﻿USE sofia;
DROP TABLE IF EXISTS sofia.kdc_vpl;
CREATE TABLE kdc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kdc_vpl WRITE;
INSERT INTO kdc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Baho haichanduso, Imulungu kalumba ulanga na isi, ");
INSERT INTO kdc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","isi ikala chakachaka na ikala yabule kinhu. Ziza dikala digubike kila hanhu mgamazi na Loho wa Imulungu kakala yenele mgamazi gose. ");
INSERT INTO kdc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Imulungu kalonga, “Hawe na mulenge,” na mulenge wiza. ");
INSERT INTO kdc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Imulungu kona mulenge unoga. Abaho Imulungu kaugola mulenge na ziza, ");
INSERT INTO kdc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","mulenge kaukema, “Imisi,” na ziza kadikema, “Ikilo.” Ikala ichungulo, ikala imitondo, siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Imulungu kalonga, “Hawe na nyafasi hagati ya mazi, igagole mazi na mazi.” ");
INSERT INTO kdc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Avo Imulungu katenda nyafasi, kagagola mazi geli uchanha na mazi geli hasi. Na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Imulungu kaikema nyafasi ayo, “Ulanga.” Ikala ichungulo, ikala imitondo, siku da kabili. ");
INSERT INTO kdc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Imulungu kalonga, “Mazi geli hasi ya ulanga gailundize hamoja ili isi inyalile yoneke.” Na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Imulungu kahakema hanhu hanyalile, “Isi,” na mazi gailundize kagakema, “Bahali.” Imulungu kona vinoga. ");
INSERT INTO kdc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Abaho Imulungu kalonga, “Isi yoteze kila aina ya minoga, mibiki na mijani, ija ilela mbeyu na ija ilela matunda ili vigendelele.” Na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Avo, isi yoteza mibiki na mijani ilelaga mbeyu mbasakanyo mbasakanyo, na ilelaga matunda mbasakanyo mbasakanyo ili vigendelele. Imulungu kona vinoga. ");
INSERT INTO kdc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ikala ichungulo, ikala imitondo, siku da kadatu. ");
INSERT INTO kdc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Abaho Imulungu kalonga, “Hawe na milenge kuulanga, iigole imisi na ikilo, ilaguse misimu ya kutambika, siku na miyaka, ");
INSERT INTO kdc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na ing'ale kuulanga na kuimwemwesela isi” Na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Avo Imulungu kalumba milenge mikulu mibili, zuwa ditawala imisi na mwezi utawala ikilo, vivija kalumba nhondo. ");
INSERT INTO kdc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Imulungu kaika milenge ayo kuulanga imwemwesele isi yose, ");
INSERT INTO kdc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","itawale imisi na ikilo, na kuugola mulenge na ziza. Imulungu kona vinoga. ");
INSERT INTO kdc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ikala ichungulo, ikala imitondo, siku da ikane. ");
INSERT INTO kdc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Imulungu kalonga, “Mazi gamemezwe vinhu vili na ugima na ulanga umemezwe ndege oguluka.” ");
INSERT INTO kdc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Avo Imulungu kalumba ming'onyo mikulu mwiibahali, na vinhu vili na ugima vikogela mgamazi na kalumba madali ga ndege wose ili vigendelele. Imulungu kona vinoga. ");
INSERT INTO kdc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Imulungu kavinogela kalonga, mwengezeke na kuimemeza ibahali na ndege wengezeke mwiisi yose. ");
INSERT INTO kdc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ikala ichungulo, ikala imitondo, siku ya itano. ");
INSERT INTO kdc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Imulungu kalonga, “Isi ilave vinhu vose vili na ugima mbasakanyo mbasakanyo, wanyama ofugigwa, wang'onyo otambala na wanyama wa kumuhulo ili vigendelele,” na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Avo Imulungu kalumba wanyama wose mbasakanyo mbasakanyo, wanyama wa kumuhulo, wanyama ofugigwa na wang'onyo otambala ili vigendelele. Imulungu kona vinoga. ");
INSERT INTO kdc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Abaho Imulungu kalonga, “Sambi tulumbe munhu yaigalile na siye kamba vitwili, yatawale somba weli mwiibahali, ndege na wanyama wose, ofugigwa na weli kumuhulo na wang'onyo wose otambala mwiisi.” ");
INSERT INTO kdc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Avo Imulungu kalumba munhu yaigalile na heyo. Kalumba mbigalo na mtwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Imulungu kalagusa moyo unogile kumwao, kalonga, “Leleni mwengezeke, mwiimemeze isi yose na kuitawala. Nowatenda mweye muwatawale somba na ndege na wang'onyo wose ogenda mwiisi.” ");
INSERT INTO kdc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Abaho Imulungu kalonga, “Loleni, nowagwaa kila mnoga mwiisi ulelaga mbeyu na kila biki dilelaga matunda geli na mbeyu mgati, vokuwa ndiya yenu. ");
INSERT INTO kdc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na wanyama wose wa mwiisi na ndege wose na wang'onyo wose otambala, vose vili na ugima, ndiya yao yokuwa mijani yose ya minoga.” Na vivo isang'hanike. ");
INSERT INTO kdc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Imulungu kalola kila kinhu kiyasang'hane na kachona kinoga ng'hani. Ikala ichungulo, ikala imitondo, siku da sita. ");
INSERT INTO kdc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Vino vivo ulanga na isi vivimambukizwe hamoja na vinhu vose vili mumo. ");
INSERT INTO kdc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Siku da saba Imulungu kakala yeshilize sang'hano yake yose yaisang'hane, avo siku dijo da saba Imulungu kabwihila. ");
INSERT INTO kdc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Imulungu kainogela siku ya saba na kaitenda ing'ale, kwavija viyeshilize sang'hano yake ya kulumba kabwihila. ");
INSERT INTO kdc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Vino vivo ulanga na isi vivilumbigwe. Kipindi acho Mndewa Imulungu viyalumbile ulanga na isi, ");
INSERT INTO kdc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","mwiisi kukala kuduhu minoga na mbeyu zotile, kwavija Mndewa Imulungu kakala hanagala mvula bule, na kukala kuduhu munhu yakalile yolima, ");
INSERT INTO kdc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","lakini mazi galawa hasi mwiisi na kudodeza isi. ");
INSERT INTO kdc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Abaho Mndewa Imulungu kasola ulongo mdodo kulawa mwiisi na muulongo awo kalumba munhu, kamuhuvila munhu ayo mhumuzi ya ugima mvizonzo va mhula yake na munhu kawa na ugima. ");
INSERT INTO kdc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Abaho Mndewa Imulungu kahanda mgunda ako Edeni, mwambu wa kudilawila zuwa, na mumo kamwika mbigalo ayo yamulumbile. ");
INSERT INTO kdc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mndewa Imulungu kahandigiza kila biki dinogile na mibiki ilelaga matunda gofaya kudigwa. Hagati ya mgunda awo kukala na biki da ugima na biki da kujuwa ganogile na gehile. ");
INSERT INTO kdc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kukala na kizanda cha mazi gokilimila mumgunda awo wa Edeni, kulawa kuko kizanda acho kiigola kuwa vizanda vine. ");
INSERT INTO kdc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Twaga da kizanda cha ichanduso dokemigwa Pishoni, chokilima kuzunguluka isi yose ya Havila, ako kuko ili zahabu. ");
INSERT INTO kdc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zahabu ya isi ayo inoga ng'hani. Kuko kuna mavuta gonung'hila goya gokemigwa bedola na mabwe ga bei ng'hulu gokemigwa shohamu. ");
INSERT INTO kdc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Twaga da kizanda cha kabili dokemigwa Gihoni, kizanda acho chokilima kuzunguluka isi yose ya Kushi. ");
INSERT INTO kdc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Twaga da kizanda cha kadatu dokemigwa Tigilisi, kizanda acho chokilima mwambu wa kudilawila zuwa wa Ashulu. Na kizanda cha ikane chokemigwa Fulate. ");
INSERT INTO kdc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Abaho Mndewa Imulungu kamwika mbigalo ayo mumgunda awo wa Edeni, yaulime na kuulola goya. ");
INSERT INTO kdc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mndewa Imulungu kamulagiza munhu ayo, “Kodaha kuja tunda da biki jojose dili mumgunda, ");
INSERT INTO kdc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","lakini matunda ga biki da kujuwa ganogile na gehile, sikuuje. Siku donda uje kofa.” ");
INSERT INTO kdc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Abaho Mndewa Imulungu kalonga, “Havinogile bule mbigalo kukala yaiyeka. Avo nomtendela miyage wa kumfaya kumtaza.” ");
INSERT INTO kdc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Avo kulawa mwiisi Mndewa Imulungu kasola ulongo kidogo, kalumba wanyama wose na ndege wose, abaho kamgalila mbigalo ija yalole vonda yawagwelele matwaga, na matwaga gayawagwee gago gakalile matwaga gao. ");
INSERT INTO kdc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Avo mbigalo ija kawagwaa matwaga wanyama wose ofugigwa na wanyama wa kumuhulo na ndege wose, lakini kuduhu hata imoja yamfaiye kumtaza. ");
INSERT INTO kdc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Abaho Mndewa Imulungu kamtenda mbigalo ayo yawase utulo, na viyakalile muutulo kamogola lubavu lwake lumoja na kuhagubika hanhu aho kwa nyama. ");
INSERT INTO kdc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na lubavu luyagomole kwa mbigalo kalutenda mtwanzi, kamgala kwa mbigalo ayo. ");
INSERT INTO kdc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Abaho mbigalo ayo kalonga, “Ona, dino zege dilawile mmizege yangu, na nyama ilawile mwiinyama yangu. Ino kokemigwa, ‘Mtwanzi,’ kwavija kalawa kwa mbigalo.” ");
INSERT INTO kdc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Lekaavo mbigalo komuleka tatake na mamake, na koilumba na mwehe wake, nao wabili awo okuwa kinhu kimoja. ");
INSERT INTO kdc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mbigalo ayo na mwehe wake wose wabili wakala mwazi, lakini hawonile kinyala bule. ");
INSERT INTO kdc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mgendela hasi kakala mvizi kubanza wanyama wose wa kumuhulo walumbigwe na Mndewa Imulungu. Avo mgendela hasi kamuuza mtwanzi ayo, “Vino Imulungu kawalongela sikumuje tunda da biki jojose dili mumgunda?” ");
INSERT INTO kdc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mtwanzi ayo kamwidika, “Todaha kuja tunda da biki jojose dili mumgunda, ");
INSERT INTO kdc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","lakini Imulungu katulongela, ‘Sikumuje matunda ga biki dili hagati ya mgunda, hebu kudikwasa, mwahatenda vivo, mofa.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mgendela hasi kamulongela mtwanzi ayo, “Hamufa bule. ");
INSERT INTO kdc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Imulungu kalonga avo kwavija kojuwa kamba mwahaja matunda ga biki dijo meso genu gogubuligwa na mokuwa kamba Imulungu, mogajuwa ganogile na gehile.” ");
INSERT INTO kdc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mtwanzi ayo viyonile matunda ga biki dijo viganogile kudigwa, na dibiki vidinogeza mgameso na kagelegeza vivinogile kuwa na nzewele, avo kakondola tunda kadija, diyagwe kamgwaa mkasano wake, na heyo vivija kadija. ");
INSERT INTO kdc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Viweshilize kuja, meso gao gagubuka, wajuwa kamba wakala mwazi. Avo wasoneleza mijani ya biki da mtini, waigubika. ");
INSERT INTO kdc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ichungulo wahulika Mndewa Imulungu kotembela mumgunda, hewo waifisa mna imibiki. ");
INSERT INTO kdc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Lakini Mndewa Imulungu kamkema imbigalo, kamuuza, “Kwa kwahi?” ");
INSERT INTO kdc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Heyo kamwidika, “Nikuhulika mumgunda, nidumba na kuifisa, kwavija nikala mwazi.” ");
INSERT INTO kdc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Imulungu kamuuza, “Nani yakulongele kukala mwazi? Vino, gweye kuja tunda dinikugomese sikuuje?” ");
INSERT INTO kdc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mbigalo ayo kamwidika, “Mtwanzi yuungwelele ng'hale na heyo hamoja ayo yangwelele tunda da biki dijo, na niye nidija.” ");
INSERT INTO kdc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Abaho Mndewa Imulungu kamuuza imtwanzi, “Habali utendile vivo?” Kamwidika, “Mgendela hasi ayo yanivizile nije.” ");
INSERT INTO kdc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Abaho Mndewa Imulungu kamulongela mgendela hasi, “Kwavija kutenda avo, gweye wiiyeka kuduwiligwa kubanza wanyama wose ofugigwa, na kubanza wanyama wose wa kumuhulo, kulawa sambi kotambala kwa inda yako, na koja timbwisi siku zose za ugima wako. ");
INSERT INTO kdc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nokutenda gweye na mtwanzi mwiihile, ulelo wako na ulelo wake oihila, heyo kokuhonda pala jako, na gweye kokiluma kisiginho chake.” ");
INSERT INTO kdc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Abaho kamulongela imtwanzi, “Nokwengezela usungu wa kulela, kwa usungu kolela wana. Komsulukila mkasano wako na heyo kokutawala.” ");
INSERT INTO kdc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Abaho kamulongela imbigalo, “Kwavija gweye kumtegeleza mwehe wako, na kuja tunda da biki dinikugomese sikuuje, kwa mbuli ayo, isi yose iduwiligwa. Kwa kulawa fuguti kopata ndiya yako, siku zose za ugima wako. ");
INSERT INTO kdc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isi yokulelela miba na misani, na gweye koja minoga ya kumuhulo. ");
INSERT INTO kdc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kwa fuguti jako kopata ndiya yako, mbaka vonda ubwele muulongo muulumbigwe, kwavija gweye kulawa mditimbwisi, avo kobwela kabili mditimbwisi.” ");
INSERT INTO kdc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu kamgwaa mwehe wake twaga da Hawa, kwavija kakala mama wa wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Abaho Mndewa Imulungu kawatendela Adamu na mwehe wake viwalo va ng'hwembe, kawavaza. ");
INSERT INTO kdc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Abaho Mndewa Imulungu kalonga, “Sambi wanhu wano waigala kamba imoja wetu na ogajuwa ganogile na gehile. Olondigwa wagomesigwe sikuwaje tunda da biki da ugima, kwavija wahaja okuwa wagima milele.” ");
INSERT INTO kdc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Avo Mndewa Imulungu kawaswaswanya mumgunda wa Edeni na kawatenda walime mwiisi iwalumbiligwe. ");
INSERT INTO kdc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Abaho kuna umwambu wa kudilawila zuwa wa mgunda awo keka wasenga wa kuulanga na sime dikwaka dikalile dozunguluka banzi zose, kuikimila nzila ilongoza kudibiki da ugima. ");
INSERT INTO kdc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Abaho Adamu kamuwasa mwehe wake, na heyo kagoga inda na kalela mwana wa kimbigalo. Hawa kalonga, “Kwa kutazigwa na Mndewa Imulungu mhata mwana wa kimbigalo.” Na heyo kamkema Kaini. ");
INSERT INTO kdc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Abaho Hawa kalela mwana iyagwe wa kimbigalo, twaga jake Abeli. Abeli kakala msusilaji, lakini Kaini kakala mulimaji. ");
INSERT INTO kdc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Siku dimoja Kaini kasola vinhu vidodo mna ivinhu viyasengile, kamulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abaho Abeli kamulavila Mndewa Imulungu nyama zinonile za ng'hondolo wa chaudele yawachinjile kulawa mna ifugo yake. Mndewa kanogezwa na Abeli hamoja na nhunza yake, ");
INSERT INTO kdc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","lakini Kaini hanogeligwe hamoja na nhunza zake. Avo Kaini kagevuzika ng'hani na kihanga chake kikala filufilu. ");
INSERT INTO kdc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Abaho Mndewa Imulungu kamulongela Kaini, “Habali kugevuzika na habali kihanga chako cha filufilu? ");
INSERT INTO kdc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Maza utendile kinhu kinogile, wahatogoligwe, lakini kwavija kutenda gehile, nzambi yokusepasepa hana ulwivi lwako, yokusulukila, lakini kolondigwa uihume.” ");
INSERT INTO kdc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Abaho Kaini kamulongela mdodo wake Abeli, “Tuchole kumgunda.” Avo viwakalile kumgunda, Kaini kamvamila ndugu yake kamkoma. ");
INSERT INTO kdc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mndewa Imulungu kamuuza Kaini, “Ndugu yako Abeli kakwahi?” Kaini kamwidika, “Niye sijuwa bule, vino niye ayo mkalizi wa ndugu yangu?” ");
INSERT INTO kdc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Abaho Mndewa kalonga, “Gweye kutenda choni? Damu ya ndugu yako yonililila kulawa mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gweye sambi kuduwiligwa mwiisi yuukala, ifonzile damu ya ndugu yako yuumkomile. ");
INSERT INTO kdc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kamba wahalima, isi honda ikulelele ndiya yoyose. Kokuwa tanga nzulule mwiisi.” ");
INSERT INTO kdc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini kamulongela Mndewa Imulungu, “Nhaguso ino ng'hulu ng'hani kumwangu, niye siidaha bule. ");
INSERT INTO kdc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lola, lelo koniwinga kulawa mwiisi inogile kutali na meso gako. Nokuwa tanga nzulule mwiisi, na munhu yoyose yahanyona kong'homa.” ");
INSERT INTO kdc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lakini Mndewa Imulungu kamwidika, “Bule! Munhu yahakukoma gweye Kaini kobwezeligwa miyanza saba.” Avo Mndewa kamwikila Kaini kilaguso cha kumzuma munhu yoyose yonda yamone sikuyamkome. ");
INSERT INTO kdc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Abaho Kaini kasegela mgameso ga Mndewa Imulungu na kakala mwiisi ikemigwe, “Nodi,” ikalile mwambu wa kudilawila zuwa wa Edeni. ");
INSERT INTO kdc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini kamuwasa mwehe wake, na imwehe kagoga inda, kamulela Henoki. Abaho Kaini kazenga buga, kadikema buga dijo twaga da imwana Henoki. ");
INSERT INTO kdc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoki kamulela Iladi, na heyo Iladi kamulela Mehuyaeli, na heyo Mehuyaeli kamulela Mesushaeli, na heyo Mesushaeli kamulela Lameki. ");
INSERT INTO kdc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki kasola wehe wabili, imoja twaga jake Ada na iyagwe twaga jake Sila. ");
INSERT INTO kdc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada kamulela Yabali, yakalile muhenga wa wanhu wakalile ofuga na okala mvibanda. ");
INSERT INTO kdc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ndugu yake kakemigwa Yubali, ayo kakala tata wa wanhu wose wakalile otowa bango na filimbi. ");
INSERT INTO kdc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila nayo kamulela Tubali Kaini, yakalile yotenda kila viya va shaba na mizuma. Lumbu jake Tubali Kaini kakala Naama. ");
INSERT INTO kdc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki kawalongela wehe zake, “Ada na Sila, nhegelezeni, tegelezeni zinilonga mweye wehe zangu. Niye nimkoma munhu imoja kwavija kandumiza, nimkoma mbwaga ayo kwavija kanilumiza. ");
INSERT INTO kdc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kamba munhu yomkoma Kaini kobwezeligwa miyanza saba, avo munhu yonikoma niye kobwezeligwa miyanza malongo saba na saba.” ");
INSERT INTO kdc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu kamuwasa kabili mwehe wake, kalela mwana wa kimbigalo, kamkema Seti, akuno kolonga, “Imulungu kangwaa mwana hanhu ha Abeli, yakomigwe na Kaini.” ");
INSERT INTO kdc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti nayo kalela mwana, twaga jake kamkema Enoshi. Kipindi acho wanhu wasonga kumtambikila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Uno awo msafa wa ulelo wa Adamu. Imulungu viyalumbile wanhu, kalumba kamba viyeli mwenyego. ");
INSERT INTO kdc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kalumba mbigalo na mtwanzi, kalagusa moyo unogile na kawakema, “Munhu.” ");
INSERT INTO kdc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu viyavikize miyaka gana na malongo madatu, kalela mwana yaigalile na heyo, twaga jake kamkema Seti. ");
INSERT INTO kdc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tangu Adamu yamulele Seti, kakala miyaka magana manane, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu viyavikize miyaka magana tisa na malongo madatu kafa. ");
INSERT INTO kdc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti viyavikize miyaka gana na tano, kamulela Enoshi. ");
INSERT INTO kdc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seti viyamulelile Enoshi, kakala yavikize miyaka magana manane na saba, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti kafa viyavikize miyaka magana tisa na longo na mibili. ");
INSERT INTO kdc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi viyavikize miyaka malongo tisa, kamulela Kenani. ");
INSERT INTO kdc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enoshi viyamulelile Kenani, kakala miyaka magana manane na tano, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi kafa viyavikize miyaka magana tisa na tano. ");
INSERT INTO kdc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani viyavikize miyaka malongo saba, kamulela Mahalaleli. ");
INSERT INTO kdc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenani viyamulelile Mahalaleli, kakala miyaka magana manane na malongo mane, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani kafa viyavikize miyaka magana tisa na longo. ");
INSERT INTO kdc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli viyavikize miyaka malongo sita na tano, kamulela Yaledi. ");
INSERT INTO kdc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleli viyamulelile Yaledi, kakala miyaka magana manane na malongo madatu, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli kafa viyavikize miyaka magana manane na malongo tisa na tano. ");
INSERT INTO kdc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi viyavikize miyaka gana na malongo sita na mbili, kamulela Henoko. ");
INSERT INTO kdc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaledi viyamulelile Henoko, kakala miyaka magana manane, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaledi kafa viyavikize miyaka magana tisa na malongo sita na mibili. ");
INSERT INTO kdc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoko viyavikize miyaka malongo sita na tano, kamulela Mesusela. ");
INSERT INTO kdc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henoko kakala koilumba na Imulungu, viyamulelile Mesusela, Henoko kakala miyaka magana madatu, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henoko kakala miyaka magana madatu na malongo sita na tano. ");
INSERT INTO kdc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoko kakala koilumba na Imulungu, abaho kapotela, kwavija Imulungu kakala yamsolile. ");
INSERT INTO kdc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mesusela viyavikize miyaka gana na malongo manane na saba, kamulela Lameki. ");
INSERT INTO kdc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mesusela viyamulelile Lameki, kakala miyaka magana saba na malongo manane na mbili, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mesusela kafa viyavikize miyaka magana tisa na malongo sita na tisa. ");
INSERT INTO kdc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki viyavikize miyaka gana na malongo manane na mbili, kamulela mwana wa kimbigalo, ");
INSERT INTO kdc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","mwana ayo kamgwaa twaga da Nuhu, kuno kolonga, “Mwana ino ayo yonda yatuhoze mizoyo mwiisang'hano yetu ndala itusang'hana kwa makono getu mwiisi iduwiligwe na Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Viyamulelile Nuhu, Lameki kakala miyaka magana matano na malongo tisa na tano, kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki kafa viyavikize miyaka magana saba na malongo saba na saba. ");
INSERT INTO kdc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu viyavikize miyaka magana matano, kawalela Shemu na Hamu na Yafeti. ");
INSERT INTO kdc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wanhu viwenele mwiisi yose na kulela wana wa kitwanzi, ");
INSERT INTO kdc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","viumbe wayagwe wa kuulanga wawona wandele awo wanoga, avo wawasola waja wawalondile na kuwa wehe zao. ");
INSERT INTO kdc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Abaho Mndewa Imulungu kalonga, “Loho yangu iwagwaa wanhu ugima honda ikale mgati ya wanhu milele, kwavija hewo wa kufa, siku zao za kukala wagima hazibanza miyaka gana na malongo mabili.” ");
INSERT INTO kdc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mzisiku azo na kumwande, kukala na mizinhu mikulu mwiisi ilawilile mbuli ya viumbe wayagwe wa kuulanga viwawasile na wandele wa wanhu. Mizinhu ayo, iyo ikalile na nguvu na ijuwigwa ng'hani baho umwaka, na ikemigwa Wanefili. ");
INSERT INTO kdc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mndewa Imulungu viyone kubanza kwa nzambi za wanhu mwiisi, na kila kiwogesa kutenda wanhu mmizoyo yao siku zose kiha, ");
INSERT INTO kdc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mndewa Imulungu kagelegeza habali kamulumba munhu mwiisi, avo kona usungu ng'hani muumoyo wake. ");
INSERT INTO kdc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mndewa Imulungu kalonga, “Nowabananga wanhu wose niwalumbile mwiisi, na vivija nowabananga wanyama na wang'onyo otambala mwiisi na ndege. Nokona usungu habali niwalumba mwiisi.” ");
INSERT INTO kdc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Lakini Nuhu kanogeligwa na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Zino azo simulizi za Nuhu na ulelo wake. Nuhu kakala munhu yotenda ganogile, na kakala munhu yelibule kitala mna iwanhu wa kipindi acho. Nuhu kakala koilumba na Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu kakala na wana wadatu wa kimbigalo, Shemu na Hamu na Yafeti. ");
INSERT INTO kdc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Isi ikala inangike mgameso ga Imulungu, isi yose imema gehile, ");
INSERT INTO kdc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Imulungu kailola isi na kayona isi yose ikala ibanangike ng'hani, kwavija kila munhu kakala kokweleleza nzila zake zihile. ");
INSERT INTO kdc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Imulungu kamulongela Nuhu, “Nowabananga wanhu wose kwavija isi imema gehile mbuli yao. Ona, nowabananga hewo hamoja na iisi! ");
INSERT INTO kdc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Avo izengele mwenyego safina kulu kwa mibiki ikemigwa Gofe. Gola magati mdisafina dijo na ukande tongo tongo kunze na mgati. ");
INSERT INTO kdc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Vino vivo vonda udizenge safina dijo, utali wake diwe makono gana na malongo madatu na ndatu na ugazi wake diwe makono malongo mabili na mbili na utali wake wa kuchola uchanha diwe makono longo na ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Zenga kiswili cha safina dijo na wike nyafasi ya nusu mkono kulawa kiswili na kukanho. Wike mulango mulubavu lwa disafina na utende makanho madatu, kanho da hasi na da kabili na da kadatu. ");
INSERT INTO kdc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Lola, nogala mazi mengi mwiisi nibanange kila kinhu kili na ugima mwiisi. Kila kinhu kili na ugima mwiisi chofa. ");
INSERT INTO kdc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Lakini notenda lagano na gweye. Kokwingila mdisafina gweye na mwehe wako na wanago na wehe zao. ");
INSERT INTO kdc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kolondigwa wingize mdisafina kila mng'onyo, wabili wabili mtwanzi na mbigalo ili wawe wagima hamoja na gweye. ");
INSERT INTO kdc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","“Kila aina ya ndege na kila aina ya wanyama na kila aina ya wang'onyo otambala mwiisi, wabili wabili okwiza kumwako ili uweke goya. ");
INSERT INTO kdc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Vivija ugale kila ndiya idigwa, wike mgati mbuli ya ndiya yako na ndiya ya hewo.” ");
INSERT INTO kdc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu katenda kila kinhu kamba viyalagizwe na Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mndewa Imulungu kamulongela Nuhu, “Ingila mdisafina gweye na wanhu wa mng'anda yako, kwavija mna iwanhu wose iwokala sambi mwiisi gweye wiiyeka ayo utenda ganogile. ");
INSERT INTO kdc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mna iwanyama odigwa sola saba saba mbigalo na mtwanzi kwa kila aina, na mna iwanyama hawadigwa sola wabili wabili mbigalo na mtwanzi kwa kila aina. ");
INSERT INTO kdc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Vivija sola ndege saba saba wa kimbigalo na wa kitwanzi kwa kila aina, ili wike mbeyu kabili mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kwavija siku saba kumwande, nogala mvula mwiisi yonda itowe siku malongo mane imisi na ikilo, na vinhu vose vili na ugima vinilumbile mwiisi vofa.” ");
INSERT INTO kdc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu katenda kila kinhu kamba viyalagizwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Kipindi mazi mengi vigezile mwiisi, Nuhu kakala na miyaka magana sita. ");
INSERT INTO kdc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu na mwehe wake na wanage na wehe zao wengila mdisafina ili wahonyeke na mazi mengi. ");
INSERT INTO kdc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Wanyama odigwa na wanyama hawadigwa na ndege na wang'onyo wose otambala mwiisi, ");
INSERT INTO kdc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","mbigalo kwa mtwanzi, wengila mdisafina hamoja na Nuhu kamba viyalagize Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Siku saba kumwande mazi mengi gasonga kuigubika isi. ");
INSERT INTO kdc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu viyakalile na miyaka magana sita, mna isiku ya longo na saba ya mwezi wa kabili, siku ayo nzasa zose za mazi zili hasi mwiisi zivuguka, na nyivi zose za mazi ga kuulanga zivuguka. ");
INSERT INTO kdc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Na mvula itowa mwiisi siku malongo mane imisi na ikilo. ");
INSERT INTO kdc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Siku didija mvula viisongile kutowa, Nuhu na mwehe wake na wanage, Shemu na Hamu na Yafeti, hamoja na wehe zao, wengila mdisafina. ");
INSERT INTO kdc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wengila hewo wenyego hamoja na aina zose za wanyama wa kumuhulo, aina zose za wanyama ofugigwa, aina zose za wang'onyo otambala na kila aina ya ndege. ");
INSERT INTO kdc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Wabili wabili wa kila aina ya vinhu vilumbigwe vili na ugima vingila mdisafina hamoja na Nuhu. ");
INSERT INTO kdc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Wanyama wengile wakala wa kitwanzi na wa kimbigalo kwa kila aina ya kinhu kilumbigwe kili na ugima kamba Mndewa Imulungu viyamulagize Nuhu. Abaho Mndewa kahinda ulwivi kukisogo cha Nuhu. ");
INSERT INTO kdc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mazi gagendelela kumema kwa kipindi cha siku malongo mane, mazi gongezeka na kwinula disafina uchanha ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mazi gongezeka ng'hani mwiisi na safina jeluka uchanha yake. ");
INSERT INTO kdc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mazi gago gakala mengi ng'hani uchanha mwiisi, gavigubika vigongo vose vitali vili mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mazi gongezeka mbaka gavigubika ivigongo utali wa makono saba. ");
INSERT INTO kdc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Vinhu vose vili na ugima mwiisi vifa, ndege na wanyama ofugigwa na wanyama wa kumuhulo na kila mng'onyo yotambala mwiisi na wanhu wose wafa. ");
INSERT INTO kdc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kila kinhu kili na mhumuzi ya ugima mwiisi inyalile kifa. ");
INSERT INTO kdc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kila kinhu kili na ugima mwiisi kifa, wanhu na wanyama na wang'onyo wose otambala na ndege wakomigwa. Nuhu yaiyeka ayo yasigale hamoja na waja yakalile nao mdisafina. ");
INSERT INTO kdc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mazi gago hagahunguke mwiisi kwa siku gana na malongo matano. ");
INSERT INTO kdc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Lakini Imulungu hamsemwile bule Nuhu na wanyama wose yakalile nao mdisafina. Avo kagala beho mwiisi na mazi gasonga kuhunguka. ");
INSERT INTO kdc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Baho nzasa za mazi geli mwiisi zihindigwa na nyivi za mazi geli kuulanga zihindigwa. Mvula ileka kutowa, ");
INSERT INTO kdc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","na mazi gagendelela kuhunguka mholemhole kwa siku gana na malongo matano. ");
INSERT INTO kdc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mna isiku ya longo na saba muumwezi wa saba, safina dima uchanha kuvigongo va Alalati. ");
INSERT INTO kdc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mazi gagendelela kuhunguka mholemhole, na siku ya ichanduso ya mwezi wa longo, nhembeti za vigongo zoneka. ");
INSERT INTO kdc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Vizibitile siku malongo mane, Nuhu kavugula zonzo diyatendile, ");
INSERT INTO kdc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kamulava kunze bondwa, kaguluka uko na uko mbaka mazi viganyalile mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Abaho Nuhu kamulava huwa yalole kamba mazi gahunguka mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Lakini kwavija mazi gakala gagubike isi yose, huwa ayo hapatile hanhu ha kwima, avo kaguluka kabwela mdisafina. Nuhu kagolosa mkono wake na kambweza huwa ayo mdisafina. ");
INSERT INTO kdc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhu kabeta siku saba ziyagwe, abaho kamulava kabili huwa iija. ");
INSERT INTO kdc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ichungulo huwa kabwela kwa Nuhu, mmulomo wake kakala yalumile lujani lwa mzeituni. Avo Nuhu kajuwa kamba mazi gakala gahunguke mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Abaho kabeta siku saba ziyagwe na kamulava huwa ayo kabili, mwanza uno huwa ayo habwelile bule. ");
INSERT INTO kdc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu viyakalile na miyaka magana sita na moja, siku da ichanduso da mwezi wa ichanduso, mazi gakala ganyalile mwiisi yose. Nuhu kagubula ingubiko ya disafina, kawegesela, kona isi ikala inyalile. ");
INSERT INTO kdc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Siku ya malongo mabili na saba ya mwezi wa kabili isi yose ikala inyalile. ");
INSERT INTO kdc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Baho Imulungu kamulongela Nuhu, ");
INSERT INTO kdc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lawa kunze mdisafina, gweye hamoja na mwehe wako na wanago na wehe zao. ");
INSERT INTO kdc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Lava kunze vinhu vose vili na ugima vikalile hamoja na gweye, ndege na wanyama na kila mng'onyo yotambala ili walele ng'hani mwiisi, ongezeke na kwenela kila hanhu mwiisi.” ");
INSERT INTO kdc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Avo Nuhu kalawa mdisafina hamoja na wanage na mwehe wake na wehe wa wanage. ");
INSERT INTO kdc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Wanyama wose na vinhu vose vili na ugima mwiisi na ndege wose na kila mng'onyo yotambala mwiisi vilawa mdisafina kamba viwengile. ");
INSERT INTO kdc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu kamzengela Mndewa upango wa kulavila nhosa. Kasola wanyama wayagwe odigwa na ndege odigwa, kamulavila Mndewa Imulungu nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kunung'hila goya kwa nhosa kumnogeza Mndewa Imulungu, na heyo kailongela mwenyego, “Honda niiduwile isi kabili mbuli gaja gowotenda wanhu, nojuwa kulawa kipindi viwakalile wabwanga magesa gao geha. Sibwelela ng'o! kabili kuvibananga vinhu vose vili na ugima kamba vinhendile. ");
INSERT INTO kdc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Isi vonda igendelele, hokuwa na msimu wa kuhanda na msimu wa kusenga, msimu wa vuke na msimu wa kihuhwe, msimu wa zuwa kali na msimu wa masika, imisi na ikilo vokuwa baho siku zose.” ");
INSERT INTO kdc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Imulungu kalagusa moyo unogile kwa Nuhu na wanage, kalonga, “Mulele wana wengi, muimemeze isi yose. ");
INSERT INTO kdc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Wanyama wose na ndege wose na wang'onyo wose otambala mwiisi na somba wose wa mwiibahali owadumba mweye. Wose wammakono genu. ");
INSERT INTO kdc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kila kinhu kili na ugima chokuwa ndiya yenu kamba viniwagwelele mijani yose na mbogamboga. Sambi nowagwaa vinhu vose. ");
INSERT INTO kdc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Lakini sikumuje nyama kuno ing'hali na damu kwavija ugima wa mwiidamu. ");
INSERT INTO kdc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Damu ya ugima wenu noilonda, noilonda damu ya kila mnyama na kila munhu. Yonda yamkome miyage noudai kumwake ugima wa munhu yamkomile. ");
INSERT INTO kdc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Munhu yonda yamkome miyage na heyo kokomigwa, kwavija munhu kalumbigwa kamba viyeli Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mweye mulele wana wengi ili mwengezeke ng'hani mwiisi yose.” ");
INSERT INTO kdc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Imulungu kamulongela Nuhu na wanage, ");
INSERT INTO kdc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sambi notenda lagano na mweye na wanhu wa ulelo wenu, ");
INSERT INTO kdc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na vose vili na ugima, ndege wose na wanyama ofugigwa na wanyama wa kumuhulo na kila kinhu kilawile mdisafina hamoja na gweye. ");
INSERT INTO kdc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kwa mbuli zino notenda lagano jangu na gweye na nolonga vino, vinhu vose vili na ugima honda nivibanange bule kabili kwa mazi mengi. Mazi mengi honda gaibanange bule isi yose kabili. ");
INSERT INTO kdc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kamba kilaguso cha lagano dino dilibule uhelelo, dinitenda na gweye na vinhu vose vili na ugima, ");
INSERT INTO kdc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","nokwika pinde jangu kuulanga, dokuwa kilaguso cha lagano jangu na isi yose. ");
INSERT INTO kdc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kipindi chochose chonda niugubike ulanga na mawingu, pinde da Imulungu dokoneka, ");
INSERT INTO kdc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nokumbuka gaja ganongile kumwako na wanyama wose, kamba mazi mengi honda gavibanange kabili vinhu vose vili na ugima. ");
INSERT INTO kdc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pinde jangu vonda dilawilile kuulanga nojona, baho nokumbuka lagano jangu dilibule uhelelo kumwangu niye na vinhu vose vili na ugima mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kino acho kilaguso cha lagano dinitenda kwa vinhu vose vili na ugima.” ");
INSERT INTO kdc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wanage Nuhu walawile mdisafina wakala Shemu na Hamu na Yafeti. Hamu kakala tata wa Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wana awo wadatu wa Nuhu wao wakalile wahenga wa wanhu wose wa mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu ayo yasongile kulima mgunda wa mizabibu. ");
INSERT INTO kdc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Viyang'wile divai, kakoligwa na kasaula viwalo vake, kawasa mwazi mkibanda chake. ");
INSERT INTO kdc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, tata wa Kanaani, viyamone tatake ka mwazi, kalawa kunze na kuwalongela ndugu zake wabili. ");
INSERT INTO kdc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Abaho Shemu na Yafeti wasola kiwalo, wakika kukisogo mmaega gao. Watembela kisengele nyuma, wengila mkibanda na kumgubika tatao, kuno vihanga vao walola kumgwazo ili sikuwamone tatao viyakalile mwazi. ");
INSERT INTO kdc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu viyalamuke na kujuwa kiyamtendele mwanage imdodo, ");
INSERT INTO kdc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kalonga, “Kanaani yaduwiligwe na Imulungu! Kokuwa mtumwa wa ndugu zake. ");
INSERT INTO kdc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yatogoligwe Mndewa Imulungu wa Shemu! Kanaani yawe mtumwa wa Shemu. ");
INSERT INTO kdc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Imulungu yamwengezele Yafeti! Ulelo wake ukale na wanhu wa Shemu! Kanaani kokuwa mtumwa wa Yafeti.” ");
INSERT INTO kdc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mazi mengi viganyalile Nuhu kakala miyaka magana madatu na malongo matano. ");
INSERT INTO kdc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhu kafa viyakalile na miyaka magana tisa na malongo matano. ");
INSERT INTO kdc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Uno awo ulelo wa wanage Nuhu, Shemu na Hamu na Yafeti. Vikishile kipindi cha mazi mengi wano wose wadatu walela wana. ");
INSERT INTO kdc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Yafeti wakala, Gomeli na Magogu na Madai na Yavani na Tubali na Mesheki na Tilasi. ");
INSERT INTO kdc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeli wakala, Ashikenazi na Lifati na Togama. ");
INSERT INTO kdc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani wakala, Elisha na Talishishi na Kitimu na Dodanimu. ");
INSERT INTO kdc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kubitila awo wanhu wa isi za mwhani wenela mziisi zao, kila wanhu na ulonzi wao na makabila gao na izing'holo zao. ");
INSERT INTO kdc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu wakala, Kushi na Misili na Putu na Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kushi wakala, Seba na Havila na Sabita na Laama na Sabiteka. Wana wa Laama wakala, Sheba na Dedani. ");
INSERT INTO kdc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi kakala na mwana yakemigwe Nimulodi, yakalile galu wa ichanduso na munhu mwene nguvu mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kakala msakaji mkulu mgameso ga Mndewa Imulungu, lekaavo wanhu olonga, “Uwe kamba Nimulodi msakaji mkulu mgameso ga Mndewa Imulungu!” ");
INSERT INTO kdc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mabuga gaichanduso ga utawala wake gakala, Babeli na Eleki na Akadi na Kaline, gose gakala mwiisi ya Shinali. ");
INSERT INTO kdc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kulawa kuko Nimulodi kachola Ashulu kazenga buga da Ninawi na Lehoboti na Kala, ");
INSERT INTO kdc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Leseni dili hagati ya Ninawi na buga kulu da Kala. ");
INSERT INTO kdc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misili kawalela Waludi na Waanami na Walehabi na Wanafutuhi, ");
INSERT INTO kdc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Wapatulusi na Wakafutoli na Wakasuluhi. Wafilisiti walawa kwa Wakasuluhi. ");
INSERT INTO kdc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani kawalela Sidoni, imwana chaudele na Heti. ");
INSERT INTO kdc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Vivija Kanaani kakala muhenga wa Wayebusi na Waamoli na Wagiligashi, ");
INSERT INTO kdc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Wahivi na Waaliki na Wasini, ");
INSERT INTO kdc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Waalivadi na Wasemali na Wahamasi. Abaho ng'holo nyingi za Wakanaani zipwililika. ");
INSERT INTO kdc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Na zimbaka za Wakanaani zisongela Sidoni kubitila nzila ya Gelali mbaka Gaza, abaho kubitila Sodoma na Gomola na Adima na Seboimu mbaka ako Lasha. ");
INSERT INTO kdc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Awo uwo ulelo wa Hamu, kamba viweli mna gamakabila gao na isi zao na ulonzi wao. ");
INSERT INTO kdc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, mkulu wa Yafeti, kalela wana. Shemu ayo muhenga wa wana wose wa Ebeli. ");
INSERT INTO kdc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu wakala, Elamu na Ashulu na Alifakisadi na Ludi na Alamu. ");
INSERT INTO kdc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Alamu wakala, Usi na Huli na Geseli na Mashi. ");
INSERT INTO kdc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alifakisadi kamulela Shela na Shela kamulela Ebeli. ");
INSERT INTO kdc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeli kakala na wana wabili, imoja kakemigwa Pelegi kwavija mna ikipindi chake wanhu wa mwiisi wakala waigolile, na mwana iyagwe kakemigwa Yokitani. ");
INSERT INTO kdc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani kawalela Alimodadi na Shelefu na Hasalimawesi na Yela, ");
INSERT INTO kdc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadolamu na Uzali na Dikila, ");
INSERT INTO kdc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obali na Abimaeli na Sheba, ");
INSERT INTO kdc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofili na Havila na Yobabu. Awo wose wakala wanage Yokitani. ");
INSERT INTO kdc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Isi iwakalile yenela kulawa Mesha mbaka Sefali kuvigongo va mwambu wa kudilawila zuwa. ");
INSERT INTO kdc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Awo uwo ulelo wa Shemu, kamba viweli mna gamakabila gao na isi zao na ulonzi wao. ");
INSERT INTO kdc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Zino azo ng'holo za wana wa Nuhu kamba viwaleligwe toka isi mbaka isi. Kubitila awo wanhu wa makabila gose wenela mwiisi yose vigeshile mazi mengi. ");
INSERT INTO kdc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Baho haichanduso wanhu wa mwiisi yose wakala olonga ulonzi umoja na mbuli zizija. ");
INSERT INTO kdc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Avo wanhu viwafungile mwanza kuchola isi za mwambu wa kudilawila zuwa wayona isi ya bawe ako Shinali, na wakala kuko. ");
INSERT INTO kdc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Avo wailongela wao kwa wao, “Amweye! Tutende matofali na tugasome moto vinogile.” Avo wakala na matofali badala ya mabwe na tongo tongo badala ya matope. ");
INSERT INTO kdc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wailongela, “Tuizengele buga na lingo donda divike mbaka kuulanga, ili tutende matwaga getu gajuwigwe na sikutupwililike mwiisi yose.” ");
INSERT INTO kdc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Abaho Mndewa Imulungu kahumuluka hasi yalole dibuga na dilingo diwakalile ozenga wanhu awo. ");
INSERT INTO kdc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mndewa Imulungu kalonga, “Wanhu wano ni wanhu wa isi imoja na olonga ulonzi umoja, na kino acho kiwosonga kutenda, avo jojose diwolonda kutenda oditenda. ");
INSERT INTO kdc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Leka tuhumuluke hasi, tukawakanganye ulonzi wao ili walemelwe kuitegeleza wao kwa wao.” ");
INSERT INTO kdc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Avo Mndewa Imulungu kawapwililisa mwiisi yose na waleka kuzenga idibuga. ");
INSERT INTO kdc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Buga dijo dikemigwa Babeli, kwavija aho Mndewa Imulungu hayawakanganye wanhu na kuwagwaa ulonzi mbasakanyo mbasakanyo na kulawa aho kawapwililisa wanhu mwiisi yose. ");
INSERT INTO kdc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Uno awo ulelo wa Shemu. Miyaka mibili vigeshile mazi mengi, Shemu viyavikize miyaka gana, kamulela Alifakisadi. ");
INSERT INTO kdc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shemu viyamulelile Alifakisadi, kakala miyaka magana matano na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alifakisadi kakala na miyaka malongo madatu na tano, kamulela Shela. ");
INSERT INTO kdc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Alifakisadi viyamulelile Shela, kakala miyaka magana mane na midatu, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela kakala na miyaka malongo madatu, kamulela Ebeli. ");
INSERT INTO kdc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shela viyamulelile Ebeli, kakala miyaka magana mane na midatu, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeli kakala na miyaka malongo madatu na nne, kamulela Pelegi. ");
INSERT INTO kdc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ebeli viyamulelile Pelegi, kakala miyaka magana mane na malongo madatu, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi viyakalile na miyaka malongo madatu, kamulela Leu. ");
INSERT INTO kdc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi viyamulelile Leu, kakala miyaka magana mabili na tisa, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu viyakalile na miyaka malongo madatu na mibili, kamulela Selugi. ");
INSERT INTO kdc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Leu viyamulelile Selugi, kakala miyaka magana mabili na saba, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selugi viyakalile na miyaka malongo madatu, kamulela Naholi. ");
INSERT INTO kdc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Selugi viyamulelile Naholi, kakala miyaka magana mabili, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi viyakalile na miyaka malongo mabili na tisa, kamulela Tela. ");
INSERT INTO kdc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naholi viyamulelile Tela, kakala na miyaka gana dimoja na longo na tisa, na kalela wana wayagwe wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela viyakalile na miyaka malongo saba, kamulela Abulamu na Naholi na Halani. ");
INSERT INTO kdc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Uno awo ulelo wa Tela, tatao Abulamu na Naholi na Halani. Halani kakala tatake Lutu. ");
INSERT INTO kdc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kipindi Tela yang'ali mgima Halani kafa ako Uli buga da Wakalidayo kuyaleleke. ");
INSERT INTO kdc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abulamu na Naholi wasola wehe. Mwehe wa Abulamu kakemigwa Salai na mwehe wa Naholi kakemigwa Milika biti Halani, vivija Halani kakala tatake Isika. ");
INSERT INTO kdc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salai kakala mgumba. ");
INSERT INTO kdc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela kamsola imwana Abulamu na imzukulu Lutu, yakalile mwanage Halani, na imukwe Salai mwehe wa Abulamu, kalawanya nao ako Uli buga da Wakalidayo, kachola na hewo mwiisi ya Kanaani, viwavikile kudibuga da Halani wakala kuko. ");
INSERT INTO kdc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela kafa ako Halani viyakalile na miyaka magana mabili na tano. ");
INSERT INTO kdc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mndewa Imulungu kamulongela Abulamu, “Segela mwiisi yako, waleke ndugu zako na ng'anda ya tatako uchole mwiisi yonda nikulagusile. ");
INSERT INTO kdc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nokutenda uwe na ulelo onda uwe kabila kulu. Nokutenda umwede na kuditenda twaga jako dijuwigwe ng'hani, na gweye kokuwa kilamuso cha wanhu wengi kumweda. ");
INSERT INTO kdc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Munhu yonda yakutendele ganogile na niye nomtendela ganogile. Lakini munhu yonda yakuduwile na niye nomduwila. Kubitila gweye nowatenda wanhu wa isi zose wamwede.” ");
INSERT INTO kdc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abulamu viyakalile na miyaka malongo saba na tano kasegela Halani, kamba viyalongeligwe na Mndewa Imulungu, na Lutu kachola hamoja na heyo. ");
INSERT INTO kdc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abulamu kamsola imwehe Salai na Lutu mwana wa ndugu yake hamoja na vinhu vao vose na wanhu wose wawapatile ako Halani. Wasegela kuchola isi ya Kanaani. Viwavikile ako, ");
INSERT INTO kdc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abulamu kabita mziisi mbaka Shekemu, hanhu hong'ala heli na biki kulu da Mole. Kipindi acho Wakanaani wao wakalile iwenekae wa isi ayo. ");
INSERT INTO kdc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ako Mndewa Imulungu kamulawilila Abulamu, kamulongela, “Ino ayo isi yonda niwagwee ulelo wako.” Abaho Abulamu kamzengela upango wa kulavila nhosa Mndewa yamulawilile. ");
INSERT INTO kdc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kulawa kuko Abulamu kasegela kachola kuvigongo mwambu wa kudilawila zuwa wa Beseli keka ng'hambi hagati ya buga da Beseli mwambu wa kudihongela zuwa na buga da Ai mwambu wa kudilawila zuwa. Kuko vivija kamzengela Mndewa Imulungu upango wa kulavila nhosa na kaditambikila twaga da Mndewa. ");
INSERT INTO kdc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abaho Abulamu kagendelela na mwanza kuchola mwambu wa Negebu ubanzi wa kusini. ");
INSERT INTO kdc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lakini kukala na lufilili lwa nzala mwiisi ayo. Avo Abulamu kachola kukala Misili, kwavija nzala ikala ng'hulu ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Viyakalile mmambwegambwega kuvika Misili, kamulongela imwehe Salai, “Nojuwa gweye kwa mtwanzi unogile na kogela lembo. ");
INSERT INTO kdc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wamisili wahakona olonga, ‘Ino mwehe wake,’ avo ong'homa na gweye okuleka mgima. ");
INSERT INTO kdc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Avo walongele gweye kwa lumbu jangu, avo mbuli ya gweye hawang'homa bule na onhenda goya.” ");
INSERT INTO kdc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abulamu viyavikile Misili, wenekae wa kuko wamona Salai kakala mtwanzi yanogile ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Wanhu weli na ukulu muundewa wa Falao viwamone Salai wamtogola ng'hani kwa mndewa Falao, avo Salai kagaligwa mng'anda ya mndewa. ");
INSERT INTO kdc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Avo, mbuli ya Salai mndewa Falao kamtendela Abulamu ganogile, na kagweleligwa ng'hondolo na ng'ombe na vihongwe mbigalo na vihongwe watwanzi na watumwa wa kimbigalo na wa kitwanzi na ngamiya. ");
INSERT INTO kdc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Lakini Mndewa Imulungu kamkoboza Falao na wanhu wose wa mng'anda yake na kawagwaa mitamu mbuli ya Salai, mwehe wake Abulamu. ");
INSERT INTO kdc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Avo Falao kamkema Abulamu, kamulongela, “Kunhenda choni gweye? Habali hunongele kamba Salai mwehe wako? ");
INSERT INTO kdc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Habali kunongela kakala lumbu jako na kundeka nimsole yawe mwehe wangu? Avo sambi, ayo baho mwehe wako, msole uhalawe hano!” ");
INSERT INTO kdc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Avo Falao kawalagiza wanhu zake, na hewo wamuleka Abulamu yasegele na mwehe wake hamoja na vinhu vake vose. ");
INSERT INTO kdc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abulamu kabwela kulawa Misili, kachola mwambu wa Negebu, kakala hamoja na mwehe wake na vinhu vake vose hamoja na Lutu. ");
INSERT INTO kdc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abulamu kakala munhu tajili ng'hani. Kakala na fugo nyingi na shaba na zahabu. ");
INSERT INTO kdc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kagendelela na mwanza wake kulawa Negebu mbaka Beseli. Kavika hanhu kuyekile ng'hambi yake aho haichanduso hagati ya Beseli na Ai, ");
INSERT INTO kdc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","aho kuyazengile upango wa kulavila nhosa. Aho kaditambikila twaga da Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lutu yakalile kokwanga hamoja na Abulamu, heyo vivija kakala na fugo na vibanda. ");
INSERT INTO kdc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Wakala na fugo nyingi mbaka isi ija ikala ndodo kwa Abulamu na Lutu kukala hamoja. ");
INSERT INTO kdc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Avo wasusilaji wa Abulamu na wasusilaji wa Lutu wasonga kugomba. Kipindi acho Wakanaani na Wapelizi awo wakalile wenekae wa isi ayo. ");
INSERT INTO kdc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abaho Abulamu kamulongela Lutu, “Niye na gweye sikutugombe hebu wasusilaji zako na wasusilaji zangu sikuwagombe kwavija niye na gweye twa ndugu. ");
INSERT INTO kdc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Avo tuigole. Sagula mwambu wowose wa isi kuulonda, wahachola mwambu wa mkono wa kumoso niye nochola mwambu wa mkono wa ukudila, wahachola mwambu wa mkono wa ukudila niye nochola mwambu wa mkono wa ukumoso.” ");
INSERT INTO kdc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutu kalola, kajona bonde da lwanda lwa Yolidani dikala dimemile mazi kila hanhu, kamba mgunda wa Mndewa Imulungu hebu kamba isi ya Misili mwambu wa Soali. Kino kikala kipindi Mndewa Imulungu yang'hali hanagabananga mabuga ga Sodoma na Gomola. ");
INSERT INTO kdc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Avo Lutu kaisagulila bonde jose da lwanda lwa Yolidani, kachola mwambu wa kudilawila zuwa. Wanhu awo wabili vivo viwaigolile. ");
INSERT INTO kdc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abulamu kasigala mwiisi ya Kanaani na Lutu kakala mna gamabuga gakalile kubonde, keka ng'hambi yake behi na Sodoma. ");
INSERT INTO kdc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wanhu wa kuko Sodoma wakala wehile na wakala omtendela Mndewa Imulungu nzambi nyingi. ");
INSERT INTO kdc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lutu viyaigolile na Abulamu, Mndewa Imulungu kamulongela Abulamu, “Aho hawili lola goya mhande zose. ");
INSERT INTO kdc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Isi yose ino yuulola, nokugwaa gweye na ulelo wako, iwe yenu milele. ");
INSERT INTO kdc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nowatenda wanhu wa ulelo wako wawe wengi mbaka munhu sikuyadahe kuwapeta, kamba vija msanga, avo kamba hana munhu kodaha kuupeta msanga baho kodaha kuwapeta wanhu wa ulelo wako. ");
INSERT INTO kdc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sambi, chola ukaikagule isi ayo yose, kwavija isi ayo yose nokugwaa gweye.” ");
INSERT INTO kdc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Avo Abulamu kahama kuing'hambi yake, kachola kukala behi na mibiki mikulu ya Mamule ako Hebuloni, na ako kamzengela Mndewa Imulungu upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kipindi acho mndewa Amulafeli wa Shinali na mndewa Alioko wa Elasali na mndewa Kedolilaomeli wa Elamu na mndewa Tidali wa Goimu, ");
INSERT INTO kdc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","wachola kuitowa na wandewa wano, mndewa Belao wa Sodoma na mndewa Bilisha wa Gomola na mndewa Shinabu wa Adima na mndewa Shemebeli wa Seboimu na mndewa wa Bela na vivija Soali. ");
INSERT INTO kdc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wandewa awo wose watano waiting'hana kubonde da Sidimu hebu bahali ya Mkele. ");
INSERT INTO kdc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kwa kipindi cha miyaka longo na mibili wakala mmakono ga mndewa Kedolilaomeli, lakini muumwaka wa longo na ndatu wambiduka. ");
INSERT INTO kdc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Muumwaka wa longo na nne, mndewa Kedolilaomeli na waja wandewa wayage weza na kuwahuma Walefai ako Ashitaloti Kalinaimu na Wazuzi ako Hamu na Waemi ako Shawe Kiliataimu, ");
INSERT INTO kdc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Waholi ako kuvigongo vao va Seili mbaka Elipalani behi na kiwala. ");
INSERT INTO kdc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Abaho wabwela kuchugu mbaka Enimishipati hebu Kadeshi, waitowa isi yose ya Waamaleki na kuwahuma na vivija wawatowa Waamoli wakalile Hazazoni Tamali. ");
INSERT INTO kdc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Abaho mndewa wa Sodoma na mndewa wa Gomola na mndewa wa Adima na mndewa Seboimu na mndewa wa Bela hebu Soali wengila kukigongo kubonde da Sidimu, ");
INSERT INTO kdc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","waitowa na Kedolilaomeli mndewa wa Elamu na Tidali mndewa wa Golimu na Amulafeli mndewa wa Shinali na Alioko mndewa wa Elasali, wandewa wane waitowa na wandewa watano. ");
INSERT INTO kdc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Bonde da Sidimu dikala dimemile masimo ga lami, avo wandewa wa Sodoma na Gomola viwakalile okimbila ing'hondo wadumbukila mumo, lakini wandewa wayagwe wasigale wakimbilila kuvigongo. ");
INSERT INTO kdc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Avo waja wahumile, wavisola vinhu vose va Sodoma na Gomola, vivija wasola ndiya zao, wasegela. ");
INSERT INTO kdc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Vivija wamgela mmakono Lutu, mwana wa ndugu yake Abulamu hamoja na vinhu vake, kwavija Lutu kakala yokala Sodoma, abaho walawanya. ");
INSERT INTO kdc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Munhu imoja yahonyeke, kamgalila usenga Abulamu yakalile Muebulania, na yakalile kokala behi na mibiki mikulu ya Mamule ya Muamoli, yakalile ndugu yake Eshikoli na Aneli, wose wakala wailumbile na Abulamu. ");
INSERT INTO kdc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abulamu viyahulike ndugu yake Lutu kageligwa mmakono, kalawa na wanhu zake wakalile magalu magana madatu na longo na nane waleleke mng'anda yake, wawakweleleza wanhu awo mbaka Dani. ");
INSERT INTO kdc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ako kawagola wanhu zake mvibumbila. Ikilo kawatowa wanhu awo, kawawinga mbaka Hoba, kasikazini ya Damesiki. ");
INSERT INTO kdc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Baho, Abulamu kavikombola vinhu vose visoligwe na wanhu awo na kamkombola Lutu ndugu yake, vinhu vake, hamoja na watwanzi na wanhu wayagwe. ");
INSERT INTO kdc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abulamu viyakalile kobwela kulawa kumtowa mndewa Kedolilaomeli na wayage, mndewa wa Sodoma kachola kuiting'hana na heyo kubonde da Shawe hebu Bonde da Mndewa. ");
INSERT INTO kdc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na heyo Melikizedeki, yakalile mndewa wa Salemu na vivija yakalile mulava nhosa wa Imulungu yeli Uchanha Ng'hani, kamgalila Abulamu gate na divai, ");
INSERT INTO kdc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","kamtambikila kwa kulonga, “Imulungu yeli Uchanha Ng'hani, yalumbile ulanga na isi, yamtendele ganogile Abulamu! ");
INSERT INTO kdc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na Imulungu yeli Uchanha Ng'hani yagweleligwe ukulu, kwa kukugwaa udahi wa kuwahuma wanhu wakwihile.” Na heyo Abulamu kamgwaa Melikizedeki kinhu kimoja mna ikila vinhu longo kwa vinhu vose viyapatile kuing'hondo. ");
INSERT INTO kdc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mndewa wa Sodoma kamulongela Abulamu, “Ngwelela niye wanhu awo, na vinhu vose avo sola gweye.” ");
INSERT INTO kdc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abulamu kamwidika mndewa wa Sodoma, “Noiduwila kwa Mndewa Imulungu, yeli Uchanha Ng'hani, yalumbile ulanga na isi, ");
INSERT INTO kdc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","sisola kinhu chako chochose, sisola hata luzi hebu luzabi lwa vilatu, Sambi uitape kwa kulonga, ‘Niye ayo nimtendile Abulamu yawe tajili’ ");
INSERT INTO kdc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Avo sisola kinhu chochose, ila nosola kiwadile wanhu zangu na kija cha wanhu wanicholile nao, Aneli na Eshikoli na Mamule, wao wana fungu mna ivinhu avo.” ");
INSERT INTO kdc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Vizibitile mbuli azo, Mndewa Imulungu kamulongela Abulamu mzinzozi, “Abulamu, sikuudumbe! Niye ayo ngao yako. Niye na hamoja na gweye, na kinhu acho kinoga ng'hani kumwako.” ");
INSERT INTO kdc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lakini Abulamu kalonga, “Go Mkulu Mndewa Imulungu, kongwaa choni na niye nabule mwana wa kuhazi na muhazi wangu ayo Eliezeli munhu wa ako Damesiki?” ");
INSERT INTO kdc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abulamu kalonga, “Lola hungwelele bule mwana, avo mtumwa yaleligwe mng'anda yangu ayo yonda yawe muhazi wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Abaho Mndewa Imulungu kamulongela, “Munhu ino honda yawe muhazi wako, lakini mwana yonda umulele mwenyego ayo yonda yawe muhazi wako.” ");
INSERT INTO kdc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Aho Mndewa Imulungu kamulava kunze Abulamu, kamulongela, “Lola uchanha upete zinhondo, kamba kweli kodaha kuzipeta. Ulelo wako okuwa kamba vizili zinhondo azo.” ");
INSERT INTO kdc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abulamu kamtogola Mndewa Imulungu na kwa mbuli ayo Mndewa Imulungu kamgesa Abulamu kamba munhu yanogile mgameso gake. ");
INSERT INTO kdc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Abaho Mndewa Imulungu kamulongela Abulamu, “Niye ayo Mndewa Imulungu nikugalile kulawa Uli, buga da Wakalidayo, ili nikugwee isi ino.” ");
INSERT INTO kdc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Lakini Abulamu kalonga, “Go Mkulu Mndewa Imulungu, nojuwaze kamba isi ino yokuwa yangu?” ");
INSERT INTO kdc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Avo Mndewa kamwidika, “Ngalila ng'ombe yeli na miyaka midatu na mbuzi wa kitwanzi yeli na miyaka midatu na ng'hondolo wa kimbigalo yeli na miyaka midatu na huwa na kinda da njiwa.” ");
INSERT INTO kdc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abulamu kamgalila Mndewa Imulungu wanyama awo, kila imoja kambalula, kavika ivihande mmisafa mibili kuno na kuno, lakini iwandege hawabalule bule. ");
INSERT INTO kdc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Jola viwezile kuna imitufi ayo, Abulamu kawawinga. ");
INSERT INTO kdc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Zuwa vidikalile dohonga, Abulamu kapata utulo kawasa, bwembwe da ziza kulu dimwizila. ");
INSERT INTO kdc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Abaho Mndewa Imulungu kamulongela Abulamu, “Ujuwe goya kamba ulelo wako okala kamba wanhu baki mwiisi ya ugeni, okuwa watumwa na odununzigwa ng'hani kwa miyaka magana mane. ");
INSERT INTO kdc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lakini nowakoboza wanhu wa isi yonda wakale muutumwa, kukimambukizo osegela mwiisi ayo iwakalile kuno wana vinhu vingi. ");
INSERT INTO kdc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Lakini gweye mwenyego kokuwa mgima kwa siku nyingi na kofa moyo hoole na kozikigwa goya. ");
INSERT INTO kdc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Vizukulu vako vilembwe vobwela hano, kwavija nzambi za Waamoli zing'hali hazinavikila kuwa nyingi avo niwataguse.” ");
INSERT INTO kdc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Viivikile ikilo, nongo ilava yosi na wenge da moto ukwaka voneka vobita hagati ya maunde ga nyama. ");
INSERT INTO kdc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Siku ayo Mndewa Imulungu kailagana na Abulamu, kalonga, “Nowagwaa isi ino wanhu wa ulelo wako, kulawa lwanda lwa Misili mbaka lwanda luja mkulu lwa Fulate, ");
INSERT INTO kdc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","hamoja na isi za Wakeni na Wakenizi na Wakadimoni, ");
INSERT INTO kdc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Wahiti na Wapelizi na Walefai, ");
INSERT INTO kdc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Waamoli na Wakanaani na Wagiligashi na Wayebusi.” ");
INSERT INTO kdc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Avo, Salai, mwehe wake Abulamu, kakala hanamulelela wana bule. Lakini kakala na mtumwa wa kitwanzi, Mmisili, twaga jake Hajili. ");
INSERT INTO kdc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Avo Salai kamulongela Abulamu, “Mndewa Imulungu kangwaa ugumba. Genda ukawase na mtumwa wangu wa kitwanzi, sengine nopata wana kubitila heyo.” Avo Abulamu katogola kiyalongile Salai. ");
INSERT INTO kdc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abaho, Salai kamsola mtumwa wake wa kitwanzi, mwenekae wa Misili, yakemigwe Hajili kamgwaa mkasano wake yamtende mwehe wake. Gago galawilila Abulamu viyakalile Kanaani kwa miyaka longo. ");
INSERT INTO kdc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abulamu kawasa na Hajili, na Hajili kagoga inda. Lakini Hajili viyagogile inda kasonga kuitapa na kumbezeli Salai. ");
INSERT INTO kdc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Abaho Salai kamulongela Abulamu, “Gweye ayo kilamuso cha niye kudununzwa. Niye nikugwaa mtumwa wangu, kwavija sambi kajuwa kana inda, kosonga kunibezeli niye. Mndewa Imulungu na yatutaguse niye na gweye!” ");
INSERT INTO kdc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Lakini Abulamu kamulongela Salai, “Mtumwa wako kammakono gako, mtendele viulonda.” Avo Salai kamdununza ng'hani Hajili mbaka kakimbila. ");
INSERT INTO kdc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Msenga wa kuulanga wa Mndewa kamvika Hajili kuinzasa ako kuluwala, ikalile hamgwazo wa nzila ya kuchola Shuli. ");
INSERT INTO kdc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Msenga ayo wa kuulanga kamuuza, “Gweye Hajili, mtumwa wa Salai, kolawa kwahi na kochola kwahi?” Hajili kamwidika, “Nomkimbila Salai inimsang'hanila.” ");
INSERT INTO kdc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Abaho msenga ayo wa Mndewa Imulungu kamulongela, “Bweleganya kwa Salai ukamtegeleze.” ");
INSERT INTO kdc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Abaho kamulongela, “Nokugwaa ulelo mkulu ng'hani mbaka wanhu olemelwa kuwapeta.” ");
INSERT INTO kdc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Abaho msenga ayo wa Mndewa Imulungu kamulongela, “Gweye kuna inda, na kolela mwana wa kimbigalo, komgwaa twaga da Ishimaeli, fambulo jake kahulika, kwavija Mndewa Imulungu kahulika kudununzwa kwako. ");
INSERT INTO kdc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Lakini mwanago kokala kamba kihongwe wa kumuhulo, hailumba na wanhu na wanhu nao hawailumba na heyo bule. Koihasanya na ndugu zake wose.” ");
INSERT INTO kdc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Avo Hajili kamgwaa Mndewa Imulungu iyalongile na heyo twaga da, “Imulungu konilola.” Kwavija kalonga, “Nimona heyo yonyona niye.” ");
INSERT INTO kdc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Lekaavo kuna sima dokemigwa Beeli Lahai Loi, fambulo jake sima da ija yeli mgima yonyona niye. Sima dijo ding'hali kuko, ako hagati ha Kadeshi na Beledi. ");
INSERT INTO kdc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Avo Hajili kamulelela Abulamu mwana wa kimbigalo, Abulamu kamgwaa mwana ayo twaga da Ishimaeli. ");
INSERT INTO kdc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hajili viyamulelile Ishimaeli, Abulamu kakala yavikize miyaka malongo manane na sita. ");
INSERT INTO kdc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abulamu viyavikize miyaka malongo tisa na tisa, Mndewa Imulungu kamulawilila, kamulongela, “Niye na Imulungu yeli na Udahi wose, nhegeleze na utende ganogile. ");
INSERT INTO kdc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na niye notenda lagano na gweye na kwengeza wanhu wa ulelo wako.” ");
INSERT INTO kdc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abulamu kafugama, kaidulika mbaka hasi. Nayo Imulungu kamulongela, ");
INSERT INTO kdc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Notenda lagano dino na gweye, nokulongela, kokuwa tata wa makabila mengi. ");
INSERT INTO kdc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kulawa sambi, twaga jako hukemigwa Abulamu, ila kokemigwa Abulahamu, kwavija nikutenda tata wa makabila mengi.” ");
INSERT INTO kdc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nokutenda uwe na ulelo mkulu, kulawa kumwako olawa wanhu wa makabila mengi na wayagwe okuwa wandewa. ");
INSERT INTO kdc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Lagano jangu na gweye na ulelo wako dabule uhelelo. Avo nokuwa Imulungu wako na Imulungu wa ulelo wako. ");
INSERT INTO kdc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nokugwaa isi ino yose ya Kanaani yuukala kamba munhu baki. Isi yose ya Kanaani yokuwa ya ulelo wako milele, na niye nokuwa Imulungu wao.” ");
INSERT INTO kdc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Abaho Imulungu kamulongela Abulahamu, “Na gweye udigoge lagano jangu, gweye mwenyego na ulelo wako na ng'holo zao. ");
INSERT INTO kdc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dino dijo lagano jangu, niye na gweye, na ulelo wako, kila mbigalo kumwenu kolondigwa yengile kumbi. ");
INSERT INTO kdc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mwingile kumbi, iwe kilaguso cha lagano jangu niye na mweye. ");
INSERT INTO kdc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kila mwana wa kimbigalo muulelo wako yahavikiza siku nane tangu kuvumbuka yengizigwe kumbi, mutende vivo kwa watumwa waleligwe mng'anda yako na watumwa waguligwe kwa sente zenu kulawa kwa wanhu baki. ");
INSERT INTO kdc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kila imoja yaleleke mng'anda yako, hebu yaguligwe kwa sente zako, yengile kumbi. Kino chokuwa kilaguso cha lagano jangu mzing'huli zenu na dino dokuwa lagano dilibule uhelelo. ");
INSERT INTO kdc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mbigalo yoyose yahaleka kwingila kumbi yabaguligwe na wanhu zake kwavija kadibena lagano jangu.” ");
INSERT INTO kdc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Abaho Imulungu kamulongela Abulahamu, “Na mwehe wako sikuumkeme Salai, kulawa sambi twaga jake Sala. ");
INSERT INTO kdc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nomtendela ganogile, kokulelela mwana wa kimbigalo. Nomtendela ganogile, kokuwa mama wa makabila mengi na wandewa wa wanhu olawa kumwake.” ");
INSERT INTO kdc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abulahamu kaidulika mbaka hasi, kakala kosekelela kuno kogelegeza, “Vino, vodahika kweli mwana kuvumbuka kulawa kwa mvele wa miyaka gana? Vino, Sala yeli na miyaka malongo tisa, kodaha kweli kulela mwana?” ");
INSERT INTO kdc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Avo, Abulahamu kamuuza Imulungu, “Habali hutogola Ishimaeli yawe muhazi wangu?” ");
INSERT INTO kdc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Lakini Imulungu kamwidika, “Bule! Mwehe wako Sala kokulelela mwana wa kimbigalo, komgwaa twaga da Isaka. Heyo na wanhu wa ulelo wake nokwika nao lagano dilibule uhelelo. ");
INSERT INTO kdc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nikuhulika viupulile mbuli ya Ishimaeli, avo nomtendela ganogile kwa kumgwaa wana wengi na ulelo mkulu. Na heyo kokuwa tata wa watawala longo na wabili na nomtenda yawe na ulelo onda uwe kabila kulu. ");
INSERT INTO kdc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Lakini lagano jangu nodika kwa Isaka, yonda yakulelele Sala aho mwakani kipindi kamba kino.” ");
INSERT INTO kdc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Imulungu viyamambukize kulonga na Abulahamu, kamuleka. ");
INSERT INTO kdc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Siku didija Abulahamu kamwingiza kumbi mwanage Ishimaeli na vivija kawengiza kumbi waja yawagulile na wambigalo wose wakalile mng'anda yake kamba viyalongeligwe na Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abulahamu viyengile kumbi kakala na miyaka malongo tisa na tisa, ");
INSERT INTO kdc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na mwanage Ishimaeli viyengile kumbi kakala na miyaka longo na ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abulahamu na mwanage Ishimaeli wengila kumbi siku dimoja, ");
INSERT INTO kdc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kengila kumbi hamoja na wambigalo wose wakalile mng'anda yake hamoja na waja waleleke mng'anda yake na waja waguligwe. ");
INSERT INTO kdc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Zuwa vidikalile dokwaka, Abulahamu kakala yakalile hana uluhelengo lwa kibanda chake. Mndewa Imulungu kamulawilila Abulahamu behi na mibiki mikulu ya Mamule, ");
INSERT INTO kdc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abulahamu viyenule kihanga chake, kawona wanhu wadatu wema. Viyawone, kawakimbilila na kaidulika mbaka hasi, ");
INSERT INTO kdc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abulahamu kalonga, “Wakulu mweye, mwahaninogela sikumumbite vivino, niye na msang'hanaji wenu. ");
INSERT INTO kdc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ndekeni niwagalile mazi ga kusunha magulu genu, humuleni hano hasi mdibiki. ");
INSERT INTO kdc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kipindi mohumula, nowagalileni ndiya kidogo muje, mpate mhamba ya kugendelela na mwanza wenu. Mweye mwa wageni zangu, ndekeni niwasang'hanile.” Nao wamwidika, “Vinoga, sang'hana kamba viulongile.” ");
INSERT INTO kdc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Avo Abulahamu himahima kengila mkibanda cha Sala, kamulongela, “Lopola, usole mhishi tano za usage unogile ng'hani, ukande, uteleke magate.” ");
INSERT INTO kdc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abaho kalopola kuchola kudibumbila da fugo yake, ako kasagula bofu dimoja da ng'ombe ditelele goya, kamgwaa mtumwa wake, na heyo kapigilika himahima. ");
INSERT INTO kdc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abaho Abulahamu kasola siagi na maziwa, na unde dipile da ng'ombe, kawatandila wageni zake. Viwakalile hasi mdibiki woja, na heyo kema behi na nao. ");
INSERT INTO kdc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Abaho waja iwageni wamuuza, “Mwehe wako Sala kakwahi?” Abulahamu kawedika, “ka Mng'anda mkibanda.” ");
INSERT INTO kdc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Abaho imoja wao kalonga, “Nobwela kumwako kipindi kamba kino mwakani, na mwehe wako Sala kolela mwana wa kimbigalo.” Sala yakalile haulwivi, kukisogo chake, kakala kotegeleza. ");
INSERT INTO kdc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abulahamu na Sala wakala wavele, na Sala kakala hatumika. ");
INSERT INTO kdc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Avo, Sala kakala koseka munda kwa munda, kalonga, “Niye namvele na mkasano wangu vivija mvele, vino nodaha kudeng'helela na kupata wana?” ");
INSERT INTO kdc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Abaho Mndewa Imulungu kamuuza Abulahamu, “Habali Sala kaseka na kuiuza kamba kodaha kulela mwana muuvele wake? ");
INSERT INTO kdc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Vino, kuna kinhu chochose hakidahika kwa Mndewa Imulungu? Kamba vinongile, nobwela mkipindi kikigwe, mwehe wako Sala kolela mwana wa kimbigalo.” ");
INSERT INTO kdc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sala kengilwa bwembwe, avo kalema kwa kulonga, “Aka, sisekile bule!” Lakini Mndewa Imulungu kamulongela, “Ona, kukala useka.” ");
INSERT INTO kdc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Wanhu awo viwenuke ili wasegela, walongoza umwambu kudili buga da Sodoma, na Abulahamu kawasindikiza muumwanza wao. ");
INSERT INTO kdc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Abaho Mndewa Imulungu kalonga, “Vino, nimfise Abulahamu kinhu kinilonda kusang'hana? ");
INSERT INTO kdc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ulelo wake okuwa kabila kulu na kubitila hewo wanhu wa makabila gose nowatendela vinhu vinogile. ");
INSERT INTO kdc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nimsagula heyo ili yawalagize wanage na ulelo wao wagoge nzila ya Mndewa Imulungu kwa kutenda gaja goyolonda Mndewa, avo Mndewa yagavikize gaja gayamulongele Abulahamu.” ");
INSERT INTO kdc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Abaho Mndewa Imulungu kamulongela Abulahamu, “Wanhu wa Sodoma na Gomola oyalaliligwa ng'hani kwavija nzambi zao zibanza. ");
INSERT INTO kdc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Avo, nochola kuko halole mwenyego, kamba gaja ganihulike gaukweli, kwavija nolonda kujuwa.” ");
INSERT INTO kdc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Avo, wanhu awo wasegela, wachola Sodoma, lakini Mndewa Imulungu kasigala na Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abaho Abulahamu kamcholela Mndewa Imulungu, kamuuza, “Vino, kweli kochola kuwakoboza wanogile hamoja na wene nzambi? ");
INSERT INTO kdc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Vino, kamba kudibuga hokuwa na wanhu wanogile malongo matano, kodikoboza buga jose? Vino, hudileka bule ili wanhu awo malongo matano wahonyeke? ");
INSERT INTO kdc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sigesa kamba kotenda vivo, kuwakoma wanhu wanogile hamoja na wanhu wene nzambi! Havidahika bule, kwavija msemi wa isi yose kolondigwa yataguse goya.” ");
INSERT INTO kdc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mndewa Imulungu kamwidika, “Kamba nahawona wanhu wanogile malongo matano mdibuga da Sodoma, mbuli ya awo nodileka buga jose.” ");
INSERT INTO kdc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abulahamu kalonga, “Chonde, niye nihonzolomoka kulonga na Mndewa hamoja niye na timbwisi na sikinhu chochose. ");
INSERT INTO kdc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Lakini kamba wanhu wanogile wahawa malongo mane na tano badala malongo matano, vino, kodikoboza buga jose kwavija wahunguka wanhu watano?” Mndewa Imulungu kamwidika, “Kamba nahawona wanhu wanogile wavika malongo mane na tano sidikoboza bule.” ");
INSERT INTO kdc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abulahamu kengeza kulonga, “Kamba okala wanhu malongo mane waiyeka.” Mndewa Imulungu kamwidika, “Mbuli ya wanhu awo wanogile malongo mane, sitenda vivo bule.” ");
INSERT INTO kdc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abulahamu kalonga, “Go, Mndewa, chonde! sikuugevuzike, nolonga kabili. Vilihi kamba okoneka wanhu wanogile malongo madatu?” Mndewa Imulungu kamwidika, kamba nahawona wao malongo madatu, sitenda vivo bule. ");
INSERT INTO kdc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abulahamu kalonga, “Chonde, gela kumgongo uhonzolomo wangu wa kulonga na gweye, Mndewa. Yokuwa vilihi kamba wahakoneka wanhu wanogile malongo mabili?” Mndewa Imulungu kamwidika, “Mbuli ya awo malongo mabili, sitenda vivo bule.” ");
INSERT INTO kdc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abaho kalonga, “Go, Mndewa, chonde! sikuugevuzike, ndeka nyengeze kulonga. Kamba okoneka wanhu wanogile longo waiyeka, yokuwa vilihi?” Mndewa Imulungu kamwidika, “Mbuli ya awo longo, sitenda vivo bule.” ");
INSERT INTO kdc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mndewa Imulungu viyeshilize kulonga na Abulahamu, kasegela, na Abulahamu kabwela ukae kumwake. ");
INSERT INTO kdc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Wasenga awo wabili wa kuulanga wavika kudibuga da Sodoma ichungulo, Lutu kakala yakalile hana ulwivi lwa dibuga da Sodoma. Viyawone, kenuka kawabokela, kaidulika mbaka hasi, ");
INSERT INTO kdc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","kalonga, “Wakulu zangu, chonde tucholeni ukae kumwangu, niye na msang'hanaji wenu. Ako mosunha magulu genu na kuwasa kumwangu kilo cha lelo, abaho imitootondo ng'hani mogendelela na mwanza wenu.” Lakini, awo walonga, “Bule, towasa baha kunze kulubuga.” ");
INSERT INTO kdc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lakini Lutu kawasusumiza ng'hani mbaka watogola na wachola na heyo ukae kumwake. Lutu kawatelekela ndiya ya magate gelibule hamila, na hewo wagaja. ");
INSERT INTO kdc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Wang'hali hawanawasa, wambigalo wose wa buga da Sodoma, wabwanga kwa wavele waizunguluka ing'anda ya Lutu. ");
INSERT INTO kdc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wamkema Lutu, wamuuza, “Wakwahi wambigalo wezile kumwako? Walave kunze. Tolonda kuwawasa!” ");
INSERT INTO kdc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lutu kalawa kunze na kuhinda ulwivi kukisogo chake. ");
INSERT INTO kdc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kawalongela, “Mbwiga zangu, chonde, sikumutende kinhu kihile kamba acho! ");
INSERT INTO kdc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Loleni, nina wandele wabili wang'hali wali. Ndekeni niwagalile wandele awo muwatende vimulonda. Lakini sikumuwatendele kinhu chochose wambigalo wano, kwavija wano wageni zangu.” ");
INSERT INTO kdc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Lakini awo walonga, “Ndoko! Gweye kwa zinhu da kutali, na sambi koitenda kwa msemi! Tokutendela kinhu kihile ng'hani kubanza awo iwageni zako.” Wagangamala kumsung'ha Lutu mbaka walonda kubena ulwivi. ");
INSERT INTO kdc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lakini wanhu awo wakalile mng'anda wagolosa makono gao, wamsung'hila Lutu mng'anda na kuhinda ulwivi. ");
INSERT INTO kdc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Abaho wawagela usuwameso wambigalo wose wakalile kunze hana ulwivi, wakulu kwa wadodo, avo hawaluwone ulwivi. ");
INSERT INTO kdc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wanhu waja wabili wamulongela Lutu, “Vino, kunayo munhu yoyose iyagwe hano, sengine wanago, wakwe zako, hebu ndugu wayagwe iwokala kudibuga dino? Wasegese hano, ");
INSERT INTO kdc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","todibananga buga dino kwavija Mndewa Imulungu kahulika wanhu viwoiyalala mbuli ya wanhu wano, na heyo katutuma twize kudibananga.” ");
INSERT INTO kdc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Abaho Lutu kawacholela iwakwe, walondile kusola wanage kawalongela, “Amweye, lopoleni kuhalawa hanhu hano, Mndewa Imulungu kohabananga.” Lakini iwakwe wagesa kakala kowageweza. ");
INSERT INTO kdc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Usiku viuchile wasenga awo wa kuulanga wawamba kumulongela Lutu, “Lopola! Msole mwehe wako na wandele zako wabili weli hano, ili buga dahabanangigwa sikumufe.” ");
INSERT INTO kdc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lutu kakala konyawanyawa. Lakini Mndewa Imulungu kamonela bazi. Wasenga awo wa kuulanga wamgoga makono gake na makono ga mwehe wake na makono ga wandele zake wabili, wawalongoza goya kulawa kudibuga dija. ");
INSERT INTO kdc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Viwawalavile kunze, msenga imoja wa kuulanga kawalongela, “Kimbileni muuhonye ugima wenu! Sikumulole kukisogo na sikumwime hanhu hohose kubonde. Kimbileni kuvigongo, sikumufe.” ");
INSERT INTO kdc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lakini Lutu kawalongela, “Bule, wakulu zangu. ");
INSERT INTO kdc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Niye na msang'hanaji wenu munyona nofaya ng'hani, munyonela bazi ng'hani kwa kuuhonya ugima wangu. Lakini sidaha bule kukimbila mbaka kuna ivigongo, zumozumo dino domvika ning'hali sinavika kuko, na niye nofa. ");
INSERT INTO kdc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mojona buga dija? Hadili kutali bule. Ndekeni ng'himbilile kuja, dokoneka buga dodo lakini kuko konda nihonyeke.” ");
INSERT INTO kdc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Na heyo kamwidika, “Ona, nhogola. Buga dija sidibananga bule. ");
INSERT INTO kdc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Lopola kukimbila! Sidaha kutenda kinhu chochose mbaka vonda uvike kuko.” Lekaavo buga dijo dikemigwa Soali, fambulo jake dodo. ");
INSERT INTO kdc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lutu viyavikile Soali, zuwa dikala dikunguzuke. ");
INSERT INTO kdc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Bahaja kulawa kuulanga Mndewa Imulungu kahumulusa mabwe gokwaka moto mgamabuga ga Sodoma na Gomola, ");
INSERT INTO kdc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","kagabananga mabuga gago, bonde jose, na wenekae wose na minoga yose yotile mwiisi. ");
INSERT INTO kdc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lakini mwehe wake Lutu kalola kukisogo na kagaluka dibwe da mkele. ");
INSERT INTO kdc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Imitondo iyagwe, Abulahamu kalopola kuchola hanhu haemile haulongozi ha Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kalola hasi mwambu wa Sodoma na Gomola, kubonde jose kona yosi dofililika mwiisi. Yosi dijo diigala na yosi dilawa mdibiwi kulu dikwaka. ");
INSERT INTO kdc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Avo Mndewa Imulungu viyagabanange mabuga geli kubonde kuyakalile Lutu, kamgesa Abulahamu na katogola Lutu yahonyeke. ");
INSERT INTO kdc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kwavija Lutu kakala kodumba kukala kudibuga da Soali, kasegela heyo hamoja na wandele zake wabili, kachola kuvigongo ako kakala kuimhango. ");
INSERT INTO kdc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Siku dimoja, mndele imkulu kamulongela imdodo, “Lola, tataetu mvele na kuno kutukala kuduhu mbigalo wa kutuwasa kamba viwotenda wanhu wose mwiisi ili na siye tupate wana. ");
INSERT INTO kdc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Leka, tumgwee tataetu divai yang'we yakoligwe, abaho tuwase na heyo na tulele nayo wana.” ");
INSERT INTO kdc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ikilo wamgwaa tatao divai, na mndele ija imkulu kawasa nayo. Lakini tatake hajuwile bule kwavija kakala yakoligwe ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Imitondo iyagwe mwana imkulu kamulongela imdodo, “Jana ikilo niwasa na tata, na lelo leka tumgwee divai yakoligwe, abaho na gweye ukawase nayo avo wose tulele na tataetu.” ");
INSERT INTO kdc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Avo kilo acho, wamgwaa tatao divai, kakoligwa, abaho mndele ija imdodo kawasa nayo, lakini tatake hajuwile bule. ");
INSERT INTO kdc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Avo, wandele wose wabili wagoga inda, waipatile kwa tatao. ");
INSERT INTO kdc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ija imndele imkulu kalela mwana wa kimbigalo, twaga jake kamkema Moabi, heyo ayo imuhenga wa Wamoabu mbaka sambi. ");
INSERT INTO kdc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Na mndele imdodo vivija kalela mwana wa kimbigalo, twaga jake kamkema Benami. Heyo ayo imuhenga wa Waamoni mbaka sambi. ");
INSERT INTO kdc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kulawa Mamule, Abulahamu kafunga mwanza kachola mwiisi ya Negebu, keka ukazi wake hagati ya Kadeshi na Shuli. Abaho kakala kidogo ako Gelali. ");
INSERT INTO kdc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ako kawalongela wanhu kamba Sala kakala lumbu jake. Avo mndewa Abimeleki wa Gelali kamsola Sala. ");
INSERT INTO kdc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Lakini ikilo Mndewa Imulungu kamulawila Abimeleki mwiinzozi, kamulongela, “Gweye kofa kwavija mtwanzi yuumsolile kasoligwa.” ");
INSERT INTO kdc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Lakini Abimeleki kakala yang'hali hanawasa na Sala bule, avo kalonga, “Vino Mndewa, kowakoma wanhu welibule gehile? ");
INSERT INTO kdc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abulahamu mwenyego iyo yalongile kamba Sala kakala lumbu jake na Sala vivija kalonga Abulahamu kakala lumbu jake. Niye nhenda avo moyo kwatu! Sitendile dihile bule.” ");
INSERT INTO kdc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mwiinzozi ayo, Imulungu kamulongela, “Ona, nojuwa viutendile vivo kukala moyo kwatu, na niye iyo nikutendile sikuutende nzambi, lekaavo nikugomesa sikuuwase nayo mtwanzi ayo. ");
INSERT INTO kdc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sambi mbweze mtwanzi ayo kwa mkasano wake. Abulahamu ni mtula ndagu wangu, avo kokupulila sambi ufe. Lakini kamba humbweza bule, nokuzuma, gweye na wanhu zako wose mofa.” ");
INSERT INTO kdc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Avo, imitondo yake, Abimeleki kawakema wasang'hanaji zake wose na kuwapetela viyalotile, na wao wadumba ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abaho Abimeleki kamkema Abulahamu, kamuuza, “Gweye, kunhendela choni? Nikutenda choni mbaka kutenda toneke tubananga niye na wanhu wa undewa wangu? Kuduhu munhu yotenda viunhendele gweye.” ");
INSERT INTO kdc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki kamuuza Abulahamu, “Vino, kilamuso cha kutenda vino choni?” ");
INSERT INTO kdc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abulahamu kamwidika, “Niye nigesa kuwa hanhu hano kuduhu munhu yomdumba Imulungu, avo wahang'homile ili wamsole mwehe wangu. ");
INSERT INTO kdc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ukweli heyo ni lumbu jangu, tuleleka tata imoja kila imoja na mamake, lekaavo nimsola. ");
INSERT INTO kdc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Avo Imulungu viyanhendile ndeke ng'anda ya tatangu na kuchola isi ya kutali, nimulongela mwehe wangu, ‘Kulagusa unogelwa wako kumwangu, kokose konda tuchole, walongele wanhu niye na lumbu jako.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abaho Abimeleki kambwezela Abulahamu imwehe Sala, kamgwaa na ng'hondolo, ng'ombe na watumwa wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki kamulongela Abulahamu, “Lola, isi yose ino yangu, kala kokose kuulonda.” ");
INSERT INTO kdc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abaho kamulongela Sala, “Nomgwaa lumbu jako magana kwa magana ga sente ili kulagusa kwa wanhu zako kamba gweye kwabule ubananzi, kila munhu kojuwa kamba hutendile mbuli yoyose ihile.” ");
INSERT INTO kdc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abaho Abulahamu kampula Imulungu, nayo kamuhonya Abimeleki na mwehe wake na watumwa zake wa kitwanzi avo wadaha kulela wana kabili, ");
INSERT INTO kdc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kwavija Mndewa Imulungu kakala yawatendile watwanzi wose mng'anda ya Abimeleki sikuwalele wana mbuli ya Sala. ");
INSERT INTO kdc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mndewa Imulungu kamnogela Sala, katenda gaja gayalongile. ");
INSERT INTO kdc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Mna ikipindi kikija kiyalongile Imulungu, muuvele wake Abulahamu, Sala kagoga inda, kamulelela mwana wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abulahamu kamgwaa mwana ayo yamulelile Sala twaga da Isaka. ");
INSERT INTO kdc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kamba viyalagizwe na Imulungu, Isaka viyavikize siku nane toka kuvumbuka kamwigiza kumbi. ");
INSERT INTO kdc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abulahamu kakala na miyaka gana Isaka viyaleleke. ");
INSERT INTO kdc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Avo Sala kalonga, “Imulungu kangalila daba na munhu yoyose yonda yahulike mbuli ino koseka na niye.” ");
INSERT INTO kdc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Abaho kengeza kulonga, “Nani yahamulongele Abulahamu kamba Sala yahakong'heze mwana? Lakini muuvele wake nimulelela mwana wa kimbigalo.” ");
INSERT INTO kdc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Imwana viyakulile kalekeswa tombo. Siku da kulekeswa tombo imwana, Abulahamu katenda nyimwilinyimwili ng'hulu. ");
INSERT INTO kdc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Siku dimoja Ishimaeli, mwanage Abulahamu yaleligwe na Hajili, Mmisili, kakala koseka. ");
INSERT INTO kdc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sala viyawone, kamulongela Abulahamu, “Muwinge kutali mtumwa ino na mwanage, kwavija havidahika mwana wa mtumwa ino yahazi hamoja na mwanangu Isaka.” ");
INSERT INTO kdc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mbuli ino imgaza ng'hani Abulahamu kwavija vivija Ishimaeli kakala mwanage. ");
INSERT INTO kdc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Lakini Imulungu kamulongela, “Sikuulumile moyo mbuli ya mwana ayo hebu mtumwa wako Hajili. Togola mbuli yoyose iyokulongela Sala kwavija gweye kopata ulelo kubitila Isaka kamba vinikulongele. ");
INSERT INTO kdc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Vivija imwana wa mtumwa, nomtenda yawe na ulelo onda uwe kabila kwavija heyo vivija mwanago.” ");
INSERT INTO kdc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Imitondo iyagwe, Abulahamu kasola ndiya na nongo ya mazi kamgwaa Hajili. Kamdikwa mmaega gake, abaho kamuwinga heyo na mwanage. Hajili kasegela, kakala kowegela kuluwala lwa Beelisheba. ");
INSERT INTO kdc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Gamazi vigeshile mwiinongo yake, Hajili kamtambaliza mwanage mkisolo, ");
INSERT INTO kdc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","abaho kakala hasi, utali wa magulu gana. Kalonga munda kwa munda, “Sidaha kulola mwanangu viyofa.” Na viyakalile aho, kasonga kulila. ");
INSERT INTO kdc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Imulungu kahulika viyolila imwana, na msenga wa kuulanga kamkema Hajili, kamulongela, “Hajili, kilamuso choni? Sikuudumbe, Imulungu kahulika kililo cha mwanago ako kuyeli. ");
INSERT INTO kdc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mwinule mwanago umgoge mkono, kwavija nomtenda yawe na ulelo onda uwe kabila kulu.” ");
INSERT INTO kdc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Imulungu kamgubula Hajili gameso, kajona sima da mazi. Kachola kamemeza mazi inongo, kamgwaa mwanage yang'we. ");
INSERT INTO kdc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Imulungu kakala hamoja na mwana ayo, viyakalile kokula. Kakala kuluwala na kakala galu wa kupigisa migoha kwa upinde. ");
INSERT INTO kdc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Viyakalile kokala kuluwala lwa Palani, mamake kamsolela mtwanzi wa Kimisili yawe mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kipindi acho, Abimeleki hamoja na Fikoli, mkulu wa wakalizi wake, kamulongela Abulahamu, “Kila kinhu kiutenda Imulungu kahamoja na gweye. ");
INSERT INTO kdc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lelo, niduwile kwa Imulungu honda umvizile niye, hebu wanangu, hebu lukolo lwangu. Kamba niye vinhendile ganogile kumwako na gweye unhendele vivo, hamoja na isi yuukala.” ");
INSERT INTO kdc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abulahamu kalonga, “Noiduwila.” ");
INSERT INTO kdc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abulahamu kakala yamuyalalile Abimeleki mbuli ya sima diyabokigwe na wasang'hanaji zake Abimeleki. ");
INSERT INTO kdc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki kamulongela, “Niye simjuwile bule munhu yatendile vivo, na gweye hunongele bule mbuli ino, niihulika sambi.” ");
INSERT INTO kdc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abaho Abulahamu kamgwaa Abimeleki ng'hondolo na ng'ombe, wanhu awo wabili watenda lagano. ");
INSERT INTO kdc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abulahamu kawabagula ng'hondolo saba wa kitwanzi, ");
INSERT INTO kdc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki kamuuza Abulahamu, “Habali kowabagula ng'hondolo wano saba wa kitwanzi?” ");
INSERT INTO kdc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abulahamu kamwidika, “Bokela ng'hondolo wano saba wa kitwanzi kulawa mmakono gangu kamba usindila kamba niye iyo nihimbile sima dino.” ");
INSERT INTO kdc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Avo hanhu haja hakemigwa Beelisheba, fambulo jake sima da kuiduwila, kwavija hanhu aho wanhu awo wabili aho hawatendile lagano jao. ");
INSERT INTO kdc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Viwailumbile ako Beelisheba, Abimeleki na Fikoli, mkulu wa wakalizi wake, kabwela mwiisi ya Wafilisiti. ");
INSERT INTO kdc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abaho Abulahamu kahanda biki dikemigwa tamalisiki ako Beelisheba, kamgwaa ukulu Mndewa Imulungu, Imulungu yelibule uhelelo. ");
INSERT INTO kdc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abulahamu kakala ng'hani mwiisi ya Wafilisiti. ");
INSERT INTO kdc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ako kumwande, Imulungu kamgeza Abulahamu, kamkema, “Abulahamu!” Abulahamu kamwidika, “Nabaha!” ");
INSERT INTO kdc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Imulungu kamulongela, “Msole mwanago Isaka, yuumnogela ng'hani, uchole mwiisi ya Molia, ukamulave nhosa ya kusoma moto kulugongo londa nikulagusile.” ");
INSERT INTO kdc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Imitondo yake, Abulahamu kaidamuka, kamtanda kihongwe wake. Kawasola wasang'hanaji zake wabili na imwana Isaka. Viyamambukize kukanha ngodi za kusomela inhosa, kafunga mwanza wa kuchola hanhu kuyalongeligwe na Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Siku da kadatu Abulahamu kenula kihanga chake kahona hanhu aho kwa kutali. ");
INSERT INTO kdc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abaho kawalongela wasang'hanaji zake, “Kaleni hano na ikihongwe, niye na mwanangu tochola haja kumtambikila Imulungu abaho towabwelela.” ");
INSERT INTO kdc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abulahamu kamdikwa Isaka ngodi za kusomela nhosa, na heyo mwenyego kasola moto na mwele. Wachola hamoja, ");
INSERT INTO kdc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka kalonga, “Agweye tata!” Tatake kamwidika, “Kolongaze mwanangu?” Isaka kamulongela, “Moto na ngodi za baha lakini ing'hondolo wa nhosa kakwahi?” ");
INSERT INTO kdc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abulahamu kamwidika, “Mwanangu, Imulungu mwenyego iyo yonda yatugwelele.” Avo wose wabili wagendelela na mwanza wao. ");
INSERT INTO kdc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Viwavikile hanhu kuyalongeligwe na Imulungu, Abulahamu kazenga upango wa kulavila nhosa na uchanha keka ngodi. Abaho kamgodeka imwana, kamtambaliza muupango wa nhosa, mna zingodi. ");
INSERT INTO kdc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abaho kagolosa umkono, kasola mwele yamchinje imwana. ");
INSERT INTO kdc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Lakini msenga wa kuulanga wa Mndewa kamkema, “Abulahamu! Abulahamu!” Abulahamu kamwidika, “Nabaha.” ");
INSERT INTO kdc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kamulongela, “Sikuumulumize imwana. Sambi nojuwa komdumba Imulungu, kwavija hugomese bule mwanago yuumnogela.” ");
INSERT INTO kdc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abulahamu kahinduka, kona ng'hondolo wa kimbigalo, mhembe zake zangama mkisolo. Avo kachola kumsola ing'hondolo, kamulava nhosa ya kusoma moto hanhu ha mwanage. ");
INSERT INTO kdc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Avo Abulahamu kahakema hanhu aho, “Mndewa Imulungu kogola.” Kamba wanhu viwolonga mbaka lelo, “Kulugongo lwa Mndewa Imulungu wanhu ogweleligwa.” ");
INSERT INTO kdc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Msenga wa Mndewa kamkema kabili Abulahamu, ");
INSERT INTO kdc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kalonga, “Mndewa Imulungu kolonga vino, ‘Noiduwila mwenyego, kwavija kusang'hana vino na hugomese mwanago yeli yaiyeka yuulelile na Sala, ");
INSERT INTO kdc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nokutenda umwede na kuutenda ulelo wako uwe kamba nhondo za kuulanga na kamba msanga wa mwhani. Ulelo wako osola isi za wanhu wawehile, ");
INSERT INTO kdc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","na kubitila ulelo wako wanhu wa makabila gose omweda kwavija kunhegeleza niye.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abulahamu kabwela kwa wasang'hanaji zake, kachola nao Beelisheba, kakala kuko. ");
INSERT INTO kdc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ako kumwande Abulahamu kahulika kamba Milika kamulelela wana Naholi, ndugu yake. ");
INSERT INTO kdc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usi mwana wa chaudele na Buzi ndugu yake, na Kemueli tatake Alamu, ");
INSERT INTO kdc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi na Hazo na Pilidashi na Yidilafu na Besueli, ");
INSERT INTO kdc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Besueli kamulela Lebeka. Milika kamulelela Naholi, ndugu yake Abulahamu, wana wanane. ");
INSERT INTO kdc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mtumwa wa kitwanzi, yakalile kamba mwehe wake yakemigwe Leuma, vivija kamulelela wana, Teba na Gahamu na Tahashi na Maaka. ");
INSERT INTO kdc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala kakala na miyaka gana na malongo mabili na saba. ");
INSERT INTO kdc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kafa ako kudibuga da Kiliati Aliba vivija dokemigwa Hebuloni mwiisi ya Kanaani, Abulahamu kamulilila na kamwikila tanga. ");
INSERT INTO kdc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abulahamu kaluleka lukuli lwa mwehe wake, kachola kulonga na Wahiti, kawalongela, ");
INSERT INTO kdc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Niye kumwenu na munhu baki. Ngweleleni hanhu nimzikile mwehe wangu na hawe hanhu ha kuzikila wanhu zangu.” ");
INSERT INTO kdc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahiti wamwidika Abulahamu, ");
INSERT INTO kdc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Go mkulu, tutegeleze. Gweye kwa munhu mkulu usaguligwe na Imulungu. Mzike mwehe wako kudipanga dinogile ng'hani. Kila munhu kumwetu kodeng'helela kukugwaa mhango ili umzike mwehe wako na hawe hanhu ha kuzikila wanhu zako.” ");
INSERT INTO kdc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Baho Abulahamu kafugama na kuidulika haulongozi wa Wahiti. ");
INSERT INTO kdc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kawalongela, “Kamba monhogolela nimzike baha mwehe wangu, chonde, mpuleni Efuloni mwanage Sohali, mbuli ya niye, ");
INSERT INTO kdc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nimgwee sente nigule mhango yake ya Makipela, ili kuimbaka ya mgunda wake. Mpuleni nimgwee sente ilondigwa, bahano mgameso genu ili nihatende hanhu ha kuzikila.” ");
INSERT INTO kdc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efuloni mwenyego kakala yakalile hamoja na Wahiti wayage wakalile waiting'hane hana ulwivi lwa dibuga, mgameso gao kamwidika, ");
INSERT INTO kdc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Go mkulu bule sichuuza, nokugwaa mgunda wose hamoja na imhango ili mumo. Nokugwaa mgameso ga wanhu zangu ili umzike mwehe wako.” ");
INSERT INTO kdc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abulahamu kawadulikila kabili Wahiti, ");
INSERT INTO kdc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kamulongela Efuloni mgameso gao, “Chonde, tegeleza nokupula. Nogula mgunda wose. Togola nilave fungu, mumo nomzika mwehe wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuloni kamwidika, ");
INSERT INTO kdc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Go mkulu, mgunda ouzigwa kwa kilo nne za shaba, kumwangu niye na gweye hana choni? Mzike mwehe wako.” ");
INSERT INTO kdc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abulahamu katogola, mgameso ga Wahiti kamgwaa Efuloni fungu diyalongile, dikala kilo nne za shaba, vivo wakalile ouza wachuuzi wa kipindi acho. ");
INSERT INTO kdc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Avo mgunda wose wa Efuloni ukalile ako Makipela mwambu wa Mamule, ndio kulonga mgunda na mhango na mibiki yose ikalile mzimbaka, vose avo vikala va Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Wahiti wose wakalile hana ulwivi lwa dibuga wakala wajuwile kamba vinhu vose vikala va Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Avo Abulahamu kamzika imwehe Sala mwiimhango ikalile mumgunda wa Makipela behi na Mamule uli Hebuloni mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Avo mgunda ukalile wa Wahiti na mhango ili mumo isoligwa na Abulahamu hawe hanhu ha kuzikila. ");
INSERT INTO kdc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Avo, Abulahamu kakala mvele ng'hani, na Mndewa Imulungu kakala yamtendele vinhu vingi vinogile. ");
INSERT INTO kdc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Avo kamulongela msang'hanaji wake yakalile mvele kubanza wose, yakalile yololesa vinhu vake, “Chonde ingiza mkono wako mna gamaungo gangu madeke kamba kilaguso na uiduwile kwa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nokulonda uiduwile kwa Mndewa Imulungu, Imulungu wa kuulanga na mwiisi, kamba honda umsolele mwehe mwanangu kulawa kwa wandele wa Wakanaani onikala nao hano. ");
INSERT INTO kdc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ubwele mwiisi inileleke kulawa kwa ndugu zangu umsolele mwehe mwanangu Isaka.” ");
INSERT INTO kdc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Msang'hanaji wake kamuuza, “Yokuwa vilihi kamba mndele ayo yahalema kwiza na niye mwiisi ino? Avo nimbweze mwanago mwiisi yuulawile?” ");
INSERT INTO kdc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abulahamu kamwidika, “Bule, sikuumbweze mwanangu kuko! ");
INSERT INTO kdc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mndewa Imulungu, Imulungu wa kuulanga, kandava mwiikae ya tatangu na mwiisi indeleke, kaiduwila kumwangu kamba kowagwaa isi ino ulelo wangu. Komtuma msenga wake wa kuulanga yakulongolele, ili umgalile mwanangu mwehe kulawa kuko. ");
INSERT INTO kdc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kamba mndele ayo yahalema kwiza na gweye, kuiduwila kwangu kumwako kokuhonya. Lakini vovose vonda iwe sikuumbweze mwanangu kuko.” ");
INSERT INTO kdc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Avo msang'hanaji ija kengiza mkono wake mna gamaungo madeke ga imkulu wake Abulahamu, kaiduwila kamba kotenda kamba viyalondile Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Abaho msang'hanaji ayo kawasola ngamiya longo wa mkulu wake, kasegela, kachola na vinhu vingi vinogile. Kachola kudibuga diyakalile Naholi, mwiisi ya Mesopotamia. ");
INSERT INTO kdc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Viyavikile, kawafugamiza iwangamiya kudisima dikalile kunze ya buga dija. Ikala ichungulo, kipindi cha watwanzi kwiza kudeha mazi. ");
INSERT INTO kdc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nayo kampula Imulungu, “Go Mndewa Imulungu wa mkulu wangu Abulahamu, nokupula unitaze lelo na umonele bazi mkulu wangu Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lola, nahano hamgwazo wa sima kuwezaga kudeha mazi wandele wa kudibuga. ");
INSERT INTO kdc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nahamulongela mndele, ‘Chonde nenula nongo yako ungwee mazi ga kung'wa’ Yahalonga, ‘Ing'wa, na vivija nowang'weza ngamiya wako’ Yawe ija yuumsagulile msang'hanaji wako Isaka. Kwa mbuli ino nojuwa kumonela bazi mkulu wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Yang'hali hanakwishiliza kumpula Imulungu, Lebeka, mndele wa Besueli, mwanage Milika, mwehe wake Naholi, ndugu yake Abulahamu, kavika kuno kapapa nongo yake mdiega. ");
INSERT INTO kdc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mndele ayo kakala yanogile ng'hani, kakala mhambe, hatembele na mbigalo yoyose. Kachola kudisima, kamemeza mazi nongo yake na kubwela. ");
INSERT INTO kdc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Msang'hanaji ayo kalopola kuiting'hana nayo, kamulongela, “Chonde, ngwaa mazi ga kung'wa muinongo yako.” ");
INSERT INTO kdc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mndele ayo kamwidika, “Ing'wa mkulu wangu,” Bahaja kanenula nongo yake, kaigogeleza kamng'weza. ");
INSERT INTO kdc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Viyamambukize kumng'weza mazi, kamulongela, “Vivija nowadehela mazi ngamiya wako, mbaka vonda wamambukize kung'wa.” ");
INSERT INTO kdc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Avo kalopola kagida gamazi mna ikiya cha kung'wela wanyama, kakimbila kudisima kadeha mazi gayagwe na kuwang'weza ngamiya wake wose. ");
INSERT INTO kdc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Munhu ija kakala komulola goya, halongile mbuli bule, kalonda yajuwe kamba Mndewa Imulungu kaunogela mwanza wake. ");
INSERT INTO kdc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamiya viwamambukize kung'wa gamazi, munhu ija kasola pete ya zahabu ya bei ng'hulu, kampasika muimhula yake na kamvaza mmakono gake bangili mbili za zahabu za bei ng'hulu. ");
INSERT INTO kdc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Abaho kamuuza, “Gweye mndele wa nani? Chonde nongela, ukae kumwenu kuna gati da kuwasa?” ");
INSERT INTO kdc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mndele ija kamwidika, “Niye na mndele wa Besueli, mwanage Milika mwehe wa Naholi.” ");
INSERT INTO kdc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kalonga, “Kumwetu kuna hanhu ha kuwasa wageni, na vivija mijani ya kudimila ngamiya wenu imema.” ");
INSERT INTO kdc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Baho munhu ija kafugama, kamtambikila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kalonga, “Yatogoligwe Mndewa Imulungu, Imulungu wa mkulu wangu Abulahamu, ija haisemwile bazi jake na gaja gayalongile kwa mkulu wangu. Na niye, Mndewa Imulungu kanilongoza muumwanza wangu kuing'anda ya iwandugu wa mkulu wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mndele ija kakimbila kuing'anda ya mamake na kawasimulila gose. ");
INSERT INTO kdc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebeka kakala na lumbu jake yakemigwe Labani. Labani kalopola kuiting'hana na munhu ija kudisima. ");
INSERT INTO kdc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labani viyayonile ija ipete na bangili mmakono ga lumbu jake na viyahulike mbuli ziyalongeligwe Lebeka na munhu ayo, kamcholela munhu ayo, kamvika yemile behi na ngamiya wake kudisima. ");
INSERT INTO kdc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kamulongela, “Tuchole ukayangu, gweye kwa munhu unogeligwe na Mndewa Imulungu. Habali kokwima hano kunze? Niye nikutandila gati mng'anda yangu na hanhu ha kwika ngamiya wako.” ");
INSERT INTO kdc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Avo munhu ayo kengila mng'anda. Labani kawanenula iwangamiya mizigo na kuwagwaa mijani. Abaho kamgalila msang'hanaji wa Abulahamu na wanhu zake mazi ga kusunha magulu gao. ");
INSERT INTO kdc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Abaho wamgalila ndiya, lakini kalonga, “Sija bule mbaka nikulongele kinonda kulonga.” Labani kamulongela, “Ona, tulongele.” ");
INSERT INTO kdc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Munhu ija kalonga, “Niye na msang'hanaji wa Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mndewa Imulungu kamnogela ng'hani mkulu wangu nayo kana vinhu vingi. Kamgwaa ng'hondolo na ng'ombe na sente na zahabu na wasang'hanaji wa kimbigalo na wasang'hanaji wa kitwanzi na ngamiya na vihongwe. ");
INSERT INTO kdc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sala mwehe wa mkulu wangu, muuvele wake, kamulelela mkulu wangu mwana, na mkulu wangu kamgwaa mwana ayo vinhu vake vose. ");
INSERT INTO kdc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mkulu wangu kaniduwiliza, kalonga, ‘Sikuumsolele mwanangu mwehe kulawa kwa wandele wa Wakanaani kunikala niye. ");
INSERT INTO kdc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Lakini chola kulubuga lwa tatangu, kwa wanhu wa lukolo lwangu ako umsolele mwanangu mwehe.’ ");
INSERT INTO kdc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Abaho nimuuza mkulu wangu, ‘Yokuwa vilihi kamba yahalema kwiza na niye?’ ");
INSERT INTO kdc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Lakini kanidika, ‘Mndewa Imulungu yonilongoza siku zose, komtuma msenga wake yachole na gweye na kutenda mwanza wako unoge, ili umsolele mwehe mwanangu kulawa mulukolo lwangu na mulubuga lwa tatangu. ");
INSERT INTO kdc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kamba wahachola kwa wanhu wa lukolo lwangu, hata kamba wahalema kukugwaa mndele baho kuiduwila kwangu kokuhonya.’ ");
INSERT INTO kdc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Lelo vinivikile kudisima, nimpula Imulungu, nonga, ‘Mndewa Imulungu, Imulungu wa mkulu wangu Abulahamu, tenda mwanza wangu unoge. ");
INSERT INTO kdc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Niye nokwima hano behi sima, yaheza mndele kudeha mazi, nompula yangwee mazi ga kung'wa mwiinongo yake. ");
INSERT INTO kdc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Yahatogola, na vivija kowagwaa mazi ngamiya wangu, ayo kodaha kuwa ija yuumsagule yawe mwehe wa mwana wa mkulu wangu.’ ");
INSERT INTO kdc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ning'hali sina mambukiza kumpula Imulungu munda kwa munda, Lebeka keza na nongo yake mdiega, kachola kudisima kudeha mazi. Avo nimulongela, ‘Chonde, nigwelele mazi ga kung'wa.’ ");
INSERT INTO kdc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Himahima kanenula nongo yake mdiega jake, kalonga, ‘Ing'wa na vivija nowang'weza ngamiya wako.’ Avo ning'wa na vivija kawang'weza iwangamiya. ");
INSERT INTO kdc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Avo nimuuza, ‘Gweye kwa mndele wa nani?’ Kanidika, ‘Niye na mndele wa Besueli mwanage Naholi na imwehe Milika.’ Abaho nimvaza pete mwiimhula na bangili mmakono gake. ");
INSERT INTO kdc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Abaho nifugama, nimtambikila Mndewa Imulungu. Nimtogola Mndewa, Imulungu wa mkulu wangu Abulahamu, yanilongoze niye mbaka kulukolo lwa mkulu wangu Abulahamu, ako nimona mndele wa kusoligwa na mwanage mkulu wangu. ");
INSERT INTO kdc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Avo, kamba molagusa bazi na kumtendela ganogile mkulu wangu, nongeleni, na kamba hamutenda bule, nongeleni, na niye njuwe cha kutenda.” ");
INSERT INTO kdc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Viwahulike avo, Labani na Besueli wamwidika, “Kwavija mbuli ino yolawa kwa Mndewa Imulungu, siye twabule mbuli ya kulonga. ");
INSERT INTO kdc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka ino hano, msole uchole nayo. Leka yasoligwe na mwana wa mkulu wako, kamba Mndewa Imulungu mwenyego viyalondile iwe.” ");
INSERT INTO kdc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Msang'hanaji wa Abulahamu viyahulike kiwalongile, kamfugamila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Abaho kalava vinhu va kuihamba va shaba na zahabu na viwalo, kamgwaa Lebeka. Vivija kawagwaa nhunza za bei ng'hulu lumbu jake Lebeka na mamake. ");
INSERT INTO kdc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Abaho msang'hanaji wa Abulahamu na wanhu zake waja na kung'wa, na wawasa kuko. Imitondo viwalamuke, msang'hanaji ija kalonga, “Ndekeni mbwele kwa mkulu wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Lakini lumbu jake na mamake wamwidika, “Muleke imndele yakale na siye kamba siku longo abaho kochola nayo.” ");
INSERT INTO kdc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Lakini kawalongela, “Sikumung'hawize, kwavija Mndewa Imulungu kautenda mwanza wangu unoge. Ndekeni nibwele kwa mkulu wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wao walonga, “Tumkemeni imndele tumuuze.” ");
INSERT INTO kdc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Avo wamkema Lebeka, wamuuza, “Kolonda kuchola na munhu ino?” Nayo kedika, “Ona, nochola nayo.” ");
INSERT INTO kdc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Avo wamuleka Lebeka na msang'hanaji wake wachole hamoja na msang'hanaji wa Abulahamu na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Avo wamtambikila Lebeka kwa kulonga, “Gweye mndele, uwe mama wa wanhu magana kwa magana! Wanhu wa ulelo wako wagahume mabuga ga wanhu owehila!” ");
INSERT INTO kdc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Abaho Lebeka na wasang'hanaji wake waitanda, wakwela ngamiya wao, wachola na msang'hanaji wa Abulahamu, wose wasegela. ");
INSERT INTO kdc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kipindi acho, Isaka kakala yasegele Beeli Lahai Loi, kakala mwiisi ya Negebu. ");
INSERT INTO kdc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Siku dimoja ichungulo, kakala yacholile kumgunda kugelegeza. Viyalolile, kona ngamiya okwiza. ");
INSERT INTO kdc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lebeka viyamone Isaka, kahumuluka kulawa mna ingamiya, ");
INSERT INTO kdc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kamuuza msang'hanaji wa Abulahamu, “Munhu ija yotembela mumgunda kokwiza kuno kutwili iyo nani?” Msang'hanaji kamwidika, “Heyo ayo mkulu wangu.” Avo kasola mtandio wake, kaigubika kihanga chake. ");
INSERT INTO kdc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Msang'hanaji ayo kampetela Isaka kila kinhu kiyatendile. ");
INSERT INTO kdc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Avo Isaka kamgala Lebeka mkibanda cha Sala, mamake, kawa mwehe wake, Isaka kamnogela Lebeka, avo kasamhuka mbuli ya kwaga kwa mamake. ");
INSERT INTO kdc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abulahamu kasola mwehe iyagwe, twaga jake Ketula. ");
INSERT INTO kdc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula kamulelela Abulahamu Zimlani na Yokushani na Medani na Midiani na Ishibaki na Shua. ");
INSERT INTO kdc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokushani kamulela Sheba na Dedani. Ulelo wa Dedani wakala Waashulu na Waletushi na Waleumi. ");
INSERT INTO kdc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wanage Midiani wakala Efa na Efeli na Hanoki na Abida na Elidaa. Wose wano walawa muulelo wa Ketula. ");
INSERT INTO kdc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abulahamu kamgwaa Isaka uhazi wa vinhu vake vose. ");
INSERT INTO kdc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Lakini yang'hali mgima kawagwaa nhunza iwana yalelile na watumwa wake. Abaho kawagala wana awo kuna iisi ya mwambu wa kudilawila zuwa, kutali na kuyeli mwanage Isaka. ");
INSERT INTO kdc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abulahamu kakala na miyaka gana na malongo saba na tano. ");
INSERT INTO kdc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abulahamu viyafile kakala mvele ng'hani, kauja ng'hani na kailumba na wahenga zake wafile mwaka. ");
INSERT INTO kdc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Wanage Abulahamu Isaka na Ishimaeli, wamzika tatao mwiimhango ya Makipela, habehi na Mamule mumgunda ukalile wa Efuloni, mwanage Sohali, Muhiti. ");
INSERT INTO kdc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Mgunda awo Abulahamu kakala yaugulile kwa Wahiti, heyo na mwehe wake Sala wazikigwa mumgunda awo. ");
INSERT INTO kdc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abulahamu viyafile, Imulungu kamtendela ganogile Isaka, mwanage Abulahamu, keka ng'hambi yake behi na Beeli Lahai Loi. ");
INSERT INTO kdc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Uno awo ulelo wa Ishimaeli, mwanage Abulahamu, ija imsang'hanaji wake Sala, Hajili Mmisili, yalelile na Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Gano gago matwaga ga wanage Ishimaeli, kamba viwaleleke, Nebayosi, mwana wa chaudele wa Ishimaeli na Kedali na Adibeeli na Mibisamu, ");
INSERT INTO kdc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Mishima na Duma na Masa, ");
INSERT INTO kdc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi na Tema na Yetuli na Nafishi na Kedema. ");
INSERT INTO kdc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wano awo wanage Ishimaeli, wakalile watawala wa makabila longo na mbili. Mabuga gao na ng'hambi zao zikemigwa kwa matwaga gao. ");
INSERT INTO kdc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishimaeli viyafile kakala yavikize miyaka gana na malongo madatu na saba, nayo kailumba na wahenga zake wafile umwaka. ");
INSERT INTO kdc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ulelo wa Ishimaeli wakala mna gamabuga gakalile hagati ya Havila na Shuli, behi na Misili, kuchola Ashulu. Wao wakala waigolile na ulelo uyagwe wa Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Uno awo ulelo wa Isaka mwanage Abulahamu. Abulahamu kamulela Isaka. ");
INSERT INTO kdc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka viyavikize miyaka malongo mane kamsola Lebeka, mndele wa Besueli, Imualamu wa Padani Alamu na lumbu jake Labani Imualamu. ");
INSERT INTO kdc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Lebeka kakala mgumba, avo Isaka kampula Mndewa Imulungu. Nayo Mndewa Imulungu kahulika kupula kwake na imwehe Lebeka kagoga inda. ");
INSERT INTO kdc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Inda ayo ikala ya mapacha, wang'hali hawanavumbuka wakala oisung'hasung'ha mwiinda yake. Avo kalonga, “Habali kinhu kamba kino chondawilila niye?” Avo kachola kumuuza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mndewa Imulungu kamulongela, “Makabila mabili ga mwiinda yako, ng'holo mbili zonda uzilele, zogomba. Imoja yokuwa na nguvu kubanza iyagwe, imkulu komsang'hanila imdodo.” ");
INSERT INTO kdc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Siku zake za kulela vizivikile, Lebeka kalela wana mapacha. ");
INSERT INTO kdc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wa ichanduso kakala mdung'hu, lukuli lose upipi wiiyeka, avo wamkema Esau. ");
INSERT INTO kdc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wa kabili kavumbuka kuno kamgoga Esau mna ikisiginho, avo wamgwaa twaga da Yakobo. Lebeka viyawalelile iwana, Isaka kakala yavikize miyaka malongo sita. ");
INSERT INTO kdc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wana awo wakula, Esau kakala galu wa kusaka, kakala konogelwa kusinda kumuhulo, lakini Yakobo kakala munhu muhole, kakalaga ukae. ");
INSERT INTO kdc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Avo, Isaka kakala yamnogele Esau, kwavija kakala kotobola nyama ziyakomile, lakini Lebeka kakala yamnogele Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Siku dimoja, Yakobo kakala koteleka ng'hunde, Esau kakala yabwelile kulawa kusaka. Kakala na nzala ng'hani, ");
INSERT INTO kdc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","avo kamulongela Yakobo, “Nofa nzala, ngolela kinhu acho ikidung'hu ndie.” Lekaavo wamgwaa twaga da Edomu, fambulo jake mdung'hu. ");
INSERT INTO kdc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo kamwidika, “Nokugwaa kamba wahangwaa kija kiulondigwa kuhazi kamba mwana wa chaudele.” ");
INSERT INTO kdc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kamulongela, “Ona! Nolonda kufa, uhazi wangu wa mwana wa chaudele onifaya choni?” ");
INSERT INTO kdc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo kamwidika, “Tanhu iduwile kamba kongwaa kiulondigwa kuhazi.” Esau kaiduwila kamgwaa Yakobo kiyalondigwe kuhazi. ");
INSERT INTO kdc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Avo Yakobo kamgwaa Esau gate na ng'hunde. Kaja, kang'wa, abaho kenuka, kasegela. Vino vivo Esau viyakibezile kija kiyalondigwe kuhazi kamba mwana wa chaudele. ");
INSERT INTO kdc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abaho kukala na lufilili lwa nzala mwiisi, siyo ija ilawilile kipindi cha Abulahamu. Avo Isaka kamgendela Abimeleki, mndewa wa Wafilisiti, ako Gelali. ");
INSERT INTO kdc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mndewa Imulungu kamulawilila Isaka, kamulongela, “Sikuuchole mwiisi ya Misili, lakini ukakale mwiisi yonda nikulongele. ");
INSERT INTO kdc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kala baho, na niye nokuwa hamoja na gweye, nokutendela ganogile. Nokugwaa gweye na ulelo wako isi ino yose. Notenda kija kinongile kwa tatako Abulahamu. ");
INSERT INTO kdc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Noutenda ulelo wako wengezeke kamba vizili nhondo za kuulanga na nowagwaa isi zose zino. Kubitila ulelo wako, wanhu wa makabila gose omweda, ");
INSERT INTO kdc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kwavija Abulahamu kamhulika na katenda gaja ganimulongele na katenda gaja ganimulagize na kagoga gaja ganimfundile.” ");
INSERT INTO kdc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Avo Isaka kakala ako Gelali. ");
INSERT INTO kdc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wenekae wa ako viwauzile mbuli ya mwehe wake, kawalongela kakala lumbu jake. Kadumba kuwalongela kamba kakala mwehe wake, kwavija kadumba wahamkomile na kumsola Lebeka, yakalile yanogile ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Viyakalile ako kwa kipindi, Abimeleki, mndewa wa Wafilisiti kasungulila mdidilisha kamona Isaka komfagatila mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki kamkema Isaka, kamulongela, “Kumbe iyo mwehe wako! Habali kulonga kakala lumbu jako?” Isaka kamwidika, “Nidumba nahakomigwe maza nongile kakala mwehe wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki kalonga, “Kutenda choni kumwetu? Imoja wa wanhu zangu yahadahile kuwasa na mwehe wako na gweye wahatendile toneke tubananga.” ");
INSERT INTO kdc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Avo Abimeleki kawazuma wanhu wose, kawalongela, “Munhu yoyose yonda yamtendele vihile munhu ino hebu mwehe wake, kokomigwa.” ");
INSERT INTO kdc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mwaka awo Isaka kahanda mbeyu mwiisi ija, kaigwisa ndiya kwavija Mndewa Imulungu kakala yamtendele ganogile. ");
INSERT INTO kdc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka kagendelela goya, kakala na vinhu vingi. ");
INSERT INTO kdc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Wafilisiti wamonela migongo kwavija kakala na mabumbila bwando ga ng'hondolo na ng'ombe na watumwa. ");
INSERT INTO kdc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Avo wagasila masima gose tatake gayawalagize wasang'hanaji wake wagahimbe viyakalile mgima. ");
INSERT INTO kdc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abaho Abimeleki kamulongela Isaka, “Segela mwiisi yetu, gweye kuna nguvu kubanza siye.” ");
INSERT INTO kdc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Avo Isaka kasegela, keka ng'hambi yake kubonde da Gelali, na kakala kuko. ");
INSERT INTO kdc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka kagahimba kabili masima gahimbigwe kipindi Abulahamu tatake yang'hali hanakufa na kusiligwa na Wafilisiti viyafile Abulahamu. Isaka kagagwaa masima gago matwaga gagaja gakemigwe na tatake. ");
INSERT INTO kdc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wasang'hanaji wa Isaka viwahimbile kubonde wapata mazi ga nzasa. ");
INSERT INTO kdc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Wasusilaji wa Gelali wakala ogomba na wasusilaji wa Isaka, walonga, “Mazi gano ga kumwetu.” Avo Isaka kadikema sima dijo, “Eseki,” fambulo jake bwato. ");
INSERT INTO kdc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Wasang'hanaji wa Isaka wahimba sima diyagwe, sima dijo vivija wadigombela kabili, avo kadikema, “Sitina,” fambulo jake kuihila. ");
INSERT INTO kdc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kasegela hanhu aho, kahimba sima diyagwe. Lakini sima dijo hawadigombele bule, avo kadikema, “Lehoboti,” fambulo jake kulekeswa. Kalonga, “Sambi Mndewa Imulungu katulekesa tukale mwiisi, na tomweda ng'hani.” ");
INSERT INTO kdc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaka kasegela, kachola ako Beelisheba. ");
INSERT INTO kdc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mndewa Imulungu kamulawilila ikilo, kamulongela, “Niye na Imulungu wa tatako Abulahamu. Sikuudumbe kwavija niye na hamoja na gweye. Nokutendela ganogile na nokugwaa ulelo mkulu mbuli ya kija kinongile kwa msang'hanaji wangu Abulahamu.” ");
INSERT INTO kdc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Avo Isaka kazenga upango wa kulavila nhosa, kamtambikila Mndewa Imulungu. Abaho keka ng'hambi yake kuko na wasang'hanaji zake wahimba sima diyagwe. ");
INSERT INTO kdc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki hamoja na mbwigake Ahuzasi na Fikoli mkulu wake wa iwakalizi, wasegela Gelali, wachola kumulola Isaka. ");
INSERT INTO kdc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Avo Isaka kawauza, “Habali mwiza kundola, mweye munihile na kuniwinga mwiisi yenu?” ");
INSERT INTO kdc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wao wamwidika, “Sambi tojuwa kamba Mndewa Imulungu kahamoja na gweye, avo tolonda gweye na siye tuilagane. Tokulonda ulonge, ");
INSERT INTO kdc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kamba hututendela vihile, kamba siye vitulekile kukutendela vihile. Tukutendela ganogile na tukuleka usegele kwa tindiwalo. Sambi yokoneka Mndewa Imulungu kakutendela ganogile.” ");
INSERT INTO kdc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Avo Isaka kawatendela nyimwilinyimwili, nao waja na kung'wa. ");
INSERT INTO kdc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Imitondo yake, kila munhu kaiduwila kwa miyage. Isaka kawalaga, na hewo wamuleka moyo kwatu. ");
INSERT INTO kdc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Siku didija wasang'hanaji wa Isaka wamwizila, wamulongela mbuli ya sima diwahimbile, walonga, “Tugavika mazi.” ");
INSERT INTO kdc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Avo Isaka kadikema sima dijo, “Shiba,” fambulo jake kuiduwila, na mbaka sambi buga dijo dokemigwa Beelisheba. ");
INSERT INTO kdc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau viyavikize miyaka malongo mane, kasola wehe wabili Wahiti, Yudisi mndele wa Beeli na Basemati mndele wa Eloni. ");
INSERT INTO kdc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Watwanzi awo wamtenda Isaka na mwehe wake wakale moyo nyunguwaa. ");
INSERT INTO kdc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka kakala mvele na kawa msuwameso. Avo kamkema mwanage imkulu Esau, kamulongela, “Mwanangu,” imwana kamwidika, “Tata, nabaha.” ");
INSERT INTO kdc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka kalonga, “Lola, niye namvele, na siku ya kufa kwangu siijuwile bule. ");
INSERT INTO kdc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Avo sola upinde na msale, uchole kumuhulo ukanisakile mnyama. ");
INSERT INTO kdc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nhelekele ndiya inondaga, ungalile ndie, ili nikutambikile ning'hali sinakufa.” ");
INSERT INTO kdc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaka viyakalile komulongela Esau, Lebeka kakala kotegeleza. Avo Esau viyacholile kusaka, ");
INSERT INTO kdc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebeka kamulongela mwanage Yakobo, “Nimuhulika tatako komulongela mkulu wako Esau, ");
INSERT INTO kdc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ngalila mnyama, unhelekele, nahamala kuja nikutambikile mgameso ga Mndewa Imulungu ning'hali sinakufa.’ ");
INSERT INTO kdc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Lelo mwanangu, nhegeleza goya na usang'hane kinikulongela. ");
INSERT INTO kdc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Genda, kuna ifugo ya mbuzi, kangalile mabofu mabili ga mbuzi ganenehe, nimtelekele tatako ndiya ili mulile iyalondaga. ");
INSERT INTO kdc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Abaho mgalile tatako yaje, ili yakutambikile yang'hali hanakufa.” ");
INSERT INTO kdc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobo kamulongela mamake, Lebeka, “Lakini kojuwa kamba mkulu wangu Esau kana upipi mulukuli, niye nabule upipi mulukuli. ");
INSERT INTO kdc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kamba tatangu yahambabasa, nokoneka kamba nomvizila, avo noiduwila mwenyego kubanza kutambikiligwa.” ");
INSERT INTO kdc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mamake kamwidika, “Mwanangu, kamba kuduwiligwa mbuli yako, leka nduwiligwe niye, genda kangalile gago gamabofu ga mbuzi.” ");
INSERT INTO kdc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Avo Yakobo kagenda kuwasola, kamgalila mamake, na heyo kateleka indiya iyalondaga tatake. ");
INSERT INTO kdc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Abaho Lebeka kasola viwalo vinogile ng'hani va mwanage wa chaudele Esau, vikalile mng'anda, kamvaza mwanage imdodo Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kamvaza ng'hwembe za mbuzi mmakono gake na msingo mulibule upipi. ");
INSERT INTO kdc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Abaho kamgwaa ayo indiya ili umulile na gamagate gayatandile. ");
INSERT INTO kdc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Avo, Yakobo kachola kwa tatake, kamkema, “Tatangu!” Nayo kamwidika, “Mwanangu. Gweye kwa mwanangu nani?” ");
INSERT INTO kdc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo kamwidika tatake, “Niye na Esau, mwanago wa chaudele, nisang'hana kamba viunongele, chonde, lamuka uje ndiya inikugalile, ili unitambikile.” ");
INSERT INTO kdc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaka kalonga, “Mwanangu, vilihi hukawile bule kumpata?” Yakobo kamwidika, “Mndewa Imulungu wako iyo yanitazile kumpata.” ");
INSERT INTO kdc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Avo Isaka kamulongela Yakobo, “Kwesa behi mwanangu nikukwase, njuwe kamba kweli gweye kwa mwanangu Esau.” ");
INSERT INTO kdc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo kakwesa behi na tatake Isaka, nayo kamkwasa na kalonga, “Sauti ya Yakobo, lakini makono ga Esau.” ");
INSERT INTO kdc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Avo hamjuwile bule kwavija makono gake gakala na upipi kamba mkulu wake Esau, avo kaitanda kumtambikila. ");
INSERT INTO kdc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kamuuza kabili, “Vino gweye kweli kwa mwanangu Esau?” Nayo kamwidika, “Ona.” ");
INSERT INTO kdc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Avo, Isaka kamulongela, “Mwanangu ngalila inyama yuukomile nije, nahamambukiza nikutambikile.” Yakobo kamgalila indiya na heyo kaja, vivija kamgalila idivai na heyo kang'wa. ");
INSERT INTO kdc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Abaho tatake Isaka, kamulongela, “Kwesa behi uninonele.” ");
INSERT INTO kdc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Avo, Yakobo kamgendela na kamnonela, Isaka viyahulike mnung'ho wa viwalo vake, kamtambikila, kalonga, “Oo, mnung'ho unogile wa mwanangu uigala na mnung'ho wa mgunda utambikiligwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nompula Imulungu yagale mvula mna imigunda yako na yakugwelele vinhu vose va mwiisi, na uigwise ndiya na zabibu. ");
INSERT INTO kdc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Wanhu wa mziisi wakusang'hanile na wanhu wakufugamile, uwatawale ndugu zako na wanage mamako wakufugamile. Wonda wakuduwile, waduwiligwe na Imulungu na onda wakutambikile, nao watambikiligwe.” ");
INSERT INTO kdc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka viyamambukize kumtambikila Yakobo, bahaja Yakobo viyasegele kwa tatake, mkulu wake Esau kabwela kulawa kusaka. ");
INSERT INTO kdc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Na heyo vivija kateleka ndiya ili mulile, kamgalila tatake. Abaho kamulongela, “Tatangu lamuka uje nyama inikusakile, ili unitambikile.” ");
INSERT INTO kdc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka kamuuza, “Gweye kwa nani?” Nayo kamwidika, “Niye na mwanago wa chaudele, Esau.” ");
INSERT INTO kdc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Baho Isaka kagwaya ng'hani, kalonga, “Kumbe ija yasakile nyama na kungalila nani? Na niye nija gweye haunakwiza abaho nimtambikila, nayo kotambikiligwa kweli!” ");
INSERT INTO kdc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau viyahulike mbuli za tatake kaguta kwa sauti ng'hulu kalonga, “Tata, na niye vivija nitambikile!” ");
INSERT INTO kdc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Lakini Isaka kalonga, “Ndugu yako keza kamvizila, nayo kasola kutambikiligwa kwako.” ");
INSERT INTO kdc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau kalonga, “Uno mwanza wa kabili kamvizila, lekaavo twaga jake Yakobo! Tanhu kamboka ukulu wangu kamba mwana wa chaudele na sambi kasola kutambikiligwa kwangu!” Abaho kamuuza tatake, “Hundekele kutambikiligwa kokose?” ");
INSERT INTO kdc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka kamwidika Esau, “Nimtenda yakutawale na niwatenda ndugu zake wose wawe wasang'hanaji zake na nimgwaa ndiya na zabibu. Sambi kuduhu kinhu chochose chonda nikutendele mwanangu.” ");
INSERT INTO kdc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau kamulongela tatake, “Gweye kuna kutambikila kumoja kwiiyeka tata? Nhambikile na niye vivija tatangu!” Abaho Esau kalila kwa usungu. ");
INSERT INTO kdc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tatake kamwidika Esau, “Ukazi wako okuwa kutali na isi inogile, kutali na mvula ya kuulanga. ");
INSERT INTO kdc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kokala kwa kuitowa kwa sime jako na komsang'hanila mdodo wako. Lakini wahambiduka kolawa mmakono gake.” ");
INSERT INTO kdc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Avo, Esau kamwihila Yakobo kwavija tatake kamtambikila Yakobo. Esau kailongela, “Tatangu yahafa na siku za kumulilila zahesha, nomkoma ndugu yangu Yakobo.” ");
INSERT INTO kdc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lakini Lebeka viyajuwile kiyolonda kutenda Esau, kamkema Yakobo, kamulongela, “Ukale meso ndugu yako Esau kokusamhukila na kuno kogelegeza yakukome. ");
INSERT INTO kdc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Avo mwanangu tenda vinikulongela. Lopola ukimbile kwa lumbu jangu Labani ako Halani. ");
INSERT INTO kdc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kala kuko mbaka ng'hasiliki ya ndugu yako yahahola. ");
INSERT INTO kdc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ng'hasiliki ya mkulu wako yahesha na kuisemwa kija kiumtendele nomtuma munhu ubwele. Habali kwa siku dimoja nifiligwe na mweye wanangu wabili?” ");
INSERT INTO kdc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka kamulongela Isaka, “Niye nidonha mbuli ya wehe zake Esau wano Wahiti, kamba Yakobo vivija yahasola imoja wa watwanzi wano Wahiti, niye nokuwa na kilamuso gani cha kuwa mgima?” ");
INSERT INTO kdc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaka kamkema Yakobo, kamtambikila, kamulagiza yolonga, “Sikuusole mtwanzi wa kulawa Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Genda Padani Alamu, mng'anda ya babu yako Besueli, ukasole imoja wa wandele wa mjomba wako Labani. ");
INSERT INTO kdc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Imulungu yeli na Udahi wose yakutendele ganogile na yakugwee wana bwando, ili uwe tata wa makabila mengi. ");
INSERT INTO kdc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Imulungu yakutendele ganogile gweye na ulelo wako kamba viyamtendele ganogile Abulahamu, usole isi ino yuukala kamba munhu baki, isi ija Imulungu iyamgwelele Abulahamu.” ");
INSERT INTO kdc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Avo, Isaka kamtuma Yakobo yachole, nayo Yakobo kachola Padani Alamu kwa Labani mwanage Besueli, imualamu. Labani kakala lumbu wa Lebeka mamao Yakobo na Esau. ");
INSERT INTO kdc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau kajuwa kamba Isaka kamtambikila Yakobo na kakala yamtumile yachole Padani Alamu yakasole mwehe, na viyamtambikile kamulagiza sikuyamsole mtwanzi Mkanaani. ");
INSERT INTO kdc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Vivija kajuwa kamba Yakobo kawategeleza tatake na mamake, kachola Padani Alamu. ");
INSERT INTO kdc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Avo Esau kajuwa kamba tatake hawalondile watwanzi wa Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Avo, leka waja iwatwanzi yawasolile toka mwaka, Esau kachola kwa Ishimaeli mwanage Abulahamu, kamsola Mahalati mndele wa Ishimaeli, lumbu jake Nebayosi. ");
INSERT INTO kdc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo kasegela Beelisheba, kachola Halani. ");
INSERT INTO kdc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Viyavikile hanhu kwavija zuwa dikala dihongile, kasola dibwe dimoja kasigamiza pala jake mdibwe dijo kawasa utulo. ");
INSERT INTO kdc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kalota nzozi, mwiinzozi kona kidando kulawa mwiisi mbaka kuulanga na wasenga wa kuulanga wakala odanda na kuhumuluka mkidando acho. ");
INSERT INTO kdc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mndewa kema mkidando acho kalonga, “Niye ayo Mndewa Imulungu, Imulungu wa Abulahamu na Imulungu wa Isaka tatako. Isi yuuwasile nokugwaa gweye na ulelo wako. ");
INSERT INTO kdc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ulelo wako omema kamba timbwisi da mwiisi na okwenela mwambu wa kudihongela zuwa na mwambu wa kudilawila zuwa, mwambu wa kasikazini na mwambu wa kusini. Kubitila gweye na ulelo wako ng'holo zose za mwiisi zomweda. ");
INSERT INTO kdc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Niye na hamoja na gweye, kokose konda uchole niye nokulola na nokubweza mwiisi ino. Sikuleka mbaka vonda nisang'hane gaja ganikulongele.” ");
INSERT INTO kdc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo viyalamuke muutulo, kalonga, “Ukweli Mndewa Imulungu kabaha, na niye ng'hala sijuwile bule!” ");
INSERT INTO kdc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakobo kadumba na kalonga, “Hanhu hano hogela bwembwe, vinyona hano aho ng'anda ya Imulungu kuili na lwivi lwa kuulanga.” ");
INSERT INTO kdc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Imitondo yake Yakobo kasola didibwe diyasigamize kudipala jake kadisimika na uchanha yake kadigidila mavuta. ");
INSERT INTO kdc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hanhu aho kahakema Beseli, fambulo jake, “Ng'anda ya Imulungu,” lakini aho umwaka buga dijo dikala dokemigwa Luzu. ");
INSERT INTO kdc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Abaho Yakobo kaiduwila kwa Imulungu, kalonga, “Kamba Imulungu kokuwa hamoja na niye na kuulola goya mwanza wangu na kungwaa ndiya na viwalo, ");
INSERT INTO kdc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na kamba nahabwela mgima ukae kwa tatangu, baho Mndewa kokuwa Imulungu wangu, ");
INSERT INTO kdc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","na hanhu hano hanisimike dibwe dino hokuwa ng'anda ya Imulungu na vose vonda ungwelele nokulavila fungu da longo.” ");
INSERT INTO kdc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo kagendelela na mwanza wake, kavika mziisi za wanhu wa mwambu wa kudilawila zuwa. ");
INSERT INTO kdc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Siku dimoja kona sima kuluwala na mabumbila madatu ga ng'hondolo gahumula, kwavija ng'hondolo awo wakala ong'wa mazi kulawa mdisima dijo. Mmulomo wa disima kukala na dibwe kulu. ");
INSERT INTO kdc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mabumbila ga ng'hondolo gahaiting'hana, wasusilaji odikwesa kumgwazo dibwe dijo kulawa hana umulomo wa disima na owang'weza ng'hondolo wao. Abaho odibweza bahaja mmulomo wa disima. ");
INSERT INTO kdc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo kawauza iwasusilaji, “Ndugu zangu molawa kwahi?” Wamwidika, “Tolawa mwiisi ya Halani.” ");
INSERT INTO kdc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kawauza, “Mumjuwa Labani, mzukulu wa Naholi?” Wamwidika, “Ona, tumjuwa.” ");
INSERT INTO kdc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Abaho Yakobo kawauza, “Vilihi mgima?” Wamulongela, “Ona, mgima, na mndele wake Laheli aija kuja kokwiza na ng'hondolo wake.” ");
INSERT INTO kdc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Abaho Yakobo kawalongela, “Loleni zuwa ding'hali hadinahonga, siyo kipindi cha kuweka hamoja ng'hondolo. Wang'wezeni mazi mkawasusile.” ");
INSERT INTO kdc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Lakini wao wamulongela, “Hatudaha bule kutenda vivo mbaka vibumbila vose vikale hamoja na dibwe dikwesigwe kumgwazo ya disima, baho towang'weza iwang'hondolo.” ");
INSERT INTO kdc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo viyakalile yang'hali kolonga na wasusilaji awo, Laheli keza na ng'hondolo wa tatake, kwavija heyo iyo yakalile yowasusila. ");
INSERT INTO kdc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo viyamone Laheli mndele wa Labani, lumbu wa mamake na viyawone ng'hondolo wa Labani, kachola kudisima kadikwesa kumgwazo didibwe kawang'weza ng'hondolo wa mjomba wake. ");
INSERT INTO kdc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Abaho Yakobo kamnonela Laheli kwa deng'ho mbaka mahozi gamulawa. ");
INSERT INTO kdc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo kamulongela Laheli kamba heyo kakala ndugu wa tatake na kakala mwana wa Lebeka. Laheli kakimbila ukae kamulongela tatake. ");
INSERT INTO kdc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani viyahulike mbuli za Yakobo, mwihwage, kalopola kumbokela, kamfagatila na kumnonela, kamgoneka ukae kumwake. Yakobo kampetela mbuli zose zilawilile. ");
INSERT INTO kdc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nayo Labani kalonga, “Gweye kwa ndugu yangu wa usungu.” Yakobo kakala na mjomba wake kwa mwezi umoja. ");
INSERT INTO kdc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Siku dimoja Labani kamulongela Yakobo, “Siyo kwavija gweye kwa ndugu avo unisang'hanile bule. Nongele fungu diulonda.” ");
INSERT INTO kdc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani kakala na wandele wabili, imndele ikulu twaga jake Lea na imdodo twaga jake Laheli. ");
INSERT INTO kdc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea kakala na meso makulu, lakini Laheli kakala yanogile na kakala na unovu. ");
INSERT INTO kdc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo kamnogela Laheli, avo kamulongela Labani, “Nokusang'hanila kwa miyaka saba unigwee Laheli, mndele wako imdodo yawe mwehe wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani kamulongela, “Vinoga nikugwee gweye umsole kubanza yasoligwe na munhu iyagwe, kala bahano na niye.” ");
INSERT INTO kdc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Avo, mbuli ya kumnogela Laheli, Yakobo kamsang'hanila Labani miyaka saba, lakini kumwake heyo kona kamba kipindi kidodo kwavija kamnogela ng'hani Laheli. ");
INSERT INTO kdc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Abaho Yakobo kamulongela Labani, “Kipindi changu kisha, avo ngwelele mwehe wangu nolonda kuwasa nayo.” ");
INSERT INTO kdc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Avo, Labani kawagoneka wanhu kuna inyimwilinyimwili. ");
INSERT INTO kdc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Lakini viivikile ichungulo, kamsola Lea mndele wake imkulu, kamgala kwa Yakobo. Yakobo kawasa nayo. ");
INSERT INTO kdc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani kamulava Zilipa yakalile mtumwa wake yamsang'hanile mndele wake Lea. ");
INSERT INTO kdc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Vikuchile, Yakobo kajuwa kamba kakala Lea, avo kamuuza Labani, “Kunhenda choni? Niye nikusang'hanila mbuli ya Laheli. Avo habali kunivizila?” ");
INSERT INTO kdc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani kamwidika, “Mwiisi yetu hatutendaga vivo, siyo mila yetu kutenda imdodo yasoligwe tanhu kipindi imkulu yang'hali. ");
INSERT INTO kdc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Beta mbaka zishe siku saba za nyimwilinyimwili ya zengele, abaho nokugwaa Laheli kamba konisang'hanila kwa miyaka saba iyagwe.” ");
INSERT INTO kdc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo katogola. Avo Yakobo kakala na Lea kwa siku azo saba, abaho Labani kamgwaa Laheli mndele wake imdodo yawe mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani kamulava Biliha yakalile mtumwa wake wa kitwanzi yamsang'hanile mndele wake Laheli. ");
INSERT INTO kdc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Avo, Yakobo kawasa na Laheli vivija. Lakini Yakobo kamnogela ng'hani Laheli kubanza Lea. Yakobo kamsang'hanila Labani miyaka saba iyagwe. ");
INSERT INTO kdc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mndewa Imulungu viyone Lea kehiligwa, kamtenda yalele wana, lakini Laheli kakala mgumba. ");
INSERT INTO kdc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea kagoga inda, kalela mwana wa kimbigalo, kamkema Lubeni, fambulo jake mwana mbigalo, kwavija kalonga, “Mndewa Imulungu kona kugaya kwangu, kulawa sambi mkasano wangu koninogela.” ");
INSERT INTO kdc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea kagoga inda kabili, viyalelile mwana wa kimbigalo kalonga, “Kwavija Mndewa Imulungu kahulika kamba nihiligwa, lekaavo vivija kangwaa na ino.” Avo kamkema Simeoni, fambulo jake kahulika. ");
INSERT INTO kdc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Abaho kagoga inda lwa kadatu na kalela mwana iyagwe wa kimbigalo, kalonga, “Sambi mkasano wangu koilumba na niye, kwavija nimulelela wana wadatu wa kimbigalo.” Avo mwana ayo kamkema Lawi, fambulo jake koilumba. ");
INSERT INTO kdc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kagoga inda lwa ikane, na viyalelile mwana wa kimbigalo kalonga, “Mwanza uno nomgwaa nhogolwa Mndewa Imulungu.” Avo mwana ayo kamkema Yuda, fambulo jake nhogolwa. Abaho kaleka kulela wana. ");
INSERT INTO kdc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laheli viyone hanamulelela Yakobo wana kamonela migongo Lea, mkulu wake. Avo kamulongela Yakobo, “Ngwaa wana buleavo nofa.” ");
INSERT INTO kdc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo kamgevuzikila Laheli kalonga, “Vino niye ngaluka Imulungu yakutendile sikuulele wana?” ");
INSERT INTO kdc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheli kamulongela, “Mtumwa wangu Biliha kabaha, wasa nayo ili yandelele mwana, na niye mhate wana kubitila heyo.” ");
INSERT INTO kdc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Avo Laheli kamgwaa Yakobo mtumwa wake Biliha yawe kamba mwehe wake. Yakobo kawasa nayo, ");
INSERT INTO kdc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha kagoga inda, kamulelela Yakobo mwana wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Laheli kalonga, “Imulungu kanigombela, kahulika kulila kwangu na kangwaa mwana wa kimbigalo.” Avo mwana ayo kamkema Dani, fambulo jake kanigombela. ");
INSERT INTO kdc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha mtumwa wa Laheli kagoga inda kabili, kamulelela Yakobo mwana wa kabili wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Laheli kalonga, “Niitowa ng'hani na mkulu wangu, na niye nihuma.” Avo twaga jake kamkema Nafutali, fambulo jake niitowa. ");
INSERT INTO kdc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea viyone sambo isha, kamsola mtumwa wake Zilipa, kamgwaa Yakobo yawe kamba mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa mtumwa wa Lea kamulelela Yakobo mwana wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea kalonga, “Nimweda.” Avo twaga jake kamkema Gadi, fambulo jake nimweda. ");
INSERT INTO kdc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa, mtumwa wa Lea, kamulelela Yakobo mwana wa kabili wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea kalonga, “Sambi nodeng'helela! Watwanzi ong'hema deng'ho.” Avo twaga jake kamkema Asheli fambulo jake deng'ho. ");
INSERT INTO kdc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kipindi cha kusenga ngano, Lubeni kachola kumgunda ako kona nhula, kamgalila mamake yakemigwe Lea. Laheli kamulongela Lea, “Chonde mbagulila nhula za mwanago.” ");
INSERT INTO kdc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lakini Lea kamwidika, “Gweye viumsolile mkasano wangu kugesa ikala mbuli ndodo. Na sambi vivija kolonda nhula za mwanangu.” Laheli kamwidika, “Vinoga, kamba kongwaa nhula za mwanago lelo Yakobo kowasa kumwako.” ");
INSERT INTO kdc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Avo, ichungulo Yakobo viyabwelile kulawa kumgunda, Lea kachola kumbokela, kamulongela, “Lelo kowasa na niye, kwavija nikulihila kwa nhula za mwanangu.” Avo ikilo kawasa kwa Lea. ");
INSERT INTO kdc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Imulungu kamuhulika Lea, nayo kagoga inda, kamulelela Yakobo mwana wa tano wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea kalonga, “Imulungu kangwaa nhunza yangu, kwavija nimgwaa mkasano wangu mtumwa wangu,” avo kamkema mwana ayo Isakali, fambulo jake nhunza yangu. ");
INSERT INTO kdc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea kagoga inda kabili, kamulelela Yakobo mwana wa sita wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea kalonga, “Imulungu kamgwaa nhunza inogile. Sambi mkasano wangu konitogola kwavija nimulelela wana sita.” Avo kamkema imwana ayo Zabuloni, fambulo jake konitogola. ");
INSERT INTO kdc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Abaho kalela mwana wa kitwanzi, kamkema Dina. ");
INSERT INTO kdc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Abaho Imulungu kamkumbuka Laheli, kamuhulika na kumtenda yalele wana. ");
INSERT INTO kdc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Laheli kagoga inda, kalela mwana wa kimbigalo, kalonga, “Imulungu kanisegesela kinyala changu.” ");
INSERT INTO kdc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Avo kamkema mwana ayo Yusufu, fambulo jake kanisegesela, kwavija kalonga, “Nompula Mndewa Imulungu yanyengezele mwana iyagwe wa kimbigalo.” ");
INSERT INTO kdc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laheli viyamulelile Yusufu, Yakobo kamulongela Labani, “Ndeka mbwele ukayangu, mwiisi yangu. ");
INSERT INTO kdc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ngwelela wehe zangu na wanangu, niwapatile kwa kukusang'hanila, nisegele. Kujuwa vinikusang'hanile goya.” ");
INSERT INTO kdc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lakini Labani, kamulongela, “Kamba kononda, chonde sikuusegele, kwavija njuwa kwa uhawi kamba Mndewa Imulungu kanitenda nimwede mbuli ya gweye. ");
INSERT INTO kdc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nongela fungu jako, na niye nokuliha.” ");
INSERT INTO kdc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo kamulongela, “Gweye kujuwa vinikusang'hanile, na vija fugo yako viyongezeke mmakono gangu. ");
INSERT INTO kdc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kwavija kija kidodo kiukalile nacho ning'hali sinavika, sambi chongezeka ng'hani na kokose kunicholile Mndewa Imulungu kakutenda umwede. Lakini sambi na niye nolonda kuwalola goya wanhu wa mng'anda yangu.” ");
INSERT INTO kdc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani kamuuza, “Nikugwee choni?” Yakobo kamwidika, “Sikuungwee kinhu chochose, nogendelela kuwalola wanyama wako kamba konhendela kinhu kimoja. ");
INSERT INTO kdc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nhogolela niwakagule wanyama wako, lelo, na kulawa mumo, nibagule kila bofu da ng'hondolo yeli na uzegenhe zegenhe na kila ng'hondolo mtitu, na mbuzi weli na uzegenhe zegenhe. Dijo ijo fungu jangu, dinilonda. ");
INSERT INTO kdc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Avo ako kumwande, kinongile chokoneka goya, vonda wize kulola fungu jangu. Mbuzi yoyose yelibule uzegenhe zegenhe hebu ng'hondolo yelibule utitu yahakoneka mkibumbila changu, iyo kebigwa.” ");
INSERT INTO kdc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani kamwidika, “Ona, na iwe kamba viulongile.” ");
INSERT INTO kdc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Lakini siku didija Labani kawabagula mbuzi wose wa kimbigalo weli na uzegenhe zegenhe hebu mindilizi ndilizi na mbuzi wose wa kitwanzi weli na uzegenhe zegenhe hebu mindilizi ndilizi, vivija kawasegesa ng'hondolo wose weli watitu, kawagwaa wanage wawasusile kamba fungu da Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labani na bumbila dijo dili fungu da Yakobo, kainega na Yakobo muumwanza wa kutembela siku ndatu, nayo Yakobo kagendelela kuwasusila wanyama wasigale wa Labani. ");
INSERT INTO kdc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Avo, Yakobo kasola fito mbisi za mibiki midatu kagabandula gamagome, na katenda misitali mzifito azo. ");
INSERT INTO kdc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Abaho kazisimika zifito ziyabandule kuulongozi wa viya va kung'wela mazi, hanhu haja wanyama wezaga kung'wa mazi, kwavija wanyama wahaiting'hana hamoja kung'wa mazi oikwela. ");
INSERT INTO kdc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Wanyama waikwela na kugoga inda kuulongozi wa fito azo, walela wana weli na uzegenhe zegenhe na mindilizi ndilizi. ");
INSERT INTO kdc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo kageka kumgwazo mabofu ga ng'hondolo, abaho awo wasigale kawatenda walole ubazi wa wanyama weli na uzegenhe zegenhe na utitu kudikalile bumbila da Labani. Kwa kutenda avo, Yakobo kapata bumbila jake mwenyego, na hadikile hamoja na wanyama wa Labani. ");
INSERT INTO kdc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Avo chahavika kipindi cha wanyama weli na nguvu kugoga inda, Yakobo kokwika zifito kuulongozi wao mna iviya va kung'wela mazi, ili waikwele na wagoge inda kuulongozi wa fito azo. ");
INSERT INTO kdc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lakini hazikile fito azo kuulongozi wa wanyama wanyolile. Hakibitile kipindi kitali, wanyama wanyolile wakala wa Labani, na waja weli na nguvu wakala wa Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Avo, Yakobo kawa tajili ng'hani, kakala na mabumbila makulu ga wanyama, kakala na watumwa wa kitwanzi na wa kimbigalo na ngamiya na vihongwe. ");
INSERT INTO kdc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo kahulika wanage Labani viwakalile olonga, “Yakobo kasola kila kinhu cha tataetu na utajili kaupata kulawa kwa tataetu.” ");
INSERT INTO kdc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Vivija Yakobo kakala yajuwile kamba Labani kakala hamgesa bule kamba viikalile haichanduso. ");
INSERT INTO kdc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Abaho Mndewa Imulungu kamulongela Yakobo, “Bwela mwiisi ya wahenga zako na lukolo lwako, na niye nokuwa hamoja na gweye.” ");
INSERT INTO kdc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Avo Yakobo kawatuma wanhu wawakeme Laheli na Lea weze kuluwala kuyakalile na fugo yake. ");
INSERT INTO kdc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakobo kawalongela, “Nokona sambi tataenu hangesa kamba viikalile ichanduso, lakini Imulungu wa tatangu kahamoja na niye. ");
INSERT INTO kdc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mweye mojuwa nimsang'hanila tataenu kamba vindahile. ");
INSERT INTO kdc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hata avo kamvizila na kugalusa fungu jangu miyanza longo. Lakini Imulungu hamulekile yandumize. ");
INSERT INTO kdc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tataenu viyalongile, ‘Wanyama weli na uzegenhe zegenhe wao fungu jako,’ avo bumbila jose dilela wanyama weli na uzegenhe zegenhe, na viyalongile, ‘Wanyama weli na mindilizi ndilizi wao fungu jako,’ avo bumbila jose dilela wanyama weli na mindilizi ndilizi. ");
INSERT INTO kdc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Avo Imulungu kamboka tataenu fugo yake, kangwaa niye.” ");
INSERT INTO kdc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Kipindi cha wanyama kugoga inda, ndota nzozi, mwiinzozi ayo mbona mbuzi wose wa kimbigalo wawakwelile wanyama awo wakala na mindilizi ndilizi na uzegenhe zegenhe. ");
INSERT INTO kdc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mwiinzozi ayo, msenga wa kuulanga kang'hema, ‘Yakobo,’ na niye nimwidika, ‘Nabaha!’ ");
INSERT INTO kdc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kanongela, ‘Lola, mbuzi wose wa kimbigalo, iwokwela mbuzi wa kitwanzi wana mindilizi ndilizi na uzegenhe zegenhe, kwavija nichona kija kiyokutendela Labani. ");
INSERT INTO kdc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Niye ayo Imulungu yakulawilile ako Beseli kuja kuugidile mavuta mdibwe na kuiduwila kumwangu, sambi segela mwiisi ino, ubwele mwiisi yako.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Laheli na Lea wamwidika Yakobo, “Siye twabule uhazi usigale kwa tataetu! ");
INSERT INTO kdc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Katutenda kamba wanhu baki, katuchuuza na kuzinanga sente zituchuuzigwe. ");
INSERT INTO kdc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Vinhu vose Imulungu viyambokile tataetu va kumwetu na wanetu. Avo sang'hana kinhu chochose kiyakulongele Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Abaho Yakobo kawakweza wanage na wehe zake mna iwangamia. ");
INSERT INTO kdc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Kawasusila kuulongozi wanyama wake wose, na vinhu vose viyapatile ako Padani Alamu, kafunga mwanza wa kubwela kwa tatake Isaka mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani viyacholile kuwakanha mibahila iwang'hondolo. Laheli keba vinyago viyavitambikilaga tatake. ");
INSERT INTO kdc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo hamulongele bule Labani imualamu kamba kosegela, kamfisa. ");
INSERT INTO kdc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Avo Yakobo kasegela na vinhu vake vose, kaloka lwanda lwa Fulate, kagenda Gileadi, isi ya kukigongo. ");
INSERT INTO kdc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Siku da kadatu, Labani kalongeligwa kamba Yakobo kakimbila. ");
INSERT INTO kdc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Avo, Labani kasola wanhu zake, kamkweleleza Yakobo kwa kipindi cha siku saba, kamvika kuvigongo mwiisi ya Gileadi. ");
INSERT INTO kdc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lakini ikilo, Imulungu kamulawilila Labani imualamu, mwiinzozi kamulongela, “Iteganye sikuumtende Yakobo kinhu chochose kihile.” ");
INSERT INTO kdc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Avo Labani kamvika Yakobo, kipindi acho Yakobo kakala yekile ng'hambi yake kukigongo. Labani nayo na ndugu zake, keka ng'hambi yake kukigongo cha Gileadi. ");
INSERT INTO kdc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labani kamulongela Yakobo, “Kutenda choni? Kumvizila na kuwasola wandele zangu kamba wanhu wagogigwe kuing'hondo. ");
INSERT INTO kdc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Habali kung'himbila kinyelegezi, kumvizila? Wahanongele, nahakulagile kwa deng'ho, kwa nyila kwa ngoma na bango. ");
INSERT INTO kdc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hundekile niwalage kwa kuwanonela wazukulu zangu na wanangu, avo kutenda ubozi. ");
INSERT INTO kdc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nodaha kukutenda vihile, lakini Imulungu wa tatako ikilo cha lelo kanongela, ‘Iteganye sikuumtende Yakobo kinhu chochose kihile.’ ");
INSERT INTO kdc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nojuwa kamba kusegela kwavija kukala usulukila ng'hani kubwela ukae kwa tatako, lakini habali kunibila vinyago vangu vinivitambikila?” ");
INSERT INTO kdc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo kamwidika Labani, “Nidumba, kwavija nigesa wahambokile wandele zako. ");
INSERT INTO kdc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Lakini wahamona munhu yoyose kana vinyago vako, kokomigwa. Mgameso ga ndugu zetu zahila kinhu chochose cha kumwako, na kili chako ukisole.” Yakobo kakala hajuwile bule Laheli kakala yebile vinyago va Labani. ");
INSERT INTO kdc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Avo, Labani kengila mkibanda cha Yakobo, mkibanda cha Lea na mkibanda cha waja watumwa wabili wa kitwanzi, lakini hapatile kinhu bule. Viyalawile mkibanda cha Lea, kengila mkibanda cha Laheli. ");
INSERT INTO kdc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Avo Laheli kakala yavisolile vinyago vija, kavifisa hasi ya mkoba wa kukalila uchanha ya ngamiya na mwenyego kakala uchanha yake. Labani kazahila kila hanhu mkibanda, lakini hapatile kinhu bule. ");
INSERT INTO kdc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Laheli kamulongela tatake, “Sikuugevuzike go mkulu, sidaha bule kwima haulongozi wako, niye notumika.” Kazahila lakini havonile bule vinyago vake. ");
INSERT INTO kdc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo kagevuzika, kagomba na Labani. Yakobo kamuuza Labani, “Kimbanange choni, choni kimbanange mbaka konisaka kamba vino? ");
INSERT INTO kdc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sambi kuzahila mna ivinhu vangu vose, avo kupata choni kili chako? Vike hano mgameso ga ndugu zetu, waleke watutaguse niye na gweye. ");
INSERT INTO kdc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ng'hala na gweye kwa kipindi cha miyaka malongo mabili. Kuduhu ng'hondolo wako na mbuzi wako yalemelwe kulela, na sidile ng'hondolo wako wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kamba ng'hondolo kakomigwa na wanyama wa kumuhulo, niye nikala noliha mwenyego. Gweye kunonda nikulihe kamba yahebigwa imisi hebu ikilo. ");
INSERT INTO kdc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Avo, imisi nikala nolukula na zuwa na ikilo nhoigwa na beho na kuwasa meso. ");
INSERT INTO kdc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Niye ng'hala ukayako miyaka malongo mabili. Nikusang'hanila miyaka longo na nne mbuli ya wandele zako wabili na nikusang'hanila kwa miyaka sita mhate fugo yangu, lakini gweye kugalusa fungu jangu miyanza longo. ");
INSERT INTO kdc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kamba siyo Imulungu wa tatangu, Imulungu wa Abulahamu na Imulungu yamtendile Isaka yamdumbe hakalile na niye, wahaniwingile makono gaiyeka. Lakini Imulungu kalola kugaya kwangu na sang'hano za makono gangu na ikilo cha lelo kakuzuma.” ");
INSERT INTO kdc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani kamwidika Yakobo, “Watwanzi wano wandele zangu, wana wano wanangu, na wanyama wano wangu. Lakini niye notenda choni kwa wandele zangu, hebu kwa wana wawalelile? ");
INSERT INTO kdc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Avo, tutende lagano niye na gweye, diwe usindila mgameso gangu na gweye.” ");
INSERT INTO kdc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Avo, Yakobo kasola dibwe, kadisimika. ");
INSERT INTO kdc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobo kawalongela ndugu zake, “Lundizeni mabwe.” Avo wasola mabwe wagalundiza, na hewo waja ndiya aho behi ya dilundo da gamabwe. ");
INSERT INTO kdc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani kadikema lundo dijo da mabwe, Yegali Sahaduta, lakini Yakobo kadikema Galeedi. ");
INSERT INTO kdc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani kamulongela Yakobo, “Lundo dino dotukumbusa niye na gweye.” Lekaavo twaga jake hakemigwa Galeedi. ");
INSERT INTO kdc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Vivija hanhu aho hakemigwa Misipa, kwavija Labani kalonga, “Mndewa Imulungu yatulolese niye na gweye twahawa baki baki.” ");
INSERT INTO kdc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Labani kagendelela kulonga, “Kamba kowatendela vihile wandele zangu hebu wahasola mtwanzi iyagwe, hata kamba sijuwile, kumbuka Imulungu kotulola.” ");
INSERT INTO kdc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Vivija Labani kamulongela Yakobo, “Lola lundo dino, na mzengo uno unikile hagati yako gweye na niye. ");
INSERT INTO kdc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Lundo dino na mzengo uno votulola, niye sibita mwambu wa lundo dino kwiza kumwako, na gweye sikuwize ubazi wangu kundumiza. ");
INSERT INTO kdc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Imulungu wa Abulahamu na Imulungu wa Naholi na Imulungu wa tatao, watutaguse.” Avo Yakobo kaiduwila kwa twaga da Imulungu iyamtendile tatake Isaka yamdumbe. ");
INSERT INTO kdc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo kachinja mnyama kamulava nhosa kukigongo, kawagoneka wanhu zake waje ndiya. Viwamalile kuja, wawasa kukigongo. ");
INSERT INTO kdc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Imitondo, Labani kawanonela wandele zake na wazukulu zake, kawatambikila abaho kasegela kabwela ukae. ");
INSERT INTO kdc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo viyakalile kochola, wasenga wa kuulanga waiting'hana nayo. ");
INSERT INTO kdc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo viyawone kalonga, “Ino ng'hambi ya Imulungu!” Avo hanhu aho kahakema Mahanaimu. ");
INSERT INTO kdc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo kawatuma wasenga wamulongolele kuchola kwa ndugu yake Esau, mwiisi ya Seili ako Edomu. ");
INSERT INTO kdc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kawalagiza walonge vino, “Mulongeleni vino mkulu wangu Esau, ‘Msang'hanaji wako Yakobo kolonga vino, ng'hala na Labani mbaka sambi. ");
INSERT INTO kdc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nina ng'ombe, na vihongwe, mabumbila ga ng'hondolo na mbuzi na watumwa wa kimbigalo na wa kitwanzi. Avo go mkulu nokugalila usenga uno, ili wahanyona umbonele bazi.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Iwasenga viwabwelile kwa Yakobo, wamulongela, “Tuvika kwa ndugu yako Esau, nayo kamzila kokwiza kukubokela, na kailongoza na wambigalo magana mane.” ");
INSERT INTO kdc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Avo, Yakobo kakala moyo nyunguwaa na bwembwe, kawagola wanhu zake mvibumbila vibili, vivija kawagola ng'hondolo na mbuzi na ng'ombe na ngamiya. ");
INSERT INTO kdc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kagesa muumoyo, “Kamba Esau yaheza na kuditowa bumbila dimoja, bumbila diyagwe dohonyeka.” ");
INSERT INTO kdc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Abaho Yakobo kapula, kalonga, “Go Imulungu wa tatangu Abulahamu na Imulungu wa tatangu Isaka, go Imulungu unongele mbwele mwiisi yangu na mulukolo lwangu na kunongela konhendela ganogile. ");
INSERT INTO kdc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Niye sifaya koneligwa bazi na moyo unogile unitendele niye msang'hanaji wako. Vinilokile mwambu wa Yolidani ng'hala nabule kinhu chochose ila mkongoja, lakini sambi ninago mabumbila gago mabili. ");
INSERT INTO kdc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nokupula unihonye mmakono ga ndugu yangu Esau, kwavija nodumba sikuyeze kututowa wose niye na iwana na mama zao. ");
INSERT INTO kdc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lakini gweye kunongela, ‘Nokutenda umwede na noutenda ulelo wako kamba msanga wa mwhani, haudahika kupetigwa.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Avo, ikilo Yakobo kawasa baho. Abaho kabagula vinhu vake, yamgwee nhunza ndugu yake Esau. ");
INSERT INTO kdc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Zinhunza zikala mbuzi wa kitwanzi magana mabili na mbuzi wa kimbigalo malongo mabili na ng'hondolo wa kitwanzi magana mabili na ng'hondolo wa kimbigalo malongo mabili. ");
INSERT INTO kdc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ngamiya okong'heza malongo madatu hamoja na mabofu gao, ng'ombe wa kitwanzi malongo mane na mibigalo longo, na vihongwe wa kitwanzi malongo mabili na mbigalo longo. ");
INSERT INTO kdc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kawagwaa wasang'hanaji wake, kila imoja na bumbila jake kawalongela, “Nongoleleni kila bumbila diinege na bumbila diyagwe muumwanza wetu.” ");
INSERT INTO kdc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kamulagiza msang'hanaji yalongole, “Ndugu yangu Esau yahakuting'hana na kukuuza, ‘Gweye kwa mtumwa wa nani, na kochola kwahi na wanyama wano walongole wa nani?’ ");
INSERT INTO kdc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Gweye umwidike, ‘Vinhu vino va msang'hanaji wako Yakobo, nhunza ino ya mkulu wangu Esau, na heyo kakuchugu kokwiza.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Vivija kamulagiza munhu wa bumbila da kabili, na da kadatu na wose wayagwe wawasondelele, “Mwahamting'hana Esau mulonge vivo. ");
INSERT INTO kdc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Abaho sikumuisemwe kulonga, ‘Msang'hanaji wako Yakobo kakuchugu kokwiza.’ ” Yakobo katenda avo kuno kogesa, “Sengine nomuhoza kamba wanhu wahalongola na nhunza zino, abaho twahaiting'hana, sengine kombokela.” ");
INSERT INTO kdc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Avo, wanhu walongola na zinhunza, heyo mwenyego kawasa kuing'hambi. ");
INSERT INTO kdc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ikilo Yakobo kalamuka, kawasola wehe zake wabili, watumwa zake wa kitwanzi wabili na wanage longo na imoja, waloka lwanda lwa Yaboki. ");
INSERT INTO kdc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Viyamambukize kuwalosa umwambu, vivija kavilosa vinhu vose viyakalile navo. ");
INSERT INTO kdc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Avo, Yakobo kasigala yaiyeka. Munhu imoja keza, waigela mhambaga mbaka imitootondo. ");
INSERT INTO kdc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Munhu ayo viyone hadaha bule kumuhuma Yakobo, kamtowa mzimbweto mkigudi mbaka katuhuka. ");
INSERT INTO kdc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Abaho munhu ayo kamulongela Yakobo, “Ndeka nichole sambi ocha.” Lakini Yakobo kedika, “Sikuleka uchole mbaka unitambikile.” ");
INSERT INTO kdc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Munhu ayo kamuuza, “Twaga jako nani?” Nayo kamwidika, “Yakobo.” ");
INSERT INTO kdc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Munhu ayo kamulongela, “Sambi hukemigwa Yakobo kabili, lakini kokemigwa Izilaeli kwavija kuihuma na Imulungu na wanhu, na gweye kugangamala.” ");
INSERT INTO kdc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo kamulongela munhu ayo, “Chonde nongela twaga jako.” Lakini munhu ayo kedika, “Habali koniuza twaga jangu?” Abaho kamtambikila. ");
INSERT INTO kdc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo kalonga, “Nimona Imulungu meso kwa meso, na ning'hali mgima.” Avo kahakema hanhu aho Penueli. ");
INSERT INTO kdc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakobo viyakalile kosegela Penueli, zuwa dikala dilawile, kakala koiseseza mbuli ya mbweto zake. ");
INSERT INTO kdc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Avo, Waizilaeli mbaka lelo hawaja bule muge uli mzimbweto za kigudi, kwavija baho itoigwe mbweto ya Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo kamona Esau kokwiza na wanhu zake magana mane, avo, kawagola wanage kumwake Lea, Laheli na waja watumwa wabili. ");
INSERT INTO kdc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Watumwa na wanao kaweka haulongozi, abaho Lea na wanage, kukisogo chao kamwika Laheli na Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakobo mwenyego kalongola, kaidulika mbaka hasi miyanza saba, mbaka viyavikile behi na ndugu yake. ");
INSERT INTO kdc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau kamkimbilila kumbokela Yakobo, kamfagatila na kamnonela, wose wabili wakala olila. ");
INSERT INTO kdc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau viyalolile na kuwona watwanzi na iwana kauza, “Wano weli hamoja na gweye kina nani?” Yakobo kamwidika, “Wano awo wana waja Imulungu kwa bazi jake kanigwaa niye msang'hanaji wako.” ");
INSERT INTO kdc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Abaho waja watumwa wa kitwanzi na wanao wakala mmabehi, waidulika. ");
INSERT INTO kdc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea nayo na wanage keza, kaidulika. Kukimambukizo, Laheli na Yusufu weza, nao waidulika. ");
INSERT INTO kdc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau kauza, “Na bumbila dino diniiting'hane najo mnzila hano dofambula choni?” Yakobo kamwidika, “Go, mkulu, nilonda uninogele.” ");
INSERT INTO kdc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Lakini Esau kamwidika, “Ndugu yangu, na niye nina vinhu vingi, vinhu vako viwe vako mwenyego.” ");
INSERT INTO kdc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo kamulongela, “Bule, kamba kweli kononda, bokela nhunza yangu, kwavija nahalola kihanga chako kamba nolola kihanga cha Imulungu vija viumbokele goya. ");
INSERT INTO kdc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Chonde, togola nhunza inikugalile, kwavija Imulungu kanyonela bazi, kangwaa kila kinhu kinonda.” Avo Yakobo kagendelela kumsusumiza mbaka katogola. ");
INSERT INTO kdc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau kalonga, “Tuchole, na niye nokulongolela.” ");
INSERT INTO kdc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Lakini Yakobo kamulongela, “Mkulu wangu, gweye kojuwa wana wano wang'hali ving'hele, na fugo zino zokong'heza. Avo nolondigwa kuzilola goya. Kamba wanyama wano, ogaligwa mkudu mkudu kwa siku dimoja, wanyama wose wofa. ");
INSERT INTO kdc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Avo, nokupula ulongole na niye nokwiza mholemhole, noziseseza fugo zangu na wanangu mbaka vonda nikuvike ako Seili.” ");
INSERT INTO kdc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau kalonga, “Leka nikulekele wanhu zangu wayagwe.” Lakini Yakobo kalonga, “Aka, sikuutende vivo. Niye nodeng'helela kwavija gweye mkulu wangu koninogela.” ");
INSERT INTO kdc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Avo, siku didija Esau kafunga mwanza wa kubwela Seili. ");
INSERT INTO kdc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakobo kachola mbaka Sukoti. Kazenga ng'anda na fugo zake kazizengela mabumba. Lekaavo hanhu aho hakemigwa Sukosi. ");
INSERT INTO kdc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kulawa kuko Sukoti mwiisi ya Padani Alamu Yakobo kavika goya ako kudibuga da Shekemu mwiisi ya Kanaani, keka ng'hambi behi na buga dijo. ");
INSERT INTO kdc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hanhu aho kuyekile ng'hambi kahagula kulawa mulukolo lwa Hamoli tatake Shekemu kwa vihande gana va shaba. ");
INSERT INTO kdc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Avo, ako kazenga upango wa kulavila nhosa kaukema Eli Elohe Izilaeli, fambulo jake Imulungu ni Imulungu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Avo Dina mndele wake Lea, ija Lea yalelile na Yakobo, kachola kuwatembelela wandele wa isi ayo. ");
INSERT INTO kdc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Baho, Shekemu mwanage Hamoli, Muhivi mkulu wa isi viyamone kamgoga kamuwasa kwa nguvu na kamgela kinyala. ");
INSERT INTO kdc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Moyo wake uilumba na Dina mndele wa Yakobo, kamnogela mndele ayo, kalonga nayo mbuli zamulile. ");
INSERT INTO kdc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekemu kamulongela Hamoli, tatake, “Nisolele mndele ino yawe mwehe wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo viyahulike kamba mndele wake Dina kawasigwa kwa nguvu na Shekemu, kanyamala mbaka viwabwelile wanage kwavija wanage wakala mmigunda na zifugo zose. ");
INSERT INTO kdc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamoli tatake Shekemu, kamcholela Yakobo, kalonga nayo. ");
INSERT INTO kdc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kipindi acho wanage Yakobo wabwela mmigunda. Viwahulike mbuli ayo wagevuzika ng'hani kwavija Shekemu kawaliga wanhu wa Izilaeli kwa kumuwasa kwa nguvu mndele wa Yakobo kinhu kigomesigwe. ");
INSERT INTO kdc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoli kawalongela, “Moyo wa mwanangu Shekemu omulonda mndele wenu. Chonde mulekeni yamsole. ");
INSERT INTO kdc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tuisolele mweye na siye, mutugwee wandele zenu na mweye musole wandele zetu. ");
INSERT INTO kdc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mweye modaha kukala na siye, na isi ino yokuwa haulongozi wenu, kaleni amo muchuuze vinhu venu, na soleni vinhu mumo.” ");
INSERT INTO kdc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Abaho Shekemu kamulongela tatake Dina na iwalumbu, “Nhogoleleni, na niye nowagwaa chochose kimulonda. ");
INSERT INTO kdc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Nongeleni kinhu chochose cha zengele na nhunza, hata zahawa nyingi nolava ili nimsole.” ");
INSERT INTO kdc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Wanage Yakobo wamwidika Shekemu na tatake Hamoli, kwa uvizi, kwavija kamfitiza Dina, lumbu jao. ");
INSERT INTO kdc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wamulongela, “Hatudaha kutenda vivo, lumbu jetu yasoligwe na munhu hengile kumbi. Mbuli kamba ayo yotugela kinyala. ");
INSERT INTO kdc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Lakini towatogolela kwa mbuli ino imoja, muwe kamba siye, kila mbigalo kumwenu yengile kumbi. ");
INSERT INTO kdc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Baho towagwaa mndele wetu, na siye tosola wandele zenu, tokala na mweye, na siye tokuwa kinhu kimoja. ");
INSERT INTO kdc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Lakini mwahalema kwingila kumbi, siye tomsola lumbu jetu na tosegela.” ");
INSERT INTO kdc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mbuli ayo iwanogela Hamoli na mwanage Shekemu. ");
INSERT INTO kdc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mbwanga ayo yakalile yotegelezigwa ng'hani mng'anda ya tatake, hakawile bule kutenda mbuli ayo, kwavija kakala yamnogele mndele wa Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamoli na imwana Shekemu wachola kuna ulwivi lwa dibuga kuko koiting'hanaga na walonga na wambigalo wayao wa buga dijo. ");
INSERT INTO kdc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Wawalongela, “Wanhu wano mbwiga zetu, tuwaleke wakale mwiisi yetu na wachuuze kinhu chochose, isi ino ng'hulu kumwetu siye na wao. Todaha kuwasola wandele zao na wao odaha kusola wandele zetu. ");
INSERT INTO kdc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lakini wanhu wano watogola kukala kumwetu na kuwa kinhu kimoja kwa mbuli ino, siye tuwengize kumbi wambigalo wose kamba hewo viwengile kumbi. ");
INSERT INTO kdc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Vino, ng'hondolo zao, na wanyama wao wose honda wawe kumwetu? Avo, tuilumbe nao, nao okala kumwetu.” ");
INSERT INTO kdc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Avo wambigalo wose wacholile kuna ulwivi wa dibuga wawatogolela Hamoli na mwanage Shekemu, avo kila mbigalo kudibuga kengila kumbi. ");
INSERT INTO kdc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Siku da kadatu kumwande, kuno wang'hali na usungu wa kwingila kumbi, wana wabili wa Yakobo, Simeoni na Lawi lumbu zake Dina, wasola misime yao, wengila kwa kinyelegezi kudibuga wawakoma wambigalo wose. ");
INSERT INTO kdc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wawakoma kwa misime Hamoli na mwanage Shekemu na wamsola Dina mng'anda ya Shekemu wasegela. ");
INSERT INTO kdc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Wana wayagwe wa Yakobo wawezila wanhu awo wafile wavisola vinhu va buga dijo kwavija wamfitiza lumbu jao. ");
INSERT INTO kdc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wasola ng'hondolo na mbuzi na ng'ombe na vihongwe na kila kinhu kikalile kudibuga na mmigunda. ");
INSERT INTO kdc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wasola kila kinhu kinogile, wawagoga watwanzi zao na wanao na walawanya na kila kinhu kikalile mzing'anda. ");
INSERT INTO kdc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakobo kawalongela Simeoni na Lawi, “Mweye mungalila zumozumo na sambi Wakanaani na Wapelizi na kila munhu mwiisi ino konihila. Wanhu zangu niye wadodo kamba awo wose wahailumba ili wanivamile onikoma niye na wanhu wose wa mng'anda yangu.” ");
INSERT INTO kdc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Lakini hewo wamwidika tatao, “Vino, vinoga viwamtendele lumbu jetu kamba mgoni?” ");
INSERT INTO kdc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Imulungu kamulongela Yakobo, “Segela uchole Beseli, ukakale kuko. Kanzengele niye upango wa kulavila nhosa, niye Imulungu nikulawilile viukalile komkimbila ndugu yako Esau.” ");
INSERT INTO kdc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakobo kawalongela wanhu wa mng'anda yake, na wose wakalile hamoja na heyo, “Segeseni minyago yenu ili kumwenu, isunheni, mkasaule viwalo venu. ");
INSERT INTO kdc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tusegele tuchole ako Beseli kuko nomzengela Imulungu upango wa kulavila nhosa, ayo yanidike siku ya kugaya kwangu, kakala hamoja na niye muumwanza wangu wose.” ");
INSERT INTO kdc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wao wamgwaa Yakobo vinyago vose viwavitambikile vikalile mmakono gao na heleni zikalile mmagwiti gao, Yakobo kavihimbila hasi ya biki da mwaloni dikalile ako Shekemu. ");
INSERT INTO kdc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na wanage viwakalile osegela Imulungu kawatenda wanhu wa mabuga gakalile behi wadumbe, avo hawawakweleleze bule. ");
INSERT INTO kdc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Avo, Yakobo hamoja na wanhu wose yakalile nao wavika kudibuga da Luzu, vivija dokemigwa Beseli mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ako kazenga upango wa kulavila nhosa, kahakema hanhu aho Eli Beseli, kwavija ako Imulungu yamulawilile viyakalile komkimbila ndugu yake. ");
INSERT INTO kdc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola msang'hanaji wa Lebeka kafa, kazikigwa ako behi ya Beseli, hasi ya mwaloni. Avo hanhu aho hakemigwa, “Mwaloni wa kuiyalala.” ");
INSERT INTO kdc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo, viyabwelile kulawa Padani Alamu, Imulungu kamulawilila kabili kamtenda yamwede. ");
INSERT INTO kdc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Imulungu kamulongela, “Twaga jako Yakobo, lakini sambi hukemigwa Yakobo kabili, twaga jako dokuwa Izilaeli.” Avo Yakobo kakemigwa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nayo Imulungu kamulongela, “Niye iyo Imulungu nili na Udahi wose, ulele ng'hani na mongezeke. Makabila mengi golawa kumwako na wandewa olawa mkigudi chako. ");
INSERT INTO kdc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Isi iniwagwelele Abulahamu na Isaka vivija nokugwelela gweye, na nowagwelela wanhu wa ulelo wako baho kumwande.” ");
INSERT INTO kdc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Avo, Imulungu kamuleka kulawa hanhu aho kuyakalile kolonga nayo. ");
INSERT INTO kdc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo kasimika dibwe hanhu aho hayalongile na Imulungu, kagida nhunza ya king'waji na vivija kagida mavuta. ");
INSERT INTO kdc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo kahakema hanhu aho hayalongile na Imulungu, Beseli. ");
INSERT INTO kdc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wachola kulawa Beseli, mbaka hasigala hadodo kuvika Efulata, Laheli kagogigwa na usungu wa kulela, usungu wake ukala mkulu. ");
INSERT INTO kdc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Usungu viumgogile ng'hani, imtwanzi yamtazile kulela kamulongela, “Sikuudumbe, kupata mwana iyagwe wa kimbigalo.” ");
INSERT INTO kdc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Viyakalile kotapatapa, kwavija kakala kokanha loho, kamkema imwana Benoni, fambulo jake kunyunyuwala, lakini tatake kamkema Benjamini, fambulo jake kumweda. ");
INSERT INTO kdc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Laheli kafa, kazikigwa mwiinzila ya Efulata, sambi yojuwika kamba Beselehemu. ");
INSERT INTO kdc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo kasimika mhanda uchanha ya panga dijo, na mbaka lelo dojuwika kamba mhanda ya panga da Laheli. ");
INSERT INTO kdc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Abaho Izilaeli kagendelela na mwanza, keka ng'hambi yake mwambu wa kabili wa lingo da Edeli. ");
INSERT INTO kdc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Avo Izilaeli viyakalile mwiisi ija, Lubeni kawasa na Biliha, imoja wa watumwa wa Yakobo yakalile kamba mwehe wake. Nayo Yakobo kaihulika mbuli ayo. Yakobo kakala na wana longo na wabili wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wanage Lea wakala, Lubeni, mwana wa chaudele wa Yakobo, na Simeoni na Lawi na Yuda na Isakali na Zabuloni. ");
INSERT INTO kdc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wanage Laheli wakala, Yusufu na Benjamini. ");
INSERT INTO kdc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wanage Biliha mtumwa wa Laheli wakala, Dani na Nafutali. ");
INSERT INTO kdc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wanage Zilipa mtumwa wa Lea wakala, Gadi na Asheli. Wano awo wana wa kimbigalo wa Yakobo waleleke ako Padani Alamu. ");
INSERT INTO kdc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo keza kwa Isaka, tatake ako Mamule kudibuga da Kiliati Aliba vivija dokemigwa Hebuloni isi kuwakalile Abulahamu na Isaka. ");
INSERT INTO kdc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka kakala miyaka gana na malongo manane. ");
INSERT INTO kdc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaka kafa kuno mvele na kauja ng'hani, kailumba na wahenga zake wafile umwaka. Iwana Esau na Yakobo wamzika tatao. ");
INSERT INTO kdc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Uno awo ulelo wa Esau, vivija kokemigwa Edomu. ");
INSERT INTO kdc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau kasola wehe mna iwandele wa isi ya Kanaani. Ada mndele wa Eloni, Muhiti, na Oholibama mndele wa Anaho na mzukulu wa Sibeoni Muhivi, ");
INSERT INTO kdc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","vivija kamsola Basemati mndele wa Ishimaeli lumbu jake Nebayosi. ");
INSERT INTO kdc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada kamulelela Esau, Elifazi, na Basemati kamulelela Leueli, ");
INSERT INTO kdc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","na Oholibama kamulela Yeushi na Yalamu na Kola. Wano wao wanage Esau, waleligwe na wehe zake wadatu ako kuna iisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau kasola wanage na wehe zake na wose wakalile mng'anda yake na fugo zake na vinhu vose viyakalile navo ako Kanaani kachola isi ili kutali na ndugu yake Yakobo. ");
INSERT INTO kdc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Wakala na vinhu vingi avo hawadahile bule kukala hamoja, isi iwakalile haidahile bule kwenela fugo zao zose. ");
INSERT INTO kdc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Lekaavo Esau, vivija kokemigwa Edomu, kakala kuna iisi ya vigongo va Seili. ");
INSERT INTO kdc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Uno uwo ulelo wa Esau muhenga wa wanhu wa Edomu okala kuna iisi ya vigongo va Seili. ");
INSERT INTO kdc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Gano gago matwaga ga wana wa kimbigalo wa Esau, Elifazi mwanage Ada mwehe wake Esau na Leueli mwanage Basemati mwehe wake Esau. ");
INSERT INTO kdc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wanage Elifazi wakala Temani na Omali na Sefo na Gatamu na Kenazi. ");
INSERT INTO kdc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Vivija Elifazi mwanage Esau kakala na mtumwa wa kitwanzi yakalile kamba mwehe wake kakemigwa Timina, ayo nayo kamulelela mwana yakemigwe Amaleki. Wana wao wazukulu wa Esau kwa mwehe wake Ada. ");
INSERT INTO kdc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wanage Leueli wakala, Nahasi na Zela na Shama na Miza. Wano awo wazukulu wa Esau kwa mwehe wake Basemati. ");
INSERT INTO kdc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Wano awo wanage Oholibama mndele wa Anaho mzukulu wa Sibeoni. Kamulelela mkasano wake Esau wana wadatu, Yeushi na Yalamu na Kola. ");
INSERT INTO kdc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Wano awo wakalile iwakulu mna zing'holo za wazukulu wa Esau. Wanage Elifazi chaudele wa Esau, Temani na Omali na Sefo na Kenazi, ");
INSERT INTO kdc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kola na Gatamu na Amaleki. Wano wao iwakulu muulelo wa Elifazi ako Edomu, wakala wazukulu wa Ada. ");
INSERT INTO kdc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Na Leueli, mwanage Esau, kawalela Nahasi na Zela na Shama na Miza, wano wao iwakulu walawile kwa Leueli ako Edomu, wakala wazukulu wa Basemati, mwehe wa Esau. ");
INSERT INTO kdc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wanage Oholibama, mwehe wake Esau wakala, Yeushi na Yalamu na Kola. Wano awo iwakulu walawile kwa Oholibama mndele wa Anaho. ");
INSERT INTO kdc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Wano awo wanhu wa ulelo wa Esau, vivija kokemigwa Edomu, na wano awo iwakulu. ");
INSERT INTO kdc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Wano awo wanage Seili, Muholi na vivija awo wenekae wa isi ayo. Lotani na Shobali na Sibeoni na Anaho, ");
INSERT INTO kdc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni na Eseli na Dishani wano awo iwakulu walawile kwa Waholi na wanage Seili ako mwiisi ya Edomu. ");
INSERT INTO kdc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wanage Lotani wakala, Holi na Hemamu. Lotani kakala na lumbu jake yokemigwa Timina. ");
INSERT INTO kdc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wanage Shobali wakala, Alivani na Manahati na Ebali na Shefo na Onamu. ");
INSERT INTO kdc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wanage Sibeoni wakala, Aya na Anaho. Anaho iyo yonile nzasa ya mazi ga moto ako kuluwala, viyakalile kowasusila ivihongwe wa Sibeoni tatake. ");
INSERT INTO kdc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wanage Anaho wakala, Dishoni na Oholibama mndele wa Anaho. ");
INSERT INTO kdc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wanage Dishoni wakala, Hemadani na Eshibani na Isilani na Kelani. ");
INSERT INTO kdc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wanage Eseli wakala, Bilihani na Zaawani na Akani. ");
INSERT INTO kdc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wanage Dishani wakala, Usi na Alani. ");
INSERT INTO kdc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Wano awo iwakulu kwa Waholi, Lotani na Shobali na Sibeoni na Anaho, ");
INSERT INTO kdc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoni na Eseli na Dishani, kila imoja kakala mkulu mulukolo lwake mwiisi ya Seili. ");
INSERT INTO kdc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Avo wano awo wandewa watawale ako mwiisi ya Edomu, kipindi acho wanhu wa Izilaeli hawanatawaligwa na mndewa yoyose. ");
INSERT INTO kdc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwanage Beoli katawala ako Edomu, na twaga da buga jake dikala Dinihaba. ");
INSERT INTO kdc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela viyadanganike, Yobabu mwanage Zela, kulawa isi ya Bosila kawa mndewa hanhu hake. ");
INSERT INTO kdc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu viyadanganike, Hushamu kulawa isi ya Watemani kawa mndewa hanhu hake. ");
INSERT INTO kdc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu viyadanganike, Hadadi mwanage Bedadi, ayo yawahumile iwakalizi wa Midiani ako mwiisi ya Moabu, kawa mndewa hanhu hake. Buga jake dikemigwa Aviti. ");
INSERT INTO kdc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi viyadanganike, Samila kulawa mwiisi ya Masileka, katawala hanhu hake. ");
INSERT INTO kdc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samila viyadanganike, Shauli kulawa Lehoboti behi ya lwanda lwa Fulate, kawa mndewa hanhu hake. ");
INSERT INTO kdc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli viyadanganike, Baali Hanani mwanage Akiboli kawa mndewa hanhu hake. ");
INSERT INTO kdc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali Hanani mwanage Akiboli viyadanganike, Hadadi kawa mndewa hanhu hake. Twaga da buga jake dikemigwa Pau, na twaga da imwehe kakemigwa Mehetabeli biti Matiledi mzukulu wa Mezahabu. ");
INSERT INTO kdc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Wano awo wakalile iwakulu muulelo wa Esau, wekigwa kwa matwaga gao na ng'holo zao na isi zao, mkulu Timina na mkulu Aliva na mkulu Yesesi, ");
INSERT INTO kdc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na mkulu Oholibama na mkulu Ela na mkulu Pinoni, ");
INSERT INTO kdc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na mkulu Kenazi na mkulu Temani na mkulu Mibisali, ");
INSERT INTO kdc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","mkulu Magidieli na mkulu Ilamu. Wano awo wakalile iwakulu ako Edomu. Watambuligwa kamba viwakalile okala mwiisi ayo. Esau ayo muhenga wa wanhu wa Edomu. ");
INSERT INTO kdc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo kakala mwiisi iyakalile tatake, isi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ino ayo simulizi ya Yakobo na wanage. Yusufu viyakalile na miyaka longo na saba, kakala kosusila bumbila da fugo hamoja na ndugu zake. Nayo kakala mbwanga hamoja na wanage Biliha, na wanage Zilipa, wehe wa tatake. Nayo Yusufu kamulongelaga tatake gose gehile ga ndugu zake. ");
INSERT INTO kdc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Avo, Izilaeli kamnogela ng'hani Yusufu kubanza wanage wose, kwavija kamulela muuvele, na kamsonela kanzu tali dinogile. ");
INSERT INTO kdc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ndugu zake viwonile tatao komnogela ng'hani Yusufu kubanza hewo wose, wamwihila na hawalongile nayo kwa tindiwalo. ");
INSERT INTO kdc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yusufu kalota nzozi, na viyawalongele ndugu zake, avo wabanza kumwihila. ");
INSERT INTO kdc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kawalongela, “Chonde, tegelezeni nzozi ino indotile, ");
INSERT INTO kdc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","siye tukala kumgunda tofunga makinza ga ngano, bahaja kinza jangu dima wima, na makinza genu gema kuzunguluka kinza jangu, abaho gadifugamila.” ");
INSERT INTO kdc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ndugu zake wamulongela, “Vino, kogesa gweye kokuwa mndewa na kututawala siye?” Avo, wengeza kumwihila ng'hani mbuli ya nzozi yake na gaja gayalongaga mbuli yao. ");
INSERT INTO kdc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Abaho kalota nzozi iyagwe, na kawalongela ndugu zake, kawalongela, “Loleni nilota nzozi iyagwe, avo zuwa na mbalamwezi na nhondo longo na imoja vikala vinifugamila.” ");
INSERT INTO kdc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Viyamulongele tatake hamoja na ndugu zake, tatake kamkomhokela kamulongela, “Nzozi gani ayo yuulotile? Vino niye na mamako na ndugu zako tokufugamila mbaka hasi?” ");
INSERT INTO kdc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ndugu zake wamonela migongo, lakini tatake keka mbuli ayo muumoyo. ");
INSERT INTO kdc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Siku dimoja ndugu zake wachola kususila ng'hondolo wa tatao ako Shekemu, ");
INSERT INTO kdc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","na Izilaeli kamulongela Yusufu, “Gweye kojuwa ndugu zako, osusila ng'hondolo ako Shekemu, avo izo nikutume kumwao.” Yusufu kedika, “Ona.” ");
INSERT INTO kdc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Avo kamulongela, “Genda kawalole kamba wose ogendelela goya hamoja na zifugo zose, abaho ubwele unongele.” Avo Yakobo kamtuma kulawa kubonde da Hebuloni. Yusufu viyavikile ako Shekemu, ");
INSERT INTO kdc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","kamvika munhu kokwanga mmigunda, munhu ija kamuuza, “Kozahila choni?” ");
INSERT INTO kdc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu kedika, “Nowazahila ndugu zangu. Chonde nongela osusila kwahi?” ");
INSERT INTO kdc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Munhu ayo kalonga, “Hano wahalawa, niwahulika olonga ochola Dosani.” Avo Yusufu kagendelela kuwazahila ndugu zake kawavika ako Dosani. ");
INSERT INTO kdc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Avo ndugu zake wamona toka yeli kutali, na yang'hali hanavika wakala kiseto cha kumkoma. ");
INSERT INTO kdc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wailongela, “Amweye, ayo nyamiloto kokwiza. ");
INSERT INTO kdc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mulopole tukamkome na tumwase kudisima dimoja dili hano, abaho tulonge kadigwa na mng'onyo. Tulole nzozi zake zokuwa kwahi.” ");
INSERT INTO kdc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Lubeni viyahulike vivo kageza kumuhonya na makono gao, kalonga, “Bule, sikutumkome. ");
INSERT INTO kdc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Sikumwite damu ya munhu. Mwaseni kudisima dino dili hano kuluwala, lakini sikummulumize.” Lubeni kalonga avo ili yamuhonye kulawa mmakono gao abaho yambweze kwa tatake. ");
INSERT INTO kdc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Avo Yusufu viyavikile kwa ndugu zake, wamsaula kanzu jake ditali diyavalile, ");
INSERT INTO kdc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","na wamgoga wamwasa kudisima dijo. Avo kudisima dijo kukala kuduhu mazi, dikala dinyalile. ");
INSERT INTO kdc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Viwakalile hasi na kuja, wenula vihanga vao, wawona mwanza wa Waishimaeli olawa Gileadi ochola Misili. Ngamiya wao wakala wapapile ubani na mkegeni na manemane. ");
INSERT INTO kdc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda kawalongela ndugu zake, “Vino topata choni twahamkoma ndugu yetu na kulufisa lukuli lwake? ");
INSERT INTO kdc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Lekeni tumchuuze kwa Waishimaeli wano, na makono getu sikugamulumize kwavija ino ndugu yetu wa usungu.” Ndugu zake wamtogolela. ");
INSERT INTO kdc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Viwabitile wachuuzi Wamidiani, ndugu zake Yusufu wamulava kudisima, wamchuuza kwa Waishimaeli kwa vihande malongo mabili va shaba, awo wamsola Yusufu mbaka Misili. ");
INSERT INTO kdc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lubeni viyabwelile kudisima, na viyone Yusufu kamduhu, kadega kiwalo chake kwa usungu. ");
INSERT INTO kdc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kawacholela ndugu zake kalonga, “Imbwaga kamduhu muja, na niye nichole kwahi?” ");
INSERT INTO kdc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Avo, wachinja bofu da mbuzi, wadivabika dikanzu mwiidamu. ");
INSERT INTO kdc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Abaho wamgalila tatao dikanzu, wamulongela, “Tudidondola kanzu dino, tanhu dilole goya kamba da mwanago hebu siyo.” ");
INSERT INTO kdc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kadijuwa kalonga, “Ona, dino kanzu da mwanangu Yusufu, kadigwa na mng'onyo, loo, mwanangu kadegigwa degigwa.” ");
INSERT INTO kdc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Abaho Yakobo kadega kiwalo chake kwa usungu, kavala gunia. Kamulilila mwanage kwa siku nyingi. ");
INSERT INTO kdc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanage wose, wa ikimbigalo kwa wa ikitwanzi weza kumuhoza umoyo tatao, lakini kalema kuhozigwa umoyo, kalonga, “Bule, nogendelela kumuyalalila mwanangu mbaka vonda nichole hasi kuna iisi ya wafile kuyali.” Avo, Yakobo kagendelela kumuyalalila Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kipindi acho ako Misili awo Iwamidiani wamchuuza Yusufu kwa Potifa, imoja wa iwakulu wa mndewa Falao, ayo kakala mkulu wa iwakalizi wa ng'anda ya mndewa. ");
INSERT INTO kdc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Avo, kipindi acho, Yuda kawaleka ndugu zake, kachola kukala na munhu imoja mwenekae wa Adulami twaga jake Hila. ");
INSERT INTO kdc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Viyakalile kuko kamona mndele wa Shua, munhu wa isi ya Kanaani. Yuda kamsola mndele ayo kawa mwehe wake, ");
INSERT INTO kdc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","kagoga inda, kalela mwana wa kimbigalo, twaga jake wamkema Eli. ");
INSERT INTO kdc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kagoga inda kabili kalela mwana wa kimbigalo, twaga jake wamkema Onani. ");
INSERT INTO kdc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Abaho kalela mwana wa kadatu, vivija wa kimbigalo, twaga jake wamkema Shela. Shela viyavumbuke Yuda kakala Kezibu. ");
INSERT INTO kdc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda kamsolela mwehe mwanage wa chaudele Eli, twaga da mwehe ayo Tamali. ");
INSERT INTO kdc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Lakini Eli, chaudele wa Yuda katenda gehile mgameso ga Mndewa Imulungu, avo Mndewa kamkoma. ");
INSERT INTO kdc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Avo, Yuda kamulongela Onani, “Mwingilile mwehe wa ndugu yako, kwavija vivo ulondigwa kutenda ukamulelele ndugu yako wana.” ");
INSERT INTO kdc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Lakini Onani kakala yajuwile kamba wana awo honda wawe wake, avo viyamwingilile mwehe wa ndugu yake, ketila hasi zimbeyu na kamnyima ndugu yake wana. ");
INSERT INTO kdc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Avo mbuli ayo yaitendile haimnogele bule Mndewa Imulungu, avo kamkoma. ");
INSERT INTO kdc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda kamulongela imukwe, “Kala ugane mng'anda ya tatako mbaka mwanangu Shela vonda yawe mbala goya.” Kwavija kagesa, “Sambi yafe kamba ndugu zake.” Avo Tamali kachola kukala mng'anda ya tatake. ");
INSERT INTO kdc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Siku heleketwaa zibita, mndele wa Shua mwehe wa Yuda kafa. Yuda viyamambukize gamatanga, kasegela na mbwigake Hila, munhu wa Adulami wachola Timina kwa wanhu wakalile okanha mibahila ya ng'hondolo wake. ");
INSERT INTO kdc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali viyahulike kamba tatake mkwe kamnzila kochola Timina kukanha mibahila ya ng'hondolo wake, ");
INSERT INTO kdc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","kasaula kiwalo chake cha ugane, kaigubika mtandio, abaho kakala hasi hana ulwivi lwa Enaimu, ukalile mnzila ya kuchola Timina. Kuno kagesa kamba Shela kakala mbala goya, lakini hagweleligwe bule yawe mkasano wake. ");
INSERT INTO kdc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda viyamonile kagesa kakala mtwanzi mgoni, kwavija kakala yagubike ikihanga. ");
INSERT INTO kdc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kakala hajuwile bule kamba kakala mkwe yake, avo kabaguka hamgwazo mnzila, kalonga, “Nolonda kuwasa na gweye.” Tamali kamuuza, “Nahatogola kongwaa choni?” ");
INSERT INTO kdc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kamwidika, “Nokugwaa bofu da mbuzi dili mdibumbila jangu.” Nayo kamulongela, “Wike kinhu kulagusa kamba kongalila ajo dibofu da mbuzi.” ");
INSERT INTO kdc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda kamuuza, “Kolonda nike choni?” Tamali kedika, “Ngwelele acho ikinhu kili na kilaguso chako na nzabi yake hamoja na mkongoja uugogile.” Avo Yuda kamgwaa, abaho kamuwasa nayo kagoga inda. ");
INSERT INTO kdc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Avo, Tamali kachola ukae kumwake, kasaula mtandio wake, kavala kabili viwalo vake va ugane. ");
INSERT INTO kdc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda kagala bofu da mbuzi kwa mkono wa mbwigake munhu wa Adulami ili yapate vinhu vake viyekile kwa mtwanzi ayo, lakini hamvikile bule. ");
INSERT INTO kdc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kawauza wenekae wa aho, “Kakwahi mtwanzi ija imgoni yakalile mnzila ya kuchola Enaimu?” Wamwidika, “Hano hanakala mtwanzi mgoni bule.” ");
INSERT INTO kdc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Avo kabwela kwa Yuda kamulongela, “Simonile bule! Na iwenekae wa aho wanongela hanakala mtwanzi yoyose mgoni kumwao.” ");
INSERT INTO kdc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda kalonga, “Muleke yakale navo vinhu avo, bule wanhu otuseka. Gweye kuchola kumgalila bofu da mbuzi, lakini humvikile bule.” ");
INSERT INTO kdc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Avo, viibitile miyezi midatu Yuda kalongeligwa, “Mkwe yako Tamali sambi mgoni, na vino sambi kana inda mbuli ya ugoni.” Yuda kalagiza, “Mulaveni kunze mumsome moto.” ");
INSERT INTO kdc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Viwakalile omulava kunze, Tamali katuma usenga kwa tatake mkwe, ulonga, “Munhu mwene vinhu vino iyo yangelile inda.” Kalonga, “Vilole goya, vinhu vino va nani, pete ino na nzabi na mkongoja uno.” ");
INSERT INTO kdc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda kavijuwa vinhu avo na kalonga, “Tamali katenda goya kubanza niye. Ona kwavija hasoligwe bule na mwanangu Shela.” Toka siku dijo Yuda hawasile kabili na Tamali. ");
INSERT INTO kdc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kipindi cha kuifungula vikivikile wajuwa kamba kakala na wana wabili wa kimbigalo mna iinda. ");
INSERT INTO kdc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Viyakalile koifungula, mwana imoja kalava mkono, avo imng'hunga kasola luzi ludung'hu kamfunga mumkono kalonga, “Ino ayo yasongile kuvumbuka.” ");
INSERT INTO kdc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Lakini mwana ayo kaubweza mkono wake mgati, miyage iyo yasongile kuvumbuka. Imng'hunga kalonga, “Mbona gweye kubita kwa nguvu!” Avo kamkema Pelesi. ");
INSERT INTO kdc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Abaho ndugu yake yakalile na luzi ludung'hu mumkono kalawa kunze, nayo wamkema Zela. ");
INSERT INTO kdc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Avo, Yusufu kagaligwa Misili. Mmisili imoja yakemigwe Potifa, yakalile imoja wa iwakulu wa Falao, na kakala mkulu wa iwakalizi wa ng'anda ya mndewa, kamgula kulawa kwa Waishimaeli awo. ");
INSERT INTO kdc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mndewa Imulungu kakala na Yusufu na kamtenda yamwede, kakala mng'anda ya mkulu ayo Mmisili. ");
INSERT INTO kdc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mkulu ayo viyajuwile kamba Mndewa Imulungu kakala na Yusufu na Mndewa kamtenda yamwede kwa kila kinhu kiyatendile, ");
INSERT INTO kdc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","avo, Yusufu kanogeligwa na Potifa na kamtenda yawe mtumwa wake heyo mwenyego, kamwika yawe mwimilizi wa ng'anda yake na yalolese vinhu vake vose. ");
INSERT INTO kdc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kulawa kipindi Potifa kiyamtendile mwimilizi wa ng'anda yake na kila kinhu kiyakalile nacho, Mndewa Imulungu kamtenda Mmisili ayo yamwede mbuli ya Yusufu. Kumweda ako kukala mna ikila kinhu kiyakalile nacho mng'anda yake na kumgunda. ");
INSERT INTO kdc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Avo Potifa keka kila kinhu mmakono ga Yusufu, na hatendile kinhu chochose, ila ndiya iyadile. Yusufu kakala yanenehe na yanogile. ");
INSERT INTO kdc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Avo, kukala na kipindi mwehe wa mkulu wake, kamsulukila Yusufu, kamulongela, “Wasa na niye.” ");
INSERT INTO kdc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Lakini Yusufu kalema, kamulongela, “Lola mkulu wangu halola kinhu chochose mng'anda, kwavija niye nabahano. Kila kinhu kakika mmakono gangu. ");
INSERT INTO kdc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kuduhu munhu mng'anda ino konibanza niye. Mkulu wangu hangomese kugoga kinhu chochose ila gweye kwavija kwa mwehe wake. Avo habali nitende ubananzi awo, nimtendele Imulungu nzambi?” ");
INSERT INTO kdc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hamoja mtwanzi ayo kagendelela kumnanahiza Yusufu, lakini Yusufu kalema kuwasa nayo hebu kukala nayo. ");
INSERT INTO kdc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lakini siku dimoja, Yusufu kengila mng'anda kusang'hana sang'hano yake, mng'anda kukala kuduhu mtumwa iyagwe. ");
INSERT INTO kdc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Avo mwehe wake Potifa kagoga kanzu jake, kamulongela, “Wasa na niye.” Lakini Yusufu kamulekela idikanzu mmakono gake, kakimbila kunze. ");
INSERT INTO kdc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mtwanzi ayo viyone Yusufu kamulekela kanzu jake na kukimbila kunze, ");
INSERT INTO kdc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kawakema watumwa wa ng'anda yake kawalongela, “Loleni, mkasano wangu katugalila Muebulania yatulige! Kengila mng'anda yawase na niye, lakini niguta nyangi. ");
INSERT INTO kdc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Viyamhulike noguta nyangi, kaleka kanzu jake, kakimbila kunze.” ");
INSERT INTO kdc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Avo mtwanzi ayo kadika goya dikanzu jake, mbaka mkasano wake viyabwelile ukae. ");
INSERT INTO kdc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Abaho kampetela mbuli ayo, kalonga, “Mtumwa ino Muebulania yuutugalile keza kumwangu kungela kinyala, ");
INSERT INTO kdc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","lakini vinigutile nyangi, kandekela kanzu jake, kakimbila kunze.” ");
INSERT INTO kdc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Avo mkulu ayo wa Yusufu viyahulike mbuli za mwehe wake, kamba vivo viyatendile mtumwa wake, kagevuzika ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kamsola Yusufu kamgodeka mkifungo, aho hawagodekigwe wabananzi wa mndewa. ");
INSERT INTO kdc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Lakini Mndewa Imulungu kakala hamoja nayo, kamonela bazi, kamtenda yanogeligwe mgameso ga mkulu wa ikifungo. ");
INSERT INTO kdc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Avo mkulu wa ikifungo kamtenda Yusufu yawe mkulu wa wafungwa wose wakalile mkifungo, kila kinhu kitendigwa mmakono gake. ");
INSERT INTO kdc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mkulu wa ikifungo hadumbile kinhu chochose kikalile mmakono ga Yusufu, kwavija Mndewa Imulungu kakala hamoja na Yusufu, avo kila kinhu kakitenda kinoge. ");
INSERT INTO kdc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kipindi kiyagwe kumwande, mkulu wa ung'waji na mkulu wa koka magate wa mndewa Falao wamgevuza mndewa ayo. ");
INSERT INTO kdc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falao kawagevuzikila wakulu awo wabili. ");
INSERT INTO kdc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kawagodeka mwiing'hambi ya mkulu wa wakalizi, hanhu aho hayagodekigwe Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wakala mkifungo kwa kipindi fulani na mkulu wa wakalizi kamsagula Yusufu yawasang'hanile wakulu awo wabili. ");
INSERT INTO kdc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Siku dimoja ikilo wakulu awo wabili walota nzozi, kila munhu kalota nzozi yake, mkulu wa ung'waji kalota nzozi ili na fambulo jake na mkulu wa koka magate kalota nzozi ili na fambulo jake. ");
INSERT INTO kdc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Imitondo yake Yusufu viyacholile kuwalola wakulu awo wabili, kawona onyawanyawa. ");
INSERT INTO kdc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Avo Yusufu kawauza wakulu awo wa Falao wakalile wagodekigwe hamoja na heyo mwenyego mna ing'hambi ya mkulu wa wakalizi, kawauza, “Habali lelo vihanga venu vogela bazi?” ");
INSERT INTO kdc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wamwidika, “Siye wose tulota nzozi, lakini kuduhu munhu wakutufambulila nzozi zetu.” Yusufu kawalongela, “Imulungu iyo yodaha kufambula, nongeleni nzozi zenu.” ");
INSERT INTO kdc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Avo mkulu wa ung'waji kamsimulila Yusufu nzozi yake, kalonga, “Mna inzozi niye nyona mzabibu kuulongozi wangu, ");
INSERT INTO kdc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mzabibu awo ukala na matambi madatu. Bahaja viusongile kuzuka mijani, maluwa gake galela vimvaba va zabibu zipile. ");
INSERT INTO kdc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ng'hala ngogile kikasi cha Falao mmakono gangu, avo nizisola zabibu azo nizikamila mkikasi acho, nimgwaa Falao.” ");
INSERT INTO kdc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu kamulongela mkulu ayo, “Fambulo da nzozi yako ijo dino, matambi ago madatu gauwone azo siku ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Zahabita siku ndatu Falao kokulava mkifungo na kokubweza kabili muukulu wako. Na gweye komgwaa kabili Falao kikasi cha ung'waji kamba viutendile aho umwaka. ");
INSERT INTO kdc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Lakini chonde sikuunisemwe wahalawa kunze unyonele bazi na unitambule mgameso ga Falao, ili ndawe mkifungo. ");
INSERT INTO kdc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kwavija niye nitolosigwa kulawa mwiisi ya Waebulania na hano Misili sitendile mbuli yoyose ihile ya kunhenda nigodekigwe.” ");
INSERT INTO kdc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ija imkulu wa koka magate viyone kamba kafambula vinogile, kamulongela Yusufu, “Na niye vivija nilota nzozi! Mna inzozi yangu ng'hala mhapile mdipala jangu migelo midatu ya magate. ");
INSERT INTO kdc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mna ikigelo cha uchanha kukala na vinhu vingi va kuja mbuli ya Falao, lakini ndege wakala woja kulawa mkigelo acho kuko kudipala jangu.” ");
INSERT INTO kdc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu kamulongela, “Fambulo da nzozi yako ijo dino, ija imigelo midatu ni siku ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Zahabita siku ndatu Falao kokulava mkifungo kokanha pala jako na kokutumbika mdibiki, na ndege oluja lukuli lwako.” ");
INSERT INTO kdc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Avo siku da kadatu kumwande, ikala siku ya kukumbuka kuvumbuka kwa Falao, avo kawagoneka wakulu zake wose mna inyimwilinyimwili, kawalava mkifungo mkulu wa ung'waji na mkulu wa koka magate, kaweka mgameso ga wakulu wose yawagoneke. ");
INSERT INTO kdc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Abaho kambwezela ukulu wake mkulu wa ung'waji ili yamgwee kikasi cha ung'waji. ");
INSERT INTO kdc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Lakini ija imkulu wa koka magate kamtumbika mdibiki, kamba Yusufu viyawafambulile nzozi zao. ");
INSERT INTO kdc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lakini ija imkulu wa ung'waji kamsemwa Yusufu na hamkumbuke bule. ");
INSERT INTO kdc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Viibitile miyaka mibili, Falao kalota nzozi kema mumgwazo wa lwanda lwa Naili, ");
INSERT INTO kdc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","kawona ng'ombe saba wanogile na wanenehe wakala olawa muulwanda na wasonga kuja misanze. ");
INSERT INTO kdc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Abaho walawilila ng'ombe saba wayagwe wakala wasokile na weha ng'hani walawa muulwanda lwa Naili, weza wema behi na waja iwang'ombe wayagwe mumgwazo wa ulwanda. ");
INSERT INTO kdc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ng'ombe awo wasokile na wehile wawaja waja wayagwe saba wakalile wanogile na wanenehe. Baho Falao kalamuka muutulo. ");
INSERT INTO kdc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Viyawasile kabili kalota lwa kabili. Kona makungwi saba makulu na ganoga gazuka kulawa mna dibelege dimoja. ");
INSERT INTO kdc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Abaho galawilila makungwi saba gayagwe masisili na ganyalile kwa vuke da zuwa. ");
INSERT INTO kdc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Gago gamakungwi saba masisili gagameza gaja gamakungwi saba makulu gamemile uhule. Baho Falao viyalamuke kajuwa kamba kakala kolota. ");
INSERT INTO kdc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Imitondo yake, Falao kanyawanyawa ng'hani, kawakema iwahawi wose wa isi ya Misili na wanhu wabala, kawalongela nzozi zake, lakini kuduhu hata imoja yadahile kumfambulila nzozi azo. ");
INSERT INTO kdc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Abaho ija imkulu wa ung'waji kamulongela Falao, “Lelo nokumbuka ubozi wangu! ");
INSERT INTO kdc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kipindi kija viutugevuzikile siye wasang'hanaji zako niye na ija imkulu wa koka magate, kutugodeka mna ing'hambi ya mkulu wa wakalizi. ");
INSERT INTO kdc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kilo kimoja tulota nzozi, kila munhu kalota nzozi ili na fambulo jake. ");
INSERT INTO kdc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Avo mbwanga imoja Muebulania, mtumwa wa mkulu wa wakalizi kakala hamoja na siye mkifungo. Vitumulongele nzozi zetu, heyo katufambulila nzozi zetu kila munhu kamba viili. ");
INSERT INTO kdc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Viyatufambulile vivo viilawilile, niye nibwezigwa mwiisang'hano yangu na ija imkulu wa koka magate katumbikiga mdibiki.” ");
INSERT INTO kdc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Avo, Falao kalagiza Yusufu yagaligwe, nao wamulava mkifungo wambea mvili na kasaula viwalo vake, kagaligwa kuulongozi wa Falao. ");
INSERT INTO kdc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falao kamulongela Yusufu, “Niye nilota nzozi, lakini kuduhu munhu yodaha kufambula. Nihulika wanhu okutogola kamba munhu yahakusimulila nzozi yake kodaha kuifambula.” ");
INSERT INTO kdc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu kamwidika Falao, “Niye nabule udahi awo, lakini Imulungu kokwidika kamba viulonda.” ");
INSERT INTO kdc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Falao kamulongela Yusufu, “Nilota nima mumgwazo wa lwanda lwa Naili, ");
INSERT INTO kdc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","niwona ng'ombe saba wanogile na wanenehe walawa muulwanda na wasonga kuja misanze. ");
INSERT INTO kdc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Abaho weza ng'ombe saba wayagwe wanyolile na wasisili na wasoka ng'hani. Niye sinawona ng'ombe kamba awo mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Avo, waja iwang'ombe saba wasokile ng'hani wawaja waja iwang'ombe saba wanenehe. ");
INSERT INTO kdc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Lakini viweshilize kuwaja kuduhu munhu yodaha kujuwa kamba wawaja wayao. Kwavija wakala wasokile vivija va ichanduso. Baho nilamuka muutulo. ");
INSERT INTO kdc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Abaho nilota kabili, nigona makungwi saba ganogile gamema uhule gazuka kulawa mdibelege dimoja. ");
INSERT INTO kdc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Abaho galawilila makungwi saba gayagwe gabule kinhu masisili na ganyala kwa vuke da zuwa. ");
INSERT INTO kdc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na makungwi gago saba masisili gagameza gaja makungwi saba ganogile. Avo niye niwalongela wahawi nzozi zino, na kuduhu munhu yadahile kunifambulila.” ");
INSERT INTO kdc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Abaho Yusufu kamulongela Falao, “Nzozi zako mbili fambulo jake dimoja. Imulungu kakugubulila gaja goyolonda kutenda kipindi kiguhi kikwiza. ");
INSERT INTO kdc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ng'ombe saba wanogile ofambula miyaka saba, na gaja makungwi saba ganogile vivija gofambula miyaka saba, nzozi azo fambulo jake dimoja. ");
INSERT INTO kdc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Waja ng'ombe saba wasokile ng'hani wezile aho kumwande na gaja makungwi saba gelibule kinhu ganyalile kwa vuke da zuwa, fambulo jake ni miyaka saba ya lufilili lwa nzala. ");
INSERT INTO kdc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kamba vinikulongele mndewa Falao, Imulungu kakugubulila gaja goyolonda kutenda kipindi kiguhi kikwiza. ");
INSERT INTO kdc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hokuwa na miyaka saba ya mulao mwiisi yose ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Lakini kumwande yokwiza miyaka saba ya lufilili lwa nzala, hata awo umulao osemwigwa mwiisi ya Misili. Lufilili alo lwa nzala loinanga isi ino. ");
INSERT INTO kdc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mulao osemwigwa kwavija nzala ikwiza yokuwa ng'hulu ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nzozi ayo ibweleligwa miyanza mibili kila imoja viyagwe kukulagusila kamba Imulungu kagesa kutenda vivo, na kotenda mbuli ayo kipindi kiguhi kikwiza. ");
INSERT INTO kdc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Avo go mkulu Falao, usagule munhu yeli na nzewele na ubala, umgwee ng'honde ya kuilolesa isi yose ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Abaho go mkulu Falao, usagule wemilizi mwiisi yose, uwalagize weke mgelo umoja mna imigelo mitano ya ndiya yose ya Misili mna ikipindi cha miyaka saba ya mulao. ");
INSERT INTO kdc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Uwalagize wanhu awo iwemilizi weke hamoja ndiya kwa miyaka saba ya mulao. Ndiya ayo ikigwe kukanho jako gweye go mkulu Falao, iwe ngama kwa mabuga gose, na wailolese goya ngama ayo. ");
INSERT INTO kdc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ndiya ayo yokuwa ngama kwa wanhu wa isi ya Misili ili isi sikuibanangike kwa lufilili lwa nzala lukwiza miyaka saba iyagwe.” ");
INSERT INTO kdc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Mbuli iyalongile Yusufu itogoligwa mgameso ga Falao na wakulu zake. ");
INSERT INTO kdc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Avo Falao kawauza wakulu zake, “Munhu ino kana loho ya Imulungu, vino todaha kumpata munhu iyagwe kamba ino?” ");
INSERT INTO kdc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Abaho Falao kamulongela Yusufu, “Kwavija Imulungu kakugubulila mbuli zose azo, kuduhu munhu iyagwe yeli na nzewele na ubala kamba gweye. ");
INSERT INTO kdc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gweye ayo yonda uwe mulolesaji wa isi yangu, na wanhu zangu wose okuwa hasi mmakono gako. Niye niiyeka iyo mkulu kubanza gweye kwavija nokala mkigoda cha undewa. ");
INSERT INTO kdc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Avo sambi nikusagula kamba mkulu wa isi yose ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Abaho Falao kaivula mkidole chake pete yake ili na kilaguso kamvaza Yusufu, na kamvaza na viwalo va kitani inogile na mkufu wa zahabu msingo. ");
INSERT INTO kdc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Falao kamkweza Yusufu mumtuka wake wa kabili wa falasi na wakalizi walongola kuulongozi wa Yusufu, wakemelela walonga, “Mwime kumgwazo wa nzila,” Falao kamgwaa Yusufu ukulu kwa wanhu wose wa isi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Abaho Falao kamulongela Yusufu, “Niye iyo mndewa Falao! Nolonga munhu yoyose mwiisi yose ya Misili sikuyatende kinhu chochose bila ya gweye kumulongela.” ");
INSERT INTO kdc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falao kamgwaa Yusufu twaga da Misili Safenati Panea. Kamgwaa Asenati mndele wa Potifela, mulava nhosa wa buga da Oni yawe mwehe wake. Avo Yusufu kasonga kutembelela isi yose ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu kakala na miyaka malongo madatu viyasongile kumsang'hanila Falao, mndewa wa Misili. Kalawa mng'anda ya Falao na kuitembelela isi yose ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Avo mna imiyaka ija saba ya mulao, migunda ya Misili ilela ndiya nyingi ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu keka hamoja ndiya yose kipindi acho cha miyaka saba ya mulao na kaika ngama mmabuga ga Misili. Kila buga keka ngama ya ndiya kulawa mmigunda ili mmabehi na buga dijo. ");
INSERT INTO kdc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu keka ngama ya ndiya nyingi ng'hani, ikala nyingi kamba msanga wa mwhani, ikala haipimigwa bule. ");
INSERT INTO kdc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Miyaka ya lufilili lwa nzala hainavika Yusufu kakala na wana wabili kulawa kwa mwehe wake Asenati, mndele wa Potifela mulava nhosa wa buga da Oni. ");
INSERT INTO kdc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu kamgwaa mwanage twaga da Manase kalonga, “Imulungu kanhenda niisemwe magazo gangu kulawa kwa ndugu wa ng'anda ya tatangu.” ");
INSERT INTO kdc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana wa kabili kamgwaa twaga da Efulaimu kalonga, “Imulungu kangwaa wana mwiisi ya kugaya kwangu.” ");
INSERT INTO kdc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Miyaka ija saba ya mulao mwiisi ya Misili ibita, ");
INSERT INTO kdc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na miyaka saba ya lufilili lwa nzala isonga, kamba viyalongile Yusufu baho haichanduso. Isi zose ziyagwe zikala na nzala, lakini isi yose ya Misili ikala na ndiya. ");
INSERT INTO kdc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wanhu wa isi ya Misili viwasongile kupata nzala, wamulilila Falao yawagwee ndiya. Na heyo Falao kawalongela wanhu wose wa Misili, “Gendeni kwa Yusufu, donda yawalongele tendeni.” ");
INSERT INTO kdc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala yenela ng'hani mwiisi yose ya Misili. Avo Yusufu kafungula makanho gose kawauzila wanhu wa Misili indiya. ");
INSERT INTO kdc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Abaho wanhu kulawa kila hanhu mwiisi yose weza Misili kwa Yusufu kugula ndiya kwavija nzala ikala ng'hulu ng'hani mwiisi yose. ");
INSERT INTO kdc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo viyahulike kamba ako Misili kukala na ndiya nyingi, kawalongela wanage, “Habali mokala kwa kuibunhulila meso?” ");
INSERT INTO kdc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Niye mhulika kamba Misili kuna ndiya. Gendeni kuko mkagule ndiya sikutufe kwa nzala. ");
INSERT INTO kdc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Avo ndugu zake Yusufu, longo wachola Misili, kugula ndiya. ");
INSERT INTO kdc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Lakini Yakobo hamulekile Benjamini, mdodo wake Yusufu yachole nao kwavija kadumba kodaha kupata gehile gogose. ");
INSERT INTO kdc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Avo wana wa Izilaeli wavika Misili kamba wanhu wayagwe wacholile kugula ndiya, kwavija hata mwiisi ya Kanaani kukala na lufilili lwa nzala. ");
INSERT INTO kdc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Kipindi acho Yusufu iyo yakalile mkulu ako Misili. Heyo iyo yakalile mkulu wa kuwauzila ndiya wanhu wa isi zose. Avo ndugu zake weza wamfugamila Yusufu na wamgwaa ukulu. ");
INSERT INTO kdc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Bahaja Yusufu viyawonile ndugu zake kawajuwa, lakini kaitenda kamba munhu baki na kawakomhokela. “Mweye mulawa kwahi?” Wamwidika, “Tulawa mwiisi ya Kanaani, twiza hano kugula ndiya.” ");
INSERT INTO kdc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Hamoja Yusufu kawajuwa ndugu zake, wao wakala hawamjuwile bule. ");
INSERT INTO kdc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Baho kakumbuka nzozi zake za umwaka mbuli ya awo ndugu zake, kawalongela, “Mweye mwiza kutusepa, mwiza kusepa ili mujuwe kwahi isi yetu haikalizigwa.” ");
INSERT INTO kdc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wao wamwidika, “Bule, go mkulu, siye wasang'hanaji zako, twiza kugula ndiya. ");
INSERT INTO kdc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Siye twa ndugu, twa wana wa tata imoja, siye twa wanhu tutamaniligwa, hatwizile kuwasepa bule.” ");
INSERT INTO kdc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Lakini Yusufu kasusumiza kulonga, “Mweye mwiza kusepa isi yetu mujuwe hanhu hahakalizigwa.” ");
INSERT INTO kdc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wamulongela, “Siye wasang'hanaji zako tukala wana longo na wabili, wose wana wa munhu imoja, yokala mwiisi ya Kanaani. Mdodo wetu kasigala na tataetu na ndugu yetu imoja kafa.” ");
INSERT INTO kdc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Lakini Yusufu kawalongela, “Kamba vinongile mweye mwiza kutusepa mwiisi yetu. ");
INSERT INTO kdc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na vino avo vonda nijuwe, noiduwila kwa twaga da Falao, honda musegele hano mbaka vonda yeze mdodo wenu. ");
INSERT INTO kdc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mtumeni imoja wenu yakamsole ayo indugu yenu imdodo, kuno mweye wayagwe mombeta mkifungo baho nojuwa kamba molonga ukweli, buleavo noiduwila kwa twaga da Falao kamba mweye mwa wasepaji!” ");
INSERT INTO kdc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Abaho kaweka wose mkifungo kwa siku ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Siku da kadatu Yusufu kawalongela, “Kwavija niye nomdumba Imulungu, tendeni vino ili muwe wagima. ");
INSERT INTO kdc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kamba kweli mweye mwa wanhu mutamaniligwa imoja wenu yasigale hano mkifungo, na mweye wayagwe muwagalile ndiya wanhu zenu weli na nzala. ");
INSERT INTO kdc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Abaho mumgale kumwangu ndugu yenu imdodo baho nojuwa kamba mulonga kweli, na mweye honda mukomigwe bule.” Avo waitogolela kutenda vivo. ");
INSERT INTO kdc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wailongela wenyego, “Siye totagusigwa mbuli ya mdodo wetu. Siye tumona viyagaiye lakini viyatupulile tumtaze tumulemela, lekaavo gano gose gotupata.” ");
INSERT INTO kdc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubeni kawalongela, “Vino niye siwalongele bule sikutumulumize imbwanga? Lakini mweye hamunhegeleze bule! Avo sambi totagusigwa mbuli ya damu yake.” ");
INSERT INTO kdc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Wao hawajuwile kamba Yusufu kajuwa gose gawakalile olonga, kwavija viyalongile nao kalonga kubitila munhu yakalile yotafasili. ");
INSERT INTO kdc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu kachola kumgwazo, kalila kwa usungu. Viyanyamale kabwela kalonga nao. Abaho kamgoga Simeoni na kamfunga nzabi mgameso gao. ");
INSERT INTO kdc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu kalagiza mikoba yao imemezwe ndiya na kila munhu yabwezelwe sente yake mumkoba wake, na wagweleligwe mhamba ya mnzila. Watendeligwa vinhu vose avo. ");
INSERT INTO kdc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wawadikwa imizigo vihongwe wao wasegela. ");
INSERT INTO kdc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mnzila, viwavikile hanhu ha kuwasa wanhu baki, imoja wao kafungula mkoba wake ili yamgwee ndiya kihongwe wake, kakanganya kona sente yake ya mmulomo wa mkoba wake. ");
INSERT INTO kdc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kawalongela ndugu zake, “Sente yangu ibwezigwa, aino hano mmulomo wa mkoba wangu!” Viwahulike vivo, wahomba. Wailola kuno ogwaya na kuiuza, “Mbuli gani ino iyatutendele Imulungu?” ");
INSERT INTO kdc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Viwavikile mwiisi ya Kanaani kwa tatao Yakobo wamulongela mbuli zose ziwalawilile, wamulongela, ");
INSERT INTO kdc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mkulu wa isi ya Misili kalonga na siye kwa kutukomhokela, na katugesa kamba siye twa wasepaji wa isi yake. ");
INSERT INTO kdc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Lakini siye tumulongela, ‘Siye twa wanhu otamaniligwa, hatuli wasepaji bule. ");
INSERT INTO kdc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tumulongela kamba siye twa ndugu longo na wabili wa tata imoja, na imoja wetu kafa, na ija imdodo ka ako ukae Kanaani hamoja na tata yetu.’ ");
INSERT INTO kdc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Avo mkulu wa isi ayo katulongela, ‘Baho nojuwa kamba kweli mweye motamaniligwa, mulekeni kumwangu ndugu yenu imoja na mweye wayagwe mugale ndiya ukae kwa wanhu zenu weli na nzala. ");
INSERT INTO kdc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Abaho mgaleni kumwangu ndugu yenu imdodo na baho nojuwa kamba mweye hamuli wasepaji lakini mwa wanhu mutamaniligwa. Mwahatenda vivo nomulekesa ndugu yenu, na mweye motogolelwa kuchuuza na kugula vinhu mwiisi ino.’” ");
INSERT INTO kdc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Viwakalile okung'husa mikoba yao, wakanganya kona kila imoja wao kabwezelwa kikoba chake cha sente mna umkoba wake. Viwonile vivo, wose na tatao wakanganya, wadumba ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tatao Yakobo kawalongela, “Moniboka wanangu, Yusufu kahaduhu, Simeoni kahaduhu, na sambi molonda kumsola na Benjamini. Gose gago gamhata niye.” ");
INSERT INTO kdc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Baho Lubeni kamulongela tatake, “Kamba simbweza Benjamini wakome wanangu wabili. Muleke Benjamini mmakono gangu, niye nomkaliza na kumbweza kumwako.” ");
INSERT INTO kdc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Lakini tatake kamwidika, “Mwanangu hachola na mweye, ndugu yake kafa mwaka, na heyo yaiyeka iyo yasigale. Niye namvele na uhenga kamba mbwanga yuno yahapata gehile mmwanza wenu, mong'homa kwa lusikisiki.” ");
INSERT INTO kdc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Lufilili lwa nzala lubanza ng'hani mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Viishile ndiya ija iwagulile kulawa Misili, Yakobo kawalongela wanage, “Gendeni kabili Misili, mkatugulile ndiya kidogo.” ");
INSERT INTO kdc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Lakini Yuda kamulongela tatake, “Munhu ija katuzuma ng'hani, kalonga, ‘Siwabokela bule kamba hamwizile na ndugu yenu imdodo.’ ");
INSERT INTO kdc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kamba kotogola tuchole na ndugu yetu imdodo, tochola kukugulila ndiya. ");
INSERT INTO kdc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Lakini kamba wahalema, hatuchola bule, kwavija munhu ija katulongela, ‘Sikumuchone kihanga changu kamba hamwiza na ndugu yenu.’” ");
INSERT INTO kdc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izilaeli kalonga, “Habali mungela mdizumozumo kwa kumulongela munhu ayo kamba muna ndugu iyagwe?” ");
INSERT INTO kdc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wamwidika, “Munhu ija katuuza goya mbuli ya lukolo lwetu, ‘Tataenu yang'hali mgima, muna ndugu iyagwe?’ Avo siye tumwidika, twahajuwile vilihi kamba yahalongile, ‘Mgaleni ndugu yenu?’” ");
INSERT INTO kdc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda kamulongela Izilaeli tatake, “Nitogolele niye nichole nayo ili tusegele sambi baha, tuchole tukagule ndiya, sikutufe kwa nzala gweye na wanetu. ");
INSERT INTO kdc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Niye iyo yonda nidaigwe. Gweye nidai niye, kamba simbweza kumwako, nidaigwe niye siku zose. ");
INSERT INTO kdc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Maza hatukawile bule, twahacholile na kubwela miyanza mibili.” ");
INSERT INTO kdc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Baho Izilaeli, tatao, kawalongela, “Ona, kwavija vivo ilondigwa, tendeni avo, soleni mmikoba yenu vinhu vinogile ng'hani va isi ino, mumgalile nhunza mkulu ayo. Soleni mavuta ga nyemba kidogo na uki kidogo, ubani, manemane, kungu na lozi. ");
INSERT INTO kdc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Soleni sente miyanza mibili ya zija zilondigwa kwavija molondigwa mubweze sente zija zikalile mmilomo ya mikoba yenu, sengine zibwezigwa kwa kuisemwa. ");
INSERT INTO kdc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Msoleni ayo ndugu yenu muchole nayo kwa munhu ayo. ");
INSERT INTO kdc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Imulungu yeli na Udahi wose yawatende moneligwe bazi na munhu ayo, yamulekese ija ndugu yenu iyagwe na Benjamini wabwele hamoja na mweye. Kumwangu niye kamba yahakuwa kwagiligwa na wanangu iwe vivo.” ");
INSERT INTO kdc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Baho wasola zija zinhunza na sente miyanza mibili ya zija za ichanduso, wachola Misili hamoja na Benjamini. Viwavikile wachola kwima kuulongozi wa Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu viyamonile Benjamini hamoja nao, kamulongela ija yololesa ng'anda yake, “Wagale wanhu wano ukae kumwangu ukachinje mnyama na umtande vinogile, kwavija wanhu wano woja na niye ndiya ya imisi.” ");
INSERT INTO kdc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mulolesaji ayo katenda kamba viyalagizwe, kawagala wanhu awo ukae kwa Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Viwonile ogaligwa mng'anda ya Yusufu wadumba, wailongela, “Tugaligwa kuno mbuli ya zija zisente zibwezigwe mna imikoba yetu vitwizile mwanza wa ichanduso, katenda vino ili yapate kilamuso cha kutuboka vihongwe wetu na kututenda watumwa zake.” ");
INSERT INTO kdc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Avo wamgendela ija imulolesaji wa ng'anda ya Yusufu walonga na heyo kipindi wahaulwivi, ");
INSERT INTO kdc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","wamulongela, “Chonde go mkulu! Siye tukala twizile mwanza wa ichanduso kugula ndiya, ");
INSERT INTO kdc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","lakini ikilo vituvikile hanhu ha kuwasa wanhu baki, tufungula mikoba yetu na kila munhu kayona sente yake vivija kamba viyalavile, ikala mmulomo wa mkoba. Avo tuzibweza. ");
INSERT INTO kdc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Vivija tugala sente ziyagwe kugula ndiya. Hatumjuwile munhu yekile zisente mna imikoba yetu.” ");
INSERT INTO kdc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mulolesaji ayo kawedika, “Sikumudumbe, Imulungu wenu, Imulungu wa tata zenu, kawagwaa ngama mna imikoba yenu. Niye nizibokela sente zenu.” Abaho kamgala Simeoni kumwao. ");
INSERT INTO kdc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mulolesaji ayo viyawagoneke mng'anda ya Yusufu tanhu kawagwaa mazi wasunhe magulu gao na vivija kawagwaa ndiya vihongwe wao. ");
INSERT INTO kdc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na wao wazitanda nhunza zao za kumgwaa Yusufu, kwavija wahulika kamba woja hamoja nayo. ");
INSERT INTO kdc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu viyabwelile ukae wamgwaa zija zinhunza ziwakalile nazo, wamfugamila mbaka hasi. ");
INSERT INTO kdc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu kawalamusa na kawauza, “Vilihi tataenu imvele mgima? Vino yang'hali mgima?” ");
INSERT INTO kdc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wamwidika, “Msang'hanaji wako, tataetu, kogendelela goya, na yang'hali mgima.” Abaho wamfugamila mbaka hasi. ");
INSERT INTO kdc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu viyenule kihanga chake kamona Benjamini mdodo wake, mwana wa mamake, kalonga, “Ino iyo mdodo wenu yumulongile?” Kalonga, “Imulungu yakonele bazi mwanangu!” ");
INSERT INTO kdc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Bahaja, Yusufu kasegela hanhu aho, kwavija mahozi gakala golonda kumulawa mbuli ya kumnogela mdodo wake, kengila mdigati jake kasonga kulila. ");
INSERT INTO kdc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Viyamambukize kusunha kihanga chake, kalawa kunze kuno kaifunga umoyo, kalagiza wagale indiya. ");
INSERT INTO kdc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusufu kekiligwa ndiya yaiyeka na ndugu zake wekiligwa waiyeka na vivija Wamisili wakalile aho wekiligwa waiyeka, kwavija ikala mwiko kwa Wamisili kuja ndiya hamoja na Waebulania. ");
INSERT INTO kdc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ndugu zake Yusufu wakala kuulongozi wake kwa kuipanga kusongela imkulu mbaka imdodo na wakala oilola kuno okanganya. ");
INSERT INTO kdc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ndiya ikala ilawa kwa Yusufu na igoligwa kumwao, lakini Benjamini kagweleligwa miyanza mitano ng'hani ya kija kiwagweleligwe ndugu zake. Avo waja na kung'wa kuno odeng'helela hamoja na heyo. ");
INSERT INTO kdc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Abaho Yusufu kamulagiza mulolesaji wa ng'anda yake, kalonga, “Memeza mikoba ya wanhu wano kamba viwodaha kupapa. Abaho ika sente zao kila munhu mmulomo wa mkoba wake. ");
INSERT INTO kdc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mna umkoba wa ija imdodo ng'hani, ika kija ikikasi changu cha shaba, hamoja na sente yake.” Ayo imulolesaji katenda kamba viyalagizwe na Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Imitondo yake walongeligwa wachole hamoja na vihongwe wao. ");
INSERT INTO kdc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Hawanavika kutali ng'hani Yusufu kamulongela mulolesaji wa ng'anda yake, “Lopola, wawinze wanhu waja, wauze, ‘Habali mmuliha gehile munhu ija yawatendele ganogile? ");
INSERT INTO kdc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Habali mwiba kikasi cha shaba cha mkulu wangu, kiyasang'hanilaga kwa kung'wela na kulagula? Mubananga ng'hani!’” ");
INSERT INTO kdc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ija imulolesaji viyawavikile kazibwelela mbuli azo. ");
INSERT INTO kdc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Lakini wamuuza, “Go mkulu kofambula choni? Siye wasang'hanaji zako hatudaha kutenda mbuli kamba ayo. ");
INSERT INTO kdc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kumbuka go mkulu, sente ituvikile mmikoba yetu tuibweza kulawa mwiisi ya Kanaani. Yokuwaze twibe sente hebu zahabu mng'anda ya mkulu wako? ");
INSERT INTO kdc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Avo, kamba wahamvika imoja wetu kana kikasi acho yakomigwe, na siye wose wayagwe tuwe watumwa zako.” ");
INSERT INTO kdc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ayo imulolesaji kedika, “Ona, na iwe vivo kamba vimulongile. Lakini ija yaiyeka yonda yoneke na kikasi acho, iyo yonda yawe mtumwa wangu, na wayagwe wose mokuwa mwabule kitala.” ");
INSERT INTO kdc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Avo, kila munhu kahumulusa mkoba wake hasi himahima na kufungula. ");
INSERT INTO kdc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ija imulolesaji kalola imikoba yose, kasongela mkoba wa imkulu wao na kamambukizila mkoba wa imdodo wao, kikasi kakipata mumkoba wa Benjamini. ");
INSERT INTO kdc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Baho wose wadega viwalo vao kwa usungu. Kila imoja kamkweza kihongwe wake mkoba, wabwela kudibuga. ");
INSERT INTO kdc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na ndugu zake wavika mng'anda ya Yusufu na Yusufu kakala yang'hali ukae kumwake. Avo, wamfugamila mbaka hasi. ");
INSERT INTO kdc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu kawauza, “Habali mutendile kamba avo? Vino hamujuwile bule munhu kamba niye nodaha kulagula?” ");
INSERT INTO kdc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda kedika, “Tulonge choni, go mkulu, tulonge choni kulagusa hatubanange? Imulungu kagagubula gehile getu, siye sambi twa watumwa zako, siye hamoja na ija yoneke na kikasi chako.” ");
INSERT INTO kdc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Lakini Yusufu kalonga, “Bule, niye sidaha kutenda kamba avo. Munhu ija yagogeke na kikasi iyo yonda yawe mtumwa wangu. Mweye wayagwe mose bweleni moyo kwatu kwa tataenu.” ");
INSERT INTO kdc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Baho Yuda kamkwesela behi Yusufu na kulonga, “Go mkulu chonde togola niye msang'hanaji wako, niigombele kidogo, chonde sikuugevuzike kwavija gweye kamba Falao mwenyego. ");
INSERT INTO kdc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Go mkulu, gweye kutuuza, ‘Mweye muna ndugu hebu tata?’ ");
INSERT INTO kdc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tukwidika, ‘Tunayo tata, yeli mvele na tunayo ndugu iyagwe mdodo yaleleke kipindi cha uvele wa tataetu, mkulu wake mbwanga ayo kafa, na ino imdodo iyo yasigale kwa mamake, na tataetu komnogela ng'hani mbwanga ino.’ ");
INSERT INTO kdc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Go mkulu kutulagiza siye wasang'hanaji zako tumgale ayo imdodo wetu ili umone. ");
INSERT INTO kdc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tukulongela kamba mbwanga ayo hadaha kumuleka tatake, kwavija yahamuleka tatake kofa. ");
INSERT INTO kdc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lakini gweye go mkulu, kutulongela, ‘Kamba hamwizile na ndugu yenu imdodo, sikumuchone kihanga changu kabili.’” ");
INSERT INTO kdc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Vitubwelile ukae kwa msang'hanaji wako, tataetu tumulongela viutulagize gweye go mkulu. ");
INSERT INTO kdc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na viyatulongele twize kabili kuno kugula ndiya, ");
INSERT INTO kdc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","tumwidika, “Hatudaha kuchola mbaka ndugu yetu imdodo yachole hamoja na siye, kamba hatuchola nayo munhu ija hatubokela bule.” ");
INSERT INTO kdc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Msang'hanaji wako tataetu katulongela, “Mojuwa kamba mwehe wangu Laheli kanilelela wana wabili, ");
INSERT INTO kdc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","imoja kalawanya mgameso gangu, vinyona kadegigwa vihande vihande na mng'onyo, kwavija sinamona kabili. ");
INSERT INTO kdc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kamba mwahamsola na ino vivija na gahampata gehile, mongala kuna dipanga kuno nina lusikisiki.” ");
INSERT INTO kdc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Avo, go mkulu nahabwela ukae kwa tatangu niye msang'hanaji wako bila mbwanga ino na kuno ugima wa tata otamanila ugima wa mbwanga ino, ");
INSERT INTO kdc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","yahaona mbwanga heli hamoja na siye kofa. Avo siye wasang'hanaji zako, tomkoma tataetu kwa lusikisiki. ");
INSERT INTO kdc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Hata avo niye niiduwila mbuli ya mbwanga ino, nilonga, kamba simbweza Benjamini kumwako, nidaigwe niye siku zose. ");
INSERT INTO kdc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Avo go mkulu, chonde niye msang'hanaji wako nikale hano hanhu ha mbwanga ino. Muleke yabwele ukae hamoja na ndugu zake. ");
INSERT INTO kdc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nodahaze kubwela kwa tatangu bila mbwanga ino? Bule, sidaha kufunga umoyo kugona gehile gonda gampate tatangu.” ");
INSERT INTO kdc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Baho Yusufu kalemelwa kufunga umoyo mgameso ga wasang'hanaji zake wose wakalile hamoja nayo, kalagiza walawe kunze. Avo Yusufu kakala yaiyeka viyailaguse kwa ndugu zake. ");
INSERT INTO kdc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lakini kalila kwa sauti ng'hulu mbaka Wamisili wamuhulika, vivija wanhu wa mng'anda ya Falao wamuhulika. ");
INSERT INTO kdc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu kawalongela ndugu zake, “Niye na Yusufu, vino tatangu yang'hali mgima?” Lakini ndugu zake walemelwa kumwidika wagwa kifudete mgameso gake hawadahile kumwidika. ");
INSERT INTO kdc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu kawalongela ndugu zake, “Chonde kweseni behi.” Viwamkwesele, kawalongela, “Niye iyo ndugu yenu Yusufu yumuniuzile Misili. ");
INSERT INTO kdc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Lakini sambi sikumuigevuzikile hebu kulonga habali mutendile vivo. Imulungu iyo yangalile kuno, niwalongolele, ili niuhonye ugima wa wanhu. ");
INSERT INTO kdc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Uno mwaka wa kabili wa lufilili lwa nzala mwiisi na ing'hali miyaka mitano kumwande, baho wanhu hawadaha kulima hebu kusenga ndiya. ");
INSERT INTO kdc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Imulungu kangala kuno niwalongolele, ili kuhonya ugima wenu, mweye musigale wagima mwiisi na kugala ukombola mkulu. ");
INSERT INTO kdc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Avo, siyo mweye mungalile kuno, lakini Imulungu iyo yangalile na kanitenda nimgwelelege Falao magesa kamba na tatake. Niye na mkulu wa ng'anda yake yose na nowatawala wanhu wose wa Misili.” ");
INSERT INTO kdc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Avo, lopoleni mubwele kwa tatangu na mmulongele, “Yusufu mwanago kolonga, ‘Imulungu kanitenda munhu mkulu mwiisi yose ya Misili. Avo, sikuukawe kwiza kumwangu. ");
INSERT INTO kdc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kokala behi na niye ako Gosheni, gweye na wanago na wazukulu zako, fugo zako na vinhu vako vose. ");
INSERT INTO kdc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Niye nokulolesa baho kwavija ing'hali miyaka mitano ya lufilili lwa nzala. Buleavo gweye na wanhu zako na fugo zako mogaya kwa nzala.’” ");
INSERT INTO kdc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Abaho Yusufu kagendelela kulonga, “Mweye wenyego molola kwa meso genu, na hata mdodo wangu Benjamini kona kwa meso gake kamba niye iyo Yusufu mwenyego nilonga na mweye. ");
INSERT INTO kdc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mmulongele tatangu mbuli ya ukulu unilinao kuno Misili na mbuli ya kila kinhu kimone. Avo mulopole mumgale hano tatangu.” ");
INSERT INTO kdc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Abaho Yusufu kamfagatila ndugu yake Benjamini, kuno kolila na vivija Benjamini kamfagatila kuno kolila. ");
INSERT INTO kdc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kuno yang'hali kolila Yusufu kawafagatila ndugu zake na kawanonela. Baho ndugu zake walonga nayo. ");
INSERT INTO kdc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mbuli azo zivika mng'anda ya Falao kamba ndugu zake Yusufu weza, Falao na wasang'hanaji zake wadeng'helela. ");
INSERT INTO kdc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Avo, Falao kamulongela Yusufu, “Walongele ndugu zako, wawapapize mizigo vihongwe wao wabwele mwiisi ya Kanaani, ");
INSERT INTO kdc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","wamgale hano tatao na ndugu zao wose. Niye nowagwaa hanhu hanogile ng'hani mwiisi ino ya Misili, na wao okala kwa kudeng'helela ganogile ga isi ino. ");
INSERT INTO kdc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Vivija walongele wasole mituka ino ya kubulula ili wawapapile wanao ving'hele na wehe zao na sikuwaleke kumgala tatao. ");
INSERT INTO kdc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Walongele sikuwagese mbuli ya vinhu vao kwavija hanhu hanogile kubanza kose mwiisi ya Misili hokuwa hao.” ");
INSERT INTO kdc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Avo, wana wa Izilaeli watenda kamba viwalagizwe. Yusufu kawagwaa mituka ya kubulula kamba Falao viyalongile na vivija kawagwaa mhamba ya mnzila. ");
INSERT INTO kdc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kila imoja wao kamgwaa viwalo va kusaula, lakini Benjamini kamgwaa vihande magana madatu va shaba na kamgwaa viwalo vitano va kusaula. ");
INSERT INTO kdc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Vivija kamgalila tatake nhunza zino mbuli ya mwanza wake, vihongwe longo wapapile vinhu vinogile ng'hani mwiisi ya Misili, vihongwe wa kitwanzi longo wapapile ndiya, na magate na vinhu viyagwe va kuja. ");
INSERT INTO kdc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Avo, Yusufu kailaga na ndugu zake. Viwakalile osegela kawazuma kawalongela, “Sikumugombe mnzila!” ");
INSERT INTO kdc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Baho wasegela mwiisi ya Misili na wabwela kwa tatao Yakobo mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wamulongela, “Yusufu yang'hali mgima! Heyo iyo mkulu wa isi yose ya Misili.” Baho tatao kakanganya, kwavija hazitogole mbuli azo. ");
INSERT INTO kdc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Lakini viwamulongele mbuli zose ziyalongile Yusufu na viyone mituka ya kubulula iyagalile Yusufu ili kumsola, moyo wake umema deng'ho. ");
INSERT INTO kdc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Izilaeli kalonga, “Sambi notogola, mwanangu Yusufu yang'hali mgima! Nochola nikamulole ning'hali sinakufa.” ");
INSERT INTO kdc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Avo, Izilaeli kasonga mwanza wake, hamoja na vinhu vake vose. Viyavikile Beelisheba kamulavila nhosa Imulungu wa Isaka tatake. ");
INSERT INTO kdc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Imulungu kalonga na Izilaeli ikilo mwiinzozi kamkema, “Yakobo, Yakobo.” Yakobo kedika, “Nabaha.” ");
INSERT INTO kdc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Imulungu kamulongela, “Niye ayo Imulungu, Imulungu wa tatako. Sikuudumbe kuchola Misili, wahawa kuko nokutenda uwe na ulelo onda uwe kabila kulu. ");
INSERT INTO kdc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Niye mwenyego nochola hamoja na gweye ako Misili na nokubweza kuno. Wahafa mkono wa Yusufu uwo onda ukufumbe meso gako.” ");
INSERT INTO kdc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Avo, Yakobo kasegela Beelisheba. Wanage wamsola tatao, na wanao ving'hele hamoja na wehe zao, wawakweza mna imituka iyagalile Falao impape. ");
INSERT INTO kdc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Vivija wasola fugo zao na vinhu vao vose viwapatile mwiisi ya Kanaani, wachola Misili. Yakobo kasola lukolo lwake lose, ");
INSERT INTO kdc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","wanage, wazukulu zake wa kitwanzi na wa kimbigalo, wose kawagala mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Gano gago matwaga ga wana wa Izilaeli wacholile ako Misili. Lubeni mwanage wa chaudele, ");
INSERT INTO kdc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","hamoja na wana wa Lubeni, wakalile Hanoki na Palu na Hesiloni na Kalimi. ");
INSERT INTO kdc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeoni na wanage, Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli mwana wa mtwanzi Mkanaani. ");
INSERT INTO kdc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawi na wanage, Gelishoni na Kohati na Melali. ");
INSERT INTO kdc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda na wanage, Eli na Onani na Shela na Pelesi na Zela. Lakini Eli na Onani wafa mwiisi ya Kanaani. Pelesi na wanage, Hesiloni na Hamuli. ");
INSERT INTO kdc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakali na wanage, Tola na Puva na Yashubu na Shimuloni. ");
INSERT INTO kdc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabuloni na wanage, Seledi na Eloni na Yaleeli. ");
INSERT INTO kdc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wano wao wana wa kimbigalo wa Lea iyamulele Yakobo ako Padani Alamu, wahaleka mndele wake Dina. Wanage na iwazukulu wose kwa wose wakala malongo madatu na ndatu. ");
INSERT INTO kdc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi na wanage, Sifioni na Hagi na Shuni na Esiboni na Eli na Alodi na Aleli. ");
INSERT INTO kdc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asheli na wanage, Imina na Ishiva na Ishivi na Belia na Sela na lumbu jao. Belia na wanage, Hebeli na Malikieli. ");
INSERT INTO kdc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wanhu longo na sita ni wana na wazukulu wa Yakobo na Zilipa, mtumwa yagweleligwe Lea na tatake Labani. ");
INSERT INTO kdc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Laheli kamulelela Yakobo wana wabili Yusufu na Benjamini. ");
INSERT INTO kdc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ako Misili Asenati mndele wa Potifela yakalile mulava nhosa wa buga da Oni, kamulelela Yusufu wana wabili wakalile Manase na Efulaimu. ");
INSERT INTO kdc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamini na wanage, Bela na Bekeli na Ashibeli na Gela na Naamani na Ehi na Loshi na Mupimu na Hupimu na Alidi. ");
INSERT INTO kdc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Wanhu wao longo na nane ni wana na wazukulu wa Yakobo waleligwe na Laheli mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani na mwanage Hushimu. ");
INSERT INTO kdc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafutali na wanage, Yaseeli na Guni na Yeseli na Shilemu. ");
INSERT INTO kdc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Wanhu wao saba ni wana na wazukulu wa Yakobo yalelile na Biliha, mtumwa wa Laheli iyagweleligwe na Labani tatake. ");
INSERT INTO kdc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wanhu wose waleligwe mulukolo lwake Yakobo, wakala malongo sita na sita, wahaleka kuwapeta wehe wa wanage. Wanhu awo wose wao wacholile mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ako Misili Yusufu kakala na wana wabili. Avo, wanhu wose wa ulelo wa Yakobo ako Misili wakala malongo saba. ");
INSERT INTO kdc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo kamulongela Yuda yalongole kwa Yusufu yampule waiting'hane ako Gosheni. Viwavikile Gosheni, ");
INSERT INTO kdc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu kakwela mtuka wa kubululigwa na falasi, kachola kumbokela Izilaeli, tatake, ako Gosheni. Viyamvikile tatake kamfagatila na kalila kwa kipindi kitali. ");
INSERT INTO kdc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izilaeli kamulongela Yusufu, “Hata sambi nahafa siyo mbuli kwavija nichona kihanga chako na njuwa kamba gweye kwa mgima.” ");
INSERT INTO kdc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Abaho Yusufu kawalongela ndugu zake na wanhu wa mng'anda ya tatake, “Niye nochola kumulongela Falao kamba ndugu zangu na wanhu wa mng'anda ya tatangu wakalile okala mwiisi ya Kanaani wavika. ");
INSERT INTO kdc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nomulongela kamba mweye mwa wasusilaji na mwiza na ng'ombe na mbuzi na ng'hondolo na vinhu venu vose. ");
INSERT INTO kdc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Avo, Falao yahawakema na kuwauza, ‘Sang'hano yenu choni?’ ");
INSERT INTO kdc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mmwidike, ‘Siye wasang'hanaji zako tosusila fugo toka muubwanga wetu, kamba viyakalile tataetu.’ Baho kowatogolela mukale ako Gosheni, kwavija kwa wanhu wa Misili wanhu osusila hawawalonda.” ");
INSERT INTO kdc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Avo, Yusufu kachola kumulongela Falao, “Tatangu na ndugu zangu wavika hamoja na ng'hondolo zao na mbuzi zao na ng'ombe zao na vinhu vao vose, walawa mwiisi ya Kanaani, sambi wa ako Gosheni.” ");
INSERT INTO kdc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusufu kawasagula ndugu zake watano kawalagusa kwa Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falao kawauza, “Sang'hano yenu choni?” Wao wamwidika, “Siye wasang'hanaji zako twa wasusilaji kamba viyakalile tataetu.” ");
INSERT INTO kdc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Vivija wamulongela Falao, “Siye wasang'hanaji zako, twiza kukala mwiisi ino kamba wanhu baki kwavija kuna lufilili lwa nzala ng'hani ako Kanaani na kuduhu ndiya kwa fugo zetu. Avo, chonde go mkulu, siye wasang'hanaji zako tokupula tukale hanhu hokemigwa Gosheni.” ");
INSERT INTO kdc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falao kamulongela Yusufu, “Tatako na ndugu zako weza kumwako gweye, ");
INSERT INTO kdc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","na isi yose ya Misili ya mmakono gako. Weke tatako na ndugu zako hanhu hanogile ng'hani mwiisi ino, waleke wakakale ako Gosheni, na kamba kuna wanhu wowose viweli kuwajuwa goya kamba odaha kulolesa goya zifugo, wasagule wakanilolesele fugo zangu.” ");
INSERT INTO kdc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Abaho Yusufu kamgala kwa Falao tatake Yakobo, Yakobo kamtambikila Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falao kamuuza Yakobo, “Kuna miyaka mingapi toka uvumbuke?” ");
INSERT INTO kdc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo kamwidika Falao, “Miyaka yangu inigweleligwe kamba munhu mbita nzila ni miyaka gana na malongo madatu. Miyaka ayo midodo na imema magazo, na haivikile wingi wa miyaka iwakalile nayo iwahenga zangu kamba wanhu obita nzila.” ");
INSERT INTO kdc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Abaho Yakobo kamtambikila Falao, kasegela. ");
INSERT INTO kdc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Avo, Yusufu kawagwaa tatake na ndugu zake hanhu hokemigwa Lamesesi hanhu hanogile ng'hani mwiisi ya Misili, hanhu aho wagweleligwa hawe hao, kamba viyalagize Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu kawagwelela ndiya tatake na ndugu zake na lukolo lose lwa tatake kamba viwakalile. ");
INSERT INTO kdc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kukala kuduhu ndiya kila hanhu. Lufilili lwa nzala lukala lwenele kila hanhu mbaka iwatenda wanhu wose mwiisi ya Misili na isi ya Kanaani wanyolile mbuli ya nzala. ");
INSERT INTO kdc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu keka hamoja sente zose za isi ya Misili na isi ya Kanaani mbuli ya ndiya iwagulile, kazigala zisente azo kwa Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sente za wanhu wa Misili na Kanaani vizimalile, wanhu wose wamcholela Yusufu na kumulongela, “Chonde, tugwelele ndiya, sikutufe mgameso gako, kwavija sente zetu zisha.” ");
INSERT INTO kdc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu kawalongela, “Kamba sente zenu zisha, avo munigwelele fugo zenu na niye nowagwaa ndiya.” ");
INSERT INTO kdc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Avo wamgalila Yusufu fugo zao, nayo kawagwaa ndiya na hewo wamgwaa falasi na ng'ombe na ng'hondolo na mbuzi na vihongwe. Avo mwaka awo wose Yusufu kawagwaa ndiya na hewo wamgwaa zifugo. ");
INSERT INTO kdc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka uyagwe wamcholela kabili Yusufu wamulongela, “Hatukufisa bule, sente zetu zose zisha na fugo zetu zose zako gweye. Avo, go mkulu siye wasang'hanaji zako twabule chochose cha kukugwaa ila siye wenyego na migunda yetu. ");
INSERT INTO kdc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Habali siye tufe mgameso gako, na migunda yetu sikuilimigwe? Avo, tugule siye na migunda yetu mbuli ya ndiya, na siye na migunda yetu yokuwa mmakono ga Falao. Chonde, tugwelele ndiya ili sikutufe na vivija utugwelele mbeyu mbuli ya migunda yetu.” ");
INSERT INTO kdc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Avo Yusufu kaigula isi yose ya Misili iwe ya Falao. Kila munhu wa Misili kalondigwa kuuza mgunda wake mbuli ya lufilili lwa nzala, avo isi yose ikala ya Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Avo, Yusufu kawatenda wanhu wawe watumwa, kulawa mwambu uno wa isi na mwambu uyagwe wa isi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Lakini Yusufu haigulile bule isi ya walava nhosa, kwavija siku zose wao wagweleligwa ndiya kulawa kwa Falao, wagweleligwa fungu dilondigwa. Lekaavo hawauzile bule migunda yao. ");
INSERT INTO kdc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu kawalongela wanhu, “Sambi niwagula mweye na migunda yenu mbuli ya Falao, mbeyu azino hano muhande migunda yenu. ");
INSERT INTO kdc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Lakini mwahasenga ndiya mna gamafungu matano dimoja mumgwelele Falao, na mafungu mane gasigale gokuwa genu mbuli ya mbeyu kwa migunda yenu na ndiya yenu na wanhu wa mzing'anda zenu na wanenu.” ");
INSERT INTO kdc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wanhu wa Misili wamwidika, “Kuhonya ugima wetu, kwavija kututendela ganogile, siye tokuwa watumwa wa Falao.” ");
INSERT INTO kdc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Vivo Yusufu viyekile lagizo mwiisi ya Misili na dabaho mbaka sambi, kuwa fungu dimoja mna gamafungu matano ga ndiya yose yagweleligwe Falao. Migunda ya walava nhosa waiyeka ayo haisoligwe na Falao. ");
INSERT INTO kdc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Avo wanhu wa Izilaeli wakala mwiisi ya Misili hanhu hokemigwa Gosheni. Ako wakala na vinhu vingi na wasonga kongezeka ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo kakala Misili kwa miyaka longo na saba, miyaka yose ya ugima wa Yakobo ikala miyaka gana na malongo mane na saba. ");
INSERT INTO kdc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kipindi cha Izilaeli kufa vikikalile behi, kamkema mwanage Yusufu na kamulongela, “Kamba koninogela ingiza mkono wako mna gamaungo gangu madeke na uiduwile kamba konitendela ganogile na kotamaniligwa. Sikuunizike mwiisi ya Misili, ");
INSERT INTO kdc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","lakini unitambalize hamoja na wahenga zangu, umhape kulawa Misili ukanizike ako kuwazikiligwe hewo.” Yusufu kamwidika, “Notenda kamba viulongile.” ");
INSERT INTO kdc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo kamulongela Yusufu, “Iduwile,” Yusufu kaiduwila. Abaho Izilaeli kaidulika mwambu wa pala wa ulusazi lwake kamtambikila Imulungu. ");
INSERT INTO kdc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kipindi kiyagwe, Yusufu kalongeligwa kamba tatake mtamu. Avo kawasola wanage wabili Manase na Efulaimu kachola nao kwa tatake. ");
INSERT INTO kdc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo viyalongeligwe, “Mwanago Yusufu keza kukulola,” Izilaeli kawamba kwinuka kakala mulusazi. ");
INSERT INTO kdc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo kamulongela Yusufu, “Imulungu yeli na Udahi wose kanilawilila ving'halile ako Luzu mwiisi ya Kanaani, kanitenda nimwede. ");
INSERT INTO kdc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kanongela, ‘Nokutenda ongezeke na kuwatenda muwe wengi. Nokutenda uwe na ulelo onda uwe isi zili na wanhu wengi, na nokugwaa isi ino kamba uhazi kwa ulelo wako milele.’” ");
INSERT INTO kdc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Avo, wanago wabili waulelile kuno Misili ning'hali sinavika kumwako okuwa wanangu. Efulaimu na Manase okuwa wangu niye, kamba vija Lubeni na Simeoni viweli wangu. ");
INSERT INTO kdc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Lakini wana onda ulele kumwande okuwa wako. Opata uhazi kubitila Efulaimu na Manase. ");
INSERT INTO kdc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Notenda vivo mbuli ya mamako Laheli. Vinikalile nobwela kulawa Padani heyo kafa behi ya kuvika Efulata mwiisi ya Kanaani. Kandekela lusikisiki, niye nimzika baho behi ya nzila ya kuchola Efulata nayo iyo Beselehemu.” ");
INSERT INTO kdc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Izilaeli viyawone wanage Yusufu, kauza, “Wano wanage nani?” ");
INSERT INTO kdc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu kamulongela tatake, “Wano wao wana wanigweleligwe na Imulungu hano.” Izilaeli kalonga, “Chonde wagale behi niwatambikile.” ");
INSERT INTO kdc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Avo meso ga Izilaeli gakala hagadaha kulola goya mbuli ya uvele. Yusufu kawakwesa behi wanage nayo tatake kawanonela na kuwafagatila. ");
INSERT INTO kdc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izilaeli kamulongela Yusufu, “Niye nigesa sichona kabili kihanga chako, lakini Imulungu kanhenda niwone wanago vivija. ");
INSERT INTO kdc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Abaho Yusufu kawasegesa wanage mmavindi ga tatake, na kafugama mbaka hasi.” ");
INSERT INTO kdc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Abaho Yusufu kawasola wanage, Efulaimu kamgoga kwa mkono wa kudila na kamwika mkono wa kumoso wa Izilaeli na Manase kamgoga kwa mkono wa kumoso na kamwika mkono wa kudila wa Izilaeli, na kawagala kumwake. ");
INSERT INTO kdc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Lakini Izilaeli kenula mkono wake wa kudila na kawika mdipala da Efulaimu na kabitiza mkono wake wa kumoso mdipala da Manase hamoja Manase iyo yakalile imkulu. ");
INSERT INTO kdc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Abaho Izilaeli kamtambikila Yusufu, kalonga, “Imulungu iwamtegeleze wahenga zangu Abulahamu na Isaka, Imulungu yanilongoze muugima wangu wose mbaka lelo, ");
INSERT INTO kdc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","na msenga wa kuulanga yanihonyile na gehile gose yawatambikile wabwanga wano! Wakemigwe kwa twaga jangu na matwaga ga wahenga zangu Abulahamu na Isaka, wawe na wana wengi na ulelo mkulu.” ");
INSERT INTO kdc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu viyone tatake keka mkono wake wa kudila kudipala da Efulaimu hanogelwe bule, avo kaugoga mkono wa tatake kalonda kuusegesa kudipala da Efulaimu yawike kudipala da Manase. ");
INSERT INTO kdc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu kamulongela tatake, “Si vivo bule tata! Ino iyo mwana imkulu, chonde wike mkono wako wa kudila kudipala jake.” ");
INSERT INTO kdc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Lakini tatake kalema, “Nojuwa mwanangu nojuwa. Manase vivija kokuwa munhu mkulu na kokuwa na wanhu wengi. Lakini imdodo kokuwa munhu mkulu kubanza heyo na wanhu wa ulelo wake okuwa makabila mengi.” ");
INSERT INTO kdc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Avo, Izilaeli kawatambikila siku dijo kalonga, “Wanhu wa Izilaeli owatambikila wanhu kubitila matwaga genu, olonga, ‘Imulungu yakutendele ganogile kamba Efulaimu na Manase.’ ” Avo Izilaeli kamtenda Efulaimu munhu mkulu kubanza Manase. ");
INSERT INTO kdc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Abaho Izilaeli kamulongela Yusufu, “Niye sambi nofa. Lakini Imulungu kokuwa hamoja na mweye, na kowabweza mwiisi ya wahenga zenu. ");
INSERT INTO kdc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Na niye nokugwaa gweye na siyo ndugu zako mgunda uli na mboji uniwabokile Waamoli kwa sime na upinde wangu.” ");
INSERT INTO kdc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakobo kawakema wanage kawalongela, “Kweseni behi niwalongele gaja gonda gawalawilile baho kumwande.” ");
INSERT INTO kdc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Kaleni hamoja mutegeleze, mweye wana wa Yakobo, nhegelezeni niye Izilaeli tataenu.” ");
INSERT INTO kdc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Gweye Lubeni kwa mwanangu wa chaudele, gweye kwa nguvu zangu, na tunda da ubwanga wangu, gweye kuwabanza wayagwe kwa ukulu na nguvu, ");
INSERT INTO kdc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","gweye kuigala na mazi ga sika kulu, lakini honda uwe mkulu kabili, kwavija kumuwasa msang'hanaji wangu yeli kamba mwehe wangu, gweye kulufitiza lusazi lwangu.” ");
INSERT INTO kdc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Lawi ni ndugu, osang'hanila misime yao kwa kubananga. ");
INSERT INTO kdc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Lakini niye siilumba nao mna ikija kiwolonda kutenda, niye siilumba nao mumting'hano wao, kwavija kwa ng'hasiliki yao wawakoma wanhu na kwa utundu wao wakanha migiha ya ng'ombe. ");
INSERT INTO kdc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Noiduwila ng'hasiliki yao kwavija ibanza ukwiha na kugevuzika kwao kwabule bazi. Nowapwililisa mwiisi ya Yakobo, nowatimulila mwiisi ya Izilaeli.” ");
INSERT INTO kdc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Gweye Yuda ndugu zako okugwaa nhogolwa. Wanhu wakwihile kowabota singo na ndugu zako okufugamila. ");
INSERT INTO kdc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Gweye Yuda mwanangu kuigala na simba yapatile kija kiyasakile na kubwela hoyokala. Kamba simba koigolola na kutambalala hasi, simba yeli na nguvu nani yonda yamulamuse? ");
INSERT INTO kdc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mkongoja wa ukulu honda usegele mmakono ga Yuda, na mkongoja wa utawala honda usegele muulelo wake mbaka vonda yeze ija mwenyego heyo makabila gose gomtegeleza. ");
INSERT INTO kdc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kwavija kokuwa na mizabibu mingi komfunga kihongwe wake mumzabibu ili yaje majani ga mzabibu. Kwavija kokuwa na divai nyingi kofuwila viwalo vake na makanzu gake kogafuwila mna idivai inogile ng'hani. ");
INSERT INTO kdc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meso gake madung'hu mbuli ya kung'wa divai na meno gake mazelu mbuli ya kung'wa maziwa.” ");
INSERT INTO kdc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabuloni kokala mwiimwhani, mwhani yake yokuwa hanhu ha kwika ngalawa ng'hulu. Isi yake yoibakana na isi ya Sidoni.” ");
INSERT INTO kdc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakali kaigala na kihongwe yeli na nguvu yotambalala mna zimbahasha zake. ");
INSERT INTO kdc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kaona kamba hanhu ha kubwihila hanoga na kaona isi inoga, kainama mgongo wake yapape mzigo, kawa mtumwa kusang'hana sang'hano ndala.” ");
INSERT INTO kdc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani kokuwa msemi wa wanhu zake kokuwa kamba makabila gayagwe ga Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani kokuwa mgendela hasi mnzila, mgendela hasi yeli na sumu mumgwazo wa nzila, yoluma visiginho va falasi, nayo munhu yamkwelile kogwa.” ");
INSERT INTO kdc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Go, Mndewa Imulungu nobeta unihonye.” ");
INSERT INTO kdc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi kokumbigwa na wabavi, lakini heyo kowasondelela kukisogo na kowabunda.” ");
INSERT INTO kdc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Isi yookala Asheli yolela ndiya ng'hani nayo kolava ndiya iyolonda mndewa.” ");
INSERT INTO kdc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutali kaigala na mhala yalekesigwe, yolela wana wanogile.” ");
INSERT INTO kdc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu kaigala na biki dilela matunda, biki dilela mumgwazo wa nzasa, matambi gake gokwenela mbaka mna uluwa. ");
INSERT INTO kdc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wanhu oitowa kwa migoha wammemela ng'hani wampigisila migoha na wamgaza. ");
INSERT INTO kdc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Lakini upinde wake ukala goya mmakono gake, na makono gake gang'hali na nguvu, kwa udahi wa ija Yodaha wa Yakobo na Msusilaji na Dibwe da Izilaeli, ");
INSERT INTO kdc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","mbuli ya Imulungu wa tatako, yakutazile, mbuli ya Imulungu yeli na Udahi wose yakutendile umwede kwa mbuli zinogile za kuulanga, na kumweda kulawa hasi mwiibahali, kumweda kwa kuwa na fugo nyingi na wana heleketwaa. ");
INSERT INTO kdc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kumweda kwa tatako kukula ng'hani kubanza kumweda kwa vigongo va umwaka. Kumweda ako kuwe kudipala da Yusufu, kuwe mkihanga cha ayo yatendigwe mkulu kwa ndugu zake.” ");
INSERT INTO kdc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini kaigala na mbwizi mkali, imitondo koja kiyasakile na ichungulo kogola kija kiyasakile.” ");
INSERT INTO kdc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Gano gago makabila longo na mabili ga Izilaeli na zino azo mbuli ziyalongile tatao kuwatambikila kamba viilondigwa. ");
INSERT INTO kdc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Abaho Izilaeli kawalagiza vino wanage, “Niye sambi nofa na kuilumba na wahenga zangu wafile umwaka, nizikeni hamoja na wavele zangu mna imhango ili mumgunda wa Efuloni Muhiti, ");
INSERT INTO kdc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ako Makipela, mwambu wa kudilawila zuwa wa Mamule, mwiisi ya Kanaani. Abulahamu kagula mhango na mgunda awo kwa Efuloni Muhiti, uwe mhango ya kuzikila. ");
INSERT INTO kdc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kuko kuwazikigwe Abulahamu na mwehe wake Sala, vivija kuko kuwazikigwe Isaka na mwehe wake Lebeka na vivija kuko nimzikile mwehe wangu Lea. ");
INSERT INTO kdc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mgunda awo na mhango ayo viguligwa kwa Wahiti.” ");
INSERT INTO kdc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo viyamambukize kuwalagiza wanage keka magulu gake mulusazi, kakanha loho, kailumba na wahenga zake wafile umwaka. ");
INSERT INTO kdc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Baho Yusufu kaibwanha mwenyego kamfagatila tatake kalila na kumnonela. ");
INSERT INTO kdc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusufu kawalagiza waganga wambake tatake Izilaeli dawa ili sikuyakole, na wao watenda vivo. ");
INSERT INTO kdc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kamba viwatendaga, watenda sang'hano ayo kwa siku malongo mane. Na wanhu wa Misili wamuyalalila kwa siku malongo saba. ");
INSERT INTO kdc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Siku za kumuyalalila vizishile, Yusufu kawalongela wanhu wa Falao, “Kamba moninogela nipulileni kwa Falao mulongeleni, ");
INSERT INTO kdc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tatangu viyakalile kolonda kufa kanongela niiduwile kamba nomzika kudipanga diyatandile ako Kanaani. Avo chonde ndeke nichole hamzike tatangu, abaho nobwela.’ ” ");
INSERT INTO kdc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falao kamwidika, “Genda kamzike tatako, kamba viulongile kotenda.” ");
INSERT INTO kdc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Avo, Yusufu kachola kumzika tatake. Wasang'hanaji na vilongozi wa ng'anda ya Falao na vilongozi wa wanhu wa Misili wachola na Yusufu. ");
INSERT INTO kdc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Wanhu wa mng'anda yake na ndugu zake na wanhu wa lukolo lwa tatake wachola nayo. Wana wadodo na ng'ombe na ng'hondolo na mbuzi, wao wasigale ako Gosheni. ");
INSERT INTO kdc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Vivija wanhu okwela falasi na wanhu okwela mituka ibululigwa na falasi wailumba nayo. Kukala na wanhu wengi. ");
INSERT INTO kdc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Viwavikile kulubuga lwa kubigila uhemba lwa Atadi, mwambu wa lwanda lwa Yolidani waiyalala kwa bwembwe, Yusufu nayo kamtendela mwenekwaga matanga ga siku saba. ");
INSERT INTO kdc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wanhu wa Kanaani wakalile baho viwone kuiyalala kwao aho hana ulubuga lwa kubigila uhemba lwa Atadi walonga, “Kuiyalala kuno kwa Wamisili kukula ng'hani.” Lekaavo hanhu aho behi na lwanda lwa Yolidani hakemigwa Abeli Misili. ");
INSERT INTO kdc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wana wa Yakobo wamtendela tatao kamba viyawalagize. ");
INSERT INTO kdc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wamgala mbaka isi ya Kanaani, wamzika mwiimhango ikalile mumgunda ako Makipela, mwambu wa kudilawila zuwa wa Mamule. Mhango na mgunda awo Abulahamu kaugula kwa Efuloni Muhiti, ili hawe hanhu ha kuzikila. ");
INSERT INTO kdc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Viwamambukize kumzika tatao, Yusufu kabwela Misili hamoja na ndugu zake na wanhu wose wacholile hamoja nayo muumwanza wa kumzika tatake. ");
INSERT INTO kdc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Viimalile ndilo ya tatao, ndugu zake Yusufu wailongela, “Sengine ndugu yetu Yusufu kagevuzika na kogabweza gehile gose gatumtendele.” ");
INSERT INTO kdc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Avo wamgalila Yusufu usenga, walonga, “Tatako kaleka usi uno yang'hali hanakufa, ");
INSERT INTO kdc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mulongeleni vino Yusufu mbuli yangu, chonde ugele kumgongo nzambi ziwakutendele ndugu zako, kwavija wakutendela gehile ng'hani.’ Avo sambi chonde ugele kumgongo nzambi zitukutendele siye wasang'hanaji wa Imulungu wa tatako.” Yusufu viyapatile usenga uno kalila. ");
INSERT INTO kdc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Abaho ndugu zake wamcholela, wamfugamila mbaka hasi walonga, “Lola siye twa watumwa zako.” ");
INSERT INTO kdc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lakini Yusufu kawalongela, “Sikumudumbe, vino niye na Imulungu? ");
INSERT INTO kdc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mweye mukala mulondile kunhendela gehile, lakini Imulungu kagesa kutenda ganogile ili wanhu wengi wawe wagima kamba vimona sambi. ");
INSERT INTO kdc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Avo, sikumudumbe, niye nowagwaa ndiya hamoja na wanenu.” Avo kawahoza mizoyo na kalonga nao vinogile. ");
INSERT INTO kdc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu kagendelela kukala Misili hamoja na wanhu wa lukolo lwa tatake. Yusufu kakala na miyaka gana na longo. ");
INSERT INTO kdc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu kamweda kuwona wana na wazukulu wa mwanage Efulaimu. Vivija wana wa Makili mwana wa Manase kawabokela mmahaza gake. ");
INSERT INTO kdc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Abaho Yusufu kawalongela ndugu zake, “Niye sambi nofa, lakini Imulungu kowezila tu kuwataza. Kowalava mwiisi ino na kowagala mwiisi iyawalongele kowagwaa Abulahamu na Isaka na Yakobo.” ");
INSERT INTO kdc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Abaho Yusufu kawatenda wana wa Izilaeli waiduwile, kalonga, “Imulungu yahawezila kuwataza, soleni mizege yangu kulawa hano.” ");
INSERT INTO kdc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Avo, Yusufu kafa ako Misili, akuno mvele wa miyaka gana na longo. Na hewo walubaka dawa lukuli lwake ili sikulukole, walwika kudisanduku ako Misili.");
INSERT INTO kdc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Gano gago matwaga ga wana wa kimbigalo wa Yakobo vivija kokemigwa Izilaeli wacholile Misili hamoja na heyo, kila imoja na wanage, ");
INSERT INTO kdc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubeni na Simeoni na Lawi na Yuda, ");
INSERT INTO kdc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","na Isakali na Zabuloni na Benjamini, ");
INSERT INTO kdc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","na Dani na Nafutali na Gadi na Asheli. ");
INSERT INTO kdc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ulelo wose wa Yakobo wakala wanhu malongo saba. Kipindi acho Yusufu kakala yalongole mwaka kuko Misili. ");
INSERT INTO kdc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kumwande Yusufu kafa na ndugu zake na wanhu wose wa ulelo uja wafa, ");
INSERT INTO kdc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","lakini Waizilaeli wengezeka ng'hani, wakala na nguvu na wenela kila hanhu mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Abaho mndewa iyagwe katawala ako Misili, mndewa ayo kakala hamjuwile bule Yusufu. ");
INSERT INTO kdc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kawalongela wanhu zake, “Loleni Waizilaeli viweli wengi ng'hani na wana nguvu ng'hani kubanza siye. ");
INSERT INTO kdc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Avo kamba yahalawila ng'hondo, odaha kuilumba na wanhu otwihila na kututowa, na hewo olawanya mwiisi ino. Avo tuzahile nzila ya kuwahunguza sikuwengezeke.” ");
INSERT INTO kdc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Avo Wamisili weka wemilizi wawemilile Waizilaeli na wawadununze kwa sang'hano ndala. Waizilaeli wamzengela Falao mabuga ga kwikila vinhu vake, mabuga gago gakala Pitomu na Lamesesi. ");
INSERT INTO kdc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Lakini viwagendelele kuwadununza, vivo Waizilaeli viwagendelele kwengezeka na kwenela mwiisi yose. Avo Wamisili wawadumba ng'hani Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Avo Wamisili wawatenda Waizilaeli kamba watumwa kwa kuwagwaa sang'hano ndala. ");
INSERT INTO kdc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wautenda ugima wao uwe mdala kwa kuwananahiza sang'hano ndala ya kuzenga ng'anda na sang'hano zose za migunda. Waizilaeli hawoneligwe bazi. ");
INSERT INTO kdc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Avo mndewa wa Misili, kawalongela Shifila na Pua iwang'hunga, waja owataza watwanzi wa Kiebulania, ");
INSERT INTO kdc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","kawalongela, “Vonda muwataze watwanzi wa kiebulania kipindi cha kulela, yahaleleka mwana wa kitwanzi mulekeni lakini yahaleleka mwana wa kimbigalo mkomeni.” ");
INSERT INTO kdc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lakini kwavija wang'hunga wao wakala omdumba Imulungu hawategeleze ziwalongeligwe na mndewa wa Misili, wawaleka wana wa kimbigalo wawe wagima. ");
INSERT INTO kdc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Avo mndewa wa Misili kawakema wang'hunga awo kawauza, “Habali hamuwakomile iwana wa kimbigalo?” ");
INSERT INTO kdc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hewo wamwidika, “Watwanzi wa Kiebulania hawaigalile na watwanzi wa Kimisili, watwanzi wa Kiebulania wana nguvu ng'hani, na olela yang'hali mng'hunga hanavika.” ");
INSERT INTO kdc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Avo Imulungu kawatendela ganogile awo iwang'hunga, na Waizilaeli wengezeka na wakala na nguvu ng'hani. ");
INSERT INTO kdc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kwavija awo iwang'hunga wakala omdumba Imulungu, Imulungu kawatenda walele wana. ");
INSERT INTO kdc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Abaho Falao kawalagiza wanhu zake wose, kawalongela, “Kila mwana wa kimbigalo yonda yavumbuke kwa Waebulania mwaseni muulwanda lwa Naili, lakini kamba mwana wa kitwanzi mulekeni mgima.” ");
INSERT INTO kdc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kukala na munhu imoja wa kabila da Lawi, yamsolile mtwanzi imoja, mtwanzi ayo vivija kolawa mdikabila da Lawi. ");
INSERT INTO kdc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Avo mtwanzi ayo kagoga inda, kalela mwana wa kimbigalo. Viyamone mwana ayo kanoga ng'hani, kamfisa kwa miyezi midatu. ");
INSERT INTO kdc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Viyonile hadaha kumfisa kabili, kasola kisege kilukigwe na milanzi kakibaka tongo tongo, kamwika mwana ayo mkisege acho, abaho kakizudika ikisege mmidete mgamazi kumgwazo wa ulwanda lwa Naili. ");
INSERT INTO kdc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Lumbu jake ija imwana, kaifisa behi ili yalole choni chonda kimulawilile. ");
INSERT INTO kdc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Avo mndele wa Falao kahumuluka muulwanda yakoge, wasang'hanaji zake wa kitwanzi wakala otembela tembela kumgwazo wa ulwanda. Mndele wa Falao kachona kija ikisege mmisanze, kamtuma msang'hanaji wake yamgalile. ");
INSERT INTO kdc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mndele wa Falao viyakifungule ikisege acho kamona mwana, kakala kolila. Heyo kamonela bazi, kalonga, “Imwana ino vivija wa Waebulania.” ");
INSERT INTO kdc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Bahaja lumbu jake mwana ija kalawilila kamuuza mndele wa Falao, “Kolonda nichole kumkema mtwanzi wa Kiebulania yakong'hezele mwana ino?” ");
INSERT INTO kdc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mndele wa Falao kamwidika, “Ona, genda kamkeme.” Avo mndele ayo kachola kumkema mamake imwana ayo. ");
INSERT INTO kdc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mndele wa Falao kamulongela mtwanzi ayo, “Msole imwana ino unyong'hezele, na niye nokuliha fungu jako.” Avo mtwanzi ayo kamsola imwana na kumong'heza. ");
INSERT INTO kdc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwana viyakalile mbala goya, kamgala kwa mndele wa Falao, heyo kamsola na kamtenda mwanage. Kalonga, “Kwavija nimvabula mgamazi,” avo kamkema Musa, fambulo jake kuvabula. ");
INSERT INTO kdc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musa viyakulile, kachola kuwatembelela ndugu zake Waebulania, kawona viwananahizwe kusang'hana sang'hano ndala. Kamona Mmisili imoja komtowa Muebulania, imoja wa Waebulania wayage. ");
INSERT INTO kdc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa kawegesela na viyone kuduhu munhu yomulola, kamkoma Immisili na kamfisa mmisanga. ");
INSERT INTO kdc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Imitondo yake, Musa kachola kabili kawona Waebulania wabili oitowa. Avo kamuuza ija yomonela miyage, “Habali komtowa miyago?” ");
INSERT INTO kdc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Munhu ayo kamwidika, “Nani yakwikile uwe kilongozi wetu na msemi wetu? Kolonda kunikoma kamba vuumkomile ija Immisili?” Avo Musa kadumba na kailongela mwenyego, “Kumbe wanhu oijuwa mbuli ino!” ");
INSERT INTO kdc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Falao viyaihulike mbuli ayo ilawilile, kalonda kumkoma Musa, lakini Musa kakimbila kachola kukala mwiisi ya Midiani, kakala behi na sima. ");
INSERT INTO kdc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Avo wandele saba wa mulava nhosa wa kuko Midiani weza kudeha mazi ili wazing'weze fugo za tatao. ");
INSERT INTO kdc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Wasusilaji wayagwe weza wawawinga wandele awo. Lakini Musa keza kawataza wandele awo kwa kuzing'weza mazi fugo zao. ");
INSERT INTO kdc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Viwabwelile kwa tatao Leueli, kawauza, “Habali lelo mulopola kubwela?” ");
INSERT INTO kdc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wao wamwidika, “Mmisili imoja katutaza mmakono ga wasusilaji waja, heyo mwenyego katudehela mazi na kuzing'weza fugo zetu.” ");
INSERT INTO kdc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tatao kawauza wandele zake, “Kakwahi? Habali mmuleka kuko? Mkemeni yeze yaje hamoja na siye.” ");
INSERT INTO kdc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Avo Musa katogola kukala kwa munhu ayo, avo munhu ayo kamgwaa Musa mndele wake yakemigwe Sipola yawe mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola kamulelela Musa mwana wa kimbigalo. Musa kailongela mwenyego, “Niye sili mwenekae mwiisi ino.” Avo kamgwaa twaga mwana ayo Gelishomu, fambulo jake munhu baki. ");
INSERT INTO kdc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Miyaka mingi viibitile mndewa wa Misili kafa, lakini Waizilaeli wagangamala na wamulilila Imulungu kwavija wakala watumwa. ");
INSERT INTO kdc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Imulungu kahulika kuiyalala kwao, na heyo kakumbuka lagano jake diyatendile na Abulahamu na Isaka na Yakobo. ");
INSERT INTO kdc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Imulungu kawalola Waizilaeli na kajuwa viwodununzwa. ");
INSERT INTO kdc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa kakala kodisusila bumbila da ng'hondolo wa tata mkwe wake Yetulo, imulava nhosa wa ako Midiani. Musa kadigala bumbila dijo mwambu wa kuluwala na kavika Holebu, kulugongo lwa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Baho, msenga wa Mndewa Imulungu kamulawilila Musa mna dilambi da moto ulawile hagati ya ikisolo. Musa kachona ikisolo chokwaka moto lakini hakilukula. ");
INSERT INTO kdc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa kagelegeza, “Beta ng'hwese behi ndole unzonza uno, habali kisolo chokwaka lakini hakilukula.” ");
INSERT INTO kdc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mndewa Imulungu viyamonile kakwesa behi, kamkema kulawa kuna ikisolo! “Musa! Musa!” Musa kedika, “Niye nabaha.” ");
INSERT INTO kdc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Imulungu kamulongela Musa, “Sikuukwese behi! Vula vilatu vako kwavija aho hawimile hong'ala.” ");
INSERT INTO kdc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Abaho Imulungu kamulongela, “Niye na Imulungu wa tatako, Imulungu wa Abulahamu na Imulungu wa Isaka na Imulungu wa Yakobo.” Avo Musa kagubika kihanga chake kwavija kadumba kumulola Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Abaho Mndewa Imulungu kamulongela, “Nigona madununzo gowopata wanhu zangu weli kuko Misili. Mhulika viwoiyalala kwa kudununzwa na waja owemilila. Kwavija nojuwa viwogaya, ");
INSERT INTO kdc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","avo nihumuluka ili niwakombole walawe mmakono gawa Misili na niwagale mwiisi ng'hulu na inogile, isi imemile uki na maziwa, isi ya Wakanaani na Wahiti na Waamoli na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO kdc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Na sambi kililo cha Waizilaeli kinivikila na niwona Wamisili viwowadununza. ");
INSERT INTO kdc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sambi nokutuma kwa Falao, ili uwalave wanhu zangu wa Izilaeli mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Lakini Musa kamulongela Imulungu, “Niye na nani mbaka nichole kwa Falao, nikawalave Waizilaeli mwiisi ya Misili?” ");
INSERT INTO kdc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Imulungu kamulongela, “Niye nokuwa hamoja na gweye. Vonda uwalave wanhu wa Izilaeli mwiisi ya Misili, monitambikila niye kulugongo luno. Acho chokuwa kilagusa kamba niye nikutuma.” ");
INSERT INTO kdc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa kamulongela Imulungu, “Nahachola kwa Waizilaeli kuwalongela, ‘Imulungu wa wahenga zenu kanhuma kumwenu,’ wao wahaniuza, ‘Twaga jake nani?’ Niwalongele choni?” ");
INSERT INTO kdc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Imulungu kamulongela Musa, “Nene iyo Nene. Vino vivo viulondigwa kuwalongela Waizilaeli, ‘Ija yokemigwa Nene iyo Nene, kanhuma kumwenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Imulungu kamulongela Musa, “Walongele Waizilaeli kamba, ‘Niye Mndewa Imulungu, Imulungu wa wahenga zenu, Imulungu wa Abulahamu na Imulungu wa Isaka na Imulungu wa Yakobo nikutuma kumwao.’ Dino dijo twaga jangu milele, vino vivo ulelo wose vonda wanikumbuke. ");
INSERT INTO kdc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Genda ukaiting'hane na wavele wa Izilaeli walongele kamba, ‘Niye Mndewa Imulungu, Imulungu wa wahenga zenu, Imulungu wa Abulahamu na Imulungu wa Isaka na Imulungu wa Yakobo, kandawila na kanilongela.’ Walongele, ‘Niwalola goya na nigona gaja gomutendeligwa mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Na niye nilonga kamba nowalava mwiisi ya Misili kuna gamagazo, nowagala mwiisi ya Wakanaani na Wahiti na Waamoli na Wapelizi na Wahivi na Wayebusi mwiisi imemile uki na maziwa.’ ");
INSERT INTO kdc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Wao okutegeleza, abaho gweye na wavele wa Izilaeli mochola kwa mndewa wa Misili na kumulongela, ‘Mndewa Imulungu, Imulungu wa Waebulania katulawila siye. Avo tutogolele tuchole kwa siku ndatu kuluwala tukamulavile nhosa Mndewa Imulungu wetu.’ ");
INSERT INTO kdc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nojuwa mndewa wa Misili honda yawatogolele muchole mbaka yananahizwe kwa nguvu. ");
INSERT INTO kdc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Lakini nougolosa mkono wangu na kuwakoboza Wamisili kwa vilaguso vonda nitende kuko. Abaho Falao kowaleka musegele. ");
INSERT INTO kdc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Abaho nowatenda Wamisili wawatendele ganogile Waizilaeli ili vonda musegele mwiisi ya Misili, sikumusegele makono gaiyeka. ");
INSERT INTO kdc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kila mtwanzi wa Kiebulania yampule Mmisili yokala behi na heyo hebu mgeni yokala mng'anda yake viwalo na vinhu va kuihamba va zahabu na shaba. Avo mowavaza wanenu wa kitwanzi na wa kimbigalo vinhu avo vose. Vino vivo vonda musole vinhu va Wamisili.” ");
INSERT INTO kdc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Abaho Musa kamulongela Mndewa Imulungu, “Avo yokuwaze kamba Waizilaeli hawanhogola na hawanitegeleza vonda niwalongele. Onongela, ‘Mndewa hakulawile bule’?” ");
INSERT INTO kdc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Avo Mndewa Imulungu kamuuza, “Kugoga choni mmakono?” Kamwidika “Fimbo.” ");
INSERT INTO kdc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mndewa kamulongela, “Ibwanhe hasi.” Musa viyaibwanhe hasi, igaluka mgendela hasi, Musa kakimbila. ");
INSERT INTO kdc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Abaho Mndewa Imulungu kamulongela Musa, “Golosa mkono wako mgoge umkila.” Avo Musa kagolosa mkono wake kamgoga umkila, na imgendela hasi kagaluka fimbo kabili. ");
INSERT INTO kdc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mndewa Imulungu kamulongela, “Utende vino ili Waizilaeli watogole kamba niye Mndewa, Imulungu wa wahenga zao, Imulungu wa Abulahamu na Imulungu wa Isaka na Imulungu wa Yakobo nikulawila.” ");
INSERT INTO kdc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mndewa Imulungu kamulongela kabili Musa, “Ingiza mkono wako mna ikiwalo chako.” Avo Musa kengiza mkono wake mna ikiwalo chake na viyaulavile kunze, ukala na utamu wa dikulu ukala mzelu kamba pamba. ");
INSERT INTO kdc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Abaho Imulungu kamulongela, “Ingiza kabili mkono wako mna ikiwalo chako!” Musa kawingiza mkono wake mna ikiwalo chake, viyaulavile kunze mkono wake ubwela kamba viwili lukuli lwake. ");
INSERT INTO kdc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Imulungu kamulongela Musa, “Kamba oleka kukutogola kwa unzonza wa ichanduso, odaha kutogola kwa unzonza wa kabili. ");
INSERT INTO kdc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Lakini kamba hawakutogole kwa vinhu avo vibili, wahalema kukutegeleza kwa gaja gaulongile, deha mazi ga lwanda lwa Naili ugete mwiisi. Mazi gago gogaluka damu.” ");
INSERT INTO kdc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa kamulongela Mndewa Imulungu, “Aka Mndewa sikuunhume niye. Niye sidahile bule kulonga goya toka mwaka, hata sambi viusongile kulonga na niye msang'hanaji wako. Niye sili mulongaji.” ");
INSERT INTO kdc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mndewa Imulungu kamuuza, “Nani yalumbile mulomo wa munhu? Nani yomtenda munhu sikuyalonge hebu mvugu? Yalole hebu msuwameso? Vino sili niye Mndewa Imulungu? ");
INSERT INTO kdc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Avo, genda! Nokutaza kulonga, nokufunza cha kulonga.” ");
INSERT INTO kdc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Lakini Musa kamwidika, “Mndewa wangu, chonde mtume munhu iyagwe.” ");
INSERT INTO kdc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mndewa Imulungu kamgevuzikila Musa, kamulongela, “Gweye sikunayo ndugu yako Haluni ija Imulawi? Nojuwa heyo kodaha kulonga vinogile. Sambi kamnzila kokwiza kuiting'hana na gweye na yahakona kodeng'helela. ");
INSERT INTO kdc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Gweye longa nayo na mulongele gaja gonda yalonge. Niye nowataza, na kuwafunza ga ukusang'hana. ");
INSERT INTO kdc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Haluni kolonga na Waizilaeli hanhu hako. Heyo kokuwa mulongaji wako na gweye kokuwa kamba Imulungu kumwake. ");
INSERT INTO kdc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sola ifimbo ino ili mmakono gako, avo koitumia kutenda unzonza.” ");
INSERT INTO kdc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Abaho Musa kabwela kwa Yetulo, tata mkwe yake, kamulongela, “Chonde nokupula nhogolela nibwele Misili kwa ndugu zangu, nikawakagule kamba wang'hali wagima.” Yetulo kamulongela, “Genda moyo uholile.” ");
INSERT INTO kdc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa viyakalile yang'hali mwiisi ya Midiani, Mndewa Imulungu kamulongela, “Bwela Misili kwavija waja wose walondile kukukoma wafa.” ");
INSERT INTO kdc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Avo Musa kamsola mwehe wake na wanage, kawakweza mumgongo wa kihongwe, kasonga mwanza wa kubwela Misili, Musa kasola fimbo iyalongeligwe na Imulungu yaisole. ");
INSERT INTO kdc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mndewa Imulungu kamulongela Musa, “Wahavika mwiisi ya Misili sang'hana mgameso ga Falao unzonza wose unikugwelele udahi wa kusang'hana. Lakini noutenda moyo wa Falao uwe mdala avo honda yawaleke Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Abaho gweye komulongela Falao, Mndewa Imulungu kalonga vino, ‘Wanhu wa Izilaeli kamba mwanangu chaudele wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Na niye nokulongela muleke mwanangu yasegele, ili yakanitambikile, lakini humulekesa bule yasegele, avo nomkoma chaudele wako wa kimbigalo.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Viyakalile yang'hali mnzila kobwela Misili, Musa kakala mng'anda ya kuwasa wageni, Mndewa Imulungu kamcholela kalonda kumkoma. ");
INSERT INTO kdc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Lakini Sipola mwehe wake Musa kasola dibwe dikutwa, kadikanha govi da mwanage, kamkwasa najo mmagulu gake, kalonga, “Gweye kwa mkasano wa damu kumwangu.” ");
INSERT INTO kdc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Avo Mndewa Imulungu kamuleka Musa yawe mgima, kwavija Sipola viyamwingize kumbi kakala yalongile, “Mkasano wa damu.” ");
INSERT INTO kdc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mndewa Imulungu kamulongela Haluni, “Chola kuluwala ukaiting'hane na Musa.” Avo Haluni kachola kuiting'hana na Musa kulugongo lwa Imulungu, viyamone kamnonela. ");
INSERT INTO kdc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Abaho Musa kamulongela Haluni gaja gose gayalongeligwe na Mndewa Imulungu viyamulongele yabwele Misili, vivija kamulongela unzonza wose uyalongeligwe yasang'hane. ");
INSERT INTO kdc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Avo Musa na Haluni wachola Misili, wawakema wavele wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Haluni kawalongela gose Mndewa Imulungu gayamulagize Musa na vivija Musa katenda unzonza mgameso ga wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wanhu watogola, na viwahulike kamba Mndewa kawezila na kagona madununzo gao na kolonda kuwataza, waidulika wamtambikila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Abaho Musa na Haluni wachola kwa Falao wamulongela, “Mndewa Imulungu, Imulungu wa Izilaeli kolonga vino, ‘Waleke wanhu zangu wasegele, wakanitendele nyimwilinyimwili kuluwala.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Lakini Falao kawauza, “Mndewa Imulungu ayo nani mbaka nimtegeleze na niwaleke Waizilaeli wasegele? Niye simjuwile bule ayo Mndewa Imulungu, na siwaleka Waizilaeli wasegele.” ");
INSERT INTO kdc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa na Haluni wamwidika, “Imulungu wa Waebulania katulawila siye. Tuleke tuchole kuluwala kwa mwanza wa siku ndatu tukamulavile nhosa Mndewa Imulungu wetu. Wahalema sikutusegele Mndewa Imulungu kotukoma kwa mitamu hebu kwa ng'hondo.” ");
INSERT INTO kdc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mndewa wa Misili kawedika, “Gweye Musa na miyago Haluni habali mowatenda wanhu waleke kusang'hana? Bweleni mzisang'hano zenu.” ");
INSERT INTO kdc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Abaho Falao kalonga kabili, “Wanhu wenu wengi kubanza wanhu wa isi yangu, na sambi mweye molonda waleke kusang'hana!” ");
INSERT INTO kdc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Siku didija Falao kawalagiza Wamisili iwakulu wa watumwa hamoja na iwemilizi owemililaga Waizilaeli wayao, kalonga, ");
INSERT INTO kdc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Sikumuwagwelele Waizilaeli minyomvi ya kutendela matofali, walekeni wenyego wachole kuizahila. ");
INSERT INTO kdc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Lakini wingi wa matofali gondawatende uwe uuja kamba wa siku zose, na sikudiswele hata tofali dimoja, kwavija wanhu wano wanyeka, lekaavo onongela, ‘Tuleke tuchole tukamulavile nhosa Imulungu wetu.’ ");
INSERT INTO kdc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wengezeni wanhu wano sang'hano ndala zonda ziwatende sikuwategeleze mbuli za uvizi.” ");
INSERT INTO kdc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Avo Wamisili iwakulu wa watumwa hamoja na iwemilizi owemililaga Waizilaeli wayao wachola kwa iwanhu kuwalongela, “Falao kalonga vino, ‘Siwagwelela kabili minyomvi. ");
INSERT INTO kdc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gendeni mweye wenyego kokose kumudaha kuipata, lakini wingi wa matofali uwe vivija kamba siku zose.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Avo wanhu wapwililika kila hanhu mwiisi ya Misili kuzahila minyomvi. ");
INSERT INTO kdc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nao Wamisili iwakulu wa watumwa, wawalagiza wanhu walonga, “Tendeni matofali kamba gaja gamukalile motenda siku zose vimukalile mogaliligwa minyomvi.” ");
INSERT INTO kdc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wamisili iwakulu wa watumwa wawatowa iwemilizi owemililaga Waizilaeli wayao, wasaguligwe kwimilila sang'hano kuno owalongela, “Habali hamuvikize wingi wa matofali gagaja kamba vimutendaga siku zose?” ");
INSERT INTO kdc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Abaho iwemilizi owemililaga Waizilaeli wayao wachola kwa Falao, wamulongela, “Go, mkulu habali kotutendela vino siye wasang'hanaji zako? ");
INSERT INTO kdc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hatugweleligwa kabili minyomvi na kuno tolongeligwa tutende matofali. Abaho totoigwa lakini wabanange wanhu zako mwenyego.” ");
INSERT INTO kdc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falao kawedika, “Mweye mnyeka, na hamulonda kusang'hana, lekaavo monongela, ‘Tuleke tuchole tukamulavile nhosa Mndewa Imulungu.’ ");
INSERT INTO kdc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Bweleni kusang'hana! Honda mugweleligwe minyomvi, lakini molondigwa mutende matofali kamba gaja gamutendaga siku zose.” ");
INSERT INTO kdc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Avo iwemilizi owemililaga Waizilaeli wayao wayona wa mmagazo ng'hani kwavija walongeligwa, “Mutende matofali kamba gaja gamutendaga siku zose.” ");
INSERT INTO kdc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Viwasegele kwa Falao, wamting'hana Musa na Haluni wakala owabeta. ");
INSERT INTO kdc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Avo wawalongela, “Mndewa Imulungu yakilole kija kimutenda na yawataguse mweye kwavija mumtenda Falao na wasang'hanaji zake watwihile. Mweye muwagwelela mbuli ya kutukomela.” ");
INSERT INTO kdc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Abaho Musa kachola kwa Mndewa Imulungu kabili kamulongela, “Mndewa Imulungu habali kowatendela gehile wanhu wano? Avo kumbe kino acho kiunitumile? ");
INSERT INTO kdc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Toka vinicholile na kulonga na Falao kwa twaga jako, mndewa ayo kowatendela gehile wanhu wano, na gweye hutendile kinhu chochose kuwakombola wanhu zako.” ");
INSERT INTO kdc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Abaho Mndewa Imulungu kamulongela Musa, “Sambi kochona chonda nimtendele Falao. Kwa udahi wangu kowaleka wanhu zangu wasegele. Nayo kowawinga wasegele mwiisi yake kwa udahi wangu.” ");
INSERT INTO kdc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Imulungu kamulongela Musa, “Niye na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nimulawilila Abulahamu na Isaka na Yakobo, njuwika kamba Imulungu yeli na Udahi wose, lakini siwalongele bule kamba twaga jangu Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Vivija niilagana nao kuwagwaa isi ya Kanaani, kuko kuwakalile kamba wanhu baki. ");
INSERT INTO kdc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Sambi nihulika kuiyalala kwa Waizilaeli viwodununzwa na Wamisili, avo nidikumbuka lagano jangu. ");
INSERT INTO kdc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Walongele Waizilaeli vino, ‘Niye Mndewa Imulungu, nowalava mwiisi ya Misili. Nowatenda mulekeswe kulawa muutumwa. Nougolosa mkono wangu na nowakoboza Wamisili na kuwakombola mweye. ");
INSERT INTO kdc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nowatenda muwe wanhu zangu, na niye nokuwa Imulungu wenu. Mojuwa kamba niye na Mndewa Imulungu, Imulungu wenu, vonda niwalave muutumwa ako Misili. ");
INSERT INTO kdc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nowagala mwiisi ija inilongile kwa kuiduwila nowagwaa Abulahamu na Isaka na Yakobo. Nowagwaa mweye isi ayo iwe yenu. Niye na Mndewa Imulungu.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa kawalongela Waizilaeli mbuli azo, lakini hewo hawamtegeleze bule, kwavija wakala na lusikisiki mmizoyo yao mbuli ya magazo ga utumwa. ");
INSERT INTO kdc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Genda kamulongele Falao, mndewa wa Misili, yawaleke Waizilaeli wasegele mwiisi yake.” ");
INSERT INTO kdc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Lakini Musa kamwidika Mndewa Imulungu, “Kamba Waizilaeli hawanitegeleze, avo Falao konitegeleza vilihi? Na niye munhu mwenyego sili mulongaji.” ");
INSERT INTO kdc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Lakini Mndewa Imulungu kalonga na Musa na Haluni na kawalagiza wachole kwa Falao, mndewa wa Misili, wawalave Waizilaeli mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Gano gago matwaga ga iwahenga wakulu wa Waizilaeli. Wanage Lubeni chaudele wa Izilaeli wakala, Hanoki na Palu na Hesiloni na Kalimi. Wano wakala wahenga wa kabila da Lubeni. ");
INSERT INTO kdc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wanage Simeoni wakala, Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli yakalile mwana wa mtwanzi wa Kanaani. Wano wakala wahenga wa kabila da Simeoni. ");
INSERT INTO kdc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Gano gago matwaga ga wana wa kimbigalo wa Lawi, Gelishoni na Kohati na Melali. Lawi kawa mgima kwa miyaka gana na malongo madatu na saba. ");
INSERT INTO kdc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wanage Gelishoni wakala, iwakulu wa lukolo lwa Libini na Shimei. ");
INSERT INTO kdc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wanage Kohati wakala, Amulamu na Ishali na Hebuloni na Uzieli. Kohati kawa mgima kwa miyaka gana malongo madatu na ndatu. ");
INSERT INTO kdc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wanage Melali wakala, Mahili na Mushi. Wano awo iwahenga wa kabila da Lawi. ");
INSERT INTO kdc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulamu kamsola Yokebedi lumbu wa tatake, nayo kamulela Musa na Haluni. Amulamu kawa mgima kwa miyaka gana dimoja na malongo madatu na saba. ");
INSERT INTO kdc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wanage Ishali wakala, Kola na Nefegi na Zikili. ");
INSERT INTO kdc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wanage Uzieli wakala, Mishaeli na Elisafani na Sitili. ");
INSERT INTO kdc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haluni kamsola Elisheba, mndele wa Aminadabu na lumbu jake Nashoni, nayo kamulelela Nadabu na Abihu na Eleazali na Itamali. ");
INSERT INTO kdc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wanage Kola wakala, Asili na Elikana na Abiasafu, wano wakala wahenga wa lukolo lwa Kola. ");
INSERT INTO kdc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazali mwanage Haluni kamsola mndele wa Putieli, nayo kamulelela Finehasi. Wano awo iwahenga wakulu wa kabila da Lawi. ");
INSERT INTO kdc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Musa na Haluni awo walongeligwe na Mndewa Imulungu, “Muwalave Waizilaeli mwiisi ya Misili kwa ng'holo zao.” ");
INSERT INTO kdc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ona awo wamulongele Falao, mndewa wa Misili, yawaleke Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kipindi acho Mndewa Imulungu viyalongile na Musa mwiisi ya Misili, ");
INSERT INTO kdc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kamulongela, “Niye na Mndewa Imulungu. Mulongele Falao, mndewa wa Misili, gaja gose gonikulongela.” ");
INSERT INTO kdc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Lakini Musa kamwidika Mndewa Imulungu, “Niye sili mulongaji, avo Falao konitegeleza vilihi?” ");
INSERT INTO kdc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Avo Mndewa Imulungu kamulongela Musa, “Nokutenda gweye kamba Imulungu kwa Falao, na ndugu yako Haluni kokuwa kamba mtula ndagu wako. ");
INSERT INTO kdc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mulongele ndugu yako Haluni gaja gose gonda nikulagize, nayo Haluni komulongela Falao yawaleke Waizilaeli wasegele mwiisi yake. ");
INSERT INTO kdc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Lakini noutenda moyo wa Falao uwe mdala. Hata nahakongeza unzonza na vilaguso mwiisi ya Misili, ");
INSERT INTO kdc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Falao hakutegeleza bule. Abaho nougolosa mkono wangu uli na udahi na kuwakoboza Wamisili na nozilava ng'holo za Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na Wamisili ojuwa kamba niye na Mndewa Imulungu vonda niugolose mkono wangu kumwao na kuwalava Waizilaeli mwiisi yao. ");
INSERT INTO kdc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Haluni wasang'hana kamba viwalagizwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Kipindi viwalongile na Falao, Musa kakala na miyaka malongo nane na Haluni kakala na miyaka malongo nane na ndatu. ");
INSERT INTO kdc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Mndewa wa Misili yahawalongela, ‘Tendeni unzonza,’ mulongele Haluni yasole fimbo yake yaibwanhe hasi mgameso ga Falao, nayo yogaluka mgendela hasi.” ");
INSERT INTO kdc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Avo Musa na Haluni wachola kwa Falao na watenda kamba viwalagizwe na Mndewa Imulungu. Haluni kaibwanha hasi fimbo yake mgameso ga Falao na watawala wake, nayo igaluka mgendela hasi. ");
INSERT INTO kdc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Abaho Falao kawakema wanhu wake weli na nzewele na wahawi wake, na kwa uhawi wao watenda vivija. ");
INSERT INTO kdc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kila imoja wao kaibwanha hasi fimbo yake, na fimbo zao zigaluka mgendela hasi. Lakini fimbo ya Haluni igaluke mgendela hasi izimeza fimbo zao zigaluke mgendela hasi. ");
INSERT INTO kdc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hata avo zoyo da Falao dikala dala na hawategeleze bule Musa na Haluni, kamba Mndewa Imulungu viyalongile. ");
INSERT INTO kdc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Abaho Mndewa Imulungu kamulongela Musa, “Moyo wa Falao mdala na kolema kuwaleka Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Avo uidamuke ulukwili ukaiting'hane na Falao viyochola kuulwanda lwa Naili. Isole fimbo ija igaluke mgendela hasi, umbete kumgwazo wa lwanda. ");
INSERT INTO kdc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Abaho umulongele vino, ‘Mndewa Imulungu, Imulungu wa Waebulania, kanhuma kumwako nikulongele uwaleke wanhu zake wasegele, wachole wakamtambikile kuluwala, lakini mbaka sambi gweye hutegeleza. ");
INSERT INTO kdc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Avo Mndewa Imulungu kolonga vino, sambi komjuwa heyo iyo nani. Nogatowa mazi ga lwanda lwa Naili kwa fimbo ino, na mazi gose gogaluka damu. ");
INSERT INTO kdc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Somba weli muulwanda lwa Naili wofa, lwanda lonung'ha bundo, na Wamisili honda walonde kugang'wa mazi gake.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mndewa Imulungu kamulongela Musa, “Mulongele Haluni yasole fimbo yake na yaigolose uchanha ya mazi gose ga Misili, mvizanda vose mna imifuluta mna ivikolongo vose na mna gamalamba, vose avo vogaluka damu. Damu yokuwa kila hanhu mwiisi yose hata mna iviya va mibiki na mabwe.” ");
INSERT INTO kdc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Haluni watenda kamba Mndewa Imulungu viyawalagize. Haluni kenula fimbo yake mgameso ga Falao na watawala zake kagatowa mazi ga lwanda lwa Naili, na mazi gose gagaluka damu. ");
INSERT INTO kdc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Somba wakalile muulwanda lwa Naili wafa. Mazi gake ganung'ha bundo mbaka Wamisili hawadahile kugang'wa mazi gake. Damu ikala kila hanhu mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Lakini wahawi wa Misili kwa uhawi wao watenda kamba vivo. Avo zoyo da Falao digendelela kuwa dala, na heyo hawategeleze Musa na Haluni kamba viyalongile Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Avo, Falao kabwela ukae kumwake, na hagagelegeze gaja galawilile. ");
INSERT INTO kdc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Wamisili wose wakala ohimba kumgwazo wa lwanda lwa Naili wapate mazi ga kung'wa, kwavija hawadahile kung'wa mazi ga lwanda lulo. ");
INSERT INTO kdc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Zibita siku saba toka Mndewa Imulungu viyagagaluse mazi ga lwanda. ");
INSERT INTO kdc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Abaho Mndewa Imulungu kamulongela Musa, “Chola kwa Falao mulongele Imulungu kolonga, ‘Waleke wanhu zangu wasegele, wakanitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Wahalema, noibananga isi yako kwa kugala mibula. ");
INSERT INTO kdc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lwanda lwa Naili lomema mibula na mibula ayo yokwingila mng'anda yako na mdigati jako na mulusazi lwako luuwasa, na mzing'anda za watawala zako na mzing'anda za wanhu zako hata mna iviya venu va kutelekela. ");
INSERT INTO kdc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mibula ayo yokwela mulukuli lwako, na mna izing'huli za wanhu zako na watawala zako.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mndewa Imulungu kamulongela Musa, “Mulongele Haluni yenule fimbo yake uchanha ya vizanda na imifuluta na vikolongo, na mibula yolawilila na kuigubika isi yose ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Avo Haluni kenula fimbo yake uchanha ya mazi gose ga Misili, na mibula ilawilila na kuigubika isi yose ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Lakini wahawi wa Misili watenda kamba vivo kwa uhawi wao, na vivija watenda mibula ilawilile mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Abaho Falao kawakema Musa na Haluni kawalongela, “Mpuleni Mndewa Imulungu yaisegese mibula ino kumwangu na kwa wanhu zangu, na niye nowaleka wanhu zenu wachole kumulavila nhosa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa kamwidika Falao, “Sagula gweye lini kolonda nikupulile gweye hamoja na watawala zako na wanhu zako mibula isegele mzing'anda zenu na wasigale muulwanda wiiyeka.” ");
INSERT INTO kdc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falao kalonga, “Nipulile mayo.” Musa kamwidika, “Notenda kamba viulongile ili ujuwe kuduhu yoyose yaigalile na Mndewa Imulungu, Imulungu wetu. ");
INSERT INTO kdc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mibula ayo yosegela kumwako na mzing'anda zenu na watawala wako na kwa wanhu zako, mibula ayo yosigala muulwanda wiiyeka.” ");
INSERT INTO kdc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Abaho Musa na Haluni wasegela kwa Falao, Musa kampula Mndewa Imulungu, yaisegese mibula ikalile kwa Falao. ");
INSERT INTO kdc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mndewa Imulungu katenda kamba Musa viyampulile. Mibula ikalile mzing'anda na mna gamabuga na mmigunda ifa. ");
INSERT INTO kdc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wanhu waika hamoja mibula yose ifile, na isi yose inung'ha bundo. ");
INSERT INTO kdc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lakini Falao viyonile mibula ifa, zoyo jake dikala dala kabili, hawategeleze Musa na Haluni kamba Mndewa Imulungu viyalongile. ");
INSERT INTO kdc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Abaho Mndewa Imulungu kamulongela Musa, “Mulongele Haluni, yenule fimbo yake yatoe timbwisi da isi, najo dogaluka mhani mwiisi yose ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Avo Haluni viyenule fimbo yake na kuitowa hasi, timbwisi digaluka mhani wawananahila wanhu na wanyama. Timbwisi jose da isi ya Misili digaluka mhani. ");
INSERT INTO kdc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wahawi wa Misili kwa uhawi wao wageza kugalusa timbwisi diwe mhani lakini hawadahile bule. Mhani wakala wenele kwa wanhu na wanyama. ");
INSERT INTO kdc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Wahawi wamulongela Falao, “Uno mkono wa Imulungu!” Lakini zoyo da Falao digendelela kuwa dala na halondile kuwategeleza Musa na Haluni kamba Mndewa Imulungu viyalongile. ");
INSERT INTO kdc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mndewa Imulungu kamulongela Musa, “Uidamuke ulukwili ukaiting'hane na Falao viyochola kuulwanda. Mulongele kamba Mndewa Imulungu kolonga, ‘Waleke wanhu zangu wasegele, wakanitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Wahalema kuwaleka wasegele, nogala mikonzi kumwako gweye na watawala zako na kwa wanhu zako wose. Ng'anda za Wamisili zomema mikonzi na vivija isi yose yomema mikonzi. ");
INSERT INTO kdc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Lakini mdisiku dijo kuna umwambu wa Gosheni, kuko kowokala wanhu zangu kokuwa kuduhu mikonzi, ili ujuwe kamba niye Mndewa Imulungu nosang'hana mwiisi ino. ");
INSERT INTO kdc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nowabagula wanhu wako na wanhu wangu, unzonza uno noutenda mayo.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Avo Mndewa Imulungu katenda kamba viyalongile, kagala madali ga mikonzi ingile mng'anda ya Falao na mna zing'anda za watawala zake. Isi yose ya Misili inangigwa na mikonzi ayo. ");
INSERT INTO kdc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Abaho Falao kamkema Musa na Haluni kawalongela, “Gendeni mkamulavile nhosa Imulungu wenu mmuno mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa kamwidika, “Aka havinogile bule kutenda vivo, kwavija nhosa zonda tumulavile Mndewa Imulungu wetu zowagevuza Wamisili. Avo twahalava nhosa ziwagevuza okwiza kutukoma kwa mabwe. ");
INSERT INTO kdc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tolondigwa tugende mwanza wa siku ndatu kuluwala, tukamulavile nhosa Mndewa Imulungu wetu, kamba viyatulagize.” ");
INSERT INTO kdc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Falao kalonga, “Nowaleka musegele muchole mkamulavile nhosa kuluwala Mndewa Imulungu, Imulungu wenu, lakini sikumuchole kutali ng'hani. Mhulileni na niye.” ");
INSERT INTO kdc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa kamwidika Falao, “Nahasegela hano nompula Imulungu, mayo mikonzi ino yosegesigwa kumwako gweye, na kwa watawala wako na kwa wanhu zako. Lakini sikuutuvizile kabili na kuwagomesa wanhu sikuwachole kumulavila nhosa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Abaho Musa kasegela kwa Falao, na kampula Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mndewa Imulungu katenda vivija kamba Musa viyapulile. Mikonzi isegela kwa Falao, na kwa watawala zake na kwa wanhu zake, kuduhu hata ng'honzi imoja yasigale. ");
INSERT INTO kdc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Lakini hata mwanza uno zoyo da Falao dikala dala na hawalekile Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Abaho Mndewa kamulongela Musa, “Genda kwa Falao mulongele, Mndewa Imulungu, Imulungu wa Waebulania, kolonga, ‘Waleke wanhu zangu wasegele, wakanitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Wahalema kuwaleka wasegele, ");
INSERT INTO kdc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nougolosa mkono wangu na kugala mitamu mzifugo zako zose, ng'ombe na falasi na vihongwe na ngamiya na mbuzi na ng'hondolo. ");
INSERT INTO kdc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Lakini Mndewa Imulungu kobagula fugo za Waizilaeli na fugo za Wamisili, avo mzifugo za Waizilaeli kokuwa kuduhu hata mnyama imoja yonda yafe.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mndewa Imulungu keka siku kalonga, “Mayo Mndewa kotenda mbuli ino mwiisi ino.” ");
INSERT INTO kdc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Imitondo yake Mndewa Imulungu katenda kamba viyalongile, na fugo zose za Misili zifa, kuduhu hata mnyama imoja wa Waizilaeli yafile. ");
INSERT INTO kdc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falao kawatuma wanhu wakauze mbuli ya fugo za Waizilaeli, wamulongela kuduhu hata mnyama imoja wa Waizilaeli yafile. Lakini zoyo da Falao digendelela kuwa dala na halondile kuwaleka wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Abaho Mndewa Imulungu kamulongela Musa na Haluni, “Kila imoja yadehe mitozi ya tanuli ganza dimoja, abaho Musa yaipwililise uchanha mgameso ga Falao ");
INSERT INTO kdc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mitozi ayo yokuwa timbwisi na dopwililika mwiisi yose ya Misili. Timbwisi dijo dogala mipute na yahatumbuka yokuwa milonda kwa wanhu na wanyama mwiisi yose ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Avo wadeha mitozi kulawa mditanuli wachola kwa Falao, na Musa kaipwililisa uchanha mgameso ga Falao. Wanhu na wanyama wapata mipute na viitumbuke iwa milonda. ");
INSERT INTO kdc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Iwahawi hawadahile kwima kuulongozi wa Musa mbuli ya mipute ikalile kumwao na ikalile kwa Wamisili wose. ");
INSERT INTO kdc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Lakini Mndewa Imulungu kamtenda Falao yawe na moyo mdala na hawategeleze, kamba Mndewa Imulungu viyamulongele Musa. ");
INSERT INTO kdc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Abaho Mndewa Imulungu kamulongela Musa, “Lamuka imitondo ng'hani uchole kwa Falao. Mulongele kamba Mndewa Imulungu, Imulungu wa Waebulania kolonga, ‘Waleke wanhu zangu wasegele, wakanitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kwavija mwanza uno nokukoboza gweye na watawala zako na wanhu zako, baho kojuwa kamba kuduhu iyagwe mwiisi yose yaigalile na niye. ");
INSERT INTO kdc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kwavija mbaka sambi nahagolose mkono wangu na kukutowa gweye na wanhu zako na mwahafile mwaka. ");
INSERT INTO kdc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Lakini niwaleka muwe wagima kulagusa udahi wangu avo wanhu wose wa mwiisi wadijuwe twaga jangu. ");
INSERT INTO kdc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Lakini zoyo jako ding'hali dala na hulonda kuwaleka wanhu zangu wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Avo, mayo saa kamba ino nogala mvula ng'hulu ya mabwe nayo hainalawilila mwiisi ya Misili toka mwanduso wake mbaka lelo. ");
INSERT INTO kdc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Avo lagiza fugo zako zose na kila kinhu kili mmigunda kikigwe goya kwavija mvula ya mabwe yomtowela kila munhu na kila mnyama yeli kumgunda hebu kunze ya ng'anda na wose wofa.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Lakini watawala wa Falao wadumbile gaja gayalongile Mndewa Imulungu walopola wawasegesa watumwa zao na wanyama zao mmigunda wawagala mzing'anda. ");
INSERT INTO kdc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Lakini waja hawagagelegeze gaja gayalongile Mndewa Imulungu wazileka fugo zao na watumwa zao mmiguda. ");
INSERT INTO kdc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Abaho Mndewa Imulungu kamulongela Musa, “Golosa mkono wako uchanha kuulanga, ili mvula ya mabwe itowe kila hanhu mwiisi ya Misili, kwa kila munhu na kila mnyama na kila kinhu kili mmigunda.” ");
INSERT INTO kdc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa viyaugolose mkono wake uchanha kuulanga, Mndewa Imulungu kagala mvula ya mabwe na ng'huwa na mimwesa mwiisi. Avo Mndewa Imulungu kagala mvula ya mabwe kila hanhu mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mvula ng'hulu ya mabwe na mimwesa igendelela kutowa, kuduhu mwenekae yoyose wa Misili yawahile kuchona kinhu kamba acho. ");
INSERT INTO kdc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mvula ya mabwe itowa kila hanhu mwiisi ya Misili na ibananga migunda yose. Mvula ayo iwakoma wanyama wose na wanhu wose wakalile kunze, ibena vinhu vose vihandigwe mmigunda na mibiki. ");
INSERT INTO kdc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Lakini mvula ya mabwe haitowile mwambu wa Gosheni, kuko kuwakalile okala Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Falao kalagiza Musa na Haluni wakemigwe, kawalongela, “Mwanza uno nitenda nzambi, Mndewa Imulungu katenda goya, niye na wanhu zangu tubananga. ");
INSERT INTO kdc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mpuleni Mndewa Imulungu! Kwavija ng'huwa zino na mvula ino vibanza, niye nowaleka musegele na honda mukawe kusegela.” ");
INSERT INTO kdc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa kamwidika Falao, “Sambi baha nahasegela kudibuga dino, noigolosa mikono yangu nompula Mndewa Imulungu, mvula na ng'huwa voleka, na kokuwa kuduhu mvula ya mabwe, baho gweye kojuwa isi yose ya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Lakini nojuwa gweye na watawala zako hamumdumba bule Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Minoga ya kutendela viwalo va kitani na shayili vose vikala vinangigwe, kwavija shayili ikala yosonga kunamiza na minoga ya kutendela viwalo va kitani ikala yokwalika. ");
INSERT INTO kdc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Lakini ngano na minoga iyagwe iigalile na ngano havinangigwe kwavija vikawaga kukangala. ");
INSERT INTO kdc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Avo Musa kasegela kwa Falao, kachola kunze kudibuga, kagolosa makono gake kampula Mndewa Imulungu. Ng'huwa na mvula ya mabwe vileka kutowa. ");
INSERT INTO kdc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Falao viyonile mvula ya mabwe na ng'huwa vileka kutowa, katenda nzambi kabili, heyo na watawala zake watenda mizoyo yao iwe midala. ");
INSERT INTO kdc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Avo, kalema kuwaleka Waizilaeli wasegele, kamba Mndewa Imulungu viyalongile kwa mulomo wa Musa. ");
INSERT INTO kdc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Abaho Mndewa Imulungu kamulongela Musa, “Genda kwa Falao, kwavija niye niwatenda heyo na watawala zake wawe na mizoyo midala ili nitende unzonza hagati yao. ");
INSERT INTO kdc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Avo, mweye muwasimulile wanenu na wazukulu zenu, viniwagelile bumbuwazi Wamisili kwa kutenda vilaguso hagati yao, na baho mweye mojuwa kamba niye na Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Avo Musa na Haluni wachola kwa Falao wamulongela, “Mndewa Imulungu wa Waebulania kolonga, ‘Mbaka lini kolema kugwa kingubanguba kuulongozi wangu? Waleke wanhu zangu wasegele, wakanitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Wahalema kuwaleka wanhu zangu wasegele, mayo nogala mbalangulu mwiisi yako. ");
INSERT INTO kdc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Isi yose yogubikigwa na mbalangulu na kuduhu hanhu honda honeke. Na woja kila kinhu kidodo kisigasigwe na mvula ya mabwe, vivija woja hata mibiki isigale. ");
INSERT INTO kdc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mbalangulu wao omema mzing'anda zako na mzing'anda za watawala zako na ng'anda za Wamisili wose. Okuwa wengi hata wahenga zenu hawanachona kinhu kamba acho toka viwaleleke mbaka lelo.’ ” Abaho Musa kasegela kwa Falao. ");
INSERT INTO kdc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Watawala wa Falao wamuuza, “Vino, munhu ino kotugaza mbaka lini? Waleke Waizilaeli wasegele, wakamtambikile Mndewa Imulungu wao. Vino hulola kamba isi ya Misili yobanangika?” ");
INSERT INTO kdc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Abaho Musa na Haluni wakemigwa wabweleganye kwa Falao, nayo Falao kawalongela, “Gendeni mkamtambikile Mndewa Imulungu wenu. Lakini nouza, kina nani onda wachole hamoja na mweye?” ");
INSERT INTO kdc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa kamwidika, “Tochola hamoja na wabwanga na wavele na wanetu wa kimbigalo na wa kitwanzi, ng'hondolo na ng'ombe na mbuzi, kwavija tolondigwa tukamtendele nyimwilinyimwili Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Lakini Falao kawalongela, “Mawe! Mndewa Imulungu yawe hamoja na mweye, kamba nahawatogolela mweye mugende, hamoja na watwanzi na wanenu! Niye nokona mweye mogelegeza gehile mmizoyo yenu. ");
INSERT INTO kdc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Bule! Wambigalo waiyeka wao onda wachole kumtambikila Mndewa Imulungu, kwavija mbuli ayo iyo imulonda.” Abaho Musa na Haluni wawingigwa kuulongozi wa Falao. ");
INSERT INTO kdc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mndewa Imulungu kamulongela Musa, “Golosa fimbo yako uchanha mwiisi ya Misili, ili mbalangulu walawilile na wengile mmigunda na waje minoga yose ili mmigunda, na kila kinhu kilekigwe kunangigwa na mvula ya mabwe.” ");
INSERT INTO kdc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Avo Musa kagolosa fimbo yake uchanha mwiisi ya Misili. Mndewa Imulungu kagala beho kulawa mwambu wa kudilawilila zuwa na beho dijo dibuma uchanha mwiisi, imisi mbaka kilo chose. Imitondo beho dijo digala mbalangulu. ");
INSERT INTO kdc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Mbalangulu awo wenela kila hanhu mwiisi ya Misili, wahumulukila uchanha mwiisi yose. Mbalangulu awo wakala madali kwa madali. Hawanalawilila mbalangulu kamba wano na honda walawilile kabili. ");
INSERT INTO kdc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Waigubika isi yose ya Misili mbaka ikala ziza. Wakija kila kinhu kisigasigwe na mvula ya mabwe na waija minoga na matunda gakalile mna imigunda. Kuduhu tepo jojose disigale mdibiki wala mna iminoga mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Abaho Falao kalopola kawakema Musa na Haluni, kawalongela, “Niye nibananga kwa Mndewa Imulungu wenu, na kumwenu mweye. ");
INSERT INTO kdc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Avo nowapula mugele kumgongo nzambi zangu mwanza uno na Mndewa Imulungu wenu yanisegesele mbuli ino igala ifa.” ");
INSERT INTO kdc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa kasegela kwa Falao na kachola kumpula Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nayo Mndewa Imulungu kagala beho kulu kulawa mwambu wa kudihongela zuwa diwapwililisa mbalangulu wose na diwagala mbahali ya Shamu. Kuduhu hata mbalangulu yasigale mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Lakini Mndewa Imulungu kamtenda Falao yawe na moyo mdala, nayo hawalekile Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Abaho Mndewa Imulungu kamulongela Musa, “Golosa mkono wako uchanha kuulanga, isi ya Misili iwe na ziza, wanhu wababase babase mdiziza.” ");
INSERT INTO kdc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Avo Musa kagolosa mkono wake uchanha kuulanga, kukala na ziza totolo mwiisi yose ya Misili kwa siku ndatu. ");
INSERT INTO kdc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kuduhu munhu yadahile kumona miyage hebu munhu kusegela hanhu hayakalile kwa siku ndatu. Lakini Waizilaeli wose hanhu hawakalile kukala na mulenge. ");
INSERT INTO kdc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Abaho Falao kamkema Musa kamulongela, “Gendeni mkamtambikile Mndewa Imulungu. Watwanzi na wanenu vivija odaha kuchola hamoja na mweye. Lakini ng'hondolo zenu na ng'ombe na mbuzi osigala.” ");
INSERT INTO kdc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Lakini Musa kamulongela, “Wahatenda vivo gweye utugwelele wanyama wa nhosa na nhosa ya kusoma moto ili tukamtambikile Mndewa Imulungu wetu. ");
INSERT INTO kdc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tolondigwa tuwasole wanyama wetu wala kuduhu hata imoja yonda yasigale. Kwavija kwa iwanyama awo tomulavila nhosa Mndewa Imulungu wetu, na mbaka sambi siye hatujuwa mbaka twahavika kuko, kinhu gani tolondigwa tukamulavile nhosa Mndewa.” ");
INSERT INTO kdc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Lakini Mndewa Imulungu kamtenda Falao yawe na moyo mdala na kalema kuwaleka Waizilaeli wasegele. ");
INSERT INTO kdc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falao kamulongela Musa, “Segela, witeganye sikuuchone kihanga changu kabili, kwavija siku yonda uchone kihanga changu kofa!” ");
INSERT INTO kdc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa kamwidika, “Kulonga goya, sichona kabili kihanga chako.” ");
INSERT INTO kdc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mndewa Imulungu kamulongela Musa, “Ding'hali kubulo dimoja disigala nomtowa najo Falao na Wamisili, abaho kumwande kowalekeseni musegele hano, na heyo mwenyego kowawinga musegele mwiisi yake. ");
INSERT INTO kdc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Walongele Waizilaeli kamba kila mbigalo na mtwanzi yampule munhu wa behi yake vinhu va shaba na zahabu.” ");
INSERT INTO kdc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mndewa Imulungu kawatenda Waizilaeli wanogeligwe na Wamisili, na Musa mwenyego kawa munhu mkulu ng'hani mwiisi ya Misili, mgameso ga watawala wa Falao hamoja na wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa kamulongela Falao, “Mndewa Imulungu kolonga vino, ‘Kilo kikulu, lelo nobita hagati ya isi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Nahabita kila chaudele wa kimbigalo mwiisi ya Misili kofa. Kusongela chaudele wako gweye Falao ija yeli muhazi wako mbaka chaudele wa msang'hanaji wako ija yoduga kwa dibwe. Hata chaudele wa fugo zako vivija wofa. ");
INSERT INTO kdc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Hokuwa na kililo kikulu mwiisi yose ya Misili, kililo acho hakinalawilila, na honda kilawilile kabili. ");
INSERT INTO kdc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Lakini mna iwanhu wa Izilaeli kokuwa kuduhu kililo na kokuwa na tindiwalo, baho kojuwa kamba Mndewa Imulungu ayo yowabagula Waizilaeli na Wamisili.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Abaho Musa kamulongela Falao, “Wasang'hanaji zako okwiza kumwangu na kunifugamila na onipula nisegele mwiisi ya Misili niye na wanhu wose onikweleleza. Gahamala gago nosegela.” Abaho Musa kasegela kwa Falao kuno kagevuzika. ");
INSERT INTO kdc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mndewa Imulungu kamulongela Musa, “Falao honda yakutegeleze ili nhende ng'hani unzonza mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Avo Musa na Haluni watenda unzonza wose mgameso ga Falao. Lakini Mndewa Imulungu kamtenda Falao yawe na moyo mdala, kalema kuwaleka Waizilaeli wasegele mwiisi yake. ");
INSERT INTO kdc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Viwakalile wang'hali mwiisi ya Misili, Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi uno okuwa mwezi wa ichanduso wa mwaka kumwenu. ");
INSERT INTO kdc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Walongele Waizilaeli kamba mdisiku da longo da mwezi uno, kila munhu mng'anda yake yasole mwana ng'hondolo, hebu mwana mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kamba ng'anda ina wanhu wadodo na haidaha kumuja mwana ng'hondolo wose, iilumbe na wayao weli behi nao wamuje kamba hewo viweli, na wasagule mnyama yodaha kugoligwa kwa kila munhu kamba viyodaha kuja. ");
INSERT INTO kdc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mnyama ayo yonda mumsagule yatelele, na yawe mbigalo na yawe wa mwaka umoja na modaha kumsola mwana ng'hondolo hebu mwana mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kila ng'anda imkalize mbaka siku da longo na nne ya mwezi uno, wanhu wa Izilaeli olondigwa wawachinje wanyama awo ichungulo. ");
INSERT INTO kdc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Abaho wasole idamu ya wanyama awo na kuibaka mna iviwambaza va imilango na uchanha ya imilango, mumo monda wadile izinyama. ");
INSERT INTO kdc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kilo acho nyama ayo ibanikigwe na idigwe hamoja na kinhu kili usungu na gate hadigeligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sikuidigwe ing'hali mbisi hebu sikuikimusigwe na mazi, ila ibanikigwe yose hamoja na pala na migulu na vinhu va mgati. ");
INSERT INTO kdc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sikumuleke nyama yoyose mbaka imitondo. Nyama yoyose yonda isigale mbaka imitondo muisome moto. ");
INSERT INTO kdc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Nyama ayo, muije kuno muitanda kwa mwanza kwa kuifunga mikwiji mvigudi venu na kuvala vilatu na mugoge fimbo mmakono genu na muje himahima, na ino ayo Pasaka ya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Kilo acho nobita hagati ya isi ya Misili na nowakoma wana wa chaudele wa Wamisili, wose chaudele wa wanhu na chaudele wa wanyama. Noitagusa milungu yose ya Misili. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Damu ili mna iviwambaza yokuwa kilaguso kulagusa ng'anda zimukala. Nahayona damu ayo, nowabita mweye, na siwalumiza bule kipindi viniwabananga Wamisili. ");
INSERT INTO kdc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Siku ayo muikumbuke, na mweye mutende nyimwilinyimwili kwa Mndewa Imulungu, muitende iwe nyimwilinyimwili kwa ulelo wenu wose mbuli ya niye, dino dokuwa lagizo da milele kumwenu.” ");
INSERT INTO kdc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mndewa Imulungu kagendelela kulonga, “Kwa siku saba, muje magate hagageligwe hamila. Siku ya ichanduso ya siku azo saba musegese hamila mna izing'anda zenu, munhu yoyose yahaja gate digeligwe hamila mzisiku azo saba, kobaguligwa mna iwanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Siku ya ichanduso na siku ya saba hokuwa na mting'hano ung'alile. Na munhu yoyose mna izisiku azo sikuyasang'hane sang'hano yoyose ila sang'hano ya kutanda indiya. ");
INSERT INTO kdc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mutende nyimwilinyimwili ino ya magate hagageligwe hamila kukumbuka viniwalavile mweye makabila ga Izilaeli kulawa Misili. Ulelo wenu wose uideng'helele siku ayo, kamba lagizo da milele. ");
INSERT INTO kdc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Avo muje magate hagageligwe hamila kusongela ichungulo ya siku ya longo na nne ya mwezi wa ichanduso, mbaka ichungulo ya siku ya malongo mabili na imoja ya mwezi uwo. ");
INSERT INTO kdc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mna izisiku azo saba hamila sikuyoneke mzing'anda zenu. Na munhu yoyose, munhu baki hebu mwenekae yonda yaje kinhu chochose kili na hamila kobaguligwa mna iwanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hanhu hohose honda mukale sikumuje kinhu chochose kigeligwe hamila. Molondigwa muje magate hagageligwe hamila.” ");
INSERT INTO kdc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Avo Musa kawakema wavele wose wa Izilaeli, kawalongela, “Saguleni wana ng'hondolo na muwachinje kamba kila munhu viweli mng'anda yake mbuli ya nyimwilinyimwili ya Pasaka. ");
INSERT INTO kdc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Soleni bunho da hisopo na mdivabike mwiidamu ili mbakuli na imizeni idamu mviwambaza va milango na uchanha na munhu yoyose sikuyalawe mng'anda yake mbaka imitondo. ");
INSERT INTO kdc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mndewa Imulungu viyobita mwiisi ya Misili na kuwakoma Wamisili, koyona idamu ili mviwambaza va imilango na uchanha na komgomesa ija imsenga wa ifa sikuyengile mzing'anda zenu na kuwakoma. ");
INSERT INTO kdc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mweye na ulelo wenu mugagoge malagizo gano milele. ");
INSERT INTO kdc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mwahavika mwiisi yonda yawagwee Mndewa Imulungu kamba viyawalongele, molondigwa muigoge nyimwilinyimwili ino. ");
INSERT INTO kdc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na wanenu wahawauza, ‘Nyimwilinyimwili ino yofambula choni?’ ");
INSERT INTO kdc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Walongeleni, ‘Ino nhosa ya Pasaka kwa Mndewa Imulungu, kwavija kazibita ng'anda za Waizilaeli mwiisi ya Misili. Kawakoma Wamisili lakini siye hatukomile.’ ” Abaho Waizilaeli waidulika wamtambikila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Waizilaeli watenda kamba Mndewa Imulungu viyawalagize Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kilo kikulu Mndewa Imulungu kawakoma wana wa chaudele wose wa Wamisili. Wose wafa kusongela mwana chaudele wa Falao, imuhazi wa undewa mbaka mwana chaudele wa mfungwa yeli mkifungo, vivija wana chaudele wa wanyama wafa. ");
INSERT INTO kdc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Avo Falao na watawala zake na Wamisili wose walamuka ikilo, kukala na kililo mwiisi yose ya Misili, kwavija kukala kuduhu ng'anda iswelile kufa munhu. ");
INSERT INTO kdc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kilo acho Falao kawakema Musa na Haluni, kawalongela, “Lamukeni! Segeleni mwiisi yangu mweye hamoja na Waizilaeli, gendeni mukamtambikile Mndewa Imulungu kamba vimulongile. ");
INSERT INTO kdc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Soleni ng'hondolo zenu na ng'ombe na mbuzi musegele, kamba vimulongile. Vivija nipulileni kwa Mndewa yanitendele ganogile.” ");
INSERT INTO kdc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisili wawasusumiza Waizilaeli walopole kusegela mwiisi yao. Walonga, “Kamba hamusegela wose tofa.” ");
INSERT INTO kdc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Avo Waizilaeli wasola usage wao ukandigwe ung'hali haunageligwa hamila, na mabakuli gao ga kukandila wavigela mzimbahasha na wapapa mna gamaega. ");
INSERT INTO kdc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Waizilaeli watenda kamba Musa viyawalagize na wawapula Wamisili wawagwelele vinhu va shaba na zahabu na viwalo. ");
INSERT INTO kdc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mndewa Imulungu kawatenda Wamisili wawatendele ganogile Waizilaeli, na Wamisili wawagwelela kila kinhu kiwapulile, vivo Waizilaeli viwasolile vinhu va Wamisili. ");
INSERT INTO kdc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waizilaeli wasegela Lamesesi wachola Sukoti. Wakala wambigalo ovika kamba laki sita, watwanzi na wana hawapetigwe. ");
INSERT INTO kdc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Vivija kukala na bumbila da wanhu wengi wayagwe wacholile hamoja nao. Vivija wakala na ng'hondolo wengi na mbuzi na ng'ombe. ");
INSERT INTO kdc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kwavija wakala walopole kusegela mwiisi ya Misili hawadahile kutanda ndiya ya kuja mnzila, ila uja uusage ukandigwe bila kugeligwa hamila wiiyeka, avo woka magate hagageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waizilaeli wakala mwiisi ya Misili kwa kipindi cha miyaka magana mane na malongo madatu. ");
INSERT INTO kdc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Viishile miyaka ayo magana mane na malongo madatu, makabila gose ga Mndewa Imulungu gasegela mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Kilo acho Mndewa Imulungu kakala kowalolesa Waizilaeli ili yawalave mwiisi ya Misili, kilo acho cholondigwa kikumbukigwe na Waizilaeli na ulelo wao wose kamba kilo cha kumgwaa ukulu Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mndewa Imulungu kawalongela Musa na Haluni, “Uno awo mwiko wa Pasaka. “Munhu baki sikuyaje ndiya ya Pasaka. ");
INSERT INTO kdc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mtumwa yoyose yaguligwe, tanhu yengizigwe kumbi lekaavo yaje ndiya ino. ");
INSERT INTO kdc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Munhu yoyose yokala kumwenu kamba munhu baki hebu kibaluwa yolihigwa sikuyaje ndiya ino. ");
INSERT INTO kdc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Nyama yose idiligwe mng'anda ayo itelekeligwe. Sikumutule zege jake jojose. ");
INSERT INTO kdc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Waizilaeli wose olondigwa waideng'helele nyimwilinyimwili ino. ");
INSERT INTO kdc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Munhu baki yoyose yokala hamoja na mweye yahalonda kudeng'helela nyimwilinyimwili ya Pasaka, kolondigwa tanhu yawengize kumbi wambigalo wose weli mng'anda yake, baho kogesigwa kamba mwenekae miyenu na kodaha kuideng'helela. Mbigalo yoyose yalekile kwingila kumbi sikuyaje. ");
INSERT INTO kdc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Mwiko uno okuwa kwa Mwiizilaeli na kwa munhu baki yokala na mweye.” ");
INSERT INTO kdc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waizilaeli wose watenda kamba Mndewa Imulungu viyamulagize Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mdisiku dijo Mndewa Imulungu kagalava makabila ga Izilaeli mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Muwalave kumwangu wana wose chaudele wa kimbigalo, kwavija kila mwana chaudele wa Kiizilaeli na mwana chaudele wa mnyama wose wangu niye.” ");
INSERT INTO kdc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa kawalongela wanhu, “Sikumuisemwe siku ino. Mweye vimulawile mwiisi ya Misili kuko kumukalile watumwa, kwavija Mndewa Imulungu kawalava kwa nguvu za makono gake. Sikumuje magate gageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lelo mosegela mwiisi ino ya Misili muumwezi uno wa ichanduso, mwezi wa Abibu. ");
INSERT INTO kdc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kipindi Mndewa Imulungu vonda yawagale mwiisi ya Wakanaani na Wahiti na Waamoli na Wahivi na Wayebusi, mwiisi ija iyaiduwile kowagwaa wahenga zenu isi imemile maziwa na uki, molondigwa mutende nyimwilinyimwili kila mwaka. ");
INSERT INTO kdc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Diyeni magate hagageligwe hamila kwa siku saba na mna isiku ya saba tendeni nyimwilinyimwili kwa kumgwaa ukulu Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kwa siku azo saba moja magate hagageligwe hamila. Gate digeligwe hamila hebu hamila sikuvoneke mzing'anda zenu hebu mgati ya izimbaka zenu. ");
INSERT INTO kdc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mdisiku dijo walongeleni wanenu vino, ‘Totenda vino kwavija Mndewa Imulungu katulava mwiisi ya Misili.’ ");
INSERT INTO kdc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Nyimwilinyimwili ino iwe kamba kilaguso mna gamakono genu hebu mna ivihanga venu, ili siku zose mukumbuke malagizo ga Mndewa Imulungu. Kwavija Mndewa Imulungu kawalava mwiisi ya Misili kwa mkono wake uli na nguvu. ");
INSERT INTO kdc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Avo deng'heleleni nyimwilinyimwili ino mna ikipindi kikigwe, kila mwaka.” ");
INSERT INTO kdc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Musa kagendelela kuwalongela, “Mndewa Imulungu kowagala mwiisi ya Wakanaani na kowagwelela isi ayo, kamba viyaiduwile kumwenu mweye na wahenga zenu. ");
INSERT INTO kdc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Mwahavika kuko walaveni kwa Mndewa Imulungu wana chaudele wa kimbigalo. Kila mwana chaudele wa kimbigalo wa fugo zenu kokuwa wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Lakini mwana chaudele wa kimbigalo wa kihongwe molondigwa mumgombole kwa kuliha mwana ng'hondolo. Lakini kamba hulonda kumgombola, kolondigwa umkome kwa kumbota isingo. Kila mwana chaudele wa kimbigalo wa munhu kolondigwa umgombole. ");
INSERT INTO kdc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ako kumwande mwanago yahakuuza mbuli ino yofambula choni? Mulongele, ‘Kwa nguvu ya mkono wake Mndewa Imulungu katulava mwiisi ya Misili, kuko kutukalile watumwa. ");
INSERT INTO kdc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Falao kwa udala wa zoyo jake katulemela sikutusegela mwiisi yake, avo Mndewa Imulungu kawakoma wana chaudele wa kimbigalo wa Wamisili, chaudele wa wanhu na wanyama. Lekaavo tomulavila Mndewa Imulungu kila mwana chaudele wa kimbigalo wa fugo zetu lakini kila mwana chaudele wa kimbigalo wa wanhu kogomboligwa.’ ");
INSERT INTO kdc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mbuli ino yokuwa kamba kilaguso mmakono genu na kilaguso mna ivihanga venu, kamba Mndewa Imulungu katulava Misili kwa mkono wake uli na nguvu.” ");
INSERT INTO kdc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Falao viyawalekile Waizilaeli wasegele, Imulungu hawalongoze wabitile mwiisi ya Wafilisiti, hamoja ikala nzila ya kukanhiza. Imulungu kalonga, “Wahaiting'hana na ng'hondo odaha kugimbula na kubwela Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Avo Imulungu kawabitiza mna inzila ya kuzunguluka kubitila kuluwala, mwambu wa bahali ya Shamu. Waizilaeli wasegela mwiisi ya Misili kuno waitanda kwa ng'hondo. ");
INSERT INTO kdc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa kaisola mizege ya Yusufu, kamba Yusufu viyalagize yang'hali hanakufa. Yusufu kakala yawaduwilize Waizilaeli kwa kulonga, “Imulungu vonda yeze kuwataza, soleni mizege yangu musegele nayo.” ");
INSERT INTO kdc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Waizilaeli wasegela Sukoti weka ng'hambi ako Etamu kumgwazo wa luwala. ");
INSERT INTO kdc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Imisi Mndewa Imulungu kawalongoza kwa wingu joneke kamba mhanda kuwalagusila inzila, na ikilo kawalongoza kwa moto oneke kamba mhanda kuwamwemwesela, ili wadahe kugendelela na mwanza wao imisi na ikilo. ");
INSERT INTO kdc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Imhanda ya wingu iwalongolela Waizilaeli imisi na imhanda ya moto iwalongolela ikilo, siku zose Waizilaeli walongozwa. ");
INSERT INTO kdc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Walongele Waizilaeli wabweleganye kukisogo na weke ng'hambi haulongozi ha Pi Hahiloti, hagati ya buga da Migidoli na bahali ya Shamu na behi na Baali Sefoni. ");
INSERT INTO kdc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falao kogesa kamba Waizilaeli onyawanyawa mwiisi, na kiwala kiwatenda walemelwe kubita. ");
INSERT INTO kdc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Noutenda moyo wa Falao uwe mdala na heyo kowakweleleza. Na niye nopata ukulu kwa kuwabananga heyo hamoja na iwakalizi zake. Abaho Wamisili ojuwa kamba niye ayo Mndewa Imulungu.” Avo Waizilaeli watenda vivo. ");
INSERT INTO kdc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mndewa wa Misili viyalongeligwe Waizilaeli wasegela, heyo na watawala zake wagalusa nzewele zao walonga, “Totenda choni? Tuwaleka Waizilaeli wasegela sikuwatusang'hanile!” ");
INSERT INTO kdc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Avo Falao kautanda mtuka wake wa ng'hondo na wakalizi zake. ");
INSERT INTO kdc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kasola mituka yake magana sita inogile kwa ng'hondo, na mituka yose ya Misili ya ng'hondo ilongozigwe na watawala wa isi. ");
INSERT INTO kdc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mndewa Imulungu kautenda moyo wa Falao, mndewa wa Misili, uwe mdala, nayo kawakweleleza Waizilaeli wakalile wasegele mwiisi ya Misili kwa kuitapa. ");
INSERT INTO kdc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Wakalizi wa Kimisili wawakweleleza Waizilaeli hamoja na falasi zao wose na mituka ya ng'hondo, na wanhu wawakwelile iwafalasi. Wawavika weka ng'hambi kumgwazo wa bahali ya Shamu behi na Pi Hahiloti, na Baali Sefoni. ");
INSERT INTO kdc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Waizilaeli viwamone Falao kokwiza na wakalizi zake wadumba na wamulilila Mndewa Imulungu yawataze. ");
INSERT INTO kdc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Waizilaeli wamuyalalila Musa walonga, “Vino kukala kuduhu hanhu ha kuzikila kuja Misili mbaka kutugala tufile kuluwala? Habali kututenda tusegele mwiisi ya Misili! ");
INSERT INTO kdc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Vino hatukulongele vitukalile mwiisi ya Misili, ‘Tuleke, tuwasang'hanile Wamisili’? Vinoga ng'hani siye tuwasang'hanile Wamisili kubanza kufila kuno kuluwala.” ");
INSERT INTO kdc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa kawedika, “Sikumudumbe, imeni mulole lelo Mndewa Imulungu vonda yawakombole, kwavija wano Wamisili omuwona lelo honda muwone kabili. ");
INSERT INTO kdc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mndewa Imulungu kowagombela, mweye nyamaleni.” ");
INSERT INTO kdc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Abaho Mndewa Imulungu kamulongela Musa, “Habali monililila? Walongele Waizilaeli wagendelele na mwanza wao. ");
INSERT INTO kdc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Inula fimbo yako uigolose uchanha ya bahali, mazi goigola na Waizilaeli odaha kubita hagati ya bahali mna iisi inyalile. ");
INSERT INTO kdc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Niye Mndewa noitenda mizoyo ya Wamisili iwe midala, na avo owakweleleza na niye nogweleligwa ukulu kwa kumbananga Falao na wakalizi zake okwela falasi na mituka yake. ");
INSERT INTO kdc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Wamisili ojuwa kamba niye ayo Mndewa Imulungu, vonda nigweleligwe ukulu kubitila Falao na mituka yake ya ng'hondo na wakalizi zake okwela falasi.” ");
INSERT INTO kdc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Avo msenga wa kuulanga, yakalile kuulongozi kwa Waizilaeli, kasegela kema kukisogo chao. Na ija imhanda ya wingu vivija isegela kuulongozi wao ima kukisogo chao, ");
INSERT INTO kdc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","hagati ya Waizilaeli na Wamisili. Wingu dijo ditenda ziza kwa Wamisili na diwamwemwesela Waizilaeli. Avo Wamisili hawadahile kuwakwesela behi Waizilaeli kilo kigima. ");
INSERT INTO kdc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa kaugolosa mkono wake uchanha ya bahali, na Mndewa Imulungu kaibweza bahali kukisogo kwa beho kulu kulawa mwambu wa kudilawilila zuwa. Beho dijo dibuma kilo kigima na kuigola bahali banzi mbili na hagati yake kulawilila isi inyalile. ");
INSERT INTO kdc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Waizilaeli wabita hagati ya bahali, mwiisi inyalile, na ng'huta za mazi zikala mwambu wao wa mkono wa ukudila na wa ukumoso. ");
INSERT INTO kdc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wamisili wawakweleleza kubitila isi inyalile ikalile hagati ya bahali hamoja na falasi zao na mituka yao ya ng'hondo na wakwela falasi zao. ");
INSERT INTO kdc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ulukwili Mndewa Imulungu kawasungulila Wamisili kubitila mhanda ya moto na mhanda ya wingu, kawagela bwembwe Wamisili. ");
INSERT INTO kdc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kagatenda malingi ga mituka yao galemelwe kutembela goya. Wamisili walonga, “Tusegele hano, Mndewa Imulungu kowagombela Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Abaho Mndewa Imulungu kamulongela Musa, “Golosa mkono wako uchanha ya bahali ili mazi gawagubike Wamisili, hamoja na mituka yao na wakwela falasi wao.” ");
INSERT INTO kdc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa kaugolosa mkono wake uchanha ya bahali, na imitondo mazi gabwela kamba vigakalile. Wamisili wageza kugakimbila gamazi lakini Mndewa Imulungu kawasung'hila mbahali. ");
INSERT INTO kdc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mazi gabwela na kuigubika mituka na wakwela falasi, na wakalizi wose wa Falao wawakweleleze Waizilaeli hagati ya bahali. Kuduhu hata munhu yahonyeke. ");
INSERT INTO kdc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Lakini Waizilaeli wabita hagati ya bahali mna iisi inyalile, ng'huta za mazi ga bahali zikala zimile mwambu wao wa ukudila na mwambu wa ukumoso. ");
INSERT INTO kdc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mdisiku dijo Mndewa Imulungu kawakombola Waizilaeli kulawa mna gamakono gawa Misili, na Waizilaeli wawona Wamisili kumgwazo wa bahali wafa mwaka. ");
INSERT INTO kdc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Waizilaeli viwonile unzonza uyatendile Mndewa Imulungu kwa Wamisili, wamdumba Imulungu na wamtamanila Mndewa Imulungu na msang'hanaji wake Musa. ");
INSERT INTO kdc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Abaho Musa na Waizilaeli wamwimbila Mndewa Imulungu lwila luno, “Nomwimbila Mndewa Imulungu kwavija kauchanha ng'hani, falasi na wanhu owakwela kawasung'hila mwiibahali. ");
INSERT INTO kdc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mndewa iyo nguvu zangu na lwila lwangu heyo iyo yanikombole. Heyo iyo Imulungu wangu, na niye nomtogola, na niye nomtogola Imulungu wa tatangu, na nomtambikila. ");
INSERT INTO kdc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mndewa Imulungu kamba munhu wa ng'hondo Mndewa Imulungu dijo twaga jake. ");
INSERT INTO kdc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Mituka ya Falao na wakalizi zake kawasila mwiibahali. Watawala zake wadumbukila mwiibahali ya Shamu. ");
INSERT INTO kdc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Mazi gawagubika, Wadumbukila mbaka hasi mwiibahali kamba dibwe. ");
INSERT INTO kdc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mndewa Imulungu mkono wako wa kudila, ogweleligwa ukulu. Mndewa Imulungu mkono wako wa kudila owahonda waja okwihila. ");
INSERT INTO kdc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kwa ukulu wako kuwabwanha hasi waja okwihila kowahuvila kwa ng'hasiliki yako nayo yowasakaza kamba usoti. ");
INSERT INTO kdc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kwa mhumuzi yako mazi gailundiza. Mawimbi gamazi gema wima kamba kisugulu, mazi ga bahali gaganda. ");
INSERT INTO kdc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ija yatwihile kalonga, ‘Nowakweleleza na nowagoga, Noigolela vinhu vao kamba vinonda, Nosomola sime jangu, na nowabananga kwa mkono wangu.’ ");
INSERT INTO kdc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Lakini gweye kugala beho jako, nayo bahali iwagubika. Wadidimila mgamazi kamba dibwe. ");
INSERT INTO kdc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Mndewa Imulungu, mna iwaja oikema mulungu nani kamba gweye? Nani yaigalile na gweye, gweye ung'alile ng'hani, Nani yodaha kutenda unzonza na vinhu vikulu kamba vako? ");
INSERT INTO kdc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kuugolosa mkono wako wa kudila, na isi iwameza waja watwihile. ");
INSERT INTO kdc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Gweye kotamaniligwa mna igaja goulonga, kuwalongoza waja uwakombole, kwa nguvu zako kuwalongoza kuna iisi yako ing'alile. ");
INSERT INTO kdc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wanhu wa isi ziyagwe wazihulika mbuli azo, na wagwaya kwa bwembwe, Wanhu okala Filisitia onyawanyawa. ");
INSERT INTO kdc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Watawala wa isi ya Edomu ogwaya, wakulu wa Moabu oinyuwata, wanhu wose okala Kanaani mizoyo yao yolumbuka. ");
INSERT INTO kdc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bwembwe na ifa viwagubika. Kwa ukulu wa nguvu zako wao wanyamala tuluu kamba dibwe, mbaka wanhu zako wabite, ona mbaka waja uwakombole wabite. ");
INSERT INTO kdc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Gweye kuwagala wanhu zako na kowahanda kulugongo lwako, Hanhu hausagule hawe kae yako gweye Mndewa Imulungu, kae yuuzengile kwa makono gako. ");
INSERT INTO kdc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Gweye Mndewa Imulungu, kotawala milele.” ");
INSERT INTO kdc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Falasi wa Falao na mituka yake na wakwela falasi wake viwengile mwiibahali hanhu hanyalile, Mndewa Imulungu kagabweza mazi ga bahali gawagubika. Lakini Waizilaeli wagendelela kutembela hanhu hanyalile hagati ya ibahali. ");
INSERT INTO kdc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Abaho Miliamu mtula ndagu wa kitwanzi, lumbu jake Haluni kasola ngoma ndodo, na watwanzi wayagwe wamkweleleza, kuno wagoga ngoma zao ndoondodo kuno ocheza. ");
INSERT INTO kdc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliamu kawembila, “Mwimbileni Mndewa Imulungu, kwavija kabanza kwa ukulu, falasi na waja owakwela kawasung'hila mbahali.” ");
INSERT INTO kdc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Abaho Musa kawalongoza Waizilaeli wagendelele na mwanza kulawa bahali ya Shamu, kuchola kuluwala lwa Shuli. Wagenda kuluwala kwa siku ndatu bila kugona mazi. ");
INSERT INTO kdc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Viwavikile hanhu hokemigwa Mala, hawadahile kugang'wa mazi ga hanhu aho kwavija gakala gausungu. Lekaavo hanhu aho hakemigwa Mala. ");
INSERT INTO kdc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Wanhu wamuyalalila Musa walonga, “Tung'we choni?” ");
INSERT INTO kdc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa kamulilila Mndewa Imulungu, nayo Mndewa Imulungu kamulagusila kibiki. Abaho Musa kakigela mgamazi, mazi gakala gaumulile. Kuko Mndewa Imulungu kawagwaa Waizilaeli malagizo vivija kawageza. ");
INSERT INTO kdc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kawalongela, “Kamba monitegeleza goya niye Mndewa Imulungu wenu kwa kutenda ganogile mgameso gangu, na kugoga Malagizo gangu, na niye siwakoboza bule kwa mitamu iniwagalile Wamisili. Kwavija niye ayo Mndewa Imulungu niwahonyaga mweye.” ");
INSERT INTO kdc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Abaho Waizilaeli wavika kuko Elimu, kuko kukalile na nzasa longo na mbili na mitende malongo saba, weka ng'hambi yao kuko behi na mazi. ");
INSERT INTO kdc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Waizilaeli wose wasegela kulawa Elimu wavika kuluwala lwa Sini hagati ya Elimu na Sinai. Ino ikala siku ya longo na tano ya mwezi wa kabili toka viwasegele mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ako kuluwala Waizilaeli wakala owayalalila Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Waizilaeli wawalongela, “Vinoga ng'hani kamba Mndewa Imulungu yahatukomile vitukalile mwiisi ya Misili, kuko tuja nyama na tuja ndiya itulondile, lakini mweye mutugala kuno kuluwala ili tufe kwa nzala.” ");
INSERT INTO kdc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Abaho Mndewa Imulungu kamulongela Musa, “Nowagalila magate kulawa kuulanga. Kila siku odondola chakuja cha kuwafaya siku dijo. Kwa nzila ino nowageza nilole kamba odaha kugagoga malagizo gangu. ");
INSERT INTO kdc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mna isiku ya sita, wadondole chakuja miyanza mibili ya vija viwadondolaga kila siku.” ");
INSERT INTO kdc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Avo Musa na Haluni wawalongela Waizilaeli wose, “Ichungulo mojuwa kamba Mndewa Imulungu ayo yawalavile mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Imitondo mowona ukulu wa Mndewa Imulungu, kwavija kawahulika vimmuyalalile. Siye kina nani mbaka mutuyalalile?” ");
INSERT INTO kdc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Vivija Musa kawalongela, “Ichungulo Mndewa Imulungu kowagwaa nyama muje na imitondo kowagwaa magate muje mushibe, kwavija heyo kahulika kuiyalala kwenu. Siye twa kina nani mbaka mutuyalalile? Sikumutuyalalile siye, lakini muyalalileni Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa kamulongela Haluni, “Walongele Waizilaeli wose weme kuulongozi wa Mndewa Imulungu, kwavija kahulika kuiyalala kwao.” ");
INSERT INTO kdc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Haluni viyakalile kolonga na Waizilaeli, wanhu wose walola kuluwala, bahaja ukulu wa Mndewa Imulungu oneka mmawingu. ");
INSERT INTO kdc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Niwahulika Waizilaeli viwoniyalalila. Avo walongele vino, ‘Ichungulo woja nyama na imitondo woja magate. Abaho mojuwa kamba niye ayo Mndewa Imulungu, Imulungu wenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ichungulo ng'hwale weza waigubika ng'hambi yao, imitondo tungwe dikala jenele banzi zose za ng'hambi yao. ");
INSERT INTO kdc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tungwe vidinyalile, kukala na kinhu kidodo cha ubulunge kikala kibewe. ");
INSERT INTO kdc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Waizilaeli viwachone kinhu acho, waiuza, “Akino choni?” Kwavija hawakijuwile kikala kinhu gani. Musa kawalongela, “Dino dijo gate diyowagwaa Mndewa Imulungu muje. ");
INSERT INTO kdc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mndewa Imulungu kalagiza mutende vino, ‘Kila munhu yadondole kamba viyodaha kuja. Yadondole mhishi imoja kamba wanhu wa mng'anda mmwake viweli.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Avo Waizilaeli watenda vivo, wanhu wayagwe wadondola vingi na wayagwe wadondola kidogo. ");
INSERT INTO kdc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Lakini viwapimile vija viwadondole mna ikibaba, wajuwa kamba imunhu yadondole vingi hakalile na kinhu kisigale na ija yadondole kidogo hahungukilwe. Kila munhu kakala yadondole kamba vija viyodaha kuja. ");
INSERT INTO kdc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa kawalongela, “Munhu yoyose sikuyasigase ndiya ino mbaka imitondo.” ");
INSERT INTO kdc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Lakini wanhu hawamtegeleze Musa. Wayagwe wasigasa mbaka imitondo, lakini imitondo ndiya ayo ikala yolile na imema ming'onyo. Avo Musa kawagevuzikila ng'hani wanhu awo. ");
INSERT INTO kdc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kila imitondo, kila munhu kadondola kamba viyodaha kuja, na zuwa vijalike, kija kisigale mwiisi kilumbuka. ");
INSERT INTO kdc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mna isiku ya sita, Waizilaeli wadondola vingi kila munhu mhishi mbili, wavele wose wa Izilaeli wamcholela Musa wamulongela Musa mbuli ayo. ");
INSERT INTO kdc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa kawalongela, “Dino dijo lagizo da Mndewa Imulungu, mayo yokuwa siku ya kubwihila ya Mndewa Imulungu. Avo gendeni mkateleke hebu kukimusa ndiya imulonda. Ndiya yonda isigale ilekeni mbaka mayo.” ");
INSERT INTO kdc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Avo watenda vivo na wasigasa ndiya iyagwe mbaka mayo kamba vija Musa viyalongile, imitondo yake kikala hacholile hebu kuwa na ming'onyo. ");
INSERT INTO kdc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa kawalongela, “Diyeni ndiya ino isigale, kwavija lelo siku ya kubwihila ya Mndewa Imulungu. Lelo honda muchone ako mwiisi. ");
INSERT INTO kdc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kwa siku sita modondola ndiya ino, lakini siku ya saba yokuwa siku ya kubwihila avo honda kiwe kuko bule.” ");
INSERT INTO kdc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mna isiku ya saba wanhu wayagwe wachola kudondola lakini hawachonile. ");
INSERT INTO kdc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Abaho Mndewa Imulungu kamulongela Musa, “Vino mbaka lini molema kugagoga malagizo gangu na mafundizo gangu? ");
INSERT INTO kdc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mukumbuke kamba, niye Mndewa Imulungu niwagwaa siku ya kubwihila, lekaavo niwagwaa ndiya ya siku mbili mna isiku ya sita. Ili kila munhu yabwihile ukae kumwake na sikuyachole kokose mna isiku ya saba.” ");
INSERT INTO kdc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Avo wanhu wahumula mna isiku ya saba. ");
INSERT INTO kdc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waizilaeli waikema ndiya ayo, “Mana.” Ikala kamba mbeyu ya uhemba mzelu na uhaulanza ukala kamba gate digeligwe uki. ");
INSERT INTO kdc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa kawalongela, “Vino avo viyalagize Mndewa Imulungu, soleni mhishi imoja ya Mana ikigwe mbuli ya wazukulu zenu, ili na hewo wayone ndiya iniwagwelele muje ako kuluwala viniwalavile mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa kamulongela Haluni, “Sola mhishi imoja ya Mana na uike kuulongozi wa Mndewa Imulungu, ikalizigwe mbuli ya wazukulu zenu.” ");
INSERT INTO kdc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kamba Mndewa viyamulagize Musa, Haluni keka Mana na ivibao va mabwe vandikigwe malagizo ili ikalizigwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Waizilaeli waja Mana kwa miyaka malongo mane mbaka viwavikile mwiisi ifa ya kukala, isi ikalile mzimbaka za Kanaani. ");
INSERT INTO kdc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Vibaba vibili va Mana, vikala hanhu ha longo ha kipimo kikemigwa Efa. ");
INSERT INTO kdc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Waizilaeli wose wasegela kuluwala lwa Sini, watembela kulawa hanhu mbaka hanhu kamba Mndewa Imulungu viyawalagize. Weka ng'hambi ako Lefidimu, lakini hanhu aho kukala kuduhu mazi ga kung'wa. ");
INSERT INTO kdc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Wasonga kumuyalalila Musa, “Tugwelele mazi ga kung'wa.” Musa kawedika, “Habali moniyalalila? Habali momgeza Mndewa Imulungu?” ");
INSERT INTO kdc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Lakini kwavija wanhu wakala na ng'hilu, wagendelela kumuyalalila Musa wamulongela, “Habali kutulava Misili na kutugala hano tufe kwa ng'hilu, siye na wanetu na fugo zetu?” ");
INSERT INTO kdc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Avo Musa kampula ng'hani Mndewa Imulungu kalonga, “Niwatendele choni wanhu wano? Olonda kunhowa mabwe.” ");
INSERT INTO kdc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mndewa Imulungu kamulongela Musa, “Genda kuulongozi wa wanhu, wagale wavele wa Izilaeli hamoja na gweye, na sola fimbo ija yuutowile lwanda lwa Naili. ");
INSERT INTO kdc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Niye nokwima kuulongozi wako uchanha ya dibwe dili kulugongo lwa Holebu. Gweye ditowe dibwe dijo na mazi golawa wanhu wang'we.” Avo Musa katenda vivo mgameso ga wavele wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kahakema hanhu aho Masa na Meliba, kwavija Waizilaeli waiyalala na wamgeza Mndewa Imulungu, viwalongile, “Vino kweli Mndewa Imulungu kahamoja na siye?” ");
INSERT INTO kdc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Waamaleki weza wawavamila Waizilaeli ako Lefidimu. ");
INSERT INTO kdc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa kamulongela Yoshua, “Sagula wambigalo, uchole kuitowa na Waamaleki. Mayo nokwima kuinhembeti ya lugongo, kuno nigoga fimbo ya Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Avo Yoshua katenda kamba viyalagizwe na Musa, kachola kuitowa na Waamaleki, Musa na Haluni na Huli wakwela kuinhembeti ya lugongo. ");
INSERT INTO kdc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ikala, Musa viyenule makono gake Waizilaeli wahuma lakini viyagahumuluse hasi, Waamaleki wahuma. ");
INSERT INTO kdc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Makono ga Musa vigadonhile Haluni na Huli wasola dibwe ili Musa yakale. Abaho wagagoga makono gake wagenula uchanha, imoja kenula mkono wa kudila na iyagwe kenula mkono wa kumoso. Avo makono ga Musa gakala na nguvu kuno genuligwa, mbaka zuwa vidihongile. ");
INSERT INTO kdc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Avo Yoshua kawahuma Waamaleki mna ing'hondo. ");
INSERT INTO kdc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Abaho Mndewa Imulungu kamulongela Musa, “Uyandike mbuli ino mkitabu ili ikumbukigwe. Abaho mulongele Yoshua kwavija nowafagila Waamaleki mwiisi yose.” ");
INSERT INTO kdc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Avo Musa kazenga upango wa kulavila nhosa kaukema, “Mndewa Imulungu ayo yanhendile nihume.” ");
INSERT INTO kdc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kalonga, “Kwavija makono gangu genuligwa kuna ikigoda cha Mndewa Imulungu. Mndewa Imulungu kogendelela kuwatowa Waamaleki ulelo mbaka ulelo!” ");
INSERT INTO kdc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetulo tata mkwe yake Musa mulava nhosa wa Midiani, kagahulika gose Mndewa Imulungu gayamtendele Musa na viyawalavile Waizilaeli mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Avo Yetulo kamsola Sipola mwehe wa Musa yakalile yabwezigwe kwa tatake, kamcholela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","hamoja na wanage wabili, mwana imkulu kakemigwa Gelishomu, Musa kamgwaa twaga dijo kwavija kalonga, “Nikimbilila mwiisi ya ugeni,” ");
INSERT INTO kdc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","na wa kabili Eliezeli, kwavija Musa kalonga, “Imulungu wa tata zangu ayo yanitazile, sikunikomigwe na Falao.” ");
INSERT INTO kdc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetulo tata mkwe yake Musa, hamoja na wanage Musa na mwehe wake kamcholela Musa kuluwala kuko kuwakalile wekile ng'hambi, kulugongo lwa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetulo kamtumila usenga Musa kalonga, “Niye mkwe yako Yetulo nokwiza hamoja na mwehe wako na wanago wabili.” ");
INSERT INTO kdc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Avo Musa kachola kuiting'hana na mkwe yake na viyamone kamfugamila na kamnonela, wailamusa abaho wengila mkibanda. ");
INSERT INTO kdc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa kamsimulila tata mkwe yake gose Mndewa Imulungu gayamtendele Falao na Wamisili mbuli ya Waizilaeli na gehile gose gawalawile mnzila na vija Mndewa Imulungu viyawakombole. ");
INSERT INTO kdc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetulo kadeng'helela ng'hani kwavija Mndewa Imulungu kawatendela ganogile Waizilaeli, kwa kuwalava Waizilaeli mmakono gawa Misili. ");
INSERT INTO kdc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetulo kalonga, “Mndewa Imulungu yatogoligwe kwavija kawakombola mulawe mmakono gawa Misili na mmakono ga Falao. ");
INSERT INTO kdc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sambi nojuwa kamba Mndewa Imulungu iyo mkulu kubanza milungu yose, kwavija kawakombola Waizilaeli kulawa mmakono gawa Misili wakalile owabezeli.” ");
INSERT INTO kdc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Abaho Yetulo, tata mkwe yake Musa, kamulavila Imulungu nhosa za kusoma moto na nhosa ziyagwe. Nayo Haluni keza hamoja na wavele wa Izilaeli waje ndiya hamoja na tata mkwe yake Musa kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Imitondo yake Musa kakala mna ikigoda kulamula kamba msemi wa wanhu, na wanhu wakala wamzunguluke toka imitondo mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yetulo tata mkwe yake Musa, viyagonile gose Musa gayawatendele Waizilaeli, kamuuza, “Habali kowatendela iwanhu vinhu vino? Habali kokala gweye wiiyeka kamba msemi, na wanhu wose wano okuzunguluka toka imitondo mbaka ichungulo?” ");
INSERT INTO kdc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa kamwidika, “Notenda vino kwavija wanhu onizila kuniuza viyolonda Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kamba wanhu wabili ogomba okwiza kumwangu, na niye nowalamula na kuwalongela vija vigalonda malagizo ga Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Abaho Yetulo tata mkwe yake Musa kamulongela, “Kiutenda hakinogile bule. ");
INSERT INTO kdc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Gweye hamoja na wanhu wano modonha, kwavija sang'hano ino munhu imoja hadaha kuitenda. ");
INSERT INTO kdc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Avo tegeleza nokugwaa magesa, na Imulungu yawe hamoja na gweye. Gweye kokwima kuulongozi wa Imulungu mbuli ya wanhu na komgalila Imulungu mbuli ya kugomba kwao. ");
INSERT INTO kdc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Wafunze wanhu malagizo ga Imulungu, walongele vija viwolondigwa kukala na sang'hano ziwolondigwa kusang'hanwa. ");
INSERT INTO kdc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Vivija usagule iwanhu odaha mna iwanhu, wanhu otamaniligwa na omdumba Imulungu na hawatogola kuhongigwa, ili wawe vilongozi wa wanhu mna ivibumbila va wanhu elufu na wanhu gana na wanhu malongo matano na wanhu longo. ");
INSERT INTO kdc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Waleke wawe kamba wasemi wa wanhu siku zose. Gaja gamadala wakugalile gweye lakini gaja gamadodo wagalamule. Kamba wahatenda vivo kodaha kutenda sang'hano yako ibuhe kwavija kosang'hana na hewo wose. ");
INSERT INTO kdc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wahatenda vivo na kamba viyolonda Imulungu kodaha kufunga umoyo na wanhu wano odaha kubwela ukae kumwao kwa tindiwalo.” ");
INSERT INTO kdc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa kakweleleza magesa ga tata mkwe yake Yetulo. ");
INSERT INTO kdc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Avo kawasagula wanhu weli na udahi mna Waizilaeli, na kawatenda wawe vilongozi wa wanhu mna ivibumbila va wanhu elufu na wanhu gana na wanhu malongo matano na wanhu longo. ");
INSERT INTO kdc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nao wakala wasemi wa wanhu kila siku, gaja gamadala wamgalila Musa na gaja gamadodo wagalamula wenyego. ");
INSERT INTO kdc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Abaho Musa na tata mkwe yake Yetulo wailaga, abaho Yetulo kabwela mwiisi yake. ");
INSERT INTO kdc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Siku da ichanduso da mwezi wa kadatu toka Waizilaeli viwasegele mwiisi ya Misili, siku dijo wavika kuluwala lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Viwasegele ako Lefidimu na kuvika kuluwala lwa Sinai, kuko weka ng'hambi kuulongozi lwa ulugongo lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa kakwela uchanha kulugongo kuiting'hana na Imulungu. Mndewa Imulungu kamkema Musa uchanha kulugongo kamulongela, “Uwalongele vino ulelo wa Yakobo na Waizilaeli wose, ");
INSERT INTO kdc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mweye wenyego mugoga gaja ganiwatendele Wamisili, na vija viniwasegese mweye kamba jola viyogasegesa makinda gake kwa mabawa gake, niwagala kumwangu. ");
INSERT INTO kdc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Avo, kamba monitegeleza niye na kugoga lagano jangu, mokuwa wanhu zangu musaguligwe hagati ya isi zose hamoja vivija isi yose yangu. ");
INSERT INTO kdc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mweye mokuwa undewa wa walava nhosa na isi ing'alile.’ Uwalongele vivo Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Avo Musa kabwela kawakema wavele wa Izilaeli, kawalongela gaja gose Mndewa Imulungu gayamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wanhu wose wedikila hamoja, “Totenda gaja gose gayalongile Mndewa Imulungu,” Nayo Musa kabwela kwa Mndewa kumulongela gaja gawalongile iwanhu awo. ");
INSERT INTO kdc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mndewa Imulungu kamulongela Musa, “Lola niye nokwiza kumwako mdiwingu kulu, ili wanhu wahulike vonda nilonge na gweye, ili wakutogole milele.” Musa kamulongela Mndewa, gaja gawalongile wanhu. ");
INSERT INTO kdc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Avo, Mndewa Imulungu kamulongela Musa, “Genda ukawahunge wanhu lelo na mayo. Walongele wanhu wafue viwalo vao, ");
INSERT INTO kdc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","na waisasale mbuli ya kisindo, kwavija niye Mndewa Imulungu nohumuluka kulugongo lwa Sinai kuulongozi wa wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Wekile wanhu imbaka kila mwambu na uwalongele sikuwakwele kulugongo hebu kulukwasa. Munhu yoyose yonda yakwase ulugongo kokomigwa. ");
INSERT INTO kdc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Yakomigwe kwa kutoigwa kwa mabwe hebu kwa mgoha, na siyo kwa makono. Yawe munhu hebu mnyama sikummuleke yawe mgima. Lakini mhalati yahagendelela kutoigwa wanhu wakwese behi ya ulugongo.” ");
INSERT INTO kdc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Abaho Musa kahumuluka kulugongo kachola kwa iwanhu na kawahunga, nao wavifuwa viwalo vao. ");
INSERT INTO kdc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kawalongela, “Muisasale kwa kisindo na mbigalo yoyose sikuyamuwase mwehe wake.” ");
INSERT INTO kdc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Imitondo siku ya kadatu kukala na ng'huwa na mimwesa na wingu kulu dilawilila kulugongo, na sauti ng'hulu ya mhalati ihulikigwa. Wanhu wose mna ing'hambi wagwaya kwa bwembwe. ");
INSERT INTO kdc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa kawalongoza wanhu wose mna ing'hambi kuchola kuiting'hana na Imulungu, na wanhu wose wema hasi ya ulugongo. ");
INSERT INTO kdc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Lugongo lwa Sinai lugubikigwa na yosi, kwavija Mndewa Imulungu kahumuluka kwa moto. Na yosi da moto uja difililika uchanha kamba yosi da biwi kulu dikwaka, na ulugongo lutigisika kwa nguvu. ");
INSERT INTO kdc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Sauti ya mhalati igendelela kuhulikigwa ng'hani. Abaho Musa kalonga na Imulungu, Imulungu nayo kamwidika kwa ng'huwa. ");
INSERT INTO kdc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mndewa Imulungu kahumuluka kulugongo lwa Sinai, kamkema Musa kuna inhembeti ya ulugongo. Nayo Musa kakwela uchanha. ");
INSERT INTO kdc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Abaho Mndewa Imulungu kamulongela Musa, “Humuluka hasi ukawazume wanhu sikuweze kundola, kwavija wahatenda vivo wengi mna iwanhu awo wofa. ");
INSERT INTO kdc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Vivija walava nhosa, awo onikweselaga olondigwa waihunge, kamba hawaihunga nowakoboza.” ");
INSERT INTO kdc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa kamulongela Mndewa Imulungu, “Wanhu hawadaha kukwela uchanha ya ulugongo lwa Sinai kwavija gweye mwenyego kutulagiza twike mbaka kuzunguluka ulugongo.” ");
INSERT INTO kdc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mndewa Imulungu kamulongela Musa, “Humuluka hasi abaho wize na Haluni. Lakini sikuuwatogolele walava nhosa na wanhu wayagwe waloke mzimbaka weze kumwangu, buleavo nowakoboza.” ");
INSERT INTO kdc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Avo Musa kahumuluka na kawalongela Waizilaeli gaja gose gayalagizwe. ");
INSERT INTO kdc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Imulungu kalonga mbuli zino zose, ");
INSERT INTO kdc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Niye ayo Mndewa Imulungu, Imulungu wako, nikulavile mwiisi ya Misili, kuko kuukalile mtumwa. ");
INSERT INTO kdc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Sikuumtambikile imulungu yoyose iyagwe ila niye. ");
INSERT INTO kdc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Sikuutende kinyago kiigalile na kinhu chochose kili kuulanga hebu mwiisi hebu mgamazi hasi ya isi ili ukitambikile. ");
INSERT INTO kdc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sikuuvifugamile hebu kuvitambikila, kwavija niye Mndewa Imulungu wako nina migongo. Nowakoboza wana mbuli ya nzambi za tata zao, hata ulelo wa kadatu na wa ikane wa waja onihila. ");
INSERT INTO kdc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Lakini nowatendela ganogile maelufu ga ulelo ga wanhu waja oninogela na kugagoga malagizo gangu. ");
INSERT INTO kdc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Sikuuditambule bule twaga jangu, niye Mndewa Imulungu wako, kwavija niye Mndewa sileka kumkoboza munhu yoyose yoditambula bule twaga jangu. ");
INSERT INTO kdc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Ikumbuke siku ya kubwihila kwa kuitenda ing'ale. ");
INSERT INTO kdc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kwa siku sita usang'hane na utende mbuli zako zose, ");
INSERT INTO kdc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","lakini siku ya saba, siku ya kubwihila ya Mndewa Imulungu wako. Siku ayo sikuusang'hane sang'hano yoyose, gweye mwenyego hebu mwanago wa kimbigalo hebu wa kitwanzi hebu mtumwa wako wa kimbigalo hebu wa kitwanzi hebu mnyama wako wa kufugigwa, hebu munhu baki iyokala mwiisi yako. ");
INSERT INTO kdc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kwavija kwa siku sita niye Mndewa Imulungu, nilumba ulanga na isi na bahali na vinhu vose vili mgati yake, abaho nibwihila siku ya saba. Lekaavo niye Mndewa Imulungu, niitenda siku ya kubwihila inoga na ing'ala. ");
INSERT INTO kdc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Wategeleze tatako na mamako, ili ukale mgima siku nyingi mwiisi inikugwelela, niye Mndewa Imulungu wako. ");
INSERT INTO kdc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Sikuukome. ");
INSERT INTO kdc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Sikuutende ugoni. ");
INSERT INTO kdc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Sikuwibe. ");
INSERT INTO kdc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Sikuumulavile miyago usindila wa uvizi. ");
INSERT INTO kdc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Sikuuisulukile ng'anda ya miyago, sikuumsulukile mwehe wa miyago hebu mtumwa wake wa kimbigalo hebu wa kitwanzi hebu ng'ombe wake hebu kihongwe wake hebu kinhu chochose kiyelinacho.” ");
INSERT INTO kdc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wanhu wona mimwesa na kuhulika ng'huwa na mhalati, na lugongo vilulavile yosi, wanhu viwagone gago wagwaya na kwima kutali. ");
INSERT INTO kdc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wanhu wamulongela Musa, “Longa na siye tokutegeleza, lakini Imulungu sikuyalonge na siye, bule tofa.” ");
INSERT INTO kdc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa kawalongela, “Sikumudumbe, kwavija Imulungu keza kuwageza ili mumdumbe siku zose na sikumutende nzambi.” ");
INSERT INTO kdc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Lakini wanhu wema kutali, Musa viyadikwesele diwingu mumo muyakalile Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mndewa Imulungu kamulagiza Musa kamba walongele Waizilaeli vino, “Mweye wenyego mona kamba nilonga na mweye kulawa kuulanga. ");
INSERT INTO kdc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Munitambikile niye niiyeka na sikumutende milungu ya shaba hebu zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Unhendele upango wa ulongo wa kulavila nhosa, na ulave nhosa zako uchanha yake, nhosa za kusoma moto na nhosa za kugala kuilumba na ng'hondolo zako na mbuzi zako na ng'ombe zako, kila hanhu honda niweke munitambikile baho niye nokwiza na kuwatendeleni ganogile. ");
INSERT INTO kdc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mwahanizengela upango wa kulavila nhosa kwa mabwe, sikumuzenge kwa mabwe gasongoligwe kwavija mwahasongola gamabwe kwa viya va kusongolela mogafitiza. ");
INSERT INTO kdc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Sikumutende upango wa kulavila nhosa na kwika vidando, ili munhu sikuyoneke ka mwazi yahakwela uchanha ya upango.” ");
INSERT INTO kdc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Wagwelele Waizilaeli malagizo gano, ");
INSERT INTO kdc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","wahamgula mtumwa Muebulania, yakusang'hanile kwa miyaka sita, mwaka wa saba mulekese bila heyo kukuliha. ");
INSERT INTO kdc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kamba viumgulile kakala hana sola kosegela yaiyeka. Lakini kamba keza na mwehe wake avo yasegele na mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kamba mkulu wake kamsolela mwehe, nayo yahalela wana wa kitwanzi na wa kimbigalo wana awo okuwa wa mkulu wake, na mtumwa ayo kosegela yaiyeka. ");
INSERT INTO kdc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kamba mtumwa ayo yahalonga, ‘Nomnogela mkulu wangu na mwehe wangu, vivija nowanogela wanangu na silonda kusegela,’ ");
INSERT INTO kdc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","avo, mkulu wake mtumwa ayo komgala mtumwa ayo kuulongozi wa Imulungu kuikiwambaza, na ayo imkulu komtoga digwiti kwa sindano na kokuwa mtumwa wake siku zose. ");
INSERT INTO kdc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Munhu yahamuuza mndele wake yawe mtumwa, honda yasegele kamba watumwa wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kamba mkulu ayo kawasa nayo na hanogeligwe nayo, aho yatogole mtumwa ayo yagomboligwe. Mkulu ayo halondigwa kumuuza mtumwa ayo kwa wanhu baki kwavija kamvizila. ");
INSERT INTO kdc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Yahamgula mbuli ya mwanage wa kimbigalo kolondigwa yamtendele kamba mndele wake. ");
INSERT INTO kdc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kamba kosola mwehe wa kabili, kolondigwa yagendelele kumgwelela mwehe wake wa ichanduso ndiya na viwalo na vivija yawase nayo. ");
INSERT INTO kdc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kamba mbigalo ayo hamgwelela mtwanzi ayo vinhu avo vidatu, mtwanzi ayo kosegela bila kumuliha kinhu chochose. ");
INSERT INTO kdc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Yomtowa miyage na kumkoma nayo kolondigwa yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kamba munhu halondile munhu ayo yafe lakini Imulungu kaileka mbuli ayo ilawilile, munhu ayo yakimbilile hanhu hanogile honda niwasagulileni. ");
INSERT INTO kdc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Lakini munhu yahatenda giladi kumtowa munhu na kumkoma, hata kamba yahakimbilila hana uupango wa nhosa, mumsegese munhu ayo na mumkome. ");
INSERT INTO kdc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Munhu yoyose yahamtowa tatake hebu mamake yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Munhu yoyose yomwiba munhu, ili yakamuuze hebu kumtenda mtumwa wake munhu ayo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Munhu yoyose yomduwila tatake hebu mamake munhu ayo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Wanhu wabili wahagomba, abaho imoja yahamtowa miyage kwa dibwe hebu konde bila kumkoma lakini yahamulumiza na kumtenda yalumwe na kuwasa mulusazi, ");
INSERT INTO kdc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","yahalawilila munhu yatoigwe kahona na abaho kotembela kwa mkongoja, munhu ayo yamtowile miyage nzambi zake zogeligwa kumgongo, lakini kamba munhu ayo yatoigwe hadaha kwinuka mulusazi, ayo yamtowile miyage yamulihe fungu da kipindi chose kiyawasile mulusazi na kolondigwa yamulole goya munhu ayo mbaka yahone. ");
INSERT INTO kdc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Munhu yahamtowa kwa fimbo mtumwa wake wa kimbigalo hebu wa kitwanzi na kumkoma, na heyo kolondigwa yakobozigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Lakini kamba mtumwa ayo hafile bule siku dijo hebu da kabili, mkulu ayo honda yakobozigwe kwavija mtumwa ayo kakala wake. ");
INSERT INTO kdc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Wambigalo wahaitowa na wahamulumiza mtwanzi yeli na inda, na kumtenda inda yake ilawe lakini heyo mwenyego halumile bule, munhu ija yamulumize kolondigwa yalave sente yonda yaitambule mkasano wa mtwanzi ayo kamba vija wasemi vonda walamule. ");
INSERT INTO kdc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Lakini kamba mtwanzi ayo kalumizigwa ng'hani yalihigwe ugima kwa ugima, ");
INSERT INTO kdc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","siso kwa siso, zino kwa zino na mkono kwa mkono na mgulu kwa mgulu, ");
INSERT INTO kdc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kusomigwa moto kwa kusomigwa moto na kilonda kwa kilonda na kulumizwa kwa kulumizwa. ");
INSERT INTO kdc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Munhu yahamtowa mdisiso mtumwa wake wa kitwanzi hebu wa kimbigalo na kudikoma disiso, yamuleke yasegele mtumwa ayo mbuli ya siso jake. ");
INSERT INTO kdc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Vivija yahamtowa na kumng'ola zino, yamuleke yasegele mbuli ya zino jake. ");
INSERT INTO kdc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ng'ombe yahamtowa munhu kwa mhembe zake na kumkoma, ng'ombe ayo yakomigwe kwa kutoigwa mabwe na nyama yake sikuidigwe na munhu. Lakini mwene ng'ombe ayo yalekigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Lakini kamba ng'ombe ayo kazoela kuwatowa wanhu kwa mhembe zake, na mwene ng'ombe kazumigwa lakini hamfungile bule, avo yahamkoma munhu yakomigwe kwa mabwe na mwene ng'ombe ayo vivija yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Lakini kamba mwene ng'ombe ayo yahatogola kuliha sente ili kuukombola ugima wake, kolondigwa yalihe sente yose ilondigwa kulihigwa. ");
INSERT INTO kdc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ng'ombe yahamkoma kwa mhembe mwana wa kimbigalo hebu wa kitwanzi lagizo dino dolamuligwa vivino. ");
INSERT INTO kdc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kamba ng'ombe yahamkoma kwa mhembe mtumwa wa kimbigalo hebu mtumwa wa kitwanzi, mwene ng'ombe yamulihe mwene mtumwa gilamu magana madatu za shaba, na ng'ombe ayo kolondigwa yakomigwe kwa mabwe. ");
INSERT INTO kdc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Munhu yahaleka kugubika simo hebu yahahimba simo abaho hadigubike, abaho ng'ombe hebu kihongwe yahadumbukila mdisimo dijo, ");
INSERT INTO kdc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","munhu mwene simo kolondigwa yamulihe ayo mwene ng'ombe hebu kihongwe yengile mdisimo, na mnyama ayo yafile mdisimo kokuwa wake. ");
INSERT INTO kdc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kamba ng'ombe wa munhu kamkoma ng'ombe wa munhu iyagwe, wanhu awo wabili wamuuze ng'ombe yamtowile mhembe ng'ombe iyagwe na abaho waigolele zisente ziwamuuzile, na vivija waigolele nyama ya ng'ombe ayo yafile. ");
INSERT INTO kdc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Lakini kamba ng'ombe ayo kazoela kuwatowa mhembe ng'ombe wayagwe, na mwene ng'ombe hamfungile ng'ombe wake, avo yalihe ng'ombe kwa ng'ombe na ija yafile kokuwa wake. ");
INSERT INTO kdc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Munhu yaheba ng'ombe hebu ng'hondolo na yahamchinja hebu kumuuza, kolondigwa yalihe ng'ombe watano hanhu ha ng'ombe imoja, na yalihe ng'hondolo wane hanhu ha ng'hondolo imoja. ");
INSERT INTO kdc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Mbavi yahagogigwa ikilo kotula ng'anda ya munhu na yahakomigwa, munhu yamkomile hatendile nzambi kwa kumkoma mbavi ayo. ");
INSERT INTO kdc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Lakini mbavi yahagogigwa na kukomigwa imisi, yamkomile katenda nzambi. Mbavi kolondigwa yalihe, kamba kabule kinhu cha kuliha, heyo mwenyego yauzigwe ili kuliha vija viyebile. ");
INSERT INTO kdc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Kamba mnyama kebigwa na yahakoneka yang'hali mgima kwa mbavi ayo, avo mbavi ayo yalihe miyanza mibili, iwe kwa ng'ombe hebu kihongwe na hata ng'hondolo. ");
INSERT INTO kdc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kamba munhu yahawadima wanyama zake mumgunda wa munhu iyagwe, yalihe vinhu vinogile vili mumgunda wake hebu va mizabibu yake. ");
INSERT INTO kdc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Munhu yahabwinha moto na kulukuza mibiki ya miba na moto awo wahalokela mmigunda na kulukuza ndiya ya munhu ing'hali hainasengigwa, hebu mgunda wose wahalukula, munhu ayo yabwinhile umoto kolondigwa yalihe unanzi wose awo. ");
INSERT INTO kdc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Munhu yahamgwaa munhu sente hebu vinhu viyagwe yamwikile na vinhu avo vahebigwa mng'anda ya munhu ayo, mbavi yahagogigwa yalihe miyanza mibili ya vinhu avo viyebile. ");
INSERT INTO kdc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Lakini kamba imbavi hagogigwe, mwene ng'anda kolondigwa yachole kuulongozi wa Imulungu na yalonge siyo heyo yebile vinhu va miyage. ");
INSERT INTO kdc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Wanhu wahamgombela ng'ombe yagile hebu kihongwe hebu ng'hondolo hebu viwalo hebu kinhu chochose chagile, na wanhu ogomba na kila munhu kolonga vinhu avo vake, wanhu awo wabili wachole kuulongozi wa Imulungu. Munhu ija yonda yoneke kaviza, komuliha miyage miyanza mibili. ");
INSERT INTO kdc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kamba munhu yahamgwaa miyage kihongwe hebu ng'ombe hebu ng'hondolo hebu mnyama yoyose, yamulolele na kamba ija imnyama yahafa hebu kulumila hebu yahasoligwa na munhu kinyelegezi, ");
INSERT INTO kdc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","wanhu awo wabili wachole kuulongozi wa Mndewa Imulungu, na ayo yagweleligwe imnyama ili yamulole yaiduwile, kulagusa kamba hamwibile mnyama ayo wa miyage. Munhu mwene ayo imnyama yatogole mbuli ayo, na ayo iyagwe honda yalihe kinhu chochose. ");
INSERT INTO kdc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Lakini kamba mnyama ayo kasoligwa kuno heyo kolola, kolondigwa yamulihe mwene ayo imnyama. ");
INSERT INTO kdc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kamba mnyama ayo kadigwa na mnyama wa kumuhulo na vihande viyagwe visigala, munhu yagweleligwe mnyama ayo yamulole kolondigwa yagale vihande avo kamba usindila na honda yalihe kinhu chochose. ");
INSERT INTO kdc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kamba munhu yahampula mnyama wa miyage na yahalumila hebu yahafa kipindi mwenyego kahabule, kolondigwa yamulihe munhu ayo. ");
INSERT INTO kdc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Lakini kamba mwenyego kabaho, munhu ayo yampulile honda yalihe chochose. Kamba mnyama ayo kasoligwa kwa kukodi, sente yonda ilihigwe ni ija ya kukodi. ");
INSERT INTO kdc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Munhu yahamvizila mhambe yang'hali kusoligwa na abaho kowasa nayo, kolondigwa yamfungile zengele na yamsole mhambe ayo. ");
INSERT INTO kdc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kamba tata wa mhambe ayo kalema mwanage sikuyasoligwe, munhu ayo yalihe sente ilondigwa kulihigwa kwa mhambe ayo. ");
INSERT INTO kdc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Sikuumuleke mtwanzi muhawi yawe mgima. ");
INSERT INTO kdc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Munhu yoyose yotenda ugoni na mnyama kolondigwa yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Munhu yomulavila nhosa imulungu iyagwe yoyose na siyo niye Mndewa Imulungu, yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Sikuumdununze munhu baki yokala kumwenu kwavija na mweye vivija mukala wanhu baki mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Sikuumdununze mtwanzi mgane hebu mwana mkiwa. ");
INSERT INTO kdc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kamba wahatenda avo, niye Mndewa nohulika kulila kwao na nowataza, ");
INSERT INTO kdc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","kwa ng'hasiliki yangu, nowakoma mna ing'hondo, na wehe zenu okuwa wagane na wanenu okuwa wabule tata. ");
INSERT INTO kdc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Wahamkopesha sente munhu imoja mna iwanhu zangu weli wakiwa, sikuuwe kamba wanhu okwika sente na kulonda nyongeza. ");
INSERT INTO kdc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kamba wahasola mgolole wa miyago kamba poni, kolondigwa umbwezele zuwa ding'hali hadinahonga, ");
INSERT INTO kdc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kwavija awo mgolole wake uyeli nao wa kuigubika. Vino gweye kogesa yahawasa koigubika choni? Yahanililila niye nomtegeleza, kwavija niye nimema bazi. ");
INSERT INTO kdc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Sikuumulige Imulungu na sikuumduwile kilongozi wa wanhu zako. ");
INSERT INTO kdc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Sikuukawe kundavila ndiya na zabibu ili mumgunda wako. “Ndavileni wanenu wa chaudele wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Vivija ndavileni wana wa chaudele wa ng'ombe na ng'hondolo zenu. Kila mwana wa chaudele wa fugo zenu yakale na mamake kwa siku saba, na siku da nane ndavileni. ");
INSERT INTO kdc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mweye mokuwa wanhu zangu mung'alile. Avo sikumuje nyama ya mnyama yakomigwe na mnyama wa kumuhulo, nyama azo wapigisileni umbwa. ");
INSERT INTO kdc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Sikuulonge mbuli za uvizi, na sikuumtaze munhu yotenda gehile kwa kulava usindila wa uvizi. ");
INSERT INTO kdc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Sikuukweleleze bumbila da wanhu otenda gehile, na sikuuilumbe na wanhu kulava usindila wa uvizi mkitala. ");
INSERT INTO kdc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Sikuumulole mkiwa mkihanga wahalamula mbuli mkitala. ");
INSERT INTO kdc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kamba wahamvika ng'ombe hebu kihongwe wa munhu yokwihila kaga, msole umbweze kwa mwenyego. ");
INSERT INTO kdc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kamba kihongwe wa munhu yokwihila kagwa na mzigo wake, sikuumuleke mtaze munhu ayo kumwinula kihongwe wake. ");
INSERT INTO kdc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Sikuumbunze mkiwa kwa kija kiyolondigwa kupata mkitala. ");
INSERT INTO kdc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Witeganye na vitala va uvizi na sikuuwakome wanhu welibule ubananzi kwavija niye nomkoboza munhu yoyose yotenda gago. ");
INSERT INTO kdc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Sikuubokele hongo kwavija hongo dowatenda wanhu sikuwalole gaja golondigwa kutendigwa na dobananga mbuli za kweli. ");
INSERT INTO kdc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Sikuumtendele vihile munhu baki, mweye mujuwa choni kuwa munhu baki kwavija na mweye mukala wanhu baki ako Misili. ");
INSERT INTO kdc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kwa miyaka sita kohanda na kusenga vihandigwe. ");
INSERT INTO kdc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Lakini muumwaka wa saba, koileka migunda yako bila kuhanda kinhu, ili wanhu wakiwa wadondole chochose kulawa mmigunda ayo, na wanyama wa kumuhulo waje vija visigale. Vivija kotenda vivo mmigunda ya mizabibu na mizeituni. ");
INSERT INTO kdc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Sang'hana kwa siku sita, lakini sikuusang'hane mdisiku da saba, ili ng'ombe wako hebu kihongwe wako vivija nao wahumule, na wana wa watumwa wako na wanhu baki wahumule. ");
INSERT INTO kdc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Uzigoge mbuli zose zinikulongele, sikumupule kwa milungu yoyose iyagwe, na hata sikumugatambule matwaga gao mmilomo yenu. ");
INSERT INTO kdc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Miyanza midatu kila mwaka munhendele nyimwilinyimwili. ");
INSERT INTO kdc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tendeni nyimwilinyimwili ya magate hagageligwe hamila. Kamba viniwalagize, kwa siku saba diyeni magate hagageligwe hamila. Tendeni vino kwa kipindi kilondigwa muumwezi wa Abibu, kwavija muumwezi awo vivo vimulawile Misili. Munhu yoyose sikuyeze kuulongozi wangu makono gaiyeka. ");
INSERT INTO kdc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Tendeni nyimwilinyimwili ya vija vimusonga kusenga mmigunda yenu. “Tendeni nyimwilinyimwili ya kulundiza ndiya mna ikimambukizo cha mwaka mwahalundiza indiya ili mmigunda yenu. ");
INSERT INTO kdc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Miyanza midatu mna umwaka wambigalo wose waiting'hane kuulongozi wangu niye Mkulu Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Wahandavila nhosa sikuulave gate digeligwe hamila, na sikuugaleke mavuta ga nhosa ya nyimwilinyimwili yangu gasigale mbaka imitondo. ");
INSERT INTO kdc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ndavileni matunda ganogile gaichanduso mgagale mng'anda ya Mndewa Imulungu wako. “Sikuuteleke nyama ya mwana mbuzi mna gamaziwa ga mamake. ");
INSERT INTO kdc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nomtuma msenga wa kuulanga yawalongolele muumwanza wenu ili yawakalize muvike hanhu haniwatandileni. ");
INSERT INTO kdc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mumtegeleze na kugoga gaja gonda yawalongele. Sikummulemele, kwavija niye na hamoja nayo na honda yazigele kumgongo nzambi zenu. ");
INSERT INTO kdc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Lakini mwahamtegeleza na kugoga gose goyolonga niye nowehila wose owehila mweye. ");
INSERT INTO kdc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Msenga wa kuulanga kowalongolela na kowagala mziisi za Waamoli na Wahiti na Wapelizi na Wakanaani na Wahivi na Wayebusi, na niye nowabananga wanhu awo wose. ");
INSERT INTO kdc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Sikumuifugamile milungu yao hebu kuitambikila hebu kukweleleza mila zao. Lakini muibanange milungu yao na mugakindule mabwe gao gong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kamba mwahanitambikila niye, Mndewa Imulungu wenu, nowatendela ganogile kwa kuwagwaa ndiya na mazi na noisegesa mitamu hagati yenu. ");
INSERT INTO kdc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mwiisi yenu kokuwa kuduhu mtwanzi yoyose yonda yatengule inda hebu mtwanzi mgumba, na niye nowatenda muwe wagima kwa siku nyingi. ");
INSERT INTO kdc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nowatenda wanhu owehila mweye wanidumbe, nowatibula wanhu onda wagombe na mweye na nowatenda wanhu owehila wahindule na kuwakimbila. ");
INSERT INTO kdc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nowaswaswanya Wahivi na Wakanaani na Wahiti kamba wanhu viwoswaswanyigwa na dondola. ");
INSERT INTO kdc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Lakini siwaswaswanya bule muumwaka umoja, nahatenda vivo isi yokuwa vihame na ming'onyo ya kumuhulo yowagaza. ");
INSERT INTO kdc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Avo nowaswaswanya kidogo kidogo mbaka vonda mongezeke ng'hani na kuitawala isi ayo. ");
INSERT INTO kdc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Zimbaka za isi yenu zokuwa kulawa bahali ya Shamu mbaka bahali ya Meditelania na kulawa kuluwala mbaka muulwanda lwa Fulate, kwavija nowagela wanhu wa isi ayo mmakono genu, na mweye mowawinga. ");
INSERT INTO kdc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Sikumuilagane nao, hebu kuilagana na milungu yao. ");
INSERT INTO kdc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Sikumuwatogolele wakale mwiisi yenu, sikuwawahonze munhende nzambi. Kamba mwahaitambikila milungu yao, awo okuwa mtego wa kuwanamata.” ");
INSERT INTO kdc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mndewa Imulungu kamulongela Musa, “Izoni kumwangu gweye na Haluni na Nadabu na Abihu hamoja na wavele wa Izilaeli malongo saba, na mnitambikile kwa kutali. ");
INSERT INTO kdc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Gweye Musa wiiyeka ayo yonda wize behi yangu, lakini wayagwe sikuweze behi yangu na wanhu sikuwakwele kulugongo hamoja na gweye.” ");
INSERT INTO kdc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa kachola kuwalongela wanhu wose mbuli ziyalongeligwe na ziyalagizwe. Wanhu wose wedika, “Tosang'hana kila kinhu kiyatulongele Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa kandika mbuli zose ziyalagizwe na Mndewa Imulungu. Imitondo yake kazenga upango wa kulavila nhosa hasi ya ulugongo na kasimika mabwe longo na mbili, kamba vigeli makabila longo na mabili ga Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Abaho kawatuma wabwanga longo wa Izilaeli wamulavile Mndewa Imulungu nhosa za kusoma moto na nhosa za ng'ombe wambigalo kamba nhosa za kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa kasola nusu ya damu ya awo iwanyama kaigida mdibakuli, na iyagwe kaimizila muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Abaho kasola ikitabu cha lagano da Mndewa Imulungu, kawasomela wanhu kuulongozi wao, nao walonga, “Totenda kila kinhu kiyatulagize Mndewa.” ");
INSERT INTO kdc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa kasola ija idamu ikalile mdibakuli kawamizila wanhu kuno kolonga, “Ino ayo damu ya lagano diyatendile Mndewa Imulungu na mweye viyawagwelele malagizo gano.” ");
INSERT INTO kdc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Abaho Musa na Haluni na Nadabu na Abihu na wavele malongo saba wa Waizilaeli wakwela kulugongo, ");
INSERT INTO kdc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na wamona Imulungu wa Izilaeli. Hasi ya magulu gake honeka kamba sakafu ya mabwe gokwaka, ikala buluu kamba ulanga. ");
INSERT INTO kdc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Imulungu hawalumize bule vilongozi awo wa wanhu wa Izilaeli, wamona Imulungu na waja na kung'wa. ");
INSERT INTO kdc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mndewa Imulungu kamulongela Musa, “Izo kumwangu uchanha kulugongo, ukale hano, nokugwelela vibao vibili va mabwe mumo nyandika malagizo na gaja golondigwa ili gawafunze Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa kasegela na mtazaji wake Yoshua, Musa kakwela kulugongo lwa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa kawalongela waja iwavele, “Tubeteni hano mbaka vonda tubwele. Haluni na Huli wabaha hamoja na mweye, munhu yoyose yahawa na mbuli yomgaza yawacholele hewo.” ");
INSERT INTO kdc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Avo, Musa kakwela kulugongo lwa Sinai, na wingu diugubika ulugongo, ");
INSERT INTO kdc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","na ukulu wa Mndewa Imulungu ukala uchanha ya ulugongo lwa Sinai. Wingu diugubika ulugongo kwa siku sita, na siku da saba Mndewa kamkema Musa kulawa kudiwingu dijo. ");
INSERT INTO kdc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ukulu wa Mndewa Imulungu oneka kwa wanhu wa Izilaeli kamba moto okwaka uchanha ya ulugongo. ");
INSERT INTO kdc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa kengila mgati ya dija diwingu, viyakalile kokwela kulugongo. Kakala kuko siku malongo mane imisi na ikilo. ");
INSERT INTO kdc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Walongele Waizilaeli wandavile sadaka. Na gweye ubokele kila kinhu chonda nilaviligwe na kila munhu yonilavila kwa moyo unogile. ");
INSERT INTO kdc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kolondigwa ubokele sadaka zino, zahabu na shaba na shaba ya kiguzi, ");
INSERT INTO kdc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","sufi ya buluu na sufi ya zambalau na sufi ndung'hu, viwalo vinogile va kitani na viwalo vitendigwe kwa mibahila ya mbuzi, ");
INSERT INTO kdc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ng'hwembe za ng'hondolo mbigalo zigeligwe langi ndung'hu na ng'hwembe za mnyama wa mbahali na mibiki ya muhamvi na mkese, ");
INSERT INTO kdc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mavuta ga taa na vinhu vilondigwa mbuli ya mavuta ga kubakala na mbuli ya ubani unung'hila goya. ");
INSERT INTO kdc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ubokele mabwe ga bei ng'hulu gokemigwa shohamu na mabwe gayagwe mbuli ya kukihamba kikoti cha mulava nhosa na kikoba cha mmhambaga. ");
INSERT INTO kdc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Vivija wanhu olondigwa wanitendele hema ding'alile, ili ng'hale hamoja nao. ");
INSERT INTO kdc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Utende hema dijo na vinhu vake kamba vonda nikulagusile. ");
INSERT INTO kdc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Nao wanhendele sanduku da lagano kwa mbao za mkese, utali wake uwe mkono umoja na nusu na ugazi wake uwe mkono umoja na utali wake kwa kuchola uchanha uwe mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Udibake sanduku dijo zahabu inogile kunze na mgati, na udizungulusile lugigo lwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Abaho koditendela sanduku dijo vipete vine va zahabu na uvigele mmagulu gake mane, kila mgulu kipete kimoja. ");
INSERT INTO kdc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Usongole mango za muhamvi na uzibake zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Mango azo uzigele mna ivipete vili kila mwambu wa disanduku, ili mudipape. ");
INSERT INTO kdc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mango azo zisigale mumo mvipete va disanduku sikuzilavigwe. ");
INSERT INTO kdc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Abaho mgati ya disanduku dijo wike vibao vibili va mabwe vandikigwe gamalagizo. ");
INSERT INTO kdc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Abaho usongole ngubiko aho hozigeligwa kumgongo nzambi, ngubiko ayo iwe ya zahabu inogile, utali wake uwe mkono umoja na nusu na ugazi wake uwe mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Abaho usongole viumbe vibili kwa zahabu, abaho uvike mumgwazo wa ingubiko, ");
INSERT INTO kdc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","imoja umwike mwambu uno na iyagwe mwambu uyagwe kuno na kuno. Uvike viumbe avo mumgwazo wa ingubiko, lakini viilumbe na ingubiko. ");
INSERT INTO kdc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Viumbe awo wailole na mabawa gao gayanzanze uchanha ya ingubiko. ");
INSERT INTO kdc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mdisanduku dijo wike vibao vibili va mabwe na uchanha yake wike ayo ingubiko. ");
INSERT INTO kdc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Na niye noiting'hana na gweye, hagati ya viumbe awo wabili weli uchanha ya disanduku da lagano, nolonga na gweye na nokugwelela malagizo gose mbuli ya Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Tenda meza ya mbao za mkese iwe na utali wa mkono umoja na ugazi wa nusu mkono na utali kwa kuchola uchanha uwe behi na kuvika mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Uibake zahabu inogile na uizungulusile lugigo lwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Abaho koizungulusila lubao luli na ugazi wa ganza na lubakigwe zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Utende vipete vine va zahabu na uvigele mna gamagulu gake mane. ");
INSERT INTO kdc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Vipete avo vikale behi na luja ulubao luzunguluswe mwiimeza na vokuwa vakupapila imeza. ");
INSERT INTO kdc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Usongole mango za muhamvi, na uzibake zahabu, mango azo zokuwa za kupapila ayo imeza. ");
INSERT INTO kdc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Utende sahani na vikasi, vivija utende bilika na vibakuli va kugidila nhosa ya ung'waji. Uvitende viya vose avo kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Uchanha ya imeza mogeka gaja gamagate gamundavile. Magate gago gosigala baho siku zose mgameso gangu. ");
INSERT INTO kdc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Utende kingolobweda cha zahabu inogile, dako jake na mgimbo wake uwe umoja, vikasi vake na vifundo vake na maluwa gake vose vitendigwe kwa kihande kimoja cha zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Matambi sita galawilile mumgimbo wa ikingolobweda, matambi madatu mwambu uno na madatu mwambu uyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kila tambi diwe na vifundo vidatu kamba vigali maluwa ga mulozi kila dimoja na vifundo vake na luwa jake. ");
INSERT INTO kdc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na umgimbo wa ikingolobweda uhambigwe na vifundo vine viigale kamba viwili mulozi uwe na vifundo na maluwa. ");
INSERT INTO kdc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kila hanhu hogozukila gamatambi mabili ili kuvikiza matambi sita ga ikingolobweda, hasi yake hawe na kifundo kimoja. ");
INSERT INTO kdc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Vifundo vivo na matambi gake vokuwa kinhu kimoja na ikingolobweda na vose vitendigwe kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Utende taa saba mbuli ya ikingolobweda uzike uchanha yake ili zimwemwese kuulongozi. ");
INSERT INTO kdc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","“Vivija utende viya va kugogela makala ga moto na viya va kuhalila moto kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Sola kilo malongo madatu na tano za zahabu inogile utendele acho ikingolobweda na viya vake vose. ");
INSERT INTO kdc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Witeganye utende kamba viulagusiligwe kuja kulugongo. ");
INSERT INTO kdc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Tenda hema da mting'hano kwa mapanziya longo ga kitani inogile galukigwe na nzabi za buluu na zambalau na udung'hu na ugagele ulembo wa viumbe weli na mabawa watendigwe na mafundi wanogile. ");
INSERT INTO kdc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kila panziya diwe na utali wa makono longo na mabili na ugazi wa makono mabili. ");
INSERT INTO kdc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mapanziya matano ugasonele hamoja dilawile panziya dimoja na matano gayagwe ugasonele hamoja dilawile panziya dimoja. ");
INSERT INTO kdc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Wike vitanzi va buluu mna imhindo ya panziya da ikimambukizo na utende vivo kwa mhindo ya panziya diyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Wike vitanzi malongo matano mna idipanziya dimoja na vitanzi malongo matano mdipanziya diyagwe, vitanzi vose viilole. ");
INSERT INTO kdc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Abaho utende vifungilo va zahabu malongo matano, ili ulumbilize vihande avo vibili va panziya, avo dihema diwe dimoja. ");
INSERT INTO kdc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Vivija utende ngubiko ya dihema kwa mapanziya longo na dimoja ga mibahila ya mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kila panziya diwe na utali wa makono longo na ndatu na ugazi wa makono mabili. Mapanziya gose gaigale. ");
INSERT INTO kdc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Mapanziya matano galumbilize hamoja na mapanziya sita galumbilize hamoja. Panziya dilumbilizigwe kwa mapanziya sita udibande kuulongozi wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Abaho wike vitanzi malongo matano mna idipanziya dimoja na vitanzi malongo matano mdipanziya diyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Utende vifungilo va shaba ya kiguzi malongo matano na uvigele mvitanzi ili ugalumbilize gago gamapanziya na kutenda ngubiko imoja ya dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ija inusu isigale ya dipanziya uigubike mwambu wa kukisogo wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Nusu mkono isigale ya idipanziya kila mwambu uigubike kila mwambu mzimbavu za dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Utende ngubiko iyagwe ya dihema kwa ng'hwembe za ng'hondolo mbigalo zigeligwe langi ndung'hu na ng'hwembe za mnyama wa mbahali. ");
INSERT INTO kdc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Utende mbao za mkese za kwimila dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kila lubao luwe na utali wa makono mane, na ugazi wa behi kuvikila mkono umoja, ");
INSERT INTO kdc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","kila lubao luwe na vilimi vibili va kulumbilizila. Mbao zose za dihema uzitende vivo. ");
INSERT INTO kdc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Utende mbao malongo mabili za mwambu wa kusini wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na vikalilo malongo mane va shaba, kila lubao vikalilo vibili ili kugogeleza vija ivilimi vibili. ");
INSERT INTO kdc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Utende mbao malongo mabili za mwambu wa kasikazini wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vikalilo malongo mane va shaba, kila lubao vikalilo vibili. ");
INSERT INTO kdc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kwa mwambu kwa kukisogo wa dihema, mwambu wa kudihongela zuwa utende mbao sita, ");
INSERT INTO kdc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","na utende mbao mbili kuvingolobweda va mwambu wa kukisogo wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mbao azo mbili za kutenda avo ivingolobweda vibili zilumbilizigwe kulawa hasi mbaka uchanha kuna ipete ya ichanduso. Mbao azo mbili za ivingolobweda avo vibili uzitende kamba vivo. ");
INSERT INTO kdc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Avo hokuwa na mbao nane na vikalilo longo na sita va shaba, kila lubao vikalilo vibili. ");
INSERT INTO kdc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Utende mango za muhamvi, mango tano mbuli ya mwambu umoja wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na mango tano mbuli ya mwambu uyagwe na mango tano mbuli ya mwambu wa kudihongela zuwa, kukisogo mwa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mango ili hagati ya mbao za dihema ibalazigwe kulawa mwambu uno mbaka uyagwe wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Mbao zose uzibake zahabu, na utende vipete va zahabu kugogeleza zimango. Vivija mango zose uzibake zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Utende dihema kamba vinikulagusile kuja kulugongo. ");
INSERT INTO kdc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tenda panziya da kitani inogile dilukigwe na sufi ya langi ya buluu na ya zambalau na udung'hu na udigele ulembo wa viumbe weli na mabawa watendigwe na mafundi wanogile. ");
INSERT INTO kdc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Udinanike mzimhanda nne za muhamvi zibakigwe zahabu, na zili na vifungilo va zahabu na zikale mvikalilo vine va shaba. ");
INSERT INTO kdc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Dike dipanziya hasi ya vifungilo uchanha ya dihema, abaho udigale disanduku da lagano mumo mdihema kukisogo ya dipanziya. Panziya dijo digole hanhu hong'ala na hanhu hong'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Wike ingubiko uchanha ya disanduku da lagano mgati ya hanhu hong'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ija imeza ikigwe gamagate uike mwambu wa kasikazini kunze ya dipanziya na kija ikingolobweda kike mwambu wa kusini wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Hana ulwingililo lwa dihema utende panziya da kitani inogile dizamile dilukigwe na sufi ya langi ya buluu na ya zambalau na udung'hu na udihambe kwa ulembo. ");
INSERT INTO kdc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Abaho utende mhanda tano za muhamvi za dipanziya na uzibake zahabu na wike vifungilo va zahabu na utende vikalilo vitano va shaba ya kiguzi mbuli ya mhanda zizo.” ");
INSERT INTO kdc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Imulungu kamulongela Musa, “Utende upango wa kulavila nhosa kwa mbao za mkese. Upango awo uigale kila mwambu, utali wake uwe makono mabili na nusu na ugazi wake uwe makono mabili na nusu na utali wake wa kuchola uchanha uwe mkono umoja na nusu. ");
INSERT INTO kdc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Utende mhembe nne mna zikona nne, na mhembe azo zokuwa kinhu kimoja na upango awo na uubake shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Viya vose va kulavila nhosa uvitende kwa shaba ya kiguzi, zae da kwikila mitozi na lwiko lwa kuzolela mitozi na bakuli na lwiko lwa kuhindulila inhosa na viya va kuhalila moto. ");
INSERT INTO kdc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Abaho utende lwavu lwa shaba ya kiguzi na wike vipete vine va shaba ya kiguzi mna zikona nne. ");
INSERT INTO kdc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ulwike lwavu awo mumgwazo hasi ya upango wa kulavila nhosa, ili uvike nusu ya upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Usongole mango za muhamvi za kupapila awo uupango wa kulavila nhosa na uzibake shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mango azo uzigele mvipete kila mwambu wa upango wa kulavila nhosa ili upapigwe. ");
INSERT INTO kdc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Utende upango awo kwa mbao na uwe na uvungu kamba vinikulagusile kuja kulugongo. ");
INSERT INTO kdc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Utende luwa lwa mting'hano. Mwambu wa kusini kuwe na mapanziya gatendigwe kwa kitani inogile ilukigwe, mapanziya gago gawe na utali wa makono malongo mane na nne kwa mwambu umoja. ");
INSERT INTO kdc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mapanziya gago gagogelezwe kwa mhanda za shaba ya kiguzi malongo mabili zili na vikalilo va shaba ya kiguzi. Ivifungilo va zimhanda na nzabi zake viwe va shaba. ");
INSERT INTO kdc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Vivija mwambu wa kasikazini, utali wa dipanziya uwe makono malongo mane na nne kwa mwambu umoja na mhanda malongo mabili za shaba ya kiguzi, lakini vifungilo va zimhanda na nzabi zake viwe va shaba. ");
INSERT INTO kdc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Mwambu wa kudihongela zuwa dipanziya diwe na utali wa makono malongo mabili na mbili kwa mwambu umoja na mhanda longo na vikalilo longo. ");
INSERT INTO kdc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mwambu wa kudilawila zuwa, mwambu wa kwingilila, luwa luwe na ugazi wa malongo mabili na mbili. ");
INSERT INTO kdc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Panziya da mwambu umoja wa umulango diwe na ugazi wa makono sita na nusu hamoja na mhanda ndatu na vikalilo vidatu. ");
INSERT INTO kdc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Vivija mwambu uyagwe wa umulango dipanziya diwe na ugazi wa makono sita na nusu hamoja na mhanda ndatu na vikalilo vidatu. ");
INSERT INTO kdc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hana umulango wa uluwa wike panziya dizamile dili na ugazi wa makono tisa, ditendigwe kwa nzabi za buluu na zambalau na udung'hu na kitani inogile ilukigwe na dihambigwe vinogile. Panziya dijo digogigwe na mhanda nne zili na vikalilo vine. ");
INSERT INTO kdc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mhanda zose kuzunguluka uluwa zigogigwe na mango za shaba, vifungilo vake viwe va shaba na vikalilo vake viwe va shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Luwa luwe na utali wa makono malongo mane na nne na ugazi wa makono malongo mabili na mbili na utali wa kuchola uchanha wa makono mabili na nusu. Mapanziya gake gawe ga kitani inogile na vikalilo va shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Vinhu vose viyagwe vizengiligwe na va kutumia mdihema na uluwa, vose viwe va shaba ya kiguzi hata vifungilo va nzabi viwe va shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Walagize wanhu wa Izilaeli wakugalile mavuta ganogile ga mizeituni mbuli ya taa, ili taa zikwake kila siku ichungulo. ");
INSERT INTO kdc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haluni na wanage weke taa mdihema da mting'hano, kunze ya panziya dili kuulongozi wa sanduku da lagano. Mgameso gangu taa azo zikwake toka ichungulo mbaka imitondo. Lagizo dino digogigwe milele na Waizilaeli na ulelo wao. ");
INSERT INTO kdc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Mgale ndugu yako Haluni na wanage wa kimbigalo, Nadabu na Abihu na Eleazali na Itamali. Uwasagule hagati ya wanhu wa Izilaeli ili wanisang'hanile kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Umsonele ndugu yako Haluni viwalo va kulavila nhosa ili yoneke kanoga na yagweleligwe ukulu mgameso ga wanhu. ");
INSERT INTO kdc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Walagize mafundi waniwagwelele nzewele wamtendele Haluni viwalo, ili yekigwe kwa sang'hano ya kunilavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Walongele wamtendele vinhu vino, kikoba cha mmhambaga na kikoti na kanzu igeligwe ulembo na kanzu na kilemba na mkwiji. Ndugu yako Haluni na wanage wavale viwalo vivo ili wanisang'hanile kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mafundi awo wasone viwalo vivo kwa sufi ya buluu na zambalau na udung'hu na nzabi za zahabu na kitani inogile ilukigwe. ");
INSERT INTO kdc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Wakitende kikoti cha mulava nhosa kwa sufi ya buluu na zambalau na udung'hu na nzabi za zahabu na kitani inogile ilukigwe na kuhambigwa goya. ");
INSERT INTO kdc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kiwe na nzabi mbili zisonigwe mzikona mbili ili zinzabi zifungigwe mmaega. ");
INSERT INTO kdc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mkwiji wa kufungila utendigwe kwa vinhu vivija va nzabi za zahabu na sufi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe na kutenda kiwe kinhu kimoja na ikikoti. ");
INSERT INTO kdc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Abaho usole mabwe mabili ga shohamu, ugandike matwaga ga wana longo na wabili wa Izilaeli, ");
INSERT INTO kdc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kamba viwaleleke, matwaga sita mdibwe dimoja na matwaga sita mdibwe diyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ugandike gamatwaga ga wana wa Izilaeli mgamabwe gago kamba munhu viyosongola muhuli abaho ugakande mna ivigigo va zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mabwe gago mabili gekigwe mzinzabi za ikikoti kulagusa makabila longo na mabili ga wana wa Izilaeli. Avo Haluni yavale matwaga gago mmaega gake mgameso gangu niye Mndewa Imulungu, kamba kinhu cha kukumbuka. ");
INSERT INTO kdc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Utende vigigo vibili va zahabu, ");
INSERT INTO kdc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu mibili ya zahabu inogile ilukigwe kamba nzabi. Uifunge ayo imikufu mvigigo vivo. ");
INSERT INTO kdc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Utende kikoba cha mmhambaga, mbuli ya kujuwa viyolonda Imulungu. Kitendigwe kwa vinhu vivija kamba ikikoti. Ukitende kwa nzabi za zahabu na sufi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kikoba acho kibandigwe na kiigale kila mwambu, utali wake uwe lwayo lumoja na ugazi wake uwe lwayo lumoja. ");
INSERT INTO kdc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kihambigwe kwa misafa mine ya mabwe ga bei ng'hulu, msafa wa ichanduso uhambigwe kwa mabwe ga akiki na topazi na alimasi ndung'hu, ");
INSERT INTO kdc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","msafa wa kabili uhambigwe kwa mabwe ga zumalidi na johali ya langi ya samawati na alimasi, ");
INSERT INTO kdc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","msafa wa kadatu uhambigwe kwa mabwe ga yasinto na akiki ndung'hu na ametisito, ");
INSERT INTO kdc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","na msafa wa ikane uhambigwe kwa mabwe ga zabalajadi na shohamu na yasipi. Mabwe gago gose gakandigwe mvigigo va zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Avo hokuwa na mabwe longo na mabili, kila dibwe jandikigwe twaga da wana wa Izilaeli, kila dibwe dokuwa kamba muhuli, kulagusa makabila longo na mabili. ");
INSERT INTO kdc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Mbuli ya kikoba cha mmhambaga, utende mikufu ya zahabu inogile na ilukigwe kamba nzabi. ");
INSERT INTO kdc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Abaho utende pete mbili za zahabu na uzifunge mzikona mbili za ikikoba, ");
INSERT INTO kdc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","na imikufu mibili ya zahabu uifunge mzipete zizo. ");
INSERT INTO kdc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mwambu umoja na mwambu uyagwe wa imikufu uzifunge mvigigo vibili va kija ikikoba ili vigogeleze ikikoti mmaega mwambu wa kuulongozi. ");
INSERT INTO kdc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Abaho utende pete mbili za zahabu na uzifunge kwa hasi mna zikona mbili za hasi ya ikikoba behi na kikoti. ");
INSERT INTO kdc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Abaho utende pete mbili ziyagwe za zahabu uzike mumgwazo wa ikikoti mwambu wa hasi, hanhu aho ikikoti hokiilumba na umkwiji ulukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kikoba cha mmhambaga kifungigwe mkikoti kwa nzabi ya buluu, ili acho ikikoba cha mmhambaga kigoge goya na kikale mumkwiji ulukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Haluni yahengila hanhu hong'ala yakivale mmhambaga kikoba acho cha kujuwa golondigwa acho chandikigwe matwaga gamakabila longo na mabili ga wana wa Izilaeli, ili niye Mndewa Imulungu sikuniwasemwe mweye. ");
INSERT INTO kdc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Mkikoba acho ugele mabwe ga kujuwa golondigwa na gawe mwiimhambaga ya Haluni kila viyokwingila kuulongozi wangu. Abaho Haluni kogajuwa gaja gonilonda kwa Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Utende kanzu da kuvalila kikoti acho kwa sufi ya buluu. ");
INSERT INTO kdc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kanzu ajo diwe na zonzo da kwingila pala. Zonzo ajo dizunguluswe lugigo lulukigwe goya ili sikudidegeke. ");
INSERT INTO kdc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Mwiimhindo ya hasi uluke kinhu kamba tonga kwa sufi ya buluu na zambalau na udung'hu. Hagati ya kila tonga wike nyangili ya zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Wike tonga abaho nyangili, tonga abaho nyangili kuzunguluka kanzu jose. ");
INSERT INTO kdc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haluni yavale kanzu dijo viyosang'hana sang'hano ya kulava nhosa na sauti ya nyangili yohulikigwa viyokwingila hanhu hong'ala mgameso gangu na viyolawa kunze, ili sikuyafe. ");
INSERT INTO kdc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Abaho utende lung'andi lwa zahabu inogile na wandike mbuli zino, ‘Kalavigwa kwa Mndewa Imulungu.’ ");
INSERT INTO kdc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Abaho ulufunge lung'andi awo kuulongozi wa kilemba kwa luzabi lwa buluu. ");
INSERT INTO kdc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Haluni yaluvale lung'andi awo mkihanga chake. Kwa kutenda vivo kopapa gehile ga wanhu wa Waizilaeli gawatendile viondavila nhosa zao, avo nozitogola nhosa zao. ");
INSERT INTO kdc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Umtendele Haluni kanzu digeligwe ulembo na dilukigwe kwa kitani inogile na umvaze kilemba cha kitani inogile na mkwiji uhambigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Uwatendele wanage Haluni makanzu na mikwiji na vilemba ili oneke wanoga na wagweleligwe ukulu. ");
INSERT INTO kdc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Umvaze ndugu yako Haluni na wanage viwalo vivo, abaho uwagidile mavuta na uwekile makono na uwalave kumwangu niye ili wanisang'hanile kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Vivija wasonele kaputula za kitani ziwagubike toka mvigudi mbaka mgamahaza ili sikuwakale mwazi. ");
INSERT INTO kdc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haluni na wanage wavale kaputula zizo wahengila mdihema da mting'hano, hebu waheza muupango wa kulavila nhosa, kusang'hana kamba walava nhosa hanhu hong'ala ili sikuwoneke wa mwazi na wakomigwe. Lagizo dino digogigwe milele na Haluni na ulelo wake. ");
INSERT INTO kdc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Na gweye uwatendele vino Haluni na wanage ili kuwatenda wanisang'hanile kamba walava nhosa. Sola bofu da ng'ombe mbigalo na ng'hondolo wabili wa kimbigalo watelele, ");
INSERT INTO kdc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","magate hagageligwe hamila, na maandazi hagageligwe hamila na gakandigwe kwa mavuta na vigate visisili vigeligwe mavuta. Vose vino uvitende kwa usage unogile wa ngano. ");
INSERT INTO kdc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Abaho uvike mkigelo undavile nhosa hamoja na dija dibofu da ng'ombe na iwang'hondolo wabili wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Abaho uwagale Haluni na wanage hana ulwivi lwa dihema da mting'hano, abaho uwakoshe kwa mazi. ");
INSERT INTO kdc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Abaho usole iviwalo va ulava nhosa na umvaze Haluni, kanzu na kanzu igeligwe ulembo na kikoti na kikoba cha mmhambaga na umfunge uja umkwiji ulukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Umvaze kilemba mdipala na wike uja ulung'andi lung'alile mumgwazo wa ikilemba. ");
INSERT INTO kdc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Abaho usole gaja gamavuta ga kubaka, umgidile Haluni mdipala jake avo komulava kumwangu. ");
INSERT INTO kdc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Abaho uwagale wanage Haluni na uwavaze gamakanzu. ");
INSERT INTO kdc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Uwafunge mikwiji mvigudi vao na uwavaze vilemba vao. Vino vivo vonda uwatende Haluni na wanage wang'ale. Hewo na ulelo wao okuwa walava nhosa milele. ");
INSERT INTO kdc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Abaho udigale dija dibofu da kimbigalo da ng'ombe haulongozi wa dihema da mting'hano. Haluni na wanage weke makono gao kudipala da idibofu. ");
INSERT INTO kdc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Dichinje bofu dijo mgameso gangu aho hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Sola damu kidogo na uibake kwa kidole chako mzimhembe za upango wa kulavila nhosa, na damu yonda isigale ite hasi ya uupango. ");
INSERT INTO kdc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Abaho ulave mavuta gose geli mna ivinhu va mgati, maini na figo mbili uvisome moto uchanha ya upango. ");
INSERT INTO kdc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Lakini nyama yake na ing'hwembe na mavi gake uvisole ukavisome moto kunze ya ng'hambi yenu. Ino ayo nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Abaho sola ng'hondolo imoja mna iwang'hondolo wabili wa kimbigalo na umulongele Haluni na wanage weke makono gao kudipala jake. ");
INSERT INTO kdc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Umchinje na usole idamu uimizile banzi zose za uupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Abaho mkanhe vihande vihande ayo ing'hondolo. Sunha ivinhu va mgati na migulu yake, uvike vose hamoja na dipala na nyama ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Abaho umsome ng'hondolo wose uchanha ya uupango, ili undavile niye nhosa ya kusoma moto. Mnung'ho wa nhosa ayo oninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Umsole ija ing'hondolo iyagwe, Haluni na wanage weke makono gao kudipala jake. ");
INSERT INTO kdc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Umchinje ng'hondolo ayo na usole damu kidogo na umbake Haluni na wanage mumgwazo wa magwiti gao ga mkono wa kudila na mna imidole ng'hulu ya makono gao ga kudila na mna imidole ng'hulu ya magulu gao ga mkono wa kudila. Damu yonda isigale uimizile banzi zose za uupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Sola damu kidogo ili muupango wa kulavila nhosa hamoja na gaja gamavuta ga kubakala ummizile Haluni na viwalo vake, vivija uwamizile wanage na viwalo vao, avo Haluni na wanage okuwa wang'ala na viwalo vao kumwangu niye. ");
INSERT INTO kdc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Abaho usole mavuta ga ng'hondolo ayo wa ikimbigalo, mavuta ga mkila wake na mavuta gagubike ivinhu va mgati na maini na figo zose mbili na mavuta gake na kihili cha ukudila. ");
INSERT INTO kdc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kulawa mna ikigelo cha magate hagageligwe hamila, kili kuulongozi wa Mndewa Imulungu, sola gate dimoja na andazi dimoja digeligwe mavuta na kigate kisisili kimoja. ");
INSERT INTO kdc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vinhu vose avo wagwelele Haluni na wanage na wao ovinula uchanha kamba kilaguso cha kundavila niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Abaho uvisole mmakono gao uvisome moto muupango wa kulavila nhosa hamoja na ija inhosa ya kusoma moto, ili vinung'hile goya na kuninogeza niye Mndewa Imulungu. Ino ayo nhosa ilavagwa kwa moto. ");
INSERT INTO kdc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Abaho usole kidali cha ing'hondolo wakumtenda Haluni yalavigwe kumwangu na ukinule uchanha kamba kilaguso cha kundavila niye Mndewa Imulungu. Kidali acho chokuwa chako. ");
INSERT INTO kdc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Mulava nhosa yahalavigwa kumwangu, kidali na kihili cha ng'hondolo mbigalo vilavigwe kumwangu, vose avo vokuwa va Haluni na wanage. ");
INSERT INTO kdc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Avo milele wanhu wa Izilaeli wajuwe kamba zinhosa za kugala kuilumba ziwonilavila niye Mndewa Imulungu kidali na kihili mwenyego Haluni na ulelo wake. Ayo yokuwa nhosa yao kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Haluni yahafa, viwalo vake ving'ala wagweleligwe wanage wavivale siku donda wabakigwe mavuta na kwikiligwa makono. ");
INSERT INTO kdc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwanage Haluni yonda yasole hanhu ha ulava nhosa wa tatake yavivale viwalo avo kwa siku saba mna dihema da mting'hano ili yasang'hane mna ihanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Sola nyama ya ayo ing'hondolo yalavigwe kumwangu, na uitelekele hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Abaho uwagwelele Haluni na wanage, na wao waidile hana ulwivi lwa dihema da mting'hano hamoja na magate gasigale mkigelo. ");
INSERT INTO kdc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wavije vinhu avo visang'hanilwe kuwalava kumwangu na kuwatenda wailumbe na niye, lakini munhu yoyose iyagwe sikuyaje kwavija vinhu avo ving'ala. ");
INSERT INTO kdc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kamba nyama yoyose hebu magate vosigala mbaka imitondo, uvisome moto. Sikuvidigwe kwavija ving'ala. ");
INSERT INTO kdc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Vino vivo vonda uwatendele Haluni na wanage kamba vinikulagize. Uwatende wang'ale kwa siku saba, ");
INSERT INTO kdc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","na kila siku uchinje ng'ombe mbigalo yawe nhosa ya kusegesa nzambi kwa kutenda vivo koutenda upango wa kulavila nhosa ung'ale, abaho uugidile mavuta ili uulave kumwangu. ");
INSERT INTO kdc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kwa siku saba uutende upango wa kulavila nhosa ung'ale na uulave kumwangu. Wahamambukiza upango awo okuwa ung'ala na kinhu chochose chonda kiukwase chong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Kila siku, kipindi chose kumwande ulave nhosa uchanha ya upango, mabofu mabili ga ng'hondolo geli na mwaka umoja. ");
INSERT INTO kdc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Bofu dimoja da ng'hondolo udilave imitondo na diyagwe ichungulo. ");
INSERT INTO kdc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Hamoja na dija dibofu da ng'hondolo diulava imitondo ulave na vibaba vibili va usage ulibule midundulu uhanganyigwe na nyhupa imoja ya mavuta ganogile ga mzeituni, na nyhupa imoja ya divai kamba nhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Vivija na dija dibofu da ng'hondolo dilavagwa ichungulo udilave hamoja na nhosa ya ndiya na nhosa ya king'waji kamba dija da imitondo. Mnung'ho wa nhosa azo zilavigwa kumwangu oninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Nhosa ino ya kusoma moto ilavigwe siku zose, ulelo mbaka ulelo mgameso gangu niye Mndewa Imulungu, kuulongozi wa ulwivi lwa dihema da mting'hano, aho honda niiting'hane na mweye na kulonga na mweye. ");
INSERT INTO kdc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Vivija aho honda niiting'hane na Waizilaeli na mng'alo wangu ohatenda hanhu aho hang'ale. ");
INSERT INTO kdc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Avo dihema da mting'hano na uupango wa kulavila nhosa, novitenda ving'ale. Vivija Haluni na wanage nowatenda wang'ale ili wanisang'hanile kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Avo, niye nokala na Waizilaeli, na nokuwa Imulungu wao. ");
INSERT INTO kdc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na hewo ojuwa kamba niye Mndewa Imulungu wao, niwalava mwiisi ya Misili ili ng'hale nao. Niye ayo Mndewa Imulungu wao. ");
INSERT INTO kdc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Utende upango kwa mbao za mkese, mbuli ya kusomela ubani. ");
INSERT INTO kdc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Upango awo uigale, utali wake na ugazi wake uwe nusu mkono, na utali wake wa kuchola uchanha uwe mkono umoja. Mhembe zake zilawilile na ziwe kinhu kimoja na awo uupango, ");
INSERT INTO kdc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","na uubake zahabu inogile. Mwambu wa uchanha, banzi zose za mulubavu na mzimhembe, vivija uzungulusile lugigo lwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Utende vipete vibili va zahabu na uvike hasi ya lugigo mna zibanzi zake mbili ziilola. Vipete avo vogogeleza zimango kipindi cha kuupapa uupango. ");
INSERT INTO kdc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Usongole mango za muhamvi na uzibake zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Upango awo uwike kuulongozi wa panziya dili kuulongozi wa sanduku da lagano, aho hana ingubiko baho honda niiting'hane na gweye. ");
INSERT INTO kdc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kila imitondo Haluni yahengila kuzitanda zitaa, yasome ubani unung'hila goya uchanha ya upango. ");
INSERT INTO kdc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Yatende vivo yahabwinha zitaa ichungulo. Nhosa ino ya ubani igendelele bila kulekigwa kipindi chose chonda kize cha ulelo wenu. ");
INSERT INTO kdc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Muupango awo, sikumusome ubani hautelele, na sikumulave nhosa ya kusoma moto, hebu nhosa ya ndiya, hebu kugida nhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mwanza umoja kwa mwaka Haluni yautende upango ung'ale kwa kugida mzimhembe zake damu ya nhosa ya kusegesa nzambi. Mbuli ayo itendigwe kila mwaka kipindi chose chonda kize. Upango awo ung'ala kwa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Vonda uwapete wanhu wa Izilaeli, kila munhu kolondigwa kuliha sente mbuli ya ugima wake kipindi cha kupetigwa. Avo kuduhu utamu wihile mna iwanhu wapetigwe. ");
INSERT INTO kdc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kila munhu yapetigwe kolondigwa yalihe gilamu tano za shaba kwa kipimo kili mdihema da mting'hano. Sadaka ino kondavila niye. ");
INSERT INTO kdc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kila munhu yopetigwa, kulawa miyaka malongo mabili na kugendelela kondavila sadaka ayo. ");
INSERT INTO kdc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Munhu mkiwa na munhu tajili wose olondigwa walihe sawa, kwa kipimo kili mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ubokele shaba ayo kulawa kwa Waizilaeli, na gweye uzitumie kwa sang'hano ya dihema da mting'hano. Nayo yokuwa kinhu cha kukumbukigwa na Waizilaeli kuulongozi wangu, mbuli ya kuliha ugima wenu.” ");
INSERT INTO kdc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Utende bakuli da shaba ya kiguzi na utende mgimbo wa shaba ya kiguzi wa kukalila dibakuli dijo, dike bakuli dijo hagati ya dihema da mting'hano na uupango wa kulavila nhosa, na ugele mazi mdibakuli dijo. ");
INSERT INTO kdc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haluni na wanage wasunhe makono gao na magulu gao kulawa mdibakuli dijo. ");
INSERT INTO kdc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wang'hali hawana kwingila mna dihema da mting'hano olondigwa waisunhe kwa mazi ili sikuwafe. Vivija waisunhe wahakwesa hana uupango ili wanisang'hanile kwa kunilavila nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Olondigwa wagasunhe makono gao na magulu gao ili sikuwafe. Mbuli ino yokuwa lagizo kwa Haluni na ulelo wake, milele.” ");
INSERT INTO kdc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Sola vinhu vinogile kamba vija manemane ya mazi nyhupa sita, mdalasini unung'hila goya kilo ndatu, mkegeni unung'hila goya kilo ndatu, ");
INSERT INTO kdc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na mdalasini uyagwe kilo sita na vipimo avo vose viigale na kipimo kili mdihema ding'alile, vivija usole nyhupa nne za mavuta ga mzeituni. ");
INSERT INTO kdc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kwa vinhu vivo utende mavuta gang'alile na ugahanganye kamba viwatendaga awo wengaga mavuta gonung'hila goya, mavuta gago mogasang'hanila kwa kulava vinhu kumwangu. ");
INSERT INTO kdc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Abaho udigidile mavuta gago dihema da mting'hano, na disanduku da lagano, ");
INSERT INTO kdc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meza na viya vake vose, taa na ikingolobweda chake na viya vake na upango wa kusomela ubani, ");
INSERT INTO kdc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na upango wa kulavila nhosa na viya vake vose na dibakuli da shaba na mgimbo wake na dako jake. ");
INSERT INTO kdc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Uvilave kumwangu ili ving'ale ng'hani. Kinhu chochose chahakwasa vinhu avo chokuwa king'ala. ");
INSERT INTO kdc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Abaho uwagidile gamavuta Haluni na wanage na kuwalava kumwangu ili wanisang'hanile kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Walongele Waizilaeli, ‘Gano gokuwa mavuta gangu gang'alile ga kubaka mna uulelo wenu wose. ");
INSERT INTO kdc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mavuta gano sikuyagidiligwe munhu yoyose vivino vivino, na sikumutende mavuta gayagwe kamba gano, mavuta gano gang'ala na mugone kamba gang'ala siku zose. ");
INSERT INTO kdc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Munhu yoyose yonda yatende mavuta kamba gano, hebu yahamgidila munhu hafaya kugidiligwa mavuta gano, munhu ayo kobaguligwa na wanhu zake.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Abaho Mndewa Imulungu kamulongela Musa, “Sola vipimo va vinhu va umulile viigale na vinhu vino, ululu wa natafi na ululu wa shekeleti na ululu wa kelibena na ubani unogile. ");
INSERT INTO kdc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Soleni vinhu avo mutendele ubani, kamba viyatendaga munhu yokwenga mavuta gonung'hila goya. Ubani awo ugeligwe mkele ili unoge na ung'ale. ");
INSERT INTO kdc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Abaho udugigwe na kuwa usage msisili ili utumike mgati mdihema da mting'hano, kuulongozi wa sanduku da lagano, aho honda niiting'hane na gweye. Ubani awo ung'ala kumwenu. ");
INSERT INTO kdc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Sikuutende ubani kamba awo kwa kutumia mwenyego, kwavija ubani awo okuwa ung'ala kumwangu niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Munhu yoyose yonda yatende ubani kamba awo ili kudeng'helela viunung'hila kobaguligwa na wanhu zake.” ");
INSERT INTO kdc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nimsagula Bezaleli mwanage Uli mzukulu wa Huli kulawa kabila da Yuda, ");
INSERT INTO kdc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","na nimmemeza loho yangu. Nimgwaa nzewele na kujuwa vinhu na ufundi, ");
INSERT INTO kdc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ili yatende sang'hano inogile, yawe mtenda vinhu va zahabu na shaba na shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nimtenda yajuwe kukanha goya mabwe, kusongola vibao na kila udahi wa kutenda vinhu. ");
INSERT INTO kdc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Vivija nimsagula Oholiabu mwanage Ahisamaki, kulawa kabila da Dani, yasang'hane hamoja na heyo. Vivija niwagwaa udahi mkulu wanhu wayagwe kwa sang'hano ziyagwe, ili watende vinhu vose vinilagize visang'hanigwe. ");
INSERT INTO kdc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Watende, hema da mting'hano, sanduku da lagano, na ngubiko yake, na vinhu vake vose, ");
INSERT INTO kdc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meza na viya vake, kingolobweda na vinhu vake, na upango wa kusomela ubani, ");
INSERT INTO kdc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","upango wa kulavila nhosa na viya vake vose, bakuli da shaba na mgimbo wake, ");
INSERT INTO kdc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","viwalo ving'ala va mulava nhosa Haluni hamoja na wanage onda wasang'hane kamba walava nhosa, ");
INSERT INTO kdc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mavuta gang'alile na ubani unung'hila goya mbuli ya hanhu hong'ala. Vinhu avo vose vitendigwe kamba vinikulagize.” ");
INSERT INTO kdc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Walongele Waizilaeli olondigwa waikumbuke siku yangu ya kubwihila, kwavija siku ayo ni kilaguso cha niye na mweye na ulelo wenu wose kamba niye ayo Mndewa Imulungu niwatenda mung'ale. ");
INSERT INTO kdc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Molondigwa muideng'helele siku ya kubwihila, kwavija siku ayo ing'ala kumwenu. Munhu yoyose yoleka kuigoga siku ayo yakomigwe. Na munhu yoyose yonda yasang'hane siku dijo kobaguligwa na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sang'haneni sang'hano zenu kwa siku sita, lakini siku ya saba ni siku ya kubwihila, na siku ayo ing'ala. Munhu yoyose yonda yasang'hane siku ayo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Avo Waizilaeli waideng'helele siku ayo ya kubwihila muulelo wao wose kamba lagano dilibule uhelelo. ");
INSERT INTO kdc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mbuli ino yokuwa kilaguso cha niye Mndewa Imulungu na Waizilaeli milele, kwavija nilumba ulanga na isi kwa siku sita na siku ya saba ndeka kusang'hana nibwihila.” ");
INSERT INTO kdc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mndewa Imulungu viyeshilize kulonga na Musa kuna ulugongo lwa Sinai, kamgwelela Musa vija ivibao vibili va mabwe, Imulungu viyandike malagizo kwa kidole chake mwenyego. ");
INSERT INTO kdc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wanhu viwonile Musa kokawa kuhumuluka kulugongo, waiting'hana kuulongozi wa Haluni, wamulongela, “Tutendele imilungu yonda itulongoze kwavija hatujuwa choni kimulawile Musa ayo yatulavile mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haluni kawedika, “Laveni heleni za zahabu zili mmagwiti ga wehe zenu na wanenu munigalile.” ");
INSERT INTO kdc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Avo wanhu wose walava iziheleni zao za zahabu na wamgalila Haluni. ");
INSERT INTO kdc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nayo kazisola kazilumbula na katenda kinyago cha ng'ombe wa kimbigalo. Wanhu wakemelela, “Ino ayo imulungu wetu Waizilaeli yatulavile mwiisi ya Misili.” ");
INSERT INTO kdc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Abaho Haluni kazenga upango wa kulavila nhosa kuulongozi wa kinyago acho cha ng'ombe, abaho kawalongela wanhu, “Mayo hokuwa na nyimwilinyimwili ya kumgwaa ukulu Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Imitondo yake wanhu walamuka ulukwili walava nhosa za kusoma moto na nhosa za kugala kuilumba. Wanhu wakala hasi waja na kung'wa ng'hani, abaho wasonga kucheza. ");
INSERT INTO kdc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Abaho Mndewa Imulungu kamulongela Musa, “Humuluka hasi kwavija wanhu zako uwalavile mwiisi ya Misili wainanga na watenda nzambi. ");
INSERT INTO kdc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Wagaleka malagizo ganiwalagize na waitendela kinyago kiigalile na ng'ombe wa kimbigalo. Nao wakitambikila na okilavila nhosa kuno olonga, ‘Gweye Izilaeli ino ayo imulungu wetu yatulavile mwiisi ya Misili.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mndewa Imulungu kamulongela Musa, “Nojuwa kamba wanhu wano wana mizoyo midala. ");
INSERT INTO kdc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Avo, sikuugeze kungomesa. Nileke niwakoboze abaho nokutenda gweye uwe na ulelo onda uwe kabila kulu.” ");
INSERT INTO kdc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Lakini Musa kampula Mndewa Imulungu wake kalonga, “Go Mndewa Imulungu, habali kowagevuzikila ng'hani wanhu wako uwalavile mwiisi ya Misili kwa udahi na mkono wenye nguvu? ");
INSERT INTO kdc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Wahatenda vivo Wamisili olonga, ‘Kawalava ili yawakome kulugongo na sikuwoneke kabili mwiisi.’ Go Mndewa Imulungu, leka kuwagevuzikila na sikuutende acho kiulonda kutenda kwa wanhu zako. ");
INSERT INTO kdc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wakumbuke wasang'hanaji zako Abulahamu na Isaka na Izilaeli, gweye mwenyego kuiduwila kwa kulonga, ‘Nowatenda muwe na ulelo kamba nhondo za kuulanga na nowagwelela isi yose inilongile nowagwaa iwe yao milele.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Avo, Mndewa Imulungu kaleka kuwatendela dija dihile diyalongile kotenda. ");
INSERT INTO kdc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Abaho Musa kahumuluka hasi ya ulugongo, kuno kagoga vibao vibili va mabwe ga lagano vandikigwe malagizo ga Imulungu banzi zose. ");
INSERT INTO kdc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Vibao avo vikala vitendigwe na Imulungu mwenyego, na Imulungu mwenyego heyo yandike. ");
INSERT INTO kdc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua viyahulike wanhu okemelela, kamulongela Musa, “Wanhu otowa nyangi za ng'hondo kuna ing'hambi.” ");
INSERT INTO kdc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa kamwidika, “Siyo nyangi za kuhuma, hebu kuhumwa, ila niye nohulika nyangi za wanhu okwimba.” ");
INSERT INTO kdc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Viwavikile behi ya ng'hambi wachona acho ikinyago cha ng'ombe wa kimbigalo na wanhu ocheza, aho Musa kagevuzika, kavasa hasi avo ivibao kulawa mmakono gake na kavibena. ");
INSERT INTO kdc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Avo, kakisola kinyago acho kakilukuza, kakihonda honda kiwa kamba usage, kaukologa usage awo mgamazi na kawananahiza Waizilaeli wang'we. ");
INSERT INTO kdc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa kamuuza Haluni, “Wa kutenda choni wanhu wano mbaka kuwengiza mna inzambi kamba ino?” ");
INSERT INTO kdc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haluni kamwidika Musa, “Chonde go mkulu sikuunigevuzikile niye msang'hanaji wako. Gweye kuwajuwa goya wanhu wano viwaitandile kutenda gehile. ");
INSERT INTO kdc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wanilongela, Musa yatulavile mwiisi ya Misili hatujuwile choni kimpatile avo, ‘Tutendele imulungu wetu yonda yatulongoze.’ ");
INSERT INTO kdc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Niye niwalongela, kila munhu yeli na zahabu yalave. Avo wangalila na niye nizilumbula muumoto na kilawa kinyago kino cha ng'ombe wa kimbigalo!” ");
INSERT INTO kdc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa viyonile wanhu watenda ubozi, na Haluni kawalekela watende ubozi awo, na kuigalila kinyala kuulongozi wa wanhu owehila, ");
INSERT INTO kdc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa kema hana ulwivi lwa kwingilila kuna ing'hambi kalonga, “Munhu yoyose yeli mwambu wa Mndewa Imulungu yeze kumwangu!” Walawi wose wamcholela Musa. ");
INSERT INTO kdc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Abaho kawalongela, “Mndewa Imulungu wa Izilaeli kolonga vino, ‘Kila munhu yaifunge sime mkigudi chake na yazunguluke kila hanhu mna ing'hambi kulawa mulango uno mbaka uyagwe, na kila munhu yamkome ndugu yake, mbwigake na munhu yokala nayo behi.’ ” ");
INSERT INTO kdc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Walawi watenda kamba viwalagizwe na Musa, siku dijo wakomigwa wanhu elufu ndatu. ");
INSERT INTO kdc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa kawalongela, “Lelo mweye wenyego muilava kwa Mndewa Imulungu, kwavija hamulemile hata kuwakoma wanenu na ndugu zenu. Imulungu yawatende mumwede lelo.” ");
INSERT INTO kdc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Imitondo yake Musa kawalongela wanhu, “Mtenda nzambi ng'hulu ng'hani. Lakini sambi nokwela kulugongo kwa Mndewa Imulungu, sengine nodaha kutenda Imulungu yazigele kumgongo nzambi zenu.” ");
INSERT INTO kdc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Avo Musa kabweleganya kwa Mndewa Imulungu kamulongela, “Chonde Imulungu, wanhu watenda nzambi ng'hulu, waitendela imulungu wao wa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Lakini sambi nokupula uzigele kumgongo nzambi zao, kamba huzigela kumgongo, dilave twaga jangu mna ikitabu chako kiwandike matwaga ga wanhu zako.” ");
INSERT INTO kdc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mndewa Imulungu kamwidika Musa, “Munhu yoyose yatendile nzambi nodilava twaga jake mna ikitabu changu. ");
INSERT INTO kdc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Lakini sambi chola, ukawalongoze wanhu mbaka hanhu hanikulongele. Nomtuma msenga wangu wa kuulanga yakulongolele, lakini siku yovika vonda niwakoboze wanhu wano kwa nzambi zao.” ");
INSERT INTO kdc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mndewa Imulungu kawagalila wanhu mikubulo kwavija wampula Haluni yawatendele kinyago cha ng'ombe kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mndewa Imulungu kamulongela Musa, “Usegele hanhu hano gweye hamoja na wanhu uwalavile mwiisi ya Misili, muchole mwiisi iniwalongele Abulahamu na Isaka na Yakobo kamba nowagwaa isi ayo ulelo wao. ");
INSERT INTO kdc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nomtuma msenga wa kuulanga yawalongoze mweye, na nowawinga Wakanaani na Waamoli na Wahiti na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO kdc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Choleni mwiisi imemile maziwa na uki. Lakini niye sichola na mweye kwavija mweye mizoyo yenu midala nodaha kuwakoma mnzila.” ");
INSERT INTO kdc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Wanhu viwahulike mbuli azo za kugela giogio, wasonga kulila na kuduhu munhu yavalile vinhu va kuihamba. ");
INSERT INTO kdc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Watenda avo kwavija Mndewa Imulungu kamulongela Musa yawalongele Waizilaeli, “Mweye wanhu hamuhulikaga munhu, nahachola na mweye nodaha kuwakoma wose. Sambi vuleni vinhu venu va kuihamba na nojuwa kinhu cha kuwatenda.” ");
INSERT INTO kdc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Avo Waizilaeli wavula vinhu vao va kuihamba viwasegele kulugongo lwa Holebu. ");
INSERT INTO kdc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa kekaga hema diyagwe kunze ya ing'hambi, hema dijo vivija kadikema, “Hema da mting'hano.” Munhu yoyose yalondile mbuli yoyose kulawa kwa Mndewa Imulungu, kochola kuna dihema dijo da mting'hano kunze ya ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kila mwanza Musa viyacholile kuna dihema dijo, kila munhu kema hana ulwivi lwa ikibanda chake na kumulola Musa viyokwingila mna dihema dijo. ");
INSERT INTO kdc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa yahengila mdihema dijo mhanda ya wingu yokwima hana ulwivi lwa dihema, na Mndewa Imulungu kolonga na heyo. ");
INSERT INTO kdc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wanhu wose viwayone mhanda ayo ya wingu ima hana ulwivi lwa dihema, kila munhu kaidulika na kumtambikila Mndewa Imulungu hana ulwivi lwa kibanda chake. ");
INSERT INTO kdc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mndewa Imulungu kakala kolonga na Musa meso kwa meso, kamba vija munhu na mbwigake. Abaho Musa kabwela kabili kuna ing'hambi na mbwanga Yoshua mwanage Nuni hasegele kuna dihema. ");
INSERT INTO kdc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa kamulongela Mndewa Imulungu, “Gweye kunilongela niwalongoze wanhu wano, lakini hunilongele nani yonda umtume yanitaze. Gweye kunongela, ‘Nokujuwa gweye kwa twaga jako na nokunogela.’ ");
INSERT INTO kdc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Sambi nokupula kamba koninogela, ndagusile nzila zako ili nikujuwe na nigendelele kunogeligwa na gweye. Vivija uwakumbuke wanhu wa isi yako.” ");
INSERT INTO kdc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mndewa Imulungu kalonga, “Niye nochola hamoja na gweye na nokugwaa tindiwalo.” ");
INSERT INTO kdc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa kedika, “Kamba gweye huchola na siye sikuutulave hanhu hano. ");
INSERT INTO kdc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Vino niye nojuwaze kamba nonogeligwa na gweye, niye na wanhu zako kamba huchola hamoja na siye? Wahachola na siye mbuli ayo yotutenda niye na wanhu zako tuwe wanhu tulieka mna iwanhu wose mwiisi yose.” ");
INSERT INTO kdc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mndewa Imulungu kamulongela Musa, “Notenda vivo kamba viulongile, kwavija nokunogela na nikujuwa kwa twaga jako.” ");
INSERT INTO kdc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Abaho Musa kalonga, “Sambi chonde ndagusile viwili.” ");
INSERT INTO kdc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mndewa Imulungu kamulongela Musa, “Nobita kuulongozi wako, kuno noditambula twaga jangu Mndewa Imulungu. Nomtendela ganogile munhu yoyose inimulonda na nomonela bazi munhu yoyose inimulonda. ");
INSERT INTO kdc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Lakini honda uchone kihanga changu, kwavija kuduhu munhu yoyose yodaha kuchona kihanga changu abaho yawe mgima.” ");
INSERT INTO kdc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Abaho Mndewa Imulungu kamulongela Musa, “Kuna hanhu behi yangu baho kodaha kwima uchanha ya dibwe dijo. ");
INSERT INTO kdc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kipindi vinibita, nokwika gweye mna imhango mdibwe na nogubika kwa mkono wangu mbaka vonda nibite. ");
INSERT INTO kdc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Abaho nousegesa mkono wangu kuchugu changu, na gweye konyona kumgongo, lakini honda uchone kihanga changu.” ");
INSERT INTO kdc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mndewa Imulungu kamulongela Musa, “Usongole vibao vibili va mabwe kamba vija va ichanduso na niye nokwandika mbuli zija zikalile mvibao vija va ichanduso, vija uvibenile. ");
INSERT INTO kdc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Uitande mayo imitondo, wize tuiting'hane uchanha kulugongo lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Sikuwize na munhu yoyose na sikuyoneke munhu yoyose kulugongo, wala ng'ombe na ng'hondolo sikuwadimiligwe behi ya ulugongo.” ");
INSERT INTO kdc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Avo Musa kasongola vibao vibili va mabwe kamba vija va ichanduso abaho imitondo ng'hani kakwela kulugongo lwa Sinai kamba viyalagizwe na Mndewa Imulungu, kuno mna gamakono gake kavikoga vibao avo vibili va mabwe. ");
INSERT INTO kdc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Abaho Mndewa kahumuluka mdiwingu mbaka hasi na kema hamoja na Musa, kaditambula twaga jake, Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Abaho Mndewa Imulungu kabita kuulongozi wa Musa kuno kolonga, “Niye na Mndewa Imulungu, Imulungu nimemile unogelwa na bazi, sigevuzika himahima nina moyo unogile na notamaniligwa. ");
INSERT INTO kdc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Notenda gaja ganongile kwa maelufu ga ulelo na nogela kumgongo gehile na nzambi, lakini sileka kuwakoboza wana na wazukulu mbaka ulelo wa kadatu na wa ikane kwa nzambi za iwahenga zao.” ");
INSERT INTO kdc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa kaidulika himahima na kamtambikila. ");
INSERT INTO kdc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Abaho kalonga, “Go Mndewa kamba koninogela, nokupula ugende na siye. Wanhu wano wana mizoyo midala, lakini nokupula ugele kumgongo gehile getu na nzambi zetu, tubokele kamba wanhu wako mwenyego.” ");
INSERT INTO kdc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Abaho Mndewa Imulungu kamulongela Musa, “Sambi notenda lagano na wanhu wa Izilaeli, notenda vilaguso havinalawilila mgameso ga wanhu wa mwiisi yose. Wanhu awo ozona sang'hano ng'hulu zonda nikutendele niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Gagogeni malagizo goniwalagiza lelo. Nowawinga Waamoli na Wakanaani na Wahiti na Wapelizi na Wahivi na Wayebusi. ");
INSERT INTO kdc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Loleni, sikumutende lagano na wanhu wa isi imugenda, kwavija mbuli ayo yokuwa mtego wa kuwanamata. ");
INSERT INTO kdc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Lakini molondigwa mubomole kila upango wao wa kulavila nhosa, na mugakindule mabwe gao gang'alile na muibene imhanda ya kumtambikila imulungu wao Ashela. ");
INSERT INTO kdc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Sikumumtambikile imulungu yoyose iyagwe kwavija niye Mndewa Imulungu twaga jangu diyagwe yeli na migongo, niye na Imulungu mwene migongo. ");
INSERT INTO kdc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Sikumutende lagano na wenekae wa isi ayo kwavija vonda wavitambikile ivinyago va imilungu yao na kuilavila nhosa, owagonekeni, na mweye monogeligwa kuja ndiya yao ilavigwe nhosa, ");
INSERT INTO kdc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","na wabwanga zenu wahasola wandele zao, na wandele awo owalongoza wabwanga zenu kuitambikila imilungu yao. ");
INSERT INTO kdc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Sikumutende na kuvitambikila vinyago va imilungu ya zuma. ");
INSERT INTO kdc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Muideng'helele nyimwilinyimwili ino ya magate hagageligwe hamila. Kwa siku saba muje magate hagageligwe hamila kwa kipindi chose kikigwe, muumwezi wa Abibu kamba viniwalagize, kwavija mwezi awo niwalava mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Wanenu wa chaudele okuwa wangu, hamoja na wana wa chaudele wa kimbigalo wa fugo zenu, ng'ombe na ng'hondolo. ");
INSERT INTO kdc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Lakini mwana chaudele wa kihongwe komgombola kwa kungalila ng'hondolo. Kamba humgombola bule umbote isingo. Wanenu wose wa chaudele wa kimbigalo muwagombole. “Munhu yoyose sikuyeze kuulongozi wangu makono gaiyeka. ");
INSERT INTO kdc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Sang'haneni kwa siku sita lakini siku ya saba mubwihile hata kamba chahawa kipindi cha kulima hebu kusenga. ");
INSERT INTO kdc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Tendeni nyimwilinyimwili ya vija vimusonga kusenga mmigunda yenu, na tendeni nyimwilinyimwili ya kulundiza indiya mna ikimambukizo cha mwaka. ");
INSERT INTO kdc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Miyanza midatu mna umwaka wambigalo wose waiting'hane kuulongozi wangu niye Mkulu Mndewa Imulungu, Imulungu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nowawinga wanhu wa isi ziyagwe mgameso genu, nozitenda zimbaka za isi yenu ziwe ng'hulu. Kuduhu munhu yoyose yonda yaisulukile isi yenu kipindi mwahaiting'hana kunitambikila niye Mndewa Imulungu wenu miyanza midatu kila mwaka. ");
INSERT INTO kdc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Sikumundavile nhosa hamoja na gate digeligwe hamila, sikumusigase kinhu chochose cha mnyama wa nyimwilinyimwili ya Pasaka mbaka imitondo. ");
INSERT INTO kdc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Nilavileni ndiya za ichanduso za imigunda yenu na muzigale mng'anda ya Mndewa Imulungu wenu. “Sikuuteleke nyama ya mwana mbuzi mna gamaziwa ga mamake.” ");
INSERT INTO kdc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Abaho Mndewa Imulungu kamulongela Musa, “Wandike mbuli zino, kwavija kubitila mbuli zino notenda lagano na gweye hamoja na Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa kakala kuko kulugongo hamoja na Mndewa Imulungu kwa siku malongo mane imisi na ikilo bila kuja kinhu chochose wala kung'wa mazi. Na kandika mvibao vivo mbuli zose za lagano na Malagizo Longo. ");
INSERT INTO kdc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa viyahumuluke hasi kulugongo lwa Sinai, kuno kapapa vija ivibao vibili va malagizo, kakala hajuwile kamba kihanga chake kikala chong'ala kwavija kakala kolonga na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haluni na Waizilaeli wose viwamonile Musa, wadumba kumkwesela behi kwavija kihanga chake kikala chong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Lakini Musa kamkema Haluni na vilongozi wose wamkwesele behi, abaho Musa kalonga na hewo. ");
INSERT INTO kdc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kipindi kidodo kumwande, Waizilaeli wose wamkwesela behi Musa, avo Musa kawagwaa malagizo gose gayagweleligwe na Mndewa Imulungu kulugongo lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa viyamambukize kulonga na hewo, kagubika kihanga chake kwa kikumbi. ");
INSERT INTO kdc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Lakini kila kipindi Musa viyacholile kulonga na Mndewa Imulungu kuna dihema da mting'hano, kakala kokivula kikumbi acho mbaka yahalawa kunze. Yahalawa kunze kowalongela Waizilaeli mbuli zose ziyalagizwe na Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","na wao wachona kihanga chake chong'ala. Avo Musa kagubika kihanga chake kwa kikumbi mbaka yahachola kulonga na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa kaiting'hana hamoja na wanhu wose wa Izilaeli abaho kawalongela, “Mndewa Imulungu kawalagiza musang'hane mbuli zino, ");
INSERT INTO kdc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","kwa siku sita musang'hane, lakini siku ya saba ni siku ing'alile ya kubwihila kwa Mndewa Imulungu. Munhu yoyose yonda yasang'hane mwiisiku ayo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sikumubwinhe moto mzikae zenu mwiisiku ayo ya kubwihila.” ");
INSERT INTO kdc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa kawalongela Waizilaeli, “Mbuli ino ayo iyailagize Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","mna ivinhu venu, mulavileni sadaka Mndewa Imulungu. Munhu yoyose yolonda, yamulavile Mndewa Imulungu sadaka za zahabu na shaba na shaba ya kiguzi, ");
INSERT INTO kdc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","sufi ya buluu na sufi ya zambalau na sufi ndung'hu na viwalo vinogile va kitani na viwalo vitendigwe kwa mibahila ya mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Mulavileni ng'hwembe za ng'hondolo mbigalo zigeligwe langi ndung'hu na ng'hwembe za mnyama wa mbahali na mibiki ya muhamvi na mkese, ");
INSERT INTO kdc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mavuta ga taa na vinhu vilondigwa mbuli ya mavuta ga kubakala na mbuli ya ubani unung'hila goya, ");
INSERT INTO kdc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mabwe ga bei ng'hulu gokemigwa shohamu na mabwe gayagwe mbuli ya kukihamba kikoti cha mulava nhosa na kikoba cha mmhambaga. ");
INSERT INTO kdc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Kila munhu hagati yenu yeli na nzewele ya kutenda kinhu chochose yasang'hane ivinhu viyalagize Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Watende hema ding'alile na ngubiko yake, vifungilo vake na vibao vake na mango zake na mhanda zake na vikalilo vake, ");
INSERT INTO kdc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sanduku da lagano na mango zake za kudipapila na ngubiko yake na panziya da hanhu hong'ala ng'hani, ");
INSERT INTO kdc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meza na mango zake za kuipapila na viya vake na magate galavigwe kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Watende kingolobweda cha taa na viya vake na taa zake na mavuta ga taa, ");
INSERT INTO kdc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","upango wa kusomela ubani na mango zake za kuupapila na mavuta gang'alile na ubani unung'hila goya na panziya da ulwivi lwa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Watende upango wa kulavila nhosa na lwavu lwake lwa shaba ya kiguzi na mango zake za kuupapila na viya vake vose na bakuli da shaba ya kiguzi na mgimbo wake. ");
INSERT INTO kdc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Watende mapanziya ga uluwa na mhanda zake na vikalilo vake na panziya da ulwivi lwa uluwa ");
INSERT INTO kdc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na vifungilo va nzabi va dihema na va uluwa na nzabi zake. ");
INSERT INTO kdc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Watende viwalo vilukigwe vinogile mbuli ya kusang'hanila hanhu hong'ala na viwalo va Haluni na wanage ili wasang'hane kamba walava nhosa.” ");
INSERT INTO kdc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Avo kibumbila chose cha Waizilaeli wasegela kuulongozi wa Musa, ");
INSERT INTO kdc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","kila munhu kasulukila mmoyo wake na kamulavila sadaka Mndewa Imulungu mbuli ya dihema da mting'hano na sang'hano zake zose, na viwalo vake ving'alile. ");
INSERT INTO kdc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Avo wanhu weli na moyo unogile watwanzi na wambigalo wagala heleni na pete na ushanga na kila kinhu cha kuihamba cha zahabu na wavinula uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kila munhu kagala chochose kiyelinacho, mwene sufi ya buluu hebu sufi ya zambalau hebu sufi ndung'hu hebu viwalo vitendigwe kwa mibahila ya mbuzi hebu ng'hwembe za ng'hondolo mbigalo zigeligwe langi ndung'hu hebu ng'hwembe za mnyama wa mbahali. ");
INSERT INTO kdc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kila munhu yadahile kugala sadaka za shaba na shaba ya kiguzi kamgalila Mndewa Imulungu, na kila munhu yeli na mbao za mkese kazigala. ");
INSERT INTO kdc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Watwanzi wose wadahile kusona wagala vinhu vao viwasonile kwa sufi ya langi ya buluu na ya zambalau na ndung'hu na kitani kilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Na watwanzi wose wadahile kusona viwalo waluka mibahila ya mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Vilongozi wagala mabwe ga shohamu na mabwe gayagwe mbuli ya kikoti na kikoba cha mmhambaga. ");
INSERT INTO kdc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Vivija wagala vinhu vinung'hila goya na mavuta ga taa na mavuta ga kubaka na ubani unung'hila goya. ");
INSERT INTO kdc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Waizilaeli wose wambigalo na watwanzi weli na moyo unogile wamulavila Mndewa Imulungu sadaka azo mbuli ya sang'hano ya Mndewa Imulungu kamba Musa viyawalagize watende. ");
INSERT INTO kdc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Abaho Musa kawalongela Waizilaeli, “Mndewa Imulungu kamsagula Bezaleli mwanage Uli mzukulu wa Huli kulawa kabila da Yuda, ");
INSERT INTO kdc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","kammemeza loho wake na kamgwaa nzewele na kujuwa vinhu va ufundi kwa kila sang'hano, ");
INSERT INTO kdc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ili yatende sang'hano inogile ya vinhu va zahabu na shaba na shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Yasongole mabwe ga kuhambila na mbao mbuli ya sang'hano zose za ufundi. ");
INSERT INTO kdc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Vivija kamgwaa heyo na Oholiabu mwanage Ahisamaki kulawa kabila da Dani, udahi wa kuwafunza wayagwe ufundi awo. ");
INSERT INTO kdc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kawagwelela udahi wa kutenda kila sang'hano ya ufundi itendigwa na wanhu osongola mabwe na oluka viwalo va sufi ya langi ya buluu na zambalau na ndung'hu na oluka kitani inogile, kwa ufundi wao wose. ");
INSERT INTO kdc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Avo Bezaleli na Oholiabu na kila mbigalo yagweleligwe udahi na Mndewa Imulungu wa kujuwa kusang'hana sang'hano ya kuzenga dihema, yatende sang'hano kamba Mndewa Imulungu viyalagize wasang'hane.” ");
INSERT INTO kdc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa kamkema Bezaleli na Oholiabu na kila munhu yagweleligwe ufundi wowose na Mndewa Imulungu na yalondile kusang'hana sang'hano na kawalongela wasonge isang'hano. ");
INSERT INTO kdc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Nao wabokela kulawa kwa Musa vinhu vose vilavigwe na Waizilaeli mbuli ya sang'hano ya dihema ding'alile. Wanhu wagendelela kulava sadaka zao kwa kulonda wenyego kila imitondo. ");
INSERT INTO kdc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Abaho wanhu wose weli na ufundi wakalile ozenga dihema da mting'hano wamcholela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","wamulongela, “Wanhu okugalila vinhu vingi ng'hani kubanza vinhu vilondigwa kwa sang'hano ilagizwe na Mndewa Imulungu tuisang'hane.” ");
INSERT INTO kdc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Abaho Musa kawalagiza wanhu waleke kugendelela kusanga vinhu mbuli ya dihema da mting'hano, avo wanhu hawagalile vinhu kabili. ");
INSERT INTO kdc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Kwavija vinhu vigaligwe vikala vingi ng'hani kubanza vilondeke kwa sang'hano. ");
INSERT INTO kdc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Wambigalo wose weli na ufundi wakuzenga dihema da mting'hano, wadizenga ajo dihema kwa mapanziya longo ga kitani ilukigwe vinogile na kwa sufi ya buluu na ya zambalau na ndung'hu na ulembo wa viumbe weli na mabawa. ");
INSERT INTO kdc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kila panziya dikala na utali wa makono longo na mabili na ugazi wa makono mabili. Mapanziya gose gaigala. ");
INSERT INTO kdc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Mapanziya matano wagasonela hamoja dilawila panziya dimoja na vivija gaja ga matano gayagwe. ");
INSERT INTO kdc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Abaho weka vitanzi va buluu mna imhindo ya panziya da ikimambukizo na watenda vivo kwa mhindo ya panziya diyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Vivija weka vitanzi malongo matano mna idipanziya dimoja na vitanzi malongo matano mdipanziya diyagwe, vitanzi vose viilola. ");
INSERT INTO kdc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Abaho watenda vifungilo va zahabu malongo matano, na walumbiliza vihande avo vibili va panziya na dihema diwa dimoja. ");
INSERT INTO kdc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Vivija watenda ngubiko ya dihema kwa mapanziya longo na dimoja ga mibahila ya mbuzi. ");
INSERT INTO kdc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kila panziya dikala na utali wa makono longo na ndatu na ugazi wa makono mabili. Mapanziya gose gaigala. ");
INSERT INTO kdc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Mapanziya matano wagalumbiliza hamoja na mapanziya sita wagalumbiliza hamoja. ");
INSERT INTO kdc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Abaho weka vitanzi malongo matano mna idipanziya dimoja na vitanzi malongo matano mdipanziya diyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Vivija watenda vifungilo va shaba ya kiguzi malongo matano na wavigela mvitanzi na wagalumbiliza gago gamapanziya na kutenda ngubiko imoja ya dihema. ");
INSERT INTO kdc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Watenda ngubiko iyagwe ya dihema kwa ng'hwembe za ng'hondolo mbigalo zigeligwe langi ndung'hu na ng'hwembe za mnyama wa mbahali. ");
INSERT INTO kdc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Abaho watenda mbao za mkese za kwimila dihema. ");
INSERT INTO kdc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kila lubao lukala na utali wa makono mane, na ugazi wa behi kuvikila mkono umoja, ");
INSERT INTO kdc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","kila lubao lukala na vilimi vibili va kulumbilizila. Mbao zose za dihema wazitenda vivo. ");
INSERT INTO kdc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Vivija watenda mbao malongo mabili za mwambu wa kusini wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na vikalilo malongo mane va shaba, kila lubao vikalilo vibili ili kugogeleza vija ivilimi vibili. ");
INSERT INTO kdc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Abaho watenda mbao malongo mabili za mwambu wa kasikazini wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vikalilo malongo mane va shaba, kila lubao vikalilo vibili. ");
INSERT INTO kdc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kwa mwambu kwa kukisogo wa dihema, mwambu wa kudihongela zuwa watenda mbao sita, ");
INSERT INTO kdc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","na watenda mbao mbili kuvingolobweda va mwambu wa kukisogo wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mbao azo mbili za kutenda avo ivingolobweda vibili wazilumbiliza kulawa hasi mbaka uchanha kuna ipete ya ichanduso. Mbao azo mbili za ivingolobweda avo vibili vivo wazitendile. ");
INSERT INTO kdc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Avo kukala na mbao nane na vikalilo longo na sita va shaba, kila lubao vikalilo vibili. ");
INSERT INTO kdc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Abaho watenda mango za muhamvi, mango tano mbuli ya mwambu umoja wa dihema, ");
INSERT INTO kdc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","na mango tano mbuli ya mwambu uyagwe na mango tano mbuli ya mwambu wa kudihongela zuwa, kukisogo mwa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Abaho mango ili hagati ya mbao za dihema waibalaza kulawa mwambu uno mbaka uyagwe wa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mbao zose wazibaka zahabu, na watenda vipete va zahabu va kugogeleza zimango. Vivija mango zose wazibaka zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Abaho watenda panziya da kitani inogile dilukigwe na sufi ya langi ya buluu na ya zambalau na udung'hu na wadigela ulembo wa viumbe weli na mabawa watendigwe na mafundi wanogile. ");
INSERT INTO kdc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Vivija watenda mhanda nne za muhamvi wazibaka zahabu na weka vifungilo va zahabu ili wadinanike dipanziya. Vivija watenda vikalilo vine va shaba va kukalila zimhanda. ");
INSERT INTO kdc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hana ulwingililo lwa dihema watenda panziya da kitani inogile dizamile dilukigwe na sufi ya langi ya buluu na ya zambalau na udung'hu na wadihamba kwa ulembo. ");
INSERT INTO kdc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Abaho watenda mhanda tano za muhamvi za dipanziya na wazibaka zahabu na weka vifungilo va zahabu na watenda vikalilo vitano va shaba ya kiguzi mbuli ya azo zimhanda. ");
INSERT INTO kdc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli katenda sanduku da lagano kwa mbao za mkese, utali wake ukala mkono umoja na nusu na ugazi wake ukala mkono umoja na utali wake kwa kuchola uchanha ukala mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kadibaka sanduku dijo zahabu inogile kunze na mgati, na kadizungulusila lugigo lwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Abaho kaditendela sanduku dijo vipete vine va zahabu na kavigela mmagulu gake mane, kila mgulu kipete kimoja. ");
INSERT INTO kdc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Vivija kasongola mango za muhamvi na kazibaka zahabu, ");
INSERT INTO kdc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","mango azo kazigela mna ivipete vili kila mwambu wa disanduku, ili dipapigwe. ");
INSERT INTO kdc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Abaho kasongola ngubiko aho hozigeligwa kumgongo nzambi, ngubiko ayo kaitenda kwa zahabu inogile, utali wake ukala mkono umoja na nusu na ugazi wake ukala mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Vivija kasongola viumbe vibili kwa zahabu, abaho kavika mumgwazo wa ingubiko, ");
INSERT INTO kdc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","imoja kamwika mwambu uno na iyagwe mwambu uyagwe kuno na kuno. Kavika viumbe avo mumgwazo wa ingubiko, lakini viilumba na ingubiko. ");
INSERT INTO kdc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Viumbe awo wailola na mabawa gao gayanzanza uchanha ya ingubiko. ");
INSERT INTO kdc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Vivija Bezaleli katenda meza ya mbao za mkese ikala na utali wa mkono umoja na ugazi wa nusu mkono na utali wa kuchola uchanha ukala behi na kuvika mkono umoja. ");
INSERT INTO kdc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kaibaka meza ayo zahabu inogile na kaizungulusila lugigo lwa zahabu, ");
INSERT INTO kdc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","abaho kaizungulusila lubao luli na ugazi wa ganza na kalubaka zahabu, ");
INSERT INTO kdc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","na kaitendela vipete vine va zahabu na kavigela mna gamagulu gake mane. ");
INSERT INTO kdc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Abaho vipete avo kagela behi na luja ulubao luyazunguluse mwiimeza ili kuipapila imeza. ");
INSERT INTO kdc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Vivija kasongola mango za muhamvi, na kazibaka zahabu, mango azo zikala za kupapila ayo imeza. ");
INSERT INTO kdc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Abaho katenda sahani na vikasi, vivija katenda bilika na vibakuli va kugidila nhosa ya ung'waji. Viya vose avo kavitenda kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Abaho katenda kingolobweda cha zahabu inogile, dako jake na mgimbo wake ukala umoja, vikasi vake na vifundo vake na maluwa gake vose kavitenda kwa kihande kimoja cha zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Matambi sita galawilila mumgimbo wa ikingolobweda, matambi madatu mwambu uno na madatu mwambu uyagwe. ");
INSERT INTO kdc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kila tambi dikala na vifundo vidatu kamba vigali maluwa ga mulozi kila dimoja na vifundo vake na luwa jake. ");
INSERT INTO kdc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na umgimbo wa ikingolobweda kauhamba na vifundo vine viigalile kamba viwili mulozi una vifundo na maluwa. ");
INSERT INTO kdc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Kila hanhu hogotela matambi mabili ili kuvikiza matambi sita ga ikingolobweda, hasi yake keka kifundo kimoja. ");
INSERT INTO kdc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Vifundo vivo na matambi gake vikala kinhu kimoja na ikingolobweda na vose kavitenda kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Katenda taa saba za ikingolobweda, vivija katenda viya va kugogela makala ga moto na viya va kuhalila moto kwa zahabu inogile. ");
INSERT INTO kdc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kasola kilo malongo madatu na tano za zahabu inogile katendela acho ikingolobweda na viya vake vose. ");
INSERT INTO kdc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Abaho Bezaleli katenda upango kwa mbao za mkese, mbuli ya kusomela ubani. Upango awo uigala, utali wake na ugazi wake ukala nusu mkono, na utali wake kuchola uchanha ukala mkono umoja. Mhembe zake zilawilila na zikala kinhu kimoja na awo uupango. ");
INSERT INTO kdc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kaubaka upango awo zahabu inogile. Mwambu wa uchanha, banzi zose za mulubavu na mzimhembe, vivija kauzungulusila lugigo lwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Abaho katenda vipete vibili va zahabu na kavigela hasi ya ulugigo mna zibanzi zake mbili ziilola. Vipete avo vigogeleza zimango kipindi cha kuupapa uupango. ");
INSERT INTO kdc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Vivija katenda mango za muhamvi na kazibaka zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Abaho katenda mavuta gang'alile ga kubaka na ubani unung'hila goya uhanganyigwe vinogile kamba munhu yotenda mavuta gonung'hila goya. ");
INSERT INTO kdc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Abaho katenda upango wa kulavila nhosa kwa mbao za mkese. Upango awo uigala kila mwambu, utali wake makono mabili na nusu na ugazi wake makono mabili na nusu na utali wake kuchola uchanha ukala mkono umoja na nusu. ");
INSERT INTO kdc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Vivija katenda mhembe nne mna zikona nne, na mhembe azo zikala kinhu kimoja na upango awo na kaubaka shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Viya vose va kulavila nhosa kavitenda kwa shaba ya kiguzi, zae da kwikila mitozi na lwiko lwa kuzolela mitozi na bakuli na lwiko lwa kuhindulila nhosa na viya va kuhalila moto. ");
INSERT INTO kdc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Abaho katenda lwavu lwa shaba ya kiguzi. Kalwika lwavu awo mumgwazo hasi ya upango wa kulavila nhosa, na uvikila nusu ya upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Vivija kalwikila vipete vine va shaba ya kiguzi mna zikona nne za ulwavu. ");
INSERT INTO kdc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Abaho katenda mango za muhamvi za kupapila awo uupango wa kulavila nhosa na kazibaka shaba ya kiguzi, ");
INSERT INTO kdc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","na kazigela azo zimango mvipete kila mwambu wa upango wa kulavila nhosa ili upapigwe na katenda upango awo kwa mbao na kawikila na uvungu. ");
INSERT INTO kdc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Abaho katenda bakuli da shaba ya kiguzi, na mgimbo wake ukala wa shaba ya kiguzi, bakuli dijo na mgimbo wake kavitenda kwa shaba ya vioo va watwanzi osang'hana hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Abaho katenda luwa lwa mting'hano. Mwambu wa kusini keka mapanziya gatendigwe kwa kitani inogile ilukigwe, mapanziya gago gakala na utali wa makono malongo mane na nne kwa mwambu umoja. ");
INSERT INTO kdc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Mapanziya gago gagogelezwa kwa mhanda za shaba ya kiguzi malongo mabili zili na vikalilo va shaba ya kiguzi. Ivifungilo va zimhanda na nzabi zake vikala va shaba. ");
INSERT INTO kdc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Vivija mwambu wa kasikazini, utali wa dipanziya ukala makono malongo mane na nne kwa mwambu umoja na mhanda malongo mabili na vikalilo va shaba ya kiguzi, lakini vifungilo va zimhanda na nzabi zake vikala va shaba. ");
INSERT INTO kdc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mwambu wa kudihongela zuwa dipanziya dikala na utali wa makono malongo mabili na mbili kwa mwambu umoja na mhanda longo zili na vifungilo na nzabi za shaba na vikalilo longo. ");
INSERT INTO kdc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Vivija mwambu wa kudilawila zuwa, mwambu wa kwingilila, katenda luwa luli na ugazi wa makono malongo mabili na mbili. ");
INSERT INTO kdc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Panziya da mwambu umoja wa umulango dikala na ugazi wa makono sita na nusu hamoja na mhanda ndatu na vikalilo vidatu. ");
INSERT INTO kdc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Vivija mwambu uyagwe wa umulango dipanziya dikala na ugazi wa makono sita na nusu hamoja na mhanda ndatu na vikalilo vidatu. ");
INSERT INTO kdc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mapanziya gose kuzunguluka uluwa gatendigwa kwa kitani inogile ilukigwe. ");
INSERT INTO kdc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Vikalilo vose va zimhanda vikala va shaba ya kiguzi na vifungilo vake na nzabi zake na uchanha ya zimhanda vose vitendigwa kwa shaba. Mhanda zose zigogelezwa kwa mango za shaba. ");
INSERT INTO kdc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hana umulango wa uluwa keka panziya ditendigwe kwa sufi ya langi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe na dihambigwe vinogile. Panziya dijo dikala na utali wa makono tisa na ugazi wa makono mabili kamba vigakalile gamapanziya gayagwe ga uluwa. ");
INSERT INTO kdc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Panziya dijo digogigwa na mhanda nne zili na vikalilo vine va shaba ya kiguzi. Uchanha ya zimhanda na vifungilo vake na nzabi zake vose kavitenda kwa shaba. ");
INSERT INTO kdc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vifungilo va nzabi za uluwa na dihema vose kavitenda kwa shaba ya kiguzi. ");
INSERT INTO kdc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Vino avo vinhu vitumike kuzengela dihema da mting'hano, mumo mudikalile disanduku da lagano. Vinhu avo vose vandikigwa na Walawi kwa kulagizwa na Musa na vikala mna uwimilizi wa Itamali mwanage imulava nhosa Haluni. ");
INSERT INTO kdc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleli mwanage Uli na mzukulu wa Huli kulawa kabila da Yuda, katenda kila kinhu Mndewa Imulungu kiyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Mtazaji wake Oholiabu mwanage Ahisamaki kulawa kabila da Dani, ayo yakalile yosongola gamabwe na kagela ulembo ivinhu, na katenda sufi ya langi ya buluu na ya zambalau na ndung'hu na kitani inogile ilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zahabu yose ilavigwe kwa kwinuligwa uchanha kwa Mndewa mbuli ya kuzengela dihema da mting'hano ikala na uzito wa kilo kamba elufu imoja kwa kipimo cha mdihema. ");
INSERT INTO kdc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Shaba iwasangile wanhu awo viwapetigwe ikala na uzito wa kilo kamba elufu ndatu na nusu kwa kipimo cha mdihema. ");
INSERT INTO kdc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kila munhu yapetigwe yakalile na miyaka malongo mabili na kugendelela kasanga gilamu tano za shaba kamba viyalondigwe, na wambigalo wose wapetigwe wakala laki sita na elufu ndatu na magana tano na hamsini. ");
INSERT INTO kdc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kilo azo kamba elufu ndatu na nusu zitumika kutenda vikalilo gana va dihema na uluwa, kila kikalilo kitendigwa kwa kilo kamba malongo madatu na tano. ");
INSERT INTO kdc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kilo kamba malongo madatu za shaba zisigale, wazitumia kilo azo kutenda vifungilo na zinzabi na wabaka uchanha ya zimhanda. ");
INSERT INTO kdc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Shaba ya kiguzi ilavigwe kwa kwinuligwa uchanha kwa Mndewa Imulungu ikala na uzito wa kilo kamba elufu mbili magana nne. ");
INSERT INTO kdc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bezaleli katumia shaba ayo ya kiguzi kutendela vikalilo va ulwivi lwa dihema da mting'hano na uupango wa kulavila nhosa na lwavu lwake na viya vose va upango awo, ");
INSERT INTO kdc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kwa shaba ayo ya kiguzi katenda vikalilo va uluwa na va ulwivi lwa uluwa na vifungilo va nzabi va dihema na uluwa. ");
INSERT INTO kdc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kwa kutumia sufi ya langi ya buluu na ya zambalau na ndung'hu watenda viwalo va kusang'hanila hanhu hong'ala. Vivija wamsonela Haluni viwalo ving'alile kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Watenda kikoti cha zahabu na kwa sufi ya langi ya buluu na ya zambalau na ndung'hu, na kitani inogile ilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nao waisoma izahabu na waikanha iwa kamba vizabi visisili ili wavigele hamoja na sufi ya langi ya buluu na ya zambalau na ndung'hu, na kitani inogile ilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kikoti acho kivaligwa kwa nzabi mmaega zisonigwe mna mzikona mbili za ikikoti. ");
INSERT INTO kdc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mkwiji wa kufungila wautenda kwa vinhu vivija va nzabi za zahabu na sufi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe na watenda kiwe kinhu kimoja na ikikoti, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Abaho wasola mabwe ga shohamu, wagakanda mna ivigigo va zahabu wagandika matwaga ga wana longo na wabili wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Abaho wageka mabwe gago mna zinzabi za kikoti zili mmaega kamba kinhu cha kukumbuka makabila longo na mbili ga Izilaeli, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Abaho watenda kikoba cha mmhambaga kwa vinhu vivija kamba ikikoti. Wakitenda kwa nzabi za zahabu na sufi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kikoba acho kibandigwa na kiigala kila mwambu, utali wake ukala lwayo lumoja na ugazi wake ukala lwayo lumoja. ");
INSERT INTO kdc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Wakihamba kwa misafa mine ya mabwe ga bei ng'hulu, msafa wa ichanduso wauhamba kwa mabwe ga akiki na topazi na alimasi ndung'hu, ");
INSERT INTO kdc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","msafa wa kabili wauhamba kwa mabwe ga zumalidi na johali ya langi ya samawati na alimasi, ");
INSERT INTO kdc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","msafa wa kadatu wauhamba kwa mabwe ga yasinto na akiki ndung'hu na ametisito, ");
INSERT INTO kdc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na msafa wa ikane wauhamba kwa mabwe ga zabalajadi na shohamu na yasipi. Mabwe gago gose wagakanda mvigigo va zahabu. ");
INSERT INTO kdc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Avo kukala na mabwe longo na mabili, kila dibwe jandikigwa twaga da wana wa Izilaeli, kila dibwe dikala kamba muhuli, kulagusa makabila longo na mabili. ");
INSERT INTO kdc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mbuli ya kikoba cha mmhambaga, watenda mikufu ya zahabu inogile na ilukigwe kamba nzabi. ");
INSERT INTO kdc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Abaho watenda vigigo vibili na pete mbili za zahabu na wazifunga mzikona mbili za ikikoba. ");
INSERT INTO kdc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mikufu ayo mibili ya zahabu waifunga mzipete zizo. ");
INSERT INTO kdc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mwambu umoja na mwambu uyagwe wa imikufu wazifunga mvigigo vibili va kija ikikoba ili vigogeleze ikikoti mmaega mwambu wa kuulongozi. ");
INSERT INTO kdc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Abaho watenda pete mbili za zahabu na wazifunga kwa hasi mna zikona mbili za hasi ya ikikoba behi na kikoti. ");
INSERT INTO kdc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Abaho watenda pete mbili ziyagwe za zahabu wazika mumgwazo wa ikikoti mwambu wa hasi, hanhu aho ikikoti hokiilumba na umkwiji ulukigwe goya. ");
INSERT INTO kdc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kikoba cha mmhambaga wakifunga mkikoti kwa nzabi ya buluu, ili acho ikikoba cha mmhambaga kigoge goya na kikale mumkwiji ulukigwe goya, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Abaho watenda kanzu ya kuvalila kikoti acho kwa sufi ya buluu. ");
INSERT INTO kdc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kanzu ajo dikala na zonzo da kwingila pala. Zonzo ajo dizunguluswa lugigo lulukigwe goya ili sikudidegeke. ");
INSERT INTO kdc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mwiimhindo ya hasi waluka kinhu kamba tonga kwa sufi ya buluu na ya zambalau na udung'hu na kitani inogile ilukigwe. ");
INSERT INTO kdc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Abaho watenda nyangili za zahabu inogile na wazika mna imhindo ya dikanzu hagati ya tonga kuzunguluka kanzu jose. ");
INSERT INTO kdc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Weka tonga abaho nyangili, tonga abaho nyangili kuzunguluka kanzu jose mbuli ya kulavila nhosa, kamba Mndewa Imulungu viyalagize. ");
INSERT INTO kdc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Abaho wawatendela Haluni na wanage makanzu ga kitani inogile ilukigwe goya, ");
INSERT INTO kdc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","na watenda kilemba na kofia na kaputula kwa kitani inogile ilukigwe goya, ");
INSERT INTO kdc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na mikwiji ya kitani inogile ilukigwe na sufi ya langi ya buluu na ya zambalau na ndung'hu na ihambigwa goya kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Abaho watenda lung'andi lwa zahabu inogile na wandika mbuli zino kamba munhu yotenda muhuli, “Kilavigwa kwa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Abaho walufunga lung'andi awo mkilemba kwa luzabi lwa buluu, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Avo sang'hano yose ya dihema da mting'hano imambukizwa. Waizilaeli wasang'hana gose kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Wamgalila Musa dihema da mting'hano hamoja na viya vake vose na vifungilo vake na mbao zake na mango zake na mhanda zake na vikalilo vake, ");
INSERT INTO kdc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ngubiko ya ng'hwembe za ng'hondolo mbigalo igeligwe langi ndung'hu na ng'hwembe za mnyama wa mbahali na panziya da hanhu hong'ala, ");
INSERT INTO kdc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sanduku da lagano na mango zake za kudipapila na ngubiko yake. ");
INSERT INTO kdc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Wamgalila imeza na mango zake za kuipapila na viya vake na magate galavigwe kwa Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ikingolobweda cha zahabu inogile na taa zake na viya vake vose hamoja na mavuta ga taa, ");
INSERT INTO kdc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","upango wa kusomela ubani na mavuta ga kubaka na ubani unung'hila goya na panziya da ulwivi lwa dihema. ");
INSERT INTO kdc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Wamgalila upango wa kulavila nhosa na lwavu lwake lwa shaba ya kiguzi na mango zake za kuupapila na viya vake vose na bakuli da shaba ya kiguzi na mgimbo wake, ");
INSERT INTO kdc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","mapanziya ga uluwa na mhanda zake na vikalilo vake na panziya da ulwivi lwa uluwa na nzabi zake na vifungilo va dihema na viya vose va kutumia mdihema. ");
INSERT INTO kdc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Wamgalila viwalo vilukigwe vinogile mbuli ya kusang'hanila hanhu hong'ala na viwalo va Haluni na wanage ili wasang'hane kamba walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Waizilaeli watenda kila kinhu kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa kakagula kila kinhu, kavona vinoga kamba watenda kila kinhu kamba Mndewa Imulungu viyamulagize. Avo Musa kawatambikila. ");
INSERT INTO kdc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Mna isiku ya ichanduso ya mwezi wa ichanduso udinule dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Mgati mdihema ajo wike dija disanduku da lagano dili na malagizo longo, abaho wike panziya kuulongozi wake. ");
INSERT INTO kdc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Abaho wingize imeza na wike viya vake uchanha yake. Vivija wingize kija ikingolobweda na uzike zitaa uchanha yake. ");
INSERT INTO kdc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Wike uupango wa zahabu wa kusomela ubani kuulongozi wa disanduku da lagano, abaho unanike dipanziya hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Wike uupango wa kulavila nhosa kuulongozi wa ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Wike dibakuli da shaba ya kiguzi hagati ya dihema da mting'hano na uupango wa kulavila nhosa na udimemeze mazi. ");
INSERT INTO kdc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Abaho uzungulusile luwa na wike panziya hana ulwivi lwake. ");
INSERT INTO kdc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Abaho udilave kumwangu dihema hamoja na viya vake vose kwa kuvigidila gamavuta gang'alile, na hema na viya vake vong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Abaho uulave kumwangu uupango wa kulavila nhosa hamoja na viya vake vose kwa kuvigidila gamavuta gang'alile na vose vong'ala. ");
INSERT INTO kdc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Vivija dibakuli da shaba ya kiguzi na mgimbo wake navo uvitendele kamba vivo. ");
INSERT INTO kdc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Abaho umgale Haluni na wanage hana ulwivi lwa idihema da mting'hano, na uwakoshe kwa mazi ");
INSERT INTO kdc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Abaho umvaze Haluni iviwalo ving'alile, umgidile mavuta gang'alile na umulave kumwangu, ili yanisang'hanile kamba mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Wagale wanage na uwavaze gaja gamakanzu. ");
INSERT INTO kdc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Abaho uwagidile mavuta kamba viumgidile tatao, ili na hewo vivija wanisang'hanile kamba walava nhosa. Wahawagidila mavuta hewo na ulelo wao okuwa walava nhosa siku zose.” ");
INSERT INTO kdc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa katenda kila kinhu kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Avo mna isiku ya ichanduso ya mwezi wa ichanduso mna umwaka wa kabili toka walawe Misili, dihema da mting'hano dinuligwa. ");
INSERT INTO kdc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa viyadinule dihema keka vikalilo vake, kazinula zimbao, na keka zimango na kazisimika mhanda zake. ");
INSERT INTO kdc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Abaho katandika ingubiko ya dihema na keka ingubiko iyagwe uchanha yake, kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Abaho kasola vija ivibao vibili va mabwe kavigela mdisanduku da lagano. Kazigela zimango za kudipapila mvipete vake na keka ingubiko uchanha yake. ");
INSERT INTO kdc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Abaho kadika disanduku mgati ya dihema na kananika dipanziya. Kwa kutenda vivo kadigubika disanduku da lagano sikujoneke, kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Abaho Musa keka imeza mgati ya dihema da mting'hano, mwambu wa kasikazini kuulongozi wa dipanziya, ");
INSERT INTO kdc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","uchanha ya imeza keka gamagate galavigwe kwa Mndewa, kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Keka ikingolobweda mgati ya dihema da mting'hano mwambu wa kusini mwambu kwa mwambu na imeza. ");
INSERT INTO kdc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Mumo mgati kuulongozi wa Mndewa Imulungu kazibwinha zitaa kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Abaho Musa keka uja uupango wa zahabu wa kusomela ubani mgati ya dihema da mting'hano, kuulongozi wa dipanziya, ");
INSERT INTO kdc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na kausoma ubani unung'hila goya uchanha yake kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kananika panziya hana ulwivi lwa dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","keka aho behi ya ulwivi lwa dihema da mting'hano upango wa kulavila nhosa, uchanha yake keka nhosa ya kusoma moto na nhosa ya ndiya kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Abaho keka dibakuli da shaba ya kiguzi hagati ya dihema da mting'hano na uupango wa kulavila nhosa, na kadimemeza mazi. ");
INSERT INTO kdc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa na Haluni na wanage wose wasunha makono gao na magulu gao kulawa mdibakuli dijo, ");
INSERT INTO kdc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","kila viwengile mgati ya dihema da mting'hano hebu viwaukwesele uja uupango wa kulavila nhosa, watenda vivo kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kukimambukizo Musa keka uluwa kuzunguluka dihema da mting'hano na uupango wa kulavila nhosa, na kananika panziya hana ulwivi lwa uluwa. Avo Musa kaimambukiza sang'hano yose. ");
INSERT INTO kdc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Abaho wingu digubika dihema da mting'hano na ukulu wa Mndewa Imulungu umema mdihema jose. ");
INSERT INTO kdc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa hadahile kwingila mna dihema da mting'hano kwavija wingu dijo dikala dimile uchanha yake, na ukulu wa Mndewa Imulungu ukala umemile mdihema ajo. ");
INSERT INTO kdc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Waizilaeli hawacholile mwanza wowose mbaka tanhu wingu dijo vidisegesigwe uchanha ya dihema. ");
INSERT INTO kdc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kamba wingu hadisegesigwe hawacholile kokose, wabeta mbaka wingu dijo vidisegesigwe. ");
INSERT INTO kdc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mna imiyanza yao yose Waizilaeli wajona diwingu da Mndewa Imulungu dikala uchanha ya dihema da mting'hano imisi, na ikilo wona moto okwaka mdiwingu uchanha ya dihema.");
INSERT INTO kdc_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Abaho Mndewa Imulungu kamkema Musa na kalonga na heyo hana dihema da mting'hano. Kamulongela, ");
INSERT INTO kdc_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Walongele Waizilaeli mbuli zino, ‘Kamba munhu komulavila Mndewa Imulungu nhosa ya mnyama, mnyama ayo yamulave mna ikibumbila chake cha fugo ya ng'ombe hebu ng'hondolo hebu mbuzi. ");
INSERT INTO kdc_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Kamba munhu kolava bofu da ng'ombe mbigalo kamba nhosa ya kusomigwa moto kulawa mdibumbila da fugo yake, yasagule mnyama yelibule kilema chochose. Yamgale hana ulwivi lwa dihema da mting'hano ili munhu ayo yatogoligwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Munhu ayo yeke mkono wake mdipala da ng'ombe ayo yolavigwa nhosa, avo nhosa ayo yotogoligwa kamba nhosa ya kulohola nzambi zake. ");
INSERT INTO kdc_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Munhu ayo yamchinje ng'ombe ayo kuulongozi wa Mndewa Imulungu, abaho iwalava nhosa weli ulelo wa Haluni wasole idamu na kuimiza banzi zose za uupango wa kulavila nhosa ako kuulwivi lwa dihema. ");
INSERT INTO kdc_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Abaho munhu ayo yamchune ayo ing'ombe na yamkanhe vihande vihande. ");
INSERT INTO kdc_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Abaho awo iwalava nhosa weli ulelo wa Haluni weke ngodi muupango wa kulavila nhosa na wabwinhe moto. ");
INSERT INTO kdc_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Abaho awo iwalava nhosa wasole ivihande va inyama hamoja na dipala na mavuta gake, wavike uchanha ya umoto muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Munhu ayo yasunhe kwa mazi ivinhu va mgati va ing'ombe na imigong'ho, na mulava nhosa yamsome kwa moto ing'ombe wose muupango wa kulavila nhosa. Nhosa ayo ya kusoma moto yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Kamba munhu kolava ng'hondolo hebu mbuzi kamba nhosa ya kusoma moto, mnyama ayo yalawe mkibumbila cha fugo yake na yawe mnyama wa kimbigalo yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Munhu ayo yamchinjile mnyama ayo ubanzi wa kasikazini wa upango wa kulavila nhosa uli kuulongozi wa Mndewa Imulungu. Abaho awo iwalava nhosa weli ulelo wa Haluni wamize idamu banzi zose za uupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Abaho munhu ayo yamkanhe mnyama ayo vihande vihande, na mulava nhosa yavike muumoto ivihande na dipala na gamavuta mna uupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Munhu ayo yasunhe kwa mazi ivinhu va mgati va imnyama na imigong'ho, na mulava nhosa yamsome kwa moto imnyama wose muupango wa kulavila nhosa. Nhosa ayo ya kusoma moto yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Kamba munhu kolava ndege kamba nhosa ya kusoma moto, avo ndege ayo yawe huwa hebu kinda da njiwa. ");
INSERT INTO kdc_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mulava nhosa yamgale ayo indege muupango wa kulavila nhosa, na yambote isingo na idamu ivuzile mwambu umoja wa upango wa kulavila nhosa na yadisome moto dipala muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Abaho yadilave tundu melo na uchafu wose yavasile mwambu wa kudilawila zuwa wa upango wa kulavila nhosa, ako kujasilagwa iditozi. ");
INSERT INTO kdc_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Abaho yamgoge gamabawa na yambalule mna imhambaga, abaho yamsome kwa moto uli muupango wa kulavila nhosa. Nhosa ayo ya kusoma moto yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Munhu yogala ndiya kwa Mndewa Imulungu kamba nhosa, tanhu yaiduge iwe usage, yaugele mavuta ga mizeituni na ubani. ");
INSERT INTO kdc_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Abaho yawagalile iwalava nhosa weli ulelo wa Haluni, imoja wao yadehe ganza dimoja da usage awo uli na mavuta hamoja na ubani, vose yavisome moto muupango wa kulavila nhosa, kamba kinhu cha kukumbuka kamba ndiya ayo yose ilavigwa kwa Mndewa Imulungu, nhosa ayo ya kusoma moto yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Usage usigale wa nhosa ayo okuwa wa walava nhosa, nhosa ayo ing'ala ng'hani kwavija ilavigwa kwa Mndewa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Kamba munhu komgalila Mndewa Imulungu gate jokigwe kamba nhosa, gate dijo ditendigwe kwa usage ulibule midundulu na utibwilizigwe na mavuta na sikuugeligwe hamila, hebu vigate visisili vitendigwe bila kugeligwa hamila na vibakigwe mavuta. ");
INSERT INTO kdc_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“ ‘Kamba munhu kogala gate jokigwe mkikalango kamba nhosa, gate dijo ditendigwe kwa usage ulibule midundulu na utibwilizigwe na mavuta, lakini sikuugeligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Magate gago gabenigwe benigwe na gagidiligwe mavuta, ayo iyo nhosa ya ndiya. ");
INSERT INTO kdc_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“ ‘Kamba kogala magate gatelekigwe mwiinongo kamba nhosa, magate gago gawe ga usage ulibule midundulu na ugeligwe mavuta. ");
INSERT INTO kdc_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Gala ndiya itendigwe kwa vinhu avo kuulongozi wa Mndewa Imulungu kamba nhosa, wagalile walava nhosa na hewo ozigala muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mulava nhosa kosola hanhu ha ndiya ayo kamba kinhu cha kukumbuka kamba ndiya ayo yose ilavigwa kwa Mndewa Imulungu na koisoma muupango wa nhosa. Ndiya ayo yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Usage usigale wa nhosa ayo okuwa wa walava nhosa, nhosa ayo ing'ala ng'hani kwavija ilavigwa kwa Mndewa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Ndiya yoyose imumgalila Mndewa Imulungu kamba nhosa sikuigeligwe hamila, kwavija havilondigwa kusoma hamila hebu uki mwiinhosa ilavigwa kwa Mndewa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kodaha kumgalila Mndewa Imulungu ndiya ya ichanduso yuusengile, lakini sikuilavigwe muupango wa kulavila nhosa kamba nhosa imnung'hila goya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ugele mkele mzinhosa zako zose za ndiya, kwavija mkele olagusa lagano diyatendile Imulungu na mweye. Ugele mkele mzinhosa zako zose. ");
INSERT INTO kdc_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Kamba komgalila Mndewa Imulungu nhosa ya ndiya ya ichanduso yuusengile, ugale kuno ikanzingigwa, hebu idugigwe. ");
INSERT INTO kdc_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Gela mavuta na ubani, ayo iyo nhosa ya ndiya. ");
INSERT INTO kdc_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mulava nhosa kosoma hanhu ha ndiya ayo idugigwe na gamavuta hamoja na ubani wose, kamba kinhu cha kukumbuka kamba ndiya ayo yose ilavigwa kwa Mndewa Imulungu. Ndiya ayo ilavigwa kwa Mndewa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Kamba munhu kogala nhosa ya kugala kuilumba, na heyo kolava ng'ombe kulawa mkibumbila chake, ng'ombe ayo yawe mtwanzi hebu mbigalo. Yamgale kuulongozi wa Mndewa Imulungu mnyama yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Munhu ayo yeke mkono wake mdipala da mnyama ayo na yamchinje hana ulwivi lwa dihema da mting'hano. Abaho awo iwalava nhosa weli ulelo wa Haluni waimizile idamu banzi zose za upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Mavuta gose geli muusapi wa mnyama ayo galavigwe nhosa ya kugala kuilumba na gasomigwe moto kamba nhosa ilavagwa kwa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Vivija yalave zifigo mbili na mavuta gake na mavuta gose gagogeleze zifigo na hanhu hanogile ha maini. ");
INSERT INTO kdc_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Iwalava nhosa weli ulelo wa Haluni wavisome moto hamoja na nhosa ili mzingodi zikwaka muupango, nhosa ayo ya kusoma moto yolava mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Kamba nhosa ayo ya kugala kuilumba yuumgalila Mndewa Imulungu yolawa mkibumbila cha fugo yako ya ng'hondolo hebu mbuzi, avo yasaguligwe mnyama wa kimbigalo hebu wa kitwanzi yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kamba munhu kogala nhosa ya bofu da ng'hondolo, kolondigwa yadilave kuulongozi wa Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","na yeke mkono wake mdipala da ng'hondolo ayo na yamchinje kuulongozi wa dihema da mting'hano. Abaho iwalava nhosa weli ulelo wa Haluni waimizile idamu banzi zose za upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Avo mwiinhosa ayo ilavigwa kwa Mndewa Imulungu kwa moto, yalave vinhu vino kulawa kwa ng'hondolo ayo, mavuta gake, mkila uli na mavuta ukanhigwe behi na mgongo sango, mavuta gose gagubike usapi na gaja geli muusapi, ");
INSERT INTO kdc_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","vivija yalave zifigo mbili na mavuta gake na mavuta gose gagogeleze zifigo na hanhu hanogile ha maini. ");
INSERT INTO kdc_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Mulava nhosa yavisome moto vinhu avo vose muupango wa kulavila nhosa kamba nhosa ilavagwa kwa Mndewa Imulungu kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Kamba nhosa yake ni mbuzi, yamgale kuulongozi wa Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","yeke mkono wake mdipala da mbuzi ayo na yamchinjile kuulongozi wa dihema da mting'hano. Abaho iwalava nhosa weli ulelo wa Haluni waimizile idamu banzi zose za upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mna inhosa ilavigwa kwa Mndewa Imulungu kwa moto, yalave mavuta gose geli muusapi wa mbuzi ayo, ");
INSERT INTO kdc_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","vivija yalave zifigo mbili na mavuta gake na mavuta gose gagogeleze zifigo na hanhu hanogile ha maini. ");
INSERT INTO kdc_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Mulava nhosa yavisome moto vinhu avo vose muupango wa kulavila nhosa kamba nhosa ilavagwa kwa moto, nhosa ayo yolava mnung'ho umnogeza Mndewa Imulungu. Mavuta gose ga imnyama mwenyego Mndewa. ");
INSERT INTO kdc_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Digogeni lagizo dino siku zose, mweye na ulelo wenu, kokose konda mukale sikumuje mavuta hebu damu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Walongele Waizilaeli mbuli zino, ‘Kamba munhu katenda nzambi bila kulonda, na katenda kinhu kigomesigwe mna gamalagizo ga Mndewa Imulungu yatende vino, ");
INSERT INTO kdc_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Kamba yatendile nzambi ayo mulava nhosa yagidiligwe mavuta na kagala gehile kwa wanhu, avo yamgalile Mndewa Imulungu bofu bigalo da ng'ombe dilibule kilema chochose, yadilave nhosa ya kusegesa nzambi zake ziyatendile. ");
INSERT INTO kdc_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Yadigale bofu dijo hana ulwivi lwa dihema da mting'hano kuulongozi wa Mndewa Imulungu. Yeke mkono wake mdipala da dibofu na yadichinjile aho kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Abaho ayo imulava nhosa yagidiligwe gamavuta yasole damu kidogo ya dibofu na yaigale mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Yazabike kidole chake mwiidamu ayo na yaimize miyanza saba kuulongozi wa Mndewa Imulungu mwambu wa kuulongozi wa panziya da gati ding'alile ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Abaho ayo imulava nhosa yeke damu kidogo mzimhembe zili muupango wa kusomela ubani uli kuulongozi wa Mndewa Imulungu mdihema da mting'hano. Damu isigale yaigide hasi mdidako da upango wa kulavila nhosa za kusoma moto uli behi ya ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Mavuta gose geli mna ing'ombe wa nhosa ya kusegesa nzambi yagalave, yagalave mavuta gose geli muusapi, ");
INSERT INTO kdc_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","vivija yalave zifigo mbili na mavuta gake na mavuta gose gagogeleze zifigo na hanhu hanogile ha maini. ");
INSERT INTO kdc_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Mulava nhosa yavisole vinhu avo vose na yavisome muupango wa kusomela nhosa kamba viyatendile kwa mavuta ga imnyama yalavigwe nhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Lakini ng'hwembe ya ayo ing'ombe na inyama na pala na migong'ho na usapi na mavi gake, ");
INSERT INTO kdc_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","na ing'ombe wose yasigale yamgale kunze ya ing'hambi hanhu habaguligwe kuko kujasilagwa ditozi, na yamsome moto uchanha ya ditozi. ");
INSERT INTO kdc_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Kamba wanhu wose wa Izilaeli watenda nzambi bila kulonda na wabena lagizo da Mndewa Imulungu, hata kamba hawajuwile bule kamba watenda nzambi yoyose, wose okuwa wabananga. ");
INSERT INTO kdc_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Baho wahajuwa nzambi waitendile, wanhu wose wagale bofu bigalo da ng'ombe kamba nhosa ya kusegesa nzambi. Wadigale bofu dijo mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Wavele wa wanhu wa Izilaeli weke makono gao mdipala da dibofu kuulongozi wa Mndewa Imulungu, na bofu dijo dichinjigwe aho kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Abaho mulava nhosa yagidiligwe gamavuta yasole idamu kidogo ya dibofu na yaigale mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Yazabike kidole chake mwiidamu na yaimize miyanza saba kuulongozi wa Mndewa Imulungu kuulongozi wa panziya da gati ding'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Abaho yeke damu iyagwe mzimhembe zili muupango wa kusomela ubani uli kuulongozi wa Mndewa Imulungu mdihema da mting'hano. Damu isigale yaigide hasi mdidako da upango wa kulavila nhosa za kusoma moto uli behi ya ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Abaho yagasole mavuta gose ga mnyama ayo na yagasome moto muupango wa kulavila nhosa, ");
INSERT INTO kdc_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","yatende kamba viyatendile kwa dija dibofu da ng'ombe wa nhosa ya kusegesa nzambi. Avo mulava nhosa kowatendela loholo mbuli ya nzambi zao, na nzambi zao zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Abaho yadisole dibofu na yadigale kunze ya ing'hambi na yadisome moto kamba viyatendile kwa ija wa ichanduso. Ino ayo nhosa ya kusegesa nzambi za wanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Kamba kilongozi wa wanhu wa Izilaeli katenda nzambi bila kulonda na katenda kinhu kigomesigwe mna gamalagizo ga Mndewa Imulungu, kilongozi ayo kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Baho yahaijuwa nzambi yake iyatendile, yagale nhosa ya mbuzi wa kimbigalo yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Yeke mkono wake mdipala da imbuzi na yamchinjile hanhu hoochinjila nhosa za kusoma moto kuulongozi wa Mndewa Imulungu. Ino ayo nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Abaho mulava nhosa yazabike kidole chake mwiidamu ya nhosa ya kusegesa nzambi na yaike mzimhembe zili muupango wa nhosa za kusoma moto. Damu isigale yaigide hasi ya dako da upango awo. ");
INSERT INTO kdc_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mavuta gose ga imbuzi ayo yagasome muupango wa kulavila nhosa kamba viyagasomile mavuta ga nhosa ya kugala kuilumba. Avo mulava nhosa komtendela loholo kilongozi ayo, na nzambi zake zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Kamba munhu yoyose mna iwanhu wa Izilaeli katenda nzambi bila kulonda, na katenda kinhu kigomesigwe mna gamalagizo ga Mndewa Imulungu, munhu ayo kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Baho yahaijuwa nzambi iyatendile, yagale mbuzi mtwanzi yelibule kilema chochose kamba nhosa ya kusegesa nzambi iyatendile. ");
INSERT INTO kdc_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Yeke mkono wake mdipala da ayo imbuzi na yamchinjile hanhu hoochinjila nhosa za kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Abaho mulava nhosa yazabike kidole chake mwiidamu ya mbuzi ayo na yaike mzimhembe zili muupango wa nhosa za kusoma moto na damu isigale yaigide hasi ya dako da upango awo. ");
INSERT INTO kdc_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mavuta gose yagalave, kamba viyatendile kwa mavuta ga nhosa ya kugala kuilumba, na mulava nhosa yagasome moto muupango wa kulavila nhosa kamba mnung'ho umnogeza Mndewa Imulungu. Avo mulava nhosa kotenda loholo da nzambi za munhu ayo, na nzambi za munhu ayo zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Kamba munhu kogala bofu da ng'hondolo diwe nhosa ya kusegesa nzambi zake, yagale bofu da kitwanzi dilibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Yeke mkono wake mdipala da idibofu da ng'hondolo da kusegesa nzambi na yadichinjile hanhu hoochinjila nhosa za kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Abaho mulava nhosa yazabike kidole chake mwiidamu ya inhosa ya kusegesa nzambi na yaike mzimhembe zili muupango wa nhosa za kusoma moto na damu isigale yaigide hasi ya dako da upango awo. ");
INSERT INTO kdc_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Abaho yagalave mavuta gose kamba viyatendile kwa mavuta ga dibofu da ng'hondolo wa nhosa ya kugala kuilumba, na mulava nhosa yagasome moto uchanha ya upango wa nhosa, uchanha wa zinhosa zilavigwe kwa Mndewa Imulungu kwa moto. Avo mulava nhosa kotenda loholo da nzambi za munhu ayo na nzambi zake zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Kamba munhu yahalondigwa kulava usindila mkitala mbuli ya kija kiyaone hebu kuhulika na heyo kolema kulonga chochose, avo kokuwa kabananga na kolondigwa yagae mbuli ya nzambi ayo. ");
INSERT INTO kdc_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kamba munhu yoyose hagati yenu yahaifitiza kwa kukwasa kinhu kihile bila kulonda mwenyego, uwe mtufi wa mnyama wa kumuhulo hebu mnyama wa kufugigwa hebu mng'onyo, munhu ayo kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Kamba munhu yahakwasa kinhu chochose kifitile cha mulukuli lwa munhu bila kulonda mwenyego, avo vonda yajuwe kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Kamba munhu yahaiduwila kutenda kinhu chochose kinogile hebu kihile bila kugelegeza, avo vonda yajuwe kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Munhu yoyose yahabananga mbuli, yatogole na yaitambule nzambi ayo, ");
INSERT INTO kdc_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na yalihe deni da nzambi yake iyatendile, yamgalile Mndewa Imulungu ng'hondolo wa kitwanzi hebu yagale mbuzi kulawa mdibumbila jake kamba nhosa ya kusegesa nzambi, na mulava nhosa yamtendele loholo. ");
INSERT INTO kdc_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Lakini kamba yahalemelwa kugala ng'hondolo, yamgalile Mndewa Imulungu huwa wabili hebu makinda mabili ga njiwa, mbuli ya nzambi yake iyaitendile. Imoja kokuwa nhosa ya kusegesa nzambi na iyagwe kokuwa nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Munhu ayo yawagale kwa mulava nhosa, na heyo mulava nhosa yasonge kulava inhosa ya kusegesa nzambi kwa kumbota isingo bila kudumula dipala. ");
INSERT INTO kdc_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yasole damu kidogo yaimizile kumgwazo wa upango wa nhosa, damu isigale yaigide hasi ya dako da uupango wa nhosa. Ino ayo nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Abaho ayo imulava nhosa yalave inhosa iyagwe kamba nhosa ya kusoma moto kamba viyalagizwe. Mulava nhosa kolohola nzambi za munhu ayo, na nzambi zake zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Kamba munhu kolemelwa kugala huwa wabili hebu makinda mabili ga njiwa, yagale vibaba vibili va usage unogile kamba nhosa ya kusegesa nzambi zake. Lakini sikuyaugele mavuta hebu ubani kwavija nhosa ayo ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Yaugale kwa mulava nhosa, na heyo yadehe ganza dimoja da usage awo na yausome muumoto uli muupango wa nhosa, kamba kinhu cha kukumbuka kamba usage awo wose ulavigwa kwa Mndewa Imulungu, hamoja na nhosa ziyomulavila Mndewa Imulungu kwa moto. Ino ayo nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Baho mulava nhosa kolohola nzambi za munhu ayo, na nzambi zake zogeligwa kumgongo. Usage usigale okuwa wa mulava nhosa kamba viikalile kwa indiya ilavigwe kamba nhosa.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kamba munhu katenda nzambi bila kulonda kwa kuleka kugala vinhu ving'alile vigalagwa kwa Mndewa Imulungu, avo yagale ng'hondolo wa kimbigalo yelibule kilema chochose kulawa mdibumbila jake. Avo bei ya ng'hondolo ayo igelegezwe kamba viwapimaga hanhu hong'ala. Ino ayo nhosa ya kulihila deni. ");
INSERT INTO kdc_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Abaho munhu ayo yalihe unanzi wose utendigwe kwa vinhu ving'alile na yengeze asilimia malongo mabili. Yamgwee mulava nhosa, na heyo mulava nhosa yalohole nzambi za munhu ayo kwa ng'hondolo mbigalo wa nhosa ya kusegesa nzambi na nzambi zake zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Munhu yoyose yahatenda nzambi bila kulonda kwa kubena lagizo da Mndewa Imulungu, hata kamba hajuwile, munhu ayo kokuwa kabananga na kolondigwa yalihe. ");
INSERT INTO kdc_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yamgalile mulava nhosa ng'hondolo mbigalo yelibule kilema chochose kulawa mdibumbila jake, ng'hondolo ayo yawe na bei kamba viyolondigwa kuliha. Na heyo imulava nhosa kolohola nzambi za munhu ayo, na nzambi yake yogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ino ayo nhosa ya kulihila deni kwa nzambi ziyamtendele Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Munhu yoyose yahamtendela nzambi Mndewa Imulungu kwa kumvizila miyage mbuli ya kinhu kiyagweleligwe yeke hebu yakike goya na komvizila hebu kumwibila, ");
INSERT INTO kdc_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","hebu koiduwila kwa uvizi mbuli ya kinhu chagile cha miyage, kamba hachonile, ");
INSERT INTO kdc_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","munhu ayo yahakoneka kabananga na katenda nzambi, yabweze kija kiyebile hebu kija kiyapatile kwa uvizi hebu kinhu kiyagweleligwe yeke hebu kinhu kija chagile na heyo kakipata, ");
INSERT INTO kdc_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","hebu chochose kija kiyaiduwile kwa uvizi. Vonda yoneke kabananga yalihe kila kinhu kamba vikikalile, na yengeze asilimia malongo mabili ya bei ya kinhu acho. ");
INSERT INTO kdc_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Abaho yamgalile mulava nhosa ng'hondolo mbigalo yelibule kilema chochose kamba viilondigwa, na yamulavile Mndewa Imulungu nhosa ya kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mulava nhosa yatende loholo da nzambi za munhu ayo kuulongozi wa Mndewa Imulungu, na Imulungu kozigela kumgongo nzambi zake ziyatendile.” ");
INSERT INTO kdc_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Mgwee Haluni na wanage malagizo gano, ‘Malagizo gano mbuli ya nhosa za kusoma moto. Nhosa ikale muupango wa nhosa kilo kigima mbaka imitondo na moto sikuuzimike. ");
INSERT INTO kdc_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Abaho mulava nhosa kuno yavalile kanzu jake da kitani na kaputula yake ya kitani, yasegese ditozi da inhosa isomigwe na yadike kumgwazo wa upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Abaho yasaule viwalo avo na yavale viwalo viyagwe, na yasole ditozi na kudigala kunze ya ing'hambi hanhu habaguligwe kwasila ditozi. ");
INSERT INTO kdc_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto uli muupango wa nhosa ugendelele kwaka sikuuzimike. Kila siku imitondo mulava nhosa yeke ngodi muumoto awo na yeke inhosa ya kusoma moto uchanha yake, na yagasome mavuta ga inhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto ugendelele kwaka muupango wa inhosa na sikuuzimike. ");
INSERT INTO kdc_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Gano gago malagizo ga nhosa ya ndiya. Wanhu wa ulelo wa Haluni wamgalile Mndewa Imulungu nhosa ya ndiya muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mulava nhosa yadehe ganza dimoja da usage hamoja na mavuta na ubani wose na yavilukuze muupango wa nhosa, ino yokuwa hanhu ha kukumbuka kamba usage wose ulavigwa kwa Mndewa Imulungu, mnung'ho wake omnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Usage usigale udigwe na Haluni na ulelo wake bila kugeligwa hamila. Waudile hanhu hong'ala kuuluwa lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Usage awo sikuwokigwe na hamila na udigwe na walava nhosa waiyeka, niye niwagwaa hewo kamba fungu jao kulawa mzinhosa ziondavila kwa moto. Nhosa azo zing'ala ng'hani kamba vizili nhosa za kusegesa nzambi na nhosa za kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Wambigalo wose wa ulelo wa Haluni odaha kuja, kwavija nhosa ayo ibaguligwa mbuli ya hewo kulawa mzinhosa zilavagwa kwa Mndewa Imulungu kwa moto. Munhu yoyose yonda yaikwase kolondigwa yang'ale.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Vivija Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Siku Haluni na ulelo wake vonda wasaguligwe wawe walava nhosa, wamgalile Mndewa Imulungu vibaba vibili va usage unogile kamba nhosa ya ndiya, kibaba kimoja wakilave imitondo na kibaba kiyagwe wakilave ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Usage awo utibwilizigwe na mavuta na ukanzingigwe. Abaho wadibanzule digate vihande vihande na wamulavile Mndewa Imulungu, na mnung'ho wake omnogeza Mndewa. ");
INSERT INTO kdc_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Munhu yolawa muulelo wa Haluni yagidiligwe mavuta ili yasole hanhu hake ha ulava nhosa, yamulavile Mndewa Imulungu nhosa ayo, lagizo dino da siku zose. Nhosa yose isomigwe moto. ");
INSERT INTO kdc_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nhosa yoyose ya ndiya ilavigwe na mulava nhosa isomigwe moto, sikuidigwe.” ");
INSERT INTO kdc_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Mulongele Haluni na wanage wa kimbigalo, ‘Gano gago malagizo ga nhosa ya kusegesa nzambi. Mnyama wa nhosa ya kusegesa nzambi yachinjiligwe hanhu aho hawachinjilaga mnyama wa nhosa ya kusoma moto kuulongozi wa Mndewa Imulungu, nhosa ino ing'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mulava nhosa yoilava inhosa, ayo yonda yaije. Yaidile hanhu hong'ala, kuna uluwa lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Kinhu chochose chonda kikwase nyama ayo chokuwa king'ala, kiwalo chochose chahadwendwekelwa na damu ya nhosa ayo, kifuwiligwe hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nhosa ayo yahatelekigwa mulukalango, lukalango ulo lutuligwe na kamba itelekeligwa mwiisefulia, sefulia ayo isuguigwe na kusunhigwa kwa mazi. ");
INSERT INTO kdc_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Wambigalo waiyeka wa ulelo wa iwalava nhosa awo odaha kuija nhosa ayo, kwavija nhosa ayo ing'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Lakini kamba damu ya mnyama wa nhosa ya kusegesa nzambi igaligwa hanhu hong'ala mna dihema da mting'hano ili kulohola nzambi, nyama ayo sikuidigwe, isomigwe moto. ");
INSERT INTO kdc_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Gano gago malagizo ga nhosa ya kulihila gehile. Nhosa ayo ing'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mnyama wa nhosa ya kulihila gehile yachinjiligwe hanhu howochinjilagwa wanyama wa nhosa za kusoma moto, na idamu imizigwe banzi zose za upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mavuta gake gose galavigwe nhosa, mavuta ga umkila na mavuta gogubika uusapi, ");
INSERT INTO kdc_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","hamoja na figo mbili na gamavuta gake na hanhu hanogile ha maini. ");
INSERT INTO kdc_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mulava nhosa yavisome moto muupango wa nhosa kamba nhosa ilavagwa kwa moto kwa Mndewa Imulungu. Ino ayo nhosa ya kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Wambigalo waiyeka wa ulelo wa walava nhosa awo odaha kuja nhosa ayo, nhosa ino ing'ala ng'hani, avo idiligwe hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Malagizo ni gagano kwa nhosa ya kusegesa nzambi na nhosa ya kulihila gehile, imulava nhosa yotenda diloholo, ayo yonda yasole inyama. ");
INSERT INTO kdc_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mulava nhosa yolava nhosa ya kusomigwa moto ya munhu yoyose, ayo yonda yasole ing'hwembe ya mnyama ayo. ");
INSERT INTO kdc_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nhosa yoyose ya ndiya hebu usage okigwe hebu utelekigwe hebu ukanzingigwe, yasole imulava nhosa yolava inhosa. ");
INSERT INTO kdc_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nhosa yoyose ya ndiya hebu usage ugeligwe mavuta hebu ulibule mavuta, yokuwa ya Haluni na ulelo wake, wose waigolele sawa. ");
INSERT INTO kdc_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Gano gago malagizo ga nhosa za kugala kuilumba kamba munhu kolonda kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Kamba munhu kogala nhosa ya kugala kuilumba mbuli ya kumgwaa nhogolwa Imulungu, yailave na gate digeligwe mavuta ila sikudigeligwe hamila, na vigate visisili vibakigwe mavuta na magate ga usage ulibule midundulu na ugeligwe mavuta. ");
INSERT INTO kdc_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Hamoja na nhosa ayo, yagale na magate gageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Mna ikila nhosa yamgalile Mndewa Imulungu magate mane, kila aina gate dimoja, magate gago gokuwa ga mulava nhosa yomiza idamu ya inhosa ya kugala kuilumba muupango. ");
INSERT INTO kdc_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama ya nhosa ayo idigwe siku dijo diilavigwa, sikukisigasigwe chochose mbaka imitondo. ");
INSERT INTO kdc_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Lakini kamba nhosa ayo ya kugala kuilumba mbuli ya kija kiyaiduwile munhu hebu kalonda mwenyego, idigwe siku dijo diilavigwa na kamba yosigala yodaha kudigwa imitondo yake. ");
INSERT INTO kdc_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Lakini nyama yoyose ya nhosa ayo yahasigala mbaka siku da kadatu isomigwe moto. ");
INSERT INTO kdc_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kamba nyama ya nhosa ayo yodigwa mbaka siku da kadatu, nhosa ayo honda itogoligwe. Munhu yalavile nhosa ayo honda yapate chochose, kwavija nhosa ayo ifita na munhu yoyose yonda yaije kogaya. ");
INSERT INTO kdc_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Nyama yoyose ikwasigwe na kinhu kifitile sikumuje. Nyama ayo isomeni moto. “ ‘Wanhu wang'alile odaha kuja nyama, ");
INSERT INTO kdc_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ilavigwe nhosa ya kugala kuilumba. Lakini munhu yoyose yafitile yahaja, yabaguligwe na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Munhu yoyose yokwasa kinhu chochose kifitile, iwe uchafu wa munhu hebu mnyama yagomesigwe kudigwa hebu chochose kimgevuza Mndewa, kamba yahaja nyama ya nhosa ayo ilavigwa kwa Mndewa Imulungu, munhu ayo yabaguligwe na wanhu zake.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Walongele vino wanhu wa Izilaeli, ‘Sikumuje mavuta ga ng'ombe hebu ng'hondolo hebu mbuzi. ");
INSERT INTO kdc_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mavuta ga mnyama yoyose yafile mwenyego hebu ga mnyama yakomigwe na mnyama iyagwe modaha kugeka goya kwa sang'hano iyagwe, lakini sikumugaje. ");
INSERT INTO kdc_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Munhu yoyose yahagaja mavuta ga mnyama yalavigwe kwa Mndewa Imulungu kwa moto, yabaguligwe na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Vivija sikumuje damu yoyose, iwe ya ndege hebu mnyama, kokose konda mukale. ");
INSERT INTO kdc_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Munhu yoyose yahaja damu, yabaguligwe na wanhu zake.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Walongele vino wanhu wa Izilaeli, ‘Munhu yoyose yahagala nhosa ya kugala kuilumba, yamgwee Mndewa Imulungu hanhu ha inhosa ayo. ");
INSERT INTO kdc_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Yamgalile kwa makono gake mwenyego kamba nhosa ya kusoma moto. Yamgalile gamavuta hamoja na ikidali chonda yakinule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mulava nhosa yagasome moto mavuta gose muupango wa nhosa, lakini ikidali chokuwa cha Haluni na ulelo wake. ");
INSERT INTO kdc_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kihili cha mkono wa ukudila wa mnyama wa nhosa zenu za kugala kuilumba mumgwee mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kihili acho chokuwa cha imulava nhosa wa ulelo wa Haluni yolava idamu na gamavuta ga inhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Niye Mndewa Imulungu niwalagiza wanhu wa Izilaeli wamgwee Haluni na ulelo wake kidali na ikihili cha mnyama ayo wa nhosa ya kugala kuilumba, kwavija wekiligwa hewo siku zose.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Dino dijo fungu diwekiligwe Haluni na ulelo wake mna zinhosa zilavagwa kwa Mndewa Imulungu kwa moto, kulawa siku diwasaguligwe wawe walava nhosa wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Viwalavigwe kwa Mndewa kwa kugidiligwa mavuta, Mndewa Imulungu kawalagiza wanhu wa Izilaeli wawagwee fungu dijo da nhosa, siku zose yokuwa vivo. ");
INSERT INTO kdc_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Avo gano gago malagizo ga nhosa ya kusoma moto na nhosa ya ndiya na nhosa ya kusegesa nzambi na nhosa ya kulihila gehile na nhosa ya munhu yahasaguligwa yawe mulava nhosa na nhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Mndewa Imulungu kamgwaa Musa malagizo gano gose kulugongo lwa Sinai siku dija diyawalagize wanhu wa Izilaeli wamgalile sadaka zao, ako kuluwala lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Mkeme Haluni na wanage weze hana ulwivi lwa dihema da mting'hano, sola iviwalo, mavuta ga kuwagidila, ng'ombe bigalo wa nhosa ya kusegesa nzambi, ng'hondolo wa kimbigalo wabili na kigelo cha magate hagageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Abaho wakeme wanhu wose wa Izilaeli weze hana ulwivi lwa dihema da mting'hano.” ");
INSERT INTO kdc_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa katenda kamba viyalagizwe na Mndewa Imulungu, kawakema wanhu wose wa Izilaeli weze hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa kawalongela wanhu wa Izilaeli, “Gano gago gayalagize Mndewa Imulungu gatendigwe.” ");
INSERT INTO kdc_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Abaho Musa kawagala kuulongozi Haluni na wanage, kawasunha kwa mazi. ");
INSERT INTO kdc_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Abaho kamvaza kanzu Haluni, na kadifunga na mkwiji, na kamvaza kanzu diyagwe na kikoti na kakifunga mkwiji ulukigwe goya mkigudi chake. ");
INSERT INTO kdc_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Abaho keka ikikoba mmhambaga ya Haluni na mgati kagela gamabwe gomtenda yajuwe goyolonda Mndewa Imulungu yatende. ");
INSERT INTO kdc_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Abaho kamvaza Haluni kilemba mdipala, kuulongozi wa kilemba acho keka ulung'andi lwa zahabu, lulagusa kamba heyo kalavigwa kwa Imulungu kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Abaho Musa kasola gamavuta, kadibaka dihema da mting'hano na kavibaka vinhu vose vikalile mgati na kavilava vinhu avo vose kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Mavuta gayagwe kagamiza muupango wa nhosa miyanza saba, na vivija kavimizila viya vose visang'haniligwa, dibakuli na mgimbo wake, vose kavilava kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Vivija Musa kamgidila Haluni gamavuta mdipala ili kumulava kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Abaho Musa kawasola wanage Haluni kawavaza makanzu na kawafunga mikwiji mvigudi, na kawavaza kofia kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Abaho Musa kamgala ing'ombe wa nhosa ya kusegesa nzambi, na heyo Haluni na wanage weka makono gao mdipala da ng'ombe ayo. ");
INSERT INTO kdc_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa kamchinja ng'ombe ayo, kazabika kidole chake mwiidamu, kazibaka zimhembe nne za uupango wa kulavila nhosa na damu isigale kaigida hasi ya dako da upango wa nhosa. Kwa kutenda avo kautenda uupango ung'ale na kaulava kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Abaho kasola mavuta gose gakalile muusapi na hanhu hanogile ha maini na zifigo mbili na mavuta gake, vose kavisoma moto muupango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Lakini nyama ya ing'ombe ayo na ing'hwembe yake na mavi gake, kavisoma moto kunze ya ing'hambi kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Abaho Musa kagala ing'hondolo wa kimbigalo wa nhosa ya kusoma moto. Haluni na wanage weka makono gao mdipala da ng'hondolo ayo. ");
INSERT INTO kdc_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa kamchinja ng'hondolo ayo na idamu yake kaimiza mzibanzi zose za upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Kamkanha vihande vihande ayo ing'hondolo, kavisoma moto hamoja na dipala na mavuta gake. ");
INSERT INTO kdc_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Musa viyamambukize kusunha uusapi na imigong'ho kwa mazi, kavisoma moto muupango wa nhosa hamoja na ivinhu viyagwe vose va ing'hondolo ayo kamba nhosa ya kusoma moto. Nhosa ayo inung'hila goya na imnogeza Mndewa Imulungu. Musa katenda kamba viyalagizwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Abaho kamgala ng'hondolo iyagwe wa kimbigalo, ili Haluni na wanage walavigwe kwa Mndewa Imulungu. Haluni na wanage weka makono gao mdipala da ng'hondolo ayo. ");
INSERT INTO kdc_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa kamchinja ng'hondolo ayo na kasola idamu kambaka Haluni kumgwazo wa gwiti jake da mkono wa kudila, vivija kambaka idamu mdidole ng'hulu da mkono wa kudila na mdidole ng'hulu da mgulu wa kudila. ");
INSERT INTO kdc_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Vivija kawabaka idamu iwana wa Haluni kumgwazo wa magwiti gao ga mkono wa kudila, na imidole ng'hulu ya makono gao ga kudila na imidole ng'hulu ya magulu gao ga ukudila. Damu iyagwe kaimiza mzibanzi zose za upango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Vivija kasola mavuta gose na mavuta geli mumkila, na mavuta gose geli muusapi na hanhu hanogile ha maini na zifigo mbili na mavuta gake na ikihili cha mgulu wa kudila wa ayo ing'hondolo. ");
INSERT INTO kdc_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Abaho kulawa mkigelo cha magate kikigwe kuulongozi wa Mndewa Imulungu, kalava gate dimoja hadigeligwe hamila, na gate dimoja dili na mavuta na kigate kimoja kisisili, vose kavika uchanha ya gamavuta na ikihili. ");
INSERT INTO kdc_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Musa kawagwaa vinhu avo vose Haluni na wanage, na wavinula uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Abaho Musa kavisola mmakono gao vinhu avo vose na kavisoma moto muupango wa nhosa hamoja na inhosa. Ino ayo nhosa ya kuwalava wanhu kwa Mndewa Imulungu wawe walava nhosa, nhosa inung'hila goya na imnogeza Mndewa Imulungu, ino ayo nhosa ilavagwa kwa moto. ");
INSERT INTO kdc_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Abaho Musa kasola ikidali kakinula uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. Hanhu ha nyama ayo ya ing'hondolo wa nhosa ya kuwalava wanhu kwa Mndewa Imulungu, mwenyego Musa kamba vija Mndewa Imulungu viyalagize. ");
INSERT INTO kdc_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Abaho Musa kasola gamavuta gang'alile na idamu kulawa muupango wa nhosa, kawamizila Haluni na wanage vivija kavimizila iviwalo vao. Avo Musa kawalava Haluni na wanage na iviwalo vao kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa kamulongela Haluni na wanage, “Telekeni nyama ino aho hana ulwivi lwa dihema da mting'hano na muije yose aho hamoja na gate dili mkigelo cha nhosa za kuwalava wanhu kwa Mndewa Imulungu, tendeni kamba Mndewa Imulungu viyanilagize, kamba vinhu avo vodigwa na Haluni na wanage. ");
INSERT INTO kdc_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Someni moto gate jojose donda disigale hebu nyama yonda isigale. ");
INSERT INTO kdc_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Sikumulawe kunze ya dihema da mting'hano kwa siku zose saba, mbaka zimale siku zenu za kulavigwa kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mndewa Imulungu katulagiza tuwatendele kamba vitutenda sambi ili nzambi zenu ziloholigwe.” ");
INSERT INTO kdc_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mukale hano hana ulwivi lwa dihema da mting'hano imisi na ikilo kwa siku saba, mwahalema mofa. Vivo viyanilagize Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Avo, Haluni na wanage watenda kila kinhu kamba Musa viyalagizwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Vizishile siku azo saba za kutendigwa walava nhosa Haluni na wanage, avo mwiisiku ya nane Musa kawakema Haluni na wanage na iwavele wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Musa kamulongela Haluni, “Sola bofu da ng'ombe wa kimbigalo wa nhosa ya kusegesa nzambi, vivija sola mwana ng'hondolo wa kimbigalo kwa nhosa ya kusoma moto, wanyama wose awo sikuwawe na kilema chochose. Abaho walavigwe nhosa kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Walongele wanhu wa Izilaeli wagale mbuzi wa kimbigalo yalavigwe nhosa ya kusegesa nzambi, vivija wagale mwana ng'hondolo na bofu da ng'ombe weli na mwaka umoja na sikuwawe na kilema chochose ili walavigwe nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na wagale ng'ombe wa kimbigalo na ng'hondolo wa kimbigalo ili walavigwe nhosa ya kugala kuilumba. Wamgalile Mndewa Imulungu nhosa ayo na nhosa ya ndiya ihanganyigwe na mavuta kwavija lelo Mndewa kowalawila.” ");
INSERT INTO kdc_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Wanhu wa Izilaeli wavigala vinhu avo vose hana dihema da mting'hano kamba Musa viyawalagize na wanhu wose wa Izilaeli wachola kwima kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa kawalongela, “Vino avo viyalagize Mndewa Imulungu mweye mutende, ili ukulu wake oneke kumwenu.” ");
INSERT INTO kdc_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa kamulongela Haluni, “Genda hana uupango wa nhosa, ulave nhosa ya kusegesa nzambi na nhosa ya kusoma moto ili kulohola nzambi zako na nzambi za wanhu wose. Lava nhosa ayo ya kulohola nzambi za wanhu kamba Mndewa Imulungu viyalagize.” ");
INSERT INTO kdc_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Avo Haluni kachola muupango wa nhosa na kachinja imwana ng'ombe wa nhosa ya kusegesa nzambi zake mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Wanage wamgalila idamu, na heyo kazabika kidole chake mwiidamu na kazibaka zimhembe zili muupango wa nhosa, damu isigale kaigida mdidako da upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Lakini gamavuta na zifigo na hanhu hanogile ha maini vose kavisoma moto muupango wa nhosa kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nyama na ing'hwembe kavisoma moto kunze ya ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Abaho kachinja ing'hondolo wa nhosa ya kusoma moto. Wanage wamgalila idamu, na heyo kaimiza idamu banzi zose za upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Abaho wamgalila dipala na vihande viyagwe va ing'hondolo ayo na heyo kavisoma moto muupango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Abaho kasunha ivinhu va mgati na imigong'ho na kavisoma moto muupango wa nhosa na ija inhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Abaho Haluni kailava inhosa iwaigalile iwanhu. Kamchinja imbuzi wa nhosa ya kusegesa nzambi za wanhu, katenda kamba viyatendile kwa ing'ombe wa kusegesa nzambi zake mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Abaho keka kuulongozi ija inhosa ya kusoma moto, imwana ng'hondolo na imwana ng'ombe na katenda kamba viyalagizwe. ");
INSERT INTO kdc_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Abaho kagala inhosa ya indiya, kadeha ganza dimoja kadisoma muupango wa nhosa hamoja na nhosa ya kusoma moto. Katenda vino kwa kwengeza inhosa ya kusoma moto ilavagwa kila siku imitondo. ");
INSERT INTO kdc_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Abaho Haluni kachinja ing'ombe wa kimbigalo na ing'hondolo wa kimbigalo kamba nhosa ya kugala kuilumba. Wanage wamgalila idamu, na heyo kaimiza banzi zose za upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Lakini gamavuta ga ing'ombe ayo na ing'hondolo ayo na mavuta geli muusapi na zifigo na hanhu hanogile ha maini na mavuta geli mumkila wa ing'hondolo, ");
INSERT INTO kdc_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","wavigela mvidali na Haluni kavisoma moto muupango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haluni kavinula uchanha ividali na ivihili va ukudila va ing'hondolo na ing'ombe, kamba kilaguso cha kumulavila Mndewa Imulungu, kamba Musa viyalagize. ");
INSERT INTO kdc_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Abaho Haluni viyamambukize kulava nhosa zose, kenula makono gake kawatambikila wanhu, abaho kahumuluka hasi. ");
INSERT INTO kdc_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Abaho Musa na Haluni wachola kuna dihema da mting'hano. Viwalawile kunze wawatambikila wanhu, na ukulu wa Mndewa Imulungu uwalawilila wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Moto ulawa muukulu wa Mndewa Imulungu uzisoma nhosa zose na gamavuta geli muupango wa nhosa. Wanhu viwone avo, wakemelela kwa deng'ho waidulika mbaka hasi wamtambikila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Wanage Haluni, Nadabu na Abihu kila imoja kasola kiya cha kuhalila moto, weka moto na ubani, wamulavila Mndewa Imulungu moto haulondigwa, kwavija Mndewa Imulungu hawalagize watende vivo. ");
INSERT INTO kdc_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Bahaja Mndewa Imulungu kagala moto uwalukuza wose, wafa kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa kamulongela Haluni, “Vino avo viyalongile Mndewa Imulungu, ‘Noilagusa kamba niye ning'ala kwa wanhu wose onda weze behi yangu, na notogoligwa mgameso ga wanhu wose!’” Haluni kanyamala tuluu. ");
INSERT INTO kdc_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa kawakema Mishaeli na Elisafani wanage Uzieli, tatake mdodo Haluni. Kawalongela soleni imitufi ino mibili ya ndugu zenu igaleni kunze ya ing'hambi kutali na ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Avo wachola wagoga iviwalo va awo wafile wawagala kunze ya ing'hambi kamba Musa viyalagize. ");
INSERT INTO kdc_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Abaho Musa kamulongela Haluni na wanage wabili, Eleazali na Itamali, “Sikumuleke kubunha mvili zenu na sikumuiyalale kwa kudega dega viwalo venu, bule mofa na Mndewa Imulungu kowagevuzikila wanhu wose. Lakini ndugu zenu na wanhu wose wa Izilaeli, odaha kuiyalala mbuli ya awo walukuzigwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mweye sikumulawe kunze ya dihema da mting'hano, bule mofa kwavija musaguligwa na Mndewa Imulungu na mugidiligwa mavuta gang'alile.” Haluni na wanage watenda kamba Musa viyalongile. ");
INSERT INTO kdc_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Abaho Mndewa Imulungu kamulongela Haluni, ");
INSERT INTO kdc_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Gweye na wanago mwahengila mna dihema da mting'hano sikumung'we ugimbi hebu divai bule mofa. Lagizo dino mudigoge kwa ulelo wenu wose onda wize. ");
INSERT INTO kdc_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Molondigwa mugajuwe gaja galavigwe kwa Imulungu na gaja ga iwanhu na mugajuwe gaja gang'alile na gaja gafitile. ");
INSERT INTO kdc_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Muwafundize wanhu wa Izilaeli malagizo gose ganiwagwelele kubitila Musa.” ");
INSERT INTO kdc_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa kamulongela Haluni na wanage wasigale Eleazali na Itamali, “Soleni ndiya ya inhosa isigale kulawa kuna inhosa ilavigwe kwa Mndewa Imulungu kwa moto, muidile behi na uupango wa nhosa bila kugela hamila, kwavija nhosa ayo ing'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Avo idileni hanhu hang'alile kwavija dijo ajo fungu jenu gweye na wanago mna zinhosa zilavagwa kwa Mndewa kwa moto, vivo viyandagize Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Lakini gweye na wanago, wa ikimbigalo na wa ikitwanzi na wanhu okala mng'anda yako, modaha kuja ikidali na ikihili vikalile vinuligwe uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. Dileni hanhu hong'ala kwavija kugweleligwa gweye na ulelo wako kamba fungu jenu kulawa mzinhosa za kugala kuilumba zigaligwa na wanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Avo galeni ikihili na ikidali na gamavuta vili nhosa ya kusoma moto, ili vose vinuligwe uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. Avo vose vokuwa vako gweye na ulelo wako kamba Mndewa Imulungu viyalagize.” ");
INSERT INTO kdc_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa viyauzile imbuzi wa nhosa ya kusegesa nzambi kakwahi kalongeligwa wamulava mwaka, Musa kawagevuzikila Eleazali na Itamali, iwana wasigale wa Haluni. ");
INSERT INTO kdc_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Kawalongela, “Habali hamuidile inyama ya nhosa ya kusegesa nzambi hanhu hong'ala? Kwavija nhosa ayo ing'ala ng'hani na mugweleligwa mweye mbuli ya kusegesa nzambi za wanhu wa Izilaeli kwa kuwatendela loholo kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Avo, kwavija idamu yake haigaligwe hanhu hong'ala, mwahaidile inyama hanhu hong'ala, kamba vinilagize.” ");
INSERT INTO kdc_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Haluni kamulongela Musa, “Lelo wamulavila Mndewa Imulungu nhosa yao ya kusegesa nzambi na nhosa ya kusoma moto, lakini gehile gandawila. Vino Mndewa yahanogezwe kamba nahaidile lelo inhosa ya kusegesa nzambi?” ");
INSERT INTO kdc_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa viyahulike vivo, kakala moyo kwatu. ");
INSERT INTO kdc_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Walongele wanhu wa Izilaeli, ‘Mna iwanyama weli mwiisi, wano awo wakudigwa. ");
INSERT INTO kdc_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Modaha kumuja mnyama yoyose yatulike mmibang'ho na ija yoselula gaja gayadile na kogaja kabili. ");
INSERT INTO kdc_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Sikumuje mnyama yoyose yoselula lakini mibang'ho yake haitulike hebu mnyama yeli na mibang'ho itulike lakini haselula bule. Sikumuje ngamiya kwavija koselula lakini mibang'ho yake haitulike bule. Mnyama ayo kumwenu mweye kafita. ");
INSERT INTO kdc_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ndezi sikumuje, ayo koselula lakini kabule mibang'ho itulike, avo ayo kafita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Buga sikumuje, ayo koselula lakini mibang'ho yake haitulike, avo ayo kafita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nguluwe sikumuje, ayo kana mibang'ho itulike lakini haselula bule, avo ayo kafita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Wanyama awo wafita kumwenu, avo sikumuje nyama yao hebu kukwasa mitufi yao. ");
INSERT INTO kdc_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Viumbe wose okala mbahali na okala muulwanda, modaha kuwaja wano, waja weli na minzaka nzaka na makalabamba. ");
INSERT INTO kdc_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Lakini kiumbe chochose kikala mbahali hebu muulwanda, kamba chabule minzaka nzaka hebu makalabamba sikumuje, avo vose vifita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Kwavija viumbe avo vifita kumwenu, sikumuje nyama yao hebu kukwasa mitufi yao. ");
INSERT INTO kdc_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chochose kikala mgamazi na kuno chabule minzaka nzaka na makalabamba acho kifita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Ndege wano wafita kumwenu, avo sikumuwaje, mhungu, jola, kimhanga, ");
INSERT INTO kdc_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kidumule na makungule na ndege wose wayagwe waigalile na hewo, ");
INSERT INTO kdc_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","na ndege wose waigalile na bondwa. ");
INSERT INTO kdc_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Sikumuje mbuni na kilopo na dudumizi na vimhanga wayagwe, ");
INSERT INTO kdc_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","bundi na mumbi na bundi mkulu, ");
INSERT INTO kdc_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","bundi mzelu na bundi luwala na kinyang'huwi, ");
INSERT INTO kdc_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","lawalawa na aina zose za nyamkuta, lugawa na gombalima. ");
INSERT INTO kdc_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Wang'onyo wose oguluka na otambala wao wafita kumwenu, sikumuje. ");
INSERT INTO kdc_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Lakini wang'onyo weli na mabawa na ogenda kwa kuzumha zumha modaha kuwaja. ");
INSERT INTO kdc_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Mna iwang'onyo awo modaha kuwaja wano, kila aina ya nzige, kila aina ya senene, kila aina ya mbalangulu na kila aina ya nyenze. ");
INSERT INTO kdc_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Lakini wang'onyo wose wayagwe oguluka na otambala, awo wafita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Munhu yoyose yokwasa imitufi ya iwanyama awo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Munhu yonda yaipape imitufi ayo kokuwa kafita mbaka ichungulo na yafuwe viwalo vake. ");
INSERT INTO kdc_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Mnyama yoyose mibang'ho yake haitulike hebu haselula, ayo kafita kumwenu, na munhu yoyose yonda yakwase mtufi wake kokuwa kafita. ");
INSERT INTO kdc_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Wanyama wose ogenda kwa mifumbi ya mibang'ho yao hamoja wana magulu mane awo wafita kumwenu, munhu yoyose yonda yakwase imitufi yao kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Munhu yoyose yonda yapape mitufi yao yafuwe viwalo vake na kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Mna iwang'onyo ogenda kwa magulu, wano wafita kumwenu, lukwili na mbewa na kila aina ya ng'henge, ");
INSERT INTO kdc_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","gong'ole na mbulu luwala na guluguja na ng'hakala na lwihu. ");
INSERT INTO kdc_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wang'onyo awo wose wafita kumwenu, munhu yoyose yonda yakwase mitufi yao kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Mtufi wa wang'onyo awo wahagwila kinhu chochose kiwe cha mbiki hebu kiwalo hebu ng'hwembe hebu kiloba hebu kiya chochose, kisunhigwe kwa mazi, na chokuwa kifita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kamba mtufi wa wang'onyo awo ulagalila mnongo, chochose kili mnongo ayo kifita na nongo ayo ituligwe. ");
INSERT INTO kdc_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ndiya yoyose yahakwasigwa na mazi golawa mnongo ayo yokuwa ifita, na kinhu chochose cha kung'wa kili mnongo ayo, chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mtufi wa mng'onyo ayo wahalagalila mkinhu chochose, kinhu acho chokuwa kifita. Kamba kinhu acho tanuli hebu jiko da ulongo avo dituligwe. Viya avo vifita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Lakini kisima hebu nzasa vokuwa ving'ala, hamoja kinhu chochose kiyagwe chahakwasa mtufi awo chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Mtufi wa mng'onyo yoyose wahalagalila mzimbeyu za kuhanda, mbeyu azo hazifita bule. ");
INSERT INTO kdc_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Lakini kamba mbeyu zilowekigwa mgamazi na mtufi wa mng'onyo yoyose wahalagalila mumo, mbeyu azo zifita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Kamba mng'onyo yoyose yumulongeligwe modaha kumuja kafa mwenyego, munhu yonda yakwase mtufi wake kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Munhu yoyose yoja ng'hone yafuwe viwalo vake, na kokuwa kafita mbaka ichungulo. Munhu yoyose yonda yapape ng'hone yafuwe viwalo vake na kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Mng'onyo yoyose yotambala mwiisi kafita kumwenu, sikumuje. ");
INSERT INTO kdc_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Sikumuje mng'onyo yoyose yogenda kwa inda yake hebu yogenda kwa magulu gake gose mane hebu yeli na magulu mengi, awo wafita kumwenu. ");
INSERT INTO kdc_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Avo sikumuifitize kwa kuja wang'onyo awo na sikumuifitize kwa kukwasa imitufi yao. ");
INSERT INTO kdc_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Niye na Mndewa Imulungu wenu, ilaveni wenyego kumwangu na muwe wanhu wang'alile kwavija niye ning'ala. Avo sikumuifitize kwa mng'onyo yoyose mwiisi. ");
INSERT INTO kdc_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kwavija niye ayo Mndewa Imulungu niwalavile mweye mwiisi ya Misili ili niwe Imulungu wenu, avo muwe wanhu wang'alile kwavija niye ning'ala. ");
INSERT INTO kdc_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Gano gago malagizo ga wanyama na ndege na wang'onyo wose ogenda mgamazi na waja otambala mwiisi. ");
INSERT INTO kdc_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Avo mujuwe kusagula, wang'onyo wafitile na hawafitile na wang'onyo odigwa na hawadigwa.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mndewa Imulungu kamgwaa Musa malagizo gano, ");
INSERT INTO kdc_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Walongele wanhu wa Izilaeli, ‘Mtwanzi yagogile inda na kulela mwana wa kimbigalo, kokuwa kafita kwa siku saba kamba viyawaga kafita mna ikipindi chake cha kutumika. ");
INSERT INTO kdc_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Siku da nane imwana yengizigwe kumbi. ");
INSERT INTO kdc_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Abaho mtwanzi ayo kogendelela kukala yafitile kwa siku malongo madatu na ndatu. Kipindi acho chose sikuyakwase kinhu chochose king'alile hebu kwingila hanhu hang'alile mbaka zimale siku za kutendigwa yang'ale mbuli ya kulawa ng'hunga. ");
INSERT INTO kdc_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“ ‘Kamba mtwanzi kalela mwana wa kitwanzi, mtwanzi ayo kokala kafita kwa wiki mbili, kamba viyawaga mna ikipindi chake cha kutumika. Na kokala kwa siku malongo sita na sita mbaka zishe siku za kutendigwa yang'ale mbuli ya kulawa ng'hunga. ");
INSERT INTO kdc_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Siku za kutendigwa yang'ale zahesha, iwe kalela mwana wa kimbigalo hebu wa kitwanzi, yamgalile mulava nhosa hana ulwivi lwa dihema da mting'hano mwana ng'hondolo wa mwaka umoja mbuli ya nhosa ya kusoma moto na kinda da njiwa hebu huwa, mbuli ya nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mulava nhosa yamulavile nhosa ayo kuulongozi wa Mndewa Imulungu na yamtendele mtwanzi ayo nhosa ya loholo da nzambi. Avo mtwanzi ayo kokuwa kang'ala mbuli ya kulawa ng'hunga. Gano gago malagizo mbuli ya mtwanzi yoyose yolela mwana wa kitwanzi hebu wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“ ‘Kamba hadaha kugala mwana ng'hondolo, yagale huwa wabili hebu makinda mabili ga njiwa, imoja yawe nhosa ya kusoma moto na iyagwe yawe nhosa ya kusegesa nzambi. Mulava nhosa yamtendele mtwanzi ayo nhosa ya loholo da nzambi, na heyo kokuwa kong'ala.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kamba munhu kavimba hebu kana pute hebu punye na yahakoneka kamba utamu wa dikulu, yagaligwe kwa Haluni imulava nhosa hebu kwa imoja wa wanage yeli mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mulava nhosa yakikagule goya ikilonda kili mulukuli na kamba mvili zili mkilonda ziwa nzelu na kilonda kihimbika ng'hani kubanza ing'hwembe, awo okuwa utamu wa dikulu. Mulava nhosa yahamambukiza kumkagula, yawalongele wanhu kamba munhu ayo kafita. ");
INSERT INTO kdc_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kamba dipunye dili mwiing'hwembe yake zelu, lakini hadihimbike ng'hani kubanza ing'hwembe na zimvili hazili nzelu, mulava nhosa yamwike munhu ayo kutali na iwanhu kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Siku da saba mulava nhosa yamkagule, na kamba yahakona idipunye hadigaluke na hadihimbike ng'hani mna ing'hwembe yagendelele kumuleka munhu ayo hanhu aho kwa siku saba ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Siku da saba mulava nhosa yamkagule kabili na kamba dipunye disonga kuhona na hajenele mwiing'hwembe, munhu ayo yafuwe viwalo vake na mulava nhosa yawalongele wanhu kamba munhu ayo kang'ala na kamba dikala punye na siyo utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Lakini kamba dipunye ajo disonga kwenela mulukuli, kulawa siku dija mulava nhosa viyamambukize kumkagula na kawalongela wanhu kamba kang'ala, avo munhu ayo yachole kabili kwa mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mulava nhosa yamkagule na kamba dipunye jenela mulukuli, yawalongele wanhu kamba munhu ayo kafita, na kamba awo utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Munhu yoyose yahawa na utamu wa dikulu yagaligwe kwa mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mulava nhosa yamkagule na kamba kana kilonda kibisi kizelu kitendile mvili zake ziwe nzelu na kina udusi, ");
INSERT INTO kdc_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","awo okuwa utamu wa dikulu wa siku nyingi. Mulava nhosa yawalongele wanhu kamba munhu ayo kafita, na sikuyamgale kutali na iwanhu, kwavija kajuwa goya kamba kafita. ");
INSERT INTO kdc_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kamba utamu wenela mulukuli lose, kulawa kudipala mbaka muulwayo kamba voyokona imulava nhosa, ");
INSERT INTO kdc_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","yamkagule kabili. Yahakona utamu awo wenela mulukuli lose, avo yawalongele wanhu kamba munhu ayo kang'ala. Kwavija lukuli lose luzelu avo munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Lakini mulukuli lwa munhu ayo mwahawa na kilonda kibisi, avo munhu ayo kokuwa kafita. ");
INSERT INTO kdc_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mulava nhosa yakikagule acho ikilonda kibisi, na kuwalongela wanhu kamba munhu ayo kafita kwavija awo utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Lakini acho ikilonda kibisi chahagaluka kabili kuwa kizelu munhu ayo yabwele kwa mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mulava nhosa yamkagule na kamba ikilonda acho kigaluka kizelu, baho mulava nhosa yawalongele wanhu kamba munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Kamba munhu kana pute abaho dihona, ");
INSERT INTO kdc_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","na baho kudikalile dipute hagaluka punye hebu hadung'hu na hana udusi, munhu ayo yamulagusile imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mulava nhosa yamkagule na kamba dipunye dihimbika ng'hani na zimvili zigaluka nzelu, mulava nhosa yawalongele wanhu kamba munhu ayo kafita, awo okuwa utamu wa dikulu ulawilile mbuli ya idipute. ");
INSERT INTO kdc_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Lakini kamba mulava nhosa yahamkagula na kuduhu mvili nzelu na hadihimbike ng'hani na dosonga kuhona, baho mulava nhosa yamwike kutali na iwanhu kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kamba punye ajo jenela mulukuli lose, mulava nhosa yawalongele wanhu kamba munhu ayo kafita, awo utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Lakini kamba dipute hadigaluke na hajenele bule ila yokoneka ng'hovu ya punye iiyeka, avo mulava nhosa yawalongele wanhu kamba munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Kamba munhu kalukula na ikilonda kiwa kidung'hu hebu kizelu, ");
INSERT INTO kdc_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mulava nhosa yakikagule ikilonda acho, na kamba zimvili zigaluka nzelu na kihimbika ng'hani, awo okuwa utamu wa dikulu ulawilila hanhu aho halukule. Mulava nhosa yawalongele wanhu kamba munhu ayo kafita, awo okuwa utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Lakini kamba imulava nhosa yahamkagula na kuduhu mvili nzelu mna ikilonda na kamba hakihimbike na kisonga kuhona, baho imulava nhosa yamwike munhu ayo kutali na iwanhu kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Siku da saba mulava nhosa yamkagule na kamba ikilonda chenela mulukuli lose, mulava nhosa yawalongele wanhu kamba munhu ayo kafita, awo okuwa utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Lakini kamba kilonda acho hachenele, ila kisonga kuhona, acho chokuwa kilonda cha kulukula, avo imulava nhosa yawalongele wanhu kamba munhu ayo kang'ala, kwavija kana ng'hovu ya kulukula iiyeka. ");
INSERT INTO kdc_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Kamba mtwanzi hebu mbigalo kana kilonda kudipala hebu mkidevu, ");
INSERT INTO kdc_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mulava nhosa yakikagule, na kamba kihimbika ng'hani na zimvili za njano na sisili, avo mulava nhosa yawalongele wanhu kamba munhu ayo kafita, awo okuwa utamu wa dikulu wa kudipala hebu wa mkidevu. ");
INSERT INTO kdc_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Lakini kamba mulava nhosa yahakona kamba ikilonda hakihimbike na zimvili siyo nhitu, baho mulava nhosa yamwike munhu ayo kutali na iwanhu kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Siku da saba mulava nhosa yakikagule ikilonda na kamba kilonda acho hachenele na kuduhu mvili zili za njano na ikilonda hakihimbike, ");
INSERT INTO kdc_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","avo munhu ayo yabee mvili zake hebu ndevu zake hasigale aho hana ikilonda. Abaho mulava nhosa yamwike munhu ayo kutali na iwanhu kwa siku saba ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Siku da saba mulava nhosa yakikagule ikilonda. Yahakona acho ikilonda hachenele mulukuli na hakihimbike ng'hani, munhu ayo yafuwe viwalo vake na imulava nhosa yawalongele wanhu kamba munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Lakini ikilonda acho chahasonga kwenela, kulawa aho imulava nhosa viyawalongele wanhu kamba munhu ayo kang'ala, ");
INSERT INTO kdc_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","imulava nhosa yamkagule kabili. Kamba ikilonda chenela mulukuli, mulava nhosa halondigwa yalole kamba kana mvili za njano, kwavija munhu ayo kokuwa kafita. ");
INSERT INTO kdc_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Lakini kamba mulava nhosa yahakona ikilonda kihona na mvili nhitu zota hanhu aho, avo ikilonda kihona na imulava nhosa yawalongele wanhu kamba munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Kamba munhu yoyose kana punye zelu mulukuli lwake, ");
INSERT INTO kdc_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mulava nhosa yamkagule munhu ayo. Kamba mulava nhosa yahakona punye ajo zelu kidogo ajo dokuwa punye diiyeka, munhu ayo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Kamba mbigalo kana halaza, munhu ayo kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kamba halaza jake disongela kukihanga mbaka kukisogo, munhu ayo kokuwa kang'ala kwavija dijo halaza diiyeka. ");
INSERT INTO kdc_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Lakini kamba kudindosi kudili dihalaza hebu kukihanga kuna punye dung'hu na zelu, awo okuwa utamu wa dikulu ulawilila aho hana dihalaza dili kudindosi hebu kukihanga. ");
INSERT INTO kdc_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mulava nhosa yamkagule, na kamba punye ajo dung'hu na zelu na dina udusi aho kuna idihalaza dili kudindosi hebu kukihanga na dokoneka kamba utamu wa dikulu, ");
INSERT INTO kdc_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","munhu ayo kana utamu wa dikulu na avo kafita. Mulava nhosa yawalongele wanhu kamba munhu ayo kafita kwavija utamu wake wamdipala. ");
INSERT INTO kdc_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Munhu yeli na utamu wa dikulu yavale midambwada na mvili zake sikuyazibunhe na yagubike imhula na umulomo na yachole yolonga, ‘Niye nifita, niye nifita!’ ");
INSERT INTO kdc_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kokala yafitile siku zose viyokugula utamu awo. Yakale kutali na iwanhu kunze ya ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kamba kuna minyela nyela kuna ikiwalo, kiwe kiwalo cha sufi hebu kitani, ");
INSERT INTO kdc_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kiwe kilukigwa hebu kisokotigwa kwa kitani hebu sufi, hebu kiwe kiwalo cha ng'hwembe yoyose, ");
INSERT INTO kdc_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na kamba iminyela nyela ayo ina langi ya jani bisi hebu midung'hu na yokwenela mna ikiwalo acho, avo yalagusiligwe mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mulava nhosa yakikagule kiwalo acho kili na minyela nyela na yakike kumgwazo kiiyeka kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Siku da saba yakikagule kiwalo acho na kamba minyela nyela ayo yenela mna ikiwalo acho, kiwe kilukigwa hebu kisokotigwa hebu kiwalo cha ng'hwembe yoyose, kiwalo acho kina minyela nyela ya utamu avo chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mulava nhosa yakilukuze kiwalo acho kwavija kina minyela nyela ya utamu. ");
INSERT INTO kdc_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Kamba mulava nhosa yahakona minyela nyela ayo hayenele mna ikiwalo acho, ");
INSERT INTO kdc_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","avo yalagize kiwalo acho kifuwigwe na kikigwe kumgwazo kiiyeka kwa siku saba ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Abaho mulava nhosa yakikagule na kamba kokona hanhu hakalile na iminyela nyela kwa vivija hata kamba hayenele, avo kiwalo acho kifita na kilukuzigwe, iwe iminyela nyela yao ya kukisogo hebu kuulongozi. ");
INSERT INTO kdc_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kamba mulava nhosa yahakona minyela nyela ayo isonga kulawa viwamambukize kukifuwa ikiwalo, avo yahamovole hanhu aho hakalile na iminyela nyela ya utamu. ");
INSERT INTO kdc_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Abaho kamba minyela nyela ayo yokoneka kabili aho kumwande na kumbe ikala yenele mna ikiwalo acho. Avo kiwalo acho kilukuzigwe. ");
INSERT INTO kdc_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Lakini kamba minyela nyela isegela mkiwalo kifuwigwe, kiwalo acho kifuwigwe kabili ili king'ale. ");
INSERT INTO kdc_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Avo gano gago malagizo ga minyela nyela ya utamu ulawilila mna ikiwalo cha sufi hebu kitani hebu kilukigwe hebu kisokotigwe hebu kiwalo cha ng'hwembe yoyose. Avo kwa nzila ayo modaha kujuwa kiwalo kifitile na kiwalo king'alile.” ");
INSERT INTO kdc_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Gano gago malagizo ga munhu yeli na utamu wa dikulu mna isiku ya kuhonyigwa kwake. Yahahonyigwa yagaligwe kwa mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mulava nhosa yachole na munhu ayo kunze ya ing'hambi yakamkagule. Kamba munhu ayo kahonyigwa utamu wake wa dikulu, ");
INSERT INTO kdc_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","baho mulava nhosa yawalagize wanhu wagale ndege wabili wagima wang'alile, na vivija wagale kibanzi cha biki dikemigwa mwelezi na sufi ndung'hu na bunho da hisopo mbuli ya munhu ayo yotendigwa yang'ale. ");
INSERT INTO kdc_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mulava nhosa yalagize wamchinje ndege imoja mna inongo ili na mazi ganogile ga nzasa. ");
INSERT INTO kdc_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mulava nhosa yamsole ndege iyagwe yeli mgima na ikibanzi cha biki da mwelezi na sufi ndung'hu na bunho da hisopo wavigele vose mna idamu ya indege yachinjigwe. ");
INSERT INTO kdc_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Abaho yammizile idamu miyanza saba munhu ayo yahonyigwe, kuno komulongela munhu ayo ung'ale. Ija indege imgima yamulekese yachole mmigunda kunze ya dibuga. ");
INSERT INTO kdc_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Abaho munhu ayo yotendigwa yang'hale yafuwe viwalo vake, na yabee mvili zake zose na yakoge mazi, abaho kokuwa kang'ala. Kodaha kubwela mwiing'hambi lakini yakale kunze ya kibanda chake kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Siku ya saba yabee mvili zake zose kabili, na yabee ndevu zake na ng'humbitu na mvili zose zili mulukuli. Abaho yafuwe viwalo vake na yakoge mazi na heyo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Siku da nane yagale wana ng'hondolo wabili wa kimbigalo welibule kilema chochose, na yagale ng'hondolo wa kitwanzi wa mwaka umoja yelibule kilema chochose, na yagale mhishi imoja na vibaba vibili va usage unogile utibwilizigwe na mavuta mbuli ya nhosa ya ndiya hamoja na mavuta selusi imoja ya nyhupa. ");
INSERT INTO kdc_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mulava nhosa yomtenda munhu ayo yang'ale yamgale kwa Mndewa Imulungu behi ya ulwivi lwa dihema da mting'hano hamoja na vinhu vose viyagalile. ");
INSERT INTO kdc_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mulava nhosa yasole mwana ng'hondolo imoja wa kimbigalo yamulave nhosa ya kulihila gehile hamoja na gaja gamavuta selusi imoja ya nyhupa. Yavinule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Abaho yamchinje ayo imwana ng'hondolo hanhu hang'alile howochinjiligwa wanyama wa nhosa ya kusegesa nzambi na nhosa ya kusoma moto. Nhosa ino ya kulihila gehile kamba viiwaga kwa nhosa ya kusegesa nzambi, imulava nhosa ayo yosola izinyama, nhosa zino zing'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mulava nhosa yasole idamu ya nhosa ya kulihila gehile na yambake munhu ayo yotendigwa yang'ale mna digwiti jake da mkono wa kudila na mdidole ng'hulu da mkono wa kudila na mdidole ng'hulu da mgulu wa mkono wa kudila. ");
INSERT INTO kdc_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Abaho mulava nhosa yasole mavuta kidogo ya gaja selusi imoja ya mavuta na yagagide mna diganza da mkono wake wa kumoso. ");
INSERT INTO kdc_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Yazabike kidole chake cha mkono wa kudila mna gamavuta gago na yammizile munhu ayo yotendigwa yang'ale miyanza saba kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Mavuta gayagwe gasigale mumkono wa mulava nhosa yambake munhu ayo yotendigwa yang'ale mna digwiti jake da mkono wa kudila na mdidole ng'hulu da mkono wake wa kudila na mdidole ng'hulu da mgulu wake wa mkono wa kudila hanhu bahaja hayabakigwe idamu ya nhosa ya kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mavuta gasigale yambake munhu ayo kudipala. Kwa nzila ayo imulava nhosa komtendela loholo da nzambi kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Mulava nhosa yailave inhosa ya kusegesa nzambi na yamtendele loholo da nzambi ili kusegesa kufita kwake. Abaho yamchinje mwana ng'hondolo wa nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Mulava nhosa yailave ija inhosa ya kusoma moto na nhosa ya indiya muupango wa nhosa. Baho mulava nhosa komtendela munhu ayo loholo da nzambi, na heyo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Lakini kamba munhu mkiwa hadaha kulava vinhu vose avo, baho yagale mwana ng'hondolo imoja wa kimbigalo yawe nhosa ya kulihila gehile, yainule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu ili kumtendela munhu ayo loholo da nzambi zake. Vivija yagale vibaba vibili va usage unogile utibwilizigwe na mavuta mbuli ya nhosa ya ndiya na mavuta selusi imoja ya nyhupa. ");
INSERT INTO kdc_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Vivija yagale huwa wabili hebu makinda mabili ga njiwa kamba vonda yadahe, kinda dimoja dokuwa mbuli ya nhosa ya kusegesa nzambi na diyagwe mbuli ya nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Siku da nane yamgalile mulava nhosa vinhu avo hana ulwivi lwa dihema da mting'hano mbuli ya kusegesigwa ukufita kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mulava nhosa yamsole ayo imwana ng'hondolo wa kimbigalo wa nhosa ya kulihila gehile hamoja na gaja gamavuta selusi imoja ya nyhupa na yavinule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Abaho yamchinje ayo imwana ng'hondolo wa kimbigalo wa nhosa ya kulihila gehile. Mulava nhosa yasole idamu kidogo yambake munhu ayo yotendigwa yang'ale mna digwiti da mkono wa kudila, na mna didole ng'hulu da mkono wa kudila na mdidole ng'hulu da mgulu wa mkono wa kudila. ");
INSERT INTO kdc_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mulava nhosa yagide mavuta kidogo mdiganza jake da mkono wa kumoso. ");
INSERT INTO kdc_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Abaho yammizile kwa kidole cha mkono wa kudila munhu ayo gago gamavuta geli mdiganza jake da mkono wa kumoso miyanza saba kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mulava nhosa yambake mavuta munhu ayo mdigwiti da mkono wa kudila, na mna didole ng'hulu da mkono wa kudila na mdidole ng'hulu da mgulu wa mkono wa kudila. Yambake hanhu aho hayambakile idamu ya nhosa ya kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mavuta gasigale mumkono wake yambake munhu ayo mdipala, ili yamtendele loholo da nzambi kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Abaho mulava nhosa yasole imoja mna iwa huwa wabili hebu iwa njiwa wabili kamba munhu ayo viyadahile kugala. ");
INSERT INTO kdc_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Imoja kokuwa kwa nhosa ya kusegesa nzambi na iyagwe mbuli ya nhosa ya kusoma moto. Vivija yalave nhosa ya ndiya, na mulava nhosa yamtendele loholo da nzambi kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Gano gago malagizo mbuli ya munhu yeli na utamu wa dikulu yolemelwa kugala nhosa ya kumtenda yang'ale.” ");
INSERT INTO kdc_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Mwahengila mwiisi ya Kanaani ayo iniwagwaa iwe yenu, niye notenda kimvuguya cha utamu wa dikulu choneke mna kiwambaza cha ng'anda imoja mna iisi yonda niwagwee iwe yenu. ");
INSERT INTO kdc_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Avo mwene ng'anda ayo yamulongele mulava nhosa kamba kimvuguya cha utamu wa dikulu choneka mng'anda yake. ");
INSERT INTO kdc_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mulava nhosa yalagize vinhu vose vili mng'anda ayo vilavigwe kunze yang'hali hanasonga kuikagula ing'anda, ili kutenda vinhu avo vose sikuvifite. Abaho mulava nhosa yengile mng'anda ayo yaikagule. ");
INSERT INTO kdc_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Yakikagule goya kimvuguya acho, na kamba choneka mna ikiwambaza na kitenda madoa ga langi ya ukole hebu ndung'hu na kamba madoa gago gengila mna ikiwambaza, ");
INSERT INTO kdc_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","baho mulava nhosa yalawe kunze na yaihinde ng'anda ayo kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Siku da saba mulava nhosa yabwele yaikagule ng'anda ayo kabili. Kamba kimvuguya acho chenela mna kiwambaza, ");
INSERT INTO kdc_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","yalagize gamabwe geli na ikimvuguya galavigwe gasigwe hanhu hafitile kunze ya dibuga. ");
INSERT INTO kdc_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Dikando da ing'anda ayo dikwatigwe na ditimbwisi jasigwe hanhu hafitile kunze ya dibuga. ");
INSERT INTO kdc_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Abaho wasole mabwe gayagwe wazenge hanhu aho na wakuluge dikando kabili. ");
INSERT INTO kdc_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Kamba kimvuguya acho choneka kabili viwamambukize kugasegesa gamabwe na kukwata dikando na kukuluga kabili, ");
INSERT INTO kdc_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","mulava nhosa yeze kuikagula. Kamba kimvuguya acho chenela mng'anda, baho acho chokuwa kimvuguya cha utamu na ng'anda ayo yokuwa ifita. ");
INSERT INTO kdc_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ng'anda ayo ituligwe na mabwe gake na dikando na mizengo yake vigaligwe hanhu hafitile kunze ya dibuga. ");
INSERT INTO kdc_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Vivija munhu yoyose yonda yengile mng'anda ayo kipindi viihindigwe kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Munhu yoyose yonda yawase hebu kudila mng'anda ayo yafuwe viwalo vake. ");
INSERT INTO kdc_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Lakini kamba mulava nhosa yahaikagula ng'anda ayo na kona kamba ikimvuguya hakibwelile kabili mng'anda ayo viwakuluge dikando, baho yawalongele wanhu kamba ng'anda ayo ing'ala, kwavija ikimvuguya kisegela. ");
INSERT INTO kdc_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ili kutenda ng'anda ayo ing'ale, mwene ng'anda yagale ndege wabili hamoja na kibimhi cha biki da mwelezi na sufi ndung'hu na bunho da hisopo. ");
INSERT INTO kdc_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Yamchinje ndege imoja mwiinongo ili na mazi ganogile ga nzasa. ");
INSERT INTO kdc_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Abaho yasole ikibimhi cha dibiki da mwelezi na dibunho da hisopo na isufi ndung'hu hamoja na ija indege iyagwe mgima na yavigele vose mwiidamu ya ija indege yachinjigwe. Abaho yaimize idamu mng'anda ayo miyanza saba. ");
INSERT INTO kdc_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Vino avo vonda yaitende ng'anda ayo ing'ale kwa idamu ya ndege, na mazi ganogile ga nzasa na ndege yeli mgima na ikibimhi cha biki da mwelezi na bunho da hisopo na sufi ndung'hu. ");
INSERT INTO kdc_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ija indege yeli mgima yamulekese yachole mmigunda kunze ya dibuga. Vino avo vonda yailohole ing'anda ayo, nayo yokuwa ing'ala. ");
INSERT INTO kdc_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Gano gago malagizo ga utamu wa dikulu, ");
INSERT INTO kdc_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na kimvuguya kili mviwambaza va ng'anda hebu minyela nyela ili mkiwalo, ");
INSERT INTO kdc_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","pute hebu uvimbe hebu punye, ");
INSERT INTO kdc_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ili mujuwe kinhu gani kifitile na kinhu gani king'alile. Avo, gano gago malagizo ga ivitamu avo vose.” ");
INSERT INTO kdc_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Walongele vino wanhu wa Izilaeli, ‘Mbigalo yoyose yahalava udusi, udusi awo ufita. ");
INSERT INTO kdc_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Udusi awo uwe ogendelela kulawa hebu uhaleka kulawa mbigalo ayo kokuwa kafita, udusi awo omtenda yafite. ");
INSERT INTO kdc_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Lusazi londa yawasile mbigalo ayo hebu kigoda chonda yakalile chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Munhu yoyose yonda yakwase lusazi lwa mbigalo ayo yafuwe viwalo vake na yakoge na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Munhu yoyose yonda yakalile kinhu kiyakalile mbigalo ayo yolawa na udusi yafuwe viwalo vake na yakoge, na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Munhu yoyose yonda yamkwase mbigalo yolawa na udusi yafuwe viwalo vake na yakoge, na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Mbigalo yolawa na udusi yahamtemela mate munhu iyagwe munhu ayo yafuwe viwalo vake na yakoge na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kwembe jojose donda yakalile kumgongo wa mnyama dokuwa difita. ");
INSERT INTO kdc_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Munhu yoyose yonda yakwase kinhu kiyakalile mbigalo ayo kokuwa kafita mbaka ichungulo. Munhu yonda yapape kinhu acho yafuwe viwalo vake na yakoge, na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Mbigalo yoyose yolawa na udusi yahamkwasa munhu yang'hali hanasunha makono gake, munhu ayo yakwasigwe yafuwe viwalo vake na yakoge na kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Nongo yoyose yonda yakwase mbigalo ayo, ituligwe. Lakini kiya chochose cha mbiki kisunhigwe kwa mazi. ");
INSERT INTO kdc_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Mbigalo yoyose yahalawa na udusi na yahahonyigwa, mbigalo ayo yabete mbaka siku saba zishe abaho yasegesigwe ukufita kwake. Yafuwe viwalo vake na yakoge mazi ga lwanda na heyo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Siku da nane yagale huwa wabili hebu makinda mabili ga njiwa hana ulwivi lwa dihema da mting'hano kuulongozi wa Mndewa Imulungu na yamgwee mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mulava nhosa yawalave nhosa, imoja kwa nhosa ya kusegesa nzambi, iyagwe kwa nhosa ya kusoma moto. Baho mulava nhosa komtendela loholo da nzambi kuulongozi wa Mndewa Imulungu na kumsegesela ukufita kwake mbuli ya kulawa udusi. ");
INSERT INTO kdc_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Mbigalo yoyose yahalawa na chelesi, yakoge lukuli lose, na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kiwalo chochose hebu ng'hwembe yahalagalilwa na chelesi kifuwigwe, na chokuwa kifita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kamba mbigalo yahawasa na mtwanzi, na kalava chelesi baho wose wabili wakoge na okuwa na wafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Mtwanzi yoyose yotumika, kokuwa kafita kwa siku saba. Munhu yoyose yonda yamkwase mtwanzi ayo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kinhu chochose kiyowasila mna ikipindi viyotumika chokuwa kifita, na kinhu chochose chonda yakikalile chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Munhu yoyose yonda yakwase lusazi lwake yafuwe viwalo vake na yakoge na kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Munhu yoyose yonda yakwase kinhu kiyakalile mtwanzi ayo, yafuwe viwalo vake na yakoge na kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Munhu yoyose yonda yakwase kinhu chochose kiyawasile hebu kukalila mtwanzi ayo, kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kamba mbigalo yahamuwasa mtwanzi ayo na idamu ya mtwanzi ayo yomtenda mbigalo ayo yavuluduke hana gamaungo gake madeke, avo mbigalo ayo kokuwa kafita kwa siku saba. Lusazi lolose londa yawasile mbigalo ayo lokuwa lufita. ");
INSERT INTO kdc_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Kamba mtwanzi yahatumika kwa siku nyingi ng'hani kubanza viiwaga hebu kotumika mna ikipindi siyo chake baho kogendelela kukala yafitile kipindi chose viyotumika. ");
INSERT INTO kdc_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Lusazi lolose luyowasila mtwanzi ayo kipindi chose acho hebu kigoda kiyokalila, chokuwa kifita kamba viiwaga kipindi viyotumika. ");
INSERT INTO kdc_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Munhu yoyose yonda yakwase vinhu avo kokuwa kafita na yafuwe viwalo vake na kukoga, na heyo kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Mtwanzi ayo yahaleka kutumika, yabete mbaka zishe siku saba ili yatendigwe yang'ale, na zahesha siku azo saba kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Siku da nane yasole huwa wabili hebu makinda mabili ga njiwa na yamgalile mulava nhosa hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mulava nhosa yamulave imoja kwa nhosa ya kusegesa nzambi na iyagwe kwa nhosa ya kusoma moto. Baho mulava nhosa komtendela loholo da nzambi kuulongozi wa Mndewa Imulungu ili kumsegesela ukufita kwake mbuli ya kutumika. ");
INSERT INTO kdc_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Vino avo vonda muwazume wanhu wa Izilaeli mbuli ya ukufita kwao, ili sikuwadifitize hema jangu ding'alile dili hagati ya hewo kipindi viwokwingila mumo akuno wafita, wahatenda vivo okomigwa. ");
INSERT INTO kdc_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“ ‘Dino dijo lagizo kwa mbigalo yafitile kwavija kolawa udusi hebu kolava chelesi. ");
INSERT INTO kdc_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Vivija kwa mtwanzi yafitile kwavija kotumika, na kwa mbigalo hebu mtwanzi yoyose yafitile kwavija kolawa na kinhu chochose na vivija kwa mbigalo yafitile kwavija kamuwasa mtwanzi yotumika.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Viwafile wana wabili wa Haluni kipindi viwamkwesele behi Mndewa Imulungu, Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Mulongele ndugu yako Haluni sikuyengile hanhu hong'ala ng'hani kukisogo cha panziya kipindi halondigwa kwingila, sikuyengile hanhu aho kwavija aho honda nilawilile mdiwingu uchanha ya ngubiko ya disanduku da lagano. Yahalema kofa. ");
INSERT INTO kdc_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Haluni yahalonda kwingila hanhu hong'ala ng'hani tanhu yalave nhosa ya bofu bigalo da ng'ombe kwa nhosa ya kusegesa nzambi na ng'hondolo mbigalo kwa nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Yakoge lukuli lose abaho yavale viwalo ving'alile. Yengile hanhu aho kuno kavala viwalo avo ving'alile, kanzu da kitani na mgati yavale kaputula ya kitani na yaifunge mkwiji wa kitani na kilemba. ");
INSERT INTO kdc_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Wanhu wa Izilaeli wamgalile mbuzi wabili wa kimbigalo kwa nhosa ya kusegesa nzambi na wamgalile ng'hondolo wa kimbigalo imoja kwa nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Haluni yamulave ayo ing'ombe wa kimbigalo kwa nhosa ya kusegesa nzambi zake mwenyego, na kutenda loholo da nzambi zake na wanhu wa mng'anda mmwake. ");
INSERT INTO kdc_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Abaho yawasole iwambuzi wabili yawagale kwa Mndewa Imulungu hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Yabwanhe simbi mbuli ya awo iwambuzi wabili, simbi ya ichanduso mbuli ya Mndewa Imulungu na ya kabili mbuli ya Azazeli. ");
INSERT INTO kdc_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Haluni yamsole ija imbuzi yalagalilwe na simbi mbuli ya Mndewa Imulungu, yamulave nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Lakini mbuzi ija yalagalilwe na simbi mbuli ya Azazeli yalavigwe kwa Mndewa Imulungu kuno yang'hali mgima ili yatende loholo da nzambi na mulava nhosa yamuleke mbuzi ayo yachole kuluwala ili kusegesa nzambi za wanhu. ");
INSERT INTO kdc_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Haluni yamsole ing'ombe wa nhosa ya kusegesa nzambi zake mwenyego ili yatende loholo da nzambi mbuli yake mwenyego na mbuli ya wanhu wa mng'anda mmwake, abaho yamchinje ing'ombe ayo. ");
INSERT INTO kdc_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Abaho yasole kiya cha kuhalila moto na yahale makala muupango wa nhosa kuulongozi wa Mndewa Imulungu na vivija yasole ubani udundigwe vinogile, yadehe maganza mabili yavigale hanhu hong'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Abaho, yaugele awo uubani mna gamakala kuulongozi wa Mndewa Imulungu, na yosi da awo uubani difililikile hana ingubiko ya disanduku da lagano, ili sikuyone abaho yafe. ");
INSERT INTO kdc_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yasole idamu kidogo ya ayo ing'ombe na yaimize kwa kidole chake mwambu wa kudilawila zuwa uchanha ya ingubiko ya disanduku da lagano, abaho yaimize kuulongozi wa disanduku da lagano miyanza saba. ");
INSERT INTO kdc_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Abaho yamchinje ija imbuzi wa nhosa ya kusegesa nzambi za wanhu wose. Idamu ya mbuzi ayo yengile nayo mgati hanhu hong'ala ng'hani na yatende kamba viyatendile kwa damu ya ing'ombe, yaimizile uchanha ya ingubiko ya disanduku da lagano na kuulongozi wa disanduku. ");
INSERT INTO kdc_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Vino vivo vonda yatende loholo mbuli ya hanhu hong'ala ng'hani na kwa mbuli ya ukufita kwao na mbuli ya gehile na nzambi za wanhu wa Izilaeli. Vivija vivo vonda yatende mbuli ya dihema da mting'hano dizengigwe hagati ya wanhu awo wafitile. ");
INSERT INTO kdc_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kipindi Haluni kolava nhosa ya loholo mbuli ya nzambi zake mwenyego na wanhu wa mng'anda mmwake na wanhu wose wa Izilaeli, munhu yoyose sikuyengile mdihema da mting'hano mbaka vonda yamambukize na kulawa kunze. ");
INSERT INTO kdc_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Abaho yalawe na kuchola kuna uupango wa nhosa uli kuulongozi wa Mndewa Imulungu na yaulohole. Yasole damu kidogo ya ija ing'ombe na imbuzi na yabake zimhembe za upango wa kulavila nhosa banzi zose. ");
INSERT INTO kdc_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Yamize idamu muupango kwa kidole miyanza saba kwa nzila ayo koulava kwa Mndewa Imulungu na koutenda ung'ale kwa kusegesa ukufita kwa wanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Haluni yahamambukiza kulohola ihanhu hong'ala ng'hani na dihema da mting'hano na uupango wa nhosa, abaho yamulave ija imbuzi kwa Azazeli kuno yang'hali mgima. ");
INSERT INTO kdc_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Haluni yeke makono gake mdipala da ayo imbuzi yeli mgima na yatambule nzambi zose za wanhu wa Izilaeli, gehile gao na ubananzi wao wose na yawike mdipala da ayo imbuzi. Abaho yamulekese ayo imbuzi yachole kuluwala kuno kogaligwa na munhu yasaguligwe kwa sang'hana ayo. ");
INSERT INTO kdc_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Munhu ayo yamuleke mbuzi ayo yachole kuluwala hanhu kuduhu wanhu kuno kapapa nzambi zao zose. ");
INSERT INTO kdc_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Abaho Haluni imulava nhosa yengile mna dihema da mting'hano na yasaule viwalo viyengile navo hanhu hong'ala ng'hani na yavileke mumo. ");
INSERT INTO kdc_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Yakoge mumo mgati ya hanhu hong'ala na yavale viwalo vake. Abaho yalawe kunze yalave nhosa ya kusoma moto na ya kusegesa nzambi zake na nzambi za wanhu wose ili kulohola nzambi zake na nzambi za wanhu wose. ");
INSERT INTO kdc_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Vivija yagasome moto gamavuta ga imnyama wa nhosa ya kusegesa nzambi muupango wa kulavila nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Munhu ija yamgalile ija imbuzi kwa Azazeli, tanhu yafuwe viwalo vake na kukoga abaho kodaha kubwela mwiing'hambi. ");
INSERT INTO kdc_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ija ing'ombe na imbuzi walavigwe nhosa ya kusegesa nzambi, awo idamu yao igaligwe hanhu hong'ala ng'hani ili kutenda loholo da nzambi, mitufi yao igaligwe kunze ya ing'hambi na isomigwe moto. Ng'hwembe zao na zinyama na mavi gao, vose visomigwe moto. ");
INSERT INTO kdc_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Munhu yonda yaisome moto imitufi ayo yavifuwe viwalo vake na yakoge, abaho kodaha kubwela mwiing'hambi. ");
INSERT INTO kdc_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Dino lagizo da siku zose, siku da longo da mwezi wa saba, mweye wenyego na hata wageni zenu mufunge kuja na sikumutende sang'hano. ");
INSERT INTO kdc_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tendeni vivo kwavija siku dijo motendeligwa loholo da nzambi, musunhigwe nzambi zenu, na mweye mokala kuno mung'ala kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Siku dijo dokuwa siku da kubwihila, na mufunge kuja, na mudigoge lagizo dino siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mulava nhosa yagidiligwe gamavuta na kulavigwa kwa Mndewa Imulungu yasolile sang'hano ya tatake, ayo yonda yatende loholo da nzambi kuno kavala iviwalo ving'alile va kitani. ");
INSERT INTO kdc_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Na heyo yatende loholo da nzambi mbuli ya hanhu hong'ala ng'hani na mbuli ya dihema da mting'hano na mbuli ya upango wa nhosa, na mbuli ya walava nhosa na wanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Dino dokuwa lagizo da siku zose, molondigwa mudigoge ili mutende loholo da nzambi zose za wanhu wa Izilaeli mwanza umoja kila mwaka.” Musa katenda kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Mulongele Haluni na wanage na wanhu wose wa Izilaeli mbuli zino, ");
INSERT INTO kdc_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘Kamba munhu yoyose kumwenu yahamulava nhosa ng'ombe hebu mwana ng'hondolo hebu mbuzi, mgati hebu kunze ya ing'hambi, ");
INSERT INTO kdc_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","na koleka kumgala mnyama ayo hana ulwivi lwa dihema da mting'hano ili yalavigwe nhosa kwa Mndewa Imulungu kuulongozi wa hanhu hong'ala, munhu ayo katenda nzambi ya kwita damu, kwavija keta damu avo yabaguligwe na wanhu wake. ");
INSERT INTO kdc_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kilamuso cha lagizo dino kuwa wanhu wa Izilaeli olondigwa wagale wanyama walondigwe kulavigwa nhosa mmigunda na wawagale kwa Mndewa Imulungu, na mulava nhosa yeli hana ulwivi lwa dihema da mting'hano, yawachinje na kumulavila Mndewa Imulungu nhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Abaho mulava nhosa yaumizile damu upango wa nhosa uli hana ulwivi lwa dihema da mting'hano na kugasoma moto gamavuta gawe mnung'ho umnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Avo wanhu wa Izilaeli waleke kuvilavila nhosa vinyamkela vikoneka kamba mbuzi, mbuli iwatendile wamuleke Imulungu kamba munhu yotenda ugoni. Lagizo dino dokuwa da siku zose kwa ulelo wao wose.’ ");
INSERT INTO kdc_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Walongele vino, ‘Munhu yoyose kumwenu, yawe munhu wa Izilaeli hebu mgeni yokala hamoja na mweye, yahalava nhosa ya kusoma moto hebu nhosa ziyagwe, ");
INSERT INTO kdc_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na hazigala hana ulwivi lwa dihema da mting'hano kwa Mndewa Imulungu, munhu ayo yabaguligwe na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Munhu yoyose wa Izilaeli hebu mgeni yokala kumwao yoja damu, niye Mndewa Imulungu nomgevuzikila munhu ayo na nombagula na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kwavija ugima wa kiumbe chochose wa mwiidamu na niwalagiza mulave damu muupango wa nhosa kutenda loholo da nzambi mbuli ya ugima wenu, kwavija damu ayo ilohola nzambi kwa ugima wa wanhu. ");
INSERT INTO kdc_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Lekaavo niwalagiza wanhu wa Izilaeli vino, “Munhu yoyose kumwenu hebu mgeni yokala kumwenu sikuyaje damu.” ");
INSERT INTO kdc_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Munhu yoyose kumwenu mweye wanhu wa Izilaeli hebu mgeni yokala kumwenu yahachola kusaka wanyama hebu ndege, yete idamu hasi na yaifukie na umsanga. ");
INSERT INTO kdc_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kwavija ugima wa kila kiumbe wa mwiidamu, lekaavo niwalagiza wanhu wa Izilaeli vino, “Sikumuje damu ya kiumbe chochose kwavija ugima wa kiumbe chochose wa mwiidamu. Munhu yoyose yonda yaje damu kobaguligwa na wanhu zake.” ");
INSERT INTO kdc_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Munhu yoyose, yawe mwenekae hebu mgeni yahaja nyama ya mnyama yafile mwenyego hebu yakomigwe na mnyama wa kumuhulo, munhu ayo yafuwe viwalo vake na yakoge, na heyo kokuwa kafita mbaka ichungulo, abaho kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Lakini kamba hafuwa viwalo vake na kukoga, munhu ayo kogaya kwa mbuli ayo.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Walongele vino wanhu wa Izilaeli, ‘Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Sikumutende kamba viwotenda wanhu wa isi ya Misili kuko kumulawile, vivija sikumutende kamba viwotenda wanhu wa isi ya Kanaani kuko kuniwagala. Sikumukweleleze viwotenda hewo. ");
INSERT INTO kdc_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mweye mugoge malagizo gangu na mukweleleze gaja goniwalongela, niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Gogeni malagizo gangu na gaja goniwalongela kwavija munhu yogagoga kokuwa mgima kubitila gago, niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Munhu yoyose sikuyamuwase ndugu yake wa usungu, niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Sikuumgele kinyala tatako kwa kumuwasa mamako, sikuumuwase mamako yakulelile. ");
INSERT INTO kdc_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Sikuumuwase mwehe wa tatako, mbuli ayo yomgela kinyala tatako. ");
INSERT INTO kdc_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Sikuumuwase lumbu jako, yawe mndele wa tatako hebu wa mamako, yawe kakulila mng'anda imoja na gweye hebu kakulila kunze. ");
INSERT INTO kdc_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Sikuumuwase mzukulu wako, yawe mzukulu wako yaleligwe na mwanago wa kimbigalo hebu mzukulu wako yaleligwe na mwanago wa kitwanzi, mbuli ayo yokugela kinyala. ");
INSERT INTO kdc_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Sikuumuwase mndele yaleligwe na mamako wa kuvikila, yasoligwe na tatako, mndele ayo lumbu jako. ");
INSERT INTO kdc_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Sikuumuwase shangazi yako, kwavija ayo ni lumbu wa tatako. ");
INSERT INTO kdc_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Sikuumuwase mamako mkulu hebu mamako mdodo, kwavija ayo ni ndugu wa mamako. ");
INSERT INTO kdc_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Sikuumuwase mwehe wa tatako mkulu hebu mwehe wa tatako mdodo, kwavija ayo nayo vivija mamako. ");
INSERT INTO kdc_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Sikuumuwase mwehe wa mwanago, kwavija ayo mkwe yako. ");
INSERT INTO kdc_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Sikuumuwase mwehe wa mdodo wako hebu mkulu wako, kwavija ayo mulamu wako. ");
INSERT INTO kdc_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Sikuumuwase mtwanzi yoyose na imwana hebu na wazukulu zake. Kwavija awo ndugu zake, wahatenda vivo kotenda gehile. ");
INSERT INTO kdc_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Sikuumsole mkulu wa mwehe wako hebu mdodo wa mwehe wako, kipindi mwehe wako yang'hali mgima. ");
INSERT INTO kdc_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Sikuumuwase mtwanzi mna ikipindi chake cha kutumika. ");
INSERT INTO kdc_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Sikuumuwase mwehe wa miyago, wahatenda avo koifitiza mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Sikuumulave nhosa mwanago yoyose kwa imulungu yokemigwa Moleki, kwavija wahatenda vivo kodikudula twaga jangu niye Imulungu wako. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Sikuumuwase mbigalo miyago kamba viutenda kwa mtwanzi, mbuli ayo yonigevuza niye Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Sikuumuwase mnyama kwavija koifitiza mwenyego. Na mtwanzi sikuyaigale mwenyego kuwasigwa na mnyama kwavija mbuli ayo kilozo. ");
INSERT INTO kdc_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Sikumuifitize kwa kutenda mbuli azo, kwavija mbuli azo zizo zowotenda wanhu wa isi zili kuulongozi wenu na niye nowawinga ili mukale mweye. ");
INSERT INTO kdc_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Isi yao ifitizigwa na niye niitagusa, nayo iwadeka wanhu okala mumo. ");
INSERT INTO kdc_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Lakini mweye na iwageni okala kumwenu gagogeni malagizo gangu na gaja goniwalongela na sikumutende mbuli kamba zizo. ");
INSERT INTO kdc_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kwavija nzambi azo wazitenda wanhu wakalile mwiisi ayo, na hewo waifitiza isi ayo. ");
INSERT INTO kdc_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Avo mwahaifitiza isi ayo yowadeka kamba viiwadekile wanhu wakalile mumo. ");
INSERT INTO kdc_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Munhu yoyose yotenda mbuli kamba azo kobaguligwa na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Gogeni gaja ganiwalagize, sikumukweleleze gaja gawatendile wanhu wakalile mwiisi ayo mweye hamunakwiza, mwahatenda vivo moifitiza wenyego. Niye ayo Mndewa Imulungu wenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Walongele wanhu wose wa Izilaeli, ‘Molondigwa mung'ale kamba niye Mndewa Imulungu wenu vining'ala. ");
INSERT INTO kdc_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Kila munhu yamtegeleze tatake na mamake na yagoge malagizo ga siku za kubwihila. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Sikumundeke niye na kuvitambikila vinyago na sikumutende vinyago va imilungu ya zuma. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Mwahamulavila Mndewa Imulungu nhosa za kugala kuilumba, mulave kamba viilondigwa ili zitogoligwe. ");
INSERT INTO kdc_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nhosa ayo idigwe siku dijo hebu imitondo yake. Kinhu chochose chonda kisigale mbaka siku da kadatu kisomigwe moto. ");
INSERT INTO kdc_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kamba nhosa ayo yodigwa mbaka siku da kadatu haitogoligwa bule. ");
INSERT INTO kdc_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Munhu yonda yaje nyama ayo kogaya kwa mbuli ayo kwavija kakifitiza kinhu king'alile kwa Mndewa Imulungu. Munhu ayo yabaguligwe na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Wahasenga ndiya mumgunda wako, sikuusenge mbaka mumgwazo wa umgunda na sikuubwele kukisogo kusalata vija visigale. ");
INSERT INTO kdc_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Sikuubwele kukisogo kusalata kila kinhu mumgunda wa mizabibu na sikuudondole zabibu zilagale hasi walekele wakiwa na wageni. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Sikuwibe. “ ‘Sikuumbunyike miyago. “ ‘Sikuulonge uvizi. ");
INSERT INTO kdc_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Sikuuiduwile kwa uvizi kwa twaga jangu, wahatenda vivo kodikudula twaga jangu. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Sikuumonele miyago hebu kumwibila. “ ‘Fungu da kibaluwa wako sikudikale kumwako mbaka imitondo. ");
INSERT INTO kdc_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Sikuumduwile mvugu hebu kumwikila gogo mnzila msuwameso, lakini unidumbe niye Imulungu wako, niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Wahawatagusa wanhu wataguse goya, sikuumnogele mkiwa hebu kumdumba munhu yeli na cheo. Lakini uwalamule kamba viilondigwa. ");
INSERT INTO kdc_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Sikuwange mzing'anda za wanhu na kuwatenda wanhu wagombe kwa kuwalongela mbuli za uvizi. “ ‘Sikuuwike ugima wa miyago mdizumozumo da ifa. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Sikuumwihile ndugu yako, lakini uilumbe na heyo ili sikuutende nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Sikuulihe gehile hebu kuwa na mfundo na munhu yoyose mna iwanhu wako lakini umnogele miyago kamba viuinogela mwenyego. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Gagogeni malagizo gangu gano. “ ‘Sikuutogole fugo yako ikweligwe na wanyama wa aina iyagwe. “ ‘Sikuuhande mumgunda wako mbeyu za aina mbili. “ ‘Sikuuvale kiwalo kitendigwe kwa nyuzi za aina mbili. ");
INSERT INTO kdc_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Mbigalo yahawasa na mtwanzi mtumwa yang'hali hanagomboligwa na kalaviligwa vilama na mbigalo iyagwe, wanhu wawataguse wose wabili, lakini sikuwakomigwe kwavija mtwanzi ayo yang'hali hanalekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mbigalo ayo yagale mdihema da mting'hano nhosa ya ng'hondolo mbigalo mbuli ya kulihila gehile, na nhosa ayo ilavigwe kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mulava nhosa yamtendele loholo da nzambi kwa ng'hondolo ayo kuulongozi wa Mndewa Imulungu, na nzambi yake yogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Mwahavika mwiisi ya Kanaani na kuhanda mibiki ya matunda, matunda gago hamulondigwa kugaja kwa miyaka midatu. ");
INSERT INTO kdc_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mwaka wa ikane matunda gago gokuwa gang'ala na mugalave kwa Mndewa Imulungu kamba nhosa ya kumgwaa nhogolwa. ");
INSERT INTO kdc_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Lakini mwaka wa tano modaha kugaja gamatunda, mwahatenda gano gose mibiki yenu ya matunda yolela matunda ng'hani. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Sikumuje nyama yoyose kuno ing'hali na damu. “ ‘Sikumulagule hebu kuwa wahawi. ");
INSERT INTO kdc_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Sikumusenye bwenzi na sikumubee ndevu zenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Sikumuichanje chanje mzing'huli zenu mbuli ya kumuyalalila munhu yafile hebu kwika kilaguso mzing'huli zenu. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Sikuumnange mndele wako kwa kumtenda mgoni, ili isi yose sikuimeme ugoni na kumema gehile. ");
INSERT INTO kdc_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Gagogeni malagizo ga siku ya kubwihila na hadumbeni hanhu hong'ala. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Sikumuchole kwa wanhu olagula kwa mizimu hebu wahawi ili mulaguliligwe baho moifitiza. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Wategeleze wanhu wavele na uwagwee ukulu. Unidumbe niye Imulungu wako, niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Munhu baki yaheza mwiisi yako sikuumtendele gehile. ");
INSERT INTO kdc_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Munhu baki ayo yakale kumwako kamba mwenekae na gweye umnogele kamba viuinogela mwenyego, kwavija hata gweye kukala munhu baki mwiisi ya Misili. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Sikuuwabunyike wayago mna ivinhu vako va kupimila va utali na uzito na kumema. ");
INSERT INTO kdc_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Molondigwa mutumie mizani ilondigwa na vipimo vilondigwa. Niye ayo Mndewa Imulungu wenu niwalavile mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Molondigwa mugagoge malagizo gangu gose na gaja goniwalongela. Niye ayo Mndewa Imulungu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Walongele vino wanhu wa Izilaeli, ‘Munhu yoyose mna iwanhu wa Izilaeli hebu munhu baki yokala kumwenu, yomulava nhosa mwanage kwa imulungu Moleki, munhu ayo yakomigwe. Wanhu wamkome kwa kumtowa mabwe. ");
INSERT INTO kdc_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Niye mwenyego nomgevuzikila munhu ayo na kumbagula na wanhu zake kwavija kamulava imoja wa wanage nhosa kwa imulungu Moleki na avo kahafitiza hanhu hong'ala na twaga jangu ding'ala. ");
INSERT INTO kdc_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kamba wanhu wa aho omuleka munhu ayo na hawamkoma, ");
INSERT INTO kdc_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","niye mwenyego nomgevuzikila munhu ayo na wanhu wa mng'anda mmwake. Nowabagula na wanhu zao heyo mwenyego hamoja na wose oleka kunitamanila niye na kumcholela imulungu Moleki. ");
INSERT INTO kdc_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Kamba munhu yoyose yahawacholela walaguzi wa mizimu na wahawi na koleka kunitamanila niye, nomgevuzikila munhu ayo na nombagula na wanhu zake. ");
INSERT INTO kdc_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Avo ilaveni kumwangu na muwe wanhu wang'alile kwavija niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Gogeni malagizo gangu, niye ayo Mndewa Imulungu niwatenda mweye mung'ale. ");
INSERT INTO kdc_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Munhu yoyose yomduwila tatake hebu mamake yakomigwe. Kwavija kamduwila tatake hebu mamake avo ifa yake yokuwa mmakono gake mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Kamba mbigalo yahatenda ugoni na mwehe wa miyage, wose wabili wakomigwe. ");
INSERT INTO kdc_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Mbigalo yahamuwasa imoja wa wehe wa tatake, kamgela kinyala tatake, wose wabili wakomigwe. Ifa ya mbigalo ayo na mtwanzi ayo yokuwa mmakono gao wenyego. ");
INSERT INTO kdc_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Mbigalo yahamuwasa mwehe wa mwanage, wose wabili wakomigwe. Awo watenda kilozo avo ifa yao yokuwa mmakono gao wenyego. ");
INSERT INTO kdc_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Kamba mbigalo yahamuwasa mbigalo miyage kamba vija mtwanzi, wose wabili wakomigwe, kwavija watenda nzambi, ifa yao yokuwa mmakono gao wenyego. ");
INSERT INTO kdc_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Kamba mbigalo yahamsola mndele na mama munhu, mbuli ino iha ng'hani. Wose imbigalo na imndele na mamake wasomigwe moto, ili sikukuwe na nzambi hagati yenu. ");
INSERT INTO kdc_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Kamba mbigalo yahamuwasa mnyama yakomigwe heyo hamoja na ayo imnyama. ");
INSERT INTO kdc_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Mtwanzi yahamkwesela mnyama ili yawasigwe, wose wakomigwe, imnyama na imtwanzi. Ifa yao yokuwa mmakono gao wenyego. ");
INSERT INTO kdc_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Kamba mbigalo yoyose yahamsola lumbu jake, mndele wa mamake hebu wa tatake, na mndele ayo katogola kusoligwa na mbigalo ayo yeli lumbu jake, mbuli ayo kilozo, avo wabaguligwe na wanhu wao kwavija watenda mbuli igela kinyala. Ayo imbigalo kogaya kwa kutenda mbuli ayo. ");
INSERT INTO kdc_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Kamba mbigalo yahamuwasa mtwanzi kipindi cha kutumika kwake, wose wabili wabaguligwe, kwavija ayo imbigalo kakwasa ukutumika kwa mtwanzi na ayo imtwanzi kagubula kutumika kwake. ");
INSERT INTO kdc_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Sikuumuwase mamako mkulu hebu mamako mdodo na sikuumuwase shangazi yako, kwavija wao ni ndugu zako wa usungu, wanhu wose otenda vivo ogaya kwa nzambi zao. ");
INSERT INTO kdc_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Kamba munhu yahamuwasa mwehe wa tatake mkulu hebu mdodo, komgela kinyala tatake mkulu hebu mdodo, wose wabili ogaya kwa nzambi zao na wose wofa bila wana. ");
INSERT INTO kdc_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Mbigalo yahamuwasa mwehe wa ndugu yake, komgela kinyala ndugu yake, mbuli ayo ifita, wose wabili wofa bila wana. ");
INSERT INTO kdc_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Gagogeni malagizo gangu gose na gaja ganiwalongele, buleavo ako kuniwagala mna iisi, isi ayo yowadeka. ");
INSERT INTO kdc_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Sikumukweleleza mila za wanhu wa isi ayo, waniwawingile mgameso genu, kwavija watenda mbuli azo zose na niye nizihila mbuli azo. ");
INSERT INTO kdc_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Lakini niwalongela mweye, moihazi isi yao, nowagwaa mweye kamba uhazi wenu, isi imemile maziwa na uki, niye ayo Mndewa Imulungu wenu niwabagule mweye na wanhu wa isi ziyagwe ili muwe wanhu zangu. ");
INSERT INTO kdc_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Avo mujuwe kubagula, mnyama yafitile na mnyama yang'alile, ndege yafitile na ndege yang'alile. Sikumuifitize kwa kukwasa mnyama hebu ndege hebu chochose kitambala mwiisi kiniwalongele kamba kifita. ");
INSERT INTO kdc_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kwavija niye Mndewa Imulungu wenu ning'ala, niye niwabagula mweye mna wanhu wa isi ziyagwe ili muwe wanhu zangu, avo muwe wanhu ong'ala. ");
INSERT INTO kdc_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Mbigalo hebu mtwanzi yoyose yolagula hebu muhawi yakomigwe kwa mabwe. Ifa yao yokuwa mmakono gao wenyego.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mndewa Imulungu kamulongela Musa, “Walongele vino iwalava nhosa weli iwana wa Haluni, ‘Mulava nhosa sikuyaifitize mwenyego kwa kukwasa mtufi wa ndugu yake yafile, ");
INSERT INTO kdc_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ila kamba mtufi awo okuwa wa ndugu yake wa usungu, kamba vija mamake hebu tatake, mdodo wake hebu mkulu wake hebu mwanage wa ikimbigalo hebu wa ikitwanzi, ");
INSERT INTO kdc_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","hebu lumbu jake yang'hali kusoligwa iyokala mng'anda yake. ");
INSERT INTO kdc_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Sikuyaifitize kwa ifa ya munhu yeli na undugu nayo kwa kuisolela. ");
INSERT INTO kdc_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Mulava nhosa sikuyabee mvili zake hebu ndevu zake hebu kuichanja chanja mulukuli kulagusa koiyalala. ");
INSERT INTO kdc_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mulava nhosa yakale yang'alile, sikuyadifitize twaga da Imulungu wake, heyo kolava nhosa kwa Mndewa Imulungu avo yakale yang'alile. ");
INSERT INTO kdc_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Mulava nhosa sikuyasole mtwanzi yakalile mgoni hebu mtwanzi yasigwe hebu siyo mhambe, sikuyatende vivo kwavija heyo munhu yang'alile kwa Imulungu wake. ");
INSERT INTO kdc_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wanhu wamone mulava nhosa kamba kang'ala kwavija kolava nhosa ya ndiya kwa Mndewa Imulungu. Niye ayo Mndewa Imulungu, niye ning'ala na nowatenda wanhu zangu wang'ale. ");
INSERT INTO kdc_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Kamba mndele wa mulava nhosa mgoni, yasomigwe moto mbaka yafe, kwavija komgela kinyala tatake. ");
INSERT INTO kdc_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Mulava nhosa imkulu yoyose, kwavija heyo ayo imkulu hagati ya wayagwe, na heyo kagidiligwa mavuta gang'alile mdipala jake na kalavigwa kwa Mndewa Imulungu ili yavale viwalo ving'alile, avo sikuyaleke kubunha mvili zake hebu sikuyadege viwalo vake kwa kuiyalala. ");
INSERT INTO kdc_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Sikuyengile hanhu heli na mtufi wa munhu yafile. Sikuyaifitize hata kwa ifa ya tatake hebu mamake. ");
INSERT INTO kdc_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Sikuyasegele hanhu hong'ala ha Imulungu wake na kuhafitiza, kwavija kalavigwa kwa Mndewa Imulungu kwa kugidiligwa mavuta gangu gang'alile. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Mtwanzi yonda yamsole yawe mhambe. ");
INSERT INTO kdc_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Sikuyasole mtwanzi mgane hebu mtwanzi yasigwe hebu mtwanzi mgoni, lakini yasole mtwanzi mhambe kulawa mulukolo lwake mwenyego, ");
INSERT INTO kdc_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ili sikuyawafitize wanage mwenyego, niye ayo Mndewa Imulungu nimtenda heyo yang'ale.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Mulongele vino Haluni, ‘Munhu yoyose muulelo wako yeli na kilema mulukuli, halondigwa kwiza behi ya Mndewa Imulungu na kumulavila Mndewa Imulungu wake nhosa ya ndiya. ");
INSERT INTO kdc_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Munhu yoyose yeli na kilema, msuwameso, mbetembete na yeli kihanga kinangike, yeli na maungo matali kubanza viilondigwa, ");
INSERT INTO kdc_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","yeli na mgulu hebu mkono ubeneke. ");
INSERT INTO kdc_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Munhu yeli na kibiyongo, munhu mguhi ng'hani, yoleka kulola goya, munhu yavimbile, munhu yeli na uhele hebu munhu yelibule kimbigalo sikuyakwese kumulavila Mndewa Imulungu nhosa ya ndiya. ");
INSERT INTO kdc_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Munhu yoyose wa ulelo wa Haluni imulava nhosa, yeli na kilema sikuyeze behi kumulavila nhosa za kusoma moto, vivija sikuyeze behi kumulavila Imulungu nhosa ya ndiya. ");
INSERT INTO kdc_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Munhu ayo kodaha kuja ndiya ilavigwe kwa Imulungu wake, vinhu ving'ala na vija ving'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Lakini sikuyakwese behi ya panziya hebu uja uupango kwavija kana kilema ili sikuyahafitize hanhu hong'ala kwavija niye Mndewa Imulungu ayo niwatenda mweye mung'ale.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa kamulongela Haluni na wanage na wanhu wose wa Izilaeli mbuli azo zose. ");
INSERT INTO kdc_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Mulongele Haluni na wanage, wavigelegeze goya vinhu viwonigalila wanhu wa Izilaeli, na sikuwadikudule twaga jangu ding'ala. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Walongele vino, ‘Kamba imoja wa munhu wenu mna uulelo wenu ako kumwande kovikwesela kuno kafita vinhu ving'alile viwongalila niye Mndewa Imulungu wanhu wa Izilaeli, munhu ayo nombagula. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Munhu yoyose wa ulelo wa Haluni yahawa na utamu wa dikulu hebu kolava udusi sikuyaje vinhu ving'ala mbaka vonda yahone. Vivija kokuwa kafita kamba yahakwasa kinhu chochose kifitizigwe na mtufi wa munhu yafile hebu yolawa na chelesi, ");
INSERT INTO kdc_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hebu yahakwasa mng'onyo yoyose yafitile hebu munhu yoyose yodaha kumtenda munhu yafite. ");
INSERT INTO kdc_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Vivija kokuwa kafita mbaka ichungulo na halondigwa kuja ndiya ing'ala mbaka vonda yakoge. ");
INSERT INTO kdc_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Zuwa dahahonga baho kokuwa kang'ala. Abaho kodaha kuja ndiya ing'ala kwavija ayo iyo ndiya yake. ");
INSERT INTO kdc_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mulava nhosa sikuyaje nyama ya mnyama yoyose yafile mwenyego hebu mnyama yakomigwe na mnyama wa kumuhulo, sikuyaje na kuifitiza. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Avo walava nhosa wagagoge malagizo gangu ili sikuwatende nzambi na kufa. Niye ayo Mndewa Imulungu niwatenda wang'ale. ");
INSERT INTO kdc_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Munhu yoyose halawa muulelo wa iwalava nhosa halondigwa kuja ndiya ing'ala. Hata mgeni wa mulava nhosa hebu kibaluwa wake sikuyaje. ");
INSERT INTO kdc_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Lakini kamba mulava nhosa kamgula mtumwa ili yawe wake, ayo kodaha kuja na vivija waja iwatumwa waleleke mng'anda yake. ");
INSERT INTO kdc_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kamba mndele wa mulava nhosa kasoligwa na mbigalo halawa muulelo wa iwalava nhosa halondigwa kuja nhosa ya vinhu ving'ala. ");
INSERT INTO kdc_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Lakini kamba mndele wa mulava nhosa mgane hebu kasigwa na kabule wana na kabwela ukae kwa tatake na komtamanila tatake kamba viyakalile yang'ali hanasoligwa, aho kodaha kuja indiya iyogweleligwa tatake kamba mulava nhosa. Munhu yoyose halawa muulelo wa iwalava nhosa halondigwa kuja ndiya ino ing'ala. ");
INSERT INTO kdc_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Kamba munhu iyagwe yahaja ndiya ino ing'ala bila kujuwa, avo yamulihe mulava nhosa kamba sente ya ndiya ayo viili na yengeze asilimia malongo mabili ya sente ya ndiya ayo. ");
INSERT INTO kdc_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Mulava nhosa sikuyavifitize vinhu vija wanhu wa Izilaeli omulavila Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","kwa kuwatogolela waje ndiya ing'ala na kuwatenda watende gehile golondigwa kulihigwa. Niye ayo Mndewa Imulungu niwatenda mung'ale.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Mulongele Haluni na wanage iwolava inhosa na wanhu wose wa Izilaeli, ‘Kamba munhu yoyose kumwenu hebu mgeni yoyose yokala Izilaeli yahagala nhosa yake, iwe nhosa ya kutenda kiyalongile hebu nhosa ya kulonda mwenyego, ");
INSERT INTO kdc_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ili nhosa ayo itogoligwe, yagale ng'ombe wa kimbigalo hebu mbuzi mbigalo hebu ng'hondolo wa kimbigalo yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Munhu sikuyagale mnyama yoyose yeli na kilema kwavija nhosa ayo honda itogoligwe mbuli yake. ");
INSERT INTO kdc_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Munhu yoyose yahamulavila Mndewa Imulungu nhosa ya kugala kuilumba ili kutenda kija kiyalongile hebu nhosa ya kulonda mwenyego kulawa mdibumbila da fugo yake, yahalonda Mndewa Imulungu yaitogole, yagale mnyama yatelele, mnyama ayo sikuyawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Sikuumulavile Mndewa Imulungu mnyama yoyose halola hebu kilema hebu yabeneke hebu yolawa udusi hebu yeli na uhele hebu vilonda, awo sikuuwalave wawe nhosa ya kusoma moto muupango wa nhosa wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ng'ombe hebu mwana ng'hondolo yeli na maungo makulu hebu madodo kubanza viilondigwa kodaha kumulava nhosa ya kulonda mwenyego, lakini sikuumulave kamba nhosa ya kutenda kija kiulongile. ");
INSERT INTO kdc_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Mnyama yeli na mhumbu zilumizigwe hebu zihondigwe hebu zituligwe hebu zikanhigwe, sikuumulavile Mndewa Imulungu hebu kumulava nhosa mwiisi yako. ");
INSERT INTO kdc_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“ ‘Vivija sikuuwabokele wanyama kamba awo kulawa kwa wageni na kumulavila Mndewa Imulungu wako kamba nhosa ya ndiya. Wanyama awo wanavilema kwavija wakanhigwa avo hawatogoligwa bule mbuli yenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ng'ombe hebu ng'hondolo hebu mbuzi yahaleligwa yakale kwa mamake kwa siku saba. Lakini kusongela siku da nane modaha kumulavila Mndewa Imulungu kamba nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Lakini sikuumchinje ng'ombe hebu ng'hondolo siku dimoja hamoja na mwanage. ");
INSERT INTO kdc_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Wahamulavila Mndewa Imulungu nhosa ya kumgwaa nhogolwa, uilave kwa nzila yonda itende utogoligwe na heyo. ");
INSERT INTO kdc_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Nyama ya mnyama ayo idigwe siku dijo na sikumuisigase mbaka imitondo. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Gogeni malagizo gangu na mugakweleleze. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Sikumudikudule twaga jangu ding'ala, twaga jangu mudigelegeze kamba ding'ala hagati ya wanhu wa Izilaeli. Niye ayo Mndewa Imulungu niwatenda mung'ale. ");
INSERT INTO kdc_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Niye ayo niwalavile mwiisi ya Misili ili niwe Imulungu wenu. Niye ayo Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Walongele vino wanhu wa Izilaeli, ‘Zino azo nyimwilinyimwili ziyasagule Mndewa Imulungu, mweye molondigwa muzijuwe kamba zing'ala. ");
INSERT INTO kdc_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Mokuwa na siku sita za kusang'hana, lakini siku ya saba yokuwa siku ya kubwihila. Mwiisiku ayo sikumusang'hane, lakini muiting'hane kwa kutambika. Siku ayo yokuwa siku ya kubwihila ya Mndewa Imulungu, isi yoyose yonda mukale. ");
INSERT INTO kdc_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Zino azo siku za nyimwilinyimwili za Mndewa Imulungu, muiting'hane kamba viilondigwa mna zisiku zino zing'ala. ");
INSERT INTO kdc_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ichungulo ya siku ya longo na nne ya mwezi wa ichanduso musonge kudeng'helela nyimwilinyimwili ya Pasaka mbuli ya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Mwiisiku ya longo na tano ya mwezi awo musonge kudeng'helela nyimwilinyimwili ya magate hagageligwe hamila, avo kwa kipindi cha siku saba muje magate hagageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mwiisiku ya ichanduso ya siku azo saba sikumusang'hane, lakini muiting'hane kwa kutambika. ");
INSERT INTO kdc_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwa kipindi cha siku saba mmulavile nhosa za kusoma moto Mndewa Imulungu na mwiisiku ya saba muiting'hane hamoja kumtambikila na sikumusang'hane.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Walongele wanhu wa Izilaeli, ‘Kamba mwahengila mwiisi yonda niwagwee na mwahasenga, mgalileni mulava nhosa gaja gaichanduso kusengigwa. ");
INSERT INTO kdc_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Na imulava nhosa yavinule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu ili gatogoligwe mbuli yenu, mulava nhosa yagalave imitondo yake vonda imale siku ya kubwihila. ");
INSERT INTO kdc_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Mwiisiku ayo yonda mvinule uchanha kamba kilaguso cha kumulavila Mndewa Imulungu vivija mmulavile nhosa ya kusoma moto ya mwana ng'hondolo wa kimbigalo wa mwaka umoja yelibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Vivija mmulavile nhosa ya ndiya ya usage unogile mhishi imoja utibwilizigwe na mavuta, mmulavile Mndewa Imulungu kwa moto, na mnung'ho wake omnogeza. Vivija mmulavile divai nyhupa imoja kamba nhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kipindi mung'hali hamunamgalila nhosa azo Mndewa Imulungu, sikumuje gate jojose hebu kinhu kikanzingigwe hebu kinhu chochose kisengigwe sambi. Dino dijo lagizo jake kumwenu na kwa ulelo wenu wose, kokose konda mukale. ");
INSERT INTO kdc_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Kulawa siku ayo ya kubwihila, siku imumgalile gaja gaichanduso kusengigwa peteni mbaka gavike mawiki saba. ");
INSERT INTO kdc_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mna isiku ya malongo matano, imitondo yake ya siku ya kubwihila ya saba, mmulavile Mndewa Imulungu nhosa ya ndiya ya sambi. ");
INSERT INTO kdc_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kila ng'anda ilave magate mabili ili genuligwe uchanha kamba kilaguso cha kumulavila Mndewa Imulungu. Kila gate ditendigwe kwa mhishi imoja ya usage unogile na ugeligwe hamila, abaho mmulavile Mndewa Imulungu kamba nhosa ya gaja gasengigwe ichanduso. ");
INSERT INTO kdc_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Na mulave hamoja na gago gamagate wana ng'hondolo saba wa mwaka umoja welibule kilema chochose na bofu da kimbigalo da ng'ombe na ng'hondolo wa kimbigalo wabili. Wanyama awo okuwa nhosa ya kusoma moto hamoja na nhosa ya ndiya na nhosa ya king'waji. Mnung'ho wa nhosa azo omnogeza Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Vivija mmulavile mbuzi imoja mbigalo kamba nhosa ya kusegesa nzambi, na mulave wana ng'hondolo wabili wa kimbigalo weli na mwaka umoja kamba nhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mulava nhosa yawenule uchanha awo iwang'hondolo wabili kamba kilaguso cha kumulavila Mndewa Imulungu hamoja na gamagate ga ndiya ya ichanduso kusengigwa. Nhosa azo zing'ala kwa Mndewa Imulungu na zokuwa za iwalava nhosa waiyeka. ");
INSERT INTO kdc_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Siku dijo walongele wanhu waiting'hane kwa mting'hano ung'alile na sikumusang'hane, dino dokuwa lagizo da siku zose kwa ulelo wenu wose kokose konda mukale. ");
INSERT INTO kdc_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Wahasenga mumgunda wako, sikuusenge mbaka kumgwazo wa mgunda wako hebu kubwela kukisogo kusalata vija visigale, walekele wakiwa na wanhu baki, niye ayo Mndewa Imulungu wako.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Walongele wanhu wa Izilaeli, ‘Siku ya ichanduso ya mwezi wa saba muhumule, ayo iwe siku ya kukumbuka kuno motowa mhalati na wanhu wose muiting'hane na kumtambikila Mndewa. ");
INSERT INTO kdc_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Sikumutende sang'hano yoyose, lakini mmulavile Mndewa Imulungu nhosa ya kusoma moto.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Siku ya longo ya mwezi awo yokuwa siku ya kulohola nzambi zenu, siku ayo yokuwa siku ya mting'hano ung'alile na mufunge kuja na mmulavile Mndewa Imulungu nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Sikumutende sang'hano yoyose, kwavija siku ayo yokuwa siku ya kulohola nzambi, ili nzambi zenu zisegesigwe kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Munhu yoyose yoleka kufunga kuja siku ayo, yabaguligwe na wanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Munhu yoyose yonda yasang'hane siku ayo nomkoma. ");
INSERT INTO kdc_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Sikumusang'hane sang'hano yoyose. Lagizo dino dokuwa kwa ulelo wenu wose, kokose konda mukale. ");
INSERT INTO kdc_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Siku ayo yokuwa siku ya kubwihila na molondigwa mufunge kuja, kusongela ichungulo ya siku ya tisa ya mwezi awo mbaka ichungulo ya siku ya longo. Molondigwa muigoge siku ya kubwihila.” ");
INSERT INTO kdc_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Walongele wanhu wa Izilaeli, ‘Mna isiku ya longo na tano ya mwezi wa saba, mumtendele Mndewa Imulungu nyimwilinyimwili ya vibanda na yokuwa kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Siku ya ichanduso mutende mting'hano ung'alile na sikumutende sang'hano yoyose. ");
INSERT INTO kdc_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwa siku saba mmulavile Mndewa Imulungu nhosa zilavagwa kwa moto, siku ya nane mutende mting'hano ung'alile na mmulavile Mndewa Imulungu nhosa ilavagwa kwa moto. Mting'hano awo ung'ala avo sikumusang'hane sang'hano yoyose. ");
INSERT INTO kdc_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Nyimwilinyimwili azo, zizo ziyasagule Mndewa Imulungu, na mutende mting'hano ung'alile na mmulavile Mndewa Imulungu nhosa zilavagwa kwa moto zili nhosa za kusoma moto na nhosa za ndiya na nhosa za king'waji, kila siku kamba viilondigwa. ");
INSERT INTO kdc_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Vivija mulave zija zinhosa zimmulavilaga Mndewa Imulungu mzisiku za kubwihila na vivija nhunza na kija kimulongile na nhosa zimulonda wenyego kumulavila Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Mwahamambukiza kusenga mutende nyimwilinyimwili kwa kipindi cha siku saba, kusongela siku ya longo na tano ya mwezi wa saba. Siku ya ichanduso yokuwa siku ya kubwihila na hata siku ya nane. ");
INSERT INTO kdc_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Siku ya ichanduso mubawe matunda ganogile kulawa mmibiki yenu, na mubene mibunho ya mitende, na mibunho izukile mijani mingi na mibiki ikota kumgwazo wa lwanda, na mumtendele Mndewa Imulungu wenu nyimwilinyimwili kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kila mwaka mumtendele Mndewa Imulungu nyimwilinyimwili ayo kwa siku saba. Lagizo dino mudigoge kwa ulelo wenu wose. Mutende nyimwilinyimwili ayo mwezi wa saba. ");
INSERT INTO kdc_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mukale mvibanda kwa siku saba, wanhu wose waleleke Izilaeli wakale mvibanda, ");
INSERT INTO kdc_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ili ulelo wenu wajuwe kamba viyawalavile wanhu wa Izilaeli mwiisi ya Misili, kawatenda wakale mvibanda. Niye ayo Mndewa Imulungu wenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Avo Musa kawalongela wanhu wa Izilaeli nyimwilinyimwili azo ziyasagule Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Walongele wanhu wa Izilaeli wakugalile mavuta ganogile ga mizeituni mbuli ya taa ili ikwake siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Haluni yaike taa ayo mdihema da mting'hano kunze ya panziya da sanduku da lagano, ili ikwake kuulongozi wa Mndewa Imulungu siku zose, kusongela ichungulo mbaka imitondo. Lagizo dino mudigoge kwa ulelo wenu wose siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Yazike taa azo hana ikingolobweda cha zahabu inogile, kili kuulongozi wa Mndewa Imulungu siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Soleni usage unogile, mutende magate longo na mabili, kila gate ditendigwe kwa mhishi imoja ya usage. ");
INSERT INTO kdc_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Magate gago gapangigwe misafa mibili mwiimeza ya zahabu inogile, kila msafa magate sita. ");
INSERT INTO kdc_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Kila msafa ugeligwe ubani ung'alile ili kulagusa kamba magate gago galavigwa kwa moto kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Kila siku ya kubwihila magate gago gapangigwe mbuli ya wanhu wa Izilaeli kuulongozi wa Mndewa Imulungu kamba lagano da siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Haluni yaiyeka na ulelo wake awo olondigwa kugaja magate gago kwavija gang'ala na dijo fungu jao mna zinhosa zilavagwa kwa moto kwa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Siku dimoja kulawilila ndwagi mwiing'hambi, Mwiizilaeli imoja na mbwanga imoja mamake kakala Mwiizilaeli lakini tatake kakala Mmisili. ");
INSERT INTO kdc_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mbwanga ayo mamake kakemigwa Shelomiti biti Dibili kulawa kabila da Dani, mbwanga ayo kadikudula twaga da Mndewa Imulungu. Avo wamgala kwa Musa, ");
INSERT INTO kdc_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","wamgodeka mbaka wajuwe viyolonda Mndewa Imulungu mbwanga ayo yatendigwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Msegeseni mbwanga ayo yadikudule twaga da Mndewa Imulungu, mumgale kunze ya ing'hambi. Wanhu wose wamuhulike viyodikudula ditwaga da Mndewa Imulungu weke makono gao kudipala jake, abaho wanhu wose wa Izilaeli wamtowe mabwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Abaho walongele wanhu wa Izilaeli, ‘Munhu yoyose yomkudula Imulungu wake, koipapa mwenyego nzambi yake. ");
INSERT INTO kdc_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Munhu yoyose yodikudula twaga da Mndewa Imulungu, yakomigwe. Iwanhu wose wa Izilaeli wamtowe mabwe, yawe munhu baki hebu mwenekae kolondigwa yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Munhu yoyose yomkoma munhu, na heyo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Munhu yoyose yomkoma mnyama wa miyage, yalihe ugima kwa ugima. ");
INSERT INTO kdc_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Munhu yoyose yomulumiza miyage, na heyo yalumizwe vivo viyamulumize miyage. ");
INSERT INTO kdc_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Munhu yahambena miyage na heyo yabenigwe, siso kwa siso, zino kwa zino, munhu yahamulumiza miyage na heyo yalumizwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Munhu yomkoma mnyama wa miyage yalihe, lakini munhu yomkoma munhu na heyo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Molondigwa muwe na malagizo gagano, kwa munhu baki hebu kwa mwenekae. Niye ayo Mndewa Imulungu wenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Avo, Musa kawalongela wanhu wa Izilaeli gago gose. Abaho wamsola mbwanga ayo yamkudule Mndewa Imulungu wamgala kunze ya ing'hambi na wamtowa mabwe. Wanhu wa Izilaeli watenda kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mndewa Imulungu kamulongela Musa ako kulugongo lwa Sinai, ");
INSERT INTO kdc_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Walongele wanhu wa Izilaeli, ‘Mwahengila mwiisi yonda niwagwee, isi yenyego igoge lagizo da kubwihila mbuli ya niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kwa miyaka sita muhande migunda yenu, na mudahulile mizabibu yenu na musenge vija vihandigwe. ");
INSERT INTO kdc_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Lakini mwaka wa saba imigunda yolondigwa ibwihile, mbuli ya Mndewa Imulungu. Sikumuhande mmigunda yenu hebu kudahulila mizabibu yenu. ");
INSERT INTO kdc_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Sikumusenge na kwika kukanho gaja gotile genyego na sikumubawe zabibu na kwika divai kulawa mmizabibu haidahuliligwe, isi yolondigwa ibwihile mwaka mgima. ");
INSERT INTO kdc_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Lakini chochose chotile muumwaka awo wa kubwihila, chokuwa ndiya yenu mweye wenyego na watumwa zenu wa kimbigalo na wa kitwanzi na vibaluwa wenu na wanhu baki okala hamoja na mweye. ");
INSERT INTO kdc_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Vivija kwa fugo yenu na wanyama wa kumuhulo wa isi yenu. Chochose kileligwa chokuwa ndiya yao. ");
INSERT INTO kdc_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Peteni miyaka saba kwa miyanza saba na yokuwa miyaka malongo mane na tisa, ");
INSERT INTO kdc_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","abaho mutowe mhalati kila hanhu siku ya longo ya mwezi wa saba kwavija siku ayo yokuwa siku ya kulohola nzambi. ");
INSERT INTO kdc_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mwaka wa malongo matano muugelegeze goya na muwalongele wanhu wose mwiisi kamba walekeswa. Muumwaka awo vinhu vose viuzigwe vibwezigwe kwa mwenyego hebu ulelo wake na munhu yoyose yauzigwe kamba mtumwa yabwele kwa wanhu wa lukolo lwake. ");
INSERT INTO kdc_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kwavija mwaka awo okuwa wa kulekeswa, avo sikumuhande mbeyu yoyose hebu kusenga na kwika kukanho kinhu chochose hebu kubawa zabibu na kwika divai kulawa mna imizabibu haidahuliligwe. ");
INSERT INTO kdc_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mwaka awo okuwa wa kulekeswa kumwenu, avo mwaka awo ung'ala. Avo moja gaja gotile genyego mmigunda yenu. ");
INSERT INTO kdc_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Mna umwaka awo kinhu chochose kiuzigwe, kibwezigwe kwa mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Wahauza mgunda kwa Mwiizilaeli miyago hebu wahagula mgunda sikuumbunze miyago. ");
INSERT INTO kdc_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Bei ya mgunda iigale na miyaka isigale kuvikila mwaka wa kulekeswa, umwaka wa kumbwezela mwenyego mgunda wake. ");
INSERT INTO kdc_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kamba miyaka ya kuvikila mwaka wa kulekeswa ing'ali mingi, bei ya mgunda awo yokuwa ng'hulu, lakini yahakuwa midodo bei ya mgunda awo yokuwa ndodo. Bei ilavigwe kwa kuigala na gaja gosengigwa mumgunda. ");
INSERT INTO kdc_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Sikumuibunze, lakini nidumbeni niye, niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Tegelezeni gaja ganiwalongele na mugoge malagizo gangu, kuko mokala goya mwiisi yonda niwagwee. ");
INSERT INTO kdc_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nayo isi yolela ng'hani na mweye moja na kushiba na mokala goya. ");
INSERT INTO kdc_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Munhu kodaha kugelegeza, “Toja choni mna umwaka awo wa saba kamba hatulondigwa kuhanda hebu kusenga vija vituhandile?” ");
INSERT INTO kdc_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Niye noitenda isi ilele ng'hani muumwaka wa sita, na mokuwa na ndiya ya kuja miyaka midatu. ");
INSERT INTO kdc_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Vonda muhande mwaka wa nane moja ndiya iija ya mwaka wa sita na moja mbaka vonda musenge mwaka wa tisa. ");
INSERT INTO kdc_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Isi sikuiuzigwe yose yose, kwavija isi yangu niye, mweye mwa kamba wabita nzila hebu wanhu baki mwiisi yangu. ");
INSERT INTO kdc_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Lekaavo mwiisi yose yumukala, molondigwa muigombole isi. ");
INSERT INTO kdc_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Kamba Mwiizilaeli miyago mkiwa na kauza mgunda wake, avo ndugu yake yeli behi yeze kuugombola mgunda awo. ");
INSERT INTO kdc_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kamba munhu ayo kabule ndugu yodaha kuugombola, lakini baho kumwande kawa mgoli na kodaha kuugombola mgunda wake, ");
INSERT INTO kdc_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","avo yapete imiyaka toka viyauuzile na yamulihe munhu yaugulile, na ayo imunhu yagulile kolondigwa yambwezele mwene mgunda awo. ");
INSERT INTO kdc_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Lakini kamba hadaha kumuliha imunhu yagulile, mgunda awo okuwa wa imunhu yagulile mbaka mwaka wa kulekeswa. Muumwaka awo yaubweze mgunda awo kwa mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Kamba munhu yahauza ng'anda yake iyokala ili mgati ya buga dizengelwe, kodaha kuigombola kipindi cha mwaka umoja toka yaiuze. Mwaka wose awo kodaha kuigombola. ");
INSERT INTO kdc_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kamba ng'anda ayo haigomboligwe mwaka wose awo, baho yokuwa ng'anda ya ayo yaigulile, yokuwa yake siku zose heyo na ulelo wake, na hailondigwa kubwezigwa mna umwaka wa kulekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Lakini ng'anda ili mkijiji kilibule senyenge izunguluke kijiji acho, yogesigwa kamba mgunda, avo yolondigwa igomboligwe na ibwezigwe muumwaka wa kulekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Hata avo, ng'anda zili mna gamabuga gowokala Walawi zodaha kugomboligwa kipindi chochose. ");
INSERT INTO kdc_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kamba ng'anda yoyose iuzigwa na Mulawi na haigomboligwe bule, avo yolondigwa ibwezigwe muumwaka wa kulekeswa, kwavija ng'anda zili mna gamabuga ga Walawi zokuwa zao kipindi chose, hewo wagweleligwa kulawa kwa wanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lakini migunda ya Walawi, sikuiuzigwe kwavija migunda ayo ni uhazi wao siku zose. ");
INSERT INTO kdc_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Kamba ndugu yako mkiwa na hadaha kuitaza mwenyego, umtaze ili yagendelele kukala na gweye kamba vija munhu baki hebu mbita nzila. ");
INSERT INTO kdc_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Sikuumwede kwa mgongo wake, umdumbe Imulungu wako, muleke ndugu yako yagendelele kukala na gweye. ");
INSERT INTO kdc_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Sikuumkopeshe sente abaho yakubwezele nyingi hebu kumgwaa ndiya na kolonda yakulihe sente nyingi. ");
INSERT INTO kdc_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Niye ayo Mndewa Imulungu wako nikulavile mwiisi ya Misili ili nikugwee isi ya Kanaani na niwe Imulungu wako. ");
INSERT INTO kdc_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Kamba ndugu yako yokala behi na gweye mkiwa, na kolonda gweye umtende msang'hanaji wako, sikuutogole yakusang'hanile kamba mtumwa. ");
INSERT INTO kdc_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Yakale kumwako kamba munhu yosang'hana kwa kupata sente hebu kibaluwa. Kokusang'hanila mbaka mwaka wa kulekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mwaka awo umuleke yachole na yabwele kwa wanhu wa lukolo lwake na kupata uhazi wa tatake na mamake. ");
INSERT INTO kdc_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kwavija wanhu wa Izilaeli ni wasang'hanaji zangu niwalavile mwiisi ya Misili, avo sikuwauzigwe kamba watumwa. ");
INSERT INTO kdc_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Sikuumtawale Mwiizilaeli miyago kwa usede lakini umdumbe Imulungu wako. ");
INSERT INTO kdc_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Modaha kugula watumwa wa kimbigalo hebu wa kitwanzi kulawa kwa wanhu wa isi ziyagwe zili mmabehi yenu. ");
INSERT INTO kdc_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Vivija modaha kugula watumwa kulawa kwa wanhu baki okala hamoja na mweye na wanao waleligwe mwiisi yenu, hewo okuwa wenu. ");
INSERT INTO kdc_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Watumwa awo modaha kuwagwaa wanenu na okuwa wao siku zose. Lakini Mwiizilaeli miyago sikuumtawale kwa usede. ");
INSERT INTO kdc_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Kamba munhu baki hebu munhu yobita nzila yokala kumwenu kawa mgoli, na munhu imoja kumwenu mkiwa kawa mtumwa wake hebu kwa imoja wa ndugu zake, ");
INSERT INTO kdc_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kodaha kugomboligwa kamba yahatendigwa mtumwa, ndugu yake imoja kodaha kumgombola, ");
INSERT INTO kdc_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","tatake mkulu hebu tatake mdodo hebu ndugu zake hebu munhu yoyose mulukolo lwake kodaha kumgombola, hebu kamba yahawa na sente kodaha kuigombola mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Heyo na munhu yamgulile wapete miyaka toka viyaguligwe mbaka mwaka wa kulekeswa. Bei yake iigale na ija iyolihigwa kibaluwa kwa miyaka yose. ");
INSERT INTO kdc_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kamba miyaka isigale mingi, yalihe ng'hani ili yaigombole mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kamba miyaka isigale midodo ya kuvikila mwaka wa kulekeswa, yapete kija kilondigwa na yalihe kwa kuigombola mwenyego. ");
INSERT INTO kdc_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kipindi chose kiyokala kwa munhu ayo yatendigwe kamba munhu yolihigwa fungu kila mwaka. Avo mmulole munhu ayo yamgulile sikuyamtendele usede. ");
INSERT INTO kdc_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Lakini hata kamba munhu ayo na wanage hawagomboligwe kwa nzila zose azo, olondigwa walekeswe muumwaka wa kulekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Wanhu wa Izilaeli ni wasang'hanaji zangu, kwavija niwalava mwiisi ya Misili. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Sikumuitendele vinyago, na sikumusimike vinyago vao hebu mabwe gao gang'alile mwiisi yenu na kuvitambikila. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Gogeni malagizo gangu ga siku ya kubwihila, na muhadumbe hanhu hangu hong'ala. Niye ayo Mndewa Imulungu wenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Kamba mwahategeleza gaja goniwalongela na kugoga malagizo gangu, ");
INSERT INTO kdc_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nowagalila mvula mna ikipindi kinogile na migunda yenu yolela ndiya nyingi na mibiki ili mmigunda yenu yolela ng'hani. ");
INSERT INTO kdc_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Vija vihandigwe volela ng'hani na mogendelela kusenga mna umsimu wa kubawa zabibu, na mogendelela kubawa zabibu mna umsimu wa kuhanda mbeyu. Mokuwa na kila kinhu chakuja, na mokala goya mwiisi yenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Nowatenda mukale goya mwiisi mbaka modaha kuwasa bila kudumba chochose. Nowasegesa wanyama wakali mna iisi na kokuwa kuduhu ng'hondo mwiisi yenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mowawinga wanhu owehila na mowakoma kwa misime. ");
INSERT INTO kdc_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Wanhu watano owawinga wanhu owehila gana dimoja na wanhu gana dimoja kumwenu owawinga wanhu elufu longo. Wanhu owehila obanangigwa mgameso genu kwa misime. ");
INSERT INTO kdc_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nowatendela ganogile na kuwatenda mupate wana wengi na mokongezeka, na niye noditenda goya lagano jangu na mweye. ");
INSERT INTO kdc_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mna umsimu wa kusenga mokuwa mung'hali moja vija vimusengile miyaka ibitile. Vivija movisegesa vija vili mmakanho genu ili mupate hanhu ha kwika vija vimusenga sambi. ");
INSERT INTO kdc_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Niye nokwika kae yangu hamoja na mweye, na siwaleka bule. ");
INSERT INTO kdc_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nokala na mweye, na nokuwa Imulungu wenu na mokuwa wanhu zangu. ");
INSERT INTO kdc_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Niye na Mndewa Imulungu wenu, niwalavile mwiisi ya Misili ili sikumuwe watumwa wa Wamisili, niye nikibena kinhu kifungigwe msingo zenu ili mugende kuno mwima wima. ");
INSERT INTO kdc_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Lakini kamba hamtegeleza na kugoga gano goniwalagiza, ");
INSERT INTO kdc_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kamba mwahagalema malagizo gangu, na kugehila gaja gonilonga na mwahabena lagano jangu, ");
INSERT INTO kdc_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","avo na niye nowatendela vino, nowagalila magazo ga kusinhukiza na nowagwaa utamu wa kifuwa kikulu, na nowagalila homa yonda iwatende munyolile, mogaya bule kuhanda mbeyu, kwavija wanhu owehila awo onda waje. ");
INSERT INTO kdc_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Niye nowahindusila kisogo, na mweye motoigwa na wanhu owehila, motawaligwa na wanhu owehila. Mosinhusigwa na kukimbila hamoja kuduhu munhu yowawinga. ");
INSERT INTO kdc_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Kamba mokuwa mung'hali mogendelela kutenda gehile nowakoboza miyanza saba ng'hani kubanza aho haichanduso mbuli ya nzambi zenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nowakoboza kwa udala wa mizoyo yenu na noutenda ulanga uwe mzelu, na noitenda isi iwe ndala mbwee kamba dibwe. ");
INSERT INTO kdc_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mogaya bule, kuhanda mmigunda yenu kwavija honda mupate ndiya yoyose na isi honda ilele bule matunda. ");
INSERT INTO kdc_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Mwahagendelela kunilema na molema kunitegeleza nokongeza kuwakoboza miyanza saba ng'hani mbuli ya nzambi zenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nowagalila wanyama wakali na hewo owakomela wanenu na woja fugo yenu na owatenda muhunguke na nzila zenu zovulala kuluwala. ");
INSERT INTO kdc_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Na mwahagendelela kulema kugoga malagizo gangu hamoja niwakoboza kwa gago gose gehile, ");
INSERT INTO kdc_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","baho niye nowagevuzikila na nowakoboza miyanza saba ng'hani mbuli ya nzambi zenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nowagalila ng'hondo kuliha lagano jangu dimubenile. Mweye mokimbilila mna gamabuga genu, lakini nowagalila mitamu ihile na nowagela mmakono ga wanhu owehila. ");
INSERT INTO kdc_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Noihunguza ndiya yenu mbaka watwanzi longo okoka magate mna ikivu kimoja. Owagwelela magate kwa kupima na hata mwahaja mokuwa mung'hali na nzala. ");
INSERT INTO kdc_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Mwahagendelela kulema malagizo gangu hamoja na gago gose gehile ganiwagwee, ");
INSERT INTO kdc_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nowakoboza vihile ng'hani, niye mwenyego nowakoboza miyanza saba ng'hani kwa nzambi zenu. ");
INSERT INTO kdc_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Na mweye moja nyama za wanenu wa kimbigalo na wa kitwanzi. ");
INSERT INTO kdc_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nohananga hanhu homutambikila ako kuvigongo, noubena upango wenu wa kulavila nhosa na ubani, noyasa mitufi yenu mna ivinyago vimtambikila, niye nowaleka. ");
INSERT INTO kdc_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nogananga mabuga genu na hanhu henu hong'ala nohatenda vihame na nozilema nhosa zenu zimundavila. ");
INSERT INTO kdc_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Noinanga isi yenu mbaka wanhu owehila wakalile aho wakanganye. ");
INSERT INTO kdc_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nowapwililisa mziisi ziyagwe na mokomigwa kwa misime, isi yenu yokuwa vihame na mabuga genu gonangika. ");
INSERT INTO kdc_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Baho isi yobwihila kamba siku ya kubwihila kwa miyaka heleketwaa, kipindi acho mweye mwa mna ziisi za wanhu owehila. Isi yobwihila goya mzisiku za kubwihila. ");
INSERT INTO kdc_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Kwa miyaka heleketwaa isi yokuwa yobwihila kwavija haibwihile kipindi vimukalile mumo. ");
INSERT INTO kdc_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Na wayagwe onda wasigale, nowatenda wadumbe kuko mziisi za wanhu owehila na okimbila hata lusanze luhembelusigwa na beho. Okimbila kamba munhu yokimbila ng'hondo. Okimbila na kugwa hata kamba kuduhu munhu yowawinga. ");
INSERT INTO kdc_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Oigwila wenyego chaka chaka kamba munhu yokimbila ng'hondo hata kamba kuduhu munhu yomuwinga. Honda mudahe kuitowa na wanhu owehila. ");
INSERT INTO kdc_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mofila mziisi ziyagwe na mna ziisi za wanhu owehila mozikigwa. ");
INSERT INTO kdc_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wayagwe onda wasigale mna ziisi za wanhu owehila onyolila na omala kwa nzambi zao, na mbuli ya nzambi za wahenga zao. ");
INSERT INTO kdc_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Lakini kamba wahazitambula nzambi zao na nzambi za wahenga zao na gehile gawanhendile niye na kundema, ");
INSERT INTO kdc_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","mbaka niye niitowa nao na niwagala mna iisi ya wanhu owehila na kamba wahatogola kamba watenda nzambi na wahatogola kutagusigwa na kuiyona hawafaya, ");
INSERT INTO kdc_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","baho niye nodikumbuka lagano jangu diniilagane na Abulahamu na Isaka na Yakobo na noikumbuka isi iniwalongele nowagwaa. ");
INSERT INTO kdc_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Kipindi viwokala kunze ya isi yao, isi yodeng'helela kubwihila kamba siku za kubwihila kwavija yokala vihame. Kipindi acho hewo olihigwa kwa nzambi zao za kuleka kugoga malagizo gangu na kugehila. ");
INSERT INTO kdc_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Lakini kwa gago gose wahakala mziisi za wanhu owehila, niye siwasa hebu kuwehila na kuwabananga wose na kudilema lagano jangu. Niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Bule, mbuli yao nodikumbuka lagano jangu diniilagane na wahenga zao, waniwalavile mwiisi ya Misili, kuno wanhu wa isi ziyagwe olola, ili niwe Imulungu wao. Niye ayo Mndewa Imulungu.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Gano gago gayalongile Mndewa Imulungu, na gamalagizo na mafundizo ga Imulungu gayawagwelele wanhu wa Izilaeli kuko kulugongo lwa Sinai kubitila Musa. ");
INSERT INTO kdc_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Walongele wanhu wa Izilaeli, ‘Munhu yahaiduwila kamba komgwaa Mndewa Imulungu munhu, munhu ayo kodaha kusegesa kiyalongile kwa kulava fungu diigala na munhu ayo. ");
INSERT INTO kdc_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","“ ‘Kamba mbigalo yeli na miyaka malongo mabili mbaka miyaka malongo sita, yamulavile Mndewa Imulungu vihande malongo matano va shaba, kwa kipimo cha hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","“ ‘Kamba munhu ayo mtwanzi yalaviligwe vihande malongo madatu va shaba. ");
INSERT INTO kdc_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","“ ‘Kamba munhu ayo kana miyaka kusongela mitano mbaka malongo mabili na yahawa mbigalo yagomboligwe kwa kulaviligwa vihande malongo mabili va shaba. Kamba yahawa mtwanzi yalaviligwe vihande longo va shaba. ");
INSERT INTO kdc_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“ ‘Kamba mwana king'hele wa mwezi umoja mbaka miyaka mitano, na kamba mwana ayo mbigalo yalaviligwe vihande vitano va shaba. Kamba mwana ayo mtwanzi yalaviligwe vihande vidatu va shaba. ");
INSERT INTO kdc_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“ ‘Kamba munhu kana miyaka kubanza malongo sita na kamba munhu ayo mbigalo, yalaviligwe vihande longo na tano va shaba. Kamba mtwanzi yalaviligwe vihande longo va shaba. ");
INSERT INTO kdc_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ ‘Lakini kamba munhu mkiwa hadaha kuliha fungu dijo, baho munhu ayo yagaligwe kwa mulava nhosa na mulava nhosa yagelegeze ili yajuwe sente nyingahi kodaha kulava kwa kuigala na ayo yalongile mbuli kwa kuiduwila. ");
INSERT INTO kdc_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Kamba kaiduwila mbuli ya mnyama yolavigwa nhosa kwa Mndewa Imulungu, baho mnyama ayo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Hailondigwa bule mnyama ayo yabadilishigwe kwa mnyama iyagwe, yanogile kwa yehile hebu yehile kwa yanogile kamba yahabadilishigwa kwa mnyama iyagwe, wose wabili okuwa wang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“ ‘Kamba kaiduwila mbuli ya mnyama yafitile, mnyama halavigwa nhosa kwa Mndewa Imulungu, baho munhu yamulavile yamgale kwa mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Na mulava nhosa yagelegeze sente ya mnyama ayo kwa kuigala na kunoga kwake hebu kwiha kwake. Vonda yalonge mulava nhosa vivo vonda iwe. ");
INSERT INTO kdc_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Lakini kamba mwenyego kolonda kumgombola, yongeze sente asilimia malongo mabili ya sente ilondigwa kwa mnyama ayo. ");
INSERT INTO kdc_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Munhu yahailava ng'anda yake kwa Mndewa Imulungu, mulava nhosa yagelegeze sente ya ng'anda ayo kwa kuigala na kunoga kwake hebu kwiha kwake. Vonda yalonge vivo vonda iwe. ");
INSERT INTO kdc_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Munhu ayo yailavile kwa Mndewa Imulungu yahalonda kuigombola ng'anda yake baho yongeze sente asilimia malongo mabili ya sente ilondigwa, baho yokuwa ng'anda yake. ");
INSERT INTO kdc_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Munhu yahaulava mgunda wake kwa Mndewa Imulungu uli uhazi wake, baho fungu da mgunda awo dololigwa kwa kuigala na mbeyu zidaha kuhanda mgunda wose awo, kila kilo malongo mabili za mbeyu za ngano yokuwa vihande malongo matano va shaba. ");
INSERT INTO kdc_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kamba yahaulava mgunda wake muumwaka wa kulekeswa, fungu jake diigale na vija vimupima. ");
INSERT INTO kdc_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Lakini yahaulava mgunda wake wahabita mwaka awo, baho mulava nhosa yagelegeze sente za mgunda awo kwa kuigala na miyaka isigale kuvikila mwaka uyagwe wa kulekeswa. ");
INSERT INTO kdc_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kamba mwenyego kolonda kuugombola mgunda wake, yongeze sente asilimia malongo mabili ya sente ilondigwa kwa mgunda awo, abaho okuwa mgunda wake. ");
INSERT INTO kdc_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Lakini kamba halonda kuugombola na kamuuzila munhu iyagwe, baho mgunda awo sikuugomboligwe kabili. ");
INSERT INTO kdc_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mna umwaka wa kulekeswa, mgunda awo ulekigwe na okuwa wa Mndewa Imulungu siku zose. Mulava nhosa, ayo yonda yausole mgunda awo. ");
INSERT INTO kdc_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Kamba munhu yahamulavila Mndewa Imulungu mgunda wake yaugulile kwa munhu iyagwe, ");
INSERT INTO kdc_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mulava nhosa yagelegeze fungu da mgunda awo kwa kuigala na miyaka isigale kuvikila mwaka wa kulekeswa, na munhu ayo kolondigwa yalihe siku dijo kamba vija kinhu king'ala kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Lakini mwaka wa kulekeswa, mgunda awo ubwezigwe kwa munhu yauzile. ");
INSERT INTO kdc_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Kila kinhu chahalondigwa kuguligwa, kiigale na kipimo kili hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Hailondigwa kumulavila Mndewa Imulungu mwana wa ichanduso wa mnyama, kwavija kila mwana wa ichanduso wa mnyama mwenyego Mndewa Imulungu, yawe mwana wa ng'ombe hebu wa ng'hondolo. ");
INSERT INTO kdc_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kamba mnyama ayo kafita, mwenyego kodaha kumgula kamba kipimo chenu vikili na yongeze sente asilimia malongo mabili ya sente ilondigwa kwa mnyama ayo. Kamba hamgombola bule baho yauzigwe kwa sente ilondigwa. ");
INSERT INTO kdc_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Lakini kinhu chochose kilavigwe chosechose kwa Mndewa Imulungu, iwe munhu hebu mnyama hebu kinhu kipatikane kwa uhazi, hakiuzigwa bule hebu kugomboligwa, chochose kilavigwe kwa Mndewa Imulungu king'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Munhu yoyose yabaguligwe ili yabanangigwe, sikuyagomboligwe, kolondigwa yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Fungu da longo da ndiya hebu matunda ga mibiki, vose mwenyego Mndewa Imulungu, avo ving'ala kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kamba munhu kolonda kudigombola fungu jake da longo yalihe kamba viilondigwa na yongeze asilimia malongo mabili. ");
INSERT INTO kdc_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Munhu yahapeta fugo yake, kila mnyama wa longo mna idibumbila jake, mnyama ayo kokuwa wa Mndewa Imulungu na wanyama awo okuwa wang'ala. ");
INSERT INTO kdc_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Munhu yoyose halondigwa kugelegeza kamba mnyama ayo kanoga hebu keha na mnyama ayo halondigwa kubadilishigwa na mnyama iyagwe. Kamba yahabadilishigwa na mnyama iyagwe, wanyama wose wabili okuwa wang'ala na hawagomboligwa bule.’ ” ");
INSERT INTO kdc_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Gano gago malagizo ga Mndewa Imulungu gayamgwelele Musa yawalongele wanhu wose wa Izilaeli kuko kulugongo lwa Sinai.");
INSERT INTO kdc_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mna isiku ya ichanduso ya mwezi wa kabili, mwaka wa kabili Waizilaeli viwalawile Misili, Mndewa Imulungu kalonga na Musa mdihema da mting'hano ako kuluwala lwa Sinai, kamulongela, ");
INSERT INTO kdc_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Gweye na Haluni muwapete Waizilaeli wose, na mugandike matwaga ga wambigalo wose kamba vizili ng'holo zao na makabila gao. ");
INSERT INTO kdc_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Waja wose odaha kuchola kuna ing'hondo weli na miyaka malongo mabili na kugendelela, wekeni mna ivibumbila va wakalizi wa ng'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Avo mbigalo imoja kulawa kila kabila yailumbe na mweye, kila imoja yeli kilongozi wa wanhu wa kabila jake.” ");
INSERT INTO kdc_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Gano gago matwaga ga wanhu onda wakutaze. Kabila da Lubeni kokuwa Elisuli mwanage Shedeuli, ");
INSERT INTO kdc_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kabila da Simeoni kokuwa Shelumieli mwanage Sulishadai, ");
INSERT INTO kdc_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kabila da Yuda kokuwa Nashoni mwanage Aminadabu, ");
INSERT INTO kdc_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kabila da Isakali kokuwa Nasaneli mwanage Suali, ");
INSERT INTO kdc_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kabila da Zabuloni kokuwa Eliabu mwanage Heloni, ");
INSERT INTO kdc_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kulawa kwa wanage Yusufu, kabila da Efulaimu kokuwa Elishama mwanage Amihudi, kabila da Manase kokuwa Gamalieli mwanage Pedasuli, ");
INSERT INTO kdc_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kabila da Benjamini kokuwa Abidani mwanage Gideoni, ");
INSERT INTO kdc_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kabila da Dani kokuwa Ahiezeli mwanage Amishadai, ");
INSERT INTO kdc_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kabila da Asheli kokuwa Pagieli mwanage Okilani, ");
INSERT INTO kdc_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kabila da Gadi kokuwa Eliasafu mwanage Deueli, ");
INSERT INTO kdc_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kabila da Nafutali kokuwa Ahila mwanage Enani.” ");
INSERT INTO kdc_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Wano awo vilongozi wasaguligwe hagati ya Waizilaeli kamba vilongozi wakulu wa ng'holo zao na vilongozi wakulu wa makabila ga Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Avo Musa na Haluni wawasola ivilongozi awo watambuligwe. ");
INSERT INTO kdc_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Mna isiku ya ichanduso ya mwezi wa kabili waiting'hana hamoja na kibumbila chose cha wanhu wakalile wapetigwe kila munhu mulukolo lwake na kabila jake, wagandika matwaga ga wambigalo wose wakalile na miyaka malongo mabili na kugendelela, kamba viweli mzing'holo zao na makabila gao, ");
INSERT INTO kdc_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kamba Mndewa Imulungu viyamulagize Musa. Avo Musa kawapeta wanhu awo ako kuluwala lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Wanhu walawile kabila da Lubeni yakalile mwana chaudele wa Izilaeli, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","wakala elufu alobaini na sita na magana tano (46,500). ");
INSERT INTO kdc_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kulawa kabila da Simeoni kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","wakala elufu hamsini na tisa na magana ndatu (59,300). ");
INSERT INTO kdc_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kulawa kabila da Gadi, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","wakala elufu alobaini na tano na magana sita na hamsini (45,650). ");
INSERT INTO kdc_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kulawa kabila da Yuda, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","wakala elufu sabini na nne na magana sita (74,600). ");
INSERT INTO kdc_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kulawa kabila da Isakali, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","wakala elufu hamsini na nne na magana nne (54,400). ");
INSERT INTO kdc_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kulawa kabila da Zabuloni, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","wakala elufu hamsini na saba na magana nne (57,400). ");
INSERT INTO kdc_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kulawa kabila da Efulaimu mwanage Yusufu, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","wakala elufu alobaini na magana tano (40,500). ");
INSERT INTO kdc_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kulawa kabila da Manase mwanage Yusufu, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","wakala elufu selasini na mbili na magana mbili (32,200). ");
INSERT INTO kdc_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kulawa kabila da Benjamini, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","wakala elufu selasini na tano na magana nne (35,400). ");
INSERT INTO kdc_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kulawa kabila da Dani, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","wakala elufu sitini na mbili na magana saba (62,700). ");
INSERT INTO kdc_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kulawa kabila da Asheli, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","wakala elufu alobaini na moja na magana tano (41,500). ");
INSERT INTO kdc_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kulawa kabila da Nafutali, kwa kukweleleza ulelo wao kamba viweli mna zing'holo zao na makabila gao, kamba kila twaga da kila imoja wao vidili, kila mbigalo yakalile na miyaka malongo mabili na kugendelela, yodaha kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","wakala elufu hamsini na ndatu na magana nne (53,400). ");
INSERT INTO kdc_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Wanhu wano awo wapetigwe na Musa na Haluni na kwa kutazigwa na waja vilongozi longo na wabili wa Izilaeli, kila imoja kakala kilongozi wa lukolo lwake. ");
INSERT INTO kdc_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Avo wambigalo wose kwa wose wa Izilaeli weli na miyaka kusongela malongo mabili na kugendelela, wadahile kuchola kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","wakala laki sita na elufu ndatu na magana tano na hamsini (603,550). ");
INSERT INTO kdc_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lakini Walawi hawapetigwe hamoja na gaja gamakabila gayagwe, ");
INSERT INTO kdc_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","kwavija Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Sikuuwapete wanhu wa kabila da Lawi hamoja na wanhu wayagwe wa Izilaeli, ");
INSERT INTO kdc_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","lakini uwasagule ili wadilolege goya dihema da mting'hano na viya vake vose na kila kinhu kili mgati, wadipape hamoja na viya vake vose. Wasang'hanile mumo na weke ng'hambi yao kudizunguluka dihema. ");
INSERT INTO kdc_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Dihema dahang'oligwa, Walawi awo onda wading'ole na dahasimikigwa, Walawi awo onda wadisimike. Munhu yoyose heli Mulawi yahadikwesela dihema yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Waizilaeli wayagwe wose weke ng'hambi zao mna gamabumbila bumbila, kila munhu mna ing'hambi yake hasi ya bendela ya ikibumbila chake. ");
INSERT INTO kdc_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lakini Walawi weke ng'hambi yao kudizunguluka dihema na wadilole goya ili munhu yoyose sikuyadikwesele behi na kuitenda ng'hasiliki yangu iwe ng'hulu mbuli ya wanhu zangu wa Izilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Avo Waizilaeli watenda kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mndewa Imulungu kawalagiza Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Waizilaeli weke ng'hambi zao kudizunguluka dihema da mting'hano, kila munhu yakale hanhu heli na bendela ilagusa kabila jake na hana ikilaguso cha ulukolo lwake.” ");
INSERT INTO kdc_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Wanhu onda weke ng'hambi mwambu wa kudilawila zuwa chokuwa kibumbila kili hasi ya bendela ya Yuda, kamba viweli mna gamakabila gao na kilongozi wa kabila da Yuda kokuwa Nashoni mwanage Aminadabu. ");
INSERT INTO kdc_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Kabila da Yuda dokuwa na wambigalo elufu sabini na nne na magana sita (74,600). ");
INSERT INTO kdc_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Wanhu onda weke ng'hambi behi na wanhu wa kabila da Yuda okuwa kabila da Isakali, kilongozi wao kokuwa Nasaneli mwanage Suali. ");
INSERT INTO kdc_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Kabila da Isakali dokuwa na wambigalo elufu hamsini na nne na magana nne (54,400). ");
INSERT INTO kdc_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Abaho kabila da Zabuloni okwika ng'hambi yao na kilongozi wao kokuwa Eliabu mwanage Heloni. ");
INSERT INTO kdc_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Kabila da Zabuloni dokuwa na wambigalo elufu hamsini na saba na magana nne (57,400). ");
INSERT INTO kdc_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Iwanhu wose onda wawe mna ikibumbila cha Yuda kamba viweli mna gamakabila gao okuwa laki imoja na elufu semanini na sita na magana nne (186,400). Hewo awo onda walongole kusegela. ");
INSERT INTO kdc_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Wanhu onda weke ng'hambi mwambu wa kusini, chokuwa kibumbila kili hasi ya bendela ya Lubeni kamba viweli mna gamakabila gao na kilongozi wa kabila da Lubeni kokuwa Elisuli mwanage Shedeuli. ");
INSERT INTO kdc_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Kabila da Lubeni dokuwa na wambigalo elufu alobaini na sita magana tano (46,500). ");
INSERT INTO kdc_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Wanhu onda weke ng'hambi behi na kabila da Lubeni okuwa wanhu wa kabila da Simeoni, kilongozi wao kokuwa Shelumieli mwanage Sulishadai. ");
INSERT INTO kdc_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Kabila da Simeoni dokuwa na wambigalo elufu hamsini na tisa na magana ndatu (59,300). ");
INSERT INTO kdc_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Abaho wanhu wa kabila da Gadi okwika ng'hambi yao na kilongozi wao kokuwa Eliasafu mwanage Leueli. ");
INSERT INTO kdc_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Kabila da Gadi dokuwa na wambigalo elufu alobaini na tano na magana sita na hamsini (45,650). ");
INSERT INTO kdc_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Iwanhu wose onda wawe mna ikibumbila cha Lubeni kamba viweli mna gamakabila gao okuwa laki moja na elufu hamsini na moja na magana nne na hamsini (151,450). Wano awo onda wasegele mmwanza wa kabili. ");
INSERT INTO kdc_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Abaho ing'hambi ya kabila da Walawi ili hagati ya izing'hambi zose, na kuno odipapa ajo dihema na kusegela najo. Kila kabila dochola kwa kukweleleza hanhu hake hasi ya bendela yake. ");
INSERT INTO kdc_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Wanhu onda weke ng'hambi mwambu wa kudihongela zuwa, chokuwa kibumbila kili hasi ya bendela ya Efulaimu kamba viweli mna gamakabila gao na kilongozi wa kabila da Efulaimu kokuwa Elishama mwanage Amihudi. ");
INSERT INTO kdc_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Kabila da Efulaimu dokuwa na wambigalo elufu alobaini na magana tano (40,500). ");
INSERT INTO kdc_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Wanhu onda weke ng'hambi behi na kabila da Efulaimu okuwa wanhu wa kabila da Manase, kilongozi wao kokuwa Gamalieli mwanage Pedasuli. ");
INSERT INTO kdc_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Kabila da Manase dokuwa na wambigalo elufu selasini na mbili na magana mbili (32,200). ");
INSERT INTO kdc_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Abaho wanhu wa kabila da Benjamini okwika ng'hambi yao na kilongozi wao kokuwa Abidani mwanage Gideoni. ");
INSERT INTO kdc_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Kabila da Benjamini dokuwa na wambigalo elufu selasini na tano na magana nne (35,400). ");
INSERT INTO kdc_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Iwanhu wose onda wawe mna ikibumbila cha Efulaimu kamba viweli mna gamakabila gao okuwa laki imoja na elufu nane na magana moja (108,100). Wano awo onda wasegele mmwanza wa kadatu. ");
INSERT INTO kdc_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Wanhu onda weke ng'hambi mwambu wa kasikazini chokuwa kibumbila kili hasi ya bendela ya Dani kamba viweli mna gamakabila gao na kilongozi wa kabila da Dani kokuwa Ahiezeli mwanage Amishadai. ");
INSERT INTO kdc_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Kabila da Dani dokuwa na wambigalo elufu sitini na mbili na magana saba (62,700). ");
INSERT INTO kdc_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Abaho wanhu onda weke ng'hambi behi yao okuwa kabila da Asheli, kilongozi wao kokuwa Pagieli mwanage Okilani. ");
INSERT INTO kdc_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Kabila da Asheli dokuwa na wambigalo elufu alobaini na moja magana tano (41,500). ");
INSERT INTO kdc_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Abaho wanhu wa kabila da Nafutali okwika ng'hambi yao na kilongozi wao kokuwa Ahila mwanage Enani. ");
INSERT INTO kdc_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Kabila da Nafutali dokuwa na wambigalo elufu hamsini na ndatu na magana nne (53,400). ");
INSERT INTO kdc_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Iwanhu wose onda wawe mna ikibumbila cha Dani kamba viweli mna gamakabila gao okuwa laki imoja na elufu hamsini na saba na magana sita (157,600). Kibumbila kino cha Dani chokuwa mmwanza wa ikimambukizo. ");
INSERT INTO kdc_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Wano awo Waizilaeli wapetigwe kamba viweli mna gamakabila gao, mzing'hambi za vibumbila vao, wose kwa wose wakala laki sita na elufu ndatu na magana tano na hamsini (603,550). ");
INSERT INTO kdc_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lakini Walawi hawapetigwe hamoja na wanhu wayagwe wa Izilaeli, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Avo Waizilaeli watenda kila kinhu kamba Mndewa Imulungu viyamulagize Musa. Avo weka ng'hambi kamba viweli mna izibendela zao, wachola mwanza wao kuno kila munhu kailongoza na lukolo lwake na ulelo wake. ");
INSERT INTO kdc_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Uno awo ulelo wa Haluni na Musa kipindi Mndewa Imulungu viyalongile na Musa ako kulugongo lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Haluni kakala na wana wane na hewo wakala Nadabu imwana chaudele na Abihu na Eleazali na Itamali. ");
INSERT INTO kdc_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Wano wose wagidiligwa mavuta wawe walava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Lakini Nadabu na Abihu wafa kuulongozi wa Mndewa Imulungu viwakalile omulavila Imulungu moto haulondigwe ako kuluwala lwa Sinai. Awo wakala hawalelile wana, avo Eleazali na Itamali wasang'hana kamba walava nhosa kipindi tatao viyakalile mgima. ");
INSERT INTO kdc_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Wagale behi wanhu wa kabila da Lawi na uweke kuulongozi wa mulava nhosa Haluni ili wamsang'hanile heyo. ");
INSERT INTO kdc_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wasang'hane hanhu hake na hanhu ha Waizilaeli wose mna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Wavilole goya viya vose va dihema da mting'hano na wawataze Waizilaeli kusang'hana hanhu hang'alile. ");
INSERT INTO kdc_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Gweye umgwelele Haluni na wanage awo iwalawi wawe hamoja nao, hewo walavigwa hagati ya Waizilaeli wawasang'hanile hewo. ");
INSERT INTO kdc_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Abaho msagule Haluni na wanage wasang'hane kamba walava nhosa, lakini munhu yoyose iyagwe yonda yasang'hane sang'hano ayo yakomigwe.” ");
INSERT INTO kdc_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lola niye niwasagula Walawi na niwalava hagati ya Waizilaeli wose hanhu ha kila mwana chaudele wa kimbigalo wa Waizilaeli, avo Walawi wose wangu niye, ");
INSERT INTO kdc_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kwavija kila mwana chaudele wa munhu na wa mnyama ni wangu. Kipindi viniwakomile wana chaudele wa Wamisili nimsola kila mwana chaudele wa Izilaeli, kila mwana chaudele wa munhu na vivija wa mnyama, wose okuwa wangu. Niye ayo Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Musa viyakalile kuluwala lwa Sinai Mndewa Imulungu kamulongela, ");
INSERT INTO kdc_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Wapete Walawi wose kamba viweli muulelo wao na lukolo lwao, kila mbigalo kusongela wana ving'hele weli na mwezi umoja na kugendelela.” ");
INSERT INTO kdc_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Avo Musa kawapeta kamba Mndewa Imulungu, viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Wanage Lawi wakala, Gelishoni na Kohati na Melali. ");
INSERT INTO kdc_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gano gago matwaga ga wana wa Gelishoni kamba vizili ng'holo zao, Libini na Shimei. ");
INSERT INTO kdc_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Gano gago matwaga ga wana wa Kohati kamba vizili ng'holo zao, Amulamu na Ishali na Hebuloni na Uzieli. ");
INSERT INTO kdc_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Gano gago matwaga ga wana wa Melali kamba vizili ng'holo zao, Mahili na Mushi. Uno awo ulelo wa Walawi kamba viweli mzing'holo zao. ");
INSERT INTO kdc_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ng'holo za Walibini na Washimei zilawa kwa Gelishoni. ");
INSERT INTO kdc_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Wambigalo wose wapetigwe kusongela wana ving'hele weli na mwezi umoja na kugendelela wakala elufu saba na magana tano (7,500). ");
INSERT INTO kdc_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ulelo uno wa Gelishoni, walondigwa kwika ng'hambi yao mwambu wa kudihongela zuwa, kumzingo wa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Nayo Eliasafu mwanage Laeli kokuwa kilongozi wa ulelo wa Gelishoni. ");
INSERT INTO kdc_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Sang'hano ya ulelo wa Gelishoni ikala kudilola goya dihema da mting'hano, hamoja na ingubiko ya dihema na panziya da ulwivi lwa dihema, ");
INSERT INTO kdc_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","mapanziya ga uluwa uzunguluke dihema na upango wa nhosa na panziya da ulwivi lwa uluwa na nzabi zake. Sang'hano ayo yose ikala yao. ");
INSERT INTO kdc_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ng'holo za Waamulami na Waishali na Wahebuloni na Wauzieli zilawa kwa Kohati. ");
INSERT INTO kdc_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Iwambigalo wose kwa wose kusongela wana ving'hele weli na mwezi umoja na kugendelela wakala elufu nane na magana sita (8,600). Hewo sang'hano yao ikala kuvilola goya vinhu vili mna ihanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ulelo wa Kohati walondigwa weke ng'hambi yao mwambu wa kusini wa dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","nayo Elisafani mwanage Uzieli kakala kilongozi wa ulelo wa Kohati. ");
INSERT INTO kdc_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Hewo sang'hano yao ikala kudilola goya sanduku da lagano, na imeza na ikingolobweda cha kwikila taa, zimhango za nhosa na viya visang'hanilwa hanhu hong'ala na dipanziya da hanhu hong'ala ng'hani, sang'hano za vinhu avo vose ikala yao. ");
INSERT INTO kdc_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Nayo Eleazali mwanage mulava nhosa mkulu Haluni katendigwa yawe kilongozi wa iwakulu wa Walawi, na iwasang'hanaji wose wa hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ng'holo za Wamahili na Wamushi zilawa kwa Melali. ");
INSERT INTO kdc_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Uno awo ulelo wa Melali. Wambigalo wose wapetigwe kusongela wana ving'hele weli na mwezi umoja na kugendelela wakala elufu sita na magana mbili (6,200). ");
INSERT INTO kdc_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Kilongozi wa ulelo wa Melali kakala Sulieli mwanage Abihaili, awo olondigwa weke ng'hambi yao mwambu wa kasikazini wa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hewo sang'hano yao ikala kulola mbao za dihema da mting'hano na fito zake na zimhanda na vikalilo vake na vinhu vose va kugogeleza dihema, sang'hano ya vinhu avo vose ikala yao. ");
INSERT INTO kdc_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Vivija walondigwa kuzilola zimhanda za uluwa, na vikalilo vake na vifungilo vake na nzabi zake. ");
INSERT INTO kdc_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Haluni na wanao weka ng'hambi yao mwambu wa kudilawilila zuwa kuulongozi wa dihema da mting'hano, hewo sang'hano yao ikala kulava nhosa na kulola goya hanhu hong'ala na kusang'hana hanhu aho mbuli ya kinhu chochose kilondigwe kwa Waizilaeli. Munhu yoyose iyagwe yahakwesa behi yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Walawi wose kamba viweli muulelo wao, wambigalo wose kusongela wana ving'hele weli na mwezi umoja na kugendelela, awo wapetigwe na Musa na Haluni kamba viwalagizwe na Mndewa Imulungu wakala elufu ishilini na mbili (22,000). ");
INSERT INTO kdc_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Abaho Mndewa Imulungu kamulongela Musa, “Uwapete chaudele wose wa kimbigalo wa Waizilaeli kusongela wana ving'hele weli na mwezi umoja na kugendelela. ");
INSERT INTO kdc_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Vivija uwabagule Walawi mbuli yangu niye Mndewa Imulungu hanhu ha iwana wa chaudele wa iwanhu wa Izilaeli, na vivija ubagule fugo zose za Walawi kamba hanhu ha fugo za chaudele za wanhu wa Izilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Avo Musa kawapeta wana wose chaudele wa Waizilaeli, kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Wana chaudele wose wa kimbigalo kamba matwaga gao vigeli, kusongela wana ving'hele wa mwezi umoja na kugendelela, wakala elufu ishilini na mbili na magana mbili na sabini na ndatu (22,273). ");
INSERT INTO kdc_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Sambi wabagule Walawi wose wawe wangu hanhu ha wana chaudele wa Waizilaeli. Vivija ubagule fugo ya Walawi wose kamba hanhu ha wana chaudele wa fugo ya Waizilaeli, niye ayo Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Mbuli ya kuwagombolela wana chaudele wa kimbigalo wa Waizilaeli magana mbili sabini na ndatu (273), wabanzile iwambigalo wose wa Walawi, ");
INSERT INTO kdc_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","avo kulawa kwa kila imoja wa awo wabanzile usole vihande vitano va shaba kamba viwopima hanhu hong'ala, ");
INSERT INTO kdc_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","na sente azo za kuwagombolela awo wabanzile umgwee Haluni na wanage.” ");
INSERT INTO kdc_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Avo Musa katogola kuzisola sente azo za kuwagombolela awo wabanzile Walawi, awo waswelile kugomboligwa. ");
INSERT INTO kdc_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Avo kavibokela kulawa kwa awo iwana chaudele wa Waizilaeli vihande va shaba elufu moja magana ndatu sitini na tano, kamba viwopima hanhu hong'ala, ");
INSERT INTO kdc_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","kawagwaa Haluni na wanage zisente azo, kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mna Iwalawi wapeteni wanhu wa ulelo wa Kohati kamba viweli mzing'holo zao na mzing'anda zao, ");
INSERT INTO kdc_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","muwapete wambigalo wose weli na miyaka malongo madatu mbaka malongo matano waja odaha kusang'hana mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Sang'hano ya ulelo wa Kohati yokuwa kuvipapa viya vose vili hanhu hong'ala ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kipindi cha kusegela chahavika Haluni na wanage wengile mng'anda ya dihema wadihumuluse dipanziya dili kuulongozi wa disanduku da lagano, abaho wadigubike disanduku da lagano kwa panziya dijo. ");
INSERT INTO kdc_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Uchanha yake wadigubike na ing'hwembe ya mnyama wa mbahali na wadikunzule dikumbi da langi ya buluu. Abaho wengize zimango za kudipapila disanduku. ");
INSERT INTO kdc_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Uchanha ya meza ili kuulongozi wangu niye Mndewa Imulungu wakunzule dikumbi da buluu na uchanha yake weke sahani na ivikasi va ubani na bakuli na bilika mbuli ya kulavila nhosa ya king'waji. Gago gamagate gasigale aho mmeza siku zose. ");
INSERT INTO kdc_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Abaho, wavike viya vose mdikumbi didung'hu na uchanha yake weke ingubiko ya ng'hwembe ya mnyama wa mbahali. Abaho wengize zimango za kuipapila. ");
INSERT INTO kdc_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Wasole dikumbi da buluu wagubikile ikingolobweda cha kwikila taa hamoja na taa zake, na viya va kugogela makala ga moto na viya va kuhalila moto na viya vose va kwikila mavuta. ");
INSERT INTO kdc_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Abaho wakike ikingolobweda hamoja na viya vake vose mna ing'hwembe ya mnyama wa mbahali, na wengize zimango za kukipapila. ");
INSERT INTO kdc_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Abaho wakunzule dikumbi da buluu uchanha ya upango wa zahabu na waugubike kwa ng'hwembe ya mhala. Abaho wengize zimango za kuupapila. ");
INSERT INTO kdc_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Wasole viya vose va kusang'hanila hanhu hong'ala, wavifunge mdikumbi da buluu na wavigubike kwa ng'hwembe ya mhala, abaho wengize zimango za kupapila. ");
INSERT INTO kdc_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Wasegese imitozi ili uchanha ya uupango wa nhosa na wadikunzule dikumbi da langi ya zambalau uchanha yake. ");
INSERT INTO kdc_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Uchanha yake weke viya vose visang'haniligwa hana uupango, lwiko lwa kuzolela mitozi na bakuli na lwiko lwa kuhindulila nhosa na viya va kuhalila moto, abaho uchanha yake wakunzule ingubiko ya ng'hwembe ya mnyama wa mbahali. Na wengize zimango za kupapila. ");
INSERT INTO kdc_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Abaho, Haluni na wanage wahamambukiza kuhagubika hanhu hong'ala hamoja na vinhu vose viyagwe waitande kwa mwanza, abaho wanhu wa ulelo wa Kohati weze wavipape. Lakini hewo hawalondigwa kuvikwasa viya avo ving'alile ili sikuwafe, ino ayo sang'hano ya ulelo wa Kohati kipindi chose dihema da mting'hano chahahamizwa. ");
INSERT INTO kdc_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazali mwanage Haluni imulava nhosa, kolondigwa yagalolese mavuta ga taa na ubani na nhosa za ndiya zilavagwa kila siku na gamavuta gang'alile. Yalolese kila kinhu kili mgati ya dihema ajo.” ");
INSERT INTO kdc_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Sikumuwakanhe ulelo wa Kohati mna Iwalawi. ");
INSERT INTO kdc_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Avo, ili sikumuwahonze wakomigwe vonda wavikwesele viya avo ving'alile ng'hani, utende vino kumwao, Haluni na wanage wengile mgati na wampangile kila imoja sang'hano yake. ");
INSERT INTO kdc_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Lakini Wakohati hawalondigwa kwingila na kuvilola viya avo ving'alile, wahatenda vivo wofa.” ");
INSERT INTO kdc_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Uwapete wanhu wa ulelo wa Gelishoni kamba viweli mzing'holo zao na mzing'anda zao, ");
INSERT INTO kdc_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","uwapete wambigalo wose weli na miyaka malongo madatu mbaka malongo matano waja odaha kusang'hana mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Sang'hano yao yokuwa ino, ");
INSERT INTO kdc_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","kupapa mapanziya ga dihema da mting'hano, na ngubiko yake na ingubiko ya ng'hwembe ya mnyama wa mbahali na dipanziya dili haulwivi lwa dihema, ");
INSERT INTO kdc_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","wapape mapanziya na nzabi za uluwa uzunguluke dihema na upango wa nhosa, panziya da ulwivi lwa uluwa na vinhu vose va kusang'hanila mumo. Hewo sang'hano yao yokuwa kwa viya avo vose. ");
INSERT INTO kdc_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Sang'hano zose azo iwe kupapa hebu sang'hano yoyose iyagwe, waitende kwa kulagizwa na Haluni na wanage. Uwalagize ivinhu vose viwolondigwa kupapa. ");
INSERT INTO kdc_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Sang'hano ayo itendigwe na wanhu wa ulelo wa Gelishoni mna dihema da mting'hano na walongozwe na Itamali mwanage Haluni imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Uwapete wanhu wa ulelo wa Melali, kamba viweli mzing'holo zao na mzing'anda zao, ");
INSERT INTO kdc_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","uwapete wambigalo weli na miyaka malongo madatu mbaka miyaka malongo matano waja odaha kusang'hana mdihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Sang'hano yao yokuwa kupapa zimbao na zifito na zimhanda na ivikalilo va dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","vivija wapape na zimhanda za uluwa zizunguluke mhande zose, ivikalilo, na vifungilo vake na nzabi hamoja na vinhu vake vose na viya vake viyagwe vose. Na gweye kowapangila ivinhu va kupapa kamba matwaga gao vigeli. ");
INSERT INTO kdc_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Sang'hano ayo itendigwe na wanhu wa ulelo wa Melali mna dihema da mting'hano na walongozwe na Itamali mwanage Haluni imulava nhosa.” ");
INSERT INTO kdc_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Avo, Musa na Haluni na vilongozi wayagwe wa wanhu wawapeta wanhu wa ulelo wa Kohati kamba viweli mzing'holo zao na mzing'anda zao. ");
INSERT INTO kdc_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Wambigalo wose weli na miyaka malongo madatu mbaka malongo matano, kila munhu yadahile kusang'hana mna dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","wose kwa wose wakala elufu mbili na magana saba na hamsini (2,750). ");
INSERT INTO kdc_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Wanhu awo wa ulelo wa Kohati awo wasang'hane mdihema da mting'hano. Musa na Haluni wawapeta kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ulelo wa Gelishoni wapetigwa kamba viweli mzing'holo zao na mzing'anda zao. ");
INSERT INTO kdc_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Wambigalo wose weli na miyaka malongo madatu mbaka malongo matano, kila munhu yadahile kusang'hana mna dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","wose kwa wose wakala elufu mbili magana sita na selasini (2,630). ");
INSERT INTO kdc_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Wanhu awo wa ulelo wa Gelishoni awo wasang'hane mdihema da mting'hano. Musa na Haluni wawapeta kamba Mndewa Imulungu viyawalagize. ");
INSERT INTO kdc_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ulelo wa Melali wapetigwa kamba viweli mna zing'holo zao na mzing'anda zao. ");
INSERT INTO kdc_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Wambigalo wose weli na miyaka malongo madatu mbaka malongo matano, kila munhu yadahile kusang'hana mna dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","wose kwa wose wakala elufu ndatu na magana mbili (3,200). ");
INSERT INTO kdc_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Wanhu awo wa ulelo wa Melali awo wasang'hane mdihema da mting'hano. Musa na Haluni wawapeta kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Avo, Walawi wose wapetigwa na Musa na Haluni na vilongozi wa wanhu, kamba viweli mzing'holo zao na mzing'anda zao. ");
INSERT INTO kdc_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Wambigalo wose weli na miyaka malongo madatu mbaka malongo matano, kila munhu yadahile kusang'hana na kupapa dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","wose kwa wose wakala elufu nane na magana tano na semanini (8,580). ");
INSERT INTO kdc_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kila munhu kagweleligwa sang'hano yake ya kinhu cha kupapa, wapetigwa kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Walagize Waizilaeli wamulave kunze ya ing'hambi munhu yoyose yeli na utamu wa dikulu na munhu yolawa udusi na munhu yoyose yafitile kwa kukwasa maiti. ");
INSERT INTO kdc_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Muwalave kunze wanhu kamba awo, wambigalo na watwanzi ili sikuwawafitize wanhu zangu wayagwe mna ing'hambi inikala.” ");
INSERT INTO kdc_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Avo Waizilaeli wawalava wanhu kamba awo kunze ya ing'hambi watenda kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mndewa Imulungu kamulagiza Musa, ");
INSERT INTO kdc_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Walongele Waizilaeli, ‘Kamba munhu yoyose mbigalo hebu mtwanzi yahaleka kumtamanila Mndewa Imulungu na yahatenda nzambi, munhu ayo kokuwa kabananga. ");
INSERT INTO kdc_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Munhu ayo kolondigwa yaitambule nzambi ayo na kolondigwa yalihe kwa kija kiyabanange na vivija yongeze asilimia ishilini na abaho yamgwelele ija iyamtendele gehile. ");
INSERT INTO kdc_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Lakini kamba munhu ayo kafa na kamba kabule ndugu yodaha kubokela kija kilihigwe, avo kinhu acho kigaligwe kwa Mndewa Imulungu mbuli ya iwalava nhosa. Vivija yagale ng'hondolo wa kimbigalo ili yatendeligwe loholo da nzambi zake. ");
INSERT INTO kdc_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kila sadaka ing'alile ilavigwa na Waizilaeli kwa Mndewa Imulungu yokuwa ya mulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kila kinhu kilavigwe kwa Mndewa Imulungu, kinhu acho chokuwa cha mulava nhosa.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Walongele Waizilaeli, ‘Kamba mwehe wa munhu yahatenda ugoni na mbigalo iyagwe, ");
INSERT INTO kdc_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","bila mkasano wake kujuwa hata kamba kuduhu munhu yamgogile ugoni heyo kokuwa kafita. ");
INSERT INTO kdc_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Avo, mkasano wake yahakona shaka kwa mwehe wake ayo kamba kaifitiza hebu kamba yahamonela wivu hata kamba haifitize, ");
INSERT INTO kdc_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","avo wose wabili wachole kwa mulava nhosa na wagale nhosa ilondigwa, nhosa yenyego iwe vibaba vibili va usage wa shaili, lakini sikuugeligwe mavuta hebu ubani, kwavija ayo nhosa ya ndiya ya mbigalo yomonela shaka mwehe wake, nhosa ayo yolavigwa kwa mbuli ayo. ");
INSERT INTO kdc_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Mulava nhosa yamgale mtwanzi ayo behi, na yamwimize kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Abaho yagele mazi gong'ala mna inongo na abaho yadehe timbwisi dili kuuvungu wa dihema da mting'hano na yadigele mmo mnongo ili gamazi gawe usungu. ");
INSERT INTO kdc_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mulava nhosa yamwike mtwanzi ayo kuulongozi wa Mndewa Imulungu na yamgubule zimvili na yamgwee ayo inhosa ya indiya ilavigwe mbuli ya koneligwa shaka. Imulava nhosa yagoge inongo ili na mazi gogala makungu. ");
INSERT INTO kdc_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Abaho mulava nhosa yamduwilize ayo imtwanzi kuno yolonga, “Kamba huwasile na mbigalo iyagwe, na kuifitiza kuno kwa mmakono ga mkasano wako, avo makungu golawa mmazi gano geli usungu sikugakupate. ");
INSERT INTO kdc_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Lakini kamba kubena dilagano na kuno kwa mmakono ga mkasano wako na kuifitiza kwa kuwasa na mbigalo iyagwe yeli siyo mkasano wako, ");
INSERT INTO kdc_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","avo Mndewa Imulungu yakukoboze na uduwiligwe mna iwanhu wako, uwe mgumba na inda yako ivimbe. ");
INSERT INTO kdc_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mazi gano gogala makungu gengile mna iinda yako na gakutende mgumba na inda yako ivimbe.” Na ayo imtwanzi yedike, “Ona, Ona.” ");
INSERT INTO kdc_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Abaho mulava nhosa yagandike gago gamakungu mkitabu na yagakoshele mgamazi gago gausungu. ");
INSERT INTO kdc_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Abaho yamng'weze mtwanzi ayo gago gamazi geli usungu gogala makungu, nago gokwingila mgati na gomtenda inda yake ilume ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Abaho imulava nhosa yaisole ayo inhosa ya indiya ya koneligwa shaka mmakono ga ayo imtwanzi na yainule uchanha kamba kilaguso kwa Mndewa Imulungu abaho yaigale hana uupango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Abaho yadehe ganza dimoja da ayo inhosa ya indiya kamba kinhu cha kukumbuka kamba nhosa ayo yose ilavigwa kwa Mndewa Imulungu na yaisome moto muupango wa nhosa. Abaho yamng'weze ayo imtwanzi gago gamazi. ");
INSERT INTO kdc_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Yahamambukiza kugang'wa gago gamazi, kamba kaifitiza na kabena dilagano da umzengo, gago gamazi gogala makungu gomtenda inda yake ilume ng'hani, lukuli lwake lovimba na isambo yosambuka sambuka. Mtwanzi ayo kogakalila makungu mna iwanhu wake. ");
INSERT INTO kdc_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Lakini kamba mtwanzi ayo haifitize bule na habanange kinhu, avo kuduhu kinhu chonda kimpate, na kolela wana. ");
INSERT INTO kdc_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Avo gano gago malagizo kwa mbuli ya koneligwa shaka, kamba mtwanzi kammakono ga mkasano wake, na kobena lagizo da umzengo na koifitiza, ");
INSERT INTO kdc_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hebu kamba mbigalo yahakona wivu na komonela shaka mwehe wake. Komwimiza mtwanzi ayo kuulongozi wa Mndewa Imulungu, imulava nhosa kotenda gose golondigwa. ");
INSERT INTO kdc_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Imkasano kokuwa habanange kinhu, ila imtwanzi kolondigwa yagae kwa awo ubananzi wake.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Walongele Waizilaeli vino, ‘Kamba mbigalo hebu mtwanzi yahaiduwila yawe Mnazili, kamba heyo kailava kwa Mndewa Imulungu, ");
INSERT INTO kdc_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","avo sikuyang'we divai hebu ugimbi, na sikuyang'we mazi ga zabibu hebu kuja zabibu zipile hebu zinyalile. ");
INSERT INTO kdc_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Kipindi acho chose sikuyaje kinhu chochose kulawa mumzabibu, dikokwa hebu ing'hwembe ya kunze. ");
INSERT INTO kdc_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Kipindi acho chose sikuyabee mvili zake, mbaka chahesha acho ikipindi cha kuilava kwa Mndewa Imulungu, yakale yang'alile yazileke mvili zake ziwe nhali. ");
INSERT INTO kdc_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Siku zose viyokala kuno kailava kwa Mndewa Imulungu, sikuyaukwesele mtufi wa munhu yafile, ");
INSERT INTO kdc_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","hata kamba yahawa tatake, mamake, mkulu wake hebu mdodo wake hebu lumbu jake, sikuyaifitize kwavija mvili zake zolagusa heyo kailava kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kipindi acho chose kokuwa kang'ala kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Kamba munhu yahafa kwa kusinhukiza behi yake na kuzifitiza mvili zake, avo yabete mbaka siku da saba na kokuwa kang'ala na mdisiku da saba yabee mvili zake. ");
INSERT INTO kdc_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Mna isiku ya nane yamgalile imulava nhosa hana ulwivi lwa dihema da mting'hano huwa wabili hebu makinda mabili ga njiwa. ");
INSERT INTO kdc_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mulava nhosa yamulave imoja kwa nhosa ya kusegesa nzambi na iyagwe kwa nhosa ya kusoma moto, na heyo komtendela loholo, kwavija katenda nzambi mbuli ya maiti. Siku didijo yaditende pala jake ding'ale, ");
INSERT INTO kdc_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","na yailave kwa Mndewa Imulungu kwa siku zake za kuilava. Avo siku za ichanduso hazipetigwa bule kwavija mvili zake zikalile zilavigwe kwa Mndewa Imulungu zifitizigwa. Avo, yagale mwana ng'hondolo wa kimbigalo wa mwaka umoja kamba nhosa ya kulihila gehile. ");
INSERT INTO kdc_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Gano gago malagizo ga munhu Mnazili vonda yamambukize siku za kuilava kwa Mndewa Imulungu. Yagaligwe hana ulwivi lwa dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","na yamulavile Mndewa Imulungu nhosa zake. Mwana ng'hondolo wa kimbigalo wa mwaka umoja yelibule kilema chochose mbuli ya nhosa ya kusoma moto, na mwana ng'hondolo wa kitwanzi wa mwaka umoja yelibule kilema chochose mbuli ya nhosa ya kusegesa nzambi, na ng'hondolo wa kimbigalo yelibule kilema chochose mbuli ya nhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Vivija yagale kigelo kimemile magate hagageligwe hamila, na maandazi ga usage ulibule midundulu na utibwilizigwe na mavuta na vigate visisili vigeligwe mavuta na nhosa ya ndiya na king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Mulava nhosa yamulavile Mndewa Imulungu vinhu avo vose na vivija yalave inhosa ya kusegesa nzambi na nhosa ya kusoma moto. ");
INSERT INTO kdc_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Yamulavile Mndewa Imulungu ayo ing'hondolo wa kimbigalo kamba nhosa ya kugala kuilumba vivija yalave na ikigelo cha magate hagageligwe hamila na inhosa ya indiya na iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Aho hana ulwivi lwa dihema da mting'hano, munhu ayo yaiduwile yabee mvili zake na yazigele muumoto ukwaka hasi ya inhosa ya kugala kuilumba. ");
INSERT INTO kdc_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Abaho mulava nhosa yasole mkono wa ija ing'hondolo wa kimbigalo kuno ukimusigwe, yamgwee mmakono munhu ayo yaiduwile yahamambukiza kubea mvili zake ziyakalile nazo viyailavile kwa Mndewa Imulungu na vivija yamgwee andazi dimoja hadigeligwe hamila kulawa mkigelo na kigate kimoja kisisili hakigeligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Abaho mulava nhosa yavinule uchanha vinhu avo kulagusa kamba vilavigwa kwa Mndewa Imulungu. Vinhu avo vose ving'ala kwa imulava nhosa hamoja na ikidali kinuligwe uchanha na ikihili kilavigwe kamba nhosa. Vinhu avo vose vahatendigwa, munhu ayo yaiduwile kodaha kung'wa divai. ");
INSERT INTO kdc_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Gano gago malagizo kwa munhu Mnazili. Nhosa yake kwa Mndewa Imulungu iwe kamba viyaiduwile, hamoja kodaha kwengeza kulava kinhu chochose, heyo kolondigwa kutenda kamba viyaiduwile kamba malagizo gakuilava kwa Mndewa Imulungu vigalonda.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Mulongele Haluni na wanage, ‘Kamba vino vivo vimulondigwa kuwatambikila Waizilaeli. Muwalongele vino, ");
INSERT INTO kdc_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Mndewa Imulungu yawatendele ganogile na yawakalize. ");
INSERT INTO kdc_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mndewa Imulungu yawamwemwesele mulenge wa kihanga chake na yawonele bazi. ");
INSERT INTO kdc_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mndewa Imulungu yawenulile kihanga chake na yawagwee tindiwalo.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Mndewa Imulungu kalonga, “Kamba oditambula twaga jangu mbuli ya Waizilaeli, niye nowatendela ganogile.” ");
INSERT INTO kdc_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mna isiku Musa viyamambukize kudimiza wima dihema ding'ala, kadigidila mavuta na kadilava kwa Mndewa Imulungu hamoja na iviya vake vose, na kaugidila mavuta uupango wa nhosa na viya vake vose. ");
INSERT INTO kdc_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Vilongozi wa Izilaeli na iwakulu wa zing'holo na vilongozi wa gamakabila, awo wawemilile iwanhu wapetigwe weza mdihema, ");
INSERT INTO kdc_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","wamgalila Mndewa Imulungu sadaka zao. Mituka igubikigwe sita na ming'ombe mibigalo longo na wabili, na kila vilongozi wabili wagala mtuka umoja, na kila kilongozi kagala ng'ombe imoja mbigalo. Viwavigalile kuulongozi wa dihema ding'ala, ");
INSERT INTO kdc_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Uvibokele vinhu avo ili visang'hanilwe mna dihema da mting'hano, uwagwee Walawi vinhu avo, kila munhu kwa sang'hano yake.” ");
INSERT INTO kdc_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Avo Musa kasola imituka na iming'ombe mibigalo kawagwaa Walawi. ");
INSERT INTO kdc_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Wagelishoni wagweleligwa mituka mibili na ming'ombe mibigalo mine, kamba sang'hano yao ya kupapila ivinhu va dihema viikalile, ");
INSERT INTO kdc_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","na Wamelali wagweleligwa mituka mine na ming'ombe mibigalo mine, ili watendele sang'hano yao ya kupapila ivinhu va dihema. Walongozwa na kilongozi wao Itamali mwanage Haluni imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Lakini Musa hawagwelele kinhu chochose Wakohati, kwavija hewo wakala na sang'hano ya kuvilola goya viya ving'ala vilondigwa kupapigwa mmaega. ");
INSERT INTO kdc_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Vilongozi awo walava sadaka siku didija upango wa nhosa viugidiligwe mavuta mbuli ya kuulava upango awo kwa Mndewa Imulungu. Walava sadaka zao kuulongozi wa upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mndewa Imulungu kamulongela Musa, “Kila siku kilongozi imoja yagale sadaka yake mbuli ya kuulava kumwangu niye Mndewa Imulungu upango wa nhosa.” ");
INSERT INTO kdc_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Avo, munhu yasongile kugala sadaka siku ya ichanduso kakala Nashoni mwanage Aminadabu kulawa kabila da Yuda. ");
INSERT INTO kdc_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu na utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Nashoni mwanage Aminadabu. ");
INSERT INTO kdc_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Siku da kabili, Nasaneli mwanage Suali kilongozi wa kabila da Isakali kagala sadaka zake. ");
INSERT INTO kdc_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Nasaneli mwanage Suali. ");
INSERT INTO kdc_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Siku da kadatu ikala zamu ya Eliabu mwanage Heloni, kilongozi wa kabila da Zabuloni. ");
INSERT INTO kdc_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Eliabu mwanage Heloni. ");
INSERT INTO kdc_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Siku ya ikane ikala zamu ya Elisuli mwanage Shedeuli, kilongozi wa kabila da Lubeni. ");
INSERT INTO kdc_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Elisuli mwanage Shedeuli. ");
INSERT INTO kdc_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Siku ya tano ikala zamu ya Shelumieli mwanage Sulishadai, kilongozi wa kabila da Simeoni. ");
INSERT INTO kdc_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Shelumieli mwanage Sulishadai. ");
INSERT INTO kdc_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Siku da sita ikala zamu ya Eliasafu mwanage Deueli, kilongozi wa kabila da Gadi. ");
INSERT INTO kdc_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Eliasafu mwanage Deueli. ");
INSERT INTO kdc_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Siku da saba ikala zamu ya Elishama mwanage Amihudi, kilongozi wa kabila da Efulaimu. ");
INSERT INTO kdc_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nhosa zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo sadaka za Elishama mwanage Amihudi. ");
INSERT INTO kdc_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Siku da nane ikala zamu ya Gamalieli mwanage Pedasuli, kilongozi wa kabila da Manase. ");
INSERT INTO kdc_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nhosa zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Gamalieli mwanage Pedasuli. ");
INSERT INTO kdc_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Siku da tisa ikala zamu ya Abidani mwanage Gideoni, kilongozi wa kabila da Benjamini. ");
INSERT INTO kdc_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Abidani mwanage Gideoni. ");
INSERT INTO kdc_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Siku ya longo ikala zamu ya Ahiezeli mwanage Amishadai, kilongozi wa kabila da Dani. ");
INSERT INTO kdc_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","na bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo sadaka za Ahiezeli mwanage Amishadai. ");
INSERT INTO kdc_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Siku ya longo na imoja ikala zamu ya Pagieli mwanage Okilani, kilongozi wa kabila da Asheli. ");
INSERT INTO kdc_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Pagieli mwanage Okilani. ");
INSERT INTO kdc_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Siku ya longo na mbili ikala zamu ya Ahila mwanage Enani, kilongozi wa kabila da Nafutali. ");
INSERT INTO kdc_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Sadaka zake zikala, sahani imoja ya shaba ili na uzito wa kilo imoja na nusu na bakuli imoja ya shaba ili na uzito wa gilamu magana manane, kamba viwapimaga mna dihema ding'ala, ayo isahani na ibakuli vimemezigwa usage ulibule midundulu utibwilizigwe na mavuta mbuli ya nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","na kisahani kimoja cha zahabu kili na uzito wa gilamu gana na longo kuno kimemezigwa ubani, ");
INSERT INTO kdc_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","na bofu bigalo da ng'ombe, ng'hondolo wa kimbigalo imoja na mwana ng'hondolo wa kimbigalo yeli na mwaka umoja, mbuli ya nhosa ya kusoma moto, ");
INSERT INTO kdc_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","na mbuzi mbigalo imoja mbuli ya nhosa ya kusegesa nzambi, ");
INSERT INTO kdc_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","na ming'ombe mibigalo mibili, ng'hondolo wa kimbigalo watano, mbuzi wa kimbigalo watano na wana ng'hondolo wa kimbigalo watano wa mwaka umoja mbuli ya nhosa za kugala kuilumba. Azo zikala sadaka za Ahila mwanage Enani. ");
INSERT INTO kdc_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Sadaka zose kwa zose zilavigwe na vilongozi wa Izilaeli mbuli ya uupango wa nhosa siku viulavigwe kwa Mndewa Imulungu zikala, sahani za shaba longo na mbili, bakuli za shaba longo na mbili, na visahani va zahabu longo na mbili. ");
INSERT INTO kdc_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Kila sahani ya shaba ikala na uzito wa kilo imoja na nusu, na kila bakuli ya shaba ikala na uzito wa gilamu magana manane. Avo, viya vose avo vikala na uzito wa kilo malongo mabili na saba na gilamu magana sita kamba viwapimaga mna dihema ding'ala. ");
INSERT INTO kdc_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Avo ivisahani va zahabu longo na vibili vimemile ubani, kila kimoja kikala na uzito wa gilamu gana na longo kamba viwapimaga mna dihema ding'ala, vose kwa vose vikala na uzito wa kilo imoja na gilamu magana madatu na malongo mabili. ");
INSERT INTO kdc_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Wanyama wose wagaligwe mbuli ya nhosa ya kusoma moto wakala ming'ombe mibigalo longo na mibili, na ng'hondolo mbigalo longo na wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja wakala longo na mbili, hamoja na inhosa ya indiya na mbuzi mbigalo longo na mbili mbuli ya nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Wanyama wose wagaligwe mbuli ya nhosa ya kugala kuilumba wakala, ming'ombe mibigalo malongo mabili na wane, ng'hondolo mbigalo malongo sita, mbuzi mbigalo malongo sita na wana ng'hondolo wa kimbigalo wa mwaka umoja malongo sita. Azo zizo sadaka zilavigwe mbuli ya upango wa nhosa, siku viugidiligwe mavuta. ");
INSERT INTO kdc_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musa viyengile mna dihema da mting'hano ili kulonga na Mndewa Imulungu, kahulika sauti kulawa mwambu wa uchanha wa ingubiko ya disanduku da lagano, hagati ya awo iviumbe wabili weli na mabawa, sauti ayo imulongela. ");
INSERT INTO kdc_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Mulongele Haluni, ‘Vonda uzike azo zitaa saba mna ikingolobweda, uzike ili zimwemwese kuulongozi wa acho ikingolobweda.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Haluni katenda vivo, kazika azo zitaa ili zimwemwese mwambu wa kuulongozi wa ikingolobweda, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Kulawa uchanha mbaka hasi acho ikingolobweda kitendigwa kwa zahabu isomigwe kwa moto kamba vivija Mndewa Imulungu viyamulagusile Musa. ");
INSERT INTO kdc_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mndewa Imulungu kamulagiza Musa, ");
INSERT INTO kdc_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Uwabagule Walawi mna iwanhu wa Izilaeli, na uwatende wang'ale. ");
INSERT INTO kdc_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Vino vivo vonda uwatende wang'ale, wamizile mazi gang'alile abaho uwalongele wakaibee mzing'huli zao zose, na wafuwe viwalo vao na wakoge. ");
INSERT INTO kdc_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Abaho wasole bofu dimoja bigalo da ng'ombe na nhosa ya ndiya, awo uusage unogile utibwilizigwe na mavuta. Vivija na gweye usole dibofu diyagwe da ng'ombe mbuli ya nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Abaho uwatende wanhu wose wa Izilaeli waiting'hane na uwagale Walawi kuulongozi wa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Vonda uwagale Walawi kuulongozi wangu, Waizilaeli wose wayagwe wawekile makono gao Walawi, ");
INSERT INTO kdc_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","abaho Haluni yaweke awo Iwalawi kuulongozi wangu kamba nhosa ya kwinuligwa uchanha mna iwanhu wa Izilaeli ili wanisang'hanile. ");
INSERT INTO kdc_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Abaho Walawi weke makono gao mna gamapala ga awo iwang'ombe mbigalo, imoja umulave nhosa ya kusegesa nzambi, na iyagwe umulave nhosa ya kusoma moto ilavigwe kumwangu, ili uwatendele loholo awo Iwalawi. ");
INSERT INTO kdc_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Abaho uwatende Walawi weme kuulongozi wa Haluni na wanage na uweke kuulongozi wangu kamba nhosa ya kwinuligwa uchanha. ");
INSERT INTO kdc_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kwa nzila ayo kowabagula Walawi mna iwanhu wa Izilaeli wayagwe ili wawe wangu. ");
INSERT INTO kdc_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Wahamambukiza kuwatenda Walawi wang'ale na kuwalava kamba nhosa ya kwinuligwa uchanha, odaha kusang'hana kuna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Awo walavigwa kumwangu, hanhu ha wana chaudele wa kimbigalo wa Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kwavija wana chaudele wa kimbigalo mna iwanhu wa Izilaeli wangu niye, yawe munhu hebu mnyama, kwavija kudisiku viniwakomile wana chaudele wose ako Misili, niwalava hewo kumwangu. ");
INSERT INTO kdc_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Avo, sambi nowasola Walawi hanhu ha wana wa chaudele wa Waizilaeli, ");
INSERT INTO kdc_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","na nimgwelela Haluni na wanage, kamba nhunza kulawa kwa Waizilaeli, ili wasang'hane kuna dihema da mting'hano mbuli ya Waizilaeli na wawatendele loholo ili sikukulawilile mikubulo hagati ya Waizilaeli vonda wakwese hanhu hong'ala.” ");
INSERT INTO kdc_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Avo, Musa na Haluni na wanhu wose wa Izilaeli wawalava Walawi kwa Mndewa Imulungu, kamba Mndewa viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Walawi waisunha mbuli ya nzambi zao na wavifuwa viwalo vao, na Haluni kawalava kamba nhosa ya kwinuligwa uchanha kuulongozi wa Mndewa Imulungu. Vivija Haluni kawatendela loholo ili wang'ale. ");
INSERT INTO kdc_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ago gose vigatendigwe Walawi wasonga kusang'hana kuna dihema da mting'hano kuno olongozwa na Haluni na wanage, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Kila Mulawi yeli na miyaka malongo mabili na tano na kugendelela kolondigwa yasang'hane kuna dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na yaleke sang'hano ayo yahavikiza miyaka malongo matano. ");
INSERT INTO kdc_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Lakini, kodaha kuwataza Walawi wayage kukaliza dihema, ila sikuyasang'hane sang'hano za siku zose. Vino vivo vonda uwagwelele Walawi sang'hano za kusang'hana.” ");
INSERT INTO kdc_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Abaho Mndewa Imulungu kamulongela Musa kuluwala lwa Sinai mna umwezi wa ichanduso muumwaka wa kabili toka viwasegele mwiisi ya Misili, kalonga, ");
INSERT INTO kdc_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Waizilaeli waideng'helele nyimwilinyimwili ya Pasaka mna ikipindi kikigwe. ");
INSERT INTO kdc_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Nyimwilinyimwili ayo yokuwa siku ya longo na nne muumwezi uno na wakweleleze malagizo gake.” ");
INSERT INTO kdc_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Avo, Musa kawalongela Waizilaeli kamba olondigwa waideng'helele nyimwilinyimwili ayo ya Pasaka. ");
INSERT INTO kdc_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Avo, waideng'helela nyimwilinyimwili ayo ya Pasaka kuluwala lwa Sinai mna isiku ya longo na nne mna umwezi wa ichanduso. Waizilaeli watenda kila kinhu kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Lakini wanhu wayagwe wakalile kuko hawadahile kuideng'helela nyimwilinyimwili ayo ya Pasaka, kwavija wakala wakwasile maiti, avo wafita. Wanhu awo wamcholela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","wawalongela, “Siye tufita kwavija tukwasa maiti, avo habali togomesigwa kumulavila Mndewa Imulungu nhosa zake mna ikipindi kikigwe hamoja na Waizilaeli wayagwe?” ");
INSERT INTO kdc_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa kawedika, “Beteni mbaka vonda nipate malagizo ga mbuli yenu kulawa kwa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Na Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Walongele Waizilaeli, ‘Imoja wenu hebu munhu wa ulelo wenu yahakuwa kafita mbuli ya kukwasa maiti hebu kamnzila mmwanza, lakini kolonda kuideng'helela nyimwilinyimwili ya Pasaka, ");
INSERT INTO kdc_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","munhu ayo kodaha kuideng'helela mna isiku ya longo na nne ya mwezi wa kabili. Yaideng'helele kwa kuja nyama ya ng'hondolo na magate hagageligwe hamila na mboga zili usungu. ");
INSERT INTO kdc_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sikuwasigase kinhu chochose mbaka imitondo vivija sikuwabene zege jojose da ing'hondolo wa Pasaka na waideng'helele Pasaka kamba malagizo gake vigolonga. ");
INSERT INTO kdc_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Lakini munhu yoyose yong'ala hebu heli mmwanza, yahaleka kuideng'helela nyimwilinyimwili ya Pasaka, yabaguligwe na wanhu zake kwavija hanilavile nhosa mna ikipindi kikigwe. Kolondigwa yatagusigwe kwa nzambi yake. ");
INSERT INTO kdc_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Kamba kuna munhu baki kokala kumwenu na kolonda kuideng'helela nyimwilinyimwili ya Pasaka, kolondigwa yatende kamba malagizo ga Pasaka vigolonda. Kila munhu kolondigwa yakweleleze malagizo gano, yawe munhu baki hebu mwenekae.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Siku vidisimikigwe dihema ding'alile, wingu dihumuluka na kudigubika dihema. Ikilo mbaka imitondo wingu dijo joneka kamba moto. ");
INSERT INTO kdc_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Vivo viikalile kila siku, imisi wingu digubika dihema na ikilo joneka kamba moto. ");
INSERT INTO kdc_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Wingu dijo dahasegelaga uchanha ya dihema, Waizilaeli otula ng'hambi yao na okwika ng'hambi kabili hanhu kudili wingu dijo. ");
INSERT INTO kdc_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Waizilaeli wasegela kwa kulagizwa na Mndewa Imulungu na vivija weka ng'hambi kwa kulagizwa na Mndewa Imulungu. Kipindi chose wingu dijo vidikala uchanha ya dihema wanhu wakala mwiing'hambi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kamba wingu dijo dikala uchanha ya dihema kwa siku nyingi, Waizilaeli wamtegeleza Mndewa Imulungu na hawasegele bule. ");
INSERT INTO kdc_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kipindi kiyagwe wingu dijo dikala uchanha ya dihema kwa siku ndodo, lakini Waizilaeli wakalile mwiing'hambi wasegela kamba Mndewa Imulungu viyalagize. ");
INSERT INTO kdc_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kipindi kiyagwe wingu dikala uchanha ya dihema kulawa ichungulo mbaka imitondo, na vidisegesigwe wagendelela na mwanza. Na kamba wingu dikala uchanha ya dihema imisi yose na kilo kigima, dahasegesigwa na hewo osonga kusegela. ");
INSERT INTO kdc_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kamba wingu dahakala uchanha ya dihema kwa siku mbili hebu mwezi umoja hebu mwaka, Waizilaeli osigala mna ing'hambi, lakini dahasegesigwa na hewo vivija osegela. ");
INSERT INTO kdc_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kwa kulagizwa na Mndewa Imulungu Waizilaeli weka ng'hambi na kwa kulagizwa na Mndewa Imulungu wagendelela na mwanza. Wagagoga malagizo ga Mndewa Imulungu kamba viyalagize kubitila Musa. ");
INSERT INTO kdc_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tenda mhalati mbili za shaba ing'ala, na mhalati azo zitoigwe kipindi cha kuwakema wanhu na kipindi cha kubena ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Mhalati zose mbili zahatoigwa hamoja, wanhu wose waiting'hane behi na gweye kuulongozi wa ulwivi lwa idihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Lakini kamba yahatoigwa mhalati imoja, vilongozi waiyeka wa makabila ga Izilaeli awo olondigwa kuiting'hana kuulongozi wako. ");
INSERT INTO kdc_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Mhalati ayo yahatoigwa kidogo, wanhu iwokala kuzing'hambi zili mwambu wa kudilawila zuwa wasonge kusegela. ");
INSERT INTO kdc_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Mhalati ayo yahatoigwa kidogo mwanza wa kabili, iwanhu okala kuzing'hambi za mwambu wa kusini wasonge kusegela. Kila kipindi mhalati yahatoigwa kamba avo yokuwa kilaguso cha kusonga umwanza. ");
INSERT INTO kdc_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Lakini kipindi cha kuwakema wanhu waiting'hane, mhalati azo zitoigwe kwa kugendelela siyo kidogo. ");
INSERT INTO kdc_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Wanhu wa ulelo wa Haluni, awo iwalava nhosa, awo onda wazitowe azo zimhalati. Mbuli azo muzigoge siku zose mweye na ulelo wenu. ");
INSERT INTO kdc_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Kipindi cha ng'hondo mwiisi yenu na iwanhu owehila wahawavamila, mulave kilaguso cha ng'hondo kwa kutowa azo zimhalati ili Mndewa Imulungu, Imulungu wenu, yawakumbuke na yawahonye kulawa kwa iwanhu owehila. ");
INSERT INTO kdc_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Vivija mna ikipindi chenu cha kudeng'helela, kamba vija nyimwilinyimwili za kusimbuka kwa mbalamwezi na nyimwilinyimwili ziyagwe, mozitowa mhalati azo kipindi vimulava nhosa zenu za kusoma moto na nhosa zenu za kugala kuilumba. Baho niye Mndewa Imulungu, Imulungu wenu nowakumbuka. Niye ayo Mndewa Imulungu, Imulungu wenu.” ");
INSERT INTO kdc_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Mna isiku ya malongo mabili ya mwezi wa kabili, mwaka wa kabili toka Waizilaeli viwasegele Misili, wingu dikalile dimile uchanha ya dihema da mting'hano disegesigwa, ");
INSERT INTO kdc_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","na Waizilaeli wasonga mwanza wa kusegela kuluwala lwa Sinai. Wingu dijo disegela na abaho dima kuluwala lwa Palani. ");
INSERT INTO kdc_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Kwa mwanza wa ichanduso Waizilaeli wasegela kwa kulagizwa na Mndewa Imulungu, kamba Musa viyawalongele. ");
INSERT INTO kdc_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Waja wakalile hasi ya ibendela ya kabila da Yuda, wasonga kusegela kibumbila kimoja mbaka kibumbila kiyagwe. Kilongozi wa kabila da Yuda kakala Nashoni mwanage Aminadabu. ");
INSERT INTO kdc_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nasaneli mwanage Suali kakala kilongozi wa kabila da Isakali. ");
INSERT INTO kdc_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Na heyo Eliabu mwanage Heloni kakala kilongozi wa kabila da Zabuloni. ");
INSERT INTO kdc_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Abaho, dihema difunguligwa na wanhu wa ulelo wa Gelishoni na Melali awo wadipapile, wasonga kusegela. ");
INSERT INTO kdc_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Abaho, iwanhu wakalile hasi ya ibendela ya kabila da Lubeni, wasegela kibumbila kimoja mbaka kibumbila kiyagwe. Kilongozi wa kabila da Lubeni kakala Elisuli mwanage Shedeuli. ");
INSERT INTO kdc_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mwanage Sulishadai kakala kilongozi wa kabila da Simeoni. ");
INSERT INTO kdc_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Na heyo Eliasafu mwanage Deueli kakala kilongozi wa kabila da Gadi. ");
INSERT INTO kdc_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Abaho wanhu wa ulelo wa Kohati wasonga mwanza kuno wapapa viya ving'alile. Viwavikile, wavika dihema disimikigwa. ");
INSERT INTO kdc_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Abaho, iwanhu wakalile hasi ya bendela ya kabila da Efulaimu, wasonga kusegela kibumbila kimoja mbaka kibumbila kiyagwe. Kilongozi wa kabila da Efulaimu kakala Elishama mwanage Amihudi. ");
INSERT INTO kdc_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwanage Pedasuli kakala kilongozi wa kabila da Manase, ");
INSERT INTO kdc_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","na Abidani mwanage Gideoni kakala kilongozi wa kabila da Benjamini. ");
INSERT INTO kdc_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kukimambukizo, waja wakalile hasi ya bendela ya kabila da Dani, wakalile kamba wakalizi wa ivibumbila vose vilongole, wasonga kusegela, kibumbila kimoja mbaka kibumbila kiyagwe. Kilongozi wa kabila da Dani kakala Ahiezeli mwanage Amishadai. ");
INSERT INTO kdc_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mwanage Okilani kakala kilongozi wa kabila da Asheli. ");
INSERT INTO kdc_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Na Ahila mwanage Enani kakala kilongozi wa kabila da Nafutali. ");
INSERT INTO kdc_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Vino vivo viwatendile Waizilaeli kamba viwakalile mna ivibumbila vao, kila viwabenile ing'hambi na kusonga kusegela. ");
INSERT INTO kdc_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Avo, Musa kamulongela mulamu wake yokemigwa Hobabu mwanage Leueli, Mmidiani mkwe wake, “Siye tochola hanhu hohose Mndewa Imulungu kuyalongile, ‘Nowagwaa mweye hanhu hano.’ Avo, tuchole wose, na siye tokutendela ganogile, kwavija Mndewa Imulungu kalonga kotugwaa siye Waizilaeli ganogile.” ");
INSERT INTO kdc_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu kedika, “Aka niye sichola na mweye, ila nobwela mwiisi yangu kwa wanhu wa lukolo lwangu.” ");
INSERT INTO kdc_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa kamulongela, “Chonde sikuutuleke, kwavija gweye kojuwa hanhu ha kwika ing'hambi ako kuluwala, na kodaha kuwa kilongozi wetu. ");
INSERT INTO kdc_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kamba wahachola na siye chochose kinogile chonda yatutendele Mndewa Imulungu, na gweye vivija kotendeligwa kinhu acho.” ");
INSERT INTO kdc_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Avo wanhu wachola umwanza kwa siku ndatu kulawa kulugongo lwa Mndewa Imulungu. Sanduku da lagano da Mndewa Imulungu diwalongolela kuzahila hanhu ha kwika ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kila viwakalile ochola kulawa ng'hambi imoja mbaka iyagwe, wingu da Mndewa Imulungu dikala uchanha yao imisi yose. ");
INSERT INTO kdc_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kila kipindi sanduku vidinuligwe ili wasegele, Musa kalonga, “Inuka, gweye Mndewa Imulungu, uwapwililise iwanhu okwihila, na uwatende wakimbile kuulongozi wako.” ");
INSERT INTO kdc_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Na sanduku vidinenuligwe, Musa kalonga, “Oo Mndewa Imulungu wabwelele wanhu maelufu kwa maelufu ga Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Wanhu wasonga kumuyalalila Mndewa Imulungu mbuli ya magazo gao. Mndewa Imulungu viyahulike vivo kagevuzika, kagala moto hagati yao. Moto awo ukwaka na kulukuza kumgwazo wa ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wanhu wamulilila Musa, na heyo kampula Mndewa Imulungu na moto awo ufa. ");
INSERT INTO kdc_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Avo hanhu aho hakemigwa Tabela, kwavija moto kulawa kwa Mndewa Imulungu ukwaka hagati ya iwanhu. ");
INSERT INTO kdc_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mna iwanhu wa Izilaeli kukala na wanhu wayagwe wakala osulukila ng'hani kuja nyama. Avo Waizilaeli wasonga kulila olonga, “Maza tupate nyama tuje! ");
INSERT INTO kdc_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Towakumbuka waja iwasomba watukalile towaja bule ako Misili, matanga, matigiti, mhuza, vitungulu na vitungulu saumu! ");
INSERT INTO kdc_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Lakini sambi tudonha haduhu ndiya iyagwe ila ino imana iiyeka!” ");
INSERT INTO kdc_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ikala kamba viwili uhemba, langi yake ikala kamba ya ukole. ");
INSERT INTO kdc_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Wanhu wazunguluka na waidondola, abaho wadunda kwa mabwe ga kudundila hebu waidunda mmatuli, abaho waiteleka na watenda magate, uhailanza ikala kamba vigate vikanzingigwe kwa mavuta. ");
INSERT INTO kdc_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kungugu vidilagale mna ing'hambi ikilo vivija imana nayo ilagala na dijo dikungugu. ");
INSERT INTO kdc_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa kahulika wanhu olila kuzing'anda zose, kila munhu hana ulwivi lwa kibanda chake. Avo, Mndewa Imulungu kagevuzika ng'hani na Musa vivija kagevuzika. ");
INSERT INTO kdc_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Avo, Musa kamulongela Mndewa Imulungu, “Habali konitendela gehile niye msang'hanaji wako? Habali konihila niye na kunigwaa zigo da kuwalola wanhu wose wano? ");
INSERT INTO kdc_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kwani niye ayo niwalumbile, kwani niye ayo niwalelile, mbaka kunongela niwapape mmhambaga yangu kamba mlezi viyopapa king'hele, na niwagale mwiisi yuuiduwile kwa iwahenga zao? ");
INSERT INTO kdc_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Noipata kwahi nyama ya kuwagwaa wanhu wose wano? Kwavija olila kuulongozi wangu olonga, ‘Tugwee nyama tuje!’ ");
INSERT INTO kdc_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sidaha kuwalola wanhu wose wano niye niiyeka, zigo dino sididaha bule! ");
INSERT INTO kdc_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kamba konitendela vino, vinoga unikome! Kamba koninogela, sikuundeke nigae kabili.” ");
INSERT INTO kdc_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Avo, Mndewa Imulungu kamulongela Musa, “Wating'hanize wavele malongo saba wa Izilaeli, awo oukona gweye otegelezigwa na otogoligwa kamba vilongozi, uwagale mdihema da mting'hano, weme behi na gweye. ");
INSERT INTO kdc_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nohumuluka hanhu aho na kulonga na gweye, na nosola hanhu ha loho inikugwelele gweye, nowagwaa wanhu awo. Na hewo owalola wanhu wano hamoja na gweye, ili sambi udipape zigo dino gweye wiiyeka. ");
INSERT INTO kdc_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Avo walongeleni iwanhu, ‘Muisasale mbuli ya mayo, moja nyama. Mndewa Imulungu kahulika molila na kulonga kuduhu wa kuwagwaa nyama, na kamba mukala vinogile ako Misili. Avo, Mndewa Imulungu kowagwaa nyama, na molondigwa muije. ");
INSERT INTO kdc_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Moja nyama siyo kwa siku dimoja diiyeka hebu siku mbili hebu siku tano hebu siku longo hebu siku malongo mabili, ");
INSERT INTO kdc_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","lakini moja nyama kwa kipindi chose cha mwezi mgima! Moija mbaka iwalawile mmhula, na mbaka moidonha. Gano gose kwavija mmulema Mndewa Imulungu yeli baha hagati yenu, na molila kuno molonga, Habali tusegela Misili?’ ” ");
INSERT INTO kdc_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Lakini Musa kamulongela Mndewa Imulungu, “Iwambigalo wose oniwalongoza laki sita awo ogenda kwa magulu, na gweye kolonga, ‘Nowagwaa nyama ya kuja mwezi mgima!’ ");
INSERT INTO kdc_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Avo, todaha kuchinja ng'hondolo na ng'ombe ili wose wenele? Avo, tukavule iwasomba wose mmbahali mbuli yao?” ");
INSERT INTO kdc_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mndewa Imulungu kamulongela Musa, “Vino udahi wangu uhunguka? Beta ulole kamba gaja ganongile gaukweli hebu siyo.” ");
INSERT INTO kdc_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Avo Musa kasegela kawalongela iwanhu gaja galongigwe na Mndewa Imulungu. Abaho kawasagula wavele malongo saba kulawa hagati ya iwavele weli vilongozi na kaweka behi kuzunguluka dihema. ");
INSERT INTO kdc_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Aho Mndewa Imulungu kahumuluka mdiwingu na kalonga na heyo. Abaho kasola hanhu ha iloho iyamgwelele Musa, kawagwaa kila imoja wa awo iwavele malongo saba. Loho ayo viiwengile awo iwavele wasonga kulagula, lakini hawabwelele kutenda vivo. ");
INSERT INTO kdc_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Wavele wabili mna iwavele awo malongo saba wasaguligwe, Elidadi na Medadi wakala wasigale mna ing'hambi, wayao viwacholile kuna dihema. Loho iwezila mumo mna ing'hambi wasonga kulagula aho kuwakalile. ");
INSERT INTO kdc_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mbwanga imoja kasomoka kakimbila kamulongela Musa, “Elidadi na Medadi olagula kuna ing'hambi.” ");
INSERT INTO kdc_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Avo, Yoshua mwanage Nuni, yakalile komtaza Musa toka viyakalile mbwanga, kamulongela, “Musa mkulu wangu wagomese!” ");
INSERT INTO kdc_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa kamulongela, “Vino kokona migongo mbuli ya niye? Vahanogile Mndewa Imulungu yahawagwelele loho yake wanhu wose wawe watula ndagu!” ");
INSERT INTO kdc_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Abaho Musa kabwela kuna ing'hambi hamoja na awo iwavele wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Bahaja Mndewa Imulungu kagala beho nyukwanyukwa, beho ajo digala ng'hwale kulawa mbahali na wema behi na ing'hambi, wakala utali wa mwanza wa kuchola siku dimoja kila mwambu kuzunguluka ing'hambi, wailundiza hamoja kuvikila mkigudi kulawa hasi. ");
INSERT INTO kdc_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Avo, siku ayo yose imisi na ikilo na siku iyagwe, wanhu wahunganika kudondola ng'hwale, kuduhu munhu yadondole hasi ya kilo elufu imoja. Wawanika ili wanyale kila hanhu kumgwazo wa ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nyama viikalile ing'hali nyingi na wanhu viwakalile wang'hali kuimambukiza kuija. Mndewa Imulungu kawagevuzikila iwanhu, kawatowa kwa mikubulo mikulu. ");
INSERT INTO kdc_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Avo hanhu aho hakemigwa Kibiloti Hataava, kwavija hanhu aho, aho kuwazikigwe iwanhu wakalile wamelo. ");
INSERT INTO kdc_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kulawa aho Kibiloti Hataava wanhu wachola mbaka Haseloti, weka ng'hambi yao na wakala kuko. ");
INSERT INTO kdc_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Abaho Miliamu na Haluni wasonga kumulonga vihile Musa kwavija kakala yasolile mtwanzi Mkushi. ");
INSERT INTO kdc_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Walonga, “Vino Mndewa Imulungu kalonga na kumulagiza Musa yaiyeka? Vino halongile na siye vivija?” Mndewa Imulungu kazihulika mbuli azo. ");
INSERT INTO kdc_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa kakala muhole ng'hani, kubanza iwanhu wose wayagwe wakalile mwiisi. ");
INSERT INTO kdc_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Bahaja Mndewa Imulungu kawalongela, Musa na Haluni na Miliamu, “Mweye wadatu mwize kuna dihema da mting'hano.” Avo, wose wadatu wachola kuna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Baho Mndewa Imulungu kahumuluka mna imhanda ya wingu, kema hana ulwivi lwa dihema, kawakema Haluni na Miliamu. Wose wabili wakwesa kuulongozi. ");
INSERT INTO kdc_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Abaho Mndewa Imulungu kawalongela, “Tegelezeni mbuli zangu. Kamba hana mtula ndagu hagati yenu, niye Mndewa Imulungu noigubula kwa kumulagusila vinhu na nolonga na heyo mzinzozi. ");
INSERT INTO kdc_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Lakini kwa msang'hanaji wangu Musa, haili vivo. Heyo kana sang'hano ya kuwalola wanhu zangu wose. ");
INSERT INTO kdc_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Niye nolonga na heyo kihanga kwa kihanga, silonga kwa kuzunguluka. Heyo konyona niye Mndewa Imulungu vinili. Avo habali hamdumbile kumulonga vihile msang'hanaji wangu Musa?” ");
INSERT INTO kdc_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Aho Mndewa Imulungu kawagevuzikila, kasegela. ");
INSERT INTO kdc_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Wingu vidisegele uchanha ya dihema, Miliamu koneka kana utamu wa dikulu, ukala mzelu kamba pamba. Haluni viyahinduke na kumulola Miliamu kakanganya, kumona kana utamu wa dikulu. ");
INSERT INTO kdc_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aho Haluni kamulongela Musa, “Chonde nokupula mndewa wangu, sikuutukoboze kwavija tutenda ubozi na nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Sikuumtende Miliamu yawe kamba munhu yavumbuke yafile, na nusu ya lukuli lwake lukola.” ");
INSERT INTO kdc_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa kamulilila Mndewa Imulungu yolonga, “Chonde, go Mndewa Imulungu muhonye!” ");
INSERT INTO kdc_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Lakini Mndewa Imulungu kamulongela Musa, “Kamba tatake yahamtemela mate mkihanga chake, vino, sambi yakone kinyala kwa siku saba? Avo, mulave kunze ya ing'hambi yakale kuko kwa siku saba, abaho yabwele mwiing'hambi.” ");
INSERT INTO kdc_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Avo, Miliamu kawingigwa yachole kunze ya ing'hambi kwa siku saba. Wanhu hawagendelele na mwanza mbaka Miliamu viyabwezigwe kuna ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Vigabitile gago wanhu wagendelela na mwanza kulawa Haseloti, weka ng'hambi kuluwala lwa Palani. ");
INSERT INTO kdc_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Watume wanhu wachole wakaisungulile isi ya Kanaani, isi yonda niwagwee wanhu wa Izilaeli. Umtume munhu imoja kulawa kila kabila, na munhu ayo yawe kilongozi.” ");
INSERT INTO kdc_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kwa kulagizwa na Mndewa Imulungu Musa kawatuma wanhu kulawa kuluwala lwa Palani. Wanhu watumigwe wakala vilongozi wa makabila gose ga Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Gano gago matwaga ga wanhu awo. Kabila da Lubeni, kachola Shamua mwanage Zakuli. ");
INSERT INTO kdc_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kabila da Simeoni kachola Shafati mwanage Holi. ");
INSERT INTO kdc_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kabila da Yuda kachola Kalebu mwanage Yefune. ");
INSERT INTO kdc_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kabila da Isakali kachola Igali mwanage Yusufu. ");
INSERT INTO kdc_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kabila da Efulaimu kachola Hoshea mwanage Nuni. ");
INSERT INTO kdc_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kabila da Benjamini kachola Paliti mwanage Lafu. ");
INSERT INTO kdc_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kabila da Zabuloni kachola Gadieli mwanage Sodi. ");
INSERT INTO kdc_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kabila da Yusufu ndio kulonga kabila da Manase, kachola Gadi mwanage Susi. ");
INSERT INTO kdc_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kabila da Dani kachola Amieli mwanage Gemali. ");
INSERT INTO kdc_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kabila da Asheli kachola Setuli mwanage Mikaeli. ");
INSERT INTO kdc_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kabila da Nafutali kachola Nabi mwanage Wofisi. ");
INSERT INTO kdc_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kabila da Gadi kachola Geueli mwanage Maki. ");
INSERT INTO kdc_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Gano gago matwaga ga iwanhu Musa yawatumile wachole wakaisungulile isi ya Kanaani. Musa kamgwaa Hoshea mwanage Nuni, twaga diyagwe, kamkema Yoshua. ");
INSERT INTO kdc_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa viyawatumile wachole wakaisungulile isi ya Kanaani, kawalongela, “Avo choleni Negebu, mkakwele ivigongo, ");
INSERT INTO kdc_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","mkaisungulile ili mujuwe isi ayo viili. Vivija loleni kamba iwanhu iwokala mumo wana nguvu hebu wadoda, kamba wengi hebu wadodo. ");
INSERT INTO kdc_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Loleni kamba isi ayo inoga hebu iha, na mulole kamba wanhu okala mzing'hambi hebu okala mzing'anda zizungulusiligwe. ");
INSERT INTO kdc_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Vivija isungulileni kamba isi yenyego ina mboji hebu kuduhu, ina muhulo hebu kuduhu. Mgangamale vonda mubwele soleni matunda ga isi ayo.” Kipindi acho ukala msimu wa zabibu kusonga kwipa. ");
INSERT INTO kdc_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Avo wanhu awo wachola kuisungulila isi ayo kulawa kuluwala lwa Sini mbaka Lehobu, behi na nzila ya kwingilila Hamati. ");
INSERT INTO kdc_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wachola mbaka Negebu na wabita mbaka buga da Hebuloni. Amo wawavika Waahimani na Washeshai na Watalimai, ulelo wa Anaki. Buga da Hebuloni dikala dilongole kuzengwa kwa miyaka saba ding'hali hadinazengwa buga da Soani dili ako Misili. ");
INSERT INTO kdc_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Viwavikile kubonde da Eshikoli, wanhu awo wakanha tambi dikalile na zabibu nyingi, wasomeka lumango wadipapa wanhu wabili. Vivija wasola makomamanga na tini. ");
INSERT INTO kdc_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Hanhu aho hakemigwa bonde da Eshikoli mbuli ya ditambi da zabibu dikanhigwe na iwanhu awo wa Izilaeli kuko. ");
INSERT INTO kdc_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Viwamambukize kuisungulila isi ayo kwa siku malongo mane, wanhu awo wabwela. ");
INSERT INTO kdc_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wabwela kwa Musa na Haluni na umting'hano wose wa Waizilaeli ako Kadeshi, kuluwala lwa Palani, walonga gose gawone na wawalagusila matunda ga isi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wamulongela Musa, “Tuvika mwiisi yuututumile kuisungulila, isi ayo imema maziwa na uki! Gano gago matunda ga isi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Lakini iwenekae wa isi ayo wana nguvu ng'hani na mabuga gao makulu na gazunguluswa senyenge ya mibwe. Vivija tuyona mizinhu mikulu, awo iwanhu wa ulelo wa Anaki. ");
INSERT INTO kdc_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Waamaleki okala ako Negebu, Wahiti na Wayebusi na Waamoli okala kuvigongo, na Wakanaani okala behi na bahali ya Meditelania na behi ya lwanda lwa Yolidani.” ");
INSERT INTO kdc_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Lakini Kalebu kawatenda wanhu wanyamale kuulongozi wa Musa, kawalongela, “Tucholeni tukaisole isi ayo, kwavija todaha kuwahuma.” ");
INSERT INTO kdc_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Lakini iwanhu wacholile kuisungulila isi ayo na heyo, walonga, “Hatudaha kuwatowa wanhu awo, hewo wana nguvu kubanza siye.” ");
INSERT INTO kdc_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Avo wabwililisa mbuli za uvizi hagati ya Waizilaeli mbuli ya isi ayo iwacholile kuisungulila, walonga, “Isi ayo hainogile bule kukala. Vivija iwanhu wose tuwone kuko wakulu ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ako tuyona mizinhu mikulu, awo iwanhu wa ulelo wa Anaki. Siye tuyona kamba mbalangulu na hewo vivo watuwone.” ");
INSERT INTO kdc_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ikilo acho wanhu wose wa Izilaeli waiyalala na kulila. ");
INSERT INTO kdc_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Wamuyalalila Musa na Haluni walonga, “Vinoga twahafile ako Misili! Vinoga twahafile baha kuluwala! ");
INSERT INTO kdc_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Habali Mndewa Imulungu kotugala mwiisi ayo? Tokomigwa mwiing'hondo, wehe zetu na wanetu ogogigwa! Vinoga tubwele Misili.” ");
INSERT INTO kdc_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Avo wasonga kuilongela, “Tusagule kilongozi, tubwele Misili!” ");
INSERT INTO kdc_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Avo, Musa na Haluni wagwa kingubanguba kuulongozi wa iwanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshua mwanage Nuni na Kalebu mwanage Yefune, awo wakalile mna iwanhu wacholile kuisungulila isi ayo, wadega viwalo vao kwa usungu, ");
INSERT INTO kdc_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","wawalongela wanhu wose wa Izilaeli, “Isi itucholile kuisungulila inoga ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kamba Mndewa Imulungu kotunogela, kotugala kuko na kotugwaa isi ayo imemile maziwa na uki. ");
INSERT INTO kdc_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Lakini sikummuleme Mndewa Imulungu, na sikumuwadumbe iwenekae wa isi ayo, kwavija hewo kamba wana wadodo kumwetu. Kiwotamanila kisegesigwa, lakini Mndewa Imulungu kahamoja na siye, sikumuwadumbe!” ");
INSERT INTO kdc_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Lakini iwanhu wose walonda kuwatowa mabwe. Bahaja ukulu wa Mndewa Imulungu oneka uchanha ya dihema da mting'hano, kuulongozi wa iwanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Abaho Mndewa Imulungu kamulongela Musa, “Vino wanhu wano onibezeli mbaka lini? Mbaka lini ogendelela kuleka kunitamanila, hamoja nitenda vinhu vingi va unzonza hagati yao? ");
INSERT INTO kdc_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nowakoboza kwa mitamu, na nowafagila wose, lakini kulawa kumwako gweye, notenda wanhu wa isi iyagwe, weli na nguvu kubanza hewo!” ");
INSERT INTO kdc_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Lakini Musa kamulongela Mndewa Imulungu, “Kuwalava wanhu wano mwiisi ya Misili kwa nguvu zako. Wamisili wahahulika kamba kuwatenda vivo wanhu zako, ");
INSERT INTO kdc_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","owalongela wanhu okala isi ino. Wanhu wano wahulika kamba gweye Mndewa Imulungu kwa hamoja na siye, kwavija gweye Mndewa Imulungu koneka kwa meso kipindi wingu jako dahemaga uchanha yetu, na gweye kutulongolelaga, imisi kwa mhanda ya wingu na ikilo kwa mhanda ya moto. ");
INSERT INTO kdc_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Avo, kamba uhawakoma wanhu zako kwa mwanza umoja, wanhu wa isi ziyagwe zihulike nhogolwa zako olonga, ");
INSERT INTO kdc_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mndewa Imulungu kawakoma wanhu zake kuluwala kwavija kalemelwa kuwagala mwiisi iyaiduwile kowagwaa.’ ");
INSERT INTO kdc_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Avo, sambi nokupula Mndewa Imulungu, utulagusile udahi wako kwa kutenda kamba viutulongele, ");
INSERT INTO kdc_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Niye Mndewa Imulungu sigevuzika himahima, nimema bazi na nogela kumgongo nzambi na gehile. Lakini sileka kuwakoboza wana na wazukulu mbaka ulelo wa kadatu na wa ikane kwa nzambi za iwahenga zao.’ ");
INSERT INTO kdc_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Nokupula ugele kumgongo nzambi za wanhu wano, kamba unogelwa wako viwili mkulu na kamba viuzigelaga kumgongo nzambi za wanhu wano toka walawe ako Misili mbaka sambi.” ");
INSERT INTO kdc_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mndewa Imulungu kamwidika, “Nizigela kumgongo nzambi zao kamba viupulile. ");
INSERT INTO kdc_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Lakini nokulongela, kamba niye vinili mgima, na kamba isi yose viimemile ukulu wangu, ");
INSERT INTO kdc_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","haduhu hata munhu imoja mna iwao onile ukulu wangu na unzonza niutendile Misili na kuluwala abaho onigeza miyanza yose na olema kunitegeleza, ");
INSERT INTO kdc_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","koyona isi iniiduwile kwa wahenga zao kamba nowagwaa, vivija na iwanhu waja onibezeli niye honda wayone. ");
INSERT INTO kdc_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Lakini kwavija msang'hanaji wangu Kalebu kavingine, na kanitegeleza goya, nomvikiza mwiisi ayo iyacholile kuisungulila, vivija ulelo wake oitawala. ");
INSERT INTO kdc_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kwavija Waamaleki na Wakanaani okala kugamabonde ga isi ayo, avo mayo mubwele kukisogo muchole kuluwala kuna inzila ilongoza bahali ya Shamu.” ");
INSERT INTO kdc_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Abaho Mndewa Imulungu kamuuza Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Wanhu wano ogendelela kuniyalalila mbaka lini? Nidonha na kuiyalala kwa wanhu wa Izilaeli! ");
INSERT INTO kdc_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Avo walongeleni, ‘Kamba vinili mgima nolonga niye Mndewa Imulungu, nowatendela gagaja gamhulike molonga. ");
INSERT INTO kdc_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mofa na ng'huli zenu zopigisigwa mmuno kuluwala kwavija muniyalalila niye, kuduhu hata imoja wenu yapetigwe yeli na miyaka malongo mabili na kugendelela, ");
INSERT INTO kdc_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","yonda yengile mwiisi iniwalongele nowagwaa iwe yenu, ila Kalebu mwanage Yefune na Yoshua mwanage Nuni. ");
INSERT INTO kdc_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mweye mulonga wanenu ogogigwa, lakini niye nowavikiza wanenu mwiisi imuibezeli, na isi ayo yokuwa kae yao. ");
INSERT INTO kdc_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Lakini mweye mofila kukuno kuluwala. ");
INSERT INTO kdc_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wanenu ogunga na kugaya kukuno kuluwala kwa miyaka malongo mane mbuli ya mweye kuswela kutamanila mbaka vonda mufe mose kuluwala. ");
INSERT INTO kdc_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mbuli ya ago gehile genu, mogaya kwa miyaka malongo mane, kamba vizili siku azo zimucholile kuisungulila isi ayo, kila siku mwaka umoja. Avo, mojuwa kumulema Imulungu ndio choni.’ ");
INSERT INTO kdc_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Niye Mndewa Imulungu nilonga, nowatendela vivo kamba vimuiting'hane kunilema. Wanhu wose okwamila baha kuluwala na wose ofila baha.” ");
INSERT INTO kdc_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Wanhu waja watumigwe na Musa wachole kuisungulila isi ayo, waja wabwelile na kuwatenda wanhu wose wamuyalalile Mndewa Imulungu kwa kugala usenga wihile mbuli ya isi ayo, ");
INSERT INTO kdc_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","wanhu awo wagalile usenga awo wafa kwa mikubulo kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Lakini Yoshua mwanage Nuni, na Kalebu mwanage Yefune, wasigala wagima mna iwanhu awo wacholile kuisungulila isi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Nayo Musa kawalongela Waizilaeli mbuli zija ziyalongeligwe na Mndewa Imulungu, na hewo walila kwa usungu. ");
INSERT INTO kdc_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Imitondo ng'hani wachola kuvigongo walonga, “Sambi todaha kuchola hanhu aho hayatulongele Mndewa Imulungu. Totogola kamba tutenda nzambi.” ");
INSERT INTO kdc_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Lakini Musa kalonga, “Avo habali mobena lagano da Mndewa Imulungu? Avo mohumwa! ");
INSERT INTO kdc_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Sikumuchole ako kuna ivigongo, sambi mutoigwe na iwanhu owehila, kwavija Mndewa Imulungu heli na mweye. ");
INSERT INTO kdc_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Avo mwahachola kuitowa na Waamaleki na Wakanaani, mofa kuing'hondo kwavija mulema kumkweleleza Mndewa Imulungu, heyo hali hamoja na mweye.” ");
INSERT INTO kdc_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Lakini hewo wasusumiza kuchola uchanha kuvigongo, hamoja sanduku da lagano da Mndewa Imulungu na vivija Musa hasegele kuna ing'hambi. ");
INSERT INTO kdc_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Avo Waamaleki na Wakanaani wakalile okala mwiisi ayo ya ivigongo wahumuluka hasi wawatowa na kuwahuma, wawawinga mbaka mwiisi ya Holima. ");
INSERT INTO kdc_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Walongele Waizilaeli vino ‘Vonda mwingile mwiisi iniwagwelela mukale, ");
INSERT INTO kdc_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","na mweye mogala nhosa yenu kuulongozi wangu niye Mndewa Imulungu kulawa mzifugo zenu, nhosa za kusoma moto hebu nhosa ziyagwe kwa kuvikiza gaja gaulongile hebu kwa kulonda wenyego hebu kwa nyimwilinyimwili zenu, nhosa azo zogala mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Avo munhu ayo yogala ng'hondolo hebu mbuzi kamba nhosa yake, vivija yamgalile Mndewa Imulungu nhosa ya ndiya, vibaba vibili va usage ulibule midundulu na utibwilizigwe na mavuta nyhupa imoja, ");
INSERT INTO kdc_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","hamoja na nyhupa imoja ya divai kamba nhosa ya king'waji. Vinhu avo vigaligwe hamoja na inhosa ya kusoma moto hebu zinhosa ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Kamba munhu kogala ng'hondolo mbigalo vivija yagale mhishi imoja ya usage ulibule midundulu na utibwilizigwe na mavuta nyhupa imoja na nusu kamba nhosa ya ndiya, ");
INSERT INTO kdc_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","hamoja na nyhupa imoja na nusu ya divai kamba nhosa ya king'waji, ili kutenda ininung'hile goya niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Kipindi vonda munigalile niye Mndewa Imulungu ng'ombe mbigalo mbuli ya nhosa ya kusoma moto hebu nhosa ziyagwe kwa kuvikiza gaja gaulongile hebu kwa kugala kuilumba, ");
INSERT INTO kdc_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","vivija mugale nhosa ya ndiya ya usage unogile mhishi imoja na vibaba vibili utibwilizigwe na mavuta nyhupa mbili, ");
INSERT INTO kdc_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","hamoja na divai nyhupa mbili kamba nhosa ya king'waji isomigwa kwa moto, ili kugala mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“ ‘Avo vinhu avo vilavigwe hamoja na kila ng'ombe mbigalo, na ng'hondolo na mbuzi. ");
INSERT INTO kdc_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Vinhu avo vongezigwe kwa kuigala na iwanyama onda walavigwe. ");
INSERT INTO kdc_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Kila Mwiizilaeli yakweleleze malagizo gago kipindi viyolava nhosa ya kusoma moto, kamba mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Na kamba kuna munhu baki yokala hamoja na mweye kwa siku ndodo hebu siku nyingi, yahalonda kulava nhosa yake ya kusoma moto kamba mnung'ho uninogeza niye Mndewa Imulungu, munhu ayo yatende kamba mweye vimutenda. ");
INSERT INTO kdc_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Muulelo wenu wose onda wize, malagizo gagaja gomukweleleza mweye gago gonda wakweleleze hewo na vivija munhu baki yoyose yokala hamoja na mweye. Mgameso ga Mndewa Imulungu mose mwa sawa, ");
INSERT INTO kdc_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","mweye na heyo molongozwa na malagizo gago.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Walongele Waizilaeli, ‘Vonda mwingile mwiisi yonda niwagale, ");
INSERT INTO kdc_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kila vonda muje ndiya ya isi ayo, molondigwa mwike kumgwazo hanhu ha ndiya na mundavile niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mwahakoka magate, gate da ichanduso dilawile mna izindiya za ichanduso, dilavigwe kamba nhosa ilawile hanhu ha kubigila uhemba. ");
INSERT INTO kdc_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mundavile niye Mndewa Imulungu nhosa ayo ulelo wenu wose onda wize. ");
INSERT INTO kdc_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Lakini kamba munhu bila kujuwa kaleka kugagoga malagizo gose ganiwagwelele niye Mndewa Imulungu kubitila Musa, ");
INSERT INTO kdc_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","na kamba ako kumwande wanhu oleka kugakweleleza gaja gose niye Mndewa Imulungu ganimulongele Musa, ");
INSERT INTO kdc_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","avo kamba kinhu acho kitendigwa bila kujuwa, bila Waizilaeli wose kujuwa, avo Waizilaeli wose wagale bofu dimoja da kimbigalo da ng'ombe mbuli ya nhosa ya kusoma moto, kamba mnung'ho uninogeza niye Mndewa Imulungu, hamoja na inhosa ya indiya na iking'waji kamba malagizo vigalonda. Vivija wanhu wagale mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mulava nhosa kowatendela loholo wanhu wose wa Izilaeli, na nzambi zao zogeligwa kumgongo kwavija watenda nzambi bila kujuwa, na wagala nhosa zao kwa Mndewa Imulungu, nhosa ya kusoma moto na nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Avo Waizilaeli wose na iwanhu baki okala hamoja na hewo, nzambi zao zogeligwa kumgongo kwavija wose waitenda nzambi ayo bila kujuwa. ");
INSERT INTO kdc_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Munhu yahatenda nzambi bila kujuwa, kolondigwa yagale mbuzi imoja mtwanzi yeli na mwaka umoja yawe nhosa ya kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mulava nhosa yamtendele loholo munhu ayo kuulongozi wa Mndewa Imulungu, na nzambi zake zogeligwa kumgongo. ");
INSERT INTO kdc_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mokuwa na malagizo gagano kwa munhu yoyose yotenda nzambi bila kujuwa, yawe mwenekae hebu munhu baki yokala hamoja na mweye. ");
INSERT INTO kdc_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Lakini munhu yoyose yotenda nzambi giladi, yawe mwenekae hebu munhu baki, ayo komuliga Mndewa Imulungu, avo kolondigwa yabaguligwa mna iwanhu zake. ");
INSERT INTO kdc_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Kwavija kagalema gaja gayalongile Mndewa Imulungu na kabena malagizo gake. Munhu ayo yabaguligwe na nzambi yake yokuwa mdipala jake mwenyego.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Siku dimoja Waizilaeli viwakalile kuluwala, wamona munhu imoja kodondola ngodi kudisiku da kubwihila. ");
INSERT INTO kdc_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Avo, munhu ayo kagaligwa kuulongozi wa Musa na Haluni na mting'hano wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Avo wamgela mmakono, kwavija wakala hawajuwile munhu ayo yatendigwe choni. ");
INSERT INTO kdc_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Avo, Mndewa Imulungu kamulongela Musa, “Munhu ayo kolondigwa yakomigwe, umting'hano wose wa Izilaeli wamtowe mabwe kunze ya ing'hambi.” ");
INSERT INTO kdc_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Avo, wanhu wamulava kunze ya ing'hambi, wamtowa mabwe mbaka kafa, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Walongele wanhu wa Izilaeli, ‘Muisonele vikumbi mna izimhindo za viwalo venu, na mwike luzi lwa langi ya buluu uchanha ya kila kikumbi. Mutende vivo muulelo wenu wose onda wize. ");
INSERT INTO kdc_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Vikumbi avo vokuwa kinhu cha kukumbuka kumwenu. Kila mwahavona mogakumbuka malagizo gangu na kugakweleleza, ili sikumukweleleze gaja gomulonda na gaja gomukona kwa meso genu wenyego. ");
INSERT INTO kdc_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Vikumbi avo vowakumbusa malagizo gangu gose na mogagoga gose, na mweye mokala mung'alile kumwangu. ");
INSERT INTO kdc_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Niye ayo Mndewa Imulungu, Imulungu wenu niwalavile mwiisi ya Misili ili niwe Imulungu wenu. Niye ayo Mndewa Imulungu, Imulungu wenu.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ako kumwande, Kola mwanage Ishali, mzukulu wa Kohati mwanage Lawi, hamoja na wanhu wadatu kulawa kabila da Lubeni wakala, Datani na Abilamu wanage Eliabu na Oni mwanage Peleti, ");
INSERT INTO kdc_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","awo wose hamoja na vilongozi magana mabili na malongo matano, wasaguligwe na Waizilaeli wose, wamulema Musa. ");
INSERT INTO kdc_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Waiting'hana kuulongozi wa Musa na Haluni wawalongela, “Mweye mubanza ng'hani! Mting'hano wa wanhu wose ung'ala na kila munhu yeli hano kang'ala, na Mndewa Imulungu kahamoja na siye wose. Habali mweye moitenda wakulu wa mting'hano wa wanhu wa Mndewa Imulungu?” ");
INSERT INTO kdc_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa viyahulike avo, kaibwanha hasi kingubanguba. ");
INSERT INTO kdc_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Abaho kamulongela Kola na iwanhu wose wamkweleleze, “Mayo imitondo, Mndewa Imulungu kolagusa nani yeli wake na nani yong'ala, na heyo yonda yamsagule, komtenda yakwese behi yake. ");
INSERT INTO kdc_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Avo, tendeni vino, imitondo gweye na wanhu wako okukweleleza, soleni viya va kuhalila makala ga moto, ");
INSERT INTO kdc_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","haleni makala ga moto na mugele ubani uchanha yake, abaho mvigale kuulongozi wa Mndewa Imulungu. Abaho tolola nani yasaguligwe na Mndewa Imulungu. Mweye Walawi mbanza ng'hani!” ");
INSERT INTO kdc_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa kagendelela kumulongela Kola, “Tegelezeni mweye Walawi! ");
INSERT INTO kdc_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Vino, mweye mokona mbuli ndodo kumwenu, Mndewa Imulungu kawasagula mweye hagati ya Waizilaeli wose, ili mumkwesele behi na musang'hane mdihema da Mndewa Imulungu, na muwasang'hanile wanhu wose? ");
INSERT INTO kdc_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kawagwaa ukulu wa kukala behi na heyo, mweye hamoja na Walawi waenu wose. Lakini sambi vivija molonda na ulava nhosa? ");
INSERT INTO kdc_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Avo, gweye na wayago momulema Mndewa Imulungu. Mweye momuyalalila Haluni, lakini ukweli mweye momuyalalila Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Abaho Musa katuma usenga kwa Datani na Abilamu wanage Eliabu, ili weze, lakini hewo walonga, “Hatwiza bule! ");
INSERT INTO kdc_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Vino mbuli ndodo gweye kutulava Misili, isi imemile maziwa na uki, ili wize kutukoma kuno kuluwala? Abaho koitenda mkulu wetu! ");
INSERT INTO kdc_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Abaho hutugalile mwiisi imemile maziwa na uki na hutugwelele migunda ya kulima na migunda ya mizabibu. Kogizaga kodaha kuwatenda wanhu wano wawe wasuwameso? Siye hatwiza bule!” ");
INSERT INTO kdc_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa kagevuzika ng'hani, kamulongela Mndewa Imulungu, “Sikuuzitogole nhosa za wanhu wano. Niye sisolile kihongwe wa munhu yoyose na simulumize munhu!” ");
INSERT INTO kdc_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa kamulongela Kola, “Mayo gweye na wayago mwize kuulongozi wa Mndewa Imulungu. Vivija Haluni kokuwa hamoja na mweye. ");
INSERT INTO kdc_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kila imoja wenu yasole kiya chake cha kuhalila makala ga moto, na yagele ubani na abaho yakigale kuulongozi wa Mndewa Imulungu, vose kwa vose vokuwa viya magana mabili na malongo matano, vivija gweye na Haluni, kila imoja kokuwa na kiya chake.” ");
INSERT INTO kdc_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Avo kila imoja wao kasola kiya chake cha kuhalila makala ga moto, kagela makala ga moto na ubani, abaho wachola na wema wima hana ulwivi lwa dihema da mting'hano, hamoja na Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Na heyo Kola kawating'haniza wanhu wose hamoja, wema wima kuulongozi wa Musa na Haluni awo wakalile hana ulwivi lwa dihema da mting'hano. Abaho ukulu wa Mndewa Imulungu uwalawilila wanhu wose! ");
INSERT INTO kdc_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Abaho Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Segeleni hagati ya umting'hano uno, ili niwakome wose sambi baha.” ");
INSERT INTO kdc_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Lakini Musa na Haluni wagwa kingubanguba walonga, “Go Mndewa Imulungu, gweye uli mwanduso wa ugima wa wanhu wose. Vino munhu imoja yahakutendela gehile kowagevuzikila wanhu wose?” ");
INSERT INTO kdc_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Walongele wanhu, ‘Kweseni kutali na ikibanda cha Kola na Datani na Abilamu.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Avo Musa kachola kwa Datani na Abilamu, na vilongozi wa Waizilaeli wamkweleleza, ");
INSERT INTO kdc_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","viyavikile kawalongela iwanhu, “Chonde segeleni kuna ivibanda va wanhu wano wehile, sikumkwase kinhu chao chochose, ili sikumukomigwe hamoja na hewo mbuli ya nzambi yao.” ");
INSERT INTO kdc_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Avo wanhu wasegela kutali na ikibanda cha Kola na Datani na Abilamu. Datani na Abilamu walawa kunze na kwima hana ulwivi lwa ivibanda vao hamoja na wehe zao na wanao wose mbaka waja wakalile okong'ha. ");
INSERT INTO kdc_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa kawalongela iwanhu, “Sambi mojuwa kamba Mndewa Imulungu ayo yanilagize niye kutenda mbuli zino zose, na siyo notenda vinilonda. ");
INSERT INTO kdc_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kamba wanhu wano wahafa ifa kamba siku zose wanhu wayagwe viwofa, avo mjuwe kamba Mndewa Imulungu hanitumile bule. ");
INSERT INTO kdc_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Lakini kamba Mndewa Imulungu yahatenda kinhu hakinatendigwa, na kamba isi yogubuka na kuwameza wanhu wano hamoja na vinhu vao vose, ochola hanhu kowochola wanhu wafile kuno wang'hali wagima, baho mojuwa wanhu wano wambezeli Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Bahaja viyamambukize kulonga mbuli azo, isi igubuka hasi ya Dasani na Abilamu, ");
INSERT INTO kdc_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","na iwameza wanhu awo hamoja na kae zao na wanhu wose wailumbile hamoja na Kola na vinhu vao vose. ");
INSERT INTO kdc_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Wahumulukila kowochola wanhu wafile kuno wang'hali wagima. Isi iwagubika, wose walawanya. ");
INSERT INTO kdc_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Waizilaeli wose wayagwe wakalile behi viwahulike wanhu awo olila, wakimbila walonga, “Tukimbile! Isi sikuitumeze na siye vivija!” ");
INSERT INTO kdc_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Abaho Mndewa Imulungu kagala moto uwalukuza wanhu waja magana mabili na malongo matano wacholile kulava ubani. ");
INSERT INTO kdc_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mulongele Eleazali mwanage Haluni imulava nhosa yavisegese avo iviya hana umoto, yaupwililise kutali awo umoto, kwavija viya avo ving'ala. ");
INSERT INTO kdc_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Viya avo ving'ala kwavija wanhu awo wavigala muupango wa nhosa wa Mndewa Imulungu. Avo, visole viya avo va wanhu awo wakomigwe mbuli ya nzambi zao, vilumbuligwe kwa moto ili viwe ngubiko ya upango wa nhosa. Mbuli ayo yokuwa kilaguso kwa Waizilaeli wose.” ");
INSERT INTO kdc_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Avo Eleazali imulava nhosa kavisola viya avo va shaba ya kiguzi, vigaligwe kuulongozi wa Mndewa Imulungu na wanhu waja walukuzigwe vilumbuligwa kwa moto, na ilawa ngubiko ya upango wa nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Mbuli ayo ikala kilaguso kwa Waizilaeli kamba munhu heli mulava nhosa, ndio kulonga halawa muulelo wa Haluni sikuyachole hana uupango wa nhosa na kusoma ubani kuulongozi wa Mndewa Imulungu. Ama sivo kokomigwa kamba Kola na wayage. Ago gose gatendigwa kamba Mndewa Imulungu viyamulagize Eleazali kubitila Musa. ");
INSERT INTO kdc_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Imitondo yake Waizilaeli wose wamuyalalila Musa na Haluni walonga, “Muwakoma wanhu wa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Viwakalile waiting'hane kuulongozi wa Musa na Haluni kuno oiyalala, wahinduka kulola kuna dihema da mting'hano, wona wingu digubika dihema, na ukulu wa Mndewa Imulungu ulawilila aho. ");
INSERT INTO kdc_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa na Haluni wachola wema kuulongozi wa dihema da mting'hano, ");
INSERT INTO kdc_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","na Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Segeleni hagati ya iwanhu awo, sambi baha nolonda kuwakoma wose!” Lakini hewo wagwa kingubanguba. ");
INSERT INTO kdc_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa kamulongela Haluni, “Sola kiya chako cha kuhalila makala ga moto, gela makala ga moto kulawa muupango wa nhosa, abaho ugele ubani na uchole nacho himahima kwa iwanhu uwatendele loholo. Lopola! Ng'hasiliki ya Mndewa Imulungu iwavikila na utamu usonga hagati yao.” ");
INSERT INTO kdc_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Avo Haluni katenda kamba Musa viyamulongele. Kasola kiya chake na kakimbila mbaka hagati ya iwanhu wakalile waiting'hane. Utamu ukala usongile hagati ya iwanhu, kagela ubani mna ikiya chake na kawatendela iwanhu loholo. ");
INSERT INTO kdc_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Viyatendile avo, utamu awo usegela na heyo kakala hagati ya iwanhu wafile na wagima. ");
INSERT INTO kdc_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Iwanhu wose kwa wose wafile kwa utamu awo wakala elufu kumi na nne na magana saba (14,700), bila kuwapeta waja wafile mbuli ya nzambi ya Kola. ");
INSERT INTO kdc_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Utamu awo viusegele, Haluni kabwela kwa Musa hana ulwivi lwa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Walongele Waizilaeli wakugalile fimbo longo na mbili, kila kilongozi wa kabila fimbo imoja. Ujandike twaga da kila imoja wao mna ifimbo yake, ");
INSERT INTO kdc_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","na twaga da Haluni ujandike uchanha ya ifimbo ilagusa kabila da Lawi. Avo hokuwa na fimbo imoja kwa kila kilongozi wa kabila. ");
INSERT INTO kdc_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Abaho uzisole fimbo azo uzigale mdihema da mting'hano na uzike kuulongozi wa sanduku da lagano hanhu aho kuniiting'hanaga na gweye. ");
INSERT INTO kdc_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Fimbo ya munhu yonda nimsagule, yozuka. Kwa nzila ayo nowatenda Waizilaeli waleke kuwayalalila mweye.” ");
INSERT INTO kdc_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa kawalongela Waizilaeli. Vilongozi wa iwanhu wose wamgwaa kila imoja fimbo yake kamba kabila jake vidili, zose kwa zose zikala fimbo longo na mbili. Fimbo ya Haluni ikigwa hamoja na fimbo azo. ");
INSERT INTO kdc_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Abaho Musa kazika fimbo azo zose kuulongozi wa Mndewa Imulungu mna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Imitondo yake, Musa kengila mna dihema da mting'hano, mumo kayona fimbo ya Haluni imunhu kulawa kabila da Lawi, izuka na ilawa matambi galike maluwa na kulela matunda gepile ga mulozi. ");
INSERT INTO kdc_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Abaho Musa kazigala kunze fimbo zose aho kuulongozi wa Mndewa Imulungu, kawalagusila Waizilaeli wose, na kila kilongozi kasola fimbo yake. ");
INSERT INTO kdc_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mndewa Imulungu kamulongela Musa, “Ibweze fimbo ya Haluni kuulongozi wa disanduku da lagano. Aho yokala goya, acho chokuwa kinhu cha kuwazuma iwanhu awo walemaga kamba wahagendelela kuiyalala wofa.” ");
INSERT INTO kdc_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa katenda kamba Mndewa Imulungu viyamulagize. ");
INSERT INTO kdc_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Waizilaeli wamulongela Musa, “Lola! Tokobozigwa! Wose tofa! ");
INSERT INTO kdc_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Munhu yoyose yonda yakwese hana dihema da Mndewa Imulungu kofa. Vino wose vivija tofa?” ");
INSERT INTO kdc_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mndewa Imulungu kamulongela Haluni, “Gweye na wanago na Walawi wayagwe wa lukolo lwa Kohati mosola gehile gose mbuli ya dihema king'ala. Gweye na wanago mopapa gehile gose gotendigwa na iwalava nhosa mbuli ya sang'hano ayo. ");
INSERT INTO kdc_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Gweye, wanago na ulelo wako wose mosang'hana kamba walava nhosa mdihema kuulongozi wa sanduku da lagano, wanhu wayagwe wa kabila jako owataza kipindi gweye na wanago vimusang'hana. ");
INSERT INTO kdc_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Hewo osang'hana sang'hano zose zonda uwagwelele mna dihema. Lakini hawalondigwa kuvikwasa viya vili mdihema hebu kuukwesela behi upango wa nhosa, wahatenda avo wose gweye na wao mofa. ");
INSERT INTO kdc_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Hewo osang'hana hamoja na gweye kuna dihema da mting'hano, na osang'hana sang'hano zao lakini munhu yoyose iyagwe sikuyakukwesele behi. ");
INSERT INTO kdc_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Gweye na wanago wao monda musang'hane aho hana ihanhu hong'ala na muupango wa nhosa ili ng'hasiliki yangu sikuiwezile kabili Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Niye ayo niwasagule ndugu zenu Walawi mna iwanhu Waizilaeli kamba nhunza kumwenu. Hewo walavigwa mbuli yangu niye Mndewa Imulungu ili wasang'hane kuna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Lakini gweye wiiyeka na wanago mosang'hane kamba walava nhosa mbuli ya uupango wa nhosa na vinhu vose vili mna ihanhu hong'ala. Sang'hano ayo yenu mweye kwavija niwagwaa nhunza ya ulava nhosa. Munhu yoyose iyagwe yahakwesa behi na ihanhu hong'ala yakomigwe.” ");
INSERT INTO kdc_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mndewa Imulungu kamulongela Haluni, “Nokugwaa gweye sadaka ziwanilavile Waizilaeli, nokugwaa vinhu Waizilaeli wavilavile kumwangu nokugwaa gweye. Nokugwaa gweye na ulelo wako vinhu vose avo kamba fungu jenu, ajo dokuwa fungu jenu siku zose. ");
INSERT INTO kdc_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Mna ivinhu vose ving'alile ng'hani vija havilukuzigwa muumoto, avo vokuwa venu. Nhosa ya ndiya na nhosa ya kusegesa nzambi na nhosa ya kulihila gehile. Kila kinhu wanhu chonda wandavile kamba nhosa ing'ala chokuwa chako na wanago. ");
INSERT INTO kdc_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Diyeni vinhu avo kamba vinhu ving'alile ng'hani, wambigalo waiyeka awo olondigwa kuvija vinhu avo, vinhu avo ving'ala kumwenu. ");
INSERT INTO kdc_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Vivija vinhu viyagwe vose vonda wanilavile Waizilaeli kamba nhosa ya kwinuligwa uchanha, vinhu avo vokuwa venu. Nokugwaa gweye na wanago na wandele zako kamba fungu jenu siku zose. Munhu yoyose mulukolo lwako hafitile kodaha kuja vinhu avo. ");
INSERT INTO kdc_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nokugwaa vinhu vose vinogile kulawa mna ivinhu va ichanduso kusengigwa viondavila Waizilaeli. Mavuta ganogile, divai na ndiya. ");
INSERT INTO kdc_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Matunda gose gaichanduso ga mmigunda yao gonda wanilavile gokuwa genu. Munhu yoyose mulukolo lwako hafitile kodaha kuja. ");
INSERT INTO kdc_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kila kinhu cha Waizilaeli kilavigwe kamba nhosa kumwangu niye Mndewa Imulungu chokuwa chenu. ");
INSERT INTO kdc_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Kila mwana wa chaudele wa Waizilaeli yolavigwa kumwangu, yawe mwana chaudele wa munhu hebu wa mnyama kokuwa wenu. Lakini molondigwa muwagombole wana wose wa chaudele wa wanhu, vivija molondigwa muwagombole wana wose wafitile wa chaudele wa wanyama. ");
INSERT INTO kdc_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Awo wose molondigwa muwagombole vonda wavikize mwezi umoja na walaviligwe vihande vitano va shaba, kamba viwopima hanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Lakini wana chaudele wa ng'ombe hebu ng'hondolo hebu mbuzi, sikuwagomboligwe kwavija hewo wang'ala. Damu yao uimizile muupango wa nhosa na mavuta gao mugasome moto gawe nhosa ya kusoma moto ilava mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama yao yokuwa yenu, kamba ikidali kinuligwa uchanha na kamba kihili cha mgulu wa kudila. ");
INSERT INTO kdc_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Vinhu vose viondavila Waizilaeli nokugwaa gweye na wanago na wandele zako, ajo dokuwa fungu jenu siku zose. Dino dokuwa lagano da siku zose mgameso gangu mbuli ya gweye na ulelo wako.” ");
INSERT INTO kdc_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mndewa Imulungu kamulongela Haluni, “Gweye kokuwa kuduhu uhazi mwiisi ayo, vivija kokuwa kuduhu fungu jojose mna iwanhu, fungu jako na uhazi wako mna iwanhu wa Izilaeli dokuwa niye.” ");
INSERT INTO kdc_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Mbuli ya Walawi, hewo niwagwaa mafungu ga longo gose goondavila Waizilaeli kamba uhazi wao. Dino dijo fungu jao kwa sang'hano iwotenda kuna dihema jangu da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kulawa sambi, wanhu wayagwe wa Izilaeli sikuwadikwesele behi dihema da mting'hano ili sikuwatende nzambi na kuigalila ifa yao. ");
INSERT INTO kdc_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lakini Walawi waiyeka awo onda wasang'hane kuna dihema da mting'hano na kudilola goya. Lagizo dino dokuwa da siku zose ulelo wenu wose. Walawi okuwa waduhu uhazi mna iwanhu wa Izilaeli, ");
INSERT INTO kdc_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","kwavija niwagwelela gamafungu ga longo goondavila Waizilaeli kamba uhazi wao. Lekaavo nilonga hewo okuwa waduhu uhazi mna iwanhu wa Izilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Vivija walongele Walawi malagizo gano, ‘Vonda mubokele gamafungu ga longo ago ganiwagwelele mweye kamba uhazi wenu mna iwanhu wa Izilaeli, vivija mundavile niye Mndewa Imulungu fungu da longo da vinhu avo. ");
INSERT INTO kdc_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Sadaka ayo yotogoligwa kamba gaja gaichanduso kusengigwa hebu kamba zabibu zilavigwe. ");
INSERT INTO kdc_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Avo vivo vonda mundavile niye Mndewa Imulungu sadaka za fungu da longo zonda mubokele kulawa kwa Waizilaeli. Sadaka ayo yonda mundavile niye Mndewa Imulungu kamba fungu jenu da longo, mumgwelele Haluni, imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kulawa mna zinhosa azo zose zonda mubokele, mundavile niye Mndewa Imulungu hanhu hanogile ha zinhosa.’ ");
INSERT INTO kdc_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Avo ukawalongele, ‘Mwahanilavila hanhu hanogile ha zinhosa, hanhu hasigale hokuwa henu, kamba viili kwa mwene mgunda viyosola zabibu zisigale na ndiya isigale yahamambukiza kulava nhosa zake. ");
INSERT INTO kdc_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Avo mweye na ulelo wenu modaha kuvija vinhu avo hanhu hohose, kwavija awo uhazi wenu mbuli ya sang'hano yenu kuna dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mokuwa mduhu nzambi mwahaja vinhu avo, kamba munilavila niye Mndewa Imulungu hanhu hanogile ha zinhosa, na mweye hamvifitiza ivinhu ving'ala va Waizilaeli na hamufa bule.’ ” ");
INSERT INTO kdc_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Abaho Mndewa Imulungu kagendelela kuwalongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Gano gago malagizo gonilava, niye Mndewa Imulungu. Walongeleni Waizilaeli wawagalile ng'ombe mdung'hu mtwanzi yelibule kilema chochose na yawe yang'hali hanatenda sang'hano ya kulima. ");
INSERT INTO kdc_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mweye mumgwelele ng'ombe ayo Eleazali imulava nhosa. Ng'ombe ayo yalavigwe kunze ya ing'hambi na yachinjigwe kuulongozi wa ayo imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","“Abaho Eleazali imulava nhosa yasole damu kidogo na yaimize kwa kidole chake miyanza saba, kulozela umwambu wa kuulongozi wa dihema da mting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Ng'ombe ayo wose hamoja na ing'hwembe na inyama na idamu na ivinhu vose va mgati, visomigwe moto kuulongozi wa imulava nhosa. ");
INSERT INTO kdc_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Abaho imulava nhosa yasole lubiki lwa mwelezi na bunho da hisopo na sufi ndung'hu, yavigele vose muumoto awo ukwaka. ");
INSERT INTO kdc_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Yahamambukiza, ayo imulava nhosa yavifuwe viwalo vake na yakoge mazi lukuli lose, abaho kodaha kubwela mna ing'hambi, na kokala yafitile mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Vivija imunhu ayo yonda yamsome moto ayo ing'ombe yavifuwe viwalo vake kwa mazi na yakoge lukuli lose, vivija na heyo kokala yafitile mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Munhu yong'ala yazole ayo imitozi ya ing'ombe na yaigale hanhu hanogile kunze ya ing'hambi. Mitozi ayo ikigwe goya na isang'hanilwe na iwanhu wose wa Izilaeli kutendela mazi ga kusegesela gehile, ili kusegesa nzambi. ");
INSERT INTO kdc_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Imunhu yonda yaizole imitozi ya ayo ing'ombe kolondigwa yafuwe viwalo vake lakini kokala yafitile mbaka ichungulo. Lagizo dino da siku zose, kwa Waizilaeli wose na iwanhu baki okala hamoja nao. ");
INSERT INTO kdc_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Munhu yoyose yahakwasa maiti kokala yafitile kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Siku da kadatu na siku da isaba munhu ayo yaisunhe kwa gaja gamazi ga kusegesa gehile na heyo kokuwa kang'ala. Lakini kamba haisunha kudisiku da kadatu na da isaba munhu ayo kosigala vivo yafitile. ");
INSERT INTO kdc_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Munhu yoyose yahakwasa maiti na haisunha kodifitiza hema da Mndewa Imulungu na yabaguligwe na iwanhu wa Izilaeli. Munhu ayo kosigala yafitile kwavija hamiziligwe gaja gamazi ga kusegesa gehile. ");
INSERT INTO kdc_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Gano gago malagizo kamba munhu yahafila mdihema. Munhu yoyose yokwingila mdihema ajo hebu munhu yeli mumo mng'anda ya dihema kokuwa kafita kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Kiya chochose hakigubikigwe chokuwa kifita. ");
INSERT INTO kdc_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Munhu yoyose yonda yakwase maiti ga munhu yakomigwe hebu munhu yafile mwenyego mng'anda hebu munhu yahakwasa mizege ya munhu yafile hebu munhu yahakwasa panga, munhu ayo kokuwa kafita kwa siku saba. ");
INSERT INTO kdc_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Mbuli ya wanhu awo wafitile isoligwe ayo imitozi ya ing'ombe mdung'hu ya kusegesa gehile na ihanganyigwe na mazi ga lwanda mna inongo. ");
INSERT INTO kdc_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Abaho munhu yong'ala yasole bunho da hisopo yadivabike mgamazi gago abaho yadimizile dihema na viya vose vili mng'anda na iwanhu weli mumo mng'anda. Vivija yammizile gago gamazi, munhu ayo yakwasile imizege ya munhu yafile hebu ayo yakwasile imaiti ya munhu yakomigwe hebu imunhu yakwasile maiti ya munhu yafile mwenyego hebu imunhu yakwasile panga. ");
INSERT INTO kdc_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Kudisiku da kadatu na da isaba munhu ayo yong'ala yammizile imunhu yafitile mazi gago, avo kudisiku da saba komtenda yang'ale ayo imunhu yafitile, na heyo yavifuwe viwalo vake na yakoge na ichungulo kokuwa kang'ala. ");
INSERT INTO kdc_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Lakini kamba munhu kafita na haisunhile bule, munhu ayo kobaguligwa na iwanhu wose kwavija kodifitiza hema da Mndewa Imulungu. Kwavija hamiziligwe gago gamazi ga kusegesa gehile, avo munhu ayo kokuwa kafita. ");
INSERT INTO kdc_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Wanhu wadigoge lagizo dino siku zose. Vivija imunhu yomiza gago gamazi ga kusegesa gehile, yafuwe viwalo vake, na munhu yoyose yogakwasa gago gamazi kokuwa kafita mbaka ichungulo. ");
INSERT INTO kdc_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kinhu chochose chonda yakikwase munhu ayo yafitile, kinhu acho chokuwa kifita, na munhu yonda yakikwase kinhu acho kokuwa kafita mbaka ichungulo.” ");
INSERT INTO kdc_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Wanhu wose Waizilaeli, wavika kuluwala lwa Sini, mna umwezi wa ichanduso weka ng'hambi yao ako Kadeshi. Viwakalile kuko Miliamu kafa na kazikigwa. ");
INSERT INTO kdc_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hanhu aho hawekile ing'hambi kukala kuduhu mazi ga kung'wa. Avo wanhu wose waiting'hana kuulongozi wa Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Waiyalala walonga, “Vinoga twahafile hamoja na ndugu zetu kuulongozi wa dihema da Mndewa Imulungu! ");
INSERT INTO kdc_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Habali mutugala siye iwanhu wa Mndewa Imulungu kuno kuluwala? Vino mutugala ili tufe hamoja na fugo zetu? ");
INSERT INTO kdc_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Vino habali mutulava Misili na mutugala hanhu hano hehile? Hano haduhu ndiya hebu tini hebu zabibu hebu makomamanga. Vivija hata mazi ga kung'wa hano haduhu!” ");
INSERT INTO kdc_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Avo, Musa na Haluni wasegela aho hana umting'hano, wachola kwima hana ulwivi lwa dihema da mting'hano, wagwa kingubanguba. Avo ukulu wa Mndewa Imulungu uwalawila, ");
INSERT INTO kdc_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","na Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Sola fimbo yako, abaho gweye na Haluni, muwating'hanize iwanhu wose wa Izilaeli. Abaho mgameso gao udilongele dibwe dili kuulongozi wao dilave mazi gake. Avo utende dibwe dilave mazi ili iwanhu wose wa Izilaeli na fugo yao wang'we mazi gago.” ");
INSERT INTO kdc_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa kachola kuisola ayo ifimbo kuulongozi wa Mndewa Imulungu kamba viyalagizwe. ");
INSERT INTO kdc_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Abaho Musa na Haluni wawating'haniza iwanhu wose kuulongozi wa idibwe na Musa kawalongela, “Tegelezeni mweye iwanhu wehile, vino tuwalavile mazi kulawa mdibwe dino?” ");
INSERT INTO kdc_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Abaho Musa kenula fimbo yake, kaditowa ajo idibwe miyanza mibili. Ilawa mbwibwi ya mazi aho, wanhu wang'wa hamoja na fugo yao. ");
INSERT INTO kdc_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Lakini Mndewa Imulungu kamulongela Musa na Haluni, “Kwavija mweye hamnitogole hebu kunigwaa ukulu mgameso ga Waizilaeli, avo kwa mbuli ayo honda muwengize iwanhu wao mna iisi inongile nowagwelela.” ");
INSERT INTO kdc_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Mazi gago gakemigwa Meliba kwavija hanhu aho Waizilaeli wamuyalalila Mndewa Imulungu na heyo kailagusa kamba kang'ala hagati yao. ");
INSERT INTO kdc_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Abaho Musa kawatuma wanhu kulawa Kadeshi wachole kwa mndewa wa Edomu wamulongele, “Ndugu yako Izilaeli kolonga vino, gweye kugajuwa magayo gose tugapatile, ");
INSERT INTO kdc_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","kujuwa iwahenga zetu viwacholile ako Misili, na wakala ng'hani ako na wadununzigwa, vivija na siye watudununza. ");
INSERT INTO kdc_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Tumulilila Mndewa Imulungu na heyo kahulika kulila kwetu, katugalila imsenga wake yatusegese ako Misili. Avo, sambi twa hano Kadeshi, kudibuga diibakane na isi yako. ");
INSERT INTO kdc_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Chonde tokupula ututogolele tubite mwiisi yako. Hatubojoga gaja gahandigwe mmigunda yenu na hatubojoga zabibu. Vivija hatung'wa mazi ga ivisima venu. Tokweleleza inzila ing'hulu ya mndewa na tobita bila kuhinduka ukudila hebu ukumoso mbaka vonda tulawe mwiisi yako.” ");
INSERT INTO kdc_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Lakini mndewa wa Edomu kedika, “Aka, hamubita mwiisi yangu, kamba mwahabita nowavamila na nowatowa kwa misime.” ");
INSERT INTO kdc_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Waizilaeli wamulongela, “Siye tokweleleza inzila ing'hulu, kamba siye na fugo yetu twahang'wa mazi genu, towaliha. Siye tolonda kubita, chonde tutogolele.” ");
INSERT INTO kdc_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Lakini mndewa wa Edomu kasusumiza, “Hatulonda mubite.” Bahaja Waedomu weli na nguvu walawilila waitowe na hewo. ");
INSERT INTO kdc_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Avo Waedomu wawalemela Waizilaeli kubita mna iisi yao. Avo, Waizilaeli wahindula wabita nzila iyagwe. ");
INSERT INTO kdc_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Abaho Waizilaeli wose wagendelela na mwanza kulawa ako Kadeshi na wavika kulugongo lwa Holi. ");
INSERT INTO kdc_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ako kulugongo lwa Holi, kuna imbaka ya isi ya Edomu, Mndewa Imulungu kamulongela Musa na Haluni, ");
INSERT INTO kdc_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Gweye Haluni kofa, na honda wingile bule mwiisi inilongile nowagwaa Waizilaeli kwavija gweye na Musa munilema niye kuja Meliba. ");
INSERT INTO kdc_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Gweye Musa msole Haluni na mwanage Eleazali, uwagale kuno uchanha kulugongo lwa Holi. ");
INSERT INTO kdc_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Abaho msaule Haluni viwalo vake va ulava nhosa na umvaze imwana Eleazali. Haluni kofila kuko kulugongo.” ");
INSERT INTO kdc_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa katenda kamba Mndewa Imulungu viyamulagize. Wose wadatu wakwela kulugongo lwa Holi kuulongozi wa iwanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Abaho Musa kamsaula Haluni viwalo vake va ulava nhosa, kamvaza imwana Eleazali. Na Haluni kafa kuko kulugongo. Abaho Musa na Eleazali wahumuluka hasi ya ulugongo. ");
INSERT INTO kdc_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Mting'hano wose viupatile usenga awo kamba Haluni kafa wamuwasila tanga kwa siku malongo madatu. ");
INSERT INTO kdc_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mndewa imoja Mkanaani wa Aladi, yakalile ako Negebu viyajuwile kamba Waizilaeli wakala okwiza kubitila nzila ya Atalimu, kachola kuwavamila na wanhu wayagwe kawagoga. ");
INSERT INTO kdc_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Avo Waizilaeli waiduwila kwa Mndewa Imulungu walonga, “Kamba wahawagela wanhu wano mmakono getu, avo togananga mabuga gao.” ");
INSERT INTO kdc_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mndewa Imulungu kawatendela kamba viwapulile, kawatenda Wakanaani wahumwe. Waizilaeli wawakoma Wakanaani wose, hamoja na mabuga gao. Avo hanhu aho hakemigwa Holima. ");
INSERT INTO kdc_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Waizilaeli wagendelela na mwanza kulawa kulugongo lwa Holi wabitila nzila ilongoza kuna ibahali ya Shamu ili waizunguluke isi ya Edomu. Lakini mnzila wanhu wadonha kugendelela na umwanza. ");
INSERT INTO kdc_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Avo wasonga kumuyalalila Mndewa Imulungu na Musa, walonga, “Habali mutulava Misili ili tufile hano kuluwala? Hano haduhu ndiya iyagwe wala mazi ga kung'wa, na tudonha kuja ndiya ino ihile.” ");
INSERT INTO kdc_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Baho Mndewa Imulungu kagala mizoka ikalile na sumu na iwaluma iwanhu, na Waizilaeli wengi wafa. ");
INSERT INTO kdc_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Avo, wanhu wamcholela Musa, wamulongela, “Tutenda nzambi tumuyalalila Mndewa Imulungu na gweye vivija. Mpule Mndewa Imulungu yatusegesele imizoka ino.” Avo Musa kawapulila iwanhu kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Avo, Mndewa Imulungu kamulongela Musa, “Tenda zoka da shaba, udinanike mdibiki. Munhu yoyose yonda yalumigwe na zoka, yahadilola ajo dizoka da shaba kohona.” ");
INSERT INTO kdc_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Avo Musa katenda zoka da shaba kadinanika mdibiki. Kila munhu yalumigwe na zoka viyadilolile ajo dizoka da shaba kahona. ");
INSERT INTO kdc_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Avo Waizilaeli wagendelela na mwanza wao na weka ng'hambi yao ako Oboti. ");
INSERT INTO kdc_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kulawa ako wachola mbaka Iye Abalimu, kuluwala mwambu wa kudilawila zuwa, ako Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kulawa ako wachola na weka ng'hambi yao kubonde da Zeledi. ");
INSERT INTO kdc_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kulawa ako wachola na weka ng'hambi yao kuluwala mwambu wa kasikazini ya lwanda lwa Alinoni, awo uluwala lugendelela mbaka mwiisi ya Waamoli. Lwanda lwa Alinoni awo ukalile imbaka ya Wamoabu na Waamoli. ");
INSERT INTO kdc_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Lekaavo yandikigwa mna ikitabu cha ng'hondo za Mndewa Imulungu, “Buga da Wahebu mwiisi ya Sufa, na mabonde ga Alinoni, ");
INSERT INTO kdc_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na mtelemuko wa gamabonde uvikile mbaka buga da Ali, na kuchola kuna imbaka ya isi ya Moabu!” ");
INSERT INTO kdc_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kulawa kuko Waizilaeli wachola mbaka Beeli, ako kuna ikisima Mndewa Imulungu kiyamulongele Musa, yawating'hanize iwanhu na heyo kowagwaa mazi. ");
INSERT INTO kdc_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Aho Waizilaeli wemba lwila luno, “Kisima lava mazi! Kimbileni! ");
INSERT INTO kdc_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kisima kihimbigwe na iwakulu kisima kihimbigwe na wanhu weli na ukulu, wakihimba kwa fimbo zao.” Kulawa kuluwala wachola mbaka Matana, ");
INSERT INTO kdc_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kulawa Matana mbaka Nahalieli, kulawa Nahalieli mbaka Bamoti, ");
INSERT INTO kdc_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kulawa Bamoti mbaka kubonde dili Moabu kuna inhembeti ya lugongo lwa Pisiga, luilola na uluwala. ");
INSERT INTO kdc_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Waizilaeli wamgalila mndewa Sihoni wa Waamoli usenga uno, ");
INSERT INTO kdc_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Ututogolele tubite mwiisi yako, honda tubite mna imigunda yako ya ndiya, na migunda ya mizabibu na hatung'wa mazi ga visima venu, tobita mna inzila ya mndewa mbaka vonda tubite mwiisi yako.” ");
INSERT INTO kdc_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Lakini Sihoni hawatogolele Waizilaeli wabite mwiisi yake. Kawating'haniza wakalizi wake, kachola kuluwala ako Yahasa kawavamila Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Lakini Waizilaeli wamkoma, waisola isi ayo kulawa hana ulwanda lwa Alinoni mbaka lwanda lwa Yaboki, aho hana imbaka ya isi ya Waamoni, aho hokalizigwa ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Waizilaeli wagasola mabuga ago gose ga Waamoli na vivija wadisola dibuga dikulu da Heshiboni na ivijiji vake vose. ");
INSERT INTO kdc_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboni dikala buga kulu da mndewa Sihoni wa Waamoli, ayo aho umwaka kaitowa na mndewa wa Moabu yakalile yalongole na kaisola isi ayo yose mbaka lwanda lwa Alinoni. ");
INSERT INTO kdc_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Lekaavo iwanhu okwimba lwila luno, “Izoni Heshiboni na mudizenge kabili. Buga da mndewa Sihoni dizengwe vinogile kabili. ");
INSERT INTO kdc_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Kwavija moto ulawa Heshiboni. Milambi ya moto ilawa kudibuga da Sihoni, ugasakaza mabuga ga Ali ako Moabu, uvinanga vigongo va lwanda lwa Alinoni. ");
INSERT INTO kdc_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mugaya mweye wanhu Moabu! Mubanangigwa mweye wanhu wa Kemoshi! Muwatenda wanenu wa kimbigalo watange tange kwa bwembwe! Wandele zenu wasoligwa kamba watumwa wa mndewa Sihoni wa Waamoli. ");
INSERT INTO kdc_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Lakini sambi ulelo wao ubanangigwa, kulawa Heshiboni mbaka Diboni, na kulawa Nashimu mbaka Nofa, behi ya Medeba.” ");
INSERT INTO kdc_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Avo Waizilaeli wakala mwiisi ya Waamoli. ");
INSERT INTO kdc_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Abaho Musa kawatuma wanhu wachole wakadisungulile buga da Yazeli. Avo wadivamila na kudisola buga ajo, wawawinga Waamoli wakalile mumo. ");
INSERT INTO kdc_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Abaho Waizilaeli wahindula na wagoga inzila ichola Bashani. Mndewa Ogu wa ako Bashani kachola na iwakalizi wake ili wawavamile ako kudibuga da Edilei. ");
INSERT INTO kdc_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Lakini Mndewa Imulungu kamulongela Musa, “Sikuumdumbe kwavija nimgela mmakono gako, heyo hamoja na iwakalizi wake na isi yake yose. Komtendela kamba viumtendele Sihoni, imndewa wa Waamoli, ayo yakalile ako Heshiboni.” ");
INSERT INTO kdc_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Avo Waizilaeli wamkoma Ogu hamoja na wanage na iwakalizi wake wose, hawamulekile hata munhu imoja, abaho waisola isi yake. ");
INSERT INTO kdc_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Waizilaeli wagendelela na mwanza na weka ng'hambi yao kudibawe da Moabu, mwambu wa kudilawilila zuwa wa lwanda lwa Yolidani, uilola na buga da Yeliko dikalile umwambu wa ulwanda. ");
INSERT INTO kdc_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Mndewa Balaki mwanage Sipoli, kagajuwa gose Waizilaeli gawawatendele Waamoli. ");
INSERT INTO kdc_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Avo heyo hamoja na Wamoabu wawadumba ng'hani Waizilaeli, kwavija Waizilaeli wakala wengi ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Avo Wamoabu wawalongela vilongozi wa Midiani, “Lunhu luno sambi baha lonanga kila kinhu kituzunguluke kamba ng'ombe mbigalo viyoja mijani mmigunda.” Avo Balaki mwanage Sipoli ayo yakalile mndewa wa Moabu kipindi acho, ");
INSERT INTO kdc_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","kamtumila usenga Balaamu mwanage Beoli ako Petoli, behi na lwanda lwa Fulate, mwiisi ya Amawi. Kamulongela vino, “Hana wanhu walawile mwiisi ya Misili, wanhu awo wenela kila hanhu mwiisi na vivija olonda kuniboka isi yangu. ");
INSERT INTO kdc_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Avo wize uniduwilizile wanhu wano kwavija wana nguvu kubanza niye. Sengine nodaha kuwahuma na kuwawinga sikuwengile mwiisi yangu, kwavija nokujuwa, gweye wahamtambikila munhu, munhu ayo kotambikilwa na wahamduwila munhu, munhu ayo koduwiligwa.” ");
INSERT INTO kdc_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Avo vilongozi wa Moabu na Midiani wasola sente zilondigwa mbuli ya kuduwiliza, wasegela wachola kwa Balaamu. Viwavikile wamgwaa Balaamu usenga wa Balaki. ");
INSERT INTO kdc_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu kawalongela, “Kilo cha lelo muwase baha, na niye nowalongela gaja gonda yanongele Mndewa Imulungu.” Avo awo iwavele wa Moabu wakala na Balaamu. ");
INSERT INTO kdc_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Abaho Imulungu kamwidika Balaamu, kamuuza, “Awano kina nani iwokala na gweye?” ");
INSERT INTO kdc_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu kamwidika Mndewa Imulungu, “Balaki mwanage Sipoli, mndewa wa Moabu, kanigalila usenga kamba, ");
INSERT INTO kdc_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","hana wanhu walawa Misili, na hewo wenela kila hanhu mwiisi. Kanipula nichole nikawaduwile wanhu awo ili yadahe kuwatowa na kuwawinga.” ");
INSERT INTO kdc_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mndewa Imulungu kamulongela Balaamu, “Sikuuchole hamoja na iwanhu wano na sikuuwaduwile wanhu awo kwavija wanhu awo watambikiligwa.” ");
INSERT INTO kdc_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Avo, imitondo Balaamu kalamuka, kawacholela awo ivilongozi wa Balaki kawalongela, “Bweleni mwiisi yenu, kwavija Mndewa Imulungu kangomesa kuchola na mweye.” ");
INSERT INTO kdc_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Avo awo ivilongozi wa Moabu walawanya, wabwela kwa Balaki wamulongela, “Balaamu kalema kwiza na siye.” ");
INSERT INTO kdc_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Abaho, Balaki kawatuma vilongozi wayagwe, wakala wengi ng'hani na wakala na ukulu kubanza awo walongole. ");
INSERT INTO kdc_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Hewo wavika kwa Balaamu wamulongela, “Balaki mwanage Sipoli kolonga vino, ‘Sikuutogole kinhu chochose kikukimile uleke kwiza kumwangu! ");
INSERT INTO kdc_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Niye nokugwaa vinhu vingi, na nokutendela kinhu chochose chonda unipule. Wize uwaduwile wanhu wano.’” ");
INSERT INTO kdc_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Lakini Balaamu kawedika awo iwanhu wa Balaki, “Hata kamba Balaki yahanigwelela ng'anda yake kuno imema sente na zahabu, niye sidaha kubena lagizo da Mndewa Imulungu, Imulungu wangu, kwa mbuli ndodo hebu ng'hulu. ");
INSERT INTO kdc_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Lakini chonde muwase baha kilo cha lelo kamba waja waenu walongole, ili nijuwe gaja gonda yanongele kabili Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Avo, kilo acho Mndewa Imulungu kamwidika Balaamu kamulongela, “Kamba awo weza kukukema, chola nao, lakini utende gaja gaiyeka gonda nikulongele.” ");
INSERT INTO kdc_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu kalamuka imitondo kamtanda kihongwe wake kachola na awo ivilongozi. ");
INSERT INTO kdc_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mndewa Imulungu kamgevuzikila Balaamu kwavija kachola na iwanhu awo, avo msenga wa Mndewa Imulungu kamkimila mnzila kipindi acho Balaamu kakala yakwelile kihongwe wake na iwasang'hanaji wake wakala na heyo. ");
INSERT INTO kdc_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Avo, ikihongwe viyamone msenga ayo wa Mndewa Imulungu kema mnzila kuno kagoga sime, kaleka inzila kabita kumgwazo. Balaamu kamtowa ayo ikihongwe kambweza mnzila. ");
INSERT INTO kdc_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Abaho msenga ayo wa Mndewa Imulungu kalongola, kema hanhu hana inzila sisili, hagati ya migunda ya mizabibu na kukala na senyenge ya mabwe ukudila na ukumoso. ");
INSERT INTO kdc_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kihongwe viyamone msenga ayo wa Mndewa Imulungu, kaibwanha kuna uluwa na mgulu wa Balaamu ukwatuligwa aho hauluwa. Avo, Balaamu kamtowa kabili ayo ikihongwe. ");
INSERT INTO kdc_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Abaho msenga ayo wa Mndewa Imulungu kalongola kabili, kema hanhu hasisili, aho hudaha kubita ukudila hebu ukumoso. ");
INSERT INTO kdc_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ayo ikihongwe viyamone msenga ayo wa Mndewa Imulungu kema aho, kawasa hasi. Balaamu kagevuzika, kamtowa kwa fimbo yake. ");
INSERT INTO kdc_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Abaho Mndewa Imulungu kamtenda ayo ikihongwe yalonge, kamulongela Balaamu, “Nikutendela choni mbaka kunitowa miyanza midatu?” ");
INSERT INTO kdc_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu kamulongela ayo ikihongwe, “Gweye kunitenda nambozi! Maza ng'halile na sime nahakukomile sambi baha.” ");
INSERT INTO kdc_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ikihongwe kamulongela Balaamu, “Niye ayo ikihongwe wako iija, nikupapaga siku zose mbaka lelo, lini nikutendela kamba vino?” Balaamu kedika, “Aka.” ");
INSERT INTO kdc_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Baho Mndewa Imulungu kagagubula meso ga Balaamu na heyo kamona msenga wa Mndewa Imulungu kema mnzila, kuno kagoga sime. Balaamu kaibwanha hasi kingubanguba. ");
INSERT INTO kdc_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Msenga ayo wa Mndewa Imulungu, kamulongela Balaamu, “Habali kumtowa kihongwe wako miyanza midatu? Niye niza kukukimila, kwavija hulondigwa uchole kuko. ");
INSERT INTO kdc_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kihongwe wako kanyona, na kainega miyanza yose midatu. Maza hainegile nahakukomile gweye, na ikihongwe ino nahamulekile mgima.” ");
INSERT INTO kdc_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu kamulongela msenga ayo wa Mndewa Imulungu, “Nitenda nzambi kwavija sijuwile kamba kwima mnzila kunikimila. Avo sambi kamba gweye hulonda nigendelele na mwanza uno, avo nobwela ukae.” ");
INSERT INTO kdc_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Msenga ayo wa Mndewa Imulungu kamulongela Balaamu, “Chola na iwanhu wano, lakini ulonge gaja gaiyeka gonda nikulongele.” Avo Balaamu kagendelela na umwanza hamoja na ivilongozi wa Balaki. ");
INSERT INTO kdc_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki viyahulike kamba Balaamu kamnzila kokwiza, kachola kumbokela kudibuga da Ali, buga dijo dikala mwiingema ya lwanda lwa Alinoni kuna imbaka ya Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki kamulongela Balaamu, “Habali hawizile kumwangu vinikukemile? Vino gweye kugelegeza sidaha bule kukugwaa vinhu vingi?” ");
INSERT INTO kdc_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu kamwidika Balaki, “Sambi niza kumwako! Vino niye nodaha kulonga mbuli yoyose inilonda? Mbuli yonda yanongele Imulungu ayo yonda nonge.” ");
INSERT INTO kdc_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Avo, Balaamu kachola hamoja na Balaki wavika kudibuga da Kiliati Husoti. ");
INSERT INTO kdc_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ako Balaki kalava nhosa ya ng'ombe na ng'hondolo, kawagwaa inyama iyagwe Balaamu na awo ivilongozi wakalile hamoja na heyo. ");
INSERT INTO kdc_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Imitondo Balaki kamsola Balaamu, kakwela na heyo mbaka Bamoti Baali, kuko Balaamu kadaha kuwona Waizilaeli wayagwe. ");
INSERT INTO kdc_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu kamulongela Balaki, “Nizengele mhango saba hano abaho unigalile ng'ombe mbigalo saba na ng'hondolo mbigalo saba.” ");
INSERT INTO kdc_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki katenda kamba Balaamu viyamulongele. Avo walava nhosa mna kila upango, ng'ombe mbigalo imoja na ng'hondolo mbigalo imoja. ");
INSERT INTO kdc_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Abaho Balaamu kamulongela Balaki, “Kala hano behi na inhosa yako ya kusoma moto, niye nokwela uchanha sengine Mndewa Imulungu kolonga na niye. Kinhu chochose chonda yandagusile nokwiza kukulongela.” Avo Balaamu kakwela yaiyeka kuna inhembeti ya ulugongo. ");
INSERT INTO kdc_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Imulungu kamulawila Balaamu, abaho Balaamu kamulongela, “Nitanda mhango saba na nilava nhosa uchanha ya kila upango ng'ombe mbigalo imoja na ng'hondolo mbigalo imoja.” ");
INSERT INTO kdc_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mndewa Imulungu kamgwaa usenga Balaamu na kamulongela, “Bwela kwa Balaki na mgwee usenga awo.” ");
INSERT INTO kdc_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Avo Balaamu kabwela na kamvika Balaki kema bahaja behi na nhosa yake, hamoja na vilongozi wose wa Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaamu kamgwaa Balaki uusenga kwa kulagula kalonga, “Balaki kanigala hano kulawa Alamu Ona, mndewa wa Moabu kanigala kulawa kuvigongo va mwambu wa kudilawilila zuwa. Kalonga, ‘Izo uniduwilizile wanhu wa Yakobo, ona, izo uwaduwile Waizilaeli!’ ");
INSERT INTO kdc_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Lakini, vino nomduwilaze munhu haduwiligwe na Imulungu? Vino nowasuwaze wanhu hawasuwigwe na Mndewa Imulungu? ");
INSERT INTO kdc_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kulawa kuna inhembeti ya imibwe nowona, Kulawa uchanha ya ivigongo nowasungulila. Lola wanhu wano okala waiyeka, Na watambikiligwa kubanza wanhu wa isi ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Nani yodaha kuwapeta wanhu wa Yakobo. Nani yodaha kugapeta mabumbila ga Izilaeli? Beta ifa yangu iwe kamba imoja wa awo iwanhu wa Imulungu, Beta niye nife kamba munhu yanogile mgameso ga Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Abaho Balaki kamulongela Balaamu, “Kunhenda choni? Nikugala hano uwaduwile wanhu onihila lakini gweye kuwatambikila.” ");
INSERT INTO kdc_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu kamwidika Balaki, “Niye nolondigwa kulonga mbuli zija ziyanigwelele Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Abaho Balaki kamulongela Balaamu, “Tuchole hanhu hayagwe aho kodaha kuwona lakini hudaha kuwona wose. Abaho uniduwilizile wanhu awo kulawa kuko.” ");
INSERT INTO kdc_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Avo Balaki kamgala Balaamu kumgunda wa Sofimu kuna inhembeti ya ulugongo lwa Pisiga. Kuko vivija kazenga mhango saba, na kalava nhosa uchanha ya kila upango, ng'ombe mbigalo imoja na ng'hondolo mbigalo imoja. ");
INSERT INTO kdc_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu kamulongela Balaki, “Kala hano behi na nhosa yako ya kusoma moto, niye nochola kuja umwambu kulonga na Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mndewa Imulungu kamulawilila Balaamu kamgwaa usenga yonda yalonge na kamulongela yabwele kwa Balaki. ");
INSERT INTO kdc_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Avo Balaamu kabwela, na kamvika Balaki kema behi na nhosa yake ya kusoma moto, hamoja na vilongozi wose wa Moabu. Balaki kamuuza Balaamu, “Mndewa Imulungu kakulongela choni?” ");
INSERT INTO kdc_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Avo, Balaamu kamgwaa Balaki uusenga kwa kulagula, “Izo Balaki utegeleze, Nhegeleze gweye mwanage Sipoli. ");
INSERT INTO kdc_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Imulungu siyo munhu yavize, Na heyo siyo munhu yagimbule magesa gake. Kotenda kinhu chochose chonda yalonge, Na kotenda gose kamba viyalongile kotenda. ");
INSERT INTO kdc_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Lola nigweleligwa malagizo ga kuwatambikila, na heyo kawatambikila avo niye sidaha kugimbula kinhu. ");
INSERT INTO kdc_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Mndewa Imulungu honile dihile kwa wana wa Yakobo, Vivija honile ndwagi kwa Waizilaeli. Mndewa Imulungu kahamoja na hewo, Na hewo omtogola kamba Mndewa wao. ");
INSERT INTO kdc_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Imulungu kawalava mwiisi ya Misili, na heyo kowagombela kwa nguvu zake kamba simba viyogombela wanage. ");
INSERT INTO kdc_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Kuduhu uhawi kwa wanhu wa Yakobo, Kuduhu munhu yodaha kuwaloga Waizilaeli. Mbuli ya Izilaeli wanhu olonga, ‘Loleni unzonza uyatendile Imulungu!’ ");
INSERT INTO kdc_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Lola Waizilaeli wenuka kamba simba mtwanzi, okwima wima kamba simba mbigalo. Oigala na simba yoleka kuwasa mbaka yamambukize kuja kija kiyasakile, na kong'wa damu ya vija viyakomile.” ");
INSERT INTO kdc_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Abaho Balaki kamulongela Balaamu, “Kamba huwaduwila vivija sikuuwatambikile!” ");
INSERT INTO kdc_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaamu kamwidika Balaki, “Vino sikulongele kamba chonda yalonge Mndewa Imulungu acho kinilondigwa kutenda?” ");
INSERT INTO kdc_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki kamulongela Balaamu, “Izo nokugala hanhu hayagwe, sengine Imulungu kokutogolela uniduwilizile wanhu awo kulawa kuko.” ");
INSERT INTO kdc_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Avo Balaki kamsola Balaamu mbaka kuna inhembeti ya ulugongo lwa Peoli, aho munhu yahema koluona uluwala. ");
INSERT INTO kdc_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu kamulongela Balaki, “Unizengele mhango saba hano abaho unitandile ng'ombe mbigalo saba na ng'hondolo mbigalo saba.” ");
INSERT INTO kdc_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Avo Balaki katenda kamba Balaamu viyamulongele, abaho kalava nhosa uchanha ya kila upango ng'ombe mbigalo imoja na ng'hondolo mbigalo imoja. ");
INSERT INTO kdc_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Avo, Balaamu kajuwa kamba Mndewa Imulungu kolonda kuwatambikila Waizilaeli, avo hacholile kabili kulagula ila kakala kolola kuluwala. ");
INSERT INTO kdc_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Kawona Waizilaeli weka ng'hambi, kila kabila dikala hanhu hake. Abaho Loho ya Imulungu imwizila, ");
INSERT INTO kdc_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","na heyo kalonga usenga uno wa ulaguzi, “Usenga wangu niye Balaamu mwanage Beoli, Usenga wa munhu yafumbuligwe gameso. ");
INSERT INTO kdc_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Usenga wa munhu yahulike mbuli za Imulungu. Munhu yalagusiligwe kinhu na Mndewa Imulungu yeli na Udahi wose. Munhu yagwile kingubanguba na kugona gose. ");
INSERT INTO kdc_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Vibanda venu vinoga mweye iwanhu wa Yakobo, Ona, ng'hambi zenu zinoga mweye wanhu wa Izilaeli! ");
INSERT INTO kdc_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Kamba mabonde golava mazi. Kamba kihati kili behi na lwanda, Kamba mikuyu ihandigwe na Mndewa Imulungu. Kamba mikenge ili behi na mazi. ");
INSERT INTO kdc_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Okuwa na mazi mengi, Mbeyu zao zofonza mazi mengi. Mndewa wao kokuwa mkulu kubanza Agagi. Undewa wao okwenela kila hanhu. ");
INSERT INTO kdc_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Imulungu kawalava mwiisi ya Misili. Heyo kowagombela kwa nguvu zake kamba simba viyowagombela wanage. Kowakoboza wanhu wa isi owehila. Koibena mizege yao. Kowahoma kwa migoha yake. ");
INSERT INTO kdc_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Kowasa kamba simba. Nani yogeza kumulamusa? Yatambikiligwe munhu yoyose yowatambikila mweye Waizilaeli. Yaduwiligwe yoyose yowaduwila mweye.” ");
INSERT INTO kdc_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki kamgevuzikila Balaamu, katowa makono gake kamulongela, “Nikukema uwaduwile iwanhu onihila, lakini miyanza yose midatu kuwatambikila! ");
INSERT INTO kdc_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Avo, sambi baha ulawanye, nilonda kukugwaa nhunza, lakini lola Mndewa Imulungu kakugomesa sikuupate nhunza azo.” ");
INSERT INTO kdc_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu kamwidika Balaki, “Vino siwalongele iwasenga wautumile kumwangu, ");
INSERT INTO kdc_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","hata kamba Balaki yahanigwelela ng'anda yake imemile sente na zahabu, niye sidaha kulema lagizo da Mndewa Imulungu, kwa kutenda kamba vinilonda niye mbuli yoyose inogile hebu ihile. Nilonga chochose chonda yalonge Mndewa Imulungu acho chonda nilonge. ");
INSERT INTO kdc_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Avo nobwela kwa wanhu zangu, lakini ning'hali sinasegela beta nikulongele mbuli zonda watende wanhu awo kwa wanhu wako ako kumwande.” ");
INSERT INTO kdc_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Avo Balaamu kalonga usenga uno wa ulaguzi, “Usenga wangu niye Balaamu mwanage Beoli, usenga wa munhu yafumbuligwe gameso, ");
INSERT INTO kdc_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","usenga wa munhu yahulike mbuli za Imulungu. Munhu yagajuwile gaja ga Imulungu yeli Uchanha Ng'hani. Munhu yalagusiligwe vinhu na Mndewa Imulungu yeli na Udahi wose. Munhu yagwile kingubanguba na meso gake gona gose. ");
INSERT INTO kdc_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nomona ayo yonda yeze, lakini aho kumwande nomulola. Nomona lakini heli habehi. Nhondo yolawa muulelo wa Yakobo. Kolawila mndewa mna iwanhu wa Izilaeli. Kwa fimbo yake kowazabula vilongozi wa Wamoabu. Kowakoma wanhu wose wa ulelo wa Seti. ");
INSERT INTO kdc_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Kowahuma iwanhu omwihila kulawa Edomu na Seili, lakini Waizilaeli ogendelela kuhuma. ");
INSERT INTO kdc_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Munhu imoja kulawa muulelo wa Yakobo kotawala. Na kowakoma iwanhu onda wasigale kudibuga.” ");
INSERT INTO kdc_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Abaho Balaamu kawalola Waamaleki, kalonga usenga uno wa ulaguzi, “Waamaleki ni wanhu wa isi ili na nguvu kubanza zose. Lakini ako kumwande yopotela yose.” ");
INSERT INTO kdc_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Abaho Balaamu kawalola Wakeni, kalonga usenga uno wa ulaguzi, “Kae zenu mweye Wakeni zihola, kamba mvulu izengigwe uchanha ya dibwe kulu. ");
INSERT INTO kdc_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Lakini mweye Wakeni mokomigwa kipindi Ashulu vonda yawagoge.” ");
INSERT INTO kdc_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Vivija Balaamu kalonga usenga uno wa ulaguzi, “Vino nani yonda yahone, Imulungu vonda yatende mbuli azo? ");
INSERT INTO kdc_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ngalawa zokwiza kulawa Kitimu, owavamila Ashulu na Ebeli, na hewo vivija obanangigwa.” ");
INSERT INTO kdc_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Avo Balaamu kenuka, kasegela kabwela ukae kumwake, vivija Balaki nayo kasegela. ");
INSERT INTO kdc_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Avo Waizilaeli viwakalile okala ako Shitimu, iwambigalo wasonga kuwasa na iwatwanzi wa Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Watwanzi awo wawagoneka Waizilaeli mna zinhambiko zao za kuilavila nhosa imilungu yao. Waizilaeli waja ndiya yao na waitambikila imilungu ayo. ");
INSERT INTO kdc_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Waizilaeli wailumba na imulungu Baali Peoli, Mndewa Imulungu kawagevuzikila Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Avo, Mndewa Imulungu kamulongela Musa, “Wasole vilongozi wose wa Waizilaeli, na uwabote kuulongozi wangu imisi, ili nileke kuwagevuzikila iwanhu.” ");
INSERT INTO kdc_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Avo Musa kawalongela iwasemi wa Izilaeli, “Kila imoja wenu yamkome munhu yoyose kumwenu yailumbile na imulungu Baali Peoli.” ");
INSERT INTO kdc_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mwiizilaeli imoja kamsola mtwanzi imoja Mmidiani kamgala kuna ikibanda chake, kipindi Musa na Waizilaeli wose olola viwakalile hana ulwivi lwa dihema da mting'hano omulilila Mndewa. ");
INSERT INTO kdc_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Avo, Finehasi mwanage Eleazali mzukulu wa Haluni, imulava nhosa, viyonile avo, kenuka kasegela hana umting'hano awo, kasola mgoha, ");
INSERT INTO kdc_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","kamkweleleza ayo Imwiizilaeli mbaka kuna ikibanda kawahoma mgoha mmunda wose wabili. Utamu ukalile owakoma Waizilaeli usegela. ");
INSERT INTO kdc_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Iwanhu wafile mbuli ya awo uutamu wakala elufu ishilini na nne (24,000). ");
INSERT INTO kdc_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwanage Eleazali mzukulu wa Haluni imulava nhosa, kakukimila kugevuzika kwangu mbuli ya Waizilaeli, mna iwanhu wose heyo yaiyeka ayo yonile usungu kamba vinyona niye. Lekaavo siwakomile Waizilaeli wose. ");
INSERT INTO kdc_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Avo mulongele kamba notenda na heyo lagano da tindiwalo. ");
INSERT INTO kdc_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Kumwake heyo na ulelo wake okuwa walava nhosa siku zose kwavija kona usungu mbuli yangu niye Imulungu wake na kawatendela loholo Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ayo Imwiizilaeli yakomigwe hamoja na mtwanzi wa Kimidiani twaga jake kakemigwa Zimili mwanage Salu, imoja wa kilongozi wa wanhu wa kabila da Simeoni. ");
INSERT INTO kdc_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Na ayo imtwanzi Mmidiani yakomigwe, twaga jake kakemigwa Kozibi biti Suli, yakalile kilongozi wa kabila ako Midiani. ");
INSERT INTO kdc_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Wavamileni Wamidiani na muwakome, ");
INSERT INTO kdc_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kwavija hewo wawatendela gehile, wawabunyika mbuli ya Peoli na mbuli ya Kozibi yakomigwe kipindi utamu viwizile ako Peoli.” ");
INSERT INTO kdc_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Vigabitile gago Mndewa Imulungu kamulongela Musa na Eleazali mwanage Haluni imulava nhosa, ");
INSERT INTO kdc_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Wapeteni Waizilaeli wose kila munhu kamba viyeli mna dikabila jake. Wapeteni wambigalo wose kusongela weli na miyaka malongo mabili na kugendelela awo odaha kuchola kuing'hondo.” ");
INSERT INTO kdc_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa na imulava nhosa Eleazali walonga na iwanhu kudibawe da Moabu, behi na lwanda lwa Yolidani, ukalile oilola na buga da Yeliko dikalile umwambu wa ulwanda, wawalongela, ");
INSERT INTO kdc_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Wapeteni iwanhu kusongela waja weli na miyaka malongo mabili na kugendelela, kamba Mndewa Imulungu viyamulagize Musa.” Iwanhu wose kwa wose walawile Misili wakala wano. ");
INSERT INTO kdc_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Mdikabila da Lubeni chaudele wa Yakobo zilawa ng'holo zino. Kubitila Henoki lulawa lukolo lwa Wahanoki, kubitila Palu lulawa lukolo lwa Wapalu, ");
INSERT INTO kdc_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kubitila Hesiloni lulawa lukolo lwa Wahesiloni, kubitila Kalimi lulawa lukolo lwa Wakalimi. ");
INSERT INTO kdc_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Lubeni wakala elufu alobaini na ndatu na magana saba na selasini (43,730). ");
INSERT INTO kdc_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwanage Palu kakala Eliabu, ");
INSERT INTO kdc_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","na wanage Eliabu wakala Nemueli na Datani na Abilamu, awo iwabili Datani na Abilamu wakala wasaguligwe mna umting'hano lakini wamuleka Musa na Haluni na wailumba na iwanhu wamkweleleze Kola, viwamulemile Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Isi igubuka na iwameza, wafa hamoja na Kola na iwanhu wamkweleleze, moto viuwalukuze wanhu magana mabili na malongo matano, acho kiwa kinhu cha kuwazuma iwanhu. ");
INSERT INTO kdc_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Lakini wanhu wa ulelo wa Kola hawakomigwe wose. ");
INSERT INTO kdc_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Mdikabila da Simeoni zilawa ng'holo zino. Kubitila Nemueli lulawa lukolo lwa Wanemueli, kubitila Yamini lulawa lukolo lwa Wayamini, kubitila Yakini lulawa lukolo lwa Wayakini, ");
INSERT INTO kdc_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kubitila Zela lulawa lukolo lwa Wazela, kubitila Shauli lulawa lukolo lwa Washauli. ");
INSERT INTO kdc_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Simeoni wakala elufu ishilini na mbili na magana mbili (22,200). ");
INSERT INTO kdc_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Mdikabila da Gadi zilawa ng'holo zino. Kubitila Sifoni lulawa lukolo lwa Wasifoni, kubitila Hagi lulawa lukolo lwa Wahagi kubitila Shuni lulawa lukolo lwa Washuni, ");
INSERT INTO kdc_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kubitila Ozini lulawa lukolo lwa Waozini, kubitila Eli lulawa lukolo lwa Waeli, ");
INSERT INTO kdc_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","kubitila Alodi lulawa lukolo lwa Waalodi, kubitila Aleli lulawa lukolo lwa Waaleli. ");
INSERT INTO kdc_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Gadi wakala elufu alobaini na magana tano (40,500). ");
INSERT INTO kdc_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Wanage Yuda wakala Eli na Onani. Awo wafila mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Mdikabila da Yuda zilawa ng'holo zino. Kubitila Shela lulawa lukolo lwa Washela, kubitila Pelesi lulawa lukolo lwa Wapelesi, kubitila Zela lulawa lukolo lwa Wazela. ");
INSERT INTO kdc_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Wanage Pelesi wakala Hesiloni na Hamuli. Kubitila Hesiloni lulawa lukolo lwa Wahesiloni, kubitila Hamuli lulawa lukolo lwa Wahamuli. ");
INSERT INTO kdc_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Yuda wakala elufu sabini na sita na magana tano (76,500). ");
INSERT INTO kdc_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Mdikabila da Isakali zilawa ng'holo zino. Kubitila Tola lulawa lukolo lwa Watola, kubitila Puva lulawa lukolo lwa Wapuva, ");
INSERT INTO kdc_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kubitila Yashubu lulawa lukolo lwa Wayashubu, kubitila Shimuloni lulawa lukolo lwa Washimuloni. ");
INSERT INTO kdc_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Isakali wakala elufu sitini na nne na magana ndatu (64,300). ");
INSERT INTO kdc_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Mdikabila da Zabuloni zilawa ng'holo zino. Kubitila Seledi lulawa lukolo lwa Waseledi, kubitila Eloni lulawa lukolo lwa Waeloni, kubitila Yaleeli lulawa lukolo lwa Wayaleeli. ");
INSERT INTO kdc_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Zebuloni wakala elufu sitini na magana tano (60,500). ");
INSERT INTO kdc_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Kulawa Yusufu tatao Manase na Efulaimu galawa makabila mabili, kabila da Manase na kabila da Efulaimu. ");
INSERT INTO kdc_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Mdikabila da Manase zilawa ng'holo zino. Kubitila Makili lulawa lukolo lwa Wamakili, kubitila Gileadi lulawa lukolo lwa Wagileadi, ");
INSERT INTO kdc_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","wanage Gileadi wakala Yezeli na Heleki, kubitila Yezeli lulawa lukolo lwa Wayezeli, kubitila Heleki lulawa lukolo lwa Waheleki, ");
INSERT INTO kdc_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kubitila Asilieli lulawa lukolo lwa Waasilieli, kubitila Shekemu lulawa lukolo lwa Washekemu, ");
INSERT INTO kdc_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kubitila Shemida lulawa lukolo lwa Washemida, kubitila Hefeli lulawa lukolo lwa Wahefeli. ");
INSERT INTO kdc_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi mwanage Hefeli halelile wana wa kimbigalo, ila kalela wana wa kitwanzi waiyeka, matwaga gao gakala Mala na Nuhu na Hogila na Milika na Tiliza. ");
INSERT INTO kdc_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Manase wakala elufu hamsini na mbili na magana saba (52,700). ");
INSERT INTO kdc_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Mdikabila da Efulaimu zilawa ng'holo zino. Kubitila Shutela lulawa lukolo lwa Washutela, kubitila Bekeli lulawa lukolo lwa Wabekeli, kubitila Tahani lulawa lukolo lwa Watahani. ");
INSERT INTO kdc_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Mwanage Shutela kakala Elani, kubitila Elani lulawa lukolo lwa Waelani. ");
INSERT INTO kdc_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Efulaimu wakala elufu selasini na mbili na magana tano (32,500). Kabila zose azo mbili zilawa kwa Yusufu. ");
INSERT INTO kdc_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Mdikabila da Benjamini zilawa ng'holo zino. Kubitila Bela lulawa lukolo lwa Wabela, kubitila Ashibeli lulawa lukolo lwa Waashibeli, kubitila Ahilamu lulawa lukolo lwa Waahilamu, ");
INSERT INTO kdc_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kubitila Shufamu lulawa lukolo lwa Washufamu, kubitila Hufamu lulawa lukolo lwa Wahufamu. ");
INSERT INTO kdc_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Wanage Bela wakala Alidi na Naamani. Kubitila Alidi lulawa lukolo lwa Waalidi, kubitila Naamani lulawa lukolo lwa Wanaamani. ");
INSERT INTO kdc_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Benjamini wakala elufu alobaini na tano na magana sita (45,600). ");
INSERT INTO kdc_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Mdikabila da Dani lulawa lukolo luno. Kubitila Shuhamu lulawa lukolo lwa Washuhamu. ");
INSERT INTO kdc_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Dani wakala elufu sitini na nne na magana nne (64,400). ");
INSERT INTO kdc_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Mdikabila da Asheli zilawa ng'holo zino. Kubitila Imina lulawa lukolo lwa Waimina, kubitila Ishivi lulawa lukolo lwa Waishivi, kubitila Belia lulawa lukolo lwa Wabelia. ");
INSERT INTO kdc_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Wanage Belia wakala Hebeli na Malikieli. Kubitila Hebeli lulawa lukolo lwa Wahebeli, kubitila Malikieli lulawa lukolo lwa Wamalikieli. ");
INSERT INTO kdc_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheli kakala na mndele yakemigwe Sela. ");
INSERT INTO kdc_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Asheli wakala elufu hamsini na ndatu na magana nne (53,400). ");
INSERT INTO kdc_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Mdikabila da Nafutali zilawa ng'holo zino. Kubitila Yaseeli lulawa lukolo lwa Wayaseeli, kubitila Guni lulawa lukolo lwa Waguni, ");
INSERT INTO kdc_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kubitila Yeseli lulawa lukolo lwa Wayeseli, kubitila Shilemu lulawa lukolo lwa Washilemu. ");
INSERT INTO kdc_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Iwambigalo wose kwa wose wapetigwe kulawa mzing'holo za kabila da Nafutali wakala elufu alobaini na tano na magana nne (45,400). ");
INSERT INTO kdc_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Waizilaeli wose kwa wose viwapetigwe wakala laki sita na elufu imoja na magana saba na selasini (601,730). ");
INSERT INTO kdc_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Wanhu wa makabila gano gose uwagwelele isi ayo kamba uhazi wao, kamba viwapetigwe kwa matwaga gao. ");
INSERT INTO kdc_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kabila dili na wanhu wengi wagweleligwe uhazi mkulu na kabila dili na wanhu wadodo wagweleligwe uhazi mdodo. Kila kabila digweleligwe uhazi wake kamba iwanhu viweli. ");
INSERT INTO kdc_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Vivija isi ayo igoligwe kwa kubwanha simbi. Kila kabila digweleligwe isi ayo kamba matwaga ga wahenga zao vigeli. ");
INSERT INTO kdc_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Uhazi wa kila kabila ugoligwe kwa kubwanha simbi, kila kabila digweleligwe kamba vidili kulu hebu vidili dodo.” ");
INSERT INTO kdc_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Mdikabila da Lawi zilawa ng'holo zino. Kubitila Gelishoni lulawa lukolo lwa Wagelishoni, kubitila Kohati lulawa lukolo lwa Wakohati, kubitila Melali lulawa lukolo lwa Wamelali. ");
INSERT INTO kdc_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Vivija ng'holo zino zilawa mdikabila da Lawi, Walibini na Wahebuloni na Wamahili na Wamushi na Wakola. Kohati kakala tata wa Amulamu. ");
INSERT INTO kdc_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Mwehe wa Amulamu twaga jake kakemigwa Yokebedi biti Lawi, kalelekela ako Misili. Mtwanzi ayo kamulelela Amulamu wana wadatu, wa kimbigalo wabili, Haluni na Musa na mtwanzi imoja yakemigwe Miliamu. ");
INSERT INTO kdc_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Haluni kakala na wana wa kimbigalo wane, Nadabu na Abihu na Eleazali na Itamali. ");
INSERT INTO kdc_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Lakini Nadabu na Abihu wafa viwamgalile Mndewa Imulungu nhosa ya moto haung'ala. ");
INSERT INTO kdc_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Walawi wambigalo wose kwa wose kusongela wana weli na mwezi umoja na kugendelela wakala elufu ishilini na ndatu (23,000). Wano hawapetigwe hamoja na Waizilaeli wayagwe kwavija wao hawagweleligwe isi yoyose kamba uhazi wao mna iwanhu wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Wano awo wambigalo mna iwanhu wa Izilaeli wapetigwe na Musa na imulava nhosa Eleazali kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda. ");
INSERT INTO kdc_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Kuduhu hata munhu imoja yasigale mna iwanhu wapetigwe na Musa na imulava nhosa Haluni, kipindi viwawapetile iwanhu kwa mwanza wa ichanduso ako kuluwala lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Kwavija Mndewa Imulungu kakala yalongile wose ofila kuluwala, na vivo ikalile kuduhu hata munhu imoja yasigale mgima, ila Kalebu mwanage Yefune na Yoshua mwanage Nuni. ");
INSERT INTO kdc_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Mala na Nuhu na Hogila na Milika na Tiliza wakala wandele wa Selofehadi. Selofehadi kakala mwanage Hefeli, Hefeli kakala mwanage Gileadi, Gileadi kakala mwanage Makili na Makili kakala mwanage Manase na Manase kakala mwanage Yusufu. ");
INSERT INTO kdc_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Avo, awo iwandele wane wamcholela Musa, wema kuulongozi wa Eleazali imulava nhosa na vilongozi wose wa Izilaeli hana ulwivi lwa dihema da mting'hano walonga, ");
INSERT INTO kdc_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Tataetu kafa ako kuluwala. Hakalile mna iwanhu wamkweleleze Kola, ayo yamulemile Mndewa Imulungu ila heyo kafa kwa nzambi zake mwenyego, na kakala kabule wana wa kimbigalo. ");
INSERT INTO kdc_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Avo habali twaga da tataetu dipotele mna iwanhu wa Izilaeli kwavija kakala kabule wana wa kimbigalo? Avo mtugwelele uhazi hamoja na iwandugu wa tataetu.” ");
INSERT INTO kdc_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Avo Musa kaigala mbuli ayo kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Azo ziwolonga iwandele wa Selofehadi za ukweli, uwagwelele uhazi hamoja na iwandugu wa tatao, waleke wasole uhazi wa tatao. ");
INSERT INTO kdc_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Abaho uwalongele Waizilaeli kamba munhu yahafa bila kuleka mwana wa kimbigalo, uhazi awo yagweleligwe mwana wa ikitwanzi. ");
INSERT INTO kdc_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Na kamba kabule mwana wa kitwanzi, avo uhazi awo wagweleligwe wakulu zake hebu wadodo zake. ");
INSERT INTO kdc_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Na kamba kabule wakulu hebu wadodo, uhazi awo wagweleligwe tata zake wakulu hebu wadodo. ");
INSERT INTO kdc_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na kamba kabule tata mkulu hebu mdodo, avo uhazi awo yagweleligwe ndugu yake wa behi, na heyo yausole kamba wake mwenyego. Gano gago malagizo gangu kwa Waizilaeli, kamba niye Mndewa Imulungu vinikulagize.” ");
INSERT INTO kdc_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mndewa Imulungu kamulongela Musa, “Kwela uchanha ya ivigongo vino va Abalimu, uilole isi yonda niwagwelele Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Wahamambukiza kuilola na gweye vivija kofa kamba ndugu yako Haluni viyafile, ");
INSERT INTO kdc_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kwavija hamdigogile lagizo jangu kuja kuluwala lwa Sini. Kipindi iwanhu wose viwaniyalalile kuja Meliba, mulema kulagusa ukulu wangu mgameso gao viwalondile wagweleligwe mazi.” ");
INSERT INTO kdc_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa kampula Mndewa Imulungu, kalonga, ");
INSERT INTO kdc_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Go, Mndewa Imulungu wangu, gweye uli mwanduso wa ugima nokupula umsagule munhu wa kuwalola iwanhu wano, ");
INSERT INTO kdc_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","na yawalongoze mna izisang'hano zao zose, ili sikuwawe kamba ng'hondolo yelibule msusilaji.” ");
INSERT INTO kdc_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Avo Mndewa Imulungu kamulongela Musa, “Msole Yoshua mwanage Nuni, imunhu yeli na moyo unogile, abaho umwikile makono, ");
INSERT INTO kdc_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","na gweye umwimize kuulongozi wa imulava nhosa Eleazali na umting'hano wose na gweye umsagule yawe kilongozi wao. ");
INSERT INTO kdc_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umgwelele hanhu ha sang'hano zako ili Waizilaeli wose wamtegeleze. ");
INSERT INTO kdc_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Heyo yamuuzege Eleazali imulava nhosa yeli na dija idibwe da kujuwa gaja igangu. Kwa nzila ayo Eleazali komulongoza Yoshua na iwanhu wose wa Izilaeli mna zimbuli zose.” ");
INSERT INTO kdc_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa katenda kamba viyalagizwe na Mndewa Imulungu. Kamsola Yoshua na kamwimiza kuulongozi wa Eleazali imulava nhosa na iwanhu wose wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Abaho kamwikila makono na kamgwaa isang'hano kamba viyalagizwe na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Walongele Waizilaeli vino, mweye mundavile nhosa zilondigwa mna ikipindi kikigwe, ndiya za kusoma moto zilava mnung'ho uninogeza niye. ");
INSERT INTO kdc_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“Walongele inhosa ya ndiya ya kusoma moto yonda wandavile iwe, wana ng'hondolo wabili wa mwaka umoja welibule kilema chochose, nhosa ayo ilavigwe kila siku. ");
INSERT INTO kdc_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mwana ng'hondolo imoja yalavigwe imitondo na wa kabili ichungulo, ");
INSERT INTO kdc_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","kila mwana ng'hondolo imoja yalavigwe hamoja na vibaba vibili va usage unogile utibwilizigwe na mavuta ganogile nyhupa imoja. ");
INSERT INTO kdc_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ino yokuwa nhosa ilavagwa kila siku, na yosomigwa kwa moto, nhosa ayo isonga kulavigwa kulugongo lwa Sinai kamba nhosa ya ndiya, ilava mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nhosa ya king'waji ya nyhupa imoja ya divai ilavigwe na kila imwana ng'hondolo. Nhosa ayo ya king'waji uigide mna ihanhu hong'ala. ");
INSERT INTO kdc_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ichungulo umulave ija imwana ng'hondolo wa kabili hamoja na imhishi ya usage utibwilizigwe na mavuta na inhosa ya king'waji isomigwa kwa moto kamba ija wa imitondo. Nhosa ayo ya ndiya yolava mnung'ho uninogeza niye Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Mna isiku ya Kubwihila, mulave nhosa ya wana ng'hondolo wabili weli na mwaka umoja na welibule kilema chochose, hamoja na mhishi imoja ya usage unogile utibwilizigwe na mavuta na mulave na inhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Nhosa ino ya kusoma moto ilavigwe kila siku ya Kubwihila bila kuleka ija inhosa ilavagwa kila siku hamoja na inhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Na kila mwezi viusonga, munilavile niye Mndewa Imulungu nhosa ya kusoma moto, ng'ombe mbigalo wabili, ng'hondolo mbigalo imoja na wana ng'hondolo mbigalo saba wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Vivija mulave nhosa ya ndiya ya mhishi imoja na vibaba vibili va usage unogile utibwilizigwe na mavuta kwa kila ng'ombe mbigalo, na mhishi imoja ya usage unogile utibwilizigwe na mavuta mbuli ya ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na vibaba vibili va usage unogile utibwilizigwe na mavuta kwa kila imwana ng'hondolo. Nhosa zino za kusoma moto azo nhosa za ndiya zilava mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Divai kamba nhosa ya king'waji nyhupa mbili zilavigwe kwa kila ing'ombe mbigalo na nyhupa imoja na nusu ilavigwe kwa kila ng'hondolo mbigalo na nyhupa imoja ilavigwe kwa kila imwana ng'hondolo. Ino ayo inhosa ya kusoma moto ya kila mwezi mna umwaka mgima. ");
INSERT INTO kdc_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Vivija munilavile niye Mndewa Imulungu nhosa ya kusegesa nzambi, mbuzi mbigalo imoja, bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na inhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Mna isiku ya longo na nne ya mwezi wa ichanduso yokuwa Pasaka ya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Mna isiku ya longo na tano ya mwezi awo nyimwilinyimwili ya magate hagageligwe hamila yosonga. Kwa siku saba muje magate hagageligwe hamila. ");
INSERT INTO kdc_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Mna isiku ya ichanduso ya nyimwilinyimwili ayo hokuwa na mting'hano ung'alile. Siku ayo sikumusang'hane. ");
INSERT INTO kdc_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Mulave nhosa ya kusoma moto kamba nhosa ya ndiya kumwangu niye Mndewa Imulungu. Ng'ombe mbigalo wabili, ng'hondolo mbigalo imoja, wana ng'hondolo mbigalo saba wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Vivija mulave na inhosa ya ndiya ya mhishi imoja na vibaba vibili va usage utibwilizigwe na mavuta kwa kila ing'ombe mbigalo, mhishi imoja mbuli ya ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na vibaba vibili kwa kila imwana ng'hondolo mna iwao saba. ");
INSERT INTO kdc_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi ili kuwatendela loholo. ");
INSERT INTO kdc_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Mulave vinhu avo vose bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku. ");
INSERT INTO kdc_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Vivija kwa siku azo zose saba, mulave nhosa ya kusoma moto kamba nhosa ya ndiya, ilava mnung'ho uninogeza niye Mndewa Imulungu. Nhosa ayo muilave bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na inhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Mna isiku ya saba mutende mting'hano ung'alile, na sikumusang'hane. ");
INSERT INTO kdc_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Mna isiku ya ichanduso ya nyimwilinyimwili ya mawiki, kipindi vimunilavila niye Mndewa Imulungu gaja gaichanduso kusengigwa, mutende mting'hano ung'alile, na sikumusang'hane. ");
INSERT INTO kdc_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mulave nhosa ya kusoma moto, ilava mnung'ho uninogeza niye Mndewa Imulungu. Ng'ombe mbigalo wabili, ng'hondolo mbigalo imoja, wana ng'hondolo saba wa kimbigalo wa mwaka umoja, welibule kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Vivija mulave nhosa ya ndiya ya mhishi imoja na vibaba vibili va usage unogile utibwilizigwe na mavuta kwa kila ng'ombe mbigalo, na mhishi imoja mbuli ya ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na vibaba vibili kwa kila imwana ng'hondolo, mna iwao saba. ");
INSERT INTO kdc_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi ili kuwatendela loholo. ");
INSERT INTO kdc_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Mulave vinhu avo vose bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na inhosa ya king'waji. Vivija iwanyama awo wose sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Mna isiku ya ichanduso ya mwezi wa saba, mutende mting'hano ung'alile, na sikumusang'hane. Siku ayo yokuwa ya kutowa mhalati. ");
INSERT INTO kdc_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mulave nhosa ya kusoma moto, ilava mnung'ho uninogeza niye Mndewa Imulungu, ng'ombe mbigalo imoja, ng'hondolo mbigalo imoja na wana ng'hondolo wa kimbigalo saba wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Vivija mulave nhosa ya ndiya ya usage unogile utibwilizigwe na mavuta, mhishi imoja na vibaba vibili mbuli ya ing'ombe mbigalo, na mhishi imoja mbuli ya ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na vibaba vibili kwa kila imwana ng'hondolo mna iwao saba. ");
INSERT INTO kdc_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi ili kuwatendela loholo. ");
INSERT INTO kdc_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Mulave vinhu avo vose bila kuleka ija inhosa ya kusoma moto na inhosa ya king'waji na inhosa ya ndiya ilavagwa siku ya ichanduso ya kila mwezi na inhosa ya kusoma moto na inhosa ya indiya na inhosa ya king'waji ilavagwa kila siku. Nhosa azo zolava mnung'ho uninogeza niye Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Mna isiku ya longo ya mwezi awo wa saba mutende mting'hano ung'alile. Siku ayo mfunge kuja na sikumusang'hane sang'hano yoyose. ");
INSERT INTO kdc_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Mundavile niye Mndewa Imulungu nhosa ya kusoma moto ilava mnung'ho uninogeza niye. Ng'ombe mbigalo imoja, ng'hondolo mbigalo imoja na wana ng'hondolo wa kimbigalo saba wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Vivija mulave nhosa ya ndiya ya usage unogile utibwilizigwe na mavuta, mhishi imoja na vibaba vibili mbuli ya ing'ombe mbigalo, na mhishi imoja mbuli ya ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na vibaba vibili kwa kila imwana ng'hondolo mna iwao saba. ");
INSERT INTO kdc_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi bila kuleka inhosa ya kuwatendela wanhu loholo hamoja na inhosa ya kusoma moto ilavagwa kila siku, na nhosa yake ya indiya na nhosa ya king'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Mna isiku ya longo na tano ya mwezi awo wa saba mutende mting'hano ung'alile. Muideng'helele nyimwilinyimwili kwa siku saba mbuli ya Mndewa Imulungu na sikumusang'hane. ");
INSERT INTO kdc_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Siku ayo mulave nhosa ya kusoma moto kamba nhosa ya ndiya ilava mnung'ho uninogeza niye Mndewa Imulungu. Ng'ombe mbigalo longo na wadatu, ng'hondolo mbigalo wabili na wana ng'hondolo wa kimbigalo longo na nne wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Vivija mulave nhosa ya ndiya ya usage unogile utibwilizigwe na mavuta, mhishi imoja na vibaba vibili kwa kila ing'ombe mbigalo, na mhishi imoja kwa kila ing'hondolo mbigalo, ");
INSERT INTO kdc_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na vibaba vibili kwa kila imwana ng'hondolo mna iwao longo na nne. ");
INSERT INTO kdc_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Siku da kabili mulave ng'ombe mbigalo longo na wabili na ng'hondolo mbigalo wabili, wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba viikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Siku ya kadatu mulave ng'ombe mbigalo longo na imoja na ng'hondolo mbigalo wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba vikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Siku ya ikane mulave ng'ombe mbigalo longo, na ng'hondolo mbigalo wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba vikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Siku ya tano mulave ng'ombe mbigalo tisa, na ng'hondolo mbigalo wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba viikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Siku ya sita mulave ng'ombe mbigalo nane, na ng'hondolo mbigalo wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba viikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Siku ya saba mulave ng'ombe mbigalo saba, na ng'hondolo mbigalo wabili, na wana ng'hondolo wa kimbigalo wa mwaka umoja longo na nne, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba vikalile siku da ichanduso. ");
INSERT INTO kdc_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Mna isiku ya nane mutende mting'hano ung'alile na sikumusang'hane. ");
INSERT INTO kdc_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mulave nhosa ya kusoma moto kamba nhosa ya ndiya ilava mnung'ho uninogeza niye Mndewa Imulungu. Ng'ombe mbigalo imoja, ng'hondolo mbigalo imoja na wana ng'hondolo saba wa mwaka umoja, wose awo sikuwawe na kilema chochose. ");
INSERT INTO kdc_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Vivija mulave inhosa ya indiya na inhosa ya king'waji hamoja na iwang'ombe mbigalo na iwang'hondolo mbigalo na iwana ng'hondolo kamba viilondigwe. ");
INSERT INTO kdc_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Vivija mulave mbuzi mbigalo imoja kamba nhosa ya kusegesa nzambi. Laveni vinhu avo bila kuleka ija inhosa ya kusoma moto ilavagwa kila siku hamoja na nhosa yake ya indiya na nhosa ya iking'waji. ");
INSERT INTO kdc_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Gano gago malagizo mbuli ya nhosa ya kusoma moto, na nhosa ya ndiya na nhosa ya king'waji na nhosa ya kugala kuilumba zonda mundavile niye Mndewa Imulungu mna ikipindi cha nyimwilinyimwili zenu, bila kuleka inhosa ya kuvikiza gaja gaulongile na nhosa ya kulonda mwenyego. ");
INSERT INTO kdc_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Avo, Musa kawalongela Waizilaeli kila kinhu kiyamulongele Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa kawagwaa malagizo gano vilongozi wa makabila ga Izilaeli. Gano gago gayamulagize Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Munhu yahaiduwila kwa Mndewa Imulungu, hebu yahalonga kwa kuiduwila kamba kuna kinhu kokitenda, munhu ayo kolondigwa sikuyabene kuiduwila kwake na yatende gose kamba viyalongile kwa mulomo wake. ");
INSERT INTO kdc_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kamba mndele yogendelela kukala mng'anda ya tatake yahaiduwila kinhu kwa Mndewa Imulungu na kuifunga mwenyego kwa mbuli ayo, ");
INSERT INTO kdc_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na tatake komuhulika na hamgomesa bule, avo mndele ayo kolondigwa yatende kila kinhu kamba viyalongile. ");
INSERT INTO kdc_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Lakini kamba tata wa mndele ayo kahulika na kamgomesa kutenda gago yalongile, avo mndele ayo halondigwa kutenda mbuli azo ziyalongile. Mndewa Imulungu koigela kumgongo mbuli ayo kwavija tatake kamgomesa kutenda gayalongile. ");
INSERT INTO kdc_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Lakini kamba mndele ayo kasoligwa na kuno kaiduwila kinhu kwa Mndewa hebu kalonga kinhu bila kugelegeza goya na kuifunga mwenyego kwa mbuli zake, ");
INSERT INTO kdc_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","na mkasano wake kazihulika mbuli azo na hamgomese bule, avo kolondigwa yatende kamba viyalongile. ");
INSERT INTO kdc_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Lakini kamba mkasano wake kazihulika mbuli azo na kamgomesa avo ayo imkasano kokuwa kaisegesa mbuli ayo na Mndewa Imulungu koigela kumgongo mbuli ayo. ");
INSERT INTO kdc_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Lakini mtwanzi mgane hebu yasigwe kolondigwa yatende kila kinhu kamba viyalongile kotenda kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Mtwanzi yasoligwe yahaiduwila kinhu hebu kulonga kotenda kinhu kwa Mndewa, ");
INSERT INTO kdc_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","na mkasano wake kahulika na hamgomese bule, avo kolondigwa yatende kila kinhu kiyalongile. ");
INSERT INTO kdc_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Lakini kamba mkasano wake vonda yahulike mbuli azo komgomesa avo hata kamba mtwanzi ayo kolonda kutenda kila kinhu kiyalongile avo halondigwa yatende na kwavija imkasano kazisegesa, avo Mndewa Imulungu koigela kumgongo mbuli ayo. ");
INSERT INTO kdc_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mkasano wake kodaha kusegesa hebu kuitogola mbuli yoyose ilongigwa na mtwanzi ayo kwa kuiduwila na kumtenda yaifunge mwenyego. ");
INSERT INTO kdc_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Lakini kamba imkasano halonga mbuli yoyose toka siku viyomuhulika mwehe wake kolonga mbuli kwa kuiduwila avo kokuwa kaitogola mbuli ayo kulawa siku dijo viyaihulike kwavija halongile mbuli yoyose. ");
INSERT INTO kdc_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Lakini kamba yahazitogola na baho kumwande kozilema avo heyo kolondigwa yapape gehile ga mwehe wake. ");
INSERT INTO kdc_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Gano gago malagizo ga Mndewa Imulungu gayamgwelele Musa kwa mbigalo na mwehe wake na kwa tata na mndele wake kamba mndele ayo hanasoligwa na kokala kwa tatake. ");
INSERT INTO kdc_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Uwabwezele Wamidiani kwa gaja gawawatendele Waizilaeli, wahamambukiza kutenda vivo gweye kofa.” ");
INSERT INTO kdc_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Avo Musa kawalongela iwanhu, “Watandeni wakalizi wachole wakawavamile Wamidiani na kuwabwezela gehile mbuli ya Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kulawa kila kabila da Izilaeli, musagule wakalizi wa ng'hondo elufu imoja.” ");
INSERT INTO kdc_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Avo wanhu elufu imoja wasaguligwa kulawa kila kabila da Waizilaeli, wose kwa wose wakala wambigalo elufu kumi na mbili waitandile kwa ng'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa kawagala wanhu awo kuna ing'hondo, kilongozi wao kakala Finehasi mwanage imulava nhosa Eleazali akuno kavipapa viya va hanhu hong'ala na zimhalati za kutowa ili kulava kilaguso cha ng'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Waivamila isi ya Wamidiani kamba Mndewa Imulungu viyamulagize Musa, wawakoma wambigalo wose. ");
INSERT INTO kdc_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mna iwanhu awo wakomigwe kukala na wandewa watano wa isi ya Midiani, wakala Evi na Lekemu na Suli na Huli na Leba. Vivija wamkoma Balaamu mwanage Beoli. ");
INSERT INTO kdc_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Waizilaeli wavisola vinhu vao vose, vivija wasola watwanzi na iwana na ng'ombe na fugo zose ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Gamabuga na ng'hambi zao wavisoma kwa moto. ");
INSERT INTO kdc_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Wavisola ivinhu vose na iwanhu wawagogile na iwanyama, ");
INSERT INTO kdc_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","wamgalila Musa na Eleazali, na iwanhu wose wa Izilaeli wakalile wekile ng'hambi kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda. ");
INSERT INTO kdc_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Avo Musa na Eleazali na ivilongozi wose wa umting'hano wa Waizilaeli wachola kunze ya ing'hambi kuwabokela awo iwakalizi. ");
INSERT INTO kdc_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa kawagevuzikila iwakulu wa wakalizi wose, iwakulu wa wakalizi elufu imoja na iwakulu wa wakalizi gana, wabwelile kulawa kuna ing'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa kawauza, “Habali muwaleka watwanzi wose wano wawe wagima? ");
INSERT INTO kdc_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Kumbukeni kamba, iwatwanzi awo wakweleleza lagizo da Balaamu, na watenda Waizilaeli wamtendele Mndewa Imulungu nzambi ako Peoli mbaka mitamu iwezila iwanhu wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Avo wakomeni wana wose wa kimbigalo na kila mndele yawasile na mbigalo. ");
INSERT INTO kdc_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Lakini sikumuwakome wandele wose waja hawanawasa na wambigalo, walekeni wagima mbuli yenu wenyego. ");
INSERT INTO kdc_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Iwanhu wose hagati yenu wakomile wanhu hebu kukwasa maiti olondigwa wakale kunze ya ing'hambi kwa siku saba, muisunhe mweye na iwanhu muwagogile kudisiku da kadatu na siku da isaba. ");
INSERT INTO kdc_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vivija mkisunhe kila kiwalo, na kila kinhu kitendigwe kwa ng'hwembe, kila kinhu kitendigwe kwa mibahila ya mbuzi hebu mibiki.” ");
INSERT INTO kdc_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mulava nhosa Eleazali kawalongela iwambigalo wose wabwelile kulawa kuna ing'hondo, “Gano gago malagizo gayagweleligwe Musa na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zahabu na shaba na shaba ya kiguzi na chuma na bati na lisasi, ");
INSERT INTO kdc_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na vose viyagwe vibitaga muumoto, vibitizwe muumoto ili kuvitenda ving'hale, na vivija volondigwa vitendigwe ving'ale kwa gaja gamazi ga kusegesa gehile. Vinhu vose viyagwe havidahaga kukala muumoto avo vitendigwe ving'ale kwa gago gamazi ga kusegesa gehile. ");
INSERT INTO kdc_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Siku ya saba muvifue viwalo venu na mweye mokuwa mong'ala na modaha kwingila mwiing'hambi.” ");
INSERT INTO kdc_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Gweye na Eleazali imulava nhosa hamoja na vilongozi wa ng'holo za makabila ga Waizilaeli vipeteni ivinhu vose na iwanhu na iwanyama visoligwe kuna ing'ondo. ");
INSERT INTO kdc_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Vigoleni vinhu avo mna gamafungu mabili, fungu dimoja dokuwa da iwakalizi wacholile kuna ing'hondo na diyagwe dokuwa da iwanhu wose wayagwe wa Izilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Abaho kulawa mdifungu da iwakalizi wacholile kuna ing'hondo, usole kinhu kimoja kulawa mna kila vinhu magana matano, iwe wanhu, ng'ombe, vihongwe, ng'hondolo hebu mbuzi. ");
INSERT INTO kdc_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Vinhu avo umgwelele imulava nhosa Eleazali kamba sadaka kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kulawa mdifungu da iwanhu wose, lava kinhu kimoja kwa kila vinhu malongo matano, iwe wanhu, ng'ombe, vihongwe, ng'hondolo hebu mbuzi. Vinhu avo uwagwee Walawi awo osang'hana mna dihema da Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa na imulava nhosa Eleazali watenda kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ivinhu viwasolile awo iwakalizi ako kuna ing'hondo vikala, ng'hondolo laki sita na elufu sabini na tano (675,000), ");
INSERT INTO kdc_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ng'ombe elufu sabini na mbili (72,000), ");
INSERT INTO kdc_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","vihongwe elufu sitini na imoja (61,000), ");
INSERT INTO kdc_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na wandele hawanawasa na wambigalo wakala elufu selasini na mbili (32,000). ");
INSERT INTO kdc_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nusu ya ivinhu avo wagweleligwa iwakalizi wacholile kuna ing'hondo, ng'hondolo laki ndatu na elufu selasini na saba na magana tano (337,500), ");
INSERT INTO kdc_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","mna iwang'hondolo awo walavigwe kwa Mndewa Imulungu wakala ng'hondolo magana sita na sabini na tano (675). ");
INSERT INTO kdc_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ng'ombe wa awo iwakalizi wakala elufu selasini na sita (36,000), na mna iwao iwang'ombe sabini na mbili walavigwa kwa Mndewa Imulungu kamba sadaka. ");
INSERT INTO kdc_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Vihongwe wa awo iwakalizi wakala elufu selasini na magana tano (30,500), na mna iwao vihongwe sitini na imoja walavigwa kwa Mndewa Imulungu kamba sadaka. ");
INSERT INTO kdc_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Iwanhu wakala elufu kumi na sita (16,000), na mna iwao wanhu selasini na mbili walavigwa kwa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Avo Musa kamgwelela vinhu avo Eleazali imulava nhosa kamba sadaka kwa Mndewa Imulungu, kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ija inusu iyagwe iwagweleligwe Waizilaeli, ayo iyaibagule Musa na ija inusu iwagweleligwe iwakalizi wacholile kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","wakala ng'hondolo laki ndatu na elufu selasini na saba na magana tano (337,500), ");
INSERT INTO kdc_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ng'ombe wakala elufu selasini na sita (36,000), ");
INSERT INTO kdc_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","vihongwe wakala elufu selasini na magana tano (30,500), ");
INSERT INTO kdc_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","wanhu wakala elufu kumi na sita (16,000). ");
INSERT INTO kdc_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kulawa mna inusu ayo iwagweleligwe Waizilaeli, Musa kalava mnyama imoja hebu munhu imoja kulawa kila bumbila da malongo matano, kamba Mndewa Imulungu viyamulagize, kawagwaa Walawi awo wasang'hane kuna dihema da Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Abaho iwakulu wa iwakalizi elufu imoja na iwakulu wa wakalizi gana, wamcholela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","wamulongela, “Go mkulu, siye tuwapeta iwakalizi wose watukalile towalongoza na tona kamba haduhu hata munhu imoja yaswelile. ");
INSERT INTO kdc_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Avo tugala viya va zahabu na vikuku na bangili na pete na heleni na ushanga kamba kila munhu viyapatile. Tuvigala ili tutendeligwe loholo kuulongozi wa Mndewa Imulungu.” ");
INSERT INTO kdc_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Avo, Musa na Eleazali wavibokela vinhu avo vigeligwe ulembo kwa zahabu. ");
INSERT INTO kdc_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Zahabu yose ilavigwe kwa Mndewa Imulungu ikala yovika kamba kilo magana mabili. ");
INSERT INTO kdc_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kila mkalizi hakalile kilongozi kasigala na vinhu vake mwenyego viyasolile ako kuna ing'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Avo Musa na Eleazali imulava nhosa waibokela zahabu ayo kulawa mmakono ga awo iwakulu wa wakalizi, waigala mna dihema da mting'hano, ili iwe kinhu cha kukumbuka kwa Waizilaeli kuulongozi wa Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Makabila ga Lubeni na Gadi gakala na fugo nyingi. Avo viwone isi ya Yazeli na Gileadi zofaya kwa fugo zao, ");
INSERT INTO kdc_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","wamcholela Musa na Eleazali na ivilongozi wose wa umting'hano wawalongela, ");
INSERT INTO kdc_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Mabuga ga Ataloti na Diboni na Yazeli na Nimla na Heshiboni na Eleale na Sebamu na Nebo na Beoni, ");
INSERT INTO kdc_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","isi ayo yose Mndewa Imulungu kaihuma mbuli ya Waizilaeli, isi ayo inoga kwa fugo, na siye tuna fugo nyingi, ");
INSERT INTO kdc_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","avo kamba mweye munogelwa towapula mutugwelele isi ayo iwe yetu, sikutuloke umwambu wa lwanda lwa Yolidani.” ");
INSERT INTO kdc_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa kawedika awo iwanhu wa makabila ga Gadi na Lubeni, “Molonda kusigala hano akuno ndugu zenu Waizilaeli ochola kuna ing'hondo? ");
INSERT INTO kdc_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Habali mowadonheza Waizilaeli sikuwachole mwiisi iyawalongele Mndewa Imulungu kowagwelela? ");
INSERT INTO kdc_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Wahenga zenu watenda vivo viniwatumile kulawa Kadeshi Balinea wakaisungulile isi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Hewo wachola mbaka kubonde da Eshikoli, wayona isi ayo lakini viwabwelile wawadonheza Waizilaeli ili sikuwengile mwiisi iyalongile Mndewa Imulungu kowagwaa. ");
INSERT INTO kdc_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Mndewa Imulungu kagevuzika ng'hani siku dijo na kaiduwila kalonga, ");
INSERT INTO kdc_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Kuduhu hata munhu yoyose mna iwanhu walawile Misili yeli na miyaka malongo mabili na kugendelela, yonda yayone isi inilongile nowagwaa Abulahamu na Isaka na Yakobo, kwavija hawanikweleleze kwa mizoyo yao yose.’ ");
INSERT INTO kdc_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Wose honda wayone isi ayo ila Kalebu mwanage Yefune kulawa lukolo lwa Wakenizi na Yoshua mwanage Nuni, kwavija wao wanikweleleza kwa mizoyo yao yose. ");
INSERT INTO kdc_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Mndewa Imulungu kawagevuzikila Waizilaeli kawatenda tanga nzulule kuluwala kwa miyaka malongo mane mbaka ulelo wose wa awo watendile gehile wafa. ");
INSERT INTO kdc_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Sambi mweye ulelo wa wene nzambi, muzuka hanhu ha iwahenga zenu, na molonda kwengeza kugevuzika kwa Mndewa Imulungu kwa Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Kamba mweye mwahalema kumkweleleza, heyo kowaleka kabili kuluwala na mweye mowatenda wanhu wose wano wakomigwe.” ");
INSERT INTO kdc_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Avo wamcholela Musa wamulongela, “Tutogolele tuwazengele ng'hondolo zetu mabumba, na tuwazengele mabuga wanetu hano. ");
INSERT INTO kdc_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Lakini siye wenyego toitanda kuchola kuna ing'hondo hamoja na ndugu zetu Waizilaeli, na tolongola mbaka tuwavikize hanhu honda wakale. Kipindi acho wanetu okala mna gamabuga gazunguluswe ili sikuwavamiligwe na iwenekae wa isi ino. ");
INSERT INTO kdc_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Siye hatubwela ukae mbaka Waizilaeli wose vonda wagweleligwe hanhu hao kamba uhazi wao. ");
INSERT INTO kdc_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Honda tuhazi kinhu chochose ako umwambu wa lwanda lwa Yolidani, kwavija siye tupata uhazi wetu mwambu uno wa kudilawila zuwa wa Yolidani.” ");
INSERT INTO kdc_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Avo Musa kawalongela, “Kamba kweli motenda kamba vimulongile, avo baha kuulongozi wa Mndewa Imulungu, muitande kuchola kuna ing'hondo. ");
INSERT INTO kdc_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Kila mkalizi wenu yaloke lwanda lwa Yolidani na kuno molongozwa na Mndewa Imulungu, mowavamila iwanhu owehila mbaka Mndewa Imulungu vonda yawatende wahumwe, ");
INSERT INTO kdc_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","na moisola isi ayo. Mwahatenda gago mobwela kwavija mokuwa musang'hana gaja golondigwa na Mndewa Imulungu kwa ndugu zenu Waizilaeli. Abaho Mndewa Imulungu kowatogolela muisole isi ino ya umwambu wa kudilawila zuwa wa Yolidani. ");
INSERT INTO kdc_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Lakini kamba hamgavikiza gago gamulongile, mokuwa mumtendela Mndewa Imulungu nzambi, na mujuwe kamba mokobozwa. ");
INSERT INTO kdc_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Avo wazengeleni wanenu mabuga na wazengeleni ng'hondolo zenu mabumba, lakini mutende kamba vimulongile!” ");
INSERT INTO kdc_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Abaho wanhu wa makabila ga Gadi na Lubeni wamulongela Musa, “Siye wasang'hanaji wako tosang'hana kamba Mndewa Imulungu viyatulagize. ");
INSERT INTO kdc_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Wehe zetu na wanetu na ng'hondolo na ng'ombe osigala hano mwiisi ya Gileadi. ");
INSERT INTO kdc_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Lakini siye wasang'hanaji wako tuitanda kuchola kuna ing'hondo kuno tolongozwa na Mndewa Imulungu. Toloka ulwanda lwa Yolidani na kuitowa na hewo kamba viulongile.” ");
INSERT INTO kdc_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Abaho Musa kalava malagizo gano kwa imulava nhosa Eleazali na Yoshua mwanage Nuni, na ivilongozi wa ng'holo za makabila ga Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Kamba wanhu wa makabila ga Gadi na Lubeni wahaloka lwanda lwa Yolidani hamoja na mweye kuno wapapa migoha yao na kuno molongozwa na Mndewa Imulungu, mwahawatowa iwanhu awo na kuisola isi ayo, avo muwagwelele isi ya Gileadi iwe yao. ");
INSERT INTO kdc_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Lakini kamba hawaloka hamoja na mweye na migoha yao, avo osola hanhu ha isi ya Kanaani hamoja na mweye.” ");
INSERT INTO kdc_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Iwanhu wa makabila ga Gadi na Lubeni wedika, “Go, mkulu, siye wasang'hanaji wako totenda kamba Mndewa Imulungu viyatulongele. ");
INSERT INTO kdc_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Kwa kulongozwa na Mndewa Imulungu, toloka na migoha yetu mbaka mwiisi ya Kanaani, lakini isi itugweleligwe hano hana umwambu wa kudilawila zuwa wa Yolidani yokuwa yetu.” ");
INSERT INTO kdc_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Avo Musa kawagwelela, iwanhu wa makabila ga Gadi na Lubeni na nusu ya iwanhu wa kabila da Manase mwanage Yusufu, isi yose ya mndewa Sihoni wa Waamoli na isi yose ya mndewa Ogu wa Bashani, mabuga gake na isi zizunguluke gamabuga. ");
INSERT INTO kdc_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Wanhu wa kabila da Gadi wagazenga kabili mabuga ga Diboni na Ataloti na Aloeli, ");
INSERT INTO kdc_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","na Atiloti Shofani na Yazeli na Yogibeha, ");
INSERT INTO kdc_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","na Beti Nimula na Beti Halani, mabuga gago gazunguluswa senyenge na wazenga mabumba ga ng'hondolo. ");
INSERT INTO kdc_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Iwanhu wa kabila da Lubeni wagazenga kabili mabuga ga Heshiboni na Eleale na Kiliataimu, ");
INSERT INTO kdc_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","na Nebo na Baali Meoni na Sibima. Matwaga gamabuga gago wagahindula, wagazenga kabili na wagagwaa matwaga gayagwe. ");
INSERT INTO kdc_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Iwanhu wa ulelo wa Makili mwanage Manase, waivamila isi ya Gileadi waisola isi ayo na wawawinga Waamoli wakalile okala mumo. ");
INSERT INTO kdc_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Avo Musa kawagwelela iwanhu wa ulelo wa Makili mwanage Manase, isi ayo ya Gileadi na hewo wakala mumo. ");
INSERT INTO kdc_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yaili munhu wa kabila da Manase kavivamila vijiji va isi ya Gileadi na kavisola, kavigwaa twaga da Hawoti Yaili. ");
INSERT INTO kdc_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Na heyo Noba kadivamila na kadisola buga da Kenati na ivijiji vake, kadikema Noba, twaga jake mwenyego. ");
INSERT INTO kdc_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Azino azo zing'hambi ziwekile Waizilaeli viwasegele mwiisi ya Misili mna gamabumbila gao kwa kulongozwa na Musa na Haluni. ");
INSERT INTO kdc_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Musa kajandika twaga da kila hanhu kuwekile ing'hambi, kulawa ng'hambi imoja mbaka iyagwe, kwa kulagizwa na Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Waizilaeli wasegela kudibuga da Lamesesi mna isiku ya longo na tano ya mwezi wa ichanduso, siku imoja toka Pasaka. Wasegela kwa kugangamala mgameso gawa Misili wose, ");
INSERT INTO kdc_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","awo wakalile owazika iwana wose wa chaudele wa kimbigalo wakomigwe na Mndewa Imulungu, kwavija vivija Mndewa Imulungu kaikoboza na imilungu yao yose. ");
INSERT INTO kdc_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Avo, Waizilaeli wasegela Lamesesi weka ng'hambi ako Sukoti. ");
INSERT INTO kdc_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Kulawa Sukoti weka ng'hambi yao ako Etamu, mwiingema ya uluwala. ");
INSERT INTO kdc_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Kulawa Etamu wabweleganya mbaka Pi Hahiloti, umwambu wa kudilawila zuwa wa Baali Sefoni, weka ng'hambi yao behi na Migidoli. ");
INSERT INTO kdc_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Kulawa Pi Hahiloti waloka ibahali ya Shamu mbaka kuluwala lwa Etamu, wagendelela na mwanza kwa siku ndatu na weka ng'hambi yao ako Mala. ");
INSERT INTO kdc_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Kulawa Mala wachola mbaka Elimu, ako Elimu kukala na mbwibwi za mazi longo na mbili, na mitende malongo saba, weka ng'hambi yao hanhu aho. ");
INSERT INTO kdc_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Kulawa Elimu weka ng'hambi yao behi na bahali ya Shamu. ");
INSERT INTO kdc_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Kulawa bahali ya Shamu, weka ng'hambi yao kuluwala lwa Sini. ");
INSERT INTO kdc_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Kulawa kuluwala lwa Sini weka ng'hambi yao ako Dofika. ");
INSERT INTO kdc_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Kulawa Dofika weka ng'hambi yao ako Alushi. ");
INSERT INTO kdc_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Kulawa Alushi weka ng'hambi yao ako Lefidimu, kuko kukala kuduhu mazi ga kung'wa. ");
INSERT INTO kdc_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Kulawa Lefidimu weka ng'hambi yao ako kuluwala lwa Sinai. ");
INSERT INTO kdc_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Kulawa kuluwala lwa Sinai weka ng'hambi yao ako Kibiloti Hataava. ");
INSERT INTO kdc_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kulawa Kibiloti Hataava weka ng'hambi yao ako Haseloti. ");
INSERT INTO kdc_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Kulawa Haseloti weka ng'hambi yao ako Litima. ");
INSERT INTO kdc_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Kulawa Litima weka ng'hambi yao ako Limoni Pelesi. ");
INSERT INTO kdc_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Kulawa Limoni Pelesi weka ng'hambi yao ako Libina. ");
INSERT INTO kdc_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Kulawa Libina weka ng'hambi yao ako Lisa. ");
INSERT INTO kdc_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kulawa Lisa weka ng'hambi yao ako Keheleta. ");
INSERT INTO kdc_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kulawa Keheleta weka ng'hambi yao ako kulugongo lwa Shefeli. ");
INSERT INTO kdc_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Kulawa kulugongo lwa Shefeli weka ng'hambi yao ako Halada. ");
INSERT INTO kdc_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Kulawa Halada weka ng'hambi yao ako Makeloti. ");
INSERT INTO kdc_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Kulawa Makeloti weka ng'hambi yao ako Tahati. ");
INSERT INTO kdc_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Kulawa Tahati weka ng'hambi yao ako Tela. ");
INSERT INTO kdc_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Kulawa Tela weka ng'hambi yao ako Mitika. ");
INSERT INTO kdc_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Kulawa Mitika weka ng'hambi yao ako Hashimona. ");
INSERT INTO kdc_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Kulawa Hashimona weka ng'hambi yao ako Moseloti. ");
INSERT INTO kdc_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Kulawa Moseloti weka ng'hambi yao ako Bene Yakani. ");
INSERT INTO kdc_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Kulawa Bene Yakani weka ng'hambi yao ako Holi Hagidigadi. ");
INSERT INTO kdc_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Kulawa Holi Hagidigadi weka ng'hambi yao ako Yotibata. ");
INSERT INTO kdc_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Kulawa Yotibata weka ng'hambi yao ako Abilona. ");
INSERT INTO kdc_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Kulawa Abilona weka ng'hambi yao ako Esioni Gebeli. ");
INSERT INTO kdc_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Kulawa Esioni Gebeli weka ng'hambi yao ako kuluwala lwa Sini vivija kokemigwa Kadeshi. ");
INSERT INTO kdc_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kulawa Kadeshi weka ng'hambi yao ako kulugongo lwa Holi, mna imbaka ya isi ya Edomu. ");
INSERT INTO kdc_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kwa kulagizwa na Mndewa Imulungu, Haluni imulava nhosa kakwela kulugongo lwa Holi na kafila kuko, kuna isiku ya ichanduso ya mwezi wa tano, mwaka wa malongo mane toka Waizilaeli viwasegele mwiisi ya Misili. ");
INSERT INTO kdc_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Haluni viyafile ako kulugongo lwa Holi kakala na miyaka gana dimoja na malongo mabili na ndatu. ");
INSERT INTO kdc_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mndewa wa Aladi, Mkanaani yakalile ako Negebu mwiisi ya Kanaani kapata usenga kamba Waizilaeli wamnzila okwiza. ");
INSERT INTO kdc_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Kulawa kulugongo lwa Holi, Waizilaeli weka ng'hambi yao ako Salimona. ");
INSERT INTO kdc_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Kulawa Salimona weka ng'hambi yao ako Punoni. ");
INSERT INTO kdc_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Kulawa Punoni weka ng'hambi yao ako Oboti. ");
INSERT INTO kdc_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Kulawa Oboti weka ng'hambi yao ako Iye Abalimu kuna imbaka ya Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Kulawa Iye Abalimu weka ng'hambi yao ako Diboni Gadi. ");
INSERT INTO kdc_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Kulawa Diboni Gadi weka ng'hambi yao ako Alimoni Dibilataimu. ");
INSERT INTO kdc_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Kulawa Alimoni Dibilataimu weka ng'hambi yao ako kuvigongo va Abalimu behi na lugongo lwa Nebo. ");
INSERT INTO kdc_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Kulawa kuvigongo va Abalimu wagendelela na mwanza na weka ng'hambi yao ako kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda. ");
INSERT INTO kdc_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Weka ng'hambi yao behi na lwanda lwa Yolidani hagati ya Beti Yeshimoti na Abeli Shitimu ako kudibawe da Moabu. ");
INSERT INTO kdc_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Kulawa kuko kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda, Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Walongele Waizilaeli kamba vonda muloke lwanda lwa Yolidani na kwingila mwiisi ya Kanaani, ");
INSERT INTO kdc_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","wawingeni wenekae wose wa isi ayo. Mugakindule mabwe gao gose na iminyago yao ya zuma na muhabomole kila hanhu hao ha kutambikila. ");
INSERT INTO kdc_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Muisole isi ayo na mukale mumo kwavija niye niwagwelela iwe yenu. ");
INSERT INTO kdc_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Na moigola isi ayo kwa kubwanha simbi kamba iwanhu viweli, isi ing'hulu kwa kabila dili na wanhu wengi na isi indodo kwa kabila dili na wanhu wadodo. ");
INSERT INTO kdc_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Lakini kamba tanhu hamuwawinga iwenekae wa isi ayo, avo awo onda muwaleke okuwa kamba vibanzi mgameso genu hebu kamba miba mzimbavu zenu, na owagaza ng'hani. ");
INSERT INTO kdc_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Kamba hamuwawinga, niye nowatendela mweye kamba vinigelegeze kuwatendela hewo.” ");
INSERT INTO kdc_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Walongele Waizilaeli vino, vonda mwingile mwiisi ya Kanaani, isi iniwagwelele iwe yenu, zimbaka za isi yenu zokuwa kamba vino. ");
INSERT INTO kdc_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Umwambu wa kusini imbaka yenu yokuwa kulawa kuluwala lwa Sini mbaka kuna imbaka ya Edomu. Yosongela mwambu wa kudilawila zuwa wa umwambu wa kusini ako kuihelela ibahali ya Mkele. ");
INSERT INTO kdc_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Abaho imbaka yenu yogendelela kusini kubitila kuna inzila ya Akilabimu na kubitila Sini mbaka Kadeshi Balinea, umwambu wa kusini. Kulawa kuko yobita mwambu wa kasikazini kwa kuchola mwambu wa kudihongela zuwa mbaka Hasali Adali na yobita mbaka ako Azimoni. ");
INSERT INTO kdc_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Kulawa Azimoni yobita kwa kuchola kuna ikizanda cha Misili na yohelela hana ibahali ya Meditelania. ");
INSERT INTO kdc_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Imbaka yenu kwa mwambu wa kudihongela zuwa yokuwa bahali ya Meditelania. ");
INSERT INTO kdc_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Imbaka yenu kwa umwambu wa kasikazini yokuwa kulawa bahali ya Meditelania mbaka kulugongo lwa Holi. ");
INSERT INTO kdc_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Kulawa kulugongo lwa Holi yobitila kuna inzila ichola Hamati, na yogendelela mbaka ako Sedadi, ");
INSERT INTO kdc_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","yobitila ako Zifuloni, na yohelela ako Hasali Enani, ayo iyo imbaka yenu kwa umwambu wa kasikazini. ");
INSERT INTO kdc_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Imbaka yenu kwa umwambu wa kudilawila zuwa yokuwa kulawa Hasali Enani na yobitila ako Shefamu. ");
INSERT INTO kdc_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Kulawa Shefamu yogendelela kubitila Libila, mwambu wa kudilawila zuwa wa Aini, abaho imbaka ayo yobita hasi kuna umwambu wa kudilawila zuwa wa lamba da Kineleti, ");
INSERT INTO kdc_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","abaho yohumulukila kulozela kuna ulwanda lwa Yolidani mbaka kuna ibahali ya Mkele, zino azo zimbaka nne za isi ayo.” ");
INSERT INTO kdc_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Avo, Musa kawalongela Waizilaeli, “Ino ayo isi yonda mwiihazi kwa kubwanha simbi, isi iyalagize Mndewa Imulungu gagweleligwe makabila tisa na nusu. ");
INSERT INTO kdc_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Kabila da Lubeni na kabila da Gadi, na nusu ya kabila da Manase wagweleligwa uhazi wao kamba viweli mzing'holo zao. ");
INSERT INTO kdc_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Makabila gago mabili na nusu wapata uhazi wao ako umwambu wa kudilawila zuwa wa lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda.” ");
INSERT INTO kdc_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Imulava nhosa Eleazali na Yoshua mwanage Nuni awo onda wawagwelele iwanhu isi ayo kamba uhazi wao. ");
INSERT INTO kdc_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Vivija usagule kilongozi imoja kulawa kila kabila ili waitaze kuigola isi ayo. ");
INSERT INTO kdc_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Gano gago matwaga ga awo ivilongozi. Kabila da Yuda kokuwa Kalebu mwanage Yefune. ");
INSERT INTO kdc_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kabila da Simeoni kokuwa Shemueli mwanage Amihudi. ");
INSERT INTO kdc_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Kabila da Benjamini kokuwa Elidadi mwanage Kisiloni. ");
INSERT INTO kdc_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Kabila da Dani kokuwa Buki mwanage Yogili. ");
INSERT INTO kdc_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Kabila da Manase mwanage Yusufu kokuwa Hanieli mwanage Efodi. ");
INSERT INTO kdc_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kabila da Efulaimu mwanage Yusufu kokuwa Kemueli mwanage Shifitani. ");
INSERT INTO kdc_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Kabila da Zabuloni kokuwa Elisafani mwanage Palinaki. ");
INSERT INTO kdc_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Kabila da Isakali kokuwa Palitieli mwanage Azani. ");
INSERT INTO kdc_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Kabila da Asheli kokuwa Ahihudi mwanage Shelomi. ");
INSERT INTO kdc_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Kabila da Nafutali kokuwa Pedaheli mwanage Amihudi.” ");
INSERT INTO kdc_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Wano awo iwanhu walagizwe na Mndewa Imulungu wawagwelele Waizilaeli isi ayo ya Kanaani kamba uhazi wao. ");
INSERT INTO kdc_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Mndewa Imulungu kalonga na Musa kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda, kamulongela, ");
INSERT INTO kdc_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Walongele Waizilaeli kamba kulawa mna uuhazi onda wagweleligwe wawagwee Walawi mabuga ga kukala na hanhu ha kudimila fugo zao kumgwazo wa gago gamabuga. ");
INSERT INTO kdc_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Mabuga gago gokuwa gao, hewo okala mumo na odima ng'ombe na fugo zao ziyagwe. ");
INSERT INTO kdc_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Ihanhu ha kudimila honda muwagwelele awo Walawi ako kumgwazo wa gamabuga kila mwambu kuwe na utali wa magulu magana mane na malongo matano kulawa ako kugamabuga. ");
INSERT INTO kdc_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Avo hanhu hose ha kudimila hokuwa na utali wa magulu magana tisa kila umwambu wa dibuga, na dibuga dokuwa aho hagati ya hanhu aho ha kudimila ako kumgwazo wa dibuga. ");
INSERT INTO kdc_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Muwagwelele Walawi mabuga sita ga kukimbilila, ili kamba munhu kamkoma miyage bila kulonda kodaha kukimbilila kuko. Vivija muwagwelele mabuga gayagwe malongo mane na mbili. ");
INSERT INTO kdc_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Mabuga gose kwa gose gonda muwagwelele Walawi gokuwa malongo mane na nane, muwagwelele mabuga gago hamoja na ihanhu ha kudimila fugo zao. ");
INSERT INTO kdc_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Gamabuga gonda walave Waizilaeli kuwagwelela Walawi iwe kamba iwanhu mdikabila dijo viweli, kamba kabila dina wanhu wengi dilave mabuga mengi na kamba kabila dina wanhu wadodo dilave mabuga kidogo. Kila kabila dilave mabuga gake mbuli ya Walawi kamba isi yao iwagweleligwe viili.” ");
INSERT INTO kdc_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Abaho Mndewa Imulungu kamulongela Musa, ");
INSERT INTO kdc_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Walongele Waizilaeli kamba vonda muloke lwanda lwa Yolidani na kwingila mwiisi ya Kanaani, ");
INSERT INTO kdc_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","musagule mabuga ga kukimbilila, ili kamba munhu kamkoma miyage bila kulonda kodaha kukimbilila mumo. ");
INSERT INTO kdc_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Mabuga gago gokuwa hanhu hanogile ha kukimbilila ili imunhu ayo yamkomile miyage sikuyakomigwe na awo onda wambwezele kwa acho kiyatendile yang'hali hanauzigwa kuulongozi wa umting'hano. ");
INSERT INTO kdc_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Musagule mabuga sita mbuli ya hanhu ha kukimbilila. ");
INSERT INTO kdc_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mna gamabuga gago sita gonda musagule, mabuga madatu gawe umwambu wa kudilawila zuwa wa lwanda lwa Yolidani, na madatu gawe mwiisi ya Kanaani. ");
INSERT INTO kdc_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Mabuga gago gokuwa hanhu ha kukimbilila mbuli ya Waizilaeli na iwanhu baki iwokala na hewo siku zose hebu iwanhu baki iwokala hamoja na hewo kwa siku ndodo. Munhu yoyose yahamkoma miyage bila kulonda kodaha kukimbilila mumo. ");
INSERT INTO kdc_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Lakini kamba munhu kamtowa miyage kwa kinhu cha zuma, na kumkoma, avo munhu ayo kokuwa mkomaji na heyo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Munhu yoyose yahamtowa miyage kwa dibwe, na kumkoma, munhu ayo kokuwa mkomaji na heyo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Munhu yahamtowa miyage kwa biki na kumkoma, munhu ayo kokuwa mkomaji na heyo yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ndugu wa imunhu ayo yakomigwe yambwezele, na yamkome mkomaji ayo vonda yaiting'hane na heyo. ");
INSERT INTO kdc_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Vivija kamba munhu komwihila miyage abaho komsung'ha hebu komtupila kinhu, ");
INSERT INTO kdc_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","hebu komtowa ng'honde na kumkoma, avo imunhu ayo yamtowile miyage na kumkoma na heyo yakomigwe. Ndugu wa imunhu ayo yakomigwe na heyo yambwezele kwa kumkoma yahamting'hana. ");
INSERT INTO kdc_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Lakini kamba munhu komsung'ha miyage bila kulonda hebu komtupila kinhu bila ugomvi wowose, ");
INSERT INTO kdc_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hebu munhu yahapigisa dibwe na kumkoma munhu bila kulonda, na kuno hagombile na imunhu ayo yamkomile, ");
INSERT INTO kdc_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","avo umting'hano wose waigelegeze mbuli ayo, mbuli ya ayo yamkomile miyage na ndugu yake imunhu yakomigwe yolonda kumbwezela ayo imkomaji, kamba malagizo gano vigali. ");
INSERT INTO kdc_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Awo umting'hano umsegese ayo imunhu yakomile mmakono ga ndugu yake ayo yakomigwe, na wambweze kudibuga da kukimbilila kuko kuyakimbilile. Yakale kuko mbaka vonda yafe imulava nhosa mkulu yasaguligwe kwa kugidiligwa mavuta. ");
INSERT INTO kdc_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Lakini munhu ayo yakomile yahalawa kunze ya dibuga da kukimbilila, ");
INSERT INTO kdc_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","abaho ndugu yake imunhu yakomigwe kamgoga ako kunze ya dibuga da kukimbilila na kumkoma, avo ayo kokuwa hatendile dihile kwa kumkoma munhu ayo. ");
INSERT INTO kdc_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Kwavija imunhu ayo yamkomile miyage kolondigwa yakale mumo kudibuga da kukimbilila mbaka vonda yafe imulava nhosa mkulu, lakini yahafa ayo imulava nhosa mkulu kodaha kubwela ukae kumwake. ");
INSERT INTO kdc_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“Malagizo gano gawe kwa ulelo wenu wose, hanhu hohose honda mukale. ");
INSERT INTO kdc_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Munhu yoyose yonda yamkome miyage, yatagusigwe ifa kwa usindila wa wanhu wabili na kugendelela onile kija kitendigwe. Munhu yoyose sikuyatagusigwe ifa kwa usindila wa munhu imoja. ");
INSERT INTO kdc_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“Sikumubokele malipo gogose ili kumuhonya munhu mkomaji, mkomaji yoyose yahatagusigwa ifa, kolondigwa yakomigwe. ");
INSERT INTO kdc_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Sikumubokele malipo gogose kulawa kwa munhu yakimbilile kudibuga da kukimbilila ili kumtenda yabwele ukae kumwake yang'hali hanakufa imulava nhosa mkulu. ");
INSERT INTO kdc_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Mwahatenda vivo moifitiza isi yenu imukala, kwavija ukomaji oifitiza isi, na kuduhu nhosa yonda ilavigwe ili kuitenda ing'ale, isi ikomeligwe munhu ila kwa kumkoma imunhu yamkomile miyage. ");
INSERT INTO kdc_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Sikumuifitize isi imukala, isi ayo inikala niye vivija, kwavija niye Mndewa Imulungu nokala hagati yenu mweye Waizilaeli.” ");
INSERT INTO kdc_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Abaho vilongozi wa lukolo lwa Gileadi mwanage Makili na Makili mwanage Manase na Manase mwanage Yusufu wachola kulonga na Musa na vilongozi wayagwe wa ng'holo za Waizilaeli. ");
INSERT INTO kdc_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Walonga, “Go mkulu, Mndewa Imulungu kakulagiza uwagwelele isi ayo wanhu wa Izilaeli kamba uhazi wao kwa kubwanha simbi, vivija kakulagiza uwagwelele wandele wa ndugu yetu Selofehadi uhazi wa tatao. ");
INSERT INTO kdc_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Lakini hewo wahasoligwa na Waizilaeli wa makabila gayagwe, uhazi wao osegela kumwetu na ochola kwa iwanhu wa gamakabila gonda wasoligwe, avo uhazi wetu siye ohunguka. ");
INSERT INTO kdc_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Mna inyimwilinyimwili ya kulekeswa, uhazi awo opetigwa hamoja na uja wa kabila donda wasoligwe, avo kabila jetu honda dipate uhazi awo kabili.” ");
INSERT INTO kdc_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Avo Musa kawagwaa Waizilaeli lagizo dino kulawa kwa Mndewa Imulungu, kawalongela “Wanhu wa kabila da ulelo wa Yusufu walonga goya. ");
INSERT INTO kdc_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Avo vino vivo viyalagize Mndewa Imulungu mbuli ya wandele wa Selofehadi, odaha kusoligwa na wambigalo wowose owalonda, lakini wambigalo awo walawe mdikabila jao, ");
INSERT INTO kdc_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ili uhazi wa Waizilaeli sikuuhamizwe kulawa kabila dimoja kuchola diyagwe, kila Mwiizilaeli yaulole uhazi wa kabila jake. ");
INSERT INTO kdc_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mtwanzi yoyose yeli na uhazi mna gamakabila ga Waizilaeli, kolondigwa yasoligwe na munhu wa kabila jake, ili kila Mwiizilaeli yasole uhazi wa iwahenga zake. ");
INSERT INTO kdc_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Avo kokuwa kuduhu uhazi onda uhamizwe kulawa kabila dimoja kuchola diyagwe. Kila kabila da iwanhu wa Izilaeli digoge uhazi wake.” ");
INSERT INTO kdc_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Avo awo iwandele wa Selofehadi watenda kamba Mndewa Imulungu viyamulagize Musa. ");
INSERT INTO kdc_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Avo Mala na Tiliza na Hogila na Milika na Nuhu, awo iwandele wa Selofehadi wasoligwa na ndugu zao waubanzi wa tatao. ");
INSERT INTO kdc_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Wasoligwa mzing'holo za kabila da Manase, mwanage Yusufu, na uhazi wao usigala mdikabila da tatao. ");
INSERT INTO kdc_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Gano gago malagizo ga Mndewa Imulungu gayawagwelele Waizilaeli kubitila Musa ako kudibawe da Moabu, behi na lwanda lwa Yolidani uilola na buga da Yeliko dikalile umwambu wa ulwanda.");
INSERT INTO kdc_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Kitabu kino kina mbuli ziyalongile Musa kwa wanhu wose wa Izilaeli kuko kuluwala mwambu wa kudilawila zuwa wa lwanda lwa Yolidani. Wakala kubonde da Yolidani behi na Sufu, mwambu umoja wa buga da Palani, na mwambu uyagwe wa mabuga ga Tofeli na Labani na Haseloti na Dizahabu. ");
INSERT INTO kdc_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Kulawa kulugongo lwa Holebu mbaka Kadeshi Balinea ugenzi wa siku longo na imoja kwa nzila ya kulugongo lwa Seili. ");
INSERT INTO kdc_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Siku ya ichanduso ya mwezi wa longo na moja, mwaka wa malongo mane, toka Waizilaeli viwasegele Misili, Musa kawalongela wanhu kila kinhu kiyamulagize Mndewa Imulungu yawalongele. ");
INSERT INTO kdc_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Katenda vivo, kipindi Mndewa Imulungu viyamuhumile mndewa Sihoni wa Heshiboni na mndewa Ogu wa Bashani yakalile mmabuga ga Ashitaloti na Edilei. ");
INSERT INTO kdc_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ako kuna umwambu uyagwe wa lwanda lwa Yolidani mwiisi ya Moabu, Musa kasonga kuwalongela iwanhu malagizo ga Mndewa Imulungu. Kalonga, ");
INSERT INTO kdc_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Mndewa Imulungu, Imulungu wetu katulongela vino vitukalile ako kulugongo lwa Holebu, kalonga, ‘Mukala kipindi kitali kulugongo luno, ");
INSERT INTO kdc_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","sambi tuleni ng'hambi yenu mugendelele na mwanza. Gendeni kuna ivigongo va isi ya Waamoli na isi ili behi ako Alaba, kuvigongo na kubonde ako Negebu na mwhani. Mugende mbaka mwiisi ya Kanaani na isi ya Lebanoni mbaka ako kuna ulwanda mkulu wa Fulate. ");
INSERT INTO kdc_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Isi yose ayo niwagwaa mweye, avo gendeni mukaisole isi ayo, niye Mndewa Imulungu niiduwila kwa wahenga zenu, Abulahamu na Isaka na Yakobo na ulelo wao.’ ” ");
INSERT INTO kdc_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Musa kawalongela iwanhu, “Vitukalile tung'hali ako kulugongo lwa Holebu, niye niwalongela vino, ‘Mweye mwa wengi ng'hani, niye sidaha bule kuwalongoza niiyeka. ");
INSERT INTO kdc_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Mndewa Imulungu, Imulungu wenu kawatenda muwe wengi, sambi mwa wengi kamba nhondo za kuulanga. ");
INSERT INTO kdc_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Mndewa Imulungu, Imulungu wa wahenga zenu, yawengeze miyanza elufu imoja ng'hani kubanza vimwili sambi, na yawatende mumwede kamba viyalongile kotenda. ");
INSERT INTO kdc_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Lakini niye niiyeka sidaha bule kuwalongoza na kuwagombeleza mwahagomba. ");
INSERT INTO kdc_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Saguleni wanhu kulawa kila kabila, wanhu weli na nzewele na wabala na otegelezigwa ili niwatende wawe vilongozi wenu.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Mweye mutogola na munidika vino, ‘Gago gaulongile ganoga.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Avo niwasola awo ivilongozi weli na nzewele, awo wamuwasagule kulawa mna gamakabila genu, niwatenda wawe vilongozi wenu. Wayagwe niwatenda wawalongoze vibumbila va iwanhu elufu na iwanhu magana na iwanhu malongo matano na iwanhu longo. Vivija niwasagula wayagwe wawe iwakulu wa kila kabila. ");
INSERT INTO kdc_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“Kipindi acho niwagwaa iwasemi wenu malagizo gano, ‘Tegelezeni goya vitala va wanhu wenu. Taguseni goya vitala va wanhu wenu, iwe iwenekae hebu iwanhu baki iwokala hamoja na mweye. ");
INSERT INTO kdc_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Sikumumbagule munhu vonda muwataguse iwanhu, wategelezeni bila kuwabagula iwakulu na iwadodo. Sikumumdumbe munhu yoyose, kwavija Imulungu ayo yotagusa. Kitala chochose kidala ngalileni niye na niye nokitegeleza.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Kipindi acho vivija niwalongela gose gomulondigwa kutenda. ");
INSERT INTO kdc_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Avo kamba Mndewa Imulungu, Imulungu wetu viyatulagize, tusonga mwanza wetu kulawa kulugongo lwa Holebu, tubita ako kuluwala lugela bwembwe, tugoga inzila ichola kuna iisi ya kuvigongo va Waamoli. Vituvikile Kadeshi Balinea, ");
INSERT INTO kdc_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","niye niwalongela, ‘Sambi muvika kuvigongo va isi ya Waamoli, iyotugwaa Mndewa Imulungu, Imulungu wetu. ");
INSERT INTO kdc_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Loleni, Mndewa Imulungu, Imulungu wenu kawagwaa mweye isi ino. Avo ingileni mukaisole kamba Mndewa Imulungu, Imulungu wa wahenga zenu viyawalongele. Sikumudumbe hebu kunyawanyawa!’ ");
INSERT INTO kdc_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“Abaho mweye mose mwiza kumwangu munongela, ‘Tuleke tutume wanhu wakaisungulile isi ayo abaho wabwele watulongele nzila inogile kubita na mabuga ga kuko vigali.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Mbuli ayo inogela, avo niwasagula wanhu longo na wabili, munhu imoja kulawa kila kabila. ");
INSERT INTO kdc_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Wanhu awo wasegela, wachola mwiisi ayo ya kuvigongo, wavika kubonde da Eshikoli na wadisungulila. ");
INSERT INTO kdc_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Viwabwelile, wapapa matunda ga isi ayo na watulongela isi ayo iyotugwaa Mndewa Imulungu, Imulungu wetu inoga. ");
INSERT INTO kdc_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Lakini mweye hamulondile kugoga lagizo da Mndewa Imulungu, Imulungu wenu, mulema kuchola mwiisi ayo. ");
INSERT INTO kdc_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Muiyalala mvibanda venu mulonga, ‘Mndewa Imulungu katwihila, lekaavo katulava mwiisi ya Misili. Kalonda kutugela mmakono ga Waamoli ili watukome. ");
INSERT INTO kdc_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Avo tuchole kwahi? Ndugu zetu watubena nguvu, watulongela, “Wanhu awo wana nguvu na watali kubanza siye, mabuga gao makulu, wagazungulusila senyenge mbaka kuulanga. Vivija tuyona mizinhu mikulu, awo iwanhu wa ulelo wa Waanaki!” ’ ");
INSERT INTO kdc_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Lakini niye niwalongela vino, ‘Sikumunyawenyawe na sikumuwadumbe wanhu awo. ");
INSERT INTO kdc_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Mndewa Imulungu, Imulungu wenu, ayo yowalongolela, heyo mwenyego koitowa na hewo mbuli yenu kamba viyatendile kuno molola ako Misili, ");
INSERT INTO kdc_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","na kuja kuluwala. Mona Mndewa Imulungu, Imulungu wenu viyawapapile kamba tata viyompapa mwanage, mnzila yose mbaka muvika hanhu hano.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Hamoja niwalongela vivo, hamumtamanile Mndewa Imulungu, Imulungu wenu, ");
INSERT INTO kdc_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","yawalongolele mmwanza wenu, ikilo kwa mhanda ya moto na imisi kwa wingu, kawazahilila hanhu ha kwika ng'hambi na kawalagusila inzila ya kubita. ");
INSERT INTO kdc_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Mndewa Imulungu viyahulike kuiyalala kwenu, kagevuzika na kaiduwila kalonga, ");
INSERT INTO kdc_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Kuduhu hata munhu imoja kulawa muulelo uno wa iwanhu otenda gehile yonda yengile mwiisi ayo inogile iniiduwile nowagwaa wahenga zenu, ");
INSERT INTO kdc_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ila Kalebu mwanage Yefune yaiyeka ayo yonda yengile, na niye nomgwaa isi ayo iyaikanyage kwa magulu gake, iwe yake na ulelo wake kwavija kanikweleleza niye Mndewa Imulungu kwa moyo wake wose.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Vivija Mndewa Imulungu kanigevuzikila niye mbuli yenu mweye, kalonga, ‘Vivija na gweye Musa, honda wingile bule mwiisi ayo. ");
INSERT INTO kdc_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Lakini ayo yokutaza, Yoshua mwanage Nuni kokwingila, avo umgele moyo, kwavija heyo ayo yonda yawalongoze wanhu wa Izilaeli waihazi isi ayo.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","“Abaho Mndewa Imulungu katulongela siye wose, ‘Awo iwana omulonga osoligwa na iwanhu owehila mweye, awo iwana wenu ving'hele walekile kujuwa ganogile na gehile, okwingila mwiisi ayo. Niye nowagwaa na hewo yokuwa isi yao. ");
INSERT INTO kdc_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Lakini mweye, hindukeni mubwele kuluwala kubitila nzila ya kuchola bahali ya Shamu.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Avo, mweye munidika, ‘Tumtenda nzambi Mndewa Imulungu. Avo, tochola na kuitowa na hewo kamba Mndewa Imulungu, Imulungu wetu viyatulagize.’ Avo kila imoja wenu keka mgoha wake mdiega, mwagiza vibuha kuchola kuivamila isi ayo ya kuvigongo. ");
INSERT INTO kdc_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Lakini Mndewa Imulungu kanongela, ‘Walongele wanhu awo, sikuwachole kuitowa kwavija niye niwaleka, sikuwachole buleavo ohumwa na iwanhu owehila.’ ");
INSERT INTO kdc_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Avo niye niwalongela, lakini hamutegeleze bule na mudilema lagizo da Mndewa Imulungu na kwa kuitapa kwenu mukwela kuvigongo avo. ");
INSERT INTO kdc_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Waamoli okala kuvigongo avo wahumuluka wawavamila na kuwaswaswanya kamba nyuki, wawatowa ako Seili mbaka Holima. ");
INSERT INTO kdc_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Mubwela na mmulilila Mndewa Imulungu, lakini Mndewa Imulungu hawategeleze bule hebu kuwagelegeza. ");
INSERT INTO kdc_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Avo, musigala ako Kadeshi siku heleketwaa, mukala kuko. ");
INSERT INTO kdc_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Abaho tuhinduka tufunga mwanza wa kuchola kuluwala kubitila nzila ya bahali ya Shamu, kamba Mndewa Imulungu viyanongele. Kwa siku nyingi tung'hali tuzunguluka mnzila kuvigongo va isi ya Seili. ");
INSERT INTO kdc_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“Abaho Mndewa Imulungu kanongela, ");
INSERT INTO kdc_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Mwanga hano kuvigongo kwa siku nyingi, avo sambi hindukeni umwambu wa kasikazini. ");
INSERT INTO kdc_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Walagize iwanhu, “Sambi mobitila mwiisi ya kuvigongo va Seili, isi ya ndugu zenu wanhu wa ulelo wa Esau. Hewo owadumba mweye, lakini muiteganye, ");
INSERT INTO kdc_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","sikumuitowe na hewo kwavija siwagwaa bule hanhu hohose ha isi yao. Siwagwaa hata hanhu hadodo hakukanyaga lwayo. Isi ayo ya kuvigongo va Seili niwagwaa wanhu wa ulelo wa Esau iwe yao. ");
INSERT INTO kdc_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Mugule ndiya yonda muje na mazi gonda mung'we.” ’ ");
INSERT INTO kdc_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“Mndewa Imulungu, Imulungu wenu kawatenda mumwede mna zisang'hano zenu zose za makono genu. Kawalola goya mmwanza wenu wose wa kukiwala kino kikulu. Miyaka yose ayo malongo mane Mndewa Imulungu, Imulungu wenu, kakala hamoja na mweye na hamuswelile kinhu chochose. ");
INSERT INTO kdc_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Avo tugendelela na mwanza wetu tuwabita ndugu zetu, awo iwanhu wa ulelo wa Esau wakalile ako Seili, tuileka nzila ya kubitila Alaba, ilawa Elati na Esioni Gebeli na tubitila nzila ya kuluwala lwa Moabu. ");
INSERT INTO kdc_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Abaho Mndewa Imulungu kanongela, ‘Sikumuwagaze wanhu wa Moabu hebu kuwadovula ili muitowe, kwavija siwagwaa bule isi ayo. Niye niwagwaa isi ayo ya Ali iwanhu wa ulelo wa Lutu kamba uhazi wao.’” ");
INSERT INTO kdc_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Umwaka isi ayo ya Ali wakala wanhu wengi ng'hani wakalile na nguvu wakemigwe Waemi na wakala watali kamba Waanaki. ");
INSERT INTO kdc_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Kamba viweli Waanaki, wanhu awo wakemigwa Walefai, lakini wanhu wa Moabu wawakema Waemi. ");
INSERT INTO kdc_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Vivija ako umwaka Waholi wakala okala ako Seili, lakini wanhu wa ulelo wa Esau wawawinga na wawakoma, abaho hewo wakala mwiisi ayo kamba vija wanhu wa Izilaeli viwatendile ako kuna iisi iyawagwelele Mndewa Imulungu. ");
INSERT INTO kdc_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Mndewa Imulungu katulongela, ‘Segeleni muloke bonde da Zeledi.’ Avo tuloka bonde da Zeledi. ");
INSERT INTO kdc_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ibita miyaka malongo madatu na nane tangu vitusegele Kadeshi Balinea mbaka vitulokile bonde da Zeledi. Kipindi acho iwanhu wose wadahile kuitowa kuna ing'hondo wafa, kamba Mndewa Imulungu viyaiduwile wofa. ");
INSERT INTO kdc_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Mndewa Imulungu mwenyego kagendelela kuwakoboza ako kuna ing'hambi mbaka wose wafa. ");
INSERT INTO kdc_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Avo viwafile wanhu awo wadahile kuchola kuitowa kuna ing'hondo, ");
INSERT INTO kdc_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Mndewa Imulungu kanongela, ");
INSERT INTO kdc_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Lelo moiloka imbaka ya isi ya Moabu kubitila buga da Ali. ");
INSERT INTO kdc_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Mwahavika mwiisi ya Waamoni sikumuwagaze hebu kuwadovula ili kuitowa na hewo kwavija niye siwagwaa bule mweye isi ayo ya Waamoni. Niye niwagwaa isi ayo wanhu wa ulelo wa Lutu.’ ” ");
INSERT INTO kdc_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Vivija isi ayo yojuwigwa kamba isi ya Walefai, ako umwaka Walefai wakala mwiisi ayo. Lakini Waamoni wawagwaa twaga da Wazamuzumi. ");
INSERT INTO kdc_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Wanhu awo wakala wengi na wakala na nguvu na wata