﻿USE sofia;
DROP TABLE IF EXISTS sofia.kdc2014_vpl;
CREATE TABLE kdc2014_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kdc2014_vpl WRITE;
INSERT INTO kdc2014_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitabu cha lukolo lwa Yesu Kilisito mzukulu wa Daudi, mzukulu wa Abulahamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahamu kamulela Isaka, Isaka kamulela Yakobo, Yakobo kamulela Yuda na ndugu zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kamulela Pelesi na Zela, mamao kakala Tamali, Pelesi kamulela Heziloni, Heziloni kamulela Alamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu kamulela Aminadabu, Aminadabu kamulela Nashoni, Nashoni kamulela Salimoni, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni kamulela Boazi, mamake Boazi kakala Lahabu, Boazi kamulela Obedi, mamake Obedi kakala Lusi, Obedi kamulela Yese, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kamulela Mndewa Daudi. Daudi kamulela Sulemani, mamake Sulemani kakala mwehe wa Ulia. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani kamulela Lehoboamu, Lehoboamu kamulela Abiya, Abiya kamulela Asa, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kamulela Yehoshafati, Yehoshafati kamulela Yolamu, Yolamu kamulela Uzia, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia kamulela Yotamu, Yotamu kamulela Ahazi, Ahazi kamulela Hezekia, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia kamulela Manase, Manase kamulela Amoni, Amoni kamulela Yosia, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia kamulela Yekonia na ndugu zake, kipindi kija Wayahudi viwahamizigwe kugaligwa Babeli. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Viubitile uhamizo wa Babeli, Yekonia kamulela Shealitieli, Shealitieli kamulela Zelubabeli, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli kamulela Abiudi, Abiudi kamulela Eliakimu, Eliakimu kamulela Azoli, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli kamulela Sadoki, Sadoki kamulela Akimu, Akimu kamulela Eliudi, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi kamulela Eliazali, Eliazali kamulela Matani, Matani kamulela Yakobo, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo kamulela Yusufu, mbigalo wake Malia, yamulelile Yesu yokemigwa Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Avo kukala na ng'holo longo na nne kulawa Abulahamu mbaka Daudi, na ng'holo longo na nne kulawa Daudi mbaka Wayahudi viwahamizigwe Babeli na ng'holo longo na nne toka viwahamizigwe Babeli mbaka kuleleka kwa Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kuvumbuka kwa Yesu Kilisito kukala vino, Malia yafungiligwe zengele na Yusufu, lakini wang'hali hawanakala hamoja kamba mbigalo na mtwanzi, Malia koneka kana inda kwa udahi wa Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwavija Yusufu kakala munhu yotenda ganogile, halondile kumgela kinyala Malia, avo kalonda kumuleka kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Viyakalile kogelegeza vivo, msenga wa kuulanga wa Mndewa kamulawilila mzinzozi na kamulongela, “Yusufu mzukulu wa Daudi, sekeudumbe kumsola Malia yawe mwehe wako, kwavija inda yake kaipata kwa udahi wa Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kolela mwana wa kimbigalo na gweye komgwaa twaga da Yesu, kwavija kowakombola wanhu zake mzinzambi zao.” ");
INSERT INTO kdc2014_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gano gose gatendeka kutenda galongigwe na Mndewa kubitila mtula ndagu wake galawilile, ");
INSERT INTO kdc2014_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mhambe kogoga inda, na kolela mwana wa kimbigalo, nao womkema Imanueli,” fambulo jake, “Mulungu kahamoja na tweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Avo Yusufu viyalamuke muutulo, kamsola Malia kamba viyalongeligwe na imsenga wa Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lakini hatembele nayo mbaka viyalelile mwana na Yusufu kamgwaa twaga mwana ayo Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kavumbuka kudibuga da Beselehemu mwiisi ya Yudea, kipindi Helode viyakalile Mndewa. Aho viyavumbuke wanhu wayagwe wajuwile mbuli za nhondo weza kulawa mwambu wa kudilawila zuwa wavika Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wauza, “Kakwahi imwana yavumbuke yawe Mndewa wa Wayahudi? Kwavija tuyona nhondo yake kulawa mwambu wa kudilawila zuwa na tweye twiza kumfugamila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mndewa Helode viyahulike vivo kanyawanyawa ng'hani na vivija kila munhu yakalile Yelusalemu kanyawanyawa. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kawakema hamoja wakulu wa walava nhosa na wafundiza Malagizo ga Musa kawauza, “Vino Kilisito Mkombola kovumbukila kwahi?” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wamwidika, “Kovumbukila kudibuga da Beselehemu mwiisi ya Yudea, vivo yandike mtula ndagu wa Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mweye wanhu wa Beselehemu mwiisi ya Yudea, buga jenu hadili dodo bule mna gamabuga ga Yuda, kwavija kumwenu kolawa mulangulizi yonda yawalongoze wanhu zangu wa Izilaeli.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Avo Helode kawakema kinyelegezi wanhu waja wojuwa mbuli za nhondo kawauza kipindi gani nhondo viyoneke. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Abaho kawatuma wachole Beselehemu na kuwalagiza, “Choleni mkazahile goya kuyali imwana, mwahamona nongeleni, nanie vivija nichole nikamfugamile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Viwamalile kumtegeleza, walawanya, mnzila wayona nhondo iija iwayone mwambu wa kudilawila zuwa, iwalongolela na kwima hanhu aho kuyavumbuke imwana. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Viwayone inhondo, wadeng'helela ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Avo wengila mng'anda, wamona imwana na Malia mamake, wamfugamila na kumtambikila. Abaho wamgwaa nhunza za zahabu, mavumba na mavuta ga bei ng'hulu gokemigwa manemane. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Abaho wabwela ukayao kwa kubitila nzila iyagwe, kwavija Mulungu kawazuma mzinzozi sekewabwele kwa Helode. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Viwasegele msenga wa Mndewa kamulawilila Yusufu mzinzozi kamulongela, “Helode komzahila imwana yamkome. Avo lamuka umsole imwana na mamake mkimbilile Misili, na mukale kuko mbaka vonda nikulongele usegele.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufu kalamuka, kamsola imwana na mamake kasegela ikilo acho na kuchola Misili, ");
INSERT INTO kdc2014_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","kakala ako mbaka Helode viyafile. Gano gatendigwa kutenda acho kiyalongile Mndewa kubitila mtula ndagu kilawilile, “Nimkema mwanangu kulawa Misili.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode viyajuwile kamba wanhu wacholile kumulola Yesu kulawa mwambu wa kudilawila zuwa wamvizila, kagevuzika ng'hani. Kalava lagizo da kuwakoma wana wose wa kimbigalo weli Beselehemu na hiwo weli behi, kusongela wana ving'hele mbaka wana weli na miyaka mibili ino itendigwa kamba viyajuwile kulawa kwa wanhu wacholile kumulola Yesu mna ikipindi viwayone inhondo. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kwa mbuli ino kilawilila kija kiyalongile Yelemia yakalile mtula ndagu wa Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sauti ihulikigwa mwiisi ya Lama, kulila na kuiyalala ng'hani. Laheli kowalilila wanage nayo kolema kuhozigwa, kwavija wafa.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helode viyafile, msenga wa Mndewa kamulawilila Yusufu mzinzozi mwiisi ya Misili, ");
INSERT INTO kdc2014_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kamulongela, “Lamuka umsole imwana na mamake, na ubweleganye mna iisi ya Izilaeli, kwavija wose walondile kumkoma imwana wafa.” ");
INSERT INTO kdc2014_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Avo Yusufu kalamuka, kamsola imwana na mamake na kabweleganya mwiisi ya Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini Yusufu viyahulike Alikelao mwanage Helode, kahala Undewa wa tatake ako Yudea, kadumba kuchola kuko, kwavija kazumigwa ng'hani mzinzozi. Avo kachola mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kahamila kudibuga da Nazaleti keka ukazi wake kuko. Avo kilawilile kija kiwalongile watula ndagu wa Mulungu, “Kokemigwa Mnazaleti.” ");
INSERT INTO kdc2014_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mna izisiku azo Yohana Mbatizaji keza kuluwala lwa Yudea, kasonga kuwapetela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kawalongela, “Lekeni nzambi zenu kwavija Undewa wa kuulanga wammabehi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ayo Yohana, ayo munhu yalongigwe na mtula ndagu wa Mulungu Isaya, “Munhu imoja kokema kuluwala, ‘Itandeni nzila ya Mndewa, goloseni nzila yake yonda yabite!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kiwalo cha Yohana kitendigwa kwa mibahila ya ngamiya, na kavala mkwiji wa ng'hwembe mkigudi chake. Lujo lwake lukala nzige na uki. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wanhu wamcholela kulawa Yelusalemu, na isi yose ya Yudea na kulawa isi zose zilihabehi na lwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Watogola hewo watenda nzambi na Yohana kawabatiza muulwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana viyawone Mafalisayo na Masadukayo wengi womwizila yawabatize, kawalongela, “Mweye mizoka nani yawalongele modaha kuikimbila nhaguso yonda igaligwe na Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Musang'hane gaja gonda galaguse muzileka nzambi zenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sekemugese kwa kulonga kamba Abulahamu heyo muhenga wetu. Nowalongela Mulungu kodaha kugasola mabwe gano na kugatenda lukolo lwa Abulahamu! ");
INSERT INTO kdc2014_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Shoka ikigwa goya kukanha mibiki mna gamasina. Kila mbiki uleka kulela matunda ganogile wokanhigwa na kwasigwa muumoto. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Niye nowabatiza mweye kwa mazi kulagusa muzileka nzambi zenu. Lakini yonda yeze kukisogo changu kowabatiza kwa Loho Yang'alile na kwa moto, heyo ni munhu mkulu kubanza nene, niye sifaya hata kupapa vilatu vake. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ayo kana lungo lwa kubetela uhule mmakono gake. Nayo kousola uhemba wake na kuwika kudikanho, lakini koisoma imikumvi muumoto haufaga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mna izisiku azo Yesu kasegela kulawa Galilaya kachola kuna ulwanda lwa Yolidani yakabatizigwe na Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohana kalonda kumgomesa Yesu, kalonga, “Niye nolondeka nibatizigwe na gweye, habali wiza kumwangu?” ");
INSERT INTO kdc2014_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu kamwidika, “Leka sambi iwe vivo kwavija kwakutenda vivo togatenda gaja gose golondigwa na Mulungu.” Avo Yohana katogola. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bahaja Yesu viyabatizigwe, kalawa mgamazi, ulanga ugubuka, na kamona Loho wa Mulungu kohumuluka kamba huwa na kakala uchanha yake. ");
INSERT INTO kdc2014_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Abaho sauti ihulikigwa kulawa kuulanga ilonga, “Ino heyo mwanangu nimnogele, ninogezigwa nayo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Abaho Loho Yang'alile kamulongoza Yesu yachole kuluwala yakagezigwe na Mwenembago. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kakala kuko siku malongo mane imisi na ikilo bila kuja. Viyamambukize siku azo, Yesu kona nzala. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Abaho Mwenembago kamcholela kamulongela, “Kamba gweye kwa Mwana wa Mulungu kweli galagize mabwe gano gagaluke magate.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lakini Yesu kamwidika, “Maandiko Gang'alile golonga, ‘Munhu hawa mgima kwa kuja kwiiyeka, lakini kwa kila mbuli yoolonga Mulungu.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Abaho Mwenembago kamsola Yesu mbaka Yelusalemu buga ding'alile, kamwika mna ikiswili cha Ing'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Abaho kamulongela Yesu, “Kamba kweli gweye kwa Mwana wa Mulungu, ilagaze mwenyego hasi, kwavija Maandiko Gang'alile golonga, ‘Mulungu kowalagiza wasenga zake wa kuulanga mbuli ya gweye, nao wokusola mmakono gao, sekeuilumize magulu gako mgamabwe.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kamwidika, “Vivija Maandiko Gang'alile golonga, ‘Sekeumgeze Mndewa Mulungu wako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Abaho Mwenembago kamsola Yesu mbaka uchanha ng'hani kuna ulugongo lutali na kamulagusila undewa wa mwiisi yose na unovu wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mwenembago kamulongela, “Vino vose nokugwaa, kamba wahanifugamila na kunitambikila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu kamulongela, “Segela kumwangu Mwenembago! Kwavija Maandiko Gang'alile golonga, ‘Mtambikile Mndewa Mulungu wako, na umsang'hanile heyo yaiyeka!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Baho Mwenembago kamuleka Yesu, na wasenga wa kuulanga weza wamsang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu viyahulike Yohana Mbatizaji kagodekigwa kukifungo, kachola isi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hakalile Nazaleti lakini kachola kukala Kapelinaumu kudibuga dili behi na lamba da Galilaya, kuzimbaka za isi ya Zabuloni na Nafutali. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mbuli ino ilawilila kamba vija viyalongile mtula ndagu wa Mulungu Isaya, ");
INSERT INTO kdc2014_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Zabuloni na isi ya Nafutali nzila ya kucholela mbahali, umwambu uyagwe wa lwanda lwa Yolidani Galilaya, isi ya wanhu haweli Wayahudi! ");
INSERT INTO kdc2014_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wanhu wakalile mdiziza wawona mulenge wa ukombozi wa Mulungu Waja wose wokala mwiisi ya sisila da ifa mulenge uwamwemwesela.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kulawa kipindi acho Yesu kasonga kuwapetela usenga wake, “Lekeni nzambi zenu, kwavija Undewa wa kuulanga wammabehi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu viyakalile kobita kumgwazo wa lamba da Galilaya, kawavika munhu na mkulu wake wovuwa somba. Wakala Simoni yakemigwe Petulo na mdodo wake Andeleya, wakala wovuwa somba mna dilamba na mizavu yao. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kawalongela, “Nikwelelezeni na niye nowatenda muwe wavuwaji wa wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahaja waileka mizavu yao, wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kagenda kumwande kawavika wandugu wabili wayagwe. Yakobo na Yohana wanage Zebedayo. Wakala mwiingalawa hamoja na tatao Zebedayo woitanda mizavu yao. Yesu kawakema, ");
INSERT INTO kdc2014_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","bahaja waileka ngalawa na tatao, na wamkweleleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kachola mwiisi yose ya Galilaya, kafundiza mzing'anda za kumpula Mulungu na kawapetela wanhu Mbuli Inogile ya Undewa wa Mulungu na baho kawahonya wanhu wakalile na mitamu na magayo gose. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbuli zake zenela mwiisi yose ya Siliya, avo wanhu wamgalila wanhu wose wakalile watamu, waja wodununzika na kila utamu, weli na vinyamkela, na visango na waja waholole na Yesu kawahonya wose. ");
INSERT INTO kdc2014_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wanhu wengi wamkweleleza Yesu kulawa Galilaya na Dekapoli, kulawa Yelusalemu na Yudea na isi ya mwambu uyagwe wa lwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu viyaluwone lunhu lwa wanhu, kakwela kulugongo, kakala hasi. Wanahina zake wamcholela, ");
INSERT INTO kdc2014_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nayo kasonga kuwafundiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wamweda wanhu waja womtamanila Mulungu yaiyeka, kwavija Undewa wa kuulanga uli wao! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wamweda wanhu waja wonyunyuwala, kwavija Mulungu kowahoza! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wamweda wanhu waja weli wahole, kwavija Mulungu kowagwaa isi yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wamweda wanhu waja weli na nzala na ng'hilu ya kutenda gaja goyolonda Mulungu, kwavija Mulungu kowatenda wegute! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wamweda wanhu waja weli na bazi kwa wayagwe, kwavija Mulungu nayo kowonela bazi! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wamweda wanhu waja wailavile kwa Mulungu kwa mizoyo yao yose, kwavija womona Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wamweda wanhu waja wotenda wanhu wailumbe, kwavija wokemigwa wana wa Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wamweda wanhu waja wodununzika mbuli ya kutenda gaja goyolonda Mulungu, kwavija Undewa wa kuulanga uli wao!” ");
INSERT INTO kdc2014_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mmweda mweye muligigwa na kudununzigwa na kulongigwa vihile, kwavija mwa wanahina zangu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sekeleleni na kudeng'helela, kwavija mwikiligwa nhunza ng'hulu kuulanga. Kwavija vino vivo wadununzigwe watula ndagu wa Mulungu wakalile umwaka, mweye hamunavumbuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mweye mulinga kamba mkele kwa wanhu wose wa mwiisi. Ila kamba mkele wahagiza ukali wake, vino wogeligwa choni mbaka ubweze ukali wake kabili? Haufaya bule, ila wokwasigwa kunze na wanhu woubojoga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mweye muigala na mulenge kwa wanhu wa mwiisi. Buga dizengigwe kulugongo hadidaha kuifisa. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kuduhu munhu yobwinha taa na kuigubika na kikalango, lakini koika kukingolobweda. Baho yomwemwesela kila munhu yeli mng'anda. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vivo ili kumwenu mweye, mulenge wenu uwamwemwesele wanhu wagone gaja ganogile gomtenda muladi wamtogole Tataenu yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sekemugese nene niza kugasegeza Malagizo ga Musa hebu mafundizo ga watula ndagu wa Mulungu. Niye niza kutenda Malagizo gago galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nowalongela ukweli, mbaka ulanga na isi vosegela, kuduhu hata mbuli ndodo ng'hani yonda isegezigwe mna Gamalagizo mbaka gose galongigwe galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Munhu yoyose yolema kukweleleza lagizo dodo mna Gamalagizo gano na kuwafundiza wayagwe watende vivo, munhu ayo kokuwa mdodo mna undewa wa kuulanga. Lakini munhu ija yogagoga Malagizo na kuwafundiza wanhu wayagwe watende vivo, munhu ayo kokuwa mkulu Muundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nowalongeleni, kamba hamutenda ganogile goyolonda Mulungu kubanza wafundiza Malagizo ga Musa na Mafalisayo, hamwingila ng'o Muundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muhulika wanhu wa umwaka viwalongeligwe, ‘Sekemukome. Munhu yoyose yonda yakome yatagusigwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini niye nowalongeleni munhu yoyose yomwihila ndugu yake kotagusigwa. Munhu yoyose yombeza ndugu yake kolondeka yagaligwe kukitala, na munhu yoyose yomkema ndugu yake, ‘Mbozi!’ ayo kolondeka yengile muumoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Avo kamba wahalonda kumulavila Mulungu nhunza muupango, na kokumbuka mugomba na ndugu yako, ");
INSERT INTO kdc2014_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tanhu ileke nhunza yako aho hana uupango, chola hima ukailumbe na ndugu yako, na abaho ubwele umulavile Mulungu nhunza yako. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Munhu yahawa na mbuli na gweye na kolonda kukugala mna ikitala, uilumbe nayo yang'hali hanakugala kukitala. Buleavo yahakugala kukitala, na kukwika mmakono ga msemi, nayo kokwika mmakono ga wakalizi, na gweye kogodekigwa mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nokulongela kweli, mumo humulawa ng'o mbaka ulipe sente yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muhulika wanhu viwalongeligwe, ‘Sekemutende ugoni.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini niye nowalongela, munhu yoyose yonda yamulole mtwanzi kwa kumsulukila, munhu ayo katenda ugoni na mtwanzi ayo muumoyo wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Avo kamba siso jako da mkono wa kudila dahakuhonza utende nzambi, ding'ole ujase. Kwavija yokuwa vinoga ng'hani gweye wagize kinhu kimoja cha lukuli lwako, kubanza lukuli lwako lose lwasigwe muumoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kamba mkono wako wa kudila wahakuhonza utende nzambi, ukanhe uwase! Kwavija vinoga ng'hani kumwako wagize kinhu kimoja cha lukuli lwako kubanza lukuli lwako lose lwasigwe muumoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Vivija muhulika wanhu viwalongeligwe, ‘Munhu yoyose yomwasa mwehe wake kolondeka yamgwee kibua cha nyasa.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini niye nowalongeleni, mbigalo sekeyamwase mwehe wake, ila kamba mtwanzi ayo katenda ugoni. Kwavija kamba yahamwasa, komtenda yawe mgoni, na mbigalo yonda yamsole mtwanzi ayo yasigwe vivija kotenda ugoni. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Muhulika wanhu wa umwaka viwalongeligwe, ‘Sekeuleke kutenda kija kiuiduile, ila kolondeka utende mbuli zose ziuiduile kwa Mndewa.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini niye nowalongeleni, sekemuiduile. Sekemuiduile kwa ulanga, kwavija acho kigoda cha Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","vivija sekemuiduile kwa isi, kwavija aho hanhu ha kwikila magulu gake, hebu kwa Yelusalemu, kwavija dijo buga da Mndewa mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Vivija sekeuiduile kwa pala jako, kwavija hudaha kulutenda hata luvili lumoja luwe luzelu hebu lutitu. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wahalonga, ‘Ona’ iwe ‘Ona,’ hebu wahalonga, ‘Bule’ iwe ‘Bule.’ Mbuli yoyose iyagwe kubanza zino yolawa kwa Mwenembago. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muhulika viilongigwe, ‘Siso kwa siso, na zino kwa zino.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini niye nowalongeleni, sekeumbwezele munhu yakutendele gehile. Munhu yahakutowa kanza da mkono wa kudila, muhindusile da kumoso. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kamba munhu yahakugala kukitala kwa kulonda kusola shati jako, muleke yasole na koti jako. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kamba munhu kokunanahiza umpapile mzigo wake kwa utali wa kilometa imoja, umpapile kwa kilometa mbili. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munhu yahakupula kinhu mgwee, munhu yahalonda kukukopa sambiumulemele. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muhulika wanhu viwalongeligwe, ‘Wanogeleni mbwiga zako, na uwehile waja wakwihile.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini niye nowalongeleni, wanogeleni wanhu wowehila na wapulileni kwa Mulungu waja wowadununza, ");
INSERT INTO kdc2014_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","baho mokuwa wana wa Tataenu yeli kuulanga. Kwavija heyo kowamwemwesela zuwa jake wanhu wehile na wanogile, na kowagwaa mvula waja wotenda gayolonda na waja wotenda gomgevuza. ");
INSERT INTO kdc2014_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vino Mulungu kowagwaa nhunza gani kamba muhawanogela waiyeka wanhu waja wowanogela mweye? Vino hata wabokela kodi hawatenda vivo? ");
INSERT INTO kdc2014_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Muhawalamusa mbwiga zenu waiyeka, motenda kilozo gani? Vino hata wamhazi hawatenda vivo? ");
INSERT INTO kdc2014_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Molondeka mutelele kamba Tataenu yeli kuulanga viyatelele. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Iteganyeni, sekemutende mbuli zinogile mgameso ga wanhu muladi wanhu wawatogole. Muhatenda avo Tataenu wa kuulanga honda yawagwee nhunza yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Avo kamba komgwaa kinhu munhu mkiwa, sekeutowe mhalati kutenda wanhu wakijuwe kija kiutenda, kamba viwotenda wanafiki mna izing'anda za kupulila na mna zinzila muladi wanhu wawatogole. Nowalongeleni ukweli, awo wabokela mwaka nhunza yao yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini gweye wahamgwaa kinhu munhu mkiwa, mkono wako wa kumoso sekeujuwe kija kitendigwa na mkono wako wa kudila. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tenda avo kwa kinyelegezi. Tatako yolola gotendigwa kinyelegezi kokugwaa nhunza. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mwahampula Mulungu, sekemuigale na wanafiki! Kwavija awo wanogelwa kwima na kumpula Mulungu mna zing'anda za ukupula na mna zinzila mhanda, muladi wanhu wawalole. Nowalongeleni ukweli, awo wabokela mwaka nhunza yao yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini gweye wahampula Mulungu, ingila mdigati jako, hinda lwivi lwako, umpule Tatako hakoneka. Tatako iyolola gaja gotendigwa kinyelegezi kokugwaa nhunza. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mwahampula Mulungu, sekemulonge mbuli nyingi za chaka chaka kamba viwotenda wamhazi, kwavija wogesa wohulikigwa kwa mbuli zao nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sekemuigale nao, kwavija Tataenu kajuwa kija kimulonda mung'hali hamunampula. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lakini mweye puleni vino, ‘Tataetu uli kuulanga, twaga jako ditogoligwe, ");
INSERT INTO kdc2014_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","undewa wako wize, goulonda mwiisi gatendigwe, kamba viili kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utugwee lelo lujo lwetu lwa kila siku. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Uzigele kumgongo nzambi zetu zitutendile, kamba vija tweye vituzigela kumgongo mbuli za wanhu wayagwe ziwatutendele. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sekeutwingize kuna ukugezigwa, lakini utuhonye na ija Imdumuka. Kwavija siku zose undewa ni wako na inguvu na ukulu. Ona.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kamba mwahazigela kumgongo nzambi wanhu ziwawatendele, vivija Tataenu yeli kuulanga kozigela kumgongo nzambi zenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini kamba hamuzigela bule kumgongo nzambi za wanhu wayagwe, Tataenu yeli kuulanga nayo hazigela bule kumgongo nzambi zenu zimutendile. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mwahafunga kuja, sekemuwe kamba wanafiki, awo wovitenda vihanga vao vigele bazi muladi wakoneke kamba wafunga kuja. Nowalongeleni ukweli, awo wabokela mwaka nhunza yao yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini gweye wahafunga kuja, sunha kihanga chako na ubunhe mvili zako, ");
INSERT INTO kdc2014_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","muladi wanhu wayagwe sekewakujuwe kamba kufunga kuja ila Tatako yaiyeka yoleka koneka, ayo yonda yajuwe. Nayo Tatako yolola gaja goutenda kinyelegezi kokugwaa nhunza. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Sekemwike ngama zenu mwiisi ino muli na ng'hobo na lungwi luzibananga, na wabavi wokwingila na kwiba. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lakini mwike ngama zenu kuulanga, ako ng'hobo na lungwi havidaha kubananga, na wabavi hawadaha kwingila na kwiba. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwavija kuko kuili ngama yako, vivija kuko kondauwe moyo wako. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Meso gago taa ya lukuli. Kamba meso gako magima, lukuli lwako lose lokuwa na mulenge, ");
INSERT INTO kdc2014_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","lakini kamba meso gako gabanangika, lukuli lwako lose lokuwa mdiziza. Avo kamba mulenge ulimgati mmwako wahawa ziza, dokuwa ziza totolo! ");
INSERT INTO kdc2014_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kuduhu munhu yodaha kuwasang'hanila wakulu wabili, kwavija komwihila imoja na kumnogela iyagwe, hebu koilumba na imoja na kumbeza iyagwe. Hamudaha kumsang'hanila Mulungu hamoja na mali. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Lekaavo nowalongeleni, sekemuugaiye ugima, moja choni na kung'wa choni, hebu ng'huli zenu zovala choni. Vino ugima haunogile bule kubanza lujo? Hebu lukuli halunogile bule kubanza viwalo? ");
INSERT INTO kdc2014_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Waloleni bondwa, hawahanda, hawasenga, hebu kwika kudikanho, lakini Tataenu yeli kuulanga kowadima. Vino mweye hamunogile ng'hani bule kubanza iwabondwa? ");
INSERT INTO kdc2014_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nani kumwenu kwa kuigaza ng'hani kodaha kwengeza hata saa dimoja da ugima wake? ");
INSERT INTO kdc2014_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Habali mogaiya viwalo? Loleni maluwa ga kumuhulo vigokula, hagasang'hana hebu kuitendela viwalo. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lakini nowalongeleni, hata mndewa Sulemani mwenyego na utajili wake wose, havalile goya kamba luwa dimoja mna gamaluwa gano. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kamba Mulungu heyo yodivaza jani da kumuhulo, lelo dabahano na mayo dokwasigwa muumoto, vino hondayawavaze ng'hani mweye? Mweye wanhu mutamanila kidogo! ");
INSERT INTO kdc2014_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Avo sekemuigaze kwa kulonga, ‘Toja choni?’ hebu, ‘Tong'wa choni?’ hebu, ‘Tovala choni?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwavija vinhu vino vivo voogaiya wamhazi. Tataenu yeli kuulanga kojuwa kamba movilonda vinhu vose avo. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakini tanhu uzahileni Undewa wa Mulungu na gaja goyolonda, na vino vose mogweleligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Avo sekemugagaiye ga mayo, kwavija mayo yoigaiya yenyego. Kila siku yoigaiya yenyego. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sekemuwataguse wanhu wayagwe, avo na mweye sekemutagusigwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwavija vimuwatagusa wanhu wayagwe, na mweye motagusigwa vivo. Mulungu kowatendela vivija vimuwatendela wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Habali kolola kibanzi kili mdisiso da ndugu yako, lakini hulola biki dili mdisiso jako? ");
INSERT INTO kdc2014_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hebu kodahaze kumulongela ndugu yako, ‘Chonde leka nikulave kibanzi kili mdisiso jako,’ na kuno gweye mwenyego mdisiso jako mna biki? ");
INSERT INTO kdc2014_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gweye kwa mnafiki! Tanhu lava biki dili mdisiso jako, abaho kodaha kulola goya na kulava kibanzi kili mdisiso da ndugu yako. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sekemuwagwee umbwa vinhu vilavigwe kwa Mulungu, kwavija wowahinduka na kuwaluma. Hebu sekemuwapigisile nguluwe lulu zenu, kwavija wozibojoga. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Puleni, na mweye mogweleligwa, zahileni, na mweye movona, gong'ondeni ulwivi, na mweye movugulilwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwavija munhu yoyose yompula Mulungu kogweleligwa, na munhu yoyose yozahila kopata, na munhu yoyose yogong'onda ulwivi kovuguliligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Vino kuna munhu yoyose kumwenu mweye kamba mwanage yahampula gate komgwaa dibwe? ");
INSERT INTO kdc2014_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hebu yahampula somba komgwaa zoka? ");
INSERT INTO kdc2014_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kamba mweye mmemile nzambi mojuwa kuwagwaa wanenu vinhu vinogile, avo Tataenu yeli kuulanga kowagwaa ng'hani vinhu vinogile wanhu waja wompula. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Avo watendeleni wayagwe gaja gose gomulonda mweye kutendeligwa, kwavija dino dijo fambulo da Malagizo ga Musa na mafundizo ga watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ingileni kubitila lwivi msisili, kwavija lwivi lwa kwingilila kuna ukupotela lugazi, na nzila ilongoza ako ibuha, na wanhu wengi wobitila nzila ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lakini nzila ilongoza kuugima ni ndodo na sisili, wanhu kidogo awo woyona. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iteganyeni na watula ndagu wa uvizi. Wowezila kwa kukoneka kwa kunze kamba ng'hondolo, lakini mgati mmwao waigala na mbwizi. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mowajuwa kwa sang'hano zao, mkese haudaha kulela fulu na mgude haudaha kulela ngama. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Vivija kila mbiki unogile wolela matunda ganogile, na mbiki wihile wolela matunda gehile. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mbiki unogile haulela matunda gehile, na mbiki wihile haulela matunda ganogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila mbiki uleka kulela matunda ganogile wokanhigwa na kwasigwa muumoto. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Avo mowajuwa watula ndagu wa uvizi kwa kija kiwosang'hana. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Siyo kila munhu yong'hema ‘Mndewa, Mndewa’ kokwingila mna Undewa wa kuulanga, ila waja waiyeka wotenda gaja goyolonda Tatangu yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Siku ya nhaguso yahavika, wanhu wengi wonongela, ‘Mndewa, Mndewa! Kwa twaga jako tuwapetela wanhu usenga wa Mulungu, na kwa twaga jako tuwalava wanhu vinyamkela na kutenda unzonza!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abaho nowalongela, ‘Ka, mweye siwajuwile bule. Segeleni kumwangu, mweye wanhu mutenda gehile!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Munhu yoyose yohulika mbuli zangu na kuzigoga, ayo kaigala na munhu mbala yazengile ng'anda yake mdibwe kulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvula itowa, vizanda vimema mazi, beho dibuma na kuitowa ng'anda ija, lakini hailagale bule, kwavija chandusilo chake kizengigwa mdibwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lakini munhu yoyose yohulika mbuli zangu na kolema kuzigoga, ayo kaigala na munhu mbozi yazengile ng'anda yake mumsanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvula itowa, vizanda vimema mazi, beho dibuma na kuitowa ng'anda ija, nayo igwa kwa nguvu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu viyamambukize kulonga avo, lunhu lose lwa wanhu lukanganywa kwa mafundizo gake, ");
INSERT INTO kdc2014_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwavija hafundize kamba wafundiza wao wa Malagizo ga Musa, lakini kafundiza kwa udahi. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu viyahumuluke kulawa kukigongo lunhu lwa wanhu lumkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Munhu imoja yeli na utamu wa dikulu kamgendela Yesu, kamfugamila kalonga, “Go mkulu, wahalonda kodaha kunihonya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kamgolosela mkono wake, kamkwasa munhu ayo kalonga, “Nolonda, hona!” Bahaja munhu ayo kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Abaho Yesu kamulongela, “Tegeleza! Sekeumulongele munhu yoyose, lakini goga inzila mbaka kwa mulava nhosa yakakulolese lolese. Abaho kalave nhosa kamba viyalagize Musa ili kutenda kila munhu yatogole kamba kuhonyigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu viyengile Kapelinaumu, mkulu imoja wa wakalizi wa Lumi kamgendela kampula yamtaze. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kalonga, “Go mkulu, msang'hanaji wangu kawasa ukae, kaholola na kolumwa ng'hani.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kamulongela, “Nochola kumuhonya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mkulu ayo kamwidika, “Go mkulu niye sifaya gweye wingile mng'anda yangu. Lakini longa mbuli na msang'hanaji wangu kohona. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Naniye vivija na hasi ya udahi wa wakulu na nina wakalizi hasi yangu. Nahamulongela ino ‘Chola!’ nayo kochola, nahamulongela iyagwe ‘Izo!’ nayo kokwiza, vivija nahamulongela msang'hanaji wangu, ‘Tenda vino!’ nayo kotenda vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu viyahulike avo, kakanganya kawalongela waja wamkweleleza, “Nowalongeleni, sinamona munhu yoyose mwiisi ya Izilaeli yotamanila kamba ino. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nowalongeleni ukweli, wanhu wengi wokwiza kulawa mwambu wa kudilawila zuwa na mwambu wa kudihongela, wokala hamoja na Abulahamu na Isaka na Yakobo mna ulujo kuna Uundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini waja wolondeka wawe muundewa wa Mulungu wokwasigwa kunze kudiziza, ako wolila na kudafuna meno.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Abaho Yesu kamulongela mkulu ayo, “Chola ukae, na kija chuupulile chotendigwa.” Saa iija msang'hanaji wake kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu viyacholile ukayake Petulo, kamvika mkwe wa kitwanzi wa Petulo kawasa mulusazi, kolumwa homa. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu kamgoga mkono wake na homa imulawa, nayo kenuka kasonga kuwasang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ichungulo viivikile, wanhu wamgalila Yesu wanhu wengi wakalile na vinyamkela. Yesu kawalava vinyamkela kwa kulonga na kawahonya wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Katenda avo muladi kilawilile kija kiyalongile mtula ndagu wa Mulungu Isaya, “Heyo mwenyego kasola magayo getu na kapapa mitamu yetu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu viyaluwone lunhu lwa wanhu lumzunguluka, kawalagiza wanahina zake waloke mwambu uyagwe wa lamba. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mfundiza Malagizo ga Musa imoja kamcholela kamulongela, “Mfundiza, nokuwinza kokose kuuchola.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamwidika, “Vizongo wana mhango na ndege wana mvulu, lakini Mwana wa Munhu kaduhu hanhu ha kubwihila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mwanahina wake imoja kamulongela, “Go mkulu, beta tanhu mbweleganye hamzike tatangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu kamulongela, “Nikweleleze, waleke wanhu wafile wawazike wanhu wao wafile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu kengila mwiingalawa na wanahina zake wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bahaja dilawilila beho kulu kudilamba, na mawimbi ga mazi gaitowa ingalawa, mbaka ingalawa ilonda kudidimila. Lakini Yesu kakala yawasile. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanahina zake wamgendela wamulamusa, wamulongela “Go mkulu, tukombole todidimila!” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kawalongela, “Mweye mutamanila kidogo, habali modumba?” Avo kenuka kadikomhokela beho na ng'humbi ya mazi vinyamale na baho kukala tuluu. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wanhu wakanganya, wauza, “Vino ino munhu gani? Mbaka beho na ng'humbi vomuhulika!” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu viyavikile umwambu, mwiisi ya Gadala, kaiting'hana na wanhu wabili weli na vinyamkela, walawa kuna gamapanga. Wanhu awo wakala wodumbigwa, avo kuduhu munhu yadahile kubita nzila ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bahaja viwamone Yesu waguta mizangi wolonga, “Gweye Mwana wa Mulungu, kotulonda choni? Kwiza kutudununza kipindi king'hali hakinavika?” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Behi na hanhu aho hakala na bumbila da nguluwe woja. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Avo vinyamkela wampula Yesu, “Wahatulava tuleke twingile mna iwanguluwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kawalongela, “Choleni,” Avo walawa na wengila mna iwanguluwe. Bumbila jose dihumulukila mna ingema ya dilamba na wose wafa mgamazi. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wasusilaji wa nguluwe awo wakimbila, wachola kudibuga, ako walonga mbuli zose zilawilile na walonga mbuli ya wanhu waja wakalile na vinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Avo wanhu wose walawa kudibuga dija, wachola kuiting'hana na Yesu. Na viwamone wampula yasegele mwiisi yao. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kengila mwiingalawa kaloka umwambu wa lamba kachola kunadibuga diyakalile. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wanhu wayagwe wamgalila munhu yaholole lukuli, yatambalale mulusazi. Yesu viyone kutamanila kwao, kamulongela munhu ayo yaholole, “Mwanangu, gangamala! Nzambi zako zigeligwa kumgongo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wafundiza Malagizo ga Musa wayagwe wailongela, “Munhu ino komuliga Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kajuwa viwagesile, avo kawalongela, “Habali mogesa gehile mna imizoyo yenu? ");
INSERT INTO kdc2014_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Vino choni kibuhile kulonga, ‘Nzambi zako zigeligwa kumgongo,’ hebu kulonga, ‘Ima utembele’? ");
INSERT INTO kdc2014_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lakini nolonda mujuwe vino, Mwana wa Munhu kana udahi mwiisi wa kuzigela kumgongo nzambi za wanhu.” Avo kamulongela munhu ija yaholole, “Ima, papa lusazi lwako, uchole ukayako!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Munhu ija kenuka kachola ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wanhu viwonile avo, wadumba, wamtogola Mulungu kwa kuwagwaa wanhu udahi awo. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu kasegela hanhu aho, na viyakalile kochola, kamona mbokela kodi, twaga jake Matayo, kakala hanhu hakulipila kodi. Yesu kamulongela, “Nikweleleze.” Matayo kenuka, kamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu viyakalile koja mng'anda ya Matayo, wabokela kodi wengi na wanhu wehile weza, waja hamoja na Yesu na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo wayagwe viwone avo, wawauza wanahina zake, “Habali mfundiza wenu koja hamoja na wanhu wano?” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu viyahulike avo, kalonga, “Wanhu wagima hawamulonda mganga, ila wanhu watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lakini choleni mkaifunze mna Gamaandiko Gang'alile, Mulungu kalonga, ‘Kinilonda niye bazi, siyo nhosa.’ Niye sizile kuwakema wanhu wogesa wanoga, lakini niza kuwakema wanhu wene nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wanahina wa Yohana Mbatizaji wamcholela Yesu wamuuza, “Habali tweye tofunga kuja na Mafalisayo vivija wofunga kuja, lakini wanahina zako hawafunga kuja bule?” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kawedika, “Vino yodahika vilihi wanhu wagonekigwe kuna idizengele wanyunyuwale kipindi munhu yosola kahamoja nao? Haidahika bule! Lakini kipindi chokwiza munhu yosola vonda yasegezigwe kumwao, aho wofunga kuja.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kuduhu munhu yokwika kilaka cha sambi mna ikiwalo cha umwaka, yahatenda vivo kilaka cha sambi chokidega kiwalo cha umwaka na aho hadegeke hokongezeka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Vivija kuduhu munhu yogida divai ya sambi mna imifuko ya ng'hwembe ya umwaka, kwavija yahatenda avo imifuko ayo yotulika, divai yokwitika na imifuko yobanangika. Ila divai ya sambi yogidigwa mna imifuko ya ng'hwembe ya sambi, vose vokuwa vigima.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu viyakalile kolonga avo, mkulu wa Wayahudi kamgendela kamfugamila kalonga, “Mwanangu kafa, nokupula tuchole ukamwikile makono, nayo kokuwa mgima.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu na wanahina zake wenuka, wachola hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mtwanzi imoja yakalile na utamu wa kutumika kwa miyaka longo na mibili, kamcholela Yesu kukisogo, kakwasa mhindo ya kiwalo chake. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kailongela mwenyego, “Nahakwasa kiwalo chake, nohona.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kahinduka, kamona mtwanzi ayo, kamulongela, “Mndele, gangamala! Kutamanila kwako kukuhonya.” Bahaja mtwanzi ija kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu viyengile mna ing'anda ya mkulu ija, kawona watowa ving'weng'we va nyila za ndilo na lunhu lwa wanhu lukala lolila. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kawalongela, “Laweni kunze. Imwana hafile bule, ila kawasa!” Nao wamseka. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lunhu lwa wanhu vilulawile kunze, Yesu kengila kudigati da mndele ayo, kamgoga mkono wake, nayo kenuka. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbuli ayo ibwililika kila hanhu mwiisi ija. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu kasegela hanhu aho, viyakalile kochola wanhu wabili wasuwameso wamkweleleza kuno wokemelela, “Mwana wa Daudi, tonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu viyengile mng'anda, wasuwameso waja wabili wamgendela, Yesu kawauza, “Motogola kamba nodaha kuwahonya?” Wamwidika, “Ona, go mkulu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu kawakwasa meso gao, kalonga, “Ilawilile kamba vimutogola.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meso gao galola, Yesu kawazuma ng'hani, “Sekemumulongele munhu yoyose mbuli ino!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini wao wachola, wazibwililisa mbuli za Yesu mwiisi ija yose. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wanhu viwakalile wosegela, wanhu wayagwe wamgalila Yesu munhu yakalile halonga, kwavija kakala na kinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kinyamkela viyalavigwe, munhu ija yakalile halonga, kasonga kulonga. Wanhu wakanganya na kulonga, “Hatunachona kinhu kamba kino mwiisi ya Izilaeli!” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Mafalisayo walonga, “Kana mwenembago ayo yomgwaa udahi wa kuwalava vinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kachola mna gamabuga gose na ivijiji, kafundiza mna izing'anda zao za kumpula Mulungu, kawapetela Mbuli Inogile ya Undewa wa Mulungu na kuwahonya wanhu weli na mitamu na magayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu viyawone wanhu, kawonela bazi kwavija wakala wogaya na waduhu munhu wa kuwataza, kamba ng'hondolo weliduhu msusilaji. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Abaho kawalongela wanahina zake, “Ndiya nyingi, lakini wasang'hanaji wadodo. ");
INSERT INTO kdc2014_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mpuleni Mndewa wa indiya, yawatume wasang'hanaji mumgunda wake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kawakema wanahina zake longo na wabili na kawagwaa udahi wa kulava vinyamkela, kuhonya mitamu na magayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gano gago matwaga ga watumigwa longo na wabili, wa ichanduso Simoni yakemigwe Petulo na ndugu yake Andeleya, Yakobo na ndugu yake Yohana wana wa Zebedayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batulumayo, Tomaso na Matayo mbokela kodi, Yakobo mwana wa Alufayo, na Tadayo, ");
INSERT INTO kdc2014_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Mkananayo, na Yuda Isikaliote, yamuhinduke Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kawatuma watumigwa wano longo na wabili kawalagiza, “Sekemuchole kwa wanhu wamhazi, hebu kwingila mna gamabuga ga Wasamalia. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila choleni kwa wanhu wa isi ya Izilaeli waigalile na ng'hondolo wapotele. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mwahachola, wapeteleni usenga uno, ‘Undewa wa kuulanga wa mmabehi!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muwahonye watamu, wazilibuleni wafile, muwahonye waja weli na utamu wa dikulu, muwalave vinyamkela. Mugweleligwa bule, laveni bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mna imifuko yenu, sekemusole zahabu hebu shaba hebu sente. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muumwanza wenu, sekemusole mkoba hebu viwalo vibili hebu vilatu hebu mkongoja. Kwavija msang'hanaji kolondeka yagweleligwe kija kilondeka. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mwahengila mna dibuga jojose hebu mna ikijiji, mumzahile munhu yonda yawabokele, kaleni ukayake mbaka vondamusegele. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mwahengila mng'anda, walamuseni wenekae. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wanhu wa ng'anda ayo wahawabokela goya, tindiwalo jenu dokala nao, kamba wahaleka kuwabokela, tindiwalo jenu dowabweleleni mweye. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Munhu yoyose yahalema kuwabokela hebu kuwategeleza, vondamusegele baho kung'huseni matimbwisi mmagulu genu kamba kilaguso cha kuwalema. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nowalongeleni ukweli mna isiku ya nhaguso Mulungu kowonela bazi wanhu wa buga da Sodoma na Gomola kubanza buga dijo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nowatuma kamba ng'hondolo hagati ya mbwizi. Avo muwe wabala kamba zoka na wahole kamba huwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muiteganye na wanhu, kwavija wowagala mna ivitala, wowatowa mbalati mna izing'anda za kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mbuli ya niye mogaligwa haulongozi ha wakulu na wandewa, muladi muwalongela wao na wamhazi Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Vonda wawagale mkitala, sekemugese gaja gondamulonge, kipindi chahavika mogweleligwa cha kulonga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwavija siyo mweye mondamulonge, lakini Loho wa Tataenu kolonga kubitila mweye. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Munhu komuhinduka ndugu yake too yakomigwe na tata komuhinduka mwanage yakomigwe, na wana wowahinduka tata zao na mama zao wakomigwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wanhu wose wowehila mweye mbuli ya twaga jangu. Lakini yoyose yonda yafunge umoyo mbaka kukimambukizo, kokomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wahawadununza kudibuga dimoja, kimbilileni kudibuga diyagwe, nowalongeleni ukweli, hamumambukiza sang'hano yenu kuna gamabuga gose ga Izilaeli yang'hali Mwana wa Munhu hanakwiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanahina hali mkulu kubanza mfundiza wake, wala mtumwa hambita mndewa wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vimnogela mwanahina kuigala na mfundiza wake na mtumwa kuigala na mndewa wake. Kamba mkulu wa ng'anda kakemigwa Belizebuli, vino wanhu wa ng'anda yake honda wakemigwe matwaga gehile ng'hani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Avo sekemuwadumbe wanhu. Chochose kigubikigwe chogubuligwa na chochose kifisigwe chokoneka. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kiniwalongeleni mdiziza, mkilonge imisi, na mbuli imuihulike kwa kinyelegezi, mweye ilongeni mkiswili. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sekemuwadumbe waja iwokoma lukuli, lakini hawadaha kuikoma loho, ila mumdumbe Mulungu yodaha kulukoma lukuli na loho muumoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vino nhongwa wabili hawauzigwa kwa sente imoja? Lakini kuduhu hata imoja wao yofa bila Tata yenu kujuwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakini mweye, hata mvili zili mmapala genu zipetigwa zose. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Avo sekemudumbe, mweye munoga ng'hani kubanza nhongwa wengi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Munhu yoyose yonitogola niye mgameso ga wanhu na niye nomtogola mgameso ga Tatangu yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini munhu yoyose yonibela niye mgameso ga wanhu na niye nombela mgameso ga Tatangu yeli kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sekemugese kamba niza kugala tindiwalo kwa wanhu wa mwiisi. Sizile kugala tindiwalo, ila zele. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwavija niza kuwagola wana na tatazao wandele na mamazao, wandele na wakwe zao wa kitwanzi. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wehi wa munhu ni wanhu wa mng'anda mmwake. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Munhu yoyose yomnogela tatake hebu mamake kubanza niye hafaya yawe mwanahina wangu. Na munhu yoyose yowanogela wanage hebu mndele wake kubanza niye hafaya yawe mwanahina wangu. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Munhu yoyose yoleka kupapa msalaba wake na kunikweleleza niye, hafaya yawe mwanahina wangu. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munhu yougomesa ugima wake kowagiza lakini munhu youlava ugima wake mbuli ya niye, koupata. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Munhu yoyose yowabokela mweye kombokela niye, na munhu yoyose yombokela niye kombokela ija yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Munhu yoyose yombokela mtula ndagu wa Mulungu, kwavija ayo mtula ndagu wa Mulungu, kobokela nhunza ya munhu ayo. Na munhu yoyose yombokela munhu yanogile, kwavija heyo kanoga kobokela nhunza ya munhu ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nowalongeleni ukweli, munhu yoyose yomgwaa mwanahina kikasi cha mazi govega kwavija heyo imoja wa wanahina zangu wadodo, kobokela nhunza yake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu viyamambukize kuwagwaa malagizo gano wanahina zake longo na wabili, kasegela hanhu aho, kachola kufundiza na kuwapetela wanhu mna gamabuga ga Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mbatizaji yakalile mkifungo viyahulike gaja gayakalile yotenda Kilisito, kawatuma wanahina zake kwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wamuuza Yesu, “Vino gweye heyo ija iyalongile Yohana kokwiza, hebu tumbete iyagwe?” ");
INSERT INTO kdc2014_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawedika, “Bweleni mkamulongele Yohana gaja gomuhulika na kugona, ");
INSERT INTO kdc2014_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wasuwameso wolola, mbetembete wotembela, na weli na utamu wa dikulu wohonyigwa na wanhu hawahulika wohulika, wafile wozilibuka na wakiwa wopeteligwa Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wamweda waja wose weliduhu shaka na niye!” ");
INSERT INTO kdc2014_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wanahina wa Yohana viwakalile wosegela, Yesu kasonga kululongela lunhu mbuli za Yohana, “Vino vimucholile kuluwala muchola kulola choni? Muchola kulola lusanze vilutigisigwa na beho? ");
INSERT INTO kdc2014_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kumbe muchola kulola choni? Muchola kumulola munhu yavalile viwalo vinogile? Wanhu wovala kamba avo wokala mna zing'anda za Wandewa! ");
INSERT INTO kdc2014_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nongeleni, vino muchola kulola choni? Muchola kumulola mtula ndagu wa Mulungu? Ona, lakini mona vingi ng'hani kubanza mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kwavija Yohana ayo yalongigwe mna Gamaandiko Gang'alile, ‘Mulungu kalonga, nomtuma msenga wangu yakulongolele, yaitande nzila yako.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nowalongeleni ukweli, hanalawilila munhu yoyose yeli munhu mkulu kubanza Yohana Mbatizaji. Lakini yeli munhu mdodo ng'hani Muundewa wa kuulanga ni munhu mkulu kubanza Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kulawa kipindi cha Yohana Mbatizaji mbaka sambi, wanhu waulema kwa nguvu Undewa wa kuulanga na wanhu wene nguvu wogeza kuuboka. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwavija Malagizo ga Musa na watula ndagu wa Mulungu, galonga mbuli ya undewa mbaka kwiza kwa Yohana Mbatizaji. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mwahazitogola mbuli zao, Yohana heyo Eliya yalongigwe kokwiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yeli na magwiti yahulike! ");
INSERT INTO kdc2014_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vino wanhu wa lukolo lwa sambi waigala na choni? Waigala na wana wadodo wakalile mna gamagulilo. Kibumbila kimoja chokemelela kiyagwe, ");
INSERT INTO kdc2014_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuwatowela gombe sugu, lakini hamuvinile bule! Tuwembila nyila za kuiyalala, lakini hamulilile bule!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwavija Yohana viyezile kafunga kuja na hang'wile divai, nao walonga, ‘Kana kinyamkela!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Munhu viyezile, kaja na kung'wa, nao walonga, ‘Muloleni munhu ino! Mmelo na mlevi, mbwiga zake wabokela kodi na wanhu wene nzambi!’ Lakini nzewele ya Mulungu yokoneka inoga kwa sang'hano zake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu kasonga kuwakomhokela wanhu wa mabuga gayatendile unzonza mwingi, kwavija wanhu awo hawazilekile bule nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kogaya, gweye buga da Kolazini! Kogaya gweye buga da Betisaida! Maza unzonza utendigwe kumwenu mweye, wahatendigwe mna gamabuga ga Tilo na Sidoni, wanhu zake wahalekile mwaka nzambi zao na kuvala magunia na kuibakaza mitozi, kulagusa kamba waleka nzambi zao! ");
INSERT INTO kdc2014_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nowalongeleni ukweli, siku ya nhaguso Mulungu kowonela bazi wanhu wa isi za Tilo na Sidoni kubanza mweye! ");
INSERT INTO kdc2014_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Vivija na gweye Kapelinaumu! Vino kolonda kuinula mwenyego mbaka kuulanga? Kohumulusigwa mbaka kowochola wanhu wafile! Maza unzonza utendigwe kumwako gweye wahatendigwe Sodoma, isi ayo yahasigale mbaka lelo! ");
INSERT INTO kdc2014_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nowalongeleni, mna isiku ya nhaguso Mulungu kowonela bazi wanhu wa isi ya Sodoma kubanza mweye!” ");
INSERT INTO kdc2014_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mna ikipindi acho Yesu kalonga, “Tata, Mndewa wa kuulanga na mwiisi, nokutogola kwavija kuwafisa mbuli zino wanhu weli na nzewele na ubala, na kuwagubulila wana wadodo. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ona, Tata, vino vivo viulondile. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tatangu kanigwaa vinhu vose. Kuduhu munhu yamjuwile Mwana ila Tata yaiyeka, na kuduhu munhu yamjuwile Tata, ila Mwana yaiyeka na waja Mwana yawasagule kuwagubulila wamjuwe Tata. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Izoni kumwangu mweye mose mugaya na kulemelwa na mizigo mikulu, na niye nowatenda mubwihile. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Soleni nila yangu muifunze kumwangu, kwavija niye simgaza munhu hebu kumwehula, na mweye mokala mizoyo iholile. ");
INSERT INTO kdc2014_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwavija nila yangu ibuha na mizigo yonda niwadikwe mibewe.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mna ikipindi acho, Yesu kakala yobita mna imigunda ya uhemba, mwiisiku ya Kubwihila. Wanahina zake wakala na nzala, avo wasonga kuhulula uhemba na kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo viwonile avo, wamulongela Yesu, “Lola, wanahina zako wotenda kinhu kigomesigwe kutendigwa mwiisiku ya Kubwihila!” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kawedika, “Hamusomile kija kiyatendile Daudi, kipindi heyo na wayage viwakalile na nzala? ");
INSERT INTO kdc2014_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kengila Mng'anda ya Mulungu, heyo na wayage wagaja magate galavigwe nhosa kwa Mulungu, hamoja hailondeke wao wagaje, ila walava nhosa waiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Vino hamusomile mna Gamalagizo ga Musa, kila siku ya Kubwihila walava nhosa wobena lagizo da siku ya Kubwihila mna Ing'anda ya Mulungu, na hawakoneka kamba wabananga? ");
INSERT INTO kdc2014_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nowalongeleni hano hana munhu mkulu kubanza Ng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maza mujuwile fambulo da ulonzi uno, ‘Nolonda bazi, silonda sadaka,’ sambi muwataguse wanhu weliduhu gehile. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwavija Mwana wa Munhu heyo Mndewa wa Kubwihila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu kasegela hanhu aho kengila mng'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ako kukala na munhu yakalile na mkono uholole. Wanhu wayagwe wakalile aho walonda kilamuso cha kumtagusila, avo wamuuza Yesu, “Vino Malagizo getu gogomesa kumuhonya munhu mwiisiku ya Kubwihila?” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kawedika, “Vino kamba munhu imoja kumwenu kana ng'hondolo wake kengila mdikolombo mwiisiku ya Kubwihila, hamulava kunze bule? ");
INSERT INTO kdc2014_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vino munhu hanogile bule kubanza ng'hondolo? Avo malagizo getu gotulonda kusang'hana ganogile mwiisiku ya Kubwihila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Abaho kamulongela munhu ija yaholole mkono, “Golosa mkono wako.” Avo kaugolosa mkono wake, nao uhona kamba uja uyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Abaho Mafalisayo walawa kunze wakala kiseto cha kumkoma Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu viyahulike mbuli ayo, kasegela hanhu aho, na lunhu mkulu lumkweleleza. Nayo kawahonya wose wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kawalagiza sekewamulongele munhu yoyose mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Katenda avo muladi kilawilile kija kiyalongile mtula ndagu wa Mulungu Isaya, ");
INSERT INTO kdc2014_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ino ayo msang'hanaji wangu, inimsagule inimnogela na moyo wangu unogezigwa nayo. Noika loho yangu kumwake, nayo kowapetela wanhu wa mwiisi nhaguso yangu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nayo kaduhu ndwagi wala haguta, kuduhu munhu yonda yaihulike sauti yake mna izinzila. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Honda yalubene ludete luveduke, hebu kuuzima utambi ulava yosi, mbaka vondayaitende haki itawale. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wanhu wose wa mwiisi woditamanila twaga jake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Abaho wanhu wayagwe wamgalila Yesu msuwameso na halonga, kwavija kakala na kinyamkela. Yesu kamuhonya, kadaha kulonga na kulola. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wanhu wose wakanganya. Walonga, “Vino ino siyo Mwanage Daudi?” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafalisayo viwahulike avo walonga, “Munhu ino kolava vinyamkela kwa udahi wa Belizebuli, mkulu wa vinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kajuwa kiwakalile wogesa, avo kawalongela, “Kamba undewa wowose wahaigola wenyego undewa awo wofa. Na lubuga lwahaigola wenyego lubuga lulo lofa. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Avo kamba Mwenembago komulava Mwenembago miyage, ayo kaigola mwenyego na undewa wake wokwimaze? ");
INSERT INTO kdc2014_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mweye molonga niye nolava vinyamkela kwa udahi wa Belizebuli. Avo wanhu wenu wolava vinyamkela kwa udahi wa nani? Kwa mbuli ayo wanhu wenu wenyego wowatagusa kamba mobananga! ");
INSERT INTO kdc2014_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakini kamba nowalava vinyamkela kwa Loho wa Mulungu, avo mujuwe kamba Undewa wa Mulungu uvika mwaka kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kuduhu munhu yodaha kutula ng'anda ya munhu mwene nguvu na kusola vinhu vake, mbaka yasonge kumgodeka nzabi munhu ayo, baho kodaha kusola vinhu vake. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Munhu yoyose heli ubanzi wangu konilema, na munhu yoyose yolema kunitaza kwika hamoja ayo kopwililisa. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Avo nowalongela, nzambi zose na maligo ga wanhu gogeligwa kumgongo, lakini maligo kwa Loho Yang'alile honda gageligwe kumgongo bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Munhu yoyose yolonga mbuli za kumliga Mwana wa Munhu, maligo gake gogeligwa kumgongo, lakini munhu yomuliga Loho Yang'alile, maligo gake honda gageligwe kumgongo ng'o mwiisi ino hebu mwiisi yonda ize. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Matunda ganogile golawa mumbiki unogile, wahawa na mbiki wihile kokuwa na matunda gehile. Kwavija mbiki wojuwika kwa matunda gake. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mweye lukolo lwa mizoka! Vino modahaze kulonga mbuli zinogile na kuno mweye wenyego mwiha? Kwavija munhu kolonga kija kimemile muumoyo. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munhu yanogile kolava ganogile mna ingama ya ganogile geli mmwake, na munhu yehile kolava gehile mna ingama ya gehile geli mmwake. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nowalongela ukweli, mna isiku ya nhaguso, wanhu wolondeka walonge habali walonga avo kwa mbuli yoyose ihile iwalongile. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mbuli zako azo zonda zikutaguse, kulagusa kunoga hebu kwiha.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Abaho wafundiza Malagizo ga Musa wayagwe na Mafalisayo wayagwe wamulongela, “Mfundiza, tolonda utende kilaguso.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kawedika, “Mweye wanhu wa lukolo lwa sambi, mwihile na hamumjuwile Mulungu molonda kilaguso? Bule! Kuduhu kilaguso chonda mugweleligwe, ila kilaguso cha mtula ndagu wa Mulungu Yona. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kamba vija Yona viyakalile siku ndatu imisi na ikilo mna iinda ya somba mkulu, vivo ili kwa Mwana wa Munhu kokala siku ndatu imisi na ikilo hasi ya isi. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mna isiku ya nhaguso wanhu wa Ninawi wokwima na kuwatagusa mweye, kwavija awo waleka nzambi Yona viyawapetele. Lakini nowalongela hano hana munhu mkulu kubanza Yona. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mna isiku ya nhaguso Malikia wa Sheba kokwima na kuwatagusa mweye kamba mubananga, kwavija heyo kafunga mwanza kulawa mwiisi yake kachola kumtegeleza Mndewa Sulemani na mafundizo gake geli na nzewele. Nowalongela, hano hana munhu mkulu kubanza Sulemani. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kinyamkela yahamulawa munhu kochola mwiisi inyalile kuzahila hanhu ha kubwihila, kamba hapatile hanhu, ");
INSERT INTO kdc2014_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","koilongela mwenyego, ‘Nobweleganya mng'anda yangu.’ Avo yahabweleganya koivika ng'anda yaduhu kinhu, ifagiligwa na kila kinhu kikigwa goya. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Abaho kochola na kusola vinyamkela wayagwe saba wehile kubanza heyo, awo wokwiza na kukala mumo. Avo ugima wa munhu ayo wokuwa wiha kubanza aho haichanduso. Kino acho chonda kiwalawilile wanhu walukolo luno lwihile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu viyakalile yang'hali kolonga na wanhu, mamake na ndugu zake weza, wema kunze walonda kulonga nayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Avo munhu imoja kamulongela, “Go mkulu, mamako na ndugu zako wema kunze wolonda kulonga na gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kamwidika, “Mamangu ayo nani? Na ndugu zangu awo kina nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Abaho kawagolosela mkono wanahina zake, kalonga, “Lola! Wano awo mamangu na ndugu zangu! ");
INSERT INTO kdc2014_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Munhu yoyose yotenda gaja golondigwa na Tatangu yeli kuulanga, ayo mamangu na ndugu zangu na lumbu jangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Siku didija Yesu kalawa mng'anda, kachola kumgwazo wa lamba, ako kakala hasi na kufundiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lunhu lwa wanhu lumzunguluka Yesu mbaka kengila mwiingalawa na kukala mumo, na wanhu wose wakala kumgwazo wa lamba. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kawalongela mbuli nyingi kwa simo. “Kukala na munhu kachola kuhanda mbeyu. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Viyakalile komiza, mbeyu ziyagwe zilagalila mnzila, ndege weza na kuzija. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ziyagwe zilagalila mgamabwe hakalile na udongo mdodo. Zota himahima kwavija udongo ukala mdodo. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lakini zuwa vidilawile, mimea inyala kwavija imizizi haingile hasi. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu ziyagwe zilagalila mvisolo va miba, miba ayo ikula na kuizonga imimea. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lakini mbeyu ziyagwe zilagalila hanhu heli na udongo unogile, zota zikula na kulela mbeyu nyingi kubanza zija zihandigwe, ziyagwe zilela gana dimoja, ziyagwe zilela malongo sita, na ziyagwe malongo madatu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu kamambukiza kwa kulonga, “Munhu yeli na magwiti yahulike.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abaho wanahina zake wamcholela Yesu wamuuza, “Habali kolonga na wanhu kwa simo?” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kawedika, “Mweye mumweda kuzijuwa mbuli zifisigwe za Undewa wa kuulanga, lakini kumwao awo haili vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwavija munhu yoyose yeli na kinhu kokongezelwa ng'hani, lakini ija yeliduhu kinhu kobokigwa hata kija kidodo kiyeli nacho. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kilamuso cha kulonga kwa simo, muladi walole lakini sekewone, na wategeleze lakini sekewahulike hebu kujuwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Avo kilawilile kiyalongile mtula ndagu wa Mulungu Isaya, ‘Kutegeleza motegeleza, lakini honda mujuwe bule, kulola molola, lakini hamona bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwavija mizoyo ya wanhu wano midala, na magwiti gao hagahulika vinogile, na wafing'hiliza meso gao. Buleavo, meso gao gahalolile, magwiti gao gahahulike, nzewele zao zahajuwile, na wahanibwelele niye, Mulungu kolonga, na niye nahawahonyile.’” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu kalonga kabili, “Lakini mweye mumweda! Kwavija meso genu golola na magwiti genu gohulika. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nowalongeleni ukweli, watula ndagu bwando wa Mulungu na wanhu bwando wa Mulungu walonda ng'hani kugona gaja gomona mweye, lakini hawagonile bule, hebu kuhulika gaja gomuhulika mweye, lakini hawahulike bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tegelezeni na muifunze fambulo da lusimo lwa munhu yohanda. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Munhu yoyose youhulika usenga wa Undewa wa Mulungu lakini haujuwa, kaigala na mbeyu zilagalile mnzila. Mwenembago kokwiza na kusola gaja gahandigwe muumoyo wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zilagalile mgamabwe ziigala na munhu youhulika usenga na bahaja viyoubokela kodeng'helela, ");
INSERT INTO kdc2014_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","lakini kwavija kaduhu mizizi, kogendelela kwa kipindi kidodo. Avo yahagaya na kudununzika mbuli ya usenga awo kobwela kukisogo. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu zilagalile mna ivisolo va miba ziigala na munhu youhulika usenga, lakini mbuli ya magayo ga ugima uno na kulonda utajili youzonga uusenga, nayo halela matunda. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbeyu zilagalile muudongo unogile ziigala na munhu youhulika usenga na kuujuwa. Ayo kolela ng'hani kubanza mbeyu zija zihandigwe, imoja gana dimoja, iyagwe malongo sita na iyagwe malongo madatu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kawalongela lusimo luyagwe, “Undewa wa kuulanga uigala na gaja galawilile kwa munhu yahandile mbeyu inogile mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kilo kimoja, wanhu viwawasile, munhu yamwihile keza na kuhanda sani hagati ya uhemba abaho kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Uhemba viukulile na kusonga kuzamiza, sani nayo yoneka. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wasang'hanaji zake wamgendela wamulongela, ‘Go mkulu, gweye kuhanda mbeyu inogile mumgunda wako. Lelo sani ilawa kwahi?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mkulu ayo kawedika, ‘Ija yanihile heyo yatendile vivo.’ Wamuuza, ‘Kolonda tuchole tukaing'ole isani?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kawedika, ‘Bule, kwavija mwahang'ola sani modaha kung'ola na uuhemba. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekeni uhemba na sani vikule hamoja mbaka kipindi cha kusenga. Baho nowalongela wasengaji wasonge kuikanha isani na kuifunga makinza na kuisoma moto, abaho wausole uhemba na kwika kudikanho jangu.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kawalongela lusimo luyagwe, “Undewa wa kuulanga uigala na kija kilawilile kwa munhu yahandile mbeyu ndodo mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yenyego ndodo kubanza mbeyu zose zilimumgunda, lakini yahakula, yokuwa mbiki mkulu kubanza yose ihandigwe mumgunda, mbaka ndege wokwiza na kuzenga mvulu mna gamatambi gake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kawalongela lusimo luyagwe, “Undewa wa kuulanga uigala na kija kilawilile kwa mtwanzi yasolile sasu na kuitibwiliza hamoja na madebe mabili ga usage mbaka usage wose usasa.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kalulongela lunhu gano gose kwa simo. Halongile nao mbuli yoyose bila simo. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Katenda gano muladi galawilile gaja gayalongile mtula ndagu wa Mulungu, “Nolonga nao kwa simo, Nowalongela mbuli zifisigwe kusongela kuumbigwa kwa isi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu viyalulekile lunhu lwa wanhu na kwingila mng'anda, wanahina zake wamcholela wamulongela, “Tulongele fambulo da lusimo lwa sani ili mumgunda.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kawedika, “Munhu yahandile mbeyu inogile ayo Mwana wa Munhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mgunda ayo isi, mbeyu inogile awo wanhu waja Undewa wa Mulungu uli wao, na sani awo wanhu waja weli wa ija Imdumuka. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ija yamwihile yahandile sani ayo Mwenembago. Kusenga ayo siku ya kimambukizo, na wasengaji ni wasenga wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kamba vija sani viikigwa hamoja na kusomigwa moto, vivo vonda ilawilile mna isiku ya kimambukizo cha isi. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Munhu kowatuma wasenga zake wa kuulanga wawagole na wawalave Muundewa wake wanhu wowahonza wayagwe watende nzambi na wose wayagwe wotenda gehile. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wasenga wa kuulanga wowapigisa mna umoto, mumo wolila na kudafuna meno. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Abaho wanhu wanogile mgameso ga Mulungu wong'ala kamba zuwa Muundewa wa Tatao. Yeli na magwiti yahulike.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Undewa wa kuulanga uigala na zahabu ifisigwe mumgunda. Munhu imoja kaiyona abaho kaifisa kabili, na kwa deng'ho kulu diyakalile najo kachola kuuza vose viyalinavo abaho kaugula mgunda uja.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Vivija Undewa wa Mulungu uigala na munhu yozahila lulu inogile, ");
INSERT INTO kdc2014_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","viyaiyonile lulu imoja inogile ng'hani, kachola na kuuza kila kinhu kiyalinacho, muladi yaigule lulu ayo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Vivija Undewa wa kuulanga uigala na wavuwa somba wategile lwavu lwao mdilamba na kunamata somba wodigwa na howodigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwavu vilumemile, walukwega kuimwhani, wakala hasi na kusonga kusagula, somba wodigwa waweka mvigelo vao na waja hawadigwa wawasa. ");
INSERT INTO kdc2014_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Avo vondaiwe mna isiku ya kimambukizo cha isi, wasenga wa kuulanga wokwiza na kuwabagula wanhu wehile hagati ya wanogile, ");
INSERT INTO kdc2014_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na wanhu wehile wokwasigwa muumoto, ako wolila na kudafuna meno gao.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kawauza, “Vino muzijuwa mbuli zino zose?” Wamwidika, “Ona.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Avo kawalongela, “Mfundiza yoyose wa Malagizo ga Musa yahawa mwanahina wa Undewa wa kuulanga koigala na munhu mwene ng'anda, yolava vinhu va sambi na va umwaka kulawa mna digati jake da kwikila vinhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu viyamambukize kuwalongela simo azo, kasegela hanhu aho ");
INSERT INTO kdc2014_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na kachola ukayake. Kafundiza mna izing'anda za kumpula Mulungu, na waja wamuhulike wakanganya. Waiuza, “Kazipata kwahi nzewele zino? Kaupata kwahi udahi wa kutenda unzonza uno? ");
INSERT INTO kdc2014_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Vino ino siyo mwanage fundi selemala? Vino ino siyo mwanage Malia? Vino ndugu zake siyo Yakobo na Yusufu na Simoni na Yuda? ");
INSERT INTO kdc2014_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Vino lumbu zake hawakala bahano bule? Gano gose kagapata kwahi?” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Avo wamulema. Yesu kawalongela, “Mtula ndagu kotegelezigwa kila hanhu, lakini hategelezigwa ukayake na mna ulukolo lwake mwenyego.” ");
INSERT INTO kdc2014_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwavija wanhu wakala waduhu kutamanila, Yesu hatendile unzonza ng'hani hanhu aho. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mna ikipindi acho Mndewa Helode kakala mkulu wa isi ya Galilaya, viyazihulike mbuli za Yesu, ");
INSERT INTO kdc2014_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kawalongela wasang'hanaji zake, “Munhu ino ayo Yohana Mbatizaji, kazilibuka kulawa kwa wafile, lekaavo kana udahi wa kutenda unzonza.” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwavija Helode ayo yalagize Yohana yagogigwe na yagodekigwe. Katenda avo mbuli ya Helodiya mwehe wa Filipo, mdodo wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwavija Yohana Mbatizaji kamulongela Helode, “Havinogile gweye kumsola Helodiya!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode kalonda kumkoma Yohana, lakini kawadumba wanhu, kwavija wamtogola Yohana kamba mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mna isiku ya kukumbuka kuvumbuka kwa Helode, mndele wa Helodiya kavina mgameso ga wanhu. Helode kanogelwa ng'hani, ");
INSERT INTO kdc2014_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mbaka kaiduila, “Nokugwaa chochose chondaupule!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kwa kufunzigwa na mamake, kalonga, “Nigwelele sambi baha pala da Yohana Mbatizaji mditanda!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mndewa kona usungu, lakini kwavija kakala yaiduile mgameso ga wanhu wagonekigwe, avo kalagiza wamgwelele. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kalagiza Yohana yakanhigwe pala ako mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pala jake digaligwa mditanda, wamgwelela mndele ayo, nayo kamgalila mamake. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanahina zake Yohana wachola kulusola lukuli lwake, waluzika, abaho wachola kumulongela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu viyagahulike gago, kasegela hanhu aho kwa ngalawa, kachola hanhu heliduhu wanhu. Wanhu viwahulike, walawa mmabuga gao wamkweleleza kwa magulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu viyahumuluke mwiingalawa, kaluwona lunhu mkulu lwa wanhu, kawonela bazi, kawahonya wanhu wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Viivikile ichungulo wanahina zake wamcholela, wamulongela, “Hano hatwili twa kuluwala na zuwa dohonga, waleke wanhu wachole kuna ivijiji wakagule lujo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kawedika, “Habali wachole? Mweye wagweleleni lujo!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Awo wamwidika “Tunago magate matano na somba wabili.” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kawalongela, “Ngalileni hano.” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kawalongela wanhu wakale hasi mna gamajani. Abaho kasola magate matano na waja iwasomba wabili. Kalola uchanha kamgwaa nhogolwa Mulungu, kagabanzula gaja gamagate kawagwaa wanahina zake wawagolele wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wanhu wose waja na kwiguta. Abaho wanahina zake wadondola magate gasigale na iwasomba na kumemeza vigelo longo na vibili. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wahaleka watwanzi na wana, wambigalo waiyeka wadile wakala kamba elufu tano. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu viyakalile kowalaga wanhu, kawalongela wanahina zake wengile mwiingalawa wamulongolele wachole mwambu wa lamba. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Viyamambukize kuwalaga wanhu, kakwela yaiyeka kukigongo kumpula Mulungu. Viivikile ichungulo kakala kuko yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kipindi acho ngalawa ikala hagati ya lamba, kuno yozoligwa na ng'humbi, kwavija beho dikala doisung'ha. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nzogolo zikwika, Yesu kawagendela kuno kotembela uchanha mgamazi. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanahina zake viwamone kotembela uchanha mgamazi, wadumba walonga, “Mzimu!” na wakemelela kwa bwembwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bahaja Yesu kawalongela, “Gangamaleni! Iyo nene! Sekemudumbe!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo kamulongela, “Mndewa, kamba ayo gweye, longa nize kumwako kwa kutembela uchanha mgamazi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kamwidika, “Izo!” Petulo kahumuluka mwiingalawa, kasonga kutembela uchanha mgamazi kumcholela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini viyone beho kadumba na kasonga kudidimila, kakemelela, “Mndewa, mhonye!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bahaja Yesu kagolosa mkono wake kamgoga, kamulongela, “Gweye utamanila kidogo! Habali kokona shaka?” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Viwakwelile mwiingalawa, beho najo dinyamala tuluu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wanahina wakalile mwiingalawa wamtambikila Yesu, walonga, “Kweli gweye kwa Mwana wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waloka umwambu wa lamba na kuvika isi ya Genesaleti. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wanhu viwamone Yesu wamjuwa. Avo wazibwililisa mbuli zake mvijiji vili mmabehi, wanhu wamgalila Yesu waja wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wampula yawaleke watamu wakwase mhindo ya kiwalo chake, na wose wakwasile wahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abaho Mafalisayo wayagwe na wafundiza Malagizo ga Musa walawile Yelusalemu wamcholela Yesu wamuuza, ");
INSERT INTO kdc2014_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Habali wanahina zako hawakweleleza mafundizo gatugweleligwe na wahenga zetu? Hawasunha makono gao kamba viilondeka wang'hali hawanakuja.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawedika, “Habali hamugagoga malagizo ga Mulungu ila mogagoga mafundizo genu wenyego? ");
INSERT INTO kdc2014_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mulungu kalonga, ‘Mtegeleze tatako na mamako na munhu yoyose yonda yamulige tatake hebu mamake kolondeka yakomigwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini mweye mofundiza, kamba munhu kana kinhu chochose kodaha kumtaza tatake hebu mamake, lakini kolonga, ‘Kinhu kino nimulavila Mulungu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Munhu ayo halondeka kumtegeleza tatake hebu mamake, kwa kutenda avo hamugatonga malagizo ga Mulungu, kwa kukweleleza mafundizo genu wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mweye mwa wanafiki! Kumbe mtula ndagu wa Mulungu Isaya kalagula goya mbuli ya mweye! ");
INSERT INTO kdc2014_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mulungu kalonga, ‘Wanhu wano wonitegeleza kwa mbuli zao, lakini mizoyo yao yakutali na niye. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wao wonitambikila bule, kwavija wofundiza mafundizo ga wanhu na kugatenda kamba malagizo gangu!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu kalukema lunhu lwa wanhu, kalulongela, “Tegelezeni na muvijuwe! ");
INSERT INTO kdc2014_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kuduhu kinhu kingila mmulomo chodaha kumgela munhu dikwe, lakini kija kilawa mmulomo wa munhu acho kimgela munhu dikwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abaho wanahina zake Yesu wamcholela wamuuza, “Vino kuvijuwa kamba Mafalisayo viwahulike mbuli ziulongile wehilwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kawedika, “Mbiki wowose hauhandigwe na Tatangu wa kuulanga wong'oligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sekemuwatonge! Awo walangulizi hawalola wa wanhu hawalola, kamba munhu halola komulongoza munhu halola miyage, wose wabili wotumbukila mdikolombo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo kamulongela, “Tufambulile ulonzi awo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kawalongela, “Vino na mweye mung'hali hamujuwile? ");
INSERT INTO kdc2014_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mweye hamujuwile bule? Kinhu kingila mmulomo wa munhu chochola mna iinda, abaho cholawa kunze? ");
INSERT INTO kdc2014_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini vija vilawa mmulomo, volawa muumoyo, navo vivo vimgela munhu dikwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwavija muumoyo wa munhu, mumo mulawa magesa gehile, ubavi, ukomaji, ugoni, kuwalonga wayagwe vihile, uvizi na nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gano gago gomgela munhu dikwe, lakini kuja bila kusunha makono hakumgela munhu dikwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kahalawa hanhu aho kachola mwiimbaka ili behi na kudibuga da Tilo na Sidoni. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mtwanzi imoja Mkaanani wa isi ayo kamcholela kuno kotowa nyangi, kamulongela, “Go mkulu, Mwana wa Daudi! Nyonele bazi mndele wangu kana kinyamkela komgaza ng'hani.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu hamwidike mbuli. Wanahina zake wamcholela Yesu wampula, “Mulongele yasegele! Kwavija kotukweleleza na kotutowela mizangi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kawedika, “Nhumigwa kwa wanhu wa isi ya Izilaeli weli kamba ng'hondolo wapotele.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mtwanzi ayo keza kamfugamila kamulongela, “Go mkulu, nhaze!” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kamwidika, “Havinogile bule kusola lujo lwa iwana na kuwapigisila umbwa.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mtwanzi ayo kamwidika, “Ona, go mkulu, lakini hata umbwa woja kija kilagale hasi mmeza ya wakulu zao.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu kamwidika, “Gweye kwa mtwanzi utamanila ng'hani! Kiulondile kotendiligwa.” Bahaja mndele wake kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu kahalawa hanhu aho, kachola kumgwazo wa lamba da Galilaya. Kakwela kukigongo kakala hasi. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lunhu lwa wanhu lumcholela na wamgalila wanhu wakalile mbetembete, wasuwameso, walemale, wanhu hawalonga na wanhu wengi watamu, waweka haulongozi wake, nayo kawahonya. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wanhu wakanganya viwone wanhu hawalonga wolonga, walemale wahona, mbetembete wotembela na wasuwameso wolola, nao wamgwaa nhogolwa Mulungu wa Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kawakema wanahina zake, kalonga, “Nowonela bazi wanhu wano, kwavija wakala na niye siku ndatu na waduhu lujo. Silonda niwaleke wachole na nzala, sekewasinduke mnzila.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanahina zake wamuuza, “Hano hatwili twa kuluwala, togapata kwahi magate ga kuwagwaa wanhu wose wano waje?” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kawauza, “Mna magate mangapi?” Wamwidika, “Saba na visomba vidoododo kidogo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Avo Yesu kawalongela wanhu wakale hasi. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kasola gamagate saba na waja iwasomba, kamgwaa nhogolwa Mulungu, kagabanzula gamagate, kawagwaa wanahina zake, nao wawagolela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose waja na kwiguta. Abaho wanahina zake wadondola vija visigale na kumemeza vigelo saba. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wambigalo wadile wakala elufu nne, watwanzi na wana hawapetigwe bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Abaho Yesu kawalaga wanhu, kengila mwiingalawa, kachola mwiisi ya Magadani. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo wayagwe wamcholela Yesu walonda kumgeza, wampula yawalagusile kilaguso kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu kawedika, “Zuwa dahahonga, molonga, ‘Honoga, kwavija ulanga mdung'hu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na imitondo molonga, ‘Lelo mvula kotowa, kwavija ulanga mdung'hu na mawingu totolo.’ Modaha kujuwa ulanga viuli, lakini hamujuwa vilaguso va kipindi acho. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lukolo lwa sambi lwihile na luliduhu kutamanila molonda kilaguso! Lakini kuduhu kilaguso chonda mugweleligwe kubanza kija cha Yona.” Yesu kawaleka baho, kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanahina zake viwalokile umwambu uyagwe wa lamba, wakala waisemwile kusola magate. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kawalongela, “Muiteganye na mkale meso na usasu wa Mafalisayo na Masadukayo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wasonga kuilongela wenyego, “Kolonga vino kwavija hatusolile magate.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kajuwa kija kiwakalile wolonga, kawauza, “Mweye mutamanila kidogo, habali molongelela mbuli za kuwa bule magate? ");
INSERT INTO kdc2014_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mung'hali hamuvijuwile? Vino hamukumbuka vinigabanzule gamagate matano na kuwagwaa wanhu elufu tano? Vino mmemeza vigelo vingapi? ");
INSERT INTO kdc2014_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na vivija gaja magate saba kwa wanhu elufu nne? Vino, mmemeza vigelo vingapi? ");
INSERT INTO kdc2014_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vino hamujuwile vilihi kamba sikalile nolonga mbuli ya magate? Muiteganye na usasu wa Mafalisayo na Masadukayo!” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Baho wanahina wajuwa kamba Yesu hawazumile waiteganye na usasu wa magate, ila mafundizo ga Mafalisayo na Masadukayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu viyavikile mwiisi ya Kaisalia Filipi, kawauza wanahina zake, “Vino, wanhu wolonga Mwana wa Munhu ayo nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wamwidika, “Wayagwe wolonga Yohana Mbatizaji, wayagwe wolonga Eliya, kuno wayagwe wolonga Yelemia na wayagwe wolonga imoja wa watula ndagu wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kawauza, “Na mweye molonga niye na nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo kamwidika, “Gweye kwa Kilisito, Mwana wa Mulungu yeli mgima.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kamwidika, “Kumweda gweye Simoni, mwanage Yohana, kwavija mbuli yuulongile hufunzigwe na munhu, ila ilawa kwa Tatangu yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Niye nokulongela, Petulo, gweye kwa dibwe kulu na uchanha mwa dibwe dino nozenga kanisa jangu, hata ifa haidaha bule kudihuma. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nokugwaa luvugulo lwa Undewa wa kuulanga, chochose chondaufunge mwiisi chofungigwa kuulanga, na chochose chondaufungule mwiisi chofunguligwa kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Abaho Yesu kawazuma wanahina zake sekewamulongele munhu yoyose kamba heyo kakala Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kulawa baho, Yesu kawalongela wanahina zake fulu ipile, “Nolondeka kuchola Yelusalemu, kuko nodununzigwa ng'hani mmakono ga wavele, wakulu wa walava nhosa na wafundiza Malagizo. Ako nokomigwa na siku da kadatu nozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo kamsola Yesu kumgwazo kasonga kumkomhokela, “Bule, Mndewa! Dino hadikulawilila bule!” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kahinduka, kamulongela Petulo, “Segela kumwangu, Mwenembago! Gweye kong'himila, kwavija hugesa ga Mulungu, ila kogesa ga iwanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Abaho Yesu kawalongela wanahina zake, “Munhu yoyose yolonda kwiza kumwangu, yaileme mwenyego, yaupape msalaba wake na yanikweleleze. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwavija munhu yoyose yolonda kuukombola ugima wake kowagiza, lakini munhu yoyose yowagiza ugima wake mbuli ya niye koupata. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vino munhu kopata choni kamba yahaipata isi yose, lakini kowagiza ugima wake? Hebu munhu kolava choni yaupate kabili ugima wake? ");
INSERT INTO kdc2014_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwavija Mwana wa Munhu kokwiza muukulu wa Tatake hamoja na wasenga wa kuulanga, abaho komgwaa kila munhu nhunza yake iigalile na sang'hano yake. ");
INSERT INTO kdc2014_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nowalongela ukweli, wanhu wayagwe wemile hano, hondawafe bule, mbaka vondawamone Mwana wa Munhu vondayeze muundewa wake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vizibitile siku sita, Yesu kamsola Petulo na Yakobo na Yohana ndugu yake Yakobo, kachola nao waiyeka kuna ulugongo lutali. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Viwakalile wolola, Yesu kagaluka. Kihanga chake king'ala kamba zuwa, na viwalo vake vikala vizelu chuwee kamba mulenge. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Baho wanahina waja wadatu wamona Musa na Eliya wolonga na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo kamulongela Yesu, “Mndewa, vinoga tweye tukale hano! Kamba wahalonda nozenga viheha vidatu, kimoja chako gweye, kimoja cha Musa na kimoja cha Eliya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Viyakalile yang'ali kolonga, wingu ding'alile diwagubika na sauti ilawa mdiwingu ilonga, “Ino ayo Mwanangu inimnogele. Mumtegeleze!” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanahina zake viwahulike vivo, wadumba ng'hani wagwa kingubanguba. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kawacholela kawakwasa kawalongela, “Inukeni, sekemudumbe!” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Viwalolile uchanha, hawamonile munhu ila Yesu yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Viwakalile wohumuluka kulugongo, Yesu kawazuma, “Sekemumulongele munhu yoyose mbuli zino zimone, mbaka Mwana wa Munhu vonda yazilibuke kulawa kwa wafile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abaho wanahina wamuuza, “Habali wafundiza Malagizo ga Musa wolonga Eliya kolondeka yeze tanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kawedika, “Kweli, Eliya kokwiza tanhu, nayo kokwiza kutanda kila kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini nowalongeleni, Eliya kamala kwiza na wanhu hawamjuwile bule, wamtendela viwalondile. Vivo vonda wamdununze Mwana wa Munhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Abaho wanahina zake wajuwa kamba Yesu kakala kolonga mbuli ya Yohana Mbatizaji. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Viwaluvikile lunhu lwa wanhu, munhu imoja kamcholela Yesu, kamfugamila, ");
INSERT INTO kdc2014_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kamulongela, “Go mkulu, monele bazi mwanangu, kana kisango na kogaya ng'hani. Miyanza mingi kogwa muumoto hebu mgamazi. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimgala kwa wanahina zako, lakini hawadahile bule kumuhonya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kawedika, “Mweye lukolo lwihile na luliduhu kutamanila! Ng'hale na mweye mbaka lini? Nogela kitumbe kumgongo mbaka lini? Mgaleni hano imbwanga!” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kamkomhokela ikinyamkela, nayo kamulawa mbwanga ayo, bahaja kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abaho wanahina zake wamcholela Yesu kinyelegezi wamuuza, “Habali tweye hatudahile kumulava ikinyamkela?” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kawedika, “Kwavija mutamanila kidogo. Nowalongeleni ukweli, mwahawa na kutamanila kidogo kamba mbeyu ndodo ya haladali, modaha kukilongela kigongo kino, ‘Segela hano uchole haja!’ nacho chochola. Mwahatendile kila kinhu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kinyamkela kamba ino hadaha kulawa mbaka upule na kufunga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wanahina viwakalile hamoja kuko Galilaya, Yesu kawalongela, “Mwana wa Munhu kogeligwa mmakono ga wanhu, ");
INSERT INTO kdc2014_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nao womkoma, lakini siku da kadatu kozilibuka.” Wanahina zake wakala wanyunyuwale. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na wanahina zake viwavikile Kapelinaumu, wabokela kodi ya Ng'anda ya Mulungu wamcholela Petulo, wamuuza, “Vino mfundiza wenu kalipaga kodi ya Ng'anda ya Mulungu?” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo kawedika, “Ona, kalipaga.” Petulo viyengile mng'anda, Yesu kasonga kulonga, “Simoni, gweye kogesaze? Wandewa wa isi wasolaga kodi na malipo kulawa kwa nani? Kwa wenekae hebu kwa wanhu baki?” ");
INSERT INTO kdc2014_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo kamwidika, “Kwa wanhu baki.” Yesu kamwidika, “Vinoga, ino yofambula kamba wenekae hawalondeka kulipa. ");
INSERT INTO kdc2014_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini hatulonda kuwagevuza wanhu wano. Avo chola kudilamba tega ndoano. Msole somba yonda yalongole kunamata, mbabazule umulomo na mgati yake kokona sente ya kulipa kodi ya Ng'anda ya Mulungu, yangu niye na gweye. Isole kalipile kodi yetu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kipindi acho wanahina wamcholela Yesu, wamuuza, “Nani yeli mkulu Muundewa wa kuulanga?” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kamkema mwana mdodo, kamwimiza haulongozi wao, ");
INSERT INTO kdc2014_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kalonga, “Nowalongeleni ukweli, kamba mwahaleka kugaluka na kuigala na mwana mdodo, hamkwingila ng'o Muundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Munhu yoyose yoihumulusa kamba mwana ino ayo mkulu kubanza wose Muundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yoyose yombokela mwana mdodo kamba ino kwa twaga jangu, kombokela niye. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Munhu yoyose yonda yamuhonze imoja wa wadodo wano wonitogola, yatende nzambi yokuwa vinoga munhu ayo yagodekigwe dibwe kulu da kudugila msingo na yasigwe mbahali. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mogaya wanhu wa mwiisi mbuli ya gaja gowatenda wanhu wagize kutamanila kwao! Magayo golondeka galawilile lakini kogaya munhu ija yonda yatende galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kamba mkono wako hebu mgulu wako wahakuhonza utende nzambi ukanhe uwase! Yokuwa vinoga kwingila kuna uugima wa mazuwa gose na mkono hebu mgulu, kubanza kwingila na makono mabili hebu magulu mabili na kwasigwa mna umoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kamba siso jako dahakuhonza utende nzambi, ding'ole na ujase! Yokuwa vinoga gweye wingile kuna uugima wa mazuwa gose na siso dimoja kubanza kuwa na meso mabili na kwasigwa muumoto wa jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Iteganyeni sekemumbeze imoja wa wadodo wano. Kwavija nowalongeleni wasenga wa kulanga wolola kihanga cha tatangu yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwavija Mwana wa Munhu keza kukikombola kija kipotele. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mogesaze? Kamba munhu kana ng'hondolo gana dimoja, na ng'hondolo imoja kapotela, avo hawaleka waja malongo tisa na tisa mna ikigongo na kuchola kumzahila ija ng'hondolo yapotele? ");
INSERT INTO kdc2014_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nowalongeleni ukweli yahampata, kodeng'helela ng'hani kubanza waja malongo tisa na tisa walekile kupotela. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vivija Tata yeli kuulanga halonda hata imoja wa wadodo wano yapotele. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kamba ndugu yako yahakutendela gehile. Chola ukamzume, heyo na gweye muli mwiiyeka. Yahakutegeleza, kumpata ndugu yako. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yahalema kukutegeleza, msole munhu imoja hebu wabili hamoja na gweye, ili chochose kilongigwa kitogoligwe na wanhu wabili hebu wadatu. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kamba yahalema kuwategeleza, walongele wanhu wamtogole Yesu, vivija yahalema kuwategeleza, muleke yawe kumwako kamba mmhazi hebu mbokela kodi. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nowalongeleni, jojose dondamudifunge mwiisi dofungigwa kuulanga, na jojose dondamfungule mwiisi dofunguligwa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nowalongeleni kabili, wanhu wabili kumwenu mweye wahaitogolela mwiisi kupula kinhu chochose, Tatangu yeli kuulanga kowatendela. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwavija kokose konda waiting'hane wanhu wabili hebu wadatu kwa twaga jangu, niye na hamoja nao.” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Abaho Petulo kamcholela Yesu kamuuza, “Mndewa, kamba ndugu yangu yahanhendela vihile, ngele kumgongo miyanza mingapi? Mbaka miyanza saba?” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamwidika, “Nokulongela siyo miyanza saba, lakini saba miyanza malongo saba, ");
INSERT INTO kdc2014_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","kwavija Undewa wa Mulungu uigala na Mndewa yalondile kupeta sente zake na wasang'hanaji zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Viyasongile kupeta sente, kagaligwa munhu imoja yakalile kodaigwa talanta elufu kumi. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Msang'hanaji ayo kakala kaduhu kinhu cha kumulipa, avo mndewa kalagiza yauzigwe, heyo, mwehe wake na wanage na vose viyalinavo muladi yalipe dideni. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Msang'hanaji ayo kamfugamila kampula, ‘Go mkulu, nibetele kwa kufunga umoyo nokuliha kila kinhu!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mndewa ija kamonela bazi, avo kamulekelela dideni dija na kamuleka yachole.” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Abaho munhu ija viyasegela kamting'hana msang'hanaji miyage yakalile komdai sente gana dimoja, kamgoga kasonga kumbota isingo kuno kolonga, ‘Liha sente yangu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Msang'hanaji miyage kamfugamila, kampula, ‘Nibetele kwa kufunga umoyo nokuliha!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini kalema, kachola na kumgodeka miyage mkifungo mbaka vonda yalihe deni dija. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wasang'hanaji wayage viwonile kija kilawilile wona usungu, wachola kumulongela mndewa mbuli zose zilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Avo mndewa kamkema msang'hanaji ayo, kamulongela. ‘Gweye kwa msang'hanaji wihile, niye nikulekelela deni jako kwavija kunipula nhende vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kulondeka umonele bazi msang'hanaji miyago kamba niye vinikonele bazi.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mndewa wake kagevuzika ng'hani, kamgodeka mkifungo mbaka vondayalihe deni jose.” ");
INSERT INTO kdc2014_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu kamambukiza, “Vino vivo Tatangu yeli kuulanga vonda yawatendeleni mweye, kamba hamuzigela kumgongo mbuli za ndugu zenu kwa mizoyo yenu yose.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu viyamambukize kulonga mbuli azo, kasegela isi ya Galilaya na kachola mwiisi ya Yudea, kuna umwambu wa lwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lunhu mkulu lwa wanhu lumkweleleza, na kuko kawahonya wanhu wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wayagwe wamcholela Yesu na wamgeza kwa kumuuza, “Vino vinoga mbigalo kumwasa mwehe wake kwa mbuli yoyose?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kawedika, “Vino hamugasomile bule Maandiko Gang'alile vigalonga kulawa kuna ichanduso, Mulungu kamuumba mbigalo na mtwanzi? ");
INSERT INTO kdc2014_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Avo Mulungu kalonga, ‘Kwa mbuli ayo mbigalo komuleka tatake na mamake nayo koilumba na mwehe wake, na wabili awo wokuwa kinhu kimoja. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Avo haweli wabili kabili lakini kinhu kimoja. Avo kiyalumbilize Mulungu, munhu sekeyakigole.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafalisayo wamuuza Yesu, “Habali Musa katugwaa lagizo kamba mbigalo kodaha kumgwaa kibua cha nyasa mwehe wake na kumwasa?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kawedika, “Musa kawagwaa lagizo muwaleke wehe zenu kwavija mizoyo yenu midala, lakini havikalile vivo bule kipindi Mulungu viyaumbile isi. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nowalongeleni, mbigalo yoyose yomwasa mwehe wake, na kumsola mtwanzi iyagwe, kotenda ugoni. Ila kodaha kumwasa mwehe wake kamba yahatenda ugoni.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanahina zake wamulongela, “Kamba vino vivo ili kwa mbigalo na mwehe wake, vinoga kuleka kusola.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kawedika, “Siyo kila munhu kodaha kuitogola mbuli ino, lakini waja wagweleligwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kuna vilamuso vingi viwatenda wanhu waleke kusola, wayagwe waleligwa vivo, wayagwe watendigwa vivo na wanhu. Na wayagwe hawasola mbuli ya Undewa wa kuulanga. Lakini ija yodaha kugagoga mafundizo gano yagagoge.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wanhu wayagwe wamgalila Yesu wana wadodo yawahagatile na kuwatambikila, lakini wanahina zake wawakomhokela. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kalonga, “Walekeni wana wadodo weze kumwangu sekemuwagomese, kwavija Undewa wa kuulanga wa wanhu kamba wana wano.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kawahagatila, abaho kasegela hanhu aho. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mbwanga imoja kamcholela Yesu, kamuuza, “Mfundiza nhende choni kinogile niupate ugima wa mazuwa gose?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamulongela, “Habali koniuza mbuli ya kinhu kinogile? Kuna imoja yaiyeka yanogile. Wahalonda kwingila muugima wa mazuwa gose, gagoge malagizo ga Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kamuuza, “Malagizo gani?” Yesu kamwidika, “Sekeukome, sekeutende ugoni, sekewibe, sekeulave usindila wa uvizi, ");
INSERT INTO kdc2014_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wategeleze tatako na mamako, na umnogele miyago kamba viuinogela mwenyego.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mbwanga ayo kamwidika, “Malagizo gano gose nigagoga. Choni kiyagwe kinilondeka kutenda?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamulongela, “Wahalonda udahe kutenda goyolonda Mulungu, genda kachuuze vinhu vose viuli navo na ukawagwelele wakiwa zisente, na gweye kokuwa na utajili kuulanga, abaho wize unikweleleze.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mbwanga ija viyahulike avo, kasegela kuno kanyunyuwala, kwavija kakala tajili ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Abaho Yesu kawalongela wanahina zake, “Nowalongeleni ukweli, yokuwa vidala ng'hani kwa munhu tajili kwingila Muundewa wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nowalongeleni kabili, vibuha kwa ngamiya kubita mna ikizonzo cha sanzia, kubanza tajili kwingila Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanahina zake viwahulike avo, wakanganya ng'hani wamuuza, “Vino nani yonda yadahe kukomboligwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kawalola bunhuu kawalongela, “Kwa munhu havidahika, lakini kwa Mulungu gose godahika.” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petulo kamwidika, “Lola tweye tuleka kila kinhu na kukukweleleza gweye. Avo topata choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kawalongela, “Nowalongeleni ukweli, Mwana wa Munhu vondayakale mna ikigoda chake cha ukulu mna iisi yonda ize, mweye wanahina zangu longo na wabili mokala mna ivigoda va ukulu na kugatawala makabila longo na mabili ga Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Munhu yoyose yalekile ng'anda hebu ndugu hebu lumbu jake hebu tatake hebu mamake hebu wanage hebu migunda mbuli ya niye kobokela miyanza gana kwa vija viyelinavo, na koupata ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini wanhu wengi weli wa ichanduso wokuwa wa ikimambukizo, na waja wa ikimambukizo wokuwa wa ichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Undewa wa kuulanga uigala na kija kilawilile kwa munhu yeli na mgunda wa mizabibu, kalawa imitootondo ng'hani, kachola kugoneka wanhu wakasang'hane mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kailagana nao yawalipe sente kwa sang'hano ya siku dimoja, abaho kawagala mumgunda wake wakasang'hane. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Abaho saa ndatu kachola kudigulilo kawavika wanhu wema aho waduhu chakutenda. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Avo kawalongela, ‘Mweye vivija gendeni kumgunda wangu mukasang'hane na nowalipa chochose cha kufaya.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Avo wachola. Viivikile saa sita na saa tisa imisi ayo mwene mgunda kachola katenda vivija viyatendile ichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Viivikile saa kumi na moja kachola na kawavika wanhu wayagwe wema, kawauza, ‘Habali mwima hano imisi yose mduhu cha kusang'hana?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wanhu waja wamwidika, ‘Kwavija kuduhu munhu yatugwelele sang'hano.’ Kawalongela, ‘Na mweye vivija mkasang'hane kumgunda wangu wa mizabibu!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Viivikile ichungulo, munhu mwene mgunda kamulongela mwamizi wake wa mgunda, ‘Wakeme wanhu wasang'hane na uwalipe sente zao, kusongela waja wakimambukizo na waja wa ichanduso.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wanhu wasang'hane kusongela saa kumi na moja, walipigwa kila munhu sente imoja. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Avo waja wanduse kusang'hana viwezile wagesa kamba wolipigwa sente nyingi, lakini kila imoja wao kagweleligwa sente imoja. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wasola zisente na kusonga kumnung'unikila ija yawagoneke. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Walonga, ‘Wanhu wano wagonekigwe kukimambukizo wasang'hana kwa saa dimoja diiyeka, tweye tusang'hana siku ngima mdizuwa, abaho kuwalipa vivija viutulipile tweye!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ija mwene mgunda kamwidika imoja wao, ‘Mbwigangu tegeleza, niye sikubunzile bule. Vino hatuilagane nikulipe sente imoja kwa kusang'hana siku dimoja? ");
INSERT INTO kdc2014_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sola sente yako uchole, niye ninogelwa kumlipa munhu ino inimgoneke kukimambukizo kamba vinikulipile gweye. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Vino havinogile bule niye kutenda kija kinilonda kwa sente zangu mwenyego? Hebu gweye kokona migongo kwavija niye nina moyo unogile?’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu kamambukiza kulonga, “Avo wose weli wa ikimambukizo sambi wokuwa wa ichanduso kumwande, na wose weli wa ichanduso sambi wokuwa wa ikimambukizo kumwande.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu viyakalile kochola Yelusalemu, kainega kumgwazo na wanahina zake longo na wabili, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tegelezeni, tochola Yelusalemu, kuko Mwana wa Munhu kogeligwa mmakono ga wakulu wa walava nhosa na wafundiza Malagizo ga Musa. Nao womtagusa yafe. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na womwika mmakono ga Wamhazi, nao womzeha womtowa mbalati na womkoma kwa kumuwamba mumsalaba, lakini siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abaho mwehe wa Zebedayo na wanage wabili kamcholela Yesu, kamfugamila kampula yamtendele kija kiyolonda. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamuuza, “Kolonda choni?” Kamwidika, “Chonde, nhogolela wanangu wano wabili, imoja yakale mwambu wa mkono wako wa kudila na iyagwe mwambu wa mkono wako wa kumoso muundewa wako.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kawedika, “Hamkijuwile kinhu kimpula, vino modaha kuking'wela kikasi cha madununzo chonda niking'wele niye?” Wamwidika, “Todaha.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kawalongela, “Kweli moking'wela kikasi changu, lakini naduhu udahi wa kusagula nani yakale mwambu wa mkono wangu wa kudila hebu wa kumoso. Hanhu aho wekiligwa wanhu wasaguligwe na Tatangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Baho wanahina longo viwahulike avo, wawagevuzikila ng'hani Yakobo na Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu kawakema wose hamoja kawalongela, “Mojuwa kamba wakulu wa wanhu wa mwiisi wowalanguliza kwa nguvu, na wakulu wao wana udahi. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini haili vivo kumwenu. Munhu yoyose yolonda kuwa munhu mkulu, yawe msang'hanaji wa wose, ");
INSERT INTO kdc2014_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na munhu yolonda kuwa wa ichanduso, yawe mtumwa wa wose. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kamba vija Mwana wa Munhu, hezile kusang'hanilwa, lakini keza kuwasang'hanila na kuulava ugima wake kwa kuwakombola wanhu wengi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na wanahina zake viwakalile wosegela kudibuga da Yeliko, lunhu lwa wanhu lumkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wanhu wabili wasuwameso wakalile kumgwazo wa inzila, viwahulike Yesu kobita, wasonga kukemelela, “Mwana wa Daudi! Tonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lunhu lwa wanhu luwakomhokela luwalongela wanyamale. Lakini wagendelela kukemelela ng'hani, “Mwana wa Daudi! Tonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kema kawakema kawauza, “Molonda niwatendele choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wamwidika, “Go mkulu, tolonda kulola!” ");
INSERT INTO kdc2014_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu kawonela bazi kawakwasa meso gao, bahaja wadaha kulola, nao wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wanahina zake viwavikile Yelusalemu, wachola Betifage kuna Ulugongo lwa Mizeituni. Baho kawatuma wanahina zake wabili wamulongolele, ");
INSERT INTO kdc2014_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kawalongela, “Gendeni kuna ikijiji kili kuulongozi wenu, aho momvika mhunda kafungigwa na mwanage kumgwazo. Wafunguleni mungalile hano. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Munhu yoyose yahawauza, mulongeleni, Mndewa kowalonda, nayo kowaleka wachole.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gano gatendeka muladi kiyalongile mtula ndagu wa Mulungu kilawilile, ");
INSERT INTO kdc2014_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Dilongele buga da Sayuni, Lola, mndewa wako kokwiza! Muhole na kakwela mhunda na mwanage mhunda.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Avo wanahina wachola watenda vivija viyawalongele Yesu watende. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamgala ija imhunda na mwanage, watandika viwalo vao mmigongo wa waja iwamhunda, na Yesu kakwela uchanha. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lunhu lwa wanhu lwanzanza viwalo vao mnzila kuno wayagwe wabena mibunho na kuyanzanza mnzila muladi yabite. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wanhu wakalile kukisogo na kuulongozi wa Yesu wakemelela, “Yatogoligwe mwana wa Daudi! Mulungu yamtambikile ija yokwiza kwa twaga da Mndewa! Mulungu yatogoligwe!” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu viyengile Yelusalemu, wanhu wose wa kudibuga wading'huka na waiuza, “Ino ayo nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lunhu lwa wanhu lwidika, “Ino ayo Yesu, mtula ndagu wa Mulungu kolawa Nazaleti mwiisi ya Galilaya,” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kengila Mng'anda ya Mulungu, kawawinga wanhu wose wakalile wogula na kuchuuza vinhu. Kazibidula meza za wanhu wakalile wovunja sente na vigoda va wanhu wakalile wochuuza njiwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kawalongela, “Yandikigwa mna Gamaandiko Gang'alile, ‘Ng'anda yangu yokuwa kae ya kupulila.’ Lakini moitenda mhango ya wabavi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wasuwameso na wanhu mbetembete wamcholela Yesu kuna Ing'anda ya Mulungu, nayo kawahonya. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wakulu wa walava nhosa na wafundiza Malagizo ga Musa wagevuzika viwonile mbuli za unzonza ziyakalile yotenda Yesu na wana viwakalile wokemelela Mng'anda ya Mulungu, “Yatogoligwe Mwana wa Daudi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Avo wamuuza Yesu, “Vino kohulika viwolonga wana wano?” Yesu kawedika, “Mhulika, hamugasomile gaja Gamaandiko Gang'alile golonga, ‘Muwafundiza wana na ving'hele kulava nhogolwa inogile.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu kawaleka na kachola Betania kunze ya buga, kawasa kuko. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Imitootondo, Yesu viyakalile kobwela mna idibuga, kakala na nzala. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Behi na nzila kawona mbiki wa mtini kaucholela, yalole kamba kodaha kupata tunda jojose, lakini honile kinhu ila majani gaiyeka. Avo kaulongela, “Sekeulele matunda ng'o!” Bahaja mbiki awo unyala gogodaa. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanahina zake viwonile avo wakanganya ng'hani, waiuza, “Habali mbiki uno wa mtini unyala himahima?” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawedika, “Nowalongeleni ukweli kamba mwahatogola na kuleka kunyawanyawa, modaha kutenda kamba kija kinitendile kwa mbiki uno wa mtini. Siyo kino kiiyeka, lakini modaha kukilongela kigongo kino, ‘Ng'oka ukayase mbahali,’ na yokuwa vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kamba mwahatogola, mobokela chochose chonda mupule.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kengila Mng'anda ya Mulungu, na viyakalile kofundiza, wakulu wa walava nhosa na wavele wamwizila wamuuza, “Vino kotenda gano gose kwa udahi wa nani? Nani yakugwelele udahi uno wa kutenda gano?” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawedika, “Nowauza mbuli imoja munilongele, na niye nowalongeleni kwa udahi wa nani notenda gano. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nongeleni, vino udahi wa Yohana wa kubatiza ulawa kwahi? Ulawa kwa Mulungu hebu ulawa kwa wanhu?” Wasonga kuilongela, “Twahalonga ulawa kwa Mulungu, kotuuza, ‘Habali hamumtogole Yohana?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lakini twahalonga, ‘Ulawa kwa wanhu,’ towadumba wanhu kwavija wose wamtogola Yohana kamba mtula ndagu wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Avo wamwidika Yesu, “Hatujuwile.” Abaho Yesu kawalongela, “Na niye siwalongela bule notenda gano kwa udahi wa nani.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mweye mogesaze? Munhu imoja kakala na wana wabili, kachola kwa ija mwana imkulu kamulongela, ‘Mwanangu, lelo chola ukasang'hane kumgunda wa mizabibu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nayo kamwidika, ‘Sichola bule.’ Lakini kumwande kidogo kagimbula na kuchola. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Abaho tata ija kachola kwa mwana iyagwe kamulongela mbuli iija. Nayo kamwidika, ‘Ona tata nochola,’ lakini hacholile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Avo nani mna iwana waja wabili yatendile kija kiyalondile tatao?” Wamwidika, “Ija mwana imkulu.” Avo Yesu kawalongela, “Nowalongeleni wabokela kodi na wagoni wowalongolela kwingila mna Undewa wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwavija Yohana Mbatizaji keza kuwalagusila nzila inogile, na mweye hamumtogole lakini wabokela kodi na wagoni wamtogola. Vivija na mweye vimonile avo, hamulekile nzambi zenu na kumtogola.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kalonga, “Tegelezeni lusimo luyagwe, kukala na munhu imoja mwene mgunda kahanda mizabibu mumgunda wake, kazungulusila lwigo, kahimba hanhu ha kukamila zabibu, kazenga lingo na kawakodisha walimaji. Abaho kafunga mwanza kachola isi ya kutali. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Msimu wa kubawa zabibu viuvikile, kawatuma wasang'hanaji zake kwa waja walimaji wamgalile zabibu kulawa mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Walimaji waja wawagoga wasang'hanaji awo, imoja wamtowa, iyagwe wamkoma, na iyagwe wamtowa mabwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kawatuma kabili wasang'hanaji wayagwe, wengi kubanza waja waichanduso, walimaji awo wawatendela vivija. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kukimambukizo kamtuma mwanage, kalonga, ‘Ino womtegeleza kwavija mwanangu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini walimaji viwamonile mwanage, wailongela, ‘Ino ayo muhazi lekeni tumkome na tusole uhazi wake!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Avo wamgoga na wamwasa kunze ya umgunda na wamkoma.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu kawauza, “Vino munhu mwene mgunda yaheza kowatenda choni waja walimaji?” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wamwidika, “Kowakoma walimaji wose wehile na kowakodisha wanhu wayagwe mgunda awo, nao womgolela zabibu mumsimu wa kubawa zabibu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kawalongela, “Hamusomile mna Gamaandiko Gang'alile, ‘Dibwe wadilemile wazengaji, sambi digalamuka dibwe kulu kubanza gose. Mbuli ino itendigwa na Mndewa nayo yotukanganya.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu kengeza kulonga, “Avo nowalongeleni ukweli, Undewa wa Mulungu wobokigwa kumwenu na wogweleligwa wanhu wolela matunda ganogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Munhu yoyose yonda yaikwale mdibwe ajo kobeneka beneka na munhu donda dimulagalile domuhonda tipitipi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulu wa walava nhosa na Mafalisayo viwahulike simo azo wajuwa kamba kakala kowalonga hewo. ");
INSERT INTO kdc2014_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Avo wazahila nzila ya kumgogela, lakini waludumba lunhu lwa wanhu, kwavija wamtogola Yesu kakala mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kalonga nao kabili kwa simo, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Undewa wa kuulanga uigala na kija kilawilile kwa mndewa yamtandile mwanage wa kimbigalo zengele. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawatuma wasang'hanaji zake wawalongele waja wagonekigwe weze kuna idizengele, lakini waja wagonekigwe walema kwiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Avo kawatuma wasang'hanaji wayagwe kawalongela, ‘Walongeleni vino waja wagonekigwe kuna idizengele, zengele jangu niditanda, nyhinja ng'ombe wanonile, kila kinhu nimala kukitanda goya. Izoni kuna idizengele!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini waja wagonekigwe hawatongile bule, kila munhu kachola kuna isang'hano yake, imoja kumgunda wake, na iyagwe kuna ibiashala yake. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wayagwe wawagoga wasang'hanaji zake, wawatowa na kuwakoma. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mndewa kagevuzika ng'hani, avo kawatuma wakalizi zake wakawakome waja wawakomile wasang'hanaji zake na wadisome moto buga jao. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Abaho kawakema wasang'hanaji zake na kawalongela, ‘Zengele jangu nimala kuditanda, lakini wanhu wagonekigwe kuna idizengele hawafaya kugonekigwa.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Avo choleni kuna izinzila na munhu yoyose yonda mumone mumgoneke yeze kudizengele. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Avo wasang'hanaji wachola mna izinzila na wawagala wanhu wose wawavikile, wanogile na wehile, avo gati da zengele dimema wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mndewa viyengile kuwalola wageni zake, kamona munhu imoja havalile kiwalo cha zengele. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamuuza, ‘Mbwigangu, kwingilaze muno kuno kuduhu kiwalo cha zengele?’ Lakini munhu ayo hamwidike bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Abaho mndewa kawalongela wasang'hanaji, ‘Mfungeni magulu na makono, mumwase kunze kudiziza ako kolila na kudafuna meno.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu kamambukiza kwa kulonga, “Wagonekigwe wengi, lakini wasaguligwe wadodo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafalisayo walawanya wamkalila kiseto Yesu wamgoge kwa mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wawatuma wanahina zao hamoja na wanhu wayagwe mna ikibumbila cha Helode. Walonga, “Mfundiza, tokujuwa gweye kwa munhu ulonga ukweli na kofundiza nzila za Mulungu mna ikweli. Humdumba munhu yoyose, kwavija hutonga ukulu wa munhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tulongele, gweye kokonaze? Vino vinoga kulipa kodi kwa Mndewa wa Lumi hebu havinogile bule?” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lakini Yesu kagajuwa magesa gao gehile, kawalongela, “Mweye mwa wanafiki, habali monigeza? ");
INSERT INTO kdc2014_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndagusileni isente imulipilaga kodi!” Nao wamgalila isente. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nayo kawauza, “Vino kihanga kino cha nani? Na twaga dino da nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nao wamwidika, “Va Mndewa wa Lumi.” Abaho Yesu kawalongela, “Mgweleleni Mndewa wa Lumi vili va Mndewa wa Lumi, na mgweleleni Mulungu vili va Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Viwahulike avo, wakanganya, wamuleka wasegela. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Siku didija Masadukayo wayagwe wanhu wolonga kuduhu kuzilibuka wamcholela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Walonga, “Mfundiza, Musa katulongela mbigalo yahafa yang'hali hanalela wana, ndugu yake kolondeka yamsole mgane ayo, muladi yalele nayo wana mbuli ya ndugu yake. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hano kumwetu kukala na ndugu saba. Ija imkulu kasola mwehe na kafa halekile wana, na mdodo wake kamuhala mgane ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kinhu kikija kimulawilila mwana wa kabili, wa kadatu mbaka wose saba. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ako kumwande, mtwanzi ija nayo kafa. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mna isiku ya kuzilibuka wanhu wafile, mtwanzi ayo kokuwa wa nani? Kwavija wose saba wakala wamsolile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kawedika, “Mweye mopotela! Kwavija hamugajuwile Maandiko Gang'alile hebu udahi wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwavija mna isiku ya kuzilibuka wanhu wafile, wanhu hawasola wala hawasoligwa wokuwa kamba wasenga wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini kwa mbuli ya kuzilibuka kwa wanhu, hamusomile kija kiyawalongele Mulungu? Kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Niye na Mulungu wa Abulahamu, Mulungu wa Isaka, Mulungu wa Yakobo.’ Heyo heli Mulungu wa wanhu wafile, ila Mulungu wa wanhu wagima.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lunhu lwa wanhu viluhulike avo, lukanganya kwa mafundizo gake. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo viwahulike kamba Yesu kawatenda Masadukayo wanyamale tuluu, waiting'hana hamoja, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","na imoja wao, kakala munhu yagajuwile goya Malagizo ga Musa, kamgeza Yesu kwa kumuuza, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mfundiza, mna Gamalagizo lagizo gani dili kulu?” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kamwidika, “ ‘Mnogele Mndewa Mulungu wako kwa moyo wako wose, kwa loho yako yose na kwa nzewele zako zose.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dino ijo lagizo dili kulu na da ichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Da kabili doigala na dino, ‘Mnogele miyago kamba viuinogela mwenyego.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagizo gose ga Musa na mafundizo ga watula ndagu wa Mulungu gema mna gamalagizo gano mabili.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo viwaiting'hane hamoja, Yesu kawauza, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Vino mweye mogesa choni kwa mbuli ya Kilisito? Mwanage nani?” Wamwidika, “Mwanage Daudi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kawauza, “Habali Loho Yang'alile kamulongoza Daudi yamkeme, ‘Mndewa’? Kwavija kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mndewa kamulongela Mndewa wangu, Kala hano mwambu wa mkono wangu wa kudila, mbaka niweke hasi mmagulu gako wanhu wakwihile.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kamba Daudi komkema ‘Mndewa’, yokuwaze Kilisito yawe mwanage Daudi?” ");
INSERT INTO kdc2014_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kuduhu munhu yamwidike, kulawa siku dijo na kugendelela kuduhu munhu yagezile kumuuza Yesu mbuli yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Abaho Yesu kalulongela ulunhu na wanahina zake, ");
INSERT INTO kdc2014_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","kawalongela, “Wafundiza Malagizo ga Musa na Mafalisayo wana udahi wa kufambula Malagizo ga Musa. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Avo gogeni na mtende gaja gose gonda wawalongeleni, lakini sekemutende gaja gowotenda hewo, kwavija hawatenda gaja gowopetela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wowadikwa wanhu mgamaega mbahasha ng'hulu na kuno hewo wenyego hawalonda kugolosa makono kuwataza kupapa. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gose gowotenda, wotenda muladi wakoneke na wanhu. Kwavija wovala vikumbi vandikigwe Maandiko Gang'alile mna ivihanga vao na wofunga mna gamakono gao, na wovala viwalo vili na vinhu vitali woneke kamba wailava kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wonogelwa kukala hanhu hanogile mna izinyimwili nyimwili na kukala mna ivigoda va haulongozi mna izing'anda za kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wonogelwa kulamusigwa na wanhu mna gamagulilo na kukemigwa na wanhu, ‘Mfundiza’. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini mweye sekemukemigwe ‘Mfundiza’. Kwavija mweye mwa wanhu wa lubuga lumoja na Mfundiza wenu imoja. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sekemumkeme munhu yoyose hano mwiisi, ‘Tata’, kwavija munayo Tata imoja yeli kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Vivija sekemukemigwe ‘Walangulizi’, kwavija munayo mulangulizi imoja, nayo ayo Kilisito Mkombola ");
INSERT INTO kdc2014_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yeli mkulu hagati yenu yawe msang'hanaji wenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Munhu yoyose yoitenda mwenyego mkulu kotendigwa mdodo, na munhu yoyose yoitenda mwenyego mdodo kotendigwa mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Mohinda mulango wa Undewa wa kuulanga mgameso ga wanhu, kuno mweye wenyego hamwingila, wala hamulonda kuwatogolela waja wolonda kwingila wengile! ");
INSERT INTO kdc2014_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Mosola vinhu vili mzikae za wagane, abaho moitenda munoga kwa kulonga mbuli nyingi mwahampula Mulungu! Mbuli ya gano nhaguso yenu yokuwa ng'hulu ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Moloka bahali na kuchola mziisi muladi mumpate munhu wa kutogola kamba vimutogola mweye, na mwahampata momtenda yehe miyanza mibili kubanza mweye kwa kwiingila jehanamu! ");
INSERT INTO kdc2014_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mogaya mweye walangulizi hamulola! ‘Mofundiza munhu yahaiduila kwa Ng'anda ya Mulungu siyo mbuli. Lakini yahaiduila kwa zahabu ili Mng'anda ya Mulungu, koifunga mwenyego.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mweye hamulola na wabozi! Kilihi kili kikulu, zahabu hebu Ng'anda ya Mulungu iitenda zahabu ing'ale? ");
INSERT INTO kdc2014_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vivija mweye mofundiza, ‘Munhu yahaiduila kwa upango wa kulavila nhosa siyo mbuli, lakini yahaiduila kwa nhosa ili muupango, koifunga mwenyego.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mweye hamulola! Kilihi kili kikulu, inhosa hebu uupango wa kulavila nhosa uitenda inhosa ing'ale? ");
INSERT INTO kdc2014_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Avo munhu yahaiduila kwa upango wa kulavila nhosa, koiduila kwa upango wa kulavila nhosa hamoja na nhosa yose ili uchanha yake, ");
INSERT INTO kdc2014_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","na ija yoiduila kwa Ng'anda ya Mulungu, kaiduila kwa Ng'anda ayo ya Mulungu na kwa Mulungu yokala mumo. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yoyose yoiduila kwa ulanga, koiduila kwa kigoda cha undewa cha Mulungu na kwa ayo yokikalila. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mogaya mweye wafundiza Malagizo na Mafalisayo, mweye mwa wanafiki! Momgwaa Mulungu fungu da longo da majani gonung'hila goya, binzali na kalafuu, lakini moleka kugagoga mafundizo makulu ga Malagizo, kamba vija haki, bazi na kutamanila. Molondeka kugatenda gano na sekemugaleke gaja gayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mweye walangulizi hamulola! Molava ng'honzi mgamazi lakini momeza mhunda! ");
INSERT INTO kdc2014_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Mosunha kikasi na sahani kwa kunze, lakini moleka mgati mmema vinhu vimpatile kwa kuboka na ugila. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gweye Mfalisayo hulola! Tanhu sunha mgati ya kikasi na kunze kokuwa kuzelu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Muigala na vikuta va mapanga vibakigwe langi nzelu, kwa kunze gokoneka ganoga, lakini mgati gamema mizege ya wanhu wafile na kila kinhu kihile. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Vivija na mweye kwa kunze mokoneka kamba wanhu munogile, lakini mgati mmwenu mmema unafiki na nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mogaya mweye wafundiza Malagizo ga Musa na Mafalisayo, mweye mwa wanafiki! Mozengela vikuta va mapanga ga watula ndagu wa Mulungu na kugahamba mapanga ga wanhu wanogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mweye molonga maza tukalile mna ikipindi cha wahenga zetu, sambituilumbe nao kuwakoma watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Avo moilagusa wenyego kamba mwa wazukulu wa hewo wawakomile watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Avo mambukizeni kija wakisongile wahenga zenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mweye mizoka na wana wa mizoka! Modahaze kuikimbila nhaguso ya jehanamu? ");
INSERT INTO kdc2014_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Avo nowagalila watula ndagu wa Mulungu na wanhu weli na nzewele, na wafundiza. Wayagwe mowakoma, wayagwe mowawamba na wayagwe mowatowa mbalati mna zing'anda za kumpula Mulungu na kuwawinga kulawa buga dino wachole buga diyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Avo damu yose ya wanhu wanogile itike mwiisi yodaigwa kumwenu, kusongela damu ya Habili ija yakalile yanogile, mbaka damu ya Zakalia mwana wa Balakia yumumkomile hagati ya Ng'anda ya Mulungu na upango wa kulavila nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nowalongeleni ukweli, nhaguso ya ukomaji wose uno yokuwa mna iwanhu wa lukolo luno! ");
INSERT INTO kdc2014_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Gweye Yelusalemu, Gweye Yelusalemu! Kowakoma watula ndagu wa Mulungu na kuwatowa kwa mabwe waja Mulungu yawatumile kumwako! Miyanza mingapi nilonda kuwahagata wanago kwa makono gangu, kamba vija nguku viyovihagata vinziya vake mna gamabawa gake, lakini hulondile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Avo Ng'anda yako ya Mulungu ilekigwa ukiwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nowalongeleni, honda mumbone kabili mbaka vonda mulonge, ‘Mulungu yamtambikile ija yokwiza kwa twaga da Mndewa.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu viyakalile kolawa Mng'anda ya Mulungu, wanahina zake wamcholela, wamulagusile ng'anda zili behi na Ng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kawauza, “Mogona gano gose? Nowalongela ukweli, haduhu dibwe donda dilekigwe uchanha ya diyagwe, kila dibwe dokwasigwa hasi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu viyakalile kuna Ulugongo lwa Mizeituni, wanahina zake weli waiyeka wamgendela, wamuuza, “Tulongele, yolawilila lini? Na choni chondakitendeke kulagusa kwiza kwako na kimambukizo cha isi?” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kawedika, “Muiteganye, munhu yoyose sekeyawavizile. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwavija wanhu wengi wokwiza kwa twaga jangu na kulonga, ‘Niye ayo Kilisito!’ Nao wowavizila wanhu wengi. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mohulika ng'hondo na mbuli zake, lakini sekemudumbe, kwavija gano gose golondigwa galawilile, ila kimambukizo king'hali kuvika. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi yoitowa na isi iyagwe, undewa woitowa na undewa uyagwe. Kila hanhu hokuwa na lufilili lwa nzala na mitigisiko mikulu ya isi. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gano gose kamba mwanduso wa usungu wa kulela mwana. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Abaho mogogigwa, modununzigwa na kukomigwa. Wanhu wa isi zose wowehila mbuli ya niye. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kipindi acho wanhu wengi woleka kutamanila kwao, woihinduka na woihila, ");
INSERT INTO kdc2014_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","na watula ndagu wengi wa uvizi wolawilila na kuwavizila wanhu wengi. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mbuli ya kongezeka kwa gehile, unogelwa wa wanhu wengi wohunguka, ");
INSERT INTO kdc2014_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","lakini munhu yonda yafunge umoyo mbaka kukimambukizo kokomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na kimambukizo king'hali hakinavika, Mbuli Inogile ya Undewa yopetigwa kwa wanhu wa kabila zose iwe usindila kwa isi zose. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Muhachona, ‘Kinhu kinyolodoke kigala Ubananzi’ kilongigwe na mtula ndagu wa Mulungu Danieli, kima Mng'anda ya Mulungu. Ija yosoma yajuwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Abaho wanhu weli mwiisi ya Yudea wakimbilile kuna ikigongo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Munhu yeli mkiswili cha ng'anda yake, sekeyahumuluke hasi mna ing'anda yake kusola kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yeli kumgunda sekeyabwele ukae kusola kiwalo chake. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wogaya watwanzi wali na zinda na waja wokong'heza mna izisiku azo. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mpuleni Mulungu muladi sekemukimbile mumsimu wa kihuhwe hebu mna isiku ya Kubwihila! ");
INSERT INTO kdc2014_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwavija siku ayo kokuwa na magayo makulu, haganalawila toka kuumbigwa kwa isi mbaka sambi na honda galawilile kabili. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mulungu kazihunguza siku azo, maza hazihunguze sambi yahone munhu yoyose. Lakini mbuli ya wanhu zake yawasagule, Mulungu kozihunguza siku azo. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Avo, munhu yoyose yahawalongela, ‘Amweye, Kilisito Mkombola kahano!’ hebu ‘Ka ako!’ sekemutogole. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwavija wolawilila makilisito na watula ndagu wa uvizi, wotenda unzonza na vilaguso muladi yahadahika wawavizile hata waja wasaguligwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tegelezeni! Niwalongela mbuli zino kipindi king'hali hakinavika.” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Avo munhu yoyose yahawalongela, ‘Loleni, kakuja kuluwala!’ sekemuchole, hebu yahalonga, ‘Loleni, kaifisa hano!’ sekemutogole. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kamba vija lumwesa lumwemwesa ulanga wose kulawa kudilawila zuwa mbaka kudihongela vivo vonda yoneke Mwana wa Munhu yaheza.” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kokose kuli na mzoga, baho hoiting'hana mhungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Gahamala magayo ga siku azo, zuwa dokuwa ziza, mwezi honda umwemwese bule, nhondo zolagala kulawa kuulanga, na vinhu vili kuulanga votigisika. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Abaho kilaguso cha Mwana wa Munhu cholawilila kuulanga, wanhu wa mwiisi wolila vonda wamone Mwana wa Munhu kokwiza mna gamawingu ga kuulanga kwa nguvu na ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mhalati yotoigwa, na kowatuma wasenga zake wa kuulanga mna izibanzi nne za mwiisi, nao woweka hamoja wanhu zake yawasagule kulawa mwambu uno wa isi na uyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ifunzeni kubitila mbiki wa mtini, matambi gake gahasonga kuzuka na kwika majani, mujuwe kamba vuli da mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Vivija, mwahazona mbuli azo, mojuwa kamba kammabehi kwiza. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nowalongeleni ukweli, wanhu wa lukolo luno hawafa wose mbaka gano gose galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ulanga na isi vobita, lakini mbuli zangu hondazibite ng'o. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kuduhu yaijuwile siku hebu saa ya kwiza, siyo wasenga wa kuulanga wala Mwana, lakini Tata yaiyeka ayo yaijuwile. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwiza kwa Mwana wa Munhu kuigala na kija kilawilile kipindi cha Nuhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwavija kipindi kija ing'hali hainatowa mvula ng'hulu wanhu waja na kung'wa, wanhu wasola na kusoligwa, mbaka mna isiku ija Nuhu viyengile mna idisafina. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Lakini wanhu hawajuwile chondakilawilile mbaka mvula ng'hulu viitowile na kuwafagila wose. Vivo vondaiwe kipindi Mwana wa Munhu yaheza. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kipindi acho wanhu wabili wokuwa kumgunda, imoja kosoligwa na iyagwe kolekigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Watwanzi wabili wokuwa woduga, imoja kosoligwa na iyagwe kolekigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Avo muiteganye, kwavija hamuijuwile siku ya kwiza Mndewa wenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini mujuwe vino, maza mwene ng'anda yahaijuwile siku ya kwiza mbavi, yahakalile meso na sambi yamuleke mbavi yaitule ng'anda yake. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Avo, muitande siku zose, kwavija Mwana wa Munhu kokwiza mna isaa hamuigesile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nani yeli msang'hanaji yotamaniligwa na yeli na nzewele? Ayo ija mkulu wake kamwika yawalolese goya wasang'hanaji wayagwe na kuwagwaa lujo mna isaa inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kamweda msang'hanaji ija kamba mkulu wake yahabwela komvika kosan'hana vivo! ");
INSERT INTO kdc2014_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nowalongela ukweli, mkulu wake komwika msang'hanaji ayo yawe mulolesaji wa vinhu vake vose. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini yahawa msang'hanaji hatamaniligwa, koilongela mwenyego, ‘Mkulu wangu kokawa kubwela,’ ");
INSERT INTO kdc2014_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na kosonga kuwatowa wasang'hanaji wayage na kuja na kung'wa hamoja na walevi. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Abaho mkulu wake kobwela mna isiku msang'hanaji ija haigesile na mna isaa haijuwile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mkulu ayo komtowa ng'hani na kumwika hamoja na wanafiki. Baho kolila na kudafuna meno.” ");
INSERT INTO kdc2014_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Undewa wa kuulanga woigala na kija kilawilile kwa weli longo wasolile taa zao na kuchola kumbokela munhu yosola. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wali watano wakala wabozi na watano wakala wabala. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Waja iwabozi wasola taa zao, lakini hawasolile ngama yoyose ya mavuta. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Waja iwabala wasola nyhupa zimemile za mavuta hamoja na taa zao. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Munhu yosola viyakawile kwiza, wali wose wasonga kukukila na wawasa. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kilo kikulu, kulawilila nyangi, ‘Msola mwehe kavika! Laweni mukambokele!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wali wose walamuka wazitanda taa zao. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Waja iwabozi wawalongela waja iwabala, ‘Mtuhunguzile mavuta genu kidogo kwavija taa zetu zolonda kufa.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini waja iwabala wawedika, ‘Bule, tuduhu mavuta gakutwenela tweye na mweye. Vinoga muchole mkagule genu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Avo waja iwabozi wachola kugula mavuta, viwakalile wochola, munhu yosola kavika. Waja watano waitandile wengila nayo mna ing'anda ya dizengele, lwivi luhindigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kumwande kidogo waja iwali wabozi wavika, wasonga kukemelela, ‘Go mkulu, go mkulu! Tuvugulile!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ayo yosola kawedika, ‘Bule! Niye siwajuwile bule mweye.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu kamambukiza kwa kulonga, “Muiteganye, kwavija hamuijuwile siku hebu saa. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Vivija Undewa wa kuulanga uigala na kija kilawilile kwa munhu imoja yafungile mwanza, kawakema wasang'hanaji zake kaweka walole goya vinhu vake. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kila imoja kamgwaa kamba viyadahile, imoja kamgwaa mifuko mitano ya sente, iyagwe kamgwaa mifuko mibili ya sente, na iyagwe kamgwaa mfuko umoja wa sente. Abaho kachola mwanza wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Msang'hanaji yagweleligwe mifuko mitano ya sente kachola kazisang'hanila zisente kapata mifuko mitano iyagwe ya sente. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vivija msang'hanaji yagweleligwe mifuko mibili ya sente kazisang'hanila na kupata mifuko mibili iyagwe ya sente. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini msang'hanaji yagweleligwe mfuko umoja wa sente, kachola kauhimbila mfuko wa sente wa mkulu wake. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vizibitile siku nyingi mkulu wao awo iwasang'hanaji kabwela kapeta zisente hamoja nao. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Msang'hanaji yagweleligwe mifuko mitano ya sente keza kagala mifuko mitano iyagwe ya sente, kalonga, ‘Go mkulu, kunigwaa mifuko mitano ya sente, lola mhata mifuko mitano iyagwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mkulu wake kalonga, ‘Kutenda goya, msang'hanaji unogile na utamaniligwa! Kwavija kotamaniligwa kwa kulolesa vinhu vidodo, avo nokwika ulolese vinhu vingi. Wize udeng'helele hamoja na niye!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Abaho msang'hanaji ija yagweleligwe mifuko mibili ya sente keza kalonga, ‘Go mkulu, kunigwaa mifuko mibili ya sente, lola mhata mifuko mibili iyagwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mkulu wake kalonga, ‘Kutenda goya, msang'hanaji unogile na utamaniligwa! Kwavija kotamaniligwa kwa kulolesa vinhu vidodo, avo nokwika ulolese vinhu vingi. Wize udeng'helele hamoja na niye!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Abaho msang'hanaji ija yabokele mfuko umoja wa sente keza, kalonga, ‘Go mkulu, nikujuwa gweye kuna gahigahi, kosenga hanhu huhahandile, kokwika hamoja indiya hanhu huhamizile mbeyu. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Avo nidumba, nyhola niuhimbila mfuko wako wa sente. Lola, uno awo mfuko wako wa sente.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mkulu wake kamwidika, ‘Gweye kwa msang'hanaji wihile na mnyeke! Ona, kujuwa nosenga hanhu sihahandile na kwika hamoja hanhu sihamizile mbeyu. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wahawikile mfuko wangu wa sente kwa iwanhu wokwika sente, muladi vonda mbwele na niye nyambulile faida. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sambi baha, mbokeni umfuko wa sente mumgwee ayo yeli na mifuko longo ya sente. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwavija munhu yoyose yeli na kinhu kokongezelwa, lakini ija yeliduhu kinhu, kobokigwa hata kija kidodo kiyelinacho. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na msang'hanaji ino yehile mwaseni kunze kudiziza, ako kolila na kudafuna meno.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana wa Munhu yeli Mndewa vonda yeze muukulu wake, hamoja na wasenga zake wa kuulanga, kokala mkigoda chake cha undewa. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wanhu wose mwiisi woiting'hana haulongozi wake, nayo kowabagula kamba msusilaji viyowabagula ng'hondolo na mbuzi. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nayo koweka wanhu watendile goyolonda Mulungu mwambu wa mkono wake wa kudila na wanhu watendile gehile mwambu wa kumoso. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abaho Mndewa kowalongela waja wakalile mwambu wa mkono wake wa kudila, ‘Izoni mweye munogeligwe na Tatangu! Bokeleni uhazi wenu, undewa umutandiligwe tangu kuumbigwa kwa isi. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ng'hala na nzala mweye mungwaa lujo, ng'hala na ng'hilu mweye mungwaa mazi, ng'hala mgeni mweye mumbokela mzing'anda zenu. ");
INSERT INTO kdc2014_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ng'hala mwazi mweye mumvaza, ng'hala mtamu mweye mwiza kundola, ng'hala ngodekigwe mkifungo mweye mwiza kundola.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wanhu watendile goyolonda Mulungu womwidika, ‘Mndewa, kipindi gani tukona kuna nzala na tukugwaa lujo, hebu kuna ng'hilu na tukugwaa mazi? ");
INSERT INTO kdc2014_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kipindi gani viukalile mgeni na tukubokela mzing'anda zetu, hebu viukalile mwazi na tweye tukuvaza? ");
INSERT INTO kdc2014_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kipindi gani tukona mtamu hebu kugodekigwa mkifungo, twiza kukulola?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mndewa kokwidika, ‘Nowalongela fulu ipile, chochose kimumtendele imoja wa ndugu zangu awo weli wadodo, munhendela niye!’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Abaho kowalongela waja weli mwambu wa kumoso, ‘Segeleni kumwangu, mweye muduiligwe! Muchole kuna umoto haufaga, uyekiligwe Mwenembago na wasenga zake! ");
INSERT INTO kdc2014_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ng'hala na nzala mweye hamungwelele lujo, ng'hala na ng'hilu mweye hamungwelele mazi, ");
INSERT INTO kdc2014_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ng'hala mgeni mweye hamumbokele bule mzing'anda zenu, ng'hala mwazi mweye hamnivazile bule, ng'hala mtamu na mkifungo mweye hamwizile kundola.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Abaho womwidika, ‘Mndewa, kipindi gani tukona kuna nzala hebu ng'hilu hebu kwa mgeni hebu kwa mwazi hebu kwa mtamu hebu mkifungo na tweye hatukutazile bule?’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mndewa kokwidika, ‘Nowalongela fulu ipile, chochose hamumtendele imoja wa wanhu awo iwadodo, hamunhendele niye.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wano wogaligwa kuna ukugaya kwa mazuwa gose, lakini waja watendile goyolonda Mulungu wogenda kuna uugima wa mazuwa gose.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu viyamambukize kuwafundiza mbuli zino zose, kawalongela wanahina zake, ");
INSERT INTO kdc2014_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kamba vimujuwile zahabita siku mbili kokuwa na nyimwili nyimwili ya Pasaka, abaho Mwana wa Munhu kogogigwa muladi yawambigwe mumsalaba.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Abaho wakulu wa walava nhosa na wavele waiting'hana hamoja mna uluhelengo lwa Mkulu wa walava nhosa, yakemigwe Kayafa. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na wakala kiseto wamgoge Yesu kinyelegezi abaho wamkome. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Walonga, “Lakini seketutende avo kipindi cha nyimwili nyimwili ya Pasaka, buleavo wanhu woding'huka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu kakala Betania mng'anda ya Simoni, munhu yakalile na utamu wa dikulu. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu viyakalile koja, mtwanzi imoja kamcholela na nyhupa ya alabasita imemile mavuta gonung'hila goya ga bei ng'hulu, kamgidila Yesu mdipala. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanahina viwonile avo wagevuzika. Wauza, “Unanzi gani uno?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Mavuta gano gahauzigwe kwa bei ng'hulu na zisente wahagweleligwe wakiwa!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu kajuwa kiwakalile wolonga, avo kawalongela, “Habali momgaza mtwanzi ino? Niye kanitendela mbuli inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wanhu wakiwa mokala nao siku zose, lakini honda mukale na niye siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Viyakalile yonigidila mavuta mulukuli lwangu, kalutanda lukuli lwangu kwa kuzikigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Avo nowalongeleni ukweli, kokose konda ipetigwe Mbuli Inogile mwiisi, kino kiyatendile mtwanzi ino cholongigwa, avo wanhu womkumbuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Abaho imoja wa wanahina longo na wabili yakemigwe Yuda Isikaliote kachola kwa wakulu wa walava nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kawauza, “Monigwaa sente ngapi nahamuhinduka Yesu kumwenu?” Avo wampetela sente malongo madatu wamgwaa. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kusongela aho Yuda kazahila nzila ya kumwika Yesu mmakono gao. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mna isiku ya ichanduso ya Nyimwili nyimwili ya Magate hagageligwe Usasu, wanahina wamcholela Yesu wamuuza, “Kolonda tukutandile kwahi lujo lwa Pasaka?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu kawalongela, “Choleni kunadibuga kwa munhu imoja, na mumulongele, ‘Mfundiza kolonga, saa yangu ivika, niye na wanahina zangu todeng'helela Pasaka mng'anda yako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanahina watenda kamba Yesu viyawalongele, walutanda lujo lwa Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Viivikile ichungulo, Yesu na wanahina zake longo na wabili wakala hasi waje. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Viwakalile woja Yesu kawalongela, “Nowalongela ukweli, imoja wenu konihinduka.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanahina zake wanyawanyawa, wasonga kumuuza, imoja imoja, “Mndewa, kolonga niye?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kawedika, “Ija yozanhika tonge mbakuli hamoja na niye ayo yonda yanihinduke. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Munhu kofa kamba Maandiko Gang'alile vigolonga, lakini kogaya munhu ija yomuhinduka Mwana wa Munhu! Yahanogile ng'hani kamba munhu ayo sambi yavumbuke.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ayo yonda yamuhinduke Yesu, kamuuza, “Mfundiza! Vino kolonga niye?” Yesu kamwidika, “Ona, iyo gweye kamba viulongile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Viwakalile woja, Yesu kasola gate, kamgwaa nhogolwa Mulungu, abaho kadibanzula, kawagwaa wanahina zake, kalonga, “Soleni muje, uno ulo lukuli lwangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Abaho kasola kikasi cha divai, kamgwaa nhogolwa Mulungu, kawagwaa wanahina zake, kalonga, “Mose ing'wileni kikasi kino. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ino ayo damu yangu ya lagano, ikwitika mbuli ya wengi muladi nzambi zao zigeligwe kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nowalongela, kusongela sambi honda ning'we kabili divai mbaka siku ija vondaning'we divai ya sambi na mweye Muundewa wa Tatangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Abaho wemba lwila, wachola kuna Ulugongo lwa Mizeituni. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abaho Yesu kawalongela, “Kilo cha lelo mweye mose mokimbila na kundeka niiyeka, kwavija yandikigwa, Mulungu kalonga, ‘Nomtowa Msusilaji, na bumbila da ng'hondolo dopwililika.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini nahazilibuka, nowalongolela kuchola Galilaya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo kamwidika, “Hata kamba wose wahakuleka, niye sikuleka bule!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamulongela Petulo, “Nokulongela ukweli, kilo cha lelo, nzogolo yang'hali hana kwika konibela miyanza midatu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo kamwidika, “Silonga avo bule, hata kamba nahafa na gweye!” Na wanahina wayagwe walonga vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Abaho Yesu na wanahina zake kachola hanhu hokemigwa Getisemane, kawalongela, “Kaleni hano, niye nogenda haja kumpula Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kawasola Petulo na wana wabili wa Zebedayo. Kasonga kona usungu na kunyunyuwala. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ako kawalongela, “Usungu uli muumoyo wangu mkulu ng'hani wodaha kung'homa. Kaleni hano meso hamoja na niye.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Abaho kachola hamwande kidogo, kaibwanha hasi, kampula Mulungu, “Tatangu, kamba yahadahika, unisegezele kikasi kino cha madununzo! Lakini siyo kamba vinilonda niye, ila viulonda gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Abaho kabwela kawavika waja wanahina zake wadatu wawasa, kamulongela Petulo, “Vino hamudahile kukala meso na niye hata saa dimoja? ");
INSERT INTO kdc2014_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kaleni meso mumpule Mulungu sekemwingile mna ukugezigwa, moyo wa munhu wolonda kutenda ganogile, lakini lukuli lwaduhu nguvu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kachola lwa kabili kumpula Mulungu, kalonga, “Tatangu, kamba haidahika kukisegeza kikasi kino cha madununzo mbaka niking'wile, viulonda gweye ilawilile.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Viyabwelile kabili kawavika wanahina zake wawasa, kwavija meso gao gakala na utulo. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Abaho Yesu kawaleka kabili, kachola kampula Mulungu mwanza wa kadatu, kalonga mbuli zizija. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kawabwelela wanahina zake kawauza, “Mung'hali muwasa na kubwihila? Loleni, kipindi cha Mwana wa Munhu kwikigwa mmakono ga wanhu wene nzambi kivika. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukeni, tuchole! Loleni, munhu yonihinduka kavika!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu yang'hali kogendelela kulonga, imoja wa wanahina zake longo na wabili, yakemigwe Yuda Isikaliote kavika. Keza na lunhu lutumigwe na wakulu wa walava nhosa na wavele kuno wapapa mapanga na malungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ayo yomuhinduka Yesu kawagwaa kilaguso, kawalongela, “Munhu yonda nimnonele ayo yummulonda. Mgogeni!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bahaja Yuda kamcholela Yesu kalonga, “Mfundiza, zihoze.” Abaho kamnonela. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamwidika, “Mbwiga, tenda kikugalile!” Abaho weza wamgoga Yesu, wamgodeka. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Imoja wa waja wakalile na Yesu, kasomola panga jake kamkanha digwiti msang'hanaji wa Mkulu wa walava nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamulongela, “Bweza panga jako muna iyala, kwavija munhu yoyose yoitowa na miyage kwa panga kofa kwa panga. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Vino hamujuwile bule maza nilondile nahampulile Tatangu yanhaze, nayo bahobaho yahagalile mabumbila makulu kubanza longo na mabili ga wasenga wa kuulanga wanhaze? ");
INSERT INTO kdc2014_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini golawililaze Maandiko Gang'alile golonga, yolondeka ilawilile?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Abaho Yesu kalulongela ulunhu, “Mwiza kungoga na mapanga na malungu kamba vija nambavi? Kipindi chose ng'hala nifundiza Mng'anda ya Mulungu, lakini hamngogile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mbuli zino zitendeka muladi Maandiko Gang'alile gawandike watula ndagu wa Mulungu galawilile.” Baho wanahina wose wamuleka wakimbila. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Waja wamgogile Yesu wamgala mng'anda ya Kayafa, yakalile Mkulu wa walava nhosa, baho wafundiza Malagizo ga Musa na wavele waiting'hana hamoja. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo kamkweleleza kwa kutali mbaka kuuluwa lwa Mkulu wa walava nhosa, kengila mgati kakala hamoja na wakalizi muladi yalole choni cholawilila. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wakulu wa walava nhosa na wanhu wa mkitala cha Wayahudi wazahila usindila wa uvizi wamkome Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wanhu wayagwe weza kulonga uvizi mbuli yake, lakini hawapatile mbuli yoyose. Abaho wanhu wabili walawilila, ");
INSERT INTO kdc2014_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","walonga, “Munhu ino kalonga, ‘Noibomola Ng'anda ya Mulungu na kuizenga kabili kwa siku ndatu.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mkulu wa walava nhosa kenuka kamulongela Yesu, “Kuduhu cha kuwedika kwa kitala choolava wanhu wano?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu kanyamala tuluu, Mkulu wa walava nhosa kamulongela, “Kwa twaga da Mulungu yeli mgima nolonda uiduile, tulongele kamba gweye kwa Kilisito Mkombola, Mwana wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kamwidika, “Ona, vivo viulonga. Lakini nowalongeleni wose, kulawa sambi momona Mwana wa Munhu kakala muukulu mwambu wa mkono wa kudila wa Mulungu yeli na udahi, kokwiza mna gamawingu ga kuulanga!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bahaja Mkulu wa walava nhosa kakidega kiwalo chake, kalonga, “Kaliga! Hatulonda usindila uyagwe? Mumuhulika viyaligile! ");
INSERT INTO kdc2014_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mweye mogesaze?” Awo wamwidika, “Kabananga, kolondeka yakomigwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Abaho wamtemela mate mna ikihanga wamtowa, na wayagwe wamtowa ng'hofi. ");
INSERT INTO kdc2014_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kuno wolonga, “Gweye Kilisito Mkombola lagula. Nani yakutowile?” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo kakala yakalile mulubuga, msang'hanaji wa kitwanzi kamcholela, kamulongela, “Gweye vivija kukala hamoja na Yesu wa Galilaya.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini Petulo kabela haulongozi ha wose, kalonga, “Sikijuwile kiulonga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Viyakalile kolawa kunze ya umulango, ako kaiting'hana na msang'hanaji iyagwe wa kitwanzi kamona na kawalongela wanhu, “Munhu ino nayo kakala hamoja na Yesu wa Nazaleti.” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo kabela kabili, kalonga, “Noiduila simjuwile munhu ino!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hamwande kidogo, wanhu wakalile wemile aho wamcholela Petulo wamulongela, “Kweli gweye vivija kwa imoja wao, kwavija ulonzi wako wolagusa kamba gweye kolawa Galilaya!” ");
INSERT INTO kdc2014_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Abaho Petulo kalonga, Mulungu kojuwa nolonga ukweli, niduiligwe nahalonga uvizi, “Simjuwile munhu ayo!” Bahaja nzogolo keka ");
INSERT INTO kdc2014_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","na Petulo kakumbuka mbuli ziyalongeligwe na Yesu, “Nzogolo yang'hali hana kwika konibela miyanza midatu.” Kachola kunze kalila kwa usungu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Imitootondo, wakulu wa walava nhosa wose na wavele wakala kiseto cha kumkoma Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wamgodeka nzabi, wamulongoza na wamwika mmakono ga Pilato, mkulu wa isi ya Lumi. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda, ija yamuhinduke Yesu, viyonile Yesu katagusigwa, kona usungu kazibweza zisente malongo madatu kwa wakulu wa walava nhosa na wavele. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kawalongela, “Nhenda nzambi kwa kumuhinduka munhu yatendile ganogile yakomigwe!” Lakini wao wamwidika, “Ajo jako wiiyeka, tweye twamduhu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda kazasa zisente Mng'anda ya Mulungu kasegela, abaho kachola kaibota mwenyego kwa luzabi. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulu wa walava nhosa wazidondola zisente walonga, “Malagizo getu gogomesa kuzika sente zino mna ikiya cha kwikila sente kili Mng'anda ya Mulungu, kwavija sente zino za damu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Abaho waitogolela, wasola zisente wagula mgunda wa mulumba, uwe hanhu ha kuzikila wageni. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lekaavo mbaka lelo mgunda awo wokemigwa, “Mgunda wa Damu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Avo kilawilila kija kiyalongile mtula ndagu wa Mulungu Yelemia, “Wasola sente malongo madatu, sente ziwaitogolele wanhu wa Izilaeli kumulipa. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wazigulila mgunda wa mulumba, kamba Mndewa viyanilagize.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu kema haulongozi wa mkulu wa isi, nayo kamuuza, “Gweye kwa Mndewa wa Wayahudi?” Yesu kamwidika, “Ona, vivo viulonga.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini wakulu wa walava nhosa na wavele viwamulavile vitala, Yesu hawedike mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Avo Pilato kamuuza, “Vino gweye huhulika vitala vose viwolonga kumwako?” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini Yesu hedike mbuli yoyose, na mkulu ayo kakanganya ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yahavikaga Nyimwili nyimwili ya Pasaka mkulu wa isi komfungulila mfungwa imoja, wamulondile wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mna ikipindi acho kukala na mfungwa imoja yajuwike ng'hani, twaga jake Balaba. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Avo lunhu lwa wanhu viluiting'hane, Pilato kawauza, “Molonda nimfungulile nani? Balaba hebu Yesu yokemigwa Kilisito Mkombola?” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato kajuwa goya kamba Wayahudi wamgela Yesu mmakono gake, kwavija wamonela migongo. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato viyakalile mna ikigoda cha nhaguso, mwehe wake kamtumila usenga, “Sekeumtendele chochose munhu ayo hatendile gehile, kwavija nigaya ng'hani mzinzozi mbuli yake.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakini wakulu wa walava nhosa na wavele, waluding'hula lunhu lwa wanhu lumpule Pilato yamfungulile Balaba na kumkoma Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato kaluuza kabili lunhu luja, “Mna iwano wabili molonda nimfungulile nani?” Wamwidika, “Balaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kawauza, “Nhende choni kwa Yesu yokemigwa Kilisito Mkombola?” Wamwidika, “Muwambe mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kawauza, “Vino katenda kinhu gani kihile?” Lakini wao wagendelela kukemelela, “Muwambe mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato viyone hadaha kutenda mbuli yoyose, na wanhu wasonga kuding'huka, kasola mazi, kasunha makono gake mgameso ga lunhu luja, kalonga, “Niye namduhu kwa damu ya munhu ino, ajo jenu wenyego!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lunhu lose lwa wanhu lwidika, “Damu yake ikale uchanha yetu na uchanha mwa wanetu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato kamfungulila Balaba, abaho kalagiza Yesu yatoigwe mbalati na kamgela mmakono gao yawambigwe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abaho wakalizi wa Pilato wamgala Yesu mng'anda ya Mndewa, na wakalizi wose wamzunguluka. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wamvula viwalo vake na wamvaza kiwalo cha undewa. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Waluka ngata ya miba waika mdipala jake, na mkongoja mumkono wake wa kudila. Abaho wamfugamila kwa kumzeha, walonga “Mwinyi, Mndewa wa Wayahudi!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Abaho wamtemela mate na wasola umkongoja wamtowa towa nao mdipala. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Viwamambukize kumzeha, wamvula ikiwalo cha undewa wamvaza viwalo vake. Abaho wamgala yawambigwe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Viwakalile wochola, wamting'hana munhu imoja mwenekae wa Kilene, twaga jake Simoni, wakalizi wamnanahiza yaupape msalaba wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wavika hanhu hokemigwa Goligota, fambulo jake, “Hanhu ha Fumvu da Pala”. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamgwaa Yesu divai ihanganyigwe na kinhu kili usungu, lakini viyailanzile, kalema kung'wa. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wamuwamba Yesu mumsalaba, waigolela viwalo vake kwa kubwanha simbi. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Abaho wakala hasi womkaliza. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uchanha ya msalaba wake wakika kibao chandikigwe kilamuso cha kutagusigwa kwake, “Ino ayo Yesu, Mndewa wa Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Abaho wawawamba wabavi wabili hamoja na Yesu, imoja mwambu wa mkono wake wa kudila na iyagwe mwambu wa kumoso. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wanhu wakalile wobita watigisa mapala gao na kumuliga Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Walonga, “Hambe gweye kulonga koibomola Ng'anda ya Mulungu na kuizenga kabili kwa siku ndatu! Lelo humuluka mumsalaba uikombole mwenyego kamba gweye kwa Mwana wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Vivija wakulu wa walava nhosa na wafundiza Malagizo ga Musa na wavele wamzeha Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Walonga, “Kawakombola wayagwe, lelo hadahile vilihi kuikombola mwenyego! Vino ino siyo Mndewa wa wanhu wa Izilaeli? Lelo yahahumuluka mumsalaba tomtogola! ");
INSERT INTO kdc2014_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kamtamanila Mulungu na kalonga kamba heyo Mwana wa Mulungu. Lelo lekeni tulole kamba Mulungu komuhonya!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vivija na waja wabokaji wawambigwe hamoja na Yesu, wamuliga. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Viivikile saa sita imisi isi yose ikala igubikigwe na ziza totolo, ziza dijo dikala kwa masaa madatu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Viivikile saa tisa imisi Yesu kalila kwa sauti ng'hulu, “Eloi Eloi lama sabakitani?” Fambulo jake, “Mulungu wangu, Mulungu wangu, habali kundeka?” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lakini wanhu wayagwe wemile aho viwahulike, walonga, “Komkema Eliya!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bahaja munhu imoja kakimbila kasola dodoki, kadivabika mwiidivai, kadinanika mulubiki kamgwaa Yesu yadifonze. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Abaho wanhu wayagwe walonga, “Mulekeni, tulole kamba Eliya kokwiza kumkombola!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Abaho Yesu kalila kabili kwa sauti ng'hulu, kafa. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bahaja panziya da Ng'anda ya Mulungu digola gati da Ng'anda ya Mulungu na hanhu hong'ala ng'hani, didegeka mhande mbili, kulawa uchanha mbaka hasi. Isi itigisika na mibwe itulika. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mapanga gafunhuka na wanhu wengi wa Mulungu wakalile wafile wazilibuka. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Walawa mna gamapanga, na Yesu viyazilibuke wachola Yelusalemu kudibuga ding'alile, na wanhu wengi wawona. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mkulu wa wakalizi na wakalizi wakalile womkaliza Yesu, viwayone isi yotigisika na mbuli ziyagwe zilawilile, wadumba ng'hani na kulonga, “Kweli ino kakala Mwana wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Baho kukala na watwanzi wengi, womulola kwa kutali. Watwanzi awo wakala womkweleleza Yesu kulawa Galilaya na wamtaza. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mna iwao kakala Malia Magidalena, Malia mamao Yakobo na Yusufu na mwehe wa Zebedayo. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Viivikile ichungulo, keza munhu imoja tajili mwenekae wa Alimataya, twaga jake Yusufu, nayo vivija kakala mwanahina wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kamcholela Pilato, kampula lukuli lwa Yesu, Pilato kalagiza yagweleligwe. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu kalusola ulukuli, kaluzingiliza sitili ya sambi, ");
INSERT INTO kdc2014_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na kalwika mdipanga jake mwenyego da sambi yadisongole mdibwe. Abaho kabimbilisa dibwe kulu kadigubika mmulomo wa dipanga kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Magidalena na Malia iyagwe wakala aho wodilola dipanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Imitondo yake, ikala siku ya Kubwihila, wakulu wa walava nhosa na Mafalisayo wachola kwa Pilato. ");
INSERT INTO kdc2014_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wamulongela, “Go mkulu, tomkumbuka, munhu ija cha uvizi viyakalile mgima kalonga, ‘Zahavika siku ndatu nozilibuka.’ ");
INSERT INTO kdc2014_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Avo lagiza panga jake dikalizigwe mbaka siku ya kadatu, muladi wanahina zake sekewachole kulwiba ulukuli, abaho wawalongele wanhu kamba kazilibuka. Avo uvizi uno waikimambukizo wokwiha ng'hani kubanza uja wa ichanduso.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kawalongela, “Soleni wakalizi, mkadikalize dipanga kamba vimulonda.” ");
INSERT INTO kdc2014_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Avo wasegela wadikaliza dipanga na wakanda kilaguso mna idibwe na wawaleka wakalizi wadikalize. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Viimalile siku ya Kubwihila, siku ya jumapili, Malia Magidalena na Malia ija iyagwe waidamuka wachola kudilola dipanga. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bahaja isi ikala yotigisika ng'hani, na msenga wa kuulanga wa Mndewa kahumuluka kuulanga, kadibimbilisa idibwe hamgwazo, na kadikalila. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kaoneka kamba lumwesa, na viwalo vake vikala vizelu chuwee. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wakalizi wamdumba ng'hani avo wakala wogwaya, wakala kamba wanhu wafile. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Msenga wa kuulanga kawalongela iwatwanzi, “Sekemudumbe, kwavija nojuwa momzahila Yesu yawambigwe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kahaduhu hano, kazilibuka kamba viyalongile. Izoni mulole hanhu hawamwikile. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Choleni himahima mkawalongele wanahina zake, ‘Yesu kazilibuka kulawa kwa wafile na kowalongolela kuchola Galilaya, kuko momona!’ Uno awo usenga wangu kumwenu.” ");
INSERT INTO kdc2014_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Avo watwanzi waja wasegela himahima kudipanga, kuno wodumba na kudeng'helela, wakimbila kuwalongela wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bahaja Yesu kawating'hana, kawalamusa, “Zihozeni.” Wamcholela wamgoga magulu gake, wamtambikila. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu kawalongela, “Sekemudumbe. Choleni mkawalongele ndugu zangu wachole Galilaya, kuko wonyona.” ");
INSERT INTO kdc2014_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Watwanzi waja viwakalile mnzila, wakalizi wayagwe wachola kudibuga na kuwalongela wakulu wa walava nhosa kila kinhu kilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wakulu wa walava nhosa viwaiting'hane hamoja na wavele waitogolela mbuli, wawagwaa waja iwakalizi sente nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wawalongela, “Longeni, wanahina zake weza ikilo kulwiba ulukuli vimukalile muwasile. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Avo mkulu wa isi yahaihulika mbuli ino, tweye tolonga nayo, na mweye hamwingila mna dizumozumo.” ");
INSERT INTO kdc2014_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Avo wakalizi wazisola zisente na watenda kamba viwalongeligwe. Avo mbuli ino ayo yenele kwa Wayahudi mbaka lelo. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abaho wanahina longo na imoja wachola kukigongo mwiisi ya Galilaya, ako kuyawalongele Yesu wachole. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Viwamonile, wamtambikila, kuno wayagwe wanyawanyawa. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kawezila, kawalongela, “Nigweleligwa udahi wose wa kuulanga na mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Avo gendeni mkawatende wanhu wa isi zose wawe wanahina zangu, muwabatize kwa twaga da Tata na Mwana na Loho Yang'alile, ");
INSERT INTO kdc2014_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na muwafundize wagoge kila kinhu kiniwalagizeni, naniye nokuwa hamoja na mweye siku zose mbaka kukimambukizo cha isi.”");
INSERT INTO kdc2014_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ino ayo Mbuli Inogile ya Yesu Kilisito Mkombola, Mwana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isonga kamba viyandikigwe na mtula ndagu wa Mulungu Isaya, “Mulungu kalonga, ‘Nomtuma msenga wangu yakulongolele yaitande nzila yako.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Munhu imoja kokema kuluwala, ‘Itandeni nzila ya Mndewa, goloseni nzila yake yonda yabite!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana Mbatizaji kalawilila kuluwala kawapetela wanhu, “Lekeni nzambi na mbatizigwe na Mulungu kozigela kumgongo nzambi zenu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wanhu wengi kulawa mwiisi ya Yudea na kudibuga da Yelusalemu wachola kumtegeleza Yohana. Watogola kamba wana nzambi, Yohana kawabatiza muulwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana kavala kiwalo kitendigwa kwa mibahila ya ngamiya na mkwiji wa ng'hwembe mkigudi chake, lujo lwake lukala nzige na uki. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kawapetela wanhu, “Munhu yonda yeze kukisogo changu ni munhu mkulu kunibanza nene. Niye sifaya hata kudohola nzabi za vilatu vake. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Niye nowabatiza kwa mazi, lakini heyo kowabatiza kwa Loho Yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mna ikipindi acho Yesu kalawa mna ikijiji cha Nazaleti mwiisi ya Galilaya na Yohana kambatiza muulwanda lwa Yolidani. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu viyalawile mgamazi, bahaja kawona ulanga ugubuka na kamona Loho Yang'alile kohumuluka kamba huwa na kakala uchanha yake. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sauti ihulikigwa kulawa kuulanga ilonga, “Gweye kwa Mwanangu nikunogele. Ninogelwa na gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bahaja Loho Yang'alile kamulongoza yachole kuluwala, ");
INSERT INTO kdc2014_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kakala kuko kuluwala siku malongo mane, kagezigwa na Mwenembago. Wanyama wa kumuhulo wakala aho lakini wasenga wa kuulanga weza wamsang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana viyagodekigwe mkifungo, Yesu kachola isi ya Galilaya, kawapetela wanhu Mbuli Inogile ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kalonga, “Kipindi kivika, Undewa wa Mulungu wammabehi! Lekeni nzambi na muitogole Mbuli Inogile!” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu viyakalile kobita kumgwazo wa lamba da Galilaya kawavika wavuwa somba wabili, Simoni na mdodo wake Andeleya wakala wovuwa somba na mizavu yao. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kawalongela, “Nikwelelezeni, na niye nowatenda muwe wavuwaji wa wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bahaja waileka mizavu yao, wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kagenda kumwande, kawavika wandugu wabili wayagwe. Yakobo na Yohana, wanage Zebedayo. Wakala mwiingalawa woitanda mizavu yao. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bahaja Yesu viyawone kawakema, nao wamuleka tatao Zebedayo na wasang'hanaji zake mwiingalawa, wamkweleleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wanahina zake wavika kudibuga da Kapelinaumu, viivikile siku ya Kubwihila Yesu kengila mng'anda ya kumpula Mulungu, kasonga kufundiza. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wanhu wamuhulike wakanganya mafundizo gake, kwavija hafundize kamba wafundiza Malagizo ga Musa, ila kafundiza kwa udahi. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Abaho munhu yakalile na kinyamkela kengila mng'anda ya kumpula Mulungu, kaguta, ");
INSERT INTO kdc2014_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Vino, kolonda choni kumwetu, gweye Yesu wa Nazaleti? Kwiza kutukoma? Nokujuwa gweye kwa ija Yang'alile yatumigwe na Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamkomhokela ikinyamkela, “Nyamala! Mulawe munhu ino!” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kinyamkela kamgela kisango munhu ayo, kaguta nyangi, kamulawa. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wanhu wose wakanganya ng'hani, avo wasonga kuilongela, “Vino kino choni? Mafundizo gano ga sambi! Munhu ino kana udahi wa kulava vinyamkela, nao womtegeleza!” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Avo mbuli za Yesu zibwililika himahima kila hanhu mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na wanahina zake, hamoja na Yakobo na Yohana walawa mna ing'anda ya kumpula Mulungu, wachola kuna ikae ya Simoni na Andeleya. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mkwe wa kitwanzi wa Simoni kakala yawasile mulusazi kolumwa homa, Yesu viyavikile wamulongela mbuli za mtamu ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu kamgendela mtwanzi ayo, kamgoga mkono kamwinula. Homa imulawa na kasonga kuwasang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ichungulo, zuwa vidihongile, wanhu wamgalila Yesu watamu na waja wakalile na vinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wanhu wose wa kudibuga dija waiting'hana haluhelengo lwa ing'anda. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kawahonya wanhu wengi wakalile na mitamu na kawalava vinyamkela wengi. Hawalekile vinyamkela walonge kwavija wamjuwa kakala nani. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Imitootondo ng'hani siku diyagwe, Yesu kalamuka kasegela, kachola kunze kudibuga, hanhu kuduhu wanhu, kuko kampula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na wayage wachola kumzahila, ");
INSERT INTO kdc2014_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","viwamvikile wamulongela, “Kila munhu kokuzahila.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu kawedika, “Tolondeka kuchola kuna ivijiji viyagwe vili behi. Ako nako nolondeka kuwapetela wanhu Mbuli Inogile, kwavija acho kiminzile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yesu kachola kila hanhu mwiisi ya Galilaya, kawapetela wanhu Mbuli Inogile mzing'anda za kumpula Mulungu na kulava vinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munhu imoja yeli na utamu wa dikulu kamgendela Yesu, kamfugamila, kampula, kalonga, “Wahalonda kodaha kunihonya.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kamonela bazi, kamgolosela mkono, kamkwasa, kalonga, “Nolonda, hona!” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bahaja utamu umulawa, kahona. ");
INSERT INTO kdc2014_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu kamulongela yachole, kamzuma, ");
INSERT INTO kdc2014_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","kamulongela, “Tegeleza, sekeumulongele munhu yoyose mbuli ino, lakini goga inzila mbaka kwa mulava nhosa, yakakulolese lolese. Abaho kalave nhosa kamba viyalagize Musa ili kutenda kila munhu yatogole kamba kuhonyigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini munhu ayo kasegela, kasonga kuzibwililisa mbuli azo kila hanhu, kalonga mbuli nyingi mbaka Yesu hadahile kwingila mwiisi kunze kunze. Avo Yesu kakala kunze hanhu kuduhu wanhu, lakini wanhu wamcholela kulawa kila hanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hazibitile siku nyingi, Yesu kabwela Kapelinaumu, mbuli zibwililika kwa wanhu kamba kakala ukae. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wanhu wengi waiting'hana hamoja mbaka kukala kuduhu gati disigale, wamema mbaka kuluhelengo. Yesu kakala kowapetela mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Abaho weza wanhu wane, wampapile munhu yaholole walonda kumgala kwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwavija kukala na lunhu, hawadahile bule kumgala kwa Yesu. Avo watobola zonzo kukiswili uchanha ya aho haakalile Yesu, wahumulusa mkeka muyatambalale munhu ayo yaholole. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu viyakone kutamanila kwao, kamulongela munhu ayo yaholole, “Mwanangu, nzambi zako zigeligwa kumgongo.” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wafundiza Malagizo ga Musa wayagwe wakalile hanhu aho wagesa mna imizoyo yao, ");
INSERT INTO kdc2014_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Munhu ino kodahaze kulonga vino? Ino komkudula Mulungu! Mulungu yaiyeka ayo yodaha kuzigela kumgongo nzambi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahaja Yesu kakijuwa kiwagesile mna imizoyo yao. Avo kawauza, “Habali mogesa avo? ");
INSERT INTO kdc2014_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vino choni kibuhile, kumulongela munhu yaholole, ‘Nzambi zako zigeligwa kumgongo’, hebu kulonga, ‘Ima, papa mkeka wako utembele?’ ");
INSERT INTO kdc2014_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lakini nolonda mujuwe, Mwana wa Munhu kana udahi mwiisi wa kuzigela kumgongo nzambi za wanhu.” Avo kamulongela munhu ayo yaholole, ");
INSERT INTO kdc2014_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nokulongela, lamuka, papa mkeka wako, uchole ukae!” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nayo kenuka, kapapa mkeka wake, kalawa kunze na kasegela mgameso gao. Wose wakanganya, wamtogola Mulungu na walonga, “Hatunachona kinhu kamba kino!” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kabweleganya kabili kumgwazo wa lamba da Galilaya. Lunhu lwa wanhu lumcholela, nayo kasonga kuwafundiza. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Viyakalile kobita, kamvika mbokela kodi imoja twaga jake Lawi, mwanage Alufayo kakala mng'anda ya kulipila kodi. Yesu kamulongela, “Nikweleleze.” Lawi kenuka, kamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu viyakalile koja mng'anda ya Lawi, wabokela kodi wengi na wanhu wene nzambi, wakala hamoja nayo woja na wanahina zake, kwavija wanhu wengi wakala womkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wafundiza Malagizo ga Musa wayagwe wakalile Mafalisayo viwamonile Yesu koja na wanhu wene nzambi na wabokela kodi, wawauza wanahina zake, “Habali koja na wanhu kamba wano?” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu viyahulike avo kawedika, “Wanhu wagima hawamulonda mganga, ila wanhu watamu womulonda. Sizile kuwakema wanhu wogesa wanoga, niza kuwakema wanhu wene nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wanahina wa Yohana Mbatizaji na wanahina wa Mafalisayo wakala wofunga kuja. Wanhu wayagwe wamcholela Yesu, wamuuza, “Habali wanahina wa Yohana na wanahina wa Mafalisayo wofunga kuja lakini wanahina zako hawafunga kuja?” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kawedika, “Vino yodahika vilihi wanhu wagonekigwe kuna dizengele wafunge kuja kipindi munhu yosola kahamoja nao? Bule! Hawadaha kufunga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini kipindi chokwiza munhu yosola vonda yasegezigwe kumwao, baho wofunga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kuduhu munhu yokwika kilaka cha kiwalo cha sambi mna kiwalo cha umwaka. Yahatenda avo, kilaka cha sambi chokidega kiwalo cha umwaka, na aho hadegeke hokongezeka. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Vivija kuduhu munhu yogida divai ya sambi mna mifuko ya ng'hwembe ya umwaka, kwavija yahatenda avo divai ya sambi yoitula imifuko na divai yokwitika na imifuko yobanangika. Ila divai ya sambi yogidigwa mna imifuko ya ng'hwembe ya sambi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Siku dimoja da Kubwihila, Yesu na wanahina zake wakala wobita mna imigunda ya uhemba. Viwakalile wobita, wanahina zake wasonga kuhulula uhemba. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo wamulongela Yesu, “Lola, wanahina zako wotenda kinhu kigomesigwe kutendigwa kudi siku da Kubwihila!” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kawedika, “Hamusomile kija kiyatendile Daudi kipindi heyo na wayage viwakalile na nzala? ");
INSERT INTO kdc2014_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mna ikipindi cha Mkulu wa walava nhosa Abiatali, Daudi kengila mna Ing'anda ya Mulungu na kugaja magate galavigwe nhosa kwa Mulungu. Magate gago golondigwa kudigwa na walava nhosa waiyeka, lakini Daudi kagaja na abaho kawagwaa wayage.” ");
INSERT INTO kdc2014_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Abaho Yesu kawalongela, “Siku ya Kubwihila ikigwa mbuli ya wanhu, na siyo wanhu mbuli ya siku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Avo Mwana wa Munhu ayo Mndewa wa siku ya Kubwihila.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Abaho Yesu kachola kabili mng'anda ya kumpula Mulungu. Ako kukala na munhu yakalile na mkono uholole. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wanhu wayagwe wakalile aho walonda kilamuso cha kumtagusila Yesu, avo wamulola bunhuu kamba komuhonya munhu ayo mna isiku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamulongela munhu ayo yaholole mkono, “Ima hano kuulongozi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abaho Yesu kawauza wanhu awo, “Vino Malagizo getu gotulonda tutende choni mna isiku ya Kubwihila? Kutenda ganogile hebu kutenda gehile? Kuuhonya ugima wa munhu hebu kuukoma?” Lakini wao wanyamala huupi. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu kawalola wanhu awo kwa kugevuzika, kawonela bazi mbuli ya udala wa mizoyo yao. Abaho kamulongela munhu ayo, “Golosa mkono wako.” Nayo kaugolosa mkono wake, na mkono wake uhona. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Abaho Mafalisayo walawa kunze mna ing'anda ya kumpula Mulungu, waiting'hana na wanhu wa Helode, wakala kiseto wamkome Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na wanahina zake wachola kudilamba da Galilaya, lunhu mkulu lwa wanhu lumkweleleza. Walawa kuzi isi za Galilaya na Yudea, ");
INSERT INTO kdc2014_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na buga da Yelusalemu, na isi ya Idumeya, na umwambu wa Yolidani, na kulawa mzimbaka zili mmabehi na mabuga ga Tilo na Sidoni. Wanhu wose awo wamcholela Yesu kwavija wahulika mbuli zake ziyakalile kotenda. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwavija lunhu lukala lukulu, Yesu kawalongela wanahina zake wamtandile ngalawa muladi wanhu sekewamsung'he sung'he. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kwavija Yesu kawahonya wanhu wengi, avo wanhu wose wakalile watamu wakala woisung'ha sung'ha wadahe kumkwasa. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wanhu wakalile na vinyamkela viwamonile Yesu, wamgwila kuulongozi waguta mizangi wolonga, “Gweye kwa Mwana wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakini Yesu kawagomesa vinyamkela sekewamulongele munhu yoyose kamba heyo kakala nani. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abaho Yesu kakwela kukigongo, kawakema wanhu yawalondile mwenyego, nao wamgendela. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kawasagula wanhu longo na wabili, kawakema watumigwa. Kawalongela, “Niwasagula mweye mukale na niye. Vivija nowagala mkawapetele wanhu Mbuli Inogile, ");
INSERT INTO kdc2014_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na mweye mokuwa na udahi wa kulava vinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wano awo longo na wabili iyawasagule, wakala Simoni, Yesu kamgwaa twaga da Petulo ");
INSERT INTO kdc2014_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na Yakobo na ndugu yake Yohana, wanage Zebedayo kawagwaa twaga da Boanilige, fambulo jake, “Wana wa Ng'huwa” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na Andeleya na Filipo na Batulumayo na Matayo na Tomaso na Yakobo mwana wa Alufayo na Tadayo na Simoni Mkananayo, ");
INSERT INTO kdc2014_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikaliote, yamuhinduke Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Abaho Yesu kachola ukae. Lunhu lwa wanhu luiting'hana kabili mbaka Yesu na wanahina zake walemelwa kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndugu zake viwahulike avo, wagenda kumsola kwavija wanhu wakala wolonga, “Kana kibozi mbwelela!” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wafundiza Malagizo ga Musa wayagwe walawile Yelusalemu wakala wolonga, “Kana Belizebuli! Ayo mkulu wa vinyamkela yomgwaa udahi wa kuwalava vinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu kawakema na kawalongela kwa simo, “Vino Mwenembago kodahaze kumulava Mwenembago? ");
INSERT INTO kdc2014_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kamba undewa wahaigola wenyego na kuitowa, undewa awo wogwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wanhu wa lubuga lumoja wahaigola na kuitowa, lubuga lulo logwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Avo kamba undewa wa Mwenembago wahaigola wenyego, undewa awo wogwa na kuhelela baho. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kuduhu munhu yodaha kutula ng'anda ya munhu mwene nguvu na kusola vinhu vake, mbaka yasonge kumgodeka munhu ayo, baho kodaha kusola vinhu vake. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nowalongela ukweli, nzambi zose ziwatendile wanhu na maligo gao gose, Mulungu kodaha kugela kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lakini munhu yoyose yomuliga Loho Yang'alile, maligo gake hondagageligwe kumgongo bule, kwavija katenda nzambi ya mazuwa gose.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kalonga avo kwavija wanhu wakala wolonga, “Kana kinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Abaho mamake na ndugu zake Yesu weza, wema kunze wamtuma munhu yamkeme Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lunhu lwa wanhu lukala lumzunguluke Yesu. Nao wamulongela, “Go mkulu, mamako na ndugu zako wa kunze, wokulonda gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kawedika, “Mamangu ayo nani? Na ndugu zangu wao nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Baho kawalola wanhu awo wamzunguluke, kawalongela, “Loleni! Wano awo mamangu na ndugu zangu! ");
INSERT INTO kdc2014_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Munhu yoyose yotenda gaja golondigwa na Mulungu, ayo ndugu yangu na lumbu jangu na mamangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kasonga kufundiza kabili kumgwazo wa lamba da Galilaya. Lunhu lwa wanhu lumzunguluka mbaka kengila mwiingalawa na kukala mumo. Wanhu wose wakala kumgwazo wa lamba. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kawafundiza vinhu vingi kwa simo, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tegelezeni! Kukala na munhu kachola kuhanda mbeyu. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Viyakalile komiza zimbeyu kumgunda, ziyagwe zilagalila mnzila, ndege weza na kuzija. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ziyagwe zilagalila mgamabwe hakalile na udongo mdodo. Zota himahima kwavija udongo ukala mdodo. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zuwa vidilawile, diisoma mimeya na kwavija mizizi yake haicholile hasi ng'hani, inyala. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu ziyagwe zilagalila mvisolo va miba, visolo avo vikula na kuizonga mimeya, nayo ilemelwa kulela. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lakini mbeyu ziyagwe zilagalila hanhu heli na udongo unogile. Zota, zikula na kulela kubanza zija zihandigwe, ziyagwe zilela malongo madatu, ziyagwe zilela malongo sita, na ziyagwe zilela gana dimoja.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Abaho Yesu kalonga, “Munhu yeli na magwiti, yahulike!” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu viyakalile yaiyeka, wanahina zake longo na wabili na wanhu wayagwe wamulongela yawafambulile simo azo. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kawalongela, “Mweye mugweleligwa kuzijuwa mbuli zifisigwe za Undewa wa Mulungu, lakini awo weli kunze wohulika mbuli zose kwa simo, ");
INSERT INTO kdc2014_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","muladi, ‘Walole, lakini sekewone, wategeleze lakini sekewajuwe. Kwavija wahavijuwa, wodaha kumbwelela Mulungu, na Mulungu kozigela kumgongo nzambi zao.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Abaho Yesu kawauza, “Hamulujuwile vilihi lusimo luno? Vino lelo molujuwaze lusimo lolose luyagwe? ");
INSERT INTO kdc2014_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muhandaji kohanda mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wanhu wayagwe waigala na izimbeyu zilagalile mnzila, wahahulika mbuli, Mwenembago kokwiza na kuisola mbuli ihandigwe mgati mmwao. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wanhu wayagwe waigala na mbeyu zilagalile mna gamabwe. Wahahulika mbuli, bahaja wozibokela kwa kudeng'helela, ");
INSERT INTO kdc2014_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","lakini kwavija waduhu mizizi mgati mmwao, wokala kipindi kidodo. Wahagaya na kudununzika mbuli ya usenga awo, wobwela kukisogo. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wanhu wayagwe waigala na mbeyu zilagalile mna ivisolo va miba. Wohulika mbuli, ");
INSERT INTO kdc2014_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lakini magayo ga ugima uno, kulonda utajili, na kulonda mbuli nyingi ziyagwe kuizonga mbuli ayo, nayo ilemelwa kulela. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lakini wanhu wayagwe waigala na mbeyu zilagalile muudongo unogile. Wouhulika usenga, woutogola na wolela matunda, wayagwe malongo madatu wayagwe malongo sita na wayagwe gana dimoja.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kagendelela kulonga, “Vino munhu kodaha kubwinha taa mng'anda na kuigubika na kikalango hebu kuika muuvungu wa lusazi? Vino haika kukingolobweda? ");
INSERT INTO kdc2014_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kwavija kinhu chochose kifisigwe chokoneka na kinhu chochose kigubikigwe chogubuligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yeli na magwiti yahulike!” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Vivija kawalongela, “Iteganyeni na gaja gomuhulika! Vija vimuwatagusa wayagwe na Mulungu kowatagusa vivo na mokongezeligwa ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Waja weli na vinhu wokongezelwa, lakini waja waliduhu vinhu wobokigwa hata vija vidodo viwelinavo.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kagendelela kulonga, “Undewa wa Mulungu uigala na kija kilawilile kwa munhu yamizile mbeyu mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikilo kowasa, imisi kolamuka, mbeyu zota na kukula, lakini heyo hajuwa choni kigendelela. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Udongo wenyego wozitenda mbeyu zikule goya na kulela matunda, tanhu majani, abaho mada, na womambukiza kwa kuzamiza. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uhemba wahakangala, munhu ayo kosola sengo na kosonga kusenga kwavija kipindi cha kusenga kivika.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kalonga kabili, “Vino Undewa wa Mulungu uigala na choni? Vino tuusimulile kwa lusimo gani? ");
INSERT INTO kdc2014_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uigala na kija kilawilile kwa munhu yasolile mbeyu ya haladali mbeyu ndodo kubanza zose na kuihanda mumgunda. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lakini yahahandigwa, yokula na yokuwa mbiki mkulu kubanza mibiki yose ihandigwe mumgunda. Yokwika matambi makulu ng'hani mbaka ndege wozenga mvulu zao mna gamatambi gake.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kawapetela wanhu usenga wake kwa simo nyingi ziigalile na zino, kawalongela mbuli nyingi kamba viwadahile kuzijuwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Halongile nao kinhu chochose bila simo, lakini viwakalile waiyeka na wanahina zake, kawafambulila vinhu vose. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ichungulo ya siku dijo, Yesu kawalongela wanahina zake, “Tuloke mwambu wa lamba.” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Avo wawaleka wanhu wose, wanahina zake wengila mwiingalawa yaakalile Yesu na wachola nayo. Vivija kukala na ngalawa ziyagwe hanhu aho. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bahaja dilawilila nyukwanyukwa kulu da beho na ng'humbi mgamazi gaizola ija ingalawa mbaka ilonda kumema mazi. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kakala kukisogo mwiingalawa, kawasa na keka pala jake muna umto. Wanahina zake wamulamusa na kumulongela, “Mfundiza! Vino gweye hutonga, tweye tofa?” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kalamuka, kadikomhokela dija dibeho, “Nyamala!” Baho beho dinyamala tuluu, na kukala poozi. ");
INSERT INTO kdc2014_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Abaho Yesu kawalongela wanahina zake, “Habali modumba? Mung'hali mduhu kutamanila?” ");
INSERT INTO kdc2014_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wanahina zake wadumba na waiuza wenyego, “Vino ino munhu gani? Mbaka beho na ng'humbi vose vomuhulika!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wanahina zake waloka mbaka mwambu wa lamba da Galilaya, mwiisi ya Wagelasi. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baho Yesu viyalawile mwiingalawa, kaiting'hana na munhu yeli na vinyamkela. Munhu ayo kalawa kuna gamapanga. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munhu ayo kakala yokala kuna gamapanga gago, kuduhu munhu yadahile kumgodeka minyololo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miyanza mingi wageza kumgodeka minyololo mmakono na mmagulu, lakini kakala yozikanha na kuzibena bena mhingu zili mmagulu gake. Kakala na nguvu ng'hani na kuduhu munhu yadahile kumgoga. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Imisi na ikilo kakala yokwanga mna gamapanga gaja na kuna ivigongo, kaguta nyangi na kuikanha kanha kwa mabwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Viyamone Yesu kwa kutali, kamkimbilila na kamfugamila. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kaguta, “Yesu, Mwana wa Mulungu yeli Uchanha Ng'hani! Kolonda choni kumwangu? Iduile kwa twaga da Mulungu kamba hunidununza bule!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kalonga avo kwavija Yesu kamulongela, “Kinyamkela, mulawe munhu ino!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu kamuuza, “Twaga jako nani?” Munhu ayo kamwidika, “Twaga jangu Lunhu, kwavija twa wengi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kampula Yesu sekeyawagale ivinyamkela kunze ya isi ija. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kukala na bumbila kulu da nguluwe wakala woja kuna umtelemuko wa kigongo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Avo vinyamkela wampula Yesu, “Tugale kwa nguluwe, na utuleke tuwengile wao.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kawatogolela, avo vinyamkela wamulawa munhu ayo, na wengila mna iwanguluwe. Bumbila jose da nguluwe elufu mbili wahumulukila kudilamba, wose wafila mumo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wanhu wakalile wowasusila nguluwe awo wakimbila na kuzibwililisa mbuli azo mwiisi na kumigunda. Abaho wanhu wachola kulola kija kilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Viwavikile kwa Yesu, wamona munhu ayo yakalile na vinyamkela kakala aho na kavala goya viwalo, na nzewele zake zimbwelela na wanhu wose wadumba. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wanhu wachone acho kilawilile, wawalongela wayao gaja gampatile munhu ayo yakalile na vinyamkela, na mbuli za nguluwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Avo wanhu wampula Yesu yasegele mwiisi yao. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu viyakalile kokwela mwiingalawa, munhu ayo yakalile na vinyamkela kampula Yesu wachole wose. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini Yesu kamulemela, kamulongela, “Bwela ukayako ukawalongele wanhu wa lukolo lwako gaja gose Mndewa gayakutendele, na viyakonele bazi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Avo munhu ayo kasegela, kachola hanhu hakemigwe Dekapoli, kawalongela wanhu gaja gose Yesu gayamtendele. Wanhu wose wahulike wakanganya. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kabwela mwambu uyagwe wa lamba. Lunhu lwa wanhu lumzunguluka kumgwazo wa lamba. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Abaho keza mkulu imoja wa ng'anda ya kumpula Mulungu, twaga jake Yailo. Viyamone Yesu, kaibwanha hasi mmagulu gake, ");
INSERT INTO kdc2014_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kampula ng'hani, “Mndele wangu kolumwa ng'hani. Nokupula chonde chonde, wize ukamwikile makono muladi yahone na yawe mgima.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Abaho Yesu kachola na Yailo, lunhu mkulu lwa wanhu lumkweleleza kuno lomsung'ha sung'ha. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baho kukala na mtwanzi yakalile na utamu wa kutumika kwa miyaka longo na mibili. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mtwanzi ayo kachola kwa waganga wengi na katumia vinhu vose viyakalile navo, lakini hahonile bule, ila kagendelela kulumwa ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Viyazihulike mbuli za Yesu, kengila mna ulunhu lwa wanhu, kamcholela Yesu kukisogo na kakwasa kiwalo chake. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kailongela mwenyego, “Nahakwasa kiwalo chake, nohona.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Viyakwasile kiwalo cha Yesu, bahaja kutumika kuleka, nayo kahulika kahona utamu wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bahaja Yesu kajuwa nguvu zimulawa, avo kahinduka muulunhu na kuuza, “Nani yanikwasile kiwalo changu?” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanahina zake wamwidika, “Kowona wanhu viwokusung'ha sung'ha, abaho kouza nani yakukwasile?” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu kalola mhande zose ili yamone munhu yatendile vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mtwanzi ayo kajuwa kinhu kimulawilile, avo kamgendela Yesu kuno kodumba na kugwaya. Kamfugamila Yesu, kamulongela fulu ipile. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamulongela mtwanzi ayo, “Mwanangu, kutamanila kwako kukuhonya. Genda moyo uholile, kuhona utamu wako.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu viyakalile kogendelela kulonga, wasenga kulawa ukayake Yailo weza na kumulongela Yailo, “Mndele wako kafa. Habali kogendelela kumgaza Mfundiza?” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu viyazihulike mbuli azo zilongigwe na wasenga awo, hazigesile bule, lakini kamulongela Yailo, “Sekeudumbe, togola tu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Abaho Yesu halondile munhu yoyose iyagwe yamkweleleze, ila Petulo, Yakobo na Yohana, ndugu yake Yakobo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Viwavikile mng'anda ya Yailo, Yesu kawona wanhu wobwahanhuka kwa usungu na kuiyalala. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu kengila mng'anda kawalongela, “Habali moiyalala na kulila? Imwana hafile bule, lakini kawasa!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lakini wamseka, avo Yesu kawalava kunze wose, kamsola tatake na mamake ija imwana, na waja wanahina zake wadatu. Wengila mna idigati mulutambalizwe lukuli lwa mwana ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu kamgoga mkono, kamulongela, “Talita Kumi!” fambulo jake, “Mndele, nokulongela lamuka!” ");
INSERT INTO kdc2014_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bahaja mndele ayo kenuka na kasonga kugenda. Mndele ayo kakala na miyaka longo na mibili. Mbuli ino viilawilile, wanhu wakanganya ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lakini Yesu kawagomesa ng'hani sekewamulongele munhu yoyose mbuli ayo ilawilile, abaho kawalongela, “Mgweleleni lujo mndele ino.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kasegela hanhu aho kachola kudibuga diyavumbuke, na wanahina zake wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Vidivikile siku da Kubwihila, Yesu kasonga kufundiza mng'anda ya kumpula Mulungu. Wanhu wamuhulike wakanganya ng'hani, waiuza, “Munhu ino kazipata kwahi mbuli zino? Nzewele gani ino mbaka kodaha kutenda unzonza uno? ");
INSERT INTO kdc2014_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Vino ino siyo ija fundi selemala, mwanage Malia, na ndugu zake Yakobo na Yusufu na Yuda na Simoni? Vino lumbu zake hawakala bahano bule?” Avo wamulema. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kawalongela, “Mtula ndagu kotegelezigwa kila hanhu, lakini hategelezigwa ukayake na kwa ndugu zake, na kwa wanhu wa lukolo lwake mwenyego.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu hatendile unzonza wowose, ila kawekila makono watamu kidogo na kawahonya. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu kakanganya ng'hani kwavija wanhu wakala waduhu kutamanila. Abaho Yesu kachola mna ivijiji vili behi, na kasonga kuwafundiza wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kawakema wanahina longo na wabili, kawatuma wabili wabili, na kawagwaa udahi wa kulava vinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kawalongela, “Sekemusole kinhu chochose, ila mkongoja wiiyeka. Sekemusole gate hebu mkoba hebu sente mkibindo. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Valeni vilatu, lakini sekemusole kiwalo kiyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hanhu hohose honda mubokeligwe, kaleni aho mbaka vonda musegele. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mwahavika kudibuga jojose na wanhu wa aho wahalema kuwabokela hebu kuwategeleza, segeleni na kung'huseni matimbwisi geli mmagulu genu muladi iwe kilaguso kamba wawatendela nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Avo wasegela na kuwapetela wanhu waleke nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wawalava vinyamkela wengi na kuwabakaza mavuta wanhu wengi wakalile watamu na kuwahonya. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mndewa Helode kahulika mbuli azo zose, kwavija twaga da Yesu dikala dijuwike kila hanhu. Wanhu wayagwe wakala wolonga, “Yohana Mbatizaji kazilibuka kulawa kwa wafile, lekaavo kana udahi wa kutenda unzonza.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wanhu wayagwe walonga, “Ino Eliya.” Na wanhu wayagwe walonga, “Ino mtula ndagu kaigala na imoja wa watula ndagu wa Mulungu wa kuko umwaka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helode viyazihulike mbuli azo, kalonga, “Ino ayo Yohana Mbatizaji inimkanhile pala jake lakini kazilibuka kulawa kwa wafile!” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Helode mwenyego kakala yalagize Yohana yagodekigwe nzabi, abaho yekigwe mkifungo. Katenda avo mbuli ya Helodiya iyamsolile, hamoja kakala mwehe wa Filipo, mdodo wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana Mbatizaji kakala yomulongela Helode, “Malagizo golonga, havinogile bule gweye umsole mwehe wa mdodo wako!” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Avo Helodiya kakala komwihila Yohana, na kalonda kumkoma. Lakini hadahile bule, ");
INSERT INTO kdc2014_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kwavija Helode kakala komdumba Yohana na kajuwa kamba kakala munhu yanogile na yang'alile avo kamkaliza. Kakala konogelwa kumuhulika, hamoja moyo umuluma ng'hani kila viyamalile kumuhulika. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Siku dimoja, Helodiya kapata nyafasi mna idisiku da kukumbuka kuvumbuka kwa Helode. Helode kawatendela nyimwili nyimwili ng'hulu wakulu wa mabuga, na wakulu wa wakalizi, na walangulizi wa isi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mndele wa Helodiya viyengile kuvina, kamnogeza ng'hani Helode na wageni wagonekigwe kuna inyimwili nyimwili. Avo mndewa Helode kamulongela mndele ayo, “Nipule chochose kiulonda, nokugwaa.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kaiduila, “Noiduila, nokugwaa chochose chondaunipule, hata nusu ya undewa wangu nokugwaa!” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Avo mndele ayo kalawa kunze kamuuza mamake, “Nipule choni?” Nayo kamwidika, “Pula pala da Yohana Mbatizaji.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bahaja mndele ayo kakimbila mbaka kwa mndewa, kamulongela, “Sambi baha nigwelele pala da Yohana Mbatizaji mditanda!” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mndewa kona usungu ng'hani, lakini kwavija kaiduila mgameso ga wanhu wagonekigwe, hadahile kumulemela. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bahaja mndewa kamulagiza mkalizi yadigale pala da Yohana. Mkalizi kagenda mkifungo, kakanha pala da Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Abaho kadika pala dija mditanda, kamgalila mndele ayo, nayo kamgwaa mamake. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanahina wa Yohana viwahulike mbuli ayo, wachola kulusola lukuli lwa Yohana na kuluzika. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Watumigwa wabwela, waiting'hana na Yesu na wamulongela gaja gose gawatendile na kufundiza. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baho kukala na wanhu wengi wakalile wokwiza na kusegela, mbaka Yesu na wanahina zake hawapatile nyafasi ya kuja kinhu. Avo Yesu kawalongela wanahina zake, “Tucholeni twiiyeka hanhu kuduhu wanhu mkabwihile kidogo.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Avo wasegela waiyeka mwiingalawa, wachola hanhu kuduhu wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wanhu viwonile wosegela, bahaja wawajuwa. Avo walawa mna gamabuga gose, wakimbila mbaka wawalongolela kuvika Yesu na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu viyahumuluke mwiingalawa, kaluvika lunhu mkulu lwa wanhu. Kawonela bazi kwavija wakala kamba ng'hondolo weliduhu msusilaji. Avo kasonga kuwafundiza vinhu vingi. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zuwa vidikalile dohonga, wanahina zake wamcholela Yesu, wamulongela, “Hanhu hano hatwili kuduhu wanhu, na sambi zuwa dohonga. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Walongele wanhu wachole mna imigunda na vijiji vilibehi muladi wakaigulile vinhu va kuja.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu kawedika, “Wagweleleni mweye kinhu cha kuja waje.” Wamuuza, “Vino tuchole tukagule magate ga sente ifaya kumulipa msang'hanaji kwa miezi minanetuwagwee waje?” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu kawauza, “Munago magate mangapi? Gendeni mukalole.” Viwagalolile, wamulongela, “Kuna magate matano na somba wabili.” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Abaho Yesu kawalongela wanahina zake wawagole wanhu wose mna ivibumbila bumbila, wakale hasi mna gamajani mabisi. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Avo wakala mna ivibumbila va wanhu gana na va wanhu malongo matano. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Abaho Yesu kasola gaja gamagate matano na somba wabili, kalola uchanha na kamgwaa nhogolwa Mulungu. Abaho kagabanzula gaja gamagate, kawagwaa wanahina zake wawagolele wanhu. Vivija kawagolela wose somba waja wabili. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wanhu wose waja na kwiguta. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abaho wanahina zake wadondola magate gasigale na iwasomba, wamemeza vigelo longo na vibili. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wambigalo waiyeka wadile wakala gana elufu tano. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahaja Yesu kawalagiza wanahina zake wakwele mwiingalawa wamulongolele kuchola Betisaida, kuna umwambu uyagwe wa lamba. Heyo kakala yolulaga lunhu lwa wanhu lusegele. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Viyamambukize kuwalaga wanhu, kakwela kuna ikigongo kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Viivikile ichungulo, ngalawa ikala hagati ya lamba, lakini Yesu kakala yaiyeka mwiisi inyalile. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu kawona wanahina zake wolemelwa kutowa ng'hafi, kwavija beho kulu dikala dowabweza kuwalawile. Nzogolo zikwika, Yesu kawagendela, kuno kotembela uchanha mgamazi. Kalonda kuwabita, ");
INSERT INTO kdc2014_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","lakini viwamone kotembela uchanha mgamazi, wagizaga mzimu. Wakemelela kwa bwembwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wose viwamone wadumba ng'hani. Bahaja Yesu kawalongela, “Gangamaleni! Iyo nene! Sekemudumbe!” ");
INSERT INTO kdc2014_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Abaho Yesu kengila mwiingalawa, na beho dinyamala tuluu. Wanahina zake wakanganya ng'hani, ");
INSERT INTO kdc2014_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwavija wakala hawajuwile fambulo da kuwagwaa lujo wanhu elufu tano, mizoyo yao ikala midala. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waloka umwambu, wavika kuna iisi ya Genesaleti, baho waifunga ngalawa yao. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bahaja viwahumuluke mwiingalawa, wanhu wamjuwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Avo wakimbila mwiisi yose, na kila hanhu viwahulike Yesu kabaho wamgalila watamu watambalale mvisazi vao. ");
INSERT INTO kdc2014_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila hanhu Yesu hayacholile, iwe mna ivijiji, hebu mna gamabuga, hebu mna imigunda, wanhu wawasola watamu zao na kuwagala kuna gamagulilo. Wampula Yesu yawatogolele waikwase mhindo ya kiwalo chake. Wose waikwasile wahona. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo na wafundiza Malagizo ga Musa wayagwe wezile kulawa Yelusalemu waiting'hana haulongozi wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wawona wanahina wayagwe wa Yesu woja bila kusunha makono gao kamba viilondeka wanhu watende. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafalisayo na Wayahudi wayagwe wokweleleza mafundizo gawabokele kwa wahenga zao, hawaja kinhu mbaka wasunhe makono gao ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wala hawaja kinhu chochose kulawa kudigulilo mbaka wasunhe, na wokweleleza mafundizo gayagwe mengi kamba vija mwiko wa kusunha vikasi na nongo na viya va shaba na gayagwe mengi. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Avo Mafalisayo na Wafundiza Malagizo ga Musa wamuuza Yesu, “Habali wanahina zako hawakweleleza mafundizo gatugoleligwe na wahenga zetu, lakini woja bila kusunha makono?” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kawedika, “Mweye mwa wanafiki! Kumbe mtula ndagu wa Mulungu Isaya kalagula goya mbuli zenu viyandike, ‘Mulungu kolonga, wanhu wano, wonitegeleza kwa milomo yao, lakini mizoyo yao yakutali ng'hani na niye. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awo wonitambikila bule, kwavija wofundiza mafundizo ga wanhu, na kugatenda kamba galawa kwa Mulungu!’ ");
INSERT INTO kdc2014_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mweye mogaleka Malagizo ga Mulungu na mogagoga mafundizo ga wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu kagendelela kulonga, “Mweye mwa wabala kwa kulema Malagizo ga Mulungu na kugagoga mafundizo genu wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwavija Musa kawalagiza, ‘Mtegeleze tatako na mamako,’ ‘Munhu yoyose yonda yamulige tatake hebu mamake kolondeka yakomigwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini mweye mofundiza, kamba munhu kana kinhu kodaha kumtaza tatake hebu mamake lakini kolonga ‘Ino kobani’ fambulo jake kinhu kino nimulavila Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","munhu ayo halondeka kumtaza tatake hebu mamake. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwa nzila ino mafundizo genu gomuwagwaa wanhu gosegeza mbuli za Mulungu. Na gayagwe mengi kamba gano gomutenda.” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Abaho Yesu kalukema lunhu lwa wanhu kabili na kalulongela, “Mweye mose mnitegeleze na mujuwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kuduhu kinhu kingila mmulomo wa munhu kulawa kunze kidaha kumgela munhu dikwe. Lakini, kija kilawa mmulomo wa munhu acho kimgela munhu dikwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Munhu yeli na magwiti yahulike. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu na wanahina zake, viwalulekile lunhu lwa wanhu na kwingila mng'anda, wanahina zake wamuuza yawalongele fambulo da ulonzi uja. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kawalongela, “Vino mweye mduhu nzewele kubanza wanhu wayagwe? Vino hamujuwile kamba kuduhu kinhu kingila mmulomo wa munhu kulawa kunze kidaha kumgela munhu dikwe? ");
INSERT INTO kdc2014_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwavija hakingila muumoyo lakini mna iinda na abaho cholawa kunze ya lukuli.” Kwa ulonzi uno Yesu kavitenda vinhu vose va kuja vinoge kudigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kagendelela kulonga, “Kinhu kilawa muumoyo wa munhu acho kimgela munhu dikwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwavija muumoyo wa munhu molawa magesa gehile na kuiwasa chaka chaka na ubavi na ukomaji, ");
INSERT INTO kdc2014_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na ugoni na umelo na gehile na uvizi na kusulukila na migongo na maligo na kuitapa na ubozi. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ago gose gehile golawa mgati mwa munhu na kumgela munhu dikwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Abaho Yesu kahalawa hanhu aho kachola mwiimbaka ili behi na buga da Tilo. Kengila mng'anda na halondile munhu yoyose yajuwe kakala aho, lakini hadahile bule kuifisa. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mtwanzi imoja, yakalile na mndele wake yeli na kinyamkela, viyahulike mbuli za Yesu, bahaja kamgendela na kamfugamila Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mtwanzi ayo hakalile Muyahudi, kavumbuka kudibuga da Silofoinike mwiisi ya Siliya kampula Yesu yamulave mndele wake kinyamkela. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lakini Yesu kamwidika, “Tanhu waleke wana wegute. Kwavija havinogile bule kusola lujo lwa iwana na kuwapigisila umbwa.” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mtwanzi ayo kamwidika, “Ona, go mkulu, lakini hata umbwa weli hasi mmeza woja kija kisigazigwe na iwana!” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu kamulongela mtwanzi ayo, “Kwavija kwidika vivo, bwela ukayako na komvika mndele wako kinyamkela kamulawa!” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mtwanzi ayo kachola ukayake, viyavikile kamvika mndele wake katambalala mulusazi na kinyamkela kakala yamulawile. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu kasegela kachola behi na isi ya Tilo kwa kubitila mwiisi ya Sidoni mbaka kudilamba da Galilaya kwa kubitila nzila ya mna zimbaka za Dekapoli. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wanhu wayagwe wamgalila munhu yakalile hahulika na halonga, wampula Yesu yamwikile makono. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kamsola kamgala hamgwazo hanhu kuduhu wanhu. Yesu kengiza vidole mna gamagwitwi ga munhu ayo, katema mate kamkwasa lulimi. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Abaho Yesu kalola kuulanga, kabweza mhumuzi, kamulongela, “Efata!” fambulo jake, “Vuguka!” ");
INSERT INTO kdc2014_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bahaja munhu ayo magwiti gake gavuguka na kakala yohulika na kulonga bila kugaya. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Abaho Yesu kawagomesa wanhu awo sekewamulongele munhu yoyose mbuli ayo, lakini Yesu viyagendelele kuwagomesa, vivo viwagendelele kuibwililisa mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wanhu wose waihulike mbuli ayo wakanganya. Walonga, “Katenda goya kila kinhu, kowatenda wanhu hawahulika wahulike na wanhu hawalonga walonge!” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hazibitile siku nyingi lunhu luyagwe lukulu lwa wanhu luiting'hana. Wanhu viwakalile waduhu kinhu chochose cha kuja Yesu kawakema wanahina zake kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Niye nowonela bazi wanhu wano, kwavija wakala na niye kwa siku ndatu na waduhu kinhu cha kuja. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nahawalongela wabwele ukayao na nzala, wosinduka mnzila, kwavija wanhu wayagwe walawa kutali.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanahina zake wamuuza, “Hano hatwili twa kuluwala, tolupata kwahi lujo lwa kuwagwaa wanhu wose wano?” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kawauza, “Mna magate mangapi?” Wamwidika, “Tuna magate saba.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu kalulongela lunhu luja lwa wanhu lukale hasi. Abaho kasola gamagate saba, kamgwaa nhogolwa Mulungu, kagabanzula kawagwaa wanahina zake wawagolele wanhu, na wanahina zake watenda vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vivija wakala na visomba kidodo. Yesu kamgwaa nhogolwa Mulungu, vivija kawalongela wanahina zake wawagolele wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wanhu waja na kwiguta. Abaho wanahina zake wadondola vija visigale na kumemeza vigelo saba. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wambigalo waiyeka wadile wakala elufu nne. Abaho Yesu kawalaga, ");
INSERT INTO kdc2014_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bahaja Yesu na wanahina zake wakwela mwiingalawa, wachola mwiisi ya Dalimanuta. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo wayagwe wamcholela Yesu wasonga kuibamilila nayo, walonda kumgeza wampula yatende kilaguso kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lakini Yesu kona usungu, kalonga, “Habali wanhu wa lukolo luno lwa sambi molonda vilaguso? Nowalongeleni ukweli, kuduhu kilaguso chonda mugoleligwe!” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu kawaleka, kakwela mwiingalawa kaloka mwambu uyagwe wa dilamba. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanahina zake wakala waisemwile kusola magate, wakala na gate dimoja diiyeka mwiingalawa. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kawazuma wanahina zake kawalongela, “Muiteganye na usasu wa Mafalisayo na usasu wa Helode.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wanahina zake wasonga kuinyong'onyela, “Ino kolonga vino kwavija twaduhu magate.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kakijuwa kiwakalile wolonga, kawauza, “Habali moilongela mbuli ya magate? Vino mung'hali hamujuwile? Habali mizoyo yenu midala? ");
INSERT INTO kdc2014_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna meso lakini hamulola, muna magwiti lakini hamuhulika? Vino hamukumbuka bule? ");
INSERT INTO kdc2014_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Vinibanzule magate matano na kuwagwaa wanhu elufu tano? Vino mmemeza vigelo vingapi kwa avo visigale?” Wamwidika, “Tumemeza vigelo longo na vibili.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kawauza kabili, “Vivija vinibanzule gaja magate saba na kuwagwaa wanhu elufu nne, vino mmemeza vigelo vingapi kwa avo visigale?” Wamwidika, “Tumemeza vigelo saba.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Abaho kawauza, “Mung'hali hamnavijuwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu na wanahina zake viwavikile Betisaida, wanhu wayagwe wamgalila Yesu munhu yakalile msuwameso, wampula yamkwase. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kamgoga mkono munhu ayo, kamulava kunze ya kijiji kija. Abaho kamtemela mate mgameso, kamwikila makono, kamuuza, “Vino kokona choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Munhu ija kalola, kalonga, “Nowona wanhu, lakini waigala na mibiki itembela.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu kamwikila makono kabili mgameso. Munhu ayo kabunhula meso na meso gake galola, nayo kadaha kulola goya vinhu vose. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kamulongela munhu ayo yachole ukayake, kamzuma, “Sekeyabweleganye mna ikijiji.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Abaho Yesu na wanahina zake wachola kuna ivijiji va Kaisalia ya Filipi, mnzila Yesu kawauza wanahina zake, “Nongeleni wanhu wolonga niye na nani?” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamwidika, “Wanhu wayagwe wolonga gweye kwa Yohana Mbatizaji, wanhu wayagwe wolonga gweye kwa Eliya, kuno wayagwe wolonga gweye kwa imoja wa watula ndagu wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu kawauza, “Na mweye molonga niye na nani?” Petulo kamwidika, “Gweye kwa Kilisito Mkombola.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Abaho Yesu kawagomesa wanahina zake, “Sekemumulongele munhu yoyose mbuli zangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Abaho Yesu kasonga kuwafundiza wanahina zake, “Mwana wa Munhu kolondeka yadununzigwe ng'hani na kulemigwa na wavele na wakulu wa walava nhosa na wafundiza Malagizo ga Musa. Kokomigwa na siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kawalongela fulu ipile, avo Petulo kamgala Yesu kumgwazo kasonga kumkomhokela. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lakini Yesu kahinduka kawalola wanahina zake, kamkomhokela Petulo, “Segela kumwangu Mwenembago! Kwavija hugesa mbuli za Mulungu lakini kogesa mbuli za kiunhu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Abaho Yesu kalukema lunhu lwa wanhu na wanahina zake kawalongela, “Munhu yoyose yahalonda kunikweleleza, yaileme mwenyego na kuidikwa msalaba wake yanikweleleze. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwavija munhu yoyose yahalonda kuukombola ugima wake kowagiza, na munhu yoyose yowagiza ugima wake mbuli ya niye na kwa Mbuli Inogile koukombola. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vino munhu kopata choni kamba yahaipata isi yose na kuwagiza ugima wake? ");
INSERT INTO kdc2014_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kuduhu kinhu chonda yalave yaubweze ugima wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Munhu yoyose yonyonela kinyala niye na mafundizo gangu mna ulukolo lwa sambi lulekile kumjuwa Mulungu na kutenda gehile, Mwana wa Munhu nayo komonela kinyala munhu ayo yaheza muukulu wa Tatake na wasenga zake wang'alile wa kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kagendelela kulonga, “Nowalongela ukweli, wanhu wayagwe weli hano hawafa bule mbaka wawone Undewa wa Mulungu ukwiza na nguvu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vizibitile siku sita, Yesu kamsola Petulo, Yakobo na Yohana, kachola nao waiyeka kuna ulugongo lutali. Viwakalile wolola, Yesu kagaluka. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Viwalo vake vikala vizelu chuwee, na kuduhu munhu yoyose mwiisi yodaha kuvifuwa viwe vizelu kamba vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Baho wanahina waja wadatu wamona Eliya na Musa wolonga na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo kamulongela Yesu, “Mfundiza, vinoga tweye tukale hano! Tozenga viheha vidatu, kimoja chako gweye, kimoja cha Musa na kimoja cha Eliya.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo hajuwile cha kulonga kwavija heyo na wayage wakala wodumba. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Abaho dilawilila wingu na kuwagubika na sauti ilawa mdiwingu, ilonga, “Ino ayo Mwanangu inimnogele. Mumtegeleze!” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bahaja wawegesela kuno na kuno, lakini hawamonile munhu yoyose iyagwe, ila Yesu yaiyeka hamoja nao. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Viwakalile wohumuluka kulugongo Yesu kawazuma, “Sekemumulongele munhu yoyose mbuli zino zimone, mbaka Mwana wa Munhu vonda yazilibuke kulawa kwa wafile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Watogola kija kiwalongeligwe, lakini wasonga kuiuza, “Kuzilibuka kwa wafile, fambulo jake choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wanahina zake wamuuza Yesu, “Habali wafundiza Malagizo ga Musa wolonga Eliya kolondeka yeze tanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kawedika, “Ona, Eliya kokwiza tanhu, muladi yakitande goya kila kinhu. Lakini habali Maandiko Gang'alile golonga, Mwana wa Munhu kodununzika ng'hani na kulemigwa? ");
INSERT INTO kdc2014_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nowalongeleni, Eliya kamala kwiza na wanhu wamtendela viwalondile, kamba vija Maandiko Gang'alile vigalonga.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Viwawavikile waja wanahina wayagwe, waluwona lunhu lwa wanhu luwazunguluka na wafundiza Malagizo ga Musa wayagwe wakala woibamilila nao. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bahaja wanhu viwamone Yesu wakanganya ng'hani, wamkimbilila, wamulamusa. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kawauza wanahina zake, “Mweye moibamilila nao choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Munhu imoja mna ulunhu lwa wanhu kamwidika, “Mfundiza, nikugalila mwanangu, kana kinyamkela yamfungile mulomo. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kinyamkela ayo yahamwizila, komulagaza hasi na kolawa miholovu mumulomo, kodafuna meno na kunyala lukuli lose. Niwalongela wanahina zako wamulave ikinyamkela, lakini hawadahile bule.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kawalongela, “Mweye wanhu muleka kutamanila! Ng'hale na mweye mbaka lini? Nogela kitumbe kumgongo mbaka lini? Ngalileni hano imbwanga.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Avo wamgala kwa Yesu. Bahaja kinyamkela viyamone Yesu, kamgela kisango imbwanga ayo, kagwa hasi, kaibimbilisa, kuno kolava mihovu mumulomo. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamuuza tata wa imbwanga ayo, “Utamu uno umsonga lini?” Kamwidika, “Umsonga toka haudodo. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miyanza mingi kinyamkela kamgeza kumkoma kwa kumbwanha muumoto na mgamazi. Tonele bazi na ututaze, kamba wahadaha!” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kamulongela, “Kolonga, kamba wahadaha! Kila kinhu chodahika kwa munhu yotamanila.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bahaja tata wa imbwanga ija kakemelela, “Notamanila, lakini kutamanila kwangu kudodo. Nhaze nitamanile ng'hani!” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu viyaluwone lunhu lowamemela, kamkomhokela kinyamkela ayo, “Gweye kinyamkela wa kuleka kulonga na kuhulika, nokulagiza umulawe mbwanga ino, sekeumwingile kabili!” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kinyamkela kaguta, kambwanha hasi mbwanga ayo, kamulawa. Mbwanga ayo koneka kamba munhu yafile, kila munhu kalonga, “Kafa!” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu kamgoga mkono mbwanga ayo kamtaza kwinuka, nayo kenuka. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu viyengile mng'anda, wanahina zake wamuuza kinyelegezi, “Habali tweye hatudahile kumulava kinyamkela?” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kawedika, “Kinyamkela kamba ino hadahika kulavigwa kwa nzila yoyose, ila kwa kumpula Mulungu kwiiyeka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanahina zake wasegela hanhu aho wachola kubitila isi ya Galilaya. Yesu halondile munhu yoyose yajuwe kuyeli, ");
INSERT INTO kdc2014_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwavija kakala kowafundiza wanahina zake. Kawalongela, “Mwana wa Munhu kogeligwa mmakono ga wanhu, nao womkoma na siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakini wanahina zake hawadijuwile fambulo da ulonzi awo na wadumba kumuuza. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wavika Kapelinaumu, viwengile mng'anda, Yesu kawauza wanahina zake, “Mukala muibamilila choni mnzila?” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakini wanahina zake hawamwidike bule, kwavija mnzila wakala woibamilila nani yeli munhu mkulu viweli. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kakala hasi, kawakema wanahina zake longo na wabili, kawalongela, “Munhu yoyose yolonda kuwa wa ichanduso, kolondeka yawe wa ikimambukizo na yawe msang'hanaji wa wose.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Abaho Yesu kamsola mwana mdodo kamwimiza haulongozi wao, kamuhagatila kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munhu yoyose yombokela mwana mdodo kamba ino kwa twaga jangu, kombokela niye, na munhu yoyose yombokela niye hambokela niye niiyeka vivija kombokela ija yanhumile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana kamulongela Yesu, “Mfundiza, tumona munhu imoja kolava vinyamkela kwa twaga jako. Tweye tumgomesa kwavija siyo miyetu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kawalongela, “Sekemumgomese, kwavija kuduhu munhu yotenda unzonza kwa twaga jangu na kuno kononga vihile. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwavija munhu yoyose hatulema kaubanzi wetu. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nowalongela ukweli munhu yoyose yowagwaa kikasi cha mazi ga kung'wa kwa twaga jangu kwavija mweye mwa wanhu wa Kilisito kobokela nhunza yake. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Munhu yoyose yomuhonza imoja wa wadodo wano wonitogola yatende nzambi, yokuwa vinoga munhu ayo yagodekigwe dibwe kulu da kudugila msingo na yasigwe mbahali. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kamba mkono wako wahakuhonza utende nzambi, ukanhe! Yokuwa vinoga wingile kuna ugima na mkono umoja, kubanza wingile na makono mabili na abaho uchole jehanamu kuna umoto haufaga. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mumo, ‘Funza wowaja hawafa bule na umoto uwalukuza haufaga.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kamba mgulu wako wahakuhonza utende nzambi, ukanhe! Yokuwa vinoga wingile kuna ugima na mgulu umoja, kubanza wingile na magulu gose mabili na abaho wasigwe jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mumo, ‘Funza wowaja hawafa bule na umoto uwalukuza haufaga.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kamba siso jako dahakuhonza utende nzambi, ding'ole! Yokuwa vinoga wingile Muundewa wa Mulungu na siso dimoja, kubanza wingile na meso gose mabili na abaho wasigwe jehanamu. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mumo, ‘Funza wowaja hawafa bule na umoto uwalukuza haufaga.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila munhu kotendigwa yatogoligwe na Mulungu kwa moto kamba vija nhosa viitogoligwa na Mulungu kwa mkele. ");
INSERT INTO kdc2014_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mkele unoga, lakini kamba wahagiza ukali wake, vino kodahaze kuubweza kabili? “Muwe na mkele mgati yenu na mukale kwa tindiwalo na waenu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Abaho Yesu kasegela kachola isi ya Yudea, kaloka lwanda lwa Yolidani, lunhu lwa wanhu lumcholela Yesu kabili, nayo kawafundiza kamba viyatendaga. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafalisayo wayagwe wamcholela Yesu wamgeza, wamuuza, “Tulongele, vino vinoga mbigalo kumwasa mwehe wake?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kawauza, “Vino Musa kawalagiza choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wamwidika, “Musa katulagiza kamba mbigalo kodaha kumgwaa kibua cha nyasa mwehe wake na kumwasa.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kawalongela, “Musa kawandikila lagizo dino mbuli ya udala wa mizoyo yenu. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maandiko Gang'alile golonga kulawa kuna ichanduso, ‘Mulungu kawaumba mbigalo na mtwanzi. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwa mbuli ayo mbigalo komuleka tatake na mamake na koilumba na mwehe wake, ");
INSERT INTO kdc2014_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na wabili awo wokuwa kinhu kimoja.’ Avo haweli wabili kabili, lakini kinhu kimoja. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Avo kiyalumbilize Mulungu, munhu sekeyakigole.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Viwabwelile mng'anda, wanahina zake wamuuza Yesu mbuli ino. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu kawalongela, “Mbigalo yomwasa mwehe wake na kumsola mtwanzi iyagwe, komtendela ugoni mwehe wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vivija mtwanzi yomulema mkasano wake na kusoligwa na mbigalo iyagwe kotenda ugoni.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wanhu wayagwe wamgalila Yesu wana wadodo yawahagatile na kuwatambikila, lakini wanahina zake wawakomhokela. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu viyonile avo, kagevuzika, kawalongela, “Walekeni wana wadodo weze kumwangu sekemuwagomese kwavija Undewa wa Mulungu ni wa wanhu kamba wana wano. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nowalongeleni ukweli, munhu yoyose yolema kuubokela Undewa wa Mulungu kamba mwana mdodo, honda yengile ng'o.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Abaho kawahagatila wana waja kawekila makono gake kawatambikila. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu viyasongile mwanza wake kabili, munhu imoja kamkimbilila, kamfugamila kamuuza, “Mfundiza Unogile, nhende choni niupate ugima wa mazuwa gose?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kamuuza, “Habali kong'hema unogile? Kuduhu yanogile, ila Mulungu yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kugajuwa Malagizo ga Musa, ‘Sekeukome, sekeutende ugoni, sekewibe, sekeulave usindila wa uvizi, sekeulonge uvizi, wategeleze tatako na mamako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munhu ayo kamwidika, “Mfundiza gano gose nigagoga toka haudodo.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamulola bunhuu, kamnogela, kamulongela, “Kuhungukilwa kinhu kimoja. Genda kachuuze vinhu vose viulinavo na uwagwelele wakiwa zisente na gweye kokuwa na utajili kuulanga. Abaho unikweleleze.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Munhu ija viyahulike avo, kona usungu, kasegela kuno kanyunyuwala kwavija kakala tajili ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kalola mhande zose kawalongela wanahina zake, “Yokuwa vidala ng'hani kwa munhu tajili kwingila Muundewa wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ulonzi uno uwasinhusa wanahina zake, lakini Yesu kagendelela kulonga, “Wanangu, vidala ng'hani kwingila Muundewa wa Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vibuha kwa ngamiya kubita mna ikizonzo cha sanzia kubanza tajili kwingila Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanahina wakanganya ng'hani waiuza, “Avo lelo nani yonda yadahe kukomboligwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kawalola bunhuu, kawalongela, “Kwa munhu haidahika lakini kwa Mulungu haili vivo, gose godahika kwa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulo kamulongela, “Lola, tweye tuleka kila kinhu na tukukweleleza gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kawedika, “Nowalongela kweli, munhu yoyose yalekile ng'anda yake hebu ndugu zake hebu lumbu zake hebu mamake hebu tatake hebu wanage hebu migunda mbuli ya niye na kwa Mbuli Inogile, ");
INSERT INTO kdc2014_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kobokela vingi ng'hani mna ikipindi cha sambi. Na kobokela ng'hani miyanza gana, ng'anda na ndugu na lumbu na wana na mama na migunda na hamoja na madununzo na mna ikipindi chondakize kobokela ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakini wanhu wengi weli wa ichanduso wokuwa wa ikimambukizo na waja wa ikimambukizo wokuwa wa ichanduso.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na wanahina zake wakala mnzila wochola Yelusalemu. Yesu kawalongolela wanahina zake wakalile wokanganya kuno wanhu wakalile womkweleleza wadumba. Yesu kainega hamgwazo na wanahina zake longo na wabili, kawalongela gaja gonda gamulawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesu kawalongela, “Tegelezeni, tochola Yelusalemu, kuko Mwana wa Munhu kogeligwa mmakono ga wakulu wa walava nhosa na wafundiza Malagizo ga Musa. Womtagusa yafe na kogeligwa mmakono ga wanhu haweli Wayahudi, ");
INSERT INTO kdc2014_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nao womzeha na womtemela mate na womtowa mbalati na womkoma lakini siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Abaho Yakobo na Yohana, wana wa Zebedayo wamcholela Yesu, wamulongela, “Mfundiza, kuna kinhu tolonda ututendele.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu kawauza, “Molonda niwatendele choni?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamwidika, “Vondaukale kuna ikigoda chako cha Undewa wako, tolonda ukale na tweye, imoja mwambu wa mkono wako wa kudila na iyagwe mwambu wa mkono wako wa kumoso.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kawalongela, “Hamkijuwile kinhu kimpula. Vino modaha kuking'wela kikasi cha madununzo chonda niking'wele niye? Na kubatizigwa ubatizo unibatizigwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamwidika, “Todaha,” Yesu kawalongela, “Mong'wela kikasi chonda ning'wele niye na kubatizigwa ubatizo wonda nibatizigwe niye. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lakini niye nabule udahi wa kusagula nani yakale mwambu wa mkono wangu wa kudila hebu wa kumoso. Mulungu ayo yonda yawagwee hanhu aho, wanhu waja yawasagule.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Baho wanahina longo viwahulike vivo wawagevuzikila ng'hani Yakobo na Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kawakema wose hamoja kawalongela, “Mojuwa kamba waja wokoneka wakulu wa isi, wowalanguliza wanhu kwa nguvu, na wakulu wao wana udahi. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini haili vivo kumwenu. Munhu yoyose yolonda kuwa munhu mkulu, yawe msang'hanaji wa wose. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na munhu yoyose yolonda kuwa wa ichanduso, yawe mtumwa wa wose. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwavija Mwana wa Munhu hezile kusang'hanilwa, lakini keza kuwasang'hanila wanhu na kuulava ugima wake kwa kuwakombola wanhu wengi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wavika Yeliko. Yesu na wanahina zake hamoja na lunhu lwa wanhu viwakalile wosegela, msuwameso imoja yakalile yopula, twaga jake Batumayo, mwanage Timayo kakala mnzila. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Batumayo viyahulike Yesu wa Nazaleti kobita, kasonga kukemelela, “Yesu, mwanage Daudi nyonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wanhu wengi wamkomhokela, wamulongela yanyamale, lakini heyo kagendelela kukemelela ng'hani, “Mwana wa Daudi, nyonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kema, kalonga, “Mkemeni.” Avo wamkema, wamulongela, “Gangamala! Ima, kokukema.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kawasa mgolole wake, kazumha kamcholela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kamuuza, “Kolonda nikutendele choni?” Munhu ayo kamwidika, “Mfundiza, nolonda kulola.” ");
INSERT INTO kdc2014_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kamulongela, “Chola, kutamanila kwako kukuhonya.” Bahaja kadaha kulola kamkweleleza Yesu mnzila. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Viwavikile behi na Yelusalemu, habehi na mabuga ga Betifage na Betania kuna Ulugongo lwa Mizeituni, Yesu kawatuma wanahina zake wabili wamulongolele. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kawalongela, “Gendeni kuna ikijiji kili kuulongozi wenu, mwahengila momvika mwana mhunda kafungigwa, nayo yang'hali hanakweligwa na munhu. Mfunguleni mumgale hano. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Munhu yoyose yahawauza habali motenda avo, mulongeleni Mndewa komulonda, nayo kombweza sambi baha.” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wanahina waja wachola wamvika mwana mhunda kafungigwa hana ulwivi lwa ng'anda uilola na nzila. Viwakalile womfungula, ");
INSERT INTO kdc2014_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wanhu wemile aho wawauza, “Motenda choni, habali momfungula imhunda?” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wawedika kamba Yesu viyawalongele, wanhu waja wawaleka wachole. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamgala imwana mhunda ayo kwa Yesu, watandika viwalo vao mumgongo wa imhunda, Yesu kakwela uchanha. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanhu wengi wanzanza viwalo vao mnzila, na wayagwe wabena mibunho wayanzanza mnzila. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wanhu wakalile kukisogo na kuulongozi wa Yesu wakemelela, “Mulungu yatogolwe! Mndewa Mulungu yamtambikile ayo yokwiza kwa twaga jake! ");
INSERT INTO kdc2014_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mulungu yautambikile undewa ukwiza wa mndewa Daudi, muhenga wetu! Mulungu yeli uchanha ng'hani yatogolwe!” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kavika Yelusalemu, kachola kuna Ing'anda ya Mulungu, kawegesela kuno na kuno. Lakini kwavija zuwa dikala dihongile, Yesu kachola Betania na wanahina zake longo na wabili. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imitondo yake, viwakalile wosegela Betania, Yesu kakala na nzala. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kwa kutali Yesu kawona mbiki wa mtini ukalile na mijani mingi, avo kaucholela yalole kamba kodaha kupata tunda jojose lakini viyavikile honile tunda jojose, ila majani gaiyeka, kwavija haukalile msimu wa kulela. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu kaulongela mbiki wa mtini, “Munhu sekeyaje tunda jojose kumwako kabili!” Wanahina zake wamuhulika viyalongile vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Viwavikile Yelusalemu, Yesu kachola kuna Ing'anda ya Mulungu. Kasonga kuwawinga wanhu wose wakalile wogula na kuchuuza vinhu. Kazibidula meza za wanhu wakalile wovunja sente na vigoda va wanhu wakalile wochuuza njiwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kawagomesa sekewasole kinhu chochose kubitila kuna Ing'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abaho kawafundiza, “Yandikigwa mna Gamaandiko Gang'alile, ‘Ng'anda yangu yokuwa kae ya kupulila kwa wanhu wa isi zose.’ Lakini mweye moitenda mhango ya wabavi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wakulu wa walava nhosa na wafundiza Malagizo ga Musa viwahulike vivo, wasonga kuzahila nzila ya kumkoma Yesu, lakini wamdumba, kwavija lunhu lwa wanhu lukanganya mafundizo gake. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Viivikile ichungulo, Yesu na wanahina zake wasegela kudibuga. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Imitootondo yake, viwakalile wobita mnzila wawona mbiki awo wa mtini unyala gogodaa! ");
INSERT INTO kdc2014_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo kakumbuka kija kilawilile, kamulongela Yesu, “Mfundiza, lola, umbiki wa mtini uuduile unyala!” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kawedika, “Mumtogole Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nowalongela ukweli, munhu yoyose yahakilongela kigongo kino, Ng'oka ukayase mbahali na hakona shaka muumoyo wake lakini kotogola kiyolonga cholawilila, na Mulungu komtendela. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Avo nowalongeleni, mwahampula Mulungu kinhu chochose, togoleni kamba mubokela, mogweleligwa chochose chonda mupule. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mwahampula Mulungu geleni kumgongo nzambi ziwawatendele wanhu, muladi Tataenu yeli kuulanga nayo yazigele kumgongo nzambi zenu zimutendile. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kamba hamuzigela kumgongo nzambi za wanhu ziwawatendele, na Tataenu yeli kuulanga honda yazigele kumgongo bule nzambi zenu zimutendile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wavika kabili Yelusalemu, Yesu viyakalile kogenda kuna Ing'anda ya Mulungu, wakulu wa walava nhosa na wafundiza Malagizo ga Musa na wavele wamcholela, ");
INSERT INTO kdc2014_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wamuuza, “Vino kotenda gano gose kwa udahi gani? Nani yakugwelele udahi wa kutenda gano?” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kawedika, “Na niye nowauza mbuli imoja, mwahanidika, baho nowalongeleni notenda gano kwa udahi gani. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nongeleni, udahi wa Yohana wa kubatiza ulawa kwa Mulungu hebu kwa wanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wasonga kuilongela, “Twahalonga, ‘Ulawa kwa Mulungu,’ kotuuza, ‘Habali hamumtogole Yohana?’ ");
INSERT INTO kdc2014_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lakini twahalonga, ‘Ulawa kwa wanhu,’” wawadumba wanhu, kwavija wanhu wamtogola Yohana kamba mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Avo wamwidika, “Tweye hatujuwile.” Yesu kawalongela, “Na niye siwalongela bule kwa udahi gani notenda gano.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu kalonga nao kwa simo, “Munhu imoja kahanda mizabibu mumgunda wake. Kazungulusila lwigo mumgunda wake, kahimba hanhu ha kukamila zabibu, kazenga lingo. Abaho kawakodisha walimaji, kafunga mwanza kachola. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Msimu wa kubawa zabibu viuvikile, kamtuma msang'hanaji kwa awo walimaji yamgalile zabibu kulawa mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lakini walimaji awo wamgoga, wamtowa, wamuwinga makono gaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Abaho kamtuma msang'hanaji iyagwe, ayo nayo wamtowa mdipala na wamgela kinyala. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwene mgunda kamtuma msang'hanaji iyagwe, nayo wamkoma, na kawatuma wayagwe wengi wawatendela vivo, wayagwe wawatowa na wayagwe wawakoma. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kakala kasigala na munhu imoja wa kumtuma, nayo kakala mwanage yamnogele ng'hani. Kamtuma kuno kolonga, ‘Womtegeleza mwanangu.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini walimaji wailongela, ‘Ino ayo muhazi, lekeni tumkome tusole uhazi wake!’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Avo wamgoga, wamkoma wamwasa kunze ya umgunda wa imizabibu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kawauza, “Vino mwene mgunda kotendaze? Kokwiza kuwakoma walimaji wose na kowakodisha walimaji wayagwe mgunda awo wa mizabibu. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hamgasomile Maandiko Gang'alile vigalonga, ‘Dibwe wadilemile wazengaji, Sambi digalamuka dibwe kulu kubanza gose. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mbuli ino itendigwa na Mndewa, nayo yotukanganya!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Walangulizi wa Wayahudi walonda kumgoga Yesu, kwavija wajuwa lusimo luno kawalonga wao. Lakini waludumba lunhu lwa wanhu, avo wamuleka wasegela. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mafalisayo wayagwe na wanhu wa Helode wakala watumigwe kwa Yesu, wamgoge kwa mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wamcholela wamulongela, “Mfundiza, tokujuwa gweye kwa munhu ulonga ukweli, humdumba munhu yoyose, hutonga ukulu wa munhu. Lakini gweye kofundiza goyolonda Mulungu wanhu wagatende. Tulongele, vino vinoga kulipa kodi kwa Mndewa wa Lumi hebu havinogile bule? Tulipe hebu seketulipe?” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini Yesu kaujuwa ubala wao kawauza, “Habali monigeza? Ngalileni isente niilole.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamgalila isente, nayo kawauza, “Vino kihanga kino cha nani? Na twaga dino da nani?” Wamwidika, “Va Mndewa wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu kawalongela, “Mgweleleni Mndewa wa Lumi vili va Mndewa wa Lumi, na mgweleleni Mulungu vili va Mulungu.” Nao wamkanganya Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abaho Masadukayo, wanhu wolonga kuduhu kuzilibuka kulawa kwa wafile. Wayagwe wamcholela Yesu wamulongela, ");
INSERT INTO kdc2014_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mfundiza, Musa katwandikila, ‘Munhu yahafa na kuleka mwehe wake bila wana, ndugu yake munhu ayo kolondeka yamsole mgane ayo, yamulelele ndugu yake yafile wana.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kukala na ndugu saba, ija imkulu kasola mwehe kafa halekile wana. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wakabili nayo kamuhala mgane ayo nayo vivija kafa halekile wana. Vivija kwa wakadatu kafa halekile wana. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Abaho kwa wayagwe, wose saba wamsolile mgane ayo wafa hawalekile wana. Ako kumwande, mtwanzi ayo nayo kafa. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Avo, wanhu wose wafile wahazilibuka mwiisiku ya kuzilibuka, mtwanzi ayo kokuwa mwehe wa nani? Kwavija wose saba wakala wamsolile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kawedika, “Mweye mopotela! Kwavija hamugajuwile Maandiko Gang'alile hebu udahi wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwavija wanhu wafile vonda wazilibuke, hawasola wala hawasoligwa wokuwa kamba wasenga wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwa mbuli ya kuzilibuka kwa wanhu wafile, hamusomile mna ikitabu cha Musa mbuli ya kisolo kikwaka? Mulungu kamulongela Musa, ‘Niye na Mulungu wa Abulahamu na wa Isaka na wa Yakobo.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Heyo heli Mulungu wa wanhu wafile, ila Mulungu wa wanhu wagima. Avo mweye mopotela ng'hani!” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mfundiza Malagizo ga Musa imoja yakalile aho kahulika viwaibamilile. Kona kamba Yesu kawedika goya Masadukayo, avo kamkwesela Yesu kamuuza, “Mna ga Malagizo gose lagizo gani dili kulu?” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kamwidika, “Lagizo dili kulu ijo dino, ‘Tegelezeni mweye wanhu wa Izilaeli! Mndewa Mulungu wetu ayo Mndewa yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mnogele Mndewa Mulungu wako kwa moyo wako wose, kwa loho yako yose, kwa nzewele zako zose, na kwa nguvu zako zose.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lagizo da kabili kwa ukulu ijo dino, ‘Mnogele miyago kamba viuinogela mwenyego.’ Kuduhu lagizo diyagwe kulu kubanza gano mabili.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mfundiza Malagizo ga Musa kamtogola Yesu, “Mfundiza, kwidika goya viulongile, Mndewa ayo Mulungu na kuduhu iyagwe ila heyo. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumnogela Mulungu wako kwa moyo wako wose na kwa nzewele zako zose na kwa nguvu zako, na kumnogela miyago kamba viuinogela mwenyego, kunoga ng'hani kugoga Malagizo gano mabili kubanza kumulavila Mulungu nhosa za wanyama na nhosa ziyagwe.” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu viyonile munhu ayo kedika goya, kamulongela, “Huli kutali na Undewa wa Mulungu.” Kusongela aho haduhu munhu yoyose yagezile kumuuza Yesu mbuli yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu viyakalile kofundiza Mng'anda ya Mulungu, kawauza, “Habali wafundiza Malagizo ga Musa wolonga Kilisito Mkombola mwana wa Daudi? ");
INSERT INTO kdc2014_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Loho Yang'alile kamulongoza Daudi kulonga, ‘Mndewa Mulungu kamulongela Mndewa wangu, Kala hano hana mwambu wa mkono wangu wa kudila mbaka niweke hasi mmagulu gako wanhu wakwihile.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Avo Daudi mwenyego kamkema, ‘Mndewa.’ Avo Kilisito Mkombola kodahaze kuwa mwana wa Daudi?” Lunhu lwa wanhu lukala lumtegeleza Yesu kwa kudeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Viyakalile kofundiza, kawalongela, “Muiteganye na wafundiza Malagizo ga Musa, wonogelwa kugenda kuno wovala mikanzu mitali na kulamusigwa na wanhu mna gamagulilo, ");
INSERT INTO kdc2014_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","wosagula vigoda va haulongozi mzing'anda za kumpula Mulungu na kukala hanhu hanogile mna izinyimwili nyimwili. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wowaboka wagane vinhu na kusola ng'anda zao, abaho woilagusa wanoga kwa kumpula Mulungu mbuli nyingi. Nhaguso yao yokuwa ng'hulu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu kakala behi na kigelo cha kulavila sadaka hana Ing'anda ya Mulungu, kawalola wanhu viwolava sente mkigelo. Matajili wengi walava sente nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Abaho keza mgane mkiwa kalava sente mbili ndodo. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kawakema wanahina zake kawalongela, “Nowalongela ukweli mgane mkiwa ino kalava sente nyingi mna ikigelo cha sadaka kubanza wose wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwavija wose walava vija visigale muutajili wao, lakini mgane ino hamoja na ukiwa wake kalava vose viyelinavo.” ");
INSERT INTO kdc2014_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu viyakalile kosegela kuna Ing'anda ya Mulungu, mwanahina wake imoja kamulongela, “Mfundiza, lola mabwe gano na ng'anda zino vizinogile!” ");
INSERT INTO kdc2014_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamwidika, “Kozona ng'anda zino vizili ng'hulu? Haduhu dibwe donda dilekigwe uchanha ya diyagwe, kila dibwe dokwasigwa hasi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu viyakalile kuna Ulugongo lwa Mizeituni, mwambu kwa mwambu na Ng'anda ya Mulungu, baho Petulo na Yakobo na Yohana na Andeleya wamcholela Yesu kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Wamulongela, “Tulongele, choni chonda kitendeke kulagusa kipindi cha kulawilila gano gose?” ");
INSERT INTO kdc2014_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kawalongela, “Muiteganye, munhu yoyose sekeyawavizile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wanhu wengi, wokwiza kwa twaga jangu na kulonga, ‘Nene iyo heyo!’ Nao wowavizila wanhu wengi. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mwahahulika mbuli za ng'hondo kutali na mbuli za ng'hondo mmabehi, sekemudumbe, kwavija gano gose golondigwa galawilile, ila kimambukizo king'hali hakinavika. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isi yoitowa na isi iyagwe, undewa woitowa na undewa uyagwe. Kila hanhu hokuwa na mitigisiko mikulu ya isi na lufilili lwa nzala. Gano gose kamba mwanduso wa usungu wa kulela mwana. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Na mweye muiteganye. Mogogigwa na kugaligwa mkitala. Motoigwa mna izing'anda za kumpula Mulungu, mogaligwa haulongozi wa wakulu wa isi na wandewa mbuli ya niye, muladi muwalongele Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lakini kimambukizo king'hali hakinavika, Mbuli Inogile tanhu yolondeka ipetigwe kwa wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mwahagogigwa na kugaligwa mkitala, sekemunyawenyawe mbuli ya kulonga. Kipindi chahavika longeni chochose chonda mugweleligwe. Kwavija mbuli zonda mulonge hazili zenu, ila zolawa kwa Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Munhu komuhinduka ndugu yake too yakomigwe, na tata komuhinduka mwanage yakomigwe. Wana wowahinduka tata zao na mama zao wakomigwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wanhu wose wowehila mweye mbuli ya niye, lakini yoyose yonda yafunge umoyo mbaka kukimambukizo kokomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Vondamuchone, ‘Kinhu kinyolodoke kigala Ubananzi’ kima hanhu si hake. Munhu yosoma yavijuwe, waja weli mwiisi ya Yudea wakimbilile kuna ivigongo. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Munhu yeli mkiswili cha ng'anda yake sekeyahumuluke hasi mna ing'anda yake kusola kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yeli kumgunda sekeyabwele ukae kusola kiwalo chake. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wogaya watwanzi wali na zinda na waja wokong'heza mna izisiku azo. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mpuleni Mulungu mbuli zino sekezilawilile mna ikipindi cha kihuhwe! ");
INSERT INTO kdc2014_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwavija siku azo hokuwa na magayo makulu, haganalawila kulawa kuna ichanduso Mulungu viyaumbile isi mbaka sambi na honda galawilile kabili. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lakini Mulungu kazihunguza siku zizo, maza hazihunguze sambi yahone munhu yoyose. Lakini mbuli ya wanhu zake yawasagule, Mulungu kazihunguza siku zizo. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Avo, munhu yoyose yahawalongela, ‘Amweye, Kilisito kahano!’ hebu ‘Kahaja!’ sekemumtogolele. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwavija wolawilila makilisito na watula ndagu wa uvizi. Wotenda unzonza na vilaguso muladi yahadahika wawavizile hata waja wasaguligwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Muiteganye! Niye niwalongela kila kinhu kipindi king'hali hakinavika. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Gahamala magayo ga siku azo, zuwa dokuwa ziza, na mwezi honda umwemwese bule, ");
INSERT INTO kdc2014_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nhondo zolagala kulawa kuulanga, na vinhu vili kuulanga votigisika. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Abaho Mwana wa Munhu kolawilila, kokwiza mna gamawingu kwa nguvu ng'hulu na ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abaho kowatuma wasenga zake wa kuulanga mna izibanzi nne za mwiisi, waweke hamoja wanhu wasaguligwe na Mulungu kulawa mwambu uno wa isi na uyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ifunzeni kubitila mbiki wa mtini. Matambi gake gahasonga kuzuka na kwika majani, mujuwe kamba vuli da mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Vivija, mwahazona mbuli azo, mojuwa kamba kammabehi kwiza. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nowalongeleni ukweli, wanhu wa lukolo luno hawafa wose mbaka gano gose galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ulanga na isi vobita, lakini mbuli zangu hondazibite ng'o. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kuduhu yaijuwile siku hebu saa ya kwiza, siyo wasenga wa kuulanga wala Mwana, lakini Tata yaiyeka ayo yaijuwile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muiteganye, na mukale meso, kwavija Hamkijuwile kipindi chonda yeze. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yokuwa kamba munhu yofunga mwanza na kuwaleka wasang'hanaji zake walolese goya vinhu, kila munhu kamgwaa sang'hano yakutenda. Kamulagiza mkalizi wa mulango yakale meso. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Muiteganye, kwavija hamujuwile kipindi cha kwiza mkulu wa ng'anda, yodaha kuwa ichungulo, kilo kikulu, nzogolo zikwika, hebu imitondo. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yaheza kwa kuwasinhusa, sekeyawavike muwasile. ");
INSERT INTO kdc2014_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mbuli iniwalongele mweye, nowalongela wanhu wose, kaleni meso!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zikala zisigale siku mbili ivike Nyimwili nyimwili ya Pasaka na Magate haganageligwa usasu. Wakulu wa walava nhosa na wafundiza Malagizo ga Musa wakala wozahila nzila ya kumgoga Yesu wamkome. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Walonga, “Seketutende avo kipindi cha Nyimwili nyimwili ya Pasaka, buleavo wanhu woding'huka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu kakala Betania mng'anda ya Simoni, munhu yakalile na utamu wa dikulu. Viyakalile koja, mtwanzi imoja keza na nyhupa ya alabasita imemile mavuta gonung'hila goya ga bei ng'hulu. Kaifungula, kamgidila Yesu ga mavuta mdipala. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wanhu wayagwe wakalile aho wagevuzika, wailongela, “Unanzi gani uno wa mavuta!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abaho wamkomhokela mtwanzi ayo, walonga, “Mavuta gano gahauzigwe kwa sente magana madatu na zisente wagweleligwe wakiwa!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lakini Yesu kawalongela, “Mulekeni, habali momgaza mtwanzi ino? Niye kanhendela mbuli inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wanhu wakiwa mokala nao siku zose, saa yoyose mwahalonda modaha kuwataza. Lakini honda mukale na niye siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mtwanzi ino katenda viyadahile, kalongola kulubakaza lukuli lwangu mavuta ganogile, kulutanda kwa kuzikigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nowalongeleni ukweli, kokose konda ipetigwe Mbuli Inogile mwiisi, kino kiyatendile mtwanzi ino cholongigwa, avo wanhu womkumbuka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Abaho imoja wa wanahina zake longo na wabili yakemigwe Yuda Isikaliote, kachola kwa wakulu wa walava nhosa yamuhinduke Yesu kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Avo viwahulike kiyalongile wadeng'helela, na wailagana nayo kumgwaa sente. Avo Yuda kasonga kuzahila nzila ya kumgela Yesu mmakono gao. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mna isiku ya ichanduso ya Nyimwili nyimwili ya Magate hagageligwe Usasu, siku dijo mwana ng'hondolo wa Pasaka kochinjigwa, wanahina zake Yesu wamuuza, “Kolonda tuchole kwahi tukutandile lujo lwa Pasaka?” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu kawatuma wanahina zake wabili kawalongela, “Gendeni kudibuga, momting'hana mbigalo kaidikwa nongo ya mazi. Mkwelelezeni, ");
INSERT INTO kdc2014_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka mng'anda yonda yengile, mulongeleni mwene kae, ‘Mfundiza kolonga, da kwahi gati da kudila lujo lwa Pasaka niye na wanahina zangu?’ ");
INSERT INTO kdc2014_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nayo kowalagusila gati kulu dili uchanha dikigwa goya na dihambigwa. Mumo tutandileni.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanahina zake wasegela, wachola kudibuga, wavika kila kinhu vivija viyawalongele Yesu, avo wamtandila lujo lwa Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Viivikile ichungulo, Yesu kavika na wanahina zake longo na wabili. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Viwakalile woja, Yesu kalonga, “Nowalongeleni imoja wenu yoja na niye, konihinduka.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wanahina zake wanyawanyawa, wamuuza, imoja imoja, “Vino gweye kolonga niye?” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kawedika, “Imoja wenu mweye longo na wabili, yozanhika gate jake hamoja na niye mbakuli. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana wa Munhu kofa kamba Maandiko Gang'alile vigolonga. Lakini kogaya munhu ija yomuhinduka Mwana wa Munhu. Yahanogile ng'hani kamba munhu ayo sambi yavumbuke!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Viwakalile woja, Yesu kasola gate, kamgwaa nhogolwa Mulungu, kadibanzula na kawagwaa wanahina zake kalonga, “Soleni, uno ulo lukuli lwangu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Abaho kasola kikasi cha divai, kamgwaa nhogolwa Mulungu, kawagwaa wanahina zake, wose waking'wela. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu kalonga, “Ino ayo damu yangu ilagusa lagano da Mulungu, ikwitika mbuli ya wanhu wengi. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nowalongela, kusongela sambi honda ning'we kabili divai, mbaka siku dijo donda ning'we divai ya sambi Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Abaho wemba lwila, wachola kuna Ulugongo lwa Mizeituni. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kawalongela, “Mweye mose mokimbila na kundeka niiyeka, kwavija Maandiko Gang'alile golonga, ‘Mulungu komtowa msusilaji, na ng'hondolo wose wopwililika.’ ");
INSERT INTO kdc2014_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini nahazilibuka, nowalongolela kuchola Galilaya.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo kamwidika Yesu, “Hata kamba wose wahakuleka, niye sikuleka bule!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kamulongela Petulo, “Nokulongela ukweli, kilo cha lelo nzogolo yang'hali hana kwika miyanza mibili, konibela miyanza midatu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petulo kagangamiza kulonga, “Silonga vivo bule, hata kamba nahafa na gweye!” Na wanahina wayagwe walonga vivo. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu na wanahina zake wavika hanhu hokemigwa Getisemane, Yesu kawalongela, “Kaleni hano, niye nogenda kumpula Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kawasola Petulo na Yakobo na Yohana. Yesu kona usungu na kanyunyuwala. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kawalongela wanahina zake, “Usungu uli muumoyo wangu mkulu ng'hani wodaha kung'homa. Kaleni hano meso.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kachola kumwande kidogo, kaibwanha hasi, kampula Mulungu, kamba yahadahika sekeyaibitile saa ayo ya madununzo. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kampula Mulungu, “Tata! Kumwako gose godahika. Ukisegeze kikasi kino cha madununzo. Lakini siyo kamba vinilonda niye ila viulonda gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abaho kabwela kawavika wanahina zake wadatu wawasa. Kamulongela Petulo, “Simoni kuwasa? Vino hamudahile kukala meso hata saa dimoja?” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kawalongela, “Kaleni meso, mumpule Mulungu sekemwingile mna ukugezigwa. Moyo wa munhu wolonda kutenda ganogile, lakini lukuli lwaduhu nguvu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kachola lwa kabili kumpula Mulungu, kalonga mbuli zizija. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Viyabwelile kabili, kawavika wanahina zake wawasa, kwavija meso gao gakala na utulo. Hawaijuwile mbuli yakumulongela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Viyabwelile mwanza wa kadatu, kawalongela, “Mung'hali muwasa na kubwihila? Yotosha! Kipindi kivika! Loleni, Mwana wa Munhu kogeligwa mmakono ga wanhu wene nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamukeni, tuchole. Loleni munhu yonihinduka kavika!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu viyakalile yang'hali yogendelela kulonga, imoja wa wanahina zake longo na wabili, yakemigwe Yuda Isikaliote kavika. Keza na lunhu lutumigwe na wakulu wa walava nhosa, wafundiza Malagizo ga Musa na wavele, kuno wapapa mapanga na malungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda Isikaliote yomuhinduka Yesu kawagwaa kilaguso, kawalongela, “Munhu yonda nimnonele ayo yummulonda. Mgogeni mumgele mmakono genu.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bahaja Yuda kamcholela Yesu kamulongela, “Mfundiza!” Abaho kamnonela. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Avo wamgoga Yesu wamgodeka. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lakini imoja wa waja wakalile na Yesu, kasomola panga jake, kamkanha digwiti msang'hanaji wa Mkulu wa walava nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kawalongela, “Vino habali mwizile kungoga na mapanga na malungu kamba vija nambavi? ");
INSERT INTO kdc2014_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila siku ng'hala na mweye, nowafundiza kuna Ing'anda ya Mulungu, hamnigogile. Lakini gano gatendeka muladi Maandiko Gang'alile galawilile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Abaho wanahina wose wamuleka wakimbila. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mbwanga imoja yavalile mgolole wiiyeka, kakala yomkweleleza Yesu. Walonda kumgoga, ");
INSERT INTO kdc2014_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lakini kauleka mgolole wake, kakimbila mwazi. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abaho Yesu kagaligwa mng'anda ya Mkulu wa walava nhosa, mumo wakulu wa walava nhosa wose, wavele na wafundiza Malagizo ga Musa waiting'hana. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo kamkweleleza Yesu kwa kutali, kengila muuluwa lwa mkulu wa walava nhosa, kakala hasi na wakalizi, kokotela moto. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wakulu wa walava nhosa na wanhu wose wa mkitala wazahila usindila wa uvizi muladi wamkome Yesu, lakini hawaupatile bule. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wanhu wengi walonga mbuli za uvizi kwa Yesu, lakini usindila wao hauwilumbile. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Abaho wanhu wayagwe wema walonga mbuli za uvizi kwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Walonga, “Tumuhulika kolonga, ‘Noibomola Ng'anda ino ya Mulungu izengigwe na wanhu, na kwa siku ndatu noizenga iyagwe haizengigwe na wanhu.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na awo vivija usindila wao hauwilumbile. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mkulu wa walava nhosa kenuka mgameso ga wanhu kamuuza Yesu, “Vino kuduhu mbuli ya kwidika kwa kitala choolava wanhu wano?” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini Yesu kanyamala tuluu, halongile mbuli, Mkulu wa walava nhosa kamuuza kabili, “Gweye ayo Kilisito Mkombola, Mwana wa ija Yotogoligwa?” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kamwidika, “Nene iyo heyo. Mweye momona Mwana wa Munhu kakala muukulu mwambu wa mkono wa kudila wa Mulungu yeli na Udahi, kokwiza mna gamawingu ga kuulanga!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mkulu wa walava nhosa kakidega kiwalo chake, kalonga, “Hatulonda usindila uyagwe! ");
INSERT INTO kdc2014_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muhulika viyomuliga Mulungu. Mweye mogesaze?” Wose walonga, kabananga kolondeka yakomigwe. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wanhu wayagwe wamtemela mate Yesu, wamgubika gameso, wamtowa na wamulongela, “Lagula, nani yakutowile!” Abaho wakalizi wamsola wamtowa ng'hofi. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo viyakalile yang'hali hasi muuluwa, msang'hanaji imoja wa kitwanzi wa mkulu wa walava nhosa kamcholela. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Viyamone Petulo kokotela moto, kamulola bunhuu kamulongela, “Gweye vivija kukala hamoja na Yesu wa Nazaleti.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petulo kabela, “Bule, sijuwile kiulonga.” Abaho Petulo kalawa kunze mbaka kuna uluhelengo. Bahaja nzogolo keka. ");
INSERT INTO kdc2014_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Msang'hanaji ija wa kitwanzi kamona Petulo, kawalongela wanhu wemile aho, “Ino nayo imoja wao!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lakini Petulo kabela kabili. Hamwande kidogo wanhu wakalile wemile aho wamulongela Petulo kabili, “Gweye vivija kwa imoja wao, kwavija kwa mwenekae wa Galilaya.” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petulo kalonga, “Mulungu kojuwa nolonga ukweli, niduiligwe nahalonga uvizi, simjuwile munhu yumulonga!” ");
INSERT INTO kdc2014_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bahaja nzogolo keka mwanza wa kabili, baho Petulo kakumbuka mbuli ziyalongeligwe na Yesu, “Nzogolo yang'hali hanakwika miyanza mibili, konibela miyanza midatu.” Avo Petulo kasonga kulila. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Imitootondo, wakulu wa walava nhosa, wafundiza Malagizo ga Musa, wavele na wanhu wose wa mkitala waiting'hana, waitogolela kumgala Yesu kwa Pilato. Wamgodeka nzabi, wamgala kwa Pilato. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kamuuza Yesu, “Gweye ayo Mndewa wa Wayahudi?” Yesu kamwidika, “Ona, vivo viulonga.” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wakulu wa walava nhosa wamulavila Yesu vitala vingi, ");
INSERT INTO kdc2014_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","avo Pilato kamuuza Yesu kabili, “Hulonda kwidika? Tegeleza viwokulavila vitala!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu hedike mbuli yoyose, Pilato kakanganya. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yahavikaga Nyimwili nyimwili ya Pasaka Pilato kamfungulilaga mfungwa imoja wamulondile wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mna ikipindi acho kukala na munhu imoja twaga jake Balaba, kakala yagodekigwe mkifungo na wayage, mbuli ya ukomaji kipindi wanhu viwading'huke. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lunhu lwa wanhu viluiting'hane, lumpula Pilato yawatendele kamba viyatendaga. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato kawauza, “Molonda niwafungulileni mndewa wa Wayahudi?” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato kajuwa goya kamba wakulu wa walava nhosa wamgela Yesu mmakono gake kwavija wamonela migongo. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini wakulu wa walava nhosa wawading'hula wanhu wampule Pilato yawafungulile Balaba. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kaluuza kabili lunhu luja, “Vino molonda nhende choni kwa munhu ino yumumkema mndewa wa Wayahudi?” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wanhu wose wakemelela, “Muwambe mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kawauza, “Vino kabananga choni?” Awo wagendelela kukemelela, “Muwambe mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kalonda kulunogeza lunhu lwa wanhu, avo kamfungulila Balaba mkifungo. Abaho kalagiza Yesu yatoigwe mbalati na yawambigwe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wakalizi wamgala Yesu muuluwa lwa ng'anda ya mkulu wa isi, waiting'hana na wayao wose. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wamvaza kiwalo cha Undewa, waluka ngata ya miba, waika mdipala jake. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wamulamusa, “Mwinyi, Mndewa wa Wayahudi!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wamtowa mbalati mdipala wamtemela mate, wamfugamila na kumwinamila. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Viwamambukize kumzeha, wamvula ikiwalo cha Undewa wamvaza viwalo vake. Abaho wamulava kunze wamuwambe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Viwakalile mnzila wamting'hana munhu imoja twaga jake Simoni, mwenekae wa Kilene, tatao Alekizanda na Lufo. Kipindi acho kakala kolawa kumgunda, wakalizi wamnanahiza yaupape msalaba wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wamgala Yesu mbaka hanhu hokemigwa Goligota, fambulo jake, “Hanhu ha Fumvu da Pala.” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wamgwaa Yesu divai ihanganyigwe na kinhu kili usungu, lakini Yesu kalema kung'wa. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Abaho wamuwamba Yesu mumsalaba, waigolela viwalo vake, kwa kubwanha simbi, ili yajuwike simbi yomgwila nani avo yasole ikiwalo. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikala saa ndatu imitondo viwamuwambile Yesu mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wandika kilamuso cha kutagusigwa kwake, chandikigwa vino, “Mndewa wa Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vivija wawawamba wabavi wabili hamoja na Yesu, imoja mwambu wake wa mkono wa kudila na iyagwe mwambu wake wa kumoso. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Avo galawilila Maandiko Gang'alile galongile, “Kekigwa hamoja na wanhu watendile gehile.” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wabita nzila watigisa mapala gao wamuliga Yesu, walonga, “Gweye kulonga koibomola Ng'anda ya Mulungu na kuizenga kabili kwa siku ndatu! ");
INSERT INTO kdc2014_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Lelo humuluka mumsalaba uikombole mwenyego!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vivija wakulu wa walava nhosa na wafundiza Malagizo ga Musa wamzeha Yesu walonga, “Kawakombola wayagwe, lakini hadaha kuikombola mwenyego! ");
INSERT INTO kdc2014_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Leka tumulole Kilisito Mkombola, Mndewa wa Izilaeli, lelo yahahumuluka mumsalaba na tweye tomtogola!” Vivija na wanhu waja wabili wawambigwe hamoja na Yesu wamuliga. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Viivikile saa sita imisi, isi yose ikala igubikigwe na ziza totolo, ziza dijo dikala kwa masaa madatu. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Viivikile saa tisa imisi, Yesu kalila kwa sauti ng'hulu, “Eloi, Eloi, lama, sabakitani?” Fambulo jake, “Mulungu wangu, Mulungu wangu, habali kundeka?” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wanhu wayagwe wemile aho viwamuhulike, walonga, “Tegelezeni, komkema Eliya!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munhu imoja kakimbila kavabika dodoki mwiidivai, kadinanika mulubiki, kadika mmulomo wa Yesu, kalonga, “Beta tulole kamba Eliya kokwiza kumuhumulusa mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kalila kwa sauti ng'hulu, abaho kafa. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Panziya da Ng'anda ya Mulungu digola gati da Ng'anda ya Mulungu na hanhu hong'ala ng'hani, didegeka mhande mbili, kulawa uchanha mbaka hasi. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu wa wakalizi yemile haulongozi ha msalaba kamona Yesu viyafile, kalonga, “Kweli munhu ino kakala Mwana wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baho kukala na watwanzi wayagwe wakalile wolola kwa kutali. Mna iwao kakala Malia Magidalena, Malia mamao Yakobo mdodo na Yusufu na Salome. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Watwanzi awo wamkweleleza Yesu viyakalile Galilaya na kumsang'hanila. Watwanzi wayagwe wezile nayo Yelusalemu vivija wakala aho. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Viivikile ichungulo ing'hali hainavika siku ya Kubwihila. Wayahudi wakala woitanda kwa siku ayo ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu mwenekae wa Alimataya, imoja wa wakulu wa Mkitala cha Wayahudi yategelezigwe ng'hani kavika. Munhu ino kakala kobetela kwiza kwa Undewa wa Mulungu. Avo kamgendela Pilato bila kudumba, kampula yamgwee lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato kakanganya kuhulika Yesu kafa. Kamkema mkulu wa wakalizi kamuuza kamba Yesu kakala yafile mwaka. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato viyalongeligwe avo na mkulu wa wakalizi kamba Yesu kafa, kamulongela Yusufu yalusole lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu kagula sitili, kaluhumulusa lukuli lwa Yesu, kaluzingiliza sitili kalwika mdipanga disongoligwe mdibwe. Abaho kabimbilisa dibwe kulu kadigubika mmulomo wa dipanga. ");
INSERT INTO kdc2014_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia Magidalena na Malia mamake Yusufu wahona hanhu halwikigwe lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Viimalile siku ya Kubwihila, Malia Magidalena, Malia mamake Yakobo na Salome wagula mavuta gonung'hila goya wachola kulubakaza lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Imitootondo ng'hani mna isiku ya jumapili, zuwa vidisongile kulawa wachola kudipanga. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Viwakalile mnzila wailongela, “Nani yonda yatubimbilisile idibwe hamgwazo wa umulomo wa dipanga?” ");
INSERT INTO kdc2014_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lakini viwalolile wona dibwe dija dibimbilisigwa mwaka hamgwazo. Dikala dibwe kulu ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Avo wengila mdipanga, wamona mbwanga imoja yavalile kiwalo kizelu, kakala mkono wa kudila, wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kawalongela, “Sekemudumbe nojuwa momzahila Yesu wa Nazaleti yawambigwe mumsalaba. Kahaduhu hano, kazilibuka! Loleni hanhu hawamwikile. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Avo choleni mkawalongele wanahina zake na Petulo, ‘Yesu kowalongolela Galilaya, kuko momona kamba viyawalongele.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Avo walawa mdipanga, kuno wogwaya na kudumba, wakimbila. Hawamulongele munhu yoyose mbuli ino kwavija wakala wodumba. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu viyazilibuke mwiisiku ya Jumapili imitootondo, tanhu kamulawilila Malia Magidalena, ija yamulavile vinyamkela saba. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nayo kachola kuwalongela waja wakalile na Yesu, wakala wang'hali woiyalala na kulila. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Viwamuhulike Malia Magidalena kolonga kamba Yesu mgima na kamona, hawamtogolele bule. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Abaho Yesu kawalawilila wanahina zake wabili mna ikihanga kiyagwe, wanahina awo wakala wochola kumgunda. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nao wabweleganya na kuwalongela wayao, lakini hawawatogolele bule. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kukimambukizo Yesu kawalawilila wanahina zake longo na imoja viwakalile woja. Kawakomhokela kwavija wakala waduhu kutamanila na wakala wadala kuwatogolela waja wamonile viyazilibuke. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kawalongela, “Choleni mwiisi yose mukawapetele wanhu wose Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Munhu yoyose yotogola na kubatizigwa, kokomboligwa, lakini munhu yoyose yolema kutogola kotagusigwa. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wanhu wose wotogola wogweleligwa udahi wa kutenda unzonza, kwa twaga jangu wolava vinyamkela, wolonga ulonzi wa sambi, ");
INSERT INTO kdc2014_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","wahagoga mizoka hebu wahang'wa sumu hondawatendigwe kinhu chochose kihile, wowekila wanhu watamu makono gao, nao wohona.” ");
INSERT INTO kdc2014_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mndewa Yesu viyamambukize kulonga na wanahina zake, kagaligwa kuulanga, kakala muukulu mwambu wa mkono wa kudila wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abaho wanahina zake wachola kila hanhu kuwapetela wanhu Mbuli Inogile. Na Mndewa kasang'hana nao na unzonza wautendile ulagusa kamba usenga wao ukala wa ukweli.");
INSERT INTO kdc2014_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulu Teofili, Wanhu wengi wawamba ng'hani kwandika mbuli zija zilawilile kumwetu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wandika mbuli zija zitulongeligwe na wanhu waja wazonile kwa meso gao kusongela kuna ichanduso na wapetile uusenga. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Avo go mkulu, kwavija nizizahila vinogile mbuli zino kulawa kuna ichanduso, vinikona niye yokuwa vinoga kukwandikila goya mbuli zija zilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Notenda vino muladi ujuwe ukweli wose wa mbuli ziufundizigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kipindi acho Helode viyakalile mndewa wa Yudea, kukala na mulava nhosa, twaga jake Zakalia, wa kibumbila cha Abiya. Mwehe wake kakala Elizabeti, nayo vivija kalawa mulukolo lwa mulava nhosa Haluni. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose wabili wakala wotenda ganogile mgameso ga Mulungu, na kugagoga Malagizo gose ga Mndewa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wakala waduhu wana kwavija Elizabeti kakala mgumba, na wose wabili wakala wavele. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Siku dimoja Zakalia kakala Mng'anda ya Mulungu yosang'hana isang'hano yake ya kulava nhosa, kamba viyatendaga mna izamu yake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakalia kasaguligwa kwa kubwanha simbi, kamba viwatendaga walava nhosa, kwingila Mng'anda ya Mndewa yasome ubani. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kipindi cha kusoma ubani vikivikile, wanhu wengi wakala kunze wompula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Msenga wa kuulanga wa Mndewa kamulawilila Zakalia, kema mwambu wa mkono wa kudila wa upango wa kusomela ubani. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia viyamone, kasinhuka na kagwaya kwa bwembwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini msenga wa kuulanga kamulongela, “Sekeudumbe, Zakalia! Mulungu kahulika kupula kwako. Mwehe wako Elizabeti kokulelela mwana wa kimbigalo, twaga jake komkema Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kodeng'helela ng'hani na wanhu wengi wodeng'helela kwa kuvumbuka kwake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kokuwa munhu mkulu mgameso ga Mndewa. Honda yang'we ugimbi hebu divai. Kokuwa na Loho Yang'alile kusongela mna iinda ya mamake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kowatenda wanhu wengi wa Izilaeli wailumbe na Mndewa Mulungu wao. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nayo komulongolela Mndewa, kokuwa na nguvu kamba mtula ndagu wa Mulungu Eliya. Kowatenda tata na wana wainogele, kowagalusa wanhu waja hawamtegeleza Mulungu wagese ganogile kamba wanhu wanogile, avo yamtandile Mndewa wanhu zake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia kamuuza msenga ija wa kuulanga, “Vino nojuwaze mbuli ino kamba ya ukweli? Niye na mwehe wangu twa wavele.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Msenga ija kamwidika, “Niye na Gabilieli. Nokwima haulongozi ha Mulungu, heyo ayo yanhumile nonge na gweye kukupetela mbuli ino inogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lakini kwavija hutogole mbuli zangu zonda zilawilile mna ikipindi chake, sambi hudaha kulonga mbaka siku vonda ilawilile mbuli ino.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kipindi acho wanhu wakalile wombeta Zakalia, wakanganya habali kokawa kulawa Mng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Viyalawile kunze hadahile kulonga nao. Wajuwa hana kinhu cha unzonza kiyaonile Mng'anda ya Mulungu, kwavija kawagwaa kilaguso kwa kwinula makono gake, na kakala halonga. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Viyamambukize sang'hano yake Mng'anda ya Mulungu, kabwela ukae. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hamwande kidogo imwehe Elizabeti kagoga inda. Hasegele ukayake kwa miezi mitano. Kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Hakimambukizo Mndewa kanisegezela kinyala mgameso ga wanhu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeti viyakalile na inda ya miezi sita, Mulungu kamtuma msenga wa kuulanga, twaga jake Gabilieli, yachole kudibuga da Nazaleti, mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kakala na usenga wa mhambe imoja yafungiligwe zengele na mbigalo imoja twaga jake Yusufu, yalawilile mulukolo lwa Mndewa Daudi. Mhambe ayo twaga jake Malia. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Msenga ija kamcholela Malia, kamulongela, “Zihoze! Mndewa kahamoja na gweye. Nayo kakunogela ng'hani!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia viyauhulike usenga awo wa msenga wa kuulanga, kakala na mfundo ng'hani muumoyo wake, kakanganya usenga awo wofambula choni. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Msenga ija kamulongela, “Malia, sekeudumbe, gweye kupata ng'hekewa ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kogoga inda na kolela mwana wa kimbigalo, nayo komkema Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kokuwa munhu mkulu, kokemigwa Mwana wa Mulungu yeli Uchanha Ng'hani. Mndewa Mulungu komgwaa kigoda cha undewa, kamba viyakalile Daudi muhenga wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kokuwa mtawala wa lukolo lwa Yakobo siku zose, na undewa wake wokuwa wa mazuwa gose!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia kamuuza msenga ija, “Niye na mhambe. Lelo mbuli ayo yokuwaze?” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Msenga ija kamwidika, “Loho Yang'alile kokwizila, na nguvu za Mulungu zokugubika. Avo Mwana yonda yavumbuke kokuwa Yang'alile na kokemigwa Mwana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kumbuka ndugu yako Elizabeti. Wanhu wakala wolonga kakala mgumba, lakini sambi kana inda ya miezi sita, hamoja na uvele uyalinao. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwavija kuduhu kinhu kimulemela Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia kalonga, “Niye na msang'hanaji wa Mndewa, nailawilile kumwangu kamba viulongile.” Abaho msenga ija kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kumwande kidogo Malia kafunga mwanza, kalopola kuchola kuna idibuga dili mvigongo va isi ya Yudea. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kengila mng'anda ya Zakalia, kamulamusa Elizabeti. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti viyahulike Malia komulamusa, king'hele kili mna iinda yake kizumha. Nayo Elizabeti kamemezigwa Loho Yang'alile, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kalonga kwa sauti ng'hulu, “Gweye kunogeligwa kubanza watwanzi wose, na imwana yonda umulele konogeligwa! ");
INSERT INTO kdc2014_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Habali mbuli ino ng'hulu inilawilile niye, mbaka mama wa Mndewa wangu keza kunhembelela? ");
INSERT INTO kdc2014_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vimhulike kondamusa, mwana king'hele yeli mna iinda yangu kazumha kwa kudeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kumweda gweye utogola usenga wa Mndewa, kwavija wolawilila kumwako!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia kalonga, “Moyo wangu womgwaa nhogolwa Mndewa, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Loho yangu yomdeng'helela kwavija Mulungu Mkombola wangu, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kang'humbuka, niye msang'hanaji wake muhole! Kulawa sambi wanhu wose wong'hema munhu yamwedile, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwavija Mulungu Mkulu kanhendela vinhu vikulu. Twaga jake ding'ala. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kulawa lukolo na lukolo, kowonela bazi wanhu wose womtegeleza. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Katenda mbuli ng'hulu kwa mkono wake. Kawapwililisa wanhu weli na magoda mmizoyo yao. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawahumulusa wandewa mna ivigoda vao va undewa, na kawenula wahole. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Weli na nzala kawatenda wegute kwa vinhu vinogile na kawawinga matajili makono gaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kasang'hana kija kiyalongile kwa wahenga zetu, keza kumtaza msang'hanaji wake Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kakumbuka kumonela bazi Abulahamu, na lukolo lwake lose siku zose!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia kakala kwa Elizabeti miezi midatu, abaho kabwela ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kipindi cha kuifungula Elizabeti vikivikile, kaifungula mwana wa kimbigalo. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wanhu weli behi nayo na ndugu zake viwahulike mbuli ng'hulu ziyatendeligwe na Mndewa, wadeng'helela hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Imwana viyavikize siku nane, wamwingiza kumbi. Walonda kumkema Zakalia, twaga da tatake, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","lakini mamake kalonga, “Bule, twaga jake Yohana.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wamulongela, “Kuduhu munhu mulukolo lwenu yeli na twaga dijo!” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abaho wamgwaa kilaguso tatake, wamuuza twaga gani diyalondile mwanage yakemigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia kawapula kibao cha kwandikila, kandika vino, “Twaga jake Yohana.” Wanhu wose wakanganya! ");
INSERT INTO kdc2014_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bahaja Zakalia kadaha kulonga, kamgwaa nhogolwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wanhu weli behi nayo wadumba ng'hani. Mbuli izo za unzonza zibwililika kila hanhu kuvigongo va isi ya Yudea. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kila munhu yahulike mbuli ayo kaigelegeza, kauza, “Vino mwana ino kokuwa nani?” Kwavija udahi wa Mndewa ukala hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia tatake Yohana kamemezigwa Loho Yang'alile, kalonga usenga wa Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yatogoligwe Mndewa, Mulungu wa Izilaeli! Keza kuwataza wanhu zake na kuwagombola. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katugwaa Mkombola yeli na udahi, mzukulu wa Daudi msang'hanaji wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kamba viyalongile toka mwaka kubitila watula ndagu zake wang'alile, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kamba kotukombola na wanhu wang'hobo, na kulawa mmakono ga wanhu watwihile. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kalonga kowonela bazi wahenga zetu, na kokumbuka lagano jake ding'alile. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kaiduila kwa muhenga wetu Abulahamu, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kutukombola mmakono ga wanhu watwihile, na kututenda tumsang'hanile bila kudumba, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tuwe wanhu wang'alile na wanhu wotenda goyolonda Mulungu, siku zose za ugima wetu. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Gweye mwanangu, kokemigwa mtula ndagu wa Mulungu yeli Uchanha Ng'hani. Komulongolela Mndewa, kuitanda nzila yake. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kowalongela wanhu zake kamba wokomboligwa, na nzambi zao zogeligwa kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mulungu wetu kana bazi na moyo unogile. Kotumwemwesela mulenge wa ukombozi kulawa kuulanga, ");
INSERT INTO kdc2014_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na wowamwemwesela wanhu wose wokala mdiziza da ifa, na kulongoza magulu getu mnzila ya tindiwalo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Imwana ija kagendelela kukula lukuli na kawa na nguvu mwiiloho. Kakala kuluwala mbaka siku dija viyalawilile mgameso ga wanhu wa Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kipindi acho, Agusito, Mndewa wa Lumi, kalagiza wanhu wose mwiisi ya Lumi wapetigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Awo ukala mwanza wa ichanduso wa wanhu kupetigwa kipindi Kilenio viyakalile mkulu wa isi ya Siliya. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Avo kila munhu kachola kudibuga diyavumbuke kwandikigwa twaga jake. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu kasegela kudibuga da Nazaleti mwiisi ya Galilaya, kachola kudibuga da Beselehemu mwiisi ya Yudea, hanhu hayavumbuke mndewa Daudi. Yusufu kachola kuko kwavija kolawa mulukolo lwa Daudi. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kachola na Malia kupetigwa, yakalile yamfungile zengele. Nayo Malia kakala na inda. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Viwakalile kudibuga da Beselehemu, kipindi cha Malia kuifungula kivika. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kaifungula mwanage wa chaudele wa kimbigalo, kamvaza vikumbi. Abaho kamtambaliza hanhu hoodimiligwa ng'ombe, kwavija hawapatile gati mzing'anda za wageni. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kilo acho kukala na wasusilaji wa ng'hondolo mna imigunda ilibehi na Beselehemu, wakala wokaliza fugo zao. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Msenga wa kuulanga kawalawilila, ukulu wa Mndewa uwamwemwesela, nao wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lakini msenga ija kawalongela, “Sekemudumbe! Niye niwagalila mbuli inogile, mbuli yonda itende wanhu wose wadeng'helele. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lelo kudibuga da Daudi, Mkombola wenu kavumbuka, ayo Kilisito Mndewa! ");
INSERT INTO kdc2014_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kino acho kilaguso kumwenu, momvika mwana king'hele kavazigwa vikumbi, katambalizigwa hanhu hoodimiligwa ng'ombe.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bahaja bumbila kulu da wasenga wa kuulanga dilawilila, diilumba na msenga ija iyagwe, wamtogola Mulungu walonga, ");
INSERT INTO kdc2014_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukulu kwa Mulungu yeli Uchanha Ng'hani kuulanga, na tindiwalo diwe kwa wanhu wa mwiisi yawanogele!” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wasenga wa kuulanga viwabwelile kuulanga, wasusilaji wailongela, “Tucholeni Beselehemu tukailole mbuli ino ilawilile, yailongile Mndewa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Avo walopola kuchola, wawavika Malia na Yusufu, na wamona imwana king'hele katambalizigwa hanhu hoodimiligwa ng'ombe. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wasusilaji viwamone imwana, wawalongela kija kiyawalongele msenga wa kuulanga mbuli ya imwana. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wanhu wose wahulike kija kiwalongile wasusilaji, wakanganya. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Malia kazika mbuli izo muumoyo na kazigelegeza ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wasusilaji wabwela kuno wokwimba nyila za kumtogola Mulungu kwa mbuli zose ziwahulike na kuzona. Zose zilawilila kamba msenga wa kuulanga viyawalongele. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mna isiku ya nane, siku ya kwingizigwa imwana kumbi, wamgwaa twaga da Yesu. Twaga ijo kagweleligwa na msenga wa kuulanga mamake hanagoga inda. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Vikivikile kipindi cha kuisunha kamba Musa viyalagize mna Gamalagizo gake, Yusufu na Malia wamsola imwana na wachola nayo Yelusalemu muladi wamwike mgameso ga Mndewa, ");
INSERT INTO kdc2014_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kamba viyandikigwe mna Gamalagizo ga Mndewa, “Kila mwana wa chaudele wa kimbigalo yonda yavumbuke yagaligwe mgameso ga Mndewa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vivija wachola kulava nhosa kamba malagizo ga Mndewa vigalondile, “Huwa wabili hebu makinda mabili ga njiwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kipindi acho kukala na munhu yokala Yelusalemu, twaga jake Simeoni. Munhu ayo kakala yotenda goyolonda Mulungu na komdumba Mulungu. Vivija kakala yobetela ukombozi wa Izilaeli, na Loho Yang'alile kakala hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nayo Loho Yang'alile kamulongela honda yafe mbaka yamone Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Loho kamulongoza Simeoni yachole kuna Ing'anda ya Mulungu. Abaho Yusufu na Malia wamgala imwana Yesu kuna Ing'anda ya Mulungu wamtendele kamba Malagizo ga Musa vigalondile. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni kamsola imwana mmakono gake, kamtogola Mulungu, kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mndewa, sambi kusang'hana kamba viulongile, muleke msang'hanaji wako yachole moyo uholile. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa meso gangu niuwona ukombozi wako, ");
INSERT INTO kdc2014_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ukombozi uutandile mgameso ga wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mulenge uwatenda wanhu haweli Wayahudi wajuwe goulonda, na kugala ukulu kwa wanhu zako wa Izilaeli.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tatake na mamake imwana wakanganya kija kiyalongile Simeoni mbuli ya imwana. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeoni kawatambikila, kamulongela Malia, “Mwana ino kasaguligwa na Mulungu mbuli ya kupotela na kukomboligwa wanhu wengi wa Izilaeli. Nayo kokuwa kilaguso kulawa kwa Mulungu, na wanhu wengi womulema. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Abaho magesa ga wanhu wengi gogubuligwa. Na gweye mwenyego, usungu uli kamba panga dikutwa dousoma moyo wako.” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kukala na mgane imoja mtula ndagu wa Mulungu, yakalile mvele ng'hani, twaga jake Ana, biti Fanueli wa lukolo lwa Asheli. Mtwanzi ayo kakala na mkasano wake kwa miyaka saba toka yasoligwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nayo kakala mgane mbaka viyavikize miyaka malongo manane na nne. Kipindi chose acho kakala Mng'anda ya Mulungu imisi na ikilo, komgwaa ukulu Mulungu, kopula na kofunga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saa iija kavika, kamgwaa nhogolwa Mulungu na kalonga mbuli za imwana kwa wanhu wose wakalile wombeta Mulungu yaikombole Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufu na Malia viwamambukize kugatenda gaja gose galondeke na Malagizo ga Mndewa, wabwela kudibuga jao da Nazaleti mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Imwana kakula na kawa mbala goya, kakala yamemile nzewele, na ng'hekewa ya Mulungu ikala kumwake. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila mwaka tatake na mamake Yesu wacholaga Yelusalemu kuna inyimwili nyimwili ya Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu viyavikize miyaka longo na mibili, wachola kuna inyimwili nyimwili ya Pasaka kamba viwatendaga. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nyimwili nyimwili viimalile, wabwela ukae, lakini mbwanga Yesu kasigala Yelusalemu. Tatake na mamake hawajuwile bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wao viwagize kakala mna ikibumbila cha wanhu, avo watembela siku ngima. Abaho wasonga kumzahila Yesu mwa ndugu zao na mbwiga zao. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hawamone bule, avo wabweleganya Yelusalemu kumzahila. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Siku ya kadatu wamvika kuna Ing'anda ya Mulungu, kakala hamoja na wafundiza wa Kiyahudi, kowategeleza na kuwauza. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wanhu wose wamuhulike wakanganya nzewele zake na vija viyawedike. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tatake na mamake viwamone wasinhuka ng'hani. Mamake kamuuza, “Mwanangu, habali ututendile vino? Niye na tatako tukala moyo yungwayungwa tokuzahila gweye!” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu kawedika, “Habali munizahila? Vino hamujuwile bule niye nilondeka ng'hale mng'anda ya Tatangu?” ");
INSERT INTO kdc2014_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini wao hawajuwile fambulo da ulonzi awo. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Abaho Yesu kachola nao Nazaleti, ako kakala kowategeleza. Mamake kazika muumoyo mbuli zino zose. ");
INSERT INTO kdc2014_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu kakula lukuli na ubala, kanogeligwa na Mulungu hamoja na wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa longo na tano muundewa wa mndewa wa Lumi yakemigwe Tibelio, Pontio Pilato kakala mkulu wa isi ya Yudea, na Helode kakala mkulu wa isi ya Galilaya, na Filipo mdodo wake kakala mkulu wa Itulea na isi ya Tulakoniti, na Lusania kakala mkulu wa isi ya Abilene, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa wakala wakulu wa walava nhosa. Kipindi acho mbuli ya Mulungu imwizila Yohana mwanage Zakalia ako kuluwala ");
INSERT INTO kdc2014_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana kachola mziisi zose zili mmabehi na lwanda lwa Yolidani, kawapetela wanhu, “Lekeni nzambi na mbatizigwe na Mulungu kozigela kumgongo nzambi zenu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kamba viyandikigwe mna ikitabu cha mtula ndagu wa Mulungu Isaya, “Munhu kokema kuluwala, ‘Itandeni nzila ya Mndewa, goloseni nzila yonda yabite! ");
INSERT INTO kdc2014_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila konde dimemezigwe, kila kisugulu na kigongo visegezigwe, nzila hazigoloke zigolosigwe, na nzila zihile zotendigwa goya. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wanhu wose wokona Mulungu kowakombola wanhu!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lunhu lwa wanhu lumcholela Yohana yawabatize. Yohana kawalongela, “Mweye mizoka! Nani yawalongele modaha kuikimbila nhaguso yonda igaligwe na Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Musang'hane gaja gonda galaguse muzileka nzambi zenu. Sekemuilongele, ‘Abulahamu ayo muhenga wetu.’ Nowalongela, Mulungu kodaha kugasola mabwe gano na kugatenda lukolo lwa Abulahamu! ");
INSERT INTO kdc2014_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Shoka ikigwa goya kukanha mibiki mna gamasina. Kila mbiki uleka kulela matunda ganogile wokanhigwa na kwasigwa muumoto.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lunhu lwa wanhu lumuuza Yohana, “Avo tutende choni?” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohana kawedika, “Munhu yoyose yeli na viwalo vibili yamgwee kimoja miyage yeliduhu, na ija yeli na lujo yatende vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wabokela kodi nao weza kubatizigwa. Wamuuza Yohana, “Mfundiza, tweye tutende choni?” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nayo kawalongela, “Sekemubokele kodi kubanza vija vimulagizigwe.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wakalizi nao wamuuza, “Na tweye tutende choni?” Nayo kawalongela, “Sekemumboke munhu yoyose sente yake hebu sekemumtaguse munhu yoyose kwa uvizi. Mutosheke na kija kimubokela.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wanhu wakala wobetela kwiza kwa Mkombola, avo wasonga kuiuza mmizoyo yao kamba Yohana kodaha kuwa ayo Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana kawalongela wose, “Niye nowabatiza mweye kwa mazi, lakini kokwiza ija yeli munhu mkulu ng'hani kubanza niye. Niye sifaya hata kudohola nzabi za vilatu vake. Ayo kowabatiza kwa Loho Yang'alile na moto. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ayo kana lungo mmakono gake lwa kubetela uhule wake. Kowika uhemba kudikanho, lakini koisoma imikumvi muumoto haufaga.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa mbuli nyingi Yohana kawapetela wanhu Mbuli Inogile na kawalonda waleke nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lakini Yohana kamkomhokela mndewa Helode, mkulu wa isi ya Galilaya kwavija kamsola Helodiya, mwehe wa mdodo wake, na katenda nzambi nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Abaho Helode katenda dihile ng'hani kwa kumgodeka Yohana mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wanhu wose viwakalile wobatizigwa, Yesu nayo kabatizigwa. Viyakalile kompula Mulungu, ulanga ugubuka, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Loho Yang'alile kamuhulumukila mna ulukuli luigalile na huwa. Sauti ihulikigwa kulawa kuulanga, “Gweye kwa Mwanangu nikunogele. Ninogelwa na gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu viyasongile sang'hano yake, kakala na miyaka malongo madatu. Avo wanhu wagesa kakala mwanage Yusufu, mwanage Heli, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwanage Matati, mwanage Lawi, mwanage Meliki, mwanage Yani, mwanage Yusufu, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwanage Matatia, mwanage Amosi, mwanage Nahumu, mwanage Esili, mwanage Nagai, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwanage Maati, mwanage Matatia, mwanage Semeni, mwanage Yusufu, mwanage Yuda, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwanage Yoana, mwanage Lesa, mwanage Zelubabeli, mwanage Shealitieli, mwanage Neli, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwanage Meliki, mwanage Adi, mwanage Kosamu, mwanage Elimadamu, mwanage Eli, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwanage Yoshua, mwanage Eliezeli, mwanage Yolimu, mwanage Matati, mwanage Lawi, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwanage Simeoni, mwanage Yuda, mwanage Yusufu, mwanage Yonamu, mwanage Eliakimu, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwanage Melea, mwanage Mena, mwanage Matata, mwanage Natani, mwanage Daudi, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwanage Yese, mwanage Obedi, mwanage Boazi, mwanage Salimoni, mwanage Nashoni, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwanage Aminadabu, mwanage Adimini, mwanage Alini, mwanage Heziloni, mwanage Pelesi, mwanage Yuda, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwanage Yakobo, mwanage Isaka, mwanage Abulahamu, mwanage Tela, mwanage Naholi, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwanage Selugi, mwanage Lagau, mwanage Pelegi, mwanage Ebeli, mwanage Sela, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwanage Kenani, mwanage Alifakisadi, mwanage Shemu, mwanage Nuhu, mwanage Lameki, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwanage Metusela, mwanage Henoko, mwanage Yaledi, mwanage Mahalaleli, mwanage Kenani, ");
INSERT INTO kdc2014_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwanage Enoshi, mwanage Seti, mwanage Adamu, mwanage Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kabwela kulawa Yolidani, kamema Loho Yang'alile na kalongozigwa na Loho Yang'alile mbaka kuluwala. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ako kagezigwa na Mwenembago kwa ikipindi cha siku malongo mane. Mna ikipindi chose acho hadile kinhu chochose, avo vizimalile siku azo, nzala imuluma. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Abaho Mwenembago kamulongela Yesu, “Kamba gweye kwa Mwana wa Mulungu, dilongele dibwe dino digaluke gate.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lakini Yesu kamwidika, “Maandiko Gang'alile golonga, ‘Munhu hawa mgima kwa kuja kwiiyeka!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Abaho Mwenembago kamsola Yesu mbaka uchanha ng'hani, kamulagusila undewa wose wa mwiisi kwa mwanza umoja. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mwenembago kamulongela Yesu, “Nokugwaa ukulu na utajili wose uno, kwavija vose va mmakono gangu, na niye nodaha kumgwaa munhu yoyose inimulonda. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nokugwaa vinhu vose vino, kamba wahanitambikila.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamwidika, “Maandiko Gang'alile golonga, ‘Mtambikile Mndewa Mulungu wako, na umsang'hanile heyo yaiyeka!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Abaho Mwenembago kamsola Yesu mbaka Yelusalemu, kamwika uchanha ng'hani kuna ikiswili cha ing'anda ya Mulungu, abaho kamulongela Yesu, “Kamba gweye kwa Mwana wa Mulungu, ilagaze mwenyego hasi kulawa hano. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwavija Maandiko Gang'alile golonga, ‘Mulungu kowalagiza wasenga zake wa kuulanga wakukalize!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na vivija golonga, ‘Wokupapa mmakono gao, sekeuilumize magulu gako mgamabwe!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lakini Yesu kamwidika, “Maandiko Gang'alile golonga, ‘Sekeumgeze Mndewa Mulungu wako!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mwenembago viyamambukize kumgeza Yesu kwa kila nzila, kamuleka mbaka kipindi kiyagwe kinogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Abaho Yesu kabwela isi ya Galilaya, nguvu ya Loho Yang'alile ikala hamoja nayo. Mbuli zake zibwililika mziisi zose za mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kakala yofundiza mna zing'anda za kumpula Mulungu na kila munhu kamgwaa nhogolwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Abaho Yesu kachola Nazaleti, hanhu kuyakulile. Mna isiku ya Kubwihila, kengila mng'anda ya kumpula Mulungu kamba viyatendaga. Kema yasome Maandiko Gang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kagweleligwa kitabu cha mtula ndagu wa Mulungu Isaya, kakifungula na kona hanhu handikigwe, ");
INSERT INTO kdc2014_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loho wa Mndewa Mulungu kamgati mmwangu, kwavija kanisagula niwagalile wanhu wakiwa Mbuli Inogile. Kanituma niwapetele wagodekigwe kamba wolekesigwa, na waja wasuwameso walole, na kuwakombola waja wadununzigwe, ");
INSERT INTO kdc2014_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kuwalongela kamba saa ivika ya Mndewa kuwakombola wanhu zake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Abaho Yesu kakigubika ikitabu, kakibweza kwa msang'hanaji, abaho kakala hasi. Wanhu wose wakalile mng'anda ya kumpula Mulungu wamulola Yesu bunhuu. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nayo kasonga kuwalongela, “Chandikigwe muno, lelo kilawilila kamba vimuhulike.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wose wamtogola na wakanganya mbuli zake zinogile ziyalongile. Walonga, “Vino ino siyo mwanage Yusufu?.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu kawalongela, “Nojuwa monongela ulonzi uno, ‘Mganga, ihonye mwenyego! Gose gatuhulike kugatenda ako Kapelinaumu, vivija gatende na hano ukayako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu kagendelela kulonga, “Nowalongela ukweli, kuduhu mtula ndagu yotegelezigwa ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nhegelezeni, ona kukala na wagane wengi mwiisi ya Izilaeli mna ikipindi cha Eliya. Kipindi acho, mvula haitowile miyaka midatu na nusu, kukala na lufilili lwa nzala mwiisi yose. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lakini Eliya hatumigwe bule kwa munhu yoyose iyagwe mwiisi ya Izilaeli, ila kwa mgane imoja yakalile Selepata, mwiisi ya Sidoni. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Vivija mna ikipindi cha mtula ndagu wa Mulungu Elisha, kukala na wanhu wengi wakalile wolumwa utamu wa dikulu mwiisi ya Izilaeli. Lakini kuduhu munhu yoyose iyagwe yahonyigwe, ila Naamani yaiyeka, munhu wa isi ya Siliya.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wanhu wakalile mng'anda ya kumpula Mulungu wagevuzika ng'hani viwahulike avo. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wenuka, wamulava kunze kudibuga jao dizengigwe uchanha kukigongo, wamgala mbaka mwiingema ya kigongo acho, walonda kumpigisa hasi. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini Yesu kabita hagati ya lunhu luja, kalawanya. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Abaho Yesu kachola kudibuga da Kapelinaumu mwiisi ya Galilaya. Mwiisiku ya Kubwihila, kakala yofundiza wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mafundizo gake gawakanganya wanhu wose, kwavija kakala kolonga kwa udahi. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mng'anda ya kumpula Mulungu kukala na munhu yeli na kinyamkela. Kalila kwa sauti ng'hulu, ");
INSERT INTO kdc2014_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oii! Kolonda kututenda choni, Yesu wa Nazaleti? Vino kwiza kutukoma? Nokujuwa, Gweye kwa ija Yang'alile wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kamkomhokela ikinyamkela ija, “Nyamala! Mulawe munhu ino!” Kinyamkela kambwanha hasi munhu ija mgameso gao, abaho kamulawa bila kumulumiza. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wanhu wose wakanganya ng'hani na wailongela, “Mbuli gani zino? Munhu ino kana nguvu na udahi wa kuwakomhokela vinyamkela, nao womtegeleza!” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Avo mbuli za Yesu zibwililika kila hanhu mwiisi ija. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kalawa kuna ing'anda ya kumpula Mulungu, kachola ukayake Simoni. Mkwe wa kitwanzi wa Simoni kakala yolumwa homa ng'hali, avo wamulongela Yesu yamuhonye. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu kamcholela, kema behi na lusazi lwa mtwanzi ayo, kaikomhokela homa imulawe. Homa imulawa, bahaja mtwanzi ija kenuka, kasonga kuwasang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zuwa vidihongile, wanhu wose wakalile na watamu wawagala kwa Yesu, nayo keka makono gake uchanha mwa kila munhu na kuwahonya wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vinyamkela wawalawa wanhu wengi na kuguta, “Gweye kwa mwana wa Mulungu!” Yesu kawakomhokela na kawagomesa kulonga, kwavija wamjuwa kamba kakala Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Imitondo yake, Yesu kasegela kudibuga, kachola hanhu kuduhu wanhu. Wanhu wasonga kumzahila, na viwamone, walonda kumgomesa sekeyachole. ");
INSERT INTO kdc2014_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini Yesu kawalongela, “Vivija nolondeka kuwapetela wanhu wa mmabuga gayagwe Mbuli Inogile ya Undewa wa Mulungu, kwavija acho kiyanhumile Mulungu kukisang'hana.” ");
INSERT INTO kdc2014_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Avo kawapetela wanhu mzing'anda za kumpula Mulungu mwiisi yose ya Yudea. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Siku dimoja Yesu kakala yemile mumgwazo wa lamba da Genesaleti. Wanhu wengi wakala woisung'ha sung'ha wategeleza mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu kazona ngalawa mbili zikalile mwiingema ya lamba, zilekigwe na wavuwa somba, wakalile wosunha mizavu yao. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu kengila mwiingalawa imoja ikalile ya Simoni, kamulonda Simoni yaikwese mgamazi. Abaho Yesu kakala mwiingalawa, kafundiza lunhu luja. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Viyamambukize kufundiza, kamulongela Simoni, “Kwesa ingalawa mbaka kuna gamazi mengi, abaho gweye na wayago mupigise mizavu yenu muvuwe somba.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamwidika, “Go mkulu, tusang'hana ng'hani kilo kigima lakini hatupatile kinhu bule. Lakini kamba gweye kolonga avo, nogela mizavu yangu mgamazi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wapigisa mizavu yao, somba wengi wanamata mbaka mizavu yao ilonda kudegeka. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Avo wawakema wayao wakalile mwiingalawa iyagwe weze kuwataza. Wayao weza na wazimemeza ngalawa zose mbili, zose zikala zimemile somba mbaka zilonda kudidimila. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo viyachonile kija kilawilile, kamfugamila Yesu mmagulu, kalonga, “Mndewa, segela haulongozi wangu, niye nimema nzambi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na wayage wakanganya ng'hani mbuli ya somba wengi wawapatile. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Vivija wayage Simoni, Yakobo na Yohana, wanage Zebedayo, nao wakanganya. Yesu kamulongela Simoni, “Sekeudumbe. Kulawa sambi kokuwa mvuwaji wa wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wazilava ngalawa zao kunze mumgwazo, wavileka vinhu vose, wamkweleleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu viyakalile kudibuga dimoja, kukala na munhu imoja yakalile na utamu wa dikulu. Viyamonile Yesu, kaibwanha hasi, kampula, “Go mkulu, wahalonda, kodaha kunihonya!” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kagolosa mkono wake, kamkwasa. Kalonga, “Nolonda, hona!” Bahaja utamu wa dikulu umulawa munhu ija. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu kamulagiza, “Sekeumulongele munhu yoyose, lakini goga inzila mbaka kwa mulava nhosa ukailaguse, abaho kalave nhosa kamba viyalagize Musa ili kutenda kila munhu yatogole kamba kuhonyigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini mbuli za Yesu zibwililika kila hanhu. Wanhu wengi weza kumtegeleza na kuhonyigwa mitamu yao. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini Yesu kacholaga hanhu kuduhu wanhu na kampula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Siku dimoja Yesu viyakalile kofundiza, Mafalisayo wayagwe na wafundiza Malagizo ga Musa wakala aho. Wakala walawile kila buga mwiisi ya Galilaya na Yudea na kulawa Yelusalemu. Nguvu ya Mndewa ikala hamoja na Yesu kuwahonya watamu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wanhu wayagwe weza kuno wampapa mulusazi munhu yaholole. Wageza kumwingiza mng'anda wamwike haulongozi wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lakini hawapatile nzila ya kumwingiza mng'anda, kwavija kukala na lunhu lwa wanhu. Avo wamsola mtamu wao, wamgala uchanha kukiswili, watobola zonzo. Abaho wamuhumulusa na lusazi lwake mbaka hagati ya lunhu lwa wanhu, wamwika haulongozi wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu viyone kutamanila kwao, kamulongela munhu ija, “Mbwigangu, nzambi zako zigeligwa kumgongo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wafundiza Malagizo ga Musa na Mafalisayo wasonga kuiuza, “Munhu gani ino kolonga mbuli za kumuliga Mulungu? Mulungu yaiyeka ayo yodaha kuzigela kumgongo nzambi za wanhu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kajuwa viwagesile, avo kawalongela, “Habali mogesa avo? ");
INSERT INTO kdc2014_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Choni kibuhile, kulonga, ‘Nzambi zako zigeligwa kumgongo,’ hebu kulonga, ‘Ima utembele’? ");
INSERT INTO kdc2014_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lakini nolonda mujuwe kamba Mwana wa Munhu kana udahi mwiisi wa kuzigela kumgongo nzambi za wanhu.” Abaho kamulongela munhu ija yaholole, “Nokulongela, ima, papa lusazi lwako, uchole ukayako!” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bahaja munhu ija kenuka mgameso ga wanhu, kapapa lusazi lwake mumo muyatambalale, kachola ukayake kuno komtogola Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wanhu wose wakanganya ng'hani na kudumba! Wamtogola Mulungu walonga, “Lelo tona unzonza!” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Abaho Yesu kachola na kamona mbokela kodi yakemigwe Lawi kakala mng'anda ya kusolela kodi. Yesu kamulongela, “Nikweleleze.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi kenuka, kaleka kila kinhu, kamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abaho Lawi kamtendela Yesu nyimwili nyimwili ng'hulu ukayake. Vivija kukala na wabokela kodi wengi na wanhu wayagwe wagonekigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo na wafundiza Malagizo ga Musa wayagwe wakalile aho wawauza wanahina wa Yesu, “Habali moja na kung'wa hamoja na wabokela kodi na wanhu wotenda nzambi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kawedika, “Wanhu wagima hawalonda mganga, lakini waja weli watamu womulonda mganga. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sizile kuwakema wanhu wogesa wanoga, lakini niza kuwakema waja wene nzambi waleke.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wanhu wayagwe wamulongela Yesu, “Wanahina wa Yohana Mbatizaji wofunga kuja miyanza mingi na kumpula Mulungu, na wanahina wa Mafalisayo wotenda vivo, lakini wanahina zako woja na kung'wa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kawedika, “Vino mogesa wanhu wagonekigwe kuna idizengele wodaha kufunga kuja kipindi munhu yosola kahamoja nao? Havidahika bule! ");
INSERT INTO kdc2014_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini kipindi chokwiza, munhu yosola vonda yasegezigwe kumwao, baho wofunga kuja.” ");
INSERT INTO kdc2014_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Abaho Yesu kawalongela lusimo luno, “Kuduhu munhu yokanha kilaka mkiwalo cha sambi na kukika mkiwalo cha umwaka. Yahatenda avo, kokinanga kija kiwalo cha sambi, na kilaka acho honda kiigale na kiwalo cha umwaka. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vivija kuduhu munhu yogida divai ya sambi mna mifuko ya ng'hwembe ya umwaka. Kwavija yahatenda avo, divai ya sambi yoitula mifuko ayo ya umwaka, divai yokwitika, na mifuko yobanangika. ");
INSERT INTO kdc2014_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Divai ya sambi yogidigwa mmifuko ya ng'hwembe ya sambi! ");
INSERT INTO kdc2014_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuduhu munhu yolonda divai ya sambi yahamambukiza kung'wa ya umwaka. Kwavija kolonga, ‘Ya umwaka inoga ng'hani.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mna isiku imoja ya Kubwihila, Yesu kakala yobita mmigunda ya uhemba. Wanahina zake wasonga kubena mikungwi ya uhemba, wagafigisa mmakono gao na kuja mhule zake. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo wayagwe wawauza, “Habali motenda kinhu kigomesigwe mna isiku ya Kubwihila?” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kawedika, “Vino mweye hamusomile kija kiyatendile Daudi na wayage viwakalile na nzala? ");
INSERT INTO kdc2014_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi kengila Mng'anda ya Mulungu, kasola magate galavigwe kwa Mulungu, kagaja na vivija kawagwaa wayage. Malagizo gawagomesa wanhu wayagwe kuja magate gago ila kwa walava nhosa waiyeka.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Abaho Yesu kamambukiza kwa kulonga, “Mwana wa Munhu ayo Mndewa wa siku ya Kubwihila.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mna isiku iyagwe ya Kubwihila, Yesu kengila mng'anda ya kumpula Mulungu na kafundiza. Baho kukala na munhu imoja, mkono wake wa kudila ukala uholole. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wafundiza Malagizo ga Musa na Mafalisayo wayagwe wakala wozahila kilamuso cha kumtagusa Yesu, avo wakala womulola wamone kamba komuhonya munhu mwiisiku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini Yesu kawajuwa viwagesile, kamulongela munhu ija yaholole mkono, “Ima wize hano haulongozi.” Munhu ija kenuka na kwima hagati. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Abaho Yesu kawalongela, “Nowauza, vino Malagizo getu gotulonda tutende choni mwiisiku ya Kubwihila? Kutenda ganogile hebu kutenda gehile? Kuhonya ugima wa munhu hebu kuukoma?” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu kawalola wanhu wose wakalile aho, abaho kamulongela munhu ija, “Golosa mkono wako.” Munhu ija katenda avo, na mkono wake uhona kabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini wanhu wagevuzika ng'hani na wasonga kuilongela wamtende choni Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kipindi kija Yesu kachola kuna ikigongo kumpula Mulungu, kakala ako kilo kigima kompula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Imitondo yake, kawakema wanahina zake, kawasagula longo na wabili mna idibumbila jao, kawagwaa twaga da watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Watumigwa awo wakala Simoni, ayo Yesu kamkema Petulo na Andeleya mdodo wake, Yakobo na Yohana, Filipo na Batulumayo, ");
INSERT INTO kdc2014_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomaso na Yakobo mwanage Alufayo na Simoni yakemigwe Zelote, ");
INSERT INTO kdc2014_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwanage Yakobo na Yuda Isikaliote yamuhinduke Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu viyahumuluke kukigongo hamoja na watumigwa zake, kema hanhu hagoloke hamoja na wanahina zake wengi. Lunhu mkulu lwa wanhu lukala aho kulawa isi yose ya Yudea na buga da Yelusalemu, na kulawa mhwani ya isi za Tilo na Sidoni. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Weza kumtegeleza Yesu na kuhonyigwa mitamu yao. Vivija wanhu waja wakalile wogazigwa na vinyamkela weza na wahonyigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wanhu wose wageza kumkwasa Yesu, kwavija nguvu ya kuhonya ikala ilawa kumwake na kuwahonya wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawalola wanahina zake, kalonga, “Mmweda mweye muli wakiwa, kwavija Undewa wa Mulungu uli wenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mmweda mweye muli na nzala sambi, kwavija mokwiguta! Mmweda mweye mulila sambi, kwavija modeng'helela!” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mmweda mweye kamba wanhu womwihilani, wowalema, wowaliga na kuwalonga vihile kwa mbuli ya Mwana wa Munhu! ");
INSERT INTO kdc2014_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Deng'heleleni na kuvina vonda galawilile, kwavija mwikiligwa nhunza ng'hulu kuulanga. Kwavija vivo wahenga zao viwawatendele watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini mogaya mweye muli matajili sambi, kwavija mmala kupata deng'ho jenu! ");
INSERT INTO kdc2014_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mogaya mweye mwigute sambi, kwavija mokona nzala! Mogaya mweye museka sambi, kwavija moiyalala na kulila!” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mogaya mweye kamba wanhu wose wowagwaa nhogolwa kwavija wahenga zao vivija wawatendela vivo watula ndagu wa uvizi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lakini nowalongela mweye munitegeleza, wanogeleni wamwihileni, muwatendele ganogile waja wowatendela gehile. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Muwatambikile waja wowaduila, na muwapulile kwa Mulungu waja womonelani. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Munhu yonda yakutowe kanza dimoja, muleke yakutowe kanza diyagwe vivija, kamba munhu kokuboka koti jako, muleke yasole na shati jako vivija. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Munhu yahakupula kinhu mgwee, na munhu yokuboka vinhu vako, sekeulonde yakubwezele. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Avo watendeleni wayagwe gaja gose gomulonda mweye kutendeligwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kamba mweye mowanogela wanhu wowanogela mweye waiyeka, vino motenda kilozo gani? Hata wanhu wene nzambi wowanogela waja wowanogela hewo! ");
INSERT INTO kdc2014_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na kamba mowatendela ganogile waja wowatendela ganogile waiyeka, vino motenda kilozo gani? Hata wanhu wene nzambi wotenda vivo! ");
INSERT INTO kdc2014_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na kamba mowakopesha waja waiyeka mutamanila wodaha kuwabwezela, vino motenda kilozo gani? Hata wanhu wene nzambi wowakopesha wayao wotamanila wodaha kuwabwezela kikija kiwawakopeshe! ");
INSERT INTO kdc2014_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lakini mweye wanogeleni waja womwihileni na muwatendele ganogile, muwakopeshe wanhu bila kutamanila kubwelezeligwa. Abaho nhunza yenu yokuwa ng'hulu, na mweye mokuwa wana wa Mulungu yeli Uchanha Ng'hani. Kwavija heyo kanoga kwa waja weliduhu nhogolwa kumwake na wanhu wotenda nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na bazi kamba vija Tata yenu viyeli na bazi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sekemuwataguse wayagwe, Mulungu honda yawataguse mweye. Sekemuwalaumu wayagwe, na Mulungu honda yawalaumu mweye. Mugele kumgongo nzambi za wanhu wayagwe, na Mulungu kogela kumgongo nzambi zenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muwagwee wayagwe, na Mulungu kowagwaa mweye. Na mweye mobokela kibaba kimemile na kusindiligwa mbaka vokwitika mmakono genu, na vose vonda mudahe kuvigoga. Avo, vija vimuwapimila wayagwe, Mulungu nayo kowapimila vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Abaho Yesu kawalongela lusimo luno, “Msuwameso hadaha kumulongoza msuwameso miyage. Yahatenda vivo, wose wabili wolagalila mdikolombo. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kuduhu mwanahina yombanza mfundiza wake. Lakini kila mwanahina yahamambukiza mafunzo gake, koigala na mfundiza wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Habali kolola kibanzi kili mdisiso da ndugu yako lakini hulola biki dili mdisiso jako? ");
INSERT INTO kdc2014_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hebu kodahaze kumulongela ndugu yako, ‘Chonde, leka nikulave kibanzi kili mdisiso jako,’ kuno gweye ung'hali hunajona biki dili mdisiso jako mwenyego? Gweye kwa mnafiki! Tanhu lava biki dili mdisiso jako, abaho kodaha kulola goya na kulava kibanzi kili mdisiso da ndugu yako. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mbiki unogile haudaha kulela matunda gehile, hebu mbiki wihile haudaha kulela matunda ganogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kila mbiki wojuwika kwa matunda gake goulela, kwavija hudaha kubawa ngama mumkese hebu kubawa fulu kuna ivisolo va miba. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munhu yanogile kolava ganogile mwiingama yake inogile ili muumoyo wake, lakini munhu yehile kolava gehile mwiingama yake ihile ili muumoyo wake. Kwavija munhu kolonga gaja gamemile muumoyo wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Habali monikema, ‘Mndewa, Mndewa,’ kuno hamugatenda gaja goniwalongela? ");
INSERT INTO kdc2014_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Munhu yoyose yokwiza kumwangu na kutegeleza mbuli zangu na kuzigoga nowalagusila kaigala na choni. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kaigala na munhu yozenga ng'anda yake yahimbile hasi ng'hani, keka chandusilo chake mdibwe. Mvula ng'hulu viitowile, mazi gaitowa ing'anda, lakini hagadahile kuitigisa kwavija ikala izengigwe goya. ");
INSERT INTO kdc2014_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini munhu yoyose yotegeleza mbuli zangu na kolema kuzigoga, kaigala na munhu yazengile ng'anda yake bila kuhimba chandusilo. Mvula ng'hulu viitowile, mazi gaitowa ng'anda ija, nayo igwa na kubanangika!” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu viyamambukize kuwafundiza wanhu, kachola Kapelinaumu. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ako kukala na mkulu imoja wa wakalizi gana wa Kilumi yakalile na msang'hanaji wake mtamu ng'hani, na kalonda kufa. Nayo mkulu ayo kakala yomnogela ng'hani msang'hanaji ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkulu ayo viyahulike mbuli za Yesu, kawatuma wavele wayagwe wa Wayahudi wampule Yesu yeze kumuhonya msang'hanaji wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Avo wamcholela Yesu, wampula ng'hani, wamulongela, “Munhu ino kofaya umtaze. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kowanogela wanhu na vivija katuzengela ng'anda ya kumpula Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Avo Yesu kachola nao. Viyakalile behi na ng'anda ya mkulu ija, mkulu ija kawatuma mbwiga zake wamulongele Yesu, “Go mkulu, sekeuigaze kwiza ukae, kwavija niye sifaya gweye wingile mng'anda yangu, ");
INSERT INTO kdc2014_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","vivija niiyona sifaya hata kwiza kumwako. Lakini longa mbuli iiyeka, na msang'hanaji wangu kohona. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwavija naniye vivija na hasi ya udahi wa wakulu na nina wakalizi hasi yangu. Nahamulongela ino, ‘Chola!’ nayo kochola, nahamulongela iyagwe, ‘Izo!’ nayo kokwiza, vivija nahamulongela msang'hanaji wangu, ‘Tenda vino!’ nayo kotenda vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu viyahulike avo kakanganya ng'hani, kahinduka, kalulongela lunhu lwa wanhu lukalile lomkweleleza, “Nowalongela, sinamona munhu yeli na tamanilo kulu kamba dino, hata mwiisi ya Izilaeli!” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wanhu waja watumigwe wabwela kuna ing'anda ya mkulu ija, wamvika msang'hanaji ija kahona. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kumwande, Yesu kachola kudibuga dimoja dikemigwe Naini. Kailongoza na wanahina zake na lunhu mkulu lwa wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Viyakalile habehi na ulwivi mkulu wa kwingilila kudibuga dijo, wanhu wapapile maiti ga mbwanga wakala wolawa kunze kudibuga, wochola kuzika. Mbwanga ayo yafile kakala mwana yeli yaiyeka wa mtwanzi yakalile mgane. Wanhu wengi wa buga ijo wakala hamoja na mtwanzi ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mndewa Yesu viyamone mtwanzi ayo, kamonela bazi, kamulongela, “Sekeulile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Abaho kagenda, kalukwasa ulusazi luwaitambalize maiti ya mbwanga ija. Wanhu walupapile ulusazi luja wema. Yesu kalonga, “Mbwanga! Nokulongela, lamuka.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mbwanga ija yafile kalamuka, kasonga kulonga. Abaho Yesu kamgwaa mama ija mwanage. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wanhu wose wengila bwembwe na wamtogola Mulungu. Walonga, “Mtula ndagu mkulu wa Mulungu katulawilila hamwetu! Mulungu keza kuwakombola wanhu zake!” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbuli zino za Yesu zenela mwiisi yose ya Yudea na isi zili mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanahina zake Yohana Mbatizaji wamulongela Yohana mbuli zose zino. Nayo kawakema wanahina zake wabili mna iwanahina zake, ");
INSERT INTO kdc2014_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kawatuma wachole kwa Mndewa wakamuuze, “Vino gweye ayo ija iyalongile Yohana Mbatizaji kokwiza, hebu tumbete iyagwe?” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Viwavikile kwa Yesu, wamulongela, “Yohana Mbatizaji katutuma tukuuze, kamba gweye ayo ija yalongile kokwiza, hebu tumbete iyagwe?” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kipindi kikija Yesu kawahonya wanhu wengi wakalile watamu, wakalile wogaya, wakalile na vinyamkela na kawatenda wanhu wengi wakalile wasuwameso walole. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Avo Yesu kawedika, “Bweleni mkamulongele Yohana gaja gomuhulika na kugona, wasuwameso wolola, mbetembete wotembela, na weli na utamu wa dikulu wohonyigwa, na wanhu hawahulika wohulika, wafile wozilibuka, na wakiwa wopeteligwa Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kamweda munhu ija yeliduhu shaka na niye!” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wanahina wa Yohana viwasegele, Yesu kasonga kululongela lunhu luja mbuli ya Yohana, “Vino vimucholile kuluwala, muchola kulola choni? Muchola kulola lusanze vilutigisigwa na beho? ");
INSERT INTO kdc2014_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Vino muchola kulola choni? Muchola kumulola munhu yavalile viwalo vinogile? Wanhu iwovala viwalo vinogile, weli na ugima wa kubwihila wokala mzing'anda za wandewa! ");
INSERT INTO kdc2014_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nongeleni, vino muchola kulola choni? Muchola kumulola mtula ndagu wa Mulungu? Ona, lakini mona vingi ng'hani kubanza mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwavija Yohana ayo yalongigwe mna Gamaandiko Gang'alile, ‘Mulungu kalonga, nomtuma msenga wangu yakulongolele, yaitande nzila yako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kamambukiza kulonga, “Nowalongela, Yohana ni munhu mkulu kubanza munhu yoyose yakalile mwiisi. Lakini yeli mdodo Muundewa wa Mulungu ni munhu mkulu kubanza Yohana.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wanhu wose wamuhulike, hata wabokela kodi, wamtogola Mulungu kamba kanoga na wakala wabatizigwe na Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Mafalisayo na wafundiza Malagizo ga Musa walema kutenda ga Mulungu, kwavija walema kubatizigwa na Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kagendelela kulonga, “Vino niwasimulile kwa lusimo gani wanhu wa lukolo luno? Vino waigala na choni? ");
INSERT INTO kdc2014_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Waigala na wana wadodo wakalile mdigulilo. Kibumbila kimoja chokikemelela kibumbila kiyagwe, ‘Tuwatowela gombe sugu, lakini hamuvinile bule! Tuwembila nyila za kuindilo, lakini hamulilile bule!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana Mbatizaji keza, kafunga kuja na hang'wile divai, mweye mulonga, ‘Kana kinyamkela!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Munhu keza, kaja na kung'wa, mweye mulonga, ‘Muloleni munhu ino! Mmelo na mulevi, mbwiga wa wabokela kodi na wanhu waja wotenda nzambi!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lakini nzewele ya Mulungu yokoneka inoga kwa wanhu waja wose woitogola.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo imoja kamgoneka Yesu yakaje nayo lujo lwa ichungulo. Avo Yesu kachola kuna ing'anda ya Mfalisayo, kakala na kuja. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kudibuga dija kukala na mtwanzi imoja yakalile yotenda nzambi. Kahulika kamba Yesu kakala yoja mng'anda ya Mfalisayo ayo, avo kasola nyhupa ya alabasita imemile mavuta gonung'hila goya ga bei ng'hulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kema kukisogo, habehi na magulu ga Yesu kolila, mahozi gake galagalila mgamagulu ga Yesu. Abaho kagahangusa magulu ga Yesu kwa mvili zake, kaganonela na kagagidila mavuta. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayo ija viyone avo, kailongela, “Maza munhu ino yakalile mtula ndagu wa Mulungu, yahamjuwile mtwanzi ino yomgoga kavilihi, yahamjuwile kamema nzambi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamulongela, “Simoni, nina mbuli ya kukulongela.” Simoni kalonga, “Ona, Mfundiza, nongela.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kasonga kumulongela, “Kukala na wanhu wabili wakopile sente kwa munhu yokopesha sente. Imoja kakopa sente magana matano, na iyagwe kakopa malongo matano. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wose wabili hawadahile kumulipa, avo munhu ija kawalekelela wose. Vino nani mna iwanhu waja yonda yamnogele ng'hani munhu ija?” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamwidika, “Vinikona niye kokuwa ija yalekeleligwe sente nyingi.” Yesu kalonga, “Kulonga goya.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Abaho kamuhindukila mtwanzi ija na kamulongela Simoni, “Komona mtwanzi ino? Niza kuna ikae yako, hungwelele mazi ga kusunha magulu gangu, lakini mtwanzi ino kagasunha magulu gangu kwa mahozi gake na kagahangusa kwa mvili zake. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gweye hunibokele kwa kuninonela, lakini mtwanzi ino halekile kuganonela magulu gangu tangu vinizile. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hunibakile pala jangu mavuta, lakini mtwanzi ino kambakaza magulu gangu mavuta gonung'hila goya. ");
INSERT INTO kdc2014_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nokulongela, nzambi zake nyingi zigeligwa kumgongo, lekaavo kalagusa unogelwa mkulu. Lakini munhu yoyose yeli na nzambi kidogo zigeligwe kumgongo, kolagusa unogelwa mdodo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Abaho Yesu kamulongela mtwanzi ija, “Nzambi zako zigeligwa kumgongo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wanhu wayagwe wakalile hamoja na Yesu muulujo, wasonga kuilongela, “Ino munhu gani yodaha kuzigela kumgongo nzambi za wanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Lakini Yesu kamulongela mtwanzi ija, “Kutamanila kwako kukukombola. Genda moyo uholile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hamwande Yesu kafunga mwanza, kabitila mna gamabuga na vijiji kowapetela wanhu Mbuli Inogile ya Undewa wa Mulungu. Wanahina zake longo na wabili wachola nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Watwanzi wayagwe wakalile walavigwe vinyamkela na kuhonyigwa mitamu yao vivija wamkweleleza. Watwanzi awo wakala Malia, yakemigwe Magidalena, ija yalavigwe vinyamkela saba, ");
INSERT INTO kdc2014_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana mwehe wake Kuza yakalile msang'hanaji mkulu mna ikae ya mndewa Helode, na Suzana, na watwanzi wayagwe wengi. Watwanzi awo wakala wosola vinhu vao na kuwataza Yesu na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wanhu wagendelela kwiza kwa Yesu kulawa kila buga. Lunhu mkulu viluitig'hane hamoja, Yesu kalulongela lusimo luno. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kukala na munhu kachola kuhanda mbeyu mumgunda wake. Viyakalile komiza izimbeyu, mbeyu ziyagwe zilagalila mnzila, wanhu wazibojoga, na ndege wazija. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeyu ziyagwe zilagalila mdibwe hali na udongo kidogo. Vizotile, zinyala kwavija udongo ukala waduhu unyefu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeyu ziyagwe zilagalila mna ivisolo va miba. Miba ikula na izizonga zimbeyu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbeyu ziyagwe zilagalila mna udongo unogile. Zikula na kulela mbeyu nyingi kubanza zija zihandigwe, kila mbeyu ilela miyanza malongo longo.” Yesu viyalongile avo, kalonga kwa sauti ng'hulu, “Munhu yeli na magwiti, yahulike!” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanahina zake Yesu wamuuza fambulo da lusimo luno. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu kawedika, “Mweye mutendigwa kuzijuwa mbuli zifisigwe za Undewa wa Mulungu. Lakini kwa wanhu wayagwe, nolonga kwa simo, muladi walole lakini sekewone, na wategeleze lakini sekewajuwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Dino ijo fambulo da muhandaji, mbeyu ni mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Zija zilagalile mnzila zolagusa wanhu waja iwohulika mbuli ya Mulungu, lakini Mwenembago kokwiza na kuisola mbuli ayo mmizoyo yao muladi waleke kutogola na kukomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu zilagalile mdibwe zolagusa wanhu waja wohulika mbuli ya Mulungu na kuibokela kwa kudeng'helela, lakini mbuli ayo haika mizizi mgati mmwao. Woitogola kwa kipindi kidodo, lakini wahagezigwa woileka mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu zilagalile mvisolo va miba zolagusa wanhu waja wohulika mbuli ya Mulungu, lakini viwogendelela, Mbuli ayo yozongigwa zongigwa na magayo, na utajili, na kudeng'helela vinhu va mwiisi. Wanhu awo hawalela bule matunda gonda gakangale. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lakini mbeyu zilagalile hali na udongo unogile zolagusa wanhu waja iwohulika mbuli ya Mulungu na kuika mmizoyo yao na kuitogola, wofunga umoyo mbaka wolela matunda. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wanhu hawabwinha taa kuigubika na kikalango hebu kuika muuvungu wa lusazi. Lakini woika hana ikingolobweda, muladi wanhu viwokwingila wone mulenge. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kinhu chochose kifisigwe chokwikigwa hanhu hazelu, na kinhu chochose kigubikigwe chojuwika na kugaligwa hana umulenge. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Avo muiteganye na gaja gomuhulika, kwavija munhu yeli na kinhu kokongezeligwa, lakini ija yeliduhu kinhu kobokigwa hata kija kidodo kiyogesa kanacho.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mamake na ndugu zake Yesu wamcholela, lakini hawadahile kumvikila habehi mbuli ya lunhu lwa wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Munhu imoja kamulongela Yesu, “Mamako na ndugu zako wema kunze, wolonda kukona.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kawalongela wanhu wose, “Mamangu na ndugu zangu ni waja woihulika mbuli ya Mulungu na kuitenda.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Siku dimoja Yesu kakwela mwiingalawa hamoja na wanahina zake, kawalongela, “Tuloke umwambu.” Avo wasonga umwanza. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Viwakalile muumwanza, Yesu kawasa. Bahaja nyukwanyukwa da beho disonga kubuma mna idilamba, na ngalawa isonga kumema mazi, avo wose wakala mdizumozumo. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wanahina wamgendela Yesu wamulamusa, wamulongela, “Go mkulu! Go mkulu! Tofa!” Yesu kalamuka, kadikomhokela beho na ng'humbi ya mazi. Vose vinyamala na kukala tuluu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Abaho kawalongela wanahina zake, “Tamanilo jenu da kwahi?” Lakini awo wakanganya na kudumba, wailongela, “Ino munhu gani? Kodikomhokela beho na ng'humbi, navo vomuhulka!” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na wanahina zake wavika kuna imhwani ya isi ya Wagelasi, muumwambu wa lamba kulawa Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Viyahumuluke mwiingalawa, kamting'hana munhu imoja yeli na vinyamkela, yalawile kudibuga. Miyaka mingi munhu ayo kakala havala kiwalo wala hasinya ukayake, lakini kakala yokala kuna gamapanga. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Viyamone Yesu, kaibwanha mmagulu ga Yesu, kaguta mizangi yolonga, “Gweye Yesu! Mwana wa Mulungu yeli Uchanha Ng'hani! Kolonda kunitenda choni? Nokupula, sekeunidununze!” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kalonga avo kwavija Yesu kakala yamulagize ikinyamkela yamulawe munhu ayo. Miyanza mingi kinyamkela ayo kakala yomkumba munhu ayo. Hamoja wanhu wakala womgodeka mng'anda kuno makono gake na magulu gake gagodekigwa minyololo na mhingu, lakini kakala yokanha, na kinyamkela ayo kakala yomkimbiza mbaka kuluwala. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kamuuza munhu ija, “Twaga jako nani?” Kamwidika, “Twaga jangu Lunhu.” Kalonga avo kwavija vinyamkela wengi wakala wamkumbile. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Vinyamkela waja wampula Yesu sekeyawagale kuna dikolombo dikulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Habehi na aho kukala na bumbila kulu da nguluwe wakalile woja kukigongo. Avo vinyamkela wampula Yesu yawatogolele wawakumbe nguluwe. Yesu kawatogolela. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Vinyamkela wamulawa munhu ija, wawengila nguluwe. Bumbila jose da nguluwe dihumulukila mwiingema ya idilamba, wengila mdilamba, wose wafa mgamazi. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wanhu wakalile wowadima nguluwe awo wachona acho kilawilile, wakimbila na wazibwililisa mbuli azo kudibuga na mvijiji. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wanhu wachola kulola kija kilawilile. Viwavikile kwa Yesu, wamona munhu ija yalavigwe vinyamkela kakala mmagulu ga Yesu, kavala viwalo, kana nzewele zake. Wanhu wose wadumba. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na waja wayonile mbuli ayo, wawalongela wanhu vija munhu ayo yakalile na vinyamkela viyahonyigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abaho wanhu wose wa isi ija ya Wagelasi wampula Yesu yalawanye, kwavija wakala wadumbile ng'hani. Avo Yesu kakwela mwiingalawa na kulawanya. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Munhu ija yalavigwe vinyamkela kampula Yesu wachole wose. Lakini Yesu hamtogolele, kamulongela, ");
INSERT INTO kdc2014_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwela ukayako ukawalongele wanhu gose gayakutendele Mulungu.” Avo munhu ija kachola kila hanhu kudibuga dija, kawapetela wanhu mbuli zose ziyatendeligwe na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu viyabwelile mwambu uyagwe wa lamba, wanhu wambokela kwa deng'ho kwavija wose wakala wombeta. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Abaho keza munhu imoja, twaga jake Yailo. Munhu ayo kakala mkulu wa ng'anda ya kumpula Mulungu. Kamfugamila Yesu, kampula yachole ukayake, ");
INSERT INTO kdc2014_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwavija mndele wake yeli yaiyeka kakala mmabehi kufa. Mndele ayo kakala na miyaka longo na mibili. Yesu viyakalile kochola, wanhu wakala womsung'ha sung'ha kila mwambu. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mna dibumbila dija da wanhu, kukala na mtwanzi imoja yakalile na utamu wa kutumika kwa miyaka longo na mibili. Kakala yamambukize vinhu vake vose kwa waganga, lakini kuduhu munhu yadahile kumuhonya. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mtwanzi ija kamcholela Yesu kukisogo, kakwasa mhindo ya kiwalo cha Yesu, bahaja kutumika kuleka. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kauza, “Nani yanikwasile?” Wanhu wose wabela. Petulo kalonga, “Go mkulu, wanhu wose wakuzunguluka na kukusung'ha sung'ha.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu kalonga, “Kuna munhu kanikwasa, kwavija nihulika nguvu zinilawa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mtwanzi ija viyone hadaha kuifisa, keza yogwaya, kaibwanha mmagulu ga Yesu. Baho mgameso ga wanhu, kamulongela Yesu habali kakwasa mhindo ya kiwalo chake, na vija viyahonyigwe bahaja. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamulongela, “Mwanangu, kutamanila kwako kukuhonya. Chola moyo uholile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu viyakalile yang'hali yolonga, msenga kulawa ukayake Yailo keza, kamulongela Yailo, “Mndele wako kamala kufa, avo sekeumgaze Mfundiza.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lakini Yesu viyahulike avo, kamulongela Yailo, “Sekeudumbe, gweye togola tu, mndele wako kohona.” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Viyavikile kuna ing'anda ya Yailo, Yesu kawagomesa wanhu sekewengile hamoja nayo, ila kengila na Petulo na Yohana, na Yakobo na tatake na mamake mndele ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wanhu wose wakala wolila na kumuyalalila imwana. Yesu kawalongela, “Sekemulile, kwavija imwana hafile bule, kawasa tu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wanhu wose wamseka kwavija wakala wajuwile imwana kakala yafile. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini Yesu kamgoga mkono, kamulongela, “Mwanangu, lamuka!” ");
INSERT INTO kdc2014_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ugima wake umbwelela mndele ija, bahaja kalamuka. Abaho Yesu kawalagiza wamgwee lujo. ");
INSERT INTO kdc2014_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tatake na mamake wakanganya ng'hani, lakini Yesu kawagomesa sekewamulongele munhu yoyose kija kilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu kawakema hamoja wanahina zake longo na wabili, kawagwaa nguvu na udahi wa kulava vinyamkela na kuwahonya watamu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Abaho kawatuma wachole wakawapetele wanhu usenga wa Undewa wa Mulungu na kuhonya watamu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kawalongela, “Sekemusole kinhu chochose muumwanza wenu. Sekemusole mkongoja, wala mkoba, wala lujo, wala sente, wala viwalo vibili. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ng'anda yoyose yonda mwingile na kugonekigwa, kaleni mumo mbaka vonda musegele mna idibuga dijo. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wanhu wahalema kuwabokela, segeleni buga dijo na kung'huseni timbwisi dili mmagulu genu kiwe kilaguso kamba wawatendela nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wanahina wafunga mwanza, wabitila vijiji vose wowapetela wanhu Mbuli Inogile na kuwahonya wanhu kila hanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helode yakalile mndewa wa Galilaya, kahulika mbuli zose ziyatendile Yesu. Kanyawanyawa ng'hani, kwavija wanhu wakala wolonga Yohana Mbatizaji kazilibuka kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wanhu wayagwe walonga Eliya kalawilila, wayagwe walonga imoja wa watula ndagu wa Mulungu wa umwaka kazilibuka kulawa kuna iwanhu wafile. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lakini Helode kalonga, “Yohana nimkanha dipala, vino ino ayo nani inihulika mbuli zake?” Nayo kalonda kumona Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Watumigwa waja viwabwelile, wamulongela Yesu kila kinhu wakitendile. Yesu kawasola, kachola nao waiyeka kuna dibuga dikemigwe Betisaida. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini wanhu viwajuwile avo, wamkweleleza Yesu. Nayo kawabokela, kalonga nao mbuli ya Undewa wa Mulungu na kawahonya waja wakalile watamu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zuwa vidisongile kuhonga, wanahina longo na wabili wamcholela Yesu, wamulongela, “Walongele wanhu wachole kuna ivijiji na migunda ilibehi na hano wakazahile lujo na hanhu ha kuwasa, kwavija hano hatwili twa kuluwala.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini Yesu kawalongela, “Mweye wagweleleni lujo waje.” Lakini wao wamwidika, “Tuna magate matano na somba wabili tu. Kolonda tuchole tukawagulile lujo lunhu lose luno?” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wambigalo waiyeka wakalile hanhu aho wakala wovika elufu tano. Yesu kawalongela wanahina zake, “Walongeleni wanhu wakale mna ivibumbila va wanhu malongo matano.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nao wanahina watenda vivo. Wanhu wose wakala hasi. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Abaho Yesu kagasola magate matano na somba wabili, kalola uchanha kuulanga, kamgwaa nhogolwa Mulungu, kagabanzula gamagate na iwasomba, kawagwaa wanahina zake wawagwelele wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wanhu wose waja na kwiguta. Wanahina zake wasola vigelo longo na vibili vimemile vinhu visigale. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Siku dimoja Yesu kakala yaiyeka kompula Mulungu. Wanahina zake wamcholela, nayo kawauza, “Vino wanhu wolonga niye na nani?” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wamwidika, “Wanhu wayagwe wolonga gweye kwa Yohana Mbatizaji, wayagwe wolonga kwa Eliya, kuno wayagwe wolonga gweye kwa imoja wa watula ndagu wa Mulungu wa umwaka yazilibuke kulawa kwa wafile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu kawauza, “Na mweye molonga niye na nani?” Petulo kamwidika, “Gweye kwa Kilisito, wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Abaho Yesu kawagomesa wanahina zake sekewamulongele munhu yoyose mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Vivija Yesu kawalongela, “Mwana wa Munhu kolondeka yadununzike ng'hani, na kulemigwa na wavele na wakulu wa walava nhosa na wafundiza Malagizo ga Musa. Kokomigwa lakini siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Abaho Yesu kawalongela wanhu wose, “Munhu yoyose yolonda kunikweleleza, yaileme mwenyego, yaidikwe msalaba wake kila siku, yanikweleleze. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwavija munhu yoyose yolonda kuukombola ugima wake mwenyego kowagiza, lakini munhu yoyose yowagiza ugima wake mbuli ya niye, koukombola. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vino munhu yahapata kila kinhu mwiisi, lakini kowagiza ugima wake, munhu ayo kopata choni? ");
INSERT INTO kdc2014_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kamba munhu konyonela kinyala niye na mafundizo gangu, Mwana wa Munhu nayo yaheza muukulu wake na wa Tatake na wasenga wa kuulanga wang'alile komonela kinyala munhu ayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lakini nowalongela ukweli, wanhu wayagwe wemile hano honda wafe mbaka wawone Undewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Vizibitile siku nane toka yalonge mbuli azo, Yesu kawasola Petulo na Yohana na Yakobo kachola nao kukigongo kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Viyakalile kompula Mulungu, kihanga chake kigaluka, viwalo vake vikala vizelu chuwee! ");
INSERT INTO kdc2014_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bahaja wanhu wabili wakala aho wolonga nayo. Nao wakala Musa na Eliya, ");
INSERT INTO kdc2014_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","wakoneka muukulu, wakala wolonga na Yesu mbuli ya ifa yake yonda yaimambukize ako Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na wayage wakala wokuluza. Viwalamuke, wawona ukulu wa Yesu na wanhu wabili wemile nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wanhu waja viwakalile wosegela, Petulo kamulongela Yesu, “Go mkulu, vinoga tweye tukale hano! Tuzenge viheha vidatu, kimoja chako, kimoja cha Musa na kimoja cha Eliya.” Petulo kakala hajuwa bule kija kiyolonga. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo yang'hali yolonga, wingu dilawilila, diwagubika na kungugu jake, wanahina wadumba ng'hani wingu dijo vidiwagubike. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauti ilonga kulawa mdiwingu, “Ino ayo Mwanangu inimsagule. Mtegelezeni!” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sauti ayo viinyamale, Yesu kasigala yaiyeka. Wanahina wanyamala tuluu, na kipindi kija hawamulongele munhu yoyose kija kiwone. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Imitondo yake Yesu na wanahina zake wadatu wahumuluka kukigongo. Lunhu mkulu lwa wanhu luiting'hana na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Munhu imoja mna ulunhu kaguta, “Mfundiza! Nokupula undolele mwanangu, mwanangu yeli yaiyeka! ");
INSERT INTO kdc2014_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kinyamkela komkumba na komtenda yagute nyangi, komgela kisango kuno kolawa miholovu mumulomo. Kogendelela kumulumiza na hamuleka hima bule! ");
INSERT INTO kdc2014_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niwapula wanahina zako wamulave kinyamkela ayo, lakini hawadahile bule.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kawalongela, “Mweye lukolo luliduhu kutamanila na lwagile! Nokala na mweye mbaka lini? Nogela kitumbe kumgongo mbaka lini?” Abaho kamulongela munhu ija, “Mgale hano mwanago.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mbwanga ija viyakalile komwizila Yesu, kinyamkela kambwanha hasi na kamgela kisango. Lakini Yesu kamkomhokela kinyamkela, kamuhonya mbwanga ija, na kamgwaa tatake. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wanhu wose wakanganya kwa udahi mkulu wa Mulungu. Wanhu viwakalile wang'hali wokanganya mbuli ziyatendile Yesu, Yesu kawalongela wanahina zake, ");
INSERT INTO kdc2014_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sekemuisemwe mbuli inilonda kuwalongela! Mwana wa Munhu kogeligwa mmakono ga wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini wanahina zake hawajuwile fambulo da ulonzi awo. Ukala ufisigwe kumwao avo hawadahile kuujuwa, nao wadumba kumuuza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wanahina wa Yesu wasonga kuibamilila wao kwa wao nani yeli munhu mkulu viweli. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu kakijuwa kiwakalile wogesa, kamsola mwana mdodo, kamwika behi nayo. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Abaho kawalongela wanahina zake, “Munhu yoyose yombokela mwana ino kwa twaga jangu, konibokela niye, na munhu yoyose yombokela niye, kombokela ija yanhumile. Kwavija munhu yeli mdodo vimwili, ayo munhu mkulu kubanza wose.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana kamulongela Yesu, “Mndewa, tumona munhu kolava vinyamkela kwa twaga jako. Tumgomesa kwavija halawa mkibumbila chetu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kamulongela Yohana na wanahina wayagwe, “Sekemumgomese, kwavija munhu yoyose hamwihilani mweye miyenu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kipindi cha Yesu kugaligwa kuulanga vikikalile mmabehi, kagangamala, kachola Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kawatuma wasenga wamulongolele wachole kuna ikijiji kili mwiisi ya Samalia kumtandila kila kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini wanhu wa kijiji cha Samalia hawambokele Yesu, kwavija wajuwa kamba kakala kochola Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanahina zake, Yakobo na Yohana viwone avo, walonga, “Mndewa, kolonda tulagize moto kulawa kuulanga uwasakaze wose?” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kahinduka kawakomhokela. Kawalongela, “Hamujuwile bule loho gani imulinayo, kwavija Mwana wa Munhu hezile kuubananga ugima wa wanhu lakini keza kuukombola.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Abaho Yesu na wanahina zake wachola kuna ikijiji kiyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Viwakalile mnzila, munhu imoja kamulongela Yesu, “Nokukweleleza kokose konda uchole.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamulongela, “Vizongo wana mhango na ndege wana mvulu, lakini Mwana wa Munhu kaduhu hanhu ha kubwihila na kutambalala.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu kamulongela munhu iyagwe, “Nikweleleze.” Lakini munhu ija kalonga, “Go mkulu, beta tanhu mbwele ukae hamzike tatangu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamwidika, “Waleke wanhu wafile wawazike wanhu wafile wayao. Lakini gweye chola ukawapetele wanhu Undewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Munhu iyagwe kalonga, “Go mkulu, nokukweleleza, lakini beta tanhu halulage lukolo lwangu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kamulongela, “Munhu yoyose yokwaluka kulima abaho kolola kukisogo, hafaya Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Abaho Mndewa Yesu kawasagula wanhu wayagwe malongo saba na wabili, kawatuma wabili wabili wamulongolele kila kijiji na kila hanhu kuyalondile kuchola. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kawalongela, “Kuna ndiya nyingi lakini wasang'hanaji wadodo. Mpuleni Mndewa wa indiya yawatume wasang'hanaji mumgunda wake. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gendeni! Nowatuma mweye kamba ng'hondolo mna iwambwizi. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sekemusole mfuko hebu mkoba hebu vilatu. Sekemwime na kumulamusa munhu yoyose mnzila. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ng'anda yoyose yonda mwingile, tanhu mulonge, ‘Tindiwalo dikale mng'anda ino.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kamba hana munhu kodinogela tindiwalo, tindiwalo jenu dokala nayo, kamba kuduhu munhu yodinogela tindiwalo, tindiwalo jenu dowabwelela. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mkale mng'anda ayo, diyeni na kung'wa chochose chonda wawagwelele, kwavija msang'hanaji kolondeka yapate malipo gake. Sekemuhamehame kulawa ng'anda imoja kuchola iyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Buga jojose donda mwingile na kubokeligwa, diyeni vija vonda wawagwelele. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wahonyeni watamu weli kuko, na muwalongele, ‘Undewa wa Mulungu wa behi yenu.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini buga jojose donda mwingile na wanhu wolema kuwabokela, laweni mumo, na vimubita kuna zinzila zao, mulonge, ");
INSERT INTO kdc2014_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata matimbwisi ga buga jenu gatunanahile mmagulu getu togakung'husa kiwe kilaguso kumwenu kamba mututendela gehile. Lakini mujuwe kamba Undewa wa Mulungu wa mmabehi!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nowalongela ukweli, mna isiku ya nhaguso, Mulungu kolagusa bazi ng'hani kwa wanhu wa buga da Sodoma kubanza wanhu wa buga dijo! ");
INSERT INTO kdc2014_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kogaya gweye buga da Kolazini! Kogaya gweye buga da Betisaida! Maza unzonza utendigwe kumwenu mweye wahatendigwe mna gamabuga ga Tilo na Sidoni, wanhu zake wahalekile mwaka nzambi zao na kuvala magunia na kuibakaza mitozi, kulagusa kamba waleka nzambi! ");
INSERT INTO kdc2014_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mwiisiku ya nhaguso, Mulungu kolagusa bazi ng'hani kwa wanhu wa mabuga ga Tilo na Sidoni kubanza mweye. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Gweye buga da Kapelinaumu, vino kolonda kuinula mwenyego mbaka uchanha kuulanga? Mawe! Kohumulusigwa mbaka kowochola wanhu wafile!” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu kawalongela wanahina zake, “Munhu yoyose yowategeleza mweye, konhegeleza niye, na yoyose yowalema mweye, kondema niye. Na munhu yoyose yondema niye, komulema ija yanhumile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Abaho wanhu waja malongo saba na wabili wabwela kuno wodeng'helela. Walonga, “Mndewa, hata vinyamkela watutegeleza vituwakomhokele kwa twaga jako!” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kawedika, “Nimona Mwenembago kolagala kulawa kuulanga kamba lumwesa. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tegelezeni! Niwagwaa udahi, avo modaha kukanyaga mgendela hasi na inge na kuzihuma nguvu zose za Mwenembago. Kuduhu kinhu chonda kiwalumize. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lakini sekemudeng'helele kwavija vinyamkela wowategeleza, ila deng'heleleni kwavija matwaga genu gandikigwa kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kipindi kija Yesu kadeng'helela kwa udahi wa Loho Yang'alile, kalonga, “Tata, Mndewa wa kuulanga na mwiisi! Nokutogola kwavija kuwafisa mbuli zino wanhu weli na nzewele na ubala, na kuwagubulila wana wadodo. Ona, Tata, vino vivo viulondile. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tatangu kanigwaa vinhu vose. Kuduhu munhu yamjuwile Mwana ila Tata yaiyeka, na kuduhu munhu yamjuwile Tata ila Mwana na waja wose Mwana yawasagule kuwagubulila wamjuwe Tata.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Abaho Yesu kawahindukila wanahina zake, kalonga nao kinyelegezi, “Wamweda wanhu wose wovona vinhu vimona mweye! ");
INSERT INTO kdc2014_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nowalongela ukweli, watula ndagu wengi wa Mulungu na wandewa walonda kuvona vimona mweye, lakini hawavonile bule, na vivija walonda kuhulika vimuhulika mweye, lakini hawahulike bule.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Munhu imoja yagajuwile goya Malagizo ga Musa, kachola kwa Yesu yamgeze. Avo kamuuza, “Mfundiza, vino nhende choni niupate ugima wa mazuwa gose?” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kamwidika, “Vino, Malagizo golongaze na gweye kogajuwaze?” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Munhu ija kamwidika, “ ‘Mnogele Mndewa Mulungu wako kwa moyo wako wose, na kwa loho yako yose, na kwa nguvu zako zose, na kwa nzewele zako zose,’ na ‘Umnogele miyago kamba viuinogela mwenyego.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kamwidika, “Kulonga goya, tenda vivo na gweye kokuwa na ugima.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini munhu ija kalonda kuilagusa kamba kanoga, avo kamuuza Yesu, “Vino miyangu ayo nani?” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kamwidika, “Munhu imoja kakala kolawa Yelusalemu kochola Yeliko. Mnzila, wabavi wamgoga, wamboka vinhu vake, na kumtowa, wamuleka habehi na kufa. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Abaho mulava nhosa imoja kakala yohumuluka kubitila nzila iija. Viyamone, kainega, kabitila kumgwazo. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vivija Mlawi imoja viyavikile aho, kamulola munhu ija, nayo kainega, kabitila kumgwazo. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini Msamalia imoja yakalile muumwanza kavika aho hayakalile munhu ija. Nayo viyamone, kamonela bazi. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamcholela, kamgela mavuta na divai mna ivilonda vake na kavifunga goya. Abaho kamwika uchanha mwa mhunda wake, kamgala mbaka kuna ing'anda ya wageni na kumulolesa goya. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Imitondo yake kalava sente kamgwaa mwene ng'anda, kamulongela, ‘Mulolese goya munhu ino. Chochose chonda umsang'hanile, nahabwela nokugwaa fungu jako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Abaho Yesu kamuuza, “Viukona gweye, mna iwanhu awo wadatu, nani yakalile miyage munhu ija yatoigwe na wabavi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Munhu ija kamwidika, “Ija yamonele bazi.” Yesu kamulongela, “Na gweye genda ukatende vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na wanahina zake viwakalile mnzila, wengila kuna ikijiji kimoja. Mtwanzi imoja twaga jake Mata kambokela ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata kakala na mdodo wake yakemigwe Malia, yakalile hasi behi na magulu ga Yesu na kutegeleza mafundizo gake. ");
INSERT INTO kdc2014_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Mata kakala yohunganika na sang'hano nyingi ziyalondeke kusang'hana, avo kamcholela Yesu, kamulongela, “Mndewa, vino hutonga bule kamba mdodo wangu kanilekela sang'hano zose nisang'hane niiyeka? Mulongele yeze yanitaze!” ");
INSERT INTO kdc2014_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Mndewa kamwidika, “Gwee Mata gwee! Kohunganika na kugaya kwa vinhu vingi, ");
INSERT INTO kdc2014_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lakini kimoja kiiyeka kilondeka. Malia kasagula kinhu kinogile, na honda kisegezigwe bule kumwake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Siku dimoja Yesu kakala hanhu kompula Mulungu. Viyamambukize, mwanahina wake imoja kamulongela, “Mndewa, tufundize kupula, kamba vija Yohana viyawafundize wanahina zake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kawalongela, “Mwahampula Mulungu, longeni vino. ‘Tataetu uli kuulanga. Twaga jako ditogoligwe, Undewa wako wize. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utugwee lelo lujo lwa kila siku. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uzigele kumgongo nzambi zetu, kamba vija tweye vituzigela kumgongo nzambi za wanhu. Sekeutwingize kuna ukugezigwa.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Abaho Yesu kawalongela wanahina zake, “Munhu gani kumwenu yeli na mbwiga yahamcholela kilo kikulu na kumulongela, ‘Mbwigangu, ng'hopeshe magate madatu, ");
INSERT INTO kdc2014_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwavija mbwigangu keza, kalawa mwanza, na niye nabule lujo lwa kumgwaa!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","na ija yeli mng'anda yamwidike, ‘Sekeunigaze! Lwivi luhindigwa mwaka, na niye na wanangu tuwasa, avo sidaha kulamuka kukugwaa kinhu chochose.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nowalongela vino, hata yahalema kulamuka na kumgwaa magate kwavija mbwigake, lakini kwavija kaduhu kinyala kugendelela kumpula, kolamuka na kumgwaa kila kinhu kiyopula. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Avo nowalongela, puleni na mweye mogweleligwa, zahileni na mweye movona, gong'ondeni ulwivi na mweye movugulilwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwavija waja wose wompula Mulungu wogweleligwa, na waja wozahila wopata, na lwivi lovuguligwa kwa munhu yoyose yogong'onda. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Vino kuna munhu yoyose kumwenu kamba mwanage yahampula somba, heyo komgwaa zoka? ");
INSERT INTO kdc2014_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hebu yahampula finga komgwaa inge? ");
INSERT INTO kdc2014_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kamba mweye wene nzambi mojuwa kuwagwaa wanenu vinhu vinogile, lakini Tataenu yeli kuulanga kowagwaa ng'hani Loho Yang'alile wanhu waja wompula.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Siku dimoja Yesu kakala komulava kinyamkela yamtendile munhu imoja yalemelwe kulonga. Kinyamkela ayo viyamulawile, munhu ija kasonga kulonga. Lunhu lwa wanhu lukanganya ng'hani, ");
INSERT INTO kdc2014_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","lakini wanhu wayagwe walonga, “Belizebuli, mkulu wa vinyamkela, ayo yomgwaa udahi wa kulava vinyamkela.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wanhu wayagwe walonda kumgeza Yesu, avo wampula yatende kilaguso kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini Yesu kakijuwa kiwakalile wokigesa, avo kawalongela, “Undewa wowose wahaigola mna ivibumbila na kuitowa, undewa awo wofa, na lubuga lumoja lwahaigola, lubuga lulo lofa. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Avo kamba undewa wa Mwenembago wahaigola mvibumbila na kuitowa, undewa awo wokwimaze? Mweye molonga niye nolava vinyamkela kwavija Belizebuli konigwaa udahi wa kutenda vivo. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kamba nolava vinyamkela kwa udahi wa Belizebuli, avo wanhu wenu wolava vinyamkela kwa udahi wa nani? Kwa mbuli ayo wanhu wenu wenyego wowatagusa kamba mobananga! ");
INSERT INTO kdc2014_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini kamba nowalava vinyamkela kwa udahi wa Mulungu, avo mujuwe kamba Undewa wa Mulungu uvika mwaka kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Munhu mwene nguvu viyokaliza ng'anda yake kwa silaha, vinhu vake havisoligwa bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini yaheza munhu mwene nguvu kubanza heyo, komtowa na kumuhuma, komboka silaha zake ziyatamanile na koigolela na wayage vija viyasolile. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Munhu yoyose heli ubanzi wangu konilema, na munhu yoyose yolema kunitaza kwika hamoja, ayo kopwililisa. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kinyamkela yahamulawa munhu, kochola mwiisi inyalile kuzahila hanhu ha kubwihila. Yahaswela, koilongela, ‘Nobwela ukayangu kunilawile.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yahabwela na kuivika ng'anda ifagiligwa na kila kinhu kikigwa goya, ");
INSERT INTO kdc2014_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","baho kobwela na kuwagala vinyamkela wayagwe saba wehile kubanza heyo, awo wokwiza na kukala mumo. Avo ugima wa munhu ayo wokuwa wiha kubanza aho haichanduso.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu yang'hali yolonga, mtwanzi imoja kulawa kuna ulunhu kamulongela kwa sauti ng'hulu, “Kamweda mtwanzi yakulelile na kukukong'heza!” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini Yesu kamwidika, “Wamweda ng'hani wanhu wose wohulika mbuli ya Mulungu na kuigoga!” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wanhu viwakalile womsung'ha sung'ha, Yesu kagendelela kulonga, “Lukolo luno lwa wanhu wotenda nzambi! Lolonda kilaguso, lakini kuduhu kilaguso chochose chonda wagweleligwe, ila kilaguso cha Yona. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kamba vija mtula ndagu wa Mulungu Yona viyakalile kilaguso kwa wanhu wa Ninawi, vivo ili kwa Mwana wa Munhu vonda yawe kilaguso kwa wanhu wa lukolo luno. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mna isiku ya nhaguso, Malikia wa Sheba kokwima na kuwatagusa mweye kamba mubananga, kwavija heyo kafunga mwanza kulawa mwiisi yake kachola kumtegeleza Mndewa Sulemani na mafundizo gake geli na nzewele. Nowalongela, hano hana munhu mkulu kubanza Sulemani. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mna isiku ya nhaguso, wanhu wa Ninawi wokwima na kuwatagusa mweye, kwavija awo waleka nzambi Yona viyawapetele. Lakini nowalongela, hano hana munhu mkulu kubanza Yona! ");
INSERT INTO kdc2014_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kuduhu munhu yobwinha taa na kuigubika na kikalango, lakini koika kukingolobweda, muladi wanhu wokwingila mng'anda wone mulenge. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meso gako mulukuli lwako gaigala na taa. Kamba meso gako magima, lukuli lwako lose lokuwa na mulenge, lakini meso gako gahabanangika, lukuli lwako lose lokuwa mdiziza. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Muiteganye, mulenge uli mgati mmwenu sekeuwe ziza. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kamba lukuli lwako lose lwahawa na mulenge, na kuduhu hanhu heli na ziza, lukuli lwako lose lokuwa na lenge eka, kamba vija taa viimwemwesa mulenge wake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu viyamambukize kulonga, Mfalisayo imoja kamgoneka ukayake wakaje hamoja, avo Yesu kengila mng'anda, kakala hasi, kasonga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisayo ayo kakanganya ng'hani viyamone Yesu koja bila kusunha makono gake. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Avo Mndewa kamulongela, “Mweye Mafalisayo mosunha vikasi na sahani kwa kunze, lakini mgati mmwenu mmema ubokaji na gehile. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mweye mwa wabozi! Vino siyo Mulungu yavitendile va kunze na va mgati vivija? ");
INSERT INTO kdc2014_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lakini laveni vili mgati na muwagwee wakiwa na kila kinhu chonoga kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mogaya mweye Mafalisayo! Kwavija momgwaa Mulungu fungu da longo da majani gonung'hila goya kamba vija binzali na kalafuu, na mboga ziyagwe, lakini moleka kutenda ganogile kwa wanhu na kumnogela Mulungu. Molondeka kutenda gano na sekemugaleke gago gayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mogaya mweye Mafalisayo! Kwavija monogelwa kukala kuna ivigoda va haulongozi mzing'anda za kumpula Mulungu na kulamusigwa mna gamagulilo. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mogaya mweye! Kwavija muigala na mapanga hagakoneka, wanhu wobita uchanha bila kugajuwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Munhu imoja yagajuwile goya Malagizo ga Musa kamulongela Yesu, “Mfundiza, wahalonga avo, kotuliga tweye vivija!” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kamwidika, “Vivija mogaya mweye mugajuwile goya Malagizo ga Musa! Kwavija mowapapiza wanhu mizigo mikulu, lakini mweye wenyego hamulonda kugolosa makono kuwataza kupapa. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mogaya mweye, kwavija mogazengela goya mapanga ga watula ndagu wa Mulungu, waja wakomigwe na wahenga zenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mweye wenyego mokitogola kija kiwatendile wahenga zenu, kwavija wao wawakoma watula ndagu wa Mulungu, na mweye mogazengela goya mapanga gao. ");
INSERT INTO kdc2014_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwa mbuli ayo, nzewele ya Mulungu ilonga, ‘Nowatuma watula ndagu wa Mulungu na watumigwa, wayagwe wowakoma na wayagwe wowadununza!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Avo wanhu wa lukolo luno wotagusigwa mbuli ya kuwakoma watula ndagu wose wa Mulungu, kulawa kuna ichanduso cha isi, ");
INSERT INTO kdc2014_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","toka kukomigwa kwa Habili mbaka kukomigwa kwa Zakalia, ija yakomigwe hagati ha upango wa kulavila nhosa na Hanhu Hong'ala. Ona, nowalongela, wanhu wa lukolo luno wotagusigwa kwa kuwakoma wao!” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mogaya mweye wafundiza Malagizo ga Musa! Kwavija mofisa luvugulo lwa kuvugulila lwivi lwa ng'anda ya kuifunzila. Mweye wenyego hamwingila bule, abaho muwagomesa waja wakalile wolonda kwingila sekewengile!” ");
INSERT INTO kdc2014_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu viyasegele hanhu aho, wafundiza Malagizo ga Musa na Mafalisayo wasonga kumulonga vihile na kumuuza mbuli nyingi, ");
INSERT INTO kdc2014_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wageza kumnamata kwa mbuli zake zonda yalonge. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wanhu wengi waiting'hana hamoja mbaka wanhu wakala woikanyaga. Tanhu Yesu kawalongela wanahina zake, “Iteganyeni na usasu wa Mafalisayo, nao ndo unafiki. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kinhu chochose kigubikigwe chogubuligwa, na kija kifisigwe chojuwika. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Avo chochose kimulongile mdiziza chohulikigwa mmulenge, na chochose kimunyong'onye mwiiyeka mdigati dihindigwe chopetigwa mkiswili. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nowalongela mweye mbwiga zangu, sekemuwadumbe wanhu waja woukoma lukuli, abaho hawadaha kutenda kinhu kiyagwe chochose kihile. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lakini nowalagusila wa kumdumba, mdumbeni Mulungu, heyo yahakoma, kana udahi wa kumwasa munhu muumoto wa jehanamu. Nowalongeleni, mdumbeni ayo! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Vino nhongwa watano hawachuuzigwa kwa sente ndodo mbili? Lakini kuduhu hata imoja yosemwigwa na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hata mvili zili mmapala genu zipetigwa zose. Avo sekemudumbe. Mweye munoga ng'hani kubanza nhongwa wengi! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nowalongeleni ukweli, munhu yoyose yonitogola niye mgameso ga wanhu, Mwana wa Munhu nayo komtogola mgameso ga wasenga wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini munhu yoyose yonibela niye mgameso ga wanhu, Mwana wa Munhu nayo kombela mgameso ga wasenga wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Munhu yoyose yomulonga vihile Mwana wa Munhu, nzambi zake zogeligwa kumgongo, lakini munhu yoyose yomuliga Loho Yang'alile, nzambi zake honda zigeligwe kumgongo bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wahawagala haulongozi wa ng'anda za kumpula Mulungu, na mgameso ga wakulu wa isi na wandewa, sekemunyawenyawe vija vonda mwidike hebu kija chonda mulonge. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwavija Loho Yang'alile kowafundiza saa iija kimulondeka kulonga.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Munhu imoja muulunhu kamulongela Yesu, “Mfundiza, mulongele ndugu yangu tuigolele uhazi wa tataetu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu kamwidika, “Mbwigangu, nani yanigwelele udahi wa kuwalamula hebu kuwagolela uhazi wenu?” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Abaho kagendelela kuwalongela wose, “Muiteganye na ugila! Kwavija ugima wa munhu hautamanila wingi wa vinhu viyalinavo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Abaho Yesu kawalongela lusimo luno, “Kukala na munhu imoja yakalile na mgunda uli na ndiya nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kasonga kugelegeza mwenyego, ‘Nabule hanhu hakwika ndiya yangu yose. Nhendeze?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Abaho kailongela, ‘Notenda vino, nogatula makanho gangu na kuzenga makulu ng'hani. Mumo nokwika ndiya yangu na vinhu vangu viyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Abaho noilongela, gweye moyo wangu! Kuna vinhu vose vinogile kwa miyaka heleketwaa. Bwihila, diya, ing'wa, na kudeng'helela!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Mulungu kamulongela, ‘Gweye kwa mbozi! Kilo cha lelo noulonda ugima wako, abaho vinhu vose vino viuikile vokuwa va nani?’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Abaho Yesu kamambukiza kulonga, “Vino vivo ili kwa waja woikila vinhu vao wenyego, lakini haweka vinhu vao kwa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Abaho Yesu kawalongela wanahina zake, “Nowalongela, sekemulugaiye lujo lumulonda muladi muwe wagima, hebu viwalo vimulonda kwa ng'huli zenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwavija ugima unoga kubanza lujo, na lukuli lunoga kubanza viwalo. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Waloleni bondwa, hawahanda, hawasenga, waduhu makanho, lakini Mulungu kowadima! Vino Mulungu hawanogela ng'hani mweye kubanza iwabondwa? ");
INSERT INTO kdc2014_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nani kumwenu kwa kuigaza ng'hani kodaha kwengeza hata saa dimoja da ugima wake? ");
INSERT INTO kdc2014_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kumbe hamudaha kutenda mbuli ndodo kamba ino, habali moigaza kwa mbuli ziyagwe? ");
INSERT INTO kdc2014_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Loleni maluwa vigokula. Hagasang'hana hebu hagaisonela viwalo. Lakini nowalongela kweli, hata mndewa Sulemani, hamoja na utajili wake wose kakala kaduhu viwalo vinogile viigalile na maluwa gano. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kamba Mulungu heyo yodivaza jani da kumuhulo, lelo dabahano na mayo dokwasigwa muumoto, vino hondayawavaze ng'hani mweye? Mweye wanhu mutamanila kidogo! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Avo sekemuigaze moja choni, hebu mong'wa choni. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwavija vinhu avo, vivo voogaiya wanhu haweli Wayahudi. Tataenu yeli kuulanga kojuwa molonda vinhu vose avo. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lakini uzahileni tanhu Undewa wa Mulungu, nayo kowagwaa vinhu avo. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sekemudumbe mweye kibumbila kidodo cha wanahina zangu, kwavija Tataenu kanogelwa kuwagwaa mweye Undewa. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chuuzeni vose vimulinavo na muwagwelele wakiwa zisente. Muitendele mikoba hailala, na muikile ngama yenu kuulanga. Ako hondaihunguke, kwavija kuduhu wabavi wodaha kuhavika na kuduhu ng'hobo wodaha kuibananga. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwavija kuko kuili ngama yako, vivija kuko kondauwe moyo wako. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Muitande na kuifunga mikwiji mvigudi, na taa zenu ziwe zokwaka, ");
INSERT INTO kdc2014_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kamba wasang'hanaji viwombetela mkulu wao yabwele kulawa kuna idizengele. Yahabwela na kugong'onda ulwivi, himahima womvugulila. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wamweda wasang'hanaji waja mkulu wao yahabwela kowavika meso! Nowalongeleni ukweli, mkulu ayo kosaula koti jake, kowalongela wakale hasi muulujo nayo kowasang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wamweda wasang'hanaji waja mkulu wao kowavika wang'hali meso, hata kamba yahabwela kilo kikulu hebu nzogolo zikwika! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lakini mujuwe vino, kamba mwene ng'anda yahajuwile saa ya kwiza mbavi, yahakalile meso, na sambi yaileke ng'anda yake ituligwe na mbavi. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na mweye vivija molondeka mwiitande, kwavija Mwana wa Munhu kokwiza mna isaa hamuigesile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo kamulongela, “Mndewa, vino lusimo luno kutulongela tweye twiiyeka, hebu kuwalongela wanhu wose?” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mndewa kamwidika, “Vino msang'hanaji gani yotamaniligwa na yeli na nzewele? Ayo ija mkulu wake komwika yalolese wasang'hanaji wayagwe, na yawagwee lujo mna isaa inogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kamweda msang'hanaji ija mkulu wake yahabwela komvika kosang'hana vivo! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nowalongela ukweli, mkulu wake komwika msang'hanaji ayo yawe mulolesaji wa vinhu vake vose. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini msang'hanaji ija yahailongela mwenyego, ‘Mkulu wangu kokawa ng'hani kubwela.’ Baho kosonga kuwatowa wasang'hanaji wayagwe, wa kitwanzi na wa kimbigalo, kuno koja na kung'wa mbaka kokoligwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Abaho mkulu wake kobwela mna isiku msang'hanaji ija haigesile na mna isaa haijuwile bule. Mkulu ayo komtowa ng'hani na kumwika hamoja na wanhu hawatogola. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Msang'hanaji ija yajuwile kija kiyolonda mkulu wake yakisang'hane, lakini hakisang'hana bule msang'hanaji ayo kotowigwa ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini msang'hanaji ija hakijuwile kiyolonda mkulu wake, abaho kotenda kinhu kihile, msang'hanaji ayo kotowigwa kidogo. Munhu yagweleligwe vingi kodaigwa vingi, na munhu yagweleligwe vingi ng'hani kodaigwa vingi ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niza kubwinha moto mwiisi, vinondile niye wahakile mwaka! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nina ubatizo nolondigwa niubokele, na niye nougaiya ng'hani mbaka umale! ");
INSERT INTO kdc2014_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Vino mweye mogesa niza kugala tindiwalo mwiisi? Bule! Sizile kugala tindiwalo, lakini kuwagola wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kulawa sambi, wanhu watano wa ng'anda imoja woigola, wadatu kwa wabili, na wabili kwa wadatu. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tata koigola na mwanage, na mwana koigola na tatake. Mama koigola na mndele wake, na mndele koigola na mamake. Mama mkwe koigola na mkwe wake wa kitwanzi, na mkwe wa kitwanzi koigola na mama mkwe wake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu kawalongela wanhu kabili, “Mwahajona wingu dolawilila mwambu wa kudihongela zuwa, baho molonga, ‘Mvula kotowa,’ na kweli kotowa. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na mwahajona beho da kusini nyukwanyukwa molonga, ‘Hokuwa na joto,’ na yokuwa vivo. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mweye mwa wanafiki! Modaha kulola isi na ulanga na kulagula kamba mvula kotowa hebu hatowa, habali hamujuwile fambulo da kipindi kino? ");
INSERT INTO kdc2014_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Habali hamudaha kujuwa wenyego mbuli zinogile za kusang'hana? ");
INSERT INTO kdc2014_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kamba munhu kokugala mkitala, vinoga uilumbe nayo mung'hali mnzila. Wahalemelwa, kokugala kwa msemi, nayo msemi kokugala mmakono ga wakalizi, nao wokugodeka mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nokulongela, mumo humulawa ng'o, mbaka ulipe sente yose!” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kipindi kikija wanhu wayagwe wakala aho, wamulongela Yesu mbuli ya Wagalilaya wakomigwe na Pilato kipindi viwakalile womulavila nhosa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kawedika, “Vino mogesa Wagalilaya awo wakala na nzambi nyingi kubanza Wagalilaya wayagwe lekaavo wadununzika vivo? ");
INSERT INTO kdc2014_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bule! Nowalongela kweli, na mweye vivija mwahalema kuleka nzambi zenu, mose mofa kamba awo. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hebu mogesa wanhu waja longo na wanane wafile kwa kulagaliligwa na lingo ako Siloamu wakala na nzambi nyingi kubanza wanhu wose kudibuga da Yelusalemu? ");
INSERT INTO kdc2014_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bule! Nowalongela, mwahalema kuleka nzambi, mose mofa kamba awo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Abaho Yesu kawalongela lusimo luno, “Munhu imoja kahanda mbiki wa matunda mumgunda wake wa mizabibu. Kachola kuzahila matunda, lakini hapatile tunda jojose bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Avo kamulongela msang'hanaji wake, ‘Lola, mwaka uno wa kadatu nokwiza hano kuzahila matunda mumbiki uno, lakini sipata chochose. Ukanhe! Habali ugendelele kuibananga isi?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lakini msang'hanaji wake kamwidika, ‘Go mkulu, uleke mwaka uno uiyeka, nouhalilila na kuwikila mbolea. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Abaho kamba wahalela yokuwa goya, lakini wahaleka kulela, kodaha kuukanha!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Siku dimoja da Kubwihila, Yesu kakala yofundiza mng'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Baho kukala na mtwanzi imoja. Mtwanzi ayo kakala na kinyamkela yamtendile yalumwe miyaka longo na nane. Kakala yaveduke mgongo na hadahile kuigolosa bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu viyamone, kamkema, kamulongela, “Mama, kuhonyigwa utamu wako!” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu kamwikila makono, bahaja lukuli lwake lugoloka, nayo kamgwaa nhogolwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini mkulu wa ng'anda ya kumpula Mulungu kagevuzika kwavija Yesu kamuhonya munhu mwiisiku ya Kubwihila. Avo kawalongela wanhu, “Mnazo siku sita za kusang'hana. Mzisiku azo, mwize muhonyigwe, lakini sekemwize kudisiku da Kubwihila!” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mndewa kamwidika, “Mweye mwa wanafiki! Vino, nani kumwenu yoleka kumfungula ng'ombe wake hebu mhunda wake kulawa mdizizi na kumulongoza yachole kung'wa mazi mwiisiku ya Kubwihila? ");
INSERT INTO kdc2014_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mtwanzi ino kolawa mulukolo lwa Abulahamu. Nayo kakala yagogigwe na Mwenembago kwa miyaka longo na nane. Vino halondeke kulekesigwa mwiisiku ya Kubwihila?” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mbuli azo ziyalongile Yesu ziwatenda waja wamwihile wagwe kinyala, lakini wanhu wayagwe wakala wodeng'helela kwa mbuli zose za unzonza ziyasang'hane Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Abaho Yesu kawauza, “Vino Undewa wa Mulungu uigala na choni? Vino niusimulile kwa lusimo gani? ");
INSERT INTO kdc2014_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uigala na kija kilawilile kwa munhu yasolile mbeyu ndodo ya haladali na kuihanda mumgunda wake. Mbeyu ayo yota na kuwa mbiki mkulu, na ndege wazenga mvulu zao mna gamatambi gake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu kawauza kabili, “Vino Undewa wa Mulungu uigala na choni? ");
INSERT INTO kdc2014_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uigala na kija kilawilile kwa mtwanzi yasolile mela na kuditibwiliza hamoja na madebe mabili ga usage, abaho usage wose ugongomoka.” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kagendelela na mwanza wake kuchola Yelusalemu, kubitila kuna gamabuga na vijiji kowapetela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munhu imoja kamuuza, “Go mkulu, vino wonda wakomboligwe wanhu wadodo waiyeka?” Yesu kawedika, ");
INSERT INTO kdc2014_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gangamaleni mwingile kubitila ulwivi msisili, kwavija wanhu wengi wolonda kwingila lakini honda wadahe bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwene ng'anda kokwinuka na kuhinda ulwivi. Mweye mokwima kunze na kusonga kugong'onda ulwivi molonga, ‘Mndewa, tuvugulile!’ Nayo kowedika, ‘Sikujuwile kumulawa!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mweye momwidika, ‘Tuja na kung'wa hamoja na gweye, na gweye kutufundiza kudibuga jetu!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini heyo kolonga kabili, ‘Sikujuwile kumulawa! Segeleni kumwangu, mweye mose mutenda nzambi!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Baho molila na kudafuna meno mwahawona Abulahamu na Isaka na Yakobo na watula ndagu wose wa Mulungu muundewa wa Mulungu, kuno mweye wenyego mwasigwa kunze! ");
INSERT INTO kdc2014_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wanhu wokwiza kulawa mwambu wa kudilawila zuwa na mwambu wa kudihongela zuwa, kulawa mwambu wa kasikazini na mwambu wa kusini, wokala hasi muulujo muundewa wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Abaho wanhu waja weli wa ikimambukizo sambi wokuwa wa ichanduso, na waja weli wa ichanduso sambi wokuwa wa ikimambukizo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kipindi kikija Mafalisayo wayagwe wamcholela Yesu, wamulongela, “Segela hanhu hano uchole hanhu hayagwe, kwavija Helode kolonda kukukoma.” ");
INSERT INTO kdc2014_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kawedika, “Gendeni mkamulongele vino ija kizongo, ‘Nolava vinyamkela na kuhonya watamu lelo na mayo, na siku da kadatu nomambukiza sang'hano yangu!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata avo lelo, mayo, na kisindo nogendelela na mwanza wangu, kwavija hailondeka mtula ndagu wa Mulungu yafile kunze ya buga Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Gweye Yelusalemu! Gweye Yelusalemu! Kowakoma watula ndagu wa Mulungu na kuwatowa kwa mabwe waja Mulungu yawatumile kumwako! Miyanza mingapi nilonda kuwahagata wanago kwa makono gangu, kamba vija nguku viyovihagata vinziya vake mna gamabawa gake, lakini hulondile bule! ");
INSERT INTO kdc2014_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sambi lola, Ng'anda yenu ya Mulungu ilekigwa vihame! Na niye nowalongela, hondamumbone kabili mbaka siku dija vondamulonge, ‘Mulungu yamtambikile ija yokwiza kwa twaga da Mndewa!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mwiisiku imoja ya Kubwihila, Yesu kachola kuja lujo mng'anda ya mkulu imoja wa Mafalisayo, wanhu wakala womulola goya Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Munhu imoja yakalile na utamu wa kuvimba lukuli keza kwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu kawauza wafundiza Malagizo ga Musa na Mafalisayo, “Vino, vinoga kumuhonya munhu mwiisiku ya Kubwihila hebu havinogile bule?” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini wao hawalongile mbuli yoyose bule. Yesu kamsola mtamu ija, kamuhonya, abaho kamuleka yachole. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Abaho kawauza, “Vino nani kumwenu yeli na mwana hebu ng'ombe, yahadumbukila mdikolombo mwiisiku ya Kubwihila, hamulava mwiisiku ayo?” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lakini wao hawadahile kumwidika mbuli ino. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu kawona wanhu waja wagonekigwe viwakalile wosagula vigoda va kuulongozi. Avo kawalongela wose lusimo luno, ");
INSERT INTO kdc2014_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Munhu yahakugoneka kuna idizengele, sekeukale mvigoda va haulongozi, kwavija kodaha kwiza munhu yagonekigwe yeli munhu mkulu kubanza gweye, ");
INSERT INTO kdc2014_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na munhu yawagoneke mose wabili kokwizila na kukulongela, ‘Segela aho haukalile umulekele miyago.’ Baho kogwa kinyala mgameso ga wanhu na kobwela kukala kuna ivigoda va kukisogo. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakini wahagonekigwa kuna ulujo, genda ukakale kuna ivigoda va kukisogo, muladi munhu yakugoneke yaheza yakulongele, ‘Mbwigangu, izo ukale kuna ivigoda va haulongozi.’ Baho kopata nhogolwa mgameso ga wanhu wose wagonekigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwavija waja wose woitenda wenyego wanhu wakulu wotendigwa wanhu wadodo, na waja woitenda wenyego wanhu wadodo wotendigwa wanhu wakulu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Abaho Yesu kamulongela ija yamgoneke, “Kamba kowatanda wanhu lujo lwa imisi hebu lwa ichungulo, sekeuwagoneke mbwiga zako, hebu ndugu zako, hebu matajili hebu wanhu welibehi na gweye. Kwavija wahatenda avo, wao nao wokugoneka na avo wokulipa vija viuwatendele wao. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lakini kamba wahatenda nyimwili nyimwili, wagoneke wakiwa,, mbetembete, waholole, na waja wasuwameso, ");
INSERT INTO kdc2014_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na gweye kotambikiligwa, kwavija awo hawadaha kukulipa. Mulungu kokulipa mwiisiku ya kuzilibuligwa kwa wanhu wanogile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Munhu imoja mna iwaja wakalile muulujo viyahulike avo, kamulongela Yesu, “Wamweda waja wonda waje lujo lwa nyimwili nyimwili muundewa wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kamulongela, “Munhu imoja katenda nyimwili nyimwili ng'hulu, kawagoneka wanhu wengi. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Viivikile saa ya nyimwili nyimwili, kamtuma msang'hanaji wake yakawalongele wanhu wagonekigwe weze, kwavija kila kinhu kitandigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakini kila munhu kalava kitala chake. Munhu wa ichanduso kamulongela msang'hanaji ija, ‘Nigula mgunda, avo nolondeka nikaulole. Chonde, ndeka nyhole.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Iyagwe kalonga, ‘Nigula ng'ombe longo wa kulimila, avo vino na muumwanza, nochola kuwageza. Chonde, ndeka nyhole.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iyagwe kalonga, ‘Sambi sambi nisola mwehe, avo sidaha kwiza.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Msang'hanaji ija kabwela na kumulongela mbuli zose zino mkulu wake. Mkulu wake kagevuzika ng'hani, kamulongela msang'hanaji wake, ‘Lopola ugende mzinzila mhanda na mna gamabuga, uwagale hano wanhu wakiwa, waholole, wasuwameso na mbetembete.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bahaja msang'hanaji ija kamulongela, ‘Go mkulu, gago gose gasang'hanigwa, lakini kuna gati disigala.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Avo mkulu ija kamulongela msang'hanaji wake, ‘Lawa kunze uchole mzinzila na mna gamakulugumbi ukawalongele wanhu weze, muladi ng'anda yangu imeme. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nowalongela kweli, kuduhu hata munhu imoja mna iwaja wagonekigwe walemile kwiza yonda yalanze lujo lwangu!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Baho lunhu lwa wanhu vilukalile lomkweleleza, Yesu kahinduka, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Munhu yoyose yokwiza kumwangu na kuno kowanogela ng'hani tatake na mamake na mwehe wake na wanage na lumbu zake na ndugu zake na vivija kamba kounogela ng'hani ugima wake mwenyego kubanza kumnogela Kilisito, hadaha kuwa mwanahina wangu. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na munhu yoyose haupapa msalaba wake na kunikweleleza, hadaha kuwa mwanahina wangu. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Vino nani kumwenu yahalonda kuzenga lingo, tanhu hakala hasi na kugelegeza sente za kudizengela, muladi yajuwe kamba kana sente za kumambukiza sang'hano yake? ");
INSERT INTO kdc2014_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Buleavo, yahamambukiza kuzenga chandusilo, kolemelwa kumambukiza kuzenga dilingo, na wose wachone acho kilawilile womseka, ");
INSERT INTO kdc2014_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wolonga, ‘Munhu ino kasonga kuzenga, lakini kalemelwa kumambukiza sang'hano yake!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Hebu mndewa gani yahaitanda kuchola kuitowa na mndewa iyagwe, tanhu hakala hasi na kugelegeza kamba heyo na wakalizi zake elufu kumi kodaha kuitowa na mndewa miyage yeli na wakalizi elufu ishilini? ");
INSERT INTO kdc2014_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kamba yahona hadaha, kowatuma wasenga zake wakaiting'hane na mndewa iyagwe, wampule wailumbe yang'hali kutali.” ");
INSERT INTO kdc2014_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu kamambukiza kulonga, “Vivo ili kumwenu, kuduhu munhu yodaha kuwa mwanahina wangu mbaka yaleke kila kinhu kiyali nacho. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mkele unoga, lakini wahagiza ukali wake, kuduhu nzila ya kuubweza kabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haufaya kwa isi hebu mna imbolea, lakini wokwasigwa. Yeli na magwiti yahulike!” ");
INSERT INTO kdc2014_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Siku dimoja wabokela kodi wengi na wanhu wayagwe wotenda nzambi wachola kumtegeleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na wafundiza Malagizo ga Musa wasonga kunung'unika, “Munhu ino kowabokela wanhu wotenda nzambi na kuja nao!” ");
INSERT INTO kdc2014_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Avo Yesu kawalongela lusimo luno. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Vino kamba imoja wenu kana ng'hondolo gana, abaho ng'hondolo imoja kapotela, vino kotenda choni? Kowaleka waja malongo tisa na tisa kuluwala, na kuchola kumzahila ija yapotele mbaka yampate. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yahampata, kodeng'helela na kumwika mmaega gake, ");
INSERT INTO kdc2014_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kumgala ukae. Abaho kowakema hamoja mbwiga zake na wanhu weli behi nayo na kowalongela, ‘Miyenu nodeng'helela kwavija nimpata ng'hondolo wangu yapotele. Avo tudeng'helele hamoja!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nowalongela, avo vondaiwe, hokuwa na ndeng'helelo ng'hulu kuulanga mbuli ya munhu imoja mwene nzambi yahaleka nzambi zake, kubanza waja malongo tisa na tisa wogesa wanoga na hawalonda kuzileka nzambi zao.” ");
INSERT INTO kdc2014_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Hebu mtwanzi yeli na sente longo yahagiza imoja, kotendaze? Kobwinha taa, kofagila ng'anda yake, na kulola goya kila hanhu mbaka yaipate. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yahaipata, kowakema hamoja mbwiga zake na wanhu weli behi yake, kowalongela, ‘Nodeng'helela ng'hani kwavija niipata sente yangu ipotele. Avo tudeng'helele hamoja!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Vivija nowalongela, wasenga wa Mulungu wodeng'helela mbuli ya munhu imoja mwene nzambi yahaleka nzambi zake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kagendelela kulonga, “Kukala na munhu imoja yakalile na wana wabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ija imdodo kamulongela tatake, ‘Tata, nigwelele uhazi wangu sambi.’ Avo munhu ija kawagolela uhazi wao wanage awo wabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hazibitile siku nyingi, ija imdodo kachuuza uhazi wake. Abaho kafunga mwanza na sente ziyapatile, kachola isi ya kutali, ako kazinanga sente zose ziyapatile. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kamambukiza kila kinhu kiyakalile nacho. Abaho lufilili lwa nzala lulawilila mwiisi ija, nayo kakala kaduhu kinhu chochose kisigale. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Avo kachola kusang'hana kibaluwa kwa munhu imoja wa isi ija, munhu ayo kamtuma mumgunda wake yasusile nguluwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kakala kosulukila kuja maganda gawadile nguluwe, lakini kuduhu munhu yamgwelele kinhu chochose cha kuja. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Abaho kagelegeza na kulonga, ‘Tatangu kana wasang'hanaji wengi, woja mbaka wosigaza na niye hano nofa na nzala! ");
INSERT INTO kdc2014_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nosegela na kuchola kwa tatangu na kumulongela, Tata, nimtenda Mulungu nzambi, na vivija nikutendela gweye nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sifaya kukemigwa mwanago. Nhende kamba imoja wa wasang'hanaji zako.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Avo kafunga mwanza wa kubwela kwa tatake. “Viyakalile yang'hali kutali, tatake kamona. Kamonela bazi mwanage, avo kamkimbilila, kamuhagatila na kamnonela. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwanage kamulongela, ‘Tata, nimtenda Mulungu nzambi, na vivija nikutendela gweye. Sifaya kukemigwa mwanago.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lakini tatake kawakema wasang'hanaji zake. Kawalongela, ‘Lopoleni! Galeni kiwalo kinogile mumvaze. Mvazeni pete mkidole chake na vilatu mmagulu gake. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Abaho choleni mumgale bofu da ng'ombe dinonile mudichinje, wose tuje na kudeng'helela! ");
INSERT INTO kdc2014_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwavija mwanangu ino kakala yafile lakini sambi mgima. Kakala yapotele lakini sambi koneka.’ Avo wasonga kudeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kipindi acho mwanage imkulu kakala kumgunda. Viyakalile behi na ing'anda, kahulika nyila na wanhu wovina. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Avo kamkema msang'hanaji imoja, kamuuza, ‘Ako kuna choni?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Msang'hanaji ayo kamwidika, ‘Mdodo wako kabwela ukae, na tatako kamchinjila bofu da ng'ombe dinonile, kwavija kabwela mgima!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ija imwana mkulu kagevuzika ng'hani, avo kalema kwingila mng'anda. Tatake kalawa kunze na kumpula yengile mng'anda. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lakini kamwidika tatake, ‘Lola, miyaka yose ino niye nokusang'hanila kamba msang'hanaji, na silemile lagizo jako jojose. Kungwaa choni? Hunigwelele hata mbuzi nideng'helele na mbwiga zangu! ");
INSERT INTO kdc2014_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini mwanago ino kananga vinhu vako mbuli ya ugoni, na viyabwelile ukae kumchinjila bofu da ng'ombe dinonile!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tatake kamwidika, ‘Mwanangu, kipindi chose kukala na niye, na vinhu vose vinilinavo vako. ");
INSERT INTO kdc2014_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lakini tulondeka tudeng'helele na kusekelela, kwavija mdodo wako kakala yafile lakini sambi mgima, kakala yapotele lakini sambi koneka!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kawalongela wanahina zake, “Kukala na tajili imoja yakalile na mulolesaji wa vinhu vake. Tajili ayo kalongeligwa kamba mulolesaji ayo konanga sente zake. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Avo kamkema mng'anda, kamuuza, ‘Mbuli gani zimhulika kumwako? Mhetela vinhu vose viubokele na vija viulavile, kwavija hudaha kuwa mulolesaji wa vinhu vangu kabili.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mulolesaji ija kailongela, ‘Mkulu wangu konilekesa usang'hano. Notenda choni? Kulima sidahile bule, na kupula nokona kinyala. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sambi nojuwa choni chonda nhende muladi nahalavigwa mna isang'hano, niwe na mbwiga wa kunibokela mzikae zao!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Avo kawakema wanhu wose wakalile wodaigwa na mkulu wake. Kamuuza wa ichanduso, ‘Kodaigwa choni na mkulu wangu?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nayo kamwidika, ‘Madebe gana ga mavuta.’ Mulolesaji ija kamulongela, ‘Sola cheti chako, kala hasi, lopola wandike malongo matano.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Abaho kamuuza iyagwe, ‘Na gweye kodaigwa choni?’ Nayo kamwidika, ‘Viloba gana va ngano.’ Mulolesaji ija kamulongela, ‘Sola cheti chako, wandike malongo nane.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mkulu wa ija mulolesaji mbala kamtogola kwavija katenda vinhu kwa ubala. Kwavija wanhu wa mwiisi ino wabala ng'hani mna zimbuli zao kubanza wanhu wa kumulenge.” ");
INSERT INTO kdc2014_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu kagendelela kulonga, “Avo nowalongeleni, itendeleni umbwiga kubitila vinhu va mwiisi, muladi vahamala mudahe kubokeligwa kuna ikae ya ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Munhu yoyose yotamaniligwa mna ivinhu vidodo, kotamaniligwa mna ivinhu vikulu. Na munhu yoyose hatamaniligwa mna ivinhu vidodo, vivija hatamaniligwa mna ivinhu vikulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Avo kamba mweye hamutamaniligwa kulolesa mali za mwiisi, modahaze kutamaniligwa kulolesa mali za kuulanga? ");
INSERT INTO kdc2014_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kamba hutamaniligwa kulolesa vinhu va munhu iyagwe, nani yonda yakugwee vinhu vako mwenyego? ");
INSERT INTO kdc2014_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kuduhu msang'hanaji yodaha kuwasang'hanila wakulu wabili. Kwavija komwihila imoja na kumnogela iyagwe, hebu koilumba na imoja na kumbeza iyagwe. Hamudaha kumsang'hanila Mulungu hamoja na mali.” ");
INSERT INTO kdc2014_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayo viwazihulike mbuli zino zose, wamzeha Yesu, kwavija wakala wanogelwa na sente. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu kawalongela, “Mweye awo wanhu muitenda munoga mgameso ga wanhu, lakini Mulungu kaijuwa mizoyo yenu. Kwavija vinhu vikoneka vinoga ng'hani kwa wanhu, mgameso ga Mulungu vokoneka viha. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malagizo ga Musa na maandiko ga watula ndagu wa Mulungu vikala vipetigwa mbaka kipindi cha Yohana Mbatizaji. Kusongela aho, Mbuli Inogile ya Undewa wa Mulungu yopetigwa, na kila munhu kowamba kokwingila. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini vibuha ng'hani kwa ulanga na isi kupotela, kubanza kinhu kidodo ng'hani kupotela mna Gamalagizo. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mbigalo yoyose yomwasa mwehe wake na kusola mtwanzi iyagwe, kotenda ugoni. Na mbigalo yomsola mtwanzi ija yasigwe, nayo kotenda ugoni vivija. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kukala na tajili imoja yavalile viwalo va sente nyingi ng'hani na kuja goya kila siku. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vivija kukala na munhu imoja mkiwa yakemigwe Lazalo, kamema vilonda lukuli lose, kakala yokwikigwa muulwivi lwa tajili ija. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalo kakala yosulukila kuja vilagale muimeza ya tajili ayo. Na umbwa wakala wokwiza na kumulambita mvilonda vake. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Abaho mkiwa ija kafa na kasoligwa na wasenga wa kuulanga mbaka behi ya Abulahamu. Tajili ayo nayo kafa na kazikigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ako kowochola wanhu wafile, kakala kodununzika ng'hani. Kenula meso gake, kamona Abulahamu kwa kutali na Lazalo kakala behi yake. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Avo kamkema kwa sauti ng'hulu, ‘Tata Abulahamu! Nyonele bazi! Mtume Lazalo yazabike kidole chake mgamazi, yaluhoze lulimi lwangu, kwavija nogaya ng'hani muumoto uno!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lakini Abulahamu kamulongela, ‘Mwanangu, kumbuka muugima wako kubokela vinhu vinogile, nayo Lazalo kabokela vihile. Lakini sambi Lazalo kobwihila, na gweye kodununzika. ");
INSERT INTO kdc2014_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hata avo, hagati yetu tweye na mweye hekigwa kolombo kulu, muladi munhu yolonda kuloka kulawa kuno kwiza kumwenu sekeyadahe, hebu munhu yoyose kulawa kumwenu sekeyaloke kwiza kumwetu!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tajili ija kalonga, ‘Nokupula gweye, tata Abulahamu, umtume Lazalo kuna ikae ya tatangu, ");
INSERT INTO kdc2014_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ako kuna ndugu zangu watano. Muleke yachole yakawazume muladi sekeweze hanhu hano ha kudununzika!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abulahamu kalonga, ‘Ndugu zako wanago maandiko ga Musa na ga watula ndagu wa Mulungu ga kuwazuma. Wawategeleze wao kiwolonga!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tajili ija kamwidika, ‘Bule tata Abulahamu! Lakini kamba munhu yahazilibuka kulawa kwa wafile na kuwacholela, baho wozileka nzambi zao!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lakini Abulahamu kamulongela, ‘Kamba hawagagoga maandiko ga Musa na watula ndagu wa Mulungu, honda wategeleze hata kamba munhu yahazilibuka kulawa kwa wafile!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu kawalongela wanahina zake, “Vinhu vondaviwatende wanhu watende nzambi volawilila, lakini kogaya munhu ija yovitenda vilawilile! ");
INSERT INTO kdc2014_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yokuwa vinoga kwa munhu ayo yagodekigwe dibwe kulu da kudugila msingo na yasigwe mbahali, kubanza kumuhonza imoja wa wadodo wano yatende nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Avo iteganyeni! “Ndugu yako yahakutendela nzambi, umzume. Yahatogola, gela kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yahakutendela nzambi miyanza saba kwa siku dimoja, na kila yaheza kumwako kolonga, ‘Ng'hosa,’ kolondeka ugele kumgongo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Watumigwa wamulongela Mndewa, “Twengezele tamanilo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mndewa kawedika, “Maza tamanilo jenu dahakuwile dodo kamba mbeyu ndodo ya haladali, mwahadahile kuulongela mbiki uno wa mkuyu, ‘Ng'oka ukaihande mbahali!’ nao wahawatogolele. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Vino nani kumwenu yeli na msang'hanaji yomulimila hebu kosusila ng'hondolo, yahabwela kumgunda, komulongela yalopole kuja lujo lwake? ");
INSERT INTO kdc2014_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bule. Lakini komulongela, ‘Uitande, nitandile lujo lwangu, unisang'hanile mbaka ng'homeleze kuja na kung'wa, abaho na gweye koja na kung'wa.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Vino komgwaa nhogolwa msang'hanaji ayo kwavija kasang'hana gaja galagilizigwe? ");
INSERT INTO kdc2014_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vivo ili kumwenu mweye, mwahatenda vose vimulagilizigwe, longeni, ‘Tweye twa wasang'hanaji wadodo, tusang'hana kija kitulondigwe kusang'hana!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu viyakalile mnzila kochola Yelusalemu, kabitila mzimbaka za vijiji va Samalia na Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Viyakalile kokwingila mna ikijiji kimoja, mumo kukala na wanhu longo wakalile na utamu wa dikulu, wemile kutali. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Waguta, “Go mkulu! Yesu! Tonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu kawona, kawalongela, “Gendeni mkailaguse kwa walava nhosa.” Viwakalile mnzila wochola, wahona. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Imoja wao viyone kahona, kabweleganya kwa Yesu kuno komgwaa nhogolwa Mulungu kwa sauti ng'hulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kamgwila Yesu mmagulu kingubanguba, kamtogola. Munhu ayo kakala Msamalia. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kalonga, “Vino hawakalile wanhu longo wahonyigwe? Wayagwe tisa wa kwahi? ");
INSERT INTO kdc2014_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Vino kuduhu iyagwe yabwelile kumgwaa nhogolwa Mulungu, ila munhu ino hali muyahudi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Abaho Yesu kamulongela munhu ija, “Ima na uchole. Kutamanila kwako kukuhonya.” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayo wayagwe wamuuza Yesu Undewa wa Mulungu vondawize. Yesu kawedika, “Undewa wa Mulungu hawiza kwa kukoneka kwa meso. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuduhu munhu yonda yalonge, ‘Lola, uno hano!’ hebu ‘Uja haja!’ Kwavija Undewa wa Mulungu wa mgati mmwenu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Abaho kawalongela wanahina zake, “Kipindi chokwiza vonda mulonde kuyona siku imoja mwiizisiku za Mwana wa Munhu, lakini hondamuyone bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Baho wanhu wowalongela, ‘Loleni kakuja!’ hebu ‘Loleni, kahano!’ Sekemuwakweleleze. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwavija kamba vija lumwesa vilulawilila kuulanga na kumwemwesa kulawa mwambu umoja mbaka mwambu uyagwe, vivo vondayawe Mwana wa Munhu mwiisiku yake. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini tanhu kolondeka yadununzike ng'hani na kulemigwa na wanhu wa lukolo luno. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamba viikalile mna ikipindi cha Nuhu, vivo vondaiwe mzisiku za Mwana wa Munhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kila munhu kakala koja na kung'wa, kusola na kusoligwa mbaka siku ija Nuhu viyengile mdisafina. Mvula ng'hulu itowa na kuwakoma wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Vivija kamba viilawilile mna ikipindi cha Lutu. Wanhu wagendelela kuja na kung'wa, kugula na kuchuuza, kuhanda na kuzenga. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini siku ija Lutu viyasegele Sodoma, moto na mabwe gokwaka vilagala hasi na kuwakoma wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vivo vondaiwe mwiisiku Mwana wa Munhu vonda yagubuligwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mwiisiku ayo, munhu yeli mkiswili cha ng'anda yake sekeyahumuluke mng'anda kusola vinhu vake, vivija munhu yeli kumgunda sekeyabwele ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukeni gampatile mwehe wake Lutu. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munhu yoyose yolonda kuukombola ugima wake mwenyego, kowagiza, na yoyose yowagiza ugima wake, koukombola. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nowalongela, kilo acho wanhu wabili wawasile mulusazi lumoja, imoja kosoligwa na iyagwe kolekigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Watwanzi wabili woduga sembe hamoja, imoja kosoligwa na iyagwe kolekigwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wanhu wabili wokuwa kumgunda, imoja kosoligwa na iyagwe kolekigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wanahina zake wamuuza, “Vino, kwahi Mndewa?” Yesu kawedika, “Kokose kuli na mzoga, baho honda waiting'hane mhungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Abaho Yesu kawafundiza wanahina zake kwa lusimo kamba siku zose wolondeka kumpula Mulungu na sekewadonhe. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kalonga, “Kudibuga dimoja kukala na msemi yakalile hamdumba Mulungu hebu kuwatonga wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Vivija kudibuga dijo, kukala na mgane imoja yakalile komgendela msemi ayo baho kwa baho, kampula, ‘Ngwelele haki yangu kulawa kwa munhu yanitendele gehile.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Siku nyingi msemi ayo hamtegeleze mgane ayo, lakini kumwande kailongela, ‘Hata kamba simdumba Mulungu hebu kuwatonga wanhu, ");
INSERT INTO kdc2014_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kwavija mgane ino konigaza, nomgwaa haki yake, kwavija nahaleka, kogendelela kwiza hano na kunigaza!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Abaho Mndewa kagendelela kulonga, “Tegelezeni kiyalongile msemi ija yehile. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Vino, Mulungu honda yawagwee haki wanhu zake yawasagule, womulilila imisi na ikilo? Vino kokawa kuwategeleza? ");
INSERT INTO kdc2014_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nowalongela, kowagwaa haki yao himahima. Lakini Mwana wa Munhu vondayeze, vino kodivika tamanilo mwiisi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Abaho Yesu kawalongela lusimo luno wanhu waja wakalile woitapa wanoga na kuwabeza wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kukala na wanhu wabili wacholile kumpula Mulungu kuna Ing'anda ya Mulungu. Imoja kakala Mfalisayo na iyagwe kakala mbokela kodi. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Mfalisayo ayo kainega kumgwazo na kumpula Mulungu, ‘Go Mulungu, nokugwaa nhogolwa kwavija niye sili kamba wanhu wayagwe, wabokaji, wotenda gehile, hebu wagoni. Wala sili kamba ino mbokela kodi. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Niye nofunga kuja miyanza mibili mzisiku saba, na nolava fungu da longo da vinhu vangu vose vinipata!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lakini ija mbokela kodi kema kutali, hadahile hata kwinula meso gake kuulanga, lakini kaitowa mhambaga yake kwa usungu, kalonga, ‘Go Mulungu, nyonele bazi, niye notenda nzambi!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nowalongela, mbokela kodi ija kachola ukayake kuno katendigwa kanoga mgameso Mulungu kubanza ija Mfalisayo. Kwavija wose woitenda wanhu wakulu wohumulusigwa, na waja woihumulusa wotendigwa wanhu wakulu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wanhu wayagwe wamgalila Yesu wana wadodo yawekile makono. Wanahina viwone avo, wawakomhokela. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu kawakema iwana, kalonga, “Walekeni wana wadodo weze kumwangu, sekemuwagomese, kwavija Undewa wa Mulungu wa wanhu kamba wano. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nowalongeleni ukweli! Munhu yoyose yolema kuubokela Undewa wa Mulungu kamba mwana mdodo, honda yengile ng'o!” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkulu imoja kamuuza Yesu, “Mfundiza Unogile, nhende choni niupate ugima wa mazuwa gose?” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kamuuza, “Habali kong'hema, ‘unogile’? Kuduhu yanogile, ila Mulungu yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kugajuwa Malagizo, ‘Sekeutende ugoni, sekeukome, sekewibe, sekeulonge uvizi, wategeleze tatako na mamako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Munhu ija kedika, “Gago gose nigagoga toka haudodo.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu viyahulike avo, kamulongela, “Kuhungukiligwa na kinhu kimoja. Chuuza vose viulinavo, uwagwee sente wanhu wakiwa, na gweye kokuwa na ngama yako kuulanga. Abaho wize unikweleleze.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini munhu ayo viyahulike avo, kanyunyuwala kwavija kakala tajili ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu viyamone kanyunyuwala, kalonga, “Vino avo vonda iwe vidala kwa wanhu matajili kwingila Muundewa wa Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kwavija vibuha kwa ngamiya kubita mna ikizonzo cha sanzia, kubanza tajili kwingila muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wanhu wamuhulike, wamuuza, “Avo lelo nani yonda yadahe kukomboligwa?” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kawedika, “Vinhu havidahika kwa wanhu, kwa Mulungu vodahika.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Abaho Petulo kalonga, “Lola! Tweye tuvileka vinhu vetu vose, tukukweleleza gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kawalongela, “Nowalongela kweli, munhu yoyose yoleka kae yake hebu mwehe wake hebu ndugu zake hebu tatake na mamake hebu wanage mbuli ya Undewa wa Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kobokela vinhu vingi ng'hani mna ikipindi kino na kobokela ugima wa mazuwa gose mna ikipindi chonda kize.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kawagala hamgwazo wanahina zake longo na wabili, kawalongela, “Tegelezeni! Tochola Yelusalemu. Kuko kila kinhu chandikigwe na watula ndagu wa Mulungu mbuli ya Mwana wa Munhu cholawilila. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwavija kogeligwa mmakono ga wanhu haweli Wayahudi, nao womzeha, womuliga, na womtemela mate. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Womtowa mbalati na kumkoma, lakini siku da kadatu kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lakini wanahina hawazijuwile bule mbuli azo, kwavija wakala wafisigwe na hawakijuwile kija kiyakalile yokilonga Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu viyakalile behi na kuvika Yeliko, munhu imoja yakalile msuwameso kakala hamgwazo mnzila, kopula. ");
INSERT INTO kdc2014_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Munhu ayo viyahulike lunhu lwa wanhu lobita, kauza, “Kuna choni?” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wanhu wamulongela, “Yesu wa Nazaleti kobita.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nayo kakemelela, “Yesu! Mwana wa Daudi! Nyonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wanhu walongole wamkomhokela, wamulongela yanyamale. Lakini heyo kagendelela kukemelela ng'hani, “Mwana wa Daudi! Nyonele bazi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Avo Yesu kema, kalagiza munhu ija yagaligwe kumwake. Viyavikile behi, Yesu kamuuza, ");
INSERT INTO kdc2014_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kolonda nikutendele choni?” Nayo kamwidika, “Go mkulu, nolonda kulola.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kamulongela, “Lola! Kutamanila kwako kukuhonya.” ");
INSERT INTO kdc2014_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bahaja munhu ija kadaha kulola, kamkweleleza Yesu kuno komgwaa nhogolwa Mulungu. Wanhu wose viwone avo, wamgwaa nhogolwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kachola kudibuga da Yeliko, na kakala yobita mzinzila za buga dijo. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kuko kukala na mkulu imoja wa wabokela kodi yakemigwe Zakayo, nayo kakala tajili. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kakala kolonda kumona Yesu, lakini hadahile mbuli ya lunhu lwa wanhu na kwavija kakala mguhi. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Avo kakimbila haulongozi wa lunhu luja, kakwela mumbiki wa mkuyu muladi yamone Yesu, yakalile yochola kubitila nzila ija. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu viyavikile hanhu aho, kalola uchanha, kamulongela, “Zakayo, himahima humuluka hasi, kwavija lelo nolondeka kukala mng'anda yako.” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo kahumuluka himahima, kamgoneka Yesu kwa kudeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wanhu wose wagone ago, wasonga kunung'unika, walonga, “Munhu ino kachola kukala mng'anda ya munhu mwene nzambi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo kema, kamulongela Yesu, “Go Mkulu, tegeleza! Nowagwaa wakiwa nusu ya vinhu vangu, na kamba nimboka munhu yoyose kinhu, nombwezela miyanza mine.” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kamulongela, “Lelo ukombozi uvika kwa wanhu wa lubuga luno, kwavija munhu ino nayo kolawa mulukolo lwa Abulahamu. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwavija Mwana wa Munhu keza kuwazahila na kuwakombola waja wapotele.” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wanhu viwakalile wotegeleza gago, Yesu kagendelela kuwalongela lusimo. Baho kakala mmabehi na Yelusalemu, nao wagesa kamba Undewa wa Mulungu wa mmabehi kulawilila. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Avo kawalongela, “Kukala na munhu imoja wa lukolo lwa kindewa yafungile mwanza kuchola isi ya kutali yakatendigwe mndewa, abaho yabwele ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Avo yang'hali hanasegela, kawakema wasang'hanaji zake longo, kila imoja kamgwaa sente sawa, abaho kawalongela, ‘Tendeni biashala mbaka vondambwele.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini wanhu wa isi yake wakala wamwihile. Avo wawatuma wasenga wagende kwa wanhu waja wakalonge, ‘Hatumulonda munhu ino yawe mndewa wetu.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Munhu ija kaupata undewa, kabwela ukayake. Baho kawalagiza wasang'hanaji zake yawagwelele sente wachole kumwake yapate kujuwa kija kiwapatile. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Msang'hanaji wa ichanduso keza, kalonga, ‘Go mkulu, sente zako ziunigwelele zilela miyanza longo.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kamulongela, ‘Kutenda goya msang'hanaji unogile! Kwavija kutenda vinogile kulolesa mna ivinhu vidodo, nokutenda uwe munhu mkulu wa mabuga longo.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Msang'hanaji wa kabili keza, kalonga, ‘Go mkulu, sente zako ziunigwelele zilela miyanza mitano.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nayo kamulongela, ‘Kokuwa munhu mkulu wa mabuga matano.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Msang'hanaji iyagwe keza, kalonga, ‘Go mkulu, sola sente zako. Nikala nizifungile goya mkikumbi. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nikudumba, kwavija kuna gahigahi. Kosola vinhu va wayago kwa uvizi na kosenga vija huvihandile.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mkulu ija kamulongela, ‘Gweye kwa msang'hanaji yehile! Nokutagusa kwa mbuli zako mwenyego! Kunijuwa nina gahigahi, nisolaga vinhu va wayangu na kusenga vija sivihandile. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Habali huzikile sente zangu kwa wanhu wokwika sente muladi vimbwelile nyambulile zongezeke?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Abaho kawalongela waja wemile aho, ‘Mbokeni ayo zisente, mumgwelele msang'hanaji ija yapatile sente miyanza longo ya zija ziyagweleligwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lakini wao wamulongela, ‘Go mkulu, lakini heyo kanazo sente miyanza longo!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nayo kawedika, ‘Munhu yeli na kinhu kokongezelwa, lakini ija yeliduhu kinhu, kobokigwa hata kija kidodo kiyelinacho. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na sambi, waja wanihile, wondema niye niwe mndewa wao, wagaleni hano, muwakome bahano mgameso gangu!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu viyamambukize kulonga avo, kawalongolela kuchola Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Viyakalile behi na kuvika Betifage na Betania, habehi na Lugongo lwa Mizeituni, kawatuma wanahina zake wabili, ");
INSERT INTO kdc2014_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kawalongela, “Gendeni kuna ikijiji kili kuulongozi wenu. Mwahengila, momvika mwana mhunda kafungigwa, nayo yang'hali hanakweligwa na munhu. Mfunguleni mumgale hano. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Munhu yoyose yahawauza habali momfungula, mulongeleni, ‘Mndewa komulonda.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wanahina waja wachola, wamvika kamba vija Yesu viyawalongele. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Viwakalile womfungula imwana mhunda, wenyego wawauza, “Habali momfungula?” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nao wawedika, “Mndewa komulonda.” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wamgala imwana mhunda kwa Yesu. Abaho watandika viwalo vao mumgongo wa imwana mhunda, na wamtaza Yesu kukwela. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu viyakalile kochola, wanhu wanzanza viwalo vao mnzila. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Viyakalile behi na kuvika Yelusalemu, hanhu hali na mtelemuko wa Lugongo lwa Mizeituni, lunhu mkulu lwa wanahina zake lusonga kudeng'helela na kumgwaa nhogolwa Mulungu kwa sauti ng'hulu mbuli ya unzonza wauwonile. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Walonga, “Mulungu yamtambikile Mndewa yokwiza kwa twaga da Mulungu, tindiwalo kuulanga na ukulu kwa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baho Mafalisayo wayagwe wakalile muulunhu wamulongela Yesu, “Mfundiza, walagize wanahina zako wanyamale!” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kawedika, “Nowalongeleni, wahanyamala wano, mabwe goguta.” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu viyavikile behi na buga da Yelusalemu na viyawone wanhu wa buga dijo, kawalilila, ");
INSERT INTO kdc2014_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kalonga, “Maza lelo mwahajuwile mbuli zilondeka kugala tindiwalo! Lakini sambi zifisigwa mgameso genu! ");
INSERT INTO kdc2014_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwavija kipindi chokwiza, wanhu wakwihile vonda wakuzengele luwa, wokuzunguluka na kukusung'ha sung'ha kila mwambu. ");
INSERT INTO kdc2014_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wokuhondahonda gweye na wanhu zako weli muuluwa wako. Kuduhu hata dibwe dimoja donda disigazigwe uchanha ya diyagwe, kwavija hukijuwile kipindi kiyezile Mulungu kukukombola!” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Abaho Yesu kengila Mng'anda ya Mulungu, kasonga kuwawinga wanhu wakalile wochuuza vinhu, ");
INSERT INTO kdc2014_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kawalongela, “Yandikigwa mna Gamaandiko Gang'alile, Mulungu kalonga, ‘Ng'anda yangu yokuwa ng'anda ya kupulila.’ Lakini mweye muitenda mhango ya wabavi!” ");
INSERT INTO kdc2014_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila siku Yesu kakala kofundiza Mng'anda ya Mulungu. Wakulu wa walava nhosa, wafundiza Malagizo ga Musa, na walangulizi wa wanhu walonda kumkoma, ");
INSERT INTO kdc2014_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lakini hawadahile bule kutenda avo, kwavija wanhu wose wakala womtegeleza goya, hawalondile kuswela mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Siku dimoja Yesu kakala Mng'anda ya Mulungu kowafundiza wanhu na kuwapetela Mbuli Inogile. Wakulu wa walava nhosa na wafundiza Malagizo ga Musa hamoja na wavele weza, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wamulongela, “Tulongele, vino kotenda mbuli zino kwa udahi wa nani? Nani yakugwelele udahi uno?” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kawedika, “Beteni na niye niwauze mbuli imoja. Nongeleni, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","vino udahi wa Yohana wa kubatiza ulawa kuulanga hebu kwa wanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wagesa, “Tulonge choni? Twahalonga, ‘Ulawa kuulanga,’ kotuuza, ‘Habali, hamumtogole Yohana?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na twahalonga, ‘Ulawa kwa wanhu,’ lunhu lose luno lotutowa mabwe, kwavija wose wotogola kamba Yohana kakala mtula ndagu wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Avo wamwidika, “Hatujuwile kuulawile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu kawalongela, “Na niye siwalongela bule notenda mbuli zino kwa udahi wa nani.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Abaho Yesu kawalongela wanhu lusimo luno, “Kukala na munhu imoja yahandile mizabibu mumgunda wake. Kawakodisha walimaji, abaho kachola mwiisi iyagwe na kakala siku nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Msimu wa kubawa zabibu viuvikile, munhu ija kamtuma msang'hanaji wake yachole kwa walimaji wamgwelele zabibu. Lakini walimaji waja wamtowa msang'hanaji ija, wamuwinga makono gaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Avo kamtuma msang'hanaji iyagwe, lakini walimaji wamtowa vivija na kumuliga, wamuwinga makono gaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Abaho kamtuma msang'hanaji wa kadatu. Ino nayo walimaji wamulumiza, wamwasa kunze. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Abaho mwene mgunda ija kalonga, ‘Nhende choni? Nomtuma mwanangu nimnogele. Lamda ino womtegeleza!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakini walimaji viwamone, wailongela, ‘Ino ayo muhazi wake. Tumkome na uhazi wake wokuwa wetu.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Avo wamulava kunze ya mgunda uja, wamkoma.” Yesu kawauza, “Vino, mwene mgunda kowatenda choni waja walimaji? ");
INSERT INTO kdc2014_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kokwiza na kuwakoma walimaji wose awo na kowakodisha walimaji wayagwe mgunda awo wa mizabibu.” Wanhu viwahulike mbuli ayo, walonga, “Bule! Sekeilawilile avo!” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu kawalola, kawauza, “Vino, ulonzi uno fambulo jake choni? ‘Dibwe wadilemile wazengaji kamba hadifaya, digalamuka dibwe kulu da kutamanila kubanza gose!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Munhu yoyose yonda yaikwale mdibwe ajo kobeneka beneka munhu donda dimulagalile domuhonda tipitipi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wafundiza Malagizo ga Musa na wakulu wa walava nhosa wajuwa kamba lusimo ulo kakala kowafumbila wao. Avo bahaja walonda kumgoga Yesu, lakini wawadumba wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Avo wazahila kipindi kinogile. Wawahonga wanhu wayagwe waitende wanoga, wawatuma wamgeze Yesu kwa kumuuza, muladi wadahe kumgoga na kumgala kwa mkulu wa Lumi. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wanhu awo wamulongela Yesu, “Mfundiza, tokujuwa gweye kofundiza na kulonga ukweli, wala hutonga ukulu wa munhu, lakini kofundiza nzila za Mulungu mna ikweli. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tulongele, vino vinoga kulipa kodi kwa mndewa mkulu wa Lumi hebu havinogile bule?” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lakini Yesu kaujuwa mwaka ubala wao, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ndagusileni isente. Vino, kihanga kino na twaga dino va nani?” Wamwidika, “Va mndewa mkulu wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu kawalongela, “Vinoga. Vinhu va mndewa wa Lumi mgweleleni mndewa wa Lumi, na va Mulungu mgweleleni Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Avo, mgameso ga wanhu hawadahile kumgoga kwa mbuli yoyose. Wakanganya ulonzi wake, wanyamala huupi. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Abaho Masadukayo, wanhu wolonga kamba kuduhu kuzilibuka kulawa kwa wafile. Wayagwe wamcholela Yesu, wamulongela, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mfundiza, Musa katwandikila, ‘Munhu yahafa na kuleka mwehe wake bila wana, ndugu yake munhu ayo kolondeka yamsole imgane, yamulelele ndugu yake yafile wana.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kukala na ndugu saba. Ija imkulu kasola mwehe, lakini kafa bila kulela wana. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wakabili kamsola mtwanzi ija, lakini nayo kafa bila wana. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Abaho wa kadatu kamsola. Vivo ilawilile kwa wose saba wamsola, lakini wafa bila wana. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kukimambukizo, mtwanzi ija nayo kafa. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lelo mwiisiku ya kuzilibuka, mtwanzi ayo kokuwa mwehe wa nani? Kwavija kakala yasoligwe na wose saba.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kawedika, “Wanhu wa mwiisi ino wosola na kusoligwa, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lakini waja wasaguligwe kuzilibuka kulawa kwa wafile na kuupata ugima wondawize, hawasola hebu kusoligwa. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Woigala na wasenga wa kuulanga, na hondawafe bule. Wao ni wana wa Mulungu kwavija wazilibuka kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini kwa mbuli ya kuzilibuka kwa wanhu wafile, hata Musa kalagusa avo mna imbuli ya ikisolo kikwaka baho kamkema Mndewa, ‘Mulungu wa Abulahamu na Mulungu wa Isaka na Mulungu wa Yakobo.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Heyo ni Mulungu wa wanhu wagima, siyo wa wanhu wafile. Kwavija kumwake heyo wose wagima.” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wafundiza Malagizo ga Musa wayagwe walonga, “Mfundiza, kulonga goya!” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Avo hawadahile kumuuza mbuli ziyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu kawauza, “Vino habali wanhu wolonga kamba Kilisito Mkombola kolawa mulukolo lwa Daudi? ");
INSERT INTO kdc2014_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kwavija Daudi mwenyego kolonga mna ikitabu cha Zabuli, ‘Mndewa Mulungu kamulongela Mndewa wangu, Kala hano mwambu wangu wa mkono wa kudila, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mbaka niwahume wanhu wakwihile na niweke hasi mmagulu gako.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi mwenyego kamkema ‘Mndewa.’ Yodahika vilihi Kilisito Mkombola yalawe mulukolo lwa Daudi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wanhu wose viwakalile womtegeleza, Yesu kawalongela wanahina zake, ");
INSERT INTO kdc2014_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Muiteganye na wafundiza Malagizo ga Musa. Wao wonogelwa kwanga kuno wavala mikanzu mitali, na kulamusigwa na wanhu mna gamagulilo na kukala mna ivigoda va haulongozi mzing'anda za kumpula Mulungu na mna izinyimwili nyimwili. ");
INSERT INTO kdc2014_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wowonela wagane kwa kusola vinhu vao, na kuitenda wanoga kwa kumpula Mulungu kwa kulonga mbuli nyingi! Awo nhaguso yao yobanza ng'hani!” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kenula meso gake kawona matajili viwogela nhunza zao mkigelo cha kulavila nhuza. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Abaho kamona mgane mkiwa imoja kagela sente mbili ndodo. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu kalonga, “Nowalongela ukweli, mgane ino kalava kinhu kikulu kubanza wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwavija matajili walava vija visigale muutajili wao, lakini mgane ino hamoja na ukiwa wake, kalava vose viyotamanila muugima wake.” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wanahina wayagwe wakala wolonga mbuli ya Ng'anda ya Mulungu, viizengigwe kwa mabwe ganogile na sadaka za wanhu zilavigwe kwa Mulungu. Lakini Yesu kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mogona gano gose! Siku yokwiza kuduhu dibwe dondadisigale uchanha ya diyagwe, mabwe gose gobomoligwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wamuuza, “Mfundiza, vinhu avo volawilila lini? Choni chondakitendeke kulagusa kipindi cha kulawilila vinhu avo cha mmabehi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kawedika, “Muiteganye, munhu sekeyawavizile. Kwavija wanhu wengi wokwiza kwa twaga jangu, na kulonga, ‘Niye ayo Kilisito!’ na ‘Kipindi cha mmabehi!’ Lakini sekemuwakweleleze. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mwahahulika ng'hondo na zumozumo, sekemudumbe, kwavija vinhu avo volondeka tanhu vilawilile, lakini kimambukizo king'hali hakinavika.” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu kagendelela kulonga, “Wanhu wa isi imoja woitowa na wanhu wa isi iyagwe, undewa umoja woitowa na undewa uyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kila hanhu hokuwa na migudemo mikulu ya isi, lufilili lwa nzala na mitamu, volawilila vinhu va kugela bwembwe na vilaguso kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakini gang'hali haganalawila gano gose, mogogigwa na kudununzigwa. Mogaligwa mzing'anda za kumpula Mulungu na kuwagodeka mkifungo, mogaligwa haulongozi wa wandewa na wakulu wa isi mbuli ya twaga jangu. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kino chokuwa kipindi chenu kinogile cha kuwapetela wanhu Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gangamaleni, sekemunyawenyawe mbuli ya vija vonda mwidike, ");
INSERT INTO kdc2014_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kwavija niye nowagwaa ubala na mbuli za kulonga. Kuduhu munhu mna iwanhu wamwihileni yodaha kuwahuma hebu kulema chonda mulonge. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mohindukigwa na tata zenu na mama zenu na ndugu zenu na wanhu wa mulukolo, na mbwiga zenu, na wayagwe vimwili wowakoma. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wanhu wose wowehila mweye mbuli ya twaga jangu. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini kuduhu hata luvili lumoja lwa mmapala genu londa lupotele. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mwahagangamala, moihonya wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mwahajona buga da Yelusalemu dizungulukigwa na wakalizi, baho mujuwe kipindi cha kubanangigwa cha mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Baho, waja weli Yudea wakimbilile kuvigongo, waja weli kudibuga walawanye, waja weli kumigunda sekewabwele kudibuga. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwavija kino acho kipindi cha nhaguso kutenda gaja gandikigwe galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mna izisiku azo wogaya watwanzi wali na zinda na waja wokong'heza! Kwavija hokuwa na magayo ng'hani mwiisi, na ng'hasiliki ya Mulungu yokuwa mna iwanhu wano. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wayagwe wokomigwa kwa panga, na wayagwe wosoligwa na kugodekigwa mziisi zose, na wanhu haweli Wayahudi wodihondahonda buga da Yelusalemu, mbaka kipindi chao vonda kimale. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Hokuwa na vilaguso mna dizuwa, mna umwezi, na mna zinhondo. Isi zose zokuwa mna ukugaya, wodumba mvumo wa bahali na ng'humbi. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wanhu wosinduka kwa bwembwe, kwa kubetela chondakilawilile mwiisi, kwavija vinhu vili kuulanga votigisika. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kipindi acho womona Mwana wa Munhu kokwiza, mna ga mawingu kwa nguvu ng'hulu na ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Avo vinhu vino vahasonga kulawilila, mwime na mwinule mapala genu uchanha, kwavija kukomboligwa kwenu kwa mmabehi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Abaho Yesu kawalongela lusimo luno, “Geseni mbiki wa mtini na mibiki yose iyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mwahagona majani gake gosonga kuzuka, mojuwa kamba vuli da mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vivija, mwahavona vinhu avo volawilila, mujuwe kamba Undewa wa Mulungu wa mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nowalongeleni ukweli, wanhu wa lukolo luno hawafa wose mbaka gano gose galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ulanga na isi vobita, lakini mbuli zangu hondazibite. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Iteganyeni! Mizoyo yenu sekeigogigwe na unovu wa mwiisi ino, kukoligwa, na kugaya mbuli ya ugima uno, kwavija siku ayo yowasinhusa ");
INSERT INTO kdc2014_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kamba mtego. Kwavija yowezila wanhu wose wokala kila hanhu mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Muiteganye na mupule siku zose, muladi mudahe kuhonyeka mna zimbuli zose zino zondazilawilile na kwima haulongozi wa Mwana wa Munhu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kila siku Yesu kakala kofundiza Mng'anda ya Mulungu, na yahavika ichungulo, kacholaga kuna Ulugongo lwa Mizeituni na kakala kuko kilo kigima. ");
INSERT INTO kdc2014_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Imitootondo ng'hani wanhu wose wakala wochola kuna Ing'anda ya Mulungu kumtegeleza. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kipindi cha Nyimwili nyimwili da Magate hagageligwe Mela, kikemigwe Pasaka kikala behi. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wakulu wa walava nhosa na wafundiza Malagizo ga Musa wakala wozahila nzila ya kumkoma Yesu, lakini wawadumba wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mwenembago kamkumba Yuda Isikaliote, imoja wa wanahina longo na wabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda kachola kwa wakulu wa walava nhosa na wakulu wa wakalizi wa Ng'anda ya Mulungu, kawalongela vija vonda yamuhinduke Yesu kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nao wadeng'helela na waitogolela kumgwaa sente. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda katogola, na kasonga kuzahila nzila ya kumgela Yesu mmakono gao kwa kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Siku ya Magate hagageligwe Mela ivika. Siku ayo bofu da ng'hondolo da Pasaka dolavigwa nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Avo Yesu kawatuma Petulo na Yohana, kawalongela, “Choleni mkatutandile lujo lwa Pasaka tuje.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nao wamuuza, “Kolonda tukalutandile kwahi ulujo lwa Pasaka?” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu kawedika, “Mwahengila kudibuga, mnzila momting'hana mbigalo yapapile nongo ya mazi. Mkwelelezeni mbaka mng'anda yonda yengile, ");
INSERT INTO kdc2014_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na mulongeleni mwene kae, ‘Mfundiza kokuuza, dakwahi gati dondanidile lujo lwa Pasaka niye na wanahina zangu?’ ");
INSERT INTO kdc2014_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nayo kowalagusila gati kulu da uchanha dihambigwe, mumo mtutandile kila kinhu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wasegela wavika kila kinhu kamba vija Yesu viyawalongele, nao watanda lujo lwa Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saa viivikile, Yesu kakala muulujo na watumigwa zake. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kawalongela, “Nisulukila ng'hani kuja lujo luno lwa Pasaka hamoja na mweye ning'hali sinadununzika! ");
INSERT INTO kdc2014_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Avo nowalongela, honda nije kabili mbaka vonda ilawilile Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Abaho Yesu kasola kikasi cha divai, kamgwaa nhogolwa Mulungu, kalonga, “Soleni kino mung'wile mose. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nowalongela kulawa sambi, honda ning'we divai ino mbaka vondawize Undewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Abaho kasola gate, kamgwaa nhogolwa Mulungu, kadibanzula, kawagwaa, kalonga, “Uno ulo lukuli lwangu, ulavigwe mbuli ya mweye. Tendeni vino kwa kung'humbuka niye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Vivija, viwamambukize kuja lujo lwa ichungulo, kawagwaa kikasi, kalonga, “Kino acho kikasi cha lagano da sambi dilagusigwa kwa damu yangu, ikwitika mbuli ya mweye. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lakini, loleni! Munhu yonihinduka kabahano na niye muulujo! ");
INSERT INTO kdc2014_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwana wa Munhu kofa kamba Mulungu viyalondile, lakini kogaya munhu ija yomuhinduka!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Abaho wasonga kuiuza, nani viweli yonda yatende vivo. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wanahina wakala woibamilila wao kwa wao nani yokoneka munhu mkulu kubanza wose. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kawalongela, “Wandewa wa wanhu haweli Wayahudi wana udahi kwa wanhu, walangulizi woikema, ‘Mbwiga wa wanhu.’ ");
INSERT INTO kdc2014_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini kumwenu mweye haili vivo bule, munhu mkulu kumwenu yawe kamba munhu mdodo, na mulangulizi yawe kamba msang'hanaji. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vino, nani yeli munhu mkulu, ija yakalile mmeza koja, hebu ija yotanda ulujo? Ona, ayo ija yakalile mmeza koja. Lakini niye na hagati yenu kamba munhu yosang'hana.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mweye mukala na niye kipindi chose cha kugezigwa kwangu, ");
INSERT INTO kdc2014_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","kamba Tatangu viyanigwelele Undewa na niye nowagwaa Undewa awo. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Moja na kung'wa mmeza yangu mna Undewa wangu, na mokala mna ivigoda va Undewa kugatawala makabila ga Izilaeli longo na mabili.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu kalonga, “Simoni, Simoni! Tegeleza! Mwenembago kampula Mulungu kuwageza mweye, kuwabagula wanogile na wehile, kamba vija mfolaji viyobagula fuya na hemba. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini nikupulila kwa Mulungu gweye Simoni, muladi kumtamanila kwako Mulungu sekekupotele. Na vondaunibwelele, uwagangamize ndugu zako.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulo kamwidika, “Mndewa, notogola kugodekigwa na gweye mkifungo na kufa!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kalonga, “Petulo, nokulongela ukweli, kilo cha lelo nzogolo yang'hali hanakwika, konibela miyanza midatu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Abaho Yesu kawauza wanahina zake, “Vino, kipindi kija viniwatumile kuno mduhu kibindo hebu mkoba hebu vilatu, muhungukiligwa na kinhu chochose?” Wamwidika, “Aka, hatuhungukiligwe na kinhu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu kawalongela, “Lakini sambi, munhu yoyose yeli na kibindo, hebu mkoba yausole, na munhu yoyose yeliduhu panga yakachuuze koti jake yakagule. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwavija nowalongela Maandiko Gang'alile galongile, ‘Kekigwa mdibumbila dimoja na wabananzi,’ golondigwa galawilile. Nowalongela, gaja gandikigwe mbuli ya niye golawilila.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wanahina walonga, “Mndewa, lola, hano hana mapanga mabili!” Nayo kawedika, “Gofaya!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kasegela kudibuga dija kachola kuna Ulugongo lwa Mizeituni, kamba viyazowele, na wanahina zake wamkweleleza. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Viyavikile kuko, kawalongela, “Mpuleni Mulungu, sekemwingile mna ukugezigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Abaho kawaleka, kachola utali wa kwasa dibwe, kafugama, kampula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kalonga, “Tata, wahalonda, unisegezele kikasi kino cha madununzo. Siyo kamba vinilonda niye, lakini kamba viulonda gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Msenga wa kuulanga kamulawilila, kamgangamiza. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kwa usungu mkulu uyakalile nao kampula ng'hani, mbaka fuguti dimulawa, fuguti jake dikala kamba madondwe ga damu golagala hasi. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Viyamambukize kumpula Mulungu, kabwela kwa wanahina zake, kawavika wokuluza kwavija wakala wadonhile mbuli ya kunyunyuwala. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kawalongela, “Habali mowasa? Lamukeni mumpule Mulungu, sekemwingile mna ukugezigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu viyakalile yang'hali kolonga, lunhu lwa wanhu luvika lulongozigwe na Yuda, imoja wa wanahina zake longo na wabili. Yuda kamcholela Yesu kamulamusa kwa kumnonela. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lakini Yesu kamulongela, “Yuda, komuhinduka Mwana wa Munhu kwa kumnonela?” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wanahina wakalile hamoja na Yesu viwonile gaja gonda galawilile, wauza, “Mndewa, tuwakanhe na mapanga getu?” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Imoja wao kambiga kwa panga msang'hanaji wa Mkulu wa walava nhosa na kamkanha digwiti da mkono wa kudila. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lakini Yesu kalonga, “Bule sekemutende avo!” Kadikwasa digwiti da munhu ija, kamuhonya. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Abaho Yesu kawalongela wakulu wa walava nhosa na wakulu wa wakalizi wa Ng'anda ya Mulungu na wavele wezile kumgoga, “Habali, mwiza kungoga kwa mapanga na malungu, kamba nambavi? ");
INSERT INTO kdc2014_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Siku zose ng'hala na mweye Mng'anda ya Mulungu hamngogile bule. Lakini kino acho kipindi chenu cha kusang'hana, muundewa wa ziza.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Baho wamgoga Yesu, wengila nayo mng'anda ya mkulu wa walava nhosa. Petulo kamkweleleza kwa kutali. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wabwinha moto hagati hana uluwa, wakala hamoja na Petulo kakala hamoja nao. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Msang'hanaji imoja wa kitwanzi viyamone Petulo kakala aho haumoto, kamulola bunhuu, kalonga, “Vivija munhu ino kakala hamoja na Yesu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petulo kabela, kalonga, “Gwee, mtwanzi gwe, simjuwile bule!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hamwande kidogo munhu iyagwe kamona Petulo, kalonga, “Vivija na gweye kwa imoja wao!” Lakini Petulo kamwidika “Gwee munhu gwe, siyo niye!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Vidibitile saa dimoja, munhu iyagwe kagangamiza ng'hani, “Kweli munhu ino kakala hamoja na Yesu, kwavija nayo mwenekae wa Galilaya!” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petulo kamwidika, “Munhu gweye, sikijuwile kiulonga!” Bahaja, viyakalile yang'hali kolonga, nzogolo keka. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mndewa kahinduka, kamulola Petulo, nayo Petulo kakumbuka Mndewa viyamulongele, “Kilo cha lelo nzogolo yang'hali hanakwika, konibela miyanza midatu.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petulo kalawa kunze kalila kwa usungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wanhu wakalile womkaliza Yesu, wakala womzeha na kumtowa, ");
INSERT INTO kdc2014_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","viwamgubike gameso na wamuuza, “Lagula! Nani yakutowile?” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vivija walonga mbuli ziyagwe nyingi za kumuliga. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Imitondo yake, wavele, wakulu wa walava nhosa na wafundiza Malagizo ga Musa waiting'hana hamoja na Yesu kagaligwa mkitala acho. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Walonga, “Tulongele! Vino, gweye ayo Kilisito Mkombola?” Yesu kawedika, “Nahawalongela, honda munitogole bule, ");
INSERT INTO kdc2014_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nahawauza mbuli, honda mwidike bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini kusongela sambi, Mwana wa Munhu kokala muukulu mwambu wa mkono wa kudila wa Mulungu yeli na Udahi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wose walonga, “Vino gweye kwa Mwana wa Mulungu?” Yesu kawedika, “Molonga, iyo niye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Walonga, “Hatulonda usindila uyagwe! Tweye wenyego tumuhulika viyalongile!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Abaho wanhu wose wenuka, wamgala Yesu kwa Pilato, ");
INSERT INTO kdc2014_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","wasonga kumulavila vitala, walonga, “Tumvika munhu ino kowagiza wanhu zetu, kowagomesa wanhu sekewalipe kodi kwa mndewa mkulu wa Lumi na koikema heyo ayo Kilisito Mkombola na koikema Mndewa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kamuuza, “Gweye ayo Mndewa wa Wayahudi?” Yesu kamwidika, “Ona, vivo viulonga,” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Abaho Pilato kawalongela wakulu wa walava nhosa na ulunhu lwa wanhu, “Siyonile mbuli ya kumtagusa munhu ino.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini wao wagangamiza ng'hani, walonga, “Kwa mafundizo gake kowading'hula wanhu wose wa mwiisi ya Yudea. Kasongela Galilaya na sambi keza hano.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato viyahulike avo kauza, “Vino munhu ino mwenekae wa Galilaya?” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Viyajuwile kamba Yesu kalawa mwiisi ilongozigwa na Helode, kamgala kwa Helode, yakalile Yelusalemu kipindi acho. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode viyamone Yesu kadeng'helela ng'hani, kwavija kahulika mbuli zake na toka mwaka kakala yolonda kumona. Kakala kobetela kona unzonza utendigwa na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Avo Helode kamuuza Yesu mbuli nyingi, lakini hamwidike mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wakulu wa walava nhosa na wafundiza Malagizo ga Musa walawilila kuulongozi wamulavila vitala Yesu vikulu vikulu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helode na wakalizi zake wamzeha Yesu na kumwehula, abaho wamvaza kiwalo cha undewa wambweza kwa Pilato. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kipindi kikija Helode na Pilato wakala mbwiga, kwavija ako umwaka wakala waihile. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kawakema hamoja wakulu wa walava nhosa, walangulizi na wanhu, ");
INSERT INTO kdc2014_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kawalongela, “Mumgala munhu ino kumwangu mulonga kakala kowagiza wanhu. Lelo nimuuza mgameso genu na siyonile mbuli yoyose ihile yumumtagusile. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Vivija Helode hachonile kiyabanange, lekaavo kambweza kumwetu. Kwavija kuduhu mbuli yoyose yaitendile munhu ino imtende yakomigwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Avo nolagiza yatoigwe mbalati na kumuleka yachole.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chahavikaga kipindi cha Nyimwili nyimwili ya Pasaka, Pilato kalondeka yamfungulile mfungwa imoja. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lunhu lose lukemelela, “Mkome munhu ayo! Tufungulile Balaba!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba kakala yagodekigwe mkifungo mbuli ya kuwading'hula wanhu kudibuga, na mbuli ya ukomaji. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kalonda kumulekesa Yesu, avo kalulongela ulunhu kabili. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini wagendelela kukemelela, “Muwambe mumsalaba! Muwambe mumsalaba!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato kawalongela mwanza wa kadatu, “Vino, mbuli gani ihile yaitendile munhu ino? Siyonile mbuli yoyose yaitendile munhu ino imtende yakomigwe! Nolagiza yatoigwe mbalati na kumulekesa.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wagendelela kukemelela ng'hani, wolonga Yesu yawambigwe mumsalaba, kukimambukizo nyangi zao zihuma. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Avo Pilato katogola kija kiwalondile kumtendela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kamfungulila munhu iwamulondile, ija yagodekigwe mbuli ya kuwading'hula wanhu na ukomaji, na kamgela Yesu mmakono gao wamtendele kamba viwalondile. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wakalizi wamulongoza Yesu, viwakalile womgala, wamting'hana munhu imoja kulawa Kilene, twaga jake Simoni, kakala kolawa kumgunda, wamgoga wamdikwa umsalaba, na wamulagiza yaupape kukisogo cha Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lunhu mkulu lwa wanhu lumkweleleza, mmwanza awo wakala watwanzi wayagwe wakalile womulilila na kuiyalala. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kahinduka kawalongela, “Mweye kina mama wa Yelusalemu! Sekemunililile niye, lakini ililileni wenyego na wanenu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwavija kipindi chokwiza wanhu wolonga, ‘Wamweda watwanzi hawalelile wana na hawakong'heze!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kipindi acho wanhu wovilongela vigongo, ‘Tulagalile!’ na wovilongela visugulu, ‘Tufiseni!’ ");
INSERT INTO kdc2014_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","kwavija kamba wanhu wotenda mbuli zino kipindi mbiki ung'hali mbisi, vino yokuwaze kipindi mbiki wahanyala?” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wanhu wabili wayagwe wakalile wabananzi, wagaligwa wakomigwe hamoja na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Viwavikile hanhu hakemigwe, “Fumvu da Pala,” wamuwamba Yesu mumsalaba, hamoja na waja wabananzi wabili, imoja mwambu wa mkono wake wa kudila na iyagwe mwambu wa mkono wake wa kumoso. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kalonga, “Tata, gela kumgongo nzambi zao, kwavija hawakijuwa kiwotenda.” Waigolela viwalo vake kwa kubwanha simbi. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wanhu wema aho wolola, kuno wakulu wa Wayahudi womzeha Yesu, walonga, “Kawakombola wayagwe, leka yaikombole mwenyego, kamba heyo ayo Kilisito, yasaguligwe na Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vivija wakalizi wamzeha, wamcholela wamgwaa divai ya ugwadu, ");
INSERT INTO kdc2014_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kuno wolonga, “Kamba gweye kwa Mndewa wa Wayahudi, ikombole mwenyego!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Uchanha ya msalaba wake wandika vino, “Ino ayo Mndewa wa Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Imoja wa waja wabananzi yawambigwe mumsalaba, kamuliga Yesu, kalonga, “Vino gweye siyo Kilisito Mkombola? Ikombole mwenyego na tweye!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini ija iyagwe kamkomhokela miyage, kalonga, “Vino, gweye humdumba Mulungu bule? Na gweye kutagusigwa kamba heyo. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gweye na niye totagusigwa goya, kwavija tobokela fungu da sang'hano zetu, lakini munhu ino hatendile mbuli yoyose ihile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Abaho munhu ija kamulongela Yesu, “Yesu, ung'humbuke wahengila Muundewa wako!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kamulongela, “Nokulongela ukweli, lelo kokuwa na niye Paladiso.” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ikala saa sita imisi, ziza diigubika isi yose mbaka saa tisa, ");
INSERT INTO kdc2014_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kwavija zuwa dileka kumwemwesa. Panziya da Ng'anda ya Mulungu digola gati da Ng'anda ya Mulungu na hanhu hong'ala ng'hani, didegeka mhande mbili. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kalila kwa sauti ng'hulu, “Tata, noika mmakono gako loho yangu!” Viyalongile avo, kafa. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mkulu wa wakalizi wa Lumi viyagone gago galawilile, kamgwaa nhogolwa Mulungu, kalonga, “Munhu ino kweli kakala yanogile!” ");
INSERT INTO kdc2014_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wanhu wose wakalile waiting'hane aho kulola mbuli azo, viwagone gago galawilile, wabwela ukayao, kuno wotowa mhambaga zao kwa kunyunyuwala. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wanhu wose wamjuwile Yesu na watwanzi wamuwinzile kulawa Galilaya, wema kwa kutali wolola mbuli azo. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kukala na munhu imoja twaga jake Yusufu, munhu wa Mkitala, kakala munhu yanogile na kutenda goyolonda Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Keza kulawa Yudea buga da Alimataya na kakala kobeta kwiza kwa Undewa wa Mulungu. Hamoja kakala imoja wa wakulu wa mkitala, hagatogole gaja gawalondile wayage na gaja gawakalile wotenda. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kachola kwa Pilato, kampula lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Abaho kaluhumulusa hasi ulukuli, kaluzingiliza sitili, kalwika mdipanga disongoligwe mdibwe, dikalile hadinazikiligwa munhu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ikala ijumaa, siku ayo ikala siku ya kuitanda siku ya Kubwihila ikalile behi kusonga. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Watwanzi waja wamkweleleze Yesu kulawa Galilaya wachola na Yusufu, na wajona dipanga na vija vilwikigwe lukuli lwa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Abaho wabwela ukae, watanda mavuta gonung'hila goya walubake lukuli lwa Yesu. Mna isiku ya Kubwihila wabwihila kamba Malagizo ga Musa vigalagize. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili imitootondo ng'hani, watwanzi waja wachola kudipanga, kuno wasola mavuta gonung'hila goya gawatandile. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wadivika idibwe dibimbilisigwa hamgwazo wa umulomo wa dipanga, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","avo wengila mdipanga, lakini hawaluwone lukuli lwa Mndewa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wema aho kuno woikanganya mbuli ayo, bahaja wanhu wabili wavalile viwalo vizelu chuwee wema behi nao. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kuno wamema bwembwe, watwanzi waja waidulika hasi, wanhu waja wawalongela, “Habali momzahila munhu yeli mgima mna iwanhu wafile? ");
INSERT INTO kdc2014_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hano kahaduhu, kazilibuka. Kumbukeni vija viyawalongele viyakalile Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana wa Munhu kolondeka yageligwe mmakono ga wanhu wotenda nzambi, awo womuwamba mumsalaba, na siku ya kadatu kozilibuka!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Baho watwanzi waja wazikumbuka mbuli zake, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Walawa mdipanga, na wawalongela wanahina longo na imoja mbuli zose zino na wanhu wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Watwanzi awo wakala, Malia Magidalena, Yoana na Malia mamake Yakobo, awo hamoja na watwanzi wayagwe wawalongela watumigwa mbuli azo. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakini watumigwa wagesa kamba mbuli zilongigwe na iwatwanzi waja za ubozi, na hawawatogolele bule. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakini Petulo kenuka na kakimbila mbaka kudipanga, kasungulila mgati, kayona sitili iiyeka. Abaho kabwela ukae kuno kokanganya kija kilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Siku didija wanahina wabili wa Yesu wakala wochola kuna ikijiji kimoja kikemigwe Emau, kikala utali wa kilometa longo na imoja kulawa Yelusalemu, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","wakala wosimulila usheha wa mbuli zose zilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Viwakalile wosimulila, Yesu mwenyego kakwesa behi kailongoza nao. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wamona, lakini wafisigwa sekewamjuwe. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kawalongela, “Mosimulila usheha gani kuno mogenda?” Nao wema wanyamala tuluu, na vihanga vao vogela bazi kwa kunyunyuwala. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Imoja wao yakemigwe Kileopa, kamuuza, “Vino, gweye wiiyeka ayo huli mwenekae wa Yelusalemu hujuwile mbuli zilawilile kuko sambi sambi?” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kawauza, “Mbuli gani?” Nao wamwidika, “Mbuli zimulawilile Yesu wa Nazaleti, munhu ayo kakala mtula ndagu wa Mulungu na kakala yokoneka mgameso ga Mulungu na wanhu wose kamba kana udahi kwa kila kinhu kiyalongile na kiyatendile. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wakulu wa walava nhosa na walangulizi zetu wamgela mmakono yatagusigwe kufa, na yawambigwe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na tweye tutamanila kamba heyo ayo yonda yawakombole wanhu wa Izilaeli! Lakini lelo siku ya kadatu toka zilawilile mbuli zino. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Watwanzi wayagwe wa mdibumbila jetu watukanganya, imitootondo wachola kuna dipanga, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lakini hawaluvikile lukuli lwake. Wabwela walonga wawona wasenga wa kuulanga wawalongela kamba, Yesu mgima. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Abaho wanhu wayagwe wa mkibumbila chetu wachola kuna dipanga na wavika vivija viwawalongele watwanzi awo, lakini hawamonile bule.” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu kawalongela, “Mweye mwa wabozi, na mizoyo yenu midala kutogola gose galongigwe na watula ndagu wa Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vino, halondigwa Kilisito Mkombola yadununzike kamba avo, abaho yengile muukulu wake?” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu kawasimulila gaja galongigwe na Maandiko Gang'alile mbuli yake mwenyego, kusongela mna ivitabu va Musa na maandiko ga watula ndagu wose wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Viwavikile behi na ikijiji kiwakalile wochola, Yesu kaitenda kamba kogendelela na mwanza, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","lakini wamgoma ng'hani, wolonga, “Ukale na tweye, zuwa dihonga na ziza dokwingila.” Avo kagenda na kukala nao. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kakala hasi na kuja nao, kasola gate, kamgwaa nhogolwa Mulungu, abaho kadibanzula kawagwaa. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bahaja, meso gao gagubuligwa na wamjuwa, lakini kapotela mgameso gao. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wailongela, “Vino, mizoyo yetu hayakile na kimuhemuhe vitukalile mnzila kotulongela na kotusimulila Maandiko Gang'alile?” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bahaja wenuka wabweleganya Yelusalemu, kuko wawavika wanahina longo na imoja wakala hamoja na wanhu wayagwe, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wolonga, “Mndewa kazilibuka kweli! Kamulawilila Simoni!” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wanhu waja wawasimulila kija kiwalawilile mnzila, na vija viwamjuwile Yesu viyadibanzule gate. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wanhu waja viwakalile wang'hali wowasimulila mbuli azo, bahaja Yesu kema hagati yao, kawalongela, “Zihozeni.” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wasinhuka na kudumba wagesa wokona mzimu. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lakini Yesu kawalongela, “Habali modumba na kunyawanyawa? ");
INSERT INTO kdc2014_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Loleni makono gangu na magulu gangu, na mojuwa kamba ayo niye. Mbabaseni mojuwa, kwavija mzimu waduhu lukuli na mizege, kamba vimnyona niye.” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Viyalongile avo, kawalagusila makono gake na magulu gake. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wakala wang'hali hawatogola, kwavija wakala wodeng'helela na kukanganya, avo Yesu kawauza, “Mna kinhu chochose chakuja hano?” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wamgwaa kihande cha somba yakokigwe, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kakisola, kakija mgameso gao. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Abaho kawalongela, “Mbuli zino azo ziniwalongeleni ving'halile hamoja na mweye, kamba gose gandikigwe mbuli ya niye mna Gamalagizo ga Musa, na gandikigwe na watula ndagu wa Mulungu, na Zabuli galondeka galawilile.” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Baho kazigubula nzewele zao wadahe kugajuwa Maandiko Gang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kawalongela, “Vino avo yandikigwe, Kilisito Mkombola kolondeka yadununzike na siku da kadatu kozilibuka kulawa kwa wafile, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kwa twaga jake, usenga wopetigwa kwa wanhu wa isi zose, kusongela Yelusalemu, muladi waleke nzambi zao na Mulungu yazigele kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na mweye awo wasindila wa mbuli azo. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na niye nowagalila ija iyalongile Tatangu. Lakini beteni kudibuga mbaka nguvu vonda iwezileni kulawa uchanha.” ");
INSERT INTO kdc2014_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Abaho kawalongoza kunze kudibuga mbaka Betania, ako kenula makono gake, kawatambikila. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Viyakalile kowatambikila, kawaleka kagaligwa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wamtambikila na wabwela Yelusalemu kwa deng'ho kulu, ");
INSERT INTO kdc2014_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","kipindi chose wakala Mng'anda ya Mulungu na kumgwaa nhogolwa Mulungu.");
INSERT INTO kdc2014_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Baho kunaichanduso vinhu vose ving'hali havinaumbigwa kukala imoja yakemigwe Mbuli. Ayo kakala na Mulungu na ayo kakala Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Toka kunaichanduso Mbuli kakala hamoja na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kubitila heyo, Mulungu kaumba vinhu vose. Kuduhu kinhu chochose kiumbigwe bila heyo. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mgati mmwake mumo ukalile mwanduso wa ugima, na ugima awo ukala mulenge kwa wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mulenge awo wokwaka mdiziza, najo ziza hadiudaha kuuzima bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kulawilila munhu imoja yatumigwe na Mulungu, twaga jake Yohana. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ayo keza kuwalongela wanhu mbuli ya umulenge muladi wanhu wose wahulike na watogole. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Heyo mwenyego hakalile awo umulenge bule, lakini keza kuwalongela wanhu mbuli ya umulenge. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uno ukala mulenge kweli, mulenge wizile mwiisi kuwamwemwesela wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mbuli kakala mwiisi, na kubitila heyo Mulungu kaumba isi yose, lakini wanhu wa mwiisi hawamjuwile bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Keza mwiisi yake mwenyego, lakini wanhu zake mwenyego hawambokele bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakini waja wambokele na kumtogola, Mulungu kawatogolela kuwa wanage. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Si wana wa Mulungu bule kwa kuleligwa, hebu viwolonda wanhu hebu kwa udahi wa mbigalo yoyose, lakini Mulungu mwenyego heyo Tatao. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na heyo yakemigwe Mbuli kawa munhu, kakala hamoja na tweye, na tweye tuwona ukulu wake, ukulu uyagweleligwe na Mulungu Tatake, nayo kamema ng'hekewa na ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana kalava usindila uno yolonga, “Ino ayo iniwalongeleni kokwiza kukisogo changu yeli mkulu kubanza niye, kwavija kakala kuko toka umwaka niye sinavumbuka.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa ng'hekewa imemile iyalinayo, tweye wose tumweda ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mulungu kalava Malagizo kubitila Musa, lakini Yesu Kilisito katugalila ng'hekewa na ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuduhu munhu yamonile Mulungu, lakini Imwana yaiyeka yaigalile na Mulungu na kuilumba na Tata, ayo yatutendile tumjuwe Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wakulu wa Wayahudi kudibuga da Yelusalemu wawatuma walava nhosa na Walawi wachole kwa Yohana wakamuuze, “Gweye kwa nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana halemile bule kuwedika, lakini kalonga fulu ipile, “Niye sili Kilisito Mkombola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wamuuza, “Gweye kwa nani? Kwa Eliya?” Yohana kawedika, “Ka, sili Eliya bule.” Wamuuza, “Gweye kwa mtula ndagu wa Mulungu?” Kawedika, “Ka, sili niye.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wamulongela, “Tulongele, gweye kwa nani? Tolonda tukawedike waja watutumile. Vino gweye mwenyego koikemaze?” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana kawedika kwa kulonga gaja gayalongile mtula ndagu wa Mulungu Isaya, “Niye na ‘imoja yokema kuluwala. Tendeni goya nzila ya Mndewa, goloseni nzila yonda yabite!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wasenga waja watumigwe na kibumbila cha Mafalisayo ");
INSERT INTO kdc2014_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","wamuuza Yohana, “Kumbe gweye huli Kilisito, hebu huli Eliya, hebu huli mtula ndagu wa Mulungu, habali kobatiza wanhu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana kawedika, “Niye nowabatiza mweye kwa mazi, lakini kabaho imoja kema hagati yenu, mweye hamumjuwile bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kokwiza kukisogo changu, lakini niye sifaya hata kudohola nzabi za vilatu vake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mbuli zose zino zilongigwa ako Betania mwambu wa kudilawila zuwa wa lwanda lwa Yolidani, kuyakalile Yohana yobatiza wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Imitondo yake Yohana kamona Yesu komwizila, kalonga, “Loleni, Mwanang'hondolo wa Mulungu yosegeza nzambi za wanhu wa mwiisi! ");
INSERT INTO kdc2014_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ino ayo inilongile mbuli zake, ‘Kokwiza munhu kukisogo changu yeli munhu mkulu kubanza nene, kwavija kakala kuko toka umwaka niye sinavumbuka.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Niye mwenyego simjuwile viyali, lakini niza kuwabatiza kwa mazi muladi kutenda yajuwigwe na wanhu wa Izilaeli.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana kalava usindila kwa kulonga, “Nimona Loho Yang'alile kohumuluka kuulanga kamba huwa na kwima uchanha yake. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Niye nikala sijuwile kamba ayo heyo, lakini Mulungu, yanhumile kuwabatiza kwa mazi kanongela, ‘Munhu yonda umone Loho Yang'alile komuhumulukila kulawa kuulanga na kwima uchanha kwa munhu ayo, heyo ayo yonda yawabatize kwa Loho Yang'alile.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Abaho Yohana kalonga, “Nichona kinhu acho, na nowalongeleni ukweli, heyo ayo Mwana wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Imitondo yake, Yohana kakala kabili hanhu aho na wanahina zake wabili. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Viyamone Yesu kobita, kalonga, “Loleni, ino ayo Mwanang'hondolo wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wanahina awo wabili viwamuhulike Yohana kolonga avo, wamkweleleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu kahinduka, kawona womkweleleza, kawauza, “Mozahila choni?” Wamwidika, “Labi, kokala kwahi?” Labi fambulo jake, “Mfundiza.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kawalongela, “Izoni mulole.” Avo wachola hamoja nayo na kuhona hayakalile yokala. Ikala saa kumi ya imisi, na wasinda nayo. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andeleya, ndugu yake Simoni Petulo, kakala imoja wa awo iwabili wamuhulike Yohana na kumkweleleza Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bahaja Andeleya viyamone Simoni ndugu yake, kamulongela, “Tumona Masihi.” Masihi fambulo jake “Kilisito Mkombola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Abaho Andeleya kamgala Simoni kwa Yesu. Yesu kamulola, kamulongela, “Twaga jako Simoni mwanage Yohana, lakini kokemigwa Kefa.” Kefa kwa Kigiliki Petulo, na Petulo fambulo jake dibwe. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Imitondo yake Yesu kachola isi ya Galilaya, kamvika Filipo, kamulongela, “Ng'holeleze!” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo kakala mwenekae wa Betisaida kudibuga diwakalile Andeleya na Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo kamvika Nasanaeli, kamulongela, “Tumona munhu ayo yandikigwe na Musa mna ikitabu cha Malagizo, na watula ndagu wa Mulungu wengi wandika mbuli zake. Heyo Yesu mwanage Yusufu, mwenekae wa Nazaleti.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nasanaeli kamuuza, “Vino mbuli yoyose inogile yodaha kulawa kudibuga da Nazaleti?” Filipo kamwidika, “Izo ulole.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu viyamone Nasanaeli komwizila, kasimulila, “Ino Mwiizilaeli kweli, mgati yake mduhu uvizi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasanaeli kamuuza, “Vino gweye kunjuwaze?” Yesu kamwidika, “Filipo yang'hali hanakukema viukalile hasi hana umbiki wa mtini, niye nikona.” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nasanaeli kedika, “Mfundiza, gweye kwa Mwana wa Mulungu! Gweye kwa Mndewa wa Izilaeli!” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kamulongela Nasanaeli, “Vino kotogola kwavija nikulongela nikona viukalile hana umbiki wa mtini? Kokwiza kuvona vinhu vingi ng'hani kubanza vino!” ");
INSERT INTO kdc2014_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu kawalongela, “Nowalongeleni ukweli, mouwona ulanga ugubuka na wasenga wa kuulanga wokwela na kuhumuluka uchanha ya Mwana wa Munhu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Siku da kadatu kukala na zengele kudibuga da Kana mwiisi ya Galilaya. Mamake Yesu kakala aho, ");
INSERT INTO kdc2014_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na wanahina zake vivija wagonekigwa kudizengele. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai viimalile, mamake kamulongela Yesu, “Divai imala.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kamwidika, “Mama, habali unongela vivo. Saa yangu hainavika.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Abaho mamake Yesu kawalongela waja wasang'hanaji, “Chochose chonda yawalongele sang'haneni.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kukala na nongo sita za mabwe, kila nongo yomema madumu matano, zikigwa aho kamba viikalile mila ya Wayahudi ya kunawa. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kawalongela awo iwasang'hanaji, “Memezeni mazi nongo zose.” Nao wazimemeza mbaka uchanha. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Abaho Yesu kawalongela, “Deheni kidogo mumgalile mkulu wa dizengele.” Nao wamgalila. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mkulu wa dizengele viyagalanzile gaja gamazi, gagaluka divai. Hajuwile kuilawile, lakini waja iwasang'hanaji wadehile gamazi wajuwa. Avo mkulu wa dizengele kamkema ayo yosola mwehe, ");
INSERT INTO kdc2014_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kamulongela, “Kila munhu kagolaga divai inogile hana ichanduso. Wanhu wagonekigwe wahang'wa ng'hani, kolava divai igwaduke wang'we, lakini gweye kuika divai inogile mbaka sambi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu kasang'hana unzonza uno wa ichanduso ako Kana mwiisi ya Galilaya. Kuko kalagusa ukulu wake, na wanahina zake wamtogola. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Vigabitile gago, Yesu hamoja na mamake, ndugu zake, na wanahina zake wachola kudibuga da Kapelinaumu wakala aho siku ndodo. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Siku da Pasaka ya Wayahudi dikala behi, avo Yesu kachola Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kawavika wanhu Mng'anda ya Mulungu wochuuza ng'ombe, ng'hondolo, njiwa, na wayagwe wakala mmeza wovunja sente. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu kabota balati da luzabi, kawawinga wose ng'hondolo, ng'ombe, na vivija kazibidula meza za wanhu wakalile wovunja sente na kuzipwililisa sente zao. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Abaho kawalongela wose wakalile wochuuza njiwa, “Wasegezeni hano! Lekeni kuitenda ng'anda ya Tatangu kamba gulilo!” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanahina zake wakumbuka kamba Maandiko Gang'alile golonga, “Unogelwa wangu wa ng'anda yako yakutambikila, wosoma mgati mmwangu kamba moto.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wakulu wa Wayahudi wamuuza Yesu, “Vino unzonza gani wonda utende kutulagusila gweye kuna udahi wa kutenda gano gose?” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kawedika, “Tuleni Ng'anda ino ya Mulungu, na niye noizenga kabili kwa siku ndatu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wayahudi wamuuza, “Ng'anda ino ya Mulungu izengigwa kwa miyaka malongo mane na sita. Vino, gweye koizenga kwa siku ndatu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakini Ng'anda ya Mulungu iyakalile yolonga Yesu ikala lukuli lwake. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Viyazilibuke kulawa kwa wafile, wanahina zake wakumbuka kamba Yesu kawalongela mbuli ayo, wanahina zake wagatogola Maandiko Gang'alile na gaja gayalongile Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu viyakalile kudibuga da Yelusalemu kuna inyimwili nyimwili ya Pasaka, wanhu wengi wamtogola viwonile mbuli nyingi za unzonza ziyatendile. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu kakala hawatamanila bule, kwavija kawajuwa wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hailondeke munhu yoyose yamulongele mbuli yao, kwavija mwenyego kagajuwa gakalile mmizoyo yao. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kukala na mulangulizi imoja wa Wayahudi twaga jake Nikodemo, kakala imoja mna ikibumbila cha Mafalisayo. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Siku dimoja ikilo kamcholela Yesu na kumulongela, “Labi, tojuwa gweye kwa mfundiza kutumigwa na Mulungu. Kwavija kuduhu munhu yodaha kutenda unzonza kamba viutenda gweye kamba Mulungu hali hamoja nayo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kamwidika, “Nokulongela ukweli, kuduhu munhu yodaha kuwona Undewa wa Mulungu bila kuleligwa mwanza wa kabili.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo kamuuza, “Vino munhu mkulu kodahaze kuleligwa mwanza wa kabili? Havidahika bule munhu mkulu kwingila mna iinda ya mamake na kuleligwa mwanza wa kabili!” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kamwidika, “Nokulongela ukweli, kuduhu munhu yodaha kwingila Muundewa wa Mulungu bila kuleligwa kwa mazi na kwa Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Munhu koleligwa kwa lukuli na tatake na mamake, lakini koleligwa kiloho na Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sekeukanganye kwavija nokulongela molondeka mweye mose muleligwe mwanza wa kabili. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Beho dobuma kokose kudilonda, kodihulika, lakini hudijuwa dolawa kwahi hebu dochola kwahi. Vivo viili kwa munhu yoyose yaleligwe na Loho Yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo kauza, “Avo gano godahikaze?” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kamwidika, “Gweye kwa mfundiza mkulu wa Waizilaeli, huijuwile vilihi mbuli ino? ");
INSERT INTO kdc2014_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nokulongela ukweli, tolonga kija tukijuwile tosimulila acho tuchonile, lakini haduhu munhu yoyose kumwenu yotogola usenga wetu. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hamnhogola viniwalongeleni mbuli za mumuno mwiisi, vino monhogolaze nahawalongela mbuli za ako kuulanga? ");
INSERT INTO kdc2014_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kuduhu munhu yoyose yacholile kuulanga ila Mwana wa Munhu, yezile kulawa kuko.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kamba Musa viyamwinule mumbiki nyoka wa shaba kuja kuluwala, vivo vonda yenuligwe Mwana wa Munhu, ");
INSERT INTO kdc2014_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","avo munhu yoyose yonda yamtogole yawe na ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Avo, Mulungu kawanogela wanhu wa mwiisi mbaka kamulava Mwanage yeli yaiyeka, muladi munhu yoyose yonda yamtogole sekeyapotele lakini yawe na ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mulungu hamtumile mwanage yeze mwiisi yawataguse wanhu, lakini kamtuma yeze kuwakombola. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Wanhu wose wonda wamtogole Mwana honda watagusigwe bule, lakini wose womulema watagusigwa mwaka, kwavija hawamtogole Mwana yaiyeka yanogeligwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Vino vivo nhaguso vonda iwe, mulenge wiza mwiisi, lakini wanhu wanogelwa na ziza kubanza mulenge, kwavija gago goyosang'hana ganyolodoka. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wanhu wose wotenda gehile hawaulonda mulenge na haweza kumulenge, kwavija hawalonda gehile gao gowotenda goneke. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini wanhu wotenda ganogile wokwiza kumulenge muladi woneke wosang'hana goyolonda Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Vigabitile gago, Yesu na wanahina zake wachola kuna iisi ya Yudea, kuko kakala nao siku ndodo na kabatiza wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nayo Yohana kakala kobatiza ako Ainoni, siyo kutali ng'hani kulawa Salimu, kwavija hanhu aho kukala na mazi mengi. Wanhu wakala womcholela, nayo kawabatiza. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gano gose gatendeka Yohana yang'hali hanagodekigwa mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wanahina wayagwe wa Yohana wasonga kuibamilila na Muyahudi mbuli ya jadi ya kunawa ili wamtambikile Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Avo wamcholela Yohana na kumulongela, “Mfundiza, vino komkumbuka munhu ija yuukalile nayo mwambu wa kudilawila zuwa wa lwanda lwa Yolidani, ija yuulongile mbuli zake? Hambe sambi kobatiza na kila munhu komcholela!” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana kawedika, “Kuduhu munhu yodaha kuwa na kinhu chochose kamba Mulungu hamgwelele. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mweye wenyego awo wasindila zangu kamba nonga, ‘Niye sili Kilisito Mkombola, lakini nhumigwa nimulongolele.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mtwanzi yosoligwa ni wa mbigalo yosola. Lakini mbwiga wa mbigalo yosola, yemile na kutegeleza, kodeng'helela yahahulika sauti ya mbigalo yosola. Vivo ili kumwangu, deng'ho jangu divika. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Heyo kolondeka yawe mkulu na niye niwe mdodo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Heyo yolawa uchanha ni mkulu kubanza wose. Heyo yolawa mwiisi ni wa mwiisi na kolonga mbuli za mwiisi, lakini heyo yolawa kuulanga ni mkulu wa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Heyo kolonga mbuli ziyone na zija ziyahulike, lakini kuduhu munhu yotogola mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lakini munhu yoyose yozitogola mbuli zake kosindila kamba Mulungu kolonga ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Heyo yatumigwe na Mulungu kolonga mbuli za Mulungu, kwavija Mulungu kamgwaa ng'hani Loho wake Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata kamnogela Mwanage na keka kila kinhu mmakono gake. ");
INSERT INTO kdc2014_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Munhu yoyose yomtogola Mwana kana ugima wa mazuwa gose, na munhu yoyose yomulema Mwana kaduhu ugima, lakini kosigala mwiinhaguso ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo wahulika kamba Yesu kakala kopata na kobatiza wanahina wengi kubanza Yohana, ");
INSERT INTO kdc2014_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","lakini ukweli Yesu hambatize munhu yoyose ila wanahina zake wao wabatize. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu viyahulike avo, kasegela mwiisi ya Yudea na kubwela mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mmwanza wake kalondeka yabitile Samalia. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kavika mwiisi ya Samalia kudibuga da Sikali, behi na mgunda wa Yakobo uyamgwelele mwanage yakemigwe Yusufu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hanhu aho kukala na sima da Yakobo. Yesu viyadonhile na mwanza mtali, kakala aho kudisima. Ikala imisi. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mtwanzi wa kisamalia keza kudeha mazi. Yesu kamulongela, “Nigwelele mazi ning'we.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kipindi acho wanahina zake wakala wacholile kudibuga kugula chakuja. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mtwanzi ayo kamwidika, “Gweye kwa Muyahudi na niye na Msamalia. Kodahaze kumhula mazi ga kung'wa?” Kwavija Wayahudi hawajaga hamoja na Wasamalia. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kamwidika, “Maza ujuwile choolava Mulungu, na maza ujuwile nani yokupula mazi ga kung'wa, wahampulile, nayo yahakugwelele mazi gogala ugima.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mtwanzi ayo kamulongela, “Go mkulu, gweye kuduhu doo, na sima dino dingila ng'hani. Wahagapatile kwahi mazi gago gogala ugima? ");
INSERT INTO kdc2014_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Vino gweye kwa mkulu kubanza tata yetu Yakobo yatugwelele sima dino? Heyo mwenyego hamoja na wanage na fugo yake yose wang'wa mazi ga mdisima dino!” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kamwidika, “Wanhu wose wong'wa mazi gano wokona ng'hilu kabili, ");
INSERT INTO kdc2014_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lakini munhu yoyose yong'wa mazi gonda nimgwelele, honda yaone ng'hilu kabili. Mazi gonda nimgwelele niye gokuwa nzasa ya mazi gogala ugima wa mazuwa gose mgati mmwake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mtwanzi ayo kalonga, “Go mkulu, nigwee mazi gago muladi sekeniwe na ng'hilu kabili, na ndeke kwiza hano kudeha mazi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kamulongela, “Genda kamkeme mkasano wako, na wize nayo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mtwanzi ayo kamwidika, “Naduhu mkasano.” Yesu kamulongela, “Kulonga goya kuduhu mkasano. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kusoligwa na wakasano watano, na mbigalo yuukala nayo sambi siyo mkasano wako. Kunongela goya.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mtwanzi ayo kalonga, “Go mkulu, vinikona gweye kwa mtula ndagu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wahenga zetu wamtambikila Mulungu kuna ulugongo luno, lakini mweye Wayahudi molonga Yelusalemu aho hanhu holondeka tumtambikile Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kamulongela, “Mama, togola gano gonikulongela, kipindi chokwiza baho wanhu honda wamtambikile Tata kuna ulugongo luno hebu ako Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mweye Wasamalia hamumjuwile goya ayo imumtambikila, lakini tweye Wayahudi tumjuwa itumtambikila, kwavija ukombozi wolawa kwa Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakini kipindi chokwiza na sambi chabahano, aho awo wotambikaga kweli, womtambikila Tata kwa loho na kweli, kwavija Tata kolonda wanhu womtambikila kamba vivo. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mulungu ni Loho, avo wanhu womtambikila wolondeka wamtambikile kwa loho na kweli.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mtwanzi ayo kamulongela Yesu, “Nojuwa Mkombola kokwiza, yokemigwa Kilisito, yaheza kotulongela mbuli zose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kamwidika, “Iyo nene, inilonga na gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kipindi acho wanahina zake Yesu wabwela, wakanganya ng'hani viwamvikile Yesu kolonga na mtwanzi ayo. Lakini kuduhu imoja wao yamuuzile mtwanzi ayo, “Kolonda choni?” hebu yamuuze Yesu, “Habali kolonga na mtwanzi ino?” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Abaho mtwanzi ayo kaleka nongo yake ya mazi, kabweleganya kudibuga na kuwalongela wanhu, ");
INSERT INTO kdc2014_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Izoni mumulole munhu yanongele gaja gose ganhendile. Vino hadaha kuwa Kilisito Mkombola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Avo wanhu wasegela kudibuga na kumgendela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mna ikipindi kikija wanahina zake wamnanahiza Yesu, “Mfundiza, chonde, diya tanhu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini Yesu kawedika, “Ninao lujo mweye hamulujuwile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Avo wanahina wasonga kuiuza, “Vino hana munhu kamgalila chakuja?” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kawalongela, “Ujaji wangu, ni kutenda goyolonda ija yanhumile na kuimambukiza sang'hano iyanigwelele. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mweye mulongaga vino, ‘Ing'hali miezi mine tosonga kusenga.’ Lakini nowalongeleni, inuleni meso genu mulole mmigunda! Vihandigwe vikangala volondeka visengigwe! ");
INSERT INTO kdc2014_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Msengaji kolipigwa, na kwika hamoja indiya kwa ugima wa mazuwa gose. Avo muhandaji na msengaji wose wadeng'helele hamoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ulonzi uno wa kweli, ‘Imoja kohanda iyagwe kosenga.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Niwatuma mkasenge mumgunda kinhu kija hamkisang'hanile, wanhu wayagwe awo wasang'hane, na mweye momweda kwa sang'hano yao.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamalia wengi wa buga dija wamtogola Yesu kwa gaja gayalongile mtwanzi ayo, “Kanongela gose ganhendile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Avo Wasamalia viwamcholele Yesu, wampula yakale nao. Yesu kakala nao siku mbili. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wanhu wengi watogola mbuli ya usenga wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wamulongela mtwanzi ayo, “Sambi totogola, siyo mbuli ya gaja gaulongile gaiyeka, lakini tweye wenyego tumuhulika, na tojuwa heyo ayo Mkombola wa wanhu wa mwiisi yose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Vizibitile siku mbili, Yesu kachola isi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwavija Yesu mwenyego kalonga, “Mtula ndagu hapata nhogolwa mwiisi yake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Viyavikile mwiisi ya Galilaya, wanhu wengi wambokela, kwavija wakala wacholile mna ulujo lwa Pasaka mwiisi ya Yelusalemu na wachona kila kinhu kiyatendile kipindi cha Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu kachola kabili kudibuga da Kana mwiisi ya Galilaya, aho hayagaluse mazi kuwa divai. Aho kukala na mkulu imoja yakalile na mbwanga wake mtamu kudibuga da Kapelinaumu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mkulu ayo viyahulike kamba Yesu keza kulawa mwiisi ya Yudea kwiza mwiisi ya Galilaya, kamcholela Yesu, kampula yachole kudibuga da Kapelinaumu yakamuhonye mbwanga wake, yakalile kolonda kufa. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kamulongela, “Kuduhu munhu yoyose hagati yenu yotogola mbaka yaone unzonza na vilaguso.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mkulu ayo kamulongela, “Go mkulu, tuchole wose mwanangu yang'hali hanakufa.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kamulongela, “Genda, mwanago kohona!” Munhu ayo katogola mbuli za Yesu, kachola. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mnzila ya kuchola ukayake kawating'hana wasang'hanaji zake wamulongela, “Mbwanga wako kahona!” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kawauza mna ikipindi gani mwanage viyahonile, wamwidika, “Ikala jana saa saba imisi vivo homa viimulekile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bahaja tata ayo kakumbuka ikala kipindi acho Yesu viyamulongele, “Mwanago kohona.” Avo heyo na wanhu wa mng'anda yake wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uno ukala unzonza wakabili yautendile Yesu viyalawile isi ya Yudea kwiza isi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Vigabitile gano, Yesu kachola kudibuga da Yelusalemu kuna inyimwili nyimwili ya Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ako Yelusalemu behi na mulango ukemigwe Mulango wa Ng'hondolo kukala na kolombo dikemigwe kwa Kiebulania Betisaza. Mumgwazo wa kolombo dijo kukala na vihelengo vitano. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lunhu mkulu lwa wanhu wolumwa lukala lutambalala mvihelengo vivo, wanhu wasuwameso, mbetembete na wanhu waholole. Wakala wobetela mazi gatibuligwe, ");
INSERT INTO kdc2014_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kwavija kuna kipindi msenga wa kuulanga kezaga na kugatibula gaja gamazi geli kudikolombo, na mtamu yoyose yahalongola kwingila mazi gahamala kutibuligwa, kohona utamu wowose uyali nao. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aho kukala na munhu imoja mtamu kwa miyaka malongo madatu na nane. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu viyamone katambalala aho, kajuwa kamba munhu ayo kana utamu wa siku nyingi, avo Yesu kamuuza, “Kolonda kuhona?” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mtamu ayo kamwidika, “Go mkulu. Kuduhu munhu wa kuningiza kudikolombo mazi gahatibuligwa. Kila vinigeza kwingila, munhu iyagwe konilongolela.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Abaho Yesu kamulongela, “Winuke, papa mkeka wako, utembele.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bahaja munhu ayo kahona, kapapa mkeka wake, kasonga kutembela. Mbuli ino ilawilila mwiisiku ya Kubwihila, ");
INSERT INTO kdc2014_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","avo wakulu wa Wayahudi wamulongela munhu ija yahonyigwe, “Lelo ni siku ya Kubwihila, Malagizo getu gogomesa gweye sekeupape mkeka wako.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Munhu ayo yahonyigwe kawedika, “Munhu heyo yanihonyile kanilongela nipape mkeka wangu nigende.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wamuuza, “Munhu gani heyo yakulongele utende vivo?” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lakini munhu ayo yahonyigwe kakala hamjuwile Yesu viyali, kwavija hanhu aho kukala na lunhu, na Yesu kakala yasegele. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Abaho, Yesu kamvika munhu ayo yamuhonyile Mwiig'anda ya Mulungu. Kamulongela, “Tegeleza, gweye sambi kuhona. Sekeutende nzambi kabili, muladi sekegakupate gehile kubanza gano.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Abaho munhu ayo kasegela, kachola kwa iwakulu wa Wayahudi, kawalongela, “Yesu ayo yanihonyile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Abaho Wayahudi wasonga kumwihila Yesu kwavija kamuhonya munhu siku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kawedika, “Tatangu kosang'hana siku zose, na niye vivija nosang'hana.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ulonzi uno uwatenda wakulu wa Wayahudi wazahile nzila kwa nguvu zose wadahe kumkoma Yesu. Watenda avo siyo kwavija kabena lagizo da siku ya Kubwihila diiyeka, lakini vivija kamkema Mulungu Tatake, avo kaitenda kamba kaigala na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kawedika, “Nowalongeleni ukweli, Mwana hatenda mbuli yoyose heyo mwenyego, kotenda gaja goyomona Tatake kotenda. Gaja goyotenda Tata, Mwana nayo kotenda. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Avo Tata komnogela Mwanage na komulagusila gaja gose goyotenda mwenyego. Komulagusila mbuli ng'hulu ng'hani kubanza zino, na mweye mose mokanganya. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kamba vija Tata viyowazilibula wanhu wafile na kuwagwaa ugima, vivo ili kwa Mwana nayo kowagwaa ugima waja wose yawalondile. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata hamtagusa munhu yoyose. Kamgwelela Mwanage udahi wose wa kutagusa, ");
INSERT INTO kdc2014_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","avo wanhu wose wamtegeleze Mwana, kamba vija viwomtegeleza Tata. Munhu yoyose yolema kumtegeleza Mwana kolema kumtegeleza Tata yamtumile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nowalongeleni ukweli, wanhu wose wozihulika mbuli zangu na kumtogola heyo yanhumile wanao ugima wa mazuwa gose. Awo honda watagusigwe bule, kwavija wamala kubita mkufa kwiza muugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nowalongeleni ukweli, kipindi chokwiza tena kipindi kimala kwiza, baho waja wafile woihulika sauti ya Mwana wa Mulungu, na waja woihulika wokuwa wagima. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kamba Tata mwenyego viyali chanduso cha ugima, vivo ili kwa Mwanage, kamtenda yawe chanduso cha ugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kamgwelela Mwana udahi wa kutagusa, kwavija heyo ayo Mwana wa Munhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sekemuikanganye mbuli ino, kipindi chokwiza baho waja wose wafile woihulika sauti yake ");
INSERT INTO kdc2014_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na wolawa mna gamapanga gao. Waja wose watendile ganogile wozilibuka na kupata ugima, na waja watendile gehile wozilibuka ili watagusigwe.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Niye mwenyego sitenda mbuli yoyose kwa udahi wangu, lakini notagusa kamba Mulungu viyonongela, avo notagusa goya, kwavija sitenda kija kinonda, lakini kija kiyolonda heyo yanhumile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nahalonga mbuli zangu mwenyego, ulonzi wangu wokuwa wa uvizi. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lakini kabaho imoja yosindila mbuli ya niye, naniye nojuwa gaja goyolonga ga ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mweye mutuma wasenga kwa Yohana, na mbuli ziyalongile mbuli yangu ni za ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Siulonda usindila wa munhu, lakini nonga vino ili mukomboligwe. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana kakala kamba kiwenge kikwaka yangaduu, na mweye muudeng'helela mulenge wake kwa kipindi kidodo. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Lakini niye mwenyego ninao usindila mkulu kubanza wa Yohana, kija kinhenda acho kiyanigwelele Tatangu nikitende, gano gose golagusa kamba Tata ayo yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata mwenyego yanhumile, vivija kosindila mbuli ya niye. Mweye hamunaihulika sauti yake hebu kuchona kihanga chake, ");
INSERT INTO kdc2014_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na mweye muilema mbuli yake kwavija hamumtogole ija iyamtumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mogasoma Maandiko Gang'alile kwavija mogesa kulawa mumo moupata ugima wa mazuwa gose. Na kuno Maandiko gago gago gandika mbuli zangu! ");
INSERT INTO kdc2014_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lakini hamulonda kwiza kumwangu mupate ugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Sizahila nhogolwa kulawa kwa wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini niye niwajuwa. Nojuwa mna imizoyo yenu hamumnogela Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Niza kwa twaga da Tatangu, lakini hamunibokele, ila munhu iyagwe yaheza kwa twaga jake mwenyego, mombokela. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Munogelwa kubokela nhogolwa kulawa mweye kwa mweye, lakini hamulonda kupata nhogolwa kulawa kwa heyo yeli Mulungu yaiyeka, vino modahaze kunhogola niye? ");
INSERT INTO kdc2014_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sekemugese nowalongeleza kwa Tatangu, lakini Musa, yumumtamanila ayo yonda yawalongeleze. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kamba kweli mumtogola Musa, mwahanhogole na niye, kwavija Musa kandika mbuli zangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kamba hamgatogole gaja gayandike Musa, modahaze kutogola gano gonilonga?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Abaho, Yesu kaloka mwambu wa lamba da Galilaya, vivija dokemigwa Lamba da Tibelia. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lunhu mkulu lumkweleleza, kwavija luwona unzonza wake wa kuhonya watamu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu kakwela mbaka uchanha kukigongo kakala hasi na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kipindi cha nyimwili nyimwili ya Wayahudi ikemigwe Pasaka kikala behi. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu viyalolile kaluwona lunhu mkulu lomwizila, avo kamuuza Filipo, “Tukagule kwahi vinhu vingi vakuja muladi wanhu wano wose waje?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu kalonga vino kumgeza Filipo kwavija kakala yajuwile kinhu gani chonda yatende. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo kamwidika, “Sente magana mabili hazidaha kugula magate kwa wanhu wose wano!” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Imoja wa wanahina zake Yesu yakemigwe Andeleya, ndugu yake Simoni Petulo, kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kabahano mbwanga kana magate matano ga ngano na somba wabili, lakini sikinhu chochose kwa lunhu lulihano.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kawalongela wanahina zake, “Walongeleni wanhu wakale hasi.” Kwavija hanhu aho hakala na mijani, wanhu wose wakala hasi. Kukala na wambigalo kamba elufu tano. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu kasola gaja gamagate, kamgwaa nhogolwa Mulungu, kawagolela wanhu wose wakalile aho. Katenda vivo kwa waja iwasomba, kila munhu kapata viyalondile. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Viwamambukize kuja, Yesu kawalongela wanahina zake, “Dondoleni vihande visigale. Sekemuleke hata kimoja.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Avo wanahina wadondola na kumemeza vigelo longo na vibili kulawa kuna gamagate matano gawadile wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Viwauwonile unzonza uno yautendile Yesu, wanhu walonga, “Kweli ino ayo mtula ndagu wa Mulungu yalondeke kwiza mwiisi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu kajuwa kamba walonda kumgoga kwa nguvu na kumtenda mndewa wao, avo kabweleganya kuvigongo yaiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Viivikile ichungulo, wanahina wa Yesu wahumuluka kudilamba, ");
INSERT INTO kdc2014_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wakwela mwiingalawa, na kubwela umwambu wa lamba mwambu wa Kapelinaumu. Ikilo ivika lakini Yesu kakala yang'hali hanachola kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Beho kulu dibuma na kugatibula ga mazi. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wanahina zake viwacholile utali wa kilometa tano mbaka sita, wamona Yesu kotembela uchanha mgamazi, kokwiza mwambu wao kuili ngalawa, wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu kawalongela, “Sekemudumbe. Iyo niye!” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wanahina zake walonda kumsola Yesu mwiingalawa, bahaja wavika mwiisi kuwakalile wochola. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Imitondo iyagwe lunhu mkulu lukala lukalile mwambu uyagwe wa lamba wona aho hakala na ngalawa imoja iiyeka. Wao wajuwa kamba Yesu hacholile hamoja na wanahina zake, lakini wasegela waiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngalawa ziyagwe zilawile Tibelia zivika mbaka behi na hanhu hawadile magate Mndewa viyamambukize kumgwaa nhogolwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wanhu viwajuwile Yesu kahaduhu hanhu aho, hebu wanahina zake, wakwela mzingalawa na kuchola Kapelinaumu, kumzahila. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wanhu viwamvikile Yesu umwambu uyagwe wa lamba, wamuuza, “Mfundiza, vino hano kwiza lini?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kawedika, “Nowalongeleni ukweli, monizahila niye kwavija muja magate mwiguta, siyo kwavija mona unzonza wangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sekemulusang'hanile lujo lunangika, lakini mulusang'hanile lujo lugala ugima wa mazuwa gose. Uno awo lujo londa yawagwee Mwana wa Munhu, kwavija Mulungu Tata kamsagula.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Avo wamuuza, “Vino kinhu gani tutende tudahe kugatenda goyolonda Mulungu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kawedika, “Kinhu choolonda Mulungu mweye mutende, mumtogole ija yamtumile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wamwidika, “Vino unzonza gani wonda utende ili tuwone na kukutogola? Choni chonda utende? ");
INSERT INTO kdc2014_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wahenga zetu waja lujo lukemigwa Mana kuluwala, kamba Maandiko Gang'alile vigalonga, ‘Kawagwelela lujo luhumuluke kuulanga.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kawalongela, “Nowalongeleni ukweli, siyo Musa yawagwelele lujo lwa kuulanga, lakini Tatangu ayo yowagwaa lujo lwa ukweli kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Lujo loowagwaa Mulungu ayo heyo yezile hasi kulawa kuulanga na kowagwaa ugima wanhu wa mwiisi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wamulongela, “Go mkulu, tugwee lujo lulo siku zose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu kawalongela, “Niye ayo lujo lugala ugima. Wose wonda weze kumwangu honda wone nzala, na waja wose wonhogola honda wone ng'hilu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Niwalongeleni kamba munyona lakini hamtogola. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose iwonigwelela Tatangu wokwiza kumwangu. Na niye simwasa kunze munhu yoyose yokwiza kumwangu, ");
INSERT INTO kdc2014_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kwavija sizile hasi kulawa kuulanga kutenda gaja gonilonda lakini goyolonda Tata yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Gano gago goyolonda ija yanhumile sekenimwagize hata imoja mna iwaja wose yangwelele, lakini nolondeka niwazilibule wose na kuwagwaa ugima siku ya kimambukizo. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwavija kiyolonda Tatangu acho kino, kila munhu yomulola Mwana na kumtogola heyo yawe na ugima wa mazuwa gose. Na niye nomzilibula munhu ayo mna isiku ya uhelelo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Avo, Wayahudi wasonga kumnung'unikila Yesu kwavija kalonga, “Niye ayo lujo luhumuluke kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Avo walonga, “Vino ino siyo Yesu mwanage Yusufu? Tumjuwa tatake na mamake. Yokuwaze kabili kolonga kahumuluka kuulanga?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kawedika, “Lekeni kuinung'unikila. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kuduhu munhu yodaha kwiza kumwangu bila kugaligwa na Tata yanhumile, na niye nomzilibula munhu ayo mna isiku ya uhelelo. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Watula ndagu wa Mulungu wandika, ‘Kila munhu kofundizigwa na Mulungu.’ Munhu yoyose yomtegeleza Tata na kuifunza kumwake kokwiza kumwangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kuduhu munhu yoyose yamonile Tata, heyo yalawile kwa Mulungu ayo heyo yaiyeka yamonile Tata. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nowalongeleni ukweli, heyo yotogola kanao ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Niye ayo lujo lugala ugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wahenga zenu waja lujo Mana kuluwala, lakini wafa. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lakini munhu yoyose yoluja lujo luhumuluke kuulanga honda yafe bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Niye ayo lujo lugala ugima luhumuluke kuulanga. Munhu yoyose yoja lujo luno, kokuwa mgima siku zose. Lujo londa nimgwee munhu ayo ni lukuli lwangu, awo uniwagwelela wanhu wa mwiisi ili wawe wagima.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mbuli ino iwatenda Wayahudi waibamilile. Waiuza, “Vino munhu ino kodahaze kutugwaa lukuli lwake tuluje?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu kawalongela, “Nowalongeleni ukweli, kamba hamuluja lukuli lwa Mwana wa Munhu na kuing'wa damu yake, honda muwe na ugima mgati mmwenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Munhu yoluja lukuli lwangu na kuing'wa damu yangu kanao ugima wa mazuwa gose, na niye nomzilibula mna isiku ya uhelelo. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwavija lukuli lwangu ulo lujo lwa kweli, na damu yangu acho king'waji cha kweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wanhu woluja lukuli lwangu na kuing'wa damu yangu wokala mgati mmwangu, na niye nokala mgati mmwao. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata yeli mgima yanhumile, na kwa mbuli yake niye na vivija mgima. Vivo vonda iwe munhu yoyose yoluja lukuli lwangu kokuwa mgima mbuli ya niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uno awo lujo luhumuluke kuulanga, haluigalile na lujo luja luwadile wahenga zenu, abaho wafa. Lakini yoyose yoluja lujo luno kokuwa mgima siku zose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kalonga mbuli zino viyakalile kofundiza mna ing'anda ya kumpula Mulungu ako Kapelinaumu. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wanhu zake wengi wamkweleleze waihulika mbuli ino na kulonga, “Mafundizo gano madala ng'hani. Nani yodaha kugatogola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bila kulongeligwa, Yesu kajuwa kamba wanhu zake wamkweleleze wakala woinung'unikila mbuli ino, avo kawalongela, “Vino mbuli ino yolonda kuwatenda mulemelwe? ");
INSERT INTO kdc2014_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Vino yokuwaze, mwahamona Mwana wa Munhu kobwela uchanha kuja kuyakalile ichanduso? ");
INSERT INTO kdc2014_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Loho wa Mulungu ayo yomgwaa munhu ugima, nguvu za munhu hazidaha kinhu chochose. Mbuli ziniwalongeleni ni za Loho wa Mulungu na zogala ugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lakini wayagwe wenu hawatogola.” Yesu kawajuwa toka mwaka waja hawamtogola na kamjuwa ija yonda yamuhinduke. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Abaho kalonga, “Lekaavo niwalongeleni kuduhu munhu yodaha kwiza kumwangu bila Tata kutenda idahike kwa munhu ayo kutenda vivo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwa ulonzi uno, wanhu wengi wamkweleleze wabweleganya kukisogo na hawadahile kabili kuchola nayo. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Avo Yesu kawauza wanahina zake longo na wabili, “Na mweye vivija molonda kusegela?” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo kamwidika, “Mndewa, tweye tuchole kwa nani? Gweye kunazo mbuli zigala ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sambi tweye totogola na tojuwa kamba gweye ayo Yang'alile ija yalawile kwa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu kedika, “Vino siwasagule mweye longo na wabili? Lakini imoja wenu Mwenembago!” ");
INSERT INTO kdc2014_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu kakala yolonga mbuli ya Yuda, mwanage Simoni Isikaliote. Yuda kakala imoja wa wanahina longo na wabili, ayo yonda yamuhinduke Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Vigabitile gano, Yesu kachola mwiisi ya Galilaya, halondile kuchola isi ya Yudea kwavija wakulu wa Wayahudi wakala wolonda kumkoma. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Siku ya nyimwili nyimwili ya Wayahudi ya viheha ikala behi, ");
INSERT INTO kdc2014_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","avo ndugu zake Yesu wamulongela, “Segela hanhu hano uchole isi ya Yudea, muladi wanhu zako wokukweleleza wazone mbuli ziutenda. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kuduhu munhu yofisa kija kiyotenda kamba yahalonda wanhu wamjuwe goya. Kwavija gweye kotenda mbuli zino, leka wanhu wose wamwiisi wakujuwe.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesu hatogoligwe hata na ndugu zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kawalongela, “Kipindi changu niye hakinavika. Lakini kipindi chochose kinoga kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wanhu wa mwiisi hawawehila mweye, lakini wonihila niye, kwavija siku zose nowalongela gaja goyotenda ganyolodoka. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mweye choleni kuna inyimwili nyimwili. Niye sichola bule, kwavija kipindi changu hakinavika.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu kalonga vino, abaho kagendelela kukala mwiisi ya Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndugu zake Yesu viwacholile kuna inyimwili nyimwili, Yesu nayo kachola. Hacholile kunze kunze lakini kachola kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wakulu wa Wayahudi wakala womzahila Yesu hana inyimwili nyimwili. Walonga, “Munhu ija ka kwahi?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hakala na minong'ono hana ulunhu mbuli ya Yesu. Wanhu wayagwe walonga, “Kanoga,” lakini wayagwe walonga, “Bule, kokwagiza wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lakini kuduhu munhu yokala yolonga mbuli ya Yesu chaka chaka, kwavija wakala wowadumba wakulu wa Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nyimwili nyimwili viikalile hagatigati, Yesu kengila Mng'anda ya Mulungu kasonga kufundiza. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wakulu wa Wayahudi wakanganya ng'hani na kulonga, “Yokuwaze munhu ino kojuwa vinhu vingi na kuno haifunzile kokose?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kawedika, “Mafundizo gano gonifundiza siyo gangu, lakini golawa kwa Mulungu yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Munhu yoyose yolonda kutenda goyolonda Mulungu kojuwa gano gonifundiza golawa kwa Mulungu hebu nolonga gaja gonilonda. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Munhu ija yolonga mbuli zake kozahila nhogolwa yake mwenyego. Lakini heyo yozahila nhogolwa kumwake ija yamtumile munhu ayo mkweli, mduhu uvizi mumulomo mmwake. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vino Musa hawagwelele Malagizo? Lakini kuduhu hata munhu imoja yogagoga. Vino habali molonda kung'homa?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lunhu lwa wanhu lumwidika, “Gweye kuna kinyamkela. Nani yolonda kukukoma?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kawedika, “Nhenda unzonza umoja, mweye mose mukanganya. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa kawalagiza muwengize kumbi wanenu hamoja siyo Musa lakini wahenga zenu awo wasongile, na mweye momwingiza kumbi mwana mna isiku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kamba mwana kokwingizigwa kumbi mna isiku ya Kubwihila muladi sekemubene Malagizo ga Musa, habali monigevuzikila kwavija nimuhonya munhu mna isiku ya Kubwihila? ");
INSERT INTO kdc2014_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lekeni kutagusa kwa meso, lakini mutaguse kwa ukweli.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wanhu wayagwe wa Yelusalemu walonga, “Vino ino siyo munhu ija iwakulu wolonda kumkoma? ");
INSERT INTO kdc2014_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Loleni! Kolonga kunze kunze na hawamulongela mbuli yoyose! Vino iwakulu wamjuwa ayo Kilisito Mkombola? ");
INSERT INTO kdc2014_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lakini Kilisito Mkombola yaheza, kuduhu munhu yonda yajuwe kolawa kwahi, lakini tweye tukujuwa koolawa munhu ino.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu viyakalile kofundiza Mng'anda ya Mulungu, kalonga kwa sauti ng'hulu, “Vino mweye munjuwa goya niye na mukujuwa kuja kundawa? Sizile kwa udahi wangu mwenyego, heyo yanhumile, ni mkweli. Mweye hamumjuwile, ");
INSERT INTO kdc2014_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","lakini niye nimjuwa, kwavija nolawa kumwake, nayo kanhuma.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Abaho walonda kumgoga, lakini kuduhu hata munhu imoja yamgolosele mkono, kwavija saa yake ikala hainavika. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lakini wanhu wengi hana ulunhu wamtogola na kulonga, “Vino Kilisito Mkombola yaheza, kotenda unzonza mkulu kubanza yautendile munhu ino?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo waluhulika lunhu lonyong'onya mbuli ya Yesu, avo wao na iwakulu wa walava nhosa wawatuma wakalizi wamgoge. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu kalonga, “Nokala na mweye kipindi kidodo, na abaho nochola kumwake ija yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Monizahila, lakini honda munyone, kwavija hamudaha kwiza hanhu hanili.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wakulu wa Wayahudi wailongela, “Vino munhu ino kochola kwahi mbaka seketumone? Vino kochola kunagamabuga ga Wagiliki kuko kookala wanhu zetu na kuwafundiza Wagiliki? ");
INSERT INTO kdc2014_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Vino kofambula choni viyolonga, tomzahila lakini honda tumone, na hatudaha kuchola kuko konda yawe?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mna isiku ya uhelelo na siku ng'hulu ya inyimwili nyimwili, Yesu kema kakemelela, “Munhu yoyose yokona ng'hilu yeze kumwangu yang'we. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kamba Maandiko Gang'alile vigalonga, ‘Munhu yonhogola niye, vizanda va mazi gogala ugima vokilima muumoyo wake.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu kalonga vino mbuli ya Loho Yang'alile, ija wanhu wose womtogola wombokela. Kipindi acho Loho Yang'alile kakala yang'hali hanakwiza, kwavija Yesu kakala hanakwinuligwa muukulu. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wanhu wayagwe mna ulunhu wamuhulika viyalongile avo na walonga, “Kweli munhu ino mtula ndagu wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wanhu wayagwe walonga, “Heyo ayo Kilisito Mkombola!” Lakini wayagwe walonga, “Kilisito Mkombola hadaha kulawa mwiisi ya Galilaya! ");
INSERT INTO kdc2014_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiko Gang'alile golonga kamba Kilisito Mkombola kolawa mulukolo lwa Daudi na kovumbukila Beselehemu kudibuga diyakalile Daudi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Avo lunhu luigola mbuli ya Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wanhu wayagwe walonda kumgoga Yesu, lakini kuduhu hata munhu imoja yamgolosele mkono. ");
INSERT INTO kdc2014_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wakalizi viwabwelile, wakulu wa walava nhosa na Mafalisayo wawauza, “Habali hamumgalile?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wakalizi wawedika, “Kuduhu munhu yolonga kamba munhu ayo!” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo wawauza, “Vino na mweye vivija muviziligwa?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Mumjuwa mkulu yoyose hebu Mfalisayo yomtogola? ");
INSERT INTO kdc2014_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lunhu luno halugajuwile Malagizo ga Musa, avo waduiligwa na Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo kakala imoja wa Mafalisayo wakalile aho, ayo yacholile kumulola Yesu ichanduso. Kawalongela wayage, ");
INSERT INTO kdc2014_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Vino Malagizo getu godaha kumtagusa munhu yoyose bila tanhu kumuhulika na kukijuwa kija kiyatendile?” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wamwidika, “Vino na gweye vivija kolawa mwiisi ya Galilaya? Gasome Maandiko Gang'alile na koifunza, kuduhu mtula ndagu wa Mulungu yalawile mwiisi ya Galilaya.” ");
INSERT INTO kdc2014_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Abaho kila munhu kachola ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu kachola kuna Ulugongo lwa Mizeituni. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Imitootondo ng'hani Yesu kabwela kuna Ing'anda ya Mulungu. Wanhu wose wamzunguluka, nayo kakala hasi kasonga kuwafundiza. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wafundiza Malagizo ga Musa na Mafalisayo wamgala mtwanzi yagogigwe ugoni, wamwika haulongozi wa wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wamulongela Yesu, “Mfundiza, mtwanzi ino kagogigwa ugoni. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muna ga Malagizo getu Musa katulagiza kamba mtwanzi kamba ino yatoigwe mabwe mbaka yafe. Lelo gweye kolongaze?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Walonga vino ili wamgoge Yesu kwa mbuli zake, muladi wapate kumtagusa. Lakini Yesu kainama kandika hasi kwa kidole chake. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Viwagendelele kwima aho kuno womuuza, Yesu kenuka kawalongela, “Munhu yoyose hatendile nzambi yasonge kumpigisila dibwe.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Abaho Yesu kainama kabili kandika hasi. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Viwahulike avo, wose wasegela imoja imoja, wasonga iwavele. Yesu kalekigwa yaiyeka, na mtwanzi ija yang'hali yemile aho. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu kenuka na kumulongela mtwanzi ija, “Wa kwahi wanhu waja? Kuduhu munhu yoyose yakutaguse?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mtwanzi ija kalonga, “Go mkulu, kahaduhu.” Yesu kalonga, “Vinoga. Na niye vivija sikutagusa. Genda lakini sekeutende nzambi kabili.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu kawalongela Mafalisayo kabili, “Niye ayo mulenge wa isi. Munhu yoyose yonikweleleza kokuwa na mulenge wa ugima na honda yagende mdiziza bule.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo wamulongela, “Gweye koisindila mwenyego, avo gago goulonga hagatogoligwa kamba kweli.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kawedika, “Aka, hata kamba nahaisindila mwenyego, gaja gonilonga ga ukweli kwavija nikujuwa kundawile na kuja kunichola. Mweye hamukujuwile kuja kundawile hebu kuja kunichola. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mweye motagusa kwa nzila zoyotagusa wanhu, niye simtagusa munhu yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lakini hata nahatagusa, notagusa goya kwavija sili niiyeka bule, nahamoja na Tata yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yandikigwa mna ga Malagizo genu kamba usindila wa wanhu wabili wahailumba, gaja gowolonga ga ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Niye noisindila mwenyego, na Tata yanhumile vivija konisindila.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wamuuza, “Tatako kakwahi?” Yesu kawedika, “Hamnijuwile niye hebu Tatangu. Maza munijuwile niye, vivija mwahamjuwile Tatangu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kalonga gano gose viyakalile kofundiza Mng'anda ya Mulungu, mdigati hakikigwe kiya cha kulavila sadaka. Kuduhu munhu yamgogile, kwavija saa yake ikala hainavika. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu kawalongela kabili, “Niye nosegela, mweye monizahila, lakini mofa na nzambi zenu. Hamudaha kuchola kuja kunyhola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Avo wakulu wa Wayahudi wauza, “Kolonga hatudaha kuchola hanhu kuyochola. Vino kolonda kuikoma mwenyego?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kawedika, “Mweye mwa wanhu wa mwiisi ino, lakini niye nolawa kuulanga. Mweye molawa mumuno mwiisi, lakini niye silawa mwiisi bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lekaavo niwalongeleni mofa na nzambi zenu. Mofa na nzambi zenu kamba hamulonda kutogola kamba ‘Niye ayo Heyo.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wamuuza, “Gweye kwa nani?” Yesu kawedika, “Niwalongeleni haichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ninazo mbuli nyingi za kulonga kumwenu, nyingi za kuwatagusa. Hata ivo ija yanhumile ni mkweli, na niye nowalongela wanhu wa mwiisi kija kimhulike kumwake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wakala hawajuwile kamba Yesu kakala kolonga mbuli ya Tata. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Avo kawalongela, “Mwahamwinula uchanha Mwana wa Munhu, mojuwa kamba, ‘Niye ayo Heyo,’ abaho mojuwa kamba sitenda mbuli yoyose kwa udahi wangu, lakini nolonga kija kiyanilagize Tata nonge. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na heyo yanhumile kahamoja na nene, handekile niiyeka bule kwavija siku zose notenda kija kimnogele.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Wanhu wengi wamuhulike Yesu yolonga mbuli zino wamtogola. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Avo Yesu kawalongela Wayahudi waja wamtogole, “Kamba mwahatogola mafundizo gangu, mwa wanahina zangu kweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Avo moijuwa kweli, na kweli yowatenda mulekesigwe.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wamwidika, “Tweye twa lukolo lwa Abulahamu na hatunakuwa watumwa wa munhu yoyose. Habali kotulongela ‘Tolekesigwa’?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kawalongela, “Nowalongeleni ukweli, munhu yoyose yotenda nzambi mtumwa wa nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mtumwa hali munhu wa lukolo siku zose, lakini mwana ayo munhu wa lukolo siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kamba Mwana yahawalekesa, na mweye molekesigwa kweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nojuwa mwa lukolo lwa Abulahamu. Lakini molonda kunikoma, kwavija hamgatogola mafundizo gangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nowalongela kija kiyanilagusile Tatangu, lakini mweye motenda kija kimulongeligwe na tata yenu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wamwidika, “Tata yetu Abulahamu.” Yesu kawedika, “Maza mukalile wana wa Abulahamu, mwahatendile mbuli zizija ziyatendile heyo. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Niwalongela ukweli umhulike kwa Mulungu, lakini molonda kunikoma. Abulahamu hatendile kamba vivo! ");
INSERT INTO kdc2014_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Motenda kiyatendile tata yenu.” Wamwidika, “Mulungu yaiyeka ayo Tata itwilinayo hatuli wana wa kuvikila, tweye twa wanage too.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kawalongela, “Maza Mulungu yakalile Tata yenu, mwahaninogele, kwavija niza kulawa kwa Mulungu na sambi nabahano. Sizile kwa udahi wangu mwenyego, lakini kanhuma. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Habali hamjuwa kinonga? Kwavija hamudaha kutegeleza usenga wangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mweye mwa wana wa tataenu, Mwenembago, na mweye molonda kukweleleza kusulukila kwa tataenu. Kusongela mwaka kakala mkomaji na hemile muna ikweli, kwavija mduhu kweli mgati mmwake. Yahalonga uvizi, kolagusa viyali, kwavija heyo ni mvizi na tata wa uvizi. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lakini nowalongeleni ukweli, lekaavo hamnitogola bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nani imoja wenu yodaha kulagusa kamba nibananga? Kamba nolonga ukweli, habali hamunhogola? ");
INSERT INTO kdc2014_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Munhu wa Mulungu kotegeleza mbuli za Mulungu. Hata ivo, mweye hamuli wa Mulungu, lekaavo hamnitegeleza.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi wamuliga Yesu walonga, “Hatulongile goya kamba gweye kwa Msamalia na kuna kinyamkela?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kawedika, “Nabule kinyamkela. Nomtegeleza Tatangu lakini mweye monibeza. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sizahila nhogolwa yangu mwenyego. Lakini kabaho imoja yoizahila, heyo ayo yotagusa. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nowalongeleni ukweli, munhu yoyose yotogola mafundizo gangu honda yafe bule.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Avo, Wayahudi wamulongela, “Sambi tojuwa kamba gweye kuna kinyamkela! Abulahamu kafa, na watula ndagu wa Mulungu wafa, abaho gweye kolonga yoyose yotogola mafundizo gako honda yafe bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vino gweye kwa mkulu kubanza tata yetu Abulahamu? Heyo kafa, na watula ndagu wa Mulungu vivija wafa. Kogesa gweye kwa nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kawedika, “Nahaitogola mwenyego, nhogolwa ayo mduhu kinhu. Ija yonitogola niye ni Tatangu yumulonga Mulungu wenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mweye hamumjuwile bule, lakini niye nimjuwa. Nahalonga simjuwile, nokuwa mvizi kamba mweye. Lakini nimjuwa, na nozigoga mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tata yenu Abulahamu kadeng'helela viyachonile kipindi changu chakwiza, kachona na kadeng'helela.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wayahudi wamulongela Yesu, “Vino gweye hunapata hata miyaka malongo matano, kumonaze Abulahamu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kawedika, “Nowalongeleni ukweli, Abulahamu yang'hali hana vumbuka, niye nabaha.” ");
INSERT INTO kdc2014_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Abaho wadondola mabwe wampigisile, lakini Yesu kaifisa kalawanya Mng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu viyakalile kogenda, kamona munhu yavumbuke msuwameso. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wanahina zake wamuuza, “Mfundiza, nzambi gani imtendile munhu ino yavumbuke msuwameso? Vino heyo ayo yaitendile nzambi ayo hebu tatake na mamake?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kawedika, “Ino hailawilile kwavija heyo katenda nzambi hebu tatake na mamake watenda nzambi. Lakini kavumbuka msuwameso muladi udahi wa Mulungu woneke kumwake. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kwavija ing'hali imisi, tolondeka tusang'hane sang'hano ya ija yanhumile. Ikilo yovika, baho kuduhu munhu yodaha kusang'hana. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kipindi ning'hali mwiisi, niye na mulenge wa isi yose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Viyamambukize kulonga vino, Yesu katema mate hasi, kabuluga nhope kwa mate gaja, abaho kambaka mgameso munhu ija msuwameso. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yesu kamulongela, “Genda kasunhe kihanga chako hana dilamba da Siloamu.” Siloamu fambulo jake “Yatumigwe.” Avo munhu ija kachola, kasunha kihanga chake, kabwela yolola. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wanhu weli mmabehi nayo, na wanhu wamonile aho umwaka yopula, ing'hali hainalawilila mbuli ino, wauza, “Vino ino siyo munhu ija yakalile na kupula?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wanhu wayagwe walonga, “Iyo heyo,” lakini wayagwe walonga, “Aka, siyo heyo, kaigala nayo.” Avo munhu ija kalonga mwenyego, “Iyo niye.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wamuuza, “Vino kudahaze kulola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kawedika, “Munhu yokemigwa Yesu katenda nhope, kanibaka mgameso gangu, kanilongela nigenda Siloamu nikasunhe kihanga changu. Avo nichola, na bahaja vinisunhile nidaha kulola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wamuuza, “Munhu ayo kakwahi?” Kawedika, “Mmhane.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Abaho wamgala kwa Mafalisayo munhu ayo yakalile msuwameso. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu viyatendile nhope na kumuhonya munhu ayo yakalile msuwameso ikala siku ya Kubwihila. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Abaho Mafalisayo wamuuza kabili munhu ayo viyadahile kulola. Kawalongela, “Kanibaka nhope mgameso gangu, nisunha kihanga changu, na sambi nodaha kulola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo wayagwe walonga, “Munhu yatendile mbuli ino halawa kwa Mulungu bule, kwavija hadigoga lagizo da siku ya Kubwihila.” Lakini wayagwe walonga, “Vino munhu yotenda nzambi kodahaze kutenda unzonza kamba uno?” Avo, wakala waigolile. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Avo Mafalisayo wabwelela kumuuza munhu ayo, “Kulonga kakuhonya usuwameso wako. Gweye kolongaze mbuli ya munhu ayo?” Munhu ayo kawedika, “Mtula ndagu wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hata ivo wakulu wa Wayahudi hawalondile kutogola kamba kakala msuwameso na sambi kodaha kulola. Avo wawakema tatake na mamake, ");
INSERT INTO kdc2014_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wayahudi wawauza, “Vino ino ayo mwanenu? Yumulonga kavumbuka msuwameso, lelo kadahaze kulola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tatake na mamake wawedika, “Tojuwa kamba heyo ayo mwanetu, na tojuwa kamba kavumbuka msuwameso. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lakini hatujuwile sambi viyadahile kulola, wala hatumjuwile munhu yamuhonyile. Muuzeni mwenyego, heyo mkulu goya, kodaha kuwedika!” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tatake na mamake walonga vino kwavija wakala wowadumba wakulu wa Wayahudi, kwavija Wayahudi walonga munhu yoyose yolonga komtogola Yesu kamba ayo Kilisito Mkombola kowingigwa mng'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lekaavo tatake na mamake walonga, “Heyo mkulu goya, muuzeni!” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mwanza wa kabili wamkema munhu ija yavumbuke msuwameso, wamulongela, “Iduile kwa Mulungu kamba kolonga ukweli! Tojuwa kamba munhu ino yakuhonyile kotenda nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Munhu ayo kawedika, “Mmhane kamba munhu ayo kotenda nzambi hebu hatenda bule. Kinhu kimoja kinjuwile, ng'hala silola, sambi nolola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wamuuza, “Vino kakutendela choni? Kakuhonyaze usuwameso wako?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kawedika, “Nimala kuwalongela, lakini hamulonda kutegeleza. Vino habali molonda kuihulika kabili? Hebu na mweye vivija molonda kuwa wanahina zake?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wamuliga na kumulongela, “Gweye kwa mwanahina wa munhu ayo! Tweye twa wanahina wa Musa. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tojuwa kamba Mulungu kalonga na Musa, lakini kwa munhu ayo, hatujuwile kolawa kwahi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Munhu ija kawedika, “Mweye monyazanya! Hamkujuwile kuyalawile, lakini kanitenda nidahe kulola! ");
INSERT INTO kdc2014_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tojuwa kamba Mulungu hawategeleza wanhu wotenda nzambi, lakini kowategeleza wanhu waja womtegeleza heyo na kusang'hana gaja goyolonda. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tangu chanduso cha isi yose kuduhu munhu yahulike kamba munhu yoyose kamuhonya munhu yavumbuke msuwameso. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Maza munhu ino halawile kwa Mulungu, sambi yadahe kutenda mbuli ino.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wamwidika, “Gweye kuvumbuka na kukulila mzizambi abaho kolonda kutufunza tweye?” Avo wamuwinga mna ing'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu viyahulike kamba wamuwinga mng'anda ya kumpula Mulungu, kamona munhu ayo kamuuza, “Vino gweye komtogola Mwana wa Munhu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Munhu ayo kamwidika, “Go mkulu, nongela ayo nani, mhate kumtogola!” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kamulongela, “Kumona, ayo heyo yolonga na gweye sambi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Munhu ayo kalonga, “Notogola Mndewa.” Abaho kamfugamila Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kalonga, “Niza mwiisi ino kuwatagusa wanhu, avo waja hawalola walole na waja wogesa wolola waleke kulola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo wayagwe wakalile hamoja na Yesu viwamuhulike kolonga avo, wamuuza, “Vino kolonga na tweye vivija hatulola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kawedika, “Maza mkalile hamulola, sambi mutende nzambi. Lakini kwavija molonga molola, avo mung'hali motenda nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu kalonga, “Nowalongela ukweli, munhu yoyose yoleka kubitila hana ulwivi lwa ng'hondolo, lakini kokwela na kubitila nzila iyagwe, munhu ayo mbavi na mbokaji. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Munhu ija yobitila hana ulwivi ayo msusilaji wa ng'hondolo. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mkalizi wa ulwivi komvugulila ulwivi, ng'hondolo wokihulika kifengwa cha msusilaji viyowakema ng'hondolo zake kwa matwaga gao, kowalava kunze. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yahawalava kunze kowalongolela, na ng'hondolo womkweleleza kwavija wakijuwa kifengwa chake. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Honda wamkweleleze munhu yoyose iyagwe, lakini womkimbila munhu ayo kwavija hawakijuwile kifengwa chake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kawalongela lusimo luno lakini hawajuwile fambulo jake. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Avo Yesu kalonga kabili, “Nowalongeleni ukweli, niye ayo lwivi lwa ng'hondolo. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wose wayagwe wezile kukisogo changu wabavi na wabokaji, lakini ng'hondolo hawawategeleze bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Niye ayo lwivi. Munhu yoyose yobitila kumwangu kokomboligwa, kokwingila na kulawa kuzahila chakuja. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbavi kokwiza muladi yebe, yakome, na kunanga. Niye niza muladi muwe na ugima, ugima umemile. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Niye ayo msusilaji yanogile. Msusilaji yanogile koulava ugima wake mbuli ya ng'hondolo. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Munhu wa kulipigwa yeli siyo msusilaji na ng'hondolo haweli wake, yahamona mbwizi kokwiza, kowaleka ng'hondolo na kukimbila. Avo mbwizi kogoga imoja na wayagwe wopwililika. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Munhu wa kulipigwa kokimbila kwavija heyo munhu wa kulipigwa kwiiyeka, na hawatonga bule ng'hondolo. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Niye ayo msusilaji yanogile. Niwajuwa ng'hondolo zangu na wao wonijuwa niye, ");
INSERT INTO kdc2014_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kamba Tata viyonjuwa niye, na niye vinimjuwa Tata. Na niye nodaha kufa mbuli yao. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Abaho ninao ng'hondolo wayagwe siyo wa mdizizi dino. Vivija nolondeka niwagale, wokihulika kifengwa changu, nao wokuwa bumbila dimoja da msusilaji imoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tata koninogela kwavija noulava ugima wangu kwa kulonda mwenyego, muladi nidahe kuubweza kabili. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kuduhu munhu youlava ugima wangu. Niye noulava kwa kulonda mwenyego. Ninao udahi wa kuulava, na udahi wa kuubweza kabili. Vino vivo viyanilagize Tata nhende.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mbuli zino za Yesu ziwatenda Wayahudi waigole kabili. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wanhu wengi wakala wolonga, “Kana kinyamkela, vivija kana kibozi mbwelela! Habali mumtegeleza?” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lakini wanhu wayagwe wakala wolonga, “Munhu yeli na kinyamkela hadaha kulonga kamba vino! Vino kinyamkela kodahaze kuwahonya wasuwameso?” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ako Yelusalemu kukala na nyimwili nyimwili ya kulavigwa kwa Ng'anda ya Mulungu kwa Mulungu. Kikala kipindi cha kihuhwe. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu kakala kotembela mna uluhelengo lwa Sulemani hana Ing'anda ya Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wayahudi wamzunguluka, wamuuza, “Vino gweye kotugaza mbaka lini? Tulongele fulu ipile, gweye kwa Kilisito Mkombola?” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kawedika, “Nimala kuwalongeleni, lakini hamnhogola. Mbuli zinhenda kwa udahi wa Tatangu zonilagusa, ");
INSERT INTO kdc2014_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","lakini honda mtogole, kwavija hamuli ng'hondolo zangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ng'hondolo zangu woihulika sauti yangu, niye niwajuwa na wao wong'holeleza. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nowagwaa ugima wa mazuwa gose, na honda wafe bule. Kuduhu munhu yonda yawasole mmakono gangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tatangu yanigwelele awo ayo mkulu kubanza wose, na kuduhu yodaha kuwasola mmakono ga Tata. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Niye na Tata twa wamoja.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Abaho Wayahudi wadondola mabwe kabili wamtowe Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kawalongela, “Nhenda mbuli nyingi zinogile mgameso genu zija ziyanigwelele Tata nhende, kwa mbuli gani molonda kunhowa mabwe?” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahudi wamwidika, “Hatulonda kukutowa na mabwe mbuli ya mbuli yoyose inogile, lakini mbuli ya ukuduzi wako! Gweye kwa munhu, lakini koitenda mwenyego kwa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kawedika, “Vino hayandikigwe mna Ikitabu chenu cha malagizo kamba Mulungu kalonga, ‘Mweye mwa walungu?’ ");
INSERT INTO kdc2014_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mulungu kawakema ‘walungu’ wanhu waja wagweleligwe usenga wake, na tweye tojuwa kamba Maandiko Gang'alile golonga ukweli siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kamba viili kumwangu, Tata kanisagula na kanhuma mwiisi. Yokuwaze kabili mweye molonga nomkudula kwavija nonga niye na Mwana wa Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kamba sitenda gaja goyolonda Tatangu nhende, sekemunhogole. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lakini kamba nogatenda, hata kamba hamnitogola niye, molondeka mutogole gaja ganisang'hane, muladi mujuwe kamba Tata kokala mgati mmwangu na niye nokala mgati mwa Tata.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bahaja walonda kumgoga Yesu, lakini kawalawa mmakono gao. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Abaho Yesu kabwela kabili mwambu wa lwanda lwa Yolidani mbaka aho haakalile Yohana yobatiza wanhu, kakala kuko. ");
INSERT INTO kdc2014_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wanhu wengi wamcholela, walonga, “Yohana hatendile unzonza, lakini kila kinhu kiyalongile mbuli ya munhu ino cha ukweli.” ");
INSERT INTO kdc2014_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wanhu wengi wa ako wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Munhu yakemigwe Lazalo yakalile kudibuga da Betania kakala mtamu. Betania dijo buga diwakalile Malia na mkulu wake Mata. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia ino ayo yambakaze Mndewa mavuta gonung'hila goya mmagulu na kuhangusa kwa mvili zake. Lazalo lumbu jake ayo yakalile mtamu. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Avo lumbu zake Lazalo wamgalila Yesu usenga, “Mndewa, mbwigako yuumnogele mtamu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu viyahulike avo, kalonga, “Utamu awo honda ugale ifa. Uno ulawilila kugala nhogolwa kwa Mulungu, na vivo vonda iwe kwa Mwana wa Munhu kobokela nhogolwa.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kawanogela Mata na mdodo wake Malia na lumbu jao Lazalo. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Viyabokele usenga uno kamba Lazalo kakala mtamu, Yesu kongeza siku mbili kukala aho haakalile. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Abaho Yesu kawalongela wanahina zake, “Tubweleni Yudea.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanahina wamwidika, “Mfundiza, sambi sambi Wayahudi wa aho walonda kukutowa mabwe, abaho kofunga mwanza ubwele kuko?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kalonga, “Vino imisi yaduhu masaa longo na mabili? Avo wanhu wogenda imisi hawaikwala, kwavija wowona mulenge wa mwiisi ino. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lakini kamba wahagenda ikilo woikwala kwavija waduhu mulenge.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu viyamambukize kulonga avo, kalonga, “Mbwigaetu Lazalo kawasa, lakini nochola kumulamusa.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanahina wamwidika, “Mndewa, kamba kawasa kohona.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu kakala yofambula kamba Lazalo kafa, lakini wanahina zake wagesa kakala yolonga kuwasa utulo. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Avo Yesu kawalongela fulu ipile, “Lazalo kafa, ");
INSERT INTO kdc2014_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lakini nodeng'helela mbuli yenu kwavija sikalile nayo muladi mutogole. Leka tucholeni kumwake.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaso yakemigwe Pacha kawalongela wanahina wayage, “Tucholeni hiko hamoja na Mfundiza, tukafe nayo!” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu viyavikile ako, kaluvika lukuli lwa Lazalo lwa mdipanga siku nne. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ikala utali wa kamba kilometa ndatu kulawa Yelusalemu, ");
INSERT INTO kdc2014_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Wayahudi wengi weza kuwalola Mata na Malia na kuwagoga makono mbuli ya ifa ya lumbu jao. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata viyahulike kamba Yesu kakala yokwiza, kalawa kunze kumbokela, lakini Malia kasigala mng'anda. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata kamulongela Yesu, “Mndewa, maza ukalile baha lumbu jangu sambi yafe bule! ");
INSERT INTO kdc2014_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakini hata sambi nojuwa kamba Mulungu kokugwaa kinhu chochose kiumpula.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kamulongela, “Lumbu jako kozilibuka.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata kedika, “Nojuwa kamba kozilibuka mna isiku ya uhelelo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kamulongela, “Niye ayo uzilibuko na ugima. Wanhu wose wonhogola wokuwa wagima, hata wahafa, ");
INSERT INTO kdc2014_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na wanhu wose weli wagima na wonhogola niye honda wafe bule. Kozitogola mbuli zino?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata kedika, “Ona Mndewa, notogola kamba gweye ayo Kilisito Mkombola, Mwana wa Mulungu ija yezile mwiisi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata viyalongile avo, kabweleganya mng'anda, kamkema mkulu wake Malia kinyelegezi. Kamulongela, “Mfundiza kabaha, kokukema gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia viyahulike avo, kenuka himahima kamcholela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kakala yang'hali hanavika mkijiji, lakini kakala hanhu aho haamting'hane Mata. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Avo, Wayahudi wakalile mng'anda na Malia womgoga makono, wamkweleleza viwamone kenuka himahima na kuchola kunze. Wagesa kochola kudipanga kulila. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia kavika aho haakalile Yesu, bahaja viyamone, kamfugamila, kalonga, “Mndewa, maza ukalile baha, lumbu jangu sambi yafe bule!” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu viyamone Malia kolila, na Wayahudi wakalile nayo wolila vivija, kona usungu na kanyunyuwala muumoyo. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu kawauza, “Mumzikila kwahi?” Wamwidika, “Mndewa izo ulole.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalila. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wayahudi walonga, “Loleni viyamnogele Lazalo.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakini wanhu wayagwe walonga, “Kamuhonya munhu msuwameso, hadahile vilihi kumtenda Lazalo sekeyafe?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu viyakalile yang'hali konyunyuwala muumoyo, kachola kudipanga, dikalile mhango igubikigwe na dibwe. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kawalagiza, “Segezeni idibwe!” Mata, lumbu wa munhu ija yafile, kedika, “Mndewa, kwiza honung'ha bundo, kwavija kana siku nne toka yazikigwe!” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kamulongela, “Vino sikulongele bule wahatogola kouwona ukulu wa Mulungu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wadikwesa hamgwazo idibwe, Yesu kalola uchanha kalonga, “Nokugwaa nhogolwa gweye Tata, kwavija konhegeleza. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nojuwa kamba siku zose konhegeleza, lakini nolonga vino mbuli ya wanhu weli hano, ili watogole gweye kunhuma.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Viyamambukize kulonga avo, kakemelela, “Lazalo, lawa kunze!” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazalo kalawa kunze kuno makono gake na magulu gake gazingilizigwa sitili, na leso mkihanga chake. Yesu kawalongela, “Mfunguleni mulekeni yachole.” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wayahudi wengi wacholile kumtembelela Malia wachona kiyatendile Yesu, wamtogola. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lakini wanhu wayagwe wabwela kwa Mafalisayo, wawalongela kija kiyatendile Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Avo Mafalisayo na wakulu wa walava nhosa waiting'hana na wanhu wa mkitala waiuza, “Vino tutende choni? Loleni mbuli za unzonza ziyotenda munhu ino! ");
INSERT INTO kdc2014_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kamba twahamuleka yagendelele vivo, kila munhu komtogola, na wakulu wa Walumi wokwiza na kuinanga Ng'anda yetu ya Mulungu na isi yetu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Imoja wao, yakemigwe Kayafa, yakalile Mkulu wa walava nhosa, kalonga, “Mweye mwa wabozi! ");
INSERT INTO kdc2014_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Vino hamona kamba vinoga ng'hani kumwenu munhu imoja yafe mbuli ya wanhu, kubanza isi yose inangigwe?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Halongile vino kwa kugesa mwenyego, lakini kwavija kakala Mkulu wa walava nhosa mwaka awo, kakala yolagula kamba Yesu kofa mbuli ya Wayahudi, ");
INSERT INTO kdc2014_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na siyo kwa Wayahudi waiyeka, lakini vivija kuwagala hamoja wanhu wa Mulungu wapwililike wawe wamoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kulawa siku dijo wakulu wa Wayahudi wamkalila kiseto Yesu wamkome. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Avo Yesu hacholile kunze kunze mwiisi ya Yudea, lakini kasegela kachola behi na luwala, kunadibuga dikemigwe Efulahimu, kakala kuko na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kipindi cha nyimwili nyimwili ya Pasaka ya Wayahudi kikala behi kuvika, avo wanhu wengi wachola Yelusalemu ili waisunhe, nyimwili nyimwili ing'hali hainavika. ");
INSERT INTO kdc2014_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wakala womzahila Yesu, na viwaiting'hane Mng'anda ya Mulungu, waiuza, “Vino mogesaze? Hambe Yesu honda yeze mwiinyimwili nyimwili?” ");
INSERT INTO kdc2014_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakulu wa walava nhosa na Mafalisayo walagiza kamba munhu yoyose kakujuwa kuyali Yesu yalonge, ili wamgoge. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zing'hali siku sita kuvika nyimwili nyimwili ya Pasaka, Yesu kachola Betania, ukayake Lazalo, ayo iyamzilibule kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wanhu wamtandila lujo lwa ichungulo baho, Mata ayo yakalile yomtaza kugola. Lazalo kakala imoja mna iwanhu wakalile woja na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Abaho Malia kasola nusu lita ya mavuta gonung'hila goya ga bei ng'hulu ng'hani, kambakaza Yesu mmagulu, kagahangusa kwa mvili zake. Ng'anda yose ikala bwiki bwiki mbuli ya gaja gamavuta gonung'hila goya. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Isikaliote imoja wa wanahina zake Yesu, ayo yonda yamuhinduke Yesu, kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Vino habali mavuta gano hagauzigwe kwa sente magana madatu, na sente azo wagweleligwe wanhu wakiwa?” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kalonga vino siyo kwavija kakala yowatonga wakiwa, lakini kwavija kakala mbavi. Kakala mpapaji wa mkoba wa zisente, na miyanza mingi kakala yosola sente. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lakini Yesu kalonga, “Sekemumgaze! Mulekeni yatende vivo mbuli ya siku yangu ya kuzikigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wanhu wakiwa mokala nao siku zose, lakini hamkala na niye siku zose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi wengi wahulika kamba Yesu kakala Betania, avo wachola kuko, siyo mbuli ya Yesu yaiyeka lakini vivija kumona Lazalo, ayo iyamzilibule. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Avo wakulu wa walava nhosa wakala kiseto cha kumkoma Lazalo vivija, ");
INSERT INTO kdc2014_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwavija mbuli ya Lazalo Wayahudi wengi wakala wowalema na kumtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Imitondo yake lunhu mkulu lwizile kuna inyimwili nyimwili ya Pasaka luhulika kamba Yesu kakala yokwiza Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Avo wabena mibunho ya mbiki wa mtende na wachola kumbokela, wakemelela, “Mulungu yatogolwe! Mulungu yamtambikile munhu ayo yokwiza kwa twaga da Mndewa! Mulungu yamtambikile Mndewa wa Izilaeli!” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu kamona mwana mhunda, kamkwela mumgongo, kamba Maandiko Gang'alile vigalonga, ");
INSERT INTO kdc2014_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sekeudumbe, isi ya Sayuni! Hano kokwiza Mndewa wako, yakwelile mumgongo wa mwana mhunda.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kipindi acho wanahina zake hawaijuwile mbuli ino. Lakini Yesu viyenuligwe muukulu, wakumbuka kamba Maandiko Gang'alile galonga mbuli ino na wamtendela kamba vivo. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wanhu wakalile na Yesu kipindi viyamkemile Lazalo kulawa mdipanga na kumzilibula kulawa kwa wafile, wakala wogabwililisa gaja galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lekaavo lunhu lwa wanhu luchola kumbokela, kwavija luhulika unzonza uno uyatendile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Abaho Mafalisayo wailongela, “Mona, hatudaha kutenda chochose! Loleni wanhu wose wa mwiisi womkweleleza!” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wagiliki wayagwe wakala mumo mna iwanhu wacholile Yelusalemu kutambika mna ikipindi cha nyimwili nyimwili ya Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wachola kwa Filipo mwenekae wa Betisaida mwiisi ya Galilaya walonga, “Go mkulu, tolonda tumone Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo kachola na kumulongela Andeleya, abaho wose wabili wachola kumulongela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kawedika, “Sambi kipindi kivika cha Mwana wa Munhu kubokela ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nowalongeleni ukweli, mhule ya uhemba yosigala imoja siku zose mbaka ilagale hasi ife. Ila yahafa baho yolela na kuwa mhule nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Munhu yoyose younogela ugima wake kowagiza, lakini munhu yoyose yowihila ugima wake mwiisi ino kowika kwa ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Munhu yoyose yolonda kuwa msang'hanaji wangu kolondeka yanikweleleze, avo msang'hanaji wangu kokuwa na niye aho honda niwe. Tatangu komgwaa nhogolwa munhu yoyose yonisang'hanila. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sambi loho yangu yoluma, vino nongeze? Nonge, ‘Tata, sambiutende kipindi kino kivike kumwangu’? Lakini lekaavo niza ili nibite kipindi kino cha madununzo. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, uditogole twaga jako!” Abaho sauti ihulikigwa kulawa kuulanga, “Niditogola, na notenda vivo kabili.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lunhu lwimile aho luihulika sauti ayo, na wanhu wayagwe walonga, “Mulungu kaduma.” Kuno wayagwe walonga, “Msenga wa kuulanga kalonga nayo!” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lakini Yesu kawalongela, “Sauti ino haihulikigwe mbuli ya niye, lakini mbuli yenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sambi acho kipindi cha wanhu wa mwiisi ino kutagusigwa, na Mwenembago mkulu wa mwiisi ino kokwasigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kipindi nahenuligwa uchanha kulawa hasi, nomkwega kila munhu kumwangu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kwa ulonzi uno Yesu kalagusa ifa yonda yafe. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lunhu lwa wanhu lumwidika, “Malagizo getu gotulongela kamba Kilisito Mkombola kokuwa mgima siku zose. Habali kabili gweye kolonga Mwana wa Munhu kolondeka yenuligwe uchanha? Vino ino Mwana wa Munhu ayo nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu kawedika, “Mulenge wokala na mweye kwa kipindi kidodo. Gendeleleni na mwanza kung'hali na mulenge muladi ziza sekediwezile, kwavija munhu yotembela mdiziza hajuwa kuja kuyochola. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Utogoleni mulenge baho mulinao muladi muwe wanhu wa mulenge.” Yesu viyamambukize kulonga avo, kasegela, wanhu hawamonile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hamoja Yesu kasang'hana unzonza mgameso gao, lakini hawamtogole bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Avo kiyalongile mtula ndagu wa Mulungu Isaya kilawilile. “Mndewa, nani yatogole usenga wetu utulongile? Vino Mulungu kalagusa udahi wake kwa nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Avo hawadahile kutogola, kwavija Isaya vivija kalonga, ");
INSERT INTO kdc2014_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mulungu kagafumba meso gao kazifunga nzewele zao, muladi meso gao sekegadahe kulola, na nzewele zao sekezidahe kujuwa. Sekewanibwelele niye, Mulungu kolonga, na niye nidahe kuwahonya.” ");
INSERT INTO kdc2014_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kalonga vino kwavija kawona ukulu wa Yesu na kalonga mbuli yake. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Avo wakulu wengi wa Wayahudi wamtogola Yesu, lakini mbuli ya Mafalisayo hawadahile kulonga mbuli zake kunze kunze, kwavija wadumba kuwingigwa mna ing'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwavija walonda nhogolwa za wanhu kubanza nhogolwa za Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu kakemelela, “Munhu yoyose yonhogola niye, hanhogola niye niiyeka lakini vivija komtogola ija yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yoyose yonyona niye vivija komona ija yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Niye niza mwiisi niwe mulenge, ili munhu yoyose yonhogola sekeyasigale mdiziza. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Munhu yoyose youhulika usenga wangu na halonda kuutogola, niye simtagusa bule, kwavija sizile kuwatagusa wanhu wa mwiisi, ila kuwakombola. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wose wonilema niye na kuulema usenga wangu kabaho imoja yonda yawataguse. Mbuli zinongile zowatagusa mwiisiku ya uhelelo! ");
INSERT INTO kdc2014_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kwavija silongile kwa udahi wangu, lakini Tata yanhumile kanilagiza vinondeka kulonga. ");
INSERT INTO kdc2014_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na niye nojuwa kamba lagizo jake dogala ugima wa mazuwa gose. Avo nolonga gaja gayanilongele Tata nonge.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dikala ding'hali siku dimoja kuvikila nyimwili nyimwili ya Pasaka. Yesu kajuwa kamba kipindi chake kivika cha kusegela mwiisi ino na kuchola kwa Tatake. Yesu kakala yawanogele ng'hani wanhu zake weli mwiisi, kawanogela siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na wanahina zake wakala muulujo lwa ichungulo. Mwenembago kakala yamalile kwingila muumoyo wa Yuda mwanage Simoni Isikaliote, yamuhinduke Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu kajuwa kamba Tata kamgwaa vinhu vose mmakono gake. Na kajuwa kamba kalawa kwa Mulungu na kochola kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Avo kenuka muulujo, keka hamgwazo mgolole wake, kasola kikumbi, kaifunga mkigudi. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Abaho kagida mazi mwiinongo, kasonga kuwasunha magulu wanahina zake na kuwahangusa kwa kija kikumbi kiyaifungile mkigudi. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesu kavika kwa Simoni Petulo, lakini Petulo kamuuza, “Mndewa, vino gweye kolonda kunisunha magulu niye?” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kamwidika, “Kinhenda sambi gweye hukijuwa bule, lakini baho kumwande kokijuwa.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo kalonga, “Aka, gweye hunisunha magulu gangu hata siku dimoja!” Yesu kamwidika, “Kamba sikusunha magulu gako, honda uwe mwanahina wangu bule.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo kamwidika, “Mndewa, sekeusunhe magulu gangu gaiyeka, lakini vivija sunha makono gangu na pala jangu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kamulongela, “Wanhu wose wakogile waduhu dikwe na hawalondeka kuisunha, lakini magulu gao gaiyeka. Mwenye mung'ala, lakini siyo wose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kakala yajuwile mwaka nani yonda yamuhinduke, lekaavo kalonga siyo wose mung'ala. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu viyamambukize kuwasunha magulu gao, kasola uja umgolole wake, kabwela hanhu hake haakalile muulujo. Kawauza, “Mujuwa habali niye nhenda vino kumwenu? ");
INSERT INTO kdc2014_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mweye mong'hema niye Mfundiza na Mndewa, molonga goya kwavija vivo nili. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Niye Mndewa wenu na Mfundiza, niwasunha magulu genu. Avo na mweye molondeka muisunhe magulu genu. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Niye niwalagusila nzila, avo na mweye mutende kamba vija viniwatendeleni. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nowalongeleni ukweli, mtumwa hali mkulu kubanza mkulu wake, na msenga hali mkulu kubanza ija yamtumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sambi muujuwa ukweli uno, momweda kamba mwahasang'hana! ");
INSERT INTO kdc2014_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Silonga mweye mose, niwajuwa waja waniwasagule. Lakini Maandiko Gang'alile galongile vino galawilile, ‘Munhu ija inidile nayo lujo lwangu konihinduka.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nowalongeleni sambi gang'hali haganalawila, muladi gahalawilila, mutogole kamba, ‘Niye ayo Heyo.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nowalongeleni ukweli, yoyose yombokela munhu inimtuma konibokela niye, na yoyose yonibokela niye kombokela ija yanhumile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu viyamambukize kulonga avo, kona usungu ng'hani muumoyo wake, kalonga fulu ipile, “Nowalongeleni ukweli, imoja wenu konihinduka.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wanahina wailola, kuno wonyawanyawa nani yolongigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwanahina imoja, ija yanogeligwe ng'hani na Yesu, kakala behi na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo kamfunya, kamulongela, “Muuze, komulonga nani.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Avo mwanahina ija kamkwesela behi ng'hani Yesu, kamuuza, “Mndewa, komulonga nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kamwidika, “Munhu ija yonda nimgwee kihande cha gate chonda nizanhike mbakuli, ayo munhu mwenyego.” Abaho kasola kihande cha gate, kazanhika, kamgwaa Yuda mwanage Simoni Isikaliote. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bahaja Yuda viyasolile digate, Mwenembago kamwingila. Yesu kamulongela, “Tenda himahima kiulonda kutenda!” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kuduhu munhu mna iwaja wakalile muulujo yajuwile habali Yesu yamulongele vivo. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwavija Yuda kakala yopapa mkoba wa zisente, wanahina wayagwe wagesa Yesu kamulongela yachole kugula kija kilondeke mwiinyimwili nyimwili ya Pasaka, hebu yawagwee kinhu wakiwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bahaja Yuda kadibokela gate, kachola kunze. Ikala ikilo. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda viyasegele, Yesu kalonga, “Sambi ukulu wa Mwana wa Munhu wogubuligwa, na ukulu wa Mulungu wogubuligwa mgati mmwake. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na kamba ukulu wa Mulungu wogubuligwa kubitila heyo, baho Mulungu kougubula ukulu wa Mwana wa Munhu kumwake mwenyego, na kotenda vivo himahima. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu, nokala na mweye kipindi kidodo. Monizahila, lakini nowalongeleni gaja ganiwalongele wakulu wa Wayahudi, ‘Hamudaha kuchola kuja kunyhola.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nowagweleleni lagizo da sambi, Muinogele. Kamba niye viniwanogele, na mweye muinogele vivo. ");
INSERT INTO kdc2014_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mwahainogela, baho kila munhu kojuwa kamba mweye mwa wanahina zangu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo kamuuza, “Mndewa, kochola kwahi?” Yesu kamwidika, “Hudaha kuniwinza sambi kuja kunyhola, lakini baho kumwande koniwinza.” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo kamuuza, “Mndewa, habali sidaha kukuwinza sambi? Niye nodaha kufa mbuli ya gweye!” ");
INSERT INTO kdc2014_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kamwidika, “Vino gweye kweli kodaha kufa mbuli ya niye? Nokulongela ukweli, nzogolo yang'hali hanakwika konibela miyanza midatu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu kawalongela, “Sekemudumbe na kunyawanyawa. Momtogola Mulungu, nhogoleni na niye vivija. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mng'anda ya Tatangu kuna magati mengi, maza haili vivo sambi niwalongele. Nochola kuwatandileni hanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nahachola na kuwatandileni hanhu, nobwela na kuwasola ili mkale na niye aho honikala. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muijuwa nzila ya hanhu honichola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso kamulongela, “Mndewa, hatukujuwile kwahi kuuchola, vino toijuwaze inzila?” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kamwidika, “Niye ayo nzila, ukweli na ugima. Kuduhu munhu yochola kwa Tata kamba habitile kumwangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesu kawalongela, Maza munjuwile niye, mwahamjuwile na Tatangu vivija. Kulawa sambi na kugendelela mumjuwa na mumona.” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo kamulongela, “Mndewa, tulagusile Tata, acho tukilonda tu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kamwidika, “Nikala na mweye siku zose, avo lelo hunjuwile vilihi Filipo? Munhu yoyose yanyonile niye, kamona Tata. Habali gweye koniuza niwalagusile Tata? ");
INSERT INTO kdc2014_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipo, vino gweye hutogola kamba nokala mgati mwa Tata na Tata kokala mgati mmwangu? Mbuli ziniwasimulileni hazilawa kumwangu. Tata, yokala mgati mmwangu kosang'hana mwenyego. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nhogoleni nahalonga kamba nokala mgati mwa Tata na Tata kokala mgati mmwangu. Kamba siyo vivo, togoleni mbuli ya vinhu vinhenda. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nowalongeleni ukweli, wose wonhogola wotenda gaja ganhendile, wotenda makulu ng'hani kubanza gano, kwavija nochola kwa Tata. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na nowatendela chochose kimpula kwa twaga jangu, ili ukulu wa Tata woneke kubitila kwa Imwana. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mwahanipula kinhu chochose kwa twaga jangu, nowatendela. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mwahaninogela, mogagoga malagizo gangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nompula Tata, nayo kowagwaa Mtazaji iyagwe, kokala na mweye siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Heyo ayo Loho Yang'alile yolagusa ukweli wa Mulungu. Wanhu wa mwiisi hawadaha kumbokela, kwavija hawamona hebu kumjuwa. Lakini mweye mumjuwa kwavija kokala na mweye na kamgati mmwenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nahachola siwaleka mwiiyeka kamba wakiwa, nowabweleleni. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","King'hali kipindi kidodo wanhu wa mwiisi honda wanyone kabili, lakini mweye monyona. Kwavija namgima, na mweye vivija mokuwa wagima. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Siku ayo yahavika, mojuwa kamba namgati mwa Tatangu, na mweye mwa mgati mmwangu, na niye na mgati mmwenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Wanhu wose wogatogola malagizo gangu na kugagoga, wao woninogela. Tatangu kowanogela wose woninogela niye, na niye vivija nowanogela wao na kuilagusa kumwao.” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, siyo Yuda Isikaliote, kalonga, “Mndewa, habali gweye koilagusa kumwetu na siyo kwa wanhu wa mwiisi?” ");
INSERT INTO kdc2014_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kamwidika, “Munhu yoyose yoninogela niye kogagoga mafundizo gangu. Tatangu komnogela munhu ayo, niye na Tatangu tomwizila na kukala nayo. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Munhu yoyose hanogela niye hagagoga mafundizo gangu. Mafundizo gamuhulike siyo gangu, lakini golawa kwa Tata, yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Niwalongela mbuli zino ning'hali hamoja na mweye. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tatangu kowagalila Mtazaji, Loho Yang'alile kwa twaga jangu, kowafundiza vinhu vose na kuwakumbusa gose ganiwalongele. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nowalekela tindiwalo, nowagwaa tindiwalo jangu. Siwagwelela bule kamba viwowagwelela wanhu wa mwiisi. Sekemudumbe na kunyawanyawa. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Munihulika viniwalongele, ‘Nosegela, lakini nowabwelela.’ Maza muninogele mwahadeng'helele kuwa nochola kwa Tata, kwavija heyo ayo mkulu kubanza niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Niwalongela mbuli zino sambi zing'hali hazina lawilila ili zahalawilila, mutogole. ");
INSERT INTO kdc2014_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Silonga ng'hani na mweye, kwavija Mwenembago ayo mkulu wa isi ino kokwiza. Heyo kaduhu nguvu kumwangu, ");
INSERT INTO kdc2014_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini wanhu wa mwiisi wolondeka wajuwe kamba nomnogela Tata, lekaavo notenda kila kinhu kamba viyonilagiza. “Inukeni, tusegele. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Niye ayo mzabibu wa kweli, na Tatangu ayo mulimaji. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila tambi dileka kulela mgati mmwangu kodikanha, na kodidahulila kila tambi dilela matunda, ili dilele ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mweye mung'ala mwaka kwa mafundizo ganiwagwelele. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaleni mgati mmwangu, na niye nokala mgati mmwenu. Tambi hadidaha kulela matunda denyego mbaka dikale mumbiki. Vivo ili kumwenu mweye, hamudaha kulela matunda mbaka mukale mmwangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Niye na mzabibu, na mweye mwa matambi. Waja wokala mgati mmwangu na niye mgati mmwao, wolela ng'hani matunda kwavija mweye hamudaha kutenda mbuli yoyose bila niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Munhu yoyose yoleka kukala mgati mmwangu, koigala na tambi dikwasigwa kutali na kunyala. Matambi kamba gago gokwikigwa hamoja na kwasigwa muumoto galukule. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mwahakala mgati mmwangu na mbuli zangu zahakala mgati mmwenu, baho puleni chochose kimulonda, na mweye mogweleligwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ukulu wa Tatangu wolagusigwa kamba mweye mwahalela matunda mengi, na mokuwa wanahina zangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nowanogela mweye kamba vija Tata viyoninogela niye, kaleni muunogelwa wangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mwahagagoga malagizo gangu, mokala muunogelwa wangu kamba vija niye vinigagogile malagizo ga Tatangu na kukala muunogelwa wake. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Niwalongela vino ili ndeng'ho jangu dikale mgati mmwenu na avo ndeng'ho jenu dileke kumala. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lagizo jangu dijo dino, muinogele, muinogele kamba viniwanogele mweye. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kuduhu unogelwa mkulu kubanza uno, wa munhu kuulava ugima wake mbuli ya mbwiga zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mweye mwa mbwiga zangu mwahatenda gaja goniwalagiza. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Siwakema kabili watumwa, kwavija watumwa hawajuwa kija chootenda mkulu wao. Lakini nowakema mbwiga, kwavija niwalongela kila kinhu kimhulike kwa Tatangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Siyo mweye munisagule niye, lakini niye niwasagula mweye, muchole na kulela matunda, matunda gokala siku zose. Na ivo Tata kowagwaa chochose kimumpula kwa twaga jangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lagizo jangu kumwenu dijo dino, muinogele. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wanhu wa mwiisi wahawehila, kumbukeni kamba wasonga kunihila niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Maza muli wanhu wa mwiisi, baho wanhu wa mwiisi wahawanogele mweye kamba wanhu wa kumwao. Lakini niwasagula mweye hagati ya wanhu wa mwiisi, na hamwili wanhu wa mwiisi, lekaavo wanhu wa mwiisi wowehila. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukeni kiniwalongele, ‘Mtumwa hali mkulu kubanza mkulu wake.’ Kamba wanhu wanidununza niye vivija wowadununza na mweye. Kamba wagagoga mafundizo gangu, wogagoga na genu vivija. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wowatendela mweye gano gose kwavija mwa wanhu zangu, na kwavija hawamjuwile ayo yanhumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Maza sizile na kulonga nao sambi wawe na nhaguso ya nzambi, lakini sambi hawadaha kubela kamba waduhu nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Munhu yoyose yonihila niye vivija komwihila Tatangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maza sitendile kumwao mbuli zija hazinatendigwa na munhu yoyose, sambi wawe na nhaguso ya nzambi. Lakini wazona mbuli zinhendile na watwihila niye na Tatangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gano gatendeka, avo kija chandikigwe mna ga Malagizo gao kilawilile, ‘Wanihila bila kilamuso.’ ");
INSERT INTO kdc2014_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nomtuma kumwenu Mtazaji kulawa kwa Tata, Loho Yang'alile, ayo yolagusa ukweli wa Mulungu. Kowalongela ukweli mbuli ya niye, ");
INSERT INTO kdc2014_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","vivija na mweye mowalongela mbuli ya niye, kwavija mkala na niye kulawa kuna ichanduso.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu kawalongela, “Niwalongeleni gano gose ili sekemuleke kunitogola niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wanhu wowawinga mna zing'anda za kumpula Mulungu, na kipindi chokwiza baho kila munhu yowakoma mweye kogesa komsang'hanila Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wanhu wowatendela gano gose kwavija hawamjuwile Tata hebu niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Niwalongela gano ili wahasonga kuwatendela gago, mukumbuke kamba niwalongeleni. “Siwalongele gano kulawa kunaichanduso kwavija nikala hamoja na mweye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lakini sambi nochola kumwake yanhumile, kuduhu imoja wenu yoniuza, ‘Kochola kwahi?’ ");
INSERT INTO kdc2014_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwavija niwalongela gano gose, mizoyo yenu inyunyuwala ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakini nowalongeleni ukweli, vinoga kumwenu niye nisegele, kwavija kamba sisegela, Mtazaji honda yawezile. Lakini nahasegela, nomtuma kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kipindi yaheza, kowalagusila wanhu wa mwiisi kamba wabananga viwogesa mbuli ya kutenda nzambi, na mbuli ya kutenda ganogile, na mbuli ya Mulungu vonda yawataguse wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wabananga mbuli ya kutenda nzambi kwavija hawanhogola niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wabananga mbuli ya kutenda ganogile, kwavija nochola kwa Tata na honda munyone kabili. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wabananga mbuli ya Mulungu vonda yawataguse wanhu, kwavija Mwenembago, mkulu wa isi ino kamala kutagusigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nina mbuli nyingi za kuwalongela, lakini sambi hamdaha bule kuzigoga. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Loho Yang'alile yaheza, ayo yolagusa ukweli wa Mulungu, kowalongoza muujuwe ukweli wose. Honda yalonge gake mwenyego, lakini kolonga gaja gayahulike, na kowalongeleni gaja gondageze. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Konigwaa niye ukulu kwavija kosola gaja gononga na kuwalongela mweye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vinhu vose viyalinavo Tatangu ni vangu, lekaavo niwalongela kamba Loho Yang'alile kosola gaja ganimgwee niye na kuwalongela. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“King'hali kipindi kidodo honda munyone kabili, na kipindi kidodo kumwande monyona.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wanahina zake wayagwe waiuza, “Vino kofambula choni? ‘King'hali kipindi kidodo honda munyone kabili, na kipindi kidodo kumwande monyona, na vivija kalonga, kwavija nochola kwa Tata.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wagendelela kuiuza, “Kofambula choni viyolonga, ‘King'hali kipindi kidodo?’ Hatujuwa kolonga choni!” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kajuwa kamba walonda kumuuza, avo kawalongela, “Vino mweye moiuza nifambula choni vinongile, ‘King'hali kipindi kidodo honda munyone kabili, abaho kipindi kidodo kumwande monyona?’ ");
INSERT INTO kdc2014_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nowalongeleni ukweli, mweye molila na kona usungu, lakini wanhu wa mwiisi wodeng'helela. Mweye monyunyuwala, lakini kunyunyuwala kwenu kogalamuka kudeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kipindi mtwanzi yahalonda kulela, konyunyuwala kwavija kipindi chake cha kugaya kivika, lakini mwana king'hele yahavumbuka, koisemwa kugaya kwake, kodeng'helela kwavija kalela mwana king'hele mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vino vivo ili kumwenu, sambi munyunyuwala, lakini nowezila kabili na mizoyo yenu yomema ndeng'ho, kuduhu munhu yonda yadisegeze.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Siku dija dahavika, honda munipule kinhu chochose. Nowalongeleni ukweli, Tata kowagwaa chochose kimumpula kwa twaga jangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka sambi hamnapula kinhu chochose kwa twaga jangu. Puleni mogweleligwa ili ndeng'ho jenu dimeme.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Niwalongeleni mbuli zino kwa simo. Kipindi chovika, baho honda nilonge bule kwa simo, lakini nolonga kunze kunze mbuli ya Tata. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Siku dija dahavika, mompula Tata kwa twaga jangu. Siwalongela bule nompulilani kwa Tata, ");
INSERT INTO kdc2014_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwavija Tata mwenyego kowanogela. Kowanogela kwavija moninogela niye na mutogola kamba ndawa kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndawa kwa Tata na niza mwiisi, na sambi nosegela mwiisi, nochola kwa Tata.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abaho wanahina zake wamulongela, “Sambi hulonga kwa simo bule, lakini kolonga kunze kunze. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sambi tojuwa kamba kujuwa kila kinhu. Hatulonda kuuza mbuli yoyose. Ino yotutenda tukutogole kamba kulawa kwa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kawauza, “Vino sambi motogola? ");
INSERT INTO kdc2014_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kipindi chokwiza, tena kivika, baho mweye mose mopwililika, kila munhu ukayake, mondeka niiyeka. Lakini sili niiyeka bule, kwavija Tata kahamoja na niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Niwalongela gano gose, ili kwa kubandagala mmwangu mkale moyo uholile. Mwiisi mnago madununzo, lakini fungeni umoyo! Niye niihuma isi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aho Yesu viyamambukize kulonga avo, kalola uchanha kuulanga kalonga, “Tata, saa ivika. Mgwee ukulu Mwanago ili Imwana nayo yakugwee ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwavija kumgwaa Mwanago udahi kwa wanhu wose, ili yawagwee ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uno awo ugima wa mazuwa gose, wanhu wakujuwe gweye Mulungu uliwiiyeka wa ukweli, na wamjuwe Yesu Kilisito yuumtumile. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Niulagusa ukulu wako mwiisi, niimambukiza sang'hano yuunigwelele niisang'hane. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata! Sambi unigwee ukulu, ukulu uuja ung'halile nao na gweye isi ing'hali hainaumbigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Niditenda twaga jako dijuwike kwa wanhu waja waunigwelele mwiisi. Wakala wanhu wako na gweye kungwaa niye, wao waigoga mbuli yako. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sambi wojuwa vinhu vose viunigwelele volawa kumwako. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwavija niwagwaa usenga uunigwelele, na wao waubokela, wojuwa kweli niye nilawa kumwako, na watogola kamba gweye kunhuma. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Niye nowapulila wao. Siwapulila wanhu wa mwiisi bule lakini kwa wose waunigwelele, kwavija wako gweye. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wanhu wose wanili nao wako, na wose wauli nao wangu, na ukulu wangu wolagusigwa kubitila kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sambi nokwiza kumwako, sili mwiisi kabili lakini awo wa mwiisi. Tata Ung'alile, weke goya kwa udahi wa twaga jako diunigwelele wadahe kuwa kinhu kimoja kamba vija gweye na niye vitwili kinhu kimoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ving'halile hamoja nao niweka goya kwa udahi wa twaga jako diunigwelele. Niweka goya na kuduhu hata munhu imoja yapotele, ila munhu ija yasaguligwe kupotela, muladi Maandiko Gang'alile galawilile. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sambi nokwiza kumwako, nolonga mbuli zino mwiisi muladi wadahe kuwa na ndeng'ho jangu dimemile mna imizoyo yao. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niwagwelela usenga wako, na wanhu wa mwiisi wawehila, kwavija haweli wanhu wa mwiisi, kamba niye vinili siyo wa mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sikupula bule uwasegeze mwiisi, lakini nokupula uweke goya kulawa kwa ija Imdumuka. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kamba vija niye vinili siyo wa mwiisi, na awo vivija haweli wa mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uwatende wang'ale kwa kweli, mbuli yako ayo kweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Niwatuma mwiisi, kamba vija gweye viunitumile niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mbuli yao noilava mwenyego kumwako, ili na wao vivija wailave ukweli kumwako. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Siwapulila wao waiyeka bule, lakini na waja wose wonda wanhogole niye mbuli ya usenga wao wonda wawapetele. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nopula kuwa wose wawe kinhu kimoja. Tata, nopula wawe mgati mmwetu, kamba vija gweye viuli mgati mmwangu na niye mgati mmwako. Nopula wawe kinhu kimoja ili wanhu wa mwiisi watogole kamba kunhuma. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ukulu uuja uunigwelele niwagwaa wao ili wawe kinhu kimoja, kamba vija gweye na niye vitwili kinhu kimoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ino yofambula, niye nokala mgati mmwao na gweye Tata kokala mgati mmwangu. Nopula wawe kinhu kimoja kweli, muladi wanhu wa mwiisi wajuwe kamba kunhuma na kuwanogela hewo kamba viuninogela niye. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, kunigwaa wao. Nolonda wao wakale hamoja na niye aho hanili, muladi wawone ukulu wangu. Uno awo ukulu uunigwelele kwavija kuninogela isi ing'hali hainaumbigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata Unogile, wanhu wa mwiisi hawakujuwile, lakini niye nikujuwa, na wano wojuwa kamba kunhuma. ");
INSERT INTO kdc2014_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nhenda wao wakujuwe, na nogendelela kutenda vivo, ili unogelwa uli nao kumwangu ukale mgati mmwao, muladi naniye ng'hale mgati mmwao.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu viyamambukize kupula, kasegela hamoja na wanahina zake kachola mwambu wa kizanda kikemigwe Keduloni. Hanhu aho kukala na mgunda wa mibiki, Yesu na wanahina zake wengila mumo. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, yamuhinduke Yesu, kahajuwa hanhu aho, kwavija miyanza mingi Yesu kakala yoiting'hana na wanahina zake. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Avo Yuda kachola kunaumgunda wa mibiki, kachola hamoja na bumbila da wakalizi, na wakalizi wa Ng'anda ya Mulungu watumigwe na wakulu wa walava nhosa na Mafalisayo. Wakala na viwenge na mimuli na mizele. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu kajuwa kila kinhu chonda kimulawilile, avo kalawilila haulongozi, kawauza, “Momzahila nani?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wamwidika, “Yesu wa Nazaleti.” Yesu kawalongela, “Iyo niye.” Yuda yamuhinduke Yesu kakala yemile hamoja nao. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Baho Yesu viyawalongele, “Iyo niye,” wabwela kukisogo, wagwa hasi. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu kawauza kabili, “Momzahila nani?” Wamulongela, “Yesu wa Nazaleti.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kawalongela, “Nimala kuwalongela kamba iyo niye. Avo kamba monizahila niye, walekeni wano wachole.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kalonga vino muladi kija kiyalongile kilawilile, “Tata, wanhu waja waunigwelele simwagize hata imoja.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo yakalile na panga mkigudi, kadisomola kamkanha gwiti da mkono wa kudila msang'hanaji wa Mkulu wa walava nhosa. Msang'hanaji ayo kakemigwa Malukusi. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu kamulongela Petulo, “Bweza panga jako muna iyala! Kogesa silonda niking'wele kikasi cha madununzo kiyanigwelele Tatangu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Abaho wakalizi na wakulu wao na wakalizi wa Wayahudi wamgoga Yesu, wamgodeka. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wandusa kumgala kwa Anasi. Anasi kakala mkwe wa Kayafa, yakalile Mkulu wa walava nhosa mwaka awo. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ayo yawalongele wakulu wa Wayahudi kamba vinoga ng'hani kwa munhu imoja yafe mbuli ya wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo na mwanahina iyagwe wamkweleleza Yesu. Mwanahina ayo iyagwe kakala yajuwike goya na Mkulu wa walava nhosa, avo kachola na Yesu hana ulubuga lwa ng'anda ya Mkulu wa walava nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lakini Petulo kakala kunze behi na mulango. Abaho mwanahina ayo iyagwe yajuwike na mkulu wa walava nhosa kalawa kunze, kalonga na mndele yakalile mmulango, kamgala Petulo mng'anda. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mndele yakalile mmulango kamulongela Petulo, “Vino gweye huli imoja wa wanahina wa munhu ayo?” Petulo kamwidika, “Aka, siyo niye.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wasang'hanaji na wakalizi wabwinha moto wa makala, wema wokotela kwavija kukala na beho. Avo Petulo kachola, kema hamoja nao kokotela. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mkulu wa walava nhosa kamuuza Yesu mbuli ya wanahina zake na mbuli ya mafundizo gake. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kamwidika, “Siku zose nonga kunze kunze na kila munhu. Mafundizo gangu gose nifundiza mna izing'anda za kumpula Mulungu na Mng'anda ya Mulungu, mumo Wayahudi wose mooiting'hana. Silongile chochose kwa kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Habali koniuza niye? Wauze iwanhu wanihulike vinongile. Wauze mbuli iniwalongele, wao waijuwa.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu viyalongile avo, mkalizi imoja yemile behi nayo kamzaba kofi, kalonga, “Habali umwidika avo Mkulu wa walava nhosa?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kamwidika, “Kamba nonga mbuli yoyose ihile, walongele wanhu weli hano mbuli ayo. Lakini kamba nonga goya, habali konhowa?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Abaho Anasi kamgala Yesu kwa Mkulu wa walava nhosa Kayafa, kuno kagodekigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petulo kakala yang'hali yemile aho kokota moto. Wanhu wayagwe wamuuza, “Vino gweye huli imoja wa wanahina zake?” Lakini Petulo kabela, kalonga, “Aka, siyo niye!” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Msang'hanaji imoja wa Mkulu wa walava nhosa, lukolo lumoja na munhu ija yakanhigwe gwiti na Petulo, kamuuza, “Vino gweye sikonile hamoja nayo kuja kumgunda wa mibiki?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Abaho Petulo kalonga, “Aka!” Bahaja nzogolo keka. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Imitootondo ng'hani Yesu kalavigwa mng'anda ya Kayafa kagaligwa mng'anda ya mkulu wa isi. Wakulu wa Wayahudi hawengile bule mng'anda ya mkulu wa isi ya Yudea, kwavija walonda kukala wanogile, ili wadahe kuja lujo lwa Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Avo Pilato kawalawila kunze kawauza, “Muna kitala gani na munhu ino?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wao wamwidika, “Maza habanange sambi tumgale kumwako.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kawalongela, “Msoleni mweye wenyego mukamtaguse kamba Malagizo genu vigalonga.” Wayahudi wamwidika, “Tweye hatulondeka kumkoma munhu yoyose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gano gatendeka ili kutenda mbuli za Yesu zilawilile, mbuli ziyalongile kulagusa vonda yafe. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato kengila kabili mng'anda ya mkulu wa isi, kamkema Yesu, kamuuza, “Vino gweye kwa Mndewa wa Wayahudi?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kamwidika, “Vino uuzaji uno wolawa kumwako hebu wanhu wayagwe wakulongela mbuli zangu?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kamulongela, “Vino gweye kogesa niye na Muyahudi? Wanhu wako mwenyego na wakulu wa walava nhosa wao wakugalile kumwangu. Vino kutenda choni?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kamulongela, “Undewa wangu hauli wa mwiisi ino. Maza undewa wangu uli wa mwiisi ino, wanahina zangu wahanigombele sekengogigwe na wakulu wa Wayahudi. Ka, undewa wangu hauli wa bahano bule!” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Avo Pilato kamuuza, “Vino gweye kwa mndewa?” Yesu kamwidika, “Gweye kolonga niye na mndewa. Niye nivumbuka mbuli ya gano, na mbuli ya gano niza mwiisi, kulonga mbuli ya ukweli. Munhu yoyose younogela ukweli konhegeleza.” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kamuuza, “Ukweli ndiyo choni?” Abaho Pilato kalawa kunze kawacholela kabili Wayahudi, kawalongela, “Niye sichona kilamuso cha kumtagusila. ");
INSERT INTO kdc2014_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lakini mbuli ya mila yumulinayo, siku zose niwafungulilaga mfungwa imoja kipindi cha Pasaka. Avo molonda niwafungulile Mndewa wa Wayahudi?” ");
INSERT INTO kdc2014_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wamwidika kwa kukemelela, “Aka siyo heyo! Tomulonda Balaba!” Balaba kakala mbokaji. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Abaho Pilato kalagiza Yesu yatoigwe mbalati. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wakalizi waluka ngata ya miba, waika mdipala jake. Abaho wamvaza kiwalo cha undewa. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wamcholela, wamulongela, “Mwinyi, Mndewa wa Wayahudi!” Abaho wamzaba makofi. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kalawa kunze kabili, kalulongela lunhu lwa wanhu, “Loleni, nomgala kumwenu mujuwe kamba sichonile kilamuso cha kumtagusila.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Avo Yesu kalawa kunze kuno kavala ngata ya miba na kiwalo cha undewa. Pilato kawalongela, “Loleni! Munhu mwenyego ayo ino!” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wakulu wa walava nhosa na wakalizi wa Ng'anda ya Mulungu viwamone, wakemelela, “Muwambe mumsalaba! Muwambe mumsalaba!” Pilato kawalongela, “Mweye wenyego msoleni mumuwambe mumsalaba. Niye sichona kilamuso cha kumtagusila.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wamwidika, “Tunago Malagizo golonga kolondeka yafe, kwavija kaitenda heyo Mwana wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato viyahulike vivo, kadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kengila kabili mna ing'anda ya mkulu wa isi, kamuuza Yesu, “Vino gweye kolawa kwahi?” Lakini Yesu hamwidike bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato kamulongela, “Kolema kulonga na niye? Hujuwile ninao udahi wa kukufungulila na vivija kukuwamba mumsalaba.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kamwidika, “Kuna udahi kumwangu kwavija kugweleligwa na Mulungu. Avo munhu yanigalile mmakono gako katenda nzambi ng'hani.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato viyahulike vivo, kazahila nzila ya kumfungulila Yesu. Lakini Wayahudi wakemelela, “Wahamfungulila huli mbwiga wa Mndewa mkulu wa Lumi! Munhu yoyose yoitenda Mndewa komuhinduka Mndewa mkulu wa Lumi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato viyahulike mbuli azo, kamulava Yesu kunze, kakala mkigoda cha mkulu wa kitala, hanhu hakemigwe “Lubuga lwa mabwe” Kwa Kiebulania “Gabasa” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikala saa sita imisi siku ya kuitanda Pasaka. Pilato kawalongela Wayahudi, “Aino hano Mndewa wenu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wao wakemelela, “Mkome! Mkome! Muwambe mumsalaba!” Pilato kawauza, “Molonda nimuwambe mumsalaba mndewa wenu?” Wakulu wa walava nhosa wamwidika, “Twaduhu mndewa iyagwe lakini Mndewa mkulu wa Lumi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Abaho Pilato kamulava Yesu kumwao muladi wamuwambe mumsalaba. Avo wambokela Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kalawa kunze kuno kapapa msalaba wake, kachola hanhu hakemigwe Fumvu da Pala. Kwa Kiebulania hokemigwa Goligota. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ako wamuwamba Yesu mumsalaba, na vivija wawawamba wanhu wayagwe wabili. Imoja mwambu wa mkono wa kudila na iyagwe mwambu wa kumoso. Yesu hagati yao. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato kandika kibao, kakika mumsalaba. Vino vivo yandike, “Yesu wa Nazaleti, Mndewa wa Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi wengi wakisoma kibao acho kwavija hanhu aho hayawambigwe Yesu hakala behi na buga jao. Kibao acho chandikigwa Kiebulania, Kilatini na Kigiliki. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wakulu wa walava nhosa wamulongela Pilato, “Sekewandike ‘Mndewa wa Wayahudi’ lakini, ‘Munhu ino kalonga heyo ayo Mndewa wa Wayahudi.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kawedika, “Kinyandike nyandika.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wakalizi viwamambukize kumuwamba Yesu mumsalaba, wasola viwalo vake na kuvigola mafungu mane, kila mkalizi kapata dimoja. Vivija wasola kiwalo chake kiyagwe kikalile hakisonigwe bule lakini kilukigwa. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wakalizi wailongela, “Kino seketukidege, leka tubwanhe simbi tulole yomgwila nani.” Mbuli ino itendeka kutenda Maandiko Gang'alile galawilile. “Waigolela viwalo vangu, wakibwanhila simbi kiwalo changu.” Na vino vivo viwatendile iwakalizi. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Wemile behi na msalaba wa Yesu wakala mamake na mamake mkulu na Malia mtwanzi wa Kilopasi na Malia Magidalena. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu viyamone mamake na mwanahina wake yamnogele ng'hani wema aho, kamulongela mamake, “Mama, sambi ino ayo mwanago.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Abaho kamulongela mwanahina ayo, “Sambi ino ayo mamako.” Kulawa siku dijo mwanahina ayo kamsola na kukala nayo ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu kajuwa kamba kulawa sambi kila kinhu kimala, na ili kutenda Maandiko Gang'alile galawilile, Kalonga, “Nokona ng'hilu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Baho kukala na kikonha kimemile divai ya ugwadu, avo wavabika didodoki mna idivai wadinanika mna ulubiki lwa hisopo, wadika mna umulomo wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu viyang'wile ija idivai, kalonga, “Gamala!” Kaidulika kafa. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Abaho wakulu wa Wayahudi wampula Pilato yawatogolele wagabene magulu ga wanhu wakalile wawambigwe mmisalaba muladi wazihumuluse ng'huli zao. Wampula vino kwavija ikala siku ya kuitanda, na hawalondile ng'huli zikale mmisalaba mwiisiku ya Kubwihila, kwavija siku ayo ya Kubwihila ikala ing'alile. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Avo wakalizi wachola, wagabena magulu ga munhu wa ichanduso na abaho kwa munhu iyagwe wakalile wawambigwe mmisalaba hamoja na Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lakini viwezile kwa Yesu, wamvika kafa mwaka, avo hawagabenile bule magulu gake. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mkalizi imoja kamuhoma Yesu mgoha mulubavu lwake, bahaja damu na mazi vilawa. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Munhu yagonile gano vigalawilile kawalongela ili na mweye mupate kutogola. Gaja goyolonga ga ukweli na kojuwa kamba kolonga ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gano gatendigwa ili kutenda Maandiko Gang'alile galawilile, “Kuduhu zege jake donda dibenigwe.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Vivija Maandiko Gang'alile golonga, “Womulola munhu ayo wamuhomile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Vigabitile gago, Yusufu, mwenekae wa Alimataya kampula Pilato yamgwelele lukuli lwa Yesu. Yusufu kakala mwanahina wa Yesu kwa kinyelegezi, kwavija kakala yowadumba wakulu wa Wayahudi. Pilato kamtogolela yalusole lukuli lwa Yesu, avo Yusufu kachola, kalusegeza na kasegela nao. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, munhu yamgendele Yesu ikilo baho ichanduso hamoja na Yusufu, kapapa mhishi nane za mavumba, gatibwilizigwe na mavuta ga bei ng'hulu gokemigwa manemane na ubani. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wanhu awo wabili walusola lukuli lwa Yesu, waluzingiliza sitili hamoja na mavuta gonung'hila goya kamba viili mila ya Wayahudi ya kuzika. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hanhu aho hayawambigwe Yesu kukala na mgunda, mgati kukala na panga da sambi najo dikala hadinazikiligwa munhu. ");
INSERT INTO kdc2014_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwavija ikala ing'hali siku imoja kuvikila siku ya Kubwihila na vivija panga dijo dikala behi, avo walwika lukuli lwa Yesu mumo. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Imitootondo ng'hani mwiisiku ya Jumapili, kung'hali hakuna kunguzuka goya, Malia Magidalena kachola kuna dipanga kajona dija didibwe disegezigwa mmulomo wa dipanga. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Avo kachola yokimbila mbaka kwa Simoni Petulo na ija mwanahina iyagwe yanogeligwe ng'hani na Yesu, kawalongela, “Wamsegeza Mndewa kudipanga na hatujuwa wamwika kwahi!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Baho Petulo na ija mwanahina iyagwe wachola kudipanga. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose wabili wakala wokimbila, lakini ija mwanahina iyagwe kakimbila ng'hani kubanza Petulo na kalongola kuvika kudipanga. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Viyainamile na kusungulila, kayona sitili lakini hengile mgati bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kukisogo chake kavika Simoni Petulo, kengila mgati ya dipanga na kayona sitili, ");
INSERT INTO kdc2014_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kikumbi kizingilizigwe mdipala da Yesu hakikalile hamoja na sitili, lakini kikala hamgwazo kiiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Abaho ija mwanahina iyagwe yasongile kuvika kudipanga kengila mgati, vivija kayona na katogola. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wakala wang'hali hawajuwile Maandiko Gang'alile vigalongile kamba kolondeka yazilibuke kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Abaho wanahina waja wabwela ukayao. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia kakala yemile kunze ya dipanga kuno kolila. Viyakalile yang'hali kolila, kainama kasungulila kudipanga, ");
INSERT INTO kdc2014_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kawona wasenga wa kuulanga wabili wavalile viwalo vizelu, wakala aho halukalile lukuli lwa Yesu, imoja kudipala na iyagwe kuna gamagulu. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wasenga awo wamuuza Malia, “Mama, kolilila choni?” Kawedika, “Wamsegeza Mndewa wangu, na sikujuwile bule kuwamwikile!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Abaho Malia kahinduka kukisogo, kamona Yesu kema aho lakini hajuwile bule kamba kakala Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kamuuza Malia, “Mama, kolilila choni? Komzahila nani?” Malia kagesa munhu ayo kakala mwamizi wa mgunda, avo kamulongela, “Go mkulu, kamba kumsegeza, nongela hanhu haumwikile nyhole nikamsole.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kamulongela, “Malia!” Malia kahinduka kamulongela kwa Kiebulania, “Laboni!” Laboni fambulo jake “Mfundiza.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kamulongela, “Sekeungoge kwavija ning'hali sinachola kwa Tata kuulanga. Lakini genda kwa ndugu zangu ukawalongele nochola kwa Tatangu vivija Tata yenu, Mulungu wangu vivija Mulungu wenu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Avo Malia Magidalena kachola, kawalongela wanahina, “Nimona Mndewa!” Abaho kawasimulila kila kinhu kiyamulongele. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ikala ichungulo ya siku dija da Jumapili, wanahina wakala waiting'hane hamoja mng'anda kuno nyivi wahinda kwavija wakala wowadumba wakulu wa Wayahudi. Abaho Yesu kema hagati yao. Kawalongela, “Tindiwalo diwe kumwenu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Viyamambukize kulonga avo, kawalagusila makono gake na lubavu lwake. Wanahina viwamone Mndewa wadeng'helela. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kawalongela kabili, “Tindiwalo diwe kumwenu. Kamba Tata viyanhumile, na niye nowatuma.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Baho kawahuvila, kawalongela, “Bokeleni Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kamba mwahazigela kumgongo nzambi za wanhu, Mulungu nayo kozigela kumgongo. Lakini kamba hamzigela kumgongo nzambi za wanhu, vivija Mulungu hazigela kumgongo bule.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mwanahina wake imoja mna iwanahina longo na wabili Tomaso, yakemigwe Pacha hakalile hamoja nao kipindi Yesu viyezile. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Avo wanahina wayagwe wamulongela, “Tumona Mndewa!” Tomaso kawalongela, “Mbaka nizone ng'hovu za misumali mmakono gake, na ningize kidole changu mna zing'hovu na ningize mkono wangu mulubavu lwake, sitogole bule!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Vizivikile siku nane wanahina wakala hamoja kabili mng'anda, Tomaso nayo kakala hamoja nao. Nyivi zikala zihindigwe, lakini Yesu kengila kema hagati yao kawalongela, “Tindiwalo diwe kumwenu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Abaho kamulongela Tomaso, “Ika kidole chako hano, ulole makono gangu. Abaho golosa mkono wako wike mulubavu lwangu. Leka kuwa na moyo mdala, lakini utogole!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso kamwidika, “Mndewa wangu na Mulungu wangu!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kamulongela, “Vino gweye kotogola kwavija kunyona? Wamweda waja wose wotogola bila kunyona!” ");
INSERT INTO kdc2014_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu viyakalile na wanahina zake katenda mbuli ziyagwe nyingi za unzonza lakini hazandikigwe bule mna ikitabu kino. ");
INSERT INTO kdc2014_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lakini zino zandikigwa ili mweye mudahe kutogola kamba Yesu ayo Kilisito Mkombola, Mwana wa Mulungu, na kwa kumtogola muwe na ugima. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Vigabitile gano, Yesu kawalawilila wanahina zake kabili hana dilamba da Tibelia. Vino vivo viilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo na Tomaso yakemigwe Pacha na Nasanaeli mwenekae wa Kana mwiisi ya Galilaya na wanage Zebedayo na wanahina wayagwe wabili wa Yesu wakala hamoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo kawalongela wayage, “Nochola kuvuwa somba.” Wayage wamulongela, “Tochola na gweye.” Avo wakwela mwiingalawa wachola, lakini ikilo kigima hawapatile kinhu bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Zuwa vidisongile kulawa, Yesu kema mwiingema ya dilamba, lakini wanahina hawajuwile bule kamba kakala Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Abaho Yesu kawauza, “Mbwiga zangu, vino hampatile kinhu chochose?” Wamwidika, “Ona, hatupatile chochose.” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kawalongela, “Pigiseni lwavu lwenu mwambu wa mkono wa kudila wa ngalawa, mopata somba.” Avo walupigisa ulwavu, somba wengi wakala wanamate, hawadahile bule kulukwega. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mwanahina ija yanogeligwe na Yesu kamulongela Petulo, “Ayo Mndewa!” Simoni Petulo viyahulike kakala Mndewa, kaifunga kiwalo chake cha kunze mkigudi kwavija kakala yakivulile, kazumha mgamazi. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wanahina wayagwe weza mwiimhwani kwa ngalawa, kuno wokwekwesa lwavu lumemile somba. Hawakalile kutali ng'hani bule kulawa mwiisi inyalile, ikala utali wa magulu gana dimoja. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Viwavikile kunze mwiisi inyalile, wauvika moto wa makala na uchanha yake kuna somba na gate. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu kawalongela, “Wagaleni hano somba wayagwe wamuwavuwile.” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petulo kengila mgati mwiingalawa, kalukwega kunze ulwavu lumemile somba wakulu. Wose kwa wose wakala somba gana dimoja na malongo matano na ndatu. Hamoja wakala wengi kamba vivo lakini lwavu haludegeke bule. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kawalongela, “Izoni muje.” Kuduhu mwanahina yagezile kumuuza, “Gweye kwa nani?” kwavija wamjuwa kamba kakala Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Avo Yesu keza, kasola digate kawagolela, na katenda vivo kwa waja iwasomba. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uno ukala mwanza wa kadatu wa Yesu kuwalawilila wanahina zake viyazilibuke kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Viwamambukize kuja, Yesu kamuuza Simoni Petulo, “Simoni mwanage Yohana, vino koninogela ng'hani kubanza wano wayagwe?” Simoni kamwidika, “Ona Mndewa, gweye kojuwa niye nokunogela.” Yesu kamulongela, “Wadime wanang'hondolo zangu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mwanza wa kabili Yesu kamuuza Petulo, “Simoni mwanage Yohana, gweye koninogela?” Simoni kamwidika, “Ona Mndewa, gweye kojuwa niye nokunogela.” Yesu kamulongela, “Wasusile ng'hondolo zangu.” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mwanza wa kadatu Yesu kamuuza, “Simoni mwanage Yohana, gweye koninogela?” Petulo kona usungu kwavija Yesu kamuuza mwanza wa kadatu, “Koninogela?” Avo kamulongela, “Mndewa, gweye kojuwa kila kinhu, kojuwa niye nokunogela!” Yesu kamulongela, “Wadime ng'hondolo zangu. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nokulongela ukweli, viukalile mbwanga, kuifunga mkwiji mwenyego na kuchola kokose kuulondile. Lakini wahawa mvele, kogolosa makono gako na munhu iyagwe kokufunga na kokugala kuja hukulondile kukuchola.” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwa ulonzi uno Yesu kakala yolagusa vija Petulo vonda yafe na kugala ukulu kwa Mulungu. Abaho Yesu kamulongela, “Nikweleleze!” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Abaho Petulo kahinduka, kamona ija mwanahina iyagwe yanogeligwe na Yesu, ija yakalile behi na Yesu muulujo lwa Pasaka yamuuzile Yesu, “Mndewa, nani yonda yakuhinduke?” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petulo viyamone, kamuuza Yesu, “Mndewa, na ino vilihi?” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kamwidika, “Nahalonda yakale mgima mbaka vonda nize, gweye ya choni? Gweye nikweleleze!” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Avo mbuli ayo ibwililika kwa wanhu wamkweleleze Yesu kamba mwanahina ayo honda yafe bule. Lakini Yesu halongile honda yafe, kalonga, “Nahalonda yakale mgima mbaka vonda nize, gweye ya choni?” ");
INSERT INTO kdc2014_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ino ayo mwanahina yazisimulile mbuli zino, na vivija ayo yazandike. Tweye tojuwa kamba gaja gayalongile ga ukweli. ");
INSERT INTO kdc2014_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuna mbuli ziyagwe nyingi ziyatendile Yesu. Maza zandikigwe zose, vinigesa mwiisi yose sambi hawe na hanhu hakwika ivitabu vandikigwe.");
INSERT INTO kdc2014_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwa Mkulu Teofili. Mna ikitabu changu kinisongile kwandika, nyandika gose gayatendile Yesu na kufundiza kulawa mna ikipindi kiyasongile kusang'hana, ");
INSERT INTO kdc2014_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka mna disiku diyagaligwe kuulanga. Viyakalile yang'hali hanagaligwa uchanha, kawagwaa malagizo kwa udahi wa Loho Yang'alile wanhu awo yawasagule wawe watumigwa zake. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mna ikipindi cha siku malongo mane toka ifa yake, Yesu kakala yowalawilila watumigwa zake miyanza mingi muladi kulagusa kakala mgima. Wamona, nayo kalonga nao mbuli za Undewa wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mna ikipindi kimoja viyakalile koja nao, kawalagiza, “Sekemulawe kudibuga da Yelusalemu, lakini mbeteleni Loho Yang'alile yeli nhunza iyawalongele Tatangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana kawabatiza kwa mazi, lakini mna ikipindi kidodo kumwande mobatizigwa kwa Loho Yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Watumigwa viwaiting'hane hamoja na Yesu, wamuuza, “Mndewa, vino kipindi kino acho chonda uwabwezele wanhu wa Izilaeli undewa?” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu kawedika, “Kipindi na siku azo va mmakono ga Tatangu. Mweye siyo sang'hano yenu kujuwa lini vondaiwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini Loho Yang'alile vondayawezile, mobokela nguvu, na mowapetela wanhu mbuli zangu zimone, mowapetela kudibuga da Yelusalemu na mziisi zose za Yudea na Samalia, na kuuhelelo wa isi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Viyamambukize kulonga vivo, kagaligwa uchanha kuulanga kuno womulola. Abaho ulanga umfisa, hawamone kabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Viwakalile wang'hali wolola bunhuu kuulanga Yesu viyakalile kochola, bahaja wanhu wabili wavalile viwalo vizelu chuwee wema habehi nao. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Walonga, “Mweye wanhu wa Galilaya, habali mwima aho na kulola uchanha kuulanga? Yesu iino yagaligwe uchanha kuulanga kulawa kumwenu, kobwela kabili kamba vivo vimmona kochola kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Abaho watumigwa wabwela Yelusalemu kulawa kuna Ulugongo lwa Mizeituni, lukalile utali wa kilometa imoja kulawa buga dija. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wengila kudibuga, wachola mbaka kudigati diwakalile Petulo na Yohana na Yakobo na Andeleya na Filipo na Tomaso na Batulumayo na Matayo na Yakobo mwanage Alufayo na Simoni Zeloti na Yuda mwanage Yakobo. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wagendelela kuiting'hana hamoja kumpula Mulungu, hamoja na watwanzi wayagwe, na Malia mamake Yesu na wadodo zake Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Siku dimoja Petulo kema mumting'hano wa wanhu wamtogole Yesu. Wanhu awo wakala wovika gana dimoja na malongo mabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Petulo kema na kulonga, “Ndugu zangu, Maandiko Gang'alile golondeka galawilile, gaja gayalongile Loho Yang'alile kubitila Daudi, yalagule mbuli ya Yuda, ayo yawalongoze wanhu waja wamgogile Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda kakala imoja wa kibumbila chetu, kwavija kasaguligwa tutende nayo sang'hano.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yuda kagula mgunda kwa sente ziyapatile kwa gehile, mumo kagwa kingubanguba luu, na inda yake itulika na vinhu vake vose va mgati vilawa kunze. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wanhu wose wa Yelusalemu waihulika mbuli ayo, avo kwa ulonzi wa kumwao waukema mgunda awo Akelidama, fambulo jake, “Mgunda wa Damu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kwavija yandikigwa mna ikitabu cha Zabuli, ‘Ng'anda yake iwe vihame, mgati yake sekeyakale munhu yoyose.’ Vivija yandikigwa, ‘Munhu iyagwe yasole sang'hano yake.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Avo, kolondeka yasaguligwe munhu imoja yakalile na tweye kipindi chose Mndewa Yesu viyangile na tweye. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Kusongela kipindi kija Yohana viyawapetele wanhu usenga wake wa kubatiza, mbaka siku dija Yesu viyagaligwe kuulanga kulawa kumwetu. Munhu ayo yailumbe na tweye mna isang'hano ya kuwapetela wanhu kuzilibuka kwa Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Avo wasagula matwaga ga wanhu wabili, Yusufu yakemigwe Balisaba hebu Yusito, na wakabili Matiasi. ");
INSERT INTO kdc2014_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Abaho wampula Mulungu walonga, “Mndewa, kugajuwa goyogesa kila munhu. Avo tulagusile nani mna iwanhu wano wabili yuumsagule ");
INSERT INTO kdc2014_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","yakusang'hanile muutumigwa yaulekile Yuda, yalemelwa kuchola hanhu hayalondeke.” ");
INSERT INTO kdc2014_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aho wabwanha simbi kusagula mna iwanhu awo wabili, avo simbi imgwila Matiasi, nayo kongezigwa mna ikibumbila cha watumigwa longo na imoja. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Siku da Pentekoste vidivikile, wanhu wose wamtogole Yesu wakala waiting'hane hamoja. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bahaja wanhu wahulika kinhu chobuma kulawa kuulanga kiigalile na beho kulu dibuma, kinhu acho kiimemeza ng'anda yose iwakalile wanhu awo. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Baho wona vinhu viigalile na lambi da moto, vipwililika na kumkwasa kila munhu yakalile aho. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wanhu wose wamemezigwa Loho Yang'alile na wasonga kulonga kwa ulonzi uyagwe, kamba Loho viyawadahize kulonga. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ako Yelusalemu kukala na Wayahudi womdumba Mulungu, walawile kila hanhu mwiisi yose. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Viwazihulike nyangi azo, lunhu mkulu luiting'hana hamoja. Wanhu wose wakanganya, kwavija kila munhu kahulika wanhu wamtogole Yesu wolonga kwa ulonzi wake mwenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wakanganya ng'hani na kulonga, “Wanhu wose wano wolonga, ni wenekae wa Galilaya. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yokuwaze kabili, kila imoja wetu kowahulika wolonga kwa ulonzi wake mwenyego? ");
INSERT INTO kdc2014_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wayagwe vitwili wolawa Palitiya na Mediya na Elama, kulawa Mesopotamia, Yudea na Kapadokia, kulawa Ponto na Asiya, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kulawa Fulugia na Pamfulia, kulawa Misili na banzi za Libiya behi na Kilene. Wayagwe wetu walawa Lumi, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wayahudi na wanhu wengile dini ya Kiyahudi, na wayagwe wetu wolawa Kilete na Alabiya lakini kila imoja wetu kowahulika wolonga mbuli ng'hulu ziyatendile Mulungu kwa ulonzi wa kumwetu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wose wakanganya na kwazanywa, waiuza, “Mbuli ino fambulo jake choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini wanhu wayagwe wawageweza, walonga, “Wanhu wano wakoligwa!” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Abaho Petulo kema hamoja na watumigwa longo na imoja na kwa sauti ng'hulu kasonga kululongela ulunhu, “Mbwigazangu Wayahudi na mweye mose mukalaga isi ya Yelusalemu, nhegelezeni niwalongele fambulo da mbuli zino. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wanhu wano hawakoligwe, kamba vimugelegeza, sambi saa ndatu ya imitondo. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lakini, gano gago gayalongile mtula ndagu wa Mulungu Yoeli, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mulungu kolonga, ‘Vino vivo vondanhende mna isiku ya uhelelo, Nomgidila kila munhu Loho yangu. Wanenu wa kimbigalo na wakitwanzi wolagula mbuli zangu, wabwanga zenu wolagusiligwa vinhu na Mulungu, wavele wenu wolota nzozi. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ona, hata wasang'hanaji zangu wose wa kitwanzi na wa kimbigalo, nowagidila Loho yangu mna izisiku azo, na wao wolagula. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Notenda unzonza kuulanga na vilaguso mwiisi. Hokuwa na damu, moto na yosi, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zuwa dogeligwa ziza, mwezi wogaluka mdung'hu kamba damu, ing'hali hainavika siku ija ng'hulu ya kwiza kwa Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abaho, munhu yoyose yompula Mndewa kwa kutazigwa kokomboligwa.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Wanhu wa Izilaeli! Tegelezeni mbuli zino, Yesu wa Nazaleti kakala munhu wa udahi na kalagusigwa kumwenu kwa unzonza na vilaguso viyatendile Mulungu kubitila kumwake. Mweye wenyego muijuwa mbuli ino kwavija ilawilila bahano hamwenu. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Toka mwaka Mulungu kajuwa na kalonda mweye mumgoge Yesu na mweye mumkoma kwa kuwaleka wanhu wotenda nzambi wamuwambe mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lakini Mulungu kamzilibula kulawa kwa wafile, kamulekesa kulawa muusungu wa ifa, kwavija havidahike ifa imwike mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwavija Daudi kalonga mbuli yake, ‘Nimona Mndewa ka haulongozi wangu siku zose, kahabehi yangu, na niye sigwaya bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Avo niye nodeng'helela, na lulimi lwangu lolonga kwa kudeng'helela, na lukuli lwangu lokala kwa kutamanila, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwavija gweye Mulungu honda undeke kowochola wanhu wafile, honda umuleke mtumigwa wako yang'alile yole mdipanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kundagusila nzila ilongoza muugima, nimema deng'ho kwavija kwa hamoja na niye.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ndugu zangu, nolondeka nonge fulu ipile kamba muhenga wetu mkulu Daudi yajuwike ng'hani. Kafa, kazikigwa, na mbaka lelo panga jake dabahano hamwetu. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kwavija kakala mtula ndagu wa Mulungu, kakijuwa kija kiyalongile Mulungu, Mulungu kamulongela kwa kuiduila kamba yahamtendile munhu imoja kulawa mulukolo lwa Daudi yawe Mndewa kamba viyakalile heyo. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi kagona gonda yatende Mulungu, avo kasimulila mbuli ya kuzilibuka kwa Kilisito Mkombola viyalongile, ‘Halekigwe kuwochola wanhu wafile, lukuli lwake halwolile mdipanga.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mulungu kamzilibula ino Yesu, na tweye wao tuyone mbuli ayo na towapetela mweye. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kazilibuligwa na kwikigwa muukulu mwambu wa mkono wa kudila wa Mulungu Tatake, na kambokela Loho Yang'alile, kamba viyalongeligwe. Kino kimona na kuhulika ayo Loho iyatugidile Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwavija Daudi hagaligwe kuulanga, lakini kalonga, ‘Mndewa kamulongela Mndewa wangu, Kala hano muukulu mwambu wangu wa mkono wa kudila ");
INSERT INTO kdc2014_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka niwatende wanhu wakwihile kamba kigoda cha kwikila magulu gako.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Wanhu wose wa Izilaeli molondeka mujuwe kamba ino Yesu, yummuwambile mumsalaba, Mulungu kamtenda Mndewa na Kilisito Mkombola!” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wanhu viwahulike vivo, wasomigwa mmizoyo na wamulongela Petulo na watumigwa wayagwe, “Ndugu zetu, lelo tutende choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo kawalongela, “Kila imoja wenu kolondeka yaleke nzambi na yabatizigwe kwa twaga da Yesu Kilisito, na Mulungu kozigela kumgongo nzambi zenu na mobokela Loho Yang'alile yeli nhuza. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwavija lagano da Mulungu ditendigwa mbuli yenu na mbuli ya wanenu, na wose wali mmatali na Mndewa Mulungu wetu kowakema kumwake.” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo kawalongela mbuli nyingi na kwa kuwazuma kalonga, “Ihonyeni wenyego kulawa mna inhaguso yonda ize ya wanhu wa lukolo luno wihile!” ");
INSERT INTO kdc2014_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wanhu wengi wazitogola mbuli zake na wabatizigwa, wanhu gana malongo madatu wongezeka mkibumbila siku dijo. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wagendelela kufundizigwa na watumigwa, wakala kimbwiga na kuja gate hamoja na kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mbuli nyingi za unzonza na vilaguso zikala zitendigwa na watumigwa, na kila munhu kengila bwembwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wanhu wose wamtogole Yesu wagendelela kukala hamoja na kuigolela vinhu vao. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wakala wochuuza migunda na vinhu viwakalile navo na kuigolela zisente kwa kila munhu viyalondile. ");
INSERT INTO kdc2014_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wagendelela kuiting'hana Mng'anda ya Mulungu kila siku, wakala woja hamoja mzikae zao, waja kwa kudeng'helela na kwa moyo uholile, ");
INSERT INTO kdc2014_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kuno womtogola Mulungu, na wanhu wose wawanogela. Kila siku wanhu wamtogole Yesu wongezigwa na Mndewa mdibumbila jao. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Siku dimoja saa tisa ya imisi kipindi cha kumpula Mulungu, Petulo na Yohana wakala wochola kuna Ing'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kipindi acho wanhu wakala wampapile munhu imoja mbetembete toka viyavumbuke. Kila siku wakala womwika munhu ayo hana ulwivi lwa Ng'anda ya Mulungu lukemigwe, “Lwivi lunogile” muladi yapule sente kwa wanhu wakalile wokwingila Mng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Viyawone Petulo na Yohana wokwingila Mng'anda ya Mulungu, kawapula wamgwee kinhu chochose. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nao wamulola munhu ayo bunhuu. Petulo kamulongela, “Tulole tweye!” ");
INSERT INTO kdc2014_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Avo kawalola bunhuu, kuno kotamanila kupata kinhu chochose kulawa kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lakini Petulo kamulongela, “Nabule sente, ila nokugwaa kija kinilinacho, kwa twaga da Yesu Kilisito wa Nazaleti, nokulagiza ima wima utembele!” ");
INSERT INTO kdc2014_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Abaho kamgoga kwa mkono wake wa kudila kamwinula. Na bahaja mige ya magulu gake igangamala. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kenuka, kema kwa magulu gake, kasonga kutembela. Abaho kengila Mng'anda ya Mulungu hamoja nao, kuno kozumha zumha na kumtogola Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wanhu wose viwamone kotembela na komtogola Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","wamjuwa kamba heyo yakalile yopula hana, “Ulwivi Lunogile,” avo wose wakanganya kija kimulawilile munhu ayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kuno munhu ayo yang'hali kowawinza Petulo na Yohana hana, “Uluhelengo lwa Sulemani,” kamba vilukemigwe, wanhu wose wakanganya na wasonga kuwakimbilila. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo viyawone wanhu, kawalongela, “Ndugu zangu wa Izilaeli, habali moikanganya mbuli ino, habali motubunhulila meso? Vino mogelegeza mbuli ino ilawilila kwa udahi wetu kumtenda munhu ino yatembele hebu kwavija tweye tomtambikila Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mulungu wa Abulahamu na Isaka na Yakobo na Mulungu wa wahenga zetu, kamgwaa ukulu mtumigwa wake Yesu. Lakini mumgela mmakono ga iwakulu, mumulema haulongozi ha Pilato, hata Pilato viyalondile kumulekesa. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kakala yang'alile na yanogile, lakini mweye mumulema, mumpula Pilato yawatendele vimulonda, yawafungulile munhu mkomaji. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mumkoma ayo yakalile chanduso cha ugima, lakini Mulungu kamzilibula kulawa kwa wafile na tweye tuyona mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Udahi wa twaga da Yesu awo umgwelele nguvu munhu ino mbetembete. Kino kimona na kukijuwa kitendigwa kwa kutamanila kwa twaga jake. Kumtamanila Yesu ako kumtendile munhu ino yahonyigwe, kamba mose vimona. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sambi, ndugu zangu, nojuwa kija kimumtendele Yesu mweye na wakulu zenu mukala hamkijuwile. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mulungu kalonga mbuli ino toka mwaka ilawilile kubitila watula ndagu zake wose, kamba Kilisito wake Mkombola kolondeka yadununzike, na vino vivo ili. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lelo lekeni nzambi zenu mumbwelele Mulungu, muladi Mulungu yazigele kumgongo nzambi zenu. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mwahatenda avo, kipindi cha kuhozigwa moyo chokwiza kulawa kwa Mndewa, na komtuma Yesu, yeli Kilisito Mkombola yasaguligwe mbuli yenu. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kolondeka yasigale kuulanga mbaka kipindi kivike cha kugatenda gose gawe ga sambi, kamba viyalongile Mulungu kubitila watula ndagu zake wang'alile wakalile kuko umwaka. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwavija Musa kalonga, ‘Mndewa Mulungu wenu kowagalileni mtula ndagu wake, kamba viyanhumile niye, kokuwa imoja wa wanhu zenu. Mutogole chochose chonda yawalongeleni. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Munhu yoyose yolema kumtegeleza mtula ndagu ayo wa Mulungu kobaguligwa mna iwanhu wa Mulungu na kokomigwa.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na watula ndagu wa Mulungu wose wakalile na usenga, kusongela Samweli na wayagwe wezile kumwande, vivija walonga vinhu vilawilila mzisiku zino. ");
INSERT INTO kdc2014_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lagano da Mulungu kubitila watula ndagu zake ni jenu, na mweye mwamgati mna idilagano da Mulungu yaditendile kwa wahenga zenu. Kamba viyalongile kwa Abulahamu, ‘Kubitila lukolo lwako nowatenda wanhu wose wa mwiisi wamwede.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Avo Mulungu viyamzilibule mtumigwa wake, tanhu kamtuma kumwenu, mumwede na kuwatenda mweye muleke nzambi zenu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo na Yohana viwakalile wang'hali wolonga na wanhu, walava nhosa, wakulu wa wakalizi wa Ng'anda ya Mulungu, na Masadukayo wayagwe wavika. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wagevuzika ng'hani kwavija watumigwa wao wabili wakala wowafundiza wanhu kuwa Yesu kazilibuka kwa wafile, na ino ilagusa kamba wafile wozilibuka. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Avo wawagoga na kuwagodeka mkifungo mbaka imitondo yake, kwavija zuwa dikala dihongile. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini wanhu wengi wauhulike usenga watogola, na wambigalo wongezeka mbaka gana malongo matano. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Siku diyagwe wakulu wa Wayahudi, wavele, na wafundiza Malagizo ga Musa waiting'hana Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Waiting'hana na Anasi mulava nhosa mkulu, na Kayafa na Yohana na Alekizanda, na wanhu wayagwe wa lubuga lwa mulava nhosa mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Waweka Petulo na Yohana haulongozi wao, wawauza, “Vino mweye mutendaze? Nguvu gani yumpatile hebu mosang'hana kwa twaga da nani?” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo kuno kamema Loho Yang'alile, kawedika, “Walangulizi wa wanhu na wavele! ");
INSERT INTO kdc2014_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kamba lelo touzigwa mbuli ya kija kinogile kitendigwe kwa munhu yabemendeke magulu na vija viyahonyigwe, ");
INSERT INTO kdc2014_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","avo molondeka mose mujuwe, na wanhu wose wa Izilaeli mujuwe, kamba munhu ino yemile haulongozi wenu kahona kwa twaga da Yesu Kilisito wa Nazaleti, ayo yummuwambile mumsalaba na Mulungu kamzilibula kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu iyo yolongigwa mna Gamaandiko Gang'alile, ‘Dibwe dilemigwe na mweye wazengaji digalamuka dibwe da kutamanila kubanza gose.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ukombozi haupatikana kwa munhu yoyose iyagwe, kwavija mwiisi yose kuduhu twaga diyagwe diyatugwee Mulungu donda tukomboligwe najo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wakulu wa mkitala wakanganya kona vija Petulo na Yohana viwagangamale, kwavija wawajuwa kamba hawaifunzile ubala wowose. Abaho wajuwa kamba wakala mbwiga zake Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lakini viwamone munhu ayo yahonyigwe kema hamoja na Petulo na Yohana, hawadahile kulonga mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Avo wawalongela walawe mdigati da ikitala, abaho wakulu wa mkitala wasonga kuilongela wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wakulu wa mkitala waiuza, “Tuwatende choni wanhu wano? Kila munhu mwiisi ya Yelusalemu kojuwa kamba unzonza uno mkulu utendigwa na hewo, na tweye hatudaha kuibela bule mbuli ino. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini kutenda mbuli ino sekeibwililike ng'hani kwa wanhu, leka tuwazume wanhu wano waleke kulonga kwa munhu yoyose kwa twaga da Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Avo wawakema kabili mng'anda, wawazuma sekewalonge hebu kufundiza kwa twaga da Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petulo na Yohana wawedika, “Mweye wenyego taguseni choni kinogile mgameso ga Mulungu, kuwategeleza mweye hebu kumtegeleza Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwavija hatudaha kuleka kulonga kija kituwone na tukihulike tweye wenyego.” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Avo wanhu wa mkitala wawazuma ng'hani abaho wawalekesa. Hawadahile kuwatagusa, kwavija wanhu wose wakala womgwaa nhogolwa Mulungu mbuli ya kija kilawilile. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Munhu yatendiligwe unzonza uno wa kuhonyigwa kakala na miyaka kubanza malongo mane. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bahaja Petulo na Yohana viwalekesigwe, wabwela kuna ikibumbila chao na kuwalongela kija kilongigwe na wakulu wa walava nhosa na wavele. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wanhu wamtogole Yesu viwahulike avo, wailumba hamoja mna ukumpula Mulungu, walonga, “Mndewa gweye kuumba ulanga, isi, bahali na vose vilimgati mmwake! ");
INSERT INTO kdc2014_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kulonga kubitila muhenga wetu Daudi, mtumigwa wako, kwa udahi wa Loho Yang'alile. Viyalongile, ‘Habali wanhu wa mwiisi yose wagevuzika? Habali wanhu wokala kiseto cha kibozi? ");
INSERT INTO kdc2014_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wandewa wa mwiisi waitanda wenyego, walangulizi waiting'hana hamoja kumbiduka Mndewa na Mkombola ayo yaamsagule.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwavija Helode na Pontio Pilato waiting'hana hamoja mna idibuga dino da wanhu haweli Wayahudi na wanhu wa Izilaeli kumbiduka Yesu, Mtumigwa wako Yang'alile, Kilisito Mkombola yuumsagule. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Watenda mbuli zija ziulondile toka mwaka zilawilile kwa udahi wako. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sambi, gweye Mndewa, ulole mbuli zao zakugela bwembwe ziwatendile. Tutaze tweye wasang'hanaji zako seketudumbe kuwapetela wanhu usenga wako. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Golosa mkono wako uwahonye wanhu. Tenda vifukuzi na unzonza kwa twaga da Yesu mtumigwa wako yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Viwamambukize kumpula Mulungu, aho hawakalile waiting'hane hatigisika. Wose wamemezigwa Loho Yang'alile na wagendelela kuwapetela wanhu usenga wa Mulungu bila kudumba. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kibumbila cha wanhu wamtogole Yesu wakala na moyo umoja. Kuduhu imoja wao yalongile vija viyakalile navo vikala vake, lakini waigolela na wayao kila kinhu kiwakalile nacho. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Watumigwa wawapetela wanhu mbuli ya kuzilibuka kwa Mndewa Yesu kwa nguvu ng'hulu, na Mulungu kawagwaa wanhu ng'hekewa ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kukala kuduhu munhu yoyose mkibumbila yakalile bila kinhu. Wanhu wayagwe wakalile na migunda hebu ng'anda wakala wochuuza, na kugala zisente ziwapatile, ");
INSERT INTO kdc2014_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na wawagwaa watumigwa, na zisente izo zigoligwa kwa kila munhu kamba viyalondile. ");
INSERT INTO kdc2014_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kukala na Mulawi imoja twaga jake Yusufu, mwenekae wa Kupulo, ayo watumigwa wamkema Balinaba, fambulo jake, “Munhu yogangamiza wanhu,” ");
INSERT INTO kdc2014_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","kachuuza mgunda wake, kawagwaa zisente watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kukala na munhu imoja yakemigwe Anania na mwehe wake Safila, nao vivija wachuuza mgunda wao. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anania kailumba na mwehe wake, kabagula sente ziyagwe na zisigale kawagwaa watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petulo kamuuza, “Anania, habali kumtogolela Mwenembago yakulongoze umvizile Loho Yang'alile kwa kufisa sente ziyagwe ziupatile kwa kuchuuza mgunda wako? ");
INSERT INTO kdc2014_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Viukalile ung'hali hunachuuza umgunda ukala wako, na viumambukize kuchuuza, sente zikala zako. Lelo, habali kutenda mbuli ayo? Humvizile munhu bule ila kumvizila Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bahaja Anania viyaihulike mbuli ayo, kagwa hasi kafa. Wanhu wose waihulike mbuli ayo wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wabwanga weza waluvaza sitili lukuli lwake walulava kunze waluzika. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vigabitile masaa madatu mwehe wake Anania keza, kengila mng'anda, lakini hajuwile gaja gampatile mkasano wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo kamuuza, “Nongele, zino izo sente zose zimpatile gweye na mkasano wako kwa kuchuuza mgunda wenu?” Kamwidika, “Ona, zizo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Avo Petulo kamulongela, “Vino habali gweye na mbigalo wako muilumba kumgeza Loho wa Mndewa? Wanhu wamzikile mkasano wako sambi wa hamulango na gweye wokusola vivija!” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bahaja kagwa hasi mmagulu ga Petulo kafa. Wabwanga viwengile wamvika kafa, avo wamulava kunze na wamzika behi na mbigalo wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wanhu wose wamtogole Yesu na wose wayagwe waihulike mbuli ayo wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Watumigwa watenda mbuli nyingi za unzonza na vifukuzi mna iwanhu. Wanhu wose wamtogole Yesu waiting'hana hamoja muluhelengo lwa Sulemani. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kuduhu wanhu wayagwe kulawa kunze wagezile kuilumba na wanhu wamtogole Yesu, hamoja wanhu wawagwaa nhogolwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lunhu lwa wambigalo na watwanzi wamtogole Mndewa wongezeka mkibumbila. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mbuli ya unzonza uwakalile wotenda watumigwa, wanhu wawagala watamu mvisazi na mmikeka, muladi sisila da Petulo diwakwase wanhu wayagwe viyakalile kobita. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lunhu lwa wanhu lwiza kulawa mmabuga geli behi na Yelusalemu, na kuwagala wanhu wose wakalile wolumwa hebu wakalile na vinyamkela, na wose wahonyigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Abaho mulava nhosa mkulu na wayage wose, na wanhu wa kibumbila cha Masadukayo, wawonela migongo ng'hani watumigwa, avo wasonga kuwehila. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wawagoga watumigwa na kuwagodeka mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lakini ikilo msenga wa kuulanga wa Mndewa kafungula nyivi za ikifungo, kawalava kunze iwatumigwa, kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gendeni mkeme Mng'anda ya Mulungu, walongeleni wanhu mbuli ya ugima uno.” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Watumigwa watogola, na imitootondo wengila Mng'anda ya Mulungu na wasonga kufundiza. Mulava nhosa mkulu na wayage wawakema hamoja wavele wose wa Izilaeli mkitala, abaho walagiza watumigwa walavigwe mkifungo na wagaligwe haulongozi wao. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini wakulu wa wakalizi wa Ng'anda ya Mulungu viwacholile, hawawavikile iwatumigwa mkifungo, avo wabwela mkitala na kulonga, ");
INSERT INTO kdc2014_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Vituvikile mkifungo, tukivika kihindigwa na wakalizi wose wokaliza zinyivi, lakini vitufungule zinyivi, hatumvikile munhu bule mgati!” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wakulu wa walava nhosa na wakulu wa wakalizi wa Ng'anda ya Mulungu viwahulike avo, wakanganya kija kiwalawilile watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Abaho munhu imoja keza kawalongela, “Tegelezeni! Wanhu wamuwagodeke mkifungo wa Mng'anda ya Mulungu wofundiza wanhu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Avo mkulu wa wakalizi wa Ng'anda ya Mulungu kachola hamoja na wanhu zake wawagoga iwatumigwa. Hawawagogile kwa nguvu, kwavija wawadumba wanhu sekewawatowe mabwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wawagala iwatumigwa mgati, na wawemiza haulongozi wa mkitala, na mulava nhosa mkulu kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tuwagomesa sekemufundize kwa twaga da munhu ino, lakini loleni kimtendile! Mugabwililisa mafundizo genu mwiisi yose ya Yelusalemu, na molonga tweye wao kilamuso cha ifa yake!” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petulo na watumigwa wayagwe wedika, “Tolondeka tumtegeleze Mulungu siyo wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mweye mumkoma kwa kumuwamba mumsalaba, lakini Mulungu wa wahenga zetu kamzilibula Yesu kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mulungu kamwinula mbaka mwambu wa mkono wake wa kudila kamtenda Mulangulizi na Mkombola, kuwatenda wanhu wa Izilaeli waleke nzambi zao na Mulungu yazigele kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tweye tuzona mbuli azo, tweye na Loho Yang'alile, yeli nhunza ya Mulungu kwa wose womtogola.” ");
INSERT INTO kdc2014_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wanhu wa mkitala viwahulike avo, wagevuzika ng'hani walonda kuwakoma iwatumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini imoja wao, Mfalisayo yakemigwe Gamalieli yakalile mfundiza Malagizo ga Musa yadumbigwe ng'hani na wanhu wose, kema aho mkitala. Kawalongela watumigwa walavigwe kunze kidogo, ");
INSERT INTO kdc2014_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","abaho kawalongela wanhu wa mkitala, “Waizilaeli wayangu, iteganyeni ng'hani na kija kimulonda kuwatendela wanhu wano! ");
INSERT INTO kdc2014_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Baho umwaka kukala na munhu yakemigwe Teuda, kaitenda munhu mkulu, na wanhu gana na nne wailumba nayo. Lakini kakomigwa na wanhu zake wamkweleleze waimwaga na mbuli zake zihelela baho. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Abaho, Yuda mwenekae wa Galilaya kalawilila mna ikipindi cha kuwapeta wanhu, na heyo vivija kakala na lunhu mkulu, lakini vivija kakomigwa, na wanhu zake wose wamkweleleze waimwaga. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lelo, nowalongeleni, sekemuwatendele mbuli yoyose wanhu wano. Walekeni! Kamba kija kiwaitogolele kutenda cholawa kumwao wenyego, hondakitendeke bule, ");
INSERT INTO kdc2014_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","lakini kamba cholawa kwa Mulungu, hondamuwahume bule. Baho mogomba na Mulungu!” Wanhu wa mkitala wakweleleza mbuli za Gamalieli. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wawakema iwatumigwa mkitala, wawatowa mbalati, na wawalagiza sekewalonge kabili kwa twaga da Yesu, abaho wawalekesa. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Watumigwa viwasegele mkitala, wakala na deng'ho kwavija Mulungu katogola wageligwe kinyala mbuli ya twaga da Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kila siku wagendelela kufundiza na kuwapetela wanhu Mng'anda ya Mulungu na mzikae za wanhu, kamba Yesu Kilisito iyo Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Siku vizigendelele wanahina viwakalile wokongezeka, kukala na ndwagi mna Iwayahudi wolonga Kigiliki na waja iwolonga Kiebulania. Wayahudi iwolonga Kigiliki walonga kamba wagane wakiwa weli kumwao wasemwigwa muna ukugoleligwa sente kila siku. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Avo iwatumigwa longo na wabili wawakema wanahina wose wawalongela, “Havinogile bule kumwetu kuleka kuwapetela wanhu mbuli ya Mulungu na kuwagolela lujo. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Avo, ndugu zangu, saguleni wanhu saba kumwenu wajuwike kamba wamema Loho Yang'alile na nzewele, na toweka wawe wakulu wa mbuli ino. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lakini tweye tompula Mulungu na kuwapetela wanhu mbuli ya Mulungu kipindi chetu chose.” ");
INSERT INTO kdc2014_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wanhu wose wanogelwa na mbuli za watumigwa, avo wamsagula Sitefano munhu yamemile kutamanila na Loho Yang'alile, hamoja na Filipo na Polokolo na Nikanoli, Timona na Palimena na Nikolasi munhu hali Muyahudi kulawa Antiokia iyo yakalile yengile mwiidini ya Kiyahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Abaho wanhu wao wose wagaligwa kwa iwatumigwa, wao wampula Mulungu na kuwekila makono. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Avo mbuli za Mulungu zigendelela kwenela. Wanahina wongezeka ng'hani ako Yelusalemu na walava nhosa wengi wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mulungu kamgwaa ng'hekewa na nguvu Sitefano, nayo kadaha kutenda unzonza na vifukuzi mna iwanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini kalemigwa na wanhu wayagwe wakalile wanhu wa ng'anda ya kumpula Mulungu, ikemigwe, “Ng'anda ya kumpula Mulungu ya wanhu Walekesigwe,” wanhu awo walawa Kilene na Alekizandilia. Wayagwe walawa isi za Kilikia na Asiya. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini Loho Yang'alile kamgwaa nzewele Sitefano viyakalile kolonga, mbaka walemelwa kumuhuma. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Avo wawahonga wanhu walonge, “Tumuhulika komulonga vihile Musa na Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa ulonzi uno wawading'hula wanhu, wavele na wafundiza Malagizo ga Musa. Wamgoga Sitefano na kumgala mkitala cha Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Abaho wawagala wanhu wayagwe walonge uvizi mbuli yake, walonga, “Siku zose munhu ino koilonga vihile Ng'anda ya Mulungu na Malagizo ga Musa. ");
INSERT INTO kdc2014_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tumuhulika kolonga kamba Yesu wa Nazaleti koibomola Ng'anda ya Mulungu na kugalusa vihendo vetu vitugweleligwe na Musa!” ");
INSERT INTO kdc2014_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wanhu wose wakalile mkitala wambunhulila meso Sitefano, wachona kihanga chake kiigala na kihanga cha msenga wa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mulava nhosa mkulu kamuuza Sitefano, “Mbuli zino za ukweli?” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefano kawedika, “Tata zangu na ndugu zangu, nhegelezeni! Muhenga wetu Abulahamu yang'hali hanachola kukala isi ya Halani, Mulungu wa ukulu kamulawilila mwiisi ya Mesopotamia. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mulungu kamulongela, ‘Segela mwiisi yako, waleke wanhu wa lubuga lwako uchole isi yonda nikulagusile.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Avo kalawanya mwiisi ya Wakalidayo kachola kukala kudibuga da Halani. Tatake Abulahamu viyafile, Mulungu kamulongela Abulahamu yeze mwiisi ino yumukala sambi. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mulungu hamgwelele Abulahamu hata kimhongwe kidodo kiwe chake mwenyego, lakini Mulungu kamulongela komgwaa, iwe yake na lukolo lwake. Mulungu viyamulongele avo, Abulahamu kakala kaduhu wana. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Vino vivo Mulungu viyamulongele Abulahamu, ‘Lukolo lwako lokala mwiisi ya ugeni, ako wokuwa watumwa na wotendigwa vihile kwa miyaka magana mane. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lakini nowatagusa wanhu wondawawatende watumwa. Abaho lukolo lwako lolawa mwiisi iyo na wonigwaa ukulu niye hanhu hano.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Abaho Mulungu kamgwaa Abulahamu kihendo cha kwingila kumbi kamba kilaguso cha lagano. Avo Abulahamu kamwingiza kumbi Isaka siku ya nane toka viyavumbuke. Vivija Isaka kamwingiza kumbi mwanage, yakemigwe Yakobo, na Yakobo kawengiza kumbi waja wahenga zetu longo na wabili.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Wanage Yakobo wamonela migongo mdodo wao Yusufu na wamchuuza yawe mtumwa mwiisi ya Misili. Lakini Mulungu kakala hamoja nayo, ");
INSERT INTO kdc2014_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kamuhonya na magayo gake. Yusufu viyagaligwe kwa Falao mndewa wa Misili, Mulungu kamtenda yanogeligwe, na nzewele zake zoneka, avo mndewa wa Misili kamtenda yawe mkulu wa wakulu wa Isi, na mkulu wa wasang'hanaji wa mng'anda. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Abaho kukala na lufilili lwa nzala mwiisi yose ya Misili na Kanaani, itendile wanhu wadununzike. Wahenga zetu hawapatile lujo bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo viyahulike ako Misili kukala na ndiya, kawatuma wanage, wahenga zetu, mwanza wa ichanduso kuvika ako. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Viwacholile mwanza wa kabili, Yusufu kailagusa kwa ndugu zake, na mndewa Falao kalujuwa lukolo lwa Yusufu. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Avo Yusufu kawatuma wasenga kwa tatake Yakobo, wamulongele heyo na lukolo lose weze Misili, wose kwa wose wakala malongo saba na tano. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Abaho Yakobo kachola Misili, ako heyo na wanage wafa. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ng'huli zao zigaligwa Shekemu, ako wazikigwa mna gamapanga gayagulile Abulahamu kwa sente kulawa kuna ulukolo lwa Hamoli.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kipindi cha Mulungu kutenda gayamulongele Abulahamu vikikalile behi, wanhu zetu wongezeka ng'hani mwiisi ya Misili. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Abaho mndewa iyagwe yalekile kumjuwa Yusufu kasonga kutawala mwiisi ya Misili. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kawatendela usede wahenga zetu na kuwatenda vihile, kawalagiza waweke kunze wanao ving'hele, muladi wafe. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa kavumbuka mna ikipindi acho, kakala mwana yanogile. Kaleligwa na mamake kwa miezi midatu, ");
INSERT INTO kdc2014_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na viyekigwe kutali na ukae, mndele wa Falao kamsola na kamulela kamba mwanage. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kafundizigwa ubala wose wa Wamisili na kawa munhu mkulu kwa kulonga na sang'hano.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa viyavikize miyaka malongo mane, kachola kuwalola ndugu zake Waizilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kamona imoja wao kotendiligwa vihile na Mmisili, avo kachola kumtaza Mwiizilaeli kwa kumulipa gehile Mmisili kwa kumkoma. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kagesa ndugu zake Waizilaeli wahajuwile kamba Mulungu yahawakombole kubitila heyo, lakini wao hawajuwile. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Imitondo yake kawona Waizilaeli wabili woitowa, kageza kuwagombeleza kawalongela, ‘Nhegelezeni mweye mwa ndugu habali moitowa kamba avo?’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lakini ayo yakalile yomtowa miyage kamsung'ha Musa kumgwazo. Kamuuza, ‘Nani yakutendile mulangulizi na mulamuzi wetu? ");
INSERT INTO kdc2014_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hebu kolonda kunikoma kamba viumkomile ija Mmisili jana?’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa viyahulike avo, kalawanya mwiisi ya Misili kachola mwiisi ya Midiani. Ako kapata wana wabili.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Viibitile miyaka malongo mane, msenga wa kuulanga kamulawilila Musa kuna ikisolo kikalile chokwaka kuluwala behi na lugongo lwa Sinai. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kakanganya ng'hani kija kiyone, kachola behi ya kisolo yalole goya. Lakini kahulika sauti ya Mndewa, ");
INSERT INTO kdc2014_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Niye na Mulungu wa wahenga zako, Mulungu wa Abulahamu na Mulungu wa Isaka na Mulungu wa Yakobo.’ Musa kagwaya kwa bwembwe na hagezile kulola kabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mndewa kamulongela, ‘Vula vilatu vako, kwavija hanhu aho hawimile hang'ala. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Niwona wanhu zangu viwodununzigwa mwiisi ya Misili. Nihulika viwogutilila, nihumuluka niwahonye. Avo sambi nokutuma uchole Misili.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa iyo yalemigwe na wanhu wa Izilaeli, viwamulongile, ‘Nani yakutendile mulangulizi na mulamuzi kumwetu?’ Musa iyo yatumigwe na Mulungu kuwalanguliza wanhu na kuwakombola kubitila msenga wa kuulanga yamulawilile hana ikisolo kikwaka. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kawalongoza wanhu walawe Misili, kwa kutenda unzonza na vilaguso mwiisi ya Misili na hana Ibahali ya shamu kwa miyaka malongo mane kuluwala. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa iyo yawalongele wanhu wa Izilaeli, ‘Mulungu kowasagulileni mtula ndagu wake, kamba viyanhumile niye na kokuwa imoja wa wanhu zenu.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa iyo yakalile na lung'husesa lwa wanhu wa Izilaeli kuluwala, kakala ako na wahenga zetu na msenga wa kuulanga yalongile nayo hana Ulugongo lwa Sinai, na kabokela mbuli za ugima wa Mulungu yatugwelele tweye.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakini wahenga zetu walema kumtogola, wamsung'ha kumgwazo na walonga yahanogile kumwao wahabweleganye Misili. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Avo wamulongela Haluni, ‘Tutendele mulungu yonda yatulongoze. Hatujuwa kinhu gani kimulawilile Musa, yatulavile Misili.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Avo watenda kinyago cha ng'ombe, wakigwaa ukulu, watenda nyimwili nyimwili kudeng'helela kija kiwatendile. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mulungu kawaleka na kawatenda wazigwee ukulu nhondo za kuulanga, kamba viyandikigwe mna ikitabu cha watula ndagu wa Mulungu.” “Mweye wanhu wa Izilaeli! Si niye bule yumunichinjile wanyama na kundavila nhosa kwa miyaka malongo mane kuja kuluwala? ");
INSERT INTO kdc2014_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mweye mkipapa kiheha cha mulungu Moleki, na kinyago cha nhondo ya mulungu wenu Lefani, vinyago vimutendile vivo vimvitambikile, avo nowahamizila mwiisi ya Babeli.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wahenga zetu wakala na kiheha kilagusa kamba Mulungu kabaho ako kuluwala. Kitendigwa kamba Mulungu viyamulongele Musa yakitende, kiigalile na kija kiyaone. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Abaho, wahenga zetu wakibokele acho ikiheha kwa wahenga zao. Wakipapa viwacholile hamoja na Yoshua na wachola nacho mna ziisi ziyawabitize Mulungu. Kikala kuko mbaka kipindi cha Daudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi kanogeligwa na Mulungu na kampula Mulungu yamtogolele yatende hanhu hakukala Mulungu wa Yakobo. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Sulemani iyo yamzengele Mulungu ng'anda.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Lakini Mulungu yeli Uchanha Ng'hani hakala mng'anda izengigwe kwa makono ga wanhu, kamba mtula ndagu wa Mulungu viyolonga, ");
INSERT INTO kdc2014_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ulanga acho kigoda changu na isi iyo inikile magulu gangu. Ng'anda ya gani yonda munizengele niye? Hanhu gani hondanikale niye? ");
INSERT INTO kdc2014_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Niye mwenyego iyo nhendile vinhu vose vino.” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Abaho Sitefano kalonga, “Mweye muli na mizoyo midala, na mulekile kumjuwa Mulungu, mweye musitile magwiti genu kutegeleza usenga wa Mulungu! Mwiigala na wahenga zenu na mweye vivija momulema Loho Yang'alile! ");
INSERT INTO kdc2014_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vino hana mtula ndagu yoyose wa Mulungu wahenga zenu wamulekile kumdununza? Wawakoma wasenga wa Mulungu wao kulawa umwaka walongile kwiza kwa Msang'hanaji wake Yanogile. Na sambi mumuhinduka na kumkoma. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mweye wao mubokele malagizo ga Mulungu, gamgweleligwe na wasenga wa kuulanga, lakini hamgagogile bule!” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wanhu wa mkitala viwamtegeleze Sitefano, wagevuzika ng'hani, wadafuna meno gao. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini Sitefano kuno kamema Loho Yang'alile, kalola uchanha kuulanga kawona ukulu wa Mulungu na Yesu kema mwambu wa mkono wa kudila wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kalonga, “Loleni, nouwona ulanga ugubuka na Mwana wa Munhu kema mwambu wa mkono wa kudila wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kwa nyangi wanhu wa mkitala wasita magwiti gao. Bahaja wanhu wose wamzumhila Sitefano, ");
INSERT INTO kdc2014_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wamulava kunze ya buga, wamtowa mabwe. Waja wakalile womtowa mabwe waleka viwalo vao kwa mbwanga imoja twaga jake Sauli. ");
INSERT INTO kdc2014_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Viwakalile womtowa mabwe Sitefano kapula, “Mndewa Yesu, ibokele loho yangu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kafugama kaguta, “Mndewa! ugele kumgongo nzambi yao ino!” Viyalongile avo kafa. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nayo Sauli kona vinoga kukomigwa kwa Sitefano. Mna izisiku azo wanhu wamtogole Yesu ako Yelusalemu wasonga kudununzigwa vihile. Wanhu wose wamtogole Yesu, wahaleka watumigwa, wakala wapwililike mwiisi iyo ya Yudea na Samalia. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wanhu wanogile wamzika Sitefano na wamulilila ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lakini Sauli kalonda kuwadununza wanhu wamtogole Yesu. Kachola ng'anda mbaka ng'anda, kawalava kunze wanhu wamtogole Yesu, wambigalo kwa watwanzi, na kaweka mvifungo. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wanhu wamtogole Yesu wapwililike wachola kila hanhu kuwapetela wanhu Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo kachola kudibuga da Samalia na kawapetela wanhu mbuli ya Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lunhu lwa wanhu lumtegeleza goya Filipo viyalongile na kuwona unzonza uyatendile. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vinyamkela wawalawa wanhu kwa kulila, na wanhu wengi waholole na mbetembete wahonyigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Avo kukala na deng'ho kulu kudibuga dija. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Munhu imoja twaga jake Simoni kakala yokala mumo, kawazanya Wasamalia kwa uhawi wake. Kaitenda kamba kakala munhu mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wanhu wose kudibuga dija, wakulu kwa wadodo wamtegeleza ng'hani, walonga, “Munhu ino kana udahi wa Mulungu ukemigwa, ‘Udahi Mkulu’.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wamtegeleza ng'hani kwavija kwa miyaka mingi kawazanya kwa uhawi wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini viwautogole usenga wa Filipo, usenga wa Mbuli Inogile ya Undewa wa Mulungu na mbuli ya twaga da Yesu Kilisito, wose wabatizigwa, wambigalo kwa watwanzi. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni nayo katogola, viyamambukize kubatizigwa kakala yokwanga na Filipo na kakanganya viyone unzonza na vilaguso vikalile vitendigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Watumigwa wakalile Yelusalemu wahulika wanhu wa Samalia waibokela mbuli ya Mulungu, avo wawatuma Petulo na Yohana kumwao. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Viwavikile, wawapulila kwa Mulungu wanhu wamtogole Yesu wambokele Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwavija Loho Yang'alile kakala yang'hali hanamuhulumukila munhu yoyose kumwao, wakala wabatizigwe kwa twaga da Mndewa Yesu diiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Abaho Petulo na Yohana wawekila makono, wabokela Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni kona wanhu wamtogole Yesu wambokela Loho Yang'alile viwekiligwe makono na watumigwa. Avo kalonda kuwagwaa sente Petulo na Yohana, ");
INSERT INTO kdc2014_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kalonga, “Naniye nigweleleni udahi uno, muladi munhu yoyose yonda nimwikile makono gangu yabokele Loho Yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lakini Petulo kamwidika, “Upotele kutali gweye na sente zako, kwa kugesa kodaha kugula kwa sente nhunza ya Mulungu! ");
INSERT INTO kdc2014_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kuduhu hanhu hohose mwiisang'hano yetu, kwavija moyo wako haugesa ganogile mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Avo leka nzambi zako, na magesa gako gehile na mpule Mndewa yagele kumgongo. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwavija nokona kumema migongo na kwa mfungwa wa nzambi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kamulongela Petulo na Yohana, “Mhulileni kwa Mndewa, gano gamulongile sekegandawilile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Viwamambukize kulonga gaja gawone na kuwapetela wanhu usenga wa Mndewa, Petulo na Yohana wabwela Yelusalemu. Mnzila wawapetela Mbuli Inogile wanhu wa mvijiji va Samalia. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Msenga wa kuulanga wa Mndewa kamulongela Filipo, “Itande uchole kusini kubitila nzila ilawa Yelusalemu kuchola Gaza.” Nzila ino sambi haitumika. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Avo Filipo kaitanda na kuchola. Muisiopiya yeliduhu kimbigalo, yakalile munhu mkulu mna ingama ya Kandake mndewa wa kitwanzi wa Isiopiya kakala mnzila ya kuchola ukayake. Kakala Yelusalemu komtambikila Mulungu na kakala yobwela ukayake na mtuka wa kubulula. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Viyakalile mnzila kakala yosoma kitabu cha mtula ndagu wa Mulungu Isaya. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Avo Loho Yang'alile kamulongela Filipo, “Genda kakale behi na mtuka uja.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Baho Filipo kakimbila behi na mtuka kamuhulika munhu ayo kosoma kitabu cha mtula ndagu wa Mulungu Isaya. Filipo kamuuza, “Vino kogajuwa gago gousoma?” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mkulu ayo kedika, “Nodahaze kugajuwa bila munhu kunifambulila?” Avo kamgoneka Filipo yakwele mumtuka na yakale hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Munhu ayo kakala yosoma hanhu hano mna Gamaandiko Gang'alile, “Kakala kamba ng'hondolo yogaligwa kuchinjigwa, kamba mwana ng'hondolo yanyamale huupi viyokanhigwa mibahila, halongile mbuli. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kageligwa kinyala na koneligwa. Kuduhu munhu yodaha kulonga mbuli za lukolo lwake, kwavija ugima wake mwiisi uvika kuuhelelo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mkulu iyo kamuuza Filipo, “Nongele mtula ndagu wa Mulungu kolonga mbuli ya nani? Mbuli yake mwenyego hebu ya munhu iyagwe?” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo kasonga kulonga, kasongela hanhu hano ha Maandiko Gang'alile, kamulongela Mbuli Inogile ya Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Viwakalile wogendelela na mwanza, wavika hanhu hakalile na mazi, mkulu ayo kalonga, “Hano hana mazi. Kinhu gani kingomesa ndeke kubatizigwa?” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo kamulongela, “Kodaha kubatizigwa kamba wahatogola kwa moyo wako wose. Mkulu ayo kamwidika, ‘Notogola kamba Yesu Kilisito iyo Mwana wa Mulungu’.” ");
INSERT INTO kdc2014_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mkulu ayo kalagiza mtuka wime. Filipo na mkulu iyo wahumulukila mgamazi, Filipo kambatiza. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Viwalawile mgamazi, Loho wa Mndewa kamsegeza Filipo. Mkulu ayo hamonile kabili, lakini kagendelela na mwanza kuno kamema deng'ho. ");
INSERT INTO kdc2014_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo kasinhukila ka Azoto, kachola isi ya Kaisalia na mnzila kawapetela wanhu Mbuli Inogile kila buga. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mna ikipindi acho Sauli kagendelela kuwehila na kuwakoma wanahina wa Mndewa. Kachola kwa mulava nhosa mkulu, ");
INSERT INTO kdc2014_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kapula baluwa ya kujuwika mng'anda ya kumpula Mulungu ako Damesiki, muladi yahamvika munhu yoyose mtwanzi hebu mbigalo kotogola nzila ya Mndewa yamgoge yamgale Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sauli viyakalile mnzila behi na kuvika Damesiki, bahaja mulenge kulawa kuulanga ummwemwesela banzi zose. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kagwa hasi na kahulika sauti yomulongela, “Sauli, Sauli! Habali konidununza?” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli kauza, “Mndewa, gweye kwa nani?” Kedika, “Niye na Yesu yuunidununza. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lakini inuka uchole kudibuga, ako kolongeligwa cha kusang'hana.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wanhu wakalile mwanza umoja na Sauli wema, hawalongile mbuli, sauti waihulika lakini hawamonile munhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli kenuka, kabenzula meso gake, lakini hachonile kinhu. Avo wamgoga mkono wamulongoza Damesiki. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa siku ndatu hadahile kulola, na kipindi chose acho hadile na hang'wile kinhu chochose. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kukala na mwanahina wa Yesu kuko Damesiki twaga jake Anania. Mulungu kamulagusila kinhu mzinzozi, Mndewa kamkema, “Anania!” Anania kedika, “Aino baha Mndewa.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mndewa kamulongela, “Winuke uchole Mnzila Igoloke. Kuna ing'anda ya Yuda muuze munhu yokemigwa Sauli kulawa Taliso. Heyo kompula Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mulungu kamulagusila kinhu, kamona munhu yakemigwe Anania keza na kumwikila makono gake yadahe kulola kabili.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lakini Anania kamwidika, “Mndewa wanhu wengi wanongela mbuli zake munhu ino na gaja gose gayawatendele wanhu zako wa mwiisi ya Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nayo keza Damesiki kwa udahi kulawa kwa wakulu wa walava nhosa kuwagoga wanhu wose wokugwaa ukulu gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mndewa kamulongela, “Genda kwavija nimsagula yanisang'hanile, kutenda twaga jangu dijuwike na wanhu haweli Wayahudi na wandewa wao na wanhu wa Izilaeli. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Niye mwenyego nomulagusila vonda yadununzike mbuli yangu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Avo Anania kachola kengila mng'anda iyakalile Sauli, kamwikila makono, kalonga, “Ndugu yangu Sauli, Mndewa kanhuma, Yesu mwenyego yakulawilile gweye mnzila viukalile kokwiza hano. Kanhuma muladi udahe kulola kabili na umemezigwe Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bahaja vinhu kamba vibale vilagala mgameso ga Sauli, na kadaha kulola kabili, kenuka na kabatizigwa, ");
INSERT INTO kdc2014_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","viyamambukize kuja, nguvu zake zimbwelela.” Sauli kakala siku ndodo na wanahina wa Yesu ako Damesiki. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Baho kasonga kuwapetela wanhu mzing'anda za kumpula Mulungu kamba Yesu iyo Mwana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wanhu wose wamuhulike wakanganya wauza, “Vino ino siyo heyo yawakomile wanhu wamgwelele ukulu Yesu mwiisi ya Yelusalemu. Hezile hano mbuli ya kuwagoga wanhu wao na kuwagala kwa wakulu wa walava nhosa?” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lakini Sauli kawapetela wanhu kwa udahi mkulu, na kulonga kwake kamba Yesu Kilisito kakala Mkombola kuwatenda Wayahudi wakalile Damesiki walemelwe kumwidika. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Vizibitile siku nyingi, Wayahudi waiting'hana na wakala kiseto cha kumkoma Sauli. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini kalongeligwa mbuli iyo, imisi na ikilo wakaliza hana ulwivi lwa kwingila kudibuga muladi wamkome. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini ikilo kimoja wanahina wakalile na Sauli wamsola, wamuhumulusa mdigelo kulu kubitila zonzo dikalile muuluwa uzunguluke dibuga. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli kachola Yelusalemu kalonda kuilumba na wanahina. Lakini wose wamdumba, kwavija hawatogole kamba Sauli nayo kakala mwanahina. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Abaho Balinaba keza kumtaza Sauli, na kamgala kwa watumigwa. Kawasimulila vija Sauli viyamonile Mndewa mnzila na Mndewa kalonga nayo. Vivija kawalongela vija Sauli viyawapetele wanhu wa Damesiki kwa twaga da Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Avo Sauli kakala nao na kachola kudibuga jose da Yelusalemu, kawapetela wanhu wa Damesiki kwa twaga da Mndewa kwa kugangamala. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Vivija kalonga na kuibamilila na Wayahudi wolonga Kigiliki, lakini hewo walonda kumkoma. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wanhu wamtogole Yesu viwone vivo, wamgala Sauli mbaka kudibuga da Kaisalia na wamuleka yachole Taliso. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Avo kipindi acho vibumbila va wanhu wamtogole Yesu vikala moyo hole kila hanhu kuko Yudea na Galilaya na Samalia. Kubitila Loho Yang'alile yakalile yowagangamiza wanhu, wanhu wongezeka ng'hani viwakalile wokala kwa kumdumba Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo kagenda kila hanhu, siku dimoja kachola kuwatembelela wanhu wamtogole Yesu wakalile ako Ludia. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ako kamting'hana munhu yakemigwe Enea, yakalile yaholole na hadahile kwinuka mulusazi kwa miyaka minane. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo kamulongela, “Enea, Yesu Kilisito kokuhonya. Lamuka mulusazi lwako tandika lusazi lwako.” Bahaja Enea kenuka. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wanhu wose wakalile Ludia na Saloni wamona Enea, nao wamtogola Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ako Yopa kukala na mtwanzi yakemigwe Tabita yakalile mwanahina wa Yesu, Twaga jake kwa Kigiliki Dolikasi, fambulo jake, “Mhala,” Mtwanzi ayo kakala yotenda ganogile na kuwataza wakiwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kipindi acho mtwanzi ayo kalumwa, abaho kafa. Lukuli lwake lusunhigwa lwikigwa mdigati da uchanha. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Buga da Yopa hadikalile kutali ng'hani na buga da Ludia. Wanahina wa Yesu ako Yopa viwahulike kamba Petulo kakala kuko Ludia, wawatuma wanhu wabili na usenga uno, “Tokupula ulopole wize kumwetu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Avo Petulo kachola nao. Viyavikile kagaligwa mdigati da uchanha ako wagane wose wamzunguluka kuno wolila na kumulagusila viwalo vose viyasonile Dolikasi viyakalile yang'hali mgima. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo kavilava kunze, kafugama mavindi kampula Mulungu, abaho kaluhindukila lukuli lwa mtwanzi ayo yafile, kalonga, “Tabita, lamuka!” Nayo kabenzula meso gake, viyamonile Petulo, kagandamuka. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulo kamgoga mkono kamtaza kwinuka. Abaho kawakema wanhu wose wamtogole Yesu, wayagwe wakala wagane kamwika haulongozi wa hewo, kuno ka mgima. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbuli ino ibwililika kudibuga jose da Yopa na wanhu wengi wamtogola Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo kagendelela kukala ako Yopa kwa siku nyingi mwiikae ya munhu yakalile yowamba ng'hwembe yakemigwe Simoni. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kukala na munhu imoja mwiisi ya Kaisalia yakemigwe Kolinelio, kalala mkulu wa kibumbila cha wakalizi gana wa Kilumi kikemigwe, “Kibumbila cha Italia.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kakala munhu yomdumba Mulungu, heyo na wanhu wose wa mulubuga lwake wamgwaa ukulu Mulungu. Vivija kasang'hana ng'hani kuwataza wanhu wakiwa na kakala yompula Mulungu siku zose. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Siku dimoja saa tisa imisi, Mulungu kamulagusila kinhu, kamona msenga wa kuulanga wa Mulungu kamwizila kamulongela, “Kolinelio!” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolinelio kamulola bunhuu msenga ayo wa kuulanga kwa bwembwe kamulongela, “Go mkulu, kuna choni?” Msenga wa kuulanga kamwidika, “Mulungu kanogelwa kumpula kwako na sang'hano ya kuwataza wakiwa, nayo hakusemwa bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Watume wanhu sambi baha, wachole Yopa kwa munhu imoja yokemigwa Simoni Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Heyo mgeni mna ikae ya munhu yokemigwa Simoni, muwamba ng'hwembe, kokala behi ya Bahali.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Abaho msenga ayo wa kuulanga kasegela, Kolinelio kawakema wasang'hanaji zake wabili na mkalizi wake imoja wa iwasang'hanaji zake, yomdumba Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kawalongela kija kilawilile, abaho kawatuma wachole Yopa. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Siku diyagwe viwakalile mnzila behi na Yopa, imisi Petulo kachola kudigati da uchanha kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kona nzala na kalonda kuja kinhu chochose, lujo vilukalile lotandigwa, Mulungu kamulagusila kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kona ulanga ugubuka na kona kinhu kamba mgolole mkulu uwambigwe mhande zake nne wohumulusigwa hasi. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mgati yake kukala na wanyama wose na wang'onyo wotambala na ndege. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kahulika sauti yomulongela, “Petulo, lamuka uchinje uje!” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lakini Petulo kalonga, “Aka, Mndewa, sinakuja bule kinhu kigomigwe hebu kihile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sauti imulongela kabili, “Sekeuvikeme viha vinhu viyatendile Mulungu vinoge.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mbuli ino ilawilila miyanza midatu, abaho kinhu acho kigaligwa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petulo viyakalile kokanganya fambulo da kinhu acho, wanhu watumigwe na Kolinelio wavika hana ing'anda ya Simoni, na wakala wemile haulongozi wa ulwivi. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wakema, wauza, “Vino hano hana mgeni yoyose yokemigwa Simoni Petulo?” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo kakala yang'hali yogelegeza fambulo da kinhu acho, baho Loho Yang'alile kamulongela, “Tegeleza! Kuna wanhu wadatu wokuzahila. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Avo sekeunyawenyawe, itande uchole nao, kwavija niye iyo niwatumile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Avo Petulo kahumuluka kawalongela wanhu wao, “Niye iyo yumumzahila. Muwinza choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wamwidika, “Mkulu Kolinelio katutuma. Munhu ayo kanoga na komdumba Mulungu na katogoligwa ng'hani na Wayahudi. Msenga yang'alile wa kuulanga kamulongela yakugoneke gweye ukayake. Muladi yahulike chondaulonge.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petulo kawagoneka wanhu awo kumwake, ikilo acho kawagwaa hanhu ha kuwasa. Imitondo yake kaitanda kachola nao na wanhu wayagwe wamtogole Yesu kulawa Yopa wachola nayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Imitondo yake wavika mwiisi ya Kaisalia. Kolinelio kakala kowabeta, hamoja na ndugu na mbwiga zake wa behi yawagoneke. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petulo viyakalile behi kuvika, Kolinelio kenuka kamcholela, kagwa kingubanguba kamtambikila. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petulo kamwinula, kamulongela, “Inuka, niye mwenyego na munhu kamba gweye.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo kagendelela kulonga na Kolinelio viyakalile kokwingila mng'anda, mumo kawavika wanhu wengi waiting'hana. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petulo kawalongela, “Mweye wenyego mujuwa goya kamba Muyahudi kagomigwa na malagizo gake sekeyamtembelele hebu kuilumba na munhu hali Muyahudi. Lakini Mulungu kandagusila sekenimkeme munhu yoyose keha hebu hafaya. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na viundagize, silemile bule niza, avo nokuuza kabili kung'hemela choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolinelio kalonga, “Siku ndatu zibitile mna isaa kamba ino, saa tisa imisi, ng'hala nimpula Mulungu mng'anda yangu. Bahaja munhu yavalile viwalo vizelu chuwee, kema haulongozi wangu, ");
INSERT INTO kdc2014_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kalonga, ‘Kolinelio! Mulungu kahulika viumpulile na kazitogola sang'hano zako za kuwataza wanhu wakiwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mtume munhu yachole Yopa kwa munhu yokemigwa Simoni Petulo. Kokala mwiikae ya Simoni muwamba ng'hwembe, kokala behi na Bahali.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Avo bahaja niwatuma wanhu kumwako, na kutenda goya viwizile. Sambi wose twabaha haulongozi wa Mulungu, tobetela kuhulika mbuli yoyose yakulagize Mndewa ulonge.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Baho Petulo kasonga kulonga, “Sambi nojuwa kweli Mulungu hambagula munhu yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wose womgwaa ukulu na kutenda ganogile kowatogola, hatonga wolawa isi gani. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muujuwa usenga uyaugalile kwa wanhu wa Izilaeli, kuwapetela wanhu Mbuli Inogile igala tindiwalo kubitila Yesu Kilisito yeli Mndewa wa wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Muzijuwa mbuli ng'hulu zitendeke mwiisi yose ya Wayahudi, kusongela Galilaya, Yohana viyamalile kuwapetela wanhu usenga wake wa ubatizo. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mumjuwa Mulungu viyamsagule Yesu wa Nazaleti kwa kumgwaa Loho Yang'alile na udahi. Kila hanhu hayacholile katenda ganogile na kuwahonya wanhu wose wakalile mmakono ga Mwenembago, kwavija Mulungu kakala nayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tweye tuchona kila kinhu kiyatendile mwiisi ya Wayahudi na Yelusalemu. Abaho wamkoma kwa kumuwamba mumsalaba. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lakini siku ya kadatu Mulungu kamzilibula kulawa kwa wafile na kamtenda yaoneke, ");
INSERT INTO kdc2014_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","siyo kwa kila munhu, lakini kwa waja wazonile mbuli azo, wasaguligwe mwaka na Mulungu, wao tweye tudile na kung'wa hamoja nayo viyazilibuke kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Katulagiza tuwapetela wanhu Mbuli Inogile na kuwalongela kamba Yesu iyo yasaguligwe na Mulungu kuwatagusa wanhu wagima na wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Watula ndagu wose wa Mulungu walonga mbuli yake, walonga wanhu wose womtogola nzambi zao zogeligwa kumgongo kwa udahi wa twaga da Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petulo viyakalile yang'hali yolonga, Loho Yang'alile kawahumulukila wanhu wose wakalile womtegeleza. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wayahudi wamtogole Yesu wezile kulawa Yopa hamoja na Petulo wakanganya viwone Mulungu vivija kawagwaa wanhu haweli Wayahudi nhunza ya Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwavija wawahulika wolonga kwa ulonzi wa sambi na kuutogola ukulu wa Mulungu. Petulo kawalongela, ");
INSERT INTO kdc2014_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wanhu wano wambokela Loho Yang'alile, kamba vitumbokele tweye. Vino munhu yoyose kodaha kuwagomesa sekewabatizigwe kwa mazi?” ");
INSERT INTO kdc2014_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Avo kalagiza wabatizigwe kwa twaga da Yesu Kilisito. Abaho wampula yakale nao kwa siku ndodo. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Watumigwa na wanhu wayagwe wamtogole Yesu ako Yudea wahulika kamba wanhu haweli Wayahudi vivija wabokela mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petulo viyacholile Yelusalemu, wanhu wolonda wanhu haweli Wayahudi wengile kumbi, wambeza Petulo, ");
INSERT INTO kdc2014_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","walonga, “Gweye kukala mzikae za wanhu haweli Wayahudi hawengile kumbi na vivija kuja nao!” ");
INSERT INTO kdc2014_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Avo Petulo kawalongela fulu ipile kija kilawilile kusongela kuna ichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Vinikalile nompula Mulungu kudibuga da Yopa, Mulungu kandagusila kinhu. Nyona kinhu chokwiza hasi kiigala na mgolole mkulu uhumulusigwa kwa mhande zake nne kulawa kuulanga, wima behi yangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ndola goya mgati yake nyona wanyama wose, wang'onyo wotambala na ndege. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Abaho mhulika sauti yonongela, ‘Petulo, lamuka uchinje uje!’ ");
INSERT INTO kdc2014_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lakini nonga, ‘Mndewa bule! Kuduhu kinhu kihile hebu kigomesigwe kingile mumulomo wangu.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sauti ilonga kabili kulawa kuulanga, ‘Sekeuvikeme viha vinhu viyatendile Mulungu vinoge.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mbuli ayo ilawilila miyanza midatu, kukikomelezo kinhu kija kibwelezigwa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Bahaja wanhu wadatu watumigwe kumwangu kulawa Kaisalia wavika mng'anda ing'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Loho kanilongela nichole nao sekeninyawenyawe. Ndugu wano sita kulawa Yopa wachola na niye Kaisalia na wose twingila mng'anda ya Kolinelio. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kolinelio katulongela vija viyamonile msenga kulawa kuulanga kema mng'anda yake. Kamulongela, ‘Mtume munhu yachole Yopa kwa munhu yokemigwa Simoni Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kowalongeleni mbuli zondaziwatende gweye na wanhu wa mulubuga lwako mukomboligwe.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Vinisongile kulonga, Loho Yang'alile keza kumwao kamba viyezile kumwetu kuna ichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Abaho nikumbuka kija kiyalongile Mndewa, ‘Yohana kawabatiza wanhu kwa mazi, lakini mweye mobatizigwa kwa Loho Yang'alile.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Vivo ili Mulungu kawagwaa wanhu haweli Wayahudi nhunza iija iyatugwelele tweye vitumtogole Mndewa Yesu Kilisito Mkombola, niye na nani, mbaka nimgomese Mulungu?” ");
INSERT INTO kdc2014_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Viwahulike avo, waleka kumulonga na wamtogola Mulungu, walonga, “Vivija Mulungu kawagwaa wanhu haweli Wayahudi nyafasi ya kuleka nzambi na kubokela ugima wa mazuwa gose!” ");
INSERT INTO kdc2014_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wanhu wayagwe wamtogole Yesu wakalile wapwililike mbuli ya madununzo galawilile viyakomigwe Sitefano, wachola mbaka Foinike, Kupulo na Antiokia, kuwapetela Wayahudi waiyeka usenga uno. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini wanhu wayagwe wamtogole Yesu, walawile Kupulo na Kilene, wachola Antiokia kuwapetela wanhu haweli Wayahudi usenga wa Mbuli Inogile ya Mndewa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Udahi wa Mndewa ukala hamoja nao, na wanhu wengi watogola na wambwelela Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mbuli ino iwavikila wanhu wamtogole Yesu ako Yelusalemu, avo wamtuma Balinaba yachole Antiokia. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Viyavikile na kona vija Mulungu viyawagwelele ng'hekewa, kadeng'helela na kawapula wagendelele kumtamanila Mndewa kwa mizoyo yao yose. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balinaba kakala munhu yanogile, kamema Loho Yang'alile na kutamanila, na wanhu wengi wambwelela Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Abaho Balinaba kachola Taliso kumzahila Sauli. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Viyamonile, kamgala Antiokia, mwaka mgima waiting'hana na wanhu wamtogole Yesu na wawafundiza wanhu wengi. Ako Antiokia, kuko wanahina wa wasonga kukemigwa Wakilisito. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mna ikipindi acho watula ndagu wayagwe wa Mulungu wasegela Yelusalemu wachola Antiokia. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Imoja wao yakemigwe Agabo, kema na kwa udahi wa Loho Yang'alile kalagula kamba hokuwa na lufilili lwa nzala mwiisi yose. Ilawilila kipindi cha utawala wa Kilaudio. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wanahina wa Yesu waitogolela kila munhu yagale chochose kiyakalile nacho, kuwataza wayao wamtogole Yesu wakalile Yudea. ");
INSERT INTO kdc2014_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Watenda avo, abaho wawagwaa sente Balinaba na Sauli wazigale kwa wavele wa wanhu wamtogole Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mna ikipindi kikija Mndewa Helode kasonga kuwadununza wanhu wayagwe wamtogole Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kalagiza Yakobo mkulu wake Yohana yakomigwe kwa panga. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Helode viyonile mbuli ino iwanogela Wayahudi, kagendelela, kamgoga Petulo. Mbuli ino ilawilila mna ikipindi cha Magate hagageligwe usasu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Viwamgogile Petulo wamgodeka mkifungo, wamwika mmakono ga wakalizi wakalile vibumbila vine kila kibumbila kikala na wakalizi wane. Helode kalonda kumulava Petulo haulongozi wa wanhu yahamala Nyimwili nyimwili ya Pasaka. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Avo Petulo viyakalile yang'hali kagodekigwa, wanhu wamtogole Yesu wampulila ng'hani kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mna ikilo cha siku ayo iyalondile Helode yamgale Petulo haulongozi wa wanhu, Petulo kakala yawasile hagati ya wakalizi wabili. Kakala yagodekigwe kwa minyololo mibili. Hana ulwivi lwa kifungo hakala na wakalizi wakalile wokaliza. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bahaja msenga wa kuulanga wa Mndewa kema, mulenge umwemwesa mdigati dija. Msenga wa kuulanga kamtigisa Petulo mdiega, kamulongela, lamuka, “Lopola, inuka!” Bahaja minyololo ilagala kulawa mmakono ga Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Abaho msenga ayo wa kuulanga kamulongela, “Ifunge mkwiji wako na uvale vilatu vako.” Petulo katenda vivo, na msenga wa kuulanga kamulongela, “Vala kiwalo chako uniwinze.” ");
INSERT INTO kdc2014_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo kamkweleleza kunze ya kifungo, lakini hajuwile kamba msenga wa kuulanga kakala yotenda vivo kweli, kagiza kakala yolota nzonzi. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wabita kibumbila cha ichanduso cha wakalizi abaho cha kabili, na kukimambukizo kibumbila cha wakalizi wa lwivi lwa kwingilila kudibuga. Lwivi luwavugukila lwenyego na wao walawa kunze, wagenda mnzila bahaja msenga wa kuulanga kamuleka Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Abaho Petulo kajuwa gamulawilile kalonga, “Sambi nojuwa kweli! Mndewa kamtuma msenga wake wa kuulanga yamhonye mmakono ga Helode na kulawa kwa kija kiwalondile kutenda Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Viyajuwile avo kachola ukae kwa Malia mamake Yohana yakemigwe Maluko, ako wanhu wengi wakala waiting'hane na wakala wompula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo kagong'onda lwivi lwa kunze, na mtumigwa wa kitwanzi yakemigwe Loda kachola kulola nani yogong'onda. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Viyajuwile ikala sauti ya Petulo, kadeng'helela kaleka kuvugula ulwivi kabweleganya mng'anda, kawalongela, “Yemile kunze Petulo!” ");
INSERT INTO kdc2014_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wamulongela, “Gweye kuna kibozi mbwelela.” Lakini kagangamiza kamba ikala kweli. Avo wamwidika, “Sengine msenga wake kulawa kuulanga.” ");
INSERT INTO kdc2014_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mna ikipindi acho Petulo kagendelela kugong'onda ulwivi, kukimambukizo wamvugulila, na viwamone wakanganya. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petulo kenula mkono kulagusa wanyamale, kawalongela vija Mndewa viyamulavile mkifungo. Kawalongela, “Mulongeleni Yakobo mbuli ino na wanhu wayagwe wamtogole Yesu,” abaho kachola hanhu hayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Viivikile imitondo, wakalizi wakala wonyawanyawa kwa kija kimulawilile Petulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode kalagiza wamzahile Petulo, lakini hawamonile bule. Avo kalagiza waja wakalizi wauzigwe na kalagiza wakomigwe. Abaho, Helode kasegela mwiisi ya Yudea kachola kukala mwiisi ya Kaisalia. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode kawagevuzikila ng'hani wanhu wa Tilo na Sidoni, avo wamgendela hamoja. Tanhu wamtewenza Bulasto, mkalizi wa ng'anda ya Mndewa yawataze. Abaho wachola kwa Helode kumpula kuwe na tindiwalo, kwavija isi yao itamanila lujo kulawa mwiisi ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mna disiku disaguligwe Helode kavala viwalo vake va undewa, kakala mkigoda chake cha undewa, kalonga na wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wanhu wakemelela, “Ino sauti ya Mulungu, siyo ya munhu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bahaja msenga wa kuulanga kambwanha hasi Helode, kwavija hamgwelele Mulungu ukulu. Kahomigwa na msango kafa. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lakini mbuli ya Mulungu igendelela kwenela. ");
INSERT INTO kdc2014_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balinaba na Sauli viwamambukize sang'hano yao, wabwela Yelusalemu hamoja na Yohana Maluko. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mna iwanhu wamtogole Yesu ako Antiokia, kukala na watula ndagu wa Mulungu na wafundiza, Balinaba na Sauli na Simeoni yakemigwe Mtitu na Lukio yalawile Kilene, Manaeni yakulile hamoja na Mndewa Helode. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Viwakalile womgwaa ukulu Mndewa na kufunga kuja, Loho Yang'alile kawalongela, “Mbagulileni Balinaba na Sauli wasang'hane sang'hano iniwakemele.” ");
INSERT INTO kdc2014_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wafunga kuja na kumpula Mulungu, wawekila makono wawatuma wachole. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Balinaba na Sauli viwatumigwe na Loho Yang'alile wachola kudibuga da Seleukia, kulawa ako wakwela meli mbaka kisiwa cha Kupulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Viwavikile kudibuga da Salami wawapetela wanhu mbuli ya Mulungu mna izing'anda za kumpula Mulungu za Wayahudi. Yohana Maluko kakala yowataza kusang'hana. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wanga mna ikisiwa mbaka wavika Pafo, ako wamting'hana muhawi imoja Muyahudi yakemigwe Baliyesu, yaitendile mtula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Munhu ayo kakala mbwiga wa mkulu wa kisiwa acho, yakemigwe Seligio Paulo, yakalile munhu mbala. Mkulu wa kisiwa kija kawakema Balinaba na Sauli kalonda kuhulika mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini wakala wogomesigwa na Elima yakalile muhawi, dino ijo fambulo jake kwa Kigiliki, yakalile yogeza kumtenda mkulu wa kisiwa sekeyatogole kumtamanila Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Abaho Sauli, vivija yakemigwe Paulo, kuno kamema Loho Yang'alile, kamulola bunhuu ayo imuhawi, ");
INSERT INTO kdc2014_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kalonga, “Gweye mwana wa Mwenembago! Gweye kuvihila vinhu vose vinogile. Gweye kumema magesa gose gehile, na siku zose kogeza kuugalusa ukweli wa Mndewa kamba uvizi! ");
INSERT INTO kdc2014_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Udahi wa Mndewa wokutagusa sambi baha, na gweye kokuwa msuwameso honda uwone mulenge wa imisi kwa kipindi kidodo.” Bahaja kungugu dimulawilila Elima mgameso, kagenda kuno komzahila munhu yamgoge mkono yamulongoze. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mkulu ayo wa ikisiwa viyonile kija kilawilile, katogola, kwavija kakanganya ng'hani mafundizo gayahulike kwa sama ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo na wayage wakwela meli kulawa Pafo mbaka Peliga, buga dikalile Pamfulia, baho Yohana Maluko kawaleka ako kabwela Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wagendelela na mwanza kulawa Peliga mbaka wavika kudibuga da Antiokia Pisidia. Mwiisiku ya Kubwihila wengila mng'anda ya kumpula Mulungu ya Wayahudi, wakala hasi. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Viwamambukize kusoma Malagizo ga Musa na maandiko ga watula ndagu wa Mulungu, wakulu wa ng'anda ya kumpula Mulungu ya Wayahudi wawagalila usenga, walonga, “Ndugu zetu, mwahawa na usenga wa kugangamiza towapula mulonge na wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo kenuka, kawenulila makono, kalonga, “Ndugu zangu Waizilaeli na wanhu wose muli hano mumgwaa ukulu Mulungu, nhegelezeni! ");
INSERT INTO kdc2014_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mulungu wa wanhu wa Izilaeli kawasagula wahenga zetu na kawatenda isi ng'hulu viwakalile mwiisi ya Misili. Mulungu kawalava mwiisi ya Misili kwa udahi mkulu, ");
INSERT INTO kdc2014_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","kwa miyaka malongo mane ako kuluwala kafunga umoyo mbuli ya sang'hano zao. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kazibananga isi saba mwiisi ya Kanaani na kawatenda wanhu zake wawe wenekae. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gano gose gatendeka kwa miyaka magana mane na malongo matano. “Abaho kawagwaa wasemi wawalangulize mbaka kipindi cha mtula ndagu wa Mulungu Samweli. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Baho wanhu walonda wawe na mndewa, Mulungu kawagwaa Sauli mwanage Kishi wa kabila da Benjamini, yawe mndewa wao kwa miyaka malongo mane. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Viyamsegeze Sauli, Mulungu kamtenda Daudi yawe mndewa wao. Vino vivo viyalongile Mulungu mbuli yake, ‘Nimona Daudi mwanage Yese ayo munhu younogeza moyo wangu, munhu yonda yatende gose gonilonda yatende.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mulukolo lwa Daudi mumo yalawile Yesu, Mulungu kamtenda yawe Mkombola wa wanhu wa Izilaeli kamba viyalongile. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu yang'hali hana songa sang'hano yake, Yohana kawapetela wanhu wose wa Izilaeli waleke nzambi zao na wabatizigwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohana viyakalile behi na kuimambukiza sang'hano yake, kawauza wanhu, ‘Vino mweye mogesa niye iyo Mkombola? Niye sili ayo yumumbetela. Heyo kokwiza kukisogo changu, niye sifaya hata kudohola vilatu vake.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ndugu zangu Waizilaeli, lukolo lwa Abulahamu, na wanhu wose hamuli Wayahudi muli hano mumgwaa ukulu Mulungu, usenga uno wa kukomboligwa ugaligwa kumwetu! ");
INSERT INTO kdc2014_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwavija wanhu wakalile Yelusalemu na wakulu zao hawajuwile Yesu iyo Mkombola, vivija hawazijuwile mbuli za watula ndagu wa Mulungu zisomigwe kila siku ya Kubwihila. Avo watenda mbuli zilongigwe na watula ndagu wa Mulungu zilawilile kwa kumtagusa Yesu yafe. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hamoja hawapatile kilamuso cha kumkomela, wampula Pilato yamtaguse kufa. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Viwamambukize kutenda kila kinhu kilongigwe na Maandiko Gang'alile mbuli yake, wamuhumulusa mumsalaba wamwika mdipanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Mulungu kamzilibula kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwa siku nyingi kawalawilila wanhu waja yakalile yokwanga nao kulawa Galilaya mbaka Yelusalemu. Wanhu awo sambi wowalongela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tweye twiza kuwapetela Mbuli Inogile, mbuli iyalongile Mulungu kwa wahenga zetu kamba koitenda, ");
INSERT INTO kdc2014_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","sambi katutendela, tweye lukolo lwake, kwa kumzilibula Yesu. Kamba viyandikigwe mna ikitabu cha Zabuli ya kabili, ‘Gweye kwa Mwanangu, na lelo nolonga wose wajuwe niye na Tatako.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Vino vivo viyalongile Mulungu mbuli ya kumzilibula kulawa kwa wafile, sekeyole mdipanga. ‘Nowanogela kwa unogelwa ung'alile kamba vinimulongele Daudi.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hanhu hayagwe mna ikitabu cha Zabuli holonga, ‘Mulungu hondaumuleke mtumigwa wako yang'alile yole mdipanga.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mbuli ino hailawilile kwa Daudi, kwavija Daudi kasang'hana gayalondile Mulungu, abaho kafa, kazikigwa hamoja na wahenga zake, na lukuli lwake luola mdipanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini haikalile vivo kwa ayo Mulungu yaamzilibule kulawa kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ndugu zangu Waizilaeli, tolonda mujuwe, usenga wa nzambi kugeligwa kumgongo wopetigwa kumwenu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Munhu yoyose yomtogola Yesu kolekesigwa, lakini mbuli ino haidahike mna Gamalagizo ga Musa. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Avo, muiteganye, sekegawalawilile gaja galongigwe na watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Tegelezeni mweye muli wafyosi! Kanganyeni mufe! Kwavija kinhu kinhenda sambi, honda mkitogole bule, hata kamba munhu yahawasimulila!’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Balinaba viwakalile wolawa mng'anda ya kumpula Mulungu, wanhu wawagoneka wabwele mna Isiku iyagwe ya Kubwihila, wawapetele goya mbuli izo. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wanhu viwasegele mumting'hano Wayahudi wengi na wanhu haweli Wayahudi waitogole dini ya Kiyahudi wawakweleleza Paulo na Balinaba. Watumigwa wawagangamiza wagendelele kukala mna ing'hekewa ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Siku iyagwe ya Kubwihila kila munhu kudibuga keza kutegeleza mbuli ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wayahudi viwaluwone lunhu lwa wanhu, wona migongo, wakilema kiyalongile Paulo na wamuliga. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lakini Paulo na Balinaba wagangamala kulonga, “Mbuli ya Mulungu ilondeka tanhu ipetigwe kumwenu. Lakini kwavija muilema na muiyona wenyego hamufaya kuupata ugima wa mazuwa gose, tweye towaleka tochola kwa wanhu haweli wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwavija dino ijo lagizo diyatugwee Mndewa, ‘Niwatenda mulenge kwa wanhu haweli wayahudi, ili wanhu wose wa mwiisi wakomboligwe.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wanhu haweli Wayahudi viwahulike avo, wadeng'helela na walonga usenga wa Mndewa unoga, na wanhu wose wasaguligwe kuupata ugima wa mazuwa gose wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mbuli ya Mndewa ibwililika kila hanhu mwiisi ayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lakini wakulu wa Wayahudi wawading'hula watwanzi haweli Wayahudi wakalile wotegelezigwa na womgwaa ukulu Mulungu na wambigalo wakalile na vinhu vingi kudibuga dija. Wasonga kuwadununza Paulo na Balinaba na kuwawinga mwiisi yao. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Watumigwa wakung'husa nhimbwisi za mmagulu gao kulagusa walemigwa, abaho wachola Ikonia. ");
INSERT INTO kdc2014_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wanahina wa Yesu ako Antiokia wadeng'helela na wamema Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ako Ikonia mbuli zilawilila kamba vizilawilile kuja Antiokia, Paulo na Balinaba wengila mng'anda ya kumpula Mulungu, wawasimulila wanhu mbaka wanhu wengi wakalile Wayahudi na wanhu haweli Wayahudi wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Wayahudi hawamtogole Yesu wawading'hula wanhu haweli Wayahudi wagombe na wanhu wamtogole Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo na Balinaba wakala ako kwa siku nyingi, wolonga kwa kugangamala mbuli ya Mndewa, na Mndewa kalagusa kamba usenga wao mbuli ya ng'hekewa ukala kweli kwa kuwagwaa udahi wa kutenda unzonza na vilaguso. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wanhu wa isi ayo wakala waigolile, wayagwe wakala ubanzi wa Wayahudi na wayagwe ubanzi wa watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Abaho wanhu wayagwe haweli Wayahudi na Wayahudi, na walangulizi wao waitogolela kuwatendela vihile watumigwa na kuwatowa kwa mabwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Watumigwa viwaijuwile mbuli iyo, wakimbilila Lusitila na Delibe mwiisi ya Lukaonia na mziisi zili mmabehi. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wakala ako wowapetela wanhu Mbuli Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ako Lusitila kukala na munhu imoja yakalile mbetembete toka yavumbuke na kakala hadahile kugenda. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Munhu ayo kakala yomtegeleza Paulo viyakalile kolonga. Paulo kona kotamanila na kodaha kuhonyigwa, avo kamulola bunhuu, ");
INSERT INTO kdc2014_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kakemelela, “Ima kwa magulu gako!” Munhu ayo kazumha zumha kasonga kugenda. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lunhu lwa wanhu viluwone kija kiyatendile Paulo, wasonga kukemelela kwa ulonzi wa kumwao wa Kilukaonia, “Walungu wagaluka wanhu na watuhumulukila!” ");
INSERT INTO kdc2014_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balinaba wamgwaa twaga da Zeu na Paulo wamgwaa twaga da Helime, kwavija iyo yakalile mulongaji mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mulava nhosa wa mulungu yakemigwe Zeu, kagala ng'ombe mbigalo na maluwa hana ulwivi lwa buga dijo. Kwavija heyo na lunhu walonda kuwalavila nhosa watumigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lakini Balinaba na Paulo viwahulike kija kiwalondile kutenda wanhu awo, wadega viwalo vao wakimbilila hagati ya ulunhu lwa wanhu, kuno wokemelela, ");
INSERT INTO kdc2014_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Habali motenda vivo? Tweye vivija twa wanhu kamba mweye! Tweye twiza hano kuwapetela Mbuli Inogile, muleke kumtendela gehile Mulungu yeli Mgima, yaumbile ulanga na isi na bahali na vose vili mgati yake. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Baho umwaka Mulungu kawaleka wanhu wose watende kamba viwalondile. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lakini halekile kuilagusa kamba kabaho kwa mbuli zinogile ziyotenda, kowagwaa mweye mvula kulawa kuulanga na ndiya mna ikipindi chake, kowagwaa lujo na kuimemeza mizoyo yenu deng'ho.” ");
INSERT INTO kdc2014_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hamoja watumigwa walonga avo, lakini ikala vidala ng'hani kulugomesa lunhu lwa wanhu luleke kuwalavila nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lakini Wayahudi wayagwe walawa Ikonia na Antiokia na isi ya Pasidia na wawatewenza wanhu wailumbe nao, wamtowa mabwe Paulo na kumulava kunze ya buga, wagesa kakala yafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lakini wanahina wa Yesu viwamzunguluke, kenuka kabwela kudibuga. Imitondo yake Paulo na Balinaba wachola Delibe. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo na Balinaba wawapetela wanhu Mbuli Inogile ako Delibe na wapata wanahina wengi. Abaho wabwela Lusitila mbaka Ikonia na Antiokia ya Pisidia. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wawagangamiza wanahina wa Yesu na wawalonda wakale mna ukutamanila, wawafundiza, “Tolondeka tubitile madununzo mengi muladi twingile Muundewa wa Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo na Balinaba wasagula wavele kila kibumbila cha wanhu wamtogole Yesu, kwa kumpula Mulungu na kufunga kuja waweka mmakono ga Mndewa, iwamtamanile. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Viwabitile mna zimbaka za isi ya Pisidia wavika Pamfulia. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Viwamambukize kuwapetela wanhu usenga ako Peliga wachola Atalia. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kulawa Atalia wakwela meli wabwela Antiokia, hanhu hawekiligwe makono kupuliligwa ng'hekewa kwa Mulungu mbuli ya sang'hano iwaimambukize. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Viwavikile Antiokia, watenda mting'hano wa kibumbila cha wanhu wamtogole Yesu, wawalongela mbuli zose ziyawatendele Mulungu na vija viyafungule nzila kwa wanhu haweli Wayahudi wamtogole Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wakala siku nyingi hamoja na wanahina wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wanhu wayagwe walawa Yudea weza Antiokia na wasonga kuwafundiza wanhu wamtogole Yesu, walonga, “Honda mukomboligwe mbaka mwingile kumbi kamba Malagizo ga Musa vigalonda.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo na Balinaba waibamilila ng'hani na hewo kwa mbuli ino, avo waitogolela Paulo na Balinaba na wanhu wayagwe wa Antiokia wachole Yelusalemu kulonga na watumigwa na wavele wa kibumbila cha wanhu wamtogole Yesu kwa sama ya mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wanhu wamtogole Yesu ako wawatuma na viwakalile wochola kubitila Foinike na Samalia, wawalongela wanhu vija wanhu haweli Wayahudi viwamtogole Mulungu, mbuli ino itenda wanhu wamtogole Yesu wadeng'helele. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Viwavikile Yelusalemu wabokeligwa na wanhu wamtogole Yesu na watumigwa na wavele, wawasimulila gose gayatendile Mulungu kubitila hewo. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini wanhu wayagwe wamtogole Yesu wa kibumbila cha Mafalisayo wema walonga, “Wanhu haweli Wayahudi wolondeka wengile kumbi na kulongeligwa wagagoge Malagizo ga Musa.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Watumigwa na wavele waiting'hana hamoja muladi kulonga mbuli iyo. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Viwagendelele ng'hani kulonga Petulo kema kalonga, “Ndugu zangu toka mwaka mujuwa Mulungu kanisagula kumwenu niwapetele Mbuli Inogile wanhu haweli Wayahudi, muladi wahulike na kutogola. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mulungu yajuwile goyogesa kila munhu, kalagusa viyawatogole wanhu haweli Wayahudi kwa kuwagwaa Loho Yang'alile kamba viyatendile kumwetu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mulungu hatubagule bule tweye na wao, kaisunha mizoyo yao kwavija wamtogola Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vino habali molonda kumgeza Mulungu? Vino habali molonda kuwadikwa wanahina wa Yesu mizigo mikulu? Wahenga zetu hebu tweye hatudahile kuipapa. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Totogola na kukomboligwa kwa ng'hekewa ya Mndewa Yesu, kamba viili kumwao.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bumbila jose da wanhu dikala huupi viwawahulike Balinaba na Paulo wosimulila mbuli zose za unzonza na vilaguso ziyatendile Mulungu kubitila wao kwa wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Viwamambukize kusimulila, Yakobo kasonga kulonga, “Ndugu zangu, nhegelezeni! ");
INSERT INTO kdc2014_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni kasimulila vija Mulungu ichanduso viyawanogele wanhu haweli Wayahudi kwa kuwasagula wanhu kulawa kumwao wawe wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mbuli zino ziigala na mbuli za watula ndagu wa Mulungu. Kamba Maandiko Gang'alile vigalonga, ");
INSERT INTO kdc2014_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Mndewa kolonga, ‘Abaho nobwela na kukizenga kabili kiheha cha Daudi, nokizenga kiheha chake, na kukizenga goya kabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Baho wanhu wayagwe wose wa mwiisi wokwiza kumwangu, wanhu wose haweli Wayahudi waniwasagule wawe wangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Avo viyolonga Mndewa, yatendile mbuli ino ijuwike toka mwaka.’” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo kagendelela kulonga, “Vinikona niye, tuleke kuwagaza wanhu haweli Wayahudi wombwelela Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lakini tuwandikile baluwa kuwalongela waleke kuja lujo halufaya lulavigwe nhosa kwa vinyago, muladi kuwagomesa sekewatende ugoni, waleke kuja mnyama yabobotoligwe hebu kung'wa damu. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwavija Malagizo ga Musa gasomigwa toka mwaka mna zing'anda za kumpula Mulungu kila siku ya Kubwihila, mbuli zake zipetigwa mmabuga.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abaho watumigwa na wavele na wanhu wose wamtogole Yesu ako Yelusalemu, waitogolela kusagula wanhu kulawa mdibumbila na kuwagala Antiokia hamoja na Balinaba na Paulo. Wawasagula wanhu wabili wakalile wotegelezigwa ng'hani na wanhu wamtogole Yesu, wanhu wao wakala Yuda yakemigwe Balisaba na Sila. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wawagwaa baluwa yandikigwe vino, “Tweye watumigwa na wavele, ndugu zenu, towalamusa mweye ndugu zetu hamuli Wayahudi mukala Antiokia, Siliya na Kilikia. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuhulika kuna wanhu walawa kumwetu wawading'hula na kuwaleka moyo yungwayungwa kwa mbuli ziwawalongele, lakini tweye hatuwatumile bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Avo tuiting'hana hamoja na wose tuitogolela kuwasagula wasenga na kuwatuma kumwenu. Wokuwa hamoja na mbwiga zetu Balinaba na Paulo, ");
INSERT INTO kdc2014_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","wao waulava ugima wao mbuli ya sang'hano ya Mndewa Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Avo towatuma kumwenu Yuda na Sila, wonda wawalongele kwa mulomo mbuli zituwandikila. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Avo Loho Yang'alile na tweye tuitogolela seketuwadikwe mizigo iyagwe kubanza malagizo gano. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sekemuje lujo lulavigwe nhosa kwa vinyago, sekemung'we damu, sekemuje nyama ya mnyama yabobotoligwe, muiteganye na ugoni. Motenda goya kamba mwahaleka kusang'hana mbuli zose zino. Mkale goya.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Viwamambukize kuwalaga, wanhu awo watumigwe wachola Antiokia, ako wawakema hamoja wanhu wamtogole Yesu, wawagwaa baluwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wanhu awo viwaisomile baluwa iyo, wadeng'helela ng'hani mbuli ya usenga wa kuwagangamiza. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, wakalile watula ndagu wa Mulungu walonga nao ng'hani, wawagangamiza na kuwagela moyo. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Viwakalile kipindi kidodo, walagigwa kwa tindiwalo na wanhu wamtogole Yesu, wabwela kwa waja wawatumile. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lakini Sila kasigala ako. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Balinaba wakala ako Antiokia kwa kipindi kidodo, wawafundiza wanhu na kuwapetela mbuli ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hazibitile siku nyingi Paulo kamulongela Balinaba, “Tubwele tukawakagule waetu wamtogole Yesu mna gamabuga gatupetile mbuli ya Mndewa, tukawalole viwogendelela.” ");
INSERT INTO kdc2014_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balinaba kalonda kumsola Yohana Maluko wachole wose, ");
INSERT INTO kdc2014_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","lakini Paulo halondile wachole nayo, kwavija hakalile nao mbaka kuuhelelo wa sang'hano yao. Kwavija kabwela na kuwaleka wao ako Pamfulia. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Avo waibamilila, abaho waigola Balinaba kamsola Yohana Maluko wakwela meli wachola Kupulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lakini Paulo kamsagula Sila, wanhu wa ako wamtogole Yesu wampulila ng'hekewa ya Mndewa, abaho kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kachola Siliya na Kilikia na kuwagangamiza wanhu wamtogole Yesu mziisi azo. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo kavika Delibe na Lusitila, ako kukala na mwanahina wa Yesu imoja yakemigwe Timoseo. Mamake kakala Muyahudi yamtogole Yesu, lakini tatake kakala Mgiliki. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wanhu wose wamtogole Yesu ako Lusitila na Ikonia wamtogola Timoseo. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo kalonda kumsola Timoseo, avo kamwingiza kumbi. Katenda vivo kwavija Wayahudi wose wakalile ako wajuwa kamba tatake Timoseo kakala Mgiliki. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Viwakalile wobita mna gamabuga gaja wawagwaa wanhu malagizo galavigwe na watumigwa na wavele ako Yelusalemu, wawalongela wagagoge. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Wanhu wamtogole Yesu mziisi azo wagangamizigwa mna ukutamanila na wanhu wongezeka kila siku. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Wabitila isi ya Fulugia na Galatia kwavija Loho Yang'alile hawatogolele wawapetele wanhu usenga awo mwiisi ya Asiya. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Viwavikile mna zimbaka za Misiya, walonda kuchola mwiisi ya Bisiniya, lakini Loho wa Yesu hawatogolele bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Avo wabitila Misiya, wachola dimwe kwa dimwe mbaka Tuloasi. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ikilo Paulo kalagusiligwa kinhu na Mulungu, kamona munhu wa Makedonia kema kampula, “Loka wize Makedonia ututaze!” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Baho Paulo viyalagusiligwe kinhu acho, tuitanda kuchola Makedonia, kwavija tona Mulungu katukema kuwapetela wanhu Mbuli Inogile ako. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tulawa Tuloasi, tuloka kwa meli dimwe kwa dimwe mbaka Samotilake, imitondo yake tuvika Neapoli. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tulawa ako tuchola mbaka Filipi, buga kulu da Makedonia, buga dizengigwe na Walumi. Tukala ako siku nyingi. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Siku ya Kubwihila tulawa kudibuga dija tuchola mumgwazo wa lwanda, twagiza aho, baho hooiting'hana Wayahudi kumpula Mulungu. Tukala hasi tulonga na iwatwanzi waiting'hane aho. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mna iwaja wakalile wotutegeleza kukala na mtwanzi imoja yakalile yomgwaa ukulu Mulungu, mtwanzi ayo twaga jake Lidia mwenekae wa Tuatila ayo kakala mchuuza viwalo vinogile va bei ng'hulu. Mndewa kamfungula umoyo kadaha kuzibokela mbuli ziyalongile Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Heyo na wanhu wa mulubuga lwake viwamambukize kubatizigwa katugoneka, kalonga, “Mwahanyona nomtamanila Mndewa mwize ukae mukale.” Avo katunanahiza ng'hani tuchole. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Siku dimoja vitukalile tochola hanhu ha kumpula Mulungu, tumting'hana mtumwa imoja mtwanzi yakalile na kinyamkela wa ulaguzi. Mtumwa ayo kawapatila sente nyingi wakulu zake mbuli ya kulagula. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Avo mndele ayo kamkweleleza Paulo na tweye, kuno kokemelela, “Wanhu wano wasang'hanaji wa Mulungu Yeli Uchanha Ng'hani! Wowapeteleni nzila ya kukomboligwa!” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Katenda avo kwa siku nyingi, mbaka siku dimoja Paulo kagevuzika, kahinduka kamulongela iyo ikinyamkela, “Nokulagiza kwa twaga da Yesu Kilisito mulawe mndele ino!” Bahaja kinyamkela kamulawa. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iwakulu wa mndele ayo viwone nzila yao ya kupata sente isegela, wawagoga Paulo na Sila, wawabulula mbaka haulongozi wa iwakulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wawagala kwa wasemi walonga, “Wanhu wano Wayahudi, nao wogala ndwagi mwiisi yetu. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wofundiza vihendo vigomigwe na Malagizo getu, tweye twa wenekae wa Lumi hatudaha kuvitogola vihendo vino wala hatuvigoga.” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lunhu lwa wanhu luilumba kuwatowa Paulo na Sila. Abaho wasemi wawavula viwalo Paulo na Sila na walagiza watoigwe mbalati. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Viwamambukize kuwatowa ng'hani, wawagodeka mkifungo, mkulu wa kifungo kalagilizigwa yaweke muukalizi mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Viyapatile ndagilizi zizo, kaweka mdigati dili mgati ng'hani na kagafunga magulu gao mzimhanda. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kilo kikulu Paulo na Sila wampula Mulungu na kumwimbila nyila za kumtogola, wafungwa wayao wakala wowategeleza. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bahaja ulawilila mtigisiko mkulu wa isi, mhanda za kifungo zitigisika. Baho nyivi zose zivuguka na nzabi ziwagodekigwe zifunguka. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mkalizi wa ikifungo kalamuka. Viyone nyivi za kifungo zivuguka, kagiza wafungwa wakimbila, avo kasomola panga jake yaikome mwenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini Paulo kakemelela ng'hani, “Sekeuikome! Tweye wose twa baha!” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mkalizi wa kifungo kapula taa igaligwe, kazumhila mng'anda, kalagalila mmagulu ga Paulo na Sila kuno kogwaya. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Abaho kawalava kunze kawauza, “Mo wakulu, nhende choni ng'homboligwe?” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wamwidika, “Mtogole Mndewa Yesu na gweye kokomboligwa hamoja na wanhu wa mulubuga lwako.” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Avo wampetela mbuli ya Mndewa hamoja na wanhu wa mulubuga lwake. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mna isaa iija ya ikilo mkalizi wa kifungo kawasola Paulo na Sila kawasunha vilonda vao, abaho bahaja heyo na wanhu wa mulubuga lwake wabatizigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Abaho kawagala Paulo na Sila uchanha mng'anda yake na kawagwaa lujo. Heyo na wanhu wa mulubuga lwake wadeng'helela ng'hani, kwavija sambi wakala wamtogole Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Imitondo yake wakulu wa Lumi wawatuma wakulu wa wakalizi kuno wawalagiza, “Walekeni wanhu wao wachole.” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Avo mkulu wa kifungo kamulongela Paulo, “Iwakulu watulagiza tuwafungulile gweye na Sila. Avo choleni moyo uholile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lakini Paulo kawalongela iwakulu wa wakalizi, “Watutowa mgameso ga wanhu hamoja hatubanange mbuli, tweye twa wenekae wa Lumi lakini watugodeka mkifungo. Lelo wolonda kutufungulila kinyelegezi, bule! Leka weze watufungulile wenyego.” ");
INSERT INTO kdc2014_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wakulu wa wakalizi wawalongela mbuli zino wakulu wa Lumi, na iwakulu viwahulike Paulo na Sila wakala wenekae wa Lumi, wadumba ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Avo weza na kuwapula wagele kumgongo mbuli ziwawatendele, abaho wawalava mkifungo, wawapula wasegele kudibuga dija. ");
INSERT INTO kdc2014_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila walawa mkifungo wachola mng'anda ya Lidia. Mumo wawavika Wakilisito, wawalongela mbuli za kuwagangamiza, abaho walawanya. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila wagenda kubitila buga da Amifipoli na buga da Apolonia mbaka Sesalonike, ako kukala na ng'anda ya kumpula Mulungu ya Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kamba viyatendaga, Paulo kengila mng'anda ya kumpula Mulungu. Kwa siku ndatu za Kubwihila kalonga na wanhu, kwa Maandiko Gang'alile, ");
INSERT INTO kdc2014_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kuwalagusila kamba Kilisito Mkombola kalondeka yadununzike na kuzilibuka kwa wafile, Paulo kawalongela, “Ino Yesu inimsimulila kumwenu, iyo Kilisito Mkombola.” ");
INSERT INTO kdc2014_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wanhu wayagwe watogola wailumba na Paulo na Sila, vivija walangulizi wa kitwanzi na bumbila da Wagiliki womgwaa ukulu Mulungu watenda vivo. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini Wayahudi wona migongo, wawasola wanhu wehile kulawa kuna digulilo, watenda bumbila na kugala ugomvi mwiisi ayo yose. Wengila mng'anda ya Yasoni kuwazahila Paulo na Sila wawagale mgameso ga wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lakini hawawapatile bule, avo wawabulula Yasoni na wanhu wayagwe wamtogole Yesu mgameso ga wakulu wa buga dija wakemelela, “Wanhu wano wagala ndwagi kila hanhu! Na sambi weza kudibuga jetu, ");
INSERT INTO kdc2014_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Yasoni kawagoneka mng'anda yake. Wano wose hawagagoga malagizo ga Mndewa wa Lumi, na wolonga kuna mndewa iyagwe twaga jake Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mbuli zino zilutenda lunhu na wakulu wa buga dija moyo yungwayungwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iwakulu wa buga wawatoza sente Yasoni na wayage, abaho wawafungulila wachole. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Viivikile ikilo, wanhu wamtogole Yesu wawagala Paulo na Sila ako Beleya. Viwavikile ako wengila mng'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wanhu wa Beleya wakala wotegeleza vinogile ng'hani kubanza wanhu wa Sesalonike. Wauhulika usenga awo kwa kusulukila, kila siku wakala wogalolesa goya Maandiko Gang'alile, wone kamba Paulo kakala yolonga kweli. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wanhu wengi watogola, na watwanzi wengi wa Kigiliki wakalile wakulu watogola na vivija wambigalo wengi watogola. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini Wayahudi wakalile Sesalonike viwahulike Paulo vivija kawapetela mbuli ya Mulungu wanhu wa Beleya, wachola ako na kugala ndwagi na kuwading'hula wanhu wao. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bahaja wanhu wamtogole Yesu wamgala Paulo mhwani lakini Sila na Timoseo wasigala Beleya. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wanhu wakalile womsindikiza Paulo wachola nayo mbaka Asene, abaho wabwela Beleya na usenga kulawa kwa Paulo, kamba Sila na Timoseo sekewakawe kuchola kumwake. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo vikalile kowabeta Sila na Timoseo ako Asene kagevuzika ng'hani viyonile buga dijo dimema vinyago va milungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Avo kakala kolonga na Wayahudi na wanhu haweli Wayahudi womgwaa ukulu Mulungu mng'anda ya kumpula Mulungu. Na kila siku kakala yolonga na wanhu wakalile mna gamagulilo. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wanhu waifunzile nzewele za Epiluko na Stoiki hawamtogolele, wayagwe walonga, “Ubozi gani woolonga munhu ino?” Wayagwe wedika, “Yokoneka kolonga mbuli ya milungu haijuwika?” Walonga avo kwavija Paulo kakala yowapetela mbuli ya Yesu na kuzilibuka. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Avo wamsola Paulo wamgala kwa wanhu wa mkitala cha Aleopago cha buga dija, walonga, “Tolonda kujuwa mbuli ya gano mafundizo ga sambi goulonga. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Vinhu viyagwe vituhulike kolonga tona vifukuzi kumwetu, tolonda tujuwe fambulo da mbuli izo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kwavija wenekae na wageni wose wa Asene na wanhu wayagwe wakalile ako wakala wosimulila na kuilongela mbuli izo za sambi kipindi chose. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo kema haulongozi wa wanhu wa mkitala cha buga da Aleopago kalonga, “Vinikona niye mweye wanhu wa Asene mwa wanhu wa dini. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwavija vinikalile notembela mwiisi yenu ndola kila hanhu homutambikila, nyona upango wa kulavila nhosa umoja wandikigwa, ‘Kwa Mulungu hajuwike.’ Avo ayo imumtambikila bila kumjuwa iyo iniwapeteleni sambi. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mulungu yatendile vinhu vose vili mwiisi, iyo Mndewa wa ulanga na isi na hakala mzing'anda zizengigwe na wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Vivija hasang'hanilwa kwa makono ga wanhu kamba vija kolonda chochose kulawa kumwao, kwavija heyo mwenyego iyo yowagwaa wanhu ugima, kowatenda wawe na mhumuzi na kila kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kwa munhu imoja Mulungu kawaumba wanhu wose na kutenda wakale mwiisi yose, kulawa kuna ichanduso kagesa lini na kwahi wanhu wahakalile. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Katenda vino muladi wanhu wose wamzahile, vivija kwa kumzahila zahila wapate kumuwinza. Lakini Mulungu hali kutali na kila imoja wetu, ");
INSERT INTO kdc2014_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kamba viyalongile munhu imoja, ‘Mgati mmwake tokala, togenda na twa wagima.’ Kamba viyalongile mtunga lwila wenu imoja, ‘Tweye vivija twa wanage.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwavija tweye twa wana wa Mulungu, havinogile bule kugesa Mulungu kaigala na zahabu hebu shaba hebu dibwe disongoligwe na kwikigwa ulembo na wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mulungu kaitenda halola kipindi kija wanhu viwakalile wabozi. Lakini lelo kowalagiza wanhu kila hanhu wazileke nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwavija Mulungu keka siku dimoja donda yawataguse wanhu wose wa mwiisi bila kumonela munhu kubitila munhu iyamsagule. Mulungu kawalagusila mbuli ino kwa kumzilibula munhu ayo kulawa kwa wafile!” ");
INSERT INTO kdc2014_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Viwamuhulike Paulo kolonga mbuli ya kuzilibuka kwa wafile, wanhu wayagwe wamzeha, lakini wayagwe walonga, “Tolonda kuihulika kabili mbuli ino.” ");
INSERT INTO kdc2014_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Avo Paulo kawaleka kasegela mkitala. ");
INSERT INTO kdc2014_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wanhu wayagwe watogole wailumba na Paulo, mna iwao kakala Diyonisiyo, yakalile munhu wa mkitala, vivija kukala na mtwanzi yakemigwe Damali na wanhu wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Vigamalile gano, Paulo kasegela Asene kachola Kolinto. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ako Kolinto kamvika Muyahudi yakemigwe Akula, mwenekae wa Ponto, yabwelile kulawa Italia hamoja na mtwanzi wake Pilisila, kwavija Kaisali Kilaudio kalagiza Wayahudi wose wasegele Lumi. Paulo kachola kuwalola, ");
INSERT INTO kdc2014_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","kwavija awo wakala mafundi wa kusona mahema kamba Paulo, avo kakala nao na kusang'hana. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila siku ya Kubwihila kakala kolonga na wanhu mng'anda ya kumpula Mulungu, kageza kuwakwega Wayahudi na Wagiliki. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoseo viwasegele Makedonia, Paulo kasonga kuwapetela wanhu kipindi chake chose, kuwalagusila Wayahudi kamba Yesu kakala Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Viwamulemele na kumuliga, kakung'huna nhimbwisi ya viwalo vake kalonga, “Kamba mwahapotela mmhane wenyego, niye namduhu. Kulawa sambi na kugendelela nochola kwa wanhu haweli Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Avo kawaleka kachola kukala mng'anda ya munhu imoja hali Muyahudi twaga jake Tito Yusito, yakalile munhu yomgwaa ukulu Mulungu, ng'anda yake ikala behi na ng'anda ya kumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo yakalile mkulu wa ng'anda ya kumpula Mulungu kamtogola Mndewa hamoja na wanhu wose wa mulubuga lwake na wanhu wayagwe wengi wauhulike usenga awo mwiisi ya Kolinto, watogola na wabatizigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Siku dimoja ikilo Mndewa kamulagusila Paulo kinhu, kamulongela, “Sekeudumbe, gendelela kuwapetela wanhu sekeubwele kukisogo, ");
INSERT INTO kdc2014_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwavija na hamoja na gweye. Kuduhu munhu yonda yadahe kukulumiza kwavija kudibuga dino ninao wanhu wengi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Avo Paulo kakala ako mwaka mgima na miezi sita kowafundiza wanhu mbuli ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakini kipindi Galio viyakalile mkulu wa isi ya Akaya, Wayahudi waiting'hana, wamgoga Paulo wamgala mkitala. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Walonga, “Munhu ino kowatenda wanhu wamgwee ukulu Mulungu bila kukweleleza Malagizo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo yang'hali hanalonga mbuli, Galio kawalongela Wayahudi, “Mazaikalile mbuli ya ubavi hebu ubananzi nahawategeleze. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini kwavija moibamilila mbuli ya matwaga na malagizo genu wenyego, lamuleni mweye wenyego niye silonda kuwa msemi bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Baho kawawinga mkitala. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Abaho wose wamgoga Sositene yakalile mkulu wa ng'anda ya kumpula Mulungu, wamtowa bahaja haulongozi wa kitala. Lakini Galio haitongile bule mbuli iyo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo kakala Kolinto siku nyingi hamoja na wanhu wamtogole Yesu. Abaho kawaleka kakwela meli hamoja na Pilisila na Akula mbaka Siliya. Yang'hali hanakwela meli kuchola Kenkela, tanhu kasenya mvili zake kwavija kakala yaiduile. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Viwavikile Efeso baho Paulo kawaleka Pilisikila na Akula, kengila mng'anda ya kumpula Mulungu kulonga na Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wanhu wampula yakale siku nyingi lakini kawalemela. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lakini viyakalile kosegela kawalongela, “Mulungu yahalonda nobwela kabili kumwenu.” Avo kakwela meli kasegela Efeso. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Viyavikile Kaisalia kachola Yelusalemu kuwalamusa wanhu wamtogole Yesu, abaho kachola Antiokia. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kakala siku ndodo, kasegela kubitila Galatia na Fulugia kuwagangamiza wanahina wose wa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kipindi acho kukala na Muyahudi imoja yakemigwe Apolo, mwenekae wa Alekizandilia keza Efeso. Kakala munhu yajuwile kulonga na ubala wa Maandiko Gang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kakala yafundizigwe nzila ya Mndewa, yang'hali hanavulala kalonga mbuli za Yesu, kawafundiza goya hamoja kakala yaujuwile ubatizo wa Yohana wiiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Pilisila na Akula viwamuhulike kolonga bila kudumba mng'anda ya kumpula Mulungu, wamsola wamgala ukayao wamfambulila goya mbuli za Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo viyalondile kuchola Akaya, wanhu wamtogole Yesu wamgangamiza kwa kuwandikila baluwa wanahina wa Yesu ako Akaya wambokele. Viyavikile ako kwa udahi wa ng'hekewa ya Mulungu kadaha kuwataza wanhu wa ako wamtogole Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwa ubala wake wa kulonga kawahuma Wayahudi haulongozi ha iwanhu wose kwa kulagusa Maandiko Gang'alile kamba Yesu iyo Kilisito Mkombola. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo viyakalile Kolinto, Paulo kachola kubitila mvijiji na kavika Efeso. Ako kawavika wanahina wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kawauza, “Vimumtogole Yesu mubokela Loho Yang'alile?” Wamwidika, “Aka, hata kuhulika hatunahulika kamba kuna Loho Yang'alile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo kawauza, “Vino mubatizigwa ubatizo gani?” Wamwidika, “Ubatizo wa Yohana.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo kalonga, “Ubatizo wa Yohana ukala kwa wanhu wose watogole kuleka nzambi zao. Yohana kawalongela wanhu wa Izilaeli wamtogole ayo yonda yeze kukisogo chake, nayo iyo Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Viwahulike avo, wabatizigwa kwa twaga da Mndewa Yesu ");
INSERT INTO kdc2014_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo kawekila makono na Loho Yang'alile kawahumulukila, walonga kwa ulonzi uyagwe na vivija walagula usenga wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wose kwa wose wakala wanhu longo na wabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa kipindi cha miezi midatu Paulo kakala yochola mng'anda ya kumpula Mulungu, kakala kolonga nao muladi yawagale Muundewa wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini wayagwe wakala wadala, walema kutogola wasonga kulonga vihile mbuli ya Mndewa mna iwanhu. Baho Paulo kawaleka kawasola wanahina wa Mndewa, kakala kolonga nao kila siku mdigati da kuifunzila da Tulano. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mbuli zino zigendelela kwa kipindi cha miyaka mibili mbaka wanhu wose wakalile mwiisi ya Asiya, Wayahudi na wanhu haweli Wayahudi, waihulika mbuli ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mulungu katenda mbuli za unzonza ng'hulu kubitila Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Wanhu wakala wosola vikumbi na viwalo viyagwe viyasang'hanile Paulo, wavigala kwa watamu, nao wahonyigwa na waja wakalile na vinyamkela walavigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi wayagwe wahunga vinyamkela wachola kuno na kuno wogeza kusang'hanila twaga da Mndewa Yesu. Wawalongela vinyamkela, “Nowalagiza kwa twaga da Yesu ayo yopetigwa na Paulo mulawe.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kukala na wana saba wa Muyahudi imoja, mulava nhosa mkulu yakemigwe Sikewa, nao watenda vivo. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lakini kinyamkela kawalongela, “Yesu nimjuwa goya na Paulo nimjuwa goya, lakini mweye kina nani?” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Abaho munhu ayo yakumbigwe na ikinyamkela kawazumhila wose kawahuma nguvu. Na wao wanage Sikewe wakimbila kulawa mng'anda ayo kuno wolawa damu na viwalo vao videgekadegeka. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wayahudi wose na wanhu haweli Wayahudi wakalile Efeso waihulika mbuli ino. Wose wengila bwembwe, na kudigwaa nhogolwa twaga da Mndewa Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wanhu wengi wamtogole Yesu weza walonga mgameso ga wanhu mbuli ziwatendile. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wanhu wengi wayagwe wakalile wahawi aho haichanduso, wadondoleza vitabu vao na kuvisoma moto haulongozi wao, wagelegeza sente ya vitabu avo yovika magana malongo matano. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Avo mbuli ya Mndewa yenela na iwa na nguvu ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Vigamalile gano, Paulo kachola Yelusalemu kwa kubitila Makedonia na Akaya. Kalonga, “Nahavika ako nolondeka nichole Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Avo kawatuma wasang'hanaji zake wabili Timoseo na Elasito walongole Makedonia, nayo kakala kidogo ako Asiya. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kipindi acho kukala na ndwagi ako Efeso mbuli ya Mndewa. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kukala na munhu imoja twaga jake Demetiliyo kakala yosongola vinyago va ng'anda ya mulungu wa kitwanzi yakemigwe Atemi, sang'hano ino iwatenda waja watumigwa zake wamwede ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetiliyo kawakema hamoja wao iwasang'hanaji na wayagwe wakalile na sang'hano kamba ayo, kawalongela, “Wambigalo wayangu mojuwa topata sente kulawa mwiisang'hano ino. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lelo mohulika na kona wenyego mbuli ziyatendile Paulo siyo hano Efeso kwiiyeka, lakini vivija kose mwiisi ya Asiya. Kawading'hula na kuwatenda wanhu watogole kamba mulungu yatendigwe kwa makono ga wanhu hali mulungu bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kokuwa na zumozumo kamba sang'hano yetu yobezigwa na ng'anda ya mulungu wa kitwanzi Atemi yolongigwa siyo kinhu na kusegezeligwa ukulu wake. Mulungu ino kogweleligwa ukulu na wanhu wose wa Asiya na wose weli mwiisi!” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wanhu viwahulike vivo wagevuzika, wasonga kukemelela, “Atemi iyo mkulu wa Efeso!” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Buga jose dimema ndwagi. Wanhu wawagoga Gayo na Alisitaliko, wenekae wa Makedonia, wakalile muumwanza na Paulo, wakimbila mbaka kuna digati da mwangalo. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo kalonda kuchola kuna ulunhu, lakini wanahina wa Yesu wamgomesa. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wakulu wayagwe wa isi ayo, wakalile mbwiga zake, vivija wamtumila usenga wampula sekeyachole kuna digati da mwangalo. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kukala na tulikizi mumting'hano wose, wano wolonga vija na wayagwe wolonga vino, kwavija wanhu wengi wakala hawajuwile habali waiting'hana. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wayahudi wamtenda Alekizanda yalawilile haulongozi, avo wanhu wayagwe mna ulunhu wagiza iyo heyo. Nayo Alekizanda kawenulila wanhu mkono wanyamale kwa kulonda kuigombela. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini viwajuwile kamba kakala Muyahudi, wanhu wose wakemelela hamoja kwa masaa mabili, “Atemi ayo mkulu wa Efeso!” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Abaho kalani wa buga dija kawatenda wanhu wanyamale kawalongela, “Mweye wenekae wa Efeso, kila munhu kojuwa wanhu wa isi ino ya Efeso awo wokaliza ng'anda ya mulungu Atemi na vivija awo wokaliza mabwe mazelu galagale kulawa kuulanga. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kuduhu munhu yodaha kuibela mbuli ino. Avo nyamaleni sekemulopole kutenda kinhu chochose. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muwagala wanhu wano hano hamoja hawailigile ng'anda ya mulungu hebu kumuliga mulungu wetu wa kitwanzi. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kamba Demetiliyo na wasang'hanaji zake wana kitala na munhu yoyose, wabaha wasemi na wakulu wa isi, wodaha kuitagusila ako. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lakini kamba mna mbuli ziyagwe, zigaleni mna uuting'hano. ");
INSERT INTO kdc2014_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Maza tutagusigwe mbuli ya kuwading'hula wanhu, na vilozo vilawilile lelo. Ndwagi ino haifaya bule na sambi tudahe kuigombela vinogile mbuli ya ndwagi ayo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Viyamambukize kulonga avo, kawalongela wanhu wakalile mumting'hano waimwage. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ndwagi ya Efeso viimalile, Paulo kawakema hamoja wanahina wa Yesu, kawalongela mbuli za kuwagangamiza. Abaho kawalaga kachola Makedonia. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kabitila isi ayo kawagangamiza wanhu kwa usenga wake. Abaho kavika Ugiliki, ");
INSERT INTO kdc2014_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ako kakala miezi midatu. Kakala koitanda kuchola Siliya, viyajuwile Wayahudi wakala kiseto cha kumtenda vihile, avo kabwela kubitila Makedonia. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sapatulo, mwanage Pilo, kulawa Beleya kailongoza nayo, vivija Alisitaliko na Sekundo kulawa Sesalonike, Gayo kulawa Delibe, Tukiko na Tulofimo kulawa mwiisi ya Asiya na Timoseo. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wanhu wao walongola na kutubeta ako Tuloasi. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Viimalile Nyimwili nyimwili ya Magate hagageligwe Usasu, tukwela meli kulawa Filipi, vizibitile siku tano tuwavika kuja Tuloasi. Ako tukala siku saba. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mwiisiku ya Jumamosi ichungulo tuiting'hana hamoja muulujo. Paulo kagendelela kulonga mbaka kilo kikulu, kwavija imitondo yake kakala yosegela. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vibatali vingi vikala vikwaka mdigati da uchanha kutukalile tuiting'hane. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbwanga imoja yakemigwe Eutiko kakala yakalile mdidilisha, Paulo viyakalile kogendelela kulonga, Eutiko kasonga kukukila na kakukila mbaka kalagala hasi, kulawa mdigati da uchanha da kadatu. Viwacholile kumwinula wamvika kafa mwaka. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lakini Paulo kahumuluka hasi kainama kamuhagatila kalonga, “Sekemudumbe ino mgima!” ");
INSERT INTO kdc2014_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Abaho kabwela kabili mdigati da uchanha, kabanzula gate, kaja. Kagendelela kulonga nao mbaka vikukunguzuke, abaho kasegela. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wanhu awo wamsola mbwanga ayo wamgala ukayake kuno mgima na wakala moyo hole. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tweye tukwela meli tulongola kuchola Aso, ako tuchola kumsola Paulo. Avo yatulongele Paulo, kwavija kalonda kuvika ako kubitila isi inyalile. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Avo katuvika ako Aso, tumsola mwiimeli, tuchola nayo Mitulene. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kulawa ako tukala muumwanza wa kuchola Kio na imitondo yake tuvika. Siku ya kabili tuvika Samo na imitondo yake tuvika Mileto. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo kagesa kugendelelela na mwanza wake kwa meli bila kubitila Efeso ili sekeyakawe ako Asiya. Kakala yolopola kuvika Yelusalemu kuna inyimwili nyimwili ya Pentekosite, kamba yahadahike. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kulawa Mileto Paulo katuma usenga kwa wavele wa kibumbila cha wanhu wamtogole Yesu ako Efeso waiting'hane nayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Viwavikile kawalongela, “Mujuwa vija ving'halile na mweye kipindi chose, kusongela siku dija dinivikile mwiisi ya Asiya. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mujuwa vinimsang'hanile Mndewa kwa uhole na mahozi na magayo ganipatile mbuli ya viseto vihile va Wayahudi wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mujuwa silekile kuwapetela kunzekunze mzikae zenu na kuwafundiza chochose chonda kiwataze. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Niwazuma ng'hani Wayahudi na wanhu haweli Wayahudi wazileke nzambi zao na wambwelele Mulungu na kumtogola Mndewa wetu Yesu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Avo, sambi kwa kumtegeleza Loho Yang'alile nochola Yelusalemu bila kujuwa gonda gamhate ako. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kinhu kimoja kinjuwile, Loho Yang'alile kanizuma kila buga, kifungo na magayo vonibeta. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini siutonga ugima wangu kamba kinhu, nogesa kuumambukiza utumigwa na sang'hano iyanigwelele Mndewa Yesu kuisang'hana, nayo iyo kuwapetela wanhu Mbuli Inogile ya ng'hekewa ya Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nibita kumwenu mose kuwapetela Undewa wa Mulungu. Sambi nojuwa kuduhu imoja wenu yonda yambone niye kabili. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lelo nowalongela, munhu yoyose kumwenu yahapotela, niye namduhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwavija silekile bule kuwapetela gose goyolonda Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Avo muiteganye wenyego, diloleni goya bumbila jose diyawagwelele Loho Yang'alile mdikalize. Waloleni goya wanhu wa Mulungu, yawapatile Mulungu kubitila damu ya Mwanage. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nojuwa goya nahasegela mbwizi wakali wokwiza kumwenu, na wodibananga bumbila dino. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kipindi chovika baho wanhu wayagwe kulawa mdibumbila jenu wenyego, wowavizila wawagize wanahina kwa kuwatenda wawakweleleze hewo. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Avo mkale meso mwahakumbuka kamba kwa miyaka midatu imisi na ikilo niwafundiza kwa mahozi mengi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Avo sambi noweka muukalizi wa Mulungu na usenga wake wa ng'hekewa, udaha kuwagangamiza na kuwagwaa nhunza ziyalinazo Mulungu kwa wanhu zake wose. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Silondile sente hebu zahabu hebu viwalo va munhu yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mweye wenyego mojuwa kamba nisang'hana kwa makono gangu mwenyego, muladi mhate vinhu vinilonda niye na wayangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Niwalagusila kamba kwa kusang'hana ng'hani tolondeka kuwataza wanyolile, kumbukeni mbuli ziyalongile Mndewa Yesu mwenyego, ‘Vinoga ng'hani kulava kubanza kubokela.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo viyamambukize kulonga avo, kafugama hamoja nao, kampula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wanhu wose wakala wolila na kumulaga kwa kumuhagatila na kumnonela kwa unogelwa mkulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Wakala wanyunyuwale kwavija kalonga honda wamone kabili. Avo wachola nayo mbaka kuna imeli. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Vitumambukize kuwalaga, tukwela meli tuchola dimwe kwa dimwe mbaka Kosi, imitondo yake tuvika Lode, kulawa ako tuchola Patala. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ako tuivika meli ikalile yochola Foinike, avo tukwela, tuchola mwanza wetu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Vituvikile hanhu hakuyona Kupulo, tubitila mwambu wa kusini tuchola Siliya. Vituvikile buga da Tilo twima kwavija meli ilonda kuhumulusa mizigo. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ako tuwavika wanahina wa Yesu na tukala hamoja nao siku saba. Kwa kulongozigwa na Loho Yang'alile, wanhu awo wamulongela Paulo sekeyachole Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Lakini kipindi chetu cha kukala nao vikimalile, tusegela tugendelela na mwanza wetu. Wanhu wose hamoja na watwanzi na wana walawa kudibuga wachola hamoja na tweye mbaka mhwani, baho wose tufugama tumpula Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Abaho tuilaga, tweye tukwela meli na wao wabwela ukayao. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tugendelela na mwanza wetu tulawa Tilo tuchola Tolemaisi, ako tuwalamusa wakilisito tukala nao siku dimoja. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Imitondo yake tusegela tuchola Kaisalia. Ako tukala mng'anda ya Filipo, mpetaji wa Mbuli Inogile, imoja mna iwanhu saba wasaguligwe kamba watazaji wa kibumbila cha wanhu wamtogole Yesu ako Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kakala na wandele wane wakalile wolagula usenga wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Vitukalile aho siku nyingi mtula ndagu wa Mulungu yakemigwe Agabo keza kulawa Yudea. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Keza kumwetu, kasola mkwiji wa Paulo kaifunga magulu gake na makono gake kalonga, “Vino vivo viyolonga Loho Yang'alile, mwene mkwiji uno, Wayahudi womgodeka kamba vino ako Yelusalemu, womgela mmakono ga wanhu haweli Wayahudi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vituhulike avo, tweye na wanhu wayagwe wakalile aho tumpula Paulo sekeyachole Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Avo Paulo kedika, “Mweye molonda kutenda choni, kulila kamba vino na kunibweza kukisogo? Niye niitanda siyo kufungigwa kwiiyeka ako Yelusalemu, lakini hata kufa mbuli ya Mndewa Yesu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Viyalemile kututegeleza, tumuleka tulonga, “Goyolonda Mndewa galawilile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Vitumambukize kukala aho kipindi kidodo, tufunga mizigo yetu tuchola Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wanahina wayagwe walawile Kaisalia vivija wachola hamoja na tweye na watugala mng'anda ya munhu itukalile tochola kumwake, Mnasoni yakalile mwenekae wa Kupulo na kakala mkilisito kulawa haichanduso. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Vituvikile Yelusalemu, wanhu wamtogole Yesu kuko watubokela kwa deng'ho. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Imitondo yake Paulo kachola hamoja na tweye kumulola Yakobo, na wavele wose wa kibumbila cha wanhu wamtogole Yesu wakala baho. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo kawalamusa na kuwasimulila goya gaja gayatendile Mulungu kwa wanhu haweli Wayahudi kubitila sang'hano yake. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Viwahulike avo, wose wamtogola Mulungu. Abaho wamulongela Paulo, “Ndugu yetu Paulo, koona vija magana kwa magana ga Wayahudi viwamtogole Yesu, na vija viwogagoga malagizo. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Walongeligwa kukala kowafundiza Wayahudi wakalile mziisi za wanhu haweli Wayahudi sekewagagese Malagizo ga Musa, na kuwalongela sekewawengize kumbi wanao hebu kukweleleza vihendo va Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lelo yokuwaze? Kwavija wahulika kamba kwa baha, ");
INSERT INTO kdc2014_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","vino vivo vitulonda gweye utende. Hano hana wanhu wane waiduile kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ilumbe nao mna kihendo cha kuisunha ukalipe sente zilondeka, abaho wasenyigwe mvili zao. Avo wanhu wose wojuwa kamba mbuli ziwalongeligwe mbuli ya gweye za uvizi, avo gweye mwenyego ugendelele kugagoga Malagizo ga Musa. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lakini mbuli ya wanhu haweli Wayahudi weli wakilisito, tuwagalila baluwa kuwalongela vija vituitogolele kamba sekewaje kinhu chochose kilavigwe nhosa kwa vinyago, hebu kung'wa damu hebu kuja nyama ya mnyama yabobotoligwe, na sekewatende ugoni.” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Avo Paulo kawasola na imitondo yake katenda kihendo cha kuisunha hamoja nao. Abaho kengila Mng'anda ya Mulungu na kuwalongela kipindi cha kihendo cha kuisunha na mbuli ya nhosa yonda ilavigwe kwa kila imoja wao. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lakini siku izo saba vizikalile behi kumala, Wayahudi wayagwe walawile mwiisi ya Asiya wamona Paulo ka Mng'anda ya Mulungu. Waluding'hula lunhu lose lwa wanhu, wamgoga Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Waguta ng'hondo, “Wanhu wa Izilaeli, mtutaze ino iyo munhu yochola kila hanhu na kofundiza vinhu viyagwe kwa wanhu wa Izilaeli na Malagizo ga Musa na Ng'anda ino ya Mulungu. Na sambi kawagala wanhu haweli Wayahudi kuhagela dikwe hanhu hano hong'ala!” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Walonga vino kwavija wamona Tulofimo mwenekae wa Efeso hamoja na Paulo kudibuga, avo wagesa Paulo kamgala Mng'anda ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Isi yose ikala mdizumozumo, wanhu walawa kila hanhu na kumgoga Paulo, wambulula wamulava Mng'anda ya Mulungu. Bahaja nyivi za Ng'anda ya Mulungu zihindigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Lunhu lwa wanhu lulonda kumkoma Paulo, baho usenga ugaligwa kwa mkulu wa wakalizi wa Kilumi kamba wanhu wose wa Yelusalemu wading'huka. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Bahaja mkulu wa wakalizi kawasola wakulu na wakalizi na kukimbilila kuna ulunhu. Wanhu viwamone mkulu ayo hamoja na wakalizi, waleka kumtowa Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkulu wa wakalizi kachola mbaka kwa Paulo, kamgoga na kulagiza yagodekigwe minyololo mibili. Abaho kauza, “Munhu gani ino, na katenda choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wanhu wayagwe wabwahanhuka vino, na wayagwe wabwahanhuka vino. Kukala na mwazanyo mbaka mkulu wa wakalizi hadahile kujuwa kija kilawilile, avo kawalagiza wanhu zake wamsole Paulo mbaka kuing'hambi. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo viyavikile mna ikidaluko, wakalizi wampapa mbuli ya ndwagi za wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wanhu wose wamwizila kuno wokemelela, “Mkome!” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wakalizi viwakalile womgala mwiing'hambi, Paulo kamulongela mkulu wa wakalizi, “Chonde, nodaha kukulongela mbuli?” Mkulu ayo wa wakalizi kamuuza, “Kumbe kodaha kulonga Kigiliki! ");
INSERT INTO kdc2014_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kumbe gweye huli mwenekae wa Misili, ija juzi juzi yawading'hule wanhu na kuwalongoza wanhu wehile gana malongo mane mbaka kuluwala!” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo kamwidika, “Niye na Muyahudi, nileleke Taliso mwiisi ya Kilikia, mwenekae wa buga dijuwike ng'hani. Chonde ndeke nonge na wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mkulu wa wakalizi kamtogolela, avo Paulo kema mkidaluko kawenulila makono wanhu wanyamale. Wanhu viwanyamale kalonga nao kwa Kiebulania. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndugu zangu Wayahudi, nhegelezeni sambi viniigombela kumwenu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Viwamuhulike kolonga Kiebulania, wanyamala tuluu na Paulo kagendelela kulonga, ");
INSERT INTO kdc2014_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Niye na Muyahudi, nivumbukila Taliso mwiisi ya Kilikia. Lakini ng'hulila bahano Yelusalemu kamba mwanahina wa Gamalieli. Nibokela mafundizo kwa kugangamala mna gamalagizo ga wahenga zetu na niilava mwenyego kwa moyo wose kwa Mulungu kamba mose muli hano.” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Niwadunhunza mbaka kuwakoma wanhu waikweleleze nzila ino. Niwagoga wambigalo na watwanzi na kuwagodeka mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mulava nhosa mkulu na wanhu wose wamkitala wodaha kulonga kamba nolonga ukweli. Nibokela baluwa kulawa kwa ndugu Wayahudi ako Damesiki, avo nyhola kuwagoga wanhu awo na kuwagala Yelusalemu kuno wagodekigwa minyololo muladi watagusigwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Vinikalile nogenda na kuvika behi ya Damesiki, yopata saa sita imisi, bahaja mulenge kulawa kuulanga unimwemwesela mhande zose. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nigwa hasi mhulika sauti yonongela, ‘Sauli, Sauli! Habali kondununza?’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Niuza, ‘Mndewa, gweye kwa nani?’ Kanongela, ‘Niye na Yesu wa Nazaleti. Niye iyo yuunidununza.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wanhu wakalile hamoja na niye wawona umulenge, lakini hawaihulike sauti ya ayo yalongile na niye. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nimuuza, ‘Mndewa nhende choni?’ Mndewa kanongela, ‘Lamuka uchole Damesiki, ako kolongeligwa kila kinhu kinilonda utende.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ng'hala silola mbuli ya uja umulenge mkali, avo waja wayangu wanigoga mkono na kunilongoza Damesiki. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mna dibuga dijo kukala munhu yakemigwe Anania, munhu yomdumba Mulungu, yagagogile Malagizo ga Musa na kakala kotogoligwa ng'hani na Wayahudi wose wakalile kuko. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Keza kumwangu, kema behi yangu, kalonga, ‘Ndugu Sauli lola kabili!’ Bahaja ndola kabili na kumulola. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anania kalonga, ‘Mulungu wa wahenga zetu kakusagula ujuwe goyolonda, na kumona Msang'hanaji wake Yanogile na kumuhulika kolonga kwa mulomo wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwavija kuvona na komulongela kila munhu kiwone na kuhulika. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na sambi kobeta choni? Inuka na ubatizigwe na nzambi zako zigeligwe kumgongo kwa kumpula heyo.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nibwela Yelusalemu na vinikalile nompula Mulungu Mng'anda ya Mulungu, Mulungu kandagusila kinhu, ");
INSERT INTO kdc2014_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nimona Mndewa, kanongela, ‘Lopola usegele Yelusalemu, kwavija wanhu weli hano hondawatogole gondaulonge mbuli ya niye.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nimwidika, ‘Mndewa, wao wojuwa goya kamba ningila mzing'anda za kumpula Mulungu, niwagoga na kuwatowa wanhu wakutogole gweye. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na munhu wako Sitefano viyakomigwe, niye ng'hala baho nolola viyokomigwa na kukaliza viwalo va wanhu wakalile womkoma.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mndewa kanongela, ‘Genda, kwavija nokugala kutali kwa wanhu haweli Wayahudi.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wanhu wamtegeleza Paulo mbaka viyalongile vino, lakini wasonga kuguta nyangi, “Msegezeni! Mkomeni! Holondigwa yawe mgima!” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wagendelela kuguta nyangi kuno wopunga viwalo vao, wagevuzika na kupigisa timbwisi uchanha. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkulu wa wakalizi kawalagiza wanhu zake wamgale Paulo kuing'hambi, kawalongela wamtowe mbalati muladi wajuwe habali Wayahudi woguta nyangi kamba avo mbuli yake. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lakini viwamgodeke na kulonda kumtowa mbalati, Paulo kamulongela mkulu yemile aho, “Vino malagizo gotogola kumtowa mwenekae wa Lumi ing'hali hainajuwika mbuli gani ihile iyaitendile?” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mkulu ayo viyahulike vivo kachola kwa mkulu wa wakalizi kamuuza, “Kolonda kutenda choni? Munhu ayo mwenekae wa Lumi!” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Avo mkulu wa wakalizi kamcholela Paulo kamuuza, “Nongele, gweye kwa mwenekae wa Lumi?” Paulo kamwidika, “Ona.” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mkulu wa wakalizi kamulongela, “Niye niwa mwenekae wa Lumi kwa kulipa sente nyingi.” Lakini Paulo kamwidika, “Niye na mwenekae wa Lumi kwa kuleligwa,” ");
INSERT INTO kdc2014_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bahaja wanhu walondile kumsola Paulo walawanya. Na ayo mkulu wa wakalizi kadumba ng'hani viyajuwile Paulo kakala mwenekae wa Lumi na kuno kamgodeka nzabi. ");
INSERT INTO kdc2014_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mkulu wa wakalizi kalonda kujuwa habali Wayahudi wamtagusa Paulo. Avo imitondo yake kamfungula Paulo iminyololo na kuwalagiza wakulu wa walava nhosa na wanhu wose wa mkitala waiting'hane. Abaho kamsola Paulo na kumwika haulongozi wao. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo kawalola bunhuu wanhu wa mkitala, kalonga, “Waizilaeli wayangu! Mbaka lelo nosang'hana goyolonda Mulungu kwa moyo uleka kunitagusa kamba nibananga.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Baho Anania Mulava nhosa mkulu kawalagiza waja wakalile behi na Paulo wamtowe kofi mumulomo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo kamulongela, “Mulungu kokutowa kofi gweye mwenyego uigalile na kando dibakigwe uzelu! Kwima baho muladi unitaguse kwa Malagizo, kuno gweye mwenyego kobena Malagizo kwa kulagiza nhoweke!” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wanhu wemile behi na Paulo wamulongela, “Gweye komuliga mulava nhosa mkulu wa Mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo kedika, “Waizilaeli wayangu, sijuwile bule kamba kakala mulava nhosa mkulu. Kwavija Maandiko Gang'alile golonga, ‘Sekeumulonge vihile mulangulizi wa wanhu zako.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo viyone bumbila diyagwe wakala Masadukayo na wayagwe wakala Mafalisayo, kakemelela mkitala, “Waizilaeli wayangu! Niye na Mfalisayo, mwanage Mfalisayo. Niye ngaligwa hano mkitala kwavija notogola kamba wanhu wafile wozilibuka!” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bahaja viyalongile avo, Mafalisayo na Masadukayo wasonga kuihasanya, na bumbila diigola. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kwavija Masadukayo wolonga kuduhu kuzilibuka kwa wafile na kuduhu wasenga wa kuulanga hebu loho, lakini Mafalisayo wogatogola gose madatu. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wakemelela ng'hani, wafundiza Malagizo ga Musa wayagwe wa kibumbila cha Mafalisayo wenuka walonga kwa nguvu, “Hatuona kiyabanange munhu ino! Yodahika loho hebu msenga wa kuulanga kalonga nayo kweli!” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bwato dikala kulu mbaka mkulu wa wakalizi kengila bwembwe kamba Paulo yahakanhigwe vihande vihande. Avo kawalagiza wakalizi zake wahumuluke kuna dibumbila, wamsegeze Paulo wamgale kuna ing'hambi. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilo acho Mndewa kema behi ya Paulo, kamulongela, “Sekeudumbe! Kamba viuwalongele mbuli zangu hano Yelusalemu, vivija kolondeka utende vivo kudibuga da Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Imitondo yake wayahudi wayagwe waiting'hana hamoja na kutenda ubala. Waiduila honda waje hebu kung'wa mazi mbaka vonda wamkome Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wanhu waitogolele kutenda avo wakala wanhu kubanza malongo mane. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Abaho wachola kwa wakulu wa walava nhosa na wavele, walonga, “Tuiduila hamoja kamba hatuja kinhu mbaka vonda tumkome Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Avo, gweye na wanhu wa mkitala galeni usenga kwa mkulu wa wakalizi yamgale Paulo kumwetu, kuno moitenda molonda kujuwa goya mbuli zake. Na tweye toitanda kumkoma yang'hali hanavika hano.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini mwana wa lumbu jake Paulo kahulika kiseto chao, avo kachola kuna ing'hambi kamulongela Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Abaho Paulo kamkema mkulu imoja wa wakalizi, kamulongela, “Mgale mbwanga ino kwa mkulu wa wakalizi, kana mbuli ya kumulongela.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mkulu ayo kamsola, kamulongoza mbaka kwa mkulu wa wakalizi, kamulongela, “Ayo Paulo yagodekigwe, kang'hema na kunipula nimgale mbwanga ino kumwako, kwavija kana mbuli kolonda kukulongela.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mkulu wa wakalizi kamgoga mkono, kamgala hamgwazo waiyeka, kamuuza, “Kolonda kunongela choni?” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kamulongela, “Wakulu wa Wayahudi wailumba mayo wakupule wamsole Paulo kuna ikitala, kuno woitenda wanhu wa mkitala wolonda kujuwa goya mbuli zake. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lakini sekeuwatogolele, kwavija kuna wanhu kubanza malongo mane awo waifisa wombeta. Waiduila hawaja kinhu hebu kung'wa mbaka vonda wamkome. Wao sambi waitanda kutenda avo na wobetela vonda ulonge.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkulu wa wakalizi kalonga, “Sekeumulongele munhu yoyose kamba kunongela mbuli ino.” Abaho kamuleka imbwanga yachole. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Abaho mkulu wa wakalizi kawakema wakulu zake wabili, kawalongela, “Watandeni wakalizi magana mabili wachole Kaisalia, hamoja na wakwela falasi malongo saba na wakalizi magana mabili wa migoha, na muitande kusegela saa ndatu lelo ikilo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mtandeni falasi wa Paulo, na mumvikize mgima kwa Felikisi mtawala wa Kilumi wa isi ya Yudea.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Abaho mkulu wa wakalizi kandika baluwa ilonga vino, ");
INSERT INTO kdc2014_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Go mkulu, zihoze, “Niye Kilaudio Lusia, nokwandikila gweye, mkulu Felikisi. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Wayahudi wamgoga munhu ino na walonda kumkoma, lakini vimbonile kakala mwenekae wa Lumi, avo nhyola na wakalizi zangu kumuhonya. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nilonda kujuwa kilamuso cha kumtagusila, avo nimgala mkitala chao. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lakini nyona kuduhu mbuli yoyose iyatendile kumtenda yafe hebu kugodekigwa mkifungo. Nhaguso yao kumwake ikala mbuli ya Malagizo gao wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na vinongeligwe kuna kiseto cha kumkoma, ndopola kumgala kumwako. Niwalongela wanhu wamtaguse wagale vitala vao kumwako.” ");
INSERT INTO kdc2014_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Avo wakalizi wao wamsola Paulo kamba viwalagizigwe. Wamgala ikilo acho mbaka Antipatili. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Imitondo yake wakalizi wa magulu wabwela kuna ing'hambi, wawaleka waja wakalizi wa falasi wagendelele na mwanza hamoja na Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Viwavikile Kaisalia wamgwaa ija ibaluwa mkulu wa isi ayo na kumwika Paulo mmakono gake. ");
INSERT INTO kdc2014_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mkulu ayo viyaisomile ibaluwa kamuuza Paulo kalawa isi gani. Viyajuwile kalawa isi ya Kilikia, ");
INSERT INTO kdc2014_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kamulongela, “Nokutegeleza kipindi wanhu wakutaguse wahavika.” Abaho kalagiza Paulo yekigwe muukalizi, mng'anda ya Helode imkulu wa isi. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Vizibitile siku tano, Anania mulava nhosa mkulu hamoja na wavele na munhu yagajuwile malagizo yakemigwe Telutulo, wachola kwa Felikisi wamulongela vitala vao mbuli ya Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Abaho Paulo kakemigwa, na Telutulo kasonga kulava kitala chake vino, “Go mkulu Felikisi! Ulangulizi wako unogile ugala tindiwalo kwa kipindi kitali, na mgaluko mkulu wotendigwa mbuli ya isi yetu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tweye tubokela mbuli ino kwa deng'ho na siku zose tolonga utogoligwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Silonda ng'hani kwagiza kipindi chako, lakini nokupula uwe muhole na utegeleze goya gonilonga. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tona kamba munhu ino mng'hobo ng'hani, kogala ndwagi kwa Wayahudi mwiisi yose na iyo mkulu wa kibumbila cha Wanazaleti. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Vivija kalonda kuigela dikwe Ng'anda ya Mulungu, na tweye tumgoga. Tulonda kumtagusa kwa malagizo getu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lakini Lusia, mkulu wa wakalizi keza, kamsola kwa nguvu mmakono getu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na gweye wahamuuza munhu ino, kodaha kujuwa kulawa kumwake mbuli zose zitumtagusila. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wayahudi nao watogola kiyalongile Telutulo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mkulu ayo kamwinulila Paulo mkono muladi yalonge, na Paulo kalonga, “Nodeng'helela kuigombela haulongozi wako kwavija nojuwa miyaka heleketwa gweye kwa msemi wa isi ino. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gweye mwenyego kujuwa kamba zibita siku longo na mbili ziiyeka toka nyhole Yelusalemu kumtambikila Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wayahudi hawambonile ngombe na munhu Mng'anda ya Mulungu hebu wambone nowading'hula wanhu, siyo mng'anda ya kumpula Mulungu hebu hanhu hohose kudibuga. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nao hawadaha kukulagusila kitala kiwanigalile hano. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lakini niye notogola nomgwaa ukulu Mulungu wa wahenga zetu na kuikweleleza nzila ayo iwoikema ya uvizi. Lakini vivija noitogola kila mbuli yandikigwe mna Gamalagizo ga Musa na vitabu va watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Niye nomtamanila Mulungu kamba vija viwomtamanila hewo, kamba wanhu wose wanogile na wehile wozilibuka kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Avo siku zose niiyoha ng'hani sambi niwe na moyo unitagusa kamba nibananga mgameso ga Mulungu na mgameso ga wanhu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Viibitile miyaka mingi mbwela Yelusalemu muladi kuwagwaa sente wayangu na kumulavila Mulungu nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ving'halile notenda avo wanyona Mng'anda ya Mulungu, ving'homeleze kihendo cha kuisunha. Kukala kuduhu lunhu hebu ndwagi yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakini Wayahudi wayagwe walawile mwiisi ya Asiya wakala baho, awo wao walondeke kwiza hano haulongozi wako na kulava kitala chao kamba wana mbuli yoyose kumwangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hebu leka wanhu wano weli hano walonge, mbuli gani ihile iwaiyonile kumwangu vinimile mkitala, ");
INSERT INTO kdc2014_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","lakini mbuli zino ziiyeka zinongile vinimile haulongozi wao kamba, ‘Lelo niye ngogigwa mbuli ya kutogola kamba wanhu wafile wozilibuka.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Abaho Felikisi yakalile yaijuwile goya mbuli ya kibumbila cha wanhu wamtogole Yesu, kawalongela wanhu wanyamale, kalonga, “Vondayeze Lusia, mkulu wa wakalizi, nolava nhaguso ya mbuli ayo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kamulagiza mkulu wa wakalizi yamkalize Paulo, lakini sekeyamkalize ng'hani na yawatogolele mbwiga zake wamgwee kiyolonda. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Vizibitile siku ndodo Felikisi keza hamoja na mwehe wake Dulusila, yakalile Muyahudi. Kalagiza Paulo yagaligwe, kamtegeleza viyalongile mbuli ya kumtogola Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lakini Paulo viyakalile kolonga mbuli ya kutenda ganogile na kuigomesa mwenyego na mbuli ya Siku ya Mulungu kuwatagusa wanhu, Felikisi kadumba ng'hani kalonga, “Sambi kodaha kuchola, nokukema kabili nahapata nyafasi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mna ikipindi acho kakala yotamanila Paulo yahamgwelele sente, lekaavo kakala yogendelela kumkema na kulonga nayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Viibitile miyaka mibili, Polikio Fesito kamuhala Felikisi nyafasi ya ukulu wa isi. Felikisi kalonda nhogolwa kwa Wayahudi avo kamuleka Paulo mkifungo. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Siku ndatu kumwande Fesito viyavikile mwiisi ayo, kasegela Kaisalia kachola Yelusalemu, ");
INSERT INTO kdc2014_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","wakulu wa walava nhosa na wakulu wa Wayahudi viwagalile kitala chao mbuli ya Paulo. Wampula Fesito, ");
INSERT INTO kdc2014_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","yawatendele vinogile yamgale Paulo Yelusalemu, kwavija wakala kiseto mnzila wamkome. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesito kawedika, “Paulo kamkifungo ako Kaisalia, naniye nobwela kuko sambi baha. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Walekeni wakulu zenu wachole na niye Kaisalia wakamtaguse kamba katenda gehile.” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito kakala hamoja nao siku nane hebu longo abaho kachola Kaisalia. Imitondo yake kakala mkigoda cha nhaguso mkitala, kalagiza Paulo yagaligwe mgati. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo viyavikile, Wayahudi walawile Yelusalemu wamzunguluka na kusonga kulava vitala vikulu vikulu viwalemele kulava usindila. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Lakini Paulo kaigombela, “Niye sitendile chochose kihile kwa Malagizo ga Wayahudi hebu kwa Ng'anda ya Mulungu hebu kwa Mndewa mkulu wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lakini Fesito kalonda nhogolwa kwa Wayahudi, avo kamuuza Paulo, “Kotogola kuchola Yelusalemu ukatagusigwe ako mgameso gangu mbuli ya gano?” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo kalonga, “Niye nokwima hano mkitala cha Mndewa mkulu wa Lumi, hano baho nilondeka kutagusigwa. Kamba viujuwile siwatendile Wayahudi chochose kihile. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nahatenda dihile dinilondeka nhaguso ya kufa silema bule. Lakini kamba kuduhu ukweli mvitala viwagalile mbuli yangu, kuduhu munhu yodaha kunigala kumwao nochola kumwande kwa Mndewa mkulu wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Baho Fesito viyamambukize kulonga na wanhu zake wamkitala, kamulongela Paulo, “Kuchola kumwande kwa Mndewa mkulu wa Lumi, avo kochola kwa Mndewa mkulu wa Lumi!” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vizibitile siku nyingi mndewa Agilipa na Benike wavika Kaisalia muladi kumulamusa Fesito. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Viwakalile ako siku nyingi, Fesito kamsimulila mndewa mbuli za Paulo, kalonga, “Hano hana munhu yalekigwe mkifungo na Felikisi. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Viny'holile Yelusalemu, wakulu wa walava nhosa na wavele wa Wayahudi wagala kitala kumwangu na kumhula nimtaguse. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lakini niye niwedika siyo vivo viwatendaga Walumi kumulava munhu yatagusigwe yang'hali hana iting'hana na wanhu walavile kitala kihanga kwa kihanga na kugoleligwa nyafasi yaigombele mwenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Viwezile hano, sikawile bule, lakini imitondo yake ng'hema mting'hano mkitala na kulagiza munhu ayo yagaligwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wanhu wamtaguse viwemile hawalavile kitala chochose kihile kamba vinigesile nene. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Lakini wakala woibamilila mbuli ya dini yao wenyego na mbuli ya munhu yokemigwa Yesu, yakalile yafile, lakini Paulo kagendelela kulonga kakala mgima. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sijuwile dakutenda vija nahapatile mbuli zino. Avo nimpula Paulo kamba yahadahile kuchola Yelusalemu na kutagusigwa kuko. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Paulo kachola kumwande, kalonda Mndewa mkulu wa Lumi yalamule mbuli yake na yekigwe muukalizi. Avo nilagiza yekigwe muukalizi mbaka vondanimgale kwa Mndewa mkulu wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa kamulongela Fesito, “Maza nahanogelwe ng'hani kamba nahamuhulika munhu ayo niye mwenyego.” Fesito kamwidika, “Komuhulika mayo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Imitondo yake Agilipa na Benike wengila kwa deng'ho kudigati da kuiting'hana, wakulu wa wakalizi na wakulu wa ziisi. Fesito kalagiza Paulo yagaligwe mgati. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesito kalonga, “Mndewa Agilipa na wanhu wose muli hano hamoja na tweye, mumona munhu ino Wayahudi wose ako Yelusalemu na hano wagala vitala kumwangu. Walonga munhu ino yakomigwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lakini niye siyonile mbuli yoyose ihile iyatendile mbaka yakomigwe. Kwavija heyo mwenyego kalonda kuchola kumwande kwa Mndewa mkulu wa Lumi, nigesa nimgale kuko. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lakini niye nabule mbuli ya kumwandikila Mndewa mkulu wa Lumi mbuli ya munhu ino. Avo nimgala haulongozi wenu ng'haning'hani haulongozi wako, gweye Mndewa Agilipa muladi wahamala kumulolesa, mhate dakwandika mbuli yake. ");
INSERT INTO kdc2014_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwavija vinigesa yokuwa yosekeza nahamgala mfungwa bila kwandika kilamuso kiyatagusiligwe.” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa kamulongela Paulo, “Kodaha kuigombela.” Baho Paulo kenula makono gake kalonga vino, ");
INSERT INTO kdc2014_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mndewa Agilipa! Niye noiyona nimweda, lelo kuigombela haulongozi wako mbuli zose ziwonitagusila Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kwavija gweye kuvijuwa goya vihendo va Wayahudi na kuihasanya kwao. Nokupula ufunge umoyo unhegeleze.” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi wose wajuwa ving'halile toka haudodo wangu. Wajuwa ving'halile mwiisi yangu na ako Yelusalemu. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Toka mwaka wanijuwa goya, na wao wahalonda wodaha kukulongela kamba ng'hala mkibumbila cha Mafalisayo womgwaa ukulu Mulungu kubanza wose. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lelo nokwima hano nitagusigwe mbuli ya kutamanila lagano diwagweleligwe wahenga zetu na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dino ijo lagano ditamaniligwa koneka na makabila longo na mabili, kamba viwomsang'hanila goya Mulungu imisi na ikilo. Mbuli ya gago, go mkulu notagusigwa na Wayahudi! ");
INSERT INTO kdc2014_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mweye mose muli hano, habali mokona vidala kutogola kamba Mulungu kowazilibula wanhu wafile?” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Niye mwenyego nhenda kila mbuli kuwagoma wanhu waditogole twaga da Yesu wa Nazaleti. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Lekaavo nhendile vivo ako Yelusalemu. Nigweleligwa udahi na wakulu wa walava nhosa na kuwagodeka mkifungo wanhu wengi wamtogole Mulungu, na viwatagusigwe kufa na niye niilumba nao. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Miyanza mingi nyhola mzing'anda za kumpula Mulungu na niwananahiza wabele kutamanila kwao. Ng'hala niwehile ng'hani mbaka nyhola mmabuga ga kutali kuwadununza.” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kwa mbuli ayo ving'halile nochola Damesiki kwa udahi wa wakulu wa walava nhosa. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Go mkulu, kipindi ving'halile mnzila, zuwa vidikalile mdindosi, nyona mulenge mkulu kubanza zuwa, womwemwesa kulawa kuulanga, unizunguluka niye na waja wayangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tweye wose tulagala hasi na mhulika sauti yonongela kwa Kiebulania, ‘Sauli, Sauli! Habali konidununza? Koilumiza mwenyego kamba ng'ombe yotowa mbalati ya mndewa wake.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Niye nimuuza, ‘Mndewa, gweye kwa nani?’ Nayo Mndewa kanidika, ‘Niye na Yesu, yuunidununza. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lakini winuke wime kwa magulu gako. Nikulawilila muladi nikusagule uwe msang'hanaji wangu. Kowalagusila wanhu wayagwe lelo kunyona na gaja gonda nikulagusile. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nokuhonya na wanhu wa Izilaeli na vivija nokuhonya na wanhu haweli Wayahudi ako konda nikugale. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Uwafumbule meso gao walawe mdiziza weze kudilenge na walawe mmakono ga Mwenembago wambwelele Mulungu, avo kubitila kutamanila kwao kumwangu nzambi zao zogeligwa kumgongo na wopata uhazi wao mna iwanhu wasaguligwe na Mulungu.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Avo Mndewa Agilipa sikilemile bule kinhu acho cha kuulanga kiyandagusile Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Niwapetela wanhu kusongela Damesiki na Yelusalemu na abaho isi yose ya Yudea na kwa wanhu haweli Wayahudi. Waleke nzambi zao na wambwelele Mulungu na watende gaja golagusa waleka nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa mbuli ayo lekaavo Wayahudi wangoga ving'halile mng'anda ya kumpula Mulungu, na walonda kung'homa. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lakini Mulungu kanhaza mbaka lelo, na avo nima hano kuwalongela wanhu wose, wakulu kwa wadodo. Mbuli inonga iyo iija iwalongile watula ndagu wa Mulungu na Musa yolawilila. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mbuli ya Kilisito Mkombola kalondeka yadununzike na yawe wa ichanduso kuzilibuka kwa wafile, muladi yawapetele Wayahudi na wanhu haweli Wayahudi mulenge wa kukomboligwa.” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo viyakalile koigombela avo, Fesito kakemelela, “Gweye Paulo, kuna kibozi mbwelela! Kusoma kwako ng'hani kukwehula!” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulo kamwidika, “Go mkulu, sikwingililigwa bule, vinonga niye ukweli wiiyeka. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mndewa Agilipa! Kumwako nolonga bila kudumba kwavija mbuli zino zose kuzijuwa goya. Vinigesa mbuli zino kuzijuwa goya kwavija hazitendeke kinyelegezi. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mndewa Agilipa, vino kowatogola watula ndagu wa Mulungu? Nojuwa kowatogola!” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa kamulongela Paulo, “Viugesa kwa kipindi kino kidodo kodaha kunhenda niwe mkilisito?” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo kamwidika, “Kiwe kipindi kidodo hebu kitali nompula Mulungu gweye na mweye mose munhegeleza hano lelo muwe kamba vinili niye, lakini bila minyololo!” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Baho Mndewa Agilipa, na mkulu wa isi, Benike na waja wose wakalile hamoja nao, wenuka. ");
INSERT INTO kdc2014_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Viwakalile wosegela wailongela, “Munhu ino hatendile mbuli ya kumtenda yafe hebu yagodekigwe mkifungo.” ");
INSERT INTO kdc2014_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nayo Agilipa kamulongela Fesito, “Maza munhu ino halondile kuchola kumwande kwa Mndewa mkulu wa Lumi yahafunguligwe.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Viwaitogolele tuchole Italia, wawagela Paulo na wafungwa wayagwe mmakono ga Juliasi, mkulu wa kibumbila cha wakalizi wa Lumi, kikemigwe, “Kibumbila cha Mndewa wa Lumi.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukwela meli ilawile Adilamito, ikalile yochola mhwani ya isi ya Asiya na tusonga umwanza. Alisitaliko, mwenekae wa Makedonia kulawa Sesalonike kakala na tweye. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Imitondo yake tuvika Sidoni. Juliasi kamonela bazi Paulo na kamtogolela yachole kuwalola mbwiga zake, yagweleligwe kiyalondile. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulawa ako tugendelela na mwanza kwavija ubeho ukala wobuma kwiza kumwetu, avo tubitila kisiwa cha Kupulo kukalile kuduhu ubeho. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Abaho tuloka bahali ya Kilikia na Pamfulia, tuvika kudibuga da Mula mwiisi ya Lukia. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Baho mkulu ayo kayona meli ng'hulu yolawa Alekizandilia ikala yochola Italia, avo katukweza. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tugendelela na mwanza mholemhole, na kwa siku nyingi kwa kugaya ng'hani tuvika mwiisi ya Nido. Ubeho ututenda seketuchole kutali ng'hani na mwambu uja, avo tubitila mwambu wa Kilete behi na Salimone ako ubeho haukalile mkulu bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tubita mumgwazo mholemhole tuvika hanhu hokemigwa Bandali Inogile behi na buga da Lasea. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Aho tuhakala ng'hani, mbaka kipindi cha kufunga kuja kikala kibitile, kwavija kipindi acho kikala hakinogile bule kugenda kwa meli. Avo Paulo kawazuma, ");
INSERT INTO kdc2014_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Wayangu, vinikona mwanza uno wokuwa na magayo mengi na kwagiza vinhu vingi vikwezigwe mwiimeli, vivija kwagiza ugima wetu.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini mkulu wa wakalizi kanogelwa na kija kiyalongile mulosaji na mwene meli siyo gaja gayalongile Paulo. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwavija hanhu aho hakala hehile na kikala kipindi cha kihuhwe, wanhu wengi wanogelwa kugendelela na mwanza yahadahika wavike Foiniki. Foiniki ayo bandali ya Kilete ichola kusini kudihongela zuwa na kasikazini kudihongela zuwa, ako wahadahile kukala kipindi cha kihuhwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lubeho lunogile lwa kudihongela zuwa lusonga kubuma, na wao wagesa kamba wapata kiwalondile, avo wafungula nzabi, wasegeza meli yao wachola behi ya mhwani ya Kilete. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakini hakibitile kipindi kitali, ubeho mkulu ukemigwa “Ubeho wa kaskazini,” usonga kubuma kulawa mkisiwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ubeho uitowa ayo imeli, kwavija hatudahile kuugomesa tuileka isoligwe na beho. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kisiwa kimoja kidodo kikemigwe Kauda kitutaza kidogo na uja uubeho, na vitubitile kusini yake tuhonyeka, hamoja tugazika ng'hani, tudaha kukihonya kija ikigalawa didodo cha meli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wanhu wakikwega kigalawa mgati, abaho waizungulusila nzabi imeli na kuifunga kwa nguvu. Wadumba wahananahile mumgwazo wa bahali, mhwani ya Libiya, avo wahulumusa matanga na kuileka imeli isoligwe na beho. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Beho digendelela kubuma na imitondo yake wasonga kuyasa mizigo ili mwiimeli. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Siku da kadatu wasonga kwasa mgamazi vinhu viyagwe vili mwiimeli kwa makono gao wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa kipindi cha siku nyingi hatudahile kujona zuwa hebu nhondo, beho digendelela ng'hani mbaka twagiza tamanilo da kuhona. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Viwakalile kipindi kitali bila kuja, Paulo kema haulongozi wao kawalongela, “Wayangu maza munhegeleze niye na kuleka kuchola Kilete, sambi gatupate magayo gano gose na ubananzi uno. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lakini sambi nowapula, gangamaleni! Kuduhu imoja wenu yonda yafe, meli iiyeka iyo yonda ibanangike. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwavija kilo cha jana msenga wa kuulanga wa Mulungu kanizila. Mulungu inimsang'hanila na kumgwaa ukulu. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Msenga ayo wa kuulanga kanilongela, ‘Paulo sekeudumbe! Kolondeka wime haulongozi wa Mndewa mkulu wa Lumi. Kwa mbuli yako Mulungu kouhonya ugima wa wanhu wose weli muumwanza na gweye.’ ");
INSERT INTO kdc2014_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Avo wayangu fungeni moyo! Kwavija nomtamanila Mulungu, galawilila kamba viyanongele. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini tokwasigwa kuna ikisiwa kiyagwe.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kilo cha longo na nne, twasigwa na ubeho kuna ibahali ya Meditelania, kilo kikulu walosaji wasinhukila wa behi na isi inyalile. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Wahumulusa hasi luzabi lufungigwe kinhu kizito kuzahila utali wa mazi, wapata utali wa mita malongo mane. Abaho watenda vivo kabili wapata malongo madatu. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Wadumba kamba imeli sekeichole kuna gamabwe avo wahumulusa nanga nne kukisogo cha imeli, wapula uche hima hima. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Abaho walosaji walonda kutoloka, wahumulusa ikigalawa kidodo mgamazi na waitenda wochola kwika nanga kuulongozi wa imeli. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Paulo kamulongela mkulu wa wakalizi na wakalizi, “Kamba walosaji wano hawasigala mumuno mwiimeli, sambimutamanile kuhonyeka.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Avo wakalizi wazikanha nzabi ziigogile ngalawa ndodo na kuileka ichole. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Usiku haunakucha, Paulo kawapula wanhu wose waje, “Kwa siku zose longo na nne mukala munyawanyawa, hamudile kinhu chochose. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lelo nowapula chonde muje lujo muladi mupate nguvu ya kugendelela kuwa wagima. Kuduhu hata luvili lumoja londa lwage.” ");
INSERT INTO kdc2014_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paulo viyamambukize kulonga avo, kasola gate, kamgwaa nhogolwa Mulungu mgameso gao, kadibanzula kasonga kuja. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kila munhu kasamhuka, kasola gate kaja. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wanhu wose kwa wose tukalile mwiimeli tukala wanhu magana mabili na malongo saba na sita. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Viwegute wahunguza uzito wa meli, kwa kwasa uhule wa ngano mbahali. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Viuchile, walosaji hawaijuwile bule isi ayo, ila wona msanga wa mhwani, avo waitogolela kwima aho kamba yahadahika. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wakanha zinanga wazileka mbahali, kipindi kikija wazifungula zinzabi zifungigwe muusukani, abaho wadinula digolole dili kuulongozi muladi digoge beho, wachole mhwani. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini wavika hanhu haziiting'hanile bahali mbili, na imeli yangama. Mwambu wa ulongozi wangama mumsenga bila kutigisika. Mwambu wa kukisogo wa imeli usonga kubeneka vihande mbuli ya mazi geli na ng'humbi. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wakalizi walonda kuwakoma wafungwa wose kwa kudumba kamba wahakogelele mbaka mhwani na kutoloka. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mkulu wa wakalizi kalonda kumuhonya Paulo, avo kawagomesa sekewatende avo. Ila kawalagiza wose wadahile kogelela wazumhe kulawa mwiimeli na wogelele mbaka mhwani. ");
INSERT INTO kdc2014_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Wayagwe wakweleleza kwa kugoga vihande va mbao hebu vihande va imeli ibeneke. Vivo tuhonyeke tweye wose na kuvika wagima mhwani. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Vituvikile kuna imhwani kuno twawagima, tujuwa kamba kisiwa kija chokemigwa Malita. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wenekae wa aho watunogela ng'hani. Mvula isonga kutowa na kukala na beho, avo wabwinha moto na kutugoneka. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo kadondola ngodi kakala yozika muumoto, mbuli ya umoto awo mgendela hasi kalawa mzingodi kamuluma Paulo na kuizingiliza mumkono wake. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wenekae wa aho viwamone mgendela hasi mumkono wa Paulo wailongela, “Vitukona munhu ino kokuwa mkomaji, hamoja kahonyeka kufa mbahali, nhaguso ya milungu haimulekile yagendelele kuwa ugima.” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini Paulo kamwasila muumoto mgendela hasi ayo na hamulumize bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wanhu waja wakala womulola kamba yahavimbile hebu yalagale hasi na kufa. Lakini viwabetele kwa kipindi kitali na kona haduhu kinhu kimulawilile, wagaluka na kulonga, “Heyo kakala mulungu!” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Behi na hanhu aho hakala na migunda ya mkulu wa ikisiwa yakemigwe Pubulio. Avo katugoneka, kwa kipindi cha siku ndatu tukala ukayake. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tatake Pubulio kakala yawasile mulusazi kolumwa homa na kuhala. Paulo kachola kumulola, viyamambukize kumpula Mulungu, kamwikila makono gake, kamuhonya. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Viyamambukize kutenda avo, wanhu wayagwe wakalile watamu mkisiwa acho weza na wahonyigwa. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wanhu watugwaa nhunza nyingi na kipindi vitusongile mwanza kabili, weka mwiimeli kila kinhu kitulondile. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Viibitile miezi midatu tusonga kabili mwanza kwa meli ilawile Alekizandilia, ikemigwe, “Milungu Pacha.” Meli ayo ikala imile mkisiwa acho kwa kipindi chose cha kihuhwe. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tuvika kudibuga da Silakusa, na tukala baho kwa siku ndatu. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulawa aho tugendelela na mwanza na tuvika mwiisi ya Legio. Imitondo yake beho disonga kubuma kulawa kusini, vizibitile siku mbili tuvika kudibuga da Potioli. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ako tuwavika wayetu wamtogole Yesu, wao watupula tukale nao siku saba. Abaho tuvika Lumi. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Waetu wamtogole Yesu ako Lumi viwatuhulike tuvika, wayagwe weza kutubokela Kudigulilo da Apio na wayagwe hanhu hokemigwa Ng'anda Ndatu za wageni. Paulo viyawaonile kamgwaa nhogolwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Vituvikile kudibuga da Lumi, Paulo katogoleligwa kukala yaiyeka hamoja na mkalizi imoja wa kumkaliza. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Vizibitile siku ndatu, Paulo kawakema hamoja walangulizi wa Kiyahudi wa hanhu aho. Viwaiting'hane kawalongela, “Waizilaeli wayangu, hamoja sitendile mbuli yoyose ihile kwa wanhu zetu hebu kwa vihendo vetu vitubokele kwa wahenga zetu, ngodekigwa ako Yelusalemu na ngeligwa mmakono ga Walumi. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Viwaniuzile na kona sitendile mbuli yoyose ihile ya kung'homela, walonda kunifungulila. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Wayahudi viwailemile mbuli ino, niye nyhola kumwande kwa Mndewa mkulu wa Lumi, hamoja ng'hala nabule kitala chochose kwa wanhu zangu. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Lekaavo niwapula mwize nonge na mweye, niye nigodekigwa minyololo kamba vino, kwavija notogola Mkombola iwakalile wombeta wanhu wa Izilaeli keza.” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Wao wamulongela, “Tweye hatubokele baluwa yoyose kulawa Yudea mbuli yako wala kuduhu munhu yoyose yezile hano na kulonga mbuli zako hebu yalonge chochose kihile kumwako. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini yokuwa vinoga tukuhulike mwenyego ulonge magesa gako, kwavija tweye tojuwa kamba kila hanhu wanhu wokilema kibumbila kino.” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Avo wapanga kuiting'hana, na wanhu wengi wavika kuyakalile. Toka imitondo mbaka ichungulo Paulo kawasimulila na kuwafambulila mbuli za Undewa wa Mulungu kageza kuwatenda wamtogole Yesu kwa kusoma Malagizo ga Musa na maandiko ga watula ndagu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wanhu wayagwe wazitogola mbuli zake, ila wayagwe hawamtogole bule. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Viwalekile kuilumba wenyego, wasegela, Paulo viyamalile kulonga mbuli ino, “Loho Yang'alile kalonga goya kwa wahenga zenu kubitila mtula ndagu wa Mulungu Isaya! ");
INSERT INTO kdc2014_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kalonga, ‘Genda ukawalongele wanhu wano, kuhulika mohulika, lakini hondamujuwe bule, kulola molola, lakini hondamone, ");
INSERT INTO kdc2014_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwavija mizoyo ya wanhu wano midala, wasita magwiti gao, wafing'hiliza meso gao. Maza wadahile kulola kwa meso gao, na kuhulika kwa magwiti gao, na kujuwa kwa mizoyo yao, wahanibwelele niye, na niye nahawahonyile.’ ” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paulo kamambukiza kulonga, “Avo mujuwe kamba usenga wa Mulungu kuwakombola wanhu, ugaligwa kwa wanhu haweli Wayahudi na wao wohulika. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo viyamambukize kulonga avo, Wayahudi wachola mzikae zao kuno woibamilila.” ");
INSERT INTO kdc2014_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa kipindi cha miyaka mibili Paulo kakala mng'anda iyapangile, mumo kawagoneka wanhu wose wezile kumulamusa. ");
INSERT INTO kdc2014_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kawapetela wanhu mbuli za Undewa wa Mulungu na kuwafundiza mbuli za Mndewa Yesu Kilisito, kalonga kwa kugangamala na kubwihila.");
INSERT INTO kdc2014_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Niye Paulo, na mtumwa wa Yesu Kilisito na mtumigwa, nisaguligwe na ng'hemigwe na Mulungu niwapetele wanhu Mbuli yake Inogile. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Mbuli Inogile ilongigwe na Mulungu toka mwaka kubitila watula ndagu zake, kamba viyandikigwe mna Maandiko Gang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Mbuli ino Inogile yomulonga Mwana wa Mulungu, Mndewa wetu Yesu Kilisito. Heyo kawa munhu kwa kuvumbuka mulukolo lwa Daudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kwa nzila ya Loho Yang'alile, kalagusigwa kwa udahi mkulu kuwa Mwana wa Mulungu kwa kuzilibuligwa kwa wafile nayo yuyo Yesu Kilisito Mndewa wetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kubitila heyo na kwa mbuli ya twaga jake tubokela ng'hekewa na tuwa watumigwa, tuwalongoze wanhu wa isi zose wategeleze kwavija womtamanila. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Vivija mweye mwa mna iwanhu wasaguligwe kuwa wanhu wa Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Avo nowandikila mweye mose mukala ako Lumi, mweye munogeligwe na Mulungu na kawasagula muwe wanhu zake wang'alile. Ng'hekewa na tindiwalo kulawa kwa Mulungu Tataetu na Mndewa Yesu Kilisito vikale na mweye mose. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tanhu, nomgwaa nhogolwa Mulungu wangu kubitila Yesu Kilisito mbuli ya mweye mose, kwavija kumtamanila kwenu Mulungu kuhulikigwa na wanhu wose wa mwiisi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mulungu inimsang'hanila kwa moyo wangu wose, kwa kuwapetela wanhu Mbuli Inogile ya Mwanage, ayo yolola kuwa nowakumbuka mweye, ");
INSERT INTO kdc2014_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","miyanza mingi nahampula Mulungu. Nompula Mulungu yahalonda, yatende idahike niwatembelele mweye sambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nosulukila ng'hani niwone, muladi niwatende mumwede kiloho na niwagangamize. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Niye ng'hala nifambula vino, wose mweye na niye tuigangamize, tamanilo jangu kwa Mulungu dowagangamiza mweye na tamanilo jenu kwa Mulungu donigangamiza niye. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ndugu zangu nolonda mujuwe, miyanza mingi nilonda kuwatembelela, lakini mhotigwa kutenda avo mbaka sambi. Nilonda kumwenu mweye wanhu wamtogole Mulungu kamba vija viwatogole wanhu wayagwe haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nina ng'honde ya kuwapetela wanhu wose, Wagiliki na haweli Wagiliki, wabala na wabozi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Lekaavo nosulukila ng'hani vivija niwapetele Mbuli Inogile mweye mukala ako Lumi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Siyonela kinyala bule Mbuli Inogile, kwavija ina udahi wa Mulungu wakumkombola munhu yoyose yotogola, tanhu kwa Wayahudi, abaho kwa wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwavija Mbuli Inogile yogubula vija Mulungu viyowatenda wanhu wanoge mgameso gake. Mbuli ino yotendeka kwa kutamanila, kusongela haichanduso mbaka kuuhelelo. Kamba Maandiko Gang'alile vigalonga, “Munhu yatendigwe kanoga na Mulungu, kokuwa mgima kwa kumtamanila.” ");
INSERT INTO kdc2014_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mulungu kaigubula ng'hasiliki yake kulawa kuulanga mbuli ya gehile gose na nzambi za wanhu, awo kwa gaja gehile gowosang'hana woukimila ukweli sekeujuwike. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Avo gose gotenda Mulungu yajuwike kumwao gagubuligwa, kwavija Mulungu mwenyego kawagubulila. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Toka Mulungu yaumbe isi, udahi wake wa mazuwa gose na vija viyali, hamoja havoneka kwa meso, lakini vojuwika kwa kulola vinhu viyaumbile Mulungu. Avo wanhu hawadaha bule kuigombela! ");
INSERT INTO kdc2014_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Wamjuwa Mulungu, lakini hawamgwaa ukulu, hebu kumgwaa nhogolwa, magesa gao gamema ubozi, mizoyo yao imema ziza. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wenyego woitapa wabala kumbe wabozi. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Woleka kumgwaa ukulu Mulungu yeli mgima siku zose, wovigwaa ukulu vinyago, viigalile na wanhu wofa na ndege na wanyama na wang'onyo wotambala. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Avo Mulungu kawaleka wasulukile gehile mmizoyo yao, na woitendela vinhu vigela kinyala mzing'huli zao. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wougalusa ukweli wa Mulungu kwa uvizi, wovitambikila na kuvisang'hanila vija viyaumbile Mulungu na womuleka ija Yaumbile, heyo yolondeka kutogoligwa siku zose. Ona! ");
INSERT INTO kdc2014_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwavija wotenda vino, Mulungu kawaleka wawinze mbuli zigela kinyala mbaka watwanzi waleka kuwasa na wambigalo na woilonda wao kwa wao. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Wambigalo vivija woleka kuwasa na watwanzi, woilonda wao kwa wao. Wambigalo kwa wambigalo woitendela mbuli zigela kinyala, avo waigalila wenyego nhaguso ilondeka kwa gaja gowosang'hana. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwavija wanhu awo walema kumjuwa Mulungu kwa nzewele zao, Mulungu nayo kawaleka wakweleleze nzewele zao zihile, nao wasang'hana mbuli zigomesigwe kusang'hanwa. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wanhu wano wamema gose gehile, kwiha na umelo na wogevuza wayagwe. Wamema migongo na ukomaji na ndwagi na uvizi na magesa gehile. Wolonga wayao, ");
INSERT INTO kdc2014_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","woivizila, womwihila Mulungu, wanhu weli na nyodo, wasede wanhu weli na magoda, wanhu wogesa nzila ziyagwe za kutenda gehile. Hawawategeleza tatazao na mamazao, ");
INSERT INTO kdc2014_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","waduhu nzewele, hawatenda ziwalongile, hawawanogela wanhu na waduhu bazi kwa wanhu wayagwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wajuwa malagizo ganogile ga Mulungu golonga wanhu wotenda mbuli azo wolondeka wafe. Hawahelele kutenda mbuli azo ziiyeka lakini vivija wowagwaa pala ukulu wanhu wotenda mbuli zizo. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Avo gweye mbwigangu, kamba kowatagusa wayagwe kuwa wabananga, hudaha ng'o kuigombela, hata wahawa nani. Kwavija wahawatagusa wayagwe kuno na gweye kotenda mbuli zizija ziwotenda wao, baho koitagusa mwenyego. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tweye tojuwa kuwa nhaguso ya Mulungu kwa wanhu wotenda mbuli kamba azo ya kweli. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lakini gweye mbwigangu uwatagusa waja wotenda mbuli kamba azo kuno gweye mwenyego kotenda vivo! Vino gweye kogesa kodaha kuhonyeka na nhaguso ya Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Hebu kowehula uhole wake mkulu na viyoleka kulopola kuwatagusa wanhu na kufunga umoyo kwake. Hujuwa bule uhole wa Mulungu wokulongoza uleke nzambi na umbwelela Mulungu? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lakini kuna moyo mdala na kolema kumbwelela Mulungu, avo koikila nhaguso ng'hulu mna isiku ija ya ng'hasiliki za Mulungu na nhaguso yake inogile vondaigubuligwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kwavija Mulungu komulipa kila munhu kamba vija viyatendile. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wanhu wayagwe wogendelela kutenda ganogile kuno wolonda ukulu kwa Mulungu na kutogoligwa na Mulungu na kuleka kufa. Wanhu awo Mulungu kowagwaa ugima wa mazuwa gose. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Wanhu wayagwe wana gahigahi na woulema ukweli, muladi wakweleleze gehile, wanhu awo Mulungu kowatagusa ng'hani kwa ng'hasiliki yake. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Madununzo na usungu gowapata wanhu wose wotenda gehile, tanhu kwa Wayahudi abaho kwa wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini Mulungu kowagwaa ukulu, kutogoligwa na tindiwalo wanhu wose wotenda ganogile, tanhu Wayahudi abaho wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwavija Mulungu hambagula munhu yoyose. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wanhu wotenda nzambi kuno waduhu Malagizo ga Musa, wopotela bila Malagizo. Wanhu wotenda nzambi kuno wagajuwa Malagizo ga Musa, wotagusigwa kwa Malagizo. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kwavija siyo waja wogahulika Malagizo ga Musa, wao wanogile mgameso ga Mulungu, lakini waja wotenda vigalonda Malagizo, wao wonda watendigwe wanoge mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Wanhu haweli Wayahudi waduhu Malagizo ga Musa, lakini wahagesa kusang'hana vigalonda Malagizo, wao wenyego wanago malagizo hata kamba waduhu Malagizo ga Musa. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Mbuli zao zootenda zolagusa kuwa zilagizigwe na Malagizo zandikigwa mmizoyo yao. Mizoyo yao yolagusa kuwa uno awo ukweli, kwavija magesa gao kipindi kiyagwe gowatagusa na kipindi kiyagwe gowagombela. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Gano golawilila mna isiku ayo Mulungu vonda yagataguse magesa ga kinyelegezi ga wanhu, kubitila Yesu Kilisito, kamba viilonga Mbuli Inogile iniwapetela. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kamba gweye koikema Muyahudi, kogatamanila Malagizo ga Musa na koigodela kuwa munhu wa Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kamba gweye kujuwa viyolonda Mulungu utende kwavija Malagizo gakufunza kusagula ganogile, ");
INSERT INTO kdc2014_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","kamba gweye kujuwa goya kuwa kwa mulongozaji wa wasuwameso, na kwa mulenge kwa wanhu weli mdiziza, ");
INSERT INTO kdc2014_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kamba gweye kwa mulangulizi wa wabozi na mfundiza wa wanhu hawanakangala, kamba gweye kogesa mna Gamalagizo kunayo nzewele yose na ukweli, ");
INSERT INTO kdc2014_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","kowafundiza wayagwe, habali huifundiza mwenyego? Kowapetela wanhu sekewebe habali gweye mwenyego kokwiba? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Gweye kowalongela wanhu sekewatende ugoni, habali gweye kotenda ugoni? Kolonga vinyago havilondeka bule habali gweye mwenyego kokwiba vinhu vili mzing'anda za kutambikila vinyago? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Koigodela Malagizo ga Mulungu, vino gweye humgela kinyala Mulungu kwa kugabena Malagizo gake? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Maandiko Gang'alile golonga, “Mbuli ya gaja gomtenda mweye Wayahudi, wanhu wa isi ziyagwe wodiliga twaga da Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Mwahagagoga Malagizo, kwingila kumbi kwenu kofambula kinhu, lakini kamba hamugagoga Malagizo, kamba vija hamwingile kumbi bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kamba munhu heli Muyahudi na hengile kumbi yahagagoga Malagizo, vino Mulungu hamgesa bule kamba munhu yengile kumbi? ");
INSERT INTO kdc2014_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Avo waja hawengile kumbi na kuno wogagoga Malagizo wowahonza mutagusigwe kuwa mubananga mweye Wayahudi mwingile kumbi na kugajuwa Malagizo, lakini mogabena. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Avo, siyo kila munhu yokoneka kwa kunze Muyahudi iyo Muyahudi wa kweli, na munhu hatendigwa Muyahudi wa kweli kwavija kengila kumbi mulukuli. ");
INSERT INTO kdc2014_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lakini Muyahudi wa kweli ayo ija yeli Muyahudi kwa mgati, ayo ija moyo wake wingila kumbi. Ino ayo sang'hano ya Loho wa Mulungu na siyo Malagizo gandikigwe. Munhu yeli vino kobokela nhogolwa kwa Mulungu, na siyo kwa wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Vino Wayahudi wana choni chongezeke kuwabanza wanhu haweli Wayahudi? Hebu kwingila kumbi ni kinhu kikulu? ");
INSERT INTO kdc2014_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ona, kuna vinhu vingi vikulu, Mulungu kawagwaa Wayahudi usenga wake. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lakini yokuwaze kamba wanhu wayagwe hawatamaniligwa? Vino Mulungu nayo hatamaniligwa bule? ");
INSERT INTO kdc2014_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bule, Mulungu kolonga ukweli, hata kamba kila munhu koviza. Kamba Maandiko Gang'alile vigalonga mbuli ya Mulungu, “Wahalonga kolagusa ukweli, wahatagusa gweye kohuma.” ");
INSERT INTO kdc2014_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kamba gaja gehile gotusang'hana golagusa kamba Mulungu kotenda goya, vino tulongeze? Tulonge Mulungu kobananga yahatutagusa? Hano nolonga kiunhu unhu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bule, maza ikalile vivo, Mulungu yahadahile vilihi kuwatagusa wanhu wose wa mwiisi? ");
INSERT INTO kdc2014_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Munhu kodaha kulonga, “Kamba uvizi wangu womsang'hanila Mulungu na kumgwaa ukulu na wotenda ukweli wake woneke, habali notagusigwa kamba nina nzambi?” ");
INSERT INTO kdc2014_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Lelo habali hatulonga, “Lekeni tutende nzambi ili ganogile geze?” Wanhu wayagwe wandiga walonga niye nofundiza mbuli zizo! Wotagusigwa kamba viilondeka. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Sambi tulonge choni? Vino tweye Wayahudi tunoga kubanza wanhu haweli Wayahudi? Bule, nimala kuwalongela kuwa Wayahudi na wanhu haweli Wayahudi wose wotawaligwa na nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kamba Maandiko Gang'alile vigalonga, “Kuduhu hata munhu imoja yanogile mgameso ga Mulungu, ");
INSERT INTO kdc2014_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kuduhu munhu yeli na nzewele hebu yomzahila Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wanhu wose wamuleka Mulungu, wose wotenda gehile, kuduhu munhu yotenda ganogile, kuduhu hata imoja. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mitundu melo yao iigala na mapanga hagafukiligwe milimi yao yolonga uvizi, na mumilomo yao zolawa mbuli zili na sumu iigalile na sumu ya mgendela hasi, ");
INSERT INTO kdc2014_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ulonzi wao umema kuduila kugela usungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Hawakawa kukoma. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kokose kuwochola wohabananga na kuhananga. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Hawajuwile kukala kwa tindiwalo, ");
INSERT INTO kdc2014_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","hawamdumba Mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Sambi tojuwa kuwa Malagizo ga Mulungu gahalonga, golonga kwa wanhu wose wolongozigwa na Malagizo, muladi wanhu sekewaigombele, na wanhu wose wa mwiisi watagusigwe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kwavija kuduhu munhu yotendigwa kanoga mgameso ga Mulungu kwa kutenda gaja golondigwa na Malagizo, ila Malagizo ga Mulungu gotutenda tweye tujuwe totenda nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lakini sambi nzila ya Mulungu ya kuwatenda wanhu wanoge mgameso gake igubuligwa. Haitendeka kwa Malagizo ga Musa, hamoja Malagizo ga Musa na watula ndagu wa Mulungu wolonga mbuli ayo. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mulungu kowatenda wanhu wanoge mgameso gake kubitila tamanilo jao kwa Yesu Kilisito. Mulungu kotenda avo kwa wanhu wose womtogola Kilisito, kwavija wose waigala. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Wanhu wose watenda nzambi na wahungukilwa na ukulu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lakini kwa nhunza ya ng'hekewa ya Mulungu, wanhu wose wotendigwa wanoga na Mulungu kubitila Yesu Kilisito, yowalekesa. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mulungu kamulava Yesu muladi kwa damu yake, yazigele kumgongo nzambi za wanhu kwa kumtamanila heyo. Katenda avo kulagusa viyotenda ganogile kwa wanhu, kwavija baho umwaka kafunga umoyo na hawataguse bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Katenda avo kulagusa viyanogile kwa wanhu mna ikipindi cha sambi na komtenda munhu yoyose yomtogola Yesu yanoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Lelo toigodela choni? Kuduhu! Choni kilamuso cha mbuli ino? Kwavija togagoga Malagizo ga Mulungu? Bule, lakini kwavija totogola. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kwavija Mulungu komtenda munhu yanoge mgameso gake kwa kumtamanila kwiiyeka, na siyo kwa kutenda gaja golondigwa na Malagizo. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Vino Mulungu ni Mulungu wa Wayahudi waiyeka? Vino vivija heli Mulungu wa wanhu haweli Wayahudi? Ona, vivija Mulungu wa wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mulungu ni imoja, na kowatenda awo wengile kumbi wanoge mgameso gake kwa kumtamanila, vivija kowatenda awo hawengile kumbi wanoge mgameso gake kwa kumtamanila. ");
INSERT INTO kdc2014_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Vino ino yofambula kuwa wahamtamanila Mulungu kuduhu Malagizo? Bule, si vivo bule, togagoga Malagizo. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Vino tulonge choni mbuli ya Abulahamu, muhenga wetu, kaifunza choni? ");
INSERT INTO kdc2014_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Maza Abulahamu yatendigwe kanoga mgameso ga Mulungu mbuli ya zija ziyasang'hane, yahawile na kinhu cha kuigodela, lakini siyo mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Maandiko Gang'alile golonga, “Abulahamu kamtamanila Mulungu, na mbuli ya kumtamanila kwake, Mulungu kamgesa kanoga.” ");
INSERT INTO kdc2014_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Munhu yahasang'hana halipigwa kamba nhunza, lakini kolipigwa kamba fungu jake. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lakini munhu yoleka kutamanila sang'hano zake mwenyego, ila komtamanila Mulungu yozigela kumgongo nzambi za wanhu, avo Mulungu kodigesa tamanilo da munhu ayo na komtenda yanoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nayo Daudi kalonga mbuli iino, viyalongile mbuli ya kumweda kwa munhu yagesigwe na Mulungu kanoga, bila kulola gaja gayasang'hane. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Wamweda wanhu waja nzambi zao zigeligwa kumgongo na gaja gawatendile hagatongigwa! ");
INSERT INTO kdc2014_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kamweda munhu ija nzambi zake Mndewa honda yazigese!” ");
INSERT INTO kdc2014_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Vino kumweda kuno kuyalongile Daudi ni kwa wanhu waja wengile kumbi waiyeka? Bule! Vivija kwa wanhu hawengile kumbi. Kamba vinisongile kulonga, “Abulahamu kamtamanila Mulungu, na kwa kumtamanila kwake, Mulungu kamgesa kanoga.” ");
INSERT INTO kdc2014_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Vino Abulahamu kagesigwa kipindi gani? Yang'hali hana kwingila kumbi hebu viyengile kumbi? Yang'hali hanakwingila kumbi na siyo viyengile kumbi. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abulahamu kengila kumbi kumwande, kwingila kumbi kwake kukala kilaguso kilaguse kuwa Mulungu kamgesa kanoga mbuli ya kumtamanila kwake yang'hali hanakwingila kumbi. Avo Abulahamu yuyo tata wa wanhu wose womtamanila Mulungu hata kamba hawengile kumbi na wanhu awo wogesigwa na Mulungu wanoga. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Vivija Abulahamu iyo tata wa wanhu wose wengile kumbi, lakini siyo kwavija wengila kumbi kwiiyeka, ila kwavija wokweleleza nzila iija ya kumtamanila Mulungu iyaikweleleze tataetu Abulahamu yang'hali hanakwingila kumbi. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mulungu kamulongela Abulahamu na lukolo lwake kuwa isi yose yokuwa yao, siyo kwavija Abulahamu kagagoga Malagizo, lakini kwavija kamtamanila Mulungu, nayo Mulungu kamtenda kanoga mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kwavija kamba kija kiyalongile Mulungu wogweleligwa waja wogagoga Malagizo waiyeka, baho tamanilo jao kwa Mulungu daduhu kinhu na vivija kija kiyalongile Mulungu siyo kinhu. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Malagizo gogala ng'hasiliki za Mulungu, lakini kamba kuduhu Malagizo, kuduhu kubena Malagizo. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Avo kija kiyalongile Mulungu kiza kwa kutamanila, muladi kubitila ng'hekewa ya Mulungu kwa vovose wagweleligwe nhunza wanhu wa lukolo lose lwa Abulahamu, siyo kwa waja wogagoga Malagizo waiyeka, lakini vivija kwa waja womtamanila Mulungu kamba viyatendile Abulahamu, yeli tata wa tweye wose. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kamba Maandiko Gang'alile vigalonga, “Nikusagula uwe tata wa isi nyingi.” Avo mbuli azo za kweli mgameso ga Mulungu, iyamtamanile Abulahamu, Mulungu yowazilibula wanhu wafile, na kwa lagizo jake vinhu havikalile baho, vabaho. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abulahamu katogola na katamanila, hamoja kukala kuduhu kinhu cha kutamanila, na avo kawa tata wa isi nyingi. Kamba Maandiko Gang'alile vigalonga, “Wanhu wa lukolo lwako wokuwa wengi.” ");
INSERT INTO kdc2014_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abulahamu kakala na miyaka gana dimoja, lakini tamanilo jake kwa Mulungu hadihunguke hamoja kajuwa kakala yalalile ng'hani, na mwehe wake Sala sambo ikala imalile. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abulahamu halekile kutamanila kiyalongile Mulungu, lakini tamanilo jake kwa Mulungu dimgangamiza na kamgwaa ukulu Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Kajuwa goya kuwa Mulungu kodaha kutenda kija kiyamulongele. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Lekaavo Abulahamu kwa kumtamanila Mulungu, “Kagesigwa na Mulungu kanoga.” ");
INSERT INTO kdc2014_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ulonzi wa, “kagesigwa na Mulungu kanoga” hawandikigwe kumwake yaiyeka, ");
INSERT INTO kdc2014_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","vivija wandikigwa kumwetu kuwa togesigwa na Mulungu tunoga kwa kumtogola Mulungu yamzilibule Mndewa wetu Yesu, kwa wafile. ");
INSERT INTO kdc2014_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Heyo kalavigwa yafe kwa nzambi zetu, abaho kazilibuka ili Mulungu yatutende tunoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Sambi kwavija tutendigwa tunoga mgameso ga Mulungu kwa kumtamanila, tuna tindiwalo na Mulungu kubitila Mndewa wetu Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa kumtamanila heyo, Yesu katugalila ng'hekewa ya Mulungu, itukala nayo sambi, avo tobetela kwa kudeng'helela kwingila muukulu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Siyo gago gaiyeka, lakini vivija toigodela gamagayo getu, kwavija tojuwa kuwa magayo gogala kufunga umoyo, ");
INSERT INTO kdc2014_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kufunga umoyo kogala kugangamala, na kugangamala kogala tamanilo. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Tamanilo dino haditugela kinyala, kwavija Mulungu keka unogelwa wake mmizoyo yetu kubitila Loho Yang'alile, iyatugwelele tweye. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Vitukalile hatudaha kuihonya wenyego, kipindi kinogile vikivikile, Kilisito kafa mbuli ya tweye tutenda gehile. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Vidala ng'hani kwa munhu kufa mbuli ya munhu yanogile mgameso ga Mulungu. Sengine munhu kodaha kugeza kufa mbuli ya munhu yanogile ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini Mulungu katulagusila vija viyotunogela kwavija vitukalile tung'hali totenda nzambi Kilisito kafa mbuli yetu tweye! ");
INSERT INTO kdc2014_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwavija sambi Mulungu katutenda tunoge mgameso gake kwa damu ya Kilisito, kweli kotukombola na ng'hasiliki za Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Vitukalile tuihila na Mulungu, tuilumba nayo kubitila ifa ya mwanage. Sambi tuilumba na Mulungu, yokuwa vinoga ng'hani na kweli tokomboligwa kwa ugima wa Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lakini siyo gago gaiyeka, vivija wose todeng'helela mbuli ya gaja gayatendile Mulungu kubitila Mndewa wetu Yesu Kilisito, yatutendile tuilumbe na Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nzambi ingila mwiisi kubitila munhu imoja, na nzambi yake igala ifa. Avo, ifa yenela kwa wanhu wose kwavija wanhu wose watenda nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Malagizo ga Musa gang'hali haganagaligwa nzambi zikala mumuno mwiisi. Lakini hanhu kuduhu Malagizo, nzambi hazigesigwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lakini kulawa mna ikipindi cha Adamu mbaka mna ikipindi cha Musa, ifa iwatawala wanhu wose, hata kwa waja hawatendile nzambi kamba ziyatendile Adamu yalekile kugoga gaja gayamulagize Mulungu. Adamu kakala kamba sisila da Kilisito yezile kumwande. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini vinhu vino vibili haviigalile, kwavija nhuza ya Mulungu haiigalile na nzambi ya Adamu. Kweli hata kamba wanhu wengi wafa kwa nzambi ya munhu ayo imoja, lakini ng'hekewa ya Mulungu ibanza ng'hani na nhunza yake yenela kwa wanhu wengi kubitila ng'hekewa ya munhu imoja, Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nhunza ya Mulungu haiigalile na nzambi ya munhu imoja. Kwavija munhu imoja viyatendile nzambi Mulungu katagusa, lakini wanhu wengi viwatendile nzambi, Mulungu kawagwaa nhunza ya kuwatenda wanoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwa nzambi za munhu imoja ifa itawala. Lakini kija kiyatendile munhu ija imoja, Yesu Kilisito, kikulu ng'hani. Wanhu wose woipata ng'hekewa imemile ya Mulungu na nhuza ng'hulu, wotendigwa wanoga mgameso ga Mulungu na wotawala muugima kubitila munhu imoja, Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Avo kamba vija nzambi za munhu imoja ziwatagusa wanhu wose, vivo ili kwa kinhu kimoja kinogile kwa Mulungu chowatenda wanoge mgameso ga Mulungu wanhu wose na kuwagwaa ugima. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kamba vija kulema kutegeleza kwa munhu imoja wanhu wengi wotenda nzambi, vivo ili kwa kutegeleza kwa munhu imoja wanhu bwando wotendigwa wanoga mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagizo ga Musa galawilila, avo gehile nago gongezeka, lakini nzambi vizongezeke, ng'hekewa ya Mulungu nayo yongezeka ng'hani. ");
INSERT INTO kdc2014_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Avo, kamba vija nzambi vizitawale na kugala ifa, vivo ili ng'hekewa ya Mulungu yotawala kwa ganogile, na kutugala muugima wa mazuwa gose kubitila Yesu Kilisito Mndewa wetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Baho tulongeze? Vino tugendelele kutenda nzambi ili ng'hekewa ya Mulungu yongezeke? ");
INSERT INTO kdc2014_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bule! Tweye tufa na hatulongozigwa kabili na nzambi, yokuwaze tugendelele kabili kukala mzinzambi? ");
INSERT INTO kdc2014_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Vino hamujuwile kamba tweye wose tubatizigwe kwa kuilumba na Yesu Kilisito tubatizigwa mwiifa yake? ");
INSERT INTO kdc2014_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Vitudidimizigwe mgamazi, kamba tuzikigwa hamoja nayo na tuilumba mwiifa yake, avo kamba vija Kilisito viyazilibuke mwiifa kwa ukulu wa Tata, vivija na tweye tudahe kukala muugima wa sambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kwavija kamba tuilumba nayo mna ukufa kamba viyafile, vivija toilumba nayo mna ukuzilibuka kamba viyazilibuke. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Kwavija tojuwa unhu wetu wa umwaka uwambigwa mumsalaba hamoja na Kilisito, muladi udahi wa nzambi uli mzing'huli zetu unangigwe na seketuwe watumwa wa nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwavija munhu yoyose yahafa, kolekesigwa na udahi wa nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kamba tufa hamoja na Kilisito, vivija totamanila kukala hamoja nayo. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwavija tojuwa kamba Kilisito kazilibuka kwa wafile na honda yafe kabili, ifa honda imtawale kabili. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Avo kwavija kafa mwanza umoja, nzambi yaduhu udahi kumwake na sambi kokala kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Vivija na mweye muigese kamba mufa na hamulongozigwa kabili na nzambi, lakini mukale wagima kwa Mulungu kubitila Yesu Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nzambi sekezitawale kabili mzing'huli zenu zifa, avo sekemukweleleze vizilonda ng'huli zenu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Vivija sekemulave hata hanhu hadodo ha maungo genu kwa nzambi. Lakini muilave wenyego kwa Mulungu, kamba wanhu wazilibuke kwa wafile, na muilave wenyego kumwake kwa gaja goyolonda. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nzambi sekeziwatawale kabili, kwavija mweye hamulongozigwa na Malagizo ga Musa, lakini molongozigwa na ng'hekewa ya Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Vino tulonge choni? Tutende nzambi kabili, kwavija hatulongozigwa na Malagizo lakini tolongozigwa na ng'hekewa ya Mulungu? Bule! ");
INSERT INTO kdc2014_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mweye mojuwa kamba mwahailava wenyego kamba watumwa kumtegeleza munhu, mweye mokuwa watumwa wa munhu ayo yumumtegeleza. Mwahawa watumwa wa nzambi, mohelela mwiifa, hebu mwahawa watumwa wa kumtegeleza Mulungu motendigwa munoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Lakini Mulungu yatogoligwe, kwavija hamoja umwaka mukala watumwa wa nzambi, lakini sambi mogagoga kwa mizoyo yenu yose, gaja gose geli mna gamafundizo gamubokele. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mulekesigwa muutumwa wa nzambi na muwa watumwa wa kutenda goyolonda Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nolonga ulonzi uwalongaga wanhu siku zose muladi mudahe kujuwa. Kamba vija umwaka vimuilavile wenyego kuwa watumwa wa nzambi na gehile gose. Vivija sambi molondeka muilave wenyego kuwa watumwa wa kutenda goyolonda Mulungu, gogala kung'ala. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Vimukalile watumwa wa nzambi, mukala hamugesa kutenda goyolonda Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Vino mupata choni vimusang'hane mbuli zija sambi mozonela kinyala? Kwavija gaja gamutendile gogala ifa! ");
INSERT INTO kdc2014_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini mulekesigwa mzinzambi na mwa watumwa wa Mulungu. Sambi mumweda kwa kupata kung'ala, na kung'ala kuno kogala ugima ulibule uhelelo. ");
INSERT INTO kdc2014_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwavija fungu da nzambi ayo ifa, lakini nhunza ya Mulungu awo ugima ulibule uhelelo kwa kuilumba na Yesu Kilisito, Mndewa wetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ndugu zangu, nojuwa mogajuwa gonilonga kwavija nolonga na wanhu wagajuwile malagizo. Malagizo gomtawala munhu kipindi yahawa mgima. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mtwanzi yahasoligwa kogodekigwa na lagizo kipindi chose mkasano wake yang'hali mgima, lakini mkasano wake yahafa, mtwanzi ayo kalekesigwa na lagizo dimgogile. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Avo yahasoligwa na mbigalo iyagwe kipindi mkasano wake yang'hali mgima, kokemigwa mgoni. Lakini kamba mkasano wake yahafa, kobwihila na hatenda ugoni bule hata kamba yahasoligwa na mbigalo iyagwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Avo ndugu zangu, mweye vivija mufa na hamulongozigwa kabili na Malagizo, kwavija muilumba na lukuli lwa Kilisito, sambi mwa wanhu zake heyo yazilibuke kwa wafile, muladi tusang'hane ganogile kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Vitukalile tokala kuno tolongozigwa vija vilulonda lukuli, usulukilo wa nzambi, uding'huke kwa lagizo usang'hana mzing'huli zetu, mbuli zose zitutendile zihelela mwiifa. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Sambi hatulongozigwa na Malagizo, kwavija tuigola na gaja gatugodeke. Avo tomsang'hanila Mulungu mnzila ya sambi ya Loho Yang'alile siyo mnzila ya umwaka ya Malagizo gandikigwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Vino tulonge Malagizo gana nzambi? Bule! Lakini Malagizo gago ganitendile niye niijuwe nzambi. Maza Malagizo hagalongile, “Sekeusulukile kinhu cha miyago,” Sambi njuwe bule kusulukila kwiha. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Lakini mbuli ya Malagizo gago, nzambi ipata nzila ya kuding'hula gehile gose kumwangu. Bila Malagizo nzambi zaduhu udahi. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Baho umwaka ving'halile silongozigwa na malagizo ng'hala mgima, lakini malagizo vigezile, nzambi zizilibuka na niye nifa. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Vinikona niye, malagizo gagesigwe gogala ugima, gagala ifa. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kwavija nzambi zipata nyafasi igaligwe na malagizo, na kubitila malagizo gago, zimvizila na kung'homa. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Avo Malagizo ga Musa Gang'ala, na lagizo ding'ala, domnogeza Mulungu na dinoga. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Vino ino yofambula kija kinogile kigala ifa kumwangu? Bule, lakini ili nzambi ijuwike kamba nzambi, kubitila kija kinogile igala ifa kumwangu. Avo kubitila Malagizo nzambi ilagusigwa viibanzile kwiha. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tojuwa kuwa Malagizo golawa kwa Loho Yang'alile lakini niye na munhu yeli na lukuli, nichuuzigwa niwa mtumwa wa nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sikijuwile kija kinhenda, kwavija sitenda kija kinonda, lakini kija kinikihila acho kinhenda. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kamba nahatenda kija sikilondile kutenda, ino yolagusa kuwa nogatogola Malagizo gago kuwa ganoga. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Avo, siyo niye nitenda kinhu acho, ila nguvu ya nzambi ayo ikala mgati mmwangu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nojuwa kuwa kuduhu dinogile dikala mgati mmwangu muunhu wangu. Kwavija nolonda kutenda ganogile, lakini sidaha bule kutenda. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Sitenda mbuli zinogile zinilonda kutenda, ila notenda gehile gaja sigalonda kutenda. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Avo nahatenda gaja sigalonda kutenda, ino yolagusa kamba siyo niye nitenda avo, ila nzambi ikala mmwangu ayo itenda avo. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Avo nyona kuna kinhu chogendelela, nahalonda kutenda ganogile, nzambi ya behi yangu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mgati muumoyo wangu nogadeng'helela Malagizo ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lakini nokona kuna lagizo diyagwe dosang'hana mgati mmwangu, lagizo ajo dogomba na malagizo gotogoligwa na nzewele zangu, na donhenda niye niwe mfungwa wa nzambi zisang'hana mgati mmwangu. ");
INSERT INTO kdc2014_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Oo miyenu niye! Nani yodaha kunikombola ndawe mulukuli luno lunigala mwiifa? ");
INSERT INTO kdc2014_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mulungu yatogoligwe, yotenda mbuli zino kubitila Mndewa wetu Yesu Kilisito! Vino vivo ili, niye mwenyego kwa nzewele zangu na mtumwa wa Malagizo ga Mulungu, lakini kwa lukuli lwangu niye na mtumwa wa malagizo ga nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Avo wanhu wose weli wa Yesu Kilisito honda watagusigwe kuwa wabananga. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwavija kubitila Yesu Kilisito malagizo ga Loho yogala ugima, gotulekesa na malagizo ga nzambi na ga ifa. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kija hakidahike kutendigwa na Malagizo ga Musa mbuli ya kunyolila kwa unhu wa wanhu, Mulungu kasang'hana kwa kumtuma Mwanage mwenyego, yezile mulukuli luigalile na ng'huli zetu tweye wene nzambi. Avo kazitagusa nzambi zili mulukuli lulo. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Mulungu katenda vivo muladi gaja galondeke mna Gamalagizo ga Musa gatendeke mgati mmwetu, tweye tukala muugima wa Loho Yang'alile, na siyo lukuli lumemile nzambi. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Wanhu wokala kwa kulukweleleza lukuli wotawaligwa na magesa ga lukuli. Lakini wanhu wokala kwa kukweleleza viyolonda Loho Yang'alile, wotawaligwa na magesa ga Loho Yang'alile. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kwavija kulongozigwa na magesa ga lukuli kogala ifa, lakini kulongozigwa na Loho Yang'alile kogala ugima na tindiwalo. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Wanhu wokweleleza vilulonda lukuli woihila na Mulungu. Kwavija hawagagoga Malagizo ga Mulungu na hawadaha kugagoga. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wanhu wokweleleza vilulonda lukuli hawadaha kumnogeza Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Lakini mweye, kamba Loho wa Mulungu kokala mgati mmwenu, hamulongozigwa na lukuli, ila molongozigwa na Loho. Kamba munhu yoyose kaduhu Loho wa Kilisito, munhu ayo heli wa Kilisito bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Lakini kamba Kilisito kokala mgati mmwenu, hata kamba ng'huli zenu zofa mbuli ya nzambi, Loho kowatenda muwe wagima, kwavija Mulungu kawatenda munoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Kamba Loho wa Mulungu yamzilibule Yesu kwa wafile kokala mgati mmwenu, avo ayo Mulungu yamzilibule Kilisito kwa wafile vivija kozizilibula ng'huli zenu zifaga, kotenda avo kubitila Loho wake, yokala mgati mmwenu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Avo ndugu zangu, tuna ng'honde, tolondeka seketukale kamba vizilonda ng'huli zetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Avo mwahakala kamba vizilonda ng'huli zenu, mofa, lakini kamba mozileka nzambi zenu kubitila Loho, mokuwa wagima. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kwavija wanhu wolongozigwa na Loho wa Mulungu wao wana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwavija Mulungu hawagwelele bule Loho wa kuwatenda muwe watumwa kabili na kuwagela bwembwe, lakini kawagwaa Loho wa kuwatenda wana. Na kwa udahi wa Loho tomkema Mulungu, “Tata!” ");
INSERT INTO kdc2014_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Nayo Loho mwenyego kolagusa hamoja na loho zetu kuwa tweye twa wana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Kwavija tweye twa wanage, kotugwaa ganogile gayawekile wanhu zake, vivija tweye hamoja na Kilisito topata gaja gayamwikile, kamba tugaya nayo, vivija toupata ukulu wake. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kwavija nojuwa magayo ga kipindi kino hagabanzile ukulu uja wonda ugubuligwe kumwetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Vinhu vose viumbigwe vobetela kwa kusulukila ng'hani, Mulungu vonda yalaguse welihi wao wanage. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwavija vinhu viumbigwe vitendigwa voneke si kinhu bule, siyo kwa kulonda venyego, lakini kamba viyalondile Mulungu. Hata ivo chabaho cha kutamanila, ");
INSERT INTO kdc2014_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kuwa vinhu viumbigwe hana siku volekesigwa muutumwa wa kunangika na vokwingila muukulu wa kubwihila wa wana wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwavija tojuwa mbaka sambi baha, vinhu vose viumbigwe vogutilila kwa usungu kamba usungu wa kulela mwana. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Lakini siyo vinhu viumbigwe viiyeka avo vigutilila kwa usungu, lakini tweye vivija tuli na Loho, yakalile nhunza ya ichanduso ya Mulungu, togutilila mgati kwa mgati, kuno tobetela Mulungu yatutende wanage na kutulekesa mna zing'huli zetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwavija kwa kutamanila avo tukomboligwa, lakini twahachona acho kitubetela, tamanilo dijo hadifaya. Nani yotamanila kija kiyaone? ");
INSERT INTO kdc2014_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Lakini kamba totamanila kija tung'hali hatunachona, tokibeta kwa kufunga umoyo. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Vivo ili, Loho mwenyego kotutaza tweye kuna ukunyolila kwetu. Kwavija hatujuwile kija kitulondeka kumpula Mulungu. Loho mwenyego kotupulila kwa Mulungu kwa kugutilila kuleka kulongeka. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ayo yolola mmizoyo yetu, kojuwa viyogesa Loho, kwavija Loho kowapulila wanhu wa Mulungu kamba viyolonda Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tojuwa kuwa mna ivinhu vose Mulungu kosang'hana vinogile kwa waja womnogela Mulungu, waja yawakemile watende goyolonda. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kwavija wanhu yawajuwile Mulungu toka mwaka, awo yawabagule waigale na Mwanage, muladi Imwana yawe mwana wa chaudele mulukolo lukulu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Avo waja wabaguligwe na Mulungu, wao yawakemile, na waja yawakemile, kawatenda wanoge mgameso gake, na waja yawatendile wanoge mgameso gake, wao yakalile nao muukulu wake. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mzimbuli zose zino, tulonge choni, Mulungu yahawa ubanzi wetu, nani yodaha kututenda mbuli yoyose? ");
INSERT INTO kdc2014_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Mulungu hamonele bazi hata Mwanage mwenyego, lakini kamulava mbuli ya tweye wose! Kamba katugwaa Mwanage, vino vivija honda yatugwee bule vinhu vose? ");
INSERT INTO kdc2014_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Vino nani yonda yawalavile vitala wanhu wasaguligwe na Mulungu? Mulungu mwenyego kawatenda wanoge mgameso gake! ");
INSERT INTO kdc2014_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Vino nani yonda yawataguse kuwa wabananga? Kuduhu! Kwavija Yesu Kilisito kafa, abaho kazilibuka kwa wafile, sambi kokala muukulu mwambu wa mkono wa kudila wa Mulungu, nayo ayo yotupulila kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Vino nani yodaha kutugola na unogelwa wa Kilisito? Vino mbuli ya magayo hebu udala wa kupata vilondeka hebu madununzo hebu lufilili lwa nzala hebu ukiwa hebu zumozumo hebu ifa? ");
INSERT INTO kdc2014_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kamba Maandiko Gang'alile vigalonga, “Mbuli yako, tweye twa mdizumozumo da kufa imisi na ikilo. Tuigala na ng'hondolo wochola kuchinjigwa.” ");
INSERT INTO kdc2014_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Bule, mzimbuli zose zino tuhuma ng'hani kubitila heyo yotunogela tweye! ");
INSERT INTO kdc2014_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kwavija niye nojuwa goya kuduhu kinhu kidaha kutugola na unogelwa wake, si ifa hebu ugima hebu wasenga wa kuulanga hebu wakulu wayagwe wa kuulanga, si kipindi cha sambi hebu kipindi chonda kize, hebu udahi wowose, ");
INSERT INTO kdc2014_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","si kuulanga hebu hasi kuwochola wanhu wafile, hebu mna ivinhu vose viumbigwe, kuduhu kidaha kutugola na unogelwa wa Mulungu uli kwa Yesu Kilisito Mndewa wetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Niye nolonga ukweli, niye na munhu wa Kilisito, avo siviza bule. Moyo wangu, kwa kuitogolela na Loho Yang'alile, wonongela kamba silonga uvizi bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nolonga vino, kwavija nonyunyuwala ng'hani na usungu uli muumoyo haumala bule, ");
INSERT INTO kdc2014_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","mbuli ya Wayahudi wayangu, na wanhu wa lukolo lwangu, mbuli ya kuwataza nahadahile kupula niduiligwe na Mulungu na mbaguligwe na Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Awo wao Wayahudi, wasaguligwe na Mulungu wawe wanage, kawalagusila ukulu wake, kailagana nao, kawagwaa Malagizo gake, na vija viwolondeka kumtambikila na gaja gayalongile. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Awo wao wazukulu wa wahenga wa Waebulania, nayo Kilisito muuunhu wake kalawa mulukolo lwao. Mulungu yotawala mna ivose, yatogoligwe siku zose! Ona. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Silonga bule Mulungu kalemelwa kutenda kija kiyalongile, kwavija siyo wanhu wose wa Izilaeli wao wanhu wa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Vivija siyo lukolo lose lwa Abulahamu wao wanage Mulungu. Kwavija Mulungu kamulongela Abulahamu, “Lukolo lwako lolawa kwa Isaka.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Avo siyo wana wose wa Abulahamu waleligwe kwa lukuli wao wana wa Mulungu, lakini wana waleligwe kubitila kija kiyalongile Mulungu, awo wao lukolo lwa Abulahamu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kwavija kija kiyalongile Mulungu acho kino, “Mna ikipindi kinogile nobwela na Sala kolela mwana.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Na haimalile baho bule, ila Lebeka kalela wana wabili kwa tata imoja, nayo iyo Isaka muhenga wetu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Lakini wana wao wabili wang'hali hawanavumbuka na wang'hali hawanajuwa kutenda ganogile hebu gehile, muladi Mulungu yaoneke kana udahi wa kusagula, ");
INSERT INTO kdc2014_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","na yahasagula kosagula kamba viyolonda mwenyego, na siyo mbuli ya kija kiyatendile munhu, lakini kwa kija kiyalongile, “Imkulu komsang'hanila imdodo.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kamba Maandiko Gang'alile vigalonga, “Nimnogela Yakobo, lakini nimwihila Esau.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Vino tulonge choni? Mulungu kobagula? Bule habagula bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kwavija kamulongela Musa, “Nomtendela ganogile munhu yoyose inimulonda, na nomonela bazi munhu yoyose inimulonda.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Avo kila kinhu chotamanila bazi da Mulungu siyo viyolonda munhu hebu viyosang'hana munhu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kwavija Maandiko Gang'alile gomulongela vino Falao, “Niye nikutenda mndewa, muladi kubitila gweye ndaguse udahi wangu na twaga jangu dijuwike mwiisi yose.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Avo, Mulungu komonela bazi munhu yoyose yoomulonda na komtenda munhu yoyose yoomulonda yawe mdala kutogola. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Lakini imoja wenu konilongela, “Kamba vino vivo ili, habali Mulungu kolonga tubananga? Nani yodaha kugalema goyolonda Mulungu?” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Gweye mbwigangu kwa nani umwidika Mulungu? Vino kitumbe chodaha kumuuza munhu yakilumbile, “Habali unilumbile vino?” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Avo munhu yalumbile kitumbe kodaha kukisang'hanila kamba viyolonda. Kodaha kulumba vitumbe vibili muulongo uuja, kitumbe kimoja kwa sang'hano ng'hulu na kiyagwe kwa sang'hano ndoo ndodo. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Vivo ili kwa kija kiyatendile Mulungu. Kalonda kulagusa ng'hasiliki yake na kutenda udahi wake ujuwike, lakini kafunga umoyo na kuwonela bazi wanhu wose walondeke kutagusigwa, wanhu walondeke kubanangigwa. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nayo mwenyego kalonda kulagusa ukulu wake, viyatonele bazi tweye wanhu zake, yatusagule toka mwaka tubokele ukulu wake. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Avo tweye twa wanhu tukemigwe, siyo kulawa kwa Wayahudi waiyeka, lakini vivija kulawa kwa wanhu haweli Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kamba viyolonga Mndewa mkitabu cha mtula ndagu Hosea, “Wanhu haweli wangu, nowakema, ‘Wanhu zangu.’ Ija simnogele, nomkema, ‘Nomnogela.’ ");
INSERT INTO kdc2014_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na hanhu hawalongeligwe, ‘Hamwili wanhu zangu,’ baho wokemigwa wana wa Mulungu yeli mgima.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nayo Isaya mtula ndagu wa Mulungu kalonga kwa kukemelela mbuli ya wanhu wa Izilaeli, “Hata kamba wanhu wa Izilaeli wengi kamba msanga wa mhwani, lakini wanhu wonda wakomboligwe wokuwa wadodo. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kwavija Mndewa kolopola kumambukiza kuwatagusa wanhu wa mwiisi.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kamba Isaya viyalongile ako kukisogo, “Maza Mndewa yeli na udahi sambi yatulekele wanhu wayagwe mulukolo, twahabanangike kamba wanhu wa Sodoma na Gomola.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Avo tulonge choni? Wanhu haweli Wayahudi hawatendile kinhu muladi watendigwe wanoge mgameso ga Mulungu, lakini kwa kumtamanila, Mulungu kawatenda wanoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Wanhu wa Izilaeli wakalile wozahila malagizo muladi watendigwe wanoga na Mulungu, lakini hawagapatile malagizo ga kuwatenda wanoge mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Habali hawagapatile? Hawagapatile kwavija hawekile tamanilo jao kwa Mulungu lakini watamanila gaja gawakalile wosang'hana. Avo waikwala, “mwiing'walo ya dibwe.” ");
INSERT INTO kdc2014_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kamba vigolonga Maandiko Gang'alile, “Loleni nokwika dibwe ako Sayuni donda diwatende wanhu waikwale, dibwe kulu donda diwalagaze wanhu. Lakini munhu yoyose yonda yamtogole honda yagwe kinyala.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ndugu zangu, moyo wangu wolonda ng'hani na nowapulila kwa Mulungu Waizilaeli wayangu wakomboligwe! ");
INSERT INTO kdc2014_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nokona kuwa wowamba ng'hani kumnogeza Mulungu, lakini kuwamba kwao hakutimilike kwavija hawaujuwile ukweli wose. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kwavija hawajuwile vija Mulungu viyowatenda wanhu wanoge mgameso gake, lakini wao watenda viwogesa, avo walema kutogola vija Mulungu viyowatenda wanhu wanoge mgameso gake. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwavija Kilisito viyezile, keza kugamambukiza Malagizo, avo munhu yoyose yomtogola Kilisito kotendigwa kanoga mgameso ga Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mbuli ya kutendigwa kunoga mgameso ga Mulungu kwa kugagoga Malagizo, Musa kandika vino, “Munhu yoyose yogoga Malagizo kokuwa mgima kwa Malagizo.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lakini mbuli ya kutendigwa kunoga mgameso ga Mulungu kwa kumtamanila, Maandiko Gang'alile golonga vino, “Sekeuiuze mwenyego, nani yonda yachole kuulanga kumuhumulusa Kilisito?” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Vivija sekeuiuze, nani yonda yachole hasi kowochola wanhu wafile kumzilibula Kilisito?” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Maandiko Gang'alile golonga, “Usenga wa Mulungu wa behi na gweye, wa mumulomo wako na muumoyo wako,” nao, awo usenga wa kumtamanila Mulungu, utuwapetela wanhu. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Wahalonga kwa mulomo wako kuwa Yesu ayo Mndewa na kotogola muumoyo wako kuwa Mulungu kamzilibula kwa wafile, kokomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kwavija wahatogola muumoyo wako, kotendigwa kunoga mgameso ga Mulungu na wahalonga kwa mulomo wako kokomboligwa. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Maandiko Gang'alile golonga, “Munhu yoyose yomtogola honda yageligwe kinyala.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Mulungu hawabagula Wayahudi na wanhu haweli Wayahudi, kwavija wose Mndewa wao imoja, nayo kowatendela ganogile wanhu wose wompula. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kwavija Maandiko Gang'alile golonga, “Munhu yoyose yopula kwa twaga da Mndewa kokomboligwa.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Vino wompulaze kamba hawamtogole? Na womtogolaze kamba hawauhulike usenga wake? Na wouhulikaze usenga kamba kuduhu munhu wa kuwapetela? ");
INSERT INTO kdc2014_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Wanhu wopetaze usenga kamba hawatumigwe? Kamba Maandiko Gang'alile vigalonga, “Lola vivinogile kwiza kwa wanhu wopeta Mbuli Inogile!” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lakini siyo wose waitogola Mbuli Inogile ya Mulungu. Kwavija Isaya mtula ndagu wa Mulungu kalonga, “Mndewa, nani yautogole usenga wetu?” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Avo munhu komtamanila Mulungu kwa kuuhulika usenga, usenga awo wokwiza kwa kupetigwa kwa mbuli inogile ya Kilisito. ");
INSERT INTO kdc2014_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lakini niye nouza, vino hawauhulike usenga? Ona, kuuhulika wauhulika, kwavija Maandiko Gang'alile golonga, “Nyangi zao zihulikigwa mwiisi yose, mbuli zao zivika kuuhelelo wa isi.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nouza kabili, vino wanhu wa Izilaeli hawajuwa bule? Mulungu kalonga kwa mulomo wa Musa, “Nowatenda mweye wanhu zangu muwonele migongo, wanhu wa isi iyagwe nowatenda muwagevuzikile wanhu wabozi wa isi ziyagwe.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Mulungu kagangamiza kulonga kwa mulomo wa Isaya, “Wanhu walekile kunizahila wanyona, niwalawilila wanhu walekile kuuza mbuli zangu.” ");
INSERT INTO kdc2014_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lakini mbuli ya Izilaeli, Mulungu kolonga, “Imisi yose niwenulila makono gangu kuwabokela wanhu woleka kunihulika na wononga vihile.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Nouza, vino Mulungu kowalema Wayahudi wanhu zake mwenyego? Bule, hawalema! Niye mwenyego na Mwiizilaeli, mzukulu wa Abulahamu, kabila da Benjamini. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Mulungu hawalemile bule wanhu zake, yawasagule toka mwaka. Vino hamujuwile bule Maandiko Gang'alile vigalonga mbuli ya Eliya viyamuyalalile Mulungu mbuli ya wanhu wa Izilaeli? ");
INSERT INTO kdc2014_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Kalonga, “Mndewa, wawakoma watula ndagu zako na kubomola kila upango wako wa kulavila nhosa. Niye niiyeka ayo nisigale na wao wolonda kung'homa.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Vino Mulungu kamwidikaze? Kamwidika vino, “Niye mwenyego niikila wanhu gana miyanza malongo saba waja hawamtambikile Baali yaitendile mulungu.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Sambi vivo ili, hana wanhu kidogo wasigala mna iwanhu wasaguligwe na Mulungu kwa ng'hekewa yake. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Avo wasaguligwa kwa ng'hekewa ya Mulungu, siyo mbuli ya gaja gawasang'hane. Maza Mulungu kosagula wanhu kwa gaja goyosang'hana, baho ng'hekewa yake sambi iwe ng'hekewa bule. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Vino, wanhu wa Izilaeli wakipata kija kiwakalile wokizahila? Bule, lakini waja wasaguligwe na Mulungu wakipata, wayagwe wafumbigwa sekewajuwe. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kamba Maandiko Gang'alile vigalonga, “Mulungu kaifunga mizoyo yao na nzewele zao, mbaka lelo hawadaha kulola hebu kuhulika.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Nayo Daudi kolonga, “Nyimwili nyimwili zao ziwe mtego wa kuwanamata, waikwale na watagusigwe! ");
INSERT INTO kdc2014_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Meso gao gafumbigwe sekewadahe kulola, migongo yao iveduke mbuli ya kugaya siku zose.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Nouza kabili, vino Wayahudi viwaikwalile na kugwa hawenuke kabili? Bule haili avo, kwavija Wayahudi watenda nzambi, wanhu haweli Wayahudi wakomboligwa, avo Wayahudi wowonela migongo. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Nzambi za Wayahudi zigala vinhu vingi vinogile kwa wanhu wa mwiisi, na kulemelwa kwa Wayahudi kugala vinhu vingi vinogile kwa wanhu haweli Wayahudi. Avo kamba Wayahudi wahasang'hana goyolonda Mulungu wogala vinhu vingi ng'hani vinogile. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Sambi nolonga na mweye wanhu hamwili Wayahudi, kwavija niye na mtumigwa wa wanhu haweli Wayahudi, noigodela sang'hano yangu. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Nogesa nodaha kuwatenda Wayahudi wayangu wawonele migongo mweye, avo ndahe kuwakombola wayagwe wao. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kwavija Wayahudi viwalemigwe, wanhu wose wa mwiisi wailumba na Mulungu. Sambi yokuwaze kamba wahatogoligwa? Wanhu wafile wozilibuka! ");
INSERT INTO kdc2014_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kamba kihande cha ichanduso cha gate kilavigwa kwa Mulungu, avo gate jose dilavigwa kwa Mulungu, na kamba mzizi wa mbiki ulavigwa kwa Mulungu, vivija na matambi gake galavigwa kwa Mulungu. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Kamba matambi gayagwe ga mzeituni wamumgunda gakanhigwa na tambi da mzeituni wa kumuhulo diombekigwa, avo mweye wanhu hamwili Wayahudi wao tambi da mzeituni wa kumuhulo. Sambi momweda kwa kupata vinhu vingi vinogile kulawa kwa Wayahudi. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Avo sekemuwabeze waja wose wakanhigwe kamba matambi, moigodela choni? Mweye mwa matambi, hamuigogeleza mizizi, ila mizizi yowagogeleza mweye. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Lakini molonga, “Matambi gakanhigwa muladi niye niombekigwe mmwake.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ona molonga. Wakanhigwa kwavija hawatogole, mweye musola hanhu hao kwavija mutogola. Lakini sekemuigodele mbuli ayo, ila dumbeni. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kamba Mulungu kagakanha matambi gakalile hanhu hake, vino viugesa kokonela bazi gweye? ");
INSERT INTO kdc2014_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Loleni Mulungu viyeli na bazi na viyeliduhu mwangalo. Mulungu kaduhu mwangalo kwa waja watendile nzambi, lakini kokonela bazi kamba wahagendelela kutamanila bazi jake. Wahaleka kutenda avo vivija kokanhigwa. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Wayahudi wahaleka kulema kutogola kwao, woombekigwa kabili, kwavija Mulungu kodaha kuwaombeka kabili. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mweye wanhu hamwili Wayahudi mukanhigwa kulawa mumzeituni wa kumuhulo na muombekigwa mumzeituni wa mumgunda, hanhu haheli henu, avo vibuha ng'hani kwa Mulungu kugaombeka matambi gakanhigwe mumbiki wao wenyego. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ndugu zangu, nolonda muijuwe mbuli ino ifisigwe, muladi sekemuyone mwa wabala ng'hani, Wayahudi hawamtegeleze Mulungu kwa kipindi kidodo, mbaka wanhu haweli Wayahudi walondeke kumbwelela Mulungu wenele. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Wanhu wose wa Izilaeli wokomboligwa, kamba vigalonga Maandiko Gang'alile, “Mkombola kokwiza kulawa Sayuni kowatenda wanhu wa lukolo lwa Yakobo waleke nzambi zao. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Vino vivo vonda niilagane nao, nahasegeza nzambi zao.” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwavija Wayahudi wailema Mbuli Inogile, waihila na Mulungu mbuli ya mweye wanhu hamwili Wayahudi. Lakini kwavija wasaguligwa, wang'hali wonogeligwa na Mulungu mbuli ya wahenga zao. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kwavija Mulungu yahamsagula munhu na kumgwaa nhunza, hagesa habali yatendile vivo. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Baho umwaka mweye wanhu hamwili Wayahudi hamumtegeleze Mulungu, lakini sambi Mulungu kowonela bazi kwavija Wayahudi waleka kumtegeleza. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Vivo ili, kwavija Mulungu kawonela bazi mweye, na sambi Wayahudi nao hawamtegeleza Mulungu, muladi na wao vivija Mulungu yawonele bazi. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwavija Mulungu kawagodeka wanhu wose sekewamtegeleze muladi yawonele bazi wanhu wose. ");
INSERT INTO kdc2014_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Loleni Mulungu viyanogile! Mulungu mbala ng'hani na kana nzewele ng'hani! Nani yodaha kugasimulila gaja goyolonda kusang'hana? Nani yodaha kuzijuwa nzila zake? ");
INSERT INTO kdc2014_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kamba vigalonga Maandiko Gang'alile, “Nani yazijuwile nzewele za Mndewa? Nani yodaha kumgwaa magesa? ");
INSERT INTO kdc2014_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Nani yasongile kumgwaa kinhu Mulungu, ili Mulungu yambwelezele?” ");
INSERT INTO kdc2014_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwavija vinhu vose viumbigwa na Mulungu, na vose vabaho kubitila Mulungu na vabaho mbuli yake. Mulungu yagweleligwe ukulu siku zose! Ona. ");
INSERT INTO kdc2014_vpl V