﻿USE sofia;
DROP TABLE IF EXISTS sofia.kca_vpl;
CREATE TABLE kca_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kca_vpl WRITE;
INSERT INTO kca_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Оԓәӈән Турәм турәм пӑ мўв тыйәԓтәс. ");
INSERT INTO kca_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Мўв ватԓы-хŏрԓы пӑ таԓ ус, пӑтыԓы йиӈкәӈ тӑха нўмпийән пӑтлам ус, Турәм Ԓыԓәԓ йик нўмпийән йӑӈхәс. ");
INSERT INTO kca_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Турәм йастәс: «Нŏвийа ат йиԓ». Пӑ нŏвийа йис. ");
INSERT INTO kca_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Щӑԓта Турәм шийаԓәсԓы, нŏви щит йӑм, пӑ пӑтлам эԓты нŏви атэԓт ўсԓы. ");
INSERT INTO kca_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Турәм нŏви хӑтԓа нэмәтсәԓы, пӑтлам пӑ ата нэмәтсәԓы. Йэтән ус пӑ аԓәӈсӑхат ус: оԓәӈ хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Турәм йастәс: «Йик кўтән турәм ԓŏӈәԓ ат питәԓ, йиӈкәт атэԓт ат ўԓԓы». ");
INSERT INTO kca_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Турәм турәм ԓŏӈәԓ тыйәԓтәс, нўм йиӈкәт иԓта йиӈкәт эԓты атэԓт ўсԓы. Пӑ щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Турәм щи турәм ԓŏӈәԓ турәм хӑра нэмәтсәԓы. Йэтән ус пӑ аԓәӈсӑхат ус: кимет хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Турәм йастәс: «Турәм иԓпийән йиӈкәт и тӑхайа ат ӑктәщԓәт пӑ сорәм тӑха ат этәԓ». Пӑ щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Сорәм тӑха Турәм мўва нэмәтсәԓы, йӑха ӑктәм йиӈкәт щарса нэмәтсәԓы. Турәм шийаԓәсԓы, щит йӑм. ");
INSERT INTO kca_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Турәм йастәс: «Мўв вŏсты тŏрнәт пӑ йўхәт ат энмәԓәԓ, тŏрнәт энәмты сэмәт ат тӑйԓәт пӑ ԓэвпәсәӈ йўхәт, кашәӈ йўх энмәԓтәм ԓэвпәсԓаԓән нохәр сэм ԓўв сырәԓ щирән мўвән ат тӑйәԓ». Пӑ щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Мўв вŏсты тŏрнәт пӑ ԓэвпәсәӈ йўхәт энмәԓтәс: кашәӈ тŏрән тŏрән сэмԓаԓ пиԓән ԓўв сырәԓ щирән; пӑ йўхәт, кашәӈ йўх энмәԓтәм нохәр сэмәӈ ԓэвпәс ԓўв сырәԓ щирән тӑйәс. Турәм шийаԓәсԓы, щит йӑм. ");
INSERT INTO kca_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Йэтән ус пӑ аԓәӈсӑхат ус: хуԓмет хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Щӑԓта Турәм йастәс: «Турәм хӑрән хутԓәты ŏтәт ат питԓәт, ат пӑ хӑтәԓ ԓэра уйәтты урәӈән, пӑ щӑԓта поса ат уԓԓәт: йисәт, тӑԓәт, хӑтԓәт ԓэрапты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Пӑ турәм хӑрән хутԓәптәты ŏтәта ат питԓәт, мўв хутԓәптәты урәӈән». Пӑ щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Турәм кӑт вŏԓаӈ хутԓәптәты ŏтӈән тыйәԓтәс: уншәк ŏт хӑтәԓән ԓойты урәӈән, айшәк ŏт атән ԓойты урәӈән, пӑ хусәт тыйәԓтәс; ");
INSERT INTO kca_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Турәм щи ŏтәт турәм хӑра ԓэщатсәԓы, мўв хутԓәптәты, ");
INSERT INTO kca_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","пӑ ат пӑ хӑтәԓ мŏрт пŏрайән пайтыԓыты, пӑ нŏви пӑ пӑтлам кӑтна тӑйты урәӈән. Турәм шийаԓәсԓы, щит йӑм. ");
INSERT INTO kca_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Йэтән ус пӑ аԓәӈсӑхат ус: ԋӑԓмет хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Турәм йастәс: «Кӑмән хŏрпи ваӈкәтԓыты, ущиԓыты вой тащ йик ат тыйәԓтәԓ, пӑ мўв нўмпийән, турәм хӑр хўват тŏхԓәӈ войәт ат йӑхԓәт». ");
INSERT INTO kca_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Турәм ун хўԓ шикет пӑ ар сыр ваӈкәтԓыты, ущиԓыты йикән вŏшиты арат ԓыԓәӈ ŏт пӑ ар сыр тŏхԓәӈ вой тыйәԓтәс. Турәм шийаԓәсԓы, щит йӑм. ");
INSERT INTO kca_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Турәм ԓывиԓаԓ йӑмән мӑсԓы, пŏтәртман: «Пŏшхащаты, ара йўваты, щарсәтән йиӈкәт тэкнәптаԓән, тŏхԓәӈ войәт мўв хŏща па ара ат йиԓәт». ");
INSERT INTO kca_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Йэтән ус пӑ аԓәӈсӑхат ус: ветмет хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Турәм йастәс: «Ԓыԓәӈ ŏтәт сырԓаԓ щирән мўв ат тыйәԓтәԓ: йош войәт, ут войәт, ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт хŏԓ сырԓаԓ щирән». Пӑ щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ут войәт сырԓаԓ щирән, йош войәт сырԓаԓ щирән, ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт сырԓаԓ щирән Турәм тыйәԓтәс. Турәм шийаԓәсԓы, щит йӑм. ");
INSERT INTO kca_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Турәм йастәс: «Мўӈ хŏрасэв пӑ Мўӈ хŏрпев хŏйат тыйәԓтԓув. Пӑ щӑԓта щарәс хўԓәт нўмпийән, тŏхԓәӈ войәт нўмпийән, йош войәт нўмпийән, омәсты мўв нўмпийән, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт нўмпийән кущайа ԓўв ат уԓ». ");
INSERT INTO kca_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Турәм хŏйат Ԓўв хŏрасәԓ щира, Турәм хŏрас щира, тыйәԓтсәԓы; йох хŏйат пӑ нэ хŏйат тыйәԓтәс. ");
INSERT INTO kca_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Турәм ԓынан йӑмән мӑсԓы пӑ Турәм ԓынана йастәс: «Пŏшхащатән, ара йўваты, мўв тэкнәптаԓән, мўв ԓŏватән кущайа уԓаты, пӑ щарәс хўԓәт, пӑ тŏхԓәӈ войәт нўмпийән, пӑ мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт нўмпийән кущайа уԓатән». ");
INSERT INTO kca_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Турәм йастәс: «Тӑта щи, мўв ԓŏватән энәмты кӑмән хŏрпи ԓат сэмәӈ тŏрән пӑ кӑмән хŏрпи ԓэвпәсәӈ йўх, мўва йŏвәԓты нохәр сэмԓаԓ пиԓән Ма нынана мӑсәм: щит нынана ԓэтŏта питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ут войәта, тŏхԓәӈ войәта пӑ ар сыр ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәта – хŏԓ ԓыԓәӈ войәта энәмты тŏрнәт, лыптәт ԓэтŏта Ма мӑсәм». Щиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Щӑԓта Турәм ватсәԓы, мўй Ԓўв тыйәԓтәс пӑ щит шек йӑм. Йэтән ус пӑ аԓәӈсӑхат ус: хутмет хӑтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Щиты турәм пӑ мўв опсантәм щир йэтшәс, турәмән пӑ мўвән уԓты ŏтәт тыйәԓтты вер йэтшәс. ");
INSERT INTO kca_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ԓапәтмет хӑтәԓ унты Турәм Ԓўв верәм верԓаԓ йэтшәптәсԓы, щӑԓта ԓапәтмет хӑтәԓән Ԓўв верәм верԓаԓ эԓты щўтщәс. ");
INSERT INTO kca_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ԓапәтмет хӑтәԓ Турәм йӑмән мӑсԓы, йэмәӈа версәԓы, щи хӑтәԓән Ԓўв тыйәԓтәм пӑ йэтшәптәм верԓаԓ эԓты щўтщәс. ");
INSERT INTO kca_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Тӑм турәм пӑ мўв опсантәм щир, тыйәԓтәм щир. Турәм Куща мўв пӑ турәм тыйәԓтмаԓән, ");
INSERT INTO kca_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","кӑмән хŏрпи хӑр мўв варәс пӑ кӑмән хŏрпи хӑр мўв тŏрән хŏԓна ӑт энмәс, Турәм Куща мўва йэрт хŏԓна ӑт китыԓыйәс, пӑ мўв хӑр ԓэщатты хŏйат ӑнтом ус, щишән. ");
INSERT INTO kca_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Туп мўв эԓты шив нŏх этԓыйәс пӑ мўв сŏх аратәԓ иса посмәԓтысԓы. ");
INSERT INTO kca_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Щӑԓта Турәм Куща мўв хиш эԓты хŏйат тыйәԓтәс пӑ ԋŏԓ ўсәԓа уԓты ԓыԓән пŏԓәтсәԓы, пӑ хŏйат ԓыԓәӈа йис. ");
INSERT INTO kca_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Щӑԓта Турәм Куща хӑԓэвәт пеләк мўвән, Едэмән, ар сыр йўхәт опсәс, щи ŏйәӈ-щўԋәӈ тӑхайән тыйәԓтәм хŏйатәԓ уԓты хӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Турәм Куща ар хŏрпи йўхәт умәщԓыты кеша пӑ йӑм ԓэвпәс урәӈән энмәԓтәс, пӑ щӑԓта, щи ŏйәӈ-щўԋәӈ тӑха кўтәпән уԓәпса йўх энмәԓтәс пӑ йӑм пӑ атәм ŏша пайәтты щир тӑйты йўх щита энмәԓтәс. ");
INSERT INTO kca_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ŏйәӈ-щўԋәӈ тӑха йикән пŏшәԓтәты урәӈән, Едэм мўв эԓты йŏхан ŏвәс, йэԓԓы щи йŏхан лакки ԋӑԓ йŏхана йохарщийәс. ");
INSERT INTO kca_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Йитәԓ нэмәԓ Фисон: ԓўв Хавила мўв керәтман ŏвәԓ, щита, хŏта сорԋи уԓ, ");
INSERT INTO kca_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","сорԋи щи мўвән йӑм; хŏԓна щита эпԓәӈ ух пӑ оникс кев уԓ. ");
INSERT INTO kca_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Кимет йŏхан Гихон: Куш мўв керәтман ԓўв ŏвәԓ. ");
INSERT INTO kca_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Хуԓмет йŏхан Хиддекель: Ассирия мўв йэԓпийән ԓўв ŏвәԓ. Ԋӑԓмет йŏхан Евфрат. ");
INSERT INTO kca_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Турәм Куща хŏйат ўсԓы, пӑ Едэм ŏйәӈ-щўԋәӈ тӑхайән ԓўвеԓ уԓты хӑйсәԓы, щи мўвән мŏԓты энмәԓты пӑ шавиты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Турәм Куща хŏйата партәс, щиты йастәман: «Тӑм ŏйәӈ-щўԋәӈ тӑхайән кашәӈ йўх эԓты нӑӈ ԓэты верәтԓән, ");
INSERT INTO kca_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","туп йӑм пӑ атәм ŏша пайәтты йўх эԓты аԓ ԓэва, щи хӑтәԓ, хун щи йўх эԓты мŏԓты ԓэԓән ки, нӑӈ хӑԓԓән». ");
INSERT INTO kca_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Щӑԓта Турәм Куща йастәс: «Хŏйата утща уԓты атәм, ԓўвеԓа ԋотты ԓўв хŏрпеԓ пиԓ тыйәԓтԓув». ");
INSERT INTO kca_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Мўв хиш эԓты Турәм Куща хŏԓ ут войәт тыйәԓтсәԓы, хŏԓ тŏхԓәӈ войәт тыйәԓтсәԓы, щӑԓта ԓывиԓаԓ хŏԓ хŏйат хŏща тусԓы, ваттыйа, хŏты хŏйатән нэмәтԓайәт; хŏты хŏйатән кашәӈ ԓыԓәӈ ŏт нэмәтԓа, щиты нэмәԓ ат питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Щӑԓта хŏйат кашәӈ шŏши войа, тŏхԓәӈ войа, ут войа нэм мӑс; туп хŏйата ԓўвеԓа ԋотты ԓўв хŏрпеԓ пиԓ ӑт ԉикмәс. ");
INSERT INTO kca_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Щӑԓта Турәм Куща хŏйат так оԓма пайәтсәԓы; хун ԓўв вŏйәпса, и хŏнлŏхәԓ нŏх ўсԓы, щи лот ԋŏхеԓән лӑп пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Щӑԓта Турәм Куща хŏйат эԓты ўйәм хŏнлŏхәԓ эԓты нэ хŏйат тыйәԓтәс, пӑ ԓўвеԓ хŏйат хŏща тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Щӑԓта хŏйат йастәс: «Тӑта щи, тӑм ԓŏв ма ԓŏвԓам эԓты пӑ тӑм ԋŏхи ма ԋŏхем эԓты; ԓўв имийа нэмәтты питԓа: икеԓ эԓты ўйман уԓԓа». ");
INSERT INTO kca_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Щишән, йох хŏйат ԓўв ащеԓ пӑ ԓўв аԋԏэԓ хӑйԓәԓы пӑ ԓын ита йиԓтән. ");
INSERT INTO kca_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Адам пӑ ԓўв имеԓ кинтак ԋар эԓән усӈән, ԓын ӑт йэԓамтысӈән. ");
INSERT INTO kca_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Турәм Куща тыйәԓтәм ут войәт эԓты ŏхты вой мет ŏщмарәӈ ус. Ԓўв нэ пеԓа йастәс: «Турәм мўй йӑна йастәс: ‘Тӑм ŏйәӈ-щўԋәӈ тӑхайән нэмәԓты йўх эԓты аԓ ԓэватән?’» ");
INSERT INTO kca_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ŏхты войа нэ йастәс: «Мин йўхәтән энмәм ԓэвпәсәт ԓэты верәтԓәмән, ");
INSERT INTO kca_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","туп Турәм щиты йастәс: ‘Ŏйәӈ-щўԋәӈ тӑха кўтәпән энәмты йўх эԓты ԓэвпәсәт аԓ ԓэватән пӑ аԓ кетмаԓән, нынана ӑт пӑрты урәӈән’». ");
INSERT INTO kca_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ŏхты вой нэӈа йастәс: «Ӑнта, ӑт пӑрԓәтән, ");
INSERT INTO kca_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Турәм уйәтԓәԓы, щи хӑтәԓән, хун нын щиԓта ԓэԓтән, нын ŏшән йŏхәтԓайтән, щӑԓта Турәм иты йӑм пӑ атәм уйәтты питԓәтән». ");
INSERT INTO kca_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Щитәԓән нэ шийаԓәсԓы, щи йўх сэмән ватты умәщ пӑ ԓэвпәсәԓ йӑм хŏрпи, пӑ щӑԓта йўхәԓ мосәԓ, ŏшәӈ нŏмәс мӑԓ, щишән; щикәԋща, энмәм ԓэвпәс ԓўв ўс пӑ ԓэс; пӑ ԓэвпәс икеԓа па мӑсԓы, ԓўв па ԓэс. ");
INSERT INTO kca_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Щӑԓта ԓын ŏшән йŏхәтсайтән, пӑ ԋарԓŏмәԓты уԓты верән веԓщи мŏштәсԓән, пӑ смоква йўх лыптәт эԓты эԓ сайԓәты ӑнтәпӈән версәтән. ");
INSERT INTO kca_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Щӑԓта Турәм Куща сый хуԓтмәстән, хŏты Ԓўв щи ŏйәӈ-щўԋәӈ тӑхайән хӑтәԓ йоләх сӑмән шушиԓыйәс; Адам нэӈәԓ пиԓән Турәм Куща эԓты йўхәт кўтән хӑԋэмәстән. ");
INSERT INTO kca_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Турәм Куща пӑ Адам ўваԓсәԓы пӑ йастәс: «Нӑӈ хŏта?» ");
INSERT INTO kca_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ԓўв йастәс: «Ŏйәӈ-щўԋәӈ тӑхайән Нӑӈ шушиԓыты сыйэн ма хуԓтсэм, пӑ пӑԓтамәсәм ԋарԓŏмәԓты уԓмем урәӈән, щишән хӑԋэмәсәм». ");
INSERT INTO kca_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Турәм иԋщәссәԓы: «Хŏй нӑӈена йастәс нӑӈ ԋарԓŏмәԓты уԓты верэн? Аԓт пӑ нӑӈ щи йўх эԓты ԓэсән, хŏԓща Ма нӑӈена ԓэты ӑт эсәԓсэм?» ");
INSERT INTO kca_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Адам йŏхԓы йастәс: «Нэӈән, Нӑӈ мӑнэма мийәм нэӈенән, щи йўх эԓты мӑсайәм, пӑ ма ԓэсәм». ");
INSERT INTO kca_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Щӑԓта Турәм Куща нэӈа йастәс: «Мўйа нӑӈ щиты версэн?» Нэ йастәс: «Ŏхты вой мӑнэм ԓэпәԓсәԓы, щишән ма ԓэсәм». ");
INSERT INTO kca_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Щӑԓта Турәм Куща ŏхты войа йастәс: «Щит вермен урәӈән, мўԓман уԓты питԓән йош войәт пӑ ут войәт кўтән, тӑԓта йэԓԓы хŏн пӑтэнән хӑтыԓыты нӑӈ питԓән пӑ уԓтэн хўват мўв хиш ԓэты питԓән; ");
INSERT INTO kca_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","пӑ щӑԓта нӑӈ пӑ нэ, нын кўтәнән атмащ уԓты щир верԓәм, нӑӈ энмәԓты ŏтԓан пӑ ԓўв энмәԓты ŏтԓаԓ кўтән йэԓԓы ищи атмащ уԓты щир пŏнԓәм; хŏйат нӑӈен ŏхен эԓты веԓты питԓәԓы, нӑӈ пӑ ԓўвеԓ кўр йŏтԓаӈ эԓты пŏрэмәԓэн». ");
INSERT INTO kca_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Нэӈа йастәс: «Ԓавәртат уԓтэнән кӑшиԓан шек ара верԓәԓам; муш пиԓән ԋаврэм тӑйты питԓән; нӑӈ икен нӑӈен мосты питәԓ, ԓўв пӑ нӑӈ кущайэн питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Адама пӑ йастәс: «Нэӈен йасӈа хуԓәтмен урәӈән пӑ щи йўх эԓты ԓэвмен урәӈән, хŏԓща Ма нӑӈена ԓэты ӑт эсәԓсэм, щи йастыԓысәм: ‘Щиԓта аԓ ԓэва’, тӑԓта йэԓԓы нӑӈ урӈенән мўв мўԓман уԓты питәԓ; уԓтэн хўват шукащман мўв эԓты ԓэтŏт мŏщатты питԓән; ");
INSERT INTO kca_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","пеԓантыты тŏрнәт нӑӈена мўв энмәԓтәԓ, мўв хӑрән энәмты тŏрнәт эԓты ԓэты питԓән; ");
INSERT INTO kca_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","шӑк йик кўтән ԋаԋэн ԓэты питԓэн, мўва иԓ питтэн унты, хŏԓща нӑӈ ўйман уԓԓән, нӑӈ мўв хиш пӑ мўв хиша па йиԓән». ");
INSERT INTO kca_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Адам имеԓ нэмән мӑсԓы: Ева, ԓўв хŏԓ уԓты хŏйатәт аԋԏийа йис. ");
INSERT INTO kca_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Турәм Куща Адама пӑ ԓўв имеԓа ԓумәтты сŏхәт ԋўки эԓты верәс пӑ ԓынан ԓумәттәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Турәм Куща йастәс: «Тӑта щи, хŏйат Мўӈ итэва йис, йӑм пӑ атәм уйәтты питәс, щишән, ӑт рӑхәԓ ԓўвеԓ щиты йэԓ эсәԓты, хŏԓна уԓәпса йўх эԓты ԓэвпәс ўты верәтәԓ, щиԓта ԓэԓ ки, веккеша уԓты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Щишән, Турәм Кущайән Едэм ŏйәӈ-щўԋәӈ тӑха эԓты ԓўв воштәса, мўвән ат рупитәԓ, хŏԓща ԓўв тыйәԓтса. ");
INSERT INTO kca_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Щиты хŏйат воштәсԓы, пӑ Едэм ŏйәӈ-щўԋәӈ тӑха пўӈәԓән хӑтәԓ этты пеләк сӑхат херувим ŏт пӑ щӑԓта ԓӑрыты тўтәӈ аԓтты кеши, уԓәпса йўх хŏща мӑнты йуш шавиты урәӈән ԓощәԓтәс. ");
INSERT INTO kca_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Адам Ева пиԓән устән, щӑԓта нэӈәԓ Каин нэмпи пŏх тӑйәс, пӑ йастәс: «Турәм Кущайән ԋаврэмән партсайәм». ");
INSERT INTO kca_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Щӑԓта пӑ ху апщеԓ сэма питәс, Авель. Авель ош тащәт шавийәс, Каин пӑ мўв хӑрән рупитәс. ");
INSERT INTO kca_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Мŏԓты кўт хӑщәман, Каин энмәԓтәм лэвпәсԓаԓ эԓты Турәм Кущайа мойԓәпса тус, ");
INSERT INTO kca_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Авель ищи, мет оԓәӈ пўш опсәм войԓаԓ пӑ щи войԓаԓ вŏй мойԓәпсайа тусԓы. Турәм Куща Авель пеԓа пӑ ԓўв мойԓәпсайԓаԓ пеԓа йӑм сэмән вантәс, ");
INSERT INTO kca_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Каин пеԓа пӑ ԓўв мойԓәпсайԓаԓ пеԓа йӑм сэмән ӑт вантәс. Каин ԉикән йŏхәтса пӑ вешәԓ ԉик эԓты питыйа йис. ");
INSERT INTO kca_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Щӑԓта Турәм Куща Каина йастәс: «Мўйа нӑӈ ԉикән йŏхәтсайән? Мўйа веншен па хŏрпийа йис? ");
INSERT INTO kca_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Йӑм верԓән ки, вещкат вешән ватԓән. Атәм верԓән ки, ов пўӈԓэнән кӑрэк ŏԓәԓ, ԓўв нӑӈен кӑлщәԓтԓәԓы, нӑӈ пӑ ԓўв нўмпеԓән йурәӈа уԓа». ");
INSERT INTO kca_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Щӑԓта Каин Авель апщеԓ пиԓән потәртәс. Мўв хӑрән уԓманән, Каин Авель апщеԓ хŏща щӑкәс пӑ ԓўвеԓ веԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Щӑԓта Турәм Куща Каин иԋщәссәԓы: «Авель апщен хŏта?» Ԓўв йастәс: «Ӑт уйәтԓэм: ма ԓўвеԓ ватман хун уԓԓәм?» ");
INSERT INTO kca_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Щӑԓта Турәм Куща йастәс: «Мўй нӑӈ версән? Апщен ўр ўвты сый Мӑнэма мўв эԓты щащәԓ; ");
INSERT INTO kca_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ин нӑӈ мўԓтсайән, мўвен эԓты воштысайән, мўв пелки лоӈхиԓәс, нӑӈ йошенән мӑнәԓтәм апщен кӑԓы ўты урәӈән; ");
INSERT INTO kca_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","тӑԓта йэԓԓы мўв хӑрән рупиттэнән, ԓўв нӑӈ урӈенән йур ӑт мӑԓ; нӑӈ мўв ԓŏватән шŏшиԓы-хотԓы хŏйата питԓән». ");
INSERT INTO kca_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Щӑԓта Турәм Кущайа Каин йастәс: «Мӑнэма щи мўԓтәм верэн шек ԓавәрт, ма ӑт верәмԓэм; ");
INSERT INTO kca_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ин Нӑӈ мӑнэм ма мўвем эԓты ԋухәԓԓэн, пӑ Нӑӈ эԓтэн па хӑԋэмәԓәм, шŏшиԓы-хотԓыйа уԓты питԓәм; пӑ йэщаԓт йŏхәтты оԓәӈ ŏтән ма щи веԓԓайәм». ");
INSERT INTO kca_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Щӑԓта Турәм Куща ԓўвеԓа йастәс: «Каин веԓты ŏта, ԓапәт пўш нўра уԓа». Щӑԓта Турәм Куща Каина щимәщ пос ԓэщатәс, щӑха уйтантыты ŏтәтән ԓуԓән ӑт ат веԓса. ");
INSERT INTO kca_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Щӑԓта Турәм Куща эԓты Каин мӑнәс пӑ Едэм эԓты хӑтәԓ этты пеләкән Нод мўвән уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Каин имеԓ пиԓән устән; имеԓ Енох нэмпи пŏх тӑйәс. Пӑ щӑԓта Каин вош опсәс, вошәԓ пŏхәԓ нэмән пŏтсәԓы: Енох. ");
INSERT INTO kca_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Енох Ирад пŏх тӑйәс; Ирад Мехиаель пŏх тӑйәс; Мехиаель Мафусал пŏх тӑйәс; Мафусал пӑ Ламех пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ламех кӑт нэ ўйԓыйәс: йитәԓ нэм Ада, кимет нэӈәԓ нэм Цилла. ");
INSERT INTO kca_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ада Иавал пŏх тӑйәс: ԓўв эԓтэԓ пирщин хотәтән уԓты пӑ вой тащәт шавиты хŏйатәт йэԓԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ԓўв ху апщеԓ нэмәԓ Иувал ус: ԓўв эԓтэԓ нарәс йўхән пӑ тŏмранән йŏтты хŏйатәт йэԓԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Цилла пӑ Тувалкаин тӑйәс, ԓўв пӑтәр ŏх пӑ карты эԓты ар сыр пŏрмасәт верәс. Тувалкаин Ноема нэмпи нэ апщи тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Щӑԓта Ламех имеӈәԓԓаԓа йастәс: «Ада пӑ Цилла! Ма пŏтрэм хуԓәнтатән; Ламех имеӈән! Ма йасәӈԓам хуԓәнтатән: ху хŏйат мӑнэм мушмәԓтмаԓ урәӈән ма веԓсэм пӑ айԓат хŏйат мӑнэм хӑтщәмаԓ урәӈән ма веԓсэм. ");
INSERT INTO kca_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Каин урәӈән ԓапәт пўш нўра ўԓа, Ламех урәӈән ԓапәтйаӈ пўш ԓапәт нўра ўԓа». ");
INSERT INTO kca_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Щӑԓта Адам имеԓ хŏԓна пŏх тӑйәс, Сиф нэмән мӑсԓы, пŏтәрман: «Каинән веԓәм Авель йўкана Турәм мӑнэма ԋаврэм па мӑс». ");
INSERT INTO kca_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Сиф ищи пŏх тӑйәс, Енос нэмән мӑсԓы; щи йис эԓты Турәм Куща пеԓа пойәкщәты питса. ");
INSERT INTO kca_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Тӑм Адам и рут хŏйатәт: Турәм, хŏйат тыйәԓтмаԓән, Турәм Ԓўв хŏрпеԓа ԓўвеԓ тыйәԓтсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","йох хŏйат пӑ нэ хŏйат тыйәԓтәс, пӑ ԓынан йӑмән мӑсԓы, пӑ щӑԓта ԓынан тыйәԓтәм хӑтәԓән ‘хŏйат’ нэмән ԓынан мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Адам, нуптәԓ сот хŏԉмаӈ тӑԓ уԓмаԓән, ԓўв хŏрпеԓ пӑ ԓўв хŏраспеԓ пŏх тӑйәс, пӑ Сиф нэмән ԓўвеԓ мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Сиф сэма питәм йўпийән Адам хŏԓна нийәԓсот тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Иуԓтыйа Адам нуптәԓ йӑрәтйаӈсот хŏԉмаӈ тӑԓ ус; щӑԓта ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Сиф, нуптәԓ сот вет тӑԓ уԓмаԓән, Енос пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Енос сэма питәм йўпийән, Сиф хŏԓна нийәԓсот ԓапәт тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Иуԓтыйа Сиф нуптәԓ йӑрәтйаӈсот кӑтхŏщйаӈ тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Енос, нуптәԓ йӑрсот тӑԓ уԓмаԓән, Каинан пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Каинан сэма питәм йўпийән, Енос хŏԓна нийәԓсот ветхŏщйаӈ тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Енос нуптәԓ йӑрәтйаӈсот вет тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Каинан, нуптәԓ ԓапәтйаӈ тӑԓ уԓмаԓән, Малелеил пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Малелеил сэма питәм йўпийән, Каинан хŏԓна нийәԓсот ԋӑԓйаӈ тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Каинан нуптәԓ йӑрәтйаӈсот йаӈ тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Малелеил, нуптәԓ хутйаӈ вет тӑԓ уԓмаԓән, Иаред пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Иаред сэма питәм йўпийән, Малелеил хŏԓна нийәԓсот хŏԉмаӈ тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Малелеил йӑрәтйаӈсот тӑԓ унты вет тӑԓәԓ ӑт усԓы; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Иаред, нуптәԓ сот хутйаӈ кӑт тӑԓ уԓмаԓән, Енох пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Енох сэма питәм йўпийән, Иаред нийәԓсот тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Иаред нуптәԓ йӑрәтйаӈсот хутйаӈ кӑт тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Енох, хутйаӈ вет тӑԓ уԓмаԓән, Мафусал пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Мафусал сэма питәм йўпийән, Енох хуԓәмсот тӑԓ Турәм пиԓән ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Иуԓтыйа Енох хуԓәмсот хутйаӈ вет тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Енох Турәм пиԓән ус; щӑԓта ӑнтома йис, ԓўв Турәмән уса. ");
INSERT INTO kca_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Мафусал, нуптәԓ сот нийәԓйаӈ ԓапәт тӑԓ уԓмаԓән, Ламех пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ламех сэма питәм йўпийән, Мафусал ԓапәтсот нийәԓйаӈ кӑт тӑԓ ус, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Мафусал нуптәԓ йӑрәтйаӈсот ԓапәтйаӈ пеԓа йӑрәтйаӈ тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ламех, нуптәԓ сот нийәԓйаӈ кӑт тӑԓ уԓмаԓән, пŏх тӑйәс, ");
INSERT INTO kca_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ной нэмән ԓўвеԓ мӑсԓы пӑ йастәс: «Турәм Кущайән мўԓәм мўвевән ԓавәрт рупатайэвән тӑм пŏх мўӈев торапԓәԓԓы». ");
INSERT INTO kca_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ной сэма питәм йўпийән, Ламех хутсот тӑԓ унты вет тӑԓәԓ ӑт усԓы, пӑ эвет-пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ламех нуптәԓ ԓапәтсот ԓапәтйаӈ ԓапәт тӑԓ ус; пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Нойа ветсот тӑԓ ус, хун ԓўв хŏщайәԓ сэма питсәт: Сим, Хам пӑ Иафет. ");
INSERT INTO kca_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Мўвән хŏйатәт ара йисәт пӑ ԓыв хŏщайэԓ эвет сэма питсәт, ");
INSERT INTO kca_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","пӑ Турәм пŏхәтән хŏйат рут эвет кащаԓәсайәт, мўй хŏрпи ԓыв хŏрасәӈәт, пӑ хŏй ԓывиԓаԓа рӑхәс, нэӈа ўты питсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Щӑԓта Турәм Куща йастәс: «Ма ԓыԓэм век хун хŏйатәт хŏща уԓ, хŏйатәт пӑрԓәт, нупәтԓаԓ сот хус тӑԓ ат уԓ». ");
INSERT INTO kca_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Щи пŏрайән мўвән пӑԓатәӈ-ԓŏватәӈ хŏйат шикет усәт, метшопәӈ щи пŏра эԓты, хŏты Турәм пŏхәт хŏйат эвет хŏща ԓŏӈтыты питсәт, пӑ ԋаврэмәт ԓыв эԓтыԓаԓ тӑйты питсәт: щит йис тэԓән щащәм йурәӈ уртәт. ");
INSERT INTO kca_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Щӑԓта Турәм Куща шийаԓәсԓы, мўвән уԓты хŏйатәт ԓыв кўтԓаԓән шек уԉԋайа уԓԓәт, нŏмәсԓаԓ пӑ сӑмԓаԓ иса ԉикәӈәт; ");
INSERT INTO kca_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","хŏйат тыйәԓтмаԓ урәӈән, Турәм Куща нŏпсәԓ шӑкәс пӑ Ԓўв сӑмәԓ кӑшийән тэкәтса. ");
INSERT INTO kca_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Турәм Куща йастәс: «Мўвән уԓты Ма тыйәԓтәм хŏйат рутэм, хŏйатәт эԓты ўйман, йош войәт, ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт, пӑ тŏхԓәӈ войәт унты хŏԓ хŏԓтԓыԓам, ԓывиԓаԓ тыйәԓтмем урәӈән Ма нŏпсэм шӑкәс, щишән». ");
INSERT INTO kca_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Туп Ной пеԓа Турәм Куща йӑм сэмән вантәс. ");
INSERT INTO kca_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Тӑта щи Ной уԓәпса: щи ишән уԓәм хŏйатәт кўтән туп Ной тўӈа-щира ус, атәм ӑт верыԓыйәс; Турәм пиԓән Ной ус. ");
INSERT INTO kca_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ной хуԓәм пŏх тӑйәс: Сим, Хам пӑ Иафет. ");
INSERT INTO kca_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Турәм ватман мўв ўкщәм уԓәпсайән пӑ ԉикәӈ верәтән тэкнәс. ");
INSERT INTO kca_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Турәм шийаԓәсԓы, хŏты мўв шӑкатәм, кашәӈ ԓыԓәӈ ŏт шушты йушәԓ ўкщәма вермаԓ, щишән. ");
INSERT INTO kca_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Щӑԓта Турәм Ной пеԓа йастәс: «Ма кашәӈ ԓыԓәӈ ŏт хŏԓтԓэм, мўв ԓыв эԓтайэԓ ԉикәӈ верәтән тэкнәс; щишән, Ма ԓывиԓаԓ пӑратԓәԓам. ");
INSERT INTO kca_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Гофер йўх эԓты ковчег хоп нӑӈена вера; хопен йӑтәӈа веры, щӑԓта ԓыпеԓ пӑ эԓтэԓ ухән нэры. ");
INSERT INTO kca_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Пӑ щиты веры: хўватәԓән ковчег хоп хуԓәмсот кўш оԓәӈ, ўтатәԓән ветйаӈ кўш оԓәӈ, пӑԓатәԓән хŏԉмаӈ кўш оԓәӈ ат питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ковчег хоп ԓоӈәԓән веры, нумән хот щур пӑԓатәԓ и кўш оԓәӈ ԓŏват ат уԓ; и пелкәԓән ов вера; ԓыпеԓән пӑ, иԓән, кўтәпән пӑ нумән, уԓты йӑт ат тӑйәԓ. ");
INSERT INTO kca_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Пӑ щӑԓта, Ма ун йик мўва партԓәм, турәм иԓпийән уԓты ԓыԓәӈ ŏтәт хŏԓ пӑратты урәӈән; мўвән уԓты ŏтәт хŏԓ пӑрԓәт. ");
INSERT INTO kca_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Туп нӑӈ пиԓэнән Ма йастантәпса верԓәм: щи ковчег хопа нӑӈ ԓŏӈԓән, щӑԓта нӑӈ пŏхԓан, щӑԓта нӑӈ имен, щӑԓта пŏхԓан имет нӑӈ пиԓэнән ԓŏӈԓәт. ");
INSERT INTO kca_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Щӑԓта ковчег хопа хŏԓ войәт эԓты ԓŏӈәԓта, кашәӈ вой сыр эԓты кӑтәнән, нэ вой пӑ ху вой, ԓыв нӑӈ пиԓэнән ԓыԓӈа ат хӑщԓәт. ");
INSERT INTO kca_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tŏхԓәӈ войәт эԓты кашәӈ сыр войӈән, йош войәт эԓты, хŏԓ мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт эԓты кашәӈ сыр войӈән ат уԓԓәӈән. Ԓыв нӑӈ хŏщайэн ԓŏӈԓәт, ԓыԓӈа хӑщты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Нӑӈ пӑ ар сыр ԓэвпәс ўйа, мўй хŏрпи мосәԓ, пӑ нӑӈ хŏщайән сопасԓы; щит нӑӈена пӑ ԓывиԓаԓа ԓэтŏта питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ной иса щиты версәԓы: хŏты Турәм ԓўвеԓа партәс, ԓўв щиты щи версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Щӑԓта Турәм Куща Нойа йастәс: «Нӑӈ пӑ нӑӈ тыхԓэн хŏԓ ковчег хоп ԓыпийа ԓŏӈаты, Ма йэԓпемән тӑм ишән уԓты хŏйатәт кўтән туп нӑӈен вещката ԓўӈәтԓэм. ");
INSERT INTO kca_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Сыстам йош войәт эԓты кашәӈ вой сыр эԓты кӑтәнән ԓапәт пўш ўйа, ху войәт пӑ нэ войәт, ӑнта сыстам йош войәт эԓты кӑтәнән ўйа, ху войәт пӑ нэ войәт, ");
INSERT INTO kca_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","тŏхԓәӈ войәт эԓты ищи кӑтәнән ԓапәт пўш кашәӈ вой сыр эԓты, ху войәт пӑ нэ войәт, йэԓԓы мўв ԓŏватән вой сыр шавиты урәӈән, ");
INSERT INTO kca_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ԓапәт хӑтәԓ хӑщты йўпийән ԋӑԓйаӈ хӑтәԓ пӑ ԋӑԓйаӈ ат Ма мўва йэрт шошәмԓәм; мўвән уԓты ԓыԓәӈ ŏтәт, хŏйтат Ма тыйәԓтсәм, хŏԓ пӑратԓәԓам». ");
INSERT INTO kca_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ной щиты щи верәс, хŏты ԓўвеԓ Турәм Куща партәс. ");
INSERT INTO kca_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ун йик мўва йŏхтәмән, Ной нуптәԓ хутсот тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Щӑԓта Ной пӑ ԓўв пŏхԓаԓ, пӑ ԓўв имеԓ, пӑ пŏхԓаԓ имет ковчег хопа ԓŏксәт ун йик эԓты шаващты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Щӑԓта сыстам йош войәт эԓты, ӑнта сыстам йош войәт эԓты, тŏхԓәӈ войәт эԓты пӑ мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт эԓты ");
INSERT INTO kca_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","кӑтәнән, ху войәт пӑ нэ войәт, Нойа Турәм партәм щирән Ной хŏща ковчег хопа ԓŏксәт. ");
INSERT INTO kca_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ԓапәт хӑтәԓ хӑщәм йўпийән, ун йик мўва йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ной нупәт хутсотмет тӑԓән, кимет тыԓәщән ԓапәтхŏщйаӈмет хӑтәԓән, щи хӑтәԓ пӑтыԓы тӑха йиӈкәт ким шошатсәт пӑ опәԉ овәт пелки пўншатсәт; ");
INSERT INTO kca_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","щӑԓта ԋӑԓйаӈ хӑтәԓ пӑ ԋӑԓйаӈ ат мўва йэрт щошийәс. ");
INSERT INTO kca_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Щи хӑтәԓән щи Ной, щӑԓта Сим, Хам пӑ Иафет – Ной пŏхәт, пӑ ԓўв имеԓ, пӑ пŏхԓаԓ хуԓәм ими ԓыв пиԓԓаԓән ковчег хопа ԓŏксәт. ");
INSERT INTO kca_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ԓывәт пӑ хŏԓ ут войәт ԓыв сырэԓ щирән, йош войәт ԓыв сырэԓ щирән, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт ԓыв сырэԓ щирән пӑ хŏԓ тŏхԓәӈ войәт ԓыв сырэԓ щирән, ");
INSERT INTO kca_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","хŏԓ ԓыԓәӈ ŏтәт кӑтәнән Ной хŏща ковчег хоп ԓыпийа ԓŏксәт; ");
INSERT INTO kca_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ху войәт пӑ нэ войәт ар сыр ŏтәт эԓты, Турәм Нойа партәм щирән ԓŏксәт. Щӑԓта Турәм Куща ов ԓўв йўпеԓән лӑп тухәртсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Щӑԓта ԋӑԓйаӈ хӑтәԓ сыс мўвән йик эптәс, шек ар йиӈка йис пӑ йикән ковчег хоп нŏх хўвәтса, ԓўв мўв нўмпийа нŏх эԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Мўвән йик шек уна йис пӑ ковчег хоп йик сŏх эԓты нопәтса. ");
INSERT INTO kca_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Щи арат ар йиӈка йис пӑ турәм иԓпийән уԓты мет пӑԓ Кевәт йик иԓпийа петсәт; ");
INSERT INTO kca_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ветхŏщйаӈ кўш оԓәӈ пӑԓатән Кевәт йикән лӑп ўсайәт. ");
INSERT INTO kca_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Мўй ԓыԓәӈ ŏт ус пӑ мўвән шушиԓыйәс, иса пӑрсәт – тŏхԓәӈ войәт, йош войәт, ут войәт, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт пӑ хŏйатәт хŏԓ; ");
INSERT INTO kca_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","сорәм мўвән ԓыԓ тӑйәм ŏтәт хŏԓ пӑрсәт. ");
INSERT INTO kca_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Мўв пӑԓатән уԓәм ԓыԓәӈ ŏтәт хŏԓ пӑратсайәт: хŏйатәт эԓт ўйман йош войәт, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт пӑ тŏхԓәӈ войәт унты, мўвән щитәт хŏԓ пӑратсайәт; Ной пӑ ԓўв пиԓәԓән ковчег хоп ԓыпийән уԓәм ŏтԓаԓ туп хӑщсәт. ");
INSERT INTO kca_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Сот ветйаӈ хӑтәԓ мўвән йик и йурәӈа, и йурәӈа йис. ");
INSERT INTO kca_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ной, пӑ ԓўв пиԓәԓән ковчег хопән уԓәм ут войәт пӑ йош войәт Турәм иса нŏмәсән тӑйсәԓы; Турәм мўва вот китәс пӑ йиӈкәт иса вŏԓысәт. ");
INSERT INTO kca_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Мўв пӑтыԓы тӑха йиӈкәт лӑп пентатсәт пӑ йик шошмәм опәԉ овәт тухратсәт пӑ йэрт турәм эԓты сŏхнәс. ");
INSERT INTO kca_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Йик айән-айән мўв эԓты йŏхԓы мӑнты питәс, сот ветйаӈ хӑтәԓ хӑщәм йўпийән йик айа йиты питәс. ");
INSERT INTO kca_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ԓапәтмет тыԓәщ ԓапәтхŏщйаӈмет хӑтәԓән ковчег хоп Арарат Кевәт хŏща иԓ ԓойәс. ");
INSERT INTO kca_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Йаӈмет тыԓәщ унты йик айәԓта сорәс, йаӈмет тыԓәщ оԓәӈ хӑтәԓән Кев тӑйәт этсәт. ");
INSERT INTO kca_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Пӑ ԋӑԓйаӈ хӑтәԓ хӑщәм йўпийән Ной ковчег хопән верәм ишԋэԓ пўшсәԓы ");
INSERT INTO kca_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","пӑ хуләх ким эсәԓсәԓы, щитәԓ пурԓәс, мӑныԓыйәс пӑ йŏхԓы йŏхтыԓыйәс, мўв йик эԓты сорты унты. ");
INSERT INTO kca_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Щӑԓта голубь вой ԓўв ким эсԓәс, ваттыйа, мўвән йик шимԓа йис мўй ӑнта, ");
INSERT INTO kca_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","туп голубь кўр пурәмты сорәм мўв ӑт уйтәс пӑ йŏхԓы Ной хŏща, ковчег хопа йŏхтәс, йик хŏԓна мўв ԓŏватән ус; Ной йошәԓ йэԓ шӑшсәԓы пӑ ԓўвеԓ ўсԓы, пӑ йŏхи ковчег хоп ԓыпийа эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Щӑԓта ԓўв па ԓапәт хӑтәԓ ԓавԓәсәс пӑ голубь ковчег хоп эԓты па ким эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Голубь йэтна пеԓа йŏхԓы йŏхтәс пӑ, ԋŏԓәԓән оливка йўх йӑԓәп вŏсты лыпәт тус, щиты Ной мŏштәсԓы, йик мўв эԓты мӑнмаԓ. ");
INSERT INTO kca_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ԓўв хŏԓна ԓапәт хӑтәԓ ԓавԓәсәс, щӑԓта голубь па ким эсәԓсәԓы; ԓўв хŏщайәԓ голубь йŏхԓы ӑт йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ной нупәт хутсот оԓәӈмет тӑԓәԓән оԓәӈ тыԓәщ оԓәӈмет хӑтәԓән мўв сŏх эԓты йик сорәс; Ной ковчег хоп ԓоӈԓәԓ пўшсәԓы, ким ӑӈкәрмәс, пӑ мўв сŏх нŏх сормаԓ. ");
INSERT INTO kca_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Кимет тыԓәщән, хус ԓапәтмет хӑтәԓ унты мўв нŏх сорәс. ");
INSERT INTO kca_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Щӑԓта Турәм Нойа йастәс: ");
INSERT INTO kca_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Ковчег хоп эԓты нӑӈ, нӑӈ имен, нӑӈ пŏхԓан, нӑӈ пŏхԓан имиԓаԓ нӑӈ пиԓэнән ким этаты; ");
INSERT INTO kca_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","нӑӈ пиԓэнән уԓәм войԓан, кашәӈ вой сыр эԓты, ким этәԓтаԓән – тŏхԓәӈ войәт, йош войәт, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт: мўв хўват ԓыв ат мӑнԓәт, ара ат йиԓәт, мўв ԓŏватән ат пŏшхащԓәт». ");
INSERT INTO kca_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ной пŏхԓаԓ пиԓән, имеԓ пиԓән, пŏхԓаԓ имет пиԓән ким этәс. ");
INSERT INTO kca_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ут войәт, мўвән ваӈкәтԓыты, ущиԓыты, хухәтԓыты войәт пӑ тŏхԓәӈ войәт, – хŏԓ мўв ԓŏватән йӑхты ŏтәт сырԓаԓ щирән ковчег хоп эԓты ким этсәт. ");
INSERT INTO kca_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Турәм Кущайа йирасты нŏрәм Ной верәс пӑ кашәӈ сыстам йош вой сыр эԓты пӑ кашәӈ сыстам тŏхԓәӈ вой сыр эԓты и войән ус пӑ нŏх ўщитты йирасты нŏрма ԓўв тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Турәм Куща щи йӑм пусәӈ эпәԓ эпсатмаԓ кемән Ԓўв, сӑмәԓ ԋŏхԓәман, йастәс: «Па йэԓԓы, хŏйат урәӈән, мўв мўԓты ӑт питԓэм, хŏйат сӑм нŏпсәт – айтэԓән ԉик тӑйԓәт; хŏты Ма ин версәм, пӑ нэмәԓты пŏрайән ԓыԓәӈ ŏтәт тӑмиты пӑратты ӑт питԓәԓам: ");
INSERT INTO kca_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","йэԓԓы мўв уԓтаԓ хўват ԓэвпәс энмәԓты вер пӑ ԓэвпәс ӑкәтты вер, ищки пӑ рўв, ԓўӈ пӑ тӑԓ, ат пӑ хӑтәԓ ӑт хŏԓаԓәт». ");
INSERT INTO kca_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Щӑԓта, Турәм Ной пӑ пŏхԓаԓ йӑмән мӑсԓы пӑ ԓывиԓаԓа йастәс: «Пŏшхащаты, ара йўваты, мўв тэкнәптаты; ");
INSERT INTO kca_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","нын эԓтан хŏԓ ат пӑԓԓәт: хŏԓ мўвән уԓты войәт, хŏԓ турәмән йӑхты войәт, хŏԓ мўвән йӑхты ŏтәт, хŏԓ щарәс йикән уԓты войәт – ԓыв хŏԓ нын йошԓәна мийман уԓԓәт; ");
INSERT INTO kca_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","мўй ԓыԓәӈ ŏт уԓ, мўй ԋŏхаԓ, щит нынана ԓэтŏта питәԓ; йэԓпи вŏсты тŏрнәт нынана миймем иты, ин хŏԓ нынана мӑԓэм; ");
INSERT INTO kca_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","туп ўр тӑйты ԋŏхи аԓ ԓэваты, ўр щит ԓыԓ йур; ");
INSERT INTO kca_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","нын ўрән, хŏта нын ԓыԓән йур уԓ, Ма ищипа нŏх кӑшԓэм; кашәӈ вой эԓты нŏх кӑшԓэм, кашәӈ хŏйат эԓты ван хŏйатәԓ ԓыԓ йур нŏх кӑшԓэм; ");
INSERT INTO kca_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","хŏйат ўр шошмәм ŏт ищи хŏйат йош эԓты ԓўв ўрәԓ мӑнәԓ: хӑтнэху Турәм хŏрас щира тыйәԓтман уԓ; ");
INSERT INTO kca_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","нын пӑ пŏшхащаты, ара йўваты, мўв тэкнәптаты пӑ мўв ԓŏватән уԓаты». ");
INSERT INTO kca_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Щӑԓта, Ной пӑ пŏхԓаԓ пеԓа, Турәм щиты йастәс: ");
INSERT INTO kca_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Ма нын пиԓанән пӑ нын ԋаврэмԓән пиԓән Ма йастантәпсайэм верԓэм, ");
INSERT INTO kca_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","пӑ кашәӈ нын пиԓанән уԓты ԓыԓәӈ ŏт пиԓән, ковчег хоп эԓты нын пиԓанән этәм войәт пиԓән, иса мўвән уԓты войәт пиԓән, тŏхԓәӈ войәт, йош войәт, ут войәт пиԓән; ");
INSERT INTO kca_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ма нын пиԓанән йастантәпсайэм верԓэм: тӑԓта йэԓԓы ун йикән ԓыԓәӈ ŏт ӑт пӑратԓа, ун йикән мўв таԓа ӑт пайәтԓа». ");
INSERT INTO kca_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Щӑԓта Турәм йастәс: «Щи йастантәпсайэм посән ԓэщатԓэм, щит Ма нын пиԓанән верԓэм, пӑ нын пиԓанән уԓты ар сыр ԓыԓәӈ ŏтәт пиԓән, пӑ йэԓԓы уԓты рута веккеша хӑйԓэм. ");
INSERT INTO kca_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Пӑԓӈәт кўтән Ма нўԓ йўхем ԓощԓэм, щит Ма мўв пиԓән верты йастантәпсайэма пос питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Щиты питәԓ, хун Ма пӑԓӈәт ӑкәтԓәм, щита пӑԓӈәтән нўԓ йўхем ԓоԋщатәԓ; ");
INSERT INTO kca_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","щиты Ма нын пиԓанән пӑ ар сыр ԓыԓәӈ ŏтәт пиԓән верәм йастантәпсайэм нумты питԓэм; йэԓԓы хŏԓ ԓыԓәӈ ŏтәт ун йикән пӑратты ӑт питԓайәт. ");
INSERT INTO kca_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Нўԓ йўхем пӑԓӈәтән эттаԓән, Ма ԓўвеԓ шийаԓәԓэм пӑ мўвән уԓты кашәӈ ԓыԓәӈ ŏт пиԓән уԓты веккеша йастантәпсайэм нумты питԓэм». ");
INSERT INTO kca_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Турәм Ной пеԓа йастәс: «Тӑм йастантәпса пос, Ма щит ар сыр мўвән уԓты ԓыԓәӈ ŏтәт пиԓән версэм». ");
INSERT INTO kca_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ковчег хоп эԓты этәм Ной пŏхԓаԓ усәт: Сим, Хам пӑ Иафет. Хам щит Ханаан ащи ус. ");
INSERT INTO kca_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Щит Ной хуԓәм пŏх ус, ԓыв эԓтыԓаԓ мўв хŏйатәӈа йис. ");
INSERT INTO kca_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ной мўвән рупитты питәс пӑ виноград йўхәт опсәс; ");
INSERT INTO kca_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","щӑԓта виноград йўх ўна ԓўв йиԋщәс пӑ кўтщәса, пӑ ԋарԓŏмәԓты пирщин хотәԓән ŏԓәс. ");
INSERT INTO kca_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Щӑԓта Хам, щит Ханаан ащи, ԓўв ащеԓ ԋар эԓән кащаԓәсԓы, пӑ ким этмаԓән кӑт йайӈәԓаԓа щит эԓты пŏтәртсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Сим пӑ Иафет сŏх ўстән пӑ ԓӑӈкәрԓәна пŏнман, шӑш тӑхат ԓŏксәтән пӑ ԓын ащан лӑп лаксәԓән; ԓын вешԓән йŏхԓы керәтман устән, ащан ԋар эԓ ԓын ӑт вӑтсәԓән. ");
INSERT INTO kca_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ной йиԋщәм ўнайәԓ эԓты нŏх сайкәмтәс пӑ мŏштәсԓы, мўй ай пŏхәԓ ԓўв пиԓәԓән верәс; ");
INSERT INTO kca_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","пӑ йастәс: «Ханаан мўԓса, митйох митйоха ԓўв йайԓаԓ хŏща уԓты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Щӑԓта пӑ йастәс: «Турәм Кущайа, Сим ики Турма – йӑм йасәӈ ат йастәԓәт, щӑԓта Ханаан пӑ Сим митхуйа питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","пӑ Турәм Иафет мўвәт ԓӑщкама ат верԓәԓы, пӑ Сим хотәтән Иафет ат уԓ; пӑ Ханаан ԓўвеԓа митхуйа питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ной ун йик йўпийән хуԓәмсот ветйаӈ тӑԓ хŏԓна ус. ");
INSERT INTO kca_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ной уԓәм нуптәԓ йӑрәтйаӈсот ветйаӈ тӑԓ арат ус, пӑ ԓўв пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Тӑми Ной пŏхәт тыхәԓ тэԓәт: Сим, Хам пӑ Иафет. Ун йик йўпийән ԓыв ԋаврэмәт сэма пайәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Иафет пŏхәт: Гомер, Магог, Мадай, Иаван, Фувал, Мешех пӑ Фирас. ");
INSERT INTO kca_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Гомер пŏхәт: Аскеназ, Рифат пӑ Фогарма. ");
INSERT INTO kca_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Иаван пŏхәт: Елиса, Фарсис, Киттим пӑ Доданим. ");
INSERT INTO kca_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ԓыв эԓтыԓаԓ щарәс ԉэпәӈ пӑ пухрәӈ рутәт ԓыв мўвԓаԓән уԓты питсәт, кашәӈ рут утща йасӈәӈа йис, кашәӈ мир ԓыв рутԓаԓ щирән уԓты питсәт. ");
INSERT INTO kca_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Хам пŏхәт: Хуш, Мицраим, Фут пӑ Ханаан. ");
INSERT INTO kca_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Хуш пŏхәт: Сева, Хавила, Савта, Раама пӑ Савтеха. Раама пŏхәт: Шева пӑ Дедан. ");
INSERT INTO kca_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Хуш хŏԓна Нимрод пŏх тӑйәс, ԓўв мет оԓәӈ вŏԓаӈ кущайа йис. ");
INSERT INTO kca_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Турәм Куща йэԓпийән ԓўв йурәӈ веԓпәсԓәты хуйа ус, щишән, щи йастәԓа: «Нимрод хŏрпи йурәӈ веԓпәсԓәты ху Турәм Куща йэԓпийән». ");
INSERT INTO kca_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ԓўв мўвәԓән оԓәӈ вошәт усәт: Вавилон, Эрех, Аккад пӑ Халне Сеннаар мўвән. ");
INSERT INTO kca_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Щи мўв эԓты этәс пӑ Ассур мўва мӑнәс пӑ Ниневия, Реховоф-ир пӑ Калах вош опсәс, ");
INSERT INTO kca_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","пӑ Ресен, Ниневия пӑ Калах кўтән, опсәс, щит вŏԓаӈ вош. ");
INSERT INTO kca_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Мицраим эԓты луд йох, анам йох, легав йох, нафтух йох, ");
INSERT INTO kca_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","патрус йох, кафтор йох пӑ каслух йох мӑтсәт, каслух йох эԓты филистимәт йэԓԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ханаан эԓты сэма питсәт: оԓәӈ пŏхәԓ Сидон, щӑԓта Хет, ");
INSERT INTO kca_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","иевус йох, амор йох, гергес йох, ");
INSERT INTO kca_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ев йох, арк йох, син йох, ");
INSERT INTO kca_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","арвад йох, цемар йох пӑ химаф йох. Йухәт Ханаан рутәт лакки мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Сидон вош эԓты Герар вош пеԓа Газа вош унты Ханаан мўв кимԓәт усәт, щиԓта йэԓԓы Содом, Гоморра, Адма пӑ Цевоим вошәт пеԓа Лаша унты. ");
INSERT INTO kca_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Щит Хам пŏхәт, рутԓаԓ щирән, йасәӈԓаԓ щирән, ԓыв уԓты мўвԓаԓән, ԓыв мирԓаԓ щирән. ");
INSERT INTO kca_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Сим, Иафет ун йайәԓ, ԋаврэмәт ищи тӑйәс. Сим – ԓўв Евер хŏԓ пŏхәт опращ. ");
INSERT INTO kca_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Сим пŏхәт: Елам, Ассур, Арфаксад, Луд пӑ Арам. ");
INSERT INTO kca_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Арам пŏхәт: Уц, Хул, Гефер пӑ Маш. ");
INSERT INTO kca_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арфаксад Сала тӑйәс, Сала Евер тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Евер кӑт пŏх тӑйәс; итәԓ Фалек, ԓўв уԓмаԓ ишән мўв ара ортәм урәӈән щи нэмән пŏтса; кимет пŏхәԓ нэм Иоктан. ");
INSERT INTO kca_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Иоктан тӑйәс: Алмодад, Шалеф, Хацармавеф, Иерах, ");
INSERT INTO kca_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Гадорам, Узал, Диклу, ");
INSERT INTO kca_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Овал, Авимаил, Шева, ");
INSERT INTO kca_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Офир, Хавила пӑ Иовав. Щит иса Иоктан пŏхәт. ");
INSERT INTO kca_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Уԓәм лотԓаԓ Меша эԓты Сефар унты, хӑԓэвәт пеләк ун Кев унты, усәт. ");
INSERT INTO kca_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Щит Сим эԓты мӑнәм пŏхәт рут йохԓаԓ щирән, ԓыв йасәӈԓаԓ, ԓыв мўвԓаԓ, ԓыв мирԓаԓ пиԓән. ");
INSERT INTO kca_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Тӑми иса Ной пŏхәт эԓты мӑнәм рутәт, ԓыв рутԓаԓ пӑ мирԓаԓ щирән. Ԓыв эԓтыԓаԓ ун йик йўпийән мўв ԓŏватән мирәт лакки мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Мўв ԓŏватән иса туп и йасәӈ, и пŏтәр ус. ");
INSERT INTO kca_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Хӑԓэвәт пеләк эԓты касәԓман, Сеннаар мўвән хӑр мўв ԓыв уйәтсәт пӑ щита уԓты питсәт. ");
INSERT INTO kca_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Пӑ ԓыв кўтэԓән йастатсәт: «Кирпищәт верԓув пӑ тўтән такапԓәԓув». Кев йўкана кирпищ питәс, пӑ мўв ух вŏщләх йўкана питәс. ");
INSERT INTO kca_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ԓыв йастатсәт: «Мўв ԓŏвата лакки мӑнтэв йэԓпийән, мўӈева ун вош пӑ турма хойты пӑԓ хот омәсԓув, нэмԓув такан щащты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Хŏйатәт опсәм вош пӑ пӑԓ хот ватты урәӈән Турәм Куща мўва иԓ ŏхԓәс. ");
INSERT INTO kca_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Щӑԓта Турәм Куща йастәс: «Тӑм, и мир, йасӈеԓ па ит; ванты, тӑм мўй ԓыв верты питсәт, пӑ ин мўй нŏмәс ўԓәт, щит тӑԓаӈа вертэԓ унты, ӑт вŏԓыԓәт; ");
INSERT INTO kca_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","щишән, иԓ ŏхәԓԓув пӑ ԓыв йасӈеԓ щиты ԓыԓәтԓэв пӑ ԓыв кўтԓаԓән йасәӈ ӑт ат мŏштыԓәт». ");
INSERT INTO kca_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Щиты Турәм Куща ԓывиԓаԓ щиԓта мўв ԓŏвата лакки китсәԓы; вош омәсты ԓыв нŏх вŏԓысәт. ");
INSERT INTO kca_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Щишән, щи вош Вавилон нэмән пŏтса: щита Турәм Куща мўв ԓŏватән уԓты йасәӈ ԓыԓәтсәԓы, пӑ щиԓта Турәм Куща ԓывиԓаԓ мўв ԓŏвата лакки китсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Тӑта щи Сим тыхәԓ тэԓ: Сим сот тӑԓ ԓŏватән, ун йик йўпийән кӑт тӑԓ хӑщәман, Арфаксад пŏх тӑйәс; ");
INSERT INTO kca_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Арфаксад сэма питәм йўпийән Сим ветсот тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Арфаксад хŏԉмаӈ вет тӑԓ ԓŏватән Сала пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Сала сэма питәм йўпийән Арфаксад ԋӑԓсот хуԓәм тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Сала хŏԉмаӈ тӑԓ ус пӑ Евер пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Евер сэма питәм йўпийән Сала ԋӑԓсот хуԓәм тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Евер хŏԉмаӈ ԋӑԓ тӑԓ ус, пӑ Фалек пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Фалек сэма питәм йўпийән Евер ԋӑԓсот хŏԉмаӈ тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Фалек хŏԉмаӈ тӑԓ ус пӑ Рагав пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Рагав сэма питәм йўпийән, Фалек кӑтсот йӑрәтйаӈ тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Рагав нуптәԓ хŏԉмаӈ кӑт тӑԓ ус, пӑ Серух пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Серух сэма питәм йўпийән, Рагав кӑтсот ԓапәт тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Серух хŏԉмаӈ тӑԓ ус, пӑ Нахор пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Нахор сэма питәм йўпийән, Серух кӑтсот тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Нахор нуптәԓ хус йӑрәтйаӈ тӑԓ ус, пӑ Фарра пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Фарра сэма питәм йўпийән, Нахор сот йӑрхус тӑԓ ус, пӑ эвет пӑ пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Фарра ԓапәтйаӈ тӑԓ ус, пӑ Аврам, Нахор пӑ Аран пŏхәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Тӑми Фарра тыхәԓ тэԓ: Фарра Аврам, Нахор пӑ Аран пŏхәт тӑйәс. Аран Лот нэмпи пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Аран, Фарра ащеԓ уԓман, ԓўв сэма питәм мўвәԓән, Халдея мўвән Ур нэмпи тӑха хŏща пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Аврам пӑ Нахор нэ тустән; Аврам ими нэм Сара; Нахор ими нэм Милка, ԓўв Аран эви, Аран – щит Милка пӑ Иска ащи. ");
INSERT INTO kca_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Сара ӑт ԓавәртәмәса, ԋаврэм ӑт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Щӑԓта Фарра Аврам пŏхәԓ ўсԓы, пӑ Аран пŏх, Лот хиԓэԓ, пӑ Сара меԋәԓ, Аврам пŏхәԓ ими, пӑ ԓыв пиԓэԓән Халдея мўв Ур нэмпи тӑха эԓты Ханаан мўв пеԓа мӑнәс, туп Харран унты йŏхәтмеԓән, щита хӑщсәт. ");
INSERT INTO kca_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Фарра кӑтсот вет тӑԓ ус, пӑ Харран мўвән Фарра пӑрәс. ");
INSERT INTO kca_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Турәм Аврама йастәс: «Нӑӈ мўвен эԓты, нӑӈ рутэн эԓты пӑ нӑӈ ащен хот эԓты эта пӑ хŏԓта Ма нӑӈена аԉԓэм, щи мўва мӑна; ");
INSERT INTO kca_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","щӑԓта Ма нӑӈ эԓтэн вŏԓаӈ мир тыйәԓтԓәм пӑ нӑӈен йӑмән мӑԓэм, нӑӈ нэмен нŏх эԓәтԓэм, нӑӈ хўватэн мир йӑмән питԓа; ");
INSERT INTO kca_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ма, нӑӈена йӑм йасәӈ йастәты ŏтәта, йӑм мӑԓәм, пӑ нӑӈен мўԓты ŏтәт мўԓԓәԓам; нӑӈ хўватэн мўв ԓŏватән уԓты мирәт хŏԓ йӑмән мӑԓайәт». ");
INSERT INTO kca_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Щӑԓта, Турәм Куща йастәм щирән, Аврам мӑнәс; Лот ики ищи ԓўв пиԓәԓән мӑнәс. Аврам, Харран эԓты мӑнмаԓән, нуптәԓ ԋийәԓйаӈ пеԓа вет тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Аврам Сара имеԓ пӑтән ўсԓы; апщеԓ пŏх Лот ики, тӑйәм войԓаԓ пӑ пŏрмасԓаԓ пӑ Харранән ԓўвеԓа рупитәм митйохԓаԓ ищи пӑтән ўсԓы; Ханаан мўв пеԓа мӑтсәт; пӑ Ханаан мўва йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Аврам щи мўв хўват Сихем унты мӑнман, Море ун дуб йўх унты йŏхтәс. Щи мўвән щи ишән ханаан йох усәт. ");
INSERT INTO kca_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Щӑԓта Турәм Куща Аврам хŏща этәс пӑ йастәс: «Йэԓԓы уԓты ԋаврэмԓана тӑм мўв Ма мӑԓэм». Ԓўв хŏщайәԓ этԓыйәм Турәм Куща урәӈән щита йирасты нŏрәм верәс. ");
INSERT INTO kca_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Щиԓта ԓўв Кев пеԓа мӑнәс, Вефиль эԓты хӑтәԓ этты пелка; щӑԓта пирщин хотәԓ щиты ԓощсәԓы пӑ Вефиль ԓўв эԓтайәԓ хӑтәԓ ԓŏӈты пелка питәс, Гай пӑ хӑтәԓ этты пелка питәс; щита Турәм Кущайа йирасты нŏрәм верәс, пӑ Турәм Куща пеԓа пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Щӑԓта Аврам йэԓԓы мӑнәс, Негев морты мўв пеԓа касԓәс. ");
INSERT INTO kca_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Щи мўвән ԓэԓԓы пŏра ус. Щишән, Египет мўв унты Аврам йŏхтәс пӑ щита рŏнәс, йэша уԓты урәӈән, Ханаан мўвән ԓэԓԓы пŏра шек тарәм ус. ");
INSERT INTO kca_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Египет мўва ванамәмаԓән, Сара пеԓа, ԓўв имеԓ пеԓа йастәс: «Ма уйәтԓэм, нӑӈ хŏрасәӈ нэ; ");
INSERT INTO kca_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Египет мўв хŏйатәт нӑӈен шийаԓәтэԓән, йастәԓәт: ‘Тӑм ԓўв имеԓ’; мӑнэм веԓԓэԓ, нӑӈ пӑ ԓыԓӈа хӑйԓайән; ");
INSERT INTO kca_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","йаста, мӑтты ки нӑӈ ма нэ апщем, щишән, нӑӈ хўватэн мӑнэм йӑм питәԓ, пӑ ма ԓуԓән ԓыԓӈа хӑщԓәм». ");
INSERT INTO kca_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Щиты щи ус, Аврам Египет мўва йŏхәтмаԓән, Египет мўв хŏйатәтән кащаԓәса, Сара шек хŏрасәӈ нэ; ");
INSERT INTO kca_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","фараон кущайәтән ищи кащаԓәса, ԓыв фараона щи айкеԓ тусэԓ; пӑ Сара фараон хон хота уԓты ўса. ");
INSERT INTO kca_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Аврама пӑ ԓўв урӈәԓән ищи йӑм ус; ош тащәтән пӑ мис тащәтән, осёл войәтән, митйохәтән пӑ митнэӈәтән, осёл нэ войәтән пӑ верблюд войәтән тӑйты мӑса. ");
INSERT INTO kca_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Туп Турәм ԓавәрт мушәт фараона пӑ ԓўв хотәԓа Аврам ими Сара урәӈән китәс. ");
INSERT INTO kca_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Щӑԓта фараон Аврам вохсәԓы пӑ йастәс: «Мўй нӑӈ ма пиԓэмән версән? Мўйа нӑӈ мӑнэма ӑт йастәсән, щит нӑӈ имен? ");
INSERT INTO kca_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Мўйа нӑӈ йастәсән: ‘Ԓўв ма нэ апщем’? Ма ԓўвеԓ нэӈа ўты ўтщисэм. Тӑта щи нӑӈ имен, ўйи ԓўвеԓ пӑ мӑна». ");
INSERT INTO kca_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Щӑԓта фараон хŏйатԓаԓ партсәԓы, Аврам имеԓ пиԓән пӑ тӑйәм тащԓаԓ-пŏрмасԓаԓ пиԓән щи мўв эԓты китса. ");
INSERT INTO kca_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Пӑ Аврам имеԓ пиԓән, тащԓаԓ-пŏрмасԓаԓ пиԓән Египет эԓты йŏхԓы, Морты мўв пеԓа мӑтсәт, Лот ики па ԓўв пиԓәԓән мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Аврам шек ар тащ, сорԋи ŏх пӑ щел ŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Морты мўв эԓты Вефиль пеԓа ԓўв йэԓԓы касԓәс, щи тӑха унты, хŏта щи йэԓпийән Вефиль пӑ Гай кўтән пирщин хот ԓоԋщиԓыйәс, ");
INSERT INTO kca_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","щи тӑха унты, хŏта ԓўв мет оԓәӈән йирасты нŏрәм верәс; щита Аврам Турәм Куща пеԓа пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Аврам пиԓән касԓыйәм Лот нэмпи хиԓэԓ ищи ош тащәт, мис тащәт, пирщин хотәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ԓын шек ар тащ йӑха тӑйсәтән, щишән мўвән йэрмата йис, йэԓԓы щиты уԓты ӑт верәтсәтән. ");
INSERT INTO kca_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Аврам пӑ Лот ики тащ шавиты йохԓән кўтәӈа йисәт. Ханаан йох пӑ ферез йох щи мўвән щи пŏрайән усәт. ");
INSERT INTO kca_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Аврам Лот пеԓа щиты йастәс: «Мин кўтәӈа уԓты ӑт питԓәмән, тащ шавиты йохԓәмән ищи кўтәӈа уԓты ӑт питԓәт, мин нӑӈ пиԓэнән рутӈән; ");
INSERT INTO kca_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","мўй арат мўв нӑӈ йэԓпенән ӑт уԓ? Кӑтна мӑнԓәман: нӑӈ ки шӑнша, ма венша; нӑӈ ки венша, ма пӑ шӑнша». ");
INSERT INTO kca_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Иордан йŏхан ԉэп мўвәт Лот ики хŏԓ ватсәԓы пӑ кащаԓәсԓы, щи мўв Сигор унты йикән йӑма пŏшԓа, Турәм Куща ŏйәӈ-щўԋәӈ тӑха иты, Египет мўв иты. Щит щи йэԓпийән ус, хун Турәм Куща Содом пӑ Гоморра вошӈән шўкатсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Иордан йŏхан ԉэп мўв Лот ики хŏԓ ԓўв пеԓайәԓ ўсԓы; щишән, ԓўв хӑтәԓ этты мўв пеԓа мӑнәс. Кӑт тӑхайән ԓын уԓты питсәӈән. ");
INSERT INTO kca_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам Ханаан мўвән уԓты питәс; Лот ики пӑ Иордан йŏхан ԉэп мўв вошәтән уԓты питәс пӑ Содом унты пирщин хотәт ԓоԋщиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Содомән уԓты хŏйатәт ԉикәӈәт усәт, Турәм Куща йэԓпийән ар кӑрэк верыԓысәт. ");
INSERT INTO kca_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Лот утща уԓты питмаԓ йўпийән, Турәм Куща Аврама йастәс: «Ин ԓойты мўвен эԓты ар тӑха пеԓа ӑӈкәртыйа: овәс мўв пела пӑ морты мўв пеԓа, хӑтәԓ этты пӑ хӑтәԓ ԓŏӈты пеләк пеԓа; ");
INSERT INTO kca_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","хŏԓ ватты мўвԓан Ма нӑӈена пӑ нӑӈ ԋаврэмԓана веккеша тӑйты мӑԓԓам; ");
INSERT INTO kca_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","щӑԓта нӑӈ тыхԓэн сэй хиш иты ара верԓэм; щи сэй хиш мӑтты ŏтән ԓўӈәтты верәтԓа ки, нӑӈ тыхԓэн ищи щиты ԓўӈәтты питԓа; ");
INSERT INTO kca_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","мӑна, щи мўв хўватәԓ, ўтатәԓ хŏԓ йӑӈхи, Ма ԓўвеԓ нӑӈена мӑԓэм». ");
INSERT INTO kca_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Аврам пирщин хотԓаԓ лосәтсәԓы, пӑ мӑнәс, пӑ Хеврона касԓәс, Мамре дуб йўхәӈ ут пўӈәԓән уԓты питәс; щита ԓўв Турәм Кущайа йирасты нŏрәм верәс. ");
INSERT INTO kca_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Щит Амрафел, Сеннаар мўв хон, Ариох, Елласар хон, Кедорлаомер, Елам хон, Фидал, Гоим хон – щи хонәт уԓәм ишән ус, ");
INSERT INTO kca_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Бера йэщаԓт, Содом хон, Бирша йэщаԓт, Гоморра хон, Шинав йэщаԓт, Адма хон, Шемевер йэщаԓт, Севоим хон, Бела (Сигор) вош хон йэщаԓт ԉаԉәсты ԓыв мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Щи хонәт хŏԓ Сиддим лот мўвән, хŏта ин Сŏԓаӈ щарәс, йўрԓаԓ йӑха пŏнмеԓ. ");
INSERT INTO kca_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Кӑтхŏщйаӈ тӑԓ ԓыв Кедорлаомер хон иԓпийән усәт, хуԓметхŏщйаӈ тӑԓән ԉаԉа эԓԓәсәт. ");
INSERT INTO kca_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ԋӑԓхŏщйаӈмет тӑԓән Кедорлаомер пӑ ԓўв пиԓәԓән уԓәм хонәт йŏхәтсәт пӑ рефа йох Аштероф-Карнаим вŏшән, зуз йох Гам вошән, эм йох Шаве-Кириафаимән иԓ пайәтсәԓаԓ, ");
INSERT INTO kca_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","пӑ хоррей йох Сеир кевәтән, Эл-Фаран унты, щит таԓ хишәӈ мўв сыԓәԓ хŏща. ");
INSERT INTO kca_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Щиԓта йŏхԓы йŏхәтмеԓ йўпийән, ԓыв, Кадеса айәԓтты, Мишпат ԓыԓәӈ йик лот унты йŏхәтсәт, пӑ ԉаԉәсман, амалик йох мўв нŏх ўсэԓ, пӑ Хацацон-Фамарән уԓәм амор йох эԓты ищи нŏх питсәт. ");
INSERT INTO kca_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Щӑԓта Содом хон, Гоморра хон, Адма хон, Севоим хон, Бела (Сигор) хон этсәт пӑ ԓыв пиԓэԓән Сиддим лот мўвән ԉаԉәссәт, ");
INSERT INTO kca_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Кедорлаомер, Елам хон пиԓән, Фидал, Гоим хон пиԓән, Амрафел, Сеннаар хон пиԓән, Ариох, Елласар хон пиԓән, – ԋӑԓ хон вет хон йэщаԓт ус. ");
INSERT INTO kca_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Сиддим мўвән ух кӑшты мўв ўсәт усәт. Хун Содом пӑ Гоморра хонӈән хухәԓман хŏнтаты питсәтән, ԓын щи мўв ўсәта рӑкәтсәтән, хӑщәм ŏтәт Кевән хӑԋэмәсәт. ");
INSERT INTO kca_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Нŏх питәм ŏтәт Содом пӑ Гоморра тащәт-пŏрмасәт пӑ хŏԓ ԓэтŏт сопасәт ўсԓаԓ пӑ мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Пӑ Содомән уԓәм Лот ики, Аврам хиԓы, тащԓаԓ-пŏрмасԓаԓ пиԓән ищи пӑтән тусэԓ. ");
INSERT INTO kca_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Щӑԓта ԓыԓӈа хӑщәм ŏтәт эԓты ит хŏнтамаԓ, пӑ щи вер эԓты, Мамре дуб йўхәӈ ут пўӈәԓән уԓәм, Аврам еврей икийа пŏтәртәс. Щита уԓәм Мамре амор ики пӑ ԓўв хӑнам йохԓаԓ Эшкол пӑ Анер Аврам пиԓән и пеԓа усәт. ");
INSERT INTO kca_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Аврам, ԓўв Лот хиԓэԓ катԓәм пӑ тўвәм вер, хуԓмаԓ кемән, ԓўв хотԓаԓән сэма питәм хуԓәмсот ԋийәԓхус ԉаԉәсты верәтты йох ӑктәс пӑ ԋӑԓ хон йўпеԓ эԓты Дан унты ԋухәԓсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Аврам атәԓән ԉаԉ йохԓаԓ ар похла ортсәԓы, ԋухԓәм ŏтԓаԓ эԓты йŏхәтсәԓы пӑ ԉаԉәсман нŏх питәс, пӑ Хова унты, Дамаск эԓты ŏвәс пеԓа ԉаԉәсман ԋухәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Аврам ԉаԉән мŏщатәм тащәт-пŏрмасәт йŏхԓы керәтсәԓы, Лот хиԓэԓ пŏрмасԓаԓ пиԓән йŏхԓы тусԓы, нэӈат пӑ хŏйатәт ищи йŏхԓы тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Кедорлаомер хон пӑ ԓўв пиԓәԓән уԓәм хонәт эԓты нŏх питмаԓ йўпийән, йŏхԓы йўвмаԓән, Шаве лот мўвән, Содом хон ԓўв йэщаԓтэԓ этәс, щит ин Хон лот мўва айәԓԓа; ");
INSERT INTO kca_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","пӑ Мелхиседек, Салим хон, ԋаԋ пӑ ўна ким тус, ԓўв Нўм Турма йир верты хŏйата ус, ");
INSERT INTO kca_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","щӑԓта ԓўвеԓа Турәм эԓты йӑм вохәс пӑ йастәс: «Аврам Нўм Турәмән йӑмән ат мӑԓа, турәм пӑ мўв Тӑйты Ŏт эԓты, ");
INSERT INTO kca_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","пӑ Нўм Турма йӑм йасәӈ ат йастәԓәт, хорахщет нӑӈ йошена миймаԓ урәӈән». Аврам шитәм ŏтԓаԓ эԓты ԓўвеԓа и йаӈметәԓ мӑс. ");
INSERT INTO kca_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Щӑԓта Содом хон Аврама йастәс: «Хŏйатԓам мӑнэма мийаԓән, пŏрмасԓам нӑӈена хӑйаԓән». ");
INSERT INTO kca_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Аврам пӑ щиты Содом хон пеԓа йастәс: «Турәм Куща Нўм Турмем пеԓа, турәм пӑ мўв Тӑйты Ŏтэм пеԓа йошем нŏх шӑшԓэм пӑ йасәӈ мӑԓәм, ");
INSERT INTO kca_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","и сŏхәм, и кеԓ нӑӈ пŏрмасԓан эԓты ӑт уԓәм, щӑха нӑӈ ӑт ат йастәсән: ‘Аврам ма тащәӈа версэм’, ");
INSERT INTO kca_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","мӑнэма нэмәԓты ӑт мосәԓ, ԉаԉәсәм йохәт ԓэвәм ŏт тўмпийән пӑ ма пиԓэмән йӑӈхәм хŏйатәта ортты пŏрмас тўмпийән; Анер, Эшкол пӑ Мамре, шитәм пŏрмасәт эԓты, ԓывиԓаԓа мосты арат ат ўԓәт». ");
INSERT INTO kca_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Щи верәт хӑщәм йўпийән Турәм Куща уԓәмән Аврам пеԓа йастәс: «Аԓ пӑԓа, Аврам; Ма нӑӈ сайԓәпсайэн, нӑӈ мойԓәпсайэн шек ун». ");
INSERT INTO kca_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Аврам йастәс: «Вŏсху Турәм Куща! Мўй Нӑӈ мӑнэма мӑԓән? Ма ԋаврэм ӑт тӑйԓәм, пŏрмасэм пӑ тащем, Дамаск вош эԓты уԓты, Елиезер нэмпи хот шавиты кущайэма хӑщәԓ». ");
INSERT INTO kca_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Щиты Аврам йастәс: «Нӑӈ мӑнэма ԋаврэм ӑт мӑсән, щишән, ма хотэмән сэма питәм митхуйэма хотэм пӑ тащем хӑщәԓ». ");
INSERT INTO kca_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Щӑԓта Турәм Куща ԓўвеԓа йастәс: «Ԓўвеԓа хотэн пӑ тащен ӑт питәԓ, туп хŏй нӑӈ эԓтэн тыйәԓ, щитэна нӑӈ тащен питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Щӑԓта Турәм Куща ԓўвеԓ ким этәԓтәсԓы пӑ йастәс: «Турәм хӑр пеԓа ванта пӑ хусәт ԓўӈтаԓән, ԓўӈәтты верәтԓэн ки». Пӑ ԓўвеԓа йастәс: «Щи арат нӑӈ тыхԓэн питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Аврам Турәм Куща йасӈа эвԓәс, щишән Турәм Куща ԓўвеԓ вещката ԓўӈәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Щӑԓта ԓўвеԓа йастәс: «Ма Турәм Куща, Ма нӑӈен Халдея мўвән уԓты Ур нэмпи тӑха эԓты ты тусэм, тӑм мўв нӑӈена тӑйты мӑты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Авраам пӑ йастәс: «Вŏсху Турәм Куща! Мўй щирән ма мŏштәԓэм щи мўв мӑнэма питты вер?» ");
INSERT INTO kca_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Турәм Куща ԓўвеԓ йастәс: «Хуԓәм тӑԓа йўвәм нэ мис, хуԓәм тӑԓа йўвәм коза, хуԓәм тӑԓа йўвәм ош, горлица вой пӑ энәмты голубь вой Мӑнэм тўва». ");
INSERT INTO kca_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Аврам щиты щи верәс, пӑ войԓаԓ хўватԓаԓ щирән хŏԓ кӑтна ващсәԓы, и пеләкԓаԓ кимет пеләкԓаԓ йэщаԓт пŏтсәԓы; туп тŏхԓәӈ войӈиԓаԓ кӑтна ӑт эвәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Вой хӑԓайәт хŏща кўркәт, хулхәт, вŏрӈайәт йŏхәтсәт; пӑ Аврам ԓывиԓаԓ йэԓ воштәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Най ԓŏӈәмән Аврам так оԓма питәс, щӑԓта тўрма ԓўв эԓтэԓ питәс пӑ пӑԓщамән йŏхәтса. ");
INSERT INTO kca_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Щӑԓта Турәм Куща Аврама йастәс: «Уйты, нӑӈ эԓтэн тыйты мирэн па мўва касԓәм хŏйатәта питԓәт, тынԓы-пелԓы рупата ԋўрты питԓәт, пӑ щиты йэрмәԓты уԓәпсайән ԋӑԓсот тӑԓ уԓты питԓәт, ");
INSERT INTO kca_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","туп Ма щи мир хŏща сўт верԓэм, хŏй хŏща ԓыв тынԓы-пелԓы рупата ԋўрты питԓәт; щи йўпийән ԓыв тащԓаԓ-вещԓаԓ пиԓән йŏхәтԓәт, ");
INSERT INTO kca_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","нӑӈ пӑ йӑмән ащиԓан хŏща мӑнԓән, нуптэн йӑма уԓман иԓ лоттәԓайән; ");
INSERT INTO kca_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","туп хиԓыԓан ԋаврэмәт тыйэԓт йŏхԓы йŏхәтԓәт, хун амор йох атәм верәт тэкәнты ўша йиԓәт». ");
INSERT INTO kca_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Най ԓŏӈәмән пӑтлама йис, пӑ щи, пусӈиԓәты кур сэма питәс пӑ тўт ԋаԓәм пусәӈ пиԓән кӑтна эвтәм войәт кўтән мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Щи хӑтәԓән Турәм Куща Аврам пиԓән йастантәпса верәс, йастәман: «Тӑм мўв йэԓԓы уԓты ԋаврэмԓана Ма мӑԓэм, Египет йŏхан эԓты Евфрат ас унты: ");
INSERT INTO kca_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","кен йох, кенез йох, кедмон йох мўвәт, ");
INSERT INTO kca_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","хет йох, ферез йох, рефа йох мўвәт, ");
INSERT INTO kca_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","амор йох, ханаан йох, гергес йох пӑ иевус йох мўвәт». ");
INSERT INTO kca_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Сара Аврам ийикеԓа ԋаврэм ӑт тӑйәс. Ԓўв хŏщайәԓ Египет мўв нэ, Агарь нэмпи митнэ ус. ");
INSERT INTO kca_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Аврам пеԓа Сара щиты йастәс: «Турәм Кущайән ԋаврэмән ӑт партсайәм. Мӑна, митнэӈем пиԓән уԓа. Мосәӈ, ԓўв мӑнэма ԋаврэм тӑйты питәԓ». Аврам Сара йасӈәт пеԓа хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Щиты, Ханаан мўвән йаӈ тӑԓ уԓман йўпийән, Сара Аврам ийикеԓа Египет мўв Агарь митнэӈәԓ ай нэӈа тӑйты мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Аврам Агарь пиԓән ус, пӑ ԓўв нэ щирән ԓавәрта йис. Щиты питмаԓ кемән, ԓўв куща нэӈәԓ эԓты ԓўвеԓ унашәк тӑйты питсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Сара Аврама йастәс: «Ма нӑӈена митнэӈем мӑсәм; ԓўв ԋаврэм щирән уԓ пӑ мӑнэм нэмәԓтыйа ӑт тӑйԓәԓы. Щишән, нӑӈ урӈенән ма ԉикән этԓайәм; Турәм Куща мӑнэма пӑ нӑӈена сўт верты ŏта ат уԓ». ");
INSERT INTO kca_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Аврам Сара пеԓа йастәс: «Ԓўв нӑӈ митнэӈен, мўй ԓӑӈхаԓайән, щит ԓўв пиԓәԓән вера». Щишән, Сара митнэӈәԓа рупата ԋўрты партәс пӑ Агарь ԓўв эԓтэԓ хŏнтас. ");
INSERT INTO kca_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Турәм Куща ангел таԓ хишәӈ мўвән йик ўты ўс пўӈәԓән, Сур пеԓа мӑнты йушән, ԓўвеԓ уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Пӑ йастәс: «Агарь, Сара митнэ, хŏԓща йŏхәтсән пӑ хŏԓта мӑнԓән?» Ԓўв йастәс: «Ма Сара куща нэӈем эԓты хŏнтаԓәм». ");
INSERT INTO kca_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Турәм Куща ангел ԓўвеԓа йастәс: «Куща нэӈен хŏща йŏхԓы мӑна пӑ ԓўв пеԓайәԓ хуԓәнта». ");
INSERT INTO kca_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Щӑԓта Турәм Куща ангел ԓўвеԓа йастәс: «Энәмты тыхԓэн щи ԓŏват ара верԓэм, ԓўӈәтты йур ӑт йŏхәтәԓ». ");
INSERT INTO kca_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Хŏԓна Турәм Куща ангел ԓўвеԓа йастәс: «Нӑӈ ин ԋаврэм щирән уԓԓән пӑ пŏх сэма пайәтԓән, Измаил нэмән ԓўвеԓ пŏнԓэн, Турәм Куща нӑӈ ԓавәрт уԓәпсайэн хуԓтсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ԓўв ут вой иты хŏйатәт кўтән уԓты питәԓ: ԓўв иса мир йэщаԓт питәԓ, мир пӑ ԓўв йэщаԓтәԓ питәԓ, йайԓаԓ-апщиԓаԓ пиԓән кўтәӈа уԓты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Щишән, Агарь ԓўв пиԓәԓән пŏтәртәм Турәм Куща нэмән мӑсԓы: «Нӑӈ – Мӑнэм ватман тӑйты Турәм». Щиты ԓўв йастәс: «Йӑна тӑта, Мӑнэм ватман тӑйты Ŏт, ма ватсәм». ");
INSERT INTO kca_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Щишән, щи йик ўты ўс щиты айәԓтԓа: Беэр-лахай-рои. Кадес лот пӑ Баред вош кўтән ԓўв уԓ. ");
INSERT INTO kca_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Агарь Аврама пŏх сэма пайтәс; Агарь эԓты тӑйәм пŏхәԓ Аврам Измаил нэмән пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Аврама ԋийәԓйаӈ хут тӑԓ ус, хун Агарь Измаил пŏхәԓ сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Аврама йӑрсот йӑрәтйаӈ тӑԓ ус, хун Турәм Куща ԓўв йэщаԓтәԓ этәс пӑ ԓўвеԓа йастәс: «Ма Иса Верәтты Турәм, Ма йэԓпемән йӑӈха пӑ вещката уԓа; ");
INSERT INTO kca_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ма йастантәпсайэм мин кўтэмәнән верԓэм пӑ щӑԓта шек-шек ара нӑӈен рутмәԓтԓэм». ");
INSERT INTO kca_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Аврам мўва хŏмта рӑкнәс. Турәм пӑ ԓўв пиԓәԓән йэԓԓы пŏтәртәс пӑ щиты йастәс: ");
INSERT INTO kca_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Тӑм Ма йастантәпсэм нӑӈ пиԓэнән: ар сыр мир ащийа нӑӈ питԓән, ");
INSERT INTO kca_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Аврам нэмен хӑйԓэн, пӑ тӑԓта йэԓԓы нӑӈ нэмен питәԓ: Авраам, Ма нӑӈен ар сыр мир ащийа верԓэм; ");
INSERT INTO kca_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","пӑ шек-шек нӑӈен рутмәԓтԓэм, пӑ нӑӈ эԓтэн Ма ар сыр мир этәԓтәԓәм, пӑ хонәт нӑӈ эԓтэн этԓәт; ");
INSERT INTO kca_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ма йастантәпсайэм мин кўтэмәнән пӑ йэԓԓы уԓты нӑӈ ԋаврэмԓан пиԓән верԓэм, щит веккеша уԓты йастантәпса, щиты Ма нӑӈ Турмена пӑ нӑӈ йўпен ԋаврэмԓана Турма уԓты питԓәм; ");
INSERT INTO kca_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ин нӑӈ па мўвәӈ хŏйат иты уԓты Ханаан мўвен нӑӈена пӑ нӑӈ йўпенән рутәмты ԋаврэмԓана хŏԓ мӑԓэм, веккеша тӑйты мӑԓэм; пӑ ԓывиԓаԓа Турма уԓты питԓәм». ");
INSERT INTO kca_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Щӑԓта Турәм Авраама йастәс: «Нӑӈ пӑ нӑӈ пелкен эԓты Ма йастантәпсайэм тўӈа-щира веры, нӑӈ пӑ нӑӈ йўпенән энәмты ԋаврэмԓан пӑ йэԓԓы уԓты ԓыв ԋаврэмԓаԓ ԋаврэмәт ищи. ");
INSERT INTO kca_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Щит Ма йастантәпсайэм, щит мин кўтэмәнән пӑ нӑӈ йўпенән йэԓԓы уԓты нӑӈ ԋаврэмԓан ԋаврэмәт пиԓән тўӈа-щира верты верән уԓ: хŏԓ йох рут сэма питәм йох ԋаврэмәт пиԓән эвәтты щира питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","хŏԓ йох хŏйатәта сэма питәм йох ԋаврэмәт пиԓән эвәтты щир вераты: щит Ма нын пиԓанән йастантәпсайэм поса питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Кашәӈ сэма питәм йох ԋаврэм нын рутԓән хŏща, нӑӈ пӑ нӑӈ йўпенән энәмты ԋаврэмԓан пӑ ԓыв ԋаврэмԓаԓ ԋаврэмәт хŏща ԋийәԓ хӑтԓа йитаԓән эвәтты щирән ат верԓайәт. Шŏши хотән сэма питәм пӑ щел ŏх сӑхат па рут хŏйат эԓты ԓутәм ŏт, хŏй ӑнтом нӑӈ рутэн эԓты, эвәтты щирән ат верԓайәт. ");
INSERT INTO kca_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Щишән, нӑӈ хотэнән сэма питәм ŏт пӑ щел ŏх сӑхат ԓутәм ŏт эвәтты щирән ат верԓа, щиты Ма йастантәпсайэм нын эԓәнән веккеша йастантәпсайа питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ӑт эвтәм йох хŏйат, хŏй эвәтты щирән ӑт верԓа, ԓўв мирәԓ эԓты эртԓа, Ма йастантәпсайэм шŏппи ўшмаԓ урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Щӑԓта Турәм Авраама йастәс: «Сара имен пӑ аԓ айәԓты Сара нэмаԓән, ԓўв нэмәԓ питәԓ: Сарра. ");
INSERT INTO kca_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ма ԓўвеԓ йӑмән мӑԓэм пӑ нӑӈен пŏхән ԓўв эԓтэԓ мӑԓэм; ԓўвеԓ йӑмән мӑԓэм, пӑ мирәт ԓўв эԓтэԓ этԓәт, хонәт ԓўв эԓтэԓ этԓәт». ");
INSERT INTO kca_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Авраам хŏмта рӑкнәс пӑ ԋӑхән йŏхәтса пӑ ԓўв сӑхатәԓ йастәс: «Сот тӑԓпи ики эԓты пŏх хун уԓ? Йӑрсот тӑԓпи Сарра мўй щирән ԋаврэм сэма пайәтәԓ?» ");
INSERT INTO kca_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Пӑ щӑԓта Авраам Турма йастәс: «Измаил кўш кепа Нӑӈ йэԓпенән ԓыԓӈа пӑ йӑма ат уԓ!» ");
INSERT INTO kca_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Турәм пӑ йастәс: «Вŏԓԓы нӑӈ имен Сарра нӑӈена пŏх сэма пайәтәԓ, нӑӈ пӑ ԓўвеԓ Исаак нэмән пŏнԓэн; Ма пӑ йастантәпсайэм ԓўв пиԓәԓән веккеша йастантәпсайа верԓэм, пӑ ԓўв йўпеԓән уԓты ԋаврэмԓаԓа. ");
INSERT INTO kca_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Измаил эԓты Ма нӑӈен ищи хуԓтсэм: Ма ԓўвеԓ йӑмән мӑԓэм, тыхԓәԓ ара верԓэм, пӑ шек-шек ԓўвеԓ рутмәԓԓэм; кӑтхŏщйаӈ кӑнащ ԓўв эԓтэԓ сэма питԓәт; Ма ԓўв эԓтайәԓ вŏԓаӈ мир этәԓтәԓәм. ");
INSERT INTO kca_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Туп Ма йастантәпсайэм Исаак пиԓән верԓэм, папуш и тӑм пŏрайән Саррайән нӑӈена тӑйты пŏхен пиԓән». ");
INSERT INTO kca_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Щитәԓән Турәм Авраам пиԓән пŏтәртты вŏԓыйәс пӑ нŏх эԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Щи хӑтәԓән Авраам Измаил пŏхәԓ эвәтты щирән версәԓы. Пӑ ԓўв хотәԓән сэма питәм йох хŏйатәт пӑ щел ŏхәԓ сӑхат ԓутәм ŏтәт ищи щиты версәԓы, хŏты Турәм ԓўвеԓ йастәс. ");
INSERT INTO kca_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраама, эвәтты щир верәмән, йӑрсот йӑрәтйаӈ тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Измаил пŏхәԓа эвәтты щир верәмән хуԓәмхŏщйаӈ тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Вŏԓԓы щи хӑтәԓән Авраам Измаил пŏхәԓ пиԓән эвәтты щирән версайтән. ");
INSERT INTO kca_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ԓўв пиԓәԓән ԓўв хотәӈ йох хŏйатԓаԓ, ԓўв хотәԓән сэма питәм пӑ па мир хŏйатәт эԓты щел ŏх сӑхат ԓутәм ŏтәт хŏԓ эвәтты щирән версайәт. ");
INSERT INTO kca_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Мамре дуб йўхәӈ ут хŏща, хӑтәԓ кўтәп рўвән пирщин хот овәԓ пўӈәԓән Авраам омәсмаԓән, ԓўв хŏщайәԓ Турәм Куща этәс. ");
INSERT INTO kca_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Авраам сэмӈиԓаԓ нŏх аԓәпсәԓы пӑ шийаԓәсԓы, хуԓәм йох хŏйат ԓўв эԓтэԓ йэԓәншәк ԓойԓәт. Ԓывиԓаԓ шийаԓәмаԓ кемән, пирщин хот овәԓ эԓты ԓыв хŏщайэԓ йэщаԓт хухәԓмәс пӑ мўв унты иԓ ԋўрщәман ŏх пŏнәс, ");
INSERT INTO kca_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","пӑ йастәс: «Вŏԓаӈ Куща! Нӑӈ йӑм сэмән ма пеԓайэм ватԓән ки, Нӑӈ митхуйэн хот мŏхты аԓ мӑна; ");
INSERT INTO kca_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","кўрԓән ԉŏхәтты йикән туԓайты, щӑԓта тӑм йўх иԓпийән щўтщаты, ");
INSERT INTO kca_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ма пӑ ԋаԋ туԓәм, нын сӑмԓән ԓэщтәты урәӈән, щӑԓта йэԓԓы мӑнты верәтԓәты; ищипа щи ин нын митхуйән хŏща йŏхәтсәты». Ԓыв йастәсәт: «Хŏты пŏтәртԓән, щиты веры». ");
INSERT INTO kca_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Щӑԓта Авраам пирщин хота, Сарра хŏща, тэрматыман ԓŏӈемәс пӑ йастәс: «Хуԓәм мера арат йӑм ԓат сорашәк рўвта пӑ паԓәм ԋаԋ вера». ");
INSERT INTO kca_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Щӑԓта тащәԓ хŏща Авраам хухәԓмәс, мет йӑм ай мис пŏшәх пирыйәс, айкем митхуйәԓа мӑсԓы пӑ щитәԓ ԓэтŏт сора верты питәс. ");
INSERT INTO kca_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Щӑԓта вŏй пӑ мис йик, пӑ йӑԓпа кавәртәм ԋŏхи ўс, пӑ ԓыв йэԓпиԓаԓән омәссәԓы, ԓўв пӑ ԓыв пўӈԓэԓән йўх иԓпийән ԓойәс. Ԓыв пӑ ԓэсәт. ");
INSERT INTO kca_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Щӑԓта ԓўвеԓа йастәсәт: «Сарра иимен пӑ хŏта?» Ԓўв йастәс: «Тӑта, пирщин хотән». ");
INSERT INTO kca_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Итэԓ йастәс: «Папуш и тӑм пŏрайән Ма нӑӈ хŏщайэн па йŏхәтԓәм, пӑ Сарра иимен пŏх тӑйты питәԓ». Сарра пӑ пирщин хот ов сайән ԓойәс пӑ хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраам пӑ Сарра уна пелка йўвәм хŏйатӈән усӈән, Сарра нэ верԓаԓ йэтшәсәт. ");
INSERT INTO kca_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Сарра ԋӑхән йŏхәтса пӑ ԓўв сӑхатәԓ йастәс: «Ԏо, Ма пӑ, пирщамәмем йўпийән, ԋаврэм мўй щирән мŏщатԓәм? Иикем па пирәщ». ");
INSERT INTO kca_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Турәм Куща Авраам пеԓа йастәс: «Мўйа пӑ Сарра ԋӑхәс, йастәман: ‘Пирәщ турәмән мўй щирән ма ԋаврэм мŏщатԓәм?’ ");
INSERT INTO kca_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Турәм Кущайа мŏԓты ԓавәрт вер хун уԓ? Папуш, йастәм хӑтԓэмән, Ма нӑӈ хŏщайэн йŏхәтԓәм, Сарра пӑ пŏх тӑйты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сарра пӑԓтамәс пӑ йастәс: «Ма ӑт ԋӑхсәм». Турәм Куща пӑ йастәс: «Ӑнта, нӑӈ ԋӑхсән». ");
INSERT INTO kca_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Щӑԓта щи йох хŏйатәт нŏх ԓойсәт пӑ Содом вош пеԓа мӑтсәт; Авраам ищи ԓыв пиԓэԓән тŏхишәк унты йӑӈхәс. ");
INSERT INTO kca_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Щӑԓта Турәм Куща йастәс: «Ма мўй верты ўтщиԓәм, Авраам эԓты хӑԋатԓэм хун? ");
INSERT INTO kca_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Авраам эԓты вŏԓаӈ пӑ йурәӈ мир йӑна рутмәԓ, мўвән уԓты мирәт хŏԓ ԓўв хўватәԓән йӑмән мӑԓайәт, ");
INSERT INTO kca_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ма ԓўвеԓ щи урәӈән пирысэм, щӑха ԓўв, ԋаврэмԓаԓа пӑ хиԓыԓаԓа, Турәм Куща аԉәм йуш хўват, тўӈа-щира пӑ вещката уԓман, шушты ат партԓәԓы, Турәм Куща пӑ мўй Авраама йастәс, ищи верԓәԓы». ");
INSERT INTO kca_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Турәм Куща йастәс: «Содом пӑ Гоморра вошӈән хŏйатәт уԓәпса эԓты ар хоԓԓәпәӈ ўв щащәԓ, кӑрэкеԓ шек ԓавәрт, ");
INSERT INTO kca_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","иԓ ŏхәԓԓәм пӑ ватԓэм, йӑна мўй ԓыв щиты уԓԓәт, хŏты Ма хуԓԓыԓэм, мосәӈ, ӑнта, щит ԓэрапԓэм». ");
INSERT INTO kca_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Щи хŏйатӈән карэмәсӈән пӑ Содом пеԓа мӑтсәӈән; Авраам пӑ Турәм Куща йэщаԓт хŏԓна ԓойәс. ");
INSERT INTO kca_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Авраам Ԓўв хŏщайәԓ ванашәк мӑнәс пӑ йастәс: «Нӑӈ кӑрэкәӈ хŏйатәт пиԓән вещкат хŏйатәт мўй па пӑратԓәԓан? ");
INSERT INTO kca_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Мосәӈ, тӑм вошән ветйаӈ вещкат хŏйат уԓ? Пӑр мŏԓты Нӑӈ щи тӑха пӑратԓэн, щита уԓты щи ветйаӈ вещкат хŏйат урәӈән ӑт щаԉәтԓэн? ");
INSERT INTO kca_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Нӑӈ щиты ӑт верԓэн, вещкат хŏйатәт атәм хŏйатәт пиԓән пӑратԓәԓан хун, атәм хŏйатәт иты вещкат хŏйатәт сўтәтԓыԓан хун, Нӑӈ эԓтэн щит ӑт питәԓ! Иса мўв Сўт верты Ŏт йŏвра верәԓ хун?» ");
INSERT INTO kca_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Турәм Куща йастәс: «Содом вошән ветйаӈ вещкат хŏйат Ма уйәтԓәм ки, Ма ԓыв урӈеԓән хŏԓ щи тӑха щаԉәтԓэм». ");
INSERT INTO kca_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Авраам пӑ йастәс: «Ма пӑ Вŏсху пиԓән пŏтәртты йасӈем хŏԓна этәԓ, ма, таԓ хиш пӑ нампәр: ");
INSERT INTO kca_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","мосәӈ, ветйаӈ вещкат хŏйат унты вет туп ӑт тӑрмәԓ? Нӑӈ тӑԓаӈ вош щи ӑт тӑрәмты вет хŏйат урәӈән пӑратԓэн хун?» Ԓўв йастәс: «Ӑт пӑратԓэм, ԋӑԓйаӈ вет щита уйәтԓәм ки». ");
INSERT INTO kca_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Авраам Ԓўв пиԓәԓән йэԓԓы пŏтәртәс пӑ йастәс: «Мосәӈ, ԋӑԓйаӈ щита ԉикмәԓ?» Ԓўв йастәс: «Ԋӑԓйаӈ хŏйат урәӈән Ма щит ищи ӑт верԓэм». ");
INSERT INTO kca_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Щӑԓта Авраам йастәс: «Вŏсху ӑт ат ԉикащәԓ, ма па йастәԓәм: мосәӈ, щита туп хŏԉмаӈ хŏйат питәԓ?» Ԓўв йастәс: «Ӑт верԓэм, хŏԉмаӈ щита ԉикмәԓ ки». ");
INSERT INTO kca_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраам йастәс: «Ма пӑ Вŏсху пиԓән пŏтәртты йасӈем хŏԓна этәԓ: мосәӈ, щита хус ԉикмәԓ?» Ԓўв йастәс: «Хус урәӈән ӑт пӑратԓэм». ");
INSERT INTO kca_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Авраам йастәс: «Вŏсху ӑт ат ԉикащәԓ, ма и пуш па иԋщәсԓэм: мосәӈ, щита йаӈ туп питәԓ». Ԓўв йастәс: «Йаӈ урәӈән ӑт пӑратԓэм». ");
INSERT INTO kca_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Щӑԓта Турәм Куща мӑнәс, Авраам пиԓән пŏтәртты вŏԓыйәс; Авраам пӑ ԓўв уԓты тӑхайәԓа йŏхԓы мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Щи ангелӈән йэтна пеԓа Содома йŏхәтсәтән, хун Лот ики Содом вош овәт пўӈәԓән опсәс. Лот ики ԓынан кащаԓәмаԓ кемән, нŏх ԓойәс пӑ ԓын йэщаԓтан мӑнәс пӑ мўв унты, ŏх пŏнман, иԓ ԋўрәс ");
INSERT INTO kca_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","пӑ йастәс: «Кущайӈәԓам! Митхуйән хота ԓŏӈатән пӑ хоԓатән, кўрԓән ԉŏхитаԓән, аԓәӈсӑхат нŏх киԓԓәтән пӑ йэԓԓы нын йушән хўват мӑнԓәтән». Ԓын пӑ йастәстән: «Ӑнта, мин камән хоԓԓәмән». ");
INSERT INTO kca_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ԓўв пӑ шек такан ԓынан пойәксәԓы; пӑ ԓын ԓўв йўпеԓән мӑтсәтән, пӑ ԓўв хотәԓа ԓŏксәтән. Ԓўв йӑм эпԓәӈ ԓэтŏт пӑ паԓәм ԋаԋ верәс, пӑ ԓын ԓэстән. ");
INSERT INTO kca_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ԓын хŏԓна иԓ ӑт ŏԓсәтән, хун Содом вош йох, айэԓ-унэԓән, кашәӈ вош оԓәӈ эԓты, щи хот, керәтман, лӑп ўсэԓ. ");
INSERT INTO kca_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Лот ики ким вохсэԓ пӑ ԓўвеԓ йастәсәт: «Хŏта нӑӈ хŏщайэн хоԓты йŏхтәм хŏйатӈән? Ԓынан мўӈ хŏщайэв ким тўваԓән; мўӈ ԓын пиԓанән пакрасԓыты ԓӑӈхаԓайув». ");
INSERT INTO kca_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лот ики ԓыв хŏщайэԓ ким этәс, пӑ хŏт овәԓ ԓўв йўпеԓән лӑп тухәрсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","пӑ йастәс: «Хӑнам йŏх, атәм аԓ вераты; ");
INSERT INTO kca_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","тӑта щи ма эвеӈәԓам, ԓын хŏԓна йох хŏйат пиԓән ӑт устән; ма ԓынан нын хŏщайән этәԓтыԓԓам, мўй ԓӑӈхаԓайты, ԓын пиԓанән вераты, туп тӑм йŏхтәм хŏйатӈәна нэмәԓты аԓ вераты, ԓын ма мойәӈ хŏйатӈәԓам, ма ԓынан сайԓәты верэм уԓ». ");
INSERT INTO kca_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ԓывәт пӑ йастәсәт: «Ты йўва». Пӑ йастәсәт: «Тӑм хŏйат па мўв эԓты йŏхтәм ŏт, пӑ мўӈев сўтәтты ўтщийәԓ? Ин мўӈ нӑӈена ԓынан эԓты аршәк атәм верԓув». Щӑԓта щи хŏйат, Лот ики, пўӈԓа ипәртты питсэԓ, пӑ ов шўкатты ўтщисэԓ. ");
INSERT INTO kca_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Щиӈәԋща щи йохӈән йошԓән ким ԋиншәмтысԓән пӑ Лот ики йŏхи ԋӑрэмәсԓән, пӑ ов лӑп тухәрсәԓән; ");
INSERT INTO kca_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ов пўӈәԓән уԓәм хŏйатәт айэԓ-унэԓән сэмԓы пайәтсәԓән, щишән щитәт, ов кӑшман, воԓԓы шукащсәт. ");
INSERT INTO kca_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Щи йохӈән Лот ики пеԓа йастәсӈән: «Хŏйтыԓан тӑта хŏԓна уԓԓәт? Веӈԓан мўй, пŏхԓан мўй, эвиԓан мўй пӑ па хŏйатԓан тӑм вош эԓты хŏԓ йэԓ тўваԓән, ");
INSERT INTO kca_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","мин тӑм тӑха иса таԓа верԓэмән, Турәм Куща унты шек ун хоԓԓәпәӈ ўв тӑм мŏхет уԓәпса эԓты йŏхтәс, щишән, Турәм Куща тӑм тӑха иса таԓа верты урәӈән минэмән китсәԓы». ");
INSERT INTO kca_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Лот ики ким этәс пӑ веӈа верты ўтщийәм ŏтӈиԓаԓ пиԓән пŏтәртәс, пӑ йастәс: «Нŏх ԓойатән, тӑм тӑха эԓты мӑнатән, Турәм Куща тӑм вош пӑратԓәԓы». Туп ԓын ԓўвеԓа ӑт эвәԓсәтән. ");
INSERT INTO kca_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Аԓәӈсӑхата йўвмаԓән, ангелӈән Лот ики тэрматты питсәԓән, щиты йастәман: «Нŏх киԓа, имен пӑ эвеӈәԓан ўйаԓән, тӑԓта йэԓ мӑнаты, нынана ԓыԓӈа хӑщты урәӈән, вош атәм верәт нӑӈена ӑт ат хойсәт». ");
INSERT INTO kca_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ԓўв пӑ ӑт тэрматыйәс, щишән, щи хŏйатӈән ԓўвеԓ пӑ ԓўв имеԓ пӑ ԓўв эвеӈәԓаԓ йошԓән эԓты катәԓман, ўсԓән пӑ вош кимпийа тусԓән, Турәм Куща йӑм сэмән Лот ики пеԓа ватмаԓ урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Вош кимпийа ԓывиԓаԓ тўвманән, итәԓ йастәс: «Нӑӈ ԓыԓэн шавийи; йŏхԓы аԓ ванта пӑ тӑм пайԓы мўвән иԓ аԓ ԓойԓыйа; нӑӈ ӑт ат пӑртсән, Кев ўрән шаваща». ");
INSERT INTO kca_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Лот ики пӑ ԓынана йастәс: «Ӑнта, Вŏԓаӈ Куща! ");
INSERT INTO kca_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Тӑта щи, Нӑӈ митхуйэн пеԓа Нӑӈ йӑм сэмән ватсән, ма уԓәпсайэм шавиты урәӈән Нӑӈ щи ԓŏват йӑм версән; туп ма Кев ўр унты хухәԓты ӑт верәтԓәм, тӑм шук эԓты ат шаващсәм пӑ ԓыԓӈа ат хӑщсәм, ");
INSERT INTO kca_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","тўм воша хухәԓты ваншәк, ԓўв ай; щи хухәԓты мӑнэм эсԓы, – ԓўв ай; ԓыԓэм па шавиԓэм». ");
INSERT INTO kca_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Пӑ ԓўвеԓа йастәс: «Нӑӈ урӈенән щит Ма па верԓэм: нӑӈ айәԓты вошен ӑт шўкатԓэм; ");
INSERT INTO kca_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","тэрматыйа, щита хӑԋэма, нӑӈ щи ӑт йŏхәттэн унты Ма верэм верты ӑт верәтԓэм». Щишән, щи вош Сигор нэмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Най нŏх этәс, хун Лот ики Сигор унты йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Щӑԓта, Турәм Куща Содом пӑ Гоморра вошӈән Турәм Куща эԓты турәм эԓты тўтәӈ кевәтән пӑ тўтән йэрт иты шошәпсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","щи вошӈән, пӑ щи пайԓы мўвәт, пӑ щи вошӈән хŏԓ хŏйатәт, пӑ мўвән энмәм ŏтәт хŏԓаԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Лот ики йўпийән йўвәм имеԓ йŏхԓы ӑӈкәрмәс, пӑ сŏԓаӈ акԓа мŏхты йис. ");
INSERT INTO kca_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Авраам аԓәӈсӑхат аԓәӈ нŏх киԓәс пӑ щи тӑхайа мӑнәс, хŏта Турәм Куща йэщаԓт щи йэԓпийән ԓойәс, ");
INSERT INTO kca_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Содом пӑ Гоморра вошӈән пӑ йŏхан ԉэпән уԓты мўвәт пеԓа ӑӈкәрмәс пӑ кащаԓәсԓы: щи мўв эԓты, ӑԓәм кур иты, пусәӈ нŏх этәс. ");
INSERT INTO kca_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Щиты ус, хун Турәм пайԓы мўв вошәт пӑратсәԓы, Турәм Авраам нŏмәсән иса тӑйсәԓы пӑ вошәт шўкатәм тӑха эԓты Лот ики йэԓ китсәԓы, хŏта Лот ики ус. ");
INSERT INTO kca_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Сигор эԓты Лот ики мӑнәс, Кев ўрән эвеӈәԓаԓ пиԓән уԓты питәс, ԓўв Сигор вошән уԓты пӑԓәс. Щита эвеӈәԓаԓ пиԓән хŏшапәӈ кев ԓыпийән ус. ");
INSERT INTO kca_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Щӑԓта ŏпеԓ апщеԓа йастәс: «Ащемән пирәщ, пӑ йŏх хŏйат тӑм мўвән ӑнтом, мин пиԓэмәнән уԓты урәӈән, хŏты мўв ԓŏватән уԓԓыйәԓ, ");
INSERT INTO kca_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","щишән, ащемән ўнайән йищәԓтәԓэмән, пӑ ащемән эԓты рутэмән йэԓԓы туԓэмән». ");
INSERT INTO kca_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Щи атән ԓын ащан йищәԓтәсԓән; ун эвеԓ ԓўв хŏщайәԓ ԓŏӈтыйәс; ащеԓ пӑ ӑт уйтәс, хун ԓўв ŏԓԓыйәс пӑ хун нŏх киԓәс. ");
INSERT INTO kca_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Кимет хӑтәԓ ŏпеԓ апщеԓа йастәс: «Мŏԓхатәԓ ма ащем хŏща ԓŏӈтысәм; тӑм ат ԓўвеԓ ўнайән па йищәԓтәԓэмән; пӑ нӑӈ ԓŏӈтыйа, ащемән эԓты рутэмән йэԓԓы туԓэмән». ");
INSERT INTO kca_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Щи ат ащан ўнайән па йищәԓтәсԓән; пӑ ай эвеԓ ԓўв хŏщайәԓ ԓŏӈтыйәс; ащеԓ па ӑт уйтәс, хун ԓўв ŏԓԓыйәс пӑ хун нŏх киԓәс. ");
INSERT INTO kca_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Щиты Лот ики эвеӈәԓаԓ ԓын ащан эԓты кинтак ԓавәрта йисӈән. ");
INSERT INTO kca_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ун эвеԓ пŏх тӑйәс, нэмән мӑсԓы: Моав. Ԓўв ин тӑм унты моав йох ащи. ");
INSERT INTO kca_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ай эвеԓ ищи пŏх тӑйәс, нэмән ԓўвеԓ мӑсԓы: Бен-Амми. Ԓўв ин тӑм унты аммон йох ащи. ");
INSERT INTO kca_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Авраам йэԓԓы Морты мўв пеԓа касԓәс, Кадес лот пӑ Сур мўв кўтән уԓты питәс; мŏԓты сыс Герар вошән ус. ");
INSERT INTO kca_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Авраам Сарра имеԓ эԓты щиты йастәс: «Ԓўв ма нэ апщем». Авимелех, Герар вош хон, Сарра ԓўв хŏщайәԓ туты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Атәԓән уԓәмән Авимелех хŏща Турәм йŏхтәс пӑ ԓўвеԓа йастәс: «Тӑм ими ўймен урәӈән нӑӈ сŏрма питԓән, ԓўв ики тӑйәԓ». ");
INSERT INTO kca_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Авимелех пӑ щи нэ хŏща ӑт кетмийәс пӑ йастәс: «Вŏсху! Нўрԓы мир пӑр мўй пӑратԓэн? ");
INSERT INTO kca_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Авраам мӑнэм йастәс: ‘Ԓўв ма нэ апщем’? Сарра пӑ йастәс: ‘Ԓўв ма йайәм’. Ма щит йӑм нŏмәсән версэм пӑ йошԓам сыстамәт». ");
INSERT INTO kca_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Щӑԓта Турәм ԓўвеԓ уԓәмән йастәс: «Ма ищи уйәтԓэм, щит нӑӈ йӑм нŏмәсән версэн, щишән, нӑӈен Ма йэԓпемән кӑрэк эԓты сайԓәптәсэм пӑ ԓўв хŏщайәԓ нӑӈен кетәмты ӑт эсәԓсэм; ");
INSERT INTO kca_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ин пӑ икеԓа имеԓ йŏхԓы мийи, ԓўв Турәм айкеԓ туты хŏйат пӑ нӑӈ урӈенән пойәкщәԓ, щиты нӑӈ ԓыԓӈа хӑщԓән; йŏхԓы ӑт мӑԓэн ки, уйты, хотәӈ ŏтԓан пиԓән нӑӈ сŏрма питԓән». ");
INSERT INTO kca_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Авимелех аԓәӈсӑхат аԓәӈ нŏх киԓәс, митйохԓаԓ хŏԓ вохсәԓы, щи йасӈәт ԓывиԓаԓ хŏԓ пŏтәртсәԓы; пӑ щи хŏйатәт шек пӑԓтәмәсәт. ");
INSERT INTO kca_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Щӑԓта Авимелех Авраам вохсәԓы пӑ ԓўвеԓа йастәс: «Мўй нӑӈ мўӈ пиԓэвән версән! Мўй атәм вермем урәӈән нӑӈ мӑнэм пӑ ма хон мўвем ун кӑрэка пайәтсэн? Нӑӈ ма пиԓэмән ӑт рӑхты верәт версән». ");
INSERT INTO kca_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Щӑԓта Авимелех Авраама йастәс: «Хŏты нӑӈ нумәссән, тӑмиты верменән?» ");
INSERT INTO kca_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраам йастәс: «Ма щиты нумәссәм, тӑм тӑхайән Турәм эԓты пӑԓты вер ӑнтом пӑ ма имем урәӈән ма веԓԓайәм; ");
INSERT INTO kca_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ԓўв пӑ йӑна ма нэ апщем: ԓўв ма ащем эви, туп ӑнта ма аԋԏэм тӑйәм эви; щӑԓта ма имема йис; ");
INSERT INTO kca_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Турәм мӑнэм ащем хот эԓты мўв хўват йӑхты китмаԓән, ма ԓўвеԓа щиты йастәсәм: ‘Щи ԓŏват йӑм вера, хŏԓта кепа мин ӑт йŏхәтԓәмән, иса ма эԓтэм пŏтәрта: ‘Щит ма йайәм’». ");
INSERT INTO kca_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Щӑԓта Авимелех ай пӑ ун йош вой, митйох пӑ митнэӈәт Авраама мӑсԓы; Сарра имеԓ па йŏхԓы мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Щӑԓта Авимелех йастәс: «Тӑта щи, ма мўвем нӑӈ йэԓпенән; уԓа, хŏта нӑӈена ԓэщаԓәԓ». ");
INSERT INTO kca_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Саррайа пӑ йастәс: «Тӑта щи, ма нӑӈ йайәна щŏрәс сикль щел ŏх мӑсәм; тӑм мойԓәпса нӑӈена, нӑӈ хŏйатԓан ат уйәтԓэԓ, нӑӈ иса вещкат пӑ нэмәԓты атәм ӑт версән». ");
INSERT INTO kca_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Щӑԓта Авраам Турәм пеԓа пойәкщәс, пӑ щӑԓта Авимелех, пӑ ԓўв имеԓ, пӑ ԓўв митнэԓаԓ Турәмән хŏԓ йӑмәԓсайәт, пӑ ԓыв ԋаврэм тӑйты питсәт; ");
INSERT INTO kca_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Авраам Сарра имеԓ урәӈән Авимелех хотән ԋаврэм тӑйты вер Турәм Куща вŏԓытысԓы. ");
INSERT INTO kca_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Турәм Куща, йастымаԓ щирән, Сарра пеԓа щи арат йӑм ус пӑ, хŏты ԓўвеԓа йастыԓыйәс, щиты версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Сарра ԓавәрта йис пӑ Авраама пŏх сэма пайтәс, Авраам пирщамәм йўпийән, вŏԓԓы щи пŏрайән, хŏты Турәмән ԓўвеԓа йастыԓыса; ");
INSERT INTO kca_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Авраам ԓўв хŏщайәԓ сэма питәм пŏхәԓа, Саррайән ԓўвеԓа тӑйәм пŏхәԓа, Исаак нэм пŏнәс; ");
INSERT INTO kca_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","щӑԓта, Авраам Исаак пŏхәԓ эвәтты щирән ԋийәԓмет хӑтәԓән версәԓы, хŏты Турәм ԓўвеԓа партәс. ");
INSERT INTO kca_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Исаак пŏхәԓ ԓўв хŏщайәԓ сэма питәмән, Авраам нуптәԓ сот тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Сарра йастәс: «Турәмән ԋӑхты партсайәм; хŏй ма эԓтэм хуԓәԓ, ма пиԓэмән ԋӑхты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Щӑԓта па йастәс: «Хŏй Авраама, ԓуԓән, йастәс: ‘Сарра ԋаврэм эсәмән ԓапәтты питәԓ’? Ԓўв пирща йўвмаԓ йўпийән ма пŏх тӑйсәм». ");
INSERT INTO kca_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ԋаврэм энмәс пӑ эсәм эԓты вŏԓытса; Исаак эсәм эԓты вŏԓытәм хӑтәԓән Авраам йӑм ԓэтотәӈ пӑсан верәс. ");
INSERT INTO kca_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Щӑԓта Сарра кащаԓәсԓы, хŏты Египет нэ Агарь тӑйәм пŏх ԓўв Исаак пŏхәԓ эԓты ԋӑхәԓ, ");
INSERT INTO kca_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","пӑ Авраама йастәс: «Тӑм митнэ пŏхәԓ пиԓән вошты, ищипа тӑм митнэ пŏх ма Исаак пŏхем пиԓән нӑӈ хӑйты тащен ортты ӑт питԓәԓы». ");
INSERT INTO kca_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Авраама щит щикем ӑт ԓэщаԓәс, Измаил ищи ԓўв пŏхәԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Турәм пӑ Авраама щиты йастәс: «Нŏпсэн ӑт ат шӑкәԓ энәмты пŏхен пӑ митнэӈен урәӈән; мўй Сарра нӑӈена йастәԓ, иса ԓўвеԓ хуԓәнта, туп Исаак хўват тӑйты тыхԓэнән Ма нӑӈена партәм ԋаврэмԓам питԓәт; ");
INSERT INTO kca_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","митнэӈен пŏх эԓты Ма ищи мир энмәԓԓәм, ԓўв ищи нӑӈ ԋаврэмен». ");
INSERT INTO kca_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Авраам аԓәӈсӑхат аԓәӈ киԓәс, ԋаԋ пӑ йик тӑйты хир ўс, пӑ щит иса Агарь ԓӑкра пŏтсәԓы, пӑ пŏхәԓ пиԓән ԓўвеԓ йэԓ китсәԓы. Агарь мӑнәс пӑ Вирсавия таԓ хишәӈ мўвән тӑпәс, ");
INSERT INTO kca_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","хирән йиӈкәԓ хŏԓас пӑ пŏхәԓ варәс похәл иԓпийән хӑйсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","щӑԓта йэԓшәк мӑнәс, и ԋоԓ йўвәтты хўватән иԓ опсәс. Щиты ԓўв йастәс: «Энәмты пŏх пӑрты щир ватты ӑт ԓӑӈхаԓайәм». Ԓўв опсәс пӑ ўвты питәс пӑ хоԓԓәс; ");
INSERT INTO kca_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Турәм энәмты пŏх тўр сый хуԓтсәԓы; Турәм ангел турәм эԓты Агарь ўваԓтсәԓԓы пӑ йастәс: «Хŏты йисән, Агарь? Аԓ пӑԓа; Турәм энәмты пŏх тўр сый щиԓта, хŏта ԓўв уԓ, хўԓтсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","нŏх ԓойа, энәмты пŏхен нŏх ԓощәԓты пӑ йошәԓ эԓты катԓы, Ма вŏԓаӈ мир ԓўв эԓтэԓ этәԓтәԓәм». ");
INSERT INTO kca_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Щӑԓта, Турәмән йушән аԉса пӑ, ԓўв йик ўты мўв ўс кащаԓәс, щи мӑнәс, хирәԓ йикән тэкәптәсԓы пӑ пŏхәԓ йищәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Турәм энәмты пŏх пиԓән ус, ԓўв энмәс, пӑ таԓ хишәӈ мўвән уԓты питәс, ԋоԓәӈ-йухԓәӈ вой веԓты хуйа йис. ");
INSERT INTO kca_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Фаран нэмпи таԓ хишәӈ мўвән ԓўв ус; Египет мўв эԓты аԋԏэԓән нэӈән ўса. ");
INSERT INTO kca_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Щи ишән Авимелех хон, Фихол ԉаԉ йох кущайәԓ пиԓән, Авраама йастәс: «Турәм иса нӑӈ пиԓэнән, мўй вер кепа нӑӈ ӑт верԓән; ");
INSERT INTO kca_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","щишән, Турәм ватман мӑнэма тӑта йасәӈ мийа, нӑӈ мӑнэма, ма пŏхема, ма хиԓэма атәм ӑт верԓән; хŏты ма нӑӈ пиԓэнән йӑма верәт версәм, хун нӑӈ тӑм мўва уԓты йŏхәтсән, щиты нӑӈ па, ма пиԓэмән пӑ тӑм мўв пиԓән, верәт верты питԓән». ");
INSERT INTO kca_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Авраам йастәс: «Ма йасәӈ мӑԓәм». ");
INSERT INTO kca_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Авраам Авимелех пеԓа туп йик ўты мўв ўс урәӈән ўшмащәс, Авимелех митйохәтән нŏх ўйәм урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Авимелех пӑ йастәс: «Ӑт уйәтԓэм, хŏй щит верәс, нӑӈ пӑ мӑнэма ӑт йастәсән; ма щит эԓты ин тӑм унты ӑт хуԓԓысэм». ");
INSERT INTO kca_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Щӑԓта Авраам ошәт пӑ мисәт ўс пӑ Авимелеха мӑсԓы, щиты ԓын йастантәпса версәтән. ");
INSERT INTO kca_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ԓапәт нэ ош вой тащ эԓты Авраам атэԓт ўсԓы. ");
INSERT INTO kca_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Авимелех пӑ Авраама йастәс: «Мўйа ԓапәт нэ ош нӑӈ атэԓт ўсән?» ");
INSERT INTO kca_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Авраам йастәс: «Тӑм ԓапәт нэ ош ма йошем эԓты ўйи, щит щӑха нумты урәӈән, тӑм йик ўты мўв ўс ма хирсэм, ԓўв мӑнэм». ");
INSERT INTO kca_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Щишән, щи лот Вирсавия нэмән мӑсԓы, щита ԓын кўтәнән йасәӈ мӑстән. ");
INSERT INTO kca_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Щиты ԓын Вирсавия нэмпи тӑхайән йастантәпса версәтән. Авимелех хон ԓўв Фихол ԉаԉ йох кущайәԓ пиԓән ԓойсәт пӑ филистимәт мўва йŏхԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Вирсавия хŏща Авраам дуб йўхәӈ йохәм опсәс, щита Турәм Куща пеԓа, веккеша уԓты Турәм пеԓа, пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Авраам филистимәт мўвән ӑԓ йŏхтыԓыты хŏйат щирән йӑм хўв кўт ус. ");
INSERT INTO kca_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Щиты ус, Турәм щи верәт йўпийән Авраам эвәԓты вер артаԓәсԓы. Пӑ щиты ԓўвеԓа йастәс: «Авраам!» Ԓўв йŏхԓы йастәс: «Ма щи». ");
INSERT INTO kca_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Турәм йастәс: «Сӑм вŏшән тӑйты аратәԓ и пŏхен, Исаак пŏхен, ўйи пӑ Мориа мўва мӑна; пӑ щита и кев ўр Ма нӑӈен аԉԓәм, щита ԓўвеԓ йира туты урәӈән нŏх ўщиты». ");
INSERT INTO kca_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Авраам аԓәӈсӑхат аԓәӈ нŏх киԓәс, осёл войәԓ нŏх киртсәԓы, кӑт энәмты митху пӑ Исаак пŏхәԓ пӑтән ўсԓы; йир ўщитты урәӈән тўт йўх хӑлытәс, пӑ щӑԓта нŏх ԓŏйәс пӑ Турәм аԉәм тӑха пеԓа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Хуԓмет хӑтәԓән Авраам хўвәԓта щи тӑха шийаԓәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Энәмты митхуйӈәна Авраам йастәс: «Нын тӑта осёл войән пиԓән хӑщатән, мин пӑ пŏхем пиԓән тŏхи мӑнԓәмән пӑ пойәкщәԓмән, пӑ щӑԓта нын хŏщайән йŏхԓы йŏхәтԓәмән». ");
INSERT INTO kca_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Авраам йир ўщитты тўт йўх ўс, пӑ Исаак пŏхәԓа шӑнша пŏтсәԓы; ԓўв пӑ йоша тўт пӑ кеши ўс, пӑ ԓын йӑха мӑтсәтән. ");
INSERT INTO kca_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Щӑԓта Исаак Авраам ащеԓ пеԓа пŏтәртты питәс, пӑ йастәс: «Ащийэ!» Ԓўв пӑ йŏхԓы йастәс: «Хŏты, пŏхийэ». Пŏхәԓ йастәс: «Тӑта тўт йўх пӑ тўт, хŏта пӑ йира ўщитты ош пŏшәх?» ");
INSERT INTO kca_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Авраам йастәс: «Турәм Ԓўвеԓа йира ўщитты ош уйәтәԓ, пŏхийэ». Пӑ ԓын йӑха йэԓԓы мӑтсәӈән. ");
INSERT INTO kca_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Щӑԓта Турәм йастәм тӑхайа йŏхәтсәтән; Авраам щита йирасты нŏрәм верәс, тўт йўхәт пŏнәс, пӑ Исаак пŏхәԓ йӑрман йирасты нŏрма йўхәт эԓты пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Щӑԓта Авраам ԋиншәмтыйәс пӑ кеши аԓэмәс, пŏхәԓ пŏткәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Туп Турәм Куща ангел турәм эԓты ԓўв пеԓайәԓ ўваԓтәс: «Авраам! Авраам!» Ԓўв йастәс: «Ма щи». ");
INSERT INTO kca_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ангел йастәс: «Пŏхен эԓты йошен аԓ аԓми пӑ ԓўв пиԓәԓән нэмәԓты аԓ вера, ин Ма уйәтԓэм, Турәм эԓты нӑӈ пӑԓԓән, пӑ аратәԓ и пŏхен Мӑнэма мӑты ӑт щаԉәтсэн». ");
INSERT INTO kca_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Щӑԓта Авраам йŏхԓы ӑӈкәрмәс пӑ кащаԓәсԓы: тӑта щи, ԓын йўпанән хӑш похәлән оӈәтԓаԓән ош йŏвәртымаԓ. Авраам мӑнәс, ош ўсԓы пӑ пŏхәԓ йўкана йира ўщитты тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Авраам щи тӑха нэмән мӑсԓы: Иегова-ире. Щишән интӑм унты йастәԓа: «Турәм Куща кевән уйәтты питԓа». ");
INSERT INTO kca_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Щӑԓта Турәм Куща ангел кимет пўш турәм эԓты Авраам пеԓа йасәӈ тӑйәс ");
INSERT INTO kca_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","пӑ щиты йастәс: «Мӑнэмән йасәӈ мӑԓәм, Турәм Куща йастәԓ, тӑм вер вермен урәӈән, нӑӈ пŏхен, аратәԓ и пŏхен ӑт щаԉәтсэн, ");
INSERT INTO kca_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","щишән Ма нӑӈен ар йӑмән мӑԓэм пӑ нӑӈ тыхәԓ тэԓэн арәԓ ара йиԓ, турәм хусәт арата пӑ щарәс сыԓ сэй хиш арата; ԓыв пиԓԓаԓән ԉаԉәсты ŏтәт вошԓаԓ нӑӈ тыхәԓ тэԓэн ԓыв йошԓаԓа пайәтԓәԓаԓ; ");
INSERT INTO kca_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","нӑӈ тыхԓэн хўват мўв ԓŏватән уԓты мирәт хŏԓ йӑмән мӑԓайәт нӑӈ Ма йасӈема хуԓтмәмен урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Щӑԓта Авраам энәмты митхуйӈәԓаԓ хŏща йŏхтәс, пӑ щӑԓта хŏԓ йӑха Вирсавияйа мӑтсәт; Авраам Вирсавия тӑхайән уԓты хӑщәс. ");
INSERT INTO kca_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Щи верәт йўпийән Авраам айкеԓән йŏхәтса, йастәса: «Нахор апщена Милка имеԓ ищи пŏхәт сэма пайәтмаԓ: ");
INSERT INTO kca_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","оԓәӈ ŏтәԓ Уц, Вуз апщеԓ, Кемуил, Арам ащи, ");
INSERT INTO kca_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Кесед, Хазо, Пилдаш, Идлаф пӑ Вафуил». ");
INSERT INTO kca_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Вафуил эԓты Ревекка сэма питәс. Ԋийәԓ пŏх Милка сэма пайтәс, Нахор икеԓа, Авраам апщийа. ");
INSERT INTO kca_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Нахор Реума нэмпи ай нэӈәԓ Тевах, Гахам, Тахаш пӑ Мааха ищи сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Сарра уԓәм нуптәԓ сот хус ԓапәт тӑԓ арат ус: щит Сарра уԓәм тӑԓәт; ");
INSERT INTO kca_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Кириаф-Арба хŏща, щит ин Хеврон, щита Ханаан мўвән Сарра пӑрәс. Авраам ԓўв урӈәԓән хоԓԓәты пӑ йирӈәԓтыты йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Щӑԓта пӑрәм ŏтәԓ эԓты йэԓшәк мӑнәс пӑ хет йох пиԓән пŏтәртты питәс, пӑ йастәс: ");
INSERT INTO kca_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Ма нын хŏщайән пўӈәԓта йŏхтәм пӑ мўвемәм хŏйат, пӑрәм ŏтэм иԓ шавиты урәӈән мӑнэма йŏра тӑйты мўв тыныйаты». ");
INSERT INTO kca_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Хет йох Авраама щиты йŏхԓы йастәсәт: ");
INSERT INTO kca_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Куща ики, мўӈ йасӈева хуԓәнта; нӑӈ мўӈ кўтэвән Турәм кӑнащ; мет йӑмшәк лоттәты тӑхайԓувән нӑӈ пӑрәм ŏтэн шавийи; мўӈ йŏра лоттәты тӑхайԓувән нӑӈ пӑрәм ŏтэн шавитэн урәӈән, нэмәԓты хŏйат мўӈ эԓтэв нӑӈена шŏппи йасәӈ ӑт йастәԓ». ");
INSERT INTO kca_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Авраам нŏх ԓойәс пӑ щи мўв мир пеԓа, хет йох пеԓа, ŏх пŏнман, иԓ ԋўрәс; ");
INSERT INTO kca_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","пӑ Авраам ԓывиԓаԓа йастәс: «Нын щиты кашащԓәты ки, пӑрәм ŏтэм ат лоттәсэм, щишән, мӑнэм хуԓәнтаԓән, Цохар пŏх Ефрон ма урӈемән иԋщәсаты, ");
INSERT INTO kca_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ԓўв мўв хӑрәԓ сыԓән Махпела хŏща уԓты хŏшапәӈ кев, лоттәты урәӈән, мŏрт тынән мӑнэма нын ватман ат тыныԓԓы». ");
INSERT INTO kca_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ефрон пӑ хет йох кўтән опсәс; пӑ щӑԓта Ефрон, хет ху, вошәӈ пушасәԓ ун ова ԓŏӈтыты хет йох хŏԓ хуԓман, Авраам пеԓа щиты йастәс: ");
INSERT INTO kca_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Ӑнта, кущайэм, мӑнэм хуԓәнты: мўв хӑр пӑ щита уԓты хŏшапәӈ кев ма нӑӈена мӑԓэм, мирэм ватман, нӑӈена мойԓәԓэм, нӑӈ пӑрәм ŏтэн лотты». ");
INSERT INTO kca_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Авраам щи мўвәӈ мир йэщаԓт, ŏх пŏнман, иԓ ԋўрәс, ");
INSERT INTO kca_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","пӑ, мир хуԓәтман, Ефрон пиԓән пŏтәртәс пӑ йастәс: «Ма пеԓайэм хуԓтмәԓән ки, ма нӑӈена щи мўв хӑр урәӈән тын мӑԓәм; ма эԓтэм ўйи, пӑ ма пӑрәм ŏтэм щита лоттәԓэм». ");
INSERT INTO kca_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ефрон Авраам пеԓа йŏхԓы пŏтәртәс пӑ йастәс: ");
INSERT INTO kca_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Кущайэм! Мӑнэм хуԓәнта: щи мўв тынәԓ щел ŏхән ԋӑԓсот сикль; нӑӈена пӑ мӑнэма щит мўй ар? Пӑрәм ŏтэн лотты». ");
INSERT INTO kca_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Авраам Ефрон пиԓән кашащәс пӑ Ефрона Авраам щел ŏх пусмекԓәс пӑ мӑс, мўй арат ԓўв, хет мир хуԓәтман, йастәс, щел ŏхән ԋӑԓсот сикль, вŏсйох тынасты щирән. ");
INSERT INTO kca_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Щиты Ефрон мўв хӑр, Махпела хŏща, Мамре пўӈәԓән, щи тӑха пӑ щита уԓты хŏшапәӈ кев, керәтман энәмты йўхәт пиԓән, ");
INSERT INTO kca_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","щит иса, вошәӈ пушас ун ова ԓŏӈтыты хет йох ватман, Авраам йоша питәс. ");
INSERT INTO kca_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Щи йўпийән Авраам, Сарра, ԓўв имеԓ, лоттәсԓы, Махпела хŏща уԓты хŏшапәӈ кев ԓыпийән, Мамре пўӈәԓән, щит тӑм пŏрайән Хеврон вош, Ханаан мўвән. ");
INSERT INTO kca_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Щиты хет йох эԓты мўв хӑр Авраам йоша питәс, пӑ щита уԓты хŏшапәӈ кев, ԓўв мŏхиԓаԓ лоттәты урәӈән па. ");
INSERT INTO kca_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраам пирщамәса пӑ тӑԓԓаԓ арәт усәт. Турәм Кущайән кашәӈ вер хŏща Авраам йӑмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Щӑԓта Авраам хотәԓән уԓты, ԓўв тӑйты хŏԓ мŏԓтыԓаԓ ԓэщатты, куща митхуйәԓа йастәс: «Ма пещем иԓпийа йошен пŏныԓыйи ");
INSERT INTO kca_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","пӑ Турәм Кущайән, опәԉ Турәмән пӑ мўв Турәмән, мӑнэма йасәӈ мийа, ханаан йох эвет эԓты, хŏйтат кўтән ма уԓԓәм, нӑӈ ма пŏхема нэ ӑт ўԓән, ");
INSERT INTO kca_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","пӑ ма мўвема, ма энмәм мўвема йӑхԓән пӑ Исаак пŏхема нэ щиԓта ўԓән». ");
INSERT INTO kca_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Митхуйәԓ ԓўвеԓа йастәс: «Мосәӈ, тӑм мўва щи нэ ма пиԓэмән йиты ӑт кашащәԓ, мосәӈ, нӑӈ мўвена, хŏԓща нӑӈ этсән, пŏхен туты мосәԓ?» ");
INSERT INTO kca_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Авраам ԓўвеԓа йастәс: «Ма эԓтэм пӑԓԓән ки, пŏхем тŏхи аԓ тўви; ");
INSERT INTO kca_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Турәм Куща, ŏпәԉ Турәм, Хŏй ащем хот эԓты мӑнэм сэма питәм мўвем эԓты ўсԓы, пӑ Хŏй мӑнэм йасәӈ мӑс, пŏтәртман: ‘Йэԓԓы уԓты ԋаврэмԓана тӑм мўв мӑԓэм’, – Ԓўв ангеләԓ нӑӈ йэԓпенән китԓәԓы, пӑ нӑӈ пŏхема щиԓта нэ ўԓән; ");
INSERT INTO kca_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","нӑӈ пиԓэнән щи нэ йиты ӑт ки кашащәԓ, мӑнэма мийәм тӑм йасӈен эԓты нӑӈ веләк питԓән; туп пŏхем тŏхи аԓ тўви». ");
INSERT INTO kca_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Авраам кущайәԓ пещ иԓпийа митхуйәԓ йошәԓ пŏтсәԓы пӑ ԓўвеԓа йасәӈ мӑс. ");
INSERT INTO kca_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Кущайәԓ верблюдәт эԓты митхуйәԓ йаӈ верблюд ўс пӑ мӑнәс. Кущайәԓ эԓты ар сыр тынәӈ мойԓәпсайәт ԓўв пӑтән тӑйәс. Месопотамия мўва, Нахор уԓәм воша, ԓўв мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Йӑм хўв мӑнман, ԓўв йэтна пеԓа йик ўты мўв ўс пўӈәԓән, вош кимәԓән, верблюдԓаԓ иԓ ԓойәԓттәсԓы, щи пŏрайән, хун нэӈәт йик аԓтты йŏхтыԓыԓәт, ");
INSERT INTO kca_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","пӑ йастәс: «Турәм Куща, Авраам кущайэм Турәм! Тӑм хӑтәԓ эви ма йэщаԓтэм киты пӑ Авраам кущайэма щи ԓŏват йӑм этәԓта; ");
INSERT INTO kca_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","тӑта щи ма, йик ўты тӑхайән ԓойԓәм, пӑ вошәӈ хŏйатәт эвет йик ӑмәртты йŏхтыԓыԓәт; ");
INSERT INTO kca_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","и эви, хŏйа ма йастәԓәм: ‘Сŏхта пўтэн иԓшәк эсԓыйи, ма йик йищԓәм’, хŏй пӑ мӑнэма йастәԓ: ‘Йиԋща, ма нӑӈ верблюдԓана па йищты мӑԓәм’, – щи эви щи Нӑӈ Исаак митхуйэна Нӑӈ ԓэщатсэн; щиты ма мŏштәԓэм, Нӑӈ ма Авраам кущайэма щи ԓŏват йӑм этәԓтәсэн». ");
INSERT INTO kca_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ԓўв хŏԓна пойәкщәты ӑт йэтшәс, тӑта щи, сŏхта пўт ԓӑкра пŏнман Ревекка этәс, хŏй Вафуил эԓты сэма питәс, Вафуил щит Нахор пӑ Милка пŏх, Нахор пӑ Авраам апщи ус; ");
INSERT INTO kca_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","эви хŏрасәӈ ус, ху сайән ӑт уԓәм айԓат нэ. Ԓўв йик аԓтты тӑхайа ŏхԓәс, сŏхта пўтәԓ тэкәптәсԓы пӑ нŏхԓы шушәс. ");
INSERT INTO kca_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Митху ԓўв йэщаԓтәԓ хухәԓмәс пӑ йастәс: «Сŏхта пўтэн эԓты мӑнэм йик йищты йэша мийа». ");
INSERT INTO kca_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ԓўв йастәс: «Йиԋща, кущайэм». Ищи мŏхты сŏхта пўтәԓ йоша иԓ эсәԓсәԓы пӑ ԓўвеԓ йищәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ԓўвеԓ йищәԓтәмаԓ йўпийән йастәс: «Верблюдԓан урәӈән йик ӑмәртты ищи верәтԓәм, мŏрта йищтэԓ унты». ");
INSERT INTO kca_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ищи мŏхты йиӈкәԓ сŏхта пўтәԓ эԓты хўрыйа шошәпсәԓы, щӑԓта пӑ йик ўты мўв ўс хŏща йик ӑмәртты хухәԓмәс, щиты хŏԓ ԓўв верблюдԓаԓ урәӈән йик ӑмәртәс. ");
INSERT INTO kca_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Щи хŏйат мӑшйайән ԓўв пеԓайәԓ вантәс, шек такан нумәсәс, йӑна мўй Турәм Кущайән йŏхтәм йушәԓ йӑмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Хун верблюдәт йищты йэтшәсәт, щи хŏйат ԋŏԓән тӑйты сорԋэӈ ԓуйәт ўс, и сикль шуп ԓавәрт арат, пӑ кӑт сорԋэӈ йош сур кўсы, кашәӈ ŏт йаӈ сикль ԓавәрт арат, пӑ эвийа щитәт мӑсԓы; ");
INSERT INTO kca_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","пӑ йастәс: «Нӑӈ хŏй эви? Мӑнэм йаста, нӑӈ ащен хотән мўӈев хоԓты тӑха уԓ мўй?» ");
INSERT INTO kca_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ԓўв йастәс: «Ма Вафуил эви, ԓўв Нахор пӑ Милка пŏх». ");
INSERT INTO kca_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Щӑԓта хŏԓна ԓўвеԓа йастәс: «Мўӈ хŏщайэв сорәм тŏрән пӑ вой ԓапәтты ԓат уԓ, хоԓты тӑха ищи уԓ». ");
INSERT INTO kca_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Щи хŏйат, ŏх пŏнман, иԓ ԋўрәс пӑ Турәм Куща ишәксәԓы, ");
INSERT INTO kca_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","пӑ йастәс: «Турәм Кущайа ун ишәк йасәӈ, Авраам кущайэм Турма, Хŏй ма кущайэм Ԓўв йӑм верәԓән пӑ Ԓўв вещкатәԓән ӑт хӑйсәԓы! Турәм Куща тўӈ йушән кущайэм апщеԓ хота мӑнэм тусԓы». ");
INSERT INTO kca_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Эви хухәԓмәс пӑ щит эԓты аԋԏэԓ хотән пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ревекка Лаван нэмпи йай тӑйәс. Лаван йик ўты тӑхайа щи хŏйат хŏща хухәԓмәс. ");
INSERT INTO kca_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Хун ԓўв ԋŏԓән тӑйты сорԋэӈ ԓуйәт пӑ йош сурән тӑйты кўсэт ԓўв апщеԓ хŏща кащаԓәс, пӑ Ревекка апщеԓ йасӈәт хуԓәс: «Щиты ма пиԓэмән тӑм хŏйат пŏтәртәс», ԓўв щи хŏйат хŏща йŏхтәс, пӑ тӑта щи, ԓўв верблюдәт пўӈәԓән йик ўты тӑхайән ԓойәԓ; ");
INSERT INTO kca_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Лаван йастәс: «Турәм Кущайән йӑмән мийәм хŏйат, мўйа кӑмән ԓойԓән? Йŏхи ԓŏӈа, хот пӑ верблюдԓан ŏԓты тӑха ма ԓэщатсәм». ");
INSERT INTO kca_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Щи хŏйат хота ԓоӈәс. Лаван верблюдәт эсәԓсәԓы пӑ сорәм тŏрәнән пӑ ԓатән мӑсԓы, пӑ щӑԓта, ԓўвеԓа пӑ ԓўв пиԓәԓән йŏхтәм хŏйатԓаԓа, кўрԓаԓ ԉŏхәтты йик тус; ");
INSERT INTO kca_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","пӑ пӑсан верса, туп ԓўв йастәс: «Верэм пŏтәрттэм унты ԓэты ӑт питԓәм». Пӑ йастәсәт: «Пŏтәрта». ");
INSERT INTO kca_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ԓўв йастәс: «Ма Авраам митху; ");
INSERT INTO kca_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Турәм Куща ма кущайэм ар йӑмән мӑсԓы, пӑ ԓўв тащәӈа йис: ошәт пӑ хор мисәт, щел ŏх пӑ сорԋи, митйохәт пӑ митнэӈәт, верблюдәт пӑ осёл войәт Авраама Ԓўв мӑс; ");
INSERT INTO kca_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","кущайэм Сарра имеԓ, пирща йўвмаԓ йўпийән, кущайэма пŏх сэма пайтәс, пӑ Авраам кущайэм мўй тӑйәс, иса ԓўвеԓа мӑсԓы; ");
INSERT INTO kca_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","кущайэм ма эԓтэм йасәӈ ўс, йастәман: ‘Ханаан йох эвет эԓты, хŏйтат кўтән ма уԓԓәм, нӑӈ ма пŏхема нэ аԓ ўйа, ");
INSERT INTO kca_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","пӑ ащем хота пӑ рутԓам хŏща йӑӈха, пӑ пŏхема нэ щиԓта ўԓән’. ");
INSERT INTO kca_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Кущайэма ма йастәсәм: ‘Мосәӈ, ма пиԓэмән нэ ӑт мӑнәԓ’. ");
INSERT INTO kca_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ԓўв мӑнэма йастәс: ‘Турәм Куща, Хŏй йэԓпийән ма уԓԓәм, Ԓўв ангеләԓ нӑӈ пиԓэнән китԓәԓы пӑ йушен йӑмән пӑртԓәԓы, пӑ рутԓам эԓты ащем хŏт эԓты пŏхема нэ ўԓән; ");
INSERT INTO kca_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","мӑнэма мийәм йасӈен эԓты нӑӈ веләк питԓән, хун рутԓам хŏща йӑхԓән; ԓыв нӑӈена нэ ӑт ки мӑԓәт, мийәм йасӈен эԓты веләк питԓән’. ");
INSERT INTO kca_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Щӑԓта йик ўты тӑхайа ма тӑм хӑтәԓ йŏхәтсәм пӑ йастәсәм: ‘Турәм Куща, Авраам кущайэм Турәм! Нӑӈ ма мӑнты йушем йӑмән партԓэн ки, ");
INSERT INTO kca_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","тӑта щи, йик ўты тӑхайән ма ԓойԓәм, пӑ эви, хŏй йик ӑмәртты этәԓ, ԓўвеԓа ма йастәԓәм: ‘Сŏхта пўтэн эԓты мӑнэма йэша йищты мийа’, ");
INSERT INTO kca_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","хŏй пӑ мӑнэма йастәԓ: ‘Нӑӈ йиԋща, верблюдԓана йик ищи ӑмәртԓәм’, – щит щи нэ, хŏй Турәм Куща ма кущайэм пŏха ԓэщатсәԓы’. ");
INSERT INTO kca_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Щи нŏпсэм хŏԓна пӑтэԓ унты ӑт тусэм, хун Ревекка этәс, пӑ сŏхта пўтәԓ ԓӑкрәԓән, йик ўты тӑхайа ŏхԓәс, йик ӑмәртәс; пӑ ма ԓўвеԓ йастәсәм: ‘Мӑнэма йик йищты мийа’. ");
INSERT INTO kca_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ԓўв ищи кумән сŏхта пўтәԓ иԓ эсәԓсәԓы пӑ йастәс: ‘Йиԋща, верблюдԓан ищи йищәԓтәԓԓам’. Пӑ ма йищсәм, верблюдԓам пӑ ԓўв йищәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ма ԓўвеԓ иԋщәссэм пӑ йастәсәм: ‘Нӑӈ хŏй эви?’ Ԓўв йастәс: ‘Вафуил эви, ԓўв Нахор пӑ Милка пŏх’. Щӑԓта ма ԓўвеԓ ԋŏԓән тӑйты сорԋэӈ ԓуйәт пӑ йош сур кўсэт йошӈиԓаԓа пŏтсәм. ");
INSERT INTO kca_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ма пӑ, ŏх пŏнман, иԓ ԋўрсәм пӑ Турәм Куща ишәксэм, пӑ Турәм Кущайа йӑм йасәӈ йастәсәм, Авраам кущайэм Турма, Хŏй тўӈ йуш хўват мӑнэм ты тусԓы, кущайэм апщи хиԓынэ ԓўв пŏхәԓа нэӈа ўты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ин пӑ мӑнэма йастаты, ма кущайэма щи ԓŏват йӑм пӑ вещкат вер верты нŏмәс нын тӑйԓәты мўй ӑнта? Щит щи мӑнэма йастаты, мӑнэма йэԓԓы верәт тўӈащира верты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Лаван пӑ Вафуил йŏхԓы йастәстән: «Турәм Куща эԓты тӑм вер уԓ; мўӈ нӑӈена атәм пӑ йӑм йастәты ӑт верәтԓув; ");
INSERT INTO kca_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","тӑта щи, Ревекка нӑӈ йэԓпенән; ԓўвеԓ ўйи пӑ мӑна; Турәм Куща йастәм щирән, кущайэн пŏх имийа ԓўв ат питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Авраам митху ԓын йасәӈԓән хуԓмаԓән, мўв унты, ŏх пŏнман, иԓ ԋўрәс пӑ Турәм Куща ишкәс. ");
INSERT INTO kca_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Щӑԓта митху щел ŏх пӑ сорԋэӈ пŏрмасәт этәԓтәс, пӑ ԓумәтты сŏхәт, пӑ Ревеккайа мӑсԓы; йайәԓа пӑ аԋԏэԓа ищи тынәӈ мойԓәпсайәт мӑс. ");
INSERT INTO kca_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Щӑԓта ԓўв пӑ ԓўв пиԓәԓән уԓәм хŏйатәт ԓэсәт, йищсәт пӑ хоԓсәт. Аԓәӈсӑхат нŏх киԓмеԓән, ԓўв йастәс: «Кущайэм хŏща мӑнэм эсԓаԓән». ");
INSERT INTO kca_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Туп йайәԓ пӑ аԋԏэԓ йастәсӈән: «Эвев мўӈ пиԓэвән йаӈԓэм хӑтәԓ ат уԓ, щи йўпийән мӑнԓән». ");
INSERT INTO kca_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ԓўв пӑ ԓынана йастәс: «Мӑнэм аԓ рŏнаԓтаԓән, Турәм Куща ма йушем йӑмән партсәԓы; мӑнэм эсԓаԓән, кущайэм хŏща ма мӑнԓәм». ");
INSERT INTO kca_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ԓын йастәсӈән: «Эвемән вохԓэмән пӑ иԋщәсԓэмән, мўй ԓўв йастәԓ». ");
INSERT INTO kca_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ревекка вохсэԓән пӑ ԓўвеԓа йастәсӈән: «Тӑм хŏйат пиԓән мӑнԓән?» Ԓўв йастәс: «Мӑнԓәм». ");
INSERT INTO kca_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Щӑԓта Ревекка, ԓыв апщеԓ, пӑ ԓўвеԓ эсәмән ԓаптәм ими, пӑ Авраам митху хŏйатԓаԓ пиԓән, Ханаан мўва китсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ревеккайа Турәм эԓты йӑм вохсәт пӑ ԓўвеԓ йастәсәт: «Апщийэв! Щŏрсәӈ щŏрсәт нӑӈ эԓтэн сэма ат питԓәт, нӑӈ тыхԓэн ԋаврэмәт пеԓа ԉик туты ŏтәт вошԓаԓ ԓыв йошԓаԓа ат питԓәт!» ");
INSERT INTO kca_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ревекка митнэԓаԓ пиԓән ԓойс, верблюдәт шӑнша омәссәт, пӑ щи хŏйат йўпийән мӑтсәт. Щиты митху Ревекка ўсԓы пӑ мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Исаак Беэр-лахай-рои эԓты йŏхтәс, ԓўв Негев морты мўвән ус. ");
INSERT INTO kca_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Йэтна пеԓа Исаак тŏрнәӈ-лыптәӈ хӑра шушиԓыты мӑнәс, йэԓ ватман кащаԓәсԓы: верблюдәт йиԓәт. ");
INSERT INTO kca_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ревекка пӑ Исаак кащаԓәсԓы, пӑ верблюд эԓты иԓ ŏхԓәс. ");
INSERT INTO kca_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Щӑԓта митхуйа йастәс: «Хŏй щи хŏйат, мўӈ йэщаԓтэв мўв хӑр хўват йиԓ?» Митху йастәс: «Щит ма кущайэм». Щи йасӈәт хуԓтмаԓ кемән, ԓўв ŏхшам ўс пӑ ŏха пŏтсәԓы, пӑ йэмәԓман венша иԓшәк эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Митху Исаак пеԓа иса, мўй ԓўв верәс, пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Исаак, Сарра аԋԏэԓ пирщин хота, эви ԓŏӈәԓсәԓы, Ревекка нэӈа ўсԓы, пӑ ԓўв имеԓа йис, сӑмәӈа тӑйты питсәԓы; щиты аԋԏэԓ пӑрәм йўпийән Исаак нŏпсәԓ ԓӑрпиԓәс. ");
INSERT INTO kca_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Авраам хŏԓна нэ ўйԓыйәс, Хеттура нэмәԓ. ");
INSERT INTO kca_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ԓўв Зимран, Иокшан, Медан, Мадиан, Ишбак пӑ Шуах пŏхәт ԓўвеԓа сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Иокшан Шева пӑ Дедан пŏхӈән тӑйәс. Дедан пŏхәт усәт: Ашурим, Летушим пӑ Леюмим. ");
INSERT INTO kca_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Мадиан пŏхәт: Ефа, Ефер, Ханох, Авида пӑ Елдага. Щит иса Хеттура хиԓэт. ");
INSERT INTO kca_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Авраам мўй тӑйәс, иса Исаак пŏхәԓа мӑсԓы, ");
INSERT INTO kca_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ай нэӈԓаԓ пŏхәта, Авраам хŏԓна ԓўв уԓмаԓән мойԓәпсайәт мӑс пӑ Исаак пŏхәԓ эԓты йэԓ китсәԓы, хӑтәԓ этты мўва. ");
INSERT INTO kca_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Авраам уԓәм хӑтԓәт сот ԓапәтйаӈ вет тӑԓ арат ус; ");
INSERT INTO kca_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","щӑԓта Авраам пӑрәс, пирща уԓәм хӑтәԓԓаԓ йӑма усԓы, уԓәпсайәԓ тэԓәӈ ус, пӑ пӑрәм ŏтԓаԓ хŏща мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Исаак пӑ Измаил пŏхӈәԓаԓән Мамре пўӈәԓән Цохар хет ики Ефрон пŏхәԓ мўв хӑрән Махпела хŏшапәӈ кевән ԓўв лоттәса, ");
INSERT INTO kca_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","хет хŏйатәт эԓты Авраам ԓутәм мўв хӑрән. Щита Авраам пӑ Сарра имеԓ лоттәман уԓԓәтән. ");
INSERT INTO kca_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Авраам пӑрәм йўпийән Турәм Куща Исаак пŏхәԓ йӑмән мӑсԓы. Беэр-лахай-рои хŏща Исаак ус. ");
INSERT INTO kca_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Тӑм пӑ Авраам Измаил пŏхәԓ тыхәԓ тэԓ, Сарра митнэ, Египет нэ Агарь Авраама тӑйәм пŏх тыхәԓ тэԓ. ");
INSERT INTO kca_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Тӑм Измаил пŏхәт нэмәт, сэма питмеԓ щирән: Измаил оԓәӈ пŏхәԓ Наваиоф, ԓўв йўпеԓән Кедар, Адбеел, Мивсам, ");
INSERT INTO kca_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Дума, Масса, ");
INSERT INTO kca_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Фема, Иетур, Нафиш пӑ Кедма. ");
INSERT INTO kca_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Щит Измаил пŏхԓаԓ нэмәт, ԓыв нэмԓаԓән ԓыв уԓәм куртԓаԓ пӑ ԓыв касԓыйәм хот вŏԓԓаԓ нэмәтсайәт. Щит кӑтхŏщйаӈ ŏх туты ху нэм рутԓаԓ щирән. ");
INSERT INTO kca_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Измаил сот хŏԉмаӈ ԓапәт тӑԓ ус; ԓўв пӑрәс пӑ пӑрәм ŏтԓаԓ хŏща мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Хавила эԓты Сур унты ԓыв усәт, щит Ассирийа мўв пеԓа мӑнтыйән Египет ԉэпән уԓты мўв. Измаил йох Авраам па хиԓэт пиԓән кўтәӈа пӑ ԉаԉәсман усәт. ");
INSERT INTO kca_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Тӑм Авраам Исаак пŏхәԓ тыхәԓ тэԓ эԓты пŏтәр. Авраам Исаак пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Исаак ԋӑԓйаӈ тӑԓ ԓŏватән Ревекка нэӈа тусԓы, Месопотамия мўвән уԓты Вафуил арамей ху эви, Лаван арамей ху апщи. ");
INSERT INTO kca_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Турәм Кущайа Исаак имеԓ урәӈән пойәкщәс, ԓўв ԋаврэм ӑт тӑйәс; Турәм Кущайән ԓўв хуԓтмәса, Ревекка имеԓ ԓавәрта йис. ");
INSERT INTO kca_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Пŏхӈәԓаԓ пӑтлам хотән пŏткатты питсәтән, пӑ ԓўв йастәс: «Щиты ки питәԓ, мўйа мӑнэма щит?» Пӑ Турәм Куща иԋщәсты мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Турәм Куща ԓўвеԓ йастәс: «Нӑӈ утрэнән кӑт рут, кӑт сыр мир нӑӈ эԓтэн этәԓ; и мирәԓ киметәԓ эԓты йурәӈшәк питәԓ, уншәк ŏтәԓ айшәк ŏтәԓ иԓпийән питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ԋаврэм сэма питты пŏра йŏхтәс: пӑ щи, пиԓаӈ ԋаврэмӈән пӑтлам хотән уԓман. ");
INSERT INTO kca_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Оԓәӈән сэма питәм ԋаврэм эԓәԓ ўрты, пӑ эԓәԓ ԓŏватәԓән пўнәӈ ус, пўнәӈ сŏх хŏрпи; щишән ԓўв Исав нэмән пŏтса. ");
INSERT INTO kca_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Щӑԓта апщеԓ этәс, йошәԓән Исав кўр йŏтԓаӈа катәԓман; ԓўвеԓа мийәм нэм Иаков. Исаака хутйаӈ тӑԓ ус, хун ԓын сэма питсәӈән. ");
INSERT INTO kca_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ԋаврэмӈән энәпсәтән, Исав таксар вой веԓты хуйа йис, мўвән йӑхты хŏйата; Иаков пӑ ром хŏйат ус пӑ пирщин хотәтән ус. ");
INSERT INTO kca_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исаак Исав сӑмәӈашәк тӑйсәԓы, туты войәԓ ԓўвеԓ йӑм ус, Ревекка пӑ Иаков сӑмәӈа тӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ипуш Иаков ԓэтŏт кавәртәс; Исав пӑ мўв хӑр эԓты метман йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Щӑԓта Исав Иакова йастәс: «Щи ўрты, ўрты ԓэтŏт эԓты мӑнэма мийа, ма метсәм». Щишән, ԓўв хŏԓна Едом нэмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Иаков пӑ йастәс: «Оԓәӈән нӑӈ унашәк уԓты верэн мӑнэма мийи». ");
INSERT INTO kca_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Исав йастәс: «Ма ԓэԓԓы щи хӑԓԓәм, мўй йӑм мӑнэма щи унашәк уԓты вер хŏща?» ");
INSERT INTO kca_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Иаков йастәс: «Оԓәӈән мӑнэма йасәӈ мийа». Ԓўв йасәӈ мӑс пӑ оԓӈа сэма питәм верәԓ Иаков апщеԓа мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Иаков Исава ԋаԋ пӑ ӑԋкәш соԓамат мӑс; ԓўв ԓэс пӑ йиԋщәс, нŏх ԓойәс пӑ мӑнәс; щиты Исав оԓӈа сэма питәм верәԓ ӑт шависԓы пӑ уштәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Авраам уԓәм ишән мўвән ԓэԓԓы йӑт ус, ин ԓэԓԓы пŏра па йŏхтәс; Авимелех хŏща, филистимәт хон хŏща, Герар мўва, Исаак мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Турәм Куща ԓўв хŏщайәԓ этәс пӑ йастәс: «Египет мўва аԓ мӑна; Ма нӑӈена йастәԓэм, мӑты мўвән нӑӈена уԓты, ");
INSERT INTO kca_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","тӑм мўвән уԓа, Ма нӑӈ пиԓэнән питԓәм, пӑ йӑмән нӑӈен мӑԓэм, нӑӈен пӑ йэԓԓы уԓты ԋаврэмԓана тӑм мўвәт мӑԓәм пӑ Авраама, нӑӈ ащена, мийәм йастәпсайэм Ма тӑԓаӈа верԓэм; ");
INSERT INTO kca_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","турәм хусәт иты нӑӈ тыхәԓ тэԓэн ара верԓэм, пӑ нӑӈ тыхәԓ тэԓэна тӑм мўвәт мӑԓәм; нӑӈ тыхԓэн хўват мўвән уԓты мирәт хŏԓ йӑмән мӑԓайәт, ");
INSERT INTO kca_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Авраам Ма йасӈема хуԓәтмаԓ урәӈән пӑ Ма партәм щирэмән уԓмаԓ урәӈән: Ма партәпсайԓам, Ма йастәпсайԓам пӑ Ма законԓам щирән уԓмаԓ урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Исаак Герар мўвән уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Щита уԓәм хŏйатәт ԓўвеԓ Ревекка имеԓ эԓты иԋщәссэԓ, ԓўв пӑ йастәс: «Щит ма нэ апщем»; ԓўв пӑԓәс йастәты: «Щит ма имем», ԓўв нумәсәс, щита уԓты хŏйатәтән, Ревекка хŏрасәӈ урәӈән, ԓўв ӑт ат веԓса. ");
INSERT INTO kca_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Йӑм хўв кўт ԓўв щита уԓман, ипўш филистимәт хон Авимелех, ишԋи эԓты кащаԓәсԓы, хŏты Исаак Ревекка имеԓ вощхиԓԓы. ");
INSERT INTO kca_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Авимелех Исаак вохсәԓы пӑ йастәс: «Тӑм нэш нӑӈ имен; мўйа нӑӈ йастәсән: ‘Ԓўв ма нэ апщем?’» Исаак ԓўвеԓ йастәс: «Ма нумәссәм, ԓўв урӈәԓән пӑрты верәтԓәм». ");
INSERT INTO kca_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Авимелех щиты йастәс: «Мўй нӑӈ мўӈ пиԓэвән версән? Мӑтты йŏх хŏйат ма мирэм эԓты нӑӈ имен хŏща ԓŏӈәс ки, нӑӈ мўӈев нўрәӈа пайәтсэн, ԓуԓән». ");
INSERT INTO kca_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Авимелех хŏԓ мирәԓа партәпса мӑс, йастәман: «Хŏй тӑм хŏйат хŏща мўй пӑ ԓўв имеԓ хŏща кетмәԓ, щит сŏрма пайәтԓа». ");
INSERT INTO kca_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Исаак щи мўв хӑратән ԓат сэм опсәс пӑ щи тӑԓән сот пўш аршәк ячмень ԓат тŏрән энмәс: щиты Турәм Кущайән йӑмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Щиты щи хŏйат тащәӈа йис, тащәԓ энмәс пӑ энмәс, шек тащәӈа йўвмаԓ унты. ");
INSERT INTO kca_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ай йош вой пӑ ун йош вой тащәт тӑйәс пӑ ар мўв хӑр, филистимәт ԓўв пеԓайәԓ сӑмԓаԓ щарыты питсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Щӑԓта Авраам ащеԓ уԓәпса ишән митйохԓаԓән хирәм йик ўты мўв ўсәт филистимәтән мўвән лӑп йовәԓсайәт. ");
INSERT INTO kca_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Исаак пеԓа Авимелех йастәс: «Мўӈ эԓтэв йэԓ мӑна, нӑӈ мўӈ эԓтэв йурәӈашәк йисән». ");
INSERT INTO kca_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Щишән, Исаак щиԓта мӑнәс, пӑ Герар йŏхан пўӈәԓән пирщин хотәт ԓоԋщәс, пӑ щита уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Щӑԓта Исаак йик ўты мўв ўсәт пӑ йӑԓпа хирсәԓы, Авраам ащеԓ ишән хирыԓыйәм йик ўты мўв ўсәт, Авраам пӑрәм йўпийән филистимәтән мўвән лӑп йовԓыԓысайәт; щӑԓта ащеԓ катра пŏныԓыйәм нэматән нэмәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Исаак митйохәт Герар сорәм йŏхан курән мўв хирсәт пӑ ԓыԓәӈ йикпи мўв ўс уйәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Герар мўв тащ шавиты йох Исаак тащ шавиты йох пиԓән йӑха питсәт, йастәман: «Мўӈ йиӈкев». Щишән, ԓўв щи йик ўты мўв ўс нэмән мӑсԓы: Есек, щита йӑха питыԓыйәм урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Кимет йик ўты мўв ўс хирсәт; щита ищи йӑха питыԓысәт; щит ԓўв Ситна нэмән нэмәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ԓўв щиԓта йэԓ мӑнәс, йик ўты мўв ўс па хирәс, щита йӑха ӑт питыԓысәт, пӑ нэмәтсәԓы: Реховоф, щӑԓта йастәс: «Ин мўӈева Турәм Куща ԓӑщкам мўв мӑс, тӑта мўӈ ара йиԓув». ");
INSERT INTO kca_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Щиԓта ԓўв Вирсавияйа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Щи ат Турәм Куща ԓўв хŏщайәԓ этәс пӑ йастәс: «Ма Авраам ащен Турәм; аԓ пӑԓа, Ма нӑӈ пиԓэнән; Авраам Ма митхуйэм урәӈән нӑӈен йӑмән мӑԓэм, тыхԓэн ара верԓэм». ");
INSERT INTO kca_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Щита ԓўв йирасты нŏрәм верәс пӑ Турәм Куща пеԓа пойәкщәс. Ԓўв щита пирщин хотԓаԓ ԓощсәԓы, пӑ Исаак митйохԓаԓ щита йик ўты мўв ўс хирсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Авимелех, Ахузаф ԓухсәԓ пиԓән, Фихол ԉаԉ йох кущайәԓ пиԓән, Герар эԓты ԓўв хŏщайәԓ йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исаак ԓывиԓаԓа йастәс: «Мўйа нын ма хŏщайэм йŏхәтсәты, нын ма пеԓайэм ԉик тусты пӑ мӑнэм йэԓ воштәсԓын?» ");
INSERT INTO kca_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ԓыв йастәсәт: «Мўӈ йӑпсыйа кащаԓысэв, Турәм Куща нӑӈ пиԓэнән, щишән мўӈ щиты нумәсԓув: ‘Мўӈ нӑӈ пиԓэнән йастатԓув пӑ и нŏмәсән уԓты питԓув’, ");
INSERT INTO kca_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","нӑӈ мўӈева атәм ӑт ат версән, мўӈ нӑӈен ищи ӑт кетәпсэв, иса йӑм нӑӈена версув пӑ йӑм нŏмәсән нӑӈен эсәԓсэв; Турәм Кущайән нӑӈ йӑмән мӑсайән». ");
INSERT INTO kca_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ԓўв ԓывиԓаԓ йӑм пӑсанән версәԓы, ԓыв ԓэсәт пӑ йищсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Аԓәӈсӑхат аԓәӈ киԓман, ԓыв кўтэԓән йастатсәт; Исаак ԓыв пиԓԓаԓән паймуԓәм верәс, ԓыв йӑм нŏмәсән ԓўв эԓтэԓ мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Щи хӑтәԓ Исаак митйохԓаԓ йŏхәтсәт пӑ ԓыв хирәм йик ўты мўв ўс эԓты айкеԓ версәт, пӑ йастәсәт: «Мўӈ йик уйәтсув». ");
INSERT INTO kca_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Пӑ Шива нэмән нэмәтсэԓ. Интӑм хӑтәԓ унты щи вош нэмәԓ Беэршива. ");
INSERT INTO kca_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Исава ԋӑԓйаӈ тӑԓ ус, хун Беэр нэмпи хет ики эви Иегудифа нэӈа ԓўв ўсԓы, пӑ Елон нэмпи хет ики эви Васемафа нэӈа ўсԓы. ");
INSERT INTO kca_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Исаака пӑ Ревеккайа ԓын пиԓанән уԓты шук хŏрпи ус. ");
INSERT INTO kca_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Исаак пирщамәса пӑ сэмԓаԓ ўртԓыйа йисәт; Исавәԓ, ун пŏхәԓ, вана вохсәԓы пӑ ԓўвеԓа йастәс: «Пŏхийэ!» Ԓўв йастәс: «Ма щи». ");
INSERT INTO kca_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Исаак йастәс: «Ма пирщамәсайәм, сŏрма питты хӑтԓэм ванамәс; ");
INSERT INTO kca_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","веԓпәс пŏрмасԓан ўйаԓән пӑ, йухԓэн пӑ ԋоԓԓан, веԓпәсԓәты йӑӈха пӑ вой ԋŏхи тўва, ");
INSERT INTO kca_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","мӑнэма рӑхты эпԓәӈ ԓэтŏт вера пӑ мӑнэма ԓэты тўви, пӑртэм йэԓпийән ма нӑӈен йӑмән мӑԓэм». ");
INSERT INTO kca_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ревекка хўԓтсәԓы, хŏты Исаак Исав пŏхәԓа щит пŏтәртәс. Щӑԓта Исав вой мŏщатты пӑ вой ԋŏхи туты мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ревекка пӑ Иаков пŏхәԓа йастәс: «Ма хуԓтсэм, хŏты ащен Исав йайәна йастәс: ");
INSERT INTO kca_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Вой ԋŏхи мӑнэма тўва пӑ эпԓәӈ ԓэтŏт мӑнэма вера; ма ԓэԓәм пӑ Турәм Куща ватман пӑртэм йэԓпийән нӑӈен йӑмән мӑԓэм’. ");
INSERT INTO kca_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ин, пŏхийэ, ма йасӈема хуԓәнта, мўй ма нӑӈена партԓәм: ");
INSERT INTO kca_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Таща йӑӈха пӑ кӑт йӑм коза пŏшәх щиԓта ўйа, ма пӑ нӑӈ ащена щиԓта ԓўвеԓа рӑхты эпԓәӈ ԓэтŏт верԓәм, ");
INSERT INTO kca_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","нӑӈ пӑ ащена туԓэн, щӑԓта ԓўв ԓэԓ пӑ пӑртаԓ йэԓпийән нӑӈен йӑмән мӑԓԓы». ");
INSERT INTO kca_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Иаков Ревеккайа, аԋԏэԓа, йастәс: «Исав йайәм пўнәӈ хŏйат, ма пӑ эԓэм ԋар; ");
INSERT INTO kca_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","мосәӈ, ащем мӑнэм маԓәсты питԓәԓы, ма пӑ ԓўвеԓ ԓэпәԓԓэм пӑ мўԓәсты йасәӈән йастәԓайәм, йӑм йасәӈ йўкана». ");
INSERT INTO kca_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Аԋԏэԓ ԓўвеԓ йастәс: «Пŏхийэ, нӑӈен мўԓты йасәӈ мӑнэма ат хойәԓ, туп ма йасӈема хуԓәнта, йӑӈха пӑ мӑнэма щи коза пŏшәхӈән тўваԓән». ");
INSERT INTO kca_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ԓўв мӑнәс, коза пŏшәхӈән ўс, пӑ аԋԏэԓа тусԓы; аԋԏэԓ пӑ ԓэтŏт верәс, ащеԓа рӑхты ԓэтŏт. ");
INSERT INTO kca_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Щӑԓта Ревекка ԓўв хотәԓән уԓәм Исав ун пŏхәԓ тынәӈ сŏхәт ўсԓы, Иаков ай пŏхәԓ щи сŏхәта ԓумәттәсԓы; ");
INSERT INTO kca_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","йошԓаԓ пӑ ԋар сапԓәԓ коза пŏшәх сŏхәтән йŏвәртсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","щӑԓта ԓўв ԓэщатәм эпԓәӈ ԓэтŏтәԓ пӑ ԋаԋәԓ Иаков пŏхәԓ йоша мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ԓўв ащеԓ хŏща ԓŏнәс пӑ йастәс: «Ащийэ!» Щитәԓ йастәс: «Ма щи; нӑӈ пӑ хŏй, пŏхийэ?» ");
INSERT INTO kca_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Иаков ащеԓа йастәс: «Ма Исав, оԓәӈ пŏхен; нӑӈ партмен щирән ма версэм; нŏх киԓа, опса пӑ вой ԋŏхи ԓэва, мӑнэм йӑмән мӑты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Щӑԓта Исаак пŏхәԓа йастәс: «Пŏхийэ, щикем сора нӑӈ вой уйәтсән?» Ԓўв йастәс: «Турәм Куща, нӑӈ Турмен щи вой мӑнэма йэщаԓт китсәԓы». ");
INSERT INTO kca_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Щӑԓта Исаак Иакова йастәс: «Вана йӑӈха, пŏхийэ, ма нӑӈен маԓәсԓэм, нӑӈ йӑна ма Исав пŏхем мўй ӑнта?» ");
INSERT INTO kca_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Иаков Исаак ащеԓ хŏща ванамәс пӑ ащеԓ ԓўвеԓ маԓәссәԓы пӑ йастәс: «Тўр сыйэн Иаков тўр сый; йошԓан пӑ Исав йошәт». ");
INSERT INTO kca_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Щиты ԓўвеԓ ӑт мŏштәсԓы, йошԓаԓ Исав йайәԓ йошәт иты пўнәӈәт усәт; пӑ йӑмән мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Щӑԓта па иԋщәссәԓы: «Нӑӈ ма Исав пŏхем?» Ԓўв йастәс: «Йӑна щи, ма». ");
INSERT INTO kca_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Исаак йастәс: «Мӑнэма мийи, нӑӈ тўвәм вой ԋŏхен эԓты ԓэԓәм, нӑӈен йӑмән мӑты урәӈән». Иаков ԓўвеԓа мӑс пӑ ԓўв ԓэс, ўнайән ԓўвеԓ па тусԓы, пӑ ԓўв йиԋщәс. ");
INSERT INTO kca_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Исаак ащеԓ ԓўвеԓа йастәс: «Вана йӑӈха, пŏхийэ, мӑнэм мосәԓты». ");
INSERT INTO kca_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ԓўв вана мӑнәс пӑ ԓўвеԓ мосәԓтәсԓы. Исаак ԓўв сŏхԓаԓ эпәԓ мŏштәс пӑ йӑмән мӑсԓы. Ԓўв йастәс: «Тӑта щи пŏхем эԓты йиты эпәԓ, ԓат сэмән опсәм мўв хӑр эпәԓ хŏрпи, Турәм Кущайән йӑмән мийәм мўв хӑр эпәԓ хŏрпи; ");
INSERT INTO kca_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","турәм ат йик эԓты пӑ тэԓәӈ мўв эԓты Турәмән ат мӑԓайән, ар ԋаԋ ԓатән пӑ ўнайән ат мӑԓайән; ");
INSERT INTO kca_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","мирәт нӑӈена ат рупитԓәт, ŏх пŏнман, иԓ ԋўрман нӑӈ йэԓпенән мирәт ат ԓойԓәт; хӑнам йохԓан нўмпийән кущайа уԓа, аԋԏэн пŏхәт нӑӈ йэԓпенән, ŏх пŏнман, иԓ ат ԋўрԓәт; нӑӈен мўԓты ŏтәт – мўԓԓайәт; нӑӈена йӑм йасәӈ йастәты ŏтәт – йӑмән мӑԓайәт!» ");
INSERT INTO kca_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Исаак Иаков йӑмән миймаԓ йўпийән, Исаак ащеԓ эԓты Иаков туп этәс, Исав йайәԓ веԓпәс эԓты йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ԓўв ищи эпԓәӈ ԓэтŏт верәс, щӑԓта ащеԓа тусԓы, пӑ ащеԓа йастәс: «Ащи, нŏх киԓа пӑ пŏхен тўвәм вой ԋŏхи ԓэва, мӑнэма йӑм мӑты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Исаак ащеԓ пӑ ԓўвеԓа йастәс: «Нӑӈ хŏй?» Ԓўв йастәс: «Ма нӑӈ пŏхен, оԓәӈ пŏхен, Исав». ");
INSERT INTO kca_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Исаак такан тӑрыты питәс пӑ йастәс: «Тўм пӑ хŏй ус, хŏй веԓпәсԓәты йӑӈхәс, мӑнэма вой ԋŏхи тус? Ма пӑ щиԓта ԓэсәм нӑӈ йŏхәттэн йэԓпийән, щӑԓта ԓўвеԓ йӑмән мӑсэм. Ԓўв щи йӑм тӑйты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Исав, ащеԓ йасӈәт хуԓмаԓән, сӑмәԓ похман такан ўвты питәс пӑ ащеԓа йастәс: «Ащи! Мӑнэм ищи йӑмән мийи». ");
INSERT INTO kca_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ԓўв пӑ йастәс: «Апщен ԓэпәԓтман йŏхтәс пӑ нӑӈ йўкан йӑмен ўсԓы». ");
INSERT INTO kca_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Щӑԓта Исав йастәс: «Ӑԓ хун ԓўв Иаков нэм тӑйәԓ, кӑт пўш мӑнэм ԓэпәԓтсәԓы? Ма оԓәӈ сэма питәм верэм ўсԓы, ин пӑ ма йўкан йӑмем ўсԓы». Щӑԓта пӑ Исав ащеԓа йастәс: «Ма урӈемән пӑ йӑм йасәӈ нӑӈ вŏԓԓы ӑт хӑйсән?» ");
INSERT INTO kca_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исаак Исава йастәс: «Ма ԓўвеԓ нӑӈ нўмпенән кущайа пŏтсэм пӑ хӑнам йохԓаԓ ԓўв хŏщайәԓ митйоха питԓәт; ԋаԋән пӑ ўнайән ԓўвеԓ мойԓәптәсэм; нӑӈ урӈенән ма нэмәԓты ӑт верәтԓәм верты, пŏхийэ». ");
INSERT INTO kca_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Исав пӑ ащеԓа йастәс: «Ащи, нӑӈ мўй туп и йӑм йасәӈ тӑйԓән? Ащи, мӑнэм ищи йӑмән мийи!» Исав такан йэԓ хоԓԓантәс. ");
INSERT INTO kca_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Исаак ащеԓ ԓўвеԓа щиты йастәс: «Нӑӈ уԓты щирэн мўв тэԓ эԓты пӑ турәм ат йик эԓты уԓты питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","нӑӈ пӑ аԓтты кешен тӑйман уԓты питԓән, апщен урәӈән рупитты питԓән; пŏра йŏхәтәԓ, хун нӑӈ апщен пиԓән ԉаԉәсты питԓән, пӑ ԓўв эԓтэԓ велка йиԓән». ");
INSERT INTO kca_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Иаков ащеԓән йӑмән мийәм урәӈән Исавән ԉикән этты питса; Исав ԓўв сӑхатәԓ щиты йастәс: «Ащем хоԓԓәп хӑтԓәт вана йŏхәтсәт, щи йўпийән ма Иаков апщем веԓԓэм». ");
INSERT INTO kca_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Исав ун пŏхәԓ йасӈәт Ревеккайа йастәсайәт; ԓўв Иаков ай пŏхәԓ ԓўв хŏщайәԓ вохты партсәԓы, пӑ ԓўвеԓа йастәс: «Исав йайән нӑӈен веԓты ўтщиԓԓы; ");
INSERT INTO kca_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","пŏхийэ, ма йасӈема хуԓәнта, Харран воша Лаван йайәм хŏща хŏнта, ");
INSERT INTO kca_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","щита йӑм кўт уԓа, йайән ԉикәԓ мӑнтаԓ унты, ");
INSERT INTO kca_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","йайән ԉикәԓ мӑнәԓ пӑ ԓўв йŏрэмәԓԓы, мўй нӑӈ ԓўвеԓа версән: щи пŏрайән ма нӑӈен йŏхи вохты китԓәм; мўй урәӈән ма нынан и хӑтәԓән уштәԓԓам?» ");
INSERT INTO kca_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Щӑԓта Исаака Ревекка йастәс: «Хет нэӈӈән урәӈән ма уԓәпсайэм кашԓы; хет эвет эԓты, тӑм мўв эԓты, тӑм нэӈӈән хŏрпи нэ Иаков туԓ ки, мўйа мӑнэма уԓты?» ");
INSERT INTO kca_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Щӑԓта Исаак Иаков вохсәԓы, пайәмуԓәм верәс, пӑ щиты ԓўвеԓа партәс пӑ йастәс: «Ханаан мўв эвет эԓты нэ аԓ тўва; ");
INSERT INTO kca_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","мӑна, Месопотамия мўва йӑӈха, Вафуил хота, нӑӈ аԋԏэн ащи хота, щиԓта нӑӈена нэ тўва, Лаван эвет эԓты, нӑӈ аԋԏэн йай эвет эԓты. ");
INSERT INTO kca_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Иса Верәтты Турәмән нӑӈ йӑмән ат мӑԓайән, пӑ нӑӈ ат рутмәԓԓайән, пӑ нӑӈ ара ат верԓайән, пӑ ар рут мир нӑӈ эԓтэн ат питәԓ, ");
INSERT INTO kca_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","пӑ Авраама мийәм йӑм, Турәмән нӑӈена ищи ат мӑԓа, нӑӈена пӑ нӑӈ пиԓэнән нӑӈ тыхԓэна, мўӈ йŏхтәм мўвев, Турәмән Авраама мийәм мўв, нӑӈена хӑйты урәӈән!» ");
INSERT INTO kca_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Исаак Иаков йӑм нŏмәсән китсәԓы, пӑ ԓўв Месопотамия мўва Лаван хŏща мӑнәс, Вафуил арамей ики пŏх хŏща, Иаков пӑ Исав Ревекка аԋԏан йай хŏща. ");
INSERT INTO kca_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Исав мŏштәсԓы, Иаков пŏхәԓ Исаак йӑмән мӑсԓы, пӑ, йӑм йасәӈән йастәмаԓән, Месопотамия мўва ԓўвеԓ нэ туты китсәԓы, пӑ такан партсәԓы: «Ханаан мўв эвет эԓты нэ аԓ тўва», ");
INSERT INTO kca_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","пӑ хŏты ащеԓ пеԓа пӑ аԋԏэԓ пеԓа Иаков хуԓәнтәс пӑ Месопотамия мўва мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Исав ŏша пайәтсәԓы, Ханаан мўв эвет Исаак ащеԓа ӑт рӑхԓәт; ");
INSERT INTO kca_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Исав Измаил хŏща мӑнәс пӑ Махалафа нэӈа ўсԓы, Авраам Измаил пŏхәԓ эви, Наваиоф апщи, щит тӑйәм имеӈәԓаԓ тўмпийән. ");
INSERT INTO kca_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Иаков Вирсавия эԓты этәс пӑ Харран пеԓа мӑнәс, ");
INSERT INTO kca_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","щӑԓта и тӑхайа йŏхтәс пӑ, най ԓŏӈәмән щита хоԓты хӑщәс. Щи тӑхайән кевәт эԓты и кев ŏсма пŏтсәԓы, пӑ щита иԓ ŏԓәс. ");
INSERT INTO kca_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Щӑԓта уԓмийәс: хомтэп мўв эԓты ԓойәԓ пӑ нўм оԓӈәԓ турма хойәԓ; пӑ щиԓта Турәм ангеләт итԓаԓ нŏхԓы мӑнԓәт, киметԓаԓ иԓԓы ŏхәԓԓәт. ");
INSERT INTO kca_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Щӑԓта Турәм Куща щита хомтэпән ԓойәԓ пӑ пŏтәртәԓ: «Ма Турәм Куща, Авраам ащен Турәм, пӑ Исаак Турәм. Мўвен, хŏта нӑӈ ŏԓԓән, Ма нӑӈена пӑ йэԓԓы уԓты ԋаврэмԓана мӑԓэм; ");
INSERT INTO kca_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","нӑӈ тыхԓэн мўв сэй хиш арата йиԓ; щарәс пеԓа пӑ хӑтәԓ этты пелка, пӑ ŏвәс пеԓа пӑ морты мўв пеԓа нӑӈ ԓӑрпиԓәԓән; пӑ нӑӈ хўватэн пӑ нӑӈ тыхәԓ тэԓэн хўват мўв ԓŏватән уԓты мирәт хŏԓ йӑмән мӑԓайәт; ");
INSERT INTO kca_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","тӑта щи Ма нӑӈ пиԓэнән, нӑӈен шавиԓэм, хŏԓта кепа нӑӈ ӑт мӑнԓән; тӑм мўва нӑӈен йŏхԓы керәтԓэм, щишән, Ма нӑӈен ӑт хӑйԓэм, Ма йастәм йасӈем пӑтэԓа тутэм унты». ");
INSERT INTO kca_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Иаков уԓмәԓ эԓты нŏх верԓәс пӑ йастәс: «Йӑна щи тӑм тӑхайән Турәм Куща уԓ; ма пӑ ӑт уйәтсэм!» ");
INSERT INTO kca_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Щӑԓта хŏрщәмән йŏхәтса пӑ йастәс: «Тӑм тӑха щикем пӑԓщәм хŏрпи! Аԓт пӑ тӑта Турәм хот, тӑм пӑ турәм ов». ");
INSERT INTO kca_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Иаков аԓәӈсӑхат аԓәӈ нŏх киԓәс, ŏсма пŏныԓыйәм кевәԓ ўсԓы пӑ нумты кева омәссәԓы, пӑ оливка вŏйән эԓты шошәпсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Пӑ щи тӑха нэмән пŏтсәԓы: Вефиль, щи вош йэԓпи нэмәԓ ус: Луз. ");
INSERT INTO kca_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Щӑԓта Иаков так йасәӈ мӑс, йастәман: «Турәм ма пиԓэмән питәԓ ки пӑ мӑнты йушемән мӑнэм шавиԓԓы, пӑ ԓэты ԋаԋ мӑԓ пӑ ԓумәтԓәты сŏх мӑԓ, ");
INSERT INTO kca_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","пӑ ащем хота ма тӑԓаӈа йŏхԓы йŏхәтԓәм, щитэмән Турәм Куща ма Турмем питәԓ, – ");
INSERT INTO kca_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","пӑ щӑԓта тӑм кев, нумты кева ма ԓощсэм, Турәм хота питәԓ; пӑ Нӑӈ, Турәм, мӑнэма мойԓәты ŏтэн эԓты йаӈмет шупәԓ Нӑӈена мӑԓэм». ");
INSERT INTO kca_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Щӑԓта Иаков йэԓԓы мӑнәс пӑ хӑтәԓ этты пеләкән уԓты мирәт мўва йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Тŏхи ванамимаԓән, кащаԓәсԓы: ԓӑщкам мўвән йик ўты мўв ўс пўӈәԓән хуԓәм ош тащ ŏԓәԓ, щи мўв ўс эԓты тащәт йикән йищәԓтәсайәт. Мўв ўс ун кев шупән лӑп пайәтман ус. ");
INSERT INTO kca_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Хун ош тащәт хŏԓ щита ӑктәщисәт, йик ўты мўв ўс эԓты кев шуп йэԓ пертыԓыса пӑ ошәт йищәԓтысайәт; щӑԓта кев шуп пӑ ŏԓәм тӑхайәԓа, йик ўты мўв ўс эԓты пŏныԓыса. ");
INSERT INTO kca_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Иаков ош шавиты йоха йастәс: «Хӑнам йох! Хŏԓща нын уԓԓәты?» Ԓыв йастәсәт: «Мўӈ Харран вош эԓты». ");
INSERT INTO kca_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ԓўв ԓывиԓаԓ иԋщәсәс: «Нахор пŏх Лаван уйәтԓәԓән?» Ԓыв йастәсәт: «Уйәтԓэв». ");
INSERT INTO kca_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ԓўв пӑ хŏԓна ԓывиԓаԓ иԋщәсәс: «Тўмтака ԓўв уԓ?» Ԓыв йастәсәт: «Тўмтака уԓ; тўта щи Рахиль эвеԓ ошԓаԓ пиԓән йиԓ». ");
INSERT INTO kca_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Иаков йастәс: «Хӑтәԓ хŏԓна хўв; тащәт ӑкәтты хŏԓна аԓәӈ; ошԓән йищәԓтаԓән пӑ щӑхра воштаԓән». ");
INSERT INTO kca_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ԓыв йастәсәт: «Тащәт хŏԓ ӑктәщтэԓ унты щит верты ӑт верәтԓув, кев шуп йик ўты ўс эԓты йэԓ пайәтԓа пӑ веԓщи ошәт йищәԓтәты питԓәԓув». ");
INSERT INTO kca_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ԓўв хŏԓна ԓыв пиԓԓаԓән пŏтәртәс, хун Рахиль ащеԓ ошәт пиԓән вана йŏхтәс, ԓўв ош тащ шавийәс. ");
INSERT INTO kca_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Хун Иаков аԋԏэԓ йай Лаван Рахиль эви пӑ Лаван ошәт кащаԓәс, ԓўв йик ўты мўв ўс эԓты кев шуп перәтсәԓы пӑ аԋԏэԓ йай Лаван ŏшәт йищәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Иаков Рахиль мосәԓтәсԓы пӑ такан йэԓ хоԓԓаԓтәс. ");
INSERT INTO kca_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Щӑԓта Иаков Рахиль пеԓа пŏтәртәс, ԓўв Ревекка пŏх пӑ ԓўв ащеԓа рута уԓ. Рахиль хухәԓмәс пӑ ащеԓа щит йастәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Иаков эԓты, нэ апщеԓ пŏх эԓты хуԓмаԓ кемән, Лаван йэщаԓт ким хухәԓмәс, ԓўвеԓ ӑпәԓсәԓы пӑ мосәԓтәсԓы, пӑ хотәԓа ԓŏӈәԓсәԓы; Иаков пӑ Лавана иса щит пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Лаван пӑ ԓўвеԓа йастәс: «Йӑна нӑӈ ма ԓŏвем пӑ ма ԋŏхем». Иаков ԓўв хŏщайәԓ тӑԓаӈ тыԓәщ ус. ");
INSERT INTO kca_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Щӑԓта Лаван Иакова йастәс: «Кўш нӑӈ мӑнэма рута уԓԓән, пӑ щӑԓта тынԓы-пелԓы хун ма хŏщайэм рупитты питԓән? Йаста мӑнэма, мўйән нӑӈен сŏхәптәты?» ");
INSERT INTO kca_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Лаван кӑт эви тӑйәс; ун эвеԓ нэм Лия, айшәк эвеԓ нэм Рахиль. ");
INSERT INTO kca_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Лия сэмән ватман ўртԓы ус, Рахиль пӑ хŏрасәӈ пӑ ԋӑрәк эви ус. ");
INSERT INTO kca_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Иаков Рахиль пеԓа сӑмәԓ питәс пӑ йастәс: «Рахиль ай эвен урәӈән ԓапәт тӑԓ нӑӈена рупитты питԓәм». ");
INSERT INTO kca_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Лаван йастәс: «Нӑӈена мӑԓэм ки, йӑмшәк, па хŏйата мӑтэм мушән; ма хŏщайэм уԓа». ");
INSERT INTO kca_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Иаков Рахиль урәӈән ԓапәт тӑԓ рупитәс; кӑмәтса хӑтәԓ йўкана щи тӑԓәт хӑщәпсәт, ԓўв Рахиль шек сӑмәӈа тӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Пӑ щӑԓта Иаков Лавана йастәс: «Имийа мӑнэма мийи, ԓўв пиԓәԓән уԓты пŏрайэм йŏхтәс». ");
INSERT INTO kca_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Лаван щита ванән уԓәм хŏйатәт вохсәԓы пӑ поры верәс. ");
INSERT INTO kca_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Йэтнайән Лия эвеԓ ўсԓы пӑ Иаков хŏща ԓŏӈәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Лаван Зелфа митнэӈәԓ Лия эвеԓа митнэӈа мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Аԓәӈсӑхат ԓэрамәс, щит Лия уԓмаԓ. Иаков Лавана йастәс: «Мўйа нӑӈ щиты ма пиԓэмән версән? Ма нӑӈ хŏщайэн Рахиль урәӈән ӑт рупитсәм? Мўйа нӑӈ мӑнэм ԓэпәԓсэн?» ");
INSERT INTO kca_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Лаван йастәс: «Мўӈ уԓты тӑхайэвән щиты ӑт верԓа, хун ай ŏтәԓ ун ŏтәԓ йэԓпийән ху сайа мӑԓа; ");
INSERT INTO kca_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","тӑм эвем поры ԓапәт йэтшәпты пӑ кимет эвем нӑӈена мӑԓэв, щӑԓта ԓўв урӈәԓән хŏԓна ԓапәт тӑԓ рупитты питԓән». ");
INSERT INTO kca_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Иаков щиты щи версәԓы пӑ щи поры ԓаптәԓ йэтшәптәсԓы. Щӑԓта Лаван Рахиль эвеԓ ԓўвеԓа нэӈа па мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Лаван Валла митнэӈәԓ Рахиль эвеԓа митнэӈа мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Иаков Рахиль пиԓән па ус, Лия эԓты Рахиль сӑмәӈашәк тӑйсәԓы; пӑ хŏԓна ԓапәт тӑԓ Лаван хŏща рупитәс. ");
INSERT INTO kca_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Лия сӑмәӈа ӑт тӑйты вер Турәм Куща мŏштәсԓы пӑ ԋаврэмән ԓўвеԓ партсәԓы, Рахиль пӑ ԋаврэм ӑт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Лия ԓавәрта йис пӑ Иакова пŏх сэма пайтәс, нэмән мӑсԓы: Рувим, щиты ԓўв йастәс: «Ма шукем Турәм Куща мŏштәсԓы, тӑԓта йэԓԓы сӑма мосман икемән тӑйты питԓайәм». ");
INSERT INTO kca_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Щӑԓта па ԓавәрта йис пӑ пŏх сэма пайтәс, пӑ йастәс: «Турәм Куща хуԓтсәԓы, ма сӑма ӑт мосԓәм, па пŏхән мӑсайәм». Нэмән мӑсԓы: Симеон. ");
INSERT INTO kca_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Щӑԓта па ԓавәрта йис пӑ пŏх сэма пайтәс, пӑ йастәс: «Ин хŏты икем ма пиԓэмән уԓты питәԓ, ма ԓўвеԓ хуԓәм пŏхән тӑйсэм». Щишән, пŏхәԓ нэмән мӑса: Левий. ");
INSERT INTO kca_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Щӑԓта пӑ ԓавәрта йис пӑ па пŏх сэма пайтәс, пӑ йастәс: «Ин ма Турәм Куща ишәкԓэм». Щишән, пŏхәԓ нэмән мӑсԓы: Иуда. Пӑ ԋаврэм тӑйты вŏԓыйәс. ");
INSERT INTO kca_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Рахиль пӑ Иакова ԋаврэм ӑт тӑйәс, щишән, Рахиль Лия ŏпеԓ пеԓа ўшмащты питәс, пӑ Иакова йастәс: «Мӑнэма ԋаврэм мийа, ӑнтом ки, ма пӑрԓәм». ");
INSERT INTO kca_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Иаков Рахиль пеԓа ԉикащәс пӑ йастәс: «Ма ӑнта Турәм, Ԓўв нӑӈена ԋаврэм ӑт партәс». ");
INSERT INTO kca_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ԓўв пӑ йастәс: «Тӑта щи ма митнэӈем Валла; ԓўв пиԓәԓән уԓа; ԓўв ма шаншема ԋаврэм сэма ат пайәтәԓ, ма ищи, ԓуԓән, ԓўв мŏхтэԓ ԋаврэм ат тӑйсәм». ");
INSERT INTO kca_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Пӑ Валла митнэӈәԓ ай нэӈа ԓўвеԓ мӑсԓы; Иаков ԓўв пиԓәԓән ус. ");
INSERT INTO kca_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Валла ԓавәрта йис пӑ Иакова пŏх сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Рахиль йастәс: «Турәм ма верэм тўӈа пайәтсәԓы пӑ мӑнэм хўԓсәԓы, пӑ пŏх мӑнэма мӑс». Щишән, Дан нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Щӑԓта Рахиль Валла митнэӈәԓ па ԓавәрта йис пӑ кимет пŏх Иакова сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Щӑԓта Рахиль йастәс: «Ŏпем пиԓән мин шек такан йӑха хойԓысмән, пӑ ма нŏх питсәм». Пӑ Неффалим нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Лия пӑ, ԋаврэм тӑйты вŏԓымаԓән, Зелфа митнэӈәԓ ўсԓы пӑ Иакова ай нэӈа мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Щӑԓта Зелфа, Лия митнэ, Иакова пŏх сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Лия йастәс: «Шек йӑм». Гад нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Щӑԓта Зелфа, Лия митнэ, кимет пŏх Иакова сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Лия пӑ йастәс: «Ма ŏйэма, нэӈәт мӑнэм ŏйәӈа айәԓты питԓэԓ». Асир нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ԓат тŏрән сэвәрты пŏрайән Рувим пŏхәԓ мўв хӑра мӑнәс пӑ мандрагор энәмты ԓэвпәсәт уйтәс, Лия аԋԏэԓа щитәт тусԓы. Рахиль Лияйа йастәс: «Пŏхен тўвәм мандрагор энәмты ԓэвпәсәт эԓты мӑнэма мийа». ");
INSERT INTO kca_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Лия пӑ ԓўвеԓа йастәс: «Икем нŏх ўсэн, щит нӑӈена шимәԓ, пŏхем тўвәм мандрагорәт па ԓӑӈхаԓԓан?» Рахиль йастәс: «Тӑм йэтән ԓўв нӑӈ хŏщайэн ат ԓŏӈтыйәԓ, пŏхен мандрагорәт сӑхат». ");
INSERT INTO kca_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Иаков йэтна пеԓа мўв хӑр эԓты йŏхәтмаԓән Лия ԓўв йэщаԓтәԓ этәс пӑ йастәс: «Ма хŏщайэм ԓŏӈтыйа, ма нӑӈен пŏхем мандрагорәт сӑхат ԓутсэм». Щи ат Иаков ԓўв хŏщайәԓ хоԓәс. ");
INSERT INTO kca_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Турәм Лия хуԓтмәсԓы, ԓўв ԓавәрта йис пӑ Иакова ветмет пŏх сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Щӑԓта Лия йастәс: «Турәм мӑнэм мойԓәптәсԓы, митнэӈем икема миймем урәӈән». Иссахар нэмән ԓўвеԓ мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Лия па ԓавәрта йис, щӑԓта хутмет пŏх Иакова сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Щиты Лия йастәс: «Турәм мӑнэма йӑм мойԓәпса мӑс; икем ма хŏщайэм уԓты питәԓ, ма ԓўвеԓа хут пŏх сэма пайәтсәм». Завулон нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Щӑԓта эви тӑйәс, Дина нэмән ԓўвеԓ пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Турәм Рахиль нŏмәсән иса тӑйсәԓы, Турәм ԓўвеԓ хуԓтсәԓы пӑ ԋаврэмән партсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ԓўв ԓавәрта йис пӑ пŏх тӑйәс, пӑ йастәс: «Турәм йэԓэмем нŏх ўсԓы». ");
INSERT INTO kca_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Иосиф нэмән пŏтсәԓы пӑ йастәс: «Турәм мӑнэма кимет пŏх па мӑԓ». ");
INSERT INTO kca_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Рахиль Иосиф сэма пайәтмаԓ йўпийән, Иаков Лавана йастәс: «Мӑнэм эсԓы, ма ма тӑхайэма, ма мўвема мӑнԓәм; ");
INSERT INTO kca_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ԋаврэмԓам пӑ имиԓам мийаԓән, ма ԓыв урӈеԓән нӑӈена рупитсәм, щӑԓта ма мӑнԓәм, нӑӈ уйәтԓэн, хŏты ма нӑӈен йӑма рупитсэм». ");
INSERT INTO kca_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Лаван пӑ ԓўвеԓа йастәс: «Йӑм сэмән ма пеԓайэм ватԓән ки, тӑта хӑща. Ма мŏштәсэм, Турәм Куща нӑӈ хўватэн мӑнэм йӑм мӑԓ». ");
INSERT INTO kca_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Пӑ йастәс: «Нӑӈ тынэн ма эԓтэм мӑнэма йасты, пӑ ма мӑԓэм». ");
INSERT INTO kca_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Иаков ԓўвеԓа йастәс: «Нӑӈ уйәтԓэн, хŏты ма нӑӈена рупитсәм пӑ ма уԓтэм сыс хŏты нӑӈ тащԓан энәпсәт; ");
INSERT INTO kca_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ма йŏхәтмемән, шимәԓ ус, ин пӑ ара йис; Турәм Куща нӑӈен йӑмән мӑсԓы ма йŏхәтмем йўпийән; ма пӑ ма хот тэԓэм урәӈән хун рупитты питԓәм?» ");
INSERT INTO kca_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Лаван йастәс: «Мўй нӑӈен мӑты?» Иаков йастәс: «Нэмәԓты мӑнэм аԓ мийа. Ма йастәтэм щирән верԓэн ки, ма пӑ йэԓԓы нӑӈ тащԓан тӑйты пӑ шавиты питԓәԓам. ");
INSERT INTO kca_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ма тӑм хӑтәԓ нӑӈ ош тащԓан хŏԓ ватԓәԓам; хӑншаӈ, лотәӈ пӑ питы ошәт пӑ хӑншаӈ пӑ лотәӈ козайәт хŏԓ атэԓт ўйаԓән. Щимәщ войәт мӑнэма тына питԓәт. ");
INSERT INTO kca_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Щӑха, ватты йŏхәттэнән, ма нӑӈ йэԓпенән вещкат ат усәм. Ӑнта хӑншаӈ, ӑнта лотәӈ коза пӑ ӑнта питы ош ма хŏщайэм ԉикмәԓ ки, щит ԓоԓмәм ŏта ԓўӈтәсты питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Лаван йастәс: «Йӑм, нӑӈ йасӈен щирән ат питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Щи хӑтәԓ хŏԓ хӑншаӈ, лотәӈ козайәт пӑ козёләт, нŏви лот тӑйты войәт, пӑ питы ошәт ԓўв атэԓт ўсԓы, пӑ пŏхԓаԓа шавиты мӑсԓы; ");
INSERT INTO kca_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","пӑ хуԓәм хӑтәԓ сыс мӑнты хўвата щи войәт йэԓ туты партсәԓы. Иаков пӑ, Лаван йош войәт шавиты хӑщәс. ");
INSERT INTO kca_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Щӑԓта Иаков тополь, миндаль пӑ чинар йўхәт эԓты веԓщи сэврәм нўвԓаԓ хŏща йўх карԓаԓ шумԓәӈа ԋŏхәрсәԓы, нŏви ԋар йўх унты карәԓ хŏпәтман; ");
INSERT INTO kca_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","щимәщ шумԓәӈ нўвәт войәт йищәԓтәты хўрэт ԓыпийа пŏтсәԓы, хŏԓта войәт йищты йŏхтыԓысәт. Вохатты сыс йищты йŏхтыԓыйәм войәт, ");
INSERT INTO kca_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","щи нўвәт йэԓпийән вохатсәт, щишән, опсәм пŏшхәт хӑншаӈәт пӑ лотәӈәт усәт. ");
INSERT INTO kca_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Иаков щи ош пŏшәхԓаԓ атэԓт тӑйсәԓы; щӑԓта пӑ, вохатты пŏрайән нŏви войәт щиты ԓощәԓтыԓысԓы, ԓыв Лаван хӑншаӈ пӑ питы войәт пеԓы ат ватсәт; ԓўв тащԓаԓ атэԓт тӑйсәԓы, Лаван войәт пиԓән ӑт ԓыԓәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Кашәӈ пўш, хун йурәӈ нэ войәт хўрэт хŏща йик йищты йŏхтыԓысәт, хўрэт ԓыпийа войәт сэм йэԓпийа Иаков шумәԓтәм нўвәт пŏныԓыйәс, ԓыв щита ат вохатсәт. ");
INSERT INTO kca_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Хун пӑ вевԓы войәт усәт, щи пŏрайән нўвәт ӑт пŏныԓыйәс. Щишән, вевԓы войәт Лаван пеԓа питсәт, йурәӈ ŏтәт пӑ Иаков пеԓа. ");
INSERT INTO kca_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Щишән, щи хŏйат шек-шек тащәӈа йис, ар ош тащ, тӑйәс, митнэӈәт, митйох, верблюд пӑ осёл войәт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Щӑԓта Лаван пŏхәт йасӈәт Иаков хуԓтсәԓы, ԓыв щиты пŏтәртсәт: «Ащев тӑйәм тащ Иаков иса нŏх ўймаԓ, щишән ԓўв тащәӈа йис». ");
INSERT INTO kca_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Иаков Лаван вешәԓ кащаԓәс пӑ, ԓўв ӑнта мŏԓхатәԓ хŏрпи, ин пӑ иса мŏԓты хӑрәх-мŏрәх. ");
INSERT INTO kca_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Щӑԓта Турәм Куща Иакова йастәс: «Ащиԓан мўвәта, нӑӈ мўвена йŏхԓы керԓа; Ма пӑ нӑӈ пиԓэнән питԓәм». ");
INSERT INTO kca_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Иаков айкеԓ китәс, Рахиль пӑ Лия вохты, ԓўв шавиты ош тащԓаԓ хŏща ԓынан йŏхәтты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Пӑ ԓынана йастәс: «Ма ваттэмән, ащан вешәԓ ӑнта щи йэԓпи хŏрпи, ин пӑ иса хӑрәх-мŏрәх; туп ма ащем Турәм иса ма пиԓэмән уԓ; ");
INSERT INTO kca_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","нын уйәтԓәԓԓән, йурэмән нын ащана ма рупитсәм, ");
INSERT INTO kca_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ащан пӑ мӑнэм ԓэпәԓтысԓы пӑ сŏхәптәты тынәԓ йаӈ пўш пелтыԓысԓы; туп Турәм ԓўвеԓа атәм верты мӑнэма ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Хун ԓўв йастәс: ‘Лотәӈ войәт нӑӈена тына питԓәт’, иса лотәӈ войәт сэма питсәт. Хун пӑ ԓўв йастәс: ‘Хӑншаӈ войәт нӑӈена тына питԓәт’, иса хӑншаӈ войәт сэма питсәт. ");
INSERT INTO kca_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Щиты Турәм нын ащан эԓты тащ нŏх ўсԓы пӑ мӑнэма мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ипуш ма уԓәмән ватсэм, вохатты питмеԓән козёл хор войәт иса хӑншаӈәт пӑ лотәӈәт усәт. ");
INSERT INTO kca_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Турәм ангел мӑнэма уԓәмән йастәс: ‘Иаков!’ Ма йастәсәм: ‘Ма щи’. ");
INSERT INTO kca_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ԓўв йастәс: ‘Ӑӈкәрма пӑ ванта: козёл хор войәт вохатты питмеԓән иса лотәӈәт пӑ хӑншаӈәт усәт. Мӑнэма иса ныԓа, мўй Лаван нӑӈ пиԓэнән верәԓ. ");
INSERT INTO kca_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ма Вефильән нӑӈ хŏщайэн этԓыйәм Турәм, хŏта нӑӈ оливка вŏй кев эԓты шошәпсән пӑ Мӑнэма так йасәӈ мӑсән. Ин нӑӈ нŏх ԓойа, тӑм мўв хӑйи пӑ нӑӈ сэма питәм мўвена йŏхԓы мӑна’». ");
INSERT INTO kca_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Рахиль пӑ Лия ԓўвеԓ йŏхԓы йастәсӈән: «Ащемән хот эԓты мин йўканэмәна хӑйәм мŏԓты пŏрмәс уԓ а мўй? ");
INSERT INTO kca_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Аԓт пӑ пўӈәԓ ŏтәта минэмән ԓўӈәтԓәԓы? Минэмән тынысԓы пӑ шитәм щел ŏхәԓ ищи посатсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Щишән, Турәмән ащемән эԓты нŏх ўйәм тащ мўӈева пӑ мўӈ ԋаврэмԓува уԓ; щишән, хŏты нӑӈена Турәм йастәс, хŏԓ щиты веры». ");
INSERT INTO kca_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Иаков нŏх ԓойәс, ԋаврэмԓаԓ пӑ имиԓаԓ верблюдәт шӑнша опсәԓсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","шитәм тащԓаԓ пӑ пŏрмасԓаԓ пӑтән ўсԓы, Месопотамия мўвән ԓўв шитәм тащԓаԓ пӑ пŏрмасԓаԓ, Ханаан мўва Исаак ащеԓ хŏща мӑнты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Лаван пӑ, ошԓаԓ ԓŏртты мӑнмаԓән, Рахиль эвеԓән ԓухԓаԓ нŏх ԓŏԓәпсайәт. ");
INSERT INTO kca_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Иаков пӑ Лаван арамей ики ԓэпәԓсәԓы, ԓўв эԓтэԓ хŏнтаман мӑнәс, мӑнты айкеԓән ӑт версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Мўй тӑйәс, щитәԓ пиԓән мӑнәс; йŏхан ўшсәԓы пӑ Галаад кев ўр пеԓа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Хуԓмет хӑтәԓән Иаков мӑнәм вер Лавана йастәса. ");
INSERT INTO kca_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ԓўв рутԓаԓ ԓўв пиԓәԓән ўс пӑ ԓапәт хӑтәԓ ԓўв йўпеԓән ԋухԓәсәс, Галаад кев ўр хŏща эԓты йŏхәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Атән Лаван арамей ики хŏща уԓәмән Турәм йŏхтәс пӑ ԓўвеԓа йастәс: «Пӑԓԓән ки, Иакова йӑм аԓ йаста, атәм аԓ йаста». ");
INSERT INTO kca_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Лаван Иаков эԓты йŏхәтсәԓы; Иаков пирщин хŏтԓаԓ кев ўр хŏща ԓощсәԓы, Лаван пӑ рутԓаԓ пиԓән ищи Галаад кев ўрән пирщин хŏтԓаԓ ԓощсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Щӑԓта Лаван Иакова йастәс: «Мўй нӑӈ версән? Мўйа нӑӈ мӑнэм ԓэпәԓсэн пӑ эвеӈәԓам ԉаԉәсты иты, ԋӑрэмәман, тусԓан? ");
INSERT INTO kca_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Мўйа нӑӈ хӑԋайән мӑтсән, ма эԓтэм хӑԋэмәсән, мӑнэма ӑт йастәсән? Ма, ԓуԓән, нӑӈен каш пиԓән, ар пиԓән, тимпанән пӑ нарәс йўхән йŏтман эсәԓсэм. ");
INSERT INTO kca_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Нӑӈ мӑнэма хиԓыԓам пӑ эвиԓам мосәԓтәты ӑт эсәԓсэн; нӑӈ щит ӑт нумәсман версэн. ");
INSERT INTO kca_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Нынан атәм верты йур ма тӑйԓәм; туп нын ащан Турәм мŏԓха атән мӑнэма йастәс: ‘Пӑԓа, Иакова атәм ӑԓ йаста, йӑм аԓ йаста’. ");
INSERT INTO kca_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ат уԓ, нӑӈ мӑтсән, ащен хота нӑӈ мӑнты шек ԓӑӈхасайән, – туп мўйа нӑӈ ма ԓухԓам ԓоԓәпсәԓан?» ");
INSERT INTO kca_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Иаков Лаван пеԓа йастәс: «Ма пӑԓсәм, щиты нумәссәм, нӑӈ эвеӈәԓан йурән нŏх ӑт ат ўсԓан, ԓўԓән. ");
INSERT INTO kca_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Хŏй хŏща ԓухԓан уйәтԓәԓан, щит ԓыԓӈа уԓты ӑт питәԓ; рутԓәмән уԓман ванты, мўй нӑӈ ŏтэн эԓты ма хŏщайэм уԓ, пӑ нӑӈена ўйи». Иаков ӑт уйәтсәԓы, щит Рахильән ԓоԓәпсайәт. ");
INSERT INTO kca_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Иаков пирщин хота Лаван йӑӈхәс, пӑ Лия пирщин хота, пӑ митнэӈӈән пирщин хота, туп нэмәԓты ӑт уйтәс. Щӑԓта, Лия пирщин хот эԓты этмаԓән, Рахиль пирщин хота ԓŏӈәс. ");
INSERT INTO kca_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Рахиль щи йэԓпийән ԓухԓаԓ ўсԓы пӑ верблюд шӑнша хушәм хира пŏтсәԓы, щӑԓта эԓты омәссәԓы. Лаван пирщин хот хŏԓ кӑшсәԓы пӑ нэмәԓты ӑт уйтәс. ");
INSERT INTO kca_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ԓўв ащеԓа щиты йастәс: «Кущайэм ӑт ат ԉикащәԓ, ма ԓўв йэԓпеԓән нŏх ԓойты ӑт верәтԓәм, нэ верән уԓԓәм». Пӑ Лаван кӑншатәс, туп ԓухԓаԓ ӑт уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Иаков ԉикащәс пӑ Лаван пиԓән ԉавәтты питәс. Иаков пŏтәртты питәс пӑ Лавана йастәс: «Мўй хŏрпи нўр тӑйԓәм, мўй хŏрпи кӑрэк версәм, ма йўпем нӑӈ туԓэн? ");
INSERT INTO kca_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Хŏԓ пŏрмасԓам нӑӈ вӑтсәԓан, нӑӈ хотэн пŏрмасәт эԓты нӑӈ мўй уйәтсән? Этәԓтыйи тӑта нӑӈ рутԓан йэԓпийән пӑ ма рутԓам йэԓпийән; ԓыв минэмән ат сўтәтԓэԓ. ");
INSERT INTO kca_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Хус тӑԓ ма нӑӈ хŏщайэн усәм; коза пӑ ош нэ войәт ӑт мушмиԓысәт, тащен эԓты ош ма ӑт ԓэсәм; ");
INSERT INTO kca_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","войән веԓәм ŏт нӑӈена ма ӑт тутԓысәм, щит ма сŏхәптысэм; нӑӈ ма эԓтэм иса нŏх кӑшсэн, мўй хӑтԓәԓән ушәс, мўй атәԓән тӑпәс, ");
INSERT INTO kca_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","хӑтԓәԓән рўв эԓты, атәԓән ищки эԓты шукащсәм, ŏԓмем ӑт ŏԓԓысәм. ");
INSERT INTO kca_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Щиты хус тӑԓ нӑӈ хотэнән усәм. Ԋӑԓхŏщйаӈ тӑԓ эвеӈәԓан урәӈән рупитсәм пӑ хут тӑԓ тащен урәӈән, нӑӈ пӑ сŏхәптәты тынэн йаӈ пўш пелтыԓысэн. ");
INSERT INTO kca_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ащем Турәм ма пиԓэмән ӑт ки ус, Авраам Турәм пӑ Исаак пӑԓты Ŏт, нӑӈ мӑнэм таԓты китсэн, ԓуԓән. Ма шукащты верэм пӑ ма йошԓам рупата Турәм кащаԓәсԓы пӑ хӑщәм атән мӑнэм эԓт питсәԓы». ");
INSERT INTO kca_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Щӑԓта Лаван пŏтәртәс пӑ Иакова щиты йастәс: «Эвеӈәԓам – ма эвеӈәԓам; ԋаврэмәт – ма ԋаврэмԓам; тащ – ма тащем, иса, мўй нӑӈ ватԓән, щит мӑнэм: ма эвеӈәԓам пиԓән пӑ ԓын тӑйәм ԋаврэмԓән пиԓән мўй верты верәтԓәм? ");
INSERT INTO kca_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ин ма пӑ нӑӈ йастатԓәмән кўтԓәмәнән йӑма уԓты, щи йастантәпса минэмән нумты ат питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Иаков кев шуп ўс пӑ нумты кева омәссәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Щӑԓта Иаков рутԓаԓа йастәс: «Кевәт ӑктаты». Ԓыв кевәт ӑкәтсәт пӑ кев пай версәт, щи кев пай ԓоӈәԓән ԓэсәт. ");
INSERT INTO kca_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Лаван кев пай щиты нэмәтсәԓы: Иегар-Сагадуфа; Иаков пӑ кев пай Галаада нэмәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Щӑԓта Лаван йастәс: «Тӑм хӑтәԓ тӑм кев пай мин кўтэмәнән вер вантәм ŏта питәԓ». Щишән, нэмән пŏтса: Галаад, ");
INSERT INTO kca_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","хŏԓна пӑ: Мицпа, щит Лаван йастәм урәӈән: «Турәм Куща мӑнэм пӑ нӑӈен ватман ат тӑйԓәԓы, хун уԓты кўтэмән хўва питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","эвеӈәԓам пиԓән атма уԓты питԓән ки мўй пӑ ма эвеӈәԓам тўмпийән хŏԓна имет ўԓән ки, кўш щит ватты хŏйат ӑнтом, нӑӈ уйты, Турәм ищипа ватәԓ». ");
INSERT INTO kca_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Щӑԓта Лаван Иакова йастәс: «Тӑта щи кев пай пӑ нумты кев, щит мин кўтэмәнән ма ԓощсэм; ");
INSERT INTO kca_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","тӑм кев пай вер вантәм ŏта питәԓ, па нумты кев ищи вер вантәм ŏта питәԓ, тӑм кев пай пӑ нумты кев атәм верты урәӈән нӑӈ ма пелкема ӑт ўшԓэн пӑ ма нӑӈ пелкена ӑт ўшԓэм; ");
INSERT INTO kca_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Авраам Турәм пӑ Нахор Турәм, ԓын ащан Турәм, мин кўтэмәнән ат сўтытәԓ». Исаак ащеԓ пӑԓәм Турәмән Иаков йасәӈ мӑс. ");
INSERT INTO kca_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Иаков щи кев ўрән йир тус пӑ рутԓаԓ порыԓыты вохсәԓы; ԓыв порыԓысәт пӑ щи кев ўрән хоԓсәт. ");
INSERT INTO kca_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Аԓәӈсӑхат аԓәӈ Лаван нŏх киԓәс, хиԓыԓаԓ пӑ эвеӈәԓаԓ мосәԓтәсԓы пӑ йӑм йасәӈән мӑсԓы. Щӑԓта Лаван мӑнәс пӑ ԓўв хотәԓа йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Иаков пӑ ԓўв йушәԓән мӑнәс. Турәм ангеләт ԓўв йэщаԓтэԓ этсәт. ");
INSERT INTO kca_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ԓывиԓаԓ кащаԓәмаԓән, Иаков йастәс: «Тӑм Турәм ԉаԉ йох уԓты тӑха». Щишән, щи тӑха нэмәтсәԓы: Маханаим. ");
INSERT INTO kca_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Щӑԓта Иаков Исав йайәԓ хŏща Сеир кев мўва, щит Едом мўвән, айкеԓ туты хŏйатәт ԓўв йэԓпеԓән китсәԓы, ");
INSERT INTO kca_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ԓывиԓаԓа партсәԓы: «Исав кущайэма щиты йастаты: Иаков митхуйэн тӑмиты пŏтәртәԓ: ‘Лаван хŏща тӑм хӑтәԓ унты ма усәм; ");
INSERT INTO kca_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","хор мисәт пӑ осёл войәт, ош тащ, митйохәт пӑ митнэӈәт ма тӑйԓәм; кущайэма ма эԓтэм айкеԓ ма китԓәм, йӑм сэмән митхуйәԓ пеԓа ат вантәс, ԓуԓән’». ");
INSERT INTO kca_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Айкеԓ тўвәм йох Иаков хŏща йŏхԓы йŏхәтсәт пӑ йастәсәт: «Исав йайән хŏща йӑхсув; ԓўв нӑӈ пеԓайэн йэщаԓт йиԓ, ԓўв пиԓәԓән ԋӑԓсот хŏйат». ");
INSERT INTO kca_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Иаков шек пӑԓтамәс пӑ сӑмәԓ мӑнәс; щӑԓта ԓўв пиԓәԓән йўвәм хŏйатԓаԓ, ошԓаԓ, козайԓаԓ, мисԓаԓ, верблюдԓаԓ кӑтна ортсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Пӑ йастәс: «Исав и пелкәԓ веԓты питԓәԓы ки, кимет пелкәԓ ԓыԓәԓ этәԓ». ");
INSERT INTO kca_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Щӑԓта Иаков йастәс: «Авраам ащем Турәм пӑ Исаак ащем Турәм, Турәм Куща, мӑнэма тӑмиты йастыԓыйәм Ŏт: ‘Мўвена йŏхԓы мӑна, сэма питәм мўвена, пӑ Ма нӑӈен йӑмән верты питԓэм!’ ");
INSERT INTO kca_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Нэмәԓтыйа ӑт рӑхты митхулэӈкена щи арат йӑм пӑ щи арат ŏй Нӑӈ мӑсән; мӑнмемән, ма нэмәԓты ӑт тӑйсәм, туп шушты сўвем пиԓән тӑм Иордан йŏхан ўшсэм, ин пӑ кӑт хот тэԓ тӑйԓәм. ");
INSERT INTO kca_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Исав йайәм йош эԓты мӑнэм шавийи, ма щит эԓты пӑԓԓәм, ԓўв йŏхәттаԓән, мӑнэм пӑ ԋаврэмәт аԋԏиԓаԓ пиԓән веԓԓәԓы. ");
INSERT INTO kca_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Нӑӈ йастәсән: ‘Ма нӑӈен йӑмән верты питԓэм пӑ тыхәԓ тэԓэн щарәс сэй хиш иты ара верԓэм, щи аратәԓ ԓўӈәтты ӑт верәтԓа’». ");
INSERT INTO kca_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Щи ат Иаков щита хоԓәс. Тӑйәм ŏтәԓ эԓты Исав йайәԓа мойԓәпса ԓэщатәс: ");
INSERT INTO kca_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","кӑтсот коза нэ вой, хус козёл хор вой, кӑтсот нэ ош, хус хор ош, ");
INSERT INTO kca_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","хŏԉмаӈ пусты верблюд нэ вой ԓыв пŏшәхԓаԓ пиԓән, ԋӑԓйаӈ мис, йаӈ хор мис, хус осёл нэ вой, йаӈ осёл хор вой. ");
INSERT INTO kca_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Митйохԓаԓ йоша кашәӈ тащ атэԓт мӑсԓы пӑ митйохԓаԓа йастәс: «Ма йэԓпемән мӑнаты пӑ кўтән-кўтән тащԓән хӑйаԓән». ");
INSERT INTO kca_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Мет оԓәӈ ŏтәԓа щиты йастәман, партәс: «Щӑха, Исав йайәм нӑӈ пиԓэнән уйтаттаԓән, ԓўв нӑӈен иԋщәсԓәԓы: ‘Нӑӈ хŏй? Пӑ хŏԓта мӑнԓән? Пӑ хŏй тащ нӑӈ воштәԓән?’ ");
INSERT INTO kca_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","нӑӈ щиты йаста: ‘Иаков митхуйэн тащ; Исав кущайәԓа мойԓәпсайа ԓўв китсәԓы; ԓўв пӑ мўӈ йўпевән йиԓ’». ");
INSERT INTO kca_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Щиты кимет, хуԓмет пӑ хŏԓ тащәт шавийәм митйоха йастәты партәс: «Тӑмиты Исава йастаты, хун ԓўв пиԓәԓән уйтатԓыты; ");
INSERT INTO kca_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","пӑ йастаты: ‘Иаков митхуйэн пӑ мўӈ йўпевән йиԓ’». Ԓўв щиты нумәсәс: «Ԓўвеԓ кащаԓәтэм йэԓпийән, оԓӈа китәм мŏйԓәпсайԓамән сӑмәԓ ԓэптапԓэм, мосәӈ, ԓўв мӑнэм вана ўԓԓы». ");
INSERT INTO kca_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Щиты Иаков мойԓәпсайԓаԓ оԓӈа мӑтсәт, ԓўв пӑ щи ат пирщин хотәԓән хоԓәс. ");
INSERT INTO kca_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Щӑԓта атәԓән нŏх киԓәс, имеӈәԓаԓ пӑ митнэӈәԓаԓ ўсԓы, пӑ ихŏщйаӈ пŏхәԓ ўсԓы, пӑ Иавок йŏхан кўрән шŏппи ўшсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ԓывиԓаԓ йŏхан шŏппи тусԓы пӑ мўй ԓўв тӑйәс, хŏԓ йŏхан шŏппи ўншәптәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Щӑԓта Иаков утща хӑщәс. Аԓәӈ хўщәԓ унты ԓўв пиԓәԓән Ахой катԓантыйәс; ");
INSERT INTO kca_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ӑт верәмтаԓ мŏштымаԓән, Ԓўв Иаков пещ ԓŏв йӑта хойԓыйәс пӑ Иаков пещ ԓŏв йӑт мушмәԓтсәԓы, хун ԓўв Ԓўв пиԓәԓән катԓантыйәс. ");
INSERT INTO kca_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Пӑ йастәс: «Эсԓы Мӑнэм, хущәԓ этәс». Иаков йастәс: «Ӑт эсәԓԓэм Нӑӈен, мӑнэм йӑмән ӑт мӑтэн унты». ");
INSERT INTO kca_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Щӑԓта йастәс: «Нӑӈ нэмен хŏты?» Ԓўв йастәс: «Иаков». ");
INSERT INTO kca_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Пӑ йастәс: «Тӑԓта йэԓԓы нӑӈ нэмен Израиль питәԓ, Иаков нэмен хӑйԓэн, нӑӈ Турәм пиԓән катԓантысән, пӑ хŏйатәт эԓты нŏх питты питԓән». ");
INSERT INTO kca_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Иаков ищи ԓўвеԓ иԋщәссәԓы, щиты йастәман: «Нӑӈ нэмен йасты». Пӑ Ԓўв йастәс: «Мўйа нӑӈ Ма нэмем иԋщәсԓән?» Пӑ щи тӑхайән Иаков йӑмән мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Иаков щи тӑха нэмәтсәԓы: Пенуэл; ԓўв щиты пŏтәртыйәс: «Ма Турәм веш ванән ватсэм пӑ ԓыԓӈа хӑщсәм». ");
INSERT INTO kca_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Най этәс, хун ԓўв Пенуэл мŏхты мӑнәс; пещәԓ урәӈән нохман шушәс. ");
INSERT INTO kca_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Щишән, интӑм унты израиль мир хŏйатәт пещән уԓты ԓон ӑт ԓэԓәт, щит Катԓантыйәм Ŏт Иаков пещ ԓŏв мушмәԓтмаԓән щи ԓона хойԓымаԓ урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Щӑԓта Иаков кащаԓәсԓы, хŏты Исав пӑ ԓўв пиԓәԓән ԋӑԓсот хŏйат йиԓ. Щӑԓта Иаков Лия, Рахиль пӑ митнэӈӈәԓаԓ ԋаврэмԓаԓ пиԓән иса атэԓт ԓощәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Митнэӈӈәԓаԓ ԋаврэмԓән пиԓән оԓӈа ԓощәԓтәсԓы, Лия ԋаврэмԓаԓ пиԓән ԓыв йўпеԓән, Рахиль пӑ Иосиф мет йŏԓта. ");
INSERT INTO kca_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ԓўв пӑ ԓыв йэщаԓтэԓ мӑнәс пӑ йайәԓ хŏща ванамәмаԓән, мўв унты ԓапәт пўш, ŏх пŏнман, иԓ ԋўрыԓыйәс. ");
INSERT INTO kca_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Исав пӑ ԓўв йэщаԓтәԓ хухәԓмәс, пӑ сапԓәԓ эԓты ԓўвеԓ ӑпәԓсәԓы, мосәԓтәсԓы, пӑ хоԓԓәстән. ");
INSERT INTO kca_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Имет пӑ ԋаврэмәт кащаԓәс пӑ иԋщәссәԓы: «Щит хŏйтыԓан?» Иаков йастәс: «Турәмән мӑнэма, нӑӈ митхуйэна, мойԓәм ԋаврэмәт». ");
INSERT INTO kca_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Щӑԓта митнэӈәт ԋаврэмԓаԓ пиԓән вана йисәт пӑ, ŏх пŏнман, иԓ ԋўрсәт; ");
INSERT INTO kca_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Лия ԋаврэмԓаԓ пиԓән ищи вана йис пӑ, ŏх пŏнман, иԓ ԋўрсәт; мет йухәт Иосиф пӑ Рахиль вана йистән пӑ, ŏх пŏнман, иԓ ԋўрсәтән. ");
INSERT INTO kca_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Щӑԓта Исав йастәс: «Мўйа нӑӈ тӑм тащԓан ма йэщаԓтэм китсәԓан?» Иаков йастәс: «Кущайэм йӑм сэмән ма пеԓайэм, ат вантәс, ԓўԓән». ");
INSERT INTO kca_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Исав йастәс: «Апщийэм, ма тӑйты ŏтэм ар; нӑӈ ŏтэн нӑӈ хŏщайэн ат уԓ». ");
INSERT INTO kca_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Иаков йастәс: «Ӑнта, нӑӈ ма пеԓайэм йӑм сэмән ватԓән ки, мойԓәпсайэм ма йошем эԓты ўйи, нӑӈ веншен ваттэмән щит Турәм веш ваттэм хŏрпи, нӑӈ пӑ ма пеԓайэм щи арат йӑм усән; ");
INSERT INTO kca_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","нӑӈена тўвәм мойԓәпсайэм ўйи, щит Турәм мӑнэма мойԓәс, щишән, ма мўй иса тӑйԓәм». Щиты Иаков Исав пойәксәԓы, пӑ ԓўв ўсԓы ");
INSERT INTO kca_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","пӑ йастәс: «Нŏх ԓойԓув пӑ мӑнԓув; ма нӑӈ йэԓпенән мӑнԓәм». ");
INSERT INTO kca_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Иаков ԓўвеԓа йастәс: «Кущайэм уйәтԓәԓы, ԋаврэмәт вевԓэт, щӑԓта, пусты мисәт пӑ ошәт тӑйԓәм: и хӑтәԓ сыс такан воштәты ки, войәт хŏԓ хӑԓԓәт; ");
INSERT INTO kca_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","кущайэм митхуйәԓ йэԓпийән ат мӑнәԓ, ма пӑ айәԓта, тащ мӑнты кемән, пӑ ԋаврэмԓам хŏты шушԓәт, пӑ кущайэм хŏща Сеир мўва йŏхәтԓәм». ");
INSERT INTO kca_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Исав йастәс: «Ма хŏйатԓам эԓты кӑмәтса нӑӈ пиԓэнән хӑйԓәм». Иаков йастәс: «Мўй урәӈән? Йӑм сэмән кущайэм ма пеԓайэм ватәԓ ки, щит щи ŏй!» ");
INSERT INTO kca_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Щиты Исав ищи хӑтәԓән Сеир мўва йŏхԓы мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Иаков пӑ Сокхоф пеԓа мӑнәс, щита хот опсәс, вой шавиты варәс хотәт ищи верәс. Щишән, щи тӑха щиты нэмәтсәԓы: Сокхоф. ");
INSERT INTO kca_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Иаков, Месопотамия эԓты йŏхәтмаԓән, Ханаан мўвән уԓты Сихем воша йӑма йŏхтәс, щита вош йэԓпийән уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Щӑԓта мўв хӑр щи пеләк, хŏта ԓўв пирщин хотԓаԓ верәс, сот щел ŏх сӑхат Еммор пŏхәт эԓты, Сихем пӑ ԓўв апщиԓаԓ эԓты, Иаков ԓўвеԓа ԓутсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Щӑԓта щита йирасты нŏрәм ԓўв верәс пӑ Турәм Куща пеԓа, Израиль Турәм пеԓа, пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Дина, щит Иаков эԓты Лия тӑйәм эви, щи мўвәӈ эвет пиԓән уйтантыты мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Пӑ щи мўв кӑнащ ики, Еммор ев ики, Сихем нэмпи пŏхән ԓўв кащаԓәса, ԓўв эви йурән катәԓсәԓы пӑ ԓўв пиԓәԓән ŏԓәс. ");
INSERT INTO kca_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Щӑԓта Иаков Дина эви пеԓа нŏпсәԓ питәс пӑ ԓўвеԓа эви сӑма рӑхәс, пӑ ԓўв эвийа ԏўпаӈ йасӈәт пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Еммор ащеԓа Сихем щиты йастәс: «Щи эви мӑнэма нэӈа ўйи». ");
INSERT INTO kca_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Иаков хуԓтсәԓы, хŏты Еммор пŏх ԓўв Дина эвеԓ пиԓән атәм вер верәс, туп пŏхԓаԓ тащеԓ пиԓән щӑхәрән усәт, щишән, ԓыв йŏхәттэԓ унты Иаков мӑшйайа ус. ");
INSERT INTO kca_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Еммор, Сихем ащи, Иаков хŏща пŏтәртты йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Иаков пŏхәт щӑхәр эԓты йŏхәтмеԓән щи вер эԓты хуԓтсэԓ, щи йох нŏпсэԓ шӑкәс пӑ шек ԉикащсәт, Израиля атәм вер верәм урәӈән, Иаков эви пиԓән Сихем ŏԓмаԓ урәӈән. Щиты верты ӑт рӑхәс. ");
INSERT INTO kca_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Еммор ԓыв пиԓэԓән пŏтәртты питәс пӑ йастәс: «Сихем пŏхем нын эван пеԓа нŏпсәԓ шек уԓ, щишән имийа ԓўвеԓа мийаԓән; ");
INSERT INTO kca_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","рута мўӈ пиԓэвән уԓаты; нын эвиԓән мўӈева мийԓыйаԓән, мўӈ эвиԓув пӑ ўйԓыйаԓән; ");
INSERT INTO kca_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","щӑԓта мўӈ пиԓэвән уԓаты; тӑм мўв нын йэԓпанән, касԓыйаты пӑ тӑм мўвән уԓаты, пӑ нынана тӑйты йŏра мўва ԓутаԓән». ");
INSERT INTO kca_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Сихем пӑ эви ащийа пӑ йайԓаԓа йастәс: «Йӑм сэмән ма пеԓайэм ватԓәты ки, мўй ӑт йастәԓты, ма иса мӑԓәм; ");
INSERT INTO kca_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","мет ун тын пӑ мойԓәпсайәт йастаты, ма мӑԓәм, мўй мӑнэма ӑт йастәԓты, туп эви мӑнэма имийа мийаԓән». ");
INSERT INTO kca_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Иаков пŏхәт Дина апщеԓ атәм вера пайтәм урәӈән, Сихема пӑ Еммор ащеԓа ԋаԓмиман йŏхԓы пŏтәртсәт; ");
INSERT INTO kca_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","пӑ щиты Симеон пӑ Левий йастәсӈән: «Эвтәм вер ӑт тӑйты хŏйат сайа апщев мӑты мўӈ ӑт верәтԓув, щит мўӈева йэм, ӑт рӑхәԓ; ");
INSERT INTO kca_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","туп нын пиԓанән и верән и нŏпса йŏхәтԓув, хун нын мўӈ итэва йиԓты, хун хŏԓ йох рутән эвтәм вер тӑйты питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","щи пŏрайән мўӈ эвиԓув нынана мӑты питԓәԓув пӑ нын эвиԓән мўӈева ўты питԓәԓув, йӑха уԓты питԓув пӑ и мира йиԓув; ");
INSERT INTO kca_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","щи эвәтты верән мўӈев ӑт хуԓәтԓәты ки, эвев нŏх ўԓэв пӑ мӑнԓув». ");
INSERT INTO kca_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Еммора пӑ Сихем пŏхәԓа щи йасӈәт рӑхсәт. ");
INSERT INTO kca_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Энәмты пŏх мŏхты щи вер верты ԓэщатыйәс, Иаков эви ԓўвеԓ шек сӑма рӑхәс. Ащеԓ хотән ԓўв мет ԓӑтәӈа ԓўӈтәсәс. ");
INSERT INTO kca_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Щӑԓта Еммор Сихем пŏхәԓ пиԓән вошәӈ пушас ун ова йŏхәтсәӈән пӑ вошәӈ йох пеԓа пŏтәртты питсәӈән пӑ йастәсӈән: ");
INSERT INTO kca_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Тӑм хŏйатәт мўӈ пиԓэвән йӑма уԓты ԓӑӈхаԓайәт; ат уԓԓәт пӑ касԓыԓәт тӑм мўвән; мўв тӑта ԓӑщкам. Ԓыв эвиԓаԓ нэӈа ўты питԓәԓув, мўӈ эвиԓув пӑ ԓывиԓаԓа мӑԓԓув. ");
INSERT INTO kca_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Туп щи щирән щи хŏйатәт мўӈ пиԓэвән и мир иты уԓты кашащԓәт, мўӈ йохԓув па хŏԓыйэ, ԓыв итэԓән эвәтман ат усәт, ԓуԓән. ");
INSERT INTO kca_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ԓыв тащԓаԓ, пŏрмасԓаԓ аԓт мўӈева питԓәт? Ин ԓыв пиԓԓаԓән кашащԓув, пӑ ԓыв мўӈ пиԓэвән йӑха уԓты питԓәт». ");
INSERT INTO kca_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Щӑԓта вошәӈ пушас ун ов хŏща ӑктәщиты йох, Еммор пӑ Сихем пŏхәԓ йасӈәта хŏԓ эвәԓсәт: вошәӈ йох хŏԓ эвәтты верән версайәт. ");
INSERT INTO kca_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Хуԓмет хӑтәԓән, хун ԓыв эвтәм ԋўләмԓаԓ кӑшәтсәт, Иаков пŏхӈиԓаԓ, Симеон пӑ Левий, Дина йайӈән, аԓтты кешиԓән ўсԓән, пӑ айԓы-кеԓԓы воша мӑтсәӈән, пӑ йох хŏԓ пӑратсәԓән. ");
INSERT INTO kca_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Еммор ики Сихем пŏхәԓ пиԓән аԓтты кешийән ищи веԓсәԓән; Сихем хот эԓты Дина ўсԓән пӑ мӑтсәӈән. ");
INSERT INTO kca_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Иаков пŏхәт пӑратәм ŏтәт хŏща йŏхәтсәт пӑ тынәӈ пŏрмасәт пӑтән ўсԓаԓ, ԓыв апщеԓ атәм вера питәԓтәм урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Мис тащәт, ош тащәт пӑ осёл войԓаԓ ԓывиԓаԓа воштәсԓаԓ, мўй вошән ус, мўй щӑхәрән ус, иса ўсԓаԓ; ");
INSERT INTO kca_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","пӑ хŏԓ ԓыв тащԓаԓ, пӑ хŏԓ ԋаврэмԓаԓ, пӑ ԓыв нэԓаԓ ԋӑрэмәман тусԓаԓ, пӑ пŏрмасәт, хотәтән мўй ус, иса пӑтән тусԓаԓ. ");
INSERT INTO kca_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Щӑԓта Иаков Симеон пӑ Левий пеԓа йастәс: «Нын мӑнэм атәм вера пайәтсәԓән, тӑм мўв хŏйатәтән, ханаан йохән пӑ ферез йохән, ԉикән этты питԓайәм. Ма шимәԓ хŏйат тӑйԓәм; ԓыв ийӑха ӑктәщԓәт, ԉаԉән йŏхәтԓәт пӑ хотэм пиԓән пӑратԓайув». ");
INSERT INTO kca_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ԓын пӑ йŏхԓы йастәстән: «Мўӈ апщев уԉԋа нэӈа тӑйты рӑхәԓ мўй?» ");
INSERT INTO kca_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Турәм Иакова йастәс: «Ԓойа, Вефиля мӑна пӑ щита уԓа, пӑ йирасты нŏрәм щита Мӑнэма вера, нӑӈ хŏщайэн этԓыйәм Турмена, хун нӑӈ пӑ Исав эԓты, нӑӈ йайән эԓты, хŏнтасән». ");
INSERT INTO kca_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ԓўв хот тэԓәԓа пӑ ԓўв пиԓәԓән уԓәм ŏтԓаԓа Иаков йастәс: «Ин тӑйты па мир ԓуӈхәт вŏщкаԓән, сыстамтыйаты, пӑ па сŏх ԓумтаты; ");
INSERT INTO kca_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ԓойԓув пӑ Вефиля мӑнԓув; щита Турма йирасты нŏрәм ма верԓәм, Хŏй мӑнэм шука питәм хӑтԓэмән хуԓтсәԓы пӑ йушән, хŏта ма йӑхсәм, ма пиԓэмән ус». ");
INSERT INTO kca_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Щӑԓта тӑйәм па мир ԓуӈхәт пӑ пӑԓән тӑйәм пӑԓрунтәт ԓыв Иакова хŏԓ мӑсԓаԓ, щи пŏрмасәт Сихем пўӈәԓән уԓты дуб йўх иԓпийән Иаковән мўва шависайәт. ");
INSERT INTO kca_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Щӑԓта ԓыв мӑтсәт. Пӑ ван вошәтән Турәм эԓты пӑԉщәм ус, пӑ щишән Иаков пŏхәт ӑт ԋухәԓсайәт. ");
INSERT INTO kca_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Иаков Ханаан мўвән уԓты Луз воша йŏхтәс, щит Вефиль, ԓўв пӑ ԓўв пиԓәԓән уԓәм хŏйатәт. ");
INSERT INTO kca_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Щита йирасты нŏрәм верәс, пӑ щи тӑха нэмәтсәԓы: Эл-Вефиль, щита ԓўв хŏщайәԓ Турәм этԓыйәс, хун ԓўв йайәԓ эԓты хŏнтас. ");
INSERT INTO kca_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Щӑԓта Девора пӑрәс, Ревекка эсәмән ԓаптәм ими, Вефиль эԓты ныкԓы дуб йўх иԓпийән ԓўв лоттәман уԓ пӑ щи йўх Иаковән «Хŏԓԓәп дуб йўха» нэмәтса. ");
INSERT INTO kca_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Месопотамия эԓты Иаков йŏхәтмаԓ йўпийән Турәм ԓўв хŏщайәԓ па этәс пӑ ԓўвеԓ йӑмән мӑсԓы; ");
INSERT INTO kca_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","пӑ Турәм ԓўвеԓа йастәс: «Нӑӈ нэмен Иаков; тӑԓта йэԓԓы Иаков нэм тӑйты нӑӈ ӑт питԓән, нӑӈ нэмен питәԓ Израиль». Пӑ Израиль нэмән ԓўвеԓ мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Пӑ Турәм ԓўвеԓа йастәс: «Ма Иса Верәтты Турәм; рутма пӑ ара йўва; мир пӑ ар мир нӑӈ эԓтэн питәԓ, хонәт нӑӈ эԓтэн этԓәт; ");
INSERT INTO kca_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Авраама пӑ Исаака мийәм мўв Ма нӑӈена мӑԓэм, нӑӈ тыхԓэна тӑм мўв па мӑԓэм». ");
INSERT INTO kca_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Щӑԓта щита пŏтәрттәм тӑхайәԓ эԓты Турәм нŏх эԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Турәм ԓўв пиԓәԓән пŏтәртәм тӑхайән Иаков нумты кев ԓоԋщәс, щи нумты кев йир йўкана ўнайән шошәпсәԓы, пӑ оливка вŏйән шошәпсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Щи тӑха, хŏта Турәм ԓўв пиԓәԓән пŏтәртәс, Иаков нэмәтсәԓы: Вефиль. ");
INSERT INTO kca_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Щӑԓта Вефиль эԓты йэԓԓы мӑтсәт. Ефрафа унты йэша ӑт йŏхәтмеԓән, Рахиль ԋаврэм сэма пайтәс, щи верәԓ шек ԓавәрт ус. ");
INSERT INTO kca_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Хун ԓўв шукащәс, ԋаврэмәԓ пўкән эвтәм ими ԓўвеԓ йастәс: «Аԓ пӑԓа, пŏхән па йŏхәтсайән». ");
INSERT INTO kca_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ԓыԓ шўвәԓ мӑнмаԓән, пӑрты ўша йŏхәтмаԓән, Рахиль ԓўвеԓ нэмән мӑсԓы: «Бенони». Ащеԓән пӑ Вениамина нэмәтса. ");
INSERT INTO kca_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Пӑ Рахиль пӑрәс, пӑ Ефрафа, щит Вифлеем пеԓа мӑнты йуш пўӈәԓән ԓўв лоттәса. ");
INSERT INTO kca_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ԓўвеԓ лоттәм тӑхайән Иаков нумты кев ԓоԋщәс. Щит Рахиль нумты кев тӑм хӑтәԓ унты уԓ. ");
INSERT INTO kca_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Израиль йэԓԓы мӑнәс пӑ Гадер тащ ватты пӑԓ хот сайән пирщин хотәԓ ԓощсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Израиль щи мўвән уԓмаԓ сыс Рувим пŏхәԓ ащеԓ Валла ай нэ пиԓән уԓмаԓ. Израиль щит эԓты хуԓтсәԓы. Иаков кӑтхŏщйаӈ пŏх тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Лия пŏхәт: Иаков оԓәӈ пŏхәԓ Рувим, ԓўв йўпеԓән Симеон, Левий, Иуда, Иссахар пӑ Завулон. ");
INSERT INTO kca_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Рахиль пŏхәт: Иосиф пӑ Вениамин. ");
INSERT INTO kca_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Валла, Рахиль митнэ, пŏхәт: Дан пӑ Неффалим. ");
INSERT INTO kca_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Зелфа, Лия митнэ, пŏхәт: Гад пӑ Асир. Щит Иаков пŏхәт Месопотамия мўвән сэма питсәт. ");
INSERT INTO kca_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Щӑԓта Иаков Исаак ащеԓ хŏща йŏхтәс, Мамре, Кириаф-Арба хŏща, щит Хеврон, хŏта Авраам пӑ Исаак па мўв эԓты йŏхтәм ŏтәта усәт. ");
INSERT INTO kca_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Иуԓтыйа Исаак уԓәм нуптәԓ сот ԋийәԓйаӈ тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Пирщамәм пӑ йӑмәс уԓмаԓ йўпийән, Исаак пӑрәс, пӑрәм ŏтԓаԓ хŏща мӑнәс; Исав пӑ Иаков пŏхӈиԓаԓән иԓ ԓэщатса. ");
INSERT INTO kca_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Тӑм Исав тыхәԓ тэԓ, Едом ищи ԓўв. ");
INSERT INTO kca_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Исав Ханаан мўв эвет эԓты нэӈәт ўс: Елон нэмпи хет ики Ада эвеԓ, пӑ Цивеон нэмпи ев ики Ана пŏхәԓ эви Оливема, ");
INSERT INTO kca_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Пӑ Васемафа, Измаил эви, Наваиоф апщи. ");
INSERT INTO kca_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада Исав эԓты Елифаз сэма пайтәс, Васемафа Рагуил сэма пайтәс, ");
INSERT INTO kca_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Иеус, Иеглом пӑ Корей Оливема сэма пайтәс. Щит Ханаан мўвән сэма питәм Исав пŏхәт. ");
INSERT INTO kca_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Щӑԓта Исав имиԓаԓ, пŏхԓаԓ, эвиԓаԓ пӑ хотәԓ хŏйатәт пӑ Ханаан мўвән шитәм тащԓаԓ хŏԓ ўсԓы, пӑ хŏԓ войԓаԓ, пŏрмасԓаԓ пиԓән па мўва мӑнәс, Иаков апщеԓ эԓты йэԓшәк, ");
INSERT INTO kca_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ԓын шек ар тащ тӑйсәтән, йӑха уԓты ӑт верәтсәтән, уԓты йŏхтәм мўвән хŏща тащԓын ӑт ԓэпсәт, ар тащ тӑйман урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Исав, Едом ищи ԓўв, Сеир кевәӈ мўв хŏща уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Тӑм Исав тыхәԓ тэԓ, едом йох ащи, Сеир кевәӈ мўв хŏща. ");
INSERT INTO kca_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Тӑм Исав пŏхԓаԓ нэмәт: Елифаз, Исав Ада имеԓ пŏх, Рагуил, Исав Васемафа имеԓ пŏх. ");
INSERT INTO kca_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Елифаз пŏхәт тӑйәс: Феман, Омар, Цефо, Гафам пӑ Кеназ. ");
INSERT INTO kca_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Исав пŏх Елифаз Фамна ай нэ тӑйәс. Ԓўв Елифаза Амалик пŏх тӑйәс. Тӑми Исав Ада имеԓ йэԓԓы уԓты ԋаврэмәт. ");
INSERT INTO kca_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Тӑм пӑ Рагуил пŏхәт: Нахаф пӑ Зерах, Шамма пӑ Миза. Щит Исав Васемафа имеԓ йэԓԓы уԓты ԋаврэмәт. ");
INSERT INTO kca_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Тӑм Исав Оливема имеԓ пŏхәт, Цивеон ики Ана пŏхәԓ эви: ԓўв Исава Иеус, Иеглом пӑ Корей тӑйәс. ");
INSERT INTO kca_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Тӑм Исав йэԓԓы уԓты ԋаврэмәт кўтән ун икет. Исав оԓәӈ пŏхәԓ Елифаз пŏхәт: ун ики Феман, ун ики Омар, ун ики Цефо, ун ики Кеназ. ");
INSERT INTO kca_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Ун ики Корей, ун ики Гафам, ун ики Амалик. Щит Елифаз хот ун икет Едом мўвән; щит Исав Ада имеԓ йэԓԓы уԓты ԋаврэмәт. ");
INSERT INTO kca_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Тӑм Исав пŏх Рагуил пŏхәт: ун ики Нахаф, ун ики Зерах, ун ики Шамма, ун ики Миза. Щит Рагуил ун икет Едом мўвән; щит Исав Васемафа имеԓ йэԓԓы уԓты ԋаврэмәт. ");
INSERT INTO kca_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Тӑм Исав ими Оливема пŏхәт: ун ики Иеус, ун ики Иеглом, ун ики Корей. Щит Исав ими Оливема, Ана ики эви, эԓты уԓәм ун икет. ");
INSERT INTO kca_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Тӑм Исав пŏхәт, пӑ ԓыв ун икиԓаԓ. Щит Едом хот. ");
INSERT INTO kca_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Тӑм пӑ щи мўвән уԓәм Сеир нэмпи хоррей ики пŏхәт: Лотан, Шовал, Цивеон, Ана, ");
INSERT INTO kca_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дишон, Эцер пӑ Дишан. Щит хоррей йох ун икет, Сеир пŏхәт, Едом мўвән. ");
INSERT INTO kca_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Лотан пŏхәт усәт: Хори пӑ Геман; Лотан нэ апщи: Фамна. ");
INSERT INTO kca_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Тӑм Шовал пŏхәт: Алван, Манахаф, Эвал, Шефо пӑ Онам. ");
INSERT INTO kca_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Тӑм Цивеон пŏхәт: Аиа пӑ Ана. Тӑм щи Ана, хŏй хошәм йиӈкәт таԓ хишәӈ мўвән уйтәс, хун Цивеон ащеԓ осёл войәт шавийәс. ");
INSERT INTO kca_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Тӑм Ана ики ԋаврэмәт: Дишон пӑ Оливема, Ана ики эви. ");
INSERT INTO kca_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Тӑм Дишон пŏхәт: Хемдан, Эшбан, Ифран пӑ Херан. ");
INSERT INTO kca_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Тӑм Эцер пŏхәт: Билган, Зааван пӑ Акан. ");
INSERT INTO kca_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Тӑм Дишан пŏхәт: Уц пӑ Аран. ");
INSERT INTO kca_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Тӑм хоррей йох ун икет: ун ики Лотан, ун ики Шовал, ун ики Цивеон, ун ики Ана, ");
INSERT INTO kca_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ун ики Дишон, ун ики Эцер, ун ики Дишан. Тӑм хоррей йох ун икет пӑ щит ԓыв рутԓаԓ нэмәт Сеир мўвән. ");
INSERT INTO kca_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Тӑм хонәт Едом мўвән хонәта усәт, израиль йох хŏща хонәт этәм йӑм йэԓпийән. ");
INSERT INTO kca_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Едомән хона Бела ус, Веор пŏх, ԓўв вошәԓ нэм Дингава. ");
INSERT INTO kca_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Щӑԓта Бела пӑрәс, Иовав ԓўв йўпеԓән хона питәс, Зерах пŏх, Восор эԓты. ");
INSERT INTO kca_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Иовав пӑрәс, Хушам ԓўв йўпеԓән хона питәс, Феман мўв эԓты. ");
INSERT INTO kca_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Хушам пӑрәс, Гадад ԓўв йўпеԓән хона питәс, Бедад пŏх, ԓўв мадиан йох Моав мўв хӑрән ԉаԉән нŏх питсәԓы; Гадад вошәԓ нэм Авиф. ");
INSERT INTO kca_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Гадад пӑрәс, Самла ԓўв йўпеԓән хона питәс, Масрека эԓты. ");
INSERT INTO kca_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Самла пӑрәс, ԓўв йўпеԓән Саул хона питәс, ԓўв йŏхан пўӈәԓән омәсты Реховоф вош эԓты ус. ");
INSERT INTO kca_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Саул пӑрәс, Баал-Ханан, Ахбор пŏх, ԓўв йўпеԓән хона питәс. ");
INSERT INTO kca_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Баал-Ханан, Ахбор пŏх, пӑрәс, щӑԓта Гадар ԓўв йўпеԓән хона питәс; ԓўв вошәԓ нэм Пау; имеԓ нэм Мегетавеель, Мезагав ики Матреда пŏхәԓ эви. ");
INSERT INTO kca_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Тӑм Исав эԓты мӑнәм ун икет нэмәт, рутԓаԓ щирән, мўвԓаԓ щирән, нэмԓаԓ щирән: ун ики Фимна, ун ики Алва, ун ики Иетеф, ");
INSERT INTO kca_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ун ики Оливема, ун ики Эла, ун ики Пинон, ");
INSERT INTO kca_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ун ики Кеназ, ун ики Феман, ун ики Мивцар, ");
INSERT INTO kca_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ун ики Магдиил, ун ики Ирам. Тӑм Едом мўв ун икет, вошԓаԓ щирән, ԓыв йошԓаԓән тӑйәм мўвеԓән. Щит иса Исав эԓты, едом йох ащи эԓты, мӑнәм рут. ");
INSERT INTO kca_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Иаков Ханаан мўвән ус, хŏта ащеԓ па мўв эԓты йŏхтәм ŏта ус. ");
INSERT INTO kca_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Тӑм Иаков рут уԓәпса эԓты пŏтәр. Ԓапәтхŏщйаӈ тӑԓ ԓŏват энәмты пŏх Иосиф тащ шавиман йайԓаԓ пиԓән йӑӈхәс, ащеԓ имеӈӈән пŏхәт пиԓән, Валла пŏхәт пӑ Зелфа пŏхәт пиԓән. Ащеԓа Иосиф йайԓаԓ эԓты пŏләщ тутԓыман йӑӈхәс. ");
INSERT INTO kca_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Йайԓаԓ кўтән Иосиф пŏхәԓ Израиль мет сӑма мосман тӑйсәԓы, ԓўв пирщамәмаԓән щи пŏхәԓ сэма питәс, щишән, хŏрамәӈ сŏхән ԓўвеԓ версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Йайԓаԓән мŏштәса, ащеԓ ԓўвеԓ пŏхԓаԓ кўтән мет сӑма мосман тӑйԓәԓы; Иосиф ԉикән этты питсэԓ пӑ йӑм щирән ԓўв пиԓәԓән пŏтәртты ӑт верәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ипуш Иосиф уԓәм вантәс, пӑ йайԓаԓа пŏтәртсәԓы; щи йўпийән мет такан ԉикән этты питса. ");
INSERT INTO kca_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ԓўв ԓывиԓаԓа йастәс: «Ма вантәм уԓмем хуԓәнтаты: ");
INSERT INTO kca_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ԋаԋ тŏрән энәмты хӑр кўтәпән мўӈ ԋаԋ тŏрән мŏнталэт йӑрԓув; пӑ ма йӑрәм ԋаԋ тŏрән мŏнталэм нŏх ԓойәс пӑ тўӈа ԓойәс, нын ԋаԋ тŏрән мŏнталыԓән пӑ керәтман ԓойсәт пӑ ма йӑрәм ԋаԋ тŏрән мŏнталэм пеԓа, ŏх пŏнман, иԓ ԋўрсәт». ");
INSERT INTO kca_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Йайԓаԓ ԓўвеԓа йастәсәт: «Нӑӈ мўй мўӈ нўмпевән хона питԓән? Мўӈ мўй нӑӈ иԓпенән питԓув?» Щи уԓмәԓ пӑ йасәӈԓаԓ урәӈән мет таканшәк ԉикән этты питса. ");
INSERT INTO kca_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Щӑԓта кимет уԓәм па вантәс, йайԓаԓа пŏтәртсәԓы, щиты йастәс: «Щиты ус, ма уԓәм па ватсәм: хӑтәԓ пӑ тыԓәщ пӑ ихŏщйаӈ хус ма шŏмайэм, ŏх пŏнман, иԓ ԋўрсәт». ");
INSERT INTO kca_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ащеԓа пŏтәртсәԓы пӑ йайԓаԓа ищи; ащеԓән ԉавәттәса пӑ йастәса: «Мўй щимәщ уԓәм нӑӈ ватсән? Мўй щирән ма пӑ нӑӈ аԋԏэн, пӑ нӑӈ йайԓан нӑӈ йэԓпенән мўв унты, ŏх пŏнман, иԓ ԋўрты йŏхәтԓув?» ");
INSERT INTO kca_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Йайԓаԓ ԓўв пеԓайәԓ ўшмащсәт, ащеԓән пӑ щи йасәӈ ӑт йŏрэмәса. ");
INSERT INTO kca_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Йайԓаԓ Сихем вош ԉэпән ащеԓ тащ шависәт. ");
INSERT INTO kca_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Израиль Иосифа йастәс: «Йайԓан ӑԓт Сихемән тащ шавиԓәт? Йӑӈха, ма нӑӈен ԓыв хŏщайэԓ китԓэм». Ԓўв йастәс: «Йӑна щи, ма йӑхԓәм». ");
INSERT INTO kca_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Израиль ԓўвеԓа йастәс: «Йӑӈха, ванты, йайԓан тўмтакәт мўй пӑ тащеԓ тӑԓаӈ мўй, пӑ айкеԓ мӑнэма тўва». Хеврон лот мўв эԓты ԓўвеԓ китсәԓы; ԓўв пӑ Сихема йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Щита мўв хӑрән ԓўв тӑпәс пӑ ԓўвеԓ уйтәм хŏйатән иԋщәсса: «Мўй нӑӈ кӑшԓән?» ");
INSERT INTO kca_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ԓўв йастәс: «Ма йайԓам кӑшԓәм, мӑнэма йасты, хŏта ԓыв тащ шавиԓәт?» ");
INSERT INTO kca_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Щи хŏйат йастәс: «Ԓыв тӑԓта мӑтсәт, ма хуԓтсэм, хŏты ԓыв пŏтәртсәт: ‘Дофана мӑнԓув’». Щиты Иосиф йайԓаԓ йуш хўват мӑнәс, пӑ Дофан вош ԉэпән ԓывиԓаԓ уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ԓыв хўвәԓта ԓўвеԓ кащаԓәсэԓ, пӑ ԓўв вана йитаԓ сыс, ԓыв нумәсты питсәт, хŏты ԓўвеԓ веԓты. ");
INSERT INTO kca_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Щӑԓта ԓыв кўтэԓән йастәсәт: «Уԓәм вантәм ŏт йиԓ; ");
INSERT INTO kca_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ин мӑнԓув пӑ ԓўвеԓ веԓԓэв, мӑтты мўв ўса йўвәтԓэв, пӑ йастәԓув, ут войән ԓэса; щи пŏрайән ватԓэв, ԓўв уԓәмԓаԓ мўйа йиԓәт». ");
INSERT INTO kca_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Щит Рувим йайәԓән хуԓса пӑ атәм нŏмәсԓаԓ эԓты ԓўвеԓ шависԓы, пӑ щиты йастәс: «Ԓўвеԓ ӑт веԓԓэв». ");
INSERT INTO kca_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Рувим ԓывиԓаԓа йастәс: «Ўр ӑԓ шошматы; тӑм мўв ўса таԓ йикԓы мўвән йўвтаԓән, туп йошән аԓ кетмаԓән». Щиты ԓўв пŏтәртәс, ԓыв йошԓаԓ эԓты ԓўвеԓ шавиты пӑ ащеԓ хŏща ԓўвеԓ йŏхтәптәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Иосиф йайԓаԓ хŏща йŏхәтмаԓән, ԓыв ԓўв хŏрамәӈ сŏхәԓ ԓўв эԓтэԓ нŏх менәпсэԓ, ");
INSERT INTO kca_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","пӑ ԓўвеԓ ўсэԓ пӑ мўв ўса йўвәтсэԓ; щи мўв ўс таԓ ус, йик щита ӑнтом ус. ");
INSERT INTO kca_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ԓыв пӑ ԓэты омәссәт, пӑ ӑӈкәртмеԓән, кащаԓәсэԓ, хŏты Галаад мўв эԓты измаил йох онас йиԓ, йӑма авты стиракс йўх ух, бальзам пӑ ладан пŏрмасәт верблюдәт туԓәт: Египет мўва щит тўвман мӑнԓәт. ");
INSERT INTO kca_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Щӑԓта Иуда йайԓаԓа йастәс: «Мўй ŏнтас, апщев пӑратԓэв пӑ ԓўв ўрәԓ хӑԋатԓэв? ");
INSERT INTO kca_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Мӑнԓув пӑ измаил йоха ԓўвеԓ тыныԓэв, мўӈ йошԓувән ԓўвеԓ ӑт кетәмԓэв, ищипа ԓўв мўӈ апщев, ищи мўӈ ўрэв». Йайԓаԓ ԓўв пеԓайәԓ хўԓтмәсәт. ");
INSERT INTO kca_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Хун Мадиан мўвәӈ тынасты йох ванамәсәт, йайԓаԓ мўв ўс эԓты Иосиф нŏх таԓсэԓ пӑ измаил йоха хус щел ŏх сӑхат тынысэԓ; ԓыв пӑ Иосиф Египта тусэԓ. ");
INSERT INTO kca_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Рувим щи мўв ўс хŏща па йŏхтәс; пӑ Иосиф мўв ўсән ӑнтом. Щит кащаԓәмаԓ кемән, ԓўв ԓўмтәмԓаԓ мӑншисԓы, ");
INSERT INTO kca_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","апщиԓаԓ хŏща йŏхԓы йŏхтәс пӑ йастәс: «Энәмты пŏхев ӑнтом, ма пӑ, хŏԓта ма мӑнԓәм?» ");
INSERT INTO kca_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ԓыв Иосиф сŏх ўсэԓ, козёл вой хŏрсэԓ пӑ щи ўрән сŏхәԓ ԋŏсәтсэԓ; ");
INSERT INTO kca_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","щӑԓта щи хŏрамәӈ сŏх ащеԓа китсэԓ, пӑ йастәсәт: «Мўӈ тӑм уйәтсув; ванты, нӑӈ пŏхен сŏх мўй пӑ ӑнтом?» ");
INSERT INTO kca_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ԓўв сŏхәԓ мŏштәсԓы пӑ йастәс: «Тӑм ма пŏхем сŏх; ут войән ԓўв ԓэса; аԓт пӑ Иосиф войәтән лакки мӑншиса». ");
INSERT INTO kca_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Иаков ԓўмтәмԓаԓ мӑншисԓы, уԓттӑхты хир хŏрпи сох ӑтпәԓа ԓумтәс пӑ ар хӑтәԓ пŏхәԓ эԓты хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Эвиԓаԓ, пŏхԓаԓ хŏԓ ӑктәщсәт, ԓўвеԓ щаԉәтты урәӈән; ԓўв пӑ хуԓәтты ӑт ԓӑӈхас пӑ йастәс: «Тӑмиты хощман пŏхем хŏща иԓта турма мӑнԓәм». Щиты ащеԓ ԓўв эԓтэԓ хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Иосиф пӑ Мадиан мўв хŏйатәтән Египет мўвән Потифар нэмпи ун кущайа тыныса, фараон шавиты йох кущайа. ");
INSERT INTO kca_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Щи артән Иуда йайԓаԓ хӑйсәԓы пӑ Хира нэмпи хŏйат пўӈәԓән Одоллам вошән уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Щита Иуда Шуа нэмпи ханаан ики эви кащаԓәс: ԓўвеԓ нэӈа тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Щи нэ ԓавәрта йис пӑ пŏх тӑйәс, пӑ Иуда ащеԓән Ир нэмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Щӑԓта па ԓавәрта йис пӑ па пŏх тӑйәс, пӑ Онан нэмән ԓўвеԓ мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Щӑԓта пŏх па тӑйәс пӑ Шела нэмән ԓўвеԓ мӑсԓы. Иуда пӑ, ԓўв пŏхәԓ сэма пайәтмаԓән, Хезив вошән ус. ");
INSERT INTO kca_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Щӑԓта Иуда Ир нэмпи оԓәӈ пŏхәԓ нэӈән тусԓы; Фамарь нэмәԓ. ");
INSERT INTO kca_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Туп Ир, Иуда оԓәӈ пŏхәԓ, Турәм Куща йэԓпийән ар кӑрэк тӑйәс, щишән, Турәм Кущайән сŏрма пайәтса. ");
INSERT INTO kca_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Щишән, Иуда Онан пŏхәԓа йастәс: «Йайән ими нэӈа ўйи, ԓэху щирән, пӑ йайән тыхәԓ йэԓԓы тўви». ");
INSERT INTO kca_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Онан уйәтсәԓы, щит ӑнта ԓўв тыхԓәԓ питәԓ, щишән, йайәԓ ими пиԓән щиты ус, йайәԓ тыхәԓ йэԓԓы ӑт ат рутмәс. ");
INSERT INTO kca_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Турәм Куща йэԓпийән мўй ԓўв верәс, атәм ус; пӑ Ԓўв ԓўвеԓ ищи сŏрма пайәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Щӑԓта Иуда Фамарь меԋәԓ пеԓа йастәс: «Шела пŏхем энәмты унты ащен хотән шукаԓт имийа уԓа». Щиты Иуда нумәсәс: «Йайԓаԓ иты Шела ӑт ат ԓуԓән пӑрәс». Фамарь мӑнәс пӑ ащеԓ хотән уԓты питәс. ");
INSERT INTO kca_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Хўв кўт хӑщәс пӑ Иуда имеԓ, Шуа ики эви, пӑрәс. Иуда, хӑтәԓԓаԓ тӑрмәм йўпийән, Фамна воша мӑнәс, хŏта ошԓаԓ ԓŏртты хŏйатәт усәт, ԓўв пиԓәԓән Одоллам эԓты Хира нэмпи ԓухсәԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Фамарь айкеԓән верса: «Ўпән ики Фамна воша ош ԓŏртты мӑнәԓ». ");
INSERT INTO kca_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ԓўв шук туты сŏхԓаԓ эхсәԓы, ŏхшам пŏнәс пӑ щиты йэмәԓман Фамна пеԓа мӑнты йушән, Енаим вош ов хŏща опсәс. Ԓўв уйәтсәԓы, Шела энмәс, ԓўв пӑ ԓэхуйәԓа ӑт опсәԓса. ");
INSERT INTO kca_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Иуда ԓўвеԓ кащаԓәсԓы пӑ вешәԓ хӑԋатмаԓ урәӈән, уԉԋа нэӈа йўкатсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ԓўв хŏщайәԓ йирэмәс пӑ йастәс: «Нӑӈ хŏщайэн рӑхәԓ ԓŏӈтыты?» Ԓўв ӑт уйәтсәԓы, щит ԓўв меԋәԓ ус. Фамарь пӑ ԓўвеԓ ищмәсԓы: «Ма хŏщайэм ԓŏӈтытэн мита мўй нӑӈ мӑнэма мӑԓән?» ");
INSERT INTO kca_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ԓўв йастәс: «Ма нӑӈена ма тащем эԓты ош пŏшәхән китԓэм». Ԓўв пӑ йастәс: «Киттэн унты мŏԓты пŏрмас щи йўкана хӑйԓән?» ");
INSERT INTO kca_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Иуда йастәс: «Мўй хŏрпи йўкан нӑӈена мӑты?» Ԓўв пӑ йастәс: «Нӑӈ йŏра кеԓәӈ посэн пӑ йошән тӑйты шушты сўвен». Иуда щит ԓўвеԓа мӑсԓы пӑ ԓўв хŏщайәԓ ԓŏӈәс; ԓўв эԓтэԓ Фамарь ԓавәрта йис. ");
INSERT INTO kca_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Щӑԓта ԓўв ԓŏйәс пӑ мӑнәс, тӑйәм ŏхшамәԓ эхсәԓы пӑ шук туты сŏхԓаԓ па ԓумәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Иуда Одоллам эԓты уԓты ԓухсәԓ пиԓән ош пŏшәх китәс, нэ хŏща хӑйәм пŏрмасәт нŏх ўты урәӈән, туп ԓўв щи нэ ӑт уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Шŏши хŏйатәт эԓты иԋщәссәԓы: «Хŏта щи уԉԋа нэ, хŏй Енаим йуш пўӈәԓән опсәс?» Ԓыв йастәсәт: «Тӑта уԉԋа нэ ӑнтом ус». ");
INSERT INTO kca_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ԓўв Иуда хŏща йŏхтәс пӑ йастәс: «Ма ԓўвеԓ ӑт уйәтсэм; пӑ щита уԓты шŏши хŏйатәт йастәсәт: ‘Тӑта уԉԋа нэ ӑнтом ус’». ");
INSERT INTO kca_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Иуда йастәс: «Ԓўв йўканәԓа ат ўԓԓы, туп ԋӑха ӑт ат пайәтсаймән; ма тӑм ош пŏшәхән щи китыԓысэм, нӑӈ пӑ ԓўвеԓ ӑт уйәтсэн». ");
INSERT INTO kca_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Хуԓәмԓэм тыԓәщ хӑщәс пӑ Иуда айкеԓән верса: «Фамарь меԋән уԉԋайа уԓты питмаԓ пӑ нэ щирән кӑшаӈа уԓ». Иуда йастәс: «Йэԓ ԓўвеԓ тўваԓән пӑ нŏх ат ўщитԓа». ");
INSERT INTO kca_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Хун ԓўв туты питса, ўпәԓ икийа щимәщ йасәӈ китәс: «Тӑм пŏрмасәт тӑйәм хŏйат эԓты ма ԓавәрта йисәм». Пӑ йастәс: «Мŏштәԓэн, тӑм хŏй йŏра кеԓәӈ пос пӑ шушты сўв?» ");
INSERT INTO kca_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Иуда мŏштәсԓы пӑ йастәс: «Ԓўв ма эԓтэм вещкатшәк, щит ма ԓўвеԓ Шела пŏхема ӑт мӑсэм». Ԓўв хŏщайәԓ па ӑт ԓŏӈтыйәс. ");
INSERT INTO kca_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Щӑԓта ԋаврэм сэма питты хӑтәԓән ԓэрамәс, ԓўв нэш пӑтлам хотән пиԓаӈ ŏтӈән тӑймаԓ. ");
INSERT INTO kca_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ԋаврэмӈән сэма питәмән, оԓәӈән итәԓ йош этәс; пўкән эвтәм ими ўрты сŏхәмән йошәԓ йӑрәпсәԓы, йастәман: «Тӑмен оԓӈа этәс». ");
INSERT INTO kca_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ԓўв пӑ йошәԓ йŏхԓы сухтәсԓы; пӑ йайәԓ оԓӈа этәс. Ԓўв йастәс: «Мўй щирән нӑӈ йуш версән?» Щишән Фарес нэмән мӑса. ");
INSERT INTO kca_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Йухәт ўрты сŏхәмән йӑрәм йŏшәӈ апщеԓ этәс. Ԓўв нэмән мӑса: Зара. ");
INSERT INTO kca_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Иосиф пӑ Египта тўвман ус, ԓўвеԓ тўвәм измаил йŏх йош эԓты фараон шавиты йох кущайән, Потифар нэмпи кущайән, Египет мўв хуйән, ԓутса. ");
INSERT INTO kca_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Турәм Куща Иосиф пиԓән ус: ԓўв верԓаԓ йӑма мӑтсәт пӑ Потифар, Египет мўв ху кущайәԓ хотән ус. ");
INSERT INTO kca_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Кущайәԓән мŏштәса, Турәм Куща ԓўв пиԓәԓән уԓ, мўй ԓўв ӑт верәԓ, ԓўв верты верԓаԓән Турәм Куща ԋотәԓ. ");
INSERT INTO kca_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Щиты Иосиф Потифарән ванән тӑйты питса пӑ ԓўв йŏра митхуйәԓа йис. Щӑԓта ԓўвеԓ хотәԓ кущайа пŏтсәԓы пӑ мўй тӑйәс, иса ԓўв йошәԓа мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Хот кущайа ԓўвеԓ пŏнмаԓ ўш эԓты пӑ иса тӑйәм ŏтәԓ ԓўв йошәԓа миймаԓ йўпийән, Иосиф урәӈән Египет мўв ху хот Турәм Куща йӑмән мӑсԓы, щишән, Турәм Куща йӑм ԓўв хотәԓән пӑ мўв хӑрәԓән тӑйәм ŏтәԓ хŏща иса ус. ");
INSERT INTO kca_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Щишән, ԓўв, мўй тӑйәс, иса Иосиф йоша мӑсԓы, нэмәԓты эԓты ӑт нумәсәс, ԓўвеԓа йŏра ԓэтŏт верты тўмпийән. Иосиф хŏрасәӈ пӑ ԓŏватәӈ ус. ");
INSERT INTO kca_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Щишән, кущайәԓ ими Иосиф пеԓа ватты питәс пӑ йастәс: «Ма пиԓэмән уԓа». ");
INSERT INTO kca_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ԓўв пӑ ӑт кашащәс пӑ кущайәԓ ими пеԓа йастәс: «Тӑта щи, кущайэм мўй тӑйәԓ, ма йошема мӑсԓы, нэмәԓты эԓты ӑт нумәсәԓ; ");
INSERT INTO kca_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","тӑм хотән ма эԓтэм уншәк ŏт ӑнтом; тӑм хотән нӑӈ тўмпенән мӑнэма ӑт рӑхты вер ӑнтом, нӑӈ ԓўв имеԓ; мўй щирән ма щимәщ атәм вер верԓәм пӑ Турма кӑрэк верԓәм?» ");
INSERT INTO kca_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Кашәӈ хӑтәԓ кўш нэ щиты Иосифа пŏтәртәс, Иосиф ӑт хуԓәнтәс ԓўв пиԓәԓән уԓты. ");
INSERT INTO kca_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Имŏԓты хӑтәԓән ԓўв верәԓ сӑхат хота ԓŏӈәс, щита хотәӈ ŏтәт эԓты нэмәԓт хŏйат ӑнтом ус; ");
INSERT INTO kca_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","щи нэ ԓумтәм сŏхәԓ эԓты ԓўвеԓ катәԓсәԓы пӑ йастәс: «Ма пиԓэмән уԓа». Иосиф пӑ, сŏхәԓ ԓўв йошәԓән хӑйман, ким хухәԓмәс. ");
INSERT INTO kca_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Нэ пӑ, щит кащаԓәмаԓ кемән, хун сŏхәԓ ԓўв йошәԓән хӑщәс пӑ Иосиф ким хухәԓмәс, ");
INSERT INTO kca_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","хотәӈ ŏтԓаԓ ўваԓсәԓы пӑ ԓывиԓаԓа щиты йастәс: «Вантаты, Потифар мўӈев еврей тўвмаԓ пӑ щитэн мўӈ хŏщайэв йŏвәртыйәԓ. Щи еврей ма хŏщайэм йŏхтәс, ма пиԓэмән уԓты ўтщийәс, ма пӑ сыйәӈ тўрән ўваԓтсәм; ");
INSERT INTO kca_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ԓўв пӑ, хўԓтмәмаԓән, хŏты ма ўваԓтсәм, сŏхәԓ ма хŏщайэм хӑйсәԓы пӑ ким хухәԓмәс». ");
INSERT INTO kca_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Щиты Потифар йŏхи йŏхәтты унты Иосиф сŏх щи нэ ԓўв хŏщайәԓ хӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ԓўвеԓа ищи щи йасӈәт пŏтәртәс, йастәман: «Нӑӈ тўвәм еврей митхуйэн ма хŏщайэм йŏвәртыты йŏхтыԓыйәс; ");
INSERT INTO kca_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","хун ма ўвты питсәм, ԓўв сŏхәԓ ма хŏщайэм хӑйсәԓы пӑ ким хухәԓмәс». ");
INSERT INTO kca_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Кущайәԓ имеԓ йасӈәт хуԓмаԓ йўпийән, хŏты ԓўв йастәс: «Щиты ма пиԓэмән нӑӈ митхуйэн верәс», ԓўв шек ԉикащәс; ");
INSERT INTO kca_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","щӑԓта кущайәԓән Иосиф касна хота омәсты партса, хŏта хон вера питәм ŏтәт усәт. Щита касна хотән ԓўв опсәс. ");
INSERT INTO kca_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Турәм Куща Иосиф пиԓән ус, йӑм сэмән вантәс, щишән, касна хот куща ԓўв пеԓайәԓ ищи йӑм ус. ");
INSERT INTO kca_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Касна хот куща щита опсәм вера питәм ŏтәт хŏԓ Иосиф йоша мӑсԓы, щишән, мўй ԓыв щита ӑт версәт, щи верәт хŏща ԓўв пӑ уна ус. ");
INSERT INTO kca_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Касна хот куща Иосиф йошән тӑйты верәт эԓты нэмәԓты ӑт ԓэрамтәс, Турәм Куща Иосиф пиԓән ус, щишән мўй ԓўв верәс, Турәм Кущайән щи верәтән иса ԋотса. ");
INSERT INTO kca_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Щи йўпийән хона ўнайәт ԓэщатты куща пӑ ԋаԋ верты куща Египет хонэԓ йэԓпийән, кущайэԓ йэԓпийән, вера питсәӈән. ");
INSERT INTO kca_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Кӑт кущайӈәԓаԓ пеԓа фараон ԉикащәс, ўнайәт ԓэщатты куща пӑ ԋаԋ верты куща пеԓа, ");
INSERT INTO kca_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","пӑ ԓўвеԓ шавиты йохԓаԓ куща йоша ԓынан мӑсԓы, щи касна хота, хŏта Иосиф опсәс. ");
INSERT INTO kca_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Шавиты йох куща ԓын хŏщайән Иосиф рупитты ԓэщатәс, пӑ ԓўв ԓынана рупитәс. Щиты касна хотән мŏԓты сыс ԓын устән. ");
INSERT INTO kca_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ипуш касна хотән, ўнайәт ԓэщатты куща пӑ ԋаԋ верты куща уԓмистән, кашәӈ ŏт ԓўв уԓмәԓ, кинтак и атән, кашәӈ ŏт ŏщхўԉ уԓәм вантәс. ");
INSERT INTO kca_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Аԓәӈсӑхат Иосиф ԓын хŏщайән йŏхтәс, ԓынан кащаԓәсԓы, ԓын вешԓән рўтаԉӈән. ");
INSERT INTO kca_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Фараон кущайӈән ԓўв ищмәсԓы, ԓўв пиԓәԓән кущайәԓ хотән уԓты касна хотән опсәм ŏтӈән пеԓа, щиты йастәс: «Мўйа нын тӑм хӑтәԓ вешԓән рўтаԉӈән?» ");
INSERT INTO kca_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ԓын ԓўвеԓа йастәсӈән: «Мин тӑм ат уԓмисмән; туп щи уԓәмӈән ԓӑрпитты хŏйат ӑнтом». Иосиф ԓынана йастәс: «Уԓәм ԓӑрпитты вер аԓт Турәм эԓты уԓ? Мӑнэм уԓәмԓән пŏтәртаԓән». ");
INSERT INTO kca_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Хона ўнайәт ԓэщатты куща ԓўв уԓмәԓ Иосифа пŏтәртәс пӑ йастәс: «Уԓмитэмән, виноград ўна йўх ма йэԓпемән; ");
INSERT INTO kca_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","щи йўхән хуԓәм нўв; йўх энмәс, лыпәтән этса, щӑԓта щита виноград воԋщәм ŏтәт энәпсәт пӑ пŏшсәт; ");
INSERT INTO kca_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","фараон ан ма йошемән катәԓԓэм; виноград воԋщәм ŏтәт ма ўсәм пӑ фараон ан ԓыпийа пӑщәртсәԓам, пӑ фараон йоша ан мӑсэм». ");
INSERT INTO kca_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Иосиф ԓўвеԓ йастәс: «Тӑта щи уԓмен ԓӑрпитты щир: хуԓәм нўв – щит хуԓәм хӑтәԓ; ");
INSERT INTO kca_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","хуԓәм хӑтәԓ хӑщты йўпийән фараон нӑӈен эсәԓԓәԓы пӑ рупитәм тӑхайэна омәсԓәԓы, нӑӈ пӑ фараон ан ԓўв йошәԓа мӑԓэн, йэԓпи иты, хун нӑӈ ԓўв хŏщайәԓ хона ўнайәт ԓэщатты кущайа усән; ");
INSERT INTO kca_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","хун нӑӈен йӑм питәԓ, ма эԓтэм нумәԓми пӑ, щи ԓŏват йӑм вера, фараона ма эԓтэм йаста, тӑм касна хот эԓты ким ат эсәԓсайәм; ");
INSERT INTO kca_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ма еврейәт мўв эԓты йурән тусайәм; тӑта пӑ касна хотән омәсты урәӈән нэмәԓт атәм ӑт версәм». ");
INSERT INTO kca_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ԋаԋ верты куща кащаԓәсԓы, хŏты ԓўв уԓәм йӑма ԓӑрпитсәԓы пӑ Иосифа йастәс: «Ма ищи уԓмисәм: ŏхемән хуԓәм кураԋэк катәԓԓәм; ");
INSERT INTO kca_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","нўмпеләк кураԋэкән кӑмән хŏрпи фараон урәӈән ԓэты ԋаԋәт, ŏхемән омәсты кураԋэк эԓты щи ԓэтŏтәт тŏхԓәӈ войәтән нухԓайәт». ");
INSERT INTO kca_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Пӑ Иосиф щиты йŏхԓы йастәс: «Тӑта щи уԓмен ԓӑрпитты щир: хуԓәм кураԋэк – щит хуԓәм хӑтәԓ; ");
INSERT INTO kca_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","хуԓәм хӑтәԓ хӑщты йўпийән фараон нӑӈ ŏхен хŏԓт сэвәрты партԓәԓы пӑ нӑӈен йўха нŏх сухтәԓԓы, тŏхԓәӈ войәтән эԓэн нухты питԓа». ");
INSERT INTO kca_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Хуԓмет хӑтәԓән, фараон ԓўв сэма питәм хӑтԓәԓән митйохԓаԓа поры пӑсан верәс, пӑ касна хота опсыԓыйәм ўнайәт ԓэщатты пӑ ԋаԋ верты кущайӈән эԓты митйохԓаԓ уԓман нумәԓмәсԓы; ");
INSERT INTO kca_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","щӑԓта хона ўнайәт ԓэщатты куща йэԓпи рупитәм тӑхайәԓа пŏтсәԓы, пӑ ԓўв фараон йоша ан мӑс; ");
INSERT INTO kca_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ԋаԋ верты куща пӑ йўха нŏх сухтәса, хŏты Иосиф ԓынана уԓәм ԓӑрпитыйәс. ");
INSERT INTO kca_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Хона ўнайәт ԓэщатты куща Иосиф эԓты ӑт пӑ нумәԓмәсԓы, ԓўв эԓтэԓ йŏрэмәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Кӑт тӑԓ хӑщәмән фараон уԓәм вантәс: ԓўв йŏхан питарән ԓойәԓ; ");
INSERT INTO kca_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","йŏхан эԓты ԓапәт мис ким этәс, йӑм хŏрпет пӑ вŏйаӈәт, пӑ тŏрән ԓэты питсәт; ");
INSERT INTO kca_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","щӑԓта, ԓыв йўпеԓән йŏхан эԓты па ԓапәт мис этәс, атәм хŏрпет пӑ керыйәмәт, пӑ тўм мисәт пўӈԓа йŏхан питарән ԓойсәт; ");
INSERT INTO kca_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","щӑԓта атәм хŏрпи пӑ керыйәм мисәт ԓапәт йӑм хŏрпи пӑ вŏйаӈ мисәт йŏхи ԓэсԓаԓ. Щитәԓән фараон нŏх верԓәс, ");
INSERT INTO kca_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","па вŏйәпса, пӑ кимет пўш уԓмийәс: и ԋаԋ тŏрәнән ԓапәт йӑм пӑ тэԓәӈ ԋаԋ тŏрән тӑй энмәс; ");
INSERT INTO kca_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","щӑԓта пӑ, щи йўпийән ԓапәт сорәм пӑ хӑԓэвәт вотән сорәԓтәм ԋаԋ тŏрән тӑй энмәс; ");
INSERT INTO kca_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","щӑԓта сорәм ԋаԋ тŏрән тӑйәт йӑм пӑ тэԓәӈ ԋаԋ тŏрән тӑйԓаԓ йŏхи ԓэсԓаԓ. Фараон нŏх верԓәс пӑ мŏштәсԓы, щит уԓәм. ");
INSERT INTO kca_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Аԓәӈсӑхат ԓўв нŏпсәԓ шӑкәс, щӑԓта ԓўв китсәԓы, пӑ Египет мўв хŏԓ щӑртәӈ пӑ хŏԓ мўтра уйәтты хŏйатәт вохсәԓы, фараон ԓывиԓаԓа уԓмәԓ пŏтәртсәԓы; туп щи уԓәм ԓӑрпитты хŏйат ӑт ԉикмәс. ");
INSERT INTO kca_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Хона ўнайәт ԓэщатты куща пŏтәртты питәс пӑ щиты йастәс: «Ин ма вера питыԓыйәм щирэм нумәԓмәсэм; ");
INSERT INTO kca_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ипуш фараон мин пеԓайэмән, митйохӈәԓаԓ пеԓа ԉикащәс, пӑ мӑнэм пӑ ԋаԋ верты куща фараон шавиты йох куща хотән касна хота омәссәԓы; ");
INSERT INTO kca_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","пӑ и атән ма пӑ ԓўв уԓмисмән, кашәӈ ŏт ŏщхўԉ уԓәм вантәс; ");
INSERT INTO kca_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","щита мин пиԓэмән еврей мир эԓты энәмты ху ус, фараон шавиты йох куща митху; мин ԓўвеԓа уԓәмԓәмән пŏтәртсәԓәмән, ԓўв пӑ минэмәна кашәӈ ŏт мўй вантәс, йӑпсыйа ԓӑрпитсәԓы; ");
INSERT INTO kca_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","щӑԓта, хŏты ԓўв минэмәна ԓӑрпитсәԓы, щиты щи тыйәс: ма тӑйәм рупатайэма йŏхԓы ўсайәм, тўм ху пӑ йўха нŏх сухтыса». ");
INSERT INTO kca_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Фараон Иосиф вохты партсәԓы. Ԓўв тэрматыман касна хот эԓты эсәԓса. Ԓўв упәтԓаԓ ԓŏртсайәт, па сŏх ԓумтәс пӑ фараон хŏща йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Фараон Иосифа йастәс: «Ма уԓәм ватсәм, пӑ нэмәԓты ŏт ӑнтом, хŏйән ԓуԓән ԓӑрпитты верәтса, ма хуԓԓысэм, нӑӈ уԓәм ԓӑрпитты хоштэн». ");
INSERT INTO kca_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Иосиф фараона йŏхԓы йастәс: «Щит ӑнта ма; фараон йӑм урәӈән Турәм йŏхԓы йастәԓ». ");
INSERT INTO kca_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Фараон Иосифа щиты пŏтәртәс: «Уԓәм ватсәм: ма йŏхан питарән ԓойԓәм; ");
INSERT INTO kca_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","щӑԓта йŏхан эԓты ԓапәт вŏйаӈ пӑ йӑм хŏрпи мис этәс пӑ тŏрән ԓэты питсәт; ");
INSERT INTO kca_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ԓыв йўпеԓән йŏхан эԓты па ԓапәт мис этәс, керыйәмәт, ватты шек атмәт; тӑм Египет мўв ԓŏватән щимәщ керыйәм ŏтәт ӑт вантыԓысәм; ");
INSERT INTO kca_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","щӑԓта керыйәм мисәт оԓәӈән этәм вŏйаӈ мисәт йŏхи ԓэсԓаԓ; ");
INSERT INTO kca_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","кўш йŏхи ԓэсԓаԓ, ԓыв ищипа керыйәм хŏрпийа вантәссәт. Щи кемән нŏх верԓәсәм. ");
INSERT INTO kca_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Щӑԓта па уԓмисәм: и ԋаԋ тŏрәнән ԓапәт йӑм пӑ тэԓәӈ ԋаԋ тŏрән тӑй энмәс; ");
INSERT INTO kca_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","щӑԓта пӑ, щи йўпийән ԓапәт сорәм пӑ хӑԓэвәт вотән сорәԓтәм ԋаԋ тŏрән тӑй энмәс; ");
INSERT INTO kca_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","щӑԓта сорәм ԋаԋ тŏрән тӑйәт ԓапәт йӑм пӑ тэԓәӈ ԋаԋ тŏрән тӑйԓаԓ йŏхи ԓэсԓаԓ. Щит ма щӑртәӈ хŏйатәта пŏтәртсэм, туп нэмәԓты хŏйатән щи уԓәм ԓӑрпитты ӑт верәтса». ");
INSERT INTO kca_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Иосиф щиты фараона йастәс: «Фараон и вер эԓты кӑт пўш уԓмийәс: Турәм мўй верәԓ, щит эԓты Ԓўв фараона айкеԓ верәс. ");
INSERT INTO kca_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ԓапәт йӑм мис – щит ԓапәт тӑԓ; пӑ ԓапәт йӑм ԋаԋ тŏрән тӑй – щит ищи ԓапәт тӑԓ: кӑт уԓәм и нŏмәс; ");
INSERT INTO kca_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ԓыв йўпеԓән этәм ԓапәт атәм хŏрпи пӑ керыйәм мис – щит ԓапәт тӑԓ, щӑԓта ԓапәт сорәм пӑ хӑԓэвәт вотән сорәԓтәм ԋаԋ тŏрән тӑй – щит ԓапәт ԓэԓԓы тӑԓ». ");
INSERT INTO kca_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Щишән, ма щиты фараона йастәсәм: «Мўй Турәм верәԓ, щит Ԓўв фараона этәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Иса Египет мўвән ԓапәт тащәӈ пӑ ԓэтотәӈ тӑԓ тӑԓта йэԓԓы питәԓ; ");
INSERT INTO kca_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","щи йўпийән ԓапәт ԓэԓԓы тӑԓ йŏхәтәԓ, щи йэԓпи йӑма уԓәм уԓәпса Египет мўвән йŏрэмәԓа, ԓэԓԓы тӑԓәтән мўв таԓа верԓа пӑ хŏйатәт вŏԓԓы нўшайа йиԓәт, ");
INSERT INTO kca_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","пӑ щи йэԓпи йӑм уԓәпса йŏрэмәԓа, ԓэԓԓы тӑԓәт урәӈән, йŏхәтты ԓэԓԓы тӑԓәт шек ԓавәртәт питԓәт. ");
INSERT INTO kca_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Фараон кӑт пўш и хŏрпи уԓәм щишән вантәс, щит Турәм йасәӈ так урәӈән пӑ щи вер Турәмән тӑм ванән йӑна верты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Щӑԓта пӑ, фараон ŏшәӈ пӑ вер хошты хŏйат ат уйәтәԓ, пӑ Египет мўв ԓŏватән уна ат пŏнԓәԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Пӑ щӑԓта, фараон мўвәԓ ԓŏватән ватты кущайәт ат омәсәԓ, пӑ ԓапәт тащәӈ тӑԓәт хўват Египет мўвән энмәԓты ԋаԋ ветмет пелкеԓ ат ӑкәтԓэԓ; ");
INSERT INTO kca_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","щи йŏхәтты йӑм тӑԓәтән ԓыв ԋаԋ ԓат пӑ па сэмәӈ ԓат ат ўԓәт, пӑ фараон партты щирән вошәтән сопаса ат акәтԓэԓ пӑ ат шавиԓэԓ. ");
INSERT INTO kca_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Египет мўвән йэԓԓы йŏхәтты ԓэԓԓы ԓапәт тӑԓ кеша щи ԓэтŏт сопаса питәԓ, тӑта уԓты мир ӑт пӑрты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Фараона пӑ ԓўв митйохԓаԓа щи йасӈәт рӑхсәт. ");
INSERT INTO kca_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Фараон митйохԓаԓа йастәс: «Ԓўв хŏрпеԓ йӑм хŏйат хŏԓща уйәтԓув, хŏй хŏща Турәм Ԓыԓ ат ус, ԓуԓән?» ");
INSERT INTO kca_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Фараон Иосифа йастәс: «Хŏты Турәм нӑӈена щит иса пўшсәԓы, щимәщ ŏшәӈ пӑ мўтрайәӈ нӑӈ хŏрпен хŏйат ӑнтом; ");
INSERT INTO kca_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","нӑӈ ма хотэм нўмпийән питԓән, ма мирэм нӑӈ йасӈена хуԓәтты питәԓ; туп хона омәстэм щирән ма нӑӈ эԓтэн унашәк уԓԓәм». ");
INSERT INTO kca_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Фараон Иосифа йастәс: «Щиты, ма нӑӈен хŏԓ Египет мўв кущайа пŏнԓэм». ");
INSERT INTO kca_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Фараон ԓўв йошәԓ эԓты веншәӈ ԓуйтәԓ хŏԓт пайәтсәԓы пӑ Иосиф ԓўйа ԓумәттәсԓы; ухәԓ щӑшкан сŏхәта ԓўвеԓ ԓумәттәсԓы, сапԓәԓа сорԋэӈ карты кеԓ пŏнәс; ");
INSERT INTO kca_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ԓўв йўпеԓән кимет хон йŏра ԓовәӈ ухәԓән Иосиф тутԓыты партсәԓы пӑ ԓўв йэԓпеԓән ўвты: «Ŏх пŏнман, иԓ ԋўраты!» Щиты Египет мўв ԓŏватән ԓўвеԓ кущайа пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Фараон Иосиф пеԓа йастәс: «Ма фараон; туп нӑӈ йасӈен такԓыйа Египет мўв ԓŏватән нэмәԓты хŏйат йош ӑт тўвемәԓ, кўрәм ӑт верәԓ». ");
INSERT INTO kca_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Фараон Иосиф йӑԓәп нэмән мӑсԓы: Цафнаф-панеах, пӑ Илиополь вош Потифер нэмпи йир верты хŏйат, Асенефа нэмпи эви, фараон ԓўвеԓа нэӈа мӑсԓы. Иосиф Египет мўв хўват мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Иосиф хŏԉмаӈ тӑԓ ԓŏват ус, хун ԓўв Египет мўв хон хŏща, фараон хŏща рупитты йŏхтәс. Фараон эԓты этмаԓ йўпийән, ԓўв Египет мўв хŏԓ йӑхсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Щи мўвән ԓапәт тащәӈ тӑԓ хўват и ԓат сэм эԓты кўш тэԓ энмиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Египет мўвән ԓапәт йӑм тӑԓ сыс энмәм ԋаԋ ԓат пӑ па сэмәӈ ԓат ԓўв ӑкәтсәԓы, пӑ вошәтән щи ԓат пŏтсәԓы; кашәӈ вош керәтман уԓты мўв хӑрәт эԓты. ");
INSERT INTO kca_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Иосиф ԋаԋ ԓат пӑ па сэмәӈ ԓат шек ар ӑктәс, щарәс сэй хиш арат, щишән, ԓўӈәтты кўртәсәс пӑ йэԓԓы ӑт ԓўӈәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ԓэԓԓы тӑԓәт йэԓпийән Иосиф кӑт пŏх тӑйәс, хŏйӈән Асенефа, Илиополь вош Потифер нэмпи йир верты хŏйат эви, сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Иосиф оԓәӈ пŏхәԓ нэмән мӑсԓы: Манассия, щиты ԓўв пŏтәртәс: «Шукащты верԓам пӑ ащем хот тэԓ Турәм мӑнэма йŏрэмәты ԋотсәԓы». ");
INSERT INTO kca_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Кимет пŏхәԓ нэмән мӑсԓы: Ефрем, щиты ԓўв пŏтәртәс: «Шукащәм мўвемән Турәм мӑнэм тыхԓәӈа версәԓы». ");
INSERT INTO kca_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Щиты ԓапәт тащәӈ тӑԓәт Египет мўвән хӑщсәт, ");
INSERT INTO kca_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","щӑԓта ԓапәт ԓэԓԓы тӑԓәт йŏхәтсәт, Иосиф йастәм щирән. Пӑ хŏԓ мўвәтән ԓэԓԓы пŏра ус, туп Египет мўв ԓŏватән ԋаԋ ус. ");
INSERT INTO kca_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Египет мўвән ԓэԓԓы йӑт йŏхтәмән, фараон эԓты мир ԋаԋ вохты питәс. Хŏԓ Египет хŏйатәта фараон йастәс: «Иосиф хŏща мӑнаты, ԓўв хŏты йастәԓ, щиты вераты». ");
INSERT INTO kca_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Мўв ԓŏватән иса ԓэԓԓы пŏра ус; Иосиф ԋаԋ ԓат сопасԓәм хотԓаԓ пелки пўшсәԓы пӑ Египет мира тыныты питсәԓы. Ԓэԓԓы пŏра Египет мўвән йура йиты питәс. ");
INSERT INTO kca_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Па хон мўвәт эԓты Египта Иосиф эԓты ԋаԋ ԓат ԓутты йŏхтыԓысәт, мўв ԓŏватән ԓэԓԓы пŏра йура йиты питәс. ");
INSERT INTO kca_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Иаков Египтән ԋаԋ ԓат уԓты вер хуԓмаԓән, Иаков пŏхԓаԓа йастәс: «Мўй нын ԓавәԓԓәты?» ");
INSERT INTO kca_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Пӑ йастәс: «Ма хуԓтсэм, Египтән ԋаԋ ԓат уԓтаԓ; щи мӑнаты пӑ мўӈева ԋаԋ ԓат щита ԓутаты, мўӈева уԓты пӑ ӑт пӑрты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Иосиф йаӈ йай Египта ԋаԋ ԓат ԓутты мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Вениамин пӑ, Иосиф апщи, йайԓаԓ пиԓән Иаковән ӑт китса, ԓўв щиты йастәс: «Вера ӑт ат питәԓ». ");
INSERT INTO kca_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ханаан мўвән ԓэԓԓы пŏра ус, щишән, Израиль пŏхәт па йŏхтәм ŏтәт пиԓән ԋаԋ ԓат ԓутты йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Иосиф пӑ щи мўвән мет ун кущайа пŏнман ус; мўвән уԓты мира ԋаԋ ԓат ԓўв щи тыныйәс. Иосиф йайԓаԓ йŏхәтсәт пӑ ԓўв йэԓпеԓән мўв унты, ŏх пŏнман, иԓ ԋўрсәт. ");
INSERT INTO kca_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Иосиф йайԓаԓ кащаԓәс пӑ ԓывиԓаԓ мŏштәсԓы; туп ӑт уйәтты веш верәс пӑ ԓыв пиԓԓаԓән щикем такан пŏтәртәс пӑ ԓывиԓаԓа йастәс: «Хŏԓща нын йŏхәтсәты?» Ԓыв йастәсәт: «Ханаан мўв эԓты ԓэтŏт ԓутты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Иосиф йайԓаԓ мŏштәсԓы, ԓыв пӑ ԓўвеԓ ӑт мŏштәсэԓ. ");
INSERT INTO kca_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Иосиф уԓәмԓаԓ нумәԓмәс, хŏта ԓыв эԓтыԓаԓ уԓмийәс; пӑ ԓывиԓаԓа йастәс: «Нын хӑԋайән верәт ԓэрапты ŏтәт, мўӈ хŏщайэв ԉаԉ пиԓән йŏхәтты урәӈән сайԓы мўв вантыԓты». ");
INSERT INTO kca_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ԓыв пӑ ԓўвеԓа йастәсәт: «Ӑнта, мўӈ кущайэв; нӑӈ митйохԓан ԓэтŏт ԓутты йŏхәтсәт; ");
INSERT INTO kca_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","мўӈ хŏԓ и ащи ԋаврэмәт; мўӈ вещкат хŏйатәт; нӑӈ митйохԓан ӑнта хӑԋайән верәт ԓэрапты ŏтәт». ");
INSERT INTO kca_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ԓўв пӑ ԓывиԓаԓа йастәс: «Ӑнта, мўӈ хŏщайэв ԉаԉ пиԓән йŏхәтты урәӈән сайԓы мўв вантыԓты». ");
INSERT INTO kca_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ԓыв йастәсәт: «Мўӈ, нӑӈ митйохԓан, кӑтхŏщйаӈ йай; мўӈ Ханаан мўв эԓты уԓты и хŏйат пŏхәт, ай ŏтэв ащев пиԓән хӑщәс, итэв пӑ ӑнтом». ");
INSERT INTO kca_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Иосиф ԓывиԓаԓа йастәс: «Щит щи ма нынан пŏтәртсәм, йастымемән: нын хӑԋайән верәт ԓэрапты ŏтәт; ");
INSERT INTO kca_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","щи вер ин щиты ԓэрапԓэм: фараон уԓәпсайән йастәпса мӑԓәм, ай апщан йŏхәтты унты нын тӑԓта ӑт этԓәты; ");
INSERT INTO kca_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","итән китаԓән, ԓўв апщан ты ат туԓԓы, нын пӑ тӑта йэртман тӑйты питԓайты; щиты ԓэра йиԓ, йӑна мўй мӑнэм пŏтәрԓәты; ӑнта щиты ки, фараон уԓәпсайән йастәпса мӑԓәм, нын хӑԋайән верәт ԓэрапты ŏтәт». ");
INSERT INTO kca_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Пӑ хуԓәм хӑтԓа касна хота ԓывиԓаԓ омәссәԓы. ");
INSERT INTO kca_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Хуԓмет хӑтәԓән Иосиф ԓывиԓаԓа йастәс: «Тӑмиты вераԓән, щиты нын ԓыԓӈа хӑщԓәты, ма Турәм эԓты ищи пӑԓԓәм: ");
INSERT INTO kca_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","нын вещкат хŏйатәт ки, и апщан тӑм касна хотән ат хӑщәԓ; нын пӑ мӑнаты, ԓэԓԓы уԓты тыхәԓ тэԓԓәна ԋаԋ тўваты, ");
INSERT INTO kca_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","апщан пӑ ма хŏщайэм тўваԓән, йасәӈԓән вещкат урәӈән пӑ нынан ԓыԓӈа хӑщты урәӈән». Ԓыв щиты щи версэԓ. ");
INSERT INTO kca_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ԓыв кўтԓаԓән щиты пŏтәртсәт: «Апщева кӑрэк вермев урәӈән ин мўӈ сўтәтԓайув; мўӈ ватсэв, хŏты ԓўв шукащәс, хŏты мўӈев пойәксәԓы, туп ӑт хуԓәтсэв; щишән, тӑм шука питсув». ");
INSERT INTO kca_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рувим пӑ ԓывиԓаԓа йастәс: «Ма нынана ӑт хун пŏтәртысәм: ‘Энәмты пŏха кӑрэк аԓ вераты’? Нын пӑ ӑт хуԓәтсәты; щи, ин ўрәԓ кӑшты питса». ");
INSERT INTO kca_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Туп ԓыв ӑт уйәтсэԓ, Иосиф щит иса мŏштәԓԓы; ванты, ԓўв пиԓәԓән пŏтәртмеԓән йасәӈ тŏлмащԓәты хŏйат ус. ");
INSERT INTO kca_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Щӑԓта ԓыв эԓтыԓаԓ йэԓшәк мӑнәс пӑ йэԓ хоԓԓаԓтәс. Щӑԓта ԓыв хŏщайэԓ йŏхԓы йŏхтәс, па ԓыв пиԓԓаԓән пŏтәртәс, пӑ Симеон ԓыв кўтэԓ эԓты ўсԓы пӑ ԓыв ватман йӑрты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Щӑԓта Иосиф ԓыв хирԓаԓ ԋаԋ ԓатән тэкәптәты партсәԓы, ԓыв щел ŏхԓаԓ пӑ йŏхԓы хирԓаԓа пŏнты партсәԓы, пӑ мӑнты йушеԓа хӑԓы хирәтән мӑты партсәԓы. Щиты щи ԓыв пиԓԓаԓән верман уса. ");
INSERT INTO kca_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ԓыв ԋаԋ ԓат хирԓаԓ осёл войәт эԓты ԓэԓтсәԓаԓ, пӑ щиԓта мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Хун ԓыв хоԓты урәӈән ԓойсәт, и хуйэԓ хирәԓ эхсәԓы, осёл войәԓ ԋаԋ ԓатән мӑты урәӈән, пӑ хир овән ԓўв йŏра щел ŏхәԓ кащаԓәсԓы, ");
INSERT INTO kca_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","пӑ йайԓаԓа йастәс: «Щел ŏхем пӑ йŏхԓы пŏнәм; тӑта щи хирэм ԓыпийән». Ԓыв сӑмԓаԓ мӑтсәт, пӑ ԓыв кўтэԓән пӑԓтамәман пŏтәртты питсәт: «Амуй щит Турәм мўӈ пиԓэвән верәс?» ");
INSERT INTO kca_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Щӑԓта Ханаан мўва, Иаков ащеԓ хŏща йŏхәтмеԓән, ԓыв пиԓэԓән уԓәм верәт хŏԓ ԓўвеԓа пŏтәртсэԓ, щиты йастәсәт: ");
INSERT INTO kca_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Щи мўвән уна уԓты куща щикем такан мўӈ пиԓэвән пŏтәртәс пӑ щи мўв хӑԋайән верәт ԓэрапты ŏтәта мўӈев йўкатсәԓы». ");
INSERT INTO kca_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Мўӈ ԓўвеԓа йастәсув: «Мўӈ вещкат хŏйатәт; мўӈ ӑнта хӑԋайән верәт ԓэрапты ŏтәт; ");
INSERT INTO kca_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","мўӈ кӑтхŏщйаӈ йай-апщи ащев хŏща; итэв пӑ ӑнтом, ай апщев пӑ ащев пиԓән Ханаан мўвевән хӑщәс». ");
INSERT INTO kca_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Щӑԓта щи мўвән уна уԓты куща щиты йастәс: «Ма щиты ԓэрапԓэм, мўй хŏрпи нын вещкат хŏйатәт: и апщан ма хŏщайэм хӑйаԓән, нын пӑ ԋаԋ ԓат ўйаты ԓэԓԓы уԓты тыхәԓ тэԓԓән урәӈән пӑ мӑнаты, ");
INSERT INTO kca_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","пӑ ай апщан ма хŏщайэм тўваԓән; щиты ма уйәтты питԓэм, нын ӑнта хӑԋайән верәт ԓэрапты ŏтәт, нын вещкат хŏйатәт; щишән, апщан эсәԓԓэм, пӑ тӑм мўвән тынасты верәтԓәты». ");
INSERT INTO kca_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Щӑԓта, хирәт шошәмты питмеԓән, кашәӈ ху хирәԓән ԓўв йŏра щел ŏхәԓ уйтәс. Ŏхи хирԓаԓ кащаԓымеԓән, ащеԓ ики пиԓән ԓыв хŏԓт пӑԓтәмәсәт. ");
INSERT INTO kca_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Щӑԓта Иаков ащеԓ ԓывиԓаԓа йастәс: «Нын урӈәнән ԋаврэмԓам ӑнтомәт: Иосиф ӑнтом, Симеон ӑнтом, Вениамин па ўты ўтщиԓԓын, – щит иса мӑнэма хойәԓ!» ");
INSERT INTO kca_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Щӑԓта Рувим ащеԓа йастәс: «Ма пŏхӈиԓам веԓаԓән, Вениамин йŏхԓы ӑт туԓэм ки; ма йошема ԓўвеԓ мийи; ма ԓўвеԓ нӑӈ хŏщайэн йŏхи туԓэм». ");
INSERT INTO kca_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ԓўв пӑ йастәс: «Пŏхем нын пиԓанән ӑт мӑнәԓ; йайәԓ пӑрәс, пӑ ԓўв утща хӑщәс, щишән; йушән мӑнман мŏԓты вера питәԓ ки, вотәм ŏхем щи шукән хощман иԓта турма туԓԓән». ");
INSERT INTO kca_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Мўвән ԓэԓԓы пŏра йура йис. ");
INSERT INTO kca_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Египет эԓты тутԓыйәм ԋаԋ ԓантэԓ ԓэвмеԓ йўпийән, ащеԓ ики ԓывиԓаԓа йастәс: «Па йӑӈхаты, мўӈева ԓэтŏт йэша ԓутаты». ");
INSERT INTO kca_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Иуда ԓўвеԓа йастәс: «Щи хŏйат мўӈева такан йастәс: ‘Апщан такԓы ма хŏщайэм аԓ йŏхтаты’. ");
INSERT INTO kca_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Апщев мўӈ пиԓэвән китԓэн ки, мўӈ мӑнԓув пӑ нӑӈена ԓэтŏт ԓутԓув, ");
INSERT INTO kca_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ӑт китԓэн ки, ӑт мӑнԓув, щи хŏйат щиты мўӈева йастәс: ‘Апщан такԓы ма хŏщайэм аԓ йŏхтаты’». ");
INSERT INTO kca_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Израиль йастәс: «Мўй урәӈән нын мӑнэма щимәщ атәм версәты, па и апщи тӑйты верән щи хŏйата йастәманән?» ");
INSERT INTO kca_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ԓыв йастәсәт: «Щи хŏйат мўӈ эԓтэв пӑ мўӈ рутэв эԓты ар пўш иԋщәсәс, щиты пŏтәртәс: ‘Нын ащан хŏԓна ԓыԓәӈ? Йай-апщи тӑйԓәты?’ Мўӈ пӑ ԓўвеԓа щи иԋщәпсайәԓ щирән пŏтәртсэв. Хŏԓща мўӈ уйәтсэв, ԓўв щиты йастәԓ: ‘Апщан ты тўваԓән’?». ");
INSERT INTO kca_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Израиль ащеԓ пеԓа Иуда щиты йастәс: «Энәмты пŏхен ма пиԓэмән эсԓы, мўӈ ԓойԓув пӑ йӑхԓув, щишән ԓыԓӈа хӑщԓув пӑ ӑт пӑрԓув: мўӈ, пӑ нӑӈ, пӑ мўӈ ԋаврэмԓув; ");
INSERT INTO kca_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ма йасәӈ мӑԓәм, ма эԓтэм иԋщәсԓэн; ма нӑӈ хŏщайэн ԓўвеԓ ӑт туԓэм ки, нӑӈ веншен йэщаԓт ӑт ԓощәԓтәԓэм ки, уԓтэм хўват нўрәӈ питԓәм; ");
INSERT INTO kca_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","мўӈ ӑт ки рŏтсув, кӑт пўш йӑхсув – йŏхәтсув, ԓўԓән». ");
INSERT INTO kca_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Израиль ащан ики ԓывиԓаԓа йастәс: «Щиты ки, тӑмиты вераԓән: тӑм мўв мет йӑм мойԓәпсайәт пӑтән ўйаты пӑ щи хŏйата тўваԓән: бальзам пӑ пирәм мав, пӑ йӑма авты стиракс йўх ух пӑ ладан йоԓ, фисташка пӑ миндаль; ");
INSERT INTO kca_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","кӑт пўш аршәк ŏх пӑ ўйаты; хир ова йŏхԓы пŏнәм ŏхԓән нын йошԓәнән йŏхԓы мийаԓән: мосәӈ, ӑт ватман щиты тыйәс; ");
INSERT INTO kca_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","апщан па ўйаԓән, ԓойаты пӑ щи хŏйат хŏща мӑнаты; ");
INSERT INTO kca_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Иса Верәтты Турәм нынан ат шавиԓԓы, щи хŏйат Вениамин пӑ кимет апщан ат эсәԓԓәԓы; ма пӑ, ԋаврэмԓы хӑщԓәм ки, щиты ԋаврэмԓы ат уԓԓәм». ");
INSERT INTO kca_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Щӑԓта щи хŏйатәт мойԓәпсайәт ўсәт, кӑт пўш аршәк щел ŏх ўсәт, Вениамин па пӑтән ўсэԓ, ԓойсәт пӑ Египта мӑтсәт пӑ Иосиф хŏща йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ԓыв кўтэԓән Вениамин кащаԓәмаԓән, Иосиф ԓўв хотәԓ митйохәт кущайа йастәс: «Щи хŏйатәт хотэма вохаԓән, мӑтты вой хŏра пӑ ԓэтŏт ԓэщата, хӑтәԓ кўтәпән щи хŏйатәт ма пиԓэмән ԓэты питԓәт». ");
INSERT INTO kca_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Иосиф партәм щирән хŏйат иса версәԓы пӑ Иосиф хота щи мŏхет ԓŏӈәԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Хŏйатәт пӑ пӑԓтамәсәт, хун Иосиф хота тусайәт, пӑ йастәсәт: «Тӑм хирԓува йŏхԓы пŏнәм щел ŏхԓув урәӈән ты тусайув, мўӈ хŏщайэв йŏвәртыты пӑ мўӈев иԓ катәԓты урәӈән, тынԓы-пелԓы ԋўрты урәӈән осёл войԓув пиԓән ты тусайув». ");
INSERT INTO kca_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Щитэԓән Иосиф хотәԓ митйохәт куща хŏща ванамәсәт пӑ хот ов хŏща ԓўвеԓа пŏтәртты питсәт, ");
INSERT INTO kca_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","пӑ йастәсәт: «Щи ԓŏват йӑм вера, хуԓәнта, куща ху, тӑм йэԓпийән мўӈ ԓэтŏт ԓутты ты йŏхтыԓысув, ");
INSERT INTO kca_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","щӑԓта, йŏхԓы мӑнмевән, мўӈ хоԓты ԓойԓысув, щита хирԓув эхсәԓув пӑ кашәӈ хир овән – мўӈ сŏхәптәм щел ŏхев тӑԓаӈ тэԓән уԓмаԓ, щи ŏхԓув мўӈ йŏхԓы тусԓув; ");
INSERT INTO kca_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ин ԓэтŏт ԓутты урәӈән па щел ŏх тусув. Мўӈ ӑт уйәтԓэв, хŏйән щи ŏхԓув йŏхԓы хирԓува пŏтсайәт». ");
INSERT INTO kca_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ԓўв йастәс: «Рома уԓаты, аԓ пӑԓаты; нын Турмән пӑ нын ащан Турәм нын хирԓәна ԓум пŏнәс; нын щел ŏхән ма унтэм йŏхтәс». Щӑԓта Симеон ԓыв хŏщайэԓ тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Щӑԓта щи хŏйат ԓывиԓаԓ Иосиф хота ԓŏӈәԓтсәԓы пӑ йикән тусԓы пӑ ԓыв кўрԓаԓ ԉŏхәтсәԓаԓ; осёл войԓаԓ ищи ԓэтŏтән мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Хӑтәԓ кўтәпән Иосиф йŏхәтты унты ԓыв мойԓәпсайәт ԓэщатсәт, ԓыв хуԓсэԓ, щита ԓэты питԓәт. ");
INSERT INTO kca_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Щӑԓта Иосиф йŏхи йŏхтәс; ԓыв йошԓаԓән мойԓәпсайԓаԓ ԓўвеԓа хота ԓŏӈәԓсәԓаԓ, пӑ мўв унты ԓўв йэԓпеԓән, ŏх пŏнман, иԓ ԋўрсәт. ");
INSERT INTO kca_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ԓўв пӑ тўмтак верэԓ эԓты ԓывиԓаԓ иԋщәссәԓы пӑ йастәс: «Нын пирәщ ащан ики тўмтака мўй уԓ, хŏй эԓты нын пŏтәртсәты? Хŏԓна ԓўв ԓыԓәӈ?» ");
INSERT INTO kca_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ԓыв йастәсәт: «Тўмтак нӑӈ митхуйэн, мўӈ ащев ики, хŏԓна ԓыԓәӈ». Щӑԓта ԓыв, ŏх пŏнман, иԓ ԋўрсәт. ");
INSERT INTO kca_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Иосиф сэмԓаԓ нŏх эԓәтсәԓы пӑ Вениамин кащаԓәс, ԓўв апщеԓ, ԓўв аԋԏэԓ пŏх, пӑ йастәс: «Тӑм нын ай апщан, хŏй эԓты нын мӑнэма пŏтәртысты?» Пӑ йастәс: «Турәмән ат шавиԓайән, пŏхийэм!» ");
INSERT INTO kca_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Иосиф апщеԓ урәӈән сӑмәԓ ԋŏхԓәс, хӑщ йэԓ хоԓԓаԓтәс, щишән, тэрматыман щиԓта этәс пӑ пӑты хот пӑтыйа мӑнәс пӑ щита хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Щӑԓта вешәԓ нŏх ԉŏхәтсәԓы, йŏхԓы ԓыв хŏщайэԓ йŏхтәс, нŏпсәԓ такапсәԓы пӑ йастәс: «Ԓэтŏт тўваты». ");
INSERT INTO kca_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Щӑԓта ԓўвеԓа утщайа мӑса, ԓывиԓаԓа пӑ утщайа, Иосиф пиԓән ԓэвәм Египет мўв хŏйатәта па утщайа, Египет хŏйатәт еврейәт пиԓән йӑха ԓэты ӑт верәтԓәт, Египет хŏйатәта щит йэм. ");
INSERT INTO kca_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Щӑԓта ԓыв Иосиф йэщаԓт опсәԓсайәт, оԓәӈ ŏт оԓәӈ ŏт щирән, ай ŏт ай ŏт щирән, щи хŏйатәт пӑ, ийэщаԓт омәсман, ощатыман ватсәт. ");
INSERT INTO kca_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Иосиф пӑсан эԓты ԓэтŏтән тутԓысайәт, Вениамин йайԓаԓ эԓты вет пўш арәншак мийԓыса. Ԓўв пиԓәԓән ԓыв мŏрта ԓэсәт пӑ йищсәт пӑ кашәӈа йисәт. ");
INSERT INTO kca_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Щӑԓта Иосиф ԓўв хотәԓ митйохәт кущайа партәс, щиты йастәс: «Тӑм хŏйатәт хирԓаԓ ԓэтŏтән тэԓ пŏнаԓән, мўй арат войԓаԓ туты верәтԓәт, кашәӈ ŏта сŏхәптәм щел ŏхәԓ хир ова йŏхԓы пŏны, ");
INSERT INTO kca_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ма анэм пӑ, щел ŏх анэм, ай хуйэԓ хир ова ԓўв ԓутәм ԋаԋәԓ сӑхат сŏхәптәм ŏхәԓ пиԓән пŏны». Щитәԓ Иосиф йастәм щирән иса версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Аԓәӈсӑхат, нŏвийа йўвәмән, щи хŏйатәт йŏхԓы мӑнты эсәԓсайәт, ԓыв пӑ осёл войԓаԓ па. ");
INSERT INTO kca_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ԓыв шек хўва вош эԓты ӑт питсәт, хун Иосиф хотәԓ митйохәт кущайа йастәс: «Мӑна, щи хŏйатәт йŏԓта ԋухԓаԓән, эԓты йŏхәттэнән, ԓывиԓаԓа йаста: ‘Мўйа нын йӑм йўкана атәм версәты? ");
INSERT INTO kca_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Тӑм ан эԓты кущайэм йищәԓ пӑ щӑртәԓ? Атәм нын версәты’». ");
INSERT INTO kca_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ԓўв ԓывиԓаԓ эԓты йŏхәтсәԓы пӑ щи йасӈәт ԓывиԓаԓа йастәс. ");
INSERT INTO kca_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ԓыв пӑ ԓўвеԓа йŏхԓы йастәсәт: «Мўйа кущайэв щимәщ йасӈәт пŏтәртәԓ? Ӑнта, нӑӈ митйохԓан щимәщ вер ӑт верԓәт. ");
INSERT INTO kca_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Тӑта щи, хир овԓувән уйтәм щел ŏхев мўӈ нӑӈена йŏхԓы Ханаан мўв эԓты тусэв: хŏты сӑхат щел ŏх мўй па сорԋи кущайэн хот эԓты ԓоԓәмты верәтԓув? ");
INSERT INTO kca_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Мӑты митхуйэн хŏща щи ан уйәтԓэн, щитэна сŏрәм, мўӈ пӑ кущайэва митйоха питԓув». ");
INSERT INTO kca_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ԓўв йастәс: «Йӑм; хŏты нын йастәсты, щиты ат питәԓ: хŏй хŏща ан уйәтԓа, щит митхуйэма питәԓ, нын пӑ нўрәӈа ӑт питԓәты». ");
INSERT INTO kca_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ԓыв сора хирԓаԓ иԓ эсәԓсәԓаԓ, мўв эԓты пŏтсәԓаԓ пӑ кашәӈ хŏйат ԓўв хирәԓ пелки эхсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ԓўв хирәт хŏԓ ватсәԓы, ун хуйэԓ эԓты питщәсԓы пӑ ай ŏтәԓән йэтшәптәсԓы; Вениамин хирән ан уйәтса. ");
INSERT INTO kca_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ԓыв ԓумтәмԓаԓ мӑншисԓаԓ пӑ осёл войԓаԓ эԓты хирԓаԓ ԓэԓсәԓәԓ, пӑ йŏхԓы воша керԓәсәт. ");
INSERT INTO kca_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Иуда пӑ ԓўв йайԓаԓ-апщиԓаԓ Иосиф хота йŏхәтсәт, ԓўв хŏԓна йŏԓән уԓмаԓ, пӑ ԓўв йэԓпеԓән мўва иԓ рӑкәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Иосиф ԓывиԓаԓа йастәс: «Мўй нын версәты? Нын мўй ӑт уйәтсәԓән, ма хŏрпем хŏйат ищипа щи вер ԓэрапты урәӈән щӑртыԓәты верәтәԓ?» ");
INSERT INTO kca_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Иуда йастәс: «Мўй мўӈ верәтԓув кущайэва йастәты? Мўй пŏтәртты? Мўй йŏхԓы йастәԓув? Митйохԓан накԓат Турәм уйәтсәԓы; ин мўӈ хŏԓ кущайэв митйохәт, мўӈ хŏԓ, пӑ щитэв, хŏйтэв хирән ан уйәтса». ");
INSERT INTO kca_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Иосиф пӑ йастәс: «Ӑнта, щиты ма ӑт верԓэм; хŏй хŏща ан уйәтса, щит ма митхуйэма питәԓ, нын пӑ ащан хŏща йӑмән мӑнаты». ");
INSERT INTO kca_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Иуда ԓўв хŏщайәԓ ванамәс пӑ йастәс: «Кущайэм, митхуйэна пӑԓԓана йасәӈ йастәты эсԓы, пӑ митхуйэн пеԓа аԓ ԉикаща, нӑӈ ищи фараон пӑԓатән омәсԓән. ");
INSERT INTO kca_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Кущайэм митйохԓаԓ иԋщәссәԓы, йастәман: ‘Ащи мўй йай-апщи тӑйԓәты?’ ");
INSERT INTO kca_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Кущайэва мўӈ йастәсув, пирәщ ащи тӑйты верэв пӑ апщи, ащев тӑԓԓаԓ ара йўвман тӑйәм пŏхәԓ, ԓўв йайәԓ пӑрәс, аԋԏэԓ эԓты ԓўв утща ԓыԓӈа хӑщәс, щишән, ащеԓән сӑмәӈа тӑйԓа. ");
INSERT INTO kca_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Нӑӈ митйохԓана партсэн: ‘Ма хŏщайэм ԓўвеԓ тўваԓән, мӑнэм ԓўвеԓ ватты урәӈән’. ");
INSERT INTO kca_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Кущайэва мўӈ йастәсув: ‘Энәмты пŏх ащеԓ хӑйты ӑт верәтԓәԓы, ащеԓ хӑйԓәԓы ки, ащеԓ пӑрәԓ’. ");
INSERT INTO kca_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Нӑӈ пӑ митйохԓана йастәсән: ‘Ай апщан нын пиԓанән ӑт ки йŏхәтәԓ, нын ма хŏщайэм аԓ па этԓыйаты’. ");
INSERT INTO kca_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Хун мўӈ ащев хŏща, нӑӈ митхуйэн хŏща, йŏхәтсув, кущайэм йасӈәт ԓўвеԓа пŏтәртсәԓув. ");
INSERT INTO kca_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Щӑԓта, пŏра хӑщәмән, ащев ики па йастәс: ‘Па йӑӈхаты, ԓэтŏт йэша ԓутаты’. ");
INSERT INTO kca_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Мўӈ ԓўвеԓа щиты йастәсув: ‘Утща мӑнты мўӈева ӑт рӑхәԓ; туп апщев мўӈ пиԓэвән мӑнәԓ ки, мўӈ мӑнԓув; щи хŏйат веш ватты мўӈева ӑт рӑхәԓ, апщев мўӈ пиԓэвән ӑт ки питәԓ’. ");
INSERT INTO kca_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ащев, нӑӈ митхуйэн, мўӈева щиты йастәс: ‘Нын уйәтԓәԓән, имем мӑнэма кӑт пŏх сэма пайтәс; ");
INSERT INTO kca_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","итәԓ ма эԓтэм мӑнәс, ма йастәсәм: аԓт ԓўв ут войән лакки мӑншиса; ин тӑм унты ԓўвеԓ ӑт ватсэм; ");
INSERT INTO kca_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","хŏԓна тӑмем ма эԓтэм ўԓԓән ки, пӑ мŏԓты вера питәԓ ки, вотәм ŏхем, щи шукән хощман, иԓта турма туԓԓән’. ");
INSERT INTO kca_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ин ма ащев хŏща, нӑӈ митхуйэн хŏща, йŏхәтԓәм ки, пӑ ԓўв ԓыԓәԓ шавиты ай апщев мўӈ пиԓэвән ӑт ки питәԓ, ");
INSERT INTO kca_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ԓўв, энәмты пŏх ӑнтом вер кащаԓәтаԓән, пӑрәԓ; пӑ мўӈ, нӑӈ митйохԓан ащев ики вотәм ŏхәԓ, хощман, иԓта турма туԓэв. ");
INSERT INTO kca_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Щӑԓта пӑ ма, нӑӈ митхуйэн, щи энәмты пŏх урәӈән ащема йасәӈ мӑсәм: ‘Йŏхԓы нӑӈ хŏщайэн ӑт ки туԓэм, уԓтэм хўват нӑӈ йэԓпенән нўрәӈ питԓәм’. ");
INSERT INTO kca_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Щишән, ма, нӑӈ митхуйэн, ԓўв йўканәԓа кущайэм хŏща митхуйа ат хӑщԓәм, энәмты пŏх пӑ йайԓаԓ пиԓән ат мӑнәԓ; ");
INSERT INTO kca_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ӑԓ щиты, ма мўй щирән ащем хŏща апщем такԓы мӑнԓәм? Ащем шук туты вер ма ватты ӑт верәтԓәм». ");
INSERT INTO kca_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ԓўв пўӈԓәԓән ԓойәм хŏйатәт уԓман Иосиф нŏпсәԓ шӑкәс пӑ ԓўв ўваԓтәс: «Ма эԓтэм йэԓ мӑнаты!» Щишән, нэмәԓты пўӈәԓ хŏйат ӑнтом ус, хун ԓўв йайԓаԓа аԉәсәс. ");
INSERT INTO kca_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ԓўв щиты такан хоԓԓаԓтәс пӑ, Египет хŏйатәтән хуԓса пӑ фараон хот хŏйатәтән хуԓса. ");
INSERT INTO kca_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Иосиф пӑ йайԓаԓа йастәс: «Ма – Иосиф, ащем хŏԓна ԓыԓәӈ?» Туп йайԓаԓ нэмәԓты йастәты ӑт верәтсәт, ԓыв ӑт уйәтсәт, мўй нумәсты. ");
INSERT INTO kca_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Иосиф йайԓаԓа йастәс: «Ма хŏщайэм вана йўваты». Ԓыв ванамәсәт. Ԓўв йастәс: «Ма – Иосиф, нын апщан, хŏйтан Египта нын тынысԓән; ");
INSERT INTO kca_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","туп ин аԓ хошийаты пӑ нынан аԓ нўрмәԓтаԓән мӑнэм ты тыныман урәӈән, щит Турәм мӑнэм нын йэԓпанән китсәԓы нын уԓәпсайән шавиты урәӈән; ");
INSERT INTO kca_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","кӑт тӑԓа йис, хŏты мўвән ԓэԓԓы йӑт йŏхтәс: хŏԓна вет тӑԓ нэмәԓты мўва омәсты ӑт питԓа, нэмәԓты ӑкәтты ӑт питԓа; ");
INSERT INTO kca_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Турәм мӑнэм нын йэԓпанән китсәԓы, нынан пӑ нын тыхәԓ тэԓԓән мўвән хӑйты урәӈән пӑ нын уԓәпсайән вŏԓаӈ щирән шавиты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Щишән, ӑнта нын мӑнэм ты китсәԓән, щит Турәм, Ԓўв мӑнэм фараон ԓӑӈкәр хуйа пŏтсәԓы, пӑ хŏԓ ԓўв хотәԓ кущайа, пӑ Египет мўв тӑйтаӈ ун кущайа ищи. ");
INSERT INTO kca_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ащем хŏща сора мӑнаты пӑ ԓўвеԓа пŏтәртаты: ‘Иосиф пŏхен щиты йастәԓ: Турәм мӑнэм Египет мўв ԓŏватән кущайа пŏтсәԓы; ма хŏщайэм йŏхта, аԓ рŏна; ");
INSERT INTO kca_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Гесем мўв щуӈән нӑӈ уԓты питԓән; ма пўӈԓэмән ванән нӑӈ питԓән, нӑӈ пŏхԓан па, нӑӈ пŏхԓан пŏхәт па, ай пӑ ун войԓан, пӑ иса, мўй нӑӈ тӑйԓән; ");
INSERT INTO kca_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","пӑ нӑӈен щита ԓапәтты верәтԓэм, ԓэԓԓы йӑт хŏԓна вет тӑԓ питәԓ, нӑӈена пӑ нӑӈ хотәӈ ŏтԓана нўшайа ӑт питты урәӈән’. ");
INSERT INTO kca_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Тӑта щи, нын сэмԓән пӑ Вениамин апщем сэмәт ватԓәт, щит ма нын пиԓанән пŏтәртԓәм; ");
INSERT INTO kca_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Египет мўвән ма ун кущайа уԓты уԓәпсайэм эԓты пӑ иса, мўй нын тӑта ватсәты, ащема пŏтәртаты, пӑ сорашәк ащем ты тўваԓән». ");
INSERT INTO kca_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Щӑԓта ԓўв Вениамин апщеԓ ӑпәԓсәԓы пӑ хоԓԓәс; Вениамин пӑ, ԓўвеԓ ӑпәԓтыман, хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Пӑ йайԓаԓ хŏԓ мосәԓтәсԓы, ԓывиԓаԓ ӑпәԓтыман, хоԓԓәс. Щӑԓта йайԓаԓ ԓўв пиԓәԓән пŏтәртсәт. ");
INSERT INTO kca_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Иосиф йайԓаԓ йŏхтәм айкеԓ фараон унты йŏхтәс; фараон митйохԓаԓ пиԓән нŏх амтәс. ");
INSERT INTO kca_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Фараон Иосиф пеԓа йастәс: «Йайԓан пеԓа йаста: ‘Тӑмиты вераты: войԓән шӑншәт ԋаԋ ԓатән ԓэԓтаԓән пӑ Ханаан мўва мӑнаты; ");
INSERT INTO kca_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ащан пӑ нын тыхәԓ тэԓԓән ўйаты, пӑ ма хŏщайэм йŏхтаты; ма нынана мет йӑм тӑха Египетән мӑԓәм, мўвән энмәԓтәм мет йӑм ԓэвпәсәт нын ԓэты питԓәты’. ");
INSERT INTO kca_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Нӑӈена ин партԓэм ԓывиԓаԓа йастәты: ‘Щиты вераты: Египет мўв эԓты колесница ԓовәӈ ухԓәт ԋаврэмԓән пӑ имиԓән урәӈән ўйаты, ащан ты тўваԓән пӑ нын ты йŏхтаты; ");
INSERT INTO kca_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","пŏрмасԓән эԓты аԓ нумәсаты, Египет мўвән мўй йӑм уԓ, щит эԓты нынана мӑԓәм’». ");
INSERT INTO kca_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Израиль пŏхәт щиты щи версэԓ. Колесница ԓовәӈ ухԓәт Иосиф ԓывиԓаԓа мӑсԓы, хŏты фараонән партса, пӑ йушән тӑрәмты арат хӑԓ мӑс; ");
INSERT INTO kca_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","кашәӈ хŏйата йӑԓәп ԓумтәм сŏх мӑс, Вениамина пӑ хуԓәмсот щел ŏх пӑ вет йӑԓәп ԓумтәм сŏх мӑс; ");
INSERT INTO kca_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ащеԓа пӑ Египет мўв мет йӑм пŏрмасәтән ԓэԓтәм йаӈ осёл вой китәс, пӑ йаӈ осёл нэ вой ԋаԋ ԓатән, ԋаԋән пӑ хӑԓы хирән ащеԓа йŏхԓы йуш кеша ԓэԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Щӑԓта йайԓаԓ эсәԓсәԓы, пӑ ԓыв мӑтсәт. Пӑ ԓывиԓаԓа йастәс: «Йушән кўтәӈа ӑԓ йўваты». ");
INSERT INTO kca_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ԓыв Египет мўв эԓты мӑтсәт пӑ Ханаан мўва Иаков ащеԓ хŏща йŏхәтсәт, ");
INSERT INTO kca_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","пӑ айкеԓ тусәт, щиты йастәсәт: «Иосиф ԓыԓәӈ пӑ Египет мўв ԓŏватән ун кущайа уԓ». Иаков ԓыԓәԓ йэрмәс, пӑ ԓўв ԓывиԓаԓа ӑт эвԓәс. ");
INSERT INTO kca_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Щӑԓта, хун ԓыв ԓўвеԓа Иосиф йасӈәт пŏтәртсәԓәԓ, мўй ԓўв йастыԓыйәс, пӑ щӑԓта, хун Иосифән ԓўвеԓ туты китәм колесница ԓовәӈ ухԓәт кащаԓәс, Иаков ащеԓ ԓыԓәԓ ԓӑщкама йис, ");
INSERT INTO kca_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","пӑ Израиль йастәс: «Мета щи, тӑрмәԓ, Иосиф пŏхем ԓыԓәӈ; мӑнԓәм пӑ пӑртэм йэԓпийән ԓўвеԓ ватԓэм». ");
INSERT INTO kca_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Израиль ԓўв тӑйәм ŏтәԓ пиԓән мӑнәс, пӑ Вирсавияйа йŏхтәс, пӑ Исаак ащеԓ Турма Иаков щита йир верәс. ");
INSERT INTO kca_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Атәԓән уԓәмән Турәм Израиль вохсәԓы: «Иаков! Иаков!» Ԓўв йастәс: «Ма щи». ");
INSERT INTO kca_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Турәм йастәс: «Ма Турәм, нӑӈ ащен Турәм; Египет мўва мӑнты аԓ пӑԓа, щита нӑӈ эԓтэн вŏԓаӈ мир тыйәԓтԓәм; ");
INSERT INTO kca_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ма нӑӈ пиԓэнән Египет мўва мӑнԓәм, Ма нынан йŏхԓы па туԓԓам. Иосиф ԓўв йошәԓән нӑӈ сэмԓан лӑп петԓәԓы». ");
INSERT INTO kca_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Вирсавия эԓты Иаков йэԓԓы мӑнәс; пӑ щӑԓта Израиль пŏхәт Иаков ики, ԋаврэмԓаԓ, имиԓаԓ пиԓән колесница ԓовәӈ ухԓәтән Египет мўва тусԓаԓ; щитәт фараонән китсайәт, ԓўвеԓ туты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ханаан мўвән шитәм войԓаԓ пӑ пŏрмасԓаԓ пӑтән ўсԓаԓ, пӑ Египет мўва йŏхәтсәт, – Иаков пӑ хŏԓ рутәԓ ԓўв пиԓәԓән. ");
INSERT INTO kca_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Пŏхԓаԓ пӑ хиԓыԓаԓ, эвиԓаԓ пӑ хиԓынэԓаԓ, пӑ хŏԓ рутәԓ ԓўв пиԓәԓән Египет мўва пӑтән тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Тӑта щи Египет мўва йŏхтәм Израиль пŏхԓаԓ нэмәт: Иаков пӑ ԓўв пŏхԓаԓ. Иаков оԓәӈ пŏхәԓ Рувим. ");
INSERT INTO kca_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Рувим пŏхәт: Ханох пӑ Фаллу, Хецрон пӑ Харми. ");
INSERT INTO kca_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Симеон пŏхәт: Иемуил пӑ Иамин, пӑ Огад, пӑ Иахин, пӑ Цохар, пӑ Саул, ханаан нэ пŏх. ");
INSERT INTO kca_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Левий пŏхәт: Гирсон, Кааф пӑ Мерари. ");
INSERT INTO kca_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Иуда пŏхәт: Ир пӑ Онан, пӑ Шела, пӑ Фарес, пӑ Зара; туп Ир пӑ Онан ханаан мўвән пӑрсәтән. Фарес пŏхәт: Есром пӑ Хамул. ");
INSERT INTO kca_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Иссахар пŏхәт: Фола пӑ Фува, Иов пӑ Шимрон. ");
INSERT INTO kca_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Завулон пŏхәт: Серед пӑ Елон, пӑ Иахлеил. ");
INSERT INTO kca_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Щит Лия тыхәԓ тэԓ ус, Месопотамия мўвән Иакова тӑйәм пŏхәт пӑ Дина эвеԓ, пӑ ԓыв пŏхԓаԓ. Аратәԓән ԋӑԓйаӈ пеԓа хуԓәм хŏйат эвиԓаԓ пӑ пŏхԓаԓ, пӑ ԓыв ԋаврэмԓаԓ. ");
INSERT INTO kca_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Гад пŏхәт: Цифион пӑ Хагги, Шуни пӑ Эцбон, Ери пӑ Ароди пӑ Арели. ");
INSERT INTO kca_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Асир пŏхәт: Имна пӑ Ишва, пӑ Ишви, пӑ Бриа, пӑ Серах нэ ŏпеԓ. Бриа пŏхәт: Хевер пӑ Малхиил. ");
INSERT INTO kca_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Щит Зелфа тыхәԓ тэԓ ус, Лаванән Лия эвеԓа ԓўв митнэӈа мӑса. Иакова ԓўв энмәԓтәм тыхԓаԓ аратәԓән хутхŏщйаӈ ԋаврэм ус. ");
INSERT INTO kca_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Иаков Рахиль имеԓ пŏхәт: Иосиф пӑ Вениамин. ");
INSERT INTO kca_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Египет мўвән Иосиф хŏща Манассия пӑ Ефрем сэма питсәтән, Асенефа, Илиополь вош Потифер нэмпи йир верты хŏйат эвийән, сэма пайәтсайтән. ");
INSERT INTO kca_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Вениамин пŏхәт: Бела пӑ Бехер пӑ Ашбел; Гера пӑ Нааман, Эхи пӑ Рош, Муппим пӑ Хуппим пӑ Ард. ");
INSERT INTO kca_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Щит иса Рахиль тыхәԓ тэԓ ус, хŏйтат Иаков хŏща сэма питсәт, аратәԓән ԋӑԓхŏщйаӈ хŏйат. ");
INSERT INTO kca_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Дан пŏх: Хушим. ");
INSERT INTO kca_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Неффалим пŏхәт: Иахцеил пӑ Гуни, пӑ Иецер, пӑ Шиллем. ");
INSERT INTO kca_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Тӑм Валла тыхәԓ тэԓ ус, Лаванән Рахиль эвеԓа ԓўв митнэӈа мӑса. Иакова ԓўв энмәԓтәм тыхәԓ тэԓәԓ аратәԓән ԓапәт хŏйат. ");
INSERT INTO kca_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Египет мўва Иаков пиԓән йŏхтәм хŏйатәт, хŏйтат ԓўв эԓтэԓ тыйсәт, аратәԓән ԓапәтйаӈ пеԓа хут хŏйат, ԓыв тўмпеԓән хŏԓна Иаков пŏхԓаԓ имет па. ");
INSERT INTO kca_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Иосиф пŏхӈән, хŏйӈән Египет мўвән сэма питсәӈән, кӑт хŏйат. Египет мўва касԓәм Иаков хŏттэԓ хŏйат иуԓтыйа ԓапәтйаӈ. ");
INSERT INTO kca_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Иаков ԓўв йэԓпеԓән Иосиф хŏща Иуда китсәԓы, Иосифән Гесем пеԓа йуш аԉты урәӈән. Щӑԓта Гесем мўва ԓыв йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Иосиф ԓўв колесница ԓовәӈ ухԓәԓ киртсәԓы пӑ Израиль ащеԓ йэщаԓт Гесем мўва мӑнәс, ԓўвеԓ кащаԓәмәԓән, ӑпәԓсәԓы, пӑ ԓўв сапԓәԓән хўв хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Пӑ Израиль Иосифа йастәс: «Ин ма нӑӈен ԓыԓӈа ватмем йўпийән пӑрты верәтԓәм». ");
INSERT INTO kca_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Иосиф йайԓаԓа пӑ ащеԓ хŏт тэԓа йастәс: «Ма мӑнԓәм, фараона айкеԓ туԓәм пӑ ԓўвеԓ йастәԓәм: ‘Ма йайԓам пӑ ма ащем хот тэԓ, хŏйтат Ханаан мўвән усәт, ма хŏщайэм йŏхәтсәт; ");
INSERT INTO kca_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","щит ош шавиты хŏйатәт; ԓыв вой энмәԓԓәт; пӑ ун вой па ай вой тащԓаԓ пӑ мўй тӑйԓәт, ԓыв пӑтән тусԓаԓ’. ");
INSERT INTO kca_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Фараон нынан вохԓаԓы ки пӑ иԋщәсԓәԓы: ‘Мўй верман уԓԓәты?’, ");
INSERT INTO kca_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","нын щиты йастаты: ‘Мўӈ, нӑӈ митйохԓан, айтэԓән ин тӑм унты вой энмәԓтман усув, опращԓув иты’; щишән, нын Гесем мўвән уԓты хӑйԓайты. Египет хŏйатәт ош шавиты хŏйатәт ӑт шӑктәԓԓаԓ, ԓывиԓаԓа щит ўкщәм». ");
INSERT INTO kca_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Иосиф йŏхтәс пӑ фараона айкеԓ верәс пӑ йастәс: «Ащем пӑ йайԓам, ай пӑ ун вой тащԓаԓ пиԓән, пӑ иса мўй ԓыв тӑйԓәт, Ханаан мўв эԓты йŏхәтсәт; пӑ ин ԓыв Гесем мўвән». ");
INSERT INTO kca_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Йайԓаԓ эԓты вет хŏйат ўс пӑ фараон йэщаԓт ԓощәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Фараон ԓўв йайԓаԓ иԋщәссәԓы: «Мўй верман уԓԓәты?» Ԓыв фараона йастәсәт: «Мўӈ ащиԓув иты ош тащ шавиты йох, нӑӈ митйохԓан». ");
INSERT INTO kca_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Щӑԓта ԓыв фараона йастәсәт: «Мўӈ тӑм мўва уԓты щира йŏхәтсув, тащ ԓапәтты мўв ӑнтом урәӈән, Ханаан мўвән шек ԓэԓԓы йӑт йŏхтәс; щишән, митйохԓан Гесем мўвән уԓты эсԓаԓән». ");
INSERT INTO kca_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Фараон Иосифа йастәс: «Ащен пӑ йайԓан нӑӈ хŏщайэн йŏхәтсәт; ");
INSERT INTO kca_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Египет мўв нӑӈ йэԓпенән: ащен пӑ йайԓан мет йӑм мўвән уԓты мийаԓән; Гесем мўвән ԓыв ат уԓԓәт; щӑԓта вер йӑма уйәтты хŏйатәт ԓыв кўтэԓән уйәтԓән ки, ма тащԓам вантыты хŏйатәт ԓыв эԓтыԓаԓ пŏна». ");
INSERT INTO kca_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Щӑԓта Иосиф Иаков ащеԓ фараон пиԓән уйтантыты тусԓы. Иаков фараон Турәм йӑмән мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Фараон Иаков пеԓа йастәс: «Нӑӈ нуптэн мўй арат тӑԓ?» ");
INSERT INTO kca_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Иаков фараона йастәс: «Ма касԓыйәм хӑтәԓԓам сот хŏԉмаӈ тӑԓ; ма уԓәм тӑԓԓам шимԓәт пӑ шукәӈәт, пӑ аратэԓән ащиԓам касԓыйәм тӑԓәта ӑт йŏхәтԓәт». ");
INSERT INTO kca_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Щӑԓта Иаков фараон Турәм йӑмән мӑсԓы, пӑ фараон эԓты этәс. ");
INSERT INTO kca_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Иосиф ащеԓ пӑ йайԓаԓ Египет мўвән уԓты хӑйсәԓы, Египет мет йӑм мўвән, Раамсес мўвән, ԓывиԓаԓа мўв щуӈ тӑйты мӑсԓы, хŏты фараонән партса. ");
INSERT INTO kca_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Иосиф ащеԓ пӑ йайԓаԓ, пӑ хŏԓ иса ащеԓ тыхәԓ тэԓ тӑрәмты аратән ԋаԋән мийԓысԓы, кашәӈ хот тэԓ тӑрәмты аратән. ");
INSERT INTO kca_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Мўв ԓŏватән ԋаԋ ӑнтом ус, мет ԓэԓԓы йӑт йŏхтәс, щишән, Египет пӑ Ханаан мўвәт ԓэԓԓы шукащсәт. ");
INSERT INTO kca_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Египет мўвән пӑ Ханаан мўвән мўй арат щел ŏх ус, щи ŏх тыныйәм ԋаԋ ԓат сӑхат Иосиф хŏԓ ӑкәтсәԓы пӑ фараон хотән шависԓы. ");
INSERT INTO kca_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Щиты Египет мўвән пӑ Ханаан мўвән щел ŏх хŏԓас. Египет мўв хŏйатәт Иосиф хŏща йŏхәтсәт пӑ йастәсәт: «Мўӈева ԋаԋ мийа; щел ŏхев хŏԓәм урәӈән, нӑӈ ватман, мўӈев мўй пӑрты мосәԓ?» ");
INSERT INTO kca_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Иосиф йастәс: «Тащԓән ты воштаԓән, войԓән сӑхат ԋаԋән мӑԓԓам, ŏхԓән ки хŏԓасәт». ");
INSERT INTO kca_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ԓыв тащԓаԓ Иосиф хŏща воштәсԓаԓ; Иосиф пӑ ԓывиԓаԓа ԋаԋ мийԓыйәс ԓовәт сӑхат, ош тащәт, мис тащәт пӑ осёл войәт сӑхат; щи тӑԓ ԓывиԓаԓ хŏԓ войԓаԓ сӑхат ԋаԋән ԓўв мийԓысԓы. ");
INSERT INTO kca_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Щи тӑԓ щиты хӑщәс; йухәт тӑԓ ԓўв хŏщайәԓа йŏхәтсәт пӑ ԓўвеԓа йастәсәт: «Мўӈ кущайэв эԓты ӑт хӑԋатԓэв, ŏхев хŏԓас, тащԓув па кущайэв пеԓа питсәт; кущайэва мӑты урәӈән нэмәԓты ӑт хӑщәс, мўӈ эԓԓув пӑ мўӈ мўвԓув тўмпийән; ");
INSERT INTO kca_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","мўй урәӈән мўӈева, нӑӈ сэмԓан ватман, пӑрты пӑ мўвԓув таԓты хӑйты? Мўӈиԓув пӑ мўӈ мўвԓув ԋаԋ сӑхат ԓутаԓән, пӑ мўӈ, мўвԓув пиԓән веккеша фараон митйоха питԓув, нӑӈ пӑ мўӈева ԋаԋ сэмәӈ ԓат мийа, мўӈев ԓыԓӈа хӑщты пӑ ӑт пӑрты урәӈән пӑ мўвев таԓты ӑт хӑйты урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Щиты Иосиф хŏԓ Египет мўв фараон урәӈән ԓутсәԓы, Египет мўвәӈ хŏйатәт кашәӈ ԓўв мўв хӑрәԓ тынысԓы ԓыԓӈа хӑщты урәӈән. Фараон пеԓа мўв иса питәс. ");
INSERT INTO kca_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Египет мўв и оԓӈәԓ эԓты кимет оԓӈәԓ унты уԓты мир хŏԓ митйоха Иосиф версәԓы. ");
INSERT INTO kca_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Туп йир верты хŏйатәт мўвәт Иосиф ӑт ԓутсәԓы, ԓыв фараон эԓты йўкан ŏхән мийԓысайәт, фараон мийәм ŏх эԓты ԓэсәт; щишән мўвеԓ ԓыв ӑт тынысэԓ. ");
INSERT INTO kca_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Иосиф мир пеԓа йастәс: «Тӑта щи, фараон кеша нынан пӑ нын мўвԓән ма ԓутсәԓам; тӑта щи нынана ԋаԋ сэмәӈ ԓат, пӑ мўва пŏнаԓән; ");
INSERT INTO kca_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ԋаԋ ӑкәтты пŏра йŏхәттаԓән, ветмет пелкәԓ фараона мийаԓән, ԋӑԓ пелкәԓ пӑ мўва омәсты пӑ нынана пӑ хотәӈ ŏтԓән пӑ ԋаврэмԓән ԓапәтты урәӈән хӑщәԓ». ");
INSERT INTO kca_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ԓыв йастәсәт: «Нӑӈ мўӈ ԓыԓэв шависэн; йӑм сэмән кущайэв мўӈ пеԓэва ат ватәԓ пӑ фараона митйоха питԓув». ");
INSERT INTO kca_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Щиты Иосиф Египет мўвән тӑм хӑтәԓ унты уԓты закон постәс: ӑктәм ԋаԋ ԓат ветмет пелкәԓ фараона мӑты, туп йир верты хŏйатәт ӑктәм ԋаԋ ԓат тўмпийән, ԓыв мўвеԓ фараон пеԓа ӑт ԓўӈтәсәс. ");
INSERT INTO kca_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Щиты Израиль Египет мўвән ус, Гесем мўв щуӈән, щи мўвән ԓыв тӑйтаӈаӈа уԓты питсәт, пӑ ԋаврэмәӈа йисәт, пӑ шек ара йисәт. ");
INSERT INTO kca_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Иаков Египет мўвән ԓапәтхŏщйаӈ тӑԓ ус; пӑ аратәԓ тӑԓԓаԓ щирән ԓўв сот ветйаӈ пеԓа ԓапәт тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Израиль пӑрты хӑтԓаԓ ванамәс, Иосиф пŏхәԓ вохсәԓы пӑ ԓўвеԓа йастәс: «Йӑм сэмән ма пеԓайэм ватԓән ки, йошен ма пещ иԓпема пŏныԓыйи пӑ йасәӈ мийа, нӑӈ мӑнэм щаԉәтԓэн пӑ ӑт ԓэпәԓԓэн, Египет мўвән мӑнэм ӑт лоттәԓэн, ");
INSERT INTO kca_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ащиԓам пиԓән мӑнэм ŏԓты урәӈән; Египет мўв эԓты мӑнэм тўви пӑ ԓыв ŏԓты хŏшапәӈ кевеԓән мӑнэм лотты». Иосиф йастәс: «Нӑӈ йасӈен щирән верԓэм». ");
INSERT INTO kca_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Пӑ йастәс: «Мӑнэма йасәӈ мийа». Иосиф йасәӈ ԓўвеԓа мӑс. Израиль пӑ ԓўв ŏԓттәхайәԓ ŏсмәԓән, ŏх пŏнман, иԓ ԋўрәс. ");
INSERT INTO kca_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Щи йўпийән Иосифа йастәса: «Щиты, нӑӈ ащен кӑшаӈ». Пӑ ԓўв Манассия пӑ Ефрем пŏхӈәԓаԓ пӑтән ўсԓы. ");
INSERT INTO kca_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Иакова айкеԓ верса пӑ йастәса: «Щиты, Иосиф пŏхен нӑӈ хŏщайэн йиԓ». Израиль хӑщәм йурԓаԓ ӑктәс пӑ ŏԓттӑхайәԓән нŏх опсәс. ");
INSERT INTO kca_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Иаков Иосиф пеԓа йастәс: «Иса Верәтты Турәм Луз вошән, Ханаан мўвән, ма хŏщайэм этәс пӑ йӑмән мӑнэм мӑсԓы, ");
INSERT INTO kca_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","пӑ мӑнэма йастәс: ‘Ма нӑӈен рутмӑԓтԓэм, ара верԓэм, ар мир нӑӈ эԓтэн питәԓ, пӑ тӑм мўв нӑӈ йўпенән нӑӈ тыхԓэна веккеша тӑйты мӑԓэм’. ");
INSERT INTO kca_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ин нӑӈ пŏхӈәԓан, ма йŏхәттэм йэԓпийән Египет мўвән сэма питәм пŏхӈәԓан, ԓын мӑнэӈәԓам; Ефрем пӑ Манассия, ԓын Рувим пӑ Симеон иты, мӑнэӈәԓам питԓәӈән; ");
INSERT INTO kca_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ԓын йўпанән сэма питты ԋаврэмԓән нӑӈиԓан питԓәт; ԓыв щӑха йайӈәԓән нэм хўват йайӈәԓән мўвәт эԓты мўвән ортԓайәт йэԓԓы тӑйты урәӈән. ");
INSERT INTO kca_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Месопотамия эԓты мӑнмемән, Ханаан мўвән, Ефрафа унты йэша ӑт йŏхәтмемән, Рахиль пӑрәс, ма ԓўвеԓ щита, Ефрафа пеԓа мӑнты йуш пўӈәԓән, лоттәсэм», Ефрафа щит ин Вифлеем. ");
INSERT INTO kca_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Щӑԓта Израиль Иосиф пŏхӈән кащаԓәс пӑ йастәс: «Щит хŏйӈән?» ");
INSERT INTO kca_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Иосиф ащеԓа йастәс: «Щит ма пŏхӈәԓам, Турәмән тӑта мӑнэм мийәм пŏхӈәԓам». Иаков йастәс: «Ма пўӈԓэма ԓынан тўваԓән, ма ԓынан йӑмән мӑԓԓам». ");
INSERT INTO kca_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Пирща йўвәм Израиль ики сэмԓаԓ нўшайа йисәт, йӑма ӑт нысайәт. Иосиф пŏхӈәԓаԓ ԓўв пўӈԓәԓа тусԓы, ԓўв ԓынан мосәԓтәсԓы пӑ ӑпәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Израиль Иосифа щиты йастәс: «Нӑӈ веншен шийаԓәты ӑт нумисысәм; ин пӑ Турәмән ԋаврэмԓан мӑнэм хŏԓна этәԓтәсайәт». ");
INSERT INTO kca_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Иосиф ԓынан ԓўв шаншŏхԓаԓ эԓты йэԓшәк тусԓы пӑ ԓўв йэԓпеԓән мўв унты, ŏх пŏнман, иԓ ԋўрәс. ");
INSERT INTO kca_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Щӑԓта Иосиф пŏхӈәԓаԓ кинтак ўсԓы, Ефремәԓ йӑм пеләк йошәԓа, Израиль пӑрта пеләк йош шŏма, Манассияйәԓ пӑ пӑрта пеләк йошәԓа, Израиль йӑм пеләк йош шŏма, пӑ ԓўв хŏщайәԓ вана тусԓы. ");
INSERT INTO kca_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Израиль пӑ йӑм пеләк йошәԓ Ефрем ŏха пŏтсәԓы, кўш щитәԓ айшәк ус, пӑрта пеләк йошәԓ пӑ Манассия ŏха пŏтсәԓы. Номәс тӑйман йошӈиԓаԓ щиты, пеләтман, пŏтсәԓы, кўш Манассия оԓәӈ пŏх ус. ");
INSERT INTO kca_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Щитәԓән Израиль Иосиф йӑмән мӑсԓы пӑ щиты йастәс: «Турәм, Хŏй йэԓпийән Авраам пӑ Исаак ащеӈәԓам устән, пӑ мӑнэм уԓтэм хўват тӑм хӑтәԓ унты шавийәм Турәм, ");
INSERT INTO kca_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","атәм вер эԓты мӑнэм нŏх пайтыԓыты ангел, тӑм энәмты пŏхӈән йӑмән ат мӑԓԓы; ԓын нэмԓән йастытыйән, ма нэмем пӑ, Авраам пӑ Исаак ащеӈәԓам нэмӈән, ищи ат нумәԓмиԓайәт, пӑ ԓын тыхәԓ тэԓԓән мўвән ара ат йиԓтән». ");
INSERT INTO kca_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Иосиф кащаԓәсԓы, ащеԓ йӑм пеләк йошәԓ Ефрем ŏха пŏнмаԓ; нŏпсәԓ щит эԓты шӑкәс. Ащеԓ йош ўсԓы пӑ Ефрем ŏх эԓты Манассия ŏха пŏнты ўтщисԓы, ");
INSERT INTO kca_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","пӑ ащеԓа йастәс: «Ӑнта, ащи, тӑта щи – оԓәӈ пŏхем; ԓўв ŏхәԓа йӑм пеләк йошен пŏны». ");
INSERT INTO kca_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ащеԓ пӑ ԓўв пиԓәԓән ӑт кашащәс пӑ йастәс: «Уйәтԓэм, пŏхийэ, уйәтԓэм; ԓўв эԓтэԓ ищи вŏԓаӈ мир тыйәԓ, туп апщеԓ ԓўв эԓтэԓ унашәк питәԓ, ԓўв эԓтэԓ ар мир тыйәԓ». ");
INSERT INTO kca_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Щи хӑтәԓ ԓынан йӑмән мӑсԓы, йастәман: «Нын нэмԓән хўват израиль йох хŏйатәта йасәӈән йӑм мӑты питԓәт, пŏтәрман: ‘Турәм Ефрем пӑ Манассия иты нӑӈена ат верәԓ’». Щиты Ефрем Манассия эԓты унашәк пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Щӑԓта Израиль Иосифа йастәс: «Щи, ма пӑрты хӑтԓэм йŏхтәс; Турәм нын пиԓанән питәԓ пӑ ащиԓән мўва нынан йŏхԓы туԓԓы; ");
INSERT INTO kca_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","амор йох эԓты аԓтты кешемән пӑ йухԓэмән ма йŏра шитәм мўвем нӑӈена мӑԓэм, щит йайԓан мўв эԓты аршәк, йайԓан кўтән уна уԓтэн урәӈән». ");
INSERT INTO kca_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Иаков пŏхԓаԓ вохсәԓы пӑ йастәс: «Йӑха ӑктәщаты, пӑ ма нынана йастәԓәм, мўй нын пиԓанән йэԓԓы уԓты хӑтԓәтән питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ӑктәщаты пӑ хуԓәнтаты, Иаков пŏхәт, Израиль ащан ики хуԓәнтаты. ");
INSERT INTO kca_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувим, оԓәӈ пŏхем! Нӑӈ – ма йурэм пӑ ма ху йурэм оԓәӈ ԋаврэмем, мет ԓӑтәӈ пӑ мет йурәӈ; ");
INSERT INTO kca_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","туп нӑӈ хўмпәт иты йэшащсән, – ащен ŏԓттӑхайа ŏԓсән, нӑӈ ма ŏԓттӑхайэм шӑкатсэн, щишән, мет уна нӑӈ ӑт питԓән. ");
INSERT INTO kca_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеон пӑ Левий, йайсакӈән, аԓтты кешиԓән пӑратты урәӈән тӑйԓәԓән; ");
INSERT INTO kca_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ԓын нŏмәсԓән хŏща ма вер ӑт тӑйԓәм, ԓын пиԓанән ӑт ӑктәщиԓәм, ԓын хŏйатәт ԉикащман веԓԓыстән пӑ каш урәӈән хор кўр ԓон эвтыԓыстән; ");
INSERT INTO kca_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ԓын ԉикән мўԓман ат уԓ, мŏрт тўмпи так урәӈән пӑ йэшащты щирән мўԓман ат уԓ, мŏрт тўмпи йурәӈ урәӈән; Иаков тыхәԓ тэԓ кўтән лакки йŏвәԓԓыԓам пӑ Израиль мўв ԓŏватән лакки рӑԋӈәԓԓыԓам. ");
INSERT INTO kca_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иуда! Йайԓанән нӑӈ ишәкты питԓайән. Вўракԓан нӑӈ эԓтэн пӑԓты питԓәт; ащен пŏхәт нӑӈ йэщаԓтэн, ŏх пŏнман, иԓ ԋўрԓәт. ");
INSERT INTO kca_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Иуда, нӑӈ энәмты лев вой, нӑӈ йӑм веԓпәс эԓты йŏхәтԓән, пŏхийэ. Лев ху вой иты пӑ лев нэ вой иты, ԓўв мўвән ŏԓтаԓән, хŏйән нŏх кўрәтты верәтԓа? ");
INSERT INTO kca_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Скипетр хон пос Иуда хŏща хӑщәԓ пӑ ԓўв хот тэԓәԓән хон катәԓты пос йэԓԓы тӑйты питԓа, Йӑмащты Ŏт йŏхәттаԓ унты, Хŏй йэщаԓт хŏԓ мирәт шаншŏхән ԓойты питԓәт. ");
INSERT INTO kca_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Виноград йўха осёл вой пŏшхәԓ ԓўв йӑрԓәԓы, виноград мет йӑм йўх хŏща осёл пŏшхәԓ ԓощәԓтәԓԓы; сŏхԓаԓ ўнайән пусԓәԓы пӑ ԓумтәмәԓ виноград ўрән ԉŏхәтԓәԓы. ");
INSERT INTO kca_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Сэмԓаԓ ўна иты вŏԉиԓәт пӑ пекԓаԓ мис йик иты нŏвет. ");
INSERT INTO kca_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулон щарәс питарән уԓты питәԓ пӑ ун хопәт ԓойты шитам лух йўкана питәԓ, Сидон унты ԓўв мўв сыԓәԓ йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Иссахар – йŏханӈән кўтән ŏԓты йурәӈ осёл вой; ");
INSERT INTO kca_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ԓўв кащаԓәсԓы, щўтщәты лотәԓ йӑм, мўвәԓ ԓӑтәӈ: ԓӑӈкәрԓаԓ ԓавәрт аԓтты урәӈән иԓ эсәԓсәԓы, пӑ мит сŏхәптәты урәӈән рупитты питәс. ");
INSERT INTO kca_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан, Израиль и тыхәԓ иты, ԓўв мирәԓ сўтәтты питԓәԓы; ");
INSERT INTO kca_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан ŏхты вой иты йушән ŏԓты питәԓ, атәм ŏхты вой иты йушән ԓавԓәсәԓ, ԓов кўрәԓ эԓты пŏрэмәтаԓән ԓов шӑшән омәсты хŏйат йŏхԓы рӑкәнәԓ. ");
INSERT INTO kca_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Нӑӈ ԋотпена нŏмәс пŏнԓәм, Турәм Куща! ");
INSERT INTO kca_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Гад ԓоԓмасты ŏтәтән иԉапты питԓа, ԓўв пӑ ԓывиԓаԓ каԓтәмԓаԓ хўват йŏхԓы ԋухәԓԓәԓы. ");
INSERT INTO kca_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Асир пӑ – ԋаԋәԓ мавәӈ питәԓ, хонәт ԓэты ԓэвпәсәт тутԓыты питәԓ. ");
INSERT INTO kca_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Неффалим – ун теревинф йўх, хŏрам нўвәт ԓўв энмәԓтәԓ. ");
INSERT INTO kca_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Иосиф – йӑм ԓыԓәӈ йўх нўв, йӑм ԓыԓәӈ йўх нўв йик пўӈәԓән; нўвԓаԓ пушас нўмпийән энәмԓәт; ");
INSERT INTO kca_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ԉаԉәсман ԓўв шукатыса, йухԓәӈ йохән ԋоԓән эсԓыса, ");
INSERT INTO kca_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ԓўв пӑ йухԓәԓ ищипа така хӑщәс, йошԓаԓ ищиты йурәӈәт, Иаков йурәӈ Турәм йошәт эԓты, Ԓыԓәт Шавиты Ŏт эԓты пӑ Израиль Так Вер эԓты, ");
INSERT INTO kca_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ащен Турәм эԓты, Хŏйән нӑӈ ат ԋотԓайән, Иса Верәтты Ŏт эԓты, Хŏйән нӑӈ йӑмән ат мӑԓайән нумәԓта турәм эԓты, иԓән ŏԓты пӑтыԓы тӑха эԓты, эсәм шўв пӑ утрәԓ эԓты; ");
INSERT INTO kca_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ащен йӑм йасӈәт эԓты, ԓыв катра Кевәт йӑм эԓты пӑ йис сӑхмәт йӑм эԓты ԓыв пӑԓшәкәт; Иосиф ŏх пӑтыйа ԓыв ат питԓәт, йайԓаԓ кўтән пирыйәм ŏт ŏх пӑтыйа ԓыв ат питԓәт. ");
INSERT INTO kca_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Вениамин, ԋэԓәӈ йэвәр, аԓәӈсӑхат веԓәм ŏтәԓ ԓэԓ пӑ йэтнайән мŏщатәм ŏтәԓ ортәԓ». ");
INSERT INTO kca_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Тӑм Израиль кӑтхŏщйаӈ сыр рут; щиты ԓывиԓаԓа ащеԓ ики йастәс; ԓывиԓаԓ йӑмән мӑсԓы, кашәӈ ŏтәԓ ԓўв йўкан йӑмән мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Щӑԓта Иаков ԓывиԓаԓа щиты партсәԓы, ԓывиԓаԓа щиты йастәс: «Ма ма мирэм хŏща мӑнԓәм; ащиԓам ŏԓты хŏшапәӈ кевән мӑнэм лоттаԓән, щит Ефрон хет ики мўв хӑр хŏща, ");
INSERT INTO kca_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Махпела мўв хӑр хŏща, Мамре шŏма Ханаан мўвән. Авраам Ефрон хет ики эԓты щи хŏшапәӈ кев лоттәты урәӈән мўв хӑр пиԓән ԓутәс. ");
INSERT INTO kca_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Щи хŏшапәӈ кевән Авраам Сарра имеԓ пиԓән лоттәман уԓԓайтән; щита Исаак Ревекка имеԓ пиԓән лоттәман уԓԓайтән; щита Лия имем ма лоттәсэм; ");
INSERT INTO kca_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","щи мўв хӑр хŏшапәӈ кевәԓ пиԓән хет йох эԓты ԓутса». ");
INSERT INTO kca_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Щитәԓән, пŏхԓаԓа партәм йасәӈԓаԓ Иаков вŏԓәтсәԓы, кўрԓаԓ ŏԓттӑхайа пŏтсәԓы, пӑ пӑрәс, пӑ опращԓаԓ хŏща мӑнәс. ");
INSERT INTO kca_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Иосиф ащеԓ эԓты рӑкнәс пӑ хоԓԓәс, пӑ ԓўвеԓ мосәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Щӑԓта Иосиф ԉэккар митйохԓаԓа ащеԓ бальзамән ԋŏсәтты партсәԓы; ԉэккарәт Израиль бальзамән ԋŏсәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ԋӑԓйаӈ хӑтәԓ хӑщәс, щи арат хӑтәԓ бальзамән пŏшәԓтәԓа, пӑ ԓапәтйаӈ хӑтәԓ Египет хŏйатәт ԓўв эԓтэԓ хоԓԓәсәт. ");
INSERT INTO kca_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Хоԓԓәп хӑтԓәт хӑщәмән, фараон ԓӑӈкәр хŏйатәт пеԓа Иосиф йастәс: «Йӑм сэмән ма пеԓайэм ватԓәты ки, тӑмиты фараона йастаты: ");
INSERT INTO kca_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ащем ма эԓтэм йасәӈ ўс, щиты пŏтәртәс: ‘Ма пӑрты хӑтԓэм ванамәс; Ханаан мўвән ма ԓэщатәм хŏшапәӈ кевемән мӑнэм шавийи’. Ин пӑ мӑнэм эсԓы йӑхты пӑ ащем лоттәты, пӑ щӑԓта йŏхԓы йŏхәтты». ");
INSERT INTO kca_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Фараон йастәс: «Йӑӈха пӑ ащен лотты, хŏты ԓўв нӑӈена партәс». ");
INSERT INTO kca_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Иосиф ащеԓ лоттәты мӑнәс. Ԓўв пиԓәԓән фараон хŏԓ ԓӑӈкәр йохԓаԓ мӑтсәт, ԓўв хотәԓ ун икет пӑ Египет мўв хŏԓ ун икет, ");
INSERT INTO kca_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","пӑ Иосиф хот тэԓ, пӑ йайԓаԓ, пӑ ащеԓ хот тэԓ. Туп ԋаврэмԓаԓ пӑ ай пӑ ун вой тащԓаԓ Гесем мўвән хӑйсыԓаԓ. ");
INSERT INTO kca_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ԓыв пиԓԓаԓән ԓовәӈ ухԓәт пӑ ԓов шӑнша ԓэԓәм хŏйатәт па мӑтсәт, щишән, мӑнәм ŏтэԓ ар ус. ");
INSERT INTO kca_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Щиты ԓыв Горен-гаатад унты Иордан йŏхан па пелка йŏхәтсәт пӑ щита шек так хоԓԓәп версәт; ԓапәт хӑтәԓ щита ащеԓ урәӈән Иосиф хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ханаан мўвән уԓты хŏйатәт щи хоԓԓәп Горен-гаатад хŏща ватсәт пӑ йастәсәт: «Египет мўв хŏйатәт хŏща ун шук пӑ хоԓԓәп!» Щишән, щи тӑха щиты нэмәтса: ‘Египет мўв хŏйатәт хоԓԓәп’, щит Иордан йŏхан па пеләкән уԓ. ");
INSERT INTO kca_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Щиты Иаков пŏхәт ԓўв партәм верәԓ версэԓ: ");
INSERT INTO kca_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ханаан мўва пŏхԓаԓән ԓўв туса пӑ Мамре шŏма Махпела мўв хӑр хŏща уԓты хŏшапәӈ кев ԓыпийән шависа. Щи хŏшапәӈ кев мўв хӑр пиԓән Авраам Ефрон хет ики эԓты лоттәты урәӈән ԓутәс. ");
INSERT INTO kca_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Щӑԓта ащеԓ лоттәмеԓ йўпийән Иосиф пӑ йайԓаԓ пӑ хŏԓ ԓўв пиԓәԓән ащеԓ лоттәты йӑӈхәм хŏйатәт Египта йŏхԓы йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ащеԓ пӑрәм йўпийән Иосиф йайԓаԓ йастәсәт: «Мосәӈ, Иосиф мўӈев ԉикән этԓәԓы пӑ ԓўвеԓ атәм вермев нўр йŏхԓы катәԓԓәԓы?» ");
INSERT INTO kca_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Пӑ ԓыв Иосифа айкеԓ китсәт: «Ащен пӑртаԓ йэԓпийән щиты йастәс: ");
INSERT INTO kca_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Иосифа тӑмиты йастаты: йайԓан нўрәт пӑ кӑрэкәт йŏрэмаԓән нӑӈена атәм вермеԓ урәӈән’. Пӑ ин ащен Турәм митйохԓаԓ нўрԓаԓ эсԓаԓән». Щит ԓўвеԓа пŏтәртәмән, Иосиф хоԓԓәс. ");
INSERT INTO kca_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Щӑԓта йайԓаԓ ищи йŏхәтсәт, пӑ ԓўв йэԓпеԓән мўв унты, ŏх пŏнман, иԓ ԋўрсәт, пӑ йастәсәт: «Мўӈ нӑӈена рупитты йохԓан». ");
INSERT INTO kca_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Иосиф йастәс: «Аԓ пӑԓаты, ма мўй Турәм хун? ");
INSERT INTO kca_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Йӑна щи, нын ма пеԓайэм атәм версәты; туп Турәм щит йӑма керәтсәԓы, ин тыйәԓтәм верәԓ урәӈән: ар хŏйат ԓыԓ шавиты урәӈән; ");
INSERT INTO kca_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","щишән, аԓ пӑԓаты: ма нынан, имиԓән пӑ нын ԋаврэмԓән ԓапәтԓыԓам». Пӑ ԓывиԓаԓ роммәԓтсәԓы, пӑ сӑмԓаԓ рӑхты щирән ԓыв пиԓԓаԓән пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Щиты Иосиф Египет мўвән ус пӑ ащеԓ хот тэԓ ищи ус; Иосиф уԓәм нуптәԓ сот йаӈ тӑԓ ус. ");
INSERT INTO kca_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ефрем хиԓэт ԋаврэмԓаԓ хŏԓна вантәс, Манассия Махир пŏхәԓ пŏхәт сэма питәмән Иосиф шанша ищиты пŏныԓысайәт. ");
INSERT INTO kca_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Щӑԓта Иосиф йайԓаԓа йастәс: «Ма пӑрты хӑтԓэм ванамәс, нын хŏщайән Турәм йŏхәтәԓ пӑ нынан тӑм мўв эԓты щи мўва туԓԓы, мўй эԓты Ԓўв Авраама, Исаака пӑ Иакова йасәӈ мӑс». ");
INSERT INTO kca_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Щӑԓта Иосиф Израиль пŏхәт эԓты так йасәӈ ўс, щиты пŏтәртман: «Турәм нын хŏщайән йŏхәтәԓ, пӑ ԓŏв шўкԓам тӑԓта тўваԓән». ");
INSERT INTO kca_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Иосиф нуптәԓ сот йаӈ тӑԓ аратән пӑрәс. Египет мўвән бальзамән ԓўв ԋŏсәтса пӑ кев эԓты верәм хӑԓа йўха пŏтса.");
INSERT INTO kca_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Иона, Амафий пŏх, пеԓа Турәм Куща йасәӈ ус: ");
INSERT INTO kca_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","«Нŏх ԓойа, Ниневияйа, ун воша, мӑна пӑ щита хŏйатәта такан пŏтәрта, ԓыв шек атәм верԓаԓ Ма уйәтты питсәԓам». ");
INSERT INTO kca_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Туп Иона нŏх ԓойәс пӑ Фарсис вош пеԓа Турәм Куща эԓты хӑԋемәты урәӈән, хŏнтас. Иоппия воша йŏхтәс, Фарсис пеԓа мӑнты паршәӈ ун хоп уйтәс, ŏх сŏхәптәс пӑ хопа ԓэԓәс, ԓыв пиԓэԓән Фарсис унты мӑнты, Турәм Куща эԓты шӑшән хŏнтаты урәӈән. ");
INSERT INTO kca_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Туп Турәм Куща щарәсән так вот этәԓтәс, вот шек тарма йис, паршәӈ хоп шўкаԓәты кема йис. ");
INSERT INTO kca_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Хопәӈ хŏйатәт пӑԓтамәсәт, пӑ кашәӈ хŏйат ԓўв турмәԓ пеԓа пойәкщәс, пӑ пŏрмасԓаԓ йиӈка йовәԓты питсәԓаԓ, хоп йэша кенашәк верты урәӈән; Иона пӑ хоп ԓыпийа, ŏхәԓмаԓ йўпийән, иԓ ŏԓәс пӑ такан вŏйәпса. ");
INSERT INTO kca_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ԓўв хŏщайәԓ хоп куща йŏхтәс пӑ ԓўв пеԓайәԓ йастәс: «Мўй нӑӈ ŏԓԓән? Нŏх ԓойа, турмен пеԓа пойәкща; мосәӈ пӑ ԓўв мўӈ эԓтэв нумәԓмәԓԓы пӑ мўӈ ӑт пӑрԓув». ");
INSERT INTO kca_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Хŏйатәт кўтԓаԓән йастәсәт: «Пос йўвәтԓув, ватԓэв, хŏй урәӈән мўӈ тӑмәщ шук туԓув». Пӑ пос йўвәтсәт, ин пос Иона пеԓа аԉәс. ");
INSERT INTO kca_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Щиӈәԋща ԓўвеԓа йастәсәт: «Мўӈева йаста, хŏй урәӈән мўӈ тӑмәщ шук туԓув? Мўй вер тӑйԓән пӑ хŏԓща нӑӈ йиԓән? Нӑӈ мўвен хŏта уԓ пӑ мӑты рут эԓты уԓԓән?» ");
INSERT INTO kca_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ԓўв йастәс: «Ма еврей, щарәс пӑ мўв опсәԓтәм Турәм Куща йэԓпийән шаншэм иԓ эсәԓԓэм». ");
INSERT INTO kca_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Щӑԓта хŏйатәт шек такан пӑԓтамәсәт пӑ ԓўвеԓа йастәсәт: «Мўй урәӈән нӑӈ щиты версэн?» Хŏйатәт ŏша пайәтсэԓ, Турәм Куща эԓты ԓўв хŏнтаԓ, хŏты ԓўв ԓывиԓаԓа йастәс. ");
INSERT INTO kca_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Щарәс йэшащты щирәԓ и тарма, и тарма йис, ԓыв йастәсәт: «А хŏты мўӈэва нӑӈен верты, щарәсән тэвна йиты урәӈәӈ». ");
INSERT INTO kca_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Щи йўпийән ԓўв щиты йŏхԓы йастәс: «Мӑнэм ўйаԓән пӑ щарса йўвтаԓән, щӑԓта щарәсән нын урӈәнән тэвна йиԓ, ма уйәтԓэм, ма ўрӈемән нын тӑм так вот шук ватԓәты». ");
INSERT INTO kca_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Туп щи хŏйатәт йуртат ԓовәԓты питсәт, мўв сыԓа хойты урәӈән пӑ ӑт верәтсәт, щарәс йэшащты щирәԓ мет тарма йис, щишән. ");
INSERT INTO kca_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Щиӈәԋща Турәм Куща пеԓа ўвман пойәкщәты питсәт пӑ йастәсәт: «Турәм Куща, тӑм хŏйат ԓыԓ урәӈән ӑт ат пӑрԓув, пӑ нӑрԓы ўр мўӈева аԓ пŏны; Нӑӈ, Турәм Куща, Нӑӈена хŏты рӑхәԓ, щиты версэн!» ");
INSERT INTO kca_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Иона ўсэԓ пӑ йиӈка йўвәтсэԓ, щӑԓта щарәсән тэвна йис. ");
INSERT INTO kca_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Щиӈәԋща щи хŏйатәт Турәм Куща эԓты шек пӑԓтамәсәт, пӑ Турәм Кущайа йир тусәт пӑ йастәпса мӑсәт. ");
INSERT INTO kca_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Турәм Куща ун веса Иона йŏхи ԓавемәты партсәԓы; Иона щи вес хŏн ԓыпийән хуԓәм хӑтәԓ пӑ хуԓәм ат ус. ");
INSERT INTO kca_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Иона Турәм Куща ԓўв Турмәԓ пеԓа вес хŏн ԓыпи эԓты пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Пӑ йастәс: «Шука ма питмем урәӈән Турам Куща пеԓа пойәкщәсәм, пӑ Ԓўв мӑнэм хуԓсәԓы; ма иԓта турәм эԓты уваԓсәм, пӑ Нӑӈ ма тўр сыйэм хуԓсэн. ");
INSERT INTO kca_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Нӑӈ мӑнэм мӑԓ йиӈка, щарәс сӑма, шуйԓәптәсэн, ма йикән лӑп ўсайәм, иса Нӑӈ йикԓан, Нӑӈ хўпԓан ма нўмпемән йӑӈхиԓысәт. ");
INSERT INTO kca_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Ма йастәсәм: Нӑӈ мӑнэм куш сэм сайа йэԓ воштәсэн, ма ищи пӑ Нӑӈ йэмәӈ хотэн шийаԓәԓэм. ");
INSERT INTO kca_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ԓыԓэм сŏхәнты унты ма йиӈкәтән ӑпәԓтсайәм, пӑтыԓы тӑхайа ма щи тухәрсайәм; щарәс лывәщән ŏхем лӑп йŏвәртса. ");
INSERT INTO kca_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Кев вŏш унты ма иԓ шуйԓәсәм, мўв ԓўв йэртэпԓаԓән мӑнэм веккеша лӑп петсәԓы; Нӑӈ пӑ, Турәм Куща, ма Турмем, ма ԓыԓэм иԓта турәм эԓты нŏх туԓэн. ");
INSERT INTO kca_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Хун ма ԓыԓэм сŏхәнты питәс, ма Турәм Куща эԓты нумәԓмәсәм, пӑ ма пойкем Нӑӈ хуԓсэн, Нӑӈ йэмәӈ хотэна пойкем йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Хŏй йурԓы пӑ нэмәԓтыйа ӑт рӑхты ŏтԓаԓ пеԓа пойәкщәԓәт, Йӑм Сӑмәӈ Ŏтэԓ хӑйԓәт. ");
INSERT INTO kca_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ма пӑ ишкаԋщәп арән Нӑӈен йирән туԓәм; мўй йастыԓысәм, верԓэм: Турәм Куща хŏща нŏх пайтәсты щир уԓ!» ");
INSERT INTO kca_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Турәм Куща ун веса партәс, пӑ ԓўв сорәм мўва Иона ким охтаԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Щӑԓта Турәм Куща кимет пўш Иона пеԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","«Нŏх ԓойа, Ниневия ун воша мӑна, щита хŏйатәта йасәӈ такан пŏтәрта, мўй Ма нӑӈен партсәм». ");
INSERT INTO kca_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Иона нŏх ԓойәс пӑ Турәм Куща йасәӈ хўват Ниневия воша мӑнәс; Ниневия хŏты Турәм ԓӑтәӈ ун вош, вош хўватәԓ хуԓәм хӑтәԓ шушты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Щӑԓта Иона вош хўват шушты питәс, ий хӑтәԓ мўй арат верәтәԓ мӑнты, ԓўв сыйәӈа пŏтәртәс, йастыман: «Хŏԓна ԋӑԓйаӈ хӑтәԓ - пӑ Ниневия вош шўкатԓа!» ");
INSERT INTO kca_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ниневия вошәӈ хŏйатәт Турма эвәԓсәт, вўщԓәты йасәӈ версәт, ԓӑтәӈ ŏтԓаԓ эԓты ԓӑтԓы ŏтԓаԓ унты уԓттӑхты хир хŏрпи сŏха ԓумәтԓысәт. ");
INSERT INTO kca_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Щи айкеԓ Ниневия хон унты йŏхтәс, ԓўв хон омәсты тӑхайәԓ эԓты нŏх ԓойәс, пӑ хон сŏхԓәԓ нŏх эхсәԓы, пӑ уԓттӑхты хир хŏрпи сŏх ԓумтәс, пӑ рат хыша опсәс. ");
INSERT INTO kca_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Хон Ниневия вошән йастәты партсәԓы: «Хон пӑ ԓўв ԓӑӈкәр йŏхԓаԓ партԓәт: хŏйатәт пӑ войәт – мисәт пӑ ошәт нэмәԓты ӑт ат ԓэԓәт, тŏрән энәмты тӑхайа ӑт ат йӑхԓәт, йик ӑт ат йищԓәт. ");
INSERT INTO kca_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Пӑ хŏйатәт пӑ войәт уԓттӑхты хир хŏрпи сŏхән пŏнман ат усәт, пӑ Турәм пеԓа такан ат пойәкщәсәт, кашәӈ хŏйат йŏвра йўшԓаԓ, атәм верԓаԓ эԓты шӑшән ат керԓәс. ");
INSERT INTO kca_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Хŏй уйәтәԓ, мосәӈ, Турәм мўӈев щаԉәтԓәԓы, Ԓўв тарәм ԉикәԓ мўӈ эԓтэв нŏх ўԓԓы, пӑ мўӈ ӑт пӑрԓув». ");
INSERT INTO kca_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Турәм ԓыв верԓаԓ шийаԓәсԓы, хŏты ԓыв атәм верԓаԓ эԓты шӑшән керԓәсәт. Турәм ԓывиԓаԓ щаԉитсәԓы, йэԓпи йастыԓыйәм шука пайәтты йасәӈԓаԓ йŏхԓы ўсԓы. Йастыԓыйәс ԓывиԓаԓа атәм верты, пӑ ӑт верәс. ");
INSERT INTO kca_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Иона щи вер урәӈән нŏпсәԓ шӑкәс пӑ ԉикащәс. ");
INSERT INTO kca_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Щӑԓта Турәм Куща пеԓа ԓўв пойәкщәс пӑ йастәс: «Турәм Куща! Щит эԓты щи ма пӑԓсәм, хун ма ма мўвемән хŏԓна усәм? Щи урәӈән Фарсис пеԓа ма хŏнтасәм, ма уйәтсэм, Нӑӈ, Турәм, йӑм сӑмәӈ, щаԉаӈ, арпуш умщәӈ, хўв ԓавԓәсты верәтԓән, шука пайәтты йасӈен китты ӑт кашащԓән. ");
INSERT INTO kca_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ин хŏты, Турәм Куща, ма ԓыԓэм ма эԓтэм ўйи, уԓтэм эԓты, хӑԓԓәм–ки йӑмшәк». ");
INSERT INTO kca_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Щӑԓта Турәм Куща йастәс: «Щит эԓты нӑӈ шек нŏпсэн шӑкәс?» ");
INSERT INTO kca_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Иона вош эԓты ким этәс, пӑ хутԓыты пеләк сӑхат вош пўӈәԓән пӑԓ нŏрәм хŏрпи ŏт верәс, ԓоӈԓа варәс нўвәт пŏнәс, щи иԓпийа сай тӑхайа опсәс, ваттыйа, вош хŏты йиԓ. ");
INSERT INTO kca_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Турәм Куща щиты верәс, ун лыптәӈ пухращ энмәԓтәс, Иона нўмпийән пӑԓа энмәс, ԓўв охәԓ сайән ат ус, Иона ԉикәԓ ат мӑнәс ԓуԓән; Иона щи ун лыптәӈ пухращ урәӈән нŏх амтәс. ");
INSERT INTO kca_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Турәм щиты верәс, кимет хӑтәԓән хутԓәты пŏрайән, ин ун лыптәӈ пухращ сŏв шупән шŏппи пŏрса пӑ ԓўв нŏх сорәс. ");
INSERT INTO kca_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Хун най этәс, Турәм рўвәӈ вот китәс, Иона ŏх найән щиты кўтәрԓыса пӑ ԓўв рэԋԓы питәс. Сŏрәм ԓўвеԓа вохәс пӑ йастәс: «Уԓтэм ушән, хӑԓԓәм–ки йӑмшәк». ");
INSERT INTO kca_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Турәм Иона пеԓа йастәс: «Нӑӈ мўй йӑна щи лыптәӈ пухращ урәӈән нŏпсэн шӑкәс?» Ԓўв йастәс: «Шек нŏпсэм шӑкәс, хӑԓты унты!» ");
INSERT INTO kca_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Щиӈәԋща Турәм Куща йастәс: «Нӑӈ лыптәӈ пухращ щаԉәтԓән, ԓўвеԓ ӑт энмәԓтысэн пӑ щи кеша ӑт рупитысән. Ԓўв и ат сыс энмиԓыйәс пӑ кимет ат сыс нŏх сорәс. ");
INSERT INTO kca_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ниневия мўй Мӑнэм щаԉәтты ӑт рӑхәԓ? Щит Вŏԓаӈ вош, хŏта сот хус щŏрәс мŏԓтас хŏйат йӑм пеләк йош пӑрта пеләк йош эԓты артаԓәтты ӑт верәтԓәт, пӑ ар вой уԓ.»");
INSERT INTO kca_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Хун ар хŏйат, мўӈ тŏрԓы уйтәм верԓув эԓты, хӑшты питәс, ");
INSERT INTO kca_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","хун мўӈева мет оԓәӈ вантәм хŏйатәтән щит айкеԓа туса пӑ щи йўпийән ԓыв йасәӈ туты хŏйатәта питсәт, ");
INSERT INTO kca_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ма пӑ щи вер эԓты нумәссәм, йӑмәс ԓэрапман, оԓӈәԓ эԓты ԓŏватәԓән йўпеԓ тўвман, нӑӈ урӈена йэшәк Феофил, щит нэпека хӑшты нŏмәс ўсәм, ");
INSERT INTO kca_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","йӑна уԓәм утәԓтәпса, хŏты утәԓтәсайән ԓуԓән нӑӈ йӑма ат мŏштәсэн. ");
INSERT INTO kca_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Иудея мўвән Ирод ики хона уԓәм пŏрайән, Захария нэмпи Авия пеләк эԓты Турма йир верты хŏйат ус; ԓўв итэԓән Елизавета ийимеԓ пӑ Аарон рут эԓты ус. ");
INSERT INTO kca_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ԓын кинәӈтак Турәм йэԓпийән тўӈа–щира усӈән, Турәм Куща партәпса йасӈәт пӑ мŏрт щира верәт сыстама версәӈән. ");
INSERT INTO kca_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Туп ԋаврэм ӑт тӑйсәӈән: Елизавета ӑт ԓавәртәмәԓа пӑ щиты щи ԓын пирщамәсайӈән. ");
INSERT INTO kca_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","И пўш, Захария хŏйатԓаԓ пиԓән ԓыв пŏрайэԓән, Турма йэмәӈ верәт верман, уԓмаԓән, ");
INSERT INTO kca_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ԓўвеԓа питәм пос xўват, xŏты уԓтыйән Турма йир верты xŏйатәт xŏща уԓԓыйәс, Турәм Куща Хот йэмәӈ йӑтәԓа ԓŏӈты пӑ щита йоԓ кўшмәԓтты вера йис. ");
INSERT INTO kca_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Мир, щи йоԓ кўшмәԓтты пŏрайән, Турма ким пеләк сӑхат пойәкщәсәт. ");
INSERT INTO kca_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Щи сыс Турәм Куща ангел Захария сэма этәс, йоԓ кўшмәԓтты йирасты нŏрәм ԉэпән йӑм пеләк сӑхат ԓойәс. ");
INSERT INTO kca_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Захария, Ԓўвеԓ кащаԓәмаԓ кемән, нŏпсәԓ ԓыԓэмәс, пӑ пӑԓщәмән йŏхәтса. ");
INSERT INTO kca_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ангел щиты йастәс ԓўвеԓа: \"Аԓ пӑԓа, Захария: нӑӈ пойкен хуԓса! Елизавета ийименән пŏхән туԓайән, пӑ нӑӈ ԓўвеԓ Иоанн нэмән пŏнԓэн; ");
INSERT INTO kca_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","нӑӈена амәт пӑ каш питәԓ, ар хŏйат, ԓўв сэма питмаԓ урәӈән, амтәтԓыты питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Турәм Куща хŏща ԓўв ԓӑтәӈа питәԓ, ўна пӑ па кўтрәӈ ŏт йищты ӑт питәԓ, пӑ хŏԓна аԋԏеԓ хŏща пӑтлам хотән уԓман Йэмәӈ Ԓыԓән тэкәнԓа, ");
INSERT INTO kca_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","пӑ ар хŏйат Израиль йох эԓты Турәм Куща пеԓа керәтԓәԓы; ");
INSERT INTO kca_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ԓўв Турәм Куща йэԓпийән, Илияйа мийԓыйәм хŏрпи ԓыԓ пӑ йур пиԓән мӑнты питәԓ, ащет сӑм ԋаврэмԓаԓа йŏхԓы мӑты урәӈән, ӑт хуԓәтты хŏйатәта тўӈа–щира уԓты нŏмәс мӑты урәӈән. Щиты Турәм Куща урәӈән хŏйатәт ԓэщатәԓ”. ");
INSERT INTO kca_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Захария ангела йастәс: \"Xŏты сӑхат ма щи вер уйәтԓэм? Ма пирщамәсайәм, имем пӑ тӑԓԓаԓ арамәсәт\". ");
INSERT INTO kca_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ангел йŏхԓы йастәс: \"Ма – Гавриил, Турәм пўӈәԓән ԓойты ангел, нӑӈ пиԓэнән пŏтәртты пӑ нӑӈена тӑм йӑм айкеԓ туты китсайәм. ");
INSERT INTO kca_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Мўйа нӑӈ ма йасәӈԓама ӑт эвәԓсән, ин нӑӈ мӑшйайән уԓты питԓән, пӑ хŏԓна щи унты пŏтәртты щир ӑт тӑйты питԓән, хун аԉәм верэм йŏхәтәԓ, мŏрт пŏрайән ԓыв тӑԓаӈа йиԓәт”. ");
INSERT INTO kca_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Щи сыс мир камән Захария ԓавәԓсәт пӑ нумәсты питсәт, мўйа ԓўв щиты Турәм Хотән рŏнащәԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ԓўв ким этмаԓән, нэмәԓты хŏйат пеԓа пŏтәртты ӑт веритәс. Хŏйатәтән ŏша пӑйәтса, ԓўв, иԓампа, Турәм Хотән мŏԓты йэм вантәс; щиӈәԋща ԓўв хŏйатәт пеԓа ԓўйән-паӈән аԉисыман пŏтәртәс, ўӈәԓԓы щиты щи ус. ");
INSERT INTO kca_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Туп хун ԓўв йэмәӈ верәт верты хӑтәԓԓаԓ йэтшәсәт, йŏхи йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Щи йўпийән Елизавета имеԓ ԓавәрта йис, пӑ вет тыԓәщ хŏйатәт эԓты хӑԋатыйәс пӑ пŏтәртыйәс: \"Турәм Куща тӑм хӑтԓәтән ма урӈема щи йӑм верәс, ма эԓтайэм хŏйатәт ԋухматты вер нŏх ўты урәӈән, ма пеԓайэм аԋкәрмәс\". ");
INSERT INTO kca_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Хун Елизавета xутмет тыԓәщ ўшән уԓмаԓән, Турәм Гавриил нэмпи ангел Галилея мўвән уԓты Назарет воша эви xŏща китсәԓы. Щи эви Иосиф xŏща уртыса, Иосиф Давид рут эԓты уԓ. Эви нэмәԓ: Мария. ");
INSERT INTO kca_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ангел ԓўв хŏщайәԓ ԓŏӈмаԓән, йастәс: \"Амтәтԓыйа, йӑм мŏщатәм нэ! Турәм Куща Нӑӈ пиԓэнән уԓ; имет кўтән йӑмән мийәм нэ!\" ");
INSERT INTO kca_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Мария ԓўвеԓ кащаԓәмаԓ кемән, щи йасәӈԓаԓ эԓты нŏпсәԓ ԓыԓэмәс пӑ нумәсәс: мўй тӑмәщ ўща верты щир. ");
INSERT INTO kca_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ангел пӑ ԓўвеԓа йастәс: \"Аԓ пӑԓа, Мария! Турәм нӑӈ пеԓайэн йӑм щирән ӑӈкәрмәс; ");
INSERT INTO kca_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ԓавәрта йиԓән пӑ Пŏх сэма пайәтԓән, Иисус нэмән Ԓўвеԓ пŏнԓэн. ");
INSERT INTO kca_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ԓўв ԓӑтәӈ питәԓ, пӑ Нўм Турәм Пŏха айәԓты питԓа; Турәм Куща Ԓўвеԓа Давид ащеԓ хон омәсты тӑха мӑԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Щӑԓта Ԓўв Иаков хот тэԓ хŏща веккеша хона уԓты питәԓ, пӑ Хон Уԓәпсайәԓ нэмәԓты пŏрайән ӑт йэтшәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Мария ангела йастәс: \"Xŏты сӑхат щиты питәԓ, ма xу сайән уԓты вер хŏԓна ӑт уйәтԓэм?\" ");
INSERT INTO kca_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ангел йŏхԓы йастәс: \"Йэмәӈ Ԓыԓ Нӑӈ хŏщайэн эсԓәщәԓ пӑ Нўм Турәм йурән йŏхәтԓайән, щишән сэма пайәтты йэмәӈ Ԋаврэмийэн Турәм Пŏха айәԓтты питԓа. ");
INSERT INTO kca_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ин Елизавета, xŏйатәтән таԓа айәԓтәм Нӑӈ рут нэӈен, кўш пирщамәса, ищи пŏх ԓавәԓәԓ: ин ԓўв хутмет тыԓщәԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Турәм и йасӈәԓ йурԓы ӑт уԓԓыйәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Мария йастәс: \"Щишән, ма Турәм Куща митнэ; нӑӈ йасӈен щира ма xŏщайэм щи вер ат тыйәԓ\". Щи йўпийән ангел ԓўвеԓ утща хӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Йэша ус, щи йўпийән Мария ԓэщатэмийәс пӑ сора Иуда кевәтән уԓты воша мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Захария хота ԓŏӈәс пӑ Елизавета пиԓән ўща верәс. ");
INSERT INTO kca_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Хун Елизавета Мария эԓты ўща йасәӈ хуԓмәс, сӑмәԓ иԓпийән тӑйты ԋаврэмәԓ ԋŏхԓыйәс. Щи кемән Елизавета Йэмәӈ Ԓыԓән тэкәтса, ");
INSERT INTO kca_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","пӑ ԓўв такан йастәс: \"Нӑӈ имет кўтән йӑмән мийәм нэ, сӑм иԓпенән тӑйты ŏтыйэн ищи йӑмән мийәм! ");
INSERT INTO kca_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Мўй щирән щит тыйәс? Ма хŏщайэма Турәм Кущайэм аԋԏи йŏхтәс! ");
INSERT INTO kca_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ванта-са: хун ма нӑӈ ўща верты сыйэн хуԓмәсәм, щи пŏрайән ԋаврэмем сӑмем иԓпийән амәтман ԋŏхԓыйәс. ");
INSERT INTO kca_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ин эвԓәм нэ щўԋԓән, Турәм Куща эԓты йастәм йасӈәт тӑԓаӈа йиԓәт, щишән\". ");
INSERT INTO kca_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Щӑԓта Мария йастәс: \"Ма сӑмем Турәм Куща ԓӑтәӈа айәԓԓәԓы, ");
INSERT INTO kca_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ма сӑмемән шек амтәтԓыԓәм Турмем урәӈән, ма ԓыԓэм Этәԓтәты Ŏтэм урәӈән, ");
INSERT INTO kca_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ԓўв митнэ лэӈкеԓ пеԓа сэмәԓ пайәтсәԓы, тӑԓта йэԓԓы ин омәсты мир, йӑԓпа йиты мŏхет мӑнэм щўԋән мийәм нэӈа айәԓты питԓэԓ; ");
INSERT INTO kca_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Йурәӈ Ŏт мӑнэм вŏԓаӈ верәт вермаԓ урәӈән, пӑ Ԓўв Нэмәԓ йэмәӈ, ");
INSERT INTO kca_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Турәм сӑмәӈ верәԓ кашәӈ Ԓўв эԓтайәԓ пӑԓты хŏйата, ин уԓты пӑ йӑԓпа йиты мŏхета, уԓты питәԓ; ");
INSERT INTO kca_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ԓўв йурәӈ йошәԓ этәԓтәсԓы; сӑмԓаԓән йŏрәӈ нŏмәс тӑйты хŏйатәт лакки йовәԓсәԓы; ");
INSERT INTO kca_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ун кущайәт кущайа омәсты тӑхайԓаԓ эԓты иԓ пайәтсәԓы, лэӈкийа уԓты хŏйатәт нŏх эԓәтсәԓы; ");
INSERT INTO kca_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ԓэԓԓы уԓты хŏйатәт йӑм эԓты ԓапәтсәԓы, тащәӈа уԓты хŏйатәт таԓты китсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ԓўв Израиль митхуйәԓа ԋотыԓыйәс, аԉәм сӑмәӈ щирәԓ нумман, ");
INSERT INTO kca_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","хŏты мўӈ опращԓува йастыԓыйәс, Авраама пӑ йиты ԋаврэмԓаԓа веккеша\". ");
INSERT INTO kca_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Мария Елизавета хŏща хуԓәм тыԓәщ кем мойԓәман ус, щӑԓта йŏхи мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Елизавета пŏрайәԓ йŏхтәс пӑ пŏх сэма пайтәс. ");
INSERT INTO kca_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ванән уԓты хŏйатәтән пӑ рутԓаԓән хуԓса, хŏты ԓўв урӈәԓән Турәм Куща ԓӑтәӈ сӑмәӈ вер аԉәс пӑ ԓўв пиԓәԓән амтәтԓысәт. ");
INSERT INTO kca_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Нийәԓмет хӑтәԓән ԓыв ԋаврэм хŏща эвәтты вер урәӈән йŏхәтсәт пӑ ащеԓ иты Захария нэма пŏнты ўтщисэԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Туп Елизавета йастәс: \"Ӑнта, Иоанн нэмән пŏнԓэв\". ");
INSERT INTO kca_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ăктәщәм хŏйатәт йастәсәт: \"Нӑӈ рутэн кўтән тӑмәщ нэм тӑйты и хŏйат нэш ӑнтом!\" ");
INSERT INTO kca_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ащеԓ эԓты ԓўйән-паӈән аԉиԓыман иԋщәсты питса, мўйсыр нэм ԓўв ԋаврэмәԓа мӑты ԓӑӈхас. ");
INSERT INTO kca_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Хӑшты сохәԓ вохәс пӑ хӑншәс: \"Ԓўв нэмәԓ Иоанн\". Ăктәщәм хŏйатәт йасәӈ ӑт шитԓәт, ӑԓ щи ватԓәт. ");
INSERT INTO kca_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Щи пўԉаӈ ԓўв ўӈԓәԓ-ԋаԓмәԓ пел пўншаԋщәс, пӑ Турәм ишәкман пŏтәртты питәс. ");
INSERT INTO kca_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Щиӈәԋща ԓывиԓаԓ керәтман уԓәм хŏйатәт пӑԓщәмән йŏхәтсайәт, пӑ ин щи вер эԓты кев пеләк Иудея мўв ԓŏватән пŏтәртты питса. ");
INSERT INTO kca_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Хŏйән айкеԓ хуԓса, хŏԓыйэ ԓыв сӑма пŏтсэԓ пӑ пŏтәртсәт: \"Xŏйа тӑм ԋаврэм йиԓ?\" Турәм Куща йош ԓўв пиԓәԓән ус. ");
INSERT INTO kca_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Щӑԓта Захария, Иоанн ащи, Йэмәӈ Ԓыԓән тэкәтса, Турәм эԓты хуԓәм йасәӈԓаԓ пŏтәртты питәс: ");
INSERT INTO kca_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","\"Турәм Куща - Израиль Турәм ат ишәкԓа, Ԓўв Израиль мирәԓ хŏща йŏхтәс пӑ хŏԓт пайтәсты щир мӑс, ");
INSERT INTO kca_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","пӑ мўӈева ԓыԓ этәԓтәты йурәӈ Ŏт Давид, митхуйәԓ, рут сӑхат мӑс, ");
INSERT INTO kca_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","хŏты йис тэԓән Турәм йасәӈ туты йэмәӈ xŏйатԓаԓ ўӈәԓән пŏтәртәс, ");
INSERT INTO kca_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","щит мўӈев веԓты ŏтԓув эԓты пӑ мўӈиԓув нўрыты ŏтԓув эԓты мўӈев нŏх пайәтԓәԓы, ");
INSERT INTO kca_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","мўӈ ащиԓув пиԓән сӑмәӈ верәԓ ватәԓтәԓ пӑ Ԓўв йэмәӈ йастантәм щирәԓ нумԓәԓы, ");
INSERT INTO kca_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ԓўв Авраама, ащева, мийԓыйәм йасӈәԓ нумԓәԓы, мўӈева, ");
INSERT INTO kca_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","мўӈ нўрәӈ ŏтԓув эԓты нŏх пайәттаԓ йўпийән, хурԓыйа Ԓўвеԓа ");
INSERT INTO kca_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","йэмәӈ пӑ вещкат щирән кашәӈ хӑтәԓ уԓәпсайэвән митйоxа уԓты вер мӑԓ. ");
INSERT INTO kca_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Нӑӈ ищи, ԋаврэмийэ, Нўм Турәм йасәӈ туты хŏйата нэмәтԓайән, Турәм Куща йэԓпийән мӑнты питԓән: Ԓўв кешайәԓа йуш ԓэщатты урәӈән, ");
INSERT INTO kca_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ԓўв мирәԓа щит ŏша пайәтты мӑты урәӈән: кӑрэкԓаԓ йŏрэмәты щир хŏща ԓыԓ этәԓтәты вер уԓ, ");
INSERT INTO kca_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Турмев йӑм сӑм хўватән, Ԓўв йӑԓпа этты хӑтәԓ иты, нумәԓта мўӈ хŏщайэва йŏхтәс, ");
INSERT INTO kca_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","пӑтламән пӑ хӑԓа хŏрән уԓты xŏйатәт нŏх хутԓәптәты урәӈән, мўӈ кўрԓув пайԓы уԓәпса йуш хўват мӑнәԓтты урәӈән.\" ");
INSERT INTO kca_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ԋаврэмийэ щи сыс энмәԓтыйәс пӑ ԓыԓәԓ-нŏпсәԓ такамтыйәс, таԓ шитам тӑхайәтән Израильәԓ хŏща эттаԓ унты ус. ");
INSERT INTO kca_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Щи хӑтԓәтән Август нэмпи кесарь ики йасәӈ китәс, Ԓўв мўвәԓ ԓŏватән уԓты хŏйатәт нэпека ат хӑшсайәт. ");
INSERT INTO kca_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Щит мет оԓәӈ хŏйат ԓӑт щирән хӑншәпса ус. Щи пŏрайән Сирия мўвән Квириний нэмпи куща ус. ");
INSERT INTO kca_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Нэпека пайтәсты кеша кашәӈ хŏйат ԓўв йŏра вошәԓа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Щи урәӈән Иосиф па Галилея мўвән омәсты Назарет вош эԓты, Иудея мўва Давид ики воша, Вифлеема, мӑнәс. Ԓўв Давид хот пӑ рут эԓты ус, ");
INSERT INTO kca_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ԓўв, нэпека питты урәӈән, Мария пиԓән мӑнәс. Мария ԓўвеԓа уртыса пӑ щи пŏрайән ԓавәртан ус. ");
INSERT INTO kca_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Щита уԓман сыс, ԋаврэмәԓ сэма питты пŏра йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Пŏхән, оԓәӈ Ԋаврэмәԓән, йŏхәтса, сŏха Ԓўвеԓ йŏвәртсәԓы пӑ вой ԓапәтты хŏшапа пŏтсәԓы, хŏйат хоԓты хотән ŏԓты тӑха ӑт мŏщатсәӈән. ");
INSERT INTO kca_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Щи ԉэпән, мўв хӑрән вой тащ шавиты икет ат ԓавәԓман усәт. ");
INSERT INTO kca_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Турәм Куща ангел ԓыв йэщаԓтэԓ этмәс пӑ Турәм Куща йэмәӈ нŏвийән ԓыв нŏх xутԓәптысайәт; ԓыв шек пӑԓтамәсәт. ");
INSERT INTO kca_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Туп ангел ԓывиԓаԓа йастәс: \"Аԓ пӑԓаты! Ма нынана амтәтԓыты ун айкеԓ туԓәм, щи амәт иса тӑм мўв хŏйатәта уԓты питәԓ: ");
INSERT INTO kca_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","тӑм ат Давид вошән нынан Ԓыԓ Этәԓтәты Ŏт – Христос, Турәм Куща сэма питәс; ");
INSERT INTO kca_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","тӑта щи нынана пос: вой ԓапәтты хŏшапән йŏвәртәм Ԋаврэмийэ уйәтԓәты\". ");
INSERT INTO kca_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","И щишән ангел пиԓән аратәԓ турәм ԉаԉ йоx йŏхәтсәт, Турәм ишәкԓәт пӑ такан йастәԓәт: ");
INSERT INTO kca_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","\"Турма нумән ишәк йасәӈ! Пӑ мўвән пайԓы уԓәпса, хŏйатәт xŏща йӑм!\" ");
INSERT INTO kca_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ангеләт турма нŏх мӑнмеԓ йўпийән, вой шавиты йох кўтԓаԓән пŏтәртты питсәт: \"Вифлеем воша мӑнԓув пӑ ватԓэв, мўй щита тыйәс, мўй эԓты Турәм Куща мўӈев йастәс\". ");
INSERT INTO kca_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ԓыв мŏхты йуша йэтшәптәсәт, йŏхәтсәт, Мария пӑ Иосиф, пӑ вой ԓапәтты хŏшапән йŏвәртәм Ай Ԋаврэмийэ уйәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ԓывиԓаԓ кащаԓәмеԓ кемән, вой шавиты йох Тӑм Ԋаврэмийэ эԓты мўй хуԓсәт, щит иса пŏтәртсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Хуԓәнтәм мŏхет хŏԓыйэ тащ шавиты йох йасәӈ эԓты пакнысыԓәт. ");
INSERT INTO kca_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Мария щи йасӈәт хŏԓыйэ сӑмәԓән шависԓы пӑ нумәссәԓы. ");
INSERT INTO kca_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Тащ шавиты икет йŏхԓы йŏхәтсәт, Турәм вŏԓаӈа айәԓтман пӑ ишәкман, мўй хуԓсәт пӑ ватсәт, щит иса ԓывиԓаԓа йастәман ус, щи урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Нийәԓмет хӑтәԓән Ԋаврэма эвәтты вер верты пŏра йŏхтәс, пӑ щита Иисус нэмән пŏтса – щи нэмән, Ԓўв, аԋԏеԓ хŏща пӑтлам хота питтаԓ йэԓпийән, ангелән нэмәтса. ");
INSERT INTO kca_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Хун Моисей Закон хўват сыстамтыты хӑтәԓ йŏхтәс, ԓын Ԋаврэмән Иерусалим воша тусԓән, Турәм Кущайа ватәԓтәты урәӈән, ");
INSERT INTO kca_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Турәм Куща законән хӑшман уԓԓа: \"Кашәӈ оԓәӈ сэма питәм ху ԋаврэм Турәм Кущайа аԉты мосәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Пӑ ищи пўԉаӈ Турәм Куща закон хўват йир туты мосәԓ: кӑт горлица нэмпи тŏхԓәӈ войӈән, мўй пӑ голубь нэмпи тŏхԓәӈ кӑт пŏшәхӈән. ");
INSERT INTO kca_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Щи пŏрайән Иерусалим вошән Симеон нэмпи хŏйат ус, ԓўв вещкат па тўӈа–щира xŏйат ус, Израиль мир нŏх пойәкты щир ԓавԓәс; Йэмәӈ Ԓыԓ ԓўв пиԓәԓән ус. ");
INSERT INTO kca_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Йэмәӈ Ԓыԓән ԓўв аԉса, Турәм Куща китәм Христос шийаԓәтаԓ унты, ԓўв ӑт пӑрәԓ. ");
INSERT INTO kca_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Йэмәӈ Ԓыԓән тўвман, Симеон Турәм Хота йŏхтәс, хун Иисус Ԋаврэмийэ аԋԏеԓән-ащеԓән, закон хўват мосты верәт верты урәӈән, тŏхи туса, ");
INSERT INTO kca_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Симеон Ԓўвеԓ йоша ўсԓы, Турәм ишәксәԓы пӑ пŏтәртты питәс: ");
INSERT INTO kca_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","\"Вос Xу! Нӑӈ йасӈен хўватән, ин Нӑӈ митхуйэн йӑм нŏмәсән эсәԓԓэн, ");
INSERT INTO kca_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Нӑӈ мойԓәм ԓыԓ этәԓтәты верэн сэмԓамән шийаԓәсэм, ");
INSERT INTO kca_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","щит Нӑӈ иса уԓты омәсты мир кеша, ");
INSERT INTO kca_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","пўншантәм нŏви Турәм ӑт уйәтты па рут мира пӑ ишәк йасәӈ Израиль мирэна ԓэщатсэн!\" ");
INSERT INTO kca_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Иосиф пӑ Иисус аԋԏеԓ Ԓўв эԓтэԓ йасәӈ хуԓтанән туп ӑԓ пакнысыстән. ");
INSERT INTO kca_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Симеон ԓыв урәӈԓаԓа йӑм воxәс, щӑԓта Мария, Иисус аԋԏи пеԓа, йастәс: \"Тӑм ŏԓәԓ, Щит, Хŏй тӑxрэпа китса: Израильән хŏйтат иԓ питԓәт, хŏйтат пӑ нŏх ԓойԓәт, Турәм эԓты китәм поса уԓ, йасәӈԓаԓ урәӈән хŏйатәтән нўрыԓа, – ");
INSERT INTO kca_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Нӑӈ па щитән, аԓтты кеши иты, сӑмен мŏхты мӑнԓайән, – ар хŏйат сӑм хŏща уԓты хӑԋа нŏмәсԓаԓ эԓпа ат этәԓтәԓайәт\". ");
INSERT INTO kca_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Хŏԓна щита Турәм йасәӈ туты ими, Анна, ус. Ԓўв Фануил эви, пирща йўвәм ими, Асир рут эԓты ус, икеԓ пиԓән ԓапәт тӑԓ уԓмаԓ, ");
INSERT INTO kca_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","икиԓы хӑщәс, пӑ нийәԉйаӈ ԋӑԓ тӑԓа йис. Анна Турәм Хот эԓты пўӈԓа ӑт йӑӈхиԓыйәԓ, Турма ата-хӑтԓа пойәкщәман пӑ вўщԓәман ус. ");
INSERT INTO kca_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Щи пўԉаӈ ԓыв хŏщайэԓа ԓўв, вана шушман, Турәм Куща ишәкԓәԓы пӑ кашәӈ хŏйата щи Ԋаврэмийэ эԓты пŏтәртыйәс, хŏй Иерусалимән xŏԓт пайтәсты щир ԓавԓәс. ");
INSERT INTO kca_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Хун Иосиф пӑ Мария верәт иса версәԓән, Турәм Куща закон xўват, ԓыв Галилея мўва, Назарет вошеԓа йŏхԓы йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ԋаврэмийэ пӑ энмәԓтыйәс, ԓыԓәԓ-нŏпсәԓ такамтыйәс, мўтрайән тэкнәптыман, Турәм йӑм Ԓўв эԓтэԓ ус. ");
INSERT INTO kca_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Кашәӈ тӑԓ Иисус аԋԏеԓ-ащеԓ Пасха йэмәӈ хӑтԓәт урәӈән Иерусалим воша йӑӈхиԓыстән. ");
INSERT INTO kca_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Хун Ԓўв кӑтхŏщйаӈ тӑԓа йис, ищиты, xŏты уԓԓытыйән, ԓыв Иерусалима йэмәӈ хӑтԓа мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Хун йэмәӈ хӑтԓәт мӑнәм йўпийән йŏхи мӑтсәӈән, Иисус Пŏхийэ Иерусалим вошән хӑщәс; щит Иосиф пӑ Иисус аԋԏеԓ, ӑт мŏштәсԓән, ");
INSERT INTO kca_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ԓын нумәссәӈән, Ԓўв па мŏхет пиԓән йиԓ. Оԓәӈ хӑтәԓ йуш xўват шушманән, хӑтәԓ xўват рутԓаԓ пӑ уйәтты йŏхԓаԓ кўтән Ԓўвеԓ кӑшсәԓән. ");
INSERT INTO kca_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Иисус ӑт уйәтсәԓән, Ԓўвеԓ кӑшман, Иерусалима йŏхԓы йŏхәтсәӈән. ");
INSERT INTO kca_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Хуԓәм хӑтәԓ xӑщәм йўпийән Ԓўвеԓ Турәм Хотән уйәтсәԓән, утәԓтәты йохәт кўтән ԓывиԓаԓ хуԓәтман пӑ ԓыв эԓтыԓаԓ иԋщәсман опсәс; ");
INSERT INTO kca_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","хŏԓыйэ Ԓўвеԓ хуԓәнтәм хŏйатәт йасәӈ ӑт шитԓәт, Ԓўв пеԓайәԓ ӑԓ ватԓәт пӑ хуԓәтԓәт, xŏты Ԓўв йŏxԓы ŏшәӈа–нŏпсәӈа йастәԓ. ");
INSERT INTO kca_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Аԋԏеԓ-ащеԓ Ԓўвеԓ шийаԓәман кемән, йасәӈ йастәты ӑт верәтсәӈән, туп аԋԏеԓ Ԓўвеԓа йастәс: \"Пŏхийэ, минэмән хŏты Нӑӈ версэн? Тӑм мўй, ащен пӑ ма, сӑм мӑнман, Нӑӈен кӑшԓэмән.\" ");
INSERT INTO kca_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Иисус йастәс: \"Мўйа нын Мӑнэм кӑшԓәԓән? Нын мўй ӑт уйәтсәԓән, Мӑнэм щита уԓты мосәԓ, хŏта Ма Ащэм Xот уԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Туп Ԓўв йастәм йасәӈԓаԓ ԓын ӑт мŏштәсԓән. ");
INSERT INTO kca_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Щиты Ԓўв аԋԏеԓ-ащеԓ пиԓән Назарет воша йŏхԓы йŏхтәс; пӑ ԓынана хуԓәтман ус. Щи йастәм йасәӈԓаԓ xŏԓыйэ аԋтеԓән сӑмән шависайәт. ");
INSERT INTO kca_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Иисус пӑ нуптәԓ хўвашәк йис, ŏшәӈа-щащәӈа йис. Ԓўв Турәмән пӑ хŏйатәтән сӑма мосман тӑйса. ");
INSERT INTO kca_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Тиверий кесарьа уԓәм ветхŏщйаӈмет тӑԓән, хун Понтий Пилат Иудея мўв ԓŏватән кущайа уԓмаԓән, Ирод ики пӑ Галилея мўвән, ԓўв Филипп йайәԓ Итурея, Трахонитида мўвән, Лисаний ики Авилиней мўвән, ԋӑԓмет мўв щуӈ кущайәта уԓмеԓән, ");
INSERT INTO kca_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Турма йир верты хŏйатәт ŏх икеӈән Анна пӑ Каиаф уԓәм пŏрайән Иоанна, Захария пŏха, хӑр пӑ таԓ мўвән Турәм айкеԓ йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Щи йўпийән ԓўв Иордан йŏxан ԉэпән уԓты мўв ԓŏватән йӑӈхәс пӑ щи вер эԓты сыйәӈа пŏтәртәс: йиӈка ԓŏӈәԓтыты вер верты урәӈән, кӑрэк эԓты шӑшән керԓәты мосәԓ, щиты Турәмән кӑрэк йŏрэмәԓа. ");
INSERT INTO kca_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Xŏты Турәм йасәӈ туты ики Исаия йасӈәӈ нэпекән хӑшман уԓԓа: \"Таԓ мўвән такан ўвты xу тўр сый: Турәм Кущайа йуш ԓэщататы, йуш хурийэт Ԓўв урӈәԓа тўӈа вераԓән! ");
INSERT INTO kca_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Кашәӈ мўв лот тэԓәӈа ат йиԓ, кашәӈ кев пай, кашәӈ сӑӈхәм ԓэԓа ат йиԓәт. Мўвеӈ йушәт тўӈа ат йиԓәт, хŏмалэӈ йушәт пайԓы ат йиԓәт; ");
INSERT INTO kca_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","пӑ кашәӈ хŏйат Турәм ԓыԓ этәԓтәты щир шийаԓәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Иоанн, ԓўв эԓтайәԓ йиӈка ԓŏӈәԓтыты урәӈән йŏхтыԓыйәм ар хŏйата щиты пŏтәртәс: ”Ŏхты вой эԓты тыйәм ŏтәт! Хŏйән нын нŏмәсән мӑсайты, йиты ԉик эԓты хŏнтаты? ");
INSERT INTO kca_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Кӑрэк эԓты шӑшән керԓәм щирән йӑм верԓәнән аԉаԓән, xŏты йўx йӑм ԓэвпәс энмәԓтԓәԓ. Аԓ тӑйаты тӑмәщ нŏмәс, йастыман: \"Мўӈ ащев – Авраам!\" Нынана йастәԓәм, Турәм тӑм кев шўкәт эԓты Авраама ԋаврэмәт верты верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Тӑм мўй, йўх ԓэрәт пўӈәԓән ԓайәм пŏнман уԓ, йӑм ԓэвпәс ӑт энмәԓтты йўх иԓ сэвәрԓа пӑ тўта вŏщкәԓа\". ");
INSERT INTO kca_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Мир иԋщәсәс: \"Мўй щиӈәԋща мўӈева верты?\" ");
INSERT INTO kca_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ԓўв щиты йŏхԓы йастәс: \"Xŏй кӑт йэрнас тӑйәԓ ки, и йэрнасәԓ ӑт тӑйты хŏйата ат мӑԓԓы, хŏй ԓэтәт тӑйәԓ ки, ищиты ат верәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Налог ӑкәтты йохәт ԓўв хŏщайәԓа йиӈка ԓŏӈәԓтыты урәӈән йŏхәтсәт, ԓўв эԓтэԓ иԋщәссәт: \"Утәԓтәты ху, мўӈева мўй верты?\" ");
INSERT INTO kca_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Иоанн ԓывиԓаԓа йастәс: \"Xŏйатәт эԓты мŏрт тўмпи ар аԓ вохаты\". ");
INSERT INTO kca_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Соԓтан йох ищи иԋщәссәт: \"Мўӈева пӑ мўй верты?\" Пӑ ԓывиԓаԓа йастәс: \"Нэмәԓты хŏйат ŏх урәӈән аԓ шукататы, ԋаԓәм аԓ вераты, пӑ тыԓәщ ŏхԓәнән тӑрматыйаты\". ");
INSERT INTO kca_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Хун хŏйатәт ԓавԓәсман усәт, пӑ хŏԓыйэ Иоанн эԓты нумәссәт, ԓўв а мўй Христос, - ");
INSERT INTO kca_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Иоанн ԓывиԓаԓа йастәс: \"Ма нынан йиӈка ԓŏӈәԓтыԓԓам, туп ма киԋщайэм Йурәӈ Ŏт йŏxәтәԓ. Мӑнэм хŏԓна Ԓўв кўр ԓумтәм пушәх кеԓәԓ нŏх эхты йэм, ӑт рӑхәԓ; Ԓўв нынан Йэмәӈ Ԓыԓа пӑ тўта ԓŏнәԓтты питԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ԓўв сӑрәԓ йошәԓән уԓ, ԓат сэм ӑктәм тӑxайәԓ сыстапԓәԓы, ԓат сэмәт ампарәԓа ӑкәтԓәԓы, сорәм тŏрнәт пӑ ӑт xурԓәты тўтән нŏх ўщәтԓәԓы\". ");
INSERT INTO kca_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Иоанн Йӑм айкеԓ эԓты пŏтәртмаԓән, ар па хŏрпи щирән хŏйатәт утәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ԓўв Ирод, ԋӑԓмет мўв щуӈ куща ики, йайәԓ ими, Иродиада, нэӈа тўвмаԓ урәӈән пӑ па атәм верәт вермаԓ урәӈән, нўрыты питсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ирод ики щиӈәԋща, верәм атәмԓаԓ хŏща и вер па пŏнәс, Иоанн касна хота омәссәԓы. ");
INSERT INTO kca_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Хун хŏйатәт иса Иоаннән йиӈка ԓŏӈәԓтысайәт, Иисус ищи йиӈка ԓŏӈәԓтыса, йиӈка ԓŏӈәԓтыйәм йўпийән пойәкщәман ус: турәм хӑр пелки лоӈхиԓәс, ");
INSERT INTO kca_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Йэмәӈ Ԓыԓ, голубь вой хŏрпийән, Ԓўв хŏщайәԓ иԓ эсԓәщәс, пӑ турәм эԓты тўр сый щащәс: \"Нӑӈ – Ма Сӑмема Мосты Пŏхем, Ма йӑм кашэм Нӑӈ хŏщайэнән уԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Иисус верәт верты питмаԓән хŏԉмаӈ тӑԓ кема йўвман ус; хŏйатәт нумәссәт Ԓўв Иосиф пŏх, щишән опращԓаԓ - Илий, ");
INSERT INTO kca_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Матфат, Левий, Мелхий, Ианнай, Иосиф, ");
INSERT INTO kca_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Маттафий, Амос, Наум, Еслим, Наггей, ");
INSERT INTO kca_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Мааф, Маттафий, Семеи, Иосиф, Иуда, ");
INSERT INTO kca_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Иоаннан, Рисай, Зоровавель, Салафиил, Нирий, ");
INSERT INTO kca_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Мелхий, Аддий, Косам, Елмодам, Ир, ");
INSERT INTO kca_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Иосий, Елиезер, Иорим, Матфат, Левий, ");
INSERT INTO kca_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Симеон, Иуда, Иосиф, Ионан, Елиаким, ");
INSERT INTO kca_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Мелеай, Маинан, Маттафай, Нафан, Давид, ");
INSERT INTO kca_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Иессей, Овид, Вооз, Салмон, Наассон, ");
INSERT INTO kca_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Аминадав, Арам, Есром, Фарес, Иуда, ");
INSERT INTO kca_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Иаков, Исаак, Авраам, Фара, Нахор, ");
INSERT INTO kca_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Серух, Рагав, Фалек, Евер, Сала, ");
INSERT INTO kca_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Каинан, Арфаксад, Сим, Ной, Ламех, ");
INSERT INTO kca_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Мафусал, Енох, Иаред, Малелеил, Каинан, ");
INSERT INTO kca_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Енос, Сиф, Адам, Турәм. ");
INSERT INTO kca_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Иисус, Йэмәӈ Ԓыԓән тэкәнман, Иордан йŏхан эԓты йŏхԓы мӑнәс, пӑ щи Ԓыԓән хӑр пӑ таԓ мўва тўвман уса. ");
INSERT INTO kca_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Щита Ԓўв ԋӑԓйаӈ хӑтәԓ хиԋән хўщман уса пӑ щи хӑтԓәтән Иисус нэмәԓты ӑт ԓэс, щи хӑтԓәт мӑнәм йўпийән, мет йўхәт Ԓўв ԓэты ԓӑӈхаты питса. ");
INSERT INTO kca_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Хиԋ Ԓўвеԓа йастәс: \"Нӑӈ – Турәм Пŏх ки, тӑм кев шуп, ԋаԋа йитыйа парты\". ");
INSERT INTO kca_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Иисус йŏхԓы йастәс: \"Йэмәӈ Нэпекән xӑшман уԓԓа: ”Ӑнта туп ԋаԋ йурән хŏйат уԓты питәԓ, пӑ кашәӈ Турәм йасәӈ йурән”\". ");
INSERT INTO kca_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Щӑԓта Ԓўв хиԋән пӑԓ кев ԓŏӈԓа нŏх туса пӑ щиԓта ищи кумат хŏԓыйэ мўв ԓŏватән уԓты хон мўвәт аԉиԓысԓы, ");
INSERT INTO kca_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","хиԋ ики пӑ йастәс: \"Нӑӈен тӑм хон мўвәт хŏща кущайа уԓты пŏнԓэм, пӑ ԓыв вŏсԓәты–вŏрԓәты щирэԓ Нӑӈен мӑԓэм, щит иса мӑнэма мӑса, пӑ ма, хŏйа ԓӑӈхаԓәм, щита мӑԓэм. ");
INSERT INTO kca_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Нӑӈ ма йэԓпемән шаншен иԓ эсәԓԓэн ки, тӑм иса Нӑӈен мӑԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Туп Иисус йŏхԓы йастәс: \"Сатана, Ма эԓтайэм пўӈԓа мӑна; Йэмәӈ Нэпекән xӑшман уԓԓа: ”Турәм Кущайэн йэԓпийән туп шаншен иԓ эсԓы, Ԓўвеԓа туп митхуйа уԓа”\". ");
INSERT INTO kca_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Щӑԓта Иисус сатанайән Иерусалим воша туса, Турәм Хот ԓоӈәԓ йира ԓощәԓтәса, пӑ йастәса: \"Нӑӈ Турәм Пŏх ки, тӑԓта иԓ керәптыйа, ");
INSERT INTO kca_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","хӑшман ӑт уԓ: “Ԓўв ангелԓаԓа Нӑӈен шавиты партԓәԓы”, ");
INSERT INTO kca_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","пӑ “Нӑӈен нŏх аԓәмман туԓэԓ, Нӑӈ кўрэн кева аԓт вакләпәԓ”\". ");
INSERT INTO kca_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Иисус йŏхԓы йастәс: \"Йастәман уԓ: ”Турәм Кущайэн, Турмен аԓ хўщи”\". ");
INSERT INTO kca_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Хун хиԋ ики хўщәпсайԓаԓ вŏԓәтсәԓԓы, Ԓўв эԓтайәԓ мӑтты пŏра унты шӑшән мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Иисус, Йэмәӈ Ԓыԓ йурән тэкәнман, Галилея мўва йŏхԓы йŏхтәс. Ԓўв айкеԓәԓ Галилея мўв керәтман лакки ԓӑрпиԓәс. ");
INSERT INTO kca_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ԓўв Турәм йасӈа утәԓтәты хотԓаԓән ԓывиԓаԓ утәԓтәс, пӑ хŏԓыйэ Ԓўвеԓ ишәксэԓ. ");
INSERT INTO kca_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Иисус Назарета, энмәм вошәԓа, йŏхтәс, пӑ шаббат хӑтәԓән, Ԓўв уԓтаԓ иты, Турәм йасӈа утәԓтәты хота ԓŏӈәс, пӑ щита Йэмәӈ Нэпек эԓты сыйәӈа ԓуӈәтты ԓойәс. ");
INSERT INTO kca_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ԓўвеԓа Исаия, Турәм йасәӈ туты ху, нэпек мӑса: Ԓўв нэпек нŏх ԓӑрпитмаԓ йўпийән, щи тӑха уйәтсәԓы, хŏта хӑшман уса: ");
INSERT INTO kca_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"Турәм Куща Ԓыԓ Ма хŏщайэм уԓ; Ԓўв Мӑнэм, куԋарәта Йӑм айкеԓ йастәты урәӈән, ԋŏсәтсәԓы, пӑ Мӑнэм, сӑмԓаԓ рӑкнәм хŏйатәт тўмтака верты урәӈән, китсәԓы, ԋӑрэмәм хŏйатәта хŏԓт сŏхәнты вер пӑ сэмԓы хŏйатәта – сэмәӈа йиты вер аԉты китсәԓы, шукатты хŏйатәт хŏԓт эсәԓты китсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Турәм Куща йӑм ŏт тӑԓ-ԓўӈ йŏхтәм такан айәԓтты китсәԓы\". ");
INSERT INTO kca_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Иисус, нэпек лӑп йŏвәртман, ԋотты хŏйата мӑсԓы пӑ иԓ опсәс. Турәм йасӈа утәԓтәты хот тэԓ хŏйат хŏԓ Ԓўв пеԓайәԓ тŏрԓы ватԓәт. ");
INSERT INTO kca_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Щӑԓта Ԓўв ԓыв пеԓайэԓ пŏтәртты питәс: \"Тӑмхӑтәԓ, нын хуԓәм тӑм Йэмәӈ Нэпек йасӈәт, йӑнәпсәт\". ");
INSERT INTO kca_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Хŏԓыйэ ԓыв кўтэԓән Ԓўвеԓ ишәксэԓ, пӑ Ԓўв эԓтэԓ этты сӑма рӑхты йасәӈԓаԓ эԓты ощатыԓәт, пӑ пŏтәрԓәт: \"Тӑм мўй ӑнта Иосиф пŏх?\" ");
INSERT INTO kca_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Иисус ԓывиԓаԓа йастәс: \"Нын, уйәтман, Мӑнэма щимәщ йасәӈ йастәԓты: ”Ԉэккар, Нӑӈен Нӑӈ йӑмәԓты!”, хŏԓна: ”Тӑта Нӑӈ вошенән па щит вера, мўй, мўӈ хуԓмевән, Капернаум вошән версән”\". ");
INSERT INTO kca_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Щӑԓта йастәс: \"Йӑна нынана йастәԓәм: Турәм йасәӈ туты и ху нэш энмәм мўвәԓән вана ӑт уԓа. ");
INSERT INTO kca_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Вещката нынана пŏтәртԓәм: Илия Турәм йасәӈ туты ху уԓмаԓән, Израиль мўвән ар икиԓы хӑщәм ими ус, щи пŏрайән хуԓәм тӑԓ пӑ хут тыԓәщ турәм хӑр щиты лӑп йэртман уса, пӑ иса мўв ԓŏвата ун ԓэԓԓы пŏра йŏхтәс, ");
INSERT INTO kca_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ԓыв кўтэԓа ий ими хŏща нэш Илия ӑт китса, туп Сидон вош пўӈәԓән уԓты Сарепта курта икиԓы ий ими хŏща китса. ");
INSERT INTO kca_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Елисей Турәм йасәӈ туты ху уԓәм пŏрайән, йэмәӈ ԓайӈәӈ ԋўлмәт тӑйты ар хŏйат Израиль мўвән ус, Нееман нэмпи Сирия мўвәӈ ики тўмпийән, нэмәԓты хŏйат ӑт сыстапса\". ");
INSERT INTO kca_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Щит хуԓмеԓ кемән, Турәм йасӈа утәԓтәты хотән уԓты хŏйатәт хŏԓыйэ ԉикән йŏхәтсайәт. ");
INSERT INTO kca_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ԓыв нŏх ԓойәпсәт, Иисус вош эԓты ким воштәсэԓ; вошеԓ кев пай эԓты омәсман уԓ, пӑ пӑԓ кев пай венша тусэԓ, иԓ вŏщкәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Туп Ԓўв, хŏйатәт кўтән шушман, пўӈԓа йирԓәс. ");
INSERT INTO kca_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Иисус Галилея мўвән уԓты Капернаум воша йŏхтәс, пӑ шаббат хӑтәԓән ԓывиԓаԓ утәԓтәс. ");
INSERT INTO kca_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Мŏхет Ԓўв утәԓтәпсайәԓ эԓты ӑԓ пакнысыԓәт, Ԓўв йасӈәԓ партатты щир тӑйәс. ");
INSERT INTO kca_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Турәм йасӈа утәԓтәты хотән кўԉ сŏх тӑйәм хŏйат ус, пӑ ԓўв сыйәӈ тўрән ўваԓтәс: ");
INSERT INTO kca_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","\"А-а-а: Назарет эԓты уԓты Иисус, мўӈ эԓтэв мўй Нӑӈен мосәԓ? Нӑӈ мўӈев пӑратты йŏхәтсән; уйәтԓэм, Хŏй Нӑӈ! Нӑӈ – Турәм Йэмәӈ Ŏт!\" ");
INSERT INTO kca_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Иисус ԓўвеԓ такан партсәԓы: \"Мӑшйайа йўвәмта па ԓўв эԓтэԓ ким эта!\" Кўԉ сŏх Турәм йасӈа утәԓтәты хот кўтәпән хŏйат иԓ вŏщкәсԓы, щӑԓта ԓўв эԓтэԓ ким этәс, нэмәԓты атәм ин хŏйата ӑт верәс. ");
INSERT INTO kca_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Мŏхет хŏԓыйэ хŏрщәмән йŏхәтсайәт, пӑ кўтԓаԓән пŏтәртсәт: \"Мўй щит? Ԓўв щиты партатты щирән пӑ йуртат кўԉ сŏхәта пӑртәԓ пӑ ԓыв ким этԓәт?\" ");
INSERT INTO kca_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Пӑ Ԓўв эԓтэԓ айкеԓ керәтман куртәт хўват лакки мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Турәм йасӈа утәԓтәты хот эԓты ким этмаԓ йўпийән, Иисус Симон хота ԓŏӈәс. Симон утпәԓ ими шек кӑшаӈ ус; пӑ Иисус щи ими урәӈән вохса. ");
INSERT INTO kca_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ԓўв щи ими хŏща ԋўрман, муш нŏх вŏԓыты партсәԓы; ин ими мушән хӑйса. Ԓўв ищи мŏхты нŏх ԓойәс, пӑ мŏхета пӑсан омәсты питәс. ");
INSERT INTO kca_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Хӑтәԓ иԓ опсәм сыс хŏԓыйэ, хŏй мушән йŏхтәм хŏйат тӑйәс, щи ар сыр мушпи хŏйатԓаԓ Ԓўв хŏщайәԓа тусԓаԓ. Ԓўв пӑ, кашәӈ мушәӈ хŏйат эԓты йошԓаԓ пŏныԓыман, ԓывиԓаԓ тўмтака версәԓы. ");
INSERT INTO kca_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ар хŏйат эԓты ищиты кўԉ сŏхәт, ўвман, ким этсәт пӑ пŏтәртсәт: \"Нӑӈ – Христос, Турәм Пŏх!\" Ԓыв уйәтԓәт - Ԓўв – Христос, туп Иисус щит ԓывиԓаԓа йастыты ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Хун хӑтԓа йис, Ԓўв хот эԓты ким этмаԓ йўпийән, таԓ шитам тӑхайа мӑнәс. Ар хŏйатән кӑшса, пӑ Ԓўв хŏщайәԓ йŏхәтмеԓән, Ԓўвеԓ иԓ рŏнатԓэԓ, ԓыв эԓтайэԓ ӑт ат мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ԓўв пӑ ԓывиԓаԓа йастәс: \"Мӑнэм па вошәтән ищи Турәм Хон Уԓәпса эԓты Йӑм айкеԓ йастәты мосәԓ. Щи урәӈән Ма китсайәм\". ");
INSERT INTO kca_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Щиты Ԓўв Галилея Турәм йасӈа утәԓтәты хотәтән сыйәӈа пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","И пўш, хун Иисус Геннисарет нэмпи ԓор питарән ԓоймаԓән, хŏйатәт керәтман Ԓўв хŏщайәԓ нӑптәщсәт, Турәм йасәӈ хуԓәтты урәӈән, ");
INSERT INTO kca_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ԓўв кӑт ўты кӑтԓәм хоп шийаԓәс; хўԓ веԓты хŏйатәт пӑ, хоп эԓты иԓ ŏхәԓман, хоԓәпԓаԓ ԉŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Иисус и хопәԓа ԓэԓәс, Симон хопа. Ԓўв ԓор питар эԓты Симон йэша йэԓшәк мӑнты пӑртсәԓы, Ԓўв пӑ, хопән омәсман, хŏйатәт утәԓтәс. ");
INSERT INTO kca_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Хун Ԓўв хŏйатәт утәԓтәты йэтшәс, Симон пеԓа йастәс: \"Мӑԓ тӑхайа мӑна, пӑ хоԓпән хўԓ хойты щира йовәԓмаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Симон Ԓўвеԓа йастәс: \"Утәԓтәты ху, мўӈ тӑԓаӈ ат рупәтсув, нэмәԓты ӑт мŏщатсув, туп Нӑӈ йасӈен хўватән ма хоԓпем йовәԓмәԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Щиты вермеԓ йўпийән, ԓыв щи арат ар хўԓ мŏщатсәт, пӑ хŏԓна хоԓпеԓ тŏхты питәс. ");
INSERT INTO kca_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Щиӈәԋща ԓыв кимет хопән уԓәм пиԓԓаԓа йош йовәԓты питсәт, ԓывиԓаԓа ԋотты ат йŏхәтсәт; щӑԓта йŏхәтсәт пӑ хопӈәԓаԓ кинәӈтак хўԓән тэкәптәсԓаԓ, хопӈәԓаԓ вŏԓԓы иԓ шуйԓәты питсәӈән. ");
INSERT INTO kca_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Щит шийаԓәмаԓ кемән, Иисусән Петрайа айәԓтәм Симон Иисус шашӈән хŏща рӑкнәс пӑ йастәс: \"Турәм Куща, ма эԓтэм йэԓ мӑна, ма кӑрэкәӈ хŏйат\". ");
INSERT INTO kca_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Петрайа айәԓтәм Симон пӑ хŏԓ, ԓўв пиԓәԓән уԓәм йохԓаԓ, тӑм веԓәм хўԓԓаԓ пӑтыйән, пӑԓщәмән йŏхәтсайәт; ");
INSERT INTO kca_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Симон пиԓӈәԓаԓ Иаков пӑ Иоанн, Зеведей пŏхӈән ищиты пӑԓтәмәсӈән. Щӑԓта Иисус Симон пеԓа йастәс: \"Аԓ пӑԓа, тӑԓта йэԓԓы нӑӈ хŏйатәт кӑтәԓты питԓән\". ");
INSERT INTO kca_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Щиӈәԋща, хопӈән ўты тӑԓмеԓ йўпийән, пŏрмасԓаԓ иса хӑйсәԓаԓ пӑ Иисус йўпийән мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Хун Иисус и мŏԓты вошән уԓмаԓән, ԓŏватәԓән ԓайӈәӈ ԋўләмән этәм хŏйат йŏхтәс. Щӑԓта, Иисус шийаԓәмаԓ кемән, Ԓўв йэԓпеԓән хŏмта шаншантәс пӑ, пойәкман пŏтәртәс: \"Йэшәк Турәм Куща! Кашен уԓ ки, верәтԓэн мӑнэм Нӑӈ нŏх сыстапты\". ");
INSERT INTO kca_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Иисус йошәԓ йэԓ шӑшсәԓы, ԓўв хŏщайәԓа хӑнәмтыйәс пӑ йастәс: \"Ԓӑӈхаԓайәм, сыстама йўва!\" Ищи мŏхты ԓайӈәӈ ԋўләмԓаԓ йӑма йисәт. ");
INSERT INTO kca_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Иисус ԓўвеԓа нэмәԓты хŏйата щи вер эԓты пŏтәртты ӑт эсәԓсәԓы. Туп Турма йир верты хŏйата этәԓтыты пӑртсәԓы, пӑ сыстапты верәԓ пеԓа йир туты пӑртсәԓы, хŏты Моисей партәс, ԓывиԓаԓ эвԓәптәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Туп Иисус айкеԓәԓ мет йэԓ ԓӑрпиԓәс, пӑ тэԓыйэ хŏйат Ԓўв хŏщайәԓа йŏхтыԓыйәс, Ԓўв йасәӈԓаԓ хуԓәтты пӑ мушԓаԓ эԓты йӑмәԓтыты. ");
INSERT INTO kca_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Туп Иисус таԓ шитам тӑхайата мӑныԓыйәс пӑ щита пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","И хӑтәԓән, хун Иисус хŏйатәт утәԓтәс, щита Галилея пӑ Иудея куртәт эԓты, Иерусалим вош эԓты па йŏхтәм фарисейәт пӑ Закона утәԓтәты икет омәссәт; Турәм Куща йур мушәӈ хŏйатәт тўмтака верты верән этԓыйәс. ");
INSERT INTO kca_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Щӑԓта ин, кӑмәтса хŏйат щащԓы питәм ху ŏԓты сŏxԓаԓән тусәт. Ԓыв хота ԓўвеԓ ԓŏӈәԓтты ўтщисэԓ, Иисус йэԓпийа ԓуԓән пŏнты, ");
INSERT INTO kca_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","туп и ԓӑӈкәрән ԓойты хŏйатәт кўт эԓты ӑт верәтсэԓ туты. Щиӈәԋща ԓыв хот ԓоӈԓа нŏх ўратсәт, хот ԓоӈәԓ, нŏх лосәтман, усән версэԓ пӑ мушәӈ ŏтэԓ ŏԓты сŏxԓаԓән кўтԓәпа Иисус йэԓпийа иԓ эсәԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Иисус ԓыв эвәԓты щирэԓ шийаԓәмаԓ кемән, мушәӈ хŏйата йастәс: \"Ԓухсэм, кӑрэкԓан йŏрэмәсайәт!\" ");
INSERT INTO kca_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Фарисейәт пӑ Закона утәԓтәты икет щит хуԓмеԓ кемән нумәсты питсәт, пŏтәртԓәт: \"Хŏй щит, Хŏй Турма ӑт рӑхты йасӈәт йастыйәԓ? Турәм тўмпийән хŏй верәтәԓ хŏйата кӑрэкәт йŏрэмәты?\" ");
INSERT INTO kca_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Иисус, ԓыв нŏмәсԓаԓ ŏша пайәтмаԓ кемән, йŏхԓы ԓывиԓаԓа йастәс: \"Мўйа щиты нумәсԓәты? ");
INSERT INTO kca_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Мўй кеншәк йастәты: ”Нӑӈ кӑрэкԓан йŏрэмәсайәт!”, мўй пӑ йастәты: ”Нŏх ԓойа пӑ шушиԓыйа”? ");
INSERT INTO kca_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Уйтаты, Хŏйат Пŏх тӑта, мўвән, кӑрэкәт йŏрэмәты щир тӑйәԓ, - Иисус щащԓы питәм хŏйат пеԓа йастәс, - Нӑӈена пŏтәртԓәм: нŏх ԓойа, ŏԓты сŏхԓан ўйаԓән пӑ йŏхи мӑна\". ");
INSERT INTO kca_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ищи мŏхты ԓыв йэщаԓтэԓ ԓўв нŏх ԓойәс, ŏԓәм сŏxԓаԓ усԓы, Турәм вŏԓаӈа айәԓтман, йŏхи мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Щиӈәԋща вантәм хŏйатәт пӑԓщәмән йŏхәтсайәт, ԓыв Турәм вŏԓаӈа айәԓтсәт пӑ, пӑԓман, пŏтәртсәт: \"Тӑмхӑтәԓ унты ӑт вантыԓыйәм верәт мўӈ ин щи ватсув!\" ");
INSERT INTO kca_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Щи йўпийән, Иисус ким этәс, пӑ Левий нэмпи налог ӑкәтты хŏйат шийаԓәс, налог ӑкәтты тӑхайәԓән опсәс. Иисус ԓўвеԓа йастәс: \"Ма йўпемән йўва\". ");
INSERT INTO kca_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Щиӈәԋща, мŏԓтыԓаԓ иса хӑйсәԓы, нŏх ԓойәс пӑ Иисус йўпийән мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Левий ԓўв хотәԓән Иисус урәӈән ун поры пӑсан ԓэщатәс, ԓыв пиԓԓаԓән пӑсан сурыйән налог ӑкәтты ар хŏйат пӑ па мŏхет усәт. ");
INSERT INTO kca_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Фарисейәт пӑ Закона утәԓтәты икет Иисус утәԓтәты йохԓаԓ пеԓа ўшмащсәт пӑ пŏтәртсәт: \"Мўйа нын налог ӑкәтты хŏйатәт пӑ кӑрэкәӈ хŏйатәт пиԓән и йӑха ԓэԓты, йищԓәты?\" ");
INSERT INTO kca_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Иисус ԓывиԓаԓа йŏхԓы йастәс: \"Тўмтак хŏйатәта хун ԉеккар мосәԓ, мушәӈ хŏйатәта мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ма ӑнта тўӈа–щира уԓты хŏйатәт, Ма кӑрэкәӈ хŏйатәт кӑрэкԓаԓ эԓты шӑшән керԓәптәты урәӈән йŏхәтсәм\". ");
INSERT INTO kca_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Щӑԓта ԓыв Иисуса йастәсәт: \"Иоанн утәԓтәты йохԓаԓ ван кўтән вўщԓәты хӑтԓәт верыԓыԓәт пӑ пойәкщәты верәт верԓәт, фарисейәт утәԓтәты йŏх ищиты уԓԓәт, Нӑӈиԓан пӑ ԓэԓәт-йищԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Иисус ԓывиԓаԓа йŏхԓы йастәс: \"Нын мўй поры пӑсан хŏща, Нэ Туты Ху омәсман, мŏйәӈ йох вўщԓәты партты верәтԓәты? ");
INSERT INTO kca_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Хӑтԓәт йŏхәтԓәт, хун Нэ Туты Ху ԓыв эԓтэԓ нŏх ўԓа, щи пŏрайән ԓыв вўщԓәты хӑтԓәт верты питԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Иисус ԓывиԓаԓа хŏԓна тӑмәщ утәԓтәты пŏтәр пŏтәртәс: \"Нэмәԓты хŏйат, йӑԓәп ԓумтәмәԓ эԓты менэмәм йŏԓәптайәԓ, катра сŏхәԓа ӑт рӑхәԓԓәԓы; па щирән ки йӑԓәп ԓумтәмәԓ мӑшԓәԓы, пӑ йӑԓәп йŏԓәптайәԓ катра сŏхәԓа па ӑт рӑхәԓ. ");
INSERT INTO kca_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Пӑ нэмәԓты хŏйат йӑԓәп ўна катра ԋўки хира ӑт пŏнԓәԓы, па щирән ки, веԉщи кавәрты ўнайән хир мӑшԓа, ўнайәԓ иԓ мӑнәԓ пӑ хирәԓ ӑт мосты питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ӑнта, йӑԓәп ўна йӑԓәп хира пŏнты мосәԓ. Ши пŏрайән тўмеԓ тӑԓаӈа хӑщәԓ, пӑ тӑмеԓ па. ");
INSERT INTO kca_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Нэмәԓт хŏйат, катра ўна йиԋщемәман, ищи мŏхты йӑԓәп ўна йиԋщемәты ӑт ԓӑӈхамәԓа. Ԓўв йастәԓ: \"Катра ўна йӑмшәк\". ");
INSERT INTO kca_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","И пўш, шаббат хӑтәԓән Иисус ԓатән опсәм мўв хӑр хўват шушәс. Ԓўв утәԓтәты йохԓаԓ ԋаԋ тŏрән тӑйәт мӑшсәт, йошән сыстапсыԓаԓ пӑ ԓат сэмԓаԓ йŏхи ԓэсԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Тухәԓ фарисейәт иԋщәссәт: \"Мўйа нын шаббат хӑтәԓән, мўй ӑт эсәԓман уԓԓа верты, щит верԓәты?\" ");
INSERT INTO kca_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Иисус йŏхԓы йастәс: \"Нын мўй ӑт ԓўӈәтсәԓән, хун Давид мŏхиԓаԓ пиԓән сӑмԓаԓ вохәмән, мўй ԓўв верәс? ");
INSERT INTO kca_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Хŏты ԓўв Турәм Хота ԓŏӈәс пӑ Турәм кеша пŏнәм йэмәӈ ԋаԋәт усԓы, ԓэс пӑ хŏԓна ԓўв пиԓәԓән уԓәм мŏхиԓаԓа мӑсԓы, Турма йир верты хŏйатәт тўмпийа щи ԋаԋәт нэмәԓт хŏйата ԓэты ӑт эсәԓман уса?\" ");
INSERT INTO kca_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Щӑԓта Иисус ԓывиԓаԓа йастәс: \"Хŏйат Пŏх шаббат хӑтәԓ хŏща па куща\". ");
INSERT INTO kca_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Па шаббат хӑтәԓән пӑ Иисус Турәм йасӈа утәԓтәты хота ԓŏӈәс пӑ утәԓтәс. Щита и хŏйат ус, ԓўв йӑм пеләк йошәԓ нŏх сорман ус. ");
INSERT INTO kca_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Закона утәԓтәты икет пӑ фарисейәт Иисус ватман тӑйԓэԓ, шаббат хӑтәԓән хŏйат тўмтака верԓәԓы мўй ӑнтом, Ԓўв хŏщайәԓ нўр этәԓтәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Иисус, ԓыв нŏмәсԓаԓ уйәтман, сорәм йошпи хŏйата йастәс: \"Нŏх ԓойа пӑ хот кўтпа йўва\". Щитэн нŏх ԓойәс пӑ хот кўтпа этәс. ");
INSERT INTO kca_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Иисус лывиԓаԓа йастәс: \"Ма нынан иԋщәсԓәм: шаббат хӑтәԓән мўй верты эсәԓман уԓԓа? Йӑм вер мўй атәм вер? Ԓыԓ этәԓтәты мўй пӑратты?\" Ԓывәт иса мӑшйайәт. ");
INSERT INTO kca_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ԓыв пеԓайԓаԓа ӑӈкәртмаԓ йўпийән, Иисус щи хŏйата йастәс: \"Йошэн йэԓ ԋиншәмты\". Щитэн щиты версәԓы; ин йошәԓ кимет йошәԓ хŏрпийа пӑ йӑма йис. ");
INSERT INTO kca_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ԓыв пӑ пӑԓщәм ԉикән йŏхәтсайәт, кўтԓаԓән пŏтәртсәт, а мўй хŏты Иисус верты. ");
INSERT INTO kca_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Щи хӑтԓәтән Иисус кев пай ԓоӈԓа нŏх хуӈхәс пойәкщәты урәӈән, щита ат хўват Турәм пеԓа пойәкщәман ус. ");
INSERT INTO kca_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Хун хӑтԓа йис, Ԓўв утәԓтәты йохԓаԓ вохсәԓы пӑ ԓыв эԓтыԓаԓ кӑтхŏщйаӈ хŏйат пирыйәс, ԓывиԓаԓ апостоләта айәԓты щи питсәԓы: ");
INSERT INTO kca_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Симон, ԓўвеԓ Петрайа пӑ айәԓты питсәԓы, ԓўв Андрей апщеԓ па, Иаков пӑ Иоанн, Филипп пӑ Варфоломей, ");
INSERT INTO kca_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Матфей пӑ Фома, Иаков - Алфей пŏх пӑ Зилота нэмтәм Симон, ");
INSERT INTO kca_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Иуда - Иаков пŏх пӑ Иуда Искариот – щит щӑха Иисус пӑратты йохәт йоша мӑты ху. ");
INSERT INTO kca_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ԓыв пиԓԓаԓән кев пай эԓты иԓ ŏхәԓмаԓ йўпийән, Иисус пайԓы тӑхайән иԓ ԓойәс, хŏта мŏԓты кем Ԓўв утәԓтәты йохԓаԓ пӑ ар хŏйат Иудея мўв ԓŏват эԓты, Иерусалим вош эԓты, па щарәс питар мўвӈән Тир па Сидон эԓты ус, ");
INSERT INTO kca_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ԓыв Иисус хуԓәтты па мушԓаԓ эԓты тўмтака пайтәсты урәӈән йŏхәтсәт, щӑԓта пӑ кўԉ сŏхән шукатты ŏтәт ищи йӑма йисәт; ");
INSERT INTO kca_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Мир xŏԓыйэ Ԓўв хŏщайәԓа хӑнәмтыты ўратԓәт, Ԓўв эԓтайәԓ йур йис пӑ хŏԓыйэ тўмтака версайәт. ");
INSERT INTO kca_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Щӑԓта Ԓўв, утәԓтәты йохԓаԓ пеԓа ӑӈкәртман, йастәс: \"Куԋар сӑмпи ŏтәт щўԋԓәԓты! Турәм Хон Уԓәпса нынана уԓ. ");
INSERT INTO kca_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ин ԓэԓԓы уԓты ŏтәт ŏй тӑйԓәты, щӑха тӑрәмԓайты! Ин хоԓԓәты ŏтәт ŏй тӑйԓәты, ԋӑхты питԓәты! ");
INSERT INTO kca_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Нын щўԋԓәԓты, хун хŏйатәтән ԉикән этты питԓайты, хун нŏмәс кимпийән тӑйты питԓайты, пӑ ԋэрты питԓайты, нэмԓән нўрәӈа айәԓты питԓайәт, Хŏйат Пŏха эвәԓман урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Щи хӑтәԓән амтәтԓыйаты пӑ ԋӑхман-йŏтман уԓаты: турәмән нын мойԓапсайԓән вŏԓаӈәт! Ԓыв ащиԓаԓ Турәм йасәӈ туты хŏйатәт пиԓән ищи щиты уԓԓысәт. ");
INSERT INTO kca_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Туп, тащәӈ хŏйатәт, нынана шук – нын тŏрамтыты щир тӑԓаӈ тэԓән мŏщатсәԓән! ");
INSERT INTO kca_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ин тарәмтыйа ԓэты ŏтәт, нынана шук! Сӑмԓән вохты питԓайәт! Ин ԋӑхман уԓты ŏтәт, нынана шук – хоԓԓәты пӑ йирӈәԓтыты питԓәты! ");
INSERT INTO kca_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Шук нынана, хун хŏйатәт иса нын эԓтан йӑма пŏтәртты питԓәт! Ԓыв ащиԓаԓ ӑнта йӑна Турәм йасәӈ туты хŏйатәт пиԓән ищи щиты уԓԓысәт!\" ");
INSERT INTO kca_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","\"Нынана, Мӑнэм хуԓәтты ŏтәта, пŏтәртԓәм: нынан нўрмәԓтты хŏйатԓән мосман тӑйаԓән, йӑм вер вераты щи хŏйатәта, хŏйән нын ԉикән этԓайты, ");
INSERT INTO kca_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","нынан эӈкәрты ŏтԓәна Турәм эԓты йӑмән вохаԓән, пӑ нынана атәм верты хŏйатәт урәӈән, пойәкщаты. ");
INSERT INTO kca_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Веш пўӈԓэн эԓты рэскийәм ŏтэна, кимет веш пўӈԓэн па шӑши, эԓты ԓумтәмен эхты ŏтэна, ԓыпи йэрнасэн ўты па аԓ йэрты. ");
INSERT INTO kca_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Кашәӈ нӑӈ эԓтэн вохты хŏйата, мўй вохәԓ, мийи, пӑ нӑӈ ŏтэн ўйәм xŏйат эԓты ŏтэн йŏхԓы аԓ вохи. ");
INSERT INTO kca_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Хŏты ԓӑӈхаԓайты, нын пиԓәнән хŏйатәт ат усәт, щиты ԓыв пиԓԓаԓән нын уԓаты. ");
INSERT INTO kca_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Нынан мосман тӑйты хŏйатәт мосман тӑйԓәԓән ки, нынан мўй йӑм? Кӑрэкәӈ хŏйатәт ԓывиԓаԓа мосты хŏйатԓаԓән ищи мосман тӑйԓайәт. ");
INSERT INTO kca_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Пӑ щи хŏйатәта йӑм вер верԓәты ки, хŏй нынан йӑм вер верәԓ, нынана мўй йӑм? Кӑрэкәӈ хŏйатәт ищи щиты верԓәт. ");
INSERT INTO kca_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Пӑ, хŏйатәта артнайа мийԓыԓты ки, щи хŏйатәт эԓты артнайән йŏхԓы хоӈәтԓәԓән ки, нынан мўй йӑм? Кӑрэкәӈ хŏйатәт ищи кўтэԓән артнайа мийантыԓәт, йŏхԓы ищи щи арат ўты нумәсԓәт. ");
INSERT INTO kca_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Туп нынан нўрмәԓтты хŏйатԓән мосман тӑйаԓән, йӑм вер вераты пӑ, нэмәԓты йŏхԓы ӑт хоӈәтман, артнайа мийаты; щишән нынан мойԓәпса вŏԓаӈ питәԓ, пӑ Нўм Турәм ԋаврэма уԓты питԓәты; Ԓўв кўш йӑм ӑт нумты хŏйатәт пеԓа, кўш ԉикәӈ хŏйатәт пеԓа и хŏрпийа сӑмәӈ. ");
INSERT INTO kca_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Щиӈәԋща хŏйатәт пеԓа сӑмәӈа уԓаты, хŏты Турәм Ащан сӑмәӈ. ");
INSERT INTO kca_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Аԓ сўтытаты пӑ нынан нэмәԓты хŏйат сўтәтты ӑт питәԓ. Аԓ ԋухмантаты, пӑ нын эԓтан нэмәԓты хŏйат ԋухматты ӑт питәԓ. Нўр аԓ нуматы, пӑ нын нўрԓән ищи йŏрэмәԓайәт. ");
INSERT INTO kca_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Мийаты, пӑ нын па мӑԓайты: йӑм мŏртән, йовԓәм, иԓ тыԋхәм, щурщаӈа пŏнәм тэԓәӈ мŏртән хŏхәнԓәна шŏшәмԓайты; мўй сыр мерайән пŏнԓәты, щимәщ мерайән нынана пŏнты питԓа\". ");
INSERT INTO kca_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Утәԓтәты пŏтәр ԓывиԓаԓа па пŏтәртәс: \"Сэмԓы хŏйат мўй верәтәԓ сэмԓы хŏйат ватәԓтәты? Мўв ўса мўй ӑнта кинәӈтак иԓ питԓәтән? ");
INSERT INTO kca_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Утәԓтыты хŏйат утәԓтәты икеԓ эԓты унашәк ӑт уԓԓыйәԓ, туп утәԓтыты вер йэтшәман, кашәӈ хŏйат утәԓтәты икеԓ иты йиты верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Мўйа нӑӈ ԓухсэн сэма питәм нўв шўк пеԓа ватԓән, нӑӈ сэменән ŏԓты павәрт шуп ӑт мŏштәԓэн? ");
INSERT INTO kca_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Мўй щирән нӑӈ веритԓән щи ԓухсэна йастәты: \"Ԓухсэм, мийи ма нӑӈ сэмен эԓты нўв шўк нŏх ўԓэм, - щи пўԉаӈ нӑӈ сэменән павәрт ӑт шийаԓәԓэн? Кӑт вешпи хŏйат! Оԓәӈән павәрт нӑӈ сэмен эԓты нŏх ўйи, щӑԓта ныты питԓа, хŏты нўв шўк ԓухсэн сэм эԓты нŏх ўԓэн\". ");
INSERT INTO kca_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","И йӑм йўх атәм ԓэвпәс ӑт энмәԓԓәԓ; пӑ и вевтам йўх йӑм ԓэвпәс ӑт энмәԓԓәԓ, ");
INSERT INTO kca_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","кашәӈ йўх ԓўв энмәԓтәм ԓэвпәсԓаԓ эԓты уйәтԓа. Пеԓантыты варәс эԓты смоква вощтŏт ӑт ӑкәтԓа пӑ варәс пŏхәл эԓты – виноград ӑт ӑкәтԓа. ");
INSERT INTO kca_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Сӑмәԓ йӑм хŏйат сӑмәԓән шавиты йӑмәԓ этәԓтәԓ, ԉикәӈ хŏйат сӑмәԓән тӑйты ԉикәԓ этәԓтәԓ, хŏйат тэԓәӈ сӑмәԓ эԓты ԓўв ўӈԓәԓ пŏтәртәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","\"Мўйа нын Мӑнэм вохԓәԓән: \"Турәм Куща, Турәм Куща!\" пӑ хŏты Ма йастәԓәм, щиты ӑт верԓәты? ");
INSERT INTO kca_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Кашәӈ Ма хŏщайэма йŏхтыԓыты хŏйат пӑ Ма йасәӈԓам хуԓәтты хŏйат пӑ йасәӈԓам щирән верты хŏйат, нынана йастәԓәм ԓўв хŏй хŏрпи. ");
INSERT INTO kca_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ԓўв щимәщ хŏйат хŏрпи, хŏй хот омәсәԓ, хот лотәԓ мӑԓа хирсәԓы пӑ хот пӑтэԓ кев эԓты ўсԓы. Мўйа, хун йик эпәтмаԓән пӑ щи хот йикән ԋорәтман, йэша нэш пўӈԓа ԋŏхтәты ӑт верәтса, хот кев эԓты омәсман уса, щишән. ");
INSERT INTO kca_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ма йасӈем хуԓәтты хŏйат пӑ йасәӈ щирән ӑт верәԓ, щит хотәԓ мўв эԓты опсәм хŏйат хŏрпи, хотәԓ так пӑты ӑт тӑйәԓ; хун ун йикән ԋорәтса, и щишән иԓ ӑркәмтәс; щи хот пŏԉха шўкаԓәс\". ");
INSERT INTO kca_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Хун Иисус хуԓәнтәм мир пеԓа йасәӈԓаԓ хŏԓасәт, Капернаум воша мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Щита и сот ԉаԉ йох ŏх ху митхуйәԓ ԓавәртат кӑшаӈ ус, сŏрмәԓ вŏԓԓы ванамәс. Щи митху ԓўв шек мостыйа тӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Иисус эԓты хуԓмаԓ кемән, ԓўв иудейәт хŏща уна уԓты икет эԓты тухәԓԓаԓ Иисус хŏща китсәԓԓы, йастәты, ԓўв митхуйәԓ тўмтака верты урәӈән, ат йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ԓыв Иисус хŏща йŏхәтмеԓән, эвԓа-йŏԓа Ԓўвеԓ пойәксэԓ, щиты пŏтәртԓәт: \"Нӑӈен ԓўвеԓа щит верты рӑхәԓ, ԓўв йӑм хŏйат, ");
INSERT INTO kca_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ԓўв мирэв мостыйа тӑйԓәԓы, хŏԓна Турәм йасӈа утәԓтәты хот мўӈева верәс\". ");
INSERT INTO kca_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Иисус ԓыв пиԓԓаԓән мӑнәс. Туп хун Ԓўв ԉаԉ йох ŏх ху хот ԉэпа йŏхтәс, ԉаԉ йох ŏх ху ԓухәсԓаԓ йэщаԓт китсәԓы, йастәты: \"Йэшәк Турәм Куща, йэԓԓы аԓ мӑна, ма мўй вŏԓаӈ хŏйат, ма хотэма Нӑӈ ат ԓŏксән, ");
INSERT INTO kca_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","щишән, мӑнэм ма йӑм хŏйата ӑт ԓуӈәтсэм, Нӑӈ хŏщайэн ванамәты урәӈән; туп и йасәӈ йаста, митхуйэм тўмтака йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ма ищи хуԓәтты хŏйат, туп ма иԓпемән ищи ԉаԉ йохәт уԓԓәт, ита йастәԓәм: \"Мӑна\", па мӑнәԓ, пӑ кимета йастәԓәм: \"Ты йўва!\", пӑ йиԓ, митхуйэма йастәԓәм: \"Щит вера\", пӑ верәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Щит хуԓмаԓ кемән, Иисус ԓўв пелайәԓ ӑԓ ватәԓ пӑ, йŏхԓы каремәман, Ԓўв йўпеԓән шушәм хŏйатәта йастәс: \"Нынана пŏтәртԓәм, тӑмәщ эвәԓты щир Ма Израиль мир хŏща хŏԓна ӑт уйәтсәм\". ");
INSERT INTO kca_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Китыԓыйәм мŏхет, йŏхԓы йŏхәтмеԓән, кӑшаӈ митхуйэԓ, уйәтмеԓән, тўмтака йўвмаԓ. ");
INSERT INTO kca_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Щи йўпийән Иисус Наин нэмпи воша мӑнәс; ар пеләк утәԓтәты йŏхԓаԓ пӑ тэԓыйэ хŏйат Ԓўв пиԓәԓән шушсәт. ");
INSERT INTO kca_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Хун Ԓўв вош пушас ова вана йŏхтәс, вош эԓты пӑрәм хŏйат ким этәԓтәса, икиԓы хӑщәм ими туп тӑйәм и пŏхәԓ ус. Ши ими пиԓән вош эԓты ар хŏйат шушәс. ");
INSERT INTO kca_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ими шийаԓәмаԓ кемән, Турәм Куща сӑмәԓ хощты питәс, щаԉа ўсԓы пӑ ԓўвеԓа йастәс: \"Аԓ хоԓԓа!\" ");
INSERT INTO kca_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Вана шушман, Иисус ԓэԓтŏта йошәԓән хӑнәмтыйәс; ӑпа тўвәм мŏхет иԓ ԓойсәт. Щӑԓта Иисус йастәс: \"Энәмты пŏх, нӑӈена йастәԓәм, нŏх ԓойа!\" ");
INSERT INTO kca_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Пӑрәм пŏх нŏх опсәс пӑ пŏтәртты питәс; Иисусән ԓўв аԋԏеԓ йоша катԓәптәса. ");
INSERT INTO kca_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Хŏйатәт пӑԓщәмән йŏхәтсайәт, пӑ ԓыв Турәм вŏԓаӈа айәԓтты питсәт, пŏтәртԓәт: \"Вŏԓаӈ, ун Турәм йасәӈ туты хŏйат этәс, мўӈ кўтэвән уԓ! Турәм мирәԓ хŏща ԋотты йŏхтәс!\" ");
INSERT INTO kca_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Тӑмәщ айкеԓ Ԓўв эԓтэԓ Иудея мўв ԓŏвата пӑ керәтман иса лакки ԓӑрпиԓәс. ");
INSERT INTO kca_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Иоанн тӑм верәт утәԓтәты йохԓаԓ эԓты хуԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Кӑт хŏйатӈәԓаԓ вана вохман, Иисус хŏща китсәԓы, иԋщәсты: \"Нӑӈ мўй Щит, Хŏй йŏхәтты верәԓ уԓ, мўй пӑ па Ŏт ԓавәԓты мосәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ԓын Иисус хŏща йŏхәтсәӈән, йастәсӈән: \"Иоанн йиӈка ԓŏӈәԓтыты хŏйат минэмән Нӑӈ хŏщайэна иԋщәсты китсәԓы: \"Нӑӈ мўй Щит, Хŏй йŏхәтты верәԓ уԓ, мўй пӑ па Ŏт ԓавәԓты мосәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Щи пŏрайән Иисус ар сыр муш пӑ кӑши эԓты, кўԉ сŏх эԓты йӑмәԓтәс, пӑ мŏԓты кем сэмԓы хŏйатәта ватты щир мойԓәс. ");
INSERT INTO kca_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Щӑԓта Ԓўв щиты йŏхԓы йастәс: \"Мӑнаты пӑ Иоанна пŏтәртаты, мўй ватсәты, хуԓсәты: сэмԓы хŏйатәт сэмәӈа йиԓәт, нохты хŏйатәт йӑма шушиԓыԓәт; ԓайӈәӈ ԋўлмәӈ хŏйатәт сыстама йиԓәт, пӑԓԓы хŏйатәт хуԓԓәт, пӑрәм хŏйатәт нŏх ԓыԓӈатԓайәт, пӑ нўша хŏйатәта Йӑм айкеԓ эԓты сыйәӈа пŏтәртԓа; ");
INSERT INTO kca_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Щит ŏйәӈ, хŏй мӑнэма эвәԓты нŏх ӑт вŏԓыйәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Иоанн китәм йохӈән мӑнәм йўпийән, Иисус мирәԓа Иоанн эԓты пŏтәртты питәс: \"Хӑр пӑ таԓ мўва мўй ватты йӑхсәты? Вотән йовәԓты тŏрән ватты? ");
INSERT INTO kca_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Мўй пӑ ватты нын йӑхсәты? Ԓэпәт сŏхәта ԓумәтԓыйәм хŏйат ватты? Йӑма ԓумәтԓыйәм пӑ тащәӈа уԓты хŏйатәт хон хотәтән уԓԓәт. ");
INSERT INTO kca_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Мўй пӑ ватты нын йӑхсәты? Турәм йасәӈ туты хŏйат? Йӑна, пŏтәртԓәм нынана, Турәм йасәӈ туты хŏйат эԓты вŏԓаӈшәк хŏйат ватты йӑхсәты. ");
INSERT INTO kca_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Тӑм щит, хŏй эԓты хӑшман уԓԓа: \"Тӑм, Ма айкеԓ туты хŏйатэм Нӑӈ йэԓпенән китԓэм, xойән Нӑӈ йушен Нӑӈ йэԓпенән ԓэщатԓа\". ");
INSERT INTO kca_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Щишән нынана пŏтәртԓәм: иметән сэма пайтәм хŏйатәт кўтән, Иоанн йиӈка ԓŏӈәԓтыты хŏйат эԓты ԓӑтәӈшәк Турәм йасәӈ туты хŏйат ӑнтом; туп мет ай ŏт Турәм Хон Уԓәпсайән ԓўв эԓтайәԓ ԓӑтәӈшәк\". ");
INSERT INTO kca_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Хŏԓ Ԓўвеԓ хуԓәнтәм мир, пӑ налог ӑкәтты мŏхет, Турәм вещкат вер вана ўйман, Иоанн йиӈка ԓŏӈәԓтыты щирән йиӈка ԓŏӈәԓтысайәт; ");
INSERT INTO kca_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","фарисейәт пӑ Закона утәԓтәты икет йиӈка ԓŏӈәԓтыты ӑт кашащсәт, Турәм ԓӑӈхаты щир вана ӑт усэԓ. ");
INSERT INTO kca_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Щӑԓта Турәм Куща йастәс: \"Ин тӑм хŏйат рут артаԓәты мосәԓ, хŏй хŏрпет? Ԓыв хŏй хŏрпет? ");
INSERT INTO kca_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ԓыв вош хӑры хŏща омәсты ԋаврэмәт хŏрпет, кўтԓаԓән ўвәтԓәт пӑ пŏтәртԓәт: ”Мўӈ нарәс йўхән нын урӈәнән йŏтсув, нын пӑ ӑт йаксәты, мўӈ хоԓԓәты арәт арисув, нын ӑт хоԓԓәсты”. ");
INSERT INTO kca_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Иоанн йиӈка ԓŏӈәԓтыты хŏйат йŏхтәс: ԋаԋ ӑт ԓэԓ, ўна ӑт йищәԓ, пӑ пŏтәртԓәты: ”Ԓўв ԓыпеԓән кўԉ уԓ”. ");
INSERT INTO kca_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Хŏйат Пŏх йŏхтәс: ԓэԓ пӑ йищәԓ; пӑ йастәԓты: ’’Тӑта щи хŏйат, хŏй ԓэԓ пӑ ўна йищәԓ, налог ӑкәтты хŏйатәт пиԓән, кӑрэкәӈ хŏйатәт пиԓән ԓухса уԓ’’. ");
INSERT INTO kca_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ŏшәӈ–щащәӈ нŏмәс хŏԓыйэ ԓўв ԋаврэмԓаԓән вещката пӑйәтса\". ");
INSERT INTO kca_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","И фарисейән Иисус ԓэты вохса; Ԓўв хота ԓŏӈәс, пӑсан сурыйа иԓ опсәс. ");
INSERT INTO kca_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Щи вошән и уԉԋайа уԓты нэ ус, Иисус фарисей хотән ԓэты вер хуԓмаԓ кемән, нŏви кев эԓты верәм, эпԓәӈ миро вŏйән пŏнәм, ващ турпи пўт тус. ");
INSERT INTO kca_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Щӑԓта, ԓўв шӑш пеләк сӑхат Иисус кўрнат шŏма шаншәха омәсман пӑ хоԓԓәман, Ԓўв кўрԓаԓ сэмйикән ŏвӈәԓтты пӑ ŏхсŏхԓаԓән нŏх мухты питсәԓы. Ԓўв кўрԓаԓ мосәԓтәсԓы пӑ эпԓәӈ миро вŏйән ԋŏсәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Хун Иисус вохәм фарисей щит шийаԓәс, нумәсэмәс: \"Тӑм йӑна Турәм йасәӈ туты хŏйат ки ус, Ԓўв ԓуԓән уйәтсәԓы, хŏй, мўй хŏрпи нэ Ԓўв хŏщайәԓ хӑныԓыйәԓ, щит кӑрэкәӈ нэ\". ");
INSERT INTO kca_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ԓўв пеԓайәԓ Иисус йастәс: \"Симон! Ма нӑӈена мŏԓты йастәты верэм уԓ\". Ԓўв йастәс: \"Пŏтәрта, Утәԓтәты Ху\". ");
INSERT INTO kca_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Иисус йастәс: \"И ŏхәӈ ху кӑт артнайәӈ хŏйатӈән тӑйәс: итәԓ – ветсот динарий, киметәԓ – ветйаӈ. ");
INSERT INTO kca_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ԓын артнайԓын сŏхәптәты ŏх ӑт тӑйсәӈән, щишән ŏхәӈ ху кӑтӈән артнайԓын йŏрэмәсԓы. Йаста, мӑты ŏтәԓән ŏхәӈ ху мет мостыйа тӑйԓа?\" ");
INSERT INTO kca_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Симон йастәс: \"Аԓт щитэн, хŏйа ԓўв аршәк ŏх йŏрэмәс\". Иисус ԓўвеԓа йастәс: \"Йӑна щиты пŏтәртԓән\". ");
INSERT INTO kca_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ин нэ пеԓа керԓәман, Симона йастәс: \"Тӑм нэ нӑӈена ныԓа? Ма нӑӈ хотэна йŏхәтсәм, нӑӈ кўр ԉŏхәтты йик Мӑнэм ӑт мӑсән, ԓўв пӑ Ма кўрԓам сэм йикԓаԓән ŏвӈәԓтсәԓы, ŏхсŏхԓаԓән нŏх мўхсәԓы; ");
INSERT INTO kca_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","уйтатмемәнән нӑӈ Мӑнэм хŏԓна ӑт мосәԓтәсэн, ԓўв пӑ, Ма йŏхәтмем ўш эԓты, Ма кўрԓам мосәԓтәты ӑт вŏԓыйәԓ. ");
INSERT INTO kca_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Нӑӈ Ма ŏхем оливка вŏйән ӑт ԋŏсәтсэн, ԓўв пӑ эпԓәӈ миро вŏйән кўрԓам ԋŏсәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Щишән, Ма нӑӈена йастәԓәм: Ма пеԓайэм артан сӑмәӈа уԓты верәԓ аԉәԓ, мўй арат ԓўв ар кӑрэкԓаԓ йŏрэмәсайәт; хŏйа шимәԓ нўр йŏрэмәԓа, щит шимәԓ сӑмәӈа уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Иисус щи нэ пеԓа йастәс: \"Нӑӈ кӑрэкԓан йŏрэмәсайәт\". ");
INSERT INTO kca_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ԓўв пиԓәԓән пӑсан сурыйән опсәм мŏхет нумәсты питсәт: \"Хŏй тӑм, кӑрэкәт пӑ йŏрэмәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Иисус пӑ нэӈа йастәс: \"Нӑӈ эвәԓты верэнән нӑӈ нŏх пайәтсайән, йӑм нŏмәсән мӑна!\" ");
INSERT INTO kca_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Щи йўпийән Иисус вошәт куртәт хўват, Турәм эԓты сыйәӈа пŏтәртман, Йӑм айкеԓ Турәм Хон Уԓәпса эԓты тўвман, йӑӈхәс. Ԓўв пиԓәԓән кӑтхŏщйаӈ утәԓтәты йохԓаԓ усәт, ");
INSERT INTO kca_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","пӑ тухәԓ нэӈәт, хŏйтат Ԓўв кўԉ сŏх пӑ арсыр мушәт эԓты йӑмәԓтәс: Магдалинайа айәԓты Мария, ԓўв эԓтэԓ ԓапәт кўԉ сŏх ким этәс; ");
INSERT INTO kca_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Иоанна па, Ирод хŏща хот рупата ŏх ху Хуза ийими; Сусанна, хŏԓна пӑ па имет. Тӑм нэӈәт Иисуса тӑйәм ŏхԓаԓән ԋотсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Хун щи арат ар мир ӑктәщәс пӑ арсыр вошәтән уԓты мŏхет Ԓўв хŏщайәԓ йŏхәтсәт, Ԓўв утәԓтәты пŏтәрән пŏтәртты питәс: ");
INSERT INTO kca_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","\"Ики мўв хӑрәԓа ԓат сэм йовәԓты этәс, хун ԓўв ԓат сэмԓаԓ йŏвәԓмаԓән, тухәԓԓаԓ йуш пўӈԓа рӑкәтсәт пӑ иԓ пурәтсайәт, щищкетән ԓэсайәт; ");
INSERT INTO kca_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","тухәԓԓаԓ па кев эԓты рӑкәтсәт, тŏрән тӑйԓаԓ йэша нŏх этмисәт, йик ӑт тӑймаԓ пӑтыйән, нŏх сорсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Тухәԓ ԓат сэмԓаԓ пуԓән кўта рӑкәтсәт, пуԓән пӑ энмәс, щӑԓта пуԓәнән лӑп аԓэмәсайәт; ");
INSERT INTO kca_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","тухәԓ ԓат сэмԓаԓ йӑм мўва рӑкәтсәт пӑ энәммеԓ йўпийән, йӑм арат ӑкәтса, иԓ йовԓәм ԓат сэм эԓты сот пўш ар\". Щи пŏтәр пŏтәртмаԓ йўпийән, Ԓўв такан йастәс: \"Хŏй хуԓты пӑԓ тӑйәԓ ки, ат хуԓәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Утәԓтәты йохԓаԓән Ԓўв иԋщәсса: \"Мўй эԓты тӑм утәԓтәты пŏтәр\". ");
INSERT INTO kca_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Иисус йŏхԓы йастәс: \"Нынан Турәм Хон Уԓәпса хӑԋа щирәт уйәтты мӑса, па хŏйатәта утәԓтәты пŏтәр хŏща, щиты ԓыв, ватман, ӑт шийаԓәԓәт, хуԓман, ӑт мŏштәԓәт. ");
INSERT INTO kca_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Утәԓтәты пŏтәр щит айәԓԓәԓ: ԓат сэм – щит Турәм йасәӈ. ");
INSERT INTO kca_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Йуш пўӈԓа рӑкнәм ԓат сэмәт хŏрпет тухәԓ йасәӈ хуԓты хŏйатәт, хŏйтат хŏща йухәт хиԋ йŏхәтәԓ пӑ щи йасәӈ сӑмԓаԓ эԓты нŏх уԓԓы, ԓыв ӑт ат эвәԓсәт пӑ нŏх ӑт ат пайтәссәт. ");
INSERT INTO kca_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Кев эԓты питәм ԓат сэмәт хŏрпет тухәԓ хŏйатәт, амәтман йасәӈ вана ўԓәт. Туп ԓыв ԓэр ӑт тӑйԓәт, оԓәӈән эвәԓԓәт, хун хўщәпса этмәԓ, йŏхԓы ԓэԓәпԓәт. ");
INSERT INTO kca_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Пуԓән кўта рӑкнәм ԓат сэмәт хŏрпет тухәԓ йасәӈ хуԓты хŏйатәт, туп ԓыв айән-айән кашәӈ хӑтәԓ верԓаԓән, тащәӈ пӑ каш хŏрпи уԓәпсайән йŏхи пайәтԓайәт, пӑ щи йасәӈ нэмәԓтыйа ӑт йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Йӑм мўва питәм ԓат сэмәт хŏрпет тухәԓ хŏйатәт, хŏй йасәӈ хуԓмеԓ йўпийән йӑм пӑ вещкат сӑмԓаԓән шавиԓэԓ, пӑ щи йасӈеԓ ун йӑм вер верәԓ\"; Щит йастәмаԓ йўпийән, Ԓўв такан йастәс: \"Хŏй хуԓты пӑԓ тӑйәԓ ки, ат хуԓәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Нэмәԓты хŏйат тўт сун ўщәтмаԓ йўпийән, хŏшамән лӑп ӑт пŏнԓәԓы, мўй пӑ иԓ ӑт хӑԋатԓәԓы, хŏԓна пӑ тўт акԓа нŏх опсәԓԓәԓы, ԓŏӈты хŏйатәта нŏви ат ныса. ");
INSERT INTO kca_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Нэмәԓты хӑԋа ӑнтом, мўй эԓпа ӑт ат этәс, пӑ нэмәԓты хӑԋатәм ӑнтом, мўй эԓпа ӑт ат аԉса пӑ эԓпа ат питәс. ");
INSERT INTO kca_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Щӑԓта, вантаты, хŏты нын хуԓәтԓәты: хŏй тӑйәԓ, щита па мӑты питԓа, хŏй ӑт тӑйәԓ, щит эԓты, мўй тӑйты нумәсәԓ, щитәԓ па нŏх ўԓа. ");
INSERT INTO kca_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ԓўв хŏщайәԓ аԋԏеԓ пӑ ху апщиԓаԓ йŏхәтсәт, хŏйатәт кўт эԓты вана мӑнты ӑт верәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Иисуса йастәса: \"Аԋԏен пӑ ху апщиԓан камән ԓойԓәт, Нӑӈен ватты ԓӑӈхәԓайәт\". ");
INSERT INTO kca_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ԓўв щиты йŏхԓы йастәс: \"Турәм йасәӈ хуԓәтты пӑ йасәӈ хўват уԓты ŏтәт – щитәт Ма аԋԏем пӑ Ма ху апщиԓам\". ");
INSERT INTO kca_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","И хӑтәԓән Иисус утәԓтәты йохԓаԓ пиԓән хопа ԓэԓәс пӑ йастәс ԓывиԓаԓа: \"Ԓор тўм пелка ўшԓув\". Щӑԓта мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Мӑнмеԓ сыс Ԓўв иԓ вŏйәпса. Ԓорән ун вота йис, хўмпәтән эԓт хӑщ мӑнԓайәт, пӑ ԓыв туп сŏртэԓа йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Иисус хŏща вана ԋўрман, Ԓўвеԓ нŏх кўрәтсэԓ пӑ йастәсәт: \"Утәԓтәты Ху! Утәԓтәты Ху! Щи пӑрԓув\". Нŏх киԓмаԓән, Ԓўв вот пӑ хўмпәт иԓ вŏԓәтсәԓы; щӑԓта ромәпсәт, пӑ шитама йис. ");
INSERT INTO kca_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Щиӈәԋща Ԓўв утәԓтәты йохԓаԓ пеԓа йастәс: \"Хŏта нын эвԓәпсайән?\" Ԓыв, пӑԓман пӑ пакәнман, кўтэԓән пŏтәртсәт: \"Хŏй щит щимәщ, вотәта па йиӈка партәԓ, Ԓўвеԓа ԓыв хуԓәтԓәт?\" ");
INSERT INTO kca_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Галилея шŏма уԓты Гадара мўва йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Хун Иисус ўты ŏхԓәс, Ԓўв йэщаԓтәԓ вошән уԓәм и хŏйат этәс. Ԓўв хўв тэԓән кўԉәтән ԓŏӈман уса па ԓумәтты сŏха ӑт ԓумәтԓыйәс, ӑнтом хот ԓыпийән, ӑпайәт пŏнәм кев хŏшапәт ԓыпийән ус. ");
INSERT INTO kca_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Иисус шийаԓәмаԓ кемән, ԓўв ўваԓтәс, Иисус йэԓпийа иԓ рӑкнәс пӑ сыйәӈ тўрән йастәс: \"Нӑӈен ма хŏщайэм мўй вер, Иисус, Нўм Турәм Пŏх? Нӑӈен пойәкԓэм, мӑнэм аԓ шукаты!\" ");
INSERT INTO kca_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Иисусән кўԉ тӑм хŏйат эԓты ким этты партса, ԓўв щишән ўвәс. Ин унты кўԉән ар пўш мŏщатыса пӑ шукатыса, карты кеԓән йошԓаԓ кўрԓаԓ хŏԓна иԓ йӑрыԓысайәт, щиты шависа, туп ищипа карты кеԓәт ԓўв лакки мӑшԓәԓы, пӑ кўԉән атэԓт тӑхайа воштәԓа. ");
INSERT INTO kca_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Иисус ԓўвеԓ иԋщәссәԓы: \"Нӑӈ нэмен мўй?\" Щитэн йастәс: \"Легион\", ԓўв хŏщайәԓа шек ар кўԉ ԓŏӈман ус. ");
INSERT INTO kca_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ԓыв Иисус пойәксэԓ, пӑтыԓы ўса ԓыв ӑт ат китсайәт. ");
INSERT INTO kca_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Щита, кев ԓŏӈәԓән пурәщ тащ ԓӑрпиԓәмаԓ; кўԉәт Иисус пойәксэԓ, ԓуԓән ԓывиԓаԓ пурщәт ԓыпийа ԓŏӈты ат эсәԓсәԓы. Ԓўв эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Кўԉәт хŏйат эԓты ким этмеԓ йўпийән, пурщәт ԓыпийа ԓŏксәт, пӑ пурәщ тащ кев веш эԓты ԓора иԓ керәптыйәс пӑ щита щи иԓ шуйԓәс. ");
INSERT INTO kca_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Тащ шавийәм хŏйатәт, щит шийаԓәмеԓ кемән, сӑм мӑнман хухәԓмәсәт пӑ вошән, куртәтән уԓты хŏйатәта пŏтәртсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Тыйәм вер ватты ким этсәт; Иисус хŏща йŏхәтмеԓән, ԓыв кўԉәтән хӑйәм хŏйат шийаԓәсәт, Иисус пўӈәԓән опсәс, ԓумәтԓыман, ŏшәԓән ус; щиӈәԋща, пӑԓтамәсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Вантәм мŏхет пӑ ԓывиԓаԓа пŏтәртсэԓ, хŏты кўԉәӈ ху тўмтака йис. ");
INSERT INTO kca_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Гадара вош ԉэп мўвән уԓты хŏйатәт хŏԓ Иисус пўӈԓа мӑнты партсэԓ, шек ун пӑԓщәмән йŏхәтсайәт, щишән. Ԓўв хопа ԓэԓәс пӑ йŏхԓы мӑнты питәс. ");
INSERT INTO kca_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Кўԉәтән хӑйәм хŏйат Ԓўв пўӈԓәԓән уԓты пӑтән ўратәс. Туп Ԓўв ин ху щиты йастәман китсәԓы: ");
INSERT INTO kca_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","\"Йŏхи хотэна мӑна, пӑ пŏтәрты, мўй нӑӈена Турәм верәс\". Ԓўв мӑнәс пӑ вош хўватән сыйәӈа пŏтәртәс, мўй ԓўвеԓа Иисус верәс. ");
INSERT INTO kca_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Хун Иисус йŏхԓы йŏхтәс, ар хŏйатән ўщайән верса, хŏԓыйэ Ԓўвеԓ ԓавәԓсәт, щишән. ");
INSERT INTO kca_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Щӑԓта, Ԓўв хŏщайәԓа Иаир нэмпи ики, Турәм йасӈа утәԓтәты хот куща, йŏхтәс; Иисус кўрӈән хŏща хŏмта иԓ шаншатман, Ԓўвеԓ ԓўв хотәԓа ԓŏӈты вохсәԓы; ");
INSERT INTO kca_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ԓўв кӑтхŏщйаӈ тӑԓ ԓŏват кем эви, туп и ԋаврэм, тӑйәс пӑ щитәԓ пӑрты кема йис, щишән вохсәԓы. Хун Ԓўв Иаир пиԓән шушәс, Иисус ар хŏйатән лӑп нӑпәтса. ");
INSERT INTO kca_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ԓыв кўтэԓән и нэ ус, кӑтхŏщйаӈ тӑԓ кӑԓыйән этәԓтәса; ԓўв ԉэккарәта, мўйкем ŏх, пŏрмас тӑйәс, хŏԓ мӑсԓы, нэмәԓты ŏтԓаԓән йӑмәԓтты ӑт верәтса; ");
INSERT INTO kca_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Иисус хŏща шӑш пеләк сӑхат ԓўв вана хӑтәс, Ԓўв сŏхәԓ кимԓа йошән хӑнәмтыйәс, и мŏхты кӑԓэԓ мӑнты нŏх вŏԓыйәс. ");
INSERT INTO kca_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Щиӈәԋща Иисус ищмәс: \"Хŏй Ма хŏщайэма хӑнәмтыйәс?\" Хун хŏйатәт иса йастәсәт: \"Ӑнтом ма, ӑнтом ма\", Петра пӑ Иисус пиԓән уԓәм па мŏхет йастәсәт: \"Утәԓтәты Ху, Нӑӈ ар хŏйатән керәтман ԓойԓайән, пӑ тӑӈәртԓайән, Нӑӈ хŏԓна иԋщәсԓән: \"Хŏй Ма хŏщайэма хӑнәмтыйәс?\" ");
INSERT INTO kca_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Иисус пӑ йастәс: \"Ӑнта, Ма хŏщайэма а хŏй хӑнәмтыйәс, Ма эԓтэм йур шўкем этмаԓ щащәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ин нэ ватԓәԓы, хӑнәмтыйәм верәԓ ӑт пентәс, сӑмәԓ мӑнман, вана мӑнәс пӑ Иисус йэԓпийән хŏмта иԓ шаншантәс. Ԓўвеԓа, хŏйатәт хуԓәтман, йастәсԓы, мўй урәӈән Ԓўв хŏщайәԓ хӑнәмтыйәс, пӑ ищи кўрәмән тўмтака йис. ");
INSERT INTO kca_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Иисус щиты йастәс ԓўвеԓа: \"Эвийэм, аԓ пӑԓа, нӑӈ эвԓәпсайэнән нӑӈ нŏх пайәтсайән; йӑм нŏмәсән мӑна\". ");
INSERT INTO kca_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Хун Ԓўв хŏԓна щит пŏтәрмаԓән, Турәм йасӈа утәԓтәты хот куща, ԓўв хотәԓ эԓты и хŏйат йŏхтәс пӑ ԓўвеԓа йастәс: \"Нӑӈ эвен пӑрәс, Утәԓтәты Ху хŏща аԓ тŏрастыйа\". ");
INSERT INTO kca_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Иисус щи йасӈәт хуԓмаԓ кемән, ԓўвеԓа йастәс: \"Аԓ пӑԓа. Туп эвԓа, пӑ эвен сŏрәм эԓты нŏх пайәтԓа\". ");
INSERT INTO kca_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ԓўв хотәԓа йŏхәтмаԓән, Иисус нэмәԓты хŏйата йŏхи ԓŏӈты ӑт эсԓәс, туп Петрайа, Иоанна па Иакова, пӑ эви ащийа, аԋԏийа. ");
INSERT INTO kca_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Хŏԓыйэ эви урәӈән хоԓԓәсәт, ирӈәԓтысәт. Туп Иисус йастәс: \"Аԓ хоԓԓаты; ԓўв ӑнта пӑрәс – ԓўв ŏԓәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ԓыв уйәтԓэԓ - эви йӑна пӑрәс, щишән Ԓўв эԓтэԓ ԋӑхты питсәт. ");
INSERT INTO kca_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Иисус ԓывиԓаԓ хŏԓ ким воштәсԓы пӑ эви йошәԓ эԓты катәԓсәԓы, такан йастәс: \"Ԋаврэмийэ! Нŏх ԓойа\". ");
INSERT INTO kca_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Щӑԓта эви ԓыԓән йŏхәтса; ԓўв мŏхты нŏх ԓойәс, Иисус ԓўвеԓ ԓапәтты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ащеԓ-аԋԏеԓ ӑԓ пакнысыстән. Иисус пӑ нэмәԓты хŏйата щи вер эԓты пŏтәртты ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Кӑтхŏщйаӈәԓ вохмаԓ йўпийән, ԓывиԓаԓа кўԉәт воштәты, мушәт йӑмәԓты йур пӑ партатты щир мӑс, ");
INSERT INTO kca_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","пӑ ԓывиԓаԓ Турәм Хон Уԓәпса эԓты сыйәӈа пŏтәртты, мушәӈ хŏйатәт тўмтака верты китсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Щӑԓта ԓывиԓаԓа йастәс: \"Пӑтән нэмәԓты аԓ ўйаты, - ӑнта шушты сўв, ӑнта хир, ӑнта ԋаԋ, ӑнта ŏх, ӑнта кимет ԓумәтты сŏх; ");
INSERT INTO kca_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","мўйсыр хота ԓŏӈԓәты, щита хӑщаты, щиԓта йэԓԓы мӑнаты. ");
INSERT INTO kca_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Хŏта вана ӑт ки ўԓайты, щи вош эԓты эттанән, кўрԓән эԓты хиш иԓ пӑркатаԓән. Щит ԓывиԓаԓа нўра ат питәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ԓыв мӑтсәт, пӑ куртәт сӑхат кашәӈ тӑхайән Йӑм айкеԓ тутԓыман пӑ мушәӈ хŏйатәт йӑмәԓтман йӑхсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ԋӑԓмет мўв щуӈ кущайа уԓты Ирод ики, Иисус верәм верәт эԓты хуԓмаԓ кемән, нŏпсәԓ ԓыԓԓәс: хŏй йастәԓ, мӑтты щит Иоанн пӑрмаԓ эԓты нŏх ԓыԓәӈԓәс, ");
INSERT INTO kca_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","тухԓәт пӑ – Илия сэма этәс, па хŏйатәт пӑ – катра уԓәм Турәм йасәӈ туты икет эԓты мӑтты ŏт нŏх ԓыԓәӈԓәс. ");
INSERT INTO kca_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ирод йастәс: \"Ма Иоанн ŏхәԓ хŏԓт пайәтсэм; а хŏй Тӑм Хŏйат, Хŏй эԓты ма тӑмәщ айкеԓ хуԓԓәм?\" Пӑ Ԓўвеԓ ватты урәӈән, мŏԓты щир кӑшты питәс. ");
INSERT INTO kca_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Апостоләт йŏхԓы йŏхәтмеԓән, мўй версәт, Иисуса иса пŏтәртсэԓ; щӑԓта Ԓўв, щитԓаԓ пӑтән ўйман, Вифсаида вош ԉэпән уԓты атэԓ тӑхайа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Хŏйатәтән щи вер мŏштәм кемән, Ԓўв хŏщайәԓ мӑтсәт. Ԓўв, щи мŏхет вана усԓы, ԓывиԓаԓа Турәм Хон Уԓәпса эԓты пŏтәртәс пӑ хŏй тўмтака верты мосәс, щит тўмтака версәԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Хӑтәԓ йэтна пелка йиты питәс. Кӑтхŏщйаӈ утәԓтәты йохԓаԓ Ԓўв ԉэпәԓа вана хӑтман, йастәсәт: \"Мŏхет эсԓаԓән, ванән уԓты куртәта хоԓты пӑ ԓэтәт кӑшты ат мӑнԓәт; мўӈ тӑта таԓ тӑхайән уԓԓув\". ");
INSERT INTO kca_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ԓўв пӑ йастәс: \"Нын ԓывиԓаԓ ԓэтәтән мийаԓән!\" Ԓыв йастәсәт: \"Мўӈ вет ԋаԋ, кӑт хўԓ тўмпийән па ӑт тӑйԓув; мосәӈ мўӈева тӑм хŏйатәт урәӈән ԓэтәт ԓутты йӑхты?\". ");
INSERT INTO kca_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Щита вет щŏрәс кем йох хŏйат ус. Иисус утәԓтәты йохԓаԓа йастәс: \"Ԓывиԓаԓ и пўӈԓа ветйаӈ хŏйат аратән опсәԓтаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Щӑԓта ԓыв щиты версэԓ, иса хŏԓ опсәԓтсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ԓўв, вет ԋаԋ, кӑт хўԓ ўйман, турәм пеԓа нŏхԓы ӑӈкәртман, пойәкщәман, Турма пумащипа йасӈәт йастәс, морәтсәԓы пӑ утәԓтәты йохԓаԓа мӑсԓы, мира ортты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Щӑԓта ԓэсәт пӑ хŏԓ тӑрәпсайәт; пӑ хӑщәм ԋаԋ пўләт кӑтхŏщйаӈ кураԋэк арат ӑкәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","И пўш, хун Ԓўв атэԓт тӑхайән пойәкщәман ус, пӑ утәԓтәты йохԓаԓ Ԓўв пиԓәԓән усәт, йухәт Ԓўв ԓывиԓаԓ ищмәсԓы: \"Хŏйатәтән Ма хŏй йўкана тӑйԓайәм?\" ");
INSERT INTO kca_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ԓыв йŏхԓы йастәсәт: \"Иоанн йиӈка ԓŏӈәԓтыты хŏйат йўкана, тухԓәтән пӑ – Илия йўкана; па хŏйатәт пӑ йастәԓәт, катра пŏрайән уԓәм Турәм Йасәӈ туты икет эԓты и мӑтты ŏт нŏх ԓыԓәӈԓәс\". ");
INSERT INTO kca_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ԓўв ԓывиԓаԓ ищмәсԓы: \"Нын пӑ хŏй йўкана Мӑнэм тӑйԓәԓән\". Петра йŏхԓы йастәс: \"Турәмән китәм Христоса\". ");
INSERT INTO kca_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Туп Иисус ԓывиԓаԓа щит эԓты нэмәԓты хŏйата пŏтәртты шек такан ӑт эсәԓсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","йастәс: \"Хŏйат Пŏха мосәԓ ар шук туты, уна уԓты икетән, Турма йир верты хŏйатәт ŏх икетән, Закона утәԓтәты икетән вана ӑт ўты вер уԓ, пӑ пӑратты вер уԓ, щӑԓта хуԓмет хӑтәԓән нŏх ԓыԓәӈԓәты верәԓ уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ԓўв хŏԓ хŏйатәт пеԓа йастәс: \"Хŏй Ма йўпемән йиты ԓӑӈхаԓ ки, ԓўв эԓтайәԓ ат йŏрэмәԓ, пернайәԓ ат ўԓ, пӑ Ма йўпемән йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Хŏй уԓәпсайәԓ шавиты ки ԓӑӈхаԓ, щит ԓўвеԓ уштәԓԓы; хŏй уԓәпсайәԓ Ма урӈема уштәԓԓы ки, щит ԓўвеԓ шавиԓԓы. ");
INSERT INTO kca_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Мўй ŏнтас хŏйата, уԓты омәсты мир иса йоша пайәтԓәԓы ки, ԓўвеԓ пӑ ԓўв пӑратԓәԓы, мўй пӑ ԓўвеԓ ԓўв атәм верәԓ? ");
INSERT INTO kca_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Хŏй Ма эԓтэм пӑ Ма йасәӈԓам эԓты йэԓамтыты питәԓ, щи хŏйат эԓты Хŏйат Пŏх ищи йэԓамтыты питәԓ, хун Ԓўв хутԓәты–вŏрԓәты щирәԓән, щӑԓта Ащэԓ пӑ йэмәӈ ангеләт хутԓәты–вŏрԓәты щирән йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Йӑна нынана йастәԓәм: тӑта ԓойты хŏйатәт эԓты тухԓәт, Турәм Хон Уԓәпса шийаԓәтэԓ унты, сŏрма ӑт питԓәт. ");
INSERT INTO kca_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Щи йасәӈԓаԓ йўпийән, ԋийәԓ кем хӑтәԓ хӑщәм йўпийән, Иисус Петра, Иоанн пӑ Иаков пӑтән ўйман, кев ԓŏӈԓа нŏх хуӈхәс, пойәкщәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Хун Ԓўв пойәкщәс, веш хŏрасәԓ па хŏрпийа йис, ԓумтәмԓаԓ нŏвийа йисәт, вŏрԓәты питсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Щӑԓта, кӑт ики Ԓўв пиԓәԓән пŏтрэмәсӈән. Щит Моисей пӑ Илия усӈән; ");
INSERT INTO kca_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ԓын хутԓыман–вŏрԓыман этсәӈән, Иисус тӑм уԓәпса эԓты мӑнты верәԓ эԓты пŏтәртсәӈән, мўй Ԓўвеԓ Иерусалим вошән верты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Петра пӑ ԓўв пиԓәԓән уԓәм йохӈиԓаԓ оԓәмән ԓавәртамәсайәт; туп нŏх верԓәмеԓән, Иисус хутԓәты–вŏрԓәты щирәԓ пӑ Ԓўв пиԓәԓән ԓойәм щи кӑт икеӈән, шийаԓәсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Хун ԓын Ԓўв эԓтайәԓ йэԓ мӑнты питсәӈән, Петра Иисуса йастәс: \"Утәԓтәты Ху! Тӑта мўӈева йӑм уԓты; хуԓәм ԓэпәс хот верԓув: ит – Нӑӈена, ит – Моисейа, ит – Илияйа\", - мўй пŏтәртәс ӑт уйәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Хун ԓўв щит пŏтәртмаԓән, пӑԓәӈ этәс пӑ ԓыв эԓтэԓа иԓ эсԓәщәс; хун пӑԓӈа ԓŏксәт, ԓыв шек пӑԓтамәсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Пӑԓәӈ эԓты тўр сый ус, щащыԓыйәс: \"Тӑм – Ма сӑмема мосты Пŏхем, Ԓўвеԓа хуԓәнтаты\". ");
INSERT INTO kca_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Хун щи тўр сый щащәс, Иисус утща хӑщәс. Ԓыв мӑшйайа йисәт, пӑ мўй ватсәт, нэмәԓты хŏйата щи пŏрайән ӑт пŏтәртысэԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Кимет хӑтәԓ, хун ԓыв кев эԓты иԓ ŏхәԓсәт, Ԓўв ар хŏйатән йэщаԓ этса. ");
INSERT INTO kca_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Шӑмкапан, а хŏй ху мир кўт эԓты ўваԓтәс: \"Утәԓтәты Ху! Щи ԓŏват йӑм вера, Нӑӈ пŏхем пеԓа ӑӈкәрмийа, ԓўв ма туп тӑйты и ԋаврэмем: ");
INSERT INTO kca_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ԓўв кўԉән ԓŏӈтыԓа, щӑԓта ԓўв роман ўваԓтәԓ, пӑ ԓўвеԓ шукатԓәԓы, пӑ ўӈԓәԓ эԓты ԋавәр мӑнәԓ; пӑ йӑма шукаттаԓ йўпийән ўрайән ԓўв эԓтэԓ йэԓ мӑнәԓ. ");
INSERT INTO kca_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ма Нӑӈ утәԓтәты йохԓан, щи кўԉ воштәты урәӈән, вохсәԓам, пӑ ԓыв ӑт верәтсәт\". ");
INSERT INTO kca_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Иисус пӑ йŏхԓы йастәс: \"Ӑт эвәԓты пӑ вевтама нумәсты хŏйат рут! Мўй унты Ма нын пиԓанән уԓты пӑ нынан верәтты питԓәм! Пŏхен ты тўви\". ");
INSERT INTO kca_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Хун щи пŏх шушәс, кўԉ ԓўвеԓ мўва иԓ вŏщкәсԓы пӑ кӑмән щирән тӑрӈәԓтты питсәԓы; туп Иисус ԋаврэм кетәмты кўԉа ӑт эсәԓсәԓы, пŏх тўмтака версәԓы пӑ ԓўв ащеԓа ԓўвеԓ мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Иса хŏԓ Турәм ун йурәԓ эԓты туп ӑԓ пакнысысәт. Хун пӑ хŏԓыйэ Иисус верты верәт эԓты ӑԓ пакнысысәт, Ԓўв утәԓтәты йохԓаԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","\"Тӑм йасӈәт нын нŏпсәна пŏнаԓән: Хŏйат Пŏх хŏйатәт йоша мӑԓа\". ");
INSERT INTO kca_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ԓыв щи йасәӈ ŏша ӑт пŏтсэԓ, пӑ ԓыв эԓтэԓ щит лӑп уса, щишән ԓыв ӑт мŏштәсэԓ, Ԓўвеԓ щит эԓты ищмәты пӑ ԓыв пӑԓсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ԓывиԓаԓа и нŏмәс йŏхтәс: хŏй ԓыв кўтэԓән вŏԓаӈшәк? ");
INSERT INTO kca_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Иисус ԓыв сӑмԓаԓән тӑйты нŏмәсԓаԓ ватман, ԋаврэм ўсԓы пӑ Ԓўв йэԓпәԓа ԓощәԓтәсԓы ");
INSERT INTO kca_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","пӑ ԓывиԓаԓа йастәс: \"Хŏй тӑм ԋаврэмийэ Ма нэмем урәӈән вана уԓԓы, щит Мӑнэм вана уԓԓы; хŏй Мӑнэм вана уԓԓы, щит Мӑнэм Китәм Ŏт вана уԓ; хŏй нын эԓтан мет айшәк, щит вŏԓаӈ питәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Щи пўԉаӈ Иоанн йастәс: \"Утәԓтәты Ху! Мўӈ и хŏйат ватсув, ԓўв Нӑӈ нэменән кўԉәт воштәԓ, пӑ ԓўвеԓ нŏх вŏԓәтсэв, ԓўв мўӈ пиԓэвән Нӑӈ йўпенән ӑт йӑӈхәԓ, щишән. ");
INSERT INTO kca_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Иисус Иоанна йастәс: \"Аԓ вŏԓытаԓән, хŏй ӑнта нын йэщаԓтән уԓ, щит нын пеԓайән уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Хун Ԓўвеԓ мир уԓәпса эԓты нŏх ўты пŏра ванамәс, Ԓўв Иерусалим воша мӑнты нŏмәс верәс; ");
INSERT INTO kca_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","щишән айкеԓ туты йохԓаԓ Ԓўв йэԓпеԓән китсәԓы; щиӈәԋща ԓыв мӑтсәт пӑ Самария мŏхет курта йŏхәтсәт, Ԓўв урӈәԓән мўй иса ԓэщатты. ");
INSERT INTO kca_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Туп щита Ԓўв вана ӑт эсәԓса, Ԓўв Иерусалим воша шушәс, щишән. ");
INSERT INTO kca_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Щит шийаԓәмаԓән, Ԓўв утәԓтәты кӑтӈиԓаԓ, Иаков пӑ Иоанн, йастәсӈән: \"Турәм Куща, Нӑӈ ԓӑӈхаԓән ки, мўӈ йастәԓув, турәм эԓты тўт иԓ ат ŏхәԓәԓ, ԓывиԓаԓ ат пӑратԓәԓы, хŏты Илия верәс?\" ");
INSERT INTO kca_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Туп Ԓўв, ԓын пеԓайԓәна карэмәман, ԓынан нўрысԓы пӑ йастәс: \"Ӑт уйәтԓәԓән, мӑты ԓыԓ эԓты нын уԓԓәтән?\" ");
INSERT INTO kca_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Хŏйат Пŏх ӑнта хŏйатәт уԓәпса пӑратты йŏхтәс, нŏх пайәтты\". Щишән ԓыв па курта мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Щиты тыйәс, хун ԓыв мӑнмеԓән, и мӑтты ŏт Ԓўвеԓа йастәс: \"Турәм Куща! Ма Нӑӈ йўпенән мӑнԓәм, хŏԓта кепа Нӑӈ ат мӑтсән\". ");
INSERT INTO kca_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Иисус ԓўвеԓа йастәс: \"Ŏхсарәт ух тӑйԓәт, щищкет - тыхәԓ, Хŏйат Пŏх пӑ ŏхәԓ пŏнты тӑха ӑт тӑйәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Кимет хŏйата Ԓўв йастәс: \"Ма йўпемән йўва\". Щитэн йастәс: \"Турәм Куща, мӑнэм оԓәӈән йŏхи йӑхты эсԓы, пӑрәм ащем иԓ ԓэщатты\". ");
INSERT INTO kca_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Туп Иисус ԓўвеԓа щиты йастәс: \"Пӑрәм хŏйатәта хӑԓайԓаԓ ԓывиԓаԓа иԓ ԓэщатты хӑйи, нӑӈ пӑ мӑна, Турәм Хон Уԓәпса эԓты такан пŏтәрта. ");
INSERT INTO kca_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Хŏԓна хуԓмет хŏйат па йастәс: \"Турәм Куща, ма Нӑӈ йўпенән мӑнԓәм, туп йэԓпи мӑнэм йŏԓән уԓты мŏхиԓам пиԓән пайәмуԓәм верты эсԓы\". ");
INSERT INTO kca_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Иисус ԓўвеԓа йастәс: \"Нэмәԓты хŏйат, хŏй йошәԓ мўв шўкатты ŏта пŏнмаԓ йўпийән пӑ йŏхԓы ӑӈкәртыйәԓ, Турәм Хон Уԓәпсайа ӑт рӑхәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Тӑм йўпийән, Турәм Куща па ԓапәтйаӈ утәԓтәты хŏйат пирыйәс, пӑ ԓывиԓаԓ кӑтәнән Ԓўв йэԓпеԓән кашәӈ воша пӑ кашәӈ тӑхайа китсәԓы, хŏԓта Ԓўв йӑхты ўтщийәс, ");
INSERT INTO kca_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","щӑԓта ԓывиԓаԓа йастәс: \"Ӑкәтты вер ун, туп рупәтты хŏйат шимәԓ; щишән, ӑкәтты вер пеԓа уԓты Куща пойкаԓән, ԓуԓән Ԓўв рупәтты хŏйат, ӑкәтты вер урәӈән, ат китәс. ");
INSERT INTO kca_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Мӑнаты! Ма нынан ош пŏшхәт иты атәԓән йӑхты ŏтәт кўта китԓәԓам. ");
INSERT INTO kca_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Нэмәԓты пӑтән аԓ ўйаты: ӑнта тўтхот, ӑнта хир, ӑнта кўра ԓумәтты ŏт, пӑ йушән нэмәԓты хŏйат хŏща, ўщайән верты урәӈән, иԓ аԓ ԓойаты. ");
INSERT INTO kca_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Мӑтты хота ԓŏӈтанән, оԓәӈән йастаты: \"Тӑм хота йӑм уԓәпса!\" ");
INSERT INTO kca_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Щита йӑм нŏмәс нŏх катԓәпты хŏйат ки уԓ, нын йӑм нŏпсән ԓўвеԓа питәԓ, ӑнта ки – нынана йŏхлы йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Щи хотән хӑщаты, щит ԓэваты па йиԋщаты, мўйән мӑԓайты, рупәтты хŏйат рупәттаԓ урәӈән мŏԓтыйән сŏхәптәԓа. И хот эԓты кимет хота аԓ йӑӈхаты. ");
INSERT INTO kca_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Мӑтты воша йŏхәтԓәты ки пӑ щита вана ўԓайты ки, мўйән мӑԓайты, щит ԓэваты, ");
INSERT INTO kca_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","пӑ щита уԓты мушәӈ хŏйатәт йӑмәԓтаԓән пӑ ԓывиԓаԓа пŏтәртаты: \"Турәм Хон Уԓәпса нын хŏщайәна ванамәс!\" ");
INSERT INTO kca_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Мӑтты воша йŏхәтԓәты ки пӑ щита вана ӑт ўԓайты, ким эттан йўпийән йастаты: ");
INSERT INTO kca_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Мўӈ хŏщайэв хӑнәм нын вошәӈ хишԓән нынана пӑркатԓыԓув; туп уйтаты, Турәм Хон Уԓәпса нын хŏщайәна ванамәс\". ");
INSERT INTO kca_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Пŏтәртԓәм нынана, Содом воша тӑм вош эԓты сўт верты хӑтәԓән кеншәк питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Шук нӑӈена, Хоразин! Шук нӑӈена, Вифсаида! Нын хŏщайән тыйәԓтыйәм йурәӈ верәт, Тир па Сидон вошӈән хŏща тыйәԓтысайәт ки, хўвән ԓуԓән, вевтам сŏхән пӑ рат хиш кўтән омәсман, ԓыв кӑрэкԓаԓ эԓты шӑшән керԓәсәт. ");
INSERT INTO kca_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Тира пӑ Сидона сўт верты хӑтәԓән нын эԓтан кеншәк питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Нӑӈ пӑ, нўм турма нŏх пайтәсәм Капернаум, иԓта турма иԓ вŏщкиԓайән! ");
INSERT INTO kca_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Нынан хуԓәтты ŏт, Мӑнэм хуԓәтәԓ, хŏйән нын вана ӑт ўԓайты, щитән Ма вана ӑт ўԓайәм; Мӑнэм вана ӑт ўты хŏйат, щит Мӑнэм Китәм Ŏт вана ӑт ўԓ\". ");
INSERT INTO kca_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ԓапәтйаӈ утәԓтәты хŏйат амтәтԓыман йŏхԓы йŏхәтсәт пӑ пŏтәртсәт: \"Турәм Куща! Кўԉәт хŏԓна мўӈева хуԓәтԓәт, хун мўӈ Нӑӈ нэмен айәԓԓув!\" ");
INSERT INTO kca_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Иисус ԓывиԓаԓа йастәс: \"Ма ватсәм, хŏты сатана похәл тўт иты турәм эԓты иԓ рӑкнәс! ");
INSERT INTO kca_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ин щи ма нынана, ŏхты войәт эԓты, скорпион войәт эԓты па хŏԓ хиԋ йурәт эԓты пурәтты щир мӑсәм пӑ нэмәԓты хŏтащ ӑт йиԓты. ");
INSERT INTO kca_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Туп, ӑнта щи кўԉәт нынана хуԓәтты урәӈән амтәтԓыйаты, нэмԓән турәмән хӑшман уԓԓайәт, щи урәӈән амтәтԓыйаты\". ");
INSERT INTO kca_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ищишән Йэмәӈ Ԓыԓ Иисус амәтән тэкнәптәсԓы, пӑ Иисус йастәс: \"Ащийэ, турәм пӑ мўв Куща, Нӑӈ вŏԓаӈ щирэн щи урәӈән айәԓԓэм, мўй Нӑӈ мўтрайәӈ пӑ ŏшәӈ хŏйатәт эԓты тӑм иԓ хӑԋатсэн пӑ щит ай ԋаврэмәта эԓпа этәԓтәсэн. Йӑна, Ащийэ! Шиты Нӑӈена мосәс!\" ");
INSERT INTO kca_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Утәԓтәты йохԓаԓ пеԓа, каремәман, йастәс: \"Ащемән хŏԓ Мӑнэма мӑса; Пŏх –Ԓўв хŏй, Ащэԓ тўмпийән нэмәԓты ŏтән ӑт уйәтԓа, Ащи – Ԓўв хŏй, Пŏхәԓ тўмпийән нэмәԓты ŏтән ӑт уйәтԓа, пӑ хŏйа Пŏх Ащеԓ этәԓтәты ԓӑӈхаԓԓы. ");
INSERT INTO kca_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Щӑԓта, утәԓтәты йохԓаԓ пеԓа карэмәман, ԓывиԓаԓа утща щира йастәс: \"Щи сэмәт щўԋәӈәт, хŏй нын ватты ŏтԓән ватԓәт. ");
INSERT INTO kca_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Йӑна нынана пŏтәртԓәм , ар Турәм йасәӈ туты хŏйат пӑ хонәт, мўй нынанән ныԓа, щит ватты ԓӑӈхасәт пӑ ӑт ватсәт, мўй нын хуԓԓәты, щит хуԓты ԓӑӈхасәт, пӑ ӑт хуԓсәт\". ");
INSERT INTO kca_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","И пўш, Закона утәԓтәты и ики нŏх ԓойәс пӑ, Иисус артаԓәты урәӈән, ищмәсԓы: \"Утәԓтәты Ху! И пўша уԓты уԓәпса мŏщатты урәӈән, мӑнэма мўй верты мосәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Иисусән пӑ ищмәса: \"Закон хŏща мўй хӑшман уԓԓа? Мўй ԓўӈәтԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Щитэн йŏхԓы йастәс: \"Турәм Кущайэн нӑӈ Турмен арат сӑменән, арат ԓыԓэнән, арат йурэнән, арат ŏшенән сӑмәӈа тӑйи, пӑ ванән уԓты хŏйатэн ищи сӑмәӈа тӑйи, хŏты нӑӈен нӑӈ сӑмәӈа тӑйԓэн\". ");
INSERT INTO kca_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Иисус ԓўвеԓа йастәс: \"Нӑӈ йӑна йастәсән; щиты вера, пӑ уԓты питԓән\". ");
INSERT INTO kca_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Щитэн, ԓўвеԓ йӑма пайәтты ԓӑӈхаман, Иисус ищмәсԓы: \"Ма ванән уԓты хŏйатэм – хŏй?\" ");
INSERT INTO kca_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ши йасәӈ пеԓа Иисус йастәс: \"И хŏйат Иерусалим эԓты Иерихон воша шушәс пӑ хорахщетән мŏщатса. Щитәтән ԓумтәмԓаԓ хŏԓ нŏх эхсайәт, напрыйэ сэкса пӑ туп ай ԓыԓыйэԓ хӑйса, ин ŏтәт мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Щи пŏрайән йуш хўват и Турма йир верты хŏйат шушәс пӑ ԓўвеԓ шийаԓәмаԓ кемән, ԓўв пўӈԓәԓ эԓты мŏхты мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Левит ики ищи, хун щи шома йŏхтәс, вана шушиԓыйәс, ватсәԓԓы па ԓўв пўӈԓәԓ эԓты йэԓԓы мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Самария мўвәӈ и ху, щи йуш хўват мӑнман, ԓўв хŏщайәԓ уйтантәс пӑ, ԓўвеԓ шийаԓәмаԓ кемән, ԓўвеԓ щаԉәтсәԓы ");
INSERT INTO kca_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","пӑ, вана шушәс, ԋўләмԓаԓ оливка вŏйән, ўнайән ԉŏхәтмаԓ йўпийән лӑп йӑрсәԓы; щӑԓта ԓўв осёләԓ шӑнша нŏх омәсман, хоԓты хота ԓўвеԓ тусԓы пӑ щита хŏԓна ԓўвеԓ пӑйкәԓтман тӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Кимет хӑтәԓән пӑ, мӑнтаԓ йэԓпийән, кӑт динарий лакәптәс, хоԓты хотәӈ икийа мӑсԓы пӑ йастәс: ”Тӑм хŏйат ԋоты. Тӑԓта аршәк ки посатԓән, йŏхәттэмән, нӑӈена йŏхԓы мӑԓэм”. ");
INSERT INTO kca_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Нӑӈ хŏты нумәсԓән, тӑм хуԓәм хŏйат эԓты, хорахщет йоша питыԓыйәм ху хŏща, хŏй вана уԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Закона утәԓтәты ики йастәс: \"Хŏй ԓўвеԓа сӑмәӈ вер верәс, щит\". Щишән Иисус ԓўвеԓа йастәс: \"Мӑна, нӑӈ па ищиты вера\". ");
INSERT INTO kca_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Иисус утәԓтәты йохԓаԓ пиԓән йэԓԓы мӑнты йушеԓ хŏща и курта йŏхтәс. Щита Марфа нэмпи нэ йŏԓән Ԓўвеԓ мойԓәты иԓ опсәԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Щи нэ Мария нэмпи хӑнамнэ тӑйәс; Мария Иисус кўрнатән опсәс пӑ Ԓўв йасәӈԓаԓ хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Марфа пӑ Иисус кеша ун ԓэтŏтәӈ пӑсан ԓэщатәԓ, пӑ вана йŏхәтмаԓ кемән йастәс: \"Турәм Куща, Нӑӈена мўй вер ӑнтом, хŏты хӑнамнэӈэм, хот ԓыпи верәт верты, мӑнэм утща хӑйсәԓы? Йасты ԓўвеԓа, мӑнэма ат ԋотәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Иисус пӑ йŏхԓы йастәс: \"Марфа, Марфа! Нӑӈ ар ŏт эԓты нумәсԓән пӑ, сӑм мӑнман, ар вер эԓты нумәсԓән, ");
INSERT INTO kca_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","туп ит мосәԓ; Мария мет йӑм вер пирыйәс, щит ԓўв эԓтэԓ нŏх ӑт ўԓа\". ");
INSERT INTO kca_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Имŏԓты ишән, хун Иисус и тӑхайән пойәкщәс, пӑ нŏх вŏԓымаԓ йўпийән, и утәԓтәты хуйәԓ Ԓўвеԓа йастәс: \"Турәм Куща! Мўӈев пойәкщәты утәԓты, хŏты Иоанн утәԓтәты йŏхԓаԓ утәԓтәс\". ");
INSERT INTO kca_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ԓўв щиты ԓывиԓаԓа йастәс: \"Хун пойәкщәԓты, щиты пŏтәрттаты: \"Турәм Ащев! Турәмән Нӑӈ уԓԓән! Нӑӈ нэмен ат йэмԓәԓ! Нӑӈ Хон Уԓәпсайэн ат йŏхәтәԓ! Нӑӈ партәпсайэн хŏты турәмән уԓ, щиты мўвән ат питәԓ; ");
INSERT INTO kca_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ԓэты ԋаԋэв мўӈева кашәӈ хӑтԓа мийи; ");
INSERT INTO kca_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Мўӈ кӑрэкԓув мўӈева йŏрэмаԓән, хŏты мўӈ хŏйатԓува ԓўв артнайԓаԓ йŏрэмәԓув; атәм хўщәпсайа питты мўӈев аԓ эсԓы, ԉикәӈ ŏт эԓты хŏԓт пайты!\" ");
INSERT INTO kca_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Щӑԓта ԓывиԓаԓа йастәс: \"Мӑттыки нын мӑтŏтән ԓухәс тӑйәԓ, ат кўтәпән ԓўв хŏщайәԓ йŏхәтәԓ пӑ йастәԓ: \"Ԓухсыйэ, мӑнэм хуԓәм ԋаԋ, артнайа мийԓыйа, ");
INSERT INTO kca_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","пиԓхуйэм мӑнтаԓ сӑхат ма хŏщайэм хойәс, ма нэмәԓты ԓўвеԓ ԓапәтты ӑт тӑйԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Щитэн ов мŏхты ԓўвеԓа йастәԓ: \"Мӑнема аԓ тŏрастыйа, овем йӑканән лӑп пŏтсэм, ԋаврэмԓам па ма пиԓэмән ŏԓтӑхайән уԓԓәт. Ма ӑт верәтԓәм нŏх киԓты пӑ нӑӈена ԋаԋ мӑты\". ");
INSERT INTO kca_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Нынана пŏтәртԓәм, ԓўв ԓухсәԓ урәӈән нŏх ӑт ԓойәԓ ки, пӑ ԋаԋ ԓўвеԓа, пиԓа уԓтаԓ хўватән, ӑт мӑԓ ки, щитәԓ такан вохтаԓ урәӈән, ищи пӑ нŏх киԓты вера йиԓ, мўй арат вохәԓ, щи арат ԓўвеԓа мӑԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ма нынана щи йастәԓәм: вохаты, пӑ мӑԓайты, кӑншаты, пӑ уйәтԓәты; ов сэӈкаԓән, пӑ пўшԓа, ");
INSERT INTO kca_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","кашәӈ ŏт, хŏй вохәԓ, мŏщатәԓ, хŏй кӑшәԓ, уйәтәԓ, ов сэкты ŏта, ов пўшԓа. ");
INSERT INTO kca_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Мўй щимәщ ащи, хун пŏхәԓ ԓўв эԓтайәԓ ԋаԋ вохәԓ, щи йўкана кев шупән мӑԓԓы? Хун хўԓ вохәԓ, хўԓ йўкана ŏхты вой мӑԓ? ");
INSERT INTO kca_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Мўй пӑ, карәӈ пŏшәх вохтаԓән, скорпион нэмпи карәӈ хŏмләхән мӑԓԓы? ");
INSERT INTO kca_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Щӑԓта, хун нын ԉик тӑйман, ԋаврэмԓәна йӑм ŏт мӑты хошԓәты, Турәм Ащи мет щи Ԓўв эԓтэԓ вохты хŏйатәта Йэмәӈ Ԓыԓ мӑԓ\". ");
INSERT INTO kca_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","И пўш Иисус уӈәԓԓы пайәтты кўԉ хŏйат эԓты ким воштәсԓы. Хун кўԉ ким этәс, уӈәԓԓы хŏйат пŏтәртты питәс. Хŏйатәт туп ӑԓ пакнысысәт. ");
INSERT INTO kca_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Тухәԓаԓ пӑ пŏтәртсәт: \"Ԓўв кўԉәт веельзевул йурән воштәԓ. Щит кўԉәт ŏх\". ");
INSERT INTO kca_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Па хŏйатәт пӑ Иисус артаԓәман, Ԓўвеԓа мŏԓты пос турәм эԓты этәԓтәты партсәт. ");
INSERT INTO kca_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Туп Ԓўв ԓыв нŏмәсԓаԓ уйәтман, йастәс: \"Кашәӈ, кӑт йэшащты пелка ортәсәм хон мўв, таԓа йиԓ, пӑ хот, хŏта йэшащԓа, иԓ ӑркәпәԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Сатана ԓыпи нŏпсәԓән кӑт щира ки уԓ, мўй щирән ԓўв хон пелкәԓ уԓты верәтәԓ? Нын пŏтәртԓәты, мӑтты Ма веельзевул йурән кўԉәт воштәԓәм; ");
INSERT INTO kca_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ма веельзевул йурән кўԉәт ки воштәԓәм, нын йўпанән йиты йохԓән пӑ хŏй йурән ԓывиԓаԓ воштәԓԓаԓ? Щишән ԓыв нынана сўт верты хŏйатәта питԓәт. ");
INSERT INTO kca_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ма Турәм йурән кўԉәт воштәԓәм ки, уйәтман Турәм Хон Уԓәпса нын хŏщайән йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Хун йурәӈ ŏт ԉаԉәсты пŏрмасы тэԓән хотәԓ шавиԓԓы, ԓўв тащәԓ-вещәԓ нэмәԓты хŏтащ ӑт йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Хун пӑ ԓўв эԓтэԓ йурәӈшәк ŏт ԉаԉәсты йŏхәтәԓ пӑ ԓўвеԓ иԓ пайәтԓәԓы, щи пŏрайән хотәӈ ху нŏмәс пŏныԓыйәм ԉаԉәсты пŏрмасԓаԓ, ԓўв эԓтэԓ нŏх уԓԓы, пӑ ԋӑрэмәм мŏԓтыԓаԓ лакки ортԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Хŏй ӑнтом Ма пиԓэмән уԓ, щит Ма йэщаԓтэм уԓ; хŏй Ма пиԓэмән ӑт ӑкәтәԓ, щит лакки йовәԓәԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Хун кўԉ, хŏйат эԓты ким этәԓ, йикԓы тӑхайәтән йӑӈхәԓ, щўтщәты тӑха кӑшман, пӑ ӑт уйәтман, пŏтәртәԓ: \"Ма хотэма керԓәԓәм-са, хŏԉща этсәм!\". ");
INSERT INTO kca_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Йŏхԓы йŏхәттаԓән, хотәԓ нŏх йовәԓман пӑ нŏх ԓэщатман уйәтԓәԓы; ");
INSERT INTO kca_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","щӑԓта ԓўв мӑнәԓ пӑ па ԓапәт кўԉ туԓ, ԓўв эԓтэԓ мет ԉикәӈәт; ԓыв, ԓыпийа ԓŏӈман, щита уԓты питԓәт. Щиӈәԋща хŏйата оԓәӈ уԓәм эԓты мет атма йиԓ\". ");
INSERT INTO kca_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Хун Иисус щи йасӈәт йастәс, ий ими хŏйат кўт эԓты такан ўваԓтәс: \"Щўԋәӈ щи аԋԏи, хŏйән Нӑӈ сэма пайәтсайән пӑ эсәмән ԓапәтсайән!\". ");
INSERT INTO kca_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Туп Ԓўв йŏхԓы йастәс: \"Щўԋәӈ щит, хŏй Турәм йасәӈ хуԓәԓ пӑ щиты верәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Хун хŏйатәт арән йŏхәтты питсәт, Иисус пŏтәртты питәс: \"Ин тӑм уԓты мир ԉикәӈ. Ԓыв Турәм пос кӑшԓәт, туп Иона Турәм йасәӈ туты ики этәԓтыйәм пос тўмпийа, нэмәԓты Турәм пос ԓывиԓаԓа ӑт питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Хŏты Иона, Нинэвия вошәӈ хŏйатәта, поса ус, щиты Хŏйат Пŏх тӑм уԓты мира поса питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Нўм мўв нэ хон, сўт вертыйән, ин тӑм хŏйат рут пиԓән нŏх ԓойәԓ пӑ ԓывиԓаԓ сўтытԓәԓы, ԓўв Соломон мўтра йасӈәт хуԓәтты урәӈән, мўв кимәԓ эԓты йŏхтыԓыйәс. Ин тӑта пӑ нын пиԓәнән Щит, Хŏй Соломон эԓты вŏԓаӈшәк. ");
INSERT INTO kca_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Нинэвия вошәӈ хŏйатәт ищи, сўт вертыйән, ин тӑм уԓты мир пиԓән нŏх ԓойԓәт, пӑ ԓывиԓаԓ сўтытԓыԓаԓ. Ԓыв Иона йастәм Турәм йасӈәт хуԓәтман, кӑрэкԓаԓ эԓты шӑшән керԓәсәт. Ин тӑта пӑ нын пиԓәнән Щит, Хŏй Иона эԓты вŏԓаӈшәк. ");
INSERT INTO kca_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Нэмәԓты хŏйат тўт сун ўщитман, ԓўвеԓ хӑԋа тӑхайа мўй пӑ хŏшам иԓпийа ӑт омәсԓәԓы, нŏхшәк, тўт акԓа, омәсԓәԓы, ԓуԓән хота ԓŏӈты хŏйатәта нŏви ат ныса. ");
INSERT INTO kca_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ԓыпийән уԓты тўт сун – щит сэм; сэмԓан сыстамәт ки, эԓэн иса нŏвийән тэкәнман уԓԓа, атмәт ки – эԓэн ԓыпийән иса пӑтԓам. ");
INSERT INTO kca_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Щишән ванта: нӑӈ ԓыпийән тӑйты нŏвен мосәӈ пӑтԓам. ");
INSERT INTO kca_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Эԓэн нŏвийән ки тэкәнман уԓԓа пӑ нэмәԓты питы лот ӑт тӑйәԓ ки, щишән иса нŏви питәԓ, хŏты тўт сунән нӑӈ хутԓәптыԓайән\". ");
INSERT INTO kca_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Хун Ԓўв щит пŏтәртәс, и фарисей Ԓўвеԓ хотәԓа йŏхи ԓэты вохсәԓы. Иисус йŏхтәс пӑ пӑсан сурыйа опсәс. ");
INSERT INTO kca_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Иисус ԓэты йэԓпийән йошԓаԓ ӑт ԉŏхәтсәԓы, Фарисей щит шийаԓәмаԓ кемән, пӑ ӑԓ щи пакнәс. ");
INSERT INTO kca_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Туп Турәм Куща ԓўвеԓа йастәс: \"Нын, фарисейәт, анԓән-сунԓән эԓтыԓаԓ сыстапԓәԓән, нын ԓыпиԓән аратэԓән тармәт пӑ ԉикәӈәт. ");
INSERT INTO kca_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ŏтшамәт! Ăнта мўй Щит, Хŏй эԓпат уԓты ŏт тыйәԓтәс, ԓыпийән уԓты ŏт ищи тыйәԓтәс? ");
INSERT INTO kca_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Щикем ушән нўша хŏйатәта анԓәнән мўй тӑйԓәты, щит мийԓыйаты, щи пŏрайән нынана иса сыстам питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Шук нынана, фарисейәт! Мята, рута пӑ арсыр эпԓәӈ тŏрән эԓты йаӈмет шупәԓ мӑԓты, вещкат пӑ Турма сӑма мосты вер эԓты пӑ пўӈԓа ўратԓәты: тӑми верты мосәс, пӑ тўми хӑйты ӑт мосәс. ");
INSERT INTO kca_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Шук нынана, фарисейәт! Нын Турәм йасӈа утәԓтәты хотән ԓӑтәӈ тӑхайәтән омәсты сӑмәӈәт, пӑ хŏйатәт ӑктәщиты тӑхайән нын иса ат ватԓайты, ўщайән иса ат верԓайты. ");
INSERT INTO kca_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Шук нынана, Закона утәԓтәты икет пӑ фарисейәт, нын нэмәԓты щирән ӑт постәм хӑԓа лотәт хŏрпет, хŏйатәтән, ӑт мŏштыман, эԓты шушиԓыԓайәт\". ");
INSERT INTO kca_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Закона утәԓтәты ий ики Ԓўвеԓа йастәс: \"Утәԓтәты Ху! Щиты пŏтәртман, Нӑӈ мўӈев па ԉикән этԓэн!\" ");
INSERT INTO kca_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ԓўв йастәс: \"Нынана, Закона утәԓтәты икета, па шук! Хŏйатәта ԓавәрт вер пŏнԓәты, нын пӑ и ԓуйән нэш ԓўв хŏщайэԓа ӑт хӑнәмтыԓты. ");
INSERT INTO kca_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Шук нынана! Ащиԓәнән пӑратәм Турәм йасәӈ туты хŏйатәт урәӈән, ԓыв ӑпа лотԓаԓ хŏрән верԓәԓән. ");
INSERT INTO kca_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Щитән нын ащиԓән верәм верәт аԉԓәты пӑ ԓыв пиԓԓаԓән кашащԓәты, ԓыв Турәм йасәӈ туты хŏйатәт пӑратсәт, нын пӑ ӑпа лотԓаԓ хŏрән верԓәԓән. ");
INSERT INTO kca_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Щишән Турәм ŏшәӈ нŏпсәԓ йастәс: \"Турәм йасәӈ туты хŏйатәт пӑ апостоләт ԓыв хŏщайэԓа китԓәм, щитәт эԓты тухәԓаԓ пӑратԓайәт, тухәԓаԓ пӑ воштыԓайәт, ");
INSERT INTO kca_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","мўйа Турәм йасәӈ туты хŏйатәт кӑԓы мӑнәԓтса, уԓты турәм тыйәԓтәм уш эԓты, щишән ин уԓты хŏйатәт эԓты щи нўр иԋщәсты питԓа, ");
INSERT INTO kca_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Авель кӑԓы эԓты Захария кӑԓы унты, хŏй йирасты нŏрәм пӑ Турәм Хот кӑт кўтән пӑратса. Йӑна пŏтәртԓәм нынана: ин уԓты хŏйатәт эԓты мўй ус иса кӑшԓа. ");
INSERT INTO kca_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Шук нынана, Закона утәԓтәты хŏйатәта! Нын уйәтты вер щирәԓ усԓән: нын ӑт ԓŏксәты, хŏй ԓŏӈты утщийәс, щит ӑт эсәԓԓәԓән\". ");
INSERT INTO kca_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Хун Ԓўв щит пŏтәртәс, Закона утәԓтәты хŏйатәт пӑ фарисейәт мет такан ўшмащты питсәт, Ԓўвеԓ ар вер эԓты апрәӈа иԋщәсты питсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ԓыв щиты ŏщмарәӈа каншатсәт пӑ верәтты кемеԓән мŏԓты Ԓўв эԓтэԓ мӑтты йасәӈ нŏх кӑтәԓты ўтщисәт, Ԓўвеԓ ўнавота павәттыйа. ");
INSERT INTO kca_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Щи кўтән, щŏрәс мир щиты ӑктәщәс, пӑ хŏйатәт йэрмат кўтән ўратысәт, Иисус, оԓәӈән утәԓтәты йохԓаԓ пеԓа ватман, пŏтәртты питәс: \"Фарисей сŏхәм щир, ԋаԋ шўм хŏрпи, ропхәӈ вер эԓты шаващаты, кӑт вешпийа аԓ уԓаты. ");
INSERT INTO kca_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Нэмәԓты сайԓәм вер ӑнтом, ищипа эԓпа этәԓ, пӑ хӑԋа вер ӑнтом, ищипа уйәтԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Щишән, мўй эԓты нын пӑтламән йастәсты, нŏвийән хуԓԓа, пӑ мўй хот ԓыпийән пӑԓ ўса йастыԓысты, щит хот ԓоӈәԓ эԓты такан йастәԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ма нынана, пиԓйохԓама, пŏтәртԓәм: щитәт эԓты аԓ пӑԓаты, хŏй хŏйат эԓ пӑратәԓ, пӑ нэмәԓты па верты ӑт верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Туп йастәԓәм нынана, хŏй эԓты пӑԓты мосәԓ: Щит эԓты пӑԓаты, хŏй, пӑратмаԓ йўпийән, шук туты тӑхайа пайәтты веритԓәԓы. Йӑна пŏтәртԓәм нынана, Щит эԓты пӑԓаты. ");
INSERT INTO kca_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Вет щищки кӑт пӑтәр ŏх карты сӑхат ӑт тыныԓа? Турәмән ит нэш ӑт йŏрэмәм. ");
INSERT INTO kca_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Нын ŏхԓәнән ŏхсŏхԓән хŏԓна хŏԓ ԓўӈәтман уԓԓайәт. Аԓ пӑԓаты: нын ар ай щищкет эԓты тыныӈшәкәт, сӑмәӈашәк тӑйԓайты. ");
INSERT INTO kca_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Нынана пŏтәртԓәм: кашәӈ хŏйат, хŏй эԓпат Мӑнэм хŏйатәт хŏща, вана уԓԓы, щит Хŏйат Пŏхән ищи Турәм ангеләт хŏща вана ўԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Хŏй хŏйатәт хŏща Ма эԓтэм йŏвра керԓәԓ, щит эԓты па Турәм ангеләт хŏща йŏвра керԓәԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Кўш хŏйа, хŏй йŏвра йасәӈ Хŏйат Пŏха йастәԓ, щи нўрәԓ йŏрэмәԓа; хŏй Йэмәӈ Ԓыԓ эԓты ӑт рӑхты йасәӈ йастәԓ, щит нўрәԓ ӑт йŏрэмәԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Хун нын Турәм йасӈа утәԓтәты хотәта, кущайәт пӑ ŏха уԓты кущайәт хŏща туԓайты, аԓ нумәсаты, хŏты мўй пӑ йŏхԓы йастәԓты, мўй пӑ пŏтәртты верән уԓ, ");
INSERT INTO kca_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Йэмәӈ Ԓыԓ нынан щи пўԉаӈ утәԓтәԓԓы, мўй йастәты\". ");
INSERT INTO kca_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Мŏԓты хŏйат мŏхет кўт эԓты Ԓўвеԓа йастәс: \"Утәԓтәты Ху! Йайәма йаста, ащемән-анԏэмән хӑйәм хот тэԓ ма пиԓэмән ат ортԓәԓы!\" ");
INSERT INTO kca_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Иисус ԓўвеԓа йастәс: \"Нын сўтән верты хŏйән Ма ԓощәԓтәсайәм мўй пӑ нынан ортԓыты?\" ");
INSERT INTO kca_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Щӑԓта пӑ ԓывиԓаԓа йастәс: \"Ватман уԓаты, щӑр кўш щир эԓты шаващаты. Хŏты кепа хŏйат тащәӈ ат ус, ԓўв уԓәпсайәԓ ӑнта щиԓта уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Щӑԓта Ԓўв утәԓтәты пŏтәр пŏтәртәс: \"И тащәӈ ху хŏща мўв хӑрәԓән энмәԓты ԓэвпәс йӑма энмәс; ");
INSERT INTO kca_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","пӑ ԓўв щирәԓән нумәсәԓ: \"А мўй мӑнэм верты? Энмәм ԓэтәтԓам хŏԓта пŏнты?\" ");
INSERT INTO kca_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Нŏмәс верәс: \"Тӑмиты верԓәм: ампарԓам нŏх лосытԓыԓам пӑ ԓӑщкамшәк ампарәт верԓәм, щита энмәм ԓат сэмԓам пӑ па пŏрмасԓам урәӈән тэԓыйэ пŏнты тӑха питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Щӑԓта ма мӑнэма йастәты верәтԓэм: тэԓыйэ йӑм тӑйԓән, ар тӑԓа тӑрмәԓ. Ин щутща, ԓэва, йиԋща, каш вера!\" ");
INSERT INTO kca_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Турәм ԓўвеԓа туп щиты йастәс: \"Ŏшԓы ŏт! Тӑм ат уԓәпсайэн нŏх уԓа; тащтәм ŏтԓан хŏйа питԓәт?\" ");
INSERT INTO kca_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Щиты, щимәщ хŏйат пиԓән уԓԓыйәԓ, хŏй тащ ԓўв урӈәԓа ӑкәтәԓ, Турәм хŏща тащәӈа ӑт уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Щӑԓта Иисус утәԓтәты йохԓаԓа йастәс: \"Щишән Ма нынана пŏтәртԓәм: уԓәпсайән эԓты аԓ нумәсаты, мўй нынан ԓэты, эԓԓәна мўй ԓумәтты. ");
INSERT INTO kca_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Уԓәпса ԓэтәт эԓты ԓӑтәӈшәк, пӑ хŏйат эԓ - ԓумтәм эԓты ԓӑтәӈшәк. ");
INSERT INTO kca_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Хулхәт пеԓа вантаты: мўва ԓат ӑт омәсԓәт, ԓат тŏрән ӑт ӑкәтԓәт, ԓыв ун ампарәт, ԓат сэм шавиты тӑхайәт, ӑт тӑйԓәт – Турәмән ԓыв ԓапәтԓайәт; Мўй арата нын щи тŏхԓәӈ войәт эԓты ԓӑтәӈшәкәт! ");
INSERT INTO kca_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Пӑ хŏй нын эԓтан, ԓўвеԓ ԓэщатман, ԓўв пӑԓатәԓ кўш кепа и кўш оԓәӈ арата эԓәтты веритԓәԓы? ");
INSERT INTO kca_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Нын ай верыйэ верты ӑт веритԓәты ки, мўй пўӈәԓ верәт эԓты нумәсԓәты? ");
INSERT INTO kca_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ӑԋа лыптәт пеԓа вантаты, хŏты ԓыв энәмԓәт: ӑт рупитԓәт, сŏхәм ӑт верԓәт. Туп нынана пŏтәртԓәм: Соломон ики хŏԓна ԓўв вŏсԓәты–вŏрԓәты щирәԓән щиты ӑт ԓумәтԓыйәс, хŏты кашәӈ ŏтԓаԓ ԓумәтԓыԓәт. ");
INSERT INTO kca_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Хӑр мўвән энәмты хŏрамәӈ лыптәт, тӑм хӑтәԓ уԓԓәт, хӑԓэвәт кура вŏщкиԓайәт, Турәмән щиты ки ԓумәтыԓайәт, пӑр мŏԓты Ԓўв нынан ӑт ԓумәттәԓԓы, шимәԓ эвәԓты ŏтәт! ");
INSERT INTO kca_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Щӑԓта, аԓ кӑншаты, нынан мўй ԓэты пӑ мўй йищты, аԓ пӑ нумәсаты. ");
INSERT INTO kca_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Щит тӑм мир уԓәпсайән уԓты хŏйатәт кӑшԓәт; Ащан уйәтәԓ, мўй нынан мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Метшопәӈ Турәм Хон Уԓәпса кӑншаты, пӑ иса щитән ищи мӑԓайты. ");
INSERT INTO kca_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Аԓ пӑԓа, ай тащийэ! Турәм Ащан Хон Уԓәпса нынана мойԓәты йӑм кашәԓ ус. ");
INSERT INTO kca_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Пŏрмасԓән тыныйаԓән пӑ нўша хŏйатәта мийԓыйаты. Ӑт ԓыйты тўтхотәт, турәмән ӑт хŏԓаты сорԋэт нынана ԓэщататы, хŏԓта ԓŏԓмах ӑт ванамәԓ пӑ хŏта хӑхәт ӑт ԓэԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Хŏта нын сорԋиԓән уԓԓәт, щита сӑмԓән уԓты питԓәт. ");
INSERT INTO kca_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ӑнтәпԓән йӑрман ат ԓойԓәт, пӑ тўт сунԓән ат ԓэԓәт. ");
INSERT INTO kca_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Нын пӑ щи митйохәт иты уԓаты, кущайэԓ поры эԓты йŏхи йŏхәтты ԓавәԓԓәт, ԓуԓән, хун ԓўв йŏхәтәԓ пӑ ов хӑтщәԓԓы, ов мŏхты пелки ԓўвеԓа пўшмәты ат верәтԓэԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Щи митйохәт щўԋԓәт, хŏйтат, куща ху йŏхәттаԓән, эԓәпән уԓман уйәтԓәԓы. Йӑна нынана пŏтәртԓәм, ԓўв ӑтпәԓ йӑрԓәԓы, митйохԓаԓ пӑсан сурыйа опсәԓтԓәԓы, вана рӑхиԓыман, ԓывиԓаԓ ԓапәтты питԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ат кўтәпән ки йŏхәтәԓ, мўй пӑ хутԓәты йэԓпийән йŏхәтәԓ, пӑ ԓывиԓаԓ щиты уйәтԓәԓы ки, щи митйохәт ŏй тӑйԓәт. ");
INSERT INTO kca_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Нын уйәтԓәԓән: хотәӈ куща уйәтсәԓы ки, хун ԓоԓмах йŏхәтәԓ, ԓўв ԓуԓән ӑт ŏԓәс пӑ хот питарәԓ ԓуԓән пел хирты ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Нын пӑ ԓэщатыман уԓаты, ӑт ԓавԓәсԓәты пўԉаӈ Хŏйат Пŏх йŏхәтәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Щӑԓта Петра Ԓўвеԓа йастәс: \"Турәм Куща! Мўӈева мўй тӑм утәԓтәты пŏтәр пŏтәрԓэн, мўй пӑ хŏԓ хŏйатәта?\" ");
INSERT INTO kca_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Турәм Куща пӑ йастәс: \"Хŏй вещкат пӑ ŏшәӈ хот шавиты пӑ ԓэщатты хŏйат, кущайән митйохԓаԓ нўмпийа пŏнԓа, мŏрт пŏрайән мŏрт арат ԋаԋ ортты урәӈән? ");
INSERT INTO kca_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Щўԋәӈ щи митху, хŏй йŏхтәм кущайән щиты верман уйәтԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Йӑна нынана йастәԓәм, ԓўв уԓпәсәԓ ватты ԓўвеԓ пŏнԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Щи митху пӑ сӑмәԓән ки йастәԓ: \"Ма кущайэм сора ӑт йŏхәтәԓ, митйохԓаԓ пӑ митнэԓаԓ сэкты питԓәԓы, ԓэты пӑ ищты, пӑ кўтщәты унты ищты питәԓ, ");
INSERT INTO kca_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","щиӈәԋща щи митхуйэн кущайәԓ ӑт ԓавәԓты хӑтԓәԓән, нумԓы сысән йŏхәтәԓ, пӑ ԓўвеԓ кӑтна сэвәрмәԓԓы, пӑ ӑт эвәԓты хŏйатәт иты верԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Щи митху, хŏй кущайәԓ партәпса уйәтсәԓԓы пӑ йэтшәптыман ӑт ус, пӑ ԓўв ԓӑӈхатаԓ щира ӑт верәс, артан сэкты питԓа; ");
INSERT INTO kca_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","хŏй пӑ нэмәԓты ӑт уйтәс, пӑ сэкты хŏрпийа верәс, шимәԓшәк сэкты питԓа. Кашәӈ хŏйата, хŏйа ар мийман уса, ԓўв эԓтэԓ арәԓ кӑншәмәԓа, хŏйа ар аԉиԓыса, щит эԓты аршәк иԋщәсԓа. ");
INSERT INTO kca_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ма мўва тўт туты йŏхәтсәм, пӑ Ма щикем ԓӑӈхаԓәм, ԓуԓән ԓўв ат ўщиԓәмаԓ! ");
INSERT INTO kca_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Йиӈка ԓŏӈәԓтыты верән Мӑнэм мосәԓ йиӈка ԓŏӈәԓтыты; хŏты Ма шукащԓәм, хун щит йэтшәԓ! ");
INSERT INTO kca_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Нын нумәсԓәты, Ма мўва пайԓы уԓәпса туты йŏхәтсәм? Ӑнта, нынана йастәԓәм, ортәсты вер Ма тусәм; ");
INSERT INTO kca_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","тӑԓта йэԓԓы и хотән уԓты вет хŏйат кӑтна ортәсԓәт: хуԓәм хŏйат кӑт хŏйат йэщаԓт, пӑ кӑт хŏйат хуԓәм хŏйат йэщаԓт эԓԓәԓәт. ");
INSERT INTO kca_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ащи пŏхәԓ йэщаԓт эԓԓәԓ, пӑ пŏх ащеԓ йэщаԓт, аԋԏи эвеԓ йэщаԓт эԓԓәԓ, пӑ эви аԋԏеԓ йэщаԓт, унтәп меԋәԓ йэщаԓт эԓԓәԓ, пӑ меԋ утпәԓ йэщаԓт эԓԓәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Мир пеԓа йастәс: \"Хун нын кев пеләк эԓты нŏх этты пӑԓәӈ шийаԓәԓты, нын мŏхты йастәԓты: \"Йэрта йиԓ\", пӑ щиты щи уԓԓыйәԓ; ");
INSERT INTO kca_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","пӑ хун нўм вот пŏԓәԓ, пŏтәрԓәты: \"Рўва йиԓ\", пӑ щиты щи уԓԓыйәԓ. ");
INSERT INTO kca_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ар вешпи хŏйатәт! Турәм пӑ мўв хŏрас мŏштәты хошԓәты, мўй щирән тӑм пŏра ӑт мŏштәԓԓән? ");
INSERT INTO kca_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Мўйа пӑ нын нын щирәнән ӑт ԓэрапԓәԓән, мўй уԓты верәԓ уԓ? ");
INSERT INTO kca_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Хун нӑӈ пеԓайэн нўр туты хŏйатэн пиԓән сўт хŏща мӑнԓән, йушән ԓўв эԓтайәԓ хŏԓт пайтәса. Ԓўв нӑӈен сўт ху хŏща аԓт йŏхтәптәсԓы, сўт ху пӑ нӑӈен касна хот шавиты ŏта аԓт мӑсԓы, щит пӑ нӑӈен касна хота аԓт вŏщкәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Пŏтәртԓәм нӑӈена: хӑщәм ŏх шўкен ӑт мӑтән унты, щиԓта нӑӈ ӑт этԓән\". ");
INSERT INTO kca_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Щи пŏрайән тухәԓ мŏхет Иисуса Галилея хŏйатәт эԓты пŏтәртсәт, хŏй кӑԓыԓаԓ Пилатән йирԓаԓ кӑԓы пиԓән ԓыԓәтса. ");
INSERT INTO kca_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Иисус ԓывиԓаԓа щиты йастәс: \"Нын нумәстанән, мўй щи Галилея мŏхет па Галилея хŏйатәт киԋща кӑрэкәӈәт усәт, мўйа щиты пӑратсайәт? ");
INSERT INTO kca_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ӑнта, нынана пŏтәртԓәм, туп кӑрэкԓән эԓты шӑшән ӑт керԓәԓты ки, ищи хŏԓыйэ пӑрԓәты. ");
INSERT INTO kca_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Мўй пӑ, а мўй нумәсԓәты, щи, Силоам йухтас пӑԓ хотән эԓт ӑркәмтәм пӑ пӑратәм, нийәԓхус хŏйат, ԓыв Иерусалим па хŏйатәт эԓты мўй мет атмәт усәт? ");
INSERT INTO kca_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ӑнта, нынана йастәԓәм! Кӑрэкԓән эԓты ӑт керԓәԓты ки, ищиты хŏԓ пӑрԓәты!\". ");
INSERT INTO kca_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Щӑԓта щимәщ утәԓтәты пŏтәр пŏтәртәс: \"И хŏйат виноград йўхәӈ тӑхайәԓән смоква нэмпи йўх омәсман тӑйәс, щӑԓта ий пўш йўхән энмәм ԓэвпәсәԓ кӑшты йŏхтәс, пӑ ӑт уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Виноград энмәԓтты митхуйәԓа йастәс: \"Хуԓмет тӑԓа йис, ты йŏхтыԓыты питмем, смоква йўхән энмәм ԓэвпәс кӑштыйа, пӑ ӑт уйәтԓәм; иԓ сэвры ԓўвеԓ: мўйа ԓўв мўв рўв таԓәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Туп митху ԓўвеԓа йŏхԓы йастәс: \"Куща! Тӑм тӑԓа па хӑйиԓыйэ, керәтман мўвәԓ шўкатԓэм пӑ ԋащамән пŏнԓэм, - ");
INSERT INTO kca_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","мосәӈ ԓэвпәс мӑԓ; туп ӑнтом ки, папуш иԓ сэвәрԓэн\". ");
INSERT INTO kca_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","И Турәм йасӈа утәԓтәты хотән Ԓўв шаббат хӑтәԓән хŏйатәт утәԓтәс. ");
INSERT INTO kca_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Щита ԋийәԓхус тӑԓ муш верты кўԉ тӑйәм нэ ус: ԓўв хŏмта таԓман уса пӑ тўӈа верәсты ӑт веритәс. ");
INSERT INTO kca_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Иисус ԓўвеԓ шийаԓәмаԓ кемән, вана вохсәԓы пӑ ԓўвеԓа йастәс: \"Ими, нӑӈ мушен эԓты ин щи нŏх питԓән\". ");
INSERT INTO kca_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Пӑ йошӈиԓаԓ ԓўв эԓтэԓ пŏтсәԓы, пӑ ими ищи мŏхты тўӈа йис, пӑ Турәм вŏԓаӈа айәԓтты питсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Щи пўԉаӈ Иисус пеԓа йэмәӈ йасӈа утәԓтәты хот куща, Иисус шаббат хӑтәԓән хŏйат йӑмәԓмаԓ урәӈән, ўшмащман мир пеԓа йастәс: \"Рупәтты кеша хут хӑтәԓ уԓ; щи пŏрайән йӑмәԓтыты йŏхтыԓыйаты, ӑнта шаббат хӑтәԓән\". ");
INSERT INTO kca_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Турәм Куща ԓўвеԓа йŏхԓы йастәс: \"Кӑт вешпи ŏт! Нын эԓтайән кашәӈ ŏт шаббат хӑтәԓән ԓўв мисәԓ, мўй пӑ оселәԓ ԓойты тӑхайәԓ хŏща мўй хŏԓт ӑт эӈхиԓыԓԓы пӑ йищәԓтәты мўй ӑт тутԓиԓԓы? ");
INSERT INTO kca_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Тӑм Авраам рут эԓты уԓты эви пӑ сатанайән ԋийәԓхус тӑԓ йӑрман тӑйса, шаббат хӑтәԓән щи ԓыс эԓты хŏԓт эсәԓты мўй ӑт мосәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Хун Ԓўв щит пŏтәртмаԓән, хŏԓыйэ, Ԓўв пиԓәԓән ӑт кашащәм мŏхет, йэԓәпсайәт; пӑ мир иса Ԓўв хŏԓ вŏԓаӈ верԓаԓ эԓты амтәтԓыйәс. ");
INSERT INTO kca_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Иисус пӑ йастәс: \"Турәм Хон Уԓәпса мўй хŏрпи? Пӑ мўй хŏрпийа ԓўвеԓ ԓэщатԓэм? ");
INSERT INTO kca_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ԓўв горчица ԓат сэм хŏрпи, хŏйат ўсԓы пӑ ԓэвпәс энмәԓты йўхԓаԓ хŏща омәссәԓы; энмәс пӑ ун йўх хŏрпийа йис, тŏхԓәӈ войәт ԓўв нўвԓаԓ кўтән тыхәԓ верыԓысәт\". ");
INSERT INTO kca_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Хŏԓна пӑ йастәс: \"Турәм Хон Уԓәпса мўй хŏрпи? ");
INSERT INTO kca_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ԓўв имийән ўйәм ԋаԋ шўм хŏрпи, хуԓәм мŏрт арата ԓэщатәм ԓанта пŏтса пӑ рўвәтса, ԓатәԓ иса ԓыйтаԓ унты хӑйса\". ");
INSERT INTO kca_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Щӑԓта Иисус Иерусалим пеԓа йуш тўвман, вошәт, куртәт сӑхат йӑӈхәс, хŏйатәт утәԓтыман. ");
INSERT INTO kca_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","И мӑтты ŏт Ԓўвеԓ ищмәсԓы: \"Турәм Куща! Пӑр мŏԓты нŏх пайтәсты хŏйат шимәԓ?\" Ԓўв йŏхԓы йастәс: ");
INSERT INTO kca_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","\"Пушас ващ овийэйа ԓŏӈты ўрататы, нынана пŏтәртԓәм, ар мŏхет ԓŏӈты ўратԓәт пӑ ӑт верәтԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Хун хотәӈ ху нŏх ԓойәԓ пӑ овәԓ лӑп петԓәԓы, щи пŏрайән нын, камән ԓойман, ов сэкты питԓәты пӑ пŏтәртты: Турәм Куща! Турәм Куща! Ов мўӈева пелки пўнши\"; туп Ԓўв нынана йŏхԓы йастәԓ: \"Нынан ӑт уйәтԓыԓам, хŏԉща нын уԓԓәты\". ");
INSERT INTO kca_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Щи пŏрайән пŏтәртты питԓәты: \"Мўӈ Нӑӈ пиԓэнән ԓэсув пӑ йищсув, пӑ мўӈ вош хўлыԓувән Нӑӈ утәԓтәсән\". ");
INSERT INTO kca_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ԓўв пӑ йастәԓ: \"Нынана пŏтәртԓәм: нынан ӑт уйәтԓыԓам, хŏԉща нын уԓԓәты; Ма эԓтэм хŏԓыйэ ԉик верты ŏтәт пўӈԓа мӑнаты\". ");
INSERT INTO kca_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Щита хŏԓԓәп пӑ пек шихрәпса питәԓ, хун нын Турәм Хон Уԓәпса хŏща Авраам, Исаак, Иаков пӑ хŏԓ Турәм йасәӈ туты хŏйатәт шийаԓәԓты, нынәԓән пӑ щиԓта ким воштәты щирән шийаԓәԓԓән. ");
INSERT INTO kca_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Щӑԓта хӑԓэвәт пеләкән пӑ кев пеләкән уԓты мўвәт эԓты, ным пӑ нўм мўвәт эԓты хŏйатәт йŏхәтԓәт, Турәм Хон Уԓәпса хŏща поры пӑсан сурыйән ӑктәщԓәт. ");
INSERT INTO kca_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Йӑ ин, тухәԓ йŏԓта уԓты хŏйатәт оԓӈа уԓты питԓәт, пӑ тухәԓ оԓӈа уԓты хŏйатәт – йŏԓта уԓты питԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Щи хӑтәԓән Иисус хŏща фарисейәт эԓты тухәԓ мŏхет йŏхәтсәт пӑ Ԓўвеԓа пŏтәртсәт: \"Ким эта пӑ мӑна тӑԓта, Ирод Нӑӈен пӑратты утщиԓԓы\". ");
INSERT INTO kca_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Щӑԓта ԓывиԓаԓа йастәс: \"Мӑнаты пӑ йастаты щи ŏхсар икийа: 'Ма кўԉәт воштәԓәм пӑ хŏйатәт йӑмәԓтԓәм тӑмхӑтәԓ пӑ хӑԓэвәт, пӑ хуԓмет хӑтәԓән йэтшәԓәм'; ");
INSERT INTO kca_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","туп тӑмхӑтәԓ, хӑԓэвәт пӑ па йиты хӑтәԓән Мӑнэм йэԓԓы шушты мосәԓ, щиты ӑт уԓԓыйәԓ, Турәм йасәӈ туты ики Иерусалим вош кимпийән ат пӑрәс. ");
INSERT INTO kca_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Иерусалим! Иерусалим! Турәм йасәӈ туты икет веԓты пӑ Турәмән нӑӈ хŏщайэн китәм ŏтәт кевән щӑх сэкты вош! Мўй арат пўш Ма нӑӈ ԋаврэмԓан йӑха ӑкәтты утщисԓам, хŏты тŏхԓәӈ вой пŏшәхԓаԓ тŏхәԓԓаԓ иԓпийа ӑкәтԓәԓы, туп нын ӑт ԓӑӈхасты! ");
INSERT INTO kca_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Тӑм, нын хотән нынана таԓа хӑщәԓ! Нынана пŏтәртԓәм, Мӑнэм нын щи унты ӑт шийаԓәԓԓән, хун пŏра йŏхәтәԓ, пӑ йастәԓты: 'Щит йӑмән мийәм Ŏт, Хŏй Турәм Куща нэмән йŏхәтәԓ!'\" ");
INSERT INTO kca_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Имŏԓты шаббат хӑтәԓән Ԓўв фарисейәт эԓты уԓты и куща хота ԓэтыйа йŏхтәс, ԓывәт пӑ Ԓўвеԓ эԓты ватман тӑйсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ин щӑԓта, Ԓўв йэщаԓтәԓ йикән пўвԓәптәм муш тӑйты хŏйат этәс. ");
INSERT INTO kca_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Тӑм вер эԓты Иисус Закона утәԓтәты икет пӑ фарисейәт иԋщәсәс: \"Шаббат хӑтәԓән йӑмәԓты рӑхәԓ мўй ӑнта?\" ");
INSERT INTO kca_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ԓыв мӑшйайән усәт. Ԓўв мушәӈ хŏйат хŏща хӑнәмтыман йӑмәԓтсәԓы пӑ эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Щи пўԉаӈ ԓывиԓаԓа йастәс: \"Нын мӑтты ŏтԓән хŏща осёлән мўй хор мисән йик ўйԓыты ўс ԓыпийа ки иԓ рӑкәнәԓ, шаббат хӑтәԓ кепа, ищи кўрәмән мўй ԓўвеԓ нŏх ӑт таԓԓәԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Пӑ ԓыв щит пеԓа Ԓўвеԓа йŏхԓы йастәты ӑт верәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Иисус, вохәм мŏхет ԓӑтәӈшәк омәсты тӑхайәт пирыты щир, шийаԓәмаԓ кемән, утәԓтәты пŏтәр ԓывиԓаԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","\"Хун нӑӈ порыйа вохԓайән, ԓӑтәӈ омәсты тӑхайа аԓ опса, щиты питты верәтәԓ, мӑтты вохәм мойәӈ хŏйат нӑӈ эԓтэн вŏԓаӈшәк питәԓ, ");
INSERT INTO kca_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","нӑӈен пӑ ԓўвеԓ вохәм хŏйатэн, вана шушман, нӑӈена йастәты верәтәԓ: \"Тӑм омәсты лотен ԓўвеԓа мийи\"; щи пŏрайән йэԓәмман мет йŏхи хӑщәм лота нӑӈен омәсты вера йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Хун нӑӈ порыйа вохԓайән ки, йŏхәттэнән, мет йухәт омәсты тӑхайа опса, нӑӈен вохәм ŏтэн нӑӈ хŏщайэн вана шушман ат йастәԓ: \"Пиԓху! Ўтԓышәк опса\", щи пŏрайән омәсты хŏйатәт йэԓпийән нӑӈ ԓӑтәӈа питԓән, ");
INSERT INTO kca_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","кашәӈ ԓўвеԓ ԓўв ԓӑтәӈа тӑйты хŏйат ԓӑтԓыйа пӑйәтԓа, пӑ ԓўвеԓ ԓӑтԓыйа тӑйты хŏйат, ԓӑтәӈа пайәтԓа\". ");
INSERT INTO kca_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ԓўвеԓ вохәм фарисей пеԓа йастәс: \"Хун ԓэты пӑсан верԓән, пиԓйохԓан, йайԓан, рут йохԓан, нӑӈ ԉэпенән уԓты тащәӈ хŏйатԓан аԓ вохаԓән, ԓыв ищи нӑӈен ӑт ат вохԓэԓ пӑ ищиты нӑӈен йŏхԓы ӑт аԓт сŏхәптәсԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Хун ун ԓэты пӑсан вәрԓән, нўша хŏйатәт, мушмәм хŏйатәт, нŏхты хŏйатәт, сэмԓы хŏйатәт воха, ");
INSERT INTO kca_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","щи пŏрайән ŏйәӈа йиԓән, щит ԓыв нӑӈена йŏхԓы сŏхәптәты ӑт верәтԓәт, нӑӈена Турәм щирән уԓты хŏйатәт нŏх ԓыԓәӈԓәты хӑтәԓән сŏхәптәԓа\". ");
INSERT INTO kca_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Щит хуԓмаԓ кемән, Ԓўв пиԓәԓән пӑсан сурыйән опсәм и ŏт Ԓўвеԓа йастәс: \"Щит ŏйәӈ питәԓ, хŏй Турәм Хон Уԓәпса хŏща поры пӑсан сурыйән ԓэԓ-йищәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Иисус ԓўвеԓа йастәс: \"И хŏйат ун ԓэты пӑсан ԓэщатәс пӑ ар хŏйат вохәс. ");
INSERT INTO kca_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Хун ԓэты пŏра йŏхтәс, митхуйәԓ вохәм мŏхиԓаԓ хŏща китсәԓы йастәтыйа: \"Йўваты, мўй иса ԓэщатса!\" ");
INSERT INTO kca_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Пӑ иса хŏԓ и йӑха йастантәм ŏтәт иты йŏхԓы рŏвемәты питсәт. Ит йастәс: \"Ма мўв хӑр ԓутсәм пӑ мӑнэм ԓўвеԓ ватты йӑхты мосәԓ; щи ԓŏват йӑм вера, ԉик аԓ тӑйа\". ");
INSERT INTO kca_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Киметәԓ йастәс: \"Ма йаӈ хор мис ԓутсәм пӑ рупатайән ԓывиԓаԓ ватты мӑнԓәм; щи ԓŏват йӑм вера, нўрэм аԓ нуми\". ");
INSERT INTO kca_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Хуԓметәԓ йастәс: \"Ма нэ тусәм, щишән йиты ӑт веритԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Щӑԓта митху йŏхи йŏхәтмаԓән, щит иса кущайәԓа йастәсԓы. Щиӈәԋща хотәӈ куща ԓыкащәс пӑ митхуйәԓа йастәс: \"Кашәӈ вош хўлы хўват йӑӈха пӑ нўша хŏйатәт, мушмәм хŏйатәт, нŏхты пӑ сэмԓы хŏйатәт тый тўваԓән\". ");
INSERT INTO kca_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Щӑԓта митхуйәԓ йастәс: \"Куща! Версэм, хŏты нӑӈ партсэн, хŏԓна па омәсты лот уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Щиӈәԋща куща митхуйәԓа йастәс: \"Йушәт хўват мӑна пӑ пушасәт пўӈәԓән йӑӈха пӑ хŏйатәт йŏхәтты эвԓәптаԓән, хотэм хŏйатән ат тэкәтса. ");
INSERT INTO kca_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Нынана йастыԓыԓәм, тўм вохәм хŏйатәт эԓты, нэмәԓты хŏйат ма ԓэтŏтэм хŏща ўӈԓәԓ ӑт хойԓыйәԓ, вохәм хŏйат ар, туп пирыйәм хŏйат шимәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ԓўв пиԓәԓән тэԓыйэ хŏйат шушәс; Ԓўв, йŏхԓы керԓәман, ԓывиԓаԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","\"Хŏй Ма хŏщайэма йŏхәтәԓ ки, щӑԓта ащеԓ пӑ аԋԏеԓ, имеԓ пӑ ԋаврэмԓаԓ, йайԓаԓ пӑ ŏпиԓаԓ, пӑ апщиԓаԓ, пӑ хŏԓна ԓўв уԓәпсайәԓ нŏпсәԓ эԓты хŏԓт ӑт вŏщкәԓԓы ки, щит Ма утәԓтәты хŏйатэма уԓты ӑт верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Щӑԓта хŏй ԓўв пернайәԓ ӑт туԓԓы пӑ Ма йўпемән ӑт шушәԓ, Ма утәԓтәты хŏйатэма уԓты ӑт верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Хŏй нын эԓтан йухтас пӑԓ хот омәсты ўтщийәԓ ки, оԓӈа иԓ ӑт омәсәԓ пӑ тынәԓ ӑт ԓўӈәтԓәԓы мўй, йухтас пӑԓ хотәԓ ԓўв йэтшәптәты веритԓәԓы мўй ӑнтом? ");
INSERT INTO kca_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Хот пӑтэԓ ўԓԓы ки пӑ йэтшәптәты щир ӑт тӑйты ки питәԓ, хŏԓыйэ ватты ŏтәт ԓўв эԓтэԓ ԋӑхты питԓәт: ");
INSERT INTO kca_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","\"Тӑм хŏйат хот омәсты питщәс пӑ ӑт йэтшәптәсԓы\". ");
INSERT INTO kca_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Мўй пӑ мӑты хон ики па хон хŏща ԉаԉа мӑнтаԓ йэԓпийән иԓ ӑт омәсәԓ пӑ оԓәӈән мŏхиԓаԓ пиԓән ӑт ŏшйащәԓ, ԓўв йаӈ щŏрәс ԉаԉәсты йохԓаԓ пиԓән а мўй йурәӈ, щи, ԓўв пеԓайәԓ йиты, па хон ики хус щŏрәс ԉаԉәсты йŏх йэщаԓт ԓойты а мўй верәтәԓ? ");
INSERT INTO kca_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ӑнта ки, щит йэԓән уԓтаԓ сыс, ԓўв щитәԓ хŏща хŏйатәт китәԓ, ԉаԉԓы уԓәпса вохты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Щиты нын эԓтан кашәӈ хŏйат, хŏй мўйәԓ-кашӈәԓ эԓты ӑт ки верәтәԓ йирԓәты, Ма утәԓтәты хŏйатэма уԓты ӑт верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Сŏԓ - щит йӑм ŏт; туп сŏԓ эпԓәԓ уштәԓԓы ки, хŏты ԓўвеԓ йӑԓпа сŏԓаӈа верты? ");
INSERT INTO kca_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ӑнта мўва, ӑнта ԋащама ӑт рӑхәԓ; ким ԓўв вŏщкәԓа. Хŏй хуԓты кеша пӑԓ тӑйәԓ, ат хуԓәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Налог ӑкәтты йох пӑ кӑрэкәӈ хŏйатәт хŏԓыйэ Ԓўв хŏщайәԓа рӑхәԓтысәт, Ԓўвеԓ хуԓәтты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Фарисейәт пӑ щӑԓта Закона утәԓтәты хŏйатәт ўшмащсәт, пŏтәрԓәт: \"Тӑм Хойат кӑрэкәӈ мŏхәт вана ўԓԓы пӑ ԓыв пиԓԓаԓән ԓэԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Туп Ԓўв щимәщ утәԓтәты пŏтәр ԓывиԓаԓа пŏтәртәс: ");
INSERT INTO kca_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","\"Хŏй нын эԓтан, сот ош тӑйман ки, пӑ щиԓта итәԓ уштәԓԓы, йӑрсот йӑрәԏйаӈәԓ щӑхәрән мўй ӑт хӑйԓәԓы пӑ уштәм ошәԓ йўпийән мўй ӑт мӑнәԓ, уйәттаԓ унты? ");
INSERT INTO kca_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Пӑ уйәттаԓән, ўԓԓы пӑ, амәтман, порхәԓа пŏнԓәԓы; ");
INSERT INTO kca_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","пӑ, йŏхи йŏхәттаԓән, пиԓйохԓаԓ пӑ ԓўв ԉэпәԓән уԓты хŏйатԓаԓ вохԓәԓы пӑ ԓывиԓаԓа йастәԓ: \"Ма пиԓэмән йэша амтәтԓыйаты: ма уштәм ошем уйәтсэм\". ");
INSERT INTO kca_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Нынана пŏтәртԓәм, щиты турәмән кӑрэкԓаԓ эԓты шӑшән керԓәты и кӑрэкәӈ хŏйат урәӈән амәт аршәк питәԓ, хун йӑрсот йӑрәԏйаӈ тўӈа–щира уԓты хŏйатәт урәӈән, хŏйа кӑрэкԓаԓ эԓты шӑшән керԓәты ӑт мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Мўй пӑ, ий ими йаӈ сорԋеӈ ŏх карты тӑйман, и ŏх картэԓ уштәԓԓы ки, тўт сунәԓ мўй нŏх ӑт ўщитԓәԓы, пӑ хот хӑрәԓ нŏх йовәԓты ӑт питԓәԓы, уйәтты унты йӑма кӑшты ӑт питԓәԓы? ");
INSERT INTO kca_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Щӑԓта уйәттаԓән, пиԓнэԓаԓ пӑ ԓўв ԉэпәԓән уԓты нэԓаԓ вохԓәԓы пӑ йастәԓ: \"Ма пиԓэмән амтәтԓыйаты: ма уштыԓыйәм сорԋеӈ ŏх картэм уйәтсэм!\" ");
INSERT INTO kca_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Нынана пŏтәртԓәм: щиты Турәм ангеләт, кӑрэкԓаԓ эԓты шӑшән керԓәты кӑрэкәӈ и хŏйат урәӈән, амтәтԓыԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Иисус йэԓԓы пŏтәртәс: \"И хŏйат кӑт пŏх тӑйәс; ");
INSERT INTO kca_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","айшәк пŏхәԓ ащеԓ пеԓа йастәс: \"Ащи! Ма йўкан хот уԓпәсэм мӑнэма мийи\". Щӑԓта ащанән хот уԓпәсэԓ ԓынана ортса. ");
INSERT INTO kca_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Кӑмәтса хӑтәԓ хӑщәм йўпийән, ай пŏхәԓ мŏԓтыԓаԓ иса ӑкәтмаԓ йўпийән, хўв мўва мӑнәс пӑ щита ԓўв йўканәԓ, уԉԋайа уԓман, посатсәԓԓы. ");
INSERT INTO kca_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Хун ԓўв йўканәԓ хŏԓ ԓэсԓы-тӑйсәԓы, щи мўвән ун ԓэԓԓы пŏрайа йис, пӑ ԓўв нўшайа питәс; ");
INSERT INTO kca_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","щӑԓта мӑнәс пӑ щи мўвәӈ и ху хŏща ԓŏӈәԓтыйәс, щитән пӑ ԓўв мўв хӑрԓаԓа пурәщԓаԓ шавиты китса; ");
INSERT INTO kca_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ԓўвеԓән пурәщ ԓэтŏтән сӑмәԓ вŏԓԓәтты ԓуԓән амәт ус, туп нэмәԓты хŏйатән щитән хŏԓна ӑт мийԓыса. ");
INSERT INTO kca_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Нŏпсәԓ нумәԓмимаԓән, йастәс: 'Мўй арат митйох ащем хŏща мŏԓтас ԓэтәт тӑйԓәт, ма пӑ ԓэԓԓы тӑта щи хӑԓԓәм; ");
INSERT INTO kca_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","нŏх ԓойԓәм пӑ ащем хŏща мӑнԓәм, ԓўвеԓа йастәԓәм: Ащийэ! Ма турма пӑ нӑӈена кӑрэк версәм ");
INSERT INTO kca_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","пӑ нӑӈ пŏхена ԓўӈтәсты щирэм ӑнтом; мӑнэм митйохԓан кўта ўйи\". ");
INSERT INTO kca_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Нŏх ԓойәс пӑ ащеԓ хŏща мӑнәс. Хун ԓўв хŏԓна йэԓән йўвмаԓән, ащеԓән шийаԓәса пӑ щаԉәтса; щӑԓта, ащеԓ йэщаԓт хухәԓмәман, сапԓәԓа ӑпәԓмәс пӑ ԓўвеԓ мосәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Пŏхәԓ пӑ ԓўвеԓа йастәс: \"Ащи! Ма турма пӑ нӑӈена кӑрэк версәм пӑ нӑӈ пŏхена ԓўӈтәсты ўш щирэм ӑнтом\". ");
INSERT INTO kca_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ащеԓ пӑ митйохԓаԓ пеԓа йастәс: \"Мет йӑм ԓумәтты сŏх тўваты пӑ ԓумәттаԓән, пӑ йошәԓа веншәӈ ԓуйәт, кўрԓаԓа пӑ ԓумтәм мийаты; ");
INSERT INTO kca_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","щӑԓта, веԓмәӈ мис пŏшәх тўваты пӑ нŏх хŏраԓән; ԓэты пӑ каш верты питԓув! ");
INSERT INTO kca_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Пӑ хŏты, тӑм пŏхем пӑрман ус пӑ нŏх ԓыԓәӈԓәс, ушман ус пӑ уйәтса\". Щӑԓта ԓыв каш верты питсәт. ");
INSERT INTO kca_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ун пŏхәԓ пӑ мўв хӑрән ус; йŏхи йитаԓән, хун йŏхи ванамәс, арыты пӑ йакты сый хуԓмәс; ");
INSERT INTO kca_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","и митху вана вохман, ищмәсԓы: \"Щит пӑ мўй?\" ");
INSERT INTO kca_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Митху пӑ ԓўвеԓа йастәс: \"Апщен йŏхтәс, пӑ ащен веԓмәӈ мис пŏшәх хŏрәс, ԓўв пŏхәԓ тўмтака йоша пайәтмаԓ урәӈән\". ");
INSERT INTO kca_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ԓўв ԉикащәс пӑ йŏхи ԓŏӈты ӑт ԓӑӈхас. Ащеԓ пӑ, ким этәс пӑ ԓўвеԓ йŏхи пойәкты питсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Туп ԓўв ащеԓ пеԓа йŏхԓы йастәс: \"Ма мўй арат тӑԓ нӑӈена ԋотԓәм пӑ нэмәԓты пŏрайән нӑӈ йасӈен шŏппи ӑт ўншиԓысэм, нӑӈ пӑ нэмәԓты пŏрайән мӑнэм пиԓйохԓам пиԓән каш верты урәӈән, хŏԓна ош пŏшәх ӑт мийԓысән; ");
INSERT INTO kca_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","хун пӑ тӑм пŏхен, нӑӈ хот уԓпәсэн уԉԋа нэӈәт пиԓән лакки йовәԓмаԓ йўпийән, йŏхтәс, нӑӈ пӑ ԓўв урӈәԓән веԓмәӈ мис пŏшәх хŏрсән\". ");
INSERT INTO kca_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ащеԓ пӑ ԓўвеԓа йастәс: \"Пŏхийэ! Нӑӈ иса ма пиԓэмән уԓԓән, хŏԓ ма ŏтэм нӑӈен, ");
INSERT INTO kca_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","мўӈев щит эԓты амтәтԓыты пӑ каш верты мосәс, апщен пӑрман ус пӑ нŏх ԓыԓәӈԓәс, тӑпиԓыйәс пӑ уйтантәс\". ");
INSERT INTO kca_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ԓўв пӑ утәԓтәты йохԓаԓа йастәс: \"И тащәӈ хŏйат хотәԓ-вещәԓ шавиты пӑ ԓэщатты хŏйат тӑйәс. Щитэн эԓты ԓўвеԓа айкеԓ туса, мӑтты ԓўв пŏрмасԓаԓ посатәԓ; ");
INSERT INTO kca_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","щӑԓта, ԓўвеԓ вана вохсәԓы пӑ йастәс: \"Мўй ма нӑӈ эԓтэн хуԓԓәм? Йаста, хŏты хот шавиты пӑ ԓэщатты верәт версән, щиӈәԋща ма хŏщайэма рупитты ӑт питԓән\". ");
INSERT INTO kca_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Щишән щи хŏйат ԓўв турмәԓән нумәсыйәԓ: \"Хŏты нэриты? Ма кущайэм хот шавиты пӑ ԓэщатты верэм нŏх ўԓԓы; мўв хирты йур ӑт тӑйԓәм, ԓэтŏт вохты йэԓәмԓайәм; ");
INSERT INTO kca_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ԓыв хотԓаԓа ма ат ўсайәм, уйәтԓэм, мўй верты, хун хот шавиты пӑ ԓэщатты вер эԓты пўӈԓа пайәтԓайәм\". ");
INSERT INTO kca_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Пӑ кущайәԓ хŏща артнайәӈа уԓты хŏйатәт ԓӑтәԓ щирән вохсәԓы, пӑ оԓәӈ хŏйат ищмәсԓы: \"Мўй арат артна нӑӈ кущайэм хŏща тӑйԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Щитәԓ йастәс: \"Сот мера оливка вŏй\". Щӑԓта щитәԓа йастәс: \"Артна нэпекен ўйи, пӑ сорашәк иԓ опса, хӑнши: ветйаӈ\". ");
INSERT INTO kca_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Щӑԓта кимет артнайәӈ хŏйата йастәс: \"Нӑӈ пӑ мўй арат артна тӑйԓән?\" Ԓўв йŏхԓы йастәс: \"Сот мера нŏви ԓат сэм\". Щӑԓта ԓўвеԓа йастәс: \"Артна нэпекен ўйи пӑ хӑнши: ԋийәԓйаӈ\". ");
INSERT INTO kca_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Хотәӈ куща хот шавиты пӑ ԓэщатты ӑнта вещкат хŏйатәԓ ишәксәԓы, нŏпсәӈа вермаԓ урәӈән; тӑм йисән уԓты пŏхәт ԓыв хŏрпи ŏтԓаԓ кўтән нŏви турәм пŏхәт эԓты нŏпсәӈшәкәт. ");
INSERT INTO kca_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ма пӑ нынана пŏтәртԓәм: нын пиԓйохәт ԓэщататы нӑрәӈ тащ-вещ ŏнтасән, ԓуԓән, хун нўшайа йиԓты, ԓыв нынан и пўша уԓты тӑхайа ат ўсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ай верән вещкат ŏт, щит ун верән па вещкат, ай верән ӑнта вещкат ŏт, щит ун верән ищи ӑнта вещкат. ");
INSERT INTO kca_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Щишән, нын нӑрәӈ тащ-вещ тӑйман вещката ӑт усты ки, хŏй нынана вещката уԓты тащ-вещ эвԓәптәԓ? ");
INSERT INTO kca_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Пӑ па ŏт тащ-вещ хŏща вещката ӑт усты ки, хŏйән нынана нын кешайән уԓты ŏт мӑԓа? ");
INSERT INTO kca_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Нэмәԓты митху кӑт куща пеԓа уԓты ӑт верәтәԓ: мўй пӑ итәԓ ԉикән этты питԓәԓы, киметәԓ пӑ сӑмәӈа тӑйты питԓәԓы, мўй пӑ итәԓа сӑмәӈа рупитты питәԓ, киметәԓ эԓты пӑ йŏвра ватты питәԓ. И пўԉаӈ Турәм пеԓа пӑ тащ-вещ пеԓа уԓты ӑт верәтԓәты\". ");
INSERT INTO kca_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Щит иса ŏх сӑмәӈа тӑйты фарисейәтән па хуԓса, пӑ ԓыв Ԓўвэԓ ԋӑха ԋӑхсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ԓўв ԓывиԓаԓа йастәс: \"Нын хŏйатәт йэԓпийән нынан тўӈа-щира уԓты ŏтәта айәԓԓәԓән, туп Турәмән нын сӑмԓән уйәтԓайәт, хŏйатәт хŏща мўй ԓӑтәӈ, Турәм йэԓпийән щит ԋим\". ");
INSERT INTO kca_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Закон пŏра пӑ Турәм йасәӈ туты хŏйатәт пŏра Иоанн унты ус; ин ўш эԓты Турәм Хон Уԓәпса Йӑм айкеԓ эԓты сыйәӈа пŏтәртԓа, пӑ кашәӈ хŏйат йур вевән ԓыпийа ўратәԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Туп сорашәк турәм пӑ мўв хŏԓты пеԓа ушԓәтән, Закон йасӈәт эԓты и хӑнши нўвийэ хŏԓты хун ушәԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Щит, хŏй имеԓ пиԓән кӑтна мӑнәԓ пӑ па ими туԓ, пакрасԓәԓ, пӑ щит, хŏй икеԓ пиԓән кӑтна мӑнәм ими вана ўԓԓы, пакрасԓәԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","И тащәӈ хŏйат ус, ԓўв тынәӈ питы ўрты ԓумтәма пӑ пирыйәм ухәԓ щӑшкана ԓумәтԓыйәс пӑ кашәӈ хӑтәԓ поры пӑсан верыԓыйәс. ");
INSERT INTO kca_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Щӑԓта пӑ Лазарь нэмпи и куԋар хŏйат ус, ԓўв пушас овәԓ иԓпийән керәтԓыйәс, эԓәԓ ԓайӈәӈ ԋўләмән лӑп каритәм ");
INSERT INTO kca_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","пӑ тащәӈ ики пӑсан эԓты иԓ рыйты пўләта ԓуԓән хŏԓна амәтман ус, сӑмәԓ вŏԓәттыйа, ампәт вана йŏхтыԓысәт пӑ ԓўв карԓаԓ ԋŏԓыԓысԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Куԋар ху пӑрәс пӑ ԓўв ангеләтән Авраам хŏща туса. Тащәӈ ики па пӑрәс, пӑ мўва иԓ лоттәса. ");
INSERT INTO kca_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Иԓта турәмән шукащман ус, ԓўв сэмԓаԓ нŏх аԓәпсәԓы пӑ йэԓән Авраам, ԓўв пўӈԓәԓән пӑ Лазарь ики шийаԓәс. ");
INSERT INTO kca_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Такан ўвман йастәс: \"Авраам ащи! Ма урӈемән сӑмен ат ԋŏхԓәԓ пӑ Лазарен киты, ԓўй тӑйәԓ йиӈка ат метшиԓыԓԓы пӑ ԋаԓмем ат йолхәԓԓәԓы, тӑм тўт хŏща щикем шукащԓәм!\" ");
INSERT INTO kca_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Авраам йастәс: \"Пŏхийэ, нумәԓми, нӑӈ йӑмен уԓмен сыс мŏщатсэн; Лазарь пӑ – туп атәм тӑйәс. Ин пӑ ԓўв тӑта тŏрамтыйәԓ, нӑӈ пӑ шукащԓән; ");
INSERT INTO kca_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","щи тўмпийән мўӈ пӑ нын кўтәнән ун ус шики верман уԓ, тӑԓта нын хŏщайән мӑнты ԓӑӈхаты ŏтәт ӑт веритԓәт щи мӑнты, ищиты щиԓта мўӈ хŏщайэв ӑт ўншиԓыԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Щиӈәԋща тащәӈ ху йастәс: \"Щи ԓŏват йӑм вера, ун ащи, ма ащем хота ԓўвеԓ киты, ");
INSERT INTO kca_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ма вет ху апщи тӑйԓәм, ԓўв ԓывиԓаԓа ат йастәԓ, ԓуԓән ԓыв пӑ тӑм шукәӈ тӑхайа ӑт аԓ йŏхәтсәт\". ");
INSERT INTO kca_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Авраам ԓўвеԓа йастәс: \"Ԓыв Моисей пӑ Турәм йасәӈ туты икет тӑйԓәт; ԓывиԓаԓ ат хуԓәтԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ԓўв пӑ йастәс: \"Ӑнта, Авраам ун ащи, туп хун пӑрәм хŏйатәт эԓты ԓыв хŏщайэԓ мӑтты ŏт йŏхәтәԓ ки, щи пŏрайән ԓыв кӑрэкԓаԓ эԓты керԓәԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Щӑԓта Авраам ԓўвеԓа йастәс: \"Моисейа пӑ Турәм йасәӈ туты икета ӑт хуԓәтԓәт ки, пӑ пӑрәм хŏйатәт эԓты мӑтты ŏт нŏх ԓыԓәӈԓәс ки, хун эвәԓԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Иисус утәԓтәты йохԓаԓа па йастәс: \"Хўщәпсайәт ӑт йŏхәтты щир ӑнтом, туп щи хŏйата шук, хŏй мŏхты хўщәпсайәт йŏхәтԓәт; ");
INSERT INTO kca_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ԓўвеԓа, тӑм ай ŏтәт эԓты ит нэш хўщты эԓты, йӑмшәк ус ԓуԓән, сапԓәԓа ун кев шуп ки тӑхәртса пӑ щарса вŏщкәса. ");
INSERT INTO kca_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ныныԓән ватман тӑйаԓән. Нӑӈ пеԓайэна йайән мўй апщен нўр туԓ ки, ԓўвеԓа йŏхԓы йасты; ԓўв нўрәԓ эԓты шӑшән керԓәԓ ки, щи нўрәԓ йŏрэми; ");
INSERT INTO kca_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","хӑтәԓ хўват ԓапәт пўш кепа нӑӈена нўр верәԓ, пӑ ԓапәт пўш хӑтәԓ хўват нӑӈ хŏщайэна йŏхәтәԓ пӑ йастәԓ: \"Ма нўрэм эԓты шӑшән керԓәԓәм\", - нўрәԓ эсԓы, йŏрэми\". ");
INSERT INTO kca_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Щӑԓта апостоләт Турәм Кущайа йастәсәт: \"Мўӈ эвәԓты верэв арамты!\" ");
INSERT INTO kca_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Турәм Куща йастәс: \"Нын горчица ԓат сэм ԓŏват эвәԓты вер тӑйсәты ки, пӑ тӑм смоква йўха йастәсты: мўв эԓты нŏх лакәптыйа пӑ щарса опсанта\", ԓўв ԓуԓән нынана хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Хŏй нын эԓтан, мўв хӑрән рупитты мўй пӑ тащ шавиты митху тӑйман, ԓўв мўв хӑр эԓты йŏхәттаԓән, ԓўвеԓа йастәԓ: \"Сорашәк мӑна, пӑсан сурыйа опса\"? ");
INSERT INTO kca_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Аԓт пӑ ԓўвеԓа йастәԓ: \"Йэтән ԓэтәт мӑнэм кавәрта пӑ, ӑнтпен нŏх йӑрман, мӑнэм ԓавәԓман, ма ԓэтэм, йищтэм эԓты ванән ԓойа, пӑ щӑԓта веԉщи нӑӈ ԓэва, йиԋща\"? ");
INSERT INTO kca_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Хотәӈ куща щи митхуйәԓ, ԓўв партәм щирәԓа вермаԓ урәӈән, пумащипа йасӈәтән йастәԓԓы а мўй? Щиты ӑт нумәсԓәм. ");
INSERT INTO kca_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Нын ищиты, хун партыԓыйәм щирән иса верԓәты, пŏтәртаты: \"Мўӈ туп митху лэӈкет, мўй верты мосәс, щит версув\". ");
INSERT INTO kca_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Иерусалим вош пеԓа мӑнман, Иисус Самария пӑ Галилея мўвӈән кўтән шушәс. ");
INSERT INTO kca_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Пӑ хун Ԓўв и кўрта йŏхәтмаԓән, йаӈ йэмәӈ ԓайӈәӈ ԋўлмәт тӑйты хŏйатәтән йэщаԓт этса. Ԓыв йэԓән иԓ ԓойсәт ");
INSERT INTO kca_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","пӑ сыйәӈ тўрән пŏтәртсәт: \"Иисус Утәԓтәты Ху! Мўӈев щаԉиты!\" ");
INSERT INTO kca_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ԓывиԓаԓ шийаԓәмаԓ кемән, Ԓўв йастәс: \"Мӑнаты, Турма йир верты хŏйатәта аԉисыйаты\". Хун ԓыв шушсәт, сыстама йисәт. ");
INSERT INTO kca_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ԓыв эԓтэԓ и хŏйат, тўмтака йўвәм шийаԓәмаԓ кемән, сыйәӈ тўрән Турәм вŏԓаӈа айәԓтман, йŏхԓы керԓәс, ");
INSERT INTO kca_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","пӑ Иисус кўр ԋŏԓаԓ шŏма, пумащипа йастыман, хŏмта иԓ керәптыйәс; щит Самария ики ус. ");
INSERT INTO kca_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Иисус йŏхԓы йастәс: \"Ӑнта мўй йаӈ хŏйат сыстапман усайәт? Йӑрәԏйаӈ пӑ хŏта? ");
INSERT INTO kca_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Мўй щирән, тӑм па мўв хŏйат тўмпийән, ԓыв йŏхԓы ӑт керԓсәт, Турма ишәк йасәӈ йастәты урәӈән?\" ");
INSERT INTO kca_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Пӑ Иисус ԓўвеԓа йастәс: \"Нŏх ԓойа пӑ мӑна; эвәԓты верэнән нӑӈ нŏх пайәтсайән\". ");
INSERT INTO kca_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Фарисейәтән иԋщәсса, хун Турәм Хон Уԓәпса йŏхәтәԓ? Ԓўв йŏхԓы йастәс: \"Турәм Хон Уԓәпса сэмән ватман ӑт йŏхәтәԓ\", ");
INSERT INTO kca_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","пӑ ӑт йастәԓәт: \"Тӑм, Ԓўв тӑта\", мўй пӑ \"Ԓўв тўта\". Пӑ тӑм, Турәм Хон Уԓәпса нын ԓыпанән уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Утәԓтәты йохԓаԓа па йастәс: \"Хӑтԓәт йŏхәтԓәт, хун нын Хŏйат Пŏх хӑтәԓԓаԓ эԓты ит ватты ԓӑӈхаԓԓән, пӑ ӑт шийаԓәԓԓән. ");
INSERT INTO kca_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Пӑ нынана йастәԓа: \"Тӑм, тӑта щи\", мўй пӑ: \"Тўм, тўта щи\" - аԓ мӑнаты пӑ аԓ ԋухԓысыйаты, ");
INSERT INTO kca_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","пӑ хутԓыйәм пŏхәл ԋоԓ иты турәм и кимԓәԓ эԓты, кимет кимԓәԓ унты вŏрԓыйәԓ, Хŏйат Пŏх Ԓўв хӑтԓәԓән щиты питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Туп оԓәӈән Ԓўвеԓ ар шук туты мосәԓ пӑ ин уԓты хŏйатәтән вана ӑт ўты вер уԓ. ");
INSERT INTO kca_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Пӑ хŏты Ной хӑтԓәтән ус, щиты Хŏйат Пŏх хӑтԓәтән питәԓ: ");
INSERT INTO kca_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","хŏйатәт ԓэсәт, йищсәт, нэ тутԓысәт, ху сайа мӑныԓысәт щи хӑтәԓ унты, хун Ной ики ковчег ԓыпийа ԓŏӈәс, пӑ ун йик йŏхтәс, пӑ хŏԓ пӑратсайәт. ");
INSERT INTO kca_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","И щиты, Лот нэмпи ики хӑтԓәтән ус: ԓэсәт, йищсәт, ԓутәссәт, тынассәт, мўв хӑр ԓэвпәс омассәт, хот омәссәт; ");
INSERT INTO kca_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","туп щи хӑтәԓән, хун Лот ики Содом вош эԓты ким этәс, турәм эԓты тўтәӈ пӑ уӈхәӈ йэрт шошмәс, пӑ хŏԓ пӑратсайәт; ");
INSERT INTO kca_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","пӑ щи хӑтәԓән щиты питәԓ, хун Хŏйат Пŏх сэма этәԓ, ");
INSERT INTO kca_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Щи хӑтәԓән, хŏй хот ԓоӈәԓән ки уԓты питәԓ, пŏрмасԓаԓ пӑ хот ԓыпийән, щит ԓывиԓаԓ ўты иԓ аԓ ŏхԓа; хŏй пӑ мўв хӑрән ки уԓты питәԓ, ищиты йŏхԓы аԓ керԓа. ");
INSERT INTO kca_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Лот ики ийими нуммәԓмийаԓән. ");
INSERT INTO kca_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Хŏй уԓәпсайәԓ шавиты утщийәԓ ки, щит ԓўвеԓ пӑратԓәԓы, хŏй пӑ уԓәпсайәԓ пӑратԓәԓы, щит ԓўвеԓ ԓыԓӈатԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Нынана пŏтәртыԓәм: \"Щи ат кӑт хŏйат и ŏԓттӑхайән: итәԓ нŏх ўԓа, киметәԓ хӑйԓа; ");
INSERT INTO kca_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","кӑт нэӈӈән и йӑха ԓат сэм шўкатты питԓәӈән: итәԓ нŏх ўԓа, киметәԓ хӑйԓа; ");
INSERT INTO kca_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","кӑтән мўв хӑрән рупитԓәӈән: итәԓ нŏх ўԓа, киметәԓ хӑйԓа\". ");
INSERT INTO kca_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Щи урәӈән Ԓўвеԓа йŏхԓы йастәса: \"Хŏта, Турәм Куща?\" Ԓўв пӑ ԓывиԓаԓа йастәс: \"Хŏта хӑԓа, щита пӑ кўркәт ӑктәщԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Иисус ԓывиԓаԓа щит эԓты утәԓтәты пŏтәр пŏтәртәс, мӑтты иса пойәкщәты мосәԓ пӑ равԓы-хушԓы уԓты ӑт мосәԓ, ");
INSERT INTO kca_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","йастәман: \"И вошән сўт ики ус, ԓўв Турәм эԓты ӑт пӑԓәс пӑ хŏйатәт эԓты ӑт йэԓамтыйәс. ");
INSERT INTO kca_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Щи вошән и икиԓы хӑщәм нэ ус, пӑ ԓўв, сўт ики хŏща йŏхтыԓыман, пŏтәртәс: \"Мӑнэм нўр верты хŏйат эԓты эԓт питы\". ");
INSERT INTO kca_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Туп ԓўв хўв ӑт кашащәс. Йухәт иԓта нŏпсәԓән йастәс: \"Турәм эԓты ма кўш ӑт пӑԓԓәм пӑ хŏйатәт эԓты ӑт йэԓәмԓайәм, ");
INSERT INTO kca_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","туп тӑм икиԓы хӑщәм имийән рома ӑт хӑйԓайәм, ԓўвеԓ эԓт питԓэм, ԓўв мӑнэма тŏрастәтыйа ԓуԓән па ӑт aт йŏхтыԓыйәс\". ");
INSERT INTO kca_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Турәм Куща йастәс: \"Хуԓԓәԓән, ӑнтом вещкат сўт ики мўй пŏтәртәԓ? ");
INSERT INTO kca_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Турәм мўй Ԓўв пирыйәм хŏйатԓаԓ, атәԓ-хӑтәԓ Ԓўвеԓ вохты ŏтԓаԓ, эԓт ӑт питԓәԓы? Пӑр мŏԓты Ԓўв ԓывиԓаԓа ԋотәп верты рŏнәԓ? ");
INSERT INTO kca_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Нынана пŏтәртԓәм, ԓывиԓаԓа сорайән эԓт питты щир мӑԓ. Туп Хŏйат Пŏх йŏхәттаԓән, эвәԓты вер мўвән а мўй уйәтәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Тухԓәт пеԓа па, хŏй ԓыв нумәссәт ԓыв тўӈа–щира уԓты хŏйатәт, пӑ па хŏйатәт ԋэрсәт, Иисус щимәщ утәԓтәты пŏтәр пŏтәртәс: ");
INSERT INTO kca_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","\"Кӑт хŏйатӈән Турәм хота пойәкщәты ԓŏксәӈән: итәԓ - фарисей, киметәԓ - налог ӑкәтты ики. ");
INSERT INTO kca_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Фарисей, утща щира ԓойман, ԓўв турмәԓән шитаман пойәкщәс: \"Йэшәк Турәм! Пумащипа Нӑӈена йастәԓәм, ма ӑнта щимәщ, ӑнта па хŏйатәт хŏрпи - ԓоԓмахәт, хорахщет, пакрасԓәты ŏтәт, мўй пӑ тӑм налог ӑкәтты ики иты: ");
INSERT INTO kca_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ԓапәт кӑт пўш вўщԓыԓәм, кашәӈ шитты ŏтэм эԓты, йаӈмет шупәԓ мӑԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Налог ӑкәтты ики пӑ, йэԓәншәк ԓойман, сэмԓаԓ турма хŏԓна нŏх аԓәмты пӑԓәс; туп мевԓәԓ хӑтщиман, пŏтәртәс: \"Йэшәк Турәм, ма, кӑрэкәӈ ху, ма пелайэм йӑмен этәԓты!\" ");
INSERT INTO kca_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Нынана йастәԓәм, щит, фарисейа пŏнман, Турәмән вещката пайәтман, йŏхи мӑнәс: кашәӈ ԓўвеԓ ԓўв ԓӑтәӈа тӑйты хŏйат ԓӑтԓыйа пӑйәтԓа, пӑ ԓўвеԓ ԓӑтԓыйа тӑйты хŏйат ԓӑтәӈа пайәтԓа. ");
INSERT INTO kca_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Иисус хŏща ай ԋаврэмәт тўтԓысайәт, Ԓўв ԋаврэмәт хŏща ԓуԓән ат хӑнәмтыйәс; утәԓтәты йохԓаԓ щит шийаԓәмеԓ кемән, ԓывиԓаԓ ӑт эсәԓты питсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Туп Иисус, ԋаврэмәт вана вохман, йастәс: \"Ԋаврэмәт Ма хŏщайэм йŏхтыԓыты эсԓаԓән, ԓывиԓаԓ аԓ йэртԓыйаԓән, щимәщ ŏтәт урәӈән Турәм Хон Уԓәпса уԓ. ");
INSERT INTO kca_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Йӑна нынана йастәԓәм: Турәм Хон Уԓәпсайа щит ӑт ԓŏӈәԓ, хŏй ԋаврэм иты, вана ԓўвеԓ ӑт ўԓԓы\". ");
INSERT INTO kca_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Щӑԓта и мӑтты кущайа уԓты ŏтән Ԓўв ищмәса: \"Сӑмәӈ Утәԓтәты Ху! Мўй мӑнэм верты мосәԓ, ԓуԓән и пўша уԓты уԓәпса ат мŏщатсәм?\" ");
INSERT INTO kca_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Иисус ԓўвеԓа йастәс: \"Мўйа нӑӈ Мӑнэм сӑмәӈа айәԓԓэн? Нэмәԓты ŏт ӑнта сӑмәӈ, туп Турәм утща; ");
INSERT INTO kca_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Турәм партәпса йасӈәт уйәтԓәԓан: \"Па хŏйат ими пиԓән, па хŏйат ики пиԓән аԓ пакрасԓа\", \"Хŏйат аԓ пӑрата\", \"Аԓ ԓоԓма\", \"Аԓ ԋаԓмийа\", \"Аԋԏен-ащен нумман тӑйи\". ");
INSERT INTO kca_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ԓўв пӑ йастәс: \"Тӑм иса ма ай эԓты шависэм\". ");
INSERT INTO kca_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Щит хуԓмаԓ кемән, Иисус ԓўвеԓа йастәс: \"Нӑӈена па ит ӑт тӑрмәԓ: иса мўй тӑйԓән, тыныйаԓән пӑ нўша хŏйатәта ортаԓән, пӑ турәмән тащ, сорԋэт тӑйты питԓән, щӑԓта йŏхта пӑ Ма йўпемән шуша\". ");
INSERT INTO kca_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ԓўв пӑ, щит хуԓмаԓ кемән, рўтаԉа йис, шек тащәӈ ус. ");
INSERT INTO kca_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Иисус, ԓўв рутаԉа йўвмаԓ, шийаԓәмаԓ кемән, йастәс: \"Мўй хŏрпи ԓавәрт тащәӈ хŏйата Турәм Хон Уԓәпсайа ԓŏӈты! ");
INSERT INTO kca_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Верблюд нэмпи войа йинтуп пўв мŏхты мӑнты хŏԓна туԓшәк, тащәӈ хŏйата Турәм Хон Уԓәпсайа ԓŏӈты эԓты\". ");
INSERT INTO kca_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Щит хуԓәм мŏхет йастәсәт: \"Хŏй пӑ нŏх пайтәсты верәтәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Туп Ԓўв йастәс: \"Хŏйатәтән ӑт верәтты щир, Турәмән верәтԓа\". ");
INSERT INTO kca_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Петра пӑ йастәс: \"Тӑм, мўӈ мўй тӑйсув, иса хŏԓ хӑйсәԓув пӑ Нӑӈ йўпенән мӑтсув\". ");
INSERT INTO kca_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ԓўв ԓывиԓаԓа йастәс: \"Йӑна нынана пŏтәртԓәм: нэмәԓты хŏйат ӑнтом, хŏй хотәԓ, мўй ащеԓ-аԋԏеԓ, мўй пӑ йайԓаԓ-опиԓаԓ-апщиԓаԓ, имеԓ мўй пӑ ԋаврэмԓаԓ Турәм Хон Уԓәпса урәӈән ԓуԓән хӑйсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","пӑ тӑм пŏрайән мет хŏԓна аршәк ԓуԓән мŏщатәԓ, йиты пŏрайән пӑ - и пўша уԓты уԓәпса\". ");
INSERT INTO kca_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Кӑтхŏщйаӈ утәԓтәты йохԓаԓ пўӈԓа вохман, ԓывиԓаԓа йастәс: \"Тӑм мўй, мўӈ Иерусалим воша мӑнԓув, пӑ щиты иса тыйәԓ, хŏты Турәм йасәӈ туты хŏйатәт сӑхат Хŏй ат Пŏх эԓты хӑшса, ");
INSERT INTO kca_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ԓўв Турәм ӑт уйәтты па рут мира мӑԓа, пӑ Ԓўв щӑԓта кӑмән щирән ԋэрԓа, шукатԓа пӑ пŏлщәӈән ԉакԓа, ");
INSERT INTO kca_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","пӑ хомщийән сэкты питԓа, пӑ Ԓўв пӑратԓа: хуԓмет хӑтәԓән пӑ нŏх ԓыԓәӈԓәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Туп утәԓтәты йохԓаԓ щит эԓты нэмәԓты ŏша ӑт пайәтсәт; щи йасӈәт ԓывиԓаԓа хӑԋа щир тӑйсәт, пӑ йастәм ŏт ԓыв ŏша ӑт пайәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Хун Ԓўв Иерихон воша ванамәс, и сэмԓы ики йуш пўӈәԓән, меԓащ вохман, опсәс, ");
INSERT INTO kca_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","щӑԓта, ԓўв пўӈԓәԓ эԓты хŏйатәт шушты хуԓмаԓ кемән, ԓўв ищмәсԓы: \"Мўй щит?\" ");
INSERT INTO kca_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ԓўвеԓа йастәса, щит Иисус Назарет эԓты йиԓ. ");
INSERT INTO kca_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Щи йўпийән ԓўв такан ўваԓтәс: \"Иисус, Давид Пŏх! Мӑнэм щаԉиты!\" ");
INSERT INTO kca_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Оԓӈа мӑнты хŏйатәт ԓўвеԓ мӑшйайа уԓты партԓэԓ; туп ԓўв па таканшәк ўваԓтәс: \"Давид Пŏх! Мӑнэм щаԉиты!\" ");
INSERT INTO kca_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Иисус иԓ ԓойәс пӑ щит Ԓўв хŏщайәԓ вана туты партсәԓы: пӑ хун щит Ԓўв хŏщайәԓ вана йŏхтәс, ԓўвеԓ ищмәсԓы : ");
INSERT INTO kca_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","\"Мўй нӑӈ Ма эԓтэм ԓӑӈхаԓән? Сэмԓы ики йастәс: \"Турәм Куща! Ԓуԓән сэмәӈа ат йисәм\". ");
INSERT INTO kca_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Иисус ԓўвеԓа йастәс: \"Сэмәӈа ат йиԓән! Нӑӈ эвәԓты верэнән нӑӈ йӑмәԓтсайән\". ");
INSERT INTO kca_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Щӑԓта ԓўв ищи мŏхты сэмәӈа йис пӑ Ԓўв йўпеԓән мӑнәс, Турәм вŏԓаӈа айәԓтман; пӑ мир хŏԓ щит ватман, Турма ишәк йасӈәт йастәты питсәт. ");
INSERT INTO kca_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Щи йўпийән Иисус Иерихон воша йŏхтәс пӑ вош хўват шушәс. ");
INSERT INTO kca_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Щита, Закхей нэмпи ий ики, ԓўв налог ӑкәтты хŏйатәт ŏх ху пӑ хŏԓна тащәӈ ху ус. ");
INSERT INTO kca_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Иисус – Щит хŏй Ԓўв, ватты кӑшсәԓы, туп мир сайән шийаԓәты ӑт веритсәԓы, пӑԓатәԓ ԓэԓ ус, щишән, ");
INSERT INTO kca_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","пӑ, оԓӈашәк хухәԓмәман, смоква йўха нŏх хуӈхәс, Иисус кащаԓәты урәӈән, Ԓўвеԓ щи пўӈәԓта мӑнты мосәс. ");
INSERT INTO kca_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Хун Иисус щи тӑхайа йŏхтәс, нŏхԓы аӈкәрмәмаԓ кемән, ԓўвеԓ шийаԓәсԓы пӑ йастәс: \"Закхей! Сорашәк иԓ ŏхԓа, тӑм хӑтәԓән Мӑнэм нӑӈ хотэнән уԓты мосәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Щитәԓән ԓўв тэрматыман иԓ ŏхԓәс пӑ амәтман Ԓўвеԓ хотәԓа тусԓы. ");
INSERT INTO kca_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Пӑ хŏԓыйэ, щит ватман, ўшмащты питсәт: \"Ԓўв кӑрэкәӈ хŏйат хŏща мойԓәты ԓŏӈәс!\" ");
INSERT INTO kca_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Закхей пӑ, ԓойман, Турәм Кущайа йастәс: \"Турәм Куща! Тӑйты хот тэԓэм и шупәԓ нўша хŏйатәта мӑԓэм, пӑ хŏй эԓты мŏԓтас усәм ки, щита ԋӑԓ пўш аратән йŏхԓы мӑԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Иисус ԓўвеԓа йастәс: \"Тӑм хӑтәԓ тӑм хота нŏх пайтәсты щир йŏхтәс, ԓўв па Авраам пŏх, щишән. ");
INSERT INTO kca_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Хŏйат Пŏх кӑншатты йŏхтәс пӑ ушәм ŏтәт нŏх пайәтты\". ");
INSERT INTO kca_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Хун ԓыв щит хуԓәтсәт, и утәԓтәты пŏтәр па пŏтәртәс: Ԓўв Иерусалим вош ԉэпән ус пӑ ԓыв нумассәт, йэшавуԓ Турәм Хон Уԓәпса щи йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Иисус щиты йастәс: \"Йӑм рут эԓты уԓты и хŏйат хўв мўва мӑнәс, ԓуԓән щита хон кущайа павтәсты урәӈән, пӑ щӑԓта йŏхԓы йŏхәтты; ");
INSERT INTO kca_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","йаӈ митйохԓаԓ вана вохман, йаӈ сорԋеӈ ŏхән ԓывиԓаԓ мӑсԓы пӑ йастәс: \"Тӑм ŏхԓән ма йŏхәттэм унты вер пеԓа мийаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Щи мўвәӈ хŏйатԓаԓән ԓўв шек ԉикән этса пӑ ԓўв йўпеԓ хўват хŏйатәт китсайәт, йастәтыйа: \"Мўӈ нўмпева щи хŏйат хŏна уԓты, мўӈ ӑт ԓӑӈхаԓув!\" ");
INSERT INTO kca_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Хун, хон кущайа питмаԓ йўпийән, йŏхԓы йŏхтәс, щи митйохԓаԓ, хŏйа сорԋэӈ ŏх мийлыйәс, ԓўв хŏщайәԓ вохты партсәԓы, щи ŏхԓаԓән хŏй мўй шитәс, щит уйәтты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Оԓәӈ митхуйәԓ йŏхтәс пӑ йастәс: \"Куща, нӑӈ и cорԋеӈ ŏхен йаӈ сорԋеӈ ŏх тус\". ");
INSERT INTO kca_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ԓўвеԓа пӑ йастәс: \"Йӑм щи, вещкат митху! Ай вер хŏща вещката уԓмен урәӈән, кущайа уԓты, йаӈ вош ўйа!\" ");
INSERT INTO kca_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Кимет митхуйәԓ йŏхтәс пӑ йастәс: \"Куща, нӑӈ и сорԋеӈ ŏхен вет сорԋеӈ ŏх тус\". ");
INSERT INTO kca_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Щитәԓа па йастәс: \"Нӑӈ па вет вош хŏща кущайа уԓа\". ");
INSERT INTO kca_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Хуԓмет митхуйәԓ йŏхтәс пӑ йастәс: \"Куща, тӑм мўй нӑӈ мера сорԋеӈ ŏхен, ма ԓўвеԓ, ŏхшама йŏвәртман, шависэм, ");
INSERT INTO kca_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ма нӑӈ эԓтэн пӑԓсәм, нӑӈ тарәм хŏйат: мўй ӑт пŏныԓысән, щит ўԓән, пӑ мўй мўва ӑт опсыԓысән, щит ӑкәтԓән\". ");
INSERT INTO kca_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Куща ԓўвеԓа йастәс: \"Вевтам митху, нӑӈ ўӈԓэнән нӑӈен сўтәтты питԓэм! Нӑӈ уйәтсэн, мўй хŏрпи ма тарәм хŏйат, мўй ӑт пŏныԓысәм, щит ўԓәм, мўй мўва ӑт опсыԓысәм, щит ӑкәтԓәм? ");
INSERT INTO kca_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Мўй урәӈән пӑ нӑӈ ма сорԋэӈ ŏхем вер пеԓа ӑт мӑсэн, ма, йŏхәттэмән ԓуԓән, йŏхԓы мŏԓтаса ўсэм!\" ");
INSERT INTO kca_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ванән ԓойты йохԓаԓ пеԓа йастәс: \"Щел ŏх ԓўв эԓтэԓ ўйаԓән пӑ йаӈ сорԋеӈ ŏх тӑйты митхуйа мийаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ԓўвеԓа мŏхет йастәсәт: \"Куща, тўмен йаӈ сорԋеӈ ŏх щи тӑйәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","\"Нынана пŏтәртԓәм, кашәӈ тӑйтаӈ хŏйата мӑты питԓа, ӑт тӑйты ŏт эԓты, мўй тӑйәԓ, щитәԓ нŏх ўԓа; ");
INSERT INTO kca_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Щи мӑнэм веԓты ŏтԓам пӑ, хŏй, мӑнэма хона уԓтыйа ӑт ԓӑӈхас, тый тўваԓән пӑ, ма ватман, щӑх сэӈкаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Щит йастәмаԓ йўпийән, Иисус йэԓԓы Иерусалим воша нŏх мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Хун Ԓўв Виффагия пӑ Вифания кўртӈән ԉэпа, Элеон нэмпи кев пай ԉэпа ванамәс, кӑт утәԓтәты хуйӈәԓаԓ тŏхи китсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","йастәман: \"Нын йэԓпанән уԓты кўрта мӑнатән; щи йŏхәттанән, иԓ йӑрәм айкам осёл уйәтԓәтән, ԓўв шӑншәԓа нэмәԓты пŏрайән нэмәԓты хŏйат ӑт опсыԓыйәс; хŏԓт эӈхаԓән пӑ тый ватәԓтаԓән; ");
INSERT INTO kca_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","мӑтты хŏйатән ищмиԓайтән ки: \"Мўйа нŏх эхԓәԓән?\", ԓўвеԓа щиты йастатән: \"Ԓўв Турәм Кущайа мосәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Китәм кӑтӈән мӑтсәӈән пӑ хŏты Ԓўв ԓынана йастәс, щиты уйәтсәԓән. ");
INSERT INTO kca_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Хун пӑ ԓын айкам осёл хŏԓт эӈхәссәԓән, войәӈ хŏйатԓаԓән ԓын иԋщәссайӈән: \"Мўйа осёл пŏшәх нŏх эхсәԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ԓын йŏхԓы йастәсӈән: \"Ԓўв Турәм Кущайа мосәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Щӑԓта ԓўвеԓ Иисус хŏща тусԓән, пӑ, ԓумәтты сŏхԓаԓ вой шӑнша пŏнман, Иисус нŏх ԓэԓтсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Щӑԓта, хун Ԓўв вой шӑшән мӑнмаԓән, хŏйатәт ԓумтәмԓаԓ йуша ԓэрәпсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Хун Ԓўв Элеон кев пай эԓты иԓ ŏхәԓты тӑхайа ванамәс, хŏԓ аратәԓ утәԓтәты йохԓаԓ, ԓыв вантәм ар йӑм йурәӈ верԓаԓ урәӈән, амәтман, сыйәӈ тўрән Турәм ишәкты питсэԓ, ");
INSERT INTO kca_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","пŏтәртман: \"Йӑмән мийәм Хон, Турәм Куща нэм урәӈән йиты Ŏт! Турәмән пайԓы уԓәпса, пӑ нумән ишәк йасәӈ!\" ");
INSERT INTO kca_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Тухәԓ фарисейәт мир кўт эԓты Ԓўвеԓа йастәсәт: \"Утәԓтәты ху! Утәԓтәты йохԓан аԓ эсԓаԓән пŏтәртты!\" ");
INSERT INTO kca_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Туп Ԓўв ԓывиԓаԓа йŏхԓы йастәс: \"Нынана пŏтәртԓәм, ԓыв ки нŏх вŏԓыԓәт, кев шупәт ўвты питԓәт\". ");
INSERT INTO kca_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Щӑԓта, хун Иисус Иерусалим ԉэпа ванамәс, вош пеԓа ватман, ԓўв урӈәԓән хоԓԓәты питәс ");
INSERT INTO kca_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","пӑ йастәс: \"Йэшәк, тӑм нӑӈ хӑтԓэнән ԓуԓән нӑӈ мŏштәсэн ки, нӑӈ пайԓы уԓәпсайэн шавиты мўй верәтәԓ! Туп щит ин нӑӈ сэмӈиԓан эԓты хӑԋатман уԓԓа, ");
INSERT INTO kca_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","хӑтԓәт йŏхәтԓәт, хун нўрмәԓтты ŏтԓанән нӑӈ, керәтман ԉаԉәсты урәӈән, мўв пайәтән хирԓайән пӑ лӑп ԓӑрәтԓайән, пӑ ар тӑха эԓты йэрмата тӑӈәртԓайән, ");
INSERT INTO kca_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","нӑӈ пӑтэн унты шўкатԓайән, ԋаврэмԓан па нӑӈ ԓыпенән пӑратԓайәт, пӑ нӑӈ ԓыпенән омәсты и хот ӑт хӑщәԓ, мўйа нӑӈ хŏщайэн Турәм йŏхтыԓыйәм пŏра ӑт мŏштәсэн, щи урәӈән!\" ");
INSERT INTO kca_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Турәм хот ԓыпийа ԓŏӈмаԓ кемән, тынасты пӑ ԓутәсты хŏйатәт ким воштәты питсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ԓывиԓаԓа пŏтәртман: \"Хӑшман уԓԓа: \"Ма Хотэм – пойәкщәты хот, нын пӑ ԓўвеԓ хорахщет хота версәԓән!\" ");
INSERT INTO kca_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Пӑ кашәӈ хӑтәԓ Ԓўв Турәм Хотән хŏйатәт утәԓтәс. Турма йир верты хŏйатәт ŏх икет пӑ Закона утәԓтәты хŏйатәт пӑ мир хŏща уна уԓты икет Ԓўвеԓ пӑратты урәӈән, пŏра кӑшсәт, ");
INSERT INTO kca_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","пӑ ӑт уйәтсәт, а хŏты Ԓўвеԓ верты; мир, Ԓўвеԓ керәтман, лӑп ԓойман, хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Щи хӑтԓәтән и пўш, хун Ԓўв хŏйатәт Турәм Хотән утәԓтәс пӑ Йӑм айкеԓ эԓты сыйәӈа пŏтәртәс, Турма йир верты хŏйатәт ŏх икет пӑ Закона утәԓтәты икет, уна уԓты икет пиԓән Ԓўв хŏщайәԓа вана хӑтсәт ");
INSERT INTO kca_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","пӑ Ԓўвеԓа йастәсәт: \"Йаста мўӈева, хŏй партатты щирән Нӑӈ тӑм вер верԓән, ӑнты ки пӑ хŏйән Нӑӈ щи йурән мӑсайән?\" ");
INSERT INTO kca_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ԓўв ԓывиԓаԓа йŏхԓы йастәс: \"Ма па нын эԓтан и вер эԓты ищмәԓәм, Мӑнэма йастаты: ");
INSERT INTO kca_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Иоанн йиӈка ԓŏӈәԓтыйәпса турәм эԓты ус мўй пӑ хŏйатәт эԓты?\" ");
INSERT INTO kca_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ԓыв пӑ ԓыв кўтԓаԓән ŏшйащман, пŏтәртсәт: \"Йастәԓув ки: 'Турәм эԓты', Ԓўв пӑ йастәԓ: 'Мўйа пӑ ԓўвеԓа ӑт эвәԓсәты?' ");
INSERT INTO kca_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Йастәԓув ки: 'Хŏйатәт эԓты', хŏйатәтән кевән щӑх сэкԓайув, ԓыв эвәԓԓәт, Иоанн щит Турәм йасәӈ туты хŏйат\". ");
INSERT INTO kca_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Щиты йŏхԓы йастәсәт: \"Ӑт уйәтԓэв хŏԓща ус\". ");
INSERT INTO kca_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Иисус йŏхԓы йастәс: \"Ма па нынана ӑт йастәԓәм, хŏй партатты щирән щит верԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Щӑԓта Иисус мир пеԓа тӑмәщ утәԓтәты пŏтәр пŏтәртты питәс: \"И хŏйат мўв хӑрән виноград йўхәт опсәс пӑ артнайа виноград ԓэвпәс энмәԓтты хŏйатәта мӑсԓы, щӑԓта йӑм хўв кеша хŏԓт мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Хун пŏра йŏхтәс, ԓўв митхуйәԓ виноград энмәԓтәм хŏйатәт хŏща китсәԓы, ԓуԓән ԓыв митхуйәԓа виноград йўхәӈ тӑхайәԓ эԓты ԓэвпәс ат мӑсәт; туп виноград энмәԓтты хŏйатәт митху сэксэԓ пӑ таԓты йŏхи китсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Щӑԓта па митху китәс; туп щи митху па, сэкман, ԋэрман, йŏхԓы таԓты китсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Хŏԓна па хуԓметәԓ китсәԓы; туп ԓыв щит па, мушмәԓтман, воштәсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Щиӈәԋща виноград йўхәӈ тӑха куща йастәс: \"А мўй мӑнэм верты?\" Сӑма мосты ма пŏхем китԓэм; мосәӈ пӑ ԓўвеԓ шийаԓәтэԓ кемән, йэԓәмԓайәт\". ");
INSERT INTO kca_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Туп виноград энмәԓтты хŏйатәт ԓўвеԓ шийаԓәмеԓ кемән, ԓыв кўтэԓән ŏшйащԓәт, пŏтәртԓәт: \"Тӑми ащеԓ ŏх вŏԓ; мӑнԓув, веԓԓэв ԓўвеԓ, пӑ ащеԓән хӑйты тащәԓ-вещәԓ мўӈева питәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Щӑԓта, виноград йўхәӈ тӑха эԓты ԓўвеԓ ким тўвман, пӑратсэԓ. Хŏты пӑ ԓывиԓаԓ виноград йўхәӈ тӑха куща верԓәԓы? ");
INSERT INTO kca_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ԓўв йŏхәтәԓ пӑ пӑратԓәԓы щи йохԓаԓ, виноград йўхәӈ тӑхайәԓ пӑ па хŏйатәта мӑԓԓы\". Щит хуԓәм мŏхет пӑ йастәсәт: \"Ӑт ат питәԓ!\" ");
INSERT INTO kca_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Туп Иисус, ԓыв пеԓайэԓ ӑӈкәртман, йастәс: \"Тӑм хӑншәм йасәӈ мўй щит: \"Кев хот омәсты хŏйатәтән мŏԓтсатәм кев шуп, щит щуӈ хŏща мет мосты кева йис\"? ");
INSERT INTO kca_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Кашәӈ ŏт, хŏй щи кев эԓты рӑкәнәԓ, ай наприйэ шўкаԓәԓ, хŏй эԓты щи кев рӑкәнәԓ, щит пŏԉха йиԓ\". ");
INSERT INTO kca_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Щи пўԉаӈ Турма йир верты хŏйатәт ŏх икет пӑ Закона утәԓтәты икет Ԓўвеԓ кӑтәԓтты ўтщисэԓ, туп хŏйатәт эԓты пӑԓԓысәт, ԓыв ŏша пайәтсэԓ, щи утәԓтәты пŏтәр ԓыв эԓтэԓ пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Щӑԓта ԓыв, Иисус эԓт ватман тӑйман, ŏщмарәӈ хŏйатәтән китса, йӑм хŏрпийа ԓэщатыман, мӑтты йасәӈ хŏща ԓуԓән Ԓўвеԓ ат мŏщатсэԓ, рим йохәтән пŏнәм сўт верты кущайа мӑты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Щӑԓта ԓыв Иисус иԋщәссэԓ: \"Утәԓтәты Ху! Мўӈ уйәтԓэв, Нӑӈ вещката пŏтәртԓән пӑ утәԓтәԓән, хŏйат веш пеԓа ӑт ватԓән, туп йӑна Турәм йуш хўват мӑнты щира утәԓтәԓән; ");
INSERT INTO kca_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","мўӈева кесарьа налог мӑты рӑхәԓ мўй ӑнта?\" ");
INSERT INTO kca_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ԓўв пӑ, ԓыв ŏщмарэԓ мŏштәман, ԓывиԓаԓа йастәс: \"Мўйа Мӑнэм хўщԓәԓән? ");
INSERT INTO kca_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Мӑнэм динарий ŏх этәԓтаты: хŏй хŏр пӑ нэм щита?\" Ԓыв йастәсәт: \"Кесарь ŏтәт\". ");
INSERT INTO kca_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Иисус ԓывиԓаԓа йастәс: \"Кесарь ŏтәт кесарьа мийаԓән, Турәм ŏтәт па Турма мийаԓән\". ");
INSERT INTO kca_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ԓыв мир йэԓпийән Ԓўвеԓ йŏвра йасәӈ урәӈән мŏщатты ӑт верәтсэԓ, пӑ, Ԓўв йŏхԓы йастәм йасәӈԓаԓ эԓты пакнысыман, шитама йисәт. ");
INSERT INTO kca_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Щиӈәԋща кӑмәтса Саддукей йŏхтәс, нŏх ԓыԓәӈԓәты вер хŏԓт хуләтты ŏтәт эԓты, пӑ Ԓўвеԓ иԋщәссәԓ: ");
INSERT INTO kca_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","\"Утәԓтәты Ху! Моисей мўӈева тӑмәщ йасәӈ хӑншәс: мӑтты, хŏй ими тӑйәм йайәԓ пӑрәԓ ки, пӑ пӑртаԓән ԋаврем ӑт тӑйәԓ, апщеԓа ԓўв имеԓ ўты мосәԓ пӑ йайәԓ ŏх вŏԓ йэԓԓы туты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ԓапәт йай усәт, оԓәӈ йай, ими тўвман, ԋаврэмԓы пӑрәс; ");
INSERT INTO kca_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","щи нэ оԓәӈ апщеԓән ўса, щӑԓта щитэн ԋаврэмԓы пӑрәс; ");
INSERT INTO kca_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","кимет апщеԓән ўса, и щиты хŏԓ ԓапәт ху, пӑ, ԋаврэм ӑт хӑйман, пӑрсәт; ");
INSERT INTO kca_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","мŏхиԓаԓ йўпийән щи нэ па пӑрәс; ");
INSERT INTO kca_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","йа щӑԓта, нŏх ԓыԓәӈԓәтыйән мӑты ŏтәԓ имийа ԓўв питәԓ, ԓапәт йай хŏԓ ԓўвеԓ нэӈа ўйԓысэԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Иисус ԓывиԓаԓа йŏхԓы йастәс: \"Тӑм йис хŏйатәт ими туԓәт па ху сайа мӑнԓәт; ");
INSERT INTO kca_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Щитәт пӑ, хŏй йиты турәмән уԓты щира пайәтса пӑ пӑрәм эԓты нŏх ԓыԓӈатԓа, нэ туты ӑт питԓәт, ху сайа мӑнты ӑт питԓәт, ");
INSERT INTO kca_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","пӑрты пӑ ӑт верәтԓәт, ԓыв ангеләт хŏрпийа йиԓәт пӑ ԓыв Турәм ԋаврэмәт, Турәмән ԓыв нŏх ԓыԓӈатсайәт. ");
INSERT INTO kca_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Щи пӑрәм ŏтәт нŏх ԓыԓәӈԓәты вер, Моисейән хŏԓна пеԓантыты варәс пŏхәлән тыйиԓыйәм пищ пŏрайән этәԓтәса, хун Турәм Куща Авраам Турма, Исаак Турма пӑ Иаков Турма нэмәтса. ");
INSERT INTO kca_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Турәм хŏты ӑнта пӑрәм ŏтәт Турәм, ԓыԓәӈ ŏтәт Турәм, Ԓўвеԓән хŏԓыйэ ԓыԓӈәт\". ");
INSERT INTO kca_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Щи йастәм ŏтәԓ пеԓа тухәԓ Закона утәԓтәты икет йастәсәт: \"Утәԓтәты Ху! Нӑӈ йӑма йастәсән\". ");
INSERT INTO kca_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Па мŏԓты оԓәӈ эԓты Ԓўвеԓ иԋщәсты ԓыв ӑт пӑ верәтсәт. ");
INSERT INTO kca_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ԓўв пӑ ԓывиԓаԓ эԓты иԋщәсәс: \"Хŏты йастәԓәт, Христос щит Давид Пŏх? ");
INSERT INTO kca_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Давид пӑ Псалмәт нэмпи нэпекән пŏтәртәԓ: \"Турәм Куща ма Турәм Кущайэма йастәс: Ма пўӈԓэма йӑм пеләк сӑхат опса, ");
INSERT INTO kca_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","щи унты, хун Ма Нӑӈена нўр верты ŏтԓан кўрԓан иԓпийа иԓ ат пŏнԓәԓам\". ");
INSERT INTO kca_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Йӑ ин, Давид Ԓўвеԓ Турәм Кущайа айәԓԓәԓы; Хŏты сӑхат Христос ԓўвеԓа Пŏха уԓты верәтәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Щи пŏрайән, хун мир аратәԓән Ԓўвеԓ хуԓәтмаԓән, Ԓўв утәԓтәты йохԓаԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","\"Закона утәԓтәты йох эԓты хурыйаты, ԓыв хўв сŏхән йӑхты сӑмәӈәт пӑ хŏйатәт ӑктәщиты тӑхайәтән ԓывиԓаԓ мосәԓ иса ўщайән верты, щит пеԓа ԓыв сӑмәӈәт, Турәм йасӈа утәԓтәты хотәтән пӑ поры пӑсан сурыйән ԓыв мет ԓӑтәӈ тӑхайән омәсты сӑмәӈәт, ");
INSERT INTO kca_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ԓыв икиԓы хӑщәм имет хот тэԓ вŏԋщала пайәтԓәт пӑ хŏйата вантәԓтәман хўв пойәкщәԓәт; ԓыв мет тарәм сўт ватԓәт!\" ");
INSERT INTO kca_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Иисус, ӑӈкәрмәмаԓән, тащәӈ хŏйатәт мойԓәпсайәт тащ ӑкәтты ԓараща пŏнты вер шийаԓәс; ");
INSERT INTO kca_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","хŏԓна Ԓўв и нўша, икиԓы хӑщәм, ими шийаԓәс, щи ими тŏхи кӑт ԉэпта нэмпи мет ай ŏх картэӈән пŏнәс. ");
INSERT INTO kca_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Иисус йастәс: \"Йӑна нынана пŏтәртԓәм, тӑм нўша ими па хŏйатәт эԓты аршәк пŏнәс. ");
INSERT INTO kca_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ԓыв хŏԓ мŏԓтасԓаԓ эԓты Турма мойԓәпса пŏтсәт, ԓўв па нўшайәԓ эԓты, мўй арат тӑйәс, хŏԓ пŏтсәԓы\". ");
INSERT INTO kca_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Щӑԓта, хун тухԓәт Турәм Хот хŏрамәӈ тынәӈ кев пŏталэтән пӑ мойԓәпсайәтән хŏрамтәм эԓты пŏтәртсәт, Ԓўв йастәс: ");
INSERT INTO kca_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","\"Хӑтԓәт йŏхәтԓәт, хун, мўй ин тӑта ватԓәты, и кев шўк ӑт хӑщәԓ; иса хŏԓ шўкатԓайәт\". ");
INSERT INTO kca_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ԓўвеԓ пӑ ищмәсэԓ: \"Утәԓтәты Ху! Хун пӑ щит питәԓ? Пӑ мўй сыр пос хўват мŏштәԓэв, хун щит питты верәԓ уԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ԓўв йастәс: \"Хурийаты, аԓт ԓэпәԓԓайты; ар ŏтәт Ма нэмемән йŏхәтԓәт, йастыман: \"Щит Ма\", пӑ \"Щи пŏра ванән\": ԓыв йўпиԓаԓән аԓ мӑнаты. ");
INSERT INTO kca_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Хун ԉаԉәт пӑ ўшмащты верәт эԓты хуԓԓәты, пӑԉщәма аԓ ўйаԓән, тӑм вера оԓәӈән уԓты мосәԓ, туп ӑнта щи пўԉаӈ хŏԓаԓа\". ");
INSERT INTO kca_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Щи пŏрайән ԓывиԓаԓа йастәс: \"И сыр мир па сыр мир пеԓа ԉаԉәсты питщәԓ, и хон пеләк кимет хон пеләк пеԓа ԉаԉәсты питщәԓ; ");
INSERT INTO kca_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ар тӑхайән мўв такан тӑрийты щирәт питԓәт, ԓэԓԓы пŏрайәт, пӑ атәм мушәт питԓәт, пӑ пӑԓщәмәт, пӑ турәм эԓты вŏԓаӈ посәт питԓәт. ");
INSERT INTO kca_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Щитәт йэԓпийән, нын иԓ катәԓтты питԓайты пӑ ԋўхәтԓыты питԓайты, Турәм йасӈа утәԓтәты хотәта, касна хотәта мӑты питԓайты, хонәта пӑ рим йохәтән пŏнәм кущайәта Ма нэмем урәӈән туты питԓайты; ");
INSERT INTO kca_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","щит нынана Ма эԓтэм вещкат йасәӈ туты вер питәԓ. ");
INSERT INTO kca_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Щиӈәԋща, сӑмԓәна пŏнаԓән: оԓӈа ӑт мосәԓ нумәсты, мўй щирән йŏхԓы йастәты, ");
INSERT INTO kca_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ма нынана щимәщ йасӈәт пӑ ŏш мӑԓәм, нын йэщаԓтән эԓԓәты ŏтԓән йŏхԓы йастәты пӑ йэщаԓт ԓойты ӑт верәтԓәт. ");
INSERT INTO kca_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Нын хŏԓна ащиԓәнән-аԋԏиԓәнән , йайԓәнән-апщиԓәнән, пӑ па рутԓәнән, пиԓйохԓәнән эԓпа аԉԓайты, пӑ нын эԓтан тухәԓԓән пӑратԓайәт; ");
INSERT INTO kca_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","пӑ Ма нэмем урәӈән хŏйатәтән хŏԓ нын ԉикән этты питԓайты, ");
INSERT INTO kca_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","туп и ŏхсŏхийэ хŏԓна ŏхԓән эԓты ӑт ушәԓ, - ");
INSERT INTO kca_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","верәтты щирԓәнән нын ԓыԓԓән этәԓтаԓән. ");
INSERT INTO kca_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Хун пӑ Иерусалим вош ԉаԉ йохәтән лӑп кертәм шийаԓәԓты, щи пŏрайән уйтаты, ԓўв таԓа йиты пŏрайәԓ вана йŏхтәс: ");
INSERT INTO kca_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","щи пŏрайән Иудея мўвән уԓты хŏйатәт кев ԓоӈԓа ат хухәԓԓәт; хŏй вошән уԓ, ким ат этәԓ, хŏй вош ԉэпән уԓ, ԓыпийа ӑт ат ԓŏӈәԓ, ");
INSERT INTO kca_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","щит йŏхԓы сŏхәптәты хӑтԓәт, хӑншәм ŏтәт хŏԓ йӑнәмԓәт. ");
INSERT INTO kca_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Щи имета шук питәԓ, хŏй щи хӑтԓәтән ԋаврэм щирән уԓ пӑ ԋаврэм эсәмән ԓапәтәԓ; вŏԓаӈ шук мўва йŏхәтәԓ, пӑ ун ԉик тӑм мира нумәԓта питәԓ: ");
INSERT INTO kca_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","щӑԓта аԓты кеши йэтәԓ эԓты рыйты питԓәт, мўв ԓŏватән уԓты мирәта ԋӑрэмәман туԓайәт; Иерусалим вош пӑ Турәм ӑт уйәтты па рут мирәтән пурәтты питԓа, пŏрайэԓ хŏԓаты унты. ");
INSERT INTO kca_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Хӑтәԓ, тыԓәщ пӑ хусәт хŏща Турәм посәт этԓыты питԓәт, мўв хŏща пӑ ар сыр мир туп ӑԓ пакнысыԓәт щарәс сыйащты эԓты пӑ овитаԓ-хўплытаԓ эԓты; ");
INSERT INTO kca_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","пӑԓщәм эԓты пӑ уԓты–омәсты мўва йиты шукәӈ верәт эԓты хŏйатәт рэԋԓы керыԓәт, турәм хусәт, тыԓщәт ԋŏхԓәԓәт. ");
INSERT INTO kca_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Щӑԓта щи пŏрайән ԓыв Хŏйат Пŏх шийаԓәԓәт, пӑԓәӈән йурәԓ пиԓән пӑ вŏԓаӈ хутԓәты–вŏрԓәты щирәԓән йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Хун пӑ щи верәт йӑнәмты питԓәт, щи пŏрайән нŏх ԓойаты пӑ ŏхԓән нŏх аԓмаԓән, нын хŏԓт пайтәсты верән вана йŏхтәс\". ");
INSERT INTO kca_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Щӑԓта Иисус ԓывиԓаԓа утәԓтәты пŏтәр пŏтәртәс: \"Смоква йўх пеԓа пӑ па йўхәт пеԓа ӑӈкәрматы: ");
INSERT INTO kca_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","хун ԓыв шўвԓаԓ пел пўншащтэԓ пŏрайән, щит пеԓа ватман, нын уйәтԓәԓән, йэшавуԓ ԓўӈ пŏра йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","И щиты нын па, хун щи питты верәт шийаԓәԓты, уйтаты, Турәм Хон Уԓәпса ванән уԓ. ");
INSERT INTO kca_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Йӑна нынана пŏтәртԓәм: ин тӑм хŏйат рут хŏԓна ӑт хŏԓаԓ, тӑм иса уԓты питтаԓән; ");
INSERT INTO kca_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","турәм пӑ мўв хŏԓт пеԓа хŏԓаԓәт, Ма йасәӈԓам йурԓаԓ ӑт хŏԓаԓәт. ");
INSERT INTO kca_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Нынәԓән нын вантаԓән, сӑмԓән, охла-щохла ԓэвман-йищман пӑ тӑйтаӈ уԓәпса эԓты нумәсман, ӑт аԓ ԓавәртамәсайәт пӑ щи хӑтәԓән шӑӈкап ӑт аԓ йŏхәтԓайты, ");
INSERT INTO kca_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","щи хӑтәԓ, мўвән уԓты кашәӈ ŏта, хоԓәп иты, лӑп лопкәԓ. ");
INSERT INTO kca_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Щиӈәԋща кашәӈ сыс эԓәпән уԓаты пӑ пойәкщаты, ԓуԓән нын щи питты верәт эԓты шаващты пӑ Хŏйат Пŏх йэщаԓт ԓойты ат верәтсәты\". ");
INSERT INTO kca_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Хӑтԓәԓән Ԓўв Турәм Хотән хŏйатәт утәԓтәс, атәтән па, вош ким пелка этман, Элеон нэмпи кев пай ԓоӈәԓән ус. ");
INSERT INTO kca_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Хŏйатәт хŏԓ аԓәӈсӑхат эԓты Ԓўв хŏщайәԓ Турәм Хота йŏхтыԓысәт, Ԓўвеԓ хуԓәтты. ");
INSERT INTO kca_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Пасхайа айәԓты, тўтәӈ ԋаԋ йэмәӈ хӑтәԓ ванамәты питәс, ");
INSERT INTO kca_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","щиӈәԋща, Турма йир верты хŏйатәт ŏх икет пӑ Закона утәԓтәты икет ар сыр пищ кӑшсәт, хŏты Иисус пӑратты ԓуԓән, ԓыв мир эԓты пӑԓсәт, щишән. ");
INSERT INTO kca_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Сатана Иуда ԓыпийа ԓŏӈәс. Ԓўв Искариота нэмәтман уса, Кӑтхŏщйаӈ эԓты ит, ");
INSERT INTO kca_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ԓўв щи мӑнәс, пӑ Турма йир верты хŏйатәт ŏх икет пиԓән па Турәм Хот шавиты кущайәт пиԓән пŏтәртәс, хŏты Иисус ԓыв йошԓаԓа мӑты. ");
INSERT INTO kca_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ԓыв нŏх амәтсәт пӑ ŏх ԓўвеԓа сŏхәптәты кашащсәт; ");
INSERT INTO kca_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","щӑԓта Иуда аԉты йастантәс пӑ кум кӑшты питәс, хун, хŏйатԓы уԓман, Иисус ԓыв йошԓаԓа мӑты питԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Тўтәӈ ԋаԋ йэмәӈ хӑтәԓ йŏхтәс. Щи хӑтәԓән Пасха ош пŏшәх мосәс хŏрты, ");
INSERT INTO kca_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Иисус Петра па Иоанн китсәԓы, йастәман: \"Мӑнатән пӑ Пасха ԓэтŏты пӑсан ԓэщататән, мўӈев ԓэты урәӈән\". ");
INSERT INTO kca_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ԓын пӑ Ԓўвеԓа йŏхԓы йастәсӈән: \"Хŏта минэмәна ԓэщатты партԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ԓўв пӑ ԓынана йастәс: \"Щи, нын воша йŏхәттан пŏрайән, нын хŏщайән йиӈки пўт аԓты хŏйат уйтатәԓ; ԓўв йўпеԓән щи хота мӑнатән, хŏԓта ԓўв ԓŏӈәԓ, ");
INSERT INTO kca_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","щӑԓта хотәӈ кущайа йастәԓтән: \"Утәԓтәты Ху нӑӈен иԋщәсәԓ: мойәӈ хŏйат урәӈән уԓты хот йӑтэн хŏта уԓ, хŏта Ма утәԓтәты йохԓам пиԓән Пасха ԓэты ԓуԓән верәтсәм?\" ");
INSERT INTO kca_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Щӑԓта ԓўв нынан ԓӑрпа ԓэрәмтәм нўм хот йӑт аԉәԓ; щита ԓэщататән\". ");
INSERT INTO kca_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ԓын мӑтсәӈән, щӑԓта хŏты Ԓўв йастәс, щиты уйәтсәԓән, пӑ Пасха лэтŏт ԓэщатсәтән. ");
INSERT INTO kca_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Щӑԓта, хун пŏра йŏхтәс, Ԓўв пӑ кӑтхŏщйаӈ апостоләт Ԓўв пиԓәԓән пӑсан сурыйа омәссәт, ");
INSERT INTO kca_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","щӑԓта Ԓўв ԓывиԓаԓа йастәс: \"Ма, шука питтэм йэԓпийән, тӑм Пасха нын пиԓанән йӑха ԓэты шек ԓӑӈхасайәм, ");
INSERT INTO kca_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","нынана пŏтәртԓәм, па йэԓԓы ԓўвеԓ ԓэты ӑт питԓэм, щи унты, хун ԓўв Турәм Хон Уԓәпсайән ӑт пўншатәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ан ўйман, Турма пумащипа йасӈәт ԋухәмман, йастәс: \"Тӑм ан ўйаԓән пӑ нын кўтәнән ортаԓән, ");
INSERT INTO kca_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","нынана пŏтәрԓәм, тӑм ўш эԓты, Турәм Хон Уԓәпса йŏхәтты унты, ўна йищты ӑт питԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Щӑԓта Ԓўв, ԋаԋ ўйман пӑ Турма пумащипа йасӈәт ԋухәмман, ԋаԋ ара морәтман, утәԓтәты йохԓаԓа мӑсԓы, щиты йастәман: \"Тӑм Ма Эԓэм, нын урӈәна пӑратты мӑԓа; тӑмиты, Мӑнэм нумәԓмәты урәӈән, вераты\". ");
INSERT INTO kca_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","И щиты анәԓ йэтән ԓэтәт йўпийән ўсԓы, йастәман: \"Тӑм ан - йӑԓәп йастантәм щир Ма кӑԓэмән, нын урӈәнән шошәмԓа. ");
INSERT INTO kca_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Щи хŏйат, хŏй Мӑнэм ӑԉԓәԓы, йошәԓ Ма йошэм пиԓән и пӑсанән ŏԓәԓ; ");
INSERT INTO kca_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Хŏйат Пŏх пиԓән иса щиты питәԓ, хŏты номәс верман уԓԓа, туп щи хŏйата шук, хŏйән Ԓўв аԉԓа\". ");
INSERT INTO kca_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Щӑԓта ԓыв кўтԓаԓән иԋщәсты питсәт, хŏй ԓыв эԓтэԓ ԓуԓән щиты верты веритәс. ");
INSERT INTO kca_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ԓыв кўтэԓән ўрайа хŏйсәт, хŏй ԓыв эԓтэԓ мет ԓӑтәӈа ԓўӈтәсты верәԓ уԓ. ");
INSERT INTO kca_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Иисус пӑ ԓывиԓаԓа йастәс: \"Хонәт мирәт нўмпийән кущайа уԓԓәт, мир кущайәт йӑм мӑты ŏтәта айәԓԓайәт, ");
INSERT INTO kca_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","нын пӑ па щирән уԓаты: хŏй нын эԓтайән уншәк, щит айашәк aт уԓ, пӑ хŏй кущайа уԓ – щит митху иты ат уԓ. ");
INSERT INTO kca_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Хŏй уншәк: хŏй пӑсан сурыйән омәсәԓ, мўй пӑ хŏй пӑсан ԓэщатәԓ? Ӑнта мўй пӑсан сурыйән омәсты ŏт? Ма пӑ нын кўтәнән пӑсан ԓэщаттыйа уԓԓәм. ");
INSERT INTO kca_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Туп нын Ма пиԓэмән Мӑнэм артаԓәты верәт хŏща усты. ");
INSERT INTO kca_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Щишән Ма нынана Хон Уԓәпса мӑԓэм, хŏты Ащем Мӑнэма мӑсԓы, ");
INSERT INTO kca_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","нын Ма пӑсанэм сурыйән Ма Хон Уԓәпсайэм хŏща па ат ԓэсты па ат йищсәты, хон омәсты тӑхайәтән омәсты пӑ Израиль кӑтхŏщйаӈ рут сўтәтты питԓәты\". ");
INSERT INTO kca_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Турәм Куща йастәс: \"Симон, Симон! Сатана партәс, мӑтты ки нын ԋаԋ ԓат сэм иты ат пӑркатсайты, ");
INSERT INTO kca_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","туп Ма нӑӈ урӈенән пойәкщәсәм, ԓуԓән нӑӈ эвәԓты верэн ӑт aт уштәсэн; щӑԓта хун нӑӈ Ма пеԓайэм керԓәԓән, йайԓан эвәԓты вер такамты\". ");
INSERT INTO kca_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Петра Ԓўвеԓа йŏхԓы йастәс: \"Турәм Куща! Нӑӈ пиԓэнән ма кўш касна хота, кўш сŏрма питты тӑхайа мӑнты верәтԓәм!\" ");
INSERT INTO kca_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Туп Ԓўв йастәс: \"Нӑӈена, Петра, пŏтәртԓәм, тӑм ат щищкурэк ўваԓтаԓ унты хŏԓна, нӑӈ Мӑнэм уйәтты верэн хуԓәм пўш лӑп ўратԓэн\". ");
INSERT INTO kca_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Щӑԓта ԓывиԓаԓа йастәс: \"Хун Ма нынан тўтхотԓы, хирԓы, кўр ԓумтәм такԓы китыԓысԓам, нын мўй нўшайа питыԓысты?\" Ԓыв йŏхԓы йастәсәт: \"Нэмәԓты хŏща\". ");
INSERT INTO kca_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Щи йўпийән Иисус ԓывиԓаԓа йастәс: \"Ин па, хŏй тўтхот тӑйәԓ ки, пӑтән ўйи, хир ищиты; хŏй ӑт тӑйәԓ ки, ԓумтәмен тыныйи пӑ аԓты кеши ԓута; ");
INSERT INTO kca_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","нынана пŏтәртԓәм: пӑ тӑм хӑншәм ŏт Ма хŏщайэм йэтшәптәты мосәԓ: \"Хŏрахщэт пеԓа Ԓўв ԓўӈәтман ус\"; Ма йушем щи йэтшәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Утәԓтәты йохԓаԓ йастәсәт: \"Турәм Куща! Тӑм, тӑта кӑт аԓты кеши\". Ԓўв утәԓтәты йохԓаԓа йастәс: \"Мета\". ");
INSERT INTO kca_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Вŏш эԓты ким этмаԓ кемән, Ԓўв, уԓԓытаԓ иты, Элеон нэмпи кев пай ԓоӈԓа хухты мӑнәс; утәԓтәты йохԓаԓ Ԓўв йўпеԓән мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Тŏхи йŏхәтмеԓ кемән, Иисус ԓывиԓаԓа йастәс: \"Пойәкщаты, атәм хўщәпсайа ԓуԓән ӑт aт питсәты\". ");
INSERT INTO kca_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Щӑԓта Ԓўв ԓыв эԓтыԓаԓ йэԓшәк, кев шук йўвәтты хўват кема, мӑнәс пӑ шанша ԓойман, пойәкщәс, ");
INSERT INTO kca_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","пŏтәртман: \"Турәм Ащи! Нӑӈ щи анэн Ма эԓтэм пўӈәԓта туты ԓӑӈхасән ки! Туп ӑнта Ма ԓӑӈхаты верэм щирән, Нӑӈ ԓӑӈхаты верэн щирән ат питәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Щиӈәԋща Ангел турәм эԓты Ԓўв хŏщайәԓа сэма этәс пӑ Ԓўвеԓ такмәԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Нŏпсәԓ ԓыпийән шукащман уԓман, таканшәк пойәкщәс, пӑ Ԓўв мўва посыты шӑкйиӈкәԓ ўр сэм хŏрпи ус. ");
INSERT INTO kca_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Пойәкщәты йэтшәмаԓ кемән, Ԓўв нŏх ԓойәс пӑ утәԓтәты йохԓаԓ хŏща йŏхтәс. Пӑ ԓывиԓаԓ шук эԓты иԓ вŏйәмтәма уйәтсәԓы, ");
INSERT INTO kca_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","пӑ ԓывиԓаԓа йастәс: \"Мўйа нын ŏԓԓәты? Нŏх киԓаты пӑ пойәкщаты, ԓуԓән атәм хўщәпсайа ӑт aт питсәты!\" ");
INSERT INTO kca_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Хун Ԓўв хŏԓна щит пŏтәртәс, ар хŏйат йэщаԓт этәс, мир йэԓпийән кӑтхŏщйаӈ утәԓтәты ху кўт эԓты уԓты Иуда нэмпи ху, шушәс. Ԓўв Иисус хŏща вана йŏхтәс, Ԓўвеԓ мосәԓтәты урәӈән. Иуда ԓывиԓаԓа щимәщ пос аԉәс: \"Хŏй ма мосәԓтәԓэм, Щит щи уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Иисус пӑ ԓўвеԓа йастәс: \"Иуда, мосәԓтәман мўй, Хŏйат Пŏх эԓпа аԉԓән?\" ");
INSERT INTO kca_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Иисус пиԓән уԓәм ŏтәт, йэԓԓы тыйты вер мŏштәман, Ԓўвеԓа йастәсәт: \"Турәм Куща, аԓты кешийән кўтәртԓув?\" ");
INSERT INTO kca_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Щӑԓта ԓыв эԓтайэԓ ит Турма йир верты хŏйатәт ŏх ики митху аԓты кешийән рэскәсԓы пӑ ԓўв йӑм пеләк пӑԓәԓ хŏԓт тўвемәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Щи пўԉаӈ Иисус йастәс: \"Хӑйаԓән, мета\". Пӑ митху пӑԓа хӑнәмтыман, ԓўвеԓ йӑмәԓтэмәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Иисус Ԓўвеԓ ԋӑрэмәты ӑктәщәм Турма йир верты хŏйатәт ŏх икета пӑ Турәм Хот шавиты кущайәта пӑ уна уԓты икета, йастәс: \"Ищи мӑтты нын хорахщи йэщаԓт аԓты кешэӈ пӑ йущәӈ йўхи тэԓән этсәты, Мӑнэм ўты урәӈән. ");
INSERT INTO kca_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Кашәӈ хӑтәԓ Ма нын пиԓәнән Турәм Хотән уԓԓысәм, нын Ма пеԓайэм йош нŏх ӑт аԓмиԓысты, ин пӑ нын пŏрайән пӑ хиԋ йура уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Щи кемән ԓыв Иисус кӑтԓәпсэԓ пӑ Турма йир верты хŏйатәт ŏх ху хота тусэԓ. Петра пӑ йэԓташәк шушәс. ");
INSERT INTO kca_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Хун ԓыв ов йэԓпи хӑр кўтәпән рат версәт пӑ йӑха омәссәт, Петра па ԓыв кўтэԓа опсәс. ");
INSERT INTO kca_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","И митнэ, ԓўвеԓ тўт пўӈәԓән омәстаԓ шийаԓәс пӑ тŏрԓы ԓўв пеԓайәԓ ватман, йастәс: \"Тӑми па Ԓўв пиԓәԓән ус!\" ");
INSERT INTO kca_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Туп Петра Ԓўв эԓтэԓ пўӈԓа уратәс, митнэӈа щиты йастәман: \"Ма Ԓўвеԓ ӑт уйәтԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Йухәт йэшавәԓ кимет хŏйат, ԓўвеԓ шийаԓәмаԓ кемән, па йастәс: \"Нӑӈ па ԓыв эԓтэԓ\". Петра щи хŏйата йастәс: \"Ӑнта!\" ");
INSERT INTO kca_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Щос кем сыс мӑнмаԓ йўпийән, хŏԓна па ху па хӑрщийа пŏтәртәс: \"Йӑна щи, тӑмен ищи Ԓўв пиԓәԓән ус, ԓўв Галилея мўв эԓты\". ");
INSERT INTO kca_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Петра па щи хŏйата йастәс: \"Ӑт уйәтԓэм, мўй эԓты нӑӈ пŏтәртԓән!\" Щи кумат, хун ԓўв хŏԓна пŏтәртәс, щищкурэк щи ўваԓтәс. ");
INSERT INTO kca_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Щи пŏрайән Турәм Куща, йŏхԓы карэмәман, Петра пеԓа ӑӈкәрмәс. Петра щиӈәԋща Турәм Куща йасӈәт нумәԓмәсԓы, хŏты Ԓўв ԓўвеԓа йастәс: \"Щищкурэк ўваԓтты йэԓпийән, нӑӈ Мӑнэм уйәтты верен хуԓәм пўш лӑп ўратысэн\". ");
INSERT INTO kca_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Щӑԓта, ким этмаԓ кемән, шук щирән хŏԓԓаԓтәс. ");
INSERT INTO kca_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Иисус, Ԓўвеԓ кӑтәԓты хŏйатәтән, кӑмән щирән Ԓўв нухсәса пӑ сэкса; ");
INSERT INTO kca_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","щӑԓта, ԓыв Ԓўв сэмӈиԓаԓ лӑп йӑрыԓысԓаԓ, вешәԓ эԓты Ԓўвеԓ рэскиԓысэԓ пӑ иԋщәсысэԓ: \"Нӑӈ Турәм йасәӈ туты хŏйат, йаста, хŏйән рэскәсайән?\" ");
INSERT INTO kca_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Па ар сыр атәм йасәӈ Ԓўв пеԓайәԓ йастәсәт. ");
INSERT INTO kca_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Туп аԓәӈ сӑхата йис, уна уԓты икет, Турма йир верты хŏйатәт ŏх икет пӑ Закона утәԓтәты йох йӑха ӑктәщсәт, пӑ ԓыв синедрионэԓа Ԓўвеԓ ԓŏӈәԓтсэԓ ");
INSERT INTO kca_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","пӑ йастәсәт: \"Нӑӈ мўй Христос? Мўӈева йасты\". Иисус ԓывиԓаԓа йастәс: \"Нынана йастәԓэм ки, нын ӑт эвәԓԓәты; ");
INSERT INTO kca_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","нынан ищмәԓәм кепа, Мӑнэма йŏхԓы ӑт йастәԓты пӑ Мӑнэм хŏԓт ӑт эсәԓԓәԓән. ");
INSERT INTO kca_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Тӑԓта йэԓԓы Хŏйат Пŏх иса йурәӈ Турәм йӑм пеләк сӑхат омәсәԓ\". ");
INSERT INTO kca_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Щӑԓта хŏԓ йастәсәт: \"Щишән Нӑӈ Турәм Пŏх?\" Ԓўв йŏхԓы ԓывиԓаԓа йастәс: \"Нын пŏтәрԓәты, Ма уԓԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ԓыв пӑ йастәсәт: \"Мўй сыр аԉәпса мўӈева хŏԓна мосәԓ? Мўӈ Ԓўв ўӈԓәԓ эԓты щи щит хуԓсув\". ");
INSERT INTO kca_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Щи арат хŏйат хŏԓыйэ нŏх ԓойсәт пӑ Ԓўвеԓ Пилат хŏща тусэԓ, ");
INSERT INTO kca_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","щӑԓта Ԓўвеԓ нўрмәԓтты питсэԓ, пŏтәртԓәт: \"Мўӈ мŏштәсэв, тӑм Ху мирэв йŏвра хўщԓәԓы пӑ, кесарьа налог мӑты ӑт эсәԓԓәԓы, Ԓўвеԓ Христос Хона айәԓԓәԓы!\" ");
INSERT INTO kca_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Пилатән Ԓўв иԋщәсса: \"Нӑӈ Иудейәт Хон?\" Иисус ԓўвеԓа йŏхԓы йастәс: \"Нӑӈ щиты йастәԓән\". ");
INSERT INTO kca_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Пилат Турма йир верты хŏйатәт ŏх икета пӑ мир пеԓа йастәс: \"Ма нэмәԓты нўр тӑм хŏйат хŏща ӑт уйәтԓәм\". ");
INSERT INTO kca_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Туп ԓыв ўрайԓаԓ нŏх пайәтԓыԓаԓ, пŏтәртман, мӑтты ки Ԓўв Иудея ԓŏватән, Галилея эԓты ўйман тӑм вош унты, мир утәԓтыман, йэшащты хўщԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Пилат Галилея эԓты хуԓмаԓ кемән, ищмәс: \"Ԓўв мўй Галилея мўв ху?\" ");
INSERT INTO kca_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Щӑԓта, Ԓўв Ирод хон мўв эԓты уԓтаԓ ŏша пайәтмаԓ кемән, Ԓўвеԓ Ирод хŏща китсәԓы. Ирод щи хӑтԓәтән ищи Иерусалим вошән ус. ");
INSERT INTO kca_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ирод Иисус шийаԓәмаԓ кемән, нŏх амтәс, ԓўв Иисус хўвән ватты ԓӑӈхаса, Ԓўв эԓтайәԓ ар хуԓԓыйәс, щишән. Щӑԓта пӑ мӑтты пищ Ԓўв эԓтэԓ шийаԓәты нумәсыйәс, ");
INSERT INTO kca_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","пӑ Ԓўвеԓ арсыр вер эԓты иԋщәссәԓы, туп Иисус ԓўвеԓа нэмәԓты ӑт йастәс. ");
INSERT INTO kca_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Турма йир верты хŏйатәт ŏх икет пӑ щӑԓта Закона утәԓтәты йох ванән ԓойсәт пӑ Ԓўвеԓ шек нўрисэԓ. ");
INSERT INTO kca_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ирод соԓтанԓаԓ пиԓән Ԓўвеԓ иԓ ԋэрмаԓ пӑ ԋӑха ԋӑхмаԓ йўпийән, хон сŏха Ԓўвеԓ ԓумәттәсԓы пӑ йŏхԓы Пилат хŏща китсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Щӑԓта, Ирод пӑ Пилат йэԓпи ԓын кўтәнән кўтәӈа усӈән, щи хӑтәԓән пӑ ԓухса верәссәӈән. ");
INSERT INTO kca_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Пилат пӑ, Турма йир верты хŏйатәт ŏх икет, кущайәт пӑ мир ӑкәтмаԓ, ");
INSERT INTO kca_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ԓывиԓаԓа йастәс: \"Нын ма хŏщайэма тӑм хŏйат, мир йŏвра хўщты ŏт йўкана, тусԓән; тӑта щи, ма нын уԓман ԓэрапсэм пӑ тӑм хŏйат, нын Ԓўвеԓ нўрмәԓтан щирән, нэмәԓты хŏща нўрәӈа уԓтаԓ ӑт уйәтсэм. ");
INSERT INTO kca_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ирод ики ищи, ма Иисус ԓўв хŏщайәԓ китыԓысэм; сŏрәм кеша, нэмәԓты верәм вер Ԓўв хŏщайәԓ ӑт уйәтса; ");
INSERT INTO kca_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","щишән, хомщийән сэкты йўпийән, ма Ԓўвеԓ эсәԓԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Пилата, йэмәӈ хӑтәԓ урәӈән, ԓывиԓаԓа касна хот эԓты и хŏйат эсәԓты мосәс. ");
INSERT INTO kca_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Туп ԓыв аратэԓән хŏԓыйэ и тўрән ўвты питсәт: \"Щитэн ўйи, мўӈева Варавва эсԓы!\" ");
INSERT INTO kca_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Варавва, хŏйатәт пиԓән вошәӈ мир пеԓа йэшащман уԓмаԓ урәӈән пӑ веԓтатмаԓ урәӈән, касна хота омәсман уса. ");
INSERT INTO kca_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Туп Пилат, Иисус хŏԓт эсәԓты ўтщисԓы, пӑ ипуш па ԓывиԓаԓа такан йастәс. ");
INSERT INTO kca_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ԓыв туп ўвсәт: \"Пернайа сэӈки! Пернайа Ԓўвеԓ сэӈки!\" ");
INSERT INTO kca_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Пилат хуԓмет пўш ԓывиԓаԓа йастәс: \"Мўйсыр атәм вер Ԓўв верәс? Сŏрәм кеша, ма нэмәԓты атәм вер Ԓўв хŏщайәԓ ӑт уйәтсәм; щишән, хомщийән сэкты йўпийән, Ԓўвеԓ эсәԓԓэм\". ");
INSERT INTO kca_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Туп ԓыв, такан ўвман сурман, партсәт, Иисус пернайа ат сэкса; ԓыв пӑ Турма йир верты хŏйатәт ŏх икет ўв сыйэԓ нŏх питәс. ");
INSERT INTO kca_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Щӑԓта Пилат, хŏты ԓыв ԓӑӈхасәт, щиты кашащәс; ");
INSERT INTO kca_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ԓўв щит ким эсԓәс, хŏй ԓыв вохсәт, щит, хŏй, йэшащәм пӑ веԓтантәм вер урәӈән, касна хотән ус, Иисус пӑ ԓыв ԓӑӈхатэԓ щира мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Хун Ԓўвеԓ туты питсэԓ, мўв хӑрәԓ эԓты шушәм Симон, Киринея мўвәӈ ики, пӑтән хŏрэмәса; ԓўв порхәԓа перна шуп пŏтса, Иисус йўпийән ат тусԓы. ");
INSERT INTO kca_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ԓўв йўпеԓән щи арат ар мир шушәс пӑ щи кўтән нэӈәт Ԓўв урӈәԓән такан хоԓԓәсәт пӑ йирӈәԓтысәт. ");
INSERT INTO kca_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ԓыв пеԓайэԓ керԓәман, Иисус йастәс: \"Иерусалим эвет, Ма урӈемән аԓ хŏԓԓаты, нын урӈәнән пӑ нын ԋавремԓән урәӈән хоԓԓаты, ");
INSERT INTO kca_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","хӑтԓәт щи йŏхәтԓәт, хун йастәԓа: \"Ԋаврэмән ӑт партәм нэӈәт, пӑ ԋаврем хŏԓна ӑт тайәм нэӈәт, пӑ эсәмән ӑт ԓаптыԓыйәм нэӈәт ŏй тӑйԓәт!\" ");
INSERT INTO kca_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Щи пŏрайән кев пайәта йастәты питԓа: \"Мўӈ эԓтэв ӑркәмтаты!\" пӑ сӑхмәта: \"Мўӈев эԓт лаӈкаԓән!\" ");
INSERT INTO kca_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Вŏсты лыптәӈ йўх щиты ки верԓа, сорәм йўх пӑ мўй тӑйәԓ?\" ");
INSERT INTO kca_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ԓўв пиԓәԓән пӑрты тӑхайа хŏԓна кӑт хорахщи туса. ");
INSERT INTO kca_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Пӑ хун \"Ŏх ԓŏв\" нэмпи тӑхайа йŏхәтсәт, щита Ԓўвеԓ пернайа сэксэԓ, хŏрахщэӈән па, итәԓ йӑм пеләк сӑхат, киметәԓ пӑрта пеләк сӑхат. ");
INSERT INTO kca_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Иисус пӑ пŏтәртәс: \"Ащи, ԓывиԓаԓ нўра аԓ ўйи, мўй верԓәт, ӑт уйәтԓәт\". Пос вŏщкиман, Ԓўв сŏхԓаԓ ортԓысԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Хŏйатәт ԓойсәт пӑ ватсәт. Ԓыв пиԓԓаԓән кущайәт па хўләщсәт, пŏтәртман: \"Па хŏйатәт нŏх пайтыԓыйәс; Ԓўв Христос, Турәм пирыйәм Ŏт ки, Ԓўвеԓ Ԓўв нŏх aт пайәтԓәԓы\". ");
INSERT INTO kca_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ԉаԉ йох ищиты Ԓўв эԓтайәԓ, вана хӑтыԓыман, вŏщрем ўна ўӈԓәԓа тутԓыман, хўләщсәт ");
INSERT INTO kca_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","пӑ пŏтәртсәт: \"Нӑӈ - Иудейәт Хон ки, Нӑӈен Нӑӈ нŏх пайты!\" ");
INSERT INTO kca_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ԓўв нўмпеԓән грек, рим пӑ еврей йасӈәтән хӑшман уса: \"Тӑми - Иудейәт Хон\". ");
INSERT INTO kca_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Пернайа сэӈкәм и хорахщи, ԉикащман, Ԓўв пеԓайәԓ пŏтәртәс: \"Нӑӈ Христос ки, Нӑӈен нŏх пайты, пӑ мўӈев па!\" ");
INSERT INTO kca_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Киметәԓ пӑ, ԓўвеԓ нŏх вŏԓәтԓәԓы, йастыйәԓ: \"Турәм эԓты мўй нӑӈ ӑт пӑԓԓән, хун нӑӈ па щиты сўтәтман ӑт уԓԓайән? ");
INSERT INTO kca_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Мин хŏты вещката сутәтсаймән, мин верԓәмән хўват мŏщатсәмән. Ԓўв пӑ нэмәԓты атәм ӑт верәс\". ");
INSERT INTO kca_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Щӑԓта Иисуса йастәс: \"Мӑнэм нумәԓмийэ, Турәм Куща, хун Нӑӈ Хон Уԓәпсайэна йŏхәтԓән!\" ");
INSERT INTO kca_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Иисус ԓўвеԓа йастәс: \"Йӑна нӑӈена йастәԓәм, тӑмхӑтәԓ щи Ма пиԓэмән ŏйәӈ-щўԋәӈ тӑхайән уԓты питԓән\". ");
INSERT INTO kca_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Хӑтәԓ хутмет щос ԉэп ус, мўв ԓŏватән йӑрәԏйаӈ щос унты пӑтлама йис: ");
INSERT INTO kca_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","щиӈәԋща най хурԓәс, пӑ Турәм Хот ԓыпийән йэртэп сŏх кўтԓәпәԓ эԓты кӑтна тŏхнәмтәс. ");
INSERT INTO kca_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Иисус, сыйәӈ тўрән ўваԓман, йастәс: \"Ащи! Нӑӈ йошӈиԓана Ма ԓыԓэм мӑԓэм\". Щиӈәԋща, щит йастәман, ԓыԓәԓ эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Сот ԉаԉ йох ŏх ху пӑ, щи тыйәм вер пеԓа ватмаԓ эԓты, Турәм ишәксәԓы пӑ йастәс: \"Йӑна пӑ тӑм хŏйат тўӈа–щира хŏйат уԓмаԓ\". ");
INSERT INTO kca_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Щит ватты йŏхтәм мир хŏԓыйэ, тыйәм вер пеԓа ватман, мевәԓаԓ эԓты ԓывиԓаԓ ԓыв сэкман, йŏхԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Хŏԓыйэ, Иисус уйтәм мŏхет, пӑ Галилея эԓты Ԓўв йўпеԓән йўвәм нэӈәт йэԓәншәк ԓойсәт пӑ щийэԓ ватсәт. ");
INSERT INTO kca_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ӑктәщиты хŏйатәт кўтән Иосиф нэмпи ики ус. Ԓўв сӑмәӈ пӑ вещкат ус. ");
INSERT INTO kca_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ӑктәщиты тӑхайән хŏйатәт пиԓән ӑт кашащәс, ԓыв верэԓ хŏща ӑт ус; Ԓўв Иудеяйән уԓты Аримафея вошәӈ ху, Турәм Хон Уԓәпса ищи ԓавәԓман ус. ");
INSERT INTO kca_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Пилат хŏща йŏхтәс пӑ Иисус мотавтәԓ вохсәԓы; ");
INSERT INTO kca_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","щӑԓта перна эԓты ԓўвеԓ иԓ ўйман, щи кеша уԓты пуԓән щӑшканән йŏвәрмәсԓы пӑ кев пай ԓыпийән хот йӑт ԓŏват сэврәм тӑхайа пŏтсәԓы. Щи тӑхайа хŏԓна нэмәԓт хŏйат пŏнман ӑт уса. ");
INSERT INTO kca_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Щит шаббат хӑтԓа ԓэщатыты пŏра ус, пӑ щи хӑтԓа йиты щи питәс. ");
INSERT INTO kca_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Иисус пиԓән Галилея эԓты йŏхтәм нэӈәт па Иосиф йўпийән шушсәт пӑ ӑпа пŏнты кев хот ватсэԓ пӑ хŏты Ԓўв мотавтәԓ пŏнман уса ищи; ");
INSERT INTO kca_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","воша йŏхәтмеԓән йӑм эпԓәӈ йик пӑ миро вŏй ԓэщатсәт. Шаббат хӑтәԓән Турәм партәпса йасәӈ щирән ԓыв щутщәман усәт. ");
INSERT INTO kca_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ԓапәт ŏх хӑтәԓән, шек аԓәӈ, нэӈәт ԓэщатәм йӑм эпԓәӈ йикԓаԓ тўвман, Иисус пŏнәм тӑхайа мӑтсәт; ԓыв пиԓэԓән йӑха тухәԓ мŏхет па мӑтсәт; ");
INSERT INTO kca_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","туп ов кев шупәԓ, пўӈԓа хӑтәԓтәма уйәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Щӑԓта, ԓыпийа ԓŏӈмеԓән, ԓыв Иисус, Турәм Куща, мотавтәԓ щита ӑт уйәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Хун ԓыв щит эԓты шоптамәман ԓойтэԓ сӑхат, и мŏԓтыйән, имет йэԓпийән вŏԉиты сŏхәӈ кӑт хуйӈән этсәӈән. ");
INSERT INTO kca_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Щӑԓта, хун ԓыв пӑԓтамәсәт пӑ шанша хŏмта керәптысәт, ԓывиԓаԓа йастәсӈән: \"Мўйа нын ԓыԓәӈ Ŏт пӑрәм ŏтәт кўтән кӑшԓәԓән? ");
INSERT INTO kca_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ԓўв тӑта ӑнтом: Ԓўв нŏх ԓыԓәӈԓәс; нумәԓмаԓән, хун Ԓўв хŏԓна Галилея мўвән уԓмаԓән, нынана йастыԓыйәс: ");
INSERT INTO kca_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","\"Хŏйат Пŏх кӑрэкәӈ хŏйатәт йоша мӑты вер уԓ, щӑԓта пернайа сэкты вер уԓ, пӑ хуԓмет хӑтәԓән нŏх ԓыԓәӈԓәты верәԓ уԓ\". ");
INSERT INTO kca_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Щӑԓта Ԓўв йастәм йасәӈԓаԓ ԓыв нумәԓмәсԓаԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Пŏнәм тӑхайэԓ эԓты йŏхԓы йŏхәтмеԓән, ихŏщйаӈ утәԓтәты йохԓаԓа пӑ па хŏйатәта вантәм вер эԓты пŏтәртсәт. ");
INSERT INTO kca_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Щит Магдалинайа айәԓтты Мария, Иоанна, пӑ Иаков аԋԏи - Мария, пӑ ԓыв пиԓэԓән па имет усәт, хŏйтат апостолԓаԓа щи оԓәӈ эԓты йастәсәт. ");
INSERT INTO kca_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Щӑԓта утәԓтәты йŏхәта ԓыв йасәӈԓаԓ ӑԓ мŏԓтыйа усәт, пӑ ԓыв нэӈәта ӑт эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Туп Петра, нŏх ԓойәс пӑ пŏнәм тӑхайа хухәԓмәс. Тŏхи йŏхәтмаԓән, ԓыпийа ӑӈкәрмәс пӑ щита туп пуԓән щӑщканәт ŏԓтаԓ шийаԓәс. Ԓўв нŏпсәԓән пакнысыман, йŏхԓы керԓәс. ");
INSERT INTO kca_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","И щи хӑтәԓән ԓыв эԓтайэԓ кӑт утәԓтәты ху Эммаус курта шушсәӈән. Щи курта Иерусалим вош эԓты кӑт щос кем кўрән шушты хўват ус; ");
INSERT INTO kca_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","пӑ ԓын кўтәнән иса щи верәт эԓты пŏтәртсәӈән. ");
INSERT INTO kca_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Пӑ хун ԓын кўтәнән пŏтәртсәӈән пӑ ŏшйащсәӈән, пӑ Иисус Ԓўв ԓынан эԓт йŏхәтман, ԓын пиԓәнән йэԓԓы мӑнәс. ");
INSERT INTO kca_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Туп ԓын сэмӈиԓән катәԓман усайтән, пӑ ԓын Ԓўвеԓ ӑт уйәтсәԓән. ");
INSERT INTO kca_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ԓўв пӑ ԓынан ищмәсԓы: \"Мўй эԓты нын кўтәнән шушман пŏтәрԓәтән, мўй урәӈән нын рўтаԉӈән?\" ");
INSERT INTO kca_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Итәԓ, Клеопа нэмпи хŏйатәԓ, Ԓўвеԓа йастәс: \"Пӑрмŏԓтты Нӑӈ туп утща, Иерусалим воша йŏхтәм хŏйатәт эԓты, ӑт уйәтԓән тӑм хӑтԓәтән щита тыйәм вер эԓты?\" ");
INSERT INTO kca_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Щӑԓта Ԓўв ԓынан ищмәсԓы: \"Мўй эԓты?\" Ԓын Ԓўвеԓа пŏтәртсәԓән: \"Назарет эԓты уԓты Иисус пиԓән мўй ус, Турәм йасәӈ туты хŏйата ус, верән пӑ йасәӈән Турәм хŏща, аратәԓ мир хŏща йурәӈ ус. ");
INSERT INTO kca_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Турма йир верты хŏйатәт ŏх икԓувән пӑ кущайԓувән Ԓўв сŏрма пайәтты мӑсэԓ пӑ пернайа Ԓўвеԓ сэксэԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Мўӈ пӑ нŏмәс пŏныԓысув, Ԓўв Щит, Хŏй Израиль хŏԓт пайәтты верәԓ уԓ; туп щи ар вер тыймаԓ, ин хуԓмет хӑтԓәԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Мўӈ нэԓув эԓты тухәԓаԓ па мўӈев пакнәптысэԓ: ԓыв пŏнәм лотәԓән аԓәӈ сӑхат аԓәӈ усәт ");
INSERT INTO kca_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","пӑ Ԓўв мотавтәԓ щита ӑт уйәтсэԓ, йŏхԓы йŏхәтсәт пӑ пŏтәртсәт, мӑтты ԓыв ангелӈән этԓыйәм вер па ватмеԓ пӑ щитӈән пŏтәртан, мӑтты Ԓўв ԓыԓәӈ. ");
INSERT INTO kca_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Щӑԓта мўӈ эԓтэв тухԓәт ищи пŏнәм лотәԓа мӑтсәт пӑ щиты уйәтсэԓ, хŏты нэӈәт йастыԓысәт, туп Ԓўвеԓ ӑт ватсэԓ\". ");
INSERT INTO kca_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Щиӈәԋща Иисус ԓынана йастәс: \"Нын ŏшԓы пӑ ром сӑмпи ŏтәт, нынана щи ԓавәрт Турәм йасәӈ туты икет аԉәм верәта эвәԓты! ");
INSERT INTO kca_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Христоса мўй ӑнта щиты шук туты мосәс пӑ Ԓўв хутԓәты–вŏрԓәты щирәԓа ԓŏӈты?\" ");
INSERT INTO kca_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Щӑԓта, Моисей пӑ хŏԓ Турәм йасәӈ туты икет эԓты питщәман, ԓынана, мўй Ԓўв эԓтэԓ иса Йэмәӈ Нэпекән хӑшман уԓԓа, Ԓўв ԓэра верԓәԓы. ");
INSERT INTO kca_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Щиты ԓыв щи куртэԓа ванамәсәт, хŏԓта шушсәт; щӑԓта Иисус йэԓԓы мӑнты ԓӑӈхаты щир верәс. ");
INSERT INTO kca_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Туп ԓын Ԓўвеԓ иԓ вŏԓәтԓәԓән, пŏтәртман: \"Мин пиԓэмән хӑща, хӑтәԓ йэтән пеԓа мӑнты питәс\". Щӑԓта Ԓўв хота ԓŏӈәс пӑ ԓын пиԓәнән хӑщәс. ");
INSERT INTO kca_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Пӑ хун Ԓўв ԓын пиԓәнән пӑсан сурыйән омәсмаԓән, ԋаԋ ўйман, Турма пумащипа йасӈәт йастәс, ԋаԋ морәтсәԓы пӑ ԓынана мӑсԓы. ");
INSERT INTO kca_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Щи пŏрайән веԉщи ԓын сэмӈиԓән пелки пуншащсәӈән, пӑ ԓын Ԓўвеԓ мŏштәсԓән. Туп Ԓўв ԓынана ӑт ныты питса. ");
INSERT INTO kca_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ԓын кўтәнән йастәсӈән: \"Мин сӑмԓәмән мўй ӑт щарисӈән, хун Ԓўв йушән минэмәна пŏтәртәс пӑ хун Йэмәӈ Нэпек йасӈәт минэмәна ԓэра верәс?\" ");
INSERT INTO kca_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ищи мŏхты ԓын нŏх ԓойсәӈән пӑ Иерусалим воша йŏхԓы керԓәсӈән, щита ԓын ихŏщйаӈ йӑха ӑктәщәм апостол уйәтсәԓән пӑ ԓыв пиԓԓаԓән уԓәм мŏхет па. ");
INSERT INTO kca_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ԓыв пŏтәртсәт, мӑтты Турәм Куща йӑна нŏх ԓыԓәӈԓәс пӑ Симон хŏща этәс. ");
INSERT INTO kca_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Щӑԓта ԓын йушән тыйәм вер эԓты пŏтәртсәӈән, пӑ хŏты ԓын Ԓўвеԓ ԋаԋ морәтмаԓ хўват мŏштәсԓән. ");
INSERT INTO kca_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Хун ԓын щи оԓәӈ эԓты пŏтәртсәт, Иисус Ԓўв ԓыв кўтэԓән этәс пӑ ԓывиԓаԓа йастәс: \"Йӑм уԓәпса нынана\". ");
INSERT INTO kca_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ԓыв, ԓыԓэмәман пӑ пӑԓтамәман, нумәссәт, иԓампа сэмсай ŏт ватԓәт. ");
INSERT INTO kca_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Туп Ԓўв ԓывиԓаԓа йастәс: \"Мўйа нын щиты ԓыԓэмәсты? Пӑ мўй урәӈән нын сӑмԓәна щимәщ нŏпсәт ԓŏӈԓәт? ");
INSERT INTO kca_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Йошԓам–кўрԓам пеԓа ӑӈкәрматы; тӑм иса Ма. Ма хŏщайэма хӑнәмтыйаты пӑ вантыйаԓән; сэмсай ŏт эԓ–ԋŏхи пӑ ԓŏв ӑт тӑйәԓ, хŏты нын Ма хŏщайэм ваттанән\". ");
INSERT INTO kca_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Щит йастәман, Ԓўв йошӈәԓаԓ пӑ кўрӈәԓаԓ ԓывиԓаԓа этәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Хун ԓыв амәтмеԓ рўвән хŏԓна ӑт эвәԓсәт пӑ ӑԓ пакнысысәт, Ԓўв ԓывиԓаԓ ищмәсԓы: \"Мŏԓты ԓэтәт нын тӑта ӑт тӑйԓәты?\" ");
INSERT INTO kca_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ԓыв Ԓўвеԓа сӑӈхәртәм хўԓ шуп пӑ мав мӑсәт. ");
INSERT INTO kca_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Щӑԓта ўсԓы пӑ, ԓыв ватман, ԓэсԓы. ");
INSERT INTO kca_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Пӑ ԓывиԓаԓа йастәс: \"Тӑм щит, мўй эԓты Ма нынана пŏтәртысәм, хун нын пиԓәнән уԓмемән, иса щит питты верәԓ уԓ, мўй Ма эԓтэм Моисей Закон йасӈәт хŏща, Турәм йасәӈ туты хŏйатәт хŏща пӑ Псалмәт хŏща хӑшман уԓԓа\". ");
INSERT INTO kca_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Щиӈәԋща Ԓўв, Йэмәӈ Нэпек йасӈәт мŏштәты урәӈән, ԓыв ŏшԓаԓ пел пайәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Щӑԓта ԓывиԓаԓа йастәс: \"Щиты хӑшман уԓԓа, пӑ щиты Христоса шук туты мосәс, пӑ пӑрәм эԓты хуԓмет хӑтәԓән нŏх ԓыԓәӈԓәты мосәс, ");
INSERT INTO kca_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ԓўв нэмәԓән мирәта хŏԓ, Иерусалим вош эԓты питщәман, кӑрэк эԓты шӑшән керԓәты пӑ йŏрэмәты щир сыйәӈа пŏтәртты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Нын пӑ иса щи верәт вантәм хŏйатәта уԓты питԓәты. ");
INSERT INTO kca_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Щӑԓта Ма Ащем аԉәм ŏт нынана китԓәм; нын пӑ нумәԓта йурән йохәттан унты, Иерусалим вошән хӑщаты. ");
INSERT INTO kca_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Иисус утәԓтәты йохԓаԓ вош эԓты ким, Вифания унты тусԓы, щӑлта йошԓаԓ нŏх аԓәмман, ԓывиԓаԓ йӑмән мӑсԓы, ");
INSERT INTO kca_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","пӑ, хун ԓывиԓаԓ йӑмән миймаԓ сыс щи кемән ԓыв эԓтэԓ йэԓ мӑнты пӑ турма нŏх пайтәсты питәс. ");
INSERT INTO kca_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ԓыв, Ԓўв йэԓпеԓән шашԓаԓ иԓ эсәԓсәԓаԓ пӑ Иерусалима, ун амәтән амәтман, йŏхԓы керԓәсәт. ");
INSERT INTO kca_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Пӑ иса Турәм Хотән уԓԓысәт, Турәм ишәкман пӑ Ԓўвеԓа йӑм йасәӈ йастәман. Амиԋ.");
INSERT INTO kca_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Оԓәӈ нэпекем ма нӑӈена, Феофил, иса щит эԓты хӑшсэм, мўй Иисус верәс пӑ мўйа утәԓтәсԓы оԓӈәԓ эԓты ");
INSERT INTO kca_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","щи хӑтәԓ унты, хун Йэмәӈ Ԓыԓ сӑхат Ԓўв пирыйәм апостолԓаԓа партәпсайәт мийман, Ԓўв турма нŏх ўйман уса. ");
INSERT INTO kca_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ԓўв шукәԓ йўпийән, ар тŏрԓы уԓты посԓаԓ пиԓән, щитԓаԓа щи Ԓўвеԓ ԓыԓӈат этәԓтәсԓы, ԋӑԓйаӈ хӑтәԓ хўват ԓыв хŏщайэԓ этыԓыйәс пӑ Турәм Хон Уԓәпса эԓты пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Щӑԓта, ԓывиԓаԓ йӑха ӑкәтман, Ԓўв ԓывиԓаԓа партсәԓԓы: «Иерусалим эԓты аԓ мӑнаты, Ащэм аԉәм ŏт ԓавԓаты, хŏты Ма эԓтэм хуԓԓысты, ");
INSERT INTO kca_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Иоанн йиӈка ԓŏӈәԓтыйәс, нын пӑ, тӑми йўпийән кӑмәтса хӑтәԓ кемән Йэмәӈ Ԓыԓа ԓŏӈәԓтты питԓайты». ");
INSERT INTO kca_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Хун ԓыв йӑха ӑктәщсәт, Ԓўвеԓ иԋщәссэԓ, пŏтәртман: «Турәм Куща, Израиль хон пеләк ӑнта мўй ин Нӑӈ нŏх йӑԓпитԓэн?» ");
INSERT INTO kca_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Иисус пӑ ԓывиԓаԓа йастәс: «Ащем Ԓўв йурәԓән пŏнәм пŏрайәт мўй сысәт уйәтты, ӑнтом нын верән, ");
INSERT INTO kca_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","нын йур вана ўԓты, хун нын хŏщайән Йэмәӈ Ԓыԓ ŏхәԓәԓ; пӑ Иерусалимән пӑ иса Иудея пӑ Самария ԓŏватән хŏԓна пӑ мўв кимәԓ унты Мӑнэм вантәм хŏйатәта уԓты питԓәты». ");
INSERT INTO kca_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Щит йастәмаԓ кемән, ԓыв ватман, Ԓўв нŏх эԓәтса, пӑ пӑԓәӈән ԓыв сэмԓаԓ эԓты лӑп ўса. ");
INSERT INTO kca_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Щиӈәԋща, хун ԓыв турәм хӑр пеԓа ватмеԓән, Ԓўв нŏх эԓԓәмаԓ пŏрайән, шӑмкапан ԓыв йэԓпиԓаԓән нŏви ԓумтәмәӈ кӑт ху этсәӈән ");
INSERT INTO kca_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","пӑ йастәсӈән: «Галилея йох! Мўй нын ԓойԓәты пӑ турәм хӑр пеԓа ватԓәты? Тӑм Иисус, нын эԓтан турма нŏх ўйәм Ŏт, тӑм иты щи йŏхәтәԓ, хŏты нын Ԓўвеԓ турма эԓԓәтаԓ ватсәԓән». ");
INSERT INTO kca_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Щиӈәԋща ԓыв Иерусалим воша, Элеона айәԓты кев пай эԓты, йŏхԓы йŏхәтсәт, ԓўв Иерусалим ԉэпән шаббат хӑтәԓ шушты хўватән уԓ. ");
INSERT INTO kca_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Щӑԓта, йŏхԓы йŏхәтмеԓ йўпийән, нўм хот йӑта, хŏта уԓԓысәт, нŏх мӑтсәт: Петр пӑ Иаков, Иоанн пӑ Андрей, Филипп пӑ Фома, Варфоломей пӑ Матфей, Иаков Алфей пŏх пӑ Симон Зилот, пӑ Иуда, Иаков пŏх усәт. ");
INSERT INTO kca_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Хŏԓыйэ ԓыв и йӑха пойәкщәман усәт нэӈәт пӑ Мария, Иисус аԋԏи пиԓән, пӑ Ԓўв ху апщиԓаԓ пиԓән. ");
INSERT INTO kca_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Пӑ щи хӑтԓәтән Петр, утәԓтәты йŏх кўтән нŏх ԓойман, йастәс, – ");
INSERT INTO kca_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","сот хус кем хŏйат йӑха ӑктәщиты щир ус: «Хӑнам йох! Щита тыйты мосәс, мўй Йэмәӈ Нэпекән Йэмәӈ Ԓыԓ Давид ўӈәԓән Иуда эԓты йастәс. Иисус ԋӑрэмәм ŏтәт хŏща ԓўв ŏха ус; ");
INSERT INTO kca_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ԓўв мўӈ хŏщайэв ԓўӈәтман ус пӑ тӑм Турәм урәӈән верты верәт пеԓа пирыса»; ");
INSERT INTO kca_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Туп атәм вермаԓ сӑхат ўйәм ŏхԓаԓән, мўв хӑрән ԓутса, пӑ хун оԓӈат ŏхән рӑкәнмаԓән, ԓўв пўтайәԓ пелки похәс, пӑ сӑмԓаԓ-мŏхәԓԓаԓ ким ӑркәпсәт. ");
INSERT INTO kca_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Щиӈәԋща щи вер Иерусалим хŏйатәтән хŏԓ уйәтты питса, щишән щи мўв ԓыв йасӈеԓән Акелдама нэма пŏтсэԓ, щит «ўр мӑнәм мўв». ");
INSERT INTO kca_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Псалмәт нэпекән хӑшман уԓԓа: 'Ԓўв хотәԓ таԓ ат уԓ, пӑ нэмәԓты уԓты ŏт щита ӑт ат питәԓ'; пӑ: 'Ԓўв тӑйәм верәԓ па хŏйатән ат ўԓа'. ");
INSERT INTO kca_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Щишән мўӈев щи хŏйатәт эԓты ит пирыты мосәԓ, хŏй мўӈ пиԓэвән иса йӑӈхәс, хун Иисус Турәм Куща мўӈ кўтэвән ус, ");
INSERT INTO kca_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Иоанн йиӈка ԓŏӈәԓтыты вер уш эԓты пӑ щи хӑтәԓ унты, хун Ԓўв мўӈ эԓтэв нŏх ўса. Ԓўв и щиты Иисус нŏх ԓыԓәӈԓәм вер хŏща мўӈ пиԓэвән ватты ŏта ат ус». ");
INSERT INTO kca_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Пӑ кӑт хŏйат аԉса: Варсавайа айәԓты Иосиф, Иуста нэмтәм ŏт, пӑ Матфий; ");
INSERT INTO kca_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Щӑԓта пойәкщәсәт пӑ йастәсәт: «Нӑӈ, Турәм Куща, кашәӈ хŏйат сӑм уйәтԓән, тӑм кӑтӈән эԓты итәԓ, Нӑӈ пирыйәм ŏтэн, аԉи, ");
INSERT INTO kca_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","тӑм Турәм урәӈән верты верәт пӑ апостола уԓты щир вана ўты кеша, хŏԓща Иуда пўӈԓа мӑнәс, ԓўв тӑхайәԓа мӑнтаԓ урәӈән». ");
INSERT INTO kca_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Щӑԓта ԓын эԓтан пос вŏщкәсәт, пӑ Матфия пос питәс, пӑ ԓўв ихŏщйаӈ апостоләт пеԓа ԓўӈәтты питса. ");
INSERT INTO kca_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ветйаӈ хӑтԓәп хӑтәԓ питмаԓән ԓыв хŏԓыйэ и нŏмәсән йӑха усәт. ");
INSERT INTO kca_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Щӑԓта шӑмкапан турәм эԓты сый тыйәс, ищи мӑтты такан пŏԓты вот иты, пӑ хот, хŏта ԓыв усәт, лӑп ўса. ");
INSERT INTO kca_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Пӑ ԓыв хŏщайэԓ лакки ортәсты тўт ԋаԓмәт хŏрпи ŏтәт этсәт, пӑ ԓыв нўмпиԓаԓа ԓӑтәԓ щирән итән, итән вŏԓыԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Пӑ хŏԓыйэ Йэмәӈ Ԓыԓән тэкәтсайәт, щӑԓта па йасӈәтән пŏтәртты питсәт, хŏты Ԓыԓ ԓывиԓаԓа пŏтәртты щир мӑс. ");
INSERT INTO kca_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Иерусалимән пӑ иудейәт усәт, Турма эвәԓты хŏйатәт, ар сыр мир кўт эԓты турәм иԓпийән уԓты ŏтәт. ");
INSERT INTO kca_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Хун щи сый тыйәс, мир ӑктәщәс пӑ нŏмәсԓаԓ ԓыԓԓәсәт, кашәӈ хŏйат ԓывиԓаԓ хуԓәс, хŏты щитәт ԓыв ўӈәԓ пўншәм йасәӈԓаԓән пŏтәртсәт, щишән. ");
INSERT INTO kca_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","«Пӑ хŏԓыйэ ӑԓ пакнысысәт, ԓыв кўтэԓән пŏтәртман: 'Тӑм пŏтәртты ŏтәт мўй ӑнта хŏԓ Галилея мŏхет?' ");
INSERT INTO kca_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Мўй щирән мўӈ, кашәӈ хŏйат ԓўв ўӈәԓ пўншәм йасӈәԓ, хуԓԓув. ");
INSERT INTO kca_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Парфия пӑ Мидия хŏйатәт, пӑ Элам хŏйатәт, Месопотамияйән, Иудеяйән пӑ Каппадокияйән, Понтән пӑ Асияйән уԓты хŏйатәт, ");
INSERT INTO kca_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Фригияйән пӑ Памфилияйән, Египетән пӑ Киринея пўӈәԓән ŏԓты Ливия мўв йирәтән уԓты хŏйатәт, пӑ Рим эԓты йŏхтәм ŏтәт, иудейәт пӑ прозелитәт, ");
INSERT INTO kca_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Крит пӑ Аравия хŏйатәт, ԓывиԓаԓ мўӈ йасәӈԓувән Турәм вŏԓаӈ верәт эԓты пŏтәрттэԓ хуԓԓув»? ");
INSERT INTO kca_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Пӑ хŏԓ ӑԓ пакнысысәт пӑ, ощатыман, кўтԓаԓән иԋщәссәт: «А мўй щит»? ");
INSERT INTO kca_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Тухԓәт пӑ, ԋӑха ԋӑхман, пŏтәрсәт: «Ԓыв эпԓәӈ ўна йищсәт». ");
INSERT INTO kca_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Петра пӑ, ихŏщйаӈәԓ пиԓән ԓойман, сыйәӈ тўрән ԓывиԓаԓа йастәс: «Иудей йох, пӑ хŏԓ Иерусалимән уԓты ŏтәт! Тӑм вер нын ат уйәтԓәԓән, пӑ ма йасәӈԓама хуԓәнтаты: ");
INSERT INTO kca_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ԓыв ӑнта кўтщәмәт, хŏты нын нумәсԓәты, ин хӑтәԓ хуԓмет щос ӑт уԓ; ");
INSERT INTO kca_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","туп тӑми Турәм айкеԓ туты хŏйатән, Иоиԉән, йастәм айкеԓ: ");
INSERT INTO kca_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Пӑ йухәт хӑтԓәтән питәԓ, Турәм пŏтәртәԓ, Ма Ԓыԓэм эԓты хŏԓ хŏйатәта шошәмԓәм, щӑԓта нын пŏхԓән нын эвиԓән Турәм айкеԓ туты питԓәт; пӑ нын энәмты йохԓән вантәпса ватты питԓәт, пӑ нын ун икиԓән уԓмәт ватты питԓәт. ");
INSERT INTO kca_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Щӑԓта Мӑнэма рупитты йохԓама, пӑ Мӑнэма рупитты нэԓама щи хӑтԓәтән Ма Ԓыԓэм эԓты шошәмԓәм, пӑ Турәм айкеԓ туты питԓәт. ");
INSERT INTO kca_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Щӑԓта вантыԓԓаӈәԓ верәт нумән турәм хӑрийән пӑ йэмәӈ посәт иԓән мўвән, ўр пӑ тўт пӑ пусәӈ пŏлыйәпса этәԓтәԓәм. ");
INSERT INTO kca_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Най пӑтлама йиԓ, пӑ тыԓәщ ўр иты йиԓ, йэԓпи хун Турәм Куща вŏԓаӈ пӑ вŏрԓәты хӑтәԓ йŏхәтәԓ. ");
INSERT INTO kca_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Щӑԓта питәԓ: кашәӈ хŏй Турәм Куща нэм вохԓәԓԓы, нŏх пайәтԓа'. ");
INSERT INTO kca_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Израиль йох! Тӑм йасӈәт хуԓәнтаԓән: Иисус, Назарет вош хŏйат, Турәм эԓты нынана йурәӈ пӑ вантыԓԓаӈәԓ верәт пӑ йэмәӈ посәт сӑхат ватәԓтәм Ху, щитәт Турәм Ԓўв мŏхтэԓ нын кўтәнән верәс, хŏты нын щи уйәтԓәԓән, ");
INSERT INTO kca_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Тӑми, Турәм нŏмәс пӑ йэԓпи вантәм вер хўват мийәм Ŏт, нын ўсԓән пӑ, Турма ӑт эвәԓты хŏйатәт йошән картԓўкән пернайа сэкман, веԓсәԓән; ");
INSERT INTO kca_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Туп Турәм , сŏрәм мухләт лакки мӑшман, Ԓўвеԓ нŏх ԓыԓӈатсәԓы, сŏрәм Ԓўвеԓ иԓ катәԓты ӑт верәтсәԓы, щишән. ");
INSERT INTO kca_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Давид Ԓўв эԓтэԓ пŏтәртәԓ: 'Ма Турәм Куща ма йэԓпемән иса ватсәм, Ԓўв ма эԓтэм йӑм пеләк сӑхат уԓ, ма ӑт ат нŏмәнԓысәм. ");
INSERT INTO kca_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Щит эԓты ма сӑмем амтәс пӑ ԋаԓмем кашәӈа йис; хŏԓна пӑ эԓ ԋŏхем, щи пеԓа нŏмәс пŏнман, уԓты питәԓ: ");
INSERT INTO kca_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Нӑӈ ма ԓыԓэм хӑԓайәт кўтән ӑт хӑйԓэн пӑ Нӑӈ йэмәӈ ŏтэна шимты вер шийаԓәты ӑт мӑԓэн. ");
INSERT INTO kca_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Нӑӈ мӑнэм уԓәпса йуш аԉсән, ма сӑмем амәтэн тэкәнәԓ, хун Нӑӈ веншен шийаԓәԓәм'. ");
INSERT INTO kca_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Хӑнам йох! Нынана Давид опращев эԓты тŏрԓы йастәты эсәԓты ат питԓа, ԓўв пӑрәс пӑ иԓ ԓэщатса, пӑ ԓўв ԓэԓтŏтәԓ мўӈ хŏщайэв тӑм хӑтәԓ унты уԓ. ");
INSERT INTO kca_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Турәм айкеԓ туты хŏйата уԓмаԓән пӑ уйәтман, Турәм так йасәӈ мийман, ԓўвеԓа йастәс, ԓўв ўрәԓ-ԓантәԓ эԓты Христос хŏйата тыйәԓтԓәԓы пӑ ԓўв хон омәсты тӑхайәԓа опсәԓтԓәԓы, ");
INSERT INTO kca_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ԓўв Христос нŏх ԓыԓәӈԓәты вер эԓты йэԓпи йастәс, мўй Ԓўв ԓыԓәԓ хӑԓайәт кўтән ӑт хӑйԓа, пӑ Ԓўв мотавтәԓ шимты щир ӑт ватәԓ. ");
INSERT INTO kca_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Турәм Тӑм Иисус нŏх ԓыԓӈатсәԓы, щит хŏща мўӈ хŏԓ вантәм хŏйатәта усув. ");
INSERT INTO kca_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Щиӈәԋща, Ԓўв, Турәм йурәӈ йошән турма нŏх пайәтман уса пӑ Ащеԓ эԓты аԉәм Йэмәӈ Ԓыԓ вана ўйман, щит шошемәс, мўй нын ин ватԓәты пӑ хуԓԓәты. ");
INSERT INTO kca_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Давид опԉа нŏх ӑт мӑнәс; туп ԓўв пŏтәртәԓ: \"Турәм Куща ма Турәм Кущайэма йастәс: Ма йӑм пелкема опса, ");
INSERT INTO kca_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","щи унты, хун Нӑӈ кўрнатэна нӑӈен нўрмәԓтты ŏтԓан иԓ ӑт пŏнԓәԓам\". ");
INSERT INTO kca_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Щишән Израиль хот тэԓ такан ат уйәтԓәԓы, Тӑм Иисус, Хŏй нын пернайа сэксәԓән, Турәм Ԓўвеԓ Турәм Кущайа пӑ Христоса пŏтсәԓы!» ");
INSERT INTO kca_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Щит хўԓмеԓ кемән, ԓыв сӑмԓаԓән ԋŏхԓәсәт пӑ Петрайа пӑ па апостоләта йастәсәт: «Хӑнам йох, мўй мўӈева верты»? ");
INSERT INTO kca_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Петра пӑ ԓывиԓаԓа йастәс: «Кӑрэкԓән эԓты шӑнша керԓаты, пӑ нын эԓтан кашәӈ ŏт Иисус Христос нэм хўватән йиӈка ат ԓŏӈәԓтыса кӑрэкәт йŏрэмәты урәӈән; пӑ Йэмәӈ Ԓыԓ мойԓәпсайа ўйаԓән. ");
INSERT INTO kca_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Аԉәм вер нын йўканәна пӑ нын ԋаврэмԓән пӑ хŏԓ йэԓта мŏхет урәӈән уԓ, хŏй Турәм Кущайән мўӈ Турмевән вохԓа». ");
INSERT INTO kca_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Пӑ ар па хŏрпи йасӈәтән ԓўв пŏтәртәс пӑ пойкәс, йастәман: «Тӑм атәм хŏйат рут эԓты хŏԓт пайтәсаты». ");
INSERT INTO kca_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Щиӈәԋща, ԓўв йасӈәԓ вана ўйәм ŏтәт йиӈка ԓŏӈәԓтысайәт, пӑ щи хӑтәԓ эвәԓты хŏйатәт хŏща хуԓәм щŏрәс кем хŏйата арамәс. ");
INSERT INTO kca_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Щӑԓта ԓыв ван кўтԓы апостоләт утәԓтәты вер хŏща хуԓәтман, ԋаԋ морәтман, пŏтремәман пӑ пойәкщәман йӑха уԓԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Кашәӈ сӑмән пӑԉщәм ус; щӑԓта ар вантыԓԓаӈәԓ верәт пӑ йэмәӈ посәт Иерусалимән апостоләт мŏхты тыйсәт. ");
INSERT INTO kca_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Хŏԓ пӑ эвәԓты мŏхет йӑха усәт пӑ мўй иса и сура тӑйсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Пӑ хотԓаԓ пӑ тащԓаԓ–вещԓаԓ тыныԓԓаԓ, пӑ хŏйатәта хŏԓ ортԓыԓԓаԓ, ватман, хŏйа мўй арат мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Щӑԓта кашәӈ хӑтәԓ, и нŏмәсән уԓман, Турәм Хотән уԓԓысәт пӑ, хотәтән ԋаԋ морәтман, амтәтԓыман пӑ вещкат сӑмән уԓман, ԓэсәт, ");
INSERT INTO kca_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Турәм ишәкман пӑ мирән сӑмәӈа тӑйман. Турәм Куща пӑ кашәӈ хӑтәԓ нŏх пайтәм мŏхет эвәԓты хŏйатәт хŏща йŏхтәптысԓы. ");
INSERT INTO kca_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Петра пӑ Иоанн Турәм Хота йӑрәтйаӈмет пойәкщәты щосән йӑха шушсәӈән. ");
INSERT INTO kca_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Сэма питәм тэԓән уԓты нохты хŏйат ӑԓ аԓтԓыса пӑ кашәӈ хӑтәԓ Турәм Хот, Хŏрамәӈа айәԓтты, ов ԉэпа опсыԓыса. Турәм Хота ԓŏӈты хŏйатәт эԓты меԓащ вохты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ԓўв, Петра пӑ Иоанн Турәм Хот ов йэԓпийән кащаԓәмаԓ кемән, ԓын эԓтайән меԓащ вохәс. ");
INSERT INTO kca_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Петра Иоанн пиԓән, ԓўв пеԓайәԓ тŏрԓы ватман, йастәс: «Мин пеԓайэмән ӑӈкәрма». ");
INSERT INTO kca_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Щӑԓта ԓўв ԓын пеԓайән хŏрат ӑӈкәрмәс, ԓын эԓтайән мŏԓты йоша пайәтты нумәсәс. ");
INSERT INTO kca_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Туп Петра йастәс: «Щел ŏх пӑ сорԋи ма ӑт тӑйԓәм; мўй тӑйԓәм, щит нӑӈен мӑԓәм: Назарет эԓты уԓты Иисус Христос нэм хўватән ԓойа пӑ шушиԓыйа». ");
INSERT INTO kca_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Щӑԓта, ԓўвеԓ йӑм пеләк йошәԓ эԓты катәԓман, нŏх ԓощәԓтәсԓы; пӑ ищи мŏхты ԓўв кўр пушәхԓаԓ пӑ шаншŏхԓаԓ такамәсәт, ");
INSERT INTO kca_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Пӑ, нŏх ԓойәпман, ԓойәс пӑ шушиԓыты питәс, пӑ ԓын пиԓанән Турәм Хота ԓŏӈәс, шушиԓыман пӑ наврәтԓыман пӑ Турәм ишәкман. ");
INSERT INTO kca_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Щӑԓта аратәԓ мир ԓўвеԓ шушиԓыман пӑ Турәм ишәкман ватсәԓы; ");
INSERT INTO kca_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Пӑ ԓўвеԓ уйәтсэԓ, тӑм щит ус, хŏй Турәм Хот Хŏрамәӈ ов ԉэпән меԓащ вохты урәӈән опсәс; щӑԓта ԓўв тўмтака йўвмаԓ пӑтыйән, хŏйатәт шек пӑԓтәмәсәт пӑ пакнысысәт. ");
INSERT INTO kca_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Пӑ тўмтака йўвәм нохәм ху Петра пӑ Иоанн эԓты пўӈԓа ӑт мӑныԓыйәԓ, щишән мир хŏԓ, шек пакәнман, ԓын хŏщайән Соломон хот йата хухәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Петра щит шийаԓәмаԓ кемән мир пеԓа йастәс: «Израиль йох! Мўй тӑми эԓты пакәнԓәты, мўй мўӈ пеԓайэв ватԓәты, ищи мӑтты ки мин йурԓәмәнән мўй пӑ йӑмԓәмәнән щиты версэмән, ԓўв шушиԓыйәԓ? ");
INSERT INTO kca_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Авраам пӑ Исаак пӑ Иаков Турәм, мўӈ ащиԓув Турәм, Ԓўв Иисус Пŏхәԓ вŏԓаӈ щирәԓ этәԓтәсԓы, Хŏй нын веԓты мӑсԓән пӑ Хŏй эԓты, Пилат хуԓәтман, пўӈԓа ўратсәты, хун щитэн Ԓўвеԓ хŏԓт эсәԓты ўтщисԓы. ");
INSERT INTO kca_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Туп нын Йэмәӈ пӑ Вещкат Ŏт эԓты пўӈԓа ўратсәты пӑ хŏйат веԓты хорахщи нынана хŏԓт эсәԓты ўратсәты, ");
INSERT INTO kca_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Уԓәпса Куща пӑ веԓсәԓән. Тӑми, Турәмән пӑрмаԓ эԓты нŏх ԓыԓӈатса, мўй хŏща мўӈ вантәм ŏтәта уԓԓув. ");
INSERT INTO kca_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Пӑ Иисус нэм хўватән эвәԓты урәӈән, Ԓўв нэмәԓән тӑмен такапса, хŏй пеԓа нын ватԓәты пӑ ԓўвеԓ уйәтԓәԓән. Пӑ Иисус эԓты уԓты эвәԓты щир, хŏԓ нын ватман, тўмтака йиты вер верәс. ");
INSERT INTO kca_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Пӑ хŏты, ма уйәтԓэм, хӑнам йохәт, нын пӑ куща йохԓән иты, ӑт уйәтман, тӑм версәԓән; ");
INSERT INTO kca_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Турәм пӑ хŏты Ԓўв хŏԓыйэ Турәм айкеԓ туты хŏйатԓаԓ уӈәԓән Христос шукащты вер йастәс, щиты пӑ щи версәԓы. ");
INSERT INTO kca_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Щиӈәԋща, кӑрэкԓән эԓты шӑнша керԓаты пӑ Турәм пеԓа ӑӈкәрматы, нын кӑрэкԓән нŏх ат ушисайәт, ");
INSERT INTO kca_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","йӑԓпиԓәты пŏрайәт Турәм Куща эԓты ат йŏхәтԓәт, пӑ нынана йўкантәм Иисус Христос Ԓўв ат китәԓ. ");
INSERT INTO kca_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Туп Иисуса опәԉән хӑщты мосәԓ, щи пŏра унты хун Турәм иса хŏԓ йӑԓпитԓәԓы, щи пŏра эԓты Турәм хŏԓ Ԓўв йэмәӈ Турәм айкеԓ туты хŏйатԓаԓ уӈәԓән хўвән йастыԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Моисей ащиԓува ӑт йастыԓыйәс: 'Нын хӑнам йохԓән кўт эԓты Турәм Куща нын Турмән, ма итэма, Турәм айкеԓ туты хŏйат нŏх этәԓтәԓ; Ԓўвеԓа мўй хŏща иса хуԓәнтаты, мўй Ԓўв нынана пŏтәртты питәԓ; ");
INSERT INTO kca_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Щӑԓта кашәӈ ŏт, хŏй Турәм айкеԓ туты хŏйата ӑт хуԓтмәԓ, щит мир кўт эԓты пӑратԓа'. ");
INSERT INTO kca_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Щит эԓты пӑ хŏԓ Турәм айкеԓ туты хŏйатәт пŏтәртысәт, Самуил эԓты ўйман пӑ щитәт, хŏй ԓўв йўпеԓән ус, ищиты тӑм хӑтԓәт аԉсәт. ");
INSERT INTO kca_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Нын – Турәм айкеԓ туты хŏйатәт пӑ йастантәм вер пŏхәт, Турәм нын ащиԓәна йастантәм вер хӑйиԓыйәс, Авраама пŏтәртман: 'Пӑ нӑӈ ԋаврэмен сӑхат мўв ԓŏватән уԓты мир йӑмән мӑԓа'. ");
INSERT INTO kca_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Турәм, Ԓўв Иисус Пŏхәԓ ԓыԓӈатмаԓ кемән, оԓӈа нын хŏщайәна Ԓўвеԓ китсәԓы, нынана йӑм мӑты урәӈән пӑ кашәӈ ŏтән нын ԉикәӈ верԓән эԓты шӑшән керәтты урәӈән». ");
INSERT INTO kca_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Хун ԓын мир пеԓа пŏтәртсәтән, Турма йир верты йох пӑ Турәм Хот шавиты куща пӑ саддукейәт ԓын хŏщайән вана йисәт, ");
INSERT INTO kca_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","щит пеԓа ԉикихурыйа уԓман, мўйа ԓын мир утәԓтәԓԓән пӑ пӑрәм эԓты Иисус иты нŏх ԓыԓәӈԓәты вер айәԓәтән; ");
INSERT INTO kca_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Щӑԓта ԓын ԋӑрэмәсайтән пӑ аԓәӈсӑхат унты касна хот шавиты йоха мӑсайӈән; йэтән ус, щишән. ");
INSERT INTO kca_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Йасәӈ хуԓәнтәм мŏхет эԓты пӑ ар пеләк эвԓәс; пӑ эвԓәм хŏйат аратәԓ вет щŏрәс кем ус. ");
INSERT INTO kca_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Кимет хӑтәԓән Иерусалимән ԓыв куща йохԓаԓ, пӑ уна уԓты икет, пӑ Закона утәԓтәты икет ӑктәщсәт, ");
INSERT INTO kca_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Пӑ Анна - Турма йир верты ŏх ики, пӑ Каиафа, пӑ Иоанн, пӑ Александр, пӑ па мŏхет ԓўв рутәԓ эԓты; ");
INSERT INTO kca_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Щӑԓта, ԓынан кўтԓәпа ԓощәԓтәман, иԋщәссэԓ: «Мўй йурән пӑ мўй нэмән нын тӑми версәтән?» ");
INSERT INTO kca_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Щиӈәԋща Петра, Йэмәӈ Ԓыԓән тэкәнман, ԓывиԓаԓа йастәс: «Мир кущайәт пӑ Израиль ун икет! ");
INSERT INTO kca_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Тӑм хӑтәԓ мин эԓтэмән кӑшаӈ хŏйат йӑма вермемән урәӈән такан иԋщәсԓаймән ки, хŏты ԓўв тўмтака верса, ");
INSERT INTO kca_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","нын хŏԓ пӑ хŏԓ Израиль мир уйтаԓән: тӑм хŏйат ин нын йэԓпанән тўмтака ԓойәԓ Назарет эԓты уԓты Иисус Христос нэм хўват, Хŏй нын пернайа сэксәԓән пӑ Хŏй пӑрәм эԓты Турәмән нŏх ԓыԓӈатса! ");
INSERT INTO kca_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ԓўв уԓ кев шуп, нынанән, кев хот омәсты хŏйатәтән, эртәм ŏт, туп щуӈ тӑйән мет мосты кева йис. Пӑ нэмәԓтты па ŏт хŏща нŏх пайтәсты щир ӑнтом; ");
INSERT INTO kca_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Турәм иԓпийән хŏйатәта мийәм па нэм ӑнтом, мўй щирән мўӈ нŏх пайтәсты верәтсув ԓуԓән». ");
INSERT INTO kca_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Петра пӑ Иоанн ӑт пӑԓты вер кащаԓәмеԓ пӑ ԓын ӑнта утәԓтыйәм пӑ аԓ хŏйата уԓты вер мŏштәмеԓ кемән, ԓыв ӑԓ щи пакнысысәт. Щи кўтән ԓын ŏша пайтыԓысайтән, ԓын Иисус пиԓән уԓԓыстән; ");
INSERT INTO kca_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Тўмтака йўвәм пӑ ԓын пиԓәнән ԓойәм хŏйат пеԓа ватман, нэмәԓты шŏппи йастәты ӑт верәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Щӑԓта, синедрион эԓты ԓывиԓаԓ ким этты партман йўпийән, ԓыв кўтэԓән нумәссәт, ");
INSERT INTO kca_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","пŏтәртман: «Мўӈев тӑм хŏйатӈән пиԓән а мўй верты? Иерусалимән уԓты хŏйатәтән хŏԓ уйәтԓа, ԓын йӑна вантыԓԓаӈәԓ вер версәӈән, пӑ мўӈ тӑми хŏԓт хуләтты ӑт верәтԓэв; ");
INSERT INTO kca_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","туп, тӑми мир ԓŏвата лакки ӑт ат ԓӑрпиԓәс, пӑԓтаптәман, ԓывиԓаԓа тӑм нэм эԓты пŏтәртты нэмәԓты хŏйата ӑт эсәԓԓэв». ");
INSERT INTO kca_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Щӑԓта, ԓынан вана вохман, ԓынана нэмәԓты щирән ӑт пŏтәртты пӑ Иисус нэм эԓты утәԓтәты такан ӑт эсәԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Туп Петра пӑ Иоанн ԓывиԓаԓа йŏхԓы йастәсӈән: «Нумәсаты, Турәм йэԓпийән мўй вещкат - Турәм эԓты нынан аршәк хуԓәтты? ");
INSERT INTO kca_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Мин, мўй ватсәмән пӑ мўй хуԓсәмән, щит эԓты мин ӑт пŏтәртты ӑт верәтԓәмән». ");
INSERT INTO kca_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ԓыв пӑ, ԓынан пӑԓтаптәман эсәԓсэԓ, ар хŏйат уԓәм пӑтыйән, ԓынан йŏвәртты щир ӑт уйәтсәт; тыйәм вер урәӈән хŏԓыйэ Турәм ишәксәт, щишән. ");
INSERT INTO kca_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Щи хŏйата ԋӑԓйаӈ мŏԓтас тӑԓ ус, хŏй хŏща щи тўмтака йиты вантыԓԓаӈәԓ вер тыйәс. ");
INSERT INTO kca_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Эсәԓман йўпийән, ԓын пиԓԓән хŏща йŏхәтсәтән пӑ пŏтәртсәԓән, мўй Турма йир верты ŏх икет пӑ уна уԓты икет ԓынана йастәсәт. ");
INSERT INTO kca_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ԓыв пӑ, хуԓәтмеԓ йўпийән, и нŏмәсән Турәм пеԓа тўрԓаԓ сыйәӈа версәԓаԓ пӑ йастәсәт: «Тӑйтаӈ Турәм! Нӑӈ турәм хӑр пӑ мўв пӑ щарәс пӑ мўй щита уԓ иса хŏԓ тыйәԓтсэн. ");
INSERT INTO kca_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Нӑӈ мўӈ Давид ащев, Нӑӈ митхуйэн, ўӈәԓән Йэмәӈ Ԓыԓэнән йастәсән: 'Мўй урәӈән па мирәт рома уԓты ӑт верәтԓәт, пӑ ԓыв таԓ нŏмәс туты ўтщиԓәт? ");
INSERT INTO kca_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Мўвәӈ хонәт нŏх эԓԓәсәт, пӑ вŏс йохәт йӑха Турәм Куща йэщаԓт пӑ Ԓўв Христосәԓ йэщаԓт ӑктәщсәт'. ");
INSERT INTO kca_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Йӑна тӑм вошән Нӑӈ Йэмәӈ Пŏхен Иисус, Нӑӈ ԋŏсытәм Ŏтэн, йэщаԓт, Ирод пӑ Понтий Пилат па мир йох пӑ Израиль йох пиԓән ӑктәщсәт, ");
INSERT INTO kca_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ԓыв щит версәт, мўй Нӑӈ йурэнән пӑ Нӑӈ партты щирэнән уԓты верәԓ ус. ");
INSERT INTO kca_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Пӑ ин, йэшәк Турәм Куща, ԓыв пӑԓтапԓаԓ пеԓа ӑӈкәрма, пӑ Нӑӈена рупитты йохԓана иса ӑт пӑԓман, Нӑӈ йасӈен пŏтәртты мийи, ");
INSERT INTO kca_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Нӑӈ йошен йэԓ ԋинши пӑ кӑшаӈ хŏйатәт тўмтака вераԓән, Нӑӈ Иисус Йэмәӈ Пŏхен нэмән йэмәӈ посәт пӑ вантыԓԓаӈәԓ верәт вера». ");
INSERT INTO kca_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Щӑԓта, ԓыв пойәкщәмеԓ йўпийән, хŏта ԓыв ӑкәтман усайәт, щи тӑхайэԓ ԋŏхԓыйәс, пӑ хŏԓыйэ Йэмәӈ Ԓыԓән тэкәтсайәт, пӑ Турәм йасәӈ хурԓы пŏтәртсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ар эвԓәм хŏйатәт хŏща пӑ и сӑм и ԓыԓ ус; пӑ нэмәԓты хŏйат тӑйәм ŏтԓаԓ эԓты ԓывиԓаԓа ӑт айәԓԓәԓаԓ, туп иса и сура тӑйты ŏтԓаԓа усәт. ");
INSERT INTO kca_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Апостоләт пӑ ун йурән Турәм Куща Иисус Христос нŏх ԓыԓәӈԓәм эԓты пŏтәртсәт; пӑ вŏԓаӈ йӑм хŏԓыйэ ԓыв пиԓԓаԓән ус. ");
INSERT INTO kca_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ԓыв кўтэԓән и нўша хŏйат ӑнтом ус; хŏԓ хŏй мўвәт мўй хотәт тӑйәс, щитԓаԓ тынымеԓ кемән, тынасәм тынԓаԓ тутԓысәт, ");
INSERT INTO kca_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","пӑ апостоләт кўр шŏма пŏныԓысәт; пӑ кашәӈ хŏйата, хŏй мўй хŏща мосты вер тӑйәԓ, мийԓыса. ");
INSERT INTO kca_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Щиты Иосий, апостоләтән Варнавайа айәԓтәм (щит: «торамтыты пŏх»), левит, рутәԓ Кипр мўв эԓты уԓ, ");
INSERT INTO kca_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","хŏй ԓўв йŏра мўв тӑйәс, щитәԓ тынымаԓ йўпийән, ŏхԓаԓ тусԓы пӑ апостоләт кўрәт шŏма пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","И ху пӑ, нэмәԓ Анания, ԓўв Сапфира имеԓ пиԓән мўвәԓ тынымаԓ йўпийән, ");
INSERT INTO kca_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","тынәԓ эԓты и шўкәԓ, ԓўв имеԓ уйәтман, хŏԓт хӑԋатсәԓы, пӑ хӑщәм шўкәԓ тусԓы пӑ апостоләт кўр шома пŏтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Туп Петра йастәс: «Анания! Мўй урәӈән нӑӈ сӑмен хиԋа ўты эсәԓсэн. Мўйа нӑӈ Йэмәӈ Ԓыԓа олмащисән пӑ мўв тынэн эԓты и шупәԓ хӑԋатсэн? ");
INSERT INTO kca_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Мўй нӑӈ тӑйсән, ӑнтом мўй нӑӈен ус, пӑ тыныйәм сӑхат мŏщатәм ŏтэн ӑнта мўй нӑӈ йурэнән ус? Мўй урәӈән тӑми нӑӈ сӑмена пŏтсэн? Нӑӈ ӑнта хŏйатәт, Турәм ԓэпәԓсән». ");
INSERT INTO kca_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Щи йасӈәт хуԓмаԓ кемән, Анания щӑх рӑкнәс; пӑ щит хуԓәнтәм ŏтәт хŏԓ ун пӑԉщәмән йŏхәтсайәт. ");
INSERT INTO kca_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Щиӈәԋща, энәмты йох ԓўвеԓ лоттәты урәӈән ԓэщатсэԓ ким этәԓтәсэԓ пӑ иԓ лоттәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Тӑм йўпийән хуԓәмԓэм щос хӑщәс, тыйәм вер эԓты нэмәԓты ӑт уйәтман, пӑ ԓўв имеԓ йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Петра пӑ ԓўвеԓ иԋщәссәԓы: «Мӑнэм йасты, тӑм арат сӑхат нын мўвән тынысԓән?» Ԓўв йастәс: «Па хŏты, тӑм арат сӑхат». ");
INSERT INTO kca_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Туп Петра ԓўвеԓа йастәс: «Мўйа нын Турәм Куща Ԓыԓ артаԓыты кашащсәтән? Тӑта щи, нӑӈ икен лоттыйәм йох ова ԓŏӈԓәт. Нӑӈ па ким туԓайән». ");
INSERT INTO kca_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ищи мŏхты ԓўв Петра кўрӈән шŏма иԓ рӑкнәс пӑ ԓыԓәԓ мӑнәс. Пӑ энәмты йох, йŏхи ԓŏӈман, ԓўвеԓ пӑрәма уйәтсэԓ пӑ, ким этәԓтәмеԓ йўпийән, ԓўв икеԓ пўӈԓа лоттәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Щиӈәԋща хŏԓ пойәкщәты мŏхет пӑ хŏԓ, хŏй тӑм хуԓәс, ун пӑԉщәмән йŏхәтсайәт. ");
INSERT INTO kca_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Апостоләт йошән мир хŏща тэԓыйэ йэмәӈ посәт пӑ вантыԓԓаӈәԓ верәт тыйәԓтысайәт; пӑ хŏԓыйэ и нŏмәсән Соломон хот йӑтән уԓԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Пўӈәԓ хŏйатәт эԓты пӑ нэмәԓты ŏт ӑт веритәԓ ԓыв хŏщайэԓ пиԓтәщты, мир пӑ ԓывиԓаԓ ишәкәԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Турәм Кущайа эвәԓты хŏйат пӑ ара па ара йиты питәс, тэԓыйэ йох пӑ нэӈәт, ");
INSERT INTO kca_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","щиты кӑшаӈ хŏйатԓаԓ вош хўлыйа ким тутԓысԓаԓ пӑ ŏԓты сŏхԓаԓа пӑ ŏԓтӑхайԓаԓа пŏныԓысԓаԓ, кўш кепа мŏхты шушты Петра исхŏрән ԓыв эԓтыԓаԓ мӑтты ŏт ат хойԓыса ԓуԓән. ");
INSERT INTO kca_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Иерусалима ищиты ванән уԓты вошәт эԓты ар хŏйат, кӑшаӈ ŏтԓаԓ пӑ кўԉ сŏх тӑйты ŏтԓаԓ тўвман, ӑктәщисәт пӑ хŏԓ щитәт тўмтака йўвәнтысәт. ");
INSERT INTO kca_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Турма йир верты ŏх ики пӑ ԓўв пиԓәԓән хŏԓ, саддукейәт пеԓа уԓты мŏхет, ԓоԓәмты нŏмәсән тэкәтсайәт, ");
INSERT INTO kca_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","щӑԓта ԓыв апостоләт ԋӑрэмәсԓаԓ, пӑ ԓывиԓаԓ вошәӈ касна хота лӑп петсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Туп Турәм Куща ангел атәԓән касна хот овәт пелки пўшсәԓы пӑ, ԓывиԓаԓ ким тўвман, йастәс: ");
INSERT INTO kca_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Мӑнаты пӑ, Турәм Хотән, мир пеԓа хŏԓ тӑм йӑԓәп уԓәпса йасӈәт пŏтәртаԓән». ");
INSERT INTO kca_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ԓыв хуԓтмәсәт пӑ аԓәӈсӑхат Турәм Хота ԓŏксәт пӑ хŏйатәт утәԓтәсәт. Щи кўтән Турма йир верты ŏх ики пӑ ԓўв пиԓәԓән уԓәм ŏтәт йŏхәтмеԓән, синедрион пӑ Израиль пŏхәт эԓты уԓты ун икет хŏԓ вохсәԓаԓ пӑ касна хота апостоләт туты хŏйат китсәт. ");
INSERT INTO kca_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Туп китыԓыйәм ŏтәт, йŏхәтмеԓән, ԓывиԓаԓ касна хотән ӑт уйәтсәԓәԓ пӑ, йŏхԓы йŏхәтмеԓән, йастәсәт, ");
INSERT INTO kca_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","пŏтәртман: «Касна хот мўӈ лӑп такан тухәрман уйәтсэв пӑ ов йэԓпийән ԓойты касна хот шавиты йохԓаԓ пиԓән; туп, пел пўшмевән, ԓыпийән нэмәԓты хŏйат ӑт уйәтсув». ");
INSERT INTO kca_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Хун тӑм йасӈәт хуԓсәт Турма йир верты ŏх ики, Турәм Хот шавиты йох куща пӑ па Турма йир верты ŏх икет, ӑԓ щи нумәссәт: «А мўй тӑм». ");
INSERT INTO kca_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","А хŏй йŏхтәс пӑ ԓывиԓаԓа йастәс: «Щита щи, нын касна хота тухрыԓыйәм йохԓән, Турәм Хотән уԓԓәт пӑ мир утәԓтәԓәт». ");
INSERT INTO kca_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Щиӈәԋща Турәм Хот шавиты йох куща ԓӑӈкәр йохԓаԓ пиԓән ԓынан ӑнта йур-вевән тусэԓ, мир эԓты пӑԓсәт, кевән ӑт ат сэксайәт, щишән. ");
INSERT INTO kca_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ԓывиԓаԓ тўвмеԓ йўпийән, синедрион хŏща ԓощәԓтәсԓаԓ; пӑ Турма йир верты ŏх ики ԓывиԓаԓ иԋщәссәԓы, пŏтәртман: ");
INSERT INTO kca_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Нынан мўӈ такан тӑм нэм эԓты утәԓтәты ӑт ат эсԓыԓысԓув? Тӑта щи, нын Иерусалим нын утәԓтәты щирԓәнән лӑп тэкәптәман пӑ Щи Хŏйат кӑԓы мўӈева нўра пŏнты ԓӑӈхаԓты». ");
INSERT INTO kca_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Петра пӑ па апостоләт йŏхԓы йастәсәт: «Хŏйатәта пŏнман, мўӈев Турма аршәк хуԓәтты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Мўӈ ащиԓув Турәм Иисус нŏх ԓыԓӈатәс, Хŏй нын, акԓа нŏх сэкман, пӑратсәԓән. ");
INSERT INTO kca_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ԓўвеԓ Турәм Ԓўв йошәԓән Кущайа пӑ Нŏх пайәтты Ŏта пŏтсәԓы Израильа кӑрэк эԓты шӑнша керԓәты щир пӑ кӑрэк йŏрэмәты щир мӑты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ԓўв хŏщайәԓ иса тӑм вантәм ŏтәт мўӈ пӑ Йэмәӈ Ԓыԓ, Хŏйтаԓ Турәм щитәта мӑс, хŏй Ԓўвеԓа хуԓәтәԓ». ");
INSERT INTO kca_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Тӑм хуԓман, ԓыв ԉик эԓты пелки тохты уратԓәт пӑ ԓывиԓаԓ пӑратты нумисысәт. ");
INSERT INTO kca_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Мӑтты Гамалиил нэмпи фарисей, Закона утәԓтәты ху, мирән хŏԓ сӑмәӈа тӑйԓа, синедрионән нŏх ԓойман, апостоләт сора кеша ким тутԓыты партсәԓы, ");
INSERT INTO kca_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ԓывиԓаԓа пӑ йастәс: «Израиль йох! Нын щирәнән тӑм хŏйатәт эԓты нумәсаты, мўй нынан ԓыв пиԓԓаԓән верты. ");
INSERT INTO kca_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Тӑм йэԓпийәншәк Февда, ԓўвеԓ ԓўв а хŏй ԓӑтәӈ хŏйата, айәԓтман, ус, пӑ ԓўв хŏщайәԓ ԋӑԓсот кем хŏйат пиԓтәщәс; туп ԓўв пӑратса, пӑ хŏԓ, хŏй ԓўвеԓ хуԓәнтәс, лакки мӑтсәт пӑ сэм ўш эԓты петсәт. ");
INSERT INTO kca_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ԓўв йўпеԓән хŏйат ԓат щирән хӑншәм пŏрайән Галилея эԓты уԓты Иуда этәс пӑ йӑм арат мир ԓўв йўпеԓа хўщәс; туп ԓўв пӑрәс, пӑ хŏԓ, хŏй ԓўвеԓ хуԓәнтәс, лакки питсәт. ");
INSERT INTO kca_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ин па, нынана пŏтәртԓәм, пўӈԓа мӑнаты тӑм хŏйатәт эԓты пӑ ԓывиԓаԓ хӑйаԓән; тӑм вер – хŏйатәт эԓты ки, ԓўв лакки шўкаԓәԓ, ");
INSERT INTO kca_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Турәм эԓты ки, нын ԓўвеԓ шўкатты ӑт верәтԓәԓән; шаващаты, нын Турәм йэщаԓт уԓты аԓт питԓәты». ");
INSERT INTO kca_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ԓыв ԓўвеԓа хуԓмәсәт; пӑ, апостоләт йŏхԓы вохмеԓ йўпийән, ԓывиԓаԓ сэкты партсәԓаԓ пӑ, Иисус нэм эԓты пŏтәртты ӑт эсәԓмеԓ йўпийән, ԓывиԓаԓ эсәԓсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ԓыв пӑ синедрион эԓты мӑтсәт, амәтман, Турәм Куща Иисус нэм урәӈән нўр туты ўша питсәт. ");
INSERT INTO kca_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Щӑԓта кашәӈ хӑтәԓ Турәм Хотән пӑ хотәтән Иисус Христос эԓты утәԓтәты пӑ Йӑм Айкеԓ туты ӑт вŏԓыԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Тӑм хӑтԓәтән, хун утәԓтыты хŏйат арамәс, грек йасәӈән пŏтәртты иудейәт йэврей йасәӈән пŏтәртты иудейәт пеԓа айәԓта ўшмащты питсәт, щи урәӈән, мўйа ԓыв шукаԓ имиԓаԓ кашәӈ хӑтәԓ ԓэтŏт орттыйән мŏхты хӑйԓайәт. ");
INSERT INTO kca_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Щиӈәԋща кӑтхŏщйаӈ апостол, хŏԓ утәԓтәты йох йӑха ӑкәтман, йастәсәт: «Мўӈева йӑм хун, Турәм йасәӈ хӑйман, пӑсанәт пеԓа нумәсты. ");
INSERT INTO kca_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Пӑ щӑԓта, хӑнам йох, нын кўтән эԓты ԓэрамтәм йӑм, Йэмәӈ Ԓыԓән пӑ ŏшән–щащән тэкнәм, ԓапәт хŏйат пирыйаты: ԓывиԓаԓ тӑм вер верты ԓощәԓтәԓув. ");
INSERT INTO kca_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Мўӈ пӑ ивевән пойәк вер пӑ йасәӈ туты вер хŏща уԓты питԓув». ");
INSERT INTO kca_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Пӑ тӑм йастәм щир хŏԓ ӑктәщәм мŏхета рӑхи ус; пӑ Стефан, эвәԓты щирән пӑ Йэмәӈ Ԓыԓән тэкнәм ху, пӑ Филипп, пӑ Прохор, пӑ Никанор, пӑ Тимон, пӑ Пармен, пӑ Антиохия вош эԓты уԓты Николай, прозелита уԓәм ху, пирысайәт; ");
INSERT INTO kca_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ԓыв апостоләт йэщаԓт ԓощәԓтәсайәт, пӑ апостоләт пойәкщәсәт пӑ ԓыв нўмпиԓаԓа йошԓаԓ катәԓсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Пӑ Турәм йасәӈ лакки ԓӑрпиԓәс, пӑ утәԓтәты хŏйатәт Иерусалимән йӑма арамәсәт; пӑ Турма йир верты икет эԓты ар пеләк ŏтәт эвәԓты вер пеԓа пайтәссәт. ");
INSERT INTO kca_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Стефан пӑ, эвәԓты верән пӑ йурән тэкәнман, вŏԓаӈ вантыԓԓаӈәԓ верәт пӑ йэмәӈ посәт мир хŏща верәс. ");
INSERT INTO kca_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Тухәԓ, щиты айәԓты Либертинәт, пӑ Киринейәт, пӑ Александрийәт иудейәт пойәкщәты хот эԓты уԓты мŏхет, пӑ тухәԓ Киликия пӑ Асия эԓты уԓты мŏхет, Стефан пиԓән ўра вортты питсәт; ");
INSERT INTO kca_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","туп ԓыв, Стефан Йэмәӈ Ԓыԓ йурән ŏшәӈа–щащәӈа пŏтәртәм щир йэщаԓт, нэмәԓты ԓощәԓтәты ӑт верәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Щиӈәԋща ԓыв тухԓәт хӑԋайән йастәты утәԓтәсԓаԓ: «Мўӈ хуԓԓысэв, хŏты ԓўв нўрмәԓтты йасӈәт Моисей эԓты пӑ Турәм эԓты йастыԓыйәс». ");
INSERT INTO kca_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Щӑԓта мир пӑ уна уԓты икет, пӑ Закона утәԓтәты икет хўщсайәт пӑ, ӑратман, ԓўвеԓ ԋӑрэмәсэԓ пӑ синедриона тусэԓ. ");
INSERT INTO kca_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Щӑԓта ԋаԓмиты хŏйатәт этәԓтәсәт, хŏйтат пŏтәртсәт: «Тӑм хŏйат нўрасты йасӈәт Турәм Хот пӑ Закон пеԓа йастәты ӑт вŏԓыйәԓ. ");
INSERT INTO kca_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Мўӈ хуԓԓысэв, хŏты ԓўв пŏтәртәс, мӑтты Назарет эԓты уԓты Иисус тӑм Турәм хот шўкатԓәԓы пӑ мўӈева Моисейән мийәм уԓәпса щирәт па щира верԓәԓы». ");
INSERT INTO kca_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Пӑ хŏԓ, синедрионән опсәм ŏтәт, ԓўв пеԓайәԓ ватман, ԓўв вешәԓ ангел веш хŏрасән ватсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Щиӈәԋща Турма йир верты ŏх ики Стефан иԋщәссәԓы: «Тӑми щиты а мўй?» ");
INSERT INTO kca_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Туп ԓўв йастәс: «Хӑнам йох пӑ ащет! Хуԓәнтыйаты. Йэмәӈ нŏви Турәм мўӈ Авраам ащев хŏща Месопотамия мўвән этәс, Харран воша касәԓмаԓ йэԓпийән, ");
INSERT INTO kca_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","пӑ ԓўвеԓа йастәс: 'Нӑӈ мўвен эԓты пӑ нӑӈ рутэн эԓты пӑ нӑӈ ащен хот эԓты эта пӑ мӑты мўв нӑӈена аԉԓәм, щи мўва мӑна'. ");
INSERT INTO kca_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Щиӈәԋща ԓўв Халдей мўв эԓты этәс пӑ Харран вошән уԓты хӑр ԓэщатәс; щиԓта пӑ, ԓўв ащеԓ пӑрмаԓ йўпийән, Турәм ԓўвеԓ тӑм мўва касԓәптәсԓы, хŏта ин нын уԓԓәты. ");
INSERT INTO kca_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Пӑ ԓўвеԓа и кўр лоп арат йўкан тӑм мўвән ӑт мӑс. Туп Турәм ԓўвеԓа пӑ ԓўв ԋавремԓаԓа тӑм мўв тӑйты урәӈән мӑты йастәсԓы, щи пŏрайән хŏԓна Авраам и ԋавремийэ ӑт тӑйәс. ");
INSERT INTO kca_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Щӑԓта Турәм ԓўвеԓ йастәс, ԓўв ԋавремԓаԓ па мўвән касԓәм хŏйатәта питԓәт пӑ па мўв хŏйатәта тынԓы-пелԓы рупата ԋўрты питԓәт, щӑԓта йэрмәԓтты уԓәпсайән ԋӑԓсот кем тӑԓ уԓты питԓәт. ");
INSERT INTO kca_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Туп Ма', - Турәм йастәс, - 'щи мир хŏща сўт верԓәм, хŏй хŏща ԓыв тынԓы-пелԓы рупата ԋўрԓәт; пӑ щи йўпийән ԓыв щиԓта этԓәт пӑ тӑм уԓты тӑхайән Мӑнэма йир туты питԓәт'. ");
INSERT INTO kca_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Пӑ Турәм Авраама эвәтты щир йастантәпса мӑс. Авраам Исаак сэма пайтәс пӑ ԋийәԓмет хӑтәԓән эвәтты верән версәԓы; Исаак Иаков сэма пайтәс, Иаков пӑ – кӑтхŏщйаӈ опращ икет. ");
INSERT INTO kca_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ун ԓӑтәӈ опращ икет, сӑмԓаԓ щариты пӑтыйән, Иосиф Египта тынысэԓ; туп Турәм ԓўв пиԓәԓән ус, ");
INSERT INTO kca_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","пӑ ԓўвеԓ иса кӑмән хŏрпи шук эԓты хŏԓт павәтсәԓы, пӑ ŏш–щащ пӑ фараон, Египет хон йӑм сӑм ԓўвеԓа мойԓәсԓы, щи хонән ԓўв Египет хŏща пӑ ԓўв хон хотәԓ хŏща иса кущайа пŏтса. ");
INSERT INTO kca_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Щӑԓта ԓэԓԓы пŏра пӑ ун шук Египет пӑ Ханаан мўвӈән ԓŏвата иса йŏхтәс, пӑ мўӈ ащиԓув ԓэтŏт ӑт уйтыԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Иаков пӑ, Египетән ԋаԋ ԓат сэм уԓты хуԓмаԓ кемән, мўӈ ащиԓув оԓәӈмет пўш щи китсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Хун кимет пўш ԓыв тŏхи йŏхәтсәт, Иосиф ԓўв йайԓаԓа аԉәсәс, пӑ Иосиф рут фараон хонән уйәтты питса. ");
INSERT INTO kca_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Щи йўпийән Иосиф ԓўв Иаков ащеԓ пӑ хŏԓ ԓўв рутԓаԓ вохты партсәԓы, ԋийәԓйаӈ пеԓа вет арат хŏйат ус. ");
INSERT INTO kca_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Иаков Египта ўншәс, пӑ щита пӑрәс пӑ мўӈ ащиԓув па; ");
INSERT INTO kca_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Пӑ Сихем воша тўвман пӑ хŏшапәӈ кев ԓыпийа пŏнман усайәт, щи тӑха Авраам щелŏхән Сихемән уԓты Еммор пŏхәт эԓты ԓутсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Щи мŏртән, хун аԉәм вер тӑԓаӈа йиты пŏра ванамәты питәс, мўй эԓты Турәм Авраама так йасәӈ мийԓыйәс, мирәԓ Египетән энмәԓтыйәс пӑ арамийәс, ");
INSERT INTO kca_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","щи унты, хун па хон питәс, хŏй Иосиф ӑт уйәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ԓўв, мўӈ рутэв йэщаԓт ŏщмарԓыман, мўӈ ащиԓув йэрмәԓтысԓы, ԓывиԓаԓа ай ԋавремԓаԓ йовәԓты партсәԓы, ԓыԓӈа ӑт ат хӑщсәт. ");
INSERT INTO kca_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Тӑм пŏрайән Моисей сэма питәс, Турәм йэԓпийән хŏрасәӈ ус. Хуԓәм тыԓәщ ԓўв ащеԓ хотән эсәмән ԓапәтман ус. ");
INSERT INTO kca_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Хун вŏщкәса, фараон эвийән ўса пӑ ԓўв хŏщайәԓ, ԓўв пŏхәԓ иты, энмәԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Пӑ Моисей аратәԓ иса Египет ŏша–щаща утәԓтәма ус, йасәӈԓаԓән пӑ верԓаԓән йўрәӈ ус. ");
INSERT INTO kca_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Хун пӑ ԓўв ԋӑԓйаӈ тӑԓа йис, ԓўв хӑнам йохԓаԓ, Израиль пŏхәт, хŏща йӑхты нŏмәсән йŏхәтса. ");
INSERT INTO kca_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Пӑ, ԓыв эԓтыԓаԓ ит, атмащ йэшаԓәты кащаԓәмаԓ кемән, эԓт питсәԓы. Пӑ кетмәм ŏт урәӈән Египет ху пӑратсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Моисей нумәсәс, ԓўв хӑнам йохԓаԓ ŏша пайәтԓәԓаԓ, ԓўв йошәԓ сӑхат ԓывиԓаԓа Турәм нŏх пайтәсты щир мӑԓ; тўп ԓыв ŏша ӑт пайәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Кимет хӑтәԓ, хун ԓыв эԓтыԓаԓ кӑтән кўтәрмәстән, ԓўв йŏхтәс пӑ ԓынан йӑм щира уԓты пеԓа хўщиԓысԓы, пŏтәртман: «Нын – хӑнам йохӈән; мўйа кўтԓәнән йэшащԓәтән?» ");
INSERT INTO kca_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Туп рутәԓ йэшаԓәты ŏт ԓўвеԓ йэԓ пŏткәсԓы, йастәман: 'Хŏйән нӑӈ мўӈ нўмпева кущайа пӑ сўт икийа пŏтсайән? ");
INSERT INTO kca_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Нӑӈ мосәӈ мӑнэм па веԓты ԓӑӈхаԓән, хŏты мŏԓхатәԓ Египет ху веԓсэн?' ");
INSERT INTO kca_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Тӑм йасӈәт эԓты Моисей хŏнтас пӑ Мадиам мўв хŏща йŏхтәм хŏйата йис, щита ԓўв эԓтэԓ кӑт пŏх сэма питәс. ");
INSERT INTO kca_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ԋӑԓйаӈ тӑԓәԓ тэкнәм йўпийән Синай кев таԓ хишәӈ мўвән тўтән ԓэты пеԓантыты варәс похәл кўтән Моисей йэщаԓт Турәм Куща ангел этәс. ");
INSERT INTO kca_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Моисей, щит шийаԓәмаԓ кемән, щи ныты ŏт эԓты пакнысыйәс; хун йӑма вантыты урәӈән, вана шушәс, ԓўв Турәм Куща тўр сый хуԓмәс: ");
INSERT INTO kca_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Ма нӑӈ ащиԓан Турәм, Авраам Турәм пӑ Исаак Турәм пӑ Иаков Турәм'. Моисей, хŏрщәм эԓты тӑрыман, йэщаԓт ватты ӑт веритәс. ");
INSERT INTO kca_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Щӑԓта Турәм Куща ԓўвеԓа йастәс: 'Нӑӈ кўрԓан эԓты ԓумтәмен хŏԓт эӈхи, щи тӑха, хŏта нӑӈ ԓойԓән - щит йэмәӈ мўв. ");
INSERT INTO kca_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ма Египетән Ма мирэм шукатты вер ватԓәм, пӑ ԓўв эӈәԓты сыйәԓ хуԓԓәм, пӑ ԓўвеԓ хŏԓт пайәтты иԓ эсԓәщсәм: Щиӈәԋща, мӑна, Ма нӑӈен Египта китԓэм'. ");
INSERT INTO kca_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Тӑм Моисей, хŏй ԓыв вана ӑт ўсэԓ, йастәман: 'Хŏйән нӑӈ мўӈ нўмпева кущайа пӑ сўт икийа пŏтсайән?' Турәм кущайа пӑ хŏԓт пайәтты ŏта китсәԓы ангеләԓ сӑхат, хŏй ԓўвеԓа пеԓантыты варәс кўтән этԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Тӑм Моисей Египет мўвән, пӑ Ўрты щарәсән, пӑ таԓ мўвән вантыԓԓаӈәԓ верәт пӑ йэмәӈ посәт ԋӑԓйаӈ тӑԓ хўват верман, ԓывиԓаԓ Египет эԓты йэԓ тусԓы. ");
INSERT INTO kca_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Тӑми щи Моисей, хŏй Израиль пŏхәта йастәс: 'Турәм айкеԓ туты хŏйат нынана Турәм Куща нын Турмән нын хӑнам йохԓән кўт эԓты ма итэмән мӑԓ; Ԓўвеԓ хуԓәнтаты'. ");
INSERT INTO kca_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Тӑми щит, хŏй таԓ мўвән ӑктәщәм Израиль мир хŏща ангел пиԓән пӑ мўӈ ащиԓув пиԓән ус, ангел Синай кев ԓоӈәԓән ԓўв пеԓайәԓ пŏтәртәс, пӑ ԓўв ԓыԓәӈ йасӈәт вана ўсԓы, мўӈева мӑты урәӈән, ");
INSERT INTO kca_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","хŏй пеԓа мўӈ ащиԓув хуԓәтты ŏтәта уԓты ӑт ԓӑӈхасәт, ԓўвеԓ пўӈԓа хирәтсэԓ пӑ ԓўв сӑмԓаԓән Египет пеԓа керԓәсәт, ");
INSERT INTO kca_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Аарона йастәман: 'Мўӈева ԓуӈхәт вера, хŏйтат мўӈ йэԓпевән ԓуԓән ат мӑтсәт ; Моисей, мўӈев Египет мўв эԓты йэԓ тувәм ŏтэв, ӑт уйәтԓэв, хŏты йис'. ");
INSERT INTO kca_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Пӑ щи хӑтԓәтән мис хŏр версәт, пӑ щи ԓуӈха йир тусәт, пӑ ԓыв йошԓаԓән верәм вер йэԓпийән каш версәт. ");
INSERT INTO kca_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Турәм пӑ шӑшән керԓәс пӑ ԓывиԓаԓ турәм хӑр пŏрмасәт пеԓа пойәкщәты хӑйсәԓы, хŏты Турәм айкеԓ туты хŏйатәт нэпекән хӑшман уԓԓа: 'Израиль хот! Нын мўй войәт пӑ йирәт ԋӑԓйаӈ тӑԓ сыс таԓ мўв хŏща Мӑнэма тутԓысты? ");
INSERT INTO kca_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Нын Молох ԓух хӑшап пӑ Ремфан нэмпи хус ԓуӈхән, нын верәм хŏрԓән, пӑтән ўсԓән, ԓывиԓаԓа пойәкщәты урәӈән: пӑ Ма нынан Вавилон эԓты йэԓшәк касԓәптәԓԓам'. ");
INSERT INTO kca_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Вантәм ŏт Йэмәӈ Хӑшап мўӈ ащиԓув хŏща таԓ мўвән ус, хŏты Пŏтәртәм Ŏт Моисейа ԓўвеԓ верты партсәԓы, щи ԓўв вантәм ŏтәԓ хŏрпийа. ");
INSERT INTO kca_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Щи Йэмәӈ Хӑшап, йоша пайәтмеԓ йўпийән, мўӈ ащиԓув, Иисус Навин ԓыв хŏщайэԓ ŏха уԓман, мирәт тӑйты мўва ԓŏӈәԓсэԓ, Турәм, ԓыв йэԓпеԓән, мўвәӈ хŏйатәт воштәсԓы. Тӑмиты Давид хӑтԓәт унты ус. ");
INSERT INTO kca_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Тӑми Турәм хŏща йӑм мŏщатәс пӑ пойәкщәс, Иаков Турма уԓты тӑха ԓэщатты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Соломон пӑ Ԓўвеԓа хот опсәс. ");
INSERT INTO kca_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Туп Нўм Ащи ӑнтом йошән опсәм хотәтән уԓ, хŏты Турәм айкеԓ туты хŏйат пŏтәртәԓ: ");
INSERT INTO kca_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","'Турәм хӑр – ма хон омәсты тӑхайэм, пӑ мўв – Ма кўр иԓпем. Мўй хŏрпи хот Мӑнэма верԓәты, Турәм Куща пŏтәртәԓ, мўй хŏрпи тӑхайән Ма щўтщәты верем уԓ? ");
INSERT INTO kca_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ӑнта мўй Ма йошем тӑм иса тыйәԓтәс?' ");
INSERT INTO kca_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Нын - ўрайәӈ ŏтәт! Ӑт эвтәм сӑмпи пӑ ӑт эвтәм пӑԓпи хŏйатәт! Нын иса Йэмәӈ Ԓыԓ йэщаԓт уԓԓәты, хŏты нын ащиԓән, щиты нын па. ");
INSERT INTO kca_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Турәм айкеԓ туты хŏйатәт эԓты нын ащиԓәнән хŏй ӑт воштәса? Ԓыв Вещкат Ŏт йŏхәтты айкеԓ йэԓпи йастәм ŏтәт веԓсәԓаԓ, Хŏй хŏща хŏйат аԉты пӑ веԓты ŏтәта ин нын верәссәты, – ");
INSERT INTO kca_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","нынана ангеләт сӑхат мийәм Закон вана ўйман йўпийән, нын ӑт шависԓын». ");
INSERT INTO kca_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Тӑм хуԓәтман, ԓыв ԉикән кавәрмәсайәт пӑ ԓўв пеԓайәԓ пекԓаԓән йухрәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Стефан пӑ, Йэмәӈ Ԓыԓән тэкәнман уԓман, турәм хӑр пеԓа ӑӈкәрмәс, Турәм хутԓәты–вŏрԓәты щир пӑ Иисус, Турәм йӑм пеләк сӑхат ԓойтаԓ шийаԓәс, ");
INSERT INTO kca_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","пӑ йастәс: «Тӑм, лоӈхемәм опәԉ пӑ Хŏйат Пŏх, Турәм йӑм пеләк сӑхат ԓойтаԓ ма ватԓәм». ");
INSERT INTO kca_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Туп ԓыв, сыйәӈ тўрән уваԓтман, пӑԓаԓ лӑп катәԓсәԓаԓ, пӑ и сӑмән ԓўв хŏщайәԓ ӑратсәт, ");
INSERT INTO kca_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","пӑ, вош ким пелка тувман, кевән ԓўвеԓ йовәԓты питсэԓ. Вантәм хŏйатәт пӑ ԓыв ԓумәтты сŏхԓаԓ Савл нэмпи, айкам ху кўрнат шŏма пŏтсәԓаԓ, ");
INSERT INTO kca_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","пӑ Стефан кевән йовәԓсэԓ, ԓўв пойәкщәс пӑ пŏтәртәс: «Турәм Куща Иисус! Ма ԓыԓэм ўйи». ");
INSERT INTO kca_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Пӑ, шашӈәԓаԓ иԓ морәтман, сыйәӈ тўрән ўваԓтәс: «Турәм Куща! Ԓывиԓаԓа тӑми кӑрека аԓ нуми». Щӑԓта, щит йастәмаԓ кемән, пӑрәс. ");
INSERT INTO kca_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Савл пӑ Стефан пӑратты вер пеԓа такан ус. Щи хӑтԓәтән Иерусалимән пойәкщәты хŏйатәт ӑктәщиты вер пеԓа вŏԓаӈ ун ԋухәтԓыты щир тыйәс; пӑ хŏԓ, апостоләт тўмпийән, Иудея пӑ Самария ԓŏвата лакки мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Стефан пӑ Турма эвәԓты хŏйатәтән иԓ лоттәса пӑ ԓўв урӈәԓән вŏԓаӈ ун хоԓԓәп хоԓԓәса. ");
INSERT INTO kca_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Савл пӑ пойәкщәты хŏйатәт йэшаԓәс, хотәта ԓŏӈтыман, йох пӑ нэӈәт ԋӑрэмәман, касна хота мийԓысԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Щи кўтән лакки мӑнәм ŏтәт йӑӈхиԓысәт пӑ Йӑм Айкеԓ тутԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Щиты, Филипп Самария мўв воша йŏхтәс пӑ Христос эԓты пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Мир и сӑмән хуԓәтсәт щит пеԓа, мўй Филипп пŏтәртәс, хуԓман пӑ ватман, мўй хŏрпи вантыԓԓаӈәԓ верәт ԓўв верәс. ");
INSERT INTO kca_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Катәԓман уԓәм ар хŏйат эԓты кўԉ сŏхәт такан щӑлыман, ким этыԓысәт, ар пеләк щащԓы питәм ŏтәт пӑ нохты хŏйатәт тўмтака йўвиԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Щӑԓта щи вошән вŏԓаӈ ун амәт ус. ");
INSERT INTO kca_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Щи вошән ий ики ус, нэмәԓән Симон, хŏй щи йэԓпийән щӑртыԓыйәс, ԓўвеԓ ԓўв ԓӑтәӈ хŏйата айәԓман, Самария мир пакнәптыйәс. ");
INSERT INTO kca_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ԓўвеԓа айэԓ-унэԓән хŏԓ хуԓәтсәт, йастәман: «Тӑм – Турәм вŏԓаӈ йур». ");
INSERT INTO kca_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ԓўвеԓа щи пӑтыйән хуԓәтсәт, ԓўв ԓывиԓаԓ щӑртԓаԓән мŏԓты хўват пакнәптысԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Туп хун Филиппа, Турәм Хон Уԓәпса пӑ Иисус Христос нэм эԓты Йӑм Айкеԓ пŏтәртты ŏта, эвәԓсәт, йох пӑ нэӈәт кашащсәт, йиӈка ат ԓŏӈәԓтысайәт. ");
INSERT INTO kca_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Симон ԓўв па эвԓәс пӑ, йиӈка ԓŏӈәԓтыйәм йўпийән, Филипп эԓты пўӈԓа ӑт мӑныԓыйәс; пӑ, ԓӑтәӈ вантыԓԓаӈәԓ йурәт пӑ йэмәӈ посәт ватман, ӑԓ пакнысыйәс. ");
INSERT INTO kca_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Иерусалимән уԓты апостоләт, Самария хŏйатәт Турәм йасәӈ вана ўйәм айкеԓ хуԓмеԓ кемән, Петра пӑ Иоанн ԓыв хощайэԓ китсәт, ");
INSERT INTO kca_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ԓын, йŏхәтман кемән, ԓыв урәӈԓаԓән пойәкщәсӈән, ԓыв Йэмәӈ Ԓыԓ ԓуԓән вана ат ўсәт. ");
INSERT INTO kca_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Йэмәӈ Ԓыԓ хŏԓна ԓыв эԓтыԓаԓ ита нэш ӑт эсԓыщийәс, туп ԓыв Турәм Куща Иисус нэм хўватән йиӈка ԓŏӈәԓтыман усайәт. ");
INSERT INTO kca_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Щишән ԓыв эԓтыԓаԓа йошԓән пŏтсәԓән, пӑ ԓыв Йэмәӈ Ԓыԓ вана ўсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Симон пӑ, Йэмәӈ Ԓыԓ апостоләт йош пŏнты сӑхат мӑты щир шийаԓәмаԓ кемән, ԓынана ŏх тус, ");
INSERT INTO kca_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","щиты пŏтәртман: «Мӑнэма па тӑм йур мийатән, щи хŏйат, хŏй эԓты ма йошԓам пŏнԓәԓам, Йэмәӈ Ԓыԓ ат ўс». ");
INSERT INTO kca_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Туп Петра ԓўвеԓа йастәс: «Нӑӈ щелŏхен нӑӈ пиԓэнән сŏрма ат йиԓ, нӑӈ Турәм мŏйԓәпса ŏх сӑхат мŏщатты нумәссән, щишән. ");
INSERT INTO kca_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Нӑӈена тӑми хŏща нэмәԓт шўк пӑ пирыйәм вер ӑнтом, нӑӈ сӑмен Турәм пеԓа ӑнта вещкат. ");
INSERT INTO kca_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Щиӈәԋща, тӑм кӑрэкен эԓты шӑнша керԓа пӑ Турма пойәкща: мосәӈ нӑӈ атәм нŏпсэн нӑӈена хŏԓт йŏрэмәԓа; ");
INSERT INTO kca_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Нӑӈен вŏщрэм сыпән тэкәнман иты пӑ ӑнта вещкат щирәтән йӑрман иты ватԓэм». ");
INSERT INTO kca_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Симон пӑ йŏхԓы йастәс: «Ма урӈема Турәм Кущайа пойәкщаты, ма, нын йастәм ŏтԓән щира, нэмәԓтыйән ӑт ат хойсайәм». ");
INSERT INTO kca_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ԓын пӑ, вантәм ŏтәта уԓман пӑ Турәм Куща йасӈа утәԓтәман, йŏхԓы, Иерусалима, мӑтсәтән пӑ ар Самария вошәтән–куртәтән Йӑм Айкеԓ эԓты пŏтәртсәтән. ");
INSERT INTO kca_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Турәм Куща ангел пӑ Филипп пеԓа йастәс: «Ԓойа пӑ мӑна хӑтәԓ кутәп пŏра шŏма, Иерусалим эԓты Газайа мӑнты таԓ йуш хŏща». ");
INSERT INTO kca_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ԓўв ԓойәс пӑ мӑнәс. Щӑԓта ин, Ефиоп мўвәӈ евнух ики, Ефиопия нэ хон Кандакия куща, ԓўв сорԋиԓаԓ шавиты куща ху, Иерусалима пойәкщәты урәӈән йŏхтыԓыйәс, ");
INSERT INTO kca_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","йŏхԓы мӑнмаԓән пӑ, ԓўв ухԓәԓән омәсман, Турәм айкеԓ туты хŏйат Исаия хӑншәм нэпек ԓўӈтәс. ");
INSERT INTO kca_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ԓыԓ Филиппа йастәс: «Тӑм ухәԓ ԉэпа вана мӑна пӑ ԓўв пўӈԓәԓән шуша». ");
INSERT INTO kca_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Филипп вана йŏхтәс пӑ, тўмеԓ Турәм айкеԓ туты хŏйат Исаия хӑншәм нэпек ԓўӈәтмаԓ, хуԓмаԓ кемән, йастәс: «Нӑӈ мўй уйәтԓэн, мўй ԓўӈәтԓән?» ");
INSERT INTO kca_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ԓўв йастәс: «Мўй щирән уйәтԓэм, мӑтты ŏтән ӑт аԉԓайәм ки?» Пӑ Филипп нŏх хухты пӑ ԓўв пўӈԓәԓа омәсты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Хӑншәм Ŏт хŏща ԓўӈтәм тӑхайәԓ щит ус: «Ош иты Ԓўв хŏртыйа тўвман ус, пӑ, ош пŏшәх иты ԓўвеԓ ԓŏртты ŏтәԓ йэԓпийән тўр сыйԓы уԓ, щиты щи Ԓўв ўӈԓәԓ пелки ӑт пўшԓәԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ԓўв иԓ ԋэрәм щирән Ԓўв сўтәԓ йэтшәс. Туп Ԓўв рутәԓ хŏйән эԓпа аԉԓа? Ԓўв уԓәпсайәԓ мўв эԓты нŏх лакәптәԓа». ");
INSERT INTO kca_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Евнух пӑ Филипп пеԓа йастәс: «Нӑӈ щи ԓŏват йӑм вера, йаста: хŏй эԓты Турәм айкеԓ туты хŏйат тӑми пŏтәртәԓ? Ԓўв эԓтэԓ мўй пӑ па хŏйат эԓты?» ");
INSERT INTO kca_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Филипп ўӈԓәԓ пел пўшсәԓы пӑ, тӑм Хӑншәм Ŏт эԓты ўйман, ԓўвеԓа Иисус эԓты Йӑм Айкеԓ тус. ");
INSERT INTO kca_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Щи кўтән, йэԓԓы мӑнтан эԓты, ԓын йик ԉэпа йŏхәтсәтән; пӑ евнух ики йастәс: «Тӑта щи йик; мӑнэма нӑӈ эԓтэн йиӈка ԓŏӈәԓтыты мўй тŏрас верәԓ?» ");
INSERT INTO kca_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Филипп пӑ ԓўвеԓа йастәс: «Сӑмен ԓоватән эвәԓԓән ки, рӑхәԓ». Ԓўв йŏхԓы йастәс: «Эвәԓԓәм, Иисус Христос – щит Турәм Пŏх». ");
INSERT INTO kca_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Щӑԓта ухәԓ иԓ вŏԓыты партсәԓы, пӑ , Филипп пӑ евнух ики кинәӈтак йиӈка ŏхәԓсәтән; пӑ ԓўвеԓ йиӈка ԓŏӈәԓтысԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Хун пӑ ԓын йик эԓты ким этсәтән, Йэмәӈ Ԓыԓ евнух ики эԓты эсԓәщәс, Филипп пӑ Турәм Куща ангелән аԓэмәса, пӑ евнух ики ԓўвеԓ ўш ӑт ватсәԓы, пӑ, амәтман, йушәԓ йэԓԓы мӑтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Филипп пӑ Азотән ԉикмантәс пӑ, мŏхты шушман, вошәтән иса Йӑм Айкеԓ эԓты пŏтәртәс, Кесарияйа йŏхәтмаԓ унты. ");
INSERT INTO kca_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Савл пӑ, Турәм Куща утәԓтәты хŏйатәт пеԓа ԉикән кавәрман пӑ веԓтатты номәсән тэкәнман, Турма йир верты ŏх ху хŏща йŏхтәс ");
INSERT INTO kca_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","пӑ ԓўв эԓтэԓ айкеԓ нэпек Дамаск вош иудейәт пойәкщәты хотәт урәӈән вохәс. Ԓўв хŏй, тӑм утәԓтәты вер йўпи туты хŏйат, уйәтәԓ, йохәт мўй пӑ нэӈәт мŏщатты пӑ Иерусалима йŏхтәптәты ат верәтсәԓԓы. ");
INSERT INTO kca_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Хун йушән ԓўв Дамаск воша ванамәты питмаԓән, шӑмкапан турәм хӑр эԓты ԓўв нŏвийән похәтса. ");
INSERT INTO kca_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ԓўв мўва иԓ рӑкнәс пӑ тўр сый хуԓтмәс, ԓўв пеԓайәԓ пŏтәртты сый: «Савл, Савл! Мўйа Мӑнэм ԋухәԓԓэн?» ");
INSERT INTO kca_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ԓўв йастәс: «Хŏй Нӑӈ, Турәм Куща?» Турәм Куща пӑ йастәс: «Ма Иисус, Хŏйтэн нӑӈ ԋухәԓԓән. Нӑӈен карты йущәӈ йўх йэщаԓт мӑнты ԓавәрт». ");
INSERT INTO kca_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ԓўв, тӑрыман пӑ пӑԉщәмән иԉапман, йастәс: «Турәм Куща! Мўй верты мӑнэм партԓэн?» Щӑԓта Турәм Куща ԓўвеԓа йастәс: «Нŏх ԓойа пӑ воша мӑна; пӑ нӑӈена йастәԓа, мўй нӑӈен верты мосәԓ». ");
INSERT INTO kca_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ԓўв пиԓәԓән шушәм хŏйатәт пӑ сӑм мӑнман ԓойсәт, тўр сый хуԓман, пӑ нэмәԓты хŏйат ӑт шийаԓәман. ");
INSERT INTO kca_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Савл мўв эԓты нŏх ԓойәс пӑ пелки сэмән ԓўвеԓа нэмәԓты ӑт ныса. Щӑԓта йош пелкәԓ эԓты катәԓман туты питса, пӑ Дамаск воша йŏхтәптәса. ");
INSERT INTO kca_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Щӑԓта хуԓәм хӑтәԓ ԓўвеԓа нэмәԓт ӑт ныса, пӑ ӑт ԓэс, пӑ ӑт йиԋщәс. ");
INSERT INTO kca_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Дамаскән и утәԓтәты хŏйат ус, нэмәԓән Анания; пӑ Анания вантәм верәԓ хŏща Турәм Куща ԓўвеԓа йастәс: «Анания!» Ԓўв йастәс: «Тӑм Ма, Турәм Куща». ");
INSERT INTO kca_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Турәм Куща пӑ ԓўвеԓа йастәс: «Ԓойа пӑ, щиты айәԓтты Тўӈ вош хўлыйа, мӑна, пӑ Иуда хот хŏща Тарс вошәӈ ху иԋщәсы, нэмәԓән Савл; ԓўв ин пойәкщәԓ. ");
INSERT INTO kca_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Пӑ вантәм верәԓ хŏща Анания нэмпи ху вантәс, ԓўв хŏйщайәԓ йŏхәтәԓ пӑ ԓўв эԓтэԓ йошәԓ пŏнԓәԓы, ԓўв сэмәӈа ат йис». ");
INSERT INTO kca_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Анания йŏхԓы йастәс: «Турәм Куща! Ма ар хŏйат эԓты тӑм хŏйат эԓты хуԓԓысэм, мўй арат атәм ԓўв Нӑӈ хŏйатԓана Иерусалимән верәс; ");
INSERT INTO kca_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Тӑта па Турма йир верты ŏх икет эԓты хŏԓ, Нӑӈ нэмен вохты хŏйатәт йӑрты, йур тайәԓ». ");
INSERT INTO kca_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Туп Турәм Куща ԓўвеԓа йастәс: «Мӑна, ԓўв Ма пирыйәм пўтэм, Ма нэмем мир пӑ хонәт пӑ Израиль пŏхәт йэщаԓт такан йастәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Пӑ Ма ԓўвеԓа этәԓтәԓэм, мўй арат Ма нэмем урәӈән ԓўвеԓа шукащты мосәԓ». ");
INSERT INTO kca_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Анания мӑнәс пӑ хота ԓŏӈәс, йошӈиԓаԓ ԓўв эԓтэԓ пŏнман, йастәс: «Савл хӑнам ху! Йушән, хŏԓща нӑӈ шушсән, нӑӈ хŏщайэн этԓыйәм Турәм Куща Иисус, мӑнэм китсәԓы, нӑӈ сэмәӈа ат йисән пӑ Йэмәӈ Ԓыԓән ат тэкәтсайән». ");
INSERT INTO kca_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Пӑ щи пўԉаӈ сэмӈиԓаԓ эԓты ищи мӑтты сом хŏԓт рӑкнәс, пӑ ԓўв шамкапан сэмәӈа йис; нŏх ԓойәс пӑ йиӈка ԓоӈәԓтыса, ");
INSERT INTO kca_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","щӑԓта, ԓэтŏт ԓэвмаԓ йўпийән, такамәс. Пӑ Савл кӑмәтса хӑтәԓ утәԓтәты йох пиԓән Дамаскән ус. ");
INSERT INTO kca_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Пӑ щи пўԉаӈ иудейәт пойәкщәты хотәтән Иисус эԓты айкеԓ туты питәс, «Ԓўв – Турәм Пŏх». ");
INSERT INTO kca_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Щӑԓта хŏԓ хуԓәнтәм хŏйатәт аԓ пакнысысәт пӑ пŏтәртсәт: «Тӑм ӑнта мўй щит, хŏй Иерусалимән тӑм нэм вохты ŏтәт воштыԓыйәс? Йӑна щи пӑ щи урәӈән ты йŏхтәс, ԓывиԓаԓ мŏщатты пӑ Турма йир верты ŏх икет хŏща туты». ");
INSERT INTO kca_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Савл пӑ щи киԋща па такамтыйәс пӑ Дамаскән уԓты иудей йох ԓыԓԓәты унты йŏхтәптәсԓы, такан аԉман, Тӑми – Христос. ");
INSERT INTO kca_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Хун пӑ йӑм арат хӑтәԓ хӑщәм йўпийән, иудей йох ԓўвеԓ пӑратты нŏмәс версәт. ");
INSERT INTO kca_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Туп Савл ԓыв тӑм нŏпсэԓ мŏштәсԓы. Ԓыв пӑ атаӈ хӑтәԓ вош пушас ов хŏща ԓавԓәссәт, ԓўвеԓ веԓты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Утәԓтыты йох пӑ атәԓән, ԓўвеԓ ўсэԓ пӑ вош кертәм пӑԓ пушас эԓты кураԋэк ԓыпийән иԓ эсәԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Савл Иерусалима йŏхтәс пӑ утәԓтыты хŏйатәт хŏща ԓŏӈты ўратәс; туп хŏԓ ԓўв эԓтайәԓ пӑԓсәт, ԓўв утәԓтыты хŏйата уԓтыйа, ӑт эвәԓԓа. ");
INSERT INTO kca_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Варнава пӑ ԓўвеԓ ўсԓы пӑ апостоләт хŏща тусԓы пӑ ԓывиԓаԓа пŏтәртсәԓы, хŏты йуш хŏща ԓўв Турәм Куща ватсәԓы, пӑ мўй ԓўвеԓа Турәм Куща пŏтәртәс, пӑ хŏты ԓўв Дамаскән, ӑт пӑԓман, Иисус нэм урәӈән айкеԓ тус. ");
INSERT INTO kca_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Щӑԓта ԓўв ԓыв пиԓԓаԓән ус, лыпаща Иерусалим ԓŏватән йӑӈхиԓыйәс пӑ Турәм Куща Иисус нэм урәӈән ӑт пӑԓман айкеԓ тус. ");
INSERT INTO kca_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ищиты грек йаcәӈән пŏтәрты иудейәт пиԓән пŏтәртәс пӑ ўра вортәс; ԓыв пӑ ԓўвеԓ веԓты ўтщисэԓ. ");
INSERT INTO kca_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Хӑнам йохԓаԓ, тӑми мŏштәмеԓ кемән, Кесарияйа ԓўвеԓ тусэԓ пӑ Тарс воша китсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Пŏйәкщәты мŏхет пӑ Иудея мўв ԓŏватән, Галилея пӑ Самария ԓŏватән рома усәт, утәԓтыман пӑ Турәм Куща эԓты пӑԓман усәт; щӑԓта Йэмәӈ Ԓыԓән такапман, арамисәт. ");
INSERT INTO kca_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Щиты тыйәс, Петра, хŏԓ мŏхет лӑп йӑхман, Лидда вошән уԓты эвәԓты мŏхет хŏща йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Щита ԓўв Энея нэмпи и хŏйат уйтәс, хŏй ԋийәԓ тӑԓ ŏԓттӑхайәԓән, щащԓы питман, ŏԓәс. ");
INSERT INTO kca_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Петра ԓўвеԓ йастәс: «Эней! Нӑӈ Иисус Христосән тўмтака верԓайән; ŏԓттӑхайэн эԓты нŏх ԓойа». Пӑ ԓўв ищи мŏхты нŏх ԓойәс. ");
INSERT INTO kca_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Пӑ ԓўв Лиддайән пӑ Саронән уԓты хŏйатәтән хŏԓ ватса, пӑ Турәм Куща пеԓа ӑӈкәртсәт пӑ эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Иоппия вошән и утәԓтәты нэ ус, нэмәԓ Тавифа - щит «газель»; ԓўв сӑмәӈ верәтән тэкәнман уса пӑ ар йӑм вер верәс. ");
INSERT INTO kca_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Щи хӑтԓәтән вер тыйәс, ԓўв кӑшаӈа йис пӑ пӑрәс. Ԓўв ԉŏхәтса пӑ нўм хот йӑта пŏтса. ");
INSERT INTO kca_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Лидда пӑ Иоппия вош ԉэпән ванән ус, утәԓтәты йох Петра щита уԓты хуԓмеԓ кемән, ԓўв хŏщайәԓ кӑт хŏйат китсайтән, ԓўвеԓ вохты, ԓыв хŏщайэԓ йŏхәтты ԓўв ӑт ат рŏнәс. ");
INSERT INTO kca_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Петра ԓойәс пӑ ԓын пиԓанән мӑнәс; пӑ хун ԓўв йŏхтәс, нўм хот йӑта ԓўвеԓ тусэԓ, пӑ хŏԓ шукаԓт нэӈәт, хоԓԓәман, ԓўв йэԓпәԓа ԓойсәт, йэрнасәт аԉиԓыман, Тавифа ԓыв пиԓԓаԓән уԓмаԓән верыԓыйәм ŏтԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Петра мŏхет хŏԓ ким партсәԓы пӑ, шанша иԓ эсԓәщман, пойәкщәс, пӑ, мотавтәԓ пеԓа ватман, йастәс: «Тавифа! Нŏх ԓойа». Щӑԓта ԓўв сэмӈиԓаԓ пел пўшсәԓы пӑ, Петра шийаԓәмаԓ кемән, нŏх опсәс. ");
INSERT INTO kca_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ԓўв, йошәԓ ԓўвеԓа мийман, нŏх ԓощәԓтәсԓы пӑ, эвәԓты мŏхет пӑ шукаԓт нэӈәт, вана вохман, ԓыв йэщаԓтэԓ ԓўвеԓ ԓыԓӈат ԓощәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Тӑм вер Иоппия ԓŏватән иса уйәтты питса, пӑ ар хŏйат Турәм Кущайа эвԓәс. ");
INSERT INTO kca_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Пӑ йӑм арат хӑтәԓ ԓўв Иоппия вошән и мŏԓты Симон ԋўки верты ики хŏща ус. ");
INSERT INTO kca_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Кесария вошән и ху ус, нэмәԓ Корнилий, Италийский когорта кўт эԓты уԓты сот ԉаԉ йох куща, ");
INSERT INTO kca_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","хот тэԓәԓ пиԓән Турма эвәԓты хŏйат пӑ Турәм эԓты пӑԓты хŏйат, мира ар йӑм верыԓыйәс пӑ иса Турәм пеԓа пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ԓўв вантәм щирәԓән хӑтԓәԓән йӑрәтйаӈ щос кемән Турәм ангел тŏрԓы ватсәԓԓы, ԓўв хŏщайәԓ ԓŏӈәс пӑ ԓўвеԓа йастәс: «Корнилий!» ");
INSERT INTO kca_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Корнилий пӑ, ԓўв пеԓайәԓ аӈкәрмәмаԓ пӑ хŏԓт пӑԓтамәмаԓ кемән, йастәс: «Мўй, куща?» Ангел ԓўвеԓа йŏхԓы йастәс: «Нӑӈ пойәкԓан пӑ нӑӈ меԓащԓан Турәм хŏща нŏпса питсәт. ");
INSERT INTO kca_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Щӑԓта, хŏйатәт Иоппия воша кита пӑ, Петрайа айәԓты, Симон вохи. ");
INSERT INTO kca_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ԓўв Симон ԋўки ԓэщатты ху хŏща мойԓәԓ, ԓўв хотәԓ щарәс питарән уԓ; ԓўв нӑӈен щи йасӈәт йастәԓ, мўй йурән нӑӈ нŏх пайәтԓайән пӑ нӑӈ хот тэԓэн па». ");
INSERT INTO kca_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Хун, Корнилий пиԓән пŏтәртәм, ангел йэԓ мӑнәс, ԓўв митйохԓаԓ эԓты кӑтән пӑ ԓўв пўӈԓәԓән уԓәм Турма эвәԓты ԉаԉ ху вохсәԓы ");
INSERT INTO kca_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","пӑ ԓывиԓаԓа иса хŏԓ пŏтәрмаԓ йўпийән, ԓывиԓаԓ Иоппияйа китсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Кимет хӑтәԓ, хун ԓыв шушсәт пӑ воша ванамәты питсәт, Петра хут щос кемән хот ԓоӈԓа нŏх хуӈхәс, пойәкщәты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Щӑԓта ԓўв сӑмәԓ вохты питса, пӑ ԓэты ԓӑӈхаса. Щи кўтән, ԓэтот ԓэщатты эԓты, ԓўвеԓа ватты щир ус ");
INSERT INTO kca_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","пӑ ваттаԓән пел пўншаԋщәм турәм хӑр пӑ ԓўв хŏщайәԓ иԓ эсԓәщты мŏԓты пўт, ищи мӑтты ун сŏх, ԋӑԓ щуӈәԓ сӑхат йӑрман уԓԓа пӑ мўва иԓ эсәԓԓа; ");
INSERT INTO kca_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","щи ԓыпийән кӑмән хŏрпи ԋӑԓ йоши–кўрпи войәт, иԓән мўв пӑԓатән ущиԓыты войәт пӑ турәм хӑрән йӑхты тŏхԓәӈ войәт. ");
INSERT INTO kca_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Пӑ ԓўвеԓа тўр сый ус: «Петра ԓойа, веԓа пӑ ԓэва». ");
INSERT INTO kca_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Петра пӑ йастәс: «Ӑнтом, Турәм Куща, ма нэмәԓты пŏрайән нэмәԓты атәм мўй пӑ ӑнта сыстам ŏт ӑт ԓавәнтысәм». ");
INSERT INTO kca_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Щиӈәԋща кимет пўш ԓўвеԓа тўр сый ус: «Мўй Турәм сыстапсәԓы, щит атма мўй пӑ ӑнта сыстама нӑӈ аԓ ԓўӈты». ");
INSERT INTO kca_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Щит хуԓәм пўш ус, – щӑԓта пўт турма па нŏх эԓәтса. ");
INSERT INTO kca_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Хун пӑ Петра ԓўв турмәԓән ощатымаԓән, ԓўв вантәм щирәԓ, щит а мўй, – Корнилийән китәм йохәт, Симон хŏт эԓты иԋщәсман, вана йŏхәтсәт пӑ пушас овән иԓ ԓойсәт. ");
INSERT INTO kca_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ўваԓман, ищмәсэԓ: «Петрайа айәԓтты Симон мўй тӑта?» ");
INSERT INTO kca_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Петра вантәм ŏтәԓ эԓты нумисытаԓ кўтән, Йэмәӈ Ԓыԓ ԓўвеԓа йастәс: «Тӑм, хуԓәм хŏйат нӑӈен кӑшԓәт; ");
INSERT INTO kca_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ԓойа, иԓ ŏхԓа пӑ ԓўв пиԓԓаԓән, йэша нэш ӑт нŏмәнԓыман, мӑна; ԓывиԓаԓ Ма китсәԓам». ");
INSERT INTO kca_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Петра, Корнилия эԓты ԓўв хŏщайәԓ китәм хŏйатәт хŏща иԓ ŏхԓәс пӑ йастәс: «Mа щит, хŏй нын кӑшԓәты; мўй вер урәӈән нын йŏхәтсәты?» ");
INSERT INTO kca_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ԓыв пӑ йастәсәт: «Корнилий сот ԉаԉ йох куща, йӑм сӑмпи пӑ Турәм эԓты пӑԓты ху, иудея мирән хŏԓ йӑма нумман тӑйԓа, йэмәӈ ангел эԓты ԓўв хотәԓа нӑӈен вохты партәпса йŏхтәс пӑ нӑӈ пŏтәрԓан хуԓәтты». ");
INSERT INTO kca_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Щиӈәԋща Петра, ԓывиԓаԓ йŏхи вохмаԓ йўпийән, ԓапәтсәԓы. Кимет хӑтәԓ пӑ нŏх киԓмаԓ кемән, ԓыв пиԓԓаԓән мӑнәс, тухәԓ Иоппия хӑнам йох па ԓўв пиԓәԓән мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Йухәт хӑтәԓ ԓыв Кесарияйа йŏхәтсәт. Корнилий пӑ, ԓўв рутԓаԓ пӑ ван пиԓ йохԓаԓ и йӑха вохман, ԓывиԓаԓ ԓавәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Хун Петра йŏхи ԓŏӈты ўтщийәс, Корнилий ԓўв хŏщайәԓ йэщаԓт этәс пӑ ԓўв кўрԓаԓ шŏма шанша керәптыман, иԓ ԋўрәс. ");
INSERT INTO kca_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Петра пӑ ԓўвеԓ нŏх ԓощәԓтәсԓы, пŏтәрман: «Нŏх ԓойа; ма ищи хŏйат». ");
INSERT INTO kca_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Пӑ, ԓўв пиԓәԓән пŏтрэмәман, хота йŏхи ԓŏӈәс пӑ ар ӑктәщәм хŏйат уйтәс. ");
INSERT INTO kca_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Щӑԓта ԓывиԓаԓа йастәс: «Нын уйәтԓәԓән, иудея хŏйата па сыр хŏйат пиԓән пŏтрэмәты пӑ вана рӑхиԓыты ӑт рӑхәԓ; туп мӑнэма Турәм аԉәс, ма и хŏйат нэш атма мўй пӑ ӑнта сыстама ӑт ат ԓўӈәтсәм. ");
INSERT INTO kca_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Щишән ма, хун вохсайәм, пӑ йŏхи ӑт ԋŏсәрщәман йŏхәтсәм. Щӑԓта, иԋщәсԓәм: Мўй вер урәӈән нын мӑнэм вохсәԓән?» ");
INSERT INTO kca_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Корнилий йастәс: «Ԋӑԓмет хӑтәԓән ма тӑм щос унты вўщԓәсәм пӑ йӑрәԏйаӈ щос пеԓа мӑнәмән йŏԓән хотэмән пойәкщәсәм; щӑԓта щи, ма йэԓпемән нŏвийән ворԓәты ԓумтәӈәӈ ики этәс ");
INSERT INTO kca_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","пӑ пŏтәртәԓ: 'Корнилий! Нӑӈ пойкен хуԓса пӑ меԓащԓан Турәм хŏща нумәԓмәсайәт'. ");
INSERT INTO kca_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Щиӈәԋща, Иоппияйа кита пӑ Петрайа айәԓты Симон вохи: ԓўв ԋўки верты ху Симон хотән щарәс питарән мойԓәԓ; ԓўв йŏхәтәԓ пӑ нӑӈена йастәԓ'. ");
INSERT INTO kca_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ищи кумат ма нӑӈ хŏщайэн китсәм, пӑ нӑӈ йӑма версэн, йŏхәтсән. Ин мўӈ хŏԓ Турәм йэԓпийән ԓойԓув, мўй нӑӈена Турәм эԓты партман уԓ, иса хŏԓ хуԓәтты урәӈән». ");
INSERT INTO kca_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Петра ўӈԓәԓ пўшсәԓы пӑ йастәс: «Йӑна мŏштәԓэм, Турәм веш пеԓа ӑт ватәԓ, ");
INSERT INTO kca_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","туп кашәӈ мир хŏща Ԓўв эԓтэԓ пӑԓты ŏт пӑ тўӈа–щира уԓты ŏт Ԓўвеԓа рӑхи. ");
INSERT INTO kca_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ԓўв Израиль пŏхәта йасәӈ китәс, пайԓы уԓәпса Иисус Христос сӑхат аԉәс; Тӑм хŏԓ хŏйатәта уԓты Турәм Куща. ");
INSERT INTO kca_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Нын Иудея ԓŏватән, Галилея эԓты ўйман, Иоаннән утәԓтыйәм йиӈка ԓŏӈәԓтыты вер йўпийән, уԓәм верәт уйәтԓәԓән: ");
INSERT INTO kca_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Хŏты Турәм Назарет эԓты уԓты Иисус Йэмәӈ Ԓыԓән пӑ йурән ԋŏсәтсәԓы. Пӑ Ԓўв йӑм верман пӑ хŏԓ хŏйатәт, хŏй хиԋән катәԓман усайәт, тўмтака верман, йӑӈхәс, Турәм Ԓўв пиԓәԓән ус, щишән. ");
INSERT INTO kca_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Мўӈ пӑ щит хŏща иса вантәм ŏтәт, мўй Ԓўв Иудея мўвән пӑ Иерусалимән верәс, пӑ мет йухәт Ԓўв, акԓа нŏх сэкман, пӑратса. ");
INSERT INTO kca_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Турәм хуԓмет хӑтәԓән Тӑмен нŏх ԓыԓӈатсәԓы, пӑ Ԓўвеԓа этԓыты щир мӑс ");
INSERT INTO kca_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ӑнта хŏԓ мира, туп вантәм ŏтәта, Турәм эԓты пирыйәм хŏйатәта, мўӈева, пӑ мўӈ Ԓўв пиԓәԓән ԓэсув пӑ йищсув, щи йўпийән, хун Ԓўв пӑрмаԓ эԓты нŏх ԓыԓәӈԓәс. ");
INSERT INTO kca_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Щӑԓта Ԓўв мўӈева мира пŏтәртты пӑ вантәм ŏтәта уԓты партсәԓы, Ԓўв Турәм эԓты ԓыԓәӈ пӑ пӑрәм хŏйатәта Сўта уԓты пŏнәм Ŏт. ");
INSERT INTO kca_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ԓўв эԓтэԓ хŏԓ Турәм айкеԓ туты хŏйатәт аԉԓәт, кашәӈ Ԓўвеԓа эвәԓты ŏт Ԓўв нэмәԓән кӑрэк йŏрэмәты щир мŏщатәԓ». ");
INSERT INTO kca_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Хун Петра хŏԓна щи пŏтрәԓ йэԓԓы тусԓы, Йэмәӈ Ԓыԓ кашәӈ йасәӈ хуԓәнтәм хŏйата эсԓәщәс. ");
INSERT INTO kca_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Пӑ Петра пиԓән йŏхтәм, иудейәт эԓты эвәԓты ŏтәт ӑԓ пакнысысәт, Йэмәӈ Ԓыԓ мойԓәпса па рут йоха па эсәԓман уса; ");
INSERT INTO kca_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ԓыв хуԓсәт, хŏты щитәт па йасӈәтән пŏтәртсәт пӑ Турәм вŏԓаӈа айәԓтсәт, щишән. Щиӈәԋща Петра йастәс: ");
INSERT INTO kca_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Хŏй щитәта йиӈка ԓŏӈәԓтыты ӑт эсәԓты верәтәԓ, хŏйтат, мўӈ итэвән Йэмәӈ Ԓыԓән мойԓысайәт?» ");
INSERT INTO kca_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Щӑԓта ԓывиԓаԓ Иисус Христос нэм хўватән йиӈка ԓŏӈәԓтыты партсәԓы. Щи йўпийән ԓыв ԓўвеԓа кӑмәтса хӑтәԓ ԓыв хŏщайэԓ уԓты вохсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Иудеяйән уԓәм апостоләт пӑ хӑнам йох хуԓсэԓ, мӑтты па рут йох ищи Турәм йасәӈ вана ўсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Щӑԓта хун Петра Иерусалима йŏхтәс, иудейәт эԓты уԓты хӑнам йохԓаԓән ԓўв йэщаԓт нўрыса, ");
INSERT INTO kca_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","пŏтәртман: «Нӑӈ ӑт эвтәм мŏхет хŏща йӑхсән пӑ ԓыв пиԓԓаԓән ԓэсән». ");
INSERT INTO kca_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Петра пӑ хŏты вер ус, щиты ԓывиԓаԓа пŏтәртты питсәԓԓы, йастыйәԓ: ");
INSERT INTO kca_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Иоппия вошән ма пойәкщәсәм пӑ щи пўԉаӈ вантәпса ватсәм: и мŏԓтты пўт иԓ эсԓәщәс, ищи мӑтты ун сŏх лопәс, ԋӑԓ щуӈәԓ сӑхат турәм хӑр эԓты иԓ эсәԓты ŏт, пӑ ма хŏщайэм иԓ эсԓәщәс. ");
INSERT INTO kca_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ма пўт ԓыпеԓа ӑӈкәрмәсәм пӑ, вантыман, ԋӑԓ йоши–кўрпи войәт, иԓән мўв пӑԓатән ущиԓыты войәт пӑ турәм хӑрән йӑхты тŏхԓәӈ войәт шийаԓәсәм. ");
INSERT INTO kca_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Щӑԓта ма тўр сый хуԓтмәсәм, ма пеԓайэм пŏтәртәԓ: 'Петра, нŏх ԓойа, веԓа пӑ ԓэва'. ");
INSERT INTO kca_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ма пӑ йастәсәм: 'Ӑнта, Турәм Куща, нэмәԓты атәм мўй пӑ ӑнта сыстам ŏт нэмәԓт пŏрайән ма ўӈԓэма ӑт питыԓыйәс'. ");
INSERT INTO kca_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Пӑ турәм хӑр эԓты кимет пўш тўр сый мӑнэма йŏхԓы йастәс: 'Турәм мўй сыстапсәԓы, щит ӑнта сыстама нӑӈ аԓ ԓўӈты'. ");
INSERT INTO kca_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Щит хуԓәм пўш ус, пӑ па хŏԓ иса турәм хӑра нŏх эԓәтса. ");
INSERT INTO kca_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Щӑԓта ин, щи пўԉаӈ Кесария эԓты, ма хŏщайэм китәм хуԓәм хŏйат, хотэм ԉэпа, хŏта ма усәм, ԓойсәт. ");
INSERT INTO kca_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Йэмәӈ Ԓыԓ мӑнэма йастәс, ма ԓыв пиԓԓаԓән, йэша нэш ӑт нŏмәнԓыман, ат мӑтсәм. Ма пиԓэмән щи хут хӑнам йох па мӑтсәт, пӑ мўӈ тўм хŏйатэн хота йŏхәтсув. ");
INSERT INTO kca_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ԓўв мўӈева пŏтәртсәԓы, хŏты ԓўв йŏԓән хотәԓән йэмәӈ ангел ватсәԓы, пӑ ангел ԓўвеԓа йастәс: 'Хŏйатәт Иоппияйа кита пӑ Петрайа айәԓты Симон вохи; ");
INSERT INTO kca_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ԓўв нӑӈена йасӈәт йастәԓ, щи йасӈәт йурән нӑӈ нŏх пайәтԓайән пӑ нӑӈ хот тэԓэн па'. ");
INSERT INTO kca_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Хун пӑ ма пŏтәртты питсәм, ԓыв эԓтыԓаԓа Йэмәӈ Ԓыԓ иԓ эсԓәщәс, оԓәӈән хŏты мўӈ эԓтэва эсԓәщәс. ");
INSERT INTO kca_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Щи пŏрайән ма Турәм Куща йасәӈ нумәԓмәсәм, хŏты Ԓўв пŏтәртәс: 'Иоанн йиӈка ԓŏӈәԓтыйәс, нын пӑ Йэмәӈ Ԓыԓа ԓŏӈәԓтты питԓайты'. ");
INSERT INTO kca_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Щиӈәԋща, Турәм ԓывиԓаԓа ищимәщ мойԓәпса мӑс ки, мўй хŏрпи мўӈева, Турәм Куща Иисус Христоса эвԓәм ŏтәта мӑс, ма пӑ хŏй, Турма йэртԓыты ат верәтсәм?» ");
INSERT INTO kca_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Щит хуԓәтмеԓ йўпийән, ԓыв иԓ ромәпсәт пӑ Турәм ишәксэԓ, пŏтәртман: «Таӈха, па рут хŏйатәта па Турәм кӑрэк эԓты уԓәпса пеԓа керԓәты щир мӑс». ");
INSERT INTO kca_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Щи кўтән Стефан йўпийән уԓәм ԋўхәтԓыты вер эԓты лакки мӑнәм ŏтәт, туп иудейәта йасәӈ тўвман, Финикия унты пӑ Кипр пӑ Антиохия унты мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ԓыв эԓтыԓаԓ тухԓәт Кипр хŏйатәт, тухԓәт пӑ Киринея хŏйатәт усәт, хŏй Антиохияйа йŏхәтман, Турәм Куща Иисус эԓты Йӑм Айкеԓ грек йохәта пŏтәртсәт. ");
INSERT INTO kca_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Пӑ Турәм Куща йош ԓыв пиԓԓаԓән ус, пӑ йӑм арат ар хŏйат, эвәԓман, Турәм Куща пеԓа керԓәсәт. ");
INSERT INTO kca_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Щит эԓты Иерусалимән ӑктәщиты хŏйатәт унты сый йŏхтәс, пӑ Варнава Антиохияйа мӑнты партса. ");
INSERT INTO kca_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ԓўв йŏхәтмаԓ пӑ Турәм йӑм кащаԓәмаԓ кемән, нŏх амтәс пӑ хŏԓ мŏхет Турәм Куща хŏща вещкат сӑмән катԓәсты партсәԓы; ");
INSERT INTO kca_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ԓўв йӑм сӑмпи ху ус пӑ Йэмәӈ Ԓыԓән пӑ эвәԓты щирән тэкәнман уса, щишән. Щиӈәԋща йӑм арат мир Турәм Куща пеԓа керԓәс. ");
INSERT INTO kca_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Йухәт Варнава Савл кӑшты урәӈән Тарса мӑнәс пӑ, ԓўвеԓ уйәтмаԓ кемән, Антиохияйа тусԓы. ");
INSERT INTO kca_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Тӑԓаӈ тӑԓ–ԓўӈ ԓын пойәкщәты хŏйатәт ӑктәщиты тӑхайән йӑм арат хŏйат утәԓтәсӈән, пӑ утәԓтыты йох Антиохияйән веԓщи щи христианәта айәԓты питсайәт. ");
INSERT INTO kca_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Щи хӑтԓәтән Иерусалим эԓты Антиохияйа Турәм айкеԓ туты хŏйатәт йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Пӑ ԓыв эԓтыԓаԓ и ху, нэмәԓән Агав, нŏх ԓоймаԓ кемән, Йэмәӈ Ԓыԓән аԉман, йастәс, мӑтты иса мўв ԓŏватән ун ԓэԓԓы щир питәԓ, Клавдия кесарь пŏрайән щи уԓәм щир. ");
INSERT INTO kca_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Щиӈәԋща утәԓтәты йох, кашәӈ ԓўв тӑйтŏтәԓ эԓты Иудейән уԓты хӑнам йохԓаԓа, ԋотәпса китты пŏтсәт, ");
INSERT INTO kca_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","щиты щи версэԓ, ӑктәм ŏхԓаԓ Варнава па Савл мŏхты эвәԓты хŏйатәт ун икета китсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Щи пŏрайән Ирод хон щи ӑктәщиты хŏйатәт эԓты тухәԓ хŏйатԓаԓ пеԓа йошԓаԓ нŏх аԓәпсәԓы, ԓывиԓаԓа атәм верты урәӈән, ");
INSERT INTO kca_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","пӑ Иаков, Иоанн йай, аԓтты кешийән пӑратты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ваттаԓән, щит иудейәта йӑм, щи йўпийән Петра па ўсԓы, – щи пŏрайән тўтәӈ ԋаԋ йэмәӈ хӑтԓәт усәт, – ");
INSERT INTO kca_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","пӑ, ԓўвеԓ иԓ катәԓмаԓ йўпийән, пӑтлам хота омәссәԓы, пӑ ԋӑԓ ԉаԉ йохпи ԋӑԓ похла ԓўвеԓ шавиты партсәԓы, Пасха йўпийән мир хŏща ԓўвеԓ этәԓтәты нумәсыйәс. ");
INSERT INTO kca_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Петра пӑтлам хотән эԓт ԓавәԓтса, щи кўтән ӑктәщиты хŏйатәт ԓўв урӈәԓән тўӈа–щира Турма пойәкщәсәт. ");
INSERT INTO kca_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Хун пӑ Ирод ԓўвеԓ ким этәԓтәты утщисԓы, щи ат Петра кӑт ԉаԉ йŏхӈән кўтән ŏԓәс, кӑт карты кеԓән пŏнман уса, пӑ ԉаԉ йохән ов пўӈәԓән пӑтлам хот шависа. ");
INSERT INTO kca_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Щӑԓта ин, Турәм Куща ангел ԓўв йэщаԓтәԓ ԓойәс, пӑ нŏвийән пӑтлам хот нŏх хутԓәптәса. Ангел, Петра пўӈԓәԓ эԓты пŏткәман, ԓўвеԓ нŏх кўрәтсәԓы пӑ йастәс: «Сора ԓойа». Щӑԓта карты кеԓԓаԓ ԓўв йошԓаԓ эԓты иԓ рӑкәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Пӑ ангел ԓўвеԓа йастәс: «Ӑтпен йӑры пӑ кўр ԓумтәмԓан ԓумтаԓән». Ԓўв щиты версәԓы. Щӑԓта ԓўвеԓа йастәԓ: «Нӑӈ эԓты ԓумтәмен ԓумты пӑ ма йўпемән йўва». ");
INSERT INTO kca_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Петра ким этәс пӑ ԓўв йўпеԓән шушәс, ӑт уйәтман, ангелән верты вер йӑна щиты ус, нумәсман, ԓўв вантәпса ватәԓ. ");
INSERT INTO kca_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Оԓәӈ ԓавәԓты ԉаԉ йох пӑ кимет ԓавәԓты ԉаԉ йох мŏхты мӑнман, ԓын вош пеԓа мӑнты карты пушас ова йŏхәтсәтән. Щи ов ԓын урӈәнән ԓўв сӑхатәԓ пелки пўншантәс; ԓын ким этсәӈән пӑ и вош хулы мӑтсәԓән, щӑԓта шамкап ангел ԓўв пўӈԓәԓ эԓты хŏԓт пентәс. ");
INSERT INTO kca_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Щиӈәԋща Петра, сэмәԓ этмаԓән, йастәс: «Ин манэма йӑна щи ныԓа, Турәм Куща Ԓўв ангеләԓ китмаԓ пӑ мӑнэм хŏԓт пайәтсәԓы Ирод йош эԓты пӑ иса щит эԓты, мўй иудей мир ԓавԓәс». ");
INSERT INTO kca_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Щӑԓта, тыйэԓ–тохэԓ вантымаԓ йўпийән, Мария, Марка айәԓтты Иоанн аԋԏи, хот ԉэпа йохтәс, хŏта ар хŏйат ӑктәщсәт пӑ пойәкщәсәт. ");
INSERT INTO kca_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Хун пӑ Петра пушас овән хŏплэмәс, Рода нэмпи митнэ хуԓәтты ким этәс. ");
INSERT INTO kca_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Щӑԓта, Петра тўр сый мŏштымаԓ кемән, амәтмаԓ рўвән пушас ов ӑт пўшсәԓы, йŏхи хухәԓмәман, такан йастәс, мӑтты Петра пушас овән ԓойәԓ. ");
INSERT INTO kca_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Тўмет пӑ ԓўвеԓа йастәсәт: «Нӑӈ мўй ŏшенән уԓԓән?» Туп ԓўв и йэԓԓы ўра верәԓ. Ԓыв пӑ пŏтәртсәт: «Щит Ԓўв ангеләԓ». ");
INSERT INTO kca_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Щи кўтән Петра пушас ов сэкты йэԓԓы питәс. Хун пӑ ов пўшсэԓ, ԓўвеԓ кащаԓәсәт пӑ ӑԓ пакәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ԓўв пӑ, йошәԓән пос верман, мӑшйайән ат усәт, ԓывиԓаԓа пŏтәртсәԓы, хŏты Турәм Куща ԓўвеԓ пӑтлам хот эԓты ким этәԓтәсԓы, пӑ йастәс: «Тӑм вер эԓты Иаков пӑ хӑнам йохәт айкеԓән вераԓән». Йухәт, ким этмаԓән, па тӑха пеԓа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Хӑтԓа йўвмаԓ йўпийән, ԉаԉ йох кўтән ун хурэп тыйәс, хŏты Петра йис. ");
INSERT INTO kca_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ирод пӑ, ԓўвеԓ кӑшмаԓ пӑ ӑт уйәтмаԓ йўпийән, ԓавԓәм ԉаԉ йох сўтәтсәԓы пӑ ԓывиԓаԓ пӑратты партсәԓы. Йухәт ԓўв Иудея эԓты Кесарияйа мӑнәс пӑ щита хӑщиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ирод Тир пӑ Сидон хŏйатәт пеԓа лики хуры ус; ԓыв пӑ, ԓыв кўтэԓән йастатман, ԓўв хŏщайәԓ йŏхәтсәт пӑ хон хот куща, Власт, ԓыв пеԓайэԓ керәтман, пайԓы уԓәпса вохсәт, ԓыв мўвеԓ хон мўв эԓты ԓэс, щишән. ");
INSERT INTO kca_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Йастәм хӑтәԓән Ирод, хон ԓумтәма ԓумәтԓыман, пӑԓ тӑхайа опсәс пӑ ԓыв пеԓайэԓ пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Мир такан ԋухмийәԓ: «Щит ӑнта хŏйат, Турәм тўр сый». ");
INSERT INTO kca_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Туп шӑмкапан Турәм Куща ангел ԓўвеԓ мушәӈа версәԓы, щи урәӈән, мўйа ԓўв Турма ишәк йасәӈ ӑт йастәс; щӑԓта Ирод ики, суԓ войәтән шӑпиман, пӑрәс. ");
INSERT INTO kca_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Турәм йасәӈ пӑ арамәс пӑ лакки ԓӑрпиԓәс. ");
INSERT INTO kca_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Варнава пӑ Савл, партәм верән тӑԓаӈа верман йўпийән, Марк нэма пŏнәм, Иоанн пӑтән ўйман, Иерусалим эԓты Антиохияйа йŏхԓы йŏхәтсәтән. ");
INSERT INTO kca_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Антиохия вошән, щита уԓты пойәкщәты хойатәт ӑктәщиты вер хŏща тухәԓ Турәм айкеԓ туты хŏйатәт пӑ утәԓтәты йох усәт: Варнава, пӑ Нигера айәԓтты Симеон, пӑ Луций, Киринея ху, пӑ Манаил, Ирод ԋӑԓмет мўв щуӈ куща пиԓән энмәм ху, пӑ Савл. ");
INSERT INTO kca_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Хун ԓыв Турәм Кущайа верәт версәт пӑ вўщԓәсәт, Йэмәӈ Ԓыԓ йастәс: «Варнава пӑ Савл Мӑнэма щи вер пеԓа мийаԓән, мўй урәӈән Ма ԓынан вохсәԓам». ");
INSERT INTO kca_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Щиӈәԋща ԓыв, ўщԓәмеԓ пӑ пойәкщәмеԓ йўпийән пӑ йошԓаԓ ԓын эԓтыԓән поныԓымеԓ йўпийән, ԓынан эсәԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Щитӈән, Йэмәӈ Ԓыԓән китман уԓман, Селевкияйа йŏхәтсәтән, щиԓта пӑ Кипр пухра хŏпән мӑтсәӈән; ");
INSERT INTO kca_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Щӑԓта Саламинән уԓман, иудейәт пойәкщәты хотәтән Турәм йасәӈ пŏтәртсәтән; ԓын ԉэпәнән Иоанн па ус, ԓынана ԋотты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Пухәр мўв ԓŏватәԓән Паф унты мӑнман, ԓыв и мŏԓты иудей ху, нэмәԓән Вариисус, уйәтсәтән. Ԓўв щӑртәӈ пӑ ԋаԓмәӈ ики ус, Турәм айкеԓ туты икийа верәсәс. ");
INSERT INTO kca_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ԓўв проконсул Сергий Павел, ŏшәӈ ху, пиԓән ус. Проконсул Турәм йасәӈ хуԓты ԓӑӈхас, щишән Варнава пӑ Савл вана вохсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Елима, щӑртәӈ ики, пӑ (ԓўв кимет нэмәԓ щит айәԓԓәԓ) ԓыв пиԓԓаԓән ӑт кашащәԓ, эвәԓты вер эԓты проконсул пўӈԓа ԓавәԓԓәԓы. ");
INSERT INTO kca_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Туп Савл, ԓўв хŏԓна Павел, Йэмәӈ Ԓыԓән тэкәнман пӑ сэмӈиԓаԓ ԓўв пеԓайәԓ пайәтман, ");
INSERT INTO kca_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","йастәс: «Йээй, кӑмән ŏщмарән пӑ кӑмән атәмән тэкнәм ŏт, хиԋ пŏх, кашәӈ вещкат вер пеԓа ԉик туты ŏт! Нӑӈ Турәм Куща тўӈ йушәт эԓты йŏвра хўщты а мўй вŏԓыԓән пеԓа? ");
INSERT INTO kca_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ин тӑм, Турәм Куща йош нӑӈ пеԓайэн нŏх аԓԓәмман уԓ: нӑӈ сэмԓы питԓән пӑ пŏра унты хӑтәԓ ӑт ватԓэн». Щӑԓта шӑмкап ԓўв эԓтэԓ тўрма пӑ пӑтлам лаӈкантәс, пӑ ԓўв, сӑм мӑнман, тыйэԓ–тохэԓ шушиԓыйәс, ватәԓтәты хŏйат кӑншәс. ");
INSERT INTO kca_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Щиӈәԋща проконсул тыйәм вер кащаԓәмаԓ кемән, Турәм Куща утәԓтәпса эԓты, ощатыман, эвԓәс. ");
INSERT INTO kca_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Паф эԓты нык хўвԓәмеԓ кемән, Павел пӑ ԓўв пўӈԓәԓән уԓәм ŏтӈән Памфилия мўвән уԓты Пергияйа йŏхәтсәт. Туп Иоанн, ԓын эԓтыԓән пўӈԓа йирԓәман, Иерусалима йŏхԓы мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ԓын пӑ, Пергия эԓты мӑнман, Писидия ԉэпән уԓты Антиохияйа йŏхәтсәтән пӑ, иудейәт пойәкщәты хота шаббат хӑтәԓән ԓŏӈман итән, иԓ омәссәтән. ");
INSERT INTO kca_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Закон пӑ Турәм айкеԓ туты хŏйатәт нэпекәт ԓўӈтәм йўпийән иудейәт пойәкщәты хот кущайәт ԓынана йастәты китсәт: «Хӑнам йохӈән! Нын мир пеԓа нŏмәс такапты йасәӈ тӑйԓәтән ки, пŏтәртатән». ");
INSERT INTO kca_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Павел, нŏх ԓойман пӑ йошәԓән пос верман, йастәс: «Израиль йох пӑ Турәм эԓты пӑԓты мŏхет! Хуԓәнтаты. ");
INSERT INTO kca_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Тӑм мир Турәм мўӈ ащиԓув пирысԓы пӑ тӑм рут мир Египет мўв хŏща уԓмаԓ пŏрайән ԓӑтәӈа версәԓы, пӑ йурәӈ йошәԓән щиԓта йэԓ тусԓы, ");
INSERT INTO kca_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","пӑ ԋӑԓйаӈ тӑԓ кем ԓывиԓаԓ таԓ мўв хŏща ԓапәтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Щӑԓта, ԓапәт сыр мир Ханаан мўвән пӑратмаԓ йўпийән, щитԓаԓ мўв ԓывиԓаԓа йэԓԓы тӑйты ортсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Пӑ щи йўпийән, ԋӑԓсот ветйаӈ кем тӑԓ ԓывиԓаԓа сўт йохәт мийԓыйәс Турәм айкеԓ туты хŏйат Самуил унты». ");
INSERT INTO kca_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Йухәт ԓыв хон вохсәт, пӑ Турәм ԓывиԓаԓа Саул мӑс. Кис пŏх, Вениамин рут эԓты уԓты ху. Щиты ԋӑԓйаӈ тӑԓ хӑщәс. ");
INSERT INTO kca_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ԓўвеԓ пўӈԓа пайәтмаԓ йўпийән, ԓывиԓаԓа хона Давид пŏтсәԓы. Турәм ԓўв эԓтэԓ йастәс: 'Давид, Иессей пŏх, Ма сӑмема рӑхты ху, Ма уйәтсәм щит, хŏй Ма ԓӑӈхаты ŏтԓам хŏԓ тӑԓаӈа верԓәԓы'. ");
INSERT INTO kca_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ԓўв ԋаврэмԓаԓ эԓты Турәм аԉиԓыйәм верәԓ хўват Израиль мира Нŏх пайәтты Ŏт мӑс - Иисус. ");
INSERT INTO kca_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ԓўв йӑмәс эттаԓ йэԓпийән Иоанн хŏԓ Израиль мира щит эԓты пŏтәртәс: йиӈка ԓŏӈәԓтыты вер верты урәӈән, кӑрэк эԓты шӑшән керԓәты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Иоанн, ԓўв верәԓ йэтшәты питмаԓән, пŏтәртәс: 'Хŏй йўкана мӑнэм нын тӑйԓәԓән? Ма ӑнта щит; туп ин, ма йўпемән йиԓ щит, Хŏй хŏща кўр ԓумтәмәԓ эхты ма ӑт рӑхԓәм'. ");
INSERT INTO kca_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Хӑнам йох, Авраам рут ԋаврэмәт, пӑ нын кўтәнән Турәм эԓты пӑԓты ŏтәт! Нынана тӑм нŏх пайтәсты йасәӈ китман уԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Иерусалимән уԓты мŏхет пӑ ԓыв кущайԓаԓ, Иисус ӑт мŏштәсэԓ пӑ сўтәтсэԓ, пӑ щишән Турәм айкеԓ туты хŏйатәт йасӈәт тӑԓаӈа версәԓаԓ, щи йасӈәт кашәӈ шаббат хӑтәԓән ԓўӈәтԓайәт. ");
INSERT INTO kca_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ԓыв Ԓўв хŏщайәԓ нэмәԓты нўр ӑт уйәтсәт, мўй урәӈән Ԓўв сŏрма ат пайәтса, пӑ ищипа Пилат эԓты Ԓўвеԓ паратты щир вохсәт. ");
INSERT INTO kca_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Хун пӑ хŏԓ Ԓўв эԓтэԓ хӑншәм ŏт тӑԓаӈа версэԓ, йўх эԓты иԓ ўймеԓ йўпийән, хŏшапәӈ кев ԓыпийа Ԓўвеԓ пŏтсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Туп Турәм пӑрәм эԓты Ԓўвеԓ нŏх ԓыԓӈатсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ԓўв ар хӑтәԓ хўват щитәта этԓыйәс, хŏй Ԓўв пиԓәԓән Галилей эԓты Иерусалима этәс пӑ хŏй ин мир йэԓпийән Ԓўвеԓ вантәм ŏтәта уԓԓәт. ");
INSERT INTO kca_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Пӑ мўӈ нынана Йӑм Айкеԓ йастәԓув: ащиԓува аԉәм вер, Турәм мўӈева тӑԓаӈа версәԓы, ԓыв ԋаврэмԓаԓа, Иисус нŏх ԓыԓӈатман, ");
INSERT INTO kca_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","хŏты пӑ кимет псаломән хӑшман уԓԓа: 'Нӑӈ Ма Пŏхем: Ма ин Нӑӈен сэма пайәтсэм'. ");
INSERT INTO kca_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ԓўвеԓ пӑрәм эԓты нŏх ԓыԓӈатмаԓ йўпийән, щишән Ԓўв шимты ӑт питәԓ, тӑм эԓты щиты йастәс: 'Ма нынана, Давида аԉәм йӑмԓам мӑԓәм, йӑна'. ");
INSERT INTO kca_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Щишән па тӑхайән па пŏтәртәԓ: 'Йэмәӈ Нӑӈ Ŏтэна шимты щир шийаԓәты ӑт мӑԓэн'. ");
INSERT INTO kca_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Давид, ԓўв пŏрайәԓән Турәм ԓӑӈхаты щир хўват вермаԓ йўпийән, пӑрәс, пӑ ԓўв ащиԓаԓ хŏща пŏтса, пӑ шимты вер шийаԓәс; ");
INSERT INTO kca_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Тўми, Хŏй Турәмән нŏх ԓыԓӈатса, шимты вер ӑт шийаԓәс. ");
INSERT INTO kca_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Щишән, хӑнам йох, ма ԓӑӈхаԓәм, нын ат уйәтсәԓән, Ԓўв урӈәԓән нынана кӑрэк йŏрэмәты щир такан аԉԓа; ");
INSERT INTO kca_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","пӑ мўй хŏща иса, нын Моисей законән вещкат щира пайтәсты ӑт верәтсәты, щит хŏща кашәӈ эвәԓты ŏт Ԓўв хўватәԓән вещката пайтәсәԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Шаващаты малы, Турәм айкеԓ туты хŏйатәт хŏща йастәм ŏт нынана аԓт хойәԓ: ");
INSERT INTO kca_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Вантаты, укщәпԓәты ŏтәт, ощатыйаты пӑ хŏԓт пеԓа ушаты; Ма нын хӑтәԓԓәнын щимәщ вер верԓәм, щит мӑтты хŏйатән нынана пŏтәртса ки, нын ӑт эвәԓсәты ԓуԓән'». ");
INSERT INTO kca_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ԓын иудейәт пойәкщәты хот эԓты ким этман пŏрайән па рут йохәтән па шаббат хӑтәԓән щит эԓты пŏтәртты партсайӈән. ");
INSERT INTO kca_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Хун пӑ ӑктәщийәм хŏйатәт лакки эсәԓсайәт, ар пеләк иудей йох пӑ па рут эԓты иудейәт щира эвԓәптәм Турәм пеԓа сӑмәӈ ŏтәт Павел пӑ Варнава йўпи туԓәт. Ԓын, ԓыв пиԓԓаԓән пŏтрэмәман, ԓывиԓаԓ Турәм йӑм хŏща уԓты нŏмәс такапсәтән. ");
INSERT INTO kca_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Па шаббат хӑтәԓән вош тэԓ мир Турәм йасәӈ хуԓәтты хŏԓ ӑктәщәс. ");
INSERT INTO kca_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Туп иудейәт, мир шийаԓәмеԓ кемән, ԓоԓәмты нŏмәсән тэкәтсайәт пӑ, кӑткўтән уԓман пӑ ўӈращтыман, Павел пŏтәртты верәт пеԓа ўра вортты питсәт. ");
INSERT INTO kca_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Щиӈәԋща Павел пӑ Варнава такан йастәсӈән: «Нынана оԓәӈән Турәм йасәӈ пŏтәртты мосәс, туп хŏты нын Турәм йасәӈ пўӈԓа ушиԓԓән пӑ нынан нын и пўша уԓәпсайа ӑт рӑхтыйа верԓәԓән, щишән, мўӈ па рут йох пеԓа йастәԓув». ");
INSERT INTO kca_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Тӑмиты Турәм Куща мўӈева йасәӈ хӑйәс, щишән: 'Ма Нӑӈен па рут йоха нŏви кеша пŏтсэм, Нӑӈ, нŏх пайтәсты щир урәӈән, мўв сŏхәнты унты ат усән'. ");
INSERT INTO kca_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Па рут мир, щит хуԓман, амтәтԓысәт пӑ Турәм Куща йасәӈ ишәксэԓ, пӑ хŏԓыйэ, хŏй и пўша уԓты уԓәпсайа пирысайәт, эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Щӑԓта Турәм Куща йасәӈ щи мўв ԓŏватән лакки ԓӑрпиԓәс. ");
INSERT INTO kca_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Туп иудейәт, Турәм пеԓа сӑмәӈ, ԓӑтәӈ нэӈәт пӑ вошән ŏха уԓты хŏйатәт хўщмәмеԓ йўпийән, Павел пӑ Варнава пеԓа воштәты нŏмәс версәт пӑ уԓты тӑхайән эԓты ԓынан воштәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ԓын пӑ, кўрԓын эԓты хиш ԓывиԓаԓа пӑркатман, Икония воша мӑтсәӈән. ");
INSERT INTO kca_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Утәԓтәты йох пӑ амәтән пӑ Йэмәӈ Ԓыԓән тэкәнман усайәт. ");
INSERT INTO kca_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Иконияйән ԓын и йӑха иудейәт пойәкщәты хота ԓŏксәӈән пӑ щиты пŏтәртсәӈән пӑ щи арат ар иудейәт пӑ грекәт эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ԓын айкеԓәна ӑт эвәԓты иудейәт пӑ хӑнам йохәт йэщаԓт па рут йох сӑмԓаԓ йŏвра хўщсэԓ пӑ ԉикмәԓтсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Пӑ хŏты, ԓын щита йӑм хўват усӈән. Ԓын Турәм Куща эԓты хӑрщийа пŏтәртсәӈән, Хŏй Ԓўв йӑмәԓ йасәӈ ныты урәӈән, ԓын йошԓәнән йэмәӈ посәт пӑ вантыԓԓаӈәԓ верәт верәс. ");
INSERT INTO kca_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Щи кўтән вошән мир кӑтна ортәсәс: итԓаԓ иудейәт пеԓа усәт, киметԓаԓ пӑ – апостоләт пеԓа. ");
INSERT INTO kca_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Хун пӑ па рут йох пӑ иудейәт ԓыв кущайԓаԓ пиԓән ԓын пеԓайән ӑратсәт, ԓынан йэԓапты пӑ кевән йовәԓты урәӈән, ");
INSERT INTO kca_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ԓын, щит эԓты хуԓман, Ликаония мўв вошӈәна, Листрайа пӑ Дервияйа, пӑ щи ԉэпән уԓты куртәта мӑтсәӈән, ");
INSERT INTO kca_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","пӑ щита Йӑм Айкеԓ тутԓысӈән. ");
INSERT INTO kca_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Листрайән и мŏԓты, вевтам кўрпи ху опсәс, пӑтлам хот уш эԓты кўрԓы питман ус, пӑ нэмәԓты пŏрайән ӑт шушиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ԓўв Павел пŏтрәпса хуԓәнтәс. Павел ԓўв пеԓайәԓ ӑӈкәрмаԓ йўпийән, кащаԓәсԓы, ԓўв тўмтака йиты кеша эвәԓты щир тӑйәԓ, ");
INSERT INTO kca_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","сыйәӈ тўрән йастәс: «Нӑӈена йастәԓәм Турәм Куща Иисус Христос нэм урәӈән: нӑӈ кўрӈиԓана тўӈа нŏх ԓойа». Щӑԓта ԓўв и щишән нŏх ԓойәмтәс пӑ шушиԓыты питәс. ");
INSERT INTO kca_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Мир пӑ, щит шийаԓәмаԓ кемән, мўй Павел верәс, ԓўв тўр сыйәԓ сыйәӈа версәԓы, Ликаония йасәӈән пŏтәрман: «Ԓуӈхәт хŏйат хŏрасән мўӈ хŏщайэв иԓ эсԓәщсәт». ");
INSERT INTO kca_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Щӑԓта Варнава Зевса айәԓтса, Павел пӑ Ермийа айәԓтса, ԓўв йасәӈ хŏща кущайа ус. ");
INSERT INTO kca_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Вошеԓ йэԓпийән Зевс ԓух хот ус, пӑ ԓўвеԓа йир верты ху, пушас ова хор мисәт пӑ сэвәм хŏрамәӈ лыптәт тўвман, мир пиԓән йирасты ўтщийәс. ");
INSERT INTO kca_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Туп апостолӈән Варнава пӑ Павел, щит хуԓман кемән, ԓын сŏхԓән лакки мӑншисԓән пӑ, мир хŏща ӑратман, такан сыйәӈ тўрән пŏтәртсәӈән: ");
INSERT INTO kca_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Йох! Мўй нын верԓәты? Мин па – нын хŏрпан хŏйатӈән, пӑ нынана Йӑм Айкеԓ пŏтәртԓәмән, нын тӑм йурԓы ԓуӈхәт эԓты Ԓыԓәӈ Турәм пеԓа ат керԓәсты, Хŏй турәм хӑр пӑ мўв, пӑ щарәс, пӑ хŏԓ щит, мўй ԓыпиԓаԓән уԓ тыйәԓтәс, ");
INSERT INTO kca_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Хŏй хӑщәм ишән мирәта иса ԓыв йушԓаԓән йӑхты эсԓыйәс, ");
INSERT INTO kca_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ԓўв эԓтайәԓ йӑм верәтән айкеԓ мӑты щикуш ӑт вŏԓыԓыйәс, турәм хӑр эԓты мўӈева йэрт пӑ ԓэвмаӈ пŏра мийԓыман, щӑԓта ԓэтŏтән пӑ кашән мўӈ сӑмԓув вŏԓәтман, ус». ");
INSERT INTO kca_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Щиӈәԋща, щит пŏтәртман, ԓын ўрайән мир хŏща щимәщ нŏмәс такапсәтән: ԓынана йир ӑт ат версәт пӑ кашәӈ хŏйат йŏхи ат мӑнәс. Щи кўтән ԓын щита уԓман, хŏйатәт утәԓтәсӈән, ");
INSERT INTO kca_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Антиохия пӑ Икония эԓты тухәԓ иудейәт йŏхәтсәт пӑ, хун апостолӈән хӑрщийа пŏтәртсәӈән, ԓыв мира ԓын эԓтан пўӈԓа мӑнты номәс такапсәт, пŏтәртман: «Ԓын нэмәԓтты тўӈа–щира йасәӈ ӑт пŏтәртԓәӈән, туп иса олмащиԓӈән». Щӑԓта, мир хущмеԓ йўпийән, Павел кевән щӑх йовәԓтса пӑ вош ким пелка таԓса, ԓўвеԓ пӑрәма нумәссэԓ, щишән. ");
INSERT INTO kca_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Хун пӑ утәԓтәты йохәт ԓўв пўӈԓәԓән ӑктәщсәт, ԓўв нŏх ԓойәс пӑ воша мӑнәс, кимет хӑтәԓән пӑ Варнава пиԓән Дервияйа мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Йӑм Айкеԓ тӑм вошән пŏтәртман пӑ йӑм арат утәԓтәты хŏйат Турәм Куща урәӈән мŏщатман йўпийән, ԓын йŏхԓы Листра, Икония пӑ Антиохия вошәт мŏхты мӑтсәӈән, ");
INSERT INTO kca_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","утәԓтәты йох сӑм такапман, эвәԓты щирән уԓты таӈман пӑ утәԓтәман, ар шук тўвман, мўӈева Турәм Хон Уԓәпсайа ԓŏӈты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Павел пӑ Варнава кашәӈ пойәкщәты хŏйатәт ӑктәщиты щир кеша уна уԓты йох пŏтсәӈән пӑ, вўщԓыман пойәкщәсӈән пӑ Турәм Кущайа мӑсԓән, Хойа ԓыв эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Йухәт, Писидия мŏхты мӑнман, Памфилияйа йŏхәтсәтән, ");
INSERT INTO kca_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","пӑ, Турәм Куща йасәӈ Пергияйән пŏтәртман йўпийән, Атталияйа охәԓсәӈән; ");
INSERT INTO kca_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Щиԓта пӑ Антиохияйа хопән мӑтсәӈән, хŏта Турәм йӑма щи вер пеԓа эвләптыман усайӈән, мўй тӑԓаӈа версәӈән. ");
INSERT INTO kca_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Щи йŏхәтман пӑ пойәкщәты мŏхет йӑха ӑкәтман йўпийән, ԓын хŏԓ иса пŏтәртсәԓән, мўй ԓын пиԓәнән Турәм верәс пӑ мўй щирән Ԓўв эвәԓты вер ов па рут мира пел пўшсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Пӑ щита утәԓтәты йохәт пиԓән йам арат сыс усӈән. ");
INSERT INTO kca_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Тухԓәт, Иудея эԓты йŏхтәм ŏтәт, хӑнам йох утәԓтәсәт: «Моисей щирән ӑт эвтәсԓәты ки, нŏх пайтәсты ӑт верәтԓәты». ");
INSERT INTO kca_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Хун пӑ нŏмәс ар щира пӑ мŏԓты кем ўра ворты вер ԓыв пиԓԓаԓән Павел пӑ Варнава хŏща тыйәс, Павела пӑ Варнавайа пӑ ԓыв кўтэԓ эԓты па тухәԓ йохәта Иерусалима мӑнты пŏтсайәт пӑ апостоләт пӑ уна уԓты икет пиԓән тӑм вер эԓты пŏтрэмәты. ");
INSERT INTO kca_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Щиӈәԋща, пойәкщәты мŏхэтән мӑнты ԋотәм йўпийән, ԓыв Финикия пӑ Самария мŏхты мӑтсәт, па рут мир Турәм пеԓа керԓәты вер эԓты пŏтәртман, пӑ хŏԓ хӑнам йох хŏща ун амәт версәт. ");
INSERT INTO kca_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Иерусалима йŏхәтмеԓ кемән, ԓыв пойәкщәты мŏхетән, апостоләтән пӑ ун икетән вана ўсайәт, пӑ Павел пӑ Варнава такан иса хŏԓыйэ йастәсԓән, Турәм мўй ԓын пиԓанән верәс пӑ хŏты па рут йоха эвәԓты вер ов пел пўншәс. ");
INSERT INTO kca_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Щиӈәԋща тухәԓ фарисейәт эԓты эвԓәм мŏхет ўшмащты питсәт пӑ пŏтәртсәт, па рут йох эвтәптәты пӑ Моисей закон нŏх катәԓты партты мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Апостоләт пӑ ун икет щи вер ватты урәӈән ӑктәщсәт. ");
INSERT INTO kca_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Хув нумәсмеԓ йўпийән Петра, нŏх ԓойман, ԓывиԓаԓа йастәс: «Хӑнам йох! Нын уйәтԓәты, Турәм оԓәӈ хӑтԓәт эԓты мўӈ эԓтэв мӑнэм пирысԓы, ма ўӈԓэм эԓты па рут мир Йӑм Айкеԓ йасәӈ ат хуԓсәт пӑ ат эвәԓсәт; ");
INSERT INTO kca_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","пӑ Сӑм Уйәтты Турәм ԓывиԓаԓа ныты пос мӑс, ԓывиԓаԓа Йэмәӈ Ԓыԓ мўӈ итэва мойԓәс. ");
INSERT INTO kca_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Щӑԓта мўӈ пӑ ԓыв кўтэԓа нэмәԓтты кӑт сыра вантәсты щир ӑт пŏнәс, эвәԓты верән ԓыв сӑмԓаԓ сыстапсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Мўйа пӑ нын ин Турәм хўщԓәԓән, утәԓтәты хŏйатәт сапԓа ԓавәрт пŏнман, мўй ӑнта мўӈ ащиԓув, ӑнта мўӈ туты ӑт верәтсэв? ");
INSERT INTO kca_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Туп мўӈ эвәԓԓув, Турәм Куща Иисус Христос мӑты йӑмән, ԓыв итэԓән, нŏх пайәтԓайув». ");
INSERT INTO kca_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Щи йўпийән ӑктәщәм мŏхет хŏԓ мӑшйайа йисәт пӑ Варнава пӑ Павел хуԓәтсәт. Ԓын пŏтәртсәтән, мўй хŏрпи йэмәӈ посәт пӑ вантыԓԓаӈәԓ верәт Турәм ԓын мŏхтан па рут мир кўтән верәс. ");
INSERT INTO kca_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Щи йўпийән, хун ԓын мӑшйайа йистән, Иаков пŏтәр ўс пӑ йастәс: «Хӑнам йох! Мӑнэм хуԓәнтаты. ");
INSERT INTO kca_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Симон аԉиԓысԓы, хŏты Турәм оԓәӈән па рут мир пеԓа ӑӈкәрмәс, щитԓаԓ эԓты Ԓўв нэмәԓ урәӈән мир ӑкәтты. ");
INSERT INTO kca_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Тӑм эԓты Турәм айкеԓ туты хŏйатәт ищи пŏтәртысәт, хŏты хӑшман уԓԓа: ");
INSERT INTO kca_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Йухәт йŏхәтԓәм пӑ Давид иԓ питәм хот нŏх верԓэм, пӑ щита мўй шўкатман уԓԓа, нŏх верԓэм пӑ ԓўвеԓ па йӑԓпа ԓэщатԓэм, ");
INSERT INTO kca_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","па хŏйатәт пӑ хŏԓ мирәт Турәм Куща ат кӑшсәт, хŏйтат кўтән Ма нэмем йастәԓа. Щиты Турәм Куща, тӑм мўй иса верты Ŏт, пŏтәртәԓ'. ");
INSERT INTO kca_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Турма хŏԓ Ԓўв верԓаԓ йис эԓты ԓэрәт. ");
INSERT INTO kca_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Щишән ма нумәстэмән па рут мир эԓты Турәм пеԓа керԓәты ŏтәт уԓәпсайэԓ ԓавәрта верты ӑт мосәԓ, ");
INSERT INTO kca_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ԓывиԓаԓа хӑшты мосәԓ, ԓыв ԓуӈхәтән шӑкатәм ԓэтŏт эԓты, пакрасԓәты вер эԓты, шакәптәм вой ԋŏхи пӑ ўр эԓты йŏхи ат ԓавԓәссәт, пӑ па хŏйатәта щит ӑт ат версәт, мўй ԓывиԓаԓа ӑт ԓӑӈхасәт. ");
INSERT INTO kca_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Моисей закон йис тэԓән вошәтән иса пŏтәртԓа пӑ кашәӈ шаббат хӑтәԓән иудейәт пойәкщәты хотәтән ԓўӈәтԓа». ");
INSERT INTO kca_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Щиӈәԋща апостоләт пӑ ун икет аратәԓ пойәкщәты хŏйатԓаԓ пиԓән, ԓыв кўтԓаԓ эԓты йох пирыман, Антиохияйа Павел пӑ Варнава пиԓән китты нŏмәс версәт, щи мŏхет: Варсавайа айәԓтты Иуда, пӑ Сила, хӑнам йох кўтән кущайа уԓты кӑтӈән. ");
INSERT INTO kca_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ԓыв пиԓԓаԓән щимәщ хӑншәм айкеԓ мӑсәт: «Апостоләт пӑ ун икет пӑ хӑнам йохәт Антиохияйән, Сирияйән пӑ Киликияйән уԓты па рут мир эԓты уԓты хӑнам йохәта: ўща уԓаты. ");
INSERT INTO kca_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Мўӈ хуԓтмәсэв, мӑтты тухәԓ, мўӈ эԓтэв ким этәм ŏтәт, ԓыв пŏтәрԓаԓән нынан ԓыԓәтсәԓаԓ пӑ нын сӑмԓән йэша мӑнәԓтсәԓаԓ, пŏтәртман, мӑтты эвтәсты мосәԓ пӑ закон хўват уԓты мосәԓ. Щит мўӈ ԓывиԓаԓа ӑт партыԓысув, ");
INSERT INTO kca_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","мўӈ, йӑха актәщман, йох пирыман, сӑмԓува мосты мўӈ Варнавайэв пӑ Павелэв пиԓән нын хŏщайән китты и нŏмәсән артаԓәсэв, ");
INSERT INTO kca_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ԓын мўӈ Турәм Кущайэв Иисус Христос нэм урәӈән сӑмԓән мийәм хŏйатӈән. ");
INSERT INTO kca_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Щиӈәԋща, мўӈ Иуда пӑ Сила китсув, нынана ԓын йасәӈән щит па ԓэра верԓәԓән. ");
INSERT INTO kca_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Йэмәӈ Ԓыԓ пӑ мўӈ тӑм мосты вер тўмпийән нынан нэмәԓтты па вер верты ӑт мӑԓув: ");
INSERT INTO kca_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ԓух йир, пӑ ўр, пӑ шакәптәм ԋŏхи, пӑ пакрасԓәты эԓты йŏхи ԓавԓәсты, пӑ па хŏйатәта щит ӑт верты, мўй нынана ӑт ԓӑӈхаԓты. Тӑм эԓт тӑйман, йӑма верԓәты. Тўмтака уԓаты». ");
INSERT INTO kca_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Щӑԓта, китәм ŏтәт Антиохияйа йŏхәтсәт пӑ, хŏйатәт ӑкәтмеԓ кемән, хӑншәм нэпек мӑсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ԓыв пӑ, ԓўӈәтмеԓ кемән, щи утәԓтәпса эԓты нŏх амәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Иуда пӑ Сила, Турәм айкеԓ туты хŏйатӈәна уԓман, хӑнам йоха йӑм арат йасәӈ утәԓтәты щира йастәсӈән пӑ ԓывиԓаԓ такапсәԓән. ");
INSERT INTO kca_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Мŏԓкем щита уԓман йўпийән, ԓын хӑнам йохән апостоләт хŏща йӑм нŏмәсән эсәԓсайӈән. ");
INSERT INTO kca_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Туп Сила щита хӑщты нŏмәсән йŏхәтса. Иуда пӑ Иерусалима йŏхԓы йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Павел пӑ щӑԓта Варнава Антиохияйән усӈән. Щита ԓын утәԓтәсӈән пӑ Турәм Куща йасәӈ Йӑм Айкеԓа па мŏхет пиԓән тутԓысӈән. ");
INSERT INTO kca_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Мŏԓты кем пŏра хӑщмаԓ йўпийән Павел Варнавайа йастәс: «Па мӑнԓәмән, мин хӑнам йохԓәмән хŏща йӑхԓәмән, кашәӈ вошән, хŏта мин Турәм Куща йасәӈ тутԓысмән, ватԓэмән, хŏты ԓыв уԓԓәт». ");
INSERT INTO kca_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Варнава, Марка айәԓты, Иоанн пӑтән ўты ўтщисԓы. ");
INSERT INTO kca_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Туп Павел щит пӑтән ўты ӑт ԓӑӈхас, хŏй Памфилияйән ԓынан хӑйсәԓы пӑ ԓынана мийәм вер тӑԓаӈа верты ӑт ԋотәс. ");
INSERT INTO kca_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Тӑм эԓты нŏпса ӑт ԓэщаԓәты вер тыйәс, щишән ԓын кўтанән кӑтна мӑтсәӈән; щӑԓта Варнава, Марк ўйман, Кипр пеԓа нык хўвԓәс; ");
INSERT INTO kca_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Павел пӑ, ԓўвеԓа Сила пирымаԓ йўпийән, хӑнам йохәтән Турәм йӑма эвԓәптыман, мӑнәс, ");
INSERT INTO kca_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","пӑ Сирия пӑ Киликия сӑхат, пойәкщәты мир такапман, йӑӈхәс. ");
INSERT INTO kca_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ԓўв Дервия пӑ Листра вошӈән унты йŏхтәс. Пӑ щита и мŏԓты утәԓтыты ху ус, нэмәԓән Тимофей. Ԓўв аԋԏэԓ эвԓәм иудей нэ, ащеԓ пӑ – грек ху, ");
INSERT INTO kca_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","пӑ ԓўв эԓтэԓ Листрайән пӑ Иконияйән уԓәм хӑнам йох йӑма йастыԓысәт. ");
INSERT INTO kca_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Павел ԓўвеԓ пӑтән ўты нŏмәс верәс; пӑ, ўймаԓ кемән, щи тӑхайәтән уԓәм иудейәт урәӈән, эвәтты верән версәԓы; ԓўв ащеԓ грека уԓты вер хŏԓыйэ хŏйатәтән уйәтса, щишән. ");
INSERT INTO kca_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Вошәт сӑхат мӑнман, ԓыв эвәԓты мŏхет апостоләтән пӑ ун икетән Иерусалимән ԓэщатәм мŏрт щирәт хўват уԓты партсәт. ");
INSERT INTO kca_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Пӑ пойәкщәты актәщәм мŏхет кашәӈ тӑхайән эвәԓты верән такамтыԓәт пӑ кашәӈ хӑтәԓ арамәԓәт. ");
INSERT INTO kca_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Фригия пӑ Галатия мўв сӑхат мӑнман, Йэмәӈ Ԓыԓән Асия мўвән ԓыв Йӑм айкеԓ туты ӑт эсәԓсайәт. ");
INSERT INTO kca_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Мисия мўв унты йŏхәтмеԓ йўпийән, Вифиния мўва мӑнты ўтщиԓысәт; туп Йэмәӈ Ԓыԓ ԓывиԓаԓ тŏхи ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Мисия хӑйман, пӑ ԓыв Троада воша охәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Щӑԓта атәԓән Павела ватты щир ус: и мŏԓтты ху, Македония мўвәӈ ху, этәс. Ԓўв ԓойәс пӑ ԓўвеԓ вохԓәԓы: «Македонияйа йŏхта пӑ мўӈева ԋоты». ");
INSERT INTO kca_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Щи вантәпса йўпийән ищи пўԉаӈ мўӈ Македонияйа мӑнты нŏмәс версув, нумәсман, Турәм Куща мўӈев щита Йӑм Айкеԓ тутԓыты вохсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Щиӈәԋща, Троада вош эԓты нык хўвԓәмеԓ йўпийән, мўӈ тŏрԓы Самофракия пухәр мўва йŏхәтсув, кимет хӑтәԓ пӑ Неаполь воша, ");
INSERT INTO kca_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","щиԓта пӑ Филлиппы воша йŏхәтсув: Македония мўв щуӈән мет оԓәӈ вош, Рим пеԓа питәм вош. Тӑм вошән мўӈ кӑмәтса хӑтәԓ усув. ");
INSERT INTO kca_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Шаббат хӑтәԓән пӑ мўӈ вош шӑнша йŏхан пеԓа этсув, хŏта, уԓтыйән, пойәкщәты тӑха ус, пӑ, иԓ омәсман, щита ӑктәщәм имет пиԓән пŏтәртсув. ");
INSERT INTO kca_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ԓыв кўтэԓән Фиатир вош эԓты Лидия нэмпи и нэ ус, ԓўв тынәӈ питы ўрты щӑшканәт тыныйәс. Лидия Турәм пеԓа сӑмәӈа ус, пӑ Павел мўй пŏтәртәс, Турәм Кущайән ԓўв сӑмәԓ щи пеԓа пел пўшса. ");
INSERT INTO kca_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Хун пӑ ԓўв йиӈка ԓŏӈәԓтыса пӑ ԓўв йŏԓән уԓты мŏхиԓаԓ па, мўӈев ԓўв хŏщайәԓ вохсәԓы, пŏтәртман: «Нын мӑнэм Турәм Куща пеԓа тŏрԓы уԓты верэм йӑнайа ԓўӈәтсәԓԓән ки, ма хотэма ԓŏӈаты пӑ ма хŏщайэм уԓаты». Пӑ мўӈев эвԓәптәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Щиты ус, хун мўӈ пойәкщәты тӑхайа мӑнмевән, и митнэ пиԓән уйтатсув, ԓўв кўԉ сŏхән катәԓман уса, аԉисыты щирәԓ хўват ԓўв кущайԓаԓа ар ŏх йŏхтәптыйәс. ");
INSERT INTO kca_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Павел йўпийән пӑ мўӈ йўпевән шушман, ԓўв ўвәс, пŏтәртман: «Тӑм хŏйатәт – Нўм Турма рупитты йохәт, мўӈева нŏх пайтәсты йуш аԉԓәт». ");
INSERT INTO kca_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Щиты ԓўв ар хӑтәԓ верыԓыйәс. Павел, ԉикащман, кўԉ сŏх пеԓа карэмәс пӑ йастәс: «Иисус Христос нэмән нӑӈен ԓўв ԓыпеԓ эԓты ким этты партԓэм». Пӑ атәм ԓыԓ ищи кумат ким этәс. ");
INSERT INTO kca_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Щиӈәԋща ԓўв кущайԓаԓ, ваттэԓән, ԓыв ŏх йиты тӑхайэԓ хŏԓас, Павел пӑ Сила ԋӑрэмәсайӈән пӑ мир кущайәт хŏща вош хӑрыйа хŏрӈәԓтсайӈән. ");
INSERT INTO kca_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Щӑԓта, ԓынан рим кущайӈән хŏща тўвман, йастәсәт: «Тӑм хŏйатӈән, иудейәта уԓман, мўӈ вошев уԓәпса ԓыԓԓәты щир этәԓтәԓтән ");
INSERT INTO kca_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","пӑ щимәщ щирәт эԓты пŏтәртԓәтән, мўй мўӈева, Рим хŏйатәта, вана ўты пӑ верты ӑт мосәԓ». ");
INSERT INTO kca_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Мир ищиты ԓын пеԓайән эԓԓәс, рим кущайӈән пӑ ԓын эԓтайән сŏхԓән хŏԓт мӑшман йўпийән, ԓынан йўхән сэкты партсәԓән ");
INSERT INTO kca_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","пӑ ԓын, артан йўхән кўтәртыйәмӈән йўпийән, касна хота вŏщкисайӈән, касна хот шавиты хŏйата такан шавиты партсайӈән. ");
INSERT INTO kca_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Щимәщ партәпса йоша павәтмаԓ йўпийән, ԓўв ԓынан ԓыпи касна хот йӑта вŏщкәсԓы пӑ ԓын кўрԓән йўх сэсыйа сэксәԓы. ");
INSERT INTO kca_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ат кўтәп кемән Павел пӑ Сила, пойәкщәман, Турәм, арыман, ишәксәԓән; касна хота питәм ŏтәт пӑ ԓынан хуԓәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Шӑмкап мўв такан тӑриты питәс, щиӈәԋща касна хот пӑты ԋŏхԓәс; и щишән овәт хŏԓыйэ пелки пўншатсәт, пӑ хŏԓыйэ хŏйатәт хŏща сэсэт лыԋа йисәт. ");
INSERT INTO kca_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Касна хот шавиты хŏйат пӑ, нŏх верԓәмаԓән, касна хот овәт пелки пуншәм шийаԓәмаԓ кемән, аԓты кешеԓ ким лакемәсԓы пӑ ԓўвеԓ ԓўв пӑратты ўтщисԓы, ԓўв нумәсәԓ, опсәм хŏйатәт хŏнтасәт. ");
INSERT INTO kca_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Туп Павел сыйәӈ тўрән такан йастәс, пŏтәртман: «Нӑӈена нэмәԓтты атәм аԓ вера, мўӈ хŏԓ тӑта уԓԓув». ");
INSERT INTO kca_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ԓўв тўт такан вохәс, касна хот ԓыпийа хухәԓмәс пӑ тӑриман Павел пӑ Сила хŏща керәптыйәс, ");
INSERT INTO kca_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","пӑ, ԓынан ким этәԓтәман, йастәс: «Ма кущайӈәԓам! Мўй мӑнэм верты мосәԓ, нŏх пайтәсты урәӈән?» ");
INSERT INTO kca_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ԓын пӑ йастәсӈән: «Турәм Куща Иисус Христоса эвԓа, пӑ нӑӈ нŏх пайәтԓайән, нӑӈ хот тэԓэн па». ");
INSERT INTO kca_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Щӑԓта Турәм Куща йасәӈ ԓўвеԓа пӑ хŏԓ, ԓўв хотәԓән уԓәм ŏтәта, пŏтәртса. ");
INSERT INTO kca_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Пӑ ԓўв, ԓынан атәԓән ўймаԓ кемән, ԓын ԋўләмԓән нŏх ԉŏхәтсәԓы пӑ ищи мŏхты ԓўв йиӈка ԓŏӈәԓтыса пӑ ԓўв хотәӈ мŏхиԓаԓ па. ");
INSERT INTO kca_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Щӑԓта, ԓынан йŏхи хотәԓа тўвмаԓ йўпийән, ԓэты пӑсана вохсәԓы пӑ хŏт тэԓәԓ пиԓән амтәс, Турма эвәԓмаԓ урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Хун пӑ хӑтԓа йис, рим кущайӈән вошәӈ мит йохӈән йастәты китсәтән: «Щи хŏйатӈән эсԓаԓән». ");
INSERT INTO kca_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Касна хот шавиты хŏйат щит эԓты Павела такан йастәс: «Рим кущайӈән нынан эсәԓты партсәтән; щиӈәԋща, ин ким этатән пӑ йӑм нŏмәсән мӑнатән». ");
INSERT INTO kca_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Туп Павел ԓын пеԓайәна йастәс: «Минэмән, Рим хŏйатӈән, сўт такԓы хŏԓ мир сурән сэксәԓән пӑ касна хота вŏщкәсԓән, ин пӑ хӑԋайән эсәԓԓаймән? Ӑнта, ты ат йŏхәтԓәтән пӑ минэмән ԓын ким ат этәԓтәԓԓән». ");
INSERT INTO kca_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Вошәӈ мит йохӈән щи йасӈәт рим кущайӈәна йастәсԓән, пӑ щитӈән, Рим йŏха уԓты вер хуԓман кемән, хŏԓт пӑԓтәмәсӈән. ");
INSERT INTO kca_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Щӑԓта, щи йŏхәтсәтән, ԓын пеԓайән пойкащсәтән пӑ, ким этәԓтәман йўпийән, вош эԓты ким мӑнты партсәԓән. ");
INSERT INTO kca_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ԓын пӑ, касна хот эԓты ким этман йўпийән, Лидия хŏща йŏхәтсәӈән пӑ, хӑнам йохԓән шийаԓәман кемән, ԓывиԓаԓ утәԓтәсԓән, пӑ йэԓԓы мӑтсәӈән. ");
INSERT INTO kca_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Амфиполь пӑ Аполлония мŏхты мӑнман, ԓын Фессалоника воша йŏхәтсәтән, хŏта иудейәт пойәкщәты хот ус. ");
INSERT INTO kca_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Павел, ԓўв уԓԓытаԓ щирәԓән, ԓыв хŏщайэԓа ԓŏӈәс пӑ хуԓәм шаббат хӑтәԓ и йўпийән Йэмәӈ Нэпек эԓты ԓыв пиԓԓаԓән пŏтәртәс, ");
INSERT INTO kca_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ԓывиԓаԓа аԉиԓыман пӑ тŏрԓы йастәман, Христоса сŏрма питты пӑ нŏх ԓыԓәӈԓәты мосәс, пӑ йастәс: «Тӑм Христос - щит Иисус, Хŏй эԓты ма нынана пŏтәртԓәм». ");
INSERT INTO kca_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Щӑԓта ԓыв эԓтыԓаԓ тухәԓԓаԓ эвәԓсәт пӑ Павел пӑ Сила пеԓа пайтәссәт, хŏты грекәт эԓты, Турәм пеԓа сӑмәӈ хŏйат щи арат ар, и щиты пӑ ԓӑтәӈа уԓты нэӈәт эԓты йӑм арат. ");
INSERT INTO kca_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Туп ӑт эвԓәм иудейәт, шек нŏмәсән ԉикащман пӑ вош хӑри эԓты тухәԓ ӑт рӑхты хŏйатәт ўйман, похла ӑктәщсәт пӑ вош нŏх ԋŏхаԓтты питсэԓ пӑ, Иасон хот ԉэпа ӑратмеԓ кемән, ԓынан, мир хŏща ким туты урәӈән, кӑшсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ԓынан ӑт уйәтмеԓ йўпийән, ԓыв Иасон пӑ па эвәԓты хӑнам йох вош кущайәт хŏща хипԉәԓтсәԓаԓ, ўвман: «Тӑм мўв ԓŏватән уԓәпса шўкатты ŏтәт ты па йŏхәтсәт, ");
INSERT INTO kca_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Иасон пӑ ԓывиԓаԓ вана ўсԓы, пӑ хŏԓыйэ ԓыв, па Ŏт, Иисус, хона тӑйман, кесарь партты щира ӑт уԓԓәт». ");
INSERT INTO kca_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Щиӈәԋща щит хуԓәм мир пӑ вошәӈ кущайәт хурэпа пайәтсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Туп тӑмет, Иасон пӑ па ŏтәт эԓты тын ўйман, ԓывиԓаԓ эсәԓсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Хӑнам йохәт пӑ ищи мŏхты атәԓән Павел пӑ Сила Верия воша китсэԓ, хŏԓта ԓын йŏхәтман кемән, иудейәт пойәкщәты хота мӑтсәӈән. ");
INSERT INTO kca_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Тӑта уԓты ŏтәт Фессалоника мŏхет эԓты йӑм нŏпсәӈшәкәт: ԓыв йасәӈ хŏԓ сӑмәӈа вана ўсэԓ, кашәӈ хӑтәԓ Йэмәӈ Нэпек ԓэрапман, тӑми а мўй тŏрԓы щиты. ");
INSERT INTO kca_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Щӑԓта ԓыв эԓтыԓаԓ ар хŏйат эвԓәс, пӑ грек ԓӑтәӈ нэӈәт эԓты пӑ йох эԓты йӑм арат. ");
INSERT INTO kca_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Туп хун Фессалоника иудейәт мŏштәсэԓ, Верия хŏща па Павелән Турәм йасәӈ туса, ԓыв щи па йŏхәтсәт пӑ мир нŏх кўрәтты пӑ нŏх ԋŏхаԓты питсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Щишән хӑнам йох ищи мŏхты Павел китсэԓ, щарәс пеԓа шушты щира; Сила пӑ Тимофей щи вошән хӑщсәтән. ");
INSERT INTO kca_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Павела мӑнты ԋотәм ŏтәт ԓўвеԓ Афины вош унты ԋŏтсэԓ. Ԓыв, Силайа пӑ Тимофейа мийәм партәпса йоша павәтмеԓ кемән, мӑтты ԓын сорашәк ԓўв хŏщайәԓ ат йŏхәтсәӈән, йŏхԓы мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Павел мӑнты пиԓӈәԓаԓ ԓавәԓтаԓ эԓты Афины вош хуват шушиԓыйәс пӑ, тӑм вош тэԓыйэ ԓух тӑйтаԓ урәӈән, ԓўв нŏпсәԓ ўшмащәс. ");
INSERT INTO kca_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Щиӈәԋща, ԓўв иудейәт пойәкщәты хотән иудейәт пиԓән пӑ Турәм сӑмәӈа тӑйты грек йох пиԓән, пӑ кашәӈ хӑтәԓ вош хӑрийән уйтантыԓыты хŏйатәт пиԓән нумәссәс. ");
INSERT INTO kca_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ԓўв пиԓәԓән тухәԓ эпикур пӑ стоик ашкуԓайәт эԓты уԓты нŏпсәӈ йох пŏтрэмәты питыԓысәт. Итԓаԓ иԋщәссәт: «Мўй пӑ щи авашты ŏт йастәты ԓӑӈхаԓ?», па ŏтәт пӑ: «Иԓампа, ԓўв па мўв хŏйатәт ԓуӈхәт эԓты утәԓтәԓ», ԓўв ԓывиԓаԓа Иисус пӑ нŏх ԓыԓәӈԓәты вер эԓты Йӑм Айкеԓ тус, щишән. ");
INSERT INTO kca_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Щӑԓта, ԓўвеԓ пӑтән ўйман, Ареопаг нэмпи тӑхайа тусэԓ пӑ йастәԓәт: «Мўӈ а мўй верәтԓэв уйәтты, мўй щит щимәщ йӑԓәп утәԓтәпса, мўй эԓты нӑӈ пŏтәртсән? ");
INSERT INTO kca_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Нӑӈ мŏԓты ŏшԓы-уйтԓы ŏт мўӈ паԓԓува хуԓмәԓтԓән. Щишән мўӈ уйәтты ԓӑӈхаԓув, мўй щит?» ");
INSERT INTO kca_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Афины мŏхет пӑ хŏԓ пӑ ԓўв хŏщайэԓ уԓты па мўв хŏйатәт нэмәԓты щирән пŏрайэԓ ӑт хӑщәптыԓысәт, туп щиты, мŏԓты йӑԓәп вер эԓты ат хуԓәтса пӑ ат пŏтәртса. ");
INSERT INTO kca_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Щӑԓта, Павел Ареопаг кўтпа ԓойман, йастәс: «Афины хŏйатәт! Ма иса ваттэмән, нын ԓўӈхәт эԓты нумәсты вер шек такан тӑйԓәԓән. ");
INSERT INTO kca_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Нын йэмәӈ лотԓән вантыман йӑхман, ма и йирасты лот уйәтсәм, хŏта хӑшман уса: 'Ӑт уйәтты Турма'. Тӑман-щи, Хŏйтан нын, ӑт уйәтман, такан нумԓәԓән, ма нынана такан айәԓԓэм. ");
INSERT INTO kca_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Турәм, уԓты-омәсты мир тыйәԓтәм Ŏт, Ԓўв, опәԉән пӑ мўвән Турәм Кущайа уԓман, ӑнта йошән верәм хотәтән уԓ ");
INSERT INTO kca_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","пӑ хŏйат йошән верты верәт ӑт вохәԓ, ищи мӑтты Ԓўвеԓ мŏԓты мосәԓ, Ԓўв кашәӈ ŏта уԓәпса пӑ ԓыԓ, пӑ мўй иса мӑԓ. ");
INSERT INTO kca_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","И кӑԓы эԓты Ԓўв аратәԓ хŏйат рут тыйәԓтәс, иса мўв ԓŏватән уԓты урәӈән, хŏта Ԓўв хŏԓ хŏйат рутәта мŏрт пŏра пӑ мŏрт уԓты тӑха ԓэщатәс. ");
INSERT INTO kca_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ԓыв Турәм ат кӑшсәт, Ԓўв уԓты щащәԓ ат мŏштәсәт пӑ Ԓўвеԓ ат уйәтсэԓ - щи кўш Ԓўв кашәӈ ŏтԓув пўӈәԓән ванән уԓ, ");
INSERT INTO kca_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","щиты ӑт уԓ, мўӈ Ԓўвеԓән уԓԓув пӑ ԋŏхаԓув, хŏты тухәԓ нын арәт верты мŏхиԓән пŏтәртысәт: 'Мўӈ Ԓўв пиԓәԓән и рут'. ");
INSERT INTO kca_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Щиӈәԋща, Турәм рута уԓман, мўӈев щиты нумәсты ӑт мосәԓ, мӑтты Турәм сорԋи, мўй пӑ щелŏх, мўй пӑ хŏйат нŏмәс хўват хŏрасән верәм кев хŏрпи. ");
INSERT INTO kca_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Щиӈәԋща, Турәм йӑна вер ӑт уйтәм пŏра хӑйман, Турәм ин хŏйатәта хŏԓ кашәӈ тӑхайән кӑрэк эԓты шӑнша керԓәты партәԓ, ");
INSERT INTO kca_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ԓўв хӑтәԓ ԓэщатәс, щишән, хун уԓты-омәсты турәм вещката сўтәтты питԓәԓы, Ԓўв щи кеша пŏнәм Хŏйатәԓ сӑхат, пӑрәм эԓты Ԓўвеԓ нŏх ԓыԓӈатман, мира иса, уйәтты урәӈән, ваттәԓтәсԓы». ");
INSERT INTO kca_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Пӑрәм эԓты нŏх ԓыԓӈатәм вер хуԓмеԓ кемән, итԓаԓ ӑԓ хўләщсәт, киметԓаԓ пӑ йастәсәт: «Тӑм эԓты нӑӈен па ишән хуԓәтԓэв». ");
INSERT INTO kca_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Щиӈәԋща, Павел ԓыв эԓтыԓаԓ мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Тухәԓ йох пӑ, ԓўв хŏщайәԓа рӑхәԓтысәт пӑ эвәԓсәт; ԓыв кўтэԓән Дионисий Ареопаг ху, Дамарь нэмпи нэ пӑ ԓыв пиԓԓаԓән па мŏхет усәт. ");
INSERT INTO kca_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Тӑм йўпийән Павел, Афины вош хӑймаԓ йупийән, Коринф воша йŏхтәс; ");
INSERT INTO kca_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Щита ԓўв и иудей ху уйтәс, нэмәԓән Акила, Понт мўв эԓты уԓты ху. Акила тӑм ванән Италия эԓты Прискилла имеԓ пиԓән йŏхтәс, - Клавдий нэмпи кесарь иудейәта хŏԓ Рим эԓты мӑнты партсәԓы, - пӑ Павел ԓын хŏщайән йŏхтәс; ");
INSERT INTO kca_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ԓын и хŏрпи верты ŏт тӑйсәӈән: ԓын пирщин хотәт ԓэщатсәӈән, пӑ щишән Павел ԓын пиԓанән рупитты хӑщәс. ");
INSERT INTO kca_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Кашәӈ шаббат хӑтәԓән ԓўв иудейәт пойәкщәты хотән иудейәт пӑ грекәт пиԓән пŏтәртәс пӑ ԓывиԓаԓ таӈиԓысԓы. ");
INSERT INTO kca_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Хун пӑ Македония эԓты Сила пӑ Тимофей йŏхәтсәӈән, Павел иудейәта пŏтәртты ԓыԓәԓән иԉапса, мӑтты Иисус - щит Христос. ");
INSERT INTO kca_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Хун пӑ ԓыв ԓўвеԓ йэртԓыты пӑ ԓўвеԓа атма йастәты питсәт, ԓўв ԓумтәмԓаԓ иԓ пӑркатмаԓ кемән, ԓывиԓаԓа йастәс: «Нын кӑԓыԓән нын ŏх пӑтԓәнән; ма сыстам; тӑԓта йэԓԓы па рут мир хŏща мӑнԓәм». ");
INSERT INTO kca_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Павел иудейәт пойәкщәты хот эԓты ким этәс пӑ ванән уԓты хота ԓŏӈәс, хŏта Иуст нэмпи ху, Турәм пеԓа сӑмәӈ ŏт, ус. ");
INSERT INTO kca_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","иудейәт пойәкщәты хот куща Крисп пӑ хŏԓ ԓўв йŏԓән тӑйты мŏхиԓаԓ пиԓән Турәм Кущайа эвԓәс, пӑ Коринф мŏхәт эԓты ар хŏйат, хуԓәтман, эвәԓсәт пӑ йиӈка ԓŏӈәԓтыԓысайәт. ");
INSERT INTO kca_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Турәм Куща пӑ атәԓән Павел вантәпсайәԓ хŏща йастәс: «Аԓ пӑԓа, туп пŏтәрта пӑ шитама аԓ йўва, ");
INSERT INTO kca_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ма нӑӈ пиԓэнән уԓԓәм, пӑ нэмәԓты ŏт нӑӈена атәм ӑт верәԓ, Ма тӑм вошән ар хŏйат тӑйԓәм, щишән». ");
INSERT INTO kca_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Пӑ ԓўв щита, ԓывиԓаԓ Турәм йасӈа утәԓтыман, тӑԓ-ԓўӈ пӑ хут тыԓәщ арата хӑщиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Щи кўтән, Ахаия мўвән Галлион проконсул уԓәм пŏрайән, иудейәт и нŏмәсән Павел йэщаԓт эԓԓәсәт пӑ сўт верты тӑхайа тусэԓ, ");
INSERT INTO kca_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","пŏтәрман, мӑтты ԓўв хŏйатәт, Турәм пеԓа сӑмәӈа уԓты, ӑнтом Закон щирән утәԓтәԓԓы. ");
INSERT INTO kca_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Хун пӑ Павел уӈԓәԓ пел пўшты ўтщисԓы, Галлион иудейәта йастәс: «Иудейәт! Мŏԓты атәм вер мўй пӑ ԓоԓмасты, веԓтатты вер верәс ки, ма ԓуԓән нынан хуԓәтты щир тӑйсәм, ");
INSERT INTO kca_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","туп хун утәԓтәты вер эԓты, пӑ нэмәт эԓты, пӑ нын законән эԓты ўра вортԓа, нын щирәнән артаԓыйаԓән; ма щита сўта уԓты ӑт ԓӑӈхаԓәм». ");
INSERT INTO kca_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Щӑԓта сўт верты тӑха эԓты ԓывиԓаԓ воштәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Грекәт хŏԓыйэ иудейәт пойәкщәты хот куща Сосфен ԋӑрэмәсэԓ пӑ ԓўвеԓ сўт верты хот йэԓпийән сэксэԓ; туп Галлион щит эԓты йэша нэш ӑт нумисыйәс. ");
INSERT INTO kca_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Павел йам арат хӑтәԓ Коринф вошән ус. Щи йўпийән ԓўв хӑнам йох пиԓән пайәм уԓәм верәс пӑ Акила пӑ Прискилла пиԓән Сирия мўва хŏпән мӑнәс. Мӑнтаԓ йэԓпийән Павел Кенхрей вошән ŏхәԓ ԓŏртсәԓы, Турма аԉәм вер тӑйәс, щишән. ");
INSERT INTO kca_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ефеса йŏхәтмеԓ йўпийән ԓынан щита хӑйсәԓы, ԓўв пӑ иудейәт пойәкщәты хота ԓŏӈәс пӑ иудейәт пиԓән нумәсман пŏтрэмәс. ");
INSERT INTO kca_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Хун пӑ ԓыв ўратсәт, ԓўв хўвшәк ԓыв хŏщайэԓ ат ус, ԓўв ӑт кашащәс, ");
INSERT INTO kca_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","туп ԓыв пиԓԓаԓән пайәмуԓәм верәс, йастәман: «Мӑнэм йиты йэмәӈ хӑтәԓән мет шопәӈ Иерусалимән уԓты мосәԓ; нын хŏщайән пӑ, Турма рӑхты ки питәԓ, па йŏхԓы йŏхәтԓәм». Щӑԓта Ефес вош эԓты хопән мӑнәс. Акила пӑ Прискилла Ефесән хӑщсәтән. ");
INSERT INTO kca_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Хоп эԓты Кесария воша ŏхәԓмаԓ йўпийән, ԓўв Иерусалима нŏх йŏхтәс, щита пойәкщәты ӑктәщиты мŏхет йӑм йасәӈән йастәсԓы пӑ Антиохия воша мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Щӑԓта щита мŏԓты кем сыс хӑйман, этәс, пӑ и оԓтман Галатия пӑ Фригия мўвӈән мŏхты мӑнәс, утәԓтәты йŏх такапман. ");
INSERT INTO kca_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","И мӑтты иудей, нэмәԓән Аполлос, Александрия вошәӈ ху, туса пŏтәртты пӑ Йэмеӈ Нэпек уйәтты ху, Ефеса йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ԓўв Турәм Куща Йуш пеԓа утәԓтәман ус пӑ шек такан пӑ эвәԓты щира пŏтәртәс, тўӈа-щира Турәм Куща эԓты утәԓтәс, кўш туп ԓўв Иоанн йиӈка ԓŏӈәԓтыйәпса уйтәс. ");
INSERT INTO kca_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ԓўв, ӑт пӑԓман, иудейәт пойәкщәты хотән пŏтәртты питәс. Ԓўвеԓ хуԓмаԓ кемән Акила пӑ Прискилла ԓўвеԓ вана ўсԓән пӑ тўӈашәк Турәм Куща Йуш ԓўвеԓа таӈсәԓән. ");
INSERT INTO kca_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Хун пӑ ԓўв Ахаия мўва мӑнты утщийәс, хӑнам йох щита уԓты утәԓтәты йохәта нэпек хӑшсәт, ԓыв ԓўвеԓ вана ўты партсэԓ; ԓўв тŏхи йŏхәтмаԓ йўпийән, ар ԋотәп щи хŏйатәта верәс, хŏй Турәм йӑм хўватән эвәԓман ус. ");
INSERT INTO kca_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ԓўв мир йэԓпийән иудейәт ԓомтәтԓыты вер шек эԓпа аԉиԓысԓы, Йэмәӈ Нэпек хўват этәԓтыман, мӑтты Иисус уԓ Христос. ");
INSERT INTO kca_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Аполлос Коринфән уԓмаԓ сыс, Павел нŏхԓы уԓты мўвәт мŏхты мӑнман, Ефеса йŏхтәс пӑ щита тухәԓ утәԓтәты йох уйәтмаԓ кемән, ");
INSERT INTO kca_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ԓывиԓаԓа йастәс: «Йэмәӈ Ԓыԓ нын, эвәԓман йўпийән, вана ўсԓән амўй?» Ԓыв пӑ ԓўвеԓа йастәсәт: «Мўӈ хŏԓна пӑ ӑт хуԓԓысэв, Йэмәӈ Ԓыԓ амўй щит». ");
INSERT INTO kca_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ԓўв ԓывиԓаԓа йастәс: «Мўй пеԓа нын йиӈка ԓŏӈәԓтысайты?» Ԓыв йŏхԓы йастәсәт: «Иоанн йиӈка ԓŏӈәԓтыйәпса пеԓа». ");
INSERT INTO kca_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Павел йастәс: «Иоанн йиӈка ԓŏӈәԓтыйәпса ус кӑрэк эԓты шӑшән керԓәты йиӈка ԓŏӈәԓтыйәпса, хŏйатәта пŏтәртман, ԓўв йўпеԓән Йиты Ŏта, Христоса Иисуса, ат эвәԓсәт». ");
INSERT INTO kca_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Щит хуԓмеԓ кемән, ԓыв Турәм Куща Иисус нэм урәӈән йиӈка ԓŏӈәԓтысайәт, ");
INSERT INTO kca_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","пӑ, хун Павел ԓыв ŏхпӑтԓаԓ эԓты йошӈиԓаԓ пŏтсәԓы, ԓыв эԓтыԓаԓа Йэмәӈ Ԓыԓ иԓ ŏхԓәс, пӑ ԓыв па йасӈәтән пŏтәрты пӑ Турәм эԓты айкеԓ туты питсәт. ");
INSERT INTO kca_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ԓыв аратэԓән кӑтхŏщйаӈ кем хŏйат ус. ");
INSERT INTO kca_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Иудейәт пойәкщәты хота йŏхәтмаԓән, ԓўв, ӑт хурыман, хуԓәм тыԓәщ утәԓтәс, Турәм Хон Уԓәпса эԓты пŏтрэмәман пӑ эвԓәптәман. ");
INSERT INTO kca_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Туп ԓыв эԓтыԓаԓ тухԓәт сӑмԓаԓ така версәԓаԓ пӑ эвәԓты ӑт ԓӑӈхасәт, Турәм Куща Йуш мир йэԓпийән ԉикәӈ йасәӈән йастәман. Щиӈәԋща Павел ԓывиԓаԓ хӑймаԓ кемән, утәԓтәты йŏх утща щира ӑкәтсәԓы пӑ и мŏԓты Тиранн ху утәԓтәты хотән кашәӈ хӑтәԓ хŏйатәт утәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Кӑт тӑԓ-ԓўӈ кем хўват щиты ус, Асия мўвән уԓты хŏйатәт, иудейәт мўй пӑ грекәт, Турәм Куща Иисус эԓты уԓты утәԓтәпса хŏԓыйэ хуԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Турәм пӑ Павел йош мŏхты мŏԓты арат вантыԓԓаӈәԓ вер верәс, ");
INSERT INTO kca_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","кӑшаӈ хŏйатәт ԓоӈԓа ԓўв тӑйты ŏхшамԓаԓ пӑ ӑнтәп сŏхԓаԓ пŏныԓысайәт пӑ ԓыв мушԓаԓ нŏх вŏԓысәт, пӑ ԓыв эԓтыԓаԓ кўԉ сŏхәт ким этсәт. ");
INSERT INTO kca_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Хŏԓна пӑ уԉԋайа йӑхты, йасәӈән кўԉ сŏх воштәты иудей йох эԓты, тухԓәт кўԉ сŏхәӈ хŏйатәт хŏща Турәм Куща Иисус нэм йастәты питсәт, пŏтәртман: «Нынан Иисус нэмән воштәԓэв, Хŏй эԓты Павел такан йастәԓ». ");
INSERT INTO kca_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Щит мӑтты мŏԓты Скева нэмпи, иудей Турма йир верты ŏх ики, ԓапәт пŏх версәт. ");
INSERT INTO kca_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Туп кўԉ сŏх йŏхԓы йастәс: «Иисус уйәтԓэм, пӑ Павел ищи мӑнэма ԓэр, нын пӑ хŏйтат?» ");
INSERT INTO kca_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Щӑԓта ԓыв хŏщайэԓа щи кўԉ сŏхәӈ хŏйат щи ԓŏват ун йурән ӑратәс пӑ ԓывиԓаԓ иԓ пайәтсәԓы, ԓыв ԋара питман пӑ ԋўлмәӈа йўвман, щи хŏт эԓты ким хŏнтасәт. ");
INSERT INTO kca_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Щит хŏԓ Ефесән уԓты иудейәта пӑ грекәта уйәтты щира питәс, пӑ хŏԓ ԓыв пӑԉщәмән йŏхәтсайәт, пӑ Турәм Куща Иисус нэм ԓӑтәӈа айәԓтты питсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Эвԓәм ŏтәт эԓты ар хŏйат йŏхтыԓыйәс, вещкат щирән верԓаԓ эԓпа аԉсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Мўтра верыԓыйәм мŏхет эԓты йӑм ар хŏйат, мўтра верты нэпекԓаԓ йӑха ӑкәтман, хŏйатәт йэԓпийән нŏх ўщәтсәԓаԓ, пӑ тынԓаԓ йӑха пŏтсәԓаԓ пӑ ветйаӈ щŏрәс щел ŏх арата хойәс. ");
INSERT INTO kca_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Щиты такан Турәм Куща йасәӈ лакки ԓӑрпиԓәс пӑ йурамәс. ");
INSERT INTO kca_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Хун пӑ щит йэтшәс, Павел, Ԓыԓән тўвман, Македония пӑ Ахаия мўв сӑхат Иерусалима мӑнты нŏмәс верәс, йастәс: «Щи йŏхтыԓытэм йўпийән, мӑ Рим ватты верэм уԓ». ");
INSERT INTO kca_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Щӑԓта, кӑт ԓўвеԓ ԋотты хŏйатӈәԓаԓ, Тимофей пӑ Ераст, Македония мўва китмаԓ йўпийән, ԓўв Асия мўвән мŏԓты сыс кема хӑщиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Щи пўԉаӈ Турәм Куща Йуш урәӈән ун йэшащты вер тыйәс, ");
INSERT INTO kca_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","и хŏйат, нэмәԓән Димитрий, щелŏх верән тус ху, щелŏх эԓты Артемида ԓух ими хŏрамәӈ хот хŏр верыԓыйәс пӑ вератты тус йохәта ŏх шитты щир мийиԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ԓывиԓаԓ пӑ па вератты йохәт йӑха ӑкәтман, йастәс: «Мŏхет! Нын уйәтԓәты, тӑм вератты вер эԓты мўӈ тӑйтаӈ щирэв уԓ; ");
INSERT INTO kca_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","щи кўтән нын ватԓәты пӑ хуԓԓәты, ӑнта туп Ефесән, иса хӑщ Асия ԓŏватән щи Павел ар хŏйат ԓўв эвԓәптәты верәԓән йŏвра хўщәс, пŏтәртман, мӑтты хŏйат йошән верты ŏт - щит ӑнта ԓуӈхәт. ");
INSERT INTO kca_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Щит пӑ мўӈева атәм верәԓ ӑнта туп вератты верэв атма айәԓтты щирән, Артемида ԓух ими йэмәӈ хот па нэмәԓтты йўкана ӑт тӑйты питԓа. Ԓух ими хŏԓна ԓўв Асия мўв ԓŏватән пӑ мирән иса ԓӑтәӈа тӑйԓа, ԓух ԓатәӈ верәԓ хŏԓт павәтԓа!» ");
INSERT INTO kca_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Щит хуԓәтмеԓ кемән, ԓыв ԉикән йŏхәтсайәт пӑ ўвты питсәт, пŏтәртман: «Ефес вош Артемида ԓӑтәӈ!» ");
INSERT INTO kca_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Щӑԓта вош ԓŏватәԓән нŏх ԋŏхԓәс. Ԓыв Павел пиԓән йӑӈхәм Македония кӑтӈән, Гаий пӑ Аристарх, ԋӑрэмәман, и йӑха каш ватты тӑхайа ԋŏхтәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Хун пӑ Павел мир хŏща этты ўтщийәс, утәԓтәты йохәтән ԓўв ӑт эсәԓса. ");
INSERT INTO kca_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","И щиты тухәԓ Асия кущайәт эԓты па, ԓўвеԓа ԓухса уԓман, ԓўв хŏщайәԓ айкеԓ китсәт, каш ватты тӑхайа ӑт ат йис. ");
INSERT INTO kca_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Щи кўтән итԓаԓ ит ўвԓәт, киметԓаԓ пӑ кимет ŏт ўвԓәт, пŏтәртты ӑктәщәм щир и нулама ус, пӑ ар пеләк йӑха ӑктәщәм ŏтәт ӑт уйәтԓәт, мўй урәӈән ӑктәщсәт. ");
INSERT INTO kca_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Иудейәт йастәм щирән, мир кўт эԓты Александр ким вохса. Йошән пос верман, Александр мир пеԓа пŏтәртты ўтщийәс. ");
INSERT INTO kca_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Хун ŏша пайәтсэԓ, ԓўв иудей ху, хŏԓ и турән ўваԓтсәт пӑ кӑт щос кем увсәт: «Ефес вош Артемида ԓӑтәӈ!» ");
INSERT INTO kca_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Вошәӈ хӑншатты куща пӑ, хŏйатәт иԓ роммәԓтмаԓ кемән, йастәс: «Ефес йох! Мӑты хŏйат ӑт уйәтәԓ, Ефес - щит ԓӑтәӈ ԓух ими Артемида пӑ турәм эԓты иԓ рӑкнәм хŏрәԓ шавиты вош? ");
INSERT INTO kca_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Щит хŏща ўра ворты вер ӑнтом ки, нынан рома уԓты мосәԓ пӑ, ӑт нумәсман, вер верты ӑт мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Нын тӑм икеӈән ты тусԓән, ԓын ӑнта Артемида йэмәӈ хот ԓыпи ԓоԓәпсәтән, ӑнта нын ԓух имана атәм версәтән. ");
INSERT INTO kca_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Димитрий пӑ па вератты йох ԓўв пиԓәԓән мӑтты хŏйат пеԓа пŏләщ тӑйԓәт ки, щи кеша сўт верты урәӈән ӑктәщиты щир уԓ пӑ сўт кущайәт уԓԓәт: кўтԓаԓән поләщ ат тутԓыԓәт. ");
INSERT INTO kca_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Нын мŏԓтты па ŏт кӑшԓәты ки, щит закон щирән ӑктәщиты тӑхайән ватты питԓа. ");
INSERT INTO kca_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Мўӈ вевтам щира питсув - ин тӑм тыйәм вер урәӈән, йэшащты щира пŏнԓайув, щи урәӈән нэмәԓты сŏнтәӈ ӑнтом, мўӈ ӑктәщәм верэв ԓуԓән нŏх пайәтты». Щит йастәмаԓ йўпийән, ԓўв ӑктәщәм мŏхет лакки эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Йэшащты вер вŏԓыйәм йўпийән, Павел утәԓтәты йох вана вохмаԓ пӑ ԓыв номәсԓаԓ такапмаԓ йўпийән, ԓыв пиԓԓаԓән пайәмуԓәм верәс, ким этәс пӑ Македония мўва мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Щи тӑхайәт сӑхат мӑнман пӑ эвәԓты хŏйатәт йӑм артан утәԓтәсԓы. Еллада мўва йŏхәтмаԓән, ");
INSERT INTO kca_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","щита ԓўв хуԓәм тыԓәщ ус. Хун ԓўв Сирия мўва хопән мӑнты ӑктәщәс, иудейәт ԓўвеԓ пӑратты вер ԓэщатәм хуԓмаԓ кемән, Македония сӑхат йŏхԓы мӑнты нŏмәс верәс. ");
INSERT INTO kca_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ԓўв пиԓәԓән Асия унты Сосипатр, Верия вошәӈ ху, Пирр пŏх, Фессалоника эԓты уԓты Аристарх пӑ Секунд, щӑԓта Гаий - Дервия вошәӈ ху пӑ Тимофей, щӑԓта пӑ Асия эԓты уԓты Тихик пӑ Трофим йӑхсәт. ");
INSERT INTO kca_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ԓыв, йэԓԓы мӑнман, мўӈев Троада вошән ԓавәԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Мўӈ пӑ, тўтәӈ ԋаԋ хӑтԓәт йўпийән, Филиппы эԓты хопән мӑтсув пӑ ветмет хӑтәԓән Троадайән ԓыв хŏщайэԓ йŏхәтсув, щита ԓапәт хӑтәԓ усув. ");
INSERT INTO kca_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ԓапәт оԓәӈ хӑтәԓән, хун утәԓтәты йох ԋаԋ морәтты урәӈән йӑха ӑктәщсәт, Павел ԓыв пиԓԓаԓән пŏтрэмәс пӑ, кимет хӑтәԓ мӑнты нумәсмаԓ хўват, ԓўв пŏтрәԓ ат кўтәп унты тусԓы. ");
INSERT INTO kca_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Нўм хот йӑтән, хŏта мўӈ ӑктәщсув, йӑм ар тўт хŏшам ус. ");
INSERT INTO kca_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Павел хув пŏтрэмәмаԓ эԓты, и энәмты пŏх, нэмәԓән Евтих, ишԋи хопән опсәс, такан иԓ вŏйәпса пӑ ԋŏхԓәмаԓ сӑхат, хуԓмет хот пӑԓат эԓты иԓ рӑкнәс, пӑ нŏх аԓэмәмән, пӑрмаԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Павел, иԓ эсԓәщәс, энәмты пŏх эԓт ŏԓсәԓы пӑ ԓўвеԓ ӑпәԓтман, йастәс: «Аԓ хурыйаты, ԓўв ԓыԓәӈ». ");
INSERT INTO kca_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Павел нўм хŏт йӑта ԓŏӈмаԓ кемән пӑ ԋаԋ морәтмаԓ пӑ ԓэвмаԓ йўпийән, йӑм хўват, хŏԓна пӑ хутԓәты унты, пŏтрэмәс, пӑ йухәт ким этәс. ");
INSERT INTO kca_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Щи кўтән энәмты ԋаврэм ԓыԓӈат йŏхи туса пӑ щит эԓты хŏԓ шек амәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Мўӈ паршәӈ ун хопа ԓэԓсув пӑ йэԓԓы Асс вош пеԓа мӑтсув, щиԓта Павел ўты урәӈән; ԓўв мўӈева щиты партсәԓы, ԓўв кўрән шушты ўтщийәԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Хун пӑ ԓўв мўӈ пиԓэвән Асс вошән уйтантәс, ԓўвеԓ пӑтән паршәӈ ун хопа ўймев кемән, мўӈ Митилина воша мӑтсув. ");
INSERT INTO kca_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Щӑԓта, щи мӑнман, кимет хӑтәԓ мўӈ Хиос пухәр шŏма иԓ ԓойсув, хӑтәԓ хӑйман пӑ Самос пухра хойсув пӑ, Трогиллия воша йŏхтыԓымев йўпийән, кимет хӑтәԓ Милит воша йŏхәтсув, ");
INSERT INTO kca_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Павел Ефес хӑйман мӑнты нŏмәс верәс, Асияйән ӑт ат рŏнты, щишән, ԓўв тэрматыйәс, Ветйаӈ хӑтԓәп йэмәӈ хӑтәԓ кеша Иерусалимән уԓты ԓӑӈхас. ");
INSERT INTO kca_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Милит эԓты Ефеса китәсәс, Турма пŏйәкщәты хŏйатәт ун икет ԓўв хŏщайәԓа вохсәԓы, ");
INSERT INTO kca_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","пӑ, хун ԓыв ԓўв хŏщайәԓа йŏхәтсәт, ԓывиԓаԓа йастәс: «Нын уйәтԓәԓән, хŏты ма мет оԓәӈ хӑтәԓ эԓты, хун Асияйа йŏхәтсәм, ивевән нын пиԓанән усәм, ");
INSERT INTO kca_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ма Турәм Куща пеԓа рома уԓман пӑ ар сэмйик мӑнәԓтман верәт версәм, иудейәт верәм ԉикәӈ нŏпсәт пӑтыйән кӑмән кем шук мӑнэм тўты вера йис; ");
INSERT INTO kca_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ма нэмәԓтты щит эԓты ӑт хӑйсәм, мўй эԓты нынан пŏтәртты мосәс ԓуԓән, мўйа нынан утәԓтәты мосәс ԓуԓән, мир ватман пӑ хотԓән ԓыпийән. ");
INSERT INTO kca_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ма иудейәта па, грекәта па такан йастыԓысәм, ԓыв кӑрэк эԓты шӑшән керԓәман, Турәм пеԓа ат керԓәсәт пӑ мўӈ Турәм Кущайэва Иисуса Христоса ат эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Пӑ тата щи, ин ма, Ԓыԓән хўщман, Иерусалима мӑнԓәм, ӑт уйәтԓэм, мӑнэма щита мўй питәԓ; ");
INSERT INTO kca_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Туп Йэмәӈ Ԓыԓ кашәӈ вошән аԉәԓ, пŏтәртман, касна хот пӑ шукәӈ щирәт мӑнэм ԓавәԓԓәт. ");
INSERT INTO kca_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Туп ма нэмәԓты пеԓа ӑт ӑӈкәртыԓәм пӑ ма ԓыԓэм ӑт шавиԓэм, туп, амәтман, ԓўԓән мӑ йушем мӑнты пӑ Турәм Кущайән Иисусән мийәм ма верэм йэтшәптәты ат верәтсэм, Йӑм Айкеԓ Турәм йӑм эԓты пŏтәртты. ");
INSERT INTO kca_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Пӑ ин, тӑм, ма уйәтԓэм, хŏԓ нын, хŏй кўтән, Турәм Хон Уԓәпса эԓты пŏтәртман, ма йӑхсәм, мӑнэм па ӑт ватԓәԓән. ");
INSERT INTO kca_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Щишән нынана тӑм хӑтәԓ ма такан йастәԓәм: «Нэмәԓты пӑрәм хŏйат хŏща ўнавот ӑт тӑйԓәм, ");
INSERT INTO kca_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ма Турәм ԓӑӈхаты вер аратәԓ нынана такан йастәты ӑт хӑԋатысэм. ");
INSERT INTO kca_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Щиӈәԋща, нынан ватман тӑйаԓән пӑ хŏйат тащ аратәԓән па, хŏта Йэмәӈ Ԓыԓ нынан ŏха пŏтсәԓы, Турәм Куща пӑ Турәм ӑктәщиты мŏхиԓаԓ нын такан ат шависԓән, Ԓўв кӑԓэԓ сӑхат мŏщатәм пойәкщәты мŏхиԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ма уйәтԓэм, хун ма мӑнԓәм, нын хŏщайән ԉикәӈ йэврәт ԓŏӈԓәт, ԓыв пӑ тащ ӑт щаԉәтԓэԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Щӑԓта нын эԓтыԓән хŏԓна хŏйатәт нŏх ԓойԓәт, хŏй пŏтәртаԓән вещкат вер йŏвра таԓты питԓәԓы, утәԓтәты йох ԓыв йўпиԓаԓән туты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Щишән нумәсман уԓаты! Нумаԓән, ма нынан тӑԓаӈ хуԓәм тӑԓ-ԓуӈ атәԓ-хӑтәԓ ивевән сэмйик сурән нын эԓтайән кашәӈ ŏт утәԓтысэм. ");
INSERT INTO kca_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Пӑ ин нынан, хӑнам йох, Турма пӑ Ԓўв йӑмәԓ эԓты уԓты йасӈа эвԓәптәԓԓам, хŏй нынан утәԓтәты пӑ нынана Ԓўв йэмәӈ мирәԓ кўтән ŏх вŏԓ мӑты верәтәԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ӑнта щелŏх, ӑнта сорԋи, ӑнта ԓумтәм нэмәԓты хŏйат эԓты ма ӑт ԓӑӈхасәм: ");
INSERT INTO kca_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","нын уйәтԓәԓән, мӑнэм мосты ŏт пӑ ма пўӈԓэмән уԓәм хŏйатԓама мосты ŏт тӑм ма йошӈиԓамән шитәптәсәм. ");
INSERT INTO kca_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Кашәӈ верән ма нынана этәԓтысԓам, щиты рупитман, вевԓы хŏйатәта ԋŏтты мосәԓ пӑ Турәм Куща Иисус йасӈәт нумты мосәԓ, Ԓўв йастәс: 'Ўты эԓты, мӑты йӑмшәк'». ");
INSERT INTO kca_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Щит йастәмаԓ кемән, ԓўв шашӈиԓаԓ иԓ эсәԓсәԓы пӑ хŏԓ ԓыв пиԓԓаԓән пойәкщәс. ");
INSERT INTO kca_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Щи пŏрайән хŏԓыйэ хоԓԓәсәт пӑ, Павел ӑпәԓтыман, ԓўвеԓ мосәԓтәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Мет шопәӈ ԓўв йастәм йасәӈԓаԓ эԓты хощсәт, мӑтты ԓыв па нэмәԓты пŏрайән ԓўв вешәԓ ӑт ватԓэԓ. Щӑԓта ԓўв пиԓәԓән паршәӈ хоп унты мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Хун пӑ мўӈ ԓыв пиԓԓаԓән кӑтна мӑнмев йўпийән, нык хўвԓәсув, тŏрԓы Кос воша йŏхәтсув, кимет хӑтәԓ Родос пухра, щиԓта пӑ Патара воша, ");
INSERT INTO kca_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","щӑԓта Финикия пеԓа мӑнты паршәӈ ун хоп уйәтмев кемән, нŏх хухсув пӑ нык хўвԓәсув. ");
INSERT INTO kca_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Мўӈ Кипр пухәр мўв ныты ўшән усув пӑ ԓўвеԓ веш пеләк сӑхат хӑйман, Сирия мўва мӑтсув пӑ Тир вош хŏща ўты катәԓсув, тӑта хоп эԓты пŏрмасәт хӑйты моссәт. ");
INSERT INTO kca_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Щӑԓта, утәԓтәты хŏйатәт мŏщатмев кемән, щита ԓапәт хӑтәԓ усув. Ԓыв, Йэмәӈ Ԓыԓән аԉман, Павел пеԓа пŏтәртԓәт, ԓўв Иерусалима ӑт ат мӑнәԓ. ");
INSERT INTO kca_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Щи хӑтԓәт хӑйман, мўӈ этсув пӑ мӑтсув, пӑ ԓыв хŏԓыйэ имиԓаԓ пӑ ԋаврэмԓаԓ пиԓән мўӈев вош кимпи унты хŏԓна тусэԓ; намән питарән па, шаш иԓ эсәԓман, пойәкщәсув. ");
INSERT INTO kca_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Пӑ, кўтԓувән пайәмуԓәм вермев йўпийән, мўӈ паршәӈ ун хопа ԓэԓсув, ԓыв пӑ йŏхи мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Мўӈ пӑ, мӑнты верев йэԓԓы тўвман, Тир эԓты Птолемаида воша йŏхәтсув, хŏта хӑнам йохԓув ўщайән версәԓув пӑ ԓыв хŏщайэԓ и хӑтәԓ усув. ");
INSERT INTO kca_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Кимет хӑтәԓ Павел пӑ мўӈ, ԓўв пиԓәԓән уԓәм ŏтәт, йэԓԓы мӑтсув пӑ Кесарияйа йŏхәтсув пӑ, Филлипп хота ԓŏӈман, ԓўв Йӑм Айкеԓ тутԓыты ху, ԓапәт ԋотәп ху эԓты ит, ԓўв хŏщайәԓ хӑщсув. ");
INSERT INTO kca_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ԓўв ԋӑԓ икиԓы эви тӑйәс, Турәм айкеԓ туты нэӈәт. ");
INSERT INTO kca_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Щи кўтән хŏты мўӈ ԓыв хŏщайэԓ ар хӑтәԓ усув, Иудея эԓты Агав нэмпи Турәм айкеԓ туты ики йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Щӑԓта, мўӈ хŏщайэв ԓŏӈман, Павел ӑнтәп кеԓ ўсԓы пӑ ԓўв йошԓаԓ-курԓаԓ йӑха йӑрман, йастәс: «Щиты Йэмәӈ Ԓыԓ пŏтәртәԓ: 'Тӑм ӑнтәп кеԓәӈ ики тӑмиты Иерусалимән иудейәтән йӑрԓа пӑ па рут мир йоша мӑԓа'». ");
INSERT INTO kca_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Хун пӑ мўӈ щит хуԓтмәсув, мўӈ па, щита уԓты ŏтәт па пойкащсәт, ԓўв Иерусалима ӑт ат мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Туп Павел йŏхԓы йастәс: «Мўй нын верԓәты? Мўйа хоԓԓәԓты пӑ ма сӑмем мӑшԓәԓән? Ма ӑнта туп йӑрәм ŏта уԓты ԓӑӈхаԓәм, Иерусалимән Турәм Куща Иисус нэм урәӈән пӑрты таща уԓԓәм». ");
INSERT INTO kca_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Хун пӑ мўӈ ԓўвеԓ вŏԓәтты ӑт верәтсэв, ромәпсув, йастәман: «Турәм Куща партәпса щирән ат питәԓ!» ");
INSERT INTO kca_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Тӑм хӑтԓәт йўпийән, ԓэщатыман, Иерусалима мўӈ мӑтсув. ");
INSERT INTO kca_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Мўӈ пиԓэвән тухәԓ утәԓтәты йох Кесария эԓты па шушсәт. Ԓыв мўӈев Мнасон Кипр ху, хўв тэԓән утәԓтәты ху, хота тусэԓ, хŏй хŏща мўӈев ԓуԓән уԓты рӑхәс. ");
INSERT INTO kca_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Хун мўӈ Иерусалима йŏхәтсув, хӑнам йохән, амәтман, мўӈ вана ўсайув. ");
INSERT INTO kca_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Кимет хатәԓ Павел мўӈ пиԓэвән Иаков хŏща йŏхтәс; ун икет па хŏԓ йŏхәтсәт. ");
INSERT INTO kca_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ԓывиԓаԓ ўщайән верман, Павел ԓӑтйан-карйан пŏтәртсәԓы, ԓўв верәм верԓаԓ мŏхты ӑт эвәԓты па рут мир кўтән Турәм мўй верәс. ");
INSERT INTO kca_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ԓыв па, хуԓәтмеԓ йўпийән, Турәм ԓӑтәӈа айәԓтсэԓ пӑ ԓўвеԓа йастәсәт: «Хӑнам ху, ватԓэн мўй арат щŏрәс эвԓәм иудей йох, пӑ ԓыв хŏԓ Закон такан тӑйты ŏтәт. ");
INSERT INTO kca_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Нӑӈ эԓтэн пӑ йӑма хуԓԓысәт, мӑтты нӑӈ хŏԓ па рут мир кўтән уԓты иудейәт Моисей эԓты пўӈԓа хӑтты утәԓтәԓԓан, пŏтәртман, мӑтты ԓыв йох ԋаврэмԓаԓ хŏща эвәтты вер ӑт ат версәт пӑ ԓыв щирԓаԓ щирән ӑт ат усәт. ");
INSERT INTO kca_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Щиӈәԋща, мўй пӑ? Йӑна, мир ӑктәщәԓ; хуԓԓэԓ, нӑӈ йŏхәтсән, щишән. ");
INSERT INTO kca_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Вера са, мўй мўӈ нӑӈен йастәԓув: мўӈ ԋӑԓ хŏйат, йастантәм вер тӑйты ŏтәт, тӑйԓув. ");
INSERT INTO kca_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ԓывиԓаԓ ўйман, ԓыв пиԓԓаԓән сыстамтыйа пӑ ԓыв йўкан йирԓаԓ тын нӑӈ сŏхәпты, ԓыв ŏхԓаԓ ԓŏртты ат верәтсәт. Пӑ хŏԓ кащаԓәԓәт, нӑӈ эԓтайэн хуԓԓыйәм пŏԓщәт ӑнтом вещкатәт, наӈ па Закон хуват уԓԓән. ");
INSERT INTO kca_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Эвԓәм па рут йоха мўӈ верәм нŏпсэв эԓты хӑшсэв: ԓыв нэмәԓты щимәщ ӑт ат версәт, туп ԓуӈха порыԓыйәм ԓэтŏт эԓты, вой ўр пӑ шакәптәм вой ԋŏхи эԓты, пӑ пакрасԓәты вер эԓты ԓывиԓаԓ ат шависԓаԓ». ");
INSERT INTO kca_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Щишән Павел, щи йох ўйман пӑ ԓыв пиԓԓаԓән сыстамтыман, йухәт хӑтәԓ Турәм Хота ԓŏӈәс пӑ сыстамтыйәм хӑтԓәт хŏԓам вер такан йастәс, хун кашәӈ ху урәӈән йир туты вер уԓ. ");
INSERT INTO kca_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Хун пӑ ԓапәт хӑтәԓ хŏԓаты ванамәс, щи пŏрайән Асия эԓты уԓты иудейәт ԓўвеԓ Турәм Хотән шийаԓәмеԓ кемән, мир хŏԓ йэшащты хўщсэԓ пӑ ԓўвеԓ катәԓсэԓ, ");
INSERT INTO kca_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ўвман: «Израиль йох, ԋотаты! Тӑм хŏйат арат тӑхайән мŏхет мирэва пӑ Закона пӑ тӑм тӑхайа ӑт рӑхты щирән утәԓтәԓ; Щи тўмпийән грекәт Турәм Хота тус пӑ тӑм йэмәӈ тӑха щопитсәԓы». ");
INSERT INTO kca_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Щи йэԓпийән вошән ԓыв Трофим, Ефес ху, ԓўв пиԓәԓән ватсәт пӑ нумәссәт, Павел ԓўвеԓ Турәм Хота ԓŏӈәԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Вош ԓŏватәԓән нŏх ԋŏхԓәс, пӑ мир тŏхи хухәԓмәс. Павел, ԋӑрэмәм йўпийән, Турәм Хот эԓты ким хипԉәԓтса, пӑ овәт ищи кўрәмән лӑп петсайәт. ");
INSERT INTO kca_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Хун пӑ ԓыв ԓўвеԓ пӑратты ўтщисэԓ, щŏрәс ԉаԉ йох куща унты айкеԓ йŏхтәс, Иерусалим ԓоватәԓән ўшмащты питәс. ");
INSERT INTO kca_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ԓўв ищи кўрәмән ԉаԉ йох пӑ сот ԉаԉ йох кущайәт ўйман, ԓыв хŏщайэԓ ӑратсәт. Ԓыв пӑ, щŏрәс ԉаԉ йох куща пӑ ԉаԉ йохәт кащаԓәмеԓ кемән, Павел сэкты вŏԓәтсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Щиӈәԋща щŏрәс ԉаԉ йох куща, вана йŏхәтмаԓ кемән, ԓўвеԓ ўсԓы пӑ кӑт карты кеԓән иԓ йӑрты партсәԓы, пӑ иԋщәсәс: «Хŏй ԓўв пӑ мўй верәс». ");
INSERT INTO kca_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Мир хŏща итәт ит ўвсәт, па ŏтәт па ŏт ўвсәт. Щишән щимәщ сый кўтән ԓўв нэмәԓты ԓэр вер ŏша пайәтты ӑт веритмаԓ урәӈән, Павел ԉаԉ йох уԓты тӑхайа туты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Хун пӑ ԓўв ов нухләт хŏща уԓмаԓән, мир похәл щиты хӑтәԓ пӑ, ԉаԉ йохәта, нŏх аԓәмман, ԓўвеԓ туты вера йис, ");
INSERT INTO kca_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","мир аратәԓән ԓыв йўпеԓән шушәс пӑ ўвәс: «Ԓўвеԓа сŏрәм ат уԓ!» ");
INSERT INTO kca_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ԉаԉ йŏхәт хота ԓŏӈты тӑхайән Павел щŏрәс ԉаԉ йох кущайа йастәс: «Мӑнэма наӈен мŏԓты йастәты рӑхәԓ амўй?» Щит пӑ йщмәс: «Нӑӈ грек йасәӈ уйәтԓән? ");
INSERT INTO kca_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Щишән ки, наӈ ӑнта щи Египет хŏйат, хŏй мŏԓхашәк йэшащты щир верыԓыйәс пӑ таԓ тӑхайа ԋӑԓ щŏрәс веԓтатты хŏйат тус?» ");
INSERT INTO kca_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Павел пӑ йастәс: «Ма Киликия мўвән уԓты Тарс ун вошәӈ иудей ху. Нӑӈен пойәкԓәм, мӑнэм мир пеԓа йастәты эсԓы». ");
INSERT INTO kca_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Хун пӑ щитән эсәԓса, Павел, ов нухәлән ԓойман, йошәԓән мира пос мӑс. Щӑԓта, хун шек шитама йис, еврей йасәӈән щиты пŏтәртты питәс: ");
INSERT INTO kca_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Хӑнам йохәт пӑ ащет! Манэм нын йэԓпанән ӑратыты урәӈән, мӑнэм пŏтәрты эсԓаԓән». ");
INSERT INTO kca_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ԓўв пӑ ԓыв пиԓԓаԓән еврей йасәӈән пŏтәртты хуԓмеԓ кемән, мет шитама йисәт. Ԓўв йастәс: ");
INSERT INTO kca_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ма иудей ху, Киликияйән уԓты Тарс вошән сэма питәм ŏт, тӑм вошән Гамалиил утәԓтәты ху хŏща энмәԓтәм ŏт, ащиԓув Закон щирән шек йӑма утәԓтәм ŏт, Турәм вер пеԓа такан уԓты ŏт, хŏты нын хŏԓ ин уԓԓәты. ");
INSERT INTO kca_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ма хŏԓна сŏрәм унты тӑм утәԓтәпса йўпи тўвәм хŏйатәт ԋухәтԓысԓам, иԓ йӑрман йохәт пӑ нэӈәт касна хота мийԓысԓам. ");
INSERT INTO kca_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Щит вантәм ŏтәт - Турма йир верты ŏх ху пӑ йӑха актәщиты ун икет аратэԓән. Ма хŏԓна ԓыв эԓтыԓаԓ Дамаск вошәӈ хӑнам йохәта хӑншәм айкеԓ нэпекәт ўсәм пӑ щи мӑтсәм, христианәт эԓты хŏй щита ус пӑ щитәт катәԓты, пӑ ԓывиԓаԓ Иерусалима сэкты урәӈән туты. ");
INSERT INTO kca_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Хун пӑ ма йушән уԓмемән пӑ Дамаск воша ванамәсәм, хӑтәԓ кўтәп кемән шӑмкап турәм хӑр эԓты щи хŏрпи нŏвийән похәтсайәм, пӑ сэм хŏԓна нŏх ӑт эԓԓәԓ. ");
INSERT INTO kca_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ма мўва иԓ рӑкәтсәм пӑ мӑ пеԓайэм пŏтәртәм тур сый хуԓмәсәм: \"Савл, Савл! Мўйа нӑӈ Мӑнэм ԋухәԓԓэн?\" ");
INSERT INTO kca_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ма йŏхԓы йастәԓәм: \"Хŏй Нӑӈ, Турәм Куща?\" Ԓўв мӑнэма йастәс: \"Ма Назарет эԓты уԓты Иисус, Хŏй нӑӈ ԋухәԓԓэн\". ");
INSERT INTO kca_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ма пиԓэмән уԓәм ŏтәт нŏви ватсэԓ пӑ пӑԉщәмән йŏхәтсайәт; туп ма пеԓайэма Пŏтәртәм Ŏт тўр сый ӑт хуԓсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Щиӈәԋща ма йастәсәм: \"Турәм Куща! Мӑнэм мўй верты?\" Турәм Куща пӑ мӑнэма йастәс: \"Нŏх ԓойа пӑ Дамаска мӑна, пӑ щита нӑӈена иса йастәԓа, мўй наӈена верты постәса\". ");
INSERT INTO kca_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Хŏты ма вŏԉиты нŏви эԓты сэмԓы питсәм, ма пиԓэмән йўвәм мŏхет йош пелкем эԓты Дамаска ватәԓтәсайәм. ");
INSERT INTO kca_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","А-хой Анания, Закон хўват уԓты Турма эвәԓты хŏйат, Дамаскән уԓты иудейәтән хŏԓ йӑма айәԓтса, ");
INSERT INTO kca_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ма хŏщайэм йŏхтәс пӑ, вана шушман, мӑнэма йастәс: \"Савл хӑнам ху, сэмәӈа йўва!\" Пӑ ма ищи кумат ԓўвеԓ шийаԓәсэм. ");
INSERT INTO kca_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ԓўв пӑ мӑнэм йастәс: \"Мўӈ ащиԓув Турәм нӑӈен пирыйәс, наӈ Ԓўв ԓӑӈхаты щирәԓ ŏша ат пайәтсэн, Вещкат Ŏт ат шийаԓәсән пӑ тўр сый Ԓўв ўӈԓәԓ эԓты ат хуԓсән. ");
INSERT INTO kca_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Нӑӈ Ԓўвеԓа хŏԓ хŏйатәт йэԓпийән вантәм ŏта питԓән, щит эԓты, мўй ватсән пӑ хуԓсән. ");
INSERT INTO kca_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Щиӈәԋща, мўй нӑӈ айәԓта уԓԓән? Нŏх ԓойа, Турәм Куща Иисус пеԓа пойәкща, йиӈка ат ԓŏӈәԓтыԓайән пӑ, кӑрэкԓан хŏԓт ат ԉŏхәтԓайәт\". ");
INSERT INTO kca_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Хун пӑ ма Иерусалима йŏхԓы йŏхәтсәм пӑ Турәм Хотән пойәкщәсәм, мӑ вантәпса ватсәм ");
INSERT INTO kca_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","пӑ Ԓўвеԓ шийаԓәсәм, пӑ Ԓўв мӑнэма йастәс: \"Тэрматыйа пӑ Иерусалим эԓты ким эта, тӑта нӑӈ Ма эԓтайэм пŏтәртты щирэн вана ӑт ўԓа\". ");
INSERT INTO kca_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ма йастәсәм: \"Турәм Куща! Ԓыв уйәтԓэԓ, ма Нӑӈена эвәԓты хŏйатәт касна хота тухрыԓысԓам пӑ иудейәт пойәкщәты хотәтән сэӈкиԓысԓам, ");
INSERT INTO kca_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","пӑ хун Стефан, Наӈен вантәм ŏтэн, кӑԓэԓ щŏрӈәԓтәм пŏрайән, ма щита ԓойсәм, ԓўв паратты верәԓ эԓт тӑйсэм, ԓўвеԓ паратты ŏтәт ԓумтәмәт ма шависәм\". ");
INSERT INTO kca_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Щӑԓта ԓўв мӑнэма йастәс: \"Мӑна, Ма нӑӈен хўва Турма ӑт эвәԓты па рут мир хŏща китԓэм\"». ");
INSERT INTO kca_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Тӑм йасәӈ унты ԓўв хуԓәтса; щи йўпийән ўвты питсәт, пŏтәртман: «Мўв сŏх эԓты ԓўвеԓ нŏх ушийи! Ԓўвеԓа уԓты ӑт рӑхәԓ». ");
INSERT INTO kca_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Щи ԓыв ўвмеԓ кўтән, ԓумтәмԓаԓ йовәԓсәт пӑ кўрпӑт хиш нŏх йовәԓсәт, ");
INSERT INTO kca_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","щŏрәс ԉаԉ йох куща ԓўвеԓ ԉаԉ йŏх уԓты тӑхайа туты партсәԓы. Ԓўвеԓ хомщийән сэкты пӑ такан иԋщәсты партсәԓы, мўй урәӈән ԓўв пеԓайәԓ мир щиты ўвәс. ");
INSERT INTO kca_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Туп хун ԓўв лаккеԓәтән йӑртсәԓәса, Павел ԓойәм сот ԉаԉ йох кущайа йастәс: «Нынан мўй Рим ху сэкты рӑхәԓ, хŏԓна пӑ сўт такԓы?» ");
INSERT INTO kca_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Щит хуԓмаԓ кемән, сот ԉаԉ йох куща мӑнәс пӑ щŏрәс ԉаԉ йох кущайа щит тусԓы, пŏтәртман: «Ванта, мўй нӑӈ верты ўтщиԓән? Тӑм хŏйат - Рим ху». ");
INSERT INTO kca_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Щиӈәԋща щŏрәс ԉаԉ йох куща, ԓўв хŏщайәԓ вана шушман, иԋщәсәԓ: «Йаста мӑнэма, нӑӈ Рим ху?» Ԓўв йастәс: «Па хŏты». ");
INSERT INTO kca_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Щŏрәс ԉаԉ йох куща йŏхԓы йастәс: «Ма ун ŏх сӑхат щи Рим хŏйата уԓты вер ԓутсэм». Павел пӑ йастәс: «Ма пӑ щита сэма питсәм». ");
INSERT INTO kca_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Щиӈәԋща ищи кумат ԓўвеԓ шукатты утщийәм ŏтәт ԓўв эԓтайәԓ пўӈԓа хӑтәмәсәт. Щŏрәс ԉаԉ йох куща пӑ, ԓўв Рим хŏйата уԓты верәԓ мŏштәмаԓ кемән, хŏԓт пӑԓтамәс, ԓўвеԓ йӑрсәԓамаԓ урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Кимет хӑтәԓ, тŏрԓы уйәтты ԓӑӈхаман, мўй хŏща ԓўв иудейәтән ўнавота пайәтса, ԓўвеԓ кеԓԓаԓ эԓты хŏԓт пайәтсәԓы пӑ Турма йир верты ŏх икета пӑ синедриона хŏԓ ӑктәщты партсәԓы пӑ, Павел ким этәԓтәсԓы пӑ ԓыв йэԓпиԓаԓа ԓощәԓтәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Павел синедрион пеԓа ӑӈкәрмәс пӑ йастәс: «Хӑнам йох! Ма вещкат сӑмән иса тӑм хӑтәԓ унты Турәм йэщаԓт усәм». ");
INSERT INTO kca_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Турма йир верты ŏх ху Ананий пӑ Павел ԉэпән ԓойты ŏтәта ԓўвеԓ тŏрәп эԓты сэкты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Щишән Павел ԓўвеԓа йастәс: «Турәм нӑӈен секты питԓәԓы, нŏвийа нэрәм хот питар! Нӑӈ, Закон щирән сўтәтты урәӈән омәсԓән, пӑ Закон шŏппи ўшман, мӑнэм сэкты партԓэн». ");
INSERT INTO kca_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ванән ԓойәм ŏтәт пӑ йастәсәт: «Хŏты сӑхат нӑӈ Турма йир верты ŏх ху накәлты верәтԓэн?» ");
INSERT INTO kca_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Павел йастәс: «Хӑнам йох, ма ӑт уйәтсэм, ԓўв Турма йир верты ŏх икийа уԓты верәԓ; хӑшман ӑт уԓԓа: 'Нӑӈ мирэн хŏща кущайа уԓты хŏйат эԓты атма аԓ йаста'». ");
INSERT INTO kca_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Павел уйәтсәԓԓы, итәт саддукейа усәт, киметәт пӑ - фарисейа, щишән ԓўв синедрион йох пеԓа такан йастәс: «Хӑнам йох, ма фарисей, фарисей пŏх, пӑ ма пӑрәм ŏтәт нŏх ԓыԓәӈԓәты щир пеԓа нŏмәс пŏнмем урәӈән сўтәтԓайәм». ");
INSERT INTO kca_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Хун пӑ ԓўв щит йастәс, фарисейәт пӑ саддукейәт кўтԓаԓән ўра ворты питсәт, пӑ ӑктәщәм мŏхет кӑтна ортәссәт. ");
INSERT INTO kca_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Саддукейәт пŏтәртԓәт: ӑнта нŏх ԓыԓәӈԓәты щир, ӑнта ангел, ӑнта ԓыԓ ӑнтом; фарисейәт пӑ тўмеԓ па, тӑмеԓ па ванән тӑйԓыԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Щи ԓŏват ун ўв сый тыйәс; щӑԓта тухәԓ фарисейәт эԓты уԓты Закона утәԓтәты икет, нŏх ԓойман, ўра ворԓәт, йастәман: «Нэмәԓты атәм ŏт мўӈ тӑм хŏйат хŏща ӑт уйәтԓув; ԓыԓ мўй пӑ ангел ԓўв пеԓайәԓ пŏтәртыйәс ки, Турәм йэщаԓт уԓты мўӈ ӑт питԓув». ");
INSERT INTO kca_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Туп ўра ворты верэԓ уна йис, щŏрәс ԉаԉ йох куща пӑԓман, Павел ԓыв лакки аԓ мӑшԓэԓ, ԉаԉ йохәта иԓ ŏхәԓты пӑ ԓыв кўтэԓ эԓты Павел ўты партсәԓы пӑ ԉаԉ йŏх уԓты хота туты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Кимет ат Турәм Куща, ԓўв хŏщайәԓ этман, йастәс: «Павел, аԓ пӑԓа; хŏты нӑӈ Иерусалимән Ма эԓтэм пŏтәртсән, щиты Рим хŏща пŏтәртты па мосәԓ». ");
INSERT INTO kca_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Аԓәӈсӑхата йўвмаԓ кемән тухәԓ иудейәт нŏмәс версәт пӑ, Павел пӑраттэԓ унты, ӑт ԓэты, ӑт йищты йастатсәт. ");
INSERT INTO kca_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Йастантәм хŏйат ԋӑԓйаӈ мŏԓтас ус. ");
INSERT INTO kca_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ԓыв Турма йир верты ŏх икет пӑ уна уԓты икет хŏща йŏхәтсәт пӑ йастәсәт: «Мўӈ, Павел пӑраттэв унты, нэмәԓты ӑт ԓэты йастатсув. ");
INSERT INTO kca_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Щиӈәԋща, ин щи нын синедрион пиԓән щŏрәс ԉаԉ йох кущайа хӑԓэвәт Павел нын хŏщайән туты партаԓән, ищи мӑтты нын ԓўв верәԓ йӑмашәк ватты верән уԓ. Мўӈ пӑ, ԓэщатыман уԓԓув пӑ ԓўвеԓ хŏԓна щи тӑхайа йŏхәттаԓ унты, пӑраттԓэв». ");
INSERT INTO kca_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Щи йастантәм вер эԓты Павел ԓэхуйәԓ, опеԓ пŏх, хуԓәс. Ԓўв ԉаԉ йох уԓты хота йŏхтәс пӑ Павела йастәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Павел пӑ, сот ԉаԉ йох куща эԓты ит вана вохсәԓы пӑ йастәс: «Тӑм пŏх щŏрәс ԉаԉ йох куща хŏща тўви, ԓўв щи кущайа мŏԓтты йастәты ŏт тӑйәԓ». ");
INSERT INTO kca_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Щитэн ԓўвеԓ щŏрәс ԉаԉ йох куща хŏща тусԓы пӑ йастәс: «Касна хота опсәм Павел, мӑнэм вана вохман, тӑм пŏх нӑӈ хŏщайэн туты партсәԓы, ԓўв нӑӈена мŏԓтты йастәты ŏт тӑйәԓ». ");
INSERT INTO kca_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Щŏрәс ԉаԉ йох куща, ԓўвеԓ йошәԓ эԓты катәԓман пӑ ԓўв пиԓәԓән пўӈԓа йирԓәман, иԋщәссәԓы: «Мӑнэм йастәты нӑӈ мўй тӑйԓән?» ");
INSERT INTO kca_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ԓўв йŏхԓы йастәс: «Иудейәт нӑӈен партты нŏмәс версәт, нӑӈ хӑԓэвәт Павел синедрион хŏща ким ат этәԓтәсэн, ищи мӑтты ԓыв йӑмашәк ԓўв эԓтэԓ ԓэрапты верэԓ уԓ. ");
INSERT INTO kca_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Туп нӑӈ ԓывиԓаԓ аԓ хуԓәнта; ԓўвеԓ ԋӑԓйаӈ мŏԓтас хŏйат ԓыв эԓтыԓаԓ ԓомиԓәт, хŏй ӑт ԓэты пӑ ӑт йищты йастатсәт, ԓўвеԓ ӑт веԓтэԓ унты; пӑ ԓыв, нӑӈ йасӈен ԓавәԓман, ин ԓэщатыман уԓԓәт». ");
INSERT INTO kca_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Щиӈәԋща щŏрәс ԉаԉ йох куща энмәм пŏх эсәԓсәԓы, йастәман: «Нэмәԓты хŏйата аԓ йасты, мӑнэм мўй йастәсән». ");
INSERT INTO kca_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Щӑԓта, кӑт сот ԉаԉ йох кущайӈән вана вохман, йастәс: «Кӑт сот кўрән шушты, ԓапәтйаӈ ԓовәӈ ԉаԉ йох пӑ кӑтсот ԋоԓәӈ-йухԓәӈ ԉаԉ ху ԓэщататы, атәԓән хуԓәм щос кемән Кесария воша ат мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ԓовәт и щиты ԓэщатаԓән, Павел щи опсәԓман, Феликс нэмпи куща хŏща ԓўвеԓ йӑма туты урәӈән». ");
INSERT INTO kca_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Нэпека па щимәщ айкеԓ хӑншәс: ");
INSERT INTO kca_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Клавдий Лисий эԓты ԓӑтәӈ куща Феликс икийа. Ўща уԓа. ");
INSERT INTO kca_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Иудейәт тӑм хŏйат ԋӑрэмәсэԓ пӑ веԓты ўтщисэԓ; ма ԉаԉ йохԓам пиԓән йŏхәтсәм пӑ ԓўвеԓ нŏх ӑратысэм, ԓўв Рим хŏйата уԓты верәԓ мŏштәмэм пӑтыйән. ");
INSERT INTO kca_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Йухәт, ԓэрапты ԓӑӈхатэм урәӈән, мўй хŏща ԓўв нўрәӈа айәԓса, ԓўвеԓ ԓыв синедрионэԓа тусэм. ");
INSERT INTO kca_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ма ŏша пайәтсэм, ԓыв законэԓ хŏща ўрайа хойәм нŏпсәт урәӈән ԓўв нўрәӈа айәԓԓа, туп нэмәԓтты нўр сŏрәм пӑ касна хот кеша ԓўв хŏщайәԓ ӑт уйәтсәм. ");
INSERT INTO kca_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Туп ма хŏщайэм иудейәт тӑм хŏйат пеԓа атәм нŏмәс верты айкеԓэԓ йŏхтәс, ма ԓўвеԓ мŏхты нӑӈ хŏщайэн китсэм, нўр туты ŏтәта па ԓўв пеԓайәԓа нӑӈ хŏщайэн пŏтәртты партсәԓам. Тўмтака уԓа». ");
INSERT INTO kca_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Щиӈәԋща, ԉаԉ йохәт, тӑм ԓўв партәм щирәԓ хўватән, Павел ўйман, атәԓән Антипатрида воша тусэԓ. ");
INSERT INTO kca_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Кимет хӑтәԓ пӑ, ԓовәӈ ԉаԉ йохәта ԓўв пиԓәԓән мӑнты миймеԓ кемән, ԉӑԉ йох уԓты хотэԓа йŏхԓы керԓәсәт. ");
INSERT INTO kca_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ԉаԉ йох пӑ, Кесария воша йŏхәтмеԓ пӑ айкеԓәӈ нэпек куща икийа миймеԓ кемән, Павел па ԓўвеԓа мӑсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Куща ики, айкеԓәӈ нэпек ԓуӈәтмаԓ йўпийән, иԋщәссәԓы, мӑты мўв щуӈ эԓты ԓўв уԓ. Павел Киликия эԓты уԓты мŏштәмаԓ кемән, йастәс: ");
INSERT INTO kca_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Ма нӑӈен щи пŏрайән хуԓәтԓэм, хун нўр туты ŏтԓан йŏхәтԓәт». Пӑ ԓўвеԓ Ирод хŏт шикийән, ԉаԉ йохән эԓт тӑйман, уԓты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Вет хӑтәԓ хӑщәм йўпийән, Турма йир верты ŏх ху Анания ун икет пиԓән пӑ Тертулл, законәт уйәтты ху, пиԓән Кесарияйа йŏхтәс. Ԓыв куща икийа йастәсәт, мўй урәӈән Павел нўрмәԓтты питԓэԓ. ");
INSERT INTO kca_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Хун пӑ Павел тŏхи ԓŏӈәԓтса, Тертулл ԓўв нўрәԓ аԉты питсәԓы, пŏтәртман: ");
INSERT INTO kca_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","«Иса пӑ кашәӈ тӑхайән кӑмән хŏрпи йӑм щирән мўӈ вана ўԓэв, мўӈ пайԓы уԓәпсайэв урәӈән нӑӈена, ԓӑтәӈ куща Феликс, пумащипа йастәты мўӈ верэв уԓ, пӑ тӑм мир йӑм, так уԓәпса нӑӈ ŏшәӈа парттэн хўватән уԓ. ");
INSERT INTO kca_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Туп, нӑӈен шек ӑт ат тŏрастәты урәӈән, ма нӑӈен сӑмәӈ вер хўватэнән мўӈев йэша тӑхты хуԓәтты пŏйәкԓэм. ");
INSERT INTO kca_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Мўӈ тӑм хŏйат рома уԓты щир ԓыԓәтты ŏта ԓўӈәтԓэв, ԓўв - иудейәт кўтән керәтман мўв ԓŏватән йэшащты вер пеԓа ŏх ху. Ԓўв Назарет эԓты уԓты Иисус ӑт рӑхты утәԓтәпса пеԓа уԓты ŏх ху, ");
INSERT INTO kca_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","хŏй хŏԓна Турәм Хот щопитты ўтщисԓы, мўӈ ԓўвеԓ катәԓсэв пӑ мўӈ Законэв хўватән сўтәтты ўтщисэв. ");
INSERT INTO kca_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Туп щŏрәс ԉаԉ йох куща Лисий, йŏхтәс пӑ йур вевән ԓўвеԓ мўӈ йошев эԓты ўсԓы пӑ нӑӈ хŏщайэн китсәԓы, ");
INSERT INTO kca_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","мўӈева, ԓўвеԓ нўрәӈа айәԓтты ŏтәта, па нӑӈ хŏщайэн мӑнты партсәԓы. Хун нӑӈ ԓўвеԓ иԋщәсԓэн, наӈ щи мўй эԓты иса уйәтԓэн, мўй хŏща мўӈ ԓўвеԓ нўрәӈа тӑйԓэв». ");
INSERT INTO kca_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Щӑԓта иудейәт па йастәсәт, мӑтты щит щиты. ");
INSERT INTO kca_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Павел пӑ, хун куща ики ԓўвеԓа пŏтәртты щира пос аԉәс, йŏхԓы йастәс: «Уйәтԓэм, нӑӈ ар тӑԓ-ԓўӈ вещкат щирән тӑм мир сўтәтԓән, ма ԓӑрпайа ма верэм ӑратыты питԓэм. ");
INSERT INTO kca_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Нӑӈ ԓэрапты верәтԓэн, ма Иерусалима Турәм ишәкты урәӈән йŏхәтмем, кӑтхŏщйаӈ кем хӑтԓа йис. ");
INSERT INTO kca_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ӑнта Турәм Хотән, ӑнта иудейәт пойәкщәты хотән, ӑнта вош ԓŏватән ԓыв мӑнэм ўра ворман мўй пӑ мир йэшащты пеԓа хущман, ӑт уйтыԓысэԓ, ");
INSERT INTO kca_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","пӑ щит аԉты ӑт верәтԓәт, мўй хŏща мӑнэм ин нўрмәԓԓәт. ");
INSERT INTO kca_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Туп щи хŏща нӑӈен эԓпа йастәԓэм, утәԓтәпса хўват, мўй ԓыв ӑт рӑхты щира айәԓԓэԓ, йӑна ма ащиԓам Турма верәт верԓәм, иса щитәта эвәԓман, мўй Законән пӑ Турәм айкеԓ туты хŏйатәт нэпекәт хŏща хӑшман уԓԓа, ");
INSERT INTO kca_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Турма нŏмәс пŏнман тӑйԓәм, пӑрәм ŏтәт, вещкат пӑ ӑнта вещкат ŏтәт нŏх ԓыԓәӈԓәты вер питәԓ, мўй ԓыв па ԓавәԓԓәт. ");
INSERT INTO kca_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Щишән ма па ўратԓәм, Турәм пӑ хŏйатәт хŏща ма ԓыпем иса сыстам ат ус. ");
INSERT INTO kca_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ар тӑԓ хӑщәм йўпийән, ма мирэма меԓащ мӑты пӑ Турма йир туты урәӈән, ма Иерусалима йŏхәтсәм. ");
INSERT INTO kca_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ма Турәм Хотән уйәтсайәм, хун ма сыстамтыты верәт версәм, пӑ щита нэмәԓты мир пӑ йэшащты сый уԓмаԓ ӑнтом. ");
INSERT INTO kca_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Щит тухәԓ Асия мўвәӈ иудейәт усәт, хŏйтата наӈ йэщаԓтэн ԓойты пӑ мӑнэм нўрмәԓтты мосәс, ма пеԓайэм мŏԓты тӑйԓәт ки. ");
INSERT INTO kca_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Мўй пӑ щитәт ат йастәԓәт, хун ма синедрион йэщаԓт ԓоймемән, мўй хŏрпи нўр ԓыв ма хŏщайэм уйәтсәт, ");
INSERT INTO kca_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","мосәӈ, ма туп щита нўр тӑйԓәм, синедрион хŏща ўваԓтсәм: 'Ма тӑм хӑтәԓ нын йэщаԓтән, пӑрәм ŏтәт нŏх ԓыԓәӈԓәты вер пеԓа нŏмәс пŏнтэм урәӈән, сўтәтԓайәм?'» ");
INSERT INTO kca_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Щит хуԓәтмаԓ йўпийән, Феликс, щи Йуш эԓты тŏрԓы уйәтман, ԓыв верэԓ йэԓшәк хӑтәԓтәсԓы, йастәс: «Нын верән ватԓэм, хун щŏрәс ԉаԉ йох куща Лисий йŏхәтәԓ». ");
INSERT INTO kca_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ԓўв сот ԉаԉ йох кущайа Павел эԓт тӑйты партсәԓы, туп ԓўвеԓа йэрмат щир верты пӑ ԓухәсԓаԓа ԓўвеԓа мосты верәт верты мўй пӑ йŏхтыԓыты, йэртԓыты ӑт эсәԓсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Кӑмәтса хӑтәԓ йўпийән Феликс, Друзилла ийимеԓ, иудей нэ, пиԓән йŏхәтмаԓ кемән, Павел вохсәԓы, пӑ Иисуса Христоса эвәԓты вер эԓты хуԓәнтәс. ");
INSERT INTO kca_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Пӑ хун ԓўв вещкат вер эԓты, йŏхи шаващты вер эԓты пӑ йиты Турәм сўт эԓты пŏтәртәс, Феликс пӑԉщәмән йŏхәтса пӑ йастәс: «Ин мӑна, хун пӑ кум шитԓәм, нӑӈен вохԓэм». ");
INSERT INTO kca_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ԓўв ищи кўт нумәсәс, эсәԓты урәӈән, Павел ԓўвеԓа ŏх мӑԓ: щишән ван кўтԓы ԓўвеԓ вана туты партыԓысԓы пӑ ԓўв пиԓәԓән пŏтрэмәс. ");
INSERT INTO kca_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Туп кӑт тӑԓ хӑщәм кемән, Феликс рупитәм тӑхайа Порций Фест йŏхтәс, иудейәта йӑм верты урәӈән, Феликс Павел касна хотән хӑйсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Фест, щи мўв щуӈа йŏхәтмаԓ кемән, ԋӑԓмет хӑтәԓән Кесария эԓты Иерусалима мӑнәс. ");
INSERT INTO kca_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Щӑԓта Турма йир верты ŏх ху пӑ иудейәт эԓты ԓӑтәӈа уԓты йох ԓўв хŏщайәԓ Павел эԓты нўр кӑшты йŏхәтсәт пӑ ԓўв пеԓайәԓ эвԓа-йŏԓа пŏтәртсәт, ");
INSERT INTO kca_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","щит вохман, Фест ԓывиԓаԓа йӑм ат верәс, Павел Иерусалима ат вохсәԓы; пӑ йуш хŏща ԓўвеԓ веԓты нŏмәс версәт. ");
INSERT INTO kca_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Туп Фест йŏхԓы йастәс, мӑтты Павел Кесарияйән ԉаԉ йŏхән эԓт тӑйԓа пӑ йэшавәԓ ԓўв тŏхи мӑнәԓ. ");
INSERT INTO kca_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","«Щиӈәԋща,» ԓўв йастәс, «нын кущайԓән, ма пиԓэмән ат мӑнԓәт, пӑ мŏԓты вер тӑм хŏйат хŏща уԓ ки, ԓўвеԓ ат нўрмәԓтԓэԓ». ");
INSERT INTO kca_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ԓыв хŏщайэԓ ԋийәԓ мўй йаӈ хӑтәԓ кем уԓмаԓ йўпийән, Кесарияйа йŏхԓы йŏхтәс, пӑ кимет хӑтәԓ, сўт ху омәсты тӑхайа омасмаԓ кемән, Павел туты партсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Хун ԓўв этәс, Иерусалим эԓты йŏхтәм иудейәт керәтман ԓойсәт, Павел артан пӑ ԓавәртан нўрмәԓтты питсэԓ, туп ԓыв щи нўрәт тŏрԓы аԉты ӑт верәтсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ԓўв пӑ, ԓўвеԓ ӑратыман, йастәс: «Ма нэмәԓты атәм ӑнта иудейәт Закона, ӑнта Турәм Хота, ӑнта кесарьа ӑт версәм». ");
INSERT INTO kca_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Фест, иудейәта йӑм верты ԓӑӈхаман, Павел пеԓа йŏхԓы йастәс: «Иерусалима мўй мӑнты ԓӑӈхаԓән, тӑм верәт урәӈән, щита ма уԓман, нӑӈ ат сўтәтсайән?» ");
INSERT INTO kca_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Павел йастәс: «Ма кесарь сўт йэщаԓт ԓойԓәм, хŏта мӑ сўтәтты верэм уԓ. Иудейәта ма нэмәԓтты атәм ӑт версәм, хŏты нӑӈ па йӑма уйәтԓэн. ");
INSERT INTO kca_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ма закон шŏппи ўшсэм ки пӑ сŏрәм ԓӑта мŏԓтты версәм ки, пӑрты эԓты шӑшән ӑт ўратԓәм; нэмәԓты ки щит ӑнтом, мўй урәӈән тӑметән мӑ нўрмәԓтԓайәм, нэмәԓты хŏйат мӑнэм ԓывиԓаԓа мӑты ӑт верәтәԓ. Кесарь сўт такан вохԓәм». ");
INSERT INTO kca_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Щишән Фест, нŏмәс мӑты хŏйатәт пиԓән пŏтремәмаԓ йўпийән, йастәс: «Нӑӈ кесарь сўт вŏхсән, кесарь хŏща щи мӑнԓән». ");
INSERT INTO kca_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Кӑмәтса хӑтәԓ хӑщәм йўпийән, Агриппа хон Вереника пиԓән Кесария воша Фест кущайа мойԓәпса йасәӈ йастәты йŏхтәс. ");
INSERT INTO kca_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ԓын ар хӑтәԓ щита хӑйсәтән, пӑ Фест хон пиԓән Павел вер эԓты пŏтәртәс: «Тӑта, касна хотән, Феликсән хӑйәм хŏйат уԓ. ");
INSERT INTO kca_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Хун ма Иерусалимән уԓмемән, иудейәт Турма йир верты ŏх икет пӑ уна уԓты икет ԓўвеԓ нўра павәтты йŏхәтсәт. Ԓыв ԓўвеԓ сўтәтты партсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ма ԓывиԓаԓа йастәсәм, Рим хŏйатәт ӑԓ ишән мӑтты хŏйат сŏрма павәтты вер ӑт тӑйԓәт, щи унты хун ԓўвеԓа нўрмәԓтты ŏтԓаԓ пиԓән уйтантыты пӑ ԓўвеԓ ӑратыты щирән мӑԓа. ");
INSERT INTO kca_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Хун пӑ ԓыв ты йŏхәтсәт, кимет хӑтәԓ мŏхты ма сўт ху омәсты тӑхай омәсәм пӑ щи хŏйат ты туты партсэм. ");
INSERT INTO kca_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ԓўвеԓ лӑп нӑпәтман, нўрмәԓтты ŏтәт и нўр ӑт аԉсәт, мўй хŏрпи нўрәт уԓты ма нумәссәм; ");
INSERT INTO kca_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Туп ԓыв ԓўв пиԓәԓән иудейәт Турма эвәԓты верэԓ эԓты пӑ а хŏй пӑрәм Иисус эԓты ўра вортсәт, Хŏй эԓты Павел такан пŏтәртәс, мӑтты Ԓўв ԓыԓәӈ. ");
INSERT INTO kca_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ма ӑт уйәтсэм, хŏты мӑнэм щи вер ԓэрапты, пӑ ԓўвеԓ иԋщәссэм, ԓўв ԓӑӈхаԓ мўй ӑнтом Иерусалима мӑнты пӑ щита сўт йэщаԓт ԓойты. ");
INSERT INTO kca_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Туп Павел такан партсәԓы, ԓўв кесарьән ватты кеша ат хӑйса, ма пӑ ԓўвеԓ кесарь киттэм унты ԉаԉ йохәта эԓт тӑйты партсэм». ");
INSERT INTO kca_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Агриппа пӑ Фест пеԓа йастәс: «Ма па щи хŏйат хуԓәтты кашем ус». «Хӑԓэвәт щи хуԓԓэн» - Фест йŏхԓы йастәс. ");
INSERT INTO kca_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Кимет хӑтәԓ, хун Агриппа пӑ Вереника ун ԓӑтәӈ щирән йŏхәтсәтән пӑ сўт верты тӑхайа щŏрәс ԉаԉ йŏх кущайәт пӑ ԓӑтәӈа уԓты вошәӈ хŏйатәт пиԓән ԓŏксәтән, Фест партәм хўватән Павел туса. ");
INSERT INTO kca_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Щӑԓта Фест йастәс: «Агриппа хон пӑ хŏԓ тӑта уԓты йох! Нынан тўм хŏйат ныԓа, хŏй эԓты аратәԓ хŏԓ иудейәт мӑ хŏщайэм Иерусалимән пӑ тӑта, поләщ тўвман пӑ нўр кӑшман, йŏхтыԓысәт пӑ ўвсәт, ԓўвеԓа йэԓԓы уԓты ӑт мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Туп ма уйәтсэм, сŏрәм ԓӑта ԓўв немәԓты ӑт верәс; пӑ хŏты ԓўв Август эԓты сўт вер такан вохәс, ма ԓўв хŏщайәԓа ԓўвеԓ китты нŏмәс версәм. ");
INSERT INTO kca_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ма ԓўв эԓтэԓ нэмәԓты тŏрԓы вер кущайэма хӑшты ӑт тӑйԓәм; щишән ԓўвеԓ нын хŏщайән, мет шопәӈ Агриппа хон, нӑӈ хŏщайэна тусэм, ватты йўпийән, мӑнэм мŏԓтты хӑшты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ма нумәстэмән, ŏшԓы щир щит, касна хота опсәм ŏт, ԓўв нўрәԓ ӑт аԉман, хон хŏща китты». ");
INSERT INTO kca_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Агриппа Павела йастәс: «Нӑӈена нӑӈ эԓтайэн пŏтәртты рӑхәԓ». Щиӈәԋща Павел, йошәԓ йэԓ ԋиштәман, ԓўвеԓ ӑратыты щира пŏтәртты питәс: ");
INSERT INTO kca_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Агриппа хон! Мӑнэм ма ŏй тӑйтыйа айәԓԓэм, тӑм хӑтәԓ нӑӈ йэщаԓтэн кашәӈ вер эԓты мӑнэм ма ӑратыты верәтԓэм, мўй хŏща ма иудейәтән нўрмәԓԓайәм, ");
INSERT INTO kca_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","хŏԓна мет, нӑӈ иудейәт уԓәпса щирәт пӑ ўрайа питты нŏпсәт уйәтԓәԓан. Щишән нӑӈен тўӈа-щира мӑнэм хуԓәтты пойәкԓэм. ");
INSERT INTO kca_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Мет оԓәӈән ма мирэм кўтән уԓәм верэм, Иерусалимән энәмты пŏх ԓŏватән уԓәм уԓәпсайэм иудейәта иса ԓэр. ");
INSERT INTO kca_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ԓыв хўв тэԓән ма эԓтэм уйәтԓәт, туп уйәтты вер аԉты ԓӑӈхамәԓәт ки, ма фарисейа усәм. Щит мўӈ эвәԓты верэв хŏща мет так утәԓтәпса. ");
INSERT INTO kca_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ин ма сўт йэщаԓт ԓойԓәм Турәм аԉәм вер пеԓа пŏнәм нŏмәс урәӈән, мўй мўӈ ащиԓува мӑса, ");
INSERT INTO kca_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","щи аԉәм вер тӑԓаӈа йиты вер кӑтхŏщйаӈ сыр рут мўӈ мирэв шийаԓәты нумәсԓәт, атәԓ пӑ хӑтәԓ сӑмәӈа Турма верәт верман. Щи пŏнәм нŏмәс урәӈән, Агриппа хон, ма иудейәтән нўрмәԓԓайәм. ");
INSERT INTO kca_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Мўйа пӑ нын ӑт рӑхты щира ԓўӈәтԓәԓән щит, мўй Турәм пӑрәм ŏтәт нŏх ԓыԓӈатәԓ? ");
INSERT INTO kca_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Йӑна, ма ищи нумәссәм, мӑнэм Назарет эԓты уԓты Иисус нэм йэщаԓт йэшащты ар мосәԓ. ");
INSERT INTO kca_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Щит ма щи Иерусалимән версәм: Турма йир верты ŏх икет эԓты йур ўйман, ма ар Турәм хŏйатәт касна хотәта тухрыԓысәм, пӑ, хун ԓыв пӑратысайәт, ма щийэԓ кашащисәм; ");
INSERT INTO kca_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Пӑ хŏԓ иудейәт пойәкщәты хотәтән ма ар пўш ԓывиԓаԓ шукатысԓам пӑ Иисус атма айәԓты иԉамтысԓам пӑ, ԓыв пеԓайэԓ шек ԉикащман, хŏԓна пӑ па мўв вошәтән ԋухәтԓысԓам. ");
INSERT INTO kca_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Тӑм урәӈән, йур пӑ Турма йир верты ŏх икет эԓты партәм вер тӑйман, Дамаска мӑнты питсәм, ");
INSERT INTO kca_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","хӑтәԓ кўтәпән йушән, йэшәк хон, ма турәм хӑр эԓты щимәщ нŏви шийаԓәсәм, хӑтәԓ эԓты артан нŏвийа пŏӈхәртәс. Ԓўв мӑнэм пӑ ма пиԓэмән йўвәм мŏхет нŏх хутԓәптәсԓы. ");
INSERT INTO kca_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Мўӈ хŏԓ мўва иԓ рӑкәтсув, пӑ ма тўр сый хуԓмәсәм, мӑнэма еврейәт йасәӈән пŏтәртәм тўр сый: 'Савл, Савл! Мўйа нӑӈ Мӑнэм ԋўхәԓԓэн? Нӑӈен карты йўщәӈ йўх пеԓа мӑнты ԓавәрт'. ");
INSERT INTO kca_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ма йастәсәм: 'Хŏй Нӑӈ, Турәм Куща?' Ԓўв йастәс: 'Ма - Иисус, Хŏйтэн нӑӈ ԋўхәԓԓән. ");
INSERT INTO kca_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Щӑԓта нӑӈ кўрԓана нŏх ԓойа; Ма щи урәӈән нӑӈ хŏщайэна этсәм, нӑӈен Ма верԓам верты хŏйата пӑ щит вантәм ŏта пŏнты, мўй нӑӈ ватсән пӑ мўй Ма нӑӈена ватәԓтәԓәм. ");
INSERT INTO kca_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ма нӑӈен иудей мирэн эԓты хŏԓт пайәтԓэм пӑ па рут мир эԓты, хŏйтат хŏща Ма нӑӈен ин китԓэм, ");
INSERT INTO kca_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ԓывиԓаԓа сэмԓаԓ пел пўшты, ԓыв пӑтлам эԓты нŏви пеԓа ат ӑӈкәрмәсәт пӑ хиԋ йур эԓты Турәм пеԓа, пӑ Мӑнэма эвәԓты верән кӑрэк йŏрэмәты щир пӑ йэмәӈа пайтәм мŏхет кўтән уԓты щир ат мŏщатсәт'. ");
INSERT INTO kca_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Щишән, Агриппа хон, ма турәм хӑр вантәпса эԓты йŏвра ӑт керԓәсәм, ");
INSERT INTO kca_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","туп оԓәӈән Дамаск пӑ Иерусалимән уԓты мŏхета, йухәт Иудея ԓŏватән уԓты мŏхета пӑ па рут мира пŏтәртсәм, ԓыв кӑрэк эԓты шӑшән ат керԓәсәт пӑ Турәм пеԓа ат керԓәсәт, кӑрэк эԓты шӑшән керԓәты арат ԓӑт тӑйты верәт верман. ");
INSERT INTO kca_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Щи урәӈән иудейәт мӑнэм Турәм Хотән ԋӑрэмәсэԓ пӑ лакки мӑншиты ўтщисэԓ. ");
INSERT INTO kca_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Туп, Турәмән ԋотәпән миймем кемән, ма тӑм хӑтәԓ унты ԓойԓәм, айәта пӑ унәта вантәм ŏта уԓман, нэмәԓты ӑт пŏтәртман, щи тўмпийән мўй эԓты Турәм айкеԓ туты хŏйатәт пӑ Моисей пŏтәртысәт, мӑтты щит питәԓ, ");
INSERT INTO kca_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","тŏрԓы ки, мӑтты Христоса шук туты мосәс пӑ, мет оԓӈа парәм эԓты нŏх ԓыԓәӈԓәмаԓ йўпийән, мўӈ мирэва пӑ па рут мира нŏви такан айәԓтты мосәс». ");
INSERT INTO kca_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Хун ԓўв щиты ԓўвеԓ ӑратысԓы, Фест сыйәӈ тўрән йастәс: «Павел, нӑӈ ŏхен атма йис! Ун утәԓтәпса нӑӈен ŏх атма йиты унты йŏхтәптәсԓы». ");
INSERT INTO kca_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","«Ӑнтом, йэшәк ԓӑтәӈ Фест», - ԓўв йастәс, - «Ма ŏхем атәм ӑнтом, туп тŏрԓы пӑ ошәӈ йасӈәт пŏтәрԓәм. ");
INSERT INTO kca_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Хон щи верәт эԓты уйәтԓәԓы, хŏй йэщаԓт ма тŏрԓы пŏтәртԓәм. Ма йэша нэш ӑт эвәԓԓәм, ԓўв эԓтэԓ мŏԓты иса тӑм эԓты сайԓәман ат уса, тӑм ӑнта щуӈән ус. ");
INSERT INTO kca_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Агриппа хон, Турәм айкеԓ туты хŏйатәта эвәԓԓән амўй? Уйәтԓэм, эвәԓԓән». ");
INSERT INTO kca_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Агриппа Павела йастәс: «Нӑӈ мӑнэм йэша нэш ӑт эвԓәптәԓэн, Христиана йиты урәӈән». ");
INSERT INTO kca_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Павел йастәс: «Ма Турәм пойәксэм ԓўԓән, шимәԓ мўй, ар мўй, ӑнтом туп нӑӈ, пӑ хŏԓ тӑм хӑтәԓ мӑнэм хуԓәтты ŏтәт, тӑмиты ат йисәт мўй хŏрпи ма, туп йӑрәм карты кеԓ такԓы». ");
INSERT INTO kca_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Хун ԓўв щит йастәс, хон пӑ куща ики, Вереника пӑ ԓыв пиԓԓаԓән опсәм ŏтәт нŏх ԓойсәт; ");
INSERT INTO kca_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","пӑ пўӈԓа йирԓәман, ԓыв кўтэԓән пŏтәртсәт: «Тӑм хŏйат сŏрәм кеша пӑ касна хот кеша нэмәԓты атәм ӑт верәԓ». ");
INSERT INTO kca_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Пӑ Агриппа Фест пеԓа йастәс: «Тӑм хŏйат эсәԓты кўш рӑхәс, кесарь эԓты сўт ӑт вохәс ки». Щишән куща ԓўвеԓ кесарь хŏща китты нŏмәс верәс. ");
INSERT INTO kca_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Хун мўӈева Италия мўва хопән мӑнты нŏмәс верса, Павел пӑ тухәԓ па опсәм ŏтәт Август когорта эԓты Юлий нэмпи сот ԉаԉ йох кущайа мӑсайәт. ");
INSERT INTO kca_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Мўӈ, Асия вошәт сӑхат мӑнты, Адрамит вош паршәӈ ун хопа ԓэԓтсув пӑ мӑтсув. Мўӈ пиԓэвән Аристарх, Македония ху, Фессалоника вош эԓты ус. ");
INSERT INTO kca_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Кимет хӑтәԓ Сидон хŏща хойсув. Юлий, Павел пиԓән йӑм щира ус, ԓухәсԓаԓ хŏща ԓўвеԓ йӑхты эсәԓсәԓы пӑ ԓыв ԓўв верԓаԓ эԓты ат нумәссәт. ");
INSERT INTO kca_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Щиԓта этман, йэщаԓт вот эԓты хŏнтаман, мўӈ Кипр пухәр вот сай пелкеԓ сӑхат мӑтсэв, ");
INSERT INTO kca_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","пӑ, Киликия пӑ Памфилия шŏма щарәс шŏппи ўшмев йўпийән, Ликия мўвән Миры воша йŏхәтсув. ");
INSERT INTO kca_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Щита сот ԉаԉ йŏх куща Александрия вош эԓты уԓты, Италия мўва мӑнты, паршәӈ ун хоп уйтәс пӑ мўӈев щи ԓэԓтсәԓы. ");
INSERT INTO kca_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ар хӑтәԓ сыс мўӈ айәԓта йэԓԓы мӑтсув пӑ мет йухәт, ўрайән Книд вош шŏма йŏхәтсув. Пӑ вот мўӈев мосты тӑха пеԓа мӑнты кумән ӑт мийԓысԓы, мўӈ Крит пухәр сайа Салмона нэмпи ԋŏԓ пеләк сӑхат ванамәсув. ");
INSERT INTO kca_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ԓўв мŏхтэԓ ўрайән ўратмев йўпийән, и тӑхайа йŏхәтсув, Йӑм Каԓтнаӈәта айәԓтԓа, щи ԉэпән Ласея вош ус. ");
INSERT INTO kca_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Мўӈ щи арат ар сыс уштәмев урәӈән пӑ мӑнты вер пӑԉщәма йиты питәс, иудейәт сўс вўщԓәты пŏра ўш хӑщәс, Павел ԓывиԓаԓа йастәс: ");
INSERT INTO kca_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Ма ваттэмән, мўӈ мӑнәпсайэв шек ԓавәрт питәԓ пӑ ун атәм тӑйты питәԓ ӑнта туп пŏрмасәта пӑ хопа, мўӈ уԓәпсайэва па». ");
INSERT INTO kca_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Туп сот ԉаԉ йох куща Павел йасәӈ эԓты сэвәс тӑйты хŏйата пӑ хопәӈ кущайа аршәк эвԓәс. ");
INSERT INTO kca_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Щи лух тӑԓ уԓты щирән атәм ус, пӑ ар хŏйат щиԓта йэԓ мӑнты нŏмәс мийԓысәт, верәтты кемән Финик вош унты мӑнты пӑ щита тӑԓ хӑщәптәты мосәԓ. Финик - щит Крит лух, нўм кев оԓәӈ пӑ ным кев оԓәӈ вот йэщаԓт ус. ");
INSERT INTO kca_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Нўм вот пŏԓты питәс, пӑ ԓыв нумәссәт мосты щир мŏщатсәт, хопән рупитты мŏхет йакарэԓ нŏх аԓәпсәт пӑ Крит ԉэп эԓты мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Туп йэшавуԓ пухәр эԓты ŏвәс пеԓа уԓты хӑԓэвәт пеләк так вотшики пŏԓты питәс, эвроклидона айәԓтты вот. ");
INSERT INTO kca_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Паршәӈ ун хоп щиты аԓэмәса пӑ ԓўв вот йэщаԓт мӑнты ӑт веритәс, пӑ мўӈ, хумпәта мийәсман, тыйэԓ-тŏхэԓ тутԓысайув. ");
INSERT INTO kca_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Мўӈ айшәк Клавда нэмпи пухәр вот сай пелкәԓа питсув. Щита мўӈ ўрайән ай хопев катәԓты верәтсэв. ");
INSERT INTO kca_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ай хопев нŏх аԓԓәммев йўпийән, паршәӈ хопән рупитты хŏйатәт щевма кеԓәт паршәӈ хоп иԓта таԓсәԓаԓ пӑ ԓўвеԓ лӑп йӑрсәԓәсэԓ. Сэй хишәӈ пана ӑт опсатты урәӈән, парәш иԓ эсәԓсэԓ пӑ щиты щи вотән тутԓысайув. ");
INSERT INTO kca_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Кимет хӑтәԓән, вотән паршәӈ хоп щиты йовәԓты питса пӑ ԓэԓтәм пормасәт ԓыв йиӈка иԓ йовәԓты питсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Хуԓмет хӑтәԓән пӑ мўӈ йоша-кўра хоп кеԓәт-ԋўрәт иԓ йовәԓты питсув. ");
INSERT INTO kca_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ар хӑтәԓ ӑнта най, ӑнта хусәт ӑт нысайәт пӑ так вот щиты пŏԓәс, мет йухәт хŏԓна мўӈ нŏх питты щира уԓты нŏпсэв лўттәсэв. ");
INSERT INTO kca_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Хŏйатәт хув нэмәԓтты ӑт ԓэсәт. Павел, ԓыв кўтэԓа ԓоймаԓ кемән, йастәс: «Йох! Мӑнэм хуԓәтты мосәс пӑ Крит эԓты пўӈԓа мӑнты ӑт мосәс, тӑмәщ шук пӑ накԓат нын ԓуԓән ӑт ватсәты. ");
INSERT INTO kca_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ин пӑ нынан такан йастәԓәм, нŏх тўӈмәԓтыйаты, нын эԓтан нэмәԓты хŏйат ӑт посаԓәԓ, туп паршәӈ хопев шўкаԓәԓ. ");
INSERT INTO kca_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Хӑщәм атән мӑнэма Турәм ангел этәс, Хŏй пеԓа ма уԓԓәм пӑ Хŏйа ма пойәкщәԓәм ");
INSERT INTO kca_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","пӑ йастәс: 'Павел, аԓ пӑԓа! Нӑӈена кесарь йэщаԓт ԓойты мосәԓ, пӑ Турәм Ԓўв Йӑмәԓән нӑӈен щи ԓŏват йӑм верәс, хŏԓ нӑӈ пиԓэнән уԓәм ŏтәта уԓәпса мойԓәс'. ");
INSERT INTO kca_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Щишән йох, нŏх тўӈмәԓтыйаты, ма Турма эвәԓԓәм, щиты питәԓ, хŏты мӑнэма йастаман ус: ");
INSERT INTO kca_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Мўӈ мӑтты пўхра ўты йўвәтты верэв уԓ». ");
INSERT INTO kca_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ԋӑԓхŏщйаӈмет атән, хŏты мўӈ Адриа щарәс хўват тутԓысайув, ат кўтәп кемән хопән рупитты йох мўв ший мŏштәты питсәт, иԓампа мӑтты мўва ванамәты питсув, ");
INSERT INTO kca_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","пӑ, ԓыв йик мӑԓат артаԓәсэԓ, пӑ хус ԓӑԓ ус, щӑԓта йэша ус мӑԓатәԓ па артаԓәсэԓ, пӑ ветхŏщйаӈ ԓӑԓ арат ус. ");
INSERT INTO kca_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Кевәӈ тӑхайа питты эԓты пӑԓман, ԋӑԓ йакар сэвәс эԓты иԓ вŏщкәсәт пӑ хӑтԓа йиты ԓавәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Хун пӑ хопәӈ мŏхет хопеԓ эԓты хŏнтаты ўтщисәт пӑ щарса ай хоп иԓ эсәԓсәт, щимәщ хŏрас верман, мӑтты хоп ԋŏԓ эԓты йакарәт иԓ эсәԓԓәт, ");
INSERT INTO kca_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Павел сот ԉаԉ йох кущайа пӑ ԉаԉ йохәта йастәс: «Ԓыв паршәӈ хопән ӑт хӑщԓәт ки, нын ԓыԓԓән этәԓтәты ӑт верәтԓәты». ");
INSERT INTO kca_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Щиӈәԋща ԉаԉ йохәт ай хоп кеԓәт шŏппи сэвәртсәԓаԓ, пӑ хоп иԓ рӑкнәс. ");
INSERT INTO kca_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Хӑтԓа йиты йэԓпийән Павел мŏхет хŏԓ ԓэты пойәксәԓы, йастәман: «Тӑм хӑтәԓ ԋӑԓхŏщйаӈмет хатәԓ, хŏты нын, ԓавԓәсман, нэмәԓты ӑт ԓэвман, ԓэтŏтԓы уԓԓәты. ");
INSERT INTO kca_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Щишән нынан ԓэтыйа пойәкԓыԓам: щиты нын уԓәпсайԓын шавиты туԓт; нэмәԓты ŏтԓән хŏща и ŏхсŏх нын ŏхԓән эԓты иԓ ӑт рӑкәнәԓ». ");
INSERT INTO kca_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Щит йастәмаԓ кемән пӑ ԋаԋ ўймаԓ йўпийән, ԓўв, хŏйатәт ватман, Турма пўмащипа йастәс пӑ, кӑтна мŏртмаԓ кемән, ԓэты питәс. ");
INSERT INTO kca_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Щиӈәԋща хŏԓыйэ каркама йисәт пӑ хŏԓыйэ ԓэты питсәт. ");
INSERT INTO kca_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Паршәӈ хопән мўӈ аратэвән кӑтсот ԓапәтйаӈ хут хŏйат усув. ");
INSERT INTO kca_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Хун хŏйатәт тӑрәмтыйа ԓэсәт, ԋаԋ ԓат сэми хирәт щарса йŏвәԓман, хоп кенапты питсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Хун хӑтԓа йис, ԓыв этәм мўв ӑт мŏштәсэԓ, туп мŏԓтты пан тӑйты йик лух шийаԓәсәт, щи хойты нŏмәс версәт, хойты верәтԓа ки. ");
INSERT INTO kca_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Щӑԓта, йакарәт нŏх ўйәм йўпийән, щарәс хўват мӑтсәт пӑ, сэвәс ԓупԓаԓ хŏԓт эхмеԓ кемән пӑ ай паршэԓ вот хўват нŏх аԓәммеԓ йўпийән, мўв питар пеԓа ԋŏхтәсэԓ. ");
INSERT INTO kca_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Пан ŏха хойсәт, пӑ хопеԓ сорәм тӑхайа опсәс. Ԋŏԓәԓ иԓ ԓŏӈәс пӑ ӑт ԋŏхԓыйәԓ, сэвсәԓ пӑ хўмпәтән пелки сэкԓа. ");
INSERT INTO kca_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ԉаԉ йохәт касна хота омәсты ŏтәт веԓты кашащсәт, мӑтты ŏт ўты ущман ӑт ат хŏнтас. ");
INSERT INTO kca_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Туп сот ԉаԉ йох куща, Павел ӑратыман, ԓывиԓаԓ щи верэԓ эԓты иԓ вŏԓәтсәԓы пӑ ущты хошты ŏтәта оԓӈа иԓ навәрмәты пӑ мўва ўты ущты партсәԓы, ");
INSERT INTO kca_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","па ŏтәта пӑ хŏйа сохәԓ сурән, хŏйа пӑ мŏԓтты паршәӈ хоп пелкәт сурән ўты йŏхтәптәты партсәԓы; щиты хŏԓыйэ йӑма питара ўшсәт. ");
INSERT INTO kca_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ўты пайтәсмеԓ йўпийән, Павел пиԓән уԓәм ŏтәт ŏша пайәтсэԓ, пухәр нэмәԓ Мальта. ");
INSERT INTO kca_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Пухәрән шŏшийа уԓәм па сыр хŏйатәт мўӈева йӑм арат ԋотәп версәт. Йэрт пӑ ищки уԓәм пӑтыйән, ԓыв тўт пŏтсәт пӑ хŏԓыйэ мўӈев вана вохсәԓаԓ. ");
INSERT INTO kca_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Хун пӑ Павел варәс аԓтэԓ ӑктәс пӑ тўта пŏныԓыйәс, ŏхты вой, тўт рўв эԓты хŏнтаман, ԓўв йошәԓа, пŏрэмәман, иԓԓы лўԋиты питәс. ");
INSERT INTO kca_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Хун пухрәӈ хŏйатәт, Павел йош эԓты ŏхты вой иԓԓы лўԋиты шийаԓәсәт, ԓыв кўтԓаԓән пŏтәртты питсәт: «Уйәтман, тӑм хŏйат веԓтатты ŏт: ԓўв щарәс эԓты нŏх питәс, туп вещкат ԓух сўт ԓўвеԓ ԓыԓӈа уԓты ӑт хӑйԓәԓы». ");
INSERT INTO kca_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Туп ԓўв, ŏхты вой тўта рӑԋкәмаԓ йўпийән, нэмәԓты атма ӑт хойәс. ");
INSERT INTO kca_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ԓыв ԓўвеԓ нŏх пўвԓәты мўй пӑ, шӑмкапан пӑрман, иԓ рӑкәнты ԓавәԓсэԓ; туп, хўв ԓавԓәсман пӑ ваттэԓән, нэмәԓт атәм сŏрта ӑт питәс, па щира нумәсты питсәт пӑ йастәԓәт, ԓўв иԓампа ԓух. ");
INSERT INTO kca_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Щи тӑха ԉэпән Публий нэмпи пухәр куща хотәт усәт. Ԓўв мўӈев вана ўсԓы пӑ хуԓәм хӑтәԓ мойԓәптысув. ");
INSERT INTO kca_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Публий ики ащи каврәма пӑ хŏнәԓ кӑшийа йўвман ŏԓтӑхайәԓән ŏԓәс. Павел ԓўв хŏщайәԓа ԓŏӈәс, пойәкщәс пӑ, ԓўв эԓтэԓ йошԓаԓ пŏнмаԓ кемән, ԓўвеԓ тўмтака версәԓы. ");
INSERT INTO kca_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Тӑм вер йўпийән пухәрән уԓты, муш тӑйты па мŏхет йŏхтыԓысәт пӑ тўмтака верыԓысайәт, ");
INSERT INTO kca_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ԓыв мўӈева ар йӑм вер версәт пӑ мӑнты питмевән мŏсты ŏтәтән мӑсайув. ");
INSERT INTO kca_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Хуԓәм тыԓәщ хӑщәм йўпийән мўӈ Александрия эԓты уԓты, Диоскуры нэмпи паршәӈ хопән мӑтсув, щи пухәр хŏща тӑԓ хӑщәптәс, ");
INSERT INTO kca_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","щӑԓта Сиракузы воша йŏхәтмев йўпийән, щита хуԓәм хӑтәԓ усув. ");
INSERT INTO kca_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Щиԓта мӑнмев йўпийән, Ригия воша йŏхәтсув. Йухәт хӑтәԓ нўм вот пŏԓты питәс пӑ кимет хӑтәԓән мўӈ Путеол воша йŏхәтсув, ");
INSERT INTO kca_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","хŏта хӑнам йохԓув уйәтсув, пӑ ԓыв хŏщайэԓ ԓапәт кем хӑтәԓ уԓты вохсайув, йухәт Рим воша мӑтсув. ");
INSERT INTO kca_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Щита уԓәм хӑнам йох, мўӈ эԓтэв хуԓмеԓ кемән, мўӈ йэщаԓтэв Аппий вош хӑр лот пӑ Хуԓәм Хоԓты Хот унты этсәт. Павел ԓывиԓаԓ шийаԓәмаԓ кемән, Турма пумащипа йасӈәт йастәс пӑ нŏпсәԓ такамәс. ");
INSERT INTO kca_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Хун пӑ мўӈ Рим воша йŏхәтсув, сот ԉаԉ йох куща йӑрәм ŏтәт ԉаԉ йох ун кущайа мӑсԓы, Павел пӑ атэԓ щира ԓўвеԓ ԓавәԓты и ԉаԉ ху пиԓән уԓты эсәԓса. ");
INSERT INTO kca_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Хуԓәм хӑтәԓ хащәм кемән, Павел иудейәт эԓты ԓӑтәӈ йŏх йӑха вохсәԓы пӑ, хун ԓыв йӑха йŏхәтсәт, ԓывиԓаԓа пŏтәртәс: «Хӑнам йох! Мирэма мўй пӑ ащиԓув щирәта нэмәԓты атәм ӑт кўш версәм, ма йӑрман Иерусалим эԓты Рим мŏхета мӑсайәм. ");
INSERT INTO kca_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ԓыв, мӑнэм сўт вермеԓ йўпийән, эсәԓты ўтщисэԓ, ма хŏщайэм сŏрәм ԓӑта нэмәԓты нўр ӑнтом; ");
INSERT INTO kca_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","туп иудейәт йасәӈԓаԓ кӑтна мӑнман уԓԓәт, мӑнэм кесарь эԓты сўт вохты вера йис, туп ӑнтом ма мирэм мŏԓты хŏща нўрәӈа верты урәӈән. ");
INSERT INTO kca_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Щи пӑтыйән ма нынан вохсәԓам, уйтантыты пӑ нын пиԓәнән пŏтрэмәты урәӈән, Израиль нŏмәс йэԓ пŏнты урәӈән, ма тӑмиты йӑрсайәм». ");
INSERT INTO kca_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ԓыв пӑ ԓўвеԓа йастәсәт: «Мўӈ нӑӈ эԓтэн ӑнта нэпек Иудея мўв эԓты йоша ўйԓысув, ӑнта йŏхтыԓыты хӑнам йохәт эԓты нэмәԓты хŏйат нӑӈ эԓтэн айкеԓ ӑт китыԓыйәс пӑ мŏԓты атәм йасәӈ ӑт йастыԓыйәс. ");
INSERT INTO kca_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Туп мўӈева нӑӈ эԓтэн хуԓты мосәԓ, хŏты нӑӈ нумәсԓән. Мўӈ уйәтԓэв, тӑм утәԓтәты вер эԓты кашәӈ тӑхайән ўра ворԓәт». ");
INSERT INTO kca_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Щӑԓта, ԓўвеԓа аԉәм хӑтәԓән, йӑм ар хŏйат ԓўв хŏщайәԓ хоԓты хотәԓа йŏхтәс; пӑ ԓўв аԓәӈсӑхат эԓты йэтән унты ԓывиԓаԓа Турәм Хон Уԓәпса эԓты пŏтәртәс. Вантәм верәт этәԓтыйәс пӑ ԓывиԓаԓ эвԓәптәман, Моисей Закон пӑ Турәм айкеԓ туты хŏйатәт нэпекәт эԓты ўйман, Иисус эԓты пŏтәртәс. ");
INSERT INTO kca_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Тухԓәт ԓўв эвԓәптәсԓы, па ŏтәт пӑ ӑт эвәԓсәт. ");
INSERT INTO kca_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Кўтԓаԓән ўра ворты питсәт, пӑ хун ԓыв мӑнты питсәт, Павел щимәщ йасӈәт йастәс: «Йэмәӈ Ԓыԓ Турәм айкеԓ туты хŏйат Исаия сӑхат мўӈ ащиԓува йӑма йастәс: ");
INSERT INTO kca_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","'Тӑм мир хŏща мӑна пӑ йасты: пӑԓԓәнән хуԓԓәԓән пӑ ӑт мŏштәԓԓән, пӑ сэмԓәнән ватты питԓәты пӑ ӑт шийаԓәԓԓән. ");
INSERT INTO kca_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Тӑм мŏхет сӑм вŏйән лӑп таԓса, пӑ пӑԓԓаԓән ўрайән хуԓԓәт, пӑ сэмԓаԓ лап хӑтщәсԓаԓ, сэмән ӑт шийаԓәты щира, пӑ пӑԓԓаԓән ӑт хуԓты щира, пӑ сӑмԓаԓән ӑт мŏштәты щира, пӑ Ма пеԓайэм ӑт керԓәты щира, Ма ԓывиԓаԓ тўмтака ӑт ат версәԓам'. ");
INSERT INTO kca_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Щиӈәԋща, нынана ԓэр ат питәԓ, Турәм нŏх пайәтты щир па рут мира китса: ԓыв щи хуԓԓэԓ». ");
INSERT INTO kca_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Хун ԓўв тӑм йастәс, иудей йох, ԓыв кўтэԓән такан ўра ворман, мӑтсәт. ");
INSERT INTO kca_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Щӑԓта Павел тӑԓаӈ кӑт тӑԓ сŏхәптәм хотәԓән ус пӑ хŏй ԓўв хŏщайәԓ йŏхтыԓыйәс, хŏԓ вана ўйԓысԓы, ");
INSERT INTO kca_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ԓўв, ӑт пӑԓман пӑ ӑт йэртԓыман, Турәм Хон Уԓәпса эԓты пŏтәртәс пӑ Турәм Куща Иисус Христос эԓты утәԓтәс.");
ALTER TABLE kca_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
