﻿USE sofia;
DROP TABLE IF EXISTS sofia.kby_vpl;
CREATE TABLE kby_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kby_vpl WRITE;
INSERT INTO kby_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Akko kitawu kaariya Isa Almasiwu tada Mai Daudaye, ti ye tada Nawi Ibrahimbedǝyedǝ: ");
INSERT INTO kby_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim Isakua kembo, Isaku ye Yakubaa kembo, Yakuba ye Yahuda-a awaanawanju-aa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ye Feres-a Jera-aa kembo, yanja Tamar, Feres ye Hesronna kembo, Hesron ye Aramba kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ye Aminadabba kembo, Aminadab ye Nashonna kembo, Nashon ye Salmonna kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ye Bowossa kembo, ya Bowosse Rahab, Bowos ye Abidaa kembo, ya Abidaye Rut, Abida ye Yisaia kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisai ye Mai Daudaa kembo. Mai Dauda Sulemanaa kembo, calan ya Sulemanayedǝ kamu Uriyaye, ");
INSERT INTO kby_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemana ye Rehobowamba kembo, Rehobowam ye Abiyaa kembo, Abiya ye Asaa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ye Yosafatta kembo, Yosafat ye Yoramba kembo, Yoram ye Wojiyassa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Wojiyas ye Yotamba kembo, Yotam ye Ahajua kembo, Ahaju ye Hejekiyassa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekiyas ye Manasea kembo, Manase ye Amonna kembo, Amon ye Josiyassa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiyas ye jaman yaudiyaa dunon cadane cidi Babilayero caadǝnadǝn Yekoniyas-a awaanawanju-aa kembo. ");
INSERT INTO kby_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngawo cidi Babilayero caadǝnayedǝlan, Yekoniyas Sheyaltiyella kembo, Sheyaltiyel ye Jerubabella kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubabel ye Abihudda kembo, Abihud ye Aliyakimba kembo, Aliyakim ye Ajorra kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajor ye Jadokka kembo, Jadok ye Akimba kembo, Akim ye Alihudda kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Alihud ye Aliyasarra kembo, Aliyasar ye Matanna kembo, Matan ye Yakubaa kembo, ");
INSERT INTO kby_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuba ye Isuwua kembo, Isuwudǝ kwa Merambe, Meram ye Isa tia Almasiwulan bowojaidǝa kembo. ");
INSERT INTO kby_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Adǝgaima Nawi Ibrahimlan tai har Mai Daudaro yadero am jamannja tiloa gadegade mewu deri dasaa, koro Mai Daudalan tai har jaman yaudiyaa cidi Babilayero caadǝnaro yadero mewu deri dasaa, koro jaman adǝn tai har tambo Almasiwuyero yadero mewu deri dasaa. ");
INSERT INTO kby_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Akko lawar tambo Isa Almasiwuye. Yanju Meramdǝ tǝmaji Isuwuye, amma kawu larusa cade rokko dasayiro, Ruhu Alaye cakke curoaro walyeno. ");
INSERT INTO kby_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isuwu tǝmajinjudǝ kam jirema, fuwu jamayen tia nanguro njakko cǝraannidǝro, asǝrlan tia kolduro nia ngoyeno. ");
INSERT INTO kby_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Adǝ karwunjun duwon, malaiya Kǝmandeye laa kǝnnasimlan tiro fǝlediye: «Isuwu kaduwu Mai Daudaye, bare Meramba kamuro ngoduro rinǝmmi, Ruhu Alayeman curoaro walyeno. ");
INSERT INTO kby_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tada kongwa cambi, ni ye tiro cu Isa yakke, dalilnjudǝ jamanjua biwunjalan cǝkkayi nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Adǝgaima awo Kǝmande kuren ci nawiyen wuljǝnadǝ wakkayeno. ");
INSERT INTO kby_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tiye: «Akko fero kǝlayakku kwa nojǝnni curo ngoje tada kongwa cambe tia Imanuwellan bowojai,» cǝnna, maana Imanuwelledǝ Ala andi-a rokko. ");
INSERT INTO kby_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kǝnǝmlan fayenniya, Isuwu awo malaiya Kǝmandeye tiro wuljǝgǝnadǝa cǝde Meramba kamuro ngoyeno. ");
INSERT INTO kby_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amma tia kamuro nojǝnni duwon, har tada kongwa cambe Isuwu tiro cu Isa kekko. ");
INSERT INTO kby_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jaman Isa bǝla Baitalami cidi Yahudiyayen tambǝnadǝn, Hirudus ti mai duwon, ilmuwu laa cidi adinnambe cijane Jerujalembo isane: ");
INSERT INTO kby_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«Nda ti Mai Yaudiyaye tambǝnadǝ? Sillowunju adinnamlan culuwuna ruiye tiro ambǝttuwuro kadiye,» cane keworo. ");
INSERT INTO kby_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mai Hirudus adǝa fangenniya, hangalnju caa ciyeno, am Jerujalembe samma ye ngai. ");
INSERT INTO kby_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Daji wurawa ɍimannaye-a malǝmba Attauraye-a sammaa bowoje ndaran Almasiwu tambiro kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tiro: «Bǝla Baitalami cidi Yahudiyayen, akko awo nawi kuren ruwujǝnadǝ: ");
INSERT INTO kby_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«“Ni Baitalami cidi Yahudaye, curo bǝlawa Yahudayedǝn darajanǝm gana gǝni, dalilnjudǝ curonǝmlaman mai culuwi, mai duwon jamani Israyilayea cunodidǝ.”» ");
INSERT INTO kby_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Daji Mai Hirudus asǝrlan ilmuwudǝa bowoje sa sillowudǝ tayiro fǝledǝgǝnadǝa cuwore tabbatkeyeranniya, ");
INSERT INTO kby_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","tayia Baitalamiro cunode tayiro: «Lenowo hangallayen tadadǝa manowo! Tia fanduwiya, lawar sukkudowo, wu ye lekko tiro ambǝtkǝkko!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mana maidǝyedǝa fangeranniya, ilmuwudǝ jawal ngojane leyera. Ledu cadi duwon, akko sillowu adinnamlan culuwe carunadǝ fuwunjaro koje leje, har na tadadǝ dǝganadǝa nayeyenniya, tak dayeno. ");
INSERT INTO kby_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sillowudǝa kerunniya, karwunja tai daje kǝjiyeno! ");
INSERT INTO kby_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Daji fadodǝro ngasaye tadadǝ-a yanju Meram-aa carune tungurumjane tadadǝro ambǝtkeyera. Ajanja kajane tiro dinar so, kaaji so, mir so kedo. ");
INSERT INTO kby_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Daji Kǝmande kǝnnasimlan tayia galaje bare na Mai Hirudussero waldanni yenniya, jawal gade ngojane lardunjaro walladara. ");
INSERT INTO kby_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ngawo ilmuwudǝ saptanayen, malaiya Kǝmandeye laa kǝnnasimlan Isuwuro fǝlediye: «Cine tadadǝ-a yanju-aa ngone Masarro kasowo lenowo, nadǝn har kawu mana njaddǝkkiro nammowo, dalilnjudǝ Mai Hirudus tadadǝa njejoro maji nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Daji Isuwu cije buneman tadadǝ-a yanju-aa ngoje Masarro lejane, ");
INSERT INTO kby_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nadǝn har karmo Mai Hirudussero napkera. Adǝgaima awo Kǝmande kuren ci nawiyen wuljǝnadǝ wakkayeno. Tiye: «Tadania Masarnin culuworo bowokkǝna,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mai Hirudus ilmuwudǝ tia jambajanaro asuyenniya, fum gǝrgaje wada ce kǝla sa ilmuwudǝ tiro tabbaccaanayen tadawa kongwa kǝrwu yindia-a yindi cadǝnni-a bǝla Baitalamiye-a bǝladeyanju-alan dasaana sammaa roro keyeso. ");
INSERT INTO kby_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Adǝgaima awo Kǝmande kuren ci Nawi Irimiyayen wuljǝnadǝ wakkayeno. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Bǝrni Ramayelan so lagaranne jauro fandi, Rahila diye yallanjuro cikkiri. Kanadi ta wajǝna, bawo bawojana nangaro,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngawo Mai Hirudus bawojǝnayen, Masarnin malaiya Kǝmandeye laa kǝnnasimlan Isuwuro fǝlediye: ");
INSERT INTO kby_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Cine tadadǝ-a yanju-aa ngone lardu Israyilawuyero waldǝnowo, am duwon tadadǝa roro njejoro majaidǝ sanuna nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Daji Isuwu cije tadadǝ-a yanju-aa ngoje lardu Israyilawuyero walladara. ");
INSERT INTO kby_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma Mai Arkilawus cuju bawanju Mai Hirudussero cidi Yahudiyayea cunodidǝro fangenniya, Isuwu nadǝro ngaworo riyeno. Daji Kǝmande kǝnnasimlan tia galayenniya, cidi Galileyero leje ");
INSERT INTO kby_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bǝla laa Najarat canidǝn napkeno. Adǝgaima awo Kǝmande kuren ci nawiyayen wuljǝnadǝ wakkayeno. Tayiye: «Tia kam Najarattelan bowojai,» canna. ");
INSERT INTO kby_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jaman adǝn Nawi Yahaya Kasalama fǝlediye karaa cidi Yahudiyayen jamaro kawuɍi cǝdde: ");
INSERT INTO kby_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Tǝmmowo, nodo bargaa Mai Samemaye del karǝnjǝna!» cǝni kǝrga. ");
INSERT INTO kby_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tima kam duwon Kǝmande kuren ci Nawi Ishayayen kǝlanjun mana cǝdǝnadǝ wo. Tiye: «Karaan kam laa kowo sapce: “Kǝmandero jawal dabbargǝnowo, koduramnju cǝkko dewo!” cǝne mawoji.» ");
INSERT INTO kby_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahayaye kajǝmunjudǝ kanduɍi kaɍimoyen caaada, canjanju ye ngirin tikkerǝna. Kǝmbonju ye kawi-a kǝmagǝn-a. ");
INSERT INTO kby_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Daji am bǝrni Jerujalembe-a lardu Yahudiyaye sammaye-a cidi bǝrǝm Jordaniye ngaye-a nanjuro isane ");
INSERT INTO kby_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","biwunja wuljane curo bǝrǝm Jordaniyen tayiro kasala tuwaye kiddo. ");
INSERT INTO kby_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yahaya Farisawa-a Sadusiya-a kada tayiro kasala tuwaye cǝddoro nanjuro isairo kirunniya, tayiro: «Nayi kaduwu fusiyayeso! Wundu nayia ajawu isidǝro kasoworo galanja? ");
INSERT INTO kby_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Awo tuwa jireye fǝlejisoa dewo! ");
INSERT INTO kby_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bare karwundon: “Andi kaduwu Nawi Ibrahimbe,” wulluwwi. Nayiro wulnjagakki, Alaye kǝnduwonju dongur kauye anilan Nawi Ibrahimbo kaduwu alaktuwuye mbeji. ");
INSERT INTO kby_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Akko kǝrmamaro bewodǝ fǝrdu kǝskayen gǝnaada. Kǝska fi duwon tada ngǝla cakkiwawodǝa caljane kannuro fijagai. ");
INSERT INTO kby_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Wudǝ tǝmmuwwa nangaro ingilan nayiro kasala ngeddǝkko, amma kam laa wua kǝnduwon kosǝna sunonju tuluwoma tikkǝni ngawonin isi. Tidǝ Ruhu Alaye-a kannu-alan nayiro kasala njaddi. ");
INSERT INTO kby_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mukkonjun kǝmo laladuramba na wasturamnjuyero ise algama-a kalaɍi-a firji. Algamanjudǝa culore bǝralan gǝnaji, amma kalaɍidǝa kannu tǝmmaro nuiwawolan warji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Daji Isa cidi Galileyen cije bǝrǝm Jordaniyero Nawi Yahaya tiro kasala cǝddoro kadio. ");
INSERT INTO kby_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yahaya tiro daptuwuro maje: «A! Awiro gǝle naniro isǝmidǝ? Ngǝlanjudǝ, nima diye wuro kasala sǝddǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Amma Isaye tiro: «Kǝrmadǝ kasadde, dalilnjudǝ awo jire sammaa diodǝ andiro jussǝna nangaro,» yenniya, Yahaya kasatkeno. ");
INSERT INTO kby_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tiro kasala cǝdde Isa ingidǝlan kiluwunniyama, same farakko fǝrǝmde Ruhu Alaye alama bullam gai tiro jǝpciyi kiro. ");
INSERT INTO kby_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Koro samelan kowo nukce: «Adǝma Tadani wo, tia raakkǝna. Tiramnin jauro karwuni kǝjijǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Daji Yiwulis tia jarapcoro Ruhu Alaye Isaa simojiye karaa dǝɍiro kiluwo. ");
INSERT INTO kby_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kawu fidewuro bune-a kausu-aro asem kidanniya, kǝna tia kida. ");
INSERT INTO kby_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Daji Jaraptumadǝ nanjuro ise tiro: «Ni Tada Alayea, dongur kauye aniro wulgǝne kǝmboro walja!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Isaye: «A'a, kitawulan ruwuwada: “Kam kǝmbo baslan gǝni, mana Ala wuljǝna samman dǝgai,”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Koro Yiwulis tia bǝrni tayirro cade loiloiram Fado Alayen gǝnayenniya, ");
INSERT INTO kby_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tiro: «Ni Tada Alayea, sǝktǝne cidiro yukkure! Awoa kitawulan ruwuwada: “Ala kǝlanǝmnin malaiyawanjuro wada ce mukkonjan kamnjagai bare sinǝm kauro gǝmdǝgǝnniro,”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isaye tiro: «A'a, kitawulan ruwuwada: “Bare Ala Kǝmandea rijammǝmmi!”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Koro yaye Yiwulis tia kǝla kau kuruwu fet laayero cade tiro larduwa duniaye samma-a darajanja-aa fǝleyeyenniya, ");
INSERT INTO kby_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","tiro: «Ngunǝme wuro sujada sǝddǝmia, ani sammaa niro njikki!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Daji Isaye tiro kalakciye: «Nani kolle, Yiwulis! Kitawulan ruwuwada: “Ala Kǝmandero sujada yidde, ti tilonjuro ambǝtkǝne!”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Daji Yiwulis tia kolyeno, malaiyawa ye isane tiro kiskeyera. ");
INSERT INTO kby_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Isa Nawi Yahayaa kosoro casakkǝnaro fangenniya, cidi Galileyero wallada. ");
INSERT INTO kby_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bǝla Najarattea kolje leje bǝrni laa Kafarnaam canilan napkeno, bǝrni duwon ci bǝrǝmben cidi Jabulonne-a Naptaliye-alan dǝganadǝ. ");
INSERT INTO kby_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Adǝgaima awo Kǝmande kuren ci Nawi Ishayayen wuljǝnadǝ wakkayeno. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Cidi Jabulonne-a Naptaliye-a kanji jawal bǝrǝmbe na ci gade bǝrǝm Jordaniyen tiro Galile cidi kǝrdiyaye canidǝlan, ");
INSERT INTO kby_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","am curo duwuyen dasaanadǝ nur kura laa caruna, koro tayi curo kaudi karmoyen dasaanadǝ yea nur wassǝna!» ");
INSERT INTO kby_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sa adǝn Isa jamaro kawuɍi kǝji wulduwu badiyeno. Tiye: «Tǝmmowo, nodo bargaa Mai Samemaye del karǝnjǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yim laa Isa ci bǝrǝm Galileyea jǝgai duwon, yaana yindi Siman tiro Biturus cani-a yanjugǝna Andarawus-a buni taramnja bǝrǝmdǝro fijagai kiro. Tayidǝ buni tawu. ");
INSERT INTO kby_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Isaye tayiro: «Arowo wua sǝgaiwo, nayia kam tawuro njadǝkki!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sadǝman buni taramnja koljane tia geya. ");
INSERT INTO kby_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Koro nadǝn fuwuyenniya, yaana yindi gade ye Yakuba tada Jabadiye-a yanjugǝna Yahaya-a bawanjan kundenno curo maarayen buni taramnja caassai kiro. Tayia bowoyenniyama, ");
INSERT INTO kby_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","cijane maaradǝ-a bawanja-aa koljane tia geya. ");
INSERT INTO kby_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Daji Isa bǝla bǝlaro leje dandalnjan jamaa alamje kawuɍi kǝji nodo bargaa Alaye wuljiyi, am dondia kasuwanja jiɍi fi yayen isangajiyi ngai duwon, cidi Galileye sammaa diriyeno. ");
INSERT INTO kby_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Adǝgainin lawarnju cidi Siriye ngaro tatargaada. Koro am larduyedǝ amnja kasuwaa-a kǝndondi jiɍi jiɍia-a karuwaa-a sedan koroyea-a tiyi canaa-a sammaa Isaro cakkude isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jama kada tia geya, laanja cidi Galileye, laa cidi Bǝlamewuye, laa bǝrni Jerujalembe, laa cidi Yahudiyaye, laa ye ngawo bǝrǝm Jordaniye. ");
INSERT INTO kby_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Isa jama kada kadami captairo kirunniya, kǝla kau kuruwu laayero juwane napkeno. Fuwurawanju ye nanjuro kadira. ");
INSERT INTO kby_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Daji tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Barganja am karwulan talaawadǝ, nodo bargaa Mai Samemayedǝ nuwanjadǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Barganja am kǝrma cesiridǝ, fuwun simalonja bawodǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Barganja am rokura bawoadǝ, fuwun dunia warasajaidǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Barganja am kǝrma kǝna-a ngudu-aaro jire dioro ngǝnǝptaimadǝ, fuwun kuljaidǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Barganja am kanjimaɍimasodǝ, fuwun kanjimaɍi cawandidǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barganja am karwu bulladǝ, fuwun Alaa caruidǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Barganja am kǝrma nanlewa cawudidǝ, fuwun tadawa Alayelanbowodaidǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Barganja am kǝla jire dionjayen tayia basarjaidǝ, nodo bargaa Mai Samemayedǝ nuwanjadǝro. ");
INSERT INTO kby_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Am wu nangaro nayia raranjane basarnjane diwindo jiɍi jiɍi wuljaiya, bargando! ");
INSERT INTO kby_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kǝji dama baworo fannowo, dalilnjudǝ samelan mukowando jauro ngǝwu nangaro. Nonowo, adǝgaiman nawiya kureye burwonjanadǝa basaryera. ");
INSERT INTO kby_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Nayima manda duniaye wo. Amma mandadǝ kǝlambo walyenoa, jiɍi fin gǝle cayenju gairo walji? Awimaro faidajiwawo, tia deyan yirjane am guguwaccai. ");
INSERT INTO kby_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nayima nur duniaye wo. Bǝrni kǝla kau kuruwuyen dǝganadǝ gǝradiwawo. ");
INSERT INTO kby_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wunduma fatǝla wasse kǝmon tǝmjiwawo. Kam fatǝla wassiya, kǝla gǝnaduramnjuyen gǝnaje fadodǝn wundusoro nur ci. ");
INSERT INTO kby_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Adǝgaima nayi ye kollowo nurndo fuwu amben wasso, awo ngǝla diwidǝa caro Bawando Mai Samemaro daraja cadoro! ");
INSERT INTO kby_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Bare awo Attaura-a kitawuwa nawiyaye-alan ruwuwadadǝa baworo dioro kadikkoro tǝmanuwwi. A'a, tayia baworo dioro gǝni, tayi samma wakkajaro kadikko. ");
INSERT INTO kby_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jiremaro nayiro wulnjagakki, kawu same-a cidi-a baworo waljaimaro, arawu bi sǝkkal falma Attauralan baworo waljiwawo, sai tayi samma wakkajaiya duwon. ");
INSERT INTO kby_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wundu duwon wadawa aniye gananjaa ga waje am gade yea ngai alamjidǝ, curo am nodo bargaa Mai Samemayen tia kam daraja jauro ganaalan bowojai. Amma wundu duwon wadawa ania jǝgane am gade yea jaaro alamjidǝ, curo am nodo bargaa Mai Samemayen tia kam daraja kuraalan bowojai. ");
INSERT INTO kby_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Adǝ nangaro nayiro wulnjagakki, malǝmba Attauraye-a Farisawa-aa jire diolan konuwwawoa, tǝmmaro nodo bargaa Mai Samemayero ngawuwwawo. ");
INSERT INTO kby_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Amwurawande jaman kureyero: “Bare ro kambe tuluwummi, wundu duwon ro kambe cuttuluwunadǝa shararo caadi,” cane wuljaanadǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma wu nayiro wulnjagakki, kam kamanjuro gǝrgajǝgǝnadǝa shararo caadi. Koro kam kamanjuro “Kam bowuye!” cǝne rajǝnadǝa majilis adinwuyero caadi. Koro kam duwon kamanjua waje tiro: “Batti!” cǝnnadǝa kannu jaanamayero koljagai. ");
INSERT INTO kby_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Adǝ nangaro na laya duwaduramben sadaa njǝddoro isǝmma duwon, awo kuttu laa kamanǝmbo yiddǝmmaa tangǝmia, ");
INSERT INTO kby_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","fuwu laya duwaduramdǝyen sadaanǝmdǝa kolle lene ni-a kamanǝm-a solodǝnowo duwon, daji waldǝne are sadaanǝm yidde. ");
INSERT INTO kby_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Shararambo lawalamanǝm-a rokko ledu diwi duwon, kǝla jawallen doiro kowoɍi de tawaktǝne, bare nia alkaliro sǝrǝnnjǝgǝnniro. Adǝ gǝnia, alkali nia mukko sojiyero njakke, soji ye nia kosolan jannjiyi. ");
INSERT INTO kby_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jiremaro niro wulnjǝgǝkki, nadǝn wuɍi njǝgaidǝa cotto rǝmbǝmmia, tǝmmaro luwumbawo! ");
INSERT INTO kby_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Koro tayiro: “Bare kǝnjǝna dimmi,” cane wuljaanadǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma wu nayiro wulnjagakki, wundu duwon kamua cure mangarjǝnadǝ, karwunjun kǝnjǝna cǝdǝna. ");
INSERT INTO kby_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Simmǝm kǝmboramdǝ njakke biwu dimia, tia kulaine gǝmme. Tiyinǝm samma kannu jaanamayero fidiyidǝroa, sim fal fuddǝmmadǝma niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Koro mukkonǝm kǝmboramdǝ njakke biwu dimia, tia kamme gǝmme. Tiyinǝm samma kannu jaanamayero fidiyidǝroa, mukko fal fuddǝmmadǝma niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Koro waldane tayiro: “Kam kamunjua dǝpcidǝ tiro kakkadu kamu dǝptaye co,” cane wuljana. ");
INSERT INTO kby_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma wu nayiro wulnjagakki, wundu duwon kamunjua kǝla kǝnjǝnayen gǝni dǝpcǝnadǝ tia kǝnjǝnamaro cǝdǝna. Koro wundu duwon kamu dǝpkadaa niyajǝnadǝ, ti ye kǝnjǝna cǝdǝna. ");
INSERT INTO kby_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Koro amwurawande jaman kureyero: “Bare bowuro kansi bummi, kansi Kǝmandero yibbummadǝa de!” cane wuljaanadǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma wu nayiro wulnjagakki, bare tǝmmaro kansi buwwi! Bare sameyen kansi buwwi, Alaye kurisnju kǝrmaiye nangaro, ");
INSERT INTO kby_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","bi cidiyen, si gǝnaduramnju nangaro, bi Jerujalemben, bǝrni Mai Kuraye nangaro. ");
INSERT INTO kby_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Koro bare kǝlandoyen kansi buwwi, ranguwe kanduɍi kǝlandoye falmaa bul bi cǝlǝmbo diwwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngǝlanjudǝ “Aaa,” bi “A'a,” wullowo. Awi yaye adǝa kojǝnadǝ na ti Kǝladoyen kadio. ");
INSERT INTO kby_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Koro tayiro: “Kam laa sim bi timi kamanjuye fal kittuluwoa, simnju bi timinju fal ye cattuluwo!” cane wuljaanadǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma wu nayiro wulnjagakki, bare kam kǝlado wanuwwi. Kam laa feɍinǝm kǝmboram maɍin bakcia, wailadǝ yea tiro kalakkǝne. ");
INSERT INTO kby_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Koro kam laa gǝmajenǝm moworo nia shararo njadi cǝnia, kolle garinǝmdǝ yea ngojo. ");
INSERT INTO kby_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kam laa dunodunon njakke na kilometǝr fallaro lenǝmia, na kilometǝr yindiaro ti-a rokko lenowo. ");
INSERT INTO kby_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kam njuworǝnamadǝro ye, koro kam nanǝmnin tagari cǝraanadǝro bare dapkǝmmi. ");
INSERT INTO kby_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Koro tayiro: “Kǝmaskinǝmba raye, kǝladonǝmba wane,” cane wuljaanadǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma wu nayiro wulnjagakki, kǝladowandoa rawowo, koro am nayia basarnjanadǝ yero Alaa yukkorowo, ");
INSERT INTO kby_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ngainin tadawa Bawando Mai Samemayero walluwi. Dalilnjudǝ Ala cakke kǝngal am ngǝla-a diwi-aa wassi, koro ingi sameye ye jirewu-a jirenambuwu-aro cudduri nangaro. ");
INSERT INTO kby_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Am nayia njaraanaa raawia, awi mukowaye diw? Akki mowomaso ye ngai gǝna cadi? ");
INSERT INTO kby_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Koro kǝramiyando runjaa lewanuwia, awi gǝle am gadesoyea kojǝna diw? Kǝrdiya ye ngai gǝna cadi? ");
INSERT INTO kby_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adǝ nangaro Bawando Mai Samemadǝ kalkallo diomadǝ gai, nayi ye kalkallo diowuro wallowo! ");
INSERT INTO kby_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Hangal gǝnanowo, bare kǝndondo jireye federo jama nayia njaroro diwwi. Adǝ gǝnia, mukowa na Bawando Mai Samemayen fanduwwawo. ");
INSERT INTO kby_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Adǝ nangaro sadaa talaawaro yiddǝmiya, bare mǝnafǝkkaso gai am gadero awo dimmadǝa wulgǝmmi. Tayidǝ dandal so, farsam solan am tayia caro daraja cadoro sadaa cadi. Jiremaro nayiro wulnjagakki, nuwanja cawandǝna. ");
INSERT INTO kby_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma nidǝ sadaa talaawaro yiddǝmiya, bare mukkonǝm waila awo mukkonǝm kǝmboram cǝdidǝa nojǝnni, ");
INSERT INTO kby_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","sadaanǝmdǝ asǝrlan tǝdo. Daji Bawanǝm asǝrlan curuidǝ niro mukowa nji. ");
INSERT INTO kby_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Moduwa dimiya, bare mǝnafǝkkaso cadidǝ gai dimmi. Tayidǝ dandal so, farsam solan daada am tayia caroro moduwa cadiya, caraana. Jiremaro nayiro wulnjagakki, nuwanja cawandǝna. ");
INSERT INTO kby_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma nidǝ moduwa dimiya, ngimmǝmbo ngaye cinnadǝa jange Bawanǝm turuiwawodǝa kore. Daji Bawanǝm asǝrlan curuidǝ niro mukowa nji. ");
INSERT INTO kby_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Koro moduwa diwiya, bare kǝrdiyadǝ gai awo falla ngǝwuro wuwulluwwi. Mananja ngǝwu nangaro Ala tayia fanjiro tǝmajai. ");
INSERT INTO kby_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bare tayi gairo walluwwi, dalilnjudǝ kawu tia koruwidǝmaro Bawando mǝradundosodǝa nojǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Akko ngainin moduwa dewo: «“Bawande Mai Samema, cunǝmbo daraja tio! ");
INSERT INTO kby_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nodonǝm bargaa iso! Awo raamma dunian tǝdo, jiɍi same yen tǝdidǝ gai! ");
INSERT INTO kby_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Andiro kǝmbonde kuye sade. ");
INSERT INTO kby_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Biwunde gawursagane, andi ye am biwu saddǝnadǝa gawurniyenadǝ gairo. ");
INSERT INTO kby_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bare kolsame jaraptiyende, Kǝladodǝro kasane. Nodo-a kǝnduwo-a daraja-a har abadaro kaanǝmdǝma. Amin.” ");
INSERT INTO kby_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Nonowo, am biwu njaddǝnadǝa gawurnuwia, Bawando Mai Samema nayi yea gawurnjai. ");
INSERT INTO kby_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma tayia gawurnuwwawoa, Bawando ye biwundo gawurjiwawo. ");
INSERT INTO kby_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Asem diwiya, bare mǝnafǝkka cadidǝ gai fǝkkando dinuwwi! Tayidǝ am asemnja caroro fǝkkanja faljai. Jiremaro nayiro wulnjagakki, nuwanja cawandǝna. ");
INSERT INTO kby_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma nidǝ asem dimiya, kǝlanǝm ye kǝndawulan samme, fǝkkanǝm ye lamme, ");
INSERT INTO kby_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bawanǝm turuiwaworo kajia, bare wunduma asem dimiro nojǝnniro. Daji Bawanǝm asǝrlan curuidǝ niro mukowa nji. ");
INSERT INTO kby_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Bare kǝlandoro arsiyi dunialan cammuwwi, na duwon kanam-a diwuram-a bannajai, barwuso ye faljane ngasaye ngojaidǝ. ");
INSERT INTO kby_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kǝlandoro arsiyi samelan cammowo, na duwon kanam-a diwuram-a bannajaiwawo, barwuso ye faljane ngasaye ngojaiwawodǝ. ");
INSERT INTO kby_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nonowo, na arsiyindo dǝganadǝman karwundo ye kǝrga. ");
INSERT INTO kby_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Simdǝ tima fatǝla tiyiye wo. Simmǝm ngaa, tiyinǝm samma ye nurraro walji. ");
INSERT INTO kby_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma simmǝm jaujia, tiyinǝm samma ye duwuaro walji. To, nur nilan dǝganadǝ duwua, duwu adǝ jaumaro kura, diye! ");
INSERT INTO kby_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Wunduma rakce wolodi kam yindiyero waljiwawo. Bi fal waje fal cǝrayi, bi fal bǝrsǝmje fal ruji. Nayi ye ranguwe wolodi Ala-a wuɍi-ayero walluwwawo. ");
INSERT INTO kby_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Adǝ nangaro nayiro wulnjagakki, bare kǝla awo rondoro buwi-a yawi-ayen bi kǝla awo tiyindoro yakkuwiyen karwungai diwwi. Rodǝ kǝmboa kojǝna, koro tiyidǝ ye kajǝmua kojǝna, gǝna? ");
INSERT INTO kby_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngudowa sameyea ruiwo, kulo ye canadiwawo, kala ye cadiwawo, koro nema ye jawulan capcaiwawo yaye, Bawando Mai Samema tayia ambaji. Nayidǝ jauro ngudowaa darajan konuwwa, gǝna? ");
INSERT INTO kby_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wundundo gǝle rakce karwungainjulan sa fal kawunjuro cǝrgai? ");
INSERT INTO kby_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Koro awiro kǝla kajǝmuyen karwungai diwi? Fǝɍeso karaaye jiɍi ɍijaidǝa ruiwo, ngǝnǝpcaiwawo, koro caa cadiwawo. ");
INSERT INTO kby_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amma nayiro wulnjagakki, Mai Sulemana jauro darajaa yaye, ngaltema kajǝmu fǝɍe aniye falnjaa nanshawan najǝgǝna cakkǝnni. ");
INSERT INTO kby_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ala fǝɍeso ku karaan ɍijai baɍi kannuro fijagai ania ngai jakcidǝ, fagatto nayi yea jannjai, nayi kambǝrse ganaadǝ! ");
INSERT INTO kby_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Adǝ nangaro bare kǝla awo aniyen karwungai diwwi, bare kǝlandoro: “Awi gǝle buiye?” bi “Awi gǝle yaiye?” bi “Awilan gǝle tiyinde jangiye?” wulluwwi. ");
INSERT INTO kby_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kǝrdiyaso awo ania majai, amma Bawando Mai Samema nayi ye awo ani samman mǝradundoaro nojǝna. ");
INSERT INTO kby_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Attǝroa, nodo bargaa Alaye-a jirenju-a manowo duwon, awo ani samma yea nayiro njadi. ");
INSERT INTO kby_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adǝ nangaro bare karwungai baɍiye diwwi, karwungai baɍiyedǝ kuye gǝni. Ku nguson suwol kaanjua. ");
INSERT INTO kby_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Bare wundumaro shara yidduwwi, nayi yero shara njaddiwawo. ");
INSERT INTO kby_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jiɍi ambo shara yidduwidǝ gai, nayi yero shara njaddi. Koro jiɍi ambo ngalgǝwidǝ gai, nayi yero ngalnjagai. ");
INSERT INTO kby_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Awiro kalǝm sim kamanǝmben rumi duwon, karjǝm curo simmǝmben asunǝmbawodǝ? ");
INSERT INTO kby_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Akko ni simmǝmlan karjǝmbadǝ, awiawin gǝle kamanǝmbo: “Kolle kalǝm simmǝmbedǝa tuluwukke,” nǝmi? ");
INSERT INTO kby_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mǝnafǝk, karjǝm simmǝmbedǝa tuluwumiya duwon, daji ngǝlaro rume kalǝm sim kamanǝmbedǝa tuluwumi. ");
INSERT INTO kby_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Bare awo tayirdǝa kǝriyaro yiwwi, koro bare awondo darajaa fuwu aladeyayen kolluwwi. Kolluwiya, tayia guguwaccai, kǝriya ye suwordane nayia njanjannjai. ");
INSERT INTO kby_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Korowo njadi, manowo fanduwi, cinna bangowo kanjagai. ");
INSERT INTO kby_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wundu duwon cuworimadǝro cadi, kam majimadǝ ye cuwandi, koro kam cinna bakcimadǝ yero kajagai. ");
INSERT INTO kby_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Wundundo tadanju tia burodiro cuworiya, dongur kauye cidǝ? ");
INSERT INTO kby_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bi buniro cuworiya, kadi cidǝ? ");
INSERT INTO kby_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nayi diwiso awowa ngǝla tadawandoro njo nonuwwaa, balle Bawando Mai Samema awowa ngǝla am tia caworiro cidǝ! ");
INSERT INTO kby_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Adǝ nangaro awo duwon amso nayiro njaddiya raawwadǝa nayi ye tayiro yiddowo! Adǝma maana Attaura-a kitawuwa nawiyaye-aye wo. ");
INSERT INTO kby_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Ngaworam jǝkkadǝyen ngawowo, dalilnjudǝ ngaworam farak, jawalnju ye kǝskedǝ, tima ngaworam kannuyedǝ wo, koro am tiyen ngasayidǝ kada. ");
INSERT INTO kby_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amma ngaworam jǝkka, jawalnju ye jaudǝ, tima ngaworam ro sawisoyero cadimadǝ wo, koro am tia cawandidǝ ganama. ");
INSERT INTO kby_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Nawiya kattuwuyero hangal gǝnanowo! Tayidǝ nandoro isaiya, alamanja dimi gai, amma karwunja jauro diwi bulduye gai. ");
INSERT INTO kby_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tada casakkidǝlan tayia asunuwi. Inab coccoɍilan njakcai wa? Koro tarmu kolollan cadori wa? ");
INSERT INTO kby_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kǝska ngǝla nguson tada ngǝla cakki, koro kǝska diwi ye tada diwi cakki. ");
INSERT INTO kby_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kǝska ngǝladǝ rakce tada diwi cakkiwawo, koro kǝska diwidǝ ye rakce tada ngǝla cakkiwawo. ");
INSERT INTO kby_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kǝska fi duwon tada ngǝla cakkiwawodǝa caljane kannuro fijagai. ");
INSERT INTO kby_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Adǝ nangaro tadanjalan tayia asunuwi. ");
INSERT INTO kby_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Am wuro: “Kǝma! Kǝma!” cani samma gǝni nodo bargaa Mai Samemayero ngasayi, sai kam awo Bawani Mai Samema cǝraanaa cǝdimadǝ. ");
INSERT INTO kby_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yim adǝn am ngǝwu wuro: “Kǝma, Kǝma, cunǝmlan nawinawi kidiye, cunǝmlan sedanso duyeiye, koro cunǝmlan awo ajabba kada ye kidiye, gǝna?” cani. ");
INSERT INTO kby_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Daji wuye tayiro: “Ngaltema nayia nonjakkǝni. Nayi diwi diomaso, wun kuruwunno lenowo!” nǝkki. ");
INSERT INTO kby_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Adǝ nangaro wundu duwon manani ania fanje jǝganamadǝ, ti alama kam hangalla soronju kǝla kauyen cǝdandǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ingi sameye cudure bǝrǝm fala tarje, karuwa ye cije sorodǝa babakkenniya, sorodǝ wurdǝnni, dalilnjudǝ fǝrdunju kǝla kauyen tǝdandǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amma wundu duwon manani ania fanjǝna jǝgannimadǝ, ti alama kam hangal bawoa soronju kǝla cidi kesayen cǝdandǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ingi sameye cudure bǝrǝm fala tarje, karuwa ye cije sorodǝa babakkenniya, wurde tǝgǝmbo fiyada,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Isa mana ania cǝde kerǝnniya, jama captanadǝ alamdunjudǝa ajapkera, ");
INSERT INTO kby_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dalilnjudǝ malǝmbanja Attauraye gai gǝni, kǝnduwoaro tayia alamji nangaro. ");
INSERT INTO kby_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Isa kǝla kaudǝyen jǝpkenniya, am kada kadami tia geya. ");
INSERT INTO kby_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kam barasua laa ise fuwunjun tungurumje tiro: «Kǝma, raammaa, rangǝme wua isangasǝgǝme tayirro wallǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isa mukko sajiye kamdǝa leje: «Raakkǝna, tayirro walle!» yeno. Sadǝman barasudǝ tia kolje tayirro walyeno. ");
INSERT INTO kby_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Daji Isaye tiro: «Bare wundumaro adǝa wulgǝmmi, amma lene ɍimandǝro fǝledǝgǝne, koro sadaa Nawi Musa wuljǝnadǝa de, jamaro shedaro waljo!» ");
INSERT INTO kby_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Isa bǝrni Kafarnaambero kǝrgaanniya, soji kura Rombe laa nanjuro ise tia lowoje: ");
INSERT INTO kby_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Kǝma, kaɍeani dondi fadon bowada, tiyinju nuna jauro basardi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Isaye tiro: «Lekke tia isangagǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amma soji kuradǝye tiro: «Kǝma, nia fannin sawo tikkǝni. Biya wada ye, kaɍeani ngaji. ");
INSERT INTO kby_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wudǝ cidiya kǝnduwo amben kǝrgakko, fǝrduni yen sojiya takkǝna. Falnjaro: “Lene!” nǝkkiya, leji. Fal laaro: “Are!” nǝkkiya, isi. Koro kaɍeaniro: “Adǝa de!” nǝkkiya, cǝdi.» ");
INSERT INTO kby_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isa adǝa fangenniya, ajapce jama tia jagaidǝro: «Jiremaro nayiro wulnjagakki, curo jama Israyilayen kambǝrse kura adǝ gai fandǝkkǝni! ");
INSERT INTO kby_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nayiro wulnjagakki, am kada adinnam-a fǝde-alan isane Nawi Ibrahim-a Nawi Isaku-a Nawi Yakuba-a rokko nodo bargaa Mai Samemayen masǝna dioro napcai. ");
INSERT INTO kby_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma tadawa nodo bargaayedǝa deyan curo duwu cǝlǝm pǝttero gǝpcagai, nadǝn so ye tǝdi, sheɍi ye naldi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Daji Isaye soji kuradǝro: «Lene, kambǝrsenǝm nangaro, awo suworǝmmadǝ niro wakkanjuwo!» yeno. Kaɍeanjudǝ sa adǝman ngayeno. ");
INSERT INTO kby_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Isa fado Biturussero kadinniya, ya kǝsai Biturusse kangea bowada kiro. ");
INSERT INTO kby_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Isa mukkonju leyenniya, kangedǝ tia kolje, ti ye cije Isaa sosadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yim adǝa kǝngal kikkurǝnniya, bǝrniwudǝ karuwamaso kada na Isayero kewudo. Mananjulaman sedannadǝa duyeno, koro am dondi sammaa isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Adǝgaima awo Kǝmande kuren ci Nawi Ishayayen wuljǝnadǝ wakkayeno. Tiye: «Kǝndondinde kǝlanjuro ngoje kasuwanden isangaseyera,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yim laa Isa jama kada tia dirijane kǝljanadǝa kirunniya, fuwurawanjuro wada bǝrǝmdǝa faldaye kaino. ");
INSERT INTO kby_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Daji malǝm Attauraye laa nanjuro ise tiro: «Sayinna, ndara lenǝmi yaye nia njǝgakki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isaye tiro: «Kǝluwuso bǝlaanjaa, ngudoso sameye ye fannjaa, amma Tada Kambedǝ nanju tustuyema bawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Koro fuwuranju laa ye tiro: «Kǝma, amarsǝgǝne lekke bawania sittǝrakkiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amma Isaye tiro: «Wua sǝgai, kolle am sanuna amanja sanunadǝa sittǝraja!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isa curo maarayero kǝrgaanniya, fuwurawanju ye tia jaane kasargawo. ");
INSERT INTO kby_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sadǝman karuwa dunoa cije ingi bǝrǝmbe cambalje, har ingi maaradǝro fiduwu badiyeno. Sadǝn Isa kǝnǝm cǝdi. ");
INSERT INTO kby_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Fuwurawanjudǝ isane tia kǝnǝmnin kesangǝranniya, tiro: «Kǝma, andia samoye, nuiye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Isaye tayiro: «Awiro yaayew, nayi kambǝrse ganaadǝ?» yeno. Daji cije karuwadǝ-a bǝrǝmdǝ-aro kikkadǝnniya, dajane dunia gǝmbo walyeno. ");
INSERT INTO kby_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Fuwurawanjudǝ ajapcane: «A! Kam jiɍi fi attǝ? Karuwa-a bǝrǝm-ama mananju jagai!» yera. ");
INSERT INTO kby_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Isa bǝrǝmdǝa falje koje cidi Gadarawuyero kadinniya, karuwama yindi kaurilalan caluwe tia kapkeyera. Tayidǝ jauro jau, har wunduma rakce jawaldǝyen kojiwawo. ");
INSERT INTO kby_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Daji yiljane: «Awi lambonǝm andiro, Tada Alaye? Sanju cǝdǝnnin andiro ajawu gǝnaduwuro wa kadim?» yera. ");
INSERT INTO kby_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kuruwunjan alade kada newo cadi ye mbeji. ");
INSERT INTO kby_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Daji sedannadǝ Isaa lowojane: «Dusamia, aladeyadǝro dusagane curonjaro ngayiyo!» yera. ");
INSERT INTO kby_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Isaye tayiro: «To, lenowo!» yenniya, sedannadǝ caluwe curo aladeyadǝyero kasargawo. Daji aladeyadǝ samma ngǝrǝmjane kaulan jǝpcane bǝrǝmdǝro fidagane ingiye ngoje kasuno. ");
INSERT INTO kby_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sǝniya aladeyayedǝ cagase bǝlaro lejane awo kǝla karuwamaso aniyen wakkajǝnadǝa ambo wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Daji am bǝlaye samma ye Isaa kaptuwuro caluwe kerunniya, cidinja koljoro tia lowoyera. ");
INSERT INTO kby_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Daji Isa maaradǝro ngaye bǝrǝmdǝa falje koje bǝrninjaro wallada. ");
INSERT INTO kby_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Am laa kam tiyi nunaa kǝla bǝnaramben ngojane nanjuro kewudo. Isa kambǝrsenjadǝa kirunniya, kam tiyinju nunadǝro: «Tadani, bare tǝma kollǝmmi, biwunǝm gawurdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Daji malǝmba Attauraye laa karwunjan: «Kam attǝ Alaa gaskajǝna, diye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amma Isa awo karwunjaye asuje tayiro: «Awiro karwundon niadiwi dǝganadǝ? ");
INSERT INTO kby_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ndaso gǝle budu wo: “Biwunǝm gawurdǝna” wulduma ra “Cine lene!” wulduma? ");
INSERT INTO kby_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nonowo, Tada Kambedǝ nanjun kǝnduwo biwu ambe dunialan gawurduye mbeji!» yeno. Daji kam tiyinju nunadǝro: «Cine bǝnarammǝm ngone fannǝmbo lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kamdǝ cije fannjuro leyeno. ");
INSERT INTO kby_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jama captanadǝ adǝa kerunniya, rijane Ala kǝnduwo adǝ gai ambo cinadǝa kengoro. ");
INSERT INTO kby_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Isa nadǝa kolji duwon, kam laa tiro Matiyu cani kidaramnju akki mowoyen napkadaa kiro. Isaye tiro: «Wua sǝgai!» yenniya, cije tia giya. ");
INSERT INTO kby_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Isa fado Matiyuyelan masǝnaro napcǝna duwon, akki mowomaso-a biwuma gadeso-a kada ye isane ti-a fuwurawanju-a rokko masǝna dioro napkera. ");
INSERT INTO kby_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisawa adǝa kerunniya, fuwurawanjuro: «Awiro malǝmndo akki mowomaso-a biwuma gadeso-a rokko masǝna cadidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isa adǝa fangenniya, tayiro: «Kam dondi gǝnia, kam ngadǝ lowotor majiwawo. ");
INSERT INTO kby_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lenowo, mana adǝye maananju asunowo: “Bu fida gǝni, kanjimaɍima raakko.” Awoa jiremasoa gǝni, biwumasoa bowoduro kadikko,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Daji fuwurawa Nawi Yahayaye na Isayero isane tiro: «Awiro andi-a Farisawa-a asem taiye, amma fuwurawanǝm asem cadaiwawodǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isaye tayiro: «Mai larusaye dawunjan duwon, ngaladiya karwunja kuttaji wa? A'a, amma sa ise mai larusayedǝa dawunjan cattuluwiya, sa adǝn duwon asem cadai. ");
INSERT INTO kby_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Wunduma guntu batta bǝɍinne ingiro cakke captǝnni ngoje kajǝmu dinaro cukkududiwawo. Ngai cǝdia, batta bǝɍindǝ capte kardudǝ cayemaro kuraro walji. ");
INSERT INTO kby_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Koro wunduma diben bǝɍin ngoje satki dinaro fijiyiwawo. Ngai cǝdia, satkidǝ falde, diben ye cidiro fidiye, satki ye bannadi. A'a, amso diben bǝɍindǝa satki bǝɍinno fijagai, adǝgainin tayi yindi samma kǝlewa dasayi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Isa tayiro manajiyi ngai duwon, fuwuma dandalle laa ise fuwunjun tungurumje tiro: «Kǝrmama feroni bawoyeno. Are mukkonǝm tiro gǝnagǝne, roaro walji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Daji Isa cije fuwurawanju-a rokko kamdǝa geya. ");
INSERT INTO kby_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kamu laa ye nadǝn mbeji, kǝrwu mewun yindinno bu fidunju dajǝnni. Daji kamudǝ ise ngawo Isayen susuje ci kalwunjuyedǝa leyeno, ");
INSERT INTO kby_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","awoa karwunjun: «To, kajǝmunju bas lekkia, ngakki,» cǝni. ");
INSERT INTO kby_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isa suworde tia kirunniya, tiro: «Feroni, bare tǝma kollǝmmi! Kambǝrsenǝm nangaro njǝkkawo fandǝmma!» yeno. Sadǝman kamudǝ ngayeno. ");
INSERT INTO kby_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Isa fado fuwuma dandalledǝro ise algaidawu lagaranne-a jama captana kalala fijai-aa kirunniya, ");
INSERT INTO kby_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tayiro: «Luwowo lenowo! Ferodǝ bawojǝnni, kǝnǝm cǝdi,» yeno. Amma tia rujane tiro kaasu keddo. ");
INSERT INTO kby_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jamadǝa deyaro kettuluwunniya, ngaye ferodǝa mukkoyen cǝdane ciyeno. ");
INSERT INTO kby_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lawar adǝ cididǝ ngaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Isa nadǝa kolje ledu cǝdi duwon, kambu yindi tia jaane kowo sapcane: «Isa Tada Mai Daudaye, andia njunosane!» cani. ");
INSERT INTO kby_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Fado laaro kǝrgaanniya, kambuwadǝ nanjuro kadira. Isaye tayiro: «Rangǝkke adǝa njaddǝkkiro mǝrsasuwwa wa?» cǝne kiworo. Kambuwadǝye: «Aaa, Kǝma!» yera. ");
INSERT INTO kby_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Daji Isa simnja leje tayiro: «Kambǝrsendo nangaro, nayiro wakkanjaa!» yenniya, ");
INSERT INTO kby_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","sim kewando. Isa tayiro wada ce: «Fannowo, bare wunduma adǝa nojǝnni!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma lejane lawar Isayedǝa cididǝ ngaro tataryeyera. ");
INSERT INTO kby_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tayi sim cawandǝnadǝ sapkadaranniya, am gade karuwama laa rakce manajiwawoa ngojane na Isayero kewudo. ");
INSERT INTO kby_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isa sedandǝa duyenniya, kamdǝ manadu badiyeno. Daji jamadǝ ajapcane: «Ngaltema awo adǝ gai lardu Israyilayelan turunni!» yera. ");
INSERT INTO kby_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amma Farisawadǝye: «Kǝnduwo mai sedannayen sedannaa duji,» yera. ");
INSERT INTO kby_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Daji Isa leje dandalnjan jamaa alamje kawuɍi kǝji nodo bargaa Mai Samemaye wuljiye am dondia kasuwanja ngan isangajiyi ngai duwon, bǝla-a bǝladeya-a sammaa giya. ");
INSERT INTO kby_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jama kada captanadǝa kirunniya, tayia njunoyeno, dalilnjudǝ jǝktane hangalnja caa cijǝna alama dimiya sǝni bawoa gai nangaro. ");
INSERT INTO kby_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Daji fuwurawanjuro: «Kaladǝ ngǝwu, amma kidawudǝ gana. ");
INSERT INTO kby_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Adǝ nangaro Kǝma kalayedǝa lowonowo, kidawu gade yea tiro kala njǝddoro cunodo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isa fuwurawanju mewun yindindǝa bowoje tayiro kǝnduwo sedan dudaye-a am kasuwa so, kǝndondi so jiɍi fi yayea isangaduwuye-a kaino. ");
INSERT INTO kby_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cuwa kǝngayambanju mewun yindindǝyedǝ tayima Siman kam tiro Biturus canidǝ, yanjugǝna Andarawus, Yakuba tada Jabadiye, yanjugǝna Yahaya, ");
INSERT INTO kby_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, Bartolomi, Toma, Matiyu akki mowoma, Yakuba tada Alfawusse, Tadawus, ");
INSERT INTO kby_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siman kam Kan'anaye, Yahusa Iskariyot kam mukko kǝladowayero Isaa sǝrǝttuwumadǝ. ");
INSERT INTO kby_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isa tayi mewun yindin aniro wada ce kinodo. Tayiro: «Bare na kǝrdiyayero lenuwwi bi bǝlawa Samariyawuyero ngawuwwi, ");
INSERT INTO kby_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","biya na jama Israyila tayi dimiya faccaanadǝ gaiyero lenowo! ");
INSERT INTO kby_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lenuwilan, ambo: “Nodo bargaa Mai Samemaye del karǝnjǝna!” wulgǝnowo. ");
INSERT INTO kby_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Am dondia isangagǝnowo, am sanunaa roaro kalangowo, am barasuaa isangagǝnowo tayirro walja, sedanna dunowo. Dero kiwanduw, nayi ye dero yowo. ");
INSERT INTO kby_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","«Bare kunguna dinarre, bi ɍiwullaye, bi kulloye ngonuwwi, ");
INSERT INTO kby_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","koro bare ngǝrwu, bi gǝmaje yindi, bi suno gade, bi ka ngonuwwi, kidamaro ngǝnǝwuramnju wajipcǝgǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Bǝla-a bǝladeya-a fi yayero ngawuwiya, kam ngǝlama manowo fannjun jǝmmowo nammowo, har kawu nadǝa kolluwiro. ");
INSERT INTO kby_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Fannjuro ngawuwiya, barga dǝpkǝnowo. ");
INSERT INTO kby_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Am fadodǝye ngǝlaro njamoyia, bargandodǝ tayilan dǝga. Amma nayia mowo wanjaia, bargandodǝ nandoro waldo. ");
INSERT INTO kby_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wunduma nayia njamowonni bi manando ngojǝnnia, fadodǝa bi bǝladǝa kolluwiya, katti sindoye kagangowo. ");
INSERT INTO kby_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jiremaro nayiro wulnjagakki, kiyama wakkajiya, wowom am bǝla adǝyedǝ am bǝrni Sodombe-a Gomorre-adǝa nanjaunin koji. ");
INSERT INTO kby_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Fannowo, dimiya curo bulduwayero ngasaana gairo nayia njanodǝkki. Adǝ nangaro kadi gai burwoaro wallowo, koro bullam gai biwu bawoaro dǝgaiwo. ");
INSERT INTO kby_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amsoro hangal gǝnanowo, dalilnjudǝ nayia njadane fuwu majilissero njasade dandalnjasolan kowonjai, ");
INSERT INTO kby_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","koro wu nangaro fuwu gomna so, mai soyero njasadi, tayi-a kǝrdiya-aro shedaro walloworo. ");
INSERT INTO kby_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Shararo njasadiya, bare kǝla jiɍi mananuwi bi awo wulluwiyen karwungai diwwi. Sadǝn awo wulluwidǝa nayiro njadi, ");
INSERT INTO kby_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","dalilnjudǝ nayi gǝni mananuwi, Ruhu Bawandoyedǝma nayiyen manaji nangaro. ");
INSERT INTO kby_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yaana yanjugǝnaa sǝrǝcciye roro ceyesi, bawa ye tadanjua ngai, tadawa ye bawanja-a yanja-aro tuɍu cadde casakke tayia roro ceyesi. ");
INSERT INTO kby_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Cuni nangaro am samma nayia wanjai, amma kam mǝrje har sa njerorambero dǝganamadǝ njǝkkawo cuwandi. ");
INSERT INTO kby_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bǝla laan nayia basarnjaiya, bǝla gadero kasowo lenowo. Jiremaro nayiro wulnjagakki, kawu Tada Kambedǝ walde isidǝro, bǝlawa Israyilawuye sammaa ga yeruwwawo. ");
INSERT INTO kby_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Fuwura malǝmnjua kojiwawo, koro wolodi kǝmanjua kojiwawo. ");
INSERT INTO kby_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Fuwura malǝmnju gairo waljiya, cǝdǝna. Wolodi ye kǝmanju gairo waljiya, jussǝna. Kǝma fadoyedǝa Beljabullan bowoyeraa, balle am fannjuye? ");
INSERT INTO kby_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Adǝ nangaro bare tayia rinuwwi. Awima jakkada federo culuwiwawodǝ bawo, koro awima asǝrre isanodiwawodǝ bawo. ");
INSERT INTO kby_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Awo curo buneyen nayiro wulnjagakkǝnadǝa kausulan wullowo, koro awo curo sǝmondoyen tatapcane fannuwwadǝ yea farsamlan kurungowo. ");
INSERT INTO kby_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Am tiyi ceyesi ro rakcane cattuluwiwawodǝa bare rinuwwi. Amma ti ro-a tiyi-a sammaa rakce kannu jaanamayen sijiyidǝa rinowo! ");
INSERT INTO kby_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Binaru yindi gursu tiloro caladi, gǝna? Adǝ yaye Bawandoye nodunjun gǝnia, falnjama cidiro cukkuriwawo. ");
INSERT INTO kby_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nayidǝ, kanduɍi kǝlandoyema samma komgada. ");
INSERT INTO kby_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Adǝ nangaro bare rinuwwi, binaru ngǝwua darajan konuwwa. ");
INSERT INTO kby_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Wundu duwon fuwu amben wua kasansǝnamadǝ, wu ye fuwu Bawani Mai Samemayen tia kasaddǝkki. ");
INSERT INTO kby_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma wundu duwon fuwu amben wua angǝrsǝnamadǝ, wu ye fuwu Bawani Mai Samemayen tia angǝrnǝkki. ");
INSERT INTO kby_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Bare duniaro nanlewa kudoro kadikkoro tǝmanuwwi. A'a, nanlewa gǝni, kashagar kudoro kadikko. ");
INSERT INTO kby_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Awoa amba firduro kadikko, tada kǝlado bawanjuyero walji, fero ye kǝlado yanjuyero walji, kamu tadaye ye kǝlado kǝsainjuyero walji. ");
INSERT INTO kby_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Adǝgaima kambe waduwunjudǝ am fannjuyero waljai. ");
INSERT INTO kby_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wundu duwon bawanju bi yanjua wumaa kojǝnaro cǝraanamadǝ kakkero waldu tinni. Wundu duwon tadanju bi feronjua wumaa kojǝnaro cǝraanamadǝ kakkero waldu tinni. ");
INSERT INTO kby_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Koro wundu duwon kǝskanju karmoye ngoje wua sǝgannimadǝ kakkero waldu tinni. ");
INSERT INTO kby_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kam duwon ronju fando cǝraanamadǝ ronjudǝa cuwatki, amma kam duwon wu nangaro ronju cuwatkǝnamadǝ ronjudǝa cuwandi. ");
INSERT INTO kby_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Kam nayia njamowonamadǝ wumaa sǝmowo, koro kam wua sǝmowonamadǝ ye ti wua sunodǝnadǝmaa cǝmowo. ");
INSERT INTO kby_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kam duwon nawia ti nawi nangaro cǝmowonamadǝ mukowa nawiye cuwandi, koro kam jiremaa ti jirema nangaro cǝmowonamadǝ mukowa kam jiremaye cuwandi. ");
INSERT INTO kby_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wundu duwon tayi aniye gananja laaro ti fuwurani nangaro ingi kǝnjaye samsu cinamadǝ, jiremaro nayiro wulnjagakki, tǝmmaro mukowanju fucciwawo,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Isa fuwurawanju mewun yindinno wada ce kerǝnniya, nadǝa kolje bǝla bǝlaro leje jamaa alamje tayiro kawuɍi kǝji wulduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nawi Yahaya kosolan awo Almasiwu cǝdidǝa fangenniya, fuwurawanju laa nanjuro cunode ");
INSERT INTO kby_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tiro: «Nima wa fuwun isimadǝ wo, ra gade gureniye?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isaye tayiro: «Waldǝnowo, awo fannuwwa-a ruwwa-aa Yahayaro wulgǝnowo: ");
INSERT INTO kby_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kambuwa sim cawandi, ngurdiyiya ye sinjan lejai, am barasua ngajane tayirro waljai, muwaso ye fanjai, am sanuna roaro waljai, koro talaawa ye kawuɍi kǝjidǝa fanjai. ");
INSERT INTO kby_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Barganju kam wu nangaro taljiwawodǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Fuwurawa Yahayayedǝ sapkadaranniya, Isa kǝla Yahayayen jamadǝro mana njǝddo badiyeno. Tiye: «Awi curo karaayen kuroro leyew? Ngǝlai laa kanji kanjiro karuwaye cakke moji cǝdi wa? ");
INSERT INTO kby_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A'a. Awi gǝle kuroro leyew? Kam kajǝmu shawa cakkǝnaa wa? A'a, am kajǝmu shawa casakkǝnadǝ mairilan kasarga. ");
INSERT INTO kby_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To, awi gǝle kuroro leyew? Nawia wa? Aaa, nayiro wulnjagakki, nawimaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tima kam duwon kǝlanjun kitawulan adǝ ruwuwadadǝ: “Nin fuwunno kǝngayammi nodǝkke, niro jawalnǝm cassai.” ");
INSERT INTO kby_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jiremaro nayiro wulnjagakki, curo kam kamulan tambǝna sammayen wunduma Yahaya Kasalamaa kojǝna bawo. Amma curo nodo bargaa Mai Samemayen tǝngǝɍidǝ tia kojǝna. ");
INSERT INTO kby_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jaman Yahaya Kasalamayen tamiya har kuro kudero nodo bargaa Mai Samemaye kiaddin fuwu juwui, am tiro fuwu bo dapcaanadǝ kǝnduwodǝa dunodunon mowo majai. ");
INSERT INTO kby_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dalilnjudǝ kitawuwa nawiyaye-a Attaura Nawi Musaye-a nawinawi cadǝna ngai duwon, har Yahaya kadio. ");
INSERT INTO kby_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Manadǝa ngodu kasadduwwaa, tima Nawi Iliya fuwun isimadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kam sǝmonjuamadǝ fanjo! ");
INSERT INTO kby_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Wundusoro am jaman adǝyedǝa rattalgǝkki? Tayi alama yalla ci kasuwuyen napkada kowo sapcane amanjaro: ");
INSERT INTO kby_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Algaita nayiro funjagaiyena duwon, bikke randuwwi. Koro so lagaranne diyena duwon, yiruwwi,” cani gai. ");
INSERT INTO kby_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","To, Yahaya ise juwunni ye, canni ye, “Ti karuwama!” yera. ");
INSERT INTO kby_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Koro Tada Kambedǝ ise juwui, cai, “Akko kǝmboma, kǝnjama, sawa akki mowomaso-a biwumaso-aye!” yera. Amma nanrashidudǝ kǝndonjulan asudi.» ");
INSERT INTO kby_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Daji Isa am bǝrniya curonjan awo ajabba ngǝwu cǝdǝnadǝyea tǝmjanni nangaro wusadu badiyeno. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kuttundo am bǝrni Korajinne! Kuttundo am bǝrni Baitsaidaye! Ca awo ajabba ajabba nandon tǝdǝnasodǝ bǝrni Tirre-a Sidonne-alan tǝdǝnaa, tǝn kuren amnja ajaja-a buwu-alan napcane tuwa cadǝna. ");
INSERT INTO kby_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amma nayiro wulnjagakki, kiyama wakkajiya, wowomndo am bǝrni Tirre-a Sidonne-ayedǝa nanjaunin koji. ");
INSERT INTO kby_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nayi ye am bǝrni Kafarnaambe, samero wa samnjai tǝmayew? A'a, kannuro kolnjagai. Ca awo ajabba ajabba nandon tadǝnadǝ bǝrni Sodomben tadǝnaa, kua gairo dǝgai. ");
INSERT INTO kby_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amma nayiro wulnjagakki, kiyama wakkajiya, wowomndo bǝrni Sodombedǝa nanjaunin koji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sa adǝn Isaye: «Bawa Kǝma same-a dunia-aye, nia njungorǝkki, dalilnjudǝ awo ania ilmuwu so, rashiduwa soro gǝraame yallaro isanogǝmma nangaro. ");
INSERT INTO kby_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aaa, Bawa, adǝma awo jauro raammadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Bawani awo sammaa mukkoniro cakkǝna. Ti gǝnia, wunduma Tadadǝa nojǝnni. Koro wunduma Bawadǝa nojǝnni, sai Tadadǝ-a am tayiro Tadadǝ isanojiyiya cǝraana-a. ");
INSERT INTO kby_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Arowo naniro, nayi kare kurwowu ngowada yimbaruwwa samma, tustu njadǝkki. ");
INSERT INTO kby_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wudǝ rokuraa gǝni, karwu ngǝlaa nangaro, duini daundoro ngogǝnowo, kolsǝnowo alamnjakko, karwundon tustu fanduwi. ");
INSERT INTO kby_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Awoa duini ye kǝske, kareni ye kamboi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sa adǝn yim tustuyea Isa-a fuwurawanju-a kulo algamaye rejane kojai duwon, fuwurawadǝ kǝna fanjaidǝ, kǝla algamaye ficcane ngǝro badiyera. ");
INSERT INTO kby_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisawa laa adǝa kerunniya, tiro: «Akko rui, fuwurawanǝm awo yim tustuyea kǝndoro haramdǝa cadi,» yera. ");
INSERT INTO kby_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Isaye tayiro: «Sa Nawi Dauda-a amnju-a kǝna fanjanadǝn, awo cǝdǝnadǝa kitawulan kǝranuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Curo Fado Alayero ngaye burodi sadaaye ngoje gigǝro. Ɍimannaro kajia, ti-a amnju-aro burodi sadaaye ngǝrodǝ haram! ");
INSERT INTO kby_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ra, ɍimanna curo Fado Alayen awo yim tustuyea kǝndoro haram cadison, biwunja bawodǝa Attauralan kǝranuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nayiro wulnjagakki, awo laa Fado Alayea kojǝna nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Alaye: “Bu fida gǝni, kanjimaɍima raakko,” cǝnna. Ca mana adǝye maananju nonuwwaa, am ayaunja baworo ayau gǝnaawwi. ");
INSERT INTO kby_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Awoa Tada Kambedǝ Kǝma yim tustuye, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isa kǝla fuwunna leyenniya, dandalnjaro kǝrgawo. ");
INSERT INTO kby_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nadǝn kam laa mukko canaa mbeji. Farisawadǝ Isaro ayau gǝnaduwu caraana nangaro, tiro: «Yim tustuyea kam isangaduwudǝ halal wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isaye tayiro: «Wundundo diminju yim tustuyea bǝlaaro cukkuriya, gǝrje cuttuluwiwawodǝ? ");
INSERT INTO kby_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Adǝgaia, kam dimia darajan kojǝna nangaro, yim tustuyea ngǝla kǝndo halal,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Daji kamdǝro: «Mukkonǝm sane!» yeno. Sayenniya, ngaje kǝlewa salai faldǝ gairo walyeno. ");
INSERT INTO kby_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisawadǝ dandalnin keluwunniya, sawardane jawal Isaa njejoye mayera. ");
INSERT INTO kby_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Isa adǝa asuyenniya, nadǝa kolyeno. Jama kada ye tia geya. Tayi sammaa isangajiye ");
INSERT INTO kby_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","bare tia isanojaganniro sǝmonja kaskeno. ");
INSERT INTO kby_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Adǝgaima awo Kǝmande kuren ci Nawi Ishayayen wuljǝnadǝ wakkayeno. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Akko wakkilni kǝrenǝkkǝnadǝ, tia raakkǝna, tima karwuni jauro kǝjijǝgǝna wo. Ruhuni tiro yakkǝkke jiredǝa jama duniaye sammaro isanojiyi. ");
INSERT INTO kby_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kambiwu cǝdiwawo, yiljiwawo, kowonju farsamlan fandiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Caccau ɍimjǝnaa namjiwawo, fatǝla no cǝdi yea cejiwawo, har jiredǝa kǝnnasarro cuwudiro. ");
INSERT INTO kby_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Koro jama duniaye samma cunjuro tǝmanja casakki,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Daji karuwama laa kambu ye, muwa ye kewudǝnniya, Isa tia isangajiye caye gai curui ye manaji yero walyeno. ");
INSERT INTO kby_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jama samma ajapcane: «Kam adǝ, tima gǝni Tada Mai Daudayedǝ wo?» yera. ");
INSERT INTO kby_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisawadǝ adǝa fangeranniya, tayiye: «Kǝnduwo Beljabul mai sedannaye baslan sedannaa duji,» yera. ");
INSERT INTO kby_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amma Isa awo karwunjaye asuje tayiro: «Kǝrmai fi yaye kǝlanjuro yaktǝgǝnadǝ dǝgaiwawo, koro bǝla bi fado fi yaye kǝlanjuro yaktǝgǝnadǝ ye dǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To, Yiwulis sedannanjua dujia, kǝlanjuro yaktǝgǝna. Ndayilan gǝle kǝrmainjudǝ dǝgai? ");
INSERT INTO kby_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Koro wudǝ kǝnduwo Beljabullen sedannaa dukkia, fuwurawando kǝnduwo wunduyen gǝle sedannaa dujai? Adǝmaro tayi sharawundoro waljai. ");
INSERT INTO kby_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma kǝnduwo Ruhu Alayeman sedannaa dukkia, daji nodo bargaa Alaye nandoro isǝna, diye! ");
INSERT INTO kby_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Wunduma rakce fado kam dunoayero ngaye kǝndanju cǝmoyiwawo, sai kam dunoadǝa cikkeriya duwon. Cikkeriya, kǝndanju cǝmoyi. ");
INSERT INTO kby_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nonowo, kam wuro kǝldǝgǝnnidǝ lawalamani, koro kam wua banasiye rokko cammiyewawodǝ tarduma. ");
INSERT INTO kby_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Adǝ nangaro nayiro wulnjagakki, biwu so, mana bastuye so samma kambo gawurdiyi, amma Ruhu Alayea bastudǝ gawurdiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wundu duwon kǝla Tada Kambedǝyen manakuttu wuljidǝ, tiro gawurdiyi. Amma wundu duwon kǝla Ruhu Alayen manakuttu wuljidǝ, dunia yen kal, leira yen kal, har abadaro gawurdiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kǝskadǝ ngǝlaa, tadanju ye ngǝla. Kǝskadǝ diwia, tadanju ye diwi. Kǝskadǝ tadanjulan asudi. ");
INSERT INTO kby_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nayi kaduwu fusiyayeso! Nayi jauro diwidǝ, awiawin gǝle ranguwe awo ngǝla mananuwi? Dalilnjudǝ awo karwulan dǝganadǝmaa cidǝ manaji nangaro. ");
INSERT INTO kby_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kam ngǝladǝ awo ngǝla karwunjulan dǝganadǝyen ngǝla cǝdi, koro kam diwidǝ ye awo diwi karwunjulan dǝganadǝyen diwi cǝdi. ");
INSERT INTO kby_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nayiro wulnjagakki, kiyama wakkajiya, Ala kǝla mana faida bawoa kam manajǝna sammayen tia cuwori. ");
INSERT INTO kby_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awoa mananǝmlan jiremaro wallǝmi bi mananǝmlan jirenambumaro wallǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Daji malǝmba Attauraye-a Farisawa-a laaye Isaro: «Sayinna, alama laa sameye fǝlesagame ruiyeya, rayiyena,» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Isaye tayiro: «Am ansiya Alaye jaman diwi adǝyeso alama majai, amma alama Nawi Yunusse gǝnia, alama fima tayiro fǝlediyiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jiɍi Nawi Yunus kuren curo buni mafǝndiyen bune-a kausu-aro kawu yakkuro dǝganadǝ gai, Tada Kambedǝ ye curo cidiyen bune-a kausu-aro kawu yakkuro dǝgai. ");
INSERT INTO kby_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kiyama wakkajiya, am bǝrni Niniweye cijane am jaman adǝyedǝa jirenambuwuro shedajai, dalilnjudǝ tayi mana Nawi Yunusse ngojane tuwa cadǝna nangaro. Akko awo laa Nawi Yunussa kojǝna nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kiyama wakkajiya, Mai kamuye lardu Anǝmbedǝ ye cije am jaman adǝyedǝa jirenambuwuro shedaji, dalilnjudǝ ti ci duniayen cije na Mai Sulemanayero nanrashidunju fanduro isǝna nangaro. Akko awo laa Mai Sulemanaa kojǝna nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Sedan kamlan culuwiya, leje curo karaa dǝɍiyen na naptuye maji, amma cuwandiwawo. ");
INSERT INTO kby_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Daji kǝlanjuro: “Nda fanni kollǝkkǝnadǝro waldǝkke,” cǝni. Waldiya, fadodǝa bowu fat ye, tas fǝraada ye, tassana ye najiyi. ");
INSERT INTO kby_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Daji leje sedan tulur gade tia nandiwin kojana capce cuwude ngasaye napcai. Adǝ nangaro naptu kam adǝyedǝ cayemaa kojǝnaro kuttaji. Am jaman diwi adǝye yero adǝgai wakkajiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Isa jamadǝro mana cǝddi duwon, yanju-a yanjugǝnaso-a isane ci fadoyen dajane tiro mana caddo cane keworo. ");
INSERT INTO kby_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kam laaye tiro: «Akko yanǝm-a yanǝmgǝnaso-a deyan daada niro mana njǝddoro majai,» yenniya, ");
INSERT INTO kby_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Isaye kamdǝro: «Wundu yanidǝ wo? Koro wunduso yanigǝnasodǝ wo?» yeno. ");
INSERT INTO kby_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Daji fuwurawanjua mukkon fǝleje: «Akko yani-a yanigǝnaso-adǝ! ");
INSERT INTO kby_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wundu duwon awo Bawani Mai Samema cǝraanaa cǝdimadǝ, tima yani-a yanigǝnaso-a wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yim adǝman Isa fadodǝn culuwe leje ci bǝrǝmben napkenniya, ");
INSERT INTO kby_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","am kada kadami nanjun captane, har cije maararo ngaye napkeno. Amdǝ samma ye ci bǝrǝmben dajana ngai duwon, ");
INSERT INTO kby_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","awo kada misalnin tayiro wulduwu badiyeno. Tiye: «Kam laa kuloro algama jǝjǝrduro kiluwo. ");
INSERT INTO kby_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jǝjǝrji ngai duwon, kasuni laa jawalnin fiyada. Daji ngudowa isane cotto gewo. ");
INSERT INTO kby_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kasuni laa ye na kau kaua katti ngǝwu bawoalan fiyada. Katti ngǝwu bawodǝro, sadǝman ɍiyeno. ");
INSERT INTO kby_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Amma kǝngal samero tatkenniya, kausu jauje fǝrdu bawo nangaro ɍimje ngamgeno. ");
INSERT INTO kby_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kasuni laa ye na ngiwian fiyada. Ngiwidǝ ɍije algamadǝa kimitkeyeno. ");
INSERT INTO kby_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amma kasuni laadǝ ye na katti ngǝlaan fiyadanniya, ɍije nema kekko, laa tada mia mia, laa firakku firakku, laa fiakku fiakku. ");
INSERT INTO kby_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kam sǝmonjuamadǝ fanjo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Daji fuwurawa Isaye nanjuro isane tiro: «Awi nangaro jamadǝro misalnin managǝmidǝ?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Isaye: «Nayiro asǝr nodo bargaa Mai Samemaye noduro amardǝgǝna, amma tayiro amardǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kam nanjun awoamadǝ, tiro casargane ngǝwuro walji, amma kam nanjun bawomadǝ, awo cǝdanadǝmaa tilan camoyi. ");
INSERT INTO kby_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Akko dalil misalnin tayiro managǝkkidǝ: Caruima, asujaiwawo. Fanjaima, caɍiwawo, kǝlanja yero ngayiwawo. ");
INSERT INTO kby_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ngaima kǝlanjan awo Kǝmande kuren ci Nawi Ishayayen wuljǝnadǝ wakkaji. Tiye: «“Ngǝlaro fannuwi duwon, kǝlandoro tǝmmaro ngayiwawo. Koro ngǝlaro ruwi duwon, tǝmmaro asunuwwawo. ");
INSERT INTO kby_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Awoa karwu jama adǝyedǝ kibbajǝna, kiaddin sǝmonja fanjai, simnja yea jakcana, bare simnjan carunni, sǝmonjan fanjanni, koro karwunjan asujanniro. Ngai gǝnia, naniro waldane tuwa cade tayia isangagǝkki,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Amma simndo barganja, carui nangaro, sǝmondo ye, fanjai nangaro. ");
INSERT INTO kby_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jiremaro nayiro wulnjagakki, kuren nawiya so, jirewu so kada awo ruwwadǝa kuroro jauro caraana, amma carunni. Koro awo fannuwwadǝa fanduro caraana, amma fanjanni. ");
INSERT INTO kby_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«To, maana misal kasuni jǝjǝrdumayedǝa fannowo! ");
INSERT INTO kby_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wundu duwon mana kǝla nodo bargaadǝyen fanje kǝlanjuro ngaannimadǝ, Kǝladodǝ ise mana karwunjun fidǝnadǝa cotto cuttuluwi. Tima kasuni kǝla jawallen fidǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kasuni na kauan fidǝnadǝ ye, tima kam manadǝa fanjiyama, karwu kǝjiaro cǝmoyidǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amma tilan fǝrdu bawo nangaro, tussiwawo. Kǝla manadǝyen kuttu caiya, bi am tia basarjaiyama, waje kolji. ");
INSERT INTO kby_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kasuni na ngiwian fidǝnadǝ ye, tima kam manadǝa fanjǝna duwon, karwungai dio so, arsiyi mangardu so manadǝa kǝpcane tiro faidajiyiwawodǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amma kasuni na katti ngǝlaan fidǝnadǝ, tima kam manadǝa fanje kǝlanjun rojǝna tiro faidajiyi, nema laa tadanju mia mia, laa firakku firakku, laa fiakku fiakku cakkidǝ wo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isa tayiro misal gade ye wuljiye: «Nodo bargaa Mai Samemayedǝ alamanju kam kulonjun kasuni algamaye ngǝla jǝjǝrjǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amma am samma kǝnǝm cadi duwon, kǝladonju ise curo algamadǝyero kasuni kajimbe jǝjǝrjiye sapkadan. ");
INSERT INTO kby_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Algamadǝ ɍije kǝla fitkenniya, kajimdǝ ye asudiro walyeno. ");
INSERT INTO kby_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kidawudǝ isane banja ngimbaro: “Barganǝmmin, ni kasuni algamaye ngǝla gǝna kulonǝmlan jǝjǝrnǝm? To, ndayilan gǝle kajimbadǝ?” cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Banja ngimbaye tayiro: “Kǝlado laa adǝa cǝdo!” yeno. Daji kidawudǝye tiro: “Leniye tuluwiyeya, raamma wa?” cane keworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","tiye: “A'a, lenuwe kajimdǝa tuluwuwiya, algamadǝ yea mǝnguwi. ");
INSERT INTO kby_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kollowo, har kalaro rokko ɍija. Biyilajiya, kalawudǝro kajimdǝa kamja kǝla kǝlaro cekkero kannun warja duwon, daji algamadǝ yea capca bǝranilan gǝnaja nǝkki,”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Koro Isa walde tayiro misal gade wuljiye: «Nodo bargaa Mai Samemayedǝ alamanju kasuni mutarre kam laa ngoje kulonjulan fijǝna gai. ");
INSERT INTO kby_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kasuni mutarredǝ, curo kasuniya sammayen tima tǝngǝɍi wo. Amma ɍije wurajiya, kǝskawa jǝrwulan sammaro kuraro walje, har ngudoso dǝlambanjun fannja cadandi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Koro walde tayiro misal gade wuljiye: «Nodo bargaa Mai Samemayedǝ alamanju yis kamu laa ngoje rungo algamaye jaa yakku-a kǝlje dije, har fum fujǝna gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isa jama captanadǝro awo ani sammaa misalnin wulyeyeno. Misalnin gǝnia, awima tayiro wuljǝgǝna bawo. ");
INSERT INTO kby_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Adǝgaima awo Kǝmande kuren ci nawiyen wuljǝnadǝ wakkayeno. Tiye: «Misalnin mananǝkki, awowa tǝn dunia alaktǝnaman gǝraadadǝa wullǝkki,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Daji Isa jamadǝa kolje fadodǝro kasargawo. Fuwurawanju ye nanjuro isane tiro: «Marne, andiro maana misal kajim kuloyedǝa fisarsagane,» yera. ");
INSERT INTO kby_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isaye tayiro: «Kam kasuni ngǝla jǝjǝrjǝnamadǝ, tima Tada Kambedǝ wo, ");
INSERT INTO kby_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kulodǝ dunia, kasuni ngǝladǝ am nodo bargaadǝa kasaccanadǝ. Kajimdǝ am Kǝladodǝa jaanadǝ, ");
INSERT INTO kby_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kǝlado kajimdǝa jǝjǝrjǝnamadǝ Yiwulis. Biyiladǝ cinowo duniaye, kalawusodǝ malaiyawa. ");
INSERT INTO kby_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jiɍi kajimdǝa capcane kannun warjaidǝ gai, dunia cijiya, adǝgai wakkaji. ");
INSERT INTO kby_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tada Kambedǝ malaiyawanjua juwaje lejane curo nodonju bargaayen am am gadea casakke biwu cadiso-a am diwi cadiso-a sammaa capcane ");
INSERT INTO kby_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kannuro fijagai. Nadǝn so ye tǝdi, sheɍi ye naldi. ");
INSERT INTO kby_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Daji jirewudǝ curo nodo bargaa Bawanjayen kǝngal gairo nurraro waljai. Kam sǝmonjuamadǝ fanjo! ");
INSERT INTO kby_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Nodo bargaa Mai Samemayedǝ alamanju awo laa jaumaro tamanna kulolan rǝpkada gai. Kam tia cuwandiya, caye gairo rǝpce karwu kǝjiaro leje kǝndanju sammaa cǝlade kulodǝa ciwi. ");
INSERT INTO kby_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Koro nodo bargaa Mai Samemayedǝ alamanju sawurma laa mursam ngǝla maji gai. ");
INSERT INTO kby_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mursam jauro tamanna laa cuwandiya, leje kǝndanju sammaa cǝlade mursamdǝa ciwi. ");
INSERT INTO kby_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Koro nodo bargaa Mai Samemayedǝ alamanju buni taram laa buni tawu tia bǝrǝmbo gǝpcagane buni jiɍi jiɍi cadai gai. ");
INSERT INTO kby_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cǝmbǝɍǝnaro waljiya, gǝrjane ci bǝrǝmbero cawude napcane ngǝla ngǝladǝa kǝrejane joworo fijagai, amma batti battidǝa wajane yirjai. ");
INSERT INTO kby_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dunia cijiya, adǝgaima wakkaji. Malaiyawa isane jirenambuwua curo jirewuyen firjane ");
INSERT INTO kby_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kannuro fijagai. Nadǝn so ye tǝdi, sheɍi ye naldi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isaye fuwurawanjuro: «Awo ani samma kǝlandoro ngaana wa?» cǝne tayia kiworǝnniya, tiro: «Aaa,» yera. ");
INSERT INTO kby_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Daji tayiro: «Adǝgaima malǝm Attauraye fi yaye fuwura nodo bargaa Mai Samemayedǝro waljǝnadǝ alamanju kǝma fadoye ajaramnjun lǝman dina-a bǝɍin-a ngoje cuttuluwidǝ gai,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Isa misal ania cǝde kerǝnniya, nadǝa kolyeno. ");
INSERT INTO kby_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bǝla wurajǝnadǝro leje dandalnjan jamaa alamdu badiyeno. Amdǝ tia ajapcane: «Ndaran kam attǝ nanrashidu-a kǝnduwo-a ania kiwando? ");
INSERT INTO kby_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ti gǝna tada katako karomadǝye wo? Yanjuye cunjudǝ Meram, gǝna? Yanjugǝnasodǝ ye Yakuba-a Isuwu-a Siman-a Yahusa-a, gǝna? ");
INSERT INTO kby_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Koro yanjugǝnawa ferowa samma-a rokko kǝrgaiye, gǝna? To, ndaran gǝle ti adǝ awo ani sammaa kiwando?» cane ");
INSERT INTO kby_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","tia kasatturo wayera. Amma Isaye tayiro: «Nawi curo bǝlanjaye-a am fannjaye-aro kajia, darajanjua,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kambǝrsenambunja nangaro, nadǝn awo ajabba ngǝwu cǝdǝnni. ");
INSERT INTO kby_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sa adǝn Mai Hirudus lawar Isaye fangenniya, ");
INSERT INTO kby_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kowonawanjusoro: «Kam adǝ Yahaya Kasalama, tima roaro walje cijo! Adǝma nangaro kǝnduwo awo ajabba ajabba dioye nanjun mbeji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Caman kǝla lamar Ya Hirudiya kamu yanjugǝna Mai Filibussen Mai Hirudus Yahayaa cǝdane, cekkere kosoro kesakko, ");
INSERT INTO kby_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","dalilnjudǝ Yahayaye Mai Hirudusso: «Kamu yanǝmgǝnaye mowodǝ haram!» cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Koro Mai Hirudus Yahayaa roro njejoro maji duwon, jamadǝa riyeno, tia nawiro ngojana nangaro. ");
INSERT INTO kby_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngaima duwon saanduri Mai Hirudus tambǝnaye kidǝnniya, fero Ya Hirudiyaye ise fuwunjan bikke kirando. Karwu maidǝye jauro kǝjije ");
INSERT INTO kby_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tiro awi yaye ronju cǝraanaa ci cǝne wadu ngoje kansi giwo. ");
INSERT INTO kby_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ferodǝ ye leje yanju tiro gala ce walde maidǝro: «Wuro na adǝn kǝla Yahaya Kasalamaye curo buwuruyen se!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Maidǝye karwunju jauro kuttu yaye, kansi bonju-a kusottowanju-a nangaro wada ce ");
INSERT INTO kby_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","amnju cunode lejane kosolan kǝla Yahayaye kamgera. ");
INSERT INTO kby_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Daji kǝlanjudǝa buwurulan cawude ferodǝro kedo, ti ye ngoje yanjuro kikkiado. ");
INSERT INTO kby_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Fuwurawa Yahayaye isane kaminnju ngojane caade sittǝrayera, koro lejane Isaro lawar adǝa wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isa awo wakkajǝnadǝa fangenniya, ti runju maararo ngaye nadǝa kolje karaa na wunduma baworo leyeno. Amma jamadǝ adǝa fangeranniya, tayi ye bǝlanjasolan caluwe silan Isaa geya. ");
INSERT INTO kby_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Isa maaradǝn jǝpkenniya, jama kada captanadǝa cure tayia njunoje amnja dondia isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dunia lǝmgenniya, fuwurawanju isane tiro: «Na adǝ karaa bowu, koro dunia ye lǝmjǝna. Jamadǝa salamme, bǝladeyasoro leja awo kǝmboye cesiwo!» yera. ");
INSERT INTO kby_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Amma Isaye tayiro: «A'a! Sai lejaiya gǝni, nayima awo kǝmboye tayiro yowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tiro: «A! Burodi uwu-a buni yindi-a gǝnia, awima gade taiyende,» yera. ");
INSERT INTO kby_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Isaye: «Wuro tayia sukkudowo!» cǝne ");
INSERT INTO kby_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","wada ce jamadǝ kǝla kajimben napca yeno. Daji burodi uwudǝ-a buni yindidǝ-a ngoje kǝla samero sapce Alaro ardiyenniya, burodidǝa fǝsakce fuwurawanjuro ce, tayi ye jamadǝro kedo. ");
INSERT INTO kby_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tayi samma jawune kulyera. Fuwurawadǝ gaptowo sammaa capkeranniya, jowo mewun yindin kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Am duwon kǝmbo adǝa jawunadǝ kamuwa-a tadawa-a dawun baworo kongwa alama dǝwu uwu gai. ");
INSERT INTO kby_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sadǝman Isa fuwurawanjudǝa cakke tin fuwunno bǝrǝmdǝa koja ci todǝro lejaro maararo kasargawo, ti ye jamadǝa salamji yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tayia salamgenniya, ti runju moduwa dioro kǝla kau kuruwuyero giwa. Nadǝn ti tilonju lok duwon, dunia lǝmgeno. ");
INSERT INTO kby_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Koro sa adǝlan karuwa dunoa cije ingi bǝrǝmbedǝa cambalje maaradǝa babakce, har maaradǝ ci ingiyea kuruwunno leyeno. ");
INSERT INTO kby_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sa yakku buneyen Isa kǝla ingiyen silan nanjaro kadio. ");
INSERT INTO kby_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Fuwurawadǝ Isa kǝla ingiyen silan ledu cǝdidǝa kerunniya, karwunja pǝt kamde: «Kaime kam nunaye!» cane riduro burwu kesakko. ");
INSERT INTO kby_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sadǝman Isa tayiro manajiye: «Karwundo gerowo, wuma! Bare rinuwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Daji Biturusse tiro: «Kǝma, nimaa, amarsǝgǝne kǝla ingiyen nanǝmbo isǝkko,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Isaye: «Are!» yenniya, Biturus curo maaradǝyen culuwe tia naduwuro kǝla ingidǝyen silan ledu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma karuwa dunoadǝa kirunniya, yaaje tia lǝptu badiyeno. Daji kowo sapce: «Kǝma, wua sǝmoye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sadǝman Isa mukkonju sajiye tia cǝdane: «Ni kambǝrse ganaadǝ, awiro shekku kekkǝm?» yeno. ");
INSERT INTO kby_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Daji maaradǝro kasargaanniya, karuwadǝ gǝm nǝmgeno. ");
INSERT INTO kby_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Am curo maaradǝyedǝ Isaro ambǝccagane: «Jiremaro ni Tada Alaye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Daji bǝrǝmdǝa faljane koyeranniya, cidi Genesaretten jǝpkera. ");
INSERT INTO kby_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Am nadǝye Isaa asuyeranniya, lawarnju cididǝ ngaro tatargaada. Amnja dondiso sammaa na Isayero cawude ");
INSERT INTO kby_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ci kalwunjuyedǝmaa lejaro tia lowoyera. Am kalwunjudǝa lejana samma ngayera. ");
INSERT INTO kby_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Daji Farisawa-a malǝmba Attauraye-a laa Jerujalemlan cijane na Isayero isane tiro: ");
INSERT INTO kby_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Awiro fuwurawanǝmdǝ ada amwurawandeyea koljane mukkonja tuljannin kǝmbo jawuidǝ?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isaye tayiro: «Nayidǝ nda, awiro wada Alaye kolluwe adando gawidǝ? ");
INSERT INTO kby_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Awoa Alaye: “Bawanǝm-a yanǝm-aro daraja ye!” Koro “Kam duwon bawanju bi yanjua rujǝnamadǝ, tia roro ceyeso!” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma nayiye: “Kam bawanju bi yanjuro: ‘Awo nanin nuwandoro tǝmanuwwadǝa Alaro gǝnagǝkkǝna,’ cǝnia, ");
INSERT INTO kby_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bare tilan bawanju-a yanju-aro ser cǝdde daraja cinni,” nuwi. Adǝgaima adando nangaro mana Alayedǝa bowuro kalakkew. ");
INSERT INTO kby_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nayi mǝnafǝkkaso, awo Nawi Ishayaye kǝlandon wuljǝnadǝ jire. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«“Jama adǝ cilan wuro daraja sadi, amma karwunjan nanin kuruwujana. ");
INSERT INTO kby_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","De sullo wuro ambǝnsagai, alamdunjadǝ wada kambe,” cǝnna.» ");
INSERT INTO kby_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Daji Isa jamadǝa nanjuro bowoje tayiro: «Fannowo, asunowo! ");
INSERT INTO kby_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Awo ci kambero ngayidǝ kamdǝa tayir gǝniro cǝdiwawo, amma awo cinjun culuwidǝ, tima kamdǝa tayir gǝniro cǝdi wo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Daji fuwurawadǝ nanjuro isane tiro: «Farisawadǝ mana adǝa kutturo fanjanaro nonǝmma wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Isaye tayiro: «Kǝska fi duwon Bawani Mai Samema gǝni kokcomadǝ, fǝrduyen tia mǝkcai. ");
INSERT INTO kby_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kollowo tayia, kambu kambua jedumaso! Kambu kambu kamanjua jejia, tayi yindi samma bǝlaaro casukkuri.» ");
INSERT INTO kby_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Daji Biturusse tiro: «Misal adǝa andiro fisarsagane,» cǝne Isaa kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isaye: «A! Nayi ye kuamison kǝla jakkadaa wa? ");
INSERT INTO kby_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Awi yaye ci kambero ngaanadǝ curonjuro koje daji tiyinjuyen culuwiro nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma awo ci kamben culuwidǝ curo karwunjuyen isǝna, tima kamdǝa tayir gǝniro cǝdi wo. ");
INSERT INTO kby_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dalilnjudǝ niadiwi so, kam njejo so, kǝnjǝna so, jarawa so, nambarwu so, shedakambu so, adǝlamdu so samma curo karwudǝyeman caluwi, ");
INSERT INTO kby_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","anisodǝma kamdǝa tayir gǝniro cadidǝ wo. Mukko tuljǝnnin bǝri bodǝ kamdǝa tayir gǝniro cǝdiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Daji Isa nadǝa kolje lardu bǝrni Tirre-a Sidonne-ayero leyeno. ");
INSERT INTO kby_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kamu Kan'anama cididǝn dǝgana laa nanjuro ise kowo sapce tiro: «Kǝma, Tada Mai Daudaye, wua njunosǝne! Feroni jaumaro karuwaa,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma Isa tiro mana falma kalakcǝgǝnni. Daji fuwurawanju nanjuro isane tia lowojane: «Tia salamme lejo, kowo sapciaro andia sagai,» yera. ");
INSERT INTO kby_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isaye: «Dimiya fattaana Israyilayero gǝnia, Ala wua wunduyemaro sunodǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amma kamudǝ ise fuwunjun tungurumje tiro: «Kǝma, wua banasǝgǝne!» ");
INSERT INTO kby_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isaye: «Kǝmbo yallayedǝa ngonǝme kǝrisoro njodǝ jussǝnni!» yenniya, ");
INSERT INTO kby_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","kamudǝye: «Aaa, Kǝma. Adǝ yaye kǝrisodǝma kǝmbo cidiro cukkurǝnadǝa jawui,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Daji Isaye kamudǝro: «Kambǝrsenǝmdǝ jauro kura, diye! Awo raammadǝ wakkajo!» yeno. Sadǝman feronjudǝ ngayeno. ");
INSERT INTO kby_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Daji Isa nadǝa kolje leje ci bǝrǝm Galileye jǝgane kǝla kau kuruwuyen juwane napkeno. ");
INSERT INTO kby_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Am kada kadami isane ngurdiyi so, kambu so, dungu so, muwa so, am dondi gade ngǝwu soa nanjuro cawude fuwunjun gǝnajane tayia isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jamadǝ muwaso manajai, dunguso ye ngaro waljana, ngurdiyiya ye sinjan lejai, koro kambuwa ye sim cawandǝnaro kerunniya, ajapcane Ala jama Israyilayedǝa jajakkera. ");
INSERT INTO kby_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Daji Isa fuwurawanjua nanjuro bowoje tayiro: «Jama adǝa njunokkǝna, dalilnjudǝ ku wu-a rokko kawunja yakku, koro awima kǝmboye nanjan bawo nangaro. Kǝnanjaa duwon tayia salammǝkkiya, raakkǝni, bare jawallan dunonja baworo waljǝnniro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Fuwurawanjudǝye tiro: «Ndaran gǝle karaa adǝn kǝmbo sarai fandiye jama kada adǝa ambaniye?» yera. ");
INSERT INTO kby_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isaye tayiro: «Burodi ndawu nandon?» cǝne kiworǝnniya, tiro: «Tulur buni sanana laa-a,» yera. ");
INSERT INTO kby_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Daji Isa jamadǝa cakke cidin napkeranniya, ");
INSERT INTO kby_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","burodi tulurdǝ-a buniyadǝ-a ngoje Alaro ardije fǝsakce fuwurawanjuro ce, tayi ye jamadǝro kedo. ");
INSERT INTO kby_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tayi samma jawune kulyera. Fuwurawadǝ gaptowodǝa capkeranniya, jowo kalaram tulur kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Am duwon kǝmbo adǝa jawunadǝ, kamuwa-a tadawa-a dawun baworo kongwa dǝwu dewu. ");
INSERT INTO kby_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Daji Isa jamadǝa salamgenniya, maararo ngaye cidi Magadannero leyeno. ");
INSERT INTO kby_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisawa-a Sadusiya-a isane Isaa rijapturo alama laa sameye tayiro fǝlejuworo tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Isaye tayiro: «Kajirijiya, nayiye: “Kasam kǝji fandiye, same kimejǝna nangaro,” nuwi. ");
INSERT INTO kby_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Koro dunia wajiya, nayiye: “Ku ingi cuduri, same keyera kime cittaro waljǝna nangaro,” nuwi. Awo samen fǝledidǝa fisardu nonuwwa, amma awo jaman adǝn wakkajidǝa fisardudǝ nayiro katkero! ");
INSERT INTO kby_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Am ansiya Alaye jaman diwi adǝyeso alama majai, amma alama Nawi Yunusse gǝnia, alama fima tayiro fǝlediyiwawo,» yeno. Daji tayia kolje leyeno. ");
INSERT INTO kby_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Fuwurawadǝ bǝrǝm faljane ci todǝro koyeranniya, ngessane burodi ngojanniro asuyera. ");
INSERT INTO kby_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Daji Isaye tayiro: «Yis Farisawa-a Sadusiya-ayero hangal gǝnanowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tayidǝ kattenjan: «Burodi ngoniyende nangaro ngai wulji,» cane mana badiyera. ");
INSERT INTO kby_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isa adǝa asuje tayiro: «Nayi kambǝrse ganaaso, awiro kǝla burodi nandon bawoyen kattendon mananuwidǝ? ");
INSERT INTO kby_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ra, kua yaye asunuwwi wa? Burodi uwu am dǝwu uwuro dagargaadadǝ-a jowo ndawu cammuwwa-adǝa ngessuwwa wa? ");
INSERT INTO kby_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ra, burodi tulur am dǝwu dewuro dagargaadadǝ-a jowo kalaram ndawu cammuwwa-adǝa ngessuwwa wa? ");
INSERT INTO kby_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","To, awiro gǝle asunuwwidǝ? Wu kǝla burodiyen gǝni mananjagakki, yis Farisawa-a Sadusiya-ayero hangal gǝnanowo yekko!» ");
INSERT INTO kby_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Daji fuwurawadǝ yis burodiyero gǝni, alamdu Farisawa-a Sadusiya-ayero hangal gǝnaja wuljǝgǝnaro asuyera. ");
INSERT INTO kby_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isa cije cidi bǝrni Kaisariya Filibiyero kadinniya, fuwurawanjuro: «Wunduro Tada Kambedǝa amsodǝ ngoyera?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tayiye: «Am laa Yahaya Kasalama cani, laaye Nawi Iliya cani, laaye Nawi Irimiya bi nawiya kureye falnja cani,» yera. ");
INSERT INTO kby_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tiye: «Nayidǝ, wunduro wua ngosew?» cǝne tayia kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Siman Biturusse: «Nima Almasiwu Tada Ala Kǝndǝgaimayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Daji Isaye tiro: «Barganǝm Siman tada Yunusse, dalilnjudǝ kam gǝni, Bawani Mai Samema adǝa isanonjǝgǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Niro wulnjǝgǝkki, nima Biturus, kǝla kau adǝyeman jama wua gawu tandǝkki, koro kǝnduwo kannuye kǝlanjan kǝnnasar cuwandiwawo. ");
INSERT INTO kby_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Niro cuwuram nodo bargaa Mai Samemaye njikki. Awi duwon dunian gerǝmidǝ same yen tikkerǝna, koro awi duwon dunian wuinǝmidǝ same yen wuidǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Daji Isa sǝmonja kasse tayiro bare wundumaro tima Almasiwudǝ woro wuljaganni yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kua adǝn fuwun Isa fuwurawanjuro Ala kadarjǝna Jerujalembo leje mukko amwurawa-a wurawa ɍimannaye-a malǝmba Attauraye-ayen kuttu tai daje cane tia roro ceyesi, koro kawu yakkua roaro walje ciji cǝne tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Daji Biturus tia sǝgǝriro cuttuluwe jǝkkade: «A! Kǝma, Ala nia adǝro damnjuwo! Adǝ tǝmmaro niro wakkanjiyiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amma Isa suworde Biturusso: «Nani kolle, Yiwulis! Jawalnilan takkallo walsǝgǝmma. Awo karwunǝmlan tammadǝ Alaye gǝni, kambe!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Daji Isaye fuwurawanjuro: «Kam laa wua ga cǝraanaa, mǝradu kǝlanjuye wajo kǝskanju karmoye ngojo wua sǝga. ");
INSERT INTO kby_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dalilnjudǝ wundu duwon ronju ɍiwo cǝraanamadǝ ronjudǝa cuwatki, amma wundu duwon wu nangaro ronju cuwatkǝnamadǝ ronjudǝa cuwandi. ");
INSERT INTO kby_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kam dunia adǝ ngaa jǝgande ronju asarjiya, nda riwanju? Ra, awi gǝle kam ce ronju cuwandi? ");
INSERT INTO kby_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Dalilnjudǝ Tada Kambedǝ curo daraja Bawanjuyen malaiyawanju-a rokko isiya, daji wundu yayero kǝla awo cǝdǝnasoyen kalkallo ci nangaro. ");
INSERT INTO kby_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jiremaro nayiro wulnjagakki, am laa na adǝn daada mbeji, kawu kawunja dajidǝro, Tada Kambe kǝrmainjun isi carui,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngawo adǝyen kawu arakkua Isa cije Biturus-a Yakuba-a yanjugǝna Yahaya-a runjaa ngoje kǝla kau kuruwu laayero gewa. ");
INSERT INTO kby_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Fuwunjan Isaye alamanju falde fǝkkanju kǝngal gai tai daje yiyilyeno, koro kajǝmunju ye nur gai bul fokko walyeno. ");
INSERT INTO kby_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sadǝman Nawi Musa-a Nawi Iliya-a tayiro fǝledagane Isa-a jandedu badiyera. ");
INSERT INTO kby_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Daji Biturusse Isaro: «Kǝma, andi na adǝn mbejidǝ jauro ngǝla. Raammaa, ngurwo yakku na adǝn lammǝkki: fal kaanǝm, fal Nawi Musaye, fal ye Nawi Iliyaye,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Manaji ngai duwon, fofou nurra ise tayia jakkeno. Curo fofoudǝyen kowo nukce: «Adǝma Tadani wo, tia jauro raakkǝna. Tima karwuni jauro kǝjijuwo. Mananju fannowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Adǝa fangeranniya, fuwurawadǝ fǝdǝryero rǝbǝt tǝmdane karwunja tai daje kamgada. ");
INSERT INTO kby_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amma Isa ise tayia leje: «Cinowo, bare rinuwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kǝla sapkeranniya, Isa tilonju lon gǝnia, wundumaa carunni. ");
INSERT INTO kby_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kǝla kaudǝyen jǝpcai duwon, Isaye tayiro wada ce: «Bare awo ruwwa adǝa wundumaro wulgǝwwi, sai Tada Kambedǝ karmolan cijiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Daji fuwurawadǝye tiro: «Awiro gǝle malǝmba Attaurayedǝ sai Nawi Iliya burwoje isi canidǝ?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isaye tayiro: «Jiremaro Nawi Iliya ise awiso kalkallo kalakci. ");
INSERT INTO kby_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma nayiro wulnjagakki, Nawi Iliya isǝna duwon, tia asujanni, koro awiso kuttu ronja cǝraanaa tiro keddo. Adǝgaima Tada Kambedǝ ye mukkonjan kuttu cai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Daji fuwurawadǝ kǝla Yahaya Kasalamayen tayiro mana cǝddiro asuyera. ");
INSERT INTO kby_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na jama captanadǝro kadiranniya, kam laa ise fuwu Isayen tungurumje ");
INSERT INTO kby_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","tiro: «Kǝma, tadania njunone! Ti sedan koroyea jauro suwoljǝna, koro ngǝwuro kannu so, ingi soro cukkurǝna. ");
INSERT INTO kby_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Fuwurawanǝmbo tia kikkiadǝkkǝniya, tia isangaduwu tayiro katkero,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isaye tayiro: «Nayi am jaman adǝyeso kambǝrsenambuwu karwu yeskadaa, har sawi gairo dawundon dǝgakki? Koro sawi gairo nayia rannjakki? Tadadǝa wuro sukkudowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isa sedandǝro kikkadǝnniya, tadadǝa kolje culuwe sadǝman ngayeno. ");
INSERT INTO kby_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Daji fuwurawadǝ na Isayero isane runjan tiro: «Awiro sedandǝa duda andiro katkero?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isaye tayiro: «Kambǝrsendo gana nangaro. Jiremaro nayiro wulnjagakki, ca kambǝrsendo mbejia, kasuni mutarre gai yaye, kau kuruwu adǝro: “Cine na todǝro lene!” wulluwiya, cije leji. Awima nayiro tiyeri bawo! ");
INSERT INTO kby_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amma sedan jiɍi adǝyedǝ culuwiwawo, sai moduwa diwe asem tawiya duwon.» ");
INSERT INTO kby_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Fuwurawanju cidi Galileyelan capkadaranniya, Isaye tayiro: «Tada Kambedǝa mukko ambero sǝrǝccagane ");
INSERT INTO kby_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tia roro ceyesi, koro kawu yakkua roaro walje ciji,» yeno. Daji fuwurawadǝ karwunja jauro kuttayeno. ");
INSERT INTO kby_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bǝrni Kafarnaambero kadiranniya, akki Fado Alaye mowomaso na Biturussero isane tiro: «Malǝmndodǝ akki Fado Alayedǝa biyajiwawo wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Biturusse: «A'a, biyaji,» yeno. Fadoro kadinniya, Isaye burwon tiro: «Siman, awi tǝmanǝm? Na wundusoyen maiya duniayesodǝ akki camoyi? Na tadawanjayen ra na am gadesoyen?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Biturusse: «Na am gadesoyen,» yenniya, Isaye tiro: «Adǝgaia, tadawanjasodǝ dawun bawo, diye! ");
INSERT INTO kby_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Adǝ yaye bare yakkiye karwunja wajǝnniro, lene bǝrǝmbo mui kolgǝne buni burwon tammadǝa ngone cinju kane. Kanǝmiya, gursu fal fandǝmi. Ngone yade akki mowomasodǝro ye, wu-a ni-ayero,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sa adǝn fuwurawadǝ na Isayero isane tiro: «Curo nodo bargaa Mai Samemayen wundu kura wo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Daji Isa tadaana laaa bowoje dawunjan isadajiye ");
INSERT INTO kby_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tayiro: «Jiremaro nayiro wulnjagakki, karwundo falde tadawa sanana gairo walluwwia, tǝmmaro nodo bargaa Mai Samemayero ngawuwwawo. ");
INSERT INTO kby_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Adǝ nangaro wundu duwon tadaana adǝ gai kǝlanjua awimaro ngojǝnnidǝ, curo nodo bargaa Mai Samemayen tima kura wo. ");
INSERT INTO kby_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«Koro wundu duwon tadaana adǝ gaia cunilan cǝmowonamadǝ, wumaa sǝmowo. ");
INSERT INTO kby_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amma wundu duwon tadawa sanana wua mǝrsasanaso aniye falnjaa cakke talje biwu cǝdidǝ, kamdǝye daunjuro kau neduram mafǝndi lujagane bǝrǝm kuruwuro gǝpcaanama tiro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Kuttunja am duniayeso, dalilnjudǝ awowa tayia casakke taljane biwu cadi mbeji. Jaraptaso kadu baworo isai, amma kuttunju kam tiyen isaidǝ! ");
INSERT INTO kby_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mukkonǝm bi sinǝm njakke tallǝme biwu dimia, tia kamme nin kuruwunno gǝmme! Mukko yindia bi si yindia kannu tǝmmaro nuiwaworo ngawodǝroa, maskin bi dungu ro sawisoyero ngaammama niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Koro simmǝm njakke tallǝme biwu dimia, tia kulaine nin kuruwunno gǝmme! Sim yindia kannu jaanamayedǝro ngawodǝroa, sim falla ro sawisoyero ngaammama niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Hangal gǝnanowo, bare tadawa sanana aniye falnjamaro rudu gǝnagǝwwi! Nayiro wulnjagakki, samelan malaiyawanja sawisoro fǝkka Bawani Mai Samemaye carui kasarga. ");
INSERT INTO kby_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Awoa Tada Kambedǝ awo faccǝgǝnasodǝa manǝme njǝkkaworo isǝna. ");
INSERT INTO kby_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Awi gǝle tǝmanuw? Kam laa diminju miaa duwon, fal fatkeyenoa, filǝgar lǝgaridǝa kǝrisolan kolje leje fal faccǝgǝnadǝa maji, mare? ");
INSERT INTO kby_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jiremaro nayiro wulnjagakki, kiwandoa, karwukǝji duwon kǝla faldǝyen cǝdidǝ kǝla filǝgar lǝgari faccaannidǝyen cǝdidǝmaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Adǝgaima Bawando Mai Samema ye tadawa sanana aniye falnjaye fattuwu cǝraanni. ");
INSERT INTO kby_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Kǝraminǝm biwu niro njǝddia, lene katte nayi yindi rundoyen tiro biwunjudǝa wulgǝne. Mananǝm fanjia, kǝraminǝmdǝa mowomma. ");
INSERT INTO kby_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Fanjiwawoa, kam fal bi yindi ngone kallo lenowo. Adǝgainin mana fi yaye ci sheda yindi bi yakkuyen tabbattiyi. ");
INSERT INTO kby_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tayi yea fanduro wajia, jama wua gawuro wulgǝne. Koro yaye jama wua gawudǝmaa fanduro wajia, kǝrdi bi akki mowoma gairo tia ngone. ");
INSERT INTO kby_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jiremaro nayiro wulnjagakki, awi duwon dunian geruwidǝ same yen tikkerǝna, koro awi duwon dunian wuinuwidǝ same yen wuidǝna. ");
INSERT INTO kby_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Koro nayiro wulnjagakki, dunian kamndo yindi kǝla awi yayen ardijane Bawani Mai Samemaa caworia, tayiro ci. ");
INSERT INTO kby_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Dalilnjudǝ na duwon kam yindi bi yakku cunilan captanadǝ, wu ye dawunjan,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Daji Biturus na Isayero ise tiro: «Kǝma, kǝramini wuro biwu sǝddiya, ndawuro tia gawurnǝkki? Har gadegade tulurro?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isaye tiro: «A'a, har gadegade tulurro gǝni wulngeyekko, fitulur gadegade tulurro tia gawurne! ");
INSERT INTO kby_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Adǝ nangaro nodo bargaa Mai Samemaye alamanju mai laa wolodiyanju-a kǝla kasunjayen balas dio cǝraanadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Maidǝ balas dio badiyenniya, kam talanti dǝwu mewuro jǝgaimaa tiro kekkudo. ");
INSERT INTO kby_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kamdǝ awonju rǝmboye bawodǝ, kǝmanju wada ce ti-a kamunju-a yallanju-a kǝndanju samma-aa calado kasudǝ tǝrǝmbo yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Amma kamdǝ fuwu kǝmanjuyen tungurumje tiro: “Barganǝmmin, kanadi tai, sammaa rǝmbǝkki, diye!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Daji kǝma wolodidǝye tia njunoje kasudǝa wajiye tia kolje leyeno. ");
INSERT INTO kby_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Kiluwunniya, wolodi adǝ ye kamanju laa dinariyus miaro jǝgaimaa kiro. Tia dauyen rǝpciye kimiljiye: “Awo nia njǝgakkidǝa rǝmbe!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Daji kamanjudǝ fuwunjun tungurumje tia lowoje: “Marne, kanadi tai, rǝmbǝkki, diye!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma waje tia kosoro cakke, har kasudǝa cǝrǝmbiro yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Wolodiya amanjudǝ awo wakkajǝnadǝa kerunniya, karwunja jauro bannade lejane kǝmanjaro awo wakkajǝna sammaa wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Daji kǝmanjadǝ koro walde wolodidǝa bowoje tiro: “Ni wolodi kǝlado! Lowosǝmma nangaro, kasunǝm adǝ sammaa wangeyekko. ");
INSERT INTO kby_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Njunonjǝkkǝnadǝ gai, wolodi kamanǝmba njunodudǝ niro wajimnjǝgǝna, gǝna?” cǝne ");
INSERT INTO kby_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","gǝrgaje tia mukko am tiro ajawu caddiyero cakke, har ti ye sammaa cǝrǝmbiro yeno. ");
INSERT INTO kby_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Adǝgaima wundundo yaye karwunjun kamanjua gawurjiwawoa, Bawani Mai Samema ye tiro ngaidǝmaa cǝddi,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Isa mana ania cǝde kerǝnniya, cidi Galileyea kolje cidi Yahudiyaye ngawo bǝrǝm Jordaniyen dǝganaro leyeno. ");
INSERT INTO kby_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jama kada kadami Isaa jaane nadǝn am dondia isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisawa laa Isaa rijapturo isane tiro: «Kǝla dalil fiyen yaye kam kamunju dǝptadǝ halal wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isaye tayiro: «Ngaltema kitawulan adǝa kǝranuwwi wa? “Badiduramnin Alaktumadǝ tayia kongwa-a kamu-aro alakkeno.” ");
INSERT INTO kby_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Koro tiye: “Dalil adǝyero kwa bawanju-a yanju-aa kolje kamunjuro kǝrdiye tayi yindiso tiyi fallo waljai,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Adǝgaima kua adǝn fuwun tayidǝ yindi gǝni, tiloro waljana. Adǝ nangaro awo Ala kǝljǝnadǝa bare kam firjǝnni!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisawadǝye tiro: «To, awiro gǝle Nawi Musa kam kamunjuro kakkadu dǝptaye co duwon koljoro wada kaino?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isaye tayiro: «Kǝlakibbundo nangaro Nawi Musa kamu dǝpta nayiro amarngeyera, amma badiduramnin ngai gǝni. ");
INSERT INTO kby_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nayiro wulnjagakki, wundu duwon kamunjua kǝla kǝnjǝnayen gǝni dǝpce gade niyajǝnadǝ kǝnjǝna cǝdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Daji fuwurawanjuye tiro: «Adǝma naptu kam kamunjuayea, niya dionambudǝma ngalwo!» yera. ");
INSERT INTO kby_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isaye tayiro: «Kam nguson gǝni rakce mana adǝa ngoji, sai am duwon tayiro tinamasodǝ. ");
INSERT INTO kby_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dalilnjudǝ am laa curo yanjayeman adim tayia casambǝna mbeji, am laa ye am tayia adimbo cadǝna mbeji, koro am laa ye nodo bargaa Mai Samemaye nangaro kǝlanja adimbo cadǝna mbeji. Kam mana adǝa rakce ngojimadǝ ngojo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Daji am laa Isa mukkonju kǝla yallanja sananayero gǝnajuwo moduwa cǝddoro tayia nanjuro kewudǝnniya, fuwurawadǝ amdǝa wusayera. ");
INSERT INTO kby_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amma Isaye fuwurawanjuro: «Yalla sananadǝa kollowo naniro isa, bare tayiro dapkǝwwi! Nodo bargaa Mai Samemayedǝ am tayi gaiye nuwanja, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Daji kǝlanjaro mukko gǝnayeyenniya, nadǝa kolje leyeno. ");
INSERT INTO kby_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Daji jairo laa ise Isaro: «Sayinna, awi ngǝla dikke ro sawisoye fandǝkki?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isaye tiro: «Awiro kǝla awo ngǝlayen wua suworǝmidǝ? Ti ngǝladǝ tilo lon! Ro sawisoye fando raammaa, wadawadǝa gai!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jairodǝye: «Wada fiso?» cǝne tia kiworǝnniya, Isaye: «Bare ro kambe tuluwummi, bare kǝnjǝna dimmi, bare nambarwu dimmi, bare shedakambu dimmi, ");
INSERT INTO kby_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","bawanǝm-a yanǝm-aro daraja ye, koro kǝmaskinǝm yea kǝlanǝm gairo raye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jairodǝye: «Wada ani sammaa gakkǝna, awi gǝle wua mauso?» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isaye: «Kalkal diomaro waldu raammaa, lene kǝndanǝm lade talaawaro ye, arsiyi samelan fandǝmi. Daji are wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jairodǝ mana adǝa fangenniya, ti jauro gaɍiwu nangaro karwu kuttuaro sapkadan. ");
INSERT INTO kby_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Daji Isaye fuwurawanjuro: «Jiremaro nayiro wulnjagakki, gaɍiwuye nodo bargaa Mai Samemayero ngawonju jauro jau, diye! ");
INSERT INTO kby_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Koro waldǝkke nayiro wulnjagakki, gaɍiwuye nodo bargaa Alayero ngawonjudǝro kaɍimoye cuwuɍi ɍiwurayen kodunjuma budu wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Fuwurawadǝ adǝa fangeranniya, jauro ajapcane: «Assha! Adǝgaia, wundu gǝle njǝkkawo cuwandi?» yera. ");
INSERT INTO kby_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isa tayia ninije: «Kambo yojiwawo, amma Alaro awiso yoji!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Daji Biturusse tiro: «Akko andi awindeso kolliye nia njǝgaiyenadǝ, awi gǝle fandiye?» yenniya, ");
INSERT INTO kby_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isaye: «Jiremaro nayiro wulnjagakki, leira wakkaje Tada Kambedǝ kurisnju kǝrmaiye darajaalan napciya, nayi wua sǝgawwadǝ ye kuris kǝrmaiye mewun yindinlan nammuwe jiɍi Israyilaye mewun yindindǝa noduwi. ");
INSERT INTO kby_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Koro wundu duwon cuni nangaro fado, bi yeiya, bi kanna, bi bawa, bi ya, bi yalla, bi kulo koljǝnadǝ mia mia cuwandi, koro ro sawisoye ye warasaji. ");
INSERT INTO kby_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma am burwoye ngǝwu daryeyero waljai, koro daryeye ye burwoyero waljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Nodo bargaa Mai Samemayedǝ alamanju kam laa suwa lǝp jǝrwunju inabbero kidawu madaaro culuwuna gai. ");
INSERT INTO kby_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tayiro kidanja dabduyero dinariyus fal fal biyaji cǝne kasatkeranniya, tayia jǝrwunjuro kinodo. ");
INSERT INTO kby_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Koro balde culuwe ci kasuwuyen am gade kida bawo napkada kiro. ");
INSERT INTO kby_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tayiro: “Nayi ye jǝrwuniro lenowo, awo kalkaldǝa njadǝkki,” yenniya, ");
INSERT INTO kby_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","cijane leyera. Kausu dawu-a duwor-a ye culuwe caye gai kido. ");
INSERT INTO kby_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Koro yaye asar kiluwunniya, ci kasuwuyen am gade napkada cuwande tayiro: “Awiro dabdu sǝrambo na adǝn bowuro nammuwidǝ?” cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tiro: “Wunduma kida sadǝnni nangaro,” yera. Daji tayiro: “Nayi ye jǝrwuniro lenowo!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Dunia kajiriyenniya, kǝma jǝrwuyedǝye wakkilnjuro: “Kidawudǝa bowone tayiro biyanja ye, am daryeyedǝn badinǝmiya burwoyedǝro yade,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Am dunia asar kida badijanadǝ kadiranniya, dinariyus fal fal kewando. ");
INSERT INTO kby_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Daji am burwon kida badijanadǝ kadiranniya, awo am daryeyedǝyea kojǝna cawandiro tǝmajana duwon, ndasonja ye dinariyus fal fal kiwando. ");
INSERT INTO kby_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kewandǝnniya, karwunja waje ");
INSERT INTO kby_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tiro: “A! Am daryeye ani sa fallo kida cadǝna yaye, andi-a kalkallo kidǝm! Andidǝ suwa lǝp tawaniye dabdu sǝrambo kausu jau fit kǝlandenna ngǝnǝptiyena, diye!” yera. ");
INSERT INTO kby_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amma kǝma jǝrwuyedǝye falnjaro: “Sawa, awima diwi njǝddǝkkǝni. Dinariyus fallo kida dabduye dioro kasaddǝmma, gǝna? ");
INSERT INTO kby_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Awo kaanǝmdǝa ngone lene, njikkǝnadǝ gairo kam daryeye yero yikkiya, raakko. ");
INSERT INTO kby_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kǝndanilan rangǝkke awo roni cǝraana dikkiwawo wa? Ra, karwuni ngǝladǝro, wua sim diwin surumi?” yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Adǝgaima am daryeyedǝ burwoyero waljai, koro burwoyedǝ ye daryeyero waljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isa Jerujalembo ledu cǝdi duwon, kǝla jawallen fuwurawanju mewun yindindǝa sǝgǝriro cuttuluwe tayiro: ");
INSERT INTO kby_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Fannowo, Jerujalembo leniye, Tada Kambedǝa mukko wurawa ɍimannaye-a malǝmba Attauraye-aro sǝrǝccagane shara ro tuluwoye tiro cadde ");
INSERT INTO kby_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mukko kǝrdiyayero casakke, tayi ye tia rujane kirwolan jajarjane kǝskaro jajagane roro ceyesi. Koro kawu yakkua roaro walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Daji ya tadawa Jabadiye tadawanju yindi-a kallo na Isayero isane fuwunjun tungurumje awo laa cǝrawo cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Isaye tiro: «Awi raam?» cǝne tia kiworo. Kamudǝye tiro: «Marne, kǝrmainǝm fandǝmiya, kolle tadawani yindi ania napca, fal kǝmborammǝmlan, fal ye wailanǝmlan!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Isaye tayiro: «Awo koruwwadǝmaa nonuwwi. Ranguwe kǝnjaram yakkidǝn yawi wa?» cǝne tayia kiworǝnniya, tiro: «Aaa, rangiye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isaye tayiro: «Jire, kǝnjarammin yawi. Amma kǝmborammilan so, wailanilan so naptadǝ, wu gǝni kambo amargǝkki, Bawani am kǝrejǝnadǝro tayia dabbarjǝgǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Fuwurawa mewu gapcanadǝ adǝa fangeranniya, yaana yindidǝro gǝrgayeyera. ");
INSERT INTO kby_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Daji Isa tayi sammaa bowoje tayiro: «Nonuwwa, maiya kǝrdiyaye talaawanjaa jauro raccaana, koro fuwumanjaso ye amnjaro kǝnduwo fǝlejagai. ");
INSERT INTO kby_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma dawundon ngai gǝni. Wundu duwon dawundon kuraro waldu cǝraanamadǝ wolodindoro waljo! ");
INSERT INTO kby_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Koro wundu duwon fuwumandoro waldu cǝraanamadǝ kaɍeandoro waljo! ");
INSERT INTO kby_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Adǝgaima Tada Kambedǝ tiro nanwolodi caddoro gǝni kadio, tidǝma nanwolodi cǝdo ronju co am ngǝwu merujoro kadio,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Isa-a fuwurawanju-a bǝla Jerikoyelan keluwunniya, am kada kadami tia geya. ");
INSERT INTO kby_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kambu yindi ci jawallen napkada duwon, Isa kojiro fangeranniya, kowo sapcane: «Kǝma, Tada Mai Daudaye, andia njunosane!» yera. ");
INSERT INTO kby_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jamadǝ tayiro jakkade mǝdǝk napca yera, amma cayea kojǝnaro kowo sapcane: «Kǝma, Tada Mai Daudaye, andia njunosane!» yera. ");
INSERT INTO kby_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Daji Isa daje tayia bowoje: «Awi nayiro njaddǝkkiya, rawuw?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tayiye: «Kǝma, sim fandiyeya, rayiye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Daji Isa tayia njunoje simnja leyeno. Sadǝman sim cawande Isaa geya. ");
INSERT INTO kby_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerujalemba karǝnjane bǝla Baitfajeyero na Kau Jaitunnedǝro kadiranniya, Isa fuwurawanjuye yindi cunode ");
INSERT INTO kby_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tayiro: «Bǝla fuwundoyedǝro lenowo! Ngawuwiyama, koro laa kuttanjua tuwada nagǝwi. Fǝrangowo kudowo! ");
INSERT INTO kby_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kam laaye nayiro awo laa cǝnia, tiro: “Kǝmadǝ tayilan mǝradunjua,” wulgǝnowo! Sadǝman tayia juwajiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Adǝgaima awo Kǝmande kuren ci nawiyen wuljǝnadǝ wakkayeno. ");
INSERT INTO kby_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiye: «Fero Siyonnero wullowo: “Akko mainǝm nanǝmbo kǝnde cǝdi, ti rokura bawoa kǝla koroyen isi, kǝla kuttayeman,”» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Fuwurawadǝ lejane awo Isa tayiro wuljǝgǝnadǝa kedo. ");
INSERT INTO kby_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Daji korodǝ-a kuttanju-a na Isayero cawude kalwuwanja kǝladǝro ferjagane Isa juwane napkeno. ");
INSERT INTO kby_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jama kada ye kalwuwanja kǝla jawallen feryera, laa ye dǝlam kǝɍi kǝskaye kamjane kǝla jawallen sǝretkera. ");
INSERT INTO kby_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Am fuwu gǝrjana so, ngawonju jaana so kowo sapcane: «Hosanna, Tada Mai Daudayero daraja tio! Bargaa ti cu Kǝmandeyen isimadǝ! Hosanna, Mai Samemaro daraja tio!» cani. ");
INSERT INTO kby_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Isa Jerujalembo kǝrgaanniya, am bǝlaye samma hangalnja caa cijǝna: «Wundu kam attǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jamadǝye: «Tima Nawi Isa kam bǝla Najarat cidi Galileyedǝ wo!» yera. ");
INSERT INTO kby_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Daji Isa balballa Fado Alayero ngaye ladomaso-a njuwomaso-a sammaa duje tewur wuɍi canjimasoye-a napturam tattawar ladomasoye-aa tǝmbalyeno. ");
INSERT INTO kby_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tayiro: «Kitawulan ruwuwada: “Fannidǝa fado moduwayelan bowojai,” amma nayidǝ tia jongo gǝndewuyero kalakkew!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Daji Fado Alayen kambuwa-a ngurdiyiya-a na Isayero isane tayia isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wurawa ɍimannaye-a malǝmba Attauraye-a awo ajabba ajabba Isa cǝdidǝa carune, koro tadawa sanana ye Fado Alayen yiljane: «Hosanna, Tada Mai Daudayero daraja tio!» canidǝa fangeranniya, jauro gǝrgajane ");
INSERT INTO kby_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","tiro: «Awo tadawa sanana ani wuljaidǝa fannǝmma wa?» yera. Isaye tayiro: «Aaa, fakkǝna. Ngaltema adǝa kitawulan kǝranuwwi wa? “Tadawa sanana-a timalla-aa yakkǝme nia jajannjai!”» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Daji Isa tayia kolje bǝrnidǝn culuwe bǝla Baitaniyero leje boyeno. ");
INSERT INTO kby_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wajǝnanjua suwa lǝp Isa bǝrniro waldi duwon, kǝna tia kida. ");
INSERT INTO kby_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ci jawallen ya tarmuye kirunniya, nanjuro kadio, amma kalu gǝnia, awima cuwandǝnni. Daji Isaye tarmudǝro: «Bare gadero tada yakkǝmmi!» yeno. Sadǝman tarmudǝ ngau ngamgeno. ");
INSERT INTO kby_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Fuwurawadǝ adǝa kerunniya, ajapcane: «Awiawin tarmu adǝ samdǝn ngau ngamgeno?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isaye: «Jiremaro nayiro wulnjagakki, nayi shekku bawoa kambǝrsendoaa, ranguwe awo tarmudǝro yiddǝkkǝnadǝa diwi, koro adǝa kojǝnaro kau kuruwu adǝro: “Cine bǝrǝmbo fidǝgǝne!” wulluwiya, wakkaji. ");
INSERT INTO kby_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kambǝrsendoaa, awi yaye moduwalan koruwiya, fanduwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isa Fado Alayero kǝrgaanniya, jamaa alamji duwon, wurawa ɍimannaye-a amwurawa jamaye-a nanjuro isane tiro: «Kǝnduwo filan awo ania dimi? Wundu niro kǝnduwo adǝa njo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isaye tayiro: «Wu ye nayiro koro fal njaddǝkki. Jaawudǝa siwia, wu ye kǝnduwo filan awo ania dikkidǝa nayiro wulnjagakki. ");
INSERT INTO kby_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kasala Yahaya jamaro cǝddǝnadǝ, sameyen kadio ra kamben?» cǝne tayia kiworo. Daji kattenjan sawardane: «“Sameyen” wulliyea, andiro: “To, awiro gǝle tia kasadduwwidǝ?” cǝne sawori. ");
INSERT INTO kby_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amma “Kamben” wulliyea, jamadǝa riniyena, dalilnjudǝ am samma Yahayaa nawiro ngojana nangaro.» ");
INSERT INTO kby_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Daji Isaro: «Noniyende,» yera. Isaye tayiro: «Wu ye kǝnduwo filan awo ania dikkidǝa wulnjagakkiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«To, awi tǝmanuw? Kam laa tadanju yindia. Yim laa na tada burwoyedǝro leje tiro: “Tadani, ku lene jǝrwuni inabben kida de!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tadadǝye: “A'a, raakkǝni!” yeno, amma ngawo adǝyen tǝmje leyeno. ");
INSERT INTO kby_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Koro bawadǝ na tada yindiyedǝro leyenniya, ti yero caye gai wulyeyeno. Tadadǝye: “To, bawa, lekki,” yeno, amma lejǝnni. ");
INSERT INTO kby_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kǝrma tayi yindi aniyen wundunja awo bawanju cǝraanadǝa cǝdo?» cǝne tayia kiworo. Tiro: «Burwoyedǝma,» yeranniya, Isaye: «Jiremaro nayiro wulnjagakki, akki mowomaso-a jawarraso-a nayin burwonno nodo bargaa Alayero ngasayi. ");
INSERT INTO kby_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Dalilnjudǝ Yahaya nandoro ise jawal jireye fǝlengeyeranniya, tia kasadduwwi. Akki mowomaso-a jawarraso-adǝ tia kasatkera, amma nayidǝ, adǝa kiruwwiya, tǝmmuwe tia kasadduwwi. ");
INSERT INTO kby_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Akko misal gade yea fannowo! Kam laa kǝma jǝrwuye mbeji, jǝrwu inabbe cǝde garje curodǝn bǝlaa ingi inabbe tuluwoye laje soro kuruwu juworoye kidando. Daji jǝrwudǝa jǝrwuwu laaro agǝrijiye bǝlawuroro sapkada. ");
INSERT INTO kby_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sa fǝrdoye karǝngenniya, nuwanju cuwandoro kaɍeawanju laaa na jǝrwuwudǝyero kinodo. ");
INSERT INTO kby_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amma jǝrwuwudǝ kaɍeawanjudǝa keda. Faldǝa bakkera, faldǝ yea roro keyeso, faldǝ yero dongur kauye gǝgǝpcagane kano. ");
INSERT INTO kby_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Koro walde cayemaa kojǝnaro kaɍeawa gade kinodǝnniya, caye gai tayi yero keddo. ");
INSERT INTO kby_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Darye kǝma jǝrwudǝye: “Tadaniro daraja cadi,” cǝne tadanju nanjaro kinodo. ");
INSERT INTO kby_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amma jǝrwuwudǝ tadanjudǝa kerunniya, kattenjan: “Adǝma warasamadǝ wo! Arowo tia yejiyo, warasanjudǝa ngoniyo!” yera. ");
INSERT INTO kby_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Daji tia cadane jǝrwudǝlan cattuluwe roro keyeso. ");
INSERT INTO kby_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","To, kǝma jǝrwuyedǝ isiya, awi jǝrwuwu aniro cǝddi?» cǝne tayia kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tiro: «Am jauro kǝlado aniro ajawu jau fǝlejiye roro ceyesi, koro am gade sa fǝrdoyen tiro nemanju cadimadǝro jǝrwunjudǝa agǝrijiyi,» yera. ");
INSERT INTO kby_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Daji Isaye tayiro: «Ngaltema awo kitawulan ruwuwada adǝa kǝranuwwi wa? «“Kau duwon fado tandomaso wajanamadǝ, tima kau tandoye sammaro faidaaro waljǝnadǝ wo. Adǝ kǝndo Kǝmandeye, andiro jauro ajabba!” ");
INSERT INTO kby_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Adǝ nangaro nayiro wulnjagakki, Ala nodonju bargaa mukkondon cǝmoye mukko jama gade awo ti cǝraana cadimadǝyero cakki. ");
INSERT INTO kby_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nonowo, kam kǝla kau adǝyero cukkurǝnamadǝ nanamdi, koro kaudǝ kambo cukkuriya, kǝluwuro kalakci,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wurawa ɍimannaye-a Farisawa-a misallanju fangeranniya, kǝlanjaman mana kidoro asuyera. ");
INSERT INTO kby_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Daji jawal tia taye majai duwon, jamadǝa riyera, dalilnjudǝ amdǝ samma tia nawiro ngojana nangaro. ");
INSERT INTO kby_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Koro Isa walde misalnin tayiro wulyeyeno. Tiye: ");
INSERT INTO kby_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Nodo bargaa Mai Samemayedǝ alama mai laa tadanju nangaro masǝna larusaye dabbarjǝna gai. ");
INSERT INTO kby_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Maidǝ wolodiyanju laaa am masǝnaro dojǝnadǝa bowoja isaro nanjaro kinodǝnniya, kǝndero wayera. ");
INSERT INTO kby_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Koro walde wolodiya gadea cunode tayiro: “Am dokkǝnadǝro wullowo: ‘Akko masǝnanidǝ deyada. Dalowani so, kǝnnawani kaisua so duwajana, awiso kǝrma dabbargada. Arowo masǝna larusayero!’” yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma am dojǝnadǝ mananjudǝa awimaro ngojanni sapkadara. Laa kulonjaro, laa saniaramnjaro leyera. ");
INSERT INTO kby_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Am gapcanasodǝ ye wolodiyadǝa cadane basarjane roro keyeso. ");
INSERT INTO kby_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Maidǝ gǝrgaje sojiyanju cunode kamceji ania roro ceyese bǝlanja kannun waryera. ");
INSERT INTO kby_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Daji maidǝye wolodiyanjuro: “Akko masǝna larusayedǝ dabbargada, amma am dokkǝnadǝ martawa tia boye cadanni. ");
INSERT INTO kby_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Adǝ nangaro lenowo lai laisolan am fanduwwa sammaa masǝna larusayero bowonowo isa!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Daji wolodiyadǝ lejane lai lai jaane am cawandǝna sammaa ngǝlan diwin capcane isane, har larusaramdǝ damgeno. ");
INSERT INTO kby_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Maidǝ am dojǝnadǝa kuroro kǝrgaanniya, curonjan kam laa kalwu larusaye lujǝnni kiro. ");
INSERT INTO kby_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Maidǝye tiro: “Sawa, awiawin kalwu larusaye bawoa na adǝro kǝrgaam?” cǝne tia kiworǝnniya, kamdǝro awo wulduye katkero. ");
INSERT INTO kby_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Daji maidǝye wolodiyanjuro: “Tia si-a mukko-aro gerowo deyan curo duwu cǝlǝm pǝttero gǝpkǝnowo, nadǝn so ye tǝdi, sheɍi ye naldi,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nonowo, am bowojǝnadǝ ngǝwu, amma tayi kǝrejǝnadǝ gana,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Daji Farisawadǝ lejane sawardane jawal Isaro curo mananjuyen bǝlaa laduwuye mayera. ");
INSERT INTO kby_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Fuwurawanja-a am Mai Hirudussa jaana laa-aa nanjuro canode tiro: «Sayinna, ni kam jirema ye, jawal Alaye kalkallo yikkǝrami yero noniyena, dalilnjudǝ wundumaa rinǝmmi ye, gayirnǝmmi ye nangaro. ");
INSERT INTO kby_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To, awi tǝmanǝm? Kaisarro akki njodǝ halal ra haram?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amma Isa niadiwinjadǝa asuje tayiro: «Mǝnafǝkka, awiro wua rijamsuwi? ");
INSERT INTO kby_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wuɍi akkiyedǝa fǝlesǝgǝnowo!» cǝne dinariyus tiro kekkudo. ");
INSERT INTO kby_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tayiro: «Cu-a kǝla-a wunduye tilan dasaa?» cǝne tayia kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tiro: «Kaisarre,» yera. Isaye tayiro: «Daji awo Kaisarredǝa Kaisarro yowo, koro awo Alayedǝa Alaro yowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Adǝa fangeranniya, tia jauro ajapcane koljane sapkadara. ");
INSERT INTO kby_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yim adǝman Sadusiya laa, tayi cinowo duniaye bawo wuljaidǝ, na Isayero isane tiro koro cadde: ");
INSERT INTO kby_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Sayinna, Nawi Musaye: “Kam laa tada bawoa bawoje kamu koljia, yanjugǝna kamunjudǝa niyajo tiro kaduwu majuwo!” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Akko curonden yaana tulur mbeji. Burwoyedǝ kamu ngoje tada cuwandǝnnin bawoje kamunjudǝa yanjugǝnaro kolyeyeno. ");
INSERT INTO kby_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yindiyedǝ-a yakkuyedǝ-a yero ngai wakkajiye, har ti tulurredǝ kamudǝa cǝmoye bawoyeno. ");
INSERT INTO kby_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngawo adǝyen kamudǝ ye bawoyeno. ");
INSERT INTO kby_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To, tayi tulurso tia camowonadǝ, cinowo duniayen kamu wundunjayero walji?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isaye tayiro: «Nayidǝ fattǝgǝwwa, dalilnjudǝ kitawu bi kǝnduwo Alaye nonuwwi nangaro. ");
INSERT INTO kby_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cinowo duniayen am larusa so, niya so cadiwawo, tayi alama malaiyawa samelan dasaanadǝ gairo waljai. ");
INSERT INTO kby_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Koro karmolan cidudǝ, awo Ala kitawulan nayiro wulnjaanadǝa kǝranuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tiye: “Wuma Ala Ibrahimbe-a Isakuye-a Yakubaye-a wo,” cǝnna. Ti Ala am sanunaye gǝni, am roaye, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jamadǝ adǝa fangeranniya, tai dajane alamdunjudǝa ajapkera. ");
INSERT INTO kby_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisawadǝ Isa Sadusiyadǝa manan yapcǝgǝnaro fangeranniya, captane nanjuro kadira. ");
INSERT INTO kby_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Curonjan malǝm Attauraye laa tia rijapturo tiro: ");
INSERT INTO kby_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Sayinna, wadawa curo Attaura Nawi Musayedǝn finja kura wo?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isaye tiro: «“Ala Kǝmanǝmba karwunǝm ngan, ronǝm ngan, hangalnǝm ngan raye!” ");
INSERT INTO kby_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Adǝma wada kura burwoye wo! ");
INSERT INTO kby_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Koro yindiyedǝ ye ti gai: “Kǝmaskinǝm yea kǝlanǝm gairo raye!” ");
INSERT INTO kby_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wada yindi anima fǝrdu Attaura Nawi Musaye-a kitawuwa nawiyaye-a sammaye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisawadǝ nadǝn captana duwon, Isaye tayiro: ");
INSERT INTO kby_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Awi kǝla Almasiwudǝyen tǝmanuw? Ti tada wunduye?» cǝne tayia kiworo. Tiro: «Tada Mai Daudaye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Daji Isaye tayiro: «Adǝgaimaa, ndayilan gǝle Mai Dauda Ruhu Alayen tia Kǝmalan bowoyeno? Tiye: ");
INSERT INTO kby_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Kǝmandeye Kǝmaniro: ‘Namme kǝmborammilan duwon, kǝladowanǝmba cidiya sinǝmbero yakkǝkko!’ cǝnna.” ");
INSERT INTO kby_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mai Daudaye tia Kǝmalan bowojǝnadǝ, ndayilan gǝle Almasiwudǝ tadanjuro walji?» yenniya, ");
INSERT INTO kby_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","wundunjama rakce tiro jaawu cinni. Koro adǝn fuwun wunduma gadero cinju mudu kaje tiro koro cǝddǝnni. ");
INSERT INTO kby_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Daji Isaye jamadǝ-a fuwurawanju-aro: ");
INSERT INTO kby_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Malǝmba Attauraye-a Farisawa-adǝ napturam Nawi Musayen napkada. ");
INSERT INTO kby_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Adǝ nangaro awo nayiro wulnjagai sammaa dewo gaiwo. Amma bare kǝndonjadǝa diwwi, dalilnjudǝ awo wuljanadǝa cadiwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Katkun kurwowu dama bawo cakkere ngawana ambero gǝnajagai, amma tayi kǝlanja ngulondonjama casange tayia banajagaiwawo. ");
INSERT INTO kby_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kǝndonja sammaa am tayia caroro cadi. Layanja mana Alaye ye fatatallo cadi, gǝsǝr kalwunjaye ye kuruwuro cadi. ");
INSERT INTO kby_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Masǝna kuralan na darajaa-a dandallan napturam fuwuye-a caraana, ");
INSERT INTO kby_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","koro kasuwulan am tayiro lewa darajaye cadde tayia Sayinnalan bowojaiya, jaumaro caraana. ");
INSERT INTO kby_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Amma nayidǝ, bare Sayinnalan bowonjanni, dalilnjudǝ malǝmndo fal, nayi samma ye kǝramiya nangaro. ");
INSERT INTO kby_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Koro dunia adǝn bare wundumaa Bawalan bowonuwwi, dalilnjudǝ Bawando fal, ti samelan dǝganadǝ. ");
INSERT INTO kby_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Koro bare fuwumalan bowonjanni, dalilnjudǝ fuwumando fal, ti Almasiwudǝ. ");
INSERT INTO kby_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kam curondon kuramadǝ wolodindoro walji. ");
INSERT INTO kby_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nonowo, wundu duwon kǝlanjua jajakcǝnamadǝ, tia awimaro ngojaiwawo. Koro wundu duwon kǝlanjua awimaro ngojǝnnimadǝ, tia jajakcai. ");
INSERT INTO kby_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Cinna nodo bargaa Mai Samemayero ngawoyedǝa ambo jakkǝwwa. Nayi kǝlando ye ngawuwwi, koro am tiyen ngaworo majaidǝ yero dapkǝwwa. ");
INSERT INTO kby_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Kamu kwa faccǝgǝnaasoye kǝndanja sammaa buwi ye, halndo gǝraduro fuwu jamayen moduwa kuruwuro gǝrnuwi ye. Adǝ nangaro ajawundo leiran jauro kura! ");
INSERT INTO kby_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Kǝrdi falla adinndoro kalakturo bǝrǝm kura kura konuwe lardu lardu gawi. Tǝmjiya, tia kannuma nayimaa jauro konjanaro kalanguwi. ");
INSERT INTO kby_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kuttundo simoduwu kambuwaso! Nayiye: “Wundu duwon kǝla Fado Alayelan kansi juwuidǝ, awima gǝni. Amma kam kǝla dinar Fado Alayen dǝganadǝyelan kansi juwuiya, kansinju tia cǝdai!” nuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nayi kambuwa hangal bawoaso! Ndasonja gǝle kura wo, dinardǝ ra Fado Alaye dinardǝa tayirro kalakcidǝ? ");
INSERT INTO kby_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Koro nayiye: “Wundu duwon kǝla laya duwadurambelan kansi juwuidǝ, awima gǝni. Amma kam kǝla sadaa laya duwaduramdǝn gǝnaadadǝyen kansi juwuiya, kansinju tia cǝdai!” nuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nayi kambuwaso! Ndasonja gǝle kura wo, sadaadǝ ra laya duwaduram sadaadǝa tayirro kalakcidǝ? ");
INSERT INTO kby_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Adǝ nangaro kam kǝla laya duwaduramben kansi juwunamadǝ kǝla laya duwadurambe-a awo kǝlanjun gǝnaada samma-ayen kansi giwo. ");
INSERT INTO kby_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Koro kam kǝla Fado Alayen kansi juwunamadǝ kǝla Fado Alaye-a ti curonjun dǝganama-ayen kansi giwo. ");
INSERT INTO kby_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Koro kam kǝla sameyen kansi juwunamadǝ kǝla kuris kǝrmaiye Alaye-a ti kǝladǝn napcǝnama-ayen kansi giwo. ");
INSERT INTO kby_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Karasu so, bulu kaskasi so, nana soman jakka tuluwuwi, amma awo Attauralan adǝa nankuran kojǝnadǝa kolluwwa: jire dio so, kanjimaɍi fǝledu so, aman roda so. Adǝa kolluwwin awo ani yea dio wajimnjaana. ");
INSERT INTO kby_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nayi simoduwu kambuwaso! Kandana cejenuwi, amma kaɍimo yunduwi! ");
INSERT INTO kby_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Nayi ngawo tasaye-a gǝmdowolombe-adǝa tulluwe tayirro kalanguwi, amma curonjudǝ kǝnda am gadeye luwaptu so, kǝla rawo solan cǝmbǝɍǝna. ");
INSERT INTO kby_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisa kambu, burwon curo tasaye-a gǝmdowolombe-adǝa tulle duwon, ngawodǝ ye tayirro waljo! ");
INSERT INTO kby_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Nayi alama kauri garuda bullan cingada gai, ti ngawoyen kuroro shawa, amma curon silla am sanunaye-a awo tayirnambuye jiɍi jiɍi-an cǝmbǝɍǝna. ");
INSERT INTO kby_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ngaima nayidǝ, am ngawondo carune jirewuro ngonjai, amma curondodǝ nanmǝnafǝk-a nandiwi-an cǝmbǝɍǝna. ");
INSERT INTO kby_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kuttundo malǝmba Attauraye-a Farisawa-a, nayi mǝnafǝkkaso! Kauriya nawiya kureye tanduwi, taktuwuram jirewuye ye janenuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nayiye: “Ca jaman kaariyandesoyen kǝrgaiyea, tayiro kǝldǝgǝiye bu nawiyayedǝa finiyende,” nuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngainin nayima kaduwu am nawiyadǝa ceyesǝnaye nuwe shedanuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To, kǝndo diwi amwurawandoyedǝa tumogǝnowo! ");
INSERT INTO kby_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nayi kadiya, kaduwu fusiyayeso, ndayilan gǝle ranguwe ajawu kannu jaanamayero kanuwi? ");
INSERT INTO kby_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Adǝ nangaro wudǝ nawiya-a rashiduwa-a malǝmba Attauraye-a nayiro juwanjagakki. Laanjaa kǝskaro jagǝwe roro yejuwi, laanja yea dandallandon kirwolan kowonuwe bǝla bǝlan tayia basarnuwi. ");
INSERT INTO kby_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Adǝma nangaro jirewuye dunia adǝye bunja samma kǝlandoro cukkuri, bu duwon jaman Nawi Haabila jiremadǝyen tamiya har jaman Nawi Jakariya tada Barakaye katte Fado Alaye-a laya duwadurambe-ayen ronju tuluwuwwadǝyero kudero samma fidǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jiremaro nayiro wulnjagakki, awo ani samma am jaman adǝyemaro wakkajiyi. ");
INSERT INTO kby_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Jerujalem, Jerujalem, nayi duwon nawiyadǝa roro yejuwe am juwanjaanadǝro dongur kauye gǝgǝpkǝwe sanuidǝ! Alama kuwui tadawanju fefedowanjun jakcidǝ gai, ngǝwuro nayia nanin capturo raakkǝna, amma wayew. ");
INSERT INTO kby_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akko fanndo de sul kolnjaana. ");
INSERT INTO kby_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nayiro wulnjagakki, gadero wua suruwwawo, har nayiye: “Bargaa ti cu Kǝmandeyen isimadǝ!” wulluwiro.» ");
INSERT INTO kby_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isa Fado Alayen culuwuna leji duwon, fuwurawanju nanjuro isane tiro tando tando Fado Alayedǝa fǝleduwuro badiyera. ");
INSERT INTO kby_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amma Isaye tayiro: «Awo ani sammaa ruwwa, gǝna? Jiremaro nayiro wulnjagakki, kau ani sammaa wurjane fijai, har tiloma kǝla kamanjuyen gapciwaworo walji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Isa kǝla Kau Jaitunnen napcǝna duwon, fuwurawanju runjan isane tiro: «Andiro wulsagane, sawi awo ani wakkajai? Koro sa kǝndenǝm-a sidu duniaye-aye cǝdiya, awi alama duwon ambo fǝlediyidǝ wo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isaye tayiro: «Hangal gǝnanowo, bare wunduma nayia njawatkǝnni! ");
INSERT INTO kby_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Am ngǝwu cunilan isane: “Wuma Almasiwudǝ wo!” cane am kadaa cawatki. ");
INSERT INTO kby_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kǝriwu na karǝnso-a kuruwuso-alan nukcǝnaro fannuwiya, bare hangalndo cijǝnni! Sai awo ani burwon wakkajaiya duwon, amma sa njerorambe kua yaye cǝdǝnni. ");
INSERT INTO kby_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lardu-a lardu gade-a lawaladai, koro kǝrmai-a kǝrmai gade-a ye kattenjan kǝriwu gǝrjai. Kǝna ye na naro ngayi, koro cidi ye na gadegaden loloji. ");
INSERT INTO kby_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Awo ani samma badiduram boneye bas, alama kamu tia curo lejǝna gai. ");
INSERT INTO kby_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Daji nayia njadane basarnjane roro njeyesi, koro cuni nangaro jama duniaye samma wanjai. ");
INSERT INTO kby_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Daji am ngǝwu ye wua ganja koljai. Laa aman amanjaye jawui, laa gade yea wajai. ");
INSERT INTO kby_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Koro nawiya kattuwuye isane am kadaa jambajane cawatki. ");
INSERT INTO kby_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kǝla jirenambu tǝrganayen kǝrawo am ngǝwuye tǝgǝrdi. ");
INSERT INTO kby_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma kam mǝrje har sa njerorambero dǝganamadǝ njǝkkawo cuwandi. ");
INSERT INTO kby_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Koro kawuɍi kǝji nodo bargaaye adǝ ye jama duniaye sammaro shedaro wuldiyi duwon, daji njeroramdǝ isi. ");
INSERT INTO kby_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Adǝ nangaro sa duwon awo waada jauro batti masiwa kudoma lawarnju Nawi Daniyel ruwujǝnadǝ na jauro darajaan daada ruwiya, (Kǝradumadǝ asujo!), ");
INSERT INTO kby_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","daji am lardu Yahudiyayen dasaanadǝ cija kauro cagaso leja! ");
INSERT INTO kby_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kam kǝla soronjuyen dǝganadǝ bare jǝpce kare ngoduro curo sorodǝyero ngaanni! ");
INSERT INTO kby_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Koro kam kulolan dǝganadǝ ye bare kalwunju ngoduro waldǝnni! ");
INSERT INTO kby_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yim anin kamu curoa so, nganji cǝmbia sodǝ, kuttunja! ");
INSERT INTO kby_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bare kasondo sa kakuyen bi yim tustuyen wakkajǝnniro Alaa korowo! ");
INSERT INTO kby_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dalilnjudǝ sadǝn bone jauro kuttu mbeji, bone duwon sa dunia alaktǝnadǝn tai kuro kudero ngaltema jiɍinju tuwandǝnni fuwu yen fagat tuwandiwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Koro ca Kǝmande bone adǝye kawunju fulujǝnnia, wunduma njǝkkawo cuwandiwawo. Amma am kǝrejǝnadǝ nangaro kawudǝa fuluji. ");
INSERT INTO kby_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sa adǝn kam laaye nayiro: “Akkonju Almasiwudǝ!” bi “Towonju ti!” cǝnia, bare tia yasarawwi! ");
INSERT INTO kby_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Dalilnjudǝ almasiwuwa kattuwuyeso-a nawiya kattuwuyeso-a isane alama kura so, awo ajabba so cade, yoyenoa, har am kǝrejǝnadǝmaa jambajane cawatki. ");
INSERT INTO kby_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akko kawu wakkajidǝro, adǝa nayiro wulnjagakkǝna. ");
INSERT INTO kby_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Adǝ nangaro am laaye nayiro: “Towonju ti karaalan!” cania, bare lenuwwi. Bi “Akkonju ti curo ngimben!” cania, bare tayia yasarawwi. ");
INSERT INTO kby_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jiɍi same adinnamlan har fǝdero cuwalde wassidǝ gai, kǝnde Tada Kambedǝ ye ngai. ");
INSERT INTO kby_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na ɍiwa dǝganalan kowuwaso ye captai. ");
INSERT INTO kby_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Sadǝman ngawo bone yim aniyen kǝngal cǝlǝmbo walji, kumbal ye nurnju ciwawo, sillowuwaso ye samelan casuri, koro kǝnduwowa sameye ye jauro lolojai. ");
INSERT INTO kby_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Daji alama Tada Kambedǝ samelan fǝlediyi. Daji jama duniaye samma karwunja kuttaji, koro Tada Kambe kǝnduwoa-a jauro darajaa-a kǝla fofou sameyen isi carui. ");
INSERT INTO kby_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Adǝgaima malaiyawanjua nuktu kura kangadiyen cunode talgǝmo duniaye dewu samman tai ci dajiram sameyesoro yade amnju kǝrejǝnadǝa capcai. ");
INSERT INTO kby_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ya tarmuyen misal adǝa asunowo! Sa fǝktu badije kalu ɍijiya, nangǝɍi karǝnjǝnaro nonuwwa. ");
INSERT INTO kby_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngaima awo ani samma wakkajai ruwiya, ti cinnalan del karǝnjǝnaro nonowo! ");
INSERT INTO kby_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jiremaro nayiro wulnjagakki, am jaman adǝye sanuiwawo, sai awo ani samma wakkajaiya duwon. ");
INSERT INTO kby_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Same-a cidi-a baworo waljai, amma manani tǝmmaro baworo waljiwawo. ");
INSERT INTO kby_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Amma yim bi sa duwon awo ani wakkajaidǝa wunduma nojǝnni. Bawadǝro kajia, malaiyawa samelan dasaana ye nojanni, Tadadǝ ye nojǝnni. ");
INSERT INTO kby_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kǝnde Tada Kambedǝye alamanju jaman Nawi Nuhuye gai. ");
INSERT INTO kby_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Awoa jaman adǝn kawu ingi tufanaye isidǝro, amso jawui ye, casai ye, larusa so, niya so cadi ye ngai duwon, har yim ise Nawi Nuhu curo maaradǝyero kǝrgawo. ");
INSERT INTO kby_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nanjama nangi duwon, ingi tufanaye ise tayi sammaa siyeyeno. Kǝnde Tada Kambedǝye ye adǝgairo walji. ");
INSERT INTO kby_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Daji yim adǝn kongwa yindi kulolan duwon, fal ngojane fal koljai. ");
INSERT INTO kby_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Koro kamu yindi ye nedu cadi duwon, fal ngojane fal koljai. ");
INSERT INTO kby_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Adǝ nangaro faadaro dǝgaiwo, dalilnjudǝ yim Kǝmando isidǝa nonuwwi nangaro. ");
INSERT INTO kby_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amma adǝa nonowo, ca kǝma fadoyedǝ sa barwu bune fannjuro isidǝa nojǝnaa, faadaro dǝgane tia kolje fannjuro ngayiwawo. ");
INSERT INTO kby_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Adǝgaima nayi ye faadaro dǝgaiwo, dalilnjudǝ sa tǝmanuwwilan Tada Kambedǝ isi nangaro. ");
INSERT INTO kby_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wundu gǝle wolodi amanna ye, hangalla yedǝ wo, ti duwon kǝmanja tia kǝreje wolodiya amanjuro nuwanja kǝmboye sa tǝraanan njoro galajǝnadǝ? ");
INSERT INTO kby_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kǝjinju wolodi kǝmanju waldiya, ngai cǝdi najiyidǝ! ");
INSERT INTO kby_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jiremaro nayiro wulnjagakki, kǝmadǝ kǝndanju sammaa mukko wolodi adǝyero cakki. ");
INSERT INTO kby_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma wolodi adǝ ti kam batti duwon karwunjun: “Kǝmani duwan isiwawo,” cǝne ");
INSERT INTO kby_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wolodiya amanjua babaktu badije mbalmaso-a kallo jawune casairo walyenoa, ");
INSERT INTO kby_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","daji wolodi adǝye kǝmanju yim tǝmajǝnni-a sa nojǝnni-alan ise ");
INSERT INTO kby_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","tia kirwolan jajarje curo mǝnafǝkkayero cakki. Nadǝn so ye tǝdi, sheɍi ye naldi. ");
INSERT INTO kby_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Sa adǝn nodo bargaa Mai Samemaye alamanju ferowa kǝlayakku mewu fatǝlanja ngojane mai larusayedǝa kaptuwuro caluwunadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Curonjan uwu hangal bawoa, uwu ye hangalla. ");
INSERT INTO kby_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tayi hangal bawoadǝ fatǝlanja ngoyeranniya, kǝndawu ngojanni. ");
INSERT INTO kby_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amma tayi hangalladǝ fatǝlanja-a kalwo curon kǝndawu gadea-a ngoyera. ");
INSERT INTO kby_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mai larusayedǝ duwan isǝnnidǝ, tayi sammaa kǝnǝm ngoyeno. ");
INSERT INTO kby_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dawu buneyen kowo laa nukce: “Akkonju mai larusayedǝ! Luwowo tia kapkǝnowo!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Daji kǝlayakku ani samma cijane fatǝlanja dabbardu badiyera. ");
INSERT INTO kby_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Amma tayi hangal bawoadǝye hangalladǝro: “Andiro kǝndawu gana sadowo, fatǝlawande no cadi!” yeranniya, ");
INSERT INTO kby_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","hangalladǝye: “A'a, andi-a nayi-aa sadiwawo. Lenowo na ladomasoyen yuwowo!” yera. ");
INSERT INTO kby_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kǝndawu njuworo ledu cadi duwon, mai larusayedǝ kadio. Tayi dabbardanadǝ ti-a kallo na ngǝmǝri larusayero ngasaye cinnadǝ jakkera. ");
INSERT INTO kby_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ngawo adǝyen kǝlayakku gapcanadǝ ye isane tiro: “Barganǝmmin, barganǝmmin, andiro cinnadǝa fǝrǝmsaganeye!” yera. ");
INSERT INTO kby_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma mai larusayedǝye: “Jiremaro nayiro wulnjagakki, nayia nonjakkǝni,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","To, nayi ye faadaro dǝgaiwo, dalilnjudǝ yimnju bi sanju nonuwwi nangaro. ");
INSERT INTO kby_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Koro nodo bargaa Mai Samemaye alamanju kam laa bǝlawuro cǝdi cǝne wolodiyanjua bowoje kǝndanju mukkonjaro cakkǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wundunja yayero kǝla raktunjuyen talanti kaino. Kam fallo uwu ce, fallo yindi ce, fal yero fal kaino. Daji bǝlawuroro leyeno. ");
INSERT INTO kby_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sadǝman kam talanti uwu cǝmowonamadǝ leje tayilan sawur cǝde riwa uwuye kiwando. ");
INSERT INTO kby_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kam yindi cǝmowonamadǝ ye adǝgai cǝde riwa yindiye kiwando. ");
INSERT INTO kby_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma kam talanti fal cǝmowonamadǝ leje bǝlaa laje wuɍi kǝmanjuye gǝrayeno. ");
INSERT INTO kby_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Ngawo kawu kadayen kǝma wolodiya aniyedǝ bǝlawuron kadinniya, tayi-a balas kedo. ");
INSERT INTO kby_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kam talanti uwu cǝmowonamadǝ ise gade uwu cuwude tiro: “Barganǝmmin, talanti uwu simmadǝ, akko gade uwu riwaro fandǝkkǝna,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kǝmanjuye tiro: “Wuse, wolodi ngǝlama, amanma! Awo ganan aman dimmadǝ, awo ngǝwu mukkonǝmbo yakkǝkki. Are kallo kǝji fanniyo!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kam talanti yindi cǝmowonamadǝ ye ise tiro: “Barganǝmmin, talanti yindi simmadǝ, akko gade yindi riwaro fandǝkkǝna,” yenniya, ");
INSERT INTO kby_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","kǝmanjuye tiro: “Wuse, wolodi ngǝlama, amanma! Awo ganan aman dimmadǝ, awo ngǝwu mukkonǝmbo yakkǝkki. Are kallo kǝji fanniyo!” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Daji kam talanti fal cǝmowonamadǝ ye ise tiro: “Barganǝmmin, ni kam jauro nokkǝna. Na nadǝmmilan kalanǝmi, koro na kasuni finǝmmilan mowomi nangaro, ");
INSERT INTO kby_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","rinjǝkke lekke bǝlaa lakke wuɍinǝmdǝa gǝrayekko. Akko awonǝm,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amma kǝmanjuye tiro: “Ni wolodi kǝlado, kam bowuye! Na nadǝkkǝnilan kalanǝkki, koro na kasuni finǝkkǝnilan mowokkiro nonǝmma, gǝna? ");
INSERT INTO kby_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ca wuɍinidǝa bankilan gǝnanǝmmaa, waldunidǝn wuɍini riwanjua mowokkǝna. ");
INSERT INTO kby_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To, talanti faldǝa nanjun mowowo, kam nanjun mewuadǝro yowo! ");
INSERT INTO kby_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wundu duwon nanjun awoamadǝ, tiro casargane ngǝwuro walji, amma kam nanjun bawomadǝ, awo cǝdanadǝmaa tilan camoyi. ");
INSERT INTO kby_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wolodi faida bawoa adǝa deyan curo duwu cǝlǝm pǝttero gǝpkǝnowo, nadǝn so ye tǝdi, sheɍi ye naldi,” yeno. ");
INSERT INTO kby_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Sa Tada Kambedǝ darajanjua malaiyawa samman kundenno walde isiya, kǝla kurisnju kǝrmaiye darajaayen napci. ");
INSERT INTO kby_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jama duniaye samma fuwunjun captai, jiɍi sǝni dimiya-a kaniya-aa firjidǝ gai, kam kamanju-aa firje tayia kǝwu yindiro yakci. ");
INSERT INTO kby_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dimiyadǝa kǝmboramnjuro cakki, kaniyadǝ yea wailanjuro. ");
INSERT INTO kby_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Daji maidǝye tayi kǝmboramnjuyedǝro: “Nayi Bawani barga dǝmnjaanadǝ, arowo nodo bargaa duwon kawu dunia alaktǝnayen nayiro dabbargaadadǝa gandowo! ");
INSERT INTO kby_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Awoa kǝnania duwon, awo kǝmboye sew. Ngudunia yen, awo kǝnjaye sew. Wu kusotto yen, sisawuw. ");
INSERT INTO kby_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kajǝmuni bawo yen, awo jaktuye sew. Wu dondi yen, kisseyew. Kosoro sasakkǝna yen, naniro kadiw,” cǝni. ");
INSERT INTO kby_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Daji am jirewu aniye tiro: “Kǝma, yimbi nia kǝnanǝmba ngiruiye duwon, awo kǝmboye ngeiye? Ra, ngudunǝmba duwon, awo kǝnjaye ngeiye? ");
INSERT INTO kby_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yimbi kusottoro walyem duwon, njuruiye niro kiskeiye? Ra, kajǝmunǝm bawo duwon, awo jaktuye ngeiye? ");
INSERT INTO kby_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yimbi ni dondi bi kosolan duwon, njuruiye nanǝmbo kadiye?” cani. ");
INSERT INTO kby_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Maidǝye: “Jiremaro nayiro wulnjagakki, sawi duwon kǝramiyani aniye gananjaro ser yidduwiya, wumaro sidduw,” cǝni. ");
INSERT INTO kby_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Daji maidǝye tayi wailanjuyedǝro: “Nayi baskuwadadǝ, nani kollowo kannu tǝmmaro nuiwawo Yiwulis-a malaiyawanju-aro dabbarjaanadǝro ngawowo! ");
INSERT INTO kby_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Awoa kǝnania duwon, awo kǝmboye siwwi. Ngudunia yen, awo kǝnjaye siwwi. ");
INSERT INTO kby_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wu kusotto yen, sǝsaawwi. Kajǝmuni bawo yen, awo jaktuye siwwi. Wu dondi yen, kosolan yen naniro isuwwi,” cǝni. ");
INSERT INTO kby_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Daji tayi ye tiro: “Kǝma, yimbi kǝnanǝmba nia ngiruiye? Bi ngudunǝmba, bi kusotto, bi kajǝmunǝm bawoa, bi dondi, bi kosolan duwon, nia njuruiye niro kistuwuro wayeiye?” caniya, ");
INSERT INTO kby_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","maidǝye: “Jiremaro nayiro wulnjagakki, sawi duwon tayi aniye gananjaro ser njǝddoro wanuwiya, wumaro njǝddoro wanuw,” cǝni. ");
INSERT INTO kby_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Daji tayidǝ ajawu sawisoyero ngasayi, amma jirewudǝ ro sawisoyero ngasayi,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Isa mana ani sammaa cǝde kerǝnniya, fuwurawanjuro: ");
INSERT INTO kby_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Sala Laya Njǝkkayirambero kawu yindi gapcoro nonuwwa, koro Tada Kambedǝa mukko ambero sǝrǝccagane kǝskaro tia jajagane roro ceyesi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Daji wurawa ɍimannaye-a amwurawa jamaye-a fado ɍiman kura tiro Kaifas caniyen captane ");
INSERT INTO kby_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sawardane Isaa nangalan tame roro njejoye nia ngoyera. ");
INSERT INTO kby_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amma tayiye: «Sai sala kojiya duwon, bare jama hangalsango casangǝnni!» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Isa bǝla Baitaniyelan fado Siman dǝɍimayen ");
INSERT INTO kby_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","masǝna cǝdi duwon, kamu laa sǝndal curonjun kawudi jauro tamannaa ngoje ise kawudidǝa kǝla Isayero fiyeyeno. ");
INSERT INTO kby_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Fuwurawadǝ adǝa kerunniya, kutturo carune kattenjan: «Awiro kawudidǝa basarjidǝ? ");
INSERT INTO kby_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ca adǝa wuɍi kadaro calade wuɍidǝa talaawaro cadǝna!» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Isa adǝa asuje tayiro: «Awiro kamu adǝa suwolluwi? Wuro awo jauro ngǝla sǝddǝna. ");
INSERT INTO kby_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Talaawasodǝ sawisoro curondon mbeji, amma wudǝ sawisoro gǝni curondon dǝgakki. ");
INSERT INTO kby_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kawudi adǝa tiyiniro fiduwunjudǝ, sittǝraniro wua dabbarseyeno. ");
INSERT INTO kby_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jiremaro nayiro wulnjagakki, ndaran yaye curo dunia ngayen kawuɍi kǝji adǝa wuljai nguson, kamu adǝa takturo awo sǝddǝnadǝ yea wuljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Daji mewun yindindǝye falnja, kam tiro Yahusa Iskariyot canidǝ, na wurawa ɍimannayero leje ");
INSERT INTO kby_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tayiro: «Isaa mukkondoro yakkǝkkia, awi wuro siwi?» cǝne tayia kiworǝnniya, cungo ɍiwullaye fiakku mukkonjuro kesakko. ");
INSERT INTO kby_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daji sa adǝn Yahusa dama Isaa tayiro sǝrǝttuwuye mada badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yim burwoye sala Burodi Yis Bawoaye kidǝnniya, fuwurawadǝ na Isayero isane tiro: «Ndaran masǝna layayedǝa niro dabbarnjǝgǝiye bumi?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Isaye: «Bǝrnidǝro ngawowo, na kam laayero lenowo tiro wullowo: “Sayinnaye niro sanju del karǝnjǝna, fuwurawanju-a rokko masǝna layayedǝa fannǝmlan cadi,” yeno.» ");
INSERT INTO kby_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Daji fuwurawadǝ jiɍi Isa tayiro wuljǝgǝnadǝ gai kedo. Adǝgaima masǝna layayedǝa dabbaryera. ");
INSERT INTO kby_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kǝngal kikkurǝnniya, Isa mewun yindindǝ-a rokko masǝnaro napkera. ");
INSERT INTO kby_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Masǝna cadi duwon, Isaye: «Jiremaro nayiro wulnjagakki, kamndo fal wua mukko kǝladowayero sǝrǝnsiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Karwunja jauro kuttaje fal fallen wundu yaye: «Kǝma, wuma wa?» cǝne tia koro badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isaye tayiro: «Kam duwon wu-a buwururo mukko yakkiyenadǝ, tima wua sǝrǝttuwumadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tada Kambedǝ saptidǝma, jiɍi kǝlanjun kitawulan ruwuwadadǝ gai, amma kam duwon Tada Kambedǝa kǝladowanjuro sǝrǝcciyidǝ, kuttunju! Ca kam adǝ tambǝnnima tiro ngalwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Daji Yahusa kam tia sǝrǝttuwumadǝye: «Sayinna, wuma wa?» yenniya, Isaye tiro: «Nimaye wullǝmma,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Masǝna cadi duwon, Isa burodi ngoje Alaro ardiyenniya, fǝsakce fuwurawadǝro ce: «Ngonowo buiwo, adǝ tiyini,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Koro kǝnjaram ngoje Alaro ardiyenniya, tayiro ce: «Nayi samma yaiwo, ");
INSERT INTO kby_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","dalilnjudǝ adǝma buni aman ndǝptaye duwon biwu am kadaye gawurdu nangaro fidǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nayiro wulnjagakki, na adǝn fuwun gadero ingi inabbe adǝa yakkiwawo, har yim nayi-a rokko nodo bargaa Bawaniyelan bǝɍinno yakkiro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Daji aiya Alaa njungoroye yeyeranniya, caluwe Kau Jaitunnero leyera. ");
INSERT INTO kby_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Daji Isaye fuwurawanjuro: «Bune adǝman nayi samma kǝla wuyen ngaworo walduwi, akko awo kitawulan ruwuwadadǝ: “Sǝnidǝa bangǝkkiya, dimiya bǝriyedǝ tatardai.” ");
INSERT INTO kby_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amma karmolan cikkiya, nayia burwonjakke cidi Galileyero lekki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Biturusse tiro: «Tayi samma kǝla niyen ngaworo waldai yaye, wudǝ tǝmmaro ngaworo waldǝkkiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isaye: «Jiremaro niro wulnjǝgǝkki, ku bune adǝman kawu gudowom kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Amma Biturusse tiro: «Dole ni-a rokko nuiyero walyeno yaye, tǝmmaro nia angǝrnjǝkkiwawo!» yeno. Fuwurawa samma ye ngai wulyera. ");
INSERT INTO kby_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Isa fuwurawanju-a na tiro Gessemani canidǝro kadiranniya, tayiro: «Na adǝn nammowo duwon, na todǝro lekke moduwa dikke,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Daji Biturus-a tada yindi Jabadiyedǝ-aa ngoje rokko lejane karwunju kuttaje ronju jauro bannadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tayiro: «Karwuni jauro kuttajǝna, har nukki gai. Na adǝn danowo, faadaro wu-a kallo dǝgaiwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gana laa kuruwuje fǝdǝryero tǝmde moduwa cǝde: «Bawani, yojia, kǝnjaram adǝa wulan ngone! Adǝ yaye rawonidǝ gǝni, kaanǝmdǝma ti wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na fuwurawanjuyero walladanniya, kǝnǝm cadi nayeyeno. Biturusso: «Assha! Sa fallo ranguwe wu-a kallo faadaro dǝgawwawo wa? ");
INSERT INTO kby_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bare jaraptuwwiro faadaro dǝgaiwo, moduwa dewo! Ruhu kambedǝ cǝraana, amma tiyinjudǝ duno kǝskea!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Koro walde yindiyero leje moduwa cǝde: «Bawani, kǝnjaram adǝa wulan ngonǝmbawo sai yakkiyamaa, rawonǝmdǝma tǝdo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nanjaro walladanniya, caye gai kǝnǝm cadi nayeyeno, simnja nga kurwowujǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Koro walde tayia kolje yakkuyero leje mananju cayedǝlan moduwa kido. ");
INSERT INTO kby_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Daji na fuwurawadǝyero walladanniya, tayiro: «Kuamison kǝnǝmbo bowadando tussuwi wa? Sadǝ cǝdǝna, Tada Kambedǝa mukko biwumasoyero sǝrǝccaana. ");
INSERT INTO kby_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cinowo, leniyo! Akkonju kam wua sǝrǝnsiyimadǝ del karǝnjǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Isa mana cǝdi ngai duwon, Yahusa mewun yindindǝye falnja kadio. Jama kada ye na wurawa ɍimannaye-a amwurawa jamaye-ayen kashagar so, ka so mukkonna ti-a rokko kadira. ");
INSERT INTO kby_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Caman ti sǝrǝttuwumanjudǝ tayiro bǝlaanan isanojiye: «Kam tiro lewa kǝrawoye yiddǝkkidǝ, tima! Tia taiwo!» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sadǝman Yahusa na Isayero ise: «Wuse, sayinna!» cǝne tiro lewa kǝrawoye kiddo. ");
INSERT INTO kby_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isaye tiro: «Sawani, awo kǝndoro isǝmmadǝa de!» yeno. Daji amdǝ fuwujane Isaa mukkon dap keda. ");
INSERT INTO kby_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Am na Isayen dajanadǝye falnja mukko sajiye kashagar ficce wolodi ɍiman kurayea bakce sǝmonju tǝn kamgeno. ");
INSERT INTO kby_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Daji Isaye tiro: «Kashagarnǝmba fannjuro kalange! Wundu duwon kashagar ficcǝnamadǝ kashagarlaman nui. ");
INSERT INTO kby_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ra, nonǝmmi wa rangǝkke Bawania bowonǝkke sadǝman wuro malaiyawa kǝwu mewun yindinmaa kojǝnaa juwasiyidǝ? ");
INSERT INTO kby_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma ngairo walyenoa, jiɍi fin gǝle awo Ala caman kadarje kitawulan wuljǝnadǝ wakkaji?» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sa adǝn Isaye jamadǝro: «A! Nayi kashagar so, ka so mukkonna wua gǝndema gai taro wa isuwidǝ? Yim nguson Fado Alayen napkada jamaa alammǝkki duwon, wua sǝdawwi. ");
INSERT INTO kby_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma awowa nawiya kitawulan ruwujanasodǝ wakkajaro awo ani samma tadǝna,» yeno. Daji fuwurawanju samma tia koljane keyaso. ");
INSERT INTO kby_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Daji am Isaa cadanadǝ tia na Kaifas ɍiman kuradǝyero kesado, na duwon malǝmba Attauraye-a amwurawa jamaye-a ye captanadǝ. ");
INSERT INTO kby_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Biturus ye katte kaskadaaro har balballa fado ɍiman kurayedǝro tia jǝgane kǝrgaanniya, awo wakkajidǝa kuroro dawu gureduwu Fado Alayen napkeno. ");
INSERT INTO kby_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wurawa ɍimannaye-a majiliswu samma-a Isaa roro njejoro sheda kattuwuye mayera, ");
INSERT INTO kby_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","amma shedawu kattuwuye kada isana yaye, cawandǝnni. Darye am yindi isane: ");
INSERT INTO kby_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Kam adǝye rakce Fado Alayedǝa wurje curo kawu yakkuyen cǝdandi cǝnna,» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Daji ɍiman kuradǝ cije daje Isaro: «Jaawunǝm bawo wa? Awi gǝle am ani kǝlanǝmnin shedajaidǝ?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amma Isa cinju kajǝnni. Koro ɍiman kuradǝ walde tiro: «Ala Kǝndǝgaima nangaro, jire wulsagane! Nima wa Almasiwu Tada Alayedǝ wo?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isaye tiro: «Nima wullǝm, wuma! Koro nayiro wulnjagakki, kua adǝn fuwun Tada Kambedǝ mukko kǝmboram Mai Kǝnduwomayen napkada ye, curo fofou sameyen kǝnde cǝdi ye ruwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Daji ɍiman kuradǝ kalwunju karje: «A! Ti Alaa gaskajo! Sheda jiɍi fi gǝle gade maniye? Nayi kǝlando Alaa gaskadunjudǝa fannuwwa. ");
INSERT INTO kby_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Awi gǝle tǝmanuw?» cǝne tayia kiworǝnniya, tiro: «Ronju tuluwoma jusso!» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Daji laanja fǝkkanjuro lallaɍi tǝwatǝwajagane tia babakkera, laanja ye maɍin bakcane ");
INSERT INTO kby_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tiro: «Ha! Almasiwu, nawinawi de! Wundu nia bannjo?» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Biturus balballa fadoyedǝn napkada duwon, kir laa ise tiro: «Ni ye Isa kam cidi Galileye-a rokko kǝrgaw!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amma Biturus fuwu tayi sammayen angǝrje: «Awo wullǝmidǝa nokkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Daji cinna ngaworambo kiluwunniya, kir gade tia cure am nadǝn dasaanadǝro: «Kam adǝ ye Isa kam Najaratte-a rokko!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Koro Biturus walde tia angǝrje kansi juwe: «Tia nokkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gana sam kidǝnniya, am nadǝn dasaanadǝ isane Biturusso: «Fagatto ni ye kamnja fal, tǝlammǝmlan asungeiye,» yera. ");
INSERT INTO kby_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Amma Biturus kǝlanju baskuje kansi juwe: «Kam adǝa nokkǝni!» yeno. Sadǝman gudowom kokkore kekko. ");
INSERT INTO kby_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Daji Biturus awo Isa tiro wulnjǝgǝnadǝa takkeno. Isaye: «Kawu gudowom kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» cǝnna. Takkenniya, deyaro culuwe tai daje so ngoyeno. ");
INSERT INTO kby_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dunia wayenniya, wurawa ɍimannaye-a amwurawa jamaye-a samma cinja kǝljane Isaa roro ceyesi yera. ");
INSERT INTO kby_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Daji Isaa cekkere caade mukko Gomna Bilatussero kesakko. ");
INSERT INTO kby_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yahusa sǝrǝttuwumanjudǝ shara karmoye Isaro caddǝnaro kirunniya, tuwaje leje cungo ɍiwullaye fiakkudǝa wurawa ɍimannaye-a amwurawa-aro ce ");
INSERT INTO kby_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","tayiro: «Biwu dikkǝna, kam biwunju bawoa sǝrǝnnjagakkǝna,» yeno. Tiro: «Awi andia sasakko? Nima awonǝm nonǝm,» yeranniya, ");
INSERT INTO kby_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahusa wuɍidǝa Fado Alayero gǝpciye nadǝa kolje leje kǝlanju kǝskaro rojiye kano. ");
INSERT INTO kby_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wurawa ɍimannayeso wuɍidǝa capkeranniya, amanjaro: «Baitǝmbal Fado Alayero fiduwunjudǝ haram, wuɍi buye nangaro,» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Daji nia ngojane wuɍidǝn cidi duwurammaye casuwe kaurila kusottowayero kedo. ");
INSERT INTO kby_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Adǝma nangaro ku kundenno nadǝa Kulo Buyelan bowojaidǝ. ");
INSERT INTO kby_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Adǝgaima awo Kǝmande kuren ci Nawi Irimiyayen wuljǝnadǝ wakkayeno. Tiye: «Cungo ɍiwullaye fiakku, wuɍi duwon jama Israyilaye taman kǝlanjun kasaccanayedǝa ngojane ");
INSERT INTO kby_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","cidi duwurammayedǝa kesiwo, Kǝmande wulsǝgǝnadǝ gai,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isa fuwu Gomna Bilatussen dajǝna duwon, gomnadǝye tiro: «Nima wa Mai Yaudiyayedǝ wo?» cǝne tia kiworo. Isaye: «Nima wullǝm, wuma!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma wurawa ɍimannaye-a amwurawa-a tia burwuyeranniya, awima tayiro kalakcǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Daji Bilatusse tiro: «Awo kadan burwunjanadǝa fannǝmmi wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amma Isa awima tiro kalakcǝgǝnni, har gomnadǝ jauro ajapkeno. ");
INSERT INTO kby_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Caman kǝrwu nguson sala adǝlan gomnadǝ adanju jǝgane kosoma fal jama caraanadǝa tayiro salamjiyi. ");
INSERT INTO kby_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sa adǝn kosoma laa jauro nowada mbeji, cunju Barabbas. ");
INSERT INTO kby_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Daji jama capkadaranniya, Bilatusse tayiro: «Wundua nayiro salamnjagakkiya, rawuw? Barabbassa ra Isa kam tia Almasiwulan bowojaidǝa?» ");
INSERT INTO kby_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Awoa nandǝɍinja nangaro Isaa mukkonjuro sǝrǝtkeyeraro nojǝna. ");
INSERT INTO kby_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngaima Bilatus kǝla kurisnju sharayen napkada duwon, kamunju kam laaa cunode tiro: «Bare kam jirema adǝro awima yiddǝmmi, kǝla tiyen ku kǝnnasimlan jauro bone yakkǝna nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amma wurawa ɍimannaye-a amwurawa-a jamadǝa casakke Barabbassa tayiro salamjuwo Isaa roro cejo yera. ");
INSERT INTO kby_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Koro gomnadǝ walde tayiro: «Tayi yindi anilan wundunjaa nayiro salamnjagakkiya, rawuw?» cǝne tayia kiworo. Tiro: «Barabbas!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatusse tayiro: «Awi gǝle Isa kam tia Almasiwulan bowojaidǝro yiddǝkki?» cǝne tayia kiworo. Tayi sammaye: «Kǝskaro tia jagǝne no!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bilatusse: «Awiro? Ayau awiye cǝdo?» yenniya, caye baworo kowo sapcane: «Kǝskaro tia jagǝne no!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bilatus curo lamar adǝyen awima rakce cǝdiwawo ye, kalala ngǝwuji yero kirunniya, ingi ngoje fuwunjan mukkonju tulje tayiro: «Bu kam adǝyen mukkoni bawo, nayima awondo nonuw!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Amma jama sammaye: «Bunju kǝla andi-a kaduwunde-ayen dǝga!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Daji Bilatus tayiro Barabbassa salamgeyeno. Amma sojiyanjudǝa cakke Isaa kirwolan jajaryeranniya, tia kǝskaro jajaaro mukkonjaro kekko. ");
INSERT INTO kby_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Daji sojiya gomnadǝyedǝ Isaa curo gomnariyero caade kǝwunja sojiyaye sammaa fuwunjun capkera. ");
INSERT INTO kby_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tia ɍingeranniya, kalwu kime tiro lujagane ");
INSERT INTO kby_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","aɍiawu kaɍiyiye kǝlejane kǝlanjuro gǝnajagane mukkonju kǝmborambo ka kesakko. Daji fuwunjun tungurumjane tia rujane: «Ala ngǝwuro, Mai Yaudiyaye!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Koro lallaɍi tiro tǝwajagane kadǝa camoye tilan kǝlanju babakkera. ");
INSERT INTO kby_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tiro rudu gǝnajagane kerǝnniya, kalwu kimedǝa ɍinjane kajǝmunju cayedǝa lujagane tia kǝskaro jaduwuro kesado. ");
INSERT INTO kby_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Caluwuna lejai duwon, kam laa bǝla Kuraneye cunju Siman-a kǝla kǝlyera. Sojiyadǝ dunodunon tia casakke kǝska Isayedǝa ngoje ");
INSERT INTO kby_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","na tiro Golgota canidǝro leyera, Golgotaye maananjudǝ Na Buwo Kǝlaye. ");
INSERT INTO kby_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Isaro diben curonjun awo laa cǝm fok diyadaa caro kedo, amma cade kidambǝnniya, kǝnjaro wayeno. ");
INSERT INTO kby_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tia kǝskaro jayeyeranniya, kajǝmunju ngojane walawala cade kattenjan dagaryera. ");
INSERT INTO kby_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Daji nadǝn tia kuroro napkera. ");
INSERT INTO kby_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kǝlakajinjudǝro allo ayaunju kǝlan ruwuwadadǝa royeyera: TI ADƎMA ISA MAI YAUDIYAYEDƎ WO. ");
INSERT INTO kby_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Gǝndewu yindi yea ti-a rokko jayeyera, faldǝ kǝmboramnjulan, faldǝ ye wailanjulan. ");
INSERT INTO kby_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Am kamjana kojaisodǝ tiro rudu gǝnajagane kǝlanja kalakalakcane ");
INSERT INTO kby_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tiro: «Ap! Ni Fado Alayea wurnǝme curo kawu yakkuyen tandǝmidǝ, nda kǝlanǝm moye! Ni Tada Alayea, kǝskadǝn jǝmme!» cani. ");
INSERT INTO kby_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wurawa ɍimannaye ye malǝmba Attauraye-a amwurawa-a rokko adǝgai tiro rudu gǝnajagane amanjaro: ");
INSERT INTO kby_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Am gadea cǝkkaana, amma rakce kǝlanju cǝmoyiwawo! Tima Mai Israyilawuyedǝ woa, kǝskadǝn kǝrmama jǝpco, tia kasaddiye. ");
INSERT INTO kby_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Alaa mǝrsajǝna. To, Ala tia cǝraanaa, kǝrmama tia cǝmowo, tiye: “Wu Tada Alaye,” cǝnna nangaro,» cani. ");
INSERT INTO kby_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jiɍi adǝgainin gǝndewu yindi ti-a rokko jajaanadǝ ye Isaa rarayera. ");
INSERT INTO kby_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kausu kǝla dawu duwon, dunia nga tǝmje cǝlǝmbo walje, har sa yakku kajiriyero kiado. ");
INSERT INTO kby_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sa yakku kajiriyedǝ Isa kowo dunoaro sapce: «Eloi, Eloi, lama sabaktani?» yeno, maananjudǝ «Alani, Alani, awiro wua kolsem?» ");
INSERT INTO kby_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Am nadǝn dajanadǝ adǝa fangeranniya, laanjaye: «Nawi Iliyaa bowoji!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sadǝman falnja cǝgase leje soso ngoje diben comcombo lǝpciye cuttuluwe karo lassiye Isaro sayeyeno. ");
INSERT INTO kby_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amma am gapcanadǝye: «Nda kollowo, Nawi Iliya ise tia cǝkkayia, ruiyo!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Daji Isa walde kowo dunoaro sapce ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa adǝn juwa curo Fado Alayen dǝganadǝ samen tamiya kǝla cidiyannaro kudero farak yindiro kargadan. Cidi ye loloyeno, kauwa ye fafalladara, ");
INSERT INTO kby_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kauriya ye fǝrǝmdane kamin muminnaye ro carǝmbǝna kada karmolan ciyera. ");
INSERT INTO kby_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Isa karmolan ciyenniya, kaurilan caluwe bǝrni tayirro ngasaye nadǝn am kadaro fǝleyaadara. ");
INSERT INTO kby_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kajalladǝ sojiyanju Isaa gurejaimadǝ-a rokko cidi loloje awo wakkajǝnaa kerunniya, karwunja kamde: «Jiremaro ti Tada Alayedǝma!» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kamuwa kada ye kuruwunin awo ania lawarjai mbeji. Cidi Galileyen Isaa jaane banajagai. ");
INSERT INTO kby_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Curonjan Meram Magdala so, Meram Yakuba-a Isuwu-aye yanja so, tadawa Jabadiye yanja so mbeji. ");
INSERT INTO kby_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dunia kajiriyenniya, gaɍiwu laa kam Arimatiyaye cunju Isuwu kadio, ti ye fuwura Isaye. ");
INSERT INTO kby_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na Bilatussero leje kamin Isayedǝa tiro cadoro kiworǝnniya, Bilatus wada ce kamindǝa tiro kaino. ");
INSERT INTO kby_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Daji Isuwu leje kamindǝa ngoje lowowon batta linnen kǝkǝrje ");
INSERT INTO kby_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kaurinju bǝɍin curo kauyen lajǝnadǝro cakke sǝnaje ci kauridǝyero kau kura tǝmbaljiye leyeno. ");
INSERT INTO kby_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meram Magdala-a Meram faldǝ-a ye fuwu kauriyedǝn napcana mbeji. ");
INSERT INTO kby_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yim dabbarduye kojǝnaye wajǝnanjua wurawa ɍimannaye-a Farisawa-a na Bilatussen captane ");
INSERT INTO kby_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tiro: «Barganǝmmin, jambama adǝ ronjualan: “Ngawo kawu yakkuyen roaro wallǝkke cikki!” cǝnnadǝa kǝlan taiyena. ");
INSERT INTO kby_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Adǝ nangaro wada ye sojiyanǝm kauridǝa kawu yakkuro gureja, bare fuwurawanjuso isane kaminnjudǝa ndaljane ambo: “Karmolan cijǝna!” wuljanniro. Jamba daryeyedǝ burwoyedǝa koji,» yera. ");
INSERT INTO kby_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatusse tayiro: «Sojiyaa ngonowo lenowo, jiɍi nonuwwadǝ gairo kauridǝa gureja!» yeno. ");
INSERT INTO kby_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Daji kauridǝro lejane kau kura ci kauriyedǝro tawaa bakcagane sojiyadǝa gadiro gǝnayera. ");
INSERT INTO kby_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yim tustuye koyenniya, mawuye yim burwoyea suwa lǝp Meram Magdala-a Meram faldǝ-a kauridǝa kuroro leyera. ");
INSERT INTO kby_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sadǝman cidi loloyeno, malaiya Kǝmandeye laa samelan jǝpce kau kuradǝa tǝmbalje kǝladǝn napkeno. ");
INSERT INTO kby_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Camunonju mǝlǝkci gai, kajǝmunju ye bul fok. ");
INSERT INTO kby_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sojiyadǝ ridunjuro jauro lolojane am sanuna gairo walyera. ");
INSERT INTO kby_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amma malaiyadǝye kamuwadǝro: «Bare rinuwwi! Isa kam kǝskaro jajaanadǝa manuwiro nokkǝna. ");
INSERT INTO kby_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wuljǝnadǝ gai, ti na adǝn bawo, cijǝna! Arowo na tia sǝnajanadǝa ruiwo! ");
INSERT INTO kby_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Daji duwan lenowo fuwurawanjuro: “Karmolan cijǝna. Ti nayia burwonjane cidi Galileyero leji, nadǝn tia ruwi,” wulgǝnowo. Akko adǝa nayiro wulnjagakkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Daji kamuwadǝ karwunja kamdǝna ye, jauro kǝji fanjai yero kauridǝn caluwe cagase lawardǝa fuwurawanjuro njadoro leyera. ");
INSERT INTO kby_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sadǝman Isa tayia kapciye: «Wusowo!» yenniya, nanjuro isane sinjuro kamdagane tiro ambǝtkeyera. ");
INSERT INTO kby_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Daji Isaye tayiro: «Bare rinuwwi! Lenowo kǝramiyaniro wulgǝnowo cidi Galileyero leja, nadǝn wua sarui,» yeno. ");
INSERT INTO kby_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kamuwadǝ ledu cadi duwon, sojiya gureduwuye laanja bǝrnidǝro waldane wurawa ɍimannayedǝro awo wakkajǝna sammaa wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tayi ye amwurawadǝ-a rokko captane nia ngoyeranniya, wuɍi ngǝwu sojiyadǝro cade ");
INSERT INTO kby_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tayiro: «Akko awo wulluwidǝ: “Bune kǝnǝm diye duwon, fuwurawanjuso isane kaminnjudǝa ndalyera.” ");
INSERT INTO kby_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Koro gomnadǝ awo adǝa fanjia, tia lowoniye nayia njamoyiye,» yera. ");
INSERT INTO kby_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Daji sojiyadǝ wuɍidǝa camoye lejane tayiro wuljaanadǝ gai kedo. Adǝgaima ku kundenno mana adǝ curo yaudiyayen tatargada. ");
INSERT INTO kby_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Daji fuwurawa mewun tilondǝ cidi Galileyero lejane kau kuruwu Isa tayiro wuljǝgǝnadǝro kadira. ");
INSERT INTO kby_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tia kerunniya, tiro ambǝtkeyera, amma laanja dakkera. ");
INSERT INTO kby_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Daji Isa nanjaro ise tayiro: «Kǝnduwo sameye-a cidiye-a sammaa wuro sadǝna. ");
INSERT INTO kby_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Adǝma nangaro lenowo jama duniaye sammaa fuwurawaniro dewo, tayiro cu Bawadǝye-a Tadadǝye-a Ruhudǝye-alan kasala yiddowo. ");
INSERT INTO kby_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Koro wadawa nayiro njadǝkkǝna sammaa jaaro tayia alammowo. Nonowo, wu sawisoro nayi-a rokko, har cidu duniayero,» yeno.");
INSERT INTO kby_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Akko badiduram kawuɍi kǝji Isa Almasiwu Tada Alayedǝ. ");
INSERT INTO kby_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kuren curo kitawu Nawi Ishayayen ruwuwadadǝ gai: «Nin fuwunno kǝngayammi nodǝkke, jawalnǝm cassai. ");
INSERT INTO kby_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tidǝ kam laa karaan kowo sapce: “Kǝmandero jawal dabbargǝnowo, koduramnju cǝkko dewo!” cǝne mawoji.» ");
INSERT INTO kby_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nawi Yahaya Kasalama fǝlediye karaan jamaro kawuɍi kasala tuwaye biwuwa gawurduye cǝddi kǝrga. ");
INSERT INTO kby_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Adǝgaima am lardu Yahudiyaye-a bǝrni Jerujalembe-a samma nanjuro isane biwunja wuljane curo bǝrǝm Jordaniyen tayiro kasala tuwaye kiddo. ");
INSERT INTO kby_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahayaye kajǝmunjudǝ kanduɍi kaɍimoyen caaada, canjanju ye ngirin tikkerǝna. Kǝmbonju ye kawi-a kǝmagǝn-a. ");
INSERT INTO kby_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jamaro kawuɍi cǝdde: «Kam laa wua kǝnduwon kosǝna je sunonjuye ngunǝme wuiduma tikkǝni ngawonin isi. ");
INSERT INTO kby_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wudǝ ingilan nayiro kasala ngeddǝkko, amma tidǝ Ruhu Alayelan nayiro kasala njaddi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yim anin Isa bǝla Najarat cidi Galileyedǝn cije bǝrǝm Jordaniyero ise Nawi Yahaya tiro kasala kiddo. ");
INSERT INTO kby_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Isa ingidǝlan kiluwunniyama, same farakko fǝrǝmde Ruhu Alaye alama bullam gai tiro jǝpciyi kiro. ");
INSERT INTO kby_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Koro samelan kowo nukce: «Nima Tadani wo, njǝraakkǝna. Niramnin jauro karwuni kǝjijǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sadǝman Ruhu Alayedǝ tia cakke karaa dǝɍiro kiluwo. ");
INSERT INTO kby_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Karaadǝn kawu fidewuro Yiwulis tia jarapci kǝrga. Ti bundiya karaaye-a rokko, malaiyawa ye tiro kissagai. ");
INSERT INTO kby_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ngawo Nawi Yahayaa kosoro casakkǝnayen, Isa cidi Galileyero walde jamaro kawuɍi kǝji Alaye wulduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tiye: «Sadǝ cǝdǝna, nodo bargaa Alaye del karǝnjǝna! Tǝmmowo, kawuɍi kǝji Alayedǝa kasaddowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yim laa Isa ci bǝrǝm Galileyea jǝgai duwon, Siman-a yanjugǝna Andarawus-a buni taramnja bǝrǝmdǝro fijagai kiro. Tayidǝ buni tawu. ");
INSERT INTO kby_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isaye tayiro: «Arowo wua sǝgaiwo, nayia kam tawuro njadǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sadǝman buni taramnja koljane tia geya. ");
INSERT INTO kby_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Koro gana fuwuyenniya, Yakuba tada Jabadiye-a yanjugǝna Yahaya-a curo maarayen buni taramnja caassai kiro. ");
INSERT INTO kby_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sadǝman tayia bowoje cijane bawanja Jabadi-a kidawunju-aa curo maaradǝyen koljane tia geya. ");
INSERT INTO kby_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Daji Isa-a fuwurawanju-a bǝrni Kafarnaambero kadira. Yim tustuye kidǝnniyama, Isa dandallo ngaye jamaa alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jamadǝ alamdunjudǝa ajapkera, dalilnjudǝ alamdunjudǝ malǝmba Attaurayedǝ gai gǝni, kǝnduwoaro manaji nangaro. ");
INSERT INTO kby_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sa adǝn curo dandalnjadǝyen karuwama laa burwu cakke: ");
INSERT INTO kby_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«A! Awi lambonǝm andiro, Isa kam Najaratte? Andia siduwuro wa kadim? Nia asunjǝkkǝna, nima Tayir Alayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Amma Isa sedandǝro jǝkkade mana dapciye: «Cinǝm jange kamdǝa kolle luwe!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Daji sedandǝ burwu dunoa cakke kamdǝa jǝjǝkce kolje kiluwo. ");
INSERT INTO kby_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tayi samma ajapcane amanjaro: «Attǝ awi? Alamdu jiɍi bǝɍin, diye! Kǝnduwoaro sedansoro wada ciya, jagai!» cani. ");
INSERT INTO kby_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sadǝman lawar Isaye cidi Galileye ngaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dandaldǝn keluwunniyama, Isa-a Yakuba-a Yahaya-a rokko fado Simanne-a Andarawusse-aro leyera. ");
INSERT INTO kby_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ya kǝsai Simannedǝ dondi bowada, kange tia cǝdana. Daji Isaro lawarnju wulyeyeranniya, ");
INSERT INTO kby_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","nanjuro leje mukkonju cǝdane tia kisango. Kangedǝ tia kolje, ti ye tayia sosadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yim adǝa kǝngal kikkurǝnniya, am dondi-a karuwamaso-a sammaa na Isayero kewudo. ");
INSERT INTO kby_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Am bǝrnidǝye samma ci fadodǝyen captana duwon, ");
INSERT INTO kby_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isa am kada kasuwa jiɍi jiɍia isangayeyeno, koro sedanna kada duyeno. Amma sedannadǝro manadu amarjǝgǝnni, ti wunduro nojana nangaro. ");
INSERT INTO kby_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wajǝnanjua suwa lǝp Isa tawaje culuwe na wunduma baworo leje nadǝn moduwa kido. ");
INSERT INTO kby_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siman-a amanju-a ye tia madaro keluwo. ");
INSERT INTO kby_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kewandǝnniya, tiro: «Am samma nia manjai,» yera. ");
INSERT INTO kby_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Isaye tayiro: «Bǝlawa gadero leniyo, amnja yero mana Alaye yiddǝkko! Adǝma nangaro kadikko,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Adǝgaima Isa bǝla bǝlaro leje dandalnjan ambo mana Alaye wuljiyi, sedanna ye duji ngai duwon, cidi Galileye sammaa diriyeno. ");
INSERT INTO kby_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kam barasua laa na Isayero ise tungurumje tia lowoje: «Raammaa, rangǝme wua isangasǝgǝme tayirro wallǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isa kamdǝa njunoje mukko sajiye tia leje: «Raakkǝna, tayirro walle!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sadǝman barasudǝ tia kolje tayirro walyeno. ");
INSERT INTO kby_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Daji Isa tiro marmarea cǝdde tia salamgeno. ");
INSERT INTO kby_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Tiro: «Bare awima wundumaro wulgǝmmi, amma lene ɍimandǝro fǝledǝgǝne. Tayirro wallǝmmadǝ, sadaa Nawi Musa wuljǝnadǝa de, jamaro shedaro waljo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Adǝ yaye kamdǝ leje ngǝwuro manaje lawardǝa ndarasoro tataryeyeno, har Isa bǝla fimaro rakce federo ngayiwawo, sai karaa wunduma bawolan dǝgai. Koro jama ndarason yaye nanjuro isai. ");
INSERT INTO kby_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngawo kawu ganayen Isa bǝrni Kafarnaambero walladanniya, jamadǝ ti fadonno fangera. ");
INSERT INTO kby_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Am ngǝwu isane captane, har cinnaman na baworo walyeno. Tayiro mana Alaye cǝddi duwon, ");
INSERT INTO kby_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","am dewu kam tiyi nunaa laa ngojane isane nanjuro kewudo. ");
INSERT INTO kby_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amma jama captana nangaro rakcane Isaa karǝnjaiwawodǝ, daji sorodǝro jawane kǝla sorodǝye na Isa dǝganadǝn kajane kamdǝa kǝla bǝnaramnjuyen sayeyera. ");
INSERT INTO kby_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isa kambǝrsenjadǝa kirunniya, kam tiyinju nunadǝro: «Tadani, biwunǝm gawurdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Daji malǝmba Attauraye laa nadǝn napkada karwunjan: ");
INSERT INTO kby_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Awiro kam attǝ ngai wulji? Alaa gaskajǝna, diye! Ala gǝnia, wunduma kambo biwu gawurjiyi bawo, mare?» cani. ");
INSERT INTO kby_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sadǝman Isa awo karwunjaye asuje tayiro: «Awiro karwundon awo ania wulluwidǝ? ");
INSERT INTO kby_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndaso gǝle kam tiyinju nuna adǝro budu wo: “Biwunǝm gawurdǝna” wulduma ra “Cine bǝnarammǝm ngone lene!” wulduma? ");
INSERT INTO kby_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nonowo, Tada Kambedǝ nanjun kǝnduwo biwu ambe dunialan gawurduye mbeji!» yeno. Daji kam tiyinju nunadǝro: ");
INSERT INTO kby_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Niro wulnjǝgǝkki, cine bǝnarammǝm ngone fannǝmbo lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sadǝman kamdǝ fuwu am sammayen cije bǝnaramnju ngoje leyeno. Tayi samma jauro ajapcane Alaa congorǝne: «Awo adǝ gai ngaltema ruiyende!» yera. ");
INSERT INTO kby_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Koro Isa walde ci bǝrǝmbero kadio. Am kada kadami nanjuro isane tayia alamgeno. ");
INSERT INTO kby_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kodu cǝdi duwon, Lewi tada Alfawusse kidaramnju akki mowoyen napkadaa kiro. Isaye tiro: «Wua sǝgai!» yenniya, cije tia giya. ");
INSERT INTO kby_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Isa fado Lewiyen masǝnaro napcǝna duwon, akki mowomaso-a biwuma gadeso-a kada ye ti-a fuwurawanju-a rokko masǝna dioro napkera, tayi gai kada tia jaana nangaro. ");
INSERT INTO kby_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Malǝmba Attauraye kǝwu Farisawaye laa Isa biwumaso-a akki mowomaso-a rokko masǝna cadiro kerunniya, fuwurawanjuro: «Awiro Isa akki mowomaso-a biwuma gadeso-a rokko masǝna cadidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isa adǝa fangenniya, tayiro: «Kam dondi gǝnia, kam ngadǝ lowotor majiwawo. Jiremasoa gǝni, biwumasoa bowoduro kadikko,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Fuwurawa Nawi Yahayaye-a Farisawaye-a asem cadai duwon, am laa na Isayero isane tiro: «Awiro fuwurawa Yahayaye-a Farisawaye-a asem cadai, amma fuwurawanǝm cadaiwawodǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isaye tayiro: «Mai larusaye dawunjan duwon, ngaladiya asem cadai wa? A'a, mai larusaye dawunjan duwon, asem cadaiwawo. ");
INSERT INTO kby_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amma sa ise mai larusayedǝa dawunjan cattuluwiya, sa adǝn duwon asem cadai. ");
INSERT INTO kby_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Wunduma guntu batta bǝɍinne ingiro cakke captǝnni ngoje kajǝmu dinaro cukkududiwawo. Ngai cǝdia, batta bǝɍindǝ dinadǝyen capte kardudǝ cayemaro kuraro walji. ");
INSERT INTO kby_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Koro wunduma diben bǝɍin ngoje satki dinaro fijiyiwawo. Ngai cǝdia, dibendǝ satkidǝa falji. Diben ye bawo, satki ye bawo. A'a, amso diben bǝɍindǝa satki bǝɍinno fijagai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yim tustuyea laa Isa-a fuwurawanju-a kulo algamaye rejane kojai duwon, fuwurawadǝ kǝla algamaye fifirdu badiyera. ");
INSERT INTO kby_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisawa laaye tiro: «Akko rui, awiro fuwurawanǝm awo yim tustuyea kǝndoro haramdǝa cadidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Isaye tayiro: «Sa Nawi Dauda-a amnju-a kǝna fanjanadǝn, awo cǝdǝnadǝa ngaltema kitawulan kǝranuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jaman Abiyatar ɍiman kurayedǝn curo Fado Alayero ngaye burodi sadaaye ngoje jǝgǝre amnju yero ce gewo. Ɍimannaro gǝnia, am gadero burodi sadaaye ngǝrodǝ haram!» ");
INSERT INTO kby_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Daji Isaye tayiro: «Ala kamdǝa yim tustuye nangaro alakcǝnni, yim tustuyedǝa kam nangaro alakkeno. ");
INSERT INTO kby_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Adǝ nangaro Tada Kambedǝ Kǝma yim tustuye, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Koro Isa walde dandallo kǝrgawo. Nadǝn kam laa mukko canaa mbeji. ");
INSERT INTO kby_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Am laa ye Isaro ayau gǝnaduwu caraana nangaro hangalnjayen tia ninijai, yim tustuyeaman kamdǝa isangayeyenoaro. ");
INSERT INTO kby_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Daji Isa kam mukko canaadǝro: «Cine dawunden dane!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Koro jamadǝro: «Yim tustuyea ngǝla kǝndo ra diwi kǝndoma halal wo? Ro njǝkkawo ra ro tuluwoma halal wo?» cǝne kiworo. Amma gǝm kedo. ");
INSERT INTO kby_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Isa gǝrgaje kǝla karwukibbanjayen karwunju jauro kuttaje tayia ninije kamdǝro: «Mukkonǝm sane!» yeno. Sayenniya, mukkonju kǝlewa salairo walyeno. ");
INSERT INTO kby_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisawadǝ dandaldǝn keluwunniyama, lejane am Mai Hirudusse-a rokko sawardane jawal Isaa njejoye mayera. ");
INSERT INTO kby_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Daji Isa-a fuwurawanju-a cijane ci bǝrǝmbero leyera. Cidi Galileyen am kada kadami tia geya. Koro am lardu Yahudiyaye-a ");
INSERT INTO kby_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerujalembe-a lardu Idumiyaye-a cidi adinnam bǝrǝm Jordaniye-a cidi bǝrni Tirre-a Sidonne-alan kada kadami ye awo Isa cǝdisodǝa fanjane nanjuro kadira. ");
INSERT INTO kby_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Adǝgaima Isaye fuwurawanjuro bare am kada captanadǝ tia gǝgǝrǝpcaganniro maara tiro dabbarjaa yeno. ");
INSERT INTO kby_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Isa am kada isangajǝgǝna nangaro, am kasuwaasodǝ tia lejaro gǝgǝrǝptagai. ");
INSERT INTO kby_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sedanso ye tia caruiya, fuwunjun tungurumjane ngujane yiljane: «Ni Tada Alaye!» cani. ");
INSERT INTO kby_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Amma bare tia isanojaganniro tayiro jauro kikkado. ");
INSERT INTO kby_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Daji Isa kǝla kauyero juwane am tayilan mǝradunjuadǝa bowoje nanjuro kadira. ");
INSERT INTO kby_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Curonjan mewun yindin kǝreje tayia kǝngayambanjuro galayeno. Nianjudǝ ti-a rokko napca, tayia cunodo leja kawuɍinjua jamaro wuljaa, ");
INSERT INTO kby_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kǝnduwo sedan dudaye cawando. ");
INSERT INTO kby_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Akko am mewun yindin galajǝnadǝ, tayima Siman kam tiro cu Biturus cakkǝnadǝ, ");
INSERT INTO kby_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakuba tada Jabadiye, yanjugǝna Yahaya-a, tayi yindi yero cu Bonaji cakkǝna, maananjudǝ tadawa raduye, ");
INSERT INTO kby_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","koro Andarawus, Filibus, Bartolomi, Matiyu, Toma, Yakuba tada Alfawusse, Tadawus, Siman kam Kan'anaye, ");
INSERT INTO kby_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yahusa Iskariyot kam mukko kǝladowayero Isaa sǝrǝttuwumadǝ. ");
INSERT INTO kby_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Daji Isa fadoro wallada. Jama kada ye caye gai captane, har Isa-a fuwurawanju-aro masǝna boro katkero. ");
INSERT INTO kby_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kǝramiyanju adǝa fangeranniya, tia taro leyera, hangal tia maujǝna cani nangaro. ");
INSERT INTO kby_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Koro malǝmba Attauraye Jerujalemlan isanadǝye: «Beljabul tia cǝdana! Kǝnduwo mai sedannayen sedannaa duji,» yera. ");
INSERT INTO kby_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Daji Isa tayia bowoje misalnin tayiro wuljiye: «Awiawin Yiwulis rakce Yiwulissa duji? ");
INSERT INTO kby_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kǝrmai duwon kǝlanjuro yaktiyia, rakce dǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Fado duwon kǝlanjuro yaktiyia, fadodǝ ye rakce dǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yiwulis ye kǝlanju lawalaje yaktiyia, rakce dǝgaiwawo, dunonju cerǝna. ");
INSERT INTO kby_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wunduma rakce fado kam dunoayero ngaye kǝndanju cǝmoyiwawo, sai kam dunoadǝa cikkeriya duwon. Cikkeriya, kǝndanju cǝmoyi. ");
INSERT INTO kby_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Jiremaro nayiro wulnjagakki, biwu so, mana bastuye so samma kambo gawurdiyi. ");
INSERT INTO kby_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amma kam Ruhu Alayea bassimadǝ, tǝmmaro tiro gawurdiyiwawo. Biwu har abadaro gawurdiwawo cǝdo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Adǝa wuldunjudǝ, ti karuwama cani nangaro. ");
INSERT INTO kby_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Isaye yanju-a yanjugǝnaso-a isane ci fadoyen dajane am tia bowojaro kenodo. ");
INSERT INTO kby_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Am kada ye Isaa dirijane kǝljane napcana duwon, tiro: «Yanǝm-a yanǝmgǝnaso-a deyan nia manjai,» yera. ");
INSERT INTO kby_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isaye tayiro: «Wunduso yani-a yanigǝnaso-adǝ wo?» yenniya, ");
INSERT INTO kby_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","am nadǝn napcanadǝa ninije: «Akko yani-a yanigǝnaso-adǝ! ");
INSERT INTO kby_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wundu duwon awo Ala cǝraanaa cǝdimadǝ, tima yani-a yanigǝna-adǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Koro Isa walde ci bǝrǝmben jamaa alamdu badiyeno. Am kada kadami nanjun captane, har maararo ngaye napkeno. Amdǝ samma ye cidilan ci bǝrǝmdǝyen dajana ngai duwon, ");
INSERT INTO kby_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","awo kadan misalnin jamaa alamgeno. Curo alamdunjuyen tayiro: ");
INSERT INTO kby_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Fannowo, kam laa kuloro algama jǝjǝrduro kiluwo. ");
INSERT INTO kby_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jǝjǝrji ngai duwon, kasuni laa jawalnin fiyada. Daji ngudowa isane cotto gewo. ");
INSERT INTO kby_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kasuni laa ye na kau kaua katti ngǝwu bawoalan fiyada. Katti ngǝwu bawodǝro, sadǝman ɍiyeno. ");
INSERT INTO kby_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Amma kǝngal samero tatkenniya, kausu jauje fǝrdu bawo nangaro ɍimje ngamgeno. ");
INSERT INTO kby_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kasuni laa ye na ngiwian fiyada. Ngiwidǝ ɍije algamadǝa kimicciye, kǝla cakkǝnni. ");
INSERT INTO kby_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amma kasuni laadǝ ye na katti ngǝlaan fiyadanniya, ɍije kǝla ficce nema tai daje kekko, laa tada fiakku fiakku, laa firakku firakku, laa mia mia,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Daji Isaye tayiro: «Kam sǝmonjuamadǝ fanjo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na Isayen wunduma gade baworo walyenniya, tayi mewun yindindǝ-a amnju gade tia dirijane kǝljanadǝ-a kǝla misalladǝyen tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Isaye: «Nayiro asǝr nodo bargaa Alaye noduro amardǝgǝna, amma tayi dawundon bawomasodǝro awiso misalnin wuldiyi. ");
INSERT INTO kby_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngaima: “Caruima, asujaiwawo. Fanjaima, caɍiwawo. Adǝ gǝnia, Alaro waldane biwunja gawurdǝna!”» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Koro Isa walde tayiro: «Misal adǝa asunuwwi wa? Awiawin gǝle misalla gade asunuwi? ");
INSERT INTO kby_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kasuni jǝjǝrdumadǝ mana Alaye jǝjǝrjo. ");
INSERT INTO kby_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kasuni kǝla jawallen fidǝnasodǝ, tayima am manadǝa fanjana duwon, sadǝman Yiwulis ise mana tayilan fidǝnadǝa cuttuluwidǝ wo. ");
INSERT INTO kby_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tayi na kauan fidanasodǝ ye, tayima am manadǝa fanjaiyama, karwu kǝjiaro camoyidǝ wo. ");
INSERT INTO kby_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma tayilan fǝrdu bawo nangaro, tussaiwawo. Kǝla manadǝyen kuttu casaiya, bi am tayia basarjaiyama, wajane koljai. ");
INSERT INTO kby_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Am laaso ye kasuni na ngiwian fidǝnasodǝ, tayima am manadǝa fanjana duwon, ");
INSERT INTO kby_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","karwungai dio so, arsiyi mangardu so, awo gade luwaptu so karwunjaro ngasaye manadǝa kǝpcane tayiro faidajiyiwawodǝ wo. ");
INSERT INTO kby_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amma tayi na katti ngǝlaan fidanasodǝ, tayima am manadǝa fanjane ngojane karwunjan rojana tayiro faidajiyi, nema laa tadanju fiakku, laa firakku, laa mia mia casakkidǝ wo.» ");
INSERT INTO kby_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Koro Isa walde: «Fatǝladǝa kǝmon tǝmdaro ra cidiya dǝgǝllen gǝnaduro cawudi wa? A'a, tia kǝla gǝnaduramnjuyen gǝnajai. ");
INSERT INTO kby_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Awima gǝraada federo culuwiwawodǝ bawo, koro awima asǝrre isanodiwawodǝ ye bawo. ");
INSERT INTO kby_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kam sǝmonjuamadǝ fanjo!» ");
INSERT INTO kby_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Koro tayiro: «Awo fannuwiro hangal gǝnanowo! Jiɍi ambo ngalgǝwwadǝ gai, nayi yero ngalnjagai, koro adǝa kojǝna nayiro njasargai. ");
INSERT INTO kby_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kam nanjun awoamadǝ, tiro casargai, amma kam nanjun bawomadǝ, awo cǝdanadǝmaa tilan camoyi.» ");
INSERT INTO kby_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Koro Isa walde: «Nodo bargaa Alayedǝ alamanju kam laa kasuni cidiro fijiyi gai. Fijiyiya, ");
INSERT INTO kby_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","bune yen kal, kausu yen kal, bonewane cǝdi, kasunidǝ ye ɍije wuraji, amma jiɍi fin tǝdi nojǝnni. ");
INSERT INTO kby_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kattidǝma cakke nema culuwi. Burwon kal cǝdiya, kǝla ficci. Kǝla cuttuluwiya, sim cǝdi. ");
INSERT INTO kby_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bafiyama, tayida ngoje cǝwǝrdi, sa kalaye isǝna nangaro.» ");
INSERT INTO kby_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Koro Isa walde: «Awiro nodo bargaa Alayea rattalgǝiye? Misal fin gǝle tia fisarniye? ");
INSERT INTO kby_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Alamanju kasuni mutarre gai. Kasuni mutarredǝ, curo kasuniya am cidilan fijai sammayen tima tǝngǝɍi wo. ");
INSERT INTO kby_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amma fijaiya, ɍije kǝskawa jǝrwulan sammaro kura woro walje, dǝlam kura kura cǝde, har ngudoso rakcane kaudinjun fannja cadandi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kǝla raktunja fanduyen Isa tayiro mana Alayea misal kada jiɍi adǝgainin wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Misalnin gǝnia, awima tayiro wuljǝgǝnni. Amma sa nanjun jama baworo waljiya, fuwurawanjuro awiso fisarjiyi. ");
INSERT INTO kby_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yim adǝa dunia lǝmdu cǝdi duwon, Isaye fuwurawanjuro: «Leniyo bǝrǝmdǝa falliyo ci ingiye todǝro koniyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Daji jamadǝa kolyeranniya, maaradǝn Isaa ngojane leyera. Maara gade ye rokkonjun mbeji. ");
INSERT INTO kby_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Daji karuwa dunoa cije ingi bǝrǝmbe cambalje maaradǝro fidiye, har maaradǝa lǝptu mayeno. ");
INSERT INTO kby_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sadǝn Isa ngawo maaradǝyen kǝlanju birlan kǝnǝm cǝdi. Fuwurawanjudǝ tia kǝnǝmnin kesangǝranniya, tiro: «Sayinna, nuiye, ni lambonǝm bawo wa?» yera. ");
INSERT INTO kby_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Isa cije karuwadǝro jǝkkade ingi bǝrǝmbedǝro: «Waldǝne gǝm bone!» yenniya, karuwadǝ daje dunia gǝmbo walyeno. ");
INSERT INTO kby_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Daji Isaye tayiro: «Awiro yaayew? Kua yaye kambǝrsendo bawo wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Fuwurawanjudǝ jauro rijane amanjaro: «A! Wundu gǝle kam attǝ? Karuwa-a bǝrǝm-ama mananju jagai!» yera. ");
INSERT INTO kby_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Daji Isa-a fuwurawanju-a bǝrǝmdǝa faljane kojane cidi Gǝrasawuyero kadira. ");
INSERT INTO kby_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Isa maaradǝlan jǝpkenniyama, karuwama laa kaurilalan culuwe tia kapkeyeno. ");
INSERT INTO kby_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kamdǝ kaurilalan kǝrga, koro wunduma rakce tia cikkeriwawo. Saɍgalaman tia geroro yojiwawo. ");
INSERT INTO kby_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Calan ngǝwuro sinju-a mukkonju-aro saɍga casakkǝna yaye, kullum kǝjan kǝjanno kakamji. Wunduma rakce tia rojiwawo. ");
INSERT INTO kby_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bune-a kausu-a curo kaurila-a kauwa-ayen burwu cakke tiyinju kaunin rereji kǝrga. ");
INSERT INTO kby_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kamdǝ Isaa kuruwun kirunniya, cǝgase ise fuwunjun tungurumje nguje ");
INSERT INTO kby_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","dunonjuro yilje: «Awi lambonǝm wuro, Isa Tada Ala Mai Samemaye? Fuwu Alayen lowonjǝkkǝna, bare wuro ajawu gǝnasǝgǝmmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Adǝa wuldunjudǝ, Isaye calan tiro: «Sedan, kamdǝa kolle luwe!» cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Daji Isaye tiro: «Wundu cunǝm?» cǝne kiworǝnniya, tiye: «Cuni Kǝwu Sojiyaye, andi kada nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bare tayia cididǝlan dujǝnniro Isaa ngǝwuro lowoyeno. ");
INSERT INTO kby_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nadǝn alade kada kǝla kau kuruwuyen newo cadi ye mbeji. ");
INSERT INTO kby_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Koro sedannadǝ Isaa lowojane: «Aladeyadǝro dusagane curonjaro ngayiyo!» yera. ");
INSERT INTO kby_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tayiro amarjiye caluwe curo aladeyadǝyero kasargawo. Daji aladeyadǝ alama dǝwu yindi gai ngǝrǝmjane kaulan jǝpcane bǝrǝmdǝro fidagane ingiye ngoje kasuno. ");
INSERT INTO kby_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sǝniya aladeyayedǝ cagase lejane bǝladǝ-a karaanju-alan lawardǝa ambo wulyeyera. Amdǝ ye awo wakkajǝnadǝa kuroro keluwo. ");
INSERT INTO kby_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na Isayero isane kam duwon tilan kǝwu sedannaye caluwunadǝ kajǝmunju ye lujǝna, hangalnju ye kalkaljǝna napkada kerunniya, riyera. ");
INSERT INTO kby_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tayi lamar adǝa carunadǝ awo karuwamadǝ-a aladeyadǝ-aro wakkajǝgǝnadǝa amdǝro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Daji amdǝ ye Isa cidinja koljoro tia lowodu badiyera. ");
INSERT INTO kby_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Isa maaradǝro ngayi duwon, kam tilan sedanna caluwunadǝ ye Isaa lowoje kasacco rokkonjun dǝga yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Isa tiro amarjǝgǝnni, tiro: «Waldǝne fannǝmbo, ser kura Kǝmande niro njǝddǝnadǝ-a jiɍi nia njunonjǝnadǝ-a tayiro satkǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Daji kamdǝ leje cidi Bǝlamewuyen ser kura Isa tiro cǝddǝnadǝa ambo wulduwu badiyeno. Tayi samma ajapkera. ");
INSERT INTO kby_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Koro Isa walde maaradǝn bǝrǝmdǝa falje koyenniya, jama kada isane tia dirijane kǝlyera. Isa ci bǝrǝmben duwon, ");
INSERT INTO kby_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","kam laa wurawa dandaldǝye falnja cunju Jairus nadǝro kadio. Isaa kirunniya, fuwunjun tungurumje ");
INSERT INTO kby_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tia jauro lowoje: «Feroni kǝlayakku no cǝdi. Are mukkonǝm tiro gǝnagǝne, ngajo roaro dǝgaro!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Isa cije kamdǝ-a rokko leyera. Koro jama kada jaane tiro kǝkǝldagane tia gǝgǝrǝpkeyera. ");
INSERT INTO kby_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kamu laa ye nadǝn mbeji, kǝrwu mewun yindinno bu fidunju dajǝnni. ");
INSERT INTO kby_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mukko karwunma ngǝwusoyen jauro leiya cana, koro kǝndanju sammaa cuwatkǝna yaye, kalkalnju cuwandǝnni, kasuwadǝ fuwu juwui. ");
INSERT INTO kby_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Daji lawar Isayedǝa fangenniya, kamudǝ ise ngawoyen susuje kalwunjudǝa leyeno, ");
INSERT INTO kby_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","awoa karwunjun: «To, kajǝmunju bas lekkia, ngakki,» cǝni. ");
INSERT INTO kby_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sadǝman bu fidunju dayeno, koro nanlewa cuwandǝnaro tiyinjun fangeno. ");
INSERT INTO kby_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sadǝman Isa ye kǝnduwo tilan culuwunaro asuje dawu jamadǝyen suworde: «Wundu kalwuni lejo?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Fuwurawanjudǝye tiro: «A! Jamadǝ niro kǝkǝldagane gǝgǝrǝmnjaana rumma duwon, wundu nia lenjoro korǝmidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amma Isa memeje kam adǝa cǝdǝnadǝa kuroro mayeno. ");
INSERT INTO kby_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kamudǝ awo tiro wakkajǝgǝnadǝa nojǝna nangaro, rije lolojiaro ise fuwunjun tungurumje tiro jiredǝ ngaa wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Daji Isaye tiro: «Feroni, kambǝrsenǝm nangaro njǝkkawo fandǝmma! Kǝlewan lene, nanlewa yade!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Isa tiro manajiyi ngai duwon, am laa fado fuwuma dandalledǝro isane tiro: «Feronǝm bawojǝna. Awiro malǝmdǝa gadero suwollǝmi?» yera. ");
INSERT INTO kby_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amma Isa awo wuljaidǝa fangenniya, fuwuma dandalledǝro: «Bare rinǝmmi, biya yasarai!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Biturus-a Yakuba-a yanjugǝna Yahaya-a gǝnia, bare wunduma gade tia jǝganni yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Fado fuwuma dandalledǝro kadiranniya, Isa jama captana kalala fijai kiro, laa so cadi, laa waiyo cani. ");
INSERT INTO kby_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kǝrgaanniya, Isaye tayiro: «Awiro kalala finuwi ye, so diwi yedǝ? Ferodǝ bawojǝnni, kǝnǝm cǝdi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amma tia rujane tiro kaasu keddo. Amdǝ sammaa deyaro kittuluwunniya, ferodǝye bawa-a ya-a am tia casadduwunadǝ-aa ngoje na ferodǝyero kasargawo. ");
INSERT INTO kby_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ferodǝa mukkoyen kidanniya, tiro: «Talita kum!» yeno, maananjudǝ: «Feroma, niro wulnjǝgǝkki, cine!» ");
INSERT INTO kby_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sadǝman ferodǝ cije dadadu badiyeno. Tidǝ kǝrwunju mewun yindin. Adǝa kerunniya, jauro ajapkera. ");
INSERT INTO kby_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Daji Isa wada ce tayiro bare wunduma lawar adǝa fanjǝnni yeno. Koro awo kǝmboye ferodǝro cado yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Daji Isa nadǝa kolje bǝla wurajǝnadǝro kadio. Fuwurawanju ye tia geya. ");
INSERT INTO kby_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yim tustuyea dandallan jamaa alamdu badiyeno. Am tia kǝrǝnjana ngǝwuso ajapcane: «Ndaran kam attǝ awo ania kiwando? Nanrashidu tiro tina attǝ awi? Koro ndayilan awo ajabba ajabba mukkonjuyen tǝdi? ");
INSERT INTO kby_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ti gǝna katako karoma, tada Merambe, yeiya Yakubaye-a Josiye-a Yahusaye-a Simanne-adǝ wo? Koro yanjugǝnawa ferowadǝ-a rokko kǝrgaiye, mare?» cane tia kasatturo wayera. ");
INSERT INTO kby_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isaye tayiro: «Nawi curo bǝlanjaye-a durnjuye-a am fannjaye-aro kajia, darajanjua,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Adǝ nangaro nadǝn awo ajabba ajabba rakce cǝdǝnni, sai am dondi gana laaro mukkonju gǝnajiye tayia isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Adǝgaima Isa kǝla kambǝrsenambunjayen ajapkeno. Daji bǝla bǝlaro leje jamaa alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Daji Isa mewun yindindǝa bowoje tayiro kǝnduwo kǝla sedannayen ce tayia yindi yindiyen nodo badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tayiro wada ce bǝlawurodǝro ka gǝnia, bare awima ngojanni: kǝmbo, bi ngǝrwu, bi wuɍi, ");
INSERT INTO kby_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","koro suno casakko, amma bare gǝmaje yindi ngojanni yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Koro tayiro: «Ndaran yaye fado ngawuwwadǝn nammowo, har kawu nadǝa kolluwiro. ");
INSERT INTO kby_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amma ndaran yaye nayia njamowonni bi manando fandu wayeraa, nadǝa kolluwiya, katti sindoye kagangowo, tayiro shedaro waljo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Adǝgaima kǝngayambanjudǝ lejane ambo kawuɍi cadde tuwa cado yera. ");
INSERT INTO kby_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sedan kada duyera, koro am dondi kadaro kǝndawu jaitunne fijagane samjagane tayia isangayeyera. ");
INSERT INTO kby_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mai Hirudus lawar ani sammaa fangeno, dalilnjudǝ cu Isayedǝ ndarasoro tatardǝgǝna nangaro. Am laaye: «Yahaya Kasalama roaro walje cijo! Adǝma nangaro kǝnduwo awo ajabba ajabba dioye nanjun mbeji,» cani. ");
INSERT INTO kby_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Laaye: «Ti Nawi Iliya,» cani. Laaye: «Ti nawi, nawiya kureye falnja gai,» cani. ");
INSERT INTO kby_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Amma Mai Hirudus adǝa fangenniya, tiye: «Yahaya kam kǝlanju kammǝkkǝnadǝ roaro walje cijo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Caman Mai Hirudus Ya Hirudiyaa, ti kamu yanjugǝna Mai Filibusse duwon, kamuro cǝmowona. Ti nangaro, Mai Hirudus cakke Yahayaa cadane cekkere kosoro kesakko, ");
INSERT INTO kby_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","dalilnjudǝ Yahayaye Mai Hirudusso: «Kamu yanǝmgǝnaye mowodǝ haram!» cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Koro Ya Hirudiya Yahayaa wul wajǝna, har tia roro njejoro maji. Amma jawal cuwandǝnni, ");
INSERT INTO kby_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dalilnjudǝ Mai Hirudus Yahayadǝ jirema ye, kam Alaye yero asujiye tia rije cǝɍiwi nangaro. Mai Hirudus tia kǝrǝnjiya, hangalnju ciji, adǝ yaye mananju fanduro cǝraana. ");
INSERT INTO kby_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngaima duwon Ya Hirudiyaye sanju kadio. Saanduri Mai Hirudus tambǝnaye kidǝnniya, Mai Hirudus wakkillanju-a kajallawanju-a amwurawa cidi Galileye-aro masǝna kǝji dabbaryeyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fero Ya Hirudiyaye ise bikke kirandǝnniya, Mai Hirudus-a kusottowanju-a ye karwunja jauro kǝjiyeno. Maidǝye ferodǝro: «Awi yaye ronǝm cǝraanadǝa suwore niro njikke!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kansi juwune tiro: «Kore! Awodǝ reda cidiniyero walyeno yaye, niro njikki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Daji ferodǝ culuwe yanjuro: «Yani, awiro tia korǝkki?» yenniya, Ya Hirudiyaye: «Kǝla Yahaya Kasalamaye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sadǝman ferodǝ dǝgalje na Maidǝyero walde tiro: «Wuro kǝrmamaro kǝla Yahaya Kasalamaye curo buwuruyen simiya, raakko!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Maidǝ karwunju jauro kuttu yaye, kansi bonju-a kusottowanju-a nangaro ferodǝro daptuwu cǝraanni. ");
INSERT INTO kby_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sadǝman kowonanju laaro wada ce kǝla Yahayayedǝa cuwudo yeno. Kowonadǝ leje kosolan kǝla Yahayaye kamje ");
INSERT INTO kby_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kǝlanjudǝa buwurulan cuwude ferodǝro kaino, ti ye ngoje yanjuro kaino. ");
INSERT INTO kby_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Fuwurawa Yahayaye lawar adǝa fangeranniya, isane kaminnju ngojane caade kauriro casakke sǝnayera. ");
INSERT INTO kby_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kǝngayambadǝ na Isayen captane awo cadǝna-a jiɍi jamaa alamjana-a sammaa tiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Isaye tayiro: «Arowo runde karaa na wunduma bawo laaro leniyo, tussowo!» yeno, dalilnjudǝ am kada kadami nanjaro isane waldai, har dama masǝna dioyemaa cawandǝnni nangaro. ");
INSERT INTO kby_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Daji tayi runja maararo ngasaye karaa na wunduma baworo leyera. ");
INSERT INTO kby_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amma ledu cadilan am kada tayia carune asujane bǝla samman caluwe silan cagase tayin fuwunno nadǝro leyera. ");
INSERT INTO kby_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isa maaradǝn jǝpkenniya, jama kada captanadǝa cure tayia njunoyeno, tayi alama dimiya sǝni bawoa gai nangaro. Daji awo kadan tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dunia lǝmgenniya, fuwurawanju isane tiro: «Na adǝ karaa bowu, koro dunia ye lǝmjǝna. ");
INSERT INTO kby_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jamadǝa salamme, bǝla-a bǝladeya-asoro leja awo kǝmboye cesiwo!» yera. ");
INSERT INTO kby_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amma Isaye tayiro: «Nayima awo kǝmboye tayiro yowo!» yeno. Tayiye: «A! Leniye kǝmbo dinariyus yer yindia yuwiye tayiro yiye wa?» yera. ");
INSERT INTO kby_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Isaye: «Burodi ndawu taw? Lenowo ruiwo!» yeno. Lejane kerunniya, tiro: «Uwu buni yindi-a,» yera. ");
INSERT INTO kby_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Daji Isa wada ce jamadǝa yakca kǝwu kǝwuro kǝla kajim kǝɍiyen napca yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Adǝgai amdǝ yaktane laa mia mia, laa fiwu fiwuro napkera. ");
INSERT INTO kby_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Daji burodi uwudǝ-a buni yindidǝ-a ngoje kǝla samero sapce Alaro ardiyenniya, burodidǝa fǝsakce fuwurawanjuro ce fuwu jamadǝyen gǝnayera. Koro buni yindidǝ yea tayi sammaro dagaryeyeno. ");
INSERT INTO kby_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tayi samma jawune kulyera. ");
INSERT INTO kby_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Fuwurawadǝ gaptowo burodiye-a buniye-aa capkeranniya, jowo mewun yindin kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Am kǝmbo adǝa jawunadǝ kongwa dǝwu uwu. ");
INSERT INTO kby_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sadǝman Isa fuwurawanjudǝa cakke tin fuwunno bǝrǝmdǝa koja ci todǝro bǝla Baitsaidayero lejaro maararo kasargawo, ti ye jamadǝa salamji yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tayia salamgenniya, moduwa dioro kǝla kau kuruwuyero giwa. ");
INSERT INTO kby_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kǝngal kikkurǝnniya, maaradǝ dawu ingiyen, Isa ye ti tilonju lok kǝla kauyen. ");
INSERT INTO kby_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Karuwa dunoa nangaro fuwurawanju kiaddin fuwuro lejairo kirunniya, Isa sa yakku buneyen kǝla ingiyen silan nanjaro kadio. Karǝnnjayen kodu cǝraana duwon, ");
INSERT INTO kby_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Isa kǝla ingiyen silan ledu cǝdidǝa kerunniya, kaime kam nunaye cane burwu kesakko. ");
INSERT INTO kby_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tayi samma tia caruna ye, karwunja kamdǝna ye. Sadǝman Isa tayiro manajiye: «Karwundo gerowo, wuma! Bare rinuwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Daji tayiro kǝldiye maaradǝro kǝrgaanniya, karuwadǝ gǝm nǝmgeno. Tai dajane ajapcana, ");
INSERT INTO kby_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","dalilnjudǝ maana lamar burodi uwuyedǝa asujanni, kǝlanja tikkerǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Daji bǝrǝmdǝa faljane koyeranniya, cidi Genesarettero isane maaradǝa kekkero. ");
INSERT INTO kby_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Maaradǝn jǝpkeranniyama, am cididǝye Isaa asuyera. ");
INSERT INTO kby_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Adǝgaima amdǝ cagase cididǝ ngaro tatardagane amnja dondiso kǝla bǝnaramnjayen ngojane ndara yaye na ti mbeji fanjanadǝro njado badiyera. ");
INSERT INTO kby_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bǝladeya, bi bǝla, bi bǝla kuloye, biya ndara duwon na lejǝna ngasoro am dondisodǝa ngojane cawude ci kalwunjuye runju lejaro tia lowoyera. Am kalwunjudǝa lejana samma ngayera. ");
INSERT INTO kby_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisawa-a malǝmba Attauraye laa-a Jerujalemlan isane na Isayen capkadaranniya, ");
INSERT INTO kby_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","fuwurawanju laa mukkonja tayir gǝnin bǝri jawui kero, maananjudǝ mukkonja tuljanni. ");
INSERT INTO kby_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wotte Farisawadǝ-a yaudiya samma-a ada amwurawanjayea jaane mukkonja kalkallo tuljannia, kǝmbo jawuiwawo. ");
INSERT INTO kby_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kasuwulan isaiya, kasaldannia, kǝmbo jawuiwawo. Koro ada gade kada cadana cadi mbeji, gǝmdowolom so, tasa so, kulo so tulda gai. ");
INSERT INTO kby_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Daji Farisawa-a malǝmba Attauraye-aye Isaro: «Awiro fuwurawanǝmdǝ ada amwurawayedǝa koljane mukkonja tayir gǝnin kǝmbo jawuidǝ?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Isaye tayiro: «Nayi mǝnafǝkkaso, awo Kǝmande kuren ci Nawi Ishayayen kǝlandon wuljǝnadǝ jire, kitawulan ruwuwadadǝ gai. Tiye: «“Jama adǝ cilan wuro daraja sadi, amma karwunjan nanin kuruwujana. ");
INSERT INTO kby_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","De sullo wuro ambǝnsagai, alamdunjadǝ wada kambe,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Wada Alaye kolluwe ada kambe gawwa.» ");
INSERT INTO kby_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Koro tayiro: «Fagat, wada Alaye wanuwe adando garo jauro nonuwwa! ");
INSERT INTO kby_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kuren Nawi Musaye: “Bawanǝm-a yanǝm-aro daraja ye!” koro “Kam duwon bawanju bi yanjua rujǝnamadǝ, tia roro ceyeso!” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma nayiye: “Kam bawanju-a yanju-aro: ‘Awo nanin nuwandoro tǝmanuwwadǝa Alaro gǝnagǝkkǝna,’ cǝnia, ");
INSERT INTO kby_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bare gadero bawanju-a yanju-aro banajǝgǝnni,” nuwi. ");
INSERT INTO kby_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Adǝgaima adando tatarnuwe mana Alayedǝa bowuro kalakkew. Koro awo kada jiɍi adǝ gai diwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Koro Isa walde jamadǝa nanjuro bowoje tayiro: «Nayi samma fannowo, asunowo! ");
INSERT INTO kby_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Awo deyalan curo kambero ngaye kamdǝa tayir gǝniro cǝdima bawo, amma awowa curo kamben caluwidǝ, tayima kamdǝa tayir gǝniro cadi wo. ");
INSERT INTO kby_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kam sǝmonjuamadǝ fanjo!» ");
INSERT INTO kby_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Isa jamadǝa kolje fadoro kǝrgaanniya, fuwurawanjudǝ kǝla misal adǝyen tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Isaye tayiro: «A! Nayi ye kǝla jakkadaa wa? Awi yaye deyalan curo kambero ngaanadǝ kamdǝa tayir gǝniro cǝdiwaworo nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dalilnjudǝ karwunjuro gǝni, curonjuro ngaye tiyinjuyen culuwi,» yeno. Adǝgainin kǝmbo samma halallo asuyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Isaye walde tayiro: «Awo curo kamben culuwidǝ, tima kamdǝa tayir gǝniro cǝdi wo. ");
INSERT INTO kby_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dalilnjudǝ niadiwi so, jarawa so, nambarwu so, kam njejo so, ");
INSERT INTO kby_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kǝnjǝna so, mangar so, nankǝlado so, curoyindi so, nanjane so, nandǝɍi so, ngadar so, rokura so, hangalnambu so karwu kambedǝman caluwi. ");
INSERT INTO kby_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Awo diwi ani samma curo karwudǝyen caluwe kamdǝa tayir gǝniro cadi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Daji Isa cije nadǝa kolje lardu bǝrni Tirre-a Sidonne-ayero leyeno. Bare wunduma ti mbejiro asujǝnniro fado laaro kǝrgawo, amma gǝradunjudǝ yojǝnni. ");
INSERT INTO kby_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kamu laa feronju kǝlayakku karuwaa lawar Isaye fangenniya, ise fuwunjun tungurumgeno. ");
INSERT INTO kby_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kamudǝ lardu Gǝresse tia cidi Siri-Fenisiyelan kesambo. Daji Isa sedandǝa feronjulan dujoro tia ngǝwuro lowoyeno. ");
INSERT INTO kby_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isaye tiro: «Kolle burwon yalla jawo kulja, kǝmbo yallayedǝa ngonǝme kǝrisoro njodǝ jussǝnni!» yenniya, ");
INSERT INTO kby_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","kamudǝ tiro kalakciye: «Aaa, Kǝma. Adǝ yaye kǝrisodǝma kǝmbo yalla koljane cidiro cukkurǝnadǝa jawui,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Daji Isaye tiro: «Kǝla mananǝm adǝyen lene, sedandǝ feronǝmlan culuwuna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Adǝgaima kamudǝ fadoro walladanniya, feronju kǝla dǝgǝllen bowada nayeyeno, koro sedandǝ tilan culuwuna. ");
INSERT INTO kby_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Daji Isa lardu bǝrni Tirredǝa kolje cidi bǝrni Sidonneyen koje bǝrǝm Galileye cidi Bǝlamewudǝyero kadio. ");
INSERT INTO kby_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nadǝn tiro kam laa muwa ye, kǝgǝnji ye cakkude Isaa lowojane mukkonju tiro gǝnajuwo yera. ");
INSERT INTO kby_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isa kamdǝa dawu am captanayen sǝgǝriro kittuluwunniya, ngulondonju curo sǝmo yindi kamdǝyero cakke lallaɍi tǝwaje tǝlam kamdǝyea leyeno. ");
INSERT INTO kby_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Daji Isa kǝla samero sapce captiye sinje: «Efata!» yeno, maana efatayedǝ fǝrǝmdǝne. ");
INSERT INTO kby_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sadǝman sǝmo kamdǝye fǝrǝmde, awo tǝlamnjuro mana dapcǝgǝna ye wuide, farakko manadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Isa amdǝro wada ce bare wundumaro wuljaganni yeno. Amma wada ce sapciyi yaye, cayemaa kojǝnaro manajaidǝma. ");
INSERT INTO kby_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amdǝ jauro na kojǝnaro ajapcane: «Awisoa kalkallo cǝdǝna, har muwasoa fanjairo cǝdi ye, kǝgǝnjisoa manajairo cǝdi ye!» cani. ");
INSERT INTO kby_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yim anin caye gai jama kada na Isayen mbeji, koro awima kǝmboye nanjan bawo. Daji Isa fuwurawanjua nanjuro bowoje tayiro: ");
INSERT INTO kby_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Jama kada adǝa njunokkǝna, dalilnjudǝ ku rokkonilan kawunja yakku, koro awima kǝmboye nanjan bawo nangaro. ");
INSERT INTO kby_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kǝnanjaa duwon tayia fannjaro lejaro salammǝkkia, jawallan dunonja baworo walji, laanja kuruwun isana nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Fuwurawadǝye tiro: «Ndaran gǝle karaa adǝn kam rakce kǝmbo cuwande jama ania ambaji?» yera. ");
INSERT INTO kby_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isaye tayiro: «Burodi ndawu nandon?» cǝne kiworǝnniya, tiro: «Tulur,» yera. ");
INSERT INTO kby_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Daji Isa jamadǝa cakke cidin napkera. Burodi tulurdǝa ngoje Alaro ardiyenniya, fǝsakce fuwurawanjuro ce fuwu jamadǝyen gǝnaja cǝne fuwunjan gǝnayera. ");
INSERT INTO kby_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Buni sanana ye nanjan mbeji. Isa bunidǝ yea ngoje Alaro ardiyenniya, fuwurawanjuro ce fuwu amdǝyen gǝnaja yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jamadǝ jawune kulyera. Fuwurawadǝ gaptowodǝa capkeranniya, jowo kalaram tulur kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nadǝn am alama dǝwu dewu gai mbeji. Daji Isa jamadǝa salamgenniyama, ");
INSERT INTO kby_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ti-a fuwurawanju-a maararo ngasaye cidi Dalmanutayero leyera. ");
INSERT INTO kby_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Daji Farisawa laa isane kambiwu Isaro njǝddo badiyera. Tia rijapturo alama laa sameye tayiro fǝlejuworo mayera. ");
INSERT INTO kby_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Amma Isa captiye sinje: «Awiro am jaman adǝye alama majaidǝ? Jiremaro nayiro wulnjagakki, alama fima am jaman adǝyero fǝlediyiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Daji tayia kolje maaradǝro walde ngaye bǝrǝm falje kanji todǝro koyeno. ");
INSERT INTO kby_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Fuwurawadǝ ngessane burodi ngojanni. Burodi fal curo maaradǝyen gǝnia, nanjan awo kǝmboye bawo. ");
INSERT INTO kby_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isa sǝmonja kasse tayiro: «Yis Farisawa-a Mai Hirudus-ayero hangal gǝnanowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tayidǝ kattenjan kǝla burodinja bawoyen mana badiyera. ");
INSERT INTO kby_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isa adǝa asuje tayiro: «Awiro kǝla burodi nandon bawoyen mananuwidǝ? Ra, kua yaye ruwe asunuwwi wa? Nayi kǝla tikkerǝnaa wa? ");
INSERT INTO kby_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Simndoa duwon ruwwawo wa? Sǝmondoa duwon fannuwwawo wa? Ra, nayi ngeskada? ");
INSERT INTO kby_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Burodi uwu am dǝwu uwuro fǝsakkeyekkǝniya, gaptowodǝn jowo ndawu yimbǝɍuw?» yeno. Tiro: «Mewun yindin,» yera. ");
INSERT INTO kby_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Isaye: «Koro burodi tulur am dǝwu dewuro fǝsakkeyekkǝniya, gaptowodǝn jowo kalaram ndawu yimbǝɍuw?» Tiro: «Tulur,» yera. ");
INSERT INTO kby_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Daji tayiro: «To, kua yaye asunuwwi wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Isa-a fuwurawanju-a bǝla Baitsaidayero kadiranniya, am laa kambu laaa cawude Isaa lowojane kamdǝa lejo yera. ");
INSERT INTO kby_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Daji Isa kambudǝa mukkoyen cǝdane jeje ngawo bǝlayero kittuluwo. Simnjuro lallaɍi tǝwajiye tiro mukko gǝnajiye: «Awo laa rumi wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kambudǝ kǝla sapce: «Aaa, am rukki, amma alamanja kǝska dadajai gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Koro Isa walde simnjuro mukko gǝnayeyenniya, ricce sim cuwande awiso farakko curuiro walyeno. ");
INSERT INTO kby_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Daji Isaye: «Bare bǝladǝmaro waldǝme ngaammi!» cǝne kamdǝa salamje fadoro lejo yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isa-a fuwurawanju-a bǝladeyaso cidi bǝrni Kaisariya Filibiyen dasaanadǝro leyera. Kǝla jawallen duwon, Isaye fuwurawanjuro: «Wunduro wua amsodǝ ngosera?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tayiye: «Am laa Yahaya Kasalama cani, laaye Nawi Iliya cani, laaye nawiya kureye falnja cani,» yera. ");
INSERT INTO kby_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Daji Isa walde: «Nayidǝ, wunduro wua ngosew?» cǝne tayia kiworǝnniya, Biturusse: «Nima Almasiwudǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Amma Isa sǝmonja kasse tayiro bare wundumaro ti wunduro wuljaganni yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Koro Isa fuwurawanjuro Ala kadarjǝna Tada Kambedǝ kuttu tai daje cane amwurawa-a wurawa ɍimannaye-a malǝmba Attauraye-a tia wajane roro ceyesi, koro kawu yakkua roaro walje ciji cǝne tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Adǝa federo tayiro wulyeyeno. Biturus tia sǝgǝriro cuttuluwe tiro njǝkkado badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma Isa suworde fuwurawanjua kirunniya, Biturusso jǝkkade: «Nani kolle, Yiwulis! Awo karwunǝmlan tammadǝ Alaye gǝni, kambe!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Daji Isa jamadǝ-a fuwurawanju-aa nanjuro bowoje tayiro: «Kam laa wua ga cǝraanaa, mǝradu kǝlanjuye wajo kǝskanju karmoye ngojo wua sǝga. ");
INSERT INTO kby_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dalilnjudǝ wundu duwon ronju ɍiwo cǝraanamadǝ ronjudǝa cuwatki, amma wundu duwon wu-a kawuɍi kǝji Alaye-a nangaro ronju cuwatkǝnamadǝ ronjudǝa cǝɍiwi. ");
INSERT INTO kby_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kam dunia adǝ ngaa jǝgande ronju asarjiya, nda riwanju? ");
INSERT INTO kby_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awi gǝle kam ce ronju cuwandi? ");
INSERT INTO kby_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wundu duwon jaman am kǝnjǝna so, awo diwi so dioye adǝn kǝla wu-a manani-ayen nangujǝnamadǝ, Tada Kambedǝ ye daraja Bawanjuyen malaiyawa sameye-a rokko isiya, tia nanguji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Koro Isa walde: «Jiremaro nayiro wulnjagakki, am laa na adǝn daada mbeji, kawu kawunja dajidǝro, nodo bargaa Alaye kǝnduwoaro isi carui,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngawo adǝyen kawu arakkua Isa cije Biturus-a Yakuba-a Yahaya-a runjaa ngoje kǝla kau kuruwu laayero gewa. Fuwunjan Isaye alamanju falde ");
INSERT INTO kby_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","kajǝmunju ye bul fok tai daje yiyiljiro walyeno, jiɍi wunduma dunialan kare tulje rakce buljiwawodǝ gai. ");
INSERT INTO kby_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Koro Nawi Iliya-a Nawi Musa-a tayiro fǝledagane Isa-a jandedu badiyera. ");
INSERT INTO kby_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Daji Biturusse Isaro: «Sayinna, andi na adǝn mbejidǝ jauro ngǝla. Kolle ngurwo yakku lammiyo: fal kaanǝm, fal Nawi Musaye, fal ye Nawi Iliyaye,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Awo wuljidǝmaa nojǝnni, tayi rijana nangaro. ");
INSERT INTO kby_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Daji fofou ise tayia jakkeno. Curo fofoudǝyen kowo nukce: «Adǝma Tadani wo, tia jauro raakkǝna. Mananju fannowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sadǝman memeyeranniya, Isa tilonju lon gǝnia, wundumaa carunni. ");
INSERT INTO kby_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kǝla kaudǝyen jǝpcai duwon, Isa tayiro sapciye bare awo caruna adǝa wundumaro wuljaganni, sai Tada Kambedǝ karmolan cijiya duwon yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tayi ye lamar adǝa curonjan royera, amma awi maana karmolan ciduyedǝ woro kattenjan tawori kasarga. ");
INSERT INTO kby_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Daji fuwurawadǝye tiro: «Awiro malǝmba Attaurayedǝ sai Nawi Iliya burwoje isi canidǝ?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Isaye tayiro: «Jiremaro Nawi Iliya burwon ise awiso kalkallo kalakci. Awiro gǝle kitawulan Tada Kambedǝ tai daje kuttu cane am tia rujane wajai ruwuwadadǝ? ");
INSERT INTO kby_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma nayiro wulnjagakki, Nawi Iliya isǝna, koro awiso kuttu ronja cǝraanaa tiro keddo, jiɍi kǝlanjun kitawulan ruwuwadadǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na fuwurawa gapcanadǝyero kadiranniya, am kada kadami tayia dirijane kǝljana, koro malǝmba Attauraye ye tayiro kambiwu caddi kero. ");
INSERT INTO kby_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jamadǝ Isaa kerunniyama, tayi samma ajapcane cagase isane tia lewayera. ");
INSERT INTO kby_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Daji Isaye fuwurawadǝro: «Kǝla awiyen tayi-a kambiwu diwi?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Curo jamadǝyen kam laaye tiro: «Sayinna, tadani niro njukkudǝkko. Ti karuwaa, sedandǝ tiro mana dapcǝgǝna. ");
INSERT INTO kby_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndaran yaye karuwadǝ tia cǝdaiya, tia cidiro bǝp gǝpciye, cinju nga bilwua sheɍinju nalje suji. Sedandǝa dujaro fuwurawanǝmba lowoyekkǝniya, tayiro katkero,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Isaye tayiro: «Nayi am jaman adǝyeso kambǝrsenambuwu, har sawi gairo dawundon dǝgakki? Koro sawi gairo nayia rannjakki? Tadadǝa wuro sukkudowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Daji tadadǝa tiro kekkudo. Sedandǝ Isaa kirunniyama, tadadǝa bakce, kar kar loloje cidiro cure cinju nga bilwua fǝrwǝryeno. ");
INSERT INTO kby_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isaye bawa tadadǝyedǝro: «Tǝn sawi gai adǝ tiro wakkajiyi?» cǝne tia kiworo. Kamdǝye tiro: «Gananjun. ");
INSERT INTO kby_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tia njejoro ngǝwuro kannu so, ingi soro gǝpcǝgǝna. Rangǝmia, marne njunosane andia sasane!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Daji Isaye tiro: «A! Rangǝmia? Kam duwon mǝrsajǝnamadǝro awiso yoji!» ");
INSERT INTO kby_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sadǝman bawa tadadǝye kowo sapce: «Mǝrsanjǝkkǝna, marne kambǝrsenambunin banasǝgǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isa am kada nadǝro cagase isairo kirunniya, sedandǝro jǝkkade: «Nima sedan muwa kǝgǝnjima, wada njikki, tia kolle luwe, bare gadero tiro ngaammi!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Daji sedandǝ burwu cakke tadadǝa tai daje bakce fǝrdakce kolje kiluwo. Tadadǝ alama kamin gairo walje, har am ngǝwuye: «Ti bawo, nuna!» yera. ");
INSERT INTO kby_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amma Isa tia mukkoyen cǝdane sapkenniya, tadadǝ cije dayeno. ");
INSERT INTO kby_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Isa fadoro kǝrgaanniya, fuwurawanjuye runjan tiro: «Awiro sedandǝa duda andiro katkero?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Isaye tayiro: «Moduwan gǝnia, jawal sedan jiɍi adǝa duduye bawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Daji Isa-a fuwurawanju-a nadǝa koljane cidi Galileyen koyera. Isa wunduma nojiya cǝraanni, ");
INSERT INTO kby_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","dalilnjudǝ fuwurawanjua alamji nangaro. Tayiro: «Tada Kambedǝa mukko ambero sǝrǝccagane tia roro ceyesi. Ngawo tia ceyesǝnayen kawu yakkua roaro walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma fuwurawadǝ mana adǝa asujanni, koro tia kororo riyera. ");
INSERT INTO kby_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Daji Isa-a fuwurawanju-a bǝrni Kafarnaambero kadira. Isa curo fadoyen duwon, tayiro: «Kǝla awiyen jawallan kambiwu diwidǝ?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma tayi cinja kajanni, dalilnjudǝ jawallan kambiwu kǝla wundunja kura woyen cadǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Daji Isa napce tayi mewun yindindǝa bowoje tayiro: «Kam laa fuwumaro waldu cǝraanaa, jama sammaye ngawoma-a wolodinja-aro waljo!» ");
INSERT INTO kby_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Daji tadaana laaa ngoje dawunjan isadayeyeno. Tadadǝa nganjiro ngoyenniya, tayiro: ");
INSERT INTO kby_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wundu duwon tadaana adǝ gaia cunilan cǝmowonamadǝ, wumaa sǝmowo. Koro wundu duwon wua sǝmowonamadǝ, wua gǝni, ti wua sunodǝnamadǝa cǝmowo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yahayaye Isaro: «Sayinna, kam laa sedanso cunǝmlan duji kiruiyendeya, andia saanni nangaro, tiro dapkeyeiye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amma Isaye: «Bare tiro dapkǝwwi, dalilnjudǝ wunduma cunilan awo ajabba laaa cǝdidǝ rakce diwini wuljiwawo. ");
INSERT INTO kby_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Awoa kam lawalamande gǝnidǝ kaande. ");
INSERT INTO kby_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wundu duwon nayi Almasiwuye nangaro ingi kǝnjaye gǝmdowolom fal njadǝnamadǝ, jiremaro nayiro wulnjagakki, tǝmmaro mukowanju fucciwawo. ");
INSERT INTO kby_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Wundu duwon tadawa sanana wua mǝrsasanaso aniye falnjaa cakke talje biwu cǝdidǝ, kamdǝye daunjuro kau neduram mafǝndi lujagane bǝrǝmbo gǝpcaanama tiro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mukkonǝm njakke tallǝme biwu dimia, tia kamme! Mukko yindia kannu jaanamaye tǝmmaro nuiwaworo ngawodǝroa, maskin ro sawisoyero ngaammama niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Curo jaanamayedǝn kuɍi tiyidǝa jawuidǝ sanuiwawo, koro kannudǝ ye tǝmmaro nuiwawo. ");
INSERT INTO kby_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Koro sinǝm njakke tallǝme biwu dimia, tia kamme! Si yindia kannu jaanamayero nia gǝptuwudǝroa, dungu ro sawisoyero ngaammama niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Curo jaanamayedǝn kuɍi tiyidǝa jawuidǝ sanuiwawo, koro kannudǝ ye tǝmmaro nuiwawo. ");
INSERT INTO kby_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Koro simmǝm njakke tallǝme biwu dimia, tia kulaine! Sim yindia kannu jaanamayero nia gǝptuwudǝroa, sim falla nodo bargaa Alayero ngaammama niro ngalwo. ");
INSERT INTO kby_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Curo jaanamayedǝn kuɍi tiyidǝa jawuidǝ sanuiwawo, koro kannudǝ ye tǝmmaro nuiwawo. ");
INSERT INTO kby_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Wunduso kannulan mandaaro walji. ");
INSERT INTO kby_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mandadǝ ngǝla, amma kǝlambo walyenoa, jiɍi fin gǝle cayenju gairo walji? Adǝ nangaro nayi kǝlando mandaaro wallowo, amando-a ye nanlewan dǝgaiwo!» ");
INSERT INTO kby_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Daji Isa nadǝa kolje cidi Yahudiyaye ngawo bǝrǝm Jordaniyen dǝganaro leyeno. Caye gai jama kada tiro captagane, koro walde tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisawa laa Isaa rijapturo isane tiro: «Kam kamunju dǝptadǝ halal wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Isaye tayiro: «Awi Nawi Musa nayiro wadaro njado?» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tiro: «Nawi Musa kakkadu kamu dǝptaye ruwunǝme tia koldu kwaro amarjǝgǝna,» yera. ");
INSERT INTO kby_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Isaye tayiro: «Kǝlakibbundo nangaro Nawi Musa wada adǝa nayiro ruwungeyera. ");
INSERT INTO kby_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma badiduramnin: “Ala tayia kongwa-a kamu-aro alakkeno.” ");
INSERT INTO kby_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Dalil adǝyero kwa bawanju-a yanju-aa kolje kamunjuro kǝrdiye ");
INSERT INTO kby_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tayi yindiso tiyi fallo waljai.” Adǝgaima kua adǝn fuwun tayidǝ yindi gǝni, tiloro waljana. ");
INSERT INTO kby_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Adǝ nangaro awo Ala kǝljǝnadǝa bare kam firjǝnni!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tayi fadon duwon, fuwurawanju kǝla mana adǝyen tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Isaye tayiro: «Wundu duwon kamunjua dǝpce gade niyajǝnadǝ tiro biwu cǝdde kǝnjǝna cǝdǝna. ");
INSERT INTO kby_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Koro kamu duwon kwanjua dǝpce gade niyajǝnadǝ, ti ye kǝnjǝna cǝdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Am laa Isa yallanja sananaa mukkon lejoro nanjuro cawudi duwon, fuwurawadǝ amdǝa wusayera. ");
INSERT INTO kby_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Isa adǝa kirunniya, karwunju waje fuwurawanjuro: «Yalladǝa kollowo naniro isa, bare tayiro dapkǝwwi! Nodo bargaa Alayedǝ am tayi gaiye nuwanja, diye! ");
INSERT INTO kby_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jiremaro nayiro wulnjagakki, wundu duwon tadaana gai nodo bargaa Alayedǝa kasaccǝnnidǝ tǝmmaro ngayiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Daji yalladǝa nganjiro ngoje kǝlanjaro mukko gǝnajiye tayiro barga dǝpkeyeno. ");
INSERT INTO kby_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isa cije jawal kidanniya, kam laa cǝgase ise fuwunjun tungurumje tiro: «Malǝm ngǝlama, awi dikke ro sawisoye fandǝkki?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isaye tiro: «Awiro wua ngǝlaman bowosǝmi? Ala gǝnia, wunduma ngǝla bawo. ");
INSERT INTO kby_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wadawadǝa nonǝmma: Bare ro kambe tuluwummi, bare kǝnjǝna dimmi, bare nambarwu dimmi, bare shedakambu dimmi, bare kamba jambanǝme kǝndanju bummi, bawanǝm-a yanǝm-aro daraja ye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kamdǝye: «Sayinna, tǝn gananilan wada ani sammaa gakkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isa tia ninije kirawo. Tiro: «Awo fal nia maunjǝna. Lene kǝndanǝm sammaa lade talaawaro ye, arsiyi samelan fandǝmi. Daji are wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kamdǝ mana adǝa fangenniya, ti jauro gaɍiwu nangaro fǝkkanju kǝrje karwu kuttuaro sapkadan. ");
INSERT INTO kby_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isa memeje fuwurawanjuro: «Gaɍiwuye nodo bargaa Alayero ngawonju jauro jau, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fuwurawadǝ mana adǝa ajapkera. Amma Isa walde tayiro: «Tadawani, nodo bargaa Alayero ngawodǝ jauro jau! ");
INSERT INTO kby_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gaɍiwuye nodo bargaa Alayero ngawonjudǝro kaɍimoye cuwuɍi ɍiwurayen kodunjuma budu wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Fuwurawadǝ cayemaa kojǝnaro ajapcane amanjaro: «Assha! Adǝgaia, wundu gǝle njǝkkawo cuwandi?» yera. ");
INSERT INTO kby_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isa tayia ninije: «Kambo yojiwawo, amma Alaro gǝni. Alaro awiso yoji!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Daji Biturusse tiro: «Akko andi awindeso kolliye nia njǝgaiyena,» yenniya, ");
INSERT INTO kby_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isaye: «Jiremaro nayiro wulnjagakki, wunduma cuni-a kawuɍi kǝji Alayedǝ-a nangaro fado, bi yeiya, bi kanna, bi bawa, bi ya, bi yalla, bi kulo koljǝnadǝ ");
INSERT INTO kby_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dunia adǝman fado, yeiya, kanna, ya, yalla, kulo gadegade mia mia kuttu-ason cuwandiwawoma bawo. Koro leira wakkajiya, ro sawisoye ye cuwandi. ");
INSERT INTO kby_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amma am burwoye ngǝwu daryeyero waljai, koro daryeye ye burwoyero waljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Isa-a fuwurawanju-a jawal Jerujalembe ngojana duwon, Isa tayin fuwunno ledu cǝdi. Fuwurawadǝ ajapcana, koro am tia jagaisodǝ ye rijana. Koro Isa walde mewun yindindǝa sǝgǝriro cuttuluwe awo tiro fuwun wakkajiyidǝa tayiro wulduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tayiro: «Fannowo, Jerujalembo leniye, Tada Kambedǝa mukko wurawa ɍimannaye-a malǝmba Attauraye-aro sǝrǝccagane shara ro tuluwoye tiro cadde mukko kǝrdiyayero casakke, ");
INSERT INTO kby_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tayi ye tia rujane tiro lallaɍi tǝwajagane kirwolan jajarjane roro ceyesi. Koro kawu yakkua roaro walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Daji tadawa Jabadiye Yakuba-a Yahaya-a na Isayero isane tiro: «Sayinna, awo njuworiyemadǝa andiro saddǝmiya, rayiye!» yera. ");
INSERT INTO kby_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Isaye tayiro: «Awi nayiro njaddǝkkiya, rawuw?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tiro: «Marne, kǝrmainǝm darajaa fandǝmiya, kolsane nammiyo, fal kǝmborammǝmlan, fal ye wailanǝmlan!» yera. ");
INSERT INTO kby_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Isaye tayiro: «Awo koruwwadǝmaa nonuwwi. Ranguwe kǝnjaram yakkidǝn yawi wa? Koro ranguwe kasala dikkidǝa diwi wa?» cǝne tayia kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tiro: «Aaa, rangiye!» yera. Isaye tayiro: «Kǝnjaram yakkidǝn yawi ye, kasala dikkidǝa diwi ye. ");
INSERT INTO kby_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amma kǝmborammilan so, wailanilan so naptadǝ, wu gǝni kambo amargǝkki, na anidǝ am tayiro dabbargaadaye,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fuwurawa mewu gapcanadǝ adǝa fangeranniya, Yakuba-a Yahaya-aro gǝrgayeyera. ");
INSERT INTO kby_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Daji Isa tayi sammaa bowoje tayiro: «Nonuwwa, curo jama kǝrdiyasoyen am duwon jama tayia maiyaro ngojanasodǝ talaawanjaa jauro raccaana, koro fuwumanjaso ye amnjaro kǝnduwo fǝlejagai. ");
INSERT INTO kby_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma dawundon ngai gǝni. Wundu duwon dawundon kuraro waldu cǝraanamadǝ wolodindoro waljo! ");
INSERT INTO kby_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Koro wundu duwon fuwumandoro waldu cǝraanamadǝ kaɍea nayi sammayero waljo! ");
INSERT INTO kby_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Awoa Tada Kambedǝma tiro nanwolodi caddoro gǝni kadio, nanwolodi cǝdo ronju co am ngǝwu merujoro kadio,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Isa-a fuwurawanju-a bǝla Jerikoyero kadira. Jama kada-a rokko Jerikolan keluwunniya, kambu laa cunju Bartimawus tada Timawusse ci jawallen napkada lowo cǝdi mbeji. ");
INSERT INTO kby_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Isa kam Najarattedǝ kojiro fangenniya, kowo saptu badije: «Isa, Tada Mai Daudaye, wua njunosǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Am ngǝwu tiro jakkade mǝdǝk napco yera, amma cayea kojǝnaro kowo sapce: «Tada Mai Daudaye, wua njunosǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Daji Isa daje: «Tia bowonowo iso!» yeno. Kambudǝa bowojane: «Bare tǝma kollǝmmi! Cine nia bowonji,» yera. ");
INSERT INTO kby_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kambudǝ awonju jaktuye gǝpce cije na Isayero kadio. ");
INSERT INTO kby_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isaye tiro: «Awi niro njǝddǝkkiya, raam?» cǝne tia kiworo. Kambudǝye: «Sayinna, sim fandǝkkiya, raakko!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Daji Isaye tiro: «Lene, kambǝrsenǝm nangaro njǝkkawo fandǝmma!» yeno. Sadǝman sim cuwande jawallan Isaa ga badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerujalemba karǝnjane gǝre bǝla Baitfajeye-a Baitaniye-a na Kau Jaitunnedǝro kadiranniya, Isa fuwurawanjuye yindi cunode ");
INSERT INTO kby_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tayiro: «Bǝla fuwundoyedǝro lenowo! Ngawuwiyama, kutta koroye wunduma tiro ngalte juwanni tuwada nagǝwi. Fǝrangowo kudowo! ");
INSERT INTO kby_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kam laaye nayiro: “Awiro adǝa diwi?” cǝnia, tiro: “Kǝmadǝ tilan mǝradunjua, kǝrmama kalakci,” wulgǝnowo!» ");
INSERT INTO kby_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Daji lejane kuttadǝ lailan ci fadoyen tuwada nayeyera. Kuttadǝa fǝrakcai duwon, ");
INSERT INTO kby_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","am laa nadǝn daadaye tayiro: «Awi diwi? Awiro kuttadǝa fǝranguwi?» yera. ");
INSERT INTO kby_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jiɍi Isa tayiro wuljǝgǝnadǝ gairo jaawu cadǝne amdǝ ye tayia kolyera. ");
INSERT INTO kby_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Daji kuttadǝa na Isayero cawude kalwuwanja kǝladǝro ferjagane Isa juwane napkeno. ");
INSERT INTO kby_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jama kada ye kalwuwanja kǝla jawallen feryera, laa ye ngǝlai karaan kamjane jawaldǝlan sǝretkera. ");
INSERT INTO kby_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Am fuwu gǝrjana so, ngawonju jaana so kowo sapcane: «Hosanna! Bargaa ti cu Kǝmandeyen isimadǝ! ");
INSERT INTO kby_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nodo bawande Mai Daudaye isimadǝa bargaajo! Hosanna, Mai Samemaro daraja tio!» cani. ");
INSERT INTO kby_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Adǝgaima Isa Jerujalembo ise Fado Alayero kǝrgawo. Awiso kirunniya, dunia lǝmjǝna nangaro, tayi mewun yindindǝ-a rokko caluwe bǝla Baitaniyero leyera. ");
INSERT INTO kby_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wajǝnanjua Isa fuwurawanju-a bǝla Baitaniyelan keluwunniya, kǝna tia kida. ");
INSERT INTO kby_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kuruwun ya tarmuye kalunjua kirunniya, waneye tada cuwandi cǝne nadǝro kadio. Kadinniya, kalu gǝnia, awima cuwandǝnni, dalilnjudǝ sa tarmuye gǝni nangaro. ");
INSERT INTO kby_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Daji Isaye tarmudǝro: «Bare wunduma gadero tadanǝm juwunni!» yeno. Koro fuwurawanju adǝa fangera. ");
INSERT INTO kby_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Daji Isa-a fuwurawanju-a Jerujalembo kadira. Isa balballa Fado Alayero ngaye ladomaso-a njuwomaso-aa dudu badiyeno. Tewur wuɍi canjimasoye-a napturam tattawar ladomasoye-aa tǝmbalje ");
INSERT INTO kby_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","wundu yayero Fado Alayedǝyen karea kodu dapkeyeno. ");
INSERT INTO kby_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Daji jamadǝa alamje tayiro: «Kitawulan ruwuwada: “Fannidǝa fado moduwaye jama dunia sammayelan bowojai,” amma nayidǝ tia jongo gǝndewuyero kalakkew!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wurawa ɍimannaye-a malǝmba Attauraye-a adǝa fangeranniya, jawal Isaa njejoye madu badiyera. Isaa rijana, dalilnjudǝ jama samma alamdunjudǝa ajapcana nangaro. ");
INSERT INTO kby_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dunia lǝmgenniya, Isa-a fuwurawanju-a bǝrnidǝn keluwo. ");
INSERT INTO kby_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wajǝnanjua suwa lǝp jawaldǝyen kojai duwon, ya tarmuyedǝa har fǝrdunjuro ngau ngamjǝna kero. ");
INSERT INTO kby_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Daji Biturus takce Isaro: «Sayinna, akko rui! Tarmu baskunǝmmadǝ ngamjǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isaye tayiro: «Alaa mǝrsanowo! ");
INSERT INTO kby_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jiremaro nayiro wulnjagakki, wundu duwon kau kuruwu adǝro: “Cine bǝrǝmbo fidǝgǝne!” cǝne karwunjun shekku baworo awo wuljǝnadǝ wakkajiro mǝrsajiya, wakkaji. ");
INSERT INTO kby_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Adǝ nangaro nayiro wulnjagakki, awi yaye moduwalan koruwiya, tia fanduwwaro mǝrsanowo, kaandoji. ");
INSERT INTO kby_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Moduwaro danuwwa duwon, kam laa karwun tawwaa, tia gawurnowo! Bawando Mai Samema ye biwundo gawurnjagai. ");
INSERT INTO kby_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amma tia gawurnuwwia, Bawando Mai Samema ye biwundo gawurnjagaiwawo.» ");
INSERT INTO kby_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Koro Isa-a fuwurawanju-a waldane Jerujalembo kadira. Isa curo Fado Alayen dadaji duwon, wurawa ɍimannaye-a malǝmba Attauraye-a amwurawa-a nanjuro isane ");
INSERT INTO kby_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tiro: «Kǝnduwo filan awo ania dimi? Wundu niro kǝnduwo awo ania dioyedǝa njo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isaye tayiro: «Wu ye nayiro koro fal njaddǝkki, wuro jaawudǝa sewo. Siwia, wu ye kǝnduwo filan awo ania dikkidǝa nayiro wulnjagakki. ");
INSERT INTO kby_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kasala Yahaya jamaro cǝddǝnadǝ, sameyen kadio ra kamben? Wuro jaawudǝa sewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Daji kattenjan sawardane: «“Sameyen” wulliyea, andiro: “To, awiro gǝle tia kasadduwwidǝ?” cǝne sawori. ");
INSERT INTO kby_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amma “Kamben” wulliye wa?» yera. Adǝa wuldunjadǝ, jamadǝa rijana, dalilnjudǝ am samma Yahayaa nawiro ngojana nangaro. ");
INSERT INTO kby_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Daji Isaro: «Noniyende,» yera. Isaye tayiro: «Wu ye kǝnduwo filan awo ania dikkidǝa wulnjagakkiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Daji Isa misalnin wurawa adinwuyesoro manaduwu badiyeno. Tayiro: «Kam laa jǝrwu inabbe cǝde garje curodǝn bǝlaa ingi inabbe tuluwoye laje soro kuruwu juworoye kidando. Daji jǝrwudǝa jǝrwuwu laaro agǝrijiye bǝlawuroro sapkada. ");
INSERT INTO kby_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sa fǝrdoye kidǝnniya, nuwanju cuwandoro kaɍeanju laaa na jǝrwuwudǝyero kinodo. ");
INSERT INTO kby_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amma jǝrwuwudǝ tia cadane bakcane mukko dea duyera. ");
INSERT INTO kby_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Koro walde kaɍea gade kinodo. Ti yea cadane kǝlanju bakcane tia basaryera. ");
INSERT INTO kby_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Koro walde kaɍea gade kinodǝnniya, tia roro keyeso. Koro kaɍeawa gade kada kinodo. Laanjaa bakkera, laanjaa keyeso. ");
INSERT INTO kby_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kamnju falma tiro gapcuwo, tadanju jauro cǝraanadǝ. Darye tiye: “Tadaniro daraja cadi,” cǝne tia nanjaro kinodo. ");
INSERT INTO kby_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amma jǝrwuwudǝ kattenjan: “Adǝma warasamadǝ wo! Arowo tia yejiyo, warasadǝ kaandero walji!” yera. ");
INSERT INTO kby_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Daji tia cadane roro ceyese ngawo jǝrwudǝyen gǝpkera. ");
INSERT INTO kby_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","To, kǝma jǝrwuyedǝ awi cǝdi? Ise jǝrwuwu ania roro ceje am gadero jǝrwunjudǝa ci. ");
INSERT INTO kby_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Awo kitawulan ruwuwada adǝa kǝranuwwi wa? «“Kau duwon fado tandomaso wajanamadǝ, tima kau tandoye sammaro faidaaro waljǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Adǝ kǝndo Kǝmandeye, andiro jauro ajabba!”» ");
INSERT INTO kby_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jawal tia taye majai duwon, jamadǝa riyera, dalilnjudǝ kǝlanjaman misaldǝa kidoro asujana nangaro. Daji tia koljane sapkadara. ");
INSERT INTO kby_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Daji wurawa adinwuyesodǝ Isaro curo mananjuyen bǝlaa lajaa cane Farisawa laa-a am Mai Hirudussa jaana laa-aa nanjuro kenodo. ");
INSERT INTO kby_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kadiranniya, tiro: «Sayinna, ni kam jirema ye, wundumaa rinǝmbawo yero noniyena, dalilnjudǝ gayirnǝmbawo, jawal Alaye kalkallo yikkǝrami nangaro. To, Kaisarro akki njodǝ halal ra haram? Yiye ra bare yiyende?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Amma Isa nanmǝnafǝknjadǝa asuje tayiro: «Awiro wua rijamsuwi? Wuro dinariyus sukkudowo rukke!» cǝne ");
INSERT INTO kby_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","dinariyus tiro kekkudo. Tayiro: «Cu-a kǝla-a wunduye tilan dasaa?» cǝne tayia kiworǝnniya, tiro: «Kaisarre,» yera. ");
INSERT INTO kby_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Daji Isaye tayiro: «Awo Kaisarredǝa Kaisarro yowo, koro awo Alayedǝa Alaro yowo!» yeno. Adǝgaima tia jauro ajapkera. ");
INSERT INTO kby_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusiya laa, tayi cinowo duniaye bawo wuljaidǝ, na Isayero isane tiro koro cadde: ");
INSERT INTO kby_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Sayinna, Nawi Musaye: “Kam laa yanjugǝna tada bawoa bawoje kamu koljia, kamu yanjugǝna faccǝgǝnayedǝa niyajo yanjugǝnaro kaduwu majuwo!” ruwujǝna. ");
INSERT INTO kby_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Akko yaana tulur mbeji. Burwoyedǝ kamu ngoje tada cuwandǝnnin bawoyeno. ");
INSERT INTO kby_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yindiyedǝ ye kamudǝa niyaje tada cuwandǝnnin bawoyeno. Yakkuyedǝ ye ngai. ");
INSERT INTO kby_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Adǝgaima tayi tulur samma tada cawandǝnnin bawoyera. Darye kamudǝ ye bawoyeno. ");
INSERT INTO kby_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, tayi tulurso tia camowonadǝ, cinowo duniayen kamu wundunjayero walji?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isaye tayiro: «Dalil nayi fattǝgǝwwayedǝ, kitawu bi kǝnduwo Alaye nonuwwi, mare? ");
INSERT INTO kby_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Karmolan cijaiya, larusa so, niya so cadiwawo, tayi alama malaiyawa samelan dasaanadǝ gairo waljai. ");
INSERT INTO kby_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Koro karmolan cidudǝ, Attaura Nawi Musayen kǝranuwwi wa? Kitawulan na kannu dawu coccoɍi cambiyedǝn Alaye Musaro: “Wuma Ala Ibrahimbe-a Isakuye-a Yakubaye-a wo,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ti Ala am sanunaye gǝni, am roaye, diye! Nayidǝ tai danuwe fattǝgǝwwa!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Malǝmba Attauraye falnja isǝna kambiwunjadǝa kǝrǝnji duwon, Isa tayiro jaawu ngǝla cinaro asuyenniya, tiro: «Wadawa samman finja kura wo?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isaye tiro: «Sammaro kura wodǝ tima: “Jama Israyilaye, fannowo, Ala Kǝmandedǝ ti tilonju lok. ");
INSERT INTO kby_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ala Kǝmanǝmba karwunǝm ngan, ronǝm ngan, hangalnǝm ngan, dunonǝm ngan raye!” ");
INSERT INTO kby_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Koro yindiyedǝ: “Kǝmaskinǝm yea kǝlanǝm gairo raye!” Wadawa aniro kura wo gade bawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Malǝm Attaurayedǝye tiro: «Sayinna, jirenǝm! Awo wullǝmmadǝ fagat: Aladǝ ti tilonju. Ti gǝnia, Ala gade bawo. ");
INSERT INTO kby_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tia karwunǝm ngan, hangalnǝm ngan, dunonǝm ngan raame kǝmaskinǝm yea kǝlanǝm gairo rawodǝ, layaso-a sadaaso-a sammaro kura wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isa malǝmdǝ hangal kǝjiaro juwapcǝgǝna kirunniya, tiro: «Ni-a nodo bargaa Alaye-a kattendo kuruwu gǝni!» yeno. Ngawo adǝyen wunduma cinju mudu kaje tiro koro gade cǝddǝnni. ");
INSERT INTO kby_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Fado Alayen Isa jamadǝa alamdu cǝdi duwon, tayiro: «Ndayilan malǝmba Attaurayedǝye Almasiwudǝ Tada Mai Daudaye canidǝ? ");
INSERT INTO kby_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mai Dauda kǝlanjuma Ruhu Alayen manaje: “Kǝmandeye Kǝmaniro: ‘Namme kǝmborammilan duwon, kǝladowanǝmba cidiya sinǝmbero yakkǝkko!’ cǝnna.” ");
INSERT INTO kby_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mai Dauda kǝlanjuma tia Kǝmalan bowojǝnadǝ, ndayilan gǝle Almasiwudǝ tadanjuro walji?» yeno. Jama kadadǝ karwu kǝjiaro tia kǝrǝnjai. ");
INSERT INTO kby_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Curo alamdunjuyen Isaye: «Malǝmba Attaurayero hangal gǝnanowo! Kalwu kuruwua dadadu caraana, koro kasuwulan lewa darajaa-a ");
INSERT INTO kby_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","dandallan bi masǝna kuralan na darajaa-a jaumaro caraana. ");
INSERT INTO kby_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kamu kwa faccǝgǝnaasoye kǝndanja sammaa jawui ye, halnja gǝraduro fuwu jamayen moduwa kuruwuro gǝrjai ye. Am aniye ajawunja leiran jauro kura!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Isa karǝn sanduwu sadaa fidaramben napkenniya, jamadǝ curo sanduwudǝyero wuɍi fijagai lawarji duwon, arsiyiwu kada isane wuɍi ngǝwu fijagai kiro. ");
INSERT INTO kby_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Koro kamu ngudi kwa faccǝgǝnaa laa ye ise gursu kime yindi fiyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Daji Isa fuwurawanjua bowoje: «Jiremaro nayiro wulnjagakki, kamu ngudi kwa faccǝgǝnaa adǝ sadaa am gadeye sammaa kojǝnaro fijǝgǝna. ");
INSERT INTO kby_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tayi samma arsiyinjalan ngojane fiyeyera, amma ti ngudi duwon kǝndanju sammaa fiyeyeno. Awo ronju ɍiwoye ngaa fiyeyeno,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Isa Fado Alayen luwo cǝdi duwon, fuwurawanjuye fal tiro: «Sayinna, akko rui kau ani-a soro ani-a jaumaro ajabba!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isaye tiro: «Soro mafǝndi mafǝndi ania rumma, gǝna? Kau ani sammaa wurjane fijai, har tiloma kǝla kamanjuyen gapciwaworo walji,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Isa kǝla Kau Jaitunnen na Fado Alaye turuidǝn napcǝna duwon, Biturus-a Yakuba-a Yahaya-a Andarawus-a runjan isane tiro: ");
INSERT INTO kby_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Andiro wulsagane, sawi awo ani wakkajai? Koro awo ani sammaye sanja cǝdiya, awi alama duwon ambo fǝlediyidǝ wo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isaye tayiro: «Hangal gǝnanowo, bare wunduma nayia njawatkǝnni! ");
INSERT INTO kby_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Am ngǝwu cunilan isane: “Wuma ti wo!” cane am kadaa cawatki. ");
INSERT INTO kby_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kǝriwu na karǝnso-a kuruwuso-alan nukcǝnaro fannuwiya, bare hangalndo cijǝnni! Sai awo ani burwon wakkajaiya duwon, amma sa njerorambe kua yaye cǝdǝnni. ");
INSERT INTO kby_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lardu-a lardu gade-a lawaladai, koro kǝrmai-a kǝrmai gade-a ye kattenjan kǝriwu gǝrjai. Cidi ye na gadegaden loloji, koro kǝna ye na naro ngayi. Awo ani samma badiduram boneye bas, alama kamu tia curo lejǝna gai. ");
INSERT INTO kby_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Hangal gǝnanowo! Fuwu majilissero njasade dandalsolan kowonjai, koro wu nangaro fuwu gomna so, mai soyen danuwi, tayiro shedaro walloworo. ");
INSERT INTO kby_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Adǝgaima sai kawuɍi kǝji Alayedǝ jama duniaye sammaro wuldiyiya duwon. ");
INSERT INTO kby_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nayia njadane shararo njasadiya, bare kǝla awo wulluwiyen karwungai diwwi. Awo wulduye Ruhu Alaye sadǝn nayiro njadidǝa mananowo, dalilnjudǝ nayi gǝni, tima manaji nangaro. ");
INSERT INTO kby_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yaana yanjugǝnaa sǝrǝcciye roro ceyesi, bawa ye tadanjua ngai, tadawa ye bawanja-a yanja-aro tuɍu cadde casakke tayia roro ceyesi. ");
INSERT INTO kby_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Cuni nangaro am samma nayia wanjai, amma kam mǝrje har sa njerorambero dǝganamadǝ njǝkkawo cuwandi. ");
INSERT INTO kby_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Sa duwon awo waada jauro batti masiwa kudoma na tiro jussǝnnilan daada ruwiya, (Kǝradumadǝ asujo!), daji am lardu Yahudiyayen dasaanadǝ cija kauro cagaso leja! ");
INSERT INTO kby_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kam kǝla soronjuyen dǝganadǝ bare jǝpce kare ngoduro curo sorodǝyero ngaanni! ");
INSERT INTO kby_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Koro kam kulolan dǝganadǝ ye bare kalwunju ngoduro waldǝnni! ");
INSERT INTO kby_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yim anin kamu curoa so, nganji cǝmbia sodǝ, kuttunja! ");
INSERT INTO kby_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bare awo adǝ sa kakuyen wakkajǝnniro Alaa korowo! ");
INSERT INTO kby_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dalilnjudǝ yim anin bone jauro kuttu mbeji, bone duwon sa Ala dunia alakcǝnayen tai kuro kudero ngaltema jiɍinju tuwandǝnni fuwu yen fagat tuwandiwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Koro ca Kǝmande bone adǝye kawunju fulujǝnnia, wunduma njǝkkawo cuwandiwawo. Amma am kǝrejǝnadǝ nangaro kawudǝa fulujǝna. ");
INSERT INTO kby_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sa adǝn kam laaye nayiro: “Akkonju Almasiwudǝ!” bi “Towonju ti!” cǝnia, bare tia yasarawwi! ");
INSERT INTO kby_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dalilnjudǝ almasiwuwa kattuwuyeso-a nawiya kattuwuyeso-a isane alama so, awo ajabba so cade, yoyenoa, har am kǝrejǝnadǝmaa jambajane cawatki. ");
INSERT INTO kby_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nayidǝ, hangal gǝnanowo! Kawu wakkajidǝro, awo sammaa nayiro wulnjagakkǝna. ");
INSERT INTO kby_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Amma ngawo bone yim aniyen kǝngal cǝlǝmbo walji, kumbal ye nurnju ciwawo, ");
INSERT INTO kby_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sillowuwaso ye samelan casuri, koro kǝnduwowa sameye ye jauro lolojai. ");
INSERT INTO kby_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Daji Tada Kambedǝ jauro kǝnduwoa-a darajaa-a curo fofouyen isi carui. ");
INSERT INTO kby_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Adǝgaima malaiyawanjua cunode talgǝmo duniaye dewu samman ci dajiram duniayen tai ci dajiram sameyero yade amnju kǝrejǝnadǝa capcai. ");
INSERT INTO kby_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ya tarmuyen misal adǝa asunowo! Sa fǝktu badije kalu ɍijiya, nangǝɍi karǝnjǝnaro nonuwwa. ");
INSERT INTO kby_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngaima awo ani wakkajai ruwiya, ti cinnalan del karǝnjǝnaro nonowo! ");
INSERT INTO kby_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jiremaro nayiro wulnjagakki, am jaman adǝye sanuiwawo, sai awo ani samma wakkajaiya duwon. ");
INSERT INTO kby_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Same-a cidi-a baworo waljai, amma manani tǝmmaro baworo waljiwawo. ");
INSERT INTO kby_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Amma yim bi sa duwon awo ani wakkajaidǝa wunduma nojǝnni. Bawadǝro kajia, malaiyawa samelan dasaana ye nojanni, Tadadǝ ye nojǝnni. ");
INSERT INTO kby_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Hangal gǝnanowo, faadaro dǝgaiwo, sanju nonuwwi nangaro. ");
INSERT INTO kby_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Alamanju kam bǝlawuro cǝdi gai. Kǝnduwo fannjuro kistuwuyedǝa wolodiyanjuro koljiye wundunja yayero kidanju ce cinna guredumaro faadaro dǝga cǝne sapkada. ");
INSERT INTO kby_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Adǝ nangaro faadaro dǝgaiwo, dalilnjudǝ sa kǝma fadoye isidǝa nonuwwi nangaro, kajiri, bi bune, bi fajar, bi suwa, ");
INSERT INTO kby_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","bare yekkinndo bawo kǝnǝm diwi nayia nanjaganni! ");
INSERT INTO kby_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Awo nayiro wulnjagakkǝnadǝa wundusoro wulgǝkki, faadaro dǝgaiwo!» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sala Laya Njǝkkayirambe-a sala Burodi Yis Bawoaye-aro kawu yindi gapco. Koro wurawa ɍimannaye-a malǝmba Attauraye-a jawal Isaa nangalan tame roro njejoye majai. ");
INSERT INTO kby_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tayiye: «Sai sala kojiya duwon, bare jama hangalsango casangǝnni!» yera. ");
INSERT INTO kby_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isa bǝla Baitaniyelan fado Siman dǝɍimayen masǝna cǝdi duwon, kamu laa sǝndal curonjun kawudi mǝndemi ye, jauro tamanna ye, cunju nardi ngoje ise sǝndaldǝa dauyen namje kawudidǝa kǝla Isayero fiyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Am laa awo adǝa kutturo carune kattenjan: «Awiro kawudidǝa basarjidǝ? ");
INSERT INTO kby_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ca kawudi adǝa dinariyus yer yakku kojǝnaro calade wuɍidǝa talaawaro cadǝna!» cane tiro saɍiwu gǝnaduwu badiyera. ");
INSERT INTO kby_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amma Isaye tayiro: «Tia kollowo! Awiro tia suwolluwi? Wuro jauro ser sǝddǝna. ");
INSERT INTO kby_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Talaawasodǝ sawisoro curondon mbeji, koro sawi yaye, raawwaa, ranguwe tayia banagǝwi, amma wudǝ sawisoro gǝni curondon dǝgakki. ");
INSERT INTO kby_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kamu adǝ awo rakcǝnadǝa cǝdo. Kawudi adǝa tiyiniro fijiye sittǝraniro wua dabbarseyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jiremaro nayiro wulnjagakki, ndaran yaye curo dunia ngayen kawuɍi kǝji Alayedǝa wuljai nguson, kamu adǝa takturo awo sǝddǝnadǝ yea wuljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Daji Yahusa Iskariyot mewun yindindǝye falnja Isaa mukko wurawa ɍimannayero sǝrǝttuwuro nanjaro leyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Adǝa fangeranniya, karwunja kǝjije tiro wuɍi cadi cane wadu ngoyera. Yahusadǝ dama Isaa tayiro sǝrǝttuwuye mada badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yim burwoye sala Burodi Yis Bawoayen, yim duwon ngǝlaro Laya Njǝkkayirambedǝa duwajaidǝ kidǝnniya, fuwurawanjuye tiro: «Ndaran leniye masǝna layayedǝa niro dabbarnjǝgǝiye bumi?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Daji Isa fuwurawanjuye yindi cunode tayiro: «Bǝrnidǝro ngawowo, kam laa bule ingia ngojǝna-a kǝla kǝlluwi. Tia gaiwo, ");
INSERT INTO kby_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","fado duwon ngaanaye kǝmadǝro wulgǝnowo: “Sayinnaye kusottoram na fuwurawanju-a rokko masǝna layayedǝa cadidǝ ndaran?” ");
INSERT INTO kby_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nayiro soro sameye ngim kura curon karea dabbargada fǝlenjagai. Nadǝn masǝnadǝa andiro dabbarsaganowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Daji fuwurawadǝ lejane bǝrnidǝro ngasaye jiɍi Isa tayiro wuljǝgǝnadǝ gai awiso kewando. Adǝgaima masǝna layayedǝa dabbaryera. ");
INSERT INTO kby_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kǝngal kikkurǝnniya, Isa mewun yindindǝ-a rokko kadira. ");
INSERT INTO kby_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Napcana masǝna cadi duwon, Isaye: «Jiremaro nayiro wulnjagakki, kamndo fal wua mukko kǝladowayero sǝrǝnsiyi, rokkomaro masǝna diye,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Karwunja jauro kuttaje fal fallen wundu yaye: «Wuma wa?» cǝne tia koro badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Isaye tayiro: «Curo mewun yindindǝyen kǝrga, kam duwon wu-a buwururo mukko yakkiyenadǝ. ");
INSERT INTO kby_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tada Kambedǝ saptidǝma, jiɍi kǝlanjun kitawulan ruwuwadadǝ gai, amma kam duwon Tada Kambedǝa kǝladowanjuro sǝrǝcciyidǝ, kuttunju! Ca kam adǝ tambǝnnima tiro ngalwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Masǝna cadi duwon, Isa burodi ngoje Alaro ardiyenniya, fǝsakce tayiro ce: «Ngonowo, adǝ tiyini,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Koro kǝnjaram ngoje Alaro ardiyenniya, tayiro ce tilan tayi samma kesano. ");
INSERT INTO kby_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Isaye tayiro: «Adǝma buni aman ndǝptaye duwon am kada nangaro fidǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jiremaro nayiro wulnjagakki, na adǝn fuwun gadero ingi inabbe yakkiwawo, har yim nodo bargaa Alayen bǝɍinno yakkiro,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Daji aiya Alaa njungoroye yeyeranniya, caluwe Kau Jaitunnero leyera. ");
INSERT INTO kby_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isaye fuwurawanjuro: «Nayi samma ngaworo walduwi, akko awo kitawulan ruwuwadadǝ: “Sǝnidǝa bangǝkkiya, dimiyadǝ tatardai.” ");
INSERT INTO kby_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amma karmolan cikkiya, nayia burwonjakke cidi Galileyero lekki,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Biturusse tiro: «Tayi samma ngaworo waldai yaye, wudǝ ngaworo waldǝkkiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isaye: «Jiremaro niro wulnjǝgǝkki, ku bune adǝman kawu gudowom yindiro kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma Biturusse kowo dunoaro sapce tiro: «Dole ni-a rokko nuiyero walyeno yaye, tǝmmaro nia angǝrnjǝkkiwawo!» yeno. Tayi samma ye ngai wulyera. ");
INSERT INTO kby_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na tiro Gessemani canidǝro kadiranniya, Isaye fuwurawanjuro: «Na adǝn nammowo duwon, moduwa dikke,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Daji Isa Biturus-a Yakuba-a Yahaya-aa ngoje rokko lejane karwunju kuttaje ronju jauro bannadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tayiro: «Karwuni jauro kuttajǝna, har nukki gai. Na adǝn danowo, faadaro dǝgaiwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gana laa kuruwuje cidiro tǝmdiye, yojia, sa boneyedǝ tia cǝdanniro moduwa dio badiyeno. ");
INSERT INTO kby_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tiye: «Abba, Bawa, awiso niro yoji. Kǝnjaram boneye adǝa wulan ngone! Adǝ yaye awo wu raakkǝna gǝni, awo ni raammadǝma!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na fuwurawanjuyero walladanniya, kǝnǝm cadi nayeyeno. Biturusso: «Siman, kǝnǝm wa dimi? Assha! Sa fallo rangǝme faadaro dǝgambawo wa? ");
INSERT INTO kby_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bare jaraptuwwiro faadaro dǝgaiwo, moduwa dewo! Ruhu kambedǝ cǝraana, amma tiyinjudǝ duno kǝskea!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Koro walde leje mana cayedǝlan moduwa kido. ");
INSERT INTO kby_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nanjaro walladanniya, caye gai kǝnǝm cadi nayeyeno, simnja nga kurwowujǝna nangaro. Awo tiro wulduwuyema nojanni. ");
INSERT INTO kby_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yakkuyero walladanniya, tayiro: «Kuamison kǝnǝmbo bowadando tussuwi wa? Cerǝna! Sadǝ cǝdǝna, Tada Kambedǝa mukko biwumasoyero sǝrǝccaana. ");
INSERT INTO kby_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cinowo, leniyo! Akkonju kam wua sǝrǝnsiyimadǝ del karǝnjǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sadǝman Isa mana cǝdi ngai duwon, Yahusa mewun yindindǝye falnja kadio. Jama kada ye na wurawa ɍimannaye-a malǝmba Attauraye-a amwurawa jamaye-ayen kashagar so, ka so mukkonna ti-a rokko kadira. ");
INSERT INTO kby_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Caman ti sǝrǝttuwumanjudǝ tayiro bǝlaanan isanojiye: «Kam tiro lewa kǝrawoye yiddǝkkidǝ, tima! Tia taiwo, fǝrǝstiwaworo yadowo!» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Daji Yahusa kadinniyama, na Isayero ise: «Sayinna!» cǝne tiro lewa kǝrawoye kiddo. ");
INSERT INTO kby_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Daji Isaa mukkon dap keda. ");
INSERT INTO kby_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Am nanjun dajanadǝye falnja kashagar ficce wolodi ɍiman kurayea bakce sǝmonju tǝn kamgeno. ");
INSERT INTO kby_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isaye tayiro: «A! Nayi kashagar so, ka so mukkonna wua gǝndema gai taro wa isuwidǝ? ");
INSERT INTO kby_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yim nguson nandon Fado Alayen dǝgaiye jamaa alammǝkki duwon, wua sǝdawwi. Amma awo kitawulan ruwuwadadǝ wakkajo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Daji fuwurawanju samma tia koljane keyaso. ");
INSERT INTO kby_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jairo laa mayafi gǝnia, awima tiyinjun bawo Isaa jǝgana mbeji. Amdǝ tia kedanniya, ");
INSERT INTO kby_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mayafidǝa kolje de sul kiyaso. ");
INSERT INTO kby_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Daji Isaa ngojane na ɍiman kurayero kesado. Nadǝn wurawa ɍimannaye-a amwurawa jamaye-a malǝmba Attauraye-a samma ye capkadara. ");
INSERT INTO kby_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Biturus ye katte kaskadaaro har balballa fado ɍiman kurayedǝro tia jǝgane kǝrgaanniya, kannu gǝttoro dawu gureduwu Fado Alayen napkeno. ");
INSERT INTO kby_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wurawa ɍimannaye-a majiliswu samma-a sheda Isaa roro njejoro mayera yaye, cawandǝnni. ");
INSERT INTO kby_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Am kada kǝlanjun sheda bowuye cadǝna, amma cinja tilojǝnni. ");
INSERT INTO kby_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Daji am laa cijane sheda bowuye cade: ");
INSERT INTO kby_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Tiye: “Wudǝ Fado Alaye mukko kamben tǝdandǝna adǝa wurnǝkke curo kawu yakkuyen mukko kamben gǝni gade tandǝkki,” ngai cǝne fangeiye,» yera. ");
INSERT INTO kby_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amma kǝla adǝyeman cinja tilojǝnni. ");
INSERT INTO kby_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Daji ɍiman kuradǝ cije dawunjan daje Isaro: «Jaawunǝm bawo wa? Awi gǝle am ani kǝlanǝmnin shedajaidǝ?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amma Isa cinju kaje jaawu cinni. Koro ɍiman kuradǝ walde tiro: «Nima wa Almasiwu Tada Ti Bargaayedǝ wo?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isaye: «Wuma! Koro Tada Kambedǝ mukko kǝmboram Mai Kǝnduwomayen napkada ye, curo fofou sameyen kǝnde cǝdi ye ruwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Daji ɍiman kuradǝ kalwunju karje: «A! Sheda jiɍi fi gǝle gade maniye? ");
INSERT INTO kby_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Alaa gaskadunjudǝa fannuwwa. Awi gǝle tǝmanuw?» cǝne tayia kiworǝnniya, tayi samma tiro shara kamjagane ronju tuluwoma jusso yera. ");
INSERT INTO kby_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Daji laanja tiro lallaɍi tǝwatǝwajagane simnju jakcane tia babaktu badiyera. Tiro: «Nawinawi de!» cani. Adǝgaima gureduwudǝ ye tia cadane maɍin babakkera. ");
INSERT INTO kby_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Biturus balballa fadoyedǝn duwon, kir ɍiman kuraye laa nadǝro kadio. ");
INSERT INTO kby_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Biturus kannu jǝgǝtti kirunniya, tia ngǝlaro ninije: «Ni ye Isa kam Najaratte-a rokko kǝrgaw!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amma Biturus angǝrje: «Awo wullǝmidǝmaa nokkǝni, asukkǝni!» yeno. Daji cinna ngaworambo culuwe gudowom kokkore kekko. ");
INSERT INTO kby_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kirdǝ walde tia cure am nadǝn dasaanadǝro: «Kam adǝ ye falnja!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Koro Biturus walde angǝryeno. Gana sam kidǝnniya, am nadǝn dasaanadǝye Biturusso: «Fagatto ni ye kamnja fal, ni kam cidi Galileye nangaro!» yera. ");
INSERT INTO kby_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Amma Biturus kǝlanju baskuje kansi juwe: «Kam kǝlanjun mananuwi adǝa nokkǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sadǝman gudowom yindiyero kokkore kekko. Daji Biturus awo Isa tiro wuljǝgǝnadǝa takkeno. Isaye: «Kawu gudowom yindiro kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» cǝnna. Takkenniya, tai daje so ngoyeno. ");
INSERT INTO kby_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dunia wayenniyama, wurawa ɍimannaye-a amwurawa jamaye-a malǝmba Attauraye-a majiliswu samma-a ci tiloaro sawari kedo. Daji Isaa cekkere caade mukko Gomna Bilatussero kesakko. ");
INSERT INTO kby_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatusse Isaro: «Nima wa Mai Yaudiyayedǝ wo?» cǝne tia kiworo. Isaye: «Nima wullǝm, wuma!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wurawa ɍimannayedǝ awo kadan Isaa burwuyera. ");
INSERT INTO kby_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Daji Bilatus walde tiro: «Kalakkǝmbawo wa? Awo kadan burwunjanadǝa fannǝmmi wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma Isa kua yaye tiro kalakcǝgǝnni, har Bilatus ajapkeno. ");
INSERT INTO kby_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Caman kǝrwu nguson sala adǝlan gomnadǝ kosoma fal jama caworǝnadǝa tayiro salamjiyi. ");
INSERT INTO kby_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sa adǝn kam laa amanju-a tuɍu cade kam ceyese kosolan rojana mbeji, cunju Barabbas. ");
INSERT INTO kby_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Daji jama na gomnayedǝro isane awo caman tayiro caddidǝa njǝddoro tia koro badiyera. ");
INSERT INTO kby_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatusse tayiro: «Mai Yaudiyayedǝa wa nayiro salamnjagakkiya, rawuw?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Awoa nandǝɍinja nangaro wurawa ɍimannayedǝ Isaa mukkonjuro sǝrǝtkeyeraro nojǝna. ");
INSERT INTO kby_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amma wurawa ɍimannayedǝ jamadǝa casakke cuju Isayero Barabbassa tayiro salamjuwo yera. ");
INSERT INTO kby_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatusse walde tayiro: «Awi gǝle kam tia Mai Yaudiyayelan bowonuwidǝro yiddǝkki?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kowo sapcane: «Kǝskaro tia jagǝne no!» yera. ");
INSERT INTO kby_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatusse: «Awiro? Ayau awiye cǝdo?» yenniya, caye baworo kowo sapcane: «Kǝskaro tia jagǝne no!» yera. ");
INSERT INTO kby_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Daji Bilatus awo ronjaye cǝdiya cǝraana nangaro, tayiro Barabbassa salamgeyeno. Amma cakke Isaa kirwolan jajaryeranniya, tia kǝskaro jajaaro mukkonjaro kekko. ");
INSERT INTO kby_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Daji sojiyadǝ Isaa curo balballa gomnariyero caade kǝwunja sojiyaye sammaa bowojane capkera. ");
INSERT INTO kby_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kalwu kime tiro lujagane aɍiawu kaɍiyiye kǝlejane kǝlanjuro gǝnayeyera. ");
INSERT INTO kby_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Daji tiro: «Ala ngǝwuro, Mai Yaudiyaye!» wulduwu badiyera. ");
INSERT INTO kby_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kalan kǝlanju babakcane lallaɍi tiro tǝwajagane fuwunjun tungurumjane tiro daraja kedo. ");
INSERT INTO kby_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tiro rudu gǝnajagane kerǝnniya, kalwu kimedǝa ɍinjane kajǝmunju cayedǝa lujagane tia kǝskaro jaduwuro kesado. ");
INSERT INTO kby_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kam laa bǝla Kuraneye mbeji, cunju Siman, tidǝ Aleksanda-a Rufus-aye bawanja. Karaan cijǝna kodu cǝdi duwon, sojiyadǝ dunodunon tia casakke kǝska Isayedǝa ngoje leyera. ");
INSERT INTO kby_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Isaa na tiro Golgota canidǝro kesado, Golgotaye maananjudǝ Na Buwo Kǝlaye. ");
INSERT INTO kby_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Isaro diben curonjun awo laa mir cani diyadaa caro kedo, amma kǝnjaro wayeno. ");
INSERT INTO kby_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Daji tia kǝskaro jajagane kajǝmunju ngojane wundunja yaye nuwanju cuwandoro walawala cade kattenjan dagaryera. ");
INSERT INTO kby_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sa Isaa jajaanadǝ, sa lǝgar suwaye. ");
INSERT INTO kby_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Allo ayaunju kǝlan ruwuwadadǝ: MAI YAUDIYAYE. ");
INSERT INTO kby_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Gǝndewu yindi yea ti-a rokko jayeyera, faldǝ kǝmboramnjulan, faldǝ ye wailanjulan. ");
INSERT INTO kby_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Adǝgaima awo kitawulan ruwuwadadǝ wakkayeno. Tiye: «Amso tia biwumaro ngoyera,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Am kamjana kojaisodǝ tiro rudu gǝnajagane kǝlanja kalakalakcane tiro: «Ap! Ni Fado Alayea wurnǝme curo kawu yakkuyen tandǝmidǝ, ");
INSERT INTO kby_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nda kǝskadǝn jǝmme kǝlanǝm moye!» cani. ");
INSERT INTO kby_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wurawa ɍimannaye ye malǝmba Attauraye-a rokko adǝgai tiro rudu gǝnajagane amanjaro: «Am gadea cǝkkaana, amma rakce kǝlanju cǝmoyiwawo! ");
INSERT INTO kby_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Almasiwu Mai Israyilawuyedǝ kǝskadǝn kǝrma jǝpco, ruiyo tia kasaddiyo!» cani. Gǝndewu yindi ti-a rokko jajaanadǝ ye Isaa rarayera. ");
INSERT INTO kby_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kausu kǝla dawu duwon, dunia nga tǝmje cǝlǝmbo walje, har sa yakku kajiriyero kiado. ");
INSERT INTO kby_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sa yakku kajiriyedǝ Isa kowo dunoaro sapce: «Eloi, Eloi, lama sabaktani?» yeno, maananjudǝ «Alani, Alani, awiro wua kolsem?» ");
INSERT INTO kby_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Am nadǝn dajanadǝ adǝa fangeranniya, laanjaye: «Fannowo, Nawi Iliyaa bowoji!» yera. ");
INSERT INTO kby_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Daji falnja cǝgase leje soso ngoje diben comcombo lǝpciye cuttuluwe karo lassiye Isaro sayeyeno. Tiye: «Nda kollowo, Nawi Iliya ise tia kǝskadǝn cǝsayia, ruiyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Daji Isa kowo dunoaro sapce ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sa adǝn juwa curo Fado Alayen dǝganadǝ samen tamiya kǝla cidiyannaro kudero farak yindiro kargadan. ");
INSERT INTO kby_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kajalla sojiyaye fuwu Isayen daadadǝ jiɍi Isa bawojǝnadǝa kirunniya, tiye: «Jiremaro kam adǝ Tada Alayedǝma!» yeno. ");
INSERT INTO kby_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kamuwa laa ye kuruwunin awo ania lawarjai mbeji. Curonjan Meram Magdala-a Meram Yakuba Gana-a Josi-aye yanja-a Salomi-a. ");
INSERT INTO kby_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sa Isa cidi Galileyedǝn tia jaane banajagai. Koro kamuwa gade kada Isaa jaane Jerujalembo isana ye nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yim adǝ yim dabbarduye. Wajiya yim tustuye nangaro, dunia kajiriyenniya, ");
INSERT INTO kby_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Isuwu kam Arimatiyaye, ti curo majiliswudǝyen jauro kam kura ye, nodo bargaa Alayedǝye kǝndenju gureji ye, na Gomna Bilatussero ridu bawoaro leje kamin Isayedǝa tiro cadoro kiworo. ");
INSERT INTO kby_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus Isa nagatto bawojǝnadǝa ajapce kajalla sojiyayedǝa bowoje Isa tussǝna wa bawojǝnadǝro kiworo. ");
INSERT INTO kby_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kajalladǝyen Isa bawojǝnaro asuyenniya, kaminnjudǝa Isuwuro kaino. ");
INSERT INTO kby_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Daji Isuwu leje lowowon batta linne ciwe kamindǝa kǝskadǝlan cǝsaye battadǝn kǝkǝrje kauri curo kauyen lajana laaro cakke sǝnaje ci kauridǝyero kau kura tǝmbalyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meram Magdala-a Meram Josiye yanju-a ye lawarjane na Isaa sǝnajanadǝa kero. ");
INSERT INTO kby_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yim tustuye koyenniya, Meram Magdala-a Meram ya Yakubaye-a Salomi-a lejane kawudi kamin Isayedǝro fidaaro kesiwo. ");
INSERT INTO kby_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mawuye yim burwoyea suwa lǝp kǝngal kiluwunniya, kauridǝro leyera. ");
INSERT INTO kby_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kattenjan: «Wundu gǝle ci kauridǝyen kau kuradǝa andiro tǝmbalji?» cani. ");
INSERT INTO kby_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amma kǝla sapkeranniya, akko kau mafǝndidǝ tǝmballada kero. ");
INSERT INTO kby_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kauridǝro kasargaanniya, jairo laa kalwu bulla kǝmboramnin napkada kero. Tia kerunniya, karwunja tai daje kamgada. ");
INSERT INTO kby_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jairodǝye tayiro: «Bare karwundo kamdǝnni! Isa kam Najaratte ti kam kǝskaro jajaanadǝa manuwi. Ti na adǝn bawo, cijǝna! Akko na tia sǝnajanadǝa ruiwo! ");
INSERT INTO kby_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amma lenowo fuwurawanju-a Biturus-aro: “Ti nayia burwonjane cidi Galileyero leji. Nayiro wulnjaanadǝ gai, nadǝn tia ruwi,” wulgǝnowo,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Daji karwunja kamdǝna kar kar lolojaiaro kauridǝn caluwe cagase leyera. Jauro rijana nangaro, wundumaro awima wuljaganni. ");
INSERT INTO kby_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mawuye yim burwoyea suwa lǝp karmolan ciyenniya, Isa burwon Meram Magdala kamu tilan sedan tulur dujǝnadǝro fǝleyaada. ");
INSERT INTO kby_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meram ye leje am calan Isa-a rokko dasaanadǝ karwukuttaro cesiridǝa najiye tayiro wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amma Isa roaro waljǝna ye, Meram tia curuna yero fangeranniya, njasarairo wayera. ");
INSERT INTO kby_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ngawo adǝyen jiɍi gaden Isa amnja yindi karaaro ledu cadidǝro fǝleyaada. ");
INSERT INTO kby_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tayi yindidǝ ye waldane amnja gapcanadǝro wulyeyera, amma tayi yea njasarairo wayera. ");
INSERT INTO kby_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Koro fuwurawanju mewun tilondǝ masǝna cadi duwon, Isa tayi yero fǝlediye kǝla njasarainambunja-a kǝlakibbunja-ayen tayiro kikkado, dalilnjudǝ am ngawo cijǝnayen tia carunadǝa njasarairo wayera. ");
INSERT INTO kby_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Daji Isaye tayiro: «Dunia ngaro lenowo, kawuɍi kǝji Alayedǝa adamgǝna sammaro wulgǝnowo! ");
INSERT INTO kby_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kam casarane tiro kasala caddǝnamadǝ njǝkkawo cuwandi, amma kam njasarairo wajǝnamadǝ wowom Alaye tia cǝdai. ");
INSERT INTO kby_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Am casaranamadǝ akko alama rakcane cadidǝ: Cunilan sedanna dujai, tǝlamba gade bǝɍin manajai, ");
INSERT INTO kby_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kadi mukkon ngojai. Sum casaia, tayia lorujiwawo. Mukkonja am dondiro gǝnajagaiya, nanlewa cawandi,» yeno. ");
INSERT INTO kby_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kǝma Isa mana adǝa tayiro cǝddǝnaye ngawon, tia samero caade kǝmboram Alayen napkeno. ");
INSERT INTO kby_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tayi ye lejane ndara yayero kawuɍi kǝji Alayedǝa wuljagai adǝgai duwon, Kǝmadǝ tayia banajiye alama kadan manadǝa jirero tabbacciyi kǝrga.");
INSERT INTO kby_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiyofalas, Ala ngǝwuro! Amnde ngǝwu gǝrgam kǝla lamarra dawunden wakkajana aniyen ruwuduro ngǝssana, ");
INSERT INTO kby_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","jiɍi am duwon tǝn badiduramnin awo ania simnjan caruna-a mana Alaye sattuwumasoro waljana-adǝ andiro isanosaanadǝ gai. ");
INSERT INTO kby_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Barganǝmmin, tǝn badiduramnjan awo ani sammaa gakke hangallayen kokorǝkke fakkǝna nangaro, wu ye tayia sawinǝkke niro kitawulan ruwunjǝgǝkki yekko. ");
INSERT INTO kby_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngainin awowa niro njasakkǝrana sammaa tabbatto nonǝmi. ");
INSERT INTO kby_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jaman Mai Hirudus lardu Yahudiyaye cunodidǝn, ɍiman laa mbeji kǝwu ɍimanna Abiyayen kǝrga, cunju Jakariya. Kamunju ye kaduwu Nawi Harunaye, cunju Alisabatu. ");
INSERT INTO kby_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tayi yindiso na Alayen jirewu, wada Kǝmandeye sammaa taldu baworo jaana. ");
INSERT INTO kby_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tada cawandǝnni, Alisabatu rakce cambiwawo nangaro, koro tayi yindi kawu ngǝwu jawuna. ");
INSERT INTO kby_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kǝwu Abiyaye sanja dirije kidǝnniya, Jakariya ye kidanju nanɍimanne fuwu Alayen badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kǝla ada ɍimannayedǝn kamnja fal Fado Alaye na darajaaro ngawo kaaji cakkoro walawala cade Jakariyaa kǝreyera. ");
INSERT INTO kby_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sa kaaji njakkoyen jama samma balballadǝn captana moduwa cadi duwon, ");
INSERT INTO kby_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","malaiya Kǝmandeye laa kǝmboram kaaji njakkoramben daada tiro fǝleyaada. ");
INSERT INTO kby_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jakariya tia kirunniya, hangalnju jade karwunju pǝt kamgada. ");
INSERT INTO kby_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amma malaiyadǝye tiro: «Jakariya, bare rinǝmmi, Ala moduwanǝm cǝmowona. Kamunǝm Alisabatu niro tada kongwa njǝkkambi, tiro cu Yahaya yakke. ");
INSERT INTO kby_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tiramnin jauro karwunǝm kǝjiji, koro tambonjudǝye am kada ye kǝji fanjai. ");
INSERT INTO kby_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ti na Kǝmandeyen kam darajaaro walji. Bare diben bi mbal fimaa canni, kawu tambimaro Ruhu Alaye tilan dǝgai. ");
INSERT INTO kby_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaduwu Israyilaye kadaa jawal Ala Kǝmanjayero kalakciyi. ");
INSERT INTO kby_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tidǝ ro-a kǝnduwo-a Nawi Iliyayelan Kǝmadǝa burwoje ise bawaso-a tadawanjaso-a soloji, am ansiya Alaye ye hangal jirewuyero kalakciyi. Adǝgaima Kǝmadǝro jamaa dabbarjiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amma Jakariyaye malaiyadǝro: «Awiawin mana adǝa jirero nokki? Akko wu kiarinǝkkǝna, kamuni ye kǝmurjojǝnadǝ,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Daji malaiyadǝye tiro: «Wuma Jibǝrilla fuwu Alayen dadumadǝ wo. Tima wua nanǝmbo lawar kǝji adǝa njukkudǝkkoro sunodo. ");
INSERT INTO kby_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amma manani yasarammidǝ, har awo ani wakkajaidǝro, mǝdǝk nammǝme mana dimbaworo wallǝmi. Awo wulnjǝgǝkkǝna adǝ sanju cǝdiya, tabbatto wakkaji.» ");
INSERT INTO kby_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jama Jakariyaa gurejai ngai duwon, na darajaadǝn jauro tussǝnadǝa ajapkera. ");
INSERT INTO kby_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kiluwunniya, mana tayiro njǝddo tiro tiyero. Jamadǝ awo ajabba laa na darajaalan tiro fǝledǝgǝnaro asuyera. Muwamuwan gǝnia, tayiro rakce manajiyiwawo, mǝdǝk napkeno. ");
INSERT INTO kby_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kida nanɍimanne sanju kerǝnniya, fadoro wallada. ");
INSERT INTO kby_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ngawo kawu aniyen kamunju Alisabatu curo ngoyeno. Kǝndawu uwuro kuwulero kǝlanju cakke karwunjun: ");
INSERT INTO kby_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Akko ser Kǝmande sǝddǝna. Kawu anin kanjimaɍinju wuro fǝlesiye dawu amben nanguni cuttuluwuna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Alisabatu curo ngojǝnaye kǝndawu arakkua Ala malaiya Jibǝrillaa bǝla Najarat cani cidi Galileyedǝro cunode ");
INSERT INTO kby_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","na fero kǝlayakku laa tǝmajinju kaduwu Mai Daudaye laa cunju Isuwuyero leyeno. Ferodǝ cunju Meram. ");
INSERT INTO kby_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaiyadǝ na Merambero ise tiro: «Wuse, ni Kǝmande jauro barga dǝmnjǝgǝnamadǝ! Kǝmadǝ ni-a rokko,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Merambe hangalnju kǝla lewa adǝyen jauro cije awi maananjuro kǝlanju cuwori duwon, ");
INSERT INTO kby_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","malaiyadǝye tiro: «Meram, bare rinǝmmi, Ala niro barga dǝmnjǝgǝna. ");
INSERT INTO kby_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Akko curo ngonǝme tada kongwa yambǝmi, tiro cu Isa yakke. ");
INSERT INTO kby_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ti kam darajaaro walje tia Tada Mai Samemayelan bowojai. Ala Kǝmande tiro kǝrmai kaarinju Mai Daudayedǝa ci. ");
INSERT INTO kby_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Adǝgaima jama Yakubayea har abadaro cunodi, kǝrmainju ye tǝmmaro ceriwawo.» ");
INSERT INTO kby_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Daji Merambe malaiyadǝro: «Awiawin attǝ yoji, wu ngaltema kwa nokkǝnidǝ?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaiyadǝye tiro: «Ruhu Alaye kǝlanǝmbo jǝpciye kǝnduwo Mai Samemaye nia fofou gairo jannji. Adǝ nangaro tada tayir nilan tambidǝa Tada Alayelan bowojai. ");
INSERT INTO kby_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Akko kǝraminǝm Alisabatu ye nankǝmurjonjun curo ngojǝna. Kamu rakce cambiwawo canidǝ, kǝrma curonju kǝndawu arakkuyea. ");
INSERT INTO kby_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","None, awima Alaro tiyeri bawo!» ");
INSERT INTO kby_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Merambe: «Wu kanji Kǝmandeye. Kǝla mananǝmben wakkajo!» yeno. Daji malaiyadǝ tia kolje sapkadan. ");
INSERT INTO kby_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yim anin Meram cije duwaduwan bǝla cidi Yahudaye curo kauwa kura kurayen dǝgana laaro leje ");
INSERT INTO kby_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","fado Jakariyayero ngaye Alisabaturo salamgeyeno. ");
INSERT INTO kby_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Alisabatu salamduwunjudǝa fangenniya, tada curonjuyedǝ moji kido. Ruhu Alaye Alisabaturo jǝpciye ");
INSERT INTO kby_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kowo dunoaro sapce: «Curo kamuwayen nima bargaa wo, tada curonǝmbedǝ ye bargaa! ");
INSERT INTO kby_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Koro awiro gǝle Kǝmande wuro ser sǝdde, har ya Kǝmaniye naniro isidǝ? ");
INSERT INTO kby_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Akko salamduwunǝmdǝa fangekkǝniya, tada curoniyedǝ karwukǝjiro moji kido. ");
INSERT INTO kby_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Awo Kǝmande niro wulnjǝgǝnadǝ wakkajiro mǝrsanǝmmadǝ, barganǝm!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Daji Merambe: «Karwuni Kǝmandea jajakci, ");
INSERT INTO kby_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","roni Ala Njǝkkayimanilan kǝji fanji. ");
INSERT INTO kby_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wu kanjinjudǝa curo nantalaaniyensurune ngurnosǝna. Na adǝn fuwun am jaman sammaye wua bargaalan bowosai, ");
INSERT INTO kby_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mai Kǝnduwoma ser kura wuro sǝddǝna nangaro. Cunju darajaa. ");
INSERT INTO kby_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","«Jaman kureyen tai jaman ngusoro kanjimaɍinju am tia rijanaro fǝlejiyi. ");
INSERT INTO kby_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kǝmande mukkonjun kǝrmai fǝleje, am karwunjan rokuraa tarjǝna. ");
INSERT INTO kby_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Maiyaso kǝrmailan cǝsaye sǝlje, talaawaso yea darajaaro cǝdǝna. ");
INSERT INTO kby_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Am kǝnanjaasoa awo ngǝlan ambaje, gaɍiwuwaso yea mukko dea dujǝna. ");
INSERT INTO kby_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kǝmande kanjimaɍinju fǝledu koljǝnni, kanjinju Israyilaa banajǝgǝna, ");
INSERT INTO kby_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","amwurawande Nawi Ibrahim-a kaduwunju-aro har abadaro wuljǝgǝnadǝ gai.» ");
INSERT INTO kby_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meram fado Alisabatuyen kǝndawu yakku gairo napkenniya, fannjuro wallada. ");
INSERT INTO kby_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Alisabatu sanju njamboye kidǝnniya, tada kongwa kembo. ");
INSERT INTO kby_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Am fannjuye-a kǝmaskiyanju-a ser kura Kǝmande tiro cǝddǝnadǝa fanjane karwukǝjinja tiro fǝleyeyera. ");
INSERT INTO kby_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kawu wuskua jama kajanjuro kadiranniya, tiro cu bawanju Jakariyaye njakko mayera, ");
INSERT INTO kby_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","amma yanjuye: «A'a, tia Yahayalan bowojai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tayiye tiro: «Wunduma curo kǝramiyanǝmben cu adǝa bawo!» yera. ");
INSERT INTO kby_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Daji muwamuwan bawanjuro cu fi tadadǝro cakkiya cǝraworo keworo. ");
INSERT INTO kby_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakariya allo cuwore tilan «Cunju Yahaya» ruwuyeno, koro tayi samma ajapkera. ");
INSERT INTO kby_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sadǝman Jakariya ci ye cuwande, tǝlamnju ye wuide, Alaa cungoriaro mana badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Daji kǝmaskiyanja samma riyera, koro lawar adǝ cidinja Yahudiyaye kauwa kura kuraa sammaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jama adǝa fanjana samma karwunjan rojana, amanjaro: «Tadaana adǝ, awiro gǝle walji?» cani. Fagatto mukko Kǝmandeyedǝ tilan kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Daji Ruhu Alaye Jakariyaro jǝpciye nawinawi cǝde: ");
INSERT INTO kby_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Ala Kǝma Israyilawuyedǝa yungoriyo! Nguwu jamanjuyero ngaye tayia merujǝna, ");
INSERT INTO kby_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","andiro curo kaduwu kanjinju Mai Daudayen Njǝkkayima kǝnduwoa galasaana. ");
INSERT INTO kby_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kǝmande kuren ci nawiyanju kǝrejǝnayen wuljǝnadǝ gai, ");
INSERT INTO kby_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mukko kǝladowande-a waduwunde samma-ayen samoye ");
INSERT INTO kby_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","amannju bargaa koljǝnnilan amwurawandero kanjimaɍinju fǝlejiyi. ");
INSERT INTO kby_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akko kansi duwon bawande Nawi Ibrahimbo jǝbbunadǝ: ");
INSERT INTO kby_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mukko kǝladowandeyen andia samoyiya, andi ye ridu bawoaro rangiye tia gaiye ");
INSERT INTO kby_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","fuwunjun nanmumin-a nanjire-alan kawunde samman tiro ambǝtkǝiye. ");
INSERT INTO kby_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","«Ni ye, tadani, nia nawi Mai Samemayen bowonjai. Kǝmadǝn fuwunno lenǝme tiro jawal dabbargǝmi, ");
INSERT INTO kby_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","jamanjuro biwunja gawurduyen njǝkkawodǝa isanogǝmi. ");
INSERT INTO kby_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ala Kǝmande kanjimaɍima ye, serma ye nangaro, cakke Nur Kudoma nandero samelan ise ");
INSERT INTO kby_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","am duwu-a kaudi karmoye-alan dasaanadǝa wassi, koro andiro jawal nanlewayedǝa fǝlesagai.» ");
INSERT INTO kby_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Adǝgaima tadadǝ wuraji ye, Ruhu Alayen dunoaji ye, har yim jama Israyilayero fǝledǝgǝnadǝro karaan kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jaman adǝn Kaisar Agustas wada ce am larduwanjuye sammaa komja yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sa kom burwoye adǝa cadidǝn, Kǝriniyus tima gomna cidi Siriye wo. ");
INSERT INTO kby_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Daji am samma bǝlanja bǝlanjaro tayia komjaro leyera. ");
INSERT INTO kby_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngaima duwon Isuwu ye, ti kaduwu Mai Daudaye nangaro, bǝla Najarat cidi Galileyelan cije bǝla Mai Daudaye Baitalami cani cidi Yahudiyayedǝro leji cǝne ");
INSERT INTO kby_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","tǝmajinju Meram curoadǝa ngoje tayia komjaro kallo leyera. ");
INSERT INTO kby_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tayi Baitalamilan duwon, Merambe sanju njamboye kidǝnniya, ");
INSERT INTO kby_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","tada kongwa karuro kembo. Kusottoramnin na jǝpturam cawandǝnni nangaro, Meram tia jenen kǝleje curo kalwo kǝmboram lǝmannayen sǝnayeno. ");
INSERT INTO kby_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cidi adǝn sǝniya laa karaan dasaana lǝmannanja bune gurejai duwon, ");
INSERT INTO kby_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","malaiya Kǝmandeye laa tayiro fǝlediye daraja Kǝmandeye nur gai tayia wasse dirije kǝlyenniya, tai dajane riyera. ");
INSERT INTO kby_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Amma malaiyadǝye tayiro: «Bare rinuwwi, akko kawuɍi kǝji nayiro wulnjagakki, kawuɍi duwon jama sammaye karwu kǝjijiyidǝ. ");
INSERT INTO kby_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ku bǝla Mai Daudayen Njǝkkayimando tambǝna. Tima Almasiwu Kǝmadǝ wo! ");
INSERT INTO kby_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Akko awo nayiro naptu alamayero walnjagaidǝ: Timal jenen kǝleyada curo kalwo kǝmboram lǝmannayen bowada nagǝwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sadǝman malaiyadǝro malaiyawa kǝriwuwu Kǝmandeye kǝldagane Alaa congorǝne: ");
INSERT INTO kby_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Samelan Alaro daraja tio, dunia yen am ngurnojǝnaro nanlewa jǝpcuwo!» yera. ");
INSERT INTO kby_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malaiyawadǝ tayia koljane samero walladaranniya, sǝniyadǝye kattenjan: «Ciniyo Baitalamiro leniyo, awo wakkaje Kǝmande andiro isanosaana adǝa ruiyo!» yera. ");
INSERT INTO kby_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Daji duwaduwan lejane Meram-a Isuwu-a timal curo kalwo kǝmboram lǝmannayen bowadadǝ-aa nayeyera. ");
INSERT INTO kby_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tia kerunniya, tayi ye awo malaiyadǝ kǝla tadadǝyen tayiro wuljǝgǝnadǝa isanoyeyera. ");
INSERT INTO kby_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Am lawar sǝniyadǝ tayiro wuljaanadǝa fanjanadǝ nga ajapkera. ");
INSERT INTO kby_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meram ye awo ani sammaa karwunjun rojǝna tayia takci kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Daji awo malaiyadǝ tayiro wuljǝgǝna sammaa kalkallo fanjana ye caruna ye nangaro, sǝniyadǝ Alaa congorǝne tiro daraja cadiaro karaanjaro walladara. ");
INSERT INTO kby_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kawu mawua yim tadadǝa kajaduye kidǝnniya, tiro cu Isa kesakko, cu duwon malaiyadǝ kawu yanju curo ngojiro wuljǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kǝla Attaura Nawi Musayen sanja tayirro walduye kidǝnniya, Isuwu-a Meram-a tadadǝa ngojane Kǝmandero saduwuro Jerujalembo kesado, ");
INSERT INTO kby_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Attauralan ruwuwadadǝ gai: «Tada kongwa karu tambǝna nguson Kǝmandeyero waljo!» ");
INSERT INTO kby_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Koro sadaa yea kǝla awo Attauralan wuldǝnadǝyen kedo: «Bullam yindi bi tattawar sanana yindi.» ");
INSERT INTO kby_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sa adǝn Jerujalemlan kam laa mbeji, cunju Simiyon. Tidǝ jirema ye, adinma ye, sa simalo jama Israyilaye cinduyedǝa gureji, koro Ruhu Alaye tilan kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Caman Ruhu Alayedǝ tiro Almasiwu Kǝmandeyedǝa curunni duwon nuiwawo wuljǝgǝna. ");
INSERT INTO kby_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ngaima duwon Ruhu Alayedǝ Simiyonna cakke balballa Fado Alayero kǝrgawo. Isuwu-a Meram-a awo Attaura wuljǝnadǝa dioro Isaa kewudǝnniya, ");
INSERT INTO kby_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyon tia nganjiro ngoje Alaa cungore: ");
INSERT INTO kby_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kǝmande, wuro wulsǝgǝmmadǝ gai, kǝrma wu kanjinǝmba kolsǝne kǝlewan nukko! ");
INSERT INTO kby_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akko njǝkkawonǝm simmin rukkǝna, ");
INSERT INTO kby_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","njǝkkawo duwon fuwu jama duniaye sammayen dabbarnǝmmadǝ. ");
INSERT INTO kby_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Adǝ jama kǝrdiyayero nur Alaye njukkudoma ye, jamanǝm Israyilayero daraja njoma ye,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bawanju-a yanju-a awo kǝlanjun wuljǝnadǝa fangeranniya, ajapkera. ");
INSERT INTO kby_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyon tayiro barga dǝpciye Merambo: «Akko Ala kadarjǝna tada adǝ nangaro curo jama Israyilayen am kada ye cijai, kada ye casuri. Ti naptu alama waadaye cǝdi, ");
INSERT INTO kby_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","awowa karwu am kadayen gǝraada federo culuworo. Nidǝ ye, kashagar karwunǝm sukci,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nadǝn nawi kamuye laa ye mbeji, cunju Hannatu. Ti fero Fanuwelle ye, kaduwu Asherre ye. Kawu ngǝwu juwuna, kǝlayakkun kwanju-a rokko kǝrwu tulurro napkenniya, ");
INSERT INTO kby_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kwadǝ bawoyeno, ngawo adǝyen runju napce, har kǝrwu fiskun lukko dewun kiwando. Ngaltema Fado Alayedǝa koljǝnni, asem-a moduwa-a cǝdilan bune-a kausu-a Alaro ambǝcciyi kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sa adǝn Hannatu ye ise Alaro ardije kǝla tadadǝyen am duwon merudu Jerujalembe gurejai sammaro mana kiddo. ");
INSERT INTO kby_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Daji kǝla wada Kǝmandeyen awo sammaa kedǝnniya, Isuwu-a Meram-a bǝlanja Najaratte cidi Galileyero walladara. ");
INSERT INTO kby_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Adǝgaima tadadǝ wuraji ye, dunoaji ye, jauro rashiduji ye, koro barga Alaye tilan kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Saa nguson Isaye bawanju-a yanju-a Jerujalembo sala Laya Njǝkkayirambero lejai. ");
INSERT INTO kby_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ngai duwon Isa kǝrwunju mewun yindin kidǝnniya, kǝla adayen kallo saladǝro leyera. ");
INSERT INTO kby_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngawo sala kojǝnayen, fadoro waldai duwon, nojannilan tada Isadǝ Jerujalemnin napkeno. ");
INSERT INTO kby_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ti dawu jamadǝyen cane ledu kawu falle kedǝnniya, curo kǝramiyanja-a sawawanja-ayen tia madu badiyera. ");
INSERT INTO kby_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cawandǝnnidǝ, Jerujalembo tia maduro walladara. ");
INSERT INTO kby_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngawo kawu yakkuyen Isa Fado Alayen dawu malǝmbayen napkada tayia kǝrǝnji ye, cuwori ye nayeyera. ");
INSERT INTO kby_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Am tia kǝrǝndu cadi samma kǝla hangalkǝjinju-a jaawunju-ayen ajapcana. ");
INSERT INTO kby_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bawanju-a yanju-a tia kerunniya, jauro ajapcane yanjuye tiro: «Tadani, awiro adǝa andiro seddǝm? Wu-a bawanǝm-a hangalnde nga cijǝna nia manjiye,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Isaye tayiro: «Awiro wua masew? Fado Bawaniyedǝn naptudǝ wuro wajipdǝro nonuwwi wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amma mananju adǝa asujanni. ");
INSERT INTO kby_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Daji Isa tayia jǝgane kallo bǝla Najarattero waldane mananja ngoji kǝrga. Yanju awo ani sammaa karwunjun royeno. ");
INSERT INTO kby_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Adǝgaima Isa wuraji ye, rashiduji ye, na Alaye-a ambe-an ardiya cuwandi ye kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nodo Kaisar Tiberiyasse saa kǝnmewu wuria Buntus Bilatus gomna cidi Yahudiyaye, Hirudus ye mai Galileye, awanjugǝna Filibus ye mai cidi Ituriyaye-a Tarakunitisse-aye, Lisaniyas ye mai Abileneye, ");
INSERT INTO kby_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","koro Annas-a Kaifas-a ye wurawa ɍimannaye. Jaman adǝn mana Alaye karaan Nawi Yahaya tada Jakariyayero jǝpkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Daji Yahaya cidi bǝrǝm Jordaniye sammaa jǝgane jamaro kawuɍi cǝdde kasala tuwaye biwuwa gawurduye mawoji kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Adǝgaima awo Nawi Ishaya curo kitawunjuyen ruwujǝnadǝ wakkayeno. Tiye: «Karaan kam laa kowo sapce: “Kǝmandero jawal dabbargǝnowo, koduramnju cǝkko dewo! ");
INSERT INTO kby_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ngorso rǝpkadaro walja, kǝri-a kau-aso ye sanaadaro walja. Jawal kǝriyadaso cǝkko walja, batti ye tassa. ");
INSERT INTO kby_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ngainin adamgǝna samma njǝkkawo Alayedǝa carui,” cǝne mawoji.» ");
INSERT INTO kby_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jama kada na Yahayayero tayiro kasala tuwaye cǝddoro isai duwon, Yahayaye tayiro: «Nayi kaduwu fusiyayeso, wundu nayia ajawu isidǝro kasoworo galanja? ");
INSERT INTO kby_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Awo tuwa jireye fǝlejisoa dewo! Bare karwundon: “Andi kaduwu Nawi Ibrahimbe,” wulluwwi. Nayiro wulnjagakki, Alaye kǝnduwonju dongur kauye anilan Nawi Ibrahimbo kaduwu alaktuwuye mbeji. ");
INSERT INTO kby_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Akko kǝrmamaro bewodǝ fǝrdu kǝskayen gǝnaada. Kǝska fi duwon tada ngǝla cakkiwawodǝa caljane kannuro fijagai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Daji jama captanadǝye tiro: «Awi gǝle diye?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yahayaye tayiro: «Kam nanjun gǝmaje yindiadǝ kam cǝdanniro fal co, koro kam nanjun kǝmboadǝ ye ngai cǝdo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Akki mowomaso ye tayiro kasala tuwaye cǝddoro nanjuro isane tiro: «Sayinna, awi gǝle diye?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tayiro: «Bare awo wowom wulnjaanadǝa kojǝnaro mowuwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Koro sojiya ye tiro: «Andi nda, awi gǝle diye?» cane tia keworǝnniya, tayiro: «Bare dunon bi jirenambun wuɍi kambe mowuwwi, amma kǝla biyandoyen danowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jamadǝ tǝmanjaa karwunjan Yahayama wa Almasiwudǝ woro cawori duwon, ");
INSERT INTO kby_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yahayaye tayi sammaro: «Wu ingilan nayiro kasala ngeddǝkko, amma kam laa wua kǝnduwon kosǝna je sunonjuye wuiduma tikkǝni isi. Tidǝ Ruhu Alaye-a kannu-alan nayiro kasala njaddi. ");
INSERT INTO kby_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Akko mukkonjun kǝmo laladuramba na wasturamnjuyero ise algama-a kalaɍi-a firji. Algamanjudǝa culore bǝralan gǝnaji, amma kalaɍidǝa kannu tǝmmaro nuiwawolan warji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Adǝgaima mana kadan Yahaya jamadǝa galaje tayiro kawuɍi kǝji Alayedǝa wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Calan Yahaya Mai Hirudusso kamu yanjugǝnaye Ya Hirudiyaa kamuro cǝmowona-a awo diwi kada cǝdǝnadǝ-a nangaro jǝkkadǝna. ");
INSERT INTO kby_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Daji Mai Hirudus biwunjuro biwu gade cǝrgane Yahayaa kosoro kekko. ");
INSERT INTO kby_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jaman Nawi Yahaya jama sammaro kasala tuwaye cǝddidǝn, Isa yero kasala kiddo. Daji Isa moduwa cǝdi duwon, same farakko fǝrǝmde ");
INSERT INTO kby_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruhu Alaye alama bullam gai tiro jǝpciye samelan kowo nukce: «Nima Tadani wo, njǝraakkǝna. Niramnin jauro karwuni kǝjijǝna!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Isa kǝrwunju fiakku gai duwon, kidanju badiyeno. Jamadǝ tia tada Isuwuyero ngoyera. Isuwudǝ tada Eliye, ");
INSERT INTO kby_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ye tada Mattaye, Matta ye tada Lewiye, Lewi ye tada Malkiye, Malki ye tada Jannaye, Janna ye tada Isuwuye, ");
INSERT INTO kby_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isuwu ye tada Mattatiyaye, Mattatiya ye tada Amosse, Amos ye tada Nahumbe, Nahum ye tada Esliye, Esli ye tada Naggaiye, ");
INSERT INTO kby_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai ye tada Maatte, Maat ye tada Mattatiyaye, Mattatiya ye tada Semeyinne, Semeyin ye tada Yosakke, Yosak ye tada Yodaye, ");
INSERT INTO kby_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ye tada Yohanaye, Yohana ye tada Resaye, Resa ye tada Jerubabelle, Jerubabel ye tada Sheyaltiyelle, Sheyaltiyel ye tada Neriye, ");
INSERT INTO kby_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ye tada Malkiye, Malki ye tada Addiye, Addi ye tada Kosambe, Kosam ye tada Almadamaye, Almadama ye tada Yeriye, ");
INSERT INTO kby_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yeri ye tada Yoshuwaye, Yoshuwa ye tada Aliyejerre, Aliyejer ye tada Yerimaye, Yerima ye tada Mattaye, Matta ye tada Lewiye, ");
INSERT INTO kby_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ye tada Simiyonne, Simiyon ye tada Yahudaye, Yahuda ye tada Isuwuye, Isuwu ye tada Jonamiye, Jonami ye tada Aliyakimbe, ");
INSERT INTO kby_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aliyakim ye tada Malayaye, Malaya ye tada Mannaye, Manna ye tada Mattataye, Mattata ye tada Natanne, Natan ye tada Mai Daudaye, ");
INSERT INTO kby_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Mai Dauda ye tada Yisaiye, Yisai ye tada Abidaye, Abida ye tada Bowosse, Bowos ye tada Salmonne, Salmon ye tada Nashonne, ");
INSERT INTO kby_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon ye tada Aminadabbe, Aminadab ye tada Adaminne, Adamin ye tada Arambe, Aram ye tada Hesronne, Hesron ye tada Feresse, Feres ye tada Yahudaye, ");
INSERT INTO kby_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda ye tada Yakubaye, Yakuba ye tada Isakuye, Isaku ye tada Nawi Ibrahimbe, Nawi Ibrahim ye tada Tarahuye, Tarahu ye tada Nahorre, ");
INSERT INTO kby_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ye tada Serukke, Seruk ye tada Rewuye, Rewu ye tada Felekke, Felek ye tada Abiruye, Abiru ye tada Shelaye, ");
INSERT INTO kby_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela ye tada Kenanne, Kenan ye tada Arfajadde, Arfajad ye tada Samuye, Samu ye tada Nawi Nuhuye, Nawi Nuhu ye tada Lamekke, ");
INSERT INTO kby_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ye tada Matusalembe, Matusalem ye tada Idǝrisaye, Idǝrisa ye tada Jaredde, Jared ye tada Mahalalelle, Mahalalel ye tada Kenanne, ");
INSERT INTO kby_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ye tada Yenosse, Yenos ye tada Shituye, Shitu ye tada Nawi Adambe, Nawi Adam ye Alaye. ");
INSERT INTO kby_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ruhu Alaye Isalan dǝgana duwon, Isa bǝrǝm Jordaniye kolje Ruhu Alaye tia simojiye karaa dǝɍiro culuwe ");
INSERT INTO kby_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kawu fidewuro Yiwulis tia jarapci kǝrga. Yim anin Isa awima juwunni, ngawo adǝyen kǝna tia kida. ");
INSERT INTO kby_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Daji Yiwulisse tiro: «Ni Tada Alayea, dongur kauye adǝro wulgǝne kǝmboro waljo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isaye: «A'a, kitawulan ruwuwada: “Kam kǝmbo baslan gǝni dǝgai,”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Koro Yiwulis tia na toɍi laaro cade samdǝn tiro larduwa duniaye sammaa fǝleyeyenniya, tiro: ");
INSERT INTO kby_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«Kǝnduwo-a daraja-a larduwa ani sammayedǝa niro njikki. Awo ania wuro sadǝna, wu ye kam raakkǝnaro tayia yikki. ");
INSERT INTO kby_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wuro sujada sǝddǝmia, ani samma kaanǝmbo waljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isaye: «A'a, kitawulan ruwuwada: “Ala Kǝmandero sujada yidde, ti tilonjuro ambǝtkǝne!”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Koro yaye Yiwulis tia Jerujalembo cade loiloiram Fado Alayen gǝnayenniya, tiro: «Ni Tada Alayea, na adǝn sǝktǝne cidiro yukkure! ");
INSERT INTO kby_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Awoa kitawulan ruwuwada: “Ala malaiyawanjuro wada ce nia njaɍiwi,” ");
INSERT INTO kby_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","koro: “Nia mukkonjan kamnjagai bare sinǝm kauro gǝmdǝgǝnniro,”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isaye tiro kalakciye: «A'a, kitawuye wuljǝna: “Bare Ala Kǝmandea rijammǝmmi!”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tia jarapce kerǝnniya, Yiwulis tia har sa gade laaro kolyeno. ");
INSERT INTO kby_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Daji Isa kǝnduwo Ruhu Alayea cidi Galileyero wallada. Lawarnju ye lardu sammaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dandal dandallo leje jamaa alamgenniya, wunduso tia jajakkeno. ");
INSERT INTO kby_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ngai duwon Isa Najarat bǝla wurajǝnadǝro kadio. Kǝla adanjuyen yim tustuyea dandallo ngaye jamadǝro kǝra njǝddoro cije dayeno. ");
INSERT INTO kby_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tiro kitawu Nawi Ishayaye cade kayenniya, na adǝ ruwuwadadǝa kiwando. Tiye: ");
INSERT INTO kby_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ruhu Kǝmandeye wulan kǝrga, tima kawuɍi kǝji talaawaro wulgǝkkoro wua galasǝna nangaro. Am cadane kaɍearo waljanaro nankam kǝlaye cawandi, kambuwa yero sim cawandi wulduwuro wua sinodo. Koro am curo jǝktuyen dasaanaye asǝrnja jakturo wua sinodo. ");
INSERT INTO kby_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ngaima “Sa ser Kǝmandeye fandoye cǝdǝna!” jamaro wulgǝkke mawoduro kadikko,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Daji kitawudǝa jakce kistuwumadǝro kalakciye napkeno. Am samma dandaldǝn tiro sim fijaana duwon, ");
INSERT INTO kby_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","tayiro: «Kuma awo kitawulan ruwuwada sǝmondon fannuwwa adǝ wakkajǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tayi samma kǝla mana serra cinjun culuwuna adǝyen ajapcane tia jajakcane amanjaro: «A! Kam attǝ tada Isuwuyedǝma, gǝna?» cani. ");
INSERT INTO kby_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Daji Isaye tayiro: «Fagatto karau adǝa sǝdduwe: “Karwunma, kǝlanǝm isangaane! Awo ajabba ajabba bǝrni Kafarnaamben dimma fanniyenadǝa bǝlande yen de, ruiye!” nuwi. ");
INSERT INTO kby_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jiremaro nayiro wulnjagakki, nawi fimaa bǝla wurajǝnalan kasaccanni. ");
INSERT INTO kby_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Jiremaro nayiro wulnjagakki, kuren jaman Nawi Iliyayen lardu Israyilayen kamuwa kwa faccaanaa kada mbeji, koro kǝrwu yakku redaaro ingi duro waje lardu sammaro kǝna kura kǝrgawo. ");
INSERT INTO kby_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Adǝ yaye kamu kwa faccǝgǝnaa laa bǝla Sarepta lardu Sidonnedǝro gǝnia, Ala Nawi Iliyaa na wundunjamayero cunodǝnni. ");
INSERT INTO kby_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Koro jaman Nawi Iliyasayen lardu Israyilayen am barasua kada mbeji. Adǝ yaye Naaman kam lardu Siriyea gǝnia, Nawi Iliyasa wundunjamaa isangajǝgǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Adǝa fangeranniya, am dandalnin dasaana samma tiro fum gǝrgayeyera. ");
INSERT INTO kby_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cijane tia cadane ngawo bǝlayero cattuluwe ci kau kura bǝlanja kǝladǝn garjanadǝyero kesado. Nadǝn tia cidiyaro gǝptuwu majai duwon, ");
INSERT INTO kby_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Isa dawunjayen reje koje leyeno. ");
INSERT INTO kby_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Daji Isa bǝrni Kafarnaambe cidi Galileyero kadio. Yim tustuye kidǝnniya, dandallo ngaye jamaa alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jamadǝ alamdunjudǝa ajapkera, kǝnduwoaro manaji nangaro. ");
INSERT INTO kby_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Curo dandaldǝyen karuwama laa mbeji, kamdǝ burwu dunoaro cakke: ");
INSERT INTO kby_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«A! Isa kam Najaratte, awi lambonǝm andiro? Andia siduwuro wa kadim? Nia asunjǝkkǝna, nima Tayir Alayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Amma Isa sedandǝro jǝkkade mana dapciye: «Cinǝm jange kamdǝa kolle luwe!» yeno. Sedandǝ kamdǝa dawunjan cidiro yapkeyenniya, tia lorujǝnnin kolje kiluwo. ");
INSERT INTO kby_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tayi samma ajapcane amanjaro: «Attǝ mana jiɍi fi? Kǝnduwoaro sedansoro wada ciya, caluwi!» cani. ");
INSERT INTO kby_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lawar Isaye cididǝ ngaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Isa dandaldǝn kiluwunniya, fado Simannero leyeno. Ya kǝsai Simannedǝ dondi, kange tia jauro cǝdana. Daji Isaro lawarnju wulyeyeranniya, ");
INSERT INTO kby_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ise tiro ngujiye kangedǝro kikkado. Kangedǝ tia kolje, ya kǝsai ye sadǝman cije tayia sosayeno. ");
INSERT INTO kby_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kǝngal kikkurǝnniya, amnja dondi kasuwa jiɍi jiɍia sammaa na Isayero kewudo. Wundunja yayero mukko gǝnajiye isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sedanna ye am ngǝwun caluwe yiljaiaro: «A! Ni Tada Alaye!» cani. Amma Isa tayiro jǝkkade manadu amarjǝgǝnni, ti Almasiwuro nojana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wajǝnanjua suwa lǝp Isa cije culuwe na wunduma baworo leyeno. Am ngǝwu tia madaro keluwo. Kewandǝnniya, bare tayia koljǝnniro tia roduro mayera. ");
INSERT INTO kby_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amma Isaye tayiro: «Dole bǝlawa gadero lekke kawuɍi kǝji nodo bargaa Alayedǝa wulgǝkki. Adǝma nangaro Ala wua sinodo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Adǝgaima cidi Yahudiyaye yen dandalnjan jamaro kawuɍi kǝjidǝa wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yim laa Isa ci bǝrǝm Genesaretten daada, am ngǝwu ye mana Alaye fanduro gǝgǝrǝptagane tia kimiccagai ngai duwon, ");
INSERT INTO kby_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","maara yindi ci ingidǝyen tuwada kiro. Buni tawudǝ jǝpcana, karenja buni taye tuldu cadi. ");
INSERT INTO kby_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Daji Isa leje maara Simannedǝro ngaye tiro: «Ci ingidǝyen ganaro lene!» yeno. Ngai kidǝnniya, Isa ci maaradǝyen napce koro yaye jamadǝa alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mana cǝde kerǝnniya, Simanno: «Maaradǝa na kuruwuro yade, buni taramndo figǝnowo buni taiwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simanne tiro: «Malǝm, bune farai ngǝnǝptiye diyenason, awima taiyende! Amma wulsǝgǝmmadǝro, buni taramdǝa ingidǝro figǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Fiyeyeranniya, buni kada kadami cadane, har buni taramnjadǝ kakamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Daji amanja maara toyedǝa mukkon cǝgapcane isa tayia banajaaro bowoyera. Isane maara yindi sammaa bunin kek casǝmbǝɍe, har maara yindiso lǝpturo mayera. ");
INSERT INTO kby_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Siman tiro Biturus canidǝ adǝa kirunniya, fuwu Isayen tungurumje: «Kǝma, marne nani kolle! Wu biwuma, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Awoa ti-a am rokkonjuye-aso kǝla buni ngǝwu cadanadǝyen ajapkera. ");
INSERT INTO kby_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Koro sawawanju kidaye Yakuba-a Yahaya-a tadawa Jabadiye ye ajapkera. Daji Isaye Simanno: «Bare rinǝmmi, kua adǝn fuwun kam tamaro wallǝmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Maaranja ci ingiyero kewudǝnniya, awonja sammaa koljane tia geya. ");
INSERT INTO kby_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isa bǝla laan duwon, kam laa tiyinju ngan barasua mbeji. Isaa kirunniya, fǝdǝryero tǝmde tia lowoje: «Kǝma, raammaa, rangǝme wua isangasǝgǝme tayirro wallǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isa mukko sajiye kamdǝa leje: «Raakkǝna, tayirro walle!» yeno. Sadǝman barasudǝ tia kolyeno. ");
INSERT INTO kby_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Daji Isa tiro wada ce: «Bare wundumaro adǝa wulgǝmmi, amma lene ɍimandǝro fǝledǝgǝne. Tayirro wallǝmmadǝ, sadaa Nawi Musa wuljǝnadǝa de, jamaro shedaro waljo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Adǝson lawar Isaye cayea kojǝnaro ndarasoro tatargaada. Am kada kadami tia kǝrǝndu-a kasuwanjan ngadu-aro nanjuro capkadara. ");
INSERT INTO kby_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amma Isa ngǝwusoro karaa wunduma baworo leje moduwa cǝdi. ");
INSERT INTO kby_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yim laa Isa fado laan jamaa alamdu cǝdi duwon, Farisawa-a malǝmba Attauraye-a nadǝn napkada ye mbeji. Tayidǝ bǝlawa samma cidi Galileye-a Yahudiyaye-a bǝrni Jerujalembe-alan isana, koro na Isayen kǝnduwo Kǝmandeye am dondi isangaduwuye mbeji. ");
INSERT INTO kby_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Daji am laa kam tiyi nunaa kǝla bǝnaramben ngojane kadira. Kamdǝa cawude fuwu Isayen gǝnajai cane mayerason, ");
INSERT INTO kby_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","jama captana nangaro rakcane nanjuro isaiwawodǝ, daji sorodǝro jawane kajane kamdǝa kǝla bǝnaramnjuyen dawu jamayen fuwu Isayero sayeyera. ");
INSERT INTO kby_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isa kambǝrsenja kirunniya, kamdǝro: «Kam, biwunǝm gawurdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Daji malǝmba Attauraye-a Farisawa-adǝ karwunjan: «Wundu gǝle kam Alaa gaskajǝna attǝ? Ala gǝnia, wunduma kambo biwu gawurjiyi bawo, mare?» cani. ");
INSERT INTO kby_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amma Isa awo karwunjaye asuje tayiro: «Awiro karwundon ngai wulluwidǝ? ");
INSERT INTO kby_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndaso gǝle budu wo: “Biwunǝm gawurdǝna” wulduma ra “Cine lene!” wulduma? ");
INSERT INTO kby_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nonowo, Tada Kambedǝ nanjun kǝnduwo biwu ambe dunialan gawurduye mbeji!» yeno. Daji kam tiyinju nunadǝro: «Niro wulnjǝgǝkki, cine bǝnarammǝm ngone fannǝmbo lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sadǝman kamdǝ fuwu jamadǝyen cije bǝnaramnju ngoje Alaa cungoriaro fannjuro leyeno. ");
INSERT INTO kby_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tayi samma jauro ajapcane rijane Alaa congorǝne: «Ku awo ajabba ajabba ruiyena!» yera. ");
INSERT INTO kby_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngawo adǝyen Isa culuwe akki mowoma laa cunju Lewi kidaramnjun napkadaa kiro. Isaye tiro: «Wua sǝgai!» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","cije kare sammaa kolje tia giya. ");
INSERT INTO kby_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Daji Lewi fannjun Isaro masǝna kura dabbaryeyeno. Akki mowomaso-a am gadeso-a kada ye Isa-a fuwurawanju-a rokko masǝna dioro napkera. ");
INSERT INTO kby_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisawa-a malǝmbanja Attauraye-a adǝa kerunniya, karwunja waje fuwurawanjuro: «Awiro akki mowomaso-a biwuma gadeso-a rokko masǝna diwidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isaye tayiro: «Kam dondi gǝnia, kam ngadǝ lowotor majiwawo. ");
INSERT INTO kby_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jiremasoa gǝni, biwumasoa bowokke tuwa cadoro kadikko,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Am laaye Isaro: «Fuwurawa Nawi Yahayaye-a Farisawaye-a ngǝwusoro asem cadai ye, moduwa cadi ye, amma kaanǝm jawui ye, casai ye,» yera. ");
INSERT INTO kby_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isaye tayiro: «Mai larusaye dawunjan duwon, ngaladiyaa yakkuwe asem cadai wa? ");
INSERT INTO kby_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","A'a, amma sa ise mai larusayedǝa dawunjan cattuluwiya, sa adǝn duwon asem cadai.» ");
INSERT INTO kby_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Koro walde tayiro misal adǝa cǝdde: «Wunduma kajǝmu bǝɍin karje guntu ngoje kajǝmu dinaro cukkududiwawo. Ngai cǝdia, kajǝmu bǝɍin ye kardǝna, guntu bǝɍin ye dinadǝro candǝnni. ");
INSERT INTO kby_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Koro wunduma diben bǝɍin ngoje satki dinaro fijiyiwawo. Ngai cǝdia, diben bǝɍindǝ satkidǝa falje cidiro fidiyi, satki ye bannadi. ");
INSERT INTO kby_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A'a, amso diben bǝɍindǝa satki bǝɍinno fijagai. ");
INSERT INTO kby_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Koro wunduma diben dina canadǝ bǝɍindǝa majiwawo, tiye: “Diben dinadǝ kǝji,” cǝni nangaro.» ");
INSERT INTO kby_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yim tustuyea laa Isa-a fuwurawanju-a kulo algamaye rejane kojai duwon, fuwurawadǝ kǝla algamaye ficcane mukkonjan kǝmǝssane ngǝro badiyera. ");
INSERT INTO kby_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisawa laaye tayiro: «Awi nangaro awo yim tustuyea kǝndoro haramdǝa diwidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isaye tayiro: «Sa Nawi Dauda-a amnju-a kǝna fanjanadǝn, awo cǝdǝnadǝa kitawulan kǝranuwwi wa? ");
INSERT INTO kby_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Curo Fado Alayero ngaye burodi sadaaye ngoje jǝgǝre amnju yero ce gewo. Ɍimannaro gǝnia, am gadero burodi sadaaye ngǝrodǝ haram!» ");
INSERT INTO kby_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Daji Isaye tayiro: «Tada Kambedǝ Kǝma yim tustuye, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Koro yim tustuyea laa Isa dandallo ngaye jamaa alamdu badiyeno. Nadǝn kam laa mukkonju kǝmboram canaa mbeji. ");
INSERT INTO kby_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Malǝmba Attauraye-a Farisawa-a Isaro ayau gǝnaduwu majai nangaro hangalnjayen tia ninijai, yim tustuyeaman kamdǝa isangayeyenoaro. ");
INSERT INTO kby_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amma Isa awo karwunjaye asuje kam mukko canaadǝro: «Cine dawunden dane!» yeno. Kamdǝ cije dayenniya, ");
INSERT INTO kby_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Isaye jamadǝro: «Nayia njaworǝkki, yim tustuyea ser dio ra niadiwi dioma halal wo? Ro kambe njǝkkawo ra ro tuluwoma halal wo?» ");
INSERT INTO kby_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Isa memejiaro tayi sammaa curui duwon, kamdǝro: «Mukkonǝm sane!» yeno. Sayenniya, mukkonju kǝlewa salairo walyeno. ");
INSERT INTO kby_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Malǝmba Attauraye-a Farisawa-a jauro gǝrgajane sawardane awo Isaro njǝddoye mayera. ");
INSERT INTO kby_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yim anin Isa leje kǝla kauyero juwane bune farai moduwa kido. ");
INSERT INTO kby_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dunia wayenniya, fuwurawanjua bowoje curonjan mewun yindin kǝreje tayia kǝngayambanjuro galayeno. ");
INSERT INTO kby_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tayima Siman kam tiro cu Biturus cakkǝnadǝ, yanjugǝna Andarawus, Yakuba, Yahaya, Filibus, Bartolomi, ");
INSERT INTO kby_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Toma, Yakuba tada Alfawusse, Siman tiro kam lardunju rawoma canidǝ, ");
INSERT INTO kby_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahusa tada Yakubaye, Yahusa Iskariyot kam fuwun aman bomaro waljǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isa kǝngayambanju-a rokko kaudǝlan jǝpce faya laan na fuwurawanju kada captanalan dayeno. Koro jama gade jauro ngǝwu bǝrni Jerujalembe-a lardu Yahudiyaye samma-a bǝrniya ci tekuye Tir so, Sidon so-alan ye ");
INSERT INTO kby_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","mananju kǝrǝndu-a kasuwanjan ngadu-aro nanjuro kadira. Am duwon karuwa tayia basarjaidǝ ngayera. ");
INSERT INTO kby_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jama samma Isaa leduro mayera, dalilnjudǝ kǝnduwo tiyinjun culuwe tayi sammaa isangajiyi nangaro. ");
INSERT INTO kby_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Daji Isa fuwurawanjua niniyenniya, tayiro: «Bargando nayi talaawadǝ, nodo bargaa Alayedǝ nuwandodǝro. ");
INSERT INTO kby_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bargando nayi kǝrma kǝnandoadǝ, fuwun kulluwidǝro. Bargando nayi kǝrma yiruwidǝ, fuwun kaasu diwidǝro. ");
INSERT INTO kby_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Am Tada Kambedǝ nangaro nayia wanjane dunjane raranjane diwindo wuljaiya, bargando! ");
INSERT INTO kby_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa adǝn kǝji fannowo, bikke ye farnowo, dalilnjudǝ samelan mukowando jauro ngǝwu nangaro. Nonowo, adǝgaiman amwurawanja kureyeso nawiyaro keddo. ");
INSERT INTO kby_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Kuttundo nayi gaɍiwuwadǝ, nuwando dunialan fanduwwadǝro. ");
INSERT INTO kby_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kuttundo nayi kǝrma kulluwwadǝ, fuwun kǝna fannuwidǝro. Kuttundo nayi kǝrma kaasu diwidǝ, fuwun karwukutta nayia njadane yiruwidǝro. ");
INSERT INTO kby_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Am samma ngǝlando wuljaiya, kuttundo! Nonowo, adǝgaiman amwurawanja kureyeso nawiya kattuwuyero keddo. ");
INSERT INTO kby_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Amma nayi manani fannuwidǝro wulnjagakki, kǝladowandoa rawowo, waduwundoro ser yiddowo, ");
INSERT INTO kby_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","am nayia baskunjanadǝro barga dǝpkǝnowo, koro am nayia basarnjanadǝ yero Alaa yukkorowo. ");
INSERT INTO kby_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kam feɍinǝm maɍin bakcia, feɍi faldǝ yea fǝlegǝne. Koro kam kalwunǝm gari ngojia, bare gǝmajedǝa dapkǝmmi. ");
INSERT INTO kby_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wundu duwon njuworǝnadǝro ye, koro bare kam karenǝm ngojǝnadǝa yukkorǝmmi. ");
INSERT INTO kby_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jiɍi am nayiro njaddiya raawwadǝ gai, nayi ye tayiro yiddowo! ");
INSERT INTO kby_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Am nayia njaraanaa raawia, awi mukowaye diw? Biwumaso ye am tayia caraanadǝa caraana. ");
INSERT INTO kby_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Am nayiro ser njaddiro ser yidduwia, awi mukowaye diw? Biwumaso ye ngai cadi. ");
INSERT INTO kby_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Am nayiro njakkǝrǝmbiro kasu yiwia, awi mukowaye diw? Biwumaso ye tayiro kalkal kalakcaaro amanjaro kasu cadi. ");
INSERT INTO kby_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amma nayidǝ, kǝladowandoa rawowo, ser yiddowo, kasu yiwiya, bare awima fanduwiro tǝmanuwwi. Daji mukowando ngǝwuro walje, nayi ye tadawa Mai Samemayero walluwi, dalilnjudǝ ti am kǝladowa so, sernambuwu soye serma nangaro. ");
INSERT INTO kby_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bawando kanjimaɍimadǝ gai, nayi ye amba njunonowo!» ");
INSERT INTO kby_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Bare wundumaro shara yidduwwi, nayi yero shara njaddiwawo. Bare wundumaro ayau gǝnagǝwwi, nayi yero ayau gǝnanjagaiwawo. Gawurnowo, nayi yea gawurnjai. ");
INSERT INTO kby_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yowo, nayi yero njadi, jakka kek cǝmbǝɍǝna, har fidun fidi gairo nayiro njadi. Jiɍi ambo ngalgǝwidǝ gai, nayi yero ngalnjagai.» ");
INSERT INTO kby_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Daji Isa tayiro misal adǝa ce: «Kambu kambu kamanjua jeji wa? Tayi yindi samma bǝlaaro casukkuri, mare? ");
INSERT INTO kby_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Fuwura malǝmnjua kojǝnni. Amma fuwura fi yaye ngǝlaro alamgadaro waljiya, malǝmnju gairo walji. ");
INSERT INTO kby_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Awiro kalǝm sim kamanǝmben rumi duwon, karjǝm curo simmǝmben asunǝmbawodǝ? ");
INSERT INTO kby_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Akkoni simmǝmlan karjǝmbadǝ, awiawin gǝle kamanǝmbo: “Sawani, kolle kalǝm simmǝmbedǝa tuluwukke,” nǝmi? Mǝnafǝk! Karjǝm simmǝmbedǝa tuluwumiya duwon, daji ngǝlaro rume kalǝm sim kamanǝmbedǝa tuluwumi. ");
INSERT INTO kby_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kǝska ngǝla tada diwi cakkiwawo, koro kǝska diwi ye tada ngǝla cakkiwawo. ");
INSERT INTO kby_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kǝska fi yaye tadanjulan asudi. Tarmu kolollan cadoriwawo, koro inab ye coccoɍilan njakcaiwawo. ");
INSERT INTO kby_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kam ngǝladǝ awo ngǝla karwunjulan dǝgana nangaro ngǝla cǝdi, koro kam diwidǝ ye awo diwi karwunjulan dǝgana nangaro diwi cǝdi. Adǝgaima awo karwulan dǝganadǝmaa ci manaji. ");
INSERT INTO kby_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Awiro wua Kǝma, Kǝmalan bowosuwi, amma awo wullǝkkǝnadǝa diwwawodǝ? ");
INSERT INTO kby_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wundu duwon naniro ise manani fanje jǝganamadǝ, nayiro camunonju fǝlenjagakki: ");
INSERT INTO kby_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ti alama kam soro cǝdandi cǝne leje kuruwuro laje fǝrdudǝa kǝla kauyen gǝnajǝnadǝ gai. Ingi bǝrǝmbe ngǝwuje fala tarje sorodǝa babakkenniya, wurjǝnni, dalilnjudǝ sorodǝ ngǝlaro tǝdandǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amma kam duwon manani fanjǝna jǝgannimadǝ, ti alama kam soro fǝrdu bawo cidilan cǝdandǝnadǝ gai. Ingi bǝrǝmbe ngǝwuje fala tarje sorodǝa bakkenniyama, wurgada. Wurdu sorodǝye jauro diwi,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Isa mananju samma jamaro cǝdde kerǝnniya, bǝrni Kafarnaambero leyeno. ");
INSERT INTO kby_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nadǝn soji kura Rombe laa kaɍeanju jaumaro cǝraana dondi no cǝdi mbeji. ");
INSERT INTO kby_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soji kuradǝ lawar Isaye fangenniya, amwurawa yaudiyaye laaa nanjuro cunode tia lowoja iso kaɍeanju isangajuwo yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na Isayero kadiranniya, tia jauro lowojane: «Marne, adǝa tiro yiddǝmiya jussǝna, ");
INSERT INTO kby_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","dalilnjudǝ jamande yaudidǝa cǝraana, har dandal andiro settando,» yera. ");
INSERT INTO kby_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Daji Isa tayi-a rokko leyera. Isa fadodǝa karǝngenniya, soji kuradǝ sawawanju laaa na Isayero cunode tiro: «Soji kuraye yeno: “Kǝma, bare suwoldǝmmi, nia fannin sawo tikkǝni. ");
INSERT INTO kby_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nanǝmbo kǝndema ye tikkǝni. Biya wada ye, kaɍeani ngaji. ");
INSERT INTO kby_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wudǝ cidiya kǝnduwo amben kǝrgakko, fǝrduni yen sojiya takkǝna. Falnjaro: ‘Lene!’ nǝkkiya, leji. Fal laaro: ‘Are!’ nǝkkiya, isi. Koro kaɍeaniro: ‘Adǝa de!’ nǝkkiya, cǝdi.”» ");
INSERT INTO kby_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Isa adǝa fangenniya, ajapce suworde jama tia jagaidǝro: «Nayiro wulnjagakki, curo jama Israyilayeman kambǝrse kura adǝ gai fandǝkkǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Daji am soji kura cunodǝnadǝ fadodǝro walladaranniya, kaɍeadǝa kǝlewanju salai nayeyera. ");
INSERT INTO kby_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ngawo adǝyen tussǝnni Isa bǝla laa Nayin canidǝro leyeno. Fuwurawanju-a am ngǝwu-a ye tia casadduwe leyera. ");
INSERT INTO kby_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngaworam bǝlayedǝa karǝnjana duwon, kam laa nuna ngojana kaurilaro caadi. Yanjudǝ tada gade cǝdanni, kwanju ye faccǝgǝna, koro jama kada bǝladǝye yadǝa casadduwi. ");
INSERT INTO kby_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kǝmadǝ tia kirunniya, njunoje tiro: «Bare yirǝmmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Balangardǝa karǝnje leje am tia ngojanadǝ gǝm dayera. Isaye: «Jairo, niro wulnjǝgǝkki, cine!» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","kam nunadǝ cije napce mana badiyeno. Daji Isa tia yanjuro kalakkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Am samma rijane Alaa congorǝne: «Fagat, nawi kura curonden culuwuna, Ala jamanjua banaduwuro isǝna!» yera. ");
INSERT INTO kby_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lawar Isaye adǝ cidi Yahudiyaye-a larduwa tia dirijane kǝljana-a sammaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Fuwurawa Nawi Yahayaye awo ani sammaa tiro wulyeyera. Daji Yahaya curonjan yindi bowoje ");
INSERT INTO kby_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na Kǝma Isayero koro adǝa njǝddoro kinodo: «Nima wa fuwun isimadǝ wo, ra gade gureniye?» ");
INSERT INTO kby_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na Isayero kadiranniya, tiro: «Yahaya Kasalama andia nanǝmbo koro adǝa njǝddoro sanodo: “Nima wa fuwun isimadǝ wo, ra gade gureniye?”» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa adǝn Isa am kǝndondia-a kasuwaa-a karuwaa-a kada isangajiyi, koro kambuwa ngǝwua simbaro cǝdi. ");
INSERT INTO kby_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Daji Isaye fuwurawa Yahayayero: «Waldǝnowo, awo ruwwa-a fannuwwa-aa Yahayaro wulgǝnowo: Kambuwa sim cawandi, ngurdiyiya ye sinjan lejai, am barasua ngajane tayirro waljai, muwaso ye fanjai, am sanuna roaro waljai, koro talaawa ye kawuɍi kǝjidǝa fanjai. ");
INSERT INTO kby_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Barganju kam wu nangaro taljiwawodǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Fuwurawa Yahayayedǝ sapkadaranniya, Isa kǝla Yahayayen jamadǝro mana njǝddo badiyeno. Tiye: «Awi curo karaayen kuroro leyew? Ngǝlai laa kanji kanjiro karuwaye cakke moji cǝdi wa? ");
INSERT INTO kby_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A'a. Awi gǝle kuroro leyew? Kam kajǝmu shawa cakkǝnaa wa? A'a, am kajǝmu shawa casakke curo larasuyen dasaanadǝ mairilan kasarga. ");
INSERT INTO kby_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","To, awi gǝle kuroro leyew? Nawia wa? Aaa, nayiro wulnjagakki, nawimaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tima kam duwon kǝlanjun kitawulan adǝ ruwuwadadǝ: “Nin fuwunno kǝngayammi nodǝkke, niro jawalnǝm cassai.” ");
INSERT INTO kby_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nayiro wulnjagakki, curo kam kamulan tambǝna sammayen wunduma Yahayaa kojǝna bawo. Amma curo nodo bargaa Alayen tǝngǝɍidǝ tia kojǝna.» ");
INSERT INTO kby_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Jama samma akki mowomason kundenno caman kawuɍi Yahayaye fanjanadǝ, Alaa jiremaro asujane kasaccane tayiro kasala tuwaye kiddo. ");
INSERT INTO kby_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amma Farisawa-a malǝmba Attauraye-a awo Ala tayiro niajǝgǝnadǝa wajane kasala tuwaye Yahayayedǝa kasaccanni.) ");
INSERT INTO kby_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Wundusoro am jaman adǝyedǝa rattalgǝkki? Awi gǝle tayi-a camun wo? ");
INSERT INTO kby_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tayi alama yalla ci kasuwuyen napkada kowo sapcane amanjaro: “Algaita nayiro funjagaiyena duwon, bikke randuwwi. Koro so lagaranne diyena duwon, yiruwwi,” cani gai. ");
INSERT INTO kby_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","To, Yahaya Kasalama ise kǝmbo ye juwunni, diben ye canni, “Ti karuwama!” yew. ");
INSERT INTO kby_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Koro Tada Kambedǝ ise juwui, cai, “Akko kǝmboma, kǝnjama, sawa akki mowomaso-a biwumaso-aye!” yew. ");
INSERT INTO kby_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amma nanrashidudǝ kǝndonju ngan asudi.» ");
INSERT INTO kby_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisa laa Isaa masǝna dioro doyenniya, Isa fannjuro ngaye masǝnaro napkeno. ");
INSERT INTO kby_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bǝladǝn kamu biwuma laa mbeji. Isa fado Farisadǝyen masǝna cǝdiro fangenniya, sǝndal curonjun kawudi tamannaa ngoje ise ");
INSERT INTO kby_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ngawo Isayen daje ciriaro si Isayero simalo kokoljiye kanduɍi kǝlanjuyen cinje ka cinjuye gǝnajiye kawudidǝa fijiye samgeyeno. ");
INSERT INTO kby_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Adǝa kirunniya, Farisa Isaa dojǝnadǝ karwunjun: «Ca kam adǝ nawia, kamu tia lejidǝ biwumaro noji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Isaye tiro kalakciye: «Siman, awo laa niro wulnjǝgǝkkiya, raakkǝna,» yenniya, tiye: «Sayinna, wulle!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Isaye: «Am yindi kam laayen wuɍi tagariyera. Faldǝ kasuro dinariyus yer uwu ngoyeno, faldǝ ye dinariyus fiwu ngoyeno. ");
INSERT INTO kby_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cawande carǝmbǝnnidǝ, kamdǝ kasudǝa tayi yindi sammaro wayeyeno. Wundunja gǝle tia jaumaro cǝrayi?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simanne: «Tǝmanidǝn kam tiro ngǝwu wajǝgǝnadǝma,» yenniya, Isaye: «Jire wullǝm,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Daji Isa kanji kamudǝyero suworde Simanno: «Kamu adǝa rumma, gǝna? Fannǝmbo ngaakkǝnadǝn, ingi si tuldaye sukkudǝmmi, amma kamu adǝ simalonju siniro kokoljiye kanduɍi kǝlanjuyelan cingeno. ");
INSERT INTO kby_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kaptuwu darajaa ye sǝddǝmmi, amma ngaakkǝnaman, ti wuro sinilan kǝrawo fǝleduwu koljǝnni. ");
INSERT INTO kby_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni kǝlaniro kǝndawu jaitunnema figǝmmi, amma ti siniro kawudi tamanna fijiye samgeyeno. ");
INSERT INTO kby_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Adǝ nangaro niro wulnjǝgǝkki, biwunju ngǝwu gawurdǝnaro kǝrawo kura wuro fǝlesǝgǝna, amma kam biwu ganaa gawurdǝnadǝ kǝrawo ganama fǝleji.» ");
INSERT INTO kby_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Daji Isaye kamudǝro: «Biwunǝm gawurdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Am masǝna dioro ti-a kallo napcanadǝye amanjaro: «Wundu kam biwu gawurduma attǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Daji Isaye kamudǝro: «Kambǝrsenǝm nangaro njǝkkawo fandǝmma, kǝlewan lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ngawo adǝyen tussǝnni Isa bǝla kuran ganansoa jǝgane jamaro kawuɍi kǝji nodo bargaa Alaye wulyeyeno. Fuwurawanju mewun yindindǝ-a ");
INSERT INTO kby_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kamuwa laa karuwa so, kasuwa son isangajǝgǝna-a tia kesadduwo. Kamuwadǝ tayima Meram kamu tilan sedan tulur caluwuna tia Magdalan bowojai-a ");
INSERT INTO kby_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yanna kamu Ba Kuja cuwuramma Mai Hirudusse-a Susanna-a kamu gade ngǝwu-a. Koro kamuwa laa gade ngǝwu kǝndanjalan Isa-a fuwurawanju-aa banajagai kasarga. ");
INSERT INTO kby_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Am kada kadami bǝla bǝlan isai duwon, jama ngǝwu na Isayen capkadaranniya, tayiro misal adǝa wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tiye: «Kam laa kuloro algama jǝjǝrduro kiluwo. Jǝjǝrji ngai duwon, kasuni laa jawalnin fiyada. Daji am koduwu guguwaccane ngudowa isane cotto gewo. ");
INSERT INTO kby_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kasuni laa ye na kau kauan fiyada. Ɍiyenniya, nosonambu nangaro ɍimje ngamgeno. ");
INSERT INTO kby_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kasuni laa ye na ngiwian fiyada. Ngiwidǝ ti-a kallo ɍije algamadǝa kimitkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amma kasuni laadǝ ye na katti ngǝlaan fiyadanniya, ɍije tada mia mia kekko,» yeno. Isa adǝa wulyenniya, kowo sapce: «Kam sǝmonjuamadǝ fanjo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Fuwurawanju maana misal adǝyedǝa keworǝnniya, ");
INSERT INTO kby_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isaye: «Nayiro asǝr nodo bargaa Alaye noduro amardǝgǝna, amma am gadesodǝro misalnin wuldiyi. Ngaima: “Caruima, asujaiwawo. Fanjaima, caɍiwawo.” ");
INSERT INTO kby_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Akko maana misaldǝye: Kasunidǝ mana Alaye. ");
INSERT INTO kby_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kasuni kǝla jawallen fidanasodǝ, tayima am manadǝa fanjana duwon, bare kasaccane njǝkkawo cawandǝnniro, Yiwulis ise manadǝa karwunjan cuttuluwidǝ wo. ");
INSERT INTO kby_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kasuni na kauan fidanasodǝ, tayima am manadǝa fanjaiya, karwu kǝjiaro camoyidǝ wo. Amma tayilan fǝrdu bawo nangaro, kawu ganaro kasaccai yaye, kǝla manadǝyen kuttu casaiya, wajane koljai. ");
INSERT INTO kby_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kasuni na ngiwian fidanasodǝ, tayima am manadǝa fanjana duwon, karwungai dio so, arsiyi mangardu so, duniaaram so karwunjaro ngasaye kun baɍin manadǝa kǝpcane tayiro faidajiyiwawodǝ wo. ");
INSERT INTO kby_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amma kasuni na katti ngǝlaan fidanasodǝ, tayima am manadǝa fanjane ngojane karwunja ngǝlan rojana tayiro faidajiyi, kanadin nema laa casakkidǝ wo. ");
INSERT INTO kby_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Wunduma fatǝla wasse kǝmon tǝmjiwawo bi cidiya dǝgǝllen gǝnajiwawo. Kam fatǝla wassiya, am ngasayidǝ nurdǝa caroro tia kǝla gǝnaduramnjuyen gǝnaji. ");
INSERT INTO kby_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Awima gǝraada federo culuwiwawodǝ bawo, koro awima asǝrre isanodiwawodǝ ye bawo. ");
INSERT INTO kby_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Adǝ nangaro jiɍi manani fannuwiro hangal gǝnanowo! Kam nanjun awoamadǝ, tiro casargai, amma kam nanjun bawomadǝ, awo cǝdana tǝmajǝnadǝmaa tilan camoyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Daji Isaye yanju-a yanjugǝnaso-a nanjuro kadira, amma jama ngǝwu nangaro rakcane tia gǝrejanni. ");
INSERT INTO kby_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Am laaye tiro: «Yanǝm-a yanǝmgǝnaso-a deyan daada nia manjai,» yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isaye tayiro: «Nonowo, yani-a yanigǝnaso-adǝ, tayima am mana Alaye fanjane jagaidǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yim laa Isa fuwurawanju-a rokko curo maarayero ngasaye tayiro: «Leniyo bǝrǝmdǝa falliyo ci ingiye todǝro koniyo!» cǝne ledu badiyera. ");
INSERT INTO kby_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lejai duwon, kǝnǝm Isaa ngoyeno. Daji karuwa dunoa cije ingi maaradǝa lǝptu maje, har masiwa tayia fando karǝngeno. ");
INSERT INTO kby_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fuwurawadǝ isane tia kǝnǝmnin kesangǝranniya, tiro: «Malǝm, malǝm, nuiye!» yera. Isa cije karuwadǝ-a cambaldu ingiyedǝ-aro kikkadǝnniya, dajane dunia gǝmbo walyeno. ");
INSERT INTO kby_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Daji Isaye tayiro: «Nda kambǝrsendodǝ?» yeno. Fuwurawanjudǝ rijane ajapcane amanjaro: «A! Wundu gǝle kam attǝ? Karuwa-a ingi-amaro wada ciya, jagai!» yera. ");
INSERT INTO kby_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Daji Isa-a fuwurawanju-a bǝrǝmdǝa faljane kojane cidi Gǝrasawuye fuwu cidi Galileyero kadira. ");
INSERT INTO kby_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Isa maaradǝlan jǝpkenniyama, karuwama laa bǝladǝn ise tia kapkeyeno. Tussǝna kamdǝ kajǝmu ye lujǝnni, fado yen napcǝnni, kaurilalan kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kamdǝ Isaa kirunniya, burwu cakke fuwunjun tungurumje nguje dunonjuro yilje: «Awi lambonǝm wuro, Isa Tada Ala Mai Samemaye? Lowonjǝkkǝna, bare wuro ajawu gǝnasǝgǝmmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Adǝa wuldunjudǝ, Isa burwoje sedandǝro wada ce kamdǝa koljo culuwo cǝnna nangaro. Calan ngǝwuro sedandǝ kamdǝa cǝdana. Mukkonju-a sinju-a saɍgasolan tikkerǝna yaye, tayia tǝn kakamje sedandǝ tia karaaro cuttuluwi. ");
INSERT INTO kby_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Daji Isaye tiro: «Wundu cunǝm?» cǝne kiworǝnniya, tiye: «Kǝwu Sojiyaye,» yeno, sedan kada tiro ngasaana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bare tayia na ajawuyedǝro dujǝgǝnniro sedannadǝ Isaa lowoyera. ");
INSERT INTO kby_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nadǝn alade kada kǝla kau kuruwuyen newo cadi ye mbeji. Koro sedannadǝ Isaa lowojane tayia koljo curo aladeyadǝyero ngasaworo. Tayiro amarjiye ");
INSERT INTO kby_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","kamdǝn caluwe curo aladeyadǝyero kasargawo. Daji aladeyadǝ ngǝrǝmjane kaulan jǝpcane bǝrǝmdǝro fidagane ingiye ngoje kasuno. ");
INSERT INTO kby_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sǝniya aladeyayedǝ awo wakkajǝnadǝa kerunniya, cagase lejane bǝladǝ-a karaanju-alan lawardǝa ambo wulyeyera. ");
INSERT INTO kby_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Daji amdǝ ye awo wakkajǝnadǝa kuroro keluwo. Na Isayero isane kam duwon tilan sedanna caluwunadǝ kajǝmunju ye lujǝna, hangalnju ye kalkaljǝna fuwu Isayen napkada nayeyeranniya, riyera. ");
INSERT INTO kby_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Am lamar adǝa carunadǝ jiɍi karuwamadǝ nanlewa cuwandǝnadǝa tayiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Karwunja jauro kamdǝna nangaro, am cidi Gǝrasawuye samma Isa cidinja koljoro tia lowoyera. Daji ci bǝrǝmbe todǝro walduro Isa maaradǝro kǝrgawo. ");
INSERT INTO kby_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kam tilan sedanna caluwunadǝ ye Isaa lowoje kasacco rokko leja yeno. Amma Isa tia salamje: ");
INSERT INTO kby_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Waldǝne fannǝmbo, ser kura Ala niro njǝddǝnadǝa tayiro satkǝne!» yeno. Daji kamdǝ leje bǝlanja samman ser kura Isa tiro cǝddǝnadǝa ambo wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Isa cidi Galileyero walladanniya, jamadǝ cijane mukko yindin tia kemowo, tayi samma tia gurejai nangaro. ");
INSERT INTO kby_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Daji fuwuma dandalle laa cunju Jairus na Isayero ise fuwunjun tungurumje fannjuro isoro tia jauro lowoyeno, ");
INSERT INTO kby_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","dalilnjudǝ feronju tok tilo kǝrwu mewun yindinna gai no cǝdi nangaro. Isa ledu cǝdi duwon, jamadǝ jauro tiro kǝkǝldagane tia gǝgǝrǝpkeyera. ");
INSERT INTO kby_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kamu laa ye nadǝn mbeji, kǝrwu mewun yindinno bu fidunju dajǝnni. Koro kǝndanju sammaa karwunmasoyen cuwatkǝna yaye, wunduma tia rakce isangajǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Daji kamudǝ ise ngawo Isayen susuje ci kalwunjuyedǝa leyeno. Sadǝman bu fidunju dayeno. ");
INSERT INTO kby_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isaye: «Wundu wua leso?» cǝne kiworo. Wundu yaye ti gǝni yenniya, Biturusse: «Malǝm, jamadǝ nia dirinjane kǝlnjana gǝgǝrǝmnjagai, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amma Isaye: «Kam laa wua lesǝna, kǝnduwo wulan culuwunaro asunǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kamudǝ rakce gǝradiwaworo kirunniya, lolojiaro ise fuwunjun tungurumje tiro fuwu jama sammayen dalil tia lejǝna-a jiɍi nanlewa sadǝman cuwandǝna-adǝa wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Isaye tiro: «Feroni, kambǝrsenǝm nangaro njǝkkawo fandǝmma! Kǝlewan lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Isa manaji ngai duwon, kam laa fado Jairussen ise tiro: «Feronǝm bawojǝna, bare gadero malǝmdǝa suwollǝmmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amma Isa adǝa fangenniya, tiro: «Bare rinǝmmi, biya yasarai, ngaji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Fadodǝro kadiranniya, Isaye Biturus-a Yahaya-a Yakuba-a ferodǝye bawa-a ya-a ani gǝnia, bare wunduma ti-a rokko ngaanni yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sa adǝn am samma kǝla ferodǝyen karwukuttaro cesiri. Daji Isaye tayiro: «Bare yiruwwi. Ferodǝ bawojǝnni, kǝnǝm cǝdi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Amma ferodǝ nuna nojanadǝro, tia rujane tiro kaasu keddo. ");
INSERT INTO kby_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Daji ferodǝa mukkoyen cǝdane kowo sapce: «Feroma, cine!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ferodǝ ro cuwande sadǝman ciyeno. Isaye awo kǝmboye ferodǝro cado yeno. ");
INSERT INTO kby_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bawanju-a yanju-a jauro ajapkera. Amma Isa wada ce tayiro bare wundumaro awo wakkajǝnadǝa wuljaganni yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Daji Isa mewun yindindǝa bowoje tayiro kǝnduwo sedan sammaa dudaye-a am kasuwaa isangaduwuye-a ce ");
INSERT INTO kby_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","tayiro leja kawuɍi kǝji nodo bargaa Alaye jamaro wuljaa am dondi yea isangajaa yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tayiro: «Bǝlawurodǝro bare awima ngonuwwi: ka, bi ngǝrwu, bi kǝmbo, bi wuɍi, bi gǝmaje yindi. ");
INSERT INTO kby_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndaran yaye fado ngawuwwadǝn nammowo, har kawu nadǝa kolluwiro. ");
INSERT INTO kby_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Amma ndaran yaye nayia njamowonnidǝ, bǝlanja kolluwiya, katti sindoye kagangowo, tayiro shedaro waljo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Adǝgaima kǝngayambanjudǝ saptane bǝla bǝlaro lejane kawuɍi kǝji Alaye jamaro wulyeyera, koro ndarasolan am dondi isangayeyera. ");
INSERT INTO kby_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mai Hirudus awo wakkajǝna sammaa fangenniya, hangalnju caa cijǝna, dalilnjudǝ am laaye: «Yahaya Kasalama roaro walje cijo!» cani, ");
INSERT INTO kby_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","laaye: «Nawi Iliya ambo walde fǝleduwo!» cani, laaye: «Nawiya kureye falnja roaro walje cijo!» cani. ");
INSERT INTO kby_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mai Hirudusse: «Wuma kǝla Yahayayedǝa kammǝkko. Wundu gǝle kam awo kada kǝlanjun fakki attǝ?» yeno. Adǝgaima Isaa kuroro maji. ");
INSERT INTO kby_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kǝngayambadǝ walladaranniya, awo cadǝna sammaa Isaro wulyeyera. Daji tayi runjaa ngoje karaa bǝla laa Baitsaida canidǝyero leyera. ");
INSERT INTO kby_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amma jama adǝa asuyeranniya, tia geya. Isa jamadǝa cǝmoye tayiro mana kǝla nodo bargaa Alayen wuljiye amnja dondidǝa isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dunia lǝmdu badiyenniya, tayi mewun yindindǝ isane tiro: «Na dǝgaiyenadǝ karaa. Jamadǝa salamme, bǝladeya-a bǝla-asoro leja bǝnaram-a kǝmbo-a maja!» yera. ");
INSERT INTO kby_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amma Isaye tayiro: «Nayima awo kǝmboye tayiro yowo!» yeno. Tayiye: «A! Burodi uwu-a buni yindi-a gǝnia, awima gade taiyende. Leniye kǝmbo jama ani sammaro yikkiwiye wa?» yera. ");
INSERT INTO kby_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nadǝn kongwa alama dǝwu uwu gai mbeji. Isaye fuwurawanjuro: «Jamadǝa yakkowo, kǝwu fiwu fiwuyero napca,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Adǝgai cade am samma napkera. ");
INSERT INTO kby_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Daji burodi uwudǝ-a buni yindidǝ-a ngoje kǝla samero sapce Alaro ardiyenniya, burodidǝa fǝsakce fuwurawanjuro ce fuwu jamadǝyen gǝnayera. ");
INSERT INTO kby_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tayi samma jawune kulyera. Fuwurawadǝ gaptowodǝa capkeranniya, jowo mewun yindin kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yim laa Isa runju moduwa cǝdi, fuwurawanju ye rokkonjun duwon, tayiro: «Wunduro wua amsodǝ ngosera?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tayiye: «Am laa nima Yahaya Kasalama wo cani, laaye Nawi Iliya cani, laaye nawiya kureye falnja roaro waljo cani,» yera. ");
INSERT INTO kby_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Daji Isa walde: «Nayidǝ, wunduro wua ngosew?» cǝne tayia kiworǝnniya, Biturusse: «Nima Almasiwu Alayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Amma Isa sǝmonja kasse tayiro wada ce bare wundumaro adǝa wuljaganni yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Koro Isa walde tayiro: «Ala kadarjǝna Tada Kambedǝ kuttu tai daje cane amwurawa-a wurawa ɍimannaye-a malǝmba Attauraye-a tia wajane roro ceyesi, koro kawu yakkua roaro walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Daji Isaye tayi sammaro: «Kam laa wua ga cǝraanaa, mǝradu kǝlanjuye wajo wajisoro kǝskanju karmoye ngojo wua sǝga. ");
INSERT INTO kby_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dalilnjudǝ wundu duwon ronju ɍiwo cǝraanamadǝ ronjudǝa cuwatki, amma kam duwon wu nangaro ronju cuwatkǝnamadǝ ronjudǝa cǝɍiwi. ");
INSERT INTO kby_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kam dunia adǝ ngaa jǝgande ronju asarjiya, nda riwanju? ");
INSERT INTO kby_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wundu duwon kǝla wu-a manani-ayen nangujǝnamadǝ, Tada Kambedǝ ye darajanju-a daraja Bawadǝye-a malaiyawanjuye-aa isiya, tia nanguji. ");
INSERT INTO kby_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jiremaro nayiro wulnjagakki, am laa na adǝn daada mbeji, kawu kawunja dajidǝro, nodo bargaa Alaye carui,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngawo Isa awo ania wuljǝnayen kawu wuskua gai, moduwa dioro cije Biturus-a Yahaya-a Yakuba-a ngoje kǝla kau kuruwu laayero gewa. ");
INSERT INTO kby_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Moduwa cǝdi duwon, alama fǝkkanjuye falde kajǝmunju ye bul fok tai daje yiyiljiro walyeno. ");
INSERT INTO kby_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sadǝman am yindi Isa-a jandejai mbeji, tayima Nawi Musa-a Nawi Iliya-a. ");
INSERT INTO kby_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jauro nurra fǝledane kǝla karmo Isaye Jerujalemnin wakkajiyen manajai. ");
INSERT INTO kby_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Biturus-a amanju-aa kǝnǝm dama bawo ngojǝna duwon, fayeranniya, Isaye darajanjudǝ-a am yindi nanjun daadadǝ-aa kero. ");
INSERT INTO kby_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sa am yindidǝ nanjun saptaidǝn, Biturusse Isaro: «Malǝm, andi na adǝn mbejidǝ jauro ngǝla. Kolle ngurwo yakku lammiyo: fal kaanǝm, fal Nawi Musaye, fal ye Nawi Iliyaye,» yeno, amma awo wuljidǝmaa nojǝnni. ");
INSERT INTO kby_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Manaji ngai duwon, fofou ise tayia jakkeno. Fofou tayia jakcǝnaro kerunniya, riyera. ");
INSERT INTO kby_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Daji curo fofoudǝyen kowo nukce: «Adǝma Tadani wo, tia kǝrenǝkkǝna. Mananju fannowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kowodǝ nǝmgenniya, Isaa tilonju lon kero. Yim anin wundumaro awo carunadǝa wuljaganni gǝm napkera. ");
INSERT INTO kby_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wajǝnanjua Isa-a fuwurawanju yakkudǝ-a kaudǝn jǝpkeranniya, am kada kadami nanjuro isane tia kapkeyera. ");
INSERT INTO kby_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Daji curo jamadǝyen kam laa kowo sapce: «Sayinna, nia lowonjǝkkǝna, tadania njunone! Ti gǝnia, gade takkǝni. ");
INSERT INTO kby_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sedan tia cǝdaiya, sadǝman burwu cakke cinju nga bilwua kar kar loloji. Tussǝnaro basarjǝnnia, tia koljiwawo. ");
INSERT INTO kby_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sedandǝa dujaro fuwurawanǝmba lowoyekkǝniya, tayiro katkero,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isaye tayiro: «Nayi am jaman adǝyeso kambǝrsenambuwu karwu yeskadaa, har sawi gairo dawundon dǝgakke nayia rannjakki?» yenniya, kamdǝro: «Tadanǝm kude!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tadadǝ kǝnde cǝdi duwon, sedandǝ tia babakce cure fǝrdaktu badiyeno. Amma Isa sedandǝro jǝkkade tadadǝa isangajiye bawanjuro kalakkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jama samma kǝnduwo Alayedǝa jauro ajapkera. Jamadǝ awo Isa cǝdi ngaa ajapcana duwon, Isaye fuwurawanjuro: ");
INSERT INTO kby_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Awo kǝrma wulnjagakkidǝa ngǝlaro kǝlandon taiwo, Tada Kambedǝa mukko ambero sǝrǝccagai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amma fuwurawadǝ mana adǝa asujanni, maananju tayiro gǝraaada, koro kǝla mana adǝyen tia kororo riyera. ");
INSERT INTO kby_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Daji kattenjan kambiwu kǝla wundunja kura woyen ciyeno. ");
INSERT INTO kby_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isa awo karwunjaye asuje tadaana laaa ngoje gǝrenjun isadajiye ");
INSERT INTO kby_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tayiro: «Wundu duwon cunilan tada adǝa cǝmowonamadǝ, wumaa sǝmowo. Koro wundu duwon wua sǝmowonamadǝ, ti wua sunodǝnamadǝa cǝmowo. Awoa kam curondon ganadǝ, tima kura wo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yahayaye Isaro: «Malǝm, kam laa sedanso cunǝmlan duji kiruiyendeya, andia saanni nangaro, tiro dapkeyeiye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Amma Isaye: «Bare tiro dapkǝwwi, awoa kam lawalamando gǝnidǝ kaando,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Isaye sanju samero saptaye karǝngenniya, nia Jerujalembo leduye tai daje ngoyeno. ");
INSERT INTO kby_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kǝngayamba tin fuwunno cunode tiro jǝpturam dabbarduwuro lejane bǝla laa cidi Samariyayero kasargawo. ");
INSERT INTO kby_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amma Jerujalembo leji nangaro, am bǝladǝye tia saworo wayera. ");
INSERT INTO kby_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Fuwurawanju Yakuba-a Yahaya-a adǝa kerunniya, tiro: «Kǝma, wada yiye samelan kannu jǝpce tayia juwuiya, raamma wa?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amma Isa suworde tayiro kikkado. ");
INSERT INTO kby_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Daji bǝla gadero koyera. ");
INSERT INTO kby_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jawalnin lejai ngai duwon, kam laaye Isaro: «Ndara lenǝmi yaye nia njǝgakki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isaye tiro: «Kǝluwuso bǝlaanjaa, ngudoso sameye ye fannjaa, amma Tada Kambedǝye nanju tustuyema bawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isaye kam laaro: «Wua sǝgai!» yenniya, kamdǝye tiro: «Kǝma, amarsǝgǝne lekke bawania sittǝrakkiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Amma Isaye tiro: «Kolle am sanuna amanja sanunadǝa sittǝraja! Amma nidǝ, lene nodo bargaa Alayedǝa ambo satkǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Koro kam laaye Isaro: «Kǝma, nia njǝgakki, amma amarsǝgǝne lekke jamania alakǝlewakkiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Daji Isaye tiro: «Kam barero ngujǝna duwon ngawo curuimadǝ, nodo bargaa Alayedǝn faidanju bawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngawo adǝyen Kǝmadǝ curo fuwurawanjuyen am fitulur yindin gade kǝreje tayia yindi yindiyen cunode bǝla so, bǝladeya so, na leji sammaro tin fuwunno leyera. ");
INSERT INTO kby_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tayiro: «Kaladǝ ngǝwu, amma kidawudǝ gana. Adǝ nangaro kǝma kalayedǝa lowonowo, kidawu gade yea tiro kala njǝddoro cunodo! ");
INSERT INTO kby_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lenowo, dimiya curo bulduwayero ngasaana gairo nayia njanodǝkki. ");
INSERT INTO kby_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bare wuɍi, bi ngǝrwu, bi suno gade ngonuwwi, koro bare kǝla jawallen danuwe wundumaa lewanuwwi. ");
INSERT INTO kby_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Fado fi yayero ngawuwiya, burwon ambo: “Fado adǝ barga cuwando!” wulgǝnowo. ");
INSERT INTO kby_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kam nanlewaye nadǝn mbejia, bargandodǝ tilan dǝgai. Amma bawoa, bargandodǝ nandoro waldi. ");
INSERT INTO kby_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Fado adǝn jǝmmowo nammowo, awo njadǝnadǝa buiwo yaiwo, kidamaro ngǝnǝwuramnju wajipcǝgǝna nangaro. Bare fado adǝa kolluwe fado fadoro lenuwwi. ");
INSERT INTO kby_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bǝla fi yayero ngawuwe nayia njamoyiya, awo njadǝnadǝa buiwo, ");
INSERT INTO kby_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","amnja dondi nadǝn isangagǝnowo, koro jamadǝro: “Nodo bargaa Alaye nayia karǝnnjana!” wulgǝnowo. ");
INSERT INTO kby_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amma sa bǝla laaro ngawuwe nayia mowo wajaiya, farsambo luwowo tayiro: ");
INSERT INTO kby_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Katti bǝlandoye sindero tandǝgǝnadǝmaa cinniye nayiro kolnjagaiye! Amma adǝa nonowo, nodo bargaa Alaye karǝnjǝna!” wulgǝnowo. ");
INSERT INTO kby_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nayiro wulnjagakki, kiyama wakkajiya, wowom am bǝla adǝyedǝ am bǝrni Sodombea nanjaunin koji. ");
INSERT INTO kby_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Kuttundo am bǝrni Korajinne! Kuttundo am bǝrni Baitsaidaye! Ca awo ajabba ajabba nandon tǝdǝnasodǝ bǝrni Tirre-a Sidonne-alan tǝdǝnaa, tǝn kuren amnja tuwa cade ajaja-a buwu-alan napcana. ");
INSERT INTO kby_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Amma kiyama wakkajiya, wowomndo am bǝrni Tirre-a Sidonne-ayedǝa nanjaunin koji. ");
INSERT INTO kby_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nayi ye am bǝrni Kafarnaambe, samero wa samnjai tǝmayew? A'a, kannuro kolnjagai. ");
INSERT INTO kby_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«Kam manando ngojǝnamadǝ mananimaa ngojo. Kam nayia wanjanamadǝ wumaa waso. Koro kam wua wasǝnamadǝ ye ti wua sunodǝnadǝmaa wajo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Fuwurawanju fitulur yindindǝ karwu kǝjiaro walladaranniya, Isaro: «Kǝma, cunǝmlan sedannama manande jaana,» yera. ");
INSERT INTO kby_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isaye tayiro: «Yiwulis radu gai samelan curi kirukko. ");
INSERT INTO kby_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Fannowo, nayiro kǝnduwo kadi so, kǝlanji so guwattuye njadǝkkǝna, koro kǝnduwo kǝla duno kǝladodǝye sammayen njadǝkkǝna. Awima njawandiwawo. ");
INSERT INTO kby_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Adǝ yaye bare sedanna manando jagaidǝro karwundo kǝjijǝnni, cundo samelan ruwuwadadǝro kǝjijo!» ");
INSERT INTO kby_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sa adǝn Ruhu Alaye cakke karwu Isaye tai daje kǝjije: «Bawani, Kǝma same-a dunia-aye, wusenjǝkkǝna, dalilnjudǝ awo ania rashiduwa so, ilmuwu soro gǝraame tadawa sananaro isanogǝmma nangaro. Aaa, Bawa, adǝma awo raamma wo. ");
INSERT INTO kby_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Bawani awo sammaa mukkoniro cakkǝna. Ti gǝnia, wunduma Tadadǝa nojǝnni. Koro wunduma Bawadǝa nojǝnni, sai Tadadǝ-a am tayiro Tadadǝ isanojiyiya, cǝraana-a,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Isa suworde fuwurawanju runjaro: «Sim duwon awo ruwwadǝa caruidǝ, barganja! ");
INSERT INTO kby_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nayiro wulnjagakki, kuren nawiya so, maiya so kada awo ruwwadǝa kuroro caraana, amma carunni. Koro awo fannuwwadǝa fanduro caraana, amma fanjanni,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Malǝm Attauraye laa Isaa rijapturo cije tiro: «Sayinna, awi dikke ro sawisoye fandǝkki?», yenniya, ");
INSERT INTO kby_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isaye tiro: «Awi curo Attaurayen ruwuwadadǝ? Ndayiro tia kǝrayem?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tiye: «“Ala Kǝmandea karwunǝm ngan, ronǝm ngan, dunonǝm ngan, hangalnǝm ngan raye! Koro kǝmaskinǝm yea kǝlanǝm gairo raye!”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isaye: «Kalkallo wulyem. Adǝa de, ro fandǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amma malǝm Attaurayedǝ ti jiremaro fǝleduwuro maje Isaro: «To, wundu gǝle kǝmaskini wo?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Daji Isaye tiro: «Kam laa Jerujalemnin cijǝna bǝla Jerikoyero leji duwon, jawalkorjimaso tia kapcagane ɍinjane babakcane tia nuna gai koljane leyera. ");
INSERT INTO kby_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Adǝgai duwon, ɍiman laa jawaldǝyen ise kamdǝa kirunniya, sǝgǝrije koje leyeno. ");
INSERT INTO kby_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lewi laa ye nadǝro ise tia kirunniya, sǝgǝrije koje leyeno. ");
INSERT INTO kby_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kam cidi Samariyaye laa ye bǝlawuro cǝdi duwon, nadǝro kadio. Tia kirunniya, jauro njunoje ");
INSERT INTO kby_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ise tunowanjuro kǝndawu-a diben-a karwunno fijiye kǝlekǝleyeno. Daji tia koronjuro dam gǝnajiye kusottorambo cuwude tiro kiskeyeno. ");
INSERT INTO kby_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wajǝnanjua dinariyus yindi cuttuluwe kǝma kusottorambero ce tiro: “Kam adǝro kiskǝne. Waldǝkkiya, wuɍi kojǝnaro yejǝmma sammaa niro kalannjǝgǝkki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«To, malǝm, niyen wa curo am yakku aniyen wundunja kǝmaski kam jawalkorjimaso kapcaanadǝye wo?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Malǝm Attauraye: «Kam tia njunojǝnadǝma,» yenniya, Isaye tiro: «Ni ye lene, ti gai de!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isa-a fuwurawanju-a lejai duwon, bǝla laaro kadiranniya, kamu laa cunju Marta tia fannjun kisawo. ");
INSERT INTO kby_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yanjugǝna cunju Meram fuwu Kǝmadǝyen napkada mananju kǝrǝndu cǝdi duwon, ");
INSERT INTO kby_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaro kida sosaye ngǝwujiye hangalnju jauro jaada. Daji Marta na Isayero ise tiro: «Kǝma, yanigǝna wua kolsǝna runi kida dikkidǝ, ni lambonǝm gǝni wa? Tiro wulgǝne wua banasuwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kǝmadǝye tiro: «Marta, Marta, awo ngǝwuro hangalnǝm jadi, ");
INSERT INTO kby_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","amma awo faidaadǝ falma, diye! Meram awo ngalwodǝa kǝrejo, koro wunduma nanjun cǝmoyiwawo.» ");
INSERT INTO kby_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yim laa Isa na laan moduwa cǝde kerǝnniya, fuwurawanjuye falnja tiro: «Kǝma, andiro moduwa dio sakkarai, jiɍi Yahaya fuwurawanjuro cǝkkǝranadǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isaye tayiro: «Sa moduwa diwiya, ngai wullowo: «“Bawa, cunǝmbo daraja tio! Nodonǝm bargaa iso! ");
INSERT INTO kby_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yimbi yaye kǝmbonde sade. ");
INSERT INTO kby_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Biwunde gawursagane, andi ye am biwu saddǝnadǝa gawurniye nangaro. Bare kolsame jaraptiyende.”» ");
INSERT INTO kby_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Koro Isa walde tayiro: «Kamndo laa sawanjua duwon dǝrdu fannjuro leje tiro: “Sawa, burodi yakku tagarisǝgǝne. ");
INSERT INTO kby_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kǝrmama sawani laa curo bǝlawuroyen duwon, nanin jǝpkeno, koro wu ye awima tiro yikke juwui bawo,” yenniya, ");
INSERT INTO kby_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","sawanjudǝ curo fadodǝyen tiro: “Kolsǝne, bare suwolsǝmmi! Cinna ye jakkada, koro wu-a yallani-a ye boniyena. Rangǝkke cikke njikkiwawo,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nayiro wulnjagakki, nansawanja nangaro gǝni, amma dolero cije awo cǝraana sammaa ci. Dalilnjudǝ kamdǝ nangujǝnni tia cuworiya, cuwori nangaro. ");
INSERT INTO kby_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Koro nayiro wulnjagakki, korowo njadi, manowo fanduwi, cinna bangowo kanjagai. ");
INSERT INTO kby_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wundu duwon cuworimadǝro cadi, kam majimadǝ ye cuwandi, koro kam cinna bakcimadǝ yero kajagai. ");
INSERT INTO kby_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bawa fi curondon tadanju tia buniro cuworiya, cujunjuro kadi cidǝ? ");
INSERT INTO kby_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bi ngǝwullo cuworiya, kǝlanji cidǝ? ");
INSERT INTO kby_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nayi diwiso awowa ngǝla tadawandoro njo nonuwwaa, balle Bawa Mai Samema Ruhunjudǝmaa am tia caworiro cidǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yim laa Isa sedan kam laaa muwaro cǝdǝnaa duje kiluwunniya, kamdǝ mana badiyeno. Jamadǝ ajapkera, ");
INSERT INTO kby_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","amma laaye: «Kǝnduwo Beljabul mai sedannayen sedannaa duji,» yera. ");
INSERT INTO kby_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Laanja ye tia rijapturo alama laa sameye tayiro fǝlejuworo mayera. ");
INSERT INTO kby_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amma Isa awo karwunjaye asuje tayiro: «Kǝrmai fi yaye kǝlanjuro yaktǝgǝnadǝ dǝgaiwawo, koro fado duwon kǝlanjuro yaktǝgǝnadǝ dǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wu sedannaa kǝnduwo Beljabullen dukki nuwwa. To, Yiwulis ye kǝlanjuro yaktiyia, ndayilan gǝle kǝrmainjudǝ dǝgai? ");
INSERT INTO kby_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Koro wudǝ kǝnduwo Beljabullen sedannaa dukkia, fuwurawando kǝnduwo wunduyen gǝle sedannaa dujai? Adǝmaro tayi sharawundoro waljai. ");
INSERT INTO kby_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amma kǝnduwo Alayeman sedannaa dukkia, daji nodo bargaa Alaye nandoro isǝna, diye! ");
INSERT INTO kby_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Kam dunoa mukkon baɍimia fannju gurejiya, kǝndanju samma kǝlewa. ");
INSERT INTO kby_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amma kam laa tia dunon kojǝna ise tia lawalaje nasardiya, baɍiminju ardijǝnadǝa cǝmoye kǝndanju sammaa ngoje dagarji. ");
INSERT INTO kby_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nonowo, kam wuro kǝldǝgǝnnidǝ lawalamani, koro kam wua banasiye rokko cammiyewawodǝ tarduma. ");
INSERT INTO kby_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Sedan kamlan culuwiya, leje curo karaa dǝɍiyen na naptuye maji, cuwandiwawodǝ, daji kǝlanjuro: “Nda fanni kollǝkkǝnadǝro waldǝkke,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Waldiya, fadodǝa tas fǝraada ye, tassana ye najiyi. ");
INSERT INTO kby_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Daji leje sedan tulur gade tia nandiwin kojana capce cuwude ngasaye napcai. Adǝ nangaro naptu kam adǝyedǝ cayemaa kojǝnaro kuttaji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Isa manaji ngai duwon, kamu laa curo jamadǝyen kowo sapce: «Bargaa kamu nia njambe tǝgam njinadǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Isaye: «Attǝroa, barganja am mana Alaye fanjane jaanadǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jamadǝ na Isayen cacaptai adǝgai duwon, Isaye: «Am jaman adǝye jauro diwi. Alama laa sameye majai, amma alama Nawi Yunusse gǝnia, alama fima tayiro fǝlediyiwawo. ");
INSERT INTO kby_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jiɍi Nawi Yunus kuren am bǝrni Niniweyero alamaro waljǝnadǝ gai, Tada Kambedǝ ye am jaman adǝyero alamaro walji. ");
INSERT INTO kby_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kiyama wakkajiya, Mai kamuye lardu Anǝmbedǝ cije am jaman adǝyedǝa jirenambuwuro shedaji, dalilnjudǝ ti ci duniayen cije na Mai Sulemanayero nanrashidunju fanduro isǝna nangaro. Akko awo laa Mai Sulemanaa kojǝna nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kiyama wakkajiya, am bǝrni Niniweye ye cijane am jaman adǝyedǝa jirenambuwuro shedajai, dalilnjudǝ tayi mana Nawi Yunusse ngojane tuwa cadǝna nangaro. Akko awo laa Nawi Yunussa kojǝna nadǝn mbeji. ");
INSERT INTO kby_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Wunduma fatǝla wasse na turuiwawolan bi kǝmon tǝmjiwawo. Kam fatǝla wassiya, am ngasayidǝ nurdǝa caroro tia kǝla gǝnaduramnjuyen gǝnaji. ");
INSERT INTO kby_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Simmǝmdǝ tima fatǝla tiyinǝmbe wo. Simmǝm ngaa, tiyinǝm samma ye nurraro walji. Amma simmǝm kuttua, tiyinǝm samma ye duwuaro walji. ");
INSERT INTO kby_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","To, hangal gǝnane, bare nur nilan dǝganadǝ duwuro waljǝnniro! ");
INSERT INTO kby_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tiyinǝmlan ndarama duwu bawo samma nurraa, alama fatǝla nurnjulan nia wasnjidǝ gai kǝrgam.» ");
INSERT INTO kby_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Isa mana cǝdi ngai duwon, Farisa laa fannjuro tia masǝna dioro doyeno. Leje fadodǝro ngaye masǝnaro napkera. ");
INSERT INTO kby_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisadǝ kǝla Isa mukkonju tulje tayirro cǝdǝnnin masǝnaro napcǝnayen ajapkeno. ");
INSERT INTO kby_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Daji Kǝmaye tiro: «Nayi Farisawadǝ ngawo tasaye-a gǝmdowolombe-adǝa tulluwe tayirro kalanguwi, amma curondodǝ kǝnda am gadeye luwaptu so, niadiwi dio solan cǝmbǝɍǝna. ");
INSERT INTO kby_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nayi hangal kuttua! Ti ngawodǝa alakcǝnadǝ curodǝ yea alakcǝnni wa? ");
INSERT INTO kby_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Karwu tiloaro sadaa yowo, daji awiso nayiro tayirro walnjagai. ");
INSERT INTO kby_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kuttundo nayi Farisawa! Bulu kaskasi so, nana so, kǝɍijuwo samma solan jakka tuluwuwi, amma jire dio so, Alaa rawo soa kolluwwa. Tayidǝa kolluwwin awo ani yea dio wajimnjaana. ");
INSERT INTO kby_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kuttundo nayi Farisawa! Dandallan napturam fuwuye-a kasuwulan lewa darajaa-a raawwa. ");
INSERT INTO kby_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kuttundo, nayi alama kauri noduram bawoa am nojannilan tia guwaccane kojaidǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Malǝmba Attauraye falnjaye tiro: «Sayinna, adǝgai wullǝmiya, andi yea rasamma, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Daji Isaye tiro: «Nayi ye kuttundo, malǝmba Attauraye! Katkun kurwowu dama bawo ambo gǝnagǝwi, amma nayi ngulondoma sanguwe tayia banagǝwwawo. ");
INSERT INTO kby_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kuttundo! Kauriya nawiya kureye tanduwi, koro amwurawandodǝma tayia ceyeso! ");
INSERT INTO kby_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngainin awowa amwurawando cadǝna sammaa kasadduwwaro shedanuwi, dalilnjudǝ tayi nawiyaa ceyesǝna, nayi ye kauriyanja tanduwwa! ");
INSERT INTO kby_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Adǝ nangaro nanrashidunjulan Alaye: “Nawiya-a kǝngayamba-a tayiro juwagǝkki. Laanjaa ceyesi, laanja yea basarjai,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Adǝma nangaro bu nawiya sammaye kawu dunia alaktǝnaman am jaman adǝyero cukkuri, ");
INSERT INTO kby_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bu duwon jaman Nawi Haabilayen tamiya har jaman Nawi Jakariya katte laya duwadurambe-a Fado Alaye-ayen bawojǝnadǝyero kudero samma fidǝnadǝ. Ai, nayiro wulnjagakki, kǝla am jaman adǝyemaro cukkuri. ");
INSERT INTO kby_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kuttundo, malǝmba Attauraye! Awoa cuwuram ilmuye ngonuwwa, nayi kǝlando ye ngawuwwi, koro am tiro ngaworo majaidǝ yero dapkǝwwa.» ");
INSERT INTO kby_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Isa nadǝa kolyenniya, malǝmba Attauraye-a Farisawa-a tiro jauro gǝrgajagane koro kǝla awo ngǝwuyelan tia jǝkcane ");
INSERT INTO kby_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jawal mananjulan tia taye madu badiyera. ");
INSERT INTO kby_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sa adǝn am kada kadami isane captane, har amanjaa guguwaccai duwon, Isa burwolan fuwurawanjuro manaduwu badiyeno. Tayiro: «Farisawadǝro hangal gǝnanowo, nanmǝnafǝknja yis gai. ");
INSERT INTO kby_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awima gǝraada federo culuwiwawodǝ bawo, koro awima asǝrre isanodiwawodǝ ye bawo. ");
INSERT INTO kby_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Adǝgaima awo curo buneyen wulluwwadǝa kausulan fanjai, koro awo curo ngimben tatapkǝwwadǝa farsamlan kurukcai. ");
INSERT INTO kby_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Sawawani, nayiro wulnjagakki, bare am ro kambe cattuluwe ngawo adǝyen awima gade rakcane cadiwawodǝa rinuwwi. ");
INSERT INTO kby_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Amma ti rinuwimadǝa nayiro fǝlenjagakki: Ti duwon ngawo ro kambe cuttuluwunayen kǝnduwo tia kannu jaanamayero njakkoye cǝdanadǝa rinowo. Aaa, nayiro wulnjagakki, Alaa rinowo! ");
INSERT INTO kby_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Binaru uwu gursu yindiro caladi, gǝna? Adǝ yaye Ala falnjamaa cǝpciyiwawo. ");
INSERT INTO kby_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nonowo, kanduɍi kǝlandoyema samma komgada. Bare rinuwwi, binaru ngǝwua darajan konuwwa. ");
INSERT INTO kby_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Nayiro wulnjagakki, wundu duwon fuwu amben ti kakke cǝnnamadǝ, Tada Kambedǝ ye fuwu malaiyawa Alayen kamdǝ kaanju cǝni. ");
INSERT INTO kby_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amma kam duwon fuwu amben wua angǝrsǝnamadǝ fuwu malaiyawa Alayen angǝrdi. ");
INSERT INTO kby_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wundu duwon kǝla Tada Kambedǝyen manakuttu wuljidǝ, tiro gawurdiyi. Amma kam Ruhu Alayea bassimadǝ, tiro gawurdiyiwawo. ");
INSERT INTO kby_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sa nayia dandallo, bi shararambo, bi mairiro njasadiya, kǝla awo wulluwiyen bi jiɍi kǝlando mowuwiyen bare hangalndo cijǝnni, ");
INSERT INTO kby_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","dalilnjudǝ sa adǝn Ruhu Alaye awo wulduyedǝa nayiro njakkǝrai nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Curo jamadǝyen kam laaye Isaro: «Sayinna, yeiyaniro wulgǝne, curo warasandeyen nuwani sio!» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isaye tiro: «A! Wundu wua shara kamdamandoro bi warasa dagardumandoro sǝdo?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Daji jamadǝro: «Hangal gǝnanowo! Arsiyi luwapturo kanowo, kam lǝman ngǝwu jǝgandǝna nangaro gǝni roa dǝgai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Daji tayiro misal cǝdde: «Gaɍiwu laa kulonju nema jauro kekkǝnniya, ");
INSERT INTO kby_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","kǝlanjuro: “Na nemani adǝa cammǝme njakkoye bawodǝ, awi gǝle dikki?” yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Daji walde: “Akko awo dikkidǝ: Jawuwanisoa wurnǝkke gade kura kura tandǝkke curonjan algamani-a awo gade gandǝkkǝna samma-a cammǝkke yakkǝkki. ");
INSERT INTO kby_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Daji wuye karwunin: ‘Akko kǝmboso kǝrwu kadaye takkǝna. Garal nammǝkke bukke yakke, kǝji fakki!’ nǝkki.” ");
INSERT INTO kby_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amma Alaye tiro: “Ni hangal bawoa! Bune adǝman kawunǝm daje numi! Daji awo ani kǝlanǝmbo capkǝmmadǝ, wundu gǝle tayia jǝgandi?” yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ngaima kam kǝlanjuro arsiyi capcǝgǝna, amma na Alayen gaɍiwuro waljǝnnimadǝ, ti yero wakkajiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Daji Isaye fuwurawanjuro: «Adǝ nangaro nayiro wulnjagakki, bare kǝla awo rondoro buwiyen bi kǝla awo tiyindoro yakkuwiyen karwungai diwwi. ");
INSERT INTO kby_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Rodǝ kǝmboa kojǝna, koro tiyidǝ ye kajǝmua kojǝna. ");
INSERT INTO kby_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngawusoa ruiwo, kulo ye canadiwawo, kala ye cadiwawo, koro ngajiram-a jawu-a ye cadanni yaye, Ala tayia ambaji. Nayidǝ jauro ngudowaa darajan konuwwa, diye! ");
INSERT INTO kby_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wundundo gǝle rakce karwungainjulan sa fal kawunjuro cǝrgai? ");
INSERT INTO kby_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","To, ranguwe awo kǝske adǝmaa diwwawoa, awiro gǝle kǝla awowa gadedǝyen karwungai diwi? ");
INSERT INTO kby_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Fǝɍeso jiɍi ɍijaidǝa ruiwo, ngǝnǝpcaiwawo, koro caa cadiwawo. Amma nayiro wulnjagakki, Mai Sulemana jauro darajaa yaye, ngaltema kajǝmu fǝɍe aniye falnjaa nanshawan najǝgǝna cakkǝnni. ");
INSERT INTO kby_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ala fǝɍeso ku karaan ɍijai baɍi kannuro fijagai ania ngai jakcidǝ, fagatto nayi yea jannjai, nayi kambǝrse ganaadǝ! ");
INSERT INTO kby_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bare awo buwi-a yawi-aa manuwwi, bare karwungai diwwi. ");
INSERT INTO kby_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jama duniaye samma awo ania majai, amma Bawando nayi ye awo anin mǝradundoaro nojǝna. ");
INSERT INTO kby_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Attǝroa, nodonju manowo duwon, awo ani yea nayiro njadi. ");
INSERT INTO kby_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Nayi jama gana, bare rinuwwi, Bawando nodonju bargaa nayiro njoro cǝraana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kǝndando ladowo, wuɍidǝa talaawaro yowo. Kǝlandoro aɍitta dinjiwawo yikkududowo, arsiyindo samelan har abadaro ceriwawo, na duwon barwu ye lejiwawo, kanam ye juwuiwawodǝ. ");
INSERT INTO kby_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nonowo, na arsiyindo dǝganadǝman karwundo ye kǝrga. ");
INSERT INTO kby_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Canjando ye gerowo, fatǝlawando ye waskada kollowo! ");
INSERT INTO kby_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wolodiya waldu kǝmanjaye gurejai gairo dabbardǝnowo. Sa kǝmanja larusaramlan ise cinnadǝa bakciyama, tiro kajagai. ");
INSERT INTO kby_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Barganja wolodiya kǝmanja ise tayia faada najiyidǝ! Jiremaro nayiro wulnjagakki, dabbarde tayia cakke masǝna dioro napcane ise ti kǝlanju kǝmbo tayiro sajiyi. ");
INSERT INTO kby_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bune dǝrdu bi dǝrdu kojǝnaman kadioro walyenoa, tayia faada najiyia, barganja! ");
INSERT INTO kby_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amma adǝa nonowo, ca kǝma fadoyedǝ sa barwu fannjuro isidǝa nojǝnaa, tia kolje fannjuro ngayiwawo. ");
INSERT INTO kby_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nayi ye faadaro dǝgaiwo, dalilnjudǝ sa tǝmanuwwilan Tada Kambedǝ isi nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Daji Biturusse: «Kǝma, misal adǝa andiro wa wulsagami, ra jama sammaro?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kǝmaye tiro: «Wundu gǝle wolodi amanna ye, hangalla yedǝ wo, ti duwon kǝmanja tia kǝreje wolodiya amanjuro nuwanja kǝmboye sa tǝraanan njoro galajidǝ? ");
INSERT INTO kby_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kǝjinju wolodi kǝmanju waldiya, ngai cǝdi najiyidǝ! ");
INSERT INTO kby_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jiremaro nayiro wulnjagakki, kǝmadǝ kǝndanju sammaa mukko wolodi adǝyero cakki. ");
INSERT INTO kby_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amma wolodi adǝ karwunjun: “Kǝmani duwan isiwawo,” cǝne wolodiya amanjua kamun kwan babaktu badije juwe diben cane sagarandi kǝrgaro walyenoa, ");
INSERT INTO kby_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","daji wolodi adǝye kǝmanju yim tǝmajǝnni-a sa nojǝnni-alan ise tia kirwolan jajarje curo aman bowuyero cakki. ");
INSERT INTO kby_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wolodi mǝradu kǝmanjuye nojǝna duwon dabbarduro bi mǝradu kǝmanjuyedǝa galduro wajǝnamadǝ, jauro tia kowojai. ");
INSERT INTO kby_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amma wolodi awo kǝmanju cǝraana nojǝnni duwon awo tiro wowom gǝnaduwuye cǝdǝnamadǝ, tia ganamaro kowojai. Wundu duwon tiro awo ngǝwu cadǝnadǝ, nanjun ngǝwu cawori. Koro kam mukkonjuro awo jauro ngǝwu casakkǝnadǝ, nanjun ngǝwudǝmaa kojǝna cawori. ");
INSERT INTO kby_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Kannu duniaro njǝttaro kadikko. Kannudǝ kǝrmaman cambǝnaa, jauro raakko! ");
INSERT INTO kby_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wuro kasala laaa saddi mbeji. Kawu ceridǝro, kasala adǝye kurwowunju jauro jau fakki. ");
INSERT INTO kby_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Duniaro nanlewa wa kudoro kadikkoro tǝmayew? A'a, nayiro wulnjagakki, nanlewa gǝni, firda. ");
INSERT INTO kby_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na adǝn fuwun fado falnin kam uwu firdai, yakkudǝ kǝlado am yindiyero waljai, yindidǝ ye kǝlado am yakkuyero waljai. ");
INSERT INTO kby_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Adǝgaima firdai, bawa kǝlado tadanjuyero walji, tada ye bawanjuyero, ya kǝlado feronjuyero walji, fero ye yanjuyero, ya kǝsai kǝlado kamu tadanjuyero walji, kamu tadaye ye kǝsainjuyero.» ");
INSERT INTO kby_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Daji Isaye jamadǝro: «Keyera fǝden cijǝna ruwiya, sadǝman nayiye: “Ingi fandiye,” nuwi, adǝgaima wakkaji. ");
INSERT INTO kby_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Koro karuwa anǝmbe cijǝna ruwiya, nayiye: “Ku jauro kausuaro walji,” nuwi, adǝgaima wakkaji. ");
INSERT INTO kby_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nayi mǝnafǝkkaso, awo same-a cidi-alan fǝledidǝa fisardu nonuwwadǝ, awiro gǝle awo jaman adǝn wakkajidǝa fisardu nonuwwidǝ? ");
INSERT INTO kby_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Awi nangaro nayidǝ kǝlandoro kommuwe awo dioye jussǝnadǝa nonuwwawodǝ? ");
INSERT INTO kby_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sa lawalamanǝm-a rokko shararambo lenuwiya, kǝla jawalledǝman kowoɍi de tawaktǝne, bare nia fuwu alkaliyero njadǝnniro. Adǝ gǝnia, alkali nia mukko sojiyero njakke, soji ye nia kosolan jannjiyi. ");
INSERT INTO kby_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Niro wulnjǝgǝkki, nadǝn tǝmmaro luwumbawo, sai wuɍidǝa cotto rǝmbǝmiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sa adǝn am laa na Isayero isane lawar am cidi Galileye bu fida cadi duwon, Gomna Bilatus cakke tayia ceyesǝnayedǝa tiro kekkudo. ");
INSERT INTO kby_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isaye tayiro: «Galilewu ani bone ngai casana nangaro, Galilewu gade sammaa biwunin kojanaro tǝmanuwwa wa? ");
INSERT INTO kby_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A'a, nayiro wulnjagakki. Adǝ yaye, tuwa diwwawoa, nayi samma ye nuwi. ");
INSERT INTO kby_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ra, am mewun wuskun soro kuruwu lakka Silowambe wurde kǝlanjaro cukkure sanunadǝ, am gade Jerujalemnin dasaanadǝa biwunin kojanaro tǝmanuwwa wa? ");
INSERT INTO kby_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A'a, nayiro wulnjagakki. Adǝ yaye, tuwa diwwawoa, nayi samma ye nuwi.» ");
INSERT INTO kby_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Daji Isa tayiro misal adǝa cǝdde: «Kam laa curo jǝrwunju inabben ya tarmuye kokcǝna duwon, tada madaro kadinniya, cuwandǝnni. ");
INSERT INTO kby_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Daji jǝrwu njattomadǝro: “Akko ku kǝrwu yakku kǝska adǝn tada madaro isǝkkiya, awima fandǝkkiwawodǝ. Calle tia! Awiro bowuro na cǝmoyi?” ");
INSERT INTO kby_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amma jǝrwu njattomadǝye tiro: “Bani ngimba, kasadde kǝmǝne adǝ tia kolle, fǝrdunju tammǝkko muɍi figǝkko. ");
INSERT INTO kby_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Baɍiminna tada kekkoa, ngǝla. Bawoa, callǝmi,”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yim tustuyea laa Isa dandalnin jamaa alamji duwon, ");
INSERT INTO kby_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","kamu laa nadǝn mbeji, karuwa tia leje maskinno cǝdǝna kǝrwu mewun wuskunno nguwada rakce cǝkko dajiwawo. ");
INSERT INTO kby_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isa tia kirunniya, bowoje tiro: «Ya, nanmaskinnǝm-a faiduwwa!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tiro mukkonju gǝnayeyenniyama, kamudǝ cije cǝkko daje Alaa jajaktu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amma Isa yim tustuyea kamudǝa isangajǝgǝna nangaro, kura dandaldǝye gǝrgaje jamaro: «Curo mawuyen kawu arakku kidaye kambo amardǝgǝna. Yim tustuyea gǝni, yim animaa arowo isanganjaa!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kǝmaye tiro kalakciye: «Mǝnafǝkka, wundundo yaye yim tustuyea dalonju bi koronju wuije cade catti, gǝna? ");
INSERT INTO kby_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","To, kamu adǝ, kaduwu Nawi Ibrahimbe duwon Yiwulis kǝrwu mewun wuskunno tia cikkerǝnadǝ nda? Yim tustuyea tia wuidu wuro wajimsǝgǝnni wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Adǝa wulyenniya, waduwunju sammaa nangu kida, amma jama gade samma awo ajabba ajabba cǝdidǝye kǝji fanjai. ");
INSERT INTO kby_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Daji Isaye: «Nodo bargaa Alayedǝ, awi camunonju wo? Awiro tia rattalgǝkki? ");
INSERT INTO kby_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Alamanjudǝ kasuni mutarre kam laa ngoje jǝrwunjulan fije ɍije kǝska kuraro walje, har ngudoso dǝlambanjun fannja cadandǝnadǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Koro Isa walde tayiro: «Awiro nodo bargaa Alayedǝa rattalgǝkki? ");
INSERT INTO kby_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Alamanjudǝ yis kamu laa ngoje rungo algamaye jaa yakku-a kǝlje dije, har fum fujǝnadǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Isa jawal Jerujalembe jǝgaialan bǝla kuran ganansolan jamadǝa alamji ngai duwon, ");
INSERT INTO kby_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","kam laaye tiro: «Kǝma, am ganama wa njǝkkawo cawandi?» cǝne tia kiworo. Isaye jamaro: ");
INSERT INTO kby_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Cinna jǝkkadǝyen jǝktǝnowo ngawowo, nayiro wulnjagakki, am kada ngaworo majai, amma rakcaiwawo. ");
INSERT INTO kby_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Fannowo, sa kǝma fadoye cije cinnadǝa kǝrǝp jakciya, nayi deyan daadadǝ cinna banguwe: “Kǝma, kasagane!” nuwi, amma tiye: “Nayia nonjakkǝni ndaran kadiwmaro,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Daji nayi ye: “A! Ni-a kallo buiyena ye, yaiyena ye, koro farsamndesolan jamaa alammǝmma, diye!” nuwi, ");
INSERT INTO kby_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","amma tiye: “Nayia nonjakkǝni ndaran kadiwmaro. Wun kuruwunno lenowo, nayi diwi diomaso!” cǝne kalannjagai. ");
INSERT INTO kby_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Nadǝn so ye tǝdi, sheɍi ye naldi, sa adǝn Nawi Ibrahim-a Nawi Isaku-a Nawi Yakuba-a nawiya gade samma-a nodo bargaa Alayen ruwi, amma nayi kǝlandodǝa deyaro gǝmnjagai. ");
INSERT INTO kby_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Am laa adinnam-a fǝde-a yala-a anǝm-alan isane tayi ye nodo bargaa Alayen masǝna dioro napcai. ");
INSERT INTO kby_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Adǝgaima am laa daryeyedǝ burwoyero waljai, koro laa burwoyedǝ ye daryeyero waljai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa adǝn Farisawa laa na Isayero isane tiro: «Lene, na adǝa kolle! Mai Hirudus nia njejoro manji,» yera. ");
INSERT INTO kby_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isaye tayiro: «Lenowo, dǝla jambamadǝro: “Akko ku-a baɍi-a sedanna dukki, am yea isangagǝkki, kawu yakkua kidanidǝa tumogǝkki,” wulgǝnowo. ");
INSERT INTO kby_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Fagatto ku-a baɍi-a waare-a jawalni gakki. Jerujalemlan gǝnia, na gaden nawi fimaa ceyesiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Koro Isa walde: «Jerujalem, Jerujalem, nayi duwon nawiyadǝa roro yejuwe am juwanjaanadǝro dongur kauye gǝgǝpkǝwe sanuidǝ! Alama kuwui tadawanju fefedowanjun jakcidǝ gai, ngǝwuro nayia nanin capturo raakkǝna, amma wayew. ");
INSERT INTO kby_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akko fanndo de sul kolnjaana. Nayiro wulnjagakki, wua suruwwawo, har nayiye: “Bargaa ti cu Kǝmandeyen isimadǝ!” wulluwiro.» ");
INSERT INTO kby_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yim tustuyea laa Isa masǝna dioro fado Farisawaye kuranja laayero leyenniya, amdǝ jauro Isaa ninijai duwon, ");
INSERT INTO kby_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","kam laa tiyinju nga fuwadaa fuwunjun kiro. ");
INSERT INTO kby_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isaye malǝmba Attauraye-a Farisawa-aro: «Yim tustuyea kamba isangaduwuma halal ra haram?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gǝm kedǝnniya, Isa kamdǝa cǝdane isangajiye salamje leyeno. ");
INSERT INTO kby_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Daji tayiro: «Wundundo tadanju bi dalonju yim tustuyea barambo cukkuriya, sadǝman cuttuluwiwawodǝ?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Koro mana tiro kalaktuwuye tayiro katkero. ");
INSERT INTO kby_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isa am masǝna dioro dojanadǝ na darajaa kǝrejane napcai kirunniya, tayiro misal cǝdde: ");
INSERT INTO kby_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kam laa masǝna larusayero nia donjiya, bare na darajaadǝn nammǝmmi, dalilnjudǝ waneye sosamanǝm kam nia darajan konjǝna laaa dojǝna. ");
INSERT INTO kby_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Adǝgaia, sosamandodǝ nanǝmbo ise niro: “Cine nadǝa tiro kolgǝne!” cǝni. Daji nangunǝmbaro cinǝme lenǝme na daraja bawodǝlan nammǝmi. ");
INSERT INTO kby_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amma kam laa nia donjiya, lene na daraja bawolan namme. Daji sosamanǝmdǝ isiya, niro: “Sawani, are na darajaan namme!” cǝne fuwu jama dojǝna sammayen daraja fandǝmi. ");
INSERT INTO kby_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nonowo, wundu duwon kǝlanjua jajakcǝnamadǝ, tia awimaro ngojaiwawo. Koro kam duwon kǝlanjua awimaro ngojǝnnimadǝ, tia jajakcai.» ");
INSERT INTO kby_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Daji Isaye sosamanjudǝro: «Ngǝmǝri masǝna kausuye bi lesaye dabbarnǝmiya, bare sawawanǝm, bi yanǝmgǝnawa, bi kǝramiyanǝm, bi kǝmaskiyanǝm gaɍiwuwa donǝmmi. Adǝgai kidǝmba, tayi ye nia donjane njakkǝrǝmbi. ");
INSERT INTO kby_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amma ngǝmǝri masǝna dioye dabbarnǝmiya, ngudiya so, maskinna so, ngurdiyiya so, kambuwa soa done. ");
INSERT INTO kby_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Adǝgainin bargaaro wallǝmi, tayi rakcane niro njakkǝrǝmbiwawo nangaro. Yim cinowo jirewuyea Ala niro njǝkkǝrǝmbi.» ");
INSERT INTO kby_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Curo masǝnawuyen falnja adǝa fangenniya, Isaro: «Barganju kam nodo bargaa Alayen masǝna juwuidǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isaye tiro: «Kam laa masǝna ngǝmǝriye cǝdi cǝne am kada doyeno. ");
INSERT INTO kby_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sa masǝnayedǝ kidǝnniya, wolodinjua cunode am dojǝnadǝro: “Arowo, awiso kǝrma dabbargada!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amma tayi samma wajane fal fallen gawara koro ngǝskera. Burwoyedǝ tiro: “Lowonjǝkkǝna kanadi tai, kulo yuwukkǝna dolero lekke rukki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Fal ye: “Lowonjǝkkǝna kanadi tai, dalo bareye mewu yuwukkǝna lekke tayia rijammǝkki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Faldǝ ye: “Bǝɍinmaro larusa kidǝkko. Adǝmaro rangǝkke lekkiwawodǝ,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Daji wolodidǝ na kǝmanjuyero walde awo ani sammaa wulyeyeno. Adǝa fangenniya, kǝma fadoyedǝ gǝrgaje wolodinjudǝro: “Duwan luwe bǝlaye farsam farsam so, lai lai so gai, talaawa-a maskinna-a kambuwa-a ngurdiyiya-a sammaa mane kude!” ");
INSERT INTO kby_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Daji wolodidǝ walde tiro: “Kǝmani, awo wullǝmmadǝ tǝdǝna, amma koro yaye na gapcǝna mbeji,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Koro kǝmadǝye wolodinjuro: “Bǝlan luwe jawal kuran gananso gai amba yakke isa, fanni cappo tǝmbǝɍo! ");
INSERT INTO kby_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nayiro wulnjagakki, am burwon dokkǝnadǝye falnjama masǝnani juwuiwawo, diye!”» ");
INSERT INTO kby_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Am kada kadami Isaa casadduwuna kallo ledu cadi duwon, Isa suworde tayiro: ");
INSERT INTO kby_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Kam laa naniro ise bawanju-a yanju-a, kamunju-a yallanju-a, yeiyawanju-a kannawanju-a, har ronjudǝmaa wajǝnnia, rakce fuwuraniro waljiwawo. ");
INSERT INTO kby_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Koro wundu duwon kǝskanju karmoye ngoje wua sǝgannimadǝ, rakce fuwuraniro waljiwawo. ");
INSERT INTO kby_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wundundo gǝle soro sameye tando cǝraana duwon, dunonju koji ra kojiwaworo nojoro napce wuɍi ceji sammaa burwon komjǝnni tando badijidǝ? ");
INSERT INTO kby_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngai gǝnia, fǝrdudǝa gǝnaje rakce sorodǝa tumojǝgǝnniro walyenoa, am caruna samma rudu tiro gǝnajagane: ");
INSERT INTO kby_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ruiwo, kam adǝ soro tando badijǝna duwon, tumoduwu tiro katkero!” cani. ");
INSERT INTO kby_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Koro mai laa amnju dǝwu mewua duwon mai kamanju am dǝwu findiaro kǝriwu njǝkkado majia, burwon napce rakce tayia kǝriwun juwui ra juwuiwawodǝa curui, mare? ");
INSERT INTO kby_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tia jawuiro kiroa, lawalamanju kuruwunin duwon, naptu nanlewaye kororo am cukkunodi. ");
INSERT INTO kby_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Adǝgaima kam duwon kǝndanju ngaa wajǝnnidǝ rakce fuwuraniro waljiwawo. ");
INSERT INTO kby_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mandadǝ ngǝla, amma kǝlambo walyenoa, jiɍi fin gǝle cayenju gairo walji? ");
INSERT INTO kby_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Manda kǝlamdǝ kattiro bi muɍiro fiduwuro faidaa gǝni, tia deyan yirjai. Kam sǝmonjuamadǝ fanjo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yim laa akki mowomaso-a biwuma gadeso-a Isaa kǝrǝnduro nanjuro isai duwon, ");
INSERT INTO kby_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisawa-a malǝmba Attauraye-a adǝa kutturo carune kattenjan: «Kam adǝ biwumasoa kasacce, har tayi-a rokko masǝna cadi,» yera. ");
INSERT INTO kby_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Daji Isa tayiro misal adǝa cǝdde: ");
INSERT INTO kby_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Kamndo laa diminju miaa duwon, fal fatkeyenoa, filǝgar lǝgaridǝa karaalan kolje leje fal faccǝgǝnadǝa maje, har cuwandi, mare? ");
INSERT INTO kby_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cuwandiya, karwu kǝjiaro ngawanan ngoje ");
INSERT INTO kby_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","fannjuro waldi. Daji sawawanju-a kǝmaskiyanju-aa bowoje tayiro: “Wu-a nayi-a karwukǝjinde kallo fǝleniyo, dimini faccǝgǝnadǝa fandǝkkǝna nangaro,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nayiro wulnjagakki, adǝgaima samelan karwukǝji duwon kǝla biwuma fal tuwa cǝdǝnayen tǝdidǝ, kǝla jirewu filǝgar lǝgari jawallan caluwunnidǝmayen kojǝnaro tǝdi. ");
INSERT INTO kby_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Koro kamu laa cungonju mewua duwon, fal fatkeyenoa, fatǝla wasse fadodǝa fǝraje hangallayen kulasse, har cuwandi, mare? ");
INSERT INTO kby_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cuwandiya, koiyanju-a kǝmaskiyanju-aa bowoje tayiro: “Wu-a nayi-a karwukǝjinde kallo fǝleniyo, cungoni faccǝgǝnadǝa fandǝkkǝna nangaro,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nayiro wulnjagakki, adǝgaima biwuma fal tuwa cǝdiya, malaiyawa Alaye ye kǝji fanjai.» ");
INSERT INTO kby_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Koro Isa walde: «Kam laa tada yindia duwon, ");
INSERT INTO kby_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tǝngǝɍimadǝye tiro: “Bawa, nuwani warasaye se!” yenniya, bawadǝ tayiro kǝndanju dagaryeyeno. ");
INSERT INTO kby_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ngawo kawu ganayen tǝngǝɍimadǝ awonju sammaa capce lardu kuruwu laaro leje nadǝn nanjairo cǝde kǝndanju basaryeno. ");
INSERT INTO kby_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wuɍinju sammaa ceje cot kerǝnniya, kǝna jau lardudǝro ngaye lambimaro walyeno. ");
INSERT INTO kby_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Daji cije kam larduye laaro napciye aladeya neworo kulowanjuro tia kinodo. ");
INSERT INTO kby_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tada kǝskaye aladeya jawuidǝn curonjun njǝmbǝɍoro jauro mangarjǝna, amma wunduma tiro cinni. ");
INSERT INTO kby_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Daji kǝla naptunju adǝyen tuwore karwunjun: “Kai! Kidama bawaniye fi yaye kǝmbo juwe, har kulji, amma akko wua na adǝn kǝnaye sesi. ");
INSERT INTO kby_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kolle cikke bawaniyero lekke tiro: ‘Bawa, Mai Samema yero biwu yiddǝkkǝna, ni yero biwu njǝddǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kua wua tadanǝmlan bowoduro yittǝkkǝni. Marne, kasadde kidawunǝmbe falnja gairo wallǝkko!’ nǝkki.” ");
INSERT INTO kby_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Daji cije na bawanjuyero leyeno. Amma bawanjudǝ kuruwun tia kirunniya, jauro njunoje cǝgase daunjuro kamdiye lewa kǝrawoye tiro kiddo. ");
INSERT INTO kby_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Daji tadadǝye tiro: “Bawa, Mai Samema yero biwu yiddǝkkǝna, ni yero biwu njǝddǝkkǝna. Kua wua tadanǝmlan bowoduro yittǝkkǝni,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amma bawadǝye wolodiyanjuro: “Duwan lenowo, kalwu gari ngalwodǝa kudowo tiro luwunowo. Ngulondonjuro kulum yakkowo, sinju yero suno yakkowo. ");
INSERT INTO kby_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Koro kǝnna kaisuadǝa kudowo duwanowo. Bǝri ngǝmǝriye buiyo, bikke diyo, ");
INSERT INTO kby_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","dalilnjudǝ tadani adǝ nuna duwon roaro walyeno, faccǝgǝna duwon tia kiwandǝkko nangaro,” yeno. Daji karwunja jauro kǝjije ngǝmǝri badiyera. ");
INSERT INTO kby_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Sa adǝn tada kuramadǝ kulon. Fado karǝngenniya, ganga-a algaita-a nukcai fangeno. ");
INSERT INTO kby_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wolodi laaa bowoje awo wakkajǝnadǝa kiworo. ");
INSERT INTO kby_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tiye: “Kannanǝm diye walde iso. Bawanǝm tia kǝlewa salai cuwandǝna nangaro, kǝnna kaisuadǝa duwajǝna,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Daji tada kuramadǝ gǝrgaje fadodǝro ngawo wayeno. Bawanju cije culuwe tia lowodu ngǝskeno. ");
INSERT INTO kby_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amma tiye bawanjuro: “Akko kǝrwu kadaro kaɍea gairo ngǝnǝptǝkke niro kida njǝddǝkki, koro sawiso mananǝm ngokki yaye, ngaltema wuro kani tǝngǝɍima sime sawawani-a ngǝmǝri diyende. ");
INSERT INTO kby_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amma tadanǝm adǝ, arsiyinǝm sammaa jawarraro rǝmǝs cikkeje basarje walde kadinniyama, tiro kǝnna kaisuadǝa duwayeyem!” ");
INSERT INTO kby_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Daji bawadǝye tiro: “Tadani, ni sawiso nanin kǝrgam, koro awo kakke samma kaanǝm. ");
INSERT INTO kby_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngǝmǝri dio-a kǝji fanda-a ani andiro wajimsaana diye, dalilnjudǝ kannanǝm adǝ nuna duwon roaro walyeno, faccǝgǝna duwon tia kiwandiye nangaro,” yeno.» ");
INSERT INTO kby_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Koro Isa walde fuwurawadǝro: «Gaɍiwu laa wakkilnjua duwon, am nanjuro isane wakkilnjudǝa ngadarjane arsiyinju basarji yera. ");
INSERT INTO kby_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gaɍiwudǝ tia bowoje: “Awi kǝlanǝmlan wuljai fakkǝnadǝ? Balas sǝdde, kua adǝn fuwun ni wakkilni gǝni,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Daji wakkildǝye karwunjun: “Bani ngimba nanwakkilnin wua suttuluwunadǝ, awi gǝle dikki? Dunoni bareye bawo, koro lowo dio ye wuro nangua. ");
INSERT INTO kby_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","To, awo wua kidanin suttuluwiya dikke am fannjan samoyidǝa nokkǝna,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Daji am duwon banju ngimba kasuro jǝgai sammaa tilo tiloyen bowoje burwoyedǝro: “Ndawuro bani ngimba nia njǝgai?” cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tiye: “Kǝndawu jaitunne tono miaro,” yenniya, wakkildǝye tiro: “Kakkadunǝm kasuye ngone duwan namme fiwu ruwune.” ");
INSERT INTO kby_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Koro kam gadero: “Ni nda, ndawuro nia njǝgai?” yeno. “Algama buwu miaro,” yenniya, wakkildǝye: “Kakkadunǝm ngone fisku ruwune,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Banju ngimbadǝ wakkil jire bawoadǝa kǝla nanganju adǝyen kingoro, dalilnjudǝ am duniaye arsiyinjalan nanga kam fandoyen am nurrea kojana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nayiro wulnjagakki, arsiyi dunia adǝyelan sawawa fandowo. Sa dajǝnalan, nayia kǝndǝgairam sawisoyen ngǝlaro njamoyi. ");
INSERT INTO kby_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Kam awo ganan jireadǝ, ngǝwu yen jirea. Koro kam awo ganan jire bawoadǝ, ngǝwu yen jire bawoa. ");
INSERT INTO kby_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arsiyi dunia adǝyen jirenambu diwwaa, wundu gǝle arsiyi jireye sameyedǝa mukkondoro cakki? ");
INSERT INTO kby_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Koro lǝman kaando gǝnidǝlan jirenambu diwwaa, wundu gǝle nayiro nuwa kaando njadi? ");
INSERT INTO kby_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wolodi fima rakce wolodi kǝma yindiyero waljiwawo. Bi fal waje fal cǝrayi, bi fal bǝrsǝmje fal ruji. Nayi ye ranguwe wolodi Ala-a wuɍi-ayero walluwwawo.» ");
INSERT INTO kby_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisawa tayi wuɍi rawowu nangaro awo ani sammaa fangeranniya, Isaro rudu gǝnayeyera. ");
INSERT INTO kby_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isaye tayiro: «Nayi fuwu amben kǝlandoa jirewuro ngonuwwa, amma Ala awo karwundoye nojǝna. Awo fuwu amben ngǝlaro jajakcaidǝ na Alayen waada. ");
INSERT INTO kby_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Attaura-a kitawuwa nawiyaye-adǝ dasaana duwon har jaman Yahaya Kasalamaye kadio. Tǝn sa adǝn kawuɍi kǝji nodo bargaa Alaye ambo wuldiyi, koro wundu yaye tiro ngaworo mǝldi. ");
INSERT INTO kby_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adǝ yaye sǝkkal fal Attauraye baworo waldudǝro same-a cidi-a baworo walduma budu wo. ");
INSERT INTO kby_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wundu duwon kamunjua dǝpce gade niyajǝnadǝ kǝnjǝna cǝdǝna. Koro kam duwon kamu dǝpkadaa niyajǝnadǝ, ti ye kǝnjǝna cǝdǝna. ");
INSERT INTO kby_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Gaɍiwu laa mbeji, yim nguson kajǝmu kime so, kare linne ngalwo so luji ye, kullum tamtam-a daraja-alan napci ye. ");
INSERT INTO kby_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cinna fannjuyen ngudi laa ye bowada tiyinju samman tunoa mbeji, cunju Lajarus. ");
INSERT INTO kby_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kǝnanjuadǝro, kǝmbo tewur gaɍiwudǝyen cidiro fidǝnadǝa boro mangarji kǝrga, koro kǝriyama isane tunowanjudǝa mǝmǝlaccai. ");
INSERT INTO kby_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ngudidǝ bawoyenniya, malaiyawa tia ngojane gǝre Nawi Ibrahimbero kesado. Gaɍiwudǝ ye bawoje tia sittǝrayera. ");
INSERT INTO kby_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","«Curo kannuyen ajawu jauro cai duwon, kǝla sapkenniya, kuruwun Nawi Ibrahimba gǝrenjun Lajarussa kiro. ");
INSERT INTO kby_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Daji yilje: “Bawa Ibrahim, wua njunosǝne Lajarussa node ci ngulondonjuye ingiro lǝpcuwo tǝlammi samjo, curo kannu adǝyen jauro bone yakki, diye!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Amma Nawi Ibrahimbe tiro: “Tadani, tange sa dunialan jauro kǝji yamidǝ, Lajarus ye jauro kuttu caidǝ. Amma kǝrma ti na adǝn ronju bowada, ni ye curo boneyen kǝrgam. ");
INSERT INTO kby_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Koro ngawo adǝyeman kattenden bǝlaa kura kuruwu fetta, bare nanden wunduma cije nandoro lejǝnni, bi nando yen wunduma nandero isǝnni nangaro!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tiye: “Marne, Bawa, lowonjǝkkǝna, Lajarussa fado bawaniyero node, ");
INSERT INTO kby_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yaanani uwu mbeji. Tayia galajo, bare tayi ye na ajawuye adǝro isanniro!” ");
INSERT INTO kby_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Amma Nawi Ibrahimbe tiro: “Attaura-a kitawuwa nawiyaye-a nanjan mbeji. Kolle tayia fanja!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Koro tiye: “A'a, Bawa Ibrahim! Amma kam laa karmolan cije nanjaro leyenoa, tuwa cadi,” yenniya, ");
INSERT INTO kby_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nawi Ibrahimbe: “Attaura-a kitawuwa nawiyaye-a fanduro wayeraa, kam nuna roaro walje cijǝnama kasaccaiwawo.”» ");
INSERT INTO kby_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Daji Isaye fuwurawanjuro: «Awowa casakke am taljane biwu cadidǝ kadu baworo isai, amma kuttunju kam tiyen isaidǝ! ");
INSERT INTO kby_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kamdǝye daunjuro kau neduram mafǝndi lujagane bǝrǝmbo gǝpcaanama tiro ngalwo, tadawa sanana aniye falnjaa cakke talje biwu cǝdidǝro. ");
INSERT INTO kby_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangal gǝnanowo! Kǝraminǝm biwu niro njǝddia, tiro wulgǝne. Tǝmjia, tia gawurne. ");
INSERT INTO kby_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Curo kawu fallen tulurro biwu ngiddo yaye, tulurro walde ise niro: “Tǝmmǝkkǝna,” cǝnia, tia gawurne.» ");
INSERT INTO kby_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Daji kǝngayambadǝye Kǝmadǝro: «Kambǝrsendedǝa yirgai!» yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kǝmaye tayiro: «Ca kambǝrsendo mbejia, kasuni mutarre gai tǝngǝɍima yaye, ranguwe kǝska kura adǝro: “Mǝktǝne, curo bǝrǝmben koktǝne!” wulgǝwiya, manando jǝgai. ");
INSERT INTO kby_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Kamndo laa kaɍeanju kulo baredu bi lǝman neworo leje karaan walde isiya, tiro: “Duwan are namme bǝri bui!” cǝni wa? A'a! ");
INSERT INTO kby_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tiro: “Bǝri desǝgǝne, kajǝmunǝm kadawu bawoa yakkǝmiya, are kǝmboni kude fisǝgǝne. Bukke yakkiya duwon, ni ye bui yai,” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Koro kaɍeanju awo tiro wuljǝgǝnadǝa cǝdǝna nangaro, tia wuseji wa? A'a! ");
INSERT INTO kby_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","To, nayi ye awo Ala wulnjaana sammaa diwe ceriya, adǝgai wullowo: “Andi kaɍeawa faida bawoa, awo wajimsaana bas kidiye!”» ");
INSERT INTO kby_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Isa bǝrni Jerujalembero ledu cǝdi duwon, kaɍangi katte cidi Samariyaye-a Galileye-aa giya. ");
INSERT INTO kby_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bǝladeya laa karǝngenniya, kongwa barasua mewu tia kapkeyera. Kuruwun dajane ");
INSERT INTO kby_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kowo sapcane tiro: «Sayinna Isa, marne andia njunosane!» yera. ");
INSERT INTO kby_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Isa tayia kirunniya, tayiro: «Lenowo, ɍimannadǝro fǝledǝgǝnowo!» yeno. Lejai ngai duwon, ngajane tayirro walyera. ");
INSERT INTO kby_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Falnja ngajǝnaro asuyenniya, kowo sapce Alaa cungoriaro walde ");
INSERT INTO kby_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","fuwu Isayen tungurumje ngumnju cidin gǝnaje tia wuseyeno. Tidǝ kam Samariyaye. ");
INSERT INTO kby_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Daji Isaye: «Tayi mewu samma ngajana, mare? To, nda tayi lǝgardǝ? ");
INSERT INTO kby_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kusotto adǝro kajia, wundunjama walde Alaa wuseji bawo wa?» ");
INSERT INTO kby_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Daji kamdǝro: «Cine lene! Kambǝrsenǝm nangaro njǝkkawo fandǝmma,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yim laa Farisawaso Isaro kǝla yimbi nodo bargaa Alaye duniaro isiyen keworǝnniya, tayiro: «Nodo bargaa Alaye asuduramsolan gǝni isi, ");
INSERT INTO kby_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","koro wundumaye: “Akko ti!” bi “Towo ti!” wuljiwawo. Nonowo, nodo bargaa Alayedǝ dawundoman kǝrga,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Daji Isaye fuwurawadǝro: «Sa ise kawu fal yayero Tada Kambedǝa kuroro jauro raawwa, amma tia ruwwawo. ");
INSERT INTO kby_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Amsoye nayiro: “Akkonju!” bi “Towonju!” caniya, bare lenuwe tayia gawwi. ");
INSERT INTO kby_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jiɍi same ci fallan har todǝro cuwalde wassidǝ gai, yim kǝndenjuyedǝn Tada Kambedǝ ye ngai. ");
INSERT INTO kby_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amma Ala kadarjǝna, sai jauro bone cane am jaman adǝyedǝ tia wajaiya duwon. ");
INSERT INTO kby_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Jaman Tada Kambedǝye alamanju jaman Nawi Nuhuye gai. ");
INSERT INTO kby_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sadǝn amso jawui ye, casai ye, larusa so, niya so cadi ye ngai duwon, har yim Nawi Nuhu maaradǝro ngaye ingi tufanaye ise tayi sammaa siyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Koro alamanjudǝ jaman Nawi Lutuye gai. Amso jawui ye, casai ye, kasuwun luwa so, lado so cadi ye, kulo barejai, fado cadandi ye kasarga. ");
INSERT INTO kby_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Daji yim Nawi Lutu bǝrni Sodomben culuwunadǝn, dǝlawu kannuye-a kauwa kannuaye-a samen cudure tayi sammaa siyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yim duwon Tada Kambedǝ fǝlediyidǝn adǝgaima wakkaji. ");
INSERT INTO kby_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Yim adǝn kam duwon kǝla soronjuyen karenju ye curo soroyen dǝganadǝ bare jǝpce kare ngoje leji cǝne curo sorodǝyero ngaanni! Koro kam kulolan dǝganadǝ ye bare fadoro waldǝnni! ");
INSERT INTO kby_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tangowo kamu Lutuyea! ");
INSERT INTO kby_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wundu duwon ronju ɍiwo cǝraanamadǝ ronjudǝa cuwatki, amma wundu duwon ronju cuwatkǝnamadǝ ronjudǝa cǝɍiwi. ");
INSERT INTO kby_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nayiro wulnjagakki, yim adǝn bune am yindi dǝgǝl tilon bowada duwon, fal ngojane fal koljai. ");
INSERT INTO kby_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Koro kamu yindi ye kallo nedu cadi duwon, fal ngojane fal koljai. ");
INSERT INTO kby_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kongwa yindi ye kulon duwon, fal ngojane fal koljai.» ");
INSERT INTO kby_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Daji fuwurawanjuye tiro: «Kǝma, ndaran awo adǝ wakkaji?» cane tia keworǝnniya, tayiro: «Na ɍiwa dǝganalan kowuwaso ye captai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Daji Isa fuwurawanjuro kǝla sawiso tǝma koljannilan moduwa cadoyen misal adǝa kiddo. ");
INSERT INTO kby_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tayiro: «Bǝla laan alkali laa Ala yea rijǝnni, kam yea nangujǝnni mbeji. ");
INSERT INTO kby_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Koro curo bǝla adǝyen kamu kwa faccǝgǝnaa laa ye mbeji. Kullum na alkalidǝyero ise tia lowoje: “Wuro shara kǝla kǝladoniyen sǝdde!” cǝni. ");
INSERT INTO kby_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tussǝna sonju cǝmowonni, amma ngawo adǝyen alkalidǝ karwunjun: “Ala yea rikkǝni, kam yea nangunǝkkǝni yaye, ");
INSERT INTO kby_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kamu adǝ kullum wua suwolsǝna nangaro, tiro shara yiddǝkki, bare kǝnde ngǝwunjudǝn karwuni tǝgǝmbo jadǝnniro!” yeno.» ");
INSERT INTO kby_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Daji Kǝmadǝye: «Awo alkali jirenambuma adǝ wuljǝnadǝa fannowo! ");
INSERT INTO kby_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","To, Ala nda, am kǝrejǝna bune-a kausu-aro tiro sonja caddidǝro shara kǝla kǝladowanjayen cǝddiwawo wa? Ra, kawu kadaro tussǝna duwon, tayia banajiyi? ");
INSERT INTO kby_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nayiro wulnjagakki, duwaman sharanja kamji. Adǝ yaye sa Tada Kambedǝ duniaro walde isiya, koro yaye kambǝrse dunialan cuwandi wa?» ");
INSERT INTO kby_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Daji Isa am tayi kǝlanjaa jirewuro ngojane am gadea rujanaro misal adǝa kiddo: ");
INSERT INTO kby_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Am yindi moduwa dioro Fado Alayero lejane kasargawo. Kam faldǝ Farisa, faldǝ ye akki mowoma. ");
INSERT INTO kby_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisadǝ cije daje karwunjun moduwa cǝde: “Ala, wu am gade-a gade nangaro wusenjǝkkǝna. Wu barwu gǝni, diwi dioma gǝni, kǝnjǝnama gǝni, bi akki mowoma adǝ gai gǝni. ");
INSERT INTO kby_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wudǝ curo mawuyen yindiro asem dikki, koro awo fandǝkkǝna ngan fal curo mewuyen sadaaro yikki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Amma ti akki mowomadǝ, ngawolan daada kǝlama sapcǝnnin nganjinju bakciaro: “Ala, wu biwuma, wua njunosǝne!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nayiro wulnjagakki, Farisadǝa gǝni, akki mowomadǝa Ala jiremaro ngojo. Nonowo, wundu duwon kǝlanjua jajakcǝnamadǝ, tia awimaro ngojaiwawo. Koro kam duwon kǝlanjua awimaro ngojǝnnimadǝ, tia jajakcai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Am laa Isa yallanja sananaa mukkon lejoro nanjuro cawudi duwon, fuwurawadǝ adǝa kerunniya, amdǝa wusayera. ");
INSERT INTO kby_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amma Isa yalla sananadǝa bowoje fuwurawanjuro: «Yalladǝa kollowo naniro isa, bare tayiro dapkǝwwi! Nodo bargaa Alayedǝ am tayi gaiye nuwanja, diye! ");
INSERT INTO kby_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jiremaro nayiro wulnjagakki, wundu duwon tadaana gai nodo bargaa Alayedǝa kasaccǝnnidǝ tǝmmaro ngayiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kam kura laaye Isaro: «Malǝm ngǝlama, awi dikke ro sawisoye fandǝkki?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isaye tiro: «Awiro wua ngǝlaman bowosǝmi? Ala gǝnia, wunduma ngǝla bawo. ");
INSERT INTO kby_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wadawadǝa nonǝmma: Bare kǝnjǝna dimmi, bare ro kambe tuluwummi, bare nambarwu dimmi, bare shedakambu dimmi, bawanǝm-a yanǝm-aro daraja ye!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kamdǝye: «Tǝn gananilan wada ani sammaa gakkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isa adǝa fangenniya, tiro: «Koro yaye awo fal nia maunjǝna. Kǝndanǝm sammaa lade talaawaro dagargǝne, arsiyi samelan fandǝmi. Daji are wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kamdǝ adǝa fangenniya, ti jauro gaɍiwu nangaro karwukutta tia tai daje kida. ");
INSERT INTO kby_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Isa karwukuttanjudǝa kirunniya, tiye: «Gaɍiwuye nodo bargaa Alayero ngawonju jauro jau, diye! ");
INSERT INTO kby_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gaɍiwuye nodo bargaa Alayero ngawonjudǝro kaɍimoye cuwuɍi ɍiwurayen kodunjuma budu wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Am adǝa fanjanadǝye tiro: «Assha! Adǝgaia, wundu gǝle njǝkkawo cuwandi?» yera. ");
INSERT INTO kby_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isaye: «Awo kambo yojiwawodǝ Alaro yoji!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Daji Biturusse tiro: «Akkonde awindeso kolliye nia njǝgaiyena,» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isaye: «Jiremaro nayiro wulnjagakki, wunduma nodo bargaa Alaye nangaro fado, bi kamu, bi yaana, bi bawa, bi ya, bi yalla koljǝnadǝ, ");
INSERT INTO kby_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dunia adǝman awo koljǝnadǝmaa ngǝwuro kojǝna cuwandiwawodǝma bawo. Koro leira wakkajiya, ro sawisoye ye cuwandi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isa mewun yindindǝa sǝgǝriro cuttuluwe tayiro: «Fannowo, Jerujalembo leniye, koro awo nawiyaso kǝla Tada Kambedǝyen ruwujana samma wakkaji. ");
INSERT INTO kby_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Am tia cadane mukko kǝrdiyayero casakke, tayi ye tia rujane rarajane tiro lallaɍi tǝwajagane ");
INSERT INTO kby_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kirwolan jajarjane roro ceyesi. Koro kawu yakkua roaro walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amma fuwurawadǝ awima asujanni. Maananju tayiro gǝraaada nangaro, awo wuljǝnadǝa nojanni. ");
INSERT INTO kby_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Isa bǝla Jerikoye karǝngenniya, kambu laa ci jawallen napkada lowo cǝdi mbeji. ");
INSERT INTO kby_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jama kojairo fangenniya, awi wakkajoro kiworo. ");
INSERT INTO kby_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tiro: «Isa kam Najaratte kodu cǝdi,» yera. ");
INSERT INTO kby_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Daji kowo sapce: «Isa Tada Mai Daudaye, wua njunosǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Am fuwu gǝrjana lejaidǝ tiro jakkade mǝdǝk napco yera, amma cayea kojǝnaro kowo sapce: «Tada Mai Daudaye, wua njunosǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Daji Isa daje tia nanjuro cawudo yeno. Kewudǝnniya, tiro: ");
INSERT INTO kby_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Awi niro njǝddǝkkiya, raam?» cǝne tia kiworo. Tiye: «Kǝma, sim fandǝkkiya, raakko!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Daji Isaye tiro: «Sim fande! Kambǝrsenǝm nangaro nanlewa fandǝmma,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sadǝman sim cuwande Alaa cungoriaro Isaa giya. Jama samma adǝa kerunniya, tayi ye Alaa jajaktu badiyera. ");
INSERT INTO kby_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isa bǝla Jerikoyero ngaye reje kodu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bǝladǝn kam laa mbeji, cunju Jakaya. Ti kura akki mowomasoye ye, jauro gaɍiwu ye. ");
INSERT INTO kby_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wundu ti Isa wo cǝne tia kuroro maji, amma kǝla jama kadayen rangǝme kuroro tiro katkero, ti kori nangaro. ");
INSERT INTO kby_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Daji Isaa kuroro cǝgase fuwuro leje na Isa kojidǝyen kǝla tarmu laayero tatkeno. ");
INSERT INTO kby_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Isa nadǝro kadinniya, kǝla sapce tiro: «Jakaya, duwan jǝmme, ku sai fannǝmlan jǝmmǝkkiya!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakaya ganje jǝpce karwu kǝjiaro tia kapciye sosayeno. ");
INSERT INTO kby_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jamadǝ adǝa kerunniya, karwunja waje: «Fado biwumayen jǝpcǝna!» cani. ");
INSERT INTO kby_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Amma Jakaya cije daje Kǝmadǝro: «Kǝma, reda kǝndaniyedǝa talaawaro yikki. Koro kam laayen wuɍi cukkowonaro mowokkǝnaa, kawak dewu tiro kalakkǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Daji Isaye: «Ku fado adǝn njǝkkawo jǝpcǝna, dalilnjudǝ kam adǝ ye kaduwu Nawi Ibrahimbe nangaro. ");
INSERT INTO kby_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nonowo, Tada Kambedǝ am faccaanaa maje njǝkkaworo kadio,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jamadǝ awo ania kǝrǝnjai ngai duwon, Isa tayiro misal wulduwu badiyeno, dalilnjudǝ Jerujalemba karǝnjǝna ye, koro tayidǝ nodo bargaa Alaye sadǝman duniaro jǝpciyiro tǝmajana ye nangaro. ");
INSERT INTO kby_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tayiro: «Maina laa lardu kuruwu laaro leje kǝrmai lardunjuye cuwande walde isi cǝne sapturo ciyeno. ");
INSERT INTO kby_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Daji wolodiyanju mewu bowoje wundunja yayero mina fal fal ce tayiro: “Kawu waldǝkke isǝkkiro tilan sawur dewo,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amma am lardudǝye tia wajane, har ngawonjun am canode: “Kam adǝ maindero waljiro rayiyende!” yera. ");
INSERT INTO kby_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Maije kadinniya, wada ce wolodiyanju tayiro wuɍi cinadǝa bowoja isa awiso sawurlan cawandoro nojo yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Burwoyedǝ ise tiro: “Barganǝmmin, akko mina simmadǝn mina gade mewu fandǝkko,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Maiye tiro: “Wuse, wolodi ngǝlama! Awo ganan aman dimma nangaro, nia lawan bǝla mewuyero galanjǝkki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yindiyedǝ ye ise tiro: “Barganǝmmin, mina simmadǝn gade uwu fandǝkko,” yenniya, ");
INSERT INTO kby_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Maiye: “Nia lawan bǝla uwuyero galanjǝkki,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Daji wolodi gade ye ise tiro: “Barganǝmmin, akko minanǝm. Tia kesolan kǝrnǝkke dam gǝnayekko. ");
INSERT INTO kby_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ni kam jau nangaro, ringekko. Awo gǝnanǝmmidǝa ngonǝmi, awo nadǝmmidǝ yea kalanǝmi,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maiye tiro: “Mana cinǝmben shara njǝddǝkki, wolodi kǝlado! Wu kam jau, awo gǝnakkǝni ngokki, koro awo nadǝkkǝni kalanǝkkiro nonǝmma, gǝna? ");
INSERT INTO kby_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","To, awiro gǝle wuɍinidǝa bankilan gǝnanǝmmidǝ? Ca ngai dimmaa, waldunidǝn wuɍini riwanjua mowokkǝna,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Daji maiye am nadǝn daadadǝro: “Minadǝa nanjun mowowo, kam nanjun mewuadǝro yowo!” yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tayiye: “A! Barganǝmmin, nanjun mewu mbeji, diye!” yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Maiye: “Nayiro wulnjagakki, wundu duwon nanjun awoamadǝ, tiro casargai, amma kam nanjun bawomadǝ, awo cǝdanadǝmaa tilan camoyi. ");
INSERT INTO kby_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kǝladowani mainjaro wallǝkkiro wajanadǝa kudowo fuwunin roro yejowo!” yeno.» ");
INSERT INTO kby_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngawo Isa adǝa wuljǝnayen, koro walde kǝla fuwunna Jerujalembo ledu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Gǝre bǝla Baitfajeye-a Baitaniye-a na Kau Jaitunne canidǝa karǝngeranniya, Isa fuwurawanjuye yindi cunode ");
INSERT INTO kby_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tayiro: «Bǝla fuwundoyedǝro lenowo! Ngawuwiyama, kutta koroye wunduma tiro ngalte juwanni tuwada nagǝwi. Fǝrangowo kudowo! ");
INSERT INTO kby_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kam laaye: “Awiro fǝranguwi?” cǝne nayia njaworia, tiro: “Kǝmadǝ tilan mǝradunjua,” wulgǝnowo!» ");
INSERT INTO kby_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Daji am tayia cunodǝnadǝ lejane Isa tayiro wuljǝgǝnadǝ gai nayeyera. ");
INSERT INTO kby_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kuttadǝa fǝrakcai duwon, kǝmanjusoye tayiro: «Awiro fǝranguwi?» yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tayiye: «Kǝmadǝ tilan mǝradunjua,» yera. ");
INSERT INTO kby_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Daji kuttadǝa na Isayero cawude kalwuwanja kǝladǝro ferjagane tia ngoyeyera. ");
INSERT INTO kby_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Leji adǝgai duwon, am kalwuwanja kǝla jawallen feryera. ");
INSERT INTO kby_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na jawal Kau Jaitunnedǝn jǝpcidǝa karǝngenniya, fuwurawanju samma karwu kǝjiaro kowo sapcane kǝla awo ajabba ajabba carunayen Alaa njungoro badiyera. ");
INSERT INTO kby_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tayiye: «Bargaa mai cu Kǝmandeyen isimadǝ! Kǝrma duwon katte Ala-a amnju-ayen nanlewa kǝrga, Mai Samemaro daraja tio!» cani. ");
INSERT INTO kby_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Curo jamadǝyen Farisawa laaye Isaro: «Sayinna, fuwurawanǝmbo wulgǝne gǝm cado!» yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","tiye: «Nayiro wulnjagakki, nǝmgeraa, dongur kauyesoma burwu casakki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Isa Jerujalemba del karǝnje bǝrnidǝa kirunniya, tiro kikkiro. ");
INSERT INTO kby_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bǝrnidǝro: «Kai! Ca ku awo nanlewa njukkudidǝa nonǝmmaa, amma kǝrma nodu adǝ niro gǝraaadaro waljǝna. ");
INSERT INTO kby_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Adǝ nangaro yim laa ise kǝladowanǝm dirinjane kǝlnjane kanji fi yayen kikiminjagane garunǝmbo cidi capcagane tiyen kojane ");
INSERT INTO kby_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ni-a am curonǝmlan dasaana-a sammaa tǝgǝmbo sinjagai, har kau falma kǝla kamanjuyen gǝnaada baworo cadi, dalilnjudǝ sa Kǝmande amnjua cǝkkayiye isǝnaro nonǝmmi nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Daji Isa balballa Fado Alayero kǝrgaanniya, kare ladomasoa dudu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tayiro: «Kitawulan ruwuwada: “Fannidǝ fado moduwaye!”, amma nayidǝ tia jongo gǝndewuyero kalakkew!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yim nguson Isa Fado Alayen jamaa alamdu cǝdi duwon, wurawa ɍimannaye-a malǝmba Attauraye-a amwurawa jamaye-a tia njejoro majai, ");
INSERT INTO kby_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","amma jawal cawandǝnni, dalilnjudǝ jama samma hangalnja nanjun tia fanjana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yim laa Isa Fado Alayen jamaa alamje tayiro kawuɍi kǝji Alayedǝa wuljiyi duwon, wurawa ɍimannaye-a malǝmba Attauraye-a amwurawa-a nanjuro isane ");
INSERT INTO kby_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tiro: «Andiro wulsagane, kǝnduwo filan awo ania dimi? Wundu niro kǝnduwo adǝa njo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isaye tayiro: «Wu ye nayiro koro fal njaddǝkki, wulsǝgǝnowo! ");
INSERT INTO kby_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kasala Yahaya jamaro cǝddǝnadǝ, sameyen kadio ra kamben?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Daji kattenjan sawardane: «“Sameyen” wulliyea, andiro: “To, awiro gǝle tia kasadduwwidǝ?” cǝne sawori. ");
INSERT INTO kby_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amma “Kamben” wulliyea, jama samma andiro kau gǝgǝmsagane seyesi, dalilnjudǝ Yahayaa nawiro ngojana nangaro.» ");
INSERT INTO kby_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Daji Isaro ndaran kadiomaro nojanni yera. ");
INSERT INTO kby_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Isaye tayiro: «Wu ye kǝnduwo filan awo ania dikkidǝa wulnjagakkiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Daji Isa misal adǝa jamaro manaduwu badiyeno. Tayiro: «Kam laa jǝrwu inabbe cǝde jǝrwuwu laaro agǝrijiye bǝlawuro kawu kadayero sapkada. ");
INSERT INTO kby_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sa fǝrdoye kidǝnniya, nuwanju cuwandoro kaɍeanju laaa na jǝrwuwudǝyero kinodo. Amma jǝrwuwudǝ tia cadane bakcane mukko dea duyera. ");
INSERT INTO kby_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Koro walde kaɍea gade kinodo. Ti yea cadane bakcane basarjane mukko dea duyera. ");
INSERT INTO kby_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Koro walde kaɍea yakkuye kinodǝnniya, caye gai ti yea lorujane duyera. ");
INSERT INTO kby_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Daji kǝma jǝrwudǝye: “Awi gǝle dikki? Tadani raakkǝnadǝmaa nodǝkki. Waneye tiro daraja cadi,” yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amma jǝrwuwudǝ tadanjudǝa kerunniya, kattenjan: “Adǝma warasamadǝ wo! Tia yejiyo, warasadǝ kaandero waljo!” yera. ");
INSERT INTO kby_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Daji tia cadane jǝrwudǝlan cattuluwe roro keyeso. «To, kǝma jǝrwuyedǝ awi cǝdi? ");
INSERT INTO kby_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ise jǝrwuwu ania roro ceje am gadero jǝrwunjudǝa ci,» yeno. Jamadǝ adǝa fangeranniya, tayiye: «Suwana! Bare ngairo waljǝnni!» ");
INSERT INTO kby_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Amma Isa tayia ninije: «To, awi maana awo kitawulan ruwuwada adǝye? «“Kau duwon fado tandomaso wajanamadǝ, tima kau tandoye sammaro faidaaro waljǝnadǝ wo.” ");
INSERT INTO kby_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Nonowo, kam kǝla kau adǝyero cukkurǝnamadǝ nanamdi, koro kaudǝ kambo cukkuriya, kǝluwuro kalakci,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Malǝmba Attauraye-a wurawa ɍimannaye-a jawal tia taye majai duwon, jamadǝa riyera, dalilnjudǝ kǝlanjaman misaldǝa kidoro asujana nangaro. ");
INSERT INTO kby_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Daji wurawa adinwuye ani Isaa mǝlastu badijane curo mananjuyen cada mukko gomnayero casakkoro am laa jirewu gairo kǝlanja kalakcanaa nanjuro kenodo. ");
INSERT INTO kby_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tiro: «Sayinna, mana wuldunǝm-a jamaa alamdunǝm-a samma jirero noniyena, koro wundumaa gayirnǝmbawo ye, jawal Alaye kalkallo yikkǝrami ye. ");
INSERT INTO kby_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","To, Kaisarro akki njodǝ, andiro halal ra haram?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amma Isa niadiwinjadǝa asuje tayiro: ");
INSERT INTO kby_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Wuro dinariyus fǝlesǝgǝnowo rukke! Cu-a kǝla-a wunduye tilan dasaa?» cǝne tayia kiworǝnniya, tiro «Kaisarre,» yera. ");
INSERT INTO kby_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Isaye tayiro: «Daji awo Kaisarredǝa Kaisarro yowo, koro awo Alayedǝa Alaro yowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Adǝgaima rakcane fuwu jamayen Isaa curo mananjuyen cadanni. Jaawunjudǝa jauro ajapcane mǝdǝk napkera. ");
INSERT INTO kby_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusiya laa, tayi cinowo duniayea kasaccannidǝ, na Isayero isane ");
INSERT INTO kby_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","tiro koro cadde: «Sayinna, Nawi Musaye: “Kam laa yanjugǝna tada bawoa bawoje kamu koljia, kamu yanjugǝna faccǝgǝnayedǝa niyajo yanjugǝnaro kaduwu majuwo!” ruwujǝna. ");
INSERT INTO kby_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Akko yaana tulur mbeji. Burwoyedǝ kamu ngoje tada cuwandǝnnin bawoyeno. ");
INSERT INTO kby_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yindiyedǝ ye kamudǝa niyayenniya, ngai. ");
INSERT INTO kby_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yakkuyedǝ ye ngai. Adǝgaima tayi tulur samma tada cawandǝnnin bawoyera. ");
INSERT INTO kby_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ngawo adǝyen kamudǝ ye bawoyeno. ");
INSERT INTO kby_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To, tayi tulurso tia camowonadǝ, cinowo duniayen kamu wundunjayero walji?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isaye tayiro: «Am jaman adǝye larusa so, niya so cadi, ");
INSERT INTO kby_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","amma am duwon leira-a karmolan cidu-aa cawandǝnadǝ larusa so, niya so cadiwawo. ");
INSERT INTO kby_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Karmolan cidudǝn nuwanjaa nangaro, tayidǝ tadawa Alaye, malaiyawa gai rakcane gadero sanuiwawo. ");
INSERT INTO kby_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Koro Nawi Musa kǝlanjuma kitawulan na kannu dawu coccoɍi cambiyedǝn am bawojana cijaidǝa tabbaccǝgǝna. Tidǝ Kǝmandea Ala Ibrahimbe-a Ala Isakuye-a Ala Yakubaye-alan bowoyeno. ");
INSERT INTO kby_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kǝmandedǝ Ala am sanunaye gǝni, am roaye, nanjun tayi samma ronjaa nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Daji malǝmba Attauraye laaye tiro: «Sayinna, jaawunǝmdǝ kalkal!» yera, ");
INSERT INTO kby_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Adǝgaima wunduma cinju mudu kaje tiro koro gade cǝddǝnni. ");
INSERT INTO kby_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Daji Isaye tayiro: «Ndayilan Almasiwudǝ Tada Mai Daudaye canidǝ? ");
INSERT INTO kby_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mai Dauda kǝlanjuma kitawu Jawurayelan manaje: “Kǝmandeye Kǝmaniro: ‘Namme kǝmborammilan duwon, ");
INSERT INTO kby_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kǝladowanǝmba cidiya sinǝmbero yakkǝkko!’ cǝnna.” ");
INSERT INTO kby_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mai Daudaye tia Kǝmalan bowojǝnadǝ, ndayilan gǝle Almasiwudǝ tadanjuro walji?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jama samma tia kǝrǝnjai duwon, Isaye fuwurawanjuro: ");
INSERT INTO kby_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Malǝmba Attaurayero hangal gǝnanowo! Kalwu kuruwua dadadu caraana, koro kasuwulan lewa darajaa-a dandallan bi masǝna kuralan na darajaa-a jaumaro caraana. ");
INSERT INTO kby_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kamu kwa faccǝgǝnaasoye kǝndanja sammaa jawui ye, halnja gǝraduro fuwu jamayen moduwa kuruwuro gǝrjai ye. Am aniye ajawunja leiran jauro kura!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Isa kǝla sapkenniya, arsiyiwu laa curo sanduwu sadaa fidarambedǝro wuɍi fijagai kiro. ");
INSERT INTO kby_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Koro kamu ngudi kwa faccǝgǝnaa laa ye gursu kime yindi fijiyi kiro. ");
INSERT INTO kby_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Daji Isaye: «Jiremaro nayiro wulnjagakki, kamu ngudi kwa faccǝgǝnaa adǝ tayi sammaa kojǝnaro fijǝgǝna. ");
INSERT INTO kby_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tayi samma arsiyinjalan ngojane fiyeyera, amma ti ngudi duwon awo ronju ɍiwoye ngaa fiyeyeno,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fuwurawanju laaye kǝla jiɍi Fado Alayedǝa kauwanju shawa shawa-a sadaa Alaro sadakcaana-alan janejanadǝyen manajai duwon, Isaye: ");
INSERT INTO kby_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Awo ruwi anidǝ, sanja cǝde kau ani sammaa wurjane fijai, har tiloma kǝla kamanjuyen gapciwaworo walji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tayiye: «Sayinna, sawi awo ani wakkajai? Koro awo ani sammaye sanja cǝdiya, awi alama duwon ambo fǝlediyidǝ wo?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isaye tayiro: «Hangal gǝnanowo, bare wunduma nayia njawatkǝnni! Am ngǝwu cunilan isane: “Wuma ti wo!” koro “Sadǝ cǝdǝna!” cani. Bare tayia gawwi! ");
INSERT INTO kby_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kǝriwu so, hangalsango soye lawar fannuwiya, bare yaanuwwi! Sai awo ani burwon wakkajaiya duwon, amma sa njerorambe kua yaye cǝdǝnni.» ");
INSERT INTO kby_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Koro Isa walde tayiro: «Lardu-a lardu gade-a lawaladai, koro kǝrmai-a kǝrmai gade-a ye kattenjan kǝriwu gǝrjai. ");
INSERT INTO kby_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cidi ye na gadegaden jauro loloji, wowa-a kǝna-a ye na naro ngasayi. Koro awowa riduye-a alama ajabba ajabba-a ye samelan fǝledai. ");
INSERT INTO kby_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amma kawu awo ani samma wakkajaidǝro, nayia njadane basarnjane dandalnin sǝrǝnnjagai, kosoro njasakki, koro cuni nangaro fuwu mai so, gomna so yero njasadi. ");
INSERT INTO kby_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngainin dama shedaro walduye fanduwi. ");
INSERT INTO kby_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Adǝ nangaro kawudǝro nia ngonowo, bare kǝla awo kǝlando moworo wulluwiyen karwungai diwwi, ");
INSERT INTO kby_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","dalilnjudǝ wuma awo kalkal wulluwidǝa njadǝkki, koro curo waduwundoyen wundunjama rakce nayia kambiwunjaiwawo. ");
INSERT INTO kby_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bawando-a yando-a so, yaanawando so, kǝramiyando so, sawawando so nayia njadane laandoa roro ceyesi. ");
INSERT INTO kby_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cuni nangaro am samma nayia wanjai, ");
INSERT INTO kby_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","amma kanduɍi kǝlandoyema facciyiwawo. ");
INSERT INTO kby_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nedduwiya, njǝkkawo fanduwi. ");
INSERT INTO kby_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Sa kǝwuwa kǝriwuye isane bǝrni Jerujalembea dirijane kǝljana ruwiya, wurdunju karǝnjǝnaro nonowo. ");
INSERT INTO kby_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sa adǝn am lardu Yahudiyayen dasaanadǝ cija kauro cagaso leja! Am curo bǝrnidǝyen dasaanadǝ ye caluwo, koro am karaalan dasaanadǝ ye bare bǝrnidǝro ngasaanni! ");
INSERT INTO kby_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dalilnjudǝ adǝma sa ajawu gǝnaduwuyedǝ wo, ngainin awo kitawulan ruwuwada samma wakkajai. ");
INSERT INTO kby_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yim anin kamu curoa so, nganji cǝmbia sodǝ, kuttunja! Masiwa kura lardudǝro ngayi, Ala jama adǝro gǝrgajǝgǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Laanjaa kashagarsolan ceyesi, laanja yea cadane kaɍea gai larduwa gade sammaro caadi. Kǝrdiyadǝ Jerujalemba guguwaccai, har sa Ala tayiro kadarjǝgǝnadǝ cǝdiya. ");
INSERT INTO kby_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Samelan alamaso kǝngal-a kumbal-a sillowuwa-alan tarui, dunia yelan nuktu tekuye-a cambaldunju-a casakke jama larduwaye hangalnja ciji. ");
INSERT INTO kby_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kǝla awo dunialan wakkajiyen ambe karwunja kamde, har muwajai, kǝnduwowa sameye jauro lolojai nangaro. ");
INSERT INTO kby_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Daji Tada Kambedǝ kǝnduwoa-a jauro darajaa-a curo fofouyen isi carui. ");
INSERT INTO kby_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Awo ani wakkadu badijaiya, danowo kǝlando sangowo, sa nayia meruduye karǝnjǝna nangaro.» ");
INSERT INTO kby_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Daji Isa tayiro misal adǝa cǝdde: «Akko ya tarmuye-a kǝska gadeso samma-a ruiwo! ");
INSERT INTO kby_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sa kaluwanja ɍidu badijana ruwiya, nayi kǝlando nangǝɍi karǝnjǝnaro nonuwwa. ");
INSERT INTO kby_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngaima awo ani wakkajai ruwiya, nodo bargaa Alaye karǝnjǝnaro nonowo! ");
INSERT INTO kby_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Jiremaro nayiro wulnjagakki, am jaman adǝye sanuiwawo, sai awo ani samma wakkajaiya duwon. ");
INSERT INTO kby_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Same-a cidi-a baworo waljai, amma manani tǝmmaro baworo waljiwawo. ");
INSERT INTO kby_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Hangal gǝnanowo! Bare curo njǝmbǝɍo so, sagarandu so, duniasuwol so hangalndo ngojane yim adǝ ise kel gai tadu bawo nayia rǝp njadanni. ");
INSERT INTO kby_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nonowo, yim adǝ am dunialan dasaana sammaro cukkuri. ");
INSERT INTO kby_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Faadaro dǝgaiwo, duno awo wakkaji sammaro kanuwe fuwu Tada Kambedǝyen daduye fandoworo sawisoro Alaa korowo,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Adǝgaima yim nguson kausu Isa Fado Alayen jamaa alamji, bune bǝrnidǝn culuwe leje na Kau Jaitunne canidǝyen waji. ");
INSERT INTO kby_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Koro jama samma tawajane tia kǝrǝnduro Fado Alayero isai kasarga. ");
INSERT INTO kby_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sala Burodi Yis Bawoaye tia sala Laya Njǝkkayiramben bowojaidǝ karǝnjǝna. ");
INSERT INTO kby_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Koro wurawa ɍimannaye-a malǝmba Attauraye-a jawal Isaa njejoye majai, amma jamadǝa rijana. ");
INSERT INTO kby_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Daji Yiwulis Yahusa kam tiro Iskariyot cani mewun yindindǝye falnjaro kǝrgawo. ");
INSERT INTO kby_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahusa leje wurawa ɍimannaye-a wurawa Fado Alaye gureduwuye-a rokko jande kǝla jawal Isaa mukkonjaro sǝrǝttuwuyen kedo. ");
INSERT INTO kby_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Karwunja jauro kǝjije tiro wuɍi cadi yeranniya, ");
INSERT INTO kby_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahusa kasacce dama Isaa tayiro jama nojannilan sǝrǝttuwuye mada badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sala Burodi Yis Bawoayen, yim duwon ngǝlaro Laya Njǝkkayirambedǝa duwajaidǝ kidǝnniya, ");
INSERT INTO kby_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isa Biturus-a Yahaya-aa cunode tayiro: «Lenowo, masǝna layayedǝa andiro dabbarsaganowo, buiyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tiro: «Ndaran tia dabbarniyeya, raam?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Isaye tayiro: «Akko bǝrnidǝro ngawuwiya, kam laa bule ingia ngojǝna-a kǝla kǝlluwi. Fado ngayidǝro tia gaiwo ngawowo, ");
INSERT INTO kby_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","kǝma fadoyedǝro wulgǝnowo: “Sayinnaye kusottoram na fuwurawanju-a rokko masǝna layayedǝa cadidǝ ndaran?” ");
INSERT INTO kby_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nayiro soro sameye ngim kura curon karea fǝlenjagai. Nadǝn masǝnadǝa dabbarnowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Daji fuwurawadǝ lejane jiɍi Isa tayiro wuljǝgǝnadǝ gai awiso kewando. Adǝgaima masǝna layayedǝa dabbaryera. ");
INSERT INTO kby_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sa kidǝnniya, Isa kǝngayambanju-a rokko masǝnaro napkera. ");
INSERT INTO kby_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Isaye tayiro: «Caman masǝna Laya Njǝkkayirambe adǝa kawu bone yakkidǝro nayi-a rokko buiyeya, jaumaro raakkǝna. ");
INSERT INTO kby_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nayiro wulnjagakki, na adǝn fuwun tia bukkiwawo, sai jiremaro nodo bargaa Alayelan maananju wakkajiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kǝnjaram curon dibenna ngoje Alaro ardiyenniya, tayiro: «Kǝnjaram adǝa taiwo, wundundo yaye ca! ");
INSERT INTO kby_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nayiro wulnjagakki, na adǝn fuwun ingi inabbe yakkiwawo, har nodo bargaa Alaye napciro,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Daji burodi ngoje Alaro ardiyenniya, fǝsakce tayiro ce: «Adǝ tiyini nayi nangaro tinadǝ. Wua takturo adǝa dewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Adǝgai koro ngawo masǝnayen kǝnjaram ngoje tayiro ce: «Kǝnjaram adǝ aman bǝɍin bunilan ndǝpkada, bu duwon nayi nangaro fidǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kam duwon wua sǝrǝnsiyidǝ, akkonju wu-a rokko masǝna diye. ");
INSERT INTO kby_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tada Kambedǝ saptidǝma, jiɍi Ala kadarjǝnadǝ gai, amma kam duwon tia sǝrǝcciyidǝ, kuttunju!» ");
INSERT INTO kby_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Daji kattenjan kǝla wundunja awo adǝa dioma woyen koro badiyera. ");
INSERT INTO kby_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Daji fuwurawadǝ kattenjan kambiwu kǝla wundunja kura woyen cadi duwon, ");
INSERT INTO kby_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isaye tayiro: «Maiya dunia adǝye talaawanjaa raccagai, koro am tayiro serma canidǝ ye kǝnduwonja fǝlejai. ");
INSERT INTO kby_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amma nayidǝ, ngai gǝni. Kuramandodǝ tǝngǝɍi gairo waljo, koro kam nayia njanodimadǝ wolodi gairo waljo! ");
INSERT INTO kby_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wundu gǝle kura wo? Kam masǝnaro napcǝnamadǝ ra wolodinjudǝ? Kam masǝnaro napcǝnamadǝ, mare? Amma wudǝ curondon wolodindo gai. ");
INSERT INTO kby_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Curo jaraptani sammayen nayima gǝrenin nammuw. ");
INSERT INTO kby_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jiɍi Bawani wuro kǝrmai sinadǝ gai, wu ye nayiro njadǝkke ");
INSERT INTO kby_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","curo kǝrmainiyen wu-a rokko buwe yawe, koro kuris kǝrmaiyen nammuwe jiɍi mewun yindin Israyilawuyero shara yidduwi. ");
INSERT INTO kby_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Siman, Siman, fanne! Yiwulis jiɍi am argǝm lalajaidǝ gairo nayia laladuro Alaa cuworǝna, ");
INSERT INTO kby_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","amma bare kambǝrsenǝm kollǝmmiro Alaa ngikkorǝkko. Ni ye waldǝmiya, kǝramiyanǝmdǝa isadunoagǝne!» ");
INSERT INTO kby_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Biturusse tiro: «Kǝma, koso bi karmoro dabbardǝkkǝna, ni-a rokko leniyo!» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tiye: «Biturus, niro wulnjǝgǝkki, gudowom ku kokkore cakkiwawo, sai yakkuro wua angǝrsǝmiya,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Koro Isa walde tayiro: «Sa nayia wuɍi bawoa, ngǝrwu bawoa, suno gade ye bawoa njanodǝkkǝnadǝn, awo laa maunjana wa?» cǝne tayia kiworǝnniya, «Mausanni,» yera. ");
INSERT INTO kby_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Daji tayiro: «To, amma kǝrma kam wuɍinjuadǝ ngojo, kam ngǝrwunjuadǝ ye ngai, koro kam kashagarnju bawoadǝ ye kalwunju gari cǝlado fal ciwo. ");
INSERT INTO kby_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nayiro wulnjagakki, sai awo kitawulan ruwuwada adǝ wulan wakkajiya: “Amso tia biwumaro ngoyera.” Aaa, awo kǝlanin ruwuwadadǝ wakkaji,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tiro: «Kǝma, akko kashagar yindi,» yeranniya, tayiro: «Kollowo, cǝdǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Isa bǝrnilan culuwe cayedǝ gairo Kau Jaitunnero leyeno, fuwurawanju ye tia geya. ");
INSERT INTO kby_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nadǝro kadinniya, tayiro: «Bare jaraptuwwiro moduwa dewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Daji tayia kolje gana laa kuruwuje tungurumje moduwa dio badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tiye: «Bawa, kasaddǝmmaa, kǝnjaram adǝa wulan ngone! Adǝ yaye rawonidǝ gǝni, kaanǝmdǝma ti wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Daji malaiya laa samelan ise tiro fǝlediye karwunju kibbayeyeno. ");
INSERT INTO kby_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Isa jǝktu dama baworo fanji duwon, cayea kojǝnaro tai daje moduwa kido, har kǝmuwunju bu cidiro fidiyi gairo tok tok fiyadan. ");
INSERT INTO kby_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ngai moduwa kidǝnniya, cije na fuwurawanjuyero walde ise tayia karwukuttaro casambarǝna kǝnǝm cadi najiye ");
INSERT INTO kby_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","tayiro: «Awiro kǝnǝm diwidǝ? Cinowo, bare jaraptuwwiro moduwa dewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isa mana cǝdi ngai duwon, jama kada kam tiro Yahusa cani mewun yindindǝye falnja fuwu gǝrjiaro kadira. Yahusadǝ Isaro lewa kǝrawoye njǝddoro tia karǝngenniya, ");
INSERT INTO kby_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Isaye tiro: «Yahusa, lewa kǝrawoyelan wa Tada Kambedǝa sǝrǝtkǝmi?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Am nanjuyedǝ awo wakkajidǝa kerunniya, tiro: «Kǝma, kashagarlan tayia cacalliyea, nda!» cane ");
INSERT INTO kby_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","falnja wolodi ɍiman kurayea bakce sǝmonju kǝmboramdǝa tǝn kamgeno. ");
INSERT INTO kby_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amma Isaye tayiro: «Danowo! Cǝdǝna!» yenniya, sǝmonju leje isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Daji Isaye wurawa ɍimannaye-a wurawa Fado Alaye gureduwuye-a amwurawa jamaye-a tia taro isanadǝro: «A! Nayi kashagar so, ka so mukkonna wua gǝndema gai taro kadiw? ");
INSERT INTO kby_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yim nguson nayi-a rokko Fado Alayen dǝgaiye duwon, wua sǝdawwi. Amma adǝma sando wo, sa duwon duwu kǝrmainju cunodidǝ.» ");
INSERT INTO kby_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Daji Isaa cadane balballa fado ɍiman kurayedǝro kesado. Biturus ye katte kaskadaaro tayia giya. ");
INSERT INTO kby_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dawu balballayen kannu fujane napkeranniya, Biturus ye dawunjan napkeno. ");
INSERT INTO kby_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Daji kir laa Biturussa nur kannuyedǝn napkada kirunniya, tia ngǝlaro ninije: «Kam adǝ ye Isa-a rokko,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amma Biturus angǝrje: «Feroma, wu tia nokkǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gana sam kidǝnniya, kam laa ye tia cure: «Ni ye falnja!» yeno. Biturusse: «Kai! Wu gǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Alama sa fal gai cǝde kam laa gade: «Fagatto kam adǝ ye Isa-a rokko, ti ye kam cidi Galileye nangaro!» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Biturusse tiro: «Kam, awo wullǝmidǝa nokkǝni!» yeno. Sadǝman manaji ngai duwon, gudowom kokkore kekko. ");
INSERT INTO kby_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Daji Kǝmadǝ suworde Biturussa niniyeno. Biturus ye awo Kǝma tiro wuljǝgǝnadǝa takkeno. Kǝmaye: «Ku kawu gudowom kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Takkenniya, deyaro culuwe tai daje so ngoyeno. ");
INSERT INTO kby_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Adǝgai duwon am Isaa gurejaidǝ tia rurujane babaktu badiyera. ");
INSERT INTO kby_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Simnju jakcane tiro: «Nawinawi de! Wundu nia bannjo?» yera. ");
INSERT INTO kby_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Koro radu kada tiro keddo. ");
INSERT INTO kby_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dunia wayenniya, amwurawa jamaye-a wurawa ɍimannaye-a malǝmba Attauraye-a majilislan captane casakke Isaa fuwunjaro kewudo. ");
INSERT INTO kby_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tiro: «Nima wa Almasiwudǝ wo? Andiro wulsagane!» cane tia keworo. Amma Isaye tayiro: «Wulnjagakkia, kasadduwwawo. ");
INSERT INTO kby_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Koro njaddǝkkia, jaawu siwwawo. ");
INSERT INTO kby_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amma kua adǝn fuwun Tada Kambedǝ mukko kǝmboram Ala Kǝnduwomayen napkada dǝgai,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Daji tayi sammaye tiro: «Nima gǝle Tada Alayedǝ wo?» yeranniya, tayiro: «Nayima wulluw, wuma!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Daji tayiye: «A! Sheda jiɍi fi gǝle gade maniye? Andi kǝlande mana cinjulan culuwuna adǝa fanniyena,» yera. ");
INSERT INTO kby_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Daji majiliswu samma cijane Isaa fuwu Gomna Bilatussero caade ");
INSERT INTO kby_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ayau gǝnaduwu badiyera. Tayiye: «Kam adǝ jamandea tuɍu cadoro tǝmbaljiyi nayeyeiye. Kaisarro akki njo dapciyi, koro tima Almasiwu maidǝ wo cǝni,» yera. ");
INSERT INTO kby_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatusse tiro: «Nima wa Mai Yaudiyayedǝ wo?» cǝne tia kiworo. Isaye: «Nima wullǝm, wuma!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Daji Bilatusse wurawa ɍimannaye-a jama captanadǝ-aro: «Kam adǝlan ayau fima fandǝkkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amma amdǝ cayea kojǝnaro kowo sapcane: «Alamdunjun jamande cidi Yahudiyaye sammaa jawallan cuttuluwi, cidi Galileyen badije har na adǝro kadio,» yera. ");
INSERT INTO kby_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bilatus adǝa fangenniya, Isa kam Galileye waro kiworo. ");
INSERT INTO kby_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Isa kam Galile cidi duwon Mai Hirudus cunodidǝyero asuyenniya, cakke Isaa na Maidǝyero kesado, sa adǝn ti ye Jerujalemnin nangaro. ");
INSERT INTO kby_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mai Hirudus Isaa kirunniya, karwunju jauro kǝjiyeno. Tussǝna ti-a tado cǝraana, dalilnjudǝ calan lawarnju fanjǝna, koro alama laa sameye tiyen kuroro tǝmajǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Koro kada tiro kiddo, amma Isa awima tiro kalakcǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wurawa ɍimannaye-a malǝmba Attauraye-a ye nadǝn daada tia jauro burwujai. ");
INSERT INTO kby_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mai Hirudus ye sojiyanju-a rokko tiro rudu gǝnajagane rarayera. Daji kalwu darajaa tiro lujagane na Bilatussero kalakkera. ");
INSERT INTO kby_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Caman Mai Hirudus-a Gomna Bilatus-aye kattenja kuttu duwon, yim adǝman kǝjijane sawaro walyera. ");
INSERT INTO kby_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Daji Gomna Bilatus wurawa ɍimannaye-a amwurawa jamaye-a jamadǝ-aa bowoje ");
INSERT INTO kby_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tayiro: «Kam adǝ jamadǝa tuɍu cadoro tǝmbaljiyi nuwe naniro kiwuduw. Fuwundon tiro koro kiddǝkkǝniya, ayau tiro gǝnagǝwwadǝn falma fandǝkkǝni. ");
INSERT INTO kby_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Koro Mai Hirudus ye cuwandǝnni nangaro, cakke tia kalakkera. Akko awima tia roro njejoye cǝdǝna bawo. ");
INSERT INTO kby_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Adǝ nangaro yakkǝkke tia kirwon jajarjane salammǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Caman kǝla adayen sala adǝn kosoma fal tayiro salamjiyi. ");
INSERT INTO kby_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Daji jama samma ci tiloaro kowo sapcane: «A'a! Kam adǝye ronju tuluwe! Barabbassa andiro salamsagane!» yera. ");
INSERT INTO kby_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti Barabbasdǝ, bǝrnilan tuɍu cade kam laaa ceyesǝnadǝro, tia kosoro casakkǝna. ");
INSERT INTO kby_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus Isaa salamduro cǝraanadǝ, walde tayiro manayeyeno, ");
INSERT INTO kby_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","amma kowo sapcane: «Kǝskaro tia jagǝne! Kǝskaro tia jagǝne no!» cani. ");
INSERT INTO kby_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yakkuyedǝn walde tayiro: «Awiro? Ayau awiye cǝdo? Awima roro njejoye tilan fandǝkkǝni. Adǝ nangaro yakkǝkke tia kirwon jajarjane salammǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amma jamadǝ caye baworo kowo sapcane Isaa kǝskaro jajuwo no cane, har kowonjan nasargadara. ");
INSERT INTO kby_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Daji Bilatus shara kamje awo caworǝnadǝ tǝdi yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kam tia caworǝna, kam duwon tuɍu-a kam njejo-a nangaro kosoro casakkǝnadǝa salamgeno, amma Isaa awo caraanadǝa cadoro mukkonjaro kekko. ");
INSERT INTO kby_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sojiya Isaa caadi duwon, kam laa bǝla Kuraneye cunju Siman karaan isidǝa cadane kǝska karmoyedǝa ngoje ngawo Isaye jǝgane leyera. ");
INSERT INTO kby_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Curo jama tǝrǝm ngawonju jagaidǝyen kamuwa kada ti nangaro karwukuttaro nganji bakcai ye, cesiri ye mbeji. ");
INSERT INTO kby_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Daji Isa suworde tayiro: «Kamuwa Jerujalembe, bare wu nangaro yiruwwi! Kǝlando-a njuɍiyando-aro yikkirowo! ");
INSERT INTO kby_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nonowo, sa laa cǝde ambe: “Barganja kamuwa rakcane casambiwawodǝ! Barganja kamuwa ngaltema casambǝne tǝgam cadǝnnidǝ!” cani. ");
INSERT INTO kby_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sadǝn kauwa kuruwuro: “Kǝlandero yukkurowo!” koro kǝriso yero: “Andia jansanowo!” wuldu badijai. ");
INSERT INTO kby_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Awoa kǝska kǝɍidǝro ngai caddia, awi gǝle kǝska ngamdudǝro wakkajiyi?» ");
INSERT INTO kby_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sojiyadǝ gǝndewu yindi yea ti-a rokko njejoro kesado. ");
INSERT INTO kby_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na tiro Buwo Kǝlaye canidǝro kadiranniya, nadǝn Isaa kǝskadǝro jayeyera. Gǝndewu yindidǝ yea jayeyera, faldǝ kǝmboramnjulan, faldǝ ye wailanjulan. ");
INSERT INTO kby_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Daji Isaye: «Bawa, tayia gawurne, awo cadi nojanni nangaro,» yeno. Sojiyadǝ kajǝmunju ngojane walawala cade dagaryera. ");
INSERT INTO kby_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jamadǝ nadǝn daada carui ngai duwon, amwurawadǝ tiro rudu gǝnajagane: «Am gadea cǝkkaana. Tima Almasiwu Ala kǝrejǝnaa, nda kǝlanju cǝmowo!» cani. ");
INSERT INTO kby_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojiyadǝ ye tia rujane nanjuro isane tiro diben comcom sajagane: ");
INSERT INTO kby_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ni Mai Yaudiyayedǝa, kǝlanǝm moye!» cani. ");
INSERT INTO kby_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kǝlakajinjun adǝ allolan ruwuwada: TI ADƎMA MAI YAUDIYAYE WO. ");
INSERT INTO kby_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gǝndewu yindi jajaanadǝye falnja Isaro manakuttu cǝdde: «Nima gǝna Almasiwudǝ wo? Nda kǝlanǝm moye, andi yea sakkaye!» ");
INSERT INTO kby_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amma faldǝ ye kamanjuro jǝkkade: «A! Ni yero shara ro tuluwoye njaddǝnama, Alaa rinǝmbawodǝ? ");
INSERT INTO kby_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kaandedǝ jussǝna, diwi diyena nangaro ajawu gǝnasaana, amma kam adǝ awima diwi cǝdǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Daji walde: «Isa, kǝrmainǝm fandǝmiya, wua kǝlan sǝdai,» yenniya, ");
INSERT INTO kby_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isaye: «Jiremaro niro wulnjǝgǝkki, kumaro wu-a rokko jannalan dǝgaiye,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kausu kǝla dawu duwon, dunia nga tǝmje cǝlǝmbo walje, har sa yakku kajiriyero kiado, ");
INSERT INTO kby_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kǝngal ye wasturo wayeno. Sa adǝn juwa curo Fado Alayen dǝganadǝ farak yindiro kargadan. ");
INSERT INTO kby_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Daji Isa kowo dunoaro sapce: «Bawa, roni curo mukkonǝmbero yakkǝkki,» yenniya, ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kajalla sojiyayedǝ awo wakkajǝna sammaa kirunniya, Alaa jajakce: «Fagatto kam adǝ jirema!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jama kada na lamar adǝyen captanadǝ ye awo wakkajǝna sammaa kerunniya, karwukuttaro nganji bakcaiaro walladara. ");
INSERT INTO kby_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amma am Isaa nojanadǝ-a kamuwa tia cidi Galileyen jaane isanadǝ-a samma kuruwunin daada awo ania lawarjai kasarga. ");
INSERT INTO kby_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kam laa nadǝn mbeji, cunju Isuwu. Tidǝ kam ngǝlama ye, jirema ye, ");
INSERT INTO kby_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kam Arimatiya cidi Yahudiyaye, koro nodo bargaa Alayedǝa gureji. Ti majiliswudǝye falnja yaye, awo amanju niajane Isaro caddǝnadǝa kasaccǝnni. ");
INSERT INTO kby_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Daji Isuwu na Gomna Bilatussero leje kamin Isayedǝa kiworo. ");
INSERT INTO kby_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kamindǝa kǝskadǝlan cǝsaye lowowon batta linnen kǝkǝrje kauri duwon curo kauyen lajana laa wundumaa casakkǝnniro cakke sǝnayeno. ");
INSERT INTO kby_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yimdǝ yim dabbarduye, koro yim tustuye badidunju del karǝnjǝna. ");
INSERT INTO kby_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kamuwa duwon Isa-a rokko cidi Galileyen isanadǝ ye jaane kauridǝa lawarjane jiɍi kaminnju sǝnajanadǝa kero. ");
INSERT INTO kby_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Daji waldane kawudi-a kǝndawu-a dabbaryera. Yim tustuyea kǝla wadayen tuskera. ");
INSERT INTO kby_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mawuye yim burwoyea suwa lǝp kamuwadǝ kawudi-a kǝndawu-a dabbarjanadǝa ngojane kauridǝro leyeranniya, ");
INSERT INTO kby_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","kau kuradǝ ci kauriyedǝn tǝmballada nayeyera. ");
INSERT INTO kby_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kasargaanniya, kamin Kǝma Isayedǝa cawandǝnni. ");
INSERT INTO kby_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kǝla adǝyen hangalnja cijǝna duwon, kongwa yindi kajǝmu yiyiljia gǝrenjan daada tayiro fǝleyaadara. ");
INSERT INTO kby_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Karwunja kamde kǝla cidiyaro kesakkǝranniya, kongwawadǝye tayiro: «Awi nangaro kam roa curo am sanunayen manuwidǝ? ");
INSERT INTO kby_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ti na adǝn bawo, cijǝna! Awo Isa sa ti cidi Galileyen nayiro wulnjaanadǝa tangowo: ");
INSERT INTO kby_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ala kadarjǝna, Tada Kambedǝa mukko biwumasoyero casakke kǝskaro jajagane ceyesi, koro kawu yakkua roaro walje ciji.”» ");
INSERT INTO kby_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Daji mananjudǝa takkera. ");
INSERT INTO kby_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kauridǝn walladaranniya, awo ani sammaa mewun tilondǝ-a fuwurawa gadesodǝ-aro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kamuwa awo ania kǝngayambadǝro wuljaanadǝ tayima Meram Magdala-a Yanna-a Meram ya Yakubaye-a kamuwa gadeso-a wo. ");
INSERT INTO kby_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amma mananjadǝa kǝla bawoaro ngojane tayia njasarairo wayera. ");
INSERT INTO kby_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Adǝ yaye Biturus cije cǝgase kauridǝro leyeno. Nguje lotkeyenniya, batta linne gǝnia, awima gade curunni. Daji awo wakkajǝnadǝa jauro ajapce fadoro walladan. ");
INSERT INTO kby_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yim adǝman fuwurawanjuye yindinja cijane bǝla laa Imawus cani kilometǝr mewun yindin gai Jerujalemlan dǝganadǝro lejai duwon, ");
INSERT INTO kby_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","kǝla awo wakkajana ani sammayen jande badiyera. ");
INSERT INTO kby_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jandejane gasipcai duwon, Isa kǝlanju karǝnje tayi-a rokko leyera. ");
INSERT INTO kby_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amma simnjan tia carunama, ti wunduro asuduro dapkaada. ");
INSERT INTO kby_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isaye tayiro: «Kǝla awiyen jawallan jandenuwidǝ?» cǝne tayia kiworǝnniya, karwu kuttua gǝm dayera. ");
INSERT INTO kby_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Falnja cunju Kǝleyofas tiro: «Curo kusottowa Jerujalembe sammayen ni tilonǝm awo kawu anin wakkajǝnadǝa nonǝmmi wo?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tayiro: «Awi gǝle wakkajo?» yenniya, tiro: «Awo Isa kam Najarattero wakkajǝgǝnadǝ! Ti nawi kura fuwu Ala-a jama samma-ayen awo cǝdi-a manaji-a samma kǝnduwoa duwon, ");
INSERT INTO kby_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","wurawande ɍimannaye-a amwurawande-a wowom karmoye tiro gǝnajaaro tia sǝrǝccagane kǝskaro jayeyera. ");
INSERT INTO kby_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amma tima kam duwon jama Israyilayea merujimadǝ woro tǝmaniyena. Akko awo ani wakkajanadǝ ku kawu yakku. ");
INSERT INTO kby_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Koro kamuwa laa curonden lawar ajabba andiro sakkudǝna. Ku suwa lǝp kauridǝro leyeranniya, ");
INSERT INTO kby_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kaminnjudǝa cawandǝnni. Daji waldane isane andiro malaiyawa tayiro nadǝn fǝledagane ti ronjua cane wulseyera. ");
INSERT INTO kby_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Adǝgaima amnde laa ye kauridǝro leyeranniya, kamuwadǝ wuljanadǝ gai, awo sammaa kalkallo nayeyera, amma tidǝa carunni!» ");
INSERT INTO kby_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Daji Isaye tayiro: «Am hangal bawoa! Kua yaye awo nawiyaso wulnjaanadǝa njasarairo wanuwwa. ");
INSERT INTO kby_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ala kadarjǝna, ti Almasiwudǝ bone adǝa cane duwon daraja na Alayen cuwandiwawo wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Daji Attaura Nawi Musayen tamiya har kitawuwa nawiyaye gadedǝro kudero awo kǝlanjun kitawu samman ruwuwadadǝa tayiro fisaryeyeno. ");
INSERT INTO kby_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bǝla lejaidǝa karǝngeranniya, Isa fuwuro koji gairo kido. ");
INSERT INTO kby_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amma tia lowojane: «Marne, andi-a rokko jǝmmiyo! Kǝngal njukkuro cǝdi, dunia lǝmdu maji,» yeranniya, ngaye tayi-a rokko jǝpkera. ");
INSERT INTO kby_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Masǝna dioro napkeranniya, burodi ngoje Alaro ardije fǝsakce tayiro kaino. ");
INSERT INTO kby_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Daji kǝlanja fǝrǝmde tia asuyera, amma tayiro fatkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kattenjan: «Kǝla jawallen mana sadde kitawu Alaye fisarsagai duwon, karwunde tai daje kǝjijǝnni wa?» yera. ");
INSERT INTO kby_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sadǝman cijane Jerujalembo waldane kǝngayamba mewun tilondǝ-a amanja gade-a captana nayeyeranniya, ");
INSERT INTO kby_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","jamaye tayiro: «Jiremaro Kǝmadǝ karmolan cijǝna, har Simanno fǝledǝgǝna!» yera. ");
INSERT INTO kby_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Daji tayi yindidǝ ye awo kǝla jawallen wakkajǝna-a jiɍi burodi fǝsakce dagarjǝnalan tia asujana-adǝa wulyeyera. ");
INSERT INTO kby_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Fuwurawadǝ kǝla awo aniyen jande cadi ngai duwon, Isa kǝlanju dawunjan daje tayiro: «Salam aleikum!» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kaime kam nunaye laa caro cane karwunja pǝt kamgada. ");
INSERT INTO kby_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Amma Isaye tayiro: «Awiro hangalndo cijǝnadǝ? Awi nangaro kǝla wuyen danguwi? ");
INSERT INTO kby_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Akko mukkoni-a sini-a ruiwo, wu kǝlanima! Lesǝnowo ruiwo, kaimelan silla-a da-a bawo, amma wu takkǝnaro ruwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Adǝa wulyenniya, mukkonju-a sinju-a tayiro fǝleyeyeno. ");
INSERT INTO kby_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Daji karwunja tai daje kǝjijǝna yaye, ajapcane tia mǝrsajannidǝ, Isaye: «Na adǝn awo laa kǝmboye mbeji wa?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Njango buni wargadaye tiro kekkudǝranniya, ");
INSERT INTO kby_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","cǝmoye fuwunjan gigǝro. ");
INSERT INTO kby_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Daji Isaye tayiro: «Akko manani sa dawundon dǝgakkǝnadǝn nayiro wulnjagakkǝnadǝ: “Ala kadarjǝna, awowa duwon kǝlanin curo Attaura Nawi Musaye-a kitawuwa nawiyaye-a Jawura-ayen ruwuwadadǝ sai wakkajaiya,”» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Daji Isa kǝlanja fǝrǝmje kitawuwadǝa tayiro bayinduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tayiro: «Akko awo kitawulan ruwuwadadǝ: “Almasiwudǝ bone cai, kawu yakkua karmolan ciji, ");
INSERT INTO kby_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","koro Jerujalemnin tamiya har jama duniaye sammaro kudero cunjulan kawuɍi tuwa dio-a gawara fando-ayedǝa wuljagai.” ");
INSERT INTO kby_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nayima shedawu awo aniye wo. ");
INSERT INTO kby_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wudǝ awo Bawani wadu ngoje nayiro njadi cǝnnadǝa juwanjagakki. Nayi ye bǝrni adǝn nammowo duwon, har samelan kǝnduwo nayiro jǝmnjagairo,» yeno. ");
INSERT INTO kby_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Daji Isa tayia bǝrnidǝn cuttuluwe karǝn bǝla Baitaniyero kiwudǝnniya, mukkonju yindi sapce tayiro barga dǝpkeyeno. ");
INSERT INTO kby_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tayiro barga dǝpciyi ngai duwon, nanja kolje tia samero kesado. ");
INSERT INTO kby_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tiro ambǝtkeyeranniya, karwukǝji dama bawoa Jerujalembo walladara. ");
INSERT INTO kby_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Adǝgaima kullum Fado Alayen Kǝmandea congori kasarga.");
INSERT INTO kby_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Badiduramnin Kalma, Kalmadǝ Ala-a rokko, Kalmadǝ Ala kǝlanjudǝma. ");
INSERT INTO kby_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Badiduramnin Ala-a rokko kasarga. ");
INSERT INTO kby_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Awiso tiyelan alaktǝna. Curo awo alaktǝna sammayen, tiyen gǝnia, awo alaktǝna falma bawo. ");
INSERT INTO kby_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tilan ro kǝrga, rodǝ tima nur kambe wo. ");
INSERT INTO kby_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nurdǝ curo duwuyen yiyilji, amma duwudǝ tia cǝmowonni. ");
INSERT INTO kby_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kam laa Ala cunodǝna mbeji, cunju Yahaya. ");
INSERT INTO kby_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tidǝ shedaro kadio. Am samma tiyelan kasaccaro, nurdǝa shedajoro kadio. ");
INSERT INTO kby_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ti kǝlanju gǝni nurdǝ wo, amma nurdǝa shedajoro kadio. ");
INSERT INTO kby_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nur adǝ tima nur jireye wo, duniaro ise am sammaa wassimadǝ. ");
INSERT INTO kby_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tidǝ dunialan duwon, duniadǝ ye tiyelan alaktǝna yaye, duniadǝ tia nojǝnni. ");
INSERT INTO kby_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Na jamanjuyero kadio, amma jamanju tia camowonni. ");
INSERT INTO kby_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amma am duwon tia camoye cunju kasaccanamasodǝro kǝnduwo tadawa Alayero walduye kaino. ");
INSERT INTO kby_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tayidǝ buyen gǝni, bi kǝrawo tiyiyen gǝni, bi kǝrawo kamben gǝni, Alayen katambǝra. ");
INSERT INTO kby_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kalmadǝ kambo walje dawunden napkeno. Ti jauro serra ye, jirea ye. Koro darajanjua ruiyena, daraja duwon daraja Tada tilo lok na Bawayen isǝnayedǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahaya tia shedaje kowo sapce: «Tima kam kǝlanjun wuye: “Kam ngawonin isidǝ wua kosǝna, wun burwonno ti mbeji nangaro,” wullǝkkǝnadǝ.» ");
INSERT INTO kby_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Barga dǝptuwunju dama bawodǝro andi samma ser cinju bawo kiwandiye. ");
INSERT INTO kby_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wadadǝ Nawi Musayen kadio, amma ser-a jire-adǝ Isa Almasiwuyen kadira. ");
INSERT INTO kby_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wunduma ngalte Alaa curuna bawo, amma Tada tilo lok, tidǝ Ala ye, na Bawayen dǝganama ye, tima Aladǝa andiro isanosaa. ");
INSERT INTO kby_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sa yaudiya Jerujalemnin na Yahayayero ɍimanna-a Lewiya-aa ti wunduro kororo canodǝnadǝn, akko sheda Nawi Yahayayedǝ. ");
INSERT INTO kby_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Angǝrjǝnnin federo wulje tayiro: «Wu gǝni Almasiwudǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Daji tiro: «Ni wundu gǝle? Nima wa Nawi Iliya wo?» cane tia keworo. Tayiro: «A'a, wu gǝni,» yeno. Tiro: «Ni nawidǝ wa?» yeranniya, tayiro: «A'a,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Daji tiro: «To, ni wundu gǝle? Jaawu am andia sanodǝnadǝro yadiyoro, awi gǝle kǝlanǝmlan wullǝmi?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yahayaye tayiro: «Wuma “kam karaan kowo sapce: ‘Jawal Kǝmandeye cǝkko dewo!’ cǝni,” Nawi Ishaya wuljǝnadǝ gai,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Curo kǝwu Farisawaye yen am laaa canodǝna. ");
INSERT INTO kby_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tayiye Yahayaro: «Ni Almasiwu gǝni, Nawi Iliya ye gǝni, nawidǝ ye gǝni, awiro gǝle ambo kasala yiddǝmi?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tayiro: «Wudǝ ingilan ambo kasala kiddǝkko, amma dawundon kam laa daada nonuwwi mbeji, ");
INSERT INTO kby_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","tidǝ kam je sunonjuye wuiduma tikkǝni ngawonin isi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Awo ani bǝla Baitani ci bǝrǝm Jordaniye todǝn na duwon Yahaya ambo kasala cǝddidǝn wakkayera. ");
INSERT INTO kby_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wajǝnanjua Nawi Yahaya nanjuro Isa kǝnde cǝdi kirunniya, tiye: «Akko Tama Alaye biwu duniaye ngojimadǝ! ");
INSERT INTO kby_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tima kam kǝlanjun wuye: “Kam ngawonin isidǝ wua kosǝna, wun burwonno ti mbeji nangaro,” wullǝkkǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wu kǝlani tia nokkǝni, amma ingilan ambo kasala njǝddoro kadikko, ti jama Israyilayero fǝleduworo.» ");
INSERT INTO kby_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahaya shedaje: «Ruhu Alaye alama bullam gai samelan jǝpce kǝlanjun napci kirukko. ");
INSERT INTO kby_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Wu kǝlani tia nokkǝni, amma Ala wua ingilan ambo kasala yiddǝkkoro sunodǝnadǝye wuro: “Ruhudǝ samelan jǝpce kǝla kam laayen napci rumi. Tidǝ Ruhu Alayen ambo kasala cǝddi,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wu kǝlani rukkǝna ye, shedanǝkkǝna ye, tima Tada Alayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wajǝnanjua Nawi Yahaya fuwurawanjuye yindi-a rokko nadǝn dajana duwon, ");
INSERT INTO kby_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yahaya Isa koji kirunniya, tiye: «Akko Tama Alaye!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Fuwurawa yindidǝ mana adǝa fanjane Isaa geya. ");
INSERT INTO kby_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isa suworde tia jagai kirunniya, tayiro: «Awi manuwi?» cǝne kiworo. Tiro: «Rabbi, ndaran kǝrgam?» cane tia keworo. Maana rabbiyedǝ sayinna. ");
INSERT INTO kby_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Isaye tayiro: «Arowo ruiwo!» cǝne lejane na dǝganadǝa carune nadǝn ti-a rokko dabduyera. Sadǝ ye sa dewu kajiriye gai. ");
INSERT INTO kby_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tayi yindi mana Yahayayedǝa fanjane Isaa jaanadǝye falnjaye cunju Andarawus, yaana Siman Biturusse. ");
INSERT INTO kby_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Burwon leje yaananju Simanna maje tiro: «Almasiwudǝa fandiyena!» yeno. Maana Almasiwuyedǝ kam tiro Kǝristi cani. ");
INSERT INTO kby_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Daji Simanna na Isayero kiwudo. Isa tia kirunniya, tiro: «Nima Siman tada Yahayaye, na adǝn fuwun nia Kefaslan bowonjai,» yeno. Maana Kefassedǝ Biturus. ");
INSERT INTO kby_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wajǝnanjua Isa cidi Galileyero leduro nia ngoyeno. Filibussa kiwandǝnniya, tiro: «Wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibusdǝ kam Baitsaidaye bǝla Andarawus-a Biturus-aye. ");
INSERT INTO kby_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Daji Filibus ye leje Nataniyella maje tiro: «Kam duwon kǝlanjun Nawi Musa curo Attaurayen ruwuje nawiya kitawulan ruwujanadǝa fandiyena! Tidǝ Isa kam Najaratte, tada Isuwuye,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyelle tiro: «A! Najaratlan awo laa ngǝla culuwi wa?» yenniya, Filibusse: «Are rui!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Isa Nataniyel nanjuro kǝnde cǝdi kirunniya, kǝlanjun manaje: «Akko Israyilama jireye, tilan awo jirenambuye bawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyelle tiro: «Ndayin wua nosem?» cǝne tia kiworo. Isaye tiro: «Kawu Filibus nia bowonjimaro, ni cidiya tarmuyen duwon, njurukkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Daji Nataniyelle tiro: «Sayinna, nima Tada Alayedǝ wo! Nima Mai Israyilawuyedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isaye tiro: «Cidiya ya tarmuyen njurukkǝna niro wulnjǝgǝkkǝnadǝro wa wua kasansem? Awo ania kojana rumi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Daji Isaye: «Jiremaro nayiro wulnjagakki, same kaada malaiyawa Alaye kǝla Tada Kambedǝyen taccai ye, jǝpcai ye ruwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yimbe yakkua bǝla Kana cidi Galileyen larusa kedo. Ya Isaye nadǝn mbeji, ");
INSERT INTO kby_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","koro Isa-a fuwurawanju-a yea larusadǝro dojana. ");
INSERT INTO kby_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Diben cotto kerǝnniya, ya Isaye tiro: «Diben bawo cerǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Amma Isaye: «Yani, awiro naniro kadim? Sani koroma cǝdǝnni, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yanjuye wolodiyadǝro: «Awi yaye nayiro wulnjagaidǝa dewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nadǝn gǝmdo kauye arakku gǝnaada mbeji. Yaudiyaye adanja tayirro walduyero faidadai, gǝmdo fi yaye alama bule yindi bi yakku gai ngoji. ");
INSERT INTO kby_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Daji Isaye wolodiyadǝro: «Gǝmdowadǝa ingilan yimbǝɍowo!» cǝne tayia fer ferro kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Isaye tayiro: «Kǝrma kurummowo, kǝma ngǝmǝriyedǝro yadowo!» cǝne kurumjane kekkiado. ");
INSERT INTO kby_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kǝma ngǝmǝriyedǝ ingi dibenno waljǝnadǝa kidambǝnniya, ndaran kewudomaro nojǝnni, amma wolodiya ingidǝa kurumjanadǝ nojana. Daji mai larusayedǝa bowoje ");
INSERT INTO kby_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tiro: «Wundu yaye burwon diben kǝji con ci, sagarandaiya, diben burwoyedǝa najǝgǝnni ci. Amma nidǝ har kǝrmaro diben kǝji condǝa gǝnayem!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Adǝma awo Isa bǝla Kana cidi Galileyelan cǝdǝnadǝ, tima alamanju ajabba burwoye wo. Adǝgainin darajanjua fǝlejiye fuwurawanju tia kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngawo adǝyen ti-a yanju-a yanjugǝnaso-a fuwurawanju-a rokko bǝrni Kafarnaambero lejane kawu ganaro nadǝn napkera. ");
INSERT INTO kby_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sala yaudiyaye Laya Njǝkkayirambe sanju karǝngenniya, Isa Jerujalembo leyeno. ");
INSERT INTO kby_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Curo Fado Alayen am dalo so, ngǝlaro so, tattawar so caladi ye, canjimaso napkada yea nayeyeno. ");
INSERT INTO kby_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Daji Isa jelan kirwo catte tayi sammaa ngǝlaro-a dalo-an kundenno Fado Alayedǝn duyeno. Koro wuɍi canjimasoyedǝa cidiro fijiye tewurnjadǝa tǝmbalje ");
INSERT INTO kby_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","tattawar ladomasodǝro: «Ngonowo ani ngaa na adǝn tuluwowo! Bare Fado Bawaniyedǝa kasuwuro kalanguwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Daji fuwurawanjudǝ awo kitawulan ruwuwada adǝa takkera: «Rawo fannǝmbedǝ kannu gai wua sesi.» ");
INSERT INTO kby_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Daji yaudiyadǝye tiro: «Awo ania dionǝmdǝ, alama fi andiro fǝlesagami?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isaye tayiro: «Fado Alaye adǝa wurnowo, wu ye curo kawu yakkuyen waldǝkke tia tandǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Daji yaudiyadǝye tiro: «A! Fado Alaye adǝa tandoro kǝrwu fidewun arakkun cado duwon, ni curo kawu yakkuyen waldǝme tandǝmi?» yera. ");
INSERT INTO kby_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma fado duwon Isa kǝlanjun mana cǝdǝnadǝ tiyinju. ");
INSERT INTO kby_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Adǝ nangaro Isa walde karmolan cijǝnaye ngawon, fuwurawanju ye mana adǝa wuljǝnadǝa takcane awo kitawulan ruwuwadadǝ-a mana Isayedǝ-aa kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Adǝgaima Isa sala Laya Njǝkkayirambero Jerujalemnin dǝgana duwon, am kada alama ajabba ajabba cǝdidǝa carune tia kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amma Isa am sammaa jauro nojǝna nangaro, tayia mǝrsajǝnni. ");
INSERT INTO kby_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Koro kǝla kamben shedaro wundumaa majǝnni, ti kǝlanju awo karwu kambedǝa nojǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kǝwu Farisawayen kam laa kura yaudiyaye mbeji, cunju Nikodimus. ");
INSERT INTO kby_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Curo buneyen na Isayero ise tiro: «Sayinna, nidǝ malǝm na Alayen kadimbo noniyena, dalilnjudǝ wunduma Ala-a rokko gǝnia, rakce alama dimi ania cǝdiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isaye: «Jiremaro niro wulnjǝgǝkki, kam duwon bǝɍinno tambǝnnidǝ, rakce nodo bargaa Alayedǝa curuiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimusse: «Ndayin gǝle kam kiarijǝnadǝa rakcane casambi? Curo yanjuyero wa walde yindiyero ngaye tia cambi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isaye: «Jiremaro niro wulnjǝgǝkki, kam duwon ingi-a Ruhu Alaye-alan tambǝnnidǝ, rakce nodo bargaa Alayedǝro ngayiwawo. ");
INSERT INTO kby_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Awo kamben tambǝnamadǝ kamdǝma, amma awo Ruhu Alayen tambǝnamadǝ ruhudǝma. ");
INSERT INTO kby_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bare ajammǝmmi kǝla “Sai bǝɍinno tambuwiya,” wulnjǝgǝkkǝna adǝyen. ");
INSERT INTO kby_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Karuwa cijiya, na cǝraanaro fuji. Kowonju fannǝmi, amma na culuwuna-a na leji-adǝa nonǝmmi. Adǝgaima kam duwon Ruhu Alayen tambǝnamadǝ ye.» ");
INSERT INTO kby_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimusse tiro: «Jiɍi filan attǝ yoji?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isaye tiro: «Ni malǝm nowada Israyilawuye duwon awo ania nonǝmmi? ");
INSERT INTO kby_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jiremaro niro wulnjǝgǝkki, andi awo noniyena mananiye, koro awo ruiyena shedaniye, amma nayi kua yaye shedandedǝa kasatturo wanuwwa. ");
INSERT INTO kby_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nayiro awowa duniayeso wulnjagakkǝna kasadduwwi duwon, sameyesodǝa wulnjagakkia, ndayilan gǝle kasadduwi? ");
INSERT INTO kby_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wunduma samero lejǝnni, Tada Kambe samelan jǝpcǝnadǝ gǝnia. ");
INSERT INTO kby_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jiɍi Nawi Musa karaan kadi rojǝgǝnadǝ gai, sai ngairo Tada Kambedǝ yea rojagaiya, ");
INSERT INTO kby_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kǝla adǝyen wundu duwon tia kasaccǝnamadǝ ro sawisoye cuwandi. ");
INSERT INTO kby_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Awoa Ala duniadǝa jaumaro cǝraye Tadanju tilo lok kaino, wundu duwon tia kasaccǝnamadǝ bare faccǝgǝnni, amma ro sawisoye cuwando nangaro. ");
INSERT INTO kby_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ala duniaro shara njǝddoro gǝni Tadanjudǝa kinodo, amma tiyen duniadǝa cǝkkaworo. ");
INSERT INTO kby_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wundu duwon tia kasaccǝnamadǝ, tia shara cǝdaiwawo, amma wundu duwon tia kasaccǝnnimadǝ, caman tia shara cǝdana, dalilnjudǝ cu Tada tilo lok Alayedǝa kasaccǝnni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Adǝma sharadǝ wo: Nurdǝ duniaro isǝna, amma am nurdǝa wajane duwudǝa kerawo, kǝndonjaso diwi nangaro. ");
INSERT INTO kby_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Diwi dioma fi yaye nurdǝa waje na nurdǝyero isiwawo, bare kǝndonju diwidǝa am federo carunniro. ");
INSERT INTO kby_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amma jire diomadǝ na nurdǝyero isi, kǝndonjudǝ Alayen tǝdoro fǝledi nangaro.» ");
INSERT INTO kby_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngawo adǝyen Isa-a fuwurawanju-a cidi Yahudiyayero lejane kawu ganaro tayi-a rokko napce ambo kasala kiddo. ");
INSERT INTO kby_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nawi Yahaya ye na Ainon cani karǝn bǝla Salimben ambo kasala cǝddi, nadǝn ingi ngǝwu mbeji nangaro. Am nanjuro isane tayiro kasala cǝddi. ");
INSERT INTO kby_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sadǝn Yahayaa kosoro casakkǝnni duwon. ");
INSERT INTO kby_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Daji fuwurawa Yahayaye laa-a yaudi laa-a kǝla tayirro walduyen kambiwu badiyera. ");
INSERT INTO kby_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na Yahayayero isane tiro: «Sayinna, kam ni-a rokko ci bǝrǝm Jordaniye todǝyen, koro kǝlanjun shedanǝmmadǝ, akkonju ambo kasala cǝddi, koro am samma nanjuro lejai,» yera. ");
INSERT INTO kby_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahayaye tayiro: «Kam rakce awima cuwandiwawo, awo samelan tiro tinadǝ gǝnia. ");
INSERT INTO kby_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nayi kǝlandoma wu adǝa wullǝkkǝnaro shedasuwi: “Wu gǝni Almasiwudǝ wo, amma wu kam Ala tin fuwunno cunodǝnadǝ.” ");
INSERT INTO kby_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kam njuduamadǝ tima mai larusayedǝ wo. Koro sawa gǝrenjun daada tia kǝrǝnjimadǝ kowo sawanjuye fanjiya, karwunju jauro kǝjiji. Adǝ nangaro karwukǝjini adǝ kalkallo waljǝna. ");
INSERT INTO kby_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sai tidǝ kuraje, wu ye tǝngǝɍinǝkkiya. ");
INSERT INTO kby_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Kam duwon samelan isǝnamadǝ sammaa kojǝna. Kam duwon cidilan dǝganamadǝ cidiyedǝma, koro awo cidiyedǝmaa manaji. Kam duwon samelan isǝnamadǝ sammaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Awo curuna-a fanjǝna-aa shedaji, amma wunduma shedanju kasacciwawo. ");
INSERT INTO kby_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kam duwon shedanju kasaccǝnamadǝ Alaa jiremaro tabbaccǝgǝna. ");
INSERT INTO kby_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Awoa kam Ala cunodǝnamadǝ mana Alaye manaji, Ala tiro Ruhunju dadu bawoaro cina nangaro. ");
INSERT INTO kby_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bawadǝ Tadadǝa cǝraana, koro awo sammaa mukkonjuro cakkǝna. ");
INSERT INTO kby_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kam Tadadǝa kasaccǝnamadǝ ro sawisoye cuwandǝna. Amma kam Tadadǝa kasattu wajǝnamadǝ ro cuwandiwawo, gǝrgadu Alaye tilan dǝgai,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Isa Yahayaa kojǝnaro fuwurawa cuwande tayiro kasala cǝddidǝa Farisawa fanjanaro Isa asuyeno. ");
INSERT INTO kby_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Adǝ yaye Isa ti kǝlanju gǝni, fuwurawanju ambo kasala caddi. ");
INSERT INTO kby_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Daji cidi Yahudiyayea kolje cidi Galileyero wallada. ");
INSERT INTO kby_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Amma sai cidi Samariyayen reje kojiya duwon. ");
INSERT INTO kby_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Adǝgaima Isa bǝla laa cidi Samariyaye tiro Sakar cani karǝn kulo Nawi Yakuba tadanju Nawi Isuwuro cinadǝro kadio. ");
INSERT INTO kby_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nadǝn baram Yakubaye mbeji, koro kausu kǝla dawu, Isa ye bǝlawuroro cǝmbarǝna, ise ci baramdǝyen napkeno. ");
INSERT INTO kby_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kamu Samariyaye laa ingi gudoro kadio. Isaye tiro: «Ingi se yakke!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sa adǝn fuwurawanju awo kǝmboye njuworo bǝlaro lejana. ");
INSERT INTO kby_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Amma kamu Samariyayedǝye tiro: «Ni yaudi, wu ye kamu Samariyaye, awiawin wua ingi kǝnjayero suworǝmi?» Awoa caman yaudiya-a Samariyawu-a tawaktaiwawo. ");
INSERT INTO kby_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isaye tiro: «Ca kǝnjo Alayea-a wundu ingi kǝnjayero njuworǝnaa-a nonǝmmaa, nima tia korǝme ingi roye niro nji,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kamudǝye tiro: «Kǝma, karwi ye tammi, baram ye kuruwu. Ndaran ingi roye adǝa fandǝmi? ");
INSERT INTO kby_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ra, nidǝ kaarinde Nawi Yakuba ti duwon andiro baram adǝa sade ingi ti kǝlanju cane tadawanju-a lǝmannanju-a ye casanadǝmaro wa kura wo?» ");
INSERT INTO kby_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isaye tiro: «Wundu duwon ingi adǝa canadǝ nangadembo ngudu fanji, ");
INSERT INTO kby_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amma wundu duwon ingi tiro yikkidǝa canadǝ tǝmmaro ngudu fanjiwawo. Ingi tiro yikkidǝ curonjun sim ingi royero walje har ro sawisoyero bǝlbǝldi.» ");
INSERT INTO kby_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kamudǝye tiro: «Kǝma, ingi adǝa wuro se, kua adǝn fuwun bare ngudu fakke ingi gudoro na adǝro waldǝkke isǝkkǝniro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isaye tiro: «Lene kwanǝm bowone, na adǝro arowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kamudǝye: «Kwa takkǝni,» yenniya, Isaye tiro: «“Kwa takkǝni,” nǝmmadǝ, jirenǝm. ");
INSERT INTO kby_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Amma kwa uwu dim, koro ti kǝrma rokko dǝgawwadǝ kwanǝm gǝni. Awo wullǝmmadǝ jire,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Daji kamudǝye tiro: «Kǝma, ni nawiro asunǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kaariyandeso kǝla kau kuruwu adǝyen Alaro ambǝtkeyera, amma nayidǝ na Alaro ambǝttuwuyedǝ sai Jerujalemnin nuwi.» ");
INSERT INTO kby_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isaye kamudǝro: «Wua sasarai, sa laa ise Bawadǝro kǝla kau kuruwu adǝyen gǝni bi Jerujalemlan gǝni ambǝtkǝwi. ");
INSERT INTO kby_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nayidǝ awo nonuwwiro ambǝtkǝwi. Andidǝ awo noniyenaro ambǝtkǝiye, awoa njǝkkawodǝ yaudiyayen isi. ");
INSERT INTO kby_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amma sadǝ isi har isǝnama, ambǝttuwuwu jireyedǝ Bawadǝro curo ruhu-a jire-ayen ambǝccagai, dalilnjudǝ Bawadǝ am jiɍi anima tiro ambǝccaaro maji nangaro. ");
INSERT INTO kby_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Aladǝ Ruhu, am tiro ambǝccagaidǝ sai curo ruhu-a jire-ayen ambǝccaa!» ");
INSERT INTO kby_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kamudǝye tiro: «Almasiwu kam tiro Kǝristi canidǝ isiro nokkǝna. Isiya, andiro awo sammaa isanosagai,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Daji Isaye tiro: «Wu niro mananjǝgǝkkidǝ, wuma ti wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa adǝn fuwurawanju isane Isa kamuro mana cǝddidǝa ajapkera, amma wundunjama kamudǝro: «Awi raam?» bi Isaro: «Awiro tiro managǝmi?» wuljǝnni. ");
INSERT INTO kby_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Daji kamudǝ bulenju kolje bǝlaro walde ambo: ");
INSERT INTO kby_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Arowo, kam awo dikkǝna sammaa wulsǝgǝnaa ruiwo! Waneye tima Almasiwudǝ wo?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jamadǝ na Isayero leduro bǝladǝn keluwo. ");
INSERT INTO kby_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa adǝn fuwurawadǝ tia lowojane: «Sayinna, masǝna de!» cani. ");
INSERT INTO kby_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amma tayiro: «Kǝmboni nonuwwi mbeji,» yenniya, ");
INSERT INTO kby_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","fuwurawadǝ kattenjan: «Kam laa tiro kǝmbo cukkudǝna wa?» cani. ");
INSERT INTO kby_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isaye tayiro: «Kǝmbonidǝ tima awo ti wua sunodǝnamadǝ cǝraanadǝa dio-a kidanju tumoduwu-adǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nayiye: “Kaladǝro kǝndawu dewu gapco,” nuwi, gǝna? Wu nayiro wulnjagakki, kǝla sammowo kulowadǝ kaladǝro basawunaro ruiwo! ");
INSERT INTO kby_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kam kalajimadǝ alwasi cuwande nema ro sawisoyero capciyi. Adǝgaima kam cǝnadimadǝ-a kam kalajimadǝ-a rokko karwunja kǝjiji. ");
INSERT INTO kby_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kǝla adǝyen awo wuldǝnadǝ jire: “Kam laa cǝnadi, kam laa ye kalaji.” ");
INSERT INTO kby_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nayia awo kidanuwwi kaladuro ngenodǝkko. Am gade kidadǝa cado, nayi ye barga kidanjaye kiwanduw.» ");
INSERT INTO kby_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariyawu bǝla adǝn dasaana kada Isaa kasatkera, kamudǝye shedaje: «Awo dikkǝna sammaa wulsǝgǝna!» cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nanjuro kadiranniya, nanjan napcoro tia lowojane Isa kawu yindiro napkeno. ");
INSERT INTO kby_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mananju nangaro am kada ye cayemaa kojǝnaro tia kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Daji kamudǝro: «Kǝrma awo wullǝmmadǝ gǝni nangaro tia kasatkeiye. Andi kǝlandema ye tia fanniyena, koro jiremaro tima Njǝkkayima duniayedǝ woro noniyena!» yera. ");
INSERT INTO kby_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngawo kawu yindiyen Isa bǝladǝa kolje cidi Galileyero leyeno. ");
INSERT INTO kby_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caman Isa kǝlanjuma nawi bǝlanjan daraja cǝdanni cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cidi Galileyero kadinniya, am cididǝye tia ngǝlaro sosayera. Tayidǝ awo Isa Jerujalemnin sa salayen cǝdǝna sammaa caruna, dalilnjudǝ tayi ye saladǝro lejana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Daji Isa walde bǝla Kana cidi Galileye na ingia dibenno kalakcǝnadǝro kadio. Bǝrni Kafarnaambelan kowona laa mbeji, tadanju dondi. ");
INSERT INTO kby_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kowonadǝ Isa cidi Yahudiyayea kolje Galilero isǝnaro fangenniya, nanjuro leje tia lowoje iso tadanju no cǝdidǝa isangajuwo yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isaye tiro: «Alama so, awo ajabba so kiruw gǝnia, tǝmmaro yasarawwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kowonadǝye tiro: «Kǝma, kawu tadani nuiro are!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isaye tiro: «Lene, tadanǝm ronjua!» yenniya, kamdǝ mana Isa tiro wuljǝgǝnadǝa kasacce leyeno. ");
INSERT INTO kby_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ledu cǝdi duwon, wolodiyanju tia kapcagane tiro: «Tadanǝm ronjua,» yera. ");
INSERT INTO kby_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sa tadanju ngajǝnadǝa kiworǝnniya, tiro: «Bikka sa fal kausuyen kangedǝ tia kolyeno,» yera. ");
INSERT INTO kby_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bawadǝ sa adǝman Isaye tiro: «Tadanǝm ronjua!» cǝnnadǝro asuyeno. Daji ti-a am fannjuye samma-a Isaa kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Adǝma alama ajabba yindiye Isa ngawo cidi Yahudiyayea kolje cidi Galileyero isǝnayen cǝdǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ngawo adǝyen ngǝmǝri yaudiyaye laa kidǝnniya, Isa Jerujalembo leyeno. ");
INSERT INTO kby_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerujalemlan karǝn Ngaworam Dimiyayedǝn falwu ingiye ngurwo uwua mbeji, tǝlam yaudiyaudin tiro Baitsata cani. ");
INSERT INTO kby_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngurwo anin am dondi kada bowada mbeji: kambuwa so, ngurdiyiya so, am tiyinja nuna so. Ingidǝye bǝljǝmdunju gurejai, ");
INSERT INTO kby_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","dalilnjudǝ sa laa sa laan malaiya Kǝmandeye jǝpce ingidǝa bǝljǝmji nangaro. Wundu duwon ingi bǝljǝmjǝnadǝro burwon ngaanamadǝ, kǝndondi jiɍi fi tilan dǝga yaye, ngaji. ");
INSERT INTO kby_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nadǝn kam laa kǝrwu fiakkun wuskunno dondi mbeji. ");
INSERT INTO kby_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Isa kamdǝa bowada kirunniya, koro nadǝn jauro tussǝnaro nojǝnadǝ, tiro: «Ngadu raamma wa?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kam dondidǝye tiro: «Kǝma, sa ingidǝ bǝljǝmjiya, kam nanin wua ingidǝro sakki bawo. Koro ledu dikki duwon, kam gade wua burwose ngayi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isaye tiro: «Cine bǝnarammǝm ngone lene!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sadǝman kamdǝ ngaje bǝnaramnju ngoje ledu badiyeno. Yim adǝ yim tustuye. ");
INSERT INTO kby_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Adǝ nangaro yaudiyadǝye kam ngajǝnadǝro: «Yim tustuyea bǝnarammǝm ngodu niro amardǝgǝnni,» yera. ");
INSERT INTO kby_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tayiro: «Kam duwon wua isangasǝgǝnadǝ, tima wuro: “Bǝnarammǝm ngone lene!”» yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tayiye tiro: «Wundu kam duwon niro bǝnarammǝm ngone lene cǝnnadǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amma kam ngajǝnadǝ ti wundumaro nojǝnni, Isa curo jamadǝyero kǝldǝgǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngawo adǝyen Isa kamdǝa Fado Alayen najiye tiro: «Akko nganǝmma! To, biwu dio kolle, bare awo laa jauro diwi adǝa kojǝna nia njuwandǝnniro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Daji kamdǝ leje yaudiyadǝro Isama tia isangajuwo yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Isa awo ania yim tustuyea cǝdǝna nangaro, yaudiyadǝ tiro niadiwi fǝleduwu badiyera. ");
INSERT INTO kby_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Amma Isaye tayiro: «Bawani ku kundenno kida cǝdi, wu ye kida dikki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Adǝ nangaro yaudiyadǝ cayemaa kojǝnaro tia roro njejoro mayera. Yim tustuyea awo dioro dapkada runju gǝni cǝdo, koro Aladǝma Bawanju wo cǝne Alaa gaskayeno. ");
INSERT INTO kby_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Daji Isaye yaudiyadǝro: «Jiremaro nayiro wulnjagakki, Tadadǝ kǝlanju awima rakce cǝdiwawo, sai awo Bawadǝ cǝdi curunadǝa. Koro awi yaye Bawadǝ cǝdidǝa Tadadǝ ye cǝdi. ");
INSERT INTO kby_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Awoa Bawadǝ Tadadǝa cǝraana awo ti kǝlanju cǝdi sammaa tiro fǝlejiyi. Koro kǝndo animaa kojǝna tiro fǝlejiyi, nayi ye jauro ajammoworo. ");
INSERT INTO kby_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jiɍi Bawadǝ am sanunaa cǝsange tayiro ro cidǝ gai, Tadadǝ ye kam cǝraanaro ro ci. ");
INSERT INTO kby_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bawadǝ wundumaro shara cǝddiwawo, amma shara sammaa mukko Tadadǝyero cakkǝna, ");
INSERT INTO kby_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","am nga Tadadǝro daraja cado, jiɍi Bawadǝro daraja cadidǝ gai. Kam Tadadǝro daraja ciwawomadǝ Bawa tia cunodǝnadǝro daraja ciwawo. ");
INSERT INTO kby_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jiremaro nayiro wulnjagakki, kam manani fanje ti wua sunodǝnadǝa kasaccǝnamadǝ ro sawisoye cuwandǝna. Shara tia cǝdaiwawo, amma karmoro kaje ro cuwandǝna. ");
INSERT INTO kby_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Jiremaro nayiro wulnjagakki, sadǝ isi har isǝnama, sa duwon am sanuna kowo Tada Alayedǝa fanjai, koro tayi fanjanamadǝ roa dasayi. ");
INSERT INTO kby_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jiɍi Bawadǝ fǝrdu royedǝ gai, ngaima cakke Tadadǝ ye fǝrdu royero waljǝna. ");
INSERT INTO kby_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Koro kǝnduwo shara kamdaye tiro cina, dalilnjudǝ tima Tada Kambedǝ wo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bare adǝa ajammuwwi, sa ise am kaurilan samma kowonju fanjane ");
INSERT INTO kby_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","caluwi. Am duwon awo ngǝla cadǝnamasodǝ roaro cijai, amma am duwon awo diwi cadǝnamasodǝ shararo cijai. ");
INSERT INTO kby_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Wu runi awima rangǝkke dikkiwawo. Jiɍi fakkidǝ gai, shara dikki. Koro sharani ye jire, dalilnjudǝ awo raakkǝna gǝni, awo ti wua sunodǝnamadǝ cǝraanaa dioro makki nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Wu kǝlanin kǝlani shedamaro walyekkoa, shedanidǝ jire gǝni. ");
INSERT INTO kby_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Shedamani gade mbeji, koro sheda kǝlanin cǝdidǝ jirero nokkǝna. ");
INSERT INTO kby_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yahayaro am yikkunoduwwa, ti ye jiredǝa shedajo. ");
INSERT INTO kby_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wudǝ kamben gǝni sheda makki, amma njǝkkawo fandoworo awo ania wullǝkki. ");
INSERT INTO kby_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahayadǝ fatǝla waskada nur ci. Sa ganaro karwukǝjia curo nurnjuyen nammuwwa. ");
INSERT INTO kby_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amma shedani sheda Yahayayea nankuran kojǝna, dalilnjudǝ kǝndo Bawadǝ wuro tumogǝkkoro sinadǝ, wotte kǝndo dikkidǝma Bawadǝ wua sunodǝnaro kǝlanin shedasi nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Koro Bawa wua sunodǝnadǝ, tima kǝlanin shedajo. Amma nayidǝ ngaltema kowonju fannuwwi, fasalnju ye ruwwi, ");
INSERT INTO kby_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","koro mananju ye karwundon napcǝnni, dalilnjudǝ kam cunodǝnadǝa kasadduwwi nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kitawuwadǝa kǝla hangallayen kǝranuwi, tayilan ro sawisoye fanduwiro tǝmanuwwa nangaro, amma kitawu anima kǝlanin sheda cado! ");
INSERT INTO kby_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Adǝ yaye naniro isuwe ro sawisoye fandoro wayew. ");
INSERT INTO kby_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Amben gǝni daraja makki. ");
INSERT INTO kby_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Amma nayia nonjakkǝna, kǝrawo Alaye karwundon bawo. ");
INSERT INTO kby_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cu Bawaniyen kadikko, amma wua moworo wasew. Kam gade cu kǝlanjuyen kadioa, tia mowuwi. ");
INSERT INTO kby_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nayi daraja kattendon manuwi, amma daraja Ala runjuyen isidǝa manuwwawodǝ, ndayilan gǝle ranguwe wua sasarawi? ");
INSERT INTO kby_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bare wuma nayia na Bawadǝyen ngadarnjakkiro tǝmanuwwi. Ngadarmandodǝ tima Nawi Musa wo, kam duwon tǝmando tiro yakkuwwadǝ. ");
INSERT INTO kby_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ca Nawi Musaa jiremaro yasarawwaa, wu yea sasarawi, kǝlanin ruwujǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amma awo ruwujǝnadǝa yasarawwia, ndayin gǝle manani yasarawi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngawo adǝyen Isa bǝrǝm Galileye tia bǝrǝm Tiberiyasselan bowojaidǝye cinju todǝro koyeno. ");
INSERT INTO kby_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jama kada ye tia geya, alama ajabba ajabba kǝla am dondiyen cǝdi caruna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Daji Isa kǝla kau kuruwu laayero juwane fuwurawanju-a rokko napkera. ");
INSERT INTO kby_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Akko sala Laya Njǝkkayirambe sala yaudiyayedǝ karǝnjǝna. ");
INSERT INTO kby_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Isa kǝla sapce jama kada nanjuro isairo kirunniya, Filibusso: «Ndaran burodi yuwiye am ani jagaroro?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Adǝa wuldunjudǝ, Filibussa rijapturo, dalilnjudǝ Isa kǝlanjuma awo cǝdidǝa nojǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Daji Filibusse tiro: «Wundunja yaye burodi gana laa cuwandoro dinariyus yer yindima cǝdiwawo!» ");
INSERT INTO kby_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Fuwurawadǝye falnja Andarawus yaana Siman Biturusse tiro: ");
INSERT INTO kby_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Akko na adǝn tadaana laa burodi sayirre uwu-a buni yindi-a cǝdana mbeji, amma am ngǝwu aniro awi cǝddi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Isaye tayiro: «Jamadǝa yakkowo napca,» yeno. Nadǝn kajim kǝɍi tǝnas mbeji nangaro, amdǝ napkera. Tayi kongwadǝ alama dǝwu uwu gai. ");
INSERT INTO kby_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Daji burodidǝa ngoje Alaro ardiyenniya, am napkadadǝro dagaryeyeno. Bunidǝ yen ngai cǝde, har mǝradunja galyeno. ");
INSERT INTO kby_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jawune kulyeranniya, Isaye fuwurawanjuro: «Njongowa gapcanadǝa cammowo, bare awima faccǝgǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Adǝgaima njongo burodi uwu sayirre am jawune koljanayedǝa capcane jowo mewun yindin kesǝmbǝɍo. ");
INSERT INTO kby_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jamadǝ alama ajabba Isa cǝdǝnadǝa kerunniya, tayiye: «Jiremaro kam adǝ tima nawi duniaro isimadǝ wo!» cani. ");
INSERT INTO kby_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Adǝ nangaro isane tia dunodunon cadane mairo cadiro asuyenniya, Isa tayia kolje runju tok kǝla kaudǝyero walde giwa. ");
INSERT INTO kby_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dunia kajiriyenniya, fuwurawa Isayedǝ ci bǝrǝmbero jǝpcagane ");
INSERT INTO kby_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","maararo ngasaye kanji bǝrni Kafarnaambero faljane kodu badiyera. Dunia lǝmjǝna, Isa ye koroma tayia najǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Karuwa dunoa cije fuje, har bǝrǝmdǝ jauro camballadan. ");
INSERT INTO kby_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kilometǝr uwu bi arakku gairo ledu kedǝnniya, Isa kǝla ingiyen silan leje maaradǝa karǝnji kero. Kerunniya, jauro riyera. ");
INSERT INTO kby_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amma Isaye tayiro: «Wuma, bare rinuwwi!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Daji fuwurawadǝ karwu kǝjiaro curo maaradǝyen tia camoye kǝrgaanniyama, maaradǝ na lejaidǝro kadio. ");
INSERT INTO kby_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wajǝnanjua jama ci bǝrǝmbe todǝn napcanadǝ maara falma nadǝn dǝgaro asuyera. Koro Isa maaradǝro fuwurawanju-a rokko ngaanni, amma runja leyeraro nojana. ");
INSERT INTO kby_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Daji maarawa gade bǝla Tiberiyasselan karǝn na Kǝma Isa Alaro ardije burodi jagǝrǝnadǝyero kadira. ");
INSERT INTO kby_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jamadǝ Isa ye bawo, fuwurawanju ye baworo kerunniya, daji maarawadǝro ngasaye bǝrni Kafarnaambero tia maduro leyera. ");
INSERT INTO kby_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jamadǝ ci bǝrǝmbe todǝn Isaa kewandǝnniya, tiro: «Sayinna, sawi na adǝro kadim?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isaye: «Jiremaro nayiro wulnjagakki, alama ajabba ajabba ruwwa nangaro gǝni, burodi ngǝruwe kulluwwa nangaro wua masuwi. ");
INSERT INTO kby_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bare kǝmbo njǝpci adǝro kida diwwi, amma kǝmbo ro sawisoyero kida dewo, kǝmbo duwon Tada Kambedǝ nayiro njadidǝ, awoa Ala Bawadǝ tawa kǝnduwonjuyedǝa Tada Kambedǝro gǝnajǝgǝna.» ");
INSERT INTO kby_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Daji tiro: «Kida Alayedǝa dioro awi gǝle diye?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isaye tayiro: «Kida Alayedǝ tima kam cunodǝnadǝa kasaddowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tiro: «Alama ajabba jiɍi fi dime ruiye nia kasannjiye? Awi gǝle dimi? ");
INSERT INTO kby_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kaariyande kǝmbo tiro man canidǝa karaalan jawuna, kitawulan ruwuwadadǝ gai: “Tayiro kǝmbo samelan isǝnadǝa jaworo kaino.”» ");
INSERT INTO kby_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isaye: «Jiremaro nayiro wulnjagakki, Nawi Musa gǝni kǝmbo samelan isǝnadǝa njado, amma Bawanima nayiro kǝmbo jireye sameyedǝa njadi. ");
INSERT INTO kby_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Awoa kǝmbo Alayedǝ, tima kam samelan jǝpce duniaro ro sawisoye cimadǝ wo!» ");
INSERT INTO kby_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Daji tiro: «Kǝma, sawisoro kǝmbo adǝa andiro sadǝne!» yera. ");
INSERT INTO kby_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isaye tayiro: «Wuma kǝmbo ro fandoyedǝ wo! Kam naniro isǝnamadǝ tǝmmaro kǝna fanjiwawo, koro kam wua mǝrsasǝnamadǝ ye tǝmmaro ngudu fanjiwawo. ");
INSERT INTO kby_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amma nayiro wulnjagakkǝna, wua suruwwa duwon, njasarairo wayew. ");
INSERT INTO kby_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Am duwon Bawadǝ wuro sina samma naniro isai, koro kam naniro isǝnadǝa tǝmmaro wakkiwawo. ");
INSERT INTO kby_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Awo karwuni cǝraana gǝni, awo ti wua sunodǝnadǝ cǝraana dioro samelan jǝpkekko. ");
INSERT INTO kby_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Awo ti wua sunodǝnadǝ cǝraanadǝ tima am wuro sinadǝye falmaa fuddǝkkiwawo, amma yim daryeyea tayia karmolan sangǝkki. ");
INSERT INTO kby_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Akko awo Bawani cǝraanadǝ, wundu duwon Tadadǝa cure kasaccǝnadǝ ro sawisoye cuwandi, koro yim daryeyea wu ye tia karmolan sangǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tima kǝmbo samelan isǝnadǝ wo cǝnna nangaro, yaudiyadǝ karwunja waje: ");
INSERT INTO kby_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","«Ti adǝ Isa tada Isuwuye, gǝna? Bawanju-a yanju-aa noniyena, gǝna? Ndayin gǝle samelan kadikko cǝni?» yera. ");
INSERT INTO kby_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Isaye tayiro: «Bare karwundo wajǝnni! ");
INSERT INTO kby_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wunduma rakce naniro isiwawo, sai Bawa wua sunodǝnamadǝ tia gǝrjiyiya. Wu ye yim daryeyea tia karmolan sangǝkki. ");
INSERT INTO kby_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akko awo curo kitawuwa nawiyayen ruwuwadadǝ: “Tayi sammaa Ala alamji.” Wundu duwon Bawadǝa fanje asujǝnamadǝ naniro isi. ");
INSERT INTO kby_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ti Alayen isǝnadǝro kajia, wunduma Bawadǝa curunni. Tidǝ Bawadǝa curuna. ");
INSERT INTO kby_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jiremaro nayiro wulnjagakki, kam wua mǝrsasǝnamadǝ ro sawisoye cuwandi. ");
INSERT INTO kby_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","«Wuma kǝmbo ro fandoyedǝ wo! ");
INSERT INTO kby_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kaariyando kǝmbo tiro man canidǝa karaan jawuna, koro sanuna. ");
INSERT INTO kby_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amma kam duwon kǝmbo samelan isidǝa juwuidǝ, nuiwawo. ");
INSERT INTO kby_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wuma kǝmbo ro fandoye samelan isǝnadǝ wo. Kam kǝmbo adǝa juwuia, sawisoro dǝgai. Kǝmbo duwon duniaro ro sawisoye cawandoro yikkidǝ, tima da tiyiniye wo.» ");
INSERT INTO kby_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Adǝ nangaro yaudiya kattenjan kambiwu cade: «Ndayin gǝle rakce da tiyinjuye sade ngǝriyo?» cani. ");
INSERT INTO kby_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isaye: «Jiremaro nayiro wulnjagakki, da tiyi Tada Kambedǝa ngǝruwwawoa, bunju ye yawwawoa, nayilan ro bawo. ");
INSERT INTO kby_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kam duwon dani jǝgǝre buni caimadǝ ro sawisoye cuwandǝna, koro wu ye yim daryeyea tia karmolan sangǝkki. ");
INSERT INTO kby_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Dani ye kǝmbo jireye, buni ye kǝnja jireye. ");
INSERT INTO kby_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kam dani jǝgǝre buni caimadǝ wulan dǝgai, wu ye tilan dǝgakki. ");
INSERT INTO kby_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jiɍi Bawa Kǝndǝgaima wua sunode ti nangaro wu ye roa dǝgakkidǝ gai, kam duwon wu kǝmbonju womadǝ, wu nangaro ti ye roa dǝgai. ");
INSERT INTO kby_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Adǝma kǝmbo jireye samelan isǝnadǝ wo, jiɍi kaariyandoso jawune sanunadǝ gai gǝni. Kam kǝmbo adǝa juwunamadǝ sawisoro dǝgai,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Curo dandal bǝrni Kafarnaamben jamadǝa alamji duwon, Isa awo ania wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Fuwurawa Isaye ngǝwunja adǝa fangeranniya, tayiye: «A! Mana adǝ jauro jau! Wundu gǝle rakce tia fanji?» yera. ");
INSERT INTO kby_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Isa karwunja mana adǝa wajiro asuyenniya, tayiro: «Adǝ cakke talluwi wa? ");
INSERT INTO kby_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","To, Tada Kambedǝ nanju caye dǝganadǝro walde leji ruwia, nda? ");
INSERT INTO kby_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhu Alaye tima ro njomadǝ wo, kǝnduwo kambedǝ awimaro faidajiwawo. Mana nayiro wulnjagakkǝnadǝ ruhu ye, ro ye. ");
INSERT INTO kby_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amma curondon am laa kasaccanni mbeji,» yeno. Tǝn badiduramnin Isa am tia kasaccannidǝ-a kam tia sǝrǝcciyidǝ-aa nojǝna. ");
INSERT INTO kby_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Daji Isaye: «Adǝma nangaro nayiro wulngeyerakko, wunduma rakce naniro isiwawo, sai Bawadǝ tiro amarjiyiya duwon,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kǝla adǝyen fuwurawa Isaye ngǝwunja tia ga koljane ngaworo walladara. ");
INSERT INTO kby_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Daji Isaye mewun yindindǝro: «Nayi ye wua kolsuwiya, raawwa wa?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siman Biturusse tiro: «Kǝma, na wunduyero gǝle leniye? Nima mana ro sawisoyea wo! ");
INSERT INTO kby_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yasaraiyena ye, noniyena ye, nima Tayir Alayedǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isaye tayiro: «Wu gǝna nayi mewun yindindǝa kǝrenjakko? Amma kamndo fal sedan!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Adǝa kǝla Yahusa tada Siman Iskariyotten wulyeno, dalilnjudǝ tima mewun yindindǝye falnja mukko kǝladowayero Isaa sǝrǝcciyidǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngawo adǝyen Isa cidi Galileyen didiriyeno. Cidi Yahudiyayen didiridu cǝraanni, yaudiyadǝ tia roro njejoro majai nangaro. ");
INSERT INTO kby_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ngǝmǝri Leimaye sanju karǝngenniya, ");
INSERT INTO kby_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","yaanawa Isaye tiro: «Na adǝn cine cidi Yahudiyayero lene, fuwurawanǝmsodǝ ye kida dimidǝa caroro. ");
INSERT INTO kby_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kam nowadaro waldu cǝraanamadǝ awo cǝdidǝa gǝrajiwawo. Awo ania dimia, duniaro fǝledǝgǝne!» yera. ");
INSERT INTO kby_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ase, yaananjudǝma tia kasaccanni. ");
INSERT INTO kby_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Daji Isaye tayiro: «Sani koroma cǝdǝnni, amma sandodǝ sawiso dabbargada. ");
INSERT INTO kby_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Duniadǝ rakce nayia wanjaiwawo, amma wua wasǝna, dalilnjudǝ kǝndonju diwi wullǝkki nangaro. ");
INSERT INTO kby_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nayidǝ na ngǝmǝridǝyero lenowo, wudǝ ngǝmǝri adǝro lekkiwawo, sani koroma cǝdǝnni nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Awo ania tayiro wulyeyenniya, cidi Galileyen napkeno. ");
INSERT INTO kby_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amma yaanawanjudǝ na ngǝmǝridǝyero leyeranniya, Isa ye federo gǝni, asǝrlan cije leyeno. ");
INSERT INTO kby_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yaudiyadǝ na ngǝmǝridǝyen tia majane: «Ti ndaran?» cani. ");
INSERT INTO kby_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Koro curo jamadǝyen am kada kǝlanjun kambiwu kedo. Laaye: «Ti kam ngǝla,» cani, laa ye: «A'a, amba cuwatki,» cani. ");
INSERT INTO kby_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amma wunduma kǝla Isayen federo mana cǝdiwawo, yaudiyadǝa rijana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Daji ngǝmǝridǝ dawunjun duwon, Isa Fado Alayero ngaye jamaa alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yaudiyadǝ ajapcane: «Kam adǝ ngaltema kǝrajǝnnidǝ, ndayin kitawudǝa noyeno?» cani. ");
INSERT INTO kby_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Isaye tayiro: «Alamdunidǝ wuye gǝni, ti wua sunodǝnadǝye. ");
INSERT INTO kby_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kam awo Ala cǝraanadǝa dio cǝraanaa, alamdudǝ wuye gǝni, Alayero noji. ");
INSERT INTO kby_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kam ngumnjun mana cǝdimadǝ daraja kǝlanjuye maji, amma kam tia cunodǝnadǝye daraja majidǝ, tidǝ jirema, koro tilan jirenambu bawo. ");
INSERT INTO kby_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nawi Musa nayiro Attauradǝa njadǝna, gǝna? Amma wundundoma wadawanjudǝa jǝgaiwawo. Awiro wua roro njejoro manuwi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jamadǝ tiro: «Ni karuwama! Wundu nia njejoro maji?» yera. ");
INSERT INTO kby_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isaye tayiro: «Awo ajabba fal kidǝkkǝniya, nayi samma ajapkew! ");
INSERT INTO kby_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nawi Musa wada kajaduye njadǝna, adǝ yaye kajadǝ tiyen gǝni, kaariyadǝyen kadio, koro yim tustuyea kam kajanuwi. ");
INSERT INTO kby_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bare wada Nawi Musaye ganambu tǝdǝnniro yim tustuyea kam kajanuwia, awiro gǝle kǝla yim tustuyea kam sǝramba isangagǝkkǝnayen wuro gǝrgasǝgǝwi? ");
INSERT INTO kby_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bare kuro simben shara diwwi, amma kǝla jireyen shara dewo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Daji am Jerujalembe laaye: «Tima gǝna kam duwon tia roro njejoro majaidǝ? ");
INSERT INTO kby_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Akkonju federo mana cǝdi duwon, awima tiro wuljaganni. Ra, jiremaro wurawandedǝ tia Almasiwuro asujana wa? ");
INSERT INTO kby_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na kam adǝ isǝnadǝa noniyena. Amma Almasiwudǝ isiya, wunduma na isǝnadǝa nojiwawo,» yera. ");
INSERT INTO kby_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Daji Isa Fado Alayen jamadǝa alamdu cǝdi duwon, kowo sapce: «Wua nosuwwa, koro na isǝkkǝnadǝ yea nonuwwa. Ngumnin gǝni kadikko, amma ti wua sunodǝnamadǝ jirema. Tia nonuwwi. ");
INSERT INTO kby_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wu tia nokkǝna, dalilnjudǝ nanjun kadikko, koro tima wua sunodo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Adǝ nangaro Isaa taro mayera, amma wunduma tiro mukko gǝnajǝgǝnni, sanju koroma cǝdǝnni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Curo jamadǝyen ngǝwunja tia kasaccane: «Almasiwu isiya, alamaso kam adǝ cǝdǝnadǝa kojǝna cǝdi wa?» cani. ");
INSERT INTO kby_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisawa jamadǝ awo ania kǝla Isayen wuljai fangeranniya, wurawa ɍimannaye-a Farisawa-a Isaa taro gureduwu Fado Alayea juwayera. ");
INSERT INTO kby_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Isaye tayiro: «Kawu ganaro nayi-a rokko dǝgakki, ngawo adǝyen na ti wua sunodǝnadǝyero waldǝkki. ");
INSERT INTO kby_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wua masuwi, amma suwanduwwawo. Na dǝgakkiro ranguwe isuwwawo.» ");
INSERT INTO kby_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Daji yaudiyadǝ kattenjan: «Ndara leji na duwon rangiye tia fandiyewawodǝ? Ra, yaudiya curo am lardu Gǝressero tatardaanadǝyero wa leje am Gǝressedǝa alamji? ");
INSERT INTO kby_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Awi maana awo wuljǝnadǝye? “Wua masuwi, amma suwanduwwawo. Na dǝgakkiro ranguwe isuwwawo.”» ");
INSERT INTO kby_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yim daryeye yim kura ngǝmǝridǝyea Isa cije daje kowo sapce: «Kam duwon ngudunjuamadǝ, naniro iso ca! ");
INSERT INTO kby_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kam wua kasansǝnamadǝ, kitawulan ruwuwadadǝ gai: “Ingi ro fandoye bǝrǝm gai karwunjun culuwe falalaji!”» ");
INSERT INTO kby_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Adǝa wuldunjudǝ, kǝla Ruhu Alaye am tia kasaccanamadǝ fuwun cawandiyen wulyeno. Amma sa adǝn Ruhudǝ koroma tinni, dalilnjudǝ Isa koroma darajanjuro ngaanni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jamadǝ mana ania fangeranniya, laanjaye: «Kam adǝ tima jiremaro nawidǝ wo!» cani. ");
INSERT INTO kby_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Laaye: «Kam adǝ tima Almasiwudǝ wo!» cani. Amma laaye koro: «Almasiwudǝ cidi Galileyen wa isi? ");
INSERT INTO kby_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ra, kitawulan Almasiwudǝ ti kaduwu Mai Daudaye, koro bǝla Baitalami na Mai Dauda dǝganadǝn isi cǝnna, gǝna?» ");
INSERT INTO kby_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Adǝgaima kǝla Isayen jamadǝ kǝwu yindiro yakkadara. ");
INSERT INTO kby_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Curonjan laanja tia taro mayera, amma wunduma tiro mukko gǝnajǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gureduwu Fado Alaye walladaranniya, wurawa ɍimannaye-a Farisawa-a tayiro: «Awiro Isaa kuduwwidǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Gureduwuye: «Ngalte wunduma kam adǝ gairo mana cǝdǝnni!» yera. ");
INSERT INTO kby_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Daji Farisawaye tayiro: «Nayi yea jambanjana wa? ");
INSERT INTO kby_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wurawa adinwuye bi Farisawaye kam laa tia kasaccǝna mbeji wa? ");
INSERT INTO kby_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amma jama Attaura Nawi Musaye nojanni adǝ baskuwada!» yera. ");
INSERT INTO kby_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Daji Nikodimus, ti duwon Farisawaye falnja na Isayero calan lejǝnadǝ, tayiro: ");
INSERT INTO kby_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kǝla wadandeyen kambe cinjun fanniye awo cǝdidǝa noniyendelan tiro shara yiddiyewawo, gǝna?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Amma tiro: «Ni ye kam Galileye wa? Kitawudǝa kǝrane rui, nawi fima cidi Galileyen culuwunni!» ");
INSERT INTO kby_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Daji wundu yaye fannjuro walladan. ");
INSERT INTO kby_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Isa Kau Jaitunnero leyeno. ");
INSERT INTO kby_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Suwa lǝp koro walde Fado Alayero leyeno. Am samma nanjuro isai duwon, napce tayia alamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Daji malǝmba Attauraye-a Farisawa-a kamu laa kǝnjǝna dio cǝdi cadanaa cawude dawunjan tia casakke dayeno. ");
INSERT INTO kby_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tayiye Isaro: «Sayinna, kamu adǝ kǝnjǝna dio cǝdi duwon, tia keda. ");
INSERT INTO kby_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Attauralan Nawi Musaye andiro wada sade jiɍi aniro kau gǝgǝpkǝiyo tayia roro yejiyo cǝnna. To, ni nda, awi wullǝm?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Adǝa wuldunjadǝ, Isaa rijapturo awo laa tia burwuduye cawandoro. Amma Isa nguje ngulondon cidi kurda badiyeno. ");
INSERT INTO kby_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tiro dama baworo koro caddi duwon, cije tayiro: «Kam curondon biwu bawomadǝ kamudǝro burwon kau gǝpcuwo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Koro walde nguje cidi kurda badiyeno. ");
INSERT INTO kby_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Adǝa fangeranniya, kuran tamiya ganaro kudero fal fallen saptane, har Isa runju kamu fuwunjun daadadǝa kolyera. ");
INSERT INTO kby_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Isa cije dayenniya, kamudǝro: «Ndaran tayi? Wunduma niro wowom gǝnanjǝgǝnni wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tiye: «Kǝma, wunduma wowomsǝnni,» yeno. Daji Isaye tiro: «Wu ye niro wowom gǝnanjǝgǝkkiwawo. Lene, amma adǝn fuwun bare gadero biwu dimmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Koro Isa walde jamadǝro mana cǝdde: «Wu nur duniaye. Wundu duwon wua sǝganamadǝ tǝmmaro curo duwuyen lejiwawo, nur roye cuwandi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisawaye tiro: «Ni kǝlanǝmlan kǝlanǝm shedanǝmi nangaro, shedanǝmdǝ jire gǝni,» yera. ");
INSERT INTO kby_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isaye tayiro: «Sheda kǝlaniye dikki yaye, shedanidǝ jire, dalilnjudǝ na isǝkkǝna-a na lekki-adǝa nokkǝna nangaro. Amma nayidǝ na isǝkkǝna-a na lekki-adǝa nonuwwi. ");
INSERT INTO kby_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nayidǝ ambo shara kuro kamben yidduwi, amma wu kam fimaro shara yiddǝkkiwawo. ");
INSERT INTO kby_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amma shara dikki yaye, sharanidǝ jire, dalilnjudǝ wu runi gǝni, Bawa wua sunodǝnadǝ-a rokko sharaniye nangaro. ");
INSERT INTO kby_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wadandoman ruwuwada sheda kam yindiyedǝ jire. ");
INSERT INTO kby_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wuma sheda kǝlaniye dikki, koro Bawa wua sunodǝnadǝ ye kǝlanin sheda cǝdi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Daji tiro: «Bawanǝmdǝ ndaran?» yeranniya, Isaye: «Wua nosuwwi, Bawani yea nonuwwi. Ca wua nosuwwaa, Bawani yea nonuwwa,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isa Fado Alayen alamdu cǝdi duwon, na sadaa fidaramben mana ania wulyeno. Amma wunduma tia cǝdanni, sanju koroma cǝdǝnni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Koro Isa walde tayiro: «Wu lekki, koro wua masuwi, koro curo biwundoyen nuwi. Na lekkidǝro nayidǝ ranguwe lenuwwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kǝla adǝyen yaudiyadǝye: «Kǝlanju ceji wa? Adǝmaro wa: “Na lekkidǝro nayidǝ ranguwe lenuwwawo,” cǝnidǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Isaye tayiro: «Nayi cidiye, amma wu sameye. Nayi dunia adǝye, amma wu dunia adǝye gǝni. ");
INSERT INTO kby_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Adǝma nangaro nayiro curo biwuwandoyen nuwi wulngeyerakko. Wuma ti woro kasadduwwia, curo biwuwandoyen nuwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tiro: «Ni wundu?» cane keworǝnniya, Isaye tayiro: «Awo tǝn badiduramnin wulnjagakkǝnadǝma. ");
INSERT INTO kby_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Awo ngǝwu kǝlandon wulduye-a sharaduye-a takkǝna, amma ti wua sunodǝnadǝ jirema, koro awo tiyen fakkǝnadǝmaa duniaro wulgǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Amma kǝla Bawadǝyen tayiro manajiyidǝro asujanni. ");
INSERT INTO kby_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Daji Isaye tayiro: «Tada Kambedǝa kǝskaro rogǝwiya, wuma ti woro nonuwi, koro awima kǝlaniro dikkiwawo, amma Bawa wua alamsǝnadǝ gai, awo ania wullǝkkiro nonuwi. ");
INSERT INTO kby_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ti wua sunodǝnadǝ wu-a rokko. Wua runi kolsǝnni, dalilnjudǝ sawisoye awowa cǝraanadǝa dikki nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sa Isa adǝa wuljidǝn, am kada tia kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Daji Isaye yaudiya tia kasaccanamadǝro: «Manani gawia, nayi jiremaro fuwurawani. ");
INSERT INTO kby_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jiredǝa nonuwi, jiredǝ ye nayiro nankam kǝlaye njadi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tiro: «Andi kaduwu Nawi Ibrahimbe, koro kaɍea wunduyemaro ngaltema walliyende! Ndayin nankam kǝlaye fandiye nǝmi?» yera. ");
INSERT INTO kby_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isaye: «Jiremaro nayiro wulnjagakki, wundu duwon biwu cǝdimadǝ kaɍea biwuye. ");
INSERT INTO kby_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kaɍeadǝ sawisoro gǝni fadon dǝgai, amma tadadǝ sawisoro dǝgai. ");
INSERT INTO kby_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adǝ nangaro Tadadǝ nankam kǝlaye njadiya, nankam kǝlayedǝa fanduwi, diye! ");
INSERT INTO kby_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nayi kaduwu Nawi Ibrahimbero nokkǝna, amma wua njejoro manuwi, dalilnjudǝ karwundoro manani ngayiwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wu awo na Bawaniyen rukkǝnadǝa wullǝkki, amma nayi awo bawandoyen fannuwwadǝa diwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tiro: «Bawandedǝ tima Nawi Ibrahimdǝ wo!» yera. Isaye tayiro: «Ca nayi kaduwu Nawi Ibrahimbea, kǝndo Nawi Ibrahim cǝdǝnadǝa diwi. ");
INSERT INTO kby_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kǝrma wu nayiro jire Alayen fakke wulnjagakkǝna duwon, wua njejoro manuwi. Nawi Ibrahim ngaltema adǝa cǝdǝnni! ");
INSERT INTO kby_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nayi kǝndo bawandoyedǝa diwi,» yenniya, tiro: «Andia ngǝriwu gǝni sesambo, bawande tilo Ala kǝlanjudǝma!» yera. ");
INSERT INTO kby_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isaye tayiro: «Ca Ala bawandoa, wua sǝraawi, dalilnjudǝ akkoni na Alayen kadikko. Kǝlani nangaro gǝni kadikko, tima wua sunodo. ");
INSERT INTO kby_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Awiro awo nayiro wulnjagakkidǝa asunuwwawodǝ? Dalilnjudǝ mananidǝa ranguwe fannuwwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bawando tima Yiwulis wo, awo bawando cǝraanadǝa diwiya, raawwa. Tǝn badiduramnin ti kamceji, koro kǝla jireyen dajǝnni, tilan jire bawo nangaro. Kattuwu kamjiya, halnju fǝleji, dalilnjudǝ ti kattuwuma, koro bawa kattuwuye nangaro. ");
INSERT INTO kby_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amma wudǝ jire wullǝkkidǝro, wua kasansuwwawo. ");
INSERT INTO kby_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wundundo biwu dikkǝnaro shedaji? Jire wullǝkkia, awiro wua kasansuwwawo? ");
INSERT INTO kby_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kam Alayedǝ mana Alayedǝa fanji. Dalil nayi fannuwwawoyedǝ, nayi Alaye gǝni nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Daji yaudiyadǝye tiro: «Ni kam Samariyaye karuwama niyenadǝ, jirende, gǝna?» yera. ");
INSERT INTO kby_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isaye tayiro: «A'a, wulan sedan bawo. Bawaniro daraja yikki, amma nayi wuro daraja njo wanuwwa. ");
INSERT INTO kby_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kǝlaniro darajadǝa magǝkkiwawo, amma Fal laa tia maji mbeji, tima sharamadǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jiremaro nayiro wulnjagakki, kam duwon mananidǝa ngojǝnamadǝ tǝmmaro nuiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yaudiyadǝye tiro: «Kǝrma nilan sedannaro noniyena! Nawi Ibrahim nuna, nawiya gade ye sanuna, amma niye: “Kam mananidǝa ngojǝnamadǝ tǝmmaro nuiwawo!” nǝmi. ");
INSERT INTO kby_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ni bawande Nawi Ibrahimdǝa konǝmma wa? Ti nuna, nawiya gade ye sanuna. Ni wunduro kǝlanǝm ngoyem?» yeranniya, ");
INSERT INTO kby_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isaye: «Kǝlaniro daraja yikkia, darajani faidanju bawo. Bawani daraja wuro si, ti duwon tiro Alando nuwidǝ. ");
INSERT INTO kby_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tia ngaltema nonuwwi, amma wu tia nokkǝna. “Tia nokkǝni,” wullǝkkia, kattuwuma nayi gairo wallǝkki. Amma tia nokkǝna, koro mananju ngokki. ");
INSERT INTO kby_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bawando Nawi Ibrahim karwu jauro kǝjiaro jamanni kuroro cǝraana. Tia cure karwunju kǝjijǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Daji yaudiyadǝye tiro: «Kǝrwu fiwuma tammi duwon, Nawi Ibrahimba rumma?» ");
INSERT INTO kby_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isaye: «Jiremaro nayiro wulnjagakki, kawu Nawi Ibrahim tambimaro, wu mbeji!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Adǝ nangaro dongur kauye tiro gǝptuwuro ngoyera, amma Isa gǝrade Fado Alayen kiluwo. ");
INSERT INTO kby_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isa kodu cǝdi duwon, kam laa kambu tambǝnaa kiro. ");
INSERT INTO kby_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Fuwurawanjuye tiro: «Sayinna, wundu biwu cǝde kam adǝ kambu katambo? Tima ra bawanju-a yanju-a?» cane tia keworo. ");
INSERT INTO kby_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isaye tayiro: «Biwunju nangaro gǝni bi biwu bawanjuye-a yanjuye-a nangaro gǝni, Ala tilan kǝndonju fǝlejoro kam adǝ kambu katambo. ");
INSERT INTO kby_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kausu duwon, dole kida ti sunodǝnadǝyedǝa diyo! Bunejiya, wunduma rakce kida cǝdiwawo. ");
INSERT INTO kby_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wu dunialan dǝgakki duwon, wu nur duniaye,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Awo ania wulyenniya, kanduɍi cidiro tǝwajiye dije ngoje sim kambudǝyero cingeyeno. ");
INSERT INTO kby_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Isaye tiro: «Lene, falwu ingi Silowamben lamdǝne!» yeno. Maana Silowambedǝ tunodǝna. Daji kambudǝ leje lamgadanniya, sim cuwande walladan. ");
INSERT INTO kby_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kǝmaskiyanju-a am calan tia lowo cǝdi caruna-adǝye: «Tima gǝna kam napkada lowo cǝdidǝ?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Laaye: «Tima!» cani, laa ye: «A'a, ti gǝni, camunonju,» cani. Amma kamdǝye: «Wuma, diye!» cǝni. ");
INSERT INTO kby_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Adǝ nangaro tiro: «Ndayin gǝle sim kiwandǝm?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tayiro: «Kam tiro Isa canidǝ cidi dije simmiro cinjiye wuro: “Lene, Silowamlan lamdǝne!” yeno. Daji lekke lamgadakkǝniya, sim kiwandǝkko!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tiro: «Kam attǝ ndaran?» yeranniya, tayiro: «Nokkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Daji kam calan kambudǝa na Farisawayero kewudo. ");
INSERT INTO kby_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yim duwon Isa cididǝa dije sim kambudǝye kajǝnadǝ yim tustuye. ");
INSERT INTO kby_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Koro Farisawadǝ waldane kamdǝa jiɍi fin sim kiwandoro keworo. Tayiro: «Cidi dije simmiro cinjiye lamgadakkǝniya, rukki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisawadǝye laanjaye: «Kam adǝ Alayen gǝni kadio, yim tustuyero daraja cinni nangaro,» cani. Amma laanjaye: «Awiawin biwuma rakce alamaso ngai cǝdi?» cani. Daji tayi kǝwu yindiro yakkadara. ");
INSERT INTO kby_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Koro Farisawadǝ waldane kambudǝro: «Awi kǝla kam simmǝm kajǝnadǝyen wullǝmi?» cane keworǝnniya, tiye: «Ti nawi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Amma yaudiyadǝ ti kambu duwon curuiro waljǝnadǝa njasarairo wajane har bawanju-a yanju-aa bowoyera. ");
INSERT INTO kby_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tayiro: «Adǝ tadando wa? Ti kambu katambo nuwidǝ? To, awiawin kǝrma curuiro walyeno?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bawanju-a yanju-aye: «Ti tadande ye, kambu katambo yero noniyena. ");
INSERT INTO kby_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma jiɍi fin kǝrma curuiro bi wundu simnju kajoro noniyende. Ti tadaana gǝni, tia korowo! Cinjuman wulji,» yera. ");
INSERT INTO kby_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bawanju-a yanju-a adǝa wuldunjadǝ, yaudiyadǝa rijana nangaro. Caman tayidǝ wundu duwon Isa Almasiwuro kasaccidǝa dandallan cattuluwi canna. ");
INSERT INTO kby_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Adǝma nangaro bawanju-a yanju-adǝye: «Ti tadaana gǝni, tia korowo!» yera. ");
INSERT INTO kby_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Koro caye baworo waldane yaudiyadǝ kam calan kambudǝa bowojane tiro: «Alaro daraja ye! Noniyena, kam adǝ biwuma,» yera. ");
INSERT INTO kby_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tayiro: «Ti biwuma bi biwuma gǝniro nokkǝni. Awo fal nokkǝna, wu kambu duwon kǝrma rukki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Daji tiro: «Awi niro njǝddo? Ndayin simmǝm kayeno?» cane keworǝnniya, ");
INSERT INTO kby_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tayiro: «Wulnjagakkǝnama, fannuwwi. Awiro gademinno fandu rawuw? Nayi ye fuwurawanjuro wa waldu rawuw?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tia rarajane tiro: «Nima fuwuranju wo, amma andidǝ fuwurawa Nawi Musaye! ");
INSERT INTO kby_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ala Nawi Musaro mana cǝddǝnaro noniyena, amma ti adǝ ndaran kadiomaro noniyende!» yera. ");
INSERT INTO kby_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kamdǝye tayiro: «Simmi kajǝnama, ndaran kadioro nonuwwidǝ jauro ajabba! ");
INSERT INTO kby_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ala biwuwua kǝrǝnjiwaworo noniyena, amma wundu duwon Alaro daraja ce awo cǝraanaa cǝdimadǝ, Ala tia kǝrǝnji. ");
INSERT INTO kby_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tǝn dunia alaktǝnayeman wunduma kam kambu tambǝnaye sim kajǝnadǝa ngalte fanjǝnni. ");
INSERT INTO kby_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kam adǝ Alayen gǝni kadioa, awima rakce cǝdiwawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tayiye tiro: «A! Ni curo biwuyen tambǝmma duwon andia alamsami!» cane tia deyaro kettuluwo. ");
INSERT INTO kby_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Isa kamdǝa dandaldǝn cattuluwunaro fangeno. Ti-a kattadǝranniya, tiro: «Tada Kambedǝa kasaddǝmma wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kamdǝye: «Kǝma, wundu ti wo duwon tia kasaddǝkkidǝ?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isaye tiro: «Tia rumma, koro tima niro mananjiyidǝ wo!» yenniya, ");
INSERT INTO kby_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","daji kamdǝye: «Kǝma, kasaddǝkkǝna,» cǝne tiro ambǝtkeyeno. ");
INSERT INTO kby_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Daji Isaye: «Shara kamduro dunia adǝro kadikko, am caruiwawomadǝ caroro, koro am caruimadǝ kamburo waljaro!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisawa nanjun dasaana laa mana adǝa fangeranniya, tiro: «A! Andi ye kambu wa?» yera. ");
INSERT INTO kby_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isaye tayiro: «Ca nayi kambua, biwundo bawo, amma kǝrma: “Ruiye!” nuwi nangaro, biwundoa dǝgawi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Jiremaro nayiro wulnjagakki, kam duwon bǝri dimiyayero cinnayen ngayiwawo na gadeyen tacce ngayimadǝ, ti barwu ye, jawalkorjima ye. ");
INSERT INTO kby_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Amma kam cinnayen ngayimadǝ, tima sǝni dimiyadǝyedǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cinna guredumadǝ tiro kajiyi, dimiyadǝ ye kowonju fanjai. Dimiya kaanjua cunjalan bowoje cuttuluwi. ");
INSERT INTO kby_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kaanju sammaa cuttuluwiya, fuwunjaro koje dimiyadǝ tia jagai, kowonju nojana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tǝmmaro kusotto jagaiwawo, tin kuruwunno ngǝrǝmjai, kowo kusottowaye nojanni nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isa tayiro misal adǝa wulyeyeno, amma maananjudǝa asujanni. ");
INSERT INTO kby_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Koro Isa walde: «Jiremaro nayiro wulnjagakki, wuma cinna dimiyayedǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Am burwosane isanadǝ samma barwuso ye, jawalkorjimaso ye, amma dimiyadǝ tayia fanjanni. ");
INSERT INTO kby_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wudǝ cinna. Kam wuyen ngayia, njǝkkawo cuwandi. Ngaye culuwi, sǝniram ye cuwandi. ");
INSERT INTO kby_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Barwudǝ ndaldu so, njejo so, bannadu soro gǝnia, awima gade dioro isiwawo. Amma wudǝ am ro har tayilan gapcǝna cawandoro kadikko. ");
INSERT INTO kby_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Wu sǝni ngǝlama. Sǝni ngǝlamadǝ dimiya nangaro ronju ci. ");
INSERT INTO kby_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kidamadǝ sǝni gǝni, dimiyadǝ ye kaanju gǝni. Buldu kǝnde cǝdi curuiya, dimiyadǝa kolje cǝgasi, daji buldudǝ ise tayia cǝdane tatarji. ");
INSERT INTO kby_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tidǝ kidama nangaro, dimiyadǝro lambonju bawo. ");
INSERT INTO kby_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Wu sǝni ngǝlama. Dimiyanidǝa nokkǝna, tayi ye wua nosana, ");
INSERT INTO kby_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","jiɍi Bawa wua nosǝna, wu ye tia nokkǝnadǝ gai. Dimiyadǝ nangaro roni yikki. ");
INSERT INTO kby_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Koro dimiya gade bǝri adǝye gǝni takkǝna. Tayi yea dole kudǝkki, koro kowoni fanjai. Daji bǝri fal ye, sǝni fal yero waljai. ");
INSERT INTO kby_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bawadǝ wua sǝraana, roni yikkiya, waldǝkke mowokki nangaro. ");
INSERT INTO kby_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wunduma rakce roni ngojiwawo, amma rawonin tia yikki. Kǝnduwo nanin tia njoye mbeji, koro kǝnduwo nanin tia mowoye mbeji. Adǝma wada Bawaniyen fandǝkkǝnadǝ,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kǝla mana aniyen yaudiyadǝ caye baworo kǝwu yindiro yakkadara. ");
INSERT INTO kby_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ngǝwunjaye: «Kai! Ti karuwama, joɍi! Awiro tia kǝrǝnnuwi?» cani. ");
INSERT INTO kby_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Am laaye: «Adǝ mana karuwamaye gǝni. Karuwama rakce kambuye sim kaji wa?» cani. ");
INSERT INTO kby_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Binǝm Jerujalemnin Ngǝmǝri Barga Dǝptuwuye cadi duwon, ");
INSERT INTO kby_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Isa balballa Fado Alayen tiro Ngurwo Nawi Mai Sulemanaye canilan dadaji. ");
INSERT INTO kby_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Daji yaudiyadǝ tia dirijane kǝljane tiro: «Har sawiro andia curo duwuyen kolsami? Nima Almasiwudǝ woa, federo wulsagane!» yera. ");
INSERT INTO kby_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isaye tayiro: «Nayiro wulnjagakkǝna, amma wua kasansuwwi. Kǝndo cu Bawaniyen dikkidǝ wua shedasi. ");
INSERT INTO kby_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amma wua kasansuwwawo, nayi curo dimiyaniyen bawo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Dimiyanidǝ kowoni fanjai. Tayia nokkǝna, wua sagai. ");
INSERT INTO kby_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tayiro ro sawisoye yikki, koro tǝmmaro sanuiwawo. Wunduma tayia mukkonin cǝmoyiwawo. ");
INSERT INTO kby_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bawani tayia wuro sinadǝ awo sammaa nankuran kojǝna. Wunduma rakce tayia mukko Bawadǝyen cǝmoyiwawo. ");
INSERT INTO kby_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wu-a Bawadǝ-a tilo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Daji yaudiyadǝ tia roro njejoro waldane dongur kauye tiro gǝgǝptuwuro ngoyera. ");
INSERT INTO kby_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isaye tayiro: «Kǝndo ngǝla kada Bawaniye nayiro fǝlenjagakkǝna. Finja nangaro wuro dongur kauye gǝgǝmsuwe sesuwi?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yaudiyadǝye tiro: «Kǝla kǝndo ngǝlayen gǝni, kǝla Alaa gaskadunǝmben njejiye. Ni kam duwon kǝlanǝm Alaro ngonǝmidǝ!» ");
INSERT INTO kby_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isaye tayiro: «Kitawundon ngai ruwuwada, gǝna? “Wuye: Nayi alawa!” cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kitawu Alayedǝ rakce baworo tǝdiwawo. Ala am duwon tayiro mananju cinadǝro alawa cǝnnaa, ");
INSERT INTO kby_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","awiro wu duwon Ala kǝrese duniaro sunodǝnadǝro Alaa gaskanǝkkǝna nuwi, wu Tada Alaye nǝkkǝnadǝro? ");
INSERT INTO kby_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kǝndo Bawaniyedǝa dikkiwawoa, bare wua kasansuwwi. ");
INSERT INTO kby_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma tayia dikkia, kasansuwwawo yaye, kǝndodǝa kasaddowo, nonowo asunowo Bawadǝ wulan kǝrga, wu ye Bawadǝn kǝrgakkoro.» ");
INSERT INTO kby_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Koro waldane tia taro mayera, amma mukkonjan kiluwo. ");
INSERT INTO kby_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Koro Isa walde ngawo bǝrǝm Jordaniyen na Nawi Yahaya kasala tuwaye cǝdǝnadǝro leje napkeno. ");
INSERT INTO kby_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Daji am kada nanjuro isane: «Nawi Yahaya awo ajabba falma cǝdǝnni, amma awo kǝla kam adǝyen wuljǝna samma jire!» yera. ");
INSERT INTO kby_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Adǝgaima am kada nadǝn Isaa kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Curo bǝla Baitaniyen na Meram-a yanjugǝna Marta-a dasaanadǝn kam laa dondi mbeji, cunju Lajarus. ");
INSERT INTO kby_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ti Lajarusdǝ yanjugǝna Meram kamu duwon kawudi si Kǝmayedǝro fijiye kanduɍi kǝlanjuyen cinjǝnadǝye. ");
INSERT INTO kby_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yaana yindidǝ kam laa na Isayero canode: «Kǝma, kam raammadǝ dondi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Adǝa fangenniya, Isaye: «Kǝndondi adǝye njeroramnju karmo gǝni, Alaro daraja ci, koro Tada Alaye ye tiyen daraja cuwandoro!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isa Marta-a yanjugǝna-a Lajarus-aa cǝraana. ");
INSERT INTO kby_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Daji Lajarus dondiro fangenniya, na dǝganadǝn koro kawu yindiro napkeno. ");
INSERT INTO kby_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ngawo adǝyen Isaye fuwurawanjuro: «Ciniyo, cidi Yahudiyayero waldiyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Fuwurawanjuye tiro: «Sayinna, tussǝnni yaudiyadǝ nia dongur kauyen njejoro mangera, koro nadǝro waldǝmi?» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isaye tayiro: «Dabdulan sa mewun yindin dǝga, mare? Kam kausu lejia, taljiwawo, nur dunia adǝyedǝa curui nangaro. ");
INSERT INTO kby_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma kam bune lejia, talji, tilan nur bawo nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Adǝa wulyenniya, Isaye tayiro: «Sawande Lajarus kǝnǝm cǝdi, lekke tia sangǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Fuwurawadǝye tiro: «Kǝma, kǝnǝm cǝdia, ngaji,» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Isa kǝla karmo Lajarussen manajǝna, amma tayidǝ kǝla kǝnǝmben manajiro tǝmayera. ");
INSERT INTO kby_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Daji Isaye federo tayiro: «Lajarus nuna. ");
INSERT INTO kby_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nayi nangaro wu nadǝn bawodǝro kǝji fakki, wua kasansoworo. Cinowo nanjuro leniyo!» ");
INSERT INTO kby_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Daji Toma kam tiro Kawu canidǝ fuwurawa gadedǝro: «Andi ye leniyo Isa-a rokko nuiyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Isa kadinniya, ase Lajarus kawunju dewu rai curo kauriyen. ");
INSERT INTO kby_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bǝla Baitaniyedǝ karǝn Jerujalemben, kattenja alama kilometǝr yakku gai, ");
INSERT INTO kby_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","koro yaudiya kada na Marta-a Meram-ayero kǝla karmo yanjagǝnayen tayia tajiduro isana. ");
INSERT INTO kby_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta Isa kǝnde cǝdiro fangenniya, cije tia kapkeyeno, amma Meram fadon napkeno. ");
INSERT INTO kby_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martaye Isaro: «Kǝma, ca ni na adǝnna, yanigǝna bawojǝnni. ");
INSERT INTO kby_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma kǝrmamaro awi yaye Alaa korǝmiya, Ala njiro nokkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isaye tiro: «Yanǝmgǝna karmolan walje ciji,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaye: «Yim daryeye yim cinowo duniayea karmolan walje cijiro nokkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isaye tiro: «Wuma cinowo duniaye-a ro-adǝ wo! Kam wua kasansǝnamadǝ, bawoji yaye, roa dǝgai. ");
INSERT INTO kby_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Koro wundu duwon roa dǝgane wua kasansǝnamadǝ tǝmmaro nuiwawo. Adǝa yasaramma wa?» yenniya, ");
INSERT INTO kby_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","tiro: «Aaa, Kǝma, nima Almasiwu Tada Alaye duniaro isǝnadǝ woro kasaddǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Adǝa wulyenniya, Marta leje yanjugǝna Meramba bowoje asǝrlan tiro: «Sayinna isǝna, nia bowonji,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meram adǝa fangenniya, nagatto cije nanjuro leyeno. ");
INSERT INTO kby_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Isadǝ bǝlaro ngaanni, kuamison na Marta tia kapcǝgǝnadǝn kǝrga. ");
INSERT INTO kby_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yaudiya duwon curo fadoyen tia tajijanadǝ Meram nagatto cije culuwunaro kerunniya, tia geya. Kauriro so dioro lejiro tǝmayera. ");
INSERT INTO kby_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Daji Meram na Isa dǝganadǝro ise tia kirunniya, fuwunjun tungurumje tiro: «Kǝma, ca ni na adǝnna, yanigǝna bawojǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Isa Meram-a yaudiya ti-a rokko isanadǝ-a cesiriro kirunniya, karwunju kuttaje hangalnju caa ciyeno. ");
INSERT INTO kby_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tayiro: «Ndararo tia kekkuw?» cǝne kiworǝnniya, tayiye tiro: «Kǝma, are rui!» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Daji Isa so ngoyeno. ");
INSERT INTO kby_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yaudiyaye: «Jiɍi tia cǝraanadǝa ruiwo!» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amma laanjaye: «Ti kambuye sim kajǝnadǝ rakce Lajarussa karmoro cǝkkayiwawo wa?» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Koro Isa karwunju jauro bannadǝna duwon, kauridǝro leyeno. Kauridǝ kul kauye, koro cinju kau kuralan jakkada. ");
INSERT INTO kby_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isaye: «Kaudǝa tuluwowo!» yeno. Marta yaana kam bawojǝnadǝye tiro: «Kǝma, jauro kinaji. Bawojǝnadǝ, kawunju dewu rai, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isaye tiro: «Wulnjǝgǝkkǝni wa? Yasarammaa, daraja Alaye rumi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Daji kaudǝa kettuluwo. Isa kǝla samero sapce: «Bawa, wua kǝrǝnsǝmmadǝro wusenjǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Sawiso wua kǝrǝnsǝmiro nokkǝna, amma jama na adǝn dajanadǝ nangaro adǝa wulyekko, nima wua sunodǝmbo kasaccaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Adǝa wulyenniya, kowo dunoaro sapce: «Lajarus, luwe!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Daji kam bawojǝnadǝ kiluwo, si-a mukko-a batta linnen tikkerǝna, fǝkka ye batta linnen jakkada. Isaye tayiro: «Tia wuinowo, lejo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Adǝ nangaro yaudiya kada na Merambero isana duwon awo Isa cǝdǝnaa carunadǝ tia kasatkera. ");
INSERT INTO kby_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma curonjan laa na Farisawayero lejane awo Isa cǝdǝnadǝa tayiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Daji wurawa ɍimannaye-a Farisawa-a majilisdǝa capcane tayiro: «Kam adǝ alama ajabba ajabba kada cǝdidǝ, awi gǝle diye? ");
INSERT INTO kby_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tia kolliye adǝgai cǝdia, wundu yaye tia kasacci. Daji Romanwudǝ isane nande-a jamande-a sammaa camoyi,» yera. ");
INSERT INTO kby_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Daji falnja cunju Kaifas, tima saa adǝn ɍiman kura wo, tayiro: «Awima nonuwwi. ");
INSERT INTO kby_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jamadǝ samma sanuiro kam fal nunama nayiro ngalworo asunuwwi wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mana adǝa ngumnjun gǝni wulyeno, amma saa adǝn ti ɍiman kuradǝ, nawinawi cǝde Isa fuwun jamadǝ nangaro nui yeno, ");
INSERT INTO kby_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","koro jamadǝ runju gǝni nangaro, tadawa Alaye tatardanadǝa capce fallo waljaro. ");
INSERT INTO kby_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Daji tǝn yim adǝn nia Isaa roro njejoye ngoyera. ");
INSERT INTO kby_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Adǝma nangaro Isa federo fuwu yaudiyayen culuwiwawo, amma cidi karǝn karaayedǝro leje bǝla laa Ifǝrayim canidǝn fuwurawanju-a rokko napkeno. ");
INSERT INTO kby_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngǝmǝri yaudiyaye sala Laya Njǝkkayirambedǝ karǝngenniya, am kada bǝladeyalan cijane Jerujalembo kǝlanja tayirro kalakcaro leyera. ");
INSERT INTO kby_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Fado Alayen dajana Isaa majai duwon, kattenjan: «Awi tǝmanuw? Ngǝmǝridǝro isiwawo wa?» cani. ");
INSERT INTO kby_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Caman wurawa ɍimannaye-a Farisawa-a wada cade kam laa na Isa dǝganadǝa nojǝnaa, iso tayiro wuljuwo tia cada canna. ");
INSERT INTO kby_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sala Laya Njǝkkayirambero kawu arakku gapcoa, Isa bǝla Baitaniye na Lajarus kam duwon karmolan cǝsangǝnadǝ dǝganadǝro leyeno. ");
INSERT INTO kby_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nadǝn Isaro masǝna dabbaryeyera. Marta masǝnadǝa dagarji, Lajarus ye am Isa-a rokko masǝna boro napcanadǝye falnja. ");
INSERT INTO kby_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Daji Meram sǝndal curonjun kawudi jauro tamanna cunju nardi ngoje si Isayero fijiye kanduɍi kǝlanjuyen cinje, har buwuttu kawudidǝyedǝ fado ngaa kimowo. ");
INSERT INTO kby_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Fuwurawanjuye falnja Yahusa Iskariyot cani kam duwon tia fuwun kǝladowanjuro sǝrǝcciyidǝye: ");
INSERT INTO kby_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Awiro kawudi adǝa dinariyus yer yakkuro calade wuɍidǝa talaawaro cadǝnnidǝ?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Adǝa wuldunjudǝ, talaawaro kissǝgǝna gǝni, ti barwu, koro aɍittanja ye mukkonjun awo curodǝro casakkidǝa ndalji nangaro. ");
INSERT INTO kby_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Isaye tiro: «Tia kolle! Kawudi adǝa gǝnadunjudǝ, yim sittǝraniyero wua dabbarduwuro adǝa kido. ");
INSERT INTO kby_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Talaawasodǝ sawisoro curondon mbeji, amma wudǝ sawisoro gǝni curondon dǝgakki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jama yaudiya kada kadami Isa nadǝn mbejiro fangeranniya, cijane ti runjua gǝni, Lajarus kam karmolan cǝsangǝnadǝ yea kuroro kadira. ");
INSERT INTO kby_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Daji wurawa ɍimannaye nia Lajarus yea roro njejoye ngoyera, ");
INSERT INTO kby_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","dalilnjudǝ yaudiya kada kǝla tiyen tayia koljane Isaa kasaccana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wajǝnanjua jama kada ngǝmǝridǝro isanadǝ Isa Jerujalembo isiro fangeranniya, ");
INSERT INTO kby_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ngǝlai diwinoye ngojane tia kaptuwuro keluwo. Kowo sapcane: «Hosanna! Bargaa ti cu Kǝmandeyen isimadǝ! Bargaa Mai Israyilayedǝ!» cani. ");
INSERT INTO kby_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Daji Isa kutta koroye cuwande juwane kǝlanjun napkeno, kitawulan ruwuwadadǝ gai: ");
INSERT INTO kby_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Fero Siyonne, bare rinǝmmi! Akko mainǝm kǝla kutta koroyen napkada kǝnde cǝdi.» ");
INSERT INTO kby_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Fuwurawanju awo ania awimaro burwon asujanni, amma Ala Isaro daraja kenniya, daji awo ani kǝlanjun kitawulan ruwudǝna ye, tiro caddǝna yea takkera. ");
INSERT INTO kby_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jama duwon Isa-a rokko sa Lajarussa curo kauriyen bowoje karmolan cǝsangǝnadǝn dasaanadǝ sheda cadi. ");
INSERT INTO kby_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dalil jama kada tia kaptuwuro caluwunayedǝ alama adǝa cǝdǝna fanjana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Daji Farisawaye kattenjan: «Ruwi wa? Awima ranguwe diwwawo. Akko dunia nga ngawonju jaana!» yera. ");
INSERT INTO kby_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Curo am Alaro ambǝttuwuro sa ngǝmǝriye Jerujalembo isanadǝyen am lardu Gǝresse laa ye mbeji. ");
INSERT INTO kby_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na Filibus kam Baitsaida cidi Galileyero isane tiro: «Malǝm, Isaa kuroro maniye,» yera. ");
INSERT INTO kby_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibus leje Andarawusso wuljiye, Andarawus-a Filibus-a ye na Isayero lejane tiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isaye tayiro: «Sa cǝdǝna, sa duwon Tada Kambe daraja cuwandidǝ. ");
INSERT INTO kby_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jiremaro nayiro wulnjagakki, kasuni algamaye cidiro cure nuiwawoa, runju napci. Amma nuia, nema kada cakki. ");
INSERT INTO kby_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kam duwon ronju cǝraanamadǝ ronjudǝa cuwatki, koro kam duwon dunia adǝn ronjua wajǝnamadǝ tia har ro sawisoyero cǝɍiwi. ");
INSERT INTO kby_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kam laa nanwolodi wuro sǝddia, wua sǝga! Koro na dǝgakkǝnadǝn wolodini ye dǝgai. Kam laa nanwolodi wuro sǝddia, Bawadǝ daraja tiro ci. ");
INSERT INTO kby_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Kǝrma karwuni kuttu. Awi gǝle wullǝkki? Bawa, sa adǝro wua sǝkkaye? A'a, adǝma nangaro sa adǝro kadikko. ");
INSERT INTO kby_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bawa, cunǝmbo daraja ye!» yeno. Daji kowo samelan nukce: «Tiro daraja yikkǝna, koro yaye daraja yikki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jama nadǝn daadadǝ kowodǝa fangeranniya, gǝrdu keyeraye cani, laaye: «Malaiya laa tiro mana cǝddo,» cani. ");
INSERT INTO kby_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Isaye tayiro: «Kowo adǝ wu nangaro gǝni, nayi nangaro nukkeno. ");
INSERT INTO kby_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kǝrmama dunia adǝro shara kamdiyi, kǝrma mai dunia adǝyedǝa dujane culuwi. ");
INSERT INTO kby_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wudǝ, wua rosǝgǝwiya, am sammaa naniro gǝrgǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Adǝa wuldunjudǝ, karmo jiɍi fin fuwun nuidǝa fǝleyeno. ");
INSERT INTO kby_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Daji jamadǝye tiro: «Curo Attaurayen Almasiwudǝ sawisoro dǝgairo fanniyena. Ndayin gǝle Tada Kambedǝa kǝskaro rojagai nǝmi? Wundu Tada Kambe adǝ?» yera. ");
INSERT INTO kby_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Daji Isaye tayiro: «Nurdǝ koro yaye dawundon sa ganaro mbeji. Nur tawwa duwon, dadanowo, bare duwu nayia njawandǝnniro. Kam duwon curo duwuyen lejimadǝ na leji nojǝnni. ");
INSERT INTO kby_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nurdǝa tawwa duwon, nurdǝa kasaddowo, tadawa nurrero walloworo,» yeno. Isa awo ania wulyenniya, nadǝa kolje tayilan gǝraadan. ");
INSERT INTO kby_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Isa fuwu jamayen alama ajabba ajabba kada cǝdǝna yaye, tia kasaccanni. ");
INSERT INTO kby_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Adǝgaima awo Nawi Ishaya kitawulan wuljǝnadǝ wakkayeno. Tiye: «Kǝmande, wundu kawuɍinde kasacco? Koro wunduro Kǝmande mukkonju kǝnduwoa fǝlejuwo?» cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Adǝma nangaro rakcane kasaccaiwawo. Koro yaye Nawi Ishayaye: ");
INSERT INTO kby_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Ala simnja jakce kǝlanja kibbajǝgǝna, bare simnjan carunni, koro karwunjan asujanniro. Ngai gǝnia, naniro waldane tuwa cade, tayia isangagǝkki,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nawi Ishaya daraja Isaye curuna ye, kǝlanjun manajǝna ye nangaro, awo ania wulyeno. ");
INSERT INTO kby_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Adǝ yaye curo wurawa yaudiyadǝyen ngǝwu Isaa kasaccana. Amma Farisawa nangaro federo wuljaiwawo, bare Farisawadǝ tayia dandallan cattuluwunniro, ");
INSERT INTO kby_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","awoa daraja kambedǝa Alayemaa kojǝnaro caraana. ");
INSERT INTO kby_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Daji Isaye kowo sapce: «Kam wua kasansǝnamadǝ, wua gǝni, ti wua sunodǝnadǝa kasacco! ");
INSERT INTO kby_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Koro kam wua suruimadǝ ti wua sunodǝnadǝa curui. ");
INSERT INTO kby_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wu duniaro nur gai kadikko, wundu duwon wua kasansǝnamadǝ, bare curo duwuyen dǝganniro. ");
INSERT INTO kby_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kam duwon manani fanje ngoduro wajǝnamadǝ, wu gǝni shara tiro yiddǝkki, dalilnjudǝ am duniayero shara njǝddoro gǝni, duniadǝa njǝkkaworo kadikko nangaro. ");
INSERT INTO kby_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kam duwon wua wase manani ngoduro wajǝnamadǝ sharamanju mbeji. Mana wullǝkkǝnadǝ yim daryeyea tia sharaji. ");
INSERT INTO kby_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kǝlanin gǝni mana kidǝkko, amma Bawa wua sunodǝnadǝ awo wullǝkkidǝ-a jiɍi tia wullǝkkidǝ-aye wada wuro sina. ");
INSERT INTO kby_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Koro wadanjudǝ ro sawisoyero nokkǝna. Adǝma nangaro awo wullǝkkidǝ, jiɍi Bawa wulsǝgǝnadǝ gairo wullǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kawu sala Laya Njǝkkayirambedǝro, Isa sanju dunia adǝa kollǝme na Bawanjuyero leduye cǝdǝnaro nojǝna duwon, jamanju dunia adǝyea cǝraana nangaro, tayiro kǝrawonju cotto fǝleyeyeno. ");
INSERT INTO kby_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yiwulis calan nia Isaa sǝrǝttuwuye curo karwu Yahusa Iskariyot tada Simannero cakkǝna. Bǝri lesayelan, ");
INSERT INTO kby_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isa Bawadǝ awo sammaa mukkonjuro cakkǝna ye, na Alayen kadio na Alayero waldi yero nojǝna duwon, ");
INSERT INTO kby_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","daji cije kajǝmunju gǝnaje batta laa ngoje canjanjuro kikkero. ");
INSERT INTO kby_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ngawo adǝyen ingi tasaro fijiye si fuwurawanjuyedǝa tuldu badije batta canjanjuro cikkerǝnadǝn cinji ngai duwon, ");
INSERT INTO kby_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","na Siman Biturussero kadinniya, Biturusse tiro: «Kǝma, nima wa sini tullǝmi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isaye tiro: «Awo dikkidǝa kǝrma asunǝmbawo, amma fuwun asunǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Biturusse tiro: «A'a, tǝmmaro sini tullǝmbawo!» yenniya, Isaye: «Tulnjǝkkǝnia, nanilan nuwanǝm bawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Siman Biturusse: «Kǝma, sini runju gǝni, mukkoni-a kǝlani-a yea tulle!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isaye tiro: «Kam kasaldǝnadǝ, sinju tulda gǝnia, kadawu tilan bawo. Nayi tayir, amma nayi samma gǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Isa sǝrǝttuwumanjudǝa nojǝna, adǝma nangaro tiye: «Nayi samma gǝni tayir wo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sinja tulje kerǝnniya, Isa kajǝmunju ngoje luje walde napce tayiro: «Awo njaddǝkkǝnadǝa asunuwwa wa? ");
INSERT INTO kby_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wua sayinna-a Kǝma-alan bowosuwi, jirendoa, wuma ti wo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Daji wu Kǝmando ye, sayinnando ye duwon sindo tullǝkkǝnadǝ, si amandoye tulda nayi yero wajimnjaana. ");
INSERT INTO kby_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nayiro misal ngeddǝkko, nayi ye jiɍi njaddǝkkǝnadǝ gai amandoro yiddowo! ");
INSERT INTO kby_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jiremaro nayiro wulnjagakki, wolodi banju ngimbaa kojiwawo, koro kadunoma ye kam duwon tia cunodǝnadǝa kojiwawo. ");
INSERT INTO kby_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Awo ania nonuwwadǝ, tayia diwia, bargando. ");
INSERT INTO kby_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kǝla nayi sammayen gǝni mananǝkki, am kǝrenǝkkǝnadǝa nokkǝna. Amma dole sai awo kitawulan ruwuwadadǝ wakkajiya: “Kam wu-a rokko masǝna diyedǝ kǝladoniro waljǝna.” ");
INSERT INTO kby_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kǝrma kawu wakkajiro nayiro wulnjagakki, sa wakkajiya, wuma ti woro kasaddoworo. ");
INSERT INTO kby_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jiremaro nayiro wulnjagakki, wundu duwon kam nodǝkkǝnadǝa cǝmowonadǝ wumaa sǝmowo. Koro wundu duwon wua sǝmowonadǝ ti wua sunodǝnamaa cǝmowo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Awo ania wulje kerǝnniya, Isa hangalnju jauro cije: «Jiremaro nayiro wulnjagakki, kamndo laa wua mukko kǝladowaniyero sǝrǝnsiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Fuwurawadǝ kattenjan ninidane kǝla wunduyen manajimaro nojanni. ");
INSERT INTO kby_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Falnja ti duwon Isa jauro cǝraanadǝ gǝre Isayen giriskada mbeji. ");
INSERT INTO kby_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Daji Siman Biturus kǝla wunduyen manajiro tia cuwororo bǝlaana kam giriskadadǝro kiddo. ");
INSERT INTO kby_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Daji Isaa karǝnje tiro: «Kǝma, wundu?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isaye: «Kam duwon tiro burodi adǝa yigapkǝkke yikkimadǝ, tima!» yeno. Burodidǝa kigapkenniya, Yahusa tada Siman Iskariyottero kaino. ");
INSERT INTO kby_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Njangodǝa kimowonniya, Yiwulis karwunjuro kǝrgawo. Isaye tiro: «Awo dimidǝa duwan de!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amma curo am masǝnaro napcanayen falnjama awiro adǝa tiro wulyeyenoro asujǝnni. ");
INSERT INTO kby_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yahusa aɍittadǝ mukkonjun nangaro, laanja Isaye tiro lejo kare ngǝmǝriyedǝa cuwo bi awo laa talaawaro co wuljoro tǝmayera. ");
INSERT INTO kby_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahusa njangodǝa kimowonniyama, kiluwo. Sadǝ bune. ");
INSERT INTO kby_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yahusa kiluwunniya, Isaye: «Kǝrma duwon Tada Kambedǝ daraja cuwandi, koro Ala ye tiyen daraja cuwandi. ");
INSERT INTO kby_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tiyen Ala daraja cuwandia, Ala kǝlanju ye tiro daraja ci, koro sadǝman tiro daraja ci. ");
INSERT INTO kby_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tadawani sanana, sa gana laaro curondon dǝgakki. Wua masuwi, koro yaudiyaro wulgǝkkǝnadǝ gai nayi yero kǝrma wulnjagakki, na lekkidǝro ranguwe lenuwwawo. ");
INSERT INTO kby_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nayiro wada bǝɍin njadǝkki: Amandoa rawowo! Jiɍi nayia njaraakkǝnadǝ gai, nayi ye amandoa rawowo! ");
INSERT INTO kby_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Amandoa raawwaa, adǝgainin am samma nayi fuwurawaniro nojai,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siman Biturusse tiro: «Kǝma, ndararo lenǝmi?» cǝne kiworǝnniya, Isaye tiro: «Na lekkidǝro rangǝme kǝrma wua sǝgambawo, amma fuwun sǝgami,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Biturusse tiro: «Kǝma, awiro kǝrma rangǝkke njǝgakkiwawodǝ? Ni nangaro roni yikki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isaye tiro: «Wu nangaro ronǝm yimi? Jiremaro niro wulnjǝgǝkki, ku kawu gudowom kokkore cakkidǝro, wua yakkuro angǝrsǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Bare karwundo kuttajǝnni. Alaa kasaddowo, wu yea kasansǝnowo! ");
INSERT INTO kby_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Fado Bawaniyen na naptuye kada mbeji. Adǝ gǝnia, wulnjagakkiwawo. Lekke nayiro na dabbarnjagakki. ");
INSERT INTO kby_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lekke na dabbarnjagakkiya, waldǝkke isǝkke naniro njasadǝkki, na wu dǝgakkidǝn nayi ye dǝgaiworo. ");
INSERT INTO kby_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Koro jawal na lekkiyedǝa nonuwwa,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaye tiro: «Kǝma, na lenǝmidǝa noniyende. Ndayilan rangiye jawaldǝa noniye?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isaye tiro: «Wuma jawaldǝ wo, wuma jiredǝ wo, wuma rodǝ wo. Wuyen gǝnia, wunduma na Bawadǝyero isiwawo. ");
INSERT INTO kby_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wua nosuwwaa, Bawani yea nonuwi. Na adǝn fuwun tia nonuwwa ye, ruwwa ye,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibusse tiro: «Kǝma, Bawadǝa fǝlesagane, adǝ mǝradunde galji,» yenniya, ");
INSERT INTO kby_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isaye tiro: «Filibus, wu tussǝna nayi-a rokko duwon, koroma wua nosǝmmi? Kam wua surunadǝ Bawadǝa curuna. To, ndayin gǝle Bawadǝa fǝlesagane nǝmi? ");
INSERT INTO kby_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wu Bawadǝlan kǝrgakko, Bawadǝ ye wulan kǝrgaro kasaddǝmmi wa? Mana wu wulnjagakkidǝa ngummin gǝni wullǝkki, amma Bawa wulan dǝganadǝ kǝndonju cǝdi. ");
INSERT INTO kby_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wu Bawadǝlan kǝrgakko, Bawadǝ ye wulan kǝrgaro kasaddowo, bi kǝndodǝ nangaro kasaddowo! ");
INSERT INTO kby_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Jiremaro nayiro wulnjagakki, kam wua kasansǝnamadǝ ye kǝndo dikkidǝa cǝdi. Koro kǝndo animaa kojǝna cǝdi, na Bawadǝyero lekki nangaro. ");
INSERT INTO kby_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Awi yaye cunilan koruwiya, dikki, Bawadǝ Tadadǝn daraja cuwandoro. ");
INSERT INTO kby_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Awo laaro cunilan wua suworuwia, dikki. ");
INSERT INTO kby_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Wua sǝraawwaa, wadawani gawi. ");
INSERT INTO kby_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Daji Bawadǝa korǝkke nayiro Banama gade nayi-a rokko sawisoro dǝgaro njadi. ");
INSERT INTO kby_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tima Ruhu jireyedǝ wo. Duniadǝ rakce tia cǝmoyiwawo, tia carunni bi nojanni nangaro. Amma nayidǝ tia nonuwwa, dalilnjudǝ nayi-a rokko kǝrga, koro karwundon dǝgai. ");
INSERT INTO kby_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Nayia ngǝni kolnjakkiwawo, waldǝkke nandoro isǝkki. ");
INSERT INTO kby_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa gana cǝdiya, duniadǝ gadero suruiwawo, amma nayi wua suruwi. Wu roa dǝgakki nangaro, nayi ye roa dǝgawi. ");
INSERT INTO kby_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yim adǝn wu Bawadǝlan kǝrgakkoro nonuwi, nayi ye wulan kǝrgaw, wu ye nayin kǝrgakkoro nonuwi. ");
INSERT INTO kby_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kam wadawani ngoje jǝgaimadǝ, tima kam wua sǝraanadǝ wo. Koro kam wua sǝraanadǝa Bawani cǝrayi, wu ye tia raakke tiro fǝledǝgǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahusa tada Iskariyotte gǝnidǝ tiro: «Kǝma, ndayilan duniadǝro gǝni, andiro fǝledǝgǝmi?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isaye tiro: «Kam laa wua sǝraanaa, manani jǝgai. Bawani tia cǝrayi, nanjuro isiye ti-a rokko nammiye. ");
INSERT INTO kby_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kam wua sǝraannimadǝ manani jǝgaiwawo. Koro mana fannuwidǝ kakke gǝni, Bawa wua sunodǝnadǝye. ");
INSERT INTO kby_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Awo ania wu curondon dǝgakkǝna duwon nayiro wulngeyerakko. ");
INSERT INTO kby_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Banamadǝ, Ruhu Alaye ti duwon Bawa cunilan cunodidǝ, nayiro awisoa alamnjagai, koro awo wulnjagakkǝna sammaa isatannjagai. ");
INSERT INTO kby_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nanlewa kolnjagakki, nanlewani nayiro njadǝkki. Jiɍi dunia cidǝ gainin gǝni nayiro njadǝkki. Bare hangalndo cijǝnni bi rinuwwi! ");
INSERT INTO kby_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nayiro: “Wu lekki, koro waldǝkke nandoro isǝkki,” wulnjagakkǝnadǝa fannuwwa. Wua sǝraawwaa, na Bawadǝyero lekkiro kǝji fannuwi, Bawadǝ wua kosǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kǝrma kawu wakkajiro nayiro wulnjagakkǝna, sa wakkajǝnadǝn, kasaddoworo. ");
INSERT INTO kby_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngǝwuro nayiro mananjagakkiwawo, mai dunia adǝyedǝ kǝnde cǝdi nangaro. Kǝlanin kǝnduwo cǝdanni. ");
INSERT INTO kby_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amma duniadǝ Bawadǝa raakkǝnaro nojoro awo Bawadǝ wua sakkǝnadǝa dikki. Cinowo, leniyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Wuma ya inabbe jireyedǝ wo, Bawanidǝ tima jǝrwumadǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Dǝlam wulan tada cakkiwawo fi yayea calji, koro dǝlam tada cakki fi yayea tada kada cakkoro sǝrakci. ");
INSERT INTO kby_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nayidǝ mana wulnjagakkǝnadǝ nangaro kǝrmadǝma tayirro walluwwa. ");
INSERT INTO kby_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wulan dǝgaiwo, wu ye nayilan dǝgakki. Jiɍi dǝlam runju ya inabbero tandǝgǝnnin rakce tada cakkiwawodǝ gai, nayi ye wulan dǝgawwawoa, ranguwe tada yakkuwwawo. ");
INSERT INTO kby_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Wuma ya inabbedǝ wo, nayima dǝlambadǝ wo. Kam wulan dǝgana koro wu ye tilan dǝgakkǝnamadǝ tada kada cakki, dalilnjudǝ wulan gǝni kǝrgawwa, awima ranguwe diwwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kam duwon wulan dǝgannimadǝ, tia dǝlam gai deyaro gǝpcagane ngamji. Daji tayia capcane kannuro fijagane warjai. ");
INSERT INTO kby_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Amma nayi wulan dǝgawe manani ye nayilan dǝgaia, awo raawwaa korowo, fanduwi. ");
INSERT INTO kby_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Akko awo Bawaniro daraja cidǝ: Tada kada yakkuwiya, adǝgainin nayi fuwurawani jireyero walluwi. ");
INSERT INTO kby_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jiɍi Bawadǝ wua sǝraanadǝ gai, wu ye njaraakkǝna. Curo kǝrawoniyen dǝgaiwo! ");
INSERT INTO kby_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wadawani gawia, curo kǝrawoniyen dǝgawi, jiɍi wu ye wadawa Bawaniye gakke curo kǝrawonjuyen dǝgakkǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Karwukǝjini nayilan dǝga, karwukǝjindo ye kalkallo waljoro adǝa nayiro wulnjagakkǝna. ");
INSERT INTO kby_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Akko wadanidǝ: Amandoa rawowo, jiɍi wu ye nayia njaraakkǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sawawanju nangaro ronju njodǝ, kǝrawo adǝa nankuran kojǝna bawo. ");
INSERT INTO kby_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wada nayiro njadǝkkǝnadǝa gawia, nayi sawawani. ");
INSERT INTO kby_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nayia wolodiyalan gadero bowonjakkiwawo, wolodi awo banju ngimba cǝdidǝa nojǝnni nangaro. Amma nayia sawawalan bowonjakki, awo Bawaniyen fakkǝna sammaa isanonjagakkǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nayi gǝni wua kǝresuw, wuma nayia kǝrenjakke lenowo tada yakkowo tadando dǝgaro galangerakko. Daji awi yaye cunilan Bawadǝa koruwi ngaa nayiro njadi. ");
INSERT INTO kby_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akko wada nayiro njadǝkkǝnadǝ: Amandoa rawowo! ");
INSERT INTO kby_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Duniadǝ nayia wanjanaa, wumaa nayin burwonno wasoro nonowo! ");
INSERT INTO kby_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ca nayidǝ duniayea, duniadǝ kaanjudǝa cǝrayi. Amma nayi duniaye gǝni, curo duniayen nayia kǝrenjakkǝna nangaro, duniadǝ nayia wanjana. ");
INSERT INTO kby_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mana wulnjagakkǝnadǝa tangowo: “Wolodi banju ngimbaa kojiwawo.” Wua basarsanaa, nayi yea basarnjai. Manani jaanaa, kaando yea jagai. ");
INSERT INTO kby_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amma awo ani sammaa kǝla cuniyen nayiro njaddi, ti wua sunodǝnadǝa nojanni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ca isǝkke mana tayiro yiddǝkkǝnia, biwunja bawo. Amma kǝrma dalil biwunja bawo caniye bawo. ");
INSERT INTO kby_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kam wua wasǝnamadǝ Bawani yea wajǝna. ");
INSERT INTO kby_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ca kǝndo wunduma gade cǝdǝnni curonjan dikkǝnia, biwunja bawo. Amma kǝrma wu-a Bawani-aa saruna ye, wasana ye, ");
INSERT INTO kby_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","mana wadanjalan ruwuwadadǝ wakkajoro: “Dalil bawoalan wua wasera.” ");
INSERT INTO kby_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Banama na Bawadǝyen nayiro njakkunodǝkkidǝ, tima Ruhu jireye na Bawadǝyen isidǝ wo. Isiya, kǝla wuyen sheda ci. ");
INSERT INTO kby_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nayi ye kǝla wuyen sheda yiwi, dalilnjudǝ tǝn badiduramnin wu-a rokko dǝgawwa nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Bare talluwwiro awo ania wulnjagakkǝna. ");
INSERT INTO kby_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dandallan nayia njattuluwi. Ai, sa ise wundu duwon nayia roro njeyesidǝ kida Alaye cǝdoro tǝmaji. ");
INSERT INTO kby_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bawadǝa nojanni bi wua nosanni nangaro ngai cadi. ");
INSERT INTO kby_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amma awo ania nayiro wulduwunidǝ, sanja cǝdiya, tayia wulnjagakkǝnaro tangowo. «Badiduramnin awo ania nayiro wulnjagakkǝni, wu-a nayi-a rokko dǝgaiye nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Amma kǝrma na ti wua sunodǝnadǝyero waldǝkki, koro wundundoma wuro: “Ndararo lenǝmi?” cǝne suworǝnni. ");
INSERT INTO kby_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amma awo ania wulnjagakkǝna nangaro, karwundo ngaso kuttajǝna. ");
INSERT INTO kby_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Adǝ yaye jire wulnjagakki, waldǝkkǝnama nayiro ngalwo. Waldǝkkiwawoa, Banama nandoro isiwawo. Amma waldǝkkia, tia nayiro juwanjagakki. ");
INSERT INTO kby_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Isiya, duniadǝro kǝla biwu-a jire-a shara-ayen kǝndonja diwiro tabbacciyi. ");
INSERT INTO kby_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kǝla biwuyen, wua kasansanni nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kǝla jireyen, na Bawadǝyero waldǝkki, koro gadero suruwwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kǝla sharayen, mai dunia adǝyedǝro shara kamdǝgǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Koro yaye awo kada nayiro wulduwuye takkǝna, amma kǝrmadǝro ranguwe tayia ngonuwwawo. ");
INSERT INTO kby_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ruhu jireye isiya, nayia jawal jireye sammaro simonjagai. Ti ngumnjun gǝni manaji, awo fanjǝna runju manaji, koro awo fuwun wakkaji ye nayiro wulnjagai. ");
INSERT INTO kby_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wuro daraja si, dalilnjudǝ awo kakke ngoje nayiro isanonjagai nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Awo Bawaye samma kakke. Adǝma nangaro awo kakke ngoje nayiro isanonjagai yekko. ");
INSERT INTO kby_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Gana tussiya, gadero wua suruwwawo, koro gana tussiya, gademinno wua suruwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Daji fuwurawanjuye laanja kattenjan: «Awi maana awo wulsagaiyedǝ wo? “Gana tussiya, gadero wua suruwwawo, koro gana tussiya, gademinno wua suruwi,” koro “Na Bawadǝyero waldǝkki nangaro,”» yera. ");
INSERT INTO kby_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Daji tayiye: «Awi maana awo wulji adǝye wo? “Gana tussiya,” kǝla awiyen manajimaro noniyende!» yera. ");
INSERT INTO kby_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isa kǝla adǝyen tia koro caraanaro asuje tayiro: «Kǝla adǝyeman wa amandoa kokoruwi? “Gana tussiya, gadero wua suruwwawo, koro gana tussiya, gademinno wua suruwi,”» yeno. ");
INSERT INTO kby_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","«Jiremaro nayiro wulnjagakki, yiruwi ye, njǝmmuwi ye, amma duniadǝ kǝji fanji. Karwundo kuttaji, amma karwukuttando karwukǝjiro walji. ");
INSERT INTO kby_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kamu tada cambiya, jauro leiya cai, sanju cǝdǝna nangaro. Amma tadadǝa cambiya, leiya canadǝa takciwawo, karwukǝji tada tambǝnadǝye nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nayi ye kǝrma karwundo kuttaji. Amma gademinno nayia njarukkiya, karwundo jauro kǝjiji, koro wunduma karwukǝjindo adǝa cuttuluwiwawo. ");
INSERT INTO kby_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yim adǝn awimaro wua suworuwwawo. Jiremaro nayiro wulnjagakki, awi yaye Bawadǝa cunilan koruwwadǝa nayiro njadi. ");
INSERT INTO kby_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Koroma awima cunilan koruwwi. Korowo fanduwi, karwukǝjindo kalkallo waljo! ");
INSERT INTO kby_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Awo ania misalnin wulnjagakkǝna. Sa ise nayiro misalnin wulnjagakkiwawo, amma federo kǝla Bawadǝyen wulnjagakki. ");
INSERT INTO kby_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yim adǝn cunilan koruwi, koro nayiro Bawadǝa njakkorǝkki nǝkkiwawo, ");
INSERT INTO kby_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","awoa Bawa kǝlanju nayia njaraana, dalilnjudǝ wua sǝraawwa ye, wu Alayen kadikkoro kasadduwwa ye nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bawadǝyen isǝkke duniaro kadikko, koro duniadǝa kollǝkke na Bawadǝyero waldǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Daji fuwurawanjuye tiro: «Akko kǝrma misalnin gǝni, federo wullǝmi. ");
INSERT INTO kby_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kǝrma awisoa nonǝmma ye, koro kam niro koro njǝddoro mǝradunǝm bawo yero noniyena. Adǝmaro Alayen kadimbo kasaddiyena,» yera. ");
INSERT INTO kby_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isaye tayiro: «Kǝrma kasadduwwa wa? ");
INSERT INTO kby_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Akko sa isi har isǝnama, sa duwon nayia tatarnjane wundundo yaye fannjuro leje wua runi kolsidǝ. Amma wudǝ runi gǝni, Bawadǝ rokkonin nangaro. ");
INSERT INTO kby_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Awo ania nayiro wulnjagakkǝna, wulan nanlewa fandoworo. Dunialan bone yawi, amma karwundo gerowo! Kǝla duniayen kǝnnasar fandǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Isa awo ania wulyenniya, kǝla samero sapce: «Bawa, sadǝ cǝdǝna. Tadanǝm daraja niro njoro tiro daraja ye, ");
INSERT INTO kby_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","awoa am tiro yimma sammaro ro sawisoye coro, tiro kǝnduwo kǝla adamgǝna fiye yayen kem. ");
INSERT INTO kby_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ro sawisoyedǝ, tima ni Ala jireye tok tilodǝa nodu, koro Isa Almasiwu ti nodǝmmadǝ yea nodu. ");
INSERT INTO kby_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kida dioro simmadǝa tumogǝkkilan dunialan daraja njikkǝna. ");
INSERT INTO kby_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","To, Bawa, daraja duwon ni-a rokko kawu dunia alaktǝnaman takkǝnadǝa wuro se! ");
INSERT INTO kby_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Am dunia adǝn wuro simmadǝro cunǝm isanogǝkkǝna. Tayi kaanǝm, tayia wuro sime mananǝm jaana. ");
INSERT INTO kby_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kǝrma awo wuro simma samma nanǝmnin kadioro nojana. ");
INSERT INTO kby_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mana wulsǝgǝmmadǝa tayiro wulgǝkkǝna. Manadǝa camoye wu nanǝmnin kadikkoro jiremaro nojana, koro nima wua sunodǝmbo kasaccana. ");
INSERT INTO kby_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Tayiro moduwa yiddǝkki. Duniadǝro gǝni, tayi duwon wuro simmadǝro moduwa yiddǝkki, tayi kaanǝm nangaro. ");
INSERT INTO kby_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Awo kakke samma kaanǝm, awo kaanǝm samma ye kakke. Koro tayilan daraja fandǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wudǝ dunialan gadero dǝgakkiwawo, amma tayidǝ koro yaye dunialan dasayi, koro wu ye nanǝmbo isǝkki. Bawa Tayir, cunǝmlan tayia rone, cu duwon wuro simmadǝ! Tayi tiloro walja, jiɍi andi tilodǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sa wu tayi-a rokkodǝ, cunǝm duwon wuro simmalan tayia royekko. Tayia rokkǝna, koro awo kitawulan ruwuwadadǝ wakkajoro ti faccǝgǝnamadǝro kajia, falnjama faccǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Amma kǝrma nanǝmbo isǝkki, koro karwukǝjini jauro tayilan dǝgaro awo ania curo duniayen wullǝkki. ");
INSERT INTO kby_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tayiro mananǝm yikkǝna. Duniadǝ tayia wayeno, tayi duniaye gǝni nangaro, jiɍi wu ye duniaye gǝnidǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tayia dunialan tuluwero gǝni njuworǝkki, amma tayia ti Kǝladolan kanero njuworǝkki. ");
INSERT INTO kby_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tayi duniaye gǝni, jiɍi wu ye duniaye gǝnidǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jirelan tayia tayirro kalange. Mananǝmdǝ tima jiredǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jiɍi wua duniaro sunodǝmmadǝ gai, wu ye tayia duniaro kinodǝkko. ");
INSERT INTO kby_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tayi nangaro kǝlania niro njikkǝna, tayi ye jirelan tayirro waljaro! ");
INSERT INTO kby_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Tayi runjaro gǝni, koro tayi duwon mananjalan wua kasansaidǝ yero moduwa yiddǝkki. ");
INSERT INTO kby_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bawa, tayi samma tiloro walja, jiɍi ni wulan, wu ye nilandǝ gai. Tayi ye andilan tiloro walja, duniadǝ nima wua sunodǝmbo kasaccoro. ");
INSERT INTO kby_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Koro daraja wuro simmadǝa tayiro yikkǝna, tayi tiloro walja, jiɍi andi tilodǝ gai. ");
INSERT INTO kby_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wu tayilan, ni ye wulan. Adǝgainin tiloro walja, duniadǝ nima wua sunodǝm ye, koro jiɍi wua sǝraammadǝ gai tayia raamma yero nojoro. ");
INSERT INTO kby_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bawa, tayi wuro simmadǝ yea wu-a rokko na dǝgakkǝnadǝn napcaiya, raakko. Adǝgaima darajani carui, daraja duwon wuro simma, kawu dunia alaktiman wua sǝraamma nangaro. ");
INSERT INTO kby_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bawa Jirema, duniadǝ nia nonjǝnni. Amma wu nia nonjǝkkǝna, koro tayi ani nima wua sunodǝmbo nojana. ");
INSERT INTO kby_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cunǝm tayiro isanogǝkkǝna, koro fuwun isanogǝkki, kǝrawo tilan sǝraammadǝ curonjan dǝgaro, wu ye tayilan dǝgakkoro,» yeno Isaye. ");
INSERT INTO kby_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Isa awo ania wulyenniya, fuwurawanju-a rokko cijane ngawo ngor tiro Kidǝron caniyen na duwon jǝrwu laa mbejidǝro lejane kasargawo. ");
INSERT INTO kby_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahusa sǝrǝttuwumanjudǝ ye nadǝa nojǝna, Isa-a fuwurawanju-a nadǝn ngǝwuro captana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Daji Yahusa kǝwu laa sojiyaye-a gureduwu wurawa ɍimannaye-a Farisawaye-aa ngoje jǝrwudǝro fatǝla so, ka cambi so, baɍimi so mukkonna kadira. ");
INSERT INTO kby_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Daji Isa awo tiro wakkajiyi ngaa nojǝnadǝ karǝnje tayiro: «Wundua manuwi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tiro: «Isa kam Najarattea,» yeranniya, tayiro: «Wuma,» yeno. Yahusa tia sǝrǝccǝgǝnamadǝ ye tayi-a rokko daada. ");
INSERT INTO kby_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Isaye tayiro: «Wuma,» yenniya, ngawosǝsǝm cade cidiro kesuro. ");
INSERT INTO kby_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Koro Isa walde tayiro: «Wundua manuwi?» cǝne kiworǝnniya, tiro: «Isa kam Najarattea,» yera. ");
INSERT INTO kby_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isaye tayiro: «Wuma ti woro wulnjagakkǝna. Wumaa masuwia, am ania kollowo leja!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Adǝgaima mana wuljǝnadǝ wakkayeno. Tiye: «Curo am wuro simmadǝyen falma yuwatkǝkkǝni,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Daji Siman Biturus mukkon kashagarra ficce wolodi ɍiman kuradǝyea bakce sǝmonju kǝmboramdǝa tǝn kamgeno. Wolodidǝye cunju Malkus. ");
INSERT INTO kby_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Amma Isaye Biturusso: «Kashagarnǝmba fannjuro kalange! Kǝnjaram Bawadǝ wuro sinadǝn yakkiwawo wa?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Daji kǝwu sojiyayedǝ-a kajallanja-a gureduwu yaudiyayedǝ-a Isaa cadane kekkero. ");
INSERT INTO kby_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Burwon tia na Annas ba kǝsai Kaifassero kesado. Saa adǝn Kaifasdǝ ɍiman kura, ");
INSERT INTO kby_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","koro tima yaudiyadǝro gala ce kam fal jamadǝro nunama tayiro ngalwo cǝnnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Daji Siman Biturus-a fuwura gade-a Isaa geya. Ɍiman kuradǝ fuwura adǝa nojǝna nangaro, ti ye Isa-a rokko balballa fado ɍiman kuradǝyero kasargawo, ");
INSERT INTO kby_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","amma Biturus deyan cinna fadoyedǝn dayeno. Daji fuwura duwon ɍiman kura tia nojǝnadǝ walde kir cinna guredumadǝro manajiye Biturussa fadodǝro kekko. ");
INSERT INTO kby_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kir cinna guredumadǝye Biturusso: «Ni ye fuwurawa kam adǝye falnja gǝni?» yenniya, tiye: «A'a, wu gǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dunia kakua nangaro, wolodiya-a gureduwu-a kannu fujane nadǝn daada jagatti. Biturus ye tayi-a rokko daada kannu jǝgǝtti. ");
INSERT INTO kby_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Daji ɍiman kuradǝ Isaro kǝla fuwurawanju-a alamdunju-ayen koro njǝddo badiyeno. ");
INSERT INTO kby_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isaye tiro: «Federo duniadǝro wulgǝkkǝna. Kullum dandalla-a Fado Alaye-alan na yaudiya samma captaidǝn alammǝkkǝna. Awima asǝrlan wullǝkkǝni. ");
INSERT INTO kby_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Awiro koro sǝddǝmi? Am kǝrǝnsanaro kǝla awo tayiro wulgǝkkǝnayen koro yidde! Ai, awo wullǝkkǝnadǝa nojana,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Awo ania wulyenniya, gureduma laa nadǝn daada Isaa maɍin bakce tiro: «Adǝgainin ɍiman kuradǝro jaawu kalakkǝmi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isaye tiro: «Awo wullǝkkǝnadǝ diwia, kǝla diwidǝyen shedane. Amma jirea, awiro wua bansǝmi?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Daji Annas Isaa tikkerǝna na Kaifas ɍiman kuradǝyero juwayeyeno. ");
INSERT INTO kby_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Siman Biturus nadǝn daada kannu jǝgǝtti duwon, tiro: «Ni ye fuwurawanjuye falnja gǝni?» yera. Biturusse angǝrje: «Wu gǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wolodiya ɍiman kuraye falnja kǝrami kam duwon Biturus sǝmo kamjǝnadǝye tiro: «Curo jǝrwudǝyen ti-a rokko njarukkǝni wa?» yenniya, ");
INSERT INTO kby_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","koro Biturus walde angǝryeno. Sadǝman gudowom kokkore kekko. ");
INSERT INTO kby_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Daji suwa lǝp Isaa fado Kaifassen cattuluwe gomnariro kesado. Tayi kǝlanja gomnaridǝro ngasaanni, bare tayir gǝniro waljane masǝna salayedǝa tayiro bo tiyerǝnniro. ");
INSERT INTO kby_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Adǝma nangaro Gomna Bilatus culuwe nanjaro ise tayiro: «Awi burwundo kǝla kam adǝyen?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tiro: «Kam adǝ diwi dioma gǝnia, tia niro sǝrǝnnjiyewawo!» yera. ");
INSERT INTO kby_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Daji Bilatusse tayiro: «Nayi kǝlandoma tia taiwo, wadandolan tiro shara yiddowo!» yeno. Yaudiyadǝye tiro: «Andiro kam roro njejoro amardǝgǝnni,» yera. ");
INSERT INTO kby_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Adǝgaima mana Isa kǝla jiɍi nuiyen wuljǝnadǝ jirero walyeno. ");
INSERT INTO kby_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Koro Bilatus walde gomnariro ngaye Isaa bowoje tiro: «Nima wa Mai Yaudiyayedǝ wo?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isaye tiro: «Ni kǝlanǝm adǝa wullǝm ra am laa kǝlanin adǝa wulngeyera?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatusse: «Wu yaudi wa? Am lardunǝmbe-a wurawa ɍimannaye-a nia mukkoniro ngesakko. To, awi gǝle dim?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isaye: «Nodoni bargaadǝ dunia adǝye gǝni. Ca nodoni dunia adǝyea, wolodiyani cijane bare wua mukko yaudiyayero sasakkǝnniro lawala cadǝna. Amma nodoni dunia adǝye gǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Daji Bilatusse tiro: «Adǝgaimaa, ni mai?» yenniya, Isaye tiro: «Nima wullǝm, wu mai. Dalil tamboni-a duniaro kǝndeni-adǝ jiredǝa sattuwuro. Wundu duwon jiredǝyedǝ kowoni fanji,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatusse tiro: «Awi jiredǝ wo?» yeno. Bilatus adǝa wulyenniya, koro walde na yaudiyadǝyero culuwe tayiro: «Ayau fima kam adǝn fandǝkkǝni. ");
INSERT INTO kby_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amma kǝla adandoyen kosoma fal sala Laya Njǝkkayirambedǝn nayiro salamnjagakki. Mai Yaudiyayedǝa wa nayiro salamnjagakkiya, rawuw?» cǝne tayia kiworo. ");
INSERT INTO kby_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Koro waldane yiljane: «A'a, ti gǝni, Barabbas!» yera. Ti Barabbasdǝ jawalkorjima. ");
INSERT INTO kby_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Daji Bilatus cakke Isaa kirwolan jajaryera. ");
INSERT INTO kby_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojiyadǝ aɍiawu kaɍiyiye kǝlejane kǝlanjuro gǝnajagane kalwu kime tiro luyeyera. ");
INSERT INTO kby_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Daji nanjuro isane tiro: «Ala ngǝwuro, Mai Yaudiyaye!» cane maɍin babakkera. ");
INSERT INTO kby_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Koro Bilatus walde na yaudiyadǝyero culuwe tayiro: «Akko tia nandoro tuluwukki, ayau fima tilan fandǝkkǝniro nonowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Daji Isa aɍiawu kaɍiyiyedǝ-a kalwu kimedǝ-a luwadaa kiluwunniya, Bilatusse tayiro: «Akko kamdǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wurawa ɍimannaye-a gureduwudǝ-a tia kerunniya, kowo sapcane: «Kǝskaro tia jagǝne! Kǝskaro tia jagǝne no!» yera. Bilatusse tayiro: «Nayi kǝlando tia ngonowo, kǝskaro jagǝnowo! Wudǝ ayau tilan fandǝkkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yaudiyadǝye tiro: «Wadande mbeji, kǝla wadadǝyen karmo tiro wajipcǝgǝna, ti kǝlanjua Tada Alayero ngojǝna nangaro,» yera. ");
INSERT INTO kby_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bilatus mana adǝa fangenniya, cayea kojǝnaro riyeno. ");
INSERT INTO kby_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Koro gomnariro walde ngaye Isaro: «Ndaran kadim?» cǝne kiworo. Amma Isa awima tiro kalakcǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Daji Bilatusse tiro: «Wuro manasǝgǝmbawo wa? Nanilan kǝnduwo nia kolduye-a kǝnduwo nia kǝskaro jaduwuye-a mbejiro nonǝmmi wa?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isaye tiro: «Sameyen njadǝnnia, kǝnduwonǝm kǝlanin bawo. Adǝmaro kam niro sǝrǝnsǝgǝnadǝye biwunju kaanǝmdǝa kojǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sa adǝn fuwun Bilatus Isaa salamdu mayeno, amma yaudiyadǝ kowo sapcane: «Kam adǝa salammǝmia, ni sawa Kaisarre gǝni! Wundu duwon kǝlanjua mairo ngojǝnamadǝ Kaisarra wajǝna,» yera. ");
INSERT INTO kby_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mana adǝa fangenniya, Bilatus deyaro Isaa cuttuluwe kǝla kurisnju sharayen na farsam kaulan tǝdǝna tǝlam yaudiyaudin tiro Gabbata canidǝn napkeno. ");
INSERT INTO kby_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yimdǝ yim dabbardu sala Laya Njǝkkayirambe, kausu kǝla dawu gai. Bilatusse yaudiyadǝro: «Akko maindo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Amma kowo sapcane: «Ronju tuluwe! Ronju tuluwe! Kǝskaro tia jagǝne!» yera. Bilatusse tayiro: «A! Maindoa kǝskaro jagǝkki?» yenniya, wurawa ɍimannaye tiro: «Kaisar gǝnia, mainde gade bawo!» yera. ");
INSERT INTO kby_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Daji Bilatus Isaa kǝskaro jajaaro mukkonjaro kekko. Daji Isaa cadane kesado. ");
INSERT INTO kby_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Isa kǝlanjuma kǝskanju karmoye ngoje na tia Buwo Kǝlayelan bowojai tǝlam yaudiyaudin tiro Golgota canidǝro leyeno. ");
INSERT INTO kby_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nadǝn ti-a am gade yindi-a rokko kǝskaro jayeyera, sǝgǝri fi yayen kam fal fal, ti Isadǝ dawunjan. ");
INSERT INTO kby_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus kǝla alloyen ruwuje kǝskadǝro royeyeno. Akko awo ruwuwadadǝ: ISA KAM NAJARATTE, MAI YAUDIYAYE. ");
INSERT INTO kby_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yaudiya kada awo allo adǝn ruwuwadadǝa kǝrayera, na Isaa kǝskaro jajaanadǝ karǝn bǝrnidǝyen, koro awo adǝa tǝlam yaudiyaye-a Rombe-a Gǝresse-alan ruwujana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Daji wurawa ɍimanna yaudiyaye Bilatusso: «Bare “Mai Yaudiyaye” ruwunǝmmi, “Kam adǝye wu Mai Yaudiyaye cǝnna” ruwune,» yera. ");
INSERT INTO kby_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatusse tayiro: «Awo ruwunǝkkǝnadǝa ruwunǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sojiyadǝ Isaa kǝskaro jayeyeranniya, kajǝmunju ngojane ci dewuro yakcane soji fi yaye nuwanju ngoyeno. Kalwunju kuruwu tududǝnni samen tai cidiyaro yadero caaadadǝ yea ngoyera. ");
INSERT INTO kby_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sojiyadǝye kattenjan: «Bare karniyende, walawala diyo, kam cuwandidǝa ruiyo!» yera. Adǝgaima awo kitawulan ruwuwadadǝ wakkayeno. Tiye: «Kajǝmuni kattenjan yakkera, koro kalwuniro walawala kedo,» cǝnna. Akko awo sojiyadǝ cadǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Karǝn kǝska Isayedǝn yanju-a yaana yanjuye-a Meram kamu Kǝlofasse-a Meram Magdala-a daada mbeji. ");
INSERT INTO kby_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Isa yanju-a fuwura jauro cǝraanadǝ-a nadǝn daada kirunniya, yanjudǝro: «Yani, akko tadanǝm!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Daji fuwuradǝro: «Akko yanǝm!» yeno. Tǝn sa adǝn fuwuradǝ tia fannjuro kiwudo. ");
INSERT INTO kby_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ngawo adǝyen awo samma kǝrma cerǝnaro asuyenniya, awo kitawulan ruwuwada wakkajoro, Isaye: «Ngudu fakki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nadǝn kalwo curonjun diben comcom mbeji. Daji sojiyadǝ soso ngojane dibendǝro lǝpcagane cattuluwe karo lassagane cinjuro sayeyera. ");
INSERT INTO kby_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Isa cujumgenniya, tiye: «Cǝdǝna!» yeno. Daji kǝla cidiyaro cakke ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yim adǝ yim dabbarduye, koro wajǝnanjua yim tustuye kura. Bare kaminna kǝla kǝskayen yim tustuyea dasaanniro, yaudiyadǝ siyelnjadǝa nanamja kaminnadǝa caadoro Bilatussa keworo. ");
INSERT INTO kby_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Daji sojiyadǝ isane kam burwoye ti-a rokko kǝskaro jajaanadǝye siyelnju namgera, yindiyedǝye ye ngai. ");
INSERT INTO kby_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na Isayero kadiranniya, siyelnju namjanni, ti bawo bawojǝnaro caruna nangaro. ");
INSERT INTO kby_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amma sojiyadǝye falnja sisinjua kajaalan sukkeno. Sadǝman bu-a ingi-a keluwo. ");
INSERT INTO kby_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kam awo adǝa curunadǝ nayi ye kasaddoworo sheda cǝdǝna. Shedanju jire, koro awo wuljǝnadǝa jirero nojǝna. ");
INSERT INTO kby_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Adǝgaima awo ani wakkajana, kitawulan ruwuwadadǝ gai: «Sillanju falma namjaiwawo,» ");
INSERT INTO kby_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","koro na gade yen kitawulan ruwuwada: «Ti sukcanadǝa carui,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ngawo adǝyen Isuwu kam Arimatiyaye leje kamin Isayedǝa ngojoro Gomna Bilatussa kiworo. Ti ye fuwura Isaye, amma asǝrlan, yaudiyadǝa rijǝna nangaro. Daji Bilatus amari tiro kenniya, ise kamindǝa ngoyeno. ");
INSERT INTO kby_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimus kam calan na Isayero bune isǝnadǝ ye ise kawudi laa mir-a alus-a kǝllaada kilo fiakku gai kiwudo. ");
INSERT INTO kby_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Daji kamin Isayedǝa ngojane kǝla adanja sittǝra yaudiyayedǝn kawudidǝ-a rokko batta linnen kǝleyera. ");
INSERT INTO kby_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na Isaa kǝskaro jajaanadǝyen jǝrwu laa mbeji, koro curo jǝrwudǝyen kauri bǝɍin laa curonjuro wundumaa casakkǝnni mbeji. ");
INSERT INTO kby_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yimdǝ yim dabbarduye, koro kauridǝ karǝnnin dǝgana nangaro, curonjuro Isaa kesakko. ");
INSERT INTO kby_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mawuye yim burwoyea fajar Meram Magdala kauridǝro leje kau kuradǝ ci kauridǝyen tǝmballada kiro. ");
INSERT INTO kby_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Daji cǝgase na Siman Biturus-a fuwura gade Isa jauro cǝraanadǝ-ayero leje tayiro: «Kǝmadǝa kauridǝn ngojana, koro na casakkǝnadǝa noniyende!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Daji Biturus-a fuwura gadedǝ-a kǝla kauridǝnna leyera. ");
INSERT INTO kby_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tayi yindi samma cagasi lejai ngai, amma fuwura faldǝ Biturussa ngǝrǝmnin koje burwoje kauridǝro kadio. ");
INSERT INTO kby_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nguje lotkeyenniya, batta linnedǝa nadǝn gǝnaada kiro, amma curodǝro ngaanni. ");
INSERT INTO kby_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Daji Siman Biturus tia jǝgaidǝ ye ise kauridǝro kǝrgawo. Batta linnedǝa nadǝn gǝnaada kiro, ");
INSERT INTO kby_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","koro batta duwon kǝla Isayero casakkǝnadǝ batta gade-a rokko gǝni, na gaden kǝɍiyada. ");
INSERT INTO kby_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Daji fuwura duwon burwon isǝnadǝ ye kauridǝro ngaye cure kasatkeno. ");
INSERT INTO kby_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Amma Ala kadarjǝna Isa karmolan cijidǝa kitawulan ruwuwadadǝ gairo koroma asujanni. ");
INSERT INTO kby_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Daji fuwurawadǝ fannjaro walladara. ");
INSERT INTO kby_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meram deyan ci kauridǝyen daada so badiyeno. Ciri ngai duwon, nguje kauridǝa lotkeyenniya, ");
INSERT INTO kby_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","malaiya yindi kajǝmu bulla na calan kamin Isaye gǝnajanadǝn napkada kiro, faldǝ kǝlakajinjulan, faldǝ ye sinjulan. ");
INSERT INTO kby_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tayiye: «Kamu, awiro yirǝmi?» cane tia keworo. Tiye: «Kǝmania ngojana, koro na tia casakkǝnadǝa nokkǝni nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Adǝa wulyenniya, suworde Isaa nadǝn daada kiro, amma tiro asujǝnni. ");
INSERT INTO kby_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Isaye tiro: «Kamu, awiro yirǝmi? Wundua manǝmi?» cǝne kiworo. Amma ti jǝrwumadǝro tǝmaje tiro: «Malǝm, nima tia ngonǝmbo walyenoa, na tia yakkǝmmadǝa wulsǝgǝne, wu ye tia ngokki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isaye tiro: «Meram!» yenniya, kanji Isayero suworde tǝlam yaudiyaudin: «Rabbuni!» yeno, maananjudǝ Sayinna. ");
INSERT INTO kby_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Isaye tiro: «Bare rosǝmmi, koroma na Bawadǝyero waldǝkkǝni nangaro. Amma lene kǝramiyaniro: “Na Bawani-a Bawando-ayero, Alani-a Alando-ayero waldǝkki,” wulgǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Daji Meram Magdala na fuwurawadǝyero leje tayiro: «Kǝmadǝa rukkǝna!» cǝne awo tiro wuljǝgǝnadǝa tayiro wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yim adǝ yim burwoye mawuye dunia kajiriyenniya, cinna na fuwurawa dasaanayedǝ yaudiyadǝa riduro cuwuramnin jakkada duwon, Isa ise dawunjan daje tayiro: «Salam aleikum!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Adǝa wulyenniya, tayiro mukkonju-a sisinju-a fǝleyeyeno. Fuwurawadǝ kǝla Kǝmadǝa carunadǝyen karwunja jauro kǝjiyeno. ");
INSERT INTO kby_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Koro Isa walde tayiro: «Salam aleikum! Bawadǝ wua sunodǝnadǝ gai, wu ye nayia njanodǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Adǝa wulyenniya, tayiro kasam fujiye: «Ruhu Alayedǝa mowowo! ");
INSERT INTO kby_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Am tayiro biwunja gawurnuwia, biwunja gawurdǝna. Am tayiro biwunja gawurdu wanuwia, biwunja gawurdǝnni,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Fuwurawa mewun yindindǝye falnja cunju Toma kam tiro Kawu canidǝ sa Isa isǝnadǝn ti nanjan bawo. ");
INSERT INTO kby_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Daji fuwurawa gadedǝye tiro: «Kǝmadǝa ruiyena!» yera. Amma Tomaye tayiro: «Balo kusaye mukkonjun rukke ngulondoni curo balo kusayedǝro yakkǝkke mukkoni ye sisinjuro yakkǝkkǝnia, tǝmmaro kasaddǝkkiwawo,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ngawo kawu wuskuyen fuwurawa Isaye caye gai curo fadodǝyen duwon, Toma ye tayi-a rokko mbeji. Cinna fadoyedǝ cuwuramnin jakkada yaye, Isa ise dawunjan daje tayiro: «Salam aleikum!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Daji Tomaro: «Ngulondonǝm na adǝro yakke, mukkoni rui, mukkonǝm sane sisiniro yakke! Bare shekku dimmi, kasadde!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaye tiro: «Kǝmani ye, Alani ye!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isaye tiro: «Wua surumma nangaro, kasatkem? Barganja am carunni kasaccanamadǝ!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isa fuwu fuwurawanjuyen alama kada kitawu adǝn ruwudǝnni kido. ");
INSERT INTO kby_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amma dalil awo ani ruwudǝnayedǝ, Isadǝ tima Almasiwu Tada Alayedǝ woro kasaddowo, kasadduwilan ro sawisoye cunjulan fandowo nangaro. ");
INSERT INTO kby_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngawo adǝyen Isa koro walde fuwurawanjuro ci bǝrǝm tiro Tiberiyas canidǝyen fǝleyaada. Akko jiɍi tayiro fǝledǝgǝnadǝ: ");
INSERT INTO kby_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sadǝn Siman Biturus-a Toma kam tiro Kawu canidǝ-a Nataniyel kam Kana cidi Galileyedǝ-a tadawa Jabadiye-a fuwura Isaye gade yindi-a rokko mbeji. ");
INSERT INTO kby_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siman Biturusse tayiro: «Buni taro lekki,» yenniya, tiro: «Andi ye ni-a rokko leniye!» yera. Daji caluwe maararo kasargawo, amma bune adǝn awima cadanni. ");
INSERT INTO kby_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dunia wayenniya, Isa ci bǝrǝmdǝyen dayeno, amma fuwurawadǝ ti Isaro asujanni. ");
INSERT INTO kby_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Daji Isaye tayiro: «Tadawa, buni tawwa wa?» cǝne kiworǝnniya, tiro: «A'a,» yera. ");
INSERT INTO kby_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tayiro: «Buni taramdǝa kǝmboram maaradǝyero gǝpkǝnowo, fanduwi,» yeno. Gǝpkeyeranniya, nanngǝwu bunidǝyedǝro tuluwo tiyero. ");
INSERT INTO kby_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Daji fuwura Isa tia jauro cǝraanadǝye Biturusso: «Tima Kǝmadǝ wo!» yeno. Siman Biturus ti Kǝmadǝ woro fangenniya, ɍingada nangaro kalwunju luje sǝkte bǝrǝmdǝro gǝpkaadano. ");
INSERT INTO kby_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fuwurawa gapcanadǝ tayi ci ingiyen kuruwun gǝni metǝr mia gai nangaro maaradǝn taram buniadǝa gǝrjane kadira. ");
INSERT INTO kby_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cidiro jǝpkeranniya, nadǝn kannu kanduwalle buni kǝlanjun gǝnaada-a burodi-a mbeji kero. ");
INSERT INTO kby_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Isaye tayiro: «Buni kǝrma tawwadǝye laanja kudowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Daji Siman Biturus juwane buni taramnja bunin cap cǝmbǝɍǝnadǝa cidiro gǝryeno. Curodǝn buni kura kura mian fiwun yakkun mbeji. Buni kada kadami yaye, buni taramdǝ kardǝnni. ");
INSERT INTO kby_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isaye tayiro: «Arowo buiwo!» yeno. Wundunjamaye tiro: «Ni wundu?» cǝne cuworǝnni, ti Kǝmadǝro asujana nangaro. ");
INSERT INTO kby_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Daji Isa ise burodidǝa ngoje tayiro kaino, buni ye ngai. ");
INSERT INTO kby_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Isa karmolan cijǝnaye ngawon, adǝma yakkuyero fuwurawadǝro fǝleduwunjudǝ wo. ");
INSERT INTO kby_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gewunniya, Isaye Siman Biturusso: «Siman tada Yahayaye, tayi ania kojǝnaro wua sǝraamma wa?» cǝne kiworo. Biturusse tiro: «Aaa, Kǝma. Nia njǝraakkǝnaro nonǝmma,» yeno. Isaye tiro: «Dimiyania ambane!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Koro Isa kǝnyindiyero tiro: «Siman tada Yahayaye, sǝraamma wa?» cǝne kiworo. Tiye: «Aaa, Kǝma. Nia njǝraakkǝnaro nonǝmma,» yeno. Isaye: «Dimiyaniro kiskǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Koro Isa kǝnyakkuyero tiro: «Siman tada Yahayaye, sǝraamma wa?» cǝne kiworǝnniya, Biturusse karwu kuttayeno, Isa kǝnyakkuyero tiro: «Sǝraamma wa?» cǝnna nangaro. Tiye: «Kǝma, ni awi yaye nonǝmma, nia njǝraakkǝnaro nonǝmma,» yenniya, Isaye tiro: «Dimiyania ambane! ");
INSERT INTO kby_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jiremaro niro wulnjǝgǝkki, gananǝmlan ni kǝlanǝmbo kalwu lugǝme na raammaro lenǝmi. Amma kiarinǝmiya, mukko sagǝme kam gade kalwu lunjiye na raammiro njadi,» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Isa adǝa wuldunjudǝ, karmo jiɍi fiyen Biturus daraja Alaro cidǝa tiro fǝleyeyeno. Adǝa wulyenniya, Isaye tiro: «Wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Biturus suworgadanniya, fuwura Isa jauro cǝraanadǝ tayia jǝgai kiro, ti duwon sa masǝna cadidǝn karǝnje Isaro: «Kǝma, wundu nia sǝrǝnnjiyi?» cǝne cuworǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Biturus tia kirunniya, Isaro: «Kǝma, ti adǝ ye nda?» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isaye tiro: «Kawu waldǝkke isǝkkiro roa dǝgaro raakkǝnaa, awi lambonǝm? Ni wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Adǝma nangaro lawar fuwura adǝ nuiwawoye kǝramiyadǝro tatargaada. Adǝ yaye Isaye Biturusso kamdǝ nuiwawo cǝnni, amma tiye: «Kawu waldǝkke isǝkkiro roa dǝgaro raakkǝnaa, awi lambonǝm?» cǝnnadǝ. ");
INSERT INTO kby_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Fuwura adǝma kam kǝla awo aniyen sheda ce kitawulan ruwujǝnadǝ wo. Koro shedanju jirero noniyena. ");
INSERT INTO kby_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Awo gade kada Isa cǝdǝna ye mbeji. Ca fal fallen ruwujaia, tǝmakkǝna duniama rakce kitawuwa ruwudǝnadǝa ngojiwawo.");
INSERT INTO kby_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wuse, Tiyofalas! Curo kitawuni burwoyedǝlan kǝla awo Isa dio-a alamdu-a badijǝna sammayen ruwungeyekko, ");
INSERT INTO kby_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","har yim duwon Ruhu Alayen kǝngayambanju kǝrejǝnadǝro wada ce tia samero caadǝnadǝro. ");
INSERT INTO kby_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ngawo bone cane nunayen, kawu fidewuro tayiro fǝlediye mana kǝla nodo bargaa Alayen cǝdi. Adǝgaima fudu kadan tayiro roaro tabbacciye fǝleyaada. ");
INSERT INTO kby_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Isa kǝngayambanju-a rokko duwon, tayiro wada ce: «Bare Jerujalemlan saptuwwi, awo Bawadǝ njadi cǝne wulnjagakkǝnadǝa gurenowo! ");
INSERT INTO kby_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Awoa Yahayadǝ ingilan kasala tuwaye ambo kiddo, amma kawu ganaa Ruhu Alayen kasala nayiro njaddi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Daji tayi nanjun captanadǝye tiro: «Kǝma, sa adǝn wa jama Israyilayero kǝrmaidǝa kalakkǝmi?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isaye tayiro: «Yim bi sa Bawadǝ kǝnduwonjun kadarjǝnadǝa nodudǝ kaando gǝni. ");
INSERT INTO kby_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma sa Ruhu Alaye nayiro jǝmnjagaiya, kǝnduwo fanduwe Jerujalem-a cidi Yahudiyaye samma-a cidi Samariyaye-a har ci dajiram duniaye-alan shedawuniro walluwi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Adǝa wulyenniya, tia carui ngai duwon, samero caade fofou laa kuronjan tia kimowo. ");
INSERT INTO kby_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Same na lejidǝa carui duwon, akko am yindi kajǝmu bulla gǝrenjan dajane ");
INSERT INTO kby_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","tayiro: «Am cidi Galileye, awiro danuwwa same ruwidǝ? Isa kam nandon samero camowona adǝ, jiɍi samero lejǝna ruwwadǝ gaiman walde isi,» yera. ");
INSERT INTO kby_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Daji kǝngayambadǝ kau duwon tiro Kau Jaitunne cani Jerujalemba karǝn ledu yim tustuyelan dǝganadǝn waldane bǝrnidǝro kasargawo. ");
INSERT INTO kby_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kasargaanniya, soro sameye na napcanadǝro gewa. Tayima Biturus, Yahaya, Yakuba, Andarawus, Filibus, Toma, Bartolomi, Matiyu, Yakuba tada Alfawusse, Siman tiro lardunju rawoma cani, Yahusa tada Yakubaye. ");
INSERT INTO kby_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tayi ani samma kamuwadǝ-a Meram ya Isaye-a yanjugǝnaso-a rokko karwu tiloaro moduwa cadi kasarga. ");
INSERT INTO kby_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yim anin kǝramiya Isaa gawudǝye nanngǝwunja alama mian findin gai duwon, Biturus dawunjan daje tayiro: ");
INSERT INTO kby_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Kǝramiya, mana duwon Ruhu Alaye kuren ci Nawi Daudayen kǝla Yahusa jeduma am Isaa cadanayedǝyen cǝde kitawulan ruwuwadadǝ sai wakkajiya. ");
INSERT INTO kby_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yahusadǝ kǝngayam dawunden kǝrga, ti ye nuwanju kidandedǝn cuwandǝna. ");
INSERT INTO kby_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Calan kam adǝ alwasi jirenambuyelan kulo ciwe fǝdǝryero cure curonju falde kalǝmnju samma fiyada. ");
INSERT INTO kby_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Am Jerujalembe samma lamar adǝa fangeranniya, tǝlamnjalan kulo adǝa Akeldamalan bowoyera, maananjudǝ Kulo Buye. ");
INSERT INTO kby_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Awoa kitawu Jawurayelan ruwuwada: “Fannju de sul napco, bare wunduma curonjun dǝganni,” koro “Kaalanjudǝa kam gadero cado.” ");
INSERT INTO kby_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Adǝ nangaro dole curo am andi-a rokko kǝrgaiyedǝyen sa Kǝma Isa dawunden dǝgana samman, ");
INSERT INTO kby_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kasala Yahayayelan tai har yim Isaa nanden camowonadǝro kudero, falnja andiro kǝlduwo, ti ye shedama karmolan cidu Isayero waljo,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Am yindi kesangǝra, tayima Isuwu kam duwon tia Barsabaslan bowojai koro tiro Justus canidǝ-a Matiyas-a. ");
INSERT INTO kby_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Daji tayi samma moduwa cade: «Kǝma, ni karwu am sammaye nodumadǝ, tayi yindi anilan kam kǝrenǝmmadǝa isanosagane ");
INSERT INTO kby_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nuwanju kida nankǝngayam adǝyen cuwando, kida duwon Yahusa nanju kadargǝmmaro lejoro koljǝnadǝ,» yera. ");
INSERT INTO kby_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Walawala kedǝnniya, kǝla Matiyassero kikkuro. Daji tia kǝngayamba mewun tilondǝro kǝlyeyera. ");
INSERT INTO kby_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yim ngǝmǝri tiro Fentikos canidǝ kidǝnniya, Isaa gawudǝ samma na tilon captana duwon, ");
INSERT INTO kby_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","sadǝman awo laa karuwa jauro cǝgasi gai samelan nukce fado na napcanadǝ sammaa kimowo. ");
INSERT INTO kby_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Awo laa alama tǝlamba kannuye gai tayiro fǝledagane fafaidane kǝla wundunja yayen napkeno. ");
INSERT INTO kby_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ngainin Ruhu Alaye tayi sammaro jǝpciye cakke tǝlamba gadegaden manadu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sa adǝ yen yaudiya muminna laa larduwa dunia sammaye Jerujalembo isane dasaana mbeji. ");
INSERT INTO kby_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nuktu adǝa fangeranniya, jama isane captane hangalnja ciyeno, dalilnjudǝ wundunja yaye tǝlamnjun jandejai fanjǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jaumaro ajapcane kattenjan: «Am jandejai ani samma am cidi Galileye, gǝna? ");
INSERT INTO kby_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","To, jiɍi fin gǝle wundunde yaye awo wuljaidǝa tǝlamnju tamboyeman fanjidǝ? ");
INSERT INTO kby_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","«Curonden am Fartiyaye-a Mediyaye-a Elambe-a mbeji. Laande ye Mesofotamiya-a Yahudiya-a Kafadokiya-a Fantus-a Asiya-a ");
INSERT INTO kby_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firijiya-a Bamfiliya-a Masar-a kǝrye Libiye kanji bǝla Kuraneyen-a bǝrni Rombe-alan kasarga. ");
INSERT INTO kby_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Gadende yaudi yen kal, kǝrdi duwon yaudiro walyeno yen kal, Kǝret-a Arabiya-alan kadira. Tǝlamnden awo ajabba ajabba Ala cǝdǝnadǝa am ani wuljai fanniye!» ");
INSERT INTO kby_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tayi samma jaumaro ajapcane hangalnja cije wunduye kamanjuro: «Awo attǝ, awi maananju wo?» cǝni. ");
INSERT INTO kby_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amma laa ye tayia rujane: «Diben lele diye casane sagarandana!» cani. ");
INSERT INTO kby_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Daji Biturus kǝngayamba mewun tilondǝ-a rokko cije daje kowo sapce jamadǝro: «Am lardu Yahudiyaye-a nayi Jerujalemlan dǝgawwa samma-a manani fannowo, awo adǝa asunowo! ");
INSERT INTO kby_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Am ani sagarandanaro tǝmanuwwa duwon, ngai gǝni, kǝrmadǝ sa lǝgar suwaye. ");
INSERT INTO kby_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amma adǝma awo Ala ci Nawi Yowellen wuljǝnadǝ: ");
INSERT INTO kby_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«“Jaman daryeyen adamgǝna sammaro Ruhunidǝa figǝkke tadawando-a ferowando-a nawinawi cade, jairowando ye wahayicarui, kiariyando ye kǝnnasim cadi. ");
INSERT INTO kby_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yim anin har kanjiyani kwa-a kamu-aro Ruhunidǝa figǝkke nawinawi cadi. ");
INSERT INTO kby_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Awo ajabba ajabba samelan dikki, alamaso ye cidilan dikki: bu-a kannu-a kange cǝlǝm samero ciɍijiyi-a. ");
INSERT INTO kby_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kǝngal ye cǝlǝmbo walji, kumbal ye buro walji. Ngawo adǝyen yim kura darajaa Kǝmandeyedǝisi. ");
INSERT INTO kby_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Daji wundu duwon cu Kǝmandeyea bowojǝnamadǝ njǝkkawo cuwandi.” ");
INSERT INTO kby_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Jama Israyilaye, mana adǝa fannowo! Nayima dam nonuwwa, Ala Isa kam Najarattedǝlan kǝnduwo so, awo ajabba so, alama so dawundon cǝdiaro tia ardijǝnaro fǝleyeno. ");
INSERT INTO kby_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nodunjun caman tagǝnasso kadarjǝnadǝ gai, timaa mukkondoro sǝrǝccagane, nayi ye mukko am diwiyelan tia kǝskaro jawuwe kejuw. ");
INSERT INTO kby_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amma Ala tia ajawu karmoyero cǝkkaye roaro kisango, karmodǝ tǝmmaro rakce tia rojiwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Awoa Nawi Dauda kǝla tiyen adǝa wulyeno: «“Kullum Kǝmandea fuwunin rukki, ti kǝmborammin dǝgana nangaro awima loloduro sakkiwawo. ");
INSERT INTO kby_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Adǝma nangaro karwuni kǝjiji, cini yelan aiya yekki. Tiyini ye tǝmaa dǝgai, ");
INSERT INTO kby_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","dalilnjudǝ roni kannulan kollǝmbawo, Ti Tayirnǝmdǝa yakkǝme njǝpciwawo nangaro. ");
INSERT INTO kby_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jawal ro fandoye isanosǝgǝmma, koro fuwunǝmnin karwukǝji dadu bawo simi.” ");
INSERT INTO kby_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Kǝramiyani, kǝla kaarinde Nawi Daudayen nayiro farakko wulnjagakki, bawoje tia sittǝrayera, kaurinju ye kumaro nanden kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","To, ti nawi duwon, koro Ala tiro kaduwunju fal mairo galajiro kansi jǝbbunadǝa nojǝnadǝ, ");
INSERT INTO kby_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","caman karmolan cidu Almasiwuyedǝa cure kǝladǝn tiye kannulan tia koljǝnni, tiyinju ye njǝpcǝnni cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ti Isa adǝmaa Ala roaro kalakco, kǝla adǝyen andi samma shedawu. ");
INSERT INTO kby_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tia kǝmboram Alayero sapcane, Ruhu Alaye duwon Bawadǝ ci cǝne wadu ngojǝnadǝa cǝmowona adǝ, awo ruwwa-a fannuwwa-adǝa fiyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Awoa Nawi Dauda samero lejǝnni, amma ti kǝlanjuye: “Kǝmandeye Kǝmaniro: ‘Namme kǝmborammilan duwon, ");
INSERT INTO kby_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kǝladowanǝmba si gǝnadurammǝmbo dikki!’ cǝnna.” ");
INSERT INTO kby_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Adǝ nangaro jama Israyilaye samma adǝa fagatto noja: Isa kam kǝskaro jajagǝwwadǝ, Ala timaa Kǝma ye, Almasiwu yero cǝdo!» yeno Biturusse. ");
INSERT INTO kby_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jamadǝ adǝa fangeranniya, karwunja kamde Biturus-a kǝngayamba gadedǝ-aro: «Kǝramiyandeso, awi gǝle diye?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Biturusse tayiro: «Tǝmmowo, biwundo cindoro wundundo yayero cu Isa Almasiwuyen kasala caddo, ngainin Ala Ruhunjudǝa njadi. ");
INSERT INTO kby_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Awoa wadu adǝmadǝ kaando ye, kaduwundoye ye, am kuruwun dasaana sammaye ye, wotte wundu duwon Ala Kǝmande bowojidǝye.» ");
INSERT INTO kby_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Biturus mana gade ngǝwulan sǝmonja kasse gala cǝdde: «Jaman diwi adǝlan kǝlandoa yǝkkawowo!» cǝni. ");
INSERT INTO kby_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Daji am mananju ngojanadǝro kasala keddo. Yim adǝn alama am dǝwu yakku gai Isaa gawudǝro kǝllaadara. ");
INSERT INTO kby_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sawiso karwu tiloaro Isaa gawudǝ alamdu kǝngayambayedǝa kǝrǝnjai, naptu nanyaanaye cadi, burodi fǝsakcane kallo jagari, moduwa ye rokko cadi kasarga. ");
INSERT INTO kby_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mukko kǝngayambadǝyen awo ajabba so, alama so kada tadi nangaro, am samma riyera. ");
INSERT INTO kby_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Isaa gawu samma na tilon dasaana, awonja sammaa kallo cadai, ");
INSERT INTO kby_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","koro kǝndanja calade wuɍidǝa dagarjane mǝradu wunduye yaye galjai. ");
INSERT INTO kby_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yimbi yaye karwu tiloaro Fado Alayen captai, fado fadolan burodi fǝsakcane karwu kǝjiaro rokura bawoalan kǝmbonjadǝa kallo jawui, ");
INSERT INTO kby_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Alaa congori, koro na jama sammayen ardiya cawandi kasarga. Yim nguson Kǝmande am njǝkkawo cawandidǝa tayiro kǝljiyi. ");
INSERT INTO kby_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yim laa Biturus-a Yahaya-a Fado Alayero moduwa sa yakku kajiriyero lejai duwon, ");
INSERT INTO kby_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ngaworam Fado Alaye tiro Cinna Shawa canidǝn kam laa tǝn tambonjuyen ngurdiyi mbeji. Am Fado Alayero ngasayidǝa sadaaro cuwororo yim nguson tia cawude cinnadǝn gǝnajai. ");
INSERT INTO kby_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kamdǝ Biturus-a Yahaya-a Fado Alayero ngawo cadi kirunniya, tayia sadaaro kiworo. ");
INSERT INTO kby_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Amma Biturus-a Yahaya-a simnin tia cappo carune Biturusse tiro: «Sarui!» yenniya, ");
INSERT INTO kby_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","kamdǝ tayia cǝkko kiro, awo laa tayilan tǝmajǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Biturusse: «Ɍiwulla so, dinar so takkǝni, amma awo takkǝnadǝa njikki. Cu Isa Almasiwu kam Najaratten cine dadane!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Daji ngurdiyidǝa mukko kǝmboramben cǝdane kisangǝnniyama, sinju-a dau sinjuye-a dunoaro waljane ");
INSERT INTO kby_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","wup cije daje ledu badiyeno. Leji ye, sǝkti ye, Alaa cungori ye ngai duwon, tayi-a rokko Fado Alayero kasargawo. ");
INSERT INTO kby_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Daji jama samma ti dadaji ye, Alaa cungori yedǝa kero. ");
INSERT INTO kby_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tima kam duwon Cinna Shawadǝn napkada lowo cǝdidǝro asuyeranniya, awo tiro wakkajǝgǝnadǝa tai dajane ajapkera. ");
INSERT INTO kby_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kamdǝ Biturus-a Yahaya-aro kǝrdǝgǝna ngai duwon, ajapkadaro jama samma nanjaro cagase na duwon Ngurwo Nawi Mai Sulemanaye canidǝro isane capkadara. ");
INSERT INTO kby_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Biturus adǝa kirunniya, tayiro: «Jama Israyilaye, awiro kǝla adǝyen ajammuwidǝ? Awiro kǝnduwonden bi nanmuminnden kam adǝa yakkiye lejiro tǝmanuwe andia ninisawidǝ? ");
INSERT INTO kby_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ala kaariyandeye, Ala Nawi Ibrahimbe-a Nawi Isakuye-a Nawi Yakubaye-adǝ wakkilnju Isaro daraja cina, ti duwon Gomna Bilatus koldu niajǝnama, fuwu gomnadǝyen tia wanuwe sǝrǝtkǝwwadǝ. ");
INSERT INTO kby_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nayidǝ ti tayir ye, jirema yedǝa wanuwe kamceji nayiro salamnjaaro kiworuw. ");
INSERT INTO kby_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kǝma royedǝa kejuw, ti duwon Ala karmolan cǝsangǝnadǝ. Kǝla adǝyen andi ye shedawu. ");
INSERT INTO kby_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cu Isayen kambǝrsenjua nangaro kam ruwi ye, nonuwwa ye adǝ duno kiwando. Kambǝrse adǝmadǝ fuwu nayi sammayen cakke nga cirro walyeno. ");
INSERT INTO kby_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«To, kǝramiyani, nayi-a wurawando-a nodunambulan adǝa diwwaro nokkǝna, ");
INSERT INTO kby_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","amma ngainin awo Ala kuren ci nawiya sammayen wuljǝnadǝ wakkajǝna. Tiye sai Almasiwunju bone caiya, cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Adǝ nangaro tǝmmowo, Alaro waldǝgǝnowo, biwuwando cinjoro, ");
INSERT INTO kby_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","sa kasam fandoye ye na Kǝmandeyen isoro, koro Isa kam duwon Almasiwuro galanjaanadǝ yea nayiro juwanjaaro. ");
INSERT INTO kby_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ala kuren ci nawiyanju tayirren wuljǝnadǝ gai, Almasiwudǝ dolero samelan napci, har sa awo samma sawiyadaro waljidǝro. ");
INSERT INTO kby_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ngaima Nawi Musaye: “Ala Kǝmande curo kǝramiyandoyen nawi laa wu gai nayiro njasangi. Awo nayiro wulnjagai samman tia kǝrǝnnowo! ");
INSERT INTO kby_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wundu duwon nawi adǝa kǝrǝnjiwawodǝ curo jamadǝyen sulat baworo walji,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Koro Nawi Samailayen tamiya har tayi ngawonju jaanaro kudero, nawiya manajana samma ye kawu ania mawojana. ");
INSERT INTO kby_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nayima tadawa nawiyadǝye, koro warasawu aman duwon Ala kaariyando-a ndǝpcanadǝye wo. Tiye Nawi Ibrahimbo: “Kaduwunǝmben jama duniaye sammaro barga dǝpkǝkki,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Daji tia wakkilnjuro galayenniya, nayimaro duwon juwangeyera, barga dǝmnjaa, wundundoa yaye jawalnju diwilan cuttuluworo,» yeno Biturusse. ");
INSERT INTO kby_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Biturus-a Yahaya-a jamadǝro manajai ngai duwon, ɍimanna-a kura Fado Alaye gureduwuye-a Sadusiya-a nanjaro isane ");
INSERT INTO kby_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","jauro gǝrgajana, dalilnjudǝ Biturus-a Yahaya-a jamadǝa alamjai ye, Isa cijǝnadǝ gai karmolan cidu mbeji mawojai ye nangaro. ");
INSERT INTO kby_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kadiranniya, tayia cadane dunia lǝmjǝna nangaro kosoro casakke koljane wayera. ");
INSERT INTO kby_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Adǝ yaye am manadǝa fanjanadǝye ngǝwunja kasaccane, am Isaa gawudǝ alama dǝwu uwu gairo walyera. ");
INSERT INTO kby_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wajǝnanjua fuwuwu-a amwurawa-a malǝmba Attauraye-a Jerujalemnin capkadara. ");
INSERT INTO kby_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Curonjan Annas ɍiman kura-a Kaifas-a Yahaya-a Aleksanda-a am gade fado ɍiman kuraye samma-a mbeji. ");
INSERT INTO kby_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Biturus-a Yahaya-aa casakke dawunjan dayeranniya, tayiro: «Kǝnduwo fin bi cu wunduyen awo adǝa kiduw?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Daji Ruhu Alaye Biturussa cakke tayiro: «Nayi fuwuwu jamaye-a amwurawa-a, ");
INSERT INTO kby_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ku ser ngurdiyiro njǝddo-a jiɍi fin kam adǝ ngajǝna-aye kǝlan andia saworuwia, ");
INSERT INTO kby_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nayi-a jama Israyilaye samma-a ngǝlaro nonowo, cu Isa Almasiwu kam Najaratte, kam duwon nayi kǝskaro jaawe Ala ye tia karmolan cǝsangǝnadǝ, ti nangaro kam adǝ kǝlewa salai fuwundon daada. ");
INSERT INTO kby_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Isadǝ tima kau duwon nayi fado tandomaso wanuwe kau tandoye sammaro faidaaro waljǝnadǝ wo. ");
INSERT INTO kby_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tilan gǝnia, na wunduma gadeyen njǝkkawo fando bawo! Dunia ngaman cu gade ambo amardǝgǝna tilan njǝkkawo fandiyedǝ bawo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Biturus-a Yahaya-aye karwukibbanjadǝa carune tayidǝ ilmuwu gǝni, talaawaro asuyeranniya, ajapkera. Koro tayi Isa-a rokkoro asuyera. ");
INSERT INTO kby_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amma kam ngajǝnadǝ gǝre Biturus-a Yahaya-ayen daadaa carui nangaro, awo kalaktuwuye tayiro katkero. ");
INSERT INTO kby_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Daji majilisdǝn tayiro caluwo cane sawardane kattenjan: ");
INSERT INTO kby_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Awi gǝle am aniro yiddiye? Tabbat, am Jerujalemnin dasaana samma alama ajabba tayiyen tǝdǝnadǝa dam nojana, andi ye rangiye kattuwu niyewawo. ");
INSERT INTO kby_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bare lawar adǝ jama sammaro tatardǝgǝnniro tayia wusaniyo, kua adǝn fuwun bare wundumaro cu adǝyen mana cadǝnni,» yera. ");
INSERT INTO kby_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Daji tayia bowojane bare jande bi alamdu fimaa cu Isayen cadǝnni yera. ");
INSERT INTO kby_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma Biturus-a Yahaya-aye tayiro kalakcagane: «Alayedǝnna, nayia ga ra Alaa gadǝma kalkal woro sharanowo! ");
INSERT INTO kby_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Andidǝ kǝla awo ruiyena-a fanniyena-ayen rangiye nǝmmiyewawo,» yera. ");
INSERT INTO kby_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Koro nangadembo majiliswudǝ tayia wusayeranniya, kolyera. Jawal tayiro wowom gǝnaduwuye cawandǝnni, dalilnjudǝ jama samma kǝla awo wakkajǝnadǝyen Alaa congori nangaro. ");
INSERT INTO kby_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kam tiro alama adǝ tǝdde ngajǝnadǝ kǝrwunju fidewumaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Biturus-a Yahaya-aa kolyeranniya, lejane amnjaro awo wurawa ɍimannaye-a amwurawa-a tayiro wuljaana sammaa wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Adǝa fangeranniya, kǝla tilonna kowo sapcane Alaro: «Kǝma, nima same-a cidi-a teku-a awo curonjan dasaana samma-aa alangǝm! ");
INSERT INTO kby_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nima Ruhunǝmlan ci wakkilnǝm kaarinde Nawi Daudayen wulyem: «“Awiro jama kǝrdiyaso hangalsango cadǝna, jama duniaye ye bowuro sawardanadǝ? ");
INSERT INTO kby_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Maiya duniaye dabbargadara, fuwuwuso ye capkadara, Kǝmande-a Almasiwunju-aro tuɍu caddi yera.” ");
INSERT INTO kby_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Jiremaro curo bǝrni adǝyen Mai Hirudus-a Gomna Buntus Bilatus-a am larduwa gadesoye-a jama Israyilaye-a Isa wakkilnǝm tayir galanǝmmadǝro tuɍu caddi cane capkadara. ");
INSERT INTO kby_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ngaima awo calan kǝnduwonǝmnin kadarnǝmma sammaa kedo. ");
INSERT INTO kby_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kǝrma Kǝmande, marmareanjadǝa rui, andi kaɍeawanǝmdǝro mananǝm karwukibbuaro wulduro sade! ");
INSERT INTO kby_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mukkonǝm ye sane, cu wakkilnǝm tayir Isayen am isangaduwu so, alama so, awo ajabba so wakkaja!» yera. ");
INSERT INTO kby_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Alaa lowojane keserǝnniya, na captanadǝ loloje Ruhu Alaye tayi sammaro jǝpciye karwukibbuaro mana Alayedǝa wuldu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jama Isaa gawudǝ samma karwunja ye tilo, hangalnja ye tilo. Wunduma kǝndanju ti runjuye cǝniwawo, amma awonja sammaa kallo cadai. ");
INSERT INTO kby_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kǝngayambadǝ kǝnduwo dama bawoaro sheda kǝla karmolan cidu Kǝma Isayen cadi, koro ser kura tayi sammalan dǝgai. ");
INSERT INTO kby_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ngaima curonjan kam curo lambiyen dǝgana falma bawo. Am samma kuloso bi fadoso cadanadǝ calade wuɍidǝa cawude ");
INSERT INTO kby_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mukko kǝngayambayero casakki, tayi ye wundu yayero kǝla mǝradunjuyen dagarjagai. ");
INSERT INTO kby_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Adǝgaima kam laa kaduwu Lewiye cuku Kuwirussen tambǝna tiro Isuwu cani mbeji. Kǝngayambadǝ tia Barnabaslan bowojai, maananjudǝ kowoɍi njoma. ");
INSERT INTO kby_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kulo cǝdana laaa cǝlade wuɍidǝa cuwude mukko kǝngayambayero kekko. ");
INSERT INTO kby_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amma kam laa cunju Ananiya kamunju Safiratu-a rokko kulo cǝlade ");
INSERT INTO kby_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nodu kamunjuyelan wuɍidǝye laaa roje laaa cuwude mukko kǝngayambadǝyero kekko. ");
INSERT INTO kby_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Daji Biturusse tiro: «Ananiya, awiro Yiwulissa kollǝme karwunǝmbo ngaye har Ruhu Alayero kattuwu kamgǝme wuɍi kulodǝye laaa royem? ");
INSERT INTO kby_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kawu ladǝmidǝro kulodǝ kaanǝm, gǝna? Koro ladǝmmaye ngawon, wuɍidǝ ye mukkonǝmnin, mare? Awiro gǝle karwunǝmlan nianǝme awo adǝa kidǝm? Kambo gǝni, Alaro diye kattuwu kamgeyem!» ");
INSERT INTO kby_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya mana adǝa fangenniyama, bǝp cure kano. Am lawar adǝa fanjanadǝ samma jauro riyera. ");
INSERT INTO kby_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Daji jairowa laa isane kaminnjudǝa jakcane ngojane caade sittǝrayera. ");
INSERT INTO kby_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sa yakku gai kojǝnaye ngawon, kamunju awo wakkajǝnadǝa nojǝnnin kadio. ");
INSERT INTO kby_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Biturusse tiro: «Wulsǝgǝne, wuɍi adǝmaro wa kulodǝa kiladuw?» cǝne kiworǝnniya, kamudǝye: «Aaa, wuɍi adǝmaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Daji Biturusse tiro: «Awiro Ruhu Kǝmandeyea rijapturo citilo kiduw? Akko am kwanǝmba sittǝrajanadǝ cinnalan, ni yea njasadi!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sadǝman fuwu Biturussen bǝp cure kano. Jairowadǝ kasargaanniya, nuna najagane caade gǝre kwanjuyen sittǝrayera. ");
INSERT INTO kby_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jama Isaa gawudǝ-a am lawar adǝa fanjana samma-a jauro riyera. ");
INSERT INTO kby_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kǝngayambadǝ dawu jamayen alama so, awo ajabba so kada cadi. Koro Isaa gawudǝ samma Ngurwo Nawi Mai Sulemanayen karwu tiloaro captai. ");
INSERT INTO kby_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amma curo am gapcanadǝyen wunduma kowoɍi cǝde tayiro kǝldǝgǝnni, adǝ yaye amdǝ tayiro daraja cadi. ");
INSERT INTO kby_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Cayemaa kojǝnaro am Kǝmaa kasaccana kwan kamun kada kadami jamanjuro kǝldagai. ");
INSERT INTO kby_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Adǝ cakke bǝrniwu am dondi lairo cattuluwe kǝla dǝgǝl so, buji soyen gǝnajai. Ngaima Biturus kojiya, waneye kaudinju am aniye laanjaa jakci. ");
INSERT INTO kby_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Am kada ye bǝlamaskiya Jerujalemben isane amnja dondi-a karuwamaso-aa cawude tayi samma nanlewa cawandi. ");
INSERT INTO kby_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Daji ɍiman kura-a am ngawonjuye kǝwu Sadusiyaye-a nandǝɍi tayia kek cǝdana duwon cijane ");
INSERT INTO kby_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","kǝngayambadǝa mukkon cadane kosoro kesakko. ");
INSERT INTO kby_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amma bune malaiya Kǝmandeye laa cinna kosorambedǝa kaje kǝngayambadǝa cuttuluwe tayiro: ");
INSERT INTO kby_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Lenowo, Fado Alayen danowo, jamaro kawuɍi ro fando adǝye mananju sammaa wulgǝnowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Adǝa fangeranniya, suwa lǝp Fado Alayero ngasaye alamdu badiyera. Ɍiman kura-a am ngawonjuye-a majilisso kadiranniya, majiliswu-a amwurawa jama Israyilaye samma-aa capcane kǝngayambadǝa kudoro gureduwu Fado Alayea kosorambo kenodo. ");
INSERT INTO kby_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amma gureduwudǝ leyeranniya, tayia najaganni. Daji waldane lawar cawude ");
INSERT INTO kby_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","majiliswudǝro: «Kosoramdǝ ye kǝrǝp jakkada, gureduwudǝ ye cinnalan daada nayeyeiye. Amma kayeiyendeya, curon wundumaa fandiyende!» yera. ");
INSERT INTO kby_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kura gureduwu Fado Alaye-a wurawa ɍimannaye-a adǝa fangeranniya, kǝla tayiyen awi wakkajiro hangalnja caa cijǝna duwon, ");
INSERT INTO kby_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","kam laa ise tayiro: «Akko am kosoro yakkuwwadǝ Fado Alayen daada jamadǝa alamdu cadi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Daji kura gureduwu Fado Alayedǝ sojiyanju-a lejane tayia kewudo, amma dunodunon gǝni, dalilnjudǝ jamaa rijana bare tayiro kau gǝgǝpcagane ceyesǝnniro. ");
INSERT INTO kby_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tayia kewudǝnniya, fuwu majiliswuyero casakke dajane ɍiman kuradǝ tayia koro badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tayiro: «Ngǝlamaro nayiro cu adǝlan alamdu damnjagaiyena, gǝna? Akko alamdundo Jerujalem sammaro tatargǝwwa, koro bu kam adǝye andiro gǝrduwu manuwi!» ");
INSERT INTO kby_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amma Biturus-a kǝngayamba gadedǝ-aye tayiro: «Kam gǝni, Alaa ga andiro wajimsaa! ");
INSERT INTO kby_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ala Kǝma kaariyandeyedǝ Isa kam duwon kǝskaro jaawe yejuwwadǝa karmolan cǝsange ");
INSERT INTO kby_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","kǝmboramnjulan sapce jama Israyilaye tuwa cado biwunja cinjoro tia Mai ye, Njǝkkayima yero kido. ");
INSERT INTO kby_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kǝla lamar aniyen andi ye shedawu, Ruhu duwon Ala am tia jaanaro cinadǝ ye shedama,» yera. ");
INSERT INTO kby_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Majiliswudǝ adǝa fangeranniya, jauro gǝrgajane tayia njejoro mayera. ");
INSERT INTO kby_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma Farisa laa cunju Gamaliyel goni Attauraye jama samma tiro daraja cadǝnadǝ dawu majilissen cije wada ce amdǝa sa ganaro cattuluwo yeno. ");
INSERT INTO kby_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Daji majiliswudǝro: «Jama Israyilaye, awo am aniro yidduwidǝro hangal gǝnanowo! ");
INSERT INTO kby_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tussǝnnin Taudas ise kǝlanjua kam laaro ngoje am yer dewu gai ngawonjuro kasargawo. Amma awimaro waljǝnni, tia roro ceyese am tiro kǝldaana samma tatargadara. ");
INSERT INTO kby_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ngawo tiyen Yahusa kam Galileye jaman kom jamayen ise am laaa cakke ngawonju geya. Amma ti ye bawoje am tia jaana samma tatargadara. ");
INSERT INTO kby_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","To, nayiro wulnjagakki, bare am aniro suwolduwwi, kollowo leja! Nia adǝ bi kǝndo adǝ kamben kadioa, baworo walji. ");
INSERT INTO kby_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma Alayen kadioa, tayia ranguwwawo. Bare duwunwu Alayero walluwwi,» yeno. Majiliswudǝ gala Gamaliyelledǝa ngojane ");
INSERT INTO kby_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","kǝngayambadǝa bowoyeranniya, tayia babakcane wada cade bare cu Isayen manajanni cane tayia koljane leyera. ");
INSERT INTO kby_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Majilisdǝn sapkadaranniya, Ala tayiro kǝla cu Isayen martawa nangu njaye cinaro karwunja kǝjiyeno. ");
INSERT INTO kby_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yim nguson Fado Alayen kal, fado fadolan kal, kawuɍi kǝji jamaro Isadǝ tima Almasiwu woro wuljagane alamjai kasarga. ");
INSERT INTO kby_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yim anin nanngǝwu fuwurawadǝye tǝrgai duwon, curonjan am tǝlam Gǝresse manajaidǝ kamuwanja kwa faccǝgǝnaa dagar wajisoyen cǝpcagai cane kǝla am tǝlam yaudiyaye manajaidǝyen kesiro. ");
INSERT INTO kby_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kǝngayamba mewun yindindǝ fuwurawa sammaa capkeranniya, tayiro: «Mana Alaye wuldu kollǝme dagar kǝmboyero kistuwudǝ andiro jussǝnni. ");
INSERT INTO kby_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Adǝ nangaro, kǝramiyande, curondon am rashidu, amanna, Ruhu Alayea tulur kǝrenowo, kida adǝa mukkonjaro yakkiyo, ");
INSERT INTO kby_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","andi ye moduwa-a kidande kawuɍi Alaye wuldu-alan fuwu buiye,» yera. ");
INSERT INTO kby_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jama captana samma awo wuljanadǝye kǝjinju fanjane, daji Istifanus kam jauro kambǝrsea koro Ruhu Alayea, Filibus, Burokorus, Nikanor, Timon, Barminas, Nikolas kam bǝrni Antakiyaye fǝrdunju kǝrdi duwon yaudiro waljǝnadǝa kǝreyera. ");
INSERT INTO kby_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Daji tayia fuwu kǝngayambayero cawude moduwa cade tayiro mukko gǝnayeyera. ");
INSERT INTO kby_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mana Alaye cayea kojǝnaro tatarde fuwurawadǝ Jerujalemnin jauro ngǝwujane, koro ɍimanna kada ye kambǝrsedǝa kasatkera. ");
INSERT INTO kby_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanusdǝ jauro ser-a kǝnduwo-aa awo ajabba so, alama so kada dawu jamayen cǝdi. ");
INSERT INTO kby_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Daji yaudiya laa dandal tiro Kaɍeawa Nankam Kǝlaye Cawandǝna canidǝye Istifanussa kambiwudu badiyera. Am aniye laanja bǝla Kuraneye-a bǝrni Aleksandariyaye-a, laanja ye cidi Kilikiyaye-a Asiyaye-a. ");
INSERT INTO kby_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amma nanrashidu-a Ruhu-alan manaji nangaro rakcane tia yapcagaiwawo. ");
INSERT INTO kby_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Daji am laaa asǝrlan casakke tayiye: «Istifanus Nawi Musa-a Ala-aa bassi fanniyena!» cane ");
INSERT INTO kby_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","jama-a amwurawa-a malǝmba Attauraye-aye hangal kesango. Daji isane tia dunodunon cadane majilisso kesado. ");
INSERT INTO kby_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Shedawu kattuwuye yea cawude tayiye: «Kam adǝ dadu baworo mana kuttu kuttu kǝla na tayir adǝ-a Attaura-ayen cǝdi. ");
INSERT INTO kby_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tiye Isa kam Najarattedǝ na adǝa wurje ada Nawi Musa sadǝnadǝa falji cǝne fanniyena,» yera. ");
INSERT INTO kby_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tayi majilislan napkada samma simnin Istifanussa cappo kerunniya, fǝkkanjudǝa fǝkka malaiyaye gairo kero. ");
INSERT INTO kby_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Daji ɍiman kuradǝye Istifanusso: «Awo kǝlanǝmlan wuljaidǝ jire wa?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tiye: «Kǝramiyani so, bawani so, fannowo! Kaarinde Nawi Ibrahim cidi Mesofotamiyayen duwon, kawu bǝrni Harannen dǝgaidǝro, Ala Darajayedǝ tiro fǝlediye: ");
INSERT INTO kby_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Lardunǝm-a kǝramiyanǝm-aa kolle, lardu niro fǝlenjǝgǝkkidǝro lene!” yeno. ");
INSERT INTO kby_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Adǝgaima Nawi Ibrahim cidi Kaldiyawuyea kolje leje Haranlan napkeno. Ngawo bawanju bawojǝnayen, Ala tia lardu na ku dǝgawwa adǝro kiwudo. ");
INSERT INTO kby_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amma Ala cididǝn tiro warasa guwattu falma cinni. Adǝ yaye Ala tiro wadu ngojiye cididǝa ti-a kaduwunju-aro ci cǝnna. Sa adǝn tada fimaa cambǝnni. ");
INSERT INTO kby_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Daji Alaye tiro: “Kaduwunǝm lardu gadero lejane sikudoro waljai. Nadǝn kaɍearo waljane saa yer dewuro tayia basarjai. ");
INSERT INTO kby_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amma wudǝ jama tayia kaɍeanjaro cadǝnadǝro wowom gǝnagǝkki. Ngawo adǝyen lardudǝn caluwe isane na adǝn wuro ambǝnsagai,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Daji Nawi Ibrahimbo aman kajaye kaino. Adǝgaima Nawi Ibrahim Isakua cambe kawu wuskua kajayeno, Nawi Isaku ye tadanju Yakubaa, Nawi Yakuba ye kaariya mewun yindin Israyilawuyea. ");
INSERT INTO kby_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Kaariyadǝ Nawi Isuwuro nandǝɍi cadde calade lardu Masarrero kesado. Amma Ala tia koljǝnni, ");
INSERT INTO kby_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","curo bonenju sammayen tia kittuluwo. Ala cakke jauro rashiduro walje Fira'auna Mai Masarredǝ tia kasacce, har wajirinjuro galaje Masar-a mairi samma-a cunodiro walyeno. ");
INSERT INTO kby_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Daji kǝna so, bone kura so lardu Masarre-a Kan'anaye-a sammaro ngasaye, kaariyandero awo kǝmboye fandoro katkero. ");
INSERT INTO kby_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nawi Yakuba Masarnin algamaaro fangenniya, kaariyandedǝa kinodo. Adǝ ledunja burwoye. ");
INSERT INTO kby_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ledunja yindiyedǝn Nawi Isuwu awaanawanjuro asudiye, Fira'auna ye fǝrdu Isuwuye noyeno. ");
INSERT INTO kby_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Daji Nawi Isuwu cunode bawanju Nawi Yakuba-a jamanju samma-a bowoyera. Nanngǝwunja am fitulur lukko uwun. ");
INSERT INTO kby_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Adǝgaima Nawi Yakuba Masarro leje ti-a kaariyande-a nadǝn bawoyera. ");
INSERT INTO kby_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tayia bǝrni Sikembero cawude kauri duwon Nawi Ibrahim wuɍinjun na kaduwu Hamorren Sikemnin cuwǝnadǝn sittǝrayera. ");
INSERT INTO kby_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Wadu Ala Nawi Ibrahimbo ngojǝgǝnadǝye sanju karǝngenniya, jamadǝ Masarnin tasargane ngǝwujai kasarga duwon, ");
INSERT INTO kby_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","har mai gade Nawi Isuwua ti wunduro nojǝnni Masarnin kǝrmai kiwando. ");
INSERT INTO kby_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jamandero nanga cǝdde kaariyandea basarje cakke timallanja koljane kasuno. ");
INSERT INTO kby_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jaman adǝn Nawi Musa katambo, tidǝ jauro shawa. Kǝndawu yakkuro fado bawanjuyen tia keɍiwo. ");
INSERT INTO kby_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kolyeranniya, fero Fira'aunaye tia ngoje tadanju gairo kiɍiwo. ");
INSERT INTO kby_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ngaima Nawi Musaa ilmu Masarwuye samman alamjane mananju-a kǝndonju-alan kǝnduwoaro walyeno. ");
INSERT INTO kby_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Kǝrwunju fidewua duwon, Nawi Musa amnju Israyilawudǝa kuroro nia ngoyeno. ");
INSERT INTO kby_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kam Masarre laa falnjaa basarji kirunniya, kam jǝktǝnadǝa banajiye nguwunjuro ngaye Masarmadǝa bakce kejo. ");
INSERT INTO kby_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Amnjudǝ Ala tayia mukkonjuyen cǝkkayiro asujai tǝmayeno, amma asujanni. ");
INSERT INTO kby_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wajǝnanjua Israyilawu yindi lawala cadi nayeyenniya, tayia soloduro maje: “Kǝramiyani, nayidǝ jiɍindo tilo. Awiro gǝle kattendon basarduwidǝ?” yeno. ");
INSERT INTO kby_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Amma kam kamanjua basarjidǝ Nawi Musaa tǝmbalje tiro: “Wundu nia fuwumande-a alkalinde-aro galanjo? ");
INSERT INTO kby_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ra, bikka kam Masarredǝa yejǝmmadǝ gai, wu yea roro njejoro masǝmi?” ");
INSERT INTO kby_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kǝla mana adǝyen Nawi Musa cǝgase leje cidi Midiyannen sikudoro walje napkeno. Nadǝn tada yindi kembo. ");
INSERT INTO kby_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Kǝrwu fidewu kojǝnaye ngawon, malaiya laa karaa dǝɍi kau kuruwu Sinaiyen dawu kannu coccoɍi cambiyedǝn tiro fǝleyaadan. ");
INSERT INTO kby_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nawi Musa adǝa kirunniya, ajapkeno. Kuroro karǝnji duwon, kowo Kǝmandeye nukce: ");
INSERT INTO kby_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Wuma Ala kaariyanǝmbe, Ala Ibrahimbe-a Isakuye-a Yakubaye-adǝ wo,” yeno. Nawi Musa loloje riduro curunni. ");
INSERT INTO kby_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Daji Kǝmandeye tiro: “Sunonǝm sinǝmlan fidde, na danǝmmadǝ cidi tayir nangaro. ");
INSERT INTO kby_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ajawu jamani Masarnin casaidǝa fagat rukkǝna, njǝmdunja ye fakkǝna. Tayia njǝkkaworo jǝpkekko. Kǝrma are, nia Masarro njunodǝkke!” ");
INSERT INTO kby_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Nawi Musa adǝ, kam duwon Israyilawu wajane tiro: “Wundu nia fuwuma-a alkali-aro galanjo?” wuljaanadǝ, tidǝmaa Ala mukko malaiya dawu coccoɍiyen tiro fǝledǝgǝnadǝyen fuwuma-a meruduma-a gairo cunodo. ");
INSERT INTO kby_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tima lardu Masarre-a Bǝrǝm Maliyaye-a karaa dǝɍi-alan kǝrwu fidewuro awo ajabba so, alama so cǝdiaro tayia cuttuluwo. ");
INSERT INTO kby_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Koro ti Nawi Musa adǝma jama Israyilayero: “Ala curo kǝramiyandoyen nawi laa wu gai nayiro njasangi,” cǝne wuljuwo. ");
INSERT INTO kby_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sa jama karaan captanadǝn, tima kaariyande-a malaiya kǝla kau Sinaiyen tiro manajǝgǝnadǝ-a rokko dasaanadǝ wo. Koro kawuɍi ro fandoye andiro isanosaaro kiwando. ");
INSERT INTO kby_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Amma kaariyandeso tia fandu wajane tǝmbaljane karwunjan Masarro waljane ");
INSERT INTO kby_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nawi Harunaro: “Andiro sǝnǝmba fuwunde gǝrjai sattande! Musa andia lardu Masarren sattuluwuna adǝ, awo tia cuwandǝna noniyende,” yera. ");
INSERT INTO kby_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","«Yim anin kǝnna laa gumkiro cagare tiro bu fida cadde kǝndo mukkonjaye kǝjinju fangera. ");
INSERT INTO kby_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Daji Ala tayiro ngawo ce sillowusoro ambǝccaaro tayia salamgeno, kitawuwa nawiyayen ruwuwadadǝ gai: “Jama Israyilaye, wu nangaro wa saa fidewuro curo karaa dǝɍiyen bu fida so, sadaa so kiduw? ");
INSERT INTO kby_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A'a, leima Molekke-a sillowu sǝnǝm tiro Refan caniye-aa ngonuwe kallo dadayew, sǝnǝmba duwon nayima tayiro ambǝttuwuro tanduwwadǝ. Adǝ nangaro wu ye nayia ngawo bǝrni Babilayero dunjagakki!” ");
INSERT INTO kby_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Kaariyande karaan leima shedaye cadana, jiɍi Ala Nawi Musaro wada ce tia kǝla fasalnju curunayen kalkallo cǝdandǝnaro wuljǝgǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jaman Nawi Yoshuwayen sa duwon Ala fuwunjan jamasoa duje lardunja camowonadǝn, kaariyande ye leimadǝa ngojane na adǝro kewudo, har jaman Nawi Mai Daudayero kudero. ");
INSERT INTO kby_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nawi Mai Daudadǝ ardiya Alaye cuwande amari kǝndǝgairam Ala Kǝma jama Israyilayero yittandoye cuworǝna, ");
INSERT INTO kby_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","amma Nawi Mai Sulemanama fadodǝa Alaro cǝttando. ");
INSERT INTO kby_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Adǝ yaye Ala Mai Samema fadowa mukkon tadandǝnalan gǝni kǝrga. Nawi wuljǝnadǝ gai: ");
INSERT INTO kby_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«“Kǝmandeye: Samedǝ kurisni kǝrmaiye, cididǝ ye si gǝnadurammi. Fado jiɍi fi gǝle wuro sǝttanduwi? Ndara gǝle nani tustuyero walji? ");
INSERT INTO kby_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wuma gǝna mukkoniyen awo ani sammaa alangǝkko?” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Nayi gardawuso karwundo ye, sǝmondo ye kajadannidǝ, kullum Ruhu Alaye-a mǝlduwi! Nayidǝ kaariyandoso gai! ");
INSERT INTO kby_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nawiyadǝyen finjaa kaariyando basarjanni wo? Koro am kuren kǝla kǝnde ti Jiremayen manajanadǝ yea roro keyeso. Kǝrma nayi ye ti Jiremadǝye sǝrǝttuwumanjuso ye, kamcejinjuso yero walyew, ");
INSERT INTO kby_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","nayi duwon malaiyawayen Attauraa fanduwwa, amma kasatturo wanuwwadǝ!» ");
INSERT INTO kby_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Majiliswudǝ awo ania fangeranniya, karwunjan Istifanusso fum gǝrgajane sheɍinja gegaro. ");
INSERT INTO kby_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma Istifanus, Ruhu Alaye tia simojiyi duwon, simnju samero fijiye daraja Alaye-a Isa kǝmboramnjun daada-a kirunniya, ");
INSERT INTO kby_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","tiye: «Akko same kaada-a Tada Kambe kǝmboram Alayen daada-aa rukki!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amma kowo dunoaro sapcane sǝmonja jakcane tayi samma kǝla tilonna tiro fidagane ");
INSERT INTO kby_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ngawo bǝlayero cattuluwe tia njejoro kaulan gǝgǝptu badiyera. Shedawudǝ kalwuwanjaa na jairo laa tiro Shawulu canidǝyen gǝnayera. ");
INSERT INTO kby_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tiro kau gǝgǝpcagai duwon, Istifanus moduwa cǝde: «Kǝma Isa, roni moye!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Daji tungurumje kowo dunoaro sapce: «Kǝma, kǝla biwu adǝyen bare tayia korǝmmi!» yeno. Adǝa wulyenniya, ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu Istifanusse ro tuluwo ardiyeno. KIDA KƎNGAYAMBA ISAYE CIDI YAHUDIYAYE-A SAMARIYAYE-ALAN Yim adǝn basari kura kǝla jama Isaa gawu Jerujalemlan dasaanadǝyen ciyeno. Kǝngayambadǝro kajia, tayi samma cidi Yahudiyaye-a Samariyaye-aro tatargaadara. ");
INSERT INTO kby_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Muminna laa Istifanussa sittǝrajane tai dajane ti nangaro kesiro. ");
INSERT INTO kby_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amma Shawuludǝ jama Isaa gawudǝa baworo dio majialan, fado fadoro leje tayia kwan kamun cǝdane kosoro cakki. ");
INSERT INTO kby_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ngai duwon am tatardanadǝ bǝla bǝlaro lejane kawuɍidǝa wuljai, ");
INSERT INTO kby_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus ye bǝrni laa cidi Samariyayero leje Almasiwudǝa tayiro manaduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jamadǝ samma awo Filibus wuljidǝa fanjane alama ajabba ajabba cǝdidǝa kerunniya, karwu tiloaro hangalnja gǝnaada tia kǝrǝnjai. ");
INSERT INTO kby_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sedanso burwu dunoaro casakkiaro karuwama kadan caluwi, am tiyi nunaa so, ngurdiyi so kada ye ngajana. ");
INSERT INTO kby_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Adǝgaima bǝrnidǝn karwunja jauro kǝjiyeno. ");
INSERT INTO kby_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kam laa tiro Siman cani mbeji. Calan bǝladǝn sagawu cǝde am cidi Samariyaye tia ajapcai, koro kǝlanjua kam kuraro ngoji. ");
INSERT INTO kby_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tayi samma kuran ganan hangal gǝnaadaaro tia kǝrǝnjane: «Tima kǝnduwo Alaye tiro Kura canidǝ wo!» cani. ");
INSERT INTO kby_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tussǝna kǝla sagawunjuyen tia ajapcana nangaro, hangalnja samma kanjinjulan. ");
INSERT INTO kby_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma kawuɍi kǝji duwon Filibus tayiro kǝla nodo bargaa Alaye-a cu Isa Almasiwuye-ayen wuljǝgǝnadǝa kasatkeranniya, Filibus kwan kamunno tayiro kasala kiddo. ");
INSERT INTO kby_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Siman kǝlanjuma kawuɍi kǝjidǝa kasacce tiro kasala keddǝnniya, Filibusso kǝldiye alama so, awo ajabba so tǝdidǝa ajapkeno. ");
INSERT INTO kby_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kǝngayambadǝ Jerujalemnin duwon, am cidi Samariyaye mana Alayea kasaccanaro fangeranniya, tayiro Biturus-a Yahaya-aa juwayeyera. ");
INSERT INTO kby_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kadiranniya, Ruhu Alaye cawandoro tayiro moduwa keddo, ");
INSERT INTO kby_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","dalilnjudǝ tayiro cu Kǝma Isayen kasala caddǝna yaye, Ruhu Alaye wundunjamaro koroma jǝpcǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Daji tayiro mukko gǝnajagane Ruhu Alaye kewando. ");
INSERT INTO kby_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simandǝ Ruhu Alaye mukko gǝnada kǝngayambayen tinadǝa kirunniya, wuɍi ci cǝne ");
INSERT INTO kby_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","tayiro: «Kǝnduwo adǝa wu yero sewo, wundu duwon tiro mukko gǝnagǝkkǝnadǝ Ruhu Alayea cuwando!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amma Biturusse tiro: «Kǝnjo Alaye kungunalan moworo tǝmanǝmma nangaro, ni-a wuɍinǝm-a kannuye njawo! ");
INSERT INTO kby_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Lamar adǝn nuwanǝm ye bawo, lambonǝm ye bawo, karwunǝm na Alayen kalkal gǝni nangaro. ");
INSERT INTO kby_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tǝmme niadiwinǝm adǝa kolle Kǝmandea lowone, waneye awo karwunǝmbe gawurnjiyi. ");
INSERT INTO kby_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nidǝ, karwunǝm cǝlǝm fǝdǝk, koro biwun tikkerǝmmaro ngirukko,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Koro Siman walde tayiro: «Alaa wuro sukkorowo, bare awo wulluwwa adǝye falma wua suwandǝnni!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Daji sheda cade mana Kǝmaye ambo satkeyeranniya, Biturus-a Yahaya-a kawuɍi kǝjidǝa bǝla kada Samariyawuyen wuljaiaro Jerujalembo walladara. ");
INSERT INTO kby_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaiya Kǝmandeye laa Filibusso: «Cine kǝla anǝmninna lene jawal Jerujalemlan culuwe bǝrni Gajayero lejidǝa gai!» yeno. Jawal adǝ karaa dǝɍi. ");
INSERT INTO kby_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Daji cije jawal kidanniya, akko adim laa lardu Habashaye. Tidǝ kowona kura Kandatu Mai kamuye Habashawuye ye, baitǝmbalmanju ye. Jerujalembo Alaro ambǝttuwuro isǝna duwon, ");
INSERT INTO kby_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","amalenkenju kǝmbayen napkada waldu cǝdi, koro kitawu Nawi Ishayaye kǝraji. ");
INSERT INTO kby_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Daji Ruhu Alaye Filibusso: «Lene amalenkedǝa nagǝne!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibus cǝgase tia nayeyenniya, kitawu Nawi Ishayaye kǝraji fanje tiro: «Awo kǝranǝmidǝa asunǝmi wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tiye: «Kam laa gǝni bayinsuwoa, awiawin rangǝkki?» cǝne Filibussa juwa rokko napcaro doyeno. ");
INSERT INTO kby_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Curo kitawuyen na kǝrajidǝ tima: «Dimi duwarambo caadi gai, koro tama fuwu gǝrǝptawunjuyen nukciwawo gai, tidǝ ye mǝdǝk cinju kajǝnni. ");
INSERT INTO kby_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nanguro casakke jirenju dapkeyera. Wundu rakce kaduwunjuye mana cǝdi? Awoa ronju dunian cattuluwuna.» ");
INSERT INTO kby_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Adim Habashayedǝ Filibusso: «Marne, wulsǝgǝne kǝla wunduyen nawidǝ mana adǝa cǝdi? Kǝlanjun ra kǝla kam gadeyen?» ");
INSERT INTO kby_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Daji Filibus cinju kaje awo kitawulan ruwuwada adǝn tiro kawuɍi kǝji Isaye wulduwu badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ledu cadi duwon, na laa ingiaro kadiranniya, adimdǝ Filibusso: «Akko ingi! Awi wuro kasala njǝddoro damsiyi?» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibusse: «Karwunǝmnin kasaddǝmmaa, yoji,» yenniya, tiye: «Isa Almasiwuma Tada Alayedǝ woro kasaddǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Daji wada ce amalenke dajo yenniya, Filibus-a adimdǝ-a tayi yindi samma jǝpcane ingiro ngasaye Filibus tiro kasala kiddo. ");
INSERT INTO kby_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ingilan keluwunniya, Ruhu Kǝmandeye Filibussa na gadero kiado. Adimdǝ gadero tia curunni, amma karwu kǝjiaro jawalnju jǝgane leyeno. ");
INSERT INTO kby_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibusdǝ bǝrni Ajotussen duwon bǝla bǝlaro leje kawuɍi kǝji wulji, har bǝrni Kaisariyayero kadio. ");
INSERT INTO kby_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawuludǝ kua yaye fuwurawa Kǝmayero yikkado-a njejo-a majiaro na ɍiman kurayero leje ");
INSERT INTO kby_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wotiya dandalla bǝrni Damasselan dasaanaro ruwujaaro kiworo. Nianjudǝ nadǝn am Jawaldǝa jaana, kwa yen kal, kamu yen kal kiwandoa, tayia tikkerǝna Jerujalembo kudo. ");
INSERT INTO kby_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jawal cǝdane Damassa karǝnjǝna duwon, sadǝman nur samelan yiyilje tia dirije kǝlyeno. ");
INSERT INTO kby_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Daji cidiro bǝp cure kowo laa tiro: «Shawulu, Shawulu, awiro wua basarsǝmidǝ?» cǝne fangeno. ");
INSERT INTO kby_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","«Kǝma, ni wundu?» cǝne kiworǝnniya, tiye: «Wuma Isa basarsǝmidǝ wo. ");
INSERT INTO kby_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Cine bǝrniro ngaye, nadǝn kam laa niro awo dimidǝa wulnjiyi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Am tia casadduwunadǝ gǝm dayera. Kowodǝa fanjana duwon, wundumaa carunni. ");
INSERT INTO kby_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawulu cidin ciyenniya, simnju kaada yaye, awima curuiwawo. Daji tia jejane Damasso kasargawo. ");
INSERT INTO kby_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kawu yakkuro ti kambu, koro awima juwunni ye, canni ye. ");
INSERT INTO kby_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaslan fuwura laa Ananiya cani mbeji. Kǝmadǝ wahayilan tiro: «Ananiya!» yenniya, tiye: «Akkoni, Kǝma!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kǝmaye tiro: «Cine lai tiro cǝk canidǝro lene fado Yahusayen kam laa bǝrni Tarsusse Shawulu cani kore! Tidǝ moduwa cǝdi, ");
INSERT INTO kby_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","koro wahayilan kam laa Ananiya cani ngaye sim cuwandoro mukko tiro gǝnajiyi curuna,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya kalakciye: «Kǝma, kǝla kam adǝyen, jiɍi kuttu kada Jerujalemnin muminnanǝmbo cǝddǝnadǝa am ngǝwuyen fakkǝna. ");
INSERT INTO kby_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Koro na adǝn kǝnduwo mukko wurawa ɍimannayen am cunǝmba bowojaimaso sammaa geroye cuwandǝna.» ");
INSERT INTO kby_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amma Kǝmaye tiro: «Lene, fuwu jama kǝrdiya-a maiya-a jama Israyilaye-ayelan cunidǝa mawojoro tia kidamaniro kǝrenǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wu kǝlani bone cuni nangaro cai sammaa tiro fǝlegǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Daji Ananiya leje fadodǝro kǝrgaanniya, Shawuluro mukko gǝnajiye tiro: «Kǝramini Shawulu, Kǝma Isa duwon niro kǝla jawal tilan isǝmmadǝyen fǝledǝgǝnadǝ sim fandǝme Ruhu Alaye jǝmnjuworo wua sunodo.» ");
INSERT INTO kby_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sadǝman awo laa kaskasi buniye gai simnjun casure sim kiwando. Daji cije tiro kasala keddo. ");
INSERT INTO kby_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ngawo adǝyen kǝmbo juwe duno kiwando. Shawulu bǝrni Damasselan fuwurawadǝ-a rokko kawu ganaro napkenniyama, ");
INSERT INTO kby_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","dandal dandallo leje Isama Tada Alayedǝ wo cǝne kawuɍinju wuldu badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Am tia fanjana samma ajapcane: «Tima gǝna kam Jerujalemnin am cu adǝa bowojaimasoa basarjidǝ wo? Koro tayia tikkerǝna wurawa ɍimannayero njadoro na adǝro isǝna, gǝna?» cani. ");
INSERT INTO kby_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amma Shawulu cayemaa kojǝnaro duno cuwande, har yaudiya Damaslan dasaanadǝro mana tiro kalaktuwuye katkero. Tabbat Isama Almasiwudǝ woro tayiro isanojiyi. ");
INSERT INTO kby_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ngawo kawu kadayen yaudiyadǝ sawardane nia Shawulua njejoye ngoyera, ");
INSERT INTO kby_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","amma Shawulu nianjadǝa fangeno. Bune-a kausu-a tia njejoro cinnawa bǝrniyedǝa gurejai, ");
INSERT INTO kby_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","amma bune fuwurawanju tia ngojane curo jowoyen garuyen talaryera. ");
INSERT INTO kby_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Shawulu Jerujalembo kadinniya, fuwurawadǝro kǝlduwuro mayeno, amma tayi samma tia riyera, dalilnjudǝ tia fuwuraro mǝrsajanni nangaro. ");
INSERT INTO kby_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Daji Barnabas tia na kǝngayambayero cuwude tayiro jiɍi kǝla jawallen Kǝma tiro fǝlediye mana cǝddǝna ye, koro Damaslan ridu bawoaro cu Isayen manajǝna yedǝa isanoyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sa adǝn Shawulu tayi-a rokko Jerujalemnin lenǝmare cadi, cu Kǝmayen ridu bawoaro manaji. ");
INSERT INTO kby_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Koro yaudiya tǝlam Gǝresse jandejaidǝro mana cǝdde kambiwu cadi, amma tayidǝ tia njejoro majai. ");
INSERT INTO kby_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Daji kǝramiyadǝ adǝa fangeranniya, tia bǝrni Kaisariyayero caade bǝrni Tarsussero juwayeyera. ");
INSERT INTO kby_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Adǝgaima jama Isaa gawu cidi Yahudiyaye-a Galileye-a Samariyaye-a samma dunoajane naptu nanlewaye cadi, koro Kǝmaa ridanja-a bana Ruhu Alaye-alan fuwu jawune ngǝwujai kasarga. ");
INSERT INTO kby_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Biturus lardu sammaa diriji duwon, na muminna bǝla Liddayen dasaanadǝ yero kadio. ");
INSERT INTO kby_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Bǝladǝn kam laa cunju Iniyas tiyinju nga nuna kǝrwu wuskuro kǝla bujiyen bowada mbeji. ");
INSERT INTO kby_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Biturusse tiro: «Iniyas, Isa Almasiwu nia isanganjǝgǝna. Cine bujinǝm kǝɍine!» yeno. Sadǝman Iniyas wup ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Am samma bǝla Liddaye-a faya Saronne-alan dasaanadǝ Iniyassa kerunniya, Kǝmaa gawuro walyera. ");
INSERT INTO kby_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Bǝrni Yafayelan fuwura laa kamuye Tabita cani mbeji, tǝlam Gǝresselan cunju Dokas. Surro ser ngǝwu cǝdi ye, talaawaa banajiyi ye. ");
INSERT INTO kby_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yim anin kasuwa laa tia cǝdane bawoyeno. Tia kasalyeranniya, curo soro sameyen gǝnayera. ");
INSERT INTO kby_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bǝla Liddayedǝ karǝn bǝrni Yafayelan nangaro, koro fuwurawadǝ Biturus bǝladǝn mbejiro fangeranniya, am yindi juwajagane tia lowojane: «Nandero duwan are!» yera. ");
INSERT INTO kby_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Daji Biturus cije tayi-a rokko leyera. Kadiranniya, tia soro sameyedǝro kesado. Kamuwa kwa faccaanaa samma cesiriaro gǝrenjun dajane tiro kalwu so, gǝmaje so Dokas sa tayi-a rokkodǝlan cududǝnaa fǝfǝlejagai. ");
INSERT INTO kby_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Biturus jamadǝa ngimdǝn cuttuluwe tungurumje moduwa kido. Daji kamindǝro suwordiye: «Tabita, cine!» yeno. Sim kaje Biturussa kirunniya, cije napkeno. ");
INSERT INTO kby_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Biturus mukkoyen tia cǝdane kisango. Daji kamuwa kwa faccaanaadǝ so, muminna gadedǝ soa bowoje tia ronjua tayiro kalakkeyeno. ");
INSERT INTO kby_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lawar adǝ bǝrni Yafaye ngaro tatardiye am ngǝwu Kǝmaa kasatkera. ");
INSERT INTO kby_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Daji Biturus bǝrnidǝn fado mǝndǝlma laa tiro Siman canidǝyen jǝpce kawu kadaro napkeno. ");
INSERT INTO kby_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Bǝrni Kaisariyayelan kam laa cunju Korneliyus, ti soji kura Rombe curo kǝwu Italiyaye caniyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ti-a am fannjuye-a adinwu ye, Ala ridawu ye. Sadaa ngǝwu jamaro ci, koro sawiso Alaa lowoji. ");
INSERT INTO kby_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yim laa kanji sa yakku kajiriyen wahayilan malaiya Alaye laa nanjuro ise tiro: «Korneliyus!» cǝni kiro. ");
INSERT INTO kby_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tia riyadaro simnin cappo cure tiro: «Kǝma, awi?» yenniya, malaiyadǝye: «Moduwanǝm-a sadaanǝm-a awo taktuyero fuwu Alayero isana. ");
INSERT INTO kby_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","To, kǝrma am bǝrni Yafayero juwagǝne, kam laa Siman tiro Biturus canidǝa bowoja iso! ");
INSERT INTO kby_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Fado mǝndǝlma laa Siman caniyen jǝpcǝna. Fannjudǝ ci tekuyen.» ");
INSERT INTO kby_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malaiya tiro jandejǝgǝnadǝ sapkadanniya, Korneliyus curo wolodiyanjuyen yindi-a koro curo sojiyanju tiro kida caddiyen mumin fal-aa bowoyeno. ");
INSERT INTO kby_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tayiro awo wakkajǝna sammaa wuljiye bǝrni Yafayero kinodo. ");
INSERT INTO kby_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wajǝnanjua dunia kausu dawu gai am Korneliyus cunodǝnadǝ kǝla jawallen bǝrnidǝa karǝnjana duwon, Biturus moduwa dioro kǝla sorodǝyero tatkeno. ");
INSERT INTO kby_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Daji kǝna fanje masǝna dio kirawo. Kǝmbo dejai duwon, wahayi laa tia kida. ");
INSERT INTO kby_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Akko same fǝrǝmde awo laa alama batta kura-a camun talgǝmonju dewuyen tǝdana cidiyaro jǝpci kiro. ");
INSERT INTO kby_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Curonjun lǝmanna si dewua so, nganjin gǝrdawu so, ngudowa so jiɍi nguson mbeji. ");
INSERT INTO kby_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kowo laa nukce tiro: «Biturus, cine! Duwane ngǝre!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amma Biturusse: «A'a, Kǝma! Ngaltema awo haram so, tayir gǝni so bukkǝni,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Koro kowodǝ walde tiro: «Awo Ala halallo cǝdǝnadǝro bare tayir gǝni wullǝmmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Adǝ yakkuro wakkayenniya, sadǝman battadǝ kǝla samennaro ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Biturus kǝla maana wahayidǝyen hangalnju caa cijǝna duwon, akko am Korneliyus cunodǝnadǝ fado Simanne cawore cawande cinnadǝn dajane ");
INSERT INTO kby_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","kowo sapcane: «Siman kam tiro Biturus canidǝ na adǝn wa kǝrga?» cane keworo. ");
INSERT INTO kby_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biturus kua yaye kǝla wahayidǝyen juwula cǝdi duwon, Ruhu Alaye tiro: «Akko am yakku nia manjai. ");
INSERT INTO kby_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cine jǝmme shekku bawoaro tayi-a rokko lenowo, wu kǝlani tayia nodǝkkǝna nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Daji Biturus jǝpce tayiro: «Wuma kam manuwidǝ wo. Awi njawudo?» cǝne kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","tayiye: «Soji kura Rombe cunju Korneliyus kam duwon jirema ye, Ala ridama ye, koro na jama yaudiya sammayen darajaadǝ, malaiya Alaye laa tiro nia fannjuro njuwudo mananǝm fanjo yeno.» ");
INSERT INTO kby_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Daji Biturus tayia fadodǝn cǝsaye sosayeno. Wayenniya, cije kallo leyera. Koro kǝramiya bǝrni Yafaye laa ye tia kesadduwo. ");
INSERT INTO kby_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wajǝnanjua bǝrni Kaisariyayero kadio. Korneliyusdǝ calan am fannjuye-a sawawanju-aa bowoje captana tayia gurejai. ");
INSERT INTO kby_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Biturus kadinniyama, Korneliyus tia kapciye fuwunjun nguje tiro sujada kiddo. ");
INSERT INTO kby_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amma Biturus tia cǝsange: «Cine! Wu ye adamgǝna, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jandejiyiaro fadodǝro ngaye am kada capkada nayeyeno. ");
INSERT INTO kby_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tayiro: «Yaudiro kam jiɍi gadero kǝlduwu-a fannjuro ngawo-a haramdǝ nayi kǝlando nonuwwa, amma Ala wuro bare wundumaa tayir gǝni bi harambo ngokkǝniro isanosǝgǝna. ");
INSERT INTO kby_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Adǝ nangaro sa wua bowosuwwadǝman garda bawoaro kadikko. To, nayia njaworǝkki, awi dǝlwu bowodundoye wo?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyusse tiro: «Ku kawu dewu sa adǝ gai fannin moduwa sa yakkuye dikki duwon, kam laa kajǝmu yiyiljia fuwunin fǝledǝne ");
INSERT INTO kby_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wuro: “Korneliyus, Ala moduwanǝm ye fanjǝna, sadaanǝm ye takcǝna. ");
INSERT INTO kby_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bǝrni Yafayero am node, Siman tiro Biturus canidǝa bowoja iso! Ci tekuyen fado Siman mǝndǝlmayen jǝpkeno,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sadǝman niro am njukkunodǝkko, ni ye kasaddǝme isǝmmadǝ, jauro ngǝla. Adǝ nangaro kǝrma andi samma fuwu Alayen awo Kǝmande wulsagane cǝnna sammaa fanduro captiyena,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Daji Biturus cinju kaje tayiro: «Jiremaro Ala amba gayirduma gǝni, ");
INSERT INTO kby_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","curo jama fiye yayen kam duwon tia rije jire cǝdidǝa ardijiro asunǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ala mananju jama Israyilayero cǝdde Isa Almasiwuyen kawuɍi kǝji nanlewaye tayiro wulyeyeno. Isama Kǝma am sammaye wo! ");
INSERT INTO kby_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ngawo Nawi Yahaya kawuɍi kǝla kasala tuwayen jamaro cǝddǝnayen, awo duwon cidi Galileyen badije cidi Yahudiyaye ngaro tatardǝgǝnadǝa nayi kǝlando nonuwwa: ");
INSERT INTO kby_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ala Isa kam Najarattea galaje tiro Ruhunju-a kǝnduwo-a kekko. Ala ti-a rokko nangaro dadaje ser cǝde am dondi kǝnduwo Yiwulissen dasaana sammaa isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Awo cidi yaudiyayen-a Jerujalemnin-a cǝdǝna sammaye andima shedawu wo. Kǝskaro jajagane keyeso yaye, ");
INSERT INTO kby_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kawu yakkua Ala tia cǝsange cakke fǝleyaadan, ");
INSERT INTO kby_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","amma jama sammaro gǝni, andi Ala calan shedawuro kǝresanadǝro, andi duwon ngawo Ala tia karmolan cǝsangǝnayen ti-a rokko buiyena ye, yaiyena yedǝ. ");
INSERT INTO kby_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Isaye andiro wada sade jamaro kawuɍinju yiddiyo, tayiro timaa diye Ala sharama am roaye-a sanunaye-aro galajǝnadǝ wodǝa satkǝiyo yeno. ");
INSERT INTO kby_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Caman nawiya samma kǝlanjun shedajane wundu duwon tia kasaccǝnamadǝ cunjulan gawara biwuwanjuye cuwandi canna.» ");
INSERT INTO kby_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Biturus mana ania wulji ngai duwon, Ruhu Alaye am kawuɍidǝa fanjai sammaro jǝpkeyeno. ");
INSERT INTO kby_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yaudiya Isaa gawu kajanjaa Biturus-a kallo isanadǝ ajapkera, dalilnjudǝ Ala Ruhunjudǝa kǝrdiya yero cina nangaro. ");
INSERT INTO kby_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Awoa tǝlam gadegaden mana cade Alaa congoridǝa fangera. Daji Biturusse: ");
INSERT INTO kby_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Am ani ye andi gai Ruhu Alaye cawandǝnadǝ, wundu gǝle tayiro kasala ingilan njǝddo dapciyi?» cǝne ");
INSERT INTO kby_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","wada ce cu Isa Almasiwuyen tayiro kasala keddo. Daji Biturussa kawu ganaro dawunjan napcoro lowoyera. ");
INSERT INTO kby_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kǝngayambadǝ-a kǝramiya cidi Yahudiyayelan dasaanadǝ-a kǝrdiya ye mana Alaye kasaccanaro fangera. ");
INSERT INTO kby_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Biturus Jerujalembo kadinniya, kǝwu am kajaadayedǝ tiro jakkade: ");
INSERT INTO kby_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Jǝmbǝlǝmbayero ngaame, har tayi-a rokko masǝna kiduw!» yera. ");
INSERT INTO kby_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Daji Biturus lamardǝa sawije tayiro wulduwu badije: ");
INSERT INTO kby_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Wu bǝrni Yafayelan moduwa dikki duwon, wahayi laaa kirukko. Akko awo laa batta kura gai talgǝmonju dewuyen tǝdana samen naniro jǝpkeno. ");
INSERT INTO kby_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Hangal gǝnaadaro kirukkǝniya, curonjun lǝmanna si dewua so, nganjin gǝrdawu so, bundiya karaaye so, ngudowa so mbeji. ");
INSERT INTO kby_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Daji kowo laa nukce wuro: “Biturus, cine! Duwane ngǝre!” cǝni fangekko. ");
INSERT INTO kby_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Amma wuye: “A'a, Kǝma! Ngaltema awo haram so, tayir gǝni so ciniro ngaanni!” yekko. ");
INSERT INTO kby_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Koro kowodǝ walde samen nukce: “Awo Ala halallo cǝdǝnadǝro bare tayir gǝni wullǝmmi!” yeno. ");
INSERT INTO kby_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Adǝ yakkuro wakkayenniya, awo samma walde kǝla samennaro ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Sadǝman am yakku bǝrni Kaisariyayelan naniro canodǝnadǝ fado dǝgaiyenadǝro kadira. ");
INSERT INTO kby_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruhu Alaye wuro shekku bawoaro tayi-a rokko leniyo yeno. Daji kǝrami arakku ani wua sasadduwe fado kamdǝyero kǝrgayiye. ");
INSERT INTO kby_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jiɍi malaiya laa fannjun daada curunadǝa andiro wulseyera. Malaiyadǝye tiro: “Am laa Yafaro node, Siman tiro Biturus canidǝa bowoja iso! ");
INSERT INTO kby_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mana duwon tilan ni-a am fannǝmbe samma-a njǝkkawo fanduwidǝa niro wulnjiyi,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ngaima mana dio ngǝssǝkkǝna duwon, Ruhu Alaye andiro burwon jǝmsaanadǝ gai, tayiro jǝpkeyeno. ");
INSERT INTO kby_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Daji mana Kǝmaye adǝa takkekko: “Yahaya ingilan ambo kasala kiddo, amma Ruhu Alayelan nayiro kasala njaddi,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","To, Ala kǝnjo duwon andi Kǝma Isa Almasiwua kasaddiyenadǝro sadǝnadǝ gairo tayi yero kalkallo cinadǝ, wu wundu duwon rangǝkke Alaro dapkǝkkidǝ?» ");
INSERT INTO kby_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Adǝa fangeranniya, karwunja fasse Alaa congorǝne: «Ala kǝrdiya yero amarjiye tuwa cade ro cawandi, diye!» yera. ");
INSERT INTO kby_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tayi duwon kǝla basari Istifanus nangaro cijǝnayen tatardanadǝ har lardu Fenisiye-a cuku Kuwirusse-a bǝrni Antakiyaye-aro leyera. Yaudiyaro kajia, kam gadero mana Alaye wuljaganni. ");
INSERT INTO kby_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Adǝ yaye amnja laa cuku Kuwirusse-a bǝla Kuraneye-adǝ bǝrni Antakiyayero leyeranniya, am tǝlam Gǝresse manajaidǝ yero kawuɍi kǝji kǝla Kǝma Isayen wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kǝnduwo Alaye tayilan kǝrga nangaro, am kada kasaccanadǝ Kǝmaa gawuro walyera. ");
INSERT INTO kby_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jama Isaa gawudǝ Jerujalemlan lamar adǝa fangeranniya, Barnabassa bǝrni Antakiyayero kenodo. ");
INSERT INTO kby_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bǝrnidǝro ise ser Ala tayiro cǝddǝnadǝa kirunniya, karwunju kǝjije tayi sammaro kowoɍi ce karwu tiloaro Kǝmaa jaa yeno. ");
INSERT INTO kby_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasdǝ kam ngǝlama, Ruhu Alaye-a kambǝrse-a tilan kasarga. Koro am gǝnagǝni Kǝmaro kǝllaadara. ");
INSERT INTO kby_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ngawo adǝyen Barnabas Shawulua madaro bǝrni Tarsussero leyeno. ");
INSERT INTO kby_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nayeyenniya, tia bǝrni Antakiyayero kiwudo. Saa fal latto jama Isaa gawudǝro kǝldagane am kadaa alamgera. Bǝrni Antakiyayelaman fuwurawadǝa kǝristalan bowodu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Yim anin nawiya laa Jerujalemlan bǝrni Antakiyayero kadira. ");
INSERT INTO kby_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Falnja Agabus cani cije Ruhu Alaye tia cakke kǝna kura laa dunia ngaro ngayi yeno. Kǝnadǝ jaman Kaisar Kǝlodiyussen wakkayeno. ");
INSERT INTO kby_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Fuwurawadǝ nia ngojane wundunja yaye kǝla raktunjuyen bana laaa kǝramiya cidi Yahudiyayen dasaanadǝro juwajiyi yera. ");
INSERT INTO kby_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ngainin kǝnjonja mukko Barnabasse-a Shawuluye-aro casakke amwurawadǝro juwayeyera. ");
INSERT INTO kby_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jaman adǝn Mai Hirudus jama Isaa gawuye laanjaa basardu badije ");
INSERT INTO kby_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yakuba yaana Yahayayea kashagarlan roro kejo. ");
INSERT INTO kby_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yaudiya adǝa caraanaro kirunniya, Biturus yea kida. Adǝ sa sala Burodi Yis Bawoayen wakkayeno. ");
INSERT INTO kby_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kidanniya, kosoro cakke tia gureduro mukko kǝwu dewu soji dewu dewuyero kekko. Nianjudǝ ngawo sala Laya Njǝkkayiramben tia fuwu jamayen burwudu. ");
INSERT INTO kby_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Biturussa kosolan rojana ngai duwon, jama Isaa gawudǝ ti nangaro tai dajane Alaa lowojai kasarga. ");
INSERT INTO kby_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yim wajiya Mai Hirudus tia cuttuluwidǝye bunenjua Biturus katte soji yindiyen saɍga yindilan tikkerǝna kǝnǝm cǝdi. Koro cinnalan kosoram gureduwu ye mbeji. ");
INSERT INTO kby_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sadǝman malaiya Kǝmandeye laa gǝrenjun daje nur sullurudǝa waskeno. Biturussa sisilan bakce cǝsange tiro: «Duwan cine!» yeno. Saɍgawadǝ mukkonjun fiyadara. ");
INSERT INTO kby_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Daji malaiyadǝye tiro: «Kajǝmunǝm lune, sunonǝm yakke!» yeno. Ngai kidǝnniya, walde tiro: «Barmusnǝm lune, wua sǝgai!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Biturus culuwe tia giya. Awo malaiyadǝ cǝdǝnadǝa jirero ngojǝnni, wahayi curuiro tǝmayeno. ");
INSERT INTO kby_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Daji kǝwu gureduwu burwoye-a yindiye-aa koyeranniya, cinna suye bǝrnidǝa wujidǝro kadira. Cinnadǝ kǝlanjuman fǝrǝmde caluwe lai fal geya. Sadǝman malaiyadǝ tiro fatkeyeno. ");
INSERT INTO kby_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Biturus hangalnjuro walladanniya, karwunjun: «Kǝrma Kǝmande malaiyanju cunode wua mukko Mai Hirudusse-a niadiwi jama yaudiyaye samma-alan suttuluwunadǝa jiremaro nokkǝna.» ");
INSERT INTO kby_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Biturus adǝa asuyenniya, fado Meram ya Yahaya tiro Markus caniyero leyeno. Fadodǝn am kada captana Alaa lowojai. ");
INSERT INTO kby_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Biturus cinna ngaworambedǝa bakkenniya, fero kidama laa Roda cani kaduro kadio. ");
INSERT INTO kby_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kowo Biturusse asuyenniya, jauro kǝji fanje cinnadǝa kajǝnnin ngǝrǝmje jamadǝro: «Biturus cinnan daada!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tayiye tiro: «Joɍinǝmma!» yera. Amma kǝladǝn daje ngaima yenniya, daji tayiye: «Malaiyanjuro walji,» yera. ");
INSERT INTO kby_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Biturusdǝ baktu koljǝnni. Kayeranniya, tia carune ajapkera. ");
INSERT INTO kby_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Daji gǝm cadoro mukko sapce tayiro jiɍi Kǝmande tia kosolan cuttuluwunadǝa wulyeyeno. Koro walde: «Yakuba-a kǝramiyadǝ-aro awo ania wulgǝnowo!» cǝne culuwe na gadero leyeno. ");
INSERT INTO kby_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dunia wayenniya, dawu sojiyadǝyen hangalsango gǝnagǝni kǝla awi Biturussa cuwandoyen ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mai Hirudus tia maji cuwandǝnnidǝ, kosoram gureduwudǝro koro cǝdde wada ce tayia roro ceyeso yeno. Daji Mai Hirudus cidi Yahudiyayelan cije bǝrni Kaisariyayero leje napkeno. ");
INSERT INTO kby_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mai Hirudus am bǝrni Tirre-a Sidonne-aro jaumaro gǝrgajǝgǝna. Tayidǝ karwu tiloaro fuwunjuro isane bana kowonanju Bilastus caniye kewandǝnniya, naptu nanlewaye keworo, dalilnjudǝ cidi maiyedǝ cidinjaa ambaji nangaro. ");
INSERT INTO kby_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sardu kamdǝgǝnadǝ kidǝnniya, Mai Hirudus kalwunju maila cakke kuris kǝrmaiyen napce tayiro jawawi kiddo. ");
INSERT INTO kby_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jamadǝ kowo sapkadaaro: «Kowo kambe gǝni, ala laaye!» cani. ");
INSERT INTO kby_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Alaro darajadǝa cinni nangaro, sadǝman malaiya Kǝmandeye laa tia bakkeno. Daji kuɍiso jawune ro kirǝmbo. ");
INSERT INTO kby_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mana Alayedǝ fuwu juwe cayemaa kojǝnaro tatardiyi kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas-a Shawulu-a kidanja bana kudoye Jerujalemnin keserǝnniya, Yahaya tiro Markus canidǝa ngojane walladara. ");
INSERT INTO kby_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Curo jama Isaa gawu bǝrni Antakiyayelan dasaanadǝyen nawiya-a malǝmba-a mbeji, tayima Barnabas, Siman tiro Cǝlǝm canidǝ, Lusiyas bǝla Kuraneye, Manayi kam Mai Hirudus-a gananjan rokko cijana, Shawulu. ");
INSERT INTO kby_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Asem cadana Kǝmandero ambǝccagai duwon, Ruhu Alaye tayiro: «Barnabas-a Shawulu-aa galasǝgǝnowo, kida duwon ti nangaro tayia bowokkǝnadǝa cado!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Daji asem-a moduwa-a cade tayiro mukkonja gǝnayeyeranniya, salamgera. ");
INSERT INTO kby_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ruhu Alaye Barnabas-a Shawulu-aa cunodǝnadǝro, bǝla Salukiyayero lejane nadǝn maararo ngasaye cuku Kuwirussero leyera. ");
INSERT INTO kby_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bǝrni Salamissero kadiranniya, dandalla yaudiyayen mana Alaye jamaro wulduwu badiyera. Yahaya ye rokkonjan tayiro banajiyi. ");
INSERT INTO kby_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Cukudǝ sammaa rejane kojane har bǝla Bafossero kadiranniya, kam laa sagawuma nawi kattuwuye yaudi tiro Bar-Isa cania nayeyera. ");
INSERT INTO kby_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tidǝ gomnadǝ-a rokko. Gomnadǝ hangalla cunju Sarjiyus Bulus. Mana Alaye fandu cǝraana nangaro, Barnabas-a Shawulu-aa bowoyeno. ");
INSERT INTO kby_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma Bar-Isa tiro Alimas ye cani maananju sagawumadǝ tayia wayeno, gomnadǝa kambǝrsedǝlan suwordu maji nangaro. ");
INSERT INTO kby_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Daji Ruhu Alaye Shawulu tiro Bulus ye canidǝa cakke tia simnin cappo cure ");
INSERT INTO kby_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","tiro: «Ni tada Yiwulisse, jire wadama, nanga so, jamba so sammalan tǝmbǝɍǝmmadǝ, jawal jireye Kǝmandeyedǝa kattuwuyero kalaktu kollǝmbawo wa? ");
INSERT INTO kby_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Akko kǝrma mukko Kǝmandeye kǝlanǝmnin, kamburo wallǝme kawu ganaro kǝngal rumbawo!» yeno. Sadǝman bandǝgǝne so, duwu so tiro jǝpcagane fofomje jeduma mayeno. ");
INSERT INTO kby_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gomnadǝ awo wakkajǝna adǝa kirunniya, Isaa kasatkeno, alamdu kǝla Kǝmayedǝa ajapcǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Daji Bulus-a am tia casadduwuna-a bǝla Bafossen maararo ngasaye bǝla Fǝrga lardu Bamfiliyayero leyera. Nadǝn Yahaya tayia kolje Jerujalembo wallada. ");
INSERT INTO kby_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tayidǝ Fǝrgayen kojane bǝrni Antakiya cidi Bisidiyayero kadira. Yim tustuyea dandallo ngasaye napkera. ");
INSERT INTO kby_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Curo Attaura Nawi Musaye-a kitawuwa nawiyaye-ayen kǝrayeranniya, wurawa dandalledǝ tayiro: «Kǝramiya, mana galgaldaye laa jamaro njǝddoye tawwaa, wullowo!» yera. ");
INSERT INTO kby_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Daji Bulus cije mukkonju sapce tayiro: «Jama Israyilaye-a nayi Ala ridawu-a, fannowo! ");
INSERT INTO kby_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ala Kǝma jama Israyilaye kaariyandea kǝreje sa Masarnin naptu nansikudoye cadidǝn tayia isangǝwujiye dunoaro cǝde mukko kǝnduwoalan tayia lardudǝn kittuluwo. ");
INSERT INTO kby_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kǝla halnjayen kǝrwu fidewu gairo karaa dǝɍilan kanadi kida. ");
INSERT INTO kby_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jama gadegade tulur lardu Kan'anayen siyeyenniya, cidinjadǝa warasaro tayiro kaino. ");
INSERT INTO kby_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Awo ani samma kǝrwu yer dewun fiwun gainin wakkayeno. «Ngawo adǝyen tayiro alkaliya kaino, har jaman Nawi Samailayero. ");
INSERT INTO kby_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Daji mai keworǝnniya, Ala tayiro Shawulu tada Kisse jiɍi Biliyaminuyedǝa ce kǝrwu fidewuro tayia kinodo. ");
INSERT INTO kby_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Daji tia sǝlyenniya, Nawi Daudaa mairo galaje kǝlanjun shedaje: “Dauda tada Yisaiyea fandǝkkǝna, tima kam karwuni cǝraanadǝ wo, awo raakkǝna sammaa cǝdi,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wadu ngojǝnadǝ gai, Ala kaduwu kam adǝyen jama Israyilayero Njǝkkayima kisango. Tima Isa wo. ");
INSERT INTO kby_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kawu isidǝro, Nawi Yahaya jama Israyilaye sammaro kawuɍi kasala tuwaye mawoyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kidanju njero cǝdi duwon, tiye: “Wunduro wua ngosew? Wu gǝni ti wo! Nonowo, ti duwon je sunonjuye wuiduma tikkǝnidǝ ngawonin isi,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Kǝramiyani, nayi kaduwu Nawi Ibrahimbe-a nayi Ala ridawu-a, fannowo! Andimaro Ala kawuɍi njǝkkawo fandoye adǝa isanoseyera. ");
INSERT INTO kby_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Am Jerujalemnin dasaana-a amwurawanja-a Isaa Njǝkkayimadǝro asujanni, mana nawiyaye yim tustuye fin yaye dandalnin kǝrajaidǝ yea asujanni. Adǝ nangaro tiro shara karmoye cadde ngainin casakke awowa nawiya ani wuljanadǝ wakkayera. ");
INSERT INTO kby_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ayau roro njejoye tilan cawandǝnni yaye, Gomna Bilatussa lowojane tia cejo yera. ");
INSERT INTO kby_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Daji awo kǝlanjun ruwuwada sammaa cade keserǝnniya, tia kǝskadǝn casaye curo kauriyen gǝnayera. ");
INSERT INTO kby_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma Ala tia karmolan cǝsange ");
INSERT INTO kby_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kawu kadaro Isa am cidi Galileyelan Jerujalembo tia casadduwunadǝro fǝleyaada. Tayi ye kǝrma jamaro shedawu. ");
INSERT INTO kby_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Andi ye nayiro kawuɍi kǝji wadu duwon Ala kaariyandero ngojǝgǝnadǝye wulnjagaiye. ");
INSERT INTO kby_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kǝrma Ala andi kaduwunjadǝro Isaa karmolan sangoyen wadu adǝa saddǝna. Kitawu Jawuraye sura yindiyen ruwuwadadǝ gai: “Ni Tadani, ku Bawanǝmbo wallǝkkǝna!” ");
INSERT INTO kby_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Tia karmolan cǝsange tǝmmaro walde njǝpciwawodǝ, Alaye ngai cǝnna: “Barga duwon Daudaro waduro ngogǝkke tabbatkǝkkǝnadǝa nayiro dǝmnjagakki.” ");
INSERT INTO kby_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Koro Jawuralan sura gaden tiye: “Ti Tayirnǝmdǝa yakkǝme njǝpciwawo,” cǝnna. ");
INSERT INTO kby_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","To, ti Nawi Daudadǝ jamannjun kida Ala tiro kadarjǝgǝnadǝa cǝde tumoyeyenniya, ro cǝrǝmbe gǝre kaarinjusoyen sittǝrajane kaminnju njǝpkeno. ");
INSERT INTO kby_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amma ti Ala cǝsangǝnadǝ tǝmmaro njǝpcǝnni. ");
INSERT INTO kby_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Kǝramiyani, adǝa ngǝlaro nonowo! Kam adǝyen kawuɍi gawara biwuwandoye nayiro njaddiyena. ");
INSERT INTO kby_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tilaman diye kam tia kasaccǝnamadǝ gawara biwuye duwon wada Attaura Nawi Musaye gawilan ranguwe fanduwwawodǝa cuwande jiremaro walji. ");
INSERT INTO kby_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Adǝ nangaro hangal gǝnanowo! Bare kolluwe awo kitawuwa nawiyayen ruwuwadadǝ nayiro wakkanjaganni: ");
INSERT INTO kby_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Nayi rudu gǝnaduwumasodǝ, ruiwo! Ajammowo, nuiwo! Dalilnjudǝ kǝndo laa jamanndon dikki, kǝndo duwon kam laa wulnjaanaman, yasarawwawo!”» ");
INSERT INTO kby_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bulus-a Barnabas-a dandalnin luwo cadi duwon, amdǝ yim tustuye fuwuyen awo ania tayiro wuljaaro lowoyera. ");
INSERT INTO kby_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jamadǝ sapkadaranniya, yaudiya-a adinwu yaudiyaro waljana-a kada Bulus-a Barnabas-aa geya. Tayi ye tayiro gala cadde curo ser Alayen dasaa yera. ");
INSERT INTO kby_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Yim tustuye dirije kadinniya, bǝrniwudǝye ngǝwunja kawuɍi Kǝmandeyea fanduro capkadara. ");
INSERT INTO kby_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yaudiyadǝ jama kada kadamidǝa kerunniya, nandǝɍi tayia cǝdane awo Bulus wuljidǝa kambiwujane tia rarayera. ");
INSERT INTO kby_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Amma Bulus-a Barnabas-a ridu bawoaro tayiro: «Burwon nayiro mana Alaye njǝddodǝ wajipco, amma tia wanuwe martawa ro sawisoye fandoye yittuwwiro nayi kǝlandoa ngonuwwadǝro, akko kanji kǝrdiyayero suwordiye! ");
INSERT INTO kby_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Akko wada Kǝmande sadǝnadǝ: “Nia kǝrdiyaro nur njukkudomaro njǝdǝkkǝna, dajiram duniayero njǝkkawo yadǝmiro.”» ");
INSERT INTO kby_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kǝrdiyadǝ adǝa fangeranniya, kǝjinju fanjane mana Kǝmandeyero daraja njo badiyera. Am duwon Ala tayia ro sawisoye kadarjǝgǝna samma kasatkera. ");
INSERT INTO kby_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mana Kǝmandeye cididǝ ngaro tatargaada. ");
INSERT INTO kby_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma yaudiyadǝ hangal kamuwa darajaa Ala ridawu-a fuwuwu bǝrnidǝye-aye casange Bulus-a Barnabas-aa basarjane tayia cidinjan duyera. ");
INSERT INTO kby_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Daji Bulus-a Barnabas-a tayiro katti sinjaye kagakcane bǝrni Ikoniyayero leyera. ");
INSERT INTO kby_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Fuwurawadǝ karwunja jauro kǝji ye, Ruhu Alaye tayilan kǝrga ye. ");
INSERT INTO kby_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bǝrni Ikoniyaye yen Bulus-a Barnabas-a dandal yaudiyayero ngasaye mana cade har yaudiya-a am Gǝresse-a kada kadami Isaa kasatkera. ");
INSERT INTO kby_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma yaudiya kasattu wajanadǝ hangal kǝrdiyayea casange casakke kǝramiyadǝa ngukkera. ");
INSERT INTO kby_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ngai duwon, kawu ngǝwuro napcane ridu bawoaro kǝnduwo Kǝmandeyen kawuɍi kedo. Kǝmande ye alama so, awo ajabba so dio tayiro amarjiye mananju ser fandoyedǝa jirero tabbacciyi kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Amma bǝrniwudǝ yaktane laa yaudiyadǝa geya, laa ye kǝngayambadǝa geya. ");
INSERT INTO kby_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Daji kǝrdiya so, yaudiya so fuwuwunja-a rokko sawardane tayia basarjane dongur kauyen ceyesi yera. ");
INSERT INTO kby_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kǝngayambadǝ adǝa fangeranniya, cagase bǝrniya cidi Likoniyaye Listǝra-a Darbe-a bǝlamaskiyanja-aro leyera. ");
INSERT INTO kby_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na ani yen kawuɍi kǝjidǝa ambo wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Bǝrni Listǝrayelan kam laa si canaa mbeji. Tǝn tambǝnayen ti ngurdiyi, koro ngaltema sinjun lejǝnni. ");
INSERT INTO kby_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kamdǝ mana Bulussea kǝrǝnji duwon, Bulus tia simnin cappo cure kambǝrsenju ngaduyea kirunniya, ");
INSERT INTO kby_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kowo sapce tiro: «Cine, sinǝmlan cǝkko dane!» yeno. Sadǝman kamdǝ wup cije dadadu badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jamadǝ awo Bulus cǝdǝnadǝa kerunniya, tǝlamnja Likoniyayen kowo sapcane: «Akko alawa laa camuno kamben samelan jǝmsaana!» cane ");
INSERT INTO kby_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabassa Jewuslan bowojane Bulus yea Hermeslan bowoyera, tima mana diomadǝ wo nangaro. ");
INSERT INTO kby_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Daji ɍiman Jewusse ti duwon fado sǝnǝmnjuye fuwu bǝlayen dǝganadǝ dalowa-a fǝɍeya-a ngaworam bǝrnidǝyero kiwudo, ti-a jamadǝ-a rokko bu fida dio caraana nangaro. ");
INSERT INTO kby_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma kǝngayamba Barnabas-a Bulus-adǝ adǝa fangeranniya, kalwunja karjane dǝgaljane dawu jamadǝyero ngasaye kowo dunoaro sapcane ");
INSERT INTO kby_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","tayiro: «Jama, awiro awo ania diwi? Andi ye am nayi gai, diye! Koro nayiro kawuɍi kǝji wulduwuro kadiye. Awo bowu ania kollowo, Ala Kǝndǝgaima ti same-a cidi-a teku-a awo curonjan dasaana samma-aa alakcǝnadǝro tǝmdǝgǝnowo! ");
INSERT INTO kby_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jaman kureyen jama sammaa kolje jawalnja caraanaa ngoyera. ");
INSERT INTO kby_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Adǝson sawiso awo ngǝla cǝdidǝ shedanjuro waljǝna. Ngaima samelan ingi cudduri, koro nemadǝa sanjulan fanduwi. Kǝmbo njade karwundo kǝjiji,» yera. ");
INSERT INTO kby_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mana ania caddima, kiaddin jama capkadadǝro bu fida adǝa tayi nangaro dio dapkeyera. ");
INSERT INTO kby_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Daji yaudiya laa bǝrni Antakiyaye-a Ikoniyaye-alan isane jamadǝa kaanjaro kedǝnniya, Bulusso dongur kauye gǝgǝpcagane nuna cane gǝrjane ngawo bǝlayen kolyera. ");
INSERT INTO kby_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amma fuwurawadǝ isane tia dirijane kǝlyeranniya, cije walde bǝrnidǝro kǝrgawo. Wajǝnanjua Barnabas-a rokko bǝrni Darbeyero leyera. ");
INSERT INTO kby_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bulus-a Barnabas-a kawuɍi kǝjidǝa bǝrni Darbeyelan wuljane am kada Isaa gawuro walyeranniya, bǝrni Listǝraye-a Ikoniyaye-a Antakiyaye-aro walladara. ");
INSERT INTO kby_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Karwu fuwurawadǝyero duno casakke kambǝrsenjan fuwu jaworo kowoɍi cade tayiro: «Sai jauro bone yaiyeya duwon, nodo bargaa Alayero ngayiye,» yera. ");
INSERT INTO kby_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Curo jama Isaa gawu fiye yayen amwurawa galayeranniya, moduwa-a asem-a cade tayia mukko Kǝma mǝrsajanadǝyero kesakko. ");
INSERT INTO kby_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Daji cidi Bisidiyayea rejane kojane lardu Bamfiliyayero leyera. ");
INSERT INTO kby_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bǝla Fǝrgayelan kawuɍidǝa wulyeranniya, bǝla Attaliyayero koyera. ");
INSERT INTO kby_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nadǝn maararo ngasaye bǝrni Antakiya cidi Siriyero kadira. Caman bǝrnidǝn Isaa gawudǝ tayiro kida kǝrma tumojaanadǝro ser Alaye cakkorǝna. ");
INSERT INTO kby_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kadiranniya, jama Isaa gawudǝa capcane awo Ala tayi yindiyen cǝdǝna samma-a jiɍi kǝrdiyaro cinna kambǝrse fandoye kajǝgǝna-aa tayiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bulus-a Barnabas-a kawu kadaro dawu fuwurawadǝyen napkera. ");
INSERT INTO kby_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Am laa cidi Yahudiyayen bǝrni Antakiyayero isane kǝramiyadǝa alamdu badiyera. Tayiro: «Ada Nawi Musaye gawe nayia kajanjannia, ranguwe njǝkkawo fanduwwawo,» yera. ");
INSERT INTO kby_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bulus-a Barnabas-a mananjadǝa kasatturo wajane kambiwu jau fit kedǝnniya, jama sawardane Bulus-a Barnabas-a amnja gade laa-a Jerujalembo na kǝngayamba-a amwurawa-ayero leja kǝla mana adǝyen gasipca yera. ");
INSERT INTO kby_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jama Isaa gawudǝ tayia kenodǝnniya, lardu Fenisiye-a Samariyaye-a rejane kojai duwon, kǝramiyadǝro lawar Alaro waldu kǝrdiyayedǝa wuljagane tayi samma jauro kǝji fangera. ");
INSERT INTO kby_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerujalembo kadiranniya, jama Isaa gawu-a kǝngayamba-a amwurawa-adǝ tayia mukko yindin kemowo. Daji awo Ala tayiyen cǝdǝna sammaa wulyera. ");
INSERT INTO kby_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amma Isaa gawu kǝwu Farisawaye laa cijane tayiro: «Sai tayia kajajane Attaura Nawi Musayea jaaro tayiro wada cadiya duwon,» yera. ");
INSERT INTO kby_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Daji kǝngayambadǝ-a amwurawadǝ-a kǝla lamar adǝyen sawariro capkadara. ");
INSERT INTO kby_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ngǝwuro gasipkeranniya, Biturus cije tayiro: «Kǝramiya, tussǝna Ala wua curondon kǝresǝna kǝrdiyaso cinilan kawuɍi kǝji fanja kasaccaro nayi nonuwwa. ");
INSERT INTO kby_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Koro Ala ti karwu nodumadǝ Ruhunju andiro sadǝnadǝ gai, tayi yero ce tayia ardijǝnadǝa shedayeno. ");
INSERT INTO kby_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Andi-a tayi-a gayirsanni, kambǝrsenja nangaro karwunjaa tulje tayirro walyera. ");
INSERT INTO kby_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","To, awiro Alaa rijammuwe kurwowu duwon bi kaariyandema bi andima rangiye ngoniyendedǝa fuwurawa aniro gǝnagǝwidǝ? ");
INSERT INTO kby_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A'a! Tayi ser Kǝma Isayen njǝkkawo cawandǝnadǝ gai, andi ye ngaiman fandiyenaro kasaddiyena.» ");
INSERT INTO kby_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jama captanadǝ samma gǝm cadǝna kǝrǝnjai duwon, Barnabas-a Bulus-a alama so, awo ajabba so Ala tayiyen dawu kǝrdiyayen cǝdǝna sammaa tayiro wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mananja cade keseranniya, Yakubaye tayiro: «Kǝramiya, manani fannowo! ");
INSERT INTO kby_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siman jiɍi Ala burwoman kǝrdiyaa njunoje curonjan am jamanjuro waljaro kǝrejǝnadǝa wulsaana. ");
INSERT INTO kby_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Koro mana nawiyaye ye adǝa tabbaccaana, akko awo kitawulan ruwuwadadǝ: ");
INSERT INTO kby_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Alaye: ‘Ngawo adǝyen isǝkke leima Daudaye curǝnadǝa waldǝkke tandǝkki. Awo wurdǝnadǝa bǝɍinno sǝgapkǝkke tandǝkki. ");
INSERT INTO kby_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Adǝgaima adamgǝna gapcanadǝ, har kǝrdiya samma duwon tayia cunilan bowojaidǝ, wu Kǝmanjaa masai,’ yeno Kǝmande awo ania cǝde ");
INSERT INTO kby_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","tǝn kuren ambo isanojǝgǝnadǝ.” ");
INSERT INTO kby_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Adǝma nangaro, kǝramiyani, wuyenna, bare am jama kǝrdiyaye Alaa gawuro waldu cadidǝa suwolliyende, ");
INSERT INTO kby_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","amma sai da sǝnǝmbo tina ngǝro so, kǝnjǝna dio so, lǝman duwadǝnni ngǝro so, bu nja soa wajaro tayiro ruwuniyo. ");
INSERT INTO kby_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Awoa tǝn jaman kureyen yim tustuye nguson bǝrni fin yaye dandalnin Attaura Nawi Musayedǝa jamaro kǝrajagane alamjai.» ");
INSERT INTO kby_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Daji kǝngayamba-a amwurawa-a jama Isaa gawu samma-a am curonjan kǝrenǝme Bulus-a Barnabas-aro kǝlgǝme bǝrni Antakiyayero juwaduwuro ngǝlaro kero. Am jamadǝlan darajaa Yahusa tiro Barsabas cani-a Silas-aa kǝrejane ");
INSERT INTO kby_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","wotiya ngai ruwuwada mukkonjaro kesakko: «Andi kǝramiya kǝngayamba-a amwurawa-a nayi kǝramiyande fǝrdundo kǝrdi bǝrni Antakiyaye-a cidi Siriye-a Kilikiyaye-aro, salam! ");
INSERT INTO kby_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Am laa amari yiyende duwon curonden caluwe alamdunjan nayia suwolnjane hangalndo casangǝnadǝa fanniyena nangaro, ");
INSERT INTO kby_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","andi samma ci tiloaro am laaa kǝrenǝme sawawande Barnabas-a Bulus-a jauro rayiyenadǝro kǝlgǝme nandoro juwaduwuro ngǝlaro kiruiye, ");
INSERT INTO kby_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","tayi duwon cu Kǝmande Isa Almasiwuye nangaro ronja caladǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Adǝ nangaro Yahusa-a Silas-aa kinodiye, tayi ye awo ruwuniyenadǝa cinjalan wulnjagai. ");
INSERT INTO kby_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ruhu Alaye-a andi-a kurwowu gade nayiro gǝnanjagaiyewaworo ngǝlaro ruiyena, sai awo nayiro wajip ani, tayima ");
INSERT INTO kby_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","da sǝnǝmbo tina ngǝro so, bu nja so, lǝman duwadǝnni ngǝro so, kǝnjǝna dio so wanowo! Awo aniro kanuwia, ngǝla diwwa. Kǝlewan dǝgaiwo!» ");
INSERT INTO kby_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Daji jama tayia salamgeranniya, bǝrni Antakiyayero lejane jama Isaa gawudǝa capcane tayiro wotiyadǝa kedo. ");
INSERT INTO kby_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kǝrayeranniya, kowoɍi njodǝro kǝji fangera. ");
INSERT INTO kby_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahusa-a Silas-a tayi kǝlanjama nawiyadǝ kǝramiyadǝro kowoɍi cade mana kadan karwunjaro duno kesakko. ");
INSERT INTO kby_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kawu ganaro bǝrnidǝn napkeranniya, kǝramiyadǝ na jama tayia juwajaanayedǝro waldaro tayia alakǝlewayera. ");
INSERT INTO kby_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amma Silas nadǝn napci yeno, Yahusa runju Jerujalembo walladan. ");
INSERT INTO kby_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bulus-a Barnabas-a bǝrni Antakiyayelan napcane am gade ngǝwu-a rokko kawuɍi kǝji kǝla mana Kǝmandeyen alamjane wuljai kasarga. ");
INSERT INTO kby_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ngawo kawu ganayen Bulusse Barnabasso: «Waldiyo, kǝramiya bǝlawa na mana Kǝmandeye wulliyena sammayedǝa dalliyo, naptunja ruiyo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabasdǝ Yahaya tiro Markus canidǝ yea ngojane rokko lejaiya, cǝraana, ");
INSERT INTO kby_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","amma Bulusse kam tayi-a rokko kidaro lejai duwon cidi Bamfiliyayen tayia koljǝnadǝa bare ngojanni yeno. ");
INSERT INTO kby_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kambiwu jau fit cade, har firgadara. Barnabas Markussa ngoje maararo ngasaye cuku Kuwirussero leyera. ");
INSERT INTO kby_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulus ye Silassa kǝreje kǝramiyadǝ Kǝmandeyen tayiro ser cakkorǝne alakǝlewajane leyera. ");
INSERT INTO kby_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Daji Bulus larduwa Siriye-a Kilikiyaye-aa jǝgane jama Isaa gawudǝye karwunjaro duno cakki kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus bǝrni Darbeye-a Listǝraye-aro leyeno. Nadǝn fuwura laa cunju Timoti mbeji. Ti tada kamu laa yaudi Isaa gamaye, amma bawanjudǝ kam lardu Gǝresse. ");
INSERT INTO kby_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kǝramiya bǝrni Listǝraye-a Ikoniyaye-alan dasaanadǝ Timotiye ngǝlanju wuljai. ");
INSERT INTO kby_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ti-a kallo lejaro cǝraye yaudiya na anin dasaana samma bawanju kam Gǝressero nojana nangaro tia kajayeno. ");
INSERT INTO kby_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bǝrni bǝrniro lejai duwon, sawari kǝngayamba-a amwurawa-a Jerujalemnin dasaanaye kamjanadǝa tayiro cadǝne jaa yera. ");
INSERT INTO kby_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Adǝgaima jama Isaa gawu kambǝrsenjan duno cawande yim nguson nanngǝwunja tǝrgai kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ruhu Alaye Bulus-a Silas-aro cidi Asiyayelan mana Kǝmaye wuldu dapcǝgǝnadǝ, larduwa Firijiyaye-a Galatiyaye-ayen rejane koyera. ");
INSERT INTO kby_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Karǝn cidi Misiyayero kadiranniya, cidi Bitiniyayero ledu mayera, amma Ruhu Isaye tayiro amarjǝgǝnni. ");
INSERT INTO kby_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Daji cidi Misiyayen kojane bǝrni Taruwassero leyera. ");
INSERT INTO kby_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Curo buneyen Bulusso wahayi fǝlediye, kam laa lardu Makidoniyaye daada tiro: «Are Makidoniyaro, andiro banasagane!» cǝne tia lowoji kiro. ");
INSERT INTO kby_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wahayidǝa kirunniyama, Makidoniyaro ledu mayeiye, Ala tayiro kawuɍi kǝjidǝa wulduwuro bowosanaro noniyena nangaro. ");
INSERT INTO kby_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Daji bǝrni Taruwassen maararo ngayiye cuku Samotǝraki caniyero cǝkko leyeiye. Wajǝnanjua bǝrni Niyabolissero kadiyendeya, ");
INSERT INTO kby_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","nadǝn bǝrni Romanwuye duwon bǝrni kura lardu Makidoniyaye Filibi canidǝro isiye kawu ganaro napkeiye. ");
INSERT INTO kby_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Yim tustuyea ngaworam bǝrnidǝyen luwiye ci bǝrǝmbe na moduwa cadi tǝmaniyenadǝro leyeiye. Napkeiyendeya, kamuwa captanadǝro manaduwu badiyeiye. ");
INSERT INTO kby_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kamu Ala ridama laa batta kime ladoma bǝrni Tiyatiraye tiro Lidiya cani manadǝa kǝrǝnji, Ala awo Bulus wuljidǝa kasatturo karwunjuro kekko. ");
INSERT INTO kby_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ti-a am fannjuye-aro kasala kiddiyendeya, andia lowosane: «Wu Kǝmaa mǝrsadumaro ngosuwwaa, arowo fannin jǝmmowo!» cǝne andia sasakke leyeiye. ");
INSERT INTO kby_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yim laa na moduwa dioyedǝro ledu diye duwon, kir laa karuwama ise andia kamseyera. Sedandǝ tia cakke kuro cǝde ngainin kǝmawanjuro wuɍi kada cukkudi. ");
INSERT INTO kby_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Daji Bulus-a andi-aa ga ngǝsse kowo sapce: «Am ani kadunowu Ala Kǝma Samemaye, nayiro jawal njǝkkawo fandoyedǝa wulnjagai,» cǝni. ");
INSERT INTO kby_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kawu kadaro ngai cǝdidǝ, kǝla Bulussen njǝn culuwe suworde sedandǝro: «Cu Isa Almasiwuyen niro wulnjǝgǝkki, tia kolle luwe!» yeno. Sadǝman tia kolyeno. ");
INSERT INTO kby_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Amma kǝmawanjudǝ tǝmanja wuɍi fandoye baworo waljǝnaro asuyeranniya, Bulus-a Silas-aa cadane gǝrjane farsambo na fuwuwuyero kesado. ");
INSERT INTO kby_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Daji fuwu alkaliyayero kewudǝnniya, tayiro: «Am ani yaudiya, bǝrnindero fitǝna cawudi, ");
INSERT INTO kby_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ada duwon kasattunju bi ganju wowom andi Romanwuro damsaanaa cakkarai.» ");
INSERT INTO kby_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jamadǝ ye Bulus-a Silas-aro capkaadara. Daji alkaliyadǝ kajǝmu Bulus-a Silas-ayea dunon ɍinjane wada cade kalan bakkera. ");
INSERT INTO kby_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ngǝwuro tayia bakkeranniya, kosoro casakke guredumadǝro wada cade fǝrǝstaiwaworo rojo yera. ");
INSERT INTO kby_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wada adǝa kiwandǝnniya, tayia curo kosoramben sulluru daryeyedǝro cakke sinjaa dǝmbǝllo tuyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bune dǝrdu Bulus-a Silas-a moduwa cadi Alaro aiya njungoroye yejagai, kosowu gade ye tayia kǝrǝnjai ngai duwon, ");
INSERT INTO kby_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","cidi dama baworo loloje fǝrdu kosoramdǝye moji badiyeno. Sadǝman cinnaso samma fǝrǝmdane saɍga kosowu sammaye wuiyadara. ");
INSERT INTO kby_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Guredumadǝ kǝnǝmnin cije cinna samma kaada kirunniya, kosowu nga cagasǝna cǝne kǝlanju njejoro kashagar fitkeno. ");
INSERT INTO kby_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amma Bulus kowo sapce: «Bare kǝlanǝm lorunǝmmi! Andi samma menna,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Guredumadǝ fatǝla cuwore gangadaro ngaye lolojiaro fuwu Bulus-a Silas-ayen tungurumje nguyeno. ");
INSERT INTO kby_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tayia deyaro cuttuluwe: «Malǝmba, awi dikke njǝkkawo fandǝkki?» cǝne kiworǝnniya, ");
INSERT INTO kby_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","tiro: «Kǝma Isaa mǝrsane, ni-a am fannǝmbe samma-a njǝkkawo fanduwi,» yera. ");
INSERT INTO kby_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Daji ti-a am fannjuye samma-aro kawuɍi Kǝmayea wulyeyera. ");
INSERT INTO kby_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bune sa adǝman tayia cade tunonjaso tulyeno. Tulyenniyama, Bulus-a Silas-adǝ ti-a am fannjuye samma-aro kasala keddo. ");
INSERT INTO kby_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tayia fannjuro kiwudǝnniya, masǝna tayiro kaino, koro Alaa mǝrsajǝna nangaro ti-a am fannjuye-aye karwunja jauro kǝjiyeno. ");
INSERT INTO kby_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Dunia wayenniya, alkaliyadǝ sojiya canode: «Am ania kolle leja!» yera. ");
INSERT INTO kby_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Daji guredumadǝ mana ania Bulusso wuljiye tiro: «Alkaliyaye nayia kolnjakko canna. Adǝ nangaro luwowo, kǝlewan lenowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma Bulusse tayiro: «A! Andi Romanwu duwon, shara saddǝnnin fuwu jamayen bansane kosoro sesakko! Kǝrma asǝrlan andia koldu majai wa? Suwana! Tayi kǝlanjama isa kolsa!» yenniya, ");
INSERT INTO kby_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","sojiyadǝ waldane alkaliyadǝro mana Bulussedǝa wulyeyera. Alkaliyadǝ ye Bulus-a Silas-aa Romanwuro fangeranniya, rijane ");
INSERT INTO kby_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","isane nanjan gawara cawore kosolan cattuluwe tayia lowojane bǝrnidǝn caluwo yera. ");
INSERT INTO kby_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bulus-a Silas-a kosolan keluwunniya, fado Lidiyayero leyera. Nadǝn kǝramiya-a tade tayiro kowoɍi cade sapkadara. ");
INSERT INTO kby_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bulus-a Silas-a bǝrni Amfibolis-a Aboloniya-ayen rejane koyeranniya, Tasalonika bǝrni duwon curonjun dandal yaudiyaye laa dǝganadǝro kadira. ");
INSERT INTO kby_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kǝla adanjuyen Bulus nanjaro ngaye yim tustuye gadegade yakkuro awo kitawulan ruwuwadadǝa tayiro fisarjiye ");
INSERT INTO kby_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ala kadarjǝna Almasiwudǝ bone cane nune karmolan ciji adǝa bayinje tabbacciye tayiro: «Isa kam kǝlanjun mana njaddǝkkidǝ, tima Almasiwudǝ wo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yaudiyadǝye laanja-a am Gǝresse Ala ridawu kada-a kamuwa darajaa gǝnagǝni-a mananjudǝa kasaccane Bulus-a Silas-aro kǝllaadara. ");
INSERT INTO kby_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amma yaudiya laa kanduɍijane kǝladowa am bowuye farsamnin majane tǝmbaljagane hangalsango bǝrnidǝn casange Bulus-a Silas-aa fuwu jamayero kudoro fado Jasonnero cagase leyera. ");
INSERT INTO kby_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tayia najagannidǝ, Jason-a kǝramiya gade laa-aa fuwu fuwuwu bǝrnidǝyero gǝrjane kowo sapcane: «Am dunia ngan hangalsango cadidǝ na adǝ yero isane, ");
INSERT INTO kby_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason ye tayia fannjun cǝsaana. Tayi samma wowom Kaisarre ga wajane mai gade Isa cani menna wuljai,» yera. ");
INSERT INTO kby_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jama-a fuwuwudǝ-a adǝa fangeranniya, hangalnja ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasonsoyen beli kemowonniya, koljane leyera. ");
INSERT INTO kby_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Dunia lǝmgenniyama, kǝramiyadǝ Bulus-a Silas-aa casakke bǝrni Biriyayero leyera. Kadiranniya, dandal yaudiyayero kasargawo. ");
INSERT INTO kby_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yaudiya ani am bǝrni Tasalonikayedǝro kǝla fǝrǝmgadaa wo. Kawuɍidǝa mukko yindin camoye, har awo ani jire waro noduro yim nguson kitawudǝa fǝsanjane carui. ");
INSERT INTO kby_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Adǝ nangaro amnja ngǝwu Isaa kasatkera, koro curo am Gǝressedǝn kamuwa darajaa-a kongwawa-a gǝnagǝni ye kasatkera. ");
INSERT INTO kby_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amma yaudiya Tasalonikayedǝ Bulus Biriya yelan mana Alaye wuljidǝa fangeranniya, na adǝ yero isane jamaa tǝmbaljagane fitǝna kewudo. ");
INSERT INTO kby_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Sadǝman kǝramiyadǝ Bulusso ci tekuyedǝro lejo cane sapkadan, amma Silas-a Timoti-a nadǝn napkera. ");
INSERT INTO kby_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Am Bulussa casadduwunadǝ tia har bǝrni Atinayero kesado. Daji Bulus tayiro wada ce Silas-a Timoti-a nanjuro duwaduwan isa yenniya, sapkadara. ");
INSERT INTO kby_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bulus bǝrni Atinayen Silas-a Timoti-aa guredu cǝdi duwon, bǝladǝn ndaran yaye gumkiyaaro curunadǝ, karwunju kuttayeno. ");
INSERT INTO kby_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Adǝ nangaro Bulus curo dandalle yen yaudiya-a Ala ridawu-a manadai, farsam yen yim nguson am tadidǝ-a ngai cadi. ");
INSERT INTO kby_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Koro ilmuwu laa kǝwu Abikuriyaye-a Sitokiyaye-a ye ti-a jandedu badiyera. Laanjaye: «Kam kalala ngǝwua adǝ, awi gǝle wulji?» cani, laa ye: «Alamanju sǝnǝmba lardu gadeye mawoduma,» cani. Adǝa wuldunjadǝ, Bulus kawuɍi kǝji kǝla Isa-a karmolan cidu-ayen wulji nangaro. ");
INSERT INTO kby_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Daji tia ngojane fuwu majilis na duwon tiro Kǝri Arasaye caniyedǝro caade tiro: «Nda awo bǝɍin alammǝmidǝa andiro wulsagane, ngǝlaro fanniyo! ");
INSERT INTO kby_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ilmu yikkǝrami kaande-a gade adǝye maananju noduro maniye,» yera. ");
INSERT INTO kby_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Awoa am bǝrni Atinaye samma-a kusottowa bǝrnidǝn dasaana-adǝ ilmu bǝɍin wuldu-a fandu-a gǝnia, awima gade cadiwawo. ");
INSERT INTO kby_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Daji Bulus cije dawu majilisdǝyen daje tayiro: «Am bǝrni Atinaye, nayi jiɍi fin yaye jauro adinwuro rukkǝna. ");
INSERT INTO kby_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bǝrnindon dadanǝkke gumkiyando rukki duwon, curonjan har laya duwaduram laa kǝlanjun adǝ kurgadaa kirukko: “Ala laa nodǝnniye.” Awo nonuwwilan ambǝtkǝwi adǝ, timaa isanonjagakki. ");
INSERT INTO kby_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ala duwon dunia-a awowa curonjun dasaana samma-aa alakcǝnadǝ, ti Kǝma same-a cidi-aye nangaro, curo fadowa kam cǝdandǝnayen gǝni kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Koro mǝradunju bawo nangaro, mukko adamgǝnayen gǝni kistiyi, tima wundu yayero ro-a sindu-a awo gade samma-aa njoma wo. ");
INSERT INTO kby_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kam falnin jama gadegade sammaa alakkeno, duniaye ndaranjun yaye dasaaro. Jama sammaro jaman kǝndǝgainjaye kamjiye koro cidinjaro kaɍangi kiddo. ");
INSERT INTO kby_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Adǝa dionjudǝ, farafaraja tia maja, yoyenoa, cawandoro. Jiremaro katte ti-a wundundeye-a kuruwu gǝni. ");
INSERT INTO kby_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Manawundo laasomaye cannadǝ gai: “Tiyen ro kiwandiye, dadaniye, kǝrgaiye,” koro: “Andi ye kaduwunju.” ");
INSERT INTO kby_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«To, andi kaduwunjudǝ, bare tia gumki dinarre so, ɍiwullaye so, kauye so awo duwon amso ilmunja-a nangoninja-anin cadandǝnadǝye camunno ngoniyende. ");
INSERT INTO kby_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Jaman nodunambuyen Ala wowom gǝnaduwu wajǝna yaye, kǝrmadǝ am samma ndaran kasarga yaye tuwa cado yeno, ");
INSERT INTO kby_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","dalilnjudǝ kam shara diomaro galajǝnayen duniaro yim falnin shara jireye cǝddi cǝne sardu kamjǝgǝna. Nianju adǝa wundu yayero tabbattuwuro kamdǝa karmolan kisango.» ");
INSERT INTO kby_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mana kǝla karmolan ciduyedǝn fangeranniya, laanja rudu gǝnayera, amma laa ye: «Gademinno kǝla adǝyen nia kǝrǝnnjiye,» yera. ");
INSERT INTO kby_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Daji Bulus nanjan sapkadan. ");
INSERT INTO kby_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amma am laa tiro kǝldagane Isaa kasatkera. Curonjan Diyonisiyas tima majilisma-a kamu laa Damaris cani-a am gade-a. ");
INSERT INTO kby_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ngawo adǝyen Bulus bǝrni Atinayedǝa kolje bǝrni Korintiyero leyeno. ");
INSERT INTO kby_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nadǝn yaudi laa cidi Fantussen tambǝna Akila cani-a kattado. Ti-a kamunju Bilkisu-a tussǝnni lardu Italiyayen isana, Kaisar Kǝlodiyus wada ce yaudiya samma bǝrni Rombea kolja cǝnna nangaro. Daji Bulus nanjaro leje, ");
INSERT INTO kby_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","tayi samma sanianja tilo leima tandodǝ, tayiro kǝldiye fannjan napce rokko kida kedo. ");
INSERT INTO kby_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yim tustuye nguson Bulus dandallan jama-a manadai, yaudiya-a am Gǝresse-a Isaa gawuro waljaro maji. ");
INSERT INTO kby_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Daji Silas-a Timoti-a lardu Makidoniyayen kadiranniya, Bulus mana Alaye sattuwuro kǝlanju ce yaudiyaro Isadǝ tima Almasiwu wo cǝne shedaji kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amma yaudiyadǝ tia wajane rarayeranniya, kajǝmunju kagakce tayiro: «Ala bundo kǝlandoro kalakcuwo, wu dawun bawo! Kua adǝn fuwun na kǝrdiyayero lekki,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Daji nadǝn sapte fado kam laa Ala ridama tiro Titus Justus caniyero leyeno. Fannjudǝ gǝre dandaldǝyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kǝrifus kura dandaldǝye-a am fannjuye samma-a Kǝmaa kasatkera. Koro Korintiwu kada ye fangeranniya, kasaccane tayiro kasala keddo. ");
INSERT INTO kby_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Bune laa wahayilan Kǝmaye Bulusso: «Bare rinǝmmi! Manane, bare gǝm dimmi! ");
INSERT INTO kby_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Wu ni-a rokko. Wunduma nia lenje basarnjiwawo, bǝla adǝn ammi ngǝwu mbeji nangaro,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Daji kǝrwu fal redaaro napce curonjan mana Alayea alamji kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Jaman Gomna Galiyo lardu Akayaye cunodidǝn, yaudiyadǝ citilo cade Bulussa cadane shararambo caade ");
INSERT INTO kby_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","tiro: «Kam adǝ jiɍi wowom amarjǝgǝnnin amba Alaro ambǝttuwuro tǝmbaljiyi,» yera. ");
INSERT INTO kby_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bulus cinju kaji duwon, Gomnaye yaudiyadǝro: «Ca ayau laa bi biwu kura laaro walyenoa, dalil nayi yaudiyadǝa kǝrǝnduye menna. ");
INSERT INTO kby_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma lamar kalma so, cu so, wadando so wujǝnadǝ, nayima awondo nonuw! Wudǝ alkali awo aniyero waldu wakkǝna,» cǝne ");
INSERT INTO kby_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","shararamdǝlan tayia duyeno. ");
INSERT INTO kby_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Daji tayi samma Sastanisu fuwuma dandalledǝa cadane fuwu shararamdǝyeman babakkera, amma Gomnaye kistuwunjuma cuwudǝnni. ");
INSERT INTO kby_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus kawu kadaro bǝrni Korintiyelan napkenniya, cije kǝramiyadǝa alakǝlewaje Ya Bilkisu-a Akila-a rokko cidi Siriyero leduro maararo kasargawo. Bǝla Kankariyayen Bulus kansi juwuna nangaro kǝlanju kilaro. ");
INSERT INTO kby_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bǝrni Afisayero kadiranniya, Bulus tayia nadǝn kolje ti kǝlanju dandallo ngaye yaudiya-a kǝla mana Alayen manaadara. ");
INSERT INTO kby_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tia kawu kadaro napcoro lowoyeranniya, waje ");
INSERT INTO kby_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","tayiro: «Alaye cǝdia, nandoro waldǝkke isǝkki,» cǝne maararo ngaye bǝrni Afisayedǝa kolyeno. ");
INSERT INTO kby_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bǝrni Kaisariyayen jǝpce Jerujalembo leje jama Isaa gawua lewayenniya, bǝrni Antakiyayero koyeno. ");
INSERT INTO kby_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antakiyanin kawu ganaro napkenniya, cije bǝla bǝlaso lardu Galatiyaye-a Firijiyaye-a jǝgane fuwurawadǝye karwunjaro duno kekko. ");
INSERT INTO kby_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Adǝgaima yaudi laa bǝrni Aleksandariyayelan tambǝna tiro Afolus cani bǝrni Afisayero kadio. Tidǝ manama kura, koro kitawuwa Alayedǝa ngǝlaro nojǝna. ");
INSERT INTO kby_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jawal Kǝmaye ga cǝɍǝna, koro jauro karwu kǝjiaro kalkallo kǝla awowa Isaa wujanayen amba alamji, amma kasala Nawi Yahayaye runjuma nojo. ");
INSERT INTO kby_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Daji ridu bawoaro dandallan mana badiyeno. Ya Bilkisu-a Akila-a tia fangeranniya, tia ngojane cayea kojǝnaro kalkallo jawal Alayea bayingeyera. ");
INSERT INTO kby_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Afolus lardu Akayayero ledu mayenniya, kǝramiyadǝ tiro kowoɍi cade fuwurawa cididǝyero wotiya ruwujagane tia ngǝlaro sosaja yera. Kadinniya, am duwon ser Alayen Isaa gawuro waljanadǝa jauro banayeyeno, ");
INSERT INTO kby_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","awoa Isama Almasiwudǝ woro kitawuyen tabbacciye fuwu jamayen yaudiyadǝa kǝnduwoaro manan yapkeyeno. ");
INSERT INTO kby_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Afolus bǝrni Korintiyelan duwon, Bulus cidi kau kaua koje bǝrni Afisayero kadinniya, fuwurawa laaa najiye ");
INSERT INTO kby_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","tayiro: «Sa Isaa kasadduwwadǝn, Ruhu Alaye jǝmnjaana wa?» cǝne kiworo. Tiro: «A'a, andi Ruhu Alaye mbejimaro fanniyende,» yera. ");
INSERT INTO kby_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulusse: «Kasala fi gǝle nayiro njaddo?» cǝne kiworǝnniya, tayiye: «Kasala Nawi Yahayaye,» yera. ");
INSERT INTO kby_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Daji Bulusse: «Nawi Yahaya ambo kasala tuwaye cǝdde tayiro kam ngawonjun isidǝa kasacca jaa cǝni. Kamdǝ tima Isa wo.» ");
INSERT INTO kby_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Adǝa fangeranniya, cu Kǝma Isayen tayiro kasala keddo. ");
INSERT INTO kby_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Daji Bulus tayiro mukko gǝnayeyenniya, Ruhu Alaye tayiro jǝpciye tǝlamba gadegaden manajane nawinawi dio badiyera. ");
INSERT INTO kby_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Am ani, tayi alama kongwa mewun yindin gai. ");
INSERT INTO kby_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus dandallo ngaye kǝndawu yakkuro ridu bawoaro kambiwuje kǝla nodo bargaa Alayen jamaa alamje kasaccaro maji. ");
INSERT INTO kby_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma laanja kǝlakibbu cade kasattu wajane fuwu jamayen Jawaldǝro rudu gǝnayeyeranniya, Bulus tayia kolje fuwurawadǝa ngoje leje yim nguson alamduram kam tiro Tiranus caniyen tayia alamji kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kǝrwu yindiro alamji ngai duwon, am cidi Asiyayen dasaana samma mana Kǝmadǝye fangera, yaudiya yen kal, yaudiya gǝni yen kal. ");
INSERT INTO kby_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ala mukko Bulussen awo jauro ajabba ajabba cǝde ");
INSERT INTO kby_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","har batta so, kajǝmu so tia lejanadǝa cawude am dondiro gǝnajagaiya, kasuwanjan ngajai, sedanso ye tayilan caluwi. ");
INSERT INTO kby_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yaudiya sedan dudawu dadajaiso laa ye cu Kǝma Isayen sedanna dudu majane tayiro: «Cu Isa kam Bulus mawojidǝyen wulnjagakki, luwowo!» cani. ");
INSERT INTO kby_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɍiman kura laa tiro Siba caniye tadawanju tulur ngai cadi duwon, ");
INSERT INTO kby_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","sedandǝye tayiro: «Isadǝa nokkǝna, Bulus yea nokkǝna, amma nayidǝ wunduso?» cǝne ");
INSERT INTO kby_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","karuwamadǝ kǝlanjaro sǝktiye dunonja koje nasarje, har de sul loruwada cagase fadodǝlan keluwo. ");
INSERT INTO kby_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Am bǝrni Afisayelan dasaana samma, yaudiya yen kal, yaudiya gǝni yen kal, lawar adǝa fangeranniya, tayi samma rijane cu Kǝma Isayero daraja kedo. ");
INSERT INTO kby_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Am Isaa kasaccanadǝye ngǝwunja isane awo diwi diwi cadǝnadǝa fuwu jamayen wulyera, ");
INSERT INTO kby_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","koro am ngǝwu sagawu cadǝnadǝ ye kitawunja cawude capcane fuwu jama sammayen kannu ketta. Tamannja isapkeranniya, cungo ɍiwullaye dǝwu fiwu. ");
INSERT INTO kby_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Adǝgaima mana Kǝmaye tatardiye kǝnduwoaro walji kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ngawo awo ani wakkajanayen, kǝnduwo Ruhu Alayen Bulus nia larduwa Makidoniya-a Akaya-ayen renǝme konǝme Jerujalembo leduye ngoje kǝlanjuro: «Ngawo na aniro lekkǝnayen, sai bǝrni Rombe yea rukkiya!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Daji banawunjuye yindi Timoti-a Erastus-aa lardu Makidoniyayero kinodo, amma ti kǝlanju kawu ganaro cidi Asiyayen napkeno. ");
INSERT INTO kby_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jaman adǝn hangalsango kura Jawaldǝ nangaro ciyeno. ");
INSERT INTO kby_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ɍiwulla karoma laa tiro Dimitǝriyus cani mbeji. Tidǝ fado sǝnǝm Ya Artimasse ɍiwullan cǝdande saniawuro riwa gǝnagǝni cukkudi. ");
INSERT INTO kby_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Daji saniawudǝ-a am kidanja kaanja-a camun-aa capce tayiro: «Jama, saniande adǝn fandinde diyero nonuwwa. ");
INSERT INTO kby_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ruwe fannuwwadǝ gai, bǝrni Afisaye runjun gǝni, na ganaro kajia, Asiya samman Bulus adǝ gumkiya mukkon tagarǝnadǝ alawa jireye gǝni cǝne am ngǝwu mananju ngojane jawallan caluwuna. ");
INSERT INTO kby_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Adǝ cakke saniandero diwi wulduwu runju gǝni, har sǝnǝm kura Ya Artimas ti duwon am Asiyaye so, dunia ngaye so samma ambǝccagaidǝye fannju ye awima gǝniro walji, darajanju ye baworo walji,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Adǝa fangeranniya, tai dajane gǝrgajane kowo sapcane: «Ya Artimas Afisayema kura wo!» cani. ");
INSERT INTO kby_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Daji hangalsangodǝ bǝrni ngaro tatargaada. Jamadǝ Gayus-a Aristarkus-a am lardu Makidoniyaye Bulussa casadduwunadǝa cadane kǝla tilonna farsambo gangadaro kesado. ");
INSERT INTO kby_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus curo cammodǝyero ngawo cǝraana duwon, fuwurawadǝ tiro dapkeyera, ");
INSERT INTO kby_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","koro fuwuwu kura kura cidi Asiyaye laa tayi duwon sawawanjudǝ tiro am cakkunode bare farsamdǝro lejǝnniro lowoyera. ");
INSERT INTO kby_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Am captanadǝye hangalnja cijǝna nangaro, laanja awo laa yiljane wuljai, laadǝ ye awo gade yiljane wuljai. Koro ngǝwunja awiro capkadaramaro nojanni. ");
INSERT INTO kby_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Daji yaudiyadǝ Aleksandaa tǝmbaljagane am laa jamadǝye tia casakke fuwuro koje dayenniya, mukko sapce jamadǝro jawawi cǝddi yeno. ");
INSERT INTO kby_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma ti yaudiro asuyeranniya, tayi samma kǝla tilonna sa yindi gairo yiljaiaro: «Ya Artimas Afisayema kura wo!» cani. ");
INSERT INTO kby_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kakkaduma bǝrnidǝye jamadǝa cakke nǝmgeranniya, tayiro: «Am bǝrni Afisaye, wundu gǝle bǝrni Afisaye tima gureduma fado Ya Artimas darajaadǝye-a gumkinju kauye samelan curǝnadǝye-a nojǝnnidǝ? ");
INSERT INTO kby_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","To, wunduma awo ania rakce angǝrjiwawodǝ, kǝdǝk nammowo, bare hangal bawolan awima diwwi. ");
INSERT INTO kby_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Am ania na adǝro kuduwwa, amma awima diwi fado Ya Artimassen cadǝnni ye, tia rajanni ye. ");
INSERT INTO kby_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dimitǝriyus-a saniawu amanju-a kǝla kam laayen sonjaaa, shararam menna, alkaliya ye menna. Kattenjan burwuda! ");
INSERT INTO kby_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Koro manando gade laa mennaa, jama majilisso captaiya, lamardǝa sharajai. ");
INSERT INTO kby_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hangal gǝnanowo, awo ku wakkajǝna adǝ hangalsango cane burwusaiya, rangiye dǝlwu jussǝna falma cammonde adǝye yiyewawo.» ");
INSERT INTO kby_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Adǝa wulyenniya, jamadǝa salamgeno. ");
INSERT INTO kby_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ngawo hangalsangodǝ cerǝnayen, Bulus fuwurawadǝa bowoje karwunjaro kowoɍi ce tayia alakǝlewayenniya, lardu Makidoniyayero leduro sapkadan. ");
INSERT INTO kby_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Lardudǝa jǝgane mana kadan tayi yero kowoɍi kenniya, lardu Gǝressero leje ");
INSERT INTO kby_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kǝndawu yakkuro napkeno. Cidi Siriyero maaralan ledu maji duwon, yaudiya laa tiro niadiwi caddi cane ci kǝlyera. Daji lardu Makidoniyayen renǝme koduro nia ngoyeno. ");
INSERT INTO kby_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Am tia casadduwunadǝ tayima Sofata tada Firusse kam bǝrni Biriyaye, Aristarkus-a Sakundus-a bǝrni Tasalonikaye, Gayus kam bǝrni Darbeye, Timoti, koro Tikikus-a Tarofimus-a cidi Asiyaye. ");
INSERT INTO kby_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tayi ani andin fuwunno lejane bǝrni Taruwasselan guresera. ");
INSERT INTO kby_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Andidǝ ye ngawo sala Burodi Yis Bawoayen bǝrni Filibiyen maararo ngayiye sapkadaiye. Ngawo kawu uwuyen tayia Taruwasnin nagǝiye mawuro napkeiye. ");
INSERT INTO kby_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mawuye yim burwoyea burodi fǝsakturo capkadaiyendeya, har dǝrdu Bulus jamadǝro kuruwuro jandeyeyeno, dalilnjudǝ wajiya leji cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Soro sameye na captiyenadǝn fatǝla kada waskada duwon, ");
INSERT INTO kby_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","jairo laa cunju Yutikus kǝla takayen napkada kǝnǝm dio badiyeno. Bulus manaji manaji duwon, kǝnǝm jairodǝa cotto ngoje soro sameye kǝnyakkuyen cidiro kikkuro. Kesangǝranniya, ro bawo nuna. ");
INSERT INTO kby_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Daji Bulus jǝpce ngujiye tia ngoje nganjiro fakciye tayiro: «Bare hangalndo cijǝnni, ronjua, diye!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bulus walde tacce burodi fǝsakce gigǝrǝnniya, ngǝwuro manajiyi duwon, har dunia waje sapkadan. ");
INSERT INTO kby_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jairodǝa ronjua caade karwunja jauro kǝjiyeno. ");
INSERT INTO kby_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Andidǝ fuwuniye bǝla Assossero leduro maararo kǝrgayiye. Bulus calan wuljǝnadǝ gai, nadǝn tia ngoniye niye, ti silan leji cǝnna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Andia Assoslan naseyeranniya, tia maaradǝn ngoniye bǝrni Mitileyero leyeiye. ");
INSERT INTO kby_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nadǝn ciyeiyendeya, wajǝnanjua gǝre cuku Kiyossero kadiye. Waarenjua cuku Samossen koniye, waarendonjua duwon bǝrni Militussero isiye jǝpkeiye. ");
INSERT INTO kby_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bare cidi Asiyayen tussǝnniro Bulus caman bǝrni Afisayelan dajǝnnin koji cǝne nia ngojǝna. Gandunju adǝ, yojia, ngǝmǝri Fentikosse tia Jerujalemlan najiyi cǝrawo. ");
INSERT INTO kby_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Bulus bǝrni Militusselan duwon, am cunode amwurawa jama Isaa gawu bǝrni Afisayedǝa bowoja isa yeno. ");
INSERT INTO kby_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kadiranniya, tayiro: «Tǝn yim burwoyen cidi Asiyayero isǝkkǝnadǝn naptu curondon kullum dikkǝnadǝa nonuwwa. ");
INSERT INTO kby_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kida Kǝmaye rokura bawoalan dikke har soma dikkǝna, koro yaudiya laa wuro citilo saddǝnadǝro leiya ye yakkǝna. ");
INSERT INTO kby_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Koro nayiro awima gǝranjagakkǝniro awi yaye nayiro faidaa wulnjagakke farsam yen, fado fado yen alamnjakkǝnaro nonuwwa. ");
INSERT INTO kby_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ai, wuye yaudiya-a am Gǝresse-a sammaro Alaro walda tuwa cado Kǝmande Isaa mǝrsajaro wulgǝkke shedanǝkkǝna yero nonuwwa. ");
INSERT INTO kby_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Akko kǝrma Ruhu Alaye wua sakke Jerujalembo lekki, awo nadǝn wua suwandidǝa nokkǝni, ");
INSERT INTO kby_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","sai bǝrni fin yaye Ruhu Alaye wuro koso-a leiya nja-a guresaidǝa tabbansiyi kǝrga. ");
INSERT INTO kby_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Adǝ yaye ronidǝa awimaro ngokkǝni, nanin tamannju bawo, sai kida duwon Kǝma Isa wuro sina, wotte kawuɍi kǝji ser Alaye shedadudǝa tumogǝkkiya bas, raakko! ");
INSERT INTO kby_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«To, nayi duwon dawundolan dǝgakke kawuɍi kǝji nodo bargaa Alaye wullǝkkǝnadǝ samma wua gadero suruwwaworo nokkǝna. ");
INSERT INTO kby_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Adǝma nangaro ku nayiro shedanǝkki, bu wundundoyema kǝlanin bawo, ");
INSERT INTO kby_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","dalilnjudǝ nia Alaye sammaa falma gǝranjagakkǝniro wulnjagakkǝna. ");
INSERT INTO kby_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kǝlando-a bǝri duwon kǝlanjun Ruhu Alaye nayia sǝniyaro galanjanadǝ samma-a ngǝlaro ronowo! Jama Alaa gawuro kiskǝnowo, jama duwon bunjulan kaanjuro cǝdǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ngawo saptǝkkǝnayen, buldu diwi diwi curondoro ngasaye bǝridǝa basarjairo nokkǝna. ");
INSERT INTO kby_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Koro curondoman am laa cijane fuwurawaa ngawonjan gǝrduro jiredǝa kattuwuro kalakcai. ");
INSERT INTO kby_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Adǝ nangaro faadaro dǝgaiwo! Saa yakkuro bune-a kausu-aro har simmin simaloaro wundundoyema sǝmo kasta kollǝkkǝnidǝa tangowo! ");
INSERT INTO kby_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«To, kǝrma nayia mukko Ala-a mananju ser fandoye-ayero njasakkǝkkǝna, mana duwon rakce nayia isawuranjagai ye, curo am Ala kaanjuro cǝdǝna sammayen warasa njadi yedǝ. ");
INSERT INTO kby_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ɍiwulla, bi dinar, bi kajǝmu wunduyemaa luwammǝkkǝni. ");
INSERT INTO kby_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nayi kǝlandoma nonuwwa, mukkonin kida dikke wu-a am rokko leniye-aye mǝradunde galyekko. ");
INSERT INTO kby_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Curo awo aniyen nayiro dole ngǝnǝptowo kida dewo talaawaa bananoworo fǝlenjagakkǝna. Mana Kǝma Isa ti kǝlanju wuljǝnadǝa tangowo: “Njoma moworo bargaa wo.”» ");
INSERT INTO kby_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bulus awo ania wulyenniya, tungurumje tayi samma-a rokko moduwa kedo. ");
INSERT INTO kby_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Cesiriaro Bulusso kǝrdagane lewa kǝrawoye keddo. ");
INSERT INTO kby_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bulusse mana wulje tia gadero caruiwawo cǝnnadǝro, karwunja jaumaro kuttayeno. Daji tia na maaradǝyero kesadduwo. ");
INSERT INTO kby_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ngawo tayia alakǝlewaniyenayen, maararo ngayiye cǝkko cuku Kossero leyeiye. Wajǝnanjua cuku Rudassero koniye nadǝn bǝrni Fatarayero kadiye. ");
INSERT INTO kby_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fataralan maara lardu Fenisiyero leduma laa kiwandiyendeya, tiro ngayiye sapkadaiye. ");
INSERT INTO kby_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cuku Kuwirusse ruiye wailanden kolyeiyendeya, cidi Siriyero leniye bǝrni Tirren jǝpkeiye, nadǝn kare maarayedǝa casayi nangaro. ");
INSERT INTO kby_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Fuwurawa laaa fandiye nanjan mawuro napkeiye, tayidǝ Ruhu Alayen Bulusso bare Jerujalembo lejǝnni yera. ");
INSERT INTO kby_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Adǝ yaye sande ciduye kidǝnniya, ciyeiye. Tayi samma kamuwanja-a yallanja-a andia har ngawo bǝrnidǝyero sasadduwo. Ci tekuyen tungurummiye moduwa kidiyendeya, ");
INSERT INTO kby_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","alakǝlewadaiye. Daji andi maararo ngayiye, tayi ye fannjaro walladara. ");
INSERT INTO kby_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bǝlawuronde bǝrni Tirren kerǝnniya, bǝrni Tolemayissen jǝmmiye kǝramiyadǝa lewaniye kawu fallo nanjan napkeiye. ");
INSERT INTO kby_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wajǝnanjua saptiye bǝrni Kaisariyayero kadiyendeya, fado Filibus kawuɍi kǝji Alaye wuldumadǝyen jǝpkeiye. Tidǝ am tulurdǝye falnja. ");
INSERT INTO kby_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ferowanju dewu ngaltema kwa nojanni nawinawi cadi mbeji. ");
INSERT INTO kby_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kawu ngǝwuro nammiyena duwon, nawi laa tiro Agabus cani cidi Yahudiyayen kadio. ");
INSERT INTO kby_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nandero ise ngiri Bulusse cǝmoye ti kǝlanju si-a mukko-aro cikkere andiro: «Akko awo Ruhu Alaye wuljǝnadǝ: “Adǝgainin yaudiya Jerujalemlan kǝma ngiri adǝyedǝa cakkere mukko kǝrdiyayero sǝrǝccagai,”» yeno. ");
INSERT INTO kby_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Adǝa fangeiyendeya, andi-a am nadǝye-a Bulussa bare Jerujalembo lejǝnniro lowoyeiye. ");
INSERT INTO kby_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Daji Bulusse andiro: «Attǝ awi diwidǝ? Sondolan dauni namdu wa rawuw? Cu Kǝma Isaye nangaro, wudǝ koso runju gǝni, karmoma Jerujalemnin kasaddǝkkǝna,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Rangiye tia jawalndero yakkiyewaworo kiruiyendeya, manadǝa kolliye: «Awo Kǝma cǝraanadǝ tǝdo!» yeiye. ");
INSERT INTO kby_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ngawo kawu aniyen dabbardiye Jerujalembo leyeiye. ");
INSERT INTO kby_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Fuwurawa bǝrni Kaisariyaye laa ye andia sasadduwe fado Manason kam cuku Kuwirusselan jǝmmiyoro nanjuro seado. Manasondǝ fuwurawa burwoyedǝye falnja. ");
INSERT INTO kby_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerujalembo kadiyendeya, kǝramiyadǝ andia karwu kǝjiaro semowo. ");
INSERT INTO kby_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wajǝnanjua Bulus andi-a rokko na Yakubayero leyeiye, amwurawa samma ye capkadara. ");
INSERT INTO kby_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulus tayia lewayenniya, awo Ala kidanjuyen dawu kǝrdiyayen cǝdǝnadǝa fal fallen tayiro wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Adǝa fangeranniya, Alaa kengoro. Daji Bulusso: «Kǝrami, yaudiya kada kadami Isaa kasaccanaro rumma, koro tayi samma karwu tiloan Attauraa jaana. ");
INSERT INTO kby_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Amma nidǝ yaudiya larduwa kǝrdiyayen dasaana sammaa alammǝme wada Nawi Musaye ga kolja, bare tadawanjaa kajajanni bi adadǝa jaanni nǝmiro fangera. ");
INSERT INTO kby_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","To, awi gǝle diye? Ni na adǝro isǝmmadǝa fagatto fanjai. ");
INSERT INTO kby_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ngo awo wulnjǝgǝiye adǝa de. Curonden am dewu Alaro kansi jabbuna mbeji. ");
INSERT INTO kby_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Am ania ngone lamar tayirro walduyedǝa tayi-a rokko dewo, wuɍinjadǝa biyane kǝlanja calaroro. Adǝgainin tayi samma awo kǝlanǝmlan wuldidǝ awima gǝni, ni yea Attauraa gamaro nonjai. ");
INSERT INTO kby_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Amma kǝrdiya Isaa kasaccanadǝ, nia ngoniye tayiro da sǝnǝmbo tina ngǝro so, bu nja so, lǝman duwadǝnni ngǝro so, kǝnjǝna dio so wajaro wotiya ruwugǝiyena.» ");
INSERT INTO kby_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Wayenniya, Bulus am dewudǝa ngoje lejane lamar tayirro walduyedǝa kallo kedo. Daji Fado Alayero ngaye sardu yimnja tayirro waljai ye, sadaa wundunja yayero caddidǝ yea isanoyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kawu tulurdǝ njeronju del karǝnjǝna duwon, yaudiya laa cidi Asiyaye Bulussa Fado Alayen kerunniya, jama sammaa casange tia cadane ");
INSERT INTO kby_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","yiljane: «Jama Israyilaye, banasaganowo! Akko kam duwon alamdunjun ndaran yaye jamande-a Attaura-a na adǝ-a sammaro rudu gǝnajiye, har kǝrdiyamaa Fado Alayero cuwude nadǝa tayir gǝniro cǝdǝnadǝ!» yera. ");
INSERT INTO kby_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Awoa Tarofimus kam Afisaye ti-a kallo bǝrnidǝn carune Bulus tia Fado Alayero cuwudǝnaro tǝmayera. ");
INSERT INTO kby_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Hangal bǝrni sammaye caa cije, jama cagasiaro isane Bulussa cadane gǝrjane Fado Alayen kettuluwunniyama, cinnadǝa jakkera. ");
INSERT INTO kby_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tia njejoro majai duwon, kajalla sojiya Rombe lawar hangalsango Jerujalem ngan cijǝnayedǝa fangeno. ");
INSERT INTO kby_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sadǝman kǝwuwa sojiyaye-a kuranja-aa ngoje jamadǝyero ngǝrǝmbaro kadira. Jamadǝ tayia kerunniya, Bulussa baktu kolyera. ");
INSERT INTO kby_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Daji kajalladǝ karǝnje tia cǝdane wada ce tia saɍga yindin cakkero yeno. Ti wundu, koro awi cǝdo cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Curo jamadǝyen laanja awo laa yiljane wuljai, laa ye awo gade yiljane wuljai. Hangalsangodǝro awima rakce asujiwawodǝ, wada ce Bulussa sojidiro caado yeno. ");
INSERT INTO kby_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bulus kǝmbaramdǝro kadinniya, gǝrgadu jamadǝye nangaro sojiyadǝ tia samero ngoyera. ");
INSERT INTO kby_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Jama samma yiljaiaro: «Yeje tia!» cane tayia geya. ");
INSERT INTO kby_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sa Bulussa sojidiro casakkidǝn, kajalladǝro: «Amarsǝgǝne, awo laa wulnjǝgǝkke,» yeno. Tiro: «Ase, tǝlam Gǝresse nonǝmma wa? ");
INSERT INTO kby_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ni gǝni wa kam Masarre tussǝnni tuɍu cǝde karaaro kamceji dǝwu dewu cadǝnadǝ?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulusse: «Wu yaudi bǝrni Tarsus cidi Kilikiyaye, kam bǝladeyaye gǝni. Lowonjǝkkǝna, kolsǝne jamaro jandegǝkko,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Amari kenniya, Bulus kǝmbaramdǝlan daje jamaro mukko sapkeyeno. Tayi samma gǝm kedǝnniya, tǝlam yaudiyaudin tayiro: ");
INSERT INTO kby_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Kǝramiya so, bawani so, awo kǝlani moworo kǝrma wulnjagakkidǝa fannowo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tǝlam yaudiyaudin tayiro jandejiyiro fangeranniya, cayemaa kojǝnaro gǝm kedo. Daji Bulusse tayiro: ");
INSERT INTO kby_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Wu yaudi, bǝrni Tarsus cidi Kilikiyayen katambǝkko, amma bǝrni adǝn wurayekko. Fuwura Gamaliyellero wallǝkke wadawa kaariyandeye sammaa taldu bawoaro ga kiɍǝkko. Caman wuye Alaa kasattuni dama bawo, ku nayi diwidǝ gai. ");
INSERT INTO kby_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Am jawal Isayea jagaidǝa basarnǝkke har laa sanuna, laa yea kwan kamun gerǝkke kosoro kekkǝkko, ");
INSERT INTO kby_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ɍiman kura-a majiliswu samma-a ye kǝlanin shedajaidǝ gai. Nanjan wotiyawa kǝramiya yaudiyaro ruwuwada kimowokkǝniya, tayi bǝrni Damassen dasaana yea Jerujalembo tikkerǝna kudǝkke ajawu tayiro gǝnajagai nǝkke jawal kidakko. ");
INSERT INTO kby_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Kausu dawu gai ledu dikki duwon, Damassa karǝngekkǝniya, sadǝman nur kura sameye laa yiyilje wua dirise kǝlseno. ");
INSERT INTO kby_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Cidiro bǝp yurukke kowo laa nukce wuro: “Shawulu, Shawulu, awiro wua basarsǝmidǝ?” cǝne fangekko. ");
INSERT INTO kby_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Wuye: “Kǝma, ni wundu?” nǝkke kiworǝkkǝniya, tiye: “Wuma Isa kam Najaratte basarsǝmidǝ wo,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Am wua sasadduwidǝ nurdǝa caruna, amma kowo ti wuro jandesiyidǝyedǝa fanjanni. ");
INSERT INTO kby_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Daji wuye: “Awi gǝle dikki, Kǝma?” nǝkke kiworǝkkǝniya, Kǝmadǝye wuro: “Cine Damasso lene, na todǝn awo Ala niro kadarnjǝgǝna dimi sammaa wulnjagai,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nur kuradǝ cakke har rukkiwaworo wallǝkkǝna nangaro, am wua sasadduwidǝ mukkoyen jesane Damasso kadikko. ");
INSERT INTO kby_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Damaslan kam laa tiro Ananiya cani mbeji. Tidǝ Attaura Nawi Musayelan mumin, koro yaudiya bǝrnidǝn dasaana samma ngǝlanju wuljai. ");
INSERT INTO kby_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Daji naniro ise daje: “Kǝramini Shawulu, sim fande!” yeno. Sadǝman sim fandǝkke tia kirukko. ");
INSERT INTO kby_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Koro walde wuro: “Ala kaariyandeyedǝ rawonjua none, Jiremadǝa rui, koro kowo cinjuyedǝa fannero nia kǝrenjǝna, ");
INSERT INTO kby_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","dalilnjudǝ shedamanjuro wallǝme adamgǝna sammaro awo rumma-a fannǝmma-aa wulgǝmi nangaro. ");
INSERT INTO kby_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kǝrma, awi gurenǝmi? Cine, cunju bowonǝmiaro kasala njaddo, biwuwanǝm tulja!” yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Jerujalembo walladakkǝniya, Fado Alayen moduwa dikki duwon, wahayi laa wua sǝdane ");
INSERT INTO kby_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Kǝmaye wuro: “Jǝktǝgǝne, duwaduwan Jerujalemlan luwe, shedanǝm kǝla wuyen ngojaiwawo nangaro,” cǝni kirukko. ");
INSERT INTO kby_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Wuye: “Kǝma, calan wudǝ dandal dandalnin am nia kasannjanaa kosoro yakkǝkke kowonǝkkidǝa tayi kǝlanjama nojana. ");
INSERT INTO kby_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Koro sa Istifanus shedamanǝmdǝye bunju fijanadǝn, wu ye nanjan danǝkke kasaddǝkke, har kalwu am tia ceyesiyedǝa gureyekko.” ");
INSERT INTO kby_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Daji Kǝmaye wuro: “Lene, kuruwuro na kǝrdiyayero njunodǝkki!” yeno.» ");
INSERT INTO kby_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jamadǝ Bulussa kǝrǝnjai ngai duwon, mana kǝla kǝrdiyayen wulyenniya, kowo sapcane yiljane: «Yeje, tia dunian sigǝne! Tia roa koldu jussǝnni!» yera. ");
INSERT INTO kby_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Yiljane kalwunja gǝpcane katti samero yiyirjagai ngai duwon, ");
INSERT INTO kby_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","dalil jamadǝ kǝlanjun yiljaidǝa nodu cǝraana nangaro, kajalladǝ wada ce sojiyadǝ tia cada sojididǝro casakko kowoja yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tia kowojaro kekkerǝnniya, Bulus soji kura fuwunjun daadadǝro: «Wowom Rombe amarnjagane shara yidduwwilan kam Rombea kowonuwi wa?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Soji kuradǝ adǝa fangenniya, leje kajalladǝro: «Awi dio manǝmi? Kam adǝ kam Rombe, diye!» ");
INSERT INTO kby_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Daji kajalladǝ na Bulussero ise tiro: «Wulsǝgǝne, ni kam Rombe wa?» cǝne kiworǝnniya, tiro: «Aaa,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kajalladǝye: «Wu wuɍi kadan kam Rombero walyekko,» yenniya, Bulusse: «Wudǝ, kam Rombe katambǝkko!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sadǝman am tia kororo dabbardanadǝ koljane sapkadara. Kajalladǝ ye riyeno, dalilnjudǝ ti kam Rombe, koro tia cikkerǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wayenniya, kajalla Rombedǝ dalil yaudiya Bulusso ayau gǝnajaanadǝyea tabbatto noduro maji nangaro, wurawa ɍimannaye-a majiliswu samma-aro wada captuye ce Bulussa wuije caade fuwunjan dayeno. ");
INSERT INTO kby_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus majiliswudǝa ninije tayiro: «Kǝramiyani, har kuro karwunin saɍiwu bawoaro fuwu Alayen kǝrgakko,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ɍiman kura Ananiya am gǝre Bulussen daadadǝro cinju bakca yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Daji Bulusse tiro: «Ala nia bannji, ni garu garuda bullan cingadadǝ! Attauraa gamilan shara sǝddero napkadanǝm duwon, wua bansa nǝme Attaura ga wayem!» ");
INSERT INTO kby_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Am nadǝn daadadǝye tiro: «Ɍiman kura Alayedǝa ranǝmi wa?» yeranniya, ");
INSERT INTO kby_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulusse: «Kǝramiyani, tima ɍiman kura woro nokkǝni, kitawulan ruwuwada: “Bare kǝla fuwuma jamanǝmben manakuttu wullǝmmi!”» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bulus laanja Sadusiya, laa ye Farisawaro asuyenniya, majilislan kowo sapce: «Kǝramiya, wu Farisa, tada Farisawaye. Kǝla karmolan cidu mbejiro tǝmakkǝnayen wuro shara saddi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Adǝa wulyenniya, katte Farisawa-a Sadusiya-ayen kambiwu cije majilisdǝ yakkadan. ");
INSERT INTO kby_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Awoa Sadusiyadǝ cinowo ye bawo, malaiya so, jinni so ye bawo cani, amma Farisawadǝ awo ani samma mennaro kasaccana. ");
INSERT INTO kby_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Daji kalala ngǝwu ciyeno. Malǝmba Attauraye kǝwu Farisawaye laa cijane mana jau cade: «Kam adǝn awima diwi fandiyende. Jinni bi malaiya laa tiro jandejǝgǝnaa, nda?» yera. ");
INSERT INTO kby_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kambiwudǝ tai daje jaujǝnaro walyenniya, kajalladǝ Bulussa njanjakcairo rijǝna nangaro, wada ce kǝwu sojiyaye ngasawo tia dawunjan cada sojididǝro kalakca yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Buneyenniya, Kǝma gǝrenjun daje tiro: «Karwunǝm gere! Jerujalemnin kǝlanin shedanǝmmadǝ gai, sai bǝrni Rombe yen shedanǝmiya!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wayenniya, yaudiya laa ci kǝljane awima jawuiwawo casaiwaworo kansi jawune sai Bulussa roro ceyesiya duwon yera. ");
INSERT INTO kby_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Am ci kǝlda adǝa cadǝnadǝ tayi fidewumaa kojǝna. ");
INSERT INTO kby_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Daji na wurawa ɍimannaye-a amwurawa-ayero lejane tayiro: «Awima buiyewawo yaiyewaworo kansi jau buiyena, sai Bulussa roro yejiyeya duwon! ");
INSERT INTO kby_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","To, kǝrma nayidǝ majiliswu-a rokko lamarnju kalkallo koruwi gairo kajalladǝro tia nandoro cuwudo wullowo. Andi ye kawu isimaro, tia njejoro dabbardiyena,» yera. ");
INSERT INTO kby_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Amma Bulusse tadanju tiro rawama wo ci kǝlda adǝa fangenniya, sojididǝro leje ngaye Bulusso wulyeyeno. ");
INSERT INTO kby_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Daji Bulus sojiya kuraye falnja bowoje tiro: «Jairo adǝa kajalladǝyero yade, awo laa tiro wulduwuye cǝdana,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Daji sojidǝ tia ngoje na kajalladǝyero cade tiro: «Bulus kosoma wua bowose jairo adǝa nanǝmbo kudǝkko yeno, awo laa niro wulnjiyi mbeji nangaro.» ");
INSERT INTO kby_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kajalladǝ jairodǝa mukkoyen cǝdane sǝgǝriro cuttuluwe tiro: «Awi wuro wulduwuye tam?» cǝne kiworo. ");
INSERT INTO kby_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tiye: «Yaudiya laa kǝla Bulussen kalkallo cawori gairo baɍi majilisso yadero njawori cane cinja kǝljana. ");
INSERT INTO kby_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma bare tayia kasaddǝmmi, curonjan am fidewumaa kojana cinja kǝljane tia ceyesǝnnin awima jawuiwawo casaiwaworo kansi jawuna. Kǝrmadǝ tayi dabbardana, amarinǝm bas gurejai,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Daji kajalladǝ jairodǝro: «Bare wundumaro awo ania wulsǝgǝmmaro wulgǝmmi!» cǝne tia kolje leyeno. ");
INSERT INTO kby_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kajalladǝ soji kura yindi bowoje tayiro: «Soji yer yindi-a soji fǝrwu fitulur-a soji kajaaa yer yindi-a cammowo, sa lǝgar buneyen bǝrni Kaisariyayero leduro dabbardǝnowo! ");
INSERT INTO kby_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Fǝr kǝmbaye ye dabbarnowo, Bulus tiro juwa kǝlewa salainin tia na Gomna Felissero yadowo!» cǝne ");
INSERT INTO kby_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","wotiya ngai ruwuyeno: ");
INSERT INTO kby_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Barganǝmmin Gomna Felis, ngǝwuro dǝgai! Wuma Kǝlodiyus Lisiyas. ");
INSERT INTO kby_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kam adǝa yaudiya cadana roro ceyesi duwon, ti kam Rombero fangekkǝniya, wu-a sojiyani-a isiye tia mukkonjalan kimowokko. ");
INSERT INTO kby_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ayau fi tiro gǝnajagaidǝa nokkoro tia majilisnjaro kiadǝkko. ");
INSERT INTO kby_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Kǝla mana laa wadanjayen ayau gǝnajaaro asuyekko, amma ayaunju fima karmo bi kosoro njakkoye wajipcǝnni. ");
INSERT INTO kby_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kǝlanjun ci kǝlda mbejiro fangekkǝniya, sadǝman tia juwanjǝgǝkke am tiro ayau gǝnajaanadǝ yero fuwunǝmnin sonja njaddo yekko.» ");
INSERT INTO kby_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Daji sojiyadǝ wadanja jaane Bulussa ngojane curo buneyen bǝrni Antifatirissero kesado. ");
INSERT INTO kby_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wajǝnanjua fǝrwudǝ tia casadduworo koljane sojididǝro walladara. ");
INSERT INTO kby_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Soji fǝrwudǝ bǝrni Kaisariyayero isane wotiyadǝa Gomnaro kedǝnniya, Bulus yea mukkonjuro kesakko. ");
INSERT INTO kby_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gomna wotiyadǝa kǝrayenniya, Bulusso ti lardu fiye cǝne kiworo. Ti lardu Kilikiyayero fangenniya, ");
INSERT INTO kby_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tiye: «Am niro ayau gǝnanjaanadǝ isaiya, mananǝm fakki,» yeno. Daji Bulussa mairi Mai Hirudussero caado gureja yeno. ");
INSERT INTO kby_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ngawo kawu uwuyen ɍiman kura Ananiya-a amwurawa laa-a goninja sharaye tiro Tartulus cani-a bǝrni Kaisariyayero isane sonja kǝla Bulussen Gomnaro keddo. ");
INSERT INTO kby_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bulussa kewudǝnniya, Tartulus tiro ayau gǝnaduwu badiyeno. Gomnaro: «Barganǝmmin, kǝrmainǝmlan naptu nanlewayen kǝrgaiye. Curo nanrashidunǝmben awowa bǝɍin nianǝme jamandero yiddǝmmadǝ casakke kǝjiro lardu adǝ tai daje fuwu juwuna. ");
INSERT INTO kby_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ndaran yaye sa fin yaye, Gomna, awowa dimma ani nga nangaro nia jaumaro wusenjiyena! ");
INSERT INTO kby_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Barganǝmmin, manani kuruwujiwawo. Adǝ nangaro marne lowonjǝkkǝna, kanadinǝmbo kanadi yirgai, gana laaro kǝrǝnsane. ");
INSERT INTO kby_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kam adǝa fitǝnama kuraro kiruiye, dunia ngan curo yaudiyayen hangalsango cǝsangi, koro ti kǝwu adin kattuwuye tiro Najaratwu canidǝye fuwuma. ");
INSERT INTO kby_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Fado Alayedǝmaa tayir gǝniro dio majǝna duwon, tia kidaiye. Kǝla wadandeyen tiro shara njǝddoro kirayiye, ");
INSERT INTO kby_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","amma Lisiyas kajalladǝ ise duno bul foknin tia mukkonden cǝmoye ");
INSERT INTO kby_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","am tiro ayau gǝnajaanadǝro nanǝmbo isa yeno. Tia korǝmia, ni kǝlanǝmma awo kǝlanjun wulliyena sammaa nonǝmi.» ");
INSERT INTO kby_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yaudiyadǝ ye ayaudǝro duno cade jirero tabbatkeyera. ");
INSERT INTO kby_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Daji Gomna tiro manajoro alama kenniya, Bulusse: «Ku kǝrwu kada jama adǝro shara yiddǝmi nokkǝnadǝro, karwu kǝjiaro fuwunǝmnin kǝlani mowokki. ");
INSERT INTO kby_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Barganǝmmin, rangǝme tabbatto nonǝmidǝ gai, ku kawu mewun yindin kojǝnni Jerujalembo Alaro ambǝttuwuro lekkǝna. ");
INSERT INTO kby_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Fado Alayen, bi curo dandallayen, bi curo bǝrniyen kambiwu wunduma-a diye ye sarunni, jamaa yakkǝkke hangalsango cadi ye nasaganni. ");
INSERT INTO kby_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Koro awo kǝrma kǝrsaanadǝa rakcane fuwunǝmnin tabbaccagaiwawo. ");
INSERT INTO kby_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amma adǝa federo wulnjǝgǝkki, Ala kaariyandeyero ambǝtkǝkke Jawal duwon tayi adin jireye gǝni canidǝa gakki. Awo Attaura-a kitawuwa nawiyaye-alan ruwuwada sammaa kasaddǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Koro cinowo jirewu-a jirenambuwu-a sammaye mbejiro Alalan tǝmania, tǝma duwon tayi kǝlanja kasaccanadǝ. ");
INSERT INTO kby_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Adǝ nangaro sawi yaye kowoɍinǝkke karwunin saɍiwu bawoaro fuwu Ala-a jama-ayen kǝrgakko. ");
INSERT INTO kby_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Ngawo kǝrwu kadayen wuɍi sadaaye jamandero kudǝme bu fida Alaro njǝddoro waldǝkke kadikko. ");
INSERT INTO kby_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ngaima duwon, Fado Alayen lamar tayirro walduye dikkǝnaye ngawon naseyera. Nanilan jama ye bawo, hangalsango ye bawo. ");
INSERT INTO kby_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amma yaudiya laa cidi Asiyaye mbeji. Awo laa wuro kǝrduwuye cadanaa, ngǝlanjudǝ tayima nanǝmbo isa wuro kǝrsaa. ");
INSERT INTO kby_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bi am anima sa fuwu majilissen dakkǝnadǝn ayau wulan cawandǝnadǝa wulja. ");
INSERT INTO kby_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ra, fuwunjan danǝkke kowo dunoaro sammǝkke mana fal adǝa dikke: “Kǝla cinowo am sanunayen ku sharasuwi,” wullǝkkǝnadǝ?» ");
INSERT INTO kby_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Daji Gomna Felis Jawaldǝa ngǝlaro nojǝnadǝ, manadǝa fuwuro gǝrje tayiro: «Yim Lisiyas kajalladǝ isiya, shara njaddǝkki,» cǝne ");
INSERT INTO kby_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","soji kura laaro wada ce Bulussa kosoramlan roja, amma tiro kasam cado koro bare amnjuro isǝme meradunju galdu dapcaganni yeno. ");
INSERT INTO kby_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ngawo kawu ganayen Gomna Felis kamunju yaudi tiro Durusila cani-a rokko kadinniya, cunode Bulussa cawude tia kǝla Isa Almasiwua kasattuyen manaje kǝrǝngeno. ");
INSERT INTO kby_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kǝla jire dio so, kǝla ɍiwo so, shara Alaye fuwun isi soyen jandejiyi ngai duwon, Gomna rije tiro: «Kǝrma kolle lene, dama fandǝkkiya, bowonjǝkki,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Sa adǝ yen Bulus tiro wuɍi ciro tǝmajǝna nangaro, ngǝwuro tia bowoje jandejai. ");
INSERT INTO kby_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kǝrwu yindi kidǝnniya, Gomna Felis jǝpce cujunjuro Fokiyus Festus giwa. Yaudiyadǝro ser njǝddo cǝraana nangaro, Gomna Felis Bulussa curo kosoyen kolyeno. ");
INSERT INTO kby_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gomna Festus lardudǝro isǝnaye kawu yakkua, bǝrni Kaisariyayen cije Jerujalembo leyeno. ");
INSERT INTO kby_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Wurawa ɍimannaye-a fuwuwu yaudiyaye-a nanjuro isane Bulusso ayau gǝnajagane lowojane ");
INSERT INTO kby_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","tayiro ser laa cǝddo Bulussa Jerujalembo kalakcoro keworo, tia jawallan kapkǝgǝme njejoye nia ngojana nangaro. ");
INSERT INTO kby_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma Gomnaye tayiro: «Bulussa bǝrni Kaisariyayen rojai, koro wu kǝlani tussǝkkiwawo bǝrnidǝro waldǝkki. ");
INSERT INTO kby_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Fuwuwundo laa wua saa leniyo, kamdǝn awo laa diwi mennaa, tia burwuja!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Gomna dawunjan kawu wusku bi mewua kojǝnniro napkenniya, bǝrni Kaisariyayero walladan. Wajǝnanjua shararambo leje napce Bulussa cawudo yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kewudǝnniya, yaudiya Jerujalemlan isanadǝ tia dirijane kǝljane ayau kada jau fit gǝnayeyera, amma tayiro tabbattuwu katkero. ");
INSERT INTO kby_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulusse kǝlanju moworo: «Wada yaudiyayero, bi Fado Alayero, bi Kaisarro biwu fimaa yiddǝkkǝni!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Gomna yaudiyaro ser njǝddo cǝraana nangaro, Bulusso: «Jerujalembo lenǝme na todǝn kǝla awo adǝyen shara njǝddǝkki raamma wa?» cǝne tia kiworo. ");
INSERT INTO kby_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulusse: «Akkoni shararam Kaisarren daada, na adǝman sharani kamduma jussǝna wo. Awima diwi yaudiyaro yiddǝkkǝniro ni kǝlanǝm dam nonǝmma. ");
INSERT INTO kby_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jireni bawoa, bi awo laa diwi shara karmoye dikkǝnaa, karmoro kadǝkkiwawo. Amma ayau am ani wuro gǝnasaanadǝ jire gǝnia, wundumaro wua mukkonjaro njakko amardǝgǝnni. Kaisar wuro shara sǝddo!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Daji Gomna Festus galawunju-a sawargadaranniya, tiro: «Kaisar niro shara njǝddiya, raam? To, na Kaisarrero lenǝmi!» yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kawu gana koyenniya, Mai Agarifa-a Mairam Baniyatu-a lewa Gomna Festussero bǝrni Kaisariyayero kadira. ");
INSERT INTO kby_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bǝrnidǝn kawu kadaro napcana duwon, Gomna Festus awo Bulussa wujǝnaa maidǝro wuljiye tiro: «Na adǝn curo kosoyen kam laa Gomna Felis koljǝna mbeji. ");
INSERT INTO kby_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerujalembo leyekkǝniya, wurawa ɍimannaye-a amwurawa yaudiyaye-a kǝlanjun sonja sakkude tiro shara karmoye kekkoro. ");
INSERT INTO kby_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Wuye tayiro kam burwujanadǝ fuwu am tia burwujanayen kǝlanju moworo sonjaye kǝlan dama mana dioye cuwandǝnnin sharanju kamdudǝ ada am Rombe gǝni yekko. ");
INSERT INTO kby_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«Daji bǝrni adǝro kadiranniya, wajǝnanjua dǝgallǝkke shararambo lekke nammǝkke kamdǝa cawudo yekko. ");
INSERT INTO kby_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Am burwujanadǝ mana dioro dayeranniya, ayau jau tǝmakkǝnadǝa gǝni gǝnajaa, ");
INSERT INTO kby_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","biya kǝla adinnja-a kam laa cunju Isa nuna duwon Bulusse ti roa cǝni-ayen kambiwudai. ");
INSERT INTO kby_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Wu ye jiɍi dikke awo ania kokorǝkkiro nokkǝnidǝ, Bulusso Jerujalembo leje na todǝn tiro shara yiddǝkki cǝraana wa nǝkke tia kiworǝkko. ");
INSERT INTO kby_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma waje Bargaanju Kaisar sharanju cǝddoro tia roja yenniya, har kawu na Kaisarrero juwagǝkkiro tia kosolan roja yekko.» ");
INSERT INTO kby_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mai Agarifaye: «Wu ye kam adǝa kǝrǝnnǝkkiya, raakko,» yenniya, Gomna Festusse tiro: «Baɍi tia kǝrǝnnǝmi,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wajǝnanjua Mai Agarifa-a Mairam Baniyatu-a ngawomaila jauro darajaalan isane tayi-a kajallawa-a fuwuwu bǝrnidǝye-a soro kura majilissero kasargawo. Gomna Festus wada kenniya, Bulus yea kewudo. ");
INSERT INTO kby_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Daji Gomnaye: «Mai Agarifa-a nayi captuwwa samma-a, akko kam kǝlanjun jama yaudiya samma Jerujalemnin kal, bǝrni adǝn kal lowosane dunoaro kowo sapcane dunian baworo waljiya, jusso cannadǝa ruwi. ");
INSERT INTO kby_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Wudǝ, awima tia roro njejoye cǝdǝnniro asunǝkkǝna. Amma Bargaanju Kaisar tiro shara cǝddiya cǝrawo cǝnnadǝro, nia ngokke tia nanjuro juwagǝkki yekko. ");
INSERT INTO kby_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mana kibbu kǝlanjun kǝmaniro ruwuduwuye takkǝni. Adǝma nangaro tia fuwundoro kiwudǝkko, tagǝnasso fuwunǝmbo, Mai Agarifa, tia kokoriyeya, awo ruwuduye fandǝkkoro, ");
INSERT INTO kby_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","dalilnjudǝ kosoma ayaunju ruwudǝnni duwon juwaduwudǝ jussǝnniro kirukko.» ");
INSERT INTO kby_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Daji Mai Agarifaye Bulusso: «Kǝlanǝmnin mana dioro niro amardǝgǝna,» yenniya, Bulus mukko sapce kǝlanju moworo mana badiyeno: ");
INSERT INTO kby_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Barganǝmmin, ku kǝla ayau yaudiya gǝnasaana sammayen kǝlani moworo fuwunǝmlan mana dikkidǝ, kǝji fakki, ");
INSERT INTO kby_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","tagǝnasso ada so, kambiwu so yaudiyaye ngaa ngǝlamaro nonǝmmadǝro. Adǝ nangaro lowonjǝkkǝna, marne wua kanadilan kǝrǝnsǝne. ");
INSERT INTO kby_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Yaudiya samma tǝn gananilan dawu jamandeye yen, Jerujalem yen kǝndǝgaini dikkǝnadǝa nojana. ");
INSERT INTO kby_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Tussǝna wua nosanadǝ, caraanaa, wu kǝwu adinnde jau fit Farisawayedǝa gakkǝnaro rakcane shedasai. ");
INSERT INTO kby_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Koro kǝrma wadu duwon Ala kaariyandero ngojǝgǝnadǝyen tǝmania nangaro, shara kamsagai. ");
INSERT INTO kby_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jiɍinde mewun yindin ye wadu adǝn tǝmanjaa bune-a kausu-a dadu baworo Alaro ambǝccagai. Barganǝmmin, wadu adǝma nangaro yaudiya wuro ayau gǝnaseyera! ");
INSERT INTO kby_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A! Awiro gǝle nayiye Ala amba karmolan cǝsangidǝro tǝmmaro yojiwawo nuwidǝ? ");
INSERT INTO kby_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Calan wu kǝlanidǝ cu Isa kam Najarattea baworo dioro awo ngǝwu dikkoro ngǝlaro kirukko. ");
INSERT INTO kby_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Adǝmaa Jerujalemlan dikko. Na wurawa ɍimannayen amari fandǝkke muminna kada kosoro kekkǝkko. Koro sa tayia roro ceyesǝnadǝn, wu ye kasaddǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Dandal samman ngǝwuro Isaa bassaro tayiro wowom gǝnagǝkki. Karwuni tayia wul wajǝna nangaro, har bǝrniya lardu gadeyero lekke tayia basarnǝkki. ");
INSERT INTO kby_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Adǝgaima kǝnduwo-a amari-a wurawa ɍimannayealan bǝrni Damassero lekki duwon, ");
INSERT INTO kby_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Barganǝmmin, kausu kǝla dawu gai jawallan nur sameye laa kǝngalmaa yiyildun kojǝna wu-a am sasadduwi-aa wasse dirisane kǝlsana kirukko. ");
INSERT INTO kby_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Andi samma cidiro kikkuruiyendeya, kowo laa tǝlam yaudiyaudin wuro: “Shawulu, Shawulu, awiro wua basarsǝmidǝ? Ka satǝran baktu niro jau,” cǝne fangekko. ");
INSERT INTO kby_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Kǝma, ni wundu?” nǝkke kiworǝkkǝniya, Kǝmadǝye: “Wuma Isa basarsǝmidǝ wo. ");
INSERT INTO kby_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kua cine, dane! Dalil niro fǝledǝgǝkkǝnayedǝ, tima kadunomani ye, shedamani awo ku rumma-a fuwun fǝlenjǝgǝkki-aye yero njǝdǝkkoro. ");
INSERT INTO kby_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mukko jamanǝm-a jama kǝrdiyaye-ayen nia njǝmowokki. Kǝrdiyadǝyero juwanjǝgǝkke ");
INSERT INTO kby_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","simnja kanǝmi, tayia curo duwuyen tuluwume nurro yakkǝmi, koro tayia kǝnduwo Yiwulissen tuluwume Alayero kalakkǝmi. Adǝgaima gawara biwuye cawandi, koro curo am duwon kambǝrsenja nangaro tayirro waljanadǝyen nuwanja ye cawandi.” ");
INSERT INTO kby_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Barganǝmmin, adǝ nangaro wahayi sameye adǝa ga wakkǝni, ");
INSERT INTO kby_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","amma burwon am Damassero mana Alaye wulyeyekko, daji am Jerujalembe-a cidi Yahudiyaye sammaye-aro, har jama kǝrdiyaro wulyeyekko. Tayiro tǝmja, na Alayero walda, koro kǝndo tuwa jireye fǝlejisoa cado yekko. ");
INSERT INTO kby_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Adǝma nangaro yaudiya laa Fado Alayen wua sadane njejoro masera. ");
INSERT INTO kby_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Amma har kumaro bana Alaye fandǝkkǝna, nadǝn danǝkke am kuran ganan sammaro shedagǝkki. Awima gade wullǝkkiwawo, sai awo Nawi Musa-a nawiya gade-a wakkaji cannadǝ: ");
INSERT INTO kby_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Almasiwu bone cai, tima burwon karmolan ciji, koro amnde-a jama kǝrdiya-aro nur mawojiyi.» ");
INSERT INTO kby_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bulus awo ania kǝlanju moworo wuldu cǝdi ngai duwon, Gomna Festus kowo sapce tiro: «Bulus, ni joɍi! Kǝranǝm ngǝwu nia njakke joɍinǝmma!» yenniya, ");
INSERT INTO kby_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bulusse tiro: «Barganǝmmin Gomna Festus, wu joɍi gǝni. Hangalnia cor jire bas makki. ");
INSERT INTO kby_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mai Agarifa awo ani sammaa nojǝna, koro tiro ridu bawoaro jandegǝkki. Asǝrramben gǝni wakkajanadǝro, awo maidǝ nojǝnni falma baworo nokkǝna. ");
INSERT INTO kby_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Barganǝmmin Mai Agarifa, nawiyadǝa kasaddǝmma wa? Kasaddǝmmaro nokkǝna!» ");
INSERT INTO kby_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Daji maidǝye Bulusso: «A! Sam falnin wa wua kǝristaro sǝdǝmi tǝmanǝm?» yenniya, ");
INSERT INTO kby_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulusse tiro: «Sam falnin yaye, ngǝwun yaye, ni runǝm gǝni, am ku wua kǝrǝnsai samma saɍga aniro kajia, wu gairo waljaro Alaa korǝkki.» ");
INSERT INTO kby_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Daji maidǝ-a gomnadǝ-a Mairam Baniyatu-a am tayi-a rokko napkada-a cijane ");
INSERT INTO kby_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","keluwunniya, kattenjan: «Kam adǝ awima karmo bi kosoro njakkoye wajipcǝna cǝdi bawo,» cani. ");
INSERT INTO kby_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Daji Mai Agarifaye Gomna Festusso: «Ca Kaisar tiro shara cǝddo cǝnnia, rangiye tia kolliye,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lardu Italiyayero maaran leniyero nia ngoyeranniya, Bulus-a kosowu gade laa-a mukko Juliyus soji kura laa kǝwu sojiya Kaisarrero kesakko. ");
INSERT INTO kby_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Maara bǝrni Adǝramitiyaye laa bǝrniya jarara cidi Asiyayea jǝgairo ngayiye leyeiye. Curonden kam laa bǝrni Tasalonika lardu Makidoniyaye tiro Aristarkus cani mbeji. ");
INSERT INTO kby_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wajǝnanjua bǝrni Sidonnero kadiyendeya, Juliyus nanngǝla Bulusso fǝlejiye tia kolje sawawanjuyero mǝradunju galjaro leyeno. ");
INSERT INTO kby_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Na adǝn sapkadaiyendeya, karuwa ledu damsagaidǝro, kanji karuwa duno bawoa cuku Kuwirussen gaiye koyeiye. ");
INSERT INTO kby_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Daji kanji lardu Kilikiyaye-a Bamfiliyaye-a kaduniyearo tekudǝa falliye koniye bǝrni Mira lardu Lisiyayero kadiye. ");
INSERT INTO kby_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nadǝn soji kuradǝ maara laa bǝrni Aleksandariyaye lardu Italiyayero leji cuwande andia curonjuro sesakko. ");
INSERT INTO kby_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kawu kadaro yila yilayen fuwuniye duwon, kiaddin bǝrni Kinidusse karǝngeiye. Karuwa kolsane kǝla fuwunna leniyewawodǝ, kanji karuwa duno bawoa cuku Kǝrettero leniye niye fuwu bǝla Salmoniyen diriniye koyeiye. ");
INSERT INTO kby_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Jararadǝa gaiyearo kiaddin fuwuro leniye duwon, na tiro Daduram Ngǝla Maara Ingiye cani karǝn bǝrni Lasiyayero kadiye. ");
INSERT INTO kby_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bǝlawuronde kawu ngǝwu juwe asemdǝ kojǝna nangaro maaran ledudǝ jauro masiwaaro walyeno. Adǝ nangaro Bulus am ti-a kallo lejaiye sǝmo kasse ");
INSERT INTO kby_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","tayiro: «Jama, bǝlawurodǝ maara-a kare-a runja gǝni, rondemaro banna so, asar kura so cukkudiro rukki.» ");
INSERT INTO kby_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Amma soji kuradǝ awo Bulus wulji yayero mana kura maara kǝriduwuye-a kǝma maaramaye-ayedǝmaa ardijo. ");
INSERT INTO kby_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nangǝɍilan daduram maaraye adǝn naptudǝ kǝji gǝni nangaro, amdǝye ngǝwunja nadǝn saptuye nia ngoyera. Yojia, Fenisso lejane nadǝn nangǝɍi kojai yera, Fenisdǝ daduram maaraye cuku Kǝrette anǝmfǝde-a yalafǝde-aro ci. ");
INSERT INTO kby_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kasam laa anǝmbe fudu badiyenniya, maarawudǝ awo majaidǝa cawandǝna cane sunu ingilan cattuluwe jarara cuku Kǝrette jaane leyera. ");
INSERT INTO kby_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Amma sam kidǝnniya, karuwa dunoa tiro Karuwa Yalagǝdimi cani kanji cukudǝyen tai daje fuje ");
INSERT INTO kby_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","maaradǝa dap kida. Kanji karuwadǝyero suwordu tiyero nangaro, kolliye karuwadǝ andia seado. ");
INSERT INTO kby_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Cuku tǝngǝɍi laa tiro Kauda canidǝye kanjinju karuwa gana fuludǝnadǝro koyeiyendeya, kiaddin maara ganadǝa kanjindero gǝrniye ");
INSERT INTO kby_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","maaradǝro isatatkeyeiye, maarawudǝ jelan maara kuradǝa cidiya samennaro dirijane kǝljane mit kekkero. Bare Sirtisdǝro gǝmdaganniro batta maara judaramdǝa casaye koljane karuwadǝ maaradǝa tǝmbalyeno. ");
INSERT INTO kby_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Karuwadǝ jaumaro bansaidǝ, dunia wayenniya, kare curo tekuyero gǝptuwu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Koro yimbe yakkua kare kidaye maaradǝyea mukkonjaman ingidǝro gǝpkeyera. ");
INSERT INTO kby_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Keyera dama bawodǝro kawu kadaro kǝngal bi sillowu ruiyende, har tǝmande njǝkkawoye sammaa kolyeiye. ");
INSERT INTO kby_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tussǝna kǝmbo jawunnidǝ, Bulus dawunjan daje tayiro: «Jama, ca manani bare cuku Kǝrette kolliyendedǝa ngonuwwaa, banna-a asar-a ani ngaro kaniyena. ");
INSERT INTO kby_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Amma kǝrma marnowo, karwundo gerowo! Wundundoma nuiwawo, maaradǝ runjumaa fuddiye. ");
INSERT INTO kby_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Fannowo, bune adǝman malaiya Ala duwon wu kaanju ye, gakki yedǝye gǝrenin daje ");
INSERT INTO kby_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","wuro: “Bulus, bare rinǝmmi! Dole fuwu Kaisarren danǝmi, koro akko Ala njunonje njadduwowunǝm sammaye ro cǝkkayi,” yeno. ");
INSERT INTO kby_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","To, jama, karwundo gerowo! Wulsǝgǝnadǝ gai kalkallo wakkajiro Alaa mǝrsanǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Amma sai cuku laaro gǝmdiyiyeya,» yeno. ");
INSERT INTO kby_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kawu mewu deri kidǝnniya, bunenjua karuwa dunoadǝ andia kǝla teku Adariyayen tǝmbaldu cǝdi duwon, dǝrdu yindi gai maarawudǝ cidi karǝnniyenaro tǝmayera. ");
INSERT INTO kby_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nankuruwu ingiye ngalyeranniya, nganji findi kewando. Gana fuwujane gademinno ngalyeranniya, mewu wuri kewando. ");
INSERT INTO kby_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Maaradǝ kauwasoro gǝgǝmdiyiro rijanadǝ, sunu dewu ngawo maaradǝyen ingiro talarjagane wadu duniaye waryera. ");
INSERT INTO kby_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Daji maarawudǝ kǝlanja njǝkkaworo gaɍinjagane fuwu maaradǝyen sunuwa ingiro talarjagai cane maara ganadǝa ingiro kolduwu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bulusse soji kuradǝ-a sojiyadǝ-aro: «Maarawu ani maaradǝn napcaiwawoa, ranguwe rondo yikkawuwwawo!» ");
INSERT INTO kby_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Daji sojiyadǝ je maara ganayedǝa kamjane koljane kikkuro. ");
INSERT INTO kby_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Fajar Bulus kǝmbo jaworo tayi sammaa lowoje: «Akko ku kawundo mewu deri awima buwwi awo wakkaji gurenuwidǝ! ");
INSERT INTO kby_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","To, lowonjakkǝna, nanlewandoro buiwo! Ai, kanduɍi kǝla wundundoyema facciyiwawo.» ");
INSERT INTO kby_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Adǝa wulyenniya, Bulus burodi ngoje fuwu tayi sammayen Alaro ardije fǝsakce ngǝro badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Daji tayi samma ye duno cawande gewo. ");
INSERT INTO kby_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Curo maaradǝyen andi am yer yindin fitulurnin lukko arakkun. ");
INSERT INTO kby_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Jawune kulyeranniya, maaradǝ kamboijoro algamadǝa tekuro fiyeyera. ");
INSERT INTO kby_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Dunia wayenniya, maarawudǝ cididǝa nojanni, amma ci bǝrǝmbe na laa kattia kero. Rakcaia, maaradǝa nadǝro njadoro majai yera. ");
INSERT INTO kby_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Daji sunuwadǝa suwuccane tekun kolyera. Sadǝman je kǝriduramsodǝa rojǝnaa wuijane batta maara judaramdǝa karuwaro casangiye na kattiadǝro gǝrdu badiyera. ");
INSERT INTO kby_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Amma na laa ingi kuruwu gǝniro isane maaradǝa cidiro gǝmgeranniya, fuwunjudǝ kak daje, ngawonjudǝ ye duno tǝmbaɍiyaye cakke nanamdu badiyeno. ");
INSERT INTO kby_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bare wundunjama kambi cǝde ngǝrǝmjǝnniro, sojiyadǝ kosowu sammaa njejoro nia ngoyera. ");
INSERT INTO kby_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Amma kuranjadǝ Bulussa njǝkkawo cǝraana nangaro, tayiro awo niajanadǝa dapkeyeno. Am kambi nojanadǝro wada ce burwon sǝkta ingiro gǝptaa kambi cado ci tekuyero leja cǝne ");
INSERT INTO kby_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","am gadedǝ ye katako so, njongo maaraye soyen kǝlan leja yeno. Adǝgainin wundu yaye kǝlewa salainin ci tekuyero kadio. ");
INSERT INTO kby_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kǝlewa salainin kadiyendeya, cukudǝro Malita cani fangeiye. ");
INSERT INTO kby_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Am nadǝn dasaanadǝ andiro ser dama baworo fǝleseyera. Ingi cuduri koro kakua nangaro, kannu fujane andi sammaa sosasera. ");
INSERT INTO kby_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bulus kǝska kǝla fal capce kannuro fiyeyenniya, fusi laa kannu fanje culuwe mukkonjua calje tangaadan. ");
INSERT INTO kby_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Am nadǝyedǝ kadi mukkonjuro tangaada talarji kerunniya, kattenjan: «Jiremaro, kam adǝ kamceji! Tekun ronju kajǝna yaye, shara roa koljiwawo!» yera. ");
INSERT INTO kby_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Daji Bulus kadidǝa secce kannuro gǝpciye kuttu fima tia cuwandǝnni. ");
INSERT INTO kby_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Fuji bi ro bawoa bǝp curiro tǝmajana duwon, ngǝwuro gurejane awima tia cuwandǝnnidǝ, kuronja faljane ti sǝnǝm cani badiyera. ");
INSERT INTO kby_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Karǝn na adǝyen cidi laa lawan cukudǝye Faliyus caniye mbeji. Tidǝ andia kǝjiro kamsagane fannjun kawu yakkuro sosasera. ");
INSERT INTO kby_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Bawa Faliyussedǝ dondi bowada, kange-a njarwo-a tia cadana. Bulus nanjuro leyenniya, mukko gǝnajiye moduwa cǝde isangayeyeno. ");
INSERT INTO kby_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ngawo adǝyen am dondi cukudǝye gapcana isane tayi ye ngayera. ");
INSERT INTO kby_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Adǝ nangaro andiro jauro bǝrsǝm sade har sa cidundeye kidǝnniya, awo mǝradundero faidaa sammaa sedo. ");
INSERT INTO kby_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ngawo kǝndawu yakkuyen maara laa bǝrni Aleksandariyaye cukudǝn nangǝɍi kojǝna kǝlanjun alama Kawuwa Sǝnǝmbe cǝgarǝnadǝro ngayiye sapkadaiye. ");
INSERT INTO kby_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Bǝrni Sirakussero kadiyendeya, kawu yakkuro napkeiye. ");
INSERT INTO kby_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nadǝn jararadǝa gaiye duwon, tekudǝa falliye bǝrni Rigiyumbero kadiye. Wajǝnanjua karuwa anǝmbe fudu badiyenniya, kǝla fuwunna ciniye kawu yindin duwon bǝrni Futiyoli canidǝro isiye jǝpkeiye. ");
INSERT INTO kby_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Nadǝn kǝramiya laaa nayeyeiye. Andia dosane dawunjan mawuro napkeiye. Adǝgainin bǝrni Rombero leyeiye. ");
INSERT INTO kby_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kǝramiya Rombedǝ isiyero fangeranniya, andia kaptuwuro har Kasuwu Afiyusse-a Kusottoram Yakku-aro kadira. Bulus tayia kirunniya, Alaro ardije karwunjun duno kiwando. ");
INSERT INTO kby_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Rombo kadiyendeya, koljane Bulus runju soji gadimanju-a rokko napkeno. ");
INSERT INTO kby_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ngawo kawu yakkuyen Bulus fuwuwu yaudiyayea bowoje capkadaranniya, tayiro: «Kǝramiya, awima diwi jamande-a ada kaariyandeye-aro yiddǝkkǝni yaye, Jerujalemlan kosoma gai wua sadane mukko am Rombero sǝrǝnseyera. ");
INSERT INTO kby_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Koro seddǝranniya, ayau fima njejoye wulan bawo nangaro wua koldu kerawo. ");
INSERT INTO kby_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Amma yaudiyadǝ wajanadǝro, ayau jamaniro gǝnaduwuye takkǝni yaye, doleniro sai Kaisar wuro shara sǝddiya yekko. ");
INSERT INTO kby_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Adǝmaro nayia njarukke mana njaddǝkke nǝkke bowongerakko. Nonowo, tǝma Israyilawuye nangaro wu saɍga adǝlan tikkerǝkkǝnadǝ!» ");
INSERT INTO kby_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Daji tayiye tiro: «Andidǝ, wotiya falma lardu Yahudiyaye kǝlanǝmlan fandiyende, koro curo kǝramiyande na todǝn isanayen wunduma diwinǝm wulji fanniyende. ");
INSERT INTO kby_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Amma niyen awo tǝmanǝmma fanduro rayiyena, dalilnjudǝ ndaran yaye kǝwu adǝa wajanaro noniyena,» yera. ");
INSERT INTO kby_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Daji Bulusso sardu kamgeyeranniya, tayi nanngǝwun cayemaa kojǝnaro nanjuro kadira. Suwan tai har kajiriro kude, Bulus nodo bargaa Alayea shedaje Attaura Nawi Musaye-a kitawuwa nawiyaye-alan njuttiye awo Isaa wujǝnaa kasaccaro tayiro kawuɍi kiddo. ");
INSERT INTO kby_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Awo wuljǝnadǝa laanja kasatkera, laa ye kasattu wayera. ");
INSERT INTO kby_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Fandannin duwon, kawu lejaidǝro Bulusse tayiro mana fal cǝdde: «Awo Ruhu Alaye ci Nawi Ishayayen kaariyandoro wuljǝgǝnadǝ jire. ");
INSERT INTO kby_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Tiye: «“Lene, jama adǝro wulle: Ngǝlaro fannuwi duwon, kǝlandoro tǝmmaro ngayiwawo. Koro ngǝlaro ruwi duwon, tǝmmaro asunuwwawo. ");
INSERT INTO kby_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Awoa karwu jama adǝyedǝ kibbajǝna, kiaddin sǝmonja fanjai, simnja yea jakcana, bare simnjan carunni, sǝmonjan fanjanni, koro karwunjan asujanniro. Ngai gǝnia, naniro waldane tuwa cade tayia isangagǝkki.” ");
INSERT INTO kby_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«To, fannowo, lawar njǝkkawo Alaye adǝ jama kǝrdiyayero juwadǝgǝna. Tayidǝ fanjai!» ");
INSERT INTO kby_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Adǝa wulyenniya, yaudiya kattenjan kambiwu cadiaro sapkadara. ");
INSERT INTO kby_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kǝrwu yindi latto Bulus fannju agǝriyen napce, am tia kuroro isai sammaa mukko yindin kapciye, ");
INSERT INTO kby_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","wunduma tiro dapcǝgǝnnin tayiro federo kawuɍi nodo bargaa Alaye cǝdde awo Kǝma Isa Almasiwua wujǝnaa alamji kǝrga.");
INSERT INTO kby_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Wuma Bulus wolodi Isa Almasiwuye ye, kǝngayambo walduro bowowada ye, kawuɍi kǝji Alaye wulduro galaada ye, ");
INSERT INTO kby_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","kawuɍi kǝji duwon Ala kuren nawiyanjuyen kitawuwa darajaalan ci cǝne wadu ngojǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kawuɍi kǝjidǝ kǝla Tadanjuyen, ti duwon naptunju adamgǝnayen kaduwu Nawi Daudaye, ");
INSERT INTO kby_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","koro kǝla Ruhu Alayen karmolan cidunju nangaro kǝnduwoaro Tada Alayero tabbaccaanadǝ, tima Kǝmande Isa Almasiwu wo. ");
INSERT INTO kby_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tilaman ser-a nankǝngayam-aa kiwandiye, cunju nangaro amso curo kǝrdiya sammayen tia kasacca jaaro. ");
INSERT INTO kby_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Curonjan nayi ye jama Isa Almasiwuyero walduro bowowada. ");
INSERT INTO kby_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nayi duwon Ala njaraana ye, muminno walduro bowonjana ye bǝrni Romben dǝgawwa sammaro: Ala Bawande-a Kǝma Isa Almasiwu-a nayiro ser-a nanlewa-a njado! ");
INSERT INTO kby_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Burwo sallammin Isa Almasiwuyen nayi samma nangaro Alania wusenǝkki, mana kambǝrsendoye dunia ngalan cadidǝro. ");
INSERT INTO kby_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ala shedamani, ti duwon ronilan ambǝtkǝkke kawuɍi kǝji Tadanjuyea mawonǝkkidǝ, dadu baworo nayia tannjakke ");
INSERT INTO kby_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","kullum moduwa njaddǝkki, koro Alaye cǝdia, dama nandoro leduye fandǝkkoro tia korǝkki. ");
INSERT INTO kby_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nayia kuroro jauro raakkǝna, kǝnjo serre Ruhu Alayen karwundoro duno njoma laa nayiro njaddǝkkoro, ");
INSERT INTO kby_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","wotte kattenden kambǝrse kaando-a kakke-ayen andi samma duno fandiyoro. ");
INSERT INTO kby_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Kǝramiya, adǝa nonuwiya, raakko: Kǝrdiya larduwa gadeyen gai, curondo yen nema laa fandǝkkoro ngǝwuro nia nandoro leduye ngokkǝna, amma har kuro fandǝkke lekkǝni. ");
INSERT INTO kby_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Am kǝla fǝrǝmgada yen kal, fǝrǝmdǝnni yen kal, ilmuwu yen kal, ilmuwu gǝni yen kal, tayi sammaro kawuɍi kǝji wulduwuro kǝlaro ngokkǝna. ");
INSERT INTO kby_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Adǝma nangaro nayi bǝrni Romben dǝgawwadǝ yero kawuɍi kǝji wulduwu jauro raakǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kǝla kawuɍi kǝjidǝyen nangukkǝni, tima kǝnduwo Alaye kam tia kasaccǝnama fi yayero njǝkkawo kudomadǝ wo, burwon yaudiyaro, koro yaudiya gǝni yero. ");
INSERT INTO kby_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Curo kawuɍi kǝjidǝyen nanjire Alaye fǝledi, nanjire duwon kambǝrseyen isi ye, kambǝrsero simojiyi yedǝ, kitawulan ruwuwadadǝ gai: «Kam jiremadǝ kambǝrseyen roa dǝgai.» ");
INSERT INTO kby_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Gǝrgadu Alaye samen kǝla awo nanmuminne gǝni so, jirenambu so samma am jirenambulan jiredǝa gǝrajaidǝyen fǝledi, ");
INSERT INTO kby_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","dalilnjudǝ awo kǝla Alayen nodidǝ tayiro farak, Ala tayiro isanojǝgǝna. ");
INSERT INTO kby_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tǝn dunia alaktǝnayen awowa Alaye taruiwawodǝ nowada, awo alaktǝnadǝyeman federo tarui nangaro, tayima kǝnduwonju sawisoye-a naptunju Alaye-a wo. Adǝgaima amdǝye dalilnja Alaa nodunambuye bawo, ");
INSERT INTO kby_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","dalilnjudǝ Alaa nojana yaye, tiro daraja cadǝnni bi tia wusejanni, amma hangalnja ye bowuro walje karwunja hangal bawoadǝ ye duwuaro waljǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Hangal kǝjiaro kǝlanjaa ngoyera, amma joɍiyaro waljane ");
INSERT INTO kby_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","daraja Ala tǝmmaro nuiwawoyedǝa gumkiya adamgǝna so, ngudowa so, lǝmanna si dewua so, nganjin gǝrdawu soye camunolan falyera. ");
INSERT INTO kby_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Adǝ nangaro mangar diwi karwunjayen Ala tayia curo tayirnambuyen kolje tiyinjan faidadane awo nangua kattenjan kedo. ");
INSERT INTO kby_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Jire Alayedǝa kattuwulan faljane Alaktuma yayero awo alaktǝnaro ambǝccagane sujada keddo. Ala Alaktumadǝmaro har abadaro njungoro tio! Amin. ");
INSERT INTO kby_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Adǝmaro Ala tayia curo jarawa nanguayen kolyeno. Kamuwanja kǝndo kalkaldǝa awo kalkal gǝnilan falyera, ");
INSERT INTO kby_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","koro jiɍi adǝgainin kongwawa ye kamuwa-a kǝndo kalkal koljane mǝradu kamanjaye jauro cadane katte kongwawayen awo nangua cade ajawu jawallan luwonjaye wajipcǝnadǝ kǝlanjaro kikkuro. ");
INSERT INTO kby_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Alaa nodudǝa awo ngǝlaro ngoduro wajana nangaro, Ala tayia hangal yeskadaro awo jussǝnni cadoro kolyeyeno. ");
INSERT INTO kby_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Karwunjadǝ jirenambu so, nankǝlado so, mangar diwi so, niadiwi so samma yen cǝmbǝɍǝna, mandǝna so, kam njejo so, lawala so, curoyindi so, awo diwi diwi so yen rapkada. Tayi tarwawu, ");
INSERT INTO kby_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ngadarwu, kǝladowa Alaye, am jau, rokurawu, kǝla fǝleduwu, diwi dioro masku, amwurawanjaa ganambuwu, ");
INSERT INTO kby_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","hangalnja bawo, nan'adal so, kǝrawo so, kanjimaɍi so ye bawo. ");
INSERT INTO kby_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Shara Alaye duwon am kǝndo aniso gai cadimadǝro wowom karmoye wajipcǝgǝnadǝa dam nojana yaye, tayi runjua gǝni cadi, koro am cadidǝ yea ardijai. ");
INSERT INTO kby_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Adǝ nangaro, ni duwon ambo shara yiddǝmidǝ, wunduro walyem yaye, dalilnǝm adǝa dioye falma bawo, dalilnjudǝ ni am gadero shara yiddǝmiya, kǝlanǝm sharanǝmi, awo cadidǝmaa dimidǝro. ");
INSERT INTO kby_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Shara Alaye kǝla am kǝndo ania cadimadǝyedǝ jirero noniyena. ");
INSERT INTO kby_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ni kam, am awo ania cadimadǝro shara yiddǝmi duwon ni ye tayi gai dimidǝ, wowom Alayero kanǝmi wa tǝmanǝm? ");
INSERT INTO kby_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ra, Alaye nanngǝlanju-a afunju-a kanadinju-a tǝrǝmdǝa ruyem? Nanngǝlanjudǝ tuwa dioro simonjiyidǝa nonǝmmi wa? ");
INSERT INTO kby_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kǝlakibbunǝm-a tuwanambu karwunǝmbe-a nangaro yim gǝrgadu Alaye-a sharanju jireye fǝledidǝ-aro ajawu jau fit kǝlanǝmbo capkǝgǝmi. ");
INSERT INTO kby_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ala wundu yayero kǝla kǝndonjuyen kalkallo ci: ");
INSERT INTO kby_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Am duwon kǝndo ngǝla diolan neccane daraja-a bǝrsǝm-a ro njǝpciwawodǝ-aa majaimadǝro ro sawisoye ci, ");
INSERT INTO kby_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","amma am duwon kǝla rawon jiredǝa wajane jirenambu jagaimadǝro gǝrgadu-a karwujau-a fǝlejiyi. ");
INSERT INTO kby_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Wundu duwon awo diwi diomadǝ, basari-a bone-a tia cawandi, burwon yaudia, daji yaudi gǝni yea cawandi, ");
INSERT INTO kby_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","amma daraja-a bǝrsǝm-a nanlewa-a ti ngǝla diomadǝa cawandi, burwon yaudia, daji yaudi gǝni yea cawandi. ");
INSERT INTO kby_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nonowo, Ala amba gayirjiwawo. ");
INSERT INTO kby_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Am samma Attauraa nojannin biwu cadimadǝ Attaura bawolan sanui, koro am samma fǝrdu kǝnduwo Attaurayen duwon biwu cadimadǝ, Attauralan tayia sharajai. ");
INSERT INTO kby_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Attauraa kǝrǝndumaso fuwu Alayen jirewu gǝni, amma Attauraa gamasoma jirewuro waljai wo. ");
INSERT INTO kby_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Awoa kǝrdiya Attaura cadanni duwon halnja tayia simojiye awo Attauraye amarjǝnadǝa cadiya, cadanni yaye, awo cadidǝ naptu wadanjayero walji. ");
INSERT INTO kby_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Naptunjayen awo Attaura amarjǝnadǝ karwunjan ruwuwadaro fǝlejai, halnja ye ngai shedaji, koro karwunja sa laan tayia saɍiwuji, sa laa yen jirewuro asujiyi. ");
INSERT INTO kby_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Kǝla kawuɍi kǝji mawonǝkkidǝyen yim duwon Ala Isa Almasiwuyen asǝr ambea sharajidǝn awo ani wakkajai. ");
INSERT INTO kby_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","To, ni kǝlanǝmbo yaudi nǝmidǝ, Attauraro njuttǝgǝmi, Alalan awulo bumi, ");
INSERT INTO kby_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","rawo Alayedǝa nonǝmma, Attauradǝa kǝranǝmma nangaro awo ngǝladǝa gayirnǝmi, ");
INSERT INTO kby_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","nima tabbatto kambuwaye jeduma woro nonǝmma, nima koro am curo duwuyen dasaanaro nur kudoma, ");
INSERT INTO kby_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","am hangal bawoaye alamduma, yallaye malǝm woro nonǝmma, ni Attauralan ilmu-a jire-a sammaa kalkallo tammadǝ, ");
INSERT INTO kby_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","to, am gadero yikkǝrami duwon, kǝlanǝmbo yikkǝrambawo wa? Ni duwon bare nambarwu cadǝnni wullǝmidǝ, nambarwu dimbawo wa? ");
INSERT INTO kby_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ni duwon bare kǝnjǝna cadǝnni nǝmidǝ, kǝnjǝna dimbawo wa? Ni duwon gumkiyaa haramgadaro ngonǝmidǝ, kare fadowa sǝnǝmbe ndallǝmbawo wa? ");
INSERT INTO kby_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ni kǝla Attaurayen awulo bumidǝ, ganambunǝmlan Alaro daraja njo wanǝmi. ");
INSERT INTO kby_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kitawulan ruwuwadadǝ gai: «Nayi nangaro kǝrdiya cu Alayedǝa bassai.» ");
INSERT INTO kby_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Wada Attauraye gamia, kajadǝ faidaa, amma Attauraa ganambumaro wallǝmia, kajanǝmdǝ kajanamburo waljǝna. ");
INSERT INTO kby_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ngaima jǝmbǝlǝm wada Attauraye jǝgaia, kajanambunju kajaro ngojaiwawo wa? ");
INSERT INTO kby_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Koro kam tiyilan jǝmbǝlǝm duwon awo Attauraye amarjǝnadǝa cǝdidǝ nia sharanji, ni kitawu so, kaja so tamma duwon Attauraa ganambumadǝ. ");
INSERT INTO kby_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yaudidǝ kam deyan yaudiro fǝlediyi gǝni, koro kaja jireyedǝ awo tiyiye turui gǝni, ");
INSERT INTO kby_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","amma yaudidǝ kam curon yaudi wo, koro kajadǝ ye awo karwuye wo, arawuyen gǝni, Ruhu Alayen kadio. Njungoronju na amben gǝni, na Alayen wo. ");
INSERT INTO kby_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Adǝ nangaro naptu yaudiyedǝ awi faidanju wo? Awi kajadǝye riwanju wo? ");
INSERT INTO kby_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Jiɍi fin yaye ngǝwu mbeji. Kuranjudǝ, mukko yaudiyadǝyero kawuɍi Alaye casakkǝna. ");
INSERT INTO kby_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","To, nda? Laanja kasaccannia, kasattunambunjadǝ aman Alaye baworo cǝdi wa? ");
INSERT INTO kby_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","A'a, tǝmmaro ngai gǝni! Kam fi yaye kattuwumaro walji yaye, Aladǝ jirema dǝgai, kitawulan ruwuwadadǝ gai: «Mananǝmlan jiremaro nonjai ye, sharanjaiya, kǝnnasar fandǝmi ye.» ");
INSERT INTO kby_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Amma jirenambundedǝ nanjire Alaye fǝlejia, awi wulliye? Ala ajawu gǝnaduwumadǝ jirenambuma wa? Kǝla mana kamben manayekko. ");
INSERT INTO kby_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","A'a, tǝmmaro ngai gǝni! Adǝ gǝnia, ndayin gǝle Ala am duniayea sharaji? ");
INSERT INTO kby_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kattuwunilan jire Alaye ngǝwuro tǝrgane Alaro daraja cadia, awiro gǝle koro yaye wua biwumaro sharasai? ");
INSERT INTO kby_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Koro awiro gǝle har ngai wuldiwawodǝ: Nda diwi diyo, ngǝla isoro? Am laa manande cadi adǝmaa yikkǝraiye cani. Tayidǝ, wowomnja jussǝna! ");
INSERT INTO kby_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Awi gǝle? Andi yaudiyadǝ am gadero wa ngalwo? A'a, tǝmmaro ngai gǝni! Yaudiya-a kǝrdiya-a samma fǝrdu kǝnduwo biwuyen dasaanaro calan fǝleniyena. ");
INSERT INTO kby_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kitawulan ruwuwadadǝ gai: «Jirema bawo, falma bawo, ");
INSERT INTO kby_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kam asujǝna bawo, Alaa madama bawo. ");
INSERT INTO kby_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Tayi samma jawal koljana, kǝla tilonna faida baworo waljana, kam ngǝla dioma bawo, falma bawo. ");
INSERT INTO kby_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ngowoljonja kauri kaada gai, tǝlamnjan amba jambajai. Fǝrdu ka cinjayen dawi fusiyea. ");
INSERT INTO kby_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Cinja baskudu-a manakuttu-an cǝmbǝɍǝna. ");
INSERT INTO kby_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Sinja kam njejoro doi, ");
INSERT INTO kby_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","jawalnjan masiwa-a kudǝra-aa, ");
INSERT INTO kby_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","koro jawal nanlewaye nojanni. ");
INSERT INTO kby_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Adǝgaima Ala rida karwunjan bawo.» ");
INSERT INTO kby_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Awi yaye Attaura wuljidǝ, am fǝrdu kǝnduwo Attaurayen dasaanaro wuljiyiro noniyena, ngainin ci wunduye yaye gǝm cǝdo, dunia sammaa shara Alayero caado. ");
INSERT INTO kby_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ai, nodu biwuyedǝ Attaurayen isi, adǝ nangaro wunduma wada Attauraye galan fuwu Alayen jiremaro waljiwawo. ");
INSERT INTO kby_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Amma kǝrmadǝ nanjire Alaye wada Attauraye galan gǝni tuwandi, Attaura-a kitawuwa nawiyaye-a tia shedajana. ");
INSERT INTO kby_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nanjire Alayedǝ Isa Almasiwuye mǝrsaduyen am kasattuwu sammaro isi, gayirdu bawo. ");
INSERT INTO kby_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Tayi samma biwu cadǝna ye, daraja Alaye najaganni ye, ");
INSERT INTO kby_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","amma merudu Isa Almasiwulan tuwandidǝyen dero sernjulan jirewuro waljai. ");
INSERT INTO kby_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ala nanjirenju fǝlejoro, Almasiwua laya fastu gǝrgadunjuyero kaino, koro ngainin tia bunjuyen kambǝrselan kasaccane jirewuro waljai. Awoa Ala afunju nangaro biwuwa kureye wowomjǝnni. ");
INSERT INTO kby_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Adǝa dionjudǝ, jaman kǝrmayen nanjirenju fǝlejoro, ngainin Aladǝma jire ye, kam Isaa kasattumadǝa jiremaro cǝdima ye wo. ");
INSERT INTO kby_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nda gǝle awulo bodǝ? Bawo! Kǝla wada jiɍi fiyen? Kǝla wada kidayen? A'a, kǝla wada kambǝrseyen. ");
INSERT INTO kby_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nonowo, kam wada galan gǝni, kambǝrselan jiremaro waljiro tabbatkeyeiye. ");
INSERT INTO kby_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ra, Aladǝ Ala yaudiya runjaye wa? Kǝrdiyaye ye, gǝna? Aaa, kǝrdiyaye ye, ");
INSERT INTO kby_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Aladǝ falma nangaro, ti duwon am kajaadaa kambǝrseyen jirewuro cǝdi, koro jǝmbǝlǝmba yea kambǝrseyen jirewuro cǝdidǝ. ");
INSERT INTO kby_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Adǝ nangaro kǝla kambǝrseyen Attauradǝa baworo diye wa? A'a, tǝmmaro ngai gǝni! Attauradǝa tabbatkeyeiye. ");
INSERT INTO kby_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","To, kaarinde Nawi Ibrahimdǝ, awi gǝle wulliye? Naptunju adamgǝnayen, kǝla kambǝrseyen awi asujo? ");
INSERT INTO kby_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ca Nawi Ibrahim kida diolan jiremaro walyenoa, dalil awulo boye cǝdana, amma fuwu Alayen gǝni. ");
INSERT INTO kby_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","To, awi kitawu wuljo? «Nawi Ibrahim Alaa mǝrsajǝna nangaro, Ala tia jiremaro ngoyeno.» ");
INSERT INTO kby_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kam kida cǝdidǝro biyanjudǝ kǝnjo gǝni, alwasi. ");
INSERT INTO kby_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Adǝ yaye kam duwon kida cǝdiwawo, amma Ala am diwia jirewuro diomaa mǝrsajidǝ, kambǝrsenju nangaro tia jiremaro ngoji. ");
INSERT INTO kby_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nawi Dauda ye kam duwon Ala tia kidanju gǝni nangaro jiremaro ngojidǝye barganju wuljǝnadǝ gai: ");
INSERT INTO kby_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Barganja am ayauwanja ye gawurdǝna, biwuwanja ye jakkadadǝ. ");
INSERT INTO kby_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Barganju kam Kǝmande tiro biwunju tǝmmaro gǝnajiyiwawodǝ.» ");
INSERT INTO kby_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Barga adǝ am kajaada runjayema wa? Ra, jǝmbǝlǝmba ye cawandi? Kambǝrse Nawi Ibrahimbe nangaro Ala tia jiremaro ngojǝnaro wulliye. ");
INSERT INTO kby_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Dǝlwu filan tia jiremaro ngoyera? Kajanjualan ra jǝmbǝlǝmlan? Sa ti kajaadalan gǝni, jǝmbǝlǝmdǝlaman. ");
INSERT INTO kby_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kajadǝa alama gairo kiwando, alama duwon sa kajadǝnnin kambǝrsenju nangaro nanjire cuwandǝnadǝa tabbacciyidǝ. Ngainin Nawi Ibrahim bawa am kambǝrsea jǝmbǝlǝm dasaana sammayero walyeno, tayi yea kambǝrsenja nangaro jirewuro ngojaro. ");
INSERT INTO kby_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Koro bawa am kajaadaye yero walyeno, tayi duwon kajaada runju gǝni, jawal kambǝrseye bawande Nawi Ibrahim sa jǝmbǝlǝmlan jǝganadǝ yea jagaidǝ. ");
INSERT INTO kby_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ala Nawi Ibrahim-a kaduwunju-aro warasama duniayero walji cǝne wadu ngoyeno, wadu duwon wada Attauraye galan gǝni, nanjire kambǝrselan isidǝyen tiro cinadǝ. ");
INSERT INTO kby_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ca wada galan amso warasawuro walyeraa, kambǝrsedǝ ye bowu fat, wadudǝ ye faidanju baworo waljǝna, ");
INSERT INTO kby_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","wadadǝ gǝrgadu Alaye cuwudi nangaro. Na wada bawolan wada ganambu ye bawo. ");
INSERT INTO kby_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Adǝma nangaro wadudǝ awo kambǝrseye wo. Dalil wadu serlan isidǝ, tima kaduwu sammaro tabbaccuworo, kam wada jǝganama runjuro gǝni, kam kambǝrse Nawi Ibrahimbea jǝganama yero, ti duwon bawa andi sammayedǝ. ");
INSERT INTO kby_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kitawulan ruwuwadadǝ gai: «Nia bawa jama kada kadamiyero ngidǝkko.» Tidǝ Alaa kasaccǝna, Ala duwon am sanunaro ro cakke awo bawoa mennaro cǝdidǝ. ");
INSERT INTO kby_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Tǝma bawo yaye, Nawi Ibrahim tǝmaje Alaa mǝrsaje ngainin bawa jama kadayero walyeno, Alaye tiro: «Kaduwunǝm ngǝwujai,» cǝnnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ti kǝrwunju mia gai duwon, kiarijǝna ye, koro Saratu ye cambiwaworo curuna yaye, kambǝrsenju duno baworo waljǝnni. ");
INSERT INTO kby_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Wadu Alaye shekku bawoalan kasacce kambǝrsenjulan dunoaro walyeno, koro Alaro daraja kaino, ");
INSERT INTO kby_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","awo Ala cǝdi cǝnnadǝa cǝdiro tabbatto mǝrsajǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ngainin kambǝrsenju nangaro Ala tia jiremaro ngoyeno. ");
INSERT INTO kby_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Mana ruwuwada adǝ: «Tia jiremaro ngoyeno,» ti runjuro gǝni, ");
INSERT INTO kby_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","andi yero ruwuwaada. Ala andi yea jirewuro ngosai, ti duwon Kǝmande Isaa karmolan cǝsangǝnadǝa mǝrsaniyena nangaro. ");
INSERT INTO kby_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Isadǝa biwuwande nangaro sǝrǝccagane kano, koro jirewuro walliyoro karmolan ciyeno. ");
INSERT INTO kby_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Adǝ nangaro, kambǝrselan jirewuro walliyenadǝ, Kǝmande Isa Almasiwuyen katte andi-a Ala-ayen naptu nanlewayea. ");
INSERT INTO kby_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Isa nangaro jawal kambǝrseyen ser curonjun dǝgaiyena adǝro ngawo fandiyena, koro karwunde curo tǝma daraja Alayen kǝjijǝna. ");
INSERT INTO kby_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Koro adǝa kojǝnaro curo boneyeman karwunde kǝjijǝna, bonedǝ kanadi cuwudiro noniyenadǝro. ");
INSERT INTO kby_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Kanadidǝ ye hal ngǝla cuwudi, koro hal ngǝladǝ ye tǝma cuwudi. ");
INSERT INTO kby_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Tǝmadǝ tiyisam cuwudiwawo, Ala karwundero Ruhunju sadǝnayen kǝrawonju cakkǝnadǝro. ");
INSERT INTO kby_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Awima rangiyena bawoalan Almasiwu am Alaa ga wajana nangaro sa kalkalnin kano. ");
INSERT INTO kby_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kiaddin kam laa kam jirema nangaro ronju ci, waneye kam laa kam ngǝla nangaro rakce ronju ci. ");
INSERT INTO kby_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Amma Ala andiro kǝrawonju ngainin fǝlesagai: Andi biwuwu duwon, Almasiwu andi nangaro kano. ");
INSERT INTO kby_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","To, andi kǝrma bunjuyen jirewuro walliyenadǝro, adǝa kojǝnaro tiyen gǝrgadu Alayero kaniye. ");
INSERT INTO kby_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sa andi kǝladowadǝn karmo Tada Alayen Ala-a solodiyenaa, adǝa kojǝnaro solodiyenadǝ ronjuyen njǝkkawo fandiye. ");
INSERT INTO kby_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Koro adǝ runju gǝni, Kǝmande Isa Almasiwuyen na Alayen karwunde kǝjijǝna, tiyen kǝrma solo fandiyenadǝ. ");
INSERT INTO kby_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Adǝ nangaro, jiɍi kam fallen biwu duniaro ngaye biwuyen karmo ngaanadǝ gai, ngainin karmodǝ am sammaro tatargaada, tayi samma biwu cadǝnadǝro. ");
INSERT INTO kby_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kawu Ala Attaura ciro, dunialan biwu mbeji, amma sa Attaura bawodǝn wowom gǝnadiyiwawo. ");
INSERT INTO kby_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Adǝ yaye jaman Nawi Adamben tai Nawi Musayero kudero karmodǝ kǝla am sammayen kǝrga, har am biwuwa yestu Nawi Adambe-a camun cadǝnnidǝmaa lejǝna. Nawi Adamdǝ camuno ti fuwun kǝndemadǝye. ");
INSERT INTO kby_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Amma kǝnjodǝ ayaudǝ-a camun gǝni. Ayau kam faldǝye nangaro am ngǝwu kasunoa, adǝa kojǝnaro ser Alaye-a kǝnjo ser Isa Almasiwu kam faldǝye-a am ngǝwuro tasargaana. ");
INSERT INTO kby_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Koro kǝnjodǝ awo ayau kam faldǝye cuwudǝnadǝ-a camun gǝni. Awoa shara ayau fal jǝganadǝ wowom kiwudo, amma kǝnjo ayau kadaa jǝganadǝ nanjire kiwudo. ");
INSERT INTO kby_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kam fal nangaro kǝla ayau kam faldǝyen karmo kǝla am sammayen kǝrmai cunodi, adǝa kojǝnaro am ser ngǝwu-a kǝnjo nanjireye-a camoyimasodǝ Isa Almasiwu wotte kam faldǝyen roa dasaane kǝrmai canodi. ");
INSERT INTO kby_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Adǝ nangaro, jiɍi ayau kam falle am sammaro wowom cuwudidǝ gai, ngainin kǝndo nanjireye kam falle am sammaro jiremaro waldu-a ro-a cuwudi. ");
INSERT INTO kby_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Awoa ganambu kam fallen am ngǝwu biwuwuro waljanadǝ gai, ngainin ga kam fallen am ngǝwu jirewuro waljai. ");
INSERT INTO kby_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Koro ayaudǝ ngǝwujoro Attaura kadio, amma na biwu ngǝwujǝnadǝn, ser Alaye tia jauro kojiro ngǝwuyeno. ");
INSERT INTO kby_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ngainin jiɍi biwudǝ karmolan kǝrmai cunodǝnadǝ gai, ngaiman ser Alaye nanjireyen kǝrmai cunode ro sawisoye Kǝmande Isa Almasiwuyen cuwudi. ");
INSERT INTO kby_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","To, awi gǝle wulliye? Ser Alaye ngǝwujoro curo biwuyen wa dǝgaiye? ");
INSERT INTO kby_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","A'a, tǝmmaro ngai gǝni! Andi biwuro nuiyenadǝ, jiɍi fin gǝle curodǝn koro dǝgaiye? ");
INSERT INTO kby_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Wundunde yayero kasala sadde Isa Almasiwuro kǝlsaanadǝ, karmonjuro kǝlsaanaro nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Adǝ nangaro, kasala karmonjuro kǝlsaanadǝlan ti-a rokko sittǝrasanadǝ, ngainin jiɍi Almasiwudǝ daraja Bawadǝyen karmolan cijǝnadǝ gai, andi ye kǝndǝgai bǝɍin diye. ");
INSERT INTO kby_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Karmonju-a camunno tiro kǝldiyiyenadǝ, tabbatto karmolan cidunju-a camunno tiro kǝldiyiye. ");
INSERT INTO kby_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Halnde caye dǝgaiyenadǝa ti-a rokko kǝskaro jajaanaro noniyena, duno biwuyedǝ baworo waljo, bare gadero kaɍea biwuyero walliyendero. ");
INSERT INTO kby_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kam nunadǝ biwu-a firdane nankam kǝlaye cuwandǝna. ");
INSERT INTO kby_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Almasiwu-a kallo nuiyenadǝ, ti-a kallo roa dǝgaiyero mǝrsaniyena, ");
INSERT INTO kby_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","koro Almasiwu karmolan cijǝna nangaro, gadero nuiwaworo noniyena. Kǝnduwo karmoyedǝ kǝlanjun bawo. ");
INSERT INTO kby_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nonjudǝ, tilo lonno biwua baworo dioro kano, amma ronjuadǝ, Alaro daraja njoro roa dǝgai. ");
INSERT INTO kby_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Jiɍi adǝgainin nayi ye nuwe kǝnduwo biwuye kǝlandon baworo waljǝna ye, koro Isa Almasiwulan roa dǝgawe Alaro daraja yiwi yero kǝlandoa ngonowo. ");
INSERT INTO kby_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Adǝma nangaro bare biwu kǝla tiyindo nomayen kǝrmai cunode mangarnjua gawwi. ");
INSERT INTO kby_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Bare tiyindo kare kida jirenambu dioye gai mukko biwuyero yakkuwwi, amma karmolan roa cinuwwadǝ, kǝlandoa Alaro yowo, tiyindo ye kare kida nanjire dioye gai Alaro yowo. ");
INSERT INTO kby_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kǝnduwo biwuyedǝ gadero kǝlandon bawo, nayidǝ fǝrdu wadayen gǝni, fǝrdu ser Alayen dǝgawi nangaro. ");
INSERT INTO kby_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To, awi gǝle? Andi fǝrdu kǝnduwo wadayen gǝni, fǝrdu ser Alayen dǝgaiyenadǝ, koro yaye biwu diye wa? A'a, tǝmmaro ngai gǝni! ");
INSERT INTO kby_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Kamba garo tiro kaɍea gai kǝlando kewwa, ti gawidǝye kaɍeawaro walluwiro nonuwwi wa? Biwu gadǝ karmoro cadi, koro Alaa gadǝ nanjire cuwudi. ");
INSERT INTO kby_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Amma Alaa wuseniyo! Nayi calan kaɍeawa biwuyedǝ kǝrma karwundo samman alamdu jiɍi njasakkǝranadǝa gawe ");
INSERT INTO kby_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","biwu-a firduwe nankam kǝlaye fanduwe kaɍeawa nanjireyero walluwwa. ");
INSERT INTO kby_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Naptundo adamgǝnaye nangaro mana kamben manayekko. Jiɍi calan tiyindo tayirnambu so, nandiwi soro kaɍea gai kǝlando yiwe na kojǝnaro nandiwiro cadǝnadǝ gai, adǝgainin kǝrma kaɍea gai tiyindo nanjirero yowo tayirro walloworo. ");
INSERT INTO kby_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Sa nayi kaɍeawa biwuyedǝn, nayi fǝrdu kǝnduwo nanjireyen bawo. ");
INSERT INTO kby_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Awowa duwon kǝrma tayia nangunuwidǝ, sadǝn awi faidanja wo? Awoa awo aniye leduwuramnja karmo. ");
INSERT INTO kby_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Amma kǝrma biwu-a firduwe nankam kǝlaye fanduwe kaɍeawa Alayero walluwwadǝ, faidanjudǝ tima nantayir wo, leduwuramnju ye ro sawisoye. ");
INSERT INTO kby_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Awoa alwasi biwuyedǝ karmo, amma kǝnjo Alayedǝ Kǝmande Isa Almasiwuyen ro sawisoye. ");
INSERT INTO kby_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Kǝramiya, nayi Attaura nonuwwasoro wulnjagakki, kam ronjualan, kǝnduwo wadayedǝ kǝlanjun mennaro nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Misallo kamu kwaadǝ tiro wadalan kǝllaada kwadǝ ronjuamaa. Amma kwadǝ kanoa, wadadǝ kǝlanjun bawo. ");
INSERT INTO kby_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Adǝ nangaro kwadǝ ronjua duwon kwa gade kidoa, tia kǝnjǝnamaro ngojai. Amma kwanju kanoa, wada adǝ kǝlanjun bawo, kwa gade kido yaye, ti kǝnjǝnama gǝni. ");
INSERT INTO kby_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Kǝramiyani, jiɍi adǝgainin nayi ye tiyi Almasiwuyen wadaro nuwwa, ngainin kam gadeyero walluwi, ti karmolan cijǝnadǝyero, koro nema Alaro yakkiye. ");
INSERT INTO kby_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Sa hal tiyiyelan dǝgaiyenadǝn, jarawande biwuye wada cǝsangǝnadǝ tiyindea cakke nema karmoye kekkiye. ");
INSERT INTO kby_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Amma awo calan rosanadǝ-a firdiye nuiyena nangaro, kǝrma wadadǝ kǝlanden bawo, ngainin jawal caye wada ruwuwadayen gǝni, jawal bǝɍin Ruhuyen wolodiya Alayero walliye. ");
INSERT INTO kby_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","To, awi gǝle wulliye? Wada Attaurayedǝ biwu wa? A'a, tǝmmaro ngai gǝni! Wadayen gǝnia, biwu nokkiwawo. Misallo ca wadaye: «Bare mangar dimmi,» cǝnnia, mangardǝa asukkǝni. ");
INSERT INTO kby_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Amma biwudǝ wadayen dama kiwandǝnniya, mangar jiɍi jiɍi karwuniro kekko, wada bawonin biwu nuna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Calan sa wada bawolan ronia kǝrgakko, amma wadadǝ kadinniya, biwudǝ roaro walje wudǝ kanukko. ");
INSERT INTO kby_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Wada ro kudomadǝ wuro karmo sukkudo. ");
INSERT INTO kby_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Biwudǝ wadayen dama cuwande wua jambase wadadǝyen roro seso. ");
INSERT INTO kby_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Adǝgaima Attauradǝ tayir, koro wadanjudǝ tayir ye, jire ye, ngǝla ye. ");
INSERT INTO kby_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","To, awo ngǝla adǝ wuro karmo wa sukkudo? A'a, tǝmmaro ngai gǝni! Biwudǝma biwuro fǝledoro awo ngǝladǝyen kidanju karmoye wulan cǝdo, wadadǝyen biwudǝ na kojǝnaro biwuro waljoro. ");
INSERT INTO kby_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Wadadǝ awo Ruhuyero noniyena, amma wudǝ awo tiyiye, kaɍea fǝrdu biwuye gai saladǝna. ");
INSERT INTO kby_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Kǝndonidǝmaa asunǝkkiwawo. Awoa awo raakkǝnadǝa gǝni, awo wakkǝnadǝmaa dikki. ");
INSERT INTO kby_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Awo wakkǝnadǝa dikkia, wadadǝ awo ngǝlaro ardinǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ngaima kǝrma wu gǝni, biwu wulan dǝganamadǝ awo ania cǝdi. ");
INSERT INTO kby_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Wulan, wotte naptuni adamgǝnayelan, awo ngǝla fima dǝganniro nokkǝna. Akko nia awo ngǝla dioye nanin mbeji, amma duno tia dioye bawo. ");
INSERT INTO kby_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ngǝla raakkǝnadǝa dikkiwawo, amma diwi wakkǝnadǝ tima awo dikkidǝ wo. ");
INSERT INTO kby_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Awo wakkǝnadǝa dikkia, kǝrma wu gǝni dikki, amma biwu wulan dǝganamadǝ cǝdi. ");
INSERT INTO kby_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Adǝ nangaro wada adǝa wulan fandǝkki: Awo ngǝla dio raakkǝna duwon, diwi ye nanin mbeji. ");
INSERT INTO kby_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Karwunin wada Alaye tai dakke raakkǝna, ");
INSERT INTO kby_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","amma wada laa gade tiyinin rukki. Wada adǝ wada hangalniyero kǝriwu cǝkkade wua kosoma wada biwuye tiyinin dǝganadǝye sǝddi. ");
INSERT INTO kby_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kuttuni, awo njunoduye wu! Wundu gǝle wua tiyi karmoye adǝlan sǝmoyi wo? ");
INSERT INTO kby_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Kǝmande Isa Almasiwuyen Alaa wuseniyo! Ai, hangalnin wada Alaye gakki, amma naptuni adamgǝnayelan wada biwuye gakki. ");
INSERT INTO kby_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Adǝ nangaro kǝrma am Isa Almasiwua gawudǝro wowom fima bawo, ");
INSERT INTO kby_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","dalilnjudǝ wada Ruhuye duwon Isa Almasiwuyen ro njomadǝ wu-a wada biwuye-a karmoye-a firsane nankam kǝlaye sina nangaro. ");
INSERT INTO kby_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Awo duwon wada naptu adamgǝnaye nangaro lawu rakce cǝdǝnnidǝa Ala kido. Biwu nangaro Tadanjua alama tiyinde biwumaye gainin juwajiye tiyilan biwudǝro wowom gǝnayeyeno. ");
INSERT INTO kby_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Adǝa dionjudǝ, nanjire wada wuljǝnadǝ andi duwon naptu tiyiyen gǝni, Ruhuyen dǝgaiyenadǝlan tǝdo. ");
INSERT INTO kby_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Am duwon hal tiyiyen dasaanamadǝ hangalnja kǝla awo tiyiyen kǝrga, amma am duwon hal Ruhuyen dasaanamadǝ hangalnja kǝla awo Ruhuyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Hal tiyiyedǝ karmo, amma hal Ruhuyedǝ ro-a nanlewa-a. ");
INSERT INTO kby_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Awoa hal tiyiyedǝ kǝlado Alaye, dalilnjudǝ wada Alaye jǝgaiwawo, tǝmmaro rakce jǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Am hal tiyiyea gawudǝ rakcane ardiya Alaye cawandiwawo. ");
INSERT INTO kby_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Amma nayidǝ hal tiyiyen gǝni, Ruhuyen kǝrgaw, Ruhu Alaye nayilan dǝgana nangaro. Kam duwon Ruhu Almasiwuye tilan dǝgannidǝ, tidǝ Almasiwuye gǝni. ");
INSERT INTO kby_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Almasiwudǝ nayilan kǝrgaa, tiyidǝ biwu nangaro nuna, amma Ruhudǝ nanjire nangaro ro ci. ");
INSERT INTO kby_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Koro ti Isaa karmolan cǝsangǝnadǝye Ruhunju nayilan kǝrgaa, daji ti Almasiwua karmolan cǝsangǝnadǝ Ruhunju nayin dǝganadǝyen tiyindo nomadǝ yero ro cakki. ");
INSERT INTO kby_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Kǝramiya, adǝma nangaro wajipnde mbeji, amma hal tiyiyen dǝgaro gǝni, ");
INSERT INTO kby_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","awoa hal tiyiyen dǝgawwaa, nuwi, amma Ruhudǝyen kǝndo tiyiyedǝa yejuwwaa, roa dǝgawi. ");
INSERT INTO kby_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Am duwon Ruhu Alaye tayia simojimadǝ tayima tadawa Alayedǝ wo. ");
INSERT INTO kby_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ruhu fanduwwadǝ nayia kaɍeawaro gǝni ngedo har walduwe rinuwidǝ, amma Ruhu nayia tadawa Alayero diomadǝa fanduwwa, tilan kowo sammiye: «Abba, Bawa!» niye. ");
INSERT INTO kby_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruhu Alaye kǝlanjudǝ karwunde-a rokko andi tadawa Alaye woro shedaji, ");
INSERT INTO kby_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","koro andi tadawadǝro, andi ye warasawu, warasawu Alaye ye, wotte Almasiwu-a rokko warasawu. Ti-a kallo bone kiaiyea, ti-a kallo ye daraja fandiye. ");
INSERT INTO kby_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Wuyenna bone jaman kǝrmayedǝ martawa daraja andiro fuwun fǝlediyidǝyea najiyiwawo. ");
INSERT INTO kby_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Awowa alaktǝna samma fǝledu tadawa Alayea gangadaaro gurejai. ");
INSERT INTO kby_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Awo alakkadadǝ faida baworo kalaktǝna, amma rawonjun gǝni, Ala duwon tia kalakcǝnadǝ nangaro. Alaye rawonjudǝ tima ");
INSERT INTO kby_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","awo alakkada kǝlanjudǝ nankaɍea njǝptuye-a firdane nankam kǝlaye darajaa tadawa Alayedǝyen nuwanju ye cuwandi. ");
INSERT INTO kby_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kua yaye awo alakkada samma kǝla tilonna njǝmje bone kǝnjambiye cairo noniyena. ");
INSERT INTO kby_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Awo alakkada runju gǝni, andi duwon Ruhu Alaye nema burwoyero fandiyenadǝ, andi ye karwunden njǝmmiye tadawa Alayero waldunde, wotte tiyindea merududǝa gangadaaro gureniye. ");
INSERT INTO kby_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Tǝma taiyena adǝlan njǝkkawo fandiyena, awoa tǝma turuidǝ tǝma gǝni. Wundu gǝle awo curuidǝa tǝmaji? ");
INSERT INTO kby_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Amma awo ruiyewawodǝa tǝmaniyenaa, neddiye kanadilan tia gureniye. ");
INSERT INTO kby_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Koro ngaiman Ruhudǝ dawu nanlawundeyen banasagai, jiɍi moduwa ngǝlaro diyedǝa noniyende, amma Ruhudǝ kǝlanju andiro mana wuldiwawolan Alaa sakkori. ");
INSERT INTO kby_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ti awo karwun dǝgana kuromadǝ nia Ruhuye nojǝna, ti Ruhudǝ kǝla awo Ala cǝraanayen muminnaro cukkori. ");
INSERT INTO kby_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Koro Ala am tia caraana ye, kǝla fasalnjuyen bowojǝna yero awi yayea ngǝlaro cǝddiro noniyena. ");
INSERT INTO kby_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Awoa am duwon Ala caman tayia nojǝnadǝ, tayi ye camuno Tadanjuyero waljaro kadarjǝna, ti karu tadawa ngǝwuyero waljoro. ");
INSERT INTO kby_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Tayi kadarjǝnadǝa bowoyeno, koro tayi bowojǝnadǝa jirewuro kido, koro tayi jirewuro cǝdǝnadǝro daraja kaino. ");
INSERT INTO kby_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","To, kǝla awo aniyen awi gǝle wulliye? Aladǝ kaandea, wundu wadumandero walji? ");
INSERT INTO kby_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ti duwon Tadanjudǝmaa koljǝnni andi samma nangaro cinadǝ, ndayin gǝle andiro ti-a kallo awo sammaa serraro sadiwawo? ");
INSERT INTO kby_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Wundu am Ala kǝrejǝnaa ngadarji? Aladǝma tayia jirewuro dioma wo! ");
INSERT INTO kby_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Wundu gǝle ti duwon wowom gǝnajiyidǝ? Isa Almasiwudǝ tima nunadǝ wo, adǝa kojǝnaro tima karmolan cijǝna ye, kǝmboram Alayen andiro Alaa sakkori yedǝ wo. ");
INSERT INTO kby_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Wundu andia kǝrawo Almasiwuye-a firsagai? Bone wa, ra kuttu, ra basari, ra kǝna, ra kajǝmunambu, ra masiwa, ra kashagar wa? ");
INSERT INTO kby_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kitawulan ruwuwadadǝ gai: «Ni nangaro andia dabdu sǝrambo roro seyesi. Dimiya duwarambo njadoye gairo andia ngosana.» ");
INSERT INTO kby_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Amma curo awo ani sammayen ti andia saraanadǝyen kǝnnasarwumaa kojǝnaro walliyena. ");
INSERT INTO kby_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Tabbatto nokkǝna, karmo bi ro, malaiyawa bi kǝrmaiya, lamarra kǝrmaye bi fuwuye, bi kǝnduwowa, ");
INSERT INTO kby_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","awo sameye bi cidiye, bi awo alakkada gade fima rakce andia kǝrawo Alaye Kǝmande Isa Almasiwulan tuwandidǝ-a firsaiwawo. ");
INSERT INTO kby_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Almasiwulan jire wullǝkki, kattuwu gǝni, halni ye Ruhu Alayen shedasi, ");
INSERT INTO kby_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","karwukutta kura-a jǝktu ceriwawo-a curo karwuniyen fakki. ");
INSERT INTO kby_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ca yojia, kǝramiyani jama tilon tambiyena nangaro wu kǝlani baskuwada ye, Almasiwu-a faiyada yero raakko. ");
INSERT INTO kby_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Tayidǝ Israyilawu, koro Ala tayia dapce tadawanjuro cǝde daraja ce aman ndǝpcane Attaura so, kida ambǝttuwuye so tayiro waduwa ngoyeyeno. ");
INSERT INTO kby_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Kaariyadǝ kaanja, Almasiwudǝ ye kǝla naptunju adamgǝnayen tayiyeman kadio, tima Ala sawisoro bargaa same awo fiyen yaye kǝrgadǝ wo! Amin. ");
INSERT INTO kby_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Mana Alaye faida baworo waljǝna wa? A'a. Awoa kaduwu Israyilaye samma gǝni Israyiladǝ wo, ");
INSERT INTO kby_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","koro tadawa Nawi Ibrahimbe samma gǝni kaduwunju wo. Alaye: «Am Isakuyen tasambidǝmaa kaduwunǝmlan bowojai,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Maana adǝyedǝ tima tadawa tiyiye gǝni tadawa Alayedǝ, amma tadawa waduyedǝmaa kaduwuro ngojai wo. ");
INSERT INTO kby_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Akko mana waduyedǝ: «Baɍiminna kua gai isǝkki, Saratu tada cambi.» ");
INSERT INTO kby_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Adǝ runju gǝni, Rabeka ye kam fal kaarinde Nawi Isakuyen curo ngoyenniya, ");
INSERT INTO kby_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","kawu kawuwadǝ tasambe ngǝla bi diwi cadiro, fasal Alaye kadarjǝnadǝ tabbaccuworo, ");
INSERT INTO kby_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Rabekadǝro: «Karudǝ kaɍea kannadǝyero walji,» yeno. Ngaiman fasal Alayedǝ kǝla kidayen gǝni, kǝla ti bowojidǝyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kitawulan ruwuwadadǝ gai: «Yakubaa raakko, Yesawua wayekko.» ");
INSERT INTO kby_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","To, awi gǝle wulliye? Na Alayen jirenambua wa? A'a, tǝmmaro ngai gǝni! ");
INSERT INTO kby_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Tiye Nawi Musaro: «Kam tiro kanjimaɍi fǝlegǝkkidǝro kanjimaɍi fǝlegǝkki, koro kam tia njunokkidǝa njunokki,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Adǝ nangaro rawo bi kowoɍi kamben gǝni, Ala kanjimaɍi fǝlejiyidǝman kǝrga. ");
INSERT INTO kby_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kitawulan Alaye Fira'aunaro: «Dalil nia galanjǝkkǝnadǝ, tima kǝnduwoni nilan fǝlegǝkko, koro cuni dunia ngan culuworo,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Adǝma nangaro kam kǝrejǝnaro kanjimaɍi fǝlejiyi, koro kam kǝrejǝnaye kǝlanju kibbajiyi. ");
INSERT INTO kby_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Daji niye wuro: «To, ngairo walyenoa, awiro kua yaye ayau gǝnajidǝ? Wundu gǝle rakce rawonju wajidǝ?» nǝme suworǝmi. ");
INSERT INTO kby_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Amma ni kam, ni wundu duwon Alaro mana kalakkǝmidǝ? Awo tǝdandǝnadǝye ti tia cǝdandǝnadǝro: «Awiro wua ngai sǝdǝm?» cǝni wa? ");
INSERT INTO kby_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Duwuramma kǝnduwo kǝla tulo kamatkadayen kalwo laa darajaa-a laa ye daraja bawoa-a tandoye cǝdanni wa? ");
INSERT INTO kby_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","To, Ala gǝrgadunju fǝledu-a dunonju isanoduwu-a cǝraye tayi gǝrgadunjuye duwon siduwuro dabbargadadǝa jauro kanadilan mǝrjǝnaa, nda? ");
INSERT INTO kby_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Adǝa dionjudǝ, darajanju tǝrǝm tayi kanjimaɍiye duwon darajaro dabbargadadǝro isanoduwu cǝraanaa, nda? ");
INSERT INTO kby_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Andimaa curo yaudiya runjayen gǝni, curo kǝrdiyayen bowosana, ");
INSERT INTO kby_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","curo kitawu Nawi Hosiyayen wuljǝnadǝ gai: «Tayi duwon jamani gǝnidǝa jamanilan bowokki, ti duwon tǝraannidǝ yea tǝraanalan bowokki.» ");
INSERT INTO kby_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Koro: «Na duwon tayiro: “Nayi jamani gǝni,” wuljanadǝman tayia tadawa Ala Kǝndǝgaimayelan bowojai.» ");
INSERT INTO kby_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nawi Ishayaye kǝla Israyilawuyen kowo sapce: «Tadawa Israyilaye nanngǝwunja cidi kesa ci tekuyea cadǝna yaye, amnjaye ganama njǝkkawo cawandi, ");
INSERT INTO kby_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","tussiwawo Kǝmande dunia ngaro sharanju cotto kamjiyi,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nawi Ishaya calan kawu wakkajidǝro wuljǝnadǝ gai: «Ala Kǝmande Martawama kaduwu laaa kolsaganniro walyenoa, andi bǝrni Sodombe gairo walliye, bǝrni Gomorre-a camuniyena.» ");
INSERT INTO kby_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","To, awi gǝle wulliye? Kǝrdiya nanjire majannimasodǝ nanjire cawandǝna, wotte nanjire kambǝrseyen isidǝ, ");
INSERT INTO kby_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","amma jama Israyilaye wada nanjireye majaidǝa cawandǝnni. ");
INSERT INTO kby_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Awiro? Kambǝrselan gǝni, kida diolan gai tia majana nangaro. Tayidǝ kǝla kau talduyedǝn taljana, ");
INSERT INTO kby_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kitawulan ruwuwadadǝ gai: «Akko Siyonnin kau talduye ye, takkalduma ye gǝnanǝkki, kam tia mǝrsajǝnamadǝ, nangu tia cǝdaiwawo.» ");
INSERT INTO kby_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Kǝramiya, awo jauro karwuni cǝraana ye, moduwa dikki yedǝ, tima Israyilawu njǝkkawo cawando. ");
INSERT INTO kby_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Jaumaro Alaa jagairo tayia shedanǝkki, amma kǝla noduyen gǝni, ");
INSERT INTO kby_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","awoa nanjire Alayedǝa nojannin nanjire kaanja majana, wotte nanjire Alayedǝa kasaccane jaanni, ");
INSERT INTO kby_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","dalilnjudǝ Almasiwudǝ tima leduwuram wadayedǝ wo, wundu duwon kambǝrseadǝ nanjire cuwandoro. ");
INSERT INTO kby_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nawi Musa kǝla nanjire wadalan isidǝyen ngai ruwujǝna: «Kam awo ania cǝdimadǝ tayiyen roa dǝgai.» ");
INSERT INTO kby_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Amma nanjire kambǝrselan isidǝ ngai cǝni: Bare karwunǝmlan: «Wundu samero leji?» wotte Almasiwua saworo, ");
INSERT INTO kby_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","bi: «Wundu bǝlaa daduram bawoaro jǝpciyi?» wotte Almasiwua karmolan sangoro wullǝmmi. ");
INSERT INTO kby_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Amma awi gǝle wuljidǝ? «Manadǝ karǝnnǝm delnin, ti curo cinǝmben ye, curo karwunǝmben ye,» wotte mana kambǝrseye mawoniyedǝ. ");
INSERT INTO kby_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Cinǝmlan «Isama Kǝmadǝ wo!» nǝme karwunǝmlan Ala tia karmolan cǝsangǝnaro kasatkemma, njǝkkawo fandǝmi. ");
INSERT INTO kby_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Awoa karwulaman kam mǝrsaje jiremaro walji, koro cilaman kasacce njǝkkawo cuwandi, ");
INSERT INTO kby_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","kitawulan ruwuwadadǝ gai: «Wundu duwon tia mǝrsajǝnamadǝ, nangu tia cǝdaiwawo.» ");
INSERT INTO kby_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Awima yaudi-a yaudi gǝni-a gayirji bawo, ti Kǝma am dunia sammayedǝ tayi duwon tia bowojai sammaro jauro barga dǝpciyi, ");
INSERT INTO kby_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","awoa: «Wundu duwon cu Kǝmandeyea bowojǝnamadǝ njǝkkawo cuwandi.» ");
INSERT INTO kby_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","To, ndayin gǝle ti mǝrsajannidǝa bowojai? Koro ndayin ti kǝlanjun fanjannidǝa mǝrsajai? Koro ndayin mawoduma bawoa fanjai? ");
INSERT INTO kby_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Koro tayia canode lejannia, ndayin mawojai? Kitawulan ruwuwadadǝ gai: «Si am lawar kǝji kudomasoyedǝ jauro shawa!» ");
INSERT INTO kby_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Amma am samma gǝni kawuɍi kǝjidǝa jaa. Nawi Ishayaye: «Kǝmande, wundu kawuɍinde kasacco?» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ngaima kambǝrsedǝ kawuɍi fandayen isi, kawuɍi fandadǝ ye mana Almasiwuyen isi. ");
INSERT INTO kby_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Amma wuye: «Fanjanni wa?» nǝkke korǝkki. Tabbatto fanjana! «Kowonja dunia ngan nukcǝna, mananja har ci dajiram duniayero lejǝna.» ");
INSERT INTO kby_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Amma wuye: «Jama Israyilaye asujanni wa?» nǝkke korǝkki. Burwon Nawi Musaye: «Am jama gǝnia yakkǝkke nandǝɍi nayia njadai, jama hangal bawoalan faidadǝkke njasakke gǝrganuwi,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Daji ridu bawoaro Nawi Ishayaye: «Am wua masanni wua sewando, am wua saworǝnniro kǝlani fǝleyekko,» ");
INSERT INTO kby_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","amma kǝla jama Israyilayen tiye: «Dabdu sǝrambo jama ganambuma koro tuɍumaro mukkoni sayeyekko,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Adǝ nangaro korǝkki: «Ala jamanjua wayeno wa?» A'a, tǝmmaro ngai gǝni! Wu kǝlanima Israyilama, kaduwu Nawi Ibrahimbe, jiɍi Biliyaminuye. ");
INSERT INTO kby_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ala jamanju caman nojǝnadǝa wajǝnni. Ra, awo kitawu kǝla Nawi Iliyayen wuljǝna, jiɍi sonju kǝla Israyilawuyen Alaro cǝddǝnadǝa nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Tiye: «Kǝmande, nawiyanǝmba ceyesǝna, laya duwadurammǝm wurjana, wu runima gammǝkko, koro wua njejoro masai,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Awi Ala jaawuro co? «Am fuwu Ba'allen tungurumjanni dǝwu tulur kǝlaniro gǝnayekko,» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Jaman kǝrmayen ye ngaima, am laa gana gapcana Ala sernjun kǝrejǝna mbeji. ");
INSERT INTO kby_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Amma kǝrenjudǝ kǝla serren nangaro, tidǝ kǝla kidayen gǝni tǝdi. Adǝ gǝnia, ser Alayedǝ gadero ser gǝni. ");
INSERT INTO kby_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","To, awi gǝle? Jama Israyilaye awo majidǝa cuwandǝnni. Adǝ yaye tayi duwon Ala kǝrejǝnadǝ cawandǝna, tayi gadedǝye Ala kǝlanja kibbajǝgǝna, ");
INSERT INTO kby_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","kitawulan ruwuwadadǝ gai: «Ala karwunjaa jakcǝna, tayiro sim caruiwawo ye, sǝmo fanjaiwawo ye cina, har kumaro.» ");
INSERT INTO kby_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Koro Nawi Daudaye: «Masǝnanja kel-a kutti-a takkal-aro waljo, nianja ye kǝlanjaro waljo! ");
INSERT INTO kby_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Simnja duwuaro waljo bare curunniro, ngawonja ye kullumbo nguwadaro waljo!» cǝnna. ");
INSERT INTO kby_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Daji korǝkki: «Jama Israyilaye taldunjadǝ, casurǝna cijaiwawo wa?» A'a, tǝmmaro ngai gǝni! Amma ayaunjayeman njǝkkawodǝ kǝrdiyaro kadio, nandǝɍi jama Israyilayea cǝdaro. ");
INSERT INTO kby_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Taldunjadǝ barga duniaro kikkudoa, koro njuronjadǝ barga kǝrdiyaro kikkudoa, balle Alaro waldunja! ");
INSERT INTO kby_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nayi fǝrdundo kǝrdidǝro wulnjagakki, wu kǝngayam kǝrdiyayedǝro, kidanidǝa jajangǝkki, ");
INSERT INTO kby_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ngainin kǝramiyania yakkǝkke nandǝɍi tayia cǝdai, laanja njǝkkawo cawandoro. ");
INSERT INTO kby_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Tayia sǝgǝriro njakkodǝ solo duniaye kiwudoa, awi gǝle mowonja ye cuwudi? Karmolan roaro cidu, gǝna? ");
INSERT INTO kby_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Sadaa rungo nema burwoyedǝ tayirdǝro, rungodǝ samma ngai, koro si kǝskayedǝ tayirdǝro, dǝlambadǝ ye ngai. ");
INSERT INTO kby_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Dǝlamba laaa kǝska jaitun fadoyen kamjane, ni ye dǝlam ya jaitun karaaye duwon tiro tannjagane, nuwanǝm si ambaduma ya jaitunnedǝlan kiwandǝmba, ");
INSERT INTO kby_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","bare kǝla dǝlamba aniyen kǝlanǝm jajangǝmmi! Amma jajangǝmiro walyenoa, ni gǝni sidǝa ronǝmi, sidǝ nia ronjiro tange! ");
INSERT INTO kby_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Daji niye: «Wua kǝskadǝro tansaaro dǝlambadǝa kamjana,» nǝmi. ");
INSERT INTO kby_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Jiremaro, kambǝrsenambunja nangaro kamgera, amma nidǝ kambǝrsenǝm nangaro danǝmma. To, bare rokuramaro wallǝmmi, biya rine! ");
INSERT INTO kby_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ala dǝlamba alaladǝa koljǝnniro walyenoa, ni yea sam kolnjiwawo. ");
INSERT INTO kby_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Nanngǝla-a nanjau-a Alayea rui, nanjau kanji am casurǝnayen, amma nanngǝlanju kanjinǝmlan. Sai nanngǝlanjudǝlan dǝgamiya, adǝ gǝnia, ni yea kamnjai. ");
INSERT INTO kby_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Koro tayi ye, kambǝrsenambulan dasaanniro walyenoa, waldane tayia tanjai, na Alayen kǝnduwo tayia tanduye mbeji. ");
INSERT INTO kby_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Nidǝ, dǝlam ya jaitun karaayelan kamnjane ya jaitun fadoyero tanngeyera, niro alala gǝni. Balle tayi dǝlamba kǝska fadoyedǝ, ya jaitun kaanjayero tanduwudǝ jau wa? ");
INSERT INTO kby_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Kǝramiya, asǝr adǝa nonuwiya, raakko, bare ilmuwuro kǝlandoa ngonuwwi: Kǝlakibbu jama Israyilaye laanjaa cǝdana, har curo kǝrdiyayen nanngǝwunja samma Alaro isairo. ");
INSERT INTO kby_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ngainin jama Israyilaye samma njǝkkawo cawandi, kitawulan ruwuwadadǝ gai: «Njǝkkayima Siyonlan isi, kaduwu Yakubaye-a awo nanmuminne gǝnidǝ-a faiji. ");
INSERT INTO kby_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Adǝma aman tayi-a ndǝmmiyedǝ: Biwuwanja cinnǝkki.» ");
INSERT INTO kby_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kanji kawuɍi kǝjidǝyen nayi nangaro tayidǝ kǝlado Alaye, amma kanji kǝre Alayedǝyen kaariyadǝ nangaro tayidǝ taraana. ");
INSERT INTO kby_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Awoa Ala kǝnjonju-a bowodunju-aa tǝmmaro faljiwawo. ");
INSERT INTO kby_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nayidǝ calan Alaa ganambuwu duwon kǝrma ganambunja nangaro nayia njunonjana. ");
INSERT INTO kby_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ngaiman tayidǝ ye kǝrma ganambuwu nangaro kanjimaɍi fanduwwa, tayi ye kǝrma kanjimaɍi cawandoro. ");
INSERT INTO kby_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ala kanjimaɍinju am sammaro fǝlejuworo, tayia cakke kosowu ganambuyero walyera. ");
INSERT INTO kby_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Alaye nanrashidunju-a ilmunju-adǝ jaumaro kura, cinjama bawo! Wowomnju ye nodiwawo, jawalnju ye asudiwawo! ");
INSERT INTO kby_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«Wundu gǝle nia Kǝmandeye nojo? Wundu gǝle galamanjuro waljo?» ");
INSERT INTO kby_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","«Wundu gǝle burwon Alaro awo laa co, tiro cǝkkǝrǝmbiro?» ");
INSERT INTO kby_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Awoa awo samma tilan ye, tiyen ye, ti nangaro ye dǝgai. Tiro har abadaro daraja tio! Amin. ");
INSERT INTO kby_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Adǝ nangaro, kǝramiya, kǝla kanjimaɍi Alayen nayia lowonjakki, tiyindo laya roa gai tayir ye, Ala ardijǝna yero yowo, ngaiman jiɍi wajipcǝnalan tiro ambǝtkǝwi, awoa adǝma ambǝttuwundo jireye wo. ");
INSERT INTO kby_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Bare camuno jaman adǝyero walluwwi, amma hangal bǝɍin ngonowo, faldǝnowo, ngainin awo Ala cǝraana, wotte awo ngǝla ye, tǝraana ye, kalkal yedǝa asunuwi. ");
INSERT INTO kby_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kǝla ser Ala sinadǝyen wuye wundundo yayero wulgǝkki, bare kǝlandoa awo jussǝnaa kojǝnaro ngonuwwi, amma Ala wundundo yayero nuwanju kambǝrseye dagarjǝgǝnadǝ gai, hangal ngǝlan tǝmanowo. ");
INSERT INTO kby_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Jiɍi andi tiyi falnin nasha ngǝwu taiyena kidanja tilo gǝnidǝ gai, ");
INSERT INTO kby_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","jiɍi adǝgainin andi ngǝwu yaye, Almasiwulan andi tiyi fal, koro wundunde yaye nasha kamanjuye. ");
INSERT INTO kby_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Kǝla ser Ala sadǝnadǝyen, kǝnjonde gadegade. Kam laa kǝnjonju nawinawi dioro walyenoa, duno kambǝrsenjuyen cǝdo. ");
INSERT INTO kby_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Kida banayero walyenoa, kida adǝa cǝdo. Alamdumaro walyenoa, alamjo. ");
INSERT INTO kby_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Karwuro duno njomaa, duno co, bana njomaa, karwu tilon co, fuwumaa, kasaduaro cunodo, koro kanjimaɍimaa, karwu kǝjiaro cǝdo. ");
INSERT INTO kby_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kǝrawondodǝ nanmǝnafǝk bawoaro waljo! Awo diwidǝa wanowo, awo ngǝladǝa taiwo. ");
INSERT INTO kby_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Kattendon kǝrawo nanyaanayelan tǝrawowo, kamandoro daraja yowo, nayiro ngalworo ngonowo. ");
INSERT INTO kby_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Bare kasadulan lusurro walluwwi, nia ngonowo karwundo samman Kǝmandea gaiwo. ");
INSERT INTO kby_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Tǝmandolan karwundo kǝjijo, bone njalan neddowo, moduwa diolan dǝgaiwo. ");
INSERT INTO kby_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Mǝradu muminnaye gallowo, mukko yindin kusotto sawowo. ");
INSERT INTO kby_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Am nayia basarnjanadǝro barga dǝpkǝnowo. Aaa, tayiro barga dǝpkǝnowo, bare tayia baskunuwwi. ");
INSERT INTO kby_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Am karwunja kǝji-a rokko karwundo kǝjijo, am cesiri-a rokko yirowo. ");
INSERT INTO kby_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Kattendon hangalndo tilojo. Bare rokura diwwi, talaawaro kǝldǝgǝnowo. Bare kǝlandoa rashiduro ngonuwwi. ");
INSERT INTO kby_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Bare wundumaro kuttua kuttun yikkǝrǝmbuwwi, amma hangal gǝnanowo awo duwon fuwu am sammayen ngǝladǝa dewo. ");
INSERT INTO kby_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Yojia, nayiro mowonjiyiro walyenoa, am samma-a rokko nanlewan dǝgaiwo. ");
INSERT INTO kby_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Kǝrawowuni, bare kǝlandoro koro mowuwwi, kollowo gǝrgadu Alaye dama cuwando, kitawulan ruwuwadadǝ gai: «Kǝmandeye: “Wowom gǝnaduwudǝ kakke, wuma rǝmbǝkki,” cǝnna.» ");
INSERT INTO kby_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Amma wadumanǝm kǝnanjuaa, awo kǝmboye ye juwo. Ngudunjuaa, awo kǝnjaye ye ca. Ngai dimilan kaɍimi kannua kǝlanjuro lapkǝmi. ");
INSERT INTO kby_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Bare kollǝme nandiwi ranjǝgǝnni, amma awo ngǝla diolan kǝla diwidǝyen nasardǝne. ");
INSERT INTO kby_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Wundu yaye fuwuwu kǝrmai canodidǝro dau koljuwo, kǝnduwo duwon Alayen isiwawodǝ falma bawo, koro tayi dasaanadǝa Ala galajo. ");
INSERT INTO kby_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Adǝ nangaro kam fuwumaa ga wajimadǝ awo Ala galajǝnadǝa ga wajǝna, koro tayi wajanamadǝ wowom kǝlanjaro gǝrjagai. ");
INSERT INTO kby_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Awoa fuwuwudǝ am ngǝla cadisoro gǝni, am diwi cadisoro awo riduye wo. Fuwumadǝa ridu raammi? To, awo ngǝla de, ardiya nanjun fandǝmi. ");
INSERT INTO kby_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Tidǝ kidama Alaye nanlewanǝm nangaro. Amma diwi dimiro walyenoa, tia rine, bowuro gǝni kashagarnjuadǝ. Aaa, tidǝ Alaye kidamanju, tima rǝmboma duwon gǝrgadu Alaye kam diwi cǝdǝnaro gǝrjiyimadǝ wo. ");
INSERT INTO kby_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","To, dolero fuwuwudǝro dau kolgǝwi, gǝrgadu Alaye rida runjuro gǝni, saɍiwu karwundoye nangaro. ");
INSERT INTO kby_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kǝla adǝyeman akki biyanuwidǝ, awoa fuwuwudǝ kidawu Alaye awo mukkonjaro cakkǝnaa kissagai. ");
INSERT INTO kby_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Wundu yayero awo wajipnjudǝa yowo. Akkia, akki biyanowo. Julaa, jula biyanowo. Martawaa, martawa yowo. Darajaa, daraja yowo. ");
INSERT INTO kby_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Wundu yaye kamanjua rawo gǝnia, bare wunduma tia awo laaro jǝganni, kam kamanjua cǝraanadǝ awo wadaye sammaa cǝdǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Wadawa ani: «Bare kǝnjǝna dimmi, bare ro kambe tuluwummi, bare nambarwu dimmi, bare mangar dimmi,» koro wada gade samma curo mana adǝyeman tuwandǝna: «Kǝmaskinǝmba kǝlanǝm gairo raye!» ");
INSERT INTO kby_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Kǝrawodǝ diwi kamanjuro cǝddiwawo. Kǝrawodǝ tima awo wadaye sammaa diodǝ wo. ");
INSERT INTO kby_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Jaman filan kǝrgaiyero nonuwwa. Sa kǝnǝmlan ciduye cǝdǝna, njǝkkawodǝ kǝrma sa kasattu badiniyenadǝ yayero gǝrende del karǝnjǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Bune ye kodu cǝdi, dunia wadu ye karǝnjǝna. Kida duwuye waniyo, baɍimi nurre ngoniyo. ");
INSERT INTO kby_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Kǝndǝgai jussǝna kausu gairo diyo, kǝlaɍiwonambu-a sagarandu-alan gǝni, kǝnjǝna-a nanjane-alan gǝni, koro lawala-a nandǝɍi-alan gǝni. ");
INSERT INTO kby_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Amma hal Kǝmande Isa Almasiwuyea ngonowo, bare mangar tiyiye galdu dabbarnuwwi. ");
INSERT INTO kby_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kam kambǝrsenju duno bawoa mukko yindin mowowo, bare kǝla raayinjuyen kambiwu diwwi. ");
INSERT INTO kby_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Kam laa awo sammaa juwuiro mǝrsajǝna, laa ye kambǝrsenju duno bawoadǝro kǝɍijuwo runju juwui. ");
INSERT INTO kby_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Bare kam juwuidǝ kam juwuiwawodǝa rujǝnni, koro bare kam juwuiwawodǝ kam juwuidǝa sharajǝnni, Ala kam juwuidǝ yea ardijǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ni wundu duwon wolodi kam gadeyea sharanǝmidǝ? Dajǝna bi dajǝnni, adǝ awo kǝmanjuye, koro daji, na Kǝmandeyen kǝnduwo tia isadaduwuye mbeji. ");
INSERT INTO kby_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Kam laa yim laa yim gadea kojǝnaro tǝmajǝna, kam laa ye yim samma tiloro tǝmajǝna. Wundu yaye awo karwunjuyedǝa tabbatto kasacco. ");
INSERT INTO kby_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Kam yimdǝa jǝgaimadǝ Kǝmande nangaro jǝgai. Kam juwuimadǝ ye Kǝmande nangaro juwe Alaa wuseji. Koro kam juwuiwawomadǝ ye Kǝmande nangaro juwuiwawo, Alaa wuseji. ");
INSERT INTO kby_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Wunduma curonden kǝlanjuro gǝni roa dǝgai, koro wunduma curonden kǝlanjuro gǝni nui, ");
INSERT INTO kby_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","dalilnjudǝ roa kǝrgaiyea, Kǝmande nangaro dǝgaiye, koro kanuiyea, Kǝmande nangaro nuiye. Ngaima roa dǝgaiye bi nuiye, andidǝ Kǝmandeye. ");
INSERT INTO kby_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Dalil Almasiwu nune walde roaro cijǝnadǝ tima Kǝma am sanuna-a roa-a sammayero waljo. ");
INSERT INTO kby_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","To, ni, awiro kǝraminǝmba sharanǝmidǝ? Ra ni, awiro kǝraminǝmba runǝmidǝ? Awoa andi samma fuwu shararam Alayen daniye, ");
INSERT INTO kby_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","kitawulan ruwuwadadǝ gai: «Kǝmandeye: “Wu mbejidǝ jiredǝ gai, ngurumngurum fi yaye fuwunin fidi, koro tǝlam fi yaye wuma Ala woro sacci,” cǝnna.» ");
INSERT INTO kby_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ngainin wundunde yaye kǝla awo cǝdǝna sammayen Alaro wuljiyi. ");
INSERT INTO kby_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Adǝ nangaro bare gadero kattenden shara diyende, cuju adǝyero nia ngonowo bare jawal kǝramiyero takkal bi awo talduye gǝnagǝwwi. ");
INSERT INTO kby_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Kǝma Isa nangaro nokkǝna, koro tabbatto ardinǝkkǝna, awo duwon ciduramnjun tayir gǝnidǝ bawo, amma kam duwon awo laaa tayir gǝniro ngojǝnadǝ, tiro awodǝ tayir gǝni. ");
INSERT INTO kby_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kǝla awo bumiyen yakkǝme karwu kǝraminǝmbe kuttayenoa, daji jawal kǝrawoyen luwumma. Bare kǝla awo bumiyen kam duwon ti nangaro Almasiwu nunadǝ faccǝgǝnni, ");
INSERT INTO kby_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","bi awo nayiro kǝjidǝro diwi wuljanni, ");
INSERT INTO kby_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","awoa nodo bargaa Alayedǝ awo kǝmbo-a kǝnja-ayen gǝni kǝrga, tidǝ awo nanjire-a nanlewa-a karwukǝji-a Ruhu Alaye cuwudiyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Kam nanwolodi Almasiwuro ngainin cǝddidǝ, Ala tia cǝraana, koro am ye tia ardijana. ");
INSERT INTO kby_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Daji ngainin awo duwon nanlewa cuwudi ye, amba cakke kattenjan isadunoajagai yedǝa maniyo! ");
INSERT INTO kby_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Bare kǝla kǝmboyen kida Alaye wurnǝmmi. Awi yaye tayir, amma jawal kam gadeyero kǝla awo juwuiyen awo talduye laa gǝnaduwudǝ, diwi. ");
INSERT INTO kby_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Awo ngǝladǝ tima da ngǝro so, diben nja so, awo gade samman yakkǝme kǝraminǝm taljidǝa wadu. ");
INSERT INTO kby_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Nidǝ, kambǝrse kǝla awo aniyen tammadǝa katte ni-a Ala-ayen rone. Barganju kam duwon kǝla awo ardijǝnayen kǝlanju sharajiwawodǝ. ");
INSERT INTO kby_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Amma kam shekkunjuadǝ, juwuiro walyenoa, Ala tiro shara kamjiyi, awo cǝdidǝ kambǝrseyen gǝni kadio nangaro, koro awo kambǝrseyen isǝnni samma biwu. ");
INSERT INTO kby_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Andi kambǝrsende dunoadǝ, ardiya kǝlandero mada gǝni, am kambǝrsenja duno bawoadǝa nettu andiro wajimsaana. ");
INSERT INTO kby_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Wundunde yaye kambǝrse kamanjuyero duno njakkoro nanlewanju nangaro ardiya tiro majuwo. ");
INSERT INTO kby_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Awoa Almasiwuma ardiya kǝlanjuro majǝgǝnni, amma kitawulan ruwuwadadǝ gai: «Radu am nia ranjaidǝye kǝlaniro casukkurǝna.» ");
INSERT INTO kby_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Awo kuren kitawulan ruwuwada samma andia alamsaro ruwuyera, ngainin nettu yen, duno njo kitawuye yen tǝma fandiye. ");
INSERT INTO kby_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ala nettu-a duno-a njomadǝ cakko kǝla Isa Almasiwuyen hangalndo tilojo, ");
INSERT INTO kby_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ngainin karwu falnin ci tiloaro Ala Bawa Kǝmande Isa Almasiwuyero daraja yiwi. ");
INSERT INTO kby_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Adǝ nangaro Almasiwu nayia njamowonadǝ gai, wundundo yaye kamanjua cǝmowo, Alaro daraja tioro. ");
INSERT INTO kby_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Nayiro wulnjagakki, jire Alaye fǝleduro Almasiwu wolodi am kajaadayero walyeno. Adǝa dionjudǝ, wadu duwon Ala kaariyaro ngojǝgǝnadǝa tabbaccuworo, ");
INSERT INTO kby_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","koro kǝrdiya ye kanjimaɍi Alaye nangaro tiro daraja cadoro, kitawulan ruwuwadadǝ gai: «Adǝ nangaro dawu kǝrdiyayen nia njungorǝkki, cunǝmbo aiya yegǝkki.» ");
INSERT INTO kby_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Koro walde: «Nayi kǝrdiyaso, jamanju-a rokko kǝji fannowo!» ");
INSERT INTO kby_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Koro walde: «Nayi kǝrdiya samma, Kǝmandedǝa yungorowo! Jama samma tia congoro!» ");
INSERT INTO kby_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Adǝgaima koro Nawi Ishayaye: «Kaduwu Yisaiye isi, ti duwon kǝrdiyaa nodoro cijidǝ, koro timaro kǝrdiyadǝ tǝmanja casakki.» ");
INSERT INTO kby_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ala tǝma njomadǝ nayiro karwukǝji-a nanlewa-a samma kambǝrseyen na kojǝnaro njado, tǝmando kǝnduwo Ruhu Alayen ngǝwuro tǝrga. ");
INSERT INTO kby_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Kǝramiyani, nayi awo ngǝlan kek tǝmbǝɍuwwa ye, ilmu sammaa tawwa ye, koro ranguwe kattendon alamduwi yero wu kǝlani tabbatto nokkǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Adǝ yaye nayiro isatannjagakkoro kǝla awowa laayen ridu bawoaro ruwunjagakkǝna, Ala wuro ser sǝdde ");
INSERT INTO kby_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","kǝrdiyadǝro kidama Isa Almasiwuyero wallǝkkǝna nangaro. Kǝrdiyadǝ sadaa laa Ala ardijǝnaro walja, Ruhu Alaye tayia tayirro cǝdoro, ɍiman gai kida kawuɍi kǝji Alaye dikki. ");
INSERT INTO kby_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Adǝ nangaro Isa Almasiwuyen kidani Alaye dikki adǝn dalil awulo boye takkǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Awo Almasiwu kǝrdiya Alaa jaaro wuyen cǝdǝnadǝa gǝnia, awo gade wullǝkkiwawo, mana-a kǝndo-alan, ");
INSERT INTO kby_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","kǝnduwo alama so, awo ajabba soye yen, koro kǝnduwo Ruhunjuye yen adǝa kido. Ngainin Jerujalemlan tai cidi Ilirikumbero yadero dirikke kawuɍi kǝji Almasiwuyedǝa wullǝkke tumogǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Nianidǝ kawuɍi kǝjidǝa na cu Almasiwuye koro yaye nojannin mawodu, bare kǝla fǝrdu kam gade gǝnajǝnayen tandǝkkǝniro. ");
INSERT INTO kby_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Amma kitawulan ruwuwadadǝ gai: «Am duwon tayiro mana kǝlanjun wuljagannidǝ carui, koro am fanjannidǝ asujai.» ");
INSERT INTO kby_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Dǝlwu adǝma nangaro nandoro ngǝwuro ledu raakkǝnama fandǝkke lekkǝni. ");
INSERT INTO kby_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Amma kǝrma nani kidaye cidi anin gadero bawodǝ, koro saa kada nandoro leduro makkidǝ, ");
INSERT INTO kby_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","sa kokke lardu Espaniyayero lekkiya, nayia njarukkiro tǝmakkǝna, koro mǝraduni sa ganaro nayia kuroye gallǝkkǝnaye ngawon, lardudǝro lekkoro banasǝgǝwi yero tǝmakkǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Kǝrmadǝro Jerujalembo kida muminnadǝro njǝddoro lekki, ");
INSERT INTO kby_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","awoa kǝramiya lardu Makidoniyaye-a Akayaye-ayedǝ talaawa muminna Jerujalemlan dasaanadǝro bana laa kudoro ngǝlaro caruna. ");
INSERT INTO kby_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Aaa, adǝa nanngǝlanjan kedo, koro wajipdǝ kǝlanjan mbeji. Kǝrdiyadǝ curo awowa Ruhuyen nuwanja kewandoa, daji kanji kareyayen banadudǝ tayi yero wajipcǝgǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Adǝ nangaro, sa kida adǝa yerǝkke awo capcanadǝa tayiro yikkiya, nandoyen lardu Espaniyayero lekki. ");
INSERT INTO kby_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Nandoro isǝkkiya, barga Almasiwuyen cap isǝkkiro nokkǝna. ");
INSERT INTO kby_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Kǝramiya, Kǝmande Isa Almasiwu-a kǝrawo Ruhuye-a nangaro nayia lowonjakki, wu-a rokko mǝldǝnowo wuro Alaa sukkorowo. ");
INSERT INTO kby_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ala wua mukko ganambuwu cidi Yahudiyayero sǝmowo, koro muminnadǝ bana tayiro Jerujalemlan yadǝkkidǝa kǝjiro cawandoro moduwa dewo. ");
INSERT INTO kby_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ngainin Alaye cǝdia, nandoro karwu kǝjiaro isǝkki, nandon tustu fandǝkki. ");
INSERT INTO kby_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ala nanlewaye nayi sammalan dǝga! Amin. ");
INSERT INTO kby_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kǝraminde Ya Fibi banama jama Isaa gawu bǝla Kankariyayedǝa nayiro asunjagakki. ");
INSERT INTO kby_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Kǝmande nangaro jiɍi muminnaro jussǝnalan tia mukko yindin mowowo, lamar fin yaye nayin mǝradunjuadǝn tiro banagǝnowo, tima am ngǝwu wun kundenno bana sadǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ya Bilkisu-a kwanju Akila-aa lewanowo, wu-a rokko Isa Almasiwuye kidawu, ");
INSERT INTO kby_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","tayi duwon roni nangaro kaanja caladǝnadǝ. Wu runi gǝni, jama Isaa gawu fǝrdunja kǝrdi samma ye tayia ardijana. ");
INSERT INTO kby_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Jama Isaa gawu fannjan captaisodǝ yea lewanowo. Afanitus raakkǝnadǝa lewanowo, tima Isaa gama burwoye cidi Asiyaye wo. ");
INSERT INTO kby_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Meram nayi nangaro jauro ngǝnǝptǝnadǝa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Andaronikus-a Ya Yuniyatu-a, kǝramiyani ye, sawawani kosoye yedǝa lewanowo, tayidǝ dawu kǝngayambayen nowada, koro wun burwonno Almasiwua jaana. ");
INSERT INTO kby_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Amfiliyatus Kǝmande nangaro raakkǝnadǝa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Urbanus sawande kida Almasiwuyen-a Sitakis raakkǝnadǝ-aa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Afalus Almasiwulan ardiyadadǝa lewanowo. Am fado Aristabulussea lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Kǝramini Hirudiyanna lewanowo. Am Kǝmaa gawu fado Narkisussea lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ya Tarafina-a Ya Tarafosa-a kida Kǝmandeyen jauro ngǝnǝptanadǝa lewanowo. Ya Farsi tǝraanadǝa lewanowo, ti ye kida Kǝmandeyen jauro ngǝnǝptǝna. ");
INSERT INTO kby_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Rufus kam Kǝmande tia kǝrejǝnadǝ-a yanju ti yani gai yedǝ-aa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asinkǝrit-a Filegon-a Hermes-a Fatǝrobas-a Hermas-a kǝramiya tayi-a rokkodǝ-aa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filologus-a Ya Yuliyatu-a Niriyus-a yanjugǝna kamuye-a Olimfas-a muminna tayi-a rokko samma-aa lewanowo. ");
INSERT INTO kby_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Kattendon lewa kǝrawoyen lewadǝnowo. Jama Almasiwua gawu samma nayia lewanjai. ");
INSERT INTO kby_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Kǝramiya, lowonjakki, am alamdu fanduwwadǝa wajane yaktu cadimaso, takkal cakkimasoro hangaldǝnowo, tayiro kadǝnowo! ");
INSERT INTO kby_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Am ani gai Kǝmande Almasiwuro gǝni, curonjamaro kida caddi, koro manakǝjinja-a jajaktunja-an karwu am awo diwi asujaiwawoyedǝa jambajai. ");
INSERT INTO kby_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Lawar gandoyedǝa wundu yaye nojǝna. Nayi nangaro karwuni kǝjijǝna, amma kǝla awo ngǝlayen rashiduro walluwe kǝla awo diwiyen biwu bawoaro walluwiya, raakko. ");
INSERT INTO kby_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ala nanlewaye tussǝnnin cidiya sindoyen Yiwulissa gǝrneji. Ser Kǝmande Isaye nayilan dǝga! ");
INSERT INTO kby_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti sawani kidayedǝ nayia lewanjai, adǝgaima Lusiyas-a Jason-a Sosifata-a kǝramiyanidǝ ye lewanjai. ");
INSERT INTO kby_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Wu Tartiyus wotiya adǝa ruwunǝkkǝnadǝ cu Kǝmandeyen nayia lewanjakki. ");
INSERT INTO kby_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus ti duwon wu-a jama Isaa gawu samma-aye sosamandedǝ lewanjai. Erastus asusuma bǝlaye kǝraminde Kartus-a rokko ye lewanjai. ");
INSERT INTO kby_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Ser Kǝmande Isa Almasiwuye nayi sammalan dǝga! Amin. ");
INSERT INTO kby_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","To, Alaro daraja tio, kǝla kawuɍi kǝji Isa Almasiwuye mawonǝkkiyen kǝnduwo nayiro duno njoye nanjun mbeji. Koro kǝla fasal Alaye kǝrdiyaa wujǝna tǝn jaman kureyen jaktǝna duwon, ");
INSERT INTO kby_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","kǝrma awo nawiya ruwujana nangaro jama duniaye sammaro bayinjiye isanojaanayen, koro wada Ala Sawisomaye, wada duwon tayi tia mǝrsaja jaaro cinadǝ yen, ");
INSERT INTO kby_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ala tilo nanrashidu cǝdanadǝro Isa Almasiwuyen har abada abadinno daraja tio! Amin.");
INSERT INTO kby_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Wuma Bulus rawo Alayen kǝngayam Isa Almasiwuyero walduro bowowada-a kǝraminde Sastanisu-adǝ ");
INSERT INTO kby_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","jama Alaye bǝrni Korintiyen dasaana, wotte am duwon Isa Almasiwulan tayir ye, mumin yero walduro bowowadadǝro, koro am na fin yaye cu Kǝmande Isa Almasiwuye Kǝmanja ye, kaande yea bowojai samma yero: ");
INSERT INTO kby_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ala Bawande-a Kǝma Isa Almasiwu-a nayiro ser-a nanlewa-a njado! ");
INSERT INTO kby_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Sawi yaye nayi nangaro Alania wusenǝkki, dalilnjudǝ nayiro Isa Almasiwulan ser njadǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Jiɍi fin yaye mana samma-a ilmu samma-alan arsiyi jireye tilan fanduwwa, ");
INSERT INTO kby_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","sheda kǝla Almasiwuyen dawundon tabbatkaadadǝ gai, ");
INSERT INTO kby_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ngainin kǝnjo Ruhu Alaye falma nayia maunjannin fǝledu Kǝmande Isa Almasiwuye gangadaaro gurenuwi. ");
INSERT INTO kby_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ti kǝlanju har sa njerorambero duno njade yim Kǝmande Isa Almasiwuyen saɍiwu bawoaro walluwi. ");
INSERT INTO kby_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ala amanma, ti duwon Tadanju Isa Almasiwu Kǝmandedǝ-a rokko naptu nanyaanaye deworo bowonjanadǝ. ");
INSERT INTO kby_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Kǝramiya, cu Kǝmande Isa Almasiwuyen nayia lowonjakki, nayi sammaye cindo tilojo, bare kattendon yaktu mbejiro waljǝnni, amma hangalndo tilojo, niando ye tilojo. ");
INSERT INTO kby_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","To, kǝramiyani, am fado Ya Kǝlowuye wuro dawundon kambiwuaro wulsaana. ");
INSERT INTO kby_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Awo wullǝkkidǝ tima wundundo yaye: «Wudǝ Bulusse,» laaye: «Wudǝ Afolusse,» laaye: «Wudǝ Kefasse,» laaye: «Wudǝ Almasiwuye,» cǝni. ");
INSERT INTO kby_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasiwudǝ yakkada wa? Bulussa wa nayi nangaro kǝska karmoyero jajaa? Ra, cu Bulussen wa nayiro kasala ngeddo? ");
INSERT INTO kby_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Kǝrifus-a Gayus-aro gǝnia, wundundomaro kasala yiddǝkkǝniro Alaa wusenǝkkǝna, ");
INSERT INTO kby_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","bare wunduma kasala nayiro cunilan njaddǝnaro wuljǝnniro. ");
INSERT INTO kby_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ase, am fado Istifanusse yero kasala yiddǝkkǝna, amma tayin ngawon am gadero kasala yiddǝkkǝnaa nokkǝni. ");
INSERT INTO kby_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Almasiwu wua ambo kasala njǝddoro gǝni, kawuɍi kǝji wulduwuro sunodo, koro mana nanrashiduyen gǝni, bare kǝska karmoye Almasiwuyedǝ bowuro waljǝnniro. ");
INSERT INTO kby_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Am faccagaidǝro kawuɍi kǝska karmoyedǝ hangalnambu, amma andi njǝkkawo fandiyedǝro ti kǝnduwo Alaye, ");
INSERT INTO kby_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","kitawulan ruwuwadadǝ gai: «Nanrashidu rashiduwayedǝa baworo dikki, ilmu ilmuwuyedǝ yea baworo kalangǝkki.» ");
INSERT INTO kby_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","To, nda kam rashidudǝ? Nda goni Attaurayedǝ? Nda manama jaman adǝyedǝ? Ala nanrashidu dunia adǝyedǝa hangalnamburo kalakcǝnni wa? ");
INSERT INTO kby_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Awoa nanrashidu Alayen am duniaye nanrashidunjalan tia nojannidǝ, Ala dǝlwu hangalnambu mawoniyedǝyen kambǝrsewua njǝkkaworo ngǝlaro kiro. ");
INSERT INTO kby_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Yaudiya alama cawori, am Gǝresse ye nanrashidu majai, ");
INSERT INTO kby_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","amma andi Almasiwu kǝskaro jaadaa mawoniye, yaudiyadǝro awo talduye, yaudiya gǝnidǝro awo hangalnambuye. ");
INSERT INTO kby_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Amma am Alaye bowojǝnadǝ, yaudiya yen kal, yaudiya gǝni yen kal, Almasiwudǝ kǝnduwo Alaye ye, nanrashidu Alaye ye, ");
INSERT INTO kby_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","dalilnjudǝ awo na Alayen hangalnamburo caruidǝ kamba nanrashidun kojǝna, koro awo na Alayen nanlawuro tǝmajanadǝ ye kamba dunon kojǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Kǝramiya, bowodundo ruiwo: Kǝla naptu nan'adamgǝnayen dawundon rashidu ngǝwu bawo, kǝnduwoa ye ngǝwu bawo, am darajaa ye ngǝwu bawo. ");
INSERT INTO kby_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Amma Ala rashiduwaa nanguro cakkoro awo dunian hangalnambuyedǝa kǝrejǝna, am dunoaa nanguro cakkoro awo dunian lawudǝ yea kǝrejǝna, ");
INSERT INTO kby_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","koro awowa mennaa baworo dioro awo dunian batti ye, waada ye, bawo yedǝa kǝrejǝna, ");
INSERT INTO kby_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","bare adamgǝna fima fuwu Alayen awulo juwunniro. ");
INSERT INTO kby_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Tiyeman nayidǝ Isa Almasiwuyero walyew, ti duwon Alayen nanrashidundero waljǝnadǝ, nanjire-a nantayir-a merudu-an kundenno. ");
INSERT INTO kby_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Ngainin kitawulan ruwuwadadǝ gai: «Kam awulo juwuimadǝ Kǝmanden awulo juwo!» ");
INSERT INTO kby_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Wudǝ, kǝramiya, sa nandoro isǝkkǝnadǝ, mana nodu-a nanrashidu-alan gǝni asǝr Alaye wulduro kadikko. ");
INSERT INTO kby_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Isa Almasiwu, ti duwon kǝskaro jaadadǝro kajia, awima gade curondon nokkiwaworo nia ngokkǝna. ");
INSERT INTO kby_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Wudǝ, duno bawoa-a ridua-a lolodu ngǝwua-alan nandoro kadikko, ");
INSERT INTO kby_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","koro kawuɍini-a mawoduni-adǝa mana faiduye-a nanrashiduye-an gǝni, tabbattuwu Ruhu Alaye-a kǝnduwoye-alan kidǝkko, ");
INSERT INTO kby_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ngainin kambǝrsendodǝ nanrashidu kamben gǝni, kǝnduwo Alayen kǝrga. ");
INSERT INTO kby_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Adǝ yaye curo am kambǝrsenjan wurajanayen mana nanrashiduye wulliye, amma nanrashidu dunia adǝye bi kǝnduwowu dunia adǝye faccagaidǝye gǝni, ");
INSERT INTO kby_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","nanrashidu Alaye asǝrlan gǝraada wulliye, nanrashidu duwon Ala kawu dunia alaktiman darajandero kadarjǝnadǝ. ");
INSERT INTO kby_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Kǝnduwowu dunia adǝye wundunjama adǝa asujǝnni, ca asujanaa, Kǝma Darajayedǝa kǝskaro jajaganni. ");
INSERT INTO kby_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Amma kitawulan ruwuwadadǝ gai: «Awo sim curunni, sǝmo fanjǝnni, karwu kambero ngaannidǝ, awo ania Ala am tia caraanaro dabbarjǝgǝna.» ");
INSERT INTO kby_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Andiro Ala awo ania Ruhunjuyen isanosaa. Awoa Ruhudǝ awo sammaa noduma, har awowa Alaye nodu jauadǝmaa. ");
INSERT INTO kby_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Wundu gǝle awo karwu kamben dǝganadǝa nojo, ruhu kambe tilan dǝganadǝro kajia? Ngaima Ruhu Alayero kajia, wunduma awowa Alaye nojiwawo. ");
INSERT INTO kby_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Andi ruhu dunia adǝye gǝni, Ruhu Alaye fandiyena, ngainin kǝnjo serre Ala andiro sadǝnadǝa noniye. ");
INSERT INTO kby_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Koro awo animaa mananiye, mana duwon nanrashidu kamben gǝni, Ruhu Alaye alamjǝnadǝlan wulliye, awo Ruhuyedǝa am Ruhuyedǝro fisargǝiye. ");
INSERT INTO kby_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Kam Ruhu tilan dǝgannimadǝ awo Ruhu Alayedǝa kasacciwawo, dalilnjudǝ tiro awo hangalnambuye, koro rakce asujiwawo, Ruhuyen asudai nangaro. ");
INSERT INTO kby_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Kam tilan Ruhu dǝgaimadǝ awi yayea rijapci, amma ti kǝlanjudǝa wunduma rijapciwawo. ");
INSERT INTO kby_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","«Wundu gǝle nia Kǝmandeye nojo, har tia galaji?» Amma andidǝ nia Almasiwuye taiyena. ");
INSERT INTO kby_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Kǝramiya, wudǝ rangǝkke nayiro am Ruhu tayia simoji gairo mananjagakkǝni, sai am hal tiyiyen dasaana, wotte am Almasiwulan timal gairo. ");
INSERT INTO kby_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Kǝmbo gǝni, kiam nayiro njadǝkke yaw, ranguwwawodǝro. Koro yaye tia ranguwwawo, ");
INSERT INTO kby_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","kuamison nayi hal tiyiyen kǝrgaw nangaro. Dawundon nandǝɍi-a lawala-aadǝ, hal tiyiyen dǝgawe kǝla kǝndǝgai adamgǝnayen diwi, gǝna? ");
INSERT INTO kby_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kam laaye: «Wu Bulusse,» laaye: «Wu Afolusse,» cǝniya, kǝndǝgai adamgǝnaye diwwawo wa? ");
INSERT INTO kby_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","To, Afolusdǝ wundu? Bulusdǝ wundu? Tayidǝ wolodiya tayiyen mǝrsanuwwadǝ, Kǝmande finja yayero kida cinadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Wu nadǝkko, Afolus ketto, amma Ala cakke wurajo. ");
INSERT INTO kby_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Adǝ nangaro kam cǝnadimadǝ-a cattimadǝ-a awima gǝni, sai Ala cakke wurajimadǝ. ");
INSERT INTO kby_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Kam cǝnadimadǝ-a cattimadǝ-a samma tilo, wundunja yaye alwasi kidanjuye kalkal cuwandi. ");
INSERT INTO kby_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Andidǝ sawawa kida Alaye, nayidǝ ye kulo Alaye, tando Alaye. ");
INSERT INTO kby_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kǝla ser Ala wuro sinadǝyen, goni soro tandoye gai fǝrdu gǝnayekko, kam laa gade kǝladǝn cǝdandi. Amma wundu yaye jiɍi cǝttandiro hangal gǝnajo! ");
INSERT INTO kby_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Awoa wunduma rakce fǝrdu gade gǝnajiwawo, ti gǝnaadadǝro kajia, tima Isa Almasiwu wo. ");
INSERT INTO kby_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Wundu duwon kǝla fǝrdudǝyen dinarlan, bi ɍiwullan, bi kau tamanna tamannalan, bi kǝskalan, bi kangalelan, bi kajǝmlan tando cǝdimadǝ, ");
INSERT INTO kby_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","kidanju federo culuwi, yim kiyamaa tia isanojiyi, koro kannun kida wunduye yaye rijapte jiɍinju fǝledi nangaro. ");
INSERT INTO kby_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Kam laaye kidanju cǝttandǝnadǝ napkenoa, mukowa cuwandi. ");
INSERT INTO kby_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Kam kidanju kannuye juwunadǝ tia fucci. Ti kǝlanju njǝkkawo cuwandi, amma dawu kannuyen kojǝna gai. ");
INSERT INTO kby_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Nayidǝ Fado Alaye ye, Ruhu Alaye nayilan kǝrga yero nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kam laa Fado Alayea wuryenoa, Ala tia sijiyi, awoa Fado Alayedǝ tayir, koro Fadodǝ nayima. ");
INSERT INTO kby_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Bare wunduma jambadǝnni. Kamndo laa kǝla dunia adǝyen kǝlanju rashiduro ngoyenoa, hangal bawoa gairo waljo, rashiduro waljoro. ");
INSERT INTO kby_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Awoa nanrashidu dunia adǝye na Alayen hangalnambu, kitawulan ruwuwadadǝ gai: «Ala rashiduwaa nanganjan cǝdai,» ");
INSERT INTO kby_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","koro: «Kǝmande hangal rashiduwayedǝ bowuro nojǝna.» ");
INSERT INTO kby_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Adǝma nangaro bare wunduma kǝla kamben awulo juwunni, awoa awo samma kaando, ");
INSERT INTO kby_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Bulus, bi Afolus, bi Kefas, bi dunia, bi ro, bi karmo, bi awowa kǝrmaye, bi awowa fuwuye. Ai, awo samma kaando, ");
INSERT INTO kby_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","nayi ye Almasiwuye, Almasiwu ye Alaye. ");
INSERT INTO kby_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Adǝgainin andidǝa wolodiya Almasiwuye-a kistuwuwu asǝr Alaye-aro ngosa. ");
INSERT INTO kby_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Kǝla adǝyen dole kistuwumadǝ amannaro waljo. ");
INSERT INTO kby_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Wuyenna shara wuro sǝdduwiya, bi alkali adamgǝnaye laa sǝddiya, awima gǝni. Ai, kǝlanimaro shara yiddǝkkiwawo. ");
INSERT INTO kby_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Karwunilan saɍiwuaro tǝmakkǝni, amma adǝ gǝni wua jiremaro sǝdi, sharamanidǝ Kǝmande. ");
INSERT INTO kby_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Adǝ nangaro bare kawu sanju cǝdiro wundumaro shara yidduwwi, sai Kǝmande isiya, ti duwon awo curo duwuyen gǝraada ye fǝleji, nia karwu kamben dǝgana ye federo cuttuluwidǝ. Sadǝn wundu yaye jajaktunju kalkal na Alayen cuwandi. ");
INSERT INTO kby_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","To, kǝramiya, kǝndǝgaindeyen bare awo kitawulan ruwuwadaa konuwwiro ɍiworo, nayi nangaro awo ania wu kǝlani-a Afolus-aa wusanaro ngokkǝna. Ngainin wundundoma rokura cǝde kam laaa cuju kam gadeyero jǝgaiwawo. ");
INSERT INTO kby_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Wundu amba konǝmmaro nia njǝdo? Awi tamma duwon mowommi wo? Mowommaa, awi nangaro mowommi gai awulo bumi? ");
INSERT INTO kby_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Har kulluwwa! Har gaɍiwunuwwa! Nayi andi-a rokko gǝni maiyaro walluwwa! Ca maiyaro walluwwaa, andi ye nayi-a rokko kǝrmai nodiye! ");
INSERT INTO kby_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Amma kuroniyen Ala andi kǝngayambadǝa na kǝndaryeyero gǝnasaana, am duwon tayiro shara karmoye caddǝnadǝ gai. Fuwu dunia-a malaiyawa-a amso-ayen awo manayero walliyena. ");
INSERT INTO kby_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Almasiwu nangaro andidǝ hangalnambuwu, amma nayidǝ Almasiwulan rashiduwa! Andidǝ dunonde bawo, amma nayidǝ dunondoa! Nayidǝ darajaa, andidǝ ruwada. ");
INSERT INTO kby_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Har kǝrmaro kǝna-a ngudu-a fanniye, kare dina luwadaa, babakkada, fado bawoa ye kǝrgaiye, ");
INSERT INTO kby_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","koro ngǝnǝptiye mukkonden kida diye. Rarasaiya, barga dǝpkǝiye, basarsaiya, neddiye, ");
INSERT INTO kby_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","manakuttu andiro wulsagaiya, ser yiddiye. Andi jambo duniaye gairo walliyena, ngabdula am sammaye gairo, har kumaro. ");
INSERT INTO kby_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nayiro adǝa ruwudunidǝ, nayia nanguro njakkoro gǝni, tadawani jauro raakkǝna gai sǝmondo kasturo. ");
INSERT INTO kby_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Awoa malǝmba dǝwu kada Almasiwulan fanduwi yaye, bawa kada gǝni taw. Wuma kawuɍi kǝjiyen Isa Almasiwulan bawandoro walyekko. ");
INSERT INTO kby_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Adǝ nangaro nayia lowonjakki, misalni gaiwo. ");
INSERT INTO kby_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Dalil adǝro Timoti tadani jauro raakkǝna ye, Kǝmanden amanna yedǝa juwangeyerakko. Tidǝ kǝndǝgaini duwon Almasiwulan dikke ndaran yaye, dawu jama Isaa gawu fiyen yaye yikkǝrakkidǝa nayiro isatannjagai. ");
INSERT INTO kby_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Am laa nandoro isǝkkiwaworo tǝmajane rokurawuro waljana, ");
INSERT INTO kby_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","amma Kǝmande kasaccia, tussǝnnin nandoro isǝkke rokurawu aniye mananja gǝni, kǝnduwonja nokki, ");
INSERT INTO kby_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","awoa nodo bargaa Alayedǝ manan gǝni, kǝnduwon kǝrga. ");
INSERT INTO kby_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Awi rawuw? Kaaa wa nandoro isǝkki, ra kǝrawoa fǝkka farakkan isǝkki? ");
INSERT INTO kby_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Dawundon kǝnjǝna cadi cani fanniyena, koro kǝnjǝna duwon jiɍinju na kǝrdiyayeman tǝdiwawodǝ: Har kam laa kamu bawanjuyea maji. ");
INSERT INTO kby_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Koro rokura diwi! Karwukutta diwe kam awo adǝa cǝdǝnadǝa dawundon tuluwwama ngǝla wo! ");
INSERT INTO kby_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Wudǝ tiyilan nandon gǝni yaye, karwulan nayi-a rokko, koro kǝla kam awo adǝa cǝdǝnadǝyen wu mbeji gairo shara kammǝkkǝna, ");
INSERT INTO kby_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","sa cu Kǝmande Isayen captuwiya, ruhuni ye kǝnduwo Kǝmande Isayen kundenno mbeji duwon, ");
INSERT INTO kby_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","kam adǝa mukko Yiwulissero yakkowo, tiyinjua cejo, yim Kǝmandea ruhunju njǝkkawo cuwandoro. ");
INSERT INTO kby_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Awulo bondodǝ ngǝla gǝni! Yis tǝngǝɍi rungo sammaa isafujiyiro nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Nayidǝ rungo yis bawoa gai, yis dinadǝa tuluwowo, rungo bǝɍinno wallowo, awoa ngǝlaro Layande Njǝkkayirambedǝ duwaada, tima Almasiwu wo. ");
INSERT INTO kby_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Adǝ nangaro ngǝmǝridǝa diyo, yis dina, wotte yis nankǝladoye-a nandiwiye-alan gǝni, burodi yis bawoa, wotte nantayir-a jire-alan diyo. ");
INSERT INTO kby_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Curo wotiyaniyen nayiro jawal kǝnjǝnawuyen luwoworo ruwunjagakkǝna, ");
INSERT INTO kby_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","amma awo wuldu raakkǝnadǝ kǝnjǝnama dunia adǝye gǝni, bi mangarduma, bi ndalduma, bi sǝnǝm gama, adǝ gǝnia, sai dunian luwuwiya. ");
INSERT INTO kby_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","A'a, awo ruwunjagakkǝnadǝ tima kam Isaa gama cǝni duwon kǝnjǝnama, bi mangarduma, bi sǝnǝm gama, bi raraduma, bi mbalma, bi ndaldumaa, bare tiro kǝldǝgǝwwi, bare kam adǝgai-a masǝnama diwwi. ");
INSERT INTO kby_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Awi lamboni am deyayedǝa sharaduro? Am curoyedǝmaa sharanuwi, mare? ");
INSERT INTO kby_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Am deyayedǝa Ala sharaji. «Kam diwidǝa dawundon tuluwowo!» ");
INSERT INTO kby_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Kamndo laa sonju kǝla kamanjuyen cǝdanaa, ndayin na muminnayero gǝni, na kǝrdiyayero lenuwe shara njaddidǝ? ");
INSERT INTO kby_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Ra, muminnadǝ duniaro shara caddiro nonuwwi wa? Koro nayima duniaro shara yidduwia, martawa lamar tǝngǝɍimaa sharaduye nagǝwwi wa? ");
INSERT INTO kby_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Malaiyawaro shara yiddiyero nonuwwi wa? Balle lamarra dunia adǝye? ");
INSERT INTO kby_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Adǝ nangaro lamarra ani gai shararo tawwaa, awiro am duwon na jama Isaa gawuyen awima gǝnidǝro sondo yaduwidǝ? ");
INSERT INTO kby_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Nangunoworo wullǝkki. Ngaima rashidu dawundon rakce katte kǝramiyayen shara kamji falma bawo wa? ");
INSERT INTO kby_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Kǝrami laa kǝrami kamanjua shararo cadi, koro adǝ fuwu ganambuwuyen! ");
INSERT INTO kby_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Awiro walyeno yaye, shara kattendon diodǝ njurondo. Jirenambu nayiro njaddiyama ngalwo, gǝna? Kǝndando jawuiyama ngalwo, gǝna? ");
INSERT INTO kby_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Amma nayi kǝlando jirenambu so, kǝnda bo so, har kǝramiyamaro yidduwi! ");
INSERT INTO kby_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ra, jirenambuwu nodo bargaa Alayen warasa cawandiwaworo nonuwwi wa? Bare jambaduwwi! Am diwi, bi sǝnǝm gawu, bi kǝnjǝnawu, bi kamukamu, bi luttuwu, ");
INSERT INTO kby_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","bi barwuwa, bi mangarduwu, bi mbalwu, bi raraduwu, bi jambawu fima nodo bargaa Alayea warasajaiwawo. ");
INSERT INTO kby_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Calan laandoma ngai. Amma nayia kasalnjana, tayirro walluwwa, koro cu Kǝmande Isa Almasiwuye-a Ruhu Alande-ayen jirewuro walluwwa. ");
INSERT INTO kby_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","«Awo samma wuro amardǝgǝna,» nuwi, amma awo samma gǝni faidaa wo. «Awo samma wuro amardǝgǝna,» amma wu kollǝkke awima sunodiwawo. ");
INSERT INTO kby_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","«Kǝmbodǝ curoye, curo ye kǝmboye,» nuwi, koro Ala tayi yindisoa baworo cǝdi. Tiyidǝ awo kǝnjǝnaye gǝni, tidǝ Kǝmandeye, koro Kǝmande ye tiyiye. ");
INSERT INTO kby_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Ala karmolan Kǝmadǝa cǝsangǝna, koro andi yea kǝnduwonjun sasangi. ");
INSERT INTO kby_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Tiyindodǝ nasha Almasiwuyero nonuwwi wa? To, nasha Almasiwuye ngokke nasha jawarrero dikki wa? A'a, tǝmmaro ngai gǝni! ");
INSERT INTO kby_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Ra, kam jawarro kǝldǝgǝnamadǝ ti-a rokko tiyi fallo waljanaro nonuwwi wa? Akko awo kitawu wuljǝnadǝ: «Tayi yindiso tiyi fallo waljai.» ");
INSERT INTO kby_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Amma kam Kǝmandero kǝldǝgǝnamadǝ ti-a rokko ruhu fallo waljai. ");
INSERT INTO kby_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Kǝnjǝnaro kadǝnowo! Biwu kam cǝdǝna samma deya tiyiyen kǝrga, amma kǝnjǝnama tiyinjumaro biwu cǝddi. ");
INSERT INTO kby_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ra, tiyindodǝ fado Ruhu Alaye, tidǝ nayin dǝgana, koro Alayen isiro nonuwwi wa? Nayidǝ kaando gǝni, ");
INSERT INTO kby_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Ala nayia tamanlan njasuwuna. Adǝ nangaro tiyindolan Alaro daraja yowo! ");
INSERT INTO kby_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Kǝla awowa wuro ruwusuwwadǝyen: «Kongwaye kamu ngodunambudǝma ngǝla wo.» ");
INSERT INTO kby_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Amma kǝnjǝna wadaro, kongwa fi yaye kamu ngojo, koro kamu fi yaye kwa cǝdo. ");
INSERT INTO kby_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Kwadǝ kamunjuro wajipnju co, koro kamudǝ ye kwanjuro ngai cǝddo. ");
INSERT INTO kby_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Kamudǝ tiyinjulan kǝnduwonju bawo, kǝnduwodǝ mukko kwanjuyen kǝrga. Ngaima kwadǝ ye tiyinjulan kǝnduwonju bawo, kǝnduwodǝ mukko kamunjuyen kǝrga. ");
INSERT INTO kby_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Bare wundundoma kamanjuro tiyinju dapcǝgǝnni, sai kasadduwe kawu ganaro kǝlando moduwa deworo faiduwiro kajia, daji kallo waldǝnowo, bare kǝlaɍiwonambundo nangaro Yiwulis nayia jaramnjanniro. ");
INSERT INTO kby_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Adǝa wuldunidǝ, wada gǝni, jawal laa. ");
INSERT INTO kby_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Am samma wu gairo waljaiya raakkǝna, amma kam fi yaye na Alayen kǝnjonju cǝmowona, laa ngai, laa ye ngai. ");
INSERT INTO kby_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Am kamu cadanni-a kamuwa kwa faccaanaa-adǝro wulgǝkki, naptu wu gailan dasaanama tayiro ngalwo. ");
INSERT INTO kby_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Amma rakcane kǝlanja caɍiwiwawoa, niya cado, jarawadǝroa niya diodǝma ngalwo. ");
INSERT INTO kby_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Am niya cadǝnadǝro wada adǝa yikki, wu gǝni, amma Kǝmande: Bare kamudǝ kwanju-a faidanni. ");
INSERT INTO kby_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Amma kwanju-a faidanaro walyenoa, niya bawoa napco, bi kwanju-a soloda. Koro kwadǝ ye bare kamunjua dǝpcǝnni. ");
INSERT INTO kby_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Am gapcanadǝro wuma adǝa wulgǝkki, Kǝmande gǝni: Kǝrami laa kamu Isaa gama gǝni cǝdanaa, koro kamudǝ ti-a rokko naptu kasaccǝnaa, bare kamudǝa dǝpcǝnni. ");
INSERT INTO kby_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Koro kamu laa kwa Isaa gama gǝni cǝdanaa, koro kwadǝ ti-a naptu kasaccǝnaa, bare kwadǝa wajǝnni. ");
INSERT INTO kby_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Awoa kwa Isaa gama gǝnidǝ kamunjuyen tayirro waljǝna, koro kamu Isaa gama gǝnidǝ kwanjuyen tayirro waljǝna. Adǝ gǝnia, yallando tayir gǝni, amma ngainin tayidǝ tayir. ");
INSERT INTO kby_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Amma ti Isaa gama gǝnidǝ faidu kirawoa, faida. Ngairo walyenoa, kǝrami kongwa bi kamudǝ tikkerǝnni, awoa nanlewan dǝgaro Ala nayia bowongera. ");
INSERT INTO kby_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ni kamu, ndayin gǝle kwanǝmba yikkagǝmiro nonǝmi? Koro ni kwa, ndayin gǝle kamunǝmba yikkagǝmiro nonǝmi? ");
INSERT INTO kby_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Biya wundu yaye, Ala tia bowojǝnadǝ gai, naptu duwon Kǝmande tiro amarjǝgǝnadǝlan dǝga. Adǝma wada jama Isaa gawu sammayero yikkidǝ wo. ");
INSERT INTO kby_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Kam duwon sa tia bowojanalan kajanjuadǝ, bare kajadǝnniro waljǝnni. Ti jǝmbǝlǝmlan bowojanadǝ, bare kajadǝnni. ");
INSERT INTO kby_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Kajadǝ awima gǝni, kajanambudǝ ye awima gǝni, wada Alaye ga faidaa wo. ");
INSERT INTO kby_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Wundu yaye naptunju sa tia bowojanadǝyen dǝga. ");
INSERT INTO kby_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Ni kaɍea duwon bowongeraa, bare suwoldǝmmi, amma dama nankam kǝlaye fandǝmia, faidadǝne. ");
INSERT INTO kby_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Kam ti kaɍea duwon Kǝma tia bowojǝnadǝ, na Kǝmayen ti nankam kǝlaye cǝdana. Jiɍi adǝgainin kam duwon Kǝma tia nankam kǝlayea bowojǝnadǝ, ti kaɍea Almasiwuye. ");
INSERT INTO kby_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ala nayia tamanlan njasuwuna, bare kaɍea kambero walluwwi. ");
INSERT INTO kby_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Kǝramiya, wundu yaye naptu duwon Ala tia bowojǝnadǝn na Alayen dǝga. ");
INSERT INTO kby_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Kǝla ferowa kwa nojanniyen wada Kǝmandeye takkǝni, amma kam duwon kanjimaɍi Kǝmandeyen amannadǝ gai, kuroni yikki. ");
INSERT INTO kby_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Awo rukkidǝ tima suwol kǝrmayedǝro ngai naptudǝma kambo ngalwo. ");
INSERT INTO kby_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ni kamuaa, bare faidu manǝmmi. Kamu bawoaa, bare kamu ngonǝmmi. ");
INSERT INTO kby_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Amma kamu ngonǝmiro walyenoa, biwu dimmi. Koro fero kwa nojǝnni kwa cǝdiro walyenoa, biwu cǝdǝnni. Adǝ yaye am ani gai dunia adǝn bone casai, amma wudǝ adǝro kanuwiya, raakko. ");
INSERT INTO kby_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Kǝramiya, awo wullǝkkidǝ: Sa karǝnjǝna. Kua adǝn fuwun am kamu cadanadǝ kamu cadanni gairo walja, ");
INSERT INTO kby_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","am cesiridǝ ye cesiriwawo gairo walja, am karwukǝji cadidǝ ye karwukǝji cadiwawo gairo walja, am casuwidǝ ye awima cadanni gairo walja, ");
INSERT INTO kby_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","koro am dunia adǝn faidadaidǝ ye tiro duno cadǝnni gairo walja, alama dunia adǝye baworo tǝdi nangaro. ");
INSERT INTO kby_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Nayi suwol bawoaro walluwiya, raakko. Kam kamu cǝdannidǝ awowa Kǝmayero suwolde jiɍi cǝde ardiyanju cuwandoro maji. ");
INSERT INTO kby_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Amma kam kamuadǝ kǝla awowa dunia adǝyero suwolde jiɍi cǝde ardiya kamunjuye cuwandoro maji, ");
INSERT INTO kby_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","hangalnju yaktǝna. Koro kamu kwa bawoadǝ-a fero kwa nojǝnnidǝ-a kǝla awowa Kǝmandeyen suwoldai, tiyi yelan, ruhu yelan tayir napcaro. Amma kamu kwaadǝ kǝla awowa dunia adǝyero suwolde jiɍi cǝde ardiya kwanjuye cuwandoro maji. ");
INSERT INTO kby_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Adǝa wuldunidǝ, katkun gǝnaduwuro gǝni, nayia banaduwuro, naptu jussǝna dewo, hangal yaktǝnnin Kǝmandea gaiworo. ");
INSERT INTO kby_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Kam laa tǝmajinjuro awo jussǝnni cǝddiro tǝmajǝnaa, koro jauro mǝradunjua duwon lamardǝ ngai wajipcǝnaa, awo cǝraanadǝa cǝdo, niya cado, biwuro waljiwawo. ");
INSERT INTO kby_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Amma kam curo karwunjuyen nia dunoa ngojǝna, tiro dolero waljǝnni, rawonju, koro tia tǝmajinju gai roduro karwunjun nia ngojǝnadǝ, awo ngǝla cǝdi. ");
INSERT INTO kby_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Jiɍi adǝgainin kam tǝmajinju ngojǝnadǝ awo ngǝla cǝdi, koro kam ngojǝnnimadǝ adǝa kojǝna cǝdi. ");
INSERT INTO kby_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Kamudǝ kwanju roaa tiro kǝllaada, amma kwadǝ bawoyenoa, rakce kam cǝraanaa niyaji, amma Kǝmaa gamaro waljo. ");
INSERT INTO kby_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Amma wuyenna ngai naptudǝma tiro bargaa wo, koro kuronin wu yelan Ruhu Alayea. ");
INSERT INTO kby_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Kǝla da sǝnǝmbo tinayen, andi samma ilmu taiyenaro noniyena. Ilmudǝ kamba fujiyi, amma kǝrawodǝ dunoaro cǝdi. ");
INSERT INTO kby_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Kam duwon kǝlanjua awo laa nojǝnaro ngoyenoa, koroma jiɍi wajipcǝnadǝ gairo nojǝnni, ");
INSERT INTO kby_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","amma kam laa Alaa kirawoa, Ala tia nojǝna. ");
INSERT INTO kby_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","To, kǝla da sǝnǝmbo tinaa ngǝroyen, sǝnǝm dunialan awima gǝni ye, Ala tilodǝro kajia, gade bawo yero noniyena. ");
INSERT INTO kby_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Awoa alawa laa same yen kal, cidiya yen kal mbeji cani yaye, alawa kada-a kǝmawa kada-a mbejidǝ gai, ");
INSERT INTO kby_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","adǝ yaye nanden Aladǝ tilo, ti Bawa, tilan awi yaye isi, ti nangaro kǝrgaiye, koro Kǝmande Isa Almasiwudǝ ye tilo, tiyen awi yaye isi, tiyen kǝrgaiye. ");
INSERT INTO kby_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Amma am samma gǝni ilmu adǝa cada. Laanja gumkiyaa caɍinadǝro har kǝrmaro da jagariya, sǝnǝmbo tinadǝ gairo jagari, koro karwunja kibbajǝnnidǝ tayir gǝniro walji. ");
INSERT INTO kby_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Kǝmbo gǝni sasakke Alaa karǝnniye. Bo waniyea, tǝgǝrdiyewawo. Buiyea, tǝrgaiyewawo. ");
INSERT INTO kby_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Amma hangal gǝnanowo, bare nankam kǝlayendo adǝ am lawudǝa cakke taljanni. ");
INSERT INTO kby_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Kam laa karwunju kibbajǝnni duwon ni ilmuadǝ fado sǝnǝmben masǝna dimi ngiroa, adǝ cakke da sǝnǝmbo tinaa jǝgǝriwawo wa? ");
INSERT INTO kby_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Ngainin kǝla ilmunǝmben kǝrami lawu duwon ti nangaro Almasiwu nunadǝ facciyi. ");
INSERT INTO kby_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Kǝramiyandoro biwu ngainin yidduwiya, koro karwunja kibbajǝnnidǝa lorunuwiya, Almasiwumaro biwu kidduw. ");
INSERT INTO kby_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Adǝma nangaro da ngǝrodǝ cakke kǝramini taljiro walyenoa, gadero da ngǝrǝkkiwawo, bare kǝraminia yakkǝkke taljǝnniro. ");
INSERT INTO kby_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Wu kambe, gǝna? Wu kǝngayam, gǝna? Isa Kǝmandea rukkǝni wa? Nayima gǝna kidani Kǝmandelan dikkǝnadǝ wo? ");
INSERT INTO kby_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Am gade nankǝngayammidǝa kasaccaiwawo yaye, fagat nandon wu kǝngayam, Kǝmandelan nayima tawa nankǝngayammi tabbacciyidǝ wo. ");
INSERT INTO kby_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Adǝma awo am ayau gǝnasagaidǝro kalangǝkkidǝ: ");
INSERT INTO kby_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Kǝnduwo kǝmbo-a kǝnja-a fandoye taiyende wa? ");
INSERT INTO kby_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Kǝnduwo kamunde Isaa gama-a rokko bǝlawuroduye kǝngayamba gade so, yaanawa Kǝmaye so, Kefas so cadidǝ gai taiyende wa? ");
INSERT INTO kby_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Wu-a Barnabas-a runde wa kǝnduwo kida dionambuye taiyende wo? ");
INSERT INTO kby_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Wundu ngalte yaye kida sojiye cǝdi duwon wuɍinjulan ambadidǝ? Wundu ya inabbe kokci duwon tadanju caiwawodǝ? Wundu lǝmanna cǝneyi duwon kiam lǝmannayedǝa caiwawodǝ? ");
INSERT INTO kby_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Kǝla mana kamben wa awo ania wullǝkki? Attaura ye ngai wuljǝnni wa? ");
INSERT INTO kby_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Akko awo Attaura Nawi Musayen ruwuwadadǝ: «Bare dalo wastu cǝdi duwon cinjuro cambu yakkǝmmi.» Ala daloro wa lambonjua wo? ");
INSERT INTO kby_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Fagat andi nangaro adǝa wulji, mare? Aaa, andi nangaro awo adǝ ruwuwada: «Baremadǝ tǝmanjualan bare cǝdo, wastumadǝ ye nuwanju cuwandiro tǝmajo cǝdo.» ");
INSERT INTO kby_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Awowa Ruhuye karwundolan nadiyenadǝ, awo duniaye nandon kaladundedǝ awo laa kura wa? ");
INSERT INTO kby_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Am gade kǝnduwo nuwanja nandon mowoye cadanaa, andidǝ tayia kojǝnaro taiyena, gǝna? Adǝ yaye kǝnduwo adǝlan faidadiyende, curo jǝktu fiyen yaye mǝrniye, bare kawuɍi kǝji Almasiwuyedǝro takkal fima yakkiyendero. ");
INSERT INTO kby_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Am kida Fado Alayen cadidǝ kǝmbo Fado Alayen jawui, koro am laya duwaduramnin kida cadidǝ nuwanja laya duwaduramdǝlan cawandiro nonuwwi wa? ");
INSERT INTO kby_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Jiɍi adǝgai Kǝmande wada ce am kawuɍi kǝji mawodumaso kida kawuɍi kǝjiyen awo kǝndǝgainjaye cawando cǝnna. ");
INSERT INTO kby_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Amma wudǝ kǝnduwo aniye falnjamalan faidadǝkkǝni, koro nuwani fandoro gǝni awo ania ruwunǝkki. Awulo boni cattuluwiro nukkǝnama ngalwo. ");
INSERT INTO kby_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Kawuɍi kǝji wuldunidǝ dalil awulo boye gǝni, wuldunjudǝ wajimsǝgǝna. Kawuɍi kǝjidǝa wullǝkkiwaworo walyenoa, kuttuni! ");
INSERT INTO kby_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Awo adǝa rawonin dikkia, alwasi fandǝkki, amma rawonin gǝnia, nanwakkil mukkoniro casakkǝna. ");
INSERT INTO kby_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","To, awi gǝle alwasini wo? Kawuɍi kǝji wullǝkkidǝa kǝnduwo duwon kawuɍi kǝji adǝ sinadǝn faidadǝkkǝnin dero kǝnjoro. ");
INSERT INTO kby_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Na am sammayen wu kambe duwon, ngǝwunjaa mowokkoro kǝlania kaɍea tayi sammayero kalakkekko. ");
INSERT INTO kby_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Na yaudiyayen, yaudiya njǝkkawo cawandoro, yaudi gairo walyekko. Na am fǝrdu wada Attaurayen dasaanayen, wu kǝlani fǝrdu wadayen dǝgakkǝni yaye, kam fǝrdu wadayen dǝgana gairo walyekko, am fǝrdu wadayen dasaana njǝkkawo cawandoro. ");
INSERT INTO kby_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Am wada cadannidǝa mowokkoro, wu ye kam wada cǝdanni gairo walyekko, amma wudǝ kam wada Alaye cǝdanni gǝni, fǝrdu wada Almasiwuyen kǝrgakko. ");
INSERT INTO kby_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Na am lawuyen lawuro walyekko, tayi lawudǝ njǝkkawo cawandoro. Adǝgaima na am sammayen awo sammaro wallǝkkǝna, jiɍi fin yaye laanjaa yikkagǝkkoro. ");
INSERT INTO kby_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Kawuɍi kǝji nangaro ani sammaa dikki, tilan nuwani fandǝkkoro. ");
INSERT INTO kby_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Curo ngǝrǝm siyen ngǝrǝmgu samma ngǝrǝmjai yaye, tilo lon ladadǝa cuwandiro nonuwwi wa? Jiɍi diwe fanduwiro ngǝrǝmmowo! ");
INSERT INTO kby_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Am bikkelan ngǝnǝptaidǝ jawal samman kǝlanja caɍiwi. Tayidǝ aɍiawu kǝnnasarre dǝgaiwawo moworo adǝa cadi, amma andidǝ aɍiawu sawisoro dǝgai moworo diye. ");
INSERT INTO kby_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Wudǝ kam na leduye bawo gairo gǝni ngǝrǝmmǝkki, koro dambenidǝ kam kasam bakci gairo gǝni bangǝkki, ");
INSERT INTO kby_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","amma bare ngawo kawuɍi am gadero wulgǝkkǝnayen wu kǝlani curonjan baworo wallǝkkǝniro tiyini jauro ngǝnǝmmǝkke kǝlani ɍiwukki. ");
INSERT INTO kby_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Kǝramiya, adǝa nonuwiya, raakko: Kaariyande samma cidiya fofouyen dasaana, tayi samma bǝrǝm faljane kojana, ");
INSERT INTO kby_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","koro tayi sammaro curo fofoudǝ-a bǝrǝmdǝ-ayen kasala cadde Nawi Musaro kǝlyeyera. ");
INSERT INTO kby_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Tayi samma kǝmbo Ruhuyedǝmaa gewo, ");
INSERT INTO kby_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","koro tayi samma kǝnja Ruhuyedǝmaa kesa, awoa kau Ruhuye tayia jǝgaidǝyen casana, kau adǝ tima Almasiwu wo. ");
INSERT INTO kby_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Adǝ yaye Ala ngǝwunjaye kǝjinja fanjǝnni, koro karaa dǝɍiro kaminnjaa tataryeyeno. ");
INSERT INTO kby_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Lamarra ani andiro misallo walseyera, jiɍi awo diwi mangarjanadǝ gai, bare mangarniyendero. ");
INSERT INTO kby_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Bare sǝnǝm gawu amnja laa gairo walluwwi, kitawulan ruwuwadadǝ gai: «Jamadǝ kǝmbo-a kǝnja-aro napkera, koro bikke randoro ciyera.» ");
INSERT INTO kby_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Bare kǝnjǝna diyende, amnja laa cade yim falnin am dǝwu findin yakkun sanunadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Bare Almasiwua jarammiyende, amnja laa cade kadiya tayia ceyesǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Bare karwukutta fǝlenuwwi, amnja laa cade siduwuma tayia sijǝgǝnadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Lamarra ani tayiro misallo wakkajaana, koro sǝmonde kasturo ruwuyera, andi duwon sa njeroramben dǝgaiyenadǝ. ");
INSERT INTO kby_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Adǝ nangaro wundu duwon ti daadaro tǝmajǝnadǝ bare curǝnniro hangal gǝnajo! ");
INSERT INTO kby_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Jaraptu am sammaa cuwandǝna gǝnia, jaraptu fima nayia njawandǝnni. Ala amanma, kolje dunondo kojǝnaro jaramnjaiwawo, amma jaraptu isiya, ranguwe nedduwiro jawal luwoye njadi. ");
INSERT INTO kby_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Adǝ nangaro, kǝrawowuni, sǝnǝm garo kadǝnowo! ");
INSERT INTO kby_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Nayiro am hangalla gairo jandenjagakki. Nayi kǝlando awo wullǝkkidǝa sharanowo! ");
INSERT INTO kby_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Kǝnjaram bargaa ti nangaro Alaa wuseniyedǝ, tilan gǝna bu Almasiwuyero kǝldiyiye? Koro burodi fǝsangiyedǝ, tilan gǝna tiyi Almasiwuyero kǝldiyiye? ");
INSERT INTO kby_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Burodi fal dǝgadǝ, andi ngǝwu yaye, tiyinde falma, awoa andi samma burodi faldǝa ngǝriye. ");
INSERT INTO kby_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Israyilawua tangowo: Tayi laya jagaridǝ laya duwaduramdǝro kǝldaana, gǝna? ");
INSERT INTO kby_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","To, awi wullǝkki? Da sǝnǝmbo tinadǝ-a sǝnǝmdǝma-a awo laa wo? ");
INSERT INTO kby_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","A'a, amma layanjadǝ Alaro gǝni, sedannaro duwajagai. Sedannaro kǝldǝgǝwiya, raakkǝni. ");
INSERT INTO kby_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ranguwe kǝnjaram Kǝmaye-a kǝnjaram sedannaye-ayen yawwawo. Ranguwe tewur Kǝmaye-a tewur sedannaye-alan masǝna diwwawo. ");
INSERT INTO kby_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Ra, yakkiye Kǝmaa nandǝɍi cǝdai? Tia dunon koniyena wa? ");
INSERT INTO kby_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","«Awi yaye amardǝgǝna,» amma awo samma gǝni faidaa wo. «Awi yaye amardǝgǝna,» amma awo samma gǝni kamba dunoaji. ");
INSERT INTO kby_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Wundu yaye awo ngǝla kǝlanjuro gǝni, am gadeyero majuwo! ");
INSERT INTO kby_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Awo haumadin caladi sammaa buiwo, bare saɍiwu karwuye nangaro kǝlanjun kokoruwwi, ");
INSERT INTO kby_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","«Dunia-a awowa curonjun dasaana samma-a Kǝmandeye,» nangaro. ");
INSERT INTO kby_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Kam laa Isaa gama gǝni nayia donjane kasadduwe lenuwiya, awo fuwundoro casakkǝna sammaa buiwo, bare saɍiwu karwuye nangaro kǝlanjun kokoruwwi. ");
INSERT INTO kby_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Amma kam laa nayiro: «Adǝ sǝnǝmbo tina,» cǝnia, kam nayiro isanonjaanadǝ-a saɍiwu karwuye-a nangaro bare buwwi. ");
INSERT INTO kby_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Karwu kaando gǝni, kaanju wullǝkki. Awiro gǝle saɍiwu karwu kam gadeye nankam kǝlayeni sharaji? ");
INSERT INTO kby_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Alaa wusenǝkke bukkia, awiro gǝle kǝla awo duwon ti nangaro Alaa wusenǝkkǝnadǝyen wua sharasai? ");
INSERT INTO kby_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Buwi yen kal, yawi yen kal, awo diwi samma yen kal, awi yayea daraja Alayero dewo. ");
INSERT INTO kby_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Bare yaudiya-a yaudiya gǝni-a jama Alaye-aa yakkuwe taljanni, ");
INSERT INTO kby_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","wu ye jawal fin yaye ardiya am sammaye makkidǝ gai. Awoa wuro gǝni, am ngǝwuro awo faidaa makki, njǝkkawo cawandoro. ");
INSERT INTO kby_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Halnia gaiwo, jiɍi wu ye hal Almasiwuyea gakkidǝ gai. ");
INSERT INTO kby_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Awi yayen wua tansuwe alamdu jiɍi nayiro njaddǝkkǝnadǝa ngǝlaro gawi nangaro nayia wusenjakki. ");
INSERT INTO kby_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Adǝ yaye awo adǝa nonuwiya, raakko: Fuwuma kongwa sammayedǝ tima Almasiwu wo, fuwuma kamuyedǝ tima kwanju wo, koro fuwuma Almasiwuyedǝ tima Ala wo. ");
INSERT INTO kby_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kongwa duwon moduwa bi nawinawi kǝla jakkadaa cǝdidǝ fuwumanjua nanguro cakki. ");
INSERT INTO kby_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Amma kamu duwon moduwa bi nawinawi kǝla kaadaa cǝdidǝ fuwumanjua nanguro cakki, kǝlanju tǝlarǝna-a kal wo. ");
INSERT INTO kby_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Awoa kamu kǝlanju jakciwawoa, gǝrǝpca. Kǝla gǝrǝptu bi larodǝ na kamuyen awo nanguyea, kǝlanju jakco. ");
INSERT INTO kby_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Kongwaye kǝla jaktudǝ jussǝnni, ti camuno-a daraja-a Alaye nangaro, amma kamudǝ daraja kongwaye. ");
INSERT INTO kby_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Awoa kongwa gǝni kamuyen culuwo, amma kamu kongwayen culuwo. ");
INSERT INTO kby_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Koro kongwaa gǝni kamu nangaro alakca, amma kamudǝa kongwa nangaro alakca. ");
INSERT INTO kby_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Dalil adǝro alama kǝnduwoye kǝlanjun gǝnadudǝ malaiyawa nangaro kamuro wajipcǝgǝna. ");
INSERT INTO kby_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Adǝ yaye na Kǝmandeyen kamudǝ kongwa-a faiyada gǝni, kongwadǝ ye kamu-a faiyada gǝni. ");
INSERT INTO kby_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Jiɍi kamudǝ kongwayen isǝnadǝ gai, kongwadǝ ye tambo kamuyen isi, adǝgaima awi yaye Alayen isi. ");
INSERT INTO kby_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Nayi kǝlandoma sharanowo: Kamu kǝla jakcǝnnin Alaa cuworidǝ jussǝna wa? ");
INSERT INTO kby_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Kǝla kǝndǝgai duniayen, kongwaye kanduɍinju kuruwua tiro awo nangua yaye, ");
INSERT INTO kby_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","kamuye kanduɍinju kuruwuro ɍijiya, tiro awo darajaye, gǝna? Awoa kanduɍinjudǝa jakturam gairo tiro cadǝna. ");
INSERT INTO kby_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Kam laa kǝla adǝyen kambiwudu cǝraanaa, alamdu gade taiyende, jama Alaye gadegadeso ye cadanni. ");
INSERT INTO kby_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Amma kǝla wada adǝyen nayia wusenjakkiwawo, serro gǝni, sernamburo captuwi nangaro. ");
INSERT INTO kby_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Burwon cammo jama Alayero captuwiya, kattendon yaktuwwa cani fakkǝna, koro gana jirero ngokkǝna. ");
INSERT INTO kby_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Ai, sai kattendon yaktuaro waljiya, ngainin am curondon ardiyadadǝ nowadaro waljai! ");
INSERT INTO kby_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ase, sa captuwiya, masǝna Kǝmaye gǝni buwi. ");
INSERT INTO kby_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Sa masǝnadǝyen wundundo yaye namuje kǝmbonju ngoje juwui, ngainin kam laa kǝnaa, kam laa ye sagarandǝna. ");
INSERT INTO kby_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","A! Kǝmbo-a kǝnja-adǝro fanndo bawo wa? Ra, jama Alayero rudu gǝnagǝwe am awima cadannidǝa nanguro yakkuwi? To, awi gǝle nayiro wulnjagakki? Nayia wusenjakki? A'a, kǝla adǝyen nayia wusenjakkiwawo. ");
INSERT INTO kby_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Awo Kǝmandeyen mowokkǝnadǝa nayi yero njaddǝkkǝna: Kǝmande Isa bune tia sǝrǝccaanadǝn burodi ngoje ");
INSERT INTO kby_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Alaro ardiyenniya, fǝsakce: «Adǝ tiyini nayi nangaro tinadǝ. Wua takturo adǝa dewo!» cǝnna. ");
INSERT INTO kby_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Jiɍi adǝgainin koro ngawo masǝnayen kǝnjaram ngoje: «Kǝnjaram adǝ aman bǝɍin bunilan ndǝpkada. Yimbi yaye tia yawiya, wua takturo dewo!» cǝnna. ");
INSERT INTO kby_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Awoa yimbi yaye burodidǝa ngǝruwe kǝnjaramdǝyen yawiya, karmo Kǝmandeye mawonuwi, har kawu walde isiro. ");
INSERT INTO kby_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","To, kam jiɍi jussǝnnin burodidǝa jǝgǝri bi kǝnjaram Kǝmayen caidǝ tiyi-a bu-a Kǝmandeyero biwu cǝddo. ");
INSERT INTO kby_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Wundu yaye kǝlanju jarapco duwon, ngainin burodidǝa jǝgǝro, kǝnjaramdǝ yen ca. ");
INSERT INTO kby_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Awoa kam tiyi Kǝmayea asujǝnnin jǝgǝri bi caidǝ, bonju-a kǝnjanju-ayen wowom kǝlanjuro gǝrjiyi. ");
INSERT INTO kby_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Adǝmaro curondon am ngǝwu duno bawoa ye, dondi ye, kada ye sanuna. ");
INSERT INTO kby_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Jiremaro kǝlande jarammiyero walyenoa, andiro shara saddiwawo, ");
INSERT INTO kby_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","amma Kǝmadǝ andiro shara saddiya, andia jawallo sasakki, ngainin am duniaye-a rokko andiro wowom gǝnasagaiwawo. ");
INSERT INTO kby_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","To, kǝramiyani, masǝna dioro captuwiya, wundu yaye kamanjua gurejo. ");
INSERT INTO kby_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Kam laa kǝnanjuaa, fadon juwo, ngainin captuwiya, nayiro shara njaddiwawo. Waldǝkke isǝkkiya, kǝla awo gapcǝnadǝyen gala yikki. ");
INSERT INTO kby_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Kǝramiya, kǝla kǝnjowa Ruhu Alayen, curo nanjayillen dǝgawiya, raakkǝni. ");
INSERT INTO kby_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Sa nayi kǝrdiyadǝn, kolluwe jawal sǝnǝmba mana cadiwawoyero tǝmbalnjaanaro nonuwwa. ");
INSERT INTO kby_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Adǝmaro nayiro isanonjagakki, wundumaye Ruhu Alayen: «Isa baskuwada,» cǝniwawo, koro Ruhu Alayen gǝnia, wunduma rakce: «Isama Kǝma wo,» cǝniwawo. ");
INSERT INTO kby_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Kǝnjo jiɍi jiɍi mbeji, amma Ruhudǝ falma, ");
INSERT INTO kby_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","kida jiɍi jiɍi ye mbeji, amma Kǝmadǝ falma, ");
INSERT INTO kby_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","koro kǝndo jiɍi jiɍi ye mbeji, amma Aladǝ falma, ti duwon tayi sammaa am sammalan kidajidǝ. ");
INSERT INTO kby_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Faida jamaye nangaro Ruhu Alaye kam fi yayen kǝnjo laan fǝledi. ");
INSERT INTO kby_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Kam laaro Ruhudǝyen mana nanrashiduye cadi, laa yero Ruhudǝyeman mana ilmuye cadi, ");
INSERT INTO kby_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","laa yero Ruhu faldǝyeman kambǝrse cadi, laa yero Ruhudǝyeman kǝnjowa amba ngaduye cadi, ");
INSERT INTO kby_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","laa yero awo ajabba ajabba dioye, laa yero nawinawi dioye, laa yero ruhuwaa gayirduye, laa yero tǝlam jiɍi jiɍi wulduye, laa yero tǝlamba fisarduye. ");
INSERT INTO kby_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Ruhu faldǝma awo ani sammaa kidaje kam fi yayero kǝnjo kalkallo ci, jiɍi cǝraanadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Jiɍi tiyidǝ falma, nashawanju kada, koro nashawa tiyiye samma ngǝwu duwon, tiyidǝ falmadǝ gai, Almasiwudǝ ye ngai. ");
INSERT INTO kby_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Yaudi yen kal, yaudi gǝni yen kal, kaɍea yen kal, kambe yen kal, Ruhu faldǝyen andi sammaro kasala sadde tiyi faldǝro kǝlseyera, koro andi sammaa sasakke Ruhu faldǝyeman kiaye. ");
INSERT INTO kby_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Awoa tiyidǝ nasha fal gǝni, kada. ");
INSERT INTO kby_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Siye: «Wu mukko gǝni nangaro, wu nasha tiyiye gǝni,» cǝnia, adǝ cakke nasha tiyiye gǝniro walji wa? ");
INSERT INTO kby_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Koro sǝmoye: «Wu sim gǝni nangaro, wu nasha tiyiye gǝni,» cǝnia, adǝ cakke nasha tiyiye gǝniro walji wa? ");
INSERT INTO kby_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Tiyidǝ samma simba, sǝmon fandudǝ ndaran? Samma sǝmoa, kinjan fandudǝ ndaran? ");
INSERT INTO kby_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Amma Ala kǝla rawonjuyen nasha fi yayea tiyilan gǝnayeno. ");
INSERT INTO kby_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Tayi samma nasha falla, tiyidǝ ndaran? ");
INSERT INTO kby_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Awoa nashawadǝ kada, amma tiyidǝ falma. ");
INSERT INTO kby_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Sim rakce mukkoro: «Nin mǝraduni bawo!» cǝniwawo, kǝla ye rakce siro: «Nin mǝraduni bawo!» cǝniwawo. ");
INSERT INTO kby_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Ngai gǝni, amma nashawa tiyiye lawuro caruidǝ jauro faidaa. ");
INSERT INTO kby_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Nashawa tiyiye duwon ruwadaro ngoniyenadǝro jauro daraja yiye, koro nashawande nanguadǝro ngǝlaro kissiyiye, ");
INSERT INTO kby_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","nashawande kuroro ngǝladǝro sai awo laa tǝddiya gǝni. Amma Ala tiyidǝa alakce nashawa daraja bawoadǝro jauro daraja kaino, ");
INSERT INTO kby_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","bare tiyilan yakta wakkajǝnni, amma nashawadǝ kattenjaro kissaa. ");
INSERT INTO kby_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Nasha laa jau fanjiya, nasha samma ye rokko jau fanjai. Nasha laa daraja cuwandiya, nasha samma ye rokko kǝji fanjai. ");
INSERT INTO kby_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Nayidǝ tiyi Almasiwuye, wundundo yaye tiyidǝye nashanju. ");
INSERT INTO kby_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Koro Ala curo jamanjuyen burwon kǝngayamba galajǝna, kǝnyindiyen nawiya, kǝnyakkuyen malǝmba, ngawo adǝyen kǝnjo awo ajabba ajabba dioye, daji kǝnjowa amba ngaduye so, banaduwuye so, nodoye so, koro kǝnjowa tǝlam jiɍi jiɍi jandeduye so. ");
INSERT INTO kby_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Tayi samma kǝngayamba wa? Samma nawiya wa? Samma malǝmba wa? Samma awo ajabba ajabba cadi wa? ");
INSERT INTO kby_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Samma kǝnjo isangaduwuye cadana wa? Samma tǝlambalan jandejai wa? Samma fisarjai wa? ");
INSERT INTO kby_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Amma kǝnjowa ngalwodǝa jauro rawowo! Koro nayiro jawal awi yayea kojǝnaa fǝlenjagakki. ");
INSERT INTO kby_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Tǝlamba ambe-a malaiyawaye-alan jandenǝkki yaye, amma kǝrawo wulan baworo walyenoa, wudǝ nuktu suye kalala ngǝwua bas. ");
INSERT INTO kby_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Koro nawinawi dikke asǝr-a ilmu-a sammaa asukke kambǝrse har kau kuruwu sǝnaktuye takkǝna yaye, amma kǝrawo wulan baworo walyenoa, wudǝ awima gǝni. ");
INSERT INTO kby_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Koro kǝndani takkǝna sammaa sadaaro yikke tiyini ye warduro sǝrǝtkǝkki yaye, amma kǝrawo wulan baworo walyenoa, riwani bawo. ");
INSERT INTO kby_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Kǝrawodǝ kanadia ye, serra ye. Kǝrawodǝ, nandǝɍi tia cǝdaiwawo, awulo juwuiwawo, rokura ye cǝdiwawo, ");
INSERT INTO kby_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","tidǝ awima candǝnni cǝdiwawo, kǝlanjuro majiwawo, duwan gǝrgajiwawo, awo diwi karwun rojiwawo, ");
INSERT INTO kby_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","tidǝ kǝla nandiwiyen karwukǝji fǝlejiwawo, amma kǝla awo jireyen karwukǝji fǝleji. ");
INSERT INTO kby_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Kǝrawodǝ awo sammaa gawurji, awo sammaa mǝrsaji, awo samman tǝmaji, awo samman necci. ");
INSERT INTO kby_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Kǝrawodǝ tǝmmaro ceriwawo. Nawinawi diodǝ, baworo walji. Tǝlamba gaden mana diodǝ, ceri. Ilmudǝ, baworo walji. ");
INSERT INTO kby_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Awoa ilmundedǝ ye cinjua, koro nawinawindedǝ ye cinjua, ");
INSERT INTO kby_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","amma awo kalkaldǝ isiya, sadǝn awo cinjuadǝ baworo walji. ");
INSERT INTO kby_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Gananilan jandenidǝ jande tadaanaye, hangalnidǝ ye hangal tadaanaye, koro tǝmanidǝ ye tadaanaye. Wurayekkǝniya, awowa tadaanayedǝa kolyekko. ");
INSERT INTO kby_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Kǝrma misal kudǝramben gainin buji buji ruiye, amma sadǝn sim-a sim-alan ruiye. Kǝrma nodunidǝ cinjua, amma sadǝn Ala wua kalkallo nosǝnadǝ gai kalkallo nokki. ");
INSERT INTO kby_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Kǝrma awo yakku ani dasayi: kambǝrse-a tǝma-a kǝrawo-a, amma tayi sammalan kǝrawodǝ tima kura wo. ");
INSERT INTO kby_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Kǝrawo manowo, kǝnjowa Ruhu Alaye fando jauro rawowo, masammanno nawinawi dio. ");
INSERT INTO kby_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Kam tǝlam gaden jandejimadǝ ambo gǝni, Alaro jandejiyi, awoa wunduma awo wuljidǝa asujiwawo, dalilnjudǝ Ruhu Alayen awowa asǝrre jandeji nangaro. ");
INSERT INTO kby_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Amma kam nawinawi cǝdimadǝ ambo jandejiye tayia isadunoajiyi, karwunjaro duno ci, kǝrawolan ronja ye isabojiyi. ");
INSERT INTO kby_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Kam tǝlam gaden jandejimadǝ kǝlanjuro duno ci, amma kam nawinawi cǝdimadǝ jama Isaa gawuro duno ci. ");
INSERT INTO kby_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Nayi samma tǝlamba gaden jandenuwiya, raakko, amma adǝa kojǝnaro nawinawi diwiyama, raakko. Kam nawinawi cǝdimadǝ kam tǝlambalan jandejimadǝa kojǝna, kam laa fisarje jamadǝro duno ci gǝnia. ");
INSERT INTO kby_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","To, kǝramiya, nandoro isǝkke nayiro wahayi so, ilmu so, nawinawi so, alamdu solan gǝni, tǝlambalan jandengeyerakkoa, awi gǝle nayiro faidanju wo? ");
INSERT INTO kby_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Awowa ro bawoa algaida bi kumbi gai kowonja kalkallo nukcaiwawoa, ndayin gǝle awo fujai bi jajaidǝ asudi? ");
INSERT INTO kby_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Koro kangadi kalkallo fujaiwawoa, wundu gǝle kǝriwuro dabbardi? ");
INSERT INTO kby_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","Nayi ye ngai. Tǝlamndon mana kalkal gǝni diwia, ndayin gǝle awo wulluwidǝ asudi? Mana karaa dero yidduwi. ");
INSERT INTO kby_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Dunian tǝlamba jiɍi jiɍi kada mbeji, koro tǝlam maananju bawoa falma bawo. ");
INSERT INTO kby_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Adǝ nangaro tǝlambe maananju nokkǝniro walyenoa, kamdǝro kusottoro wallǝkkǝna, kamdǝ ye wuro kusottoro waljǝna. ");
INSERT INTO kby_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","Nayi ye ngai. Kǝnjowa Ruhuyedǝa fando jauro raawwa nangaro, awo jama Alayea isadunoajiyidǝa ngǝwuro manowo. ");
INSERT INTO kby_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Adǝma nangaro kam tǝlam gaden jandejimadǝ kǝnjo fisarduye cuwandoro moduwa cǝdo. ");
INSERT INTO kby_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Tǝlam gaden moduwa dikkia, ruhunidǝ moduwa cǝdǝna, amma hangalnidǝ awimaro faidajǝnni. ");
INSERT INTO kby_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","To, awi gǝle dikki? Ruhunin moduwa dikki, koro hangalni yen moduwa dikki. Ruhunin aiya njungoroye yekki, koro hangalni yen aiya njungoroye yekki. ");
INSERT INTO kby_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Adǝ gǝnia, ruhunǝmlan Alaa wusenǝmiya, kam duwon awo ania nojǝnnidǝ awo wullǝmmadǝa asujiwawoa, ndayin gǝle wusedunǝmdǝro «Amin!» cǝni? ");
INSERT INTO kby_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Ngǝlaro Alaa wusenǝmi yaye, kamanǝmdǝye karwunju dunoajiwawo. ");
INSERT INTO kby_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Tǝlamba gaden jandedun nayi sammaa konjakkǝna nangaro Alaa wusenǝkki, ");
INSERT INTO kby_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","amma dawu jama Alayen kalma dǝwu mewu tǝlamlan wullǝkki yayero am gadea alammǝkkoro kalma uwuma hangalnilan wullǝkkiya, raakko. ");
INSERT INTO kby_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Kǝramiya, kǝla hangallen bare yallaro walluwwi. Kǝla awo diwiyen yalla sananaro wallowo, amma kǝla hangaldǝyen rashiduwaro wallowo! ");
INSERT INTO kby_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Akko awo Attauralan ruwuwadadǝ: «Kǝmandeye: “Jama adǝro am tǝlam gadeye-a ci kusottowaye-ayen jandegǝkki, amma adǝson wua kǝrǝnsaiwawo,” yeno.» ");
INSERT INTO kby_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Ase, tǝlambadǝ naptu alamaye cadi, Isaa gawuro gǝni, ganambuwuro, nawinawidǝ ye ganambuwuro gǝni, Isaa gawuro. ");
INSERT INTO kby_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Adǝ nangaro, jama Isaa gawu samma captane tǝlamba gaden jandejai duwon, am awo ania nojanni bi Isaa gawu gǝni isane nadǝro ngasayia, nayia joɍiyaro ngonjaiwawo wa? ");
INSERT INTO kby_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Amma cammodǝn am samma nawinawi cadi duwon, kam Isaa gama gǝni bi awo ania nojǝnni laa nadǝro ngayia, tayi samma nangaro ti biwumaro tabbatto noji, tayi samma nangaro shara tia cǝdai, ");
INSERT INTO kby_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","asǝr karwunjuye kaadaro walje, fǝdǝryero tǝmde Alaro ambǝcciye: «Jiremaro Ala dawundon!» cǝni. ");
INSERT INTO kby_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","To, kǝramiya, awi gai gǝle? Captuwiya, wundundo yaye aiya njungoroye bi alamdu, bi wahayi cuwudi, bi mana tǝlamlan cǝdi, bi fisarji. Awo samma jamadǝa isadunoajuworo tǝdo. ");
INSERT INTO kby_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Am laa tǝlamlan jandejaia, bare yindi bi yakku kojǝnaro mana cadǝnni, fal fallen cado, koro kam laa fisarjo. ");
INSERT INTO kby_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Fisarduma baworo walyenoa, wundunja yaye dawu cammodǝyen gǝm cǝdo, kǝlanju-a Ala-aro jandejuwo. ");
INSERT INTO kby_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Nawiya yindi bi yakku mana cado, am gade ye manadǝa gayirja. ");
INSERT INTO kby_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Wahayi laa kam gade nadǝn napkadaro bayindiyia, burwoye mana cǝdidǝ gǝm cǝdo. ");
INSERT INTO kby_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Am samma caɍo, duno cawandoro, nayi samma ranguwe fal fallen nawinawi diwi. ");
INSERT INTO kby_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Nawiya ruhunja nawinawiyedǝa caɍiwi, ");
INSERT INTO kby_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","awoa Aladǝ Ala hangalsangoye gǝni, Ala nanlewaye. Jama muminna sammayen tǝdidǝ gai, ");
INSERT INTO kby_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","kamuwadǝ curo cammoyen gǝm cado, awoa jandedu tayiro amardǝgǝnni, amma Attaura ye wuljǝnadǝ gai, kǝngaaro napca. ");
INSERT INTO kby_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Awo laaa nodu caraanaa, kwawanjaa fadon caworo. Curo cammoyen kamuye mana diodǝ jauro nangua. ");
INSERT INTO kby_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","Mana Alayedǝ nayilaman wa badiyeno? Ra, nayi rundomaa nanjaa? ");
INSERT INTO kby_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Kam laa ti nawi bi tilan kǝnjo Ruhuyearo tǝmayenoa, awo ruwunjagakkǝnadǝ wada Kǝmandeye woro asujo. ");
INSERT INTO kby_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Kam laa adǝa kistuwuro wajia, tiro kissagaiwawo. ");
INSERT INTO kby_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","To, kǝramiyani, nawinawi dio jauro rawowo, bare tǝlamba gaden jandedu dapkǝwwi, ");
INSERT INTO kby_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","amma awi yaye jiɍi jussǝna-a sawiyada-alan tǝdiro waljo. ");
INSERT INTO kby_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Kǝramiya, kawuɍi kǝji wulnjagakkǝnadǝa isatannjagakki, kawuɍi kǝji duwon mowuwwa ye, kǝlanjun danuwwa ye. ");
INSERT INTO kby_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Kawuɍi nayiro wulnjagakkǝnadǝa ronuwia, tilan njǝkkawo fanduwi. Adǝ gǝnia, bowu fatto kasadduwwa. ");
INSERT INTO kby_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Awison fuwunno kawuɍi wu ye mowokkǝnadǝa nayiro njaddǝkkǝna: Kitawulan ruwuwadadǝ gai, Almasiwu biwuwande nangaro kano, ");
INSERT INTO kby_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","tia sittǝrayera, daji yimbe yakkua karmolan ciyeno, kitawulan ruwuwadadǝ gai. ");
INSERT INTO kby_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Kefasso fǝleyaada, koro tayi mewun yindindǝro, ");
INSERT INTO kby_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","daji kǝramiya yer uwumaa kojǝnaro na tilon fǝleyaada. Ngǝwunja har kuro mbeji, amma laanja ro carǝmbǝna. ");
INSERT INTO kby_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Ngawo adǝyen Yakubaro fǝleyaada, koro kǝngayamba sammaro. ");
INSERT INTO kby_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Daryerambo, kam sa cǝdǝnnin tambǝna gairo, wu yero fǝleyaada. ");
INSERT INTO kby_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Kǝngayamba samman wuma gana wo, wu kǝngayamlan bowodu tikkǝni, jama Alayedǝa basarnǝkkǝna nangaro. ");
INSERT INTO kby_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Amma awo wallǝkkǝnadǝ ser Alayen walyekko, koro serdǝa bowuro gǝni fǝlesuwo. Ai, kǝngayamba sammaa kojǝnaro ngǝnǝptǝkkǝna, amma wu gǝni, ser Alaye wulan dǝganadǝ. ");
INSERT INTO kby_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Adǝ nangaro wuro bi tayiro walyeno yaye, akko awo mawoniye kasadduwwadǝ. ");
INSERT INTO kby_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","To, Almasiwu karmolan cijǝnaro mawojaidǝ, ndayin gǝle amndo laa karmolan cidu bawo cani? ");
INSERT INTO kby_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Amma karmolan cidu bawoa, Almasiwu ye cijǝnni. ");
INSERT INTO kby_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Koro Almasiwu cijǝnniro walyenoa, mawodundedǝ ye bowu, kambǝrsendodǝ ye bowu, ");
INSERT INTO kby_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","har Alaro shedawu kattuwuyero walliyena, dalilnjudǝ Ala Almasiwua karmolan cǝsangǝna niyena, amma am sanuna karmolan cijaiwaworo walyenoa, ase tia cǝsangǝnni. ");
INSERT INTO kby_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Awoa am sanunadǝ karmolan cijaiwawoa, Almasiwu ye cijǝnni. ");
INSERT INTO kby_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Koro Almasiwu karmolan cijǝnnia, kambǝrsendodǝ faida bawo, koro yaye nayi curo biwuwandoyen. ");
INSERT INTO kby_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Adǝgaima am Almasiwuye ro carǝmbǝnadǝ ye faccaana. ");
INSERT INTO kby_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Dunia adǝ runjumaro tǝmande Almasiwuro kekkiyea, dunia samman andima awo njunoduye wo. ");
INSERT INTO kby_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Amma jiremaro Almasiwu karmolan cijǝna, koro tayi ro carǝmbǝna sammayen tima burwon cijo. ");
INSERT INTO kby_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Karmodǝ kamben isǝna nangaro, karmolan cidudǝ ye kamben kadio. ");
INSERT INTO kby_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Am samma Nawi Adamlan sanuidǝ gai, ngainin samma Almasiwulan ro cawandi, ");
INSERT INTO kby_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","amma kǝwu kǝwuro, burwon Almasiwu, daji kǝndenjun am Almasiwuye, ");
INSERT INTO kby_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ngawo adǝyen sa njerorambe cǝdi. Sadǝn Almasiwu maiya samma-a kǝrmai so, kǝnduwo so samma-aa baworo cǝde kǝrmaidǝa Ala Bawadǝro ci. ");
INSERT INTO kby_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Awoa Almasiwudǝ har kawu Ala kǝladowanju sammaa cidiya sinjuyero cakkiro, sai kǝrmai cunodiya. ");
INSERT INTO kby_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Kǝlado daryeye baworo waljidǝ tima karmo wo, ");
INSERT INTO kby_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","awoa: «Ala awo sammaa cidiya sinjuyero cakkǝna.» Amma tiye: «Awo sammaa cidiyanjuro cakkǝna,» cǝnnadǝ, farakko ti duwon awo sammaa cidiyanjuro cakkǝnadǝ dawun bawo. ");
INSERT INTO kby_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Koro sa awo samma cidiyanjunno waljiya, daji Tadadǝ kǝlanju cidiya ti awo sammaa cidiyanjuro cakkǝnadǝyero walji, ngainin Ala awo samman awi yayero walji. ");
INSERT INTO kby_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ngai duwon, am duwon cuju am sanunayero tayiro kasala caddǝnadǝ, awi gǝle maananju wo? Ca jiremaro am sanunadǝ karmolan cijaiwaworo walyenoa, awiro cujunjaro kasala caddi? ");
INSERT INTO kby_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Andi ye, awiro sa fi yaye tajirwan dǝgaiyenadǝ? ");
INSERT INTO kby_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Tabbat, kǝla nayi kǝramiyaniyen Kǝmande Isa Almasiwulan awulo bonidǝ jiredǝ gai, yimbi yaye roni karmoro salamgǝkkǝna. ");
INSERT INTO kby_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Bǝrni Afisayelan bundiya-a mǝldǝkkǝnadǝ, awi kǝla kuro kamben wuro faidanju wo? Ca am sanunadǝ karmolan cijaiwaworo walyenoa, «Nda buiyo yaiyo, baɍi nuiye nangaro.» ");
INSERT INTO kby_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Bare jambaduwwi: Am diwi-a dǝgadǝ hal ngǝla bannaji. ");
INSERT INTO kby_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Hangalndoro waldǝnowo, biwu dio kollowo, nangunoworo wullǝkki: Laando Alaa nojanni. ");
INSERT INTO kby_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Amma kam laaye: «Ndayin am sanunadǝ karmolan cijai? Koro tiyi jiɍi fia caluwi?» cǝne cuwori. ");
INSERT INTO kby_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Ni hangal bawoa! Awo nadǝmmadǝ ɍijiwawo, sai nuiya duwon. ");
INSERT INTO kby_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Koro awo nadǝmidǝ, kajim fuwun ɍijidǝa gǝni nadǝmi, kasuni runju, bi algamaye, bi awo gadeye. ");
INSERT INTO kby_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Daji Ala tiro tiyi jiɍi cǝraanaro ci, kasuni fi yayero jiɍi kaanju ci. ");
INSERT INTO kby_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Da tiyiye samma tilo gǝni, kambe runju, lǝmanne runju, ngudoye runju, buniye runju. ");
INSERT INTO kby_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Tiyiya sameye mbeji, cidiye ye mbeji, amma daraja tiyiya sameye-a cidiye-a gadegade. ");
INSERT INTO kby_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Daraja kǝngalle gade, kumballe gade, sillowuwaye gade, koro sillowuwadǝ ye darajanja gadegade. ");
INSERT INTO kby_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Cinowo am sanunayedǝ ye ngai. Karmolan tǝnadǝna, ro njǝpciwawolan ciji. ");
INSERT INTO kby_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Daraja bawoalan tǝnadǝna, darajaalan ciji. Duno bawoalan tǝnadǝna, dunoalan ciji. ");
INSERT INTO kby_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Tiyi adamgǝnayelan tǝnadǝna, ruhulan ciji. Tiyi adamgǝnaye mbejidǝ, tiyi ruhuye ye mbeji. ");
INSERT INTO kby_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Kitawulan ngai ruwuwada: «Nawi Adam kam burwoyedǝ alau roaro waljǝna.» Adam daryeyedǝ ruhu ro njomaro waljo. ");
INSERT INTO kby_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Amma awo ruhuyedǝ awo burwoye gǝni. Awo adamgǝnaye burwon isi, daji awo ruhuye. ");
INSERT INTO kby_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Kam burwoye cidin tǝdǝnadǝ, ti cidiye. Kam kǝnyindiyedǝ, ti sameye. ");
INSERT INTO kby_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Jiɍi kam cidiyedǝ gai, tayi cidiye ye ngai. Koro jiɍi kam sameyedǝ gai, tayi sameye ye ngai. ");
INSERT INTO kby_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Jiɍi camuno kam cidiyedǝro walliyenadǝ gai, camuno kam sameyedǝ yero walliye. ");
INSERT INTO kby_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Kǝramiya, awo wullǝkkidǝ tima tiyi-a bu-a nodo bargaa Alayea warasajaiwawo, awo nomadǝ ye ro njǝpciwawodǝa warasajiwawo. ");
INSERT INTO kby_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Fannowo, asǝr laa wulnjagakki: Andi samma gǝni ro rǝmbiye, amma andi samma falladaro walliye, ");
INSERT INTO kby_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","sam falnin, kǝmǝt simben, nuktu daryeye kangadiyen. Awoa kangadidǝ nukci, am sanunadǝ karmolan cijane gadero njǝpcaiwawo, koro andi samma falladaro walliye. ");
INSERT INTO kby_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Adǝgaima tiyi njǝpci adǝ gadero njǝpciwaworo waljo, koro tiyi noma adǝ gadero nuiwaworo waljo. ");
INSERT INTO kb