﻿USE sofia;
DROP TABLE IF EXISTS sofia.kbq_vpl;
CREATE TABLE kbq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kbq_vpl WRITE;
INSERT INTO kbq_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ese agafare Anumzamo'a monane mopane trohu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ama mopama fore osu'nerera, mago zana omnetfa hu'neane. Hankino tusi'a hanimo tina refite'negeno, ana timofo agofetura Anumzamofo Avamumo vono nehiane. ");
INSERT INTO kbq_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Anante Anumzamo'a huno, Masa fore hino! higeno masa fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Hagi masamo'a knare higeno Anumzamo'a keteno, masane haninena refko hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Anumzamo'a masagura zagegane huno agi'a nemino, kumazukura hanine huno agi'a ami'ne. Hanki hani huno ko'matigeno'a, pusankna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hagi tinke me'negeno Anumzamo'a huno, Mago kankamu amu'nompina me'neno tina refko hanie. ");
INSERT INTO kbq_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Huteno Anumzamo'a tina refkohu fenka netreno, hunagamu atregeno, kankamu efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anumzamo'a ana kankmumofona agi'a mone huno ante'ne. Hanki haninkino masa higeno, nampa 2 kna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Anante Anumzamo'a huno, Timo'a monamofo hinkanaga mago kaziga eri zogino evanigeno, ho'mu mopa fore hanie, huno higeno anaza efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Anumzamo'a hagagema hiankazigagura mope nehuno, tima evazu huno omeri atruma hiantinkura, hagerine huno hu'ne. Anumzamo'ma anazama kegeno'a, e'i knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hagi Anumzamo'a amanage huno hu'ne, Mopafinti maka'za hagesie. Za'ara zane zafane rumofo rumofo raga'a revava hanaza zantamimo'za hagesaze. Ragazmifina avima'a efore hanie! Hanige'za zafa rgama rentesazana e'i zamagu'afinka avima'amo'za zamagri'agna raga rentesaze. Hige'za mopafina ana zantamimo'za efore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ana nehazage'za mopafina ruzahu ruzahu trazana erifore nehazageno, ruzahu ruzahu ne'zampina avima'a me'nea rentageno, avima'amo'a agragna raga fore nehigeno, zafa rgama renteana e'i agu'afinka avima'amo'za zamagri'agna huno nemegeno, avima'a rentetere hu'ne. Hanki Anumzamo'ma anazantamima kegeno'a knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Haninkino masa higeno nampa 3 kna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hagi Anumzamo'a huno, Tavitamimo'za mona kankamumpi me'neza, masane haninena refko nehu'za, kafugi, zagegi, ko knagi hanagu nemesageno, ");
INSERT INTO kbq_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ana tavitamimo'za mona kankamumpi efore hu'za me'neza mopamofona remasa hanaze, hige'za ana zantamina fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Anumzamo'a tusi'a tavi tre tro hu'ne. Rantavimo feru remasa hanigu zage tro nehuno, rankna tavi hanimpi remasa hanigu, ika tro nehuno, ofuntaminena tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Anumzamo'a mopamofoma masama amisanagure huno mona kankamumpina tavitamina zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","E'i ana tavi'mo'za hanimpine masafinema remasama hanagure huno zamante'ne. Anumzamo'ma anazantamima kegeno'a knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hagi haninkino masa higeno, nampa 4kna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Anante Anumzamo'a amanage hu'ne, Timpina nozame zagane, zamasimu ante'za manisaza zagamo'za efore hu'za ruvinetesageno, mona kankamumpina namazagamo'za efore hu'za hare'za vano hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hagi anante Anumzamo'a tusinasi nozameramine, osifaveramina trohuno hagerimpina zamagrite zamagrite zamantege'za timpina avite'za mani'neza kaza kaza hu'za vano nehaze. Hanki namazaga zamagri kna huno tro huzmante'ne. Anumzamo'ma anazama keana knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Anumzamo'a asomu ke hunezmanteno amanage hu'ne, kase hakare huta hagerimpina mani aviteta nemaninkeno, namamo'zanena mopafina kase hakare hu'za mani titipa hiho. ");
INSERT INTO kbq_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hagi haninkino masa higeno, nampa 5fu kna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Anumzamo'a amanage huno hu'ne, Mopafina miko zagagafa rumofo rumofo fore hanaze. Kumate zagagafagi, afi zagagafagi, ne'onse zagaramine, zamagragna rumofo rumofo fore hu anante anante hiho. Anage higeno maka ana zagaramina fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hanki Anumzamo'a zagagafa tro hu'neana, trampi mani zagagafa zamagri kna tro nehuno, nontegama mani zagagafa zamagri kna tro nehuno, mopafi ne'onse zagaramina zamagri kna tro hu'ne. Anumzamo'ma anazama kegeno'a knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hagi Anumzamo'a amanage huno hu'ne, Vahe tro hamnena tagrikna hu'za manine'za, maka'za kva nehu'za nozameramine, hare'za vano nehaza namaramine, kumate zagagafane, mopafima kazama hu'za vanoma nehaza zagarami kegava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hagi Anumzamo'ma vahe'ma tro hu'neana, Agra'agna tro hu'ne. Vene a'ene tro huzanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Anumzamo'a asomu ke huneznanteno amanage huno zanasmi'ne, Mofavre kase hakare hanakeno, mopafina mani vitesaze. Ana nehuta mikoza kegava hi'o. Timpi nozame zagane, hareno vano nehia nama zagane, hakare'a mopafi kaza huno vano nehia zagaramine ana makaza kegava hi'o. ");
INSERT INTO kbq_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Anumzamo'a amanage hu'ne, Kma antahi'o! Mopafima nehagea zamofona avima'ane zafa raga'ane nezama nesa'aza tanami'noe. ");
INSERT INTO kbq_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Hanki mika ama mopamofo agofetu vonoma nehaza zagagafamo'zane, monafima hare'za vonoma nehaza nama'zaga'mozane, mika zagagafama zamasimuma ante'za vanoma nehaza zagamo'zama nesaza zana, ruzahu ruzahu traza Nagra zami'noe, huno higeno ana zana fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Anumzamo'a mika'za trohuteno keana knare huno hentofa zanke fore higeno keteno, muse hu'ne. Hagi haninkino masa higeno, nampa 6si kna emente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","E'inahu huno monane mopane, anampima me'nea zantamina maka trohu vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eri'za eri vagareteno, nampa 7ni knarera Anumzamo'a manigasa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Anumzamo'a nampa 7ni knarera manigasa nehuno, ana kna eri ruotge huno asomu hunte'ne. Na'ankure miko'a eri'zana eri vagarenegu huno manigasa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ra Anumzamo'ma monane mopane eri fore'ma hunte'nea nanekea, amanahu me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","E'i ana knafina za'ara zana fore ama mopafina osu'ne, na'ankure Ra Anumzamo'a ana knafina kora atregeno oru'ne. Ana higeno eri'za eri vahera fore huno omani'negeno, ");
INSERT INTO kbq_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","kampu'i tintamimo'za mopafinti hanati'za mika mopamofona tina ami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ra Anumzamo'a kugusopa erino regripeteno vahe tro huno agonagampi Agra'a asimu'a huhu huvazigeno, vahe efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hanki Ra Anumzamo'a mago hoza zage hanati kaziga ante'neankino, ana hozagura Ideni hoze hu'nea hozamofo agu'afi, ana nera avreno ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ra Anumzamo'a rumofo rumofo zafa higeno, mopafinti hage'ne. Hakare zafamo'za zamuma kete'ene ne'zama ne'arera knare hu'naze. Hagi ana hoza amu'nompina tare zafa me'ne. Mago zafa ofri manivava hu zafe. Hagi mago zafa knare zanki, havizanki huno'ma antahino keno'ma hu zafe. ");
INSERT INTO kbq_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hagi Ideni hozafintira mago ti hanatino enevuno, hozafina tina nemino ana timo'a refko huno 4'afi ranti evu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ese'ma evu'nea timofo agi'a Pisoni tinkino, maka Havira mopafi rugagino evu'ne. Ana mopafina knare goli me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ana mopafima me'neana mago'zana ruokamre knare goline, mana nentake'zane, mizama'amo mareri'nea oniksie nehaza havene me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Anante timofo agi'a Gihoni tinkino, Kusi mopafi rugagino evu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hagi nampa 3a Taigrisi tinkino, zage hanati kaziga Asiria mopafi evu'ne. Hagi nampa 4a Yufretis tine. ");
INSERT INTO kbq_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Hanki Ra Anumzamo'a ana ne'ma avreno Ideni hozafima ante'neana, hoza eri'zama enerino kegavama hanigure huno avrente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hianagi Ra Anumzamo'a amanage huno kasegea hunagru hunte'ne, Kagra mika hozafima me'nea zafa raga amne negahane. ");
INSERT INTO kbq_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hianagi knare'zanki havi'zanki huno antahino keno'ma hu zafa raga onetfa huo. Hanki kagrama ana zafa ragama nesnanana, tamage hunka anazupa frigahane. ");
INSERT INTO kbq_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hagi anante Ra Anumzamo'a anage hu'ne, Vemo'ma agrake maniazamo'a knare osianki'na, azahu vahera tro hanugeno knare hu'ne tragote'ne manigaha'e. ");
INSERT INTO kbq_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nehuno mopa kateno mika zagagafane, namaramine, ne'one zagagafaraminena tro huzmanteteno zamavareno zamagi antezamisie huno ana nete vigeno, zamagi'a ante'zamigeno ana zamagima ante'nere me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Higeno ana ne'mo'a mika nontegama nemaniza zagagafagi, monafima hare'za vanoma nehaza nama'zagagi, mopafima nemaniza maka afi zagagafagi huno zamagi zami'neanagi, agri'ma azahu knampa'a omani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ana higeno Ra Anumzamo'a ve mofona azeri avukoko higeno mase himre'negeno, magoke omete asoza'a avazu huteno, avufanu renkanirente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ra Anumzamo'a ana ne'mofo asoza'ama eri'nereti a' trohuno avreno egeno, ");
INSERT INTO kbq_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ana ne'mo'a huno, Ha e'ine! Nagri zaferinareti zaferina'a tro nehuno, nagri navufareti avufga'a tro hu'neanki'na, are hu'na agi antemue. Na'ankure e'i ve'mofo avufafinti erino trohu'negu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","E'i ana agafare vemo'a nererane, nefanena atreno, a'ane hagerafino eri mago huke nemani'e. ");
INSERT INTO kbq_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Zanagra arave huke kena omasi zanavufga zanavapa manina'anagi, zanagazea osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Hanki Ra Anumzana Anumzamo'a maka zagagafama mopafima trohu zamante'nefintira, tamage huno masavenentake kema hu'arera osifa'vemofo antahi'zamo'a zamagatereankino, osifavemo'a ana a'mofona antahigeno, Hozafima me'nea zafa rgagura Ra Anumzana Anumzamo'a tamagerfa huno mika one'o huno huranante'nefi? ");
INSERT INTO kbq_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Higeno ana a'mo'a osifavemofo kenona huno, Hozafintira mika zafa raga amane ne'o huno hurante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Hu'neanagi mago zafa hoza amu'nompi me'nea zafa rgagura avako osuta one'o hurante'ne. Hagi ana zafa ragama nege, avako'ma huge'ma hanuta'a, frigaha'e huno tasami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Higeno osifavemo'a a'mofonkura amanage hu'ne, Tamagerfa hutna tanagra ofrigaha'e. ");
INSERT INTO kbq_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Na'ankure Anumzamo'a keno antahino hu'neankino, nesna'ana tanavumo'a hari hina Agri kna hutna antahi antahi tani'amofona eriama hanigetna, knare zanki, havi zanki hutna keta antahita hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Higeno ana a'mo'ma ana zafa rgama keana ne'zama ne'amo'a knare higeno, zafa ragamo'a knare hu'neankino, ana a'mo'a amanahu antahintahi eri'ne. Ama zafa raga tagina nene'na knare antahi'za erisue nehuno, ana zafa raga tagino neneno, neve'ene mani'negukino, mago'a nevena amigeno ne'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Netakeno zanavumo'a hari hige'ne, zanavufga zanavapa mani'nene, zanagazegu nehune fiki zafa anina anakike zanavufgarera kena masina'e. ");
INSERT INTO kbq_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kinaga zasi anteno fruma higeno'a Anumzamo'a hozafi ne-egeno agasasanke'a nentahike hozafi mago'a zafa asoka frakike mani'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mani'nakeno Ra Anumzana Anumzamo'a vemofonkura kezatino anage hu'ne, iga mani'nane? ");
INSERT INTO kbq_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Higeno vemo'a huno, Hozafi neanke'na kagasasanke nentahi'na frakina mani'noe. Na'ankure navufga navapa mani'nena, koro hu'na fraki'noe. ");
INSERT INTO kbq_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Higeno Ra Anumzana Anumzamo'a huno, Iza hugantegenka kavufga kvapara mani'nane? Nagrama ono hu'na hunagru'ma hugante'noa zafa raga'a taginka ne'nampi? ");
INSERT INTO kbq_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Higeno vemo'a huno, Kagrama nami'nana a'mo ana zafa raga tagino neneno namige'na ne'noe. ");
INSERT INTO kbq_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Higeno anante Ra Anumzana Anumzamo'a ana a'kura huno, Kagra e'i zana na'a hu'nane? Huno antahigegeno a'mo'a kenona huno, Osifavemo renavatga hige'na tagi'na ne'noe. ");
INSERT INTO kbq_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Higeno Ra Anumzana Anumzamo'a amanage huno osifavemofona asami'ne, Osifavemoka e'inama hana nona'a, vahe'mo'zama kumate'ma kegavama nehaza zagagafane, trampi afi zagagafama mani'nafintira kazusi (kes) hugantoankinka, kagra zamageterenka rankna erinka kasaguregati regraro henka vano nehunka, mika knafina kugusopa nenenka manigahane. ");
INSERT INTO kbq_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nagra kagri'ene a'mofo amunompina ha'za nentena, tanagigomokizmi amu'nompina ha'za antesugeno, a'mo'ma kasentesia mofavremo kasenia reprorovazina, kagra agrira agamerumpafi amprigahane. ");
INSERT INTO kbq_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Anage nehuno Anumzamo'a a'mofonkura amanage hu'ne, Mofavrema kasentenaku'ma hananke'na Nagra rama'a kata kamisugenka, ana katafi mani'nenka mofavrea kasentegahane. Ana nehunka negavena tusiza hunka avesintegahane. Hianagi agra kagrira kegava krigantegahie. ");
INSERT INTO kbq_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Hagi Anumzamo'a Adamuna amanage huno asmi'ne, A'kamofo ke antahinka Nagrama kase hugante'na hunagru'ma hugante'noa zafa raga ne'nanku mopamofona Kazusi huntoankinka, kata negrinkenka maka zupa hozaka'a e'nerisankeno nezanka'a fore hinkenka negahane. ");
INSERT INTO kbq_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Hozafi ne'zana ave'ave zane agaso tra'zamo fore huno refinetena ne'zana anampinti erinka negahane. ");
INSERT INTO kbq_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kavugosafinti kamunasisi hutesigenka nezanka'a eri fore hunka negahane. Ana hume vunka kugusopareti tro hugante'nogu frinka ete mopafi ufregahane. ");
INSERT INTO kbq_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ana ne'mo'a nenaro agi'a Ivi'e huno antemi'ne. Na'ankure mika vahe'mokizmi zamarera'zama hanigure huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hanki Ra Anumzana Anumzamo'a zagagafa akru'a tavrofeno Adamune, Ivinena kukena masizanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hagi Ra Anumzana Anumzamo'a amanage hu'ne, Ama ne'mo'a tagri kna huno knare zanki havi zanki huno hago keno antahino hie. E'ina hu'negu manivava hu'mofo zafa raga'a tagino nesanuno'a manivava hu'zanku atresanunkeno ana zafarera urava'o osanie. ");
INSERT INTO kbq_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Anage nehuno Ra Anumzana Anumzamo'a, Ideni hozafintira huntegeno fegi'a agri'ma tro hu'nea mopare hoza eri'zama erisnigu huntegeno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Hagi Anumzamo'a ana ne'ma Ideni hozafinti ahenatigeno vutegeno'a, zage hanati kaziga hankavenentike ankerozamantege'za ana hoza kegava nehazageno, tevenefa tagivazu nehia bainati kazimo kagigagi nehige'za, ana manivava zafamofona kegava hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu'a nenaro Ivi'ene masegeno amu'ene huno ne'mofavre kasenenteno ana a'mo'a huno, Anumzamo naza hige'na ne'mofavre erifore hue, nehuno Keni'e huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hagi henka Ivi'a Keni neganana Abeli kasentegeno ana ne'mo'a ra huno sipisipi afu kegava higeno, Keni'a mopafi eri'za erino hoza anteno kegava hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Magokna Keni'a Ra Anumzamofo ofa hunteku hoza'afinti ne'za erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ana higeno Abeli'a sipisipi afutamimpinti afovage hu'nea agonesa afu mago aheno eme Kresramana vuntegeno, Ra Anumzamo'a negeno Abelina antahi muse hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Hianagi Keni'ma ofa hunte'neaza keteno, Anumzamo'a antahi musena huontegeno, Kenina tusi asi vazigeno avugosa rugriri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ana higeno Ra Anumzamo'a negeno Keninkura amanage hu'ne, Nahigenka krimpagna nehunka kavugosa runegaririne? ");
INSERT INTO kbq_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Hagi kagra'ma knare kavu'kava'ma hantesina Nagra muse hugantosine. Hanki kagrama havizama hanankeno'a, kumimo'a kazeri kagateregahianki, kagra hankavetinka mani'nenka kumira azeri agatero. ");
INSERT INTO kbq_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hagi mago knazupa Keni'a nagana'amofo Abelinku hofa trampi vanu'e huno agi higeke, vukema ana hofa trampi umanineke, Keni'a nagna'amofo Abelina ahe fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Anante Ra Anumzamo'a Kenina antahigeno, Negagna Abeli'a inantega mani'ne? Higeno Keni'a huno, Nagra onke'noanki, Kagrama kagesama antahinana nagra nagananimofo kva hunte ne' mani'nofi? ");
INSERT INTO kbq_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Higeno Ra Anumzana Anumzamo'a amanage hu'ne, Kagra na'a higenka kefo kavukvara hu'nane? Nagnakamofo koramo'a mopafi tagiramineno keaga hunto huno Nagritega krafage nehie. ");
INSERT INTO kbq_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Hagi nagna kamofoma ahenka eri taginana koramo'a, mopafi tagiramigeno mopamo ne'negu, ana mopa kazusi huntoankino ne'zana forera osugahie. ");
INSERT INTO kbq_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Hagi mopafima hozama erinka antesnana hozamo'a, hikazake huno nena ahenonte'na, nonka'a omanena kanke kanke hunka ama mopafina vano hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Keni'a amanage huno Ra Anumzamofo kenona hu'ne, Nagri'ma hunantana kemo'a tusi'a kna navesie! ");
INSERT INTO kbq_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hanki kama antahio! Kagra ama mopafinti nagrira meni nazeri atranankina, Kagri kavuga omaninugeno, noni'a omane'nenigena ama mopafina kanke kanke neha'nena, aza'o nagesuno'a nahe frigahie. ");
INSERT INTO kbq_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Higeno Ra Anumzamo'a kenona'a huno, Kagri'ma kahesimo'a ana nona'a 7ni'a zupa kna'zana agetereno erigahie, nehuno Kenima vahe'mo'zama negezama ohesnagu mago avame'za agofetu antente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ana higeno Ra Anumzamofo avugatira Keni'a atreno Ideni hozamofo zage hanati kaziga vuno, Nodi mopare umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keni'a nenaro'ene masegeno amu'ene huno ne'mofavre kasenteno, agi'a Inoku'e huno ante'ne. Hagi anante mago rankuma erifore huno kiteno, ana kumamofo agi'a Inoku'e huno mofavre'amofo agire asamre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hagi Inoku'a mago mofavre eri fore huno agi'a Iradi'e hu'ne. Iradi'a Mehusaeli nefa'za higeno, Mehusaeli'a Metusael nefa'za higeno, Metusaeli'a Lemeki nafa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Hagi Lemeki'a tare atre zanante'ne, mago'mofo agi'a Ada'e, mago a'mofo agi'a Zila'e. ");
INSERT INTO kbq_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada'a ne'mofavre kasenteno agi'a Jabali'e huno ante'neankino, fugagi noma ki'za nemase'za afu'ma kegava nehaza vahe'mokizmi nezamageho'e. ");
INSERT INTO kbq_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Hagi ngana'amofo agi'a Jubali'e. Jubali'a ese'ma agafa huno nofite zavena (harp) nehaza naga'mokizmi nezamageho'e. ");
INSERT INTO kbq_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Hanki Zila'a Tubalkein kasente'neankino, agra aenima, kopama tevefi krefizo huteno amasagino eri'zama eri'zantami tro nehia nere. Tubalkeini nesaro agi'a Na'ama'e. ");
INSERT INTO kbq_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Mago zupa Lemeki'a nenaro kiznigura amanage huno zanasmi'ne, Adagane Zilagata'a kama antahi'o, mago nehaza ne'mo nahe kuzafa antege'na, agrira ete ahe fri'noe. ");
INSERT INTO kbq_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Hagi mago ne'mo'ma, Kenima eme ahe frisanuno'a, 7ni'a zupa knazana eri agofetu huno erigahie. Hianagi tamage huno nagri'ma Lemeki'nama eme nahesanuno'a, 77ni'a knazana agofetu huno nona'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Hagi Adamu'a nenaro'ene masegeno ne' mofavre kasenteno amanage hu'ne, Keni'ma Abelima ahe fri'nea nona'a Anumzamo'a ne'mofavrea namiankino agi'a Seti'e. ");
INSERT INTO kbq_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Henka'a Setina ne'mofavre fore humigeno agi'a Enosi'e huno antemi'ne. Ana knafi vahe'mo'za erigafa hu'za Ra Anumzamofo agihanta nevazi'za, Agrite mono hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamumpinti'ma vahe'ma fore'ma hu'za e'naza nanekea amanahu hu'ne. Anumzamo'ma vahe'ma trohu'neana, Agra'agna huno trohu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Agra vene, a'ene tro huzanante'ne. Ana nehuno asomu ke huzmanteno, vahere huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu'a 130'a Zagegafu nehuno agra avugosagna ne'mofavre kasenteno, agi'a Seti'e hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ananteti 800'a zagegafu agatereno mani'neno, ne' mofara mago'a kasezamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Hagi Adamu'a 930'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Hagi Seti'a 105fu'a zagegafu nehuno, ne' mofavre eri fore huno agi'a Enosi'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Hagi Enosima kasenteteno'a, ananteti Seti'a 807ni'a zagegafu nemanino, mago'a ne'mofara kasezamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ana huteno 912fu'a zagegafu Seti'a maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi'a 60'a zagegafu nehuno ne' mofavre eri fore huno, agi'a Kenani'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenanima kasenteteno'a Enosi'a 815ni'a zagegafu maniteno mago'a ne'mofara zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi'a 905fu'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani'a 70'a zagegafu nehuno, ne'mofavre eri fore huno agi'a Mahalari'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalarima fore'ma hutegeno'a Kenani'a 840'a zagegafu nehuno, mago'a ne'mofara kasezmantene. ");
INSERT INTO kbq_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani'a 910ni'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalari'a 65'a zagegafu nehuno, ne' mofavre anteno agi'a Jareti'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jaretima kasenteteno, Mahalari'a 830'a zagegafu nehuno mago'a ne'mofara kasezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Hanki Mahalari'a 895fu'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jareti'a 162tu'a zagegafu nehuno ne' anteno agi'a Inoku'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enokuma kasenteteno Jareti'a 800'a zagegafu nehuno mago'a ne' mofara kasezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jareti'a 962'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inoku'a 65'a zagegafu maniteno, ne' mofavre Metusera kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ananteti Metuserama kasenteteno'a Inoku'a 300'a zagegafufina knare huno Anumzane tragoteno mani'neno mago'a ne' mofara kase zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hagi ana makara 365'a zagegafu Inoku'a mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inoku'a Anumzane tragoteno mani'negu, Anumzamo'a avre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusera'a 187ni'a zagegafu maniteno, ne'mofavre Lemeki kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusera'a Lemekima kasenteteno'a, 782'a zagegafu maniteno, mago'a ne'mofara kase zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Hagi Metusera'ma manino'ma e'nea kna'a, 969ni'a zagegafu huteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemeki'a 182'a zagegafu nehuno ne' mofavre kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lemeki'a Noa'e huno agi'a antemi'ne. Ra Anumzamo'a mopamofona tusi hunte'negeta tusi'a eri'za erita nevunkeno tagri taza hanigu ama mofavre agi'a, mani fruhu nere nehuno, zamagra kefina Noa'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Hanki Noama kasenteteno'a Lemeki'a 595fu'a zagegafu maniteno, mago'ane ne' mofara kasezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemeki'a ana maka kna'a, 777ni'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa'a 500'a zagegafu maniteno, ne'mofavrea tagufa zamanteno zamagi'a Semi'e, Hamu'e, Jafeti'e huno zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Veamo'za ama mopafina vahera kase hakare hazageno, knare'nare mofa'nerami fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Hanki vahe'mo'za rama'a mofane zaga kasezmantage'za, Anumzamofo mofavre naga'mo'za ke zamasane nehu'za zamavesia a'ne eri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ana hianagi Ra Anumzamo'a amanage hu'ne, Avamunimo'a vahe'mofompina mani'neno zamasimura zami vava osugahie. Na'ankure vahera fri'zaga mani'nazanki'za, 120'a zagegafua agateore'neza frigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ana knafine henka'anena tusinasi vahe'mo'za ama mopafina mani'nazankino, Anumzamofo mofavremo'za e'za vahe'mokizmi mofane zagane emasageno mofavrea kasezmante'naze. Hanki'za fore'ma hazana korapa knafina hankavenentake hu'za hihamu'ane vahe fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Hianagi Ra Anumzamo'ma vahe'mokizmima zamage'neana, mika kna havi avu'avazamo ama mopafina ra huno vahe'mofo antahi antahifina, havi avu ava'zamo aviteno meno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","E'ina nehazageno Anumzamo'a nezamageno rimpa haviza higeno muse osuno, nahige'na vahera trohu'noe huno asunke nehuno, ");
INSERT INTO kbq_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ra Anumzamo'a amanage hu'ne, Vahe'ene, zagagafane, namaramine, mopafi ne'onse zagarami'nena zamahe fanane hugahue. Nagrama tro'ma huzmante'noa zankura nasunku hue hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hianagi Noa'a agrake Ra Anumzamofo avurera fatgo nera mani'negeno muse hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hagi Noa nagamofo nanekea amanahu me'ne. Ana knafima mani'naza vahepina Noa'a fatgo huno hazenke'zama'a omanegeno Anumzane tragoteno mani'neno amage anteno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa'a ne' mofavre tagufa zamanteno zamagi'a Semi'e, Hamu'e, Jafeti'e huno antezmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ama mopamo'a Anumzamofo avurera haviza hu'ne, ha' zamo'ene, kefo avu'avazamo enena avite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Anumzamo'ma ama mopafima ke'neana, tamage huno makazamo'a haviza hu'ne, ama mopafima me'neazama keana kumike'za huvagare'naze. ");
INSERT INTO kbq_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hagi Anumzamo'a anage huno Noana asmi'ne, Ke ontahizageno kefo avu'ava zamo'a aviteankina zamagri'ene mopazimine zamahe fanane huku Nagra nagesa nentahue. ");
INSERT INTO kbq_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hagi kagra hanave zafareti ra ventea tro nehunka, asa hutanenka hunaraginto. Timo'ma ufre'zankura agu'ane megi'anena fukinu renkaniro. ");
INSERT INTO kbq_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ana ventema kisanana, zanra'a 150'a mitagi, kahesa'a 25 mitagi, atrure'a 15 mitagi hunka neginka, ");
INSERT INTO kbq_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","anagamu no amumpa tvaonte mago mitamofona agema'a hafu'a mita zasikana hagento. Magokaziga kaha hagentenka, ana ventemofo agu'afina ese nonki, anante nonki, agofetu nonki hunka kio. ");
INSERT INTO kbq_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Hagi Nagra ha'nenkeno tusi'a ti hageno mopa refitena mani'ne'za zamasimu nentaza zane, maka'zanena zamahe fanane hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Hu'neanagi kagrane huhagerafinugu huvempa hu'na negasamue. Kagrane a'mofavre ka'ane knoferahe'zane tamagra maka ventefi marerigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Hagi rumofo rumofo zagagafama mani'nazafintira vene, a'ene zamavaretere huge'za kahefa hu'za mani'sagu ventefi mareriho. ");
INSERT INTO kbq_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Zgagafama nama, rumofo rumofo kumate zagane, mopafi ne'onse zagarmine, vene a'ene kasefa hu'za manisnagu kagrite egahaze. ");
INSERT INTO kbq_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ana nehunka aru ne'za aru ne'zana, tamagrane maka zagagafanema nesazazana erinka eme eritru huo. ");
INSERT INTO kbq_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Higeno Anumzamo'ma asmi'neaza huno Noa'a maka'zana tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hagi Ra Anumzamo'a anage huno Noana asami'ne, Maka ama mopafima menima mani'naza vahepina kagrake fatgo nera mani'nanke'na negagoe. E'igu kagrane nagaka'anena ventefi mareriho. ");
INSERT INTO kbq_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kase avima hanagu avusese zagagafafintira 7ni'a aravere aravere zamavarentetere huo. Ana nehunka avusese osu zagagafafintira magoke arave zanavrentetere huo. ");
INSERT INTO kbq_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ana nehunka kase avima hanagu nama 7ni'a aravere aravere zamavarentetere huo. ");
INSERT INTO kbq_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Na'ankure 7ni'a zagegna manite'na Nagra ha'nenkeno kora rugahie. 40'a zagene hanine ko' nerinke'na, Nagrama mopafima trohu zamante'noa zana maka zamahe fanane hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Higeno Anumzamo'ma asmi'neaza huno Noa'a mika'zana hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ana knafina Noa'a 600'a zagegafu mani'tegeno, timo'a mopa ahe refite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ko' runaku nehige'za, Noa'ene nenaro'ene, mofavre zaga'ane anoferahe'zane ventefi mareri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Hagi agru osu zagaramimpinti'ene agruma hu'naza zagaramimpinti'ene namaramimpinti'ene, mika zagaramimpintira vene a'ene taretare hu'za Anumzamo'ma kema hu'neaza hu'za Noa'ene ventefi ufre'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hagi 7ni'a zagegna manitageno, kora erigafa huno rigeno, ti hageno refite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa'a 600'a zagegafu manitegeno 2 ikana 17tini zupa mopamo'a ruhagro higeno mopa agu'afinti tina hanatino tusi'a ti hage'ne. Tusi'a ko' ruvava huno havi avufgafinti hatihati huno tusi'a ti hage'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ana nehuno masane, hanine 40'a knafi ruose kora ruvava huno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Noa'ma ventefi mareria zupa, mofavre naga'a Semiki, Hamuki, Jafeti'ma a'ne zamima nezmarerama hu'za mareri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Trampi zagagafane, kumate zagagafane, namane, rumofo rumofo mopafi ne'onse zagarmina, vene a'ene Noante etere hu'za ventefi ufre'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Aravere aravere zamasimu nentaza zagagafamo'za ana maka Noante e'za ventefi ufre'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anante Anumzamo'ma kema hu'neaza huno aravere aravere mika ufre varetageno, Ra Anumzamo'a kafana erigi zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ranko'ma ru'neana zagene hanine 40'a knafi kora ruvava huno tusi'a ti hageno ana ventea mopafinti erisga huno mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ana nehuno timo'a reviteno marenerino mopa refitegeno, ventemo'a timofo agofetu me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hagi timo'a mago'ene hageno marerino osi agonaramine, zaza agonaraminena mika erinakri vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Hagi timo'a mago'ene mareri aviteno, mika mopane mareri agatere'nea agonaraminena 7ni'a mita aru agatereno refite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","E'ina higeno mopafima mani'nea zagaramine, nontega zagagafane, trampi zagagafane, namaramine, ne'onse zagarmine, vahe'ene, mopafima vanoma nehaza zagarminena zamahe fri vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Hagi mopafima zamasimu eri'za mani'naza zagagafa, maka fri hana hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Anumzamo'a vahe'ene, ne'onse zagarmine, namaramine, zagagafanena zamahe fanane hige'za omanitfa hu'naze. Higeno Noa'ene ventefi mani'namo'za zamagrake kasefa hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Hagi 150'a zagegnafi timo'a mopa refite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hagi timo'a mopa refite'negeno Anumzamo'a Noanku'ene mika zagagafama ventefi mani'nagu agesa nentahino, zaho atufegeno zaho erino tina retufegeno taneno urami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Anumzamo'a mopafinti'ma hanati'nea tina renkani nereno, monafinti ru'nea kora eri refitegeno ruse'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Hagi 150'a knamofo agu'afi timo'a akoheno taneno urami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hagi 7ni ikamofona, 17ni zupa ana ventemo'a eramino Ararati agonare eme runtrako hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Timo'a akoheno taneno uneramigeno 10ni ikamofo ese knazupa, mago'a agonamo'za osi'a hanaku hazage'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Hagi henka 40'a zagegna maniteno Noa'a zaho'ma erikana eri anagino, ");
INSERT INTO kbq_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kotikoti nama huntege vuteno, vano vano nehigeno, timo'a taneno uramigeno mopa efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hagi mopamo'ma ho'mu hu'nesigu, Noa'a mago maho nama huntegeno, ");
INSERT INTO kbq_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","hareno vano hiana manisnia zana omaneno tinke me'negeno ete e'ne. Egeno Noa'a aza antegame teno ventefi avre vazi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","11","Avrentegeno 7ni'agna manitegeno, Noa'a ete maho nama huntegeno hareno vu'ne. Hagi ana maho namamo'a kasefa olivi zafa asina atasino agipi haninkofino ana kinagage ehanati'ne. Ana higeno Noa keteno, hago timo'a taneno uramie huno agesa antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mago'ene 7ni'agna maniteno, ana mahona huntegeno hareno vuteno ete ome'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa'a 601ni'a kafuma nehigeno, pusa ikamofona ese knazupa, mika ama mopafina timo'a ho'mu higeno, Noa'a ana ventemofona amumpafinti anasgeno keana, mopamo'a ho'mu huvagare'negeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Anante 2 ikamofona 27ni knazupa mopamo'a ho'mu huvarenegeno Noa'a ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Anumzamo'a amanage huno Noana asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","17","kagrane nagaka'anena ventefintira atreta fegi'a atiramiho. Ventefima mani'naza zagagafane, namaramine, mika mopafi vano nehaza zagaraminena, zamavare atrege'za mopafi vu'za eza nehu'za kase hakare hu'za maniho. ");
INSERT INTO kbq_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Anage hige'za Noaki, nenaroki, mofavre naga'ane, anoferahe'zane atirami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Hagi ana zagagafane, ne'onse zagaramine, nama zagane, mika vanoma nehaza zagaramina, zamagrare zamagrare erizogi'za ventefintira atirmi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Anantera, Noa'a Ra Anumzamofonte Kresramana vu ita trohuteno, mago'a avusese zagagafafinti'ene avusese namafinti'enena aheno mika Kresramana vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Hagi Ra Anumzamo'a Kresramana vu'nea mana'a nentahino muse nehuno amanage hu'ne, vahe'mo'za kumi'ma hanaza zankura mago'anena ama mopa eri havizana osugahue. Hakare vahe'mo'za mofavrema mani'nazareti'ma eno ama knare'ma eana, havi antahi'zampinke mani'naze. Hakare zagaramima zamasimu nentaza zagaramina menima huaza hu'na zamahe refiotegahue. ");
INSERT INTO kbq_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ama ana mopa me'nenkeno maka'zana me'nena hoza negri'za, kafigahaze. Zasi'ma hu kna ne'enkeno, amuhoma hu kna egahie. Ko' aru knane zagegnanena nemenkeno, zagene hanine nehanigeno ana maka'zana vaga oregahie. ");
INSERT INTO kbq_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Noane mofavre naga'anena Anumzamo'a asomu hunezmanteno amanage huno zamasmi'ne, Mofavrea kase zamantenke'za ama mopa ruvite'za maniho. ");
INSERT INTO kbq_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Zafafima nemaniza zagaramima, timpima nemaniza zagaramima, namaramima, kazakaza hu'za vano nehaza zagaramina mika kegava hihogu tami'noanki'za tamagoro nehanageta kegava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ana zagagafa nesnagu meni neramue. Kotera hagu' kamosa tami'noanki'na, menina maka'zana nesnagu neramamue. ");
INSERT INTO kbq_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hianagi korama me'nea ame'a onegahaze, na'ankure korampina e'i asimu me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Tamage huankino, mago ne'mo'o, mago'a zagagafamo'zama tamahe'za tamagri korama eri fegi tesige'na, Nagranena ahena agri korana eri fegi atregahue. Mago'mo nefuma ahe frisnige'na, Ngaranena, agrira ahe frigahue. ");
INSERT INTO kbq_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Aza'o mago ne'ma ahe frisiana, ana nera ahe frigahaze. Na'ankure Nagra Anumzamo'na vahera Nagragna trohu zamante'noe. ");
INSERT INTO kbq_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Kagrane, kagehe'zane, vahera kase hakare huta miko'a mopafina mani viteho. ");
INSERT INTO kbq_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hagi mago'ane Anumzamo'a Noanku'ene, mofavre naga'agu'enena amanage huno zamasami'ne, ");
INSERT INTO kbq_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Menina antahio, kagrane, nagaka'ane kagehe'zane hagerfita mani'sunegu huvempage nehue. ");
INSERT INTO kbq_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Hagi ventefinti'ma atiramiza kagranema mani'naza zagagafane namaramine, kumate zagafaramine, trampi zagagafaraminte'ene ana huvempa kea nehue. ");
INSERT INTO kbq_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nagra huvempa ke'ni'a huama nehue, runena kora atresanugeno zamasimu ante'za mani'naza zagaramine, mopanena tina hageno zamahe fanane osugahie. ");
INSERT INTO kbq_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Anante Anumzamo'a huno, Nagrama amama nehuana huvempa ke nehue, Nagrane, tamagra'ene hakare zamasimu eneriza zagaramima tamagrane mani'nazane, henkama fore'ma hanaza vahe'ene amu'nontifi huvempa kea nehuanki'na, ");
INSERT INTO kbq_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","mago avame'zana monare furagena ante'nanena, negeta antahi vava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Hampona huntesugeno mopa refinetenkeno, furagenamo'a monare fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Nagrama kagri'ene maka ama mopafima zamasimu eri'za nemaniza zagagafagu'ma huvempama hu'noa ke'ni'agu nagesa nentahi'na, ete tinura tamahe fanane osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Hagi monare'ma furage'nama Nagrama negesuna, maka zamasimu'ma eri'za nemaniza zagaramina huvempa kema huzamante'noa kegu nagesa antahigahue. ");
INSERT INTO kbq_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mopafi vea'ene zagagafane huhagerafinogu avame'a, e'inahu'za fore hugahie, huno furagenakura Anumzamo'a Noana asami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Hagi ama Noa mofavre naga'ma ventefinti atirami'namokizmi zamagi'a, Semi'e, Hamu'e Jafeti'e. Hagi Hamu'a Kenani nefa'e. ");
INSERT INTO kbq_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noana tagufa mofavre nagapinti mopafima mani'nona vahera, forehu hakare hu'none. ");
INSERT INTO kbq_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Hagi tima hagetegeno henka, Noa'a hoza ne' mani'neno krepi hoza ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mago zupa waini tima'a neteno negineno kena omasi avufga avapa seli noma'afi mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenani nefa Hamu'a ome keana Noa'a avufa avapa mase'negeno keteno atiramino nempu'amokizni ome zanasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Hagi Semike, Jafetikea tavrave eri'ne zanafunte antetene zanamigati ana seli nompi vu'ne neznafana ome refitentena'e. Zanavugosa arugaziga hunte'ne nezanafa avufga onke'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Hagi Noa'ma negineno mase'nefinti henka ruhari huno negeno Hamu'ma hunte'nea zana keno antahino huteno, ");
INSERT INTO kbq_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Noa'a amanage hu'ne, Kenani'a sifnafi nemanino, afuhe'mokizmi zamagafinka evuramino amane eri'za vahe'zami manigahie. ");
INSERT INTO kbq_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hagi mago'ane Noa'a anage hu'ne, Semi Anumzamofo ra agi nemita agi'a ahentesga hanune. Kenaniga, Semi kato vahe manigahane. ");
INSERT INTO kbq_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anumzamo'a Jafetina, mopa'a erira huntenkeno Semi'ene tragotene mani'ne snakeno Kenani'a Jafeti eri'za vahe manigahie. ");
INSERT INTO kbq_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Timo'a tanetegeno Noa'a mago'ane 350'a Zagegafu mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Hagi ana miko 950'a zagegafu Noa'a maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Rantima hageno mika'zama ahe refitetegeno'a, Noana tagufa mofavre nagapinti maka'a vahera fore hu'naze. Ana kogna naga zamagi'a Semiki, Hamuki, Jafeti'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Hagi Jafeti mofavre naga zamagi'a ama'ne, Goma'e, Magogi'e, Madai'e, Javani'e, Tubali'e, Meseki'e, Tirasi'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Hanki Goma amohe'i zamagi'a Asikenazi'e, Rifati'e, Togarma'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Hanki Javani mofavre naga zamagi'a Elisa'e, Tarsisi'e, Kitimi'e, Dodanimi'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ana nagapintira refko hu'za hagerinkena mopa zamagerute zamagerute kognare, famote ranra kuma erifore hu'za kegava hutere hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hanki Hamu mofavre naga zamagi'a Kusi'e (Etopia), Mizrami'e (Isipi), Putie (Libya), Kenani'e (Palestine). ");
INSERT INTO kbq_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Hanki Kusi mofavre naga zamagi'a Seba'e, Havila'e, Sabta'e, Rama'e, Sabiteka'e. Hanki Rama'a tare ne'mofavre zanante'ne, zanagi'a Sebake Dedanike. ");
INSERT INTO kbq_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi'a, Nimiroti nefa'e. Nimiroti'a agra harafa nere. ");
INSERT INTO kbq_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Anumzamofo avurera knare harafa vahe fore huno mani'nea nere. E'ina'ma hu'negu menina vahe'mo'za rumofoma husga huntenakura, Nimroti kna vahe mani'ne hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimroti'ma kegava hu'nea moparera tagufa rankumara me'ne, zamagi'a Babelie, Erekie, Akatie, Kalne, e'i ana kumatmina Sinari (Babiloni) mopafi me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimroti'a Babiloni rankumara atreno, Asiria kaziga vuno rankumazaga ome azeri otino ki'ne. Ana kuma zamagi'a Ninive, Rehobotirie, Kalae, Resenie. ");
INSERT INTO kbq_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Hanki Reseni rankumara Ninivene, Kala kumamofo amu'nompi me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Isipi'a amana vahe'mokizmi nezamageho'e, Luti vahe'ma, Anami vahe'ma, Lehabi vahe'ma, Naftu vahe'ma, Pasru vahe'ma, Kaslu vahe'ma, Kriti vahere. Filistia vahera Kriti vahepinti fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenanina agonesa mofavrea Saidoni'e, hanki anazanke hu'za agripinti'ma fore'ma hu'nazana Hiti vahe'ma, ");
INSERT INTO kbq_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusi vahe'ma, Amori vahe'ma, Girgasi vahe'ma, ");
INSERT INTO kbq_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi vahe'ma, Arkisi vahe'ma, Sini vahe'ma, ");
INSERT INTO kbq_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvada vahe'ma, Zemari vahe'ma, Hamati vahe'mo'zanena Kenanimpinti fore hu'naze. Hanki henka Kenani, agehe'za mago mago hu'za ru mopare ru mopare umani emani hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Hanki Kenani vahe mopamo'a, Saidoni kumateti eri agafa huno Gerari vuno Gaza uhanatiteno, ananteti vuno Sodom Gomora kaziga uhanatino, Admane, Zeboim kaziga vuteno Lasa uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hamu agehe'za nagate nofite hu'za mani'neza ruzmegeru ruzmegeru neru'za rankuma trohu'za kegava hutere hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Hagi Semina mago'a ne'mofavre'a fore humi'neankino, Jafetina nempu amo'e. Semi'a Eberi nagamokizmi nezamageho mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semi mofavre naga zamagi'a, Elamu'e, Asari'e, Arpaksadi'e Ludiki, Aramu'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu mofavre naga zamagi'a Uzi'e, Huli'e, Getari'e, Masi'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksadi'a Sela nefa'e, Sela'a Eberi nefa'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi'a tare ne' mofavre zanante'ne. Mago'mofo agi'a Peleki'e, Peleki'e hu'nea agimofo agafa'a amanahu hu'ne, mopa refko hu'za nagate nofite hu'naze. Hanki nefu agi'a Joktani'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktani'ma zamante'nea naga zamagi'a, Almodati'e, Selepi'e, Hazarmaveti'e, Jera'e, ");
INSERT INTO kbq_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramuki, Uzaliki, Dikla'e, ");
INSERT INTO kbq_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaliki Abimaeliki, Seba'e. ");
INSERT INTO kbq_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Hagi Ofiriki, Havilaki, Jobabiki hu'za zamagra Joktani mofavre naga mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","E'i ana naga'ma kuma tro hu'za mani'naza mopamo'a Mesati agafa huteno vuno, Sefari zage hanatitega agona mopama me'nerega uhanatine. ");
INSERT INTO kbq_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hagi Semimpinti'ma fore hu'naza vahera nagate nofite mago mago hu'za manitere hu'ne'za zamagerute zamagerute hu'za mopa zamire mani'ne'za, rankuma trohu'za kegava hu'za manitere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hagi tima hagetegeno ana amefi'a Noa ahi'mo'za mofavre naga'afinti forehu anante anante nehu'za, hakare kaziga mopafina ranra kuma ante'za maniza vu'za e'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Korapa knafina ama mopafima mani'naza vahe'mo'za magoke zamageruke neru'za, magoke kege hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Vahe'mo'za hage'za zage hanatitega nevu'za mago agupo mopa Sinar (Babiloni) ome kete'za, anante kuma ome ante'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mani'ne'za ke hugantugama hu'za anage hu'naze, Mopa kateta briki tro huta tevefi kre hanavenetita, kolta fuki erita simenia eri hanavetita tro huta nona kisune hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Anante amanage hu'naze, Tagrati rankuma trohuta za'za no kita monafi marerisnunkeno, ana nomo'a ran tagi neramina, arurega vuta eta hu'zankura tazeri atru hanie. ");
INSERT INTO kbq_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hianagi Ra Anumzamo'a rankuma'ene, zaza none, vahe'mo'zama ki'naza nonku'ma kenaku erami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ra Anumzamo'a amanage hu'ne, Zamagra magoke naga mani'ne'za magoke zamageru neru'za, amazana eri agafa hazankiza, mago'zama hunaku'ma hanaza zana, amne tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","E'i zanku tagra uramita ke'zami eri savari hamanenke'za, zamagra zamageru'ma antahizankura amuho hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Anage nehuno Ra Anumzamo'a zamazeri fragu vazige'za kumazimi tro huvaga ore'za atre'za maka moparega vu'za e'za hu'za umani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","E'ina hu'nea agafare ana ran kumakura Babelie hu'za hu'naze. Na'ankure Ra Anumzamo ana mopafi vahe'mokizmi zamagerura zamazeri havia huteno, hakare moparega zamazeri atrege'za vu'za e'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Tima hagetegeno tare kafuma evigeno'a, Semimpinti'ma fore'ma hu'naza vahera amana hu'ne. Semi'a 100'a zagegafu huteno, Arpaksadina nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpaksadi nafa'za huteno Semi'a 500'a zagegafu nehuno ne'mofara mago'ane zamante'ne. Semi'a 600'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksadi'a 35'a zagegafu huteno, Selana nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksadi'a Sela nefa'zama huteno'a, 403'a zagegafu nehuno mago'ane ne'mofara zamante'ne. Arpaksadi'a 438'a zagegafu huteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela'a 30'a zagegafu maniteno, Eberina nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela'a Eberi nefa'za huteno 403'a zagegafu nehuno mago'ane ne'mofara zamante'ne, Sela'a 433'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberi'a 34'a zagegafu maniteno, Peleki nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eberi'a Peleki nefaza huteno, 430'a zagegafu nehuno mago'ane ne'mofara zamante'ne. Eberi'a 464'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleki'a 30'a zagegafu nehuno Reuna nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleki'ma Reu nefa'za huteno 209ni'a zagegafu maniteno mago'ane ne'mofara zamante'ne. Peleki'a 239ni'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu'a 32'a zagegafu maniteno, Serugina nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugi'ma fore hutegeno henka Reu'a 207ni'a zagegafu maniteno, mago'ane ne'mofara zamante'ne. Reu'a 239ni'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi'a 30'a zagegafu maniteno, Nahona nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serugi'a Naho nefaza huteno 200'a zagegafu maniteno, mago'ane ne'mofara zamante'ne. Serugi'a 230'a zagegafu huteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naho'a 29ni'a zagegafu nehuno, Terana nefa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naho'a, Terana nefa'za huteno 119ni'a zagegafu maniteno, mago'ane ne'mofara zamante'ne, Naho'a 148'a zagegafu maniteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera'ma 70'a zagegafu nehuno'a Abrama, Nahoma, Haranikizmi nezmafa'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera nagara amanahu hu'ne. Tera'a Abrama, Nahoma, Haranikizmi nezmafa'e. Hagi Harani'a Loti nefa'e. ");
INSERT INTO kbq_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera'a ofri mani'negeno, Harani'a kasente'naza kumate Ur kaziga Kaldi'a mopare fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Hagi Abramu'ene Nahokea a' eri'na'e. Hagi Abramu a'mofo agi'a Sarai'e. Naho a'mofo agi'a Milka'e, agra Harani mofare. Milkane Iskakizni neznafa'e. ");
INSERT INTO kbq_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hianagi Sarai'a mofavre onte narvo a' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Hagi Tera'a mofavre'a Abramuma, negeho Lotima Abramu nenaro Sarainki huno nezmavreno Kaldi'a kaziga Ur kumara atre'za Kenani vunaku vu'naze. Hianagi Harani kumate'ma unehanati'za anante umani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera'a 205fu'a zagegafu huteno, Harani mopare fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ra Anumzamo'a amanage huno Abramuna asami'ne, Mopakane, vaheka'ane negafa vahe'enena zamatrenka Nagrama kaveri hanua mopare vuo. ");
INSERT INTO kbq_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nagra kagripinti vahera zamazeri ra hanuge'za, rama'a vahe fore hu'za manigahaze. Nagra asomu hunegante'na, kagi'a eri ra neha'nena, kagripinti maka ama mopafi vahe'mo'za asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kagri'ma asomu hugantesimofona Nagra asomu huntegahue. Hianagi aza'o kagri'ma kazeri haviza hanimofona, Nagra azeri haviza hugahue. Maka mopafi naga'mo'za kagripinti asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Anumzamo'ma kema asmiaza huno Abramu'a Harani kumara atreno nevigeno, Loti'a agrane vu'ne. Abramu'a 75'a zagegafu nehuno Haranitira otino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu'a nenaro Saraima, nagana'amofo mofavre Loti'ma, eri'za vahe'ane, nezmavreno maka afufenoma'ane e'nerino Harani kumara atre'za Kenani mopare vu'za, Kenani uhanati'naze. ");
INSERT INTO kbq_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Hanki Abramu'a Kenani mopa amu'nompi rugitagino eva eva huno Sekemu ra oki zafa me'nere More kumate ehanati'ne. Hanki ana knafina Kenani vahe'mo'za ana mopafina mani'nageno ehanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ra Anumzamo'a Abramunte eno amanage huno eme asmi'ne, Maka ama mopa nagaka'a zamigahue, higeno Abramu'a Ra Anumzante Kresramana vunaku ita trohu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ananteti atreno agonarega vuno Betel kumara agatereno, Ai zage hanati kaziga megeno, Betel kuma zage fre kaziga me'negeno amu'nompi seli nona ome ki'ne. Ana huteno Ra Anumzanku nentahino, have ita tro huno Ra Anumzamofo agihanta vazino monora hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hagi Abramu'a mago'ene manitere hume vuno Negevi uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ana knafina tusi'a agatonto kna fore higeno Abramu'a Isipi moparega vu'ne, na'ankure tusi'a agate kna fore higeno'e. ");
INSERT INTO kbq_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Hagi Isipima vu kofta nehuno nenaro Sarainkura amanage huno asami'ne. Kagri'ma kagoana kagra knare hunka soe a' mani'nananki'za, ");
INSERT INTO kbq_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isipi vahe'mo'za kagesu'za Agri nenaro'e hu'za nahe fri'za kagrira a' kavre antegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","E'ina hu'negu, nensaro mani'ne hunka huge'za onahe'za natre'sage'na mani'neno. ");
INSERT INTO kbq_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramu'a anage huno nehuno Isipi uhanatige'za, Isipi vahe'mo'za Saraima kazana knare a' mani'nege'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Fero eri'za vahe'mo'za Saraina kete'za Ferona ome asami'za, knare a' mani'ne hu'za nehu'za, Saraina avre'za Fero nompi ome ante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero'a Saraima muse huntea kazigati, knare huno Abramuna kegava hunenteno, sipisipima, bulimakaoma, donkima, eri'za vahera vene a'ene nemino, a' donkine kemorine huno Abramuna ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hianagi Ra Anumzamo'a tusi'a krirami atregeno Feronte ene, noma'afima nemaniza vahete'ene e'ne. Na'ankure Abramu nenaro Sarainteku e'inahura huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Fero'a ke higeno Abramu'a egeno anage huno asami'ne, Na'a ama zana hunante'nane? Nahigenka Sarai'a a'ni'a mani'ne hunka onasmi'nane? ");
INSERT INTO kbq_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nahigenka nensaro'e hankena ara avre'noe? Ama'ne negnaro'a! Ko avrenka vuo. ");
INSERT INTO kbq_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fero'a hankave'ane ke vahe'a huzmanteno, Abramuna kegava hu'nenkeno nenaro'ene mika afu fenoznia enerine, ama mopa atrene vi'o huno huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramu'a Isipi mopareti hakare afufenoma'a enerino nenarone, Lotine neznavreno Negev vu'naku mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Menina Abramu'a afu'zagama, golima, silvama huno rama'a ante'nea ne'kino tusi'a feno ne' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Hagi masetere hume nevuno, Negev mopare vuno ko'ma mani'neno'ma hu'nere uhanati'ne. Mago kaziga Beteli kuma me'negeno, mago kaziga Ai kuma me'nere uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Abramu'a ko'ma have itama tro hunte'nere anante uhanatino, Ra Anumzamofona mono hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abramu'ene vu'nea ne' Lotina sipisipi afu'zaga'ane, bulimakao afuzaga'ane seli noma'araminena me'nea ne' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Hianagi anama mani'a mopamo'a knarera huozanante'ne. Maka afuzaga zani'amo'a titipa huno ne'zama ne'zamo'a atupa higeno, magopi manigara osu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ana nehigeno Abramune, Lotikizni afu kva vahe'mo'za fra vazi'naze. Ana knafina Kenani vahe'ene, Perisi vahe'mo'za ana mopafina mani titipa hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abramu'a amanage huno Lotina asami'ne, Tagra mago kora mani'noku fra ovazisnue, bulimakao afuti'are kegavama nehaza vahe'mo'zanena fra ovazisazanki, ");
INSERT INTO kbq_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","rama'a mopa me'neanki kagra kavesite vanuema hanana kaziga vuo. Kagrama hoga kaziga vugahue hananke'na, nagra tamaga kaziga vugahue. Hanki kagrama tamaga kaziga vugahue hananke'na, nagra hoga kaziga vugahue. ");
INSERT INTO kbq_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti'ma kesga huno kegantugama nehuno Zoari kazigama keana, Jodani kokamo'a hakare kaziga masavenke huno Ra Anumzamofo Edeni hozagna nehuno, Isipi mopagna hu'negeno ke'ne. Anama hu'neana Sodomune, Gomoranema Ra Anumzamo'ma ahe fananema osu'nea knafi anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Anante Loti'a mika Jodani agupoma hunehamprino'a zage hanatitega vu'ne. Ananteti naga'ane otre atre hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu'a Kenani mopare manigeno, Loti'a ranku'ma zaga me'nefi Jodani agupofi Sodomu tva'onte seli noma'a omegino mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomu vahe'mo'za havi avu'ava nehu'za kumi huhakare hu'za, Ra Anumzamofo ha' rente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti'ma, Abramu'ma atreno vutegeno, Ra Anumzamo'a amanage huno Abramuna asami'ne, Kesga hunka zage hanatitegane, zage fretegane keganti kegama hunka ko. ");
INSERT INTO kbq_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Hagi mika kagri'ene, kagehe'ine tami vaganeroe. ");
INSERT INTO kbq_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nagra kagehe'ina zamazeri hakare ha'nena, ama mopafina kugusopagna hanage'za, vahe'mo'zahamprigara osugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hagi otinka vunka enka nehunka, kamisua mopamofo agema'a ko. ");
INSERT INTO kbq_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Higeno Abramu'a otino seli noma'a tagna vazino erino vuno Mamre me'nea oki zafa tavaonte Hebroni kumate, Ra Anumzamofo ita ome tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ana knafina ana mopafima nemaniza kini vahe'mo'zara ha' hu'naze. Mago kaziga mani'naza kini vahe'mokizmi zamagi'a, Amrafeli'a Babiloni kumate kini nere. Arioki'a Elasa kumate kini nere. Kedolaoma'a Elami kumate kini nere. Tidali'a Goimi kumate kini nere. ");
INSERT INTO kbq_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Hagi vu'za ha' ome huzmante'nazana Bera'a Sodomu kumateti kini nere. Birsa'a Gomora kumateti kini nere. Sinabu'a Adma kumateti kini nere. Semeba'a Zeboimi kumate kini nere. Hagi Bela kumaku'ma, Zoari kumarema nehaza kumateti kini ne'ene hara hu'naku hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hagi ana knafina e'i ana kumatera kini vahe'mo'za magopi hagerafi'za Sidimi krahopi nemani'zane. Ana kazigagura menina Fri Hagerine hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","E'i ana kumatamimpi vahera 12fu'a zagegafufina Kedolaoma kegava huzmantege'za mani'naze. Hagi 13nima hiankafufina zamasi vazige'za, ke'a antahi omi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Hagi 14nima hiankafufina Kedalaoma'ene hagerafi'za mani'naza kini vahe'mo'za eza Refaim vahe'ma, Astero-Karnaimi kumate'ene Zuzimi kumate'ene Hami kumate'ene, Emimi kumate'ene Save-Kiriataim kumate vahe'ene, ");
INSERT INTO kbq_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Horaeti kumate vahe'enena ha' eme huzmanteza zamavaririge'za Idomu mopa zamirega El-parani nevazage'za, zamarotgo hu'za hagege hu'nea ka'ma mopa me'nea tvaonte vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hagi ete rukrahe'ma hu'za En-mispatima ne-e'za, Amori vahe mopa zamahe'za nehanare'za, Hazazon-tamari nemaniza, Amori vahe'mokizmi mopanena ha' huzmante'za eri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Anantera Sodomu kinigi, Gomora kinigi, Adma kinigi, Zeboim kinigi, Bela kiniki, Belagura menina Zoari hu'za nehazankino, ana 5fu'a kini vahe'mo'za eri mago hute'za, Sidim agupofi hara hunaku tro hu'naze. (Dead Sea) ");
INSERT INTO kbq_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Hagi Sidim agupofima ha'ma hazana, Kedolaoma'a Elami kini neki, Tidali'a Goimi kini neki, Amrafeli'a Sainari kinigi, Arioku'a Elasari kini ne'ki hu'za ana 4'a kini vahe'mo'za 5fu'a kini vahe'ene Fri Hagerima me'nea agupofi hara hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ana agupofina koltama kafizama eneri'za keriramina hakare'a me'neankino, Sodomu kini ne-ene Gomora kini ne'ene sondia vahe'znine koro freza ne'eza ana keriramimpi tamizageno, mago'a amanema mani'zamo'za fre'za agonarega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ha'ma hugateraza 4'a kini vahetamine sondia vahe'zmimo'za, Sodomu kumateti'ene Gomora kumatetira maka fenozmine hozafinti mika ne'zazminena eri'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ana nehu'za Abramuna nefu mofavre Loti'a Sodomu kumate mani'nege'za nevre'za, afufenoma'ane eri'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hianagi anampinti mago ne'mo zamatreno freno nevuno, Hibru ne' Abramuna ana mikozamofo nenekea ome asmi'ne. Ana knafina Abramu'a Amori ne' Mamre oki zafa agafare mani'ne. Hagi Mamre'a Eskoline, Anelkizni'a neznafukino Abramu'ene tragote'za mani'nazageno anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Hagi ha' vahe'mo'zama Lotima avre'za vu'naza nanekema Abramu'ma nentahino'a, agranema maninaza vahe'mo'zakasezmante'za ha'zama rempi huzamige'za antahi'naza vahetamina 318ni'a vahe zamavare'za zamarotgo hu'za vuvava hu'za Dani uhanati'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abramu'a eri'za vahe'a ana kenage zamazeri atru huno tarefi refko huzmantege'za nevu'za, ha' vahera hara hu zamagatere'za zamarotgo hu'za Damaskas kumamofo noti kaziga Hoba uhanati'naze. ");
INSERT INTO kbq_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hagi ha'ma eme hu'za maka fenone, negana mofavre Lotine, maka'zane a'nene vahe'ene hapinti eri'za vu'naza zanena Abramu'a mika zana ete erino ene. ");
INSERT INTO kbq_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Anantera Abramu'a Kedalaoma'ene mani'naza kini vahe ha' huzmagatereteno ete e'ne. Hanki Sodomu kini ne'mo'a Save agupofi eme agenaku e'ne. Ana agupogura kini vahe'mokizmi agupoe hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkizedeki'a Salemi kinigino, bretine, wainine erino eme ami'ne, agra Marerisa Anumzamofo pristi nere. ");
INSERT INTO kbq_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Abramuna amanage huno asomu kea hunte'ne, Monane mopane eri fore hu'nea Marerisa Anumzamo'a kagrira asomura hugantegahie. ");
INSERT INTO kbq_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ha' vahe ka'a kagri kazampima ante'nere Marerisa Anumzamofo ra agi amisune. Higeno Abramu'a mika zama eri'nefintira refko huno 10ni'a kevu anteteno, anampinti mago kevu Melkizedekina ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodomu kini ne'mo'a Abramunkura amanage hu'ne, mika vahe'zaga nagri nenaminka, Mika fenona kagraka'a erio. ");
INSERT INTO kbq_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Hianagi Abramu'a Sodomu kini nekura amanage hu'ne, Monane mopane tro'ma hu'nea Marerisa Anumzantega nagra huvempage hunte'noankina, ");
INSERT INTO kbq_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ru kagra nehunka Abramuna nagra hugeno feno nera mani'ne hunka hu'zanku nagra kukena hati nofiro, agia anomofo nofira, e'oritfa hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nagrani'a mago'zana e'orisoanagi, vahe'ni'amo'zama ko'ma ne'zama ne'nazareke mesie. Hanki nagranema hate'ma vu'namokizmi atrege'za Aneriki, Eskoliki, Mamreki hu'za mago'a zana zamagra'a eriho. ");
INSERT INTO kbq_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Henka'a Ra Anumzamo'a ava'na gnazampi amanage huno Abramuna asami'ne, Abramuga korera osu. Nagra hankoka'agna hu'na mani'noe. Ana nehu'na rama'a knare'nare zantamina kamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Hianagi Abramu'a anage hu'ne, Ra Anumzamoka hakare'za nami'nanke'na, mofavre onte'noanki, iza anazana erigahie? Frisugeno'a Damaskasi kumati eri'za ne'nimo Eliesa erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Hanki mofavre onami'nanankino, noni'afima kasente'nea eri'za vahe'nimo ana afufenoni'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Hu'neanagi Ra Anumzamo'a kenona'a huno, A'o! Rumo'a afufenonka'a e'origosie. Kagrama kasentesana mofavremo afufenonka'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Huno nehuno Abramuna avre atiramino megi'a vuno anage huno asmi'ne, monafi hanafitamina hampriga hunampi kesga hunka ko? Higeno kesga huno kegeno, Anumzamo'a huno, ana avamente kagripintira kagehe'za fore huhakare hu'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ra Anumzamo'a anage huno asmigeno, Abramu'a ana kea nentahino, amentinti nehigeno Anumzamo'a fatgo nere huno Abramunkura hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hagi Ra Anumzamo'a amanage huno Abramuna asami'ne, Ur kumateti, Kaldia vahepinti Nagra Ra Anumzamo'na kavre'na e'nomo'na, ama mopa negamue. ");
INSERT INTO kbq_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Higeno Abramu'a huno, Marerisa Anumzamoka ama mopa kamigahue nehanana, inankna kazigati ama mopa erigahue hu'na ke'na antahi'na hunaku hugenka nehane? ");
INSERT INTO kbq_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Higeno Ra Anumzamo'a amanage huno asami'ne, Tagufa kafu hu'nesia bulimakao a' anenta afu'ene, tagufa kafu hu'nesia a' anenta memene, tagufa kafu hu'nesia ve lama afu'ene, tare maho namararene, zamavarenka Nagrite eno. ");
INSERT INTO kbq_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Higeno Abramu'a kema hia kante anteno ana zagaramina aheno rutne tare hugagufeno kanti kama nenteno, namararena taga osu aga' ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ana zana tumpa namamo'za kete'za nenaku neageno Abramu'a keteno harige'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Hagi zage ufregeno avukoko higeno Abramu'a mase himare'neno, avanama keana, tusi'a hanimo agrira refitente'negeno negeno koro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ra Anumzamo'a amanage huno Abramuna asami'ne, Nagra amama negasamua kea antahise huo. Kagehe'za ru vahe mopafi umani'nesage'za zamazeri haviza nehanage'za, kazokzo eri'zana 400'a zagegafufi erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Hianagi Nagra ana eri'za eri'zmantesaza kumate vahera keaga huzamantegahue. Ana amefiga'a zamagrama atirami'za esu'za, rama'a feno eri'za egahaze. ");
INSERT INTO kbq_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Hanki kagra Abramuga zaza kna so'e hunka manitenka, ozafa renka krimpa frune frisanke'za asegantesagenka kafahezane umanigahane. ");
INSERT INTO kbq_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Hanki kagehe'za 4'a zupa vahera forehu anante anante hute'za, ete ama moparera egahaze. Ana knazupa Amori vahe'mo'zama hu'naza kumikura zamazeri haviza hugahue. Hianagi Amori vahe'ma zamazeri haviza hanua kna zahufa ome'ne. ");
INSERT INTO kbq_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Hagi zage ufreno hani higeno Abramu'ma keana, nezama kre kavofina tevegumo'a tusiza nehifinti, tevemo'a akrukru huno nerea tevemo afu'ma rutanenteno refko hunte'nea amunompi nevigeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ana zupage'za Ra Anumzamo'a Abramu'ene hagerfine manisa'a kea huvempa huno amanage hu'ne, ama mopa kagehe'i zamigahue. Isipi tima me'nereti agafa huteno vuvava huno, Jufretisi rantima me'nere vanige'na, ana maka mopa zamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ana mopare mani'naza vahe'mokizmi zamagi'a, Kenasi vahe'ene, Kin vahe'ene, Kadmo vahe'ene, ");
INSERT INTO kbq_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti vahe'ene, Peresi vahe'ene, Refaemi vahe'ene, ");
INSERT INTO kbq_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori vahe'ene, Kenani vahe'ene, Gilgasi vahe'ene, Jebusi vahe'mokizmi mopa erisanti haregahaze. ");
INSERT INTO kbq_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abramu nenaro agi'a Saraikino, mofavre onte narvo a' mani'ne. Hagi Isipi mopareti Sarai'a eri'za mofa'a Haga avregeno eri'zama'a enerino mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai'a amanage huno Abramuna asami'ne, Kama antahio. Ra Anumzamo'a mofavre kuni'a erigige'na mofavre kaseontoanki, vunka eri'za a'ni'ane umasegeno agripinti mago'a mofavrezaga eri fore hunamino, huno higeno Abramu'a a'amofonke antahino ana hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hagi Abramu'ma Kenani mopare 10ni'a zagegafu manitegeno, Hagana Isipiti'ma avre'nea eri'za mofara Abramuna nenaro'za hanie huno Sarai'a avre ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Higeno Abramu'a Hagana anteno masegeno, Haga'ma keno antahino'ma hiana amu'enema nehuno'a, kva'a Saraina ke azanava hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Hagi Sarai'a amanage huno Abramuna kesu'ne, Kagra haviza hu'nankeno eri'za a'mo'a antahi haviza hunenanteno avesinonante. E'i ana knazamo'a nagritetira kagrite vugahie. Nagra eri'za a'nia avre kamugenka antenka mase'nankeno amu'ene huteno antahi haviza hunenante. Kagra havizana hu'nampi, Nagra havizana hu'nofi, Ra Anumzamoke nerageno refko hurantegahie. ");
INSERT INTO kbq_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Hianagi Abramu'a amanage huno Saraina asami'ne, Antahio, knareki kagri eri'za a' mani'neanki kagri'ma kavesisaniaza hunto, huno higeno Sarai'a tusiza huno Hagana azanava higeno koro freno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Freno Suri kumatega nevia kamofo kampui ti me'nere ka'ma mopafi umani'ne. Anante Ra Anumza'mofo ankeromo eme negeno, ");
INSERT INTO kbq_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","anage hu'ne, Hagaga, Sarai eri'za a'moka igati ne-enka, iga vu'za nehane? huno higeno, Saraima eri'zama'ama eri nentoa a'mofo kvafinti fre'na e'noe. ");
INSERT INTO kbq_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Higeno Ra Anumzamofo ankeromo'a amanage huno asami'ne, Rukrahe hunka vunka, umani'nenka ke'amofo amage antenka eri'zama'a omerinto, ");
INSERT INTO kbq_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","huno nehuno anage hu'ne, Nagra kazeri ra ha'nena kagehe'za ohampriga'a vahe fore hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ra Anumzamofo ankeromo'a mago'ene huno, Kamu'ene hunankeno kna kavenesigenka ke hankeno Anumzamo'a antahi'negu ne'mofavre kasentenka ana mofavremofo agi'a Ismaeli'e hunka antegahane. ");
INSERT INTO kbq_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hagi mofavre ka'amo'a ra huteno, afi' donki afu kna huno manigahie. Hagi agra mika vahera nezmahenke'za agrira ahegahaze. Afu agna'zanena fru huno omanigosie. ");
INSERT INTO kbq_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hanki Haga'a ke humia Ra Anumzamofo agi neheno amanage hu'ne, Kagra nenagana Anumzane, na'ankure nagra kagoanagi ofri mani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ana hu'negu ana tinkerimofo agi'a Bir Lahai Roie hu'ne. Ana tinkerimo'a Beretine, Kadesine amunozanifi me'neankino, menina me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hanki Haga'a ne' kasentegeno, Abramu'a ana mofavre agi'a Ismaeli'e huno agi'a ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramu'a 86'a zagegafu manitegeno Haga'a Ismaelina kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramu'a 99ni'a zagegafu higeno, Ra Anumzamo'a agrite efore huno amanage huno asami'ne, Nagra Hihamu'ane Anumzamo'na kagrira negasmue. Nagri namagenentanku fatgo kavu'kava hunka manio. ");
INSERT INTO kbq_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Hanki Nagri huvempa keni'amo'a amu'nonti'afi me'nena, Nagra kagripinti vahera zamazeri hakare hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramu'a avugosaregati mopafi mase'negeno, Anumzamo'a mago'ene amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Nagra kagrane huhagerafi huvempa ke huankino, hakare'a kokantega vahera kagripinti fore hu'za ku'ma ante'za mani avitesnagenka, kagra nafazami'za hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hagi Abramuge hu'za mago'enena kagia ohegahaze. Menina Abrahamuge hu'za hugahaze. Na'ankure kagra hakare'a veamokizmi nafazamiza hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nagra kazeri ra hanena kagripinti hakare'a kokankoka vahera fore nehanageno, kini vahe'enena fore hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Hanki'na Nagra amunonti'afi huhagerafi huvempage huankino, ama ana mevava huvempa ke'mo'a, kagrite'ene kagripinti'ma fore hanaza vahete'ene henkama fore hunante anante hu'za vanaza vahete'enena meno nevanige'na Nagra kagri Anumza mani'nena, kagripinti'ma fore hu anante ante'ma hu'za vanaza vahe'mokizmi Anumza manigahue. ");
INSERT INTO kbq_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kagri'ene, kagehe'ine, henkama fore hanamokizmine kragama emanina Kenani mopa tamivaneroe. Ana mopamo'a tamagriza seno mevava nehina, Nagra zamagri Anumza manigahue. ");
INSERT INTO kbq_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hagi Anumzamo'a mago'ene amanage huno Abrahamuna asami'ne, Kagrane mofavrezaga ka'ane, kase anante anante hanamozanena huvempa keni'a amage anteho. ");
INSERT INTO kbq_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nagranema huhagerafi'nonku amanahu hugahaze, ne' mofavretmia mika zamagozamofo amega anoma'a taga hutregahaze. Henkama fore hu' anante anante'ma hu'za vanaza vahe'mo'zanena ana zanke hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Abrahamuga, Nagrane huhagerafi'noa zamofo avame'zama mesiana, kagozamofo amega noma'a taga hutro. ");
INSERT INTO kbq_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hagi maka ne' mofavre'ma kasentesamokizmia 8ti zage gnare, knane knanena henkama fore hanaza mofavre'mokizmi zamufga taga hugahaze. Nonka'afima eri'za vahe'mo'ma kasentesia vahe'pinti'ene zagoreti'ma mizasesana vahe'ma aruregati e'nesia vahe'enena zamufa taga huzmantegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kagri nompima mani'ne'za kasentenesa vahepi, zagoreti miza hu'nenaza vahe'mo'zanena, zamagoza anoma'a taga hugahaze. E'inama hanaza zamo'a Nagranema huhagerafi'noa zamofo avame'za zamagri zamufgarera mevava hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Hagi agoza anoma taga osanimo'a, Nagranema huhagerafi'noa kea ruhantaginigu, agrira naga'afintira avre atregahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hanki Anumzamo'a amanage huno Abrahamuna asami'ne, kotera negnarona Sarai'e hu'nane. Hagi menina kasefa agi'a Sera'e hunka hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nagra Serana asomu huntesugeno, agra mofavre eri fore hunegamina, asomu huntanena hakare vahe'mokizmi antazmiza nehanigeno, agripinti kini vahera fore hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahamu'a rena reno kepri huno agu'afina kizanereno anage hu'ne, Nagra 100'a zagegafu hugeno Sera'a 90'a zagegafu higeta, ko' ozafa tavava re'noanki, inankna huta mofavre kasentenaku nehukeno nehie? ");
INSERT INTO kbq_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahamu'a amanage huno Anumzamofo kenona hu'ne, knare Ismaeli'a kavure mani'neno asomura erigahie! ");
INSERT INTO kbq_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hianagi Anumzamo'a amanage hu'ne, A'o tamage huno negnaro Sera'a mofavre kasentesigenka, agi'a Aisaki'e hunka antegahane. Nagra agrane huvempa hanugeno ana huvempa kemo'a agrite'ene, agripinti'ma henkama fore hu anante anante'ma hanaza vahete'ene mevava huno vugahie. ");
INSERT INTO kbq_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ismaeli kazigagu'ma nantahima kanana, hago antahuanki'na Nagra asomu huntesugeno, agripintira rama'a vahe fore hu'za manigahaze. Ana nehanageno 12fu'a kva vahe'mokizmi nezmafaza hugahie. Nagra agehemokizmia zamazeri hankavetisuge'za hanvenentake vahe manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hianagi Nagra hu hagerafi huvempa ke'ni'a, Sera'ma kasentesia mofavre Aisakinte eri hanavetigahue. Ama ana knare anaga'a kafufi kasentegahie. ");
INSERT INTO kbq_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anumzamo'a anage huno Abrahamu asmiteno, atreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abrahamu'a Ismaeline, eri'za vahe'amokizmine zamazerino zamagoza anona taga huvagare zamante'ne. Agranema manine'za kasezmante'naza eri'za vahe'ane, ru mopareti miza se'nea vahe'ane miko zamagoza anona taga huzmante'ne. Anumzamo'ma asmi'nea kante anteno ana zupage'za taga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu'a 99ni'a zagegafu manino ozafa reteno, avufga taga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Hanki Ismaeli'a 13ni'a zagegafu huno nehazave seno manigeno avufga taga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","E'i ana zupage Abrahamune, Ismaelikizni zanavufga taga huzanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Miko eri'za vahe'ane, mofavrezimine agrane nemaniza kasente'nazampi, arurega vahe zagoreti miza sezmante'nea vahe'ene ana mika zamagoza anona taga hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahamu'a zagemo tusi amuho higeno, Mamrea hunagru hu'nea oki zafa agafare seli noma'a kasante mani'negeno, Ra Anumzamo'a anante ehanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Seli noma'a kasante mani'nereti kesga huno keana, taregi magoki vahe oti'nageno keteno, agareno viazamo zamagafi ome arena areno kepri huno, ");
INSERT INTO kbq_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","anage hu'ne, Ranimota nagrama knare nehanugeta musema nehusuta eri'za vahetami mani'nogu muse huramantoanki nagatereta eoviho! ");
INSERT INTO kbq_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Muse huramantoanki ama zafa agafare manigsa hunenke'za osia tina afi'za eme tamina tamaga sese hiho. ");
INSERT INTO kbq_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ana nehanage'na ne'zana uri'na eme taminena neneta manifru huteta kama vanarega vugahaze. Eri'za vahekamo'na noni'a kasante nantu ante nante'nagu ne'zana neteta vugahaze, hige'za knareki kema hanaza huo. ");
INSERT INTO kbq_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Anage hazageno Abrahamu'a ame huno noma'afi umarerino amanage huno nenaro Serana asamine, Knare hu'nesnia flaua tagufa kevu urinka eme herunka bretia kro, ");
INSERT INTO kbq_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","nehuno Abrahamu'a agareno vuno bulimaka'afinti anenta afu ome aheno eri'za vahe'a eme amigeno, hantka huno erino ome kre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abrahamu'a meme'mofo ami rima'a tagino eme ante nezmanteno, ko'ma kragefe'neama'a erino kaone eme ante nezamanteno tva'onte zafa agafare otino mani'nege'za ne'naze. ");
INSERT INTO kbq_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nene'za mani'ne'za Abrahamuna amanage hu'za antahige'naze, Negnaro Sera'a iga mani'ne? Hazageno Abrahamu'a huno, Ami seli nompi mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Higeno anampinti mago'mo'a amanage huno hu'ne, Henka'a ama ana knare'ma esnuana negnaro Sera'a ne' mofavre kasente'nena egahue. Huno nehigeno agu'afi Sera'a seli no kasama'are mani'neno ana ke antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamuke ozafa tavava rakeno, kafu zanimo'a agaterege'ne. Sera'a mofavre antega osu'negeno avufagamo ampasagigeno mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ana higeno Sera'ma ana kema nentahino'a agu'afi kiza nereno amanage huno agesa antahi'ne, Nagrane ranimo'enena ozafa tavava renoanki, inankna huno mofavrea fore huraminogu nehie? ");
INSERT INTO kbq_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ra Anumzamo'a amanage huno Abrahamuna asami'ne, Nahigeno Sera'a kizana nereno, tavavamo'na inankna huna mofavrea kasenteku hugeno nehie huno nehie? ");
INSERT INTO kbq_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nazamo Ra Anumzamofona amuho huntegahie? Anaga'a kafufina ama ana knare, Sera'a ne' mofavre kasente'nena egahie. ");
INSERT INTO kbq_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sera'a amano vazigeno havige huno, A'o kizana ore nogenka nehane, huno higeno Anumzamo huno, A'o kagra kiza re'nane. ");
INSERT INTO kbq_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ana tagufa vahe'mo'za oti'za vunaku nehu'za, Sodomu kuma me'nea kaziga zamavurga negageno (Abrahamu kantega ome zamatreteno enaku nevigeno), ");
INSERT INTO kbq_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ra Anumzamo'a amanage hu'ne, Menima hunaku'ma nehua zana Abrahamu avurera eri frara okisue. ");
INSERT INTO kbq_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tamage huno Abrahamumpinti tusi'a hankavenentake vahe fore hu'za kuma ante'za manigahaze. Kokankoka mika kumate vahe'mo'za agripinti asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nagra Abrahamuna huhamprinte'noankino mofavre'ane, agehe'ine huvempa keni'a rempi huzamisige'za, mani fatgo hu'za nemaniza fatgoma huno refkoma hu avu'ava zana nehu'za Ra Anumzamo'na kante vanazegu huhamprinte'noe. ");
INSERT INTO kbq_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Anante Ra Anumzamo'a amanage hu'ne, Sodomune Gomora vahe'mokizmia tusi'a kumizmimofo kezanke antahue, hankino kumi'zmimo'a tusi'a zampi mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","E'ina hu'nagu kumi zmimofo zamagenkema antahi'noa zana tamagefi, urami'na ome zamage'na antahina hanue. ");
INSERT INTO kbq_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Anage nehige'ne tare netremokea rukrahe hu'ne Sodomu kaziga vu'na'e. Nevakeno Abrahamu'a anante Ra Anumzamo'ene oti'ne. ");
INSERT INTO kbq_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hagi Abrahamu'a erava'o huno Ra Anumzamofona anage huno antahige'ne, Ana kumapima fatgo vahe'ene, hazenke vahe'ene mani'nazana ana maka zamahe fanane hugahano? ");
INSERT INTO kbq_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Hagi 50'a ana kumapima fatgo vahe'ma mani'nesazana, ana 50'a fatgo vahera zamahoke henka ana kumara zamahe fanane osugahano? ");
INSERT INTO kbq_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","E'i kagri kavu kvara omane'neankinka, havi vahe'ene fatgo vahe'enema zamahe fanane hananke'za havi vahe'ene, fatgo vahe'mo'zanena mago'zahu knazana e'origahaze. Mika mopafi vahe'mota mago'zanke hunka Kagra refko hunerantane. ");
INSERT INTO kbq_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Higeno Anumzamo'a amanage hu'ne, Nagra'ma kesugeno'ma 50'a fatgo vahe'ma Sodomu ran kumapima mani'nesazana, ana mika rankumara zamagriku hu'na zamahe fanane osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Anante Abrahamu'a mago'ane antahigeno, Nagra kugusopage hu'na tanefake vahe'mo'na Ra Anumzamokane naneke nehue. ");
INSERT INTO kbq_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Hagi 50'a fatgo vahe mani'nesafinti 5fu'a vahe'ma omanisnagenka, knare ama ana mika rankumara zamazeri havizana hugahampi? Higeno Ra Anumzamo'a ete ke nona'a amanage hu'ne, Kesugenoma 45'a fatgo vahe'ma mani'nesage'na Nagra zamazeri havizana osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Higeno Abrahamu'a mago'ene antahige'no, 40'a fatgo vahe mani'nesagenka knare zamahe fanane hugahano? Higeno Ra Anumzamo'a ete ke nona'a hunteno, Kesugeno 40'a fatgo vahe'ma mani'nesage'na, Nagra zamazeri havizana osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hagi Abrahamu'a mago'ane amanage hu'ne, Ra Anumzamoka mago'ane kea hugahuanki krimpa aheonanto, 30'a fatgo vahe mani'nesagenka knare zamazeri havizana hugahano? Higeno Ra Anumzamo'a ke nona'a amanage hu'ne, Kesugeno'ma 30'a fatgo vahe'ma mani'nesage'na, Nagra zamazeri havizana osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Higeno Abrahamu'a mago'ene hanave e'nerino Ra Anumzamofo antahige'ne, 20'a fatgo vahe'ma mani'nesagenka knare zamahe fanane hugahano? Higeno Ra Anumzamo'a kenona'a amanage hu'ne, Kesugenoma 20'a fatgo vahe'ma mani'nesage'na Nagra zamazeri havizana osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Higeno Abrahamu'a anage hu'ne, Ra Anumzamoka mago'ene kantahigegahuanki krimpa aheonanto, 10ni'a fatgo vahe'ma mani'nesagenka knare zamahe fanane hugahano? Higeno Ra Anumzamo'a ke nona'a amanage hu'ne, Kesanugenoma 10ni'a fatgo vahe'ma mani'nesage'na Nagra zamazeri havizana osugahue. ");
INSERT INTO kbq_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Hagi Anumzamo'ma Abrahamu'ene keaga huvagama nereno'a atreno vigeno, Abrahamu'a kuma'arega ete vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tare ankero tremoke kinagasegeke Sodomu kumate uhanati'na'e. Loti'a ana ra kumamofo kasante mani'nege'ne ome ke'na'e. Hanki Loti'a neznageno otino vuno zanagafi upari huno, arena ome nereno amanage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Muse huranantoanki ranimota'a eri'za vahetani'amo'na nompi marerita tanaga sese hi'o. Nagrane maseteta okina vugaha'e, huno hige'ne zanagra anage hu'na'e. A'o, megi'a kumapi masegahu'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hianagi Loti'a hankavetigene agrane vu'na'e. Vakeno noma'afi ra ne'za ome kre neznanteno zo'ore bretia mago'a kre znantegene ne'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hagi ne'zana nete'za omase mani'nageno, miko Sodomu kumate nehazavene ranra vahe'mo'zanena Loti nona eme regagi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ana hute'za Lotina ke'za atimi'za, Iga nantu vahe'ma zanavrenkama nonka'afima ante'nana vahera mani'na'e? Zanavre kamategeta znanteta masamaneno. ");
INSERT INTO kbq_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hazageno Loti'a atineramino amefiti kafana eri negino, ");
INSERT INTO kbq_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","anage hu'ne, Muse hurmantoanki nafuheta kefo avu'ava zana huoznantegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kama antahiho, mofani'amokea vene omase mofatre manina'anki, zanagri zanavre'na eme tami'nena tamavesinia zama hunaku'ma hanuta anara huznantegahaze. Hagi muse (plis) hurmantoanki nantu vahe'ma noni'afima emanina'ana zanagrira mago'zana huoznantegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Huno nehige'za zamagra anage hu'naze, Kagra manigano! Ru kazigati vahe'moka tagrikura nehananki, hago kagra refko hurante'za nehampi, kagrira kazeri havizantfa hugahune. Lotina atufe'za kafama'are eme rentrako hu'za kafana anafe hu'za ufre'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ana netremokea Lotina avazuhu nompinka nente'ne, kafana erigi'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Maka vene'nema no kasante'ma oti'naza vahe'mokizmia zanagra ositeti vuno rante vu'nea nagara zamavurga erisu hige'za impane eneri'za, kafanku hakre'za vu'za e'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Anama nehazage'ne ana netremokea amanage huke Lotina antahige'na'e, Ama kumapina vaheka'a mago'a mani'nazo? Ne'mofaka'ane, neganemone, ruga'a vaheka'ane zamavarenka amafintira ko viho. ");
INSERT INTO kbq_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ama kumara eri haviza hugahu'e. Zamagenkemo'a Ra Anumzamofonte marerigeno Ra Anumzamo'a ama rankumara omeri haviza hi'o huno hurantegeta e'no'e'. ");
INSERT INTO kbq_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Anagema hakeno'a mofa'amoke arave hugahaze hu'za huhampri znante'naza ne'trente Loti'a vuno amanage huno ome zanasami'ne, Anumzamo'a ama kumara ahe fanane huku nehianki otinketa ama kura atreta vamaneno, huno hige'ne, reravatga nehunka taginke nehane nehu'ne kiza re'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ko'atu afu'za rugeka nehigeno ankero netremokea amanage huke asami'na'e, Lotiga ame' hunka mofaka'ararene, negnarone zamavarenka vuo. Amafi vahe knaza mani'neta erizanku freta viho. ");
INSERT INTO kbq_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Hianagi Loti'a tare agesa nentahige'ne, ana netremokea Lotine, nenarone, mofa'ararene zamazante zamavazu huke, ana kumapinti vu'ne fegi'a ome zamatre'na'e. Anumzamo'a asuntaginte'negu huno Lotina anara hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Fegiama atiramitageno'a, mago ankeromo huno, Frisagi ko' atreta freho! Magore huta rukrahera huta onkeho, ama agupomofo tvaontera omanita agonarega mareriho. Anama osanuta tamagranena frigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Hianagi Loti'a amanage hu'ne, A'o! Ranimota'a keke huranantonki, anara osugahie! ");
INSERT INTO kbq_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hanki antahio, eri'za vahekamo'na nagu'nevazinka, nahoke nehenka navrenka eme natrane. Hianagi agonamo'a afete me'neankina ovu'nenugeno knazamo'a nazeri haviza hanige'na, ama ana vahe'ene frigahue. ");
INSERT INTO kbq_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hagi ko, antu onensa kumara tava'onte me'neanki, natrege'na ana osi kumapi fre'na umani'nena, ana knazana agatera'neno. ");
INSERT INTO kbq_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Higeno ankeromo'a huno, Knareki mago'ene nantahiganke'na keka'a antahigamuankina kema hana osi kumara eri havizana osugahuanki traginka ana kumapi vuo. ");
INSERT INTO kbq_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ame hunka mago'zama osunesure ana kumate vuo. Ana hu'negu ana osi kuma'mofo agi'a Zoari hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Hagi Loti'a Zoari kumate uhanatigeno zage hanatino rumasa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ana higeno Ra Anumzamo'a tevene, teve nerea salfa haverami monafinti herafitregeno ko'ma riaza huno Sodomu kumate'ene Gomora kumate erami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ana huno ana maka ranra kuma'ene, ranra kuma agu'afi mani'naza vahe'ene, hozane, trazane, mopafi nehagea maka'zana ahe fanane huvagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Hianagi Loti nenaro'a henka ne-eno rukrahe huno ana kumatega negegeno'a, avufgamo'a ruzahe higeno hagemo'ma hiaza huno krage feno anante oti'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahamu'a masereti ame nantera otino Ra Anumzanema oti'neno keaga hu'nere vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Vuno unemanino ke fenkamu teno Sodomu kuma'ene, Gomora kuma'enema me'nea agupofima keana mago'zana onke'neanki teve kunke ke'ne. Kumo'a tusiza huno marenerino vemagu vemagu nehuno refite vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anumzamo'a ana huno Loti'ma agupofima nemania kumatamima eri havizama nehuno'a, Abrahamu'enema huvempama hu'nea kegu agesa nentahino, Lotina avreno rurega ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Zoari kumapi mani'zanku Loti'a koro nehuno tare mofa'arare'ne hage'za agonarega havegampi umani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Umani'ne'za nuna'amo'a ngana'amofona amanage huno asami'ne, Nafati'amo'a ozafa re'ne. Amafi ve erita mofavre kasentesnu'a vahera omanitfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hagi antahio, tafati'amofona negi ti ami'manenkeno neteno negi nenena nagatimofo zamagi fanane hu'zankura anukita mase'neta, tafati'amofo mofavre kasentesanu'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Huno hige'ne ana kenage nafaznimofona hanave ti amikeno neteno, agesa ontahi negi neno mase'negene, nuna'amo'a anteno mase'ne. Anazama ha'ana neznafa'a antahino keno osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nuna'amo'a nefama anteno masegeno komatia nanterana, nagana'amofona amanage huno asami'ne, Hago nagra kenage nerafa'ene mase'noanki meni kenage anahu kna huta hanave ti ami'manenkeno neteno, ete negi nenena anukinka masetegeta, nagati'amofo zamagi fanane huzankura nafati'amofo mofavre tamu'ene huta kasenta'maneno, huno hige'ne, ");
INSERT INTO kbq_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ana hu'ne nafa'zanimofona waini ti amikeno neteno agesa ontahi negineno masenegeno nagana'amo anteno mase'ne. Anazama hiana neznafa'a antahino keno osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","E'ina nehuke, Loti mofa tremokea nafa'zanimofonteti zanamu'ene hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kota mofa'mo ne'mofavre kasenteteno, agi'a Moapu'e huno ante'ne, agra Moapu vahe'mokizmi nezmageho'e. ");
INSERT INTO kbq_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Hagi nagana'amo enena ana zanke huno ne' mofavre kasenteno, agi'a Ben-Ammi'e huno ante'ne. Ana mofavrefinti'ma fore hu'nea vahekura Amoni vahere hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu'a maka feno zama'a enerino kumara atreno, Negev kaziga vuno Gerar umani'ne. Ana kumara Kadesine, Surine amu'nompi me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hagi Abrahamu'a nenaro Serankura amanage huno zamasmine, Ama nensaro mani'ne. Higeno Gerari kumate kini ne' Abimeleki'ma ana nanekema nentahino'a, eri'za vahe'a huzmantege'za Serana ome avre'za eme ami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hianagi ana kenagera Anumzamo'a ava'nafi Abimelekina amanage huno eme asmi'ne, Antahio vereti a' avre'za eme kami'nazankinka frigahane. ");
INSERT INTO kbq_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Higeno Abimeleki'a Sera'enema omase'negu huno amanage hu'ne. Ra Anumzamoka mago ke'a omane'nesia vahera knare amane kuma'ane naga'anena zamahe fanane hugahano? ");
INSERT INTO kbq_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamu'a agra nasmino, ama ara nensaro'e nehigeno, Sera'a Abrahamunkura nagra nesarone huno hu'ne. E'ina hu'negu Serama avre'za eme nenamizage'na nagra nagu'areti'ene antahi antahini'areti'ene fatgo avu'ava hu'noe hu'na nagesa antahi'noe. ");
INSERT INTO kbq_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Higeno Anumzamo'a ava'nafina amanage huno Abimelekina asami'ne, Tamage hane, Nagra antahi'noe, kagra fatgo antahintahi antahinenka, anazana hu'nane. E'ina hu'nanke'na Nagra kase hugantogenka Serana avako osu'nane. E'igu kefozana osu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hianagi ama a'mofo neve'a kasnampa ne' mani'neanki, huntegeno neve hirega vino. Nevanigeno negeno kagrama fri'zankura nunamu huno kza hino. Hanki hunte'nankeno ovaniana, kagrane maka'a naga kanena frigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nanterame Abimeleki'a maka kva vahera ke hige'za eme atru hazageno, Anumzamo'ma ava'nafima asami'nea nanekea huama huno zamasmi'ne. Nezamasmige'za nentahi'za, tusi'za hu'za zamagogogu hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleki'a ke higeno Abrahamu'a egeno amanage huno antahige'ne. Kagra naza hurante'nane? Nagra kagrira mago'a kumira hugante'nogenka amanahu havizana kumani'ane vahe'nianena hurantano? Amanahu avu'avazama hanana, fatgo osu avu'ava hane. ");
INSERT INTO kbq_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nehuno Abimeleki'a amanage huno Abrahamuna asami'ne. Kagra nankna antahintahi hunka amanahu'zana hu'nane? ");
INSERT INTO kbq_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Higeno Abrahamu'a kenona amanage hu'ne, Na'ankure nagra amanage hu'na nagesa antahi'noe, ama kumapina Anumzamofonkura koro nosazanki'za, zamagra a'ni'areku hu'za nahe nefri'za a'nia erigahaze nehu'na anara hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hanki ami ara nenfa mofa nensaro mani'ne. Ana hu'neanagi nenrera mofa omani'negu huno a'ni'a mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Hanki Anumzamo'ma hunantege'na nenfa noma netre'na amanage hu'na Serana asami'noe, hakare'a kaziga vanu'ana so'e kavukva hunantenka nensaro'e hunka huo hu'na asami'noe. ");
INSERT INTO kbq_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Anante Abimeleki'a sipisipine, bulimakaone, kazokazo eri'za vahera vene a'ene Abrahamuna avrenemino, nenaro Seranena avreno eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki'a amanage hu'ne, Ko! Ama maka nagri mopa me'neanki, kavesinirera amne umanio. ");
INSERT INTO kbq_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nehuno Serana amanage huno asami'ne. Kagri'ma kagazema eri kami'nogu hu'na negasro Abrahamuna ama mizana 1tauseni'a silva zagoa mika negazage'na amue. E'ina nehanuge'za mika vahe'mo'za nege'za, nagrikura havi zana osu'ne hu'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Anage hutegeno Abrahamu'a Anumzamofontega nunamu higeno Anumzamo'a Abimelekine, nenarone, kazokzo eri'za mofanene, a'nenea zamazeri soe hige'za mofavre kasente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Na'ankure Abrahamu nenaro Seranteku huno Ra Anumzamo'a Abimeleki naga'mofo a'nea zamarimpa erigi'neane. ");
INSERT INTO kbq_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ra Anumzamo'ma huvempa kema ko'ma Serama hunte'nere, Serana eri knare hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sera'a amu'ene huno ne' mofavre kasente'ne. Abrahamu'a ozafa retegeno kasentegahane huno Anumzamo'ma asami'nea kna egeno kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahamu'a Sera'ma kasentea ne'mofavregura Aisaki'e huno agi'a ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Hanki Abrahamu'a nemofo Aisakina 8'a zagegna manitegeno, Anumzamo'ma asmi'nea kante anteno agoza anona taga hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu'a 100'a zagegafu mani'tegeno Sera'a mofavre Aisakina kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Hagi Sera'a amanage hu'ne, Anumzamo naza hige'na kizaneroe. Vahe'mo'za antahisu'za nagrane muse nehu'za kiza regahaze. ");
INSERT INTO kbq_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Anage huteno Sera'a amanage huno hu'ne, Iza Abrahamuna, Sera'a mofavre'a ante omigahie huno hugahie? Ana hu'neanagi menina agra ozafarefinka mofavre kase amue. ");
INSERT INTO kbq_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ana Mofavremo nena huno ami a'o nehigeno, Abrahamu'a ra ne'za kre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Mago zupa Sera'a keana Haga, Isipi a'mofo mofavre Abrahamunteti ante'nea ne'mo avaharo nehigeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sera'a amanage huno Abrahamuna asami'ne, Erizanti'a e'neria a'ene mofavre'anena zanahenatigeke vi'o, eri'za a'mofo mofavremo'a fenonka'a e'origahie. Hagi mofavre'nimo Aisaki erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Anage nehigeno nentahino, Abrahamu'a mofavre'agura tusi rimpagna hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Hianagi Anumzamo'a amanage huno asami'ne, Abrahamuga krimpa havizana osuo. Na'ankure mofavrene eri'za a' kagura kagesa ontahio, Sera'ma nanekema kasamiaza huo, Aisakimpinti kagehe'za fore hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Eri'za a'mofo mofavrefintira Nagra zamazeri hakare ha'nena, rankuma ante'za manigahaze. Na'ankure zamagra kagri kageheze. ");
INSERT INTO kbq_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Hanki Abrahamu'a nanterame otino bretine, zagagafa avufgare tro hu'naza tafempi tinafino Haga afunte nenteno, mofavre'a avrenemino hunte'ne. Hanki Haga'a atreno Berseba ka'ma kopi vuno umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hagi zagagafa avufgaretima tro'ma hu'naza tintafempi ti'mo'ma vagaregeno'a, mofavre'a osi zafamofo tonapi ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ana huteno kevema ahetregeno nevia avamente Haga'a umanineno amanage hu'ne, Negesugeno mofavreni'a fri zankura navresra hie, nehuno krafa huno zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Hianagi ne' mofavremofo zavike'a, Anumzamo'a antahi'ne, Anumzamofo ankeromo monafinti amanage hu'ne, Hagaga kagripina na'a hu'ne? Korera osuo, antuma mani'neno ne'mofavremo'ma zavima neteana Anumzamo'a antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Otinka vunka ne'mofavre azante ome azeri otinka avro, Nagra azeri ra hanugeno, tusi'a vahe fore huno rankuma antegahie. ");
INSERT INTO kbq_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Anage nehuno Anumzamo'a ana a'mofo avurga azeri hari higeno keana, mago tinkeri me'negeno keteno vuno zagagafa avufgareti tro'ma hu'naza tafempi tina afino ana mofavrea ome amigeno ne'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Hagi Anumzamo'a ana ne'mofavrene mani'negeno nena huno, ka'ma mopafina atima ahe'zantera harfa ne' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Agra ka'ma mopafi Parani mani'negeno, nerera'a Isipi mopareti a' ome avreno eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ana zupage Abimeleki'ene vugota sondia kva ne'a Fikoli'enena amanage hu'ne Abrahamuna asmi'na'e, Anumzamo'a kagrane mani'neno maka'zama hana zampina asomu hunegante. ");
INSERT INTO kbq_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hanki kagra tamage hunka Anumzamofo avufi huvempa hunka nasamio. Nagri'ene, mofavre'niane, nagehe'inena reravatga hunka havizana huoranto. Hagi amama emani'nana mopafima knare navu'nava hugante'noaza hunka nagrira knare kavukva hunanto. ");
INSERT INTO kbq_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Higeno Abrahamu'a huno, Nagra huvempa huanki'na kema hanaza hugantegahue. ");
INSERT INTO kbq_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Hagi mago zupa Abrahamu'a tinkeri'agu Abimelekina keaga hunte'ne. Na'ankure Abimeleki eri'za vahe'mo'za tinkeria hanare'nazagu anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki'a amanage hu'ne, Iza e'inahu'zana hu'nefi, kagra nasaminke'na ontahi'noe. Hanki meni ama nehankena nentahue. ");
INSERT INTO kbq_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrahamu'a mago'a bulimakaoramine, sipisipiraminena refko huno Abimelekina eme nemino, anante raru hu'ne tragote'ne manisa'a nanekea huvempa (covenant) hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu'a sipisipi kevu'afintira 7ni'a a' sipisipi anentatami avre arure ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ana higeno Abimeleki'a amanage huno Abrahamuna antahige'ne, Ami 7ni'a a' sipisipi anentatamina nankna kagukagesare avre rurera ante'nane? ");
INSERT INTO kbq_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahamu'a amanage hu'ne, Kagra ama 7ni'a a' sipisipi anentatamina nazampinti kamuana erigeno, ana zamo huama huranteno, ama tinkeria nagriku kafinte'ne hino. ");
INSERT INTO kbq_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","E'inage nehuno ana kumara Besebe huno agi'a ante'ne, na'ankure anante tarega'moke huvempa kea hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hanki zamagra huvempa hu'za Berseba hute'za, Abimeleki'ene sondia kva ne'a Fikoli'ene otine mopa zaniarega Filistia vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamu'a tamariski zafa Berseba negrino, anante manivava Ra Anumzamofo agi hanta vazi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahamu'a za'za kna Filistia vahe mopafina mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hagi mago'a kafua agateretegeno Anumzamo'a Abrahamuna reheno kenaku anage hu'ne, Abrahamuo higeno, ama mani'noe huno Abrahamu'a hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Anumzamo'a anage huno asami'ne, Magoke mofavre, kavesi kavesi hunentana mofavrea Aisakina avrenka Morea moparega vuo, Nagrama kaverisua agonare anantega agrira ome ahenka tevefi Kresramana vuo. ");
INSERT INTO kbq_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Higeno amenantera Abrahamu'a otino donki afura azeri retro nehuno, Kresramana vu tevea ape huno krevare'are enerino, tare eri'za vahe'ane mofavre'a Aisakine zamavareno, Anumzamo asmi'nea kotega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tare zagegna agateregeno, anante knarera Abrahamu'a nevuno kesga huno anama asmi'nea kokana ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Agra eri'za vahetrema'agura amanage hu'ne, Amare donki afura anteta mani'neke'na nagrane ne'ni'ane anturega vuta Anumzamofona mono ome hunteteta ete egahu'e. ");
INSERT INTO kbq_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamu'a Kresramana vu teve erino Aisaki kofinenteno, agra'a hugre tevene, kazine erige'ne vu'na'e. Zanagra kantega nevu'ne, ");
INSERT INTO kbq_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisaki'a anage huno nefana antahige'ne, Nenfao, higeno Abrahamu huno, voe, higeno, Hugre tevene, kre tevene eri'noe. Hagi inantegati Kresramana vu lama afura erigahu'e? Huno Aisaki'a antahige'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Higeno Abrahamu'a kenona huno, Anumzamo Kresramanavu lama afura tamigahie, huno higeke vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Anumzamo'ma asami'nea kaziga unehanati'ne, Abrahamu'a have erino ita tro huno teve hanavazine. Ana huteno nemofo, Aisakina agare azante nofi anakinteteno, ana ita agofetu azeri sga humasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahamu'a kazima'a erino Aisakina kazi refriku nehigeno, ");
INSERT INTO kbq_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","monafinkati Ra Anumzamofo ankeromo kezatino, Abrahamuo! Abrahamuo! Higeno Abrahamu'a huno, Ama mani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Higeno ankeromo'a huno, Mofavremofo avufgarera kazana onto, mago'zana huonto. Menima kagri'ma kagentoana Nagrite kamentinti nehunka, Anumzamofonku kore nehane. Na'ankure Nagri'ma nami'zantera magoke mofavreka'a aze'orinane. ");
INSERT INTO kbq_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Higeno Abrahamu'a kesga huno osi zafa titipafi ve rama afumo pazive'afi rusi hu'negeno ke'ne. Ana ve rama afu ome azerino mofavre'amofo nona'a aheno tevefi kre fananehu ofa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrahamu'a ana agonagura Ra Anumzamo tamigahie huno agi'a ante'ne. Hankino eno menima mani'nona knafinena, Ra Anumzamofo agonare tamigahie hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ra Anumzamofo ankeromo monafinkati Abrahamunku mago'ene kezatino, ");
INSERT INTO kbq_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Anage hu'ne, Nagrani'a Ra Anumzamo'na hankavenentake ke nehue, na'ankure ke'nia erizafa nehunka ne'mofavreka'a, magoke ne'mofavrea azeorinane. ");
INSERT INTO kbq_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Nagra asomu huneganta'nena kagri kagehe'impintira fore huhakare hu'za monafinka hanafi ene hagerinkenafi kasepankna nehanage'za, ha' vahe'zmi ranra kumara eri nafa'a hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Na'ankure kagri kagehe'impinti mika kokankoka vahe'mo'za asomura erigahaze. Na'ankure nagri ke'mofo avaririnanku anara hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Anage hutegeno, Abrahamu'ene Aisakikea eri'za ne'trentega ake'za, maka'mo'za kuma zamirega Berseba vu'naze. Abrahamu'a anante Berseba rama'a kna mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hagi mago'a kna evutege'za, Abrahamuna eme asamiza, Negafu Nahori nenaro Milka'a mago'a ne'mofavre'zaga kasezmante'ne hu'za eme asami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana mofavremokizmi zamagi'a, Uzi'a pusa nere, Buzi'a agri negna'e, magora Kemuelikino Aramu nefa'e. ");
INSERT INTO kbq_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Hagi mago'a mofavre nagara Keseti'e, Hazori'e Pildasi'e, Judlafi'e, Betueli'e. ");
INSERT INTO kbq_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hagi Betueli'a Rebeka nefa'e. Milka'a, Nahorintetira 8'a ne'mofavre zaga zamante'ne. Nahori'a Abrahamuna nefu'e. ");
INSERT INTO kbq_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hanki Nahorina mago kazokzo eri'za a'mofo agi'a Reumakino, Nahorintetira Teba anteno, Gahamu anteno, Tahasi anteno, Makakizmi zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera'a 127ni'a zagegafu maniteno, ");
INSERT INTO kbq_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kiriat-arba kumate fri'ne. Menina ana kumara Kenani mopafi me'neankino, Hebronie hu'za nehaze. Hanki Abrahamu'a tusi'za huno Serankura asunku nehuno zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sera fri kerfare'ma Abrahamu'a mani'nereti netreno otino Hiti mofavre'zaga amanage huno ome zamantahige'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Tamagra antahi'naze, nagra mopa agafa nera omani'noanki, amne tamagri mopafi emani'noe. Hagi a'nimo'a fri'nege'na mopa miza hu'na anampi ome asenteku tamantahinegoe. ");
INSERT INTO kbq_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hige'za Hiti mofavre naga'moza amanage hu'za Abrahamuna asami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Kama antahio ra ne'moka, kagra ra kva ne' tagranena mani'nane. Knare'ma huno kavesinia matipi asenteku'ma hananketa, amne kamigahune. Hagi aza'o ana matimofo nafa'a mani'nenimo'a i'o osugahie. Amne kamina ana matimatipina ome asentegahane. ");
INSERT INTO kbq_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abrahamu'a Hiti mofavre'mokizmi zamufi otino, Maka vahe zamufi kepri huno anage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Hanki antahiho! A' ka'ama asentesane hanuta, nagri nagi erita vuta Zohari nemofo, Efroni'ene ome keaga hiho. ");
INSERT INTO kbq_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ome antahigenkeno Makpela mopa naminke'na, ana mopa agentega havegampi Serana ome asentaneno. Ana mopamo'a nagri'za segahie. Hanki hu izoma hanige'na hakaremota tamufi ana mopa mizahu fatgo hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hankino Efroni'a ana Hiti mofavre'mokizmi amunompi mani'ne. Efroni'a Hiti ne'kino rankuma'mofo kafante emani'naza vahe'mokizmi zamagesafi, ke nona'a huno Abrahamuna asami'ne, ");
INSERT INTO kbq_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Efroni'a amanage hu'ne, ra ne'moka kama antahio, havegana miza osegahane. E'i ana mopane haveganena maka'a naga'nimokizmi zamufi huvempa hu'na meni ana mopa kamigahue. Kamisnugenka anampi fri kerfa'a ome asente'gahane. ");
INSERT INTO kbq_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Anage higeno Abrahamu'a antahima ami'za kazigati maka vahe zamufi kepri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Abrahamu'a ana vahe zamufi amanage huno Efronina asami'ne. Efroniga muse (plis) hugantoanki kama antahio, nagra menina ana mopa miza hugahue. Hanki zagoma kamisnuana, erige'na ana mopafi a'nimofo fri kerfa ome asenta'neno. ");
INSERT INTO kbq_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroni'a ana naneke nentahino, amanage huno Abrahamuna kenona'a asami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Kama antahio, ra vahe'moka, ama mopamofo mizama'a 400'a silva me'neanagi amu'nonti'afina osi'zane. Amne fri kerfa'a ome asentegahane. ");
INSERT INTO kbq_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","E'inage nehigeno Abrahamu'a mago rimpa nehuno, mago'a zago'a refko huno Efroni eme ami'ne. Efroni'a agra'a kehia avamente 400 ti'a silva zago hakare vahe zamufi eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Efroni mopa Makpela Mamre kazigama avugosama hunte'nea mopa erigeno, ana mopafima me'nea havegane, zafane, mopane, hakarezanena ami vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hanki hakare'zana Abrahamu'ma eri nafa'a hanigu Hiti ne'mofavre naga'mo'za ran kuma'mofo kahante ke refko nehaza vahe'zmufi ami vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E'ina huteno Abrahamu'a Serana Makpela havegampi, Mamre kaziga avugosa hunte'nea havegampi ome asente'ne. Ana kuma agi'a Hebron hu'za nehaza kumakino, Kenani mopafi me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mopane, havegane anampima me'nea zanena, Abrahamu naga'ma asezmante mope hu'za Hiti mofavre naga'mo'za ami vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahamuna tusiza huno hakare'a zama'afina Ra Anumzamo'a asomu hunentegeno manino vuno ozafare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Korapa eri'za ne'a, maka'a fenonte'ene nonte kegava kri'nea ne'ku, Abrahamu'a amanage huno asami'ne, Muse (plis) hugantoanki kazana namo'mofo fenka antenenka, ");
INSERT INTO kbq_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","monane mopanema tro'ma hu'nea Anumzante kagra huvempa hunantenka, Kenani mopafintira ara ne'nimofona avre omigahue hunka huo. ");
INSERT INTO kbq_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hagi vunka mopa agafa'niare vahe'niafinti a' uvrenka Aisakina eme amio. ");
INSERT INTO kbq_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Higeno eri'za ne'amo'a Abrahamuna asamino, Hagi ana a'mo'ma navaririno'ma ama mopare omena, ete negamofona avre'na mopakare ome atregahufi? ");
INSERT INTO kbq_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Higeno Abrahamu'a eri'za ne'a asamino, I'o hue! Ne'nimofona avrenka ovutfa hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hagi monafinkati Ra Anumzamo'ma nenfa vahepinti'ene fore hu'noa mopareti'ma nagima huteno, navareno eme nante'nea Anumzamo'a amanage huno huvempa huno nasmi'ne, ama mopa nagakamofo zamigahue huno hu'neankino, Anumzamo'a mago ankero vahera huntenkeno kagota huno vanigenka, Aisaki nenarona anantegati uvarenka egahane. ");
INSERT INTO kbq_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Hagi ana a'mo'ma ovugahuema hinkenka huvempama hu'nana kegura korora osunka atrenka eno. Hagi ne'nimofona ana moparera avrenka ovugahane. ");
INSERT INTO kbq_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Anage higeno, eri'za ne'amo'a azana Abrahamu amo'mofo fenka anteno, anankerera huvempa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Eri'za ne'amo'a ozafa'amofo kemoriramimpintira 10ni'a kemori afu nezmavreno, mago'a knare'nare zana e'nerino, otino Nahori rankumate Mesopotamia vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Eri'za ne'mo'ma anantegama vuteno'a, kemori afu'tmina zamazeri zamarena rezmantege'za, kinaga a'nemo'za ti nefiza knare rankuma'mofo fegi'a tinkerire mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Eri'za ne'mo'a amanage huno nunamu hu'ne, Ra Anumzane, kvanimofo Abrahamu Anumzamoka muse (plis) hugantoanki, menina antahinaminka, ozafani'a Abrahamuna avesintenka azeri so'e hanane! ");
INSERT INTO kbq_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ko, ama tinkerire nagra otina mani'noankino, rankumate vahe'mokizmi mofanemo'za ti afinakura egahaze. ");
INSERT INTO kbq_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mago mofaku'ma hu'na, muse (plis) hugantoanki, ti afi kavoka'a ante mopafitege'na tina afi'na na'neno nehanugeno, tina nenege'na kemorika'a tina afi zami'neno huno hanimo, eri'za neka'a Aisaki nenaro'za hugahie. Anama hinke'na ozafani'a Abrahamuna avesintenka azeri so'e hane hu'na hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ana eri'za ne'mo'a nunamuna huvaga ore'negeno, mago mofara Rebekakino agra ti afi kavo afunte kofi'neno rankumapintira atirmino e'ne. Rebeka'a Betueli mofa mani'neankino Milka kasente'ne. (Milka'a Abrahamu negna Nahori nenaro'e). ");
INSERT INTO kbq_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ana mofara vemo ke asane hu'are, vene'nene omase'nea mofamo, tinkerirega uramino kavo'afi ti omefirino marerino e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abrahamu eri'za ne'mo'a, ana mofa'mo'ma ti afirino marenerigeno agia reno vuno anage huno ome antahigene, Muse hugantoanki kavoka'afinti osi'a tina namisnanke'na nesanue. ");
INSERT INTO kbq_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Higeno ana mofa'mo'a anage hu'ne. Ranimoka amne negahane, nehuno ana kavo'a anteramino azeri sga huntegeno ne'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Amigeno netegeno, ana mofa'mo'a anage hu'ne, Kemorika'a ana zanke hu'na tina afi zami'nena nezmu hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Huteno ame huno Rebeka'a tina kavo'afinti afu'moza ti nenaza zompafi taginte zamantege'za nenageno, ufino ete ete huno neragige'za ana maka kemorimo'za nezamu hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ana nehigeno Abrahanu eriza ne'mo ke osuno ana mofa'mofo avufi negeno, kama e'noa zamofona, Anumzamo'a ama naza hu'za nehifi huno agesa antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kemorimo'za tina nehana hutageno, ana eri'za ne'mo'a golire tro hu'naza rini kna'amo'a 5fu'a gremi hu'neane, manogosane, golire tro hu'nea tare asana tarega azampi antaninte'neankino golimofo kna'amo'a 100'a grem hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nehuno ana mofaku huno, Muse (plis) hugantoanki iza mofa kagra mani'nampi nasamio? Knare negafa nompina kankamuna me'nesigu ama nagranema enaza vahe'enena umasegahuno? ");
INSERT INTO kbq_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Higeno ana mofa'mo'a anage huno asami'ne, Nagra Betuel mofa mani'noe. Milkane, Nahorigizni mofavremo kasenante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ana mofa'mo'a mago'ane eri'za nera asmino, kemorimo'ma nesia ne'zane trazanena hakare'a megeno, mase kankamunena me'neankinka meni kenagera masegahane. ");
INSERT INTO kbq_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Higeno ana ne'mo'a kepri huno, Ra Anumza'mofona mono hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ana huteno ana eri'za ne'mo'a anage hu'ne, Kvani'a Abrahamu Ra Anumzamofona ra agi amue. Ozafa'nimofona agekani onteno soe'za hunenteno aza nehie. Hanki nagrira Ra Anumzamo naza nehuno kana naverige'na, ozafanimofo afu'agna nompi efatgo hue. ");
INSERT INTO kbq_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Anage higeno ana mofa'mo'a agia reno nerera nompi mani'namokizmi ana naneke ome zamasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Hagi Rebeka nempu'amofo agi'a Lebani'e. Lebani'a agia reno rankumamofo fegi'a tifi kerire'ma mani'nea nete vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Hagi nesaro Rebekama agonafima manogosane, azampima asama antani'neno ana eri'za ne'mo'ma asami'nea kema ome asamigeno nentahino'a, Lebani'a vuno ome keana tinkerire ana ne'mo'a kemori afu'zagane oti'negeno ome ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lebani'a ana nera asamino, Ra Anumzamo'a asomu hugantene'moka no agu'afi emarerio. Nahigenka fegira mani'nane, noma masesana zane kamorimokizmi kuma'enena nagra ko erise hunte'noe. ");
INSERT INTO kbq_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hagi ana ne'mo'ma nompima marerigeno'a, anante Lebani'a kemori agumpinti fenoma'a erinenteno, osapa trazane ne'zane kemorimofona nezmino, agia sesehu ti tagi zamige'za agrane e'naza vahe'ene zamaga sese hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ne'za kre'za avuga eme antenentageno ana eri'za ne'mo'a amanage hu'ne, Kavera one'nena amafima e'noa zamofo agafa'a tamasamite'na ne'zana negahue. Higeno Lebani'a anage hu'ne, Knareki tasamisanketa antahisune. ");
INSERT INTO kbq_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Higeno ana eri'za ne'mo'a anage hu'ne, Nagra Abrahamu eri'za ne' e'noe. ");
INSERT INTO kbq_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ra Anumzamo'a tusiza huno ozafa'nimofona asomu hunentegeno afufeno ne' mani'ne. Ra Anumzamo'a sipisipima, bulimakaoma, silvama, golima, eri'za vene'nema, eri'za a'nema, kemorima, donkima huno ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Hanki kva'nimofo nenaro Sera'a tavavateteno ne'mofavre kase amigeno, kvanimo'a mika zama'a ana mofavremofo ami vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kva'nimo'a huvempa hunanteno, amama emani'noa Kenani vahe'mokizmi mopafintira ne' mofavreni'arera ara avre omigahane huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Hianagi vunka nenfa mopa agafareti, vahe'niafinti ara ome avrenka ne' mofavreni'a eme amio. ");
INSERT INTO kbq_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Hige'na nagra kva'nimofonkura anage hu'noe. Ana a'mo'ma navaririno omenke'na na'a hugahue? ");
INSERT INTO kbq_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Hugeno agra huno, nagrama amage'ma nentoa Ra Anumzamo'a, Agra ankero vahe'a huntenkeno kagrane nevina, kama vanana kamo'a knare hanigenka, vahe'ni'afinti nenfa nagapinti ne'nimofo ara uvregahane hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Hagi kagrama nagri vahepima vananke'za, ana a'ma onkamisnageno'a, nagrama huvempa hu'noa kemo'a kaze'origahie. ");
INSERT INTO kbq_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Hige'na nagra tinkerire enehanati'na amanage hu'na nunamuna hu'noe, Ra Anumzamoka kvanimofo Abrahamu Anumzamoka naza nehanankeno kama e'noa kamo'a knare hugahianki, ");
INSERT INTO kbq_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","amare nagra oti'na tinkerire mani'nesnugeno, ina mofamo'o ti afiku'ma esanige'na ana mofaku hu'na, muse (plis) hugantoanki tina kavoka'afintira osi'a namige'na na'neno hanugeno, ");
INSERT INTO kbq_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ana mofamo'ma nasmino, tina nenege'na kemorikamokizmi tina afi'na eme zami'neno huno hanimo, kvanimofo ne'mofo ara Kagra hampri nentane hu'na antahigahue. ");
INSERT INTO kbq_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Anage hu'na nagu'afinka nunamuna nehugeno, Rebeka'a kavo afunte kofino tinkerireti ti afinaku uramigena kete'na, muse (plis) hugantoanki ti afi namige'na na'neno. ");
INSERT INTO kbq_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hugeno kavo'a afuntetira ame huno anteme neramino amanage hu'ne, Tina nenege'na, kemorika'aramina tina afi zamineno huno hige'na, nenogeno kemori nagara ti afizamige'za ne'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ana higena nagra anage hu'na antahige'noe, kagra iza mofa mani'nane? Hugeno Nahori nenaro Milka'ma kasentenea mofavre Betueli mofa mani'noe huno higena, agonafi rinia renente'na, asana azantrempi antaninte'noe. ");
INSERT INTO kbq_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ana hute'na kepri hu'na Ra Anumzamofona mono hunte'noe. Ra Anumzamofo agi ahesga hu'na, kvanimofo Abrahamu Anumzamo'a kva hunantege'na kvani'mofo afu'aganampinti ne'amofo ara kena erifore hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Hagi menima kva'nimofoma antahimisuta, na'ane huna ome asamigahufi nasami fatgo hiho. Hagi anama osanuta nasaminke'na, nagra nentahi'na, nazano hunaku'ma hanua zana ha'neno. ");
INSERT INTO kbq_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Anage hige'ne Lebanike, Betuelikea ana kemofo nona'a anage huke asami'na'e, Ra Anumzamo amanahu'zana higu, tagra mago kea osugahu'e. ");
INSERT INTO kbq_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka'a ama kavuga mani'neanki, Ra Anumzamo'ma kema hiaza hunka avrenka vugeno, kva kamofo ne'mofo nenaro'za ome hino. ");
INSERT INTO kbq_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Hagi Abrahamu eri'za ne'mo'ma ana kema nentahino'a, kepri huno mopafi rena reno Ra Anumzamofona muse hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Abrahamu eri'za ne'mo'a avasese hu'zana silvare'ene, golire tro hu'naza zane, kukenane Rebekana nemino, ana zanke huno mago'a knare'nare zantamina zago'amo mareri'nea zana nesarone, nererane zanami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ana hutege'za ana eri'za ne'ene agrane e'naza naga'mo'zanena kave'ene tinena nete'za mase'naze. Ko'atige'za o'neti'za nanterampi Abrahamu eri'za ne'mo'a amanage huno zamasmi'ne, Nazeorita natrenke'na ete kvanimo'ma maninerega va'neno. ");
INSERT INTO kbq_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hianagi nempu'amo'ene nererakea anage hu'na'e, A'o, atrenkeno mago'agna maniteno, 10ni'agna nazana agaterete'na avreta vugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Hianagi eri'za ne'mo'a huno, Ra Anumzamo naza higeno eri'zanimo'a knare hianki, nazeri onteta natrenke'na ete kvanima mani'nerega va'neno. ");
INSERT INTO kbq_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Higene, ana mofa'mofo avesi antahigeta kesune, ");
INSERT INTO kbq_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","nehu'za Rebekana ke hakeno ege'ne antahige'na'e, Kagra ama ne'enena vugahano? Hazageno ana mofamo'a huno, ozo vugahue. ");
INSERT INTO kbq_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Anagema hige'za zamagra nezmasaro Rebekama, kegavama hunentea a'ene, Abrahamu eri'za ne'ene, agranema e'naza naga'ene ana makamokizmia huzmante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebekana asomu ke hunente'za amanage hu'naze, Tagri nersaroga, kagripintira tusi'a vahe krerfa fore hugahaze. Hagi kagri kagehe'za zamesi ozmantesaza vahe'mokizmi rankumazmi zamahe'za hanaregahaze. ");
INSERT INTO kbq_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hagi Rebeka'ene mago'a agri eri'za a'nene kemori agumpi mareri'za, ana ne'mofo amage vu'naze. Higeno Abrahamu eri'za ne'mo'a Rebekana avreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hagi ana knafina Aisaki'a Ber-lahai-roiti eno, Negev emani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Aisaki'a mago kinaga vuno hofage kopi umani'neno agesa antahi antahi nehuno kesga huno keana, kemori'zaga neageno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka'a kesga huno Aisakina negeno, kemori agumpinti eramino, ");
INSERT INTO kbq_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","eri'za nekura amanage hu'ne, Aza amanu nera tavrenakura ne-e? Higeno eri'za ne'mo'a huno, E'i nagri kvani'e, higeno Rebeka'a tavrave erino avugosa refite'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hagi eri'za ne'mo'a hakare zama hu'nea zana Aisakina asami vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ana hutegeno Aisaki'a Rebekana avreno nerera Sera seli nompi ome antegeno nenaro'za higeno, avesintene. Aisakina nerera'a fri'nere amena eme arentinti hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu'a aru a' eri'neankino, agi'a Ketura'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ana a'mo kase zamante'nea naga'mokizmi zamagi'a Zimranima, Joksanima, Medanima, Midianima, Ispakima, Suama huno zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksani'a, Sebane, Dedanikizni neznafaza hu'ne. Hanki, Dedani mofavre nagara Asurimi'e, Letusimi'e, Leumimi'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Hanki, Midiani mofavre zamagi'a Efa'ma, Eferi'ma, Hanoki'ma, Abita'ma, Elda'ma, Ana maka'mo'za Ketura agehe'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Menina Abrahamu'a maka zama'a Aisaki ami'ne, ");
INSERT INTO kbq_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ana hu'neanagi henka eri'nea a'nemokizmi mofavre nagara, Abrahamu'a kasefa'ma mani'neno muse'za nezmino huzmantege'za, Aisakina atre'za afete'are zage hanati kaziga umani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ama'i Abrahamu'ma mika zagegafu mani'neana, 175'a zagegafu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahamu'a ozafarfa reteno hakare'a zagegafu hu'nea zanku muse nehuno, vagare asimu anteteno frino naga'ane umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Hanki Hiti mopa Zohari nemofo Efroni ami'nea mopa Mamre kaziga avugosa hunte'nefi agri mofavre Aisaki'ene, Ismaelikea Abrahamu fri kerfa eri'ne Makapela havegampi ome asente'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrahamu'a Hiti mofavremofo mopa miza hu'nea mopafi nenaro Serama asente'nefi Abrahamuna ome asente'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Hanki Abrahamu'ma fritegeno'a Anumzamo'a agri ne'mofavre Aisakina asomu huntegeno, Aisaki'a Ber-hai-roi mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hagi Haga'a Isipi a'mo Sera eri'za e'nerino Abrahamunteti Ismaelina kasente'nea mofavremofo naga'mokizmi naneke. ");
INSERT INTO kbq_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismaeli mofavre naga'mozama ese'ma fore'ma hu'nazareti'ma vuno henkamofonte'ma vu'nea nagamofo zamagi'a ama'ne, Ismaeli agonesa mofavrea Nebaioti'e, Kedariki, Adbiliki, Mibsami'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma'ma, Duma'ma, Masa'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadiki, Temaki, Jetuki, Nafisi'ma, Kedema'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ama'i Ismaeli ne'mofavre nagamofo zamagigiza, 12fu'a kva vahe'mo'za kva huzamantazage'za mago'mago kuma'zmire'ene, nagate nofitera hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hagi ama maka Ismaeli'ma mani'nea zagegafu'a 137ni'a zagegafu huteno, vagare asimu anteno frino, fri'naza naga'ane umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hanki Ismaeli agehe'za Havilati mani'za Suri uhanati'naze, zage hanati'tega Isipi tvaonte, Asiri'a kaziga vu kamofo, zamagonaru'za zamagraku arure umani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hagi Abrahamu'a Aisaki nefa'e. Aisaki'pinti fore hu'naza naga'mokizmi naneke. ");
INSERT INTO kbq_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisaki'a 40'a zagegafu huteno Rebekana Betueli mofa eri'ne, Lebani'a Aramea nekino, Mesopotamia mopareti ne'mofo nesaro erigeno, nenaro'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka'a mofavre ontegeno, Aisaki'a Ra Anumzamofontega nenaro agi erino nunamu higeno, Ra Anumzamo'a nunamuma'a antahi'migeno, Rebeka'a amu'ene hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hianagi tare mofavreraremoke arimpafintira kanive nerakeno anage hu'ne, amazana na'a nehie, nehuno Anumzamofona antahige'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ra Anumzamo'a amanage huno asami'ne, Tare kumamoke krimpafina mani'na'e, hiankino tare'mokea arure arure kavufgafinti vu'ne e'ne hugaha'e. Mago'mo'a hanavetina, mago'mo'a hanave otigahie. Ese'ma fore'ma hanimo'a, henkama fore hanimofo eri'za vahe manigahie. ");
INSERT INTO kbq_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Hagi mofavrema kasente knama egeno'a, tare kugaveza mofavre arimpafi mani'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kota mofavrema kasenteana, koranke avufgane antegeno hakare avufgamo'a azokake hu'nege'za, agi'a Iso'e hu'za ante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hanki amefiga'a negna kasentegeno, Iso agiare azerino atiramigeno, agi'a Jekopu'e hu'za antemi'naze. Ana knarera Aisaki'a 60'a zagegafu hutegeno, nenaro'a mofavrea kase zanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Hagi ana mofavre'mokea nena hute'ne, Iso'a zagagafa hofa trampinti ahe ne' mani'negeno, Jekopu'a rimpa frune kazone ne' seli nompi mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisaki'a Isona avesinte'ne, na'ankure agrama zagagafa aheno eme amigeno nenea zankure. Hagi Rebeka'a Jekopu avesinte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Hagi mago zupa Jekopu'a ne'zana negregeno, Iso'a trampinti agaku nehuno e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iso'a amanage huno Jekopuna asmi'ne, Ame'ama hunka antu koranke migri (sup) ne'zana eri namige'na na'neno, na'ankure naganetege'na nehue. E'inama hu'nea agafare mago agi'a Idomu'e hu'za ante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Hagi Jekopu'a amanage hu'ne, Zage mofavremo eri asomura kota'zana nagri namitege'no. ");
INSERT INTO kbq_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Higeno Iso'a amanage hu'ne, Negano nagra fri'za nehuanki, zage mofavremo eri asomumo'a na'a hunantegahie? ");
INSERT INTO kbq_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Higeno Jekopu'a amanage huno asmine, Kotazana huvempa hutegeno, higeno agra huvempa hunteno zage mofavremo eriga asomura Jekopu ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jekopu'a bretine, lentol koheki huno amigeno neteno atreno vu'ne. Iso'a ese mofavremo'ma eriga asomu'agura antahi amneza se'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Agatekna ko'ma Abrahamu knafi fore hu'neankna huno ana mopafina fore higeno, Aisaki'a Gerari kumate Filistia kini ne' Abimelekintega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ra Anumzamo'a agrite efore huno amanage huno asmi'ne. Nagrama kasmisua mopare manigahananki, Isipia ovuo. ");
INSERT INTO kbq_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ama mopafi mani'nege'na, Nagra asomu hunegantane'na kagri'ene kagehe'ine ama mopa mika nerami'na, Nagrama huvempa negafa Abrahamuma hunte'noa kea eri knare ha'neno. ");
INSERT INTO kbq_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nagra kagehe'ina zamazeri ra ha'nenke'za monafi hanafi kna hanage'na, Nagra ama mopa kagehe'i zamisugeno, kagehe'impinti miko kokankoka vahe'mo'za asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Na'ankure kema huankea Abrahamu'a amagenenteno Nagri kasegene tra ke'nianena avariri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ana higeno Aisaki'a Gerari mopare mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ana kumate vahe'mo'za Aisakina nenaronku antahi kageno agra a'nimo'e huno huzankura koro nehuno Nensaro'e hu'ne. Hagi agrama agesama antahiana Rebeka'a vahe'mofo anunu hu'are mani'negeno, ana kumate vahe'mo'za ahezanku anage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Za'za kna anampi umaniteno, Aisaki'a nenaro Rebeka agazafe'negeno, Abimeleki'a Filistia kini ne'mo nomofo zaho eri kampinti ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Anante Abimeleki'a, Aisakina ke higeno egeno, amanage huno asami'ne, Antahio, tamage huno ami kagri a' mani'ne! Nahigenka kagra nensaro'e hunka hu'nane? Higeno Aisaki'a amanage huno asmi'ne, Na'ankure agriteku hu'za vahe'mo'za nahe fri'zanku anagea hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Higeno Abimeleki'a amanage hu'ne, Amazana naza hunerantane? Mago vahe'mo'ma neganaro'ene maseresina, kagra mago knaza eri tamisine. ");
INSERT INTO kbq_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Anage huteno Abimeleki'a hakare vahe mago kasege antezmanteno amanage hu'ne, aza'o ama nero, nenarono avako'ma hanimofona ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Hagi Aisaki'a ana mopafina avimaza hozafima hankre'neana ana kafufina 100'a agatereno hamare'ne. Ana higeno Ra Anumzamo'a asomu hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ana higeno Aisaki'a feno ne' fore nehuno, mago'ene ra huno tusi'a feno anteno, mika feno ante agatere'nea ne' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aisaki'a sipisipi zagane, memeki zagane, Bulimakaone, eri'za vahe'ene, rama'a ante'nege'za, Filistia vahe'mo'za zamasigu hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ana hige'za mika tinkerima agri nefa Abrahamu eri'za vahe'mo'zama ko'ma kafimante'nazana, Filisti'a vahe'mo'za mopa kate'za refite'naze. ");
INSERT INTO kbq_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Hagi henka Abimeleki'a amanage huno Aisakina asmi'ne, Kagra tagrira tagaterenka hanave'nentake hananki, tagri'pintira atrenka vuo. ");
INSERT INTO kbq_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hazageno Aisaki'a atreno Gerari agupofi seli no omegino anantega mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Hagi Aisaki'a eteno korapa Abrahamu kafinte'nea tinkeriramina eri so'e hu'ne. Na'ankure nefa'ma fritege'za Filistia vahe'mo'za refite'naza tinkeri raminkino, kafiteno nefa'ma ami'nea agi'aramina erikasefa huno antetere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisaki eri'za vahe'mo'za ana agupofi tinkeri nesageno, anampinti ti hanatino mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Hianagi Gerari afu kva vahe'mo'za, Aisaki afu kva vahera frage huzmante'za amanage hu'naze. Ama tagri tine! Hazageno Aisaki'a agi'a Eseki'e huno ante'ne. Na'ankure zamagra frage hunante'nazagu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Aisaki eri'za vahe'mo'za mago'ane ru tinkeri nesageno, esaza hu'za Gerari vahe'mo'za fra vazizmente'naze. Fra vazizageno negeno, Aisaki'a ana tinkerimofona Sitne huno agia ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Aisaki'a ana tinkeria atreno ru tinkeri ome kafige'za, hafra huontageno, ana tinkerimofo agi'a Rehoboti'e huno nenteno anage hu'ne, na'ankure Ra Anumzamo'a tazahuno kankamuna retro hurante'neankita, ama ana mopare manineta, maka zampina knare hugahune. ");
INSERT INTO kbq_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hagi Aisaki'a ana kumara atreno marerino Berseba kumate uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ana'ma uhanatia kenegera Ra Anumzamo'a efore humino amanage huno asami'ne, Nagra Abrahamu nafaka'amofo Anumzane, e'igu korora osuo. Nagra kagrane mani'nena asomura hunegantena henka'a kagripinti kegehe'za fore hanamoki'zminena zamazeri hakare hugahue. Na'ankure Abrahamu'a Nagri eri'za vahe mani'negu anara hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hutegeno Aisaki'a ana kumatera Kresramana vu ita trohuno, Ra Anumzamofo agi hanta vazino ana kumateke seli no azeri onetige'za, Aisaki eri'za vahe'mo'za mago tinkeri kafi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hagi Abimeleki'a Aisaki ome kenaku Gerari nevuno, magora knare antahintahi nemia ne' agi'a Ahusati'e, hanki magora sondia vahe'amofo kva ne' Fikoligizni neznavreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisaki'a amanage huno zamantahige'ne, Ko'ma mopa tamifintira tamavesra hunanteta nahe nati'nazanki, tamagra na'anku nagritega neaze? ");
INSERT INTO kbq_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Higeno ana kemofo nona'a anage hu'naze, Ra Anumzamo'a kagrane mani'neno kaza nehigeta negeta, tagra anage nehune, Kagri ene tagri ene amu'notifina tamage hunka huvempa naneke hugeta kagrane, tagranena hagerfita mani'maneno. ");
INSERT INTO kbq_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kagra, tagrira tazeri havizana osugahane. Tagra kazeri havizana kagrira osuta, trimpa frune hugantonkenka e'nane. Menina Ra Anumzamo knare huneganteno asomura hunegante. ");
INSERT INTO kbq_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hazageno ana kezmia nentahino, Aisaki'a ra kave kre zamentege'za tine ana ne'zana ne'naze. ");
INSERT INTO kbq_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nanterame oti'za raruma hu'za manisaza huvempagea hute'za, anante Aisaki'a huno, Tamarimpa frune viho, huno huzmantege'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ana'ma huzamantege'za vaza zupa, Aisaki eri'za vahe'mo'za amanage hu'za eme asmi'naze. Hago mago tinkerima kafinompintira tina fore hie. ");
INSERT INTO kbq_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ana tinkerimofo agi'a Sibae huno ante'ne. Meninena ana kumamo'a rahige'za Berseba kumare hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso'a 40'a zagegafu maniteno, Hiti ne'mofo mofa' eri'ne, agi'a Juditi'e, nefa'a Beri'e. Hanki mago a'amofo agi'a Basematikino Hiti ne' Eloni mofare. ");
INSERT INTO kbq_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ana a'tremokizni mani'zamo Aisakine Rebekagiznia zanarimpa zanata zanami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Hagi Aisaki'a ozafarfa reno avua keso'e osuno zage mofavre'a Isonku amanage huno asami'ne, Mofavrenige, higeno ama mani'noanki nahie huno higeno, ");
INSERT INTO kbq_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisaki'a agra anage hu'ne, Menina antahio, nagra ozafare'na fri knania ontahi'noe. ");
INSERT INTO kbq_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hanki ati keveka'a erinka hofa trampinti vunka, zagagafa ome ahenka eme namio. ");
INSERT INTO kbq_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nagri'ma navenesia ne'za kre haga hunka eme namige'na nene'na, nagu'areti hu'na manu regantete'na, mani'ne'na henka'a frineno. ");
INSERT INTO kbq_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hianagi Aisaki'a nemofo Isoma asmia kea Rebeka'a agesa anteno antahiteno, Iso'ma trampinka zaga aheno eme krenteku nefreana, ");
INSERT INTO kbq_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka'a mofavre'a Jekopuna anage huno asami'ne, Antahio, negafa'a negfu Isonkura nentahugeno amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","zaga ome ahenka kre haga hunka eme namige'na nene'na Anumzamofo avure manuna regantete'na fri'neno, nehigena antahi'noe. ");
INSERT INTO kbq_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hanki mofavre'niga kasmisua kea antahinka kema kasami'nua zana ome huo. ");
INSERT INTO kbq_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Menina vunka afu kevufintira tare agaho mementre ome avrenka eme namigena, negafama avenesia ne'za kre haga hugami'nena, ");
INSERT INTO kbq_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","negafa'na erinka ome amisnankeno neteno, manu aregenteteno mani'neno frino. ");
INSERT INTO kbq_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Hianagi Jekopu'a kenona'a Rebekana hunteno, Antahio, nempunimo'a avufga azokake ne' manigeno, nagrira navufgarera nazokara ore'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Hagi nafanimo'ma navako'ma huno'ma kesige'na, agri avufina nagra havige revatga nehu'na, nagra navufare manuna e'origahuanki, kna eri kofigahue. ");
INSERT INTO kbq_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anage higeno nerera'a amanage huno asmi'ne, Kagri knazamo'a nagrite egahie. Mofavre'nimoka ke'nia erizafa hunka, vunka ome azerinka eme namio. ");
INSERT INTO kbq_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Higeno ke hiaza huno tare mementre ome avreno nererante egeno, nefama avenesia kavera kre haga huteno, ");
INSERT INTO kbq_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka'a zage mofavre'a Iso knare kukena nompima me'neana erino Jekopu hankrente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Rebeka'a meme akru'a taga huno, tarega azantrempi antenenteno, azoka onte avufgare anankempi antente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Rebeka'a kave'ma kre haga huntea ne'zane, bretima tro'ma hunteana nemofo Jekopu eri ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hagi Jekopu'a nafa'amofonte uhanitino amanage ome hu'ne, Nenfa'o, higeno nafa'amo amanage hu'ne, kama ama mani'noanki, Kagra izage, Ina mofavrenimoka nehane? ");
INSERT INTO kbq_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Higeno Jekopu'a amanage huno nefana asmi'ne, Nagra Iso'na zage mofavre kamo'na, ke hunantanaza hu'na ne'za krerigante'na neoe. Muse (plis) hugantoanki otinka mani'nenka erinka nezanka'a nenenka manurenanto. ");
INSERT INTO kbq_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hianagi Aisaki'a nemofonku amanage huno asami'ne, Mofavre nimoka mensi hugantogenka vu'nananki, inankna hunka ame' hunka neane? Higeno Jekopu'a huno, Ra Anumzana, kagri Anumzamo naza huno eri fore hunamige'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Higeno Aisaki'a amanage huno Jekopuna asami'ne, Muse hugantoanki tvaonte ege'na Isoga mani'nampi kavufgare kavako hu'na ka'neno. ");
INSERT INTO kbq_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Higeno Jekopu'a nefa tva'onte egeno avufgare azerino negeno anage hu'ne, Kagerumo'a Jekopu ageru kna nehie. Hianagi kazamo'a, Iso azankna nehie. ");
INSERT INTO kbq_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aisaki'a ke so'e Jekopuna osu'ne, na'ankure azamo'a azokake huno nefu Iso azankna hu'negeno, Aisaki'a Jekopuna manua rente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aisaki'a mago'ane amanage hu'ne, Tamage hunka kagra mofavreni'a Isoga mani'nano? higeno, Jekopu'a revatga huno, Izo nagra anane. ");
INSERT INTO kbq_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Hanki Aisaki'a anage hu'ne, Ana ne'za erinka eme namige'na nene'na manu reganta'neno, higeno ana ne'zane, waini tine erino eme amigeno ne'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Anante nefa Aisaki'a nemofonku anage hu'ne, Muse (plis) hugantoanki mofavre'nimoka nagrite enka eme nantako huo. ");
INSERT INTO kbq_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Higeno Jekopu'a eazamo eme antako nehigeno, kena'areti'ma mana nevigeno nentahino'a, anante manu renenteno amanage hu'ne, Ko, mofavreni'amofo mana. E'i ana mnamo'a Ra Anumzamo hozamofo asomu huntegeno, nevia kna mana nevie. ");
INSERT INTO kbq_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nagri'ma navesiana, menina Anumzamo'a monafinkati ata kora kamisigeno, mopa aru fru hanigeno, ne'zamo'a hakare nehuno, raga nerenkeno kasefa wainimo'enena hakare hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Veamo'za kagri eri'za e'nerisageno, maka moparegati vahe'mo'za kagri kagorga manigahaze. Kagra kafuhe'ina razimi manigahane. Negrera mofavre zagamo'za zamarena re'za kepri hugantesaze. Kagri'ma sifna hugantesamo'za zamagranena sifna erigahaze. Asomu ke hugante'samo'za, asomu erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisaki'a Jekopuna manu rente vagaregeno, Jekopu'a Aisakina anama atreno atirmino arugagino nevigeno, Iso'a zaga zantetira e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Agranena haga'ane ne'za tro huno nefante erino e'ne. Iso'a anage huno eme asmi'ne, Nafa'nimoka otinka negamofona zagagafa netenka, henka manuna renanto. ");
INSERT INTO kbq_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Hianagi Aisaki'a kenona hu'no, Kagra azage? Higeno agra amanage hu'ne, Nagra Iso'na zage mofavre kamo'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Higeno Aisakina tusi'a ahirahi neregeno amanage hu'ne, Iza zaga aheno kreno eme namige'na nete'na, asomura huntogeno vigenka, kagra henka neane? Ne'zama'a eri'na nete'na ko'ma manu rente'noa manuna anante megahie. ");
INSERT INTO kbq_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iso'a nefa'ma hianke nentahino tusiza huno rimpamo'a haviza nehigeno, tusiza huno zavira neteno nafa'amofona anage huno asmi'ne, nafa'nimoka! Nagri'enena ana zanke hunka manurenanto! ");
INSERT INTO kbq_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hianagi Aisaki'a huno, Naganakamo havige eme renavatga huno kagri'ma kamiku'ma hu'noa asomura ko emerino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Higeno Iso'a amanage hu'ne, Jekopu'e hunka agima ante'minanana tamage, tare zupa nagri ku'ma eri'ne? Kota mofavremo'na asomura agra eri'ne, menina ko, nagri asomura agrake e'nerie. Hagi menina mago'a asomura eri'nampi manua renanto. ");
INSERT INTO kbq_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Higeno Aisaki'a Iso ke'are nona huno, antahio, Hago kva vaheka'a azeri oti'noe. Hakare naga'a eri'za vahere hu'na huzmante'noe, ana nehu'na hozare kave'ene kasefa wainimo'ena agri azeri sga hugahie hu'na hunte'noe. Hanki mofavre'niga, nagra na'a hugantegahue? ");
INSERT INTO kbq_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso'a nefana anage huno antahigene, Nafanimoke, kagra magoke manuntfana eri'nano? Nagri'ene manurenantogu nehue, nafao huno nehuno Iso'a krafa huno tusi zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Anante nefa Aisaki'a kenona huno, Antahio, kagra msavema'a omanesia mopafi manigahane. Anagamu monafinkatira, ata'mo'a mopakafina eoramigahie. ");
INSERT INTO kbq_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ama mopare manisnanana ha' nehunka manigahane, ana nehunka naganakamofo katoza humigahane. Hinkenka mani rva osunka, agra kaomofo anankempi agare namare zafa anteno azeri kante nehiankna zafa knankempima ante'neana, kagra eri hantagi atregahane. ");
INSERT INTO kbq_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aisaki'ma Jekopuma manuma rente'nea zanku, Iso'a nagna'amofona antahi haviza hunteno asi vazinenteno amanage hu'ne, nafa'nimofonku'ma nasunku'ma hanua kna egofta hie. Hankina henka'a nagra naganani'a Jekopuna kegahue. ");
INSERT INTO kbq_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebekana zage mofavre'a Iso'ma hianke eme asmi'zageno, anante mofavre'a Jekopuna agi higeno egeno anage huno asmi'ne, kama antahio, negafu Iso'a rimpa ante fru huteno, kagrira kahe frinaku kea retro hie. ");
INSERT INTO kbq_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","E'ina higu menina mofavre'nimoka keni'a erizafa hunka, otinka frenka Harani nensaro Lebani'ma mani'nerega vuo! ");
INSERT INTO kbq_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mago'a gna agrane umani'negeno, negafuna rimpa ahezamo'a ravaheno. ");
INSERT INTO kbq_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kagri'ma arimpa ahegante'neama fru huno agekanina, anante ke ha'nenkenka egahane. Hagi nankna hu'na tarega'motna'a magoke'zupa frisnake'na nasunkura hugahue? ");
INSERT INTO kbq_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Anage nehuno Rebeka'a anage huno Aisakina asami'ne, Hiti vahe'mokizmi mofa'negura, nagrira navesra huno nagote nagesahie. Na'ankure Jekopu'ma Hiti vahe'mokizmi mofanefinti'ma a'ma erisiana, nankna huno knarera mani'zanimo'a hugahie? ");
INSERT INTO kbq_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hanki Aisaki'a ke higeno Jekopu'a egeno asomu ke hunenteno, hankavenentake ke asamino amanage hu'ne, Kagra mago Kenani vahe'mokizmi mofara ara e'origahane. ");
INSERT INTO kbq_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hanki otinka Padan-Aram moparega (Mesopotemia), Betuel nontega vuo. E'i negrerana nefa'e. Anantegati a'ka'a erisanana negrera nesaro Lebani mofanefinti mago mofa ara erio! ");
INSERT INTO kbq_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ana'ma hanankeno'a Hankavenentake Anumzamo'a asomu huneganteno, kazeri hakare hugante'na tusi'a vahe fore hunka manigahane. ");
INSERT INTO kbq_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nagri'ma navesiana Anumzamo Abrahamu hunte'neaza huno kagri'ene, mofavreka'ane asomu hugantesnie. Ama vanoma nehana mopa, Anumzamo'a Abrahamu ami'nea mopa eri nafa'a kagra hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisaki'a Jekopuna huntegeno Padan-Aram (Mesopotemia) Lebani nemofo Betueli Aramia ne'mofontega vu'ne. Rebeka'a Jekopune Isonena neznarera'e. ");
INSERT INTO kbq_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Hagi Aisaki'ma Jekopuma asomu hunenteno Padan-aramuti a' erinogu huntegeno nevigeno hankavenentake ke asmino, kagra Kenani vahe'mokizmi mofa'nefintira ara e'oriogahane hiankea Iso'a antahine. ");
INSERT INTO kbq_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Hagi Jekopu'ma nefane nerera kema erizafa huno Padan-Aram vu'nea zamofo kenena keno antahino hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iso'ma keana nefa Aisaki'a Kenani mofa'negura musena osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ana higeno Iso'a Ismaelintega vuno a'nema zamante'nefi mago'ene a' omeri'ne. Ismaeli mofa agi'a Mahalati'e, Ismaeli'a Abrahamu nemofo'e. Mahalati'a Nebaioti nenunkna'e. ");
INSERT INTO kbq_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Hagi Jekopu'a Berseba atreno Harani kaziga vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nevigeno kantega zage ufreno hani ome higeno, have fita erinteno mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Anante mase'neno ava'nama keana, mago latamo'a mopareti agafa huteno anagamu monafinka mareri'negeno, Anumzamofo ankeromo'za ana latarera mareri'za tami'za nehazageno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ana huno nezmagegeno Ra Anumzamo'a anante otino mani'neno anage huno asami'ne, Nagra negageho Abrahamune, negafa Aisakine Anumzane, Menima mase'nana mopa kagri'ene, kagehe'ine tamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kagripinti'ma fore'ma hanaza vahe'mo'za kasepankna hu'za fore huhakare hu'za manigahaze. Zage fre kazigane, zage hanati kazigane, ruga raga agentega vu'za e'za hu'za mani titipa hu'za manigahaze. Kagri'ene kagehe'impinti ama mopafi vahe'mo'za asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Hanki antahio, Nagra kagrane mani'nena inantego vanoma hananana kva hunegante'na, ete kavre'na ama ana mopare egahue. Ana nehu'na Nagra onkatre'na, huvempama hugante'noa kea eri knare huvagaregahue. ");
INSERT INTO kbq_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Higeno Jekopu'a avu'ma masenereti otino anage hu'ne, Tamage huno Ra Anumzamo'a amafi mani'negena nagra ontahi'noane. ");
INSERT INTO kbq_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Agra amanogu nehuno amanage hu'ne. Ama mopa ruzahu hu'nea mopare e'noe! Ra Anumzamo mani'nea nompi e'noankino, ama mona kafa me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jekopu'a nanterame otino, fita aruno mase'nea havea erisga huno retru renteteno, masve tagino agofetu frenteno eri ruotge hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Agra ana kumakura Beteli'e huno agia antemi'ne. Korapara ana kumamofo agi'a Lusie huno me'neane. ");
INSERT INTO kbq_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jekopu'a amanage huno huvempa hu'ne, Afete kama nevanugeno Anumzamo'ma nagrane nevuno nagu'vazino ne'za ni'ane kukena'ni'ane nazama nehanigeno, ");
INSERT INTO kbq_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","mago knazamo navate'ma omesanige'na, nafa'nimofo kumate ete rukrahe hu'na uhanatisu'na, Ra Anumzana nagri Anumzane hu'na hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ama havema eri retruroana, Anumzamofo no mesie. Mika'zama Anumzamo'ma namisifintira 10ni'ma hania kevua refko hu'na Anumzamofo amitere hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jekopu'a masetere hume vuno, zage hanati kaziga vahe'mofo mopafi uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Agra kesga huno trazampi keana, tinkerire tagufa afu kevu masenageno ke'ne, ana tikerireti sipisipiramina tina afi'za nezmize. Hanki ana tinkerimofo agitera ra have runkani rente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Anante mika sipisipi kva vahe'mo'za utru hute'za, kerimofo agiteti havea atufe ante'ne'za, tina afi'za sipisipi zamia zamite'za, ete ana havea atufe'za ana kerimofo avazare runkani rentetere nehazane. ");
INSERT INTO kbq_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Hagi Jekopu'a zamagrikura amanage hu'ne, Nafuheta tamagra igatire? Hige'za kenona hu'za, Tagra Haranitire. ");
INSERT INTO kbq_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Hazageno Agra amanage huno zamasmi'ne, Nahori negeho Lebanina ke'nazo? Hige'za zamagra kenona amanage hu'naze, Tagra agrira ke'none. ");
INSERT INTO kbq_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hazageno Jekopu'a zamagrira amanage huno zamasmi'ne, Lebani'a knare huno mani'nefi? Hige'za zamagra hu'za, Agra knare huno mani'ne. Hanki antu ko, agri'mofa Resoli'a sipisipi zaga'ane ne-e. ");
INSERT INTO kbq_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hazageno Jekopu'a anage huno zamasmine, Keho, zagea anamifi megeno afu'zagarami eritru hukna omane'neanki, sipisipi afuzaga tina nezmita zamavareta vinke'za trazana ome neho, huno nehige'za, ");
INSERT INTO kbq_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","zamagra amanage hu'naze, E'inahura osu'nenunkeno mika'a emetru hute'nageta, tinkeriretira have avaza'a eritreta tina afi zamisunke'za negahaze. ");
INSERT INTO kbq_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Hagi Jekopu'a nanekea zamagrane nehigeno, Resoli'a agra sipisipi kva nehia mofakino, nefa sipisipi zamavareno e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jekopu'a nenogo Lebani mofa Resoli'ma sipisipi'ane ne-egeno, negeno vuno tin keriretira havea ome rekrehe huno, nerera nesaro Lebani sipisipia ti afizmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Anante Jekopu'a Resolina antako hunenteno, ranke huno zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jekopu'a Resolina amanage huno asamine, Nafakamofo nesaro Rebeka mofavre mani'noe, higeno Resoli'a agareno vuno nefa ome asmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Hanki Lebani'a nesaro mofavre nenogo nenekema nentahino'a, ome ke'naku agareno vuno, ome anukino antako hunenteno avreno noma'afi e'ne. Ana higeno Jekopu'a hakare'a kea asami vaga'rene. ");
INSERT INTO kbq_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ana hutegeno Lebani'a amanage huno asami'ne, Kagra nagri kora mani'nane. Higeno Jekopu'a anante mago ika agrane mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hagi Lebani'a amanage huno Jekopuna asami'ne, Kagra nagri kora mani'nankure hunka amne eri'zana e'origahane. Nama'a kagrira miza hugantegahufi nasamio? ");
INSERT INTO kbq_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lebani'a tare mofatre zanante'ne, kotamofo agi'a Lia'e, osi'mofo agi'a Resoli'e. ");
INSERT INTO kbq_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lia avurgamo'a kazakiri'ne, hagi Resoli avurgamo'ene, avufgamo enena knarezantfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jekopu'a Resolina avesinenteno amanage hu'ne, Nagra 7ni'a kafufi mofaka'a Resolima a'ma erinte'nakura erizanka'a erigantegahue. ");
INSERT INTO kbq_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Higeno Lebani'a amanage hu'ne, Ru vahe ami'zankura kagri'ma kamisuana knare hu'neanki nagrane manio. ");
INSERT INTO kbq_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jekopu'a 7ni'a zagegfufi Resolima a'ma erikura eri'zana eri'neankino, ana knamo'a agritera osi knasente'ne. Na'ankure agrama Resolima avesinte'negu anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hagi henka ana knamo'a vagaregeno Jekopu'a amanage huno Lebanikura hu'ne, Knama nami'nana knamo'a hago vagareanki, a'ni'a namige'na ara eri'neno. ");
INSERT INTO kbq_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Higeno Lebani'a ana kumate vahera miko zamare tru huno, aravema hu ne'za kre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ana kenegera Lebani'a Lia avreno Jekopu ome amigeno anteno mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lebani'a eri'za erinentea a' Zilpa avreno mofa'a Lia katoza huminogu eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Hanki Jekopu'a maseno kotigeno nanterama keana Lia mani'negeno keteno, agra amanage Lebanikura hu'ne, Resolinte eri'zana eri kantenoanki, kagra na'a amazana hunantane? Nahigenka renavatga hane? ");
INSERT INTO kbq_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Anage hianagi Lebani'a ana kenona amanage hu'ne, Tagri kumapina nagna'amo nuna'amofo agatereno ve' eri'zana omane'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mago sonta manitegeta, tagra mago'mofona kamisnunkenka ara erigahananki, ete mago'ene 7ni'a zagegafu eri'zana eri nantegahane. ");
INSERT INTO kbq_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Higeno Jekopu'a mago sonta Lia'ene mani vagare'tegeno, Lebani'a mofa'a Resolina avreno Jekopuna amigeno nenaro'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lebani'a, katozama'a e'neri a' Bilhana avreno Resoli katoza eri aminogu ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hanki Jekopu'a Resolina anteno mase'ne, agra Liama avesi nenteama'a agatereno Resolina tusiza huno avesintene. Agra ana nehuno Lebanina erizana 7ni'a zagegafufi erinte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Hanki Ra Anumzamo'ma keana Jekopu'a Liana avesi ontegeno, Anumzamo'a rimpa eri vasne'ne, ana hianagi Resoli'a narvo a' mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia'a amu'ene huno ne' kasenteno agi'a Rubeni'e huno nenteno anage hu'ne, Na'ankure Ra Anumzamo natazani'a nazeri knare hiankino, nenave'a avesi nantegahie. ");
INSERT INTO kbq_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Anante Lia'a mago'ene amu'ene huno ne' kasenteno amanage hu'ne, nenave'a avesi onantegeno Ra Anumzamo antahi namino mago'ene ama mofavrea nenamie, nehuno Simioni'e huno agia antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Anante Lia'a amu'ene huno ne' kasenteno amanage hu'ne, Menina ama knarera, nenave'a tvaonire manigahie. Na'ankure nagra tagufa ne'mofavre kase amue. Ana hu'negu agi'a Levi'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Anante Lia'a mago'ene amu'ene huno, ne'mofavre kasenteno amanage hu'ne, Menina nagra Ra Anumzamofo agi'a erisga hue. Ana hu'negu agi'a Juda'e hu'ne. Ana huteno ana a'mo'a mago'ene mofavrea onte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Resoli'a mofavrea Jekopuna kase omino nuna'amofo kaniverenenteno, amanage huno Jekopuna asami'ne, Mofavre onte manine'na frisugi, Mofavre eri fore hunamio. ");
INSERT INTO kbq_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Higeno Jekopuna asi vazigeno Resolina rinkfa henenteno amanage hu'ne, Nagra Anumzana omani'noanki, aza karimpa erikigenka mofavrea kamu'enena hunka kasenontane. ");
INSERT INTO kbq_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Higeno Resoli'a amanage hu'ne, Kato mofani'a Bilha'a ama mani'neanki, antenka masegeno mofavre kase naminkeno, agripinti nagranena ana zanke hu'na mofavrea eri fore haneno. ");
INSERT INTO kbq_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Anage nehuno kato mofa'a Bilhana amigeno anaroza higeno, Jekopu'a anteno mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ana higeno Bilha'a Jekopunteti amu'ene huno ne'mofavre kasente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Resoli'a amanage hu'ne, Anumzamo'a fatgoza hu'nane nehuno, nunamuni'a antahinamino ne'mofavre namie. Nehuno agi'a Dani'e huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Resoli kato mofa Bilha'a ete mago'ene amu'ene huno Jekopuna ne'mofavre kase amigeno tare se'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Resoli'a nevreno anage hu'ne, nuna nimofona tusiza hu'na kruno renente'na agateroe. Anage nehuno ana mofavremofo agi'a Naftali'e huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Hanki Lia'a mago'ene mofavre onte mani'neno keana higeno, kato mofa'a Zilpana avreno Jekopu nenaroza hinogu eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lia kato mofa Zilpa'a Jekopuna ne'mofavre kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Anante Lia'a amanage hu'ne, Na knare'za hue, nehuno agi'a Gati'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lia kato a'mo Zilpa'a ne'mofavre Jekopuna kase amigeno tare se'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ana higeno Lia'a anage hu'ne, Nagra muse huankino, a'nemo'za muse hu'mo'e hugahaze. Nehuno Asa'e huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Witi taga hu'za eme vatu nehaza knare, Rubeni'a vano hiregati mago'a rone hunte flaua raga (Mandrake) erino nerera Lia hirega e'ne. Higeno Resoli'a amanage huno Liana antahige'ne, Muse (plis) hugantoanki Rubeni'ma rone hu flaua'mofo raga'a eme kami'nefintira mago'a namio. ");
INSERT INTO kbq_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Hianagi Lia'a amanage hu'ne, Kagrama nenavema hanre'nanana, e'i osi zampi? Hutenka menina ne' mofavrenimo'ma ronema hu flauama erino'ma e'nea erisue hunka nehano? Higeno Resoli anage hu'ne, Ha knarere, ana ronehu flauama namisana nona'a Jekopu'a meni kenage kagrane emasegahie. ");
INSERT INTO kbq_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Higeno ana zupa kinaga Jekopu'a hozaregati ne-egeno, Lia'a kantegati ome nevreno anage huno asmi'ne, mofavre'nimo'ma rone hu flauama erino e'nea flauateti Resolina nemina, kagrira ko miza se'noanki, kagra enka nagrane emasegahane. Higeno ana kenege Jekopu'a Lia'ene umase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Anumzamo'a Leana antahi amigeno, amu'ene huno 5fu'mofona ne'mofavre Jekopu'na kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia anage hu'ne, Anumzamo'a mizani'a namie, na'ankure eri'za mofani'a nenave avre amugeno anteno masegeno mofavre kase nami'ne. Huteno agi'a Isaka'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lia'a Isaka amageteti amu'ene huno 6simofona ne'mofavre Jekopuna kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lia'a anage hu'ne, Anumzamo'a mareri'nea miza muse hunanteno nami'neankino, menina nenave'a nagrira antahinamigahie. Na'ankure 6si'a ne'mofavre kase amue. Nehuno agi'a Zebuluni'e huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Henka'a Lia'a Zebuluni amagetetira mofara mago anteno agi'a Daina'e hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Anantera Anumzamo'a Resoli nunamuna antahi'nemino mofavre ante ku'a eri vasanente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ana higeno amu'ene huno ne'mofavre kasenenteno anage hu'ne, Anumzamo'a nagaze zana eri amne hunante huno nehuno, ");
INSERT INTO kbq_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","agi'a Josefe'e huno antenemi'no anage hu'ne, Anumzamo'a ne'mofavrea mago'ene namisie. ");
INSERT INTO kbq_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Hagi Resoli'a Josefema kasentetegeno Jekopu'a Lebanina amanage huno asami'ne, nonkuma'niare mopani'arega vunaku huanki hunantege'na va'neno. ");
INSERT INTO kbq_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","A'neni'ane mofavre nagani'ane zamagriku hu'na eri'zanka'a eri'na e'noanki natregena va'neno. Hagi kagrake'za eri'zama erigante'noa zana kenka antahinka hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Hianagi Lebani'a amanage huno Jekopuna asami'ne, Nagrama kasnampa hu'na kagri'ma kagoana, nagrane mani'nankeno Ra Anumzamo'a kagriku huno asomura hunenante. Hagi menima kagrama kavesi nantesunka nagrane manio. ");
INSERT INTO kbq_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nehuno Lebani'a ru'ene kea avazu huno anage hu'ne, Kema hananama'a ana avamente kamigahue. Hagi miza agi ahenanto. ");
INSERT INTO kbq_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Higeno Jekopu'a amanage huno asami'ne, nagrama eri'zanka'a eri'na neogeno maka afukamo knareke huno e'neana, kagra kenka antahinka hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nagrama ome'nogenka, kagra osi'a sipisipi afuzaga ante'nananagi, nagrama erua eri'zampi Ra Anumzamo'a asomu hugantegeno rukazi huno rama'a fore hu'ne. Hagi ina zupa natre'nankena a' mofavreni'a zamaza hugahue? ");
INSERT INTO kbq_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Higeno Lebani'a amanage huno Jekopuna asmi'ne, Na'a nagra kamigahue? Higeno Jekopu'a anage hu'ne, Kagra mago zane hunka onamigahane. Kagra magoke zantfa nagrira hunantegahane, nagra mago'ene afuzagaka'a traza me'nesirega kegava hugantegahue. ");
INSERT INTO kbq_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hagi menina natrege'na maka afu zagaka'a mani'nafi vano nehu'na, tupri tapri sipisipine, aganumpa lama anenta'ma tegre ramine'niane, tupri tapri hu'nenia memene avre rure ha'nenkeno, e'i ana afu'zagamo nagri miza megahie. ");
INSERT INTO kbq_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Henka mizama naminaku hanana zupa, havigema hu'zankura e'i anamo eriama hunantegahie. Hakare'a agrono kre ramineni'ane, tupri tapri osu'nenia memempi, aganumpa osu'nenia lama anenta'enema, nagri afupima kenunka kumzafa se'nane huo. ");
INSERT INTO kbq_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Higeno Lebani'a amanage hu'ne, Ha knareki, kema hanaza huo. ");
INSERT INTO kbq_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Higeno ana zagekna zupage, agra'a Lebani'a vuno maka'a agrono krerami'neane, tupri taprima hu'nea ve memene tupri tapri hu'nea a' memene, efeke hu'neane, aganumpa sipisipi afura avrezamige'za amohe'za afete'are ome ante'za kegava hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Lebani'a Jekopuna atreno taregi magoki zagegna vu'are afete afu'zaga'a avreno umanigeno, Jekopu'a ruga'a afu'zagare kegava krino mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Hianagi kegava huno mani'neno tagufa ruzahu ruzahu zafamofo azankunatmi akafrino, ukari'za mago'a nehareno nohareno higeno efeke nehigeno, tupri tapri hu'ne. Ana zafa ukari'ma haregeno'a efeke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","E'i ana zafa azankunatamina erino vuno sipisipine mememo'za ti nenazare zamavuga ana zotaramina mopafi ome rentetere hu'ne. Hagi tima nenaku esanu'za eme nege'za ve afu'moza a' afu'tamimofo zamagumpi marerihogu anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Hanki e'i ana zafa azankunatamima rente'nea tva'ontema ve afu'mo'ma a' afumofo agumpima marerinkeno'a, ana afu'mo'a tupri tapri azoka'ene anenta antegahie. ");
INSERT INTO kbq_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Hanki Jekopu'a tupri tapri' azoka'ene ve afu'zaga agra'a suza refko huganti netreno, aganumpa ve afuzaga zamatrege'za Lebani afuzagafi mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Hanki hankavenetake ve afu'zagamo'zama a' afumokizmi zamagumpima marerizama nehazageno'a, Jekopu'a ana zafa azankuna zamavuga tinkampi arentetere hu'ne. Ana hige'za zafa azankuna rente'nea tava'onte agumpina mareritere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Hianagi hankave'a omane'nea ve afu'zagamo'zama, a' afu'mokizmi zamagumpima marerizama nehazageno'a, Jekopu'a ana zafa azankunatamina zamavuga ome reonte'ne. Hagi hankave'a omne'nea afu'zaga e'i Lebani afu'zagagi, hanave afu'zaga Jekopu suzane. ");
INSERT INTO kbq_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ana nehuno afu'amo hakare higeno, eri'za vene a'ene, kemorine, donkine, hakare'aza nenteno Jekopu'a feno ne' efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Lebani mofavre naga'mo'za agriku'ma nehaza ke'ma Jekopu'ma antahi'neana amanage hu'naze, Jekopu'a nerafa zana maka eri vaganereno, nerafa zanteti agra feno vahe fore huno manie. ");
INSERT INTO kbq_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Hanki Jekopu'a Lebani avu'ava'ma keana ko'ma nehiaza osuno, avugosa hunenanteno ha' vahe'mo hiaza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ana nehigeno Ra Anumzamo'a anage huno Jekopuna asmi'ne, Nagra kagrane manigahuanki ete negafane vaheka'a moparega vuo. ");
INSERT INTO kbq_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Higeno Jekopu'a ana kema nentahino'a afu'zagama zamavareno ome zamate'noma mani'nerega e'ogu, Resoline, Liagiznirega ke atreznantegeke, ");
INSERT INTO kbq_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","anante akeno amanage huno zanasmi'ne, neranafa'a ko'ma nehiaza huno nagranena kiza zokago huno menina omanie. Hagi avugosamo'a ruzahu nehige'na negoe. Hianagi nenfa Anumzamo'a nagrane mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nagrama neranafa eri'zama tusi namu'na sisi nehige'na hanaveni'a atre'nama eri'noana, tanagra nageta antahita hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Anama hu'nogura agesa ontahino, renavatga huno mizani'a 10ni'a zupa eri antenaga henka hu'ne. Hianagi Anumzamo'a atregeno nazeri havizana osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kora Lebani'a amanage huno nasmi'neane, maka'a tupri tapri azoka'ene afu'zaga eri'za enerina mizanka'e, higeno tupri tapri ke'za fore hu'ne. Hagi agrono tegre ramira mizanka'e hiana, anazanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","E'ina higeno Anumzamo'a neranafa azampintira memeramine, sipisipiramine, rama'a nagri avre nami vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Hanki afu'zagamo'ma agafima ahea knafi amanahu ava'na ke'noe. Maka'a ve mememofo avufgarera tupri tapri ene agrono krerami krerami hu'nea azoka me'nege'na negogeno, a' mememofo agumpina mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Anumzamofo ankeromo'a ava'nafi amanage huno nagia ahe'ne. Jekopuo! Hige'na ama mani'noe hu'na hugeno, ");
INSERT INTO kbq_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Anumzamofo ankeromo'a amanage hu'ne, tupri tapri'ene avon krerami'nea ve meme zagamo'a a' meme agumpima marerime neviana, kesga hunka ko, Lebani'ma maka'a avu'ava zama hunegante'mofona, Nagra ko ke'noe. ");
INSERT INTO kbq_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nagra Betelima efore'ma hugenka have eri atru hunka masave taginka frenentenka navufi huvempa hu'nana Anumzamo'na nehuanki menina otinka ama kumara atrenka, fore'ma hu'nana kumatega vuo huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Higeke Resolike, Liakea ana naneke nentahi'ne, amanage hu'na'e. Tagra nerafa afu fenompintira mago'zama erisu'a zana huhampri orante'neanki, na'a hugahu'e? ");
INSERT INTO kbq_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hagi nerfa'a ko hurantegeta ruregati emani vahe kna hu'noe. Tagrira ko mizante tatre'ne, Tagriteti afufeno eriana ko ana afu fenona atre hana hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tamage nerfa azampinti Anumzamo'a maka zana kagri hanare kamiana, e'i ana maka zana tagri'ene mofavre'tine suzane. E'ina hu'negu Anumzamo'ma kasami'niaza huo. ");
INSERT INTO kbq_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Hagi Jekopu'a maka a'mofavre'a, kemori afutamimofo zamagumpi zamavarentere nehuno, ");
INSERT INTO kbq_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","maka'a afu'ane, fenoma'ane emani'neno eritru hu'nea zana zogi hana huno Padan-Aram mopa atreno, Kenani moparega nefa Aisaki'ma mani'nerega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Hagi Lebani'a afete umani'neno, sipisipi azoka neharegeno, Kenanima vunaku'ma retrotra nehazageno'a, Resoli'a nompi marerino Lebani'ma havi anumzante mono hunentea zana, musufa seno erino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jekopu'a Arameania nera Lebanina osami revatga nehuno freno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jekopu'a maka zama'a enerino otino fre'no vuno, Yufretis tina takaheno Gileati agonarega avugosa hunteno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Hagi taregna evutege'za anante knazupa mago'a vahe'mo'za, Jekopu'a hago katreno fre'ne hu'za Lebanina ome asami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lebani'a ananke nentahino naga'a nezamavareno Jekopuna arotgo hu'za vu'naze. Hagi agene re'nazana 7ni'a hanine, zagene karanka mase'naze. Hagi Jekopu'a Gileati agonafi mani'nege'za ome azeri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hianagi Anumzamo'a Arameani ne' Lebanina kenage ava'nafi efore humino anage huno asami'ne, Kva huo, Jekopuna magore hunka so'e kefi havigea huonto. ");
INSERT INTO kbq_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekopu'a seli no omegino agonafi mase'negeno, Lebani'a ana agonafi Jekopu'na ome azeri'ne. Hagi Lebani'a vahe'ane mago kaziga seli no omegino, Gileati agonafi mase'naze. ");
INSERT INTO kbq_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lebani'a anage huno Jekopuna asami'ne, Kagra nahigenka renavatga hutenka mofani'ararena hapinti kina huzmante'za zamavare'za frazankna hunka zamavarenka e'nane? ");
INSERT INTO kbq_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nahigenka okura frenka renavatga hu'nane, nasminke'nasinia, muse nehu'za tambori'nine, zavena nehe'za hugantagenka tatrenka asine. ");
INSERT INTO kbq_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hagi nahigenka nasminke'na nagehe'ine, mofani'ararena zamantako nehu'na huso'e huzmantogenka zamavarenka ome'nane? Kagra mago kefo avu'avaza hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nagrira hanaveni'a me'neankina, kagrira ha' kahenaku e'noanagi, meni kenagera masenogeno negafa Anumzamo'a amanage huno nasmi'ne, Jekopuna azeri koro osuo, magore hunka havi keo, so'e keo huonto huno nasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nagra antahi'noe natrenka'ma anana, na'ankure negafa nonku tusiza huno kvenesigenke. Hianagi nahigenka anumzani'a noni'afintira kumzafa senka e'nane? ");
INSERT INTO kbq_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Higeno Jekopu'a ana kemofo nona'a amanage huno Lebanina asami'ne, Na'ankure nagrama antahuana hanavetinka mofa trenka'a hanaregahane nehu'na koro hu'na oku'a e'no'e. ");
INSERT INTO kbq_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aza'o mago'mo'ma ana anumzanka'a erino e'nesnimofona hakrenka erifore hanankeno'a, anamo'a frigahie. Nege'nagenka nagati'amofo zamufi mago'a kagri zama nagri fenompima me'neniana erigahane. Hagi Resoli'ma musufa seno e'negura Jekopu'a ontahi'neno, anahu kea hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lebani'a, Jekopu seli nompi ome agafa huno hakreteno, Lia seli nompi ome keteno, tare eri'za a' tremokizni seli nompi keme viana onke'ne. Anantera Lia seli nona atreno Resoli seli nompi umareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Resoli'a ana havi anumza erino vuno kemorimofo agofetu ante'za nemaniza tra'mofo agu'afinka ome anteteno, agofetu manino rentrako hu'ne. Hagi Lebani'a hakreno vano hiana keno eri fore osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Resoli'a amanage huno nefana asami'ne, O'maotisnua zankura ranimoka kea onasuo, ika kri'ma enerua kna ege'na mani'noe. Lebani'a maka zampina hakreno keno eviana ana havi anumzama'a kefore osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jekopuna asi vazigeno ke ha' Lebanina renteno, Lebaninkura amanage hu'ne, Nagra mago zanka'a eri haviza hu'nogenka amanahura nehano? Naza mago havizana hugante'nogenka navaririnka ne-enka, haha'ene kea hunenantane? ");
INSERT INTO kbq_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nagri feno zama re'nanana, naza magora kagri zana nonka'afintira eri'na e'nogenka hakrenka erifore hane? Hakrenkama erifore hu'nenunka, tavufi eri atru hugeta, nagri vahe'ene, kagri vahe enena negeta eri fatgo ha'mneno. ");
INSERT INTO kbq_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Hagi 20'a kafumofo agu'afima eri'za erigante'noana a' sipisipimo'o, a' mememo'o magore huno anentara kase havizana, nosige'na ve sipisipi afu zagaka'afintira magore hu'na ahena one'noe. ");
INSERT INTO kbq_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Hanki afi zagamo'ma afu'zagama aheno nege'na, kagrira eme onkasami'na, ferupi kenagepi afu'zagafinti kumazafa sazage'na, nona'a nagra'a suampinti avre'na kegina ka'afi eme antetere hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ana nehu'na zage knafina zage hara tusiza huno nave'nesigeno, kenagera tusiza huno zasimo'a nazeri kragenefege'na, magore hu'na navura mase so'e hutere osu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Hagi nagra kagri nompina e'inahu zana 20'a zagegafu hu'noe. Nagra 14ni'a zagegfufi tarega mofaka'ama eri'nakura eri'zana eri'noe. 6si'a kafufina afu'zagaka'ama kegava hu eri'za eri'noe. Ana nehugenka mizani'a 10ni'a zupa eri fenka anaga hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Hianagi nenageho Abrahamu Anumzama, nafa'nia Aisaki'ma koro hunenteno mono'ma hunentea Anumzamo'ma nagranema omani'nesina, antahuana kagra menina naza navapa hunantanke'na osine. Hianagi narimpa knazampi mani'noa zane hanave eri'zama eri'noa zanena Anumzamo'a nenageno, kenagera hanavetino nanekea eme hugantene. ");
INSERT INTO kbq_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lebani'a ke nona amanage huno Jekopuna asmi'ne, Tare mofatrena nagri mofatre mani'na'e. Hanki mofavre zaga nagri mofavre zage, afu'zaga nagri afu'zage, maka zama neganana nagrike zane. Hianagi mofatreni'ane mofavrema kase zamante'na'ana menina nagra inankna huzmantegahue? ");
INSERT INTO kbq_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","E'ina hu'negu menina egeta, naneke huvempa huteta, have zogita emeri atru huntesukeno amu'nonti'afi me'nena, henka ama ana avamezama negenuta'a, amama huhagerafu'a zankura tagesa antahitere hugahu'e. ");
INSERT INTO kbq_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jekopu'a mago avame'za za'za have ome erino anante retrureno asenenteno, ");
INSERT INTO kbq_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","naga'a ke hige'za mago'ene havea eri'za anante kevu vazintete'za, ana have kevumofo tvaonte kave ne'naze. ");
INSERT INTO kbq_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lebani'a ana havemofo agi'a Jegar-sahaduta'e huno Aramea kefina nehuno, Ama have atrumo huragesa hugahie huno ante'ne. Hianagi Jekopu'a Hibru kefina Galitie huno agi'a nenteno, ama have atrumo hu tagesa hugahie huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lebani'a amanage hu'ne, amama eritru hu'a havemo menina avame'za amu'nonti'afina megahie. Hu'ne nehu'ne ana havemofo agi'a Galitie hu'ne ante'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ete mago agi'a Mizpae hu'ne ante'na'e. Lebani'a amanage hu'ne. Tagra afete mani'neta oge age osuta mani'neta maka avu'ava'ma hanu'ana, Ra Anumzamo agrake tagegahie. ");
INSERT INTO kbq_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Hagi kagrama mofa'nimokizni hazenke ati zanamige, mago ru a'ne erige hananana, amunonti'afina magora vahera omani'nazanki Anumzamo agrake tagegahie. ");
INSERT INTO kbq_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lebani'a mago'ene Jekopuna anage huno asami'ne, Antahio, za'za havema asento'a negenka, amama oti'no'a amu'nontiafima eri atru hu'a havea ko. ");
INSERT INTO kbq_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Amama mani'neta huvempa huta asento'a havemo, amu'nontiafi me'nena, nagra ama ana havea agatere'na krimpa eri haviza hu'zana osugahue. Hagi kagra eri atru hunto'a havene, asento'a havene agaterenka narimpa eri havizana osuo. ");
INSERT INTO kbq_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hagi Abrahamu Anumzane, Nahori Anumzane, neznafa Anumzamo amu'nontiafina refko hurantegahie. Hagi Jekopu'a nefa Aisaki'ma koro hunenteno mono'ma hunentea Anumzamofonte huvempa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jekopu'a e'i ana agonafi Kresramana vu ne'za kreno Anumzamofontega ofa hunenteno naga'a zamagi hutru hige'za nete'za, ana agonafi mase'naze. ");
INSERT INTO kbq_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lebani'a nanterame otino mofatrema'ane, agehe'ine nezmavatagino zamantako nehuno, asomu ke huzmante'ne. Ana huteno, Lebani'a kuma'arega ete vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jekopu'a kantega nevigeno, Anumzamofo ankeromo'za agrite efore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Hagi Jekopu'ma nezmageno'a amanage hu'ne, Ama Anumzamofo nonkumare, nehuno agi'a Mahanaimie huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jekopu'a ke erino vu vahe huzmantege'za vugote'za nefu Iso mani'nere Idomu moparega, mago agi'a Seirie nehazarega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Hagi Jekopu'a mago'ene amanage huno huzmante'ne, Amanage huta ranimofo Isona ome asamiho, eri'za neka'a Jekopu'a anage hie, nagra Lebani mopafi mani'noreti menina neoe. ");
INSERT INTO kbq_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nagra bulimakao afutaminki, donkiraminki, memeramine, sipisipi kevuzagane, eri'za veanine zamavare'na ne-ena ranimoka kagrama kasunku'ma hunantenka mago krimpama hunka antahinamisanku hunezmantoe, hie huta ome asmiho. ");
INSERT INTO kbq_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hige'za kema eri'za vu'naza vahe'mo'za ete e'za Jekopuna amanage hu'za eme asmi'naze, Negafu Isona ome asamunanagi kantega tutagiha hugantenaku ne-ege'za, 400'a vahe'mo'za avega hu'za neaze. ");
INSERT INTO kbq_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Hazageno Jekopu'na tusi amano vazigeno agu'amo tare nehigeno, miko'a zama'ane vahe'ane, bulimakao kevune, memeramine, sipisipiramine, kemoriramina tarefi refko huno kevu huzmantene. ");
INSERT INTO kbq_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Amanahu agesa agra antahi'ne, Iso'ma, mago kevuma ha'ma eme huzmantesigeno'a, mago kevu'moza fresnaze, huno nehuno tare kevua refako hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E'ina nehuno amanage huno Anumzamofontega nunamuna hu'ne, Nenageho Abrahamu Anumzane, nafa'nimofo Aisaki Anumzana, Ra Anumzamoka Kagra nasaminka, ete kagra mopaka'are nagaka'arega vuge'na, kazeri knare hugantaneno hunka hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nagra knare osu vahe mani'nogenka vagaore kavesizane, kema hu'nante amage ante avu'avazanena Kagra eri'za vahekamo'na naveri' hu'nane. Hagi nagra magoke azompa eri'nena Jodani tina takahe'na vu'noe. Hanki menina nagra tare seli nonku'ma eme ki'na mani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Koro nagesa nehige'na, nagra nunamu nehuanki, nenfu Iso azampintira, nagu'vazio. Na'ankure eme nenaheno, mofavre ni'ane, nezamareranena zamahegahianki naza huo. ");
INSERT INTO kbq_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Na'ankure Kagra hunka, Nagra kazeri ra neha'nena kagehe'za hagerinkenafi kasepankna hanage'za, vahe'mo'zahampri hana hugara osugahaze, hunka ko nagrira hunante'nane. ");
INSERT INTO kbq_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Hagi ana kenagera anante maseteno, kotigeno otino mika'zama erino e'nefintira ase'ma hu'neama'a refko huno muse'za nefu Iso ami'za eri atru hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200'a a' memeraminki, 20'a ve memeraminki, 200'a sipisipiraminki, 20'a ve sipisipiraminena zamavarenenteno, ");
INSERT INTO kbq_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30'a kemori afuzagane anenta'zmine, 40'a a' bulimakaoramine, 10ni'a ve bulimakao afuzagagi, 20'a a' donkiraminki, 10ni'a ve donki afutaminki huno zamarente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ana huteno eri'za vahe'amokizmi huzmantege'za afu'zaga kevure kevure refko hute'za rure rure zamavare'za nevazageno amanage huno zamasmi'ne, navuga vugoteta nevuta rure rure zamavareta viho, ");
INSERT INTO kbq_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","huno nehuno, kotama vaza nagamokimire'ma vugotama hia eriza nera, amanage huno hankave ke asmi'ne, Nenfu Iso'ma eno emenegageno, igati vahe'moka, iga nevane, aza afu'zaga zamaregotenka neane? huno kantahigesigenka, ");
INSERT INTO kbq_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","amanage hunka asmio, eri'za vahekamofo Jekopu afutamine. Muse'za ramofo nefu Iso ami'zane, hagi agra henka tamage'a ne-e hiho. ");
INSERT INTO kbq_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Hanki anante anante'ma hu'za henkama vutere haza afu kevuraminte'ma kvama hu'zama vaza eri'za vahe'tmina kantegama Iso'na kesuta anankege ome asamiho, huno huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Anage nehuno mago'ene amanage huno huzmante'ne, Eri'za vaheka'a Jekopu'a agra tamefiga'a ne-e huta hiho. E'i anankema hu'neana, na'ankure kote'na museza ami'nenkeno e'nerino rimpa fru hutena, henka avufima ome negesugeno'a muse huno navregahie huno Jekopu'a agesa nentahino hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Anage huno nentahino huzmantege'za ana musezama amisia afu kevua zamavare'za vugota hu'za vazageno, ana kenagera seli noma ki'za mase'nare Jekopu'a anante mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ana kenage amu'nompi Jekopu'a otino a' trema'ane, eri'za mofatrene, 11ni'a mofavre'ane zamavareno Jabok osi tina kagata hu'nere ome zamatrege'za takahe'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Zamavreno ome zamatreteno eri'za vahe'a huzmantege'za, maka afufenoma'a eri'za takahe'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Anante Jekopu'a agrake mani'negeno, kenagera mago ne' anante ege'ne ogazafe agazafe hu'neke, oretufe aretufe nehakeno vuno kotu'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ana ne'mo'ma keama Jekopuma agate'marega osuno'a, amumazinare regri'nea zaferinare ahegeno Jekopuna amumazinamo'a avazu hurami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ana higeno ana ne'mo'a amanage hu'ne, Kotu'za hianki natrege'na va'neno, huno ana ne'mo'a higeno, Jekopu'a ana nekura huno, Katra'nena ame hunka ovugahananki, asomu hunantetenkage vugahane, huno higeno, ");
INSERT INTO kbq_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ana ne'mo'a antahigeno, Kagi'a azage, higeno, Nagra Jekopu'ne huno asamigeno, ");
INSERT INTO kbq_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ana ne'mo'a huno, Mago'ene kagrikura Jekopu'e hu'za osugahaze. Na'ankure Anumzane, mopafi vahe'ene hara hunka agatere'nanku menina kagi'a Israelige. ");
INSERT INTO kbq_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Higeno Jekopu'a antahigeno, Muse (plis) hugantoanki kagika'a nasamio, huno antahigegeno, Na'anku Nagri nagigura nantahi negane? Nehuno anante asomu hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Higeno Jekopu'a huno, Nagra Anumzamofo avufi koanagi ofri manue, nehuno Jekopu'a ana kumakura Penielie huno agi'a ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Penieli kumara agateretegeno, zagemo'a hanati anamifi tegeno, revazmu revazmu huno vu'ne. Na'ankure amumazinamo'a ruvazu hu'negu anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ana hu'negu menina Israeli vahe'mo'za zagagafamofo amumazinamo'ma agezafima eme regri'nerema me'nea ame'a nonaze. Na'ankure Jekopu amumzinama avako'ma hu'nea zanku hu'za nonaze. ");
INSERT INTO kbq_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Hagi Iso'a 400'a vahe'ane ne-egeno, Jekopu'a kesga huno negeno mofavre naga'a refko huzmantege'za, nezmarera Liane, Resoline, tare eri'za a'trene zamavuga otitere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ana huteno eri'za a'trema'ane mofavre'zanine huzmantege'za vugota hu'za vu'naze. Anantera Lia'ene mofavre naga'ane vazageno, Resoli'ene Josefekea henka vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Hianagi Jekopu'a agra vugoteno vugofa nehuno, 7ni'a zupa rena ome reno mopafi kepri hume vuno nefu tava'onte uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","E'ina higeno Iso'a negeno agareno eno Jekopuna azante eme azerino agazafeno, azana anankempi rugagino antako hunentege'ne, zavi otente atente hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ana huteke Iso'a ana a'nene mofavre ramine nezmageno anage hu'ne, Zamagra iza'za kagranena neaze? Huno antahigegeno, Jekopu'a amanage hu'ne, Anumzamo'a so'e hunanteno eri'za vahekamo'na nami'nea mofavreramine. ");
INSERT INTO kbq_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Anante Jekopu eri'za a'trene, mofavrezinine vu'za Iso agiafi ome zamarenare'za mopafi kepri hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Anante Lia'ene mofavre naga'ane ne-eza anazanke hu'za Iso agiafi zamarena eme re'za mopafi kepri hazageno, Josefe'ene Resolike henka'a anazanke hune mopafi eme kepri hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ana hutageno Iso'a amanage huno Jekopuna antahige'ne. Ese'ma afu'zaga avre'za e'naza vahe'ma zamage'noana nahigenka huzmantanke'za e'naze? Higeno Jekopu'a amanage hu'ne, ranimoka kazeri muse hunaku e'inara hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Hianagi kenona Iso'a amanage hu'ne. Nagnanimoka, nagra hago rama'a feno ante'noanki, kagrama erinkama e'nana zanka'a kagra erio. ");
INSERT INTO kbq_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Hianagi Jekopu'a amanage hu'ne, A'o, muse (plis) hugantoanki nagri'ma kagu'areti'ma hunka antahi nenamisunka amama negamua musezana (gift) nazampintira erio. Hagi musema hunka navrana zama koana, Anumzamofo avugosa keankna nehugenka nagrira krimpa naminka nenavrane. ");
INSERT INTO kbq_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Muse (plis) hugantoanki nagrama muse'zama (gift) negamuana eri'nanegu navenesie. Na'ankure Anumzamo'a avesi nenanteno naza huno hakare'aza nami'nege'na, knare hu'ne'na eme negamue. E'inage huno Jekopu'a hankavetino kehigeno Iso'a ana zantamina eri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Iso'a ana museza (gift) enerino amanage hu'ne, Nagra vugota'nena magoka vugahunanki otinketa vamneno. ");
INSERT INTO kbq_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Hianagi Jekopu'a amanage huno Isona asami'ne, ranimoka kama antahio, mofavrenimo'za hanave oti'nazageno, afu zagamo'za ami anuntage nehaze. Hagi magoke zagefinke'ma afu kevuma harita zaza kama vanunke'za, ufrigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","E'ina hu'negu (plis) muse hugantoanki ranimoka, eri'za nekamo'na natrenka vugota huge'na, afu kevu zagane, a'mofavremo'zanema kama vanaza avamente akoheta nevuta, Seiri kumate (Idom) ranimokare uhnatigahue. ");
INSERT INTO kbq_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso'a ana kenona amanage hu'ne. Muse (plis) hugantoanki mago'a eri'za vaheni'a zamatra'nena kavega hu'za vugahaze, higeno Jekopu'a amanage hu'ne. Ko' ranimoka nazeri so'e hunananki na'ante anara hugahane? ");
INSERT INTO kbq_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Higeno Iso'a netreno, ana zupage Seiri (Idom) moparega ete vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jekopu'a Sukoti kumatega vuno, e'i ana mopare noma'a negino, afu kevumokizmi none kine. E'ina hu'negu menina ana kumamofo agi'a Sukotie hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Hagi Jekopu'a Padan-aramu mopa atreno ne-eno Sekemu ehanatino, Kenani mopare ra kuma'mofo fegi'a nonkuma (kemi) eme anteno mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E'i ana mopa Hamori amohe'impinti, Sekemu nefa mopa 100'a silva zagoreti miza huno seli nona ki'ne. ");
INSERT INTO kbq_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Anante havere ita tro hunteteno agi'a El-Elohe Israeli vahe Anumzane, huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Daina'a Jekopune, Liagizni mofakino mago kna a'ne zamagenaku Sekemu kumate vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ana higeno Hivi vahe kva ne' Hamori nemofo Sekemu'a negeno monko'za huntenaku hankavetino avazu huno kefo avu'avaza hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemu'a Jekopu mofa Daina avesinenteno, akoheno masave kefinti kea humi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemu'a amanage huno nefa Hamorina asmi'ne, Ama mofara a' erinaku nehuanki avre namio. ");
INSERT INTO kbq_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jekopu'a mofa'amofo Dainama kefo avu'avazama hunte'nea ke nentahino, akoheno ke osu mani'nege'za, mofavre'amo'za afu kva nehazaregati e'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sekemu nefa Hamori'a Jekopuntega ana hazenke'mofo keaga hunaku vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jekopu amohe'za sipisipi afu kegava hu'za mani'ne'za ana hazenke zamofo kema nentahi'za, kumate ehanatizageno zamagu'amo'a kna nehigeno tusi zamasi vazi'ne. Na'ankure e'inahu kefo avu'ava zana Israeli vahepina osuga'za, Jekopu mofara hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hianagi Hamori'a amanage huno zamasmi'ne. Sekemu'a agu'areti huno mofatamia avesinenteno, e'i ana avu'ava zana hu'negu, muse hurmantoanki aminkeno a' erinteno. ");
INSERT INTO kbq_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mofane omi ami hugahunanki, atrenke'za namohe'za mofaneka'a a' erisageno, kamohe'za mofa'nenia a' erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tamagra, tagrane mani'neta mopatifina tamevesite vano nehutma, nazanoma tro'ma hunaku'ma hanutma amne tro nehutma mopane nonena miza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Hagi Sekemu'a Daina nefa Jekopune asarahehe'gizmia amanage huno zamasami'ne. Tamagrama knarere hanage'na, inankna zanku tamavesisia zana nagra tamamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mofa tamimofonte zago fenonku'ma agima ahenantesazana, kema hanaza kante antena tamigahue. Hagi mofa tamia naminke'na a' eri'neno. ");
INSERT INTO kbq_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jekopu amohe'za Sekemune nefa Hamorigizni reznavatga hu'naze, na'ankure nezmasaro Daina azeri haviza hu'negu zamagesa nentahi'za, kea hufatgo osu'za havige hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Zamagra amanage huza hu'naze, Oku avufga taga osu vahe'mo'ma nerasaroma a' erisigeno'a, tagaze hugahiankita tagra e'inahuzana osugahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hianagi mago'zana oku kvufama taga osu'nana kazigati nehunanki, tagrama hu'nonankna hu'za, kagri naga'mo'za oku'a zamufga mika'moza taga hutesageta, hu izo hugahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ana hanunketa tamagra tagri mofane ara erisageta, tagra tamagri mofane ara enerita magoke vahe trohuta manigahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Hianagi tamagrama ketima antahita oku tamufga taga osnageta, nerasarona avreta ama kumara atreta vugahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Anage hazageno Hamori'ene nemofo Sekemuke ana kema nentahike hugnare hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekemuna nefa naga'mo'za antahi nemiza nekino, anagema haza kea nentahino, Jekopu mofate agu'a me'negu hantaka huno ana kemofo amage' ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamorike nemofo Sekemu'ene ran kumamofo kahante eke atru hu'za kenaneke eri fatgo nehaza kumate ana kea vahe eme zamasmike amanage hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hagi knare knampa hurantaze, zamatre sunke'za mopatimo'a ra hu'neaki'za mani'neza, inankna'zana mizante tro nehuta, mofanetia omeri emeri hugahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Hianagi oku tavufga taga hutesunke'za, ana zanku mago zamarimpa hu'za tagrane, mago vahere hu'za mani'gahaze. E'ina hu'negu zamagrama hazankna huta maka'a vene'nemota oku tavufga taga hugahune. ");
INSERT INTO kbq_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Afu kevuzimine, feno zamimo'a tagri'za segahie. Hanki tagrama zamagri kemofoma avaririta oku tavufga taga hanunke'za, tagri'ene knare hu'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Anage nehake'za hakare'a vahe'mo'za rankumamofo kahante atirami'za, Hamori'ene, nemofo Sekemugizni ke nentahi'za, mika rankumapi vene'nemo'za oku zamufgamofo anoma'a taga hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Hagi tagufa zage agateregeno anama oku zamufga taga hu'naza vahe'mo'za tusi zamatagu nehu'za mase'nageno, Daina nesaro Simioni ene, Livaikea bainati kazi eri'ne, ana kumapi vu'ne maka'a vahera antri hazaza hu'ne zamahe hana hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamorine nemofo Sekemu'giznia bainati kazinknonu zanahe nefri'ne, Sekemu nompinti neznasaro, Dainana nevre'ne vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dainama kefo avu'ava'ma hunte'naza zanku, Jekopu mofavre naga'mo'za ana kumapi mareri'za, maka'a knare'zana eri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Sipisipi afu kevuma, bulimakaoma, donkima, kuma agu'afi me'nea zama fegi'a me'nea zanena maka eri hana hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Hakare'a razama, onensa zama, a' mofavrene nompinti zane eri hana hu'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jekopu'a amanage huno Simionine, Livaigiznia zanasmi'ne, Kenani vahe'ene, Peresi vahe' amu'nompina knaza erita eme nenamita nagrira nazeri hi'mnava'e. Tagra onensa'a vahe' mani'nonanki'za, atru hu'za ha'ma eme hurantesu'za, nagri'ene maka zani'ane nazeri haviza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hianagi kenona'a anage hu'na'e, hanki nahigeno nersarona, monko a'nemofoma hunenteankna avu'avara hunte'ne? ");
INSERT INTO kbq_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Anumzamo'a amanage huno Jekopuna asami'ne, Ko'ma negafu Isonku'ma koro frenka nevanke'na kagrite efore hugami'noa kumate otinka anagamu Beteli vunka anante umani'nenka, anante Anumzamo'na ita tro hunanto. ");
INSERT INTO kbq_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Higeno Jekopu'a amanage huno naga'ane, Agranema nemaniza naga'mokizmia zamasmi'ne. Maka havi anumzantmina netreta, tamagu'a retro nehuta, agru kukena timia antaniho. ");
INSERT INTO kbq_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","E'ina hutenketa anagamu Beteli vuta, antahima nenamino kna'zampinti'ma naza nehuno, hakare kazigama nevugeno nagranema nemania Anumzamofo Kresramanavu ita, e'i anante ome tro hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","E'inage hige'za maka vahe'mo'za havi anumzazamine, zamegesafi renentaza rinine eri'za Jekopu eme amizageno erino Sekemu rankuma tava'onte oki zafa agafafi keri kafino asente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hagi Jekopu'ma karanka naga'anema nevigeno'a Anumzamo'a Kenani kumapima nemaniza vahera zamazeri koro hige'za, mago'zana huozamante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jekopu'ene vahe'ane ana maka vu'za Lusi uhanati'naze. Mago agi'a Beteligino ana mopa Kenani me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jekopu'a havere ita tro hunteno agi'a El Betelie hu'ne. Na'ankure nefu Isonku koro'ma freno nevigeno, Anumzamo'a korapara anante fore humi'neane. ");
INSERT INTO kbq_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Anante mani'nageno Rebekana avate eri'za ara Debora'a frige'za oki zafa agafafi Betelia ohenkamu'a asente'naze. Nehu'za agi'a Alon Bakutie hu'za ante'naze. (Zamagra kefina, zavi zafe hu'naze.) ");
INSERT INTO kbq_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Hagi Padan-Aramuma atreno Jekopu'ma ete Kenani moparema egeno'a, Anumzamo'a mago'ene efore humino, asomu hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Anumzamo'a amanage huno asmi'ne, Menina kagi'a Jekopu'e huno me'ne. Hianagi mago'enena Jekopu'e hu'za osugahazanki, Israeli'e huno kagi'a megahie. Israeli'e huno Anumzamo'a Jekopu agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Anumzamo'a mago'ene amanage huno asami'ne, Nagra hihamu'ane Anumzane, mofavrea kasezmantege'za kokankoka mopafina fore huhakare hu'za rukazi hu'za rankumara ante'za nemaninage'za, mago'amo'za kini vahera efore hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abrahamune, Aisaki'gizni Nagra zanami'noa mopa kagrira kamigahue. Hagi henka ama ana mopa Nagra kagehe'i zamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anage huteno Anumzamo'a Jekopu'enema keagama ha'a kumara atreno ete mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jekopu'a ra have erino eme retru renenteno, ana haverera waini ti tagino ofa nehuno, oliv masave erino eme ragi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ana nehuno Jekopu'a Anumzamo'enema keaga hu'nea kuma'mofo agi'a Betelie huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Hagi anantetira Jekopu'a naga'ane Betelia atre'za, Efrata kumate vunaku nevazageno, kantega Resolina mofavre ante kna'amo'a egofta higeno tusi atagu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hagi Resolina mofavre'za negegeno tusi atagu nehigeno anante mofavrema aza huno kase aminaku'ma avega huno mani'nea a'mo'a amanage huno asami'ne, mago' ne'mofavre kasentananki korora osuo. ");
INSERT INTO kbq_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Resoli'a kasenteteno fri'za nehuno ana mofavre agi'a Ben-oni'e nasunku mofavre huno ante'ne. Hianagi Jekopu'a Benzameni'e nazantamaga mofavre huno agi'a ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resoli'a frige'za Efrata vu kamofo ankenare asente'naze, (mago agi'a Betlehemue.) ");
INSERT INTO kbq_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jekopu'a ra have erino vuno Resolima asente'nea kerimofo agofetu ome retru re'ne, menina Resoli kerire retru re'nea havea amne me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hagi anantetira Israeli'a (Jekopu'a) viazamo mani'ne'za afu kva nehaza noma Ederi kumate'ma me'neana agatereteno vuno ogantu'a seli nonku'mara omegino mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Anampi umani'nageno Israelina (Jekopu'na) agonesa ne'amo Rubeni'a, nefana mago a'a, nenaro eri'za erinente'a a' Bilhama anteno mase'nea kea Israeli'a antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Hagi ama'i Jekopuna 12fu'a ne' mofavre'amofo zamagi'e. Lia'ma kasezmante'nea ne'mofavrea Rubeni'a Jekopuna zage'e, anantera Simioni'e, Levi'e, Juda'e, Isaka'e, Zebuluni'e. ");
INSERT INTO kbq_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Hagi Resoli'ma kasemante'nea ne'mofavrea Josefe'ene Benzamenike. ");
INSERT INTO kbq_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Hagi Resoli eri'za a'mo Bilha'ma zanante'nea ne'mofavrea Dani'ene Naftalike. ");
INSERT INTO kbq_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Hagi Lia eri'za a'mo Zilpama kase zanante'nea ne'mofavrea Gati'ene Aselikie. Ana hu'neankino Jekopu'a Padan-Aram mani'neno zamazeri fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jekopu'a nefa hirega Mamre Kiriat-arba e'ne, e'i mago agi'e Hebronie, ana kumara nefa Abrahamu'ene Aisakike zoka umanina'a kumare. ");
INSERT INTO kbq_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisaki'a 180'a Zagegafu mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Aisaki'a za'za kna maniteno ozafa reteno renteramino, vagare asimu anteteno frino agehe'zane agigomo'zama umani'nazarega vu'ne. Jekopuke, Isoke eri'ne ome asente'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ama'i Isompinti fore hu'za vu'naza naga'mokizmi zamagi'e, Isona mago agi'a Idomu'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso'a Kenani vahe'mokizmi mofane ara eri'ne, Ada'a Hiti ne Eloni mofare. Oholibama'a, agra Ana mofakino Hivi ne' Zibeoni negeho'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Hanki mago a'mofo agi'a Basemati'e, Ismaeli mofa, Nebaioti nesaro'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada'a Elifazi kasentegeno, Basemati'a Reueli kase ante'ne, ");
INSERT INTO kbq_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama'a Jeusima, Jalamuma, Korama huno kase zamante'ne. Iso'ma Kenani mopare mani'neno kasezmante'nea ne'mofavreramimofo zamagi'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Iso'a a'neane, ne'mofavre ane, mofa'neane, maka noma'afi nemaniza naga'ane, memene, sipisipi kevune, bulimakao kevune, mika fenona Kenani mani'neno erifore hu'nea fenoma'ane enerino, negna Jekopuna atreno afete moparega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Maka zazanimo'a hakare nehigeno, afu kevu zinimo'a rukazi huno emanina'a mopamo'a avitegeno, Iso'a atreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Higeno Iso'a Seiri agona moparega umani'ne. Isona mago agi'a Idomu'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso'a Seiri agona kokampi nemaniza Idomu vahe'mofo nezmageho'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso ne'mofavremokizmi zamagi'a, Elifazi'a Iso nenaro Ada ne'mofavre, Reueli'a Iso nenaro Basemati ne'mofavre. ");
INSERT INTO kbq_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Hanki Elifazi ne'mofavre zamagi'a Temani'ma, Omari'ma, Zefo'ma, Gata'ma, Kenasi'ma hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso nemofo Elifazina, mago kazokzo eri'za a'amofo agi'a Timna'e. Timna'a mago ne'mofavre Elifazina kase ami'ne, agi'a Amaleki'e. Iso nenaro Ada ana ne'mofavrea kase zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Hanki Reueli ne'mofavre zamagi'a, Nahati'e, Zera'e, Sama'e, Miza'e. E'i ne'mofavre nagara, Iso nenaro Basemati kase zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isona mago a'amofo agi'a Oholibama'e. Ana mofakino Zibeon negeho'e. Ama Iso nenaro Basemati'ma kase zamante'nea ne'mofavre zamagi'a, Jeusi'e, Jalamu'e, Koranki huno Isona kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hagi Iso nagapinti kva eri'za eri'naza vahe zamagi'e. Isona agonesa ne'mofavre Elifasi ne' mofavre naga'mo'za kva eri'za eri'naza vahe zamagi'a Temani'e, Omari'e, Zefo'e, Kenazi'e, ");
INSERT INTO kbq_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora'e, Gatami'e, Amaleki'e. E'i'a kva vahe'tmina Idomu mopafi kegava hu'naze. Elifasi nagapinti, Isone nenaro Adakizni zanagehoze. ");
INSERT INTO kbq_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hanki Isona mago a'amofo agi'a Basemati'e, nemofo agi'a Reuelie. Hagi Reueli ne' mofavre nagamoza kva eri'za eri'naza naga'mokizmi zamagi'a, Nahati'e, Zera'e, Sama'e, Miza'e. Reueli naga Idomu mopafi kva eri'za eri'naza naga'mokizmi nezmageho'a Basemati'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso nenaro Oholibama ne' mofavre nagapinti kva eriza eri'namokizmi zamagi'e, Jalami'e, Kora'e. Oholibama'a Ana mofakino, Isonteti kase zamante'nea tagufa mofavremo'za kva eri'zana eri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","E'ina vahera Iso ne'mofavreraminki'za mago agi'a Idomu'e nehazankino agripinti fore hu'za kva eri'zana eri'naza vahe'mokizmi zamagi'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ama Seiri ne'mofavre Horati ne' ko'ma ana mopa nafa'a hu'zama mani'naza vahepinti fore hu'za kva eri'za eri'za mani'naza vahe zamagi'e, Lotani'ma, Sobali'ma, Zibeoni'ma, Ana'ma, ");
INSERT INTO kbq_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disoni'ma, Eseli'ma, Disani'ma hu'za zamagra kva eri'za eri'naza Horaet' vahe, Seiri ne' mofavre Idomu mopafi mani'naza kva vahe zamagi'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotani ne'mofavre agi'a Hori ene, Hemani'enene. Hanki Lotani nesaro'a Timna'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali ne'mofavre naga zamagi'a Alvani'ma, Manahati'ma, Ebali'ma, Sefo'ma, Onami'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeoni ne'mofavre nagara, Aia'ene, Ana'enene. Ana'a agra amuho tinkeria ka'ma mopafina keno eri fore hu'ne. Nefa Zibeoni donki kegava huno vano nehuno ana tinkeria ke fore hu'neane. ");
INSERT INTO kbq_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana mofavrezaga zamagi'a, Disoni'ma, Oholibama'e. Oholibama'a, Ana mofare. ");
INSERT INTO kbq_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disoni ne'mofavre zamagi'a Hemdani'ma, Esbani'ma, Itrani'ma Kerani'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseli ne'mofavre zamagi'a Bilhani'ma, Zavani'ma, Akani'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disani ne'mofavre zamagi'a Usike, Aranike. ");
INSERT INTO kbq_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horaeti vahepi kva eri'za eri'naza naga zamagi'a, Lotani'ma, Sobali'ma, Zibeoni'ma, Ana'ma, ");
INSERT INTO kbq_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disoni'ma, Ezeri'ma, Disani'e. Ama'i Horati vahepi fore hu'naza kva vahere. Seiri mopare nagate nofite hu'za mani'neza kva eri'za eri'naza vahe zamagi'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hanki ama'i Idomu mopafi kini vahe zamagi'e, Israeli ne' mofavre'mo'za kini vahe fore osu'naza knafi, Idomu moparera kini vahe fore hu'za mani'nazane. ");
INSERT INTO kbq_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela'a agra Beori nemofo kinia manino Idomua kegava kri'ne, rankuma'amofo agi'a Dinhabae. ");
INSERT INTO kbq_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela'ma nefrigeno'a, Zera nemofo Jobabu, Bozra kumate ne'mo Bela nona erino kinia mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabu'ma nefrigeno'a, Temati mopareti ne' Husamu kinia mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu'ma nefrigeno'a Bedati nemofo Hadadi kinia manino kegava hu'neankino, Midian vahe Moapu kumapi ha' huzamagatere'nea nekino, rankuma'amofo agi'a Avitie. ");
INSERT INTO kbq_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi'ma nefrigeno'a Samla, Masreka kumateti ne'mo, kinia manino kegava hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla'ma nefrigeno'a Sauli, Yufretis timofo tva'onte Rehoboti kumate ne'mo agri nona eri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauli'ma nefrigeno'a Bal-hanan Akbor nemofo kinimofo nona erino kegava hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bal-hanani nemofo Akbori'ma nefrigeno'a, Pao rankumateti ne'mo Hadari kuma'a erino kini mani'neane, Nenaro agi'a Mehetabelikino, Matreti mofa Mezahab negeho'e. ");
INSERT INTO kbq_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isompinti'ma fore hu'za kva eri'zama eneri'za nagate nofite'ma hu'za kuma ante'za mani'naza naga'zmire'ma kva huterema hu'naza vahe zamagi'a, Timna'ma, Alvani'ma, Jeteti'ma, ");
INSERT INTO kbq_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholiba'ma, Ela'ma, Pino'ma, ");
INSERT INTO kbq_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi'ma, Temani'ma, Mibzari'ma, ");
INSERT INTO kbq_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Megdili'ma, Irami'e. E'i zamagra Idomu kva nagare, Iso'a Idomu vahe nezmafa'e. Ana hu'neanki'za nonku'ma ante'za nemani'za mopare kva hutere hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Menina Jekopu'a agri nefa zoka mani'neno hu'nea mopare Kenani mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ama'i Jekopu naga nofimofo naneke. Josefe'a 17ni'a zagegafu nehuno, nehaza ne' mani'neno nefu'zane afutami kegava hu'ne. Bilhane, Zilpagizni nefa a'tremokizini mofavre'mozane kegava hu'naze. Josefe'a nefu'za havizama nehazankea erino nezmafana ome asami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Hagi Israeli'a (Jekopu'a) miko ne'mofavre'afintira, Josefena tusiza huno avesinte'ne. Na'ankure agra ravusefinka ante'neankino, agra avasese'ane kena tro huno antaninte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ana hige'za Josefe nefu'za, kazama nezmafa'ma tusiza huno agri'ma avesinentege'za nege'za, zamagra avesi nonte'za knare hu'za fru keaga huomi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Hagi mago kenagera Josefe'a ava'na keteno, afuhe'mokizmi ana avana kea zamasmige'za, zamagra mago'ene tusiza hu'za zamarimpa ahente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Josefe'a amanage huno zamasami'ne, Muse (plis) hurmantoanki ava'nama ke'noa zamofo nanekea antahiho, ");
INSERT INTO kbq_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","hozafi witi ananekunkeno nagri witimo'a oti fatgo higeno, tamagri witimo'za regagi'za, nagri witirera kepri hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Anante nefu'za amanage hu'za antahige'naze, tagrira tagaterenka kagra kini mani'za nehano. Tamage hunka kegava hurante'za nehano, nehu'za mago'ene zamasigu hunente'za, agri avana kene, ke'anena ontahi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Anante mago'ene ava'na keteno afuhe'i amanage huno zamasami'ne, Antahiho, mago'ene ava'nagoana, zagene, ikane, 11ni'a ofumo'za nagrite kepri hunante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Josefe'a anage huno nefane, afuhe'inena nezmasmigeno, nafa'amo'a amanage huno kesune, Kagra nankna ava'na negane? Nagrane, negrera'ene negafu'zanena tamage huta kagrite kepri hugahuno? ");
INSERT INTO kbq_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Agri afuhe'za amefi'a ke hunte'nazanagi, nefa'a hakare'a nanekea antahi antahifi atre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mago'zupa agri nefu'za, nezmafa afutami avre'za traza nehogu Sekemu vu'nazageno, ");
INSERT INTO kbq_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israeli'a amanage huno Josefena asami'ne, Negafu'za afuzaga zamavare'za Sekemu traza me'nerega ome zamante'za mani'nazanki ege'na, huganta'nena vuo. Higeno Josefe'a amanage huno kenona hu'ne, Nagra vugahue. ");
INSERT INTO kbq_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Higeno nefa'a amanage huno Josefena asmi'ne, Menina vunka negafuzane, afuzaganena knare hu'za mani'nafi ome ketenka, ete enka kea eme nasmio. Anage nehuno huntegeno Hebroni agupofinti vuno Sekemu uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Anantega ome hakeno vano nehigeno mago ne'mo anampi negeno anage huno antahige'ne, na'anku kagra nehakrane? ");
INSERT INTO kbq_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Higeno Josefe'a anage hu'ne, Nagra nafuhemokizmigu nehakroanki, muse (plis) hugantoanki inantega afu'zmia kegava hu'za mani'nafi nasmio? ");
INSERT INTO kbq_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Higeno ana ne'mo'a anage huno asamine, Amafinti atre'za vunaku nehu'za, Dotani vanune nehazage'na antahi'noe. Higeno Josefe'a zamage zamavaririno vuno afuhe'ina Dotani ome zamageno erifore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Hagi Josefe'a afete ne-eno eravao osu'nege'za afuhe'za nege'za, ahe frigahune hu'za kea retro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Zamagra zamagra ke hugantugama hu'za amanage hu'naze, ava'na kege nera antu e! ");
INSERT INTO kbq_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hanki menina enketa aheta keri kampi mate'vuta nevazita, amanage hugahune. Afi zagamo aheno ne'ne, nehuta avana ke'amo'a inankna hugahifi kesune! ");
INSERT INTO kbq_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ana hianagi Rubeni'a ana naneke nentahino, aza hunaku anage hu'ne, atrenketa ahe ofrisanune. ");
INSERT INTO kbq_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rubeni'a mago'ene amanage huno zamagrira zamasami'ne, Aheta korana eri oragi'sunanki, amima ka'ma kopima me'nea kerifi oheta avre vazisanune. Ana hanageno agra aza huno avreno nefa ome amisigu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Hanki Josefe'ma eno afuhe'inte'ma ehanatige'za, zamagra azeriza, knare avasese'ane za'za kena nefa'ma antaninte'neana zafi netre'za, ");
INSERT INTO kbq_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","zamagra azeri'za tinkeri kampi matevu atre'naze. Ana kerifina tina omnene. ");
INSERT INTO kbq_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ana hute'za, zamagra mani'ne'za ne'za nenaku nehu'za, kesga hu'za zamavua kazana, avazu hunte'za Ismaeli vahe'mo'za Giliatiti ne-eza, kemorizmifi gamune, fukinkna masave tusa masave kregefe'neane (bam) mana'nentake'za mere'ne eri'za Isipi zagore ome atrenaku e'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda'a amanage huno afuhe'mokizigura hu'ne, Neregnama aheta korama'a eri tagisuta nankna miza erigahune? ");
INSERT INTO kbq_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Agra tagri kora mani'negu ohesunanki, enketa Ismaeli vahete Josefena mizante atramneno. Hige'za nefu'za ana nanekere mago zamarimpa hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Anante mago'a Midiani vahe'mo'za, fenozama zagore'ma netre'za eneri'za nehaza vahe'mo'za anante neazageno, zamagra Josefena kerifinti avazuhu naga'atre'za Ismaeli vahete 20'a sekel silva zagore atre'naze. Ana hazage'za Josefena avre'za Isipi vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni'a keri avazare eno keana Josefe'a kerifi omani'negeno kukena'a sgane sagnu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Aganahe'inte agra uhanatino amanage hu'ne, Ana mofavre'a omani'ne. Hanki nagra inankna hugahue? ");
INSERT INTO kbq_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hige'za zamagra Josefe avasese'ane kena eri'za, ve meme ahe'za ana za'za kena'a korama'afi re'za ti'za hute'za, ");
INSERT INTO kbq_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","anante ana avasese'ane za'za kena, mago'amo'za eri'za nezmafante uhanatiza anage hu'naze. Amama kefore'ma hu'na kena muse (plis) hugantonanki, kagri negamofo za'za kenafi ko. ");
INSERT INTO kbq_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Hazageno keteno amanage hu'ne, Ama'i nagri ne'mofavremofo za'za kene. Afi zagagafamo aheno ne'ne, tamage huno Josefena amprino anitraga trogo hutre'negahie! ");
INSERT INTO kbq_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Anage nehuno Jekopu'a kukena'a braro bruru huno tanefa kateno kukena'are nefreno za'za kna ne'mofonkura huno zavira ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ana hige'za mika ne'mofa'amo'za, oti'za azeri avavasenaku hu'nazanagi, azeri vava sezankura ave'osi'ne. Hagi agra amanage hu'ne, Nenamofonku zavi netena fri'na fri vahe kumapi umanigahue. Nehuno nefa'a zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Hagi Midiani vahe'mo'za Isipi uhanati'za Josefena mizante atrazageno, Isipi ne' Fero avate kva ne' Potifa miza se'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mago zupa Juda'a afuhe'ina nezamatreno Adulami kumate ne' Hira'e nehaza ne'ene umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Juda'a anantega Kenani ne' Sua'e nehaza ne'mofo mofa keteno, a' erino anteno mase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana higeno amu'ene huno ne' kasentegeno, agra Eri'e huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Anante mago'ene amu'ene huno ne' kasenteno, Onani'e huno agi'a ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ana a'mo'a mago'ene ne' kasenteno Sela'e huno agi'a ante'ne. Juda'a Kezipi mani'negeno nenaro'a ne'mofavrea kase ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Hanki Juda'a agonesa ne'mofavre'a Erina mago a' avre ami'ne. Ana a'mofo agi'a Tema'e. ");
INSERT INTO kbq_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ana hianagi Judana agonesa mofavre'a Eri'a Ra Anumza'mofo avufi havi avu'avaza higeno, Ra Anumzamo'a ahe fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Juda'a amanage huno Onanina asami'ne, Nempuka'amofo kento ate vunka, nefu a' eneriankna avu'ava hunka, negafu a' erigeno, negafu mofavre kasenteno. ");
INSERT INTO kbq_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Hianagi Onani'a antahi'ne, kento a'mo kasentesia mofavrea agri mofavre omanigahiankino, nempu'amofo a' ene nemaseno'a avufga rina, nefu mofavre antemi'zanku mopafi atre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","E'inama agra hiazanku Ra Anumzamo'a musena osuno, ahe fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Anante Juda'a nenofero Temana anage huno asmi'ne, Negafa nontega vunka kento a' umani'negeno, ne'niamo Sela'a ra hute'na'e. Higeno Tema'a vuno nefa nompi umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mago'a zagegafu evutegeno Sua mofa, Juda nenaro'a frigeno, zamasunku hu'za zavi atazageno ana kna vagaretegeno, Juda'a sipisipi azoka neharerega Timna kumate agrane, arone'a Adulamu kumateti ne' Hira'ene vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mago'a vahe'mo'za Temana ome asami'za, Konkeno negnofero'a sipisipi'a azoka hareku Timna kumate evu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Hazageno ana a'mo kento kukena hate netreno amne kukena huno, avugosa refineteno, Enaim kuma'mofo kasante Timna vu kante emani'neno, amanage huno agesa antahine, Sela'a hago ra hu'neanagi, a' ka'e huno navre omi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Hagi Juda'ma ana a'ma eme negeno'a, monko a' mani'ne huno agesa antahi'ne. Na'ankure ana a'mo'a avugosa refiteno mani'negeno keso'e osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Agra kana atreno ana a'mofonte vugantuteno amanage hu'ne, Menina knare kagranena umasegahuo? Agra mofavre'amofo are huno ontahi'ne. Tema'a amanage huno antahige'ne, Na'a namitenka nagra'nena umasegahane? ");
INSERT INTO kbq_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Higeno agra kenona'a huno, Afuzaga ni'afinti mago ve meme avrentegantegahue huno asmi'ne. Ana a'mo'a amanage huno asmi'ne, Knare mago kamente'zana avame'za naminanke'na azeri nenugenka, henka'a avrente nantegahampi? ");
INSERT INTO kbq_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Higeno ana ne'mo'a amanage hu'ne. Avame'zana nagra na'a kamigahue? Higeno ana a'mo'a anage hu'ne, rinine, knankempi kvasese nofi'ene, kazampima eri'nana azompa ka'ane namigahane. Higeno ana miko'za nemino ome anteno masegeno agriteti amu'ene hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Anante otino vuno avugosafi refite'neaza eri netreno, kento kukena omeri hankre'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda'a rone'a Adulami ne'te, kasefa ve meme avre amigeno ana a'ma ami'neaza azampinti erinogu ome hakeana ana ara onke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Agra ana a'mofo kumate vahe zamantahigeno, Havi anumzamofo mono nompima monko a'ma Enaimima vu kantegama nemania ara ina'ne? Hige'za zamagra amanage hu'naze, Havi anumzamofo mono nompina, monko ara amafina omani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ana ne'mo'a ete Judante vuno, amanage ome hu'ne, ana ara hake'na erifore osuge'za, ana kumapi vahe'mo'za amafina monko ara omani'ne hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Anante Juda'a amanage hu'ne, Aru vahe'mo'za tagiza resagi atregeno ana a'mo erino. Hago ama'i ve meme avre kamugenka, ana ara ome hakenka eri fore osane. ");
INSERT INTO kbq_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Henka 3'a ikana evutegeno, Judana amanage hu'za asami'naze, neganofero Tema'a savri huno vano nehuno mofavre amu'ene hu'ne. Hazageno Juda'a anage hu'ne, Avre fegi atreta ana ara tevefi kre kasegeho! ");
INSERT INTO kbq_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ana ara avazu hu'za fegi'a atirmizageno, ana a'mo'a huno, Nagrama namu'ene hu'noana ama zamofo nefanteti mofavrea eriri'noe. Nehuno ana zana zamige'za eri'za nenoferonte vu'za anage hu'za ome asami'naze, muse (plis) hugantoanki ko, ama rinine, anankempi avasese'zane, azompa aza suzane? ");
INSERT INTO kbq_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Higeno Juda'a ana zantmima keno antahino'ma nehuno'a amanage hu'ne, Tema'a nagrira nagatereno knare avu'avaza hu'ne. Haviza hu'na nagra nenamofo Selana avre omugeno anteno omase'ne. Nehuno Juda'a ete mago'ene ana a'enena uomase'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ana a'mo mofavre anteku nehigeno, keana kugave'za rimpafina mani'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Anante mofavre kasenentegeno mago'mo azana ante kamategeno, aza huno mofavre kasemi a'mo'a koranke osi nofi azante kinenteno, amanage hu'ne, Ama mofavremo koteno e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hianagi eteno azana anamagi agu'ategeno, ete mago'mo atiramine. Ana a'mo'a anage hu'ne, Inankna hunka kagra anafe hunka agaterenka ane, nehuno agi'a Peresi'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hanki amefiga'a nefu osi koranke nofi'ma azante kinte'nemo atiramigeno, agi'a Zela'e huno antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Josefena avre'za Isipi mopare vazageno, Fero avate vugota huno kegava nehia ne' Potifa'a Ismael vahe'mo'za avre'za vu'naza vahepinti miza huno avrente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ra Anumzamo'a Josefe'ene mani'negeno, maka eri'zama'amo'a knare'zanke hu'ne. Josefe'a ozafa'amofo nompi Isipi mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ozafa'amo'ma keana Ra Anumzamo'a Josefe'ene mani'negeno, eri'za kama'amo'a agri azantera knare zanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ana higeno, ozafa'amo'a Josefena antahimino, avate eri'za ne' azeri oti'ne. Ana nehuno noma'ane maka'zama'a Josefe azampi antegeno kegava krinte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Isipi ne'mo'ma ana'ma hianknareti agafa huno Josefe'ma noma'afi mani'negu huno Potifana mika nompi zane, fegi'a hozafi zanena Ra Anumzamo'a asomu hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Maka'zana Potifa'a Josefe azampi antegeno kegava krigeno, maka zankura agesa ontahi'neanki, kave'ma nesia zankuke hu'ne. Hagi Josefena agi'avugosamo'ene, agia azamo'enene, avufgamo'enena knare'za huno soe zanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Anazama nehifina ozafa'amofo nenaro'a Josefena kesane nehuno anage hu'ne, Enka nagrane emaso. ");
INSERT INTO kbq_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hianagi agra ana kegura i'o nehuno, ozafa'amofo nenarona anage huno asami'ne, Antahio, nagrama ama nompima mani'nogeno'a ozafanimo'a maka'zankura agesa nontahie. Maka'zama ante'nea zana nagri nazampi kegava kri'nuegu ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mago agateresa nera ama nompina omani'ne, nagrake mani'noankino, mikazana nagri nazampi anteno kegava huo hu'neanagi, kagri kaziga antenka mase huno hu izo huonantene. Na'ankure kagra nenaroga mani'nane. Inankna hu'na nagra tusi'a kefo'zana erifore hu'na kumira Anumzamofo avufina hugahue? ");
INSERT INTO kbq_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ana a'mo'ma maka knafima Josefenku'ma masesu'e huge, erava'o huoma nehigeno'a, ke'a antahi omi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hagi mago zupa Josefe'a eri'za erinaku nompi marerigeno, ruga'a eri'za vahera ana nompina omani'nageno keteno, ");
INSERT INTO kbq_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ozafa'amofo nenaro'a nakre ku'are avazu nehuno anage hu'ne, Nagrane emaso, higeno ana nakre ku'a azampi zafi netreno, freno megi'a atiramino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ozafa'amofo nenaro'ma keama Josefe'ma nakreku'ama azampi atreno freno fegi'a atiramigeno'a, ");
INSERT INTO kbq_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ana a'mo'a noma'afi eri'za e'neriza vahe ke hige'za eme atru hazageno anage hu'ne, Keho, Hibru ne'ma avrenoma eme ante'nea ne'mo, nagri zokago renanteku ege'na krafa hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Antahige'na ranke hu'na krafama nehuana, nakre ku'a avateti zafitreno freno fegi'a vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Anage huteno ana nakre ku'a ana a'mo'a tavaoma'are anteno mani'negeno neve'a nontega e'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Anante Potifa'a egeno, nenaro'a amanage huno asmi'ne, Miza e'ori kazokazo Hibru eri'za ne' avrenka eme tami'nana ne'mo, nagrite eno zokago renantenaku nehige'na, ");
INSERT INTO kbq_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","rankema hu'na krafage hugeno'a, nakre ku'a atreno atiramino fegi'a freno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifa nenaro'ma nevema asamino, miza e'ori kazokzo eri'za ne'kamo Josefe anahura nagrira hu'ne, hiankemo'a Potifa rimpamo'a teve re'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ana higeno Josefena ozafa'amo'a avreno kini ne'mo'ma eri'za vahe'ama kinama hunezamantea kina nompi ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ana hianagi Ra Anumzamo'a Josefe'ene mani'neno avesinteno azeri so'e nehigeno, kina nonte vugota hu'nea ne'mo'ma keana knare'za hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kina nonte'ma vugote'nea ne'mo'a Josefena maka'a kina vahe'mokizmire kegava krinogu kva azeri oti'ne. Hagi inankna zama anampima haniazana agri azampi ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kina nonte'ma vugote'nea ne'mo'ma Josefe azampima ante'nea zankura agesa ontahine. Na'ankure Ra Anumzamo'a agrane mani'negu huno, maka'zama Josefe'ma hiazana, aza nehigeno knare'zanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mago'a kna evutegeno anante Isipi kini ne'mofo ti tafente'ene breti kre'zante vugota huna'a ne'tremoke, ra zani Isipi kinimofona rimpa eri haviza hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fero'a tare vugotena'a eri'za netrena, kinimofo tintfente'ene breti kre'zante vugota hu'na'a ne'tremokiznia tusi'a rimpa ahezanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ana netrena kinimofo avate kva hunente'nea ne' nompi, Josefe mani'nefi magopi kina ome huznantene. ");
INSERT INTO kbq_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Rankva ne'mo'a, Josefe kegava huznante'nogu ome zanantegeno, agra kegava kriznantegeke mago'a zaza kna kinafina mani'na'e. ");
INSERT INTO kbq_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Hagi Isipi kinimofo tinkapure azeri nentea ne'ene breti negrea ne'enena kinafi mani'neke, tarega'moke rurerure ava'na ketere hu'na'e. Hianagi ana ava'na zanimofo agu agesamo'a ru kante rugante vutere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Nanterampi Josefe eno eme zanageana, zanagra zanasu zampi mani'nakeno zanage'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Fero eri'za netre'moke kva'amofo kina nompi mani'nakeno zanantahigeno, Na'a higeta menina tanasu'zampina mani'na'e? ");
INSERT INTO kbq_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Higeno zanagra kenona anage hu'ne asami'na'e. Tagrama ava'na ke'noa ava'namofo agu'agesama huama huno tasami vahera magore huno omani'ne. Hakeno Josefe'a ana kenona anage huno zanasami'ne, Anumzamo Agrake ava'na ketani'a eri ama hugahianki ava'nama kena'a zamofo naneke nasami'o. ");
INSERT INTO kbq_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kini ne'mofo tinkapure vugote'nea ne'mo'ma agrama ke'nea ava'na kea anage huno Josefena asmi'ne, Nagrama ava'nafima koana, navuga mago wain nofi me'ne, ");
INSERT INTO kbq_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ana waini nofitera 3'a azanku'na me'neankino, ani'na eri mareno amosrea aheno, raga'a reherafigeno knare'za huno afu arente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Hagi Fero kapumo'a nazampi me'nege'na, waini raga tagi'na eri rati'na Fero kapufi nente'na, ana kapua Fero azampi eri'na ome ante'noe. ");
INSERT INTO kbq_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Higeno Josefe'a anage huno asami'ne, Ava'nama ke'nana zamofo agu'agesamo'a amana hu'ne, 3'a azankunamo'a 3'a kna huvame huno me'neankino, ");
INSERT INTO kbq_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","3'a knama evutesigeno'a, Fero'a ete erizanka'are kavrentenkenka ko'ma nehanaza hunka Fero azampi ti kapu'a erinka ome antegahane. ");
INSERT INTO kbq_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hianagi knare'ma hunka umanisunka, muse hugantoanki nagrikura kagesa antahinenaminka, nagri nagenkea Ferona asmigeno ama'i kina nompintira navre fegi'a natreno. ");
INSERT INTO kbq_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Na'ankure nagrira musufa ase'za, Hibru vahe mopafinti navre'za eme nante'nage'na, amafima ema mani'nofina magore hu'na antahi'na kena osu'noa zante navre'za eme kina hunante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ana zanke huno kini ne'mofo bretima vugoteno negrea ne'mo'a, Josefe'ma knare'ma huno kini ne'mofo waini kapure'ma e'neria ne'mofo ava'na kema rukrahe humigeno nentahino'a, anage huno Josefena asmi'ne, Nagranena ana zanke hu'na ava'na koana, 3'a eka'eka kupi bretia zogirinte'naza nanunte me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ana ekaeka kupina ruzahu ruzahu bretirami Fero suza nanunte me'nege'za namamo'za eme nenazage'na ke'noe. ");
INSERT INTO kbq_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Anage higeno Josefe'a kenona anage huno asmi'ne, Ava'nama kanazamofo agu'agesamo'a amana hu'ne, 3'a eka eka kumo'a, 3'a zagegna hu avame hu'neankino, ");
INSERT INTO kbq_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","3'a zagegnama agteresigeno'a, Fero'a kazerisga huno kagena rukafriteno zafare hantigantesige'za, namamo'za kavufga negahaze. ");
INSERT INTO kbq_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Hagi henka 3'a zagekna evutegeno, Feroma kasente'nea kna egeno maka eri'za vahe'amokizmia ra ne'za kre nezmanteno, vugoteno waini ti kapu'a erisga nemia ne'ene, bretima kre nentea ne'ene waini ti kapuama erino nemia ne'enena, ranra eri'za vahe'amofo zamavure, zanavre ama' hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ferona tinkapure vugoteno erisga hunentea nera, eri'zama'afi avrentegeno agra Ferona kapu'a azampi antente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Hianagi breti kre'zante vugota hu'nea nera, Josefe'ma ava'na kezanima zanasmi'nea kante ante'za zafare ahe'za hanti'naze. ");
INSERT INTO kbq_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Hianagi kinimofo kapu'are vugota hu'nea ne'mo'a Josefena antahi omino, agekani ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hagi tare zagegafu agateretegeno Fero'a ava'na keana, Naeli timofo ankenare oti'negeno, ");
INSERT INTO kbq_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ame huno Naeli timpintira 7ni'a masavenke huno afovage Bulimakao afu'tamimo'za hanati'za, tinkenafinti traza tragahu'za nenazageno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Anante'ma keana, ete 7ni'a zaferinage huno, vahe'mo kesane huga osu'nea Bulimakao afuzaga Naeli timpinti ehanati'za, tinkenafi ko'ma emani'naza bulimakane magopi oti'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Haviza hu'za zaferinage hu'naza Bulimakao afumo'za, 7ni'a knare'ma hu'za afovage'ma hu'naza Bulimakao afutamina zamahe'za nehana hu'naze. Anazama keteno'a Fero'a avu'ma mase'nefintira oti'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ete mago'ene Fero'a mase'neno ava'nama keana, mago witi ramparera ome ahente eme ahente huno 7ni'a ranra nenage huno knare hu'nea witi me'negeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hanki ete henkama hanatia 7ni'a witi raga'amo'a osi higeno, zage hanatitegati ea zaho'mo azeri hagege higeno, nena'a fore hu so'e osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Hagi osi witi ragamo'za 7ni'a ranra witi raga rente'neana asgahu nevazizageno ke'ne. Fero'a otino keana higeno ava'na koe huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Hagi nanterame otino antahintahi hakare nehuno, vahe huzmantege'za kasnampa vahezagane antahi'zane vahezagama Isipima nemaniza vahe ome zamasamige'za eme atru hu'naze. Fero'a ava'na ke'ama zamasmiana mago'mo'a eriama huno Ferona asamigara osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hagi anante vugota huno Fero kapure kva hunentea ne'mo'a amanage huno Ferona asami'ne, Ko'ma nagrama ufre'noa knazamofo nanekea meni huama hu'na kasamigahue. ");
INSERT INTO kbq_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Feroga eri'za vahe ka'a karimpa aherantenka, kavate kva ne'mofo nompi, nagri'ene vugota huno breti negrea ne'ene kina hurante'nane. ");
INSERT INTO kbq_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Magoke kerageke tarega'mota ava'na ke'noe. Agrane nagra'ene, ava'na ti'afina taregamota rurerure av'ana ke'noankino, agu'agesa'a metere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hibru nehazana magora anampina tagra'enena mani'neankino, kinimofo avate'ma kvama nehaza sondia vahe'mokizmi kva ne'mofo eri'za ne'mo kina hu'neno, ava'na keti'a agri asamukeno huama huno ana avana ketiamofo agu'agesa'a tasami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hagi huama'ma huno tasmi'nea kante anteno nagrira ete eri'zaniafi navrenenteno, agrira zafare aheno hanti'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Hagi Fero'a huzmantege'za Josefena mopa agu'a kina nompi mani'nege'za ame hu'za ome avre'za ageno, agi azoka hareno kena'a eri vasiteno, Fero avuga uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fero'a amanage huno Josefena asami'ne, Nagrama ke'noa ava'namofo agafa'a, magore huno eriama huno nasmiga vahera omanitfa hu'ne. Hagi kagri kagenke nasami'za, ava'na kea eriama nehane hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Higeno Josefe'a anage huno Ferona asami'ne, Nagra'a huamara osugahuanki, Anumzamo agrake Feroga ana avana keka'amofo agu'agesa'a eri ama huno kasamigahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nehigeno Fero'a anage huno Josefena asami'ne, Ava'nama ke'nofina, Naeli timofo ankenare, ");
INSERT INTO kbq_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","oti'nena negogeno, masavenke huno ra avufgane bulimakaona 7ni'a Naeli timpinti hanati'za traza nenazage'na ke'noe. ");
INSERT INTO kbq_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Negogeno ana timpinti mago'ene 7ni'a zaferinage huno kesane osuga hu'nea bulimakao afutamina, magore hu'na Isipi mopafina kora onke'noa afuzaga ke'noe. ");
INSERT INTO kbq_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ana zaferinage huno asane huga osu'nea bulimakao afu'zagamo'za koteno'ma 7ni'a masavenke avufgane bulimakao afu'tmina zamahe'za ne'naze. ");
INSERT INTO kbq_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Hianagi ana afu'zagamo'za kote'za mani'naza kanteke vahe'mofo asane osu'are mani'nazage'na nege'na, navu'ma mase'nofintira oti'noe. ");
INSERT INTO kbq_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Hagi ete mago'ane mase'nena mago ava'na koana, mago witimofo rampa'arera, 7ni'a ranra nena raga'a ome ahente eme ahente hu'negena, ");
INSERT INTO kbq_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","negogeno henka ete 7ni'a osasi rampa'ane witi hanatiana hagege hugege higeno, zage hanatitegati ea amuho'ane zaho'mo temagigeno hanati haviza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ana osi rampane witimo 7ni'a ranra rampamo nenage huno ahente'nea witi rampa'a, aga asgahu nakri'ne. Hige'na ana ava'nagea kasnampa vahe'zaga zamasmuanagi mago'mo'a huama huno onasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Josefe'a amanage huno Ferona asami'ne, Feroga tare ava'nama ke'nana zamo'a magoke kampi vu'ne, Anumzamo hania zamofo eri ama huno Agra'a Feroga eri kaveri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Hagi 7ni'a knare zamavufagane bulimakamo'za 7ni'a kafu hu avame hu'naze. Hanki 7 ni'a nena'ane witi rampamo'za 7ni'a kafu hu avame hu'nazankino, ana tarega ava'na kenamo'a magoke agu'agesage me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hagi 7ni'a knare osu zaferinage Bulimakaomozama marerinagenka ke'nanana, 7ni'a kafue. Hanki 7ni'a osasi huno hagege hu'nea witi ramparamima zage hanatitegati amuhonentake zaho'moma eme temagigenka ke'nanana, e'i 7ni'a kafufina tusi'a agatonto kna fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Maka'zana meni fore hania zamofonku nagra huama huna Feroga negasamuankino, ama anazana fore'ma hania zamofo Anumzamo'a Agra'a eri ama huno Feroga kaveri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hagi 7ni'a kafumofo agu'afina, maka Isipi mopafina, ne'zamo'a fore huhakare hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hianagi 7ni'a kafumofo agu'afina tusi'a agatonto kna egahiankino, ana agatonto zamo'a Isipi mopafina kave'ma fore'ma hu'nea kna osanige'za, rama'a ne'zama fore'ma hu'nea kafuraminkura vahe'mo'za zamage kanigahaze. Hagi miko'zana ahe fanane hanigeno, mopamo'a haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ana mopafina kave'ma fore nehiaza osuno, agatereno tusi'a agate'za fore hanige'za, ko'ma knare kafuma mani'naza zankura zamagesa ontahigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ete mago'ene Anumzamo'ma ana ava'na ke Ferogama tare zupa kasmi'neana amanahu hu'ne, Anumzamo hanigeno ame huno anazana fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hanki Feroga mago knare antahi'zane, agu'agesane ne' azeri otigeno Isipi mopa kegava hino. ");
INSERT INTO kbq_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Feroga mago'a vahe zamazeri otige'za, 7ni'a kafufina kegava hu'ne'za, ne'zamo'ma hakare hania knafina ne'zana eri'za 5fu'a kevu ante'ne'za anampinti mago kevua refko hu'za Isipi mopafina mago'zahu hu'za ne'zana eritru hiho. ");
INSERT INTO kbq_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ne'zamo'ma hakare hania kafufina huge'za, maka'a ne'zana nompi eri tru hiho. Ferogama kegava hu'nana ranra kumate witi ragane ne'zanena eritru hute'za, vahe'mo'za kegava hiho. ");
INSERT INTO kbq_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Isipi mopafina 7ni'a kafufima agatontoma fore'ma hania kna'afina, e'i anama eritru hania nezamo zamaza hanige'za, zamagakura hu'za ama ana mopafina ofrigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hanki Fero'ene eri'za vahe'amozama ana nanekema antahi'zana knare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Fero'a eri'za naga'a zamasmino, Amanahukna huno, Anumzamofo Avamu'ene nera magora hakreta kegahuno? ");
INSERT INTO kbq_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Anante Fero'a anage huno Josefena asmi'ne, Anumzamo ana maka'zana kagri kasmi'negu, magora knare antahi'zane vahera omani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kagra nagri nona kegava hunenankena, ran tratera nagrake'za manisga hugantegahuanki, kema hanana kante vahenimo'za antahi kami'za kesga hugantegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Anage huteno Fero'a mago'ane anage huno Josefena asami'ne, Nagra mika Isipi mopa kegava huogu kva kazeri otue. ");
INSERT INTO kbq_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Anage nehuno Fero'a azampinti agra'a rinia zafino Josefe azampi vazinenteno, knare kasefa kena eri vasinenteno, anankempi golire ananke nofi hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fero amagenare kva ne'mofo karisifi avrentegeno vano nehige'za, agri avufi kezati'za husga hunente'za, agrite zamarena re'naze! Nehuno maka Isipi mopa agri kvafi ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mago'ene, Fero'a Josefena anage huno asmi'ne, Nagra Fero'na huankino kagripinti'ma kema e'orinesuno'a, mago'mo'e huno azana erisga huno mago'zana huge, maka Isipi mopafina aga rentegera osugahie. ");
INSERT INTO kbq_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nehuno Josefenkura Zafenat-panea'e huno Fero'a agi'a antemine. Ana nehuno Oni kumate pristi ne' Potifera mofa Asenati ara avremine. Higeno Josefe'a agra Isipi mopa agu'afi vano nehige'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Hagi Josefe'a 30'a Zagegafu huteno, Isipi kini ne' Ferontera eri'zana eri'ne. Ana huteno Josefe'a Fero enema mani'neretira atreno maka Isipi mopafina vano hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Hagi 7ni'a zagegafumofo agu'afina ne'zamo'a ana mopafina ampore'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hutegeno maka ne'zama 7ni'a kafufi Isipi mopafi fore'ma hiana eritru huno ranra kumapima me'nea nontamimpi ante'ne. Maka'a hozafinti ne'zama eri'za e'nazana, mago mago kumate'ma me'nea nompi eri atru hutere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ana nehuno Josefe'a witi rgama eritru hu'neana, hagerinkenafi kasepankna huno zogi atru higeno, mago'ene sigerirera erinte'za hantigara osu'naze. Na'ankure nompina aviteno herafi ramigeno anara hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Agate kna fore osu'negeno, tare ne'mofavre Josefena fore humi'ne. Oni kumate pristi ne' Potifera mofa Asenati ana mofavrerarena kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Hagi Josefe'a zage ne'mofavre'amofo agi'a, Manase'e huno antenemino anage hu'ne, na'ankure knazama eri'noane, nenfa nonku'enena Anumzamo'a eri nagekani nante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Anantera mago ne'mofavre nenteno agi'a, Efraemi'e huno antenemino anage hu'ne, natazampi mani'noa mopafi Anumzamo nazeri raga renante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Hagi 7ni'a kafumofo agu'afi Isipi mopafima ne'zamo'ma ampomare'nereti vagaregeno, ");
INSERT INTO kbq_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Josefe'ma ke hu'nere, 7ni'a kafumofo agu'afina agate kna egeno miko'a mopa kaziga aga'zanku huva re'neanagi, Isipi mopamofo agu'afina ne'zana me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tusi zamagazanku maka Isipi mopafina nehu'za, Ferontega nezanku zavike hazageno, Fero'a maka Isipi vahera zamasmino, Josefente vinkeno'ma na'ane nanekema tmasmisiana kema haniaza hiho. ");
INSERT INTO kbq_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Maka kaziga mopa kagi'afina zamagaku hazageno, Josefe'a mika feno nona anagige'za Isipi vahe'mo'za anampinti ne'zana miza se'naze. Ana nehigeno tusi'a agate'zamo miko Isipi mopafina fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Zamagazamo maka kaziga mopafina hige'ze maka kaziga mopareti vahe'mo'za, Isipiti witi ne'zazmia Josefenteti eme miza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jekopu'ma Isipi moparega witi me'ne hazankema nentahino'a, ne'mofavre naga'a anage huno zamasmi'ne, Na'a higeta ovufi avufina nehaze? ");
INSERT INTO kbq_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipi mopafina witi ne'zana me'ne hazage'na antahuanki, ofrita manisunema hanuta vuta ana moparegati ne'zana ome mizaseta eho. ");
INSERT INTO kbq_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hige'za Josefena 10ni'a afuhe'za witi miza senaku Isipi urami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Hianagi Jekopu'a Josefe negna Benzameni'ma hazenke erizanku koro nehuno, atregeno afuhe'zanena ovu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Hagi zamaga'zamo' a ana zanke Kenani mopafinena hige'za Israeli amohe'za ke hiaza hu'za witi ne'za miza senaku ruga'a vahe'ene urami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Hagi Josefe'a ana mopafina gavana manino kegava kri'nege'za agritetike maka ana mopafi vahe'mo'za ne'zana eme miza se'naze. Hagi Josefe afuhe'za agrite e'za zamarena re'za kepri mopafi hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Josefe'a afuhe'i zamavugosafi nezmageno, onke vahekna nehuno hanave'ane ke huzmanteno anage hu'ne, tamagra igati e'naze? Hige'za zamagra anage hu'naze, Kenani moparegati ne'za miza senaku e'none. ");
INSERT INTO kbq_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josefe'a afuhe'ina zamageni' hianagi, zamagra agrira keni' osu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Josefe'a ko'ma afuhe'inte ava'na kezamte'nea agesa nentahino anage huno zamasmi'ne, Tamagra mopati afureta kenaku e'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Hianagi zamagra anage hu'naze, a'o, rantimoka kagri eri'za vahe'mota ne'za miza senaku e'none. ");
INSERT INTO kbq_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tagra magoke ne'mofo mofavre nagakita, tamage vahe mani'none. Hagi eri'za nagaka'mota tagra mopa afure' vahera ome'none. ");
INSERT INTO kbq_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Anage hazanagi ke'zmi rezmanteno agra anage hu'ne, A'o, kegava osu'nona mopati afureta kenaku tamagra e'naze! ");
INSERT INTO kbq_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Hige'za zamagra anage hu'za asami'naze, Eri'za vahe'kamota maka 12fu'a vahekita magoke ne'mofo ne'mofavre naga mani'none. Hanki amitenamo'a Kenani mopare nerfa'ene manigeno, magotimo'a hago fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hianagi Josefe'a amanage huno rentase hu'ne, Tamagra mopati afure vahere hu'na neramasamue. ");
INSERT INTO kbq_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tamagrama tamage nehaze hunama nagrama hanuana, amanahu hugahaze. Fero avufi hanave'ane ke huankita, ama kumara atreta ovu'nesageno, neramagna amare' e'nige'na kete'na, tamatrenugeta mopatamirega vugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hagi mago'mofo huntenkeno vuno neramagnana ome avreno eno. Hanki ruga'amota kinafi mani'nesageno, tamagenoka hugetama hunazana, tamagu'areti tamage hunafi kaneno. Havigema hanuta Fero avufina, tamage tamagra mopati afureta kenaku enaza vahere hu'na hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ana nagara maka kina nompi 3'a zagegnafi zamavarentene. ");
INSERT INTO kbq_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Hagi namba 3ma hia zagegnarera Josefe'a amanage huno zamasmi'ne, Nagra Anumzamofonku koro nehugu amana'ma hanazana manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Hagi tamage vahe'ma mani'nesuta, atrenkeno mago neramafu kina huno mani'nena, ruga'amotma witi ne'zantmia erita zamaga zanku'ma nehaza naga tamirega viho. ");
INSERT INTO kbq_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Hianagi neramagnana ome avreta nagrite ehanatiho. Anama nehanageno ketamimo'a tamagesesigeta ofrigahaze. Hige'za kema zamasmiaza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Zamagra zamagra amanage hu'naze, tamage neragnana haviza hunte'none. Na'ankure negonkeno agra o'e nehigeta antahiomuna nona'a ana knazamo'a tagritera fore nehie. ");
INSERT INTO kbq_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni'a ke nona'a amanage huno zamasami'ne, Nagra ontamasami'nofi, ana mofavrea azeri havizana osiho nehugeta ke'nia antahi onami'naza nona'a, menina agri'ma ahe fri'nona zamofo nona'a knazana enerune. ");
INSERT INTO kbq_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zamagrama antahi'zana Josefe'a ketia nontahie hu'za hu'nazanagi, agra antahine. Na'ankure Josefema kema rekrahe humi vahe'mo'a amu'nozamifi mani'neno, nanekea akrehe huno zamasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josefe'a zamatreno vuno zavi ome atete'no, eno eme kema hunezmino'a, eri'za vahe'a zamasmige'za, Simeonina azeri'za negage'za azante nofi anakinte'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Huteno Josefe'a hige'za witi ne'zana beki ku'zmifi eriri nezmante'za, zagozmia ana zanke hu'za beki kuzmifi eriri nezamante'za, kantega nevu'za nemema vanaza kave'ene eriri zamante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hige'za donki afu'zmimofo agumpi witi ne'zama eririzmantaza erinte'za anantetira atre'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kantega umsenaku hazarega mago'mo donki afu'amofo ne'zama aminaku beki ku'a eriheta huno keana, beki ku'amofo avazare zago'a me'negeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Afuhe'igizmia anage huno zamasami'ne, Beki ku'niafi zagonia eriri nante'nazanki keho. Hige'za zamahirahi nerege'za koro nehu'za rukre hu'za ovufi avufi nehu'za, anage hu'naze, Naza ama zana Anumzamo'a hunerante? ");
INSERT INTO kbq_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hagi zamagrama Kenani mopare unehanati'za, maka'zama fore huzmi'nea nanekea nezmafa Jekopuna amanage hu'za asmi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ana nera, ana mopa kegava kri'nea ra nekino, hanave kefintike kea huno, tamagra mopati afureta ke vahe e'naze hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Hianagi tagra anage huta asami'none, Tagra tamage vahe mani'nonanki, afure vahera omani'none huta asami'none. ");
INSERT INTO kbq_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tagra 12fu'a kogna nagakita, magoke ne'mofo mofavre nagare. Magotimo'a omanigeno, neragana'a nerafa'ene menina Kenani moparega mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Anage hunkeno ana mopama kegava kri'nea ra ne'mo'a amanage huno tasami'ne, Mago nermafuna nagrite netretma, witi ne'za eneritma zamagaku'ma nehaza nagatamirega viho. E'inama hanage'na, tamage vahe mani'naze hu'na nagra antahigahue. ");
INSERT INTO kbq_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hagi nagnatamimofona avreta enkena negena, tamagra tamage huta mopa afureta ke vahera omani'naze hu'na antahi neramina, neramafuna avreraminena ama mopafina amne vute'ete huta ne'zana miza nehuta zagorera atregahaze huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Anage hute'za beki ku'zmifinti ne'zama eri'za e'naza herafinaku nehu'za kazana ana kognamokizmi zago'zmia kona anakinare beki ku'zmifi metere hu'negeno, ana zagoma nezmafa'enema nege'za tusi koro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nezmafa Jekopu'a amanage huno zamasmi'ne, Tamagra mofavre onte ne' kna hunenantaze. Josefe fanane higeno, Simeon fanane higeno, Benzamenina ana zanke huta avregahaze, ana maka zamo'a ha' renante. ");
INSERT INTO kbq_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubeni'a nefana anage huno asami'ne, Benzamenima avre'na omesugenka tare ne'mofavreni'a zanahe frigahananki, nagri nazampi antege'na avre'na vute'na avre'na aneno. ");
INSERT INTO kbq_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nehigeno Jekopu'a anage hu'ne, Nagri nenamofo'a kagranena uoramigahie. Nankure nefu'a frigeno, agrake mani'ne. Kama nevnageno kantegama hazenkema omeri'nige'na, efe nazokamate'nea vahera nasuzamo nahefri'na fri'na fri vahe kumapi (Seol) umanigahue. ");
INSERT INTO kbq_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ana knafina Kenani mopafina tusi zamagatontoza fore huno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Isipi mopareti'ma mizase'za eri'za e'naza ne'zama nehana hazageno, nezmafa'a amanage huno zamasmi'ne, Ete mago'ene vuta ne'zana ome mizaseho. ");
INSERT INTO kbq_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Hianagi Juda'a amanage huno nafa'amofona asami'ne, Ana kva ne'mo'a hankavenentake ke huranteno amanage hu'ne. Tamagra nagna tamimofoma avreta ome sanage'na tamavufina ontamagegosue huno higeta e'none. ");
INSERT INTO kbq_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kagrama naganatima atresankeno'ma tagra'enema esaniana, tagra uramita nezanka'a ome miza huta egahune. ");
INSERT INTO kbq_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Hianagi kagrama Benzamenima atresnankeno'ma tagra'nema omesniana tagra ovugahune. Na'ankure ana Isipi kva ne'mo'a amanage huno tasami'ne, Tamagna timimofoma avretama omesazana nagri navumo'a ontamagegahie hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Anage nehazageno Jekopu'a (Israeli) amanage hu'ne, Tamagra nahigeta ana kva nera magora naganatia mani'ne huta asmi'nageno anankea hu'ne? E'ina'ma hu'naza zamo'a nagrira tusi'a zampi nazeri haviza haze. ");
INSERT INTO kbq_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Hianagi zamagra asami'za, Ana kva ne'mo'a ana maka'mota tantahige tantahige huno tagriku'ene, vahetigu'ene, tantahigeno amanage hu'ne, Nermafa'a ofri amne mani'nefi? Hagi magora naganatamimo'a mani'neo? Huno higeta tamagra naganatamimofona avreta eho hani'a nanekea ontahineta kenona'a hu'none. ");
INSERT INTO kbq_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Hutazageno Juda'a nafa'amofo Jekopuna amanage huno asmi'ne, Ana ne'mofavre Benzamenina huntegeno nagrane vanigeta, tagrane kagrane mofavre'zagatine tagakura huta ofrita mani'mneno. ");
INSERT INTO kbq_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nagrani'a huvempa huanki'na Benzamenina kegava krintegahue, hanki kvama hu'so'e osanugeno'ma hazenkema eri'na ana knazana nagra erigahue. Hagi kagri kavure'ma avre'na omesuna nagra ana knazana erigahue. Nehanugeno ana knazamo'a nagrane mevava hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Hianagi tagrama avega ontetasina, menina tagra tare zupa vuta ete huta ne'zana eruntesine. ");
INSERT INTO kbq_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nezmafa Israeli'a amanage huno zamasami'ne, Tamagrama Benzamenima avreta vunaku'ma hanuta amana hiho, mago'a knare'nare zafa rgama mopatifima me'neana kutamifina erinerita mago'a tusa masevene (balm), tumemofo rima'ane, (honey) mananentake masavene, mananentake zafa rine, pistasios zafa ragane, almoni zafa raganena eri'neta vuta ana kva nera musezana ome amiho. ");
INSERT INTO kbq_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ana nehuta mago'a zagoa eri aguheta tamazampina e'rineta, zamage kaniza e'ririnegahazanki, kutamifima erarinagetama erita e'naza zagonena erineta vuta ome amiho. ");
INSERT INTO kbq_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ana nehutma nagna tami'mofona otita ame huta avretma ete ana kva nete viho. ");
INSERT INTO kbq_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hagi nunamu huankino hihamu'ane Anumzamo ana ne'mofo avure asunku huramantesuno'a, mago neramafune, Benzamenikiznia zanatre sanigeke ete egaha'e. Hagi nagrama mofavre ni'amokizmigu'ma nasunku'ma hanuna, nagra nasunku nehu'na manigahue. ");
INSERT INTO kbq_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jekopu'a anage hige'za mofavre naga'amo'za ana muse'zana (gift) e'neri'za, mago'ane zagoa eriguhe'za zamazampi e'neri'za, Benzamenina nevre'za oti'za Isipi moparega vu'za ana kva ne' Josefe avure uoti'naze. ");
INSERT INTO kbq_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Hagi zamagranema nagana'amo Benzameni ne-egeno Josefe'ma negeno'a noma'afi eri'za ne'a amanage huno hunte'ne, Ama vahera zamavarenka nompi ome nezmantenka, mago afu ome ahenka krenka ne'zana retro huo. Na'ankure zamagra nagrane feru ne'zana negahune. ");
INSERT INTO kbq_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Eri'za ne'amo'a agrama ke hiaza huno zamavareno Josefe nompi ome zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Anama huno Josefe eri'za ne'mo'ma zamavareno nompi vige'za kore nehu'za amanage hu'za hu'naze. Ko'ma kutifima eriri rante'nea zagoreku huno tavre noma'afi tanteankino, tantahinegeno tazerino kazokzo eri'za vahe'a trohu neranteno mika donkitinena avre vagaregahie. ");
INSERT INTO kbq_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Anage nehu'za Josefe nompi eri'za nete, Josefe no kasante vu'za ome asami'za, ");
INSERT INTO kbq_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","amanage hu'naze, ra netimoke, tagra ko'ma amare e'tama nezama eme miza senona naga e'none. ");
INSERT INTO kbq_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Hianagi ne'zama miza huteta, kantega umsenaku hunte kutima eriheta huta konana, magoke magokemota ne'zama mizase'nona kante zagotia kutimofo avazare me'negeta keteta ama erita e'none. ");
INSERT INTO kbq_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Aza ana zago'a eririranteneo e'i ana vahera onke'none. Antahita keta osu'neta ana zagone ete mago'ane ne'za miza hanune huta eritru huna zagonena erineta e'none. ");
INSERT INTO kbq_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Anage hazageno Josefe eri'za ne'mo'a amanage huno zamasmi'ne, Knare huta manigahazanki koro osuta akoheta maniho. Tamagri Anumzane, neramafa Anumzamo kutamifina zagoa eriramante'negahie. Nagra zagotmia ko namizage'na eri'noe. Nehuno Simeoni ome avreno eme zami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ana huteno Josefe eri'za ne'mo'a nompi zamavareno eno, tina tagi zamige'za zamaga sese nehazageno, donki zamimofona ne'zana zami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ana nehazage'za Josefe'ma agra noma'afi ferura ne'za negahune hige'za antahi'nagu avega ante'za mani'ne'za musezana (gift) eri antente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Hagi Josefe'ma nontegama ne-ege'za nege'za, musezama eri'za e'naza zana eme nemi'za mopafi zamarena re'za avuga kepri hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Anante Josefe'a knare huta mani'nazo huno hu so'e hunezmanteno, anage huno zmantahige'ne, Ko'ma neramafanku'ma ozafa reno mani'ne huta nasmi'nazana, agra menina knare huno mani'nefi? Ofri mani'neo? ");
INSERT INTO kbq_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Hige'za zamagra anage hu'za asmi'naze, Nerafa'a eri'za nekamo'a knare huno ofri mani'ne. Anage hu'za nesami'za agafi kepri hu'za razampi antahimi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ana hunentageno kesga huno nagna'amofo Benzameni, nerera mofavre negeno amanage huno hu'ne, Ama mofavrea neragana e'ma hutama nasmi'naza mofavrefi? Josefe anage nehuno, Anumzamo'a knare huno mofavrenimoka kaza huno asomu hugantegahie hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Josefe'a negna negeno zavi atesia agesa higeno, hantka huno zamatreno zavi ate'sia kumaku hakreno nemasefinka asafi (rum) ufreno zavi ome ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Zaviteteno avugosa sese huteno asu'zana eri rentrako nehuno, megi'a atiramino amanage huno zamasmi'ne, ne'za atinketa namaneno. ");
INSERT INTO kbq_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Josefe ne'zana arure atimi'za, zamagrira arure atinte zamante'za, Isipi naga'mo'za zamagragu ne'zana ne'naze. Na'ankure Isipi vahe'mo'za Hibru vahe'enena magopina bretia onegahaze. Isipi vahe'mo'za Hibru vahe'enema magopi kave ne'zankura zamesra huno zamagotegahie. ");
INSERT INTO kbq_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Hagi pusa mofavrereti agafa huno fore hu'nare, ranteti vuno osite zamazeri rempi huzmantage'za mani'ne'za tusi'a zampi zamano nevazige'za zamagogogu nehu'za ovufi avufi hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Josefe itareti eri'za vahe'mo'za ne'zana refko hu'za afuhe'i ome ante nezmante'za, Benzameni tafepina 5fu'a vahe'mo'za nega ne'za antente'naze. E'ina hige'za magopi mani'ne'za knare hu'za ne'zane, tine nene'za muse hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Anante Josefe'a noma'afi eri'za ne'amofona anage huno asmi'ne, Beki ku'zmifina eri'zama vanaza avamente ne'zana erivite nezmantenka, zago'zmia zamente zamente ku avazare eriri zamantetere huo. ");
INSERT INTO kbq_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Hagi Silvare kapuni'a nagana zami'mofo ku avazare eriri nentenka, witima mizase'nea zagonena eririnto, higeno eri'za ne'mo'a Josefe'ma asmiaza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Masa hu'za nehigeno, ana vahetmina huzmantege'za donki zamine vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Zamagra rankumara atre'za afete ovu'nageno, Josefe'a eri'za ne'amofona anage huno asami'ne, Otinka ana vahera zamavaririnka ome zamazerisunka anage hunka zamasmio. Na'a higeta knare'zama huma neramanteana havizana hunteta silvare kapu'a erita e'naze? ");
INSERT INTO kbq_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","E'i ana kapufintira ranimo'a tinkera noneanki, henkama fore'ma hania zana ana kapufintike nege. Tamagra e'inahu'ma hazana havi tamavu'tamava hu'naze hunka ome zamasamio. ");
INSERT INTO kbq_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Higeno agra zamavaririno ome zamazerino, Josefe'ma hia nanekea ome zamasamige'za, ");
INSERT INTO kbq_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Zamagra anage hu'za asmi'naze, Na'a higeno rantimo'a amanahu kea nehie? Eri'za vahe kamota amanahu'zana huga osu'none! ");
INSERT INTO kbq_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Hagi beki ku avazare'ma me'negeta zagoma haketa eriteta Kenani mopareti eritama kagrite'ma e'nonana ko. Inankna huta kagri ramofo nompintira silivao, golia musufa segahune? ");
INSERT INTO kbq_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ina eri'za vahe kamofo beki kupinti'ma hakenka eri fore hanunka, ana mofona ahe frisnanketa, tagra rantimofo kazokazo eri'za vahe manigahune. ");
INSERT INTO kbq_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Agra anage hu'ne, Menina kema hazaza hugahue, iza'o eri'nenige'na hakena eri fore hanumo nagri kazokazo eri'za ne' manigahie. Hanki anazama osu'namota knare hu'nazankita amne vugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Anage hige'za mago mago'moza ame hu'za ku'zmia hanti mopafi ante'za, eri heta hazageno, ");
INSERT INTO kbq_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Josefe eri'za ne'mo'a nempu'zmimofo kuteti agafa huno haketeno vuno nagna zamimofo kute uhanatino, ana kapua Benzameni beki kupi me'negeno keno eri fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Anante zamagra kukena zamia sagne nehu'za, hakarezazmia donki agumpi erinte'za ete rankumatega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Anante Juda'a afuhe'zane Josefe nonte enehanati'za, Josefe'a nompinka mani'nege'za avuga mopafi ruzagani'za mase'naze. ");
INSERT INTO kbq_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Josefe'a afuhe'ikizmi anage huno zamasmi'ne, na'a higeta havizana hu'naze? Tamagra ontahi'nazo, nagra kasnampa (divinesen) tro hu'na oku me'nenia'zana ke'na eri fore osugahuo? ");
INSERT INTO kbq_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Higeno Juda'a anage hu'ne, na'ane huta ranimoka hugahune. Inankna huta hazenkea osu'none huta hugahune. Anumzamo kagri eri'za vahe'mofo kumira keno eri fore hu'ne, Antahio, kapu eri'negenka kenka eri fore hu'namo'ene tagranena ranimofo kazokzo eri'za vahe manigahune. ");
INSERT INTO kbq_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hianagi Josefe'a amanage huno zamasmi'ne, Nagra e'inahu'zana osugahue. Ina nemofo beki kupinti kapu ni'ama eri fore'ma hu'nemo, kazokazo eri'zana eri nantegahie. Hagi ruga'amota neramafa'ma mani'nerega tamarimpa frune vugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda'a Josefente erava'o huno anage hu'ne, ranimoke, muse (plis) hugantoanki, knare kagri eri'za vahe'mo'na kagesafinkea hugahuo. Kagra, Fero'enena mago'zahu hu'na'anki, krimpa kna eri'za vahe kamo'na huonanto. ");
INSERT INTO kbq_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","rantimoka anage hu'nane, Tamagrira neramafa'ene neramagna enena mani'neo hunka eri'za vahekamota tantahige'nane? ");
INSERT INTO kbq_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hanketa tagra rantimoka anage huta kasami'none, nerafa'a ranafa refinka neraganana ante'ne. Hagi nezanarera'a tare zanante'neankino nempu'amo'a frigeno, agrake mani'negeno, nefa'a tusiza huno avesinente. ");
INSERT INTO kbq_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Huta hunkenka kagra eri'za vaheka'motagura anage hu'nane, ana mofavrea avreta nagrite enke'na ka'neno hu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Hianagi tagra ranti'mokagura anage hu'none, osi ne'mo'a nefana otregahie. Hanki nefama atreno esigeno'a nefa'a frigahie huta kasmi'none. ");
INSERT INTO kbq_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hianagi kagra eri'za vahekamotagura anage hu'nane, neramagnama avreta omesuta, nagri navufina onke'gosaze. ");
INSERT INTO kbq_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Anankema hutanketa tagra nerfa hirega kagri eri'za vahete uhanatita, rantimokama hana kea ome asmi'none. ");
INSERT INTO kbq_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Hagi mago'a kna evutegeno nerafa'a anage hu'ne, ete vuta mago'a ne'zana ome miza seho hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Hianagi tagra anage hu'none, tagranema neragana'ma ovanigeta, tagra uoramigahune. Neragana'ma tagranema ovanigeta ana ne'mofo avurera ovugahune hunkeno, ");
INSERT INTO kbq_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","kagri eri'za vahe nerafa'a tagrikura anage hu'ne, a'nimo'ma tare ne'mofavrema kase nami'neana tamagra antahi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mago'mo'a fanane hige'na nagra anage hu'noe, mago'a zagamo aheno tagana vazinegahie nehu'na, nagra mago'enena onke'noe hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nehuno mago'ene amanage hu'ne, Neganama avreta vanageno'ma, anahu hazenke erisigeta, nagrira efe nazokara nazeri ante henkma tesageno nasuzamo nahe frina, fri vahe kumapi (Seol) umanigahue huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","E'inage hu'negu kagri eri'za vahe nenfante nagra vanugeno, ana mofavrema nagrane omesiana, nenfa'a agu'amena ana mofavrefi ante'neankino, ");
INSERT INTO kbq_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ana mofavrema nagranema ovanigeno'ma kesuno'a agra frigahie. E'inama eri'za vahe ka'mona hanuna, nenfana eri'za ne' ka'a efe azokara azeri ante henkma antesugeno asuzampi mani'neno, fri vahe kumapi (Seol) umanigahie. ");
INSERT INTO kbq_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Hanki'na eri'za vahe'kamo'na anage hu'na ana nekura huvempa hu'noe, nenfaga nagrama avre'na omesugeno'a ana knazana nagrite mevava hugahie hu'na hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","E'ina hu'negu muse (plis) hugantoanki natrege'na nagra eri'za vahe kamo'na neragna nona hu'na kazo kazo eri'zana ranimoka eriganta'nena, neragnana atregeno nefuzane vino. ");
INSERT INTO kbq_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na'ankure asuzamo nenfana azeri haviza huzanku nentahuanagi, inankna hu'na nenfantera vugahue nenagnama ovanige'na? ");
INSERT INTO kbq_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Josefena asuzamo'a avitegeno asunku'zana azeriga osuno, anante oti'naza vahekura ranke huno anage hu'ne, Hakare'amota amafintira megi'a atiramiho, hige'za atiramizageno Josefe'a nefu'zane mani'neno huama huno, nagra Josefe'ne huno zamasi'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nezmasamino krafa huno zavi netege'za, Isipi vahe'mo'za nentahi'za vu'za Fero nompi nemaniza vahera ana zamofo agenkea ome zmasamizage'za maka'moza antahi'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Anante Josefe'a afuhe'mokizmia anage huno zamasmi'ne, nagra Josefe'ne! Hanki nenfa'a knare huno mani'nefi? Higeno afuhe'mokizmia tusi'a zamagogo fege'za magore hu'za kea osu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Anante Josefe'a afuhe'mokizmigu anage hu'ne, Muse (plis) hurmantoanki nagrite erava'o hiho. Zamagra anante erava'o hazageno anage huno zamasmi'ne, tamagrama zagore'ma natrage'za mizase'za Isipima e'naza ne' tamagri neramafu Josefe'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Hianagi tamagrama mizante'ma natregenama e'noa zankura, tamagra ramagra tamarimpa ohe ahea osiho. Na'ankure tamagra'a natrage'na amafina eomani'noanki, Anumzamo hunantege'na egota hu'na vahe'mo'za ofri manisagu emani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Na'ankure agate'zamo'a tare kafu evigeno, 5fu'a kafua amne me'neanki'za hoza eri'za kri'za onkafigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Hagi Anumzamo hunantegena ofrita manisagu egote'na e'noe. Ama mopare tamazerise nehu'na, agate kna'afina tamagrira tamazama hanuana tusi'a knare kankamumpinti tamaza hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","E'ina hu'negu, tamagratmi hunantage'na amafina ome'noanki, Anumzamo hunantege'na e'noankino, Agra'a nazeri otige'na Ferona antahintahi nemi'na, noma'a kegava nehu'na, mika Isipi mopanena kegava hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hagi menina ame huta nenfa'ma mani'nerega vuta, anage huta ome asmiho, negamofo Josefena, Anumzamo'a rankva vahe Isipia azeri oti'neanki, hantka hunka eno, huta ome asmiho. ");
INSERT INTO kbq_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Hagi kagrane mofavre naga ka'ane, kagehe'inena nezmavrenka, sipisipine, meme kevune, bulimakao kevune, mika feno zanka'anena enerinka enka nagri tvaonte Goseni mopare emanigahane. ");
INSERT INTO kbq_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Anantega emani'nenage'na 5fu'a agatontoma hu kafumofo agu'afina, nagra ne'zana tamigahue. Hagi kagrane, mika nonka'afima mani'naza vahe'taminema omesutma tamunte omnena tamagaku hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hanki keho, tamagra negageno nagana'nimo Benzameni enena negege'na, nagra'a nagipinti Josefe'na ama kea tamagrira neramasmue. ");
INSERT INTO kbq_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Hagi Isipi mopafima ra nagima eri'na mani'noa zankue'ene, mika knare'zama Isipi me'negeta kaza zamofo nenekea nenfana ome nesamita, ko ame' hutma avreta kama eho. ");
INSERT INTO kbq_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Anante negna Benzameni anankempi ome azeri anukino zavi atentegeno, Benzameni'a ana zanke huno zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Josefe'a miko nefugizmi zamantako nehuno zavi atezamantetege'za, henka nefu'zane keaga hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Josefena nefu'za e'naze kema, Fero'ene eri'za vahe'amozanena nentahiza muse hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Anante Fero'a Josefenkura anage hunka negfu'gizmia zamasamio hu'ne, Kutuntamia donki afu agumpi erinteta avreta Kenani moparega viho, ");
INSERT INTO kbq_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","vutma neramafane maka nontamifima nemaniza vahe'ene zamavareta nagrite enke'na, so'e mopa Isipi nagra tami'nena anampi maniho. ");
INSERT INTO kbq_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Menina nagra huneramantoe, karisia Isipiti erita vuta osi mofavre tamine, a'ne tamine, nermafanena ome avreta eho. ");
INSERT INTO kbq_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tamagra miko zantamigura tamagesa ontahiho, Isipi moparetira knare'za erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Hige'za Israeli amohe'za Fero'ma ke'ma zamasmiaza nehazageno, Fero'ma asamia kante anteno Josefe'a karisia nezamino, kantegama nemema vanaza ne'zanena zami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Mago mago'mofona Josefe'a magoke kukena amitere nehuno, Benzamenina 5fu'a kukenagi, 300'a silva zagone ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Nefana ama'a zantami antente'ne, 10ni'a donkimofo agumpina Isipi mopafima knare'nare zantamima me'nea zantamina eri antenenteno, 10ni'a donkimofo agumpi witi rgaramine, raisi rgaramine (grain) nezmino, nezmafa kantega ne-eno neme esia kave'enena antentege'za eri'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Anante Josefe'a huzmantege'za atre'za vu'za nehazageno, anage huno zamasmi'ne, Kantegama nevuta ha' fra osiho! ");
INSERT INTO kbq_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hagi zamagra Isipitira e'za Kenani mopare nezmafa Jekopunte ehanati'naze. ");
INSERT INTO kbq_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Zamagra anage hu'za nezmafana eme asmi'naze, Josefe'a ofri amne mani'ne, tamage agra Isipi mopa miko kegava kri'ne, nehazageno ana kegura agesa tra'nereno antahi ozami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Hianagi zamagra mika ke Josefe'ma huzmante'nea kea, nezmafa eme nesmizageno nentahino, karisima negeno'a, nezmafa Jekopu agu'amo'a kasefa higeno muse hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Anante Israeli'a anage hu'ne, ha knarere, mofavrenimo'a ofri amne mani'ne. Nagra vu'na ome kete'na henka frigahue. ");
INSERT INTO kbq_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Hagi anagema huteno'a Israeli'a afufenoma'a miko enerino Isipi vunaku nevuno Bersebama unehanatino'a, nefa Aisaki Anumzamofontega ofa Kresramana vunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ana kenagera Anumzamo'a ava'nagna zampi Israelina amanage huno asmi'ne, Jekopuo, Jekopuo higeno, ama mani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Higeno Anumzamo'a anage hu'ne, Nagra Anumzamo'ne, nafakamofo Anumzane, Isipi vuzankura korera osuo na'ankure, nagaka'a Nagra zamazeri hakare hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kagrane magoka Isipia uramitena, ete kavre'na marerigahue. Hagi Josefe'a kavurga erisu huno asegantegahie. ");
INSERT INTO kbq_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Anage higeno, Jekopu'a Bersebati otino nevige'za amohe'za Fero'ma ome avreta eho huno'ma zami'nea karisfi nezmafa Jekopune ne'onse mofavre nagazmine a'nane nagazmine, hu'za anampina zamavarente'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Mika afuzagazmine, fenozminema Kenani mopareti'ma eritru hu'nazane eri'za Isipi e'naze. Jekopu'ene agehe'zane magoka maka erami'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Maka mofavre'a zagane, agehe'zane, mofa'ne zaga'ane, agehemofone naga'ane, agripinti'ma fore hu'naza naga'ane zamavareno Isipi vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jekopu mofavre naga'ma Isipima vu'nazana naga'mokizmi zamagi'a ama'ne, Rubeni'a Jekopuna agonesa mofavre. ");
INSERT INTO kbq_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubeni ne'mofavre naga'mokizmi zamagi'a, Hanoki'e, Palu'e, Hezroniki anantera Karmi'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simioni ne'mofavre naga zamagi'a Jemueli'ma, Jamini'ma, Ohati'ma, Jakini'ma, Zohariki'ma, Sauriki'za, Kenani kumate a'mofo mofavre naga mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Hagi Livae ne'mofavremokizmi zamagi'a, Gersoni'ma, Kohati'ma, Merari'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Hagi Juda ne'mofavre naga'mokizmi zamagi'a, Eri'ma, Onani'ma, Sela'ma, Perezi'ma, Zera'e. (Hianagi Erike, Onanikea Kenani mopare fri'na'e.) Hagi Perezi mofavrerarena Hezroni'ene Hamulike. ");
INSERT INTO kbq_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Hagi Isaka ne'mofavre naga'mokizmi zamagi'a, Tola'ma, Puva'ma, Iobu'ma, Simroni'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Hagi Zebuluni ne'mofavre naga'amokizmi zamagi'a, Seredi'ma, Eloni'ma, Jalili'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ama'i Lia'ma Padan-Aram mani'neno Jekopunteti kase zmante'nea mofavreramine. Hagi mofara magoke anteneankino agi'a Daina'e. Hagi ana miko ne'mofavrene, mofa'ne naga'anena 33'a vahe forehu anante anante hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Hagi Gati mofavre nagara, Zifioni'ma, Hagi'ma, Suni'ma, Ezboni'ma, Eri'ma, Arodi'ma, Areli'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Hagi Asa ne'mofavre nagara, Imna'ma, Isva'ma, Isvi'ma, Beria'e. Hanki nezmasaro agi'a Sera'e. Beria ne'mofavremokizni zanagi'a, Heberiki, Malkieli'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hagi ama'i Lia kato mofa Zilpa'ma Jekopunteti'ma kasezmante'nea ne'mofavre naga'mokizmi zamagi'e. Zilpama kasezmantege'zama fore hu anante anante'ma hu'nazana 16ni'a vahetami fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jekopu nenaro Resoli ne'mofavrerarena Josefe'ene, Benzamenike. ");
INSERT INTO kbq_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josefe'a Isipi mopare umani'negeno Manaseke, Efraemikea fore hu'na'e. Asenati'a Potifera Oni kumate (mago agi'a Heliopolis) mono kva ne'mofo mofa'mo, kase ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Hagi Benzameni ne'mofavre nagara, Bela'ma Besa'ma, Asbeli'ma, Gera'ma, Namani'ma, Ehi'ma, Rosi'ma, Mapimi'ma, Hapimi'ma, Ardi'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hagi ama'i Resoli'ma Jekopunteti'ma kase zamante'nea mofavre nagamokizmi zamagi'e. Hagi Resolima kasezmante'nefinti'ma fore hu anante anante'ma hu'nazana ana makara 14ni'a vahe fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Hagi Dani'a magoke ne'mofavrea ante'neankino agi'a Husimi'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Hagi Naftali ne'mofavre nagara, Jazili'ma, Guni'ma, Jezeri'ma, Silemi'e. ");
INSERT INTO kbq_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hagi ama'i Lebani'ma mofa'amofo Resoli'ma ami'nea kato mofa Bilha'ma Jekopunteti'ma kasezmante'nea ne'mofavre naga'mokizmi zamagi'e. Bilha'ma kasezmante'nea mofavre naga'pinti'ma fore'ma hu anante anante'ma hu'nazana ana makara 7ni''a vahe fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ana maka Jekopu naga'ma Isipima e'nazana, agri'pintima fore hunante anante hu'naza nagaki'za, ana makara 66'a vahekino, anampina a'nene mofavreraminena ohampri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Hagi Josefe'a Isipi umani'neno mofavre erifore hu'neana, tare ne'mofavre kase zanante'ne. Ana hu'neankino Jekopu naga'ma Isipima mani'nazana ana makara 70'a vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Hagi Jekopu'ma eravaoma nehuno'a, Josefe'ma kama eme averi hanigeno Goseni kumate'ma vanigu, Judana huntegeno Josefentega vugota hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ana higeno Josefe'a hosi afu'a retro huno karisifi marerino nefa Israeli ome kenaku Goseni vu'ne. Hagi nefama eme negeno'a, anankempi azeri anukino zavira zanra kna atente'ne. ");
INSERT INTO kbq_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Anante, Israeli'a amanage huno Josefena asmi'ne, Ofrinka knare hunka mani'nanke'na kvugosafina eme koanki menina natrege'na mani'nena fri'neno. ");
INSERT INTO kbq_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Higeno Josefe'a afuhe'inku'ene nefa nagaku'enena amanage hu'ne, Nagra mareri'na Feronte vu'na amanage hugahue, Nafuhe'zane, nafa'nimofo naga'enena, Kenani mopareti nagritega e'naze hu'na ome asmigahue. ");
INSERT INTO kbq_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Hagi zamagra afuzaga kva nehaza vaheki'za, sipisipizmine, memezmine, bulimakao kevuzmine nezmavre'za, maka feno zaminena eri'za e'naze, ");
INSERT INTO kbq_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","hanugeno'ma Fero'ma nankna eri'za eneriza vahere huno'ma tamantahima kenigeta, ");
INSERT INTO kbq_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","amanage hiho, Tagrane nerafa zanena eri'za vahe kamota, afu' kva huta korapa nehazave mani'nonte eta meninena e'none huta tamagrama hanageno'a, tamagrira tamatresigetma Goseni mopare umanigahaze. Na'ankure Isipi vahe'mo'za trazama nenaza afutamima kegavama nehaza vahekura, zamesra huzmante'za zamagote'nezmantaza vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Anante Josefe'a amanage huno Ferona ome asami'ne, Nafani'ane, nafuhe'zane maka sipisipi'zamine, Bulimaka'ozamine, maka zazmine Kenani mopa atre'za Goseni mopare emani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Anage huteno afuhe'impinti Josefe'a 5fu'a vahe zamavareno Fero avure vigeno, ");
INSERT INTO kbq_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fero'a ana afuhe'mokizmia anage huno zamantahige'ne, Nankna eri'za e'neriza nagare? Hige'za Ferona anage hu'za asami'naze, Tagehemofonteti'ma eno nerafante'ma eno tagrite'ma e'neana eri'za naga kamota tagra sipisipi afu kva nehu'na naga mani'none, ");
INSERT INTO kbq_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","nehu'za Feronkura anage hu'naze, Osi'a gna ama mopare maninaku tagra e'none. Eri'za vahekamota afu'mofo ne'zana, trazana omanegeno aga'zamo Kenani mopare forehigu, menina muse (plis) hugantonanki, eri'za vahekamota tatregeta Goseni mopare umani maneno. ");
INSERT INTO kbq_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Anante Fero'a Josefena anage huno asmine, Negafa'ene, kafuhe'zanena kagritega e'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Hagi Isipi mopamo'a kegava hankeno me'neanki, negafane kafuhe'inena knare huno tre tre hu'nenia mopa zamige'za Goseni maniho. Hagi kegeno anampima knare vahe'ma mani'nesiana huge'za, nagri bulimakao afura kegava hiho. ");
INSERT INTO kbq_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Anage higeno Josefe'a nafa'amofo avreno Feronte egeno, Jekopu'a asomu ke Ferona hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fero'a anage huno antahige'ne, Kagra nama'a zagegafu hu'nane? ");
INSERT INTO kbq_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Higeno Jekopu'a Feronkura anage hu'ne, Nafahe'za zaza kna maniza e'nazanagi, nagra atupa'a knafi natagura huna ne-ena, 130'a zagegafu hu'noe. ");
INSERT INTO kbq_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jekopu'a asomu ke Ferona hunteteno atreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Higeno Josefe'a nafa'amofone, afuhe'inena zamavareno Isipi mopamo'ma knare huno tretre hu'nerega, Rameses kaziga Fero'ma hu'nere mopa ome regori zamige'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josefe'a nefane, afuhe'ine, nefa nompima nemaniza vahe'ene, osi mofavre naga'enena, mani'naza avamente ne'zana zami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hianagi Isipi mopafine, Kenani mopare'enena tusi'a zagereno mikazana tefanane higeno, mika mopafina ne'zana omnetfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josefe'a Isipi mopareti'ene Kenani mopareti'ma maka zagoma eri'za ne'zama eme mizasaza zagoa eritru huteno, erino Fero nompima zagoma nentazafi ana mika ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Hagi Isipi vahe'mo'zane Kenani vahe'mo'zama zagozmima ne'zante'ma maka atre'za eri hanama hutage'za, Isipi vahe'mo'za Josefente e'za anage hu'naze, zagotia hago atreta erihna hu'nonanki, frisunki ne'zanaramio. ");
INSERT INTO kbq_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Anante Josefe'a anage huno zamasami'ne, Zago tamima omanea nona'a, afu'zagatmi eme naminke'na afu tamimofo nona hu'na ne'zana refko hurami'neno. ");
INSERT INTO kbq_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hige'za hosiramima, sipisipiramima, memekiramima bulimakaoramima, donki afu'zagaramima hu'za zamavare'za Josefena eme nemizageno nona huno, ana kafufima nesaza ne'zana zami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ana kafuma vagarege'za mago zagegafurera Josefente ete e'za anage hu'naze, rantimoka kavurera fra okigahune. Zagotia hago kagrite atreta eri hana nehuta, mika afutamina ranti'moka kagrite atre vagare'none. Hagi rantimoka menina tagrane mopatige asizanke me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nahanigeta tagra frisunkeno mopatimo'a havizana hugahie? Tagri'ene mopatinena nezanteti miza hugeta, tagra Feronte kazokazo eri'za erinenteta manimneno. Nehunka avimza tamigeta tagra ofrita mani'nesunkeno, ama mopamo'a, trankino megusa avu'avara osino. ");
INSERT INTO kbq_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hazageno Josefe'a mika Isipi mopa ne'zanteti mizaseno Ferona eri ami'ne. Mika Isipi vahe'mokizmia zamaga'zamo'a zamazeri havizantfa hige'za mopa zamia ne'zante atrageno, ana mika mopamo'a Fero mopa sevare'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Hagi Josefe'a ana mika vahetamina kazokazo eri'za vahere huno, Isipi mopamofo ruga raga atupa'aregati zamavareno, ranra kumatmimpi ome zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hianagi Josefe'a pristi vahe'mokizmi mopa miza osegeno, Fero'a ana pristi vahera ne'zana zamige'za nene'za mopa'zmia zagorera otre'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hagi Josefe'a amanage huno maka veara zamasmi'ne, Keho, hago menina tamagri'ene mopatmi'nena Fero miza semi'noe. Menina mago'a avimza timinena tamagra hoza eritma hankregahaze. ");
INSERT INTO kbq_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Hagi ne'zama hamare knarera 5fu'a ko'nama anaki'nuta, mago ko'na Fero nemita, 4'a ko'nafintira hozafi avi krisaza zane, nontamifi naga'ene ne'onse mofavre naga'mozanema nesazaza tamagra erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Hige'za anage hu'naze, Kagra knare kavukava hurantanketa ofrita mani'none! Knare agampu ra'nimofo avurera hiankita, Fero kazokzo eri'za vahe manigahune. ");
INSERT INTO kbq_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Anage hazageno, Josefe'a Isipi mopamofo tra kea anage huno ante'ne, Hozafi kave'ma hamare'za 5fu'a kevuma antesafintira mago kevua kini ne'mofo amitere hugahaze hu'nege'za, ana hume neazageno eno ama knarera ehanati'ne. Hagi pristi vahe'mo'zage mopazmia otre zamagra'a eri'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Menina Israeli vahe'mo'za Isipi mopare, Goseni agu'afi mani'ne'za, mika zana erisanti nehare'za, rama'a vahe fore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekopu'a Isipi moparera 17ni'a zagegafu mani'ne. Jekopu'ma manino'ma e'nea zagegafu'a ana maka'a 147ni'a zagegafu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israeli'ma (Jekopu) frisnia knamo atupa higeno, mofavre'a Josefe ke huno amanage huno asmi'ne, Muse (plis) hugantoanki kagrama nagriku'ma kave'ma sinante'sunka, menina kazana fenka namopi antenka musezana hunaverinka tamage hunka huo. Muse (plis) hugantoanki Isipia ase onantegahane. ");
INSERT INTO kbq_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Hianagi nagrama frisnugenka, kagra Isipitira erinka vunka vahe'niama asema nezmantafi ome asenanto. Higeno Josefe'a huno, kema hanaza hugahue. ");
INSERT INTO kbq_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Agra anage hu'ne, Tamage hu'na hugahue hanunka, huvempa huo, higeno tamage hu'na ana hugahue huno Josefe'a asmi'ne. Anante Israeli'a (Jekopu) kepri huno sipare mani'neno Josefena muse hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hagi mago'a kna evutegeno Josefena anage hu'za asmi'naze, Negafa'ma kri eri'nea nanekea antahinano, hu'za Josefe asmi'zageno, Josefe'a tare ne'mofavre'a Manasene, Efraemikizni neznavreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Vahe'mo'za Jekopuna ome asami'za, konkeno negamofo Josefe'a kagenaku ne-e, hu'za hazageno Israeli'a hanave enerino otino sipa'are mani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Anante Jekopu'a anage huno Josefena asmi'ne, Tusi'a Hanave'ane Anumzamo Lusi mopare Kenani fore hunamino asomu kea hunenanteno, ");
INSERT INTO kbq_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","amanage huno Agra nasmi'ne, Antahio, Nagra hanugeno kagripintira vahera fore hunakare hu'za kumara ante'za nemanisage'za, vahe'mo'za hamprigara osugahaze. Ana nehu'na ana mopa kagehe'mofo zamisuge'za, erisanti hare'za mani vava hugahaze huno nasami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Hagi menina kagra tare mofavre znante'nane, Kenani mopare mani'nogenka, kamama Isipi mopare mani'nenka, kase znante'nana mofavrea nagrire, Efraemike Manasekea nagri mofavre manigaha'e. Rubeni'ene Simioni'enema mani'na'ankna hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Hanki henkama kasentesana mofavrea kagri mofavre manigahie, zamagra nezmafu zanagire makazana refko hu'za erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Hagi korapara nagra Padan-Aramuti neogeno, Resoli'a frige'na nasunku hu'na afete Efrata me'nege'na, kantega Kenani mopafi Efrata vu kantega zavi eme nete'na asente'noe (E'i Betlehemie). ");
INSERT INTO kbq_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Anante Israeli'a Josefe ne'mofavrerarena neznageno anage hune, Ama aza mofavrerarene? ");
INSERT INTO kbq_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Higeno Josefe'a nefankura anage huno asmi'ne, Zanagra nagri mofavre'rarene Anumzamo'a amafi mani'nogeno nami'ne. Higeno Jekopu'a anage hu'ne, Zanavrenka nagrite egena asomu kea huznantaneno. ");
INSERT INTO kbq_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Hagi Israeli'a hago ozafareno avurga keso'e osu'ne. Ana higeno Josefe'a ne'mofavreararena zanavreno uravao higeno, zananukino antako huzanante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ana huteno Israeli'a anage huno Josefena asmi'ne, Nagra kagrira kvugosafina onkagegahue hu'na nagesa antahi'noanagi, menina Anumzamo'a natrege'na kagri'ene, mofavreka'ararena tamagoe. ");
INSERT INTO kbq_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Anante Josefe'a nefa amoteti mofavre'a rarena neznavreno, avugati mopafi kepri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ana huteno Josefe'a ana mofavre'ararena zanavreno uravao huteno, tamaga azanura Efraemina avreno, Israelina aza hoga kaziga nemino, hoga kaziga azanura Manasena avreno Israelina azan tamaga kaziga ami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Manase'a nempu'amo mani'neanagi, Israeli'a henka ne'mofo Efraemi asenire tamaga azana, nenteno hoga azana, nempu'amofo asenire anteno, azana anteganti antegma huno zananunte ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ana huteno asomu ke Josefena hunenteno amanage hu'ne, korapa'ma nenfa Abrahamu'ene Aisakike Anumzamofo avure vano huna'a kna huno, nagrira Anumzamo mani'zaniafi sipisipi kva nehia kna huno kva hunanteno menina amagnare ehanatie. ");
INSERT INTO kbq_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Havi zampinti naza hu'nea ankeromo, asomura huranantegahie. Nagri nagimo tanagripi me'nigeno, nenfa Abrahamune Aisakikizani zanagimo'enena zanagripina meno vugahie. Hanki zamagra tusi'a vahetami erifore hu'za miko mopafi manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Hagi Josefema kegeno nefa'ma azan tamagama Efraemi asenire nentegeno muse nosuno, nefa azana Efraemi aseniretira erino Manase asenire ante'ne. ");
INSERT INTO kbq_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ana nehuno Josefe'a nefana anage huno asmi'ne, Nenfaga e'inahura osunka, amamo kota fore hu'neanki tamaga kazana amamofo asenire anto. ");
INSERT INTO kbq_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ana hianagi nefa'a i'o nehuno anage hu'ne, Ne'nimoka nagra antahi'noe, Manasempintira rama'a vahe fore nehinkeno, rukazi huno tusi'a vahetami manigahie. Ana hu'neanagi Efraemipintira nefuna agatereno tusi'a vahetami fore huno, miko mopafina rukazi hu'za rankuma ante'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Agra ana kna zupa asomu ke huneznanteno anage hu'ne, Israeli vahe'mo'za vahe'ma asomu kema huzmante'nakura anage hu'za hugahaze. Anumzamo'ma Efraemine, Manasekiznima asomu'ma huzanante'neaza huno Anumzamo'a asomura huramantegahie hu'za hugahaze! Nehuno agra Efraemina, Manase avuga avrente'ne! ");
INSERT INTO kbq_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ana huteno Israeli'a Josefena anage huno asmi'ne, Kama nago! Nagra hago fri'za huanagi Anumzamo'a tamagrane mani'neno, tamavreno ete tamafahe'i mopare vugahie. ");
INSERT INTO kbq_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Hagi masavenke huno tretre hu'nea Sekemu agona mopa bainati kazinknonteti'ene atireti'ene Amori vahera zamahe'na hanare'noa mopagi'na kafuhe'ina ozamigahuanki kagri negamue. ");
INSERT INTO kbq_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jekopu'a amanage huno mika ne'mofavre'amokizmi zamasmi'ne, Henkama tamagrite'ma fore hania zamofo nanekea tamasamigahuanki, ");
INSERT INTO kbq_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Jekopu mofavre naga'nimota tamagra eme atru huneta tamagesa anteta nerafa'na Israeli'na hanua nanekea antahiho. ");
INSERT INTO kbq_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubeniga nagonesa mofavremoka, ese hihamu ni'afinti kasegante'nogenka zamagaterenka mareri vahe mani'nanku, hanave kamo asaga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hianagi timo hageno eviankna huno, nagakafina ran kagia omanegahie. Na'ankure negafa sipare marerinka haviza hunka mago a'ni'a avazu nehunka sipani'a eri hi'mna vu'nane. ");
INSERT INTO kbq_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simioni'ene Livaikea kogna mani'na'e. Bainati kazinkno zanimo'a, vahera zamazeri havizantfa hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nagri knare antahi antahimo'a, tanagri antahi antahifina omanegahie. Nagra kema anakisapina omanigahue. Na'ankure zanarimpa ahenke'ne vahera akafrigaha'e. Zanagra musezampi vu'ne, Bulimakao agia agruna nofi akafrina'e. ");
INSERT INTO kbq_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tanarimpa ahe'zantera tusi huneranantoe. Na'ankure tanarimpa ahezamo'a arava ohegahie. Tanarimpa nehena, hazenke vahe manigaha'e. Jekopu'na nagri'pintira tanatufe atra'nena, Israeli mopafina arure arure huta manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judaga kafu kaganaza kagi erisga hugahaze. Kagri kazamo'a ha' vahe ka'amokizmi zamanankempi megahie. Kagri negafa ne'mofavremo'za kepri hu'za zamarena regahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judaga laioni anenta kna hu'nane. Kagra nenamofoga laionimo ne'zaga aheno nenaku kva hiankna hu'nane. Kagrikura vahe'mo'za kagoro hugahaze. Mago vahe'mo'a kvako osugahie. ");
INSERT INTO kbq_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judaga kva vahe'mokizmi azompamo'a kagripi mevava hugahie. Kini vahe azompamo'a agiararemofo amu'nompi me'nesigeno, Nafa'amo'a henka Sailo kumate ehanatigahie. Hanige'za hakare ranra kumate veamo'za agri kea erizafa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Donki anentara krepire nofiteti rentesnankeno manigahie. Agaho donkima avesi'nesia krepi nofite'ma arentesigura antahi muhara osugahie. Kukena'a waini timpi sese hu'ne, na'ankure ne'zamo'a amporegeno nehana huga osu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Agra rama'a waini tina nenegu huno tare avurgamo'a koranke hu'ne, agra afu'mofo amirina rama'a nenegu huno, ave'mo'a efenentake hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebuluniga hageri ankenare umanigahane. Umani'nesanke'za vente'mo'za efre'za vu'za hugahaze. Mopa kamofo agemo'a Saidoni kuma atupare uhanatigahie. ");
INSERT INTO kbq_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakaga hankave donkie, tare fenonku'mofo amu'nompi manigsa hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Agrama kegeno knare manigsa kuma me'negeno, ana kumamo knare zantfa hu'negeno, hanave'a erigoteno eri'za eri'ne. Ana hu'neanagi henka'a kna'ane kazokzo eri'za erigahie. ");
INSERT INTO kbq_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daniga kva (jas) vahe tro hunka vaheka'a kegava hugahane. Mago naga Israeli kevufi manigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ha' osifavemo kamofo ankenare mani'neno, hosimofo agamerumpafi amprigeno, agumpifi vu'nea ne'mo amefigati asga hurami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ra Anumzamoka nahoke ahesnanegu, kavega ante'na mani'noe. ");
INSERT INTO kbq_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gatiga kumza vahe'mo'za kahegahaze. Hianagi rukrahe hunka, zamagumpi zamarotgo hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asaga hentofa ne'za eri fore hugahane. Rankva vahe zame'nesia ne'za, hankregahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftaliga, afi a' afu dia atregeno agareno viankna nehunka, knare so'e nanekege hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Josefega zafa azankunamo raga renteankna hugahane, azankunamo ti ankenare me'neno raga reno, pagagi huno kegina refiteankna hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ha' vahekamo'za atireti hanaveti'za hara hunegante'za, kevea negahe'za, kazeri haviza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Hianagi Jekopu Anumzamo'a Josefena hankavea aminkeno azamo'a oragesigeno, kevema ahesiana hantaga osugahie. Ana Anumzamo'a Israeli vahera sipisipi afu kegava hiankna nehuno, zamagu'vazi havegna hugahie. ");
INSERT INTO kbq_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Na'ankure Jekopu'na negafa'na Anumzamo kaza nehuno, hihamu'ane Anumzamo asomu huneganteno, anagamu monafinkati asomu huneganteno, mopa agu'afinti tina hanati'nigenka asomura e'nerinanke'za, karimpafinti'ma fore hanaza mofavre'mo'zanena asomura erigahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Kagri negafa'na asomumo'a nagri nagehe'i asomura agatereno mevava agonagna huno mareri'ne, ana asomumo'a, Josefega kokovite me'nenige'za, kafuhe'za kage anagamute'za kagegahaze. ");
INSERT INTO kbq_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benzameniga afi ha' kragna (wolf) hugahane. Nanterampi freno zaga aheno traga hiankna nehunka, kinaga'afi refko huno erino ome'mi eme'mi hiankna hugahane. ");
INSERT INTO kbq_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ama ana maka 12fu'a Israeli nagakino, nezmafa'a mago mago naga nofi'ma mani'naza avamente asomu kea huzmantetere hu'nea naneke. ");
INSERT INTO kbq_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jekopu'a amanage huno mofavre naga'amokizmia zamasmi'ne, Nagrama fri'na vahe'ni'ane umani knanimo'a kofta nehie. Hagi nafahe'ima ase zamante'naza mopare, havegampi ome asenanteho. Hiti ne' Efroni mopama mizama se'nefi ome asenanteho. ");
INSERT INTO kbq_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makapela havegampi Mamre kuma tvaonte Kenani mopa agu'afi, Abrahamu'ma ana mopane havegane vahe asente'zane huno Efroni'pinti'ma mizama se'nea mopafi ome asenanteho. ");
INSERT INTO kbq_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","E'i anampina Abrahamune nenaro Serane ase'znante'naze. Aisakine nenaro Rebekagiznia anampi ase znante'nafi, anampinke a'ni'a Liana asente'noe. ");
INSERT INTO kbq_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ana mopane havegane Hiti ne' mofavrefinti miza se'neane. ");
INSERT INTO kbq_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Anagema huno mofavre naga'amokizmi zamasmi vaga reteno, agiararena sipare asuteno vagare asimu atreteno frino naga'ane umani'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Anante Josefe'a nefa avugosafi umseno, zavi atenenteno antako hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Henka Josefe'a fri kerfare kva nehia eri'za vahe'a huzmantege'za, kehiaza hu'za avufgamo'ma kasri'zanku agu'afina mago'a marasini nente'za eri so'e hute'za, Israelina (Jekopu) masave fre'za ante'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","40'a zage gnafi e'i anazana huga hazankino, ana foti'a zagegnafina avufga eri so'e hu'naze. Ana hazageno Isipi vahe'mo'za 70'a zagegnafi zamasunku hu'za zavira ate'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Anante zavi'ma atekna agateregeno, Josefe'a anage huno Fero nompi eri'za vahera zamasmi'ne, Tamagra menima nagri'ma antahi namisuta muse huramantoanki, Ferona amanage huta ome asmiho, ");
INSERT INTO kbq_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Nenfa'a huvempa ke hunanteno amanage hu'ne, nagra ha fri'za huanki, nagrama Kenani mopafi kerigama kafinte'nofi anantega ome asenantegahane. Anage hu'negu natrege'na avufga'a eri'na mareri'na ome asentete'na, ete a'neno. ");
INSERT INTO kbq_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Higeno Fero'a amanage hu'ne, Anagamu vunka negafa'ma huvempa huno kasmi'neaza hunka ome asento. ");
INSERT INTO kbq_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Hagi Josefe'a nefa asenteku anagamu marerigeno, Fero eri'za vahe'mo'zane, noma'afi kva vahe'ene, mika Isipi mopafi kva vahe'ene, ");
INSERT INTO kbq_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","mika Josefe naga'ene, nefu'zane, nefa naga'enena vu'naze. Hianagi osi mofavre naga'zmine afu kevu zaminena Goseni mopafi zamatre'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Anama Josefe'enema vu'nazana rama'a sondia vahe'ene vu'nazankino, mago'a karisifi maniza nevazageno, mago'a hosi agumpifi mani'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Hagi ana vahe'mo'za vu'za Jordani timofo kantu kaziga ankenarega, witi honama neharaza kumate Atadi umani'naze. Anante 7ni'a zage gna zamagra umanine'za, zamagrama zamavuzmavapima nehazaza hu'za, nezmanfankura tusi zavi ate'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ana mopafima nemaniza Kenani vahe'mo'za kazama witi akru neharaza kumate Atadi mani''neza zavi netage'za nezmage'za anage hu'naze. Ama'i Isipi vahe'mo'za tusi'a zavi atetere, nehu'za agi'a Abel-mizraim hu'nazankino, zage hanati kaziga Jodani me'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hagi Jekopu mofavre naga'mo'za nezmafa'ma zmasami'neaza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Agri mofavre'mo'za kerfa'a eri'za Kenani mopafi vu'za, Makapela havegampi Mamre kuma tvaonte ome asente'naze, ko'ma Abrahamu'ma vahe asente mopae huno Hiti ne' Efroninteti, miza hu'nea mopafi asente'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ana'ma huno Josefe'ma nefama asentetege'za, afuhe'zane nefama asenteku mareri'naza vahe'ene maka ete Isipi moparega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Hagi nezmafa'ma fritege'za, Josefe nefu'za anage hu'naze, tagrama havizama hunte'nona nona'a, tagrira na'a hurantegahie? ");
INSERT INTO kbq_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nehu'za zamagra Josefena ke atrente'za anange hu'naze, Negafa'a frinaku nehuno, ");
INSERT INTO kbq_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","anage huta Josefena asmiho hu'ne, muse (plis) hugantoanki, havi avu'ava hugante'nazana kumi zamia atre'zmanto. Menina muse (plis) hugantoanki, negafa Anumzamofo eri'za vahe'mota havi avu'ava hugante'none. Ana kema Josefe'ma nentahino'a zavi ate'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Anante afuhe'za e'za Josefe avuga zamugosaregati umase'za anage hu'naze, Antahio, tagra kagri kazokazo eri'za vahere. ");
INSERT INTO kbq_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Hianagi Josefe'a anage huno zamasmi'ne, korora osiho, nagra Anumzana omani'nogu keaga huoramantegahue. ");
INSERT INTO kbq_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tamagra nagrira nazeri haviza hu'nazanagi, Ra Anumzamo'a rama'a vahe zamaza hunaku nentahino anara hu'neankino, menina ana zamo'a fore nehie. ");
INSERT INTO kbq_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","E'ina hu'negu tamagra korora osiho, nagra tamagri'ene, neone mofavre naga'enena tamazeri knare hugahue. Nehuno zamanukige antege nehuno, knare kegaga huzami'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Hagi Josefe'a Isipi mopare afu aganahezane mani'neno, 110ni'a zagegafu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efraemi mofavremo mofavre antegeno negeno, Manase ne'mofavre'mo Makiri mofavre antegeno Josefe'a amote zamavarenteno keteno fri'ne. ");
INSERT INTO kbq_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josefe'a amanage huno afuhe'ina zamasmi'ne, Nagra fri'za hue, Anumzamo tamagrira kegava huneramanteno, tamavreno ama mopafintira marerino Abrahamuma, Aisakima, Jekopuma huvempa huzmante'nea mopare vugahie. ");
INSERT INTO kbq_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Anante Josefe'a Israeli ne'mofavre nagara amanage huno huvempa huno zamasmi'ne, Anumzamo tamagrira kegava huramante'nena zaferinani'a erita mareriho. ");
INSERT INTO kbq_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hagi Josefe'a 110ni'a zagegafu maniteno frige'za, avufgamo'ma kasrizanku agu'afina mago'a marasini ante'za eri so'e hute'za masave freza, zavoafi eri antageno Isipi mopafi me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israeli ne' mofavre naga'mo'za a'mofavre zamine Isipima nezmafa Jekopu'enema vu'naza naga'mokizmi zamagi'a ama'ne, ");
INSERT INTO kbq_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni'ma, Simioni'ma, Levi'ma Juda'ma, ");
INSERT INTO kbq_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka'ma, Zebuluni'ma, Benzamini'ma, ");
INSERT INTO kbq_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani'ma Naftali'ma, Gati ene Asa'e. ");
INSERT INTO kbq_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Hagi Josefe'a ko Isipi umani'nege'za, Jekopumpinti fore'ma hu'naza nagara maka 70'a naga'mo'za vu'naze. Hianagi Josefe'a ko Isipi umani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Hagi Josefe'ene ana maka afu'aganahe'zane ana knafima magokama vu'naza naga'a fri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Hianagi Israeli vahe'mo'za mofavrea kase'za eri hakare hazageno, tusi hankvenentake vahe fore hu'za Isipi mopa mani avite'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hagi henka Josefe'ma hu'nea zantmima keno antahino osu'nea ne'mo, Isipia kasefa kini efore huno kegava hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ana kini ne'mo'a vahe'agura amanage huno zamasmi'ne, Keho, Israeli vahe'mo'za tagrira tagatere'za, rama'a vahe fore nehazageno, hankave zamimo'a tagatenere. ");
INSERT INTO kbq_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","E'ina hu'negu enketa mago'a kanku haketa zamazeri haviza hanunke'za vahera fore huhakarea osnaze. Ha'ma fore hanige'za, ha' vahetirega ante'za ha' hunerante'za kumatia atre'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Anage hige'za, kazokzo eri'za kva vahe zamazeri otizageno, Isipi kini ne' Fero'ma fenoma antesnia rankumatre, Pitomu kuma'ene, Rameses kuma'enena Israeli vahera zamazeri haviza nehazage'za ki'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tusiza hu'za Israeli vahera zamazeri haviza hazanagi, mago'ane rupazi hu'za rama'a nehazageno, Isipi vahe'mo'za Israeli vahekura koro huzmante'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Israeli vahera zamasunkura huozmantage'za eri'zana hanaveti'za eri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tusi'a eri'za fukinteti briki trohu eri'zane, hozafi eri'zane mago'a eri'za zami'za, nomani'zazmia tusiza hu'za zamazeri amuho hazage'za zamarimpa akahezampi mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Anante Isipi kini ne'mo'a, Hibru a'ne'mo'zama mofavre'ma kasenteku'ma nehzageno zamazama hukema kse nezmia Hibru a'trena, Sifrane Puagiznia amanage huno znasmi'ne, ");
INSERT INTO kbq_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Hibru ane'mozama mofavrema kasentenaku'ma nehanageta zamaza hutama kasezmantesuta, mofa'nema kasezmantesagetma, zmatrenke'za maniho, hagi ne'mofavrema kasezmantesageta zamahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Hianagi ana a'tre'mokea Anumzamofonku koro nehuke, Isipi kini ne'mo'ma hanave kema huno'ma ne' mofavre'ramima zamahe frihoma hu'neana, zamahe ofri zmatrege'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ana higeno Izipi kini ne'mo'a ana a'trena ke higeke akeno anage huno znantahige'ne, Na'a higetna ne' mofavre'rmina zamahe ofrita zmatrake'za mani'naze? ");
INSERT INTO kbq_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mofavrema zamaza huke kasezmi a'tre'mokea amanage huke Ferona kenona'a hunte'na'e, Hibru a'ne'mo'za zamagra Isipi a'negnara osu'za hanavenentake hu'nazanki'za, uohanati'nonke'za hanatinonke'za ame'ama hu'za mofavrea kasenentaze. ");
INSERT INTO kbq_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ana higeno Anumzamo'a mofavrema zamazama huke kasezami a'tre'na knare huznantegeno, Israeli vahera kase hakare hazage'za hanavenentake vahetami rama'a fore hu'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ana a'tremokea Anumzamofonku koro nehaku huno Anumzamo'a asomu huznantegeke znagranena agafa huke mofavre kasente'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Anante Fero'a ana maka Isipi vahe'a amanage huno hanavenentake ke huzmante'ne, Hibru a'nemo'zama ne' mofavrema kasezmantesazana, zmavaretma Naeli timpi matevu nezmatreta, mofa'nema kasezmantesagetma ozmahe zmatrenke'za maniho. ");
INSERT INTO kbq_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ana knafina mago Livae nagapinti ne'mo'a, mago ara Livae nagapinti erigeno, ");
INSERT INTO kbq_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","amu'ene huno ne' mofavre ksenteno, keana hiranto mofavre fore'ma higeno, 3'a ikamofo agu'afi frakino antegeno mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Hianagi ana mofavre'mo ra huno 3'a ikama higeno mago'ane frakintega'ma nosuno'a, ekaeka ku tro huno, kolta fukinuti renkanireteno, ana mofavrea ana ekaekapi anteteno erino Naeli tinkenafi me'nea uha trazampi ome frakino ante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ana mofavremofo nesaro'a agrite'ma fore haniaza kenaku ogantu'a mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Fero mofa'mo ti frenaku, eri'za mofa'nene Naeli tinte erami'za, ana tinkenare nevu'za ekaekara uha trazampi me'negeno negeno, eri'za mofa'a huntegeno omerino eme ami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ana mofa'mo'ma ekaekama erinagino keana, ana mofavremo'a zavitegeno, asuntagi nenteno anage hu'ne, Ama Hibru vahe'mokizmi mofavre. ");
INSERT INTO kbq_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Anante ana mofavremofo nesaro'a, Fero mofara antahigeno, Knare vu'na mago Hibru ara ome avre'na anenkeno mofavrea kegava krigantegahifi? ");
INSERT INTO kbq_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Higeno Fero mofa'mo'a anage huno hu'ne, Vunka kema hanaza hunka ome avrenka eno huno huntegeno, ana mofa'mo'a vuno ana mofavremofo nerera ome avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fero mofa'mo'a amanage huno ana ara asmi'ne, Ama mofavrea avrenka ome kegava krinante'nege'na, miza segantaneno, higeno ana mofavrea avreno kegava krinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ana mofavre'mo'ma rama higeno avreno Fero mofate vigeno, Fero mofa'mofo zage mofavre'aza higeno, timpinti avre fegu'a atre'noe nehuno Mosese'e huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Hagi ana knafina Mosese'ma nena huteno, mago zupa vahe'amo'zama tusiza hu'za kazokzo eri'zama enerizarega nevuno keana, mago Hibru nera, Isipi ne'mo nehegeno ome negeno, ");
INSERT INTO kbq_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","omege emegema hiana mago vahera omani'negeno keteno, ana Isipi nera ahe frino ksepampi asente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Anante knazupa Mosese'a nevuno keana tare Hibru ne'tremoke zanagra zanagra ha' nehakeno ome neznageno, hazenkema agafama hu'nea nera antahigeno, Na'a higenka negafuna nehane? ");
INSERT INTO kbq_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Hianagi ana ne'mo'a ke'nona'a huno, Iza kvati'a maninenka refko hurantegahane huno kazeriotine? Kagra Isipi ne'ma ahe fri'nanaza hunka nahe frinaku nehano? Higeno Mosese'a koro nehuno antahintahima hiana, vahe'ma ahe fri'noa zana hago e'ama hige'za antahi'naze hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Fero'ma ana kema nentahino, Mosesena ahe frinaku hianagi, Mosese'a atreno freno Midiani kumatega umaninaku vu'ne. Vuno mago tinkerire umani'nege'za, ");
INSERT INTO kbq_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","mago Midiani pristi ne'mo'a 7ni'a mofa'ne zmante'neanki'za, nezmafa sipisipine meme afu'tmimo'zama tima nesnagu tinkerire neazageno, ");
INSERT INTO kbq_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ruga'a sipisipi afu kva vahe'mo'za eme zmahenati trazageno, Mosese'a otino ana mofa'nea ome zamaza huno nezmafa sipisipi afutamine, meme afutamina ana tina afi zamige'za netageno, ");
INSERT INTO kbq_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ana mofa'nemo'za nezmafa Ruelinte (Jetro) uhanatizageno anage huno zmantahigene, nahigeta menina hantaka huta aze? hige'za, ");
INSERT INTO kbq_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ruga'a sipisipi kva vahe'mo'zama tahemanenatiza vahera, mago Isipi ne'mo taza huno zmahenenatino, sipisipiti'anena taza huno tina afizmi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Anante Rueli'a (Jetro) zmantahigeno, ina ana nera mani'ne? Nahigeta atreta e'naze? Ome kehinkeno kave emeneno, hige'za ome avre'za azageno, ");
INSERT INTO kbq_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mosese'a zmagranema manisigu mago arimpa higeno Rueli'a (Jetro) mago mofa'a, Zipora amigeno a' eri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora'a amu'ene huno ne' mofavre ksentegeno, Mosese'a rurega ne'mo'na kraga emani'nogu agi'a Gesomu'e hu'na ante'mue. ");
INSERT INTO kbq_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Za'za kna evutegeno Isipi kini nera fri'ne. Hianagi Israeli vahe'mo'za tusi'a knazama eri'za kazokzo eri'za eneri'za, Anumzamofontega zavi krafa hu'naze. Ana zavi krafa zimimo'a Anumzamofo avure marerigeno, ");
INSERT INTO kbq_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Anumzamo'a ana zavi krafazamia antahinezamino, Abrahane, Aisakine, Jekopunema huvempa huno huhagerafi'nea kegu agesa antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Anumzamo'a Israeli vahera nezmageno, knazampima mani'nazazana keno antahino hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosese'a nenemo, Jetro Midiani pristi ne'mofo sipisipi afu tamine meme afutami kva nehiankino, mago zupa, ana sipisipi afutamine meme afutami zamavareno ka'ma mopamofona mago kaziga asoparega afete vuno Anumzamofo agona, Horepi mago agi'a Sainaie nehaza agonare uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Anante Anumzamofo ankeromo'a, mago zafafina tevemo hagana hagana huno nerefi efore higeno, Mosese'ma keana tevemo'a hagana hagana huno te'neanagi, ana zafa tevea ore'ne. ");
INSERT INTO kbq_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ana higeno Mosese'a amanage huno hu'ne, Ruzahu'za huno zafa tevea oreanki, anante vu'na ome kesue nehuno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Hagi Anumzamo'ma kegeno Mosese'ma kenaku vutava'o nehigeno'a, ana zafafinti Anumzamo'a kezatino, Mosesewe! Mosesewe! higeno Mosese'a ama mani'noe higeno, ");
INSERT INTO kbq_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Anumzamo'a asmino, Mago'anena eravao osunka, kagia anona kazufe atro, na'ankure menima oti'nana mopamo'a ruotage hu'nea mopare oti'nane. ");
INSERT INTO kbq_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Anante mago'ane Anumzamo'a amanage hu'ne, Nagra kafahe'i Anumzane, Abrahamu Anumzane, Aisaki Anumzane Jekopu Anumza mani'noe, huno higeno Mosese'a Anumzamofoma ke'zanku koro huno avugosa refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ra Anumzamo'a amanage hu'ne, tamage hu'na Isipi kumapi'ma vahe'niamo'zama mani'ne'za zmatazama e'neri'za zana, hago Nagra nege'na, zavi krafama hazana antahi'noe. Na'ankure kazokzo eri'za kva vahe zami'mo'za, zmatazama zamizazana ke'na antahi'na hu'noe. ");
INSERT INTO kbq_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","E'ina hu'negu, Nagra erami'na Isipi vahe hanavefinti zamavre fegu'a zmatre'na, masavenke huno knare zantfa hu'nea mopama, kaomofo amirine tumerimo'ma avi'mate'nea mopa Kenani vahe mopama, Hiti vahe mopama Amori vahe mopama Perisi vahe mopama, Hivi vahe mopama Jebusi vahe mopa, ra mopa zamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Menina antahio, Israeli vahe'mokizmi zavira nentahi'na, Isipi ma zamazeri havizama haza zana hago ke'na antahi'na hu'noe. ");
INSERT INTO kbq_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","E'ina hu'negu menina ege'na huganta'nenkenka Feronte vunka, Israeli vahe'ni'a, Isipi kumapintira zmavrenka atiramigahane. ");
INSERT INTO kbq_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Hianagi Mosese'a amanage huno Anumzamofona asmi'ne, Nagra iza'na Ferontera vu'na Isipitira, Israeli vahera zamavare'na atiramigahue? ");
INSERT INTO kbq_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Anumzamo'a anage hu'ne, Nagra tamage hu'na kagrane manigahue. Nagrama Israeli vahe zmavrenka atiramiogu'ma hugantoa zamofo avame'zana, Israeli vahe'ma Isipiti'ma ome zmavrenka atiramisunka, Nagrira monora ama agonare eme hunantegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Anante Mosese'a amanage huno Anumzamofona asmi'ne, Antahio, nagrama Israeli vahetegama vu'na, anage hu'na ome zmasamigahue, tamafahe'i Anumzamo tamagritega hunantege'na oema hanuge'zama nantahige'za, agi'a iza'ema hanage'na? na'ane hu'na zamasamigahue? ");
INSERT INTO kbq_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Higeno Anumzamo'a amanage huno Mosesena asmi'ne, Nagra mani vava nehumo'na Nagrake Mani'noe, kagra amanage hunka Israeli vahera ome zamasamio, Nagre nehia ne'mo, hunantege'na tamagritega oe hunka huo. ");
INSERT INTO kbq_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mago'ane Anumzamo'a Mosesena asmino, Israeli vahera amanage hunka ome zamasamio, Ra Anumzamo'na tamafahe'i Abrahamu Anumzane, Aisaki Anumzane, Jekopu Anumzamo'a tamagritega hunantege'na oe. Ama'i nagimo'a mevava hanigeno, henkama fore'ma hanaza vahe'mo'za ama ana nagimofona ahentesga hu'za antahinami vava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Israeli kva vahera ome zamazeri tru hunka zmasmio, Ra Anumzamo'a tamafahe'i Anumzane, Abrahamune Aisakine Jekopune Anumzamo efore huno amanage huno nasami'ne, Nagra tamage hu'na tamagrikura nentahi'na, Isipi vahe'mo'zama hurmantaza zana ke'noe. ");
INSERT INTO kbq_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ana hu'negu Nagra huvempa hu'noa ke amage ante'na Isipi kumapima mani havizama hu'nazafinti tamavre fegu'ate'na tamavre'na Keneni vahe'ma, Hiti vahe'ma, Amori vahe'ene, Perisi vahe'ma, Hivi vahe'ma Jebusi vahe'mokizmi mopa masevenke huno knare zanfta hu'negeno, kaomofo amirimo'ene tumerimo avite'nea mopafi tamavreno vugahie hunka ome zamasamio. ");
INSERT INTO kbq_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Kema hananana, Israeli kva vahe'mo'za ke ka'a antahigahaze. E'ina hnageta kagra Israeli kva vahe zamavrenka Isipi rankva nete vuta amanage huta asamiho, Ra Anumzana Hibru vahe'mokizmi Anumzamo tagrite eama hu'ne. Hagi muse hugantonanki knare tatrenanketa tagufa zagegnafina ka'ma kopina vuta Ra Anumzatimofontega ofa ome kre sramana vuntamaneno hutma asamiho. ");
INSERT INTO kbq_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Hianagi Nagra antahi'noe, Isipi kini ne'mo'a tamatresnigeta ovugosaze. Hagi mago hankvenentake azamo'ma ha'ma rentesnigeno'a tmatresnigeta vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","E'inama hanige'na Nagra nazana erisga hu'na maka ruzahu ruzahu kaguvazana eri fore amu'no zamifina ha'nenke'za, tamatresnigeta vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nagra Isipi vahe zamufina rantamagi taminenketa Isipi vahe'ma zamatreta, vanuta amne tamavapara ovugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Hu'neanagi maka Israeli a'nemo'za no magote nemanisnaza a'nanene no zamifi nemsesnaza a'ne'mokizmia silvane golire'ma tro'ma hu'nesaza zantamine, kukenagu enena zmantahigesage'za tamisagetma, ne' mofatmimofona eri hankre zmanteho. E'inama hanutma Isipi vahe'mofona knare fenozazamia eri hana hutma vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosese'a Ra Anumzamofo kenona hunteno, Ke'niama antahi onamige, zamentintima osanageno'a nankna hugahie? Na'ankure zamagra amanage hu'za Kagrikura hugahaze. Ra Anumzamo'a kagritera efore osu'ne hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Anante Ra Anumzamo'a anage huno antahige'ne, Na'a kazampina me'ne? huno antahigegeno Mosese'a azompani'e higeno, ");
INSERT INTO kbq_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ana azompa mopafi atro, higeno Mosese'a mopafi atregeno, ana azompamo'a osifave fore higeno, Mosese'a atreno kore fre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hagi Ra Anumzamo'a anage huno Mosesena asami'ne, Kazana antenka risonare azeri sga huo, higeno Mosese'a aza antegantuteno risonare azeri sga higeno, ete azompa fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Anumzamo asmino, e'inahu'za fore hanige'za, Ra Anumzana nezmafa Abrahamu Anumzane, Aisaki Anumzane Jekopu Anumzamo kagrite efore hu'ne hu'za zamentinti hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mago'ane Ra Anumzamo'a amanage huno asmi'ne, Hagi menina nakre kuka'afi kazana vazio, higeno Mosese'a azana nekre ku'afi vaziteno erizafigeno, leprosi namumo ana azampina fore huno efenentake hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Anante Ra Anumzamo'a amanage hu'ne, Hagi menina ana nakre kuka'afi kazana ete vazio, higeno Mosese'a ana azana ana nakre ku'afi eteno vaziteno erizafigeno, ana leprosi namuna fanane huno avufgamo'a knare huno ruga'a avufga'mo'ma me'neaza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ra Anumzamo'a Mosesenkura anage huno asami'ne, Zamagrama kota avame'zamofonku'ma zamentinti osuge, antahi ogamisagenka, henka avame'za hnanke'za negesu'za zamentinti hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Hu'neanagi tare avame'zamofonte'ma nege'za zamentinti nosu'za keka'a ontahisnagenka, Naeli timpinti mago'a tina afinka hagege mopafi tagi tro. E'ina'ma hanankeno'a ana timo'a hagege mopafina kora fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mosese'a Ra Anumzamofona amanage huno asmi'ne, Muse hugantoanki Ra Anumzamoka nagra kea huso'e nosu'na, korapa anahu hu'na mani'na e'noe. Meninena nagrane kegaga hananagi nagefu'namo'a kema huzampina knarera osige'na, kea hu so'e nosue. ");
INSERT INTO kbq_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ra Anumzamo'a kenona huno, Iza vahe zamagira tro huzmante'ne? Iza ke osu vahero, zamagesa ankanire vahero, zamavu knarehu vahero, zamavu suhu vahera zamazeri nese? Nagra Ra Anumzamo'na e'inara hunezmantoe. ");
INSERT INTO kbq_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","E'ina hu'negu menina kagra vuge'na, Nagra kagrane mani'nena, kema hnana kea hugasmisnugenka hugahane. ");
INSERT INTO kbq_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Hianagi Mosese'a amanage huno ke'nona hu'ne, Ra Anumzamoka muse hugantoanki mago'a vahe huzmanto. ");
INSERT INTO kbq_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Anante Ra Anumzamo'a Mosesena rimpahenteno anage hu'ne, Anantega negafu Livae nera Aroni'a omaninefi? Nagra antahi'noankino agra knare zantfa huno kea hugahie. Hanki agra kantega eme tutagiha hugantenaku ne-eankino, eme kagesuno'a agu'areti huno musena hugantegahie. ");
INSERT INTO kbq_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Emema kagesnigenka, kema hania kea retro humige'na, Nagrani'a kagri kagite'ene agri agite'enena mani'nena inankna kea hugaha'e, rempi huranamisnugeta kea hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aroni'a kagri kagi erino vahe'ma kema zmasami vahe mani'nigenka, kagra Anumzankna hunka agritera mani'nenka vahe'ma zmasamisia kea asamigahane. ");
INSERT INTO kbq_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Hagi menina kagra kama vanohu azompa ka'a, avame'zama erifore'ma hananku erio. ");
INSERT INTO kbq_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Anantetira Mosese'a atreno nenemo ne' Jetronte vuno amanage hu'ne, Muse hugantoanki natrege'na ete Isipima mani'naza nafu nganaheintega vu'na, ofri mani'nazo ome zamaga'neno, higeno Jetro'a krimpa frune vuo huno hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mosese'a Midiani kumate mani'negeno Ra Anumzamo anage huno asmi'ne, Etenka Isipi vuo, na'ankure kahe fri'nakurema hu'naza vahe'mo'za ko' fri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Anage higeno, Mosese'a tare mofavre'ane nenarone zamavreno donki afu'mofo agofetu nezmanteno, Anumzamofo azompa'a azampi azerige'za Isipi vunaku vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ra Anumzamo'a Mosesena anage huno asmi'ne, Isipima ete uhanatisunka, kaguvazama erifore huogu'ma hankvema kami'noa hanavereti Fero avuga maka kaguvazana erifore huo. Hu'neanagi Nagra arimpa azeri hankvetisugeno Israeli vahera zmatresnige'za ovugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kagra anage hunka Ferona asamio, Ra Anumzamo'a amanage huno hu'ne, Israeli vahera kota ne' mofavre'ni'e. ");
INSERT INTO kbq_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","E'ina hu'negu Nagra anage hu'na kasami'noe, Israeli vahera zmatrege'za vu'za monora ome hunanteho. Hianagi kagra ke'ni'a ontahinka zmatranke'za ovu'nazagu, antahio, Nagra kota ne' mofavreka'a ahe frigahue! ");
INSERT INTO kbq_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mosese'ene naga'amo'za Isipi vunaku karanka nevu'za hani hige'za masenaku hazare, Ra Anumzamo'a Mosesena emegeno ahe frinaku hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Hianagi anante Zipora'a mago asne'nea have kazi erino, nemofo oku avufamofo anoma'a taga huno, Mosese agiafi ome netreno anage hu'ne, kagra tamagerfa hunka nagritera kora eri tagi nenavega mani'nane hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ana higeno Ra Anumzamo'a Mosesena ahe ofrigeno, Zipora'a amanage hu'ne, kora eri tagine'moka nenavezana hu'nane, na'ankure ne' mofavre'amofo oku avufga anoma'a taga hu'neazanku hu'ne. (Jen-Agf 17: 9-14). ");
INSERT INTO kbq_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Hagi Ra Anumzamo'a Aronina asmino, Ka'ma moparega vunka Mosesena omego, higeno Aronia vuno Anumzamofo agonare Mosesena omegeno agi antako nehuno, azeri frufra hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ra Anumzamo'ma maka kema Mosesema nesamino, avame'zantmima huvenerino, ana avame zantmima omeri fore huo huno'ma hunte'nea kante anteno, ana maka kene avame'zanena Aronina asami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Anante Mosese'ene Aronikea vuke maka Israeli vahe'mokizmi kva vahetmina ome zamazeri atru hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Anante Aroni'a Ra Anumzamo'ma Mosesema asmi'nea kea ana maka Israeli vahe'mokizmi nezmasamino, avame'zantamina zamavurera erifore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Israeli vahe'mo'za zamentinti nehu'za, Isipima zamazeri havizama hu'naza zama Anumzamo antahino keno'ma hu'nea nanekema Aroni'ma zamasamige'za nentahi'za, Israeli vahe'mo'za kepri hu'za Anumzamofo mono hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Henka Mosese'ene Aronikea Feronte vuke amanage huke ome asmi'na'e, Ra Anumzana Israeli vahe'mokizmi Anumzamo'a amanage nehie, zmatrege'za vahe'ni'amo'za vu'za kama mopafi ranagima nami ne'za ome retro hu'za neho. ");
INSERT INTO kbq_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Hianagi Fero'a ke'nona huno, Ra Anumzana i'za mani'nesigu ke'a antahi'na Israeli vahera zamatresnuge'za vugahaze? Nagra Ra Anumzana ke'na antahi'na osu'noanki'na, nagra Israeli vahera zmatresuge'za ovugahaze! ");
INSERT INTO kbq_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mosese'ene Aronikea huke, Hibru vahe'mofo Anumzamo eme tagrite eama huno, ka'ma kopi 3'a zagegnafi kana vuta, kresramna Ra Anumzantia hunteho hu'ne. Hanki anama osanunkeno'a knazantetiro, kazintetiro tahe frigahie. ");
INSERT INTO kbq_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Hianagi Isipi kinimo'a, ete kenona huznanteno, Na'ante Israeli vahe'mokizmia eri'za zmifintira zmavre rurega atre'za neha'e? Eteta eri'zantaniare vi'o! ");
INSERT INTO kbq_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Mago'ane Fero'a huno, ke'o, ama Israeli vahe'mo'za rama'a nehzageta, tanagra eri'za zmifinti zmaretre'za neha'e. ");
INSERT INTO kbq_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Fero'a ana zagefinke kazokzo eri'za vahe'mokizmi Isipi kva vahe'ene, eri'za kva hu'naza Israeli vahera zamasmino, ");
INSERT INTO kbq_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","trazamofo rampa'a zamizage'zama mopanema eri havia hu'ne'za heru'za briki'ma tro nehaza zana mago'ane ozmiho, hagi zmatrenke'za trazamofo rampa'a, zamagra'a ome eritru hu'za eri'za eho. ");
INSERT INTO kbq_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Hianagi korapara nama'a briki tro hutere nehaze, e'i ana kanteke tro hutere hugahaze. Hagi hinke'za erami'za osi'a trora osiho. Na'ankure zamagra feru vahe mani'nazagu, tatregeta vuta Anumzamofona ofa ome kresramna vuntamaneno hu'za krafa nehaze. ");
INSERT INTO kbq_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ama ana vahera mago'ane knama hu'neni'a eri'za zaminke'za eneri'za, ama havige kemofona ontahiho! ");
INSERT INTO kbq_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kazokzo eri'za vahe'mokizmi kva ne, erizante vugagota hu'naza vahe'mo'za, Israeli vahete vu'za amanage hu'za zamasami'naze, Fero'a amanage huno hu'ne, Nagra magore hu'na trazamofo rampa'a ontamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Tamagra'a vuta inantegatiro trazamofo rampa'a ome haketa eriho. Hianagi korapa'ma tro'ma nehaza avamenteke brikia tro hinkeno brikimofo nampamo'a evuoramino. ");
INSERT INTO kbq_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ana higeno Israeli vahe'mo'za ana maka Isipi mopa'afina briki'ma tro'ma hu'zana traza rampa eri atru hanagu, vu'za e'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kazokzo eri'za vahe'mokizmi kva vahe'mo'za, hu tutu huzmante'za, trazamofo rampama neramunketama mago zagefima eneriza avamente eri'zana eriho. ");
INSERT INTO kbq_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Isipi kva vahe'mo'za, Israeli eri'za kva vahete vu'za ome nezmahe'za anage hu'naze, nahigeta okine meninena ko'ma tro'ma nehaza avamentera brikia trora osu'naze? ");
INSERT INTO kbq_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Israeli eri'za kva vahe'mo'za Feronte vu'za krafage ome nehu'za, nahigenka eri'za vahekamota amanahu kavu kvara hunerantane? ");
INSERT INTO kbq_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hanki eri'za vahekamota trazamofo rampa'a ontami'ne'za, brikia tro hiho huvava hunerantaze. Hanki ko, eri'za vahekamota sefu neramizanagi, hazenkea kagrika'a vahepi me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Hianagi Fero'a anage huno kenona huzmante'ne, Tamagra tusi'a tamavresrage vahere! E'ina hu'negu tamagra hutma, tatrenketa vuta Ra Anumzamofontera ome kresramna vuntamneno hutma nehaze. ");
INSERT INTO kbq_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Eteta eri'zantamirega ko viho. Magore hu'za trazamofo rampa'a ontamigosazanki, nama'a briki'ma troma huterema nehaze avamenteke maka brikia tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Eri'zante'ma ugagota hu'naza Israeli kva vahe'mo'zama antahizageno, magoke magoke knare'ma tro'ma nehazankna avamente brikia tro hugahaze hige'za, hazenkefi manune hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Feroma atre'za nevu'za, Mosese'ene Aronikea zmavega anteke oti'nake'za ome nezanage'za, ");
INSERT INTO kbq_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","anante amanage hu'za ome znasmi'na'e, Ra Anumzamo neranegeno tanagrama ha'a avu'ava zantera kea huno refko huranantesie. Na'ankure tanagra Fero avufine eri'za vahe'amokizmi zamavufina, tazeri himna nevuta tazeri haviza huta, tahe frihogu zamazampi kazinkano erinteankna hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mosese'a ete Ra Anumzamofonte vuno amanage ome hu'ne, Ra Anumzamoka, na'a higenka Israeli vahera hazenkefina zmavrenentane? Na'a higenka vuo hunka hunantanke'na e'noe? ");
INSERT INTO kbq_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hanki Feronte'ma umahanati'na Kagri kagima he'na kema humanantana kema huanknareti'ma e'neana, agra Israeli vahera rama'a hazenkea zami'neanagi, Kagra magore hunka ana knazampintira zamaza osu'nane. ");
INSERT INTO kbq_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Anante Ra Anumzamo'a anage huno Mosesena asmi'ne, Kagra menina na'ano Feroma huntesnua zana kegahane. Nagra hankaveni'areti atufenugeno, Fero'a hankavetino hunezmanteno, maka mopa'afinti'enena zamahe'natisige'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mago'ane Anumzamo'a Mosesena amanage huno asmi'ne, Nagrake Ra Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagra Abrahamune Aisakine Jekopukizmi zamavure'ma efore'ma hu'noa hanavenentake Anumzane, hianagi nagi'a Ra Anumzane hu'na ozamasmi'noe. ");
INSERT INTO kbq_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Hanki zamagra ruregati vahekna hu'za Kenani mani'nazage'na, Nagra huvempa ke huhagerafina Kenani mopa zamigahue hu'na hu'noe. ");
INSERT INTO kbq_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Mago'ane Isipi vahe'mo'ma Israeli vahe'ma kazokzo eri'zampi zmante'nazage'za kragi'ma neru'za krafage'ma nehazama'a nentahi'na huvempa hu'na huhagerafi'noa kegu nagesa antahi'noe. ");
INSERT INTO kbq_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","E'ina hu'negu amanage hunka Israeli vahera ome zmasmio, Nagra Ra Anumzanki'na, Isipi vahe'mo'za kazokzo eri'zama tamigeta e'nerizafintira, Nagra'a nazana rusute'na rama'a hanave knazana Isipi vahera nezami'na, keaga huzmante'na Israeli vahera ete'na zamavaregahue. ");
INSERT INTO kbq_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nagri vaheni'a mani'naze hu'na neramavrena, Nagra tamagri Anumza manisugeta, Isipi vahe'mofo kazokzo eri'za vahe mani'nonkeno tavreno atirami'nea Ra Anumzane hutma antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nagra Abrahamu'ma Aisaki'ma Jekopuma zamigahue hu'na huvempama huzmante'noa mopare tamavre'na vugahue. Nagra ana mopa tamisugeno tamagri zane huno megahie. Nagra Ra Anumzamo'na hue! ");
INSERT INTO kbq_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mosese'a ama ana kea Israeli vahe zmasmi'neanagi, kema hiana ontahi'naze. Na'ankure Isipi vahe'mo'za tutu huzmantage'zama hanavenentake kazokzo eri'zama eri'naza zamo antahintahi zmimofona ahe haviza hige'za ontahi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ana higeno Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Vunka Isipi kini ne' Ferona ome asamigeno, Israeli vahera agra zmatrenke'za mopa'afintira viho. ");
INSERT INTO kbq_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Hianagi kenona'a Mosese'a Ra Anumzamofona anage huno asami'ne, Israeli vahe'mo'za kema hu'noa kea ontahi'nazanki, inankna huno Fero'a ke'ni'a antahi namigahie? Nagra kea hugara osu'noe. ");
INSERT INTO kbq_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hianagi Ra Anumzamo'a Mosesene Aronigiznia ke huno, Isipi kini ne' Fero kvafintira, Israeli vahera zmavre'za Isipi mopa atre'za vnagu hanave ke huzanante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ama'i Israeli naga nofi'mofonte ugagota hu'naza naga'mokizmi zmagi'e. Rubeni'a Israelina (Jekopu) kota mofavre'agino, Hanoku'ma Paru'ma Hesroni'ma Kami'ma, huno kasezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Hagi Simioni'a Keneni a'ma erino kasezmante'nea mofavre'rmina, e'i Jemueli'ma Jamini'ma Ohati'ma Jekini'ma Johari'ma Sauri'e. Zamagra Simioni naga nofire hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Hagi ama'i Livae'ma kasezmante'nea naga nofi'mofo zamagi'e, Gesoni'ma Kohati'ma Merari'e. Livae'a 137ni'a kafu mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Hagi Gesoni'ma kasezanante'nea mofavremokiznia znagi'a, Libini'ene Simeikegi'ne zanagra naga nofi zanirera ugagota hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Hagi Kohati ne'mofavreramimofo zamagi'a, Amrami'ma Izhari'ma Hebroni'ma Uzieli'e. Hagi Kohati'a 133'a kafuzage mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ne' mofavre'mokizni znagi'a, Mali'ene Musike. Ama'i Livae naga nofi'mofo zmagi'a kasezmante'nereti agafa huno meno e'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amrami'a nefana nesaro Jokebetina ara erigeno, Aronine Mosesene kasezanante'ne. Amrami'a 137ni'a kafu mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Hagi Izhari mofavreramina, Kora'ma Nefegi'ma Zikri'e. ");
INSERT INTO kbq_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzieli ne' mofavremokizmi zamagi'a, Misaeli'ma, Elzafani'ma Sitri'e. ");
INSERT INTO kbq_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroni'a Aminatapu mofa Erisebana Nasoni nesarona a' erigeno, Natapuma Abihuma Eriasama Itamama huno kasezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora ne' mofavremokizmi zamagi'a, Asiri'ma Erkana'ma Abiasavi'e. Zamagra Kora naga nofi mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aroni nemofo Eleaza'a Putieri mofa'nefinti mago mofa ara erino Finiasina kasente'ne. E'i naga'mokizmimpinti Livae nagara efore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Hagi ama ana Aroni'ne Mosesegizni Ra Anumzamo'a znasmino, Israeli vahera Isipi mopafintira nagate nofite zmavreta atirami'o huno huzanante'nea ne'trene. ");
INSERT INTO kbq_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","E'i ana ne'tremoke Israeli vahera Isipi mopafintira zamavareke atiraminaku, Isipi kini ne' Ferontera vu'ne ome keaga hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Hagi Ra Anumzamo'ma Isipi mopafima Mosesema kema asami'nea knafina, ");
INSERT INTO kbq_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","amanage huno Ra Anumzamo'a Mosesena asmi'ne, Nagra Ra Anumzane, Isipi kini ne' Ferona maka amama kasamua kea ome asmio. ");
INSERT INTO kbq_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Hianagi Mosese'a Ra Anumzamofo avufi amanage hu'ne, Antahio, nagra kema hu'arera knarera osu'noankino, inankna huno Fero'a keni'a antahigahie? ");
INSERT INTO kbq_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ana hutegeno Ra Anumzamo'a amanage huno Mosesena asmi'ne, Antahio, Nagra Fero avurera kazeri Anumzankna hanugeno, negafu Aroni'a kasnampa neka'a manigahie. ");
INSERT INTO kbq_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ana maka ke'ma Nagrama huoma hu'na hugantoa kea nehugeno, Israeli vahe'ma Fero'ma zamatresnige'za mopa'afinti'ma atre'za vanaza kea negafu Aroni'a kini nera asamino. ");
INSERT INTO kbq_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Hianagi Nagra Fero antahintahia eri hanaveti'nugeno tamatrenigeta novanage'na, ruzahu ruzahu kaguvazane avame zani'anena Isipi mopafina erifore hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Hagi Fero'a keka'a ontahigahianki'na, Nagra nazana rusute'na Isipi moparera ranra knazanteti kegaga hunezmantena, Nagra Israeli vahe'ni'a zamavare'na atiramigahue. ");
INSERT INTO kbq_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nagra nazama rusute'na Isipi vahe'ma ha'ma renezmante'na, Israeli vahe'ma amuno zmifinti'ma zmavre'na atiramisuge'za, Isipi vahe'mo'za Ra Anumzamo'e hu'za ke'za antahi'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mosese'ene Aronikea Ra Anumzamo'ma hi'oma huno znasmi'neaza hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mosese'a 80'a kafu higeno, Aroni'a 83'a kafu hu'neke Ferontera kea ome hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Anante Anumzamo'a Mosesene Aronigizni amanage huno znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Fero'ma kaguvaza erifore hi'oma hanigetna'a, Aronina asmigeno azompa'a matevuno mopafi Fero avuga atrenkeno, ana azompamo'a osifave efore hino. ");
INSERT INTO kbq_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mosese'ene Aronikea Feronte vuke Ra Anumzamo'ma znasami'nea kante anteke anazana hu'na'e. Aroni'a azompa Ferone eri'za vahe'amokizmi zamavuga atregeno, ana azompamo'a osifave fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Higeno Fero'a agranena antahi'zane vahe'ene avotaga vahe'ene Isipi kumapi kaguvaza erifore nehaza vahe'ene zamagi hige'za, zamagranena ana zanke hu'za oku'a tro hu'za ante'ne'za vahe'ma rezmatagama nehaza zantaminuti Aroni'ma hiaza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Mago magomo'za azompazmia matevu mopafi atrazageno, ana azompa zmimo'za osifavermi fore hazanagi, Aroni azompamo'a ana osivafermina zmasgahu nakri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hianagi Fero antahintahimo'a hanavetigeno, Ra Anumzamo'ma hu'nea kea ontahi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Hagi anante Ra Anumzamo'a Mosesena asmino, Fero antahintahimo'a hanavetigeno kea antahino Israeli vahera zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Hagi oki nanterama Fero'ma tintegama enevanire, osifavema fore hu'nea azompa kzampi eri'nenka Naeli tinkenare Ferona ome kenka, ");
INSERT INTO kbq_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","amanage hunka asmio, Ra Anumza, Hibru vahe'mofo Anumzamo kagrikura amanage hunka ome asamio huno hu'ne. Vahe'ni'a zmatrege'za vu'za ka'ma mopafi monora ome hunanteho hu'ne. Hianagi kagra eseteti'ma eno meninena ke'a ontahinka zmatranke'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","E'ina hanku Ra Anumzamo'a amanage hu'ne, amazama hanua zamo hinkenka, Nagrikura Ra Anumzane hunka antahigahane. Hagi nazampima azeri'noa azompanu, Naeli tina amasgisnugeno timo'a kora fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Hagi Naeli timpima mani'naza nozamemo'za frisnageno, ana timo'a hinimna vanige'za, Isipi vahe'mo'za ana tina onegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Anante Ra Anumzamo'a Mosesena asamino, Aronina amanage hunka asmio, azompaka'a erinka kazana rusutenka Isipi tintega nentenka, mika ranra tinte'ene, ne'one tintamintera kazana rusutegeno, timo'za kora fore nehina, kerifima mare'ne'nia timo'ene, zafare kavofine havere kavofinema me'neni'a timo'enena ana zanke huno koranke hino. ");
INSERT INTO kbq_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mosese'ene Aronikea Anumzamo hi'oma huno huzanante'nea zana hu'na'e. Aroni'a azompa'a erisga huno Fero avufine eri'za vahe'amokizmi zamufine, Naeli tina amasgigeno, ana maka timo'a kora fore higeno, ");
INSERT INTO kbq_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ana timpima mani'naza nozamemo'za frizageno, timo'a havizantfa huno hinimana vige'za Isipi vahe'mo'za tina onazageno, ana maka Isipi mopafima koramoke'za huvagare'ne. ");
INSERT INTO kbq_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ana hianagi Isipi kumapi kaguvaza erifore nehaza vahe'mo'za, oku'a tro hu'za antene'za vahe'ma rezmatagama nehaza zantminuti Aroni'ene Moseseke'ma erifore ha'a kaguvazana, zmagranena ana zanke hu'za eri'fore hu'naze. E'i anama hazageno Ra Anumzamo'ma hu'nea kante Ferona antahintahi'amo'a hankvetigeno, ke'znia ontahino zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Fero'a ana zantmima fore hiazankura ontahino, atreno rukrehe huno noma'arega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","E'ina hige'za maka Isipi vahe'mo'za Naeli timpintira tina one'za tima nesagu Naeli ti ankenarega keria kafi'za tinkura hake'naze. ");
INSERT INTO kbq_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Hagi Ra Anumzamo'ma Naeli tirama amasagigeno, korama fore huteretira 7ni'a zagegna evu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Anante Ra Anumzamo'a Mosesena asmino, Feronte vunka amanage hunka ome asamio, Ra Anumzamo'a amanage hie, zamatrege'za vahe'nimo'za vu'za, monora ome hunanteho hu'ne hunka ome huo! ");
INSERT INTO kbq_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Hagi kagrama zamatresnanke'zama ovanage'na maka Isipi mopafina, Nagra hogatmi huntanenke'za Isipi mopatamifina avite'za eri haviza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Naeli timpina hogamoke'za hugahaze. Ana hogamo'za timpintira atirami'za nonka'afi unefre'za nemsanpinkanena unefre'za nemsana sipaka'are enena umaneri'za nemaniza, eri'za vahe ka'amokizmi nompinena umaneneri'za vahe ka'amokizmi zmufgaregane umreneri'za, avenifinena unefre'za, witima krenaku'ma heneraza zompa'ramimpinena ufregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ana hanigeno hogamo'za kagri kagofetu takaunere'za, eri'za vahekamofontera takauregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Anante Ra Anumzamo'a Mosesena asmino, amanage hunka Aronina asmio, tira tintamimofone karaho tintmimofone tinkeriramimofo agofetu azompa ka'a kazampi erinka rusutegeno, hogatmimo'za emareri'za Isipi mopafina avitegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Anage higeno, Aroni'a Isipi tintamimofo agofetu azana rusutentere huno evigeno, Isipi mopafina hogatmimo'za tintamimpinti emreri'za avite'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Hianagi Isipi kumapi kaguvazama nehaza vahemo'zanena, oku zama ante'ne'za vahe'ma rezmatga nehaza zantminuti, ana zanke hazage'za Isipi mopafina hogatmimo'za fore hu'za emreri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Anante Fero'a Mosesene Aronigizni znagi huno amanage huno znasami'ne, Nunamu huta Ra Anumzamofona antahigekeno, noniafinti'ene vahe'niamokizmi nompintira, hogatamina Anumzamo'a zmavretrenke'na, Israeli vahera zmatranenke'za vu'za Ra Anumzamofonte ome Kresramana vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosese'a amanage huno Ferona asami'ne, Kagra kna antege'na Ra Anumzamofontega nunamuna hanugeno, nonka'afinti'ene eri'za vahe ka'amokizmi nompinti'ene vahe ka'amofo nompintira, ana hogatamina zamahe fanane nehuno, Naeli timpima mani'naza hogataminke zmatrenige'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fero'a okine higeno, Mosese'a amanage huno asmi'ne, kema hana kante anteno fore hanigenka, mago anumzamo'a tagri Ra Anumzanknara osu'ne hunka antahigahane. ");
INSERT INTO kbq_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ana maka hogamo'za kagriteti'ene, nonka'afinti'ene, eri'za vahe ka'afinti'ene, vahe ka'afinti'enena omanisageno, Naeli timpinke manigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ananteti Mosese'ene Aronikea Feroma atreke vute kea, hogama huntegeno Feroma azeri havizama hu'nea zanku, Mosese'a hanavetino Ra Anumzamofona antahige'ne. ");
INSERT INTO kbq_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Hagi Mosese'ma nunamuma huno antahigea kante anteno, Ra Anumzamo'a ana higeno, hogamo'za nontmimpinti'ene kumapinti'ene hozafinti'enena mika fri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ana hige'za Isipi vahe'mo'za kevure kevure ana hogatamina zogitru hazageza, kasri'za mika Isipi mopafina hinimna vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Hianagi Fero'ma kegeno hogatamimofo knazama evigeno'a, Ra Anumzamo'ma Agrama hu'nea kante anteno, Ferona antahintahi'a azeri hanavetigeno, Mosesene Aronigizni kea ontahi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Anante Ra Anumzamo'a Mosesena asmino, Aronina amanage hunka asmio, azompaka'a erinka kugusopa amasagigeno, maka Isipi mopafina ana kugusopamo'a umpe umpetmi fore hino hunka asamio. ");
INSERT INTO kbq_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mosese'ene Aronikea Ra Anumzamo'ma znasmiaza hu'na'e. Aroni'a azompa'a erino kugusopa amasagigeno umpe umpetmi ana kugusopamo'a fore huno, vahe zamufgare'ene vahe'mo'ma kvama nehia zagaraminte'ene maka Isipi kuma'afi mani'naza zagaramimofo zmufgare'enena mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Isipi kumapi kaguvaza erifore nehaza, oku'a tro hu'za antene'za vahe rezmatga nehaza zanteti, ana zanke hu'za umpe umpe eri fore hunaku hu'nazanagi, erifore hugara osazageno, umpe umpetmimo'za vahe zmufgare'ene kegavama nehaza zagaramimofo zamufgarega mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kaguvaza erifore nehaza vahe'mo'za Ferona amanage hu'za asmi'naze, Anumzamofo azamo ama zana hunerante, hu'za hazanagi Anumzamo hu'nea kante Ferona anthintahi'amo'a hanavetigeno antahi ozami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Anante Ra Anumzamo'a Mosesena asmino, Nanterame otinka Fero'ma tintegama enevanire avure ome otinka amanage hunka asmio, Ra Anumzamo'a huno zmatrege'za vahe'niamo'za vu'za, monora ome hunanteho hunka asamio. ");
INSERT INTO kbq_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Hagi kagrama vahe'ni'ama zmatresnanke'za ovanazana antahio, Nagra kagrite'ene, eri'za vahe ka'are'ene, vahe ka'are'ene nonka'armimpine, Isipi vahe nontamimpine, mopafinena ana zanke hu'za kosintamina hunta'nena mani avitegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Hianagi Nagra Goseni mopafima vahe'nima mani'naza kumara atresugeno ana kosimo'za omanigahaze. E'ina hanugenka kagra kenka antahinka hananana, Ra Anumzamo ama mopa kegava hu'neno makazana nehie hunka antahigahane ");
INSERT INTO kbq_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Hagi mago avame'zanu vahe ka'ane, vahe'niamokizmi amuno zmifina, ante'na refko okina hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hagi Ra Anumzamo'a kema hu'neaza higeno, kosintmimo'za Fero nompine, eri'za vahe'amofo nontmimpina tusi'za hu'za vazipanini hu'za kizakiza hu'naze. Ana maka Izipi mopamofona kosimoke'za higeno havizantfa hu'ne. Na'ankure ana maka mopafina kosintmimo'za vazipanini hu'za kizaki'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Fero'a Mosesene Aronigizni zanagi huno anage huno znasmi'ne, Isipi mopa'afi vutma Anumzantmimofontega ome Kresramana vunteho. ");
INSERT INTO kbq_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Hianagi Mosese'a asmino, e'inama hanunana knarera osugahie. Na'ankure Isipi vahe'mofo zmavurera zmagoteno zmavresra haniaza hugahunankino, have knonu tahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Hagi Ra Anumzanti'mo hurante'nea kante anteta tagufa zagegna, ka'ma moparega vuta kre sramana vuntegahune. ");
INSERT INTO kbq_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Higeno Fero'a huno, Tamatranenketa ka'ma mopafi vuta Ra Anumzamofontera ome kresramna vuntegahazanagi, afetera ovutma, tavaonte nevutma nagrikura nunamu hutma antahigenkeno naza hino. ");
INSERT INTO kbq_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosese'a amanage hu'ne, kagritetira ufegu'a nevanu'na, Ra Anumzamofonte nunamu hane'na kagri'ene eri'za vahe'kane, vahekafintira kosina hunte'na okina omanigahaze. Hanki reravatga hunka Ra Anumzamofona ome kresramna vunteho hunka osuo. ");
INSERT INTO kbq_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hagi Mosese'a Ferona atreno vuno Ra Anumzamofonte ome nunamu higeno, ");
INSERT INTO kbq_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mosese'ma antahi'geaza huno, Ra Anumzamo'a Feronteti'ene eri'za vahe'areti'ene vahe'afintira ana maka kosintamina zamazeri atregeno magore huno omanitfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Hianagi mago'ane ko'ma hu'neaza huno Fero antahintahia eri hanavetigeno, Israeli vahera zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Anante Ra Anumzamo'a Mosesena asmino, Feronte vunka amanage hunka ome asamio, Ra Anumzana Hibru vahe'mokizmi Anumzamo amanage hie, zmatrege'za vahe'niamo'za vu'za, monora ome hunanteho hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Hagi kagrama huo zmantenkama kazigazi hunkama zamazeri sanana, ");
INSERT INTO kbq_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","antahi'o, Ra Anumzamofo aza'mo'a tusi knazanteti, hosi afu'tamine tonki afu'tamine, kemori afu'tamine kao afu'tamine meme afu'tamine sipisipi afu'tminka'a zamazeri havi'za hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Hianagi Israeli vahe'mokizmi sipisipiraminte'ene meme afutmimofone, Isipi vahe'mokizmi afutamimofo amu'nompina mago avame'zama eri fore'ma hanuana, Israeli vahe'mokizmi afu tamimo'za magore hu'za ofrigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ra Anumzamo'a e'i ana zama hania kna huhamprinteno anage hu'ne, oki ana zana Isipi mopafina hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kema hu'nea kante, anteno, ana knarera Ra Anumzamo'a anazana higeno, maka Isipi vahe'mokizmi afu kevumo'za fri'nazanagi, Israeli vahe'mokizmi afu kevumo'za magore hu'za ofri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fero'a vahe'a huzmantege'za vu'za ome kazana, magore huno Israeli vahe'mokizmi afu kevumo'za ofri'nazanagi, Fero antahintahimo'a hanavetigeno zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Anante Ra Anumzamo'a Mosesene Aronigiznia anage huno znasmi'ne, Brikima kre teve tampinti tanefara ome kateta, Fero'a negenkeno ana tanefara Mosese'a matevu nagamu atreno. ");
INSERT INTO kbq_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ana tanefamo'a mika Isipi mopa'afina kugusopage fore huno, Isipi vahete'ene agigu'agigu afu'zagamofo zmavufarera usge namu propru huno Isipi mopafina zamazeri haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Higeke zanagra brikima kre tampinti tanefa kateke, Fero avure vuke, Mosese'a ana tanefara matevu anagamu atregeno, Isipi vahe'ene agigu'agigu afuzmimofo zmufarera usage namuntami propru huno fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Isipi kumate havige kaguvazama nehaza vahe'mo'za Mosese avuga otigara osu'naze. Na'ankure zamagri zmavufgare'ene, maka Isipi vahe'mokizmi zmavufgare'enena usagentmi fore huno propru hu'ne ");
INSERT INTO kbq_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Hianagi Ra Anumzamo'ma ko'ma Mosesema asmi'nea kante anteno, Fero antahintahia Agra'a eri hanavetigeno, Mosesene Aroni'gizni kea ontahi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Anante Ra Anumzamo'a Mosesena asmino, Nanterame otinka Fero avure uhanatinka amanage huo, Ra Anumzana Hibru vahe'mokizmi Anumzamo amanage huno hie, vahe'nia zmatrege'za vu'za monora ome hunanteho hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Anama osnanke'na Nagra menina eri'za vaheka'are'ene, vahekafinena, Nagra tusi'a knaza zami'na zamazeri haviza hanugenka, kagra antahinka kenkama hananana magore huno Nagri kna anumzana, maka mopafina omani'ne hunka antahigahane. ");
INSERT INTO kbq_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Na'ankure ama knare'ma ehanatiana Nagra nazana rusute'na knazanteti tmazeri havizana hugetma ama mopafina omanizasine. ");
INSERT INTO kbq_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Hianagi tamage hu'na ama agafare kagrira katrogenka mani'nane, hihamu hankveni'a kagrite eri'ama nehanugeno, maka mopafi vahe'mo'za nege'za Nagri Nagi'a huama hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kagra kazikzi hunka kagi'a erisga nehunka, vahe'ni'a ha' rezmantenka zmatranke'za novaze. ");
INSERT INTO kbq_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","E'ina hanku antahio, okina ama ana knarera, Isipi kuma'ma fore huno meno menima e'neregatira oru'nea kna ko'mopa ko hunta'nenkeno rugahie. ");
INSERT INTO kbq_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ana hu'negu menina ame hunka huzmantege'za sipisipine meme afu zagaka'ane fegu'ama kegavama nehanana zagaraminka'a ana maka zmavre nomofo agu'a zmanteho, na'ankure ko'mopa ko aruno fegu'ama mani'nesnaza vahe'ene sipisipine meme afutamina zamahe frigahie. ");
INSERT INTO kbq_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Fero eri'za vahe'mo'za Ra Anumzamofo kegu'ma kore'ma hzamo'za, ame hu'za vu'za kazokzo eri'za vahe'zmine, sipisipine meme afu zminena zmavre nogu'a zmante'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Hianagi Ra Anumzamofo kema nentahi'za zmefi'ma humi'za eri'za vahe'mo'za kazokzo eri'za vahe'zmine sipisipine meme afu'zmia zmatrage'za fegu'a mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Anante Ra Anumzamo'a Mosesena asmino, Kazana rusute anagamu atregeno, vahete'ene zagagafare ene, ana maka Isipi hozaramipi hageno mane'nesnia zantera ko'mopa kora herafiramino runteno. ");
INSERT INTO kbq_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mosese'a azompa'ama rusute nagamu atregeno'a, Ra Anumzamo atregeno monagea nehuno, ko'mopa kora herfineramigeno, kopsinamo'enena evuramino mika mopafina ru'ne. E'ina huno Ra Anumzamo'a atregeno ko'mopa kora Isipi mopa'afina ru'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hagi Ko'mopa komo'ene herfi'neramigeno tusi kopsina eri'ne. Isipi kuma'ma fore huno e'neretira e'inahu ko'mopa kora oru'neankna ko ru'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ana maka Isipi mopa'afina ko'mopa komo'a, vahete ene zagagafanena, zamahe haviza nehuno, hozaramimpima nehagea zantamina, ana maka zamahe haviza nehuno zafaramina rukrara krarupe atre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Magoke kumatfama ko'mopa ko'mo'ma ruonte'neana, Goseni mopafi Israeli vahe'mo'zama nemaniza kumate ruonte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Anante Fero'a Mosesene Aronikizni ke higeke vakeno amanage huno znasmi'ne, Menina hago nagra kumi hu'noe. Na'ankure Ra Anumzana Agrake fatgo hu'ne. Nagrane vahe'nianena kefo avu'ava nehuna vahe mani'none. ");
INSERT INTO kbq_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hagi Ra Anumzamofontega nunamu ome hikeno, ko'mopa ko'ene monagenena eri amane hinke'na tamatra'nena viho. ");
INSERT INTO kbq_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mosese'a kenona huno, Kumapinti'ma ufegu'ama nevanu'na Ra Anumzamofonte nazana erintesaga hu'na nunamuna hanugeno, monagema nehiazana vagarenkeno ko'mopago'ma neria ko'mo'a rusenkenka, maka mopa Ra Anumzamofo mope hunka antahigahane. ");
INSERT INTO kbq_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Hianagi nagra antahinoe, kagrane eri'za vahe ka'anena Ra Anumzamofonkura korora hunontaze. ");
INSERT INTO kbq_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Hagi e'i ana knafina (flax) kafinamo'ene balimo'enena, havizantfa hu'ne. Na'ankure bali ragamo'za ko' uzate'nazageno kafinamo'a amosre ahe'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Hianagi witine speltie nehaza zamo'za havizana osu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Anante Mosese'a Ferona atreno ra kumamofo fegu'a vuno, Ra Anumzamofontega azantrena omeri antesga higeno, monagemo'a vagaregeno, ko'mopa komo'enena ruse'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fero'ma kegeno monagene ko'mopa ko'enema rusegeno'a, Agrane eri'za vahe'amo'za antahintahizmimo'a hanavetigeno Fero'a mago'ane kumi hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ra Anumzamo'ma Mosese agipima huvazino hu'nea kante anteno, Fero antahi'zamo'a hanavetigeno Israeli vahera zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ra Anumzamo'a Mosesena asmino, Menina Feronte vuo, amama zamagri amu'nompima erifore nehua avame zantmi kesazegu agri antahintahizane eri'za vahe'amokizmi antahintahizana zamazeri hankveti'noe. ");
INSERT INTO kbq_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","E'ina hu'nesnugeta kamohe'mofone kagehe'mofonena zamasmige'za nentahi'za, Nagrama Izipi mopafi vahe'ma zamazeri zmazanava nehu'na avame zantamima amu'nozmifima erifore hu'noazana nezamasmita, Nagrikura Ra Anumza mani'ne huta keta antahita hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mosese'ene Aronikea Feronte vuke amanage huke ome asmi'na'e, Ra Anumzana Hibru vahe'mokizmi Anumzamo'a amanage huno hie, nama'a zupa Nagri navufina kagra kavufga anteraminka nomanine? Zmatrege'za vahe'ni'amo'za vu'za, monora ome hunanteho. ");
INSERT INTO kbq_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Hagi kagrama ke'nia ontahinka Nagri vahe'ma zmatresnanke'zama ovanazana, antahio, okina ana maka mopa ka'afina kenutmi huzmanta'nena efregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","E'ina hanuge'za mopamofona ana kenutamo'za maka refite vagaresage'za, vahe'mo'za mopa kegara nosnageno, ana kenutmimo'za ko'mopa ko'mo'ma aru haviza osu'nea zafaramimofo asi'nane, kasefa'ma hagesia zafa ramina zamagra nevagaregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ana kenutmimo'za nonka'armimpine, ana maka eri'za vahe ka'amokizmi nontmimpine, ana maka Isipi vahe'mokizmi nontmimpinena mani avitegahaze. E'inahu zana kagehe'mofonteti eno kafahemofonte eno'ma menima kagrite'ma e'neana, ama mopafina fore hige'za onke'nazaza fore hugahie. Anage nehuno Mosese'a rukrahe huno Ferona atreno fegu'a vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Anante Fero eri'za vahe'amo'za amanage hu'za Ferona asmi'naze, Nama'a zupa Mosesena atrankeno mago karifugna huno mani'ne. Zmatrege'za vu'za Ra Anumzana zamagra'a Anumzamofona monora ome hunteho. Hagi kagra nonkano Isipi mopamo'ma havizama nehiana? ");
INSERT INTO kbq_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Fero'a ke hige'za Mosesene Aroni'giznia ete znavre'za agrite azageno amanage huno znasmi'ne, vuta Ra Anumzana tamagra'a Anumzamofo monora ome hunteho! Hianagi iza'za vugahaze? ");
INSERT INTO kbq_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosese'a kenona'a huno, Kasefa vahe'ene tavava ozafane, ne' mofavrermine, mofa'neramine sipisipine meme afutamina zamavare vagareta vugahune. Na'ankure Ra Anumzamofontega ne'za ome kreta neneta monora huntegahune. ");
INSERT INTO kbq_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Anante Fero'a amanage huno znasmi'ne, Tamatre'snugetama a'mofavretamine vanazana, Ra Anumzamoma kegavama huramantesigu kesue. Hanki tamagra kefo antahintahi retro nehaze. ");
INSERT INTO kbq_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","E'inara osugahazanki, tamagri'ma tamavesia kante anteta vene'nemotage vutma Ra Anumzamofona monora ome huntegahaze. Hutege'za Fero avuretira eri'za vahe'amo'za znatufe'za fegu'a eme znatre'naze. ");
INSERT INTO kbq_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Anante Ra Anumzamo'a Mosesena asmi'ne, Isipi mopafina kazana rusutegeno kenutmimo'za e'za ko' mopa ko'mo'ma ru havizama nehuno atre'nea trazana eme nevagareho. ");
INSERT INTO kbq_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mosese'a azompa'a erino Isipi mopafina rusutegeno, e'i ana zagefine hanimpina, Ra Anumzamo'a zage hanatitegati zaho retufegeno maka Isipi mopa'afina efregeno nanterama ko'ma tigeno'a, kenutmi zamavreno efre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ana kenutmimo'za ana maka Isipi mopa'afina emani avite'naze. Ana kenutmina, hamprigara osu'naze. E'inahu kenutmina kora fore osu'nazanki'za henka'anena fore osugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Na'ankure ana kenumo'za Isipi mopafina mani vitazageno mopamo'a avugosa osuno haninke hu'ne. Hagi ko'mopa ko'mo'ma ahe havizama nehuno atre'nea zafa rgarmine trazantmina ne'za erivagara'zageno magore huno Isipi mopa'afina tra'za aninane zafani'nanena omnetfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Anante Fero'a ame huno Mosesene Aronigizni ke higeke akeno amanage hu'ne, Hago tamagrite'ene Ra Anumzana tamagri Anumzamofontera kumi hu'noe. ");
INSERT INTO kbq_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","E'ina hunogu keke huanki kumi'ni'a meni mago'ene atrenanteta, Ra Anumzana tamagri Anumzamofontega nunamu hikeno, nahe fri knazampintira naza hino. ");
INSERT INTO kbq_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Higeno Mosese'a Fero nompinti atirmino Anumzamofona ome antahigegeno, ");
INSERT INTO kbq_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ra Anumzamo'a zage fretegati hankavenentake zaho huntegeno eno, ana maka kenutmina Isipi mopa'afintira eme zmavrehna huno koranke hagerimpi ome zamatrege'za, magore hu'za maka Isipi mopafina omanitfa hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Hianagi Ra Anumzamo'a Fero antahintahi'a azeri hankvetigeno, Israeli vahera zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Anante Ra Anumzamo'a Mosesena asmino, Kazana rusute anagamu atregeno, Isipi mopafina kumazu hani huno vahe'mo avako huga hanintiri hino. ");
INSERT INTO kbq_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Higeno Mosese'a azana rusute anagamu atregeno, 3'a zageknafi ana maka Isipi kokampi haninkino, tusi'a hanintiri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Isipi vahe'mo'za 3'a zageknafina magore hu'za no zmia atre'za fegu'a vano hu'za zamagra'a zamavufina oge'agea osu'naze. Hianagi Israeli vahe'mo'zama nemanizafina masa me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Anante Fero'a Mosesena ke higeno egeno amanage huno asami'ne, A'mofavretamine avreneta vuta Ra Anumzamofo monora ome huntegahazanagi, sipisipine meme afutamine ruga'a afutamina zmatrenke'za maniho. ");
INSERT INTO kbq_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Hianagi Mosese'a amanage hu'ne, Ra Anumzana tagri Anumzante'ma Kresramanavunte afutamine, tevefima krefnane hu ofa hanuna afutamina tatregeta avreneta vamneno. ");
INSERT INTO kbq_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","E'ina hu'negu, maka afu kevuti'a magore huta ozmatreta zmavreha'na huta vugahune. Na'ankure tagra mago'a ana afutamimpintira zmavreta Ra Anumzamofonte monora ome huntegahune. Ina afutami aheta monora huntegahune ontahi'nonankita anante nevuta kegahune. ");
INSERT INTO kbq_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Hianagi Ra Anumzamo'a Ferona antahintahi'a azeri hankvetigeno zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Anante Fero'a Mosesena asamino, Natrenka maniganenka vuo! Mago'ane omo. Hagi henkama kagrama eme nagesanana kahe frigahue! ");
INSERT INTO kbq_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosese'a amanage hu'ne, Ha tamage hane, mago'anena kavufina eme onkegahue! ");
INSERT INTO kbq_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Anante Ra Anumzamo'a amange huno Mosesena asmi'ne, Nagra mago'ane Ferone Isipi vahe'enena knaza zami'na zamazeri haviza hugahue. Anama hutesugeno Fero'a tamatrenigeta kuma'afintira (kantri) atreta vugahaze. Tamage agra kazigazi huno tamahenatina vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Hagi maka Israeli vahetamina zmasamige'za, silvareti'ene golireti'ma tro'ma hu'nesaza zantaminkura tava'ozmire nemanisaza Isipi vahe'mokizmia, vemo'a vemofo antahigenkeno, a'mo'a, amofo antahigenkeno amitere hino. ");
INSERT INTO kbq_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Hagi Ra Anumzamo'a Isipi vahera zamarimpa zamazeri otige'za, Israeli vahetamina so'e zamavu'zamava hunezmantageno, Fero eri'za vahe'amo'zane Isipi vahe'mo'zanema ke'za antahi'zama hazana, Mosese'a ra vahe mani'ne hu'za Isipi mopafina antahimi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Higeno Mosese'a amanage huno Ferona asami'ne, Ra Anumzamo'a amanage hie, meni kenagera Nagra Isipi vahe'mofo mopafi nevu'na, ");
INSERT INTO kbq_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","maka Isipi vahe'mokizmi zmagonesa mofavre'mokizmia zamahe frigahue. Fero'ma kini trate'ma mani'nea ne'mofo agonesa ne' mofavrereti uramino, witima neganaza kazokzo eri'za a'nemokizmi agonesa ne' mofavreramimo'za fri vaganeresageno, anahukna huno maka zagagafamofo agonesa anenta'mozanena frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Anama hanigeno'a tusi'a zavi maka Isipi mopafina ategahaze. E'inahu zavira korapara ote'nazankna zavi ategahazanki'za, henkanena otegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Hianagi Israeli vahepina magore huno agasasana omnenkeno, kramofo ageru'nazana omanesigeta, tamagra Isipi vahe'mota keta antahita hanazana Ra Anumzamo'a Israeli vahera knare huzmanteno, tagripintira zamazeri ruotage hie hutma hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Hagi Feroga maka eri'za vahekamo'za e'za nagrite zmarena eme nere'za anage hugahaze, maka kagri kazigama mani'naza vahera zmavrenka vuo hanage'na, maka zmavere'na atirami'na vugahue, nehuno tusi arimpa nehegeno, Fero avugatira rukrahe huno Mosese'a atiramino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ana higeno Ra Anumzamo'a anage huno Mosesena asmi'ne, Fero'a kagri kea ontahigahianki'na, mago'ene Isipi mopafina kaguva zantamina eri fore hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosese'ene Aronikea maka kaguvazana Fero avuga eri fore hu'na'anagi, Ra Anumzamo'a Fero antahintahia eri hanavetigeno, Isipi mopafintira Israeli vahera zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Hagi Ra Anumzamo'a anage huno Mosesene Aronikiznia Isipi mopafina znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Tamagritera ama ikamo'a ese ika eri agafa hiankino, mago kafumofona ese ika megahie. ");
INSERT INTO kbq_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Hagi maka Israeli vahera anage hutma zmasamiho, ama ikamofo 10ni zupa magoke magoke naga'mofo amente nezmafa'a sipisipi anenta avretere hino. ");
INSERT INTO kbq_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Hagi osi'a naga'ma mago nompina manine'za mago sipisipi anenta'ma nehana huga'ma osu'nesu'za, osi'a naga'ma tava'ozmire nemasaza naga'ene refko hu'za neho. ");
INSERT INTO kbq_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Anama ahesnaza ve sipisipio meme afu anentamo'a, mago kafuma hu'nesigeno, afuhe afahe osu'nesia su'za azerigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Hagi zamagra ana afutamina kegavahume vu'za ama ana ikamofona 14ni knare'ma uhanatinu'za, maka Israeli vahe'mo'za kinaga zagema unefrea knare ahegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ana nehu'za ana afu'ma nesaza nozmimofo kantigma kafa zafarera mago'a korana tagi'za nefre'za, anagamu kaziga kafa zafarera fregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Zamagra ana kenageke afura tevefi kre'za aka nasene nene'za, isti onte bretinena negahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Hagi onte'nenia afuro, kavofima kre'nesaza afura onetma, aseni'ane, agigo'ane agusu agese zama'anena, maka tevefinke kregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hagi ana afu'ma kreta neneta atresazama'a me'nenkeno masa osino. Hianagi neneta atre'nazama'a, kora otu'nena tevefinke kre vagareho. ");
INSERT INTO kbq_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Hagi ana ne'zama nenenutma, amanahu hutma retrora hiho. Kukenatamia eri atupa nehutma, tamagia anona nevazita, azompanena tamazampina eri'neta ame'ama hutma ana ne'zana neho. E'i ana ne'zana Ra Anumzamo'na ontamahe'na tamagateresua ne'zane. ");
INSERT INTO kbq_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Na'ankure Nagra maka Isipi mopafi ana kenagera nevu'na, mago'mago nagapintira ese zamagonesa ne' mofavrea zamahe nefri'na, maka afutamimofo ese' ve anentara zamahe'noa Ra Anumza mani'noanki'na, maka havi anumzantamina refko huzmante'na, zamazeri haviza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Hagi tamagrama manisaza nontera kafante fre'naza koramo'a, mago avame'za me'nesige'na, Isipi vahe'ma zamazeri havizama hu'na enevu'na, ana korama eme kesu'na knazana tami'na tamazeri havizana osu'na tamagateregahue. ");
INSERT INTO kbq_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Menina amagna Ra Anumzamo'na antahinamita, musema hutma ne'zama nesaza kna me'nena, fore hu anante anante hu'zama esaza vahe'mo'zanena trake me'nena, ama ana knarera ne'zana kre'za nene'za musena hunante'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Hagi 7ni'a knamofo agu'afina zo-ore bretige negahazankita, ese knazupa nompintira zore bretia eri atregahaze. Na'ankure ana 7ni'a knamofo agu'afima zore bretima nesimofona, Nagri vahepintira ahe megi'a atregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hagi ese kna zupa atru hutma monora hunenanteta, nampa 7ni knare'enena monora hunantegahaze. Ana tarega knarera eri'zana e'origahazanagi, ne'zama nesaza zanke retrora hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Hagi istima onte bretima nenaza knagura antahita musenkase hugahaze. Na'ankure ama ana knare tamagri Isipiti tamavre'na atirami'noe. E'ina hu'negu ama ana knagura maka knafina fore hu anante hunante hu'zama esaza vahe'mo'za tra kegura zmagera okanitfa hiho. ");
INSERT INTO kbq_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Hagi ese ikamofo 14tini knamofo kinaga, isti onte bretia agafa hutma nenenkeno vuno ana ikamofona 21ni knare kinaga uhanatiho. ");
INSERT INTO kbq_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ana 7ni'a knamofo agu'afina, magore huno zore bretia nontamifina omaneno. Na'ankure istima ante bretima Israeli vahepintiro megi'a vahe'ma tamagranema mani'nesaza vahepinti'ma nesimofona, vahe'ni'afintira zamahe anati atreho. ");
INSERT INTO kbq_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tamagra zore bretia onegahaze. Hagi mika nompina zo-ore bretige neho. ");
INSERT INTO kbq_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Anantera Mosese'a maka Israeli kva vahera zamagi huno anage huno zamasami'ne, Vutma naga tamimofo avamente Anumzamo ozmaheno zamagateresia ne'zama kre sipisipi anentara ome huhampriho. ");
INSERT INTO kbq_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hagi hisopu zafa azankuna erita zompafima taginte'naza korampi reteta, kafamofo kantigama zafare nefreta, anagami kaziga zafare'ene nefreta mani'naza nona atreta megi'a oviho. ");
INSERT INTO kbq_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Na'ankure Ra Anumzamo'a kenage'ma Isipi vahe'mokizmi zmahenaku'ma enevanuno'a, ana korama kantigama kafa zafare'ene, anagamu kafa zafare'ma ke'nuno'a, ana nona agatereno nevanigeno, vahe'ma zamahe fri ankeromo'a ana nompi vahera ozmaheno zmagatereno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Hagi ama avu'avazamo'a mago kasege me'ne'na, tamagrane mofavretamine tamagehe'zanena amanahu avu'ava zana huvava huta vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Hagi Ra Anumzamo'ma huvempama huno'ma taminaku'ma hu'nea mopafima umanisutma, Ra Anumzamo'ma ontameheno tamagatere'nea zankura ne'zana kretma nenetma muse nehutma tamagesa antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Hagi henkama mofavretamimo'zama tamantahige'za, ama ne'zama kretama neneta musema nehunana, na'a agafarere hu'za tamantahigesageta? ");
INSERT INTO kbq_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Tamagra anage huta zmasamiho, Isipi nontifima mani'nonkeno Ra Anumzamo'ma oraheno tagatereno enevuno, Isipi vahe'ma zamahe'negu antahimita musenkase huta nenona ne'zane hiho. Higeno vahe'mo'za antahite'za, mopafi zmare'nare'za Ra Anumzamofona mono hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Anante Israeli vahe'mo'za vu'za, Mosesene Aronikiznima Anumzamo'ma hihoma huno znasami'nea kante ante'za ome retrotra hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Hagi ana kenage amu'nompina, Ra Anumzamo'a maka Isipi mopafi vahe'mofo zmagonesa mofavre'zmine, kini trate'ma mani'nea ne' Fero agonesa mofavrereti vuno, kina nompima mani'naza vahe'mofo mofavrene, maka afu zagazmimofo ese anentatmintema vu'neana zamahe fri vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Hagi Fero'ene maka eri'za vahe'ane, maka Isipi vahe'mo'za ana kenagera oti'za tusi'a zavite'naze. Na'ankure mika nompina zmagonesa mofavremo'za fri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ana kenage amu'nompi Fero'a Mosesene Aronikizni ke higeke akeno, Atreta otita vi'o. Vahe'ni'afintira maka Israeli vahera zmavreta kema huna'a kante anteta, Ra Anumzamofona monora ome hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Hagi maka afu'zaga taminena avreta nevutma, asomu kea hunanteho. ");
INSERT INTO kbq_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Hagi Isipi vahe'mo'za Israeli vahera tutu huzmante'za, ru maka vahe'mota frisunki tatareta ama mopafintira atiramita ko viho. ");
INSERT INTO kbq_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hagi Israeli vahe'mo'za istima onte'naza flaua zompafima herunte'nazana tavaravefi eri antegafi'za zamafunte erinte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Hagi Israeli vahe'mo'za Mosese'ma zmasami'nea kante ante'za, silvareti'ene golireti'ma tro hu'naza zantaminku'ene kukenagura Isipi vahera zmantahigazageno, ");
INSERT INTO kbq_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ra Anumzamo'a Isipi vahe'mofo zmavurera Israeli vahera zamazeri knare hige'za, nazankuro ome zmantahima kazazana Isipi vahe'mo'za ana maka zami'naze. Ana hige'za maka Isipi vahe'mofo zana eri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Hagi Israeli vahe'mo'za Ramasese kumara atre'za Sukoti kumate'ma uhanati'nazana, 600 tauseni'a naza vahera vu'naze. Anampina a'nene mofavreraminena ohampri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Hagi Israeli vahekera ovu'nazanki, rama'a ru vahe'ene afu'zagane vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Israeli vahe'mo'za Isipiti'ma eri'za e'naza flauateti, zo-ore bretia kre'naze. Na'ankure Isipi vahe'mo'za tutu hu'za huzmantage'za, ne'zama retro'ma hukna omanege'za isti onte eri'za e'naza flauateti, zo-ore bretia kre'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Hagi Israeli vahe'mo'za Isipima mani'nazana 430'a kafu mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Hagi 430'a kafuma vagamarea kna fatgore, Ra Anumzamofo vahe'mo'za Isipi mopa atre'za atirami'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Hagi anama Isipitima zamavreno'ma atirami'nea kenagemo'a, Ra Anumzamofo kenage me'nenkeno, mika Israeli vahe'mo'zane zamagripinti'ma fore hu anante anante'ma hu'zama vanaza vahe'mo'za, Ra Anumzamofo kenagere nehu'za, ne'zana kre'za nene'za monora huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Hagi Ra Anumzamo'a anage huno Mosesene Aronikiznia zanasami'ne, ontamahe'na tamagatere'noa ne'zama ne'knamofo kasegemo'a amana hu'ne, megi'a vahe'ma tamagranema emanine'naza vahe'mo'za ana ne'zana onetfa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Hianagi maka ve kazokzo vahe'ma mizasetma avre'nesaza vahe'mokizmima zmavufama taga hu'nesaza vahe'mo'za amne negahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Hagi megi'a vahero, zago eri'zama tamagrite'ma emenerisaza vahe'mo'zanena, ana ne'zana onegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Hagi ana ne'zana ana nompinke neneta mago'a avufga'a eritma megi'a atioramige, ana afumofo zaferinanena rufu otagigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mika Israeli vahe'mo'za ne'zana kre'za nene'za, ana knagura musenkase hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Hianagi ru vahe'mo'zama tamagranema emani'nenamo'za, Ra Anumzamo'ma ontamahenoma tamagatere'nea knare'ma muse ne'zama nenaku'ma hanu'za, maka vene'nemo'za oku zmufga anoma'a tagahute'za, zamagra tamagrikna hu'za erava'o hugahaze. Hagi zamavufagama taga osu'nesaza vahe'mo'za, ana ne'zana onegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hianagi megi'a vahe'ma tamagranema emani'nesaza vahe'mo'zane Israeli vahe'mo'zanena ana kasegea, amage antegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Anante Ra Anumzamo'ma Mosesene Aronikiznima hihoma huno maka kema znasami'nea kante ante'za maka Israeli vahe'mo'za ana hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ana knazupage Ra Anumzamo'a Israeli vahera Isipi mopafintira nagate nofite, zamavareno atiramino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ra Anumzamo'a Mosesena amanage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Israeli vahe'mota mika tmagonesa ne' mofavrene, mika zagagafa timimo'zama ese anenta'ma kase zmantesiana, azeri otage hanageno, Nagrike su'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Anante Mosese'a amanage huno veara zamasmi'ne, kazokzo eri'zama e'nerita kinama hutma Isipi mopare mani'nazareti'ma atiramita e'naza knagura tmagera okaniho. Na'ankure Ra Anumzamo'ma hanavenentake azanu Isipitira tamavre fegu'a atre'negu, antahimita zore bretia onegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ese ikamofona (Abibie) amana knare tamagra atretma vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ra Anumzamo'ma tmagehe'mokizmima huvempa huzmanteno, amirine, tumerimo'ma avite'nea mopama Kenani vahe'mokizmi mopane, Hiti vahe'mokizmi mopane, Amori vahe'mopama, Hivi vahe'mokizmi mopama tamigahuema hu'nea mopare'ma tamavreno vanigeta, kafugu kafugura ana knagura nentahita musenkase hiho. ");
INSERT INTO kbq_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Hagi 7ni'a zagemofo agu'afina zo-ore bretige neta nevinkeno, 7ni knarera uhanatina ne'za trohuta neneta, Ra Anumzamofona monora huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Zo-ore bretia ana 7ni'a zage knamofo agu'afinke neta vugahaze. Hagi ana knafina, zisti ante bretia nontimifine, kumapine non tva'ontamirera onteho. ");
INSERT INTO kbq_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Hanki kafune kafunena ama ana knarera mofavretimia amanage hutma zmasmiho, Ra Anumzamo'ma Isipi mopare kina huta mani'nonkeno tavreno e'nea knagura antahimita musenkase nehune huta zmasmiho. ");
INSERT INTO kbq_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ama ana knamo'a tamazante'ene kokovite'ena avame'za me'nena, tamagera okanitma tamagesa nentahinkeno, Ra Anumzamofo kasegemo'a tamagipi meno. Na'ankure Ra Anumzamo'a tusi'a hanavenentake azanu Isipitira tamavreno atirami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","E'ina hu'negu mika kafune kafune ama knama ne-ena, huhampriteneta ne'za kreta neneta musenkase hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Hanki Ra Anumzmo'ma tamagri'ene tmagehemokizmi huvempa huno, zamigahue hu'nea Kenani mopare'ma tavreno'ma vanigeta, ");
INSERT INTO kbq_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mika tmagonesa ve mofavreramine, mika'a afu'zagama kegava nehaza afu'mo'zama kasezmantesaza ese' ve anenta'a, Ra Anumzamofo amiho. Na'ankure e'i ana ese anenta'a Ra Anumzamofo su'zane. ");
INSERT INTO kbq_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Hianagi ve sipisipi anenta aheta maka donki afutamimofo ve anentara nona hutma miza hugahaze. Ana'ma hutma mizama osenutma, ana ve donki afura ananke eri vamagita ahegahaze. Maka tmagonesa ve mofavreramina ete miza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Hagi mofavretamimo'zama henkama tamantahige'zama amazana nazane hanagetma, kina hu'neta kazokzo eri'zama e'nerunkeno, hanavenentake azanu Ra Anumzamo'a Isipi mopafinti tavreno atirami'ne hutma hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Hagi Fero'ma tatregetama ovunkeno, Ra Anumzamo'ma Isipi vahe'mokizmi ese zmagonesa mofavreramine, maka afu'zagamofo anentara zamahe'ne. E'ina hu'negu maka ese ve anenta'ma kasentesazana Ra Anumzamofo kresramna vunentonanagi, tagonesa ve mofavretia ete nona huta miza nehune hutma hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ana hu'negu mago avame'za tazantera nofi anakinenteta kokovitera anakinenteta, Ra Anumzamo'ma hanavenentake azanu'ma Isipiti'ma tavreno'ma atirami'nea zankura antahimigahune. ");
INSERT INTO kbq_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Hagi Fero'ma Isipiti'ma zmatrege'za vu'nazana, Filistia mopafima vu kana tavaonte me'neanagi, Anumzamo'a zmatrege'za ana kantera ovu'naze. Na'ankure Israeli vahera ha' huzmantesage'za rukrehe hu'za Isipi e'zanku Anumzamo'a zmatrege'za ovu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","E'ina hu'negu ka'ma kokampi koranke hagerima me'nea kantega Anumzamo'a zamavreno kagino vige'za sondia vahe viaza hu'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Hagi ko'ma Josefe'a Israeli nagara zamsamino, Anumzamo'a Isipitira henka tamavreno vugahiankita zaferinani'a eri'neta vugahaze hige'za huvemapa hunte'nazare, amage anteno Mosese'a zaferina'a erino vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Anante Sukoti kumara atre'za ka'ma kokamofo atumparega, Etamu seli nona ome ki'naze. ");
INSERT INTO kbq_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Hagi Ra Anumzamo'a hampompi manineno msarera zamavreno nevuno, hanimpina tevefi mani'neno zamavreno vu'ne. E'ina hige'za kenage'ene masare'enena amne vugara hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Israeli vahe'mofo zmavugatira masarera hampomo'a zamatreno ovigeno, hanimpina tevemo'a zamatrenora ovu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Zmasamige'za Israeli vahe'mo'za rukrehe hu'za vu'za, Pihahiroti kumamofo avuga Mikdoli kuma'ene hagerinke'namofo amu'noznifi, nona ome kinkeno mago kaziga Ba'al Sifoni kuma meno. ");
INSERT INTO kbq_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Na'ankure Fero'ma agesama antahi'niana, Israeli vahe'mo'za ka'ma kokana agatere'za vugara osu'za, hazagre'za vano nehaze huno antahigahie. ");
INSERT INTO kbq_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nagrani'a Fero antahintahia eri hanaveti'nena, agri'ene sondia vahe'anena zamahe vagaresuge'za, Isipi vahe'mo'zama antahi'za ke'za hanazana, Nagrikura Ra Anumza mani'ne hu'za ra nagia namigahaze. Hige'za anante Israeli vahe'mo'za nona ki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Israeli vahe'mo'za hago atre'za vu'naze kema Isipi kini ne'mofoma eme asamizageno'a, Fero'ene eri'za vahe'amo'za antahi'zazmia ete rukrahe nehu'za, amazana naza hunke'za eri'zama erinerantaza zana zmatronke'za Israeli vahe'mo'za tatare'za vu'naze? hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Anagema hute'za, kini ne'mo'a ha'ma hu'zana karisi'a retro nehuno, sondia vahe'a zamazeri retro, ");
INSERT INTO kbq_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","nehuno 600'a knare'ma hu'nea karisiramina e'nerino, maka Isipi mopafima me'nea karesiramina erige'za, ana maka karisiramintera ugagota hu'naza sondia vahe'amo'za mareri'za manitere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Hagi Ra Anumzamo'a Isipi kini ne' Ferona antahintahia eri hanavetigeno zmarotago huno vu'neanagi, Israeli vahe'mo'za korera osu muse hu'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Anantera maka Isipi vahe'mo'zane, Fero karisi ramine, hosiramina e'neri'za nevazageno, sondia vahe'mo'zanena zamarotago hu'za Pihahirotine Ba'ale Zefone avuga, koranke hageri ankenarega Israeli vahe'ma mani'nazare vu kofta hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Hagi Israeli vahe'mo'za kazageno'ma, Fero'ene sondia vahe'amo'zama vu tava'oma nehige'za, zamagra tusi zamagogogu nehu'za, zamazama hanigu Ra Anumzamofonku kezanke hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Anantera anage hu'za Mosesena asami'naze, Isipia matira omnegenka frisunegura ama ka'ma mopafina tavrenka e'nano? Nagafare tavrenka ama ka'ma kopina e'nane? ");
INSERT INTO kbq_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Isipima mani'neta ko kasamita anage hu'none, tataregeta Isipi vahe kazokzo eri'za e'nerita manimneno hu'none. Na'ankure Isipi vahe'mokizmi kazokzo eri'zama e'nerita manusina knare hisinagi, ama ka'ma mopafima fri'zamo'a knarera osu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Hianagi Mosese'a anage huno Israeli vahera zamasami'ne, Korora osuta Anumzamo'ma menima tamagu'ma vazisia zana oti hanavetineta keho! Na'ankure Isipi vahera menina nezmagazankita, mago'enena ozmagetfa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hagi tamagra akoheta mani'nenkeno, Ra Anumzamo tamagritega anteno hara hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Anante Ra Anumzamo'a Mosesena anage huno asami'ne, Nahigenka Nagritega krafagea nehane? Zmasamige'za Israeli vahe'mo'za viho. ");
INSERT INTO kbq_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Hagi kagra azompaka'a erisga hunka, hagerintega kazana rusutegeno, hagerimo'a rupapa huno vuno eno hinkeno, hagege mopa fore hinke'za, Israeli vahe'mo'za viho. ");
INSERT INTO kbq_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Hagi Nagra Isipi vahe'mokizmi antahintahia eri hanavetisuge'za, tamarotago hu'za tamefi nevanage'na, Ferone maka sondia vahe'ane, hosima e'neri'za vahe'ene, karisizmine, zamahe refitesua zanteti, Nagra Ra nagia erigahue. ");
INSERT INTO kbq_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ana'ma hu'na Ferone maka sondia vahe'ane, hosima e'neri'za vahe'ene, karisizmine, zamahe refitesuge'za Isipi vahe'mo'za nege'za, Nagrira Ra nagi namigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Anantera Anumzamofo ankeroma, Israeli vahe'ma ugagotama huzmanteno'ma nevia ankeromo'a zmagefi'ma evigeno'a, ana zanke huno ugagotama huno'ma nevia hampomo'a' zamagefi eme refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ana kenagera Israeli vahe'ene Isipi vahe'mokizmi amu'nompina ana hampomo'a me'neno, Isipi vahe'mokizmi kaziga rehani nehuno, Israeli vahe'mokizmi remsa huzmantege'za Isipi vahe'mo'za erava'o osu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Anante Mosese'a hagerintega azana rusutegeno, Ra Anumzamo'a zage hanatitegati zaho huntegeno, ana kenagera zaho erino hagerina eri rupapa huno vuno eno higeno, mopamo'a hagege hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ana higeno hagerimo'a kantigma hihi huno vihu gna huno mreri'nege'za, Israeli vahe'mo'za ana hagerimofo amu'nompi hagege hu'nea mopare vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Anante Isipi vahe'ma, Fero hosima e'neriza vahe'ma, karisima e'neri'za vahe'ma, sondia nena, zamazeri naku zmagefi zmarotago hu'za hagerimofo amu'nompi vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kotu masama nehigeno, Ra Anumzamo'a hampompine, tevefine mani'neno kefenkateno Isipi sondia vahe'ma nezmageno, antahintahizmia zamazeri savri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ra Anumzamo'a karisizmia zamazeri ge'za ruti'zama vuzankura mragu'zati'za nevu'za, Isipi vahe'mo'za anage hu'naze, atrenketa Israeli vahera zmatreta framneno. Na'ankure Anumzamo'a zamaza huno ha' hunerante. ");
INSERT INTO kbq_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hagi Ra Anumzamo'a anage huno Mosesena asami'ne, Kazana hagerintega rusutegeno, hagerimo'a ete evuno Isipi vahe'ene karisizmine hosima eneri'za vahe'enana refitezmanteno. ");
INSERT INTO kbq_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Higeno Mosese'a ko'matigeno'a hagerintega azana rusutegeno, hagerimo'a evuno ru hamprigeno, Isipi vahe'mo'za ete rukrehe hu'za koro frenaku hazanagi hagerimofo agika frazageno, Ra Anumzamo'a hageri amu'nompi zmaheno refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Hagi maka hosima e'neriza vahe'ene, maka Fero sondia vahe'ene karisi zminena hagerimo'a zmaherefitegeno, mago'mo'e huno omani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Hianagi Israeli vahe'mo'za hageri amu'nompina hagege hu'nea mopare vazageno hagerimo'a, kantigma kegina huzmanteankna hige'za amu'nompi vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ana zupa Israeli vahera Isipi vahe'mokizmi zamazampintira Ra Anumzamo'a zmagu'vazino zamaza hige'za, Isipi vahe'ma hagerinke'nafima fri'naza vahera Israeli vahe'mo'za zmage'naze. ");
INSERT INTO kbq_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Hagi Ra Anumzamo'ma havenentake zama tro'ma huno Isipi vahe'ma ha'ma huzmantea zama, Israeli vahe'mo'za nege'za, Ra Anumzamofona kore hunte'za zamentinti hunente'za, eri'za vahe'a Mosesenena zamentinti hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ana hige'za Mosese'ene Israeli vahe'mo'za ama'na zagame Ra Anumzamofonte hu'za amanage hu'naze, Nagra Ra Anumzamofonte zagame hugahue, na'ankure Agra tusi'a ha' hu agatereneno, mareri sga hu'ne. Hagi hosi agumpi mani'za aza vahera zamasga huno hagerimpi matevutre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ra Anumzamo'a hankveni'ane zagame'ni'a mani'neno, Agra nagu'vazi'ne. Agra nagri Anumza mani'negu, agi hentesga nehue. Nenfa Anumzamofona agi'a hentesga hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ra Anumzamo'a harafa nere, Ra Anumzana agri agi me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ferone sondia vahe'amokizmine karisi ziminena, hagerimpi zmamahere'ne. Ave'masinezmantea kva vahe'amo'za koranke hagerimpi ti nakri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Zamagra amefenkame hagerimofo agu'afina havemo hiaza hu'za urami'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Kagri kzan tmagamo'a Ra Anumzamoka hanavenentake hu'negenka, ha' vaheka'a zamahenati tre'nane. ");
INSERT INTO kbq_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kagra himamuka'areti'ene fatgo kavukavaka'areti ha'ma hugante ku'ma haza vahera zamazeri agatenerane. Krimpa teveha'zamo'a, ha' vahe ka'a tevemo traza tefanene hiaza huno tefanane nehie. ");
INSERT INTO kbq_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kagona gampinti himamu kasimu zaho'mo tina azerimohihi higeno marerigeno, tima enevia timo'a moriri huno mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ha' vahetimo'za hu'za, zmarotago huta ome zamazeri ta feno zazmia refako hanune hu'naze. Zamagrama antahizaza hunerante'za, kazinteti tahe nefriza zmazanu tahe frinaku hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kagra zaho ka'a huhu hankeno hagerimo'a refite'zamante'ne. Zamagra tusi'a hanavenentake timofo agu'a tami'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Iza anumza tamimpintira magora Kagrikna Anumzana mani'ne, Ra Anumzamoka? Iza magora Kagrikna huno Hankveka'ane Ruotgera hu'ne? Nagru hu'nanke'za Kagi hesga nehazagenka, Kagra kaguvaza nehane? ");
INSERT INTO kbq_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kagra tamaga kazana rusutankeno, mopamo'a zamazeri nakri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kagrama vaheku'ma kavesi zmantenka kasuma tagizmante kavukava zanka'areti, mizasenka zmavre'nana vahera zmavrenka vu'nane. Kagraka'a hankave ka'afi kegava huzmantenka nagru hu'nea kumate ome zamante'nane. ");
INSERT INTO kbq_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Vahe'mo'za ana agenkema nentahi'za zmahirahiku hu'naze. Filistia vahe'mo'za tusi'a zamanogu hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Itomu kumate ugagota hu'naza vahe'mo'za, tusi koro hu'naze, Moapu kumate kegava hu'naza vahe'mofona, tusi zamano vazi'ne, mika Keneni nemaniza vahe'mofo zamagu'amo'a, ti se'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ra Anumzamoka tusi'a hankave ka'a zamagra nege'za, tusi korozamo zmagrira refitezmantege'za, kaza osu'naze. Zamagra zafa mneankna hu'nenageta, Kagri vahe'mota vugahune. Ra Anumzamoka isipiti tavrenka anketa kinafintira katufeta e'none. ");
INSERT INTO kbq_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kagra zamavarenka erisanti harerantenku'ma hu'nana kumakare emetantegahane. Kagraka'a manigahue hunka kazanuma tro'ma hu'nana kumapi, Ra Anumzamoka ome tantegahane. ");
INSERT INTO kbq_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ra Anumzamo'a kinia manivava hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Na'ankure hosifi maniza nevaza Fero sondia vahe'mo'za hagerimpi ufrazageno, Ra Anumzamo'a hagerina atregeno refitezmante'ne. Hianagi Israel vahe'mo'za hagerimofo amu'nompi hagege hu'nege'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kasnampa a' Miriamu, Aroni nesaro'a nase'nasepa azampi erige'za, mika a'nemo'za nase'nasepa erihanati'za nase'nasepa ati'za avo hage'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Higeno Miriamu'a mago zagame huno, Ra Anumzamofonku zagame hiho, na'ankure Agra marerisga hu'ne. Hosi agumpi mani'naza vahe'ene hosizmine hagerimpi zamasgahu re'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ananteti Mosese'a koranke hagerina atreno Israeli vahe'mo'za Sulue nehaza ka'ma kopi zamavareno, 3'a zageferu nevige'za, tina ke'za erifore osu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Zamagra Marae nehazare'ma ne-eza tina Maratira one'naze. Na'ankure ana timo'a aka hu'ne, E'ina hu'negu (aka hu'ne) Mare hu'za hu'naze, ");
INSERT INTO kbq_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ana hige'za vahe'mo'za Mosesena kehakare hunte'za anage hu'naze, ina'na ti negahune? ");
INSERT INTO kbq_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Anage hazageno Mosese'a Ra Anumzamofo antahigegeno, Anumzamo'a mago zafa averi higeno hantagino ana timpi atregeno, ana timo'a knare hige'za ne'naze. Anante Ra Anumzamo'a mago'a tra kenenteno amage'ma antesagu rezamaheno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ana nehuno anante Ra Anumzamo'a anage hu'ne, Rantimi Anumzamofo ageru'ma antahitama fatgo zama Agri avufima nehutma, kasege'agu'ma tamagesa anteta nentahitma, mika ke'ama amage'antesazana, magore hu'na kria tamavatera ontegahue, Isipi vahe'ma zmi'noankna kria ontamigahue. Na'ankure Nagra Ra Anumzamo'na, kritamima eri netromo'ne. ");
INSERT INTO kbq_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ananteti Elimie nehaza kumate 12fu'a ti nehanatigeno, 70'a tona'zafa me'nere nona emeki'za tinkenare mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Hagi menina nampa 2 ikamofo 15ni knazupa Israeli vahe'mo'za Isipima atre'za atirami'naza emaninaretira Elimia atre'za Sinie nehaza ka'ma kokampi, Elimine Sainai amu'nompi e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Hagi maka Israeli vahe'mo'za mago zamarimpa osu'za Mosesene Aronikiznia ka'ma kokampina ke hakare huznante'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Hagi Israeli vahe'mo'za anage hu'za zanasami'naze, Isipima mani'neta tavesite afu kavone, bretinena neramu nehuta maninonte Ra Anumzamo'ma tahe friresina knare hisine. Hianagi tagaku nehuta frisunegu ka'ma kokampina tavreta e'na'o. ");
INSERT INTO kbq_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Anantera Ra Anumzamo'a anage huno Mosesena asami'ne, ko, Nagra maka kna monafinti bretia ko'mariaza hu'na tamagritega atresugeno eraminige'za, vahe'mo'za vu'za mago mago knamofo agu'afima nesaza avamente erisage'na, keni'a amagera antegahazafi rezmahe'na kegahue. ");
INSERT INTO kbq_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Hagi 6si knazupa, tare knamofo agu'afima nesaza avamente zogiho. ");
INSERT INTO kbq_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ana higeno Mosese'ene Aronikea maka Israeli vahera zamasami'ne, meni kinagama ketma antahitama hanazana Ra Anumzamo Isipitira tavreno atirami'ne nehutma, ");
INSERT INTO kbq_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","nanterana Ra Anumzamofo hanave'a kegahaze. Na'ankure Ra Anumzamofoma mago tamarimpama nosuta kehakarema huntazana antahi'ne, hagi tagra izagata mani'nonketa ke hakarea hunerantaze? ");
INSERT INTO kbq_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Anante Mosese'a anage hu'ne, Ra Anumzamo'a nanterana neramu'ma hu'are bretia neramimino, afu ame'a erifore huno kinaga tamamigahie. Na'ankure Agri'ma ke hakarema hunentaza zana agra ko keno antahino hu'ne. Tagra izagata mani'nonketa ke hakarea hunerantaze. Tagri ke hakarea hunorantazanki, Ra Anumzamofo kehakarea hunentaze. ");
INSERT INTO kbq_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Anante Mosese'a anage huno Aronina asmi'ne, Maka Israeli vahe'mokizmia anage hunka zamasamio, Ra Anumzamofo tava'onte avuga eta antahiho, na'ankure ke hakare'ma hazana Agra antahine. ");
INSERT INTO kbq_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Hagi Aroni'a maka Israeli vahe'mokizmima anankema nezmasamige'za, nentahi'za kegamute'za ka'ma kokantega kazana, Ra Anumzamofo msamo'a hampompinti remsa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Anante Ra Anumzamo'a anage huno Mosesenku hu'ne, ");
INSERT INTO kbq_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Nagra Israeli vahe'mo'zama ke hakare'ma hazana ko antahi'noanki anage hunka zamasamio, kinaga afu ame'a negahaze. Hagi nanterana bretia neramu nehuta, tamagra keta antahitama hanazana, Nagrikura, Ra Anumzana tagri Anumza mani'ne hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Hagi ana zupa kinaga segeno'a, Hifa namazagamo'za e'za seli nomagi'za mani'naza kumara emani avinetazageno, nanterana ata ko aru'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ana ata ko'mo'ma hagegema higeno'a, ka'ma kokampina efeke huno breti retoza'agna'za fore huno mopa refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Anante Israeli vahe'mo'zama ana zama nege'za, zamagra zamagra anage hu'naze, ama zana na'zane? Na'ankure anazana Israeli vahe'mo'za ke'za antahi'za osu'nazagu hu'naze. Anante Mosese'a anage huno zamasami'ne, ama'i Ra Anumzamo bretima nesazaza tami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hagi amanage huno Ra Anumzamo'a hanave ke hu'ne, tare lita tima afiga'ma hu'nesia kavofi, mago mago'mo'a seli nompima mani'nesaza avamente zogiho. ");
INSERT INTO kbq_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Hagi Israeli vahe'mo'za kema zamasamiaza hu'za zogi'nazana, mago'amo'za rama'a zonegizageno, mago'amo'za osia zogi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Henka ana ne'zana erinte'za refko hu'za kazana, rama'ama eri'namo'za agateorazageno, osi'ama eri'namo'za atupara osu'naze. Maka'mo'za ana ne'zana negnare hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Anante Mosese'a anage huno zamasami'ne, Mago'a ne'zana atrenkeno me'nenkeno nanterana oseno. ");
INSERT INTO kbq_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Hianagi zamagra Mosese'ma hiankea ontahi'za, nene'za mago'a ante'nazageno ko'ma atigeno, anampintira kani fore huno himna vigeno, Mosese'a rimpa ahezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Maka nanterana Israeli vahe'mo'za nesaza avamente zogi'nazanagi, mago'ama atrageno'ma meama'a zagemo'ma amuhoma nehuno'a, teze'ze higeno fnanene hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hagi 6si knazupa tare lita tima afiga'ma hu'nesia kavofi, mago mago'mo'a tare knafima nesaza avamente tare kavo eri avitetere hino. Maka Israeli vahe'mokizmi kva vahe'mo'za e'za anazama fore'ma hiazana Mosesena eme asmi'naze ");
INSERT INTO kbq_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Anante Mosese'a anage huno zamagrira zamasmi'ne, Ra Anumzamo'a amanage hie, okina mani fruhu (Sabat) knagino, Ra Anumzamofo ruotage kne, tevefima kresazama'a tevefi negretma, kavofima kresazama'a, kavofi kreho. Hagi mesiama'a eri otage hutma ante'nenkeno, ko atuno. ");
INSERT INTO kbq_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hige'za meama'a ante'nageno ko atuneanagi, ana ne'zampina knina fore osigeno, himna ovu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosese'a amanage huno zamasmi'ne, mani fru hu'zupagita omnenketa e'origosaze. Krente hanaza ne'za neneta maniho. ");
INSERT INTO kbq_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Hagi 6si'a knafi ne'zana zogigahaze. Hianagi 7ni kna mani fruhu knagino, ne'zana omanegahie. ");
INSERT INTO kbq_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hagi mani fruhu knama (sabat) ege'za, mago'a vahe'mo'za ne'za erinaku vu'za ome hakazanagi, onke'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Anante Ra Anumzamo'a anage huno Mosesena asami'ne, Nama'a kna tamagra Nagri kasege hihoma hua ke'nena amagera nontaze? ");
INSERT INTO kbq_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hagi keho, Ra Anumzamo'na mani fruma hanaza kna tami'noe. E'ina hu'negu ne'zama nesaza zana, tare knamofo agu'afima nesaza avamente 6si knazupa Nagra tami'noe. Hagi mago'mo'e huno mani fruma huknarera megi'a nezankura hakeno ovuno, maka vahe'mo'za nozamire manitere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hige'za Israeli vahe'mo'za, 7ni knarera manigasa hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ana hige'za Israeli vahe'mo'za, ana ne'zankura manae hu'za agi'a ante'naze. Hagi ana manamo'a osisi huno kolianta zafa rgagna huno efeke higeno, haga'amo'a tumerima'areti tro hu'nea bisketigna hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Anante Mosese'a anage huno zamasami'ne, Ra Anumzamo'a anage hie, tare lita tima afiga avamente mana antenkeno me'nena henkama fore hunante anante'ma hu'za esaza vahe'mo'za ana mana nege'za, Isipiti'ma tamavremegi atre'na tamavre'na ne-ena tami'noa mana kegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Hagi Mosese'a anage huno Aronina asami'ne, tare lita tima afiga avamente ana mana erivitenka Anumzamofo avure'ma ante'nea kavofina antegeno me'nena, henkama fore hunante ante'ma hu'zama esaza vahe'mo'za kegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ra Anumzamo'ma Mosesema asmi'nea kante amage anteno, Aroni'a ana mana henkama fore hunante anante'ma hanaza vahe'mo'za nege'za antahimisagu antegeno me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Hagi Israeli vahe'mo'za 40'a kafufi ana mana ne'zana ne'za nevu'za, vahe'ma mani'naza mopafina uhanati'za, ana mana ne'za nene'za Keneni vahe'mokizmi mopafi ufre atuparega uhanati'naze. ");
INSERT INTO kbq_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Hagi ana knafima ne'zama refko'ma hu'zama negaza kavoa tare me'ne, (magora osikino oma tare lita ti afiga hu'ne. Hagi magora efetie nehaza rankavogino, 20'a lita tina afiga hu'ne.) ");
INSERT INTO kbq_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Anantera maka Israeli vahe'mo'za Anumzamo'ma zmasamino, vihoma hige'za Sinie nehaza hagege ka'ma kokana atre'za, seli nona ome ki'za masete masete hu'za vu'naze. Hagi ana hu'za nevu'za henka Refitimie nehaza kumate uhanati'za seli nona ome ki'naze. Hianagi nesaza tina ana kumatera omane'ne. ");
INSERT INTO kbq_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","E'ina hige'za Israeli vahe'mo'za Mosesena ke hara hunte'za, anage hu'naze. Tina tamigeta namneno, hazageno Mosese'a anage huno zamasami'ne, nahigeta nagrira ke hara hunentaze? Nahigeta Ra Anumzamofona rehetma negaze? ");
INSERT INTO kbq_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Hianagi vahe'mokizmia tinkura tusiza huno zmagege'za, Mosesena ke hakare hunte'za, nahigenka Isipitira tavrenka amafina e'nanketa, tagrane maka mofavrezagatine, afu'zagatinena ti ne'zankura nehuta frigahune? ");
INSERT INTO kbq_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Anama hazageno Mosese'a Ra Anumzamofontega krafa huno nunamu nehuno, Hago haveknonu nahe frigahazanki, na'a nagra ama vahera huzmantegahue huno antahige'ne? ");
INSERT INTO kbq_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Anante Ra Anumzamo'a amanage huno asami'ne, Naeli tima amasagi'nana azompa eri'nenka, Israeli vahe'mokizmi zmavuga kva vahezaga zamavarenka ugagota hutma viho. ");
INSERT INTO kbq_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Hagi antahio, Horepi agonafi havemofo agofetu Nagra otina manigahuanki, kagra ana azompanu havea ome amasagigeno, timo'a anampinti hanatina negahaze. Higeno Mosese'a Israeli kva vahe'mokizmi zmavuga ana zana hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ana kumakura Mosese'a Masae nehuno, Meribae hu'ne, na'ankure Israeli vahe'mo'zama haframa nehu'za, Ra Anumzamofona rehe'za nege'za, Ra Anumzamo'a tagri amu'nompina mani'nefi omani'ne? ");
INSERT INTO kbq_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Anantera Ameleki vahe'mo'za e'za, Israeli vahera Refitimie nehzafi hara huzmante'naze. ");
INSERT INTO kbq_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ana hazageno Mosese'a anage huno Josuana asmi'ne, Mago'a vahera tagripintira huhamprizmantege'za Ameleki vahe'enena hara ome hiho. Okina nagra Anumzamofo azompa nzampi eri'ne'na agonarera otigahue. ");
INSERT INTO kbq_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mosese'ma asamia kante anteno, Josua'a Amaleki vahe'enena hara nehige'za, Mosese'ma, Aroni'ma, Huri'ma hu'za agonarega mreri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Hagi Mosese'ma azama erintesga hige'za, Israeli vahe'mo'za hara Amaleki vahera huzmangatere'naze. Hagi Mosese'ma aza'ma erinte fenka atrege'za, Ameleki vahe'mo'za Israeli vahera hara huzmagetere'naze. ");
INSERT INTO kbq_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Hianagi Mosese azamo'a arageramigeno, Aroni'ene Hurikea have erike, mopafi ante'nakeno anante mani'nege'ne, rugaraga mani'neke azana erisga hu'nakeno kinagaseno zagea urami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Josua'ene Israeli vahe'mo'za bainati kazinu Ameleki vahera zmahege'za kazimofo ne'za se'naze. ");
INSERT INTO kbq_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Anantera Ra Anumzamo'a anage huno Mosesena asami'ne, Ama ha'mofo agenke'a avontafepi kretenegeno avame'za me'nenke'za nege'za zmagera okaniho. Hagi Josuana hamprinka ama ana nanekea asamio, Nagra ama mopafintira Ameleki vahera zamahe fanane hanugeno zmagi zmagenkea ama mopafina omanegahie. ");
INSERT INTO kbq_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mosese'a anante Kresramanavu ita tro huno, Ra Anumzamo'a nagri krauvefani'e (frekie) huno agia antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mosese'a anage hu'ne, Ra Anumzamofo hanave eritre'za hazankino, Amaleki vahera henkama fore hunante anante hu'za esaza vahera, Ra Anumzamo'a huvempa hu'neankino ha' huzmantegahue hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro'a Mitieni vahe'mokizmi pristi nekino, Mosesena nenemo'e. Maka'zama Ra Anumzamo'ma Mosesene Agri'a vahe Israeli vahe'ma huzmante'neazana Jetro'a antahi'ne. Ra Anumzamo'ma Israeli vea'ene Mosesenema huzmanteno Isipiti'ma zamavreno atirami'nea zamofo nanekea antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mosese'a nenaro Ziporama huntegeno agranema umani'nenereti Jetro'a nevreno, ");
INSERT INTO kbq_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","tare ne' mofavre'ararena znavreno e'ne. Mosese'a huno, Ru vahe'mofo mopafi emani'noe nehuno, agonesa mofavre'amofo agi'a Gesomu'e huno ante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Hagi Mosese'a anante mofavre'amofo agi'a Eliesa'e hu'ne. Na'ankure nafa'nimofo Anumzamo naza higeno, Isipi kini ne'mofo bainati kazimo'a onahe'negure hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Hagi anantera Mosese nenemo Jetro'a, Mosese nenarone mofavre'ararene nezamavreno, ka'ma mopafi Mosese'ma Anumzamofo agona me'nerega seli noma kino mani'nere vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetro'a amanage huno Mosesentega kea atrente'ne, Nagra neganemo'na aka'ane tare mofavreka'ane zamavare'na kagenaku neone. ");
INSERT INTO kbq_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hagi Mosese'a ana nanekema nentahino vuno nenemo ome negeno, rena omenereno, otino antako hunenteno, hu frufra huntetege'ne, Mosese seli nompinka ufre'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Hagi Ra Anumzamo'a zamaza huno Isipi kini ne' Fero azampinti'ene Isipi vahe zamazampinti'ma zamahokeno zmavre fegi atre'nea nanekene, karanka zamavreno ne-ege'za maka knazama eri'za neageno, Ra Anumzamo'ma Israeli vahe'ma zamazama huno e'nea naneke'a Mosese'a nenemo nera Jetrona asmi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Anumzamo'ma knare'zantfa huno Isipi vahe'mokizmi zamazampinti zamahokeno zamavreno atirami'nea nanekea Jetro'a nentahino, tusi'a muse hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Anante Jetro'a amanage hu'ne, Isipi vahe'mofo azampinti'ene Fero azampinti'ene Isipi vahe'mofo kvafinti'ma tamahokeno'ma tamavreno atirami'nea Ra Anumzamofona ra agi'a hentesga hue. ");
INSERT INTO kbq_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Hagi menina nagra antahi'noe, mika havi anumzantamina agtereno, hihamu'ane Ra Anumzana tamage huno Agrake mani'ne. Na'ankure Isipi kva vahe'mo'zama zmavufga ra nehu'za, Agri vahe'ma Israeli vahe zamazeri haviza huzmante'naza vahera, zamazeri haviza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hagi Mosese nenemo Jetro'a tevefima kre fananema hu ofa erino, Anumzamofo Kresramana vunentegeno, anante Aroni zane, Israeli kva vahe'mo'za Jetro'ene emetru hu'za Anumzamofo avurera ne'zana ne'naze. ");
INSERT INTO kbq_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hagi maseno nanterana Mosese'a keagama refkohu trate mani'nege'za, Israeli vahe'mo'za emetru hu'za regagi'za oti'nazageno, mago'magomofo nanekea refko huno nentahigeno, vuno kinaga ome ase'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","E'inahu'zama Mosese'ma vahe'mokizmima hunezmantegeno, nenemo Jetro'a negeno amanage hu'ne, nankna'za ama vahe'mofona hunezmantane? Na'a agafare kagrakera mani'nenka nanekea refko nehankeno, ama vahe'mo'za oti'za mani'nazageno vuno kinaga omenese? ");
INSERT INTO kbq_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosese'a ana kemofo nona'a amanage huno nenemo Jetrona asami'ne, Na'ankure zamagra Anumzamofo avesi'za antahinaku nagritera emetru hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Hagi tava'ozmire'ma mani'naza vahe'enema zmagrama ha'frama nehu'za, nagrite azage'na zamaza hu'na naneke'zimia antahi'na refko nehu'na, Anumzamofo tra kene, kasegenena eri ama hu'na nezmasamue. ");
INSERT INTO kbq_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Higeno Jetro'a anage huno nenemo nera Mosesena asami'ne. E'inahu zama nehanana knare zana nosane. ");
INSERT INTO kbq_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ama eri'zana kna'a me'neankinka, kagrakera e'origahane. Kagrane vahe'ka'anena tamage huno tamavesra hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Hagi menina ke'ni'a antahio, nagra antahintahia kamisugeno Anumzamo'a kagrane manigahie. Kagra vahe'mokizmi zmagi erinka Anumzamofo avure mani'nenka, vahe'mo'zama ha'frama hanaza zana erinka Anumzamofo ome asamigahane. ");
INSERT INTO kbq_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ana nehunka kagra Anumzamofo tra kene kasegenena vahera rempi hunezminka, mani'zazimi eri fatgo hu'za kama nevu'za, eri'zama erisaza zamofona zmaveri hughane. ");
INSERT INTO kbq_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Hagi mago'ane Jetro'a huno, Vahepintira tamagema huno eri'zama eriga'ma nehuno, Anumzamofonku'ma kore'ma hunenteno, krunage'ma huno fenoma eri'zanku avesra nehia vahe'ene, huhampri zamantege'za 1 tauseni'a vahete kva manina, 1 hantreti'a vahete kva manina, 50'a vahete kva manina 10ni'a vahete kva manitere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","E'i ana kva vahe'mokizmi zamatrege'za maka knafina, vahe'mokizmi knazana refko huzmanteho. Hianagi ra hazenke'zana kagrite eri'za esagenka refko huzmanto. Hianagi ne'one knazazamia ana kva vahe'mo'za eri fatgo nehanageno, knama e'nerina zamo'a osi'a o'za hugantegahie. ");
INSERT INTO kbq_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Amama negasmua kema amage nentesankeno, Anumzamo kama kaverima hanigenka kazikazi hunka mika eri'zana knare hunka e'nerisankeno, vahe'mo'za muse nehu'za zamarimpa fru'ne nozimirega vu'za e'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosese'a, Jetro'ma asmi'nea kea antahino, ana maka kea amage ante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Hagi Israeli vahepinti knare'nare vahe'a Mosese'a huhampri zmantege'za, kva vahera mani'za 1 tauseni'a vahe'mokizmi kva nemanizageno, 100'a vahe'mokizmi kva nemanizageno, 50'a vahe'mokizmi kva nemanizageno, 10ni'a vahe'mokizmi kva manitere hu'za kegava hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ana kva vahe'mo'za maka knafina, refko'ma huga knazana zamagra'a refko hu'naze. Hianagi amuhoma hianknazamofo keaga eri'za Mosesente vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Anante Mosese'a nenemo nera Jetrona hu frufra huntegeno mopa'arega ete vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israeli vahe'mo'zama Isipima atre'zama atiramiza e'nazana, 3 ikamofo ese knare ka'ma kokampi Sainai ehanati'naze. ");
INSERT INTO kbq_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Zamagrama Refitimi kuma'ma netre'za Sainai ka'ma kokampi e'za Sainai agonamofo agafi seli nozamia emegi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Hagi Mosese'a Anumzamofo ome kenaku agonafi mrerigeno, Ra Anumzamo'a agonafinti anage huno hu'ne, Menina amanage hunka Jekopu nagamofona Israeli vahe'mokizmia zamasamio, ");
INSERT INTO kbq_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nagrama Isipi vahe'mofoma navu'nava'ma hunezmante'na tumpa namamo mofavre'a agekonare avrenteno avreno eaza hu'na, tamavre'na e'noazana tamagra'a ke'naze. ");
INSERT INTO kbq_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Hagi menima tamagra ke'nima nentahitma, huvempama hu'noake'ma tamage hutma amage'ma ante'nuta, maka mopane mopane vahepintira tamagrake Nagri vahera manigahaze. Na'ankure maka mopa Nagri mopa me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tamagra Nagrini'a pristi eri'za eri vahe mani'netma, ruotage hu'neni'a kuma vahe manigahaze huno hu'ne hunka Israeli vahera zmasamigahane. ");
INSERT INTO kbq_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ana hutegeno Mosese'a agonafinti eramino, Israeli kva vahe'zaga eme zamagihu atru huno, Anumzamo'ma ome zamasamio huno hunte'nea nanekea zamasami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Hige'za maka vahe'mo'za kenona hu'za, Ra Anumzamo'ma hugantegenka eme hana kea maka amage antegahune hu'za hazageno, Mosese'a anankea erino Ra Anumzamofonte vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ra Anumzamo'a anage huno Mosesena asmi'ne, Antahio, Nagra hampogino antrako hu'ne'nia hampompi e'na kagranena keaga eme nehanuge'za, nentahi'za kagrama hana kerera maka knafina zamentintia huvava hugahaze. Anante Mosese'a Israeli vahe'mokizmi nanekea Ra Anumzamofona asami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Higeno Ra Anumzamo'a mago'ene Mosesena asamino, Menine okinena zamagra zamazeri ruotage nehu'za, kukena zimia sesehu agru nehu'za, ");
INSERT INTO kbq_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","nampa 3 knarera retro hiho, na'ankure e'i ana knarera Ra Anumzamo'a maka vahe'mokizmi zmavuga Sainai agonafi eramigahie. ");
INSERT INTO kbq_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Hagi kagra avame'za agonamofo agafina anteganeginka anage huo, tamagra kva hu'netma agonafina agatereta ovutma, ana avame'zantema uravao huno avako huge, agonafima mrerige'ma hanimofona ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tamazanura avako hutma anamofona ahe ofrita, have knonu matevutma ahefrige, kevereti aheho. Vahe'mozafi afu'zagamo'zama anama hanazana frigahaze. Hagi mememofo pazivenu'ma za'zate'ma ufemaresageta, agonarega mrerigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Anante Mosese'a agona atreno uramino zamazeri ruotage nehige'za, kukena zamia sese hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mosese'a anage huno zamasami'ne, Nampa 3 knama esigu retro hutma nemanitma, a'netaminena omaseho. ");
INSERT INTO kbq_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Hagi nampa 3knama eanknamofo nanterana, monage nehigeno kopsinamo'a trage huno enevigeno, antrako hu'nea hampomo ana agona refitegeno, ufenkrafa nehigeno, nomaki'za maka mani'naza vahe'mokizmia tusi'a zmahirahitene. ");
INSERT INTO kbq_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Anante Ra Anumzamofo ome kehogu Mosese'a kumazmifinti zmavare fegi'a atreno zamavreno vige'za, agonamofo agiafi oti'naze. ");
INSERT INTO kbq_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Hagi Sainai agonamofona toki'mo'a miko refitevagare'ne. Na'ankure Ra Anumzamo'a tusi'a tevefi eramino emani'negeno, tuki'mo'a tusi'a tevefinti'ma nehiaza huno kamogamo nehigeno, tusi'a imi erino ana agona eri tore'vare hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Hanki ufemofo agerumo'ma rura huno nevigeno'a, Mosese'ma kema nehigeno, Anumzamo'a monagema hiaza huno kenona'a humi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ra Anumzamo'a Sainai agona morusate eneramino, Mosesena ke higeno mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Anantera Ra Anumzamo'a Mosesena anage huno asami'ne, uraminka vahe'mokizmia kore ke huzmantege'za, avame'zama tafinte'za kagi'naza zana agatere'za emreoriho. Anama hanaza vahe'mo'za frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hagi pristi vahe'mo'zama Ra Anumzamo'nare'ma erava'oma hunaku'ma hanu'za, zamagra'a zamazeri ruotage nehu'za zamazeri agru hiho. Ana'ma osnage'na Nagra zamazeri haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosese'a anage huno Ra Anumzamofona asami'ne, vahe'mo'za ama agonafina omegahaze. Na'ankure Kagra ko nasaminke'na avame'za ante'nogenka ana avame'zamofona agateretma emreoriho hunka hunagru hunte'nane. ");
INSERT INTO kbq_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Hagi Ra Anumzamo'a anage huno Mosesena asami'ne, Uraminka Aronina ome avrenka eno. Hianagi zmatrege'za pristi vahe'ene, mago'a vahe'mo'za avame'zana agatere'za agonafina Nagritega omeho. Hagi anama hanage'na, Nagra zamazeri haviza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mosese'a uramino ana vahetamina, Ra Anumzamo'ma huntea kea ome zamsami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Anante ana miko nanekea Ra Anumzamo'a amanage huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Nagra Isipi mopafima kazokzo eri'za vahe'ma mani'nazage'na tamavre'na atirami'noa Ra Anumzanki'na, tamagri Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nagrake tamagri Anumzana mani'noanki, ru anumzatmintera monora huonteho. ");
INSERT INTO kbq_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tamagra mago'azamofo amema'a antretma tro huntege, monafima me'ne'nia zamofo amema'a antretma tro huntege, mopa agu'a me'ne'nia zamofo amema'a antretma tro huntege, tigu'a me'nenia zamofo amema'a antretma kaza osu havi anumzana tro huntegera osiho. ");
INSERT INTO kbq_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ana zantmintera monora huntege, tamarenaregera osiho. Na'ankure Nagra Ra Anumzana, tamagri Anumzana kanivere Anumza mani'noanki'na, zmafahe'mo'za zamavaresrama hunenante'za kumi'ma hu'ne'saza kumitera, mofavretamine agehe'mofone, agigomofonena knaza zamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Hianagi iza'zo Nagri'ma zamavesinenante'za kasegeni'ama amage'ma ante'za vanaza vahe'mokizmia, vagaore navesi'zanteti zmavesinezmante'na, ana vahepinti'ma 1000ni'a zupama fore hunante anante'ma hu'za vnaza vahe'mokizminena zamavesi zmantegahue. ");
INSERT INTO kbq_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nagra Ra Anumzana tamagri Anumza mani'noanki, amnenena nagi'a oheho. Na'ankure amnenema nagima ahesimofona Nagra azeri haviza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Mani fruma hu knamofona (Sabatia) tamagesa are'are nehuta, ruotge hu'ne hutma kegava hiho. ");
INSERT INTO kbq_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tamagra mago sontamofona 6si'a knafinke miko eri'zantmia erigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Hianagi 7ni knazupa Ra Anumzana tamagri Anumzamo'na mani fruhu kna (Sabati) me'negu ana knarera, kagrane neka'ane, mofaka'ane, ve kazokzo eri'za vaheka'ane, a' kazokzo eri'za vaheka'ane, afu kevuka'ane, emani vahemo'zanena eri'zana e'oriho. ");
INSERT INTO kbq_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Na'ankure Ra Anumzamo'a 6si'a knafi monane, mopane, hagerine miko zama ana agu'afima me'nia zantamina tro huteno, 7ni knarera manigasa nehuno, Agra ana kna erinte ruotge huno asomu hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Neramarera nermafa ke'zni antahizmitma zmagorgama manisazana, Ra Anumzana, tamagri Anumzamo'nama tami'noa moparera zazate manitma vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tamagra vahera ahe ofriho. ");
INSERT INTO kbq_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tamagra aravema hu'nesaza vahe'motma, rumofo a'eneno rumofo venena monkozana osiho. ");
INSERT INTO kbq_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tamagra musufa oseho. ");
INSERT INTO kbq_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tamagra tava'ontmire'ma nemanisia vahe'mo'ma keagare'ma oti'nenigeta, osu'nesia zankura havigea huonteho. ");
INSERT INTO kbq_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tamagra tava'ontmire'ma nemanisaza vahe'mofo nonkuro, a'amofonkuro, ve eri'za vahe'o, a' eri'za vahe'o, bulimakao afu'o, donki afu'o, inankna inankna zantamima ante'nesniana keramasanea osiho. ");
INSERT INTO kbq_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Hagi monagea nehuno, kopasi'na e'nerigeno, ufenkrafa nehigeno, agonafinti'ma tevegumo'ma nehigeno'a, miko vahe'mo'za nege'za zamahirahiku nehu'za, ogantu'a oti'ne'za, ");
INSERT INTO kbq_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","amanage hu'za Mosesena asmi'naze, kagra'a kea hugeta antahimaneno. Hagi Anumzamo'a keaga ontasamino. Na'ankure Agrama keagama hanigeta, tagra frigahune. ");
INSERT INTO kbq_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosese'a zmasmino, tamagra korora osiho. Na'ankure menina Anumzamo'ma e'neana, reramaheno ke'nigetma, Agri'ma kore'ma hunte'zamo'a tamagripi me'nenigetma kumira osanazegu e'ne. ");
INSERT INTO kbq_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Anage hige'za ana veamo'za ogamu'a oti'nageno Mosese'a, haninentake hampomagino antrako'ma hu'nefima Anumzamo'ma mani'nerega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Anante Ra Anumzamo'a amanage huno Mosesena asmi'ne, Israeli vahera amanage hunka ome zamasmio, tamagratmia negazage'na monafintira nanekea tamasami'noe. ");
INSERT INTO kbq_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Nagrake Anumzana mani'noanki, tamagra magore hutma golire havi anumzano, silvarera havi anumzantmina trorahunteta monora huonteho. ");
INSERT INTO kbq_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Hagi Nagrite'ma Kresramanama vunantesaza ita mopareti tro huteta, ana itare sipisipi afu'ene bulimaka afu'nutira tamarimpa fruhu ofane, kre fnanene hu ofa Kresramana vugahaze. Hagi miko kazigama Nagrama hu'nama e'ire Nagrira antahinamita monora hunantegahaze hu'nama hanure, ana ita trohuta kre'sramna nevinke'na, Nagra eme asomura hurmanta'neno. ");
INSERT INTO kbq_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Hagi kresramnama vu itama havereti'ma tro hanutma, vahe'mo'ma tagama osu'nesia havereti tro hiho. Na'ankure vahe'mo'ma tagama hu havereti'ma Kresramana vu itama tro'ma hanazana, ana itamo'a ruotagera huno agru osugahianki, haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Hagi Nagritegama kresramna vu itama tro'ma hanuta, zaza ita tro hu'neta lata anteta ofa hunakura mrenerinke'za, vahe'mo'za tamariga onkeho. ");
INSERT INTO kbq_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Mosesega ama'na kasegea Israeli vahe'mokizmi zamigahane. ");
INSERT INTO kbq_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kagrama Hibru vahepinti'ma kazokzo eri'za vahe'ma mizama asenunka, 6si'a kafufinke kagri kazokazo eri'za vahera manite'na, 7ni kafurera atregeno mizana osu amne fru huno vino. ");
INSERT INTO kbq_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ana kazokzo eri'za ne'mo'ma a'ma e'orinenigenka mizama hu'nenunka, anama hunte'nana kafurera atregeno agrake vino. Hianagi ko'ma a'ma ante'nenia ne'ma mizama se'nesunka, ana a'ene atregeno vino. ");
INSERT INTO kbq_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Hagi kazokzo eri'za ne'ma mizama se'ne'nia venafo'ma a'ma miza humi'nenigeno mofavrema ante'nenuno'a, ana a'ane ne'mofa'anena ana venafo azampi netreno, agrake vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Hianagi ana kazokzo eri'za ne'mo'ma huama'ma huno, nagri'ma mizaseno nafa'a hunante'nemofonku'ene a'ni'agu'ene mofavreni'agura tusiza huno navenesiankina nagra zamatre'na fru hu'na amne ovugahue huno'ma hanigeno'a, ");
INSERT INTO kbq_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mizama hunte'nea kva'amo'ma avreno Anumzamofonte vuteno, ete avreno kafa zafarero ete kafantero vuno hakare vahe avufi vahe'ma zamagesa rerapone zota erino agesa reraponenkeno agri kazokzo eri'za vahe mani'neno ufrigahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Mago ne'mo'ma, mofa'ama kazokazo eri'za mofa manisie huno'ma zagore'ma atresige'noma mizamasesiana, ve kazozko eri'za vahe'ma nehiaza huno, 7ni kafurera atresigenora frua huno amnea ovugahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ana mofa'ma a'nie huno miza hu'ne'nia venafo'ma muse osania zama hanigeno'a, ana venafo'a ana mofara atrenkeno ete nefa'a miza hino. Hagi ana mofa'ma miza hu'nenia venafo'ma mago'enena ru kaziga vahetera mizantera ozmino, na'ankure, kva'amo'a agra'a ana mofa'mofo so'e manizama'a eri haviza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Hagi ana mofa'ma miza hu'nea ne'mo'ma, ne'mofonte'ma a'e huno huntenesuno'a, agra mofa'ama kegava nehiaza huno kegava hunteno. ");
INSERT INTO kbq_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Hagi henka'ama, ana ne'mo'ma ru a'ma erisnuno'a, pusa a'enena ko'ma nehiaza huno nemaseno, knare huno kukena'ane kave'are'enena kegava huntegahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Hagi ana 3'a zama huntega'zama, ana a'mofoma huontesigeno'a, ana a'mo'a zagoa miza osu amne atreno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Iza'o vahe'ma ahe frisia nera, agri'enena ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Hianagi mago ne'mo'ma mago'azama hanifi hantaga huno mago vahe'ma ahe frisiana, Anumzamo atresigeno ana zana fore hugahiankino, agu'vazi kuma'ma retro'ma huntenerega ana ne'mo'a freno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ana hu'neanagi mago ne'mo'ma vahe'ma ahe friku'ma, oku'ama antahintahi retro huteno, ana ne'ma ahe frina, ana nera Kresramana vu itareti'enena amne avazu huta ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Iza'o nefano nererano ahesia nera, ahenkeno frino. ");
INSERT INTO kbq_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Iza'o mago vahe'ma musufa avreno eme frakino antege, zagore atrege'ma hania nera ahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Iza'o nererano nefanoma huhaviza huntesia nera ahenkeno frino. ");
INSERT INTO kbq_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Tare netremoke'ma fra nevazisapinti'ma, mago'mo'ma azanknonuro have knonuro ahenkeno ofrigahianagi, ana zanku'ma krima erino'ma mani'nenigeno, ");
INSERT INTO kbq_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kri'amo'ma osi'a knare hinkeno'ma azompare megi'a vanoma hanigeno'a, ahe'nea nera kanazana omigahie. Hianagi krima maseneno kna'ama atre'nea zantera miza hunenteno kegava hunentenkeno kriamo'a knare ome huntegahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Mago ne'mo'ma kazokzo eri'za ne'amofono, kazokzo eri'za a'amofoma kanonu'ma ahenkeno frisiana, ana kazokzo eriza vahe'mofo nafa'amofo kanazana amiho. ");
INSERT INTO kbq_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Hianagi ana kazokazo eri'za vahe'mo'ma mago kano, tare kanama manite'no'ma knamare'niana, anama ahe'nea kva nera kna omigahaze. Na'ankure ana kazokzo eri'za nera mizamase'nea ne'mofo su'za mani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tare netremoke'ma ha' nehu'ne mago'ma amu'ene hu'nesnia a'ma ahesigeno nena osu'nesia mofavrema kasenenteno, ana a'mo'ma hazenke'ma e'orisigeno'a, ana a'mofo neve'ma zago agima ahentesiama'a miza neseno nanekema refkohu kva vahe'mo'ma e'i'a amio hanazama'a amino. ");
INSERT INTO kbq_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Hianagi ana a'mo'ma ra hazenke'ma erinkeno'a, anahukna hazenke agri'enena amigahaze. Ahe fri'nirera, agri'enena ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Hagi avurgama repro haniana, agri'enena avurga repro hiho. Hagi ave'ma ru tafrina, agri'enena ave ru tafriho, hagi agia azama ruhantgina, agri'enena anazanke huta agiaza ruhantgiho. ");
INSERT INTO kbq_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Tevefima kre kasage'na, agri'enena tevefi kre kasageho, avufga rutraga hu'nena, ana zanke huta agri'enena avufga rutraga hiho. Hagi aheno avufgama ru korampamagi'nena, ana nera aheta avufga ru korampagiho. ");
INSERT INTO kbq_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kazokzo eri'za nero, kazokzo eri'za aro mizama sentenesia kva'amo avurgama repro hutrenkeno'a, agra ana nona'a atresigeno ana kazokzo eri'za vahe'mo'a zagoa miza osu fru huno amne vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hagi kazokzo eri'za ne'amofono, a'amofoma mizama se'nesia venafo'ma aheno mago ave'ma ru tafrisiana, ana kazokzo eri'za vahe'a ana nona'a atrenkeno mizana oseno fru huno amne vino. ");
INSERT INTO kbq_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Mago ve bulimakao afu'mo'ma mago nero, aro pazive anuti'ma ahe frinketa, ana ve bulimakao afura have knonteti ahefrinkeno frina avufaga'a oneho. Hianagi ana ve bulimakamofo venafona keaga hunteta kna omiho. ");
INSERT INTO kbq_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Hianagi ana ve bulimakamo'ma vahe'ma nehe'nigenoma kegina huno antenogu eme asamisage'noma, ana kema eritreno bulimaka'ama keginafima avre onte'nenigeno mago veo aro ahefrisigeno'a, ana ve bulimakao'a havenkanonu ahenefritma, bulimakao nefanena ahefriho. ");
INSERT INTO kbq_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ana hugahianagi bulimakaomo'ma ahefrinesia vahe'mofo nona hinogu'ma naga'amozama miza agima ahentesazama'a mizaseno. ");
INSERT INTO kbq_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Mago mofaro, ne'mofavreo, bulimakao afu'mo'ma pazive'anuma ahe frinkeno'a anazanke huno mizaseno. ");
INSERT INTO kbq_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Bulimakao afu'mo'ma mago kazokazo eri'za aro veoma pazive'anuti'ma ahe frinkeno'a, ana eri'za vahe'mofo kva nera bulimakaomofo venafo'a 30'a silva zago nemino, ana bulimakao afura have knonu ahe frino. ");
INSERT INTO kbq_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Mago' vahe'mo'ma keri kafinenteno'o kafinte'nesia kerima eri hagaro huteno refi otenenige'noma mago' ne'mofo bulimakao afumo'o donki afumo'ma ana kerifima uramina, ");
INSERT INTO kbq_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","kerima asente'nesnimo'a ana bulimakaono, tonki afutera nona huno miza hinkeno, anama frisia zagamo'a agriza segahie. ");
INSERT INTO kbq_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Mago ne'mofo bulimakao afumo'ma, mago ne'mofo bulimakao afu'ma ahefrina, ana bulimakao afutremofo nafa'amokea amnema manisia bulimakao afura zagore atreke ana zagoa amu'nompinti refako nehuke, anama fri'nea bulimakao afura amu'nompinti arutaneke refako hi'o. ");
INSERT INTO kbq_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Hianagi ko'ma pazive'anuti'ma ha'ma nehania bulimakao afumofo venafo'ma antahi'neno keginafima onte'nenigeno, rumofo bulimakao afu'ma ahefrisiana, anama frisia bulimakao afu'mofo venafo'na ete bulimakao afuteti nona huno miza senenteno fri'nesia bulimakao afura erigahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Mago ne'mo'ma ru vahe'mofo bulimakao afuro sipisipi afu'ma kumazafa aheno tragahuge, kumazafa seno zagore ome atrege'ma hu'nenimo'a, mago bulimakao afu'ma kumzafa asenenirera venafona 5fu'a bulimakao nona huno mizasenteno. Mago sipisipi afu'ma kumzafa asenesirera 4'a sipisipi afu venafona nona huno mizasentegahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Hagi mago kumzafa ne'mo noma anafe huno ufreno kumzafa nesena, ageno erifore huno ahe frisiana, anama ahe frisia ne'mofo korankumimo'a agritera omanegahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Hianagi ko'ma zagema hanati'noma masama hu'nesifima kumzafa nesena nomofo venafo'ma keno erifore huno'ma ahe frisiana, agritera ana ne'mofo korankumi'mo'a megahie. Hagi kumzafama nesenigeno keno eriforema haniana ana mika zama kumzafa se'nenia zantera mizaseno. Hagi ana zante'ma temaosinigeno'a, ana kumzafa nera zagore atre'za ana zagoa eri'za kumzafama eri'nea zamofo nona'a mizaseho. ");
INSERT INTO kbq_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Mago ne'mo'ma rumofo bulimakao afuro, sipsipi afuro, donki afuro kumzafaseno ome ante'nenkeno keno erifore'ma hina, anama kumzafa se'nenia ne'mo'a ana nona'a ante tragoteno kumzafama ase'nenia zaga venafona amino. ");
INSERT INTO kbq_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Mago ne'mofo sipsipi'amo'o bulimakao'ama atrenkeno trazama neno vano haniregama rumofo kaziga traza omenege, waini hozafi vuno waini hoza ome eri haviza haniana, ana bulimakao afu'mofo nafa'amo'a, knare hoza'areti'ene knare waini'areti'ene anama hoza'ama eri haviza hu'nea nera nona'a amino. ");
INSERT INTO kbq_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hagi mago'mo'ma hoza'afima trazama negresigeno tevemo'ma terakaheno rumofo witi hoza vasage ante'nenia witima tena, tevema hugre'nenimo'a ana zantmintera nona'a huno mizasenteno. ");
INSERT INTO kbq_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Mago ne'mo'ma tavaoma'are nemanisimofoma zago'afi fenoma'ama, kegava huntenogu ami'nesigeno kegava hunte'nesigeno, kumzafa ne'mo'ma anazama noma'afinti musufama se'nenia ne'ma ke'za erifore hanageno'a ana kumazafa ne'mo'a ante tragoteno miza seno. ");
INSERT INTO kbq_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Hanki kumzafa ne'ma keno erifore'ma osina, nomofo nefa'a keaga refkohu kva vahe'tmimofo avuga eno eri'neo e'o'rineo eme huama hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Hagi mago'mo'ma bulimakao afuro, donki afuro, sipsipi afuro, kukeno, mago'a zantmima fanane hu'nenia zantmima tavaoma'are nemanisimo'ma ante'nenkeno, ama nagri suzane huno'ma ome hanige'noma antahima omisigeno'a keaga refkohu kva vahete e'nakeno keaga refkohu kva vahe'mo'ma, kagra havi kavukava hu'nanema hanimo'a ante tragoteno mizaseno. ");
INSERT INTO kbq_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Mago ne'mo'ma tava'oma'are'ma nemanisimo'ma donki afuro, bulimaka afuro, sipsipi afuro, mago'a zagagafama kegava huntenogu'ma ami'nesia zagamo'ma frige, hazenke erige, vahe'mo'ma onkesigeno avreno frege'ma haniana, ");
INSERT INTO kbq_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ana zagarmima kegava hu'nesnia ne'ene ana zagaramimofo venafokea Ra Anumzamofo avuga vanakeno kegavama hu'nemo'a huvempa huno, tamage hu'na nagra onke'noe hanigeno'a, venafo'ma mago rimpama hanigeno'a ana zagaramintera miza osegahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Hianagi tamagema huno musufama se'nesageno'a, fenozama'ama kegava hu'nesimo venafona mizasenteno. ");
INSERT INTO kbq_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Hanki afi zagamo'ma aheno'ma neneno, avufga'ama ani kafritre'neniama'a erino, ana zagamofo venafoma ome averi'nuno'a ana zagarera miza osegahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Hanki mago ne'mo'ma, tava'oma'are'ma nemanisimofo zagagafama avreno eme kegava hu'nenkeno'ma, ana zagagafamofo venafo'ma omani'nensire'ma avufgare hazenkema erige frige'ma hinkeno'a, ana zagama avreno kegava hu'ne'nia ne'mo'a nona huno venafona mizasenteno. ");
INSERT INTO kbq_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Hanki ana zagamofo venafo'ma mani'neno negenkeno, eri'za e'nerino hazenkema erinkeno'a, miza osegahie. Eri'zama erinogu'ma zagoma amino avre'neniana, e'i ana zagomo aza hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Mago'ma vene ovase'nesia mofa'ma mago ne'mo'ma avreno ome anteno vase'nena afufeno huno mizasenkeno ana mofamo'a agri a' manino. ");
INSERT INTO kbq_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Hanki ana mofa'mofo nefa'ma, ana vere omanigahiema hinkeno'a, ana ne'mo'a afufenoma nehaza avamente afufenona huno ana mofa'mofo nefana amigahie. ");
INSERT INTO kbq_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Avuatgama nehania a'nea zamahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Iza'o zagagafanema monko'zama hanimofona ahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ra Anumzamofonte'ma kresramna vuonteno, havi anumazante'ma kresramnama vuntesimofona ahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mago'ma ru mopareti vahe'ma kagrane emani'nena, azeri havi zana osuge knazana omio. Na'ankure kotera kagranena Isipi moparera umani vahe mani'nenka hu'nane. ");
INSERT INTO kbq_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mago'ma kento aro, megusa mofavrema mani'nesiana azeri haviza osiho. ");
INSERT INTO kbq_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Hagi zamazeri haviza hanage'za, Nagritegama krafa hanage'na, Nagrama tamage hu'na krafagezmi antahisu'na, ");
INSERT INTO kbq_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","tusi nasivazinke'na tamahe fanane hanenke'za a'netamimo'za kento mani'nageno, mofavre tamimo'za megusa manigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Nagri vahe'mo'za zamunte omanena atupa hu'ne'za zagoma kagripinti nofi'ma hu'nenagenka, anante ante agofetu hunka namio hunka osuo. ");
INSERT INTO kbq_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Tava'onkare'ma nemanisimo'ma zagoka'ama nofi nehanigenka huvempa hana'a avame'zana anakre ku'a eri'nesunka, zagea uofre'nenkenka ana zupage amio. ");
INSERT INTO kbq_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Na'ankure agra magoke nakreku ante'neankino, kenagera e'i ana anakre ku kofino zasi korora vasegahie. Hagi ko'ma eme ominankeno'ma Nagritegama kezatina, Nagra nasunku Anumzanki'na nentahi'na eme aza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Nagrira huhaviza hunantege, kva vahetamia huhaviza huntegera osiho. ");
INSERT INTO kbq_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Hozatamifinti'ma Nagri'ma ofama naminaku'ma vasagesaza ne'zano, zafa rgamofo tima'a za'za kna azerita oviho. Tamagonesa ne'mofavre'tamia Nagri namigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Anahukna hutma ese anenta'ma bulimakao afu'mo'ene sipisipi afu'mo'enema antenigeta Nagri avretma eme namiho. Nerera'ma ese anentama antena atrenkeno nerera'enena 7ni'a kna manite'na, 8ti knarera avreta eme namiho. ");
INSERT INTO kbq_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Tamagra Nagri ruotge naga mani'nazagu, afi zagagafamo'ma aheno neneno'ma atre'nesia zaga onetma kra aminkeno neno. ");
INSERT INTO kbq_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Vahe'mo'ma osu'nesiazankura krunagea hutma vano osiho. Hazenke vahetega anteta havi kea keagafina huamara osiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Rama'a vahera avaririnka kefo avu'ava zana osuo. Hagi mago'mo'ma keagare'ma oti'nenama, rama'a vahe'mo'za havi kema hunente'nagenka kagranena zamavaririnka havi kea osuo. ");
INSERT INTO kbq_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hanki mago zanarimpa osu'neke ke ha'ma nehanankenka, amunte omane nere hunka agri kazigagera onto. ");
INSERT INTO kbq_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ha' vahekamofo bulimakao afuro donki afumo'ma hazagre'nena kesnunka, ete avrenka nafa'amofo ome amio. ");
INSERT INTO kbq_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Avesinogantesnia ne'mofo tonki afumo'ma, tusi'a knaza erino nevanifintima ome traka huno'ma masenenkenka, ana nera aza hunka donki afu'a azeri otio. ");
INSERT INTO kbq_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Hanki amunte omne vahe'mo'ma keagafima oti'nesigenka amunte me'nea vahetega antenka azeri havizana osunka keaga antahi so'e huo. ");
INSERT INTO kbq_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Havigea hunka hazenkema osu'nesia vahera keagafina avrentege ahe frigera osunka ogantu'a manio. Na'ankure Nagra e'inama hanaza vahetamimofo kumira atre ozmantegosue. ");
INSERT INTO kbq_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Keagafima mani'neno'ma aza huogu'ma masavema huno kamisia zana e'orio. Na'ankure masavema huno aza hinogu'ma ami zamo'a, keagama refkohu vahe'mofo avurga eri asu higeno, fatgo vahe'mofo kea eri rukrahe nehie. ");
INSERT INTO kbq_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ru moparetima tamagranema emani'naza vahera zamazeri havi zana osiho. Na'ankure tamagrama Isipi moparema mani'netama eri'naza knazana antahi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Tamagra hoza 6si'a kafumofo agu'afi erita nenteta, ne'zama'a vasageho. ");
INSERT INTO kbq_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Hianagi 7ni kafurera ana mopafina hoza onteta atrenkeno manigsa hino. Hagi ana mopafima agra'ama hagesia ne'zana atrenkeno zamunte omane vahe'mo'za eri'za nenenkeno, mago'a afi zagagafamo'za neho. Ana zanke huta olivi zafa hozane waini zafa hozanena onkrita atrenkeno mopamo'a amne meno. ");
INSERT INTO kbq_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Miko erizantamia 6si'a zage knafi erigahaze. Hianagi 7ni zagekna zupa manigsa hinkeno bulimakao afutamimo'ene donki afutamimo'ene, tamagri kazokzo eri'za a'mofo mofavretamine, emani vahe'mo'zama eri'zama e'nerisaza nena manigsa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Nagrama huogu'ma kasami'noa kea antahi ankere'nenka, havi anumazantmimofo agiramina ahege, ana anumzatmimofo agigenke'a huama osiho. Nehinke'za zamagra ontahiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Mago kafufina 3'a zupa atru huta ne'zana kreta neneta, monora hunantetere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Nagrama hurmante'noaza hutma ese ne'zama nesazana 7ni'a zageknafi zo-ore bretia neho. E'i ana ne'zana Avibi (March-April) ikante netere hiho. Na'ankure e'i ana ikante Isipitira atreta atiramita e'naze. E'ina hu'negu ana mika'mo'za amnea ome'za zamente zamente kresramna vu musezana eri'za eho. ");
INSERT INTO kbq_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Anantera ne'zama hamare'zamofo musema hu knarera, ese'ma hozafima nenama hania kavera emeritru hutma ne'zana neneta musena nehutma, ana hukna huta ne'zama vasage nompima ante vagare knarera, ne'zana neneta musena hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Mago kafufina 3'a zupa mika venene'motma Hankavenentake Ra Anumzamo'na navuga etere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Nagritegama kresramnama vunantesaza zagamofo koranpina zistima me'nesiazana erinteta Kresramana vuonanteho. Hianagi ana zagagafamofo afovamo'a me'nenkeno kora otino, hanki ana zupage tevefi kre fanane hiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ese ne'zama hozatamifinti'ma vasagesazana eritma Rantami Anumzamofo nompi eme amiho. Hagi anenta meme afura nerera ami rimpina onkreho. ");
INSERT INTO kbq_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Antahiho, Nagra ankero vahe'ni'a huntoankino, ugota hurmanteno nevuno kantega kegava huramanteno retro'ma huramante'noa kumatera vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ana ne'mo'ma mika'a kema kasmisiana, hara reontenka ke'a antahinka erizafa huo. Na'ankure Nagri nagimo'a agripi me'nena, ha'marentesanana kumika'a atreogantegosie. ");
INSERT INTO kbq_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Hianagi Nagrama asamisua kema tamasmi'na ke'ama antahita avaririsage'na, Nagra ha' vahetamimofona ha' hunentena, ha'ma rezmantesaza vahera ha' rezamantegahue. ");
INSERT INTO kbq_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Na'ankure ankeronimo'a ugagota hurmanteno tamavreno Amori vahepine, Hiti vahepine, Perisi vahepine, Kenani vahepine, Hivi vahepine, Jebusi vahe'mofo mopafinena nevina, Nagra ana kumatmimpi vahetmina zmahehana hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Zamagri anumzatmintera tamarenarege monora huntege, zamavu'zmavara avaririta osiho. Hagi mika havi anumzazmia erita rurako hutreho. ");
INSERT INTO kbq_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Hagi Anumza Rantamimofona Agrike monora hunentenke'na, ne'zama nesaza zane, tima nesaza zana asomu huneramante'na kria amu'notmifintira eritra'neno. ");
INSERT INTO kbq_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hagi mofavrea kase ofri knare hu'za kse nezmante'nageno, magore huno naravora ana mopafina omanigahie. Hagi ana mopafina tamagra zaza kna manitetma frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Nagra vugota hu'na ana ha' vahetimia zamazeri kore neha'nena antahintahi zamimo'a savri nehina rukrahe hu'za kore fregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nagra tume huntanenkeno ugota hurmanteno Hivi vahe'ma, Kenani vahe'ma, Hiti vahera zmarotago hinke'za ana mopafina omanigosaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Hianagi magoke kafufinkera zamahe kaso'opegosue, na'ankure e'inama hanugeno'a, afi zagagafamo'a forehu hakare huno mika kaziga avite'neno, tamazeri havizantfa hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","E'igu akohe'na, ha' vahetimia osi'a zamazeri atretere nehanugeta, hakare vahe'ma fore huta miko mopa mani aviteghaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mopatimimofo atupa'ama ometre emetrema hu'neana, koranke hgerinteti eri agafa huno vuno Medeterenia hagerinte ome atregahie. Hagi mago kaziga asopa'amo'a ka'ma mopareti erigafa huno vuno Yufretisi tinte ome atregahie. Hagi e'i ana mopafima nemaniza vahera Nagra tamaza nehane'na mopazmia zamaheta hanaregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Hanki mago huvempa kea ana mopare vahe'eneno, anumzazmirera huta eri hageorafiho. ");
INSERT INTO kbq_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Zamatrenke'za tamagri mopafina omaniho. Na'ankure tamazeri savari hanageta havi anumzante monora hunenteta kumi hanageno, kukomo tamazeriankna hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ra Anumzamo'a amanage huno Mosesena asami'ne, Kagrama, Eroni'ma, Natabu'ma, Abihu'ene 70'a Israeli kva vahe'enena Nagrama mani'noa agonare emarerita ana mikomota ogantu'a emani'neta monora hunanteho. ");
INSERT INTO kbq_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Hianagi Mosesega kagrake Ra Anumzamo'narera erava'oa hugahananki, kagranema maka e'naza kva vahe'mo'za ogantu'a maniho. Hagi magomo'e huno Mosese'enena emareorino. ");
INSERT INTO kbq_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Anante Mosese'a eazamo Ra Anumzamo'ma asamia nanekene, tra kea eme zamasamige'za maka veamo'za oti'za mago zamagi ante'za, maka kema Ra Anumzamo'ma Mosesema asamino hihoma hiazana hugahune hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Anantera Mosese'a ana miko kema Ra Anumzamo'ma asmi'nea nanekea avontafepi krente'ne. Nanterame otino ana agonamofo agafinka 12fu'a Israeli naga nofi'mofo agire 12fu'a have eri atru huno kresramana vu ita trohu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ana huteno Israeli vahepinti nehazavermi huzamantege'za tevefima kre fanane hu kresramna negre'za, agaho ve bulimakao afu'nuti rimpa fru hu ofa Ra Anumzamofona hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Anama hutageno'a Mosese'a ana bulimaka afu'mofo korana amu'nompinti tagi fako huno mago'a zuomparamimpi nenteno mago'a korana kre sramanama vu itare aru tri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ana'ma huteno'a Mosese'a eri hagerafi huvempa kema krente'nea avontafe erino hampritege'za veamo'za, nentahi'za amanage hu'naze, ana miko zama Ra Anumzamo'ma hihoma hiazana amage nenteta, miko ke'a amage antegahune. ");
INSERT INTO kbq_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Anagema hazageno'a Mosese'a zuomparamipima taginte'nea bulimaka afu korana reno ana vahetamimofo zamagofetu aru tri nehuno amanage hu'ne, antahiho Ra Anumzamo'ma ke'anuti'ma eri hagerafi huvempa kema hu'nea korane huno eri ama hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ana hutege'za Aroni'ma Nadabu'ma, Abihu'ma, 70'a Israeli kva vahetamimo'zanena Mosese'ene agonafi mareri'za, ");
INSERT INTO kbq_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israeli vahe'mofo Anumzana ome ke'naze. Ana Anumzamo'ma agiama reno'ma oti'neana safie nehaza havereti tro huntegeno pehe huno hokonke huno mona kna hu'nea zante otinege'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Hu'neanagi Agri'ma kazazankura, ana Anumzamo'a Israeli kva vahetamina zamahe ofrige'za mani'ne'za ne'zane tinena ne'naze. ");
INSERT INTO kbq_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ana'ma nehazageno Ra Anumzamo'a amanage huno Mosesenkura hu'ne, marerinka agonare'ma mani'nore enka emani'nege'na, rempima huzami'nana kasegene hihogu'ma havere'ma krente'noa nanekea kami'neno. ");
INSERT INTO kbq_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Anage'ma higeno Mosese'a otino eri'za vahe'a Josuana avregeke Anumzamofo agonarega mareri'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Hianagi Mosese'a amanage huno Israeli kva vahetminkura hu'ne. Ama anante tavega antetma mani'nenketa vuteta ete a'mneno. Hagi amu'notmifima hafra hu'zama fore'ma hanigeta, Aroni'ene Hurike manina'ankike tamazeri fatgo hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Anage huteno ana agonafi Mosese'a marerigeno hampomo'a ana agona refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ra Anumzamofo hihamu masazamo'a Sainai agonare eramino me'negeno, hampomo'a refite'negeno 6si'a zagegna evutegeno, 7ni knarera ana hampompinti Mosesena kea humi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Hagi Israeli vahe'mokizmi zamavurera Ra Anumzamofo himamu masa'amo'a anamu ana agonafina keonke'za tefanane hu tevenefa kna hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hagi Mosese'a ana agonafima marerino tusi'a hampompi ufreno 40'a zagegnagi 40'a keregeki huno umani'ne. ");
INSERT INTO kbq_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Hagi Ra Anumzamo'a amanage huno Mosesena asmi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israeli veara zamasmige'za ofa eri'za eme namiho. Iza'o ofama nami musezamo'ma agu'afima avitenkeno eme kamisia ofage erio. ");
INSERT INTO kbq_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ana ofama eri'za esazana amanahu'za eri'za eho, golima silvama, bronsima, ");
INSERT INTO kbq_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","hokonke nofi'ma, fitunke'ma, koranke'ma efeke nofi'ma, meme azoka'ma, ");
INSERT INTO kbq_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","eri korankre hunte ve sipisipi akru'ama, hage rimpi bulimakaomofo frufru huno zmana'zmana hu'nea ukri'ma akasia zafama, ");
INSERT INTO kbq_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","tavi taginte olivi masavema, knare mana neviazama masavefima eri havia huno'ma vahe'ma asenire'ma taginteno asomu'ma hunenteazama, tevefima kregenoma manavu'zama, ");
INSERT INTO kbq_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ugagota pristi vahe'mo amega antani kukenare'ma ante'zana oniksi nehaza haveramine, mago'a zago'amo mareri'nea haveramine amimizare antani'za eri'za eho. ");
INSERT INTO kbq_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Hagi Israeli veamo'za ruotage seli mono noni'a kinanteke'na Nagra zamagri amu'nompi emani'neno. ");
INSERT INTO kbq_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nagrama kaveri'ma hanua kante antenka, ana seli mono none maka agu'afima me'nia zantamina trohuo. ");
INSERT INTO kbq_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Hagi huge'za akasia zafareti mago vogisi tro hiho. Ana vogisimofona zaza'amo'a 110 sentimita hinkeno, atupa'amo'a 66 sentimita hinkeno, mareri'amo'a 66 sentimita hino. ");
INSERT INTO kbq_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ana vogisimofo agu'afine fegi'anena golinutike'za eri anonevazita agema'aramintera golinutike eri avozaze hutma eri pehe hiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Hanki 4'a rinire golire tro huta fenkami kaziga agente agentera tare tare hutma ome rekamarente eme arekamarente hiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ana nehuta Akasia zafa antrenteta tare zota trohuta golinuti eri ano vazinteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","E'i ana tare zafa ana vogisima erisga huno vu'zana anama 4'a rekamarente'naza rinifinka antaninteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Hagi ana zotarerena, huhagerafi vogisimofo rinifinkatira avazuhu otreta atrenkeno anante meno. ");
INSERT INTO kbq_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ana vogisima trohu vagaresnunka, tare havere'ma kasegema kregamisuana, ana vogisimofo agu'afi anto. ");
INSERT INTO kbq_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Hanki ana vogisimofona, asunku zamofo trare hutma avaza'a goliretike tro hinkeno, zaza'amo'a 110ni'a sentemita hinkeno, atupa kaziga'amo'a 66si'a sentemita hino. ");
INSERT INTO kbq_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Hanki hamanu golia ruguta huta tare serabimie nehaza ankerontre tro huteta, vogisimofo avaza'are asunku tra'mofo agofetu rugaraga agentera anteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Serabimie nehaza ankerontre'ma tro'ma hanazana, anama asunku zamofo tra'ma tro'ma hanaza golinutike, rugaraga agentera ana ankerontrena trohunteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ana Serabim ankeroremokea zanavugosa ohumi ahumi nehuke, kepri huke asunku tra'mofo negenakeno zanageko'namo'a, rufanara huno ana vogisia refiteno. ");
INSERT INTO kbq_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Hagi tare havere'ma huhagerafi huvempahu kasegema kre tamami'noa erita ana vogisimofo agu'afinka nenteta, asunku tra'mofo avaza'a erita refiteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Nagra e'i ana asunku tra'mofo agofetu'ma Serabim ankerontremofo amu'nompi emani'ne'na maka kasegeni'a negasmi'nena, Israeli veara zamasmigahane. ");
INSERT INTO kbq_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Anantera mago tra akasia zafareti tro hiho. Ana tra'mofona zaza'amo'a 88'a sentimita hinkeno, atupa'amo'a 44'a sentimita hinkeno, mareri'amo'a 66'a sentimita hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ana tra'mofona golinutike eri ano nevazita agema'aramintera ana golinutike eri avozaze hutma eri pehe hutma avareho. ");
INSERT INTO kbq_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hagi ana tra'mofo atumpa'are'ma eri agu'a huno rugagisiana 8'a sentimita hina, golinutike eri avozaze hutma avareho. ");
INSERT INTO kbq_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ana huteta 4'a golire rini tro huta 4'a atuparera 4'a agamofo tavaontera mago mago rekamarenteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Ana 4'a rinima rekamarentesaza tra'mofona anagami rugaraga agentega rekamrente'nenkeno ana riniramimpina erisga huno vu'zana tare zota antanitegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ana huteta akasia zafareti tare zotarare antreta tro huteta golinuti masavena frentenkeno, e'i ana zotararenteti ana trara zafa hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hanki tima taginte zuomparamine waini tima tagi'zama ofama hanaza tintafene kapunena golinutike'za tro huntenkeno ana tratera meno. ");
INSERT INTO kbq_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Hagi Nagri navure'ma antesageno me'nia bretia, ana trate antenkeno mika zupa meno. ");
INSERT INTO kbq_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tavi'ma rekru hunte azota tro'ma hanazana, retarure agi'agi, rampa'agi, azankuna'araminki asina'agna'ma hutma tro'ma huntesazama'agi, amosre'agna'ma hutma tavi'ma rekruhunte'ama tro'ma hnazana hamanteti aruta magoke golinutike trohunteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hagi ana tavi zotamofona 6si'a azankuna tro hunteho. Rugaraga 3'a azankuna metere hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hagi ana zotamofo 6si'a tavi'ma rekru hunte azankunatamimofo atumparega, almoni zafamofo ani'na'ane amosare'agna hunka tavi'ma rekruhunte'a tro hunto. ");
INSERT INTO kbq_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Hanki amu'nompima mareri'nea zotarera, almoni zafamofo 4'a amosare'agna hutma tavi'ma rekruhunte'a tro hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hanki ana zotamofoma rugaraga azankunatrema tro hunte'narera almoni zafamofo ani'na'a trohutere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ana tavi zotama azankuna'aramima, anina'ama, mosare'anema tro'ma hanazana magoke golinutike, arukuta huta trohiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ana 7ni'a azotaramintera lamu tavi tro huta antenkeno, seli nompina avuga remsa hino. ");
INSERT INTO kbq_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Hanki ana lamu tavimofo osama hampage tu'zane osama erinte tafe'enena golinutike tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","E'i ana tavi zotamofoma mika zantamima'ama tro'ma hanaza zana kna'amo'a 34'a kilo hu'nenia golireti tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hanki e'i ana mika'zama tro'ma hanazana, Nagrama ama agonafi kaveri'ma hu'noa kante antenka tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Hagi Seli mono noma kisazana knare huno zmana zmanama hu'nesia hokonke nofiki, fitunke nofiki, koranke nofi avazu huno zagi'nesia osi nofiteti 10ni'a tavrave trohutenke'za, ana zama trohu antahi'zama eri'naza eri'za vahe'mo'za, Serabimi ankeroramimofo zamema'a ana tavraveramintera hati'za tro hanageno, ");
INSERT INTO kbq_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ana maka tavaravea mago avamenteke nevuna, za'za amo'a 12fu'a mita hanigeno, atupa'amo'a tare mita hutere hino. ");
INSERT INTO kbq_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","5fu'a erimagopinteta nehatita ruga'a 5fu'amofona anahutma magopi erintetma rehatiho, ");
INSERT INTO kbq_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ana 5fu'a tavravea erintetma rehatisaza kevumofo atupa'arega, hokonke tavravereti erihagerafi atupa'a tro nehutma, mago kevumofona megi'a atuparera anazanke hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Mago kevu tavravemofo atumparera 50'a eri hagerafi atupa'a tro nehutma, mago kevumofonena anazanke hutma trohinkeke, ana tarega tavravemokizni atumpa'amokea zamavugosa ohumi ahumi hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ana tare kevu tavravema erinteno vazirusi hanigeno erintrako hu'zana, gorileti erikorave huta 50'a rinia eri hagerafi atumparamintera tro hunte'nageno, ana seli mono nomo'a magoke megahie. ");
INSERT INTO kbq_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ana seli mono noma rufite tavravea meme afu'mofo azokateti maka 11ni'a tavrave tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ana maka 11ni'a tavravea mago avamenteke'za trohinkeno, zaza'amo'a 13ni'a mita hina, atupa'amo'a tare mita hutere hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","5fu'a tavravea erinteta rehati rehati hinkeno mago tavrave nesena, 6si'a tavravemofona anazanke hutma rehatinkeno mago erisena, anampinti 6simofona repasi hinkeno ete eme ruhamprino seli nomofo avuga ufre kaziga, ana tavravemo'a taparino meno. ");
INSERT INTO kbq_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Hanki eri mago hutama hatinte'naza tavravemofona eri hagerafi atumpa'a, 50'a tro nehutma, mago'ma hatinte'naza tavravemofonena anazanke hutma tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Anantera tare tavravere'ma 50'a eri hagerafi atupa'ama troma hunte'nafima, erihagerafino eri ruhampri'zana bronsireti erikorave huta 50'a rini kana tro hutenenkeno, ana tare tavravea erirusi hinkeke seli mono nomo'a erimago huno megahie. ");
INSERT INTO kbq_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ana seli mono nomofo agofetu'ma refite'nia tavravemo'ma agatereno vania atupa'a atrenkeno amefiga uramino ruhananeno. ");
INSERT INTO kbq_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ana seli mono nomofoma rufite tavravema tro'ma hanazana, rugaruga asoparega 50'a sentimita atrenkeno vugatereno tare kaziga asopa nomofona rufiteno. ");
INSERT INTO kbq_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Hanki ana nomofoma rufite selima tro'ma hanazana, ve sipisipi afumofo akrute erikoranke huta rufineteta, ana agofetura hagerimpi bulimakaomofo amega akru eritma rufite vagaregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ana seli noma ki zafa akasia zafaraminteti tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ana seli noma eri otino ki'zafaramimofo zaza'amo'a, 4'a mita hina, kuta'amo'a 66'a sentemita hutere hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ana seli mono noma vazisgama hania zafa zazate taga hutma tro hunte'nenkeno tra'afina ome rusi huno meno. Anazanke hutma maka asopa zafa tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","E'i anama hutama tro'ma hanaza zafaramimpintira 20'a zafaretira seli nomofona sauti kaziga retrureho. ");
INSERT INTO kbq_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Hagi ana asopa zafaramimofo agafafima azerikona hina oti fatgo hania zana, mago zafamofo agafafina silvareti tare tra trohutere hinkeno, ana maka tra'mo'a 40'a fore hino. ");
INSERT INTO kbq_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","E'i anahukna huta noti kaziga 20'a zafaretira seli noma azeri oti'zafa retrureho. ");
INSERT INTO kbq_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Hagi ana asopa zafaramimofo agafafima azerikona hina oti fatgo haniazana, mago zafamofo agafafina silvareti tare tra trohutere hinkeno, ana maka tra'mo'a 40'a fore hino. ");
INSERT INTO kbq_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Seli nomofo amefira zage fre kazigama vazisgamahu zafaramina 6'a tro nehutma, ");
INSERT INTO kbq_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","seli nomofo amefi'ma ome renegente eme renagentehu tare atupatrentera retruresaza tare zafa tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Anama renagentete'ma marerisa'a tare zafamokea, magoke trate regriteke anagamu atupa'amokea rinifinka ufre'nakeno znazeri tragotegahie. Mago kaziga renagentetera anazanke hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","E'inama hanageno'a makara 8'a zafa mena, ana zafa azeri oti trara silvareti mago mago zafarera tare agi'a trohutere hinkeno ana makara 16ni'a tra megahie. ");
INSERT INTO kbq_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ana zanke hutma seli mono nomofo asoparegama rugekahu zafa akasia zafareti 5fu'a tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Hagi mago kaziga (saut) asopareganena 5fu'a rugeka zafa tro nehuta, seli mono nomofo atupa kaziga zage fre (west) kaziganema me'nea zafarera anazanke huta 5fu'a rugeka zafa tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Amu'nompi rugeka'ma hanaza zafamo'a mago asopamofo atuparetira vuno, mago atupare uhanitino. ");
INSERT INTO kbq_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ana zafaramimofona goliretike erinona vazinezamanteta, rugekama hanaza zafaramima erirusi hu'zana goliretike erikorave hutma retrure zafarera tro huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Mosesega ama agonafima kaveri'ma huankante amage antenka ana seli mono nona azeri otio. ");
INSERT INTO kbq_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Seli mono nomofo hunaragisaza tavravema tro'ma hnazana knare huno zmana zmanama hu'nesia efeke nofiki hokonke nofiki, fitunke nofiki, koranke nofi avazu huno zagi'nesia osi nofiteti tavravea tro hutenke'za, ana zama trohu antahi'zama eri'naza eri'za vahe'mo'za, Serabimi ankeroramimofo amema'a ana tavraveramintera hati'za tro hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ana tavravema hantisazana, 4'a akasia zafarera golireti eri ano nevazita, ana zafarera golireti eri rusi hu'zana tro nehuta zafama retrure trara silvaleti 4'a tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ana tavravea erirusihu rinire hantinkeno evuno hunaragintena ana tavravemofo amefiga'a, ruotage huno ruotgetfa hu'nefinka huhagerafi huvempa kasege vogisia anampinka antenkeno meno. ");
INSERT INTO kbq_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Anama ruotage huno ruotagetfa hu'nea asama hunaragintepinka kasegema me'ne vogisimofo agofetura asunku tra trohuta rufiteho. ");
INSERT INTO kbq_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Hanki hunaraginte tavaravemofo avuga ruotage'ma hu'nefina, noti kaziga mago Nagri navure'ma antesageno me'nia bretimofo trara nentetma, ana seli mono nomofo sauti kaziga tavi'ma rekaruhunte lambe tavi zota anteho. ");
INSERT INTO kbq_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ana seli nomofo kahama ufrete'ma tafi tavravema tro hanazana, hokonke nofiki, fitunke nofiki, koranke nofiki hutma, kapokureti'ene avazu huta osite nekazareti hanetma tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kafante tavravema hanti'zana 5fu'a retrure zafa akasia zafare golireti ano nevazita, ana zafarera golireti eri rusi hu'zana tro nehuta, zafama retrure trara bronsireti 5fu'a tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Akasia zafareti'ma kresramnavu itama tro'ma hanazana, mareriamo'a 1 mitagi 30'a sentemita hina, zaza'amo'ene kahesa'amo'enena mago avamenteke 2 mitagi 20'a sentemita hino. ");
INSERT INTO kbq_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Hanki 4'ama omerenagente emerenagentema hutera mago pazive tro huntetere hinkeno, ana pazivetamimo'za ana itare rutragote'za erimago zanke nehina, ana ita bronsireti amega'a anovazinteho. ");
INSERT INTO kbq_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ana itare'ma eri'zama eri'zantamina bronsireti'ma tro'ma hanazana, tanefa'ma katetre kavoraminki, osama kate sipetiraminki, ru tritri hu zuomparaminki, revazuhu zotaraminki, tevema tagi osi zuomparaminki hutma tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Bronsireti rama'a karami hagente'za strena tro hutma anaga tevema hugre itamofo antenkeno agu'afi uramino amu'nompi me'nena, anante 4'a bronsire rini tro huta zotama vazinteno erisga hu'zana tro huta 4'a renagentetera rukamregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Anama Bronsireti rama'a karami hagente'za strenama tro huta kresramna vu itamofo amu'nompi fenka kaziga trate rukamrentenkeno meno. ");
INSERT INTO kbq_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ana kresramna vu itama vazino erisagahu azotarerena akasia zafareti tro hutetma amega'a bronsireti anovaziho. ");
INSERT INTO kbq_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ana azotarerena kresramna vu itamofo rugaraga asoparega riniramima tro'ma huntepinka erita vazintenkeno, erisgama huno vu'za meno. ");
INSERT INTO kbq_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ana kresramna vu itarera kuta zafareti tro hinkeno, agu'afina hagro huno mena, ana itama tro'ma hanazana, Mosesega agonafima kaveri'ma hu'noa kante amage anteta tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Seli mono nomofo kuma keginama hanaza tavravea, sauti kaziga zaza'amo'a 44'a mita hina, keginarera osi nofiteti zagi'za hati'nesaza tavaravereti tafinteta eviho. ");
INSERT INTO kbq_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Keginama azeri oti zafaramina 20'a tro nehutma, kegina zafamofo tra'a bronsireti 20'a tro nehutma, tavravema erirusi huno tafinte'zantamine nofi'ma rente'zantamina silvareti ana azeri oti zafamofo avozarera tro hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ana zanke huno noti kaziga keginahu tavravene azeri oti zafaramina 20'a tro nehutma, kegina zafamofo tra'a bronsireti 20'a tro nehutma, tavravema erirusi huno tafinte'zantamine nofi'ma rente'zantamina silvareti ana azeri oti zafamofo avozarera tro hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ana seli mono nomofo keginare tavravea zage ufre kaziga kahesa'amo'a 22'a mita hina, keginama eri oti'zafa 10ni'ane tra zamianena, 10ni'a tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hanki zage hanati kaziga avugosama hunte'nea kumamofo kahesa'amo'a 22'a mita hino. ");
INSERT INTO kbq_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kama ufrete'ma tamaga kaziga hanti tavravea, zaza'amo'a 6 mitagi 60 sentimita hina, kegina retrure zafa 3'a tro nehuta tra'aramina 3'a tro huta anantera ana tavravea tafinteta eviho. ");
INSERT INTO kbq_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hanki kama ufretema hoga kazigama tafi tavravemofona zaza'amo'a 6'a mitagi 60 sentimita hina, 3'a retrure zafagi 3'a tra'aramina tro nehuta anantera ana tavravea tafinteta eviho. ");
INSERT INTO kbq_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hanki ana kumapima ufre kante'ma ruhi'zamahu tavaravema tro'ma hanazana, hokonke'ene, fitunke'ene, koranke nofiteti'ene, ana eri'zama eri antahi'zama eri'nesia vahe'mo osite zagino ana tavravemofona konariri'a hunentena, ana tavravemofona zaza'amo'a 9'a mita hina, 4'a retrure zafane 4'a trazamia tro huta ana tavravea kafantera tafinteho. ");
INSERT INTO kbq_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ana kuma'mofo maka kegina zafaramintera, erirusi hunte zantamine nofi'ma anaki'zana silvaretike tro nehuta, keginama eri oti tratamina bronsireti tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ana kumamofona zaza'amo'a 44'a mita hina, kahesa'amo'a 22'a mita hina, keginare'ma tafinte tavravea, knare huno osite zagi'nesia nofiteti trohinkeno mareri'amo'a 2'a mitagi 20'a sentemita nehina, bronsireti keginama retrure trataminena tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ana maka ruga'azama seli mono nompima eri'zama eri'zantamine, ruzahu ruzahu eri'zama eriterehu zantamine, seli nompi zantamine, megi'a tavravere'ma avazuhumpi huno rente zotane, seli mono nomofo tavravema avazuhumpi huno rente azotaramina, ana maka zantaminena bronsiretike tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Kagra hanavege Israeli nagara huzamantege'za olivima regatati hu'zama eri agruma hu'nesaza masavena lampe tavima tagintena tevava hania zana eri'za eho. ");
INSERT INTO kbq_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ana seli mono nompima, huvempa huno huhagerafi vogisima ante asama hunaraginte tavravemofo avuga, Aroni'ene ne' mofavre naga'amo'za Anumzamofo avurera kinagane nanteranena tavira tagintenkeno tevava nehina, ama'i ana avu'avara Israeli vahe'mota huvava hutma nevinke'za henkama tamagehe'za fore hanamo'za ana zanke hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Hagi Mosesega negafu Aronine ne' mofavre naga'a Nadabuki, Abihuki, Eleazaki, Itamaliki, Israeli vahepintira ke huge'za kagrite e'za Nagri pristi eri'za vahe maniho. ");
INSERT INTO kbq_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Negafu nera Aronina ruotage huno avasese'amo'ma mareri'neni'a kukena tro huntenenkeno, vahe'mo'za kesga hunente'za antahimiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Anahu eri'zama erigahaze hu'nama knare antahi'zama zamuge'za e'neri'za vahera mika ke huge'za, Aroni'ma antani'nenigeno azeri ruotage hanigeno, pristi eri'zani'a erisia kukena'a tro hunteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ana kukenama zagita tro'ma hnazana amanahu kukena tro hugahaze, amimizare'ma 12fu'a havema rekamre'nia tavravegi, amimizare'ma hania kukenagi za'za kukenagi, agu'afi avate kenagi, asenire naki tavravene amu'nofi'ene trohinke'za, negafu ne' Aroni'ene ne' mofavre naga'amo'zanena antanine'za, pristi eri'zani'a erigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ana kukenama tro hanaza nofitamina, hokonke nofiki, golire nofiki, fitunkeki, koranke nofi'ene knare zantfa hu'za zagi'nesa nofiteti'ene tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Amega amimizare'ma hania kukenama tro'ma hanazana, golire nofiki hokonke nofiki, fitunke nofiki, koranke nofi'ene knare zantfa hu'za osite zagi'nesaza nofiteti hinke'za ana zante eri'za vahe'mo'za trora hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Afumpinti'ma krerami'nigeno amefigama anakisnia nofira anaga kaziga tare atumparega tafinteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Amu nofi'ma zagita tro'ma hnazana, golire nofiki, hokonke nofiki, fitunke nofiki, koranke nofi'ene knare zantfa hu'za osite zagi'nesa nofiteti eri so'e hu'za tro hanageno, amimizare'ma hu kukenamo'enena magoke fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Oniksie nehaza have tare eritma 12fu'a Jekopu ne' mofavre'mokizmi zamagi, ana haverarentera taga huta krenteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ese'ma kase zamante'neregati vuno osite'ma vanigeta zamagima krentesazana, 6si'a zamagia mago havere krenteta, mago haverera 6si'a zamagi'a krenteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ana tare haverera, tagama hu'za avame'zama havere'ma tro'ma nehazaza huta, Jekopu ne' mofavre'mokizmi zamagi'a taga huta krenenteta, golireti rinia tro hinkeno ana haverarena znazeri antrako hino. ");
INSERT INTO kbq_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ana havererena ruga raga afunte'ma me' tavravere hagerafintenkeno antahizami avame zankna huno me'ne'nigeno, Aroni'a Jekopu ne' mofavre naga'mokizmima Ra Anumzamo antahizaminogu maka zupa Anumzamofo avurera vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ana havererema znazeri antrakohu rinia golireti tro nehutma, ");
INSERT INTO kbq_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","seni nofikna hutma golireti hanetma eri hagerafi hagerafi hutma tare nofitre, tro hutma ana rinirarentera renteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Amimizare'ma hania kukenama tro'ma hanazankna hutma, asunte'ma hu'neno Anumzamofo avesi'zama kefore'ma hu'zana, ana zama trohu knare antahi'zama eri'naza vahe ke hinke'za, hokonke nofiki, fitunke nofiki, koranke tavravereti'ene knare hu'za zagi'nesaza osi nofiteti tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ana tavravemofo zaza'amo'a 44'a sentimita hina, atupa kaziga'amo'a 22'a sentimita hinketma erinteta repasi hinkeno, ana maka asopamo'a mago avamenteke vino. ");
INSERT INTO kbq_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Miza zama'amo'ma mareri'nesia have raminteti ana tavraverera 4'a isa'are rekamarenteta evugahaze. Hanki kotama evania isarera rubi havegi, topasi havegi, berilie nehaza have evina, ");
INSERT INTO kbq_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","anante'ma evania isa'arera terkoise nehaza havegi, safaire nehaza havegi, emererie nehaza zafasi'nage havemo evina, ");
INSERT INTO kbq_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","anante nampa 3 isare'ma evaniana, jasintie nehaza havegi, agatie nehaza havegi, ametistie nehaza have evina, ");
INSERT INTO kbq_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","anante nampa 4 isa'ama evanirera, krisolaetie nehaza havegi, oniksie nehaza havegi, jaspe nehaza havemo ene evino. Ana maka haveramima regrinte anoma'aramina Goliletike tro huntenkeno azeri antrako hino. ");
INSERT INTO kbq_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ana maka 12fu'a haverera Israelina (Jekopu) 12f'u'a ne' mofavre'mokizmire huhamprino magoke magoke have'a me'nena, ana havere mago magomokizmi zamagi'a anante taga hu'za krentegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Amimizare'ma 12fu'a havema ante'ne tavravema rentesaza seni nofira goliretike haneho. ");
INSERT INTO kbq_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Hanki goliretike tare nofi'ma rente rinia ana tavravemofona anagamu atumpamofo ruga raga kaziga ometre emetrema hutega renteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Anama anakintesaza rinirarentera golire tare seni nofi'ma tro'ma hanaza nofinu anante hagerafinteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Hanki ana seni nofitremofo atupa'arera erita rugaraga azonare'ma ante havema eri anovazi'nea golire renteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Hanki mago ene tare golire rini tro hutma amimizare'ma 12fu'a havema ante'ne tavravemofo henkamu kaziga omete emete hutega, agu'afi amimizare'ma hu kukenamofo tvaonte tafinteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hanki mago'ene golireti tare rinia tro hutma azonareti'ma kreramino amimizare tavravema hagerafi'nere ruga raga avasase'ane nofi'numa avamare'nere renteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Hanki hokonke nofi'nu amimizare'ma 12f'u'a havema me' tavravemofo fenkamu kaziga rugaraga atumparega me'nea rinirarente anakintenkeno, amimizare hu kukenare rukamreno meno. ");
INSERT INTO kbq_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aroni'ma Ruotage'ma hu'nefinkama ufresuno'a Israeli ne' mofavre naga'mokizmi zamagia tumo'amofo agofetu amimizare'ma hu'neno ufresige'na, Ra Anumzamo'na nagerakni ozamante'noe hu avame'za meno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ana zanke hunka amimizare'ma 12fu'a havema me' tavravemofo kasagu'afinka, tare havemofo zanagi'a urimie nehaza havene, tamimie nehaza haverare eririgeno Aronina tumo'amofo agofetu amimizare hanti'neno, Ra Anumzamo'na navure'ma vaniana, e'i ana haveraremoke Nagri navesira eri ama' hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Agu'afi antani'neno agofetu'ma amimizare kukena hania za'za kukena, hokonke tavraveretike'za tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Hanki ana za'za kukenamofo ananke kana amu'nompi hagenentetma, ana kamofoma hatigagisazana tavravea ante taparita zagita hatinkeno tagatora osino. ");
INSERT INTO kbq_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Hanki ana za'za kukenamofo agiaregama rugagi atumparega, pomigreneti zafa rgagna huta hokonke nofiki, fitunke nofiki koranke nofi'nuti tro hutetma ana za'za kukenarera rentekagiteta, ana zantamimofo amu'no zmifina golireti belotami tro huta renterente hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hanki ana zantamima rente kagisazana, golireti'ma tro'ma hu'naza belora renenteta, pomigreneti zafa rgama tro'ma hu'nazana rente rente hutere hutma, ana kenamofona kagiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Seli mono nompima hunaragintegeno ruotage'ma hu'nefinkama Aroni'ma, Ra Anumzamo'na navure'ma ruotagema hu'nefinka eri'za eri'naku ana kukena hu'neno ufreno atiramino'ma nehanige'za, Ra Anumzamo'ma ahe ofri'nenigura ana arente'naza belotamimofo agerura antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Hanki goliretike mago kuta preti tro huteta anantera Ra Anumzamofontega ruotage hu'ne hutma taga huta krenteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Anantera hokonke nofi'nu ana nanekema krente'naza gorile pretia asenire'ma anaki tavravemofo agofetu anakinteho. ");
INSERT INTO kbq_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aroni'ma ana tavravema asenire maka zupa anaki'nena, Israeli vahe'mo'zama ruotage hu'nea musezama eri'zama eme namisafima hantagama hanazana, Nagra Ra Anumzamo'na ana pretima nege'na hazenkezmia atre zmantegahue. ");
INSERT INTO kbq_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Hanki agu'ama antani kukena knare tavravenuti zagita tro nehuta, anunte'ma anaki tavravenena ana zantetike tro hiho. Azonaregati'ma rugreramino asoparegama evu nofira konaririane nofi tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Hanki zamazeri ruzahu'ma hu'nesige'za vahe'mo'za antahizami'za husga huzmantesaza kukena zamu'nofi ki tavrave nofiki, kankriki megi'ama antani kukena (tunik) Aroni ne' mofavre zagamo'za hanaza kukena tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Mosesega ana kukenaramima negafu Aronine ne' mofavre naga'anema eri huzamantetenka, anantera zmanumpina masave taginka fre zmentetenka, huhamprizmantenka zamazeri ruotage nehunka, pristi vahe zamazeri otige'za Nagri eri'zana eriho. ");
INSERT INTO kbq_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Hanki efeke tavravereti zamagaze zmavufga eri frakisia atupa kena, zmaratimpareti urami fenkamuteno zamotega ome atre kena tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Hanki Aroni'ene ne' mofavre naga'anema seli mono nompima ruotage'ma hu'nefinkama ufre'za Kresramanavu itare'ma eri'zama erinaku'ma vanu'za, zamagaze eri'za frizankura ama ana atupa kena antanine'za ufregahaze. Ama'i ana kasegemo'a mevava huno Aroninteti agafa huno zmagehe'inte meno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Mosesega amanahu hunka Anumzamo'na Nagri pristi eri'zama erisagura Aronine ne' mofavre'aramima'a zamazeri ruotage hananke'za pristi eriza erisazana mago a' anenta ve agaho bulimakaogi, tare afuhe afahe osu ve sipisipi afu anentatrenki, ");
INSERT INTO kbq_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","knare'ma hu'nesia witi flauateti zo-ore bretia tro nehunka, zisti onte flauateti keikia, masavene eri havia hunka tro nehunka, olivi masavenu eri havia hunka zisti onte flauateti haganentake bisketiramina tro huo. ");
INSERT INTO kbq_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Anante mago ekaeka kupi ana zisti onte flauate'ma troma hu'nana zantamina eriritenka, ana eka eka kuki ve bulimakaonki, tare ve sipisipirerene erita Nagrira eme namiho. ");
INSERT INTO kbq_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ana hutenka Aronine ne' mofavre naga'anena zamavarenka, seli mono nomofo kahante tina frezamantetenka, ");
INSERT INTO kbq_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","anantera kukena ramima zaginka tro'ma hunte'nampinti amega kukena'a Aronina eri huntetenka anante zaza kena'a huntetenka ana agofetura amimizare kukena huntetenka, ana agofetura 12fu'a havema me'nea tavrave antanitentenka hentofazama huno tavraveretima tro'ma hu'nea amu'nofiteti erinka anakinto. ");
INSERT INTO kbq_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Aronima asenire anakinte tavravema tro'ma hunte'nazana erintani nentetma, ana tavraverera ruotage'ma hu'nea golire pretia rukamrenteho. ");
INSERT INTO kbq_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Anumpima taginte masave erinka Aronina asenire taginka huhamprintegahane. ");
INSERT INTO kbq_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Aroni ne' mofavre nagara hinke'za esagenka amega efeke kukena erintani nezamantenka, ");
INSERT INTO kbq_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","zamasenirera tavravereti anaki nezmantenka, Aronine ne' mofavre nagara zamu'nofira anaki zmantenke'za, Nagri pristi eri'za vahe zamagra manivava hugahaze. Ana hukna kante Aronine, ne' mofavre'anena huhampri zmantegahane. ");
INSERT INTO kbq_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ve agaho bulimakao avrenka seli mono nomofo avuga ege'za, Aroni'ene ne' mofavre naga'amo'za asenire zamazana anteho. ");
INSERT INTO kbq_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ana hutesagenka seli mono nomofo kahama ufrete, Ra Anumzamofo avure ana bulimakaoa aho. ");
INSERT INTO kbq_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ana ve bulimakamofo korama'a kazankoreti erinka kresramna vu itamofo pazivetamima tro'ma huntetera nefrenka, mago'a korama mesiama'a erinka kresramna vu itamofo agafi tagi netrenka, ");
INSERT INTO kbq_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","agu'afinti maka afova'ane asumanane tare kresoane anoma vazintenea afovanena erinka kresramna vu itarera kregeno teveguna mrerino. ");
INSERT INTO kbq_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Hianagi kumi'mofo ofama hnanana bulimakaomofo ame'agi, amega ukri'agi rimpa'a erinka kumamofo megi'a ome krerasago. ");
INSERT INTO kbq_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Mosesega tare ve sipisipifintira mago azerisanke'za Aroni ene ne' mofavre naga'amo'za asenirera zamazana antetesagenka, ");
INSERT INTO kbq_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ahenka korama'a taginka kresramna vu itamofona maka sopa'arega rutri tri hunto. ");
INSERT INTO kbq_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ana sipisipia tagarago hunka, rimpa'ane agiazama'anena sese hunka aseni'ane ruga'a avufganena magopi erinto. ");
INSERT INTO kbq_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ana hutenka ana maka zama'a kresramna vu itare krerasago. E'ina ofa tevereti'ma Ra Anumzamo'nare'ma kre mana vanageno Nagri navure'ma knare mnama vania ofe. ");
INSERT INTO kbq_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Mago sipisipi anenta'ma atre'nana su'ana Mosesega kagra azeri nesanke'za Aroni ene ne' mofavre naga'amo'za asenire zamazana antesnagenka, ");
INSERT INTO kbq_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ana sipisipia ahenka mago'a korama'a taginka Aronine ne' mofavre naga'amokizmia tamaga kaziga zamagesamofo atumparega frenezmantenka, tamaga kaziga zamazamofo zmazafa zamazankore fre frenezmantenka, tamaga kaziga zamagamofo zamagafa zamagigore frenezmantenka, mago'a korana taginka kresramna vu itamofo maka asoparega ru tri tri nehunka, ");
INSERT INTO kbq_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","kresramna vu itareti mago'a korana e'nerinka, zamanunte'ma tagi masavenena erinka Aronine mofavre naga'a kukena zamirera, korane masavenena rutri tri hinkeno, ana kukenane zamagranena Nagri su'za meno. ");
INSERT INTO kbq_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ana ve sipisipi anentamofo afova'ane, risonafi agusane agu'afinti afovama, azamopama eri anoma vazi'nea afovane, tare kreso'are'ma anoma vazi zanante'nea afova'ane, tamaga kaziga amumazina'ane erinka pristi vahe'ma Nagrite huhampri zamanteno zamazeri routage hu ofa eme huo. ");
INSERT INTO kbq_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ra Anumzamo'na navure'ma zisti onte bretima eka ekapi kupima ante'nafintira mago ko'na e'nerinka, masavereti'ma kre'naza keikine, magora hagege bisketine erinka, ");
INSERT INTO kbq_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ana maka'zana bretine ame'anena Aronine ne' mofavre naga'amokizmi zamazampi antenke'za erisga hu'ne'za Ra Anumzamo'na navurera erivereve hu ofa hiho. ");
INSERT INTO kbq_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Anama hutesagenka, Mosesega zamazampintira bretine ame'a erinka Ra Anumzamofonte'ma kre fananene hu ofa kresramna vu itare kregeno knare mana Nagri navurera vino. ");
INSERT INTO kbq_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ve sipisipi ahenka Aronima azeri ruotage'ma hu'naza sipisipimofo ahihiza'a erinka, Ra Anumzamo'na navurera erisga hunka eri veravehu ofa hutenka, ana ahihiza'a Mosesega nesana su'ane. ");
INSERT INTO kbq_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ana ve sipisipimofo amumazina'ane ahihiza'anema huhampri zmanteku'ma erisga hunkama eri verave hankeno'ma ruotage'ma hu'neana e'i, Aronine, mofavre naga'amo'zama nesaza su'ane. ");
INSERT INTO kbq_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Israeli vahe'mo'za Nagri'ma arimpa fru ofama, amumazina'ane ahihiza'anena namisaza su'ana, Aronine mofavre naga'amokizmi suzanki, maka zupa zamitere hiho. ");
INSERT INTO kbq_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aronina ruotge hu'nea pristi kukena'a ante'nenkeno, agri naga nofipima agri noma erisimofona erita ana kukena antaninteta asomu huta, azeri ruotage hiho. ");
INSERT INTO kbq_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mago mofavre'amo'ma agri noma erino seli mono nompima ruotage'ma hu'nefinkama pristi eri'zama erisimo'a, ana kukena hu'neno 7ni'a zage knafina eri'zana erigahie. ");
INSERT INTO kbq_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Aronine ne' mofavre naga'anema huhamprinka zamazeri ruotage hu ofama hanana sipisipifintira, ame'a erinka seli mono nomofo atruhu kumapi kavofi kregahane. ");
INSERT INTO kbq_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Seli mono nomofo kafantera Aroni'ene ne' mofavre naga'amo'za sipisipi afu'mofo ame'ane eka eka kupima bretima me'neanena eri'za negahaze. ");
INSERT INTO kbq_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ana ne'zana pristi vahe manihogu'ma huhampri zamante'naza zupama zamagri'a kumiku'ma hu'naza ofagi'za zamagra'ake nesage'za, ru vahe'mo'za oneho. Na'ankure e'i ruotagetfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Anama huhamprino zamazeri ruotage hu ofama hu'nea ve sipisipi afu ame'afi, bretio me'nesigeno'ma nanterasenigeta, onetma tevefi kre fanane hiho. Na'ankure e'i ana ne'zamo'a ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Seveni'a zagegnafi Aronine ne' mofavre naga'arema huzmantoma hu'nama hugante'noa zantamina maka huzmante vagaro. ");
INSERT INTO kbq_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mago mago zagegnarera bulimakao ahenka kumi'ma atre ofa hutere hutenka, Kresramana vu itama azeri agruma hu ofa nehunka, masevena frentenka eri ruotage hugahane. ");
INSERT INTO kbq_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ama ana itarera 7ni'a zage knafi itama azeri agruma hu ofa nehugeno, ana itamo'a me ruotagetfa huno me'nena, na'zamo'o ana itama avako'ma hania zamo'enena ruotage hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Mika zupama mago mago zage knare'ma ana itare'ma ofama hanunka, amanahu hunka ofa huo, tare sipisipirare mago zagegafu hu'nesa'a zanazerinka, ");
INSERT INTO kbq_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","mago'mofona nantera ofa nehunka, hanki mago'mofona zagema ufrenaku'ma nehanigenka kinaga ofa huo. ");
INSERT INTO kbq_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kota sipisipine ofama hananana, witi flauapintira mago kilo erinka, olivi masavea mago litafi eri hava hunka, ana sipisipinena ofa huo, ana nehunka mago lita wainia ofagna hunka tagi tro. ");
INSERT INTO kbq_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Hagi witigi, masavenki, waini tinema nanterama ofama hu'nanaza hunka, mago sipisipinena zagema ufrenaku'ma hanigenka Kresramana vuo. E'i ofa tevereti'ma kre fananehu ofa hunantage'na Ra Anumzamo'nama manama nentahi'na musema nehua ofae. ");
INSERT INTO kbq_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Menine henkama fore'ma hanaza naga'mo'za, maka zupa tevereti'ma kre fananehu ofa seli mono nomofo ufre kahantera Ra Anumzamo'na navurera kresramna vuvava nehanage'na, anante kegaga eme tamasamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","E'inama hanage'na anante Israeli naga'enena emanisugeno Ra Anumzamo'na hankave masa'nimo anankumara azeri ruotage hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ana hinke'na Ra Anumzamo'na nagra seli mono none, Kresramana vu itanena azeri ruotage nehu'na, Aronine mofavre naga'anena anahukna hu'na zamazeri ruotage ha'nena, nagri pristi eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ana nehu'na Nagra Israeli vahe'mokizmi amu'nompi mani'ne'na, zamagri Anumza manisuge'za, ");
INSERT INTO kbq_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","zamagra ke'za antahi'zama hanazana, nagrikura Ra Anumzanti mani'neno Isipitira tavareno e'neane hu'za nehanage'na, nagranena zamagri amu'nompi nemani'na nagrake'za zamagri Ra Anumzana manigahue. ");
INSERT INTO kbq_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Mnama vu zantamima kre mnama vania ita, akasia zafareti tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ana itamofo za'za'amo'a 45'a sentimita hina, kahesa'amo'a 45'a sentimita huno, mika asopa'amo'a mago avamenteke mena, atrure'amo'a 90'a sentimita marerinkeno, ana itamofona 4'ama renagentetera ana itama tro'ma hanana zafaretike pazivera tro huntetere huo. ");
INSERT INTO kbq_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ana itamofona agofetu'agi, maka asopa'agi pazivetaminena goliretike anovazi nezmanteta, ana itamofo agema'aramintera goliretike avaretma avasasea hu kaginteho. ");
INSERT INTO kbq_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Golireti'ma avasasema hunte'namofo henka kaziga, golireti tare rinia vimago azotama vazino eri sgama hu'zana ruga ruga asoparega tro huo. ");
INSERT INTO kbq_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ana itama eri sgama huno vu vimago azota akasia zafareti tro hutenka golireti erinovazinto. ");
INSERT INTO kbq_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ana itama antesazana seli mono nompima kasege ante vogisimofo agofetu asunku tra'ma refko'ma hige'na, Nagra'ma e'na nanekema eme hanua tra'ma refko hu'nea tavravemofo avuga anteho. ");
INSERT INTO kbq_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aroni'ma maka nanterama lamu tavi'ma erinte fatgo hunaku'ma esuno'a, ana itarera mnanentake zantamina kresnigeno knare mana vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kinaga zagema ufre'za nehanigeno Aroni'ma ete tavi'ma eme eri fatgo hunaku'ma esuno'a, ana itarera mnanentake zantamina eme kreno. Ana mnanentake zana menine henkama mani'zama vanaza vahe'mo'za kre'za nevinkeno, Ra Anumzamo'na navurera ana mnamo'a mevava huno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Anama mnanentake zama kre mnama vu itarera, hu izo osu'nesua mana zano, kre fanana hu ofafi, witifi waini ti ofa ana itarera osiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mago kafufina magoke zupa Aroni'a ama ana kre mnavu itarera mago kafufima hu'naza kumizmi atre'zmante ofama hanaza sipisipi afu'mofo koranteti ana itamofo 4'a pazivetera frentena Ra Anumzamo'na navurera ana itamo'a ruotage huno meno. Ama ana avu'avazamo'a menine henkama fore'ma hanaza vahepina mevava huno vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hagi anante Ra Anumzamo'a Mosesenku amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Kagra Israeli naga'ma hamprinkama zamagima erisana zupa mago mago'mo'za knare'ma hu'za manisagura, Ra Anumzamo'narera mago'a zagoa miza hiho. Anama osnageno'a, anama hamprisaza knazupa zamazeri haviza hu'zamo'a zamagritera egahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ko'ma ana maka vene'nema zamagima ante'nesamo'za, silvamofo kna'amo'a 6'a gremi hu'nesia silvareti Ra Anumzamo'na ofa eri atru hu'za eme namiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kafu zamimo'ma 20reti mreri anagamate'nesia vene'nema zamagi erisnamo'za ana ofa zagoa zamigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Zmasimu'ma mizama hanazana, feno vahe'mo'za rugatere'za otrenkeno, zamunte omane vahe'mo'za erami'za osi'a otreho. Hagi mago'zahu avamente 6'a gremi hu'nesia silva eme atreho. ");
INSERT INTO kbq_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Israeli vaheteti'ma kumi'zamima apaseno mizase zagoma erisana zagoretira, seli mono nomofo erizante atresageno, e'i ana zamo'a Israeli vahe'mokizmi kumi atre'zmantena mizama sezmante'noa avame'za Ra Anumzamo'na navurera me'nena antahi zamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Anantera Ra Anumzamo'a Mosesena amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Kagra zamasamige'za bronsireti ra zuompa zamagia zamazama sese hu'zana tro nehu'za, ana zuompamofo aga'ama tro'ma hanazana bronsireti tro hu'za, seli mono nomofone kresramna vu itamofo amu'no zanifi nente'za, anampina tina afinteho. ");
INSERT INTO kbq_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E'i ana zuompafina Aroni'ene ne' mofavre naga'amo'zanena zamagia zamazana sese hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Aroni'ene ne' mofavre naga'mozanema Seri mono nompima ufrekupi, Kresramana vunaku'ma vanu'za, ana zuompafina zamagia zamazana sese hugahaze. Ana osanu'za frigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Zamagra zamagane zamazanema sese hanu'za ofrigahaze. Ama'i ana kasegemo'a Aroninteti agafa huno ne' mofavre naga'are vanigeno, henkama zamagripinti'ma fore'ma hnamozanena ama ana kasegea amege ante vava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Anantera Ra Anumzamo'a amanage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Kasamisua kante antenka mnanentake zantamina, kna'amo'a 6si'a kilo hu'ne'nia mananentake meregi, 3'a kilo hu'nesia sinamoni pauragi, mana nentake kurumpa karamusie nehaza kurumpa e'nerinka, ");
INSERT INTO kbq_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kna'amo'a 6'a kilo hu'nesia kasia traza rafunareti trohu pauragi, ana maka'zana seli mono nompima erigahane hu'nama kasami'noa avamenteke'za erinka, olivi masavena 4'a lita taginto. ");
INSERT INTO kbq_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Anazama eri haviama huno'ma vahe'ma frezmanteno zamazeri ruotage'ma hu masavema tro'ma hu' antahi'zama eri'nea vahe ke hugeno, ana maka zana erihavia hinkeno mnanentake hute'na, ana masavemo'a me ruotage huno Nagri eri'za erisu'a meno. ");
INSERT INTO kbq_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Hagi ana masaventetira taginka seli mono nonki, kasegema ante vogisirera frenentenka, ");
INSERT INTO kbq_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","itane ana itare'ma eri'zama eri zantaminki, tavi'ma rekru hunte zotane ana tavi zotare'ma eri'zama erizantaminki, mananentake zantamima kre mana vu itagi, ");
INSERT INTO kbq_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","tevefima kre fanane hu ofama hu itane, ana itare'ma e'rizama eri zantamine, zamagia zamaza sesehu zuompane agianena, ");
INSERT INTO kbq_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","masave fre zamantenka eri ruotage huzamantegeno, me ruotage huno me'nena mago zamo'ma ana zantaminte'ma avako'ma hania zamo'enena ruotageke'za hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Aronine ne' mofavre naga'anena masave taginka fre zamantenka zamazeri ruotage huge'za Nagri pristi eri'za vahe maniho. ");
INSERT INTO kbq_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israeli nagara amanage hunka zamasamio, ama'i masavema frentesigeno Nagrite'ma zamazeri ruotage hu maseve menina me'neno, henkama fore'ma hanaza nagatera mevava hugahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Amne vahe'mofo avufgarera freontege, Nagrama tamasamugeta tro'ma hazankna hutma tamagra'a masavena trora osiho, agra ruotage hu'negu ruotage hu'ne hutma antahiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nagrama kasamua kante anteno iza'o mnanentake masavema tro huge, tagino amne vahe'ma frentege hanimo'a, Israeli vahepintira maniganegahie. ");
INSERT INTO kbq_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Huteno Ra Anumzamo Mosesena amanage huno asami'ne, Mnanentake paurama tro'ma hu zantamima erisnanana, stetikie nehaza mnazanki, onikae nehaza mana zanki, galbanamue nehaza mana zane frenkinsesie nehaza mnazantamina mago avamenteke'za erio. ");
INSERT INTO kbq_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Anazama tro hu antahi'zama eri'nesia eri'za vahe huntegeno, hagene ana paura ramina mago'za evu ofre zamagri'age eri hava huno kre mana vu paura tro hina mane ruotage huno meno. ");
INSERT INTO kbq_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ana mana zantamimpintira mago'a erinka kanegeno paura forehina seli mono nompima, kasege ante vogisimofo avuga, nagrama kagranema keagama hanure anto. E'i ana pauramo'a ruotage hu'ne huta tamagra antahiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ama'ima tamasamua kante anteta tamagra'a amanahukna mana vu paurana trora osutma, Ra Anumzamo'na navurera ruotage hu'ne hutma hiho. ");
INSERT INTO kbq_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nagrama kasamua kante anteno iza'o mnanentake masavema tro huge, tagino agra'a frege'ma hanimo'a Israeli vahepintira maniganegahie. ");
INSERT INTO kbq_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Hagi Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ko, Bezalelina, Uri nemofo Hurina negeho mofavre Juda nagapinti, Nagra agiahe'na huhamprinte'na, ");
INSERT INTO kbq_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nagra'a Avamuteti antevi antentenogeno mika'zama tro'ma hu antahi'zana erineno, tro hugara hu'neno, knare antahi'zanena eri'neankino, ");
INSERT INTO kbq_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","goliretiki, silvaretiki bronsireti'enema eri avugosa huno avasesezama tro hu'zama, ");
INSERT INTO kbq_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","havema taga hu eri'zane, regari tra'ma tro hu eri'zane, zafareti'ma eri eri'zama, ruzahu ruzahu zama azanuti'ma trohu antahintahia agu'afi ante avitente'noe. ");
INSERT INTO kbq_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Hanki Dani nagapinti Ahisameki ne'mofavre Oholiapuna, Bezalelima azama hanigura Ra Anumzamo'na huhamprinte'noe. Anahukna hu'na Nagra mika zama zmazanuti'ma tro'ma hu vahetamina, antahintahia nezami'na huhampri zmante'noankiza tro huo hu'nama hugante'noazana mika tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Seli mono none, ruotage kasegema ante vogisine, asunku trarema nehaza avaza'ane seli nompi zantamine, ");
INSERT INTO kbq_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","itane ana itare'ma eri'zama eri zantamine, goliretike trohu tavi azotane, ana azotare'ma eri'zama eri zantamine, mnanentake zama kre mnavu itane, ");
INSERT INTO kbq_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kre fanane hu ofama hu' itane, ana itare'ma mika eri'zama eri zantamine, agazama sesehu zuompane ana zuompamofo aga'ane, ");
INSERT INTO kbq_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","zagi'zama tro'ma hu'naza kukenaramine, pristi ne' Aroni'ma antanisia ruotage za'za kukenane, ne' mofavre'amozama antanine'za pristi eri'zama eri'za vnaza kukenaramine, ");
INSERT INTO kbq_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","huhamprinteno frenentea masavene, ruotage hu'nefinka ante mnavu zane, Nagrama tro hiho hu'na huramantoa kante anteta tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Anante Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Israeli vahera zamasmige'za mani fruhu knani'a (Sabat) kegava hiho. Na'ankure amu'nontinfina avame'za me'nena Ra Anumzamo tazeri ruotage hu'ne hutma nentahisageno, henkama fore'ma hu'za esaza vahe'mo'za ana zanke hu'za antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Hagi tamagra Sabatia ruotage hu'negu kegava hiho. Iza'o Sabatima kegavama osanimofona ahenefrita, mani fru knani'ama Sabati knare'ma eri'zama erisimofona naga'afintira ahenantitreho. ");
INSERT INTO kbq_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Eri'zama eri'sazana 6si'a zage knafi erigahazanagi 7ni kna zupa mani fru hugahaze. Ra Anumzamofontera ruotage hu'nea knagino, iza'o ana mani fruhu kna (Sabat) zupama mago eri'zama erisimofona ahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israeli vahe'mo'za mani fruhu kna (Sabat) kegava nehanageno, henkama mani'zama esaza zamagehe'mo'za muse nehu'za ana mani fruhu huvempa knamofona kegava huvava hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ana Sabati knamo'a Nagri'ene Israeli vahe amu'nompine mevava avame'za megahie. Na'ankure 6si'a zagegnafi Ra Anumzamo'a monane mopanena tro huteno, 7ni kna zupa eri'zana atreno mani fru hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ra Anumzamo'ma nanekema Mosesema Sainai agonafina asami vagareteno'a, tare haverarente Anumzamo'ma azankonu erivakakino kre'nea kasege tafetrena Mosesena ami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Israeli vahe'mo'zama kazama Sainai agonaregati'ma koma Mosese'ma omeno za'za knama umanige'za, Aroninte emeri atru hu'za amanage hu'naze, ugota huno tavreno'ma vania anumzantia tro huranto. Na'ankure Isipiti'ma tavreno'ma atirami'nea nera Mosesena naza fore huntefi ontahune. ");
INSERT INTO kbq_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aroni'a kenona huzmanteno, a'ne nagatamimo'zane ne' mofavretamimo'zane mofa'netamimo'za zamagesafima antani'nesaza golire rinia zafita nagrite erita eho. ");
INSERT INTO kbq_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Anagema hige'za mika vahe'mo'za zamagesare antani'naza golire rinia zafi'za Aroninte eri'za azageno, ");
INSERT INTO kbq_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ana golire riniramina zamazampinti erino kre ze'ze huno kaza osu havi anumza bulimakao afu tro hutege'za, anage hu'naze, Israeli vahe'mota Isipiti'ma tavre fegiteno e'nea anumzantie hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aroni'ma anazama keteno'a, Kresramana vu itare ana golire tro hu'naza bulimakao avuga tro hunteteno amanage hu'ne, okina Ra Anumzamofontega muse hunenteta ne'za negahune. ");
INSERT INTO kbq_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mase'za nanterampina Israeli vahe'mo'za oti'za kre fanane hu ofa nehu'za, zamarimpa fru ofa hute'za, mani'za ne'zane tine nene'za tusia muse nehu'za, monko zamavu'zmava hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Anante Ra Anumzamo'a Mosesena asamino, Ame hunka uramio, na'ankure Isipiti'ma zamavare atirami'nana vaheka'amo'za havi avu'ava haze. ");
INSERT INTO kbq_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nagrama zamasami'noa kasegea ame hu'za zamefi hunemi'za, kaza osu anumzana golire kre ze'ze hute'za bulimakao afu'mofo amema'a tro huntene'za, ana zante zamarena re'za mono hunente'za Kresramana vunente'za amanage hu'naze, Israeli vahe'mota ama anumzantimo Isipitira tamavre fegiteno e'ne hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ra Anumzamo'a Mosesena asamino, Israeli vahe'ma Nagrama zamagoana ke'ontahi vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Menina tusi narimpa aheanki'na natrege'na zamahe fanene hute'na, kagripinti rankuma vahera azeri fore ha'neno. ");
INSERT INTO kbq_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Hianagi Ra Anumzama'amo asunku'ma hanigu Mosese'a hanavetino antahigeno anage hu'ne, Ra Anumzamoka na'ante tusi'a hanaveka'areti ene kaguvazanteti Isipiti zamavare fegi atre'nana vaheka'a krimpa hezamantegahane? ");
INSERT INTO kbq_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Na'a hanige'za Isipi vahe'mo'za Ra Anumzamo'a havi agu'agesaregati ama mopafintira zamahe fanene hu'naku agonarega zamavare fegi atreno vu'ne hugahaze? Nagaka'a krimpa heozmantenka, krimpa fru hunezmantenka vaheka'a zamahe ofrio. ");
INSERT INTO kbq_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Eri'za vaheka'aramima Abrahamuma, Aisakine, Israelima (Jekopu) Kagraka'are'ma huvempa huzmantenka, tamagehe'mo'za rupazi hu'za monare me'nea hanafitaminkna nehanage'na, ama mopa huvempa hu'na zamisuge'za tamagehe'mo'za erisanti hare'za manivava hugahaze hu'nana kegu kagesa antahio. ");
INSERT INTO kbq_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Higeno Ra Anumzamo'a rimpa ahezmanteno zamahe fanane hugahue hu'nea knazampintira antahintahi'a rukrahe huno vahe'a zamahe fanane osu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ana agonareti Mosese'a tare haverarente tarega kaziga Ra Anumzamo avoma krente'nea kasege e'nerino ete urami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ana have tafetrena Anumzamo Agra'a trohu'ne. Avoma kre'nea avona Anumzamo tagahuno ana have tafetrentera krente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Israeli vahe'mo'zama rankegema haza zamagasasa kema Joshua'ma nentahino'a, kumapina ha' nehugahaze huno Mosesena asami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mosese'a ke nona huno, Ha' vahe'mokizmi ha'ma huzmante'za zamazeri zmagatere'naza zmagasasa omane'ge no, ha' vahezmi'mo'za ha' huzmante'za zamazeri zmagatere'naza zamagasasa omane'neanki zagame nehaza zamagasasa nentahue. ");
INSERT INTO kbq_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mosese'ma ana kumate uravao nehuno, ana golire bulimakaonte'ma vea'mozama avoma nehagazama'a ome negegeno, tusi rimpa hegeno ana kasegema me'nea have tafetrena mate'vuno atregeno ana agonamofo agafi ru frege'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Anama tro'ma hu'naza golire bulimakaona Mosese'a erino tevefi kreteno ana goli'a ru fuzafupegeno tanefa setegeno, erino timpi rupopo hutreteno, Israeli vaheku neho hige'za, ana tina ne'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Anama huteno Mosese'a Aronina antahigeno, Ama vahe'mo'za na'a hugantazagenka tusi'a kumipina zamavarenka ufrane? ");
INSERT INTO kbq_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroni'a kenona Mosesena hunteno, ranimoka krimpa heonanto, kefo avu'avazanke hu vahe mani'nazagenka kagra antahi'nane. ");
INSERT INTO kbq_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Na'ankure zamagra amanage hu'za nasami'naze, vugotama huranteno vania anumzantamina tro huranto, Isipiti'ma tavre fegi'a atreno e'nea nera Mosesena na'a fore hifi ontahi'none. ");
INSERT INTO kbq_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nagra zamasami'na golire riniramima hu'nesamota zafinamiho huge'za zafinamizage'na tevefi krogeno, ana golire bulimakao efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosese'a keama ana Israeli vahe'ma Aroni'ma kegava huso'e huozmanteno, zamatrege'za tusiza hu'za avoma nere'za kefo zamavu'zmavazama nehazageno, ana zamavu'zmavama hazazamo'a ha' vahe'mokizmi zmavurera kiza zokago hu'za neginagi vahekna hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mosese'a ana kumamofo efre kafante otino amanage hu'ne, Ra Anumzamofo kazigama mani'nesamoka nagrite eno, higeno mika Livae naga'mo'za Mosesente e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Anante Mosese'a Livae nagara zamasamino, Israeli vahe'mokizmi Ra Anumzamo'a amanage huno nehie, magoke magoke vahe'mota bainati kazinknona anoma'afi vazinteta zmasoparega anakintenkeno me'nena kumamofo atumparega vuta eta nehuta, magoke magoke'mota neramafune knampatamine, tava'ontamire'ma maninazamokizmia zamahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mosese'ma huzmanteaza hu'za Livae naga'mo'za, ana zupa 3 tauseni'a Israeli vahe zamahe fri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Anama hutageno Mosese'a anage huno zmasamine, menina Ra Anumzamo'a tamagrira tamazeri ruotage hie. Na'ankure tamagra'a ne' mofavretamine nermafugazmine zamahe fri'nazagu Ra Anumzamo'a menina asomu huramante. ");
INSERT INTO kbq_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Anante knazupa Mosese'a Israeli vahera zamasmino, Tusi'a kumi hazanagi menina Ra Anumzamofonte vu'na kumitamima atrermantesia zankura keaga ome hu'na kegahue. ");
INSERT INTO kbq_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mosese'a Ra Anumzamofonte ete vuno anage hu'ne, Israeli vahe'mo'za ana osuga vahe'mo'za tusi'a kumi hu'za golire havi anumzazmia tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Hianagi menina Kagrama kasunku'ma huzmantesunka kumi'zmina atrezmanto, anama osanunka avontafepima nagima krente'nanana rehanano. ");
INSERT INTO kbq_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ra Anumzamo'a Mosesena kenona'a hunteno, iza'o kumi'ma hu'nesimofonke avontafeni'afintira agia rehanenegahue. (Rev-Hufo Hu'ne 3:5) ");
INSERT INTO kbq_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Hagi menina vunka, kema hu'noa kumatera zmavrenka nevugeno ankeronimo'a vugota hurmanteno tamavreno vugahie. Hianagi zamazeri havizama hanuanknama esige'na, kumi'ma hazarera nona hu'na zamazeri haviza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aroni'ma golire bulimakao tro'ma hunte'nege'za musenkasema hu'naza zantera, Ra Anumzamo'a knazanteti Israeli vahera zamahe'ne. ");
INSERT INTO kbq_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Anante Ra Anumzamo'a Mosesena asamino, Abrahamuma, Aisakima, Jekopuma huvempa hu'na tamagehe'ima zamigahue hu'noa moparega, ama kumara atrenka kagrane Isipiti'ma zamavare fegi atrenka e'nana vahe'enena viho. ");
INSERT INTO kbq_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ankero vahe huntesugeno vugota huramanteno Kenani vahe'ma, Amori vahe'ma, Hiti vahe'ma, Perisi vahe'ma, Hivi vahe'ma, Jebusi vahetamina ana mopafintira zamahe natitregahie. ");
INSERT INTO kbq_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Hagi amirimo'ene tumerimo'ma avi'mate'nea moparega mareriho. Hianagi Nagra tamagranena ovugahue. Na'ankure tamagra ke ontahi vahe mani'nazanki'na kantega tamahe frigahue. ");
INSERT INTO kbq_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Israeli vahe'mo'za ana zamazeri havizama hania nanekema nentahi'za zavi krafa nehu'za mago'mo'e huno avufgarera avasesezana osu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Na'ankure Ra Anumzamo'a Mosesena asamino, Israeli vahera zamasamio, zamagra ke ontahi vahe mani'nazanki'na Nagrama zamgranema vanu'na ame hu'na tamahegahuanki menina tamavufgareti tamavasese zana erinetrenke'na Nagrama huramante'nua zankura antahi'neno. ");
INSERT INTO kbq_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Hige'za Israeli vahe'mo'za zmavasesezama hu'naza zana, Horepi agonafi zafitrete'za amane vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Hagi Mosese'a nehiaza huno kuma'mofo fegia ogantu mago seli no azeri otino kinenteno, Ra Anumzane atruhu seli mono none huno agia antemi'ne. Ra Anumzanema keaga hunaku hanimo'a, kumamofo fegi'a ana seli nonte vugahie. ");
INSERT INTO kbq_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ana seli nontegama Mosese'ma nevigeno'a, mika Israeli vahe'mo'za seli nozamimofo kahante otine'za negazageno, Anumzanema atru huno keagama hu seli nompina ufretere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mosese'ma ana seli nompima anama ufreterema nehigeno'a vimago hampomo eramino seli no kafante emani'negeno, Ra Anumzamo'a Mosese enena keaga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Israeli vahe'mo'za ana hampomo'ma Anumzanema atruhuno keagamahu seli nomofo kafante oti'nege'za nege'za, mika'mo'za oti'za seli nozamimofo kafante zamarena re'za monora huntetere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ra Anumzamo'a Mosese ene oge age nehuno rone'anema keaga hiankna huno nanekea hu'ne. Mosese'a anama huteno eteno kumapi vugahianagi, azama nehia nera, Nuni nemofo Josua'a ana seli nompina maka kna nemanie. ");
INSERT INTO kbq_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosese'a Ra Anumzamofona asamino, Ko ama'i vahetamina vugota huzamantenka zmavrenka mrerio hunka Kagra nasami'nane. Hianagi iza'ene hurantegahane, Kagra onasami'nane. Navesinegante'na kagika'a antahi'noe hunka hu'nane. ");
INSERT INTO kbq_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kagrama tamage hunka kavesima nantesunka, Kagraka'a kavukavara rempi hunamige'na nentahi'na kavesi zankura hakevava haneno. Hagi Israeli vahera Kagri vaheki kagesa antahizamio. ");
INSERT INTO kbq_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ra Anumzamo'a kenona huno, Nagra kagrane mani'na nevu'na manifrua kamigahue. ");
INSERT INTO kbq_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Hagi Kagrama, tagranema ovanunka, tatregeta ama kumara atreta ovamneno. ");
INSERT INTO kbq_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nagri'ene Israeli vahe ka'anema Kagrama ovananke'za, inankna hu'za ru vahe'mo'za tavesinerantane hu'za antahigahaze? Kagrama tagranema vananke'za mika ama mopafima mani'naza vahe'mo'za tagrikura ruzahu vahe mani'naze hu'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Hagi Ra Anumzamo'a Mosesena asamino, Anama nantahigana zana hugahue. Na'ankure Nagra muse hunegante'na kagika'a antahi'noe. ");
INSERT INTO kbq_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Anante Mosese'a huno, Menina hanave nentake masaka'a naveri huo higeno, ");
INSERT INTO kbq_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ra Anumzamo'a huno, maka knare navu'nava zani'ane kavuga enevu'na, nagini'a huama hu'na Ra Anumza mani'noe hu'na hugahue. Hagi nasuma raginte'naku'ma hanumofona, nasu raginente'na, nasuma raginte'na azama hunaku'ma hanumofona, agampu hunte'na aza hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hianagi Nagri navugosa kagra onkegahane. Na'ankure nagesimo'a frigahie. ");
INSERT INTO kbq_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Hagi ko, antu have agofetu oti'nesanke'na, ");
INSERT INTO kbq_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","hanave nentake masani'ane kavuga evu kagatenere'na enevu'na, have kankamunpinka kavre'na nazanu rufitegante'nena kagatere'na enevu'na, ");
INSERT INTO kbq_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","nazana erisga ha'nena namefi'age kegahane. Hianagi navugosafina onagegahane. ");
INSERT INTO kbq_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ra Anumzamo'a Mosesena asamino, Ese tare have tafekna hunka tare have tafe taga huge'na, ese'ma tare have tafete'ma me'nea nanekema rutamana'ma hu'nana nanekea krentaneno. ");
INSERT INTO kbq_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Oki nanterana retro hunka Sainai agonafi mani'nesurega emarerio. ");
INSERT INTO kbq_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Magomo'e huno kagranena ana agonafina omege, bulimakao afu'zagane sipisipi afu'zaganena ana agonamofo agafina trazana apri'za oneho. ");
INSERT INTO kbq_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Higeno Mosese'a Ra Anumzamo'ma huo huno'ma hunteaza huno, ese tare havegna have tafe taga huno azampi e'nerino, nanterampi Sainai agonarega mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Anante Anumzamo'a hampompi eramino Mosese ene eme oti'neno, Ra Anumza mani'noe huno agi'a huama hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mosese avuga Ra Anumzamo'a evu agatereno nevuno, huama huno Nagra Ra Anumzane, Nagra Ra Anumzane, vaheku nasuraginte'na zmazahu Anumzane. Ame hu'na narimpa ohe'na, vaheku zmavesi zmante'na hugahuema hu'nama huaza hufatgo hu'na nehua Anumzane. ");
INSERT INTO kbq_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nagra rama'a tauseni'a vahe zamavesi zmante'na, kefo avu'ava'ma nehu'za, kema nontahi'za kumi'ma nehaza vahera kumi'zmia atrenezamantoa Anumzane. Hianagi kefo zamavu'zmavama nehaza vahera ozamatre'na, anama haza zantera kna nezami'na, mofavre'amokizmine agehemofone agigomokizminena zmahegahue. ");
INSERT INTO kbq_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mosese'a ame huno mopafi arena reno mono hunteno, ");
INSERT INTO kbq_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ra Anumzamoke, Kagri kavure'ma kavesi'nea navu'nava'ma nehanugenka, muse hugantoanki tagranena vuo, ke ontahi vahe mani'nonanagi Ra Anumzamoka kefozantine kumitinena atrenerantenka, kagraka'a vaheka'agna hunka tavro. ");
INSERT INTO kbq_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Anante Ra Anumzamo'a huno, Nagra kagrane huvempa nehue, mika Israeli vaheka'afina korapara mika mopane mopane kumapina osu'noa kaguvaza erifore hugahue. Tamagrane manisaza vahe'mo'za Nagrama Ra Anumzamo'na hanuazana nege'za antahintahi hakare hu'za koro hanazaza kagripina eri fore hugahue. ");
INSERT INTO kbq_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Menina huoma hu'na hugantoaza amage anto. Nagra esera Amori vahe'ma, Kenani vahe'ma, Hiti vahe'ma, Perisi vahe'ma, Hivi vahe'ma, Jebusi vahera zamahenati atregahue. ");
INSERT INTO kbq_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kva hu'neta anama nevaza mopafi vahetaminena eri hagerafitma mani huvempa kea osiho. Ana vahe'mo'za amu'nontamifina krifugna hu'za tamazeri haviza hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Hianagi kresramnavu itazmia anafe nehuta ruotage'ma hu'nea havezmia rutamana nehuta zafare antre'za tro huntene'za mono hunentaza asera zafaramina antagitreho. ");
INSERT INTO kbq_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ruga'a anumzantera monora huonteho, na'ankure ru anumzante'ma mono'ma huntesageno'a Ra Anumzamofo agia kanivere Anumzankino, kanive reramantegahie. ");
INSERT INTO kbq_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ana mopafi nemaniza vahetaminena eri hagerafino mani huvempa kea osiho. Na'ankure anumzazmire'ma kresramna nevu'za, ru vene ome savri hiankna hu'za havi anumzante mono hunente'za, tamagima hanageta kresramna vanaza ne'za zamia negahaze. ");
INSERT INTO kbq_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ana nehuta Israeli vahe'mota ne'mofavretamire'ma ana mopafi a'nema erizamisaza a'nemo'za, ru vene savri hiankna hu'za anumzazmire monora hunente'za, ana ne'mofavretamia zamazeri savri hanage'za, ru vene savri hiankna hu'za zmagranena Anumzamo'na natre'za ru anumzante monora huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Kaza osu anumzantamina aenia kre mra'mra hutma trora osutfa hiho. ");
INSERT INTO kbq_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Zisti onte bretima nenaza knarera tamagera okanitma ne'za tro huta neneta musena hiho. Hanki 7ni'a zagegnafina zisti onte breti neho hu'na huramante'noe. Na'ankure Abib ikampi huhamprinte knare anara hiho hu'na huramante'noe. Na'ankure ana ikampi Isipitira etirami'naze. ");
INSERT INTO kbq_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ese'ma kasentesia ne'mofavrene, ese'ma kasentesia bulimakao afuro sipisipi afutamina, Nagri su'zane. ");
INSERT INTO kbq_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ese'ma kasentesia ve donki afura, sipisipi afu anenta aheta ofa hutma ete mizaseho. Hianagi aheta ofa hutma miza osesuta, ana ve donki afura anankema'a eri vamagita ahe friho. Hagi ana miko ese ne'mofavretamimofo nona'a huta mizaseta zamavareho. Mago'mo'e huno Nagri navurera aza avapakora omeno. ");
INSERT INTO kbq_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Hagi 6si zage knafi eri'zana eriho. Hianagi 7ni zageknarera mani fru hiho. Hozama hagolino ante knarero, ne'za hamare knare enena mani fru hiho. ");
INSERT INTO kbq_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ese ne'zama hamare musema hanaza knarera, ese witireti ne'zana kreta neneta, musena nehuta kafumofo atuparega witima hamare vagare ne'zana kreta neneta musena hiho. ");
INSERT INTO kbq_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mago kafufina 3'a zupa mika Israeli vene'nemo'za tusi'a hihamu'ane Israeli Ra Anumzamofo avurera eho. ");
INSERT INTO kbq_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Tamagrama ana huta mago kafumofo agu'afima 3'a zupama Ra Anumzamo'na navure'ma vanage'na, Nagra mopatamia erira nehu'na, ana mopafi vahe'mokizmia zamahe natitra'nena, mago vahe'mo'a ana mopatamia kenunu nehuno, hara huramanteno mopatamia e'origahie. ");
INSERT INTO kbq_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Hagi korane zistima me'nesia zanura Nagritera ofa huta Kresramana oviho. Ra Anumzamo Israeli vahetamia ozmaheno zamagatere'nea knagu antahimiza, muse ne'za kre'za nesaza kenegera, nege'atrege'ma hanaza ne'zamo'a me'nenkeno masa osino. ");
INSERT INTO kbq_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ese zana Ra Anumzanka'amofo nontega ese'ma knare ne'zama mopafinti fore'ma haniana erinka vuo. Hagi meme afu anentara nerera amirimpina onkro. ");
INSERT INTO kbq_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Anante Ra Anumzamo'a Mosesena asamino, Ama nanekeramina krento, na'ankure ama ana nanekeraminteti kagri'ene Israeli vahe'enena eri hagerafi huvempa kea nehue. ");
INSERT INTO kbq_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosese'a 40'a zagegnagi 40'a haninki huno nezane tinena oneno ana agonafi maninegeno, Ra Anumzamo'a 10ni'a kasegea tare have tafetera avona krente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosese'ma Sainai agonaregati'ma kasegema krente'nea tare have tafe'ma azampi eri'neno e'neramino'a, avugosamo'ma masanentike hu'nema'a antahinokenora osu'ne. Na'ankure Ra Anumzane keaga hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aroni'ene mika Israeli vahetamimo'zama Mosesema kazana, avugosamo'a masanentike hu'nege'za, ta va'oma'are'ma Israeli vahe'mo'za e'zankura kore hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Hianagi Mosese'a ke hige'za Israeli vahe'mo'za erava'o hazageno, Sainai agonafima Ra Anumzamo'ma mika ami'nea kasegea Mosese'a zamasami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ana hutazageno, mika Israeli vahe'mo'za Mosesente erava'o hazageno, Sainai agonafima Ra Anumzamo'ma mika ami'nea kasegea Mosese'a zamasami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosese'ma nanekema zmasami vagarete'noa tavrave erino avugosa refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Hianagi Ra Anumzamo'enema keagama hunaku'ma atruhu seli nompima Mosese'ma ufreterema nehuno'a, ana tavravea eritreteno unefreno, ete atineramino'a, Ra Anumzamo'ma ome zamasamio hu'noma asami'nea kea Israeli vahetamina nezmasamige'za, ");
INSERT INTO kbq_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","avugosamo'ma masanentike hu'neama'a kazageno, ete tavravenuti avugosa refite'neno keaga huteno, ete Anumzanema keagama hunakura eri atre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosese'a mika Israeli vahera zamazeri atru huno zamasamino, Ra Anumzamo'a ama kasege amage anteho huno huramante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sigisi'a zageknafi eri'zana eriho, hianagi 7ni zageknarera Ra Anumzamo'ma mani fru hiho huno'ma huramante'nea ruotage hu'nea knagita mani fru hugahaze. Iza'o ana zageknafima eri'zama erisimofona ahe friho. ");
INSERT INTO kbq_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mani fru knazupa Sabatirera nemaniza kumatamimpina tevea huonkreho. ");
INSERT INTO kbq_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mosese'a mika Israeli vahera zamasmino, amanahu'za hiho huno Ra Anumzamo'a hurmante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Tamagra Ra Anumzamofontera ofa erita eho. Iza'o agu'areti'ma huno ofama hunaku'ma Ra Anumzamofonte'ma hanimo'a, goline, silvane bronsine, ");
INSERT INTO kbq_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","hokonke nofiki, fitunke nofiki, koranke nofite ene, zmanazmana nofite tro hu'nesia tavravene, meme afu'mofo azoka'ene, ");
INSERT INTO kbq_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ve sipisipi afutamimofo akrutami eri korankre hu'nesazane, hagerimpi bulimakao afutamimofo akrutamine akasia zafane, ");
INSERT INTO kbq_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","tavi'ma rekru hunte olivi masavene, vahe'ma huhamprinte masavempima antegeno mnanentake nehia zantamine, kremnama vu'zane, ");
INSERT INTO kbq_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","oniksie nehaza havene, pristi vahe'mo amega antani kukenane amimizare'ma antani kukenare'ma rekamrente havea ofa erita eho. ");
INSERT INTO kbq_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Amu'nontamifinti'ma mika'zama knare'ma huno trohu antahi'zama eri'naza vahe'mota eta Ra Anumzamo'ma mika zama tro hiho huno'ma huramante'nea zana eme tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hagi Seli mono none, ana nomofo refite tavraveramine, eri fagaginte'ne tavrave hanti riniramine, no zafaramine, rugeka zafaramine, retrure zafane, regrinte tra'ane, ");
INSERT INTO kbq_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kasegema ante vogisine, erisgama huno vu zafararene, ana vogisimofo avaza'a e'i asunku trarema nehaza avaza'ane seli nompima hunaragintegeno ruotage'ma hu'neama'ama refitenia tavravene, ");
INSERT INTO kbq_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","bretima ante itane, erisgama huno vu azotararene, maka ana itare'ma eri'zama eri'zantamine, Anumzamofo avure'ma me' bretine, ");
INSERT INTO kbq_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","tavi'ma rekruhu azota'ane mago'a zantamima'ene tavitamine, tavi'ma rekruhu masavene, ");
INSERT INTO kbq_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","mnanentike zantami kre itane ana itama erisgahu zafararene tagino frenteno huhamprinte masavene, kre mnavu zantamine, seli mono nomofo ufre kahante tafinte tavravene, ");
INSERT INTO kbq_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kresramnavu itane, bronsireti rama'a karami hagente'za strena knaza tro huta anaga tevema hugre'afina runekamareta erisgahu azotararene ana itare'ma eri'zama eri'zantemine agi'ama me'ne bronsire zuompane, ");
INSERT INTO kbq_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","seli no kumamofo avazagi kagi tavraveramine, retrure zafaramine, ana zafaramima regri tra'aramine, seli nomofo kumapi ufre kafante tavravene, ");
INSERT INTO kbq_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","seli mono nomofo tavravene, kuma'ma avazagi kagi keginamofo tavravema avazuhumpi huno anaki azotane nofi'ane, ");
INSERT INTO kbq_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","pristi vahe'mo'za antanine'za ruotage hu'nefinka eri'za erisaza ruotage kukena haneta tro nehuta, Aronine ne'mofavre'aramimo'za antanine'za pristi eri'zama erisaza kukena tro hiho. ");
INSERT INTO kbq_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Anante mika Israeli vahe'mo'za Mosese'enema mani'nazaretira atre'za vu'za e'za hazageno, ");
INSERT INTO kbq_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","mika zmagu'amo'ma otige'za amisunema hu'zama haza vahe'mo'za atrumahu seli mono noma kisaza zane, ruotage hu'nea kukenaramine eri'za Ra Anumzamofonte ofa e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mika zmagu'amo'ma otia vene'nemo'zane a'nemo'zanena golireti ruzahu ruzahu avasase zama tro'ma hu'nea zantamina, zmanankempi antani'nazane, zmagesafi tafi'naza rinine, zamazampi antani'naza rinine, zamanankempi hu'zane, eri'za e'za Ra Anumzamofonte eri verave hu ofa hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Mika hokonkero, fitunkero, koranke nofiro knare huno zamana'zmana hu'nesia nofiro, memekimofo azokaro, ve sipisipi afu akru'mofo eri koranke hu'nesia akrutamino, hagerimpi bulimakao afu'mofo akrutamima ante'namo'za eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mago'a vahe'mo'zama silvane bronsine ofa Ra Anumzamofo eri'za eme nemizageno, akasia zafama ante'naza vahe'mo'za eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nofi'ma zamazanu'ma zagi'ama antahi'nesaza a'nemo'zama hokonkero fitunkero koranke nofi'ma zmanazmana nofiteti tro hunte'nesaza tavravea eri'za eho. ");
INSERT INTO kbq_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Nofi'ma zmazanu'ma zagi antahi'zama eri'naza a'nemo'zama, maka zmagu'amo'ma otinke'za nofi'ma zaginaku'ma hanu'za meme afu'mofo azokateti nofira zagiho. ");
INSERT INTO kbq_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Hagi kva vahe'mo'za oniksie nehaza haveramine, mago'a zago'amo'ma marerisa haveramina pristi vahe'mo'zama amega antani kukenare'ene amimizare'ma antani kukenare'ma rekamrente'zana erita eho. ");
INSERT INTO kbq_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ana kva vahe'mo'za mnama vu tanefatamine, tavi rekruhu olivi masavene, vahe'ma tagino frenteno huhamprinte masavene, kregeno mnama vu'zane eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mika Israeli vene'nemo'zane a'nemo'zanema, zamagu'amo'ma oti'nea vahe'mo'za Ra Anumzamofonte ofa eri'za e'naze. Ra Anumzamo'ma eriho huno'ma huzmante'nea eri'za erisagu eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Anante Mosese'a Israeli vahera zmasamino, Keho, Ra Anumzamo'a Bezalelina Uri nemofo Huri negeho Juda nagapinti huhamprinenteno, ");
INSERT INTO kbq_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Anumzamofo Avamu antevitenenteno, knare antahi'zane, ama' antahi'zane, mika zama azanu'ma tro'ma hu antahi'zane, ");
INSERT INTO kbq_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","golireti'ene, silvareti'ene, bronsireti'ma avasesezama trohu antahi'zana ami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ana nehuno havema tagahuno eri ante fatgohu antahi'zane, zafare'ma hanagatino eri'zama eri antahi'zane, mika ruzahu ruzahu kasefa zantamima tro'ma hu antahi'zane ami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Bezaleline Ahisameki nemofo Oholiapu, Dani nagapinti ne'enena vahe'ma rempima huzami antahi'zana Ra Anumzamo'a znami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ra Anumzamo'a maka ruzahu ruzahu zante'ma azanu'ma hanagatino tro'ma hu antahi'zane, eri'zama retrohu antahi'zane, hokonke'ma, fitunke'ma koranke tavravere'ma hatino avoma kreno avasese zama'ama tro'ma hu antahi'zane, nofi'nu'ma haneno zamana zamana tavravema trohu antahi'zana zanami'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Hagi Bezaleli'ene Oholiapu ene mago'a naga'enema Ra Anumzamo'ma antahintahima zamige'za seli mono noma ki' eri'zama antahi ankere'naza vahe'mo'za, Ra Anumzamo'ma hihoma huno hu'nea kante ante'za ana maka zana tro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Anante Mosese'a Bezaleline Oholiapune Ra Anumzamo'ma antahintahima zamige'za eri'zama antahi ankere'ne'za eri'zama eriku zame'nesia vahe'mokizmia zamagi huno eri'za erigafa hiho hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Israeli vahe'mo'za Anumzamofo seli mono noma kisnazegu'ma eri'za eme ami'naza muse zantamina, Mosese'a ana maka'zana erino eri'zama eri vahera zami'ne. Hagi maka nanterana Israeli vahe'mo'za zmagu'amo'ma otimo'za zamesi zante musezana eri'za eme amitere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Anumzamofo seli mono noma ki eri'zama antahi ankere'naza vahe'mo'za mono noma ki eri'za zamia atre'za, ");
INSERT INTO kbq_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mosesena eme asami'za, Ra Anumzamo'ma erita ehoma hu'nea avamena rugatere'za Israeli vahe'mo'za rama'aza eri'za azageno eri'zana eri vagarega hu'nege'za, ete mago'ane rama'a eri'za neaze. ");
INSERT INTO kbq_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mosese'a amanage huno kea Israeli vahetega atre'ne, mago a'mo'o vemo'o Anumzamofo seli mono no ki'zane huno mago'ane musezana erino eme otreno, hige'za anankea Israeli vahe'mokizmi amu'nompi hugantigama hazage'za, mago'anena Israeli vahe'mo'za mono noma ki zantamina eri'za ome'naze. ");
INSERT INTO kbq_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Na'ankure, ko'ma Israeli vahe'mo'zama eri'za emetre emetre hu'naza zantamimo'a Anumzamofo seli mono noma ki' avamentera ko agateregeno, mago'a zantamina amne mega hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tavravema hane antahi'zama antahi'naza vahe'mo'za 10ni'a tavrave hati'naze. Ana tavrave nofi'nu avonkreno hati antahi'za eri'nea ne' Bezaleli'a ana tavraveramintera hokonke nofiki, fitunke nofiki, koranke nofinu'ene hatino seravimie nehaza ankeromokizmi zmema'a tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ana maka tavravemofo zaza'amo'a 12 mita higeno, atupa'amo'a 2 mita higeno urefa erefa'amo'a mago zanke hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Hagi 5fu'a atupa'aramina rehatigeno, magoke za'za tavrave fore higeno, anahukna huno ru 5fu'a tavravemofo atupa'aramina rehatigeno, magoke za'za tavrave fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Anante ana za'za tavravereremofo tupa'arera tare tavravere'ma eri hagerafi atupa'ama tro'ma hu'neana hokonke tavravenuti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Mago za'za tavravemofo atupa'arera tavravereti tro hu'neana 50'a hagerafi atupa'ama tro'ma hu'neana, anakinte anakinte huno evu'ne. Ete mago zaza tavravemofo atupa'are enena ana zanke huno ru 50'a eri hagerfi atupa'ama tro hunte'nea anakinteno evigeno eri hagerafi atupa'aramina, rugaraga mago trente metere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Anantera tare tavravere'ma 50'a eri hagerafi atupa'ama tro'ma huntenefina, eri hagerafino eri ruhamprigeno, golireti eri korave huno 50'a rini kana tro huteno, ana tare tavravea eri rusi higeno, ana tavraveraremokea erimago huke me'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Anante seli mono nomofo agofetu'ma refitesia zana, meme afu'mofo azokateti 11ni'a tavraverami tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ana 11ni'a tavraveramimofo zaza'amo'a 13 mita hazageno, atupa kizaga'amo'a 2 mita hu'za mago zanke hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ana 11ni'a tavravefintira 5fu'a tavraveramina erinte mago huno hatigeno magoke za'za tavrave fore higeno, ana zanke huno 6si'a tavraveramina erinte mago huno hatigeno magoke za'za tavrave fore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Anante mago za'za tavravemofo atupa'arega eri hagerafi atumpa'a 50'a tavravereti trohu nenteno, ete mago za'za tavravemofo atumparega ana zanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Anante 50'a eri hagerafino eri ruhampri'zana bronsireti eri korave huno 50'a rini kana tro huteno, ana tare tavravea eri rusi higeno ana tavraveraremokea erimago huke me'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Anante seli mono no refite tavravemofo agofetu mago'ane refite'zana ve sipisipi afutamimofo akrutami eri koranke hu'nea akru'anu refite'ne. Mago'ane ete ana agofetu'ma refite'neana hagerimpi bulimakao afutamimofo akruteti tro hu'nea zanu refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Hagi seli mono nomofo retrure zafama tro'ma hu'neana, akasia zafareti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ana seli noma eri otino ki'nea zafaramimofo zaza'amo'a, 4'a mita higeno, kahesa'amo'a 66si'a sentimita hutere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ana seli mono noma vazisgama hania zafarera, tare rusima hu'zana taga huno tro huntegeno, tra'afina ome regrino rusi huno tragoteno me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","E'i anama huno'ma tro'ma huteno'a 20'a zafaramina seli nomofona sauti kaziga retrure'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ana zafarmimofo tra'azmia silvareti 40'a tro hu'ne. E'i tare tra'mokea tare zafa znazeri tragotesakeno mago nozaferina fore hutere hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ana hukna huno mago kaziga asoparega noti kaziga noma reharere zafaramina 20'a tro nehuno, ");
INSERT INTO kbq_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","regri tra'zmia silvareti 40'a tro nehuno, mago zafamofona tare regri tra'a tro huntetere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Hagi ana seli mono nomofo amefi'a zage ufre kaziga reharere zafaramina 6si'a tro nehuno, ");
INSERT INTO kbq_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ana seli mono nomofona rugaraga kazigati renagentetera tare reharere zafarere tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","E'i ana renagente zafarerena, fenkama kaziga atupamokea magoke regri tra'afi regrike ruhamprikeno, anagamu kaziga atupa'araremokea magoke rini kampi ome rusihuke ruhaprike eri magoke hu'na'e. Anazanke huno mago kaziga renagetetera tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","E'inama higeno'a ana makara 8'a zafa megeno ana zafaramima regri trara silvareti mago'mago zafarera tare tra trohutere higeno, ana makara 16ni'a tra me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ana zanke huno seli mono nomofo rugekahu zafaramina, akasia zafareti 5fu'a tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Hagi ana zanke huno mago kaziga asopareganena (saut) rugeka zafa 5fu'a tro nehuno, seli mono nomofo atupa kaziga zage fre kaziganema (west) me'nea zafarera ana zanke huno 5fu'a rugeka zafa tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ana 5fu'a rugeka zafaramimpintira amu'nompima rugeka'ma hu'nea zafamo'a, mago asopamofo atuparetira vuno, mago atupare uhanitine. ");
INSERT INTO kbq_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ana zafaramimofona goliletike erino nevazino, goli rinima asopa zafafima tro'ma hunte'nenefi vazintegeno, mago atupareti mago atupare uhanatine. ");
INSERT INTO kbq_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Seri mono nona zamana zamana'ma hu'nea nofiki, hokonke nofiki, fitunke nofiki, koranke nofi avazu huno zagi'nea osi nofiteti tro hu'nea tavravereti hunaragi'ne. Serabimie nehaza ankeroramimofo zmema'a hentofaza huno tavravere'ma nofiteti'ma avoma kre antahi'zana eri'neankino ana tavraverera hatino tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ana tavravema hanti'zana, 4'a akasia zafa golireti eri ano vaziteno, ana zafarera eri rusihu rini'a golireti tro huteno, retrure tra'a silvaleti 4'a tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mago rantavravea knare'zantfa hu'nea tavravereti seli mono nomofo kahana tro huteno sipisipi zokateti tro hu'nea koranke ene hokonke treti nofi'nuti ene ruzahu ruzahu knare treti nofi'nuti avasese zama'a tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ana 5fu'a retrure zafarera tavravema hanti'zana golireti eri fagigino tro hunenteno, ana zafaramimofo asenire ene rinire'enena golireti eri ano nevazino, retrure tra'zamia bronsireti 5fu'a tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Hagi Bezaleli'a akasia zafareti kasegema ante bokisia tro hu'ne. Ana bokisimofo zaza'amo'a 110ni'a sentimita higeno, atupa kaziga'amo'a 66si'a sentimita higeno, anagamuma mareri'amo'a 66si'a sentimita hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Fegi'ane agu'afinena goliretike eri anovaziteno anagama avazarera goliretike avazareno kagi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hanki 4'a golire rini tro huno fenkami kaziga agente agentera tare tare huno ome arekamarente eme arekamarente hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ana huteno akasia zafa antreno tare zota trohuteno golinuti eri ano vazinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","E'i ana tare zafararena, ana vogisima erisga huno vu'zana 4'a rinima rekamarente'nefinka rugaraga vazinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Hagi ana vogisimofona, asunku zamofo trare huno avaza'a goliretike tro huntegeno, zaza'amo'a 110ni'a sentemita higeno, atupa kaziga'amo'a 66si'a sentemita hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Anante ana avaza'arera hamanu golia ruguta huno tare serabimie nehaza ankerontre rugaraga atupa'ararentera tro huzanante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Serabimie nehaza ankerontre'ma tro'ma hu'neana, ana asunku tra'ma tro'ma hu'nea golinutike, rugaraga agentera ana ankerontrena magoke golinutike tro huntegeno eri mago hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ana Serabimi ankeroraremokea zanavugosa ohumi ahumi nehuke, kepri hu'ne asunku tra'mofo negakeno zanageko'namo'a rufanara huno ana vogisia refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Anantera Bezaleli'a akasia zafareti mago tra tro hu'ne. Ana tra'mofona zaza'amo'a 88'a sentimita higeno, atupa'amo'a 44'a sentimita higeno, mareri'amo'a 66si'a sentimita hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ana tra'mofona golinutike eri ano nevazino, agema'aramintera ana golinutike eri avozaze huno eri pehe huno ava regagi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hagi ana tra'mofo atumpa'arema eri agu'a huno rugagi'neana 8'a sentimita higeno, golinutike eri avozaze huno eri pehe huno avarente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ana huteno 4'a golire rini tro huno 4'a agamofo tavaonte agente agentera rekamarente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Ana 4'a rinima rekamarente'neana ana tramofo anagami rugaraga agentega rekamrente'neankino ana riniramimpi erisga huno vu'zana tare zota vazinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ana tra'ma erisga huno vu'zana, akasia zafa antreno tare azota tro huteno, ana azotararena golireti eri anovazi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hanki tima taginte zuomparamine waini tima tagi'zama ofa hu'zane tintafene kapunena golinutike'za tro huntegeno ana tratera me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hagi tavi'ma rekru hunte azotama Bezaleli'a tro'ma hu'neana, hamanteti aruguta huno magoke golinutike, retrure'agi, nenarampa'agi, azankuna'ane asi'na'anena tro hunenteno, amosre'agna huno tavi'ma rekruhunte'a tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Hagi ana tavi zotamofona 6si'a azankuna tro hunte'ne. Rugaraga 3'a azankunakna huno tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Hanki ana azotamofo 6si'a tavi'ma rekru hunte azankunatamimofo atuparega, almoni zafamofo anina'ane amosare'agna huno tavi'ma rekruhunte'a tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hanki amu'nompima mareri'nea zotarera, almoni zafamofo amosare'agna huno 4'a tavi'ma rekruhunte'a trohunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hanki ana zotamofoma rugaraga azankunatrema trohunteterema hu'nerera tare almoni zafamofo anina'a rugaraga trohuntetere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ana tavi azotama, azankuna'aramima, ani'na'ama, amosare'anema tro'ma hu'neana magoke golinutike, arukuta huno tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ana 7ni'a zotarera lamu tavi tro huno nenteno, ana lamu tavimofo osama hampage tu'zane osama erinte tafenena maka golinutike tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","E'i ana tavi zotamofoma mika zantamima'ama tro'ma hu'neana kna'amo'a 34'a kilo hu'nea golireti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ana huteno'a mnama vu zantamima kre snageno'ma mnama vania ita, magoke akasia zafaretike'za tro hu'ne. Ana itamofo zaza'amo'a 45'a sentimita higeno, kahesa'amo'a 45'a sentimita higeno, mika asopa'amo'a mago avamenteke megeno, atrure'amo'a 90'a sentimita mrerigeno, ana itamofona 4'ama renagentetera pazive tro huntetere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ana itamofona agofetu'agi, maka asopa'agi pazivetaminena goliretike erinovazinenteno, ana itamofo agema'aramintera goliretike avareno avasase'a hugagi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Kolireti'ma avasasema hunte'nemofo henka kaziga, zotama vazino eri sgama huno'ma vu'zana golireti tare rinia ruga ruga asoparega tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ana itama eri sgama huno vu'zana akasea zafareti tare azotarare tro huno golireti erinovazinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Anantera ruotage masavena pristi vahete'ene mago'azante'ma tagi'za frenente'za huhampri nezmantaza masavene, mnanentake zama tro'mahu antahintahima erine'zama tro'ma nehazankna huno, mnanentake'zana tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Hagi Bezaleli'a akasia zafareti kresramnavu itama tro hu'neana, mareri'amo'a 1 mitagi 30'a sentemita higeno zaza'amo'ene kahesa'amo'enena mago avamenteke 2 mitagi 20'a sentemita hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Hanki 4'a omerenagente eme renagente'ma hutera mago pazive tro huntetere higeno, ana pazivetamina itama tro'ma hu'neana zafareti tro higeno rutragote no erimago zanke higeno, ana ita bronsireti amega'a anovazinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ana itare'ma eri'zama eri'zantamina bronsireti tro'ma hu'neana, tanefa'ma katetre kavoraminki, osama kate sipetiraminki, ru tritri hu zuomparaminki, afu'ma revazuhu zotaraminki, tevema tagi osi zuomparaminki huno tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Bronsireti rama'a kantami hagente'za strena tro huno tevema hugre itamofo anagati'ma urami'nea agu'afi antegeno uramino amu'nompi me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Anante 4'a bronsire rini tro huno azotama vazinteno erisga huno vu'zana 4'a renagentetera rukamre'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Hagi agra akasia zafareti tare azota antreno tro huteno bronsireti eri anovazine. ");
INSERT INTO kbq_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ana azotarerena kresramna vu itamofo asoparega riniramima tro'ma huntepinka erino vazinte'ne. Ana vogisi'a kuta zafareti tro higeno, agu'afina hagro huno me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Anumzanema atruhu seli mono nomofo kafante'ma eri'zama e'neri'za a'nemo'za zmavugosa negaza bronsire kapo Bezaleli'a erino, ti fre zuompane aga'anena tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Anantera seli mono nomofo kuma keginama hu'neana, sauti kaziga zaza'amo'a 44'a mita higeno osi nofiteti zagino hati'nea tavaravereti keginarera tafinteno enevuno, ");
INSERT INTO kbq_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Keginama azeri oti zafaramina 20'a tro nehuno, kegina zafamofo regri tra'a bronsireti 20'a tro nehuno, tavravema erirusi huno tafinte'zantamine rininena silvareti tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ana zanke huno noti kaziga keginahu tavravene seli mono noma azeri oti zafaramina 20'a tro nehuno, kegina zafamofo tra'a bronsireti 20'a tro nehuno, tavravema erirusi huno tafinte'zantamine nofi'ma rente'zantamina silvareti ana zafaramimofo avozarera tro hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ana seli mono nomofo zage ufre kaziga tavravenu'ma keginama hu'neana kahesa'amo'a 22'a mita higeno, keginama eri oti'zafa 10ni'ane tra zamia, 10ni'a silvareti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hanki zage hanati kazigama avugosama hunte'nea kaziga kuma'mofo kahesa'amo'a 22'a mita hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kama ufrete'ma tamaga kaziga hanti tavravea, zaza'amo'a 6gis mitagi, 60 sentimita higeno, kegina retrure zafa 3'a tro nehuno tra'aramina 3'a tro huno ana zafarera tavravea tafinteno evu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hanki kama ufrete'ma hoga kazigama tafi tavravemofona zaza'amo'a 6gis mitagi 60 sentimita higeno, 3'a retrure zafagi, 3'a regri tra'aramina tro huteno anante tavravea tafinteno evu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ana kuma keginama maka hugagi'neana zmana'zmana nofiteti zagino tro hu'nea tavravereti kegina huno kagi'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ana kumamofo maka kegina zafaramintera, erirusi hunte zantamine riniraminena silvaretike tro nehuno, keginama regri tratamina bronsireti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hanki ana kumapima ufre kante'ma ruhiza'mahu tavaravema haneno tro'ma hu'neana, hokonke'ene fitunke'ene koranke nofiteti'ene, tro hunte'ne. Ana tavravemofo zaza'amo'a 9ni'a mita higeno, kahesa'amo'a 2 mitagi 2'a sentamita higeno maka kaziganena ana zanke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Hagi 4'a retrure zafane regri tra'zamia bronsireti 4'a tro hunenteno tavravema erirusihu zantamine, ana zafaramimofo asenire ene rinire'enena silvareti tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Kuma keginamofo tavraverarene seli mono nomofo tavravema avazuhumpi huno rente azotaramina bronsiretike ana maka tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Anumzamofo seli mono noma kasegema ante noma kinaku eritru hu'naza zantamina, Mosesi'a Livae nagaku hampriho higeno, Aroni ne'mofo Itama ana eri'zantera vugota hu'nege'za hampri'naze. ");
INSERT INTO kbq_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Juda nagapinti ne' Bezaleli'a Uri ne'mofo Huri negeho ana maka zantmima Anumzamo'ma tro huo huno Mosese'ma hunte'nea zantamina tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Hagi Dani nagapinti ne' Ahisamaki ne'mofo Oholiapu'a ruzahu ruzahu zante'ma azanteti'ma hanagatino tro'ma hu antahi'zane, hokonke'ma, fitunke'ma, koranke tavravere'ma hatino avoma kre antahi'zane, zmana'zmana nofinu'ma haneno tavrave'ma trohu antahi'zama eri'nea ne'mo aza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Anumzamofo seli mono noma kisazegu'ma eri vereve hu ofama eri'za azageno ana noma kivagare'nea golimofo kna'ama monompima refko'ma nehaza avamente'ma hampri'nazana, kna'amo'a 998'a kilogremi hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Hagi silvama eri'za azageno'ma seli mono nompima kna'ama refko'ma nehaza avamente'ma refko'ma hu'naza, kna'amo'a 3tausen 4 hantre 30'a kilogremi hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hagi 20'a kafuma agatereno mareri anagamu atre'nea vene'neramimo'za, zamagire'ma eri'za e'naza silvamofo kna'ama mono nompima refko nehaza avamente refko hu'za ke'nazana 6'a gremi hu'nea silva eri'za eme atre'naze. Hagi ana makara 603, tausenigi 550'a vene'nemo'za eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Anumzamofo seli mono nomofo retrure zafaramimofo regri tra'ama tro'ma hu'nazana, 100'a tro hazageno, ana tra'ma tro'ma hu'naza silvamofo kna'amo'a 34'a kilogremi huterere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Kna'amo'ma 30'a kilogremima hu'nea silvama amnema meama'areti, eri fagagi'za tavravema tafinte'zane, rinine tro nehu'za retrure zafaramimofona aseni'anena erinovaziza tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hanki Anumzamofoma eri vereve hu ofama eme ami'naza bronsimofo ana maka kna'amo'a 2 tausenigi 425fu'a kilogremi hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","E'i ana maka bronsireti seli mono nomofo kahante retrure zafaramimofo regri trazamine, bronsireti tro hu'nea Kresramanavu itane, rama'a kantami hagente strenane, ana itare'ma eri'zama eri zantamina tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ana bronsiretike seli mono nonkuma'mofo kegina zafaramima regri tra zamine, kahama ufrete zafaramimofo tra zami'ne, maka tvaravema avazuhumpi huno anaki azotaraminena tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hagi Ra Anumzamo'ma Mosesema asami'nea kante ante'za kukenama hatino tro hu antahintahima eri'naza vahe'mo'za, hokonkeki fitunkeki koranke nofiteti tro hu'naza zmana'zmana tavravereti, Aroni'ma antani'neno ruotage hu'nefinka eri'zama eri'nia za'za kukena hati'za tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Amega amimizare'ma antanisia ku kenama tro'ma hu'neana, golire nofiki hokonke nofiki, fitunke nofiki, koranke nofitetiki zmana'zamna hu'nea tavravereti'ene tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Hanki kukenama hatino tro hu antahintahima eri'nea ne'mo, golia aruguta huno erita'ori huteno, taga huno treti nofikna huteno hokonke ene fitunke ene koranke treti nofiteti'ma tro'ma hu'nea tavravene, efeke zamana'zamana tavravereti'ene tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Amimizafima hania kukenamofo nofi'mo'ma afumpinti'ma kreraminigeno amefigama anakisnia nofira, anaga kaziga tare atumparega hatinte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Amu'nofi'ma zagino'ma tro'ma hu'neana, golire nofiki, hokonke nofiki, fitunke nofiki, koranke nofi'ene knare zantfa hu'za zmana'zmana nofiteti hati'naza tavaravereti Ra Anumzamo'ma Mosesema asami'nea kante anteno tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Anante tare oniksie nehaza have erino 12fu'a Israeli ne' mofavre'mokizmi zamagia, ana haverarentera taga huno krente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E'i ana haverarena Ra Anumzamo negeno Israeli (Jekopu) ne' mofavre nagare huno antahi'zmi have huno afunte tavraverera Ra Anumzamo'ma Mosesema asami'nea kante anteno renteno evu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kukenama tro hu antahi'zama eri'naza vahe'mo'za, amimizare kukenama tro'ma hu'nazankna huno, hokonke nofiki, fitunke nofiki, koranke tavravereti'ene knare huno zmana'zmana hu'nea nofiteti tro hu'nea amimizare antani'nia kukenamofo agofetu'ma antani kukena tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ana tavravema za'za kazigati'ma erinteno repasi'ma higeno'a ana miko asopa'amo'a 22'a sentemita huno mago avamenteke me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mizama'amo mareri'nea haveraminteti ana tavraverera 4'a isa'are rekamarenteno evu'ne. Hanki kotama evu'nea isarera rubi havegi, topasi havegi, emerelie nehaza haverami rekamrenteno enevuno, ");
INSERT INTO kbq_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","anante isa'arera, tekuoisie nehaza havene, safaia hu'za nehaza havene, daimonie nehaza have rekamrenteno evu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Hagi nampa 3 isarera jasintie nehaza havene, agatie hu'za nehaza havene ametistie nehaza have rekamrente'za evu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Hagi nampa 4 isarera berilie nehaza havene, oniksie nehaza havene, jaspae hu'za nehaza have rekamre'za evu'naze. Ana maka haveramima azeri anoma'ama troma hu'nazana goliletike tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ana maka 12fu'a haverera Israelina (Jekopu) 12fu'a ne' mofavremokizmire huhamprino magoke magoke havea me'negeno, mago mago mokizmi zamagi'a anante taga hu'za krente'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ana amimizare'ma 12fu'a havema ante'naza tavravema rente seni nofira, goliretike tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Hanki goliretike tare nofi'ma rente rinia ana tavravemofona anagamu ruga raga kaziga ometre emetrema hutega anakinte'naze ");
INSERT INTO kbq_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ana amimizare antani tavravemofoma rugaraga atumpare'ma anakinte'naza rinirarentera, goliret'ma tare seni nofi'ma tro'ma hu'naza nofi'nu hagerafinte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Hanki ana seni nofitremofo tagina'rarena eritma rugaraga azonare'ma ante havema eri novazinea golire rentegahaze. ");
INSERT INTO kbq_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Hanki mago ene tare golire rini trohu'za amimizare'ma 12fu'a havema ante'naza tavravemofo henkamu kaziga ometre emetre hutega, agu'afi amimizare'ma hu kukenamofo tvaonte tafinte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hanki mago'ene golireti tare rinirarena tro hu'za azo'nareti'ma kreramino amimizare tavravema hagerafi'nere ruga raga avasase'ane nofi'nu'ma avamare'nere anakinte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Hagi Ra Anumzamo'ma Mosesema asami'nea kante ante'za, mago'ene golireti tare rini tro hute'za, azonareti'ma kreramino amimizare tavravema avasase'ane nofi'nu avama are'nere ruga raga hokonke nofi'nu anakintazageno hanavetino me'ne. ");
INSERT INTO kbq_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Hagi antanine'zama amimizare kukenama ana agofetu'ma hania za'za kukena, hokonke tavraveretike'za tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Hanki ana za'za kukenamofo ananke kana anagamu kaziga amu'nompi hagenente'za, ana kamofoma avazama regagi'nazana tavravea ante tapari'za zagi'za hatigagi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Hanki ana za'za kukenamofo agiaregama rugagi atumparega, pomigreneti zafa rgagna hu'za hokonke nofiki, fitunke nofiki, koranke nofinuti tro hute'za ana zaza kukenarera rentegagi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ana pomigreneti zafa rgaramimofo amu'nozmifina, golireti belotami tro hu'za rentetere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Hanki Ra Anumzamo'ma Mosese'ma asami'nea kante ante'za ana zantamima rente kagi'nazana, golireti'ma tro'ma hu'naza belora renente'za, pomigreneti zafa rgama tro'ma hu'nazana rentere hu'za ana kenamofona aga kaziga atuparega rente kagi'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Hanki nofi'nu'ma kukena hati eri'zama eri antahi'zama eri'naza antahi'zane vahe'mo'za nehazaza hu'za Aronine mofavre na'agamo'zama agu'ama antanisaza kukena zmana'zmana huno efeke tavravenuti zagi'za tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ana zmana'zamana tavraveretike zmanunte'ma anaki tavravene kankri'zamine agu'a kukena zaminena tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Hanki Ra Anumzamo'ma Mosesema asami'nea kante ante'za, nofi'nu'ma kukena hati eri'zama eri antahi'zama eri'naza vahe'mo'za nehazaza hu'za, azo'naregati'ma rugreramino asoparegama evu nofira zmana'zmana huno efeke nofi'ene, hokonke nofi'ene, fitunke nofi'ene, koranke nofinuti tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Anante goliletike mago kuta zompa tro hu'za, Ra Anumzamofontera ruotage hu'ne hu'za taga hu'za anantera krente'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Anantera Anumzamo'ma Mosesema asami'nea kante ante'za hokonke nofi'nu ana nanekema krente'naza golire zompa asenire'ma anaki tavravemofo agofetu kokovite avona anakinte'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ra Anumzamo'ma Mosesema asami'nea kante ante'za Israeli vahe'mo'za seli mono none Ra Anumzanema atruhu seli nomofo eri'zana maka eri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ana seli mono noma ki'naza zantamima tro'ma hunte'naza, eri'za Mosesente'ma e'nazana, seli nomofo tavravema hanti zantamine, retrure zafaramine, rugeka zafaramine, regri tra'aramine, ");
INSERT INTO kbq_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","hagi ana seli mono nomofoma rufite'zana, ve sipisipimofo akruteti eri korankre hu'za tro hu'naza tavravene, hage rimpi bulimakaomofo akruteti tro hu'naza tavravene, ruotage'ma hu'nefinka rente'za hunaragi tavravene, ");
INSERT INTO kbq_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kasegema ante vogisine ana vogisima erisga huno vu azotarerene, ana vogisimofo avaza'agu'ma asunku trarema nehaza avaza'ane, ");
INSERT INTO kbq_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Anumzamofo avure'ma bretima ante itane, ana itare'ma eri'zama eri'zantamine, Anumzamofo avure'ma ante bretine, ");
INSERT INTO kbq_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","goliretike tro hu tavi zotane, ana tavi azotare'ma tavi'ma rekru hunte'ama tro hunteterema higeno me' fatgoma hu'nea zane, ana tavi azotare'ma eri'zama eri zantamine, tavi'ma rekruma hu masavene, ");
INSERT INTO kbq_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","golire tro hu'nea kresramna vu itane, tagino frenenteno Anumzamofo zanema huno huhamprinte masavene, knare mnanentake toki'ma hu' tanefa'ene, Anumzamofo seli mono nomofo kahante hanti tavravene, ");
INSERT INTO kbq_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bronsireti tro hu'naza kresramnavu itane, anaga tevema hugre'afima rekamrente zana bronsireti rama'a karami hagente'zana strenane, erisga huno vu azotararene, ana itare'ma eri'zama erizantamina bronsire tro nehu'za zuompane, aga'ane, ");
INSERT INTO kbq_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ana seli mono no kumamofo kegina hugagi tavraveramine, retrure zafarmine, regri trazmine, ana kumapima ufre kahante tafinte tavravene, renteno avazuhumpi hu nofitamine, ana nofi'ma avazuhumpi huno rente zotaramine, maka ana seli mono nompima eri'zama eri zantamine, ");
INSERT INTO kbq_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","pristi vahe'mo'za antani'ne'za ruotage hu'nefinka eri'za erisaza ruotage kukenaramine, pristi ne' Aroni ruotage kukenaramine, ne'mofavre'aramimo'za antanine'za pristi eri'zama erisaza kukenane tro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ana maka eri'zana Anumzamo'ma Mosese'ma hunte'nea kante ante'za Israeli vahe'mo'za eri vagare'naze. ");
INSERT INTO kbq_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mosese'ma ana maka eri'zama eri'naza eri'zama keana Anumzamo'ma hu'nea kante ante'za eri vagarazageno, Mosese'a asomu kea huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Nagranema atruma hanaza seli mono nona, kasefa kafumofo ese ikamofona ese zage knare azeri otiho. ");
INSERT INTO kbq_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Huhagerafi huvempa kasege vogisia anampinka nentetma, tavravenuti hunargintenkeno agu'afi meno. ");
INSERT INTO kbq_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Anampinka ita erinka ome nentenka, ana itare'ma ante zantamina erinka ome antese nehunka, tavi'ma rekru hunte zota erinka ome nentenka, ana zotarera tavitamima rekru hunte'a retro huntetere huo. ");
INSERT INTO kbq_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Hanki mnanentake zama kre mnavu golire ita Anumzane hagerafi kasege ante vokisimofo avuga'a nentetma, ana seli mono nomofo kahantera tavravea renteho. ");
INSERT INTO kbq_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Anumzane atruhu seli mono nomofo avuga kahantera, kresramna vu ita nentenka, ");
INSERT INTO kbq_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","bronsireti'ma ra tifre zuompa tro'ma hu'nazana, Anumzane atruhu seli mono nomofone, Kresramanama vu itamofo amu'nompi nentenka tina ana zuompafina taginto. ");
INSERT INTO kbq_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Hagi anante ana seli mono nomofo megi'a kumara tavrave kegina huganeginka, ana megi'a kumamofo kahantera tavravea hantinto. ");
INSERT INTO kbq_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ana hutenka, tagino frenteno Anumzamofo zanema huno huhamprinte masave erinka ana seli mono none, ana seli mono nomofo agu'afima me'nea maka zantamina ana masavea taginka frenezmantenka, Anumzamofo zantamine hunka huhamprinezmantenka zamazeri ruotage huge'za ana seli mono none, ana seli mono nompima me'nea maka zantmimo'za me ruotage hu'za megahaze. ");
INSERT INTO kbq_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Anazanke hunka Kresramanama vu itane ana itare'ma eri'zama eri zantaminena ana masave taginka frenezmantenka, Anumzamofo zantamine hunka huhamprizmantenka zamazeri ruotage hugeno, ana itamo'a me ruotage huno meno. ");
INSERT INTO kbq_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Anazanke hunka tifre ra zuompane aga'anena ana masaveretike taginka freneznantenka, Anumzamofo zane hunka huhamprintegeno meno. ");
INSERT INTO kbq_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Hagi anante Aronine, ne' mofavrermima'anena zmavrenka Anumzane atru hu seli mono nomofo kahante tina frezmanto. ");
INSERT INTO kbq_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Anante Aronina ruotage hu'nea pristi kukena eri hankrentenka, huhamprinte masave taginka frenentenka, Anumzamofo nere hunka huhamprintenka azeri ruotage hugeno mani ruotage huno mani'neno, Nagri pristi eri'zana erigahie. ");
INSERT INTO kbq_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","E'ina nehunka Aronina ne' mofavrermima'a zmavrenka agu'afi avate antani kukena eri hankre zmanto. ");
INSERT INTO kbq_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nezmafama hunte'nana kna hunka ana masave taginka frezmantenka, huhampri zmantege'za Nagri pristi eri'zana eriho. E'i ana zama hanana zamo'a henkama ana nagapinti fore hunante anante hu'za vanaza vahe'mo'za pristi eri'za, eri'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Hagi Mosese'a Anumzamo'ma huoma huno'ma hunte'nea kante anteno, ana maka eri'zana eri'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hagi namba 2 kafumofona, ese ikamofo ese zage knare Anumzamofo seli mono nona azeri oti'za ki'naze. ");
INSERT INTO kbq_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosese'a ana seli mono noma azeri oti'nea regri zafarmimofo tra'zmia anteteno, retrure zafaramina regrinteteno, nomofo asoparegama rugekahu zafaramina erirusi hunteteno, no zaferina'a azeri retrurene. ");
INSERT INTO kbq_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Hagi Mosesi'a Ra Anumzamo'ma huoma huno hunte'nea kante anteno, seria eri atareno seli mono nona refiteteno, ana agofetura mago anteno refite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Hagi anante Mosese'a 10ni'a kasegema me'nea havererena erino Anumzane huhagerafi vogisimofo agu'afi anteteno, ana vogisima erisga huno vu azota zafararena ana vogisire me'nea riniramimpi vazinteteno, ana vogisimofo avaza'a asunku zamofo trarema nehaza avaza'a erino ana vogisia runkanire'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ana huteno Ra Anumzamo'ma huo huno'ma hunte'nea kante anteno Mosese'a vogisia erino ana seli mono nompinka ome nenteno, hunaragi tavrave hantintegeno ana vogisia azeri agu'a ate'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ra Anumzane atruhu seli mono nompima ana hunaragi tavravemofo megi'a noti kaziga ita erino ome nenteno, ");
INSERT INTO kbq_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ra Anumzamo'ma huo huno'ma hunte'nea kante anteno Mosese'a Ra Anumzamofo avure'ma ante bretia ana itare ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Anante seli mono nompima bretima ante itamofo kantu sauti kaziga, tavi'ma rekru hunte zota erino ome nenteno, ");
INSERT INTO kbq_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ra Anumzamo'ma huo huno'ma hunte'nea kante anteno, Mosese'a tavi'ma rekru hunte zotama ra Anumzamofo avure me'nere tavitamina rekru hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ra Anumzane atruhu' seli mono nompinka hunaragi tavravemofo avuga golireti'ma tro hu'nea ita erino ome anteteno. ");
INSERT INTO kbq_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ra Anumzamo'ma huo huno'ma hunte'nea kante anteno Mosese'a, ana itarera mnanentake zana kre mana vu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Anante ana seli mono nomofo kahantera tavravea rente'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ana huteno kre fnanehu ofama kre ita Ra Anumzane atruhu seli mono nomofo kahante anteno ana itare Ra Anumzamo'ma huo huno'ma hunte'nea kante anteno Mosese'a kre fanene hu ofane witi ofanena hu'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Anante tifre ra zuompa Ra Anumzane atruhu seli mono none kresramnama vu' itamofo amu'noznifi nenteno anampina tima fre'zana taginte'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ana hutege'za Mosese ene Aroni ene Aroni ne' mofavrermima'anena ana timpi zmazane zmaganena sese hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ra Anumzane atruhu seli mono nompima ufrege Kresramana vu itare'ma vu tavao hunaku'ma hanu'za, Ra Anumzamo'ma huo huno'ma Mosesema hunte'nea kante ante'za zamagra ana timpi tina fregahaze. ");
INSERT INTO kbq_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Anante Mosese'a ana seli mono nomofo kuma kegina tavravea hantintegagi vagareteno ana kuma'mofo kahante tavravea hantinte'ne. E'inahu kna huno ana maka eri'zana eri vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ana hutegeno hampomo ana atruhu seli mono nona eme refitegeno, Ra Anumzamofo hanavenentake msaa'amo'a ana seli mono nona eme avite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","E'ina higeno Mosese'a ana seli mono nompina uofregeno, Anumzamofo hanavenentake masa'amo'a avite'ne. ");
INSERT INTO kbq_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israeli vahe'mo'za negageno seli mono noma eme refite'nea hampomo'ma atreno marerige'za ana seli mono nona tagana vazi'za renamagi'za e'neri'za, ana hampomo'ma virega avariri'za vutere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Hianagi ana hampomo seli mono noma refiteteno'ma mege'za, Israeli vahe'mo'za anama mani'naza kumara atre'za ovu mani'nazageno, ana hampomo'ma vige'za avariri'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ra Anumzamofo hampomo'a msarera seli mono nona refiteno me'negeno, hanima higeno'a, ana hampomo'a tevenefa higeno, ana maka Israeli vahe'mo'za ke'naze. Israeli vahe'mo'zama ana mika kama vazafina e'i ana hu'za fore huno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ra Anumzamo'a atruhu seli nompinti Mosesenkura ke huno anage hu'ne, ");
INSERT INTO kbq_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Israeli vahe'mokizmia zamasamige'za Ra Anumzamo'nare'ma ofama kresramana vunante'naku hanu'za, kegavama nehania sipisipio meme afu kevufinti avreno kresramana vunanteno. ");
INSERT INTO kbq_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kre fanane hu ofama hu'zama bulimakao afu'zamifinti'ma avre'za esu'za, ve bulimakao afu afuhe afahe osu'nesia su'za avre'za atru'ma nehaza seli mono nomofo kafante omentesageno, Ra Anumzamo'a antahimigahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Agra ana ofama hania bulimakao afu'mofo asenire kumi'amofo nonama hanigu azana antenkeno, Ra Anumzamo'a antahinemino kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Hagi ana ve bulimakao anenta afura Ra Anumzamofo avuga ananke akafritesigeno, Aroni mofavremo'za pristi eri'zama e'nerizamo'za korama'a tagi'za vu'za seli mono nomofo avugama me'nea kresramana vu itare ome rutri rutri hugagiho. ");
INSERT INTO kbq_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hagi anamo'a ana bulimakaomofona akru'a kararu vaziteno, avufga'a tagahu osi osi hutesigeno, ");
INSERT INTO kbq_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aroni mofavre naga pristi eri'zama e'nerizamo'za kresramana vu itarera tevea erise hu'za agofetura ante fatgo hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Anantera Aroni mofavreramima pristi eri'zama e'nerizamo'za kresramana vu itare'ma tevema hanavazisare, tagahu osi osi'ma hanaza ame'ane, aseni'ane, afova'anena, eri antefatgo hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Agazama'ane agusu'agesezama'a timpi sese hutesigeno, pristi vahe'mo'a kre sramana vu itarera ome kresageno mana'amo'a marerinkeno, Ra Anumzamo'a knare mana nentahino muse hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Hagi sipisipio meme afu kevu'afinti'ma kresramana vunaku'ma hanimo'a, afuhe afahe'ma osu'nesia ve afu avregahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kresramana vu itamofona noti kaziga Ra Anumzamofo avuga ana afura anankena akafrisigeno, Aroni mofavreramima pristi eri'zama e'nerizamo'za korama'a tagi'za kresramna vu itamofona rutri tri hugagigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Agra tagahu osi osi hutenkeno, pristi vahe'mo'a erino kresramana vu itamofona agofetu tevema nerea trate omerintese huteno, anazanke huno aseni'ane afova'anena erino kresramana vu itare ome kregahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Agiazama'ane agusu agese'zama'a timpi sese hutesigeno, pristi vahe'mo'a kresramana vu itarera mika ome kresageno, manamo'a marerinkeno, Ra Anumzamo'a knare mana nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Hagi Ra Anumzamofonte'ma kre fanene hu ofama hu'zama namaramima avreno'ma esuno'a, maho namao kugofa kna namafinti, mago avreno kresramana vu itarera egahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Hagi pristi vahe'mo'a kresramna vu itare ana nama avreno vuteno, ananke eri vamagino eri akafriteno kresramana vu itare kresramana nevuno, korama'a erino kresramana vu itamofo asoparega tagitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ana namamofona azoka'ane, azanku'anena kresramana vu itamofona zage hanati kaziga tanefama katenetrazafi atregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Hagi pristi ne'mo'a ana namamofona agekonare azeri'neno eri taganavazino erizuzu huteno, kresramana vu itare'ma tevema nerefi mika, ome kresigeno mana'a marerinkeno, Ra Anumzamo'a knare mana nentahino musena hugahiankino, e'i ana ofa tevefi kre fanene hu ofe. ");
INSERT INTO kbq_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Mago'mo'ma Ra Anumzamofonte'ma witi ofa'ma hunaku'ma erino esuno'a kaneno eri osi huteno, erino eno. Anampina masavena taginenteno frenkinsensi nehaza mnanentake'zana erinteno, ");
INSERT INTO kbq_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","erino Aroni mofavreramima pristi eri'zama e'neriza vahete vino. Ana masavene frenkinsensinema eri haviama hu'nea witifintira mago aza huno, kresramana vu itare ome kresigeno Ra Anumzamo'a mana'a nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Hagi mago'ama mesia witia Aronine mofavre'amokizmi su'a megahie. Anama Ra Anumzamofonte'ma kre sramana vunente'za atresazama'amo'a ruotagetfaza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Avenifima kre'nesaza bretima ofama hunaku'ma erita esazana, zisti onte breti masaventeti eri havia huno kre'ne'nia kekio, hagege bisketire masave fre'ne'nia erita eho. ");
INSERT INTO kbq_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kuta fraimpenifima kre'ne'nia witireti'ma ofama hunaku'ma hanutma, kaneosi'ma hu'nesia flaua'ene olivi masavenena erihavia nehuta, anampina zistia onteho. ");
INSERT INTO kbq_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Hagi ana bretia goli osi osi huteta, anampina masave taginteho. E'i witi ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kresramana vu witi ofama kre hagage hu kavofima kresazana, kaneosi osi'ma hu'nesia flauateti masavene eri havia huteta kregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hagi ama ana zantetima witi ofama kreta erita Ra Anumzamofonte'ma esuta, pristi vahe ome aminkeno, erino kresramna vu itarera vino. ");
INSERT INTO kbq_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ana bretifintira pristi vahe'mo'za huvame hu'za mago zamaza hu'za eri'za kre manavu itare tevefi kresageno, Ra Anumzamo'a mana'a nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Hagi anama Ra Anumzamofonte'ma tevefima kresramana vunente'za atresaza bretimo'a, ruotgetfa hu'neankino Aronine mofavre'amokizmi su'a megahie. ");
INSERT INTO kbq_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Kresramana vu witima ofama erita vanazana, zistia onteho, na'ankure zistima antege tumerima antege'ma hu'nesia witiretira tevefina kreta Ra Anumzamofona ofa huontegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Hozafinti'ma e'sema ne'zama nenama hania ofama hanutma, zistine tumerinena amne tamagra erita Ra Anumzamofonte egahazanagi, e'i ana ofa kremnavu itarera Ra Anumzamo muse hanie huta onkregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Miko ofama hanaza witifina hagea antenageno, e'i ana zamo'a Anumzamo'enema huhagerafi huvempa ke'ma hu'naza kemofo huramagesa nehanigetma, tamagera okanigahazanki maka ofama hanaza witifina hagea atintegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ana nehuta ese'ma nena hania witi raga Ra Anumzamofonte'ma ofa huku'ma erita esutma, refuzafupeta eritma ege' tevefi kre hagage hutma erita egahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ana ne'zampina olivi masavene, mnanentake'za insensi antegahazankino, e'i witi ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ana Witima kne'za masavene mnanentake'za insensinema eri haviama hunte'nazafinti osi'a eri'za, Pristi vahe'mo'za knare manavu ofa Anumzamofontega huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Hagi mago'mo'ma rimpa fru ofama bulimakao afu kevu'afintima hunaku'ma hanuno'a, afuhe afahe'ma osu'nesia ve bulimakao afuro, a' bulimaka afura avreno Ra Anumzamofo avuga vino. ");
INSERT INTO kbq_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Agra ana ofama hunaku'ma hania afu'mofo asenire azana anteteno, atrumahu seli nomofo kafante anankena akafrinkeno, Aroni mofavre'mo'zama pristi eri'zama e'nerizamo'za korama'a tagi'za, kresramna vu itamofona rutri tri hugagigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Anumzanema rimpa fru ofama hania afu'mofona, miko afova'ane, rimpama eri anovazi'nea afovane, ");
INSERT INTO kbq_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","tare kreso'ane anante'ma eri anoma vazi'nea afova'ane, asumna'anena eritagatino erino, ");
INSERT INTO kbq_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aroni mofavre'ramima Pristi eri'zama e'neri'za naga eme zaminige'za kresramna vu itare'ma tevema hanavazi'naza agofetu, kre fananehu ofane kresramana vanageno, Ra Anumzamo'a sramna mana nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Hianagi anazanke huno Anumzanema arimpa fru ofama mago'mo'ma sipisipi kevu'afinti'ma hunaku'ma hanuno'a, ve sipisipi afuro a' sipisipi afu'ma afuhe afahe'ma osu'nesia su'za azerino Ra Anumzamofontega ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Hagi sipisipi afu anenta'ma ofa huno aminaku'ma hanuno'a, avreno Ra Anumzamofo avuga vino. ");
INSERT INTO kbq_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Agra ana ofama hunaku'ma avrenoma esia sipisipi afumofo asenire azana anteteno, atrumahu seli nomofo avuga anankena tagahinkeno, Aroni ne' mofavre'mo'za pristi eri'zama e'neri'zamo'za korama'a tagi'za kresramna vu itamofona maka asoparega rutri tri hugagigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Rimpa fru ofama hunaku'ma hania afuteti'ma erisia, afova'ane risona agu'sama, amagenafinti ahe futagi'ane, rimpama eri anovazi'nea afova'ane, ana maka afova'ane, ");
INSERT INTO kbq_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","tarega kreso'ane, anante'ma erino vazi'nea afova'ane, asumna'ane, kreso'anena ana maka tagatintenigeno, ");
INSERT INTO kbq_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","pristi vahe'mo'za eri'za kresramna vu itare ne'zama ofama nehazaza hu'za Ra Anumzamofontega kresramana vuntegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Hagi meme afu'ma azerino ome ofama hunaku'ma hanuno'a, agra Ra Anumzamofo avuga erino vuteno, ");
INSERT INTO kbq_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","atru'ma hu seli nomofo avuga agra ana ofama hu'naku'ma azerino esia meme afu'mofo asenire azana anteteno, anankena akafrinkeno, Aroni ne' mofavre'zamo'zama pristi eri'zama e'neri'zamo'za korama'a tagi'za erite'za kresramna vu itamofo maka asoparega rutri tri hugagigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ana afupintira arimpama erinovazi'nea afovane, maka agusu agesezama'anena, tevefi negreno, ");
INSERT INTO kbq_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","tare kreso'ane, erinoma vazi'nea afovane, asumnane, eri tagatino erino, ");
INSERT INTO kbq_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Pristi vahe amisigeno, ne'za ofama hiaza huno kresramna vu itare Ra Anumzamofontega tevefi kresramna vuntenigeno, Ra Anumzamo'a knare sramna nentahino muse hugahiankino, miko afova'amo'a Ra Anumzamofo su'a megahie. ");
INSERT INTO kbq_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ama tra kea mevava trake me'nena, tamagri'ene ana miko fore hunante anante hu'za esaza vahe'mo'za, magore hu'za agusa'ane, korama'anena onetfa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Hagi Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Mago vahe'mo'ma mago'azama hanifima, ana hugahuema huno ontahi'neno Ra Anumzamo'ma osihoma huno'ma hu'neazama hania kumimofonkura amanage hunka zamasamio. ");
INSERT INTO kbq_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ugagota pristi ne'mo'ma kumi'ma haniana, miko vahe'mokizmi zamazeri haviza hugahie. Ana hugahiankino nagra mago agaho ve bulimakao afu afuhe afahe'ma osu'nesia avreno, agrama hu'nenia kumitera kumi ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Hagi ana bulimakao afura avreno atruhu seli nomofo ufre kafante Ra Anumzamofo avuga ome anteno, azana asenire anteteno, anankena akafrigahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Anama hutena ugagota pristi ne'mo mago'a korana erino atruhu seli nompi ufregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Hagi ana korampi azankoa reteno, Ra Anumzamofo avuga hunaragintegeno ruotage'ma hu'nea tavravemofo avuga, 7ni'a zupa rutri tri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Hagi ana pristi ne'mo'a, mago'a korana tagino atrumahu seli nompi Ra Anumzamofo avuga mnanentake'za kresramana vu itamofo pazivetaminte ome frentegahie. Hagi mago'a mesia korana, atru'ma hu seli nomofo avuga me'nea kresramana vu itamofo agafi miko tagi atregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Hagi kumite'ma ofama hunaku'ma hania bulimakaomofona mika afovane, arimpama eri anovazi'nea afova'ane, ");
INSERT INTO kbq_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","tarega kreso'ane, eri anoma vazi'nea afovane asumnane, ana mika kreso'anena eri tagatitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ana huteno bulimakao afovareti'ma arimpa fru ofama kresramna neviankna huno ugagota Pristi ne'mo'a tevefi kre fanene hu ofama nehaza itare kresramna vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Hianagi mika akru'agi, ame'agi amumazina'ane, azonane aseni'ane agusu'agese zama'ane, ");
INSERT INTO kbq_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","maka erino kuma'mofo fegi'a agruma hu'nea kumapi tanefa'ma ome netrazafi, teve hanavazino kregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Mika Israeli vahe'mo'zama Ra Anumzamofo kemo'ma i'oma huno'ma hu'nesia zama mago'azama hanaregama hantagama hu'za hanu'za kumire hu'za ontahisazanagi, zamagra kumi hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Zamagrama antahisazama kumi hu'nonema hanu'za, mago ve agaho bulimakao afu avre'za kumizamiguma kresramana vu'zana, Anumzanema atru'mahu seli nomofo avuga ome anteho. ");
INSERT INTO kbq_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Hagi kva vahe'zmimo'za ana bulimakao afu'mofo asenire zamazana antetenageno, Ra Anumzamofo avuga ana bulimakaona anankena akafriho. ");
INSERT INTO kbq_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hagi ana hutesageno ugagota pristi ne'mo korama'a erino atrumahu seli nompi ufreno, ");
INSERT INTO kbq_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","azankoa ana korampi reteno, tavaravema Ra Anumzamofo avugama hantintegeno me'nerega 7ni'a zupa rutri tri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Hagi ana pristi ne'mo'a, mago'a korana tagino atrumahu seli nompi Ra Anumzamofo avuga mnanentake'za kresramana vu itamofo pazivetaminte ome frentegahie. Hagi mesia korana, atrumahu seli nomofo avugama me'nea kresramna vu itamofo agafi miko tagitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Hagi agra miko afova'a tagatino kresramana vu itare negreno, ");
INSERT INTO kbq_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","kumi'mofo ofama hu'neaza huno, ugagota pristi ne'mo ana ve bulimakao erino, mika vahe'mokizmi kumizmimofo nona huno kresramna vanigeno, Ra Anumzamo'a kumizmia atrezmantegahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Anantera ana bulimakaona erino kumamofo fegi'a ese bulimakaoma hu'neaza huno ome kregahie. E'i mika vahe'mokizmi kumi atrezmante ofe huno kresramana vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Hagi Israeli kva vahe'mo mago'azama hanafima hantga huno Ra Anumzamo'ma osuoma hu'nea zama e'i kumire huno ontahi'nenoma hanuno'a, kumi hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Hagi kumi hu'noe huno'ma antahisuno'a, kumi'aguma kresramana vu'zana ve meme afu afuhe afahe osu'nenia avreno ofama hu'zana vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ana ve meme afu'mofo asenire azana anteteno, Ra Anumzamofo avugama me'nea kresramana vu itamofo avuga, anankena akafrigahie. E'i kumi'ma hu'nea zamofonte ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Hagi kumite kresramana vu mememofo korana pristi ne'mo'a azankoreti reno Ra Anumzamofo avuga kresramana vu itare'ma me'nea pazivete ome frentegahie. Hagi mesia korana ana kresramna vu itamofo agafi miko tagitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Arimpa fru ofama kresramna vu'neankna huno afova'a miko kre vagareno. E'ina'ma pristi ne'mo'ma hanuno'a, ana ne'mofo kumi'mofo nonahina kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ra Anumzamo'ma osihoma huno hu'nea ke'ma Israeli vahepinti'ma mago'mo'ma mago'azama hanafima, e'i kumire huno ontahi'neno ana ke'ma runetagreno, kumira osu'noe huno antahigahianagi agra kumi hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Hagi agrama kumi hu'noema huno antahisuno'a, kumi'ma hu'nea zankura a' meme afuma afuhe afahe'ma osu'nesia avreno eno, kumi'arera ofa eme hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Hagi anama kumite'ma kresramna vunaku'ma hania meme afu'mofo asenire azana anteteno, kresramna vu afu'ma nehazare anankena akafrigahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Pristi vahe'mo'a azankoa ana korampi reteno, kresramana vu itare me'nea pazivetaminte ome frenenteno, mago'a mesia korana kresramana vu itamofo agafi mika tagitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Anantera arimpa fru ofama hu'neankna huno, maka afova tagatitregahie. Ana hanigeno pristi vahe'mo'za ana afova'a eri'za kresranma vu itare vu'za, Ra Anumzamofonte ome Kresramana vanageno, knare sramna nentahino muse hugahie. E'ina'ma pristi ne'mo'ma hanigeno'a, ana ne'mofo kumi'amofo nona hinkeno, Ra Anumzamo'a kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Hianagi kumi'mofo ofama hunaku'ma sipisipi afu'ma avreno'ma esuno'a, a' sipisipi afu'ma afuhe afahe'ma osu'nesia su'za avreno eno, ");
INSERT INTO kbq_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ana sipisipi afu'mofo asenire azana anteteno, kresramna vu ofamahu afu'ma zmanankema nekafrizare, anankena akafrigahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Pristi ne'mo'a azankore mago'a korana reteno, kresramana vu itare me'nea pazivetaminte ome frenenteno, mesia korana kresramana vu itamofo agafi maka tagitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ana'ma hutenuno'a arimpa fru ofama hu'neankna huno, maka afova tagatitregahie. Ana hanigeno pristi vahe'mo'za ana afova eri'za kresranma vu itare vu'za, Ra Anumzamofonte ome kresramna vuntegahaze. E'ina'ma pristi ne'mo'ma hanigeno'a, anama kumi'ma hu'nea ne'mofo kumi'amofo nona huno krenkeno, Ra Anumzamo'a kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Mago'mo'ma keno antahino hu'nesia zanku'ma huama hinogu ke refako hu trateti'ma antahigesigeno huama'ma osaniana, agra kefoza hugahiankino, anazamofo kna'a agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Hagi iza'o agruma osu'nesia zagama avako huge, agruma osu'nesia zagagafamo'ma fri'nesia avufgare'ma avako huge, fri'nenia afu'mofo avufgare avako huge, asguregatima regraroheno vanoma nehania zagaramima fri'nenigeno avako'ma haniana, agrira azeri pehena hugahiankino, kna'a agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Huge vahe'mofo azeri pehenama nehiazama antahino keno osu'neno avako'ma huteno, henkama antahino keno'ma haniana, agrira azeri pehena hanigeno, ana kefozamofo kna'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Hagi mago vahe'mo'ma agesa antahi so'e osu'neno, ame'ama huno knare'zantero havizantero huvempama huteno, henkama ke'amama haniana, haviza hugahiankino, agra'a kna'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Hanki iza'o ama ana avu'ava'ma nehuno haviza hu'noe hanuno'a, agra kumi hu'noe huno huama nehuno, ");
INSERT INTO kbq_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","kumi'ma hia zamofo nona'a, afuzaga'afinti a' sipisipio, a' meme afuro avreno Ra Anumzamofontera vanigeno, pristi vahe'mo'a agri kumitera nona huno kresramna vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Hagi agrama kumi'amofo nonama huno kresramna vu sipisipi afu'ma avrega'ma osanuno'a, agra tare maho namao, tare kugofa nama kumi'amofo nona huno Ra Anumzamofonte avreno vuno magora kumi'are ome Kresramana nevuno, magora tevefima krefanene hu ofa ome hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Agra pristi vahete tare namararena avreno vanigeno, ese nama kumi'agu huno kresramna vugahie. Hagi ana namamofona ananke erivamagasigeno frigahianagi, anankena tgahu otregahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Hagi anama kumite'ma ofama hania namamofo korana, mago'a erino kresramana vu itamofo asoparega, rutri tri hugahie. Hagi mesia korana ana kresramna vu itamofo agafi tagitregahie. E'i kumi'ma hu'nea zamofonku huno hu ofe. ");
INSERT INTO kbq_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hagi tra kemo'ma hu'nea kante anteno, mago nama kre fananehu ofa hanigeno, pristi vahe'mo erino tevefi ana ne'mofo kumi nona huno, kresramna vanigeno Ra Anumzamo'a kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Hagi agrama tare maho namao, tare kugofa nama erino ega'ma osnuno'a, kumi'agu nona huno kresramna vu'zana, 10ni'a kiloma knare hu'nenia flauama ante'nenifintira, mago kilo erino kresramna vino. Hagi agra ana flauapina masavena ontege, mnanentake'zana onteno. Na'ankure e'i kumite'ma hu ofe. ");
INSERT INTO kbq_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Hagi pristi vahete erino vanigeno, ana flauapinti huhamprino osi'a mago aza huno Ra Anumzamofontega tevefi kre mana vugahie. E'i kumite'ma kremana vu ofe. ");
INSERT INTO kbq_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","E'inahukna kanteke kumi'ma hu'nesia zantera, pristi vahe'mo'a azahuno kumi'amofo nona huno kre mnana vanigeno, Ra Anumzamo'a ana ne'mofo kumi'a atrentegahie. Hagi mago'a mesiama'a, witi ofama hu'neaza huno pristi vahe'mo erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Hagi anantera Ra Anumzamo'a Mosesena asmino, ");
INSERT INTO kbq_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Mago vahe'mo'ma Ra Anumzamofo ruotage zama hanifima hantagama haniana, e'i kumi hugahiankino, ve sipisipi anentama afuhe afahe'ma osu'nesia avreniana, zago'amo'a seli mono nompi mago silva zagomofo kna'a avamente kumi'ma hu'nerera avreno egahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Mago vahe'mo'ma Ra Anumzamofonte'ma ruotage'ma hu'nea zama hanifima hantagama haniana, 5fu'a zama eri havizama hu'nesuno'a, ana 5fu'a zana ami'neno, magora ante agofetu huno 6si'a pristi vahera aminkeno, azahuno kumi'amofo nona ana sipisipia kresramana vanigeno, Ra Anumzamo'a kumi'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ra Anumzamofo tra kemo'ma osuo hu'nenia kema rutrageno kumi'ma haniana, agra antahino keno osu'neno hugahianagi, agra haviza hugahiankino, kna'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Hagi kumi'ma hu'nea zankura afu zaga'afinti pristi vahe'mo'ma hu'nenia avamente mago ve sipisipia afuhe afahe'ma osu'nenia avreno vinkeno, pristi vahe'mo'a aza huno kumi'amofo nona huno kresramna vinkino, ontahinenoma hu'nenia kumira, Ra Anumzamo'a anamofona atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","E'i Ra Anumzamofo avufima havizama hu'nea zante hania ofagino, kumi ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ra Anumzamo'a amanage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Mago'mo'ma Ra Anumzamofo kema amagema ante fatgo nosuno, tava'oma'are'ma nemanisimofoma mago'azama kegava hunantegahie huno antahimino ami'nenkeno kegava huso'e huontege, musufasege revatga huno omnene'nia miza agima ahentege, ");
INSERT INTO kbq_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","fanane hu'ne'nia zama hakeno eri'nenoma havigema huno onketfa hu'noe huge, eme kamigahue huno eri'ne'nia zama eme nomino, mago'a anahukna kumi'ma nehuno, ");
INSERT INTO kbq_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","haviza hu'noe huno antahi'amama hanuno'a, agra kumzafama se'nenia zano, kegava hunanto huno antahimino ami'neniaza eri havia hu'neniano, havige huno eri'nenia zano, fanane hu'nesiaza eri'nesia zantera ete nemino, ");
INSERT INTO kbq_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","havige'ma huno huvempa hu'noma mago'zama eri'nenia kumite'enena, ofama hunaku'ma hania knarera 5fu'a zama eri'nenuno'a ana 5fu'a ami'neno, magora ante agofetu hinkeno, 6si'a hina ana zamofo venafona amino. ");
INSERT INTO kbq_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Hagi ana kumi'ma hu'nea zante'ma ofa'ma Ra Anumzamofonte'ma hunaku'ma hanuno'a, kumi'amofo avamente afu kevu'afinti ve sipisipia afuhe afahe'ma osu'nesia avreno pristi vahete vina, ");
INSERT INTO kbq_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","pristi vahe'mo'a aza huno ana sipisipia erino kumi'amofo nona Ra Anumzamofo avuga ofa hanigeno, kumi'a apasentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aronine mofavre naga'a amana hiho hunka zamasamio, kre fananema hu ofama hanaza zamofo tra kea amanahu me'ne, ana ofamo'a kresramana vu itare tevefi me'nenkeno, ana tevemo'a tevava nehinkeno vuno masa hino. ");
INSERT INTO kbq_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Hagi pristi vahe'mo'a efeke za'za kukena nehuno, agu'a avufa avatera efeke kukena nehuno, kresramna vanigeno tevemo'ma tevagaresia tanefara erino, ana itamofona asoparega ome anteno. ");
INSERT INTO kbq_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hagi anantera anama antani'nea kukena hatetreteno, ru kukena nentanino ana tanefara kuma'mofo fegi'a avusese huno agruma hu'ne hu'zama nehazafi ome atregahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kresramna vu itare'ma nerea tevemo'a asura osuno, tevava hino. Maka nanterana pristi vahe'mo'a teve erinegreno, tevefima kre fananene hu ofa nehuno, afova'a rimpafru ofa kresramna vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Kresramna vu itarera, tevemo'a tevava nehuno asura osino. ");
INSERT INTO kbq_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hanki ama'i witi ofama kre mnavu zamofo tra ke. Aroni ne' mofavre zagamo'za Ra Anumzamofo avuga kremna vu itamofo avuga eri'za egahaze. ");
INSERT INTO kbq_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Pristi vahe'mo'a flaua'ene masavene mnanentake insensine eri havia huteno anampinti hu avame huno mago aza huno kresramna vu itare, kre'nigeno sramna'amo'a marerinkeno, Ra Anumzamo'a knare mana nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kresramna nevu'za atresazama'a Aroni'ene mofavre'amo'za negahaze. Hagi zisti onte kekia atru'ma hu seli nonkumapi ruotagema hu'nefinke negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ana flauapina zistia anteta onkreho, nagri'ma Ra Anumzamona kremna vu nantesafinti zamagrama nesazama'a zami'noe. Kumi'mofo ofamo'a, kefozamafo ofamo'ma hu'neankna huno ruotagetfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aronimpinti fore'ma hu'nesaza vene'ne'amozage ana ne'zana negahaze. Zamagra Ra Anumzamofonte'ma tevefima kremna vunte'nafinti'ma mesiama'a, e'i zamagri ne'za megahiankino, e'i ana zamo'a kasege me'nenkeno henkama fore'ma hu anante anante'ma hu'za esaza vahe'mo'zanena negahaze. Ruotage'ma hu'nesia zama avako'ma hanimo'a ruotage hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ra Anumzamo'a amanage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aroni mofavre naga'mo'za pristi eri'zama eri'nazegu'ma masavema frezmante'za huhampri zmantesaza zupa, Ra Anumzamofontera ama'na kremna vu'za eri'za eho, knarema hu'ne'ni 10ni'a kilo flauapintira mago kilo refako hu'za maka zupama witi kremna nevazankna hu'za, amu'nompinti refako hu'za nanterana negre'za, kinaga mago'a kregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ana ne'zama retro'ma hanazana heru so'e huteta, ana ne'zama kre sazana kuta fraipanire masavena tagita kreteta ana ne'zana erita Ra Anumzamofo avuga ome golita witi ofa krenkeno knare mana nentahino, Ra Anumzamo'a musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Nefa noma erino pristi ne'ma manigahie huno'ma huhamprintesia ne'mo'a Ra Anumzamofontera ofa hugahie. E'i Ra Anumzamo'ma erisiama'agi krenkeno tevefi tevagareno. Ama anahukna avu'avazamo'a trake me'nena fore hu anante anante'ma hanaza vahe'mo'za amage antevava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Pristi vahe'mo'zama miko witi ofama hanafintira, magore hu'za one'za, miko tevefi krenkeno tevagareno. ");
INSERT INTO kbq_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aronine ne' mofavre naga'a amanage hunka zamasamio, kumite'ma kresramna vu zamofo tra kea ama'ne, kresramna vu afu'ma avreno'ma esuno'a, Ra Anumzamofo avuga kresramna vu afu'ma zamanakema taga nehazafi anankena eme tagahinkeno, ana zamo'a ruotagetfa huno Nagri su'a megahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ana afu'ma kresramana vania pristi ne'mo, ana afu'ma kresramna vanifintira, mago'a amne negahie. Ana ne'zama nesiana, ruotage'ma hu'nefi atruma nehaza seli nomofo kumapinke negahie. ");
INSERT INTO kbq_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Iza'o anama kresramna vania afute'ma avako'ma hanimo'a, agra ruotage hugahie. Hagi ana afu'mofo koramo'ma ruotage'ma hu'nefima za'za kukenare'ma akamrenkeno'a, anampinke sesera hino. ");
INSERT INTO kbq_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Hagi pristi ne'mo'ma ana afu'ma mopa kavofima kresuno'a, ana kavo'a rurako hugahie. Hianagi bronsire'ma tro'ma hu'nesaza kavofima kresuno'a, ana kavoa vazagateno sese hino. ");
INSERT INTO kbq_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ana ne'zamo'a ruotagetfa hu'neankino, pristi naganofipintira venene'amozage ana ne'zana negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Hianagi kumi'mofo nona huno ofama hu'naku korama'a erino atru'ma nehaza seli nompima ruotage'ma hu'nefinkama vania afu'mofo ame'a mago'mo'a oneno. Hagi ana miko kre fanane hino. ");
INSERT INTO kbq_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ama'i kefozama hu'nea zamofonku kresramna vu'zamofo trakegino, ruotagetfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kefozama hu'nesire'ma erino esia ofa, tevefima kresramna vu zagagafama anankema nekafrizafi ananke'na eme akafriteno, korama'a erino kresramna vu itamofo asoparega ome rutritri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Anantera miko afova'a kresramna nevuno, risonafima me'nea agusa'ane, rimpama eri anovazi'nea afova'ane, ");
INSERT INTO kbq_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","tare kreso'ane anante'ma eri anoma vazi'nea afova'ane, asumna'ane, asumnare'ma erino vazi'nea afovanena, maka eritagati atregahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ana zana pristi vahe'mo kresramna vu itamofo avuga Ra Anumzamofonte tevefi kresramna vuntegahie. E'i kefozama hu'nea zanku'ma kresramnama vania ofe. ");
INSERT INTO kbq_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ana ne'zana ruotagetfa hu'neanki'za ruotage'ma hu'nea kumapi, pristi nagapinti venene'amozage negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Hagi kefozama hu'nere'ma kresramna vania ofamo'a, kumite'ma kresramna vu ofagna hu'neankino, trakezni'amo'a magoke trake me'neankino, ina pristi vahe'mo'ma kumi'mofo nona huno kresramna vania pristi vahe'mo, agra'ama nesia su'zana, anampintira erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Anahukna huno tevefima kresramna vu ofama eri'za esageno kresramna vania pristi ne'mo, ana afu'mofo akru'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Anahukna huno avenifi kre hagage hu'nesia witio, kuta kavofi kre'nesia witio, kuta fraipanire kre'nesia witima ofama eri'za esazana, ofama hania pristi vahe'mofo su'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Hagi mika witi ofama masavene eri havia huge, hagage hu'nesia witia miko Aroni ne' mofavre'mokizmi su'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ama'i rimpa fru ofama Ra Anumzamofoma huntesaza zamofo trake. ");
INSERT INTO kbq_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Hagi mago'mo'ma Ra Anumzamofoma muse hunteno ofama huntenaku'ma hanuno'a, zo-ore bretima masavene eri havia huno kre'nenia bretine, masave frente bisketine, kne'nesia flauapima masavena eri havia huno krente'nesia kekine amigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Hagi Ra Anumzamofoma susu hunteno rimpa fru ofama huntesifina, zisti ante bretine kre mana vunteno. ");
INSERT INTO kbq_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Hagi breti ofama hunaku erino esifintira, Ra Anumzamofo suzane huno mago'mago'ma erinoma eme amisia bretimo'a, kresramana vu itare korama rutri tri hania pristi ne'mofo su'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Hagi rimpa fru ofama susu'ma hunteno amite'noma atresia avufga'a, kresramnama vania zupage negahie. Hagi magore huno atrenkeno, mago'a avufgamo'a me'nenkeno kora otino. ");
INSERT INTO kbq_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Hianagi huvempa hu'nesire'ma kresramna vu ofama huge, agra'a avesite'ma hania ofa, ana ofama kresramnama vania knare neneno, mesiama'a okina negahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Hianagi Kresramanama nevuno'ma atresageno 3'a zageknama ome haniana, ana avufga'a tevefi kre fanane hino. ");
INSERT INTO kbq_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Hagi rimpa fru ofama kresramna vu afu'mofo ame'ama mesiama'a, namba 3 knazupama nesiana ana ofama haniazamo'a, amnezankna hugahie. Iza'o ana afu'ma nesimo'a kefoza hugahiankino, kna'a agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Hagi ana afu'mofo ame'amo'ma agruma osu'nesia zama avako'ma hania avufga'a onetma, tevefi kre fanane hiho. Hagi mago'a ame'ama mesiama'a agruma hu'nesaza vahe'mo'za negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Hagi iza'o agruma osu'neno, rimpa fru ofama Ra Anumzamofonte'ma hanifinti'ma nesiana, Anumzamofo vahepintira ahe natitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Hagi mago'mo'ma vahe'ma azeri pehanama nehiazama avako huge, agruma osu'nesia zagagafa avako huge, agoteno agruma osu'nesia zama avako'ma nehuno, Ra Anumzamofontegama rimpa fru ofama kresramna vuntesnifinti'ma nesia vahera, Anumzamofo vahepintira ahe natitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Anante Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israeli vahe'mokizmia anage hunka zamasamio, Magore huta Israeli vahe'mota bulimakao afumofono, sipisipi afumofono, meme afu'mofo afova'a onetfa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Anahukna huta fri'nesia zagagafao, mago'a zagagafamo aheno tapage hu'nesia zagagafanena, mago'a eri'za kante erinenteta, onetfa hiho. ");
INSERT INTO kbq_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Na'ankure Ra Anumzamofonte'ma tevefima kresramna vuntesaza zagagafamofo afova'a nesia vahera, Anumzamofo vahepintira ahe natitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Hagi tamagrama manitama vanafina, namamofone, mago'a zagagafamofo korama'a onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Hagi iza'o korama nesimofona, Anumzamofo vahepintira ahe natitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Anante Ra Anumzamo'a Mosesena asamino anage hu'ne, ");
INSERT INTO kbq_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israeli vahera anage hunka zamasmio, iza'o rimpa fru ofama kresramna vunaku'ma haniana, rimpa fru ofama Ra Anumzamofonte hunaku'ma hanifinti, mago'a erino egahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ra Anumzamofonte'ma tevefi kre fananehu ofa agra'a azampinti erino egahie. Agra afova'ane amimizane erino egahiankino, ana amimiza'a eri veravehu ofa Ra Anumzamofonte erino egahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Hagi pristi vahe'mo'za afova'a kresramna vu itare kregahazanagi, amimiza'a Aroni mofavre naga'mokizmi su'zane. ");
INSERT INTO kbq_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Hagi rimpa fru ofama hunaku'ma eri'noma esia afu'mofona, tamaga kaziga amumazina pristi vahe'mokizmi zamigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Hagi Aroni mofavre nagapinti pristi ne'mo'ma, rimpa fru ofama afova'ane, korama'ama hanimo, tamaga kaziga amumazina erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Na'ankure maka Israeli vahe'mo'zama rimpa fru ofama hu'naku'ma eri'zama esaza kresramna vu ofafintira, eri verave hu ofama hu amimizane, kresramna vu ofama hu tamaga kaziga amumazina Aronine mofavre naga'amokizmi Nagra zami'noanki'za, maka kna zamagrake nevava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ra Anumzamofonte'ma kresramna vu ofama hanafintira, ana'ma'a Aronine mofavre'naga'amokizmi su'za megahiankino, e'i ana ne'zamo'a zamagri su'za megahie huno pristi eri'zama erisazegu'ma Mosese'ma masavema frezmanteno huhampria zupa, Ra Anumzamo'a erigahaze hu'neankino, zamagra erigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Hagi pristi vahe'ma huhampri zmanteno masavema frezmantenia zupa, Ra Anumzamo'a Israeli vahe'mokizmigura ofama hanafintira ama anama'a pristi vahera zamitere hugahaze huno huzmante'neanki'za, Israeli vahe'mo'za fore hu anante anante'ma hanaza vahe'mo'za ofama hanaza zupa, ama anama'a amitere hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ama'i kresramna vu'zamofo kasege, witima kre mana vu ofagi, kumite'ma kresramna vu ofagi, kefozama hu'nesire'ma Kresramana vu ofagi, masavema frezmanteno huhamprinte ofagi, rimpa fru ofama, ");
INSERT INTO kbq_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Israeli vahe'mo'zama Sainai hagage kokampima mani'nazageno, Ra Anumzamo'ma kresramna vunanteho huno nezmasamino, Sainai agonafi Mosesema ami'nea kasege. ");
INSERT INTO kbq_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Anantera Ra Anumzamo'a anage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Menina Aronine mofavre naga'ane, efeke za'za kukena zamine, huhampri nezmante'za tagi'zama frenezmantaza masavene, kumite'ma ofama hanaza ve bulimakaone, tare sipisipine, mago ekaeka kupi zo-ore bretia e'nerinka, ");
INSERT INTO kbq_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","atrumahu seli nomofo avuga, maka Israeli vahera ke hutru huo. ");
INSERT INTO kbq_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mosese'a Ra Anumzamo'ma asami'nea kante anteno, ke hige'za atruma hu seli nomofo ufre kanfante omeritru hazageno, ");
INSERT INTO kbq_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","amanage huno Israeli vahera zamasami'ne, Ra Anumzamo'a amana hiho huno hurante'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Anage huteno Mosese'a Aronine, mofavre naga'a zamavareno ome zmanteno tina frezamante'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ana huteno agra agu'a kukena Aronina antaninenteno, za'za kukena hunenteno anazama tro'ma nehaza vahe'mo'za knare hu'za tro hu'naza zaza nofi rugagino amu nofira hunenteno, amimizafina tavrave antaninenteno, ana tavravere efoti'ema nehazaza amimizarera anakinte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hagi onasi tavrave amimizafina anakinteteno, anantera Ra Anumzamofo avesizama keno eri fore'ma nehia haverare urimi havene tamimi havene rente'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Hagi asenirera mago tavrave nofi anakinenteno, ana nofimofo avuga golire kuta zoumpa tro hu'naza anakinenteno, Ra Anumzamo'ma Mosesema asmi'nea kante anteno tavravea anakinte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Anante Mosese'a tagino'ma frenezmanteno zamazeri ruotage'ma nehia masavena erino seli none, hakare'a zama agu'afima me'nea zantamina, masave frenenteno Ra Anumzamofo zane huno azeri ruotage hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Hagi mago'a masavena 7ni'a zupa kresramna vu itarera rutri tri hunenteno, kresramnavu itane anampima ne'zama krezantamima me'nea zana azeri ruotage nehuno, bronsire zuompane, tra'anena azeri ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Hagi mago'a masavena Aroni asenifi frenenteno azeri ruotage hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ana huteno Aroni mofavre'mokizmia zamavreno kukena hunezmanteno, zamu'nofira hunezamanteno, Ra Anumzamo'ma asmi'nea kante anteno zamasenire tavrave nofira anakizmante'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ana huteno Mosese'a kumi'mofo ofama hu'zana ve bulimakao afu avreno egeno, Aroni ene mofavre'amo'za ana bulimakaomofo asenirera zamazana ante'naze. ");
INSERT INTO kbq_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mosese'a ana bulimakao afura ananke akafriteno, mago'a korana erino Kresramana nevaza itare me'nea pazivetaminte azankonu reno frenenteno, mago'a korama meama'a ana kresramnavu itamofo agafi tagitreno azeri ruotage hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Hagi rimpafima me'nea mika'a afova'ane, asumnare'ma refite'nea afova'ane tarega kreso'anena Mosese'a tagatino kresramna vu itare kresramna vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Hianagi ana bulimakaomofo avufagi, ame'agi, agruna nofi'a erino kumamofo fegi'a Ra Anumzamo'ma asami'nea kante Mosese'a ome kre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Hagi anantera Mosese'a tevefima kresramna vu'zana ve sipisipi afu avrezamige'za, ana sipisipimofo asenire Aroni'ene mofavre'amo'za zamazana ante'naze. ");
INSERT INTO kbq_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Hagi Mosese'a ana sipisipia ananke akafrino korama'a erino kresramna vu itamofo maka asoparega rutri tri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ana sipisipima tagahu osi osi huteno'a aseni'agi, ameagi, afova'agi huno kre manavu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Hagi agusu'agese zama'ane, agazama'anena tinu sese huteno, Mosese'a Ra Anumzamo'ma asami'nea kante anteno, ana maka kresramna vigeno Ra Anumzamo'a mana'a nentahino antahi musena hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hagi Aronine mofavre'amokizmima huhampri zamanteno zamazeri ruotage hunaku Mosese'a mago sipisipia zamige'za asenire zamazana ante'naze. ");
INSERT INTO kbq_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mosese'a ana sipisipia ananke akafrino mago'a korama'a erino Aronina tamaga kaziga agesa atupare'ene, tamaga kaziga azafa azankore'ene, tamaga kaziga agafa agigore'ene frente'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mosese'a Aroni mofavre nagara kehige'za azageno anahu kna huno ana sipisipimofo korana tamaga kaziga zamagesa atupare'ene, tamaga kaziga zamazafa zamazankore'ene, tamaga kaziga zamagafa zamagigore'ene frezamante'ne. Hagi korama'a erino kresramana vu itamofo asoparega rutri tri hugagi'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Hagi ana huteno afova'ane arisona afovane, maka arimpama erino vazi'nea afovane, asumnane, tarega kreso'ane erinoma vazi'nea afovane tamagakaziga amumazinane eri'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Zisti onte bretima Ra Anumzamofo avugama ekaeka kupi antegeno me'nefinti, Mosese'a zisti onte kekia mago e'nerino, masavenema eri havia huno flauateti kre'nea bretine, masave frente bisketine eriteno sipisipi afova'ane tamaga kaziga amumazinama me'nere ante'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ra Anumzamofonte'ma eri veravehu ofa huntehogu, ana zantamina Mosese'a erino Aronine mofavre'amokizmi zamazampi ante'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ana'ma huteno'a Mosese'a zamazampinti ana zantamina erino kresramna vu itare kresramna vu'ne. E'i pristi vahe'ma zamazeri otage hu ofagino, tevefi kregeno Ra Anumzamo'a mana'a nentahino musena hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Anahukna huno Mosese'a Ra Anumzamofo avuga ana sipisipimofo ahihiza'a eriverave hu'ne. E'i Ra Anumzamo'ma asami'nea kante anteno anara hu'neankino Mosese'ma nesia ne'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Hagi Mosese'a vahe'ma huhamprinte masavena mago'a erino, kresramna vu itareti korana mago'a erino Aroni za'za kukenaregane, mofavre'amokizmi za'za kukenaregane rutri tri hu'nezmanteno, Aronine kukena'ane, mofavreramima'ane, kukenazami'nena eri ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Hagi Mosese'a Aronine mofavre'aramina amanage huno zamasamine, Sipisipi afu ame'a atruma hu seli nonte'ma ufre kahante kavofi kretetama, zo'ore bretima zamazeri ruotage'ma nehia bretima ekaeka kupima me'nea bretine Ra Anumzamo'ma hu'nea kante anteta, negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ana hute'nageno mesia bretine ame'anena tevefi maka kre vagaregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Seveni'a zagegnamofo agu'afina atruma nehaza seli nona atreta atioramiho, na'ankure 7ni'a knamofo agu'afi, agra tamazeri ruotagera hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ra Anumzamo'ma zamazeri agrumahu avu'avazama hugahanema hu'nea zana menina hago huvagarone. ");
INSERT INTO kbq_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Tamagra 7ni'a knafina hanine zagenena atrumahu seli nomofo kafante mani'neta, Ra Anumzamo'ma huramantesia zana nehuta, ofri kasefa huta maniho. ");
INSERT INTO kbq_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Hige'za Aroni'ene mofavre'amo'za Ra Anumzamo'ma Mosese'ma asamigeno zamasami'nea zana maka hu'naze. ");
INSERT INTO kbq_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Anazama huvaretageno 8ti knazupa Mosese'a Aronine mofavre naga'ane Israeli kva vahetaminena ke hutru huteno, ");
INSERT INTO kbq_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","amanage huno Aronina asami'ne, Kumite'ma ofama hu'zana mago afuhe afahe osu'nesia agaho ve bulimakao afu nevrenka, kre fananehu ofama hu'zana mago ve sipisipia afuhe afahe osu'nesia avrenka Ra Anumzamofona avuga ofa ome huntegahane. ");
INSERT INTO kbq_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Hagi Israeli vahe'mokizmia kagra anage hunka zamasamio, kumizmigu'ma kresramna vunakura, ve meme afu nevreta, tevefima kre fananehu ofama hu'zana mago kafu huno afuhe afahe osu'nesia agaho bulimakaone, mago sipisipi afuteti kresramna nevuta, ");
INSERT INTO kbq_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","mago ve bulimakaone mago ve sipisipireti arimpa fru ofa kresramana Ra Anumzamofo avuga nehuta, masavenu'ma eri havia hu flauateti witi ofa hugahaze. Na'ankure menina Ra Anumzamo'a tamagrite efore hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Hagi Mosese'ma hu'nea zantamina Israeli vahe'mo'za eri'za atruhu seli nomofo avuga Ra Anumzamofo avure eme oti'naze. ");
INSERT INTO kbq_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Anante Mosese'a amanage hu'ne, Ra Anumzamo'a huno amanahu'za hanageno Ra Anumzamofo masazamo'a tamagritera efore hugahie hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Anante Mosese'a anage huno Aronina asami'ne, Kumite'ma nona huno kresramna vu ofaka'ane tevefima kre fanane hu ofaka'a erinka enka kagra'a kumitera nona hunka ofa nehunka, Anumzamo'ma hu'nea kante antenka ruga'amokizmi kumi'zamirera nona hunka kresramna vuzamantegahane. ");
INSERT INTO kbq_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Hagi Aroni'a kresramna vu itare vurava'o huno kumi'agu kresramna vanigu agaho bulimakao anankena akafri'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Hagi anante mofavrezaga'amo'za korama'a eri'za ageno, azanko ana korampi reteno, kresramna vu itare'ma me'nea pazivetaminte frenenteno, mago'ama meama'a kresramna vu itamofo agafi tagitre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Hagi Ra Anumzamo'ma Mosesema asami'nea kante anteno afova'agi, tarega kresoagi, asumanama erinovazi'nea afova'a kresramna vu itare kumi'mofo nona huno tevefi kresramna vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ame'ane ukri'anena kumamofo fegi'a ome kre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Anantera Aroni'a kresramna vu sipisipi afura ananke akafritege'za, mofavre'amo'za ana korana eri amizageno, kresramna vu itamofo asoparega rutritri hugagi'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Hagi kresramna vu afu'ma tagahu osi osi'ma hunte'nefinti magoke magoke erinemi'za asenianena erimizageno kresramna vu itarera kre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Hagi agusu agese zama'ane agazama'anena tinu sese huteno kresramna vu itare kre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hagi anantera Aroni'a veamokizmi ofa kresramna vu afura erino ome kresramna nevuno, agra veamokizmi kumite'ma kresramna vu meme afu avreno ananke akafrino ese'ma hu'neaza huno kresramna vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hagi kresramna vu'zana erino eno kresramna vu trake'mo'ma hu'nea kante anteno kresramna vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Hagi mago'a witia azampina eriviteno eno, kre mna vu itare nanterana eme kremna vu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Hagi agra veamozama Anumzanema mago zamarimpa hanaza ofa bulimakaone, sipisipi afu'enena anankena akafri'ne. Hagi Aronina mofavre naga'amo'za korama'a erimizageno, kresramna vu itamofo asoparega rutri tri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Hianagi bulimakaomofo afova'ane, sipisipimofo risonarega me'nea agusa'ane, tarega kreso'ane asumanama eri novazi'nea afovane, ");
INSERT INTO kbq_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ana afu'mofo amimizafi eri antageno Aroni'a kresramana vu itare kre'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aroni'a Mosese'ma hu'nea kante anteno amimiza'ane tamaga kaziga amumazinanena erino Ra Anumzamofo avuga eriverave hu ofa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hagi Aroni'a kumite'ma kresramna vu ofane, kre fanane hu ofane, rimpa fru ofama huteno'a, veamokizmirega ana azana rusuteno asomu ke huzmanteteno, anantetira atreno erami'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mosese'ene Aronikea atruma nehaza seli nompi mareriteke atiramike eke veamokizmia asomu ke eme hunezmantakeno, Ra Anumzamofo masamo'a veamokizmire e'ama hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ra Anumzamo'a tevea atregeno eramino ana kresramna vu'zane, afova'a kresramana vu itaretira tefanane hu'ne. E'i anazama vahe'mo'za nege'za muse hu'za kezaneti'za, zamavugo saregati mopafi mase'za mono hunte'naze. ");
INSERT INTO kbq_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Natapu'ene Avihukea Aroni ne' mofavregi'ne, Ra Anumzamo'ma i'oma hu'nea kea rutagreke, mnanentake'zama insensima kre fraipanifi Ra Anumzamofontega ome kremna vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ana hakeno Ra Anumzamo'a teve atregeno hagnahagna huno znavufga terasagegeke, Ra Anumzamofo avuga fri'na'e. ");
INSERT INTO kbq_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ana hutakeno Mosese'a Aroninku anage hu'ne, Ra Anumzamo'a amanage hu'ne, nagrite'ma eravao'ma hanaza vahe'mo'za Nagrikura ruotage hu'ne hu'za nehanage'na, masani'a zamaveri hugahue hu'ne. Aroni'a anante kea osuno oti'ne. ");
INSERT INTO kbq_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Hagi Mosese'a anage'ma huteno, Aroni nenogo Uzari mofavre Miseline Elsafanikizanigu zanasamino, neranafu fri kerafa emerita atruhu seli mono nomofo avugatira kuma'mofo fegi'a afete ome atre'o, ");
INSERT INTO kbq_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","anage higeke anama fri'na'a netre'na za'za kukena znavufare me'negeke Mosese'ma zamasami'nea kante anteke erike fegi'a vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Anante Mosese'a amanage huno Aronine tare mofavre'arare Eleasane, Itamarinena zamasmi'ne, Ama zankura tamasunkura huta tamazokate'ma refite'naza tavrave eritrege, kukenatamia tagotora osiho, ru ete frisageno Ra Anumzamo'a mika vahekura arimpa ahezamantegahie. Hianagi mika Israeli vahe'mo'za Ra Anumzamo'ma tevereti'ma znahe fri'nea netretrenkura amane zavira ategahaze. ");
INSERT INTO kbq_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Hagi atrumahu Seli nompintira frigahazanki atiramita oviho. Na'ankure Ra Anumzamo huhampritamanteno masavea freramante'ne. Hige'za Mosesema hiankante ante'za anazana hu'naze. ");
INSERT INTO kbq_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ana hutageno, Ra Anumzamo'a anage huno Aronina asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Aroniga kagrane mofavre nagaka'anema Atrumahu Seli Nompima vunaku'ma hanaza knarera waini tina nege, hanave tina neteta uofreho, ana'ma hanazana frigahaze. Hagi henkama fore hunante anante'ma hu'zama vanaza vahe'mo'za anazana hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Hagi hanave tima oneta knare huta manisuta, e'izamo'a ruotage higeno, e'izamo'a ruotagera osu'ne nehuta, e'izamo agru higeno, e'izamo'a agru osu'ne huta rezageneta kegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ana nehutma Ra Anumzamo'ma mika trakema Mosesema ami'neana, Israeli vahera rempi huzamigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mosese'a amanage huno Aronine tare mofavre'ama ofri'ma mani'namokizni Eleasarine, Itamarinena zamasmi'ne, Witi ofama nehazageno kre mana vu ita me'nere zistima onte bretima me'neana erita neho, na'ankure e'i ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Hagi ruotage'ma hu'nea kumapi neho. Na'ankure Ra Anumzamofoma kresramna vuntenafintira kagrane kagripintima fore hanaza vahe'mo'za negahaze huno huramante'neankino, tamagri ne'za me'ne. ");
INSERT INTO kbq_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Hagi Israeli vahe'mo'zama eriverave hu ofama hanaza amimiza'ane, arimpa fru ofama hanaza amumazina'anena kagrane maka ne'mofakanena agruma hu'nea kumapinke amane negahaze. Na'ankure Ra Anumzamo'a negahaze huno huramante'neankino tamagri ne'za me'ne. ");
INSERT INTO kbq_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Hagi amo'ane amimiza'ane eri verave'ma hutesuta, afova'a tevefi kresramna nevuta Ra Anumzamo'ma hu'nea kante, amo'ane amimiza'anena kagri'ene mofavre nagakamofo suzankita, amne eri vava huta vugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Hagi Mosese'a kumite'ma ofama hu'na'a meme afu'mofo agenkema zamantahigeno keana, maka ana meme afura tevefi krevare'na'e hu'naze. Anankema Mosese'ma nentahino'a, Aroni nemofo Eleazane Itamalikiznia tusi arimpa aheneznanteno, ");
INSERT INTO kbq_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","nahigeta kumite'ma kresramna vu afura ruotage'ma hu'nefina one'na'e? Na'ankure e'i ruotage hu'neankino, vahe'mofo kefozante nona huta kresramna vanageno, Ra Anumzamo'a kumizmia eritrezmantesiegu eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Hanki keho, ruotage'ma hu'nefinkama korama'a erita uofreneta huramante'noa kante ana ame'a nazasine. ");
INSERT INTO kbq_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Hianagi Aroni'a anage huno Mosesena asami'ne, Menina kumite ofane tevefima krefanane hu ofanena Ra Anumzamofo avurera kresramna vu'na'anagi, amanahu zana nagritera fore nehie. Kumite'ma kresramna vu'nesaza zama nesuana Ra Anumzamo'a menina musena hugahifi? ");
INSERT INTO kbq_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Anankema Mosese'a nentahino, Aroni'a tamage hie huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ra Anumzamo'a amanage huno Mosesene Aroninena zanasmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Mopafima mani'naza maka zagagafafinti'ma nesaza zagamofo tra kea Israeli vahera zamasmio. ");
INSERT INTO kbq_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hagi agigomo'ma tarefi atanesigeno, trazama neteno, ete ome revarino nenesia zagagafa amane negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mago'a zagagafamo'za revari'za ne'zana nenazageno, zamagigomo'a hatanara nosigeno, mago'a zagagafamofona zamagigomo'a hatnama hanigeno ne'zama revarino nonesia zagagafa onegahaze. E'i magora kemoli afure, ne'zana varino neneanagi agiamo'a tarefina hatnara osu'neankino agrua osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Havefi krofamo'a anahukna huno ne'zana revarino neneanagi, tarefi agigomo'a ruotaneneankino agru osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Rebitimo'a anahukna huno ne'zana revarino neneanagi, tarefina agigomo'a hatnara osu'neankino agru osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Afu'mofona agigomo'a hatna hu'neanagi, ne'zana revarino noneankino, agru osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hagi tamagra ana zagagafaramima fri'nesiana avakora osuge ame'a onegahaze, na'ankure agrua osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Hanki miko hagerimpine, amane timpinema nemanisia zagama iri'ane agekonanema hunte'nesiana amane negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Hianagi mika zagama hagerimpima nemania zagane, amane timpima iri'ane ageko'nanema huonte'nesia zagama mani'neniana, himnage huno havizantfa hu'neankita onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Hagi e'i ana zagamo'za kasri'za havizantfa hu'nazanki, ame'a noneta fri'nesaza zamavufarera avakora osuta onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Hagi timpima mani'nenaza zagamofoma iri'ane agekonanema huonte'neniana, tamagotenteta haviza hu'neankita onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Mago'a nama haviza hu'neankita onegahaze. E'i ana namazaga tumpanki, zagagafama nenea namagi, haninke namama zagagafama nenea namagi, ");
INSERT INTO kbq_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","korankre za'za agekonane tumpanki, kazi tumpanki, ");
INSERT INTO kbq_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","haninke namaramima ra ageruma neria namagi, ");
INSERT INTO kbq_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","mananinkna zaza arenane namagi, rankrafama nehia komutonki, hagerinkenafi nemaniza efeke namazagagi, hagerinkena tumpanki, ");
INSERT INTO kbq_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","osi komutonki, hagerimpi hareno vano nehuno nozameza nehia namagi, ra komutonki, ");
INSERT INTO kbq_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","efeke komutonki, hagage kopi komutonki, kasari zama nenea tumpanki, ");
INSERT INTO kbq_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","za'za aginkunane efeke namagi, afi patonki, funtariki tampranena onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tare ageko'nama hunte'nenigeno agareti'ma mopafima regraroheno vanoma nehania ne'onse zaga knarera osu'neankita onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Agekona'ma huntegeno mopafima vanoma nehu'za, takaure takaurema hu'zama vanoma nehaza zagaramina amane negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","E'i ranra kenuki, asukenki, onensi kenura amane negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Hianagi mago'a zagramima agiazama hunte'nenigeno ageko'nama me'nenia zagaramina, tamagotenenteta onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Amanahu'ma hanuta tamagra'a tamavufga tamazeri pehana hugahaze. Fri'nenia zagaraminte'ma avakoma hanimofona, azeri pehana hanigeno, anazamo'a meno vuno kinaga ome vagaregahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Iza'o frizagama avakoma hanimo'a, kukena'a sese huteno mani'nenigeno, vuno kinaga senkeno anamo'a agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Agigoma me'nenia zagaramima, agigomo'ma hatanama osu'nesigeno trazama revarino nonenia zagaramina agru osu'ne huta hiho. Iza'o ana zagaramima avako'ma hanimo'a agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Rama'a agigoma hunte'nenigeno mopafima vanoma nehania zagaramina, agrua osu'naze. Hagi fri'nesageta zamavufarera avako osiho. Hagi avako'ma hanazana agru osu mani'nenageno vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Iza'o anama fri'nesia zagamofo avufa'ama erisaga hanimo'a, kukena sese huteno mani'nenigeno vuno kinaga segahie. E'i ana zagamo'a agrua osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Hagi neonse zagaramima, mopafi vano nehaza zagaramimpinti'ma agruma osu'nazana, barenki, kafagi, neonse'ene ranra tagovi zagarami'ne. ");
INSERT INTO kbq_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Hagi efeke tagovi kekogi, pupukigi zampavenki, amuho kopi nemaniza tagoviki, sgoramure. ");
INSERT INTO kbq_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Hagi ana zagaramima mopafima vanoma nehia zagaramimpinti'ma agru'ma osu'nesia zagama, fri'nenagenoma iza'o zamavufare'ma avako hanimo'a, agru osugahiankino, agru osu mani'nena vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ana zagaramimo frino evuramino zafareti'ma tro hu'nesia zantero, kukenarero, zagagafamofo akrutero, tapa kukenare'ma evuramino avako'ma haniana, agru osanigeno ana'ma hania zantamina timpi reta sese hinkeno meno vuno kinaga senkeno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ana zagagafafinti mago'mo'ma mopa kavofima evurami'niana ana kavofima me'nenia zantamimo'a agru osugahianki, ana kavoa rurako hutreho. ");
INSERT INTO kbq_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Hagi ana kavofinti'ma tima tagiramino avakoma hania ne'zamo'a agru osanigeno, ana kavofinti'ma tima ne'zamo'a, agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Hagi ana zagamofo fri avufgamo'ma evuramino avako'ma hania teve hugre stofumo'o avenimo'a agru osugahianki, rurako hutreho. ");
INSERT INTO kbq_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Hagi tinkampui nehantisirero tifi kerifi ana zagamofo fri avufamo'ma me'neniana amane agru hu'neanagi, iza'o azama avako'ma hanimo'a agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Hagi krinaku'ma ante'nenaza avimzampima fri'nesia zagamo'ma evuramisiana, ana avimazamo'a agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Hianagi fri'nenia zagamo'ma avimazama me'nenia timpima evuraminiana, ana avimzamo'a agrua osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Hagi negahazema hunama huramante'noa afuzagafintima fri'nenigeno avako'ma hanimo'a, agru osu mani'nena vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Hagi anama fri'nenia zagama nesimo'o, erisga hanimo'a agru osugahiankino kukena'a sese nehuno, agru osu mani'nenigeno vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Hagi moparema vanoma nehia zagaramina agru osu'neankita, tamagotenteta onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Hagi mopafima zamasaguregati vano nehaza zagaramine, rama'a agiaza hunte'nenia zagamo mopafi vano nehania zagaramina agru osu zagagita tamagotenenteta tamagra onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Hagi ama ana zagaramina avako nehutma, tamagra'a tamazeri pehana osiho. ");
INSERT INTO kbq_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na'ankure Nagra Ra Anumzana tamagri Anumza mani'noanki, tamagra'a tamazeri avusese nehutma, tamazeri ruotage hiho. Na'ankure Nagra ruotage hu'nogu, zamasaguregati'ma vanoma nehaza zaga avakora hutma tamazeri pehena osugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nagra'a Ra Anumzamo'na Isipitira tamavre fegu'a atre'na, tamavre'na e'noa tamagri Anumza mani'nogu, tamagra mani ruotage hutma maniho. Na'ankure Nagra ruotage hu'na mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mopafima vanoma nehaza zagaramimofone namaramimofone, miko timpima nemaniza zagaramimofone, mika mopafima regrarohe'za vano nehaza zagaramimofo tra ke. ");
INSERT INTO kbq_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Hagi tamagra rezaganeta negetma, e'izamo'a agru osu'neanki, e'izamo'a agru hu'neanki nehutma, negahunanki, onegahunanki huta hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Hanki anantera Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Amanage hunka Israeli vahera zamasamio, mago a'mo'ma ne' mofavre'ma kasentenuno'a, namunkama freneno'ma nehiaza huno 7ni'a zagegna maniteno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hagi ne' mofavremofona 8 zagekna zupa agoza anoma'a taga hutregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hagi ana a'mo'a ne' mofavrema kasente'nea zankura, 33'a zagegna agruma hanigura avega anteno manigahie. Hagi ana a'mo'a ruotage'ma huno me'neazantamina avakora nosuno, ruotagema hunefina ovuno mani'nenigeno agruma hu knamo'a egahie. ");
INSERT INTO kbq_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Hianagi mofa'ma kasentesigeno'a ana a'mo'a tare sontamofo agu'afi agrua osuno maniteno, ete mago'ane 66'agna maniteno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Hagi ne'mofavreo, mofa mofavre'ma kasente'nesia zanku'ma azeri agruma hu knama evutenkeno'a, tevefima kresramna vu ofa mago kafu hu'nesia sipisipi nevreno, kumi ofama hu'zana maho namao kugofa nama avreno pristi vahete seli nomofo avuga egahie. ");
INSERT INTO kbq_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Hagi ana nama pristi ne'mo'a avreno, ana a'mo'ma agruma osu'nea zantera nona huno Ra Anumzamofontera ofa hina, ana a'mo'ma mofavrema kasenteteno azeri agru hugahie. Hagi ama'i a'mo'ma mofavrema kasentete'noma azeri agruma hania zamofo trake. ");
INSERT INTO kbq_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Hianagi ana a'mo'ma sipisipima avrenoma ega'ma osanuno'a, tare maho namao, tare kugofa nama avreno e'nigeno, mago nama Ra Anumzamofonte kresramana nevuno, mago nama ana a'ma azeri agru hu ofa pristi ne'mo'a hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ra Anumzamo'a amanage huno Mosesene Aroninena zanasami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Mago'mofo avufare'ma zorege, zuke namurege, ahehema fore'ma hanigeno, anazamo'ma fugo namuma rege'ma hanige'za avre'za pristi ne' Aroninte vuge, mofavre zaga'are avre'za viho. ");
INSERT INTO kbq_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Hagi Pristi vahe'mo'za ana namuna rezagane'za kesageno'ma, namuma me'nenifima azokamo'ma efeke'ma huno ana namumo'ma hanagatino ufre'nesigeno, pristi ne'mo'ma reprosi namune hanigeno'a, ana vahe'mo'a agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Hagi ana namumo'ma efeke huno avufgare'ma fore'ma nehuno, rama huno agu'a uofrenkeno namuma re'nere'ma me'nea azokamo'ma efeke'ma osu'nena pristi vahe'mo'za ana nera 7ni'a zagegna azeri frakiza antegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Hagi 7ni zupama pristi vahe'mo'ma kesigeno ana namumo tera osuge, te osi osugema hu'nenkeno'a, ete mago'ane 7ni'a zagegna azeri frakigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Hagi 7ni zupama kesigeno'ma ana namumo'ma tera osuno teganinkeno'a, pristi ne'mo'a amne namune nehuno huntenkeno, kukena'a ome sese nehuno, agra'a azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Hianagi pristi vahe'mo'ma ana namuma te onasima hanigeno agru hune huno huntesige'noma umani'nenigeno, ana namumo tera hanigeno'a eteno pristi vahete vino. ");
INSERT INTO kbq_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Hagi pristi vahe'mo'ma avonta huno rezaganeno keteno, ana namumo'ma terama hu'nenkeno'a, agru osu'neankino fugo krie huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Hagi mago vahe'ma avufafima fugo namuma me'nenke'za, ko pristi vahete avre'za viho. ");
INSERT INTO kbq_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Hagi ana namuma pristi vahe'mo'za kesagenoma efeke hanigeno, azokamo'enema efeke'ma nehanigeno, avo timo'ma herafineramina, ");
INSERT INTO kbq_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","e'i zazate meno vania fugo namunkino, pristi vahe'mo'a agra agru osune huno huama nehuno azeri fore hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Hagi pristi vahe'mo ana fugo ri'ma kesigeno tera huno asenireti agiare'ma uhanatisigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","pristi vahe'mo'a rezagane so'e huno kesigenoma ana fugo namumo'ma mika avufare'ma tenenkeno, avufamo'ma efeke hanigeno'a, agra agru hu'ne huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Hianagi kesigeno kasefa namuma avufafima fore'ma hanigeno'a, agra agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Hagi pristi vahe'mo'ma kesigeno avo'mo rupro hanigeno, agu'afinti ame'amo'ma etiramisigeno kesuno'a, agru osu'neankino fugo namune huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Hianagi ana namumo'ma fananema huno efeke'ma hanigeno'a, ete pristi vahete vino. ");
INSERT INTO kbq_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Hagi pristi vahe'mo'a kesigeno'ma, namumo'ma efeke hu'nenkeno'a, namuma re'nesia vahekura agru hu'nane huno hunteno. ");
INSERT INTO kbq_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Usagema ahenesia vahe'ma vagamarentesigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ana namumo efeke huge koranke huge, zomaoresigeno'a, agra'a avufa pristi vahete eme averi hino. ");
INSERT INTO kbq_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Hagi pristi vahe'mo'ma kesageno'ma ana namumo hanagatino fre'neno, ana namumpima me'nenia azokamo'ma efeke hu'nenigeno kesuno'a, ana namunkura usagempinti fore hu'nea fugo namune nehuno, agru osu'nane huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Hianagi pristi vahe'mo'ma kesigeno, ana namumo efeke osuno hanagatino ofreno terama osanigeno'a, 7ni'a zagegna azeri frakinkeno manigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Hagi ana 7ni'a knama evutenkeno'ma ana namumo'ma rura huno avufafima vuno enoma hanigeno'a, pristi vahe'mo'a ana nekura agru osu'nane huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Hianagi ana namumo rura osuno me'nena, pristi vahe'mo'a amane usagemo ana hu'neanki agru hu'nane huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Hagi tevemo'ma mago'mofo avufgama terasgene'nigeno, namumo'ma avoke huno efeke'ma nehuno koranke'ma hu'nena, ");
INSERT INTO kbq_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","pristi vahe'mo'ma ana namumpima me'nenia azokama kesigeno'ma efeke hanigeno, namumo'ma ra huno hanagatino agu'ama ufre'nenkeno'a, agrua osu'nane huno pristi vahe'mo'a hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Hianagi pristi vahe'mo'ma kesigeno'ma, ana namumpima me'nenia azokamo'ma efeke'ma osanigeno, ana namumo'ma hanagatino uofreno, teganizama nehanigeno'a, 7ni'a zagegna azeri frakisigeno manigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Hagi 7ni kna zupa pristi vahe'mo'ma kesigeno'ma ana ne'mofo namumo'ma avufafima terama hanigeno'a, ana nekura agru osu'nane huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Hianagi ana namumo'ma tera huno avufafima vuno enoma osanigeno'ma, pristi vahe'mo'ma kenuno'a, amane tevemo te'neazamo'e nehuno, agru hu'ne huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Hagi mago vemofono a'mofoma, zuke namuma asenifi rege, ameragempima rege'ma hu'nenigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ana zuke namuma pristi vahe'mo kesigeno'ma terama huno hanagatino ufrenigeno, azokamo'ma kaninkruke hu'nena pristi vahe'mo'a ana vahekura, agru osu'nane huno huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Hianagi ana zuke namuma pristi vahe'mo'ma kesigeno'ma ana namumo'ma terama huno hanagatino uofrenigeno, haninke azokama anampima omanena, pristi vahe'mo'a ana nera 7ni'a zagegna avre frakisigeno manigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Hagi 7ni knare'ma pristi vahe'mo'ma kesigeno ana zuke namumo'ma tera osanigeno, azokamo'ma kaninkruke'ma osanigeno, ana namumo hanagatino uofre'nenkeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","anantera azokara haregahianagi, namuma re'neniama'a ohareno atrenenkeno, pristi vahe'mo'a mago'ane 7ni'a kna avre frakinkeno ana vahe'mo'a manigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Hagi 7ni kna zupa pristi vahe'mo'a keteno, namumo'ma terama huno hanagatino'ma uofre'nenkeno'a, agru hu'ne huno ana vahera huntenkeno, kukena'a sese nehuno agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Hianagi agru hu'nane huno'ma huntetesigeno, umani'nenigeno ana zuke namumo'ma terama hanigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","pristi vahe'mo'ma anamofoma kesigeno'ma, ana zuka namumo'ma tera huno vuno enoma hanigeno, hago tera hu'neankino pristi ne'mo'a kanikruke azokakura onkeno, agru osu'nane huno ana ne'kura huntegahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Hianagi pristi vahe'mo'ma kesigeno ana zuke namumo'ma tera osanigeno, haninke azokama anampima me'nena pristi vahe'mo'a agru hu'ne huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Hagi mago ne'mofono a'mofoma efeke kiraremo'ma avufaregama hu'nesigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","pristi vahe'mo'ma ana kirarema re'nea avufafima kesigeno efekema hu'nea zamo'ma amanema hanigeno'a, amne namunkino, agru hu'ne huno huntaghie. ");
INSERT INTO kbq_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Hagi mago ne'mofoma anumpi azamoma erisiana, agra agru hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Hagi mago ne'ma tinke azokama pupusenigeno azokamo'ma omanesiana, agra agru hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Hianagi azamompima namumo'ma efeke nehuno koranke'ma hu'neniana, e'i fugo namune. ");
INSERT INTO kbq_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Hagi pristi vahe'mo'ma kesigeno'ma azamompino, kokovipima namumo'ma efeke huge, koranke huge huno'ma fugo namunknama haniana, ");
INSERT INTO kbq_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ana ne'mofona fugo namu re'neankino, agru osu'ne. Hagi pristi vahe'mo'a agru osu'ne huno huntegahie. Na'ankure asenifina namu re'ne. ");
INSERT INTO kbq_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Hagi e'inahu fugo namuma re'nesia vahe'mo'a, tagato'ma hu'nesnia kukena nehuno, azokara refiraoteno, avugosa refiteno avugama'age netreno kezatino, nagra agru osu'noe nagra agru osu'noe huno hino. ");
INSERT INTO kbq_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Hagi ana fugo namuma avufare'ma me'nenigeno'a ana ne'mo'a agru osu'neakino, agraku kumamofo fegi'a manigahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Hagi sipisipi azokateti tro hu'nesia kukenarero, efeke kukenarero, ");
INSERT INTO kbq_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","sipisipi azoka zagino haneno tro hu'nenia kukenarero, efeke kukenama hanenifino, bulimakao akrutema tro'ma hu'nesaza kukenare'ma, ");
INSERT INTO kbq_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","zafa sinage huge koranke avame'zama efore'ma ana kukenare'ma hu'nena, e'i tontore zamofo avame'zanki, pristi vahe averi hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Hagi ana kukena pristi vahe'mo'a keteno, erino frakino ante'nenkeno 7ni'a zagegna megahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Hagi ana kukenaramimo'ma meno vuno 7ni zupama uhanatinigeno pristi vahe'mo'ma kesigeno'ma sipisipi azoka zagino hanenenifino, efeke kukenama hanenenifino, bulimakao akrutema tro'ma hu'nea kukenare'ma tontomo'ma ra huno vuno eno'ma hu'nenkeno'a, agru osu'ne huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hianagi sipisipi azokate tro hu'nesia kukeno, bulimakao akrute tro hu'nesia kukeno, kukenare'ma ana avame'zama fore'ma hanigeno'a, tevefi krenkeno tevareno. ");
INSERT INTO kbq_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Hianagi pristi vahe'mo'ma kesigeno kukenare'ma anazamo'ma rama osu'nena, ");
INSERT INTO kbq_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","pristi vahe'mo'a ana vahera zamasaminige'za ana kukena sese hute'za, 7ni'a zagegna mago'ane fraki'za antesageno megahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Hagi ana avame'zama sesema hutesageno'a ete mago'ane kesigenoma ana kukenamofo tontomo'ma vaga'orenigeno rura ana avamezamo osu'nenianagi, agru osu'neanki amegao agu'afima tontoma re'nena tevefi kre vagaregahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Hagi ana kukena sese'ma hanigeno, ana zamo'ma sipisipi azokate kukenaretiro, efeke kukenaretiro, bulimakao akrute kukenaretima fananema haniana, anama havizama hu'nema'a tagato hutreno. ");
INSERT INTO kbq_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hagi henkama ana tonto fore'ma hina, ana kukenamofo nefa'a tevefi krenkeno, te fanane hino. ");
INSERT INTO kbq_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Hagi henka'ama anazama fore'ma osanigeno'a, ete mago'ane sese hina agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ama'i tra kea sipisipi azokateti zagino hane'ne'nia kukenama, efeke kukena hane'za tro hu'ne'nazano, bulimakao akruteti hane'za tro hu'nenaza zama tontomo'ma eri havizama hu'nenia kukenamofoma pristi vahe'mo'ma agru hu'ne, agru osu'nema huno'ma hania trake. ");
INSERT INTO kbq_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ra Anumzamo'a Mosesena amanage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Fugonkrima eri'nesaza vahe'mo'zama ana krimo'ma atrezamantesige'za zamagra'ama zamazeri avusesema hanaza zama eri'za pristi vahete'ma vanaza zamofo trake. ");
INSERT INTO kbq_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Hagi Pristi vahe'mo'ma kumamofo fegia vuno, ana fugo namumo'ma atrentesigura ana fugo vahe'ma ome kesigenoma, ana fugo namumo'ma atrentesigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","pristi vahe'mo'a ana fugo vahera asamisigeno, agruma hu'nesia namafinti tare namarare nevreno, sida teve e'nerino, koranke nofira e'nerino, hisopu zafa azankuna e'nerino, pristi vahete esigeno ana nera azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hagi pristi vahe'mo'a zamasamisige'za enevania timpinti mopa kavofi tina afi'za esageno, ana kavomofo agofeto mago nama anankena akafrinigeno, koramo'a ana kavofi evuramigahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Hagi avu'agama mania namagi, sida tevegi, korankre nofiki, hisopu zafa azankunaki huno ana korama rente'nenia timpina reteno atigahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Anama azeri agruma hania vahe'mofo avufarega namamofo korana 7ni'a zupa pristi vahe'mo'a rutri tri hunenteno, hago agru hane huno ana fugo nera hunenteno, avuga'ma mani'nea nama atresigeno hareno vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Hagi ana'ma agruma hania ne'mo'a, kukena'a sese nehuno avufaretira mika azokara vazagatenetreno, tina freno agrua hino. Ana'ma hutesuno'a, agru hugahiankino kuma agu'afina ufregahianagi, 7ni'a kna maniteno seli noma'afina ufregahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Hagi ete 7ni kna zupa agra'ama azeri agruma hania vahe'mo'a agi azokora nehareno, avu azokara nehareno, maka avufga azoka'ene nehareno, kukena'a sese nehuno, timpi tina freno agra'a avufga sese huno azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Hagi 8ti kna zupa afuhe afahe osuno mago kafu hu'nesia tare ve sipisipigi, mago a' sipisipi nevreno, 3'a kilo flaua olivi masavene eri havia hu'ne'nia witi ofa e'nerino, mago kapu olivi masave kre sramanama vu'zana erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Hagi azeri agruma hania pristi ne'mo'a, anama agru'ma hania nera nevreno ofa'anena erino Ra Anumzamofo avuga atru'ma hu seli nomofo kahante vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Hagi ana'ma hutesuno'a, pristi vahe'mo'a kumi ofa mago ve sipisipine, olivi masavene eri verave hu ofa Ra Anumzamofontega hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Hagi ana ve sipisipia ruotage'ma hu'nere'ma kumite'ma hu ofane, kre fanane hu ofanema nehazare ome aheno. Hagi kefozama hu'nere'ma kresramana vu'zane kumite'ma kresramana vu'zana ruotage hu'neankino pristi vahe'mofoza megahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Hagi kefozama hu'nere'ma erino e'nea sipisipi afu'mofo korana, pristi vahe'mo'a mago'a erino ana vahe'mofo tamaga kaziga agesare'ene, tamaga kaziga azafare'ene tamaga kaziga agigore'ene frentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hagi pristi vahe'mo'a mago'a olivi masavena hoga aza agu'safi taginteteno, ");
INSERT INTO kbq_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","tamaga kaziga azankoreti ana masavempi reteno, Ra Anumzamofo avuga 7ni'a zupa rutri trira hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Hagi mago'ama mesia masavena pristi vahe'mo'a erino anama agruma hania vemofona, tamaga kaziga agesa atupareki, tamaga kaziga azafa azankoreki, tamaga kaziga agamofo agafa agigore frentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Hagi pristi vahe'mo'a aza agu'safima mesia masavema'a erino azeri agruma hania vahe'mofo asenirera frentegahiankino, e'i ana ofama hania zamo'a kumi'amofo nona hinkeno, Ra Anumzamo'a azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hagi anantera pristi vahe'mo'a kumitera kresramana nevuno, anama agruma osu'nesia vahera azeri agru hugahie. Ana'ma hutesuno'a, pristi vahe'mo'a tevefima kre fananehu kresramna vu sipisipi afura ahegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hagi pristi vahe'mo'a kre fanane hu ofane, witi ofanena kresramna vu itare kregahie. Pristi ne'mo'a e'ina hanigeno, anama kumi'ma hu'nesia vahe'mo'a agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Hagi amunte'ma omnenkeno maka ofama erino'ma ega'ma osanuno'a, mago ve sipisipi nevreno, olivi masavene erihavia hu'ne'nia 1 kilo witi ofa e'nerino, mago kapu olivi masavenena kumite'ma nonama huno eri veravema hu ofa erino egahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Hagi erino ega'ma hu'ne'nia avamente tare maho namarareno, tare agaho kugofa namararena azerino eno, magora kumite Kresramana nevuno, magora tevefi kre fanane hu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Hagi 8ti knazupa anama azeri agruma haniazana erino pristi vahete atru'ma nehaza seli nomofo kahante Ra Anumzamofo avuga vino. ");
INSERT INTO kbq_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ana'ma hanigeno'a, pristi vahe'mo'a ana ve sipisipi afu'ene mago kapu olivi masave erino Ra Anumzamofo avuga eri veravehu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Hagi pristi vahe'mo'a kefozama hu'naza zante kresramna vu ofa, ve sipisipi aheno korama'a tagino tamaga agesa atupare frenenteno, tamaga kaziga azafa azankore frenenteno, tamaga kaziga agamofo agigorera frentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Hagi pristi vahe'mo'a hoga kaziga aza agusafi olivi masavena taginteteno, ");
INSERT INTO kbq_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","tamaga kaziga azankoreti ana masavempi areno 7ni'a zupa Ra Anumzamofo avuga rutri tri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Hagi aza agusafima mago'a masavema me'nefintira ko'ma kefozama hu'nere'ma ofama hu'nea afumofo korama frentenere, tamaga kaziga agesamofo atumpareki, tamaga kaziga azankoreki, tamaga kaziga agafa agigoreki, huno frentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Hagi pristi vahe'mo'a aza agusafima mago'ama me'nia masavema'a ana vahe'mofona kumimofo nona huno asenifi frenteno Ra Anumzamofo avuga azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hagi pristi vahe'mo'a ana tare namafinti'ma maho namao, kugofa namama avreno esifinti kresramna vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Mago nama kumite kresramana nevuno, magora tevefima kre fananehu kresramna vu witine erinteno kregahie. E'inahukna kante pristi vahe'mo'a agru'ma osu'nesia vahe'mofo agira erino, Ra Anumzamofontera kumi nona hanigeno, anamo'a agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ama'i avufafima fugo namuma re'nesia vahe'mo'ma ante'nesia avamente erino esigeno'ma azeri agruma hania zamofo trake. ");
INSERT INTO kbq_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ra Anumzamo'a anage huno Mosesene Aroninena znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Tamagrama erisanti haregahazema hu'na tamisua mopafi Kenenima vanage'na, mago'a nona azeri haviza hanena ana nomo'ma tontore'na, ");
INSERT INTO kbq_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ana nomofo nefa'a vuno pristi vahe ome zamasamino, noni'afina tontore avame'za fore hu'ne huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Hagi pristi vahe'mo'a ana nompina efreno rezaganeno onke'neno, ana nomofo venafona hanigeno makazana eri fegi atretenkeno, pristi vahe'mo'a henka ufreno ana nona kegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Hagi pristi vahe'mo'a ana nompima ufreno rezageno'ma kesiama zafaninage zano, korankre zamo'ma fore'ma huno hanagatino fre'nesigeno'a, ");
INSERT INTO kbq_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ana nompintira pristi vahe'mo'a atiramino ana nonkafana erigino, ahe kanirentesigeno 7ni'a zagegna megahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Hagi 7ni'a zage gnama manitesigeno'a, pristi vahe'mo'a ete eno eme kesiama, ana tontomo'ma ana nomofo asoparegama rurama huno vuno eno'ma hu'nena, ");
INSERT INTO kbq_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","pristi vahe'mo'a mago'a vahe huzmantesige'za ana tontoma manesi'a havea ana nontetira eri keri'za kumamofo fegu'a agru'ma osu'nefi ome atregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Hagi ana tontomo'ma me'nenia nomofo asoparega havema azerinogu'ma rukamarente'naza zantamina vazagate'za eri'za rankumofo fegi'a agruma osu'nefi ome atregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hagi anama krima me'negeta eritraza haveramimofo nontera, ru have eri'za eme runekamare'za, ana havema azeri'zana kasefa hapa ati'za erihapa hu'za rukamrenteho. ");
INSERT INTO kbq_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Hagi anama hutesagenoma henkama ana tontoma fore'ma hina, ");
INSERT INTO kbq_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ete pristi vahe'mo'a vuno mago'ane omegeno. Ome kesigeno ana nonte'ma tontomo'ma rurama hu'nena, nomo'a haviza hu'neankino agru osu'ne huno hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Hagi ana noma ki'nesia havema, zafama, rekamre'nesaza zana tapage hu'za eri'za kumamofo fegi'a agruma osu'nefi ome atreho. ");
INSERT INTO kbq_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Hagi kahama eriginesia kna'afima ana nompima ufresimo'a, agru osu mani'nenigeno vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Hagi anahunkna huno iza'o, ana nompima mase'nimo'a kukena'a sese nehanigeno, iza'o ana nompima ne'zama nesimo'a, kukena'a sese hino. ");
INSERT INTO kbq_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Hianagi ana noma eri fatgo hutesageno'ma pristi vahe'mo eme kesigeno, ana tontoma orenenigeno'a ana nonkura kria omane'neanki, agru hu'ne huno pristi vahe'mo'a hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Hagi ana noma azeri agruma hunakura, pristi vahe'mo'a tare namarare nevreno, sida zafa e'nerino, koranke nofi enerino, hisopu zafa azankunatetiki huno azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Hagi mago nama zasi ti me'nenia mopa kavomofo agofetu agra ahenigeno, koramo'a ana kavofi avitegahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Hagi anama hutesuno'a, sida teve zafa atupa'agi, hisopu zafa azankunaki, korankre nofiki, mago'ma kasefa huno mani'nea nama anama korama me'nea timpi reteno atisga huno, ana nomofona 7ni'a zupa rutri tri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","E'ina hukanama huno timpima me'nea namamofo korantetiki, kasefa'ma mani'nea namaretiki, sida zafaretiki, hisopu zafa azankunaki, korankre nofitetiki, huno ana noma azeri agru hutesuno'a, ");
INSERT INTO kbq_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","kasefa'ma huno mani'nea nama avreno kuma'mofo fegia ometresigeno hareno vugahie. E'ina huno pristi vahe'mo'a havizama hu'nesia nomofona nona huno azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ama fugonkri eri'nesazo, zuka kri eri'nesaza zamofo tra ke, ");
INSERT INTO kbq_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","kukenare tontore'nesio, nonte tontore'nesio, ");
INSERT INTO kbq_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","zamavufagamo zorenegeno kirareki namu fore hu'nenio, efeke kirere eri'nesaza, ");
INSERT INTO kbq_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","vahe'ma rempima huzamisage'za zamagra'ama agru hu'neanki, agru osu'neanki hu'zama rezagnezama kesaza zamofo tra ke. Ama'i fugo krimofo tra ke. ");
INSERT INTO kbq_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ra Anumzamo'a anage huno Mosesene Aroninena znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Tanagra Israeli vahera zamasamiho, mago ne'mofoma agozafinti'ma efeke avo'ma haniana, e'i agrua osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Hagi vemofoma agozafinti avo'ma atirami vava hanio, avimarekama renkaniresigeno avufarima eovaniana, agra agru osu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Hagi ana krima eri'nesia ne'mo'ma masesia tafemo'a maka agru osanigeno, maka manisia tra'mo'enena agrua osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Hagi ana krima eri'nesia ne'mofo tafe'ma avako'ma hanimo'a, agrua osugahiankino, kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Hagi iza'o ana kri ne'mo'ma mani'nesia zante'ma avako'ma hania vahe'mo'a, agrua osugahiankino kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Hagi ana krima eri'nesia vahe'ma avako'ma hania vahe'mo'a, ana zanke huno agrua osugahiankino, kukena'a timpi sese nehuno, maninesigeno vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Hagi ana krima eri'nesnia ne'mo'ma agruma hu'nenia vahe'ma avetu'ma ahentesiana, anazanke huno agrua osugahiankino, kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Hagi ana krima eri'nesia ne'mo'ma hosi afu agofetu'ma ante'za manizama nevaza tafete'ma (satel) manino vanigeno'a, anazamo enena, agrua osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Hagi ana kri ne'mo'ma agofetu'ma mani'nenia zantamimo'a miko agru osu'ne. Iza'o avako'ma huno erino vanimo'a, agrua osugahiankino, kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Anahukna huno anankri'ma eri'nesia ne'mo'ma azama timpi sese osu'neno, agruma hu'nenia vahe'ma avakoma hanimo'a, agrua osugahiankino, kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Hagi ana krima eri'nenia ne'mo'ma avako'ma hu'nesnia mopa kavoa takohu netreta, ne'zama atino ne'zantamima zafare'ma tro hu'nesia zantamima avako hu'nesia zana timpi sese hiho. ");
INSERT INTO kbq_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Hagi ana ne'ma agozafintima namureno avo'ma nehiazama atrente'na, 7ni'a zagegnama evanigeno'a kukena'a enevania timpi sese nehuno, tina freno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Hagi 8kna zupa tare maho namarareno, tare kugofa namarare avreno atruhu seli nomofo kahante Ra Anumzamofo avuga, pristi vahe eme aminageno, ");
INSERT INTO kbq_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","pristi vahe'mo'a ana namararena avreteno, magomofona kumite kresramna nevuno, mago'mofona tevefima kre fanane hu ofa hugahie. Hagi pristi vahe'mo'a ana krimofo nona huno Anumzamofo avuga ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Hagi mago ne'mo'ma mase'nena agozarima esiana agru osugahiankino, ti freteno mani'nena vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Hagi ana ne'mofo avufga rimo'ma kukenare avako huge, bulimakao akruteti'ma tro hu'nesaza kukenare'ma avako'ma haniana, agrua osugahiankino, timpi sese huteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Hagi mago vemo'ma mago a'enema monko'zama hanuno'a, timpi tina freteke agru osu mani'nenakeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Hagi mago a'mo'ma ikankrima eri'siana agru osu mani'nenigeno 7ni'a zagegna evugahie. Hagi iza'o ana ika krima eri'nesia a'ma avako'ma hanimo'a, agru osu mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ana a'mo'ma tafe'ma masino nemasesia zamo'o, tra'ma anteno nemanisia miko zama'amo'a, agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Hagi ana ikankrima erinesia a'mo'ma mase'nesia tafe'ma avako'ma hanimo'a, agru osugahiankino kukena'a sese nehuno, ti freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Hagi ana krima eri'nesia a'ma nemanisia zama avako'ma hanimo'a, agrua osugahiankino, kukena'a timpi sese nehuno, tina freteno mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Hagi ana krima eri'nesia a'mo'ma nevasesia tafero, nemani'nea tra'ma avako'ma hanimo'a agru osugahiankino, agru osu mani'nenkeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Hagi ikankrima eri'nesnia a'enema monko'zama hania ne'mo'a, ana krimo azeri pehena hugahiankino, ana ne'mo'a 7ni'a zagegnafi agru osu manigahiankino, ana mase'nea sipamo'enana agrua osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Hagi ana ikankrima eri'nea a'mofoma ana kri'amo'ma zazate'ma menoma ikankrima vagama nereanknama agateresiana, ana a'mo'a agrua osu manino vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Hagi ana korankri'ma eri'nenoma manino vania kna'afima masesia tafero, manisia tra'mo'enena agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Hagi anahukna huno iza'o, ana krima eri'nesia a'mofo tafe'ma avako huge, nemanisia zama avako'ma hanimo'a, agrua osugahianki kukena'a sese nehuno, ti freno mani'nenkeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Hagi ana a'mofoma kri'amo'ma atrentenkeno'a, krima atrentenia knaretira 7ni'a gna maniteno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Hagi 8 knazupa tare maho namarareno, tare kugofa namararena avreno atruhu seli mono nomofo kafante pristi vahe ome amigahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Hagi mago nama pristi vahe'mo'a kumi' apase ofa nehuno, mago nama tevefima krefanane hu ofa hugahie. E'inahu kante korankrima e'rinea zantera pristi vahe'mo'a aza huno Ra Anumzamofo avuga nona huno ofa hanigeno, azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Hagi Israeli vahera zamazeri ruotage huge'za, agru osu zanena aru havia hu'za mani'ne'za seli mono nonimofona eri havizana osugahaze. Hagi zamagrama ana'ma hu'za mani'ne'za seli mono noni'a eri pehanama, hanage'na zamahe frigahue. ");
INSERT INTO kbq_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Hagi ama'i venenemofoma agozafinti'ma avufga rima esia zamo'ma azeri pehana haniazanki, ");
INSERT INTO kbq_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","a'nemokizmi ikankrimo'ma zamazeri pehana hu'nesiazanki, a'nemofono venenemofono oku avufgafintima avoma nehania zamofone, ikankrima eri'nesia a'enema mase'nesia vahe'enema azeri pehanama hania zamofo trake. ");
INSERT INTO kbq_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Hagi Aroni ne' mofavre'moke'ma Ra Anumzamo'ma Mosesema asmi'nea kema rutagreke i'oma hu'nea teveretima ofama hakeno znahe friteno, ");
INSERT INTO kbq_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ra Anumzamo'a amanage huno Mosesena asami'ne, Negafu Aronina asamigeno ruotagema huno ruotagetfama hu'nefinka hunaraginte'nea tavravemofo amefima huhagerafi huvempage vogisimofo avaza'a, asunku trarema nehaza tra'ma me'nerera ahe frigahuanki, amanenena agra'a avesitera omeno. Na'ankure Nagra ana asunku tratera hampompi eramina eama nehue. ");
INSERT INTO kbq_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Hagi ruotage huno ruotagema hu'nefinka Aroni'ma ufrenaku'ma hanuno'a, agaho ve bulimakao afu avreno kumitera ome kresramna nevuno, agaho ve sipisipi avreno tevefima kre fanane hu ofa ome hino. ");
INSERT INTO kbq_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Hagi anampinkama ufrenaku'ma hanuno'a, tifreno agra'a avufga sese huteno, ruotage'ma hu'nea efeke za'za kukena'a nehuno, agu'afima avufgare'ma antani efeke kukena'a nehuno, anantera afafafima amu'nofima hu efeke tavravereti afafafina ananekino, asenire'ma ki efeke tavravereti asenirera kino. Hagi e'i ana kukena ruotage hu'neankino tifreteno antanigahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Hagi Israeli vahe'mo'za tare ve meme afutrena kumite'ma kresramna vu'zana nevre'za, mago ve sipisipi afu tevefima krefanane hu ofa hu'zana avre'za Aroninte eho. ");
INSERT INTO kbq_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Hagi Aroni'a agra'a kumite'ene, noma'afima nemaniza nagamofo kumite'enena mago ve bulimakao kresramna vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Anama hutesuno'a ana tare ve meme afura avreno Ra Anumzamofo avuga atrumahu seli mono nomofo kafante eno, ");
INSERT INTO kbq_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ana tare meme afutrentera taisi zokago reno kesigeno, Ra Anumzamofo agima me'nea suzama efore hanigeno'a, anama Ra Anumzamofo agima fore'ma hania meme afukura Ra Anumzamofo su'zane nehuno, magora Asaseli su'zane hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Hagi Ra Anumzamofo su'zanema hania meme afura, Aroni'a avreno Israeli vahe'mokizmi kumite ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Hagi Asaseli su'zane huno'ma hu'nenia meme afura, avu'aga avreno Ra Anumzamofo avuga eno kumite nona huteno, ana meme afura avreno ome atrenkeno, ka'ma kopi Israeli vahe'mokizmi kumira erino vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Hagi anama hutesuno'a, Aroni'a agra kumite'ene naga'amofo kumite nonama hu ve bulimakao afura aheno kumite kresramna vu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Hagi Ra Anumzamofo avugama me'nea kresramna vu itareti tanknuza tevea kavofi hanagenenteno, mananentake'zana insensia tare aza huno erino, hunaraginte tavravemofo amefi'a ruotage'ma hu'nefinka vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Hagi Ra Anumzamofo avuga ana mananentake insensia tevefi krenkeno toki'amo'a huhagerafi huvempage vogisimofo avaza'a asunku trarema nehaza trara refitenkena ahe ofrineno. ");
INSERT INTO kbq_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Hagi ana ve bulimakao afu'mofo korampi azanko reteno, huhagerafi huvempage vogisimofo avazagu'ma asunku trarema nehaza tra'mofona, zage hanati kaziga asoparega 7ni'a zupa rutri tri hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ana huteno Aroni'a Israeli vahe'mokizmi kumite'ma kresramna vu meme afura aheno, korama'a tagino hunaraginte'nea tavravemofo amefi'a ruotage huno ruotagetfama hu'nefinka bulimakao afumofo korama hu'neaza huno, ana korana asunku tra'mofo avuga rutri tri hino. ");
INSERT INTO kbq_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","E'inahukna kanteke ruotage huno ruotage'ma hu'nefinke hu'zama hunaraginte nona azeri agru hugahie. Na'ankure Israeli vahe'mokizmi kumizamimo ana nona eri haviza hu'ne. Ana hukna kanteke kumi'mo'ma amu'nontamifima atruhu seli mono'ma eri pehanama hu'neana eri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Hagi ruotage huno ruotage'ma hu'nefinkama Aroni'ma, agra'a kumimofone, naga'amofo kumiku'ene, Israeli vahe'mokizmi kumimofonte'ma nona huno ofa hunaku ufre'nesigeno'a, mago vahe'mo'e huno atruhu seli mono nompina omani'nenkeno, ofa ome huteno atiramino eno. ");
INSERT INTO kbq_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Hagi ana'ma hutesuno'a atiramino eno Ra Anumzamofo avugama me'nea kresramna vu itare, kumimofo nona huno ofa huteno, ve bulimakaomofo korane mememofo koranena erino kresramana vu itare me'nea pazivetamintera frentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Hagi Israeli vahe'mo'za haza kumimo'ma kresramana vu itama azeri pehana hu'nea zana, ana korampi azanko reteno, 7ni'a zupa ana itarera rutri tri huno azeri agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Hagi ruotage huno ruotage'ma hu'nefinkane, atruhu seli mono none, kresramana vu itanema Aroni'ma azeri agru hutesuno'a, anama amnema mani'nea meme afura seli nomofo avuga avreno eno, ");
INSERT INTO kbq_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","asenirera tarega azana Aroni'a anteno, Israeli vahe'mokizmi kumizmia ana afumofo agumpi hu hatazafenteteno, ana meme afura huhamprinte'nesia vahe aminkeno, avreno ome atrenkeno ka'ma kopi Israeli vahe kumira erino vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Hagi ana meme afu'ma ka'ma kopima ome atresigeno vaniana, miko Israeli vahe kumira erino ka'ma kopi vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aroni'ma ana eri'zama erivaretesuno'a, ete atruhu seli mono nompi ufreno ruotage huno ruotagetfama hu'nefinkama ufre'naku'ma antani'nea efeke kukena ome hatentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Hagi ruotage'ma hu'nefinka Aroni'a tina freteno, ko'ma antani'nea kukena eri huteno, atiramino eno agra'are ene Israeli vahe'mokizmi kumimofo nona huno kre fanene hu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Anantera kumi ofama hu'nea bulimakaone, meme afu'mofo afova'a kresramna vu itare kre fanane hu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Hagi Asaseli suzane huno ka'ma kopima meme afu'ma avreno vanimo'a, ti freno kukena'a sese huteno, henka kumapina efregahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Hagi korama'a tagino ruotagema huno ruotage'ma hu'nefinkama kumimofo ofama hu'nea bulimakaone, meme afu'mofo, akru'agi, ame'agi, rifa'anena kumamofo megi'a tevefi ome kreho. ");
INSERT INTO kbq_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hagi ana zama eri'noma ome kresia vahe'mo'a, kukena'a sese nehuno timpi tina freteno kumamofo agu'afina efreno. ");
INSERT INTO kbq_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hagi ama'i mevava hania trake, tamagrane emani vahe'enena kafugu kafugura 7ni ikamofona 10ni knazupa nezane makazana a'o nehuta eri'zana e'oriho. ");
INSERT INTO kbq_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Na'ankure ana knarera kumima apaseramanteno tamazeri agruma hu ofa hanigeno, tamazeri agru hina Ra Anumzamofo avufina agru huta manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hagi ana kna mani fruhu kna zupa Sabatigita ne'zane maka'zanena a'o huta mani'neta eri'zana e'origahaze. Ama mevava trake. ");
INSERT INTO kbq_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Hagi henkama fore hu anante anante hu'za esaza vahepinti, nefa noma erino pristi eri'zama erisiegu'ma huhamprinte'nimo, ruotage'ma hu'nea zaza kukena nentanino, kumite'ma nona hu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Hagi ruotage huno ruotage'ma hu'nefinkane, atruhu seli mono none, kresramana vu itane, pristi vahe'ene maka Israeli vahe'mofo kumite nona huno ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ama'i Israeli vahe'motama maka kafufima magoke knare'ma hanaza zankino, mevava trake. Mosese'a miko Ra Anumzamo'ma hunte'nea tra kea amage anteno huvare'ne. ");
INSERT INTO kbq_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Aronine, mofavre naga'ane, maka Israeli vahera Ra Anumzamo'a amanage hie hunka zamasamio, ");
INSERT INTO kbq_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mago Israeli vahe'mo'ma bulimakao afupi, sipisipifi afu'ma, meme afu'ma kuma agu'afino, fegu'ama aheno'ma kresramna nevuno, ");
INSERT INTO kbq_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ana bulimakao afupi, sipisipi afupi, meme afuma erino atruhu seli mono nomofo kafante'ma Ra Anumzamofo avugama omesiana, e'inahu vahe'mo'a kora eritagino kumi hu'neankino, kuma agu'afintira ahenatitregahie. ");
INSERT INTO kbq_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ama'na agafare ana zana hugahaze, Israeli vahe'mo'za amane megi'a kokampi ofazimia kresramna nevazankiza, menina kresramna vu ofazimia eri'za atruhu seli mono nomofo kafante Ra Anumzamofo avuga pristi vahete esageno, agra erino arimpa fru ofa Ra Anumzamonarega hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Hagi atruhu seli mono nomofo kafante'ma kresramna vunte itama Ra Anumzamofo avugama me'nere, pristi vahe'mo ana korana rutri tri hunenteno afova'a tevefi kresigeno Ra Anumzamo'na mna'a nentahina musena hugahue. ");
INSERT INTO kbq_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Zamagra meme afu havi anumzante kresramna vunente'za, a'ne'mo'za savari hu'za monko avu'ava nehazankna osugahaze. Hagi ama'i mevava trake me'nena henkama fore hunante anante'ma hanaza Israeli vahe'mo'za amage antegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Anantera anage hunka zamasamio, Israeli vahepintiro ru vahe'ma tamagranema emani'nenaza vahe'mo'zama ofama nehu'za, ");
INSERT INTO kbq_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","atruhu seli mono nomofo kafante Ra Anumzamofonte'ma eme kresramna ovanimofona, Israeli vahepintira ahenatitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Israeli vahepintiro rurega vahe'ma enemanisia vahe'mo'zo korama nesage'na, Nagra anama korama nesia vahera namefi hunemi'na vahe'niafintira ahenatitregahue. ");
INSERT INTO kbq_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Na'ankure korampi asimu'ma erino mani'zana me'ne. Ana hu'negu kumite'ma nona huno apasente'zana koranuti Nagritera ofa hugahaze. E'ina hu'neankino koranuti kumimofo nona huno asimura amigahie. ");
INSERT INTO kbq_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","E'ina hu'negu Israeli vahe'ene ruregati vahe'ma tamagranema emani'naza vahe'motanena korana oneho hu'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Israeli vahe'mo'zo ruregati vahe'ma tamagranema emani'nesaza vahe'mo'zanema zagagafao namama ahe'za nesu'za, korama'a mopafi tagitre'za mopanu refiteho. ");
INSERT INTO kbq_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Na'ankure asimu'ma anteno mani'nea zagaramimofona asimura korampi me'ne. E'i ana agafare Israeli vahekura korana oneho hu'noankino, iza'o korama nesimofona Israeli vahepintira ahegasopegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Hagi Israeli vahero, ruregati vahe'ma tamagranema emani'nesaza vahe'mo'zama fri'nesia zagagafao, afi zagagafamo aheno traga hu'nesia zagagafama nesimo'a, kukena'a sese nehuno, timpi ti freteno agru osu mani'nenkeno vuno kinagasenkeno agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ana hu'neanagi kukena'ama sese osuno, timpima tima ofresimo'a, agra'a anazamofo knazana erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ra Anumzamo'a Mosesena anage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Israeli vahera zmasimio, Nagrake Ra Anumzana tamagri Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hagi ko'ma Isipi mani'nage'za Isipi vahe'mo'zama hu'naza avu'ava zana osuge, menima Nagrama Kenani tamavre'na vanugeta umani'naza mopafi vahe'mo'za hanaza avu'avara zamavaririta osiho. ");
INSERT INTO kbq_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Miko trakeni'a amage nenteta, kegava hiho. Na'ankure Nagrake Ra Anumzana tamagri Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Nagri tra kene kasegeniama amage'ma tamagrama antesazana, anazamo'a tamasimu tamigahie. Nagra Ra Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tamagra'a kora naga nofipina monko avu'ava zana osugahaze. Na'ankure Nagra Ra Anumzane. ");
INSERT INTO kbq_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Negrera'enena monko avu'ava zana osuo, agra kagri negrera'e. Hagi e'inama hanunka negafana agaze erimigahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Negafa a'enena monko avu'ava zana osuo, e'inama hanunka negafana agaze erimigahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Hagi negasaro eneno, negafano negarera mofa'eneno, negsaroma ru nagapima mani'nesia mofa'enena monkozana osuo. ");
INSERT INTO kbq_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Hagi mofakamofo mofaro, ne'kamofo mofa'enena negagehoki monko'zana osuo, e'inama hanana kagraka'a kazeri haviza hugahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Negafa a'nemo'zama kasezmante'nesaza mofananea, negasarozagi monkozana huozamanto. ");
INSERT INTO kbq_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Negafa nesaro'enena monkozana osuo, agra negafana nesarokino, negamomo mani'ne. ");
INSERT INTO kbq_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Negrera anunkna he'zanena monko'zana osuo, na'ankure zamagra negrerana korama'a mani'naze. ");
INSERT INTO kbq_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Negafa afu'aganahe a'enena monkozana osuo, e'inama hananana negafa afu'aganahe'ina zamagaze erizamigahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Negamofo a'enena monko'zana osuo, na'ankura agra negamofo a'kino neganofero'e. ");
INSERT INTO kbq_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Nempukamofono negagna a'enena monkozana osuo, na'ankure agra koranka'amofo a'kinka nempukamofono negagnana azeri haviza hugahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Hagi mago a'ma erinenana a'mofo mofa'enena monko'zana osuo. Hagi ana a'mofo agehe'inena monko'zana osuo, na'ankure zamagra negagehozaginka kefozantfa hugahane. ");
INSERT INTO kbq_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Mago a'ma antenankeno ofrino mani'nena ana tapina, ete nenunknana ara e'orio krunoregaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Namunka mani'neno agru osu'nesia a'enena monko'zana osuo. ");
INSERT INTO kbq_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ru ne'mofo a'enena monkozana hunka, kagra'a kazeri pehana osuo. ");
INSERT INTO kbq_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Hagi Moreki havi anumzantera mofavreka'a ahenka kresramna nevunka Anumzanka'amo'na nagi'a erihaviza osuo. Na'ankure Nagra Ra Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Hagi vene'nemo'a vene'nenena monkozana osino, na'ankure kasrino himna vu'nea kumi hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Hagi zagagafanena monko'zana vahe'mo'a osinkeno, a'nemo'za zamagra'a zamavufaga ve zagagafa zaminage'za monkozana hu ozamanteho, haviza huno kasri'nea kumi hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Amanahukna tamavu tamava huta tamagra'a tamazeri havizana osiho, Na'ankure ko'ma ama ana mopafima mani'naza vahe'ma zamahenatisua vahe'mo'za ama ana zamavu'zmavaza hu'za zamagra zamavufaga zamazeri haviza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Na'ankure ama ana agafare mopamo'a havizana hu'ne. E'ina hu'negu ama mopafinti vahera zamazeri haviza hanena, mopamo'a amuti zamatregahie. ");
INSERT INTO kbq_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Hagi tamagra miko'a kasegeni'ane, trakeni'a kegava hu'neta amage nenteta, ama ana kasri avu'ava zana tamagrane, rurega vahe'ma tamagranema emani'naza vahe'mo'zanena osiho. ");
INSERT INTO kbq_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Na'ankure ko'ma ama mopafima mani'naza vahe'mo'za, ana kasri avu'ava hazageno mopamo'a hi'mnavu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Tamagrama ama ana mopama eri havizama hanageno'a, ko'ma ama ana mopafima mani'naza vahe'mo'za mopama eri havizama hazageno amuma atizamatre'nea kna huno amu ati tamatregahie. ");
INSERT INTO kbq_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hagi ama anahu kasri avu'ava'ma hania vahera, Israeli vahe'pintira zamahe natitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Anahu'negu kva huneta kasegeni'a amage nenteta, ko'ma ama anampima mani'naza vahe'mo'zama hu'naza kasri zamavu'zamavara nosuta, tamagra zamagranena ruhavia huta mani'neta tamagra'a tamavufga eri pehena osiho. Nagrake Ra Anumzana tamagri Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ra Anumzamo'a amanage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Ama nanekea Israeli vahera zamasamio, mani ruotage huta maniho, na'ankure Ra Anumzana tamagri Anumzamo'na ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Mago magomota tamarera tamafa ke antahita agoraga'a nemanita, Sabatia mani fruhu kna kegava hiho. Nagra Ra Anumzana tamagri Anumzane. ");
INSERT INTO kbq_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Kaza osu havi anumzantera tamentintia osuge, tamagra ainiretira kreta havi anumzantamia trora osiho. Nagra Ra Anumzana tamagri Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Rimpa fru ofama Ra Anumzamofonte'ma kresramna nevanutma, kasege avariritma fatgo huta ofa hinke'na musena ha'neno. ");
INSERT INTO kbq_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Anama ofama hanaza ne'zana ana knare'ene anante knareke neho. Hagi nege atrege'ma hanaza ne'zamo'ma tagufa knama mesia ne'zana erita kre fanane hiho. ");
INSERT INTO kbq_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Hagi tagufa knama mesia ne'zamo'a haviza hugahiankino, ana ne'zama nesimo'a agru osugahiankino, Ra Anumzamo'a musena huontegahie. ");
INSERT INTO kbq_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Iza'o ana ne'zama nesimo'a ruotage hu'nea ne'zankino Ra Anumzamofo agi'a eri haviza hugahiankino, vaheni'afintira ahenatitregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Hagi hozatamifinti'ma ne'zama nehamaresuta refaregama me'nesiama'a netreta, nehamaresage'noma evuraminiama'a zo'onkita atrenkeno meno. ");
INSERT INTO kbq_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Hagi waini rgama ko'ma tagita vutesuta, ete eta mago'anena eme oragige, tagita nevanageno mopafima evuramisiama'a zoraonkita, atrenke'za zamunte omane vahero, rurega vahe'ma tamagranema enemanisaza vahe'mo'za zogiho. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Tamagra kumazafa oseta, havige havage huta rumofozana avazua osuta, rumokizmia havigea huozmanteho. ");
INSERT INTO kbq_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Hagi havigea huta Nagri nagirera huvempa huta kea osiho, ana'ma hanuta tamagra'a Anumzamofo agi eri haviza hugahaze. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Hagi iza'o tavaontamire'ma nemanisimofona azeri havizana nehuta, kumazafa seta nanazazmia e'oriho. Zagore'ma eri'za eri'nesia ne'mofo zagoa azerigeno zazatera kagranena me'nenkeno hanina huno nanterana oseno. ");
INSERT INTO kbq_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Zamagesama ankanirenesia vahera huhavizana huozamantege, zamavu asuhu vahera zamazeri tanafa hania zane huta kampina onteho. Hagi tamagra'a Anumzamofo korora hunteho. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Keagama refko hu trate'ma keagama refkoma hanazana afufenozimi omne nesnia vahetega antege, afufenozimi me'nesnia vahetega antegera osutma, mago avamenteke refko huzmanteho. ");
INSERT INTO kbq_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ru vahe'mofo amefi agenkea huta vano osu tava'ontamire nemanisimofoma keagama hunentesagenka, azahunka keaga huga'ma hu'nesigenka amne aza hunka hugahane. Na'ankure Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Hagi negafuna kagu'afina antahi havizana huontenka, havizama nehanigenka ana havi avu'avazama'a eri ama hunka haviza nehane hunka azeri fatgo huo. Ru antahi haviza huntesunka kumi hugahane. ");
INSERT INTO kbq_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Hagi havi avu'ava'ma hugantesia zante'ma nonama hu kankura ohakenka, kagragu'ma kavesintanaza hunka rumofona kavesinto. Nagra Ra Anumzamo'na nehue. Hianagi tava'onkare'ma nemanisimofona kagragu'ma kavesintana kna hunka avesinto. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Tamagra tra keni'a amage'anteta, magopina ruzahu ruzahu zagagafa kegava hu'nenkeno ru zagagafamo'a ru zagagafa oharareno. Magoke hozafina ru avimzana ru avimzana oseho. Tare nofitetima hatino tro'ma hu'nesia kukena ontaniho. ");
INSERT INTO kbq_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Hagi kazokzo eri'za mofa'ma mago nete'ma manigahiema hu'nesia mofa'ma anteno mase'nia ne'mofona, ahe ofriho. Na'ankure ana mofara miza osazageno, eri'zama'afintira katufeno fru huno omani'ne. ");
INSERT INTO kbq_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hagi ana'ma hania ne'mo'a ve sipisipi afu avreno, atruhu seli mono nomofo kafante kefozama hu'nea zantera Ra Anumzamofontera ome ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Hagi anama avreno'ma esia sipisipia, pristi vahe'mo'za ahe'za Ra Anumzamofontera kumi'a apasente ofa hinkeno, ana nera kumi'a Ra Anumzamo'a atrentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Hagi ana mopare'ma umanisuta, ese 3'a kafufina, rgama rente zafama krisaza zafamofo raga tagita oneho. ");
INSERT INTO kbq_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Hagi nampa 4 kafufima rentesia zafa rgaramina ruotage hugahiankita, mika erita Ra Anumzamofo Ra agi ami ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Hagi nampa 5fu kafufima rentesia zafa raga negahaze. E'inahu hanageno ne'zamo'a rama'a hugahie. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Korama me'nenia ame'a oneho. Zagoma reno ke avu'ava zana osuge, afa avu'ava zana osiho. ");
INSERT INTO kbq_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Hagi kagesa tavaonte'ma me'nea kazoka'ene kagemazampa kazokara ase rampagera osuo. ");
INSERT INTO kbq_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Hagi frisia vahetera kasunkura hunka kavufga taga osuo. Hagi kavufga taga hunka avona onkro. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Mofanetami'a zamatrenke'za mizantera monko avu'ava zana osiho. Ana'ma hanazana monko avu'avazamo'a avitenkeno, ama mopamo'a haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Hagi mani fruhu knani'a Sabatia kegava nehuta, seli mono noni'a kegava hiho. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Hagi iza'o fri'nea vahe'enema keaga nehanaza vahetero, havi avamu'enema keagama nehanaza vahetera, vuta knare antahintahigura ome zamantahi onkeho. Tamagra'a tamazeri haviza hugahaze. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Hagi ranra vahe'mokizmi kea antahizamita eri'zafa nehuta, Nagri agorga'a maniho. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Hagi tamagri mopafima rurega vahe'ma emani'ne'naza vahera, zamazeri havizana osiho. ");
INSERT INTO kbq_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hagi miko vahe'ma antahi zaminankna hunka antahi neminka, kagra'agu'ma kavesinentanankna hunka avesinto Tamagesa antahiho, Isipia e'inahukna huta rurega vahe umani'nazane. Nagra tamagri Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Hagi vahe'mofozama sigerima huta kna'ama kesazano, zaza'ama mesarimima hanazano, afiviteta kesazana havige kazigatira anara osiho. ");
INSERT INTO kbq_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hagi sigeritamimo'ene mesarimima hu zantamimo'a fatgo huno meno. Hagi ne'one zantamima refakohu tamavutamavamo'a, fatgo huno meno. Nagra Isipiti'ma tamavre'na e'noa Ra Anumzamo'na tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Hagi miko tra keniane, kasegeni'anena amage anteho. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ra Anumzamo'a anage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Ama'na trakea Israeli vahe'mokizmia zamasimio, Israeli vahe'mo'o rurega vahe'ma tamagranema emani'nesaza vahe'mo'za, mofavrezmia Moreki havi anumzamofona omiho. E'inahuma hania vahera have knonu ahefriho. ");
INSERT INTO kbq_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nagra ana vahera ha'renezmante'na, vahe zmifintira zamavare atregahue. Na'ankure agra mofavre'a havi anumzamofo ofa hunenteno ruotage'ma hu'nea noni'a eri haviza nehuno, Nagri nagi eri haviza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Hagi ana kumapinti vahe'mo'zama nege'zama havi anumzama Morekinte'ma mofavre'a kresramna vania nera ahe ofrisazana, ");
INSERT INTO kbq_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Nagra ana vahera ha'renente'na amage'ma ante'zama havi anumza Morekinte'ma mono'ma huntesaza vahe'enena vaheni'afintira zamahenatigahue. ");
INSERT INTO kbq_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Hagi amu'notamifintima mago'mo'ma antahiza aminogu'ma fri'nesia vahe'mofo hankro ene keagaga nehania vahete vuge, monko avu'avazama hiaza huno havi anumzante mono'ma hunentesia vahera, Nagra ha'arente'na vahe'niafintira ahenati atregahue. ");
INSERT INTO kbq_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Anahu'negu tamagra'a tamazeri agru huta mani ruotage huta maniho, na'ankure Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Hagi miko kase keni'a kegava huta nevaririta, agoraga'a maniho, na'ankure Nagra Ra Anumzamo'na tamazeri ruotagera hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Hagi iza'o nerera nefama huhavizama huntesimofona ahefriho. Agra nererane nefanema huhavizama huntesia knazana agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Hagi rumofo a'enema savri'ma hania nera, ana ne'ene anama savri'ma hania a'enena zanahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Hagi nefa nenaro enema savrima hania nera, nefa agi eri haviza hu'negu, anama savrima hania ne'ene a'ene zanahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Hagi nenofero enema savri'ma hania nera, anama savri'ma hana'a a'ene zanahe friho. Na'ankure zanagra kefo zanavu'zanava ha'ankino anazamofo nona'a zanagra'a knazama'a erigaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Hagi venenemo'ma venenenema monkozama hania vahera, kefoza huno kasri'nea kumi hugaha'anki, ana knazamofo kna'a zamahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Hagi mago ne'mo'ma mago a'ene ana a'mofo mofa anema monkozama huzanantesiana, e'inahu avu'ava'ma hu'zamo'a tusi haviza hu'ne. E'i ana avu'ava'ma hanamokizmia tevefi kre tasegenke'za frisageno anahukna avu'avazamo'a tamagripina omaneno. ");
INSERT INTO kbq_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Hagi zagagafanema monko avu'ava'ma hania nera, ahe nefrita ana zagagafa ahefriho. ");
INSERT INTO kbq_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Hagi mago a'mo'ma monko'zama huntesiegu'ma, ve zagafarema vanigeno'ma ana zagagafamo'ma hararesiana, ana a'ene ana zaganena zanahe friho. Na'ankure zanagra haviza hugaha'ankino knazana zanagra 'a erigaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Hagi iza'o nesaroma a'ma erintesimo'a, havizantfa erifore hugaha'anki, vahenifintira znahe anati atregahaze. Agra nesaro'ene monkoza higu, ana knazana agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Hagi ikankrima eri'nesia a'enema monko'zama hania nera, havi avu'avaza erifore hugahiankino, vahenifintira zanahenati atregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Hagi negrera anunkna'hezaneno, negafa asarahehezanena kamomohe'moki, monkozana osuo. E'inama hana'ana havizantfa hugahiankino knazama'a erigaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Hagi nenogo nenaro'enema monkozama hania ne'mo'a, nenogo a'mofo kena'a hategahiankino, havi avu'ava nenogona huntegahie. Hagi ana ne'ene ana a'mo'enena mofavrea onte'neke frigaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Hagi nefu a'ma rehanaresia ne'mo'a, havi avu'ava huno nefu a'mofo kena'a hategahiankino mofavre ontegaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","E'ina hu'negu kva hu so'e huneta, miko kasegeni'ane tra keni'a amagera anteta agorga'a maniho. Ana'ma osanageno'a anama tamavre'na vanua mopamo'a amu'ati tamatreankna hanigeta knarera huta ana mopafina omanigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Hagi anama vanaza mopafima ko'ma mani'naza vahe'ma zamahenati atresua vahe'mokizmi zamavu'zamava zana osiho. Na'ankure anama vanaza mopafi vahe'mo'za kefoza huno kasri'nea zamavu'zamava nehazage'na nagote'na navesra huzmante'noe. ");
INSERT INTO kbq_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Hianagi vahe'mokizmi amu'nompinti Nagra Ra Anumzana tamagri Anumzamo'na tamavre'na ko huvempa hurmante'na erisanti haregahaze hu'noa mopagino, ana mopafina tumerimo'ene amirimo'a avite'nea mopa erigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","E'ina hu'negu refkohu so'e huta negeta, e'i zagagafamo'a agru hu'neanki, e'i zagagafamo'a agru osu'neanki, e'i namamo'a agru hu'neanki, e'i agru osu'neanki hiho. Hagi agruma osu'nesia zagagafo, namaramino, zmasaguregati'ma regrorohe'za vanoma nehaza zagaraminena, neneta tamagra'a tamazeri havizana osiho. ");
INSERT INTO kbq_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Tamagra mani ruotage huta Nagri vahe maniho, na'ankure Nagra Ra Anumzamo'na ruotage hu'nogu miko kokankoka vahepintira Nagri vahe maniho hu'na tamagrira tamazeri ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Hagi mago ne'mo'o a'mo'ma fri'nea vahe'eneno kefo avamu'enema keagama hania vahera zamahe friho. Zamagri korankumimo'a zamagripi megahianki havenknonu zamahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ra Anumzamo'a Mosesena amanage huno asmi'ne, Pristi ne' Aroni mofavre nagara amanage hunka zamasamio, pristi vahe'mo'a vahe'afima mago vahe'ma frisigeno'a, vahe'ma frige'za nehaza zana hu'za zamagra'a zamazeri pehana osiho. ");
INSERT INTO kbq_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Hagi nerera'o nefa'o ne' mofavre'o mofa'amo'o afu agana'o, ");
INSERT INTO kbq_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ve e'orino vene omasenesia nesaroma agranema nemanisigeno amema rentinti huno nemanisimo'ma frisigeno'a, amane ana avu'avara avaririgahie. ");
INSERT INTO kbq_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Hagi a'amofo kazigati vahe'ma fri'na ana avu'avara huno agra'a azeri havizana osino. ");
INSERT INTO kbq_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Hagi pristi vahe'mo'za zmasunkura hu'za zamaseni zamazokara oharege, zamagi zamazokara oharege, zamavufaga taga osugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Anumzamo'na nagi'a tamagra eri havizana osuta, mani ruotage huta maniho. Na'ankure tamagra Anumzamo'na ne'zana tevefi ofa kresramna vugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Hagi pristi vahe'mo'za savri huno vanoma nehania a'neo, vema atre'nenia ara e'oriho. Na'ankure pristi vahe'mo'za Anumzamofo avurera ruotage hu'naze. ");
INSERT INTO kbq_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tamagra pristi vahera Anumzamofo vahere hutma zamazeri ruotage hiho, na'ankure zamagra Anumzamofo ne'za ofa hu vaheki, mani ruotage hu'za maniho. Nagra Ra Anumzamo'na ruotage hu'nogu, mani ruotage hutma maniho. ");
INSERT INTO kbq_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Anahukna huno mago pristi vahe'mofo mofa'mo'ma savri avu'ava huno'ma vanoma haniana, nefana azeri agaze hugahianki, azerita tevefi krefanane hiho. ");
INSERT INTO kbq_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Hagi mago'a pristi vahetaminte'ma ugagota hu'nesia pristi ne'ma asenifi masave taginte'za azeri ruotage hanageno, za'za pristi kukenama hu'nesia pristi ne'mo'a fri'nesia vahetera za'za kukena'a tagatora osuno azokara ohareno. ");
INSERT INTO kbq_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hagi Agra'a azeri haviza hugahianki, fri vahe tava'ontera ovino. Nerera'o nefa'enena frisakeno'a ovutfa huge, ");
INSERT INTO kbq_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ruotge'ma hu'nea kumara atreno ovino, na'ankure Anumza ma'amofo huhamprinteno masaventeti asenirera frenteno huhampri ante'ne. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Vugota pristi vahe'mo'a venema omasenenia mofa ara erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Hagi pristi vahe'mo'a kento aro, ve atre'nesia aro, savri avu'ava nehania ara, ara e'orino pristi nagapinti vene ovase'nesia mofa ara erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","E'ina'ma hanuno'a agripinti'ma efore hu anante anante'ma hu'za esaza vahera zamazeri havizana osugahie. Na'ankure Ra Anumzamo'na azeri ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ra Anumzamo'a Mosesena amanage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Aronina asamio, agripintima forehu anante anante hanaza vahepinti'ma zamavufagamo knare'ma osu'nesia vahe'mo'a Anumzamofo ne'zana ofa kresramna ovugahie hunka asamio. ");
INSERT INTO kbq_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Na'ankure avufgamo havizama hu'nesia vahe'mo'a, ruotage'ma hu'nefinka pristi eri'zana e'origahie. Hagi avu asuhu vahe'ma, agamo'ma havizama hu'nenia vahe'ma, avugosamo'ma havizama hu'nesia vahe'ma, agazamo'ma havizama hu'nesia vahe'ma, ");
INSERT INTO kbq_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","agamo'o azamo'ma fri'nenia vahero, ");
INSERT INTO kbq_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","amage'na fagagi vahero, atupa vahero, avu havizahu vahero, namunke namanke vahero, agonknazamo haviza hu'nesia vahero, zmatrenke'za pristi eri'zana e'oriho. ");
INSERT INTO kbq_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Hagi Aroni nagapinti fore hu'nesamoza zamavufagamo havizama hu'nesigeno'a, Ra Anumzamo'narera tevefina kresramna eme vuonanteho. Na'ankure agra avufgamo'a haviza hu'neankino, Ra Anumzamo'narera ofa eme osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Hagi ana vahe'mo'za ruotage huno ruotage'tfama hu'nea ne'zane, ruotage'ma hu'nenia ne'zanema Ra Anumzamonare'ma eri'za esazana amane negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Hianagi avufgamo'a haviza hu'nesimo'a, ruotage'ma hu'nefinka uravao osuge, kresramna vu itarera uravao osugahie. Ana'ma hanuno'a Nagri mono nona eri haviza hugahie. Na'ankure Ra Anumzamo'na zamazeri ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mosese'a ana mika nanekea Aronine mofavre naga'ane, miko vahe'enena zamasmi'ne. ");
INSERT INTO kbq_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ra Anumzamo'a Mosesena amanage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Aronine mofavre naga'anena zamasamio, Israeli vahe'mo'zama nagrite'ma eri'za esaza ofa, ruotage hu'neanki kva hu'neza Ra Anumzamo'na ruotagema hu'nea nagi'a eri havizana osugahaze. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Hagi anage hunka zamasamio, Aroni nagapintima agruma osu'nesimo'a, Nagrite'ma Israeli vahe'mo'zama ofama hunaku eri'za esaza ofamofo tava'ontera erava'o osino, ana'ma hanimofona Nagri navure'ma pristi eri'zama e'neria eri'zampintira ahenati atregahaze. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Hagi Aroni nagapinti pristi vahe'mofoma fugo krima re'nesigeno'o, agoza krima eri'nesigeno avo'ma enevania vahe'mo'a, Israeli vahe'mo'za ofama emema hanaza ne'zana oneno mani'neno agrua hugahie. Hagi magomo'ma fri'nenia zagama avako hanigeno azeri pehanama haniano, mase'nenigeno avufga rima evuge haniano, ");
INSERT INTO kbq_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","mopafima agruma osu zagaramima regraroheno vanoma nehania zagaramima avako'ma hanigeno azeri pehanama huge, agru'ma osu'nenia vahe'ma avako'ma haniana, ");
INSERT INTO kbq_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","e'i anazantamima avako'ma hanimo'a, agru osuno, mani'nenkeno kinagasenkeno ti freteno, ruotage'ma hu'nea ne'zama eme nami'naza ne'zana negahie. ");
INSERT INTO kbq_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Hagi mani'nenkeno zagema uramina, agru nehuno otage ofama hanaza ne'zana negahie. Na'ankure e'i ana ne'zana agri'a ne'za me'ne. ");
INSERT INTO kbq_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Hagi agra'a fri'nesnia zagafi, afi' zagamo'ma aheno traga hu'nenia zagagafa ono. Ana zagama nesunka, Ra Anumzamo'na navurera agru osugahane. Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Hagi pristi vahera zamasamige'za miko tra keni'a avariri fatgo nehu'za, kumi'zmimofo knazana eri'za ofriho. Nagra Ra Anumzamo'na zamazeri ruotage hunomo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Hagi amne vahe'mo'o, ru vahepinti pristi naga'ene emani'nesimo'o, zagore eri'za erinentesimo'a ruotage'ma hu'nea ofama hanaza ne'zana pristi vahe'enena onegahie. ");
INSERT INTO kbq_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Hianagi pristi vahe'mo'ma agra'a zagoreti'ma mizama se'nenia kazokazo eri'za vahe'mo'a, ana pristi ne'mofo ne'zampintira amane negahie. Hagi ana kazokazo eri'za ne'mo'ma kasente'nesia mofavre'mo'ma ante'nesigeno'a, amane ana mofavremo'a ana ne'zana negahie. ");
INSERT INTO kbq_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Hagi pristi vahe'mofo mofamo'ma amne nagapima vema eri'nesuno'a, ruotage'ma hu'nea ofama hanaza ne'zana onegahie. ");
INSERT INTO kbq_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Hu'neanagi ana pristi ne'mofo mofa'ma neve'ma frisigeno kento manige, neve'ma atresigeno mofavrema onteno mani'nesia a'mo'a ete nefa nontega vuno umani'nenuno'a, amane nefa nezampintira negahie. Hianagi amne vahe'mo'za ana ne'zana onegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Hianagi iza'o keno antahino osu'neno pristi vahe ne'zama nesimo'a, hafu'ama ne'nesuno'a 5fu'a ami'neno mago'ane ante agofetu huno 6si'a pristi vahera amino. ");
INSERT INTO kbq_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Hagi Israeli vahe'mo'zama ruotage ofama Ra Anumzamo'naregama eri'za esaza ofa, mago pristi vahe'mo'a eri havizana osino. ");
INSERT INTO kbq_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Hagi ana ne'zama zamisage'zama nesu'za ana ne'zama nesaza zamofo knazama'a eri'za mizaseho. Nagra Ra Anumzamo'na zamazeri ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Aronine mofavre naga'ane, mika'a Israeli vahera amanage hunka zamasamio, Israeli vahemoto, rurega vahe'mo'ma tamagranema emani'nenaza vahe'mo'zanema huvempahu ofa hunakuro, amane musema huno ami ofama Ra Anumzamofonte'ma hunakura, ");
INSERT INTO kbq_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","afu kevu'afintira afuhe afahe'ma osu'nenia ve bulimakao afuro, ve sipisipi afuro, ve meme afuro, avreno vuno kresramna vino. Hagi ana'ma osanazana ana ofagura antahi ozamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Hagi afuhe afahe'ma hu'nesia su'ana avrenka omo. Na'ankure e'i ana ofa, Ra Anumzamo'na antahi omigahue. ");
INSERT INTO kbq_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Hagi arimpa fru ofa afu kevu'afintima Ra Anumzamo'narega agra'a avesite ofa hunakuro, huvempa hu'nere ofama hunakura, bulimakao afu kevu'afintiro sipisipi afu kevu'afintira afuhe afahe'ma osu'nesia avreno ome ofa hinke'na, ana ofa'a antahimi'neno. ");
INSERT INTO kbq_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Hagi avusu hu'neniano, aga rehantagi'neniano, avufgamo knare osu'nenio, namu re'neniano, zukake hu'nenia zaga ahenka kresramnavu itarera Ra Anumzamo'narera kresramna oviho. ");
INSERT INTO kbq_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Hagi agiamo'ma zaza huge, agiamo'ma atupama hu'nenia ve bulimakano, ve sipisipiretira musema huta tamagra'a tamavesite hu ofa amne hugahaze. Hagi huvempama Nagrite'ma hu'nesaza ofa, e'inahu suzantetira osiho. ");
INSERT INTO kbq_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Hagi agonknazama pro hu'nesiano, agonknazama hari'nesia, sipisipio bulimakao afutetira Ra Anumzamo'narera ofa huonantegahaze. Hagi anahukna ofa tamagra mopafina osiho. ");
INSERT INTO kbq_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Hagi e'inahu sipisipi afuro bulimakao afura, megi'a vahepintira mizana huta Anumzamo'na ofa huonanteho. Na'ankure inahu zamo'a afuhe afahe huno haviza hu'neankina, tamage hu'na Anumzamo'na antahi ozamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Anante Ra Anumzamo'a anage huno Mosesena asami'ne. ");
INSERT INTO kbq_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Hagi sipisipi afuro, bulimakao afuro, meme afu'mo'ma anenta'ma ante'niana, ana anenta'amo'a nerera'enena 7ni'a zagegna manino. Hagi 8 knareti'ma vaniana, amane Ra Anumzamonarera ofa hunantegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Hianagi menima mofavrema antesia bulimakaono, sipisipi afura nererane anenta'anena magoka oznaheho. ");
INSERT INTO kbq_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Hagi Anumzamonare'ma susu nehuta musenkase ofama hunaku hanuta, ke'ma tamasamua kante anteta hanage'na, ana zankura muse nehu'na antahiramigahue. ");
INSERT INTO kbq_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Hagi ana zupage mika'a ana ofama hanaza ne'zana nehna nehuta, mago'a atrenkeno me'nenkeno vuno masa osino. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","E'ina hu'negu kasegeni'a tamagra kegava nehuta amage anteho. Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Hagi ruotage'ma hu'nea nagi'a eri havizana osiho. Israeli vahe'mota nagrikura ruotage hu'ne huta nagi'a erisaga hiho. Nagra Anumzamo'na tamagrira tamazeri ruotage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nagra tamagri Anumzama mani'naku'ma Isipiti'ma tamavre'na atirami'noa Ra Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ra Anumzamo'a amange huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Israeli vahera anage hunka zamasamio, ama'na knare mono'ma hunante'naza kna huhampruankita, ana knagura ruotage hu'ne huta nentahita atru huta monora hunanteho. ");
INSERT INTO kbq_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sigisi'a zagegna eri'za kna meno, hagi 7ni zagegna manifru knagi mani fru hu'neta eme atru hutma monora hunanteho. Inaregama manita vanafina ana Sabati knarera mago eri'zana e'orita, amane eritru huta maniho. ");
INSERT INTO kbq_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Mago kafumofo agu'afina eme atruma huta mono'ma huntesazankna Ra Anumzamo'a ama'na knarami huhamprinte'ne. ");
INSERT INTO kbq_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Hagi ese ikamofona 14nigna zupa kinaga Ra Anumzamo'na Ontamahena tamagatere'noa knamo'a agafa hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Hagi ana ikamofo 15ni zupa zo-ore bretima nekna egahiankita, 7ni'a knafi zo-ore bretia negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Hagi ana sontamofo ese kna zupa atru huta monora nehinkeno mago'mo'e huno eri'zana ana knarera e'o'rigahie. ");
INSERT INTO kbq_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Hianagi 7ni'a knamofo agu'afina tevefima kre fananehu ofa Ra Anumzamofona huntegahaze. Hagi 7ni knarera atru huta monora hunenteta erizana e'origahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ra Anumzamo'a Mosesena asamino, ");
INSERT INTO kbq_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Israeli vahera zamasamige'za, zaminaku'ma hu'noa mopare'ma vanu'zama witima krisage'noma ese raga'ama rentesiana, mago kona anaki'za pristi vahete eri'za viho. ");
INSERT INTO kbq_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Hagi pristi vahe'mo'a mani fru knamofo amefi'a, Ra Anumzamo'na navure ana witi kona eri veravehu ofa hinke'na, Ra Anumzamo'na antahimigahue. ");
INSERT INTO kbq_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Hagi ana ne'zama eri veravemahu ofama hanaza zupa, mago kafu hu'nenigeno afuhe afahe osu'nenia ve sipisipi afu aheta tevefi kre fanenehu ofa Ra Anumzamofonte huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Hagi witima ofa eri'za esafinti 2'a kilo erifako hu'za, olivi masavene erihavia hute'za kre mna nevu'za, waini tinena eri'za 1ni'a lita tagi'za ofa hanageno Ra Anumzamo'a mna'a nentahino musena hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Hagi ese ne'zama hamaresazana Ra Anumzamonare erita etetma, tamagra henka breti tro hutma nege, kre hagage huge kasefara nege hugahaze. E'inahu avu'avara henkama fore hu'anante anantema hu'zama esaza vahe'mo'zanena trake me'nena manitama vanafina ana avu'avara huta viho. ");
INSERT INTO kbq_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Hagi anama witi ko'nama eri veravemahu ofama hanazana Sabati knaretira 7ni'a sonta hampriho. ");
INSERT INTO kbq_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Hagi 7ni'a mani fruhu knama Sabatima vagamaretesigeta, 50'a kna maniteta, Ra Anumzamofontera ru kasefa witi ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Hagi eri veravema hu ofama hu'zana, tare bretia erino eno tare kilo kna'amo'ma hu'nesiama'a flauara erita ana flauapina zisti anteteta, ana bretia tro hiho. E'i ese ne'zama hozafima nenama hania ne'zamofo ofa Ra Anumzamofontega hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Hagi ana bretinema ofama hanazana, mago kafu huno afuhe afahe osu'nesia 7ni'a ve sipisipi anentataminki, bulimakao afu kevufinti mago ve bulimakao afuhe afahe osu'nesiane, tare ra ve sipisipi afutre afuhe afahe osu'nesia avreta Ra Anumzamo'narera kresramna viho. Hagi witi ofane, waini ofa krenkeno knare mana vanige'na nentahina antahi musena hugahue. ");
INSERT INTO kbq_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Hagi mago ve meme afura kumite ofa kresramna nevuta, tare ve sipisipi afutrena mago kafu hu'nesa'a zanavreta arimpa fru ofa hiho. ");
INSERT INTO kbq_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Hagi Pristi vahe'mo'a bretine ana tare sipisipia Ra Anumzamo'nare eri verave hu ofane, ese ne'za rgamofo ofa eri verave hutena, e'i ana ne'zamo'a Ra Anumzamonarera ruotage hu'neankiza pristi vahe'mo'zage negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Hagi ana knarera maka eri'zana atreta omeri atru huta monora hugahaze. Ana knamo'a mevava tra ke me'nena henkama fore hu anante anante hu'zama vanaza vahe'mo'za avaririgahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Hagi hozatamifinti ese ne'zama nehamaresuta, agentegama mesiama'a atrenkeno nemena, evuramisiama'a zo-ogiho. Ana hu'nenage'za zamunte omane vahe'ene rurega vahe'ma enemaniza vahe'mo'za ome zogiho. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mago'ane Ra Anumzamo'a Mosesena asmino, ");
INSERT INTO kbq_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Israeli vahera zamasamige'za 7ni ikamofona ese knarera manigasa hiho. Ana knarera ranknatamigi ufena nereta atru huta monora hiho. ");
INSERT INTO kbq_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Hagi mago vahe'mo'a ana knarera eri'zana e'orino. Hianagi ana knarera tevefima kre ofa eri'za Ra Anumzamo'nare eme kresramna viho. ");
INSERT INTO kbq_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ra Anumzamo'a Mosesena amanage huno asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","7ni ikamofona 10ni kna fatgorera kumi'mofo nonama hu ofa hugahaze. Ana knarera ne'zana a'o nehutma, eritru huta monora nehuta tevefima kre ofa Ra Anumzamo'nare hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Hagi ana kna zupa mago vahe'mo'a eri'zana e'origahie, na'ankure Ra Anumzana tamagri Anumzamo'nare kumimofo nonama huno apaseramante ofa hugahaze. Ana hanage'na kumitamia atrezmantegahue. ");
INSERT INTO kbq_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Hagi ana knare'ma ne'zama nesaza vahera vahe'niafintira zamahe anati atregahue. ");
INSERT INTO kbq_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Iza'o e'i ana knare'ma eri'zama erisia vahera, Nagra vahe'niafintira ahe frigahue. ");
INSERT INTO kbq_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Hagi ana knarera mago eri'zana e'oritfa hugahaze. Ama tra kemo'a menine henkanema fore hu anante anante hu'zama esaza vahetera meno nevanige'za avaririgahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hagi anankna mani fruhu kna Sabatigita, mani fru hutma nemanitma, ana ikamofona 9ni zupa kinaga ne'zana a'o hutma mani'nenkeno vuno 10ni knamofona kinaga uhanatino. ");
INSERT INTO kbq_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mago'ene Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Israeli vahera zamasamige'za, 7ni ikamofona 15tini knazupa fugagi noma kiza maniza e'naza zamofo ne'zana kre'za nene'za, 7ni'a knamofo agu'afi Ra Anumzamo'na antahi namigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Hagi ese kna zupa ruotage hu'nea knagita eri'zana e'orita eta emeri tru huta monora hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Hagi ana 7ni'a knafina tevefi kre fanene hu ofa Ra Anumzamo'narera hiho. Hagi 8 knazupa eri'zana atreta eme atru hutma monora hunenanteta, tevefi kre fanene hu ofa Ra Anumzamo'nare hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","E'i ana kna ruotage hu'ne huno Ra Anumzamo'a huhampri'nea knagita, eme atru huta monora hunenteta mago mago knama huhamprinte'nenia knarera kre fanane hu ofane, witi ofane, kresramna vu ofane, waini ofa Ra Anumzamofontega hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Hagi emeritru huta mono'ma hu knaramina amage'ma nente'nuta, mani fru hu kna Sabatigura tamagesa nentahita, muse'zana erita ne-eta, huvempa hu ofa nehuta, tamagra'a tamavesite'ma hu ofanena Ra Anumzamo'narera hunantegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Hagi ne'zama eri tru huteta ana knamofo amefi'a, 7ni ikamofo 15ni knazupa 7ni'a knafi ne'zana kreta neneta monora Ra Anumzamofona hunteta musena hunteho. Hanki ese knazupane, 8ti knanena manifru hu kna me'ne. ");
INSERT INTO kbq_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Hagi ese kna zupa muri zafa azankunaki, tofe ani'nagi, ani'na kuronkuroma hu zafa azankunaki, ankre huta e'nerita, amiramira huta Ra Anumzana tamagri Anumzamofona 7ni'a zagegnafina musena hunanteho. ");
INSERT INTO kbq_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hagi maka kafufina 7ni ikampi 7ni'a zagegnafi ne'zana neneta musena hugahaze. Ama anahu avu'avazamo'a menina me'nena henkama fore'ma hu anante anante'ma hu'zama vanaza vahe'mo'za avririgahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Hagi 7ni'a knamofo agu'afina Israeli vahe'mota fugagi noma ki'nesaza nompi manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","E'i anazama huterema nehanage'za henkama fore'ma hunante anante'ma hu'zama vanaza vahe'mo'za nege'za, Nagrama Isipiti'ma tamagehe'ima zamavare'na ne-eoge'zama fugagi'noma ki'zama maniza e'naza zanku antahigahaze. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Hanki Mosese'a Israeli vahera Ra Anumzamo'ma ne'za neneta mono hunanteta muse hutere hugahazema hu'nea knaramina eriama huno zamasami'ne. ");
INSERT INTO kbq_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Israeli vahera zmasamige'za agruma huno'ma knare'ma hu'nesia olivi masavena eri'za esagenka, lamufina tagintenka rekru huntegeno tavi'mo'a seli nompina asura osuno tevava hino. ");
INSERT INTO kbq_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Atruhu seli mono nompima hunaragi tavravemofo avuga, ruotage hu'nefina Aroni'a tavima taginte zantamina eri ante fatgo nehuno, kinaga tavira tagintenkeno asu osuno Ra Anumzamofo avurera me'neno vuno kotugahie. Hagi ama anazamo'a mago kasege me'nena tamagehezama fore hu anante anante'ma hanaza vahe'mo'za amage antegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Hagi goliretike'ma tro'ma hu'naza tavi rekruhunte azotarera, tavira me'nena Aroni'a miko zupa ana tavimofo osa'a renkanufeno erise hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Hagi kaneno eri osi hanigeno fuzafupenenia flaua erinka 12fu'a breti trohuo. Hagi tare kilo eri fako hutere hunka, mago mago bretia trohuo. ");
INSERT INTO kbq_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Hagi ana bretia refako hunka golireti'ma tro'ma hu'naza itama Ra Anumzamofo avugama me'nere tare isare 6si'a antetere huo. ");
INSERT INTO kbq_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Hagi tare isare'ma refko huta antesaza bretire frenkinsensi mnanentake zana antekeno bretimofo nona erinigeta Ra Anumzamofo ofa tevefi kre mna viho. ");
INSERT INTO kbq_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Hagi mika mani fruhu Sabati knarera pristi vahe'mo'a bretia erino, Ra Anumzamo'na navuga eme antetere hugahie. Hagi ama ana avu'avazamo'a, huhagerafi tra ke me'nena avaririgahaze. ");
INSERT INTO kbq_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hagi ana ne'zana Aronine agripinti'ma fore hu'zama esaza naga'mokizmi ne'zankiza, ruotage'ma hu'nefinka negahaze. Na'ankure ana ne'zana Ra Anumzamofonte ofa hazageno ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Mago nera nerera'a Israeli a' manigeno, nefa'a Isipi ne' mani'ne. Hagi ana ne'mo'a Israeli vahe kumapi mago Israeli ne'ene hara hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ana a'mofo agi'a Selomiti'e. Selomiti'a Dibri mofakino Dani nagapintire. Hagi ana Israeli a'mofo mofavremo'a Ra Anumzamofo agi huhaviza nehuno, Ra Anumzamofo agifi sifna ke huntege'za Mosesente avre'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Hagi ana nera avre'za kina nompi ome ante'ne'za, Ra Anumzamo'ma kema Mosesema asaminigu avega ante'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Anante Ra Anumzamo'a amanage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","nagima huhavizama hunante'nea nera kumamofo agu'afintira avrenka fegi'a vugeno, huhavizama nehanige'zama antahi'nesaza vahe'mo'za zmazana anunte antetesageno, miko vahe'mo'za have knonu ahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Hagi Israeli vahera zamasamio, iza'o Anumzamo'nama huhavizama hunantesimo'a, agra'a knazama'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Hagi iza'o Ra Anumzamo'na nagima huhavizama hanimofona ahe friho. Maka Israeli vahe'mo'zo emani'nenaza vahe'mo'zama huhavizama hanazana vahera havenknonu zamahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Hagi vahe'ma ahe frisnia vahera ahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Hagi mago'mo'ma rumofo zagagafama ahe frisiana, ana ne'mo'a, anama ahefrisia zagagafa nona huno agra'a zagagafa avremigahie. ");
INSERT INTO kbq_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Hagi iza'o tava'oma'are'ma nemanismofoma ina avufgarero kuzafa ahesigeno'a, ana zanke huta agri'enena ana avufgarera ahegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Hagi mago vahe zaferinama ruhantagisimofona, ana zanke huta agrira zaferina'a ruhantagiho. Avuma ruproma hina, ana zanke huta avu rupro hiho. Ave'ma rutafrina, agri'enena ana zanke huta ave rutafriho. ");
INSERT INTO kbq_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Hagi iza'o mago vahe zagagafama ahesimo'a, nona huno mago avaremino. Hianagi vahe'ma ahe frisimofona, ahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Hagi ruregati'ma tamagranema emani'nesaza vahe'ene Israeli vahe'mo'zanena ama ana kasegea avaririho. Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Hagi Ra Anumzamo'ma hu'nea kante anteno Mosese'a Israeli vahera huzmantege'za, Ra Anumzama huhavizama huntea nera ome avre'za kumamofo fegia havenknonu ome ahe fri'naze. ");
INSERT INTO kbq_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ra Anumzamo'a Sainai agonare Mosesena asamino, anage hu'ne, ");
INSERT INTO kbq_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Israeli vahera amanage hunka zamasamio, Nagrama tamisua mopafima ufresuta 7ni kafurera atrenkeno mopamo'a manigasa hinketa, magozane huta mopafina onkrinkeno mopamo'a Ra Anumzamofo Sabati'e huno mane fru huno mago kafu meno. ");
INSERT INTO kbq_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Hagi 6si'a kafufina mopatamifina avimza neseta, waini azankunara akafrita erise nehuta, hoza hamaregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Hianagi 7ni kafua Sabati kafugino mopamo'a atrenkeno mane fruhu huno Ra Anumzamo'nare meno. Hagi ana kafufina hoza e'orige, waini azankunara akafrita eri fatgoa osugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hagi ana kafufima agra'ama hageno raga'ama ahe'nesia witia akafrita nompina onteta, azanku'nama akafrita erise'ma osu'nesaza wainia tagita waini tina tro huta onteho. Hagi ana kafua mani fru hu kafugino, atrenkeno mopamo'a fru huno amne meno. ");
INSERT INTO kbq_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Hianagi tamagrane ve kazokzo eri'za vahe'ene, a' kazokzo eri'za vahe'ene, zagore'ma eri'zama erinermantesaza vahe'ene, ruregati vahe'ma tamagranema nemanisia vahe'mo'zanena amne anampintira eri'za negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Anahukna hu'za maka kegavama nehaza zagagafatamimo'zane, afi zagagafamo'zanena anampinti ne'zana negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Hagi 7ni'a zupa 7ni'a kafu'a hamprinkeno ana maka kafumo'a 49'a kafu hino. ");
INSERT INTO kbq_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hagi ana kafumofona 7ni ikamofo 10ni zupa, kumi'mofo nona huno apasezmante knagita mememofo pazivete ufe erita, ufena omereta mopatamifina viho. ");
INSERT INTO kbq_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Hagi 50'a kafuma hanigeta e'i ana kafumo'a ruotage hu'neanki, huama huta eri'za vahera zamatresage'za fru hu'za nagazimirega vugahaze. Hagi mikamota mopatamirega vugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Hagi 50ma hania kafua eri'nesaza zama eteno ami kafugita, hoza ontege agra'ama hagesia witia akafrita eri ontege, waini azankuna'a akafrita erise osu'nesaza waniretira raga'a tagita waini tina trora huontegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Na'ankure e'i eri'nesaza zama etenoma omi ami hu kafugino, tamagritera ruotage hugahiankita ana hozafintira ne'zanke eritma negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Hagi eri'nesaza zama eteno'ma ami kafuma hanigeno'a, miko vahe'mo'a mopa agafarega miko zama'ama me'nerega vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Hagi mopatamima zagore atrazage'za mizase'nenaza vahero, mopazmima zamagripinti mizase'nesaza vahera rezmatga huta mopazmia eri savarira osiho. ");
INSERT INTO kbq_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Hagi tamagrama mopama mago'amokizmire'ma atrenesuta, nama'a kafu mani'nageno vuno mani fruhu kafurera uhanatine, ana kafu'amofo avamente zagoa mizana sentegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Hagi rama'a kafuma ana mopafima manitesageno eri'nesazazama eteno ami kafuma ena, zagoa eri antesga huta mizasegahaze. Hagi ana mopafima osi'a kafuma mani'tesageno eri'nesaza zama eteno ami kafuma ena, anteramita osi'a zago mizasegahaze. Na'ankure ne'zama ana mopafinti'ma erifore'ma hu'nesaza avamente mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mago'mofoma orevatage arevatage huta nanazama eri avu'avara zana osiho. Hagi atrenkeno Anumzamo'na kore'ma hunante zamo tamagu'afina meno. Hagi Nagra Ra Anumzana tamagri Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Hagi Nagri tra kene kasegeni'a avaririsuta, knare huta ama mopafina nemanisageno, ");
INSERT INTO kbq_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ana mopafina ne'zana fore hanigeta neramamu nehuta hazenkea e'ori so'e hutma manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Hianagi mani fruhu 7ni kafure'ma, hozama erita ontege, ne'zama eri atruma osanuta, na'a negahune? huta antahintahi hakarea osiho. ");
INSERT INTO kbq_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Hagi 6si kafufina Nagra asomu ha'nenkeno, 3'a kafufima ne'naza avamente ne'zamo'a amporegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hagi 8ti kafufima agafa huta hozama nentesuta, ko'ma 6si kafufima hamarente'naza ne'za me'nena nenesageno, 9ni kafufina ne'zamo'a nenahinketa vasagegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Hagi mopa zagorera erivaga rehogura otreho, na'ankure mopa Nagri mopa me'negeta, tamagra rurega vahe emaniankna huta mani'naze. ");
INSERT INTO kbq_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Hagi ana mopama miza hanazegu'ma zagore'ma atresageno'a, ana mopamofo nafa'amo mizana hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Hagi mago Israeli vahe'mo'ma amunte'ma omanenigeno mopa'ama zagore'ma atre'nesige'za, mizama hu'nenageta, ana ne'mofo naga'afinti ana mopa ete mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Hagi naga'afinti'ma mago'mo'ma mizaseno ana mopama erigama osanigeno'a, me'nenkeno zagoa eritru huteno agra'a mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Hagi zagoma keno erifore huteno mizamasenaku'ma hanuno'a, nama'a kafufima ana mopafina hoza anteno ne'ne, hamprino eri fatgo huteno, hozama ante'nesia kafu'are mizasenenteno ete mopa erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Hianagi mopa nefa'ma zagore'ma atre'nesia mopa'ama erinaku'ma hanianagi zago'ama omanesigeno'a, avega anteno mani'nenkeno eri'nesia zama eteno ami kafuma esigeno'a, ana ne'mofo azampintira amne mopa'ama mizama seneniama'a nemino erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Hagi mago ne'mo'ma kegina hugagi'nenia rankumapima me'nenia noma'ama zagore'ma atresigeno ru ne'mo'ma eri'nesigeno'a, ete ana noma'a erinaku'ma hanuno'a, mago kafufinke mizasenenteno ana nona erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Hianagi ana noma mago kafufima mizase vaga'oresigeno'a, eri'nesia zama ami kafuma esigeno'a, ana nomofo nefa'a, ana nona e'origahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Hagi kegina osu kumapima me'nenia nona mopama hu'nazankna hu'za hugahazankita, zagoreti amne mizasege, eri'nesiazama ete ami kafuma esigeta, amne ana nomofo nefa'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Hagi Livae naga'mofo rankumapima mago Livae ne'mo'ma noma'ama zagore'ma atresigeno mizama se'nesage'za, agra amne inaknarero ete'no noma'a mizaseno erigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Hagi Livae naga'mo'za nozamima zagore'ma atre'nesageno rumo'zama mizasenenage'noma, eri'nesiazama eteno ami kafuma esige'za, amane nozmia erigahaze. Na'ankure zamagra mago'zana onte'nazanki nonke'za ante'naze. ");
INSERT INTO kbq_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Hianagi Livae naga'mo'zama afuzagama kegavama nehaza mopama kuma tavaonte'ma me'nesige'za zagorera otreho, e'i ana mopa zamagri'a mopa megahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Hagi Israeli vahepinti'ma mago'mo'ma amunte'ma omanesigeno agra'ama aza huga'ma osanigeta, ruregati vahe'ma mopatamifima emani'negeta azama nehazaza huta azahinkeno, tamagranena manino. ");
INSERT INTO kbq_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Hagi mago'azama zagoretima mizasenaku'ma hanigenka, Anumzamofo korozamo kagu'afi me'nenkenka, mago'a rukamrenka ra zago agia aheonto. Ana hinkeno tamagrane ana vahe'mo'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Hagi zagoma amisunka, anante ante aguheno namisigure hunka omige, ne'zama amisunka, ne'zama ante aguheno namisigure hunka omio. ");
INSERT INTO kbq_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nagra Ra Anumzana tamagri Anumzane, Isipiti'ma tamavre'na e'na Keneni mopama tami'noana, tamagri Anumza mani'naku tamavre'na e'noe. ");
INSERT INTO kbq_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Hagi Israeli nagapinti magotamimo'ma agra'a aza huga osuno, agra avufgama zagore'ma atresigenka mizasenunka, kazokzo eri'za vaheknara hunka kva huonto. ");
INSERT INTO kbq_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Hagi agrira zagore'ma zamavrazage'za eri'za erige, ruregati vahe'ma emani'ne'za eri'zama e'nerizankna huno mani'ne'nigeno, eri'nea zama eteno nemino musenkasema hu kafurera uhanatigahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Hagi ana kafurera agri'ene mofavre'araminena zamatrenke'za nagazmima mani'nare mopa agafare viho. ");
INSERT INTO kbq_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Na'ankure Israeli vahera Nagri'a eri'za vahe Isipitira tamavre'na e'noankita zagorera zmatrenage'za kazokzo eri'za vahera ozmavregosaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Hagi zamage fenkamu atreta zamazeri havizana osiho. Hu'neanagi Ra Anumzamofonku kore huntegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Kazokzo eri'za veo, kazokzo eri'za a'ma avre'sazana ru vahe'ma tava'ontamire'ma mani'nesaza kumapintike zamavareho. ");
INSERT INTO kbq_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Hagi rurega vahe'ma tamagranema enemani'naza vahepinti enena amne zamavaresage'za tamagri'za se'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Hagi frisage'za ana kazokzo eri'za vahera mofavretamimo'za zamazeri santiharesageno tamagri eri'za vahe segahaze. Hianagi Israeli vahera anara huta kazokzo eri'za vahera ozamavaregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Hagi Israeli vahe'ma zamunte omanesige'za, rurega vahe'ma tamagrane emani'nenaza vahetema zamagra zamavufagama zagore'ma atresageta, ");
INSERT INTO kbq_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ete amne naga'amo'za mizaseza ana nera avregahaze. Hagi afu agana'o, ");
INSERT INTO kbq_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","nenogo'o, nefo'amo'o korama'amo'a ana nera mizasegahaze. Hagi ana ne'mo'ma agra'ama mizasega hanuno'a, amne mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Agrane mizamase'nea ne-enena eri'zama erisia kafu'a hamprike nevikeno eri'neazama eteno nemino musenkasema hu kafure uhanatino. Hagi anama mani'nesia kafumofo avamente erinte'za mizama'a keho. Hagi ana knama refko huno keteno, mizamasentesiana zagore'ma hige'za vahe'mo'za eri'zama erige'zama mizama senezmantazankna kante miza sentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Hagi eri'nesiazama etenoma ami kafuma zazate'ma me'nenkeno'a, ana vahe'mo'a kva'amofona agra'a avufgarera rama'a zago miza sentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Hagi eri'nea zama eteno ami kafumo'ma erava'o hunenkeno'a, ana avamente osi'a zago mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Hagi emani vahe'mofo eri'za vahe'ma mani'nenkeno'a, kafugu kafugu'ma zagore'ma avrazageno eri'zama erige'zama kegavama hunentazankna hu'za kegava hunteho. Hagi atrenke'za ana vahe'mo'za mopatamifina kazokzo eri'za vahe'ma zamazeri haviza hazankna hu'za kegava huozmanteho. ");
INSERT INTO kbq_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Hagi ana ne'mo'ma agra'ama mizasegama osanigeno eri'nea zama eteno nemino musenkase hu kafuma esigeno'a, ana ne'ene mofavre'zaga'anena zamatresige'za fru hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Na'ankure Israeli vahe'mo'za Nagri eri'za vahe mani'nazage'na, zamavare'na Isipitira e'noe. Nagra Ra Anumzana, tamagri Anumzane. ");
INSERT INTO kbq_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Mago kaza osu anumzantero, zafa antreta mago anumzana trora huontege, zaza havea retrurente'neta monora huntege, havea antreta havi anumzamofo amema'a tro hunte'neta monora huonteho. Nagrake Ra Anumzana tamagri Anumzana mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mani fruhu knani'a Sabatia kegava huta manifru nehuta, mono noni'a kegava hiho. Nagra Ra Anumzamona nehue. ");
INSERT INTO kbq_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Tamagrama tra keni'ane kasegeni'ama kegava hu'neta nevaririta agorga'ama manisazana, ");
INSERT INTO kbq_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Nagra kora atre'nugeno neranigeno, mopamo'a ne'zana renentesigeno, hozafi zafamo'za raga'a rentegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Hagi witia vasageta nevanageno wainima tagi kna esigeta, wainia tagita nevanageno, hozama ante kna e'nigeta, miko ne'zana neramu nehuta mopatamifina knare huta manigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Hagi Nagra tamagrira tamarimpa fru tami'nena, masenuta mago vahekura korora osugahaze. Mopatamifintira afi ha' zagagafa ahenatinetre'na, ha' vahetamimo'za tamahe zankura kegava huramantegahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Hianagi ha' vahetamima ha'ma huzmantesazana, zamarotago huta zamahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Hagi 5fu'a vahe'mota 100'a ha' vahera zamarotago hanage'za fresageno, 100'a vahe'mota 10 tauseni'a ha' vahetamina zamarotago huta kazinteti zamahegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nagra tamagrira navesineramante'na tamazeri hakare ha'nena rama'a vahe fore nehanagena tamagranema huhagerafi huvempa kema hu'noa keni'amo'a nena raga regahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Hagi ko kafufima eritruma hu'naza ne'zana nenesageno, kasefa kafufina ne'zamo'a avitena, ko kafufima eritru hu'nenaza ne'zana eritregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nagra tamagrane nemanina, namefira huoramigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nagra tamagrane vano nehu'na, tamagri Anumza mani'nesugeta, tamagra Nagri vahe manigahze. ");
INSERT INTO kbq_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nagra Ra Anumzana, tamagri Anumzamo'na Isipiti'ma tamavre'na ogeta, mago'ane kazokzo eri'za vahera omani'naze. Hagi agarenamare zafama tamanankempi anakinte'nazageta kazokzo eri'zama e'nerizage'na, Nagra ana zafa eri atrogeta fru huta e'naze. ");
INSERT INTO kbq_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Hianagi keni'a antahi onamige, kasegeni'amofo amage ontege, ");
INSERT INTO kbq_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","tra keni'a ovaririta, huhagerafino'a huvempa ke'ma rutagresazana, ");
INSERT INTO kbq_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Nagra amanahu knaza tamigahue. Ame hu'na ranknaza atre'na, tamazeri kore nehu'na, onkanamre krine, avufga amuho krine atranena tamavurga azeri asu nehina, tamatafi manime nevuta ufrigahaze. Hagi hozama antesazana amne zankna hugahie. Na'ankure ha' vahetamimo'za hamare'za negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nagra namage'na hurami'nena ha' vahetamimo'za hara huramagateregahaze. Tamavesrama hunermantaza vahe'mo'za kegava hunermante'na, mago vahe'mo tamarotago osu'nesianagi, tamagra kore fregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Hagi ana knazama tamisugetama ontahitama mago'anema ana kumima huta vanazana, nona'a 7ni'a zupa agaterena knazana tamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nagra tamavufga rama nehaza tamavutamavara tamahe pasaru nehu'na, mona azeri'nugeno aenigna huno hanavetino kora norina, mopamo'a hanavetino bronsigna hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Hanavetamimo'a amane zanka hugahie. Na'ankure mopatamimo'a ne'zana ahe ontesigeno, zafamo'a raga reontegahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Hagi ana knazama esigeta mago'anema ana keni'ama rutagresazana, Nagra 7ni'a zupa agatere'na kumi'ma hu'nesaza avamente knazana tamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nagra afi zagagafa huzmanta'nena mofavretamia zamahe nefrisageno, afu zagatamia zamahe nefrina, tamazeri atupa hanugeta, osia vahe manisageno, kampina vahe'mo'za vano osugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Hagi ana'ma hanua zama rempi hutama ontahita, ana zanku'ma tamarimpama aheta keni'a hantagita vanazana, ");
INSERT INTO kbq_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Nagra kumi'ma hanarera narimpa ahe'na hara reramante'na, kumi'ma hanaza nona'a knazana 7ni'a zupa agatere'na tamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ana nehu'na ha' vahetami huzamanta'nena huhagerafi huvempa ke'ma hantagi'naza zantera ha' eme huramantegahaze. Hagi fretama rankumapima ufresazana, kri atra'nena anampinka tamahe nefrina, ha' vahetamimoza hara hurmante'za hara huramagateregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Hagi ne'zama e'neri'za kankamuna eri havizama ha'nena avenifima kresaza bretia 10'a naga'mo'za nesageno tamura osina tamagaku hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Hagi ana'ma huramantesugeta, tamarimpa ahenanteta, kenia ontahi ana zanke'ma huta vanazana, ");
INSERT INTO kbq_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Nagra tusi'a narimpa aheneramante'na, kumi'ma hu'nesaza avamente, agatere'na 7ni'a zupa knazana tamigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Tamage ana knafina, ne'zankura atupa nehuta ne' mofavre tami'ne mofa'netaminena zamaheta negahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Hagi agonaregama havi anumzante'ma mono'ma hunentaza kumatamia Nagra eri haviza nehu'na, mnanentake zama kre mnama kaza osu havi anumzante'ma nevaza ita tamia tagnavazi netre'na, kaza osu havi anumzana, eri haviza huntene'na ana agofetu tamahe'na fri tamavufga eri agofetu agofetu hanugeno moriri huno marerigahie. Na'ankure e'inahu tamavutavama hazazankura nagote'zmante'na namefi huramigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nagra rankumatamia eri haviza nehu'na, mono nontaminena eri haviza hugahie. Hagi mnanentake zama kre mnama vnaza ofa, Nagra antahi oramigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Hagi nagra mopatamia eri haviza ha'nena, mopatamima erisaza vahe'mo'za anazana nege'za, antri hu'za zmagogogu hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nagra ha' vahetamia hanuge'za tamahe savri hanageta, ru vahe kumapi savri huta umanisageno, kumatamimo'a amne zankna hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nagra tamazeri panini hanugeta ru vahe kumapi umani'nenageno, Sabati kafurema mopatamimofoma atrazage'noma mani fruma osu'nea nona'a anantega umani'nenageno mopamo'a mani fru hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Hagi ana mopafima mani'neta atrageno'ma mopamo'ma mani fruma osu'nea zankura mopamo'ma haviza huno mesia knafina, mopamo'a fru huno megahie. ");
INSERT INTO kbq_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Hagi ana vahe mopafima umanisamo'za tamagrira tamazeri kore ha'nena, vahe'mo tamarotago osanianagi, zafaninamo tamage'ma hania zankura kore fregahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ha vahe'mo'za zamavaririzage'za ha'pima oretufe aretufema hu'za frazaza huta vahe'mo'za ontamavariri nazanagi ozeri tanafa azeri tanafa huta fregahaze. Hagi hanavetamia omnena oti hanavetineta ha' vahetamia hara huozmantegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Hianagi ru vahe mopafi frisage'za, ha' vahetamimofo mopafi aseramantegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Hagi manisamota amane zankna huta ha' vahetamimofo mopafi haviza hugahaze. Na'ankure tamagra'a kumiku'ene neramafa kumiku anara hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ana'ma hutesu'za manisamo'za kumizmigu'ene zamagehe'i kumiku'ma zamagesa nentahi'za ana zanku'ma zamasuku nehu'za, huhavizama hunante'naza zanku'ma huama hu'za zamasunku'ma hanage'na, ");
INSERT INTO kbq_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Narimpa eri haviza hazazanku ha' vahetamimofo mopafina tamatrogeta umani'naze. Hagi tamagra'ama anteramita ana zanku'ma tamagu'ama rukrahe'ma huta nemanita, kumi'ma hu'naza zankuma nonama hanazana, ");
INSERT INTO kbq_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Jekopune, Aisakine Abrahamunema huhagerafi huvempa kema Nagrama huzmante'noa nanekegu nagesa nentahi'na, mopama zamigahuema hu'noa zanku'enena nagesa antahigahue. ");
INSERT INTO kbq_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Hagi Sabati kafurema manigasama osu'nea zanku mopamo'ma amnema menoma vania knafina mopamo'a fru huno me'nena, tamagra Nagri kema rutagrenaza zantera vahe mopafina kna erigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Hagi ana huta ha' vahetamimofo kumapina manigahazanagi, Nagra zamaretufe otre'na, zamazeri havi zantafana osu'na, huhagerafi'noa keni'a ruotagregosue. Na'ankure Nagra Ra Anumzana, zamagri Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Hagi ko'ma zamagehe'inema huhagerafinoa kegu nagesa nentahina, zamagri Anumza mani'naku ru vahe'mo'za negazage'na Isipitira zamavare'na e'noe. Nagra Ra Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ama tra kene kasegenena Ra Anumzamo Sainai agonafi Mosese asamigeno Israeli vahera zmasaminia naneke. ");
INSERT INTO kbq_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mago'ane Ra Anumzamo'a Mosesena amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Israeli vahera zamasamige'za Anumzamofoma huvempa hu'za ami'nesaza vahe'ma mizama senaku'ma hanu'za, vahe'mofo avamente nege'za mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Mono nompima erinte'zama refkoma nehaza kante anteta, kafuzamimo'ma 20tireti'ma vuno, 60re'ma ometre'nenia veneneramintera 50'a silva zago mizaseho. ");
INSERT INTO kbq_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Hagi kafuzmimo'ma 20reti'ma vuno 60re'ma vu'nesia a'mofara, 30'a silva zagoreti mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Hagi 5fu'a kafuretima vuno 20'a kafuma hu'nenia venene'a, 20'a silva zago mizase nezamanteta, 5fu'a kafuretima vuno 20'a kafuma hu'nenia mofane zagarera 10ni'a silva zagoreti mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Hagi mago ikama hu'neniretima vuno 5fu'a kafuma hu'nenia ne mofavrerera, 5'a silva zago mizaneseta, mago ikama hu'neniretima vuno 5fu'a kafuma hu'nenia mofanerera 3'a silva zago mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Hagi 6'a kafuma agaterenenia venenerera, 15tini'a silva zago miza nehuta, 60'a kafuma agatere'nenia anerera 10ni'a silva zago mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Hagi zamunte omane vahe'mo'zama huvempa hu'nenuzama zamagrama mizasega avamente zagoma e'ori'nesu'za, pristi vahete vanageno pristi vahe'mo zamagrama mizamasega avamente zago agi ahezamantesige'za mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Hagi mago'mo'ma agruma hu'nenia zagagafafinti'ma Ra Anumzamonare'ma huvempa huno ofama hu'naku'ma hania zagagafamo'a ruotage hu'ne. ");
INSERT INTO kbq_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Hagi ana ruotage'ma hu'nea zagagafa haviza hu'neanki, knare hu'neanki nehuta ru zagagafa avreonteho. Hianagi anama hanageno'a, ana tarega zagagafamokea ruotage hugaha'e. ");
INSERT INTO kbq_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Hianagi agruma osu'nenia zagagafama Ra Anumzamona'ma antahimina e'orisua ofama huvempama hanuta, ana zagagafa erita pristi vahete viho. ");
INSERT INTO kbq_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ana hanage'za knare hu'neo, haviza hu'neo pristi vahe'mo'za refako hu'za nege'za, mizama'amo'a e'inahu avamente me'ne hu'za tamasamigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Hagi ana zagama ete nona huta miza huku'ma hanuta, pristi vahe'mo'ma tamasamisia mizante 5fu'a kevurera mago kevune ante agofetu hutma mizana asegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Hagi mago ne'mo'ma noma'ama ruotage hu'ne huno Ra Anumzamo'na nazampima ante'nigeno'a, pristi vahe'mo'zage nege'za knare hu'ne huge, haviza hu'ne hu'za miza agia ahentegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Hagi ana noma Ra Anumzamo'na nazampima antesia ne'mo'ma eteno mizama senaku hanuno'a, pristi vahe'mo'zama ahentesaza 5fu'a kevua ante'neno, mago kevunena ante agofetu huno mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Hagi mago'mo'ma mopa'ama Ra Anumzamo'na nami'nenia mopamofo mizama'amo'a, bali avimzama ana mopafima negria avimzama 100'a kiloma hu'nenirera 50tia silva zago miza hutere hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Hagi erinesiazama eteno ami kafumofo agu'afima huvempa huno mopa'ama Ra Anumzamofoma amisiana, anama agima ahente'naza kante ana mopa miza hugahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Hianagi eri'nenia zama eteno ami kafumo'ma vagareno evanigeno'a, Nagri'ma nami'nenia mopamo'ma nana kafu agri'enena me'nenigeno eteno eri'nenia zama ami kafua egahie, ana avamente pristi vahe'mo'a refko huno miza agi erinteramino ahentegahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Hagi agrama ana mopa'ama eteno miza huku'ma hanuno'a, pristi vahe'mo'ma ahentesia mizantera 5fu'a zagofintira mago zago ante agofetu huno ana mizantera mizana asenigeno, ana mopamo'a eteno agri mopa megahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Hagi anama Ra Anumzamofo ami'nenia mopa'ama eteno mizama osu'neno, ru vahetema atrenigeno mizama hu'nena, eteno ana mopa'a mizana osugahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Hagi eri'nesia zama ami kafuma esigeno'a, ana mopamo'a ruotage huno Nagri'za segahie. E'igu ana mopamo'a pristi vahe mopa megahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Hagi mago vahe'mo'ma mizama hu'nesia mopama agri mopa omanene'nianagi, Ra Anumzamo'na namiku'ma hanige'za, ");
INSERT INTO kbq_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","pristi vahe'mo'za refko hu'za kete'za, nama'a kafu me'nenigeno eri'nesia zama eteno ami kafua egahie, miza agima ahentesia kante mizasenigeno, ana zagomo'a ruotge huno Ra Anumzamo'na zago megahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Hagi eri'neniazama eteno ami kafuma esigeno'a, ana mopamo'a, mopa agafa ne'mofo azampi eteno vugahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Hagi mika'a zamofo miza agima ahentesazana, mono nompima refko hu'za mizama nesaza avamente fatgo hu'za mizana hugahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Mika'a zagagafa tamimofo agonesa anentara Ra Anumzamo'na su'za me'ne. E'igu' agonesa bulimakao anentaro, sipisipi anentara ko Nagri su'a me'neanki huhampri onantegahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Hianagi agruma osu'nesaza afuka'amofo agonesa anentara pristi vahe'mo'ma ahentesia mizantera 5fu'a zagofintira mago zago ante agofetu hunka, ana afura ete miza segahane. Hagi kagrama miza osenankeno'a, ru vahe'mo ana miza fatgore mizasegahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Hianagi vahero, zagagafao, mopao, maka'zama Ra Anumzamona'ma huvempa hunka nami'nenana zana, zagoreti mizasenka e'orige, ete zagorera atregera osugahane. Hagi ana mika'zama eri ruotage'ma hunka huvempa hunana zamo'a, ruotage huno Nagrike'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Mago vahe'ma Ra Anumzamo'ma ahe frihoma hu'nesia vahera, ete mizaseta ovregahazanki ahe friho. ");
INSERT INTO kbq_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Hagi hoza tamifinti'ma witio, zafa rgama tagita eri atruma hinkeno 10ni'a kevuma huterema hina, 10ni kevua ruotage hu'negu Ra Anumzamo'na namigahaze. ");
INSERT INTO kbq_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Hagi ama ana ne'zama ete kagrama miza hunaku'ma hanunka, pristi vahe'mo'ma miza agima ahentesire mizanesenka 5fu'a zagofintira mago zago ante agofetu hunka miza hugahane. ");
INSERT INTO kbq_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Hagi bulimakao afu'ene, sipisipi afu'ene, meme afu ka'ama nehampri' nankeno'ma 10nima huterema hanimofona ruotage hu'negu, e'i Nagri su'za megahie. ");
INSERT INTO kbq_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Hagi haviza hu'ne knare hu'ne hunka ru su'zana nona hunka avre onto. Hagi nonama hunka ru su'zama avrentesankeno'a, ana taregamokea ruotage hugaha'ankinka, ete mizasenka ovregahane. ");
INSERT INTO kbq_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ra Anumzamo'a amana kasegene tra kenena Mosese'ma Sainai agonafi mani'negeno amigeno erino Israeli vahe'ma ome zmasami'nea naneke. ");
INSERT INTO kbq_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israeli vahe'ma Isipitima atre'za Sainai ka'ma kopima emani'nazageno, tare kafuma enevigeno 2 ikana ese kna zupa atruhu seli nompinti Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Kagrane Aroni'enena maka Israeli vahe'mokizmi zamagi'a nagate nofite kognare huta maka venenemokizmi zamagi'a krente'o. ");
INSERT INTO kbq_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Hagi sondia vahe'ma fore huga vahe'ma 20'a kafureti mareri nagamuteno Israeli vahepima iza'o hate vuga hu'nesiana, kagrane Aroni'enena hamprita sondia kevu'zmire zamantetere huta krente'o. ");
INSERT INTO kbq_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ana nehuta, mago mago naga nofipinti kvazmia huge'za tanaza hutere hiho. ");
INSERT INTO kbq_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Tanagrima tanaza hu'za eri'zama erisaza vahe'mokizmi zamagi'a ama'ne, Rubeni nagapintira, Sedeu nemofo Elizuri'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon nagapintira, Zurisadai nemofo Selumieli'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Juda nagapintira, Aminadab nemofo Nasoni'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isaka nagapintira, Zuari nemofo Netaneli'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun nagapintira, Helon nemofo Eliabu'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Josefe amohe'i Efraemi nagapintira, Amihud nemofo Elisama'e. Manase nagapintira Pedasuri nemofo Gamalieli'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamen nagapintira, Gideoni nemofo Abidani'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dani nagapintira, Amisadai nemofo Ahieza'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aseli nagapintira, Okran nemofo Pagieli'e, ");
INSERT INTO kbq_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gati nagapintira, Deuel nemofo Eleasafi'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nafatali nagapintira, Enan nemofo Ahira'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Amama zamagima fore hu'nemo'za, naga'zmire kva hutere hu'naza vaheki'za, Israeli vahepi vugote'za kevu'zmire kegava hutere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Hige'ne Moseseke Aronikea Ra Anumzamo'ma zamagi ahe zanasmia kante anteke zamavare atru hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Hagi 2 ikamofona ese zage gnare kema hiaza hu'ne, maka vahera zamavare atru hu'na'e. Zamagehonte zamagehonte, nagate, famote zamagima metere hu'nere, 20'a kafureti mareri anagate'nea vahera, mago mago vahe'mofo zamagi kre'ne eri fatgo hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Hagi Ra Anumzamo Mosesema asami'nea kante anteno Sainai ka'ma mopafi hamprino zamagi'a kre'ne. ");
INSERT INTO kbq_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Israeli agonesa mofavre Rubeni, ne' mofavre nagara agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke hate vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'ne. ");
INSERT INTO kbq_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Rubeni nagapintima venenema hamprino kre'nea vahera 46 tausen 500'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeoni, ne'mofavre agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke hate vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","maka Simeon naga'ma hampri'nazana 59 tausen 300ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gati ne'mofavrea agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate'ma vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","maka Gati naga'ma hampri'nazana 45tausen 650ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Juda ne'mofavrea agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate'ma vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","maka Juda naga'ma hampri'nazana 74 tausen 600ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakar ne'mofavre age'hontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate'ma vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","maka Isakar naga'ma hampri'nazana 54 tausen 400ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebuluni nemofavre nagama agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke hate vuga hu'nea vahe'ma, kafu'zmimo 20retima mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","maka Zebuluni naga'ma hampri'nazana 57tausen 400ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Josefe ne'mofavre Efraemi naga'ma agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke hate vuga hu'nea vahe'ma, kafu'zmimo 20reti'ma mreri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","maka Efraemi naga'ma hampri'nazana 40tausen 500ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Josefe ne' mofavre Manase naga'ma age'honteti'ma eno, nezmafante e'nea vahe zamagi'ane magoke magoke hate vuga hu'nea vahe'ma, kafu'zmimo 20reti mareri anagate'nea, vahe zamagi kre'neana, 32 tausen 200ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Maka Manase naga'ma hampri'nazana 32 tausen 200ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benzameni naga'ma agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate vuga hu'nea vahe'ma, kafu'zmimo 20reti'ma mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","maka Benjamen naga'ma hampri'nazana 35tausen 400ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dani nagama agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate vuga hu'nea vahe'ma, kafu'zmimo 20reti'ma mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","maka Dani naga'ma hampri'nazana 62tausen 700ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aseli naga'ma age'hontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate vuga hu'nea vahe'ma, kafu'zmimo 20reti'ma mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","maka Aseli naga'ma hampri'nazana 41tausen 500ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nafatali naga'ma agehontetima eno, nezmafante e'nea vahe zamagi'ane magoke magoke vahe'ma hate vuga hu'nea vahe'ma, kafu'zmimo 20reti'ma mareri anagate'nea, vahe zamagi kre'neana, ");
INSERT INTO kbq_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","maka Naftali naga'ma hampri'nazana 53 tausen 400ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ama'i Moseseke Aronikema Israeli venenene 12fu'a naga nofimokizmi kva vahe'ene hamprike zamagi'a kre'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Hige'za maka Israeli vahe'mo'za kognare, famote kafuzmimo 20reti mareri anagatre'nea vahe'ma hate vuga hu'naza Israeli vahe zamagi kre fatgoma hu'nazana, ");
INSERT INTO kbq_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","maka eri mago huno'ma hampriana 603 tausen 550ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Livae nagara zamagehe'inteti eno nezmafante'ma ehnati'neana zamagi'a onkre'naze. ");
INSERT INTO kbq_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Na'ankure Ra Anumzamo'a Mosesena amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Israeli vahe'mokizmi zamagima kresampina, Livae nagara zamagi'a hamprinka anampina onkregahane. ");
INSERT INTO kbq_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kagra Livae nagara zamazeri otige'za noni'afi eri'za eneri'za, maka'za agu'afi me'nea zane, eri'zama eri nenantaza zante kegava hiho. Seli mono nomofo (Tabernacle) agu'afi me'nea zana eri'za vano nehu'za, kegava hugahaze. Ana seli noni'amofo tvaonte nozmia ki'neza kva krigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Hanki kama vunakura, seli noni'a Livae naga'moza tagna vaziza repsi hu'za, umanisarera ete'za azeri otigahaze. Ana eri'zante huhampri onte'nesia vahe'ma ana tvaonte'ma esazana zamahe fri'gahaze. ");
INSERT INTO kbq_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israeli ne'mofavre'moza kumama antesazana mago mago naga kevumo agragu agragu kumara nenteno, sondia vahe'zmine, krauefa nerfi'za manitere hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Hanki Livae naga'moza seli mono noni'amofona tavaontera kumara ante kagigahaze. Hagi Israeli vahe'mo'za efresage'na nasivazi zmante'zanku, Livae naga'moza seli mono noni'a vugote'za kegava krigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israeli ne'mofavre'mo'za Ra Anumzamo Mosese asmia kante ante'za, maka'moza zamagra ana hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ra Anumzamo'a Mosesene Aroninena anage huno zanasami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Israeli vahe'mo'za nagate nagate rure rure hu'za nona negi'za, nezmageho krauefa (flag) avame'za zamente rentetere nehu'za, atrumahu Seli mono noni'amofona ante ogantute'za seli no kumazmia antegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Hanki zage hanati kaziga Juda naga kuma menigeno, sondia vahe'zmine Juda ne'mofavre nagapinti Aminadab nemofo Nasoni kegava huzamantegahie. ");
INSERT INTO kbq_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Hagi sondia kevu'ane, ana miko zamagima kre tru'ma hu'nazana 74 tausen, 600'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Agri asoparema kisazana Isaka agehe'ze, Isaka nagate'ma kegava hu'neana, Zuar nemofo Netanieli'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Hagi sondia kevu'ane, ana miko zamagima kre tru hu'nazana 54 tausen 400'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Anantera Zebuluni agehe'ze, Zebuluni ne'mofavrefinti Heloni nemofo Eliabu kva mani'ne. ");
INSERT INTO kbq_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Hagi sondia vahe'ane, ana miko zamagima kre tru hu'nazana 57 tausen, 400'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Juda nagapima agrane mani'nazana ana mika 186 tausen, 400'a sondia vahere. Kama vunaku'ma hnageno'a, zamagra vugota hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Henkamu sauti kaziga Ruben naga'mo'za krauefazamia ante'za kumara ante'za manigahaze. Rubeni nagama kvama huzmantesiana Sedeur nemofo Elizuri'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Hagi sondia vahe'ane ana miko zamagima kre tru hu'nazana 46 tausen, 500'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Hanki asoparegama mani'nazana Simeon agehe'ze, Simeon naga'ma kegava huzmantesiana, Surisadai nemofo Selumieli'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Hagi sondia kevu'ane ana miko zamagima kre tru hu'nazana 59 tausen 300'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Anantera Gati agehe'ze, Gati nagama kegava huzmantesiana, Deuel nemofo Eleasafi'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Hagi sondia kevu'ane ana miko zamagima kre tru hu'nazana 45 tausen, 650'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Rubeni agorga kuma ante'za agrane mani'nazana ana maka'a 151 tausen, 450'a sondia vahere. Juda naga'mokizmi zamefi zamagra vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hanki Livae vahe'mo'za kuma ante'za mani'nare atruhu seli mono nona amu'nompi kofi'za vugahaze, kuma ante'za mani'naza avamente avamente nevu'za mago mago'mo'za kumazmimofo krauefa amefiga eri'za vutere hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Zage fre kaziga Efraemi krauefane, sondia vahe'zmine, kuma megahie. Ana agu'afi Efraemi ne'mofavremo Amihuti nemofo Elisama kvazmia manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Hagi sondia kevu'ane ana miko zamagima kre tru hu'nazana 40 tausen, 500'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Efraemi naga asoparema kuma ante'sazana, Manase agehe'ze. Manase nagama kegava huzmantesiana, Pedasuri nemofo Gamalieli'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Hagi ana miko sondia vahe zamagima kre tru hu'nazana 32 tausen, 200'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Anante'ma esnazana Benjamen agehe'ze, Benjamen nagama kegavama huzmantesiana, Gideoni nemofo Abidani'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Hagi ana miko sondia vahe zamagima kre tru hu'nazana 35tausen, 400'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Hagi anante'ma esnazana Efraemi nagare. Hagi ana miko sondia vahe zamagima kre'nazana 108tausen, 100'a vahere. Ama ana naga'mo'za nampa trire kevu hu'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Anagamu noti kazigama kumama ante'za krauefa zaminema manisazana, Dani naga sondia vahe'mo'za kumara ante'za manigahaze. Dani nagatema kegava haniana, Amisadai nemofo Ahieza kvazmia manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Hagi ana mika sondia vahe zamagima kre tru hu'nazana 62tausen, 700'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Dani asopare kumama antesazana Aseli agehe'ze, Aseli nagama kegava huzmantesiana, Okran nemofo Pagieli'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Hagi sondia vahe ana miko zamagima kre tru hu'nazana 41 tausen, 500'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Anante'ma esazana Naftali agehe'ze. Naftali nagama kegava huzmantesiana, Enan nemofo Ahira'e. ");
INSERT INTO kbq_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Hagi ana maka sondia vahe zamagima kre tru hu'nazana 53 tausen, 400'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dani naga'ma mani'neregama kumama ante'za mani'naza vahe'ma zamagima kre'neana, ana maka 157tausen, 600'a vahere. Zamagra atuparega henka krauefa zamine vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ama'i Israeli vahe'ma nagate nagate, kumate kumate eri magoma hu'za hampri'nazana, ana maka vahera 603 tausen, 550'a vahere. ");
INSERT INTO kbq_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ana hianagi, Ra Anumzamo Mosesema asmi'nea kasegere amage ante'za, Livae nagara Israeli vahepina eri mago hu'za ohampri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israeli vahe'mo'za Ra Anumzamo Mosesema asmi'nea maka kasegere amage ante'za, kevure kevure krauefana (flag) nezamageho avame'za renente'za, seli nonkuma antetere hu'za nagate nagate eri zogiza vutere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ama'i Mosesene, Aronikizni naga'mokizmi naneke, Ra Anumzamo Sainai agonafi Mosese asamigeno krente'nea naneke. ");
INSERT INTO kbq_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ama Aroni ne'mofavre'mokizmi zamagi'e, Agonesa'a Nadabuki, Abihuki, Eliesaki, Itamari'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Anantera Aroni ne'mofavre zamagi eri otage huno huhampri zamantege'za, Ra Anumzamofo avufi veamokizmire te vugote'za mani'ne'za pristi eri'za eri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Hianagi Nadabu'ene Abihukea Ra Anumzamofo avuga agra ragisa teve i'o hu'nea teve hegre amiteke, Sainai hagage mopafi zanagra mofavrea onte'neke Ra Anumzamofo avuga fri'na'e. Hakeno Eliesa'ene Itamarikea, Aroni pristia mani'negene neznafa azahuke maka zupa pristi eri'zana eri'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ra Anumzamo Mosesena amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Livae nagara zamavarenka pristi ne' Aroninte egofa huge'za, aza hu'za mono eri'zana eriho. ");
INSERT INTO kbq_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Zamagra eri'zama hantagi zami'nere Aroni eri'zane, veamokizmi eri'zane eneri'za, seli mono nomofo fegi'a eri'zanena erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Seli mono nomofo agu'afima me'nea maka'zana kegava nehu'za, Israeli vahe'mokizmi eri'za eri nezmante'za, seli mono nompima hantagi zami'nea eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Hanki kagra Livae nagara Aronine amohe'ine zami vagarenka Israeli vahepintira zamige'za eri'zana eriho. ");
INSERT INTO kbq_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Hagi kagra Aronine ne'mofavre naga'anena huhampri zamantege'za pristi eri'zana eriho. Hagi huhampri onte'nesia vahe'ma seli mono nonte eravao hanazana zamahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ra Anumzamo mago'ene Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Menina ko, Nagra Israeli vahepinti Livae nagara agonesa ne'mofavre'gna hu'na zamavarena Nagrarega zamantoge'za nagri vahe fatgo mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Na'ankure maka'a pusa ne'mofavrea Nagri zane, Isipi mopafi pusa ne'mofavre zamahe fri'noa zupa, Nagra su'zane hu'na pusa ne'mofavre Israeli vahepi fore haniane, zagagafanena huhampri'noe. Maka Nagri zane, Nagra Ra Anumzamo'na nehue. ");
INSERT INTO kbq_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Anante Ra Anumzamo Sainai ka'ma mopafi Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levai ne'mofavre nagara nagate famote, maka venene mago ikanteti marerinesima'a hamprinka zamagia krento. ");
INSERT INTO kbq_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Higeno Ra Anumzamo asmia kante anteno Mosese'a venene'a zamagia kreno eri fatgo hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ama'i Livae ne'mofavre naga zamagie, Gersoni'e, Kohati'e, Merari'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ama'i Gersoni ne'mofavre naga nofipintira Libnike, Simeike, ");
INSERT INTO kbq_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohati ne'mofavre naga'nofipintira Amramu'e, Izhari'e, Hebroni'e, Usieli'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari naga nofipintira Malike, Musike. Livae nofipinti fore hu'naza naga nofi mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Hagi Gersonimpinti fore hu'naza nagara Libni naga'ene, Simei naga'enemo'za, zamagra Gersoni vahere hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Makama hampri'nazana venenema, mago ikanteti mreri anagate'neana, maka seven tausen 500'a vene'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gersoni vahe'mo'za zamagra seli mono nomofo amefiga'a zage fre kaziga seli nonkumara ante'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Hagi Gersoni naga'mokizmi kvazamia Laeli ne'mofo Eleasafi manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Hagi Gersoni ne'mofavremokizmi eri'za kankamuna amana hu'ne, seli nomofo agu'afine, seli noma refimate'zane, kafa zafare refite'nea tvaravene, kegava hu'neza erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Vahe atru hu kumapi, megi'a ruvanre'naza tvaravene, kahante seli nompi renentaza tvaravene, kresramna vu itare avuga me'nea tvaravene, nofitamine, agima hentea zama'a zamagrake kegava hu'neza erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Hagi Kohati naga nofipintira, Amramu nagaki, Ishara nagaki, Hebroni nagaki, Usiel nagaki, ");
INSERT INTO kbq_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ana maka vene'ne mago ikanteti mareri anagate'nea hampri'nazana, 8tausen 600'a vahe'mo'za hunagru hunte tva'oma'arera kegava hu'neza eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohati nagapinti fore hu'naza naga'mo'za, seli mono nomofo sauti kaziga seli nonkumara ante'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Hagi Kohati nagapintima kvaza erino kegava huzmante'neana, Uzieli nemofo Elizafani'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Eri'zama erisazana amanahu hu'za erigahaze, huhagerafi huvempage vogisine, teboline, tevi rekru hunte zotane, Kresramana vu itaramine, kresramna vu eri'za zantamima kazima, kavoma, sipunima, foku'ma, zompama (utensils), nagru hu'nea agu'afi me'nea zantamine, tvaravene kema huntea zama'a kegava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hagi Pristi ne' Aroni nemofo Eleasa vugoteno Levai nagate kva mani'neno, seli mono nomofo agu'afi eri'zana kegava huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari naga'ene Musa naga'enena, zamagra Merari nagare hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Hagi hampri'ma zamante'nazana, mago ikanteti mreri anagate'nea vene'nea 6 tausen 200ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari nagama kegava huzmante'neana, Abihail nemofo Zulieli'e. Zamagra seli mono nomofona noti kaziga kuma ante'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hagi Merari naga'mokizmi eri'zana, seli mono nomofo reharere zafarmine, arunkre hu zafagi, antani kantugma hu' zafarmine, azeri hanaveti zafane, eriza'zane kegava hu'neza eri'zama zami'nare eri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Hagi agu'afinka megagi'nea posi zafarmine, no azeri hanaveti zafarmine, seli no avazu huno nofi ome rentere hania azotaramine, nofi'ma rente'zantamine kegava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Hanki zage hanati kaziga seli mono nomofo avuga'a kuma ante'za mani'naza nagara, Moseseki, Aroniki, ne'mofavre naga'zniane mani'neza, hunagruma hu'nea nomofo agu'afina Israeli vahe'mokizmigu hu'za eri'zana eri nezmante'za mani'naze. Hagi huhampri ozmante vahe'ma ana tva'onte esnimofona ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Livae naga'ma Ra Anumzamo Mosese'ne Aronigizni znasmi'nea kasegere amage ante'ne, mago ikanteti mareri anagate'nea naganofiteti, ese agonesa mofavre nona huke hamprina'ana maka 22 tauseni'a vene'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Hagi Ra Anumzamo Mosesena amanage huno asami'ne, Israeli vahepi pusa ne'mofavre fore hanigeno mago ikanteti mareri anagate'nesiana, erigafa hunka zamagi'a krento. ");
INSERT INTO kbq_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Israeli vahe'mofo ese agonesa mofavrema avregazana netrenka Livae nagara zamavare namio, Nagra Ra Anumzane, Livae vahe'mofo bulimakao afuzmimo'ma pusama antesia anentara, Israeli nagamokizmi pusa bulimakamofo nona hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ana higeno Israeli vahe'mokizmi maka pusa ne'mofavre'a Ra Anumzamo asmi'nea kante anteno Mosese'a hampri'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Pusa ne'mofavre mago ika agatereno mareri anaga te'nea naga zamagi eri'neana, 22 tausen, 273'a vene'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Anante Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Israeli vahepintira pusa ne' mofavre'mokizmi nona hunka, Livae vahera nezmavrenka, Israeli vahe agonesa bilimakao nona hunka Livae naga bulimakaone erio. Huge'za Livae vahera zamagra Nagri naga manigahaze. Nagra Ra Anumzane. ");
INSERT INTO kbq_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Hagi 273'a Israeli vahe'mokizmi pusa ne'mofavre'moza, Livae naga'ma zamagtere'nare miza segahaze. ");
INSERT INTO kbq_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Seli mono nomofo zagomofo kna'a avamente kagra 5fu'a silva zago magoke magoke vahetera eritere hugahane. ");
INSERT INTO kbq_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Livae naga zamagtere'naza nona huta miza sezmante zago, Aronine ne'mofavre'ane zamio. ");
INSERT INTO kbq_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Higeno Mosese'a zagoa zogino Israeli vahe'mokizmi pusa ne'mofavre'mokizmi nona huno Livae naga nona huno miza sezmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Pusa ne'mofavre Israeli vahepinti fore'ma hu'naza nagapintira Mosese'a 1tausen, 365'a silva zagoa erino, hunagru hu'nea seli mono nomofo kna'amo hu'nea avamente ana zago'a zogite'no ");
INSERT INTO kbq_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mosese'a ana zagoma mizama sezmantesia zagoa erino Aroni'ne, ne'mofavre naga'a Ra Anumzamo'ma asami'nea kante erino zamazampi ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Anante Ra Anumzamo'a amanage huno Mosesene, Aronikizni zanasmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Kohati agehe'impinti fore hu'naza vahera nagate, famote, hamprinka Livae nagara zamagi'a krenka eri fatgo huo, ");
INSERT INTO kbq_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","maka 30'a kafureti marerino 50'a kafuma hu'nesaza vahe'ma, seli mono nompima eri'zama eriga hu'nesaza venene'a hampri'o. ");
INSERT INTO kbq_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Hagi Kohati naga'moza seli nompina hakare zupa amanahu eri'za erigahaze, seli mono nompima, hunagru hunte nomofo agu'afi ruotgema hu'nea zantminte kegava hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Hagi Israeli vahe'mo'za kumazmi atre'za vunaku hanageno'a, Aroni'a mofavre naga'ane mareri'za kafanteti tvarave hantiza huhagerafi huvempage vogisia ana tvaravereti eri ano vazigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Hagi anantera hagerimpi bulimakao akru'anu refinete'za, ana agumpina hokonke tvaravenu refinete'za, tare azota antanintegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Hagi ana'ma hutesu'za bretima nentaza itamofona hokonke tvarave eri'za tafera hute'za, ofama hu'zantamina ana agofetura nente'za zuompama, kavoma, tima tagi tafe taminena nente'za, bretinena antekeno maka zupa itamofo agofetura mevava hino. ");
INSERT INTO kbq_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ana hute'za koranke tvarave reti ana makazana refiteho, ete'za ana agofetura hagerimpi bulimakao afu'mofo ukri'anu refinete'za, tare kaziga kampi erisgahu zota antanintegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Mago hokonke tvarave eri'za tavi'ma rekru hunte'zamofo zota'ane, lamune, teve anefa resu hu'zane, zuompane, tevemofo masave tintfene, eri'zama eneriza zanena refitegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Hagi ana maka'zana hagerimpi bulimakao ukri'afi eri anakite'za afunte kofi azotare erinte'za anakintetere hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Kolire itamofo agofetura hokonke tvaravenu refitete'za, hagerimpi bulimakaomofo ukrira ana agofetu erinte'za anakite'za, tare vimago zafa antanintegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Anantera hokonke tvarave masine'za ana maka agu'afi eri'za eneriza zantamina (utensils) anakite'za, ana agofetura hage rimpi bulimakaomofo ukri'areti refitete'za, tare vimago zafa, zafama hu'zana vazintegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ana nehu'za, bronsire itaretira (alta) ta'nefara katenetre'za fitu tvarave eri'za ome refitegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Anazanke hu'za eri'zama eneriza zantamina antesazana tevefi kre kavoma, foku'ma, savolima, zompama, maka itare'ma (alta) me'nea zanena, hagerimpi bulimakao afumofo ukriteti agofetura refite'za anakite'za, zafama hu'za vanaza zafa antanintegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aroni'ene ne'mofavre naga'amo'zane seli nomofo agu'afi maka ruotge'ma hu'nea zantamina anakiza erise hutesage'za, ana kumateti hage'za vunaku hanage'za, Kohati ne'mofavre'moza emerigahaze. Hanki ruotge zantamina avako osugahazanki, avakoma hanazana frigahaze. Ama'i ruotge seli nompi me'nea zana, Kohati ne'mofavremoza zamagrake'za eri'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hagi pristi ne' Aroni nemofo Eleasa kva hania'zana tavi'mofo masavene, mnanentake zama kremna vu'zane, maka zupa ofa nemiza witi ragane, asomu huzmante'za frenezmantaza masavene, seli nomofo eri'za zantamine, agu'afima maka'za me'neane, hunagru hunte'nea nomofo agu'afi me'nea zanena agrake maka kegava hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Hagi Ra Anumzamo'a Mosesene, Aronikizni anage huno zanasmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Livae naga nofipintira, Kohati ne'mofavre nagara zamatrenke'za fri hana osiho. ");
INSERT INTO kbq_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Kohati naga'mo'za ruotge hu'nea zama kege vu kofta hu'za avako huge, hanuza fri hana huzanku Aroni'ene, ne'mofavre naga'amo'za mareri'za erise hutesage'za, eri'za kankamu zamire kofiza vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Hu'neanagi Kohati naga'mo'za osi'a knafinena agu'afina mareri'za ruotge'ma hu'nea zantamina onkegahaze. Hanki anazantamima kesuza frigahaze. Ama'i Gersoni naga'moza eri'naza erizamofo naneke. ");
INSERT INTO kbq_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Hagi Ra Anumzamo amanage huno Mosesena asami'ne. ");
INSERT INTO kbq_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Gersoni ne'mofavre nagara anazanke hunka zamagia krenka nagate famote, eri fatgo huo, ");
INSERT INTO kbq_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","maka 30'a kafureti marerino 50'a kafuma hu'nesaza vene'nea, seli mono nompima eri'zama eriga hu'nesaza venene'a hampri'o. ");
INSERT INTO kbq_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Hagi Gersoni naga'moza, seli mono nomofo agu'afi eri'za eneriza, eri'za vano hanazana amana hugahaze, ");
INSERT INTO kbq_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","zamagra seli mono nomofo ra tavaravene, agofetu refite'nea tavaravene, hagerimpi bulimakao ukarinu agofetu refite'neane, seli mono nomofo kasante ra tvarave hanti'naza zama'a erigahaze, ");
INSERT INTO kbq_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","megi'a refite kagi'naza tavaravene, mareri kahante'ene kresramna vu itare (alta) hanti'naza tavaravene, nofi tmine, ana miko eri'za zantamina Gersoni naga'mo'za erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Hagi Gersoni naga nofi'mo'za maka'a zupa, Aroni'ene ne'mofavre naga'amozama hanaza kemofo amage ante'za kofi'za vutere hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gersoni naga'mokizmi ne'mofavre'moza seli mono nomofo eri'zama eri'sazana, pristi ne' Aroni nemofo Itamari Merari nagara kegava hu'nena ana eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Livae nagapinti Merari ne'mofavre nagara, kagra zamagi krenka nagate, famote, eri fatgo huo. ");
INSERT INTO kbq_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Maka 30'a kafuma hu'nesia vahetetima marerino 50'a kafuma hu'nesaza vahe'ma, seli mono nompima eri'za eriga hu'nesaza venene'a hamprio. ");
INSERT INTO kbq_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Zamagra amanahu eri'za erigahaze, maka seli mono noma ahegagi'naza zafane, zaza zafane, re trure zafane, rusihu (soket) zafane eri'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Vahe'ma atru nehazafi retrumare'nea zafane, rusihunte (soket) zafane, nofi tafinteno omo azeri eme azeri hu zafane (pegs), nofi'tamine, maka'a eri'za zane, zamagire zamagire kegava hu'nesaza zane eri'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari naga'mokizmi ne'mofavremo'za seli mono nompi eri'zama zamasmia kante ante'za erigahaze. Hagi pristi ne' Aroni nemofo Itamari kegava ana eri'zana hu'nena erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Hige'za Mosese'ene, Aroni'ene, vahe kevure kva hu'naza vahemo'zane, Kohati naga nofira, nagate famote, ");
INSERT INTO kbq_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","maka 30'a kafureti marerino 50'a kafuma hu'naza vahe'ma, seli mono nompi eri'zama eriga hu'naza vene'nea hampri'za eri fatgo hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ana maka'ma nagate famote hampri'naza venene'a, 2 tausen 750'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ama'i maka Kohati ne'mofavre, seli nomofo agu'afi eri'zama eriga hu'naza vahe zamagi hamprike eri fatgo hu'na'e. Mosese'ene Aronike hampri'ne Ra Anumzamo'ma Mosese asmi'nea kante anteke avaririna'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gersoni ne'mofavrema, nagate famote hamprina'ana, ");
INSERT INTO kbq_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","maka 30'a kafureti marerino 50'a kafuma hu'nesaza vahe'ma, seli mono nompima eri'zama eriga hu'naza vene'nea, ");
INSERT INTO kbq_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","maka nagate famote zamagima krene eri fatgoma hu'na'a vene'nea, 2 tausen 630ti'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ra Anumzamo'ma Mosese asmi'nea kante anteke Gersoni ne'mofavre naga seli mono nompi ana maka eri'za eri'naza vene'ne zamagi'a, Mosese'ene Aronike hampri'ne eri fatgo hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari mofavre nagate famote hu'za zamagima krente'nazana, ");
INSERT INTO kbq_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","maka 30'a kafureti marerino 50'a kafuma hu'nesaza vahe'ma, seli mono nompima eri'zama eriga hu'naza vene'ne, ");
INSERT INTO kbq_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","zamagima nagate famotema hu'za kre'nazana 3tausen 200ti'e ");
INSERT INTO kbq_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ra Anumzamo'ma Mosesema asmi'nea kante anteke Merari ne'mofavre naga seli mono nompima ana maka eri'za eri'naza vene'ne zamagi'a, Mosese'ene Aronike hampri'ne eri fatgo hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Higeno Mosese'ene, Aroni'ene, Israeli vahe'mokizmi kva vahe'mo'za Livae naga nofira, hampri'za nagate famote eri fatgo hu'nazana, ");
INSERT INTO kbq_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","maka 30'a kafureti marerino 50'a kafuma hu'naza vahe'ma, seli mono nompima eri'zama eneri'za, ana zantamima kofiza vuga vene'nerami hampri'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Maka Livae venene'a zamagima kre'nazana, 8 tausen 580'e. ");
INSERT INTO kbq_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ra Anumzamo'ma Mosesema asmi'nea, kante anteke zanagra seli mono nompi eri'zama e'neriza zantamima kofizama vanaza vahe zamagi'a krente'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Anante Ra Anumzamo amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Israeli vahe'ma fugo namu kri eri'nesazane, avo' herafineramisiane, korankri eri'nesiane, fri' vahe avufgare avako hu'nesaza vahera, huzmantege'za kumamofo fegi'a umaniho. ");
INSERT INTO kbq_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Vene, a'nene huzmante'gahane, Nagra kumazmimofona amu'nozmifi nemanuankino, zamagra ana kuma eri kasri'zankura huzmante'geza fegi'a umaniho. ");
INSERT INTO kbq_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israeli vahe'mo'za Ra Anumzamo'ma Mosesema asmia kante ante'za kri eri'naza vahera huzmantage'za kumamofo fegi'a umani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Anante Ra Anumzamo anage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Israeli vahera zamasamige'za vemo'o, a'mo'o vahe'mo nehiaza huno Ra Anumzamofo antahi omino rumofoma azeri haviza huno kumi hanimo'a, haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Hagi vemo'a inazano hu'nesia kumira hufore nehuno, kumi'amofo mizana kna'amo nankna hu'nesio miza sevaga nereno, mago nazatigati mago kevu ruguheno ana agofetu kumi huntene'snimofona amigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Hianagi kumi hunte'nea ne'mofo afu'agnama fri hana hu'nesigeno'a, miza senaku hu'nesia mizane, kumi atrente ve rama afura avreno Ra Anumzamofo aminkeno pristi ne'mo erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Israeli vahe'mo'za ruotge hu'nenia ofa hu'zama pristi nete eri'za esazana, ana miko pristi ne'mo erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Maka ofama vahe'mo'ma hanageno pristi ne'mo'ma erisiana agriza segahie. Hagi mago a'mo'ma ru venema savri hania zamofo kasege. ");
INSERT INTO kbq_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Anantera Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Israeli vahera ke hunka zamasmio, mago ne'mofo a'mo nevenku ontahi havi avu'ava nehuno, ");
INSERT INTO kbq_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mago ve'ne ana a'mo monko'za hu'nesigeno, neve keno erifore osanigeno vahe'mo'enena kefore huno eri ama osnianagi, ana a'mo'a agra'a agu'a eri haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Hagi neve'ma ana a'mofoma hugofinte antahi antahimo agateresigeno nenaro havi avu'ava hu'nesia zanku, hu'neo osu'neo agenoka huno antahi anke'renaku, nenaroma antahi havizama huntesuno'a, ");
INSERT INTO kbq_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ana ne'mo nenarona avreno pristi nete vuno, ofama hu'za witi flaua mago kilo erino, olivi masvene, kremna vu pauranena ana agofetura onteno, hugofinte ofamofo witigino kumi' hu'neazamo agekni zanku, antahi antahi hugeke hu'mofo ofe. ");
INSERT INTO kbq_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Anante pristi ne'mo ana ara avreno eno Ra Anumzamo'na navuga eme azeri otinteno. ");
INSERT INTO kbq_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Hagi pristi ne'mo ruotge hu'nea tine, mopare kavone erino, seli mono nomofo agu'afinti kugusopa kateno ana timpina atregahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Hagi pristi ne'mo'a ana ara Ra Anumzamo'na navuga azeri otineno, hanigeno azokara vasane netreno, antahi antahi hu'mofo witi ofa azampi erinenteno, nazinkere'ma hu ofa witi pristi ne'mo'a akake ti tusi hunte tina azampina erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pristi ne'mo'a ana ara antahigeno, tamagema nehanunka huama huo, mago ne'mo kagrane omse'nena havi avu'ava osu'nesunka, negave kemofo amage antenka mani'nesnunka, ama akake timo tusi hugantenaku hniana agateregahane. ");
INSERT INTO kbq_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Hagi kagrama savri ka nentenka, negave amage antenka omaninka, negave'ene hugaza ru vene monko'zama hunesunka, kagra kagu'a azeri haviza hu'nanankino Anumzamo kazeri haviza hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Pristi ne'mo'a ana ara huvempa hunteno anage hugahie, vahetamimo'ma keno antahinoma haniana, Ra Anumzamo'a kazusi hunteno mofavregura erigigeno amu'mo'a zore hu'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Hankino ama timo tusi huganteno kagupafi ufreno, ana timo eri'za erinkeno kamumo zonerena, kamo'ma osasi hugahie hanigeno, ana a'mo'a huno, ana hugahie. Ana hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Hagi pristi ne'mo'a anama kazusima huntesia kea avompi krenteteno sese hinkeno ana timo'a akake timpi tagi ramigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Anante pristi ne'mo'a tusi hunte'nea akake tina ana a'ra ami'nigeno, tusi huntenea akake tina nenkeno agu'afi aka hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Pristi ne'mo ana a'moma azampima eri'nea ofa erino, ana ofa Ra Anumzamo'na navure marerino amira amira nehuno, erino kresramna vu itare (alta) vugahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Anama hute'na pristi ne'mo ana ofahu witia, mago aza eri viteno antahi antahihu ofa Kresramana vu itare (alta) krenkeno kumpi marerino. Ana huteno henka ana a'mofo aminkeno ana tina negahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ana tima aminkeno netena, ana a'mo monkoza huteno neve revatga hu'nesigeno'a, ana tusi hunte'nea (kes) tima nesnia timo'a akake agu'afina nehinkeno, amu'mo'a zorenkeno, amo'mo'a osasi hanigeno, ana a'mo'a vahe'amokizmi zamufina kefo a' manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Hianagi a'mo'ma agu'a eri pehena osu mani fatgo hu'nesnigeno'a, ana tusi (kes) hu'nenia kemo'a agaterenkeno, mago zamo avate osnigeno mofavre kasentegahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ama'i nazinkemofo kasege, vere a'mo neve'ene mani fatgo osuno atreno vuno ru vene ome savri haniano, ");
INSERT INTO kbq_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","neve'ma nenaro antahi haviza hunteno nazinke huntesuno'a, Ra Anumzamofo avure neve'a ana ara avreno vinkeno pristi ne'mo ana maka kasegea a'mofona hantagi amigahie. ");
INSERT INTO kbq_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Hagi vemo'a hzenke osugahianki, a'mo agra'a ana kumi'mofo knazana erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mago'ene Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Israeli vahera amanage hunka zamasmio, mago vemo'o, a'mo'o mani ruotge huno Ra Anumzamo'nare huvempa huno ruotge hu'na Nazareti vene a'ene manisue hanuno'a, ");
INSERT INTO kbq_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","waini tine, hankave tine aka tine, waini reratiza hankave ti tro hunte'nesazo, grepimofo tima'o, nena raga'o, hagege hune'sia raga'anena onegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mani ruotge hugahue huno'ma hu'nesia kna'afina, krepiretima tro hu'nesia wainine, avima'ane ukri'anena onegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Huvempama hu'nesia kna'afina maka zupa resanura anu azokara oharegahie. Ra Anumzamofonte huvempa hunte'nenia kna'afina ruotge huno mani'neno, anu azokara atrenkeno metoku aseno zaza hino. ");
INSERT INTO kbq_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ra Anumzamofonte mani ruotge huno mani'nesia kna'afina, agra fri vahe tvaontera ovugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hagi nefa'o, nerera'o, nefu'o, nesaro'o frisigeno'a agrira azeri pehena hugahianki avakora osino. Na'ankure Anumzamofonku huno mani ruotge hu'nea avame'zana agri anunte me'ne. ");
INSERT INTO kbq_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Mani ruotge huno mani'nia kna'afina maka'a zupa, Ra Anumzamo'nare mani ruotge hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Hianagi mago vahe'ma tvaoma'are mani'neno antrima haniaza huno frino, huvempama hu'nea azokama eri pehanama hinkeno'a, 7ni'a zagegna maniteno azeri agruma huknarera anu azokara haregahie. E'inama hanuno azeri agru huno manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Hagi anante nanterana 8 zage knarera tare hohopa namao, tare maho namo azerino pristi ne' avuga seli mono nomofo kahante vugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Pristi ne'mo'a mago nama kumi'ma apasente ofa nehuno, mago nama kre fanene hu ofa hugahie. Na'ankure fri vahe tva'onte mani'neno kumi' hu'negu mizaneseno, ana zupa anunte azokara eri ruotge hanigeno hagegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ana nehuno Ra Anumzamofonte ete agu'a nenteno, mani ruotge huno Nazareti ne'ma manisuema hanuno'a, mago kafu hu'nesia ve sipisipi anenta avreno kumi'mofo ofa hino. Na'ankure ko'ma mani ruotge hu'nea zama fri'zamo eri haviza hunte'negu, eteno mago'ene huvempa kea eri agafa hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Hagi mani ruotge huno Nazareti vahe tro huno mani'nea kna'ama vagare'na, agra seli mono nomofo kafante eno, ");
INSERT INTO kbq_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ra Anumzamo'nare kre fanenema hu ofama eri'noma esiana, mago kafu hu'nesia ve sipisipi afuhe afuhe osu'nesia su'a avreno ne-eno, kumi'ma apasente ofama haniana, mago a' sipisipi mago kafu huno afuhe afahe osu'nesia avreno ne-eno, rimpa fru ofama haniana, mago kafu huno afuhe afahe osu'nesia sipisipine avre'no eme ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Hagi witi ofama hu'zana, mago eka eka kupi, zo-ore breti krenenaza eri'za ne-eza kaneza eri knare hu'naza flaua masavene eri havia huza kre'naza kekine, waini ofanena hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Hagi ana ofama pristi ne'mo'ma Ra Anumzamofo avuga erino eme haniana, esera kumi' apasente ofa huteno, anantera tevefi kre fanene hu ofa hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ana nehuno rimpa fru ofa ve sipisipi Ra Anumzamofonte kresramna nevuno, zo-ore bretia eka eka kupi ante'nea ofa nehuno, pristi ne'mo'a anazanke huno witi ofane, waini ti ofanena hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ana hutena Nazareti vahe manisuema huno'ma mani ruotagema hu'nea ne'mo anuntetira azokara seli mono nomofo kahante ome hareteno, ana azokara rimpa fru ofama kre'nenifi fenka kaziga krenkeno tegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Hagi ana'ma hute'na pristi ne'mo'a ve sipisipimofo azona'a kavoma krenenafinti e'nerino, ekaeka kupinti zo-ore bretia mago e'nerino, mago zo-ore ta'ori kekine erino, azokama hare'nea ne'mofo azampi antegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Anante pristi ne'mo'a erisga huno Ra Anumzamonare eri veravema hu ofa hugahie. Hagi eri veravema hia ofane ve sipisipi ahihizane agianena ruotge hugahiankino pristi vahe'mo'zage eri'za negahaze. Pristi ne'mo'ma ana'ma hutena azokama hare'nea ne'mo'a waini tina negahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ama'i Nazareti vahe mani ruotge hu'na Ra Anumzamofo avufi manikurema huno'ma huvempama hania vahe'mofo kasege. Hagi anampima mago'a ofama eri agofetuma huza eriza ega'ma hanige'za amne eri'za egahaze. Nazareti vahe mani ruotge hugahune hu'za huvempama hu'nesaza kemofo amage ante'za anazana hugahaze. Ana'ma hanageno'a, Pristi vahe'mo'za asomu kea huramantegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Aronine, ne'mofavre naga'anena amanage hunka zamasmio, Israeli vahe'ma asomu kema huzmantekura, amanage hunka asomu kea huzmanto. ");
INSERT INTO kbq_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Ra Anumzamo'a asomu huneramanteno, kegava huramantegahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ra Anumzamo muse huneramanteno, tamazeri knare hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ra Anumzamo'a rukrahe huno avugosa huramino tamazeri knare nehuno, Agra'a rimpa fruzana tamigahie. ");
INSERT INTO kbq_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Hagi Nagri nagifi Israeli vahera asomu kea hu'zmantenkena, Nagra'nia asomura huzmantegahue. ");
INSERT INTO kbq_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mosese'ma seli noma ki vagareteno'a, ana nomofo agu'afi me'nea zane ana nonena eri fatgo huno hu ruotge hunteteno, agu'afi me'nea (utensil) zane, kresramna vu itane, eri'za zanena masaveragino frententeno hunagru hunte'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hagi Israeli vahepinti'ma 12fu'a naga nofimokizmi kva vahe'ma huhampri zmantage'za vahe'ma hampri'zana kva vahe'mo'za ofazmia eri'za seli mono nonte e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Hagi ana makamo'za 6si'a refitente'nea karisine, 12fu'a bulimakaone avre'za seli mono nomofo avuga Ra Anumzamofonte e'naze. Hagi mago karisia tare kva vahe'moke eri tragotetere huke erike neakeno, mago mago bulimakaona mago mago kva vahe'mo erino etere hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Anama eri'za eme kami'naza zantamina erinka, eri'zama eneri'za avamente Livae naga zamige'za seli mono nona tagana vazite'za eri'za viho. ");
INSERT INTO kbq_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Higeno Mosese'a ana karisiramine, bulimakoa afu'zaga Livae naga eri zami'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Tare karisine, 4'a bulimakao afura Gersoni ne'mofavre eri'za eneriza avamente eri'zami'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Hagi 4'a karisine, 8'a bulimakao afu'zaga, eri'za eneriza avamente Merari ne'mofavre naga eri zami'ne. Hagi pristi ne' Aroni nemofo Itamari ana nagatera kegava huzmante'nege'za ana maka eri'zana eri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Hianagi Kohati nagara mago zana Mosese'a ozami'ne. Na'ankure zamagri eri'zana hunagru hunte'nea zama seli mono nompi me'nea zantmima zamafunte kofi'za vanaza eri'za me'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Hagi kresramna vu itama hunagru'ma hunte'za masavema frentaza zupa, Israeli kva vahe'mo'za muse ofazmia eri'za vu'za kresramna vu itamofo avuga omente'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Hianagi Ra Anumzamo'a amanage huno Mosesena asmi'ne, Huzmantegeno magoke kva ne'mo muse ofa'a erino mago mago knarera etere hino. ");
INSERT INTO kbq_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Kagota huno ese zagegnare'ma agafa huno'ma ofa'a erino vu'neana, Juda naga nofi'mokizmi kva ne' Aminadabu nemofo Nasoni'e. ");
INSERT INTO kbq_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Agrama ofa hu'neana, mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekels (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zoumpafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Hagi mago golire tro hu'naza kagata hu'nea zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mna nentake'za insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Ana nehuno tevefima kre fanenema hu' ofama hu'zana mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Ama'i Aminadabu nemofo Nasonima erino e'nea ofaramine. ");
INSERT INTO kbq_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Hagi nampa 2 zagegnarera, Zuari nemofo Natanieli, Isaka naga'mokizmi kva ne'mo, ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Agrama ofa hu'neana, mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zoumpafina kaneza eri knare hu'naza flaua olivi masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Ana nehuno tevefima kre fanenema hu' ofama hu'zana mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Ama'i Zuari nemofo Natanieli'ma erino e'nea ofaramine. ");
INSERT INTO kbq_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Hagi nampa 3 zagegnarera Zebuluni naga nofi'mokizmi kva ne' Heloni nemofo Eliabu ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Agrama ofa hu'neana, mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago ve bulimakao afu'ene, mago kasefa ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Helon nemofo Eliabu, Zebuluni naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Hagi nampa 4 zagegnarera Rubeni naga nofi'mokizmi kva ne' Elizuri nemofo Sedeuri ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Elizuri nemofo Sedeuri Rubeni naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Hagi nampa 5 zagegnarera Simioni naga nofi'mokizmi kva ne' Selumieli nemofo Zulisadaima ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Ana nehuno tevefima kre fanenehu ofama hu'zana, mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea sipisipi anenta'ene avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Zuri Sadaia nemofo Serumieli Simioni naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Hagi nampa 6gisi zagegnarera Gati naga nofi'mokizmi kva ne' Deueli nemofo Eliasafu'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentake'za insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Ana nehuno tevefima kre fanenehu' ofama hu'zana, mago agaho ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentatamina 5fu'a avreno e'ne. Amai' Deueli nemofo Elisafu Gati naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Hagi nampa 7ni zagegnarera Amihud nemofo Elisama, Efraemi naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekels (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentake'za insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago agaho ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Amihudi nemofo Elisama Efraemi naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Hagi nampa 8 zagegnarera Peduzuri nemofo Gamalieli, Manase naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekels (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentake'za insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Peduzuri nemofo Gamalieli Manase naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Hagi nampa 9ni zagegnarera Gidioni nemofo Abitani Benzameni naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zompafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentake'za insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago agaho ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Gidioni nemofo Abitani'ma Benzameni naga'mokizmi kva ne'mo'ma erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Hagi nampa 10ni zagegnarera Amisadai nemofo Ahiezeri, Dani naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","mago silvare kagata hu'nea zuompa kna'amo'a 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zoumpafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago agaho ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve memene mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Amisadai nemofo Ahiezeri Dani naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Hagi nampa 11ni zagegnarera Okrani nemofo Pekieli Asa naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","mago silvare kagata hu'nea zuompa kna'amo'a 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zoumpafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Ana nehuno tevefima kre fanenema hu' ofama hu'zana, mago ve bulimakao afu'ene, mago ve sipisipine, mago kafu hu'nea, sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Okrani nemofo Pekieli Asa naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Hagi nampa 12fu zagegnarera Enani nemofo Ahira Naftali naga'mokizmi kva ne'mo'ma ofama erino e'neana, ");
INSERT INTO kbq_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","mago silvare kagata hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago silvare keri hu'nea zuompa hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekel (800 grems) hu'nea zoumpane erino e'ne. Hagi ana tarega zoumpafina kaneza eri knare hu'naza flaua masavene eri havia hu'nea witi ofa erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Hagi mago golire tro hu'naza kagata zuompa kna'amo'a 10ni'a sekel (110 grems) hu'nea zuompafi mnanentakeza insensia ante aviteno erino e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Ana nehuno tevefima kre fanenema hu' ofama hu'zama erino'ma e'neana, mago ve bulimakao afu'ene, mago agaho ve sipisipine, mago kafu hu'nea sipisipi anenta'ene avreno ne-eno, ");
INSERT INTO kbq_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","kumi'ma apasente ofa mago ve meme afu avreno e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Hagi rimpa fru ofama hu'zama avreno e'neana, tare bulimakaone, 5fu'a ve sipisipine, 5fu'a ve memene, mago kafu hu'nea sipisipi anentataminena 5fu'a avreno e'ne. Amai' Enani nemofo Ahira Naftali naga'mokizmi kva ne'mo erino e'nea ofe. ");
INSERT INTO kbq_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Hagi kresrmana vu itama masavema freno eri otagema hianknarema Israeli vahe'mokizmi kva vahe'mo'za eri'zama e'nazana 12fu'a ra silvare kagata zoumpagi, 12fu'a silvare keri zoumpagi, 12fu'a golire kagata zuompagi hu'za, kresramna vu ita masave frente'za eri otagema hazanknarea eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Hagi mago mago silvare kagata hutere hu'nea zuompa kna'amo 130'a sekel (1.5 kilo) hu'nea zuompane, mago mago silva zuompa keri hu'nea zuompamofo kna'amo'a hunagru hu'nea seli mono nomofo zago miza nesaza avamente, 70'a sekels (800 grems) hu'nea zoumpane eri'za etere hu'naze. Hagi ana mika silva zuomparamimofo kna'amo'a seli nomofo zago avamente 2 tauseni 400'a sekel hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hagi mago'mago 12fu'a golire kagata zoumpa kna'amo'a seli nomofo zago avamente 10 sekeli hu'nea zuompafi mnanentake'za insensia ante avite'za eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Hagi tevefima kre fanenema hu' ofama eri'zama e'nazana, 12fu'a ve bulimakaonki, 12fu'a ve sipisipigi 12fu'a mago kafu hu'nea sipisipi anentataminki hu'za avre'za ne-e'za anama huzmante'nea kante ante'za witi ofa eri'za e'naze. Hagi kumi'ma apasente ofa 12fu'a ve meme afu avre'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Hagi rimpa fru ofama hu'zama avre'zama e'nazana ana makara 24'a bulimakaonki, 60'a ve sipisipigi, 60'a ve memenki, 60'a mago kafuma hu'nea ve sipisipi anentataminki hu'za avre'za e'naze. Ama'i kresramna vu itama masavema frente'za eri otage'ma haza knare'ma eri'za e'naza ofaramine. ");
INSERT INTO kbq_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Anante Mosese'ma seli mono nompima ufreno Ra Anumzamo'enema nanekema hunaku'ma nehigeno'a, Ra Anumzamofo huhagerafi huvempage vogisimofo asunku trarema huza nehazare tare ankeromofo zanamema'a tro hunte'naza amu'nozanifinti Ra Anumzamo'a kea Mosesena humi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Anante Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Amanage hunka Aronina asmio, 7ni'a tavi'ma retro huteno, ruotgema hunefinkama tavima tagintesigeno'a, masa'amo'a ana tavi azota'mofo avuga remsa hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ra Anumzamo'ma Mosesema asami'nea kante anteno Aroni'a tavi'ma retro hunte'nea tavira tagintegeno, masa'amo zota'mofo avuga remsa hutre'ne. ");
INSERT INTO kbq_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Tavi'ma rekruhu azotama tro'ma hu'nazana amana hu'naze, hama eri'za golia amasagiza lamu tavimofo zota'a tro nehu'za, azankuna'a tro nehu'za anina'anema troma hunazana, Ra Anumzamo'ma Mosesema asami'nea kante ante'za tro nehu'za, Livae nagara zamazeri otage hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ru'ene Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Israeli vahepintira Livae nagara zamavarenka, zamazeri agru huo. ");
INSERT INTO kbq_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Hagi zamazeri agruma kagrama hananana anahu hugahane, agru hu'nesia ti erinka ru ani'ani hunezmantesanke'za, maka zamufa zamazokara resanu nehare'za, kukena zamia sese hute'za, zamagra avusese hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ana'ma hutenagenka huge'za mago bulimakaone witi ofa zami'ne, kanenea flaua masavempi erihavia hu'nesazane ofa nehu'za, mago bulimakao kumi'ma apasezamante ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Hagi Mosesega kehuge'za mika'a Livae vahera seli mono nonte etru nehanagenka, maka Israeli vea'ene zamazeri atru hugahane. ");
INSERT INTO kbq_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Livae nagara zamavarenka Ra Anumzamo'na navure vuge'za, Israeli vahe'mo'za Livae naga'mokizmi zamagofetu zamaza anteho. ");
INSERT INTO kbq_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aroni'a Israeli vahepinti Livae nagra Ra Anumzamofo avuga aza ante'sga huno amira amira ofama nehiaza huzmantetena, Ra Anumzamo'na eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Henka'a Livae naga'mo'za tare bulimakaomofo agenopare zamazana antetesage'za, mago bulimakaona kumi'apase ofa nehu'za, mago bulimakaona kresramna vanage'na Ra Anumzamo'na Livae nagara kumizmifintira mizasezmantegahue. ");
INSERT INTO kbq_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Hagi Livae nagara huge'za Aronine, ne'mofavre naga'ane zamuga oti'nesage'za, amira amira ofama nehazaza hu'za Ra Anumzamo'na ofa hu'za namigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","E'ina hunka Israeli vahepintira Livae nagara zamazeri otage hananke'za Nagri vahera manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Hagi anama huzmantetesunka, Livae naga'mo'za seli mono nompina eri'zana erigahazanki, zamazeri agru nehunka, kazana antesga hunka amira amira ofa huzmantegahane. ");
INSERT INTO kbq_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israeli vahepinti'ma pusa ne' mofavrema antesazama onamisaza nona hu'na, Livae nagara maka Nagrani'a zamavare'noe. ");
INSERT INTO kbq_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Hagi Isipi vahe'mokizmi zamagonesa ne'mofavrema nezmahe'na, mika'a Israeli vahe'mokizmi zamagonesa mofavrene, zagagafa zimimofo ese anentara Nagri suzane hu'na zamavare otage hu'noe. ");
INSERT INTO kbq_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Hu'neanagi menina Israeli vahe'mokizmi pusa ne'mofavre nona hu'na, Livae nagara Nagra huhampri'na zamavare'noe. ");
INSERT INTO kbq_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Israeli vahepintira, Livae nagara muse'zane hu'na Aronine, ne'mofavre naga'a seli mono nompi Israeli vahe'mokizmi kumi' apaseza miza sezmante'saza eri'za eneri'za, seli mono nomofo tvaonte'ma Israeli vahe'mo'zama ne-esageno krimo zamazeri haviza huzanku kva krigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mosese'ene, Aroni'ene mika Israeli vahe krerfamo'zanena Ra Anumzamo'ma Mosese asmi'nea kante ante'za Livae nagara anara huzmantegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Livae naga'mo'za zamagrazmi zamazeri agru nehu'za, kukena zmia sese hutazageno, Aroni aza ante sga huno Ra Anumzamofonte zamavareno amira amira hu ofa hunezmanteno, kumi apase ofa huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ana'ma hutege'za Livae vahe'mo'za seli mono nompina, Aronine, ne'mofavre naga'anena zamaza hu'za Ra Anumzamo'ma Mosesema asami'nea kante ante'za eri'zana eri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Livae naga'mo'za amanahu hugahaze, 25'a kafureti mareri'nesnamo'za, mareri'za seli mono nompina eri'zana erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Hianagi 50'a kafuma nehanu'za eri'zampintira vagare'za mago'ene eri'zana e'origahaze. ");
INSERT INTO kbq_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hu'neanagi eri'zazamifinti vagaresu'za nezmafuna amne zamaza hu'za seli mono nompi eri'zana kankamu zamire erigahaze. Hagi mago eri'zana zamagra zamavesitera e'origahaze. Hagi Livae vahe'mo'za amage ante'za eri'za kankamu zamire erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israeli vahe'mo'za Isipi mopa atre'za Sainai ka'ma hagage kokampima emani'naza kafua tare agateregeno ese ikantera, Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Menina Israeli vahe'mo'za Isipi mani'nageno knazamo zamagatere'nea knagu'ma antahimi'za ne'za (Pasova) nesaza knama ante knarera, mani fru hu'neza ne'zana neho. ");
INSERT INTO kbq_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Hagi ese ikamofona 14ni zagegna zupa, hinki'za kinaga eri agafa hu'za Isipi mani'nageno knazamo zamagtere'nea knagu antahimi ne'zana (Pasova) retro nehu'za, muse hu'zamofo tra kema ante'noa kasege'mofo amage antegahaze. Maka zupa ana knama ne-ena ana knagu antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Higeno Mosese'a Israeli vahera zamasmige'za Isipi mani'nageno knazamo zamagatere'nea knagu antahimi ne'zana (Pasova) retro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Sainai hagage ka'ma mopafi, pusa ikamofona 14tini zagegna zupa hanima hu'za nehigeno, Isipi mani'nageno knazamo zamagatere'nea knagu antahimiza nezama nenaza knazupa (Pasova) agafa hu'za musena hu'naze. Ra Anumzamo Mosesema maka kasegema asmi'nea kante ante'za Israeli vahe'mo'za anara hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Hu'neanagi mago'a vahe'mo'za avu sese osu'nagu Isipi mani'nageno knazamo zamagatere'nea knagu antahimi'za nezama nenaza knazupa (pasova) ohanati'naze. Na'ankure fri vahe avufare avako hu'nazagu, ana zagegna zupage Mosesene Aronikiznire vu'za amanage ome hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Hagi tagra fri'nea vahe'mofo avufare avako hu'neta avusese osu'nonanagi, na'anku Ra Anumzamofonte ofa huntegahaze hu'za Israeli vaheku'ma hu'naza knare'ma neonana kasea hunerantaze? ");
INSERT INTO kbq_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Hazageno Mosese'a amanage huno zamasmi'ne, navega mani'nenke'na Ra Anumzamo'a na'ane huno tamagrikura hugahifi seli mono nompina vu'na ome antahiteno. ");
INSERT INTO kbq_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Hagi Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Israeli vahera amanage hunka zamasamio, tamagro, nagatamifinti forehu anante anante hana'mo'za fri vahe'mofo avufare avakoma hanu'za agru osuge, mago kaziga afete kama vugema hu'nesu'za, Isipi mani'nageno knazamo zamagatere'nea knagu antahimiza ne'za nenaza knarera (Pasova) amne negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Hagi nampa 2 ikamofona 14tini zage knarera kinagama haninki'za nehanige'za, zamagra erigafa hu'za Isipi mani'nageno knazamo zamagatere'nea knagu antahimi (Pasova) ne'zana retro hugahaze. Hagi zamagra nezama nesazana zo'ore bretine, akake ani'naza negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Hagi zamagra ana ne'zana nege'za atrenkeno ru nanterana omanege, lama afumofo zaferina'a ruha'ontagiho. Hagi maka kasegema tamasmua ke avaririho. ");
INSERT INTO kbq_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Hianagi mago'mo agru huno mani'neno, afete nantu kama onte kumate mani'neno, Isipi mani'nageno knazamo zamagatere'nea knagu antahimiza neza nenaza (Pasova) knagu agesa ontahisimofona, huntenkeno naga'afintira mani otage huno manino. Na'ankure agra Ra Anumzamofona ana knarera ofa huonte'neankino, kumi'amofo knazana agra'a erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Hagi ru mopareti emani'naza vahe'mo'za Isipi mani'nageno knazamo zamagatere'nea knagu antahimiza ne'za nenaza knare (Pasova) Ra Anumzamofo muse hunte'nakura magoke kasegene tra kere emani' vahe'ene, mopa agafa vahe'mo'zanena avaririgahaze. Hampomo seli nona refite'ne. ");
INSERT INTO kbq_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Seli noma azeri oti'za zupage hampomo ana seli nona refitegeno, zagema ufregeno'a ana hampomo'a teve anefa kna huno remsa kenagera hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ana zanke huno mika zupa hampomo zagefina refitegeno, hanimpina teve anefa huno remsa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Hagi ana hampomo'ma ruotge seli nomofo agofetuti atre'noma vige'za, Israeli vahe'mo'za hage'za rurega nevu'za, ete mago kaziga ana hampomo'ma umanige'za, anante Israeli vahe'mo'za seli nona ome ki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Hagi Ra Anumzamo'ma zamasamia kante ante'za Israeli vahe'mo'za kana nevu'za, Ra Anumzamo'ma zamasamia kante ante'za seli nonku'ma zamia ome ki'za mani'naze. Hampomo ruotge seli nomofo agofetu umanire, anante seli nona ome ki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ana zanke'ma huno hampomo ruotge seli nomofo agofetu hakare gna mege'za, Israeli vahe'mo'za Ra Anumzamo'ma kema hanigu avega ante'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Hagi mago'a knafina hampomo ruotge seli nomofo agofetu mege'za, Ra Anumzamo'ma zamasami'nea kante ante'za avega ante'za ana nonte mani'nazageno, hampomo'ma vige'za ete Ra Anumzamo'ma zamasami'nea kante ante'za hage'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Hagi mago'a knarera hampomo'a kinagareti meno vuno nanterama uhanatisigeno, hampomo'ma vanige'za zamagra hage'za vugahaze. Hagi masarero hanimpino, ina knarema hampomo'ma vanige'za, zamagra ana hampo avriri'za hage'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tare zageo, mago ikano, mago kafuo hampomo ruotge seli nomofo agofetu'ma mege'za, Israeli vahe'mo'za seli no kumazmifintira hage'za ovu'za mani'naze. Hianagi hampomo'ma ana kuma'ma atreno'ma vige'za hage'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Hagi Ra Anumzamo'ma zamasamia kante ante'za seli nona ki'za mani'naze. Ra Anumzamo zamasamia kante ante'za hage'za vu'naze. Hagi Ra Anumzamo'ma Mosesema asami'nea kante ante'za amage ante'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Hagi Ra Anumzamo'a mago'ene amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Tare ufena tamagra hamanteti amasagitma silvare tro huteta, uferenkeno vea kevu'moza nentahiza eritru hu'za seli nozmia taganaviza vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Hagi tarega ufentetima resageta, maka vea kevu'moza kagrite e'za seli nomofo kahante eme atru hiho. ");
INSERT INTO kbq_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Magoke ufentetima resageta, Israeli kva vahe'ma, nagate nagate zamazeri oti'naza kva naga'mo'za kagri kavuga etru hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Magoke ufenkrafa hina, zage hanati kaziga ki'nesaza naga'mo'za hage'za oti'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Anante ufema tare zupa rena, henkamu (saut) kaziga ki'naza vahe'mo'za hage'za oti'za vugahaze. Hagi ufema re'zamo zamazeri otina hage'za vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Vahe'ma zamazeri atruma hunakura, kema fore hanige'za ufema resaza agerumo'a zazate ufena re'za viho. ");
INSERT INTO kbq_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aroni ne'mofavrema pristi eri'zama e'neriza naga'mo'za ufentera zamagrake'za azerine'za, ana ufena regahaze. Hagi maka knafina zamagripintima fore hu anante antante'ma hu'za vanaza vahe'mo'zage ana hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Henkama mopatamirema umani'nesageno ha' vahe'mo'za ha'ma huramante'za tamazeri havizama hanageta, hazenkemofo ufe renage'na, Ra Anumzana tamagri Anumzamo'na nentahi'na, ha' vahe zamazampinti tamagu vazigahue. ");
INSERT INTO kbq_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hagi muse nehuta, mago'a ranknama ante zupo, mika ikamofo ese zagegna zupama kresramna vu ofa nehanuto, rimpa fruhu ofa kresramna vanaza zupa, Anumzamo'narega ana ufe resage'na nentahi'na tamaza hugahue. Nagra Rana, tamagri Anumzane. Hagi Israeli vahe'mo'za Sainai agona atre'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Hagi tare kafuma evigeno, tu ikamofona, 20ti knazupa, seli mono nomofo agofetu'ma me'nea hampomo'a atreno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ana hige'za Israeli vahe'mo'za nege'za ka'ma hagage mopa Sainai atre'za hage'za nevu'za, kumara ante'za manite manite hu'za nevazageno, ka'ma hagage mopare Parani ana hampomo'a umani'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ra Anumzamo'ma Mosesesema pusante'ma asmi'nea kante ante'za atre'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Hagi Juda naga'moza sondia vahe'zmine kota hu'za krauefa (fleg) zami'ne eri'za nevazageno, Aminadabu nemofo Nasoni kva huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Hagi Zuari nemofo Natanieli Isaka sondia nagatera kva huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Hagi Helon nemofo Eliabu, Zebulun naga'mokizmi sondia nagatera kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Anante seli nona tapage hu mopafi atrageno, Gersoni naga'ene, Merari naga'mo'za ana seli nona kofi'za zamage'a vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ana zamage'a Rubeni naga'moza krauefa eri'za sondia vahe'zmine nevazageno, Sedeuri nemofo Elizur ana sondia vahera kva huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Hagi Zurisadai nemofo Selumieli, Simeon sondia nagatera kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gati naga'mokizmi sondia nagatera, Deueli nemofo Eleasafu kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Anante Kohati naga'ma nevu'za, seli nompinti ruotge hu'nea zana eri'za kantega nevzage'za, seli nona azeri oti'tage'za, anapinka ruotge zantamina eri'za ome ante'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Hagi ana amagera Efraemi sondia naga'mo'za krauefa (fleg) zamine eri'za nevazageno, Amihud nemofo Elisama kegava huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Hagi Pedasur nemofo Gamalieli, Manase naga'mokizmi sondia nagatera kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Hagi Benzameni sondia nagatera Gideoni nemofo Abidani kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Henka zamefiga'a Dani naga'moza vugote'za, zamagra krauefa (fleg) eri'za henka nevu'za, ha' vahe'ma zamefiti esagu kegava huzmante'za vu'naze. Hagi sondia naga'zamirera Amisadai nemofo Ahieza kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Hagi Okran nemofo Pagieli, Aseli naga'mokizmi sondia nagatera kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Hagi Enan nemofo Ahira, Naftali naga'mokizmi sondia nagatera kva hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mika zupa Israeli vahe'mo'za noma hage'za kasefa kumate'ma nevu'za, ana kante ante'za sondia vahe'zmine vutere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mosese'a anage huno Midieni ne' Reueli nemofo Hobabuna asami'ne, Ra Anumzamo'a Nagra ana mopa tamigahue huno huhampri tante'nea mopare nevunanki, tagrane egeta so'e tavutava huganteta vamaneno. Na'ankure Ra Anumzamo'a Israeli vahe'mofona knare'za huhampri zamante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hianagi Hobabu'a amanage hu'ne, nagra ovugahuanki, areti rukrahe hu'na mopani'aregane, naga ni'arega vugahue. ");
INSERT INTO kbq_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Higeno mago'ene Mosese'a amanage hu'ne, muse hugantoanki (plis) tatrenka ovugahane. Na'ankure kagra ka'ma hagage mopafima nonkuma ante'zana antahinkakenka hu'nanku, tagrane nevunka kana taverigahane. ");
INSERT INTO kbq_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Hagi kagrama tagrane esnanketa, Ra Anumzamo'ma knare'zama tamisigeta, anazanke huta kagrira mago'a zana kamigahune. ");
INSERT INTO kbq_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Hagi anantetira Israeli vahe'mo'za erigafa hu'za Ra Anumzamofo agona Sainai atre'za tagufa zage gnamofo agu'afi kana vu'naze. Ra Anumzamofo huhagerafi huvempage vogisia kofi'za tagufa zagegnafi vugote'za nevzageno, kuma'ma ome ante'za manisare zameri hutere huno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Seli nonkumazmima atre'za nevzageno'a, Ra Anumzamofo hampomo'a zagegnafina turuna huzmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Hagi huhagerafi huvempage vogisima kofi'za vunaku nehzageno'a, Mosese'a anage hu'ne, Ra Anumzamoka otinka ha' vahetia zamahe panini huge'za nefresage'za, kagrima ha'ma renegantaza vahe'mo'za koro freho. ");
INSERT INTO kbq_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Hagi huhagerafi huvempage vogisima inaregoma umanigeno'a, Mosese'a anage hutere hu'ne. Ohampriga'a Israeli vahe'motarera ete eno. ");
INSERT INTO kbq_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Hagi Israeli vahe'mo'za knazama eneriza zanku zamesra hige'za Ra Anumzamofo agesafi kehakare hazageno, Ra Anumzamofona tusi asi vazigeno mago'a atuparega meno evu'nea kumara teve tagintegeno teme vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ana'ma hige'za vea'moza nege'za, Mosesente taza huo hu'za zavi krafa eme hazageno, Mosese'a Ra Anumzamofontega nunamu higeno, ana tevemo'a asu hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Hagi ana kuma'mofo agi'a Taberae hu'za agia ante'naze. Na'ankure zamagrama ke hakarema hazageno Ra Anumzamofo tevemo zamagri amu'nompi teve re'negu anage agia ante'naze. ");
INSERT INTO kbq_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mago'a ru vahe'ma Israeli vahe'enema emeri havia hu'za vu'naza vahe'mo'za masave ne'za nenaza vaheki'za, ne'zama nesagu nehage'za, Israeli vahe'mo'zanena zamagranena ke hakare hu'za, tananke zana iza tamisnigeta negahune? ");
INSERT INTO kbq_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tagra Isipi mani'neta nozama, konoma, merenima, aka osu ani'ani'ma (leek), ani'ani'ma, galikima miza oseta amne nenona zankura tagesa nentahune. ");
INSERT INTO kbq_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Hianagi menina hanavetia omanegeno, ne'zantia omnegeno, manage me'ne! ");
INSERT INTO kbq_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manamo'a, ampori'e ragagna huno kani kruke hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Hagi ana mana nantera oti'za eka eka kupi zogi ante'za, mago have tra ante'neza mago havenu atufe'za vu'za eza nehazageno refuzafupeno ta'nefa sege, magru riga onaginefi rentra hazageno tanefa asege'za kavofi krete'za, kuta keki tro hu'naze. Haga'amo'a olivi masavempi kre'naza kekimofo haga gna hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Kenage'ma seli nonkumapima atako'ma eneramigeno'a ana manamo'a magoka herafirami'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Israeli vahe'mo'za seli nozamimofo kahante mani'ne'za maka'mo'za zavi netageno, Ra Anumzamofo rimpa ahe'zamo otigeno, Mosese'a ana zama negeno musena huozmante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Anante Mosese'a amanage huno Ra Anumzamofona asmi'ne, Na'ante Ra Anumzamoka kagri eri'za vahekamo'na ama zana erifore hune nami'ne? Nagrira musena huonantenka, maka vahe'mokizmi knazana nagrira eri kofi nenantano? ");
INSERT INTO kbq_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nagrake ama ana vahera kase zamante'nofi? Nagra nezmafana mani'nofi? Kagra nagrikura hunka, kasumpinka zamanukinka, a'nemo'za mofavre zamasunte zamanu'nekiza kna hunka, zamavarenka zamafahe'i huhampri zamante'nana moparera vuo hankena neo? ");
INSERT INTO kbq_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Zamananke zana inantegati ama ana maka veara eri fore hu'na zamigahue? Zamagra navufi zavi ate'za anage nehaze, tananke zana tamigeta namneno hu'za nehaze! ");
INSERT INTO kbq_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ama ana eri'zamo'a tusi'a kna navenesiankina, mika'a veara nagrakera, inankna hu'na kva huzmantegahue? ");
INSERT INTO kbq_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Amanahu hunka nagri'ma nazeri haviza hunaku'ma hanunka, muse hugantoanki Kagri kvufima knare'ma hu'nesugenka, ame' hunka nahe nefrinka, atregeno ama knazamo'a nazeri haviza osino. ");
INSERT INTO kbq_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Hagi Ra Anumzamo'a ana kema nentahino amanage huno Mosesena asmi'ne, Israeli vahe'ma kva eri'zama enerisaza vahepintira 70'a vahe zamavarenka kagrane seli nomofo avuga eme otiho. ");
INSERT INTO kbq_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Hagi anante Nagra eramina kagra'ene keaga eme nehu'na, kagripintira mago'a Avamura eri zami suge'za, kaza hu'za veamokizmi knazana mago'a erisagenka, mago'ene maka knazana kagrakera e'origahane. ");
INSERT INTO kbq_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Veara zamasamige'za, okina zamananke'zana (mit) negahazanki, zamazeri agru hu'za zamavufaga eri otage hiho. Na'ankure zavi krafagema hazana Ra Anumzamo'na antahi'noe. Iza magora tananke zana tamisigeta negahune! Isipi mani'nonana knare'zantfa huta mani'nonane hutama hazankea, Ra Anumzamo'na antahinoankina tmananke'zana taminugeta negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ne'zama tamagrama nesazana, magoke zagefino, tare zagefino, 5fu'a zagefino 10ni'a zagefino, 20'a zagefino, ");
INSERT INTO kbq_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mago ikampina tamagra nenesageno, tamagona kampinti katati huno tamagoteno tamavresra hugahie. Na'ankure tamagrane nemanua Ra Anumzamo'na tamage'na hunamita zavi neteta anage hu'naze, Nahigeta Isipi'a atreta e'nesunane? huta hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Hianagi Mosese'a ana kemofo nona'a amanage hu'ne, 600,000ni'a sondia vahe'ene menina nagra mani'nogenka, Kagra anage hane, Nagra zamananke'za zamisanuge'za mago ikamofo agu'afina negahaze nehane. ");
INSERT INTO kbq_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Sipisipi kevune, bulimakao kevu aheta tragafeta zamisuna zamo'a, maka vahe'mokizmi agu hezmantegahifi? Hifi maka hagerimpinti nozame azeri atru huta zamisunazamo, agua ahezmantegahio? ");
INSERT INTO kbq_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ra Anumzamo'a amanage huno Mosesena ke nona'a asmi'ne, Ra Anumzamo'na hanavemo'a atupa hu'nefi? Nagri kemo'a tamage huno nena raga'a efore hugamigahio, huogamigahio menina kagra kegahane. ");
INSERT INTO kbq_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mosese'a vuno Ra Anumzamo'ma asmi'nea naneke'a ana maka veara ome nezamasamino, 70'a kva vahe huhampri zamante'nea zamavareno seli nonte ome zamante kagi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Hagi Ra Anumzamo'a hampompi eramino keaga hunezamino, mago'a Mosesempi mani'nea Avamura erino ana 70'a kva vahete ante'ne. Higeno ana Avamuma zamagrite emanige'za zamagra kasnampa kea osi'a knafi hu'naze. Hianagi ete anama hute'za mago'enena ana kasnampa kea osu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ana hianagi tare kva netrena seli mono nompina mareorina'e, mago'mofo agi'a Eldati'e, hagi mago'mofo agi'a Medati'e. Zanagra kumapi mani'nakeno, Ra Anumzamofo Avamumo zanagrite emanige'ne, ana zanke hu'ne kasnampa keaga ana kumapina hu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ana nehakeno mago nehazave ne'kanomo agareno vuno Mosesena anage huno ome asami'ne, Eldatike Medatikea kasnampa keagaga kumapina neha'e. ");
INSERT INTO kbq_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nun ne'mofavremo Josua, nehazama'are Mosesena aza nehia ne'mo huno, Mosesega ranimokagi zanatregeke ana keaga osi'o. ");
INSERT INTO kbq_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Hianagi Mosese'a ke nona amanage hu'ne, kagra nagritega antenka kasnampa kea osi'o nehampi? Ra Anumzamofonte maka kasnampa vahera tro hanazegu nagesa nentahuankino, Ra Anumzamo'a Avamura Agra'a zamigahie! ");
INSERT INTO kbq_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ana'ma hute'za ete Mosese'ene Israeli kva vahe'mo'zanena kumapi vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Mago zupa Ra Anumzamo'a hankavenentake zaho huntegeno hagerintegati mika'a hifa' nama zaga renatigeno hareno Israeli vahe'ma kuma kiza mani'nazarega emani avite'ne. Mago zage gna anagamu (not) kazigane, henkamu (saut) kazigane vuga'are kumamofona agofetu emani emani higeno, ana hifa' namamo mopa aviteno mreri'neana tare kiubits (1 mita gna hu'nea avamente emani'naze). ");
INSERT INTO kbq_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Hagi veamo'za mago zagegi, mago kenageki, anante zagegi hu'za ana hifa nama zogi'naze. (Iza'o osi'ama zogitere hu'nemo'a 1tauseni'a kilo mago mago'mo'a zogitere hu'ne) ana hifa' nama zogite'za kumamofo refarega zagere ante hagege hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Hagi ana namama agafama hu'za ani'za nakriku nehazegeno, Ra Anumzamofo rimpa he'zamo'a mrerigeno, tusi kri vahe'mokizmi zamavate atregeno eme zamazeri haviza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Hagi memema ase'za zamagraguke'ma antahi'naza vahera zamahe hana hige'za fri'naze. Ana vahera anampi asene zamante'za ana kuma agi'a Kibrot-hatava hu'naze, (meme vahe asente kumare hu'za agi'a ante'naze). ");
INSERT INTO kbq_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibrot-hatavatira Israeli vahe'mo'za atre'za Hazeroti vu'za, anantega Hazeroti mopare zaza kna umani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mosese'ma Kusa (Itiopia) kumate a'ma eri'nea zanku huke Miriamuke, Aronikea kehakare hunteke, ");
INSERT INTO kbq_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","zanagra anage hu'na'e, Ra Anumzamo'a Mosesenke kegaga hunemifi? Anazankera huno tagri'enena Agra kea huoramigahio? Anage nehakeno Ra Anumzamo antahi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mosese'a menina avufga antermino agazone huno mani nera mago'a nagara zamagatereno agrake mani'ne. Magore huno agri kna vahera ama mopafina omani'ne. ");
INSERT INTO kbq_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ana'ma hakeno'a ame huno Ra Anumzamo'a Mosesene, Aronine, Miriamunku'enena anage hu'ne, ana maka 3'a nagamota atiramita seli mono nomofo avuga eho. Hige'za ana 3'a naga'mo'za eme atru hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Hagi anante Ra Anumzamo'a vimago hampompi eramino seli mono nomofo kasante eme otineno, Aronine, Miriamu kiznigu ke higeke tarega'moke avuga akeno, ");
INSERT INTO kbq_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","anante Ra Anumzamo'a amanage huno zanasmi'ne, Menina Nagri nanekea antahi'o. Tamagri amu'nompi mago kasnampa vahe'ma mani'negena Nagra Ra Anumzamo'na ava'nafi efore hunemina, avanagna zampi efore hu'na kea hunemue. ");
INSERT INTO kbq_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Hagi Nagri eri'za vahe Mosesena anara huontegahue. Nagra antahi nemina hakare eri'za zantera knare huno kva hugahie hu'na Ra Anumzamo'na antahinemue. ");
INSERT INTO kbq_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nagra fronka kea agri'enena osu'na, amate tagipinti kea ohumi ahumi nehu'e. Tanagra nahigeta korora nosuta, Nagri eri'za ne' Mosesena amefiga'a kea nehuta, hu havizana hunenta'e? ");
INSERT INTO kbq_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ra Anumzamo'a tusi rimpa nehegeno zamatreno Agra vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ana'ma higeno'a seli mono nomofo agofetuti hampomo atreno vigeno, keana fugo namu Miriamuna re'geno efeke hu'ne. Aroni'a rukrahe huno'ma keana, Miriamuna fugo namure'negeno ke'ne. ");
INSERT INTO kbq_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Anante Aroni amanage huno Mosesena asmi'ne, ranimoke tusiza hu'na nasunku hue, ama'na kumitera tagrira tazeri haviza osuo, negi vahe kna huta hago kumi hu'no'e. ");
INSERT INTO kbq_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Hagi Miriamu avufga atregeno haviza huno, kase nefria mofavremofo avufgamo knopeneramia knara osino. ");
INSERT INTO kbq_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Anante Mosese'a zavi neteno ranke huno nunamuna Ra Anumzamofontega huno, muse hugantoanki Miriamuna kri'a eri atrento. ");
INSERT INTO kbq_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Hianagi Ra Anumzamo'a Mosesena anage huno ke nona'a hunte'ne, Nefa'ma avufima avetu ahentesigeno'a, 7ni'a zage gnafina agaze zana e'orisio? Atrenkeno 7ni'a zage gna kumamofo fegi'a umani'nena, ana kna vagarena ete avreta kumapina efreho. ");
INSERT INTO kbq_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriamuna kumamofo fegu'a 7ni'a zagegna atrazageno mani'nege'za, hage'za ovuza mani'nageno Miriamu'a ege'za ete avre'naze. ");
INSERT INTO kbq_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Henka'a, anazama vagarege'za, Israeli vahe'mo'za Hazeroti'a atre'za ka'ma hagage mopafi Parani hage'za kumara ome ki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Anante Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Nagrama Israeli vahe'ma zamiku'ma hu'noa mopa, 12fu'a naga nofipinti magoke magoke kva vahezmi huzmantege'za oku'a vu'za Kenani mopa ome afure'za keho. ");
INSERT INTO kbq_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Higeno Parani ka'ma hagege mopafi mani'nafintira Mosese'a Ra Anumzamofo ke amage anteno, Israeli vahepintira kva vahezmi huzmantege'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Anama vu'namokizmi zamagi'a ama'ne, Rubeni nagapintira, Zakuri nemofo Samua'e. ");
INSERT INTO kbq_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon nagapintira, Hori nemofo Safati'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Juda nagapintira, Jefune nemofo Kalepi'e. ");
INSERT INTO kbq_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isaka nagapintira, Josefe nemofo Iga'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efraemi nagapintira, Nuni nemofo Hosea'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamen nagapintira, Rafu nemofo Palti'e. ");
INSERT INTO kbq_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebuluni nagapinti, Sodi nemofo Gatieli'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Josefe ne'mofavre Manase nagapintira, Susi nemofo Gati'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dani nagapintira, Gemali nemofo Amieli'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aser nagapintira, Maikol nemofo Seturi'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nafatali nagapintira, Vofsi nemofo Nabi'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad nagapintira, Masi nemofo Geueli'e, ");
INSERT INTO kbq_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ama'i oku'a vu'za mopa afure'za kehogu huzmantege'za vu'naza vene'ne zamagi'e. Hianagi Nun nemofo Hoseanku, Mosese'a Josua'e huno agi'a antemi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mosese'a Kenani mopa vu'za ome afure'za kehogu, agra anage huno huzmante'ne, Anagamu Negev mareriteta, anantetira agona moparega mareriho. ");
INSERT INTO kbq_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mopamo'a inankna hu'nefi ome negeta, ana mopafima nemaniza vahera hanave vahepi hanavezamia omne'ne vahepi, osi'a mani'nafi, rama'a vahe mani'nafi ome keho. ");
INSERT INTO kbq_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Inankna hu'nea mopafi nemanizo, ana mopamo'a knare hu'nefi, haviza hu'nefi? Ranra kuma'zamimo'a inankna hu'ne, ruherafi'za kumara ante'za mani'nafi, hanave vihu kegina hu'nazafi keho? ");
INSERT INTO kbq_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mopamo'a inankna hu'ne, masvema'ane mopafi hagege hu'ne? Anampina zafa me'nefi omane'ne? Ete eku'ma hanuta mago'a zafa raga eri'neta eho. Ana'ma huzmante'neana krepimo ese agafa huno afure'nea knafi huzmantege'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Zini ka'ma hagege kokampi mareri'za ana mopa oku'a afu omere'za nege'za, Rehob vu'za Lebo-hamati kaziga uhanati'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Hagi Negevi mareri'za uhanatite'za, Anaki agehe'za Ahimanima, Sesai'ma, Talmai'zama hu'za, Hebroni mani'nazare vu'naze. (Hebroni kuma erifore hu'naza kna 7ni'a kafu agateretege'za, Zoan kumara Isipi'a erifore hu'naze). ");
INSERT INTO kbq_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Anantetira Eskol agupofi uhanati'za, anampinti krepimo mago azankunate manumanu huno te'nea akafri'za, zafare taremoke zafa hutere nehu'za, mago'a pomigrenet ragane, fiki ragane eri'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ana kokankura Eskol agupoe hu'za hu'naze. Na'ankure mago'pima (manu manuma huno zafa rgama re'nege'za Israeli vahe'mo'za akafri'za) eri'za e'nagu hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Hagi 40'a zage gnamofo agu'afi mopa oku'a vano hu'za afure'za kete'za e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mosesene, Aronine, maka'a Israeli vahe kevune Paran ka'ma hagege mopafi, Kades mani'nage'za, Kenani mopafima me'nege'za kete'za aza zamofo nanekea eme nezmasmi'za, ana mopafinti zafa ragama eri'za e'nazana eme zamaveri nehu'za, ");
INSERT INTO kbq_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","amanage hu'za Mosesena asmi'naze, Hurantanketa vu'nona mopafina, tamage huno ami rine, tume rinena avite'ne. Hagi anampinti'ma zafa rgama erita e'nonana ama'ne. ");
INSERT INTO kbq_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Hianagi ana mopafina hanavenentake vahe manine'za, ranra kuma'zamirera tusinasi vihu hu'naze. Hagi anampina Anaki nezmagehoza mani'nageta zamage'none. ");
INSERT INTO kbq_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ameleki vahera Negev mopafi mani'naze, Hiti vahe'ene, Jebusi vahe'ene, Amori vahe'enena agona mopafi mani'naze. Hagi Kenani vahera hageri ankenane, Jodani timofo ankenarega mani'za evu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Hagi Mosese avuga, Kalepi'a otino amanage hu'ne, Kea tagane'neta antahiho, inazano fore hania zankura ontahita, otinketa marerita ana mopa omeri maneno. Na'ankure tagra hara huzmagatereta mopa erigahune. ");
INSERT INTO kbq_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Hianagi mago'a vahe'ma agrane vu'naza vahe'mo'za amanage hu'naze, tagra ana vahera zamahega osu'none. Na'ankure hanave zamimo'a tagri hanavea agatere'ne! ");
INSERT INTO kbq_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ana mopa ome afure'za kete'za e'naza vahe'mo'za, koro nehu'za Israeli vahera havige rezmatga hu'za anage hu'naze, anama ome ke'nona mopamo'a aza'o ana mopare umani'simofona aheno nehna hugahie. Hagi ana mika vahe'ma zamage'nona vahera tusinasi vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ana mopafinke Nefilim vahera nezmageta, Anaki vahera, Nefilim vahe'mokizmi zamagehezagita, tagrama zamagonana kenu kna tagra hu'none. Hagi zamagrama taga'zana ana zanke hu'none. ");
INSERT INTO kbq_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ana maka vahe kevu'moza ana nanekema antahite'za, Israeli vahe'mo'za ana kenagera tusi zavi ate'naze. ");
INSERT INTO kbq_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israeli vahe'mo'za Mosesene, Aronikiznia keha' reznante'za maka vahe'mo'za anage huznante'naze, Tagra Isipima mani'neta frunte'sina knare hisine! Nahanigeta ama ka'ma hagege mopafina frigahune! ");
INSERT INTO kbq_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ra Anumzamo'a ama moparera kazinknonu tahe frihogu tavreno e'nefi? A'nene, mofavretinena tahe'za hanaresagi, eteta Isipima vanunkeno'a knare hugahie? ");
INSERT INTO kbq_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Zamagra zamagra ke ohumi ahumi hu'za anage hu'naze, tagra'a tavesite mago kva ne' azeri otisunkeno, ete tavreno Isipi mopare vanie! ");
INSERT INTO kbq_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Anante Mosese'ene Aronikea maka Israeli vahe'mokizmi zamufi zanavugosaregati mopafi mase'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ana hakeno Nun nemofo Josua'ene, Jefune nemofo Kalepike, zanagra ana mopa vu'ne ome ke'na'a netre'moke, kukenaznia vararo varuru nehu'ne, ");
INSERT INTO kbq_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","amanage hu'ne maka Israeli vahe kevua zamasmi'na'e, Ana mopama ome ke'nona mopamo'a knare zantfa hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ra Anumzamo'ma muse (plis) hurantesuno'a, henka tagrira ana mopare tavreno vuno, ami rine tumemofo rimo'ene avite'nea mopa ome tamigahie. ");
INSERT INTO kbq_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ra Anumzamofo kea magore huta ru ha'ontagiho. Ana mopafima nemaniza vaheku'enena korera osiho, zamagra tagri nezasegahaze. Zamagri'ma refiteno kegava krizmante'nea zana eri atregahie. Hagi Ra Anumzamo'a tagrane mani'neanki zamagrikura korera osiho, ");
INSERT INTO kbq_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Hianagi ana maka vahe'mo'za have kano eri'za zanahe fri'za nehazageno, anante Ra Anumzamofo msazamo seli mono nonte eramino Israeli vahe zamavuga efore hige'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Hagi Ra Anumzamo'a amanage huno Mosesena asmi'ne. Nama'a zupa ama vahe'mo'za Nagrira zamagena hunenami'za, zamesi nonantaze? Nenagage'na maka kaguvaza amu'no zamifi eri fore hu'noa zankura, Nagrikura zamentintia nosazo? ");
INSERT INTO kbq_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nagra kri atrena zamahe fanane nehu'na, Mosesega naga ka'afinti kazeri ra ha'nena zamagatere'za hanave'nentake vahe fore hu'za, Israeli vahera zamagatere'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Hu'neanagi Mosese'a ana kemofo nona'a Ra Anumzamofona amanage huno asmi'ne, ana kea Isipi vahe'mo'za antahigahaze, na'ankure Kagra hanavefi ama vahera, Isipi vahe amu'no zamifinti zamarenka e'nane. ");
INSERT INTO kbq_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Isipi Kenani mopafima nemaniza vahera zamasamigahaze. Kagrama Ra Anumzamoka ama vahe amuno zamifima nemaninana, zamagra hago antahi'naze. Kagra Ra Anumzamoka zamufinti negagazagenka Kagra hamponu refite nezmantenka, Kagra Israeli vahe'mokizmi vugotezmantenka vimago hampompi nevunka, zagefina refite nezmantenka, hanimpina ana vimago hampompintira teve anefa hunka remsa huzmantenka nevane. ");
INSERT INTO kbq_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Menima Kagrama, magoke vahe aheaza hunkama ama vahe'zaga zamahe sanke'za, maka ama mopama megaginefinti Kagri kagenkema nentahi'za vahe'mo'za amanage hugahaze, ");
INSERT INTO kbq_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Ra Anumzamo huhampri zamanteno huvempa huzmante'nea mopare zamavareno vugara osuno, ka'ma mopafi zamahe fanane hie hu'za hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Hianagi menina, nagra nunamu hue, Kagrama hunana kere, Ra Anumzamoka atregeno hihamu hanavekamo'a eama hino. ");
INSERT INTO kbq_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Ra Anumzamofo rimpa ahe'zamo'a ame huno oranotigeno, rimpa fru huno avesinte zamo'a mareri avitegeno, kumi'ene kefozantine eri atre'nerante. Hianagi aza'o kasege'ama agatere'simofona, kumi'mofo nona'a nezmafanteti vuno, nemofonte vuteno henkama fore'ma hu anante anantema huno 3'o 4'a vahe'enema fore hu anante anante'ma hanaza vahete ana havizamo'a meno vugahie. ");
INSERT INTO kbq_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kagra vagaore kavesizanka'agu nentahinka nunamu huanki kumi'zmi ama vahera atrezmanto. Ama vahe'ma Isipima mani'nagenka Kagrama kumizamima eri atrenka menima e'nana kna hunka eri atre zamanto. ");
INSERT INTO kbq_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Anage higeno Ra Anumzamo'a amanage huno Mosesena asmi'ne, Nagra kema nasmi'naza hu'na kumi'zmia eri atre zamantegahue. ");
INSERT INTO kbq_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Hianagi tamage hu'na Nagra kasefa hu'na mani'noa Anumzamo'na huankino, Ra Anumzamo'na hihamune, msazamo e'nena maka mopafi vuno eno huno avitegahie. ");
INSERT INTO kbq_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Tamage hu'za maka vahe'mo'za Nagri masane kaguvazana Isipine, ka'ma hagege mopafine eri fore huge'za nege'zagi, anazankura ontahi'za 10ni'a zupa Nagrira renahe'za nege'za, Nagri kemofona amagera onte'naze. ");
INSERT INTO kbq_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ana hu'nazagu tamage hu'za nezmafama huvempa hu'na Nagrani'a zami'noa mopa, namefiga'a ke nehazamo'za onke'tfa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Hianagi Nagri eri'za ne' Kalepi'a kegahie. Na'ankure agripina ruzahu avamu me'negeno maka agu'areti huno Nagrira maka zampina namage ante'negu ana mopare Nagra avre'na vanugeno, ana mopa agehe'za eri nafa'a hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Menia Ameleki vahe'ene Kenani vahe'mo'za ana aguporamimpina mani'nazagu, okina rukre hunka ka'ma hagage mopafi ru kitaginka Koranke Hageri me'nerega vuo. ");
INSERT INTO kbq_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ra Anumzamo'a anage huno Mosesene, Aronikizni znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Nama'a zupa ama'i kumike vea kevumo'za, Nagri'ma huhaviza hunenantaza vahe'mokizmi knazana erigahue? Israeli vahe'mo'za Nagri'ma hunenantaza kea nentahue. ");
INSERT INTO kbq_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Menina zamasmio, tamage hu'na kasefa hu'na mani'noa Ra Anumzamo'na nehue, nagesa kami'nogenka hankena antahuankina inankna zanku'ma hana zana amne hugahue. ");
INSERT INTO kbq_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kagrama hampri'nana vahe'ene, maka 20'a kafureti mareri anagate'nesia vahe'ene, Nagri'ma namefi'age hu'nesaza vahe'mo'za ka'ma hagege mopafi fregahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tamage huvempa hurmante'na tamagri tamamigahuema hu'noa mopafina ovugahaze. Hianagi Jefune nemofo Kalepi'ene Nuni nemofo Josuake, zanagrake vugaha'e. ");
INSERT INTO kbq_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Hianagi tamagrama huta, mofavreti zamahe fanane hugahaze huta koro'ma hu'naza mopare, ana mofavremokizmi Nagra zamavare'na vanuge'za, i'oma hu'naza mopa ome erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Hagi tamagra, ama ka'ma hagage mopafi frigahaze! ");
INSERT INTO kbq_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Hagi tamagrama Nagri kemofo amage onte'naza nona'a, mofavretmimo'za ama ka'ma hagage mopafi 40'a kafufina knazana eri'za vano nehu'za, anama maka'mo'za ama ka'ma hagage kokampi frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Zamagrama ana mopafi 40'a zagegnafi vano nehu'za oku'a afure'za kenazankna huta, kumi'tmimofo nona mago mago knamo'a mago mago kafu huvame hanigeta, 40'a kafufi knazana erita vano hugahaze. Nagrama hurmantesua navu'navara kegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nagra Ra Anumzamo'na kea nehue, kumike vahe'mo'za atru hu'za Nagri'ma hu haviza nehazana tamage hu'na kna zamigahue. Ama ka'ma hagage mopafi zamazeri haviza ha'nena fri hana hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mosese'ma huzmantege'za oku'a vu'za mopa ome afure'za kete'za e'naza vahe'mo'za maka vahe kevu havige eme zamasmi'naze. ");
INSERT INTO kbq_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Hagi mopa afureho huno huzmantege'za vute'za, ete eza havige eme hu'naza vahera, Ra Anumzamo'a kri atregeno zamahe fri'ne. ");
INSERT INTO kbq_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Hianagi huzamantege'za vuza mopama ome afure'za ome kete'za e'naza nagapintira, Nun nemofo Josuane, Jefune nemofo Kalepikizni znatregeke zanagrake mani'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mosese'ma ana kema Israeli vahe'ma nezmasmige'za, vahe kevumo'za tusiza hu'za zavira nete'za zamasunku hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Hianagi ame' nanterampi oti'za mika'zazimia tro hu'za agonarega mareri'za nevu'za anage hu'naze, Tagra ama one, tamage kumi' hu'nonanagi, Ra Anumzamo'ma huhampri tante'nea moparega vugahune. ");
INSERT INTO kbq_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Hagi Mosese'a amanage huno zamasmi'ne, Tamagri antahizamo'a eri'zana e'origahie. Tamagra Ra Anumzamofo ke ruha'nentagize. ");
INSERT INTO kbq_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Anantega Anumzamo'a tamagranena ovanigeno ha' vahetamimo'za tamahegahazanki tamagra mareorigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Tamagri ha' vahe'mo'za Ameleki vahe'ene Kenani vahe'mo'zatamavuga mani'nazeanki'za kazinknonteti tamahegahaze. Hagi Ra Anumzamofo ke'a tamefi hunte'naza nona'a, Ra Anumzamo'a tamagra'nena ovugahie. ");
INSERT INTO kbq_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Hianagi mago'a Israeli vahe'mo'za Mosese kea eri amne nehu'za, agonarega mareri'za vu'naze. Ra Anumzamofo huhagerafi huvempage vogisimo'a anampi me'negeno, Mosese'enena kumara atreno ovu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Hagi Ameleki vahe'ene Kenani vahe'ma ana agona mopafi nemaniza vahe'mo'za erami'za zamahe'za zamarotgo hazage'za fre'za Homa kumate ehanati'naze. ");
INSERT INTO kbq_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ra Anumzamo'a amanage huno Mosesena asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Israeli vahera zamasmige'za taminaku'ma nehua mopafima umanisu'za avaririsaza kasegea ama'ne. ");
INSERT INTO kbq_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Hagi tamagratami tamavesite kresramna vu ofa hugahazo, huvempa hunesare hu ofo, ranra knare'ma hu ofa hanazana, tamagra'a afu kevufinti bulimakaone, sipisipine, memene aheta kresramna tevefima nevazage'nama mna'ama nentahina Ra Anumzamo'na musema nehua ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Hagi mago'mo'ma sipisipio memema ofama erinoma Ra Anumzamo'narema esuno'a mago kilo hu'nesia witia 1lita olivi masavene eri havia huno herunesia witi ofama hu'zana erino egahie. ");
INSERT INTO kbq_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Hagi kresramna vu ofama hanazana, mago sipisipine 1lita wainine kresramna vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Hagi ve sipisipima kresramna vunaku'ma hanuta, 2kilo hu'nesia witine 1litagi hafu'a lita olive masavene herugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Hagi waini ofama hanuta, 1litagi hafu'a lita waininu sipisipinena ofa hanage'na mna'a nentahina musena hugahue. ");
INSERT INTO kbq_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Hagi agaho bulimakaoma aheta kre fanenema hu ofama hunakuma hanuto, huvempama hunesarema ofama hunaku'ma hanuto, rimpa fru ofama hunaku'ma hanuta, ");
INSERT INTO kbq_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","witia 3'a kilo hu'nesia herafinteta, 2'a lita hu'nesia olivi masavene herugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Hagi 2 lita waini enerita mago ve bulimakaone erita eho. Nagra Ra Anumzamo'na e'ina hu ofamofo mna'a nentahina musena hugahue. ");
INSERT INTO kbq_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","E'ina huta witima, olivi masavema, waini ofanena mago'mago ve bulimakaone, ve sipisipine, sipisipi anenta'ene meme anenta'ene ofa Nagritega hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hagi e'inahukna huta maka ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Maka Israeli vahepima kasezmantesaza vahe'mo'za kresramna vanage'na mana'ama nentahina musema hanua ofama hanuza anahukna hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Hagi tamagranema emani'naza vahe' mo'za kremna vanagena mna'ama nentahina musema hanua ofama hanuza, ana zanke' hu'za ama kasegea avaririho. ");
INSERT INTO kbq_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hagi magoke tra ke me'nena rurega vahe'ene Israeli vahe'motanena avaririgahaze. Ama'i ana tra kemo'a mevava huno vugahie. Na'ankure Nagra Ra Anumzamo'na Israeli vahe'ma tamagoana magoke avamenteke vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Hagi ama magoke tra ke me'nena rurega vahe'ma tamagranema emani'nenaza vahe'mo'za avaririgahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ra Anumzamo'a anage huno Mosesena asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ama nanekea Israeli vahera zamasamio, nagrama taminaku'ma nehua mopafima uhanatita, ");
INSERT INTO kbq_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mopafima hozama ome antesageno ne'zamo'ma nenama hina, ese ne'zana refko huta ofa eme namiho. ");
INSERT INTO kbq_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hagi witi hozama antesageno ese'ma nenama hania witia erita witima refuzafunepaza kumapi ome refuzafupeteta, kekia kreta eme namiho. ");
INSERT INTO kbq_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Hagi henkama fore hu anante anantema hu'za vanaza vahe'mo'za, ama ana tra ke avariri'za bretia kre'za ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Hagi Ra Anumzamo'nama Mosesema asami'noa tra kema mago vahe'mo'ma mago'azama hanirega hantga huno runetragenigeno, ");
INSERT INTO kbq_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","henkama fore hu anante anantema hanaza vahe'mo'za Ra Anumzamo'na Mosesesema asami'noa tra kema mago'a zama haniregama hantga huno runetragenigeno, ");
INSERT INTO kbq_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ana mikamotama mago'azama hanaregama hantga huta tra ke'nima ruhantagisuta, mago ve bulimakao afu kre fanene hu ofa nehinkena mna'a nentahina musena haneno. Hagi ana ofama hanazana witine, wainine nehuta mago ve memena aheta kumima apasente ofa kresramna vugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Hagi pristi vahe'mo ama ana ofa nehanige'na, Israeli vahe'mokizmi kumizmia apasenezmantena kumizmia atrezmantegahue. Na'ankure zamagra kumi hugahune hu'za ontahi'neza hu'naza kumite Ra Anumzamonare'ma eme hanaza ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ana hanagena mika Israeli vahe'ene ruregati tamagranema enemaniza vahe'mofo kumi'zmima apasezamantenu'a ofa hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Hagi mago'moma kumi hugahuema huno ontahineno mago'azama hanirega hantaga huno'ma hania kumitera, magoke ve meme anenta aheta kresramna vanageno, ");
INSERT INTO kbq_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","pristi ne'mo'a kumi'ma hu'nesia nemofonteku huno krenkena, kumi'a apasentegahue. ");
INSERT INTO kbq_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Hagi ama'i tra kea maka Israeli vahe'motane rurega vahe'ma tamagranema enemaniza vahemo'zanena avaririgahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Hagi Israeli vahe'mo'o, rurega vahe'ma tamagranema emani'nenaza vahe'mo'za kumi'ma hanamo'za, Anumzamofo huhaviza hunteankna hugahazanki'za, Israeli vahepintira zamahe'natregahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Na'ankure anamo'a amefi hunamino agra'a avesite tra keni'a rufutagi'ne. Ana hu'negu Sabati tra ke rufutaginea kumimo'a agrite megahianki, anamofona ahe frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israeli vahe'mo'za mago Sabati knarera ka'ma hagege kokampi mani'nazageno mago ne'mo'a teve'za nehige'za ke'naze. ");
INSERT INTO kbq_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ana nera azeri'za Mosesene Aronikiznire'ene mika Israeli vahete vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Hagi ana ne'mofona nankna hazenke amigahaze ontahinazanki'za ana nera atrageno ovu'neanki kina huntazageno man'ine. ");
INSERT INTO kbq_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hagi Ra Anumzamo'a amanage huno Mosesena asmi'ne, mika veara zamasmige'za kuma'mofona fegi'a avre'za vu'za have knonu ome ahe friho. ");
INSERT INTO kbq_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ra Anumzamo'ma Mosesema asmia kante ante'za, ana nera avare'za seli no kumofona fegia vu'za haveknonu ome ahe fri'naze. Nofima kukenarema renentaza kasege. ");
INSERT INTO kbq_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ra Anumzamo'a Mosesena amanage huno' asmi'ne, ");
INSERT INTO kbq_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Israeli vahera zamasmige'za kenazmimofo agentega nofira rente'za eviho. Hagi kukenamofo agentega haninke nofi rente'za evugahazanki anazana mika knafima henkama fore hu anante anante'ma hu'za vanaza vahe'mo'za kukenazmimofo atuparega rente'za evugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Hagi ana nofi'ma negesuta Ra Anumzamo'nama tami'noa mika kasegegu tamagesa antahita nevaririta, tamagra'a tamavesizana avaririta havi tamavutamavara osugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Hagi ana nofi'ma negesageno huramagesa nehina kasege'ni'ane naneke'ni'anena avaririta mani ruotge huta manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nagra Ra Anumzamo'nama Isipiti'ma tamavre'na e'noana, tamagri Anumza maniku tamavre'na e'noa Anumza mani'noe. ");
INSERT INTO kbq_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora'a Iza nemofokino Kohati negeho, Livae naga nofipinti neki Datani'ene Abiramukea Eliabu nemofokegi Pereti nemofo Oni Rubeni nagapinti neki hu'za eri mago hu'za antahintahia retro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Hagi ana venenemo'za 250'a Israeli kva vahe'mo'zane eri mago hu'za Mosesena hararente'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Hagi ana vahe'mo'za emeri atru hu'za Mosesene Aronikiznia keha'reznante'za anage hu'naze, Tanagrakera ugagota vahera omani'na'e. Hagi miko vahe'mo'za ruotage hu'naze. Hu'neankino Ra Anumzamo'a tagrane mani'ne. Tanagra hago havifi tavreta vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mosese'ma ananke nentahino'a avugosaregati mopafi umase'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Anantera Korane mika agri'enema emehagerafi'naza naga'mokizmia Mosese'a zamasamino, Oki nanterana Ra Anumzamo'a iza Agri nagara mani'neno, ruotagera hu'nefi tamaveri hanigeta keta antahita hugahaze. Hagi Ra Anumzamo'ma huhampri zamantesimo'za Agri tavaonte ruotage'ma hu'nefina urava'o hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Koraga, kagrane kagri kamagema nentaza vahe'enena Mananentake paura kremna nevaza taferora retro hiho. ");
INSERT INTO kbq_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Hagi okina tevea hugreta mnanentake'zana Ra Anumzamofo avuga krenkeno, Ra Anumzamo'ma huhampri zamante'nea vahe'mo'za, ruotage hu'za agru hugahazanki, tamagra Livae nagamota havi avu'avara huta havifi vu'naze! ");
INSERT INTO kbq_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosese'a Korankura anage hu'ne, Livae naga nofira antahiho, ");
INSERT INTO kbq_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israeli vahe Anumzamo'ma Israeli naga nofipinti tamagrira refako huno huhampriramantegeta, Ra Anumzamofo Seli mono nompima eri'zama'a enerita, Israeli vahe zamavugama eri'zama eneri'za zamo'a knarera huoramanteneo? ");
INSERT INTO kbq_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Koragane maka kafuhe'za Livae nagamota Israeli vahepinti'ma tamazeri ruotage huno'ma Agra'a tavaonte'ma tamavrente'nea zankura ontahita, tamagra nahigeta pristi eri'zanena erinakura nehaze? ");
INSERT INTO kbq_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","E'ina hu'negu kagrane kamage'ma ante'naza naga'enena eritru'ma hazana Ra Anumzamofo ha'renentaze. Hianagi Aroni'a iza mani'negeta kehakerea hunentaze? ");
INSERT INTO kbq_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Anante Mosese'a Eliabu nemofokizni Datanine Abiramunena e'ogu ke hianagi zanagra omegahu'e nehuke, ");
INSERT INTO kbq_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","tumerimo'ene amirimo'ma avimate'nea mopafinti'ma tavrefegi atrenka e'nanana, ka'ma kopi frisunegu anara hu'nano? Hagi kagra ranti mani'nenka, kva hurante'za nehano? ");
INSERT INTO kbq_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hagi kagra tamage hunka tumerine amirimo'ma avimate'nea mopafina tavrenka omenka, erisantihare'saza zane hunka mopane waini hozanena huorante'nane. Kagra ama vahera rezamatga hu'za nehampi? I'o, tagra kagranena omegahune. ");
INSERT INTO kbq_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Anage'ma hazageno'a Mosesena tusi'a asivazigeno amanage huno Ra Anumzamofona asmi'ne, Ofama hanazana antahi ozamio. Hagi magore hu'na donki afura zamagripintira e'ori'noe. Nagra mago vahera havizana huozmante'noe. ");
INSERT INTO kbq_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Anante Mosese'a Korana anage huno asami'ne, kagri'ma kavaririza naga'ene, Aroni'enena okina Ra Anumzamofo avuga eme atru hiho. Kagrane maka ana vahe'ene Aroni'enana eme atru hiho. ");
INSERT INTO kbq_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Hagi mago magomota mananentake paurane erineta anampina mnanentake'za insensia eri havia huta erita Ra Anumzamofo avuga eho. Hagi mika 250'a mananentake paura kre manavu taferotamia erineta Aroni'enena magoka Ra Anumzamofo avuga erita egahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Anage'ma hutege'za nanterana mago mago'mo'a mananentake paura kre mnavuza taferopi teve taginte'za paura kre mna vu'za, eri'za seli mono nompima ufre kafante Mosese'ene Aroni'ene oti'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hagi Kora'a agri'ma amage'ma antage'za Mosesene Aroninema ha'ma rezmante'naza vahera atruhu seli mono nomofo kafante zamazeri atru higeno, Ra Anumzamofo hihamu masa'amo'a ana miko Israeli vahetera efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Anante Ra Anumzamo'a Mosesene Aronikiznia anage huno znasami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Hagi amama atruma hu'naza vahepintira tanagra ame huta maniganeta vike'na, zamahe fanane huvagaraneno. ");
INSERT INTO kbq_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Anage hu'neanagi Mosese'ene Aronikea zanavugosaregati mopafi maseke nunamu huke anage hu'na'e. Anumzana miko vahe'mokizmi zamasimu'ma nezamina Anumzamoka, magoke ne'mo'ma hu'nenia kumitera miko vahe'mokizmia karimpa ahezmantegahano? ");
INSERT INTO kbq_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Anante Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Mika'a vahera zmasmige'za Korama, Tatanima, Abiramukizmi seli no tava'ontetira maniganeho. ");
INSERT INTO kbq_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Anante Mosese'a otino Datanine Abiramu kizanirega nevige'za, Israeli kva vahe'mo'za avariri'za vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Hagi Mosese'a miko vahera anage huno zamasami'ne, ama kumike vahe'mokizmi seli nozmimofo tava'ontetira atreta ogantu vuta eta nehuta, mago'a zazmirera avakora osiho. Hagi ana kema ontahita avako'ma hanazana zamagri kumimofo knaza erita frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Anage hige'za Korama, Datanima, Abiramukizmi seli mono nomofo tava'ontetira atre'za ogantu mani'naze. Higeke Datani'ene Abiramukea seli nozanimofo kahante mika a'mofavre'znine oti'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Anante Mosese'a amanage huno zamasami'ne, Amanahukna zama fore'ma hanigeta negesuta Ra Anumzamo huntegeno ama eri'zana e'nerie huta hugahaze. Na'ankure nagra'a navesi zantera ama ana eri'zana e'norue. ");
INSERT INTO kbq_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hagi zamagra vahe'mo'zama nehazaza hu'za frige, knazama e'orisageta, nagrikura Ra Anumzamo'a eri'zama'a erinogura huhampri onte'ne huta hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Hianagi Ra Anumzamo'a ruzahuma huno zamahe frisiana, mopamo'a ru aka huno maka zazimine zamasagahu vazisige'za, zamavu agama fri vahe kumapima uramisageta, tamagra antahi ama'ma hanazana ama vahe'mo'za Ra Anumzamofo kefenkami atre'naze huta hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Hagi anankema huvama neregeno amehuno anama oti'naza mopamo'a hagro huno keriga efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Hagi anama oti'naza mopamo'a ru'aka huno mika Korane agranema hagerafi'naza naga'ene a'mofavrezmine, makaza zaminena zamasaga huvazi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Hagi zamavuaga mani'nageno mopamo'a zamasaga huvazino, maka'zazmine refite'zamantege'za mopafi fanane hazage'za Israeli vahe'mo'za ozamage'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Hagi miko manigagi'naza Israeli vahe'mo'za mopafima urami'za vahe'mokizmi zavi krafa nentahiza, mopamo'a tasaga huvazi zankure nehu'za koro fre'naze. ");
INSERT INTO kbq_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Hagi Ra Anumzamo tevea atregeno hagana hagana huno eramino mika 250'a vahe'ma mananentake paurama kre'za ofa nehaza vahera terasage vagare'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Pristi ne' Aroni nemofo Eliazana asamigeno mananentake zama negraza taferote'ma tevema nereana hampageno. Na'ankure e'i ruotage hu'neanki eri ruotage nehuno, tevema nerea tankanuzanena eri faka hino. ");
INSERT INTO kbq_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Kumizmimofo nona'ama fri'za vahe'mo'zama mananentake paurama kremnamavaza taferozamia, erino hamanteti arukuta huteno, kresramna vu ita refitente'za tro hino. Na'ankure Ra Anumzamofo amizageno anazamo'a ruotage huno me'neanki'za Israeli vahe'mo'za nege'za koro hugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Higeno pristi ne' Eleasa'a tevemo'ma zamahe fananema hia vahe'mokizmi 250'a mananentake paurama kre manavu bronsire tafero zamia erino, ruguta huno kresramna vu itama refite'za tro hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ra Anumzamo'ma Mosesema asami'nea kante anteno, anazamo'a mago avame'za me'nena Israeli vahe'mo'za nege'za, Aroni nagamoke mananentake paurana kremana vugahazanki, Kora'ene naga'amo'zama hu'nazaza huta rumota ke rutagreta anara osugahune hu'za antahigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Hianagi anante knazupa Mosesene Aronikiznia Israeli vahe'mo'za ke hakare huznante'za, Tanagra Ra Anumzamofo vahe zamahe frie. ");
INSERT INTO kbq_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Hagi mika vahe'mo'zama atru hu'za Mosesene Aronikiznima ke ha'ma hunezanante'za rukrahe hu'za kazageno, hampomo'a atruhu seli nona refitegeno Ra Anumzamofo masamo efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Anante Mosese'ene Aroni'enena atruhu seli nomofo kafantega vuke ome oti'nakeno, ");
INSERT INTO kbq_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","ama vahepintira maniganeke'na ame hu'na miko zamahe fanane huvagara'neno. Anage higeke Mosese'ene Aroni'enena zanavugosaregati mopafi mase'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Anante Mosese'a Aronina asmino, mananentakezama kre taferoka'a erinka antuma atruma hu'za mani'naza vahepi vunka, zamagri kumitera nona hunka mananentake paurana kremana vuo. Na'ankure Ra Anumzamofo rimpahe'zamo'a ama agafa higeno hazenkezamo'a agafa nehie. ");
INSERT INTO kbq_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Higeno Mosese'ma asamiaza huno Aroni'a agareno ana vahe amunompi vu'ne. Hianagi ko zamazeri havizahu knazamo'a agafa huno ana vahepina efore hu'negeno ome negeno, mananentake paurana Ra Anumzamofontega kremna vunenteno, ama vahe'mokizmi kumira atrezamanto huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Hagi Aroni'a fri'naza vahe'ene ofri'ma amnema mani'naza vahe'mokizmi amu'nompi' kremna vu paurana azerineno ome otigeno ana knazamo'a ame huno vagare'ne ");
INSERT INTO kbq_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Hianagi Kora'ene amage'ma ante'naza vahe'ma fri'nare ete mago'ane Israeli vahera 14 tausen, 700'a vahe ana knazamo'a zamahe fri'ne. ");
INSERT INTO kbq_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Hagi ana knazamo'ma vagamaregeno'a, Aroni'a ete Mosese'ma atruhu seli mono nomofo kafante'ma mani'nerega vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Hagi Ra Anumzamo'a Mosesena anage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Israeli vahera zamasamige'za mago'mago naga nofimofonte kva vahe'mokizmi azompa zamente zamente 12fu'a eri'za eme kaminagenka, zamagi'a krentetere ana azomparera nehunka, ");
INSERT INTO kbq_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Livae naga'mokizmi azomparera Aroni agi krento. Na'ankure mago'mago naga'nofitema ugota hu'naza vahe'mokizmi azomparera zamagia krentegahane. ");
INSERT INTO kbq_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Hagi mika ana azomparamina erinka atrumahu seli mono nompima huhagerafi huvempage vogisimofo avuga keagama nehute eme anto. ");
INSERT INTO kbq_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Hagi Nagrama huhamprintesugeno pristi eri'zama erisia ne'mofo azomparera agata hagegahie. Hagi ana zama fore'ma haniretira mago'ene Israeli vahe'mo'zama ke hakare'ma hugantesazana kezmia ontahigahue. ");
INSERT INTO kbq_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Anage higeno Mosese'a miko Israeli vahera 2fu'a naga nofi'mokizmia zamasimige'za mago'mago naga nofimo'za vugotama huzmante'nemofo azompa eme nemiza, Aroni azompanena anampi eri'za eme ami'naze. ");
INSERT INTO kbq_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mosese'a mika ana azomparamina erino atruhu seli mono nompi Ra Anumzamofo avugama ome ante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Hagi anante knazupa Mosese'a atruma hu seli mono nompima vuno ome keana, Livae nagapinti ne' Aroni azumparera agata hageno amosare'a ahenteno, almoni zafa raga rente'no uzate'ne. ");
INSERT INTO kbq_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mosese'a Ra Anumzamofo avugatira ana azomparamina erino atiramino Israeli vahete vige'za, anampinti ke'za zamagra'a azompare eritere hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Hianagi Ra Anumzamo'a Mosesena anage huno asmi'ne, Aroni azompa ete erinka huhagerafi huvempage vogisimofo avuga ome ante'negeno, ana azompamo'a avame'za me'nena Nagri'ma ke hakarema hunenantaza zana vagarenke'za, ofri maniho. ");
INSERT INTO kbq_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Higeno Mosese'a Ra Anumzamo'ma huoma huno asmi'nea zana amage anteno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Hagi Israeli vahe'mo'za Mosesena asami'za, mika vahe'mota frita fanane hu vagaregahune! ");
INSERT INTO kbq_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Hagi Ra Anumzamofo seli nomofo tava'onte'ma vanuta, tagra mika vahe'mota frita haviza hugahune. ");
INSERT INTO kbq_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Anante Ra Anumzamo'a amanage huno Aronina asami'ne, Kagrane Livae naga'mo'zane mofavre nagakamo'zanema ruotage'ma hu'nea seli mono noni'afima pristi eri'zama eriso'ema osnazana, kna'a tamagra'a erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Hagi tamafuhe'i Livae nagara zamavareta enke'za, tamagrane erimago hu'za tamaza hanageta seli mono nomofo avuga eri'zana eriho. ");
INSERT INTO kbq_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Hagi zamagra maka tamagrama zamisaza eri'za e'neri'za, seli mono nomofo eri'zana eriho. Hianagi ruotage'ma hu'nea zantaminte'ene, kresramna vu itarera erava'o osiho. Hagi erava'oma hanazana tamagrane, zmagranena frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Livae vahe'mo'zage seli mono nompina eri'zana tamaza hu'za eriho. Hianagi ru vahe'mo'za erava'o osuge, eri'zana tamaza hu'za e'origahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Hagi kagrake seli mono nompi eri'zane, kresramna vu itare'enena eri'zana erigahane. E'inahukna hanankeno Ra Anumzamo'a Israeli vahe'mota arimpa aheoramantegahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Hagi ko, Nagra'a Israeli vahepintira Livae nagara zamavare'na mago museza zamiaza hu'na negamina, zamazeri ruotage huge'za seli mono nompina eri'zana e'nerize. ");
INSERT INTO kbq_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Hianagi kagrane mofavreka'aramine pristi eri'zane, kresramna vu itare'ene, hunagru'ma hu'nefinka eri'zana erigahaze. Hagi muse'za tamiankna hu'na pristi eri'zana tami'noanki, ru vahe'mo'zama seli mono nomofo tavaonte'ma erava'oma hanazana zamahe friho. ");
INSERT INTO kbq_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Anante Ra Anumzamo'a anage huno mago'ane Aronina asmi'ne, Veamo'zama ofama eri'za esaza ofaramina kegavama hu eri'zana, kagri kamuankinka ruotage'ma hu'nea ofama Israeli vahe'mo'za eri'za esazana kagri'ene mofavre zagaka'ane tamamuankita anampintira tamagra'a suzana maka kna erigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ama'i ruotage'ma hu'nea ofama tevefima negrenka atresanama'ane, muse ofane, witi ofane, kumizmire'ma hu ofane, hazenke'ma hu'nesaza zante'ma hu ofama eri'za eme namisazana, ruotage hu'neakino kagri'ene mofavre nagakamofo su'a megahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","E'i ruotage hu'nea ofagita kagrane, ne' mofavre nagakamo'zane ruotage hu'ne hutma nentahita negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Hagi eri verave hu ofama Israeli vahe'mo'zama eri'zama esaza ofa kagri'ene ne'mofaka'ane miko nagaka'ane zamue. Hagi ana ne'zana, Nagri navure'ma agruma hu'nesaza nagakamo'zage negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Hagi maka knare'ma hu'nea olivi masavene, knare'ma hu'nea wainine, knare'ma hu'nea witine, ese ne'zama hamare'za Ra Anumzamo'na eme namisazana, kagri kamue. ");
INSERT INTO kbq_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Hagi ese ne'zama afumaresige'za eri'za esazana, agruma hu'nesaza nagaka'amozage negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Maka'zama Ra Anumzamo'nama nami'nesaza zana, amne kagra erigahane. ");
INSERT INTO kbq_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Hagi ese mofavre'ma Israeli vahe'mozo, zagagafamo'zama kasentesage'za, Ra Anumzamonare ofa eme namisazana kagri'za megahie. Hagi Israeli vahe'mo'zane zmagonesa mofavrene, agruma osu'nesia zagagafarera nona hu'za mizaseza avreho. ");
INSERT INTO kbq_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Hagi Israeli vahe'mo'za mago ikama hu'nesia agonesa mofavrere'ma ete mizase'za zamavaresaza mizana, seli mono nompi zagomofo avamente erinte'za 5fu'a silva zagoa mizasegahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Hianagi bulimakao'o, sipisipio meme afumo'zama ese kasezmantesa anentara, ruotage hu'neankino ete Israeli vahe'mo'za mizana osegahaze. Hagi kagra kresramna vu itare korazmia taginka ru tritri nehunka, afova'a tevefi kregeno, sramnamo'a kumpi marerinke'na Ra Anumzamo'na mna'a nentahina musena haneno. ");
INSERT INTO kbq_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Hagi ana ofama hu afumofo ame'a tamagri suza mesigeno, eri verave hu ofama nehaza ahihiza'ane, tamaga kaziga amo'anena tamagri su'za megahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Hagi meninteti'ma agafama huno'ma vaniana, Israeli vahe'mo'zama Ra Anumzamo'nare'ma eri'za esaza ofamo'a tamagri'ene, ne'mofatamimofo suza mevava hugahie. Hagi ama ana zamo'a mevava huhagerafi huvempage Nagrite'ene henkama tamagripinti fore'ma hanaza vahetera meno vugahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Hagi Ra Anumzamo'a Aronina amanage huno asami'ne, Israeli mopafina tamagra mago mopa erinafa'a osugahze. Tamagrama eri santima hare'nazazana Nagrake'za manigahue. ");
INSERT INTO kbq_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hagi Livae naga'nofimo'za atruma hu seli mono nompima eri'zama erisa mizana, Israeli vahe'mo'zama 10ni'a kevu ante'nenafinti mago kevuma namisaza zantaminteti, ana eri'zama erisarera erisantima hare'saza zana zamigahue. ");
INSERT INTO kbq_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Hagi meninteti'ma agafama huno vaniana Israeli vahepinti'ma Livae naga'ma omaninesimo'a, atruma hu seli mono nontera uravaoa osino. Hagi urava'oma hanimo'a kumi hugahiankino, ana nona'a frigahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Hagi Livae naga'mozage atruma hu seli mono nompina vahe kumima apasezmante eri'zana erigahaze. Hagi ama tra kemo'a mevava hugahianki'za, henkama fore'ma hanaza vahe'mo'za amage antegahaze. Hagi Israeli mopafina Livae vahe'mokizmia mopazamia omanegahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Na'ankure Israeli vahe'mo'za 10ni'a kevu antenenafinti mago kevuma ofama Ra Anumzamo'na namisaza zantamina erisante'maharesaza zana zamigahue. Hagi e'i ana agafare Israeli vahepina, Livae naga'mozama erisantima haresaza mopa omanegahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ra Anumzamo'a Mosesena amanage huno asami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Kagra Livae nagara ke hunka zamasamige'za Israeli vahe'mo'zama 10ni'a kevu ante'nenafinti mago kevuma eri'za emema namisafintira eri'na tamagrira tamigahuanki, anampintira ete hamprinkeno 10nima hania kevua namigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hagi ana ofama hanage'na, Ra Anumzamo'na nege'na, hoza tamifinti ese witi hamareta ofa haze nehu'na, wainima regatitima nehazafinti ese waini ofa nehaze hu'na hugahue. ");
INSERT INTO kbq_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","E'inahu kante Israeli vahe'mo'zama 10ni'a kevuma ante'nafinti mago kevuma eme tami'nazana refko huta Ra Anumzamo'na ofa hunantegahaze. Hagi ana ofama Ra Anumzamo'nama namisazana pristi ne' Aroni erigahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Hagi maka musezama taminafintira knare'zantfama hu'nesiama'a Ra Anumzamo'na namigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ana hu'negu Livae nagara zamasamio, anama knare'ma hu'neama'ama ofama hanage'na, Ra Anumzamo'na nege'na, hoza tamifinti witi hamareta ofa haze nehu'na, wainima regatiti'ma nehazafinti waini ofa nehaze hu'na hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Hagi Livae naga'mota seli mono nompi eri'zama e'neriza zamofo mizama'agita, a'mofavre taminena inantegama ana ne'zama nenaku'ma hanarega amne negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Hagi knare'ma hu'nesia ne'zama ofama hanuta, kumira osugahaze. Hianagi Israeli vahe'mo'zama eme tamisaza ruotage ne'zama amnezane huta eri havizama hanuta, haviza hugahazankita knazama'a tamagra'a erita frigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ra Anumzamo'a Mosesene Aroninena anage huno zanasami'ne, ");
INSERT INTO kbq_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ama'na trakea Israeli vahera zamasaminke'za korankre agaho bulimakaomofoma afuhe'afehe osu'nenigeno, agumpina agare namare zafa reonte'nenaza su'za avre'za eho. ");
INSERT INTO kbq_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Hagi ana agaho bulimakaona pristi eri'za ne' Eliesa eme amisageno, mago'a vahe'mo'za avre'za kumamofo fegi'a vu'za, agri avuga anankena akafrigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Hagi pristi ne' Eliesa'a ana bulimakaomofo korampi azankoreteno, atruma hu seli mono noma me'nerega 7ni'a zupa rutritrira hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Hagi ana bulimakaomofo akruagi, ame'agi, korama'agi, rimpa'anena rifa'aga tevefi kregahaze. ");
INSERT INTO kbq_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Hagi ana pristi ne'mo'a, sida zafagi, hisopu zafamofo azankunaki, korankre nofi'ene erino, ana tevema nerea amu'nompi kregahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hagi ana pristi ne'mo'a kukena'a sese nehuno, tina fregahie. Ana'ma hutesuno'a kumapina efregahianagi, Nagri navurera agrua osu mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Hagi ana bulimakaoma tevefima krenia ne'mo'enena kukena'a sese nehuno, tina fregahie. Hianagi Nagri navurera agrua osu mani'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Hagi Nagri navure'ma agruma hu'nenia ne'mo ana bulimakaomofo tanefara erino, kumamofo fegia agruma hu'nefina ome antegahie. Hagi Israeli vahe'mo'za ana tanefara tima fre'za zamazeri agruma hanaza timpima atrenagu erintesageno megahie. E'inahu hanageno kumizmia eritre zmantegahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Hagi ana ta'nefa'ma kateno omema atrenia ne'mo'a agru osugahiankino kukena'a sese nehuno, mani'nenkeno vuno kinagasegahie. Hagi ama'i mevava kasege Israeli vahete'ene emani vahete'enena megahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Hagi iza'o fri vahe avufgare'ma avako'ma hanimo'a, agra'a azeri pehana hu'neakino, 7ni'a zageknafi agru osuno manigahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Hagi nampa 3 knare'ene nampa 7ni knarera tina freno agru hugahie. Hianagi nampa 3 knare'ma nampa 7ni knare'enema tima ofrenu'za agru osugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Hagi iza'o fri vahe avufgama avako huteno, agra'ama azeri agruma osania ne'mo'a, Ra Anumzamo'na seli mono nona azeri pehana hugahie. E'inama hania vahera, Israeli vahepintira ahenatitreho. Na'ankure agritera azeri agruma hu tina ru tritri huonte'neankino, agra agru osu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Hagi seli nompima mago vahe'ma frisigeno'a, ana nompima mani'nenaza vaheki, efresaza vahe'mo'zanena agrua osu mani'nenageno vuno 7ni'a zagegna evugahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Hagi ana nompima avaza'a eri onki kavoramima me'nenaza kavomo'za agru osugahaze. ");
INSERT INTO kbq_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Hagi iza'o kazinknonteti ahe'nenia vahe avako hania vahero, agra'a fri'nenia vahe avako hania vahero, fri vahe zaferinare avako hania vahero, fri vahe mati mati'ma avako'ma hania vahe'mo'a, 7ni'a knamofo agu'afi agru osugahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Hagi agra'ama azeri pehanama hu'nesia zama azeri agru'ma hunakura, kresramana vu itareti tanefa kateno kavofi anteteno, enevania tinteti afino anampina taginteno. ");
INSERT INTO kbq_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Hagi agruma hu'nenia vahe'mo'a hisopu traza erino, ana timpireteno seli nonte'ene agu'afima me'nenia zantamintera rutri tri hunenteno, anampima mani'nenia vahetera rutri tri huntegahie. Hagi ana zanke huno kazinknonteti ahe fri'nenia vahero, fri vahe zaferina avako hu'nenia vahero, fri vahe kerigante avako hu'nenia vahero, fri'nenia vahe avako hu'nenia vahera ana tinuti rutri tri huzmanteno. ");
INSERT INTO kbq_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Hagi agruma hu'nenia vahero, agruma osu'nenia vahera nampa 3 knare'ene nampa 7ni knareke ana tina rutri trira huzamanteno. Hagi agruma osu'nenia zankura kukena'a sese nehuno, tina freno mani'nenigeno vuno kinagasena, Nagri navurera agrua hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Hianagi agruma osu'nenia vahe'mo'ma agra'ama azeri agruma osu'nena, Israeli vahepintira ahenatitreho. Na'ankure Ra Anumzamo'na seli mono nona azeri pehana hugahie. Hagi azeri agruma hu tinutike rutri tri huntesageno, agru hugahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hagi amanahu avu'avazamo'a mevava kasege me'nena, tima rutri tri huzmante'za zamazeri agruma hu eri'zama eri'naza vahe'mo'za, tina nefre'za, kukenazmia sese hiho. Hagi zamazeri agruma hu tima avako'ma hanaza vahe'mo'za agru osu mani'nenageno vuno kinaga segahie. ");
INSERT INTO kbq_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Hagi agruma osu'nesia vahe'mo'ma, mago'za avako huge, mago vahe'ma avako'ma haniana, ana vahero ana zantamimo'a, agru osu me'nenigeno vuno kinagasegahie. ");
INSERT INTO kbq_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hagi ese ikantera miko Israeli vahe'mo'za Zini hagege kokampi ehanati'za Kades kumate emani'nazageno, Miriamu'a frige'za anante asente'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Anampina tima ne'naza zana omanege'za, Israeli vahe'mo'za eritru hu'za Mosesene Aronikiznia kehakare huznante'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ana vahe'mo'za Mosesena ke ha'rente'za anage hu'naze, tagrira tatranketa Ra Anumzamofo avuga tafuhe'zane fruntesina knare hisine! ");
INSERT INTO kbq_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Hagi nahigenka Ra Anumzamofo vahe'mota tavrenka hagege ka'ma kokampina anketa, tagrane zagagafatinena fri'zana nehune? ");
INSERT INTO kbq_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Hagi nagafare Isipitira tavrenka ama havizama hu'nea kokampina e'nane? Fikima, wainima witi ragama, pomigreneti zafa ragama, tima nesunazanena amafina omane mopafina tavrenka e'nane. ");
INSERT INTO kbq_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosese'ene Aronikea seli nomofo avuga zanavugosaregati mopafi umaseke, Ra Anumzamofontega nunamu hakeno, Ra Anumzamofo hanavenentake msamo'a efore hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Anante Ra Anumzamo'a Mosesena amanage huno asami'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Azompaka'a enerinka mika vahera kehuge'za atru hanagenka negafu Aroni'enena ana vahe zamavuga havemofona nanekea asamigeno, ana havefinti tina herafiramino e'na, miko vahe'mo'zane zagagafa zmimozanena tina negahaze. ");
INSERT INTO kbq_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Anage higeno Mosese'a Ra Anumzamofo avugama Aroni azompama me'neana erino, Ra Anumzamo'ma huoma huno hunteaza hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Hagi anante Mosese'ene Aronikea havemofo avuga Israeli vahera zamazeri atru nehuke, Mosese'a anage huno hu'ne, kehakare'ma hu vahe'mota kama antahiho, ama havefinti tina erifore huramigahupi? ");
INSERT INTO kbq_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Anante Mosese'a azana erintesaga huno ana havere tare zupa azompa'aretira amasagigeno ana havefintira tina herafino ege'za vahe'mo'zane zagagafazaminena ne'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Anante Ra Anumzamo'a Mosesene Aronikiznia zanasamino, Nagrikura antahionamitna, ruotge hu'ne huta Israeli vahe zmavufina osu'naku, Nagrama tami'noa mopafina ama vahera zamavareta uofregaha'e. ");
INSERT INTO kbq_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","E'ina tinkura Meribe hu'za nehaze. Na'ankure Israeli vahe'mo'za, tinkura kehakare hazageno Ra Anumzamo'a Agra'a ruotage hu'noe huno zamaveri hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Hagi Mosese'a Kadesi kumate mani'neno Idomu kini ne'tega ke erino vu vahera huzmantege'za amanage hu'za ome asami'naze. Kafuhe'za Israeli vahe'mo'za kea hu'za, Knazama tagrite'ma e'neana, hago kenka antahinka hu'nane hu'za hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Hagi neragehoza Isipi mopare urami'za rama'a kafu umani'naze. Anantega umani'nonke'za Isipi vahe'mo'zama tafahe'ine tagri'enena tazeri haviza hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Hianagi tagrama Ra Anumzamofontega krafa huntonkeno ana krafama huna ketia nentahino, ankero vahe'a huntegeno, Isipitira tavreno atirami'ne. Hagi antahio, menina kagri mopamofo agentega me'nea kumate Kadesi emani'none. ");
INSERT INTO kbq_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hagi muse hugantoanki tatregeta mopakafina ufreta vamaneno. Hagi tagrama vanuta hozatamifine waini hozatamifinena ovugahune. Anahukna huta tinkeri tamifintira tina onegosune. Hagi kini vahe kanema nehaza karanka nevuta, rukrahe huganti hugama osugahunanki, karanka fatgo huta nevuta mopatamia ome agatereta vugahune. ");
INSERT INTO kbq_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Hianagi Idomu kini ne'mo'a kenona huzamanteno, tamagra mopatifina eovugahaze. Hagi anama hanageta, kazinteti hara eme huramantegahune. ");
INSERT INTO kbq_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ete Israeli vahe'mo'za mago'ane kenona hunte'za, tagra rankama avaririta nevanunkeno zagagafatimo'zo, mago vahe'mo'ma tamagri tinkerifinti'ma tima nesigeta, tagra miza hugahune. Hagi tatrenketa mopatamifi rankamofo avariri fatgo huta nevuta mago'zana avakora osugahune. ");
INSERT INTO kbq_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Hianagi Idomu kini ne'mo'a kenona huno, amafina eovugahaze, huno nehuno hanavenentake sondia vahe zamavreno ha' eme huzmante'naku e'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Hagi Idomu kini ne'mo'ma mopanifima e'ovugahazema huno hiazanku, Israeli vahe'mo'za atre'za, ru kampi vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Hagi miko Israeli vahe'mo'zama Kadesi kumara atre'za Hori agonarega vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Hagi Idomu mopa atuparega Hori agonare Ra Anumzamo'a Mosesene Aronikiznia zanasamino, ");
INSERT INTO kbq_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aroniga Nagrama Israeli vahe'ma zaminaku'ma hu'noa mopafina uofregahananki, kafu kafahe'zama nehazaza hunka frigahane. Na'ankure e'ina hi'o hu'na tanagri'ma huranantoa kerera Meriba tintera avariri fatgo osu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hagi Aronine ne' mofavre'a Elieasanena zanavrenka Hori agonare mareri'o. ");
INSERT INTO kbq_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Hagi ana agonare Aronima antani'neno pristi eri'zama eneria kukena'a, hatenka ne'mofo Elieasana antanintegahane. Hanankeno Aroni'a anante frigahie. ");
INSERT INTO kbq_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Hagi Ra Anumzamo'ma hunteaza huno Mosese'a ana famotrena miko vahe'mo'za nezamageno agonarega zanavreno mareri'ne. ");
INSERT INTO kbq_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Hagi Mosese'a Aroni'ma antani'neno pristi eri'zama eneria kukena'a hateno nemofo Elieasa antaninte'ne. Ana higeno Aroni'a ana agonare frigeke, Moseseke Elieasakea ana agonaregati erami'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Hagi Aroni'ma fri'nea zamofoma maka Israeli vahe'mo'zama ke'za antahi'zama nehu'za, 30'a zage knafi zamasunkura hu'za zavira ate'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Hagi Kenani kumate kinia Arati kumate Negevi nemania kini ne'mo antahiama Israeli vahe'mo'za Atarimi karanka neaze hazankema nentahino'a, ha' ome huzamanteno mago'a Israeli vahera kina huzamanteno zamavareno vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Anante Israeli vahe'mo'za Ra Anumzamofonte huvempa ke hu'za, Kagrama ana vahe'ma tagri tazampi zamavarentesanketa rankumazmia eri haviza hugahune. ");
INSERT INTO kbq_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Hagi Ra Anumzamo'a Israeli vahe'mokizmi ke antahizamino Kenani vahera avrezamigeno, kumazmine, ana kumapi vahera zamahe fanane hu'naze. Ana hu'negu ana kuma'mofo agi'a Homae nehaze. ");
INSERT INTO kbq_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hagi Israeli vahe'mo'za Hori agona atre'za koranke hagerintega nevaza kantega, Idomu mopa rugagi'za vu'naze. Hianagi rama'a vahe'mo'za zaza ka nevu'za, zamavaresragu hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Hagi ana vahe'mo'za Anumzamofone Mosesenena ke ha'reneznante'za anage hu'naze, Nahigeta Isipitira tavreta ama hagege kokampina frisunegura e'na'e? Bretima ne'zana omanegeno, tima ne'zana omanegeta ama kefozama hu'nea mana nezankura tavresra hie! ");
INSERT INTO kbq_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Anage hazageno Ra Anumzamo'a ha' osifave huntegeno rama'a vahe zamaprige'za fri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Hagi Israeli vahe'mo'za Mosesente e'za anage hu'naze, kagri'ene Ra Anumzamofonema huhavizama hunte'nonana, hago kumi hu'none. Hagi nunamu hugeno Ra Anumzamo'a osifavea tagripintira avretreno. Anage hazageno Mosese'a ana vahera nunamuna huzamante'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Hagi Ra Anumzamo'a Mosesena anage huno asami'ne. Mago ha' osifave bronsireti trohunka zaza zafare hantintenege'za osifavemo'ma zamaprisia vahe'mo'za ana osifavema kesga hu'za kesamo'za ofri'za manigahaze. ");
INSERT INTO kbq_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Anage huno asamigeno Mosese'a bronsireti mago osifave tro huno za'za zafare ahekamarente'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israeli vahe'mo'za vu'za Oboti kumate seli nonkumara omeki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Hagi Oboti kumatetira atre'za vu'za Moapu mopamofo kama zage hanati kaziga hagege kokampi Ia-abarim seli nonkumara ome ki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Anantetira vu'za Wadi Zere agupofi seli nonkumara omeki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Hagi anantetira rugitagiza vu'za kantu kaziga Arnoni timofo Amori vahe'mokizmi hagage mopamofo agentega seli nonkumara ome ki'za mani'naze. Na'ankure Moapu vahe'mokizmi mopane, Amori vahe'mokizmi mopa Arnoni timo refko hu'nere seli nonkumara omeki'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","E'ina hu'negu Ra Anumzamofo hapinema hu'nea avontafemo'a huno, Wahepu Safa kaziga me'nea kumaku'ene tinkrahoku Arnoni tinku hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Hagi ana karahomo'a Ari kumateti vuno, Moapu vahe kumate ome atre'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Anantetira mago'ane vu'za Beri tava'onte me'nea tin kerire vazageno Ra Anumzamo'a Mosesena asamino, vahetamina kehutru huge'na tina zami'neno. ");
INSERT INTO kbq_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","E'i anante Israeli vahe'mo'za anage hu'za zagamera hu'naze, henami ti kerimoka hanatinka marerio, tinkerimoka! Zgame hugantone! ");
INSERT INTO kbq_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","E'ina tinkeria ranra kva vahe'mo'za kafinte'naze. Hagi rankva vahe'mo'za avame'za me'nea azompareti'ene kama vanoma nehaza azompareti anankeria hanagati'za kafinte'naze. Ana hagege kokampintira Israeli vahe'mo'za atre'za Matana kumate vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Hagi Matanatira Nahaliel vute'za, Nahalielitira Bamota vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Hagi Bamotitira Moapu kaziga me'nea agupofi Piska agonamo'ma hagege kokantega avugosama hunte'nerega e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israeli vahe'mo'za amanage hu'za Amori kini ne' Sihonintega kea atrente'naze, ");
INSERT INTO kbq_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Tatregeta mopakafina rugitagita vamaneno. Hagi tagra hoza tamifino, waini hozatamifina ovuta, agentega nevuta, tinkeri tamifintira tina oneta kinimofo rankantega nevuta, mopaka'a agatereta vugahune. ");
INSERT INTO kbq_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Hianagi Sihoni'a Israeli vahe'mo'zama mopa'afima rugitagiza evu'zankura i'o huno hunezmanteno, sondi'a vahe'a kehu atru hige'za, ana hagege kokampi vu'za Israeli vahe'mokizmia Jehasi kumate hara eme huzamante'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Hianagi Israeli naga'mo'za kazinteti hara huzamagatere'za, ana vahe mopama Amoni tinte'ma vuno Jaboku tinteti'ma uhanati'nea mopa'zmia eri'naze. Hagi Amoni vahe'mokizmi mopafina uofre'naze. Na'ankure Amoni vahe'mo'za hanavenentake vihu hu'za mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Hu'negu Israeli vahe'mo'za ana mopafima me'nea ranra kuma'ene, neone kumara eri'za ana kumatamimpi mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Na'ankure Hesboni rankumara Amori kini ne' Sihoni nemania rankumare. Hagi ana mopa korapara Moapu kini ne'mo kegava hu'nea mopa aheno hanare'neankino, ana mopamo'a meno Arnoni uhanati'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","E'ina agafare zagamema hazafina hu'za, enketa Hesboni kumara negita, Sihoni kumara erigafa hamaneno hu'za nehaze. ");
INSERT INTO kbq_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Na'ankure Hesboni rankumateti tevea reno nevie. Teve anefara Sihoni kumateti huno nevuno, Moapu mopafima Ar kumama me'neana tefanane nehuno, teno vuno Arnoni tintegama marerinerega ome atre'ne. ");
INSERT INTO kbq_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moapu vahe'moka nasunku hugantoe! Kemosi havi anumzamofo vahe'mota haviza haze! Ne'mofavretami zamazeri haviza hige'za fre'za vano nehu'za hazanke erinentazageno, mofanezmia Amori kini ne' Sihoni'ma zamavareno kina huzmanteankna nehaze. ");
INSERT INTO kbq_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Hianagi Hesboni kumatetima agafa huno vuno Dibonima uhanati'nea kumatamimpi vahera tagra nezamaheta, kumazmia zamazeri haviza hu'none. Hagi Nofa kuma'enena azeri havizantfa huta vuta Medeba kumate uhanati'none. ");
INSERT INTO kbq_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","E'ina hute'za Israeli vahe'mo'za Amori vahe mopafina mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Hagi Jazeri kumama afure'za kesazegu Mosese'a huzmantege'za vute'za ageno, Jazeri kuma tava'onte'ma Amori vahe'ma mani kagi'naza vahera Israeli vahe'mo'za ha'huzamante'za zamahe natitre'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hagi anantetira rukrahe hu'za Basani kaziga karanka mareri'za vu'naze. Hagi nevazageno Basani kini ne' Ogi'a ha'huzamante'naku sondia vahe'a kehutru hige'za Ederi kumate e'naze. ");
INSERT INTO kbq_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Hianagi Ra Anumzamo'a anage huno Mosesena asmi'ne, Ko agri'ene vahe'ane mopa'anena kagri kazampi avrentoanki korera huonto. Kagra Amori vahe'mokizmi kinima Sihoni'ma Hesboni kumate'ma nemania nete'ma hu'nanaza hugahane. ");
INSERT INTO kbq_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Hu'negu Israeli vahe'mo'za Ogine ne' mofavre'ane naga'ane vahe'anena ha'huzamante'za zamahe vagarazageno, mago vahere huno ana mopafina omanige'za ana mopa eri'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Hagi Israeli vahe'mo'za Jodani timofona kama zage hanati kaziga Moapu agupofi, Jeriko kumamofo kama kaziga emani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Hagi Balaki'a Zipori nemofokino Israeli vahe'mo'zama Amori vahe'ma maka'zama huzmantaza zana ke'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Hagi Moapu vahe'mo'za tusi koro hu'naze. Na'ankure Israeli vahera rama'a vahekrefa mani'nagu koro hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Hagi Moapu vahe'mo'za Midieni ranra vahera zamasami'za, ama tusi'a vahe krefamo'za bulimakaomo traza neno revrino neankna hu'za mika zantia eri havizahaze. Hagi ana knafina Zipori nemofo Balaki'a Moapu vahe kinia mani'nea knafi anara hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Hagi agri vahepi Pethor Beori kumara Yufretis rantimofo kantu kaziga me'nea kumatega, Balaki'a Beori nomofo Balamuntega kea atrenteno anage hu'ne, ko, Isipitima e'naza vahe'mo'za mopani'afina emani avite'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","E'ina hu'negu menina zamagra tagrira tagatere'za hanaveti'za tusi'a vahe mani'nazanki, eme naza hunka kazusi ke huzmantegeta, tagra zamarotago hamnena freho. Nagra antahi'noe, izano sifanama ahentamo'a haviza nehigeno, asomu kema huntamo'a, asomu e'nerimoka mani'nane. ");
INSERT INTO kbq_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Hagi Moapu kva vahe'ene Midiani kva vahe'mo'za Balamuma miza sentesaza zagoa eri'za vu'naze. Hagi Balamuma eme nege'za Balaki'ma hu'nea nanekea asami'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Hagi Balamu'a ana vahera anage huno zamasami'ne, meni kenagera mase'nenkena ana kemofo nona'a, Ra Anumzamo'ma nasami'nia nanekea oki'na tamasami'neno, hige'za ana ranra vahe'mo'za ana kenagera agrane mase'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Hagi ana kenagera Anumzamo'a Balamunte eno anage hu'ne. Ama vahera iga vahe'mo'za kagranena emani'naze? ");
INSERT INTO kbq_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balamu'a Anumzamofona anage huno asami'ne, Balaki'a Zipori nemofo Moapu kini ne'mo ama vahera huzamantege'za nagritega ke eri'za e'naza vahe mani'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Hagi zamagra anage hu'za nasami'naze, Isipiti'ma e'naza vahe'mo'za mopa mani avite'nazanki enka nagri kaziga eme antenka kazusi huzmantegeta ha'huzamanteta zamahe natitramnena atre'za freho hu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Hianagi Anumzamo'a Balamuna anage huno asami'ne, Zamagranena ovuo. Hagi e'i ana vahe'enena vunka Israeli vahera kazusi kea ome huo zmantegahane. Na'ankure nagra Israeli vahera asomu ke huzamante'noe. ");
INSERT INTO kbq_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Hagi nanterana Balamu'a otino Balakima huzmantege'za e'naza kva vahera anage huno zamasami'ne, tamagrake kumatamirega viho. Na'ankure Ra Anumzamo'a ovugahane huno hianki'na tamagranena ovugahue. ");
INSERT INTO kbq_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Anage higeno Moapu kini ne' Balaki'ma huzmantege'za e'naza kva vahe'mo'za ete vu'za Balamu'ma omegahuema hia nanekea Balakina ome asmi'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Hagi Balaki'a mago'ene kote'ma huzamantege'za vu'naza ranra vahe'ma zmagatere'nea ranra vahetami rama'a huzmantage'za ete vu'naze. ");
INSERT INTO kbq_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ete Balamunte e'za, amanage hu'za asmi'naze, Zipori nemofo Balaki'a anage huno hurantegeta one, muse hugantoanki nagritegama enoma huana atregeno mago'zamo'a kazerionte'na amne eno. ");
INSERT INTO kbq_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Na'ankure knare hu'na rama'a fenoza mizana negami'na, na'ankuro hananana amane hugantegahue. Hagi enka ama Israeli vahera kazusi kea eme huzamanto huno hu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Hianagi Balamu'a Balaki eri'za vahe'mokizmi kenona zamirera anage hu'ne, Silvane golinena avite'nenia noma'a Balaki'a amne namigahianagi, nagra Ra Anumzanimofona agatere'na razano osi'zano osugahue. ");
INSERT INTO kbq_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","E'ina hu'negu muse huramantoanki kote'ma e'naza vahe'mo'za hu'nazaza huta meni kenagera nagrane mase'nenkena Ra Anumzamo'a na'ane hugahifi antahiteno. ");
INSERT INTO kbq_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Hagi ana kenage Ra Anumzamo'a Balamunte eno amanage huno asmi'ne, Ana kva vahe'mo'zama kagri'ma kema hunaku esagenka, otinka zamagrane vugahananagi, Nagrama hanua ke'age zmasamigahane. ");
INSERT INTO kbq_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Hagi Balamu'a nanterana otino donki afu'a retrotra nehuno, kini ne'mofo eri'za vahe'ane Moapu vu'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Hianagi Balamu'ma ana vahe'enema viazanku Ra Anumzamo'a rimpa ahentegeno, Ra Anumzamofo ankeromo'a ha'hunte'naku kampi eme oti'ne. Agra donki afu'amofo agumpi manino nevigeno, tare eri'za netremokea agrane vu'na'e. ");
INSERT INTO kbq_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Hagi Balamu donki afu'mo'ma Ra Anumzamofo ankeromo'ma azampi bainati kazinknoma eri'neno otinegeno ome negeno'a, ana donki afu'mo'a kana atreno trampi evu'ne. Hianagi ana donki afu'a kante evinogu Balamu'a ruharakimi'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Higeno tare waini hozamofo keginamo kanti kamati eri onasi hu'nea kankamunte, ana ankeromo'a oti'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Hagi donki afumo'ma Ra Anumzamofo ankeroma negeno'a, keginare Balamu agia eme runkasisino evigeno ete mago'ane Balamu'a ana donki afura ahe'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Anantetira Ra Anumzamofo ankeromo'a atreno vuno keginagamo'ma ome ositfama higeno agaterenoma vuganti kamama osu'are umani hiza huno oti'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Hagi donki afumo'ma Ra Anumzamofo ankeroma anante eme negeno'a, mopafi renareno emanigeno, Balamu'a rimpa ahegeno ana donki afura azompa'areti ahe'ne. ");
INSERT INTO kbq_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Anante Ra Anumzamo'a higeno ana donki afu'mofo Balamuna anage huno asami'ne, Na'a hugantogenka 3'a zupa nenahane? ");
INSERT INTO kbq_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Higeno Balamu'a ana donki afu'mofo kenona anage huno asmi'ne, Kagra nagrira nazeri neginagi vahe kna hu'nananki'na nazampima kazinknoma eri'noresina kagr