﻿USE sofia;
DROP TABLE IF EXISTS sofia.kbo_vpl;
CREATE TABLE kbo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kbo_vpl WRITE;
INSERT INTO kbo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Íꞌdóngárá gá ꞌdãá, Múngú gbi ꞌbụ̃ pi vũ be. ");
INSERT INTO kbo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Vũ rĩ adri kú kána, ngá ãzi ꞌa ni gé ꞌdãáyo, yị̃ị́ dabaya rĩ ẽ drị̃ bĩ nịị́ kuú cịcị, Índrí Múngú vé rĩ ri ẹ́cị́ yị̃ị́ rĩ drị̃gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Múngú ní ꞌyozú kĩnĩ, “Lẽ ụ̃tụ́ŋá ã adri anigé.” Ụ̃tụ́ŋá ní dị̃zú ãngũ ĩmgbẽrẽzú. ");
INSERT INTO kbo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Múngú ndre ụ̃tụ́ŋá rĩ índré ꞌí mị gé ꞌdãá múké, ĩri ní ụ̃tụ́ŋá pi ãsámvú acozú ãngũ bĩípi nịị́pi cịcị rĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Múngú ní ụ̃tụ́ŋá rĩ zịzú “Ụ̃tụ́ ãmgbáráká” ĩri ní ãngũ bĩípi nịị́pi cịcị rĩ zịzú “ị́nị́ŋá.” Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ ãlu rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Múngú ní ꞌyozú kĩnĩ, “Lẽ ãngũ mgbọ ã adri ụrụ ꞌdãá yị̃ị́ rĩ pi ãsámvú gé, ã aco rí yị̃ị́ ꞌbụ̃ gé rĩ pi ãsámvú yị̃ị́ vũ drị̃gé rĩ be.” ");
INSERT INTO kbo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Múngú ní ãngũ mgbọ ụrụ rĩ gbizú, ã aco rí yị̃ị́ ꞌbụ̃ gé rĩ pi ãsámvú yị̃ị́ vũ drị̃gé rĩ be. Ĩri ní ꞌi ngazú sụ̃ Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Múngú ní ãngũ mgbọ ụrụ rĩ zịzú “ꞌbụ̃.” Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ ị̃rị̃ rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Múngú ní ꞌyozú kĩnĩ, “Lẽ yị̃ị́ ꞌbụ̃ ndụ́gé rĩ ã úmú ꞌi vũrã ãlu gé, ãngũ ãꞌwí ẽ índré.” Ĩri ní ꞌi ngazú sụ̃ Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Múngú ní ãngũ ãꞌwí rĩ zịzú “nyọ̃ọ́kụ́”, ĩri ní yị̃ị́ ĩ úmúꞌbá vũrã ãlu gé rĩ zịzú “yị̃ị́ tafu”. Múngú ndre ꞌí mị gé ꞌdãá índré múké. ");
INSERT INTO kbo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Múngú ní ꞌyozú kĩnĩ, “Lẽ ngá rĩ pi ẽ ĩfũkí dụụ́ nyọ̃ọ́kụ́ drị̃gé, ngá úri be ni pi, ãzini pẹtị ũꞌa be ni pi, ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí.” Ĩri ní ꞌi ngazú sụ̃ Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ngá rĩ pi ní ĩfũzú ꞌdụzú nyọ̃ọ́kụ́ drị̃gé, ngá úri be ni pi, ãzini pẹtị ũꞌa be ni pi ĩfũkí dụụ́ ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. Múngú ndre kộpi ꞌí mị gé ꞌdãá índrékí múké. ");
INSERT INTO kbo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ na rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Múngú ní ꞌyozú kĩnĩ, “Lẽ ngá dị̃ꞌbée ãngũ ĩmgbẽrẽꞌbée ni pi ẽ índrékí ꞌbụ̃ gé ꞌdãá, ã aco rí ụ̃tụ́ŋá pi ãsámvú ị́nị́ŋá be, kộpi ẽ iꞌdakí rí lókí rĩ pi ã vúgú, ụ́ꞌdụ́ rĩ pi ã vúgú, ãzini ílí rĩ pi ã vúgú, ");
INSERT INTO kbo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","kộpi ã dị̃kí rí ãngũ ĩmgbẽrẽé ꞌbụ̃ gé ꞌdãásĩ ímụ́ vũ drị̃gé nõó.” Ĩri ní ꞌi ngazú sụ̃ Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Múngú ní ngá ambugu dị̃ꞌbée ãngũ ĩmgbẽrẽꞌbée ni pi gbizú ị̃rị̃. Ãmbúgú agaápi rá rĩ, ã dị̃ rí ãngũ ĩmgbẽrẽé ụ̃tụ́ŋá sĩ, mãdãŋá rĩ, ã dị̃ rí ãngũ ĩmgbẽrẽé ị́nị́ŋá sĩ. Ĩri ní kpá línyã rĩ pi gbizú. ");
INSERT INTO kbo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Múngú ꞌbã kộpi ꞌbụ̃ gé ꞌdãá, kộpi ã dị̃kí rí ãngũ ĩmgbẽrẽé vũ drị̃gé nõgó, ");
INSERT INTO kbo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ụ̃tụ́ rĩ ã dị̃ rí ãngũ ĩmgbẽrẽé ụ̃tụ́ŋá sĩ, mbãá rĩ ã dị̃ rí ãngũ ĩmgbẽrẽé ị́nị́ŋá sĩ, ã aco rí ụ̃tụ́ŋá pi ãsámvú ị́nị́ŋá be. Múngú ndre kộpi ꞌí mị gé ꞌdãá índrékí múké. ");
INSERT INTO kbo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ sụ rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Múngú ní ꞌyozú kĩnĩ, “Lẽ ngá ídri be ni pi ã adrikí yị̃ị́ agá ꞌdãá, ãzini lẽ ãríŋá rĩ pi ã ungakí ãngũ mgbọ ꞌbụ̃ pi ãsámvú vũ be rĩ gé sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kúru Múngú ní ngá ambugu ambugu yị̃ị́ tafu agá ídri be rĩ pi gbizú ngá céré ídri be ẹ́cị́ꞌbá ẹ́cị́ẹ̃cị̃ rĩ pi be, ãríŋá rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. Múngú ndre kộpi ꞌí mị gé ꞌdãá índrékí múké. ");
INSERT INTO kbo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Múngú sẽ kộpi ní tãkíri, ĩri ní ꞌyozú kĩnĩ, “Ĩmi tịkí, ĩmivé kãlãfe ã ga tré yị̃ị́ tafu rĩ agá ꞌdãá, ãríŋá rĩ pi vé kãlãfe ã ga tré vũ drị̃gé nõgó.” ");
INSERT INTO kbo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ tọ̃wụ́ rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Múngú ní ꞌyozú kĩnĩ, “Lẽ ãnyãpá rĩ pi, ngá nyíríŋá ídri be ẹ́cị́ꞌbá vũ drị̃gé sĩ rĩ pi, ãzini ãꞌá rĩ pi ã adrikí vũ drị̃gé nõgó anigé ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí.” Ĩri ní ꞌi ngazú sụ̃ Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Múngú gbi ãꞌá rĩ pi ãnyãpá rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ãzini gbi ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. Múngú ndre kộpi ꞌí mị gé ꞌdãá índrékí múké. ");
INSERT INTO kbo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kúru Múngú ní ꞌyozú kĩnĩ, “Lẽ ꞌbâ gbikí ꞌbá sụ̃ụ́ ꞌbá tị́nị, kộpi ã adrikí rí ãmbúgú ị̃ꞌbị́ yị̃ị́ tafu agá rĩ pi drị̃gé, ãríŋá rĩ pi drị̃gé, ãnyãpá rĩ pi drị̃gé, ãꞌá rĩ pi drị̃gé, ãzini ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi drị̃gé.” ");
INSERT INTO kbo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kúru Múngú ní ꞌbá gbizú sụ̃ ꞌí tị́nị, Múngú gbi ĩri sụ̃ ꞌí tị́nị, gbi kộpi ágó pi ũkú be. ");
INSERT INTO kbo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Múngú ní tãkíri ꞌbãzú kộpi drị̃gé, ĩri ní ꞌyozú kĩnĩ, “Ĩmi tịkí, ĩmi ízúkí ízúzũ, ĩmivé kãlãfe ã ga tré vũ drị̃gé nõgó, ĩmi adrikí ãmbúgú nyọ̃ọ́kụ́ rĩ drị̃gé. Lẽ ĩmi adrikí ãmbúgú ị̃ꞌbị́ yị̃ị́ tafu agá rĩ pi drị̃gé, ãríŋá rĩ pi drị̃gé, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi drị̃gé.” ");
INSERT INTO kbo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kúru Múngú ní ꞌyozú ꞌbá rĩ ní kĩnĩ, “Ngá úri be vũ drị̃gé rĩ pi, pẹtị ꞌaꞌbée ꞌaꞌa úri be agá rĩ pi ãrẽvú céré, á sẽ kộpi mí ní. Kộpi adri ãnyãngã mívé ni. ");
INSERT INTO kbo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Á sẽ ngá ĩfũꞌbá dụꞌbá nyọ̃ọ́kụ́ drị̃gé rĩ pi ãrẽvú céré ãꞌá rĩ pi ní, ãríŋá rĩ pi ní, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi ní ãnyãngã rú.” ");
INSERT INTO kbo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Múngú ndre ngá ꞌí ní gbií rĩ pi ãrẽvú céré índrékí ꞌí mị gé ꞌdãá múké múké. Ũndréŋá ní ícázú, ãngũ rĩ ní ọ́wụ́zú, ꞌdĩri ụ́ꞌdụ́ ázíyá rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kúru ꞌbụ̃ pi vé gbingárá vũ be, ngá céré ꞌa ni gé rĩ pi be rĩ ní ꞌi dẹzú. ");
INSERT INTO kbo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kúru kã mụụ́ caá ụ́ꞌdụ́ ẹ́zị̂rị̃ gé, ị́sụ́ Múngú dẹ ívé ẹ̃zị́ rĩ ã ngangárá gí, kúru ụ́ꞌdụ́ ẹ́zị̂rị̃ gé, ĩri ní uvuzú. ");
INSERT INTO kbo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Múngú ní tãkíri ꞌbãzú ụ́ꞌdụ́ ẹ́zị̂rị̃ rĩ drị̃gé, ꞌbã ụ́ꞌdụ́ ꞌdĩri adrií uletere, ãꞌdiãtãsĩyã ụ́ꞌdụ́ ꞌdĩri ĩri ní uvuzú rĩ, ị́sụ́ dẹ ívé ẹ̃zị́ ngá rĩ pi gbizú rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ꞌBụ̃ pi vé gbingárá vũ be rĩ ĩri ꞌdíni. Úpí Múngú kã ꞌbụ̃ pi gbií vũ be gí, ");
INSERT INTO kbo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ásé, pẹtị, dõku ngá ãzi ĩfũ dụụ́ vũ rĩ drị̃gé kuyé, ãꞌdiãtãsĩyã Úpí Múngú sẽ drĩ yị̃ị́gọ́ ꞌdịị́ vũ rĩ drị̃gé kuyé, ꞌbá ọ́mvụ́ ꞌãápi ni ꞌdãáyo, ");
INSERT INTO kbo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ẹndrịlị́gọ́ ri ꞌaá nyọ̃ọ́kụ́ rĩ ẽ drị̃ ũndrĩí nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Úpí Múngú ní ũtrẽtrẽ ĩtĩzú, ĩri ní gbizú ufuzú ꞌbá ágó rú, ĩri ní ẹ̃vị̃vị̃ ídri vé rĩ vuzú ụ̃mvụ ni gé, ágó rĩ gõ ícá ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Úpí Múngú ní ngá sazú ọ́mvụ́ Ẽdénẽ vé rĩ agá, wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé, ĩri ní ágó ꞌí ní gbií rĩ jịzú ꞌbãzú ọ́mvụ́ rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Úpí Múngú sa pẹtị ũnyĩ be ũꞌa be ĩ ní nyaá íníꞌbá ínínĩ ni pi ọ́mvụ́ rĩ agá ꞌdãá ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. Ọ́mvụ́ rĩ ã ágáŋá gá ꞌdãá, sa pẹtị ídri sẽépi rĩ, ãzini pẹtị tã múké pi nị̃zú tã ũnjí be rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yị̃ị́ ãzi ídị́ ĩfũú ọ́mvụ́ Ẽdénẽ vé rĩ agá ꞌdãá, ri ọ́mvụ́ rĩ ũsũú nĩ, yị̃ị́ rĩ aco ꞌi caá sụ. ");
INSERT INTO kbo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yị̃ị́ ãlu rĩ ã rụ́ Pĩsónã, dị ẹlịị́ mụzú ãngũ Hãvílã vé dábũ be rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dábũ ãngũ ꞌdãri vé rĩ múké, pẹtị sụ́ be ngụ̃ụ́pi ndrị̃ndrị̃ rĩ ꞌdãlé anigé, ãzini írã ũnyĩ be ĩ ní zịị́ õníkĩ rĩ pi ꞌdãlé anigé. ");
INSERT INTO kbo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Yị̃ị́ ị̃rị̃ rĩ ã rụ́ Gĩyónã, dị ẹlịị́ mụzú ãngũ Kụ́sị̃ vé rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yị̃ị́ na rĩ ã rụ́ Tị́gị̃rị̃sị̃, dị ẹlịị́ mụzú ãngũ Ãsírĩyã vé rĩ agásĩ, ụ̃tụ́ ní ĩfũngárá gálésĩla. Yị̃ị́ sụ rĩ ã rụ́ Yũfẽrétã. ");
INSERT INTO kbo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Úpí Múngú ní ágó rĩ jịzú ꞌbãzú ọ́mvụ́ Ẽdénẽ vé rĩ agá, ã ꞌã rí ọ́mvụ́ rĩ, ãzini ã ũtẽ rí ọ́mvụ́ rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Úpí Múngú ní ꞌyozú ágó rĩ ní kĩnĩ, “Mi ícó pẹtị ọ́mvụ́ agá rĩ pi vé ũꞌa nya rá, ");
INSERT INTO kbo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ꞌbo lẽ mî nya pẹtị ĩ ní tã múké nị̃zú tã ũnjí be rĩ ku, ꞌí nya dõ gí, ádarú mi drã rá.” ");
INSERT INTO kbo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Úpí Múngú ní ꞌyozú kĩnĩ, “Ágó rĩ adri dõ ọ́ꞌdụ́kụ́lẹ, adri múké ku. Ma ꞌbá ĩri ẽ ĩzã koópi ni gbi ĩri ní rá.” ");
INSERT INTO kbo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kúru Úpí Múngú ní ũtrẽtrẽ ĩtĩzú, ĩri ní gbizú ufuzú ãnyãpá rú, ãꞌá rĩ pi rú, ãzini ãríŋá rĩ pi rú. Ĩri ní kộpi jịzú ágó rĩ vúgá ꞌdãá, ã ndre rí kộpi, ã ꞌda rí kộpi ã rụ́, ágó rĩ ní kộpi ã rụ́ ꞌdazú ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kúru ágó rĩ ní ãnyãpá rĩ pi vé rụ́ ꞌdazú, ãríŋá rĩ pi be, ãꞌá rĩ pi be céré. ꞌBo ꞌbá Ãdámã ẽ ĩzã koópi ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kúru Úpí Múngú ní ágó rĩ sẽzú ụ́ꞌdụ́ kozú kpílíkpílí. Ágó rĩ kã rií ụ́ꞌdụ́ rĩ koó, Úpí Múngú ní ĩrivé gãrãfã ãlu ínjézú, ĩri ní vũrã ni ọ̃zụ̃zú gõzú ũzi. ");
INSERT INTO kbo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kúru Úpí Múngú ní gãrãfã ágó rĩ vé ꞌí ní ínjé rĩ gbizú ufuzú ũkú rú, ĩri ní jịzú ágó rĩ vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ágó rĩ ní ꞌyozú kĩnĩ, “ꞌBá nõri vé fã sụ̃ mávé rĩ tị́nị, ĩrivé zãá sụ mávé rĩ tị́nị, ĩ rụ́ ni zị ‘ũkú’, ãꞌdiãtãsĩyã íbíkí ĩri ínjé mâ rụ́ꞌbá gá.” ");
INSERT INTO kbo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tã ꞌdĩri sĩ, ꞌbá ágó ri ívé ẹ́tẹ́pị ku, ĩri ívé ẹ́ndrẹ́pị ku, kộpi ĩ úmú ũkú ni be, kộpi adri rụ́ꞌbá ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ágó rĩ pi ũkú ni be ị̃rị̃trọ́ pílílí rú, ꞌbo kộpi adrikí kú drị̃njá ãkó. ");
INSERT INTO kbo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ãꞌá Úpí Múngú ní gbií rĩ pi ãsámvú gé, ị̃nị̃ ri ãꞌá riípi mị ũꞌbãápi agaápi rá ni. Ụ́ꞌdụ́ ãlu, ĩri ní ũkú rĩ zịzú kĩnĩ, “Ẹ̃ndẹ́pị Múngú ꞌyo nyo kínĩ ĩmi nyakí pẹtị ũꞌa ọ́mvụ́ agá ꞌdĩꞌbée ku ꞌdíni rá?” ");
INSERT INTO kbo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ũkú rĩ ní újázú ị̃nị̃ rĩ ní kĩnĩ, “Múngú kĩnĩ, ꞌbâ ícó pẹtị ọ́mvụ́ agá ꞌdĩꞌbée vé ũꞌa nya rá, ");
INSERT INTO kbo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ꞌbo Múngú kĩnĩ, ‘Pẹtị ọ́mvụ́ ágáŋá gá ꞌdãri vé ũꞌa, lẽ ĩmi nyakí ku, dõku ĩmi úlókí ku, ĩmi nyakí dõ gí, ĩmi ícó ũdrã rá.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ị̃nị̃ rĩ ní újázú ũkú rĩ ní kĩnĩ, “Ĩmi ícókí ũdrãá ku. ");
INSERT INTO kbo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Múngú nị̃ rá ꞌyozú kínĩ, ĩmi nyakí dõ pẹtị rĩ vé ũꞌa gí, ĩmî mị ri ꞌi zị̃ tã nị̃zú ámázú rá, ĩmi adri sụ̃ Múngú tị́nị, ĩmi tã múké pi nị̃ tã ũnjí be rá.” ");
INSERT INTO kbo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ũkú rĩ kã ndreé pẹtị rĩ vé ũꞌa índré ꞌí mị gé ꞌdãá múké, ĩ ícó nya rá, ãzini ĩ tã múké pi nị̃ ãní tã ũnjí be rá, ĩri ní pẹtị rĩ vé ũꞌa ĩtĩzú nyazú, ĩri ní ụrụkọ ni sẽzú ágó ni adriípi ꞌí gãrã gá rĩ ní, ágó ni ní ẹ́ꞌyị́zú nyazú. ");
INSERT INTO kbo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Koro kộpi ẽ mị ní ꞌi zị̃zú, kộpi nị̃kí ámá ĩ nóni pílílí rú. Kúru kộpi ní ị̃bị́bị́ ŋõzú údézú ĩ rụ́ꞌbá ọ̃zụ̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ũndréŋá ꞌdãri sĩ, ágó rĩ pi ũkú rĩ be yịkí Úpí Múngú vé kụ́bị́, ĩri ri ẹ́cị́ ọ́mvụ́ rĩ agásĩ, kộpi ápákí Úpí Múngú sĩ mụụ́ ĩ zụ̃ụ́ pẹtị rĩ pi ãsámvú gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Úpí Múngú ní kộpi zịzú kĩnĩ, “Ĩmi íngõlé?” ");
INSERT INTO kbo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ágó rĩ ní újázú kĩnĩ, “Á yị mî kụ́bị́ ọ́mvụ́ agá ꞌdãá, sẽ má ní ụ̃rị̃, ãꞌdiãtãsĩyã ma pílílí rú, má ní ma zụ̃zú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Múngú ní ĩri zịzú kĩnĩ, “Ãꞌdi lũ mí ní kínĩ mi pílílí rú nĩ? Mí nya pẹtị rĩ vé ũꞌa má ní ꞌyoó mî nya ku rĩ gí?” ");
INSERT INTO kbo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ágó rĩ ní ꞌyozú kĩnĩ, “Ũkú mí ní sẽé má ní rĩ, sẽ má ní pẹtị rĩ ã ũꞌa, á nya gí.” ");
INSERT INTO kbo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kúru Úpí Múngú ní ꞌyozú ũkú rĩ ní kĩnĩ, “Mí ꞌo ꞌdíni ãsĩ?” Ũkú rĩ ní ꞌyozú kĩnĩ, “Ị̃nị̃ ũꞌbã mâ mị nĩ, má ní pẹtị ũꞌa rĩ nyazú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kúru Úpí Múngú ní ꞌyozú ị̃nị̃ rĩ ní kĩnĩ, “Tã mí ní ꞌoó ꞌdĩri sĩ, “Ãnyãpá rĩ pi ãsámvú gé ãꞌá rĩ pi be, á tri mi gí! Mi ímụ́ mi use bẹ̃drị̃ sĩ, mi ímụ́ fụ́rụ́ndị́ mvũ cĩmgbá cazú ụ́ꞌdụ́ céré mí ní adrizú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma sẽ ĩmivé ãsámvú ũkú rĩ be rĩ adri ũnjí, anjiŋá mívé rĩ pi ĩrivé rĩ be, kộpi ãsámvú rĩ adri ũnjí. Ĩrivé mvá ágó ri ímụ́ mi gbã drị̃gé, mi ímụ́ mvá ágó rĩ ga pá gá.” ");
INSERT INTO kbo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Múngú ní ꞌyozú ũkú rĩ ní kĩnĩ, “Sâ mí ní mvá tĩzú rĩ gé, ma sẽ mi ĩzãngã nya ambamba. Mí kãdõ mvá tĩí, ãzó ni ri ásó ambamba. Mi áwí ẹ́sị́ ꞌbã ku mí ágó ni drị̃gé, ꞌbo ĩri adri ãmbúgú mí drị̃lé gá nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Múngú ní ꞌyozú Ãdámã ní kĩnĩ, “Mí ní mívé ũkú ẽ tị yịị́, ãzini mí ní pẹtị ũꞌa má ní ꞌyoó, ‘Mî nya ku’ rĩ nyaá rĩ sĩ, “Á tri nyọ̃ọ́kụ́ rĩ gí, mî tã sĩ. Sâ mí ní adrizú ídri rú rĩ gé, mi ọ́mvụ́ ꞌã ũkpõ sĩ, ụ́rụ́ndẹ be, mí íbí ngá nya ndõ. ");
INSERT INTO kbo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ũcékúcé ri ĩfũ dụ nyọ̃ọ́kụ́ rĩ agá, mi ngá ĩfũꞌbá dụꞌbá nyọ̃ọ́kụ́ drị̃gé rĩ pi nya. ");
INSERT INTO kbo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mi ọ́mvụ́ ꞌã ũkpõ sĩ, ụ́rụ́ndẹ be, mi íbí ngá nya ndõ, cĩmgbá mí ní fizú gõzú nyọ̃ọ́kụ́ agá rĩ gé, ĩtĩkí nyọ̃ọ́kụ́ ĩ ní mi gbizú ãní, mi gõ fi nyọ̃ọ́kụ́ agá ũzi.” ");
INSERT INTO kbo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ãdámã ꞌda ꞌî ũkú ni ã rụ́ Évã ꞌi, ãꞌdiãtãsĩyã ĩri adri ẹ́ndrẹ́pị ꞌbá ídri rú rĩ pi vé ni céré. ");
INSERT INTO kbo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kúru Úpí Múngú ní lãꞌbú údézú, ĩri ní Ãdámã pi ã rụ́ꞌbá ọ̃zụ̃zú ãní ũkú ni Évã be. ");
INSERT INTO kbo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kúru Úpí Múngú ní ꞌyozú kĩnĩ, “Nóni ꞌbá ꞌdĩꞌbée ícákí sụ̃ ꞌbá tị́nị, kộpi nị̃kí tã múké pi tã ũnjí be gí. Ícókí kộpi ãꞌyĩí pẹtị ídri sẽépi rĩ nyaá ku, ãꞌdiãtãsĩyã kộpi ã adrikí rí mụzú nyonyo ku.” ");
INSERT INTO kbo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kúru Úpí Múngú ní kộpi drozú ọ́mvụ́ Ẽdénẽ vé rĩ agásĩ, kộpi ã mụkí ọ́mvụ́ ꞌãá nyọ̃ọ́kụ́ ꞌí ní ĩtĩí kộpi gbizú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Múngú kã kộpi droó fũú ọ́mvụ́ Ẽdénẽ vé rĩ agásĩ gí, ĩri ní mãlãyíkã rĩ pi ꞌbãzú ọ́mvụ́ rĩ vé wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũngárá gálé rú rĩ gé, ãzini ĩri ní ị́lị́ ãco sị́ be dị̃ị́pi lọ̃wụ̃ lọ̃wụ̃ ãcí rú ni ꞌbãzú, ĩri ẹ́cị́ ọ́mvụ́ rĩ agásĩ kụ́rụ̃, ã ũtẽ rí lẹ́tị mụụ́pi pẹtị ídri sẽépi rĩ gé rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ãdámã pi ní lazú ũkú ni Évã be, Évã ní ꞌa ị́sụ́zú, ĩri ní Káyĩnã ri tịzú. Ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú ko mâ ĩzã, á tị mvá ágó gí.” ");
INSERT INTO kbo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Vụ́drị̃ ni gé, ĩri ní Ẽbélẽ ri tịzú. Ẽbélẽ ri ꞌbá kãbĩlõ úcépi ni, Káyĩnã ri ꞌbá ọ́mvụ́ ꞌãápi ni. ");
INSERT INTO kbo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ụ́ꞌdụ́ ãlu, Káyĩnã ĩkũnã ívé ãnyãngã, íꞌdụ́ ụrụkọ ni íjị́ sẽé Úpí Múngú ní. ");
INSERT INTO kbo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ẽbélẽ íjị́ ívé rĩ kãbĩlõ mvá kãyú rĩ vé zãá úsõ be ni sẽé Úpí Múngú ní. Úpí Múngú ãꞌyĩ Ẽbélẽ ri rá, ãꞌyĩ kpá ngá ĩri ní sẽé rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ꞌBo Úpí Múngú ãꞌyĩ Káyĩnã ri kuyé, ãꞌyĩ kpá ngá ĩri ní sẽé rĩ kuyé. Sẽ Káyĩnã ã ꞌa ve ambamba, ẹndrẹtị ni adri kú ị̃trị́. ");
INSERT INTO kbo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kúru Úpí Múngú ní ꞌyozú Káyĩnã ní kĩnĩ, “Ngá mî ꞌa ní vezú rĩ ãꞌdi? Mí ẹndrẹtị adri kú ị̃trị́ ꞌdíni ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mî ꞌo dõ tã pịrị, ícókí té mi ãꞌyĩí ku? ꞌBo mí ãꞌyĩ dõ tã pịrị ꞌoó ku, ũnjĩkãnyã fi mí ẹ́sị́ agá gí, lẽ mi izaá, ꞌbo lẽ mî ndẽ ũnjĩkãnyã vé ũkpõ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Káyĩnã ní ꞌyozú ẹ́drị́pị ní kĩnĩ, “ꞌBá mụkí ẹ́cị́ be ásé agá.” Kộpi kâ mụụ́ caá ásé agá ꞌdãlé, Káyĩnã ní íꞌdózú ẹ́drị́pị Ẽbélẽ ri fụzú, ĩri ꞌdịzú drãzú rá. ");
INSERT INTO kbo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kúru Úpí Múngú ní Káyĩnã ri zịzú kĩnĩ, “Mí ẹ́drị́pị Ẽbélẽ ri íngãá?” Káyĩnã ní újázú kĩnĩ, “Á nị̃ kuyé. Mí ụ̃sụ̃ ma ꞌbá riípi má ẹ́drị́pị ri ũtẽépi ni?” ");
INSERT INTO kbo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Úpí Múngú ní ꞌyozú kĩnĩ, “Mí ꞌo ꞌdíni ãsĩ? ꞌÍ ndre drĩ ká! Mí ẹ́drị́pị vé ãrí dãápi nyọ̃ọ́kụ́ agá rĩ ngo ícá má vúgá nõó gí. ");
INSERT INTO kbo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Á tri mi gí, á dro mi fũú nyọ̃ọ́kụ́ mí ẹ́drị́pị mí ní ꞌdịị́ rĩ vé ãrí ní dãá ꞌa ni gé rĩ agásĩ ãmvé gí. ");
INSERT INTO kbo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mí kãdõ nyọ̃ọ́kụ́ rĩ ꞌãá, ãnyãngã ka mí ní ꞌa ni gé ku. Íꞌdózú ãndrũ mụzú drị̃drị̃, mi adri ꞌbẹ̃tị́ ãkó, mi ẹ́cị́ ngalanji ãngũ rĩ pi agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Káyĩnã ní ꞌyozú Úpí Múngú ní kĩnĩ, “Tã mí ní ma ĩrĩŋãzú ꞌdĩri ambamba, má ícó ãní bã ku. ");
INSERT INTO kbo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nóni ꞌí dro ma fũú nyọ̃ọ́kụ́ rĩ agásĩ gí, má ícó índré mí ẹndrẹtị gé dị̃ị́ ku, ma nóni ꞌbẹ̃tị́ ãkó, ma ẹ́cị́ mụzú ngalanji ãngũ rĩ pi agásĩ. ꞌBá rĩ ị́sụ́ dõ ma, ĩri ma ꞌdị drã rá.” ");
INSERT INTO kbo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Úpí Múngú ní ꞌyozú ĩri ní kĩnĩ, “Adri ꞌdíni kuyé, ꞌbá ãzi ꞌdị dõ mi, ma mî ãrígó ũfẽ vú be ẹ́zị̂rị̃.” Kúru Úpí Múngú ní bị́lẹ́mị ꞌbãzú Káyĩnã ã rụ́ꞌbá gá, ꞌbá ãzi ị́sụ́ dõ ĩri, ã ꞌdị rí ĩri ku. ");
INSERT INTO kbo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Káyĩnã ní kúru ngazú Úpí Múngú ã gãrã gá sĩ, ĩri ní mụzú adrizú ãngũ Nódĩ vé rĩ gé, Ẽdénẽ vé wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũngárá gálé rú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Káyĩnã pi ní lazú ũkú ni be, ũkú rĩ ní ꞌa ị́sụ́zú, ĩri ní Ẽnókã ri tịzú. Káyĩnã ní kụ̃rụ́ sịzú, ĩri ní kụ̃rụ́ rĩ ã rụ́ ꞌdazú ꞌî mvọ́pị Ẽnókã ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ẽnókã tị Ẽrádĩ ri, Ẽrádĩ tị Mẽhũjãélẽ ri, Mẽhũjãélẽ tị Mẽtũsãélẽ ri, Mẽtũsãélẽ ní Lẽmékẽ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lẽmékẽ je ũkú ị̃rị̃, ũkú kãyú rĩ ã rụ́ Ãdá ꞌi, ãzi rĩ ã rụ́ Zílã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ãdá ní Jãbálã ri tịzú. Jãbálã ri ẹ́tẹ́pị ꞌbá adriꞌbá gãkũ agá, riꞌbá ãnyãpá úcéꞌbá rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jãbálã vé ẹ́drị́pị Jũbálã ꞌi. Jũbálã ri ẹ́tẹ́pị ꞌbá riꞌbá kụ̃ꞌdị́ coꞌbá, ãzini jẽlẽgú vuꞌbá rĩ pi vé nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lẽmékẽ vé ũkú rĩ ãzi Zílã ꞌi, Zílã ní kpá mvá ágó tịzú, mváŋá rĩ ã rụ́ Tũbãlĩ-Káyĩnã ꞌi, ĩri ũndógó ngá ẹ̃zị́ ngazú rĩ pi údépi ni, ãzini riípi aya mãlámãlá, ãzini aya ẹ̃zị́ ngazú rĩ dịị́pi ni. Tũbãlĩ-Káyĩnã vé ọ́mvụ́pị ã rụ́ Nãámã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lẽmékẽ ní ꞌyozú ꞌî ũkúpị́ị ní kĩnĩ, “Ãdá, ĩmi Zílã be, ĩmi yịkí drĩ ma ká, mâ ũkúpị́ị, ĩmi yịkí mávé átángá. Kẹ̃rị́mvá ãzi ĩpẽŋã ma, á ꞌdị ĩri drãá gí. ");
INSERT INTO kbo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Dõ ũfẽkí Káyĩnã vé ãrígó vú be ẹ́zị̂rị̃, ma Lẽmékẽ ꞌi, ĩ mávé rĩ ũfẽ vú be pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni ẹ́zị̂rị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ãdámã pi ní gõzú lazú ũkú ni be dị̃ị́, ũkú rĩ ní mvá ágó tịzú, ĩri ní rụ́ ni ꞌdazú Sétẽ ꞌi, ĩri ní ꞌyozú kĩnĩ, “Múngú sẽ má ní mvá ágóŋá Ẽbélẽ Káyĩnã ní ꞌdịị́ rĩ ã ãrígó gí.” ");
INSERT INTO kbo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sétẽ ní kpá mvá ágó tịzú, ĩri ní rụ́ ni ꞌdazú Ẽnósã ꞌi. Sâ ꞌdãri gé, ꞌbá rĩ pi ní íꞌdózú Úpí Múngú ã rụ́ zịzú, ãzini ĩri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Úyú ĩ ní tã ni sĩí ꞌdĩri Ãdámã vé rĩ. Múngú kã ꞌbá ri gbií, gbi ĩri sụ̃ụ́ ꞌí tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gbi kộpi ágó pi ũkú be, sẽ kộpi ní tãkíri, ĩri ní kộpi zịzú “ꞌbá.” ");
INSERT INTO kbo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ãdámã kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na (130), ĩri ní mvá ágó tịzú sụ̃ ꞌí tị́nị. Ĩri ní rụ́ ni ꞌdazú Sétẽ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kã Sétẽ ri tịị́, vụ́drị̃ ni gé, Ãdámã gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ (800), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ãdámã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ pụ̃kụ́ na (930), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sétẽ kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu drị̃ ni tọ̃wụ́ (105), ĩri ní Ẽnósã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kã Ẽnósã ri tịị́, vụ́drị̃ ni gé, Sétẽ gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ drị̃ ni ẹ́zị̂rị̃ (807), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sétẽ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ mụdrị́ drị̃ ni ị̃rị̃ (912), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ẽnósã kã adrií caá ílí be pụ̃kụ́ úrõmĩ (90), ĩri ní Kẽnánã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kã Kẽnánã ri tịị́, vụ́drị̃ ni gé, Ẽnósã gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ mụdrị́ drị̃ ni tọ̃wụ́ (815), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ẽnósã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ drị̃ ni tọ̃wụ́ (905), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kẽnánã kã adrií caá ílí be pụ̃kụ́ ẹ́zị̂rị̃ (70), ĩri ní Mãhãlãlélĩ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kã Mãhãlãlélĩ ri tịị́, vụ́drị̃ ni gé, Kẽnánã gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ pụ̃kụ́ sụ (840), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kẽnánã kã caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ mụdrị́ (910), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mãhãlãlélĩ kã adrií caá ílí be pụ̃kụ́ ázíyá drị̃ ni tọ̃wụ́ (65), ĩri ní Yãrédẽ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kã Yãrédẽ ri tịị́, vụ́drị̃ ni gé, Mãhãlãlélĩ gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ pụ̃kụ́ na (830), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mãhãlãlélĩ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ pụ̃kụ́ úrõmĩ drị̃ ni tọ̃wụ́ (895), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yãrédẽ kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ázíyá drị̃ ni ị̃rị̃ (162), ĩri ní Ẽnókã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kã Ẽnókã ri tịị́, vụ́drị̃ ni gé, Yãrédẽ gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãrõ (800), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yãrédẽ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ pụ̃kụ́ ázíyá drị̃ ni ị̃rị̃ (962), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ẽnókã kã adrií caá ílí be pụ̃kụ́ ázíyá drị̃ ni tọ̃wụ́ (65), ĩri ní Mẽtũsélã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Kã Mẽtũsélã ri tịị́, vụ́drị̃ ni gé, Ẽnókã gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ na (300), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. Ẽnókã ri tã ꞌoó pịrị Múngú ẹndrẹtị gé, ");
INSERT INTO kbo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ẽnókã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ na pụ̃kụ́ ázíyá drị̃ ni tọ̃wụ́ (365). ");
INSERT INTO kbo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ẽnókã ní tã ꞌoó pịrị Múngú ẹndrẹtị gé rĩ sĩ, gõ índré dị̃ị́ kuyé, ãꞌdiãtãsĩyã Múngú ꞌdụ ĩri mụzú ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mẽtũsélã kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ãrõ drị̃ ni ẹ́zị̂rị̃ (187), ĩri ní Lẽmékẽ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kã Lẽmékẽ ri tịị́, vụ́drị̃ ni gé, Mẽtũsélã gõ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ẹ́zị̂rị̃ pụ̃kụ́ ãrõ drị̃ ni ị̃rị̃ (782), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mẽtũsélã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ pụ̃kụ́ ázíyá drị̃ ni úrõmĩ (969), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lẽmékẽ kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ãrõ drị̃ ni ị̃rị̃ (182), ĩri ní mvá ágó tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ĩri ní rụ́ ni ꞌdazú Núwã ꞌi, ĩri ní ꞌyozú kĩnĩ, “Mvá nõri ímụ́ ꞌbâ ĩzã ko ĩzãngã ꞌbá ní rií nyaá ẹ̃zị́ ꞌbá ní rií ngaá drị́ sĩ nyọ̃ọ́kụ́ Úpí Múngú ní trií gí nõri agá nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lẽmékẽ kã Núwã ri tịị́, vụ́drị̃ ni gé, Lẽmékẽ gõ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ tọ̃wụ́ pụ̃kụ́ úrõmĩ drị̃ ni tọ̃wụ́ (595), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lẽmékẽ adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ ẹ́zị̂rị̃ pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni ẹ́zị̂rị̃ (777), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Núwã kã adrií caá ílí be mụ̃dụ̃rụ̃lụ̃ tọ̃wụ́ (500), vụ́drị̃ ni gé, ĩri ní Sémẽ pi tịzú Ámã be, Yãpétẽ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ꞌBá rĩ pi kâ íꞌdó ízú vũ drị̃gé nõgó, kộpi tịkí anji ũkú rá. ");
INSERT INTO kbo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Anji Múngú vé rĩ pi kâ ndreé anji ũkú ꞌbá rĩ pi ní tịị́ rĩ pi ũnyĩ be ambamba, kộpi jekí ụrụkọꞌbée ĩ ní lẽé rĩ pi ĩ ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kúru Úpí Múngú ní ꞌyozú kĩnĩ, “Má ícó ꞌbá rĩ pi ãꞌyĩí adrií ídri rú mụzú nyonyo ku, ãꞌdiãtãsĩyã kộpi ꞌbá ũdrãꞌbée ũdrãdrã ni pi, kộpi ꞌyéŋá adri ílí mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ị̃rị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Anji Múngú vé rĩ pi kâ anji ũkú ꞌbá rĩ pi vé rĩ jeé, kộpi tịkí anji ũkú rĩ pi be rá. Anji kộpivé ꞌdĩꞌbée zịkí kộpi Nẽfĩlímũ, sâ ꞌdãri gé, kộpi rikí adrií vũ drị̃gé nõgó. Vụ́drị̃ ni gé, kộpi gõkí kpá adrií rá. Kộpi ẹ̃ꞌdị́ ꞌdịngárá gá ũkpõ be, kộpi ã rụ́ kụkụ. ");
INSERT INTO kbo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Úpí Múngú kã ndreé ũnjĩkãnyã ꞌbá rĩ pi vé rĩ ga vũ drị̃gé nõgó ambamba, tã kộpi ní rií ụ̃sụ̃ụ́ sâ ꞌdãri gé rĩ pi céré ũnjí, ");
INSERT INTO kbo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","tã ꞌdĩri sẽ Úpí Múngú ní ĩzãngã ambamba ꞌí ní ꞌbá gbií vũ drị̃gé nõgó rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kúru Úpí Múngú ní ꞌyozú kĩnĩ, “Vũ drị̃gé nõgó, á lẽ ꞌbá má ní gbií rĩ pi vé úri ꞌbeé ãvĩí ꞌdĩísĩ rá, íꞌdózú ꞌbá rĩ pi, ãꞌá rĩ pi, ãnyãpá rĩ pi, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi, ãríŋá rĩ pi, ma kộpivé úri ꞌbe ãvĩ ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ma ĩzãngã sĩ má ní kộpi gbií rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ꞌBo Úpí Múngú ꞌbã ẹ́sị́ múké Núwã ní. ");
INSERT INTO kbo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Úꞌdógúꞌdógú Núwã vé rĩ, ĩri ꞌdíni. Núwã ri ꞌbá tã ꞌoópi pịrị ni, ꞌbá lókí ꞌdãri gé rĩ pi ãsámvú gé, ị́sụ́kí tã ũnjí rụ́ꞌbá ni gé kuyé, Núwã ꞌdụ tã Múngú ní ꞌyoó ꞌí ní rĩ ngaá rá. ");
INSERT INTO kbo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Núwã tị anji ãgõ na, Sémẽ ꞌi, Ámã ꞌi, Yãpétẽ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tã ꞌbá rĩ pi ní ꞌoó vũ drị̃gé nõgó rĩ ũnjíkãnyãkãnyã Múngú ẹndrẹtị gé, kộpi ri tã ꞌdụ nga ẹ́sị́ ũká ũká sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Múngú ndre ũnjĩkãnyã ꞌbá rĩ pi ní ꞌoó vũ drị̃gé nõgó rĩ rá, ãꞌdiãtãsĩyã kộpi ri nóni ũnjĩkãnyã ꞌo. ");
INSERT INTO kbo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kúru Múngú ní ꞌyozú Núwã ní kĩnĩ, “Á lẽ ꞌbá rĩ pi úꞌdị́ ũdrãá céré ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ũnjĩkãnyã ga vũ drị̃gé nõgó ambamba. Ádarú á lẽ ꞌbá rĩ pi úꞌdị́ ũdrãá rá, ãzini á lẽ vũ rĩ izaá rá. ");
INSERT INTO kbo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“ꞌÍ pa párángi, mí údé mí ní kũlúmgba mọ̃ọ́ngụ́ ãní, mí aco ꞌa ni ãndíãndí, mí ũmbĩ ꞌa ni pi úgóró ni be gámũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mí údé kũlúmgba mọ̃ọ́ngụ́ rĩ ꞌdíni. Ãco ni ã adri pá ágélé mụ̃dụ̃rụ̃lụ̃ sụ pụ̃kụ́ tọ̃wụ́ (450), ẹ̃pị ni ã adri pá ágélé pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni tọ̃wụ́ (75), ngangárá ni ụrụlé rĩ ã adri pá ágélé pụ̃kụ́ sụ drị̃ ni tọ̃wụ́ (45). ");
INSERT INTO kbo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mí údé ácí ꞌbãá drị̃gé ni gé, ãsámvú ni adri mgbọ, ã ꞌbekí caá drị́ ã ꞌa na. Mí údé kẹ̃ẹ́tị kũlúmgba mọ̃ọ́ngụ́ rĩ vé wọ̃ọ́kọ̃ ãzi rĩ gé, mí aco kũlúmgba mọ̃ọ́ngụ́ rĩ ã ꞌa caá na, íꞌdózú vũgá, ágágá, ãzi rĩ ã adri ụrụgégélésĩla. ");
INSERT INTO kbo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Ma ímụ́ yị̃ị́ sẽ tị̃ nyọ̃ọ́kụ́ rĩ ẽ drị̃ ĩmũlũ céré ngá ídri be rĩ pi úꞌdị́ ũdrã ꞌdĩísĩ rá, ngá vũ drị̃gé ídri be rĩ pi céré ímụ́ ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ꞌBo ma ímụ́ ũndĩ rụ mí be, mi ímụ́ fi kũlúmgba mọ̃ọ́ngụ́ rĩ agá, ũkú mívé rĩ be, anji ãgõ mívé rĩ pi be, ũkú ĩvé rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Mi ngá ídri be rĩ pi jị kũlúmgba rĩ agá ꞌdãá, ágó ni pi ũkú ni be, kộpi ã adrikí rí ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Lẽ mî jị ãríŋá rĩ pi ị̃rị̃ ị̃rị̃ ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ãnyãpá rĩ pi be, ãꞌá rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ngá nyíríŋá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, kộpi ã mụkí rí adrií ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ꞌÍ ꞌdụ ãnyãngã nyaánya ni pi jịị́ ꞌbãá kũlúmgba agá ꞌdãlé ĩmi ní, ãzini ngá ídri be rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Núwã ꞌdụ tã rĩ pi ãrẽvú ngaá céré, sụ̃ Múngú ní lũú ꞌí ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Úpí Múngú ní ꞌyozú Núwã ní kĩnĩ, “ꞌÍ fi kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá mívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be céré, ãꞌdiãtãsĩyã á ndre mi ꞌbá tã ꞌoópi pịrị ni ꞌbá nóni adriꞌbá vũ drị̃gé rĩ pi ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ꞌÍ ꞌdụ ãnyãpá, ãzini ãꞌá ule ule rĩ pi ị̃rị̃ ị̃rị̃ caá ẹ́zị̂rị̃, ágó ni pi ũkú ni be. ꞌÍ ꞌdụ ãnyãpá, ãzini ãꞌá ãzãvũ rú rĩ pi ị̃rị̃ ị̃rị̃, ágó ni pi ũkú ni be, ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ꞌÍ ꞌdụ kpá ãríŋá rĩ pi ị̃rị̃ ị̃rị̃ caá ẹ́zị̂rị̃, ágó ni pi ũkú ni be, ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, kộpi ã adrikí rí ídri rú vũ drị̃gé nõgó. ");
INSERT INTO kbo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Íꞌdózú ãndrũ sĩ, kãdõ mụụ́ caá ụ́ꞌdụ́ ẹ́zị̂rị̃ ni gé, ma ímụ́ yị̃ị́gọ́ sẽ ꞌdị nyọ̃ọ́kụ́ drị̃gé nõgó ụ̃tụ́ŋá pụ̃kụ́ sụ, ị́nị́ŋá pụ̃kụ́ sụ, ma ngá má ní gbií ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi úꞌdị́ ũdrã céré ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Núwã ꞌdụ tã Úpí Múngú ní ẹzịị́ ꞌí ní ꞌdĩꞌbée ãrẽvú ngaá céré rá. ");
INSERT INTO kbo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Sâ yị̃ị́ rĩ ní tị̃zú vũ drị̃gé rĩ gé, ị́sụ́ Núwã vé ílí ca mụ̃dụ̃rụ̃lụ̃ ázíyá gí. ");
INSERT INTO kbo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Núwã pi ní fizú kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãlé ũkú ni be, ívé anji ãgõ rĩ pi be, anji ãgõ rĩ pi vé ũkú pi be, sụ̃ Múngú ní lũú ĩri ní rĩ tị́nị, yị̃ị́ tị̃ị́pi rĩ ẽ ĩmũlũ rí ĩ ku. ");
INSERT INTO kbo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kộpi fikí ãnyãpá, ãzini ãꞌá ule ule rĩ pi be, ãnyãpá, ãzini ãꞌá ãzãvũ rú ị̃rị̃ ị̃rị̃ rĩ pi be, ãríŋá ị̃rị̃ ị̃rị̃ rĩ pi be, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ ị̃rị̃ ị̃rị̃ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Kộpi fikí mụzú Núwã vú sĩ kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá, ágó ni pi ũkú ni be, sụ̃ Múngú ní ẹzịị́ Núwã ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ụ́ꞌdụ́ ẹ́zị̂rị̃ ã vụ́drị̃ gé, yị̃ị́ ní íꞌdózú tị̃zú nyọ̃ọ́kụ́ rĩ ẽ drị̃ ĩmũlũzú. ");
INSERT INTO kbo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Núwã vé ílí kã caá mụ̃dụ̃rụ̃lụ̃ ázíyá, mbãá ụ́ꞌdụ́ mụdrị́ drị̃ ni ẹ́zị̂rị̃, mbãá ị̃rị̃ ni gé, yị̃ị́ nyọ̃ọ́kụ́ agá rĩ íꞌdó rií íkpú ímụ́zú ãmvé nõó ũkpõ be, ãzini yị̃ị́gọ́ íꞌdó rií ꞌdịị́ ũkpõ be. ");
INSERT INTO kbo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yị̃ị́gọ́ rĩ ꞌdị ụ̃tụ́ŋá pụ̃kụ́ sụ, ị́nị́ŋá pụ̃kụ́ sụ. ");
INSERT INTO kbo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ụ́ꞌdụ́ ꞌdãri gé, ị́sụ́ Núwã pi ũkú ni be, ívé anji ãgõ Sémẽ be, Ámã be, Yãpétẽ be, ívé anji ãgõ rĩ pi vé ũkú pi be, fikí kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá gí. ");
INSERT INTO kbo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kộpi fikí ãꞌá rĩ pi be, ãnyãpá rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ãríŋá rĩ pi be ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ngá ídri be rĩ pi fikí kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá Núwã vú sĩ mụzú ị̃rị̃ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ngá ídri be rĩ pi fikí kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá, ágó ni pi ũkú ni be, ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, sụ̃ Úpí Múngú ní ẹzịị́ Núwã ní rĩ tị́nị. Múngú ní kúru kẹ̃ẹ́tị rĩ ụ̃pị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Yị̃ị́gọ́ rĩ ꞌdị caá ụ́ꞌdụ́ pụ̃kụ́ sụ, yị̃ị́ rĩ tị̃ nyọ̃ọ́kụ́ rĩ ẽ drị̃ ĩmũlũú céré. Kũlúmgba mọ̃ọ́ngụ́ rĩ nga kú yị̃ị́ rĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yị̃ị́ rĩ tị̃ nyọ̃ọ́kụ́ rĩ ẽ drị̃ ĩmũlũú ambamba, sẽ kũlúmgba mọ̃ọ́ngụ́ rĩ nga kú yị̃ị́ rĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yị̃ị́ rĩ tị̃ mụzú ambamba, ọ̃zụ̃ írã zõꞌbá ãcoco rĩ pi ẽ drị̃ céré. ");
INSERT INTO kbo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Yị̃ị́ rĩ tị̃ írã zõꞌbá ãcoco rĩ pi ẽ drị̃ ọ̃zụ̃ụ́ céré, kụngárá ni íꞌdózú írã drị̃gé ꞌdãgá, tụzú mụzú ụrụ ꞌdãá, ĩri pá ágélé pụ̃kụ́ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ngá ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi ãrẽvú céré ũdrãkí rá. Ãríŋá rĩ pi, ãnyãpá rĩ pi, ãꞌá rĩ pi, ngá nyíríŋá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi, ꞌbá rĩ pi be ũdrãkí céré. ");
INSERT INTO kbo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ngá ídri be nyọ̃ọ́kụ́ drị̃gé rĩ pi ãrẽvú ũdrãkí céré. ");
INSERT INTO kbo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Múngú ní ngá ídri be vũ drị̃gé rĩ pi úꞌdị́zú ũdrãzú céré ꞌdĩísĩ rá. Ãnyãpá rĩ pi, ãꞌá rĩ pi, ngá nyíríŋá ẹ́cị́ꞌbá vũgá sĩ rĩ pi, ãríŋá rĩ pi be, yị̃ị́ tị̃ị́pi rĩ úꞌdị́ kộpi ũdrãá céré. Núwã pi ídríkí ngá fiꞌbá kũlúmgba mọ̃ọ́ngụ́ rĩ agá rĩ pi be ꞌyéŋá nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ụ́ꞌdụ́ mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ tọ̃wụ́ ã vụ́drị̃ gé, yị̃ị́ rĩ ní íꞌdózú njụzú. ");
INSERT INTO kbo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Núwã pi ãꞌá rĩ pi be, ãnyãpá rĩ pi be kũlúmgba mọ̃ọ́ngụ́ agá ꞌdãá, Múngú ri kộpi ã tã ígá. Múngú ní ũlí sẽzú vịzú vũ drị̃gé nõgó, yị̃ị́ rĩ ní kúru njụzú. ");
INSERT INTO kbo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Múngú uga yị̃ị́ riípi íkpúpi nyọ̃ọ́kụ́ agá vũgá ꞌdãásĩ rĩ, ãzini uga yị̃ị́gọ́ riípi ꞌdịị́pi rĩ, yị̃ị́gọ́ rĩ ní ãtĩzú. ");
INSERT INTO kbo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yị̃ị́ rĩ ní njụzú mụzú vũgá ꞌdãá mãdã, ꞌdụ caá ụ́ꞌdụ́ mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kúru mbãá ụ́ꞌdụ́ mụdrị́ drị̃ ni ẹ́zị̂rị̃, mbãá ẹ́zị̂rị̃ rĩ gé, kũlúmgba mọ̃ọ́ngụ́ rĩ ní ímụ́zú pá tuzú írã Ãrãrátã drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yị̃ị́ rĩ ri njụụ́ mụzú mãdã. Mbãá mụdrị́ vé ụ́ꞌdụ́ ãlu rĩ gé, írã rĩ pi ẽ drị̃ ní ꞌbãzú índrézú. ");
INSERT INTO kbo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ụ́ꞌdụ́ pụ̃kụ́ sụ ã vụ́drị̃ gé, Núwã ní sũbâ kũlúmgba mọ̃ọ́ngụ́ rĩ vé rĩ zị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ĩri ní pụ́pụ́ ri pẽzú mụzú ãmvé ꞌdãá, pụ́pụ́ rĩ áwí rií ungaá ụrụgégé sĩ, cĩmgbá sâ yị̃ị́ rĩ ní njụzú rĩ gé. Újá ꞌi gõó Núwã vúgá ꞌdãá kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Vụ́drị̃ ni gé, ĩri ní kpá ãmámũ pẽzú, ã mụ rí ndreé dõ yị̃ị́ rĩ njụ nyọ̃ọ́kụ́ rĩ drị̃gé sĩ gí. ");
INSERT INTO kbo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ãmámũ rĩ ndã vũrã ꞌdezú ni tí, ãꞌdiãtãsĩyã yị̃ị́ rĩ ní njụụ́ dẹẹ́ kuyé rĩ sĩ. Ĩri ní ꞌi újázú gõzú Núwã vú kũlúmgba agá ꞌdãá ũzi. Núwã ní ꞌî drị́ suzú, ĩri ní ãmámũ rĩ rụzú ꞌbãzú gõzú kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãá vúlé. ");
INSERT INTO kbo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ụ́ꞌdụ́ ẹ́zị̂rị̃ ã vụ́drị̃ gé, ĩri ní kpá gõzú ãmámũ rĩ pẽzú dị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ãmámũ rĩ mvi caá Núwã vú ꞌdãá ũndré sĩ, ce ị̃bị́bị́ ụ́bụ̃rụ́ õlívẽ vé ni mụzú ꞌí tị gé ĩndĩ! Kúru Núwã ní nị̃zú ámázú ꞌyozú kínĩ, yị̃ị́ rĩ njụ nyọ̃ọ́kụ́ rĩ drị̃gé sĩ céré gí. ");
INSERT INTO kbo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Núwã tẽ caá ụ́ꞌdụ́ ẹ́zị̂rị̃, ĩri ní kpá ãmámũ rĩ pẽzú dị̃ị́, ꞌbo sâ ꞌdĩri gé, ãmámũ rĩ mvi gõó Núwã vúgá ꞌdãlé dị̃ị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Núwã vé ílí kã mụụ́ caá mụ̃dụ̃rụ̃lụ̃ ázíyá drị̃ ni ãlu, ụ́ꞌdụ́ ãlu mbãá ãlu vé rĩ gé, ị́sụ́ ãkũdẽ yị̃ị́ rĩ njụ nyọ̃ọ́kụ́ rĩ drị̃gé sĩ céré gí. Núwã ní kũlúmgba mọ̃ọ́ngụ́ rĩ ẽ drị̃ unjezú, kã mụụ́ ãngũ ndreé vũgá ꞌdãá, ị́sụ́ yị̃ị́ rĩ njụ nyọ̃ọ́kụ́ rĩ drị̃gé sĩ gí. ");
INSERT INTO kbo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mbãá ụ́ꞌdụ́ pụ̃kụ́ ị̃rị̃ drị̃ ni ẹ́zị̂rị̃, mbãá ị̃rị̃ ni gé, ị́sụ́ nyọ̃ọ́kụ́ rĩ ꞌwi dẹẹ́ gí. ");
INSERT INTO kbo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kúru Múngú ní ꞌyozú Núwã ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ĩmi ĩfũkí kũlúmgba mọ̃ọ́ngụ́ rĩ agásĩ ãmvé, ĩmi ĩfũkí mî ũkú ni be, mí ẹnjịpị́ị be, kộpivé ũkú pi be. ");
INSERT INTO kbo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ngá ídri be rĩ pi ẽ ĩfũkí ímụ́zú mí vúgá sĩ ãmvé nõó ĩndĩ, ĩvé ọ̃sụ̃kã vú sĩ ãndíãndí, ãríŋá rĩ pi, ãnyãpá rĩ pi be, ãꞌá rĩ pi be, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi be céré. Lẽ kộpi ã tịkí ízú, kộpivé kãlãfe ã ga nyọ̃ọ́kụ́ drị̃gé nõgó tré.” ");
INSERT INTO kbo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kúru Núwã pi ní ĩfũzú ũkú ni be, ẹnjịpị́ị be, ẹnjịpị́ị vé ũkú pi be, ");
INSERT INTO kbo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ãnyãpá rĩ pi be, ãꞌá rĩ pi be, ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé rĩ pi be céré, ãríŋá rĩ pi be, kộpi ĩfũkí kũlúmgba mọ̃ọ́ngụ́ rĩ agásĩ ĩvé ọ̃sụ̃kã vú sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Núwã ní kúru vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú Úpí Múngú ri ị̃njị̃zú ãní, Núwã íꞌdụ́ ãnyãpá ụrụkọ ule ule rĩ pi, ãríŋá ụrụkọ ule ule rĩ pi be, zã Úpí Múngú ní rọ̃bọ̃ŋọ̃ rú. ");
INSERT INTO kbo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Rọ̃bọ̃ŋọ̃ Núwã ní zãá ri vé ẹ̃jị́ vị caá Úpí Múngú vúgá ꞌdãá múké, sẽ ĩri ní ãyĩkõ. Ĩri ní ꞌyozú kĩnĩ, “Má ícó gõó nyọ̃ọ́kụ́ rĩ trií dị̃ị́ ku ꞌbá rĩ pi vé tã sĩ. ꞌBá nyọ̃ọ́kụ́ drị̃gé rĩ pi ã ꞌokí dõ ũnjĩkãnyã drãáãsĩyã, á gõ kộpi úꞌdị́ sụ̃ má ní kộpi úꞌdị́ drị̃drị̃ rĩ tị́nị ku. ");
INSERT INTO kbo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ílí céré vũ drị̃gé nõgó, ngá sangárá ri adri anigé, ngá ĩkũnãngárá ri adri anigé, ãngũ vé igbengárá ri adri anigé, ãngũ vé kongárá ri adri anigé, ílí ri adri anigé, ẹ̃ẹ́zụ̃ ri kpá adri anigé, ụ̃tụ́ŋá dẹ ku, ị́nị́ŋá dẹ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Múngú sẽ tãkíri Núwã pi ní ẹnjịpị́ị be kĩnĩ, “Ĩmi tịkí anji, ĩmivé kãlãfe ã ga tré vũ drị̃gé nõgó. ");
INSERT INTO kbo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ãnyãpá rĩ pi, ãꞌá rĩ pi, ãríŋá rĩ pi, ị̃ꞌbị́ rĩ pi, ngá nyíríŋá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi be céré ꞌo mí sĩ ụ̃rị̃ sĩ. Kộpi adri mî pálé gá. ");
INSERT INTO kbo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ngá ídri be ꞌdĩꞌbée ãrẽvú céré, á sẽ kộpi mí ní, ꞌí nya kộpi nyanya, sụ̃ ándúrú má ní ngá ọ́mvụ́ agá rĩ pi sẽé mí ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“ꞌBo lẽ mî nya zãá ãrí be agá rĩ ku, ãꞌdiãtãsĩyã ãrí ri ídri sẽ nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ꞌBá ãzi ꞌdị dõ ꞌbá drãá, ĩ kpá ĩri ꞌdị drã rá. Ãꞌá ꞌdị dõ ꞌbá drãá, ĩ kpá ĩri ꞌdị drã rá. ");
INSERT INTO kbo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ꞌBá ãzi ꞌdị dõ ꞌbá drãá, ĩ kpá ĩri ꞌdị drã rá, ãꞌdiãtãsĩyã Múngú gbi ꞌbá ri sụ̃ ꞌí tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mi mívé anjiŋá rĩ pi be, lẽ ĩmi tịkí anji, ĩmivé kãlãfe ã ga tré vũ drị̃gé nõgó, ĩmi írékí rí ĩmi adrií vũ drị̃gé sĩ céré.” ");
INSERT INTO kbo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Múngú ní ꞌyozú Núwã pi ní ẹnjịpị́ị be kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Á lẽ nóni ũndĩ rụụ́ mí be, ãzini mívé úyú rĩ pi be, ");
INSERT INTO kbo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ãnyãpá rĩ pi be, ãꞌá rĩ pi be, ãríŋá rĩ pi be, ngá ídri be ĩfũꞌbá mí be kũlúmgba mọ̃ọ́ngụ́ rĩ agásĩ rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ũndĩ má ní rụụ́ mí be rĩ sĩ, á gõ yị̃ị́ sẽé tị̃ị́ ngá céré ídri be rĩ pi úꞌdị́ ũdrãá dị̃ị́ ku, á gõ yị̃ị́ sẽé tị̃ị́ vũ rĩ izaá dị̃ị́ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Múngú ní ꞌyozú kĩnĩ, “Ũndĩ má ní lẽé rụụ́ mí be, ngá adriꞌbá ídri be rĩ pi be, ãzini úyú mívé rĩ pi be rĩ, ngá tã ni iꞌdaápi rĩ, ĩri adri ꞌdíni. ");
INSERT INTO kbo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Á ꞌbã gẹ́rị́ kuú ị́rị́bị́tị agá ꞌdĩ, ĩri ũndĩ má ní rụụ́ mí be rĩ vé tã iꞌda, ãzini vũ rĩ vé rĩ iꞌda. ");
INSERT INTO kbo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Má kãdõ ị́rị́bị́tị ĩpẽé vũ drị̃gé nõó, gẹ́rị́ rĩ kãdõ índré ị́rị́bị́tị agá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ma kúru ũndĩ má ní rụụ́ mí be, ãzini ngá ídri be ẹ́cị́ꞌbá nyọ̃ọ́kụ́ drị̃gé sĩ rĩ pi be rĩ vé tã ígá ãní. Yị̃ị́ gõ tị̃ị́ ngá ídri be rĩ pi úꞌdị́ ũdrãá dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Á ndre dõ gẹ́rị́ ị́rị́bị́tị agá ꞌdãá, ma ũndĩ má ní rụụ́ ngá ídri be rĩ pi be vũ drị̃gé nõgó adriípi mụzú nyonyo rĩ vé tã ígá.” ");
INSERT INTO kbo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kúru Múngú ní ꞌyozú Núwã ní kĩnĩ, “Gẹ́rị́ ꞌdĩri, ĩri ũndĩ má ní rụụ́ ngá ídri be vũ drị̃gé nõgó rĩ pi be rĩ vé tã iꞌda.” ");
INSERT INTO kbo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Núwã vé anji ãgõ rĩ pi Sémẽ ꞌi, Ámã ꞌi, Yãpétẽ sĩ, kộpi ĩfũkí céré ídri rú kũlúmgba mọ̃ọ́ngụ́ rĩ agá ꞌdãásĩ. (Ámã gõ mvá ágó tịị́, ꞌda rụ́ ni Kãnánã ꞌi.) ");
INSERT INTO kbo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Anji Núwã vé na ꞌdĩꞌbée gõkí anji tịị́ ízú ayií vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Yị̃ị́ tị̃ị́pi rĩ ã vụ́drị̃ gé, Núwã gõ ọ́mvụ́ ꞌãá, sa pẹtị vị́nyọ̃ vé rĩ pi ọ́mvụ́ rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ụ́ꞌdụ́ ãlu, Núwã mvụ vị́nyọ̃ ĩmẽrẽzú ãní ambamba, la kú ívé gãkũ agá ꞌdãá pílílí rú. ");
INSERT INTO kbo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kãnánã ẹ́tẹ́pị Ámã ndre ꞌí ẹ́tẹ́pị Núwã la kú pílílí rú, ĩri ní fũzú ãmvé ꞌdãá, lũzú ꞌí ẹ́drị́pị́ị ní. ");
INSERT INTO kbo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sémẽ pi ẹ́drị́pị Yãpétẽ be, kộpi ní bõngó íꞌdụ́zú ingazú ĩ kị́dị́ drị̃gé ụrụ, kộpi ní fizú mụzú gãkũ agá ꞌdãá úgóró sĩ, kộpi ní ĩ ẹ́tẹ́pị ã rụ́ꞌbá ọ̃zụ̃zú cí, kộpi jakí ĩ ẹndrẹtị gãrã gá, ãꞌdiãtãsĩyã ĩ ndrekí rí ĩ ẹ́tẹ́pị vé rụ́ꞌbá pílílí rú rĩ ku. ");
INSERT INTO kbo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Vị́nyọ̃ rĩ kã ãtĩí Núwã mị gé sĩ, ĩri ní tã ꞌî mvọ́pị Ámã ní ꞌoó ꞌí ní ꞌdĩri nị̃zú ámázú, ");
INSERT INTO kbo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ĩri ní ꞌyozú Ámã ní kĩnĩ, “Á tri Kãnánã ri gí! Ĩri adri tụ́gẹ̃rị̃ ã ụ̃dụ̃ ẹ́drị́pị́ị vé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ĩri ní kpá gõzú ꞌyozú kĩnĩ, “Úpí Múngú ã sẽ Sémẽ ní tãkíri! Kãnánã ã adri tụ́gẹ̃rị̃ Sémẽ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Múngú ã sẽ Yãpétẽ vé ãngũ adrizú rĩ ã adri ãmbúgú. Lẽ Yãpétẽ pi ã adrikí Sémẽ be trụ́ vũrã ãlu gé, lẽ Kãnánã ã adri tụ́gẹ̃rị̃ Yãpétẽ vé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yị̃ị́ tị̃ị́pi rĩ ã vụ́drị̃ gé, Núwã gõ adrií caá ílí mụ̃dụ̃rụ̃lụ̃ na pụ̃kụ́ tọ̃wụ́ (350). ");
INSERT INTO kbo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Núwã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ úrõmĩ pụ̃kụ́ tọ̃wụ́ (950), ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Yị̃ị́ tị̃ị́pi rĩ ã vụ́drị̃ gé, Núwã vé anji Sémẽ pi Ámã be, Yãpétẽ sĩ, kộpi gõkí anji tịị́ ízú kárákará. ");
INSERT INTO kbo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yãpétẽ vé anji rĩ pi Gõmérĩ ꞌi, Mãgógĩ ꞌi, Mãdáyĩ ꞌi, Yãvánã ꞌi, Tũbálã ꞌi, Mẽsékã ꞌi, Tĩrásã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Anji Gõmérĩ vé rĩ pi, Ãsĩkẽnázĩ pi Rĩfátã be, Tõgãrímã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Anji Yãvánã vé rĩ pi, Ẽlísã ꞌi, Tãrãsísã ꞌi, ꞌbá Kĩtímũ vé rĩ pi, ãzini ꞌbá Rõdãnímũ vé rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(ꞌBá ꞌdĩꞌbée vé úyú riꞌbá ẹ́cị́ꞌbá kũlúmgba sĩ rĩ pi, kộpi ayikí mụzú ãngũ rĩ pi agásĩ céré, ĩvé sụ́rụ́ rĩ pi vú sĩ, sụ́rụ́ ãlu ãlu rikí átá ĩvé tị sĩ.) ");
INSERT INTO kbo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Anji Ámã vé rĩ pi, Kụ́sị̃ ꞌi, Ẽjẽpétõ ꞌi, Pụ́tụ̃ ꞌi, Kãnánã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Anji Kụ́sị̃ vé rĩ pi, Sébã ꞌi, Hãvílã ꞌi, Sãbútã ꞌi, Rãámã ꞌi, Sãbĩtékã sĩ. Anji Rãámã vé rĩ pi, Sébã pi Dẽdánã be. ");
INSERT INTO kbo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kụ́sị̃ vé mvá ãzi rĩ ã rụ́ Nĩmĩródã ꞌi. Nĩmĩródã ri ũkpõ be ẹ̃ꞌdị́ ꞌdịị́pi ni vũ drị̃gé nõgó. ");
INSERT INTO kbo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ĩri ꞌbá zãá mbãápi ni Úpí Múngú ẹndrẹtị gé, sẽzú ꞌbá rĩ pi ní rizú ꞌyozú, “Mí sụ̃ Nĩmĩródã ũkpõ be riípi zãá mbãápi Múngú ẹndrẹtị gé rĩ tị́nị” ãní. ");
INSERT INTO kbo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kụ̃rụ́ drị̃drị̃ Nĩmĩródã ní íꞌdózú ívé mãlũngã rụzú rĩ, Bãbẽlónã, Ẽrékẽ, Ãkádã, ãzini Kãlánã, kụ̃rụ́ ꞌdĩꞌbée céré ãngũ Sĩnárĩ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nĩmĩródã gõ ngaá ãngũ ꞌdãri agásĩ mụụ́ Ãsírĩyã gá, ĩri ní íꞌdózú kụ̃rụ́ Nĩnéwẽ vé rĩ sịzú, Rẽhõbótĩ Írĩ vé rĩ sịzú, Kãláhã vé rĩ sịzú, ");
INSERT INTO kbo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ãzini ĩri ní kụ̃rụ́ Rẽsénĩ vé rĩ sịzú. Kụ̃rụ́ Rẽsénĩ vé rĩ, ĩri ãsámvú Nĩnéwẽ pi vé Kãláhã be rĩ gé, kụ̃rụ́ ꞌdĩri ĩri ãmbúgú. ");
INSERT INTO kbo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ẽjẽpétõ ri ẹ́ꞌbị́pị Lũdímũ rĩ pi vé ni, Ãnãmímũ rĩ pi vé ni, Lẽhãbímũ rĩ pi vé ni, Nãfãtũhímũ rĩ pi vé ni, ");
INSERT INTO kbo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pãtũrũsímũ rĩ pi vé ni, Kãsũlũhímũ rĩ pi vé ni, ãzini Kãpẽtõrímũ rĩ pi vé ni, Fẽlẽsétẽ rĩ pi íbíkí ĩfũú úyú ꞌdĩꞌbée agá. ");
INSERT INTO kbo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kãnánã ri ẹ́ꞌbị́pị Sĩdónã vé ni, Sĩdónã ri ĩrivé mvá kãyú. Kãnánã ri kpá ẹ́ꞌbị́pị Hị́tị̃ rĩ pi vé ni, ");
INSERT INTO kbo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jẽbúsĩ rĩ pi vé ni, Ãmórã rĩ pi vé ni, Gĩrĩgásĩ rĩ pi vé ni, ");
INSERT INTO kbo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hívĩ rĩ pi vé ni, Ãríkã rĩ pi vé ni, Sínã rĩ pi vé ni, ");
INSERT INTO kbo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Ãrĩvádã rĩ pi vé ni, Zẽmárã rĩ pi vé ni, Hãmátã rĩ pi vé ni. Vụ́drị̃ ni gé, úyú Kãnánã vé rĩ pi ayikí mụzú ");
INSERT INTO kbo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ãngũ Kãnánã gãrã gá rĩ pi agásĩ céré, íꞌdó Sĩdónã gá, cazú Gẽrárĩ gé, Gázã gá, Sõdómõ gá, Gõmórã gá, Ãdímã gá, Zẽbõyímũ gé, ãzini Lásã gá. ");
INSERT INTO kbo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Anji ꞌdĩꞌbée Ámã vé rĩ pi, kộpi sụ́rụ́ ĩvé rĩ pi vú sĩ, tị ĩvé rĩ pi vú sĩ, kộpi ri adri vũrã ĩvé rĩ pi gé sĩ, ãzini kộpi ri adri ãngũ ĩvé rĩ pi agásĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sémẽ mvá kãyú Yãpétẽ ẹ́drị́pị tị anji ãgõ rá, Sémẽ ri ẹ́ꞌbị́pị Ẽbérẽ rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sémẽ vé anji ãgõ rĩ pi Ẽlámã ꞌi, Ãsúrã ꞌi, Ãrĩpãkãsádã ꞌi, Lúdĩ ꞌi, Ãrámã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ãrámã vé anji ãgõ rĩ pi, Ụ́zị̃ ꞌi, Ụ́lụ̃ ꞌi, Gẽtérĩ ꞌi, Mẽsékã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ãrĩpãkãsádã ri Sélã vé ẹ́tẹ́pị, Sélã ri Ẽbérẽ vé ẹ́tẹ́pị. ");
INSERT INTO kbo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ẽbérẽ vé anji ãgõ rĩ pi ị̃rị̃, kãyú rĩ ꞌdakí rụ́ ni Pẽlégẽ ꞌi, ãꞌdiãtãsĩyã lókí Ẽbérẽ vé rĩ gé, ꞌbá rĩ pi acokí ĩ ãndíãndí ĩvé tị vú sĩ, ꞌdakí Pẽlégẽ vé ẹ́drị́pị ã rụ́ Yõkĩtánã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yõkĩtánã vé anji rĩ pi, Ãlĩmõdódã ꞌi, Sẽléfã ꞌi, Ãzãrĩmãvátã ꞌi, Jérã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ãdõrámũ ꞌi, Ũzálã ꞌi, Díkĩlã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Õbálã ꞌi, Ãbẽmãélẽ ꞌi, Sébã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Õfírĩ ꞌi, Hãvílã ꞌi, Jõbábũ ꞌi. Anji ãgõ ꞌdĩꞌbée céré Yõkĩtánã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Vũrã kộpi ní adrizú rĩ íꞌdó Mésã gá, cazú Sẽfárĩ gé, ãngũ ánga rú wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Anji ꞌdĩꞌbée Sémẽ vé rĩ pi, ĩ kộpi nị̃ ámá sụ́rụ́ ĩvé rĩ sĩ, tị ĩvé rĩ sĩ, vũrã ĩvé rĩ sĩ, ãzini ãngũ ĩvé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sụ́rụ́ ꞌdĩꞌbée ĩfũꞌbá anji Núwã vé rĩ pi ã rụ́ꞌbá gá rĩ pi, yị̃ị́ tị̃ị́pi rĩ ã vụ́drị̃ gé, kộpivé sụ́rụ́ gõ ayií mụzú ãngũ rĩ pi agásĩ, vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sâ ꞌdãri gé, ꞌbá rĩ pi céré ri átá tị ãlu ni sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ꞌBá rĩ pi ní ꞌdezú mụzú wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé, kộpi cakí ãngũ kpãkpã ni ị́sụ́ ãngũ Sĩnárĩ vé rĩ agá, kộpi áwíkí adrií ãngũ rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kộpi ní átázú ĩ ãsámvú gé sĩ kínĩ, “Lẽ ꞌbâ gbãkí bị̃rị́kị̃, ꞌbâ zãkí ãcí sĩ, ã adri rí ũkpó ũkpó.” Kộpi rikí lágáráka rĩ sịị́ bị̃rị́kị̃ sĩ, kộpi sịkí írã sĩ kuyé. Kộpi sịkí lágáráka rĩ ụ̃rụ́tẹ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kúru kộpi ní ꞌyozú kínĩ, “Ĩmi ímụ́kí ꞌbâ sị̃kí ꞌbá ní kụ̃rụ́ lágáráka be ãco caá cĩmgbá ꞌbụ̃ gé ꞌdãá, ꞌbâ rụ́ ã kụ rí ãní kụkụ, ꞌbâ írékí rí ꞌbâ mụzú vũ drị̃gé sĩ céré ku.” ");
INSERT INTO kbo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ꞌBo Úpí Múngú ní ímụ́zú vũgá nõlé kụ̃rụ́ kộpi ní rií sịị́ rĩ ndrezú lágáráka rĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Úpí Múngú ní ꞌyozú kĩnĩ, “ꞌBá nõꞌbée sụ́rụ́ ãlu, kộpi ri átá tị ãlu ni sĩ, kộpi íꞌdókí tã rĩ ngaá ꞌdĩri tị́nị, vúlé ꞌdĩgé kộpi ụ̃tị̃kí dõ tã ãzi, kộpi lẽkí dõ ꞌdụụ́ ngaá, ícó kộpi ndẽé ku. ");
INSERT INTO kbo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ĩmi ímụ́kí, ꞌbá mụkí vũgá ꞌdãlé kộpivé tị usaá, ꞌbá ãlu ãlu ã yị rí ọ́gụ́pị vé tị ku.” ");
INSERT INTO kbo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kúru Úpí Múngú ní kộpi írézú kpélékpélé vũ drị̃gé sĩ céré. Kụ̃rụ́ rĩ vé sịngárá tu pá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tã ꞌdĩri sẽ ĩ ní ãngũ rĩ ã rụ́ ꞌdazú Bãbélã ãní, ãꞌdiãtãsĩyã Úpí Múngú usa tị rĩ vũrã ꞌdãri gé, ãzini íré ꞌbá rĩ pi mụzú vũ drị̃gé sĩ vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Úyú ꞌdĩꞌbée Sémẽ vé rĩ. Yị̃ị́ tị̃ị́pi rĩ ã vụ́drị̃ kã caá ílí ị̃rị̃, ị́sụ́ ãkũdẽ Sémẽ vé ílí ca mụ̃dụ̃rụ̃lụ̃ ãlu (100), ĩri ní kúru Ãrĩpãkãsádã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sémẽ kã Ãrĩpãkãsádã ri tịị́, gõ adrií ílí mụ̃dụ̃rụ̃lụ̃ tọ̃wụ́ (500), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ãrĩpãkãsádã kã adrií caá ílí be pụ̃kụ́ na drị̃ ni tọ̃wụ́ (35), ĩri ní Sélã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ãrĩpãkãsádã kã Sélã ri tịị́, gõ adrií ílí mụ̃dụ̃rụ̃lụ̃ sụ drị̃ ni na (403), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sélã kã adrií caá ílí be pụ̃kụ́ na (30), ĩri ní Ẽbérẽ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sélã kã Ẽbérẽ ri tịị́, gõ adrií caá ílí mụ̃dụ̃rụ̃lụ̃ sụ drị̃ ni na (403), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ẽbérẽ kã adrií caá ílí be pụ̃kụ́ na drị̃ ni sụ (34), ĩri ní Pẽlégẽ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ẽbérẽ kã Pẽlégẽ ri tịị́, gõ adrií caá ílí mụ̃dụ̃rụ̃lụ̃ sụ pụ̃kụ́ na (430), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pẽlégẽ kã adrií caá ílí be pụ̃kụ́ na (30), ĩri ní Réwũ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pẽlégẽ kã Réwũ ri tịị́, gõ adrií ílí mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ drị̃ ni úrõmĩ (209), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Réwũ kã adrií caá ílí be pụ̃kụ́ na drị̃ ni ị̃rị̃ (32), ĩri ní Sẽrúgã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Réwũ kã Sẽrúgã ri tịị́, gõ adrií ílí mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ drị̃ ni ẹ́zị̂rị̃ (207), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sẽrúgã kã adrií caá ílí be pụ̃kụ́ na (30), ĩri ní Nãhórã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sẽrúgã kã Nãhórã ri tịị́, gõ adrií caá ílí mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ (200), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nãhórã kã adrií caá ílí be pụ̃kụ́ ị̃rị̃ drị̃ ni úrõmĩ (29), ĩri ní Térã ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nãhórã kã Térã ri tịị́, gõ adrií caá ílí mụ̃dụ̃rụ̃lụ̃ ãlu mụdrị́ drị̃ ni úrõmĩ (119), tị anji ãgõ ụrụkọꞌbée anji ũkú pi be ílí ꞌdĩꞌbée agá rá. ");
INSERT INTO kbo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térã kã adrií caá ílí be pụ̃kụ́ ẹ́zị̂rị̃ (70), ĩri ní Ábrãmũ pi tịzú Nãhórã be, Hãránã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Úꞌdógúꞌdógú Térã vé rĩ ꞌdíni. Térã tị Ábrãmũ pi Nãhórã be, Hãránã sĩ. Hãránã tị Lótõ ri. ");
INSERT INTO kbo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hãránã drã kụ̃rụ́ Ụ́rụ̃ vé rĩ agá, ãngũ Kãlẽdéyã vé rĩ agá, vũrã ĩ ní ĩri tịzú rĩ gé, ị́sụ́ ãkũdẽ ẹ́tẹ́pị Térã ri drĩ ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ábrãmũ pi Nãhórã be ị̃rị̃trọ́ jekí ũkú rá. Ábrãmũ vé ũkú ã rụ́ Sãráyĩ ꞌi. Nãhórã vé rĩ ã rụ́ Mĩlékã ꞌi. Mĩlékã pi Ísĩkã be, kộpi anji Hãránã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sãráyĩ adri caá úndó rú ílí be kárákará, tị mvá kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térã ní ꞌî mvọ́pị Ábrãmũ pi ꞌdụzú ꞌí ẹ́drị́pị Hãránã vé mvá Lótõ be, ꞌî mvọ́pị Ábrãmũ vé ũkú Sãráyĩ sĩ. Kộpi ngakí fũú kụ̃rụ́ Ụ́rụ̃ vé rĩ agásĩ, Ụ́rụ̃ ri ãngũ Kãlẽdéyã vé rĩ agá, kộpi lẽkí kõdô mụụ́ Kãnánã gá. ꞌBo kộpi kâ mụụ́ caá Hãránã gá, kộpi áwíkí adrií ꞌdãgá. ");
INSERT INTO kbo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Térã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ drị̃ ni tọ̃wụ́ (205), ĩri ní kúru drãzú Hãránã gá ꞌdãgá. ");
INSERT INTO kbo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Úpí Múngú ní ꞌyozú Ábrãmũ ní kĩnĩ, “ꞌÍ ku ãngũ ĩmivé rĩ, ꞌí ku máríté mívé rĩ pi, ꞌí ku ꞌbá mí ẹ́tẹ́pị vé jó ãsámvú gé rĩ pi, ꞌí mụ adrií ãngũ má ní úmvúlésĩ lẽé lũú mí ní rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ma ímụ́ sẽ mívé sụ́rụ́ ri adri ãmbúgú. Ma sẽ mi ímụ́ tãkíri ị́sụ́ rá, ma ímụ́ sẽ mî rụ́ ri kụkụ, mî tã sĩ, ma ímụ́ tãkíri sẽ ꞌbá ụrụkọꞌbée ní rá. ");
INSERT INTO kbo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ma ímụ́ tãkíri sẽ ꞌbá tãkíri sẽꞌbá mí ní rĩ pi ní, ꞌbá mi wãꞌbá rĩ pi, ma ímụ́ kộpi wã rá, ꞌbá céré vũ drị̃gé nõgó rĩ pi, ma ímụ́ kộpi ní tãkíri sẽ mî tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kúru Ábrãmũ ní ꞌdezú mụzú sụ̃ Úpí Múngú ní lũú ĩri ní rĩ tị́nị. Lótõ pi ꞌdekí mụụ́ ĩri be trụ́. Ábrãmũ ní ngazú fũzú Hãránã agásĩ rĩ gé, ị́sụ́ ãkũdẽ ĩri ílí be pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ábrãmũ jị ívé ũkú Sãráyĩ ri, ꞌí ẹ́drị́pị vé mvá Lótõ ri, ãꞌbú kộpi ní ị́sụ́ rĩ pi, tụ́gẹ̃rị̃ kộpi ní ị́sụ́ Hãránã gá ꞌdãlé rĩ pi be mụzú ĩndĩ. Kộpi ní ngazú mụzú, kộpi ní cazú ãngũ Kãnánã vé rĩ gé ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kộpi kâ mụụ́ caá Kãnánã gá ꞌdãlé, Ábrãmũ ní ẹ́cị́zú ãngũ rĩ agásĩ, ĩri ní mụzú cazú pẹtị ãmbúgú vũrã Mórẽ vé rĩ agá rĩ gé, kụ̃rụ́ Sẽkémẽ vé rĩ agá. Lókí ꞌdãri gé, ꞌbá Kãnánã vé rĩ pi ãngũ rĩ agá anigé. ");
INSERT INTO kbo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Úpí Múngú ní ꞌi iꞌdazú Ábrãmũ ní, ĩri ní ꞌyozú kĩnĩ, “Ma úmvúlésĩ ãngũ nõri sẽ mvá mívé úyú agá ni ní.” Kúru Ábrãmũ ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú Úpí ꞌi iꞌdaápi ꞌí ní rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kúru ĩri ní ꞌdezú mụzú vũrã ánga rú rĩ gé, Bẽtélẽ vé wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé, ĩri ní ívé gãkũ sịzú Bẽtélẽ pi vé ãsámvú Áyĩ be rĩ gé, Bẽtélẽ ri ụ̃tụ́ ní ꞌdengárá gálé rú, Áyĩ ri ụ̃tụ́ ní ĩfũngárá gálé rú. Ĩri ní kpá vũrã rọ̃bọ̃ŋọ̃ zãzú ní sịzú vũrã ꞌdãri gé, Úpí Múngú ri ị̃njị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kúru Ábrãmũ ní gõzú ꞌdezú mụzú ándrélé rú Nẽgévẽ gá. ");
INSERT INTO kbo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lókí ꞌdãri gé, ẹ̃bị́rị́ ꞌde ãngũ rĩ agá ũnjí ũnjí, sẽ Ábrãmũ mụ adrií tẽé ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãlé ũkõlõ. ");
INSERT INTO kbo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ábrãmũ kã caá ĩnyiŋá Ẽjẽpétõ gá ꞌdãá, ĩri ní ꞌyozú ꞌî ũkú ni Sãráyĩ ní kĩnĩ, “Á nị̃ rá mi ũnyĩ be ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ꞌBá Ẽjẽpétõ vé rĩ pi kádõ mi ndreé, kộpi ꞌyo kínĩ, mi ũkú mávé ni. Kộpi ma ꞌdị rá, kộpi mi ku adri ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ꞌÍ ꞌyo kộpi ní, mi má ọ́mvụ́pị. Mî tã sĩ, kộpi ꞌokí ma ũnjí ku, kộpi ma ku adri ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ábrãmũ pi kâ caá ꞌî ũkú ni Sãráyĩ be Ẽjẽpétõ gá ꞌdãlé, ꞌbá Ẽjẽpétõ vé rĩ pi ndrekí Sãráyĩ ri ũnyĩ be ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ꞌBãgú Ẽjẽpétõ vé rĩ vé ũgalaku rĩ pi kâ ĩri ndreé, kộpi mụkí ũlũú ꞌbãgú rĩ ní kínĩ, mvá ũkú ãzi ꞌdãáꞌdã ũnyĩ be ambamba. Kúru kộpi ní ĩri jịzú ꞌbãgú rĩ vé kání agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sãráyĩ ã tã sĩ, ꞌbãgú rĩ ꞌo Ábrãmũ ri múké, sẽ Ábrãmũ ní, kãbĩlõ, tị́, dõngí ãgõ, dõngí ũkú, ãtíꞌbá ãgõ rú ni pi, ãtíꞌbá ũkú rú ni pi be, kámĩlõ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ꞌBo Ábrãmũ ũkú ni Sãráyĩ ã tã sĩ, Úpí Múngú pẽ drã ũnjí ꞌbãgú Ẽjẽpétõ vé rĩ drị̃gé, ĩrivé ꞌbá jó ãsámvú gé rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ꞌBãgú Ẽjẽpétõ vé rĩ ní ꞌbá pẽzú mụzú Ábrãmũ ri bĩzú, ĩri ní ꞌyozú kĩnĩ, “Mí ꞌo ma ꞌdíni ãsĩ? Mí lũ má ní ꞌyozú kínĩ, Sãráyĩ ri ũkú mívé ni kuyé ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mí kĩnĩ, ‘Ĩri mívé ọ́mvụ́pị ãsĩ?’ Mí ꞌyo tã rĩ ꞌdíni, mâ ꞌdụ rí ĩri má ní ũkú rú ãní? Mívé ũkú rĩ ꞌdĩ. ꞌÍ ꞌdụ ĩri, ĩmi ꞌdekí mụụ́!” ");
INSERT INTO kbo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kúru ꞌbãgú Ẽjẽpétõ vé rĩ ní ꞌyozú ívé ãngáráwá rĩ pi ní, lẽ kộpi ã pẽkí Ábrãmũ pi ũkú ni Sãráyĩ be mụụ́ ꞌdĩísĩ rá. Ãngáráwá rĩ pi ní kộpi pẽzú mụzú ũkú ni be, ngá ĩrivé rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Kúru Ábrãmũ pi ní ngazú fũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ ũkú ni be, ngá ívé rĩ pi be, kộpi ní mụzú Nẽgévẽ gá, Lótõ pi mụkí ĩri be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ábrãmũ ri ãꞌbú be kárákará, ĩri tị́ be, kãbĩlõ be, ndrị̃ị́ be, aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni pi be, dábũ be. ");
INSERT INTO kbo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ĩri ní ngazú Nẽgévẽ gá ꞌdãásĩ, ĩri ní ẹ́cị́zú mụzú ãngũ rĩ pi agásĩ, ĩri ní cazú Bẽtélẽ gá, vũrã ĩri ní ándúrú ívé gãkũ sịzú Bẽtélẽ pi ãsámvú Áyĩ be rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Vũrã ꞌdãri ándúrú Ábrãmũ ní vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ sịzú rĩ. Ábrãmũ ní Úpí Múngú ri ị̃njị̃zú vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lótõ mụụ́pi Ábrãmũ be rĩ, ĩri kpá kãbĩlõ be, ndrị̃ị́ be, tị́ be, ꞌbá ívé ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, tụ́gẹ̃rị̃ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ꞌBo vũrã rĩ ca kộpi ní adrizú trụ́ ku, ãꞌdiãtãsĩyã kộpi ãnyãpá be ambamba, ícó kộpi ní adrizú trụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ꞌBá Ábrãmũ vé ãnyãpá úcéꞌbá rĩ pi íꞌdókí rií ãwãá ĩ ãsámvú gé sĩ Lótõ vé ꞌbá ãnyãpá úcéꞌbá rĩ pi be. Sâ ꞌdãri gé, ꞌbá Kãnánã vé rĩ pi Pẽrízĩ vé rĩ pi be ri adri ãngũ ꞌdãri agá. ");
INSERT INTO kbo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kúru Ábrãmũ ní ꞌyozú Lótõ ní kĩnĩ, “Lẽ ꞌbâ rikí ãwãá mí be ku, dõku mívé ꞌbá ãnyãpá úcéꞌbá rĩ pi ã rikí ãwãá mávé ꞌbá ãnyãpá úcéꞌbá rĩ pi be ku, ãꞌdiãtãsĩyã ꞌbâ mí be máríté. ");
INSERT INTO kbo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ãngũ rĩ ãmbúgú, adri ꞌdíni kuyé? Lẽ ꞌbâ acokí ꞌbâ adrií ãndíãndí. ꞌÍ mụ dõ drị́ ị̃jị́ gélé rú, ma mụ drị́ ẹ̃ndẹ́pị gélé rú, ꞌí mụ dõ drị́ ẹ̃ndẹ́pị gélé rú, ma mụ drị́ ị̃jị́ gélé rú.” ");
INSERT INTO kbo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lótõ ní ꞌî drị̃ ingazú ãngũ rĩ ndrezú, ndre ị́ꞌbụ́ŋá Yárídénĩ vé rĩ múké, yị̃ị́ be ambamba, sụ̃ ọ́mvụ́ Úpí Múngú vé rĩ tị́nị, sụ̃ ãngũ Ẽjẽpétõ vé mụụ́pi Zõárã gálé rú rĩ tị́nị. (Tã ꞌdĩri ꞌo ꞌi ị́sụ́ ãkũdẽ Úpí Múngú zã drĩ Sõdómõ pi Gõmórã be kuyé.) ");
INSERT INTO kbo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kúru Lótõ ní ívé rĩ ị́ꞌbụ́ŋá Yárídénĩ vé rĩ ã vúgú ĩpẽzú céré, ĩri ní ꞌdezú mụzú ụ̃tụ́ ní ĩfũngárá gálé rú. Lótõ pi ní ĩ acozú Ábrãmũ be. ");
INSERT INTO kbo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ábrãmũ áwí ívé rĩ adrií ãngũ Kãnánã vé rĩ agá, Lótõ mụ adrií ị́ꞌbụ́ŋá rĩ gé kụ̃rụ́ rĩ pi ãsámvú gé, sị gãkũ ívé rĩ pi ĩnyiŋáŋá Sõdómõ gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ꞌBá Sõdómõ vé rĩ pi ri tã ũnjí ꞌo, kộpi ri ũnjĩkãnyã ꞌo Úpí Múngú ẹndrẹtị gé ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lótõ kã mụụ́ gí, Úpí Múngú ní ꞌyozú Ábrãmũ ní kĩnĩ, “ꞌÍ ndre ãngũ ụ́rụ́lé rú, ándrélé rú, ụ̃tụ́ ní ĩfũngárá gálé rú, ãzini ụ̃tụ́ ní ꞌdengárá gálé rú. ");
INSERT INTO kbo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ãngũ mí ní ndreé ꞌdãri ã vúgú ma sẽ céré mí ní, ãzini mvá mívé úyú agá ni ní mụzú nyonyo. ");
INSERT INTO kbo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ma ímụ́ sẽ mívé úyú ri ízú tré, sụ̃ cínyáfã vũgá ꞌdĩri tị́nị, ícókí lãá bã ku. ");
INSERT INTO kbo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ꞌÍ mụ, mí ẹ́cị́ ãngũ rĩ agásĩ, ãꞌdiãtãsĩyã ma ãngũ rĩ sẽ mí ní.” ");
INSERT INTO kbo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kúru Ábrãmũ ní ívé gãkũ ꞌdụzú mụzú sịzú ĩnyiŋá pẹtị ãmbúgú Mãmúrẽ vé rĩ ã jẽlé gá, vũrã Hẽbẽrónã vé rĩ gé, ĩri ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú Úpí Múngú ri ị̃njị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sâ ꞌdãri gé, ꞌbãgú Ãmẽrãpélã Sĩnárĩ vé rĩ, ꞌbãgú Ãrĩyókĩ Ẽlẽsárã vé rĩ, ꞌbãgú Kẽdõrõlãómã Ẽlámã vé rĩ, ãzini ꞌbãgú Tĩdálã Gõyímũ vé rĩ pi ");
INSERT INTO kbo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","úmúkí ĩ ẹ̃ꞌdị́ ꞌdịị́ ꞌbãgú Bérã Sõdómõ vé rĩ be, ꞌbãgú Bĩrísã Gõmórã vé rĩ be, ꞌbãgú Sĩnábã Ãdímã vé rĩ be, ꞌbãgú Sẽmẽbérĩ Zẽbõyímũ vé rĩ be, ãzini ꞌbãgú Bélã vé rĩ be. (Bélã ri ĩ kpá zị Zõárã.) ");
INSERT INTO kbo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ꞌBãgú vúlé tọ̃wụ́ ꞌdĩꞌbée úmúkí ĩvé ãngáráwá rĩ pi mụụ́ adrií ị́ꞌbụ́ŋá Sĩdímũ vé rĩ agá (ị́ꞌbụ́ŋá ꞌdĩri ĩ nóni zị yị̃ị́ tafu ẹ̃ꞌyị́ rú ni). ");
INSERT INTO kbo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ꞌBãgú tọ̃wụ́ ꞌdĩꞌbée adrikí Kẽdõrõlãómã ã pálé gá ílí mụdrị́ drị̃ ni ị̃rị̃. ꞌBo ílí mụdrị́ drị̃ ni na ni gé, kộpi ní wazú ĩri ní ariꞌba rú. ");
INSERT INTO kbo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ílí mụdrị́ drị̃ ni sụ ni gé, Kẽdõrõlãómã pi ꞌbãgú na rĩ pi be, kộpi úmúkí ĩ mụụ́ ẹ̃ꞌdị́ ꞌdịị́ Rẽfãyímũ adriꞌbá Ãsĩtẽrótã-Kãrĩnãyímũ agá rĩ pi be, Zũzímũ adriꞌbá kụ̃rụ́ Ámã vé rĩ agá rĩ pi be, Ẽmímũ adriꞌbá Sávẽ Kĩrĩtãyímũ agá rĩ pi be, ");
INSERT INTO kbo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ãzini Hórĩ adriꞌbá ãngũ ánga rú Sẽyírĩ agá rĩ pi be, kộpi ꞌdịkí ẹ̃ꞌdị́ rĩ cĩmgbá cazú ãngũ Ẽlĩ-Pãránã gá, ĩnyiŋáŋá ãngũ ãꞌwí cínyáfã rú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kúru kộpi ní ĩ újázú gõzú vúlé, kộpi ní cazú Ẽnĩ-Mĩsĩpátã gá. (Ãngũ ꞌdĩri ĩ zị Kãdésã.) Kộpi rụkí ãngũ Ãmãlékẽ vé rĩ ã vúgú céré, kộpi ndẽkí kpá ꞌbá Ãmórã vé adriꞌbá ãngũ Hãzãzónã Tãmárã agá rĩ pi rá, kộpi rụkí ãngũ rĩ ã vúgú céré. ");
INSERT INTO kbo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kúru ꞌbãgú Sõdómõ vé rĩ, ꞌbãgú Gõmórã vé rĩ, ꞌbãgú Ãdímã vé rĩ, ꞌbãgú Zẽbõyímũ vé rĩ, ãzini ꞌbãgú Bélã vé (ĩ ní zịị́ Zõárã) rĩ sĩ, kộpi ní ꞌdezú mụzú ẹ̃ꞌdị́ ꞌdịngárá gá, kộpi mụkí ĩ tị̃ị́ ị́ꞌbụ́ŋá Sĩdímũ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kộpi lẽkí ẹ̃ꞌdị́ ꞌdịị́ ꞌbãgú Kẽdõrõlãómã Ẽlámã vé rĩ be, ꞌbãgú Tĩdálã Gõyímũ vé rĩ be, ꞌbãgú Ãmẽrãpélã Sĩnárĩ vé rĩ be, ꞌbãgú Ãrĩyókĩ Ẽlẽsárã vé rĩ be. ꞌBãgú tọ̃wụ́ rĩ pi ꞌdịkí ẹ̃ꞌdị́ ꞌbãgú sụ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ị́ꞌbụ́ŋá Sĩdímũ vé rĩ gé ꞌdãá, ꞌbụ́ ụ̃rụ́tẹ́ gazú rĩ pi kárákará. ꞌBãgú Sõdómõ vé rĩ pi Gõmórã vé rĩ be, kộpi kâ lẽé ápá, kộpivé ꞌbá ụrụkọ uꞌdekí ꞌbụ́ rĩ pi agá, ụrụkọꞌbée ápákí mụzú ãngũ ánga rú rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ꞌBãgú sụ rĩ pi uꞌdụkí ngá Sõdómõ agá rĩ pi, ãzini ngá Gõmórã agá rĩ pi ãrẽvú céré, kộpi uꞌdụkí ãnyãngã rĩ pi mụzú ĩndĩ, kộpi ní kúru ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kộpi ị́sụ́kí Ábrãmũ ẹ́drị́pị vé mvá Lótõ ri Sõdómõ agá ꞌdãlé, kộpi rụkí ĩri jịị́ mụzú ĩndĩ, ãzini kộpi uꞌdụkí ĩrivé ngá mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ágó ãzi ápápi ẹ̃ꞌdị́ gé ꞌdãásĩ rĩ ní ímụ́zú tã rĩ ũlũzú Ábrãmũ Ẽbérẽgú rĩ ní. Ábrãmũ ri adrií pẹtị ãmbúgú Mãmúrẽ Ãmórãgú rĩ vé rĩ pi ã gãrã gá. Mãmúrẽ pi ẹ́drị́pị Ẽsĩkólã be, Ãnérĩ sĩ, kộpi ũndĩ Ábrãmũ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ábrãmũ kã yịị́ kínĩ rụkí ꞌí ẹ́drị́pị vé mvá Lótõ rĩ gí, ĩri ní ãgõ mụ̃dụ̃rụ̃lụ̃ na mụdrị́ drị̃ ni ãrõ (318) ĩ ní tịị́ ĩrivé ãngá, ĩ ní ímbá múké múké ẹ̃ꞌdị́ vé tã sĩ gí rĩ pi úmúzú céré vũrã ãlu gé. Kộpi ní Kẽdõrõlãómã vé ãngáráwá rĩ pi drozú cĩmgbá cazú kụ̃rụ́ Dánã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kã mụụ́ adrií ị́nị́ŋá rĩ sĩ, Ábrãmũ ní ívé ãgõ ꞌdĩꞌbée acozú, kộpi ní íꞌdózú ẹ̃ꞌdị́ ꞌdịzú ariꞌba rĩ pi be. Kộpi drokí ariꞌba rĩ pi cĩmgbá cazú Hóbã gá, Dãmãsékẽ vé wọ̃ọ́kọ̃ ụ́rụ́lé rú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ábrãmũ íjị́ ngá ĩ ní alií rĩ pi ãrẽvú céré ĩgõó vúlé. Íjị́ ẹ́drị́pị vé mvá Lótõ ri ímụ́zú ĩndĩ, íjị́ kpá ngá ĩrivé rĩ pi, ũkú rĩ pi be, ꞌbá ụrụkọꞌbée be ímụ́zú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ábrãmũ pi kâ Kẽdõrõlãómã pi ndẽé ĩrivé ꞌbãgú rĩ pi be, ĩri ní ímvízú ĩgõzú. Kúru ꞌbãgú Sõdómõ vé rĩ ní mụzú Ábrãmũ vúgá ị́ꞌbụ́ŋá Sãvéyĩ vé rĩ agá ꞌdãá. (Ị́ꞌbụ́ŋá ꞌdĩri, ĩri ꞌbãgú rĩ vé ni.) ");
INSERT INTO kbo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kúru Mẽlẽkĩzẽdékẽ ꞌbãgú Sãlémũ vé rĩ ní pánga íjị́zú vị́nyọ̃ be sẽzú Ábrãmũ ní. Mẽlẽkĩzẽdékẽ ri átálágú Múngú ãmbúgú ꞌbá drị̃gé céré rĩ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ĩri ní tãkíri sẽzú Ábrãmũ ní, ĩri ní ꞌyozú kĩnĩ, “Múngú adriípi ãmbúgú ꞌbá drị̃gé céré ꞌbụ̃ pi gbiípi vũ be rĩ ã sẽ mí ní tãkíri. ");
INSERT INTO kbo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ẽ íngúkí Múngú adriípi ãmbúgú ꞌbá drị̃gé céré rĩ, ĩri ní sẽé mí ní ariꞌba rĩ pi ndẽé rĩ sĩ.” Ngá Ábrãmũ ní ị́sụ́ rĩ pi agá, ngá mụdrị́ agá, íꞌdụ́ ãlu ni sẽé Mẽlẽkĩzẽdékẽ ní. ");
INSERT INTO kbo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ꞌBãgú Sõdómõ vé rĩ ní ꞌyozú Ábrãmũ ní kĩnĩ, “ꞌÍ sẽ má ní ꞌbá mávé ĩ ní urụụ́ rĩ pi ĩgõó vúlé, ꞌí ꞌdụ ngá rĩ pi ãrẽvú céré mí ní.” ");
INSERT INTO kbo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ꞌBo Ábrãmũ ní újázú ꞌbãgú Sõdómõ vé rĩ ní kĩnĩ, “Á sõ ũyõ Úpí Múngú ãmbúgú ꞌbá drị̃gé céré ꞌbụ̃ pi gbiípi vũ be rĩ ẹndrẹtị gé, ");
INSERT INTO kbo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","má ícó ngá mívé rĩ ꞌdụụ́ ãluŋáni ku, kétĩ, dõku ngá pá gá ã bãákú, á ꞌdụ ãluŋáni ku, mî ꞌyo rí kínĩ, ‘Á sẽ Ábrãmũ ri adrií ãꞌbú be nĩ ꞌdíni ku.’ ");
INSERT INTO kbo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Má ãꞌyĩ ngá ãzi ãluŋáni ku. Ngá má ní ãꞌyĩí rĩ, ĩri ꞌyéŋá ãnyãngã ꞌbá mávé rĩ pi ní nyaá rĩ. ꞌBo Ãnérĩ pi Ẽsĩkólã be, Mãmúrẽ sĩ, kộpi mụkí má vúgá sĩ ĩndĩ, ngá ꞌbá ní íjị́ gõó vúlé ꞌdĩꞌbée, ꞌí sẽ kộpivé rĩ ã vúgú kộpi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Tã ꞌdĩri ã vụ́drị̃ gé, Úpí Múngú ní átázú Ábrãmũ ní urobí agá, ĩri ní ꞌyozú kĩnĩ, “Ábrãmũ, ꞌí ꞌo ụ̃rị̃ sĩ ku. Ma mi ũtẽ rá, ma mí ní ãndẽma sẽ ãmbúgú.” ");
INSERT INTO kbo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ꞌBo Ábrãmũ ní újázú ĩri ní kĩnĩ, “Úpí Múngú Ũkpõ ꞌDị́pa, sụ̃ má ní adrií mvá ãkó nõri tị́nị, ngá mí ní lẽé sẽé má ní rĩ ãꞌdi? ꞌBá úmvúlésĩ mávé ãꞌbú rụụ́pi rĩ, ĩri adri Ẽlĩzérẽ Dãmãsékẽgú rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ꞌÍ sẽ má ní anjiŋá kuyé, mávé ãtíꞌbá nõri úmvúlésĩ mávé ãꞌbú rụ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kúru Úpí Múngú ní ꞌyozú Ábrãmũ ní kĩnĩ, “Mívé ãtíꞌbá ꞌdĩri rụ úmvúlésĩ mívé ãꞌbú nĩ ku. Mi úmvúlésĩ ímụ́ mvá ágó tị rá, ĩri úmvúlésĩ mívé ãꞌbú rụ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Úpí Múngú ní Ábrãmũ ri jịzú fũzú ãmvé, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ ndre ãngũ ụrụ ꞌdãá, ꞌí lã línyã rĩ pi, mi dõ ícó kộpi lã bã rá. Mívé úyú ri ímụ́ ízú kárákará sụ̃ ꞌdĩri tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ábrãmũ ẹ̃ꞌyị̃ Úpí Múngú ri rá, Múngú ãꞌyĩ ĩri adrií ꞌbá pịrị ꞌí ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kúru Úpí Múngú ní ꞌyozú Ábrãmũ ní kĩnĩ, “Ma Úpí Múngú ꞌi, má íjị́ mi ĩfũú Ụ́rụ̃ agá ꞌdãásĩ, íngázú ãngũ Kãlẽdéyã vé rĩ agá, ma ãngũ nõri sẽ mí ní, ĩri adri mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ꞌBo Ábrãmũ ní ꞌyozú kĩnĩ, “Úpí Múngú, ma ícó nị̃ ngóni ꞌyozú kínĩ, ãngũ rĩ adri mávé ni?” ");
INSERT INTO kbo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Úpí Múngú ní ꞌyozú ĩri ní kĩnĩ, “Mí íjị́ má ní tị́ ũkú, ndrị̃ị́ ũkú, ãzini kãbĩlõ ágó céré ílí be na na ni pi, ãmámũ ãzini ũꞌbõlõgú adriípi cõrõ ni.” ");
INSERT INTO kbo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ábrãmũ ní ãnyãpá rĩ pi íjị́zú Múngú ní, ĩri ní kộpi ã ꞌa ãsĩzú céré ị̃rị̃ ị̃rị̃, ĩri ní kộpi ũꞌbãzú vũgá ꞌdĩgé ílébe ílébe, ãsĩ ãríŋá rĩ pi ã ꞌa kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Lógúnũ rĩ pi ní uꞌdezú zãá rĩ pi drị̃gé, ꞌbo Ábrãmũ údró kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ụ̃tụ́ rĩ kã rií ꞌdeé, Ábrãmũ ní ụ́ꞌdụ́ kozú kpílíkpílí, ãngũ rĩ bĩ nịị́ kuú cịcị Ábrãmũ ã gãrã gá sĩ, sẽ ĩri ní ụ̃rị̃ ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Úpí Múngú ní ꞌyozú Ábrãmũ ní kĩnĩ, “Lẽ mî nị̃ múké ꞌyozú kínĩ, úyú mívé rĩ pi úmvúlésĩ mụ adri jãkã rú ãngũ ãzi gé, kộpi adri tụ́gẹ̃rị̃ rú, ĩ kộpi ọ̃cụ̃ ca ílí mụ̃dụ̃rụ̃lụ̃ sụ. ");
INSERT INTO kbo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ꞌBo ma ímụ́ ꞌbá ãngũ rĩ agá kộpi ꞌbãꞌbée ẹ̃zị́ ngaꞌbá tụ́gẹ̃rị̃ rú rĩ pi ĩrĩŋã rá. Vụ́drị̃ ni gé, kộpi úmvúlésĩ ĩfũ ãngũ rĩ agásĩ ngá be ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ꞌBo mi úmvúlésĩ ímụ́ adri ílí be ãco, mi ímụ́ drã tã be kíri, ị́sụ́ ãkũdẽ mi ãrãkã rú, ĩ kúru mi sị̃. ");
INSERT INTO kbo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ĩri adri ca úyú sụ, vụ́drị̃ ni gé, úyú mívé rĩ pi úmvúlésĩ ĩgõ ímụ́ ãngũ nõri rụ nĩ, ãꞌdiãtãsĩyã sâ ꞌdãri gé, ị́sụ́ ꞌbá Ãmórã vé rĩ pi vé ũnjĩkãnyã ga ambamba, ma kộpi ĩrĩŋã úyú mívé rĩ pi ã tã sĩ, ma kộpivé ãngũ sẽ úyú mívé rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ụ̃tụ́ rĩ kã ꞌdeé gí, ãngũ rĩ kã nịị́, ãcígã ní ngazú vũrã ĩ ní ãcí ũdẽzú rĩ gé sĩ, ãzini ãcí ní dị̃zú ãngũ ĩmgbẽrẽzú, ẹlịzú mụzú zãá ĩ ní ũꞌbãá ílébe ílébe ꞌdĩꞌbée ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ụ́ꞌdụ́ ꞌdãri gé, Úpí Múngú ní ũndĩ rụzú Ábrãmũ be, ĩri ní ꞌyozú kĩnĩ, “Á sẽ ãngũ nõri úyú mívé rĩ pi ní, íꞌdózú yị̃ị́ Ẽjẽpétõ vé rĩ gé, cazú yị̃ị́ ãmbúgú dịị́pi dịdị Yũfẽrétã vé rĩ gé, ");
INSERT INTO kbo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ãngũ Kénĩ rĩ pi vé rĩ, ãngũ Kénĩzĩ rĩ pi vé rĩ, ãngũ Kãdĩmónĩ rĩ pi vé rĩ, ");
INSERT INTO kbo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ãngũ Hị́tị̃ rĩ pi vé rĩ, ãngũ Pẽrízĩ rĩ pi vé rĩ, ãngũ Rẽfãyímũ rĩ pi vé rĩ, ");
INSERT INTO kbo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ãngũ Ãmórã rĩ pi vé rĩ, ãngũ Kãnánã rĩ pi vé rĩ, ãngũ Gĩrĩgásĩ rĩ pi vé rĩ, ãngũ Jẽbúsĩ rĩ pi vé rĩ, á sẽ kộpi céré úyú mívé rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ábrãmũ ũkú ni Sãráyĩ tị ĩri ní anji kuyé. ꞌBo Sãráyĩ ri ãtíꞌbá be Ẽjẽpétõzị́, rụ́ ni Ãgárã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kúru Sãráyĩ ní ꞌyozú Ábrãmũ ní kĩnĩ, “Úpí Múngú uga má ní mvá tịngárá sĩ. ꞌÍ mụ laá ãtíꞌbázị́ mávé rĩ be, sâ ãzi sĩ, ĩri ícó mvá tị rá, mvá rĩ adri mávé ni.” Ábrãmũ ãꞌyĩ tã Sãráyĩ ní ꞌyoó rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ábrãmũ kã adrií Kãnánã gá ꞌdãá caá ílí mụdrị́, ũkú ni Sãráyĩ ní ívé ãtíꞌbá Ãgárã ri sẽzú ĩri ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ábrãmũ pi ní lazú Ãgárã be, Ãgárã ní ꞌa ị́sụ́zú. Ãgárã kã nị̃ị́ ámá ꞌi ꞌa be gí, ĩri ní íꞌdózú Sãráyĩ ri idezú. ");
INSERT INTO kbo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kúru Sãráyĩ ní ꞌyozú Ábrãmũ ní kĩnĩ, “Tã má ní rizú ĩzãngã nyazú nõri, tã ni ã adri mí drị̃gé. Á sẽ mávé ãtíꞌbá mí ní ũkú rú, ꞌbo nóni kã nị̃ị́ ámá ꞌi ꞌa be gí, ĩri nóni ri ma idede. Lẽ Úpí Múngú ã aco ꞌbávé tã ãsámvú mí be nĩ, ãꞌdi ri dõ ũnjí nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ábrãmũ ní ꞌyozú kĩnĩ, “Ãgárã ri mívé ãtíꞌbá, ꞌí ꞌo tã mí ní lẽé ꞌoó ĩri ní rĩ.” Kúru Sãráyĩ ní íꞌdózú Ãgárã ri ꞌozú ũnjí. Ãgárã ní ngazú ápázú mụzú ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mãlãyíkã Úpí Múngú vé rĩ ị́sụ́ Ãgárã ri ĩnyiŋá kídí adriípi ãngũ ãꞌwí cínyáfã rú rĩ agá rĩ ã gãrã gá. Kídí rĩ lẹ́tị mụụ́pi Sụ́rụ̃ gé rĩ ã jẽlé gá. ");
INSERT INTO kbo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mãlãyíkã rĩ ní ꞌyozú kĩnĩ, “Ãgárã, Sãráyĩ vé ãtíꞌbá, mí ímụ́ íngõósĩla, mi ri mụ ngõlé?” Ãgárã ní újázú ĩri ní kĩnĩ, “Má íbí ápá ímụ́ mávé ãmbúgú Sãráyĩ vúgálésĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kúru mãlãyíkã Úpí Múngú vé rĩ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ gõ mívé ãmbúgú rĩ vúgá ꞌdãlé vúlé, ꞌí mụ mi ꞌbãá vũgá ĩri ã pálé gá.” ");
INSERT INTO kbo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mãlãyíkã rĩ ní gõzú ꞌyozú ĩri ní kĩnĩ, “Ma sẽ mívé úyú ízú kárákará, ícókí lãá bã ku.” ");
INSERT INTO kbo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mãlãyíkã Úpí Múngú vé rĩ ní kpá ꞌyozú ĩri ní kĩnĩ, “Mi nóni ꞌa be, mi ímụ́ mvá ágó tị rá, mi rụ́ ni ꞌda Ĩsĩmãélẽ ꞌi, ãꞌdiãtãsĩyã Úpí Múngú yị mívé ngongárá ĩzãngã ĩzãngã rú rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mívé mvá ꞌdĩri, ĩri adri sụ̃ dõngí ásé agá ọ̃jọ́gọ́ ọ̃jọ́gọ́ rĩ tị́nị, ĩri ꞌbá rĩ pi fụfụ, ꞌbá rĩ pi kpá ĩri fụfụ, ĩrivé ẹ́sị́ ri adri ũká ũká ívé máríté rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ãgárã kĩnĩ “Á ndre nóni Úpí Múngú riípi mâ tã mbaápi rĩ gí.” Ĩri ní Múngú átápi ꞌí ní rĩ vé rụ́ ꞌdazú, “Múngú riípi ma ndreépi rĩ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ꞌBá rĩ pi ní kídí rĩ ã rụ́ ꞌdazú Bẽrẽ Lãyĩ Róyĩ ãní, kídí ꞌdĩri anigé Kãdésã pi vé ãsámvú Bẽrédĩ be rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kúru Ãgárã ní Ábrãmũ ní mvá ágó tịzú, Ábrãmũ ní mváŋá rĩ ã rụ́ ꞌdazú Ĩsĩmãélẽ. ");
INSERT INTO kbo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ãgárã ní Ábrãmũ ní mvá ágó Ĩsĩmãélẽ ri tịzú rĩ gé, ị́sụ́ ãkũdẽ Ábrãmũ vé ílí ca pụ̃kụ́ ãrõ drị̃ ni ázíyá. ");
INSERT INTO kbo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ábrãmũ vé ílí kã caá pụ̃kụ́ úrõmĩ drị̃ ni úrõmĩ, Úpí Múngú ní ꞌi iꞌdazú ĩri ní, ĩri ní ꞌyozú kĩnĩ, “Ma Múngú Ũkpõ ꞌDị́pa ꞌi. Lẽ mî ꞌdụ mávé tã ngaá, mî ꞌo tã pịrị. ");
INSERT INTO kbo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma ũndĩ rụ mí be, mi anji tị ízú kárákará.” ");
INSERT INTO kbo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ábrãmũ ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá, Múngú ri ị̃njị̃zú. Múngú ní ꞌyozú ĩri ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ũndĩ má ní lẽé rụụ́ mí be rĩ, ĩri ꞌdíni, ma sẽ mi adri ẹ́tẹ́pị sụ́rụ́ kárákará pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mívé rụ́ gõkí zịị́ Ábrãmũ ku, ĩ gõ zị Ãbũrámã, ãꞌdiãtãsĩyã á ꞌbã mi adrií ẹ́tẹ́pị sụ́rụ́ kárákará pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ma sẽ mi anji tị ízú kárákará, mi adri sụ́rụ́ be kárákará, ꞌbãgú rĩ pi kpá ímụ́ ĩfũ mî rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Ma sẽ ũndĩ má ní rụụ́ mí be rĩ adri mụzú nyonyo, cazú úyú mî vụ́drị̃ gé rĩ pi vúgá, cĩmgbá cazú úyú kộpivé rĩ pi vúgá. Ma adri Múngú mívé ni, ãzini Múngú úyú mî vụ́drị̃ gé rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nyọ̃ọ́kụ́ Kãnánã vé mí ní nóni adrizú ꞌa ni gé jãkã rú nõri, ma ímụ́ sẽ céré ĩmi ní mívé úyú mî vụ́drị̃ gé rĩ pi be mụzú nyonyo, ma adri Múngú kộpivé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kúru Múngú ní ꞌyozú Ãbũrámã ní kĩnĩ, “Mi mívé úyú mî vụ́drị̃ gé rĩ pi be, lẽ ĩmi ꞌdụkí ũndĩ má ní rụụ́ mí be ꞌdĩri vé tã ngaánga. ");
INSERT INTO kbo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ũndĩ má ní rụụ́ mí be, ãzini mívé úyú mî vụ́drị̃ gé rĩ pi be, má ní ꞌyoó ĩmi ꞌdụkí tã ni ngaánga rĩ, ĩri ꞌdíni, ãgõ ĩmi ãsámvú gé rĩ pi ãrẽvú céré, lẽ ã úlị́kí kộpi ã ágélé ẽ tị rá. ");
INSERT INTO kbo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Lẽ ã úlị́kí ĩmî ágélé ẽ tị rá, ĩri ũndĩ má ní rụụ́ mí be rĩ vé tã iꞌda. ");
INSERT INTO kbo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Anji ãgõ úmvúlésĩ ĩ ní ímụ́ tịị́ úyú vúlé ꞌdĩlé rĩ gé rĩ pi, mváŋá rĩ ca dõ ụ́ꞌdụ́ be ãrõ gí, lẽ ã lịkí ágélé ni ẽ tị rá. Lẽ ã úlị́kí kpá ãnji ãgõ ĩ ní tịị́ mívé ꞌbẹ̃tị́ ãsámvú gé rĩ pi ã ágélé ẽ tị rá, ãzini ã úlị́kí ãgõ ĩ ní jeé mũfẽngã sĩ jãkã rĩ pi drị́gé rĩ pi ã ágélé ẽ tị rá. ");
INSERT INTO kbo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dõ tịkí anji ãgõ ĩmivé ꞌbẹ̃tị́ ãsámvú gé yã, dõku jekí mũfẽngã sĩ yã, lẽ ã úlị́kí kộpi ã ágélé ẽ tị rá. Ũndĩ má ní rụụ́ ágélé ẽ tị lịzú ꞌdĩri, ĩri lũ ꞌyozú kínĩ, ũndĩ ꞌdĩri adri mụzú nyonyo. ");
INSERT INTO kbo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ꞌBá ágó ĩ ní ágélé ni ẽ tị lịị́ kuyé rĩ, ĩ ĩri gụ̃ ãmvé mávé ꞌbá rĩ pi ãsámvú gé sĩ, ãꞌdiãtãsĩyã ŋõ ũndĩ má ní rụụ́ rĩ vé tã gí.” ");
INSERT INTO kbo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Múngú ní kpá ꞌyozú Ãbũrámã ní kĩnĩ, “Mívé ũkú Sãráyĩ ri, lẽ mî zị ĩrivé rụ́ Sãráyĩ ku, mî zị ĩrivé rụ́ Sárã. ");
INSERT INTO kbo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ma ĩri ní tãkíri sẽ, ĩri mí ní mvá ágó tị rá. Ma ĩri ní tãkíri sẽ, ĩri ímụ́ adri ẹ́ndrẹ́pị sụ́rụ́ kárákará rĩ pi vé ni. ꞌBãgú rĩ pi kpá ímụ́ ĩfũ ĩrivé úyú agá.” ");
INSERT INTO kbo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ãbũrámã ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá Múngú ri ị̃njị̃zú. Ĩri ní gụzú, ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãlé kĩnĩ, “ꞌBá ágó ílí be caápi mụ̃dụ̃rụ̃lụ̃ ãlu ní nyo ícó mvá tị rá? Sárã vé ílí ca pụ̃kụ́ úrõmĩ, ĩri nyo ícó mvá tị rá?” ");
INSERT INTO kbo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ãbũrámã ní ꞌyozú Múngú ní kĩnĩ, “Mî sẽ dõ tãkíri rĩ ꞌyéŋá Ĩsĩmãélẽ ní, ĩri adri múké.” ");
INSERT INTO kbo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kúru Múngú ní ꞌyozú kĩnĩ, “Adri ꞌdíni kuyé, mívé ũkú Sárã ri ímụ́ mí ní mvá ágó tị rá, mi rụ́ ni ꞌda Ĩsákã ꞌi. Ũndĩ má ní rụụ́ rĩ adri Ĩsákã be mụzú nyonyo, ĩri ca úyú Ĩsákã ã vụ́drị̃ gé rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Á yị tã mí ní zịị́ Ĩsĩmãélẽ ã tã sĩ rĩ gí, ma ĩri ní tãkíri sẽ rá. Ma sẽ ĩri anji tị ízú kárákará. Ĩri adri ẹ́tẹ́pị anji mụdrị́ drị̃ ni ị̃rị̃ ãngũ rụꞌbá rĩ pi vé ni, ma sẽ ĩri adri sụ́rụ́ be kárákará. ");
INSERT INTO kbo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ũndĩ má ní rụụ́ mí be rĩ, ma kpá rụ Ĩsákã Sárã ní úmvúlésĩ ímụ́ tịị́ mí ní rĩ be. Ĩri ímụ́ tị sâ ãndrũ nõri tị́nị rĩ gé, ílí drụ̃ rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Múngú kã átángá rĩ átá dẹẹ́ Ãbũrámã ní gí, ĩri ní Ãbũrámã ri kuzú, ĩri ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ụ́ꞌdụ́ ꞌdãri gé, Ãbũrámã ní ívé mvá ágó Ĩsĩmãélẽ ri ꞌdụzú, ãgõ ĩ ní tịị́ ívé ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, ãzini ꞌbá ꞌí ní jeé mũfẽngã sĩ rĩ pi be, ĩri ní kộpivé ágélé ẽ tị úlị́zú rá, sụ̃ Múngú ní ꞌyoó ꞌí ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ĩ ní Ãbũrámã ã ágélé ẽ tị lịzú rĩ gé, ị́sụ́ ãkũdẽ ĩrivé ílí ca pụ̃kụ́ úrõmĩ drị̃ ni úrõmĩ, ");
INSERT INTO kbo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","mvọ́pị Ĩsĩmãélẽ vé ílí ca mụdrị́ drị̃ ni na. ");
INSERT INTO kbo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ãbũrámã pi mvọ́pị Ĩsĩmãélẽ be, úlị́kí kộpi ã ágélé ẽ tị ụ́ꞌdụ́ ãlu ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ãgõ Ãbũrámã vé ꞌbẹ̃tị́ ãsámvú gé rĩ pi, ãgõ ĩ ní tịị́ ĩrivé ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, dõku ĩ ní jeé mũfẽngã sĩ jãkã rĩ pi drị́gé rĩ pi be, kộpi ãrẽvú céré, úlị́kí kộpi ã ágélé ẽ tị Ãbũrámã pi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Úpí Múngú iꞌda ꞌi Ãbũrámã ní pẹtị ãmbúgú Mãmúrẽ vé rĩ ã jẽlé gá, ị́sụ́ ãkũdẽ Ãbũrámã úrí kuú ívé gãkũ rĩ vé kẹ̃ẹ́tịlé gá ụ̃tụ́ mgbímgbi gé ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ãbũrámã kã ꞌî drị̃ ingaá ãngũ ndrezú, ndre ãgõ na tukí pá kuú ꞌí ẹndrẹtị gé. Kã kộpi ndreé, koro ĩri ní njuzú mụzú kộpi vúgá ꞌdãá, ĩri ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá kộpi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ĩri ní ꞌyozú kĩnĩ, “Ãmbúgú mávé rĩ, ꞌí ndre dõ tã má ní ꞌoó rĩ sẽ mí ní ãyĩkõ rá, ma ãtíꞌbá mívé ni, lẽ mî aga má gãrã gá sĩ ku. ");
INSERT INTO kbo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Lẽ ĩmi uvukí pẹtị nõri ã ndụ́gé nõgó, ẽ íjị́kí ĩmi ní yị̃ị́, ĩmi ũjĩkí rí ĩmi pá ãní. ");
INSERT INTO kbo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mâ áꞌdí ĩmi ní ínyá, ĩmi nyakí rí, ã sẽ rí ĩmi ní ũkpõ, ĩmi tukí rí ẹ̃cị̃ rĩ mụzú ãní, ãꞌdiãtãsĩyã ĩmi ícákí ãtíꞌbá ĩmivé rĩ vúgá gí.” Kộpi ní ꞌyozú kínĩ, “Múké, ꞌbá ãꞌyĩkí rá, mî ꞌo sụ̃ mí ní ꞌyoó rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ãbũrámã ní njuzú fizú gãkũ agá Sárã vúgá ꞌdãlé. Ĩri ní ꞌyozú Sárã ní kĩnĩ, “Mí íꞌdụ́ jũrú, mí ĩyĩ fúndru mĩnímíni ni ꞌa ni gé mbẽlẽ, mí únjó fúndru rĩ, ꞌí ꞌbã áꞌdí pánga rú.” ");
INSERT INTO kbo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kúru Ãbũrámã ní njuzú mụzú tị́ rĩ pi ãsámvú gé ꞌdãá, ĩri ní tị́ kãjóŋá rụ́ꞌbá be múké ni ĩpẽzú, ĩri ní sẽzú ívé ãtíꞌbá rĩ drị́gé, ãtíꞌbá rĩ ní lịzú, ĩri ní ꞌbãzú áꞌdízú mbẽlẽŋá. ");
INSERT INTO kbo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kâ ínyá rĩ áꞌdí dẹẹ́ gí, Ãbũrámã ní lé kũúpi gí ni íꞌdụ́zú lé ĩ ní zoó úꞌdí rú ni be, ãzini ĩri ní tị́ zãá áꞌdípi gí rĩ íꞌdụ́zú, ĩri ní jịzú ꞌbãzú ụ̃mụ́ rĩ pi ẹndrẹtị gé. Kộpi kâ rií ínyá rĩ nyaá, Ãbũrámã áwí pá tuú kuú kộpi ã jẽlé gá pẹtị ã ndụ́gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ụ̃mụ́ rĩ pi ní Ãbũrámã ri zịzú kínĩ, “Mî ũkú ni Sárã ri íngãá?” Ãbũrámã ní újázú kĩnĩ, “Ĩri gãkũ agá ꞌdãáꞌdã.” ");
INSERT INTO kbo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kúru Úpí ní ꞌyozú kĩnĩ, “Ílí drụ̃ rĩ agá, ma ĩgõ mí vúgá nõlé sâ má ní ícázú mí vúgá ãndrũ nõri tị́nị rĩ gé, mî ũkú ni Sárã ri ímụ́ mvá ágó tị rá.” Sárã ri átángá rĩ yịị́ gãkũ Ãbũrámã úgóró gá rĩ vé kẹ̃ẹ́tịlé gá. ");
INSERT INTO kbo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ãbũrámã pi Sárã be ị̃rị̃trọ́ ãrãkã rú, kộpivé ílí ãmbúgú, Sárã vé ílí mvá tịzú rĩ aga gí. ");
INSERT INTO kbo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sárã ní gụzú, ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãá kĩnĩ, “Á dẽ gí, má ágó ni dẽ kpá gí, ma nyo gõ mvá tị ãyĩkõ ị́sụ́zú rá?” ");
INSERT INTO kbo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kúru Úpí Múngú ní ꞌyozú Ãbũrámã ní kĩnĩ, “Sárã gụgụ ãsĩ? Sárã kĩnĩ, ꞌí dẽ gí, ꞌi nyo ícó mvá tị rá yã, ꞌyo ꞌdíni ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ngá ãzi ũkpó ũkpó Úpí Múngú ri ndẽépi ni nyo anigé? Ma ímụ́ ĩgõ sâ nõri tị́nị rĩ gé, ílí drụ̃ rĩ agá, Sárã ri ímụ́ mvá ágó tị rá.” ");
INSERT INTO kbo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sárã ꞌo ụ̃rị̃ sĩ, ụ́lị́ ũnjõ kĩnĩ, “Á gụ kuyé.” Úpí Múngú kĩnĩ, “Ádarú, ꞌí gụ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ãgõ na rĩ pi kâ lẽé ꞌdeé mụzú, kộpi rikí ãngũ ndreé mụzú Sõdómõ gálé rú. Ãbũrámã mụ kộpi be trụ́, jị kộpi kuú lẹ́tị gé. ");
INSERT INTO kbo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kúru Úpí Múngú ní ꞌyozú kĩnĩ, “Má ícó tã má ní lẽé ꞌoó rĩ úcí Ãbũrámã ní ku. ");
INSERT INTO kbo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ãbũrámã vé úyú ri ímụ́ ízú tré, kộpi adri ũkpõ be ãngũ rĩ agá, sụ́rụ́ ãngũ rĩ pi agásĩ rĩ pi ãrẽvú céré tãkíri ị́sụ́ ĩri ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ãꞌdiãtãsĩyã má ĩpẽ ĩri, ẽ ímbá rí ívé anji rĩ pi ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, kộpi ã ꞌdụkí rí tã Úpí Múngú vé rĩ ngaá, kộpi ã ꞌokí rí tã pịrị, ãzini kộpi ã ꞌokí rí tã múké. Kúru ma sẽ Ãbũrámã vé úyú ri ízú tré, sụ̃ má ní ẹzịị́ rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kúru Úpí Múngú ní ꞌyozú Ãbũrámã ní kĩnĩ, “Ũnjĩkãnyã ꞌbá Sõdómõ vé rĩ pi ní ꞌoó, ãzini Gõmórã vé rĩ pi ní ꞌoó rĩ vé tã íkụ́ ícá má vúgá nõlé gí, kộpi vé ũnjĩkãnyã ꞌoó rĩ aga rá. ");
INSERT INTO kbo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Á lẽ sịị́ mụụ́ vũgá ꞌdãá, á lẽ mụụ́ ndreé, dõ ũnjĩkãnyã kộpi ní ꞌoó rĩ, ĩri adri sụ̃ íkụ́pi ícápi má vúgá nõlé rĩ tị́nị. Dõ adri ꞌdíni kuyé, á lẽ nị̃ị́.” ");
INSERT INTO kbo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kúru ãgõ ị̃rị̃ rĩ pi ní ꞌdezú mụzú Sõdómõ gá ꞌdãá, ꞌbo Ãbũrámã pi áwíkí pá tuú kuú Úpí Múngú be. ");
INSERT INTO kbo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ãbũrámã ní ꞌi útrúzú Úpí Múngú vúgá ꞌdãá, ĩri ní Úpí Múngú ri zịzú kĩnĩ, “Úpí, mi dõ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi úꞌdị́, mi nyo ꞌbá tã ꞌoꞌbá pịrị rĩ pi úꞌdị́ ĩndĩ rá? ");
INSERT INTO kbo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Dõ ꞌbá tã ꞌoꞌbá pịrị ni pi pụ̃kụ́ tọ̃wụ́ kụ̃rụ́ rĩ agá ꞌdãlé, mi nyo kụ̃rụ́ rĩ iza céré? Mí ícó kụ̃rụ́ rĩ kuú ꞌbá pụ̃kụ́ tọ̃wụ́ tã ꞌoꞌbá pịrị ꞌdĩꞌbée ã tã sĩ ku? ");
INSERT INTO kbo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ádarú lẽ mî úꞌdị́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ ku. Ngá mí ní lẽzú ꞌbá tã ꞌoꞌbá pịrị rĩ pi úꞌdị́zú ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ rĩ ãꞌdi? Lẽ mî ꞌo ꞌdíni ku! Mi ri ꞌbá vũ drị̃gé nõgó rĩ pi vé tã lị nĩ, mi ri tã lị pịrị.” ");
INSERT INTO kbo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Úpí Múngú ní ꞌyozú kĩnĩ, “Má ị́sụ́ dõ ꞌbá tã ꞌoꞌbá pịrị rĩ pi pụ̃kụ́ tọ̃wụ́ kụ̃rụ́ Sõdómõ vé rĩ agá ꞌdãlé rá, má iza kụ̃rụ́ rĩ ku kộpi ã tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ãbũrámã ní gõzú átázú dị̃ị́ kĩnĩ, “Úpí Múngú, mâ adri dõ ꞌbá áda drãápi drãdrã ni drãáãsĩyã, lẽ mî ãꞌyĩ ma, mâ átá átángá rĩ mụzú. ");
INSERT INTO kbo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ꞌBo dõ ꞌbá tã ꞌoꞌbá pịrị rĩ pi pụ̃kụ́ sụ drị̃ ni tọ̃wụ́, cakí pụ̃kụ́ tọ̃wụ́ kuyé, mi nyo kụ̃rụ́ rĩ iza ꞌbá tọ̃wụ́ ꞌdãáyo rĩ pi ã tã sĩ rá?” Úpí Múngú ní ꞌyozú kĩnĩ, “Dõ má ị́sụ́ ꞌbá rĩ pi ꞌdãlé pụ̃kụ́ sụ drị̃ ni tọ̃wụ́, má iza kụ̃rụ́ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ãbũrámã ní gõzú átázú dị̃ị́ kĩnĩ, “Dõ mí ị́sụ́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi ꞌyéŋá pụ̃kụ́ sụ, mi nyo iza rá?” Úpí Múngú ní ꞌyozú kĩnĩ, “Dõ ꞌbá tã ꞌoꞌbá pịrị rĩ pi pụ̃kụ́ sụ, má iza kụ̃rụ́ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ãbũrámã ní ꞌyozú kĩnĩ, “Úpí Múngú, mî ꞌa ã ve má ní ku fô, lẽ mî ãꞌyĩ ma, mâ átá átángá rĩ. ꞌBo dõ mí ị́sụ́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi ꞌdãlé ꞌyéŋá pụ̃kụ́ na, mi ꞌo íngóni?” Úpí Múngú ní ꞌyozú kĩnĩ, “Dõ má ị́sụ́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi pụ̃kụ́ na, má iza kụ̃rụ́ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ãbũrámã ní ꞌyozú kĩnĩ, “Úpí Múngú, lẽ mí ãꞌyĩ ma, mâ átá átángá rĩ mụzú, mí ị́sụ́ dõ ꞌbá tã ꞌoꞌbá pịrị rĩ pi ꞌdãlé ꞌyéŋá pụ̃kụ́ ị̃rị̃, mi ꞌo íngóni?” Úpí Múngú ní ꞌyozú kĩnĩ, “ꞌBá pụ̃kụ́ ị̃rị̃ tã ꞌoꞌbá pịrị rĩ pi ã tã sĩ, má iza kụ̃rụ́ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ãbũrámã ní ꞌyozú kĩnĩ, “Úpí Múngú, mî ꞌa ã ve má ní ku, mâ gõ átá vú sĩ ãlu. Mí ị́sụ́ dõ ꞌbá tã ꞌoꞌbá pịrị rĩ pi ꞌyéŋá ꞌdãlé mụdrị́, mi ꞌo íngóni?” Úpí Múngú ní ꞌyozú kĩnĩ, “ꞌBá mụdrị́ tã ꞌoꞌbá pịrị rĩ pi ã tã sĩ, má iza kụ̃rụ́ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Úpí Múngú kã átángá rĩ átá dẹẹ́ Ãbũrámã be gí, ĩri ní ꞌdezú mụzú, Ãbũrámã ní ꞌi újázú gõzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mãlãyíkã ị̃rị̃ rĩ pi cakí Sõdómõ gá ꞌdãlé ũndréŋá sĩ, ị́sụ́ ãkũdẽ Lótõ úrí kuú kụ̃rụ́ Sõdómõ vé rĩ ã kẹ̃ẹ́tịlé gá. Lótõ kã kộpi ndreé, ĩri ní ngazú ụrụ, ĩri ní mụzú kộpi vúgá ꞌdãá. Ĩri ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá kộpi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ĩri ní ꞌyozú kĩnĩ, “Ambugu mávé rĩ pi, ĩmi ímụ́kí mávé ãngá nõó. Ĩmi ũjĩkí rí ĩmî pá, ĩmi lakí rí mávé jó agá, ĩmi fũkí rí mụzú ụ̃ꞌbụ́tịŋá sĩ ẹ̃cị̃ ĩmi ní lẽé mụzú rĩ gé ꞌdãá.” Kộpi ní újázú kínĩ, “Kuyé, ꞌbâ lakí mívé jó agá ku, ꞌbâ mụ kụ̃rụ́ rĩ agá ꞌdãá, ꞌbâ la ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ꞌBo Lótõ ní kộpi sizú ũkpõ sĩ, kộpi ní mụzú Lótõ pi be trụ́, kộpi ní fizú ĩrivé jó agá ꞌdãá. Lótõ ní ngá nyanya áꞌdízú kộpi ní, áꞌdí pánga rĩ ãkụ́fị́ ãkó, kộpi ní nyazú. ");
INSERT INTO kbo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ụ̃mụ́ rĩ pi ní drĩ lazú vũgá kuyé rĩ gé, ãgõ kụ̃rụ́ Sõdómõ vé rĩ agá rĩ pi ãrẽvú céré ímụ́kí jó rĩ ã gãrã ceé kụ́rụ̃, ꞌbá ꞌdĩꞌbée kẹ̃rị́anji rĩ pi ꞌbá ambugu rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Kộpi ní Lótõ ri zịzú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ãgõ ímụ́ꞌbá mí vúgá nõgó ị́nị́ŋá sĩ rĩ pi íngãá? Mí íjị́ kộpi ĩfũú ꞌbá vúgá ãmvé nõó, ꞌbá lẽkí laá kộpi sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lótõ ní fũzú mụzú kộpi vúgá ãmvé ꞌdãá, ĩri ní kẹ̃ẹ́tị rĩ ụ̃pị̃zú cí. ");
INSERT INTO kbo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ĩri ní ꞌyozú kĩnĩ, “Má ẹ́drị́pị́ị, á mã ĩmi drị́ ị̃rị̃ sĩ, lẽ ĩmi ꞌokí ũnjĩkãnyã ꞌdĩri tị́nị ku! ");
INSERT INTO kbo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ĩmi ndrekí drĩ ká, ma anji ũkú be ị̃rị̃ anigé, kộpi drĩ kácáŋá rú. Lẽ mâ íjị́ kộpi ĩfũú ãmvé ĩmi vúgá nõlé, ĩmi ícó tã ĩmi ní lẽé ꞌoó kộpi be rĩ ꞌo rá. Lẽ ĩmi ꞌokí tã ũnjí ãgõ ꞌdĩꞌbée be ku, kộpi ụ̃mụ́ mávé ni, ma ri kộpi ũtẽ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ꞌBo kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌÍ dẹ̃ mi ꞌdĩísĩ rá, mi ꞌbá ímụ́pi ímụ́mụ̃ ni, ꞌí lẽ tã ꞌbá ní lẽé ꞌoó rĩ lũú ꞌbá ní nĩ! ꞌBâ ícó mi ꞌo ũnjí kộpivé rĩ ndẽ.” Kộpi ní Lótõ ri zezú, kộpi ní mụzú kẹ̃ẹ́tị rĩ ŋõzú. ");
INSERT INTO kbo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ꞌBo ãgõ ị̃rị̃ jó agá rĩ pi ní ĩfũzú ãmvé nõlé, kộpi ní Lótõ ri rụzú sezú jó agá ꞌdãá, kẹ̃ẹ́tị rĩ ụ̃pị̃zú cí. ");
INSERT INTO kbo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kộpi ní kẹ̃rị́anji, ãzini ꞌbá ambugu adriꞌbá kẹ̃ẹ́tịlé gá rĩ pi ẽ mị sazú ọ̃zụ̃zú rá, kộpi ã nị̃kí rí kẹ̃ẹ́tị rĩ ámá ku. ");
INSERT INTO kbo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ãgõ ị̃rị̃ ꞌdĩꞌbée ní ꞌyozú Lótõ ní kínĩ, “Mi dõ anji ãgõ be, dõku anji ũkú be, dõku ãgõ mívé anji ũkú jeꞌbá ni pi be kụ̃rụ́ rĩ agá nõgó anigé, ꞌí jị kộpi fũú nõósĩ rá, ");
INSERT INTO kbo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ãꞌdiãtãsĩyã ꞌbâ kụ̃rụ́ nõri iza ꞌdĩísĩ rá. Úpí Múngú yị tã ĩ ní rií átá kárákará ũnjĩkãnyã ꞌbá Sõdómõ vé rĩ pi ní rií ꞌoó rĩ ã tã sĩ rĩ gí, ĩpẽ ꞌbâ ímụ́ kụ̃rụ́ rĩ izangárá gá.” ");
INSERT INTO kbo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kúru Lótõ ní mụzú ãgõ lẽꞌbá ívé anji ũkú jeꞌbá rĩ pi vúgá ꞌdãá. Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi fũkí kụ̃rụ́ nõri agásĩ mbẽlẽ, ãꞌdiãtãsĩyã Úpí Múngú lẽ kụ̃rụ́ rĩ izaá ꞌdĩísĩ rá!” ꞌBo ãgõ lẽꞌbá ĩrivé anji ũkú jeꞌbá rĩ pi ụ̃sụ̃kí kínĩ, tã Lótõ ní átá ꞌdĩri tã áví vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, mãlãyíkã rĩ pi ní ꞌyozú Lótõ ní kínĩ, “ꞌÍ ꞌdụ mívé ũkú, mívé anji ũkú ị̃rị̃ ꞌdĩꞌbée be mbẽlẽ! Ĩmi fũkí kụ̃rụ́ nõri agásĩ ãmvé, kádõ kụ̃rụ́ nõri izaá, ã úꞌdị́kí rí ĩmi drãá ku.” ");
INSERT INTO kbo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ꞌBo Lótõ mụ mbẽlẽŋá kuyé. Ãgõ ꞌdĩꞌbée ní Lótõ ẽ drị́ rụzú, ũkú ni ẽ drị́ rụzú, ãzini ĩrivé anji ũkú ị̃rị̃ rĩ pi ẽ drị́ rụzú, kộpi ní ꞌbá ꞌdĩꞌbée jịzú fũzú kụ̃rụ́ rĩ agásĩ ãmvé, ãꞌdiãtãsĩyã Úpí Múngú ꞌbã ẹ́sị́ ĩdríkídri kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ãgõ ꞌdĩꞌbée kâ ꞌbá ꞌdĩꞌbée jịị́ fũú ãmvé ꞌdãá, ãlu ni ní ꞌyozú kĩnĩ, “Ĩmi ápákí mụzú nõósĩ rá, ĩmi adrikí rí ídri rú! Ã ndrekí ãngũ vúlé ku, ã tukí pá ị́ꞌbụ́ŋá agá ꞌdãá ku! Ĩmi ápákí mụzú írã drị̃gé ꞌdãá, ĩmi adrikí rí ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lótõ ní kộpi mãzú drị́ ị̃rị̃ sĩ kĩnĩ, “Kuyé fô, Úpí mávé rĩ! ");
INSERT INTO kbo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ma ãtíꞌbá ĩmivé ni, ĩmi ꞌbãkí ẹ́sị́ múké ma ídrízú, ĩmi ꞌbãkí ẹ́sị́ ĩdríkídri má ní rá. ꞌBo má ícó ápá caá írã gá ꞌdãá bã ku, ãngũ rĩ ꞌi iza ị́sụ́ ãkũdẽ ma drĩ lẹ́tị gé, ꞌbâ ũdrã ãní rá. ");
INSERT INTO kbo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ꞌÍ ndre, kụ̃rụ́ ãzi mãdãŋáŋá ĩnyiŋá ꞌdã. Ĩri vũrã mãdãŋáŋá ni, mí ãꞌyĩ dõ ma mụụ́ ꞌa ni gé ꞌdãlé rá, ma ꞌbá mávé ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, ꞌbâ ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mãlãyíkã rĩ ní ꞌyozú Lótõ ní kĩnĩ, “Ĩri múké, tã mí ní zịị́ ꞌdĩri, má ãꞌyĩ rá. Kụ̃rụ́ mí ní rií tã ni ꞌyoó ꞌdĩri, má iza ku. ");
INSERT INTO kbo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ꞌÍ nju mụzú kụ̃rụ́ rĩ agá ꞌdãá mbẽlẽ, má ícó drĩ tã ãzi ꞌoó ku, ꞌí ca dõ ꞌdãlé gí ká.” (Lótõ ní ꞌyoó kụ̃rụ́ rĩ mãdãŋáŋá rĩ sĩ, ĩ ní kụ̃rụ́ rĩ ã rụ́ zịzú Zõárã ãní.) ");
INSERT INTO kbo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lótõ ca Zõárã gá ꞌdãlé, ị́sụ́ ãkũdẽ ụ̃tụ́ rĩ ĩfũ gí. ");
INSERT INTO kbo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Úpí Múngú ní ãcíkúlúlú ĩpẽzú ꞌbụ̃ gé ꞌdãásĩ lụ̃zú kụ̃rụ́ Sõdómõ vé rĩ agá, ãzini Gõmórã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ĩri ní kụ̃rụ́ rĩ pi zãzú, ãngũ ị́ꞌbụ́ŋá rú rĩ, ꞌbá adriꞌbá kụ̃rụ́ rĩ pi agá ꞌdãlé rĩ pi, ngá dụꞌbá nyọ̃ọ́kụ́ drị̃gé rĩ pi be, ngá ꞌdĩꞌbée ãrẽvú céré vekí rá. ");
INSERT INTO kbo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ꞌBo Lótõ ũkú ni ndre ãngũ gõzú vúlé, gõ ꞌi újá ufuú troó sụ̃ ẹ̃ꞌyị́ ní troó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị, Ãbũrámã ní ꞌi újázú gõzú vũrã ándúrú ꞌí ní pá tuzú Úpí Múngú ẹndrẹtị gé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ĩri ní ãngũ ndrezú mụzú Sõdómõ gá, Gõmórã gá, ãzini ãngũ ị́ꞌbụ́ŋá rú rĩ gé ꞌdãá. Ndre ãcígã ọ̃zụ̃ ãngũ rĩ ẽ drị̃ céré, ãcígã rĩ nị kú cịcị. ");
INSERT INTO kbo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ꞌBo Múngú kã kụ̃rụ́ rĩ pi zãá ị́ꞌbụ́ŋá rĩ be gí, ígá tã ándúrú Ãbũrámã ní zịị́ ꞌdãri, ípá Lótõ rĩ ãcí kụ̃rụ́ rĩ zãápi úꞌbúpi rĩ agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lótõ pi ívé anji ũkú ị̃rị̃ rĩ pi be, kộpi fũkí ãngũ Zõárã vé rĩ agásĩ, mụkí adrií írã rĩ pi ãsámvú gé, ãꞌdiãtãsĩyã ꞌo ụ̃rị̃ sĩ adringárá Zõárã gá ꞌdãlé rĩ sĩ. Lótõ pi ívé anji ũkú ị̃rị̃ ꞌdĩꞌbée be, kộpi fikí mụụ́ adrií ụ̃jị́ agá. ");
INSERT INTO kbo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ụ́ꞌdụ́ ãlu, mvá ũkú kãyú rĩ ní ꞌyozú ọ́mvụ́pị ní kĩnĩ, “ꞌBá ẹ́tẹ́pị ri nóni ãrãkã rú, vũrã nõri agá, ãgõ ꞌbâ jeꞌbá ni pi ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mí ímụ́, ꞌbá sẽkí ꞌbá ẹ́tẹ́pị ní vị́nyọ̃ mvụụ́ ĩmẽrẽzú ãní, ꞌbâ lakí rí ĩri be, ã tị rí ꞌbá ní anji bẽsĩnĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ị́nị́ŋá ꞌdãri sĩ, kộpi ní vị́nyọ̃ sẽzú mvụzú ĩ ẹ́tẹ́pị ní, mvá ũkú kãyú rĩ ní mụzú lazú ẹ́tẹ́pị be trụ́. Ẹ́tẹ́pị nị̃ ámá ꞌyozú kínĩ, mvá ũkú rĩ la ꞌí gãrã gá yã, dõku nga mụụ́ gí yã ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kã mụụ́ adrií drụ̃ ꞌdíni, mvá ũkú kãyú rĩ ní ũlũzú ꞌí ọ́mvụ́pị ụ̃dụ́ rĩ ní kĩnĩ, “Ị́nị́ŋá ájée rĩ sĩ, ꞌbá lakí má ẹ́tẹ́pị be trụ́. Lẽ ꞌbâ sẽkí ĩri ní vị́nyọ̃ mvụụ́ dị̃ị́ ị́nị́ŋá nõri sĩ, ꞌí la rí ĩri be, mí ẹ́tẹ́pị ã tị rí mí ní mvá bẽsĩnĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kúru ị́nị́ŋá ꞌdãri sĩ, kộpi ní ĩri ní vị́nyọ̃ sẽzú mvụzú. Mvá ụ̃dụ́ rĩ ní mụzú lazú ẹ́tẹ́pị be trụ́, Ẹ́tẹ́pị nị̃ ámá ꞌyozú kínĩ, mvá ũkú rĩ la ꞌí gãrã gá yã, dõku nga mụụ́ gí yã ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lótõ ní laá ívé anji ũkú ị̃rị̃ ꞌdĩꞌbée sĩ rĩ sĩ, kộpi ị́sụ́kí ꞌa rá. ");
INSERT INTO kbo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mvá ũkú kãyú rĩ ní mvá ágóŋá tịzú, ĩri ní rụ́ ni ꞌdazú Mõábã ꞌi. Ĩri ẹ́ꞌbị́pị ꞌbá Mõábã gá rĩ pi vé ni cĩmgbá ícázú ãndrũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mvá ụ̃dụ́ rĩ ní kpá mvá ágóŋá tịzú, ĩri ní rụ́ ni ꞌdazú Bẽnámĩ ꞌi. Ĩri ẹ́ꞌbị́pị ꞌbá Ãmónã vé rĩ pi vé ni cĩmgbá ícázú ãndrũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ãbũrámã ní ngazú vũrã ꞌdãri gé sĩ, ĩri ní ꞌdezú mụzú adrizú ãngũ Nẽgévẽ vé rĩ gé, kụ̃rụ́ Kãdésã vé rĩ pi ãsámvú gé kụ̃rụ́ Sụ́rụ̃ vé rĩ be. Ĩri ní gõzú mụzú adrizú Gẽrárĩ gé. Kã rií adrií ꞌdãlé, ");
INSERT INTO kbo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ũlũ ꞌbá rĩ pi ní kĩnĩ, ꞌî ũkú ni Sárã ri ꞌí ọ́mvụ́pị. Kúru ꞌbãgú Ãbũmẽlékẽ Gẽrárĩ vé rĩ ní ꞌbá pẽzú mụzú Sárã ri íjị́zú ꞌí ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kã mụụ́ adrií ị́nị́ŋá rĩ sĩ, Múngú ní ímụ́zú átázú Ãbũmẽlékẽ ní urobí agá kĩnĩ, “Mi ímụ́ drã rá, ãꞌdiãtãsĩyã ũkú mí ní ꞌdụụ́ ꞌdĩri, ĩri ágó be.” ");
INSERT INTO kbo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ꞌBo Ãbũmẽlékẽ pi lakí ũkú rĩ be kuyé. Kúru Ãbũmẽlékẽ ní ꞌyozú kĩnĩ, “Úpí Múngú, mi nyo ꞌbá ũnjĩkãnyã ãkó rĩ pi úꞌdị́ ũdrã rá? ");
INSERT INTO kbo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ãbũrámã ꞌyo nyo má ní kĩnĩ, Sárã ri ꞌí ọ́mvụ́pị ꞌdíni kuyé? Sárã ꞌyo kpá Ãbũrámã ri ꞌí ẹ́drị́pị ꞌdíni kuyé? Á lẽ kõdô tã ũnjí ꞌoó ku, mâ ụ̃sụ̃ déna tã má ní ꞌoó rĩ pịrị.” ");
INSERT INTO kbo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kúru Múngú ní ꞌyozú ĩri ní urobí agá kĩnĩ, “Ẽ, á nị̃ rá ꞌí ꞌo tã ũnjí kuyé, má uga mi, sẽ ꞌí ꞌo ũnjĩkãnyã má ẹndrẹtị gé kuyé. Sẽ má ní mi ugazú, mí ní lazú ũkú rĩ be kuyé ãní. ");
INSERT INTO kbo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Lẽ mî újá ágó rĩ vé ũkú gõó vú ni gé ꞌdãá vúlé, ãꞌdiãtãsĩyã ĩri nẹ́bị̃, ã zị rí ma mí ní, mî drã rí ku. ꞌBo mí újá dõ ũkú rĩ gõó kuyé, mi ꞌbá mívé rĩ pi be, ĩmi céré ímụ́ ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị, Ãbũmẽlékẽ ní ívé ũgalaku rĩ pi zịzú ímụ́zú céré, ĩri ní tã ꞌi ꞌoópi ꞌdĩri ũlũzú kộpi ní. Sẽ ụ̃rị̃ fụ kộpi ãní ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kúru Ãbũmẽlékẽ ní Ãbũrámã ri zịzú ímụ́zú, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ ꞌo ꞌbâ ꞌdíni ãsĩ? Tã ũnjí má ní ꞌoó mí ní rĩ ãꞌdi sẽzú mí ní tã ũnjí íjị́zú má drị̃gé, ãzini mávé ꞌbá má ní rụụ́ rĩ pi drị̃gé? Tã mí ní ꞌoó má ní ꞌdĩri, ĩ ní kõdô ícó ꞌoó ku ni.” ");
INSERT INTO kbo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ãbũmẽlékẽ ní Ãbũrámã ri zịzú kĩnĩ, “Ngá sẽépi mí ní tã ꞌdĩri ꞌozú ꞌdíni rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ãbũrámã ní újázú kĩnĩ, “Má ụ̃sụ̃, ‘Vũrã nõri gé, ꞌbá rĩ pi rukí Múngú ri ku, kộpi ma ꞌdị ũkú mávé rĩ ã tã sĩ rá.’ ");
INSERT INTO kbo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ádarú ĩri mávé ọ́mvụ́pị, ꞌbâ ĩri be ẹ́tẹ́pị ãlu, ꞌbávé ẹ́ndrẹ́pị rĩ pi ãndíãndí. Á je ĩri má ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Múngú kã ándúrú ꞌyoó mâ ku má ẹ́tẹ́pị vé ꞌbẹ̃tị́, mâ ꞌde mụzú ãngũ ãzi gé, á ꞌyo Sárã ní, má kĩnĩ, ‘ꞌÍ lẽ dõ ma rá, vũrã ꞌbá ní ẹ́cị́zú rĩ pi agásĩ, ꞌí lũ ꞌyozú kínĩ, ma mí ẹ́drị́pị.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kúru Ãbũmẽlékẽ ní Sárã ri újázú gõzú Ãbũrámã ni vúlé. Ĩri ní kãbĩlõ íꞌdụ́zú, tị́ pi be, tụ́gẹ̃rị̃ ãgõ rú ni pi be, tụ́gẹ̃rị̃ ũkú rú ni pi be sẽzú Ãbũrámã ní. ");
INSERT INTO kbo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ãbũmẽlékẽ ní ꞌyozú kĩnĩ, “Nyọ̃ọ́kụ́ mávé rĩ, ĩri mí ẹndrẹtị gé ꞌdã. ꞌÍ mụ adrií vũrã mí ní ĩpẽé rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ĩri ní ꞌyozú Sárã ní kĩnĩ, “Ma mí ẹ́drị́pị ní mũfẽngã fífí sẽ élĩfũ ãlu (1,000), ẽ iꞌda rí ꞌbá rĩ pi ẹndrẹtị gé nõgó lũzú kínĩ, á ꞌo ũnjĩkãnyã mí ní, ꞌbo mí ꞌo ũnjĩkãnyã kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kúru Ãbũrámã ní Múngú rĩ zịzú Ãbũmẽlékẽ ní, Múngú ní ĩri ídrízú, Múngú ní kpá ũkú ni ri ídrízú anji ũkú tụ́gẹ̃rị̃ rú rĩ pi be, kộpi ã gõkí rí anji tịị́ dị̃ị́, ");
INSERT INTO kbo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ãꞌdiãtãsĩyã Úpí Múngú ọ̃zụ̃ ũkú adriꞌbá Ãbũmẽlékẽ vé ꞌbẹ̃tị́ ãsámvú gé rĩ pi vé mvá vũrã rá, Ãbũrámã vé ũkú Sárã ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Úpí Múngú ní drị́ tị̃zú Sárã rụ́ꞌbá gá, sụ̃ ĩri ní ándúrú ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sárã ní ꞌa ị́sụ́zú, ĩri ní Ãbũrámã ní mvá ágó tịzú, ị́sụ́ ãkũdẽ Ãbũrámã ri ãrãkã rú. Tịkí mváŋá rĩ sâ Múngú ní ꞌyoó ĩ mváŋá rĩ tị rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ãbũrámã ní mváŋá rĩ ã rụ́ ꞌdazú Ĩsákã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ĩsákã kã adrií caá ụ́ꞌdụ́ be ãrõ, Ãbũrámã ní ágélé ni ẽ tị lịzú, sụ̃ Múngú ní ẹzịị́ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tịkí Ĩsákã ri ãkũdẽ Ãbũrámã ri ílí be mụ̃dụ̃rụ̃lụ̃ ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sárã ní ꞌyozú kĩnĩ, “Múngú sẽ á gụ ãyĩkõ be ẹ́sị́ agá, ꞌbá tã ꞌdĩri yịꞌbá rĩ pi céré ímụ́ gụ, sụ̃ má ní gụụ́ rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sárã ní gõzú ꞌyozú kĩnĩ, “Ãꞌdi ri ícó ꞌyo kínĩ, ꞌbâ mvá tị Ãbũrámã be rá nĩ? ꞌBo á tị ĩri ní mvá ágóŋá, ị́sụ́ ãkũdẽ ĩri ãrãkã rú.” ");
INSERT INTO kbo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mváŋá rĩ kã mbaá, kã bã ndrungárá kuú gí, Ãbũrámã ní ụ̃mụ̃ ꞌbãzú ãmbúgú ụ́ꞌdụ́ Ĩsákã ní bã ndrungárá kuzú ꞌdĩri ị̃njị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sárã kã ndreé Ãgárã Ẽjẽpétõzị́ rĩ vé mvá ĩri ní tịị́ Ãbũrámã ní rĩ ri gụ Ĩsákã sĩ, ");
INSERT INTO kbo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sárã ní ꞌyozú Ãbũrámã ní kĩnĩ, “ꞌÍ dro ũkú tụ́gẹ̃rị̃ rú ꞌdĩri ívé mváŋá rĩ be rá, ĩrivé mváŋá rĩ ã rụ rí ãꞌbú mí ní ímụ́ kuú mávé mvá Ĩsákã ní rĩ ẽ tị ku.” ");
INSERT INTO kbo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tã ꞌdĩri sẽ Ãbũrámã ní ĩzãngã ambamba, ãꞌdiãtãsĩyã Ĩsĩmãélẽ ri mvá Ãbũrámã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ꞌBo Múngú ní ꞌyozú Ãbũrámã ní kĩnĩ, “Mvá rĩ vé tã, ãzini mívé tụ́gẹ̃rị̃ rĩ vé tã, ã sẽ mí ní ĩzãngã ꞌdíni ku. Lẽ mî yị tã Sárã ní ꞌyoó mí ní rĩ, ãꞌdiãtãsĩyã úyú mívé rĩ pi ímụ́ ĩfũ Ĩsákã rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ma kpá sẽ mívé tụ́gẹ̃rị̃zị́ rĩ vé mvá ri ímụ́ tị ízú kárákará, ĩrivé úyú ri ímụ́ adri sụ́rụ́ ãmbúgú, ãꞌdiãtãsĩyã ĩri mvá mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị, Ãbũrámã íꞌdụ́ ínyá, ãzini tõ yị̃ị́ kụ̃lụ́kụ́ agá tré, ĩri ní ꞌdụzú ꞌbãzú Ãgárã ã kị́dị́ gé. Ĩri ní kúru kộpi pẽzú mụzú mvọ́pị Ĩsĩmãélẽ be. Ãgárã ní ꞌdezú mụzú, ĩri ní rizú ẹ́cị́zú ãngũ ãꞌwí cínyáfã rú Bẽrĩsébã vé rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yị̃ị́ kụ̃lụ́kụ́ agá rĩ kã dẹẹ́, ĩri ní mváŋá rĩ jịzú ꞌbãzú pẹtị amuúpi rĩ vé índrĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ĩri ní ngazú mváŋá rĩ ã gãrã gá sĩ, mụzú úrízú mváŋá rĩ be ãsámvú sĩ, ãꞌdiãtãsĩyã ri ụ̃sụ̃ụ́ kĩnĩ, “Á lẽ mváŋá rĩ vé drãngárá ndreé ku.” Kã rií úrí ꞌdãlé, ĩri ní íꞌdózú ngozú. ");
INSERT INTO kbo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Múngú kã yịị́ mváŋá rĩ ri ngongo, mãlãyíkã Múngú vé rĩ ní Ãgárã ri zịzú ꞌbụ̃ gé ꞌdãásĩ kĩnĩ, “Ãgárã, ngá ũnjí rĩ ãꞌdi? Lẽ mî ꞌo ụ̃rị̃ sĩ ku. Mváŋá rĩ la kú ꞌdã, Múngú yị ĩrivé ngongárá gí. ");
INSERT INTO kbo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ꞌÍ mụ mváŋá rĩ íꞌdụ́ rụụ́ drị́gé, ma sẽ mváŋá rĩ ímụ́ tị ízú kárákará, ĩrivé úyú ri ímụ́ adri sụ́rụ́ ãmbúgú.” ");
INSERT INTO kbo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kúru Múngú ní Ãgárã ẽ mị zị̃zú, ĩri ní kídí ndrezú. Ĩri ní kúru mụzú yị̃ị́ tõzú kụ̃lụ́kụ́ rĩ agá tré, ĩri ní sẽzú mvụzú mváŋá rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mváŋá rĩ kã rií mbaá, Múngú ri ĩri ũtẽé nĩ. Mváŋá rĩ ri adrií ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá, nị̃ zãá ꞌbungárá ụ̃sụ̃ sĩ rĩ ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Mvá ágó rĩ kã rií adrií ãngũ ãꞌwí cínyáfã rú Pãránã vé rĩ agá ꞌdãá, ẹ́ndrẹ́pị ị́sụ́ ĩri ní ũkú íngázú ãngũ Ẽjẽpétõ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sâ ꞌdãri gé, Ãbũmẽlékẽ pi ꞌdekí mụụ́ ívé ũgalaku ãmbúgú ãngáráwá rĩ pi vé Pĩkólã be Ãbũrámã vúgá ꞌdãá, kộpi ní ꞌyozú Ãbũrámã ní kínĩ, “Tã céré mí ní ꞌoó rĩ agá, Múngú ri mî ĩzã ko rá. ");
INSERT INTO kbo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lẽ mî sõ ũyõ Múngú ẹndrẹtị gé nõgó ꞌyozú kínĩ, mí ícó mâ mị ũꞌbãá ku, dõku mávé anjiŋá rĩ pi ẽ mị ũꞌbãá ku, dõku mávé úyú rĩ pi ẽ mị ũꞌbãá ku. Á ꞌbã ẹ́sị́ múké mí ní, lẽ mî ꞌbã kpá ẹ́sị́ múké má ní, ãzini mî ꞌbã ẹ́sị́ múké ãngũ mí ní adrizú jãkã rú nõri drị̃gé.” ");
INSERT INTO kbo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ãbũrámã ní ꞌyozú kĩnĩ, “Á sõ ũyõ rĩ Múngú ẹndrẹtị gé gí, sụ̃ mí ní ꞌyoó rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kúru Ãbũrámã ní unuzú Ãbũmẽlékẽ ẹndrẹtị gé Ãbũmẽlékẽ vé kídí ãtíꞌbá rĩ pi ní ẹ́rị́ rĩ vé tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ãbũmẽlékẽ ní ꞌyozú kĩnĩ, “Á nị̃ kuyé dõ ãꞌdi ꞌo tã ꞌdĩri nĩ. ꞌÍ lũ má ní tã ꞌdĩri kuyé, á yị tã ꞌdĩri ãndrũ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kúru Ãbũrámã ní kãbĩlõ ụrụkọ íꞌdụ́zụ́, ãzini tị́ ụrụkọ íꞌdụ́zú sẽzú Ãbũmẽlékẽ ní. Kúru ꞌbá ị̃rị̃ ꞌdĩꞌbée ní ũndĩ rụzú ĩ ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ãbũrámã ní kãbĩlõ mbaꞌbá fõlõ ũkú rú ni pi ũpẽzú ẹ́zị̂rị̃, ꞌbãzú túngú. ");
INSERT INTO kbo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ãbũmẽlékẽ ní Ãbũrámã ri zịzú kĩnĩ, “Mí ũpẽ kãbĩlõ ũkú rú mbaꞌbá fõlõ ẹ́zị̂rị̃ ꞌdĩꞌbée ꞌbãá kuú túngú ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ãbũrámã ní újázú ĩri ní kínĩ, “Mí ẹ́ꞌyị́ kãbĩlõ mbaꞌbá fõlõ ẹ́zị̂rị̃ ꞌdĩꞌbée, ã lũ rí ꞌyozú kínĩ, á ga kídí rĩ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kúru ĩ ní vũrã ꞌdãri ã rụ́ zịzú Bẽrĩsébã, ãꞌdiãtãsĩyã ꞌbá ị̃rị̃ pi sõkí ũyõ vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kộpi ní ũndĩ rĩ rụzú ĩ ãsámvú gé sĩ Bẽrĩsébã gá ꞌdãlé rĩ ã vụ́drị̃ gé, Ãbũmẽlékẽ pi ní ĩ újázú gõzú ívé ũgalaku ãmbúgú ãngáráwá rĩ pi vé Pĩkólã be ãngũ Fẽlẽsétẽ vé rĩ gé ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ãbũrámã ní ị́tị́ sazú Bẽrĩsébã gá ꞌdãlé, ĩri ní Úpí Múngú adriípi mụzú ꞌdániꞌdáni rĩ ị̃njị̃zú vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ãbũrámã adri ãngũ Fẽlẽsétẽ vé rĩ gé ꞌdãlé lókí be ãco. ");
INSERT INTO kbo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kã mụụ́ adrií sâ ãzi ã vụ́drị̃ gé, Múngú ní Ãbũrámã ri ụ̃ꞌbị̃zú. Ĩri ní Ãbũrámã ri zịzú kĩnĩ, “Ãbũrámã!” Ãbũrámã ní ãꞌyĩzú kĩnĩ, “Ma nõ!” ");
INSERT INTO kbo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kúru Múngú ní ꞌyozú kĩnĩ, “ꞌÍ ꞌdụ mívé mváŋá ãlukúta Ĩsákã mí ní lẽé ambamba rĩ, ꞌí mụ ãngũ Mõríyã vé rĩ gé. Ma mí ní írã ãzi lũ írã rĩ pi ãsámvú gé ꞌdãá, ꞌí zã má ní mváŋá rĩ rọ̃bọ̃ŋọ̃ rú írã rĩ drị̃gé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kã mụụ́ adrií drụ̃ ꞌdíni, Ãbũrámã ní fũzú ụ̃ꞌbụ́tị, ĩri ní íjá úlị́zú, ĩri ní íjá rĩ ũdrõzú ngá ụrụkọꞌbée be dõngí rĩ ã úgóró gá, kộpi ní ꞌdezú mụzú ꞌî mvọ́pị Ĩsákã be, ívé ãtíꞌbá ụrụkọ ị̃rị̃ rĩ pi be vũrã Múngú ní lũú ĩri ní rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kã adrií ụ́ꞌdụ́ na ni gé, Ãbũrámã ní ꞌî drị̃ ingazú ãngũ ndrezú, ndre ãngũ rĩ rárá rú. ");
INSERT INTO kbo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ĩri ní ꞌyozú ívé ãtíꞌbá rĩ pi ní kĩnĩ, “Ĩmi tẽkí ꞌbâ dõngí rĩ be nõgó, ꞌbâ mụ mváŋá rĩ be ꞌdãlé Múngú ri zị. ꞌBâ kúru ĩgõ ĩmi vúgá nõlé ndõ.” ");
INSERT INTO kbo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ãbũrámã ní íjá rọ̃bọ̃ŋọ̃ zãzú rĩ ꞌdụzú ꞌbãzú ꞌî mvọ́pị Ĩsákã drị̃gé, Ãbũrámã ꞌdụ ívé rĩ ãcí, ãzini ị́lị́. ꞌBá ị̃rị̃ ꞌdĩꞌbée kâ rií ꞌdeé mụzú trụ́ ãlu, ");
INSERT INTO kbo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ĩsákã ní ꞌí ẹ́tẹ́pị Ãbũrámã ri zịzú kĩnĩ, “Má ẹ́tẹ́pị.” Ãbũrámã ní ãꞌyĩzú kĩnĩ, “Ẽ, mâ mvá rĩ.” Ĩsákã ní ẹ́tẹ́pị ri zịzú kĩnĩ, “Ãcí rĩ pi íjá rĩ be nõ, ꞌbo kãbĩlõ mvá ĩ ní mụụ́ zãá rọ̃bọ̃ŋọ̃ rú rĩ íngãá?” ");
INSERT INTO kbo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ãbũrámã ní újázú ĩri ní kĩnĩ, “Mâ mvá rĩ, Múngú ri kãbĩlõ mvá ĩ ní mụụ́ zãá rọ̃bọ̃ŋọ̃ rú rĩ sẽ rá.” Ãbũrámã pi ní ꞌdezú mụzú mvọ́pị Ĩsákã be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kộpi kã mụụ́ caá vũrã Múngú ní ándúrú lũú ĩri ní rĩ gé ꞌdãá, Ãbũrámã ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú, ĩri ní íjá rĩ pi uꞌdụzú ũꞌbãzú drị̃ ni gé. Ĩri ní ívé mvá Ĩsákã ri ũdrõzú, ĩri ní ꞌdụzú ꞌbãzú vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ drị̃gé íjá rĩ drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ĩri ní ị́lị́ íꞌdụ́zú lẽzú ívé mváŋá rĩ lịzú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ꞌBo mãlãyíkã Úpí Múngú vé rĩ ní ĩri zịzú ꞌbụ̃ gé ꞌdãásĩ, “Ãbũrámã! Ãbũrámã!” Ãbũrámã ní ãꞌyĩzú kĩnĩ, “Ma nõ.” ");
INSERT INTO kbo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mãlãyíkã rĩ ní ꞌyozú kĩnĩ, “Lẽ mî lị mváŋá rĩ ku, ã ꞌokí tã ãzi ũnjí rụ́ꞌbá ni gé ku. Á nị̃ rá ꞌyozú kínĩ mí ị̃njị̃ Múngú ri rá, ãꞌdiãtãsĩyã mí ãꞌyĩ mívé mváŋá ãlukúta ꞌdĩri sẽé ĩri ní rá.” ");
INSERT INTO kbo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ãbũrámã ní ꞌî drị̃ ingazú ãngũ ndrezú, ĩri ní kãbĩlõ ágó ndrezú, úꞌyú ni ãꞌyĩ kú pẹtị dụụ́pi kụ̃mvụ̃ rĩ ãsámvú gé. Ĩri ní mụzú kãbĩlõ rĩ rụzú, ĩri ní zãzú rọ̃bọ̃ŋọ̃ rú ꞌî mvọ́pị ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kúru Ãbũrámã ní vũrã rĩ ã rụ́ zịzú, “Úpí Múngú ri sẽ rá.” Cĩmgbá ụ́ꞌdụ́ ãndrũ rĩ gé, ꞌbá rĩ pi ri ꞌyo, “Úpí Múngú vé írã drị̃gé, Úpí ri sẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mãlãyíkã Úpí Múngú vé rĩ ní Ãbũrámã ri zịzú ꞌbụ̃ gé ꞌdãásĩ dị̃ị́, ");
INSERT INTO kbo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú kĩnĩ, mí ní mávé tã ꞌdụụ́ ngaá rá, ãzini mí ní mívé mvá ãlukúta rĩ ãꞌyĩí sẽé Úpí ní rá rĩ sĩ, á sõ ũyõ ꞌyozú kínĩ, ");
INSERT INTO kbo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ádarú ma mí ní tãkíri sẽ rá, ma sẽ mívé úyú ri úmvúlésĩ ízú sụ̃ línyã ꞌbụ̃ gé rĩ pi tị́nị, ãzini cínyáfã yị̃ị́ tafu gãrã gá rĩ tị́nị. Mívé úyú rĩ pi úmvúlésĩ kụ̃rụ́ ariꞌba rĩ pi vé rĩ ẹ́rị́ kộpi drị́gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ꞌBá ãngũ rĩ pi agásĩ rĩ pi ãrẽvú céré úmvúlésĩ tãkíri ị́sụ́ úyú mívé rĩ pi vúgá, ãꞌdiãtãsĩyã ꞌí ꞌdụ tã mávé rĩ ngaá rá.” ");
INSERT INTO kbo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kúru Ãbũrámã pi ní ĩ újázú gõzú ívé ãtíꞌbá rĩ pi vúgá ꞌdãlé, kộpi ní ꞌdezú mụzú trụ́ Bẽrĩsébã gá ꞌdãá. Ãbũrámã ní rizú adrizú Bẽrĩsébã gá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kã mụụ́ adrií vụ́drị̃ ni gé, ũlũkí Ãbũrámã ní kínĩ, Ãbũrámã ẹ́drị́pị Nãhórã vé ũkú Mĩlékã tị anji ãgõ ãrõ Nãhórã ní. ");
INSERT INTO kbo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mvá kãyú rĩ Ụ́zị̃ ꞌi, ꞌdeépi vú ni gé sĩ rĩ Bụ́zị̃ ꞌi, ꞌdeépi ꞌdĩri vú sĩ rĩ Kẽmũélẽ ꞌi, (Kẽmũélẽ ri Ãrámã vé ẹ́tẹ́pị), ");
INSERT INTO kbo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ĩri ní ꞌdezú Kẽsédẽ ꞌi, Ázõ ꞌi, Pĩlĩdásã ꞌi, Jĩdĩláfã ꞌi, Bẽtũwélẽ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bẽtũwélẽ ri Rẽbékã vé ẹ́tẹ́pị. Mĩlékã tị anji ãgõ ãrõ ꞌdĩꞌbée Ãbũrámã vé ẹ́drị́pị Nãhórã ní. ");
INSERT INTO kbo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nãhórã vé ũkú rĩ ãzi ã rụ́ Rẽúmã ꞌi, tị kpá anji ãgõ rá, anji rĩ pi, Tébã ꞌi, Gãhámã ꞌi, Tãhásã ꞌi, Mákã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sárã adri caá ílí mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ị̃rị̃ drị̃ ni ẹ́zị̂rị̃ (127). ");
INSERT INTO kbo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sárã drã Kĩrĩyátã-Ãrábã (nóni ĩ ní zịị́ Hẽbẽrónã) rĩ gé, ãngũ Kãnánã vé rĩ agá. Ãbũrámã ní fizú Sárã ri ngozú gãkũ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ãbũrámã ní ngazú ãvũ rĩ ã jẽlé gá sĩ, ĩri ní átázú ꞌbá Hị́tị̃ vé rĩ pi be, ĩri ní ꞌyozú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ma jãkã ĩmi ãsámvú gé nõgó, ĩmi sẽkí má ní vũrã jeé, mâ sị̃ rí mâ ũkú ni vé ãvũ vũrã rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ꞌBá Hị́tị̃ vé rĩ pi ní újázú Ãbũrámã ní kínĩ, ");
INSERT INTO kbo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ãmbúgú ꞌbávé rĩ, mí yị drĩ ꞌbâ ká. Mi ꞌbá ãmbúgú ĩ ní ị̃njị̃ị́ ị̃njị̃ ni ꞌbâ ãsámvú gé nõgó. Mí ĩpẽ vũrã mí ní ndreé múké ni, ꞌí sị̃ ãvũ rĩ ꞌa ni gé. ꞌBá ãsámvú gé nõgó, ꞌbá ãzi ícó ívé vũrã ãvũ sị̃zú rĩ ugaá mí ní ku.” ");
INSERT INTO kbo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kúru Ãbũrámã ní íngázú ọ̃vụ̃zú ꞌî drị̃ sị̃zú vũgá ꞌbá Hị́tị̃ vé rĩ pi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ãꞌyĩkí dõ rá, mâ sị̃ mávé ũkú ãngũ Hị́tị̃ vé rĩ agá nõgó, ĩmi zịkí má ní Ẽfõrónã Zõhárã mvọ́pị ri, ");
INSERT INTO kbo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ã sẽ rí má ní ívé ụ̃jị́ Mãkãpélã gá, ívé nyọ̃ọ́kụ́ rĩ vé ụ̃dụ̃ gé rĩ jeé. Ĩmi zịkí ĩri, ã sẽ rí jeé má ní ãjẽ ĩmi ní lẽé rĩ sĩ, ã adri rí vũrã mávé ni ãvũ sị̃zú ni.” ");
INSERT INTO kbo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ị́sụ́ ãkũdẽ Ẽfõrónã Hị́tị̃gú rĩ úrí kuú ívé ꞌbá rĩ pi ãsámvú gé ꞌdãá, ĩri ní újázú Ãbũrámã ní, ĩrivé ꞌbá Hị́tị̃ vé ímụ́ꞌbá kụ̃rụ́ rĩ vé kání tị gé rĩ pi ãrẽvú céré yịkí tã ĩri ní újá rĩ rá, ");
INSERT INTO kbo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ĩri ní ꞌyozú kĩnĩ, “Ãmbúgú mávé rĩ, adri ꞌdíni kuyé, mí yị drĩ ma ká, ma vũrã rĩ sẽ mí ní ụ̃jị́ ꞌa ni gé rĩ be má ẹ́ꞌdị́páa ẹndrẹtị gé sĩ, mî sị̃ rí mî ũkú ni drãápi rĩ vé ãvũ ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ãbũrámã ní gõzú ọ̃vụ̃zú ꞌî drị̃ sị̃zú vũgá vũrã rĩ vé ẹ́ꞌdị́páa ẹndrẹtị gé dị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ĩri ní ꞌyozú Ẽfõrónã ní, vũrã ẹ́ꞌdị́páa yịkí rá kĩnĩ, “Mí yị drĩ ma ká, dõ ícó rá, mí ãꞌyĩ má ní. Ma vũrã rĩ vé ãjẽ mí ní lịị́ rĩ ũfẽ mí ní rá, mâ sị̃ rí mávé ũkú drãápi rĩ vũrã rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ẽfõrónã ní újázú Ãbũrámã ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ãmbúgú mávé rĩ, mí yị drĩ ma ká, mũfẽngã ꞌdĩri vé tã adri ãmbúgú ku, vũrã rĩ vé ãjẽ mũfẽngã fífí mụ̃dụ̃rụ̃lụ̃ sụ (400). ꞌÍ sị̃ mívé ãvũ rĩ ĩyí.” ");
INSERT INTO kbo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ãbũrámã ãꞌyĩ tã Ẽfõrónã vé rĩ rá. Ĩri ní mũfẽngã fífí rĩ lãzú sẽzú Ẽfõrónã ní, sụ̃ ĩri ní ꞌyoó rĩ tị́nị, Hị́tị̃ rĩ pi yịkí rá. Íꞌdụ́ mũfẽngã fífí rĩ, lã caá mụ̃dụ̃rụ̃lụ̃ sụ. ");
INSERT INTO kbo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ãbũrámã ní nyọ̃ọ́kụ́ Ẽfõrónã vé adriípi Mãkãpélã gá ĩnyiŋá Mãmúrẽ be rĩ jezú. Je nyọ̃ọ́kụ́ rĩ ụ̃jị́ ꞌa ni gé rĩ be, ãzini pẹtị ꞌa ni gé rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Sẽkí nyọ̃ọ́kụ́ rĩ jeé Ãbũrámã ní, ã adri rí ĩrivé ní mụzú nyonyo, sẽkí ĩri ní nyọ̃ọ́kụ́ rĩ ꞌbá ambugu Hị́tị̃ vé ĩ úmúꞌbá kụ̃rụ́ rĩ vé kání tị gé rĩ pi andregá sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Vụ́drị̃ ni gé, Ãbũrámã ní ũkú ni Sárã vé ãvũ sị̃zú ụ̃jị́ Mãkãpélã vé rĩ agá, ĩnyiŋáŋá Mãmúrẽ be, (Mãmúrẽ ri Hẽbẽrónã gé) ĩri ãngũ Kãnánã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ãngũ ándúrú adriípi Hị́tị̃ rĩ pi vé ụ̃jị́ be rĩ, sẽkí ĩri Ãbũrámã ní rizú ãvũ sị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ãbũrámã adri caá ílí be ãco, dẽ ícá ãrãkã rú, Úpí Múngú sẽ ĩri ní tãkíri lẹ́tị be ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ụ́ꞌdụ́ ãlu, Ãbũrámã ní ꞌyozú ívé ãtíꞌbá ãmbúgú riípi ívé ngá ꞌbẹ̃tị́ ãsámvú gé rĩ ũtẽépi rĩ ní kĩnĩ, “ꞌÍ sõ ũyõ má ẹndrẹtị gé nõgó. ");
INSERT INTO kbo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Á lẽ mî sõ ũyõ Úpí Múngú ꞌbụ̃ pi gbiípi vũ be rĩ ã rụ́ sĩ, lũzú kínĩ, mí ícó mvá ũkú Kãnánã vé ni ĩpẽé jeé mâ mvọ́pị Ĩsákã ní ũkú rú ꞌbá má ní adrií kộpi ãsámvú gé rĩ pi ãsámvú gé nõgó ku. ");
INSERT INTO kbo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ꞌÍ mụ ũkú rĩ jeé mâ mvọ́pị Ĩsákã ní ãngũ ꞌbávé rĩ agá, mávé máríté rĩ pi ãsámvú gé.” ");
INSERT INTO kbo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ãtíꞌbá rĩ ní ĩri zịzú kĩnĩ, “ꞌBo ũkú rĩ gã dõ ímụ́gá má be sĩ ãngũ nõri gé, mâ ꞌo íngóni? Mâ jị rí mî mvọ́pị Ĩsákã ri mụzú ãngũ mívé mí ní ĩfũzú rĩ gé ꞌdãá?” ");
INSERT INTO kbo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ãbũrámã ní újázú ĩri ní kĩnĩ, “Lẽ mî jị mâ mvọ́pị ri ꞌdãlé ku! ");
INSERT INTO kbo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Úpí Múngú adriípi ꞌbụ̃ gé, ma zịị́pi ĩfũúpi má ẹ́tẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé sĩ, ãngũ má ẹ́ꞌdị́páa vé rĩ agásĩ, átápi má ní, tã rĩ ẹzịị́pi má ní ꞌyoópi, ‘Ma úmvúlésĩ ãngũ nõri sẽ mvá mívé úyú agá ni ní rĩ,’ ĩri ívé mãlãyíkã pẽ ꞌde mí ẹndrẹtị gé sĩ drị̃drị̃, mî mụ rí ũkú ị́sụ́ mâ mvọ́pị ní ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mvá ũkú rĩ gã dõ ímụ́gá mí be sĩ, mí ọyụ mi ũyõ mí ní sõó má ẹndrẹtị gé rĩ agásĩ gí. Lẽ mî jị mâ mvọ́pị ri ꞌdãlé ku.” ");
INSERT INTO kbo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kúru ãtíꞌbá rĩ ní ũyõ sõzú Ãbũrámã ẹndrẹtị gé, sụ̃ Ãbũrámã ní ꞌyoó ĩri ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kúru ãtíꞌbá rĩ ní ívé ãmbúgú rĩ vé kámĩlõ rĩ pi íꞌdụ́zú mụdrị́, ngá múké múké ni pi be, ĩri ní ꞌdezú mụzú. ꞌDe mụụ́ ãngũ ĩ ní zịị́ Ãrámã Nãhãrãyímũ rĩ gé, ĩri ní gõzú cazú kụ̃rụ́ Nãhórã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ãtíꞌbá rĩ kã mụụ́ caá ꞌdãlé, ĩri ní kámĩlõ rĩ pi sẽzú ulazú vũgá kídí rĩ ã jẽlé gá, kídí rĩ kụ̃rụ́ rĩ gé ãmvélésĩ. Sâ ꞌdãri ũndréŋá, ũkú rĩ pi ní mụzú yị̃ị́ ĩbẽzú ni. ");
INSERT INTO kbo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ĩri ní kúru Múngú ri zịzú kĩnĩ, “Á Úpí, Múngú mávé ãmbúgú Ãbũrámã vé rĩ, lẽ mî sẽ má ní drị̃lé múké ãndrũ sĩ, ꞌí ꞌbã ẹ́sị́ múké mávé ãmbúgú Ãbũrámã ní. ");
INSERT INTO kbo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ꞌÍ ndre, á tu pá kuú kídí rĩ ã jẽlé gá nõ, anji ũkú kụ̃rụ́ agá rĩ pi ri ímụ́ yị̃ị́ ĩbẽngárá gá, ");
INSERT INTO kbo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","á zị dõ ãlu ni, á ꞌyo dõ, ‘Mí ọ́ꞌdụ́ mívé ũdrí vũgá, ꞌí sẽ má ní yị̃ị́ mvụụ́,’ sẽ dõ má ní yị̃ị́ rĩ mvụụ́ rá, ãzini ãꞌyĩ dõ yị̃ị́ sẽé mvụụ́ mávé kámĩlõ rĩ pi ní rá, mvá ũkú mí ní ĩpẽé Ĩsákã ní rĩ ĩri adriípi ꞌdĩ. Tã rĩ nga dõ ꞌi ꞌdíni, ma nị̃ ámá ꞌyozú kínĩ ꞌí ꞌbã ẹ́sị́ múké mávé ãmbúgú rĩ ní gí.” ");
INSERT INTO kbo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ãtíꞌbá rĩ kã drĩ Múngú ri zịị́ dẹẹ́ kuyé, koro Rẽbékã ní ícázú ũdrí yị̃ị́ ĩbẽzú ni be ꞌî kị́dị́ gé. Rẽbékã ri Bẽtũwélẽ vé mvá ũkú, Bẽtũwélẽ ri Mĩlékã vé mvá, Mĩlékã ri Ãbũrámã ẹ́drị́pị Nãhórã vé ũkú. ");
INSERT INTO kbo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mvá ũkú rĩ ũnyĩ be ambamba, ĩri drĩ kácáŋá rú, ꞌbá ãzi la drĩ ĩri be kuyé. Mvá ũkú rĩ ní úlúzú mụzú kídí rĩ gé ꞌdãá, ĩri ní yị̃ị́ ĩbẽzú ívé ũdrí rĩ agá tré, ĩri ní ĩgõzú ímụ́zú ãtíꞌbá rĩ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ãtíꞌbá rĩ ní njuzú mụzú mvá ũkú rĩ vú ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mí ĩbẽ má ní yị̃ị́ mívé ũdrí agá ꞌdĩri sẽé mvụụ́.” ");
INSERT INTO kbo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mvá ũkú rĩ ní ꞌyozú kĩnĩ, “Úpí mávé rĩ, mí ẹ́ꞌyị́ yị̃ị́ rĩ mvụụ́.” Koro mvá ũkú rĩ ní ũdrí rĩ ọ́ꞌdụ́zú ꞌí kị́dị́ gé sĩ ꞌbãzú vũgá, ĩri ní yị̃ị́ rĩ ĩbẽzú sẽzú mvụzú ãtíꞌbá rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mvá ũkú rĩ kã yị̃ị́ rĩ sẽé mvụụ́ ãtíꞌbá rĩ ní, ĩri ní ꞌyozú kĩnĩ, “Ma kpá mụ yị̃ị́ ĩbẽ sẽ mvụ mívé kámĩlõ rĩ pi ní céré.” ");
INSERT INTO kbo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kúru ĩri ní yị̃ị́ ũdrí agá rĩ dãzú ꞌbụ́ ãnyãpá rĩ pi ní rizú yị̃ị́ mvụzú rĩ agá, ĩri ní njuzú mụzú vúlé kídí rĩ gé ꞌdãá yị̃ị́ ãzi ĩbẽzú dị̃ị́, ẹ́cị́ yị̃ị́ rĩ ũbẽ, kámĩlõ rĩ pi ãrẽvú céré mvụkí yị̃ị́ rĩ caá rá. ");
INSERT INTO kbo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ãtíꞌbá rĩ újí kuú kíri, tẽ rií tã Rẽbékã ní rií ꞌoó ꞌdĩri ndreé, lẽ nị̃ị́ ámá dõ mvá ũkú Úpí Múngú ní ĩpẽé rĩ adriípi ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kámĩlõ rĩ pi kâ yị̃ị́ rĩ mvụụ́ dẹẹ́ gí, ãtíꞌbá rĩ ní mãpí dábũ rú ãjẽ be ãmbúgú ni íꞌdụ́zú suzú mvá ũkú rĩ ã ụ̃mvụ gé, ĩri ní ímvẽ dábũ rú ãjẽ be ãmbúgú ni pi íꞌdụ́zú ị̃rị̃, ũꞌyĩzú mvá ũkú rĩ drị́gé. ");
INSERT INTO kbo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ãtíꞌbá rĩ ní mvá ũkú rĩ zịzú kĩnĩ, “ꞌÍ lũ má ní, mi ãꞌdi ã mvá? Mí ẹ́tẹ́pị vé jó agá ꞌdãá, vũrã ꞌbá ní mụzú lazú ị́nị́ŋá nõri sĩ mávé ãgõ nõꞌbée be ni anigé?” ");
INSERT INTO kbo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mvá ũkú rĩ ní újázú kĩnĩ, “Ma Bẽtũwélẽ ã mvá, Bẽtũwélẽ vé ẹ́ndrẹ́pị Mĩlékã ꞌi, ĩrivé ẹ́tẹ́pị Nãhórã ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ĩri ní kpá gõzú ꞌyozú kĩnĩ, “Vũrã ĩmi ní lazú mívé ꞌbá rĩ pi be ị́nị́ŋá rĩ sĩ ni anigé, ásé, ãzini ãnyãngã ã fífí kámĩlõ rĩ pi úcézú ni anigé.” ");
INSERT INTO kbo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kúru ãtíꞌbá rĩ ní kũmũcí ũtị̃zú ꞌî drị̃ sị̃zú vũgá, ĩri ní Úpí Múngú ri ị̃njị̃zú, ");
INSERT INTO kbo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ĩri ní ꞌyozú kĩnĩ, “Ẽ íngúkí Úpí Múngú mávé ãmbúgú Ãbũrámã vé rĩ íngúngũ, Úpí Múngú ꞌbã lẽngárá, ãzini ꞌdụ tã ꞌí ní lẽé ꞌoó mávé ãmbúgú ní rĩ ngaá gí, ãꞌdiãtãsĩyã íjị́ ma ícá mávé ãmbúgú rĩ vé máríté rĩ pi vé jó ãsámvú gé gí.” ");
INSERT INTO kbo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rẽbékã ní njuzú mụzú tã ꞌdĩri ũlũzú ꞌbá riꞌbá adriꞌbá ẹ́ndrẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rẽbékã vé ẹ́drị́pị ã rụ́ Lãbánã ꞌi, Lãbánã ní njuzú mụzú ãtíꞌbá rĩ vúgá kídí gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lãbánã kã mãpí ọ́mvụ́pị ã ụ̃mvụ gé rĩ ndreé, ãzini ímvẽ ĩri drị́gé rĩ ndreé, kã tã ãtíꞌbá rĩ ní átá, Rẽbékã ní ũlũú ꞌí ní rĩ yịị́, ĩri ní ꞌdezú mụzú ágó rĩ vúgá ꞌdãá, ị́sụ́ tu pá kuú ívé kámĩlõ rĩ pi be kídí rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lãbánã ní ꞌyozú kĩnĩ, “Mí ímụ́, Úpí Múngú sẽ mí ní tãkíri gí, ngá mí ní pá tuzú kuú ãmvé nõgó rĩ ãꞌdi? Má údé mí ní vũrã jó agá ꞌdãá gí, ãzini má údé kpá vũrã mívé kámĩlõ rĩ pi ní gí.” ");
INSERT INTO kbo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kúru ãtíꞌbá rĩ ní ꞌdezú mụzú Lãbánã vé ãngá ꞌdãá, Lãbánã vé ãtíꞌbá rĩ pi ní ọgụ kámĩlõ rĩ pi ã úgóró gá rĩ pi ọyụzú. Kộpi ní ásé, ãzini ãnyãngã ã fífí íjị́zú sẽzú kámĩlõ rĩ pi ní, ãzini kộpi ní yị̃ị́ íjị́zú sẽzú ãtíꞌbá rĩ ní, ãzini ĩrivé ꞌbá rĩ pi ní, kộpi ã ũjĩkí rí ĩ pá ãní. ");
INSERT INTO kbo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kúru ĩ ní ínyá íjị́zú ꞌbãzú kộpi ẹndrẹtị gé, ꞌbo ãtíꞌbá rĩ ní ꞌyozú kĩnĩ, “Má ũlũ dõ tã má ní ímụ́zú rĩ kuyé, má ícó drĩ ãꞌyĩí ínyá nyaá ku.” Lãbánã ní ꞌyozú kĩnĩ, “Mí ũlũ ꞌbá ní tã rĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ágó rĩ ní ꞌyozú kĩnĩ, “Ma ãtíꞌbá Ãbũrámã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Úpí Múngú sẽ tãkíri mávé ãmbúgú rĩ ní ambamba, ĩri ꞌbá ãꞌbú be ni. Úpí Múngú sẽ ĩri ní kãbĩlõ, ndrị̃ị́, tị́, kámĩlõ, dõngí, dábũ, aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni pi, ãtíꞌbá ãgõ rú ni pi, ãtíꞌbá ũkú rú ni pi be. ");
INSERT INTO kbo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mávé ãmbúgú rĩ vé ũkú Sárã tị ĩri ní mvá ágó, ị́sụ́ ãkũdẽ ĩri ãrãkã rú, ãmbúgú mávé rĩ sẽ ívé ngá ãrẽvú céré ívé mvá ágóŋá rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ãmbúgú mávé rĩ sẽ ma ũyõ sõó ꞌí ẹndrẹtị gé kĩnĩ, ‘Lẽ mî je mâ mvọ́pị ní ũkú ãngũ Kãnánã vé má ní adrizú nõri agá ku. ");
INSERT INTO kbo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ꞌÍ mụ ũkú rĩ jeé mâ mvọ́pị ní máríté mávé rĩ pi ãsámvú gé, má ẹ́tẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé.’ ");
INSERT INTO kbo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Má ní mávé ãmbúgú ri zịzú, má kĩnĩ, ‘Mvá ũkú rĩ gã dõ ímụ́gá má be sĩ, mâ ꞌo rí íngóni?’ ");
INSERT INTO kbo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ãbũrámã ní újázú má ní kĩnĩ, ‘Úpí Múngú má ní rií ĩrivé tã ꞌdụụ́ ngaá rĩ, ĩri ívé mãlãyíkã ĩpẽ ímụ́ mî ĩzã ko rá, mî mụ rí ũkú jeé mâ mvọ́pị ní mávé máríté rĩ pi ãsámvú gé, má ẹ́tẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ꞌÍ mụ dõ mávé máríté rĩ pi ãsámvú gé ꞌdãlé rá, kộpi gãkí dõ ũkú sẽgá mâ mvọ́pị ní sĩ, ma mi ọyụ ũyõ mí ní sõó má ẹndrẹtị gé rĩ agásĩ rá.’ ");
INSERT INTO kbo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ãndrũ má kã té ícá kídí rĩ tị gé ꞌdãá, á zị Múngú ri, má kĩnĩ, ‘Á Úpí Múngú mávé ãmbúgú Ãbũrámã vé rĩ, dõ ícó rá, lẽ mî sẽ mávé ẹ̃cị̃ nõri ã adri drị̃lé múké rú. ");
INSERT INTO kbo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ꞌÍ ndre, á tu pá kuú kídí rĩ ã gãrã gá nõ. Mvá ũkú ãzi ímụ́ dõ yị̃ị́ ĩbẽé, ma ꞌyo ĩri ní, “Mí ĩbẽ má ní yị̃ị́ mívé ũdrí agá ꞌdĩri sẽé mvụụ́,” ");
INSERT INTO kbo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mvá ũkú rĩ ꞌyo dõ má ní, “Mí ẹ́ꞌyị́ yị̃ị́ rĩ mvụụ́, ma kpá yị̃ị́ ũbẽ sẽ mívé kámĩlõ rĩ pi ní rá,” Úpí Múngú, mvá ũkú ꞌdĩri ã adri ũkú mí ní ĩpẽé mávé ãmbúgú rĩ vé mvá ní rĩ.’ ");
INSERT INTO kbo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Má kã drĩ Múngú ri zịị́ dẹẹ́ ẹ́sị́sị́lé sĩ kuyé, koro Rẽbékã ní ícázú ũdrí be ꞌî kị́dị́ gé. Ĩri ní úlúzú mụzú kídí rĩ gé ꞌdãá, ĩri ní yị̃ị́ ĩbẽzú. Má ní ꞌyozú ĩri ní, ‘ꞌÍ sẽ má ní yị̃ị́ mvụụ́.’ ");
INSERT INTO kbo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Koro mvá ũkú rĩ ní ívé ũdrí ọ́ꞌdụ́zú ꞌî kị́dị́ gé sĩ vũgá, ĩri ní ꞌyozú kĩnĩ, ‘Mí ẹ́ꞌyị́ yị̃ị́ rĩ mvụụ́, ma kpá yị̃ị́ sẽ mvụ mívé kámĩlõ rĩ pi ní ĩndĩ.’ Má ní kúru yị̃ị́ rĩ ẹ́ꞌyị́zú mvụzú, ĩri ní kpá yị̃ị́ sẽzú mvụzú kámĩlõ rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Má ní mvá ũkú rĩ zịzú, ‘Mi ãꞌdi ã mvá?’ “Ĩri ní ꞌyozú kĩnĩ, ‘Ma Bẽtũwélẽ ã mvá, Bẽtũwélẽ ri Nãhórã ã mvá, ĩrivé ẹ́ndrẹ́pị Mĩlékã ꞌi.’ “Má ní kúru mãpí íꞌdụ́zú suzú ụ̃mvụ ni gé, ãzini má ní ímvẽ íꞌdụ́zú ị̃rị̃ ũꞌyĩzú drị́ ni gé. ");
INSERT INTO kbo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kúru má ní kũmũcí ũtị̃zú mâ drị̃ sị̃zú vũgá, Úpí Múngú ri ị̃njị̃zú. Má ní Úpí Múngú mávé ãmbúgú Ãbũrámã vé rĩ íngúzú, ãꞌdiãtãsĩyã íjị́ ma pịrị ícá ũkú ị́sụ́ mávé ãmbúgú rĩ vé mvá ní, mvá ũkú rĩ ĩri mávé ãmbúgú Ãbũrámã ẹ́drị́pị Nãhórã mvọ́pị vé mvá. ");
INSERT INTO kbo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Mi dõ ẹ́sị́ múké ꞌbã mávé ãmbúgú rĩ ní rá, ãzini mi dõ tã mí ní lẽé ꞌoó mávé ãmbúgú ní rĩ ꞌdụ nga rá, ꞌí lũ má ní, dõ ꞌdíni kuyé, ꞌí lũ má ní, mâ ndã rí lẹ́tị ãzi tã má ní lẽé rĩ ꞌozú.” ");
INSERT INTO kbo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lãbánã pi Bẽtũwélẽ be, kộpi ní újázú kínĩ, “Tã ꞌdĩri íngá Úpí Múngú vúgá, tã ãzi ꞌbá ní ꞌyoó túngú ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rẽbékã ri ꞌdĩ, ꞌí jị ĩri mụzú mívé ãmbúgú rĩ vé mvá ní ũkú rú, sụ̃ Úpí Múngú ní ꞌyoó rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ãbũrámã vé ãtíꞌbá rĩ kã tã kộpi ní ꞌyoó ꞌdĩri yịị́, ĩri ní kũmũcí ũtị̃zú, ọ̃vụ̃zú ꞌî drị̃ sị̃zú vũgá, Úpí Múngú ri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ĩri ní kúru ngá ĩ ní rií ũꞌyĩí rụ́ꞌbá gá ĩ ní údé dábũ sĩ, ãzini ĩ ní údé aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni sĩ rĩ pi íꞌdụ́zú, ãzini bõngó ũnyĩ be ni pi íꞌdụ́zú sẽzú Rẽbékã ní. Ĩri ní kpá ngá ãjẽ be ãmbúgú ni pi íꞌdụ́zú sẽzú Rẽbékã ẹ́drị́pị ní, ãzini ẹ́ndrẹ́pị ní fẽfẽ rú. ");
INSERT INTO kbo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kúru ãtíꞌbá rĩ, ãgõ adriꞌbá ĩri be trụ́ rĩ pi be, kộpi ní ínyá nyazú, ãzini ngá mvụzú, kộpi áwíkí adrií ꞌdãlé ị́nị́ be rã. Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị, Ãbũrámã vé ãtíꞌbá rĩ ní ꞌyozú kĩnĩ, “Ĩmi ọyụkí ma, lẽ mâ gõ mávé ãmbúgú rĩ vúgá ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ꞌBo Rẽbékã ẹ́drị́pị pi ẹ́ndrẹ́pị be, kộpi ní újázú kínĩ, “Lẽ mvá ũkú rĩ ã adri caá ꞌbá be nõgó ụ́ꞌdụ́ be mụdrị́, ĩri íbí mụ ndõ.” ");
INSERT INTO kbo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ꞌBo ãtíꞌbá rĩ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi ugakí ma ku. Ẹ̃cị̃ mávé nõri agá, Úpí Múngú sẽ má ní drị̃lé múké gí. Ĩmi ọyụkí ma, á lẽ gõó vúlé mávé ãmbúgú rĩ vúgá ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kộpi ní ꞌyozú kínĩ, “Lẽ ꞌbâ zịkí Rẽbékã ri, ĩri dõ ꞌyo ꞌbá ní íngóni.” ");
INSERT INTO kbo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kộpi ní Rẽbékã ri zịzú ímụ́zú, kộpi ní ĩri zịzú kínĩ, “Mí ãꞌyĩ mụụ́ ágó ꞌdĩri be sâŋá nõri sĩ rá?” Rẽbékã ní ꞌyozú kĩnĩ, “Ma mụ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kúru kộpi ní ĩ ọ́mvụ́pị Rẽbékã pi ọyụzú ívé ãtíꞌbá ũkú rú ni be, ãtíꞌbá Ãbũrámã vé rĩ be, ãgõ adriꞌbá ĩri be trụ́ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kộpi ní Rẽbékã ní tãkíri sẽzú, kộpi ní ꞌyozú kínĩ, “ꞌBá ọ́mvụ́pị, lẽ mî tị ízú kárákará, lẽ anji mívé rĩ pi ã ndẽkí ĩvé ariꞌba rĩ pi vé ũkpõ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kúru Rẽbékã pi ívé ãtíꞌbá ũkú rú rĩ pi be, kộpi ní útụ́zú ĩvé kámĩlõ rĩ pi drị̃gé, kộpi ní ꞌdezú mụzú ãtíꞌbá rĩ vúgá sĩ. Ãbũrámã vé ãtíꞌbá rĩ jị Rẽbékã ri mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Sâ ꞌdãri gé, Ĩsákã íbí ímụ́ kídí ĩ ní zịị́ Bẽrẽ Lãyĩ Róyĩ gélésĩla, ãꞌdiãtãsĩyã ri adrií Nẽgévẽ gá. ");
INSERT INTO kbo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ũndréŋá ãzi sĩ, Ĩsákã ꞌde mụụ́ ásé agá ꞌdãá Múngú ri zịị́, kã mụụ́ ꞌî drị̃ ingaá ãngũ ndreé, ndre kámĩlõ ụrụkọꞌbée ri ímụ́ ꞌí vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rẽbékã ní kpá ꞌî drị̃ ingazú ụrụ, ĩri ní Ĩsákã ri ndrezú. Ĩri ní ísị́zú ívé kámĩlõ drị̃gé sĩ vũgá. ");
INSERT INTO kbo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ĩri ní ívé ãtíꞌbá rĩ zịzú kĩnĩ, “Ágó ásé agá riípi ímụ́pi ꞌbá vúgá nõó ꞌdãri ãꞌdi ꞌi?” Ãtíꞌbá rĩ ní újázú kĩnĩ, “Ágó ꞌdãri, ĩri mávé ãmbúgú.” Rẽbékã ní kúru ívé bõngó íꞌdụ́zú ꞌî ẹndrẹtị ọ̃zụ̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ãtíꞌbá rĩ ní tã ꞌí ní ꞌoó rĩ ũlũzú Ĩsákã ní céré. ");
INSERT INTO kbo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ĩsákã ní Rẽbékã ri jịzú fizú gãkũ ẹ́ndrẹ́pị Sárã ní ándúrú adrizú rĩ agá ꞌdãá ꞌí ní ũkú rú. Ĩsákã lẽ Rẽbékã ri ambamba. Ĩsákã ẹ́ndrẹ́pị Sárã ã drã dõ gí drãáãsĩyã, Rẽbékã ã tã sĩ, sẽ ĩzãngã Ĩsákã ẽ ẹ́sị́ agá rĩ dẹ rá. ");
INSERT INTO kbo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ãbũrámã gõ ũkú ãzi jeé rá, ũkú rĩ ã rụ́ Kẽtúrã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ũkú rĩ tị ĩri ní Zĩmĩránĩ ri, Jõkĩsánã ri, Mẽdánã ri, Mĩdĩyánã ri, Ĩsĩbákã ri, Súwã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jõkĩsánã tị Sébã pi Dẽdánã be. Úyú Dẽdánã vé rĩ pi Ãsũrímũ rĩ pi, Lẽtũsímũ rĩ pi, ãzini Lẽũmímũ rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Anji ãgõ Mĩdĩyánã vé rĩ pi ã rụ́, Éfã ꞌi, Ẽférẽ ꞌi, Ẽnókã ꞌi, Ãbídã ꞌi, Ẽlédã sĩ. Úyú ꞌdĩꞌbée céré Kẽtúrã vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ãbũrámã ẹzị ngá ívé rĩ pi ãrẽvú céré Ĩsákã ní. ");
INSERT INTO kbo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ãbũrámã ní drĩ adrizú ídri rú rĩ gé, íꞌdụ́ ngá sẽé fẽfẽ rú ívé anji ãgõ ũkú vúlé rĩ pi ní tịị́ rĩ pi ní, pẽ ívé anji ãgõ ꞌdĩꞌbée Ĩsákã ã gãrã gá sĩ mụụ́ adrií wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ãbũrámã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni tọ̃wụ́ (175). ");
INSERT INTO kbo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ãbũrámã drã, ị́sụ́ ãkũdẽ dẽ ícá ãrãkã rú gí, adri caá ílí be ãco. Ĩrivé ídri kã fũú, índrí ĩrivé rĩ mụ adrií ĩrivé ꞌbá ũdrãꞌbá gí rĩ pi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ĩrivé anji ãgõ Ĩsákã pi Ĩsĩmãélẽ be, kộpi ní ĩrivé ãvũ jịzú sị̃zú ụ̃jị́ agá Mãkãpélã gá, ĩnyiŋá Mãmúrẽ be, nyọ̃ọ́kụ́ Ẽfõrónã Zõhárã mvọ́pị vé rĩ agá, Zõhárã ri Hị́tị̃gú. ");
INSERT INTO kbo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ãbũrámã je ándúrú nyọ̃ọ́kụ́ rĩ ꞌbá Hị́tị̃ vé rĩ pi drị́gé. Sị̃kí Ãbũrámã pi ũkú ni Sárã be nyọ̃ọ́kụ́ rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ãbũrámã kã drãá, Múngú sẽ mvọ́pị Ĩsákã ní tãkíri rá. Ĩsákã ri adrií ĩnyiŋá Bẽrẽ Lãyĩ Róyĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ĩsĩmãélẽ ri mvá Ãbũrámã vé ni, Sárã vé ãtíꞌbá Ãgárã Ẽjẽpétõzị́ rĩ tị ĩri nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Anji Ĩsĩmãélẽ ní tịị́ rĩ pi ã rụ́ ꞌdĩ, sĩkí kộpi ã rụ́ tịngárá ĩvé rĩ vú sĩ. Mvá kãyú rĩ Nẽbãyótĩ ꞌi, ꞌdeꞌbá vụ́drị̃ ni gé rĩ pi, Kẽdárã ꞌi, Ãdĩbélã ꞌi, Mĩbĩsámã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mĩsímã ꞌi, Dúmã ꞌi, Másã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hãdádĩ ꞌi, Témã ꞌi, Jẽtúrã ꞌi, Nãpísã ꞌi, Kẽdémã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Anji Ĩsĩmãélẽ vé mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée, kộpi rụkí sụ́rụ́ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi nĩ. ꞌDakí vũrã kộpi ní adrizú rĩ pi kộpi ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ĩsĩmãélẽ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na drị̃ ni ẹ́zị̂rị̃ (137), ĩri ní kúru drãzú, ĩri ní mụzú adrizú ꞌbá ívé ũdrãꞌbá gí rĩ pi ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Úyú Ĩsĩmãélẽ vé rĩ pi írékí ĩ mụzú ãngũ rĩ pi agásĩ ãndíãndí, íꞌdózú Hãvílã gá, cazú Sụ́rụ̃ gé, cazú ĩnyiŋáŋá Ẽjẽpétõ ã wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé, wọ̃ọ́kọ̃ Ãsírĩyã vé rĩ gé. Kộpi rikí adrií ĩ ẹ́drị́pị́ị be ĩnyiŋá ĩnyiŋá. ");
INSERT INTO kbo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Úꞌdógúꞌdógú Ĩsákã vé rĩ ĩri ꞌdíni, Ĩsákã ri mvá Ãbũrámã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ĩsákã ní Rẽbékã ri jezú rĩ gé, ị́sụ́ ãkũdẽ Ĩsákã ri ílí be pụ̃kụ́ sụ. Rẽbékã ri Bẽtũwélẽ Ãrámãgú rĩ vé mvá, ãngũ Pãdãnã Ãrámã vé rĩ agá, ĩri Lãbánã Ãrámãgú rĩ vé ọ́mvụ́pị. ");
INSERT INTO kbo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rẽbékã ní drĩ mvá tịị́ kuyé rĩ sĩ, Ĩsákã zị Úpí Múngú ri, Úpí Múngú ãꞌyĩ ĩrivé zịngárá rá, ĩrivé ũkú Rẽbékã ị́sụ́ ꞌa rá. ");
INSERT INTO kbo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Anjiŋá rĩ pi rikí ĩ úgbú Rẽbékã agá ꞌdãá. Rẽbékã ní Úpí Múngú ri zịzú kĩnĩ, “Tã nõri ꞌi ꞌo má be nóni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Úpí Múngú ní ꞌyozú ĩri ní kĩnĩ, “Anji mí ꞌa gá rĩ pi ị̃rị̃, anji ị̃rị̃ ꞌdĩꞌbée ímụ́ ĩ aco adri sụ́rụ́ be ị̃rị̃, sụ́rụ́ ãzi rĩ vé ũkpõ ri ímụ́ ãzi rĩ vé rĩ ndẽ rá, mvá kãyú rĩ ímụ́ ẹ̃zị́ nga mvá ụ̃dụ́ rĩ ní.” ");
INSERT INTO kbo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rẽbékã vé sâ tĩngárá vé rĩ kã ícó, tị anji rĩ pi ẹ̃tị́ rú. ");
INSERT INTO kbo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mvá ĩfũúpi drị̃drị̃ rĩ ika, rụ́ꞌbá ni céré ꞌbí rú, kúru kộpi ní ĩri ã rụ́ ꞌdazú Ị́sọ̃wụ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kúru ẹ́drị́pị ní ĩfũzú, rụ ẹ́drị́pị Ị́sọ̃wụ̃ ã pá ẽdẽkẽdẽ cí, kúru ĩ ní ĩri ã rụ́ ꞌdazú Yõkóbũ ꞌi. Rẽbékã ní anji ꞌdĩꞌbée tịzú rĩ gé, ị́sụ́ ãkũdẽ Ĩsákã ri ílí be pụ̃kụ́ ázíyá. ");
INSERT INTO kbo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Anji rĩ pi kâ mbaá ícá ãmbúgú gí, Ị́sọ̃wụ̃ ícá ꞌbá riípi zãá mbãápi ni, lẽ ẹ̃cị̃ ásé vé rĩ ã tã ambamba. Yõkóbũ ri ívé rĩ ꞌbá adriípi tã be kíri ni, ĩri ri adri ꞌbẹ̃tị́, ri ãnyãpá úcé. ");
INSERT INTO kbo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ĩsákã lẽ Ị́sọ̃wụ̃ ri, ãꞌdiãtãsĩyã ĩri ní rií zãá úꞌdị́ íjị́ nyaá ꞌí ní rĩ ã tã sĩ, ꞌbo Rẽbékã lẽ ívé rĩ Yõkóbũ ri. ");
INSERT INTO kbo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ụ́ꞌdụ́ ãlu, Yõkóbũ ri tĩbũ áꞌdí, tĩbũ rĩ ã sụ́ ika. Ị́sọ̃wụ̃ ímụ́ ásé agá ꞌdãásĩ, ẹ̃bị́rị́ fụ ĩri káyĩ, ãndẽ ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ĩri ní ꞌyozú Yõkóbũ ní kĩnĩ, “Ẹ̃bị́rị́ fụ ma drãá káyĩ gí! ꞌÍ sẽ má ní tĩbũ mí ní áꞌdí sụ́ be ika ꞌdĩri nyaá!” (Tã ꞌdĩri sĩ, gõkí Ị́sọ̃wụ̃ ã rụ́ ꞌdaá Ẽdómã.) ");
INSERT INTO kbo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yõkóbũ ní újázú ĩri ní kĩnĩ, “Mi mvá kãyú, mí ụzị mívé kãyú má ní.” ");
INSERT INTO kbo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ị́sọ̃wụ̃ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ ndre drĩ ká, ẹ̃bị́rị́ fụ ma káyĩ gí, á lẽ drãá ãní drãdrã! Ã tịkí dõ ma kãyú drãáãsĩyã, tã múké má ní ị́sụ́ ꞌa ni gé ꞌdĩgé rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yõkóbũ ní ꞌyozú ĩri ní kĩnĩ, “Drị̃drị̃ ni, ꞌí sõ ũyõ má ẹndrẹtị gé.” Kúru Ị́sọ̃wụ̃ ní ũyõ sõzú Yõkóbũ ẹndrẹtị gé, ĩri ní ívé kãyú ụzịzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kúru Yõkóbũ ní pánga íꞌdụ́zú tĩbũ ꞌí ní áꞌdí rĩ be, ĩri ní sẽzú Ị́sọ̃wụ̃ ní, Ị́sọ̃wụ̃ ní nyazú, ĩri ní kpá ngá mvụzú, ĩri ní kúru ngazú mụzú. Ị́sọ̃wụ̃ ꞌdụ ívé kãyú ã tã ꞌbãá mãdãŋá, ụ̃sụ̃ drị̃ ni gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ẹ̃bị́rị́ ní ꞌdezú ãngũ rĩ agá ũnjí ũnjí, sụ̃ ĩri ní ọ́tụ́ ꞌdeé lókí Ãbũrámã vé rĩ gé rĩ tị́nị. Ĩsákã ní ꞌdezú mụzú Ãbũmẽlékẽ vúgá, Ãbũmẽlékẽ ri ꞌbãgú Fẽlẽsétẽ rĩ pi vé ni, ãngũ Gẽrárĩ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Úpí Múngú ní ꞌi iꞌdazú Ĩsákã ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Lẽ mî mụ Ẽjẽpétõ gá ꞌdãá ku, mí adri vũrã má ní lẽé lũú mí ní rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mí adri vũrã ꞌdĩri agá ũkõlõ. Ma adri mí be trụ́, ma mí ní tãkíri sẽ rá. Ma ãngũ ꞌdĩri sẽ céré mí ní, ãzini úyú mívé rĩ pi ní, sụ̃ má ní ọ́tụ́ ũyõ ni sõó mí ẹ́tẹ́pị Ãbũrámã ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ma sẽ mívé úyú ri ízú kárákará, kộpi adri sụ̃ línyã ꞌbụ̃ gé rĩ pi tị́nị. Ma ãngũ ꞌdĩri sẽ céré kộpi ní. ꞌBá vũ drị̃gé rĩ pi céré tãkíri ị́sụ́ úyú mívé rĩ pi ã tã sĩ, ");
INSERT INTO kbo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ãꞌdiãtãsĩyã Ãbũrámã ị̃njị̃ ma ị̃njị̃njị̃, ꞌdụ tã má ní lũú ꞌí ní rĩ ngaá rá, ꞌdụ tã má ní ẹzịị́ rĩ ngaá rá, ãzini ꞌdụ tãị́mbị́ mávé rĩ ngaá rá.” ");
INSERT INTO kbo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kúru Ĩsákã ní adrizú ãngũ Gẽrárĩ vé rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ãgõ ãngũ ꞌdãri agá rĩ pi kâ ĩri zịị́ ĩrivé ũkú ã tã sĩ, ꞌyo kộpi ní kĩnĩ, ũkú rĩ ꞌí ọ́mvụ́pị, gã lũgá sĩ ꞌyozú kínĩ ũkú rĩ ívé ni, ãꞌdiãtãsĩyã ꞌo ụ̃rị̃ sĩ. Ụ̃sụ̃ kĩnĩ ãgõ ꞌdĩꞌbée ꞌi ꞌdị rá Rẽbékã ã tã sĩ, ãꞌdiãtãsĩyã Rẽbékã ri ũnyĩ be ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ĩsákã kã adrií caá ꞌdãá sâ be ãco, Ãbũmẽlékẽ ꞌbãgú Fẽlẽsétẽ rĩ pi vé rĩ ri ãngũ ndreé sũbâ gá sĩ, ndre Ĩsákã uꞌde ũkú ni Rẽbékã ri ẹzịị́ bẹ̃drị̃ sĩ, ri tị ni ndruú. ");
INSERT INTO kbo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ãbũmẽlékẽ ní Ĩsákã ri zịzú ímụ́zú, ĩri ní ꞌyozú kĩnĩ, “Mí kĩnĩ, Rẽbékã ri mí ọ́mvụ́pị ãꞌdiãtãsĩ? Ị́sụ́zú ãkũdẽ ĩri mívé ũkú!” Ĩsákã ní újázú ĩri ní kĩnĩ, “Má ụ̃sụ̃ déna ꞌbá ãzi ri ícó ma ꞌdị Rẽbékã ã tã sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ãbũmẽlékẽ ní ꞌyozú kĩnĩ, “Ngá mí ní ꞌoó ꞌbá ní ꞌdíni rĩ ãꞌdi? ꞌBá ãzi ri té ícó la mívé ũkú sĩ, ĩri té tã ũnjí íjị́ ꞌbá drị̃gé.” ");
INSERT INTO kbo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kúru Ãbũmẽlékẽ ní tãị́mbị́ sẽzú ꞌbá rĩ pi ní céré kĩnĩ, “ꞌBá ãzi ꞌo dõ Ĩsákã ri ũnjí, dõku úló dõ Rẽbékã ã rụ́ꞌbá, ĩ ĩri ꞌdị drã ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ílí ꞌdãri agá, Ĩsákã ꞌã ọ́mvụ́, sa úri ꞌa ni gé, ãnyãngã rĩ ka ambamba, ãꞌdiãtãsĩyã Úpí Múngú sẽ ĩri ní tãkíri gí. ");
INSERT INTO kbo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ĩsákã gõ ícá ꞌbá ãꞌbú be ni, ĩrivé ãꞌbú ízú ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ĩri kãbĩlõ be, ndrị̃ị́ be, tị́ be, ãtíꞌbá be kárákará. ꞌBá Fẽlẽsétẽ vé rĩ pi ꞌbãkí ĩri ní ẹ́sị́ ũnjí ãnyãpá ꞌdĩꞌbée ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kídí ãtíꞌbá Ãbũrámã vé rĩ pi ní gaá sâ ꞌdãri gé rĩ pi, ꞌbá Fẽlẽsétẽ vé rĩ pi gakí nyọ̃ọ́kụ́ úmvú dãá kídí rĩ ọ́tụ́zú ãní ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kúru Ãbũmẽlékẽ ní ꞌyozú Ĩsákã ní kĩnĩ, “Mívé ũkpó nóni ambamba, ꞌí nga ꞌbá gãrã gá sĩ, ꞌí mụ adrií vũrã ãzi gé.” ");
INSERT INTO kbo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kúru Ĩsákã ní ngazú mụzú adrizú ị́ꞌbụ́ŋá Gẽrárĩ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kídí ọ́tụ́ ĩ ní gaá lókí Ĩsákã ẹ́tẹ́pị Ãbũrámã vé rĩ gé, Fẽlẽsétẽ rĩ pi ní nyọ̃ọ́kụ́ gaá ọ́tụ́zú lókí Ãbũrámã ní drãzú gí rĩ ã vụ́drị̃ gé ꞌdãꞌbée, Ĩsákã gõ nyọ̃ọ́kụ́ rĩ úvá kộpi agásĩ ãmvé. Ĩsákã gõ rụ́ ãlu ãlu ọ́tụ́ Ãbũrámã ní ꞌdaá kídí rĩ pi ní ꞌdãꞌbée ꞌdaá kídí rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ĩsákã vé ãtíꞌbá rĩ pi gakí kídí ị́ꞌbụ́ŋá rĩ agá ꞌdãá, kídí rĩ vé yị̃ị́ uletere. ");
INSERT INTO kbo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ꞌBá kãbĩlõ úcéꞌbá Gẽrárĩ vé rĩ pi rikí ãgátá gãá Ĩsákã vé ꞌbá kãbĩlõ úcéꞌbá rĩ pi be, kộpi kínĩ, yị̃ị́ rĩ ĩvé ni. Kúru Ĩsákã ní yị̃ị́ rĩ ã rụ́ ꞌdazú Ẽsékẽ. (Ẽsékẽ vé ífífí ãgátá.) ");
INSERT INTO kbo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ĩsákã vé ãtíꞌbá rĩ pi ní kpá kídí ãzi gazú, kộpi gõkí kpá ãgátá gãá ꞌbá Gẽrárĩ vé rĩ pi be. Kúru Ĩsákã ní kídí rĩ ã rụ́ ꞌdazú Sítĩnã. ");
INSERT INTO kbo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ĩsákã gõ ngaá ꞌdãásĩ mụụ́ vũrã ãzi gé, kộpi gõkí kpá kídí ãzi gaá, ꞌbá ãzi gõ ãgátá gãá yị̃ị́ rĩ ã tã sĩ kuyé. Ĩsákã ní kídí rĩ ã rụ́ ꞌdazú Rẽbótõ. (Rẽbótõ vé ífífí, vũrã adriípi wãlã ni.) Ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú sẽ ꞌbá ní vũrã wãlã ni gí, ꞌbâ ícó drị̃lé múké ị́sụ́ vũrã nõri agá rá.” ");
INSERT INTO kbo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ĩsákã ní ngazú vũrã ꞌdãri gé sĩ, ĩri ní ꞌdezú mụzú Bẽrĩsébã gá. ");
INSERT INTO kbo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kã mụụ́ caá ị́nị́ŋá rĩ sĩ, Úpí Múngú iꞌda ꞌi ĩri ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Ma Múngú mí ẹ́tẹ́pị Ãbũrámã vé rĩ ꞌi. Mí adri ụ̃rị̃ sĩ ku, ãꞌdiãtãsĩyã ma mí be trụ́. Ma tãkíri sẽ mí ní rá, ma sẽ mívé úyú ri ízú kárákará mávé ãtíꞌbá Ãbũrámã ã tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ĩsákã ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú Úpí Múngú ri ị̃njị̃zú ãní. Ĩri ní ívé gãkũ sịzú ꞌdãgá, ĩrivé ãtíꞌbá rĩ pi ní kídí ãzi gazú vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ụ́ꞌdụ́ ãlu, ꞌbãgú Ãbũmẽlékẽ pi Ãhúzã riípi ĩri ẽ ĩzã koópi tã pịrị sĩ rĩ be, ũgalaku ãmbúgú ãngáráwá rĩ pi vé Pĩkólã be, ímụ́kí Gẽrárĩ gé ꞌdãásĩ Ĩsákã ri ndreé. ");
INSERT INTO kbo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ĩsákã ní kộpi zịzú kĩnĩ, “Ĩmi ímụ́kí nõgó ãꞌdi ꞌoó? Ándúrú ĩmi ndrekí ma ũnjí, ĩmi drokí ma ĩmi gãrã gá sĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kộpi ní újázú ĩri ní kínĩ, “ꞌBá nị̃kí ámá uletere ꞌyozú kínĩ, Úpí Múngú ri mí be trụ́, kúru ꞌbá ní átázú ꞌbá ãsámvú gé sĩ, ꞌbá kĩnĩ, ꞌbá lẽkí ũyõ sõó ꞌbá ãsámvú gé sĩ mí be. Kúru lẽ ꞌbâ rụkí ũndĩ mí be. ");
INSERT INTO kbo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Lẽ mî sõ ũyõ ꞌyozú kínĩ, mí ꞌo ꞌbâ ũnjí ku, sụ̃ ꞌbá ní mi ꞌoó ũnjí kuyé rĩ tị́nị. ꞌBá ꞌokí ándúrú mi múké, ꞌbá pẽkí mi mụzú ꞌbá gãrã gá sĩ ãmvé tã be kíri. Nóni Úpí Múngú sẽ mí ní tãkíri gí.” ");
INSERT INTO kbo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ĩsákã ní ụ̃mụ̃ údézú kộpi ní, kộpi nyakí ngá, ãzini mvụkí ngá rá. ");
INSERT INTO kbo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tị, Ĩsákã pi ní ũyõ sõzú ĩ ãsámvú gé sĩ ãgõ Gẽrárĩ vé rĩ pi be. Ĩsákã ní ãgõ ꞌdĩꞌbée ọyụzú mụzú tã be kíri. ");
INSERT INTO kbo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ụ́ꞌdụ́ ꞌdãri gé, Ĩsákã vé ãtíꞌbá rĩ pi ní ímụ́zú kídí ĩ ní gaá rĩ ã tã ũlũzú Ĩsákã ní kínĩ, “ꞌBá gakí yị̃ị́ ĩfũú gí.” ");
INSERT INTO kbo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kúru Ĩsákã ní kídí rĩ ã rụ́ ꞌdazú Síbã. (Rụ́ Síbã ꞌdĩri vé ífífí ũyõ.) Cĩmgbá ícázú ãndrũ sĩ, kụ̃rụ́ rĩ ã rụ́ ĩ zị Bẽrĩsébã. (Ífífí ni kídí ũyõ vé ni.) ");
INSERT INTO kbo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ị́sọ̃wụ̃ kã caá ílí be pụ̃kụ́ sụ, ĩri ní Yụ̃dị́tã ri jezú ꞌí ní ũkú rú, Yụ̃dị́tã vé ẹ́tẹ́pị ã rụ́ Bérĩ ꞌi, ĩri Hị́tị̃gú. Ĩri ní kpá gõzú ũkú ãzi jezú, rụ́ ni Bãsẽmátã ꞌi, ẹ́tẹ́pị ni Ẽlónĩ ꞌi, ĩri Hị́tị̃gú. ");
INSERT INTO kbo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ꞌBo ũkú Ị́sọ̃wụ̃ vé ꞌdĩꞌbée sẽkí Ĩsákã pi ní ĩzãngã ambamba ũkú ni Rẽbékã be. ");
INSERT INTO kbo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ĩsákã kã dẽé ícá ãrãkã rú gí, mị ni ẹ̃sị̃, ndre ãngũ ku, ĩri ní ívé mvá kãyú Ị́sọ̃wụ̃ ri zịzú ímụ́zú, ĩri ní ꞌyozú kĩnĩ, “Mâ mvá rĩ.” Ị́sọ̃wụ̃ ní ãꞌyĩzú kĩnĩ, “Ma nõ.” ");
INSERT INTO kbo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ĩsákã ní ꞌyozú kĩnĩ, “ꞌÍ ndre drĩ ká, á dẽ nóni gí, ụ́ꞌdụ́ má ní drãzú rĩ, á nị̃ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mí íꞌdụ́ mívé ụ̃sụ̃, mívé bõló be, ꞌí mụ má ní zãá mbãá ꞌbuú ásé agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mí áꞌdí zãá ẹ̃jị́ ẹ̃jị́ íjị́ sẽé má ní, á lẽ nyaá, mâ sẽé rí mí ní tãkíri, ị́sụ́ ãkũdẽ á drã drĩ kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ĩsákã kã rií átá ꞌî mvọ́pị Ị́sọ̃wụ̃ be, Rẽbékã tẽ nyo rí tã ꞌdĩri yịị́. Ị́sọ̃wụ̃ kã ngaá mụụ́ ásé agá ꞌdãá zãá rĩ ã mbãngárá gá gí, ");
INSERT INTO kbo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rẽbékã ní ꞌyozú ꞌî mvọ́pị Yõkóbũ ní kĩnĩ, “ꞌÍ ndre drĩ ká, á yị mí ẹ́tẹ́pị ri átá mí ẹ́drị́pị Ị́sọ̃wụ̃ be kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Mí áꞌdí má ní zãá ẹ̃jị́ ẹ̃jị́ ni, mí íjị́ mâ nya, mâ sẽ rí mí ní tãkíri Úpí Múngú ẹndrẹtị gé, ị́sụ́ ãkũdẽ á drã drĩ kuyé.’ ");
INSERT INTO kbo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Mâ mvá rĩ, ꞌí yị ma, ꞌí ꞌdụ tã má ní rií lũú mí ní nõri ngaá. ");
INSERT INTO kbo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ꞌÍ mụ ndrị̃ị́ rĩ pi ãsámvú gé ꞌdãá, mí íjị́ má ní ndrị̃ị́ ị̃rị̃ mbaꞌbá fõlõ ni pi, mâ áꞌdí rí zãá ẹ̃jị́ ẹ̃jị́ ni sẽé mí ẹ́tẹ́pị ní, sụ̃ mí ẹ́tẹ́pị ní lẽé rĩ tị́nị, ");
INSERT INTO kbo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","mî jị rí sẽé ĩri ní, ã nya rí, ã sẽ rí mí ní tãkíri, ị́sụ́ ãkũdẽ drã drĩ kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yõkóbũ ní ꞌyozú ẹ́ndrẹ́pị Rẽbékã ní kĩnĩ, “ꞌÍ nị̃ rá má ẹ́drị́pị Ị́sọ̃wụ̃ ã rụ́ꞌbá dụ céré kuú ꞌbí rú, ꞌbo mâ rụ́ꞌbá ꞌbí ãkó. ");
INSERT INTO kbo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Má ẹ́tẹ́pị ọ́mvụ́ dõ mâ rụ́ꞌbá, ícó nị̃ị́ ámá ꞌyoó kínĩ ma ri ꞌî mị ũꞌbã ꞌdíni ku? Ícó má ní tãkíri sẽé ku, ĩri ma tri rá.” ");
INSERT INTO kbo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ẹ́ndrẹ́pị ní ꞌyozú ĩri ní kĩnĩ, “Mâ mvá rĩ, mí ẹ́tẹ́pị tri dõ mi, tã ni ã sụ mâ rụ́ꞌbá gá. ꞌÍ ꞌdụ tã má ní ꞌyoó mí ní ꞌdĩri ngaá, ꞌí mụ ndrị̃ị́ rĩ pi íjị́ má vú nõó.” ");
INSERT INTO kbo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yõkóbũ ní kúru mụzú ndrị̃ị́ rĩ pi íjị́zú sẽzú ẹ́ndrẹ́pị ní, ẹ́ndrẹ́pị ní zãá rĩ áꞌdízú ẹ̃jị́ ẹ̃jị́ sụ̃ ẹ́tẹ́pị Ĩsákã ní lẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rẽbékã ní ívé mvá kãyú Ị́sọ̃wụ̃ vé bõngó múké múké jó agá ꞌdãá rĩ pi íꞌdụ́zú úsúzú ívé mvá ụ̃dụ́ Yõkóbũ rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Íꞌdụ́ ndrị̃ị́ lãꞌbú úmbé Yõkóbũ drị́gé, ãzini umbe ni adriípi ꞌbí ãkó rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ĩri ní zãá ꞌí ní áꞌdí ẹ̃jị́ ẹ̃jị́ rĩ íꞌdụ́zú pánga be, sẽzú Yõkóbũ drị́gé. ");
INSERT INTO kbo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yõkóbũ ní mụzú ẹ́tẹ́pị vúgá ꞌdãá, ĩri ní ĩri zịzú kĩnĩ, “Má ẹ́tẹ́pị.” Ĩsákã ní ãꞌyĩzú kĩnĩ, “Mâ mvá rĩ, ma nõ.” Ĩsákã ní ĩri zịzú kĩnĩ, “ꞌBá ꞌdĩri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yõkóbũ ní ꞌyozú ẹ́tẹ́pị ní kĩnĩ, “ꞌBá rĩ ma ꞌi Ị́sọ̃wụ̃ ꞌi, mívé mvá kãyú rĩ. Á ꞌdụ tã rĩ ngaá sụ̃ mí ní lũú má ní rĩ tị́nị gí. Mí íngá úrí ụrụ sĩ, ꞌí nya zãá má ní íjị́ mí ní nõri, ꞌí sẽ rí má ní tãkíri.” ");
INSERT INTO kbo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ĩsákã ní mvọ́pị ri zịzú kĩnĩ, “Mâ mvá rĩ, mí ị́sụ́ zãá rĩ mbẽlẽŋá ꞌdíni ngóni?” Yõkóbũ ní újázú kĩnĩ, “Úpí Múngú mívé rĩ sẽ má ní drị̃lé múké nĩ, má ní zãá rĩ ị́sụ́zú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kúru Ĩsákã ní ꞌyozú Yõkóbũ ní kĩnĩ, “Mâ mvá rĩ, mí ítrú mi ĩnyiŋá mâ gãrã gá nõó, mâ ọ́mvụ́ rí mî rụ́ꞌbá, mâ nị̃ rí ámá ádarú dõ mi Ị́sọ̃wụ̃ ꞌi, dõ mí adri Ị́sọ̃wụ̃ ꞌi ku.” ");
INSERT INTO kbo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yõkóbũ ní ꞌi útrúzú ĩnyiŋá ꞌí ẹ́tẹ́pị Ĩsákã vúgá ꞌdãá, Ĩsákã ní ĩri ã rụ́ꞌbá ọ́mvụ́zú, ĩri ní ꞌyozú kĩnĩ, “Ụ́ꞌdụ́kọ́ mívé rĩ ꞌụ sụ̃ Yõkóbũ vé rĩ tị́nị, ꞌbo mî drị́ ꞌbí be sụ̃ Ị́sọ̃wụ̃ vé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ĩsákã nị̃ Yõkóbũ ri ámá kuyé, ãꞌdiãtãsĩyã drị́ ni céré ꞌbí rú sụ̃ Ị́sọ̃wụ̃ vé rĩ tị́nị. Ĩri ní kúru tãkíri sẽzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ĩri ní zịzú kĩnĩ, “Ádarú ꞌbá rĩ nyo mí ꞌi mâ mvọ́pị Ị́sọ̃wụ̃ ꞌi?” Yõkóbũ ní újázú kĩnĩ, “ꞌBá rĩ ma ꞌi Ị́sọ̃wụ̃ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ĩsákã ní ꞌyozú kĩnĩ, “Mí íjị́ má ní zãá rĩ sẽé nyaá, mâ sẽ rí mí ní tãkíri.” Yõkóbũ ní zãá rĩ jịzú sẽzú ẹ́tẹ́pị ní, ẹ́tẹ́pị ní nyazú, ĩri ní kpá vị́nyọ̃ sẽzú ẹ́tẹ́pị ní, ẹ́tẹ́pị ní mvụzú. ");
INSERT INTO kbo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kúru ẹ́tẹ́pị Ĩsákã ní ꞌyozú ĩri ní kĩnĩ, “Mâ mvá rĩ, mí ítrú mi má gãrã gá nõó, mí ímụ́ mâ tị ndruú.” ");
INSERT INTO kbo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yõkóbũ ní mụzú ẹ́tẹ́pị Ĩsákã vúgá ꞌdãá, ĩri ní tị ni ndruzú. Ĩsákã kã ĩrivé bõngó ẽ ẹ̃jị́ ngụ̃ụ́, ĩri ní ꞌyozú kĩnĩ, “Á, mâ mvọ́pị ẽ ẹ̃jị́ ngụ̃ sụ̃ ọ́mvụ́ Úpí Múngú ní tãkíri ꞌbãá drị̃ ni gé gí rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Múngú ã sẽ mí ní ẹndrịlị́gọ́ ꞌbụ̃ gélésĩ, ã ꞌa mívé ãnyãngã drị̃gé vũ drị̃gé nõgó, mívé ãnyãngã ã ka rí ãní, ãzini mívé vị́nyọ̃ ã ꞌa rí ãní. ");
INSERT INTO kbo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Sụ́rụ́ ãndíãndí rĩ pi ã ngakí rí ẹ̃zị́ mí ní, kộpi ã ũtị̃kí kũmũcí mí ẹndrẹtị gé, kộpi adrikí ãtíꞌbá mívé ni. Mi adri ãmbúgú rú mí ẹ́drị́pị́ị drị̃gé, lẽ kộpi ã ũtị̃kí kũmũcí mí ẹndrẹtị gé, kộpi ã adrikí mî pálé gá. ꞌBá rĩ tri dõ mi, ĩ ĩri tri rá, ꞌBá rĩ sẽ dõ mí ní tãkíri, ĩ ĩri ní tãkíri sẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ĩsákã kã tãkíri sẽé Yõkóbũ ní gí, Yõkóbũ kã ngaá mụụ́ ẹ́tẹ́pị ã gãrã gá sĩ, koro ẹ́drị́pị Ị́sọ̃wụ̃ ní ícázú zãá mbãngárá gálésĩ. ");
INSERT INTO kbo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ị́sọ̃wụ̃ ní kpá ínyá áꞌdízú zãá sĩ ẹ̃jị́ ẹ̃jị́, ĩri ní jịzú sẽzú ẹ́tẹ́pị ní, ĩri ní ꞌyozú kĩnĩ, “Má ẹ́tẹ́pị, mí íngá úrí ụrụ sĩ, ꞌí nya zãá má ní áꞌdí íjị́ mí ní nõri, ꞌí sẽ rí má ní tãkíri.” ");
INSERT INTO kbo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ĩsákã ní zịzú kĩnĩ, “ꞌBá rĩ ãꞌdi ꞌi?” Ị́sọ̃wụ̃ ní újázú kĩnĩ, “ꞌBá rĩ ma ꞌi Ị́sọ̃wụ̃ ꞌi, mívé mvá kãyú rĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ĩsákã ã rụ́ꞌbá yã kpĩríkpĩrí, ĩri ní zịzú kĩnĩ, “ꞌBá té zãá áꞌdípi íjị́pi má ní nõgó rĩ ãꞌdi ꞌi? Á nya zãá rĩ úꞌdíkírĩŋá nõgó, ị́sụ́ ãkũdẽ mí ícá drĩ kuyé, á sẽ tãkíri ĩri ní gí. Tãkíri má ní sẽé gí rĩ, ícókí újá gõó vúlé ku.” ");
INSERT INTO kbo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ị́sọ̃wụ̃ kã tã ẹ́tẹ́pị ní ꞌyoó ꞌdĩri yịị́, ĩri ní rizú ngozú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá ĩzãngã ĩzãngã rú, ĩri ní ꞌyozú kĩnĩ, “Má ẹ́tẹ́pị, lẽ mî sẽ má ní tãkíri rĩ ĩndĩ!” ");
INSERT INTO kbo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ĩsákã ní ꞌyozú Ị́sọ̃wụ̃ ní kĩnĩ, “Mí ẹ́drị́pị ímụ́ nõgó, ũꞌbã mâ mị, pa tãkíri má ní lẽé sẽé mí ní rĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ị́sọ̃wụ̃ ní ꞌyozú kĩnĩ, “Rụ́ ĩ ní ꞌdaá ĩri ní Yõkóbũ ꞌdĩri ꞌdakí ĩri pịrị, ãꞌdiãtãsĩyã ũꞌbã mâ mị caá vú be ị̃rị̃. Pa mávé kãyú má drị́gé sĩ, nóni pa kpá tãkíri mí ní lẽé sẽé má ní rĩ má drị́gé sĩ gí!” Kúru Ị́sọ̃wụ̃ ní ẹ́tẹ́pị ri zịzú kĩnĩ, “Tãkíri ãzi mí vúgá ꞌdĩí mí ní ícó sẽé má ní ni ꞌdãáyo?” ");
INSERT INTO kbo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ĩsákã ní ꞌyozú Ị́sọ̃wụ̃ ní kĩnĩ, “Á ꞌbã Yõkóbũ ri mí drị̃gé ãmbúgú rú gí, á ꞌyo, má kĩnĩ, ĩrivé ẹ́drị́pị́ị céré adri ãtíꞌbá ĩrivé ni. Á sẽ ĩri ní ãnyãngã fífí, ãzini á sẽ ĩri ní vị́nyọ̃ gí. Mâ mvá rĩ, mâ ꞌo rí mí ní ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ị́sọ̃wụ̃ ní ꞌyozú ẹ́tẹ́pị ní kĩnĩ, “Má ẹ́tẹ́pị, tãkíri rĩ mí vúgá ꞌdĩlé ꞌyéŋá ãlu? Má ẹ́tẹ́pị, ꞌí sẽ má ní tãkíri ĩndĩ fô!” Kúru Ị́sọ̃wụ̃ ní íꞌdózú ngozú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ẹ́tẹ́pị Ĩsákã ní ꞌyozú ĩri ní kĩnĩ, “ꞌBẹ̃tị́ mí ní adrizú rĩ, ĩri vụ̃ rárá rú nyọ̃ọ́kụ́ múké rĩ ã rụ́ꞌbá gá sĩ, ẹndrịlị́gọ́ ꞌa drị̃ ni gé ku. ");
INSERT INTO kbo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mi ẹ̃ꞌdị́ ꞌdị ị́lị́ ãco ni sĩ, mi íbí ngá ị́sụ́ ndõ. Mi ímụ́ adri tụ́gẹ̃rị̃ mí ẹ́drị́pị vé ni. ꞌBo mí kãdõ lẽé ímụ́ mi ọyụụ́ adringárá tụ́gẹ̃rị̃ rú rĩ agásĩ, mí gõ adrií tụ́gẹ̃rị̃ rú ĩri ã pálé gá ku.” ");
INSERT INTO kbo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ị́sọ̃wụ̃ ꞌbã ẹ́sị́ ũnjí Yõkóbũ ní, ẹ́tẹ́pị Ĩsákã ní tãkíri sẽé Yõkóbũ ní rĩ sĩ. Ị́sọ̃wụ̃ ní ꞌyozú kĩnĩ, “Ụ́ꞌdụ́ má ẹ́tẹ́pị ní drãzú rĩ ꞌbã ícá ĩnyiŋá gí, ma ímụ́ má ẹ́drị́pị Yõkóbũ ri ꞌdị drã rá.” ");
INSERT INTO kbo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kâ tã Ị́sọ̃wụ̃ ní ꞌyoó ꞌdĩri ũlũú Rẽbékã ní, Rẽbékã ní ꞌbá ãzi pẽzú mụzú tã ꞌdĩri ũlũzú Yõkóbũ ní kĩnĩ, “Mí ẹ́drị́pị Ị́sọ̃wụ̃ ri lẹ́tị ndã lẽzú mi ꞌdịzú drãzú, ꞌî ẹ́sị́ ã ndrĩ rí ãní. ");
INSERT INTO kbo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mâ mvá rĩ, á ꞌyo mí ní, lẽ mí ápá mụzú má ẹ́drị́pị Lãbánã vú Hãránã gá. ");
INSERT INTO kbo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ꞌÍ mụ adrií vú ni gé ꞌdãá ũkõlõ, cĩmgbá mí ẹ́drị́pị Ị́sọ̃wụ̃ vé ẹ́sị́ veépi ꞌdĩri ndrĩ dõ gí ká. ");
INSERT INTO kbo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mí ẹ́drị́pị vé ẹ́sị́ veépi ꞌdĩri ndrĩ dõ gí, ãzini tã rĩ ãvĩ dõ ẹ́sị́ ni agásĩ gí, ma ꞌbá ãzi pẽ mụ mi bĩ, mî ímví rí ĩgõó ꞌbẹ̃tị́. Á lẽ anji mávé rĩ pi ã ũdrãkí ị̃rị̃trọ́ ụ́ꞌdụ́ ãlu agá ku.” ");
INSERT INTO kbo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rẽbékã ní ꞌyozú Ĩsákã ní kĩnĩ, “Ị́sọ̃wụ̃ vé ũkú jeé Hị́tị̃ gé ꞌdĩꞌbée ri má ní ĩzãngã sẽ ambamba. Yõkóbũ je dõ kpá mvá ũkú Hị́tị̃ vé ni, múké ni, lẽ mâ drã ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kúru Ĩsákã ní Yõkóbũ ri zịzú ímụ́zú, ĩri ní tãkíri sẽzú ĩri ní. Ĩri ní ꞌyozú Yõkóbũ ní kĩnĩ, “Lẽ mî je mvá ũkú Kãnánã vé ni mí ní ũkú rú ku. ");
INSERT INTO kbo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ꞌÍ nga mụụ́ ũkú jeé Pãdãnã Ãrámã gá, mí ẹ́ndrẹ́pị vé ẹ́tẹ́pị Bẽtũwélẽ vé ꞌbẹ̃tị́ ãsámvú gé. Mí ẹ́ndrẹ́pị vé ẹ́drị́pị Lãbánã vé anji ũkú ãsámvú gé, ꞌí je ãlu ni mí ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Múngú Ũkpõ ꞌDị́pa ã sẽ mí ní tãkíri, lẽ mî tị anji, kộpi ẽ ízúkí kárákará, úyú mívé rĩ pi ẽ ízúkí, kộpi ã adrikí rí ẹ́tẹ́pị sụ́rụ́ kárákará rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Lẽ Múngú ã sẽ mí ní tãkíri úyú mívé rĩ pi be, sụ̃ ĩri ní sẽé Ãbũrámã ní rĩ tị́nị, ãngũ ꞌbá ní adrizú ꞌa ni gé jãkã rú nõri, ã adri rí ĩmivé ni, ãꞌdiãtãsĩyã Múngú sẽ ãngũ nõri Ãbũrámã ní.” ");
INSERT INTO kbo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kúru Ĩsákã ní Yõkóbũ ri pẽzú mụzú Pãdãnã Ãrámã gá Lãbánã vúgá. Lãbánã ri Bẽtũwélẽ Ãrámãgú rĩ vé mvá, Rẽbékã ri Yõkóbũ pi vé ẹ́ndrẹ́pị Ị́sọ̃wụ̃ be, ĩri Lãbánã vé ọ́mvụ́pị. ");
INSERT INTO kbo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ị́sọ̃wụ̃ nị̃ ámá ꞌyozú kínĩ, Ĩsákã sẽ tãkíri Yõkóbũ ní gí, pẽ ĩri mụụ́ ũkú jeé Pãdãnã Ãrámã gá. Kã tãkíri sẽé Yõkóbũ ní gí, ẹzị Yõkóbũ ní kĩnĩ, ã je mvá ũkú Kãnánã vé ni ku. ");
INSERT INTO kbo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yõkóbũ ꞌdụ tã ẹ́tẹ́pị pi vé ẹ́ndrẹ́pị be rĩ ngaá rá, mụ Pãdãnã Ãrámã gá ꞌdãá rá. ");
INSERT INTO kbo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kúru Ị́sọ̃wụ̃ kã nị̃ị́ ámá ꞌyozú kínĩ, ꞌí ẹ́tẹ́pị Ĩsákã lẽ ã jekí mvá ũkú Kãnánã vé ni ku, ");
INSERT INTO kbo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ĩri ní gõzú ũkú ãzi jezú. Je Ĩsĩmãélẽ vé mvá ũkú Mãhãlátã ri ꞌí ní ũkú rú. Mãhãlátã ri Nẽbãyótĩ vé ọ́mvụ́pị, Nẽbãyótĩ ri Ĩsĩmãélẽ ã mvá, Ĩsĩmãélẽ ri Ãbũrámã ã mvá. ");
INSERT INTO kbo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yõkóbũ ní ngazú Bẽrĩsébã gá ꞌdãásĩ, ĩri ní ꞌdezú mụzú Hãránã gá. ");
INSERT INTO kbo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kã mụụ́ caá vũrã ãzi gé, ĩri ní áwízú lazú ꞌdãgá, ãꞌdiãtãsĩyã ụ̃tụ́ rĩ ní ꞌdeé gí rĩ sĩ. Ĩri ní írã íꞌdụ́zú ꞌbãzú ꞌî drị̃ ẹ̃tị̃zú ãní, ĩri ní kúru lazú ụ́ꞌdụ́ kozú. ");
INSERT INTO kbo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Urobí ũbĩ ĩri kĩnĩ, ꞌí ndre ngá ĩ ní rizú tụzú ụrụ ni íꞌdózú vũgá nõgó cĩmgbá cazú ꞌbụ̃ gé ꞌdãá. Múngú vé mãlãyíkã rĩ pi ri ísị́ ímụ́zú ãní vũgá nõó, kộpi kpá gõ tụ mụzú ãní ꞌbụ̃ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Úpí Múngú tu pá kuú ngá ĩ ní rií tụụ́ ãní ụrụ rĩ drị̃gé ụrụgégé ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Ma Úpí Múngú ꞌi, Ãbũrámã pi ní rií ị̃njị̃ị́ Ĩsákã be rĩ. Ãngũ mí ní lazú ꞌdĩri, ĩri adri mívé ni, úyú mívé rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Úyú mívé rĩ pi ímụ́ ízú kárákará sụ̃ cínyáfã vũ drị̃gé rĩ tị́nị. Kộpi ĩ íré mụzú wọ̃ọ́kọ̃ ụ̃tụ́ ní ꞌdezú rĩ gé, wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé, wọ̃ọ́kọ̃ ụ́rụ́lé rú rĩ gé, ãzini wọ̃ọ́kọ̃ ándrélé rú rĩ gé. Ĩ tãkíri sẽ ꞌbá vũ drị̃gé nõgó rĩ pi ní mî tã sĩ, ãzini úyú mívé rĩ pi ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma adri mí be trụ́, vũrã mí ní ẹ́cị́zú rĩ pi agásĩ, ma mi ũtẽ rá. Ma mi íjị́ ĩgõ vúlé ãngũ nõri agá nõgó. Má ícó mi kuú ku, ma ũyõ má ní sõó rĩ vé tã ꞌdụ nga rá.” ");
INSERT INTO kbo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yõkóbũ kã aruú ụ́ꞌdụ́ gélé sĩ, ụ̃sụ̃ kĩnĩ, “Ádarú Úpí Múngú ri vũrã nõri agá anigé, ꞌbo á nị̃ ámá kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tã ꞌdĩri sẽ Yõkóbũ ní ụ̃rị̃, ĩri ní ꞌyozú kĩnĩ, “Vũrã nõri má ní ụ̃rị̃ sẽ! Vũrã nõri ícó adri jó Múngú vé ni, ĩri kẹ̃ẹ́tị fizú ãní ꞌbụ̃ gé rĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kã mụụ́ adrií drụ̃ ꞌdíni ụ̃ꞌbụ́tịŋá rĩ sĩ, Yõkóbũ ní írã ꞌí ní ꞌî drị̃ ẹ̃tị̃zú ꞌdĩri íꞌdụ́zú ịꞌdịzú, ĩri ní ũdu dãzú drị̃ ni gé. ");
INSERT INTO kbo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ĩri ní vũrã ꞌdãri ã rụ́ ꞌdazú Bẽtélẽ. (Ífífí ni, jó Múngú vé ni.) Drị̃drị̃ ni, zịkí kụ̃rụ́ ꞌdãri ã rụ́ Lụ́zị̃. ");
INSERT INTO kbo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kúru Yõkóbũ ní ũyõ sõzú Múngú ẹndrẹtị gé kĩnĩ, “Múngú ũtẽ dõ ma ẹ̃cị̃ má ní tuú nõri gé rá, sẽ dõ má ní ãnyãngã bõngó be rá, ");
INSERT INTO kbo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ãzini má újá dõ ma gõó múké má ẹ́tẹ́pị vé ãngá ꞌdãá rá, Úpí Múngú ri adri Múngú mávé ni. ");
INSERT INTO kbo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Írã má ní ịꞌdịị́ nõri, ĩri adri vũrã Múngú ri ị̃njị̃zú ni. Ngá Múngú ní sẽé má ní rĩ pi ãrẽvú céré, ngá mụdrị́ agá, ma ãlu ni íꞌdụ́ sẽ Múngú ní.” ");
INSERT INTO kbo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kúru Yõkóbũ ní ngazú mụzú ẹ̃cị̃ gé, ĩri ní cazú ꞌbá adriꞌbá wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũzú rĩ gé rĩ pi vé ãngũ gé. ");
INSERT INTO kbo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ĩri ní kídí ndrezú ásé agá ꞌdãá, kãbĩlõ rĩ pi úmúkí ĩ laá kuú kídí rĩ ã gãrã gá vũrã sĩ na, ãꞌdiãtãsĩyã kãbĩlõ rĩ pi ri yị̃ị́ mvụ kídí ꞌdãri gé. Ọ̃zụ̃kí kídí rĩ ẽ tị írã ãmbúgú ni sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kádõ kãbĩlõ rĩ pi úmú céré kídí rĩ ã gãrã gá ꞌdãá, ꞌbá kãbĩlõ úcéꞌbá rĩ pi írã rĩ gũ kídí rĩ tị gé sĩ ãmvé, kộpi kãbĩlõ rĩ pi ní yị̃ị́ sẽ mvụ, kộpi kúru írã rĩ gũ ꞌbã gõ vúlé kídí rĩ tị gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yõkóbũ ní ꞌbá kãbĩlõ úcéꞌbá rĩ pi zịzú kĩnĩ, “Má ẹ́drị́pị́ị, ĩmi íbíkí íngá ngũgá?” Kộpi ní ꞌyozú kínĩ, “ꞌBá íbíkí íngá Hãránã gá.” ");
INSERT INTO kbo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi nị̃kí Nãhórã mvọ́pị vé mvá Lãbánã ri rá?” Kộpi ní újázú kínĩ, “Ẽ, ꞌbá nị̃kí ĩri rá.” ");
INSERT INTO kbo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kúru Yõkóbũ ní kộpi zịzú kĩnĩ, “Lãbánã ri múké?” Kộpi kínĩ, “Ẽ! Ĩri múké. ꞌÍ ndre drĩ ká ĩrivé mvá ũkú Rãélẽ ri ímụ́ kãbĩlõ rĩ pi be ꞌdã.” ");
INSERT INTO kbo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yõkóbũ ní ꞌyozú kĩnĩ, “Ĩmi ndrekí drĩ ká, ụ̃tụ́ rĩ drĩ anigé, sâ nõri adri kãbĩlõ rĩ pi úmúzú vũrã ãlu gé ni kuyé. Ĩmi sẽkí kãbĩlõ rĩ pi ní yị̃ị́ mvụụ́, ĩmi jịkí kộpi vúlé mụụ́ ị̃rị́bị̃ nyaá.” ");
INSERT INTO kbo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kộpi ní újázú kínĩ, “ꞌBá ícókí drĩ kãbĩlõ rĩ pi ní yị̃ị́ sẽé mvụụ́ ku, úmúkí dõ kãbĩlõ rĩ pi céré gí, ãzini gũkí dõ írã rĩ kídí rĩ tị gé sĩ ãmvé gí, ꞌbá íbí kãbĩlõ rĩ pi ní yị̃ị́ sẽ mvụ ndõ.” ");
INSERT INTO kbo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yõkóbũ kã rií átá kộpi be, koro Rãélẽ ní ícázú ẹ́tẹ́pị vé kãbĩlõ rĩ pi be, ãꞌdiãtãsĩyã Rãélẽ ri kãbĩlõ rĩ pi úcé nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yõkóbũ kã ꞌí ádrọ́pị Lãbánã vé mvá ũkú Rãélẽ ri ndreé Lãbánã vé kãbĩlõ rĩ pi be, ĩri ní mụzú írã rĩ gũzú kídí rĩ tị gé sĩ, Ĩri ní yị̃ị́ sẽzú mvụzú kãbĩlõ rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kúru Yõkóbũ ní Rãélẽ ri uꞌdezú rụzú bẹ̃drị̃ sĩ, ĩri ẽ tị ndruzú, ĩri ní íꞌdózú ngozú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ĩri ní lũzú Rãélẽ ní kĩnĩ, ꞌi Rãélẽ ẹ́tẹ́pị vé ãdrõmvá, Rẽbékã ã mvá. Rãélẽ ní njuzú mụzú tã ꞌdĩri ũlũzú ẹ́tẹ́pị ní. ");
INSERT INTO kbo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lãbánã kã ívé ãdrõmvá Yõkóbũ vé tã yịị́, ĩri ní njuzú mụzú vú ni gé ꞌdãá. Ĩri ní Yõkóbũ ri uꞌdezú rụzú bẹ̃drị̃ sĩ, tị ni ndruzú, ĩri ní Yõkóbũ ri jịzú mụzú ívé ãngá. Yõkóbũ ní tã ꞌi ngaápi rĩ ũlũzú ĩri ní céré. ");
INSERT INTO kbo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kúru Lãbánã ní ꞌyozú ĩri ní kĩnĩ, “Mí íbí ĩfũú mâ rụ́ꞌbá gá, mi ãrí mávé ni.” Yõkóbũ kã adrií Lãbánã vúgá ꞌdãlé caá mbãá ãlu gí, ");
INSERT INTO kbo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lãbánã ní ꞌyozú ĩri ní kĩnĩ, “Mî adri dõ mávé máríté drãáãsĩyã, mí ícó má ní ẹ̃zị́ ngaá kána ku. ꞌÍ lũ má ní, mâ ũfẽ mi ngõpí?” ");
INSERT INTO kbo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lãbánã ri anji ũkú be ị̃rị̃, mvá kãyú rĩ ã rụ́ Léyã ꞌi, mvá ụ̃dụ́ rĩ ã rụ́ Rãélẽ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léyã ri ũnyĩ ãkó, Rãélẽ ri ũnyĩ be, ẹndrẹtị ni kọ́njụ́kọ́njụ́. ");
INSERT INTO kbo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yõkóbũ lẽ Rãélẽ ri ambamba, ĩri ní ꞌyozú Lãbánã ní kĩnĩ, “ꞌÍ sẽ dõ mívé mvá ụ̃dụ́ Rãélẽ ri jeé má ní ũkú rú rá, ma mí ní ẹ̃zị́ nga ca ílí ẹ́zị̂rị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lãbánã ní ꞌyozú kĩnĩ, “Á sẽ ĩri jeé ꞌbá ãzi ní ku, ma ĩri sẽ je mí ní. Lẽ mî adri má vúgá nõgó, ꞌí nga ẹ̃zị́ má ní.” ");
INSERT INTO kbo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kúru Yõkóbũ ní ẹ̃zị́ ngazú cazú ílí ẹ́zị̂rị̃, ꞌî je rí Rãélẽ ri ꞌí ní ũkú rú, ꞌbo ílí ꞌdĩꞌbée índré mị ni gé ꞌdãlé mãdãŋá, ãꞌdiãtãsĩyã lẽ Rãélẽ ri ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kúru Yõkóbũ ní ꞌyozú Lãbánã ní kĩnĩ, “Á nga ẹ̃zị́ rĩ dẹẹ́ gí, ꞌí sẽ mávé ũkú, ꞌbá lẽkí laá ĩri be.” ");
INSERT INTO kbo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kúru Lãbánã ní ꞌbá rĩ pi zịzú ímụ́zú ụ̃mụ̃ ũkú rĩ jezú rĩ ã nyangárá gá. ");
INSERT INTO kbo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ãngũ rĩ kã nịị́, Lãbánã ní ívé mvá ũkú Léyã ri jịzú sẽzú Yõkóbũ ní, Yõkóbũ pi ní lazú ĩri be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lãbánã ní ívé ãtíꞌbá Jẽléfã ri sẽzú Léyã ní, ã nga rí ĩri ní ẹ̃zị́ ãtíꞌbá rú. ");
INSERT INTO kbo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kã adrií drụ̃ ꞌdíni ụ̃ꞌbụ́tịŋá rĩ sĩ, Yõkóbũ ndre ꞌbá rĩ Léyã ꞌi! Ĩri ní ꞌyozú Lãbánã ní kĩnĩ, “ꞌÍ ꞌo ma ꞌdíni ãsĩ? Á nga mí ní ẹ̃zị́ rĩ Rãélẽ ã tã sĩ, adri ꞌdíni kuyé? Mí ũꞌbã mâ mị ꞌdíni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kúru Lãbánã ní ꞌyozú kĩnĩ, “ꞌBávé mẽrẽ nõgó rĩ, ĩ mvá ũkú kãyú rĩ je drị̃drị̃, ĩ íbí mvá ũkú ụ̃dụ́ rĩ je ndõ. ");
INSERT INTO kbo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ĩmi adrikí drĩ mvá ũkú kãyú rĩ be caá ụ́ꞌdụ́ ẹ́zị̂rị̃ ká, ụ́ꞌdụ́ ẹ́zị̂rị̃ ãjẽ vé rĩ dẹ dõ gí, ꞌbâ íbí mí ní mvá ụ̃dụ́ rĩ sẽ ndõ. Mi gõ má ní ẹ̃zị́ ãzi nga ca ílí ẹ́zị̂rị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yõkóbũ ãꞌyĩ rá. Adri caá Léyã be ụ́ꞌdụ́ ẹ́zị̂rị̃. Kúru Lãbánã ní ívé mvá ũkú Rãélẽ ri sẽzú ĩri ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lãbánã sẽ ívé ãtíꞌbázị́ Bílã ri ívé mvá ũkú Rãélẽ ní ãtíꞌbá rú. ");
INSERT INTO kbo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yõkóbũ pi ní lazú Rãélẽ be, Yõkóbũ lẽ Rãélẽ ri Léyã ri ndẽé. Yõkóbũ gõ ẹ̃zị́ ãzi ngaá Lãbánã ní caá ílí ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Úpí Múngú kã ndreé Yõkóbũ lẽ Léyã ri ku, ĩri ní drị́ tị̃zú Léyã rụ́ꞌbá gá, zị̃ Léyã vé lẹ́tị mvá tịzú rĩ rá. ꞌBo Rãélẽ adri kú úndó rú. ");
INSERT INTO kbo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léyã ní ꞌa ị́sụ́zú, ĩri ní mvá ágó tịzú, ĩri ní mvá rĩ ã rụ́ ꞌdazú Rũbénã ꞌi. Ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú ndre mávé ĩzãngã gí. Nóni má ágó ni ri ma lẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ĩri ní gõzú ꞌa ị́sụ́zú dị̃ị́, ĩri ní mvá ágó tịzú, ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú yị rá, má ágó ni lẽ ma ku, gõ má ní mvá ágó ãzi sẽé gí.” Ĩri ní mvá rĩ ã rụ́ ꞌdazú Sĩmĩyónã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ĩri ní kpá gõzú ꞌa ãzi ị́sụ́zú dị̃ị́, ĩri ní mvá ágó tịzú, ĩri ní ꞌyozú kĩnĩ, “Nóni má ágó ni ri ímụ́ adri má be trụ́, ãꞌdiãtãsĩyã á tị nóni ĩri ní anji ãgõ caá na.” Ĩri ní mvá rĩ ã rụ́ ꞌdazú Lẹ́vị̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ĩri ní kpá gõzú ꞌa ãzi ị́sụ́zú dị̃ị́, ĩri ní mvá ágó tịzú, ĩri ní ꞌyozú kĩnĩ, “Nóni ma Úpí Múngú ri íngú rá.” Ĩri ní mvá rĩ ã rụ́ ꞌdazú Yụ́dã ꞌi. ꞌDĩri ã vụ́drị̃ gé, gõ anji tịị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rãélẽ kã ndreé Léyã tị anji Yõkóbũ ní gí, ĩri ní íꞌdózú ãꞌyã ꞌbãzú ọ́mvụ́pị Léyã be, ĩri ní ꞌyozú Yõkóbũ ní kĩnĩ, “ꞌÍ sẽ dõ má ní anji ku, mâ drã ꞌdĩísĩ rá!” ");
INSERT INTO kbo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yõkóbũ ã ꞌa ve Rãélẽ ní ũnjí ũnjí, ĩri ní ꞌyozú kĩnĩ, “Ma Múngú ꞌi, má uga mi mvá tịngárá sĩ nĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rãélẽ ní ꞌyozú kĩnĩ, “Mávé ãtíꞌbá Bílã rĩ ꞌdĩ. Ĩmi lakí ĩri be, ã tị rí má ní anji, anji ĩri ní tịị́ rĩ, ã adri rí anji mávé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kúru Rãélẽ ní ívé ãtíꞌbá Bílã ri sẽzú Yõkóbũ ní ũkú rú, Yõkóbũ pi ní lazú ĩri be. ");
INSERT INTO kbo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ĩri ní ꞌa ị́sụ́zú, ĩri ní mvá ágóŋá tịzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rãélẽ ní ꞌyozú kĩnĩ, “Múngú nị̃ rá, ma ri tã ꞌo pịrị, yị mávé zịngárá gí, sẽ má ní mvá ágóŋá.” Kúru ĩri ní mvá rĩ ã rụ́ ꞌdazú Dánã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rãélẽ vé ãtíꞌbá Bílã gõ ꞌa ị́sụ́ dị̃ị́, Ĩri ní Yõkóbũ ní mvá ágóŋá ị̃rị̃ ni tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rãélẽ ní ꞌyozú kĩnĩ, “Á fụ ũmbã ũkpõ sĩ má ọ́mvụ́pị be, ꞌbo má aga gí.” Kúru ĩri ní mvá rĩ ã rụ́ ꞌdazú Nãfãtálĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Léyã kã ndreé ꞌí tị ku, ĩri ní ívé ãtíꞌbá Jẽléfã ri sẽzú Yõkóbũ ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Léyã vé ãtíꞌbá Jẽléfã ní mvá ágóŋá tịzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Léyã ní ꞌyozú kĩnĩ, “Má ị́sụ́ drị̃lé múké gí!” Ĩri ní mvá rĩ ã rụ́ ꞌdazú Gádĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Léyã vé ãtíꞌbá Jẽléfã ní Yõkóbũ ní mvá ágóŋá ị̃rị̃ ni tịzú. ");
INSERT INTO kbo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Léyã ní ꞌyozú kĩnĩ, “Ma ãyĩkõ sĩ! Nóni ũkú rĩ pi ꞌyo, má ị́sụ́ ãyĩkõ gí.” Kúru ĩri ní mvá rĩ ã rụ́ ꞌdazú Ãsérã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lókí ĩ ní rizú ãnyãngã ĩkũnãzú rĩ gé, Rũbénã ꞌde mụụ́ ọ́mvụ́ gé ꞌdãá, ị́sụ́ pẹtị ĩ ní zịị́ mãndãrákã rĩ, íjị́ pẹtị rĩ sẽé ꞌí ẹ́ndrẹ́pị Léyã ní. Rãélẽ ní ꞌyozú ọ́mvụ́pị Léyã ní kĩnĩ, “ꞌÍ sẽ mî mvọ́pị vé mãndãrákã rĩ ã ụrụkọ má ní.” ");
INSERT INTO kbo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Léyã ní újázú ĩri ní kĩnĩ, “Mávé ágó mí ní ꞌdụụ́ ꞌdĩri ca drĩ mí ní kuyé? Nóni ꞌí lẽ kpá mâ mvọ́pị vé mãndãrákã ꞌdụụ́ drị̃ ni gé kpãá?” Rãélẽ ní ꞌyozú kĩnĩ, “ꞌÍ sẽ dõ má ní mãndãrákã rĩ rá, ma sẽ Yõkóbũ ri fi mụ la mí be ị́nị́ŋá nõri sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ũndréŋá ꞌdãri sĩ, Yõkóbũ kã ímví ĩgõó ọ́mvụ́ gélésĩ, Léyã ní fũzú mụzú ĩri vúgá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Ãndrũ ꞌbâ la mí be ị́nị́ŋá nõri sĩ. Á je mi mâ mvọ́pị vé mãndãrákã sĩ gí.” Kúru Yõkóbũ pi ní lazú Léyã be ị́nị́ŋá ꞌdãri sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Múngú yị Léyã vé zịngárá rá. Ĩri ní ꞌa ị́sụ́zú, ĩri ní mvá ágó ãzi tịzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Léyã ní ꞌyozú kĩnĩ, “Má ní mávé ãtíꞌbá sẽé Yõkóbũ ní ũkú rú rĩ sĩ, Múngú ũfẽ ma gí.” Kúru ĩri ní mvá rĩ ã rụ́ ꞌdazú Ĩsãkárã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léyã ní gõzú ꞌa ãzi ị́sụ́zú dị̃ị́, ĩri ní mvá ágó ãzi tịzú Yõkóbũ ní, anji ãgõ ĩri ní tịị́ rĩ pi cakí ázíyá. ");
INSERT INTO kbo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Léyã ní ꞌyozú kĩnĩ, “Múngú sẽ má ní fẽfẽ múké ni. Nóni má ágó ni ri ma ị̃njị̃ rá, ãꞌdiãtãsĩyã á tị ĩri ní anji caá ázíyá.” Ĩri ní mvá rĩ ã rụ́ ꞌdazú Jẽbũlúnã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Vụ́drị̃ ni gé, Léyã ní gõzú mvá ũkú tịzú, ĩri ní rụ́ ni ꞌdazú Dị́nã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kúru Múngú ní Rãélẽ ã tã ụ̃sụ̃zú, yị Rãélẽ vé zịngárá rá, ĩri ní drị́ tị̃zú Rãélẽ rụ́ꞌbá gá, zị̃ Rãélẽ vé lẹ́tị mvá tịzú rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ĩri ní ꞌa ị́sụ́zú, ĩri ní mvá ágóŋá tịzú, ĩri ní ꞌyozú kĩnĩ, “Múngú ꞌdụ drị̃njá má drị̃gé sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ĩri ní mvá rĩ ã rụ́ ꞌdazú Yõsépã ꞌi, ĩri ní ꞌyozú kĩnĩ, “Lẽ Úpí Múngú ã sẽ má ní mvá ágóŋá ãzi.” ");
INSERT INTO kbo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rãélẽ kã Yõsépã ri tịị́, Yõkóbũ ní ꞌyozú Lãbánã ní kĩnĩ, “Mí ọyụ ma, á lẽ mvií gõó ꞌbẹ̃tị́ ꞌbávé ãngũ gé. ");
INSERT INTO kbo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ꞌÍ sẽ mávé ũkú rĩ pi anjiŋá rĩ pi be, ãꞌdiãtãsĩyã á nga ẹ̃zị́ rĩ mí ní kộpi ã tã sĩ, mí ọyụ ma, mâ ꞌde mụụ́. ꞌÍ nị̃ rá á nga mí ní ẹ̃zị́ rĩ ambamba.” ");
INSERT INTO kbo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lãbánã ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ yị drĩ ma ká, mí adri nõgó. Á nị̃ ámá rá, ma nóni ãꞌbú be, ãꞌdiãtãsĩyã Úpí Múngú sẽ má ní tãkíri mî tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Lãbánã ní gõzú ꞌyozú kĩnĩ, “ꞌÍ lị ngá mí ní lẽé mâ ũfẽ mi ãní rĩ, ma ũfẽ mí ní rá.” ");
INSERT INTO kbo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yõkóbũ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ nị̃ rá, á nga mí ní ẹ̃zị́ ũkpõ sĩ, má ũtẽ mívé ãnyãpá rĩ pi múké. ");
INSERT INTO kbo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Má ní drĩ ándúrú ícázú kuyé rĩ gé, mívé ãnyãpá ízú kuyé, nóni má ní adrií nõgó rĩ sĩ, Úpí Múngú sẽ mí ní tãkíri, mívé ãnyãpá ízú kárákará. ꞌBo mâ íꞌdó rí mávé ꞌbá rĩ pi ẽ ĩzã koó ngá sĩ ngọ̃tụ́?” ");
INSERT INTO kbo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lãbánã ní Yõkóbũ ri zịzú kĩnĩ, “Ngá mí ní lẽé mâ sẽ mí ní rĩ ãꞌdi?” Yõkóbũ ní újázú ĩri ní kĩnĩ, “Ã sẽkí má ní ngá ãzi ku. Mí ãꞌyĩ dõ tã má ní lẽé ꞌyoó rĩ rá, ma ícó mívé ãnyãpá úcé rá. ");
INSERT INTO kbo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ãndrũ lẽ mî ọyụ ma mụụ́ mívé ãnyãpá rĩ pi ãsámvú gé ꞌdãá, mâ ũpẽ rí kãbĩlõ rụ́ꞌbá be mĩꞌyĩmĩꞌyĩ, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃ rĩ pi, ãzini kãbĩlõ anji rụ́ꞌbá be ịnị ịnị rĩ pi, ndrị̃ị́ rụ́ꞌbá be bọ̃ꞌdụ̃bọ̃ꞌdụ̃, dõku mĩꞌyĩmĩꞌyĩ rĩ pi má ní. Ngá mí ní ma ũfẽzú rĩ pi adriꞌbée ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Úmvúlésĩ mí kãdõ ãnyãpá mí ní ma ũfẽzú rĩ pi ndreé, mî nị̃ rí ámá ꞌyozú kínĩ, ma tã ꞌo pịrị. Mávé ãnyãpá rĩ pi ãsámvú gé ꞌdãá, mí ị́sụ́ dõ ndrị̃ị́ rụ́ꞌbá be mĩꞌyĩmĩꞌyĩ ku ni, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃ ku ni, dõku mí ị́sụ́ dõ kãbĩlõ anji rụ́ꞌbá be ịnị ku ni, mi nị̃ ámá ꞌyozú kínĩ má ụ̃gụ̃ mívé ãnyãpá.” ");
INSERT INTO kbo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lãbánã ní ꞌyozú kĩnĩ, “Má ãꞌyĩ rá. Ã adri sụ̃ mí ní ꞌyoó rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ụ́ꞌdụ́ ꞌdãri sĩ, Lãbánã ní ndrị̃ị́ ãgõ rụ́ꞌbá be gírígírí, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃ rĩ pi ũpẽzú ndrị̃ị́ ũkú rụ́ꞌbá be mĩꞌyĩmĩꞌyĩ, dõku rụ́ꞌbá be bọ̃ꞌdụ̃bọ̃ꞌdụ̃ rĩ pi be, kãbĩlõ anji rụ́ꞌbá be ịnị ịnị rĩ pi be, sẽ kộpi ívé anjiŋá rĩ pi rikí úcé nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Lãbánã pi ní ꞌdezú mụzú ívé anjiŋá rĩ pi be rárá rú, kộpi tukí ẹ̃cị̃ caá ụ́ꞌdụ́ na, Yõkóbũ áwí rií Lãbánã vé ãnyãpá rĩ pi ã ụrụkọ úcé. ");
INSERT INTO kbo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yõkóbũ ní pẹtị ĩ ní zịị́ pópũlã, ãlĩmónĩ, ãzini pũlánĩ rĩ pi vé drị́tị ugazú, ĩri ní kókóꞌbõ ni pi ụ́wụ́zú kộpi ã rụ́ꞌbá gá sĩ, ĩri ní pẹtị rĩ pi vé drị́tị ꞌí ní rụ́ꞌbá ni ụ́wụ́ rĩ pi ĩgĩrĩzú kú gírígírí. ");
INSERT INTO kbo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ĩri ní pẹtị rĩ pi vé drị́tị ꞌí ní rụ́ꞌbá ni pi ụ́wụ́ rĩ pi úsúzú ꞌbụ́ ãnyãpá rĩ pi ní rizú yị̃ị́ mvụzú rĩ agá, ãꞌdiãtãsĩyã ãnyãpá rĩ pi ri ímụ́ ĩ ĩlũwã vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ãnyãpá rĩ pi kãdõ ĩ ĩlũwãá pẹtị ĩ ní ĩgĩrĩí gírígírí rĩ pi ẹndrẹtị gé, kộpi anji tị rụ́ꞌbá be gírígírí, dõku mĩꞌyĩmĩꞌyĩ, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃. ");
INSERT INTO kbo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yõkóbũ ũpẽ ãnyãpá anjiŋá ꞌdĩꞌbée ũꞌbãá túngú. Ãnyãpá mbaꞌbée gí rĩ pi kãdõ ĩ ĩlũwãá, Yõkóbũ ri kộpi ꞌbã ãngũ ndre mụzú Lãbánã vé ãnyãpá rụ́ꞌbá be gírígírí, ãzini ịnị ịnị rĩ pi vúgálé rú. Yõkóbũ gụ̃ ãnyãpá rĩ pi ã ụrụkọ ꞌbãá túngú ꞌí ní, úmú kộpi ãnyãpá Lãbánã vé rĩ pi be trụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kádõ ãnyãpá rụ́ꞌbá be mgbúmgbú rĩ pi ĩlũwãá, Yõkóbũ ri pẹtị ꞌí ní rụ́ꞌbá ni ụ́wụ́ rĩ pi úsú ꞌbụ́ ãnyãpá rĩ pi ní yị̃ị́ mvụzú rĩ agá ãnyãpá rĩ pi ẹndrẹtị gé, kộpi ẽ ĩlũwãkí rí ĩ pẹtị rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ꞌBo úsú pẹtị rĩ pi ãnyãpá ũkpõ ãkó rĩ pi ẹndrẹtị gé ku. Kúru ãnyãpá ũkpõ ãkó rĩ pi adri Lãbánã vé ni, rụ́ꞌbá be mgbúmgbú rĩ pi adri Yõkóbũ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Tã ꞌdĩri sẽ Yõkóbũ vé ãnyãpá ízú kárákará, gõ adrií kãbĩlõ be, ãzini ndrị̃ị́ be kárákará. Gõ kpá adrií ãtíꞌbá ũkú rú ni pi be, ãtíꞌbá ãgõ rú ni pi be, kámĩlõ pi be, dõngí pi be. ");
INSERT INTO kbo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yõkóbũ yị kínĩ, Lãbánã vé anji rĩ pi ri ꞌyo kínĩ, “Yõkóbũ ꞌdụ ꞌbá ẹ́tẹ́pị vé ãꞌbú ãrẽvú céré gí. Ị́sụ́ ãꞌbú ꞌdĩri ꞌbá ẹ́tẹ́pị vúgá.” ");
INSERT INTO kbo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yõkóbũ ndre kpá nóni Lãbánã adri ꞌí be ãyĩkõ sĩ sụ̃ ándúrú rĩ tị́nị ku. ");
INSERT INTO kbo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kúru Úpí Múngú ní ꞌyozú Yõkóbũ ní kĩnĩ, “ꞌÍ mvi gõó vúlé mí ẹ́ꞌbị́pị pi vé ãngũ gé, mívé máríté rĩ pi ãsámvú gé, ma adri mí be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kúru Yõkóbũ ní ụ́ꞌdụ́kọ́ pẽzú Rãélẽ pi ní Léyã be, kộpi ẽ ímụ́kí ꞌi ị́sụ́ vũrã ívé ãnyãpá rĩ pi ní ányázú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yõkóbũ ní ꞌyozú kộpi ní kĩnĩ, “Á ndre ĩmi ẹ́tẹ́pị vé adringárá má be rĩ adri sụ̃ drị̃drị̃ rĩ tị́nị kuyé, ꞌbo Múngú má ẹ́tẹ́pị vé rĩ má be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ĩmi nị̃kí rá, á nga ẹ̃zị́ ĩmi ẹ́tẹ́pị ní ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ꞌBo ĩmi ẹ́tẹ́pị ũꞌbã mâ mị, újá ngá ꞌí ní lẽé ma ũfẽzú rĩ caá vú be mụdrị́. ꞌBo Múngú ũtẽ ma rá, Múngú sẽ ꞌo ma ũnjí kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ĩmi ẹ́tẹ́pị kãdõ ꞌyoó, ndrị̃ị́ mĩꞌyĩmĩꞌyĩ rĩ pi, ꞌi ma ũfẽ ãní, ndrị̃ị́ rĩ pi céré anji tị rụ́ꞌbá be mĩꞌyĩmĩꞌyĩ. Kãdõ ꞌyoó ndrị̃ị́ gírígírí rĩ pi, ꞌi ma ũfẽ ãní, ndrị̃ị́ rĩ pi céré anji tị rụ́ꞌbá be gírígírí. ");
INSERT INTO kbo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Múngú ꞌdụ ĩmi ẹ́tẹ́pị vé ãnyãpá drị́ ni gé sĩ rá, sẽ kộpi má ní. ");
INSERT INTO kbo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Lókí ndrị̃ị́ rĩ pi ní rizú ĩ ĩlũwãzú rĩ gé, urobí ũbĩ ma, á ndre láꞌbíjõ rĩ pi rikí ndrị̃ị́ ũkú rĩ pi ĩlũwãá, láꞌbíjõ rĩ pi ã rụ́ꞌbá gírígírí, mĩꞌyĩmĩꞌyĩ, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃. ");
INSERT INTO kbo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mãlãyíkã Múngú vé rĩ ní ma zịzú urobí agá kĩnĩ, ‘Yõkóbũ!’ Má ní ãꞌyĩzú, ‘Ma nõ.’ ");
INSERT INTO kbo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Mãlãyíkã rĩ ní ꞌyozú má ní kĩnĩ, ‘ꞌÍ ndre, ndrị̃ị́ ãgõ riꞌbá ndrị̃ị́ ũkú rĩ pi ĩlũwãꞌbá rĩ pi ã rụ́ꞌbá céré gírígírí, mĩꞌyĩmĩꞌyĩ, dõku bọ̃ꞌdụ̃bọ̃ꞌdụ̃, á ꞌo tã rĩ ꞌdíni, mî ĩzã kozú, ãꞌdiãtãsĩyã á ndre tã Lãbánã ní ꞌoó mí ní rĩ pi céré gí. ");
INSERT INTO kbo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ma Múngú ándúrú ꞌi iꞌdaápi mí ní Bẽtélẽ gá, vũrã mí ní írã ịꞌdịzú rĩ gé, mí ní ũyõ sõó ẹndrẹtị ní gé rĩ ꞌi. ꞌÍ nga fũú ãngũ nõri agásĩ, ꞌí mụ adrií ãngũ ĩ ní mi tịzú rĩ agá.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rãélẽ pi Léyã be, kộpi ní újázú Yõkóbũ ní kínĩ, “Ngá ãzi ꞌbá ẹ́tẹ́pị ní ímụ́ kuú ꞌbá ní ãluŋáni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ꞌBá ẹ́tẹ́pị ndre ꞌbâ kú sụ̃ jãkã tị́nị. Sẽ ꞌbâ jeé kána mũfẽngã ãkó, ꞌbá ị́sụ́kí ngá ãzi ãjẽ ꞌdĩri agá kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ãꞌbú Múngú ní ꞌdụụ́ ꞌbá ẹ́tẹ́pị drị́gé sĩ rĩ pi ãrẽvú céré ꞌbávé ni, ꞌbávé anjiŋá rĩ pi be. ꞌÍ ꞌo tã Múngú ní lũú mí ní rĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kúru Yõkóbũ pi ívé ũkú rĩ pi be, ívé anjiŋá rĩ pi be, kộpi ní útụ́zú kámĩlõ rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yõkóbũ dro ívé ãnyãpá rĩ pi mụzú ꞌí ẹndrẹtị gé sĩ, jị kpá ãꞌbú ꞌí ní ị́sụ́ Pãdãnã Ãrámã gá ꞌdãlé rĩ pi mụzú ĩndĩ. ꞌDe mụzú ꞌí ẹ́tẹ́pị Ĩsákã vúgá ãngũ Kãnánã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Sâ kộpi ní mụzú rĩ gé, ị́sụ́ Lãbánã ri rárá rú, ĩri ri ívé kãbĩlõ rĩ pi ã ꞌbí rẽ. Rãélẽ ní ẹ́tẹ́pị vé ngá ĩ ní údé múngú rú jó ũtẽépi rĩ pi ụ̃gụ̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yõkóbũ nje ꞌi mụzú kíri, lũ Lãbánã Ãrámãgú rĩ ní ꞌyozú kínĩ ꞌí lẽ mụụ́mụ ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yõkóbũ ápá mụzú ngá ꞌí ní ị́sụ́ rĩ pi be céré, ĩri ní yị̃ị́ ãmbúgú dịị́pi dịdị Yũfẽrétã ri zozú, ĩri ní ꞌdezú mụzú ãngũ ánga rú Gĩlédã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ụ́ꞌdụ́ na ã vụ́drị̃ gé, lũkí Lãbánã ní kínĩ, Yõkóbũ ápá gí. ");
INSERT INTO kbo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lãbánã ní ívé máríté rĩ pi trazú, kộpi drokí Yõkóbũ ã vụ́drị̃ caá ụ́ꞌdụ́ be ẹ́zị̂rị̃, kộpi cakí Yõkóbũ pi ị́sụ́ ãngũ ánga rú Gĩlédã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kúru Múngú ní ꞌi iꞌdazú Lãbánã Ãrámãgú rĩ ní urobí agá ị́nị́ŋá ꞌdãri sĩ, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ ndre múké, lẽ mî ꞌyo tã ãzi ũnjí Yõkóbũ ní ku.” ");
INSERT INTO kbo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lãbánã ca mụụ́ ị́sụ́ Yõkóbũ sị ívé gãkũ ãngũ ánga rú Gĩlédã vé rĩ gé, Lãbánã pi ívé máríté rĩ pi be, kộpi mụkí kpá adrií ãngũ ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kúru Lãbánã ní mụzú ꞌyozú Yõkóbũ ní kĩnĩ, “Ngá mí ní ꞌoó ꞌdíni rĩ ãꞌdi? Mí ũꞌbã mâ mị ꞌdíni ãꞌdiãtãsĩ? ꞌÍ ꞌdụ mávé anji ũkú rĩ pi ápázú mụzú kíri, sụ̃ ꞌbá ĩ ní urụụ́ ẹ̃ꞌdị́ gé rĩ pi tị́nị ãꞌdiãtãsĩ? ");
INSERT INTO kbo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mí nje mi ápá kíri mâ mị ũꞌbãzú ꞌdíni ãsĩ? ꞌÍ lũ má ní kuyé ãsĩ? Ma té mi pẽ mụzú ãyĩkõ sĩ, ĩ té úngó ngo, ĩ té ẹ́rị́ co, ãzini ĩ té kụ̃ꞌdị́ co. ");
INSERT INTO kbo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ꞌÍ sẽ á ndru mávé anji ũkú rĩ pi ẽ tị kuyé ãsĩ, ãzini ꞌí sẽ á ndru kộpivé anjiŋá rĩ pi ẽ tị kuyé ãsĩ? Tã mí ní ꞌoó ꞌdĩri tã azakaza vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma Lãbánã ꞌi, ma ũkpõ be, ma té ícó mi ꞌo ũnjí rá, ꞌbo té ị́nị́ŋá rĩ sĩ, Múngú mí ẹ́tẹ́pị vé rĩ ꞌyo má ní kĩnĩ, mâ ndre múké, lẽ mâ ꞌyo tã ãzi ũnjí mí ní ku. ");
INSERT INTO kbo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Á nị̃ rá, ꞌí lẽ mi újá gõó mí ẹ́tẹ́pị vúgá, ꞌbo mí ụ̃gụ̃ mávé ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú rĩ pi rá ãꞌdiãtãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yõkóbũ ní újázú kĩnĩ, “Á ꞌo ụ̃rị̃ sĩ, ãꞌdiãtãsĩyã má ụ̃sụ̃ mi mívé anji ũkú rĩ pi upa má drị́gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mí ị́sụ́ dõ mívé ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú rĩ ꞌbá ãzi vúgá nõgó rá, ã ꞌdịkí ꞌbá ꞌdĩri drãá rá. ꞌÍ ndã mívé ngá rĩ ꞌbávé máríté rĩ pi ẹndrẹtị gé nõgó. Mí ị́sụ́ dõ rá, ꞌí ꞌdụ mụzú.” Yõkóbũ nị̃ ꞌyozú kĩnĩ, Rãélẽ ụ̃gụ̃ ẹ́tẹ́pị Lãbánã vé ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú rĩ nĩ ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kúru Lãbánã ní fizú ngá rĩ ndãzú Yõkóbũ vé gãkũ agá, ãtíꞌbá ị̃rị̃ ũkú rú rĩ pi vé rĩ agá, ãzini Léyã vé rĩ agá, ꞌbo ị́sụ́ ngá rĩ kuyé. Kã ĩfũú Léyã vé gãkũ agá ꞌdãásĩ, gõ fií Rãélẽ vé gãkũ agá. ");
INSERT INTO kbo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ị́sụ́ ãkũdẽ Rãélẽ ꞌdụ ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú rĩ pi zụ̃ụ́ lãꞌbú ĩ ní ꞌbãá kámĩlõ úgóró gá rĩ agá, úrí drị̃ ni gé. Lãbánã ndã ngá gãkũ agá ꞌdãlé rĩ pi ã ꞌa céré, ị́sụ́ ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú ꞌdĩri kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rãélẽ ní ꞌyozú ẹ́tẹ́pị ní kĩnĩ, “Má ẹ́tẹ́pị, mî ꞌa ã ve má ní ku, má ícó ngaá pá tuú mí ẹndrẹtị gé ụrụ sĩ ku, ãꞌdiãtãsĩyã á ndre nõó mbãá ụ́ꞌdụ́ gí.” Lãbánã ndã ngá ĩ ní údé rií ị̃njị̃ị́ múngú rĩ pi tí, ị́sụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yõkóbũ ã ꞌa ve rá, ĩri ní ꞌyozú Lãbánã ní kĩnĩ, “Ngá má ní ꞌoó ũnjí rĩ ãꞌdi? Tã ũnjí má ní ꞌoó mí ní ínjúzú má vú sĩ rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nóni ꞌí ndã ngá mávé rĩ pi ã ꞌa céré gí, ngá mívé mí ní ị́sụ́ ꞌdĩgé rá rĩ ãꞌdi? Mí íꞌdụ́ kộpi ꞌbãá mávé máríté rĩ pi ẹndrẹtị gé, ãzini mívé rĩ pi ẹndrẹtị gé, kộpi ã acokí rí ꞌbávé tã ãsámvú mí be. ");
INSERT INTO kbo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Má adri nóni caá mí be ílí pụ̃kụ́ ị̃rị̃. Mívé kãbĩlõ rĩ pi ndrị̃ị́ rĩ pi be íꞌbékí anji kuyé. Á nya mívé kãbĩlõ ágó ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ụ̃bụ̃gọ̃ ci dõ mívé kãbĩlõ, dõku ndrị̃ị́, á jị ãvũ ni sẽé mí ní ku, ma ri ãrígó ni ũfẽ ma ꞌi. Ụ̃gụ̃kí dõ mívé kãbĩlõ, dõku ndrị̃ị́ ụ̃tụ́ sĩ, dõku ị́nị́ sĩ, mi ri ꞌyo mâ ũfẽ mí ní ãrígó ni, ma ri ãrígó ni ũfẽ mí ní ãnyãpá mávé rĩ pi sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Á ri mí ní ẹ̃zị́ ngaá ụ̃tụ́ koópi gbírílí rĩ agá, ãzini ãngũ igbeépi igbegbe rĩ agá, ị́nị́ŋá sĩ, á ko ụ́ꞌdụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Má adri mívé ꞌbẹ̃tị́ ãsámvú gé caá ílí pụ̃kụ́ ị̃rị̃. Á nga mí ní ẹ̃zị́ caá ílí mụdrị́ drị̃ ni sụ, mî sẽ rí má ní mívé anji ũkú ị̃rị̃ ꞌdĩꞌbée, ãzini á nga mí ní ẹ̃zị́ caá ílí ázíyá, mî sẽ rí má ní kãbĩlõ, ngá mí ní kõdô lẽzú ma ũfẽzú rĩ, mí újá caá vú be mụdrị́. ");
INSERT INTO kbo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Múngú má ẹ́tẹ́pị Ãbũrámã vé rĩ, ãzini Múngú Ĩsákã ní ruúru rĩ ã adri té dõ má be trụ́ ku, ádarú mi té ma pẽ mụzú drị́ be ule. ꞌBo Múngú ndre ĩzãngã má ní nyaá rĩ rá, Múngú nị̃ ẹ̃zị́ má ní ngaá ũkpõ sĩ rĩ rá, ko mâ ĩzã rá. Ị́nị́ŋá rĩ sĩ, átá mí drị̃gé ũkpó ũkpó tã ũnjí mí ní ꞌoó rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lãbánã ní újázú Yõkóbũ ní kĩnĩ, “Anji ũkú ꞌdĩꞌbée mávé ni, ãnji kộpi ní tịị́ ꞌdĩꞌbée mávé ni, ãnyãpá rĩ pi kpá mávé ni. Ngá mí ní ndreé ꞌdĩꞌbée ãrẽvú céré mávé ni. Ma ãꞌdi ꞌo mávé anji ũkú ꞌdĩꞌbée ní, ãzini ma ãꞌdi ꞌo anji kộpi ní tịị́ rĩ pi ní? ");
INSERT INTO kbo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mí ímụ́, ꞌbá rụkí ũndĩ ꞌbâ ãsámvú gé sĩ mí be, lẽ ꞌbâ drõkí írã use use ni pi rizú ũndĩ ꞌbá ní rụụ́ mí be ꞌdĩri vé tã ígázú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kúru Yõkóbũ ní írã ãmbúgú ni íꞌdụ́zú ịꞌdịzú. ");
INSERT INTO kbo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ĩri ní ꞌyozú ívé máríté rĩ pi ní kĩnĩ, “Ĩmi ĩkũnãkí írã íjị́ drõó vũrã ãlu gé.” Kộpi ní kúru írã ĩkũnãzú íjị́zú drõzú vũrã ãlu gé, Lãbánã pi Yõkóbũ be, kộpi áwíkí ínyá nyaá írã ĩ ní drõó rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lãbánã ní vũrã rĩ ã rụ́ ꞌdazú Jẽgárã Sãhãdútã, Yõkóbũ ꞌda ívé rĩ Gãlédã. ");
INSERT INTO kbo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lãbánã ní ꞌyozú Yõkóbũ ní kĩnĩ, “Írã ĩ ní drõó ꞌdĩri, ĩri ũndĩ ꞌbá ní rụụ́ mi be rĩ vé tã ígázú ãní.” Tã ꞌdĩri sẽ ĩ ní ãngũ rĩ ã rụ́ ꞌdazú Gãlédã ãní. ");
INSERT INTO kbo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Lãbánã ní kpá ꞌyozú kĩnĩ, “Írã ĩ ní drõó ꞌdĩri lũ kínĩ, ꞌbá kãdõ ayií, Úpí Múngú ã ꞌbã mị rizú ꞌbâ ndrezú.” Kúru ĩ ní vũrã rĩ ã rụ́ ꞌdazú Mísĩpã. ");
INSERT INTO kbo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lãbánã ní kpá gõzú ꞌyozú kĩnĩ, “ꞌÍ ꞌo dõ mávé anji ũkú rĩ pi ũnjí, dõku ꞌí gõ dõ ũkú ụrụkọꞌbée jeé, ꞌbá ãzi dõ ꞌbá ãsámvú gé tã rĩ ndreépi ni ꞌdãáyo drãáãsĩyã, Múngú ndre tã ꞌbávé mí be rĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lãbánã ní kpá gõzú ꞌyozú Yõkóbũ ní kĩnĩ, “ꞌÍ ndre írã ĩ ní drõó ꞌdĩri, ꞌí ndre írã ĩ ní ịꞌdịị́ ꞌbâ ãsámvú gé mí be ꞌdĩri. ");
INSERT INTO kbo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Írã ĩ ní drõó ꞌdĩri, ãzini írã ĩ ní ịꞌdịị́ ꞌdĩri, kộpi sẽ ꞌbâ ũndĩ ꞌbá ní rụụ́ mí be ꞌdĩri ã tã ígá ãní. Má ícó agaá írã ĩ ní drõó ꞌdĩri drị̃gé sĩ mụụ́ mi ꞌoó ũnjí ku, mí ícó kpá agaá írã ĩ ní drõó ꞌdĩri drị̃gé sĩ, ãzini írã ĩ ní ịꞌdịị́ ꞌdĩri drị̃gé sĩ ímụ́ ma ꞌoó ũnjí ku. ");
INSERT INTO kbo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Múngú Ãbũrámã vé rĩ, Múngú Nãhórã vé rĩ, Múngú kộpi ẹ́tẹ́pị vé rĩ, ã lị tã ꞌbávé mí be rĩ nĩ.” Kúru Yõkóbũ ní ũyõ sõzú ꞌí ẹ́tẹ́pị Ĩsákã vé Múngú ị̃njị̃ị́ ị̃njị̃ rĩ ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yõkóbũ ní rọ̃bọ̃ŋọ̃ zãzú ãngũ ánga rú rĩ gé ꞌdãlé, zị ívé máríté rĩ pi ímụ́ ínyá nyangárá gá. Kộpi kâ ínyá rĩ nyaá gí, kộpi áwíkí laá ị́nị́ŋá ꞌdãri sĩ ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kã mụụ́ adrií drụ̃ ụ̃ꞌbụ́tịŋá rĩ sĩ, Lãbánã ní ívé anji ũkú rĩ pi ẹzịzú, ĩri ní kpá kộpivé anjiŋá rĩ pi ẹzịzú, ĩri ní tãkíri sẽzú kộpi ní. Ĩri ní kúru mvizú gõzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yõkóbũ ní kpá ngazú ẹ̃cị̃ drị̃gé, mãlãyíkã Múngú vé rĩ pi ní ímụ́zú ĩri ị́sụ́zú. ");
INSERT INTO kbo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yõkóbũ kã kộpi ndreé, ĩri ní ꞌyozú kĩnĩ, “Vũrã nõri Múngú vé ni.” Ĩri ní vũrã rĩ ã rụ́ ꞌdazú Mãhãnãyímũ. ");
INSERT INTO kbo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yõkóbũ ní ꞌbá ụrụkọ pẽzú mụzú drị̃drị̃ ꞌí ẹ́drị́pị Ị́sọ̃wụ̃ vúgá Sẽyírĩ gé, ãngũ Ẽdómã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi lũkí mávé ãmbúgú Ị́sọ̃wụ̃ ní ꞌdíni, ‘Ma mívé ãtíꞌbá, má adri Lãbánã vúgá ꞌdãlé cĩmgbá ícázú ãndrũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ma tị́ be, dõngí be, kãbĩlõ be, ndrị̃ị́ be, ãtíꞌbá ãgõ rú ni pi be, ãtíꞌbá ũkú rú ni pi be. Ãmbúgú mávé rĩ, á pẽ ꞌbá ꞌdĩꞌbée mụzú mí vúgá, lẽ mî ꞌbã ẹ́sị́ múké má ní.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ꞌBá Yõkóbũ ní pẽé rĩ pi kâ ĩ újá ĩgõó Yõkóbũ vúgá nõlé, kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌBá cakí mí ẹ́drị́pị Ị́sọ̃wụ̃ vúgá ꞌdãlé rá, nóni ĩri ri ímụ́ mí vúgá nõlé, kộpi ri ímụ́ ãgõ mụ̃dụ̃rụ̃lụ̃ sụ pi be.” ");
INSERT INTO kbo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yõkóbũ kã tã ꞌdĩri yịị́, ụ̃rị̃ fụ ĩri ambamba. Ĩri ní ꞌbá ívé rĩ pi awazú vũrã sĩ ị̃rị̃, awa kpá kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi, kámĩlõ rĩ pi be vũrã sĩ ị̃rị̃ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yõkóbũ ụ̃sụ̃ kĩnĩ, “Ị́sọ̃wụ̃ ímụ́ dõ ẹ̃ꞌdị́ ꞌdịị́ ngúlúmũ ãlu rĩ be, ngúlúmũ ãzi rĩ ã ápá rí rá.” ");
INSERT INTO kbo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kúru Yõkóbũ ní Múngú ri zịzú kĩnĩ, “Á, Múngú má ẹ́tẹ́pị Ãbũrámã vé rĩ, Múngú má ẹ́tẹ́pị Ĩsákã vé rĩ, Úpí Múngú ꞌyoópi má ní, ‘ꞌÍ mvi gõó vúlé ĩmivé ãngũ gé, mívé máríté rĩ pi vúgá, ma ímụ́ sẽ mi adri ngá be ambamba rĩ.’ ");
INSERT INTO kbo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ma ãtíꞌbá mívé ni, ẹ́sị́ múké mí ní ꞌbãá má ní, ãzini tã mí ní ꞌoó má ní ꞌdĩri, má ícó ãní bã ku. Má ní Yárídénĩ rĩ zongárá gá, ngá má drị́gé rĩ ꞌyéŋá túré, ꞌBo nóni ma ꞌbá be ngúlúmũ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Á Úpí, ꞌí pa ma má ẹ́drị́pị Ị́sọ̃wụ̃ drị́gé sĩ, ma ri ꞌo ĩri sĩ ụ̃rị̃ sĩ, ãꞌdiãtãsĩyã ĩri ri ímụ́ ẹ̃ꞌdị́ ꞌdị má be, mávé ũkú rĩ pi be, ãzini mávé anjiŋá rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ꞌBo mí kĩnĩ, ádarú mi ímụ́ sẽ ma adri ngá be ambamba, ãzini mi ímụ́ sẽ mávé úyú ri ízú kárákará sụ̃ cínyáfã vũgá ꞌdĩri tị́nị, ícókí lãá bã ku.” ");
INSERT INTO kbo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ị́nị́ŋá ꞌdãri sĩ, Yõkóbũ áwí laá ꞌdãlé, íꞌdụ́ ngá ívé rĩ pi ã ụrụkọ sẽé ẹ́drị́pị Ị́sọ̃wụ̃ ní fẽfẽ rú. ");
INSERT INTO kbo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ngá ĩri ní íꞌdụ́ sẽé rĩ pi, ndrị̃ị́ ũkú rĩ pi mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ (200), ndrị̃ị́ ãgõ rĩ pi pụ̃kụ́ ị̃rị̃ (20), kãbĩlõ ũkú rĩ pi mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ (200), kãbĩlõ ãgõ rĩ pi pụ̃kụ́ ị̃rị̃ (20), ");
INSERT INTO kbo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kámĩlõ ũkú rĩ pi pụ̃kụ́ na (30) ẹnjịpị́ị be, tị́ ũkú rĩ pi pụ̃kụ́ sụ (40), tị́ ãgõ rĩ pi mụdrị́ (10), dõngí ũkú rĩ pi pụ̃kụ́ ị̃rị̃ (20), dõngí ãgõ rĩ pi mụdrị́ (10). ");
INSERT INTO kbo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yõkóbũ awa ívé ãnyãpá rĩ pi sẽé ívé ãtíꞌbá rĩ pi drị́gé, kộpi rikí úcé nĩ. Ĩri ní ꞌyozú ãtíꞌbá rĩ pi ní kĩnĩ, “Ĩmi ꞌdekí mụụ́ má ẹndrẹtị gé sĩ drị̃drị̃, ĩmi awakí ãnyãpá rĩ pi, kộpi ã adrikí ãsámvú sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ĩri ní ꞌyozú ꞌbá ãnyãpá jịꞌbá drị̃drị̃ rĩ pi ní kĩnĩ, “Má ẹ́drị́pị Ị́sọ̃wụ̃ ị́sụ́ dõ ĩmi, zị dõ ĩmi, ‘Ĩmi ꞌbá ãꞌdi vé ni pi,’ ãzini ꞌyo dõ ‘Ĩmi ri mụ ngõlé, ãnyãpá ĩmi ní rií jịị́ mụzú ĩmi ẹndrẹtị gé ꞌdĩꞌbée ãꞌdi vé ni?’ ");
INSERT INTO kbo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ĩmi ꞌyokí ĩri ní, ‘Ãnyãpá rĩ pi mívé ãtíꞌbá Yõkóbũ vé ni. Ĩsẽ ãnyãpá nõꞌbée ímụ́zú ívé ãmbúgú Ị́sọ̃wụ̃ ní fẽfẽ rú, ĩri ri ímụ́ ꞌbâ vụ́drị̃ gé vúlé ꞌdĩíꞌdĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ĩri ní kpá ꞌyozú ꞌbá ãnyãpá jịꞌbá ꞌdeꞌbá drị̃drị̃ rĩ pi ã vụ́drị̃ gé rĩ pi ní, ãzini ꞌdeꞌbá ꞌdĩꞌbée ã vụ́drị̃ gé rĩ pi ní ụrụkọꞌbée be kĩnĩ, “Ĩmi ị́sụ́kí dõ Ị́sọ̃wụ̃ ri, ĩmi ꞌyokí ĩri ní tã ãlu ãlu má ní té ꞌyoó ĩmi ní rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ĩmi lũkí Ị́sọ̃wụ̃ ní ꞌyozú kínĩ, ádarú ĩrivé ãtíꞌbá Yõkóbũ ri ímụ́ ĩmi vụ́drị̃ gé vúlé ꞌdĩíꞌdĩ.” Yõkóbũ ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãá kĩnĩ, ngá ꞌí ní sẽé ꞌí ẹ́drị́pị Ị́sọ̃wụ̃ ní fẽfẽ rú ꞌdĩꞌbée, ĩri sẽ ẹ́sị́ ni ri adri ãní ꞌí ní múké. ꞌÍ kãdõ caá vú ni gé ꞌdãá, sâ ãzi sĩ, ĩri ícó ꞌi ẹ́ꞌyị́ rá. ");
INSERT INTO kbo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kúru Yõkóbũ pẽ ngá ꞌí ní lẽé sẽé fẽfẽ rú ẹ́drị́pị ní rĩ pi mụzú drị̃drị̃, ꞌBo ị́nị́ŋá ꞌdãri sĩ, áwí laá vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ị́nị́ŋá ꞌdãri sĩ, Yõkóbũ ní ívé ũkú ị̃rị̃ ꞌdĩꞌbée ꞌdụzú, ívé ãtíꞌbá ũkú rú ị̃rị̃ rĩ pi be, ívé anji ãgõ mụdrị́ drị̃ ni ãlu rĩ pi be, ĩri ní yị̃ị́ Jãbókĩ rĩ zozú kộpi be. ");
INSERT INTO kbo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Kộpi kâ yị̃ị́ rĩ zoó álé ꞌdãá, vụ́drị̃ ni gé, Yõkóbũ ní ꞌi újázú gõzú vúlé. Ĩri ní ívé ngá rĩ pi ãrẽvú pẽzú mụzú céré yị̃ị́ rĩ gé álésĩ. ");
INSERT INTO kbo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kukí ĩri kú vúlé ꞌdãlé ọ́ꞌdụ́kụ́lẹ. Ágó ãzi ímụ́ ũmbã fụụ́ ĩri be kúpé sĩ, kộpi fụkí ĩ ị́nị́ be rã cĩmgbá cazú ụ̃ꞌbụ́tịŋá gá. ");
INSERT INTO kbo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ágó rĩ kã ndreé ꞌí ndẽ Yõkóbũ ã ũkpõ kuyé, ĩri ní Yõkóbũ ã ụ̃lụ́gbẹ́ sị̃zú ãtrũzú. ");
INSERT INTO kbo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ágó rĩ ní ꞌyozú kĩnĩ, “ꞌÍ ku mâ mụ, ãꞌdiãtãsĩyã ãngũ rĩ ọ́wụ́ gí.” Yõkóbũ ní újázú ĩri ní kĩnĩ, “ꞌÍ sẽ dõ má ní tãkíri kuyé, á ku mi mụụ́ ku.” ");
INSERT INTO kbo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ágó rĩ ní ĩri zịzú kĩnĩ, “Mî rụ́ ãꞌdi ꞌi?” Ĩri ní újázú kĩnĩ, “Mâ rụ́ Yõkóbũ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ágó rĩ ní ꞌyozú kĩnĩ, “Zịkí nóni mî rụ́ Yõkóbũ ꞌi ku, ĩ mî rụ́ zị Ĩsẽrélẽ, ãꞌdiãtãsĩyã ꞌí fụ ũmbã kúpé sĩ Múngú be, ãzini ãgõ rĩ pi be, ꞌí ndẽ kộpi ã ũkpõ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yõkóbũ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ lũ mî rụ́ má ní.” Ĩri ní újázú kĩnĩ, “Ngá mí ní lẽzú mâ rụ́ nị̃zú rĩ ãꞌdi?” Ĩri ní kúru tãkíri sẽzú Yõkóbũ ní. ");
INSERT INTO kbo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yõkóbũ ní vũrã rĩ ã rụ́ ꞌdazú Pẽnĩyélẽ, ĩri ní ꞌyozú kĩnĩ, “Á ndre Múngú ã rụ́ꞌbá gí, á drã kuyé, ma ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ụ̃tụ́ rĩ kã rií ĩfũú, Yõkóbũ fũ Pẽnĩyélẽ agásĩ, ri mụụ́ ụ̃dụ́ ãlu drị̃gé, ãꞌdiãtãsĩyã ụ̃lụ́gbẹ́ ni ãtrũ ꞌi gí. ");
INSERT INTO kbo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tã ꞌdĩri sẽ cĩmgbá ícázú ãndrũ sĩ, ꞌbá Ĩsẽrélẽ vé rĩ pi nyakí ị́sụ́bãá ụ̃lụ́gbẹ́ rụ́ꞌbá gá rĩ ku, ãꞌdiãtãsĩyã ĩ ní Yõkóbũ ã ụ̃lụ́gbẹ́ sị̃ị́ ãtrũú rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yõkóbũ kã mụụ́ ꞌî drị̃ ingaá ụrụ, ndre Ị́sọ̃wụ̃ ri ímụ́ ívé ãgõ mụ̃dụ̃rụ̃lụ̃ sụ rĩ pi be, ĩri ní anjiŋá rĩ pi acozú sẽzú Léyã vúgá, Rãélẽ vúgá, ãzini ívé ãtíꞌbá ũkú rú rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ãtíꞌbá ũkú rú rĩ pi ĩvé anjiŋá rĩ pi be, kộpi ꞌdekí drị̃drị̃, Léyã pi ívé anjiŋá rĩ pi be, ꞌdekí kộpi vúgá sĩ, Rãélẽ pi Yõsépã be, ꞌdekí vúlé. ");
INSERT INTO kbo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yõkóbũ ní agazú mụzú drị̃drị̃, kã caá ẹ́drị́pị vúgá ꞌdãá, ĩri ní kũmũcí ũtị̃zú, ọ̃vụ̃ ꞌî drị̃ sị̃ị́ nyọ̃ọ́kụ́ gé ꞌdãá vú be ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ị́sọ̃wụ̃ ní njuzú mụzú Yõkóbũ vúgá ꞌdãá, ĩri ní ĩri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ, ĩri ní ĩri ã umbe ndrãzú drị́ sĩ, ĩri ẽ tị ndruzú. Kộpi ní íꞌdózú ngozú. ");
INSERT INTO kbo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ị́sọ̃wụ̃ kã ꞌî drị̃ ingaá ụrụ, ĩri ní ũkú rĩ pi ndrezú anjiŋá rĩ pi be, ĩri ní Yõkóbũ ri zịzú kĩnĩ, “ꞌBá mí be ꞌdĩꞌbée ãꞌdi pi?” Yõkóbũ ní újázú kĩnĩ, “Anjiŋá nõꞌbée Múngú ní sẽé ívé ẹ́sị́ múké rĩ sĩ mívé ãtíꞌbá ní rĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kúru ãtíꞌbá ũkú rú rĩ pi ĩvé anjiŋá rĩ pi be, kộpi ní cazú Ị́sọ̃wụ̃ vúgá ꞌdãá, kộpi ní kũmũcí ũtị̃zú, ọ̃vụ̃zú ĩ drị̃ sị̃zú nyọ̃ọ́kụ́ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kộpi ã vụ́drị̃ gé, Léyã pi ívé anjiŋá rĩ pi be, kộpi ní kũmũcí ũtị̃zú, ọ̃vụ̃zú ĩ drị̃ sị̃zú nyọ̃ọ́kụ́ gé ꞌdãá. Yõsépã pi ní kpá cazú Rãélẽ be, kộpi ní kpá kũmũcí ũtị̃zú, ọ̃vụ̃zú ĩ drị̃ sị̃zú nyọ̃ọ́kụ́ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ị́sọ̃wụ̃ ní Yõkóbũ ri zịzú kĩnĩ, “Tã mí ní ãnyãpá má ní ị́sụ́ ꞌdĩꞌbée ĩpẽzú ímụ́zú rĩ ãꞌdi?” Yõkóbũ ní ꞌyozú ĩri ní kĩnĩ, “Ãmbúgú mávé rĩ, má ĩpẽ kộpi, mî ꞌbã rí ẹ́sị́ múké má ní.” ");
INSERT INTO kbo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ꞌBo Ị́sọ̃wụ̃ ní ꞌyozú kĩnĩ, “Má ẹ́drị́pị, ma ngá be ambamba, ngá mívé ꞌdĩꞌbée, ꞌí rụ kộpi ã adrikí mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yõkóbũ ní ꞌyozú kĩnĩ, “Kuyé! ꞌÍ ꞌbã dõ ẹ́sị́ múké má ní rá, mí ẹ́ꞌyị́ fẽfẽ má ní sẽé mí ní nõꞌbée. Mí ní ma ẹ́ꞌyị́ ẹ́sị́ be céré rĩ sĩ, á ndre mî ẹndrẹtị índré sụ̃ má ní Múngú ẽ ẹndrẹtị ndreé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Lẽ mî ẹ́ꞌyị́ ngá má ní íjị́ sẽé mí ní nõri, ãꞌdiãtãsĩyã Múngú ꞌbã ẹ́sị́ múké má ní, sẽ má ní ngá má ní lẽé rĩ pi ãrẽvú céré gí.” Yõkóbũ si Ị́sọ̃wụ̃ ri ũkpõ sĩ, ụ̃dụ̃ ni, Ị́sọ̃wụ̃ ãꞌyĩ ngá rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kúru Ị́sọ̃wụ̃ ní ꞌyozú kĩnĩ, “ꞌBá ꞌdekí mụụ́ mí be trụ́, ma ꞌde drị̃drị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ꞌBo Yõkóbũ ní ꞌyozú ĩri ní kĩnĩ, “Ãmbúgú mávé rĩ, ꞌí ndre, anjiŋá mávé rĩ pi drĩ nyíríŋá, mávé ndrị̃ị́ rĩ pi, tị́ rĩ pi be, kộpivé anjiŋá kpá drĩ nyíríŋá. Drokí dõ kộpi mụzú ũkpõ sĩ ụ́ꞌdụ́ ãlu agá, kộpi ũdrã céré. ");
INSERT INTO kbo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ãmbúgú mávé rĩ, lẽ mî ꞌde mụzú drị̃drị̃, ma ãtíꞌbá mívé ni, ma mụ anjiŋá rĩ pi be, ãzini ãnyãpá rĩ pi be mãdã mî vụ́drị̃ gé sĩ, ma mụ mi ị́sụ́ Sẽyírĩ gé ꞌdãlé.” ");
INSERT INTO kbo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ị́sọ̃wụ̃ ní ꞌyozú kĩnĩ, “Lẽ mâ ku mávé ãgõ ụrụkọꞌbée kú mí vúgá nõgó.” Yõkóbũ ní ꞌyozú kĩnĩ, “Adri ꞌdíni ku, ãmbúgú mávé rĩ, lẽ mî ꞌbã drĩ ẹ́sị́ múké má ní ká.” ");
INSERT INTO kbo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kúru ụ́ꞌdụ́ ꞌdãri gé, Ị́sọ̃wụ̃ ní ꞌi újázú gõzú vúlé Sẽyírĩ gé ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ꞌBo Yõkóbũ ꞌde ívé rĩ mụụ́ Sũkótõ gá, ãngũ Pãdãnã Ãrámã vé rĩ gé, ĩri ní jó sịzú ꞌí ní, ãzini ĩri ní ápãlá ꞌbezú ívé ãnyãpá rĩ pi ní. Sẽ ĩ ní vũrã rĩ ã rụ́ ꞌdazú Sũkótõ ãní. ");
INSERT INTO kbo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kúru Yõkóbũ ní ngazú fũzú ãngũ Pãdãnã Ãrámã vé rĩ agásĩ, ĩri ní cazú kụ̃rụ́ Sẽkémẽ vé rĩ gé, ãngũ Kãnánã vé rĩ agá, ca ꞌdãlé múké. Ĩri ní ívé gãkũ sịzú vũrã ꞌdãri gé, sị gãkũ rĩ kụ̃rụ́ rĩ gé ãmvélésĩla. ");
INSERT INTO kbo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yõkóbũ je nyọ̃ọ́kụ́ ꞌí ní gãkũ rĩ sịzú rĩ anji Hãmórã vé rĩ pi vúgá, Hãmórã ri Sẽkémẽ vé ẹ́tẹ́pị, ũfẽ mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ni mụ̃dụ̃rụ̃lụ̃ ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ĩri ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú, ĩri ní rụ́ ni ꞌdazú Ẽlĩ Ẹ̃lọ́yị̃ Ĩsẽrélẽ. ");
INSERT INTO kbo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ụ́ꞌdụ́ ãlu, Dị́nã mvá ũkú Léyã ní tịị́ Yõkóbũ ní rĩ mụ anji ũkú adriꞌbá ãngũ ꞌdãri agá rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sẽkémẽ kã mụụ́ Dị́nã rĩ ndreé, ĩri ní Dị́nã ri rụzú lazú ĩri sĩ ũkpõ sĩ. Sẽkémẽ ri Hãmórã Hívĩ adriípi drị̃koma rú vũrã ꞌdãri gé rĩ vé mvá. ");
INSERT INTO kbo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sẽkémẽ ꞌbã ẹ́sị́ kú Yõkóbũ vé mvá ũkú Dị́nã drị̃gé, lẽ mvá ũkú rĩ ambamba, ri mvá ũkú rĩ ní tã múké ni átá. ");
INSERT INTO kbo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sẽkémẽ ní ꞌyozú ẹ́tẹ́pị Hãmórã ní kĩnĩ, “ꞌÍ je mvá ũkú ꞌdĩri má ní ũkú rú.” ");
INSERT INTO kbo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yõkóbũ kã yịị́ kínĩ Sẽkémẽ rụ ívé mvá ũkú Dị́nã ri lazú ũkpõ sĩ, ívé anji ãgõ rĩ pi drĩ ri ãnyãpá rĩ pi úcé ásé agá ꞌdãáꞌdã, Yõkóbũ újí kíri, ꞌyo tã ãzi kuyé, cĩmgbá kộpi ní ímvízú ĩgõzú ꞌbẹ̃tị́ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kúru Sẽkémẽ ẹ́tẹ́pị Hãmórã ní mụzú átázú Yõkóbũ be ãjẽ mvá ũkú rĩ vé rĩ ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anji Yõkóbũ vé rĩ pi kâ tã ꞌi ngaápi ꞌdĩri yịị́, kộpi ní ímụ́zú ásé agá ꞌdãásĩ ꞌbẹ̃tị́. Tã ꞌdĩri sẽ kộpi ní ĩzãngã, kộpi ã ꞌa ve ãní ũnjí ũnjí, ãꞌdiãtãsĩyã Sẽkémẽ ꞌo tã drị̃njá sẽépi ni ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé, la mvá ũkú Yõkóbũ vé rĩ sĩ, ꞌo tã ĩ ní kõdô ícó ꞌoó ku ni. ");
INSERT INTO kbo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hãmórã kã ímụ́ Yõkóbũ ri ndreé, ĩri ní ꞌyozú Yõkóbũ ní, ãzini Yõkóbũ ẹnjịpị́ị ní kĩnĩ, “Mávé mvá Sẽkémẽ ꞌbã ẹ́sị́ mívé mvá ũkú Dị́nã drị̃gé. Mî sẽ ĩri jeé Sẽkémẽ ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Lẽ ꞌbâ jekí ꞌbâ ꞌbâ ãsámvú gé sĩ jeje. Ĩmi sẽkí ĩmivé anji ũkú jeé ꞌbá ní, ꞌbâ kpá ꞌbávé anji ũkú sẽ je ĩmi ní. ");
INSERT INTO kbo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ĩmi adri ꞌbâ ãsámvú gé nõgó, ĩmi ícó adri vũrã ĩmi ní lẽé rĩ gé rá. Ĩmi adri ãngũ rĩ agá, ĩmi ngá ụzị, ĩmi nyọ̃ọ́kụ́ ị́sụ́ je ãngũ rĩ agá rá.” ");
INSERT INTO kbo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kúru Sẽkémẽ ní ꞌyozú Dị́nã ẹ́tẹ́pị ní, ãzini Dị́nã ẹ́drị́pị́ị ní kĩnĩ, “Lẽ ĩmi ꞌbãkí ẹ́sị́ múké má ní, ngá ĩmi ní zịị́ má vúgá rĩ, ma sẽ ĩmi ní rá. ");
INSERT INTO kbo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ĩmi lũkí má ní ãjẽ rĩ ã vúgú, ãzini ngá ĩmi ní lẽé rĩ, ma ícó ũfẽ ĩmi ní rá. Lẽ ĩmi sẽkí mvá ũkú rĩ má ní ũkú rú.” ");
INSERT INTO kbo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sẽkémẽ ní Dị́nã ri rụụ́ lazú ũkpõ sĩ rĩ sĩ, sẽ anji ãgõ Yõkóbũ vé rĩ pi ũꞌbãkí Sẽkémẽ pi ẽ mị ẹ́tẹ́pị Hãmórã be. ");
INSERT INTO kbo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kộpi ꞌyokí Sẽkémẽ pi ní ẹ́tẹ́pị be kínĩ, “ꞌBá ícókí ꞌbávé ọ́mvụ́pị sẽé jeé ágó ĩ ní ágélé ni ẽ tị lịị́ kuyé rĩ ní ku, ãꞌdiãtãsĩyã ĩri adri ꞌbá ní drị̃njá rú. ");
INSERT INTO kbo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ꞌBá lẽkí ꞌyoó ĩmi ní ꞌdíni, lẽ ã úlị́kí ãgõ ĩmivé rĩ pi ã ágélé ẽ tị rá, ĩmi adrikí rí sụ̃ ꞌbá tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kúru ꞌbâ ꞌbávé anji ũkú sẽ je ĩmi ní rá, ꞌbâ kpá ícó anji ũkú ĩmivé rĩ pi je rá. ꞌBâ adri ĩmi ãsámvú gé, ꞌbâ adri ĩmi be ngá ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ꞌBo ĩmi ãꞌyĩkí dõ ĩmî ágélé ẽ tị sẽé úlị́ kuyé, ꞌbâ ꞌbá ọ́mvụ́pị Dị́nã ri ꞌdụ, ꞌbâ ꞌde mụzú rá.” ");
INSERT INTO kbo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hãmórã pi mvọ́pị Sẽkémẽ be, ãꞌyĩkí tã kộpi ní ꞌyoó ꞌdĩri rá. ");
INSERT INTO kbo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kẹ̃rị́mvá Sẽkémẽ ri, ị̃njị̃kí ĩri agaá rá ẹ́tẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé ꞌdãá, iza sâ kuyé, ꞌdụ tã ĩ ní ꞌyoó ꞌdĩri ngaá rá, ãꞌdiãtãsĩyã lẽ Yõkóbũ vé mvá ũkú Dị́nã ri ẹ́sị́ be céré. ");
INSERT INTO kbo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kúru Hãmórã pi mvọ́pị Sẽkémẽ be, kộpi ní ꞌdezú mụzú ĩvé kụ̃rụ́ rĩ vé kẹ̃ẹ́tịlé gá ꞌdãá, kộpi mụkí átá ĩ ọ̃gụ̃pị́ị kụ̃rụ́ agá ꞌdãá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Kộpi ní ꞌyozú kínĩ, “Ãgõ nõꞌbée ũndĩ ꞌbávé ni. Lẽ kộpi ã adrikí ãngũ ꞌbávé rĩ agá nõgó, kộpi ã ụzịkí ngá ãngũ rĩ agá nõgó. Ãngũ rĩ kộpi ní ãmbúgú. ꞌBâ ícó kộpivé anji ũkú je rá, kộpi ícó ꞌbávé rĩ pi je rá. ");
INSERT INTO kbo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ꞌBo ꞌbávé ãgõ rĩ pi ãꞌyĩkí dõ ĩ ágélé ẽ tị sẽé úlị́ rá sụ̃ kộpivé rĩ tị́nị, kúru ꞌbá ꞌdĩꞌbée ícó adri ꞌbâ ãsámvú gé nõgó rá, ꞌbâ adri kộpi be ngá ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ꞌBo ꞌbá ꞌokí dõ ꞌdíni, ãnyãpá kộpivé rĩ, ãzini ngá kộpivé rĩ pi ãrẽvú céré adri ꞌbávé ni. Lẽ ꞌbâ ãꞌyĩkí tã kộpi ní ꞌyoó rĩ, kộpi ã adrikí rí ꞌbâ ãsámvú gé nõgó.” ");
INSERT INTO kbo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ãgõ mụꞌbá kụ̃rụ́ rĩ vé kẹ̃ẹ́tịlé gá ꞌdãlé rĩ pi ãrẽvú céré ãꞌyĩkí tã Hãmórã pi ní ꞌyoó mvọ́pị Sẽkémẽ be rĩ rá, ãzini ãgõ kụ̃rụ́ agá rĩ pi ãrẽvú céré sẽkí ĩ ágélé ẽ tị úlị́ rá. ");
INSERT INTO kbo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kộpi kâ úlị́ngárá rĩ vé ãzó taá caá ụ́ꞌdụ́ na, vụ́drị̃ ni gé, Yõkóbũ vé anji ãgõ ị̃rị̃ Sĩmĩyónã pi Lẹ́vị̃ be, Dị́nã vé ẹ́drị́pị́ị, kộpi ní ị́lị́ ãco ãco ni pi uꞌdụzú, kộpi ní mụzú ãgõ kụ̃rụ́ agá rĩ pi úꞌdị́zú ũdrãzú céré. ");
INSERT INTO kbo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Kộpi ũsõkí Hãmórã pi mvọ́pị Sẽkémẽ be ị́lị́ ãco ãco ꞌdĩꞌbée sĩ ũdrãá rá. Kộpi ísékí Dị́nã ri Sẽkémẽ vé jó agá ꞌdãásĩ, kộpi jịkí ĩri mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yõkóbũ vé anji ãgõ ụrụkọꞌbée ní cazú ãvũ rĩ pi ã gãrã gá ꞌdãá, kộpi ní ngá kụ̃rụ́ agá rĩ pi alizú, ãꞌdiãtãsĩyã rụkí kộpivé ọ́mvụ́pị lazú kụ̃rụ́ ꞌdãri agá. ");
INSERT INTO kbo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kộpi alikí kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi, dõngí rĩ pi, ngá kụ̃rụ́ agá rĩ pi ãrẽvú céré, ãzini kộpi alikí ngá kụ̃rụ́ rĩ gé ãmvélésĩla ásé agá rĩ pi ãrẽvú céré. ");
INSERT INTO kbo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kộpi uꞌdụkí ãꞌbú kụ̃rụ́ agá rĩ pi ãrẽvú céré, kộpi urụkí ũkú rĩ pi anjiŋá rĩ pi be jịị́ mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kúru Yõkóbũ ní ꞌyozú Sĩmĩyónã pi ní Lẹ́vị̃ be kĩnĩ, “Nóni ĩmi íjị́kí tã ũnjí má drị̃gé gí, ĩmi sẽkí ꞌbá Kãnánã vé rĩ pi, ãzini ꞌbá Pẽrízĩ vé ãngũ nõri agá rĩ pi ndrekí ma ũnjí. ꞌBávé kãlãfe mãdãŋáŋá, kộpi úmúkí dõ ĩ ẹ̃ꞌdị́ ꞌdịị́ ꞌbá be, kộpi ꞌbâ úꞌdị́ ũdrã ꞌbá mávé ꞌbẹ̃tị́ ãsámvú gé rĩ pi be céré.” ");
INSERT INTO kbo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kộpi ní újázú ĩri ní kínĩ, “ꞌÍ lẽ ã ꞌdụ ꞌbá ọ́mvụ́pị ri ꞌbãá sụ̃ ũkú adriípi ọ̃wụ́ rú ni tị́nị?” ");
INSERT INTO kbo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kúru Múngú ní ꞌyozú Yõkóbũ ní kĩnĩ, “ꞌÍ nga, ꞌí mụ adrií Bẽtélẽ gá. ꞌÍ sị vũrã rọ̃bọ̃ŋọ̃ zãzú ni Múngú ní vũrã ꞌdãri gé. Múngú ꞌdĩri ándúrú ꞌi iꞌdaápi mí ní sâ mí ní ápázú mí ẹ́drị́pị Ị́sọ̃wụ̃ sĩ rĩ gé rĩ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kúru Yõkóbũ ní ꞌyozú ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní, ãzini ꞌbá mụꞌbá ĩri be trụ́ rĩ pi ní kĩnĩ, “Lẽ ĩmi úꞌbékí ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú ꞌdĩꞌbée ãmvé, ĩmi ũjĩkí ĩmi ícá uletere, ĩmi úsúkí bõngó ule ni pi áyu. ");
INSERT INTO kbo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ĩmi ímụ́kí, ꞌbá ꞌdekí mụzú Bẽtélẽ gá, vũrã úmvúlésĩ má ní mụzú vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú Múngú ní rĩ gé, Múngú ꞌdĩri ándúrú mávé zịngárá yịị́pi sâ má ní ĩzãngã nyazú rĩ gé rĩ ꞌi. Ri adrií má be trụ́ vũrã má ní ẹ́cị́zú rĩ pi agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kúru kộpi ní ngá ĩ ní údé rií ị̃njị̃ị́ múngú rú rĩ pi íꞌdụ́zú céré sẽzú Yõkóbũ ní, kộpi ní kpá kãlákála ĩvé rií ũꞌyĩí bị́ gé rĩ pi ũtrũzú sẽzú ĩri ní. Yõkóbũ ní ꞌbụ́ gazú ngá ꞌdĩꞌbée sị̃zú ãní pẹtị ãmbúgú ĩnyiŋá Sẽkémẽ gá rĩ ã ndụ́gé. ");
INSERT INTO kbo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yõkóbũ pi kâ rií mụụ́ ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, Múngú sẽ ụ̃rị̃ fií ꞌbá kụ̃rụ́ agá rĩ pi ẹ́sị́ agá ambamba, sẽ kộpi drokí Yõkóbũ pi ã vụ́drị̃ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yõkóbũ pi ní cazú ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be kụ̃rụ́ Lụ́zị̃ vé rĩ gé. Kụ̃rụ́ ꞌdĩri ĩ nóni zị Bẽtélẽ, ĩri ãngũ Kãnánã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ĩri ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú ꞌdãlé, ĩri ní vũrã rĩ ã rụ́ ꞌdazú Ẽlĩ Bẽtélẽ ãꞌdiãtãsĩyã Múngú iꞌda ꞌi ándúrú Yõkóbũ ní ꞌdãgá sâ ĩri ní ápázú ẹ́drị́pị Ị́sọ̃wụ̃ sĩ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Dẽbúrã ọ́tụ́ riípi Rẽbékã vé anji ũtẽépi rĩ drã vũrã ꞌdãri gé, sị̃kí ĩri pẹtị Bẽtélẽ gá rĩ ã ndụ́gé. Kúru ĩ ní pẹtị ꞌdãri ã rụ́ ꞌdazú Ãlõnĩ Bãkútĩ. ");
INSERT INTO kbo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yõkóbũ kã ímví ĩgõó Pãdãnã Ãrámã gá ꞌdãásĩ, Múngú iꞌda ꞌi ĩri ní dị̃ị́, sẽ ĩri ní tãkíri. ");
INSERT INTO kbo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Múngú ní ꞌyozú ĩri ní kĩnĩ, “Mî rụ́ Yõkóbũ, ꞌbo nóni gõkí mî rụ́ zịị́ Yõkóbũ ku, ĩ mî rụ́ zị Ĩsẽrélẽ.” ");
INSERT INTO kbo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Múngú ní gõzú ꞌyozú ĩri ní kĩnĩ, “Ma Múngú Ũkpõ ꞌDị́pa ꞌi, lẽ mî tị ízú tré, anji mívé rĩ pi vé kãlãfe ã ga tré. Sụ́rụ́ kárákará pi ímụ́ ĩfũ mî rụ́ꞌbá gá, ꞌbãgú rĩ pi kpá ímụ́ ĩfũ mî rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ãngũ má ní sẽé Ãbũrámã pi ní Ĩsákã be rĩ, ma ímụ́ sẽ mí ní. Ma ímụ́ ãngũ nõri sẽ úyú mívé rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Múngú ní ꞌdezú mụzú, ĩri ní Yõkóbũ ri kuzú kú vũrã ꞌí ní átázú ĩri be rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yõkóbũ ní írã íꞌdụ́zú ịꞌdịzú vũrã Múngú ní átázú ꞌí be rĩ gé, ĩri ní vị́nyọ̃ íꞌdụ́zú dãzú írã ꞌí ní ịꞌdịị́ rĩ drị̃gé, ĩri ní kpá ũdu íꞌdụ́zú dãzú drị̃ ni gé, Múngú ri ị̃njị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yõkóbũ ní vũrã Múngú ní átázú ꞌí be rĩ ã rụ́ ꞌdazú Bẽtélẽ. ");
INSERT INTO kbo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kộpi ní ngazú Bẽtélẽ gá ꞌdãásĩ, ꞌdezú mụzú Ẽfãrátã gá. Kộpi ní drĩ cazú Ẽfãrátã gá ꞌdãá kuyé rĩ gé, Rãélẽ ã ꞌa ní íꞌdózú ásózú, ĩrivé tĩngárá ũkpó ũkpó. ");
INSERT INTO kbo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ĩrivé tĩngárá kã ícá ũkpó ũkpó, ũkú riípi ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koópi rĩ ní ꞌyozú Rãélẽ ní kĩnĩ, “Mí adri ụ̃rị̃ sĩ ku, mvá ãzi mí ní rií tĩí ꞌdĩri, ĩri mvá ágóŋá.” ");
INSERT INTO kbo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rãélẽ vé ídri kã íꞌdó fũú, ĩri ní mváŋá rĩ ã rụ́ ꞌdazú Bẽnónĩ ꞌi. Ẹ́tẹ́pị ꞌda ívé rĩ Bẹ̃nyẹ̃mị́nẹ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rãélẽ ní kúru drãzú, sị̃kí ĩri lẹ́tị mụụ́pi kụ̃rụ́ Ẽfãrátã vé rĩ gé. (Kụ̃rụ́ Ẽfãrátã vé rĩ ĩ kpá zị Bẽtẽlémẽ.) ");
INSERT INTO kbo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yõkóbũ ní írã íꞌdụ́zú ịꞌdịzú Rãélẽ vé ꞌbụ́rẹ̃drị̃ gé. Cĩmgbá ícázú ụ́ꞌdụ́ ãndrũ nõri gé, írã ĩ ní ịꞌdịị́ ꞌdãri, ĩri Rãélẽ vé ꞌbụ́rẹ̃drị̃ iꞌda. ");
INSERT INTO kbo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ĩsẽrélẽ ní ꞌi útrúzú mụzú drị̃drị̃, ĩri ní ívé gãkũ sịzú Mĩgĩdálã Ẽdérẽ gá, lágáráka ã wọ̃ọ́kọ̃ ándrélésĩla rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ĩsẽrélẽ kã rií adrií ãngũ ꞌdãri agá, Rũbénã ní lazú ẹ́tẹ́pị Yõkóbũ vé ũkú Bílã sĩ, Yõkóbũ yị tã ni rá. Yõkóbũ ri anji ãgõ be mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Anji Léyã vé rĩ pi Rũbénã ꞌi, ĩri mvá kãyú Yõkóbũ vé rĩ, ĩri ã vụ́drị̃ gé rĩ pi Sĩmĩyónã ꞌi, Lẹ́vị̃ ꞌi, Yụ́dã ꞌi, Ĩsãkárã ꞌi, Jẽbũlúnã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Anji Rãélẽ vé rĩ pi Yõsépã pi Bẹ̃nyẹ̃mị́nẹ̃ be. ");
INSERT INTO kbo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rãélẽ vé ãtíꞌbá Bílã vé anji ãgõ rĩ pi Dánã pi Nãfãtálĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Léyã vé ãtíꞌbá Jẽléfã vé anji ãgõ rĩ pi Gádĩ pi Ãsérã be. Anji ãgõ ꞌdĩꞌbée ũkú rĩ pi tịkí Yõkóbũ ní Pãdãnã Ãrámã gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yõkóbũ ní cazú ẹ́tẹ́pị Ĩsákã vúgá Mãmúrẽ gá ꞌdãlé, ĩnyi Kĩrĩyátã-Ãrábã (nóni ĩ ní zịị́ Hẽbẽrónã) rĩ gé, vũrã ọ́tụ́ Ãbũrámã pi ní adrizú Ĩsákã be rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ĩsákã adri caá ílí mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ãrõ (180). ");
INSERT INTO kbo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ĩri ní kúru drãzú, drã ị́sụ́ ãkũdẽ dẽ ícá ãrãkã rú gí, ĩrivé ídri fũ mụụ́ adrií ívé ꞌbá ũdrãꞌbá gí rĩ pi ãsámvú gé. Ĩrivé anji ãgõ Ị́sọ̃wụ̃ pi ní ĩri sị̃zú Yõkóbũ be. ");
INSERT INTO kbo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Úyú Ị́sọ̃wụ̃ vé rĩ pi ꞌdĩ. (Ị́sọ̃wụ̃ vé rụ́ ãzi rĩ Ẽdómã ꞌi.) ");
INSERT INTO kbo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ị́sọ̃wụ̃ je ívé ũkú rĩ pi íngázú anji ũkú Kãnánã vé rĩ pi ãsámvú gé. Ũkú kãyú rĩ Ãdá ꞌi, ĩri Ẽlónĩ Hị́tị̃gú rĩ vé mvá ũkú, ꞌdeépi vú ni gé sĩ rĩ Õhõlĩbámã ꞌi, ĩri Ánã vé mvá ũkú, ĩrivé ẹ́ꞌbị́pị Zĩbẽyónã Hívĩgú rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ũkú ụ̃dụ́ rĩ Bãsẽmátã ꞌi, ẹ́tẹ́pị ni Ĩsĩmãélẽ ꞌi, ĩrivé ọ́mvụ́pị Nẽbãyótĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ãdá tị Ẽlĩfájã ri Ị́sọ̃wụ̃ ní, Bãsẽmátã tị Rẽúlẽ ri, ");
INSERT INTO kbo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Õhõlĩbámã tị Jẽúsĩ pi Jãlámã be, Kórã sĩ. Anji ãgõ ꞌdĩꞌbée Ị́sọ̃wụ̃ vé ni, tịkí kộpi Kãnánã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ị́sọ̃wụ̃ ꞌdụ ívé ũkú rĩ pi, anji ãgõ rĩ pi, anji ũkú rĩ pi, ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi, ívé ãnyãpá rĩ pi, ngá ãrẽvú céré ĩri ní ị́sụ́ Kãnánã gá ꞌdãá rĩ pi be, mụ adrií ẹ́drị́pị Yõkóbũ gãrã gá sĩ rárá rú. ");
INSERT INTO kbo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kộpivé ãꞌbú ízú ambamba, sẽ kộpi ícókí adrií ẹ́drị́pị be trụ́ ku, ãnyãpá rĩ pi ní adrií tré rĩ sĩ, vũrã kộpi ní adrizú rĩ ca kộpi ní ku. ");
INSERT INTO kbo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","(Ị́sọ̃wụ̃ vé rụ́ ãzi Ẽdómã ꞌi.) Ị́sọ̃wụ̃ ní kúru ꞌdezú mụzú adrizú ãngũ ánga rú Sẽyírĩ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ị́sọ̃wụ̃ ri sụ́rụ́ Ẽdómã vé rĩ pi vé ẹ́ꞌbị́pị, úyú ĩrivé rĩ pi rikí adrií ãngũ ánga rú Sẽyírĩ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Anji ãgõ Ị́sọ̃wụ̃ vé rĩ pi vé rụ́, Ẽlĩfájã ꞌi, ĩrivé ẹ́ndrẹ́pị Ãdá ꞌi, mvá ágó rĩ ãzi Rẽúlẽ ꞌi, ĩrivé ẹ́ndrẹ́pị Bãsẽmátã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Anji ãgõ Ẽlĩfájã vé rĩ pi, Tẽmánã ꞌi, Ómãrĩ ꞌi, Zéfõ ꞌi, Gãtámã ꞌi, Kẽnázĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ị́sọ̃wụ̃ vé mvá Ẽlĩfájã ri ũkú ãzi be, ũkú rĩ ã rụ́ Tímĩnã ꞌi, tị Ãmãlékẽ ri nĩ. Anji ꞌdĩꞌbée vé ẹ́ꞌbị́pị Ị́sọ̃wụ̃ ꞌi, kộpivé ị̃drẹ́pị Ãdá ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Anji ãgõ Rẽúlẽ vé rĩ pi, Nãhátã ꞌi, Zérã ꞌi, Sámã ꞌi, Mízã sĩ. Anji ꞌdĩꞌbée vé ẹ́ꞌbị́pị Ị́sọ̃wụ̃ ꞌi, kộpivé ị̃drẹ́pị Bãsẽmátã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ị́sọ̃wụ̃ vé ũkú Õhõlĩbámã vé ẹ́ndrẹ́pị Ánã ꞌi, Õhõlĩbámã ri Zĩbẽyónã mvọ́pị ã mvá. Anji Ị́sọ̃wụ̃ pi ní tịị́ Õhõlĩbámã be rĩ, Jẽúsĩ ꞌi, Jãlámã ꞌi, Kórã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ị́sọ̃wụ̃ vé mvá kãyú Ẽlĩfájã vé anji ãgõ rĩ pi gõkí adrií drị̃koma rú. Anji rĩ pi vé rụ́, Tẽmánã ꞌi, Ómãrĩ ꞌi, Zéfõ ꞌi, Kẽnázĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kórã ꞌi, Gãtámã ꞌi, Ãmãlékẽ sĩ. Anji Ẽlĩfájã vé drị̃koma rú ꞌdĩꞌbée, kộpi ri adri ãngũ Ẽdómã vé rĩ agá, kộpivé ị̃drẹ́pị Ãdá ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ị́sọ̃wụ̃ vé mvá Rẽúlẽ vé anji ãgõ gõkí ícá drị̃koma rú, kộpivé rụ́, Nãhátã ꞌi, Zérã ꞌi, Sámã ꞌi, Mízã sĩ. Anji drị̃koma rú ꞌdĩꞌbée Rẽúlẽ vé ni, kộpi ri adri ãngũ Ẽdómã vé rĩ agá, anji ꞌdĩꞌbée zịkí Ị́sọ̃wụ̃ vé ũkú Bãsẽmátã ri ị̃drẹ́pị. ");
INSERT INTO kbo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Anji Ị́sọ̃wụ̃ pi ní tịị́ ũkú ni Õhõlĩbámã be rĩ pi gõkí ícá drị̃koma rú, anji rĩ pi vé rụ́, Jẽúsĩ ꞌi, Jãlámã ꞌi, Kórã sĩ. Anji drị̃koma rú ꞌdĩꞌbée úyú Ị́sọ̃wụ̃ vé ni, kộpivé ẹ́ndrẹ́pị Õhõlĩbámã ꞌi, Õhõlĩbámã ri mvá Ánã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Úyú Ị́sọ̃wụ̃ vé ꞌdĩꞌbée, kộpi drị̃koma rú ãngũ Ẽdómã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sẽyírĩ Hórĩgú rĩ ri ọ́tụ́ adrií ãngũ ánga rú Sẽyírĩ vé rĩ gé. Ĩrivé anji rĩ pi ã rụ́, Lõtánã ꞌi, Sõbálã ꞌi, Zĩbẽyónã ꞌi, Ánã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dĩsónĩ ꞌi, Ézẽrẽ ꞌi, Dĩsánĩ sĩ. Anji Sẽyírĩ vé adriꞌbá ãngũ Ẽdómã vé rĩ agá ꞌdĩꞌbée, kộpi drị̃koma sụ́rụ́ Hórĩ vé rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Anji ãgõ Lõtánã vé rĩ pi Hórĩ pi Hẽmánã be. Lõtánã vé ọ́mvụ́pị Tímĩnã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Anji ãgõ Sõbálã vé rĩ pi Ãlĩvánã ꞌi, Mãnãhátã ꞌi, Ẽbálã ꞌi, Séfõ ꞌi, Õnámã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Anji ãgõ Zĩbẽyónã vé rĩ pi Ãyá pi Ánã be. Ánã ị́sụ́ yị̃ị́ íkpúpi nyọ̃ọ́kụ́ agálésĩ ãngũ ãꞌwí cínyáfã rú rĩ agá koópi koko rĩ nĩ. Ị́sụ́ yị̃ị́ rĩ sâ ĩri ní rizú ẹ́tẹ́pị Zĩbẽyónã vé dõngí úcézú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anji Ánã vé rĩ pi ꞌdĩ, Mvá ágó rú rĩ Dĩsónĩ ꞌi, ũkú rú rĩ Õhõlĩbámã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Anji ãgõ Dĩsónĩ vé rĩ pi Hẽmĩdánĩ ꞌi, Ẽsĩbánã ꞌi, Ĩtãránã ꞌi, Kẽránã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Anji ãgõ Ézẽrẽ vé rĩ pi Bĩlĩhánã pi Zãvánã be, Ãkánã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Anji ãgõ Dĩsánĩ vé rĩ pi Ụ́zị̃ pi Ãránã be. ");
INSERT INTO kbo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hórĩ vé anji drị̃koma rú rĩ pi, Lõtánã ꞌi, Sõbálã ꞌi, Zĩbẽyónã ꞌi, Ánã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dĩsónĩ ꞌi, Ézẽrẽ ꞌi, Dĩsánĩ sĩ. Anji Hórĩ vé adriꞌbá drị̃koma rú rĩ pi ꞌdĩ, kộpi acokí ĩ sụ́rụ́ ĩvé rĩ pi vúgá sĩ, ãngũ Sẽyírĩ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ꞌBãgú ãngũ Ẽdómã vé rĩ rụꞌbá ị́sụ́zú ꞌbãgú ãzi rụ drĩ ꞌbá Ĩsẽrélẽ vé rĩ pi kuyé rĩ pi vé rụ́ ꞌdĩ, ");
INSERT INTO kbo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bẽórã vé mvá Bélã rụ ãngũ Ẽdómã vé rĩ nĩ. Kụ̃rụ́ ĩri ní adrizú ꞌa ni gé rĩ ã rụ́ Dĩnĩhábã. ");
INSERT INTO kbo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bélã kã drãá, Zérã íngápi Bõzírã gá rĩ vé mvá Jõbábã gõ adrií ꞌbãgú rú Bélã ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jõbábã kã drãá, Hũsámã íngápi ãngũ Tẽmánã vé rĩ agá rĩ gõ adrií ꞌbãgú rú Jõbábã ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hũsámã kã drãá, Bẽdádĩ vé mvá Hãdádĩ ẹ̃ꞌdị́ ꞌdịị́pi ꞌbá Mĩdĩyánã vé rĩ pi be ãngũ Mõábã vé rĩ agá, kộpi ndẽépi rá rĩ, gõ ãngũ rĩ rụụ́ nĩ Hũsámã ã vũrã gá. Kụ̃rụ́ ĩri ní adrizú ꞌa ni gé rĩ ã rụ́ Ãvítĩ. ");
INSERT INTO kbo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hãdádĩ kã drãá, Sãmílã íngápi ãngũ Mãsẽrékã vé rĩ gé rĩ, gõ ãngũ rĩ rụụ́ nĩ Hãdádĩ ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sãmílã kã drãá, Sáwũlã íngápi kụ̃rụ́ Rẽhõbótĩ vé rĩ gé yị̃ị́ gãrã gá rĩ gõ ãngũ rĩ rụụ́ nĩ Sãmílã ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sáwũlã kã drãá, Ãkĩbórĩ vé mvá Bãlã Hãnánĩ gõ ãngũ rĩ rụụ́ nĩ Sáwũlã ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ãkĩbórĩ vé mvá Bãlã Hãnánĩ kã drãá, Hãdádĩ gõ úrí ꞌbãgú rú nĩ. Kụ̃rụ́ ĩri ní adrizú rĩ Páwũ ꞌi. Ũkú ĩrivé rĩ ã rụ́ Mẽhẽtãbélẽ ꞌi, Mẽhẽtãbélẽ ri mvá ũkú Mãtẽrédĩ vé ni, Mãtẽrédĩ ri mvá ũkú Mẽzãhábã vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Úyú Ị́sọ̃wụ̃ vé adriꞌbá ꞌbãgú rú rĩ pi ꞌdakí kộpi ã rụ́ ĩvé sụ́rụ́ ã rụ́ sĩ, ãzini ĩvé ãngũ ã rụ́ sĩ, kộpivé rụ́ pi ꞌdĩ, Tímĩnã ꞌi, Álĩvã ꞌi, Jẽtétĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Õhõlĩbámã ꞌi, Élã ꞌi, Pĩnónĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kẽnázĩ ꞌi, Tẽmánã ꞌi, Míbĩzã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mãgãdĩyélẽ ꞌi, Ĩrámã sĩ. ꞌBãgú ꞌdĩꞌbée Ẽdómã vé rĩ pi, sĩkí kộpivé rụ́ ãngũ kộpi ní adrizú rĩ pi vúgá sĩ. Kộpi céré úyú Ị́sọ̃wụ̃ vé ni, Ị́sọ̃wụ̃ ri ẹ́ꞌbị́pị ꞌbá Ẽdómã vé rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yõkóbũ ri adrií ãngũ ẹ́tẹ́pị ní adrizú rĩ agá, ãngũ Kãnánã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Úꞌdógúꞌdógú Yõkóbũ vé rĩ, ãzini anjiŋá ĩrivé rĩ pi vé rĩ, ĩri ꞌdíni. Yõsépã kã adrií ílí be mụdrị́ drị̃ ni ẹ́zị̂rị̃, ri ẹ́tẹ́pị vé ãnyãpá úcé, kộpi rikí úcé ẹ́drị́pị́ị be. Ĩrivé ẹ́drị́pị́ị ꞌdĩꞌbée vé ẹ́ndrẹ́pị Bílã pi Jẽléfã be. ꞌBo Yõsépã ri tã ũnjí ẹ́drị́pị́ị ní rií ꞌoó rĩ íjị́ ũlũú ẹ́tẹ́pị ní. ");
INSERT INTO kbo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ĩsẽrélẽ lẽ Yõsépã ri ívé anji rĩ pi ãsámvú gé sĩ agaá rá, ãꞌdiãtãsĩyã tịkí Yõsépã ri ị́sụ́ ãkũdẽ Yõkóbũ ri ãrãkã rú. Ĩsẽrélẽ ící bõngó akoóko rụ̃kụ̃ ãjẽ be ãmbúgú ni sẽé Yõsépã ní. ");
INSERT INTO kbo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yõsépã ẹ́drị́pị́ị kâ ndreé ĩ ẹ́tẹ́pị lẽ Yõsépã ri ĩ agaá rá, kộpi ꞌbãkí ẹ́sị́ ũnjí Yõsépã ní. Kộpi átákí ĩri ní tã ụ́ꞌdụ́kọ́ múké sĩ ku. ");
INSERT INTO kbo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ị́nị́ŋá ãzi sĩ, Yõsépã ũbĩ urobí, kã urobí rĩ ũlũú ẹ́drị́pị́ị ní, kộpi gõkí ẹ́sị́ ũnjí ꞌbãá ĩri ní agaá rá. ");
INSERT INTO kbo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi yịkí drĩ urobí ma ũbĩípi rĩ vé tã ká. ");
INSERT INTO kbo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Urobí rĩ kĩnĩ, ꞌbá mụkí ĩmi be ọ́mvụ́ gé, ꞌbá rikí ũndú úlíli ũdrõó ĩmi be, mbẽlẽŋá mávé ũndú nga ꞌi ĩdrẽé ụrụ sĩ, ũndú ĩmivé rĩ pi trakí ĩ ũndú mávé rĩ ã gãrã gá sĩ kụ́rụ̃, sị̃kí drị̃ vũgá ẹndrẹtị ni gé.” ");
INSERT INTO kbo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yõsépã ẹ́drị́pị́ị ní ꞌyozú ĩri ní kínĩ, “Mí ụ̃sụ̃ mi ãmbúgú ꞌbá drị̃gé nĩ? Ádarú ꞌí lẽ nyo adrií ꞌbá drị̃gé ãmbúgú rú?” Kộpi gõkí ĩri ní ẹ́sị́ ũnjí ꞌbãá agaá rá urobí ĩri ní ũbĩí rĩ sĩ, ãzini tã ĩri ní ꞌyoó rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yõsépã ní gõzú urobí ãzi ũbĩzú, ĩri ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “Ĩmi yịkí drĩ ká, á gõ urobí ãzi ũbĩí. Urobí rĩ kĩnĩ, ụ̃tụ́, mbãá, ãzini línyã sị̃kí drị̃ vũgá má ẹndrẹtị gé.” ");
INSERT INTO kbo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kã urobí rĩ ũlũú ꞌí ẹ́tẹ́pị ní, ãzini ꞌí ẹ́drị́pị́ị ní, ẹ́tẹ́pị ní trezú drị̃ ni gé kĩnĩ, “Urobí mí ní ũbĩí ꞌdĩri tã ni ngóni? Mí ụ̃sụ̃ mí kĩnĩ, ꞌbâ mí ẹ́ndrẹ́pị be, mí ẹ́drị́pị́ị be úmvúlésĩ ímụ́ kũmũcí ũtị̃, drị̃ sị̃ vũgá mí ẹndrẹtị gé?” ");
INSERT INTO kbo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yõsépã ã tã ꞌde ẹ́drị́pị́ị ẹ́sị́ agá ũnjí, ꞌbo Yõkóbũ ri tã ꞌdĩri ụ̃sụ̃ụ́ kĩnĩ, urobí ꞌdĩri vé ífífí ãꞌdi. ");
INSERT INTO kbo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ụ́ꞌdụ́ ãlu Yõsépã ẹ́drị́pị́ị ꞌdekí mụụ́ ĩ ẹ́tẹ́pị vé kãbĩlõ úcé Sẽkémẽ gá. ");
INSERT INTO kbo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ĩsẽrélẽ ní ꞌyozú Yõsépã ní kĩnĩ, “Mí ẹ́drị́pị́ị ri kãbĩlõ úcé Sẽkémẽ gá ꞌdãáꞌdã, á lẽ mi pẽé mụzú kộpi vúgá ꞌdãá.” Yõsépã ní újázú kĩnĩ, “Múké, ma mụ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ẹ́tẹ́pị ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ mụ mí ẹ́drị́pị́ị ndreé, kộpi dõ múké kãbĩlõ rĩ pi be. ꞌÍ mụ dõ gí, mí újá mi ĩgõó ímụ́ tã ni ũlũú má ní.” Kúru ẹ́tẹ́pị ní Yõsépã rĩ pẽzú mụzú, Yõsépã ní ngazú ị́ꞌbụ́ŋá Hẽbẽrónã vé rĩ gé ꞌdãásĩ, ĩri ní ꞌdezú mụzú Sẽkémẽ gá ꞌdãá. Yõsépã kã caá Sẽkémẽ gá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ágó ãzi ị́sụ́ ĩri ri ẹ́cị́ ãngũ rĩ agásĩ, ágó rĩ ní ĩri zịzú kĩnĩ, “Ngá mí ní rií ndãá rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yõsépã ní újázú kĩnĩ, “Ma ri má ẹ́drị́pị́ị ndã. Mi ícó má ní vũrã kộpi ní rizú kãbĩlõ úcézú rĩ lũ rá?” ");
INSERT INTO kbo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ágó rĩ ní újázú kĩnĩ, “Kộpi ngakí mụụ́ nõósĩ gí. Á yị kộpi kínĩ, ĩ lẽkí ꞌdeé mụzú Dõtánã gá.” Kúru Yõsépã ní ꞌdezú mụzú ẹ́drị́pị́ị vúgá sĩ, ĩri ní cazú mụzú kộpi ị́sụ́zú Dõtánã gá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yõsépã ẹ́drị́pị́ị kâ ndreé Yõsépã ri ímụ́, kộpi nị̃kí ĩri ámá bá, ị́sụ́ ãkũdẽ ícá drĩ ĩ vúgá nõó kuyé, kộpi íꞌdókí rií lẹ́tị ndãá ĩri ꞌdịzú. ");
INSERT INTO kbo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kộpi rikí átá ĩ ãsámvú gé sĩ kínĩ, “Ĩ ndrekí drĩ ká, urobí ꞌdị́pa ri ímụ́ ꞌdã! ");
INSERT INTO kbo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Lẽ ꞌbâ ꞌdịkí ĩri drãá, ꞌbâ ꞌbekí ĩri ꞌbụ́ yị̃ị́ ní njụụ́ ꞌa ni gé sĩ gí rĩ agá, ꞌbâ mụ ꞌyo ꞌbá ẹ́tẹ́pị ní ụ̃bụ̃gọ̃ nya ĩri gí. ꞌBâ ndrekí rí ĩrivé urobí ꞌdĩri dõ ẹ̃zị́ nga rá.” ");
INSERT INTO kbo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rũbénã kã tã ꞌdĩri yịị́, ꞌbã ẹ́sị́ lẽzú Yõsépã ri ípázú ẹ́drị́pị́ị drị́gé sĩ rá, ĩri ní ꞌyozú kĩnĩ, “Lẽ ꞌbâ ꞌdịkí ĩri ku. ");
INSERT INTO kbo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lẽ ĩmi dãkí ãrí ku, ĩmi ꞌdụkí ĩri ꞌbeé ꞌbụ́ yị̃ị́ ní njụụ́ ꞌa ni gé sĩ gí rĩ agá ꞌdãá ãngũ ãꞌwí cínyáfã rú rĩ agá nõgó, lẽ ĩmi ꞌbãkí drị́ rụ́ꞌbá ni gé ku.” Rũbénã ꞌyo tã ꞌdĩri ꞌdíni, lẽ ẹ́drị́pị ri ípá kộpi drị́gé sĩ, jịị́ gõó ẹ́tẹ́pị vúgá ꞌdãá vúlé. ");
INSERT INTO kbo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kúru Yõsépã kã caá ẹ́drị́pị́ị vúgá ꞌdãlé, kộpi ũtrũkí ĩrivé bõngó akoóko rụ̃kụ̃ ãjẽ be ãmbúgú rĩ ĩri ní suú rĩ ĩri ã rụ́ꞌbá gá sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kộpi jịkí ĩri ꞌbeé ꞌbụ́ agá. ꞌBụ́ rĩ ã ꞌa ule, yị̃ị́ ꞌa ni gé ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kộpi kâ úrí vũgá rií ínyá nyaá, kộpi kâ ĩ drị̃ ingaá ãngũ ndreé ụrụ, kộpi ndrekí ngúlúmũ sụ́rụ́ Ĩsĩmãélẽ vé ngá ụzịꞌbá rĩ pi ri ímụ́ ĩ vúgá nõó Gĩlédã gálésĩ. Kộpi ũdrõkí ngá tị́bị́ áꞌdízú ẹ̃jị́ be ngụ̃ꞌbá ndrị̃ndrị̃ ni pi, ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni, ãzini mị́rẹ̃ pi be kámĩlõ rĩ pi úgóró gá, kộpi ri ngá ꞌdĩꞌbée jị mụ ụzị Ẽjẽpétõ gá. ");
INSERT INTO kbo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yụ́dã ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “ꞌBá ꞌdịkí dõ ꞌbá ẹ́drị́pị ri drãá, ꞌbá úcíkí dõ tã ni úcícĩ, ngá múké ꞌbá ní ị́sụ́ ꞌa ni gé ꞌdĩgé rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Múké ni, lẽ ꞌbâ sẽkí ĩri jeé ꞌbá Ĩsĩmãélẽ vé rĩ pi ní, ꞌbâ úlókí ĩri ã rụ́ꞌbá ku, ĩri ꞌbá ẹ́drị́pị, ꞌbâ ãrí ãlu.” Yụ́dã vé ẹ́drị́pị́ị ãꞌyĩkí tã ĩri ní ꞌyoó ꞌdĩri rá. ");
INSERT INTO kbo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ngúlúmũ Ĩsĩmãélẽ vé adriꞌbá ãngũ Mĩdĩyánã vé rĩ agá riꞌbá ngá ụzịꞌbá rĩ pi kâ ícá, Yõsépã ẹ́drị́pị́ị ní Yõsépã ri ísézú ꞌbụ́ rĩ agá ꞌdãásĩ ãmvé nõó, kộpi ní ĩri sẽzú jezú ꞌbá Ĩsĩmãélẽ vé rĩ pi ní mũfẽngã fífí pụ̃kụ́ ị̃rị̃ ẹ̃njị̃ꞌbá ẹ̃njị̃ẹ̃njị̃ ni sĩ, ꞌbá Yõsépã ri jeꞌbá rĩ pi ní Yõsépã ri jịzú mụzú Ẽjẽpétõ gá. ");
INSERT INTO kbo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rũbénã kã ꞌi újá gõó ꞌbụ́ rĩ gé ꞌdãlé, ị́sụ́ Yõsépã ri ꞌdãáyo. Ĩzãngã fi ẹ́sị́ ni gé ambamba, ũsĩ ívé bõngó ꞌí rụ́ꞌbá gá sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ĩri ní gõzú ẹ́drị́pị́ị vúgá ꞌdãlé, ĩri ní ꞌyozú kĩnĩ, “Mvá rĩ ꞌdãlé ꞌdãáyo! Mâ ꞌo rí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kúru kộpi ní Yõsépã vé bõngó ãco akoóko ãjẽ be ãmbúgú rĩ íꞌdụ́zú, kộpi ní ndrị̃ị́ lịzú, bõngó rĩ suzú ãrí rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kộpi ní bõngó akoóko rụ̃kụ̃ ãrí be rụ́ꞌbá gá ꞌdĩri jịzú mụzú ĩ ẹ́tẹ́pị vúgá ꞌdãá. Kộpi ní ꞌyozú kínĩ, “ꞌBá ị́sụ́kí bõngó akoóko rụ̃kụ̃ ni nõ, ꞌí ꞌbị̃ drĩ ndreé ká, bõngó nõri adri mî mvọ́pị vé rĩ kuyé?” ");
INSERT INTO kbo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yõkóbũ ámá bõngó rĩ kĩnĩ, “Bõngó akoóko rụ̃kụ̃ rĩ mâ mvọ́pị vé rĩ! Á, ụ̃bụ̃gọ̃ nya mvá rĩ gí. Ádarú ũndĩkí Yõsépã ri kpélékpélé gí.” ");
INSERT INTO kbo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kúru Yõkóbũ ní ívé bõngó ũsĩzú ꞌí rụ́ꞌbá gá sĩ rá, ĩri ní sũwárĩ íꞌdụ́zú ásúzú ꞌî rụ́ꞌbá gá áyu. Ngo ꞌî mvọ́pị ri caá ụ́ꞌdụ́ be kárákará. ");
INSERT INTO kbo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ĩrivé anji ãgõ rĩ pi, anji ũkú rĩ pi be céré ímụ́kí ĩri ẽ ẹ́sị́ ũmĩí, ꞌbo gã sĩ, lẽ ꞌbá ãzi ã ũmĩ ꞌî ẹ́sị́ ku. Ĩri ní ꞌyozú kĩnĩ, “Á lẽ ã sị̃kí ma ꞌbụ́ agá, á lẽ mụụ́ mâ mvọ́pị ri ngoó.” Ĩri dị̃ átá be, ĩri dị̃ ngo be. ");
INSERT INTO kbo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ị́sụ́ ãkũdẽ ꞌbá Mĩdĩyánã vé rĩ pi sẽkí Yõsépã ri jeé Pótĩfã ní Ẽjẽpétõ gá ꞌdãlé gí, Pótĩfã ri ũgalaku riípi ꞌbãgú Ẽjẽpétõ vé rĩ vé ꞌbẹ̃tị́ ũtẽépi rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Sâ ꞌdãri gé, Yụ́dã ní ngazú fũzú ẹ́drị́pị́ị ãsámvú gé sĩ, mụ adrií kụ̃rụ́ Ãdũlámũ vé rĩ gé, ágó ãzi vé ãngá, ágó rĩ ã rụ́ Hírã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yụ́dã ní mvá ũkú ị́sụ́zú, mvá ũkú rĩ vé ẹ́tẹ́pị Kãnánãgú, rụ́ ni Súwã ꞌi. Yụ́dã ní mvá ũkú rĩ jezú ꞌí ní ũkú rú, kộpi ní lazú mvá ũkú rĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mvá ũkú rĩ ní ꞌa ị́sụ́zú, ĩri ní mvá ágó tịzú, Yụ́dã ní mvá rĩ ã rụ́ ꞌdazú Érẽ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ũkú rĩ ní kpá gõzú ꞌa ãzi ị́sụ́zú, ĩri ní mvá ágó tịzú, ĩri ní rụ́ ni ꞌdazú Õnánĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ĩri ní kpá gõzú mvá rĩ ãzi tịzú ágó, ĩri ní rụ́ ni ꞌdazú Sélã ꞌi. Tị mvá ꞌdĩri Kẹ̃zị́bụ̃ gé. ");
INSERT INTO kbo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yụ́dã ní ũkú jezú ívé mvá kãyú Érẽ ní, mvá ũkú rĩ ã rụ́ Tãmárã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ꞌBo Yụ́dã vé mvá kãyú Érẽ ri ũnjĩkãnyã ꞌoó Úpí Múngú ẹndrẹtị gé, sẽ Úpí ꞌdị ĩri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kúru Yụ́dã ní ꞌyozú Õnánĩ ní kĩnĩ, “ꞌÍ fi mí ẹ́drị́pị vé ọ̃wụ́zị́ sụ̃ ꞌbávé mẽrẽ ní lẽé rĩ tị́nị, ĩmi tịkí rí mvá ĩri be mí ẹ́drị́pị drãápi rĩ ní.” ");
INSERT INTO kbo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ꞌBo Õnánĩ nị̃ rá ꞌyozú kínĩ, mvá ꞌdĩri úmvúlésĩ adri ívé ni ku, kãdõ laá ẹ́drị́pị vé ọ̃wụ́zị́ rĩ sĩ, ĩri ívé yị̃ị́ ágó vé rĩ sẽ ra vũgá, ꞌî tị rí mvá ẹ́drị́pị drãápi gí rĩ ní ku. ");
INSERT INTO kbo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Tã ĩri ní ꞌoó ꞌdĩri, Úpí Múngú mị gé ꞌdãlé ĩri ũnjĩkãnyã, sẽ Úpí Múngú ꞌdị kpá ĩri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yụ́dã ní ꞌyozú Tãmárã ní kĩnĩ, “ꞌÍ mụ adrií mí ẹ́tẹ́pị vé ãngá ꞌdãá, ꞌí tẽ mívé ọ̃wụ̃zị̃ rĩ ã vụ́drị̃ cĩmgbá mâ mvọ́pị Sélã mba dõ ãmbúgú gí ká.” Yụ́dã átá ꞌdíni, ãꞌdiãtãsĩyã ụ̃sụ̃ déna ívé mvá Sélã ri kpá drã sụ̃ ẹ́drị́pị́ị ní ũdrãá rĩ tị́nị. Kúru Tãmárã ní mụzú adrizú ẹ́tẹ́pị vé ãngá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ꞌDụ lókí vụ̃ụ́ ãco, Yụ́dã vé ũkú Súwã mvọ́pị ní drãzú. Ĩzãngã ŋõ Yụ́dã ẽ ẹ́sị́ rá, kâ ĩri ẽ ẹ́sị́ ũmĩí gí, ĩri ní ꞌdezú mụzú Tímĩnã gá, ãgõ riꞌbá ĩrivé kãbĩlõ ꞌbí rẽꞌbá rĩ pi vúgá, kộpi ꞌdekí mụụ́ ívé ũndĩ Hírã adriípi Ãdũlámũ gé rĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kâ lũú Tãmárã ní kínĩ, ẹ́nyẹ́pị ri mụ Tímĩnã gá ívé kãbĩlõ ꞌbí rẽngárá gá, ");
INSERT INTO kbo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nje ívé bõngó ọ̃wụ̃zị̃ vé rĩ ꞌî rụ́ꞌbá gá sĩ rá, ꞌbe bõngó pẽrépére ni ꞌî ẹndrẹtị ọ̃zụ̃zú ãní cí, mụ úrí kuú lẹ́tị ã kérétũ mụụ́pi Ẽnãyímũ gé rĩ gé, ãzini Tímĩnã gá rĩ gé. Ãꞌdiãtãsĩyã ndre Sélã mba ãmbúgú gí, ꞌbo sẽkí ꞌi ĩri ní ũkú rú kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yụ́dã kã ĩri ndreé, ụ̃sụ̃ déna ĩri ũkú ọ̃wụ́ rú ni, ãꞌdiãtãsĩyã ꞌbe bõngó pẽrépére ni ꞌî ẹndrẹtị ọ̃zụ̃zú ãní cí. ");
INSERT INTO kbo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yụ́dã nị̃ ámá ꞌyozú kínĩ, ꞌbá rĩ ꞌî mvọ́pị drãápi gí rĩ vé ũkú Tãmárã ꞌi ꞌdíni kuyé. Ĩri ní mụzú ũkú rĩ vúgá lẹ́tị mịlé gá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mí ímụ́, ꞌbâ lakí mí be.” Ũkú rĩ ní Yụ́dã ri zịzú kĩnĩ, “ꞌBá lakí dõ mí be gí, mi má ní ãꞌdi sẽ?” ");
INSERT INTO kbo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yụ́dã ní ꞌyozú kĩnĩ, “Ma ndrị̃ị́ mbaápi fõlõ ni íꞌdụ́ mávé ndrị̃ị́ rĩ pi ãsámvú gé ꞌdãá, ma ĩpẽ mí ní.” Ũkú rĩ ní ĩri zịzú kĩnĩ, “Ngá mí ní ícó sẽé má ní, ã lũ rí ꞌyozú kínĩ mi íbí ndrị̃ị́ mbaápi fõlõ rĩ íjị́ ndõ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yụ́dã ní újázú kĩnĩ, “Ngá mí ní lẽé mâ sẽ mí ní rĩ ãꞌdi?” Ũkú rĩ ní ꞌyozú kĩnĩ, “Lẽ mî sẽ má ní mívé kátrĩ ĩ ní mî rụ́ sĩí rụ́ꞌbá ni gé ꞌdĩri, bãákú ĩ ní rizú kátrĩ rĩ ꞌyĩzú rĩ be, ãzini túré mí drị́gé ꞌdĩri.” Yụ́dã ní ngá ꞌdĩꞌbée íꞌdụ́zú sẽzú ũkú rĩ ní. Kộpi ní lazú ũkú rĩ be, ũkú rĩ ní ꞌa ị́sụ́zú. ");
INSERT INTO kbo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ũkú rĩ kã mvií gõó ꞌbẹ̃tị́ ꞌdãlé, ĩri ní ívé bõngó pẽrépére ꞌî ẹndrẹtị ọ̃zụ̃zú rĩ ọ́wụ́zú rá, ĩri ní gõzú ívé bõngó ọ̃wụ̃zị̃ vé rĩ suzú ꞌî rụ́ꞌbá gá ũzi. ");
INSERT INTO kbo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kúru Yụ́dã ní ívé ũndĩ Hírã adriípi Ãdũlámũ gé rĩ pẽzú ndrị̃ị́ mbaápi fõlõ rĩ jịzú, ẽ íjị́ rí ívé ngá ꞌí ní kuú ũkú rĩ vúgá ꞌdãlé rĩ ĩgõó vúlé, ꞌbo Hírã ị́sụ́ ũkú rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hírã ní ꞌbá adriꞌbá Ẽnãyímũ gé ꞌdãlé rĩ pi zịzú kĩnĩ, “Ũkú ọ̃wụ́ rú riípi úrípi lẹ́tị mụụ́pi Ẽnãyímũ gé rĩ mịlé gá nõgó rĩ íngãá?” ꞌBá rĩ pi ní ꞌyozú kínĩ, “Ũkú ãzi ọ̃wụ́ rú ni nõgó ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hírã ní kúru ꞌi újázú gõzú Yụ́dã vúgá ꞌdãlé, ĩri ní ꞌyozú kĩnĩ, “Má ị́sụ́ ũkú rĩ kuyé. ꞌBá adriꞌbá vũrã ꞌdãri gé rĩ pi kínĩ, ũkú ọ̃wụ́ rú ni ꞌdãlé ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kúru Yụ́dã ní ꞌyozú kĩnĩ, “Lẽ ũkú rĩ ã ũtẽ ngá má ní sẽé ꞌí ní ꞌdãꞌbée múké, ꞌbá rĩ pi ã gụkí rí ꞌbâ ku. Á pẽ ndrị̃ị́ mbaápi fõlõ rĩ mụzú ĩri ní rá, ꞌbo mí ị́sụ́ ĩri kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mbãá na ã vụ́drị̃ gé, ĩ ní lũzú Yụ́dã ní kínĩ, “Mî mvọ́pị drãápi gí rĩ vé ũkú Tãmárã ri ọ̃wụ́ rú, ꞌo tã ũnjí, ĩri nóni ꞌa be.” Yụ́dã ní ꞌyozú kĩnĩ, “Ĩmi jịkí ĩri fũú kụ̃rụ́ rĩ agásĩ ãmvé, ĩmi zãkí ĩri veé ãcí sĩ!” ");
INSERT INTO kbo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ꞌBo kâ rií Tãmárã ri jịị́ mụzú ãmvé ꞌdãá, ĩri ní tị pẽzú mụzú ẹ́nyẹ́pị ní, ĩri ní ꞌyozú kĩnĩ, “Ma nóni ꞌa be, ngá nõꞌbée vé ꞌdị́pa sẽ má ní ꞌa rĩ nĩ.” Ĩri ní gõzú ꞌyozú kĩnĩ, “Mí ámá drĩ kátrĩ ĩ ní rụ́ sĩí rụ́ꞌbá ni gé ꞌdĩri, ãzini bãákú ĩ ní rizú kátrĩ rĩ ꞌyĩzú ꞌdĩri ká, ãzini mí ámá drĩ túré ꞌdĩri ká, dõ ngá nõꞌbée ãꞌdi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yụ́dã nị̃ ngá rĩ pi ámá, ngá rĩ pi ívé ni, ĩri ní ꞌyozú kĩnĩ, “Tãmárã ri tã ꞌo pịrị ndẽ ma rá, ãꞌdiãtãsĩyã á sẽ ĩri mávé mvá Sélã ní ũkú rú kuyé.” Yụ́dã pi gõkí laá Tãmárã be dị̃ị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sâ ĩrivé tĩngárá vé rĩ kã ícá, anji rĩ pi ĩri ꞌa gá ꞌdãá ẹ̃tị́ rú. ");
INSERT INTO kbo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kã rií tĩí, mváŋá rĩ ãzi ní ꞌî drị́ ísúzú ãmvé nõó, ũkú riípi ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koópi rĩ ní bõngó bãá ika ni ꞌyĩzú mváŋá rĩ ẽ drị́ umbelé gá. Ĩri ní ꞌyozú kĩnĩ, “Mvá nõri ĩfũ drị̃drị̃.” ");
INSERT INTO kbo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ꞌBo mvá rĩ gõ ꞌî drị́ seé vúlé, ẹ́drị́pị ní ĩfũzú drị̃drị̃. Ũkú riípi ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koópi rĩ ní ꞌyozú kĩnĩ, “Mí ali mi ĩfũú ũkpõ sĩ ãmvé nõó drị̃drị̃ íngóni?” Ĩ ní mvá rĩ ã rụ́ ꞌdazú Pẽrézĩ. ");
INSERT INTO kbo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kúru ẹ́drị́pị ĩ ní bõngó bãá ika ꞌyĩí drị́ umbelé ni gé rĩ ní ĩfũzú, ĩ ní rụ́ ni ꞌdazú Zérã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ꞌBá Ĩsĩmãélẽ vé riꞌbá ngá ụzịꞌbá rĩ pi ní Yõsépã ri jịzú Ẽjẽpétõ gá, kộpi sẽkí ĩri ụzịị́ Pótĩfã ní, Pótĩfã ri Ẽjẽpétõgú, ĩri ꞌbãgú Ẽjẽpétõ vé rĩ vé ũgalaku, ĩri ãmbúgú ꞌbá riꞌbá ꞌbẹ̃tị́ ꞌbãgú rĩ vé rĩ ũtẽꞌbá rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Úpí Múngú ri adrií Yõsépã be trụ́, sẽ ĩrivé tã adri mụzú céré múké, Yõsépã ri adrií ívé ãmbúgú Ẽjẽpétõgú Pótĩfã vé ãngá. ");
INSERT INTO kbo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yõsépã vé ãmbúgú Pótĩfã kã ndreé Úpí Múngú ri Yõsépã be trụ́, Úpí Múngú sẽ tã Yõsépã ní rií ꞌoó rĩ pi céré ri adrií mụzú múké. ");
INSERT INTO kbo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pótĩfã ꞌbã ẹ́sị́ múké Yõsépã ní, ꞌbã ĩri ꞌí jẽlé gá rií ꞌî ĩzã koó. ꞌBã ĩri adrií ãmbúgú ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi drị̃gé, ãzini rií ngá ívé rĩ pi ũtẽé. ");
INSERT INTO kbo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sâ Pótĩfã ní Yõsépã ri ꞌbãzú ãmbúgú rú ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi drị̃gé, ãzini ngá ívé rĩ pi ũtẽé rĩ gé, Úpí Múngú ꞌbã tãkíri ꞌbá Ẽjẽpétõ vé rĩ pi drị̃gé Yõsépã ã tã sĩ. Úpí Múngú ꞌbã tãkíri ngá Pótĩfã vé rĩ pi drị̃gé céré, ꞌbã tãkíri ĩrivé ngá jó agá rĩ pi drị̃gé, ĩrivé ngá ọ́mvụ́ agá rĩ pi drị̃gé, ãzini ãnyãpá rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Pótĩfã sẽ ngá ívé rĩ pi ãrẽvú céré kuú Yõsépã drị́gé, Yõsépã ri ũtẽé nĩ. Yõsépã ní adrií anigé rĩ sĩ, Pótĩfã ẽ ẹ́sị́ tĩ ngá ívé rĩ pi ã tã sĩ kuyé, ĩri ꞌyéŋá ri ínyá ꞌí ní lẽé nyaá rĩ ã tã ụ̃sụ̃ áyu. Yõsépã mba rụ́ꞌbá be múké, ũnyĩ be. ");
INSERT INTO kbo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kã adrií vụ̃ụ́ mãdã, ãmbúgú Yõsépã vé rĩ vé ũkú ꞌbã mị Yõsépã drị̃gé, ĩri ní ꞌyozú Yõsépã ní kĩnĩ, “Mí ímụ́, ꞌbá lakí mí be!” ");
INSERT INTO kbo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ꞌBo Yõsépã gã sĩ. Yõsépã ní ꞌyozú ĩri ní kĩnĩ, “Ĩ ní ma ꞌbãá ãmbúgú rú ngá rĩ pi drị̃gé céré rĩ sĩ, ãmbúgú mávé rĩ ẽ ẹ́sị́ tĩ ívé ngá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ã tã sĩ kuyé, ãꞌdiãtãsĩyã ꞌbã ma ãmbúgú rú rií ívé ngá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ũtẽé. ");
INSERT INTO kbo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ꞌBá ãzi jó nõri agá ma ndẽépi ãmbũgũ sĩ ni ꞌdãáyo. Ãmbúgú mávé rĩ sẽ ngá ívé rĩ pi ãrẽvú céré kuú má drị́gé, ma ri ũtẽ nĩ, ꞌbo sẽ mi má ní kuyé, ãꞌdiãtãsĩyã mi ĩrivé ũkú. Má ícó ũnjĩkãnyã ꞌoó sụ̃ ꞌdĩri tị́nị Múngú ẹndrẹtị gé ku.” ");
INSERT INTO kbo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ụ́ꞌdụ́ ãlu ãlu, ũkú rĩ ri sií Yõsépã vúgá sĩ, ꞌbo Yõsépã gã lagá ĩri be sĩ, Yõsépã lẽ ꞌi ítrú adrií ĩri ã gãrã gá ĩnyiŋá ku. ");
INSERT INTO kbo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ụ́ꞌdụ́ ãlu, Yõsépã fi mụzú jó agá ꞌdãá ívé ẹ̃zị́ ngangárá gá, ãtíꞌbá ẹ̃zị́ ngaꞌbá jó agá ꞌdãlé rĩ pi ãluŋáni jó agá ꞌdãlé ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ũkú rĩ ní Yõsépã vé bõngó akoó rụ̃kụ̃ rĩ rụzú, ĩri ní ꞌyozú kĩnĩ, “Mí ímụ́, ꞌbá lakí mí be.” ꞌBo Yõsépã ní ꞌi pazú drị́ ni gé sĩ ũkpõ sĩ, ku ívé bõngó akoó rụ̃kụ̃ rĩ kú ũkú rĩ drị́gé ꞌdĩgé, nga ápá fũú jó rĩ agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ũkú rĩ kã ndreé Yõsépã ku ívé bõngó akoó rụ̃kụ̃ rĩ kú ꞌí drị́gé ꞌdĩgé, Yõsépã ápá fũú jó rĩ agásĩ ãmvé gí, ");
INSERT INTO kbo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ũkú rĩ zị ãtíꞌbá ẹ̃zị́ ngaꞌbá ívé jó agá rĩ pi, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ndrekí drĩ ká, má ágó ni íjị́ Ẽbérẽgú nõri ímụ́ ꞌbâ uꞌdaá! Ífí jó agá nõó, lẽ laá má sĩ, ꞌbo á tre gbírílí. ");
INSERT INTO kbo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kã ndreé á tre gbírílí, ku ívé bõngó akoó rụ̃kụ̃ rĩ kú má gãrã gá nõgó, ápá fũú jó rĩ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ũkú rĩ ꞌbã Yõsépã vé bõngó akoó rụ̃kụ̃ rĩ kú ꞌí gãrã gá cĩmgbá ágó ni ní ícángárá gá ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ĩri ní kúru tã ꞌdĩri ũlũzú ágó ni ní kĩnĩ, “Ẽbérẽgú tụ́gẹ̃rị̃ rú mí ní íjị́ ꞌdĩri, lẽ ma rụụ́ lazú ãní ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ꞌBo má kã treé gbírílí, ꞌbá rĩ pi zịị́ ímụ́ má ĩzã koó, ku ívé bõngó akoó rụ̃kụ̃ rĩ kú má drị́gé nõgó, nga ápá fũú jó rĩ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yõsépã vé ãmbúgú Pótĩfã kã tã ũkú ni ní ũlũú ꞌí ní ꞌdĩri yịị́, ꞌa ni ve Yõsépã ní ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Pótĩfã jị Yõsépã ri mụụ́ ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá, vũrã ꞌbãgú rĩ ní rizú ꞌbá riꞌbá tã ũnjí ꞌoꞌbá rĩ pi ũꞌyĩzú rĩ agá. ꞌBo Yõsépã kã rií adrií jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Úpí Múngú ri adrií ĩri be trụ́, ꞌbã ẹ́sị́ múké ĩri ní, sẽ ãmbúgú riípi ꞌbá ĩ ní ũꞌyĩí jó ãngũ ũꞌyĩzú rĩ agá rĩ pi ũtẽépi rĩ lẽ Yõsépã ri lẽlẽ. ");
INSERT INTO kbo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kúru ágó ãmbúgú riípi ꞌbá ĩ ní ũꞌyĩí rĩ pi ũtẽépi rĩ ꞌbã Yõsépã ri ãmbúgú rú ꞌbá ĩ ní ũꞌyĩí rĩ pi drị̃gé, tã ĩ ní rií ngaá jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá rĩ, ku ẹ̃zị́ ni céré kuú Yõsépã drị́gé. ");
INSERT INTO kbo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ágó ãmbúgú riípi ꞌbá ĩ ní ũꞌyĩí rĩ pi ũtẽépi rĩ ẽ ẹ́sị́ tĩ tã ãzi sĩ ãluŋáni kuyé, ãꞌdiãtãsĩyã Úpí Múngú ri Yõsépã be trụ́, sẽ tã Yõsépã ní rií ꞌoó rĩ pi céré ri adrií mụzú múké. ");
INSERT INTO kbo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Vụ́drị̃ ni kã vụ̃ụ́ mãdã, ꞌbãgú Ẽjẽpétõ vé rĩ vé ꞌbá riípi ĩri ní íwá sẽépi rĩ pi ĩrivé ꞌbá riípi pánga áꞌdípi rĩ be ꞌokí tã ũnjí, sẽ ꞌbãgú rĩ ã ꞌa ve ãní rá. ");
INSERT INTO kbo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ꞌBãgú Ẽjẽpétõ vé rĩ ã ꞌa ve ívé ũgalaku riípi íwá sẽépi rĩ ní, ãzini ũgalaku riípi pánga áꞌdípi rĩ ní ambamba, ");
INSERT INTO kbo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","úꞌbé kộpi jó ãngũ ũꞌyĩzú ãmbúgú ãngũ ũtẽépi rĩ ní rií ũtẽé rĩ agá, vũrã ĩ ní Yõsépã ri ꞌyĩzú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ãmbúgú riípi ãngũ ũtẽépi rĩ ẹzị kộpi kú Yõsépã drị́gé, Yõsépã ri kộpi ũtẽé nĩ. Kộpi kâ adrií jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá caá ụ́ꞌdụ́ be ãco, ");
INSERT INTO kbo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ꞌbãgú Ẽjẽpétõ vé rĩ vé ágó riípi íwá sẽépi ĩri ní rĩ pi ágó riípi pánga áꞌdípi ĩri ní ĩ ní ũꞌyĩí kuú jó ãngũ ũꞌyĩzú rĩ agá rĩ be, urobí ní kộpi ũbĩzú ị̃rị̃trọ́, ꞌbo urobí rĩ pi vé ífífí ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ụ̃ꞌbụ́tịŋá rĩ sĩ, Yõsépã kã mụụ́ kộpi vúgá ꞌdãlé, ndre kộpi adrikí kuú ízákĩzã rú. ");
INSERT INTO kbo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yõsépã ní kúru ꞌbãgú rĩ vé ũgalaku rĩ pi zịzú kĩnĩ, “Ãndrũ ĩmi adrikí kuú ízákĩzã rú ꞌdíni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kộpi ní újázú ĩri ní kínĩ, “Urobí ũbĩ ꞌbâ ị̃rị̃trọ́, ꞌbo ꞌbá ãzi ꞌbá ní tã ni ẽ ífífí ũlũúpi ni ꞌdãáyo.” Kúru Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Múngú ri ícó urobí rĩ vé ífífí ũlũ nĩ. Ĩmi ũlũkí drĩ má ní urobí ĩmi ũbĩípi rĩ ká.” ");
INSERT INTO kbo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kúru ꞌbãgú rĩ vé ꞌbá riípi ĩri ní íwá sẽépi rĩ ní urobí ꞌi ũbĩípi rĩ ũlũzú Yõsépã ní kĩnĩ, “Urobí rĩ ũbĩ ma, á ndre pẹtị vị́nyọ̃ vé ni má ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Pẹtị vị́nyọ̃ vé rĩ drị́tị be na. Pẹtị rĩ kã íꞌdó rũú, koro ĩri ní íꞌdózú fũ zozú, ĩri ní ꞌazú. ");
INSERT INTO kbo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Á rụ ꞌbãgú rĩ vé kópõ kú má drị́gé, má ní vị́nyọ̃ rĩ vé ũꞌa uꞌdụzú, má ní zozú ꞌbãgú Ẽjẽpétõ vé rĩ vé kópõ agá, má ní kópõ rĩ sẽzú ꞌbãgú rĩ drị́gé.” ");
INSERT INTO kbo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yõsépã ní ꞌyozú ĩri ní kĩnĩ, “Urobí rĩ vé ífífí ꞌdíni, drị́tị na ꞌdĩꞌbée, ĩri ụ́ꞌdụ́ na. ");
INSERT INTO kbo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ụ́ꞌdụ́ na ni gé, ꞌbãgú Ẽjẽpétõ vé rĩ ímụ́ mi trũ rá, ĩri mi ꞌbã gõ mívé ẹ̃zị́ gé ũzi, mi ímụ́ ĩri ní íwá rĩ sẽ nĩ, sụ̃ mí ní rií ándúrú sẽé ĩri ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ꞌBo mívé tã ẹ́cị́ dõ mụzú múké, mí ụ̃sụ̃ mâ tã be, ꞌí ꞌbã ẹ́sị́ múké má ní, mí ũlũ mávé tã ꞌbãgú Ẽjẽpétõ vé rĩ ní, ã trũ rí ma jó ãngũ ũꞌyĩzú rĩ agá nõósĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ãꞌdiãtãsĩyã rụkí ma ũkpõ sĩ íjị́ ꞌbá Ẽbérẽ vé rĩ pi vé ãngũ agá ꞌdãásĩ. Ẽjẽpétõ agá nõgó, á ꞌo tã ãzi ũnjí ĩ ní ícózú ma ꞌyĩzú ãní ãluŋáni kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ãmbúgú riípi pánga áꞌdípi rĩ kã ndreé Yõsépã ũlũ urobí rĩ vé ífífí múké, ĩri ní ꞌyozú Yõsépã ní kĩnĩ, “Urobí ũbĩ kpá ma rá. Urobí rĩ kĩnĩ, á ri ũvú na pánga be agá ni pi ꞌdụ mụzú drị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ꞌBãgú Ẽjẽpétõ vé rĩ vé ngá ĩ ní áꞌdí gí rĩ pi ãrẽvú céré ũvú ụrụgégélésĩ rĩ agá, ꞌbo ãríŋá rĩ pi rikí ngá rĩ pi teé ũvú rĩ agá má drị̃gé ꞌdĩgé.” ");
INSERT INTO kbo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yõsépã ní ꞌyozú ĩri ní kĩnĩ, “Urobí rĩ vé ífífí ꞌdíni, ũvú na ꞌdĩꞌbée, ĩri ụ́ꞌdụ́ na. ");
INSERT INTO kbo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ụ́ꞌdụ́ na ni gé, ꞌbãgú Ẽjẽpétõ vé rĩ mî drị̃ lị, ĩri mívé ãvũ ꞌyĩ pẹtị sị́gé. Ãríŋá rĩ pi mívé ãvũ te rá.” ");
INSERT INTO kbo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kã mụụ́ caá ụ́ꞌdụ́ na ni gé, ụ́ꞌdụ́ ꞌdãri, ụ́ꞌdụ́ ĩ ní ꞌbãgú rĩ vé tịngárá ã tã ígázú rĩ. ꞌBãgú rĩ ꞌbã ụ̃mụ̃, zị ívé ũgalaku rĩ pi ãrẽvú céré ímụ́ ụ̃mụ̃ rĩ ã nyangárá gá. Zị kpá ívé ãmbúgú riípi ꞌí ní íwá sẽépi rĩ pi, ãmbúgú pánga áꞌdípi rĩ be ímụ́zú ụ̃mụ̃ rĩ gé ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ꞌBãgú Ẽjẽpétõ vé rĩ ní ãmbúgú riípi ꞌí ní íwá sẽépi rĩ ꞌbãzú gõzú ívé ẹ̃zị́ gé ũzi, ã sẽ rí ꞌí ní íwá rĩ sụ̃ ĩri ní ándúrú rií sẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ꞌBo ꞌyĩ ãmbúgú riípi pánga áꞌdípi rĩ pẹtị sị́gé, sụ̃ nyo Yõsépã ní ĩrivé urobí ũlũú rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ꞌBo ꞌbãgú rĩ vé ãmbúgú riípi ĩri ní íwá sẽépi rĩ ụ̃sụ̃ Yõsépã ã tã kuyé, ãvĩ ĩrivé tã sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ílí ị̃rị̃ ã vụ́drị̃ gé, ꞌbãgú Ẽjẽpétõ vé rĩ ũbĩ urobí kĩnĩ, ꞌí tu pá kuú yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ tị gé. ");
INSERT INTO kbo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tị́ ẹ́zị̂rị̃ usese, rụ́ꞌbá be múlímúlí ni pi ĩfũkí yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá ꞌdãásĩ ãmvé nõó, kộpi rikí ĩzíríkõ rĩ pi nyaá. ");
INSERT INTO kbo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tị́ ꞌdĩꞌbée ã vụ́drị̃ gé, tị́ ụrụkọ ẹ́zị̂rị̃ rụ́ꞌbá be jịrị, ụ́yị́ꞌbá kú goroce ni pi ĩfũkí kpá yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá ꞌdãásĩ ãmvé nõó, tukí pá kuú tị́ usese pá tuꞌbá kuú yị̃ị́ gãrã gá rĩ pi ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tị́ rụ́ꞌbá be jịrị, ụ́yị́ꞌbá kú goroce ꞌdĩꞌbée nyakí tị́ ẹ́zị̂rị̃ usese rụ́ꞌbá be múlímúlí ꞌdĩꞌbée rá. Kúru ꞌbãgú Ẽjẽpétõ vé rĩ ní aruzú. ");
INSERT INTO kbo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ꞌBãgú rĩ gõ kpá ụ́ꞌdụ́ koó dị̃ị́, urobí ãzi gõ kpá ĩri ũbĩí dị̃ị́, urobí rĩ agá ꞌdãá, ndre ũndú ayi drị̃ be ẹ́zị̂rị̃ ũndú pẹtị ãlu sị́gé, ꞌa gbálígbálí, mị be múké múké. ");
INSERT INTO kbo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Vụ́drị̃ ni gé, ũndú ĩfũ drị̃ be ẹ́zị̂rị̃ ũndú pẹtị ãlu ꞌdĩri ã rụ́ꞌbá gá, kộpi ayikí céré kuú mũnímũní rú, ũlí íbí ívị́ ụ̃tụ́ ní ĩfũngárá gálésĩ, ũlí rĩ koko, sẽ ũndú rĩ vé bị́ ụ́nyụ́ ãní rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ũndú mũnímũní rú ꞌdĩꞌbée utekí ũndú ꞌaápi mị be múké múké ꞌdĩꞌbée rá. ꞌBãgú Ẽjẽpétõ vé rĩ ní kpá aruzú, nị̃ ámá rá ꞌyozú kínĩ, ngá rĩ urobí ũbĩ ꞌi nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kã mụụ́ adrií ụ̃ꞌbụ́tịŋá rĩ sĩ, ꞌbãgú rĩ ẽ drị̃ ábá céré céré. Ĩri ní újógú rĩ pi zịzú, ãzini ꞌbá tã nị̃ꞌbá ambamba ãngũ Ẽjẽpétõ vé rĩ agá rĩ pi zịzú ímụ́zú ꞌí vúgá nõlé. Ĩri ní urobí rĩ ũlũzú kộpi ní, ꞌbo ꞌbá ãzi urobí rĩ vé ífífí ũlũúpi ĩri ní ãluŋáni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kúru ꞌbãgú Ẽjẽpétõ vé rĩ vé ãmbúgú riípi ĩri ní íwá sẽépi rĩ ní ꞌyozú ꞌbãgú rĩ ní kĩnĩ, “Ụ́ꞌdụ́ ãndrũ rĩ gé, má ígá tã má ní ándúrú ãvĩzú ãní rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mî ꞌa ve ándúrú ꞌbá ní mívé ãmbúgú riípi pánga áꞌdípi rĩ be, ꞌí ꞌbe ꞌbâ jó ãngũ ũꞌyĩzú ãmbúgú ãngũ ũtẽépi rĩ ní rií ũtẽé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ị́nị́ŋá ãzi sĩ, urobí ũbĩ ꞌbâ ị̃rị̃trọ́ ãmbúgú riípi pánga áꞌdípi rĩ be, urobí rĩ pi vé ífífí ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sâ ꞌdãri gé, Ẽbérẽgú ãzi ri adrií ꞌbá be trụ́ jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá, ĩri ãtíꞌbá ãmbúgú ãngũ ũtẽépi rĩ vé ni. ꞌBá ũlũkí urobí ꞌbâ ũbĩípi rĩ ĩri ní, ũlũ ꞌbá ãlu ãlu vé urobí ẽ ífífí rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tã rĩ pi ngakí nyo ĩ sụ̃ụ́ ĩri ní ũlũú ꞌbá ní rĩ tị́nị. ꞌBãkí ma gõó mávé ẹ̃zị́ gé ũzi, ꞌyĩkí ágó riípi pánga áꞌdípi rĩ pẹtị sị́gé.” ");
INSERT INTO kbo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kúru ꞌbãgú rĩ ní ꞌbá pẽzú mụzú Yõsépã ri zịzú, koro ĩ ní Yõsépã ri íjị́zú jó ãngũ ũꞌyĩzú rĩ agá ꞌdãásĩ ãmvé. Yõsépã ní ꞌî drị̃ꞌbí fazú, ĩri ní ívé bõngó újázú, ĩri mụzú pá tuzú ꞌbãgú rĩ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ꞌBãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Urobí ũbĩ ma, ꞌbo ꞌbá ãzi urobí rĩ vé ífífí ũlũúpi má ní ni ãluŋáni ꞌdãáyo. Á yị kínĩ, urobí ũbĩ dõ ꞌbá rĩ, ꞌbá rĩ ũlũ dõ mí ní, mi urobí rĩ vé ífífí ũlũ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yõsépã ní ꞌyozú ꞌbãgú rĩ ní kĩnĩ, “Má ícó urobí rĩ vé ífífí ũlũú mávé ũkpõ sĩ bã ku, Múngú ri ícó urobí rĩ vé ífífí ũlũ mí ní nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kúru ꞌbãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Urobí rĩ ũbĩ ma kĩnĩ, á tu pá kuú yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ tị gé. ");
INSERT INTO kbo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Tị́ ẹ́zị̂rị̃ usese rụ́ꞌbá be múlímúlí ni pi ĩfũkí yị̃ị́ ãmbúgú dịị́pi dịdị rĩ agá ꞌdãásĩ, kộpi rikí ĩzíríkõ rĩ pi nyaá. ");
INSERT INTO kbo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tị́ ꞌdĩꞌbée ã vụ́drị̃ gé, tị́ ụrụkọ ẹ́zị̂rị̃ rụ́ꞌbá be jịrị, ụ́yị́ꞌbá kú goroce ni pi ĩfũkí kpá yị̃ị́ rĩ agá ꞌdãásĩ ãmvé nõó. Ụ̃kụ ni, á ndre drĩ tị́ sụ̃ ꞌdĩꞌbée tị́nị rụ́ꞌbá be jịrị, ụ́yị́ꞌbá goroce ni pi ãngũ Ẽjẽpétõ vé rĩ agá nõgó kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tị́ rụ́ꞌbá be jịrị, ụ́yị́ꞌbá goroce ꞌdĩꞌbée nyakí tị́ usese, rụ́ꞌbá be múlímúlí ĩfũꞌbá drị̃drị̃ rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kộpi kâ tị́ usese ꞌdĩꞌbée nyaá gí, ꞌbá ãzi ícópi nị̃ị́pi ámápi ꞌyozú kínĩ kộpi nyakí tị́ usese ꞌdĩꞌbée gí ꞌdíni ni ꞌdãáyo, ãꞌdiãtãsĩyã kộpi áwíkí adrií kuú goroce sụ̃ ĩ ní adrií ụ̃kụ rĩ tị́nị. Kúru má ní aruzú. ");
INSERT INTO kbo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Á gõ kpá urobí ãzi ũbĩí dị̃ị́, urobí rĩ agá ꞌdãá, á ndre ũndú ayi drị̃ be ẹ́zị̂rị̃ ũndú pẹtị ãlu sị́gé, ꞌa gbálígbálí, mị be múké múké. ");
INSERT INTO kbo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Vụ́drị̃ ni gé, ũndú gõ ĩfũú drị̃ be ẹ́zị̂rị̃ ũndú pẹtị ãlu ꞌdĩri ã rụ́ꞌbá gá, kộpi ayikí céré mũnímũní rú, ũlí íbí ívị́ ụ̃tụ́ ní ĩfũngárá gálésĩ, ũlí rĩ koko, sẽ ũndú rĩ vé bị́ ụ́nyụ́ ãní rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ũndú mũnímũní rú ꞌdĩꞌbée utekí ũndú drị̃ be ẹ́zị̂rị̃ ꞌaꞌbée mị be gbálígbálí ꞌdĩꞌbée rá. Má ũlũ urobí ꞌdĩri újógú rĩ pi ní, ꞌbo ꞌbá ãzi ífífí ni ũlũúpi má ní ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kúru Yõsépã ní ꞌyozú ꞌbãgú rĩ ní kĩnĩ, “Ãmbúgú mávé rĩ, mívé urobí ꞌdĩꞌbée ị̃rị̃trọ́ lũ céré tã ãlu rĩ. Múngú iꞌda tã ꞌí ní lẽé ngaá rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tị́ usese ẹ́zị̂rị̃ rụ́ꞌbá be múlímúlí ꞌdĩꞌbée, kộpi ílí ẹ́zị̂rị̃ rĩ pi vé tã iꞌda. Ũndú drị̃ be ẹ́zị̂rị̃ ꞌaápi mị be gbálígbálí ꞌdĩꞌbée, kộpi kpá ílí ẹ́zị̂rị̃ ãlu ãlu rĩ pi vé tã iꞌda. Ílí ẹ́zị̂rị̃ ꞌdĩꞌbée agá, ãnyãngã ri ímụ́ ka ambamba. Urobí ꞌdĩꞌbée ãlu rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tị́ ẹ́zị̂rị̃ rụ́ꞌbá be jịrị, ụ́yị́ꞌbá goroce ĩfũꞌbá vúlé rú rĩ pi, kộpi ílí ẹ́zị̂rị̃ rĩ pi vé tã iꞌda. Ũndú drị̃ be ẹ́zị̂rị̃ ayiípi mũnímũní rú, ũlí ívị́pi ụ̃tụ́ ní ĩfũngárá gálésĩ, koópi koko, ũndú rĩ vé bị́ sẽépi ụ́nyụ́pi rá ꞌdĩꞌbée, kộpi kpá ílí ẹ́zị̂rị̃ ãlu ãlu rĩ pi vé tã iꞌda. Kộpi ílí ẹ́zị̂rị̃ ẹ̃bị́rị́ ní ímụ́zú ꞌdezú rĩ vé tã iꞌda. ");
INSERT INTO kbo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Tã ꞌdĩri ímụ́ ꞌi nga sụ̃ má ní ũlũú mí ní rĩ tị́nị, Múngú iꞌda mí ní tã ꞌí ní lẽé ímụ́ ngaá rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ílí ẹ́zị̂rị̃, ãnyãngã ri ímụ́ ka ambamba ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ꞌBo vụ́drị̃ ni gé, ílí ẹ́zị̂rị̃, ẹ̃bị́rị́ ri ímụ́ ꞌde ambamba, ꞌbá rĩ pi ímụ́ ãvĩ ãnyãngã kaápi ambamba ãngũ Ẽjẽpétõ vé rĩ agá rĩ ã tã sĩ rá. Ẹ̃bị́rị́ rĩ ímụ́ ꞌbá rĩ pi fụ ũnjí ũnjí ãngũ Ẽjẽpétõ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ẹ̃bị́rị́ ri ímụ́ ꞌde ũnjí ũnjí, ãnyãngã ọ́tụ́ kaápi ãngũ rĩ agá ambamba ꞌdãri vé tã rĩ ãvĩ kộpi drị̃gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Múngú sẽ urobí rĩ ũbĩ mi vú be ị̃rị̃, ãꞌdiãtãsĩyã Múngú lẽ tã rĩ ꞌdụụ́ ngaá sụ̃ ꞌdĩri tị́nị, ĩri ímụ́ tã rĩ ꞌdụ nga mbẽlẽŋá. ");
INSERT INTO kbo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ꞌBãgú Ẽjẽpétõ vé rĩ, lẽ mî ndã ꞌbá úmĩ be tã nị̃ị́pi múké múké ni, mî ꞌbã ĩri adrií ãmbúgú rú ãngũ Ẽjẽpétõ vé rĩ ã tã mbaá. ");
INSERT INTO kbo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ꞌBãgú Ẽjẽpétõ vé rĩ, lẽ mî ũpẽ ꞌbá ũgalaku rú ni pi ãngũ Ẽjẽpétõ vé rĩ agásĩ, kộpi ã rikí ãnyãngã kaápi ambamba ílí ẹ́zị̂rị̃ agá ꞌbá rĩ pi ní rií ĩkũnãá rĩ pi úmú, tọ̃wụ́ ni pi agá, kộpi ã ꞌdụkí ãlu. ");
INSERT INTO kbo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ílí ãnyãngã ní ímụ́zú kazú múké ꞌdĩꞌbée agá, ãmbúgú mávé rĩ, lẽ mî sẽ tãị́mbị́, lẽ ũgalaku rĩ pi ã úmúkí ãnyãngã fífí rĩ, kộpi ã jịkí ꞌbãá kụ̃rụ́ ĩvé rĩ pi agá jó ãnyãngã ꞌbãzú rĩ pi agá. Lẽ kộpi ã ꞌbãkí ãngáráwá rií ãnyãngã rĩ ũtẽé, ãnyãngã ã adri rí kụ̃rụ́ rĩ pi agá anigé. ");
INSERT INTO kbo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ãnyãngã ꞌdĩri ĩ ꞌbã ku ꞌbá ãngũ rĩ agá rĩ pi ní, kộpi ẽ ímụ́kí rí nyaá sâ ẹ̃bị́rị́ ní ímụ́zú ꞌdezú ũnjí ũnjí ílí ẹ́zị̂rị̃ ãngũ Ẽjẽpétõ vé rĩ agá rĩ gé, ãꞌdiãtãsĩyã ẹ̃bị́rị́ ã fụ rí ꞌbá ãngũ nõri agá rĩ pi ku.” ");
INSERT INTO kbo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ꞌBãgú Ẽjẽpétõ vé rĩ pi ívé ũgalaku rĩ pi be, kộpi ãꞌyĩkí tã Yõsépã ní ꞌyoó ꞌdĩri rá. ");
INSERT INTO kbo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ꞌBãgú Ẽjẽpétõ vé rĩ ní ꞌyozú kĩnĩ, “ꞌBâ nyo ícó ꞌbá Índrí Uletere Múngú vé rĩ ní ású sụ̃ ágó nõri tị́nị ni ị́sụ́ rá?” ");
INSERT INTO kbo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kúru ꞌbãgú Ẽjẽpétõ vé rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Múngú iꞌda mí ní urobí rĩ pi vé ífífí céré gí, ꞌbá ãzi úmĩ be tã nị̃ị́pi sụ̃ mí tị́nị ãluŋáni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ma mi ꞌbã adri ãmbúgú rú mávé ũgalaku rĩ pi drị̃gé, ꞌbá mávé rĩ pi céré tã mí ní ꞌyoó rĩ ꞌdụ nga. Má ní adrií ꞌbãgú rĩ sĩ, ma adri ãmbúgú mí drị̃lé gá.” ");
INSERT INTO kbo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kúru ꞌbãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Á ꞌbã mi nóni adrií ãmbúgú ãngũ Ẽjẽpétõ vé rĩ agásĩ céré.” ");
INSERT INTO kbo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ꞌBãgú rĩ ní ívé kátrĩ ĩ ní ꞌî rụ́ sĩí rụ́ꞌbá ni gé rĩ ínjézú suzú Yõsépã ã drị́ mváŋá gá. Ĩri ní Yõsépã ri úsúzú bõngó ũnyĩ be ni sĩ, ĩri ní ngá dábũ rú ni íꞌdụ́zú ꞌyĩzú umbe ni gé. ");
INSERT INTO kbo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ꞌBãgú rĩ sẽ ívé ꞌbá ꞌdeépi ꞌí úgóró gá rĩ vé ãrãbíyã hũsánĩ ní rií seé rĩ, Yõsépã ri únjú ãní nĩ. ꞌBá Yõsépã ẹndrẹtị gé rĩ pi rikí ọ́ꞌụ́ ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ĩmi kukí lẹ́tị Yõsépã ní!” Tã ꞌdĩri lũ ꞌyozú kínĩ, ꞌbãgú rĩ ꞌbã Yõsépã ri gávãnã rú ãngũ Ẽjẽpétõ vé rĩ agá gí. ");
INSERT INTO kbo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ꞌBãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Mâ adri dõ ꞌbãgú drãáãsĩyã, ꞌbá ãzi ícó tã ãzi ꞌoó ãngũ Ẽjẽpétõ vé rĩ agá nõgó mî tị ãkó ku.” ");
INSERT INTO kbo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ꞌBãgú rĩ ní Yõsépã ã rụ́ ꞌdazú Zãfẽnátã Pãnéyã. Ĩri ní Ãsẽnétã ri sẽzú Yõsépã ní ũkú rú. Ãsẽnétã ri mvá ũkú átálágú Põtĩférã kụ̃rụ́ Ónõ vé rĩ agá rĩ vé ni. Yõsépã ní ẹ́cị́zú ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yõsépã ní íꞌdózú ẹ̃zị́ ngazú gávãnã rú ꞌbãgú Ẽjẽpétõ vé rĩ ã pálé gá rĩ gé, ị́sụ́ ãkũdẽ ĩri ílí be pụ̃kụ́ na. Yõsépã ku ꞌbãgú rĩ kú ꞌdĩgé, ri ẹ́cị́ mụzú ãngũ Ẽjẽpétõ vé rĩ agásĩ ãngũ rĩ úndré nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ílí ẹ́zị̂rị̃ ĩ ní ꞌyoó ãnyãngã ri ka ãní ambamba ꞌdĩꞌbée agá, ãnyãngã ka ãngũ rĩ agá ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yõsépã ní ãnyãngã kaápi ílí ẹ́zị̂rị̃ agá ãngũ Ẽjẽpétõ vé rĩ agá rĩ úmúzú, ĩri ní ꞌbãzú jó ãnyãngã ꞌbãzú rĩ pi agá kụ̃rụ́ rĩ pi agásĩ. ꞌBã ãnyãngã ĩ ní ꞌaá kụ̃rụ́ ãlu ãlu ã gãrã gá rĩ kụ̃rụ́ ĩ ní ãnyãngã rĩ ꞌãzú ꞌdãri agá. ");
INSERT INTO kbo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yõsépã úmú ãnyãngã rĩ ãmbúgú ãmbúgú jó ãnyãngã ꞌbãzú rĩ pi agá ꞌdãá, sụ̃ cínyáfã troópi kú ngũ yị̃ị́ gãrã gá rĩ tị́nị, gõ ãnyãngã rĩ ã ụ̃ꞌbị̃ngárá, ãzini sĩngárá ni kuú rá, ãꞌdiãtãsĩyã ãnyãngã rĩ ambamba, ícókí ụ̃ꞌbị̃ị́ bã ku. ");
INSERT INTO kbo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ẹ̃bị́rị́ rĩ ní drĩ ꞌdezú kuyé rĩ gé, átálágú Põtĩférã kụ̃rụ́ Ónõ vé rĩ agá rĩ vé mvá ũkú Ãsẽnétã tị Yõsépã ní anji ãgõ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yõsépã ꞌda ívé mvá kãyú rĩ ã rụ́ Mãnásẽ ꞌi, kĩnĩ, “Múngú sẽ mávé ĩzãngã ã tã ãvĩ mâ ẹ́sị́ agásĩ gí, ãzini ĩzãngã mâ ẹ́sị́ agá ꞌbá má ẹ́tẹ́pị vé ꞌbẹ̃tị́ ãsámvú gé rĩ pi ã tã sĩ rĩ, ãvĩ mâ ẹ́sị́ agásĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yõsépã ꞌda ívé mvá ꞌdeépi kãyú rĩ vú sĩ rĩ ã rụ́ Ẽfẽrémã, ãꞌdiãtãsĩyã kĩnĩ, “Ãngũ má ní ĩzãngã nyazú nõri agá, Múngú sẽ á gõ mvá ãzi tịị́ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ílí ẹ́zị̂rị̃ ãnyãngã ní kazú ambamba ãngũ Ẽjẽpétõ vé rĩ agá rĩ ní dẹzú. ");
INSERT INTO kbo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kúru ílí ẹ́zị̂rị̃ ẹ̃bị́rị́ vé rĩ ní íꞌdózú sụ̃ Yõsépã ní ꞌyoó rĩ tị́nị. Ẹ̃bị́rị́ rĩ ꞌde ãngũ Ẽjẽpétõ ã gãrã gá sĩ rĩ pi agásĩ céré, ꞌbo ãngũ Ẽjẽpétõ vé rĩ agásĩ céré ãnyãngã anigé. ");
INSERT INTO kbo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ꞌBá Ẽjẽpétõ vé rĩ pi vé ãnyãngã kã dẹẹ́, ẹ̃bị́rị́ rĩ íꞌdó kộpi fụụ́ ũnjí ũnjí, kộpi íꞌdókí rií ngoó ꞌbãgú rĩ bị́lé gá kínĩ, ĩ lẽkí ꞌbãgú rĩ ã sẽ ĩ ní ãnyãngã. Kúru ꞌbãgú rĩ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí Yõsépã vúgá, tã ĩri ní lũú ĩmi ní rĩ, lẽ ĩmi ꞌdụkí ngaánga.” ");
INSERT INTO kbo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ẹ̃bị́rị́ rĩ kã ꞌdeé ãngũ rĩ agásĩ céré, Yõsépã ní jó ãnyãngã ꞌbãzú rĩ ẽ tị zị̃zú, ĩri ní ãnyãngã fífí rĩ ụzịzú ꞌbá Ẽjẽpétõ vé rĩ pi ní, ãꞌdiãtãsĩyã ẹ̃bị́rị́ rĩ ꞌde ũnjí ũnjí ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ꞌBá ãngũ rĩ pi agásĩ rĩ pi ãrẽvú céré ꞌdekí mụụ́ ãnyãngã fífí jeé Yõsépã vúgá ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá, ãꞌdiãtãsĩyã ẹ̃bị́rị́ rĩ ꞌde ãngũ vũ drị̃gé rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yõkóbũ kã yịị́ kínĩ, ãnyãngã Ẽjẽpétõ gá ꞌdãlé anigé, ĩri ní ꞌyozú ꞌí ẹnjịpị́ị ní kĩnĩ, “Ngá ĩmi ní pá tuzú kú ꞌdĩgé rizú ĩmi úndrézú ĩmi ãsámvú gé sĩ ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Á yị kínĩ, ãnyãngã Ẽjẽpétõ gá ꞌdãlé anigé, ĩmi mụkí ꞌbá ní ãnyãngã rĩ jeé, ꞌbâ adrikí rí ídri rú, ꞌbâ ũdrãkí rí ku.” ");
INSERT INTO kbo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kúru Yõsépã vé ẹ́drị́pị́ị mụdrị́ rĩ pi ní ꞌdezú mụzú ãnyãngã rĩ jengárá gá Ẽjẽpétõ gá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ꞌBo Yõkóbũ pẽ Yõsépã ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ ri mụzú ẹ́drị́pị́ị vúgá sĩ ĩndĩ kuyé, ãꞌdiãtãsĩyã ꞌo ụ̃rị̃ sĩ, ụ̃sụ̃ déna tã ũnjí ri mụ ĩri ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ĩsẽrélẽ vé anji rĩ pi mụkí ꞌbá mụꞌbá ãnyãngã jengárá gá Ẽjẽpétõ gá ꞌdãlé rĩ pi be trụ́, ãꞌdiãtãsĩyã ẹ̃bị́rị́ rĩ ꞌde kpá ãngũ Kãnánã vé rĩ agá ꞌdãlé ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sâ ꞌdãri gé, Yõsépã ri gávãnã ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãlé nĩ, ri ãnyãngã rĩ sẽé jeé ꞌbá rĩ pi ní nĩ. Yõsépã ẹ́drị́pị́ị kâ caá ꞌdãlé, kộpi ní kũmũcí ũtị̃zú, ĩ drị̃ sị̃zú vũgá Yõsépã ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yõsépã kã ꞌí ẹ́drị́pị́ị ndreé, nị̃ kộpi ámá bá, ꞌbã ꞌi kú sụ̃ ꞌi ꞌbá túngú ni tị́nị, átá kộpi ní ọ̃jọ̃gọ̃ sĩ, ĩri ní kộpi zịzú kĩnĩ, “Ĩmi íbíkí ímụ́ íngõósĩla?” Kộpi ní újázú kínĩ, “ꞌBá íbíkí ímụ́ Kãnánã gálésĩ, ꞌbá ímụ́kí ãnyãngã jeé.” ");
INSERT INTO kbo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yõsépã ã nị̃ dõ ẹ́drị́pị́ị rá drãáãsĩyã, ẹ́drị́pị́ị nị̃kí ĩri ámá kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yõsépã ní urobí ọ́tụ́ ꞌi ũbĩípi kộpi ã tã sĩ ꞌdãri ígázú, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌbá ãngũ úmíꞌbá ni pi! Ĩmi ímụ́kí ãngũ ꞌbávé rĩ úmí, dõ vũrã ĩ ní ũtẽé ku rĩ íngõri?” ");
INSERT INTO kbo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kộpi ní újázú kínĩ, “Ãmbúgú ꞌbávé rĩ, adri ꞌdíni kuyé. ꞌBâ ãtíꞌbá mívé ni, ꞌbá ímụ́kí ãnyãngã jeé. ");
INSERT INTO kbo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ꞌBâ céré anji ꞌbá ãlu vé ni. ꞌBâ ꞌbá tã ꞌoꞌbá pịrị ni pi, ꞌbá adrikí ꞌbá ãngũ úmíꞌbá ni pi ku.” ");
INSERT INTO kbo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Adri ꞌdíni kuyé! Ĩmi ímụ́kí ãngũ ꞌbávé rĩ úmí, dõ vũrã ĩ ní ũtẽé ku rĩ íngõri?” ");
INSERT INTO kbo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kộpi ní ꞌyozú ĩri ní kínĩ, “Ãmbúgú ꞌbávé rĩ, ꞌbâ mụdrị́ drị̃ ni ị̃rị̃, ꞌbâ céré ẹ́drị́pị, ꞌbâ anji ágó riípi adriípi ãngũ Kãnánã vé rĩ agá rĩ vé ni. ꞌBávé ẹ́drị́pị ụ̃dụ́ rĩ ĩri vúlé ꞌbá ẹ́tẹ́pị vúgá ꞌdãáꞌdã. ꞌBávé ẹ́drị́pị ãlu rĩ drã gí.” ");
INSERT INTO kbo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Sụ̃ té má ní ꞌyoó rĩ tị́nị, ĩmi ꞌbá ãngũ úmíꞌbá ni pi! ");
INSERT INTO kbo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Á lẽ nị̃ị́ dõ ĩmi ri tã áda ꞌyo. Á sõ ũyõ ꞌbãgú rĩ ã rụ́ sĩ, ĩmivé ẹ́drị́pị ụ̃dụ́ rĩ ícá dõ nõgó kuyé, ĩmi ícókí fũú ãngũ Ẽjẽpétõ vé rĩ agá nõósĩ ku. ");
INSERT INTO kbo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Lẽ ĩmi pẽkí ꞌbá ãlu ĩmi ãsámvú gé ꞌdĩgé, ã mụ ĩmi ẹ́drị́pị ri bĩí, ĩmi aceꞌbée rĩ pi, ma ĩmi ꞌbe jó ãngũ ũꞌyĩzú rĩ agá, mâ nị̃ rí ámá dõ tã ĩmi ní ꞌyoó rĩ tã áda. Dõ tã ĩmi ní ꞌyoó rĩ adri tã áda kuyé, ꞌbãgú rĩ ã rụ́ sĩ, ĩmi ꞌbá ãngũ úmíꞌbá ni pi!” ");
INSERT INTO kbo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yõsépã ní kộpi suzú céré jó ãngũ ũꞌyĩzú rĩ agá caá ụ́ꞌdụ́ be na. ");
INSERT INTO kbo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kã mụụ́ adrií ụ́ꞌdụ́ na ni gé, Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Á ru Múngú ri rá, ĩmi ꞌokí dõ sụ̃ má ní ꞌyoó rĩ tị́nị, ĩmi ídrí rá. ");
INSERT INTO kbo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ĩmi dõ ꞌbá tã ꞌoꞌbá pịrị ni pi, lẽ ꞌbá ãlu ĩmi ãsámvú gé ꞌdĩgé, ã adri jó ãngũ ũꞌyĩzú rĩ agá nõgó, ĩmi aceꞌbée rĩ pi, lẽ ĩmi jịkí ãnyãngã rĩ mụzú vúlé ꞌbá ĩmivé ꞌbẹ̃tị́ ãsámvú gé ẹ̃bị́rị́ ní rií fụụ́ ꞌdãꞌbée ní. ");
INSERT INTO kbo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ꞌBo ĩmi mụkí ĩmivé ẹ́drị́pị ụ̃dụ́ rĩ íjị́ ímụ́ má vúgá nõlé, ã lũ rí ꞌyozú kínĩ, ĩmi ri tã áda ꞌyo, ã úꞌdị́kí rí ĩmi drãá ku.” Yõsépã ẹ́drị́pị́ị ãꞌyĩkí tã ꞌdĩri rá. ");
INSERT INTO kbo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kộpi ní átázú ĩ ãsámvú gé sĩ kínĩ, “Ádarú ĩ ri ꞌbâ ĩrĩŋã tã ꞌbá ní ꞌoó ꞌbá ẹ́drị́pị Yõsépã ní rĩ sĩ. ꞌBá ndrekí ĩzãngã ándúrú ĩri ní ꞌi ĩmãmãlãzú ívé ídri ã tã sĩ rĩ rá, ꞌbo ꞌbá yịkí ĩrivé tã kuyé, sẽ ꞌbá ní rizú ĩzãngã nõri nyazú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rũbénã ní ꞌyozú kộpi ní kĩnĩ, “Á ꞌyo ándúrú ĩmi ní kuyé? Má kínĩ, ĩmi ꞌdịkí mvá rĩ ku fô! Ĩmi gãkí yịgá sĩ. Sẽ nóni ꞌbâ ri ĩzãngã nya, ꞌbá ní ĩri ꞌdịị́ drãá rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kộpi nị̃kí ámá ꞌyozú kínĩ, Yõsépã yị tã ĩ ní átá rĩ gí ꞌdíni kuyé, ãꞌdiãtãsĩyã ꞌbá ãzi ri átángá kộpi ní átá rĩ újá nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yõsépã ní ngazú mụzú kộpi ã gãrã gá sĩ ꞌdĩísĩ rá, ĩri ní íꞌdózú ngozú. Ĩri ní ꞌi újázú gõzú kộpi vúgá ꞌdãá, ĩri ní gõzú átázú kộpi ní dị̃ị́. Ĩri ní Sĩmĩyónã ri ĩpẽzú kộpi ãsámvú gé ꞌdĩgé, ĩri ní ꞌyozú ã úmbékí ĩri kộpi ẹndrẹtị gé ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yõsépã ní tãị́mbị́ sẽzú kĩnĩ, ã tõkí ãnyãngã fífí kộpivé jũrú rĩ pi agásĩ, ã ꞌbãkí ꞌbá ãlu ãlu vé mũfẽngã fífí gõó ĩrivé jũrú agá ꞌdãlé ũzi. Ã sẽkí kộpi ní ngá nyanya, kộpi ã nyakí rí kộpi ní mụngárá gá lẹ́tị gé ꞌdĩgé. Kâ kộpi ní ngá nyanya rĩ sẽé gí, ");
INSERT INTO kbo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","kộpi ní ĩvé ãnyãngã fífí rĩ pi ũdrõzú ĩvé dõngí rĩ pi ã úgóró gá, kộpi ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ãngũ rĩ kã nịị́, kộpi ní pá tuzú. ꞌBá ãlu kộpi ãsámvú gé ꞌdĩgé, ĩri ní ívé jũrú ẽ tị zị̃zú, ꞌî íꞌdụ́ rí ãnyãngã sẽé ívé dõngí rĩ ní, ị́sụ́ ívé mũfẽngã fífí rĩ kú jũrú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ĩri ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “Ĩmi ndrekí drĩ ká! Újákí mávé mũfẽngã fífí gõó vúlé, mũfẽngã fífí rĩ kú mávé jũrú agá nõ!” Kộpi ẽ ẹ́sị́ tĩ rụ̃cụ̃, kộpi ã rụ́ꞌbá yã kpĩríkpĩrí, ọ́gụ́pị ndre ọ́gụ́pị ri, kộpi ní ꞌyozú kínĩ, “Múngú ꞌo ꞌbâ ꞌdíni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kộpi kâ caá ĩ ẹ́tẹ́pị Yõkóbũ vúgá Kãnánã gá ꞌdãá, kộpi ũlũkí tã ꞌi ngaápi ĩ rụ́ꞌbá gá rĩ pi ãrẽvú céré ĩri ní, kộpi kínĩ, ");
INSERT INTO kbo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Gávãnã ãngũ Ẽjẽpétõ vé rĩ agá rĩ átá ꞌbá ní ọ̃jọ̃gọ̃ sĩ, kĩnĩ ꞌbâ ri ãngũ Ẽjẽpétõ vé rĩ úmí. ");
INSERT INTO kbo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ꞌBá ní ꞌyozú ĩri ní, ‘ꞌBá adrikí ꞌbá ãngũ úmíꞌbá ni pi ku, ꞌbâ ꞌbá tã ꞌoꞌbá pịrị ni pi. ");
INSERT INTO kbo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ꞌBâ ẹ́drị́pị rú mụdrị́ drị̃ ni ị̃rị̃, ꞌbâ anji ꞌbá ãlu vé ni ãngũ Kãnánã vé rĩ agá. Mvá ụ̃dụ́ rĩ ꞌbá ẹ́tẹ́pị vúgá vúlé ꞌdãáꞌdã, ꞌbávé ẹ́drị́pị ãlu rĩ drã gí.’ ");
INSERT INTO kbo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Gávãnã Ẽjẽpétõ vé rĩ ní ꞌyozú ꞌbá ní kĩnĩ, ‘Á lẽ nị̃ị́ dõ ádarú ĩmi ꞌbá tã ꞌoꞌbá pịrị ni pi. Ĩmi kukí ĩmivé ẹ́drị́pị ãlu ni kú má be nõgó. Ĩmi jịkí ãnyãngã rĩ mụzú ĩmivé ꞌbá ꞌbẹ̃tị́ ãsámvú gé ẹ̃bị́rị́ ní rií fụụ́ ꞌdãꞌbée ní. ");
INSERT INTO kbo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ĩmi mụkí ĩmivé ẹ́drị́pị ụ̃dụ́ rĩ bĩí íjị́ má vúgá nõó, mâ nị̃ rí ꞌyozú kínĩ, ĩmi adrikí ꞌbá ãngũ úmíꞌbá ni pi ku, ĩmi ꞌbá tã ꞌoꞌbá pịrị ni pi. Ma ĩmi ẹ́drị́pị ri sẽ gõ ĩmi ní rá, ĩmi ícó ẹ́cị́ ãnyãngã je ãngũ nõri agá, ꞌbá ãzi uga ĩmi ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kộpi kâ rií ĩvé ãnyãngã fífí rĩ ũdãá jũrú rĩ pi agásĩ ãmvé, ꞌbá ãlu ãlu ị́sụ́ ívé mũfẽngã fífí rĩ jũrú rĩ agá ꞌdãá! Kộpi kâ mũfẽngã fífí rĩ pi ndreé, ãzini kộpivé ẹ́tẹ́pị Yõkóbũ kã mũfẽngã fífí rĩ pi ndreé, kộpi ã rụ́ꞌbá yã kpĩríkpĩrí. ");
INSERT INTO kbo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kộpivé ẹ́tẹ́pị Yõkóbũ ní ꞌyozú kĩnĩ, “Ĩmi ꞌbekí mávé anjiŋá rĩ pi ãvĩí! Yõsépã ri nóni ꞌdãáyo, Sĩmĩyónã ri kpá ꞌdãáyo, ĩmi lẽkí kpá Bẹ̃nyẹ̃mị́nẹ̃ rĩ jịị́ mụzú! Tã ĩmi ní ꞌoó ꞌdĩri ĩzãngã sẽ má ní!” ");
INSERT INTO kbo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kúru Rũbénã ní ꞌyozú ẹ́tẹ́pị ní kĩnĩ, “Má íjị́ dõ Bẹ̃nyẹ̃mị́nẹ̃ ri ĩgõó kuyé, má ãꞌyĩ rá, mi ícó mávé anji ị̃rị̃ ꞌdĩꞌbée úꞌdị́ rá. ꞌÍ ku Bẹ̃nyẹ̃mị́nẹ̃ ri má drị́gé, má ícó ĩri íjị́ ĩgõ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ꞌBo Yõkóbũ ní ꞌyozú kĩnĩ, “Mávé mvá mụ ꞌdãlé ãluŋáni ku, ãꞌdiãtãsĩyã ẹ́drị́pị drã gí, kukí ĩri kú ọ́ꞌdụ́kụ́lẹ. Tã ũnjí ị́sụ́ dõ ĩri ẹ̃cị̃ ĩmi ní tuú rĩ gé lẹ́tị gé ꞌdĩgé, ĩzãngã rĩ sĩ, ĩmi sẽ ma drã rá.” ");
INSERT INTO kbo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ẹ̃bị́rị́ rĩ áwí ꞌdeé kuú ũnjí ũnjí ãngũ Kãnánã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kộpi kâ ãnyãngã ĩ ní jeé Ẽjẽpétõ gá rĩ nyaá dẹẹ́ gí, kộpivé ẹ́tẹ́pị Yõkóbũ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi gõkí mụụ́ ꞌbá ní ãnyãngã ãzi jeé.” ");
INSERT INTO kbo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yụ́dã ní ꞌyozú ĩri ní kĩnĩ, “Ágó ãmbúgú rĩ átá ꞌbá ní ũkpó ũkpó kĩnĩ, ‘Ĩmi íjị́kí dõ ĩmivé ẹ́drị́pị ụ̃dụ́ rĩ ímụ́zú ĩndĩ kuyé, ĩmi gõkí ícá má ẹndrẹtị gé dị̃ị́ ku.’ ");
INSERT INTO kbo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mí ãꞌyĩ dõ ꞌbâ jịkí ꞌbá ẹ́drị́pị ụ̃dụ́ rĩ mụzú ĩndĩ rá, ꞌbâ mụ ãnyãngã rĩ je íjị́ mí ní rá. ");
INSERT INTO kbo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mí kĩnĩ dõ ꞌbâ jịkí ĩri ku, ꞌbá mụkí ku, ãꞌdiãtãsĩyã ágó ãmbúgú rĩ ꞌyo ꞌbá ní kĩnĩ, ‘Ĩmi íjị́kí dõ ĩmivé ẹ́drị́pị ụ̃dụ́ rĩ ímụ́zú ĩndĩ kuyé, ĩmi gõkí ícá má ẹndrẹtị gé dị̃ị́ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ĩsẽrélẽ ní ꞌyozú kĩnĩ, “Ngá ĩmi ní ĩzãngã sẽzú má ní ꞌdíni rĩ ãꞌdi? Ngá ĩmi ní lũzú ágó ãmbúgú rĩ ní ĩmivé ẹ́drị́pị ãzi anigé rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kộpi ní újázú ĩri ní kínĩ, “Ágó ãmbúgú rĩ uzị ꞌbâ ꞌbávé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ã tã sĩ kĩnĩ, ‘Ĩmi ẹ́tẹ́pị ri drĩ ídri rú? Ĩmi ẹ́drị́pị ãzi anigé?’ ꞌBá újákí átángá ĩri ní ꞌbâ uzịzú rĩ pi rá. ꞌBâ ícó nị̃ ngóni ꞌyozú kínĩ ĩri ꞌyo, ‘Ĩmi íjị́kí ĩmi ẹ́drị́pị ri ímụ́zú ĩndĩ’?” ");
INSERT INTO kbo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kúru Yụ́dã ní ꞌyozú ꞌí ẹ́tẹ́pị Ĩsẽrélẽ ní kĩnĩ, “Mí ãꞌyĩ ꞌbâ ꞌdekí mụụ́ Bẹ̃nyẹ̃mị́nẹ̃ be trụ́, ꞌbâ ícó mụ ĩri be rá, ꞌbâ anji mívé rĩ pi, mî úlúngu be, ꞌbávé anjiŋá rĩ pi be, ꞌbâ adrikí rí ídri rú, ꞌbâ ũdrãkí rí ku. ");
INSERT INTO kbo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ma ĩri ã tã mba rá, ma ĩri íjị́ ĩgõ mí vúgá nõlé rá, má íjị́ dõ ĩri ĩgõó mí vúgá nõlé kuyé, tã ni ã adri má drị̃gé, má ní drĩ adrizú ídri rú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ꞌBâ izakí té dõ sâ kuyé, ꞌbá mụkí té ꞌdãlé gí, ꞌbá ẹndịkí té ꞌbâ caá vú be ị̃rị̃ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kộpivé ẹ́tẹ́pị Ĩsẽrélẽ ní ꞌyozú kộpi ní kĩnĩ, “Dõ Bẹ̃nyẹ̃mị́nẹ̃ ri mụ ĩmi vúgá sĩ ĩndĩ, ĩmi tõkí ngá múké múké ãngũ nõri agá rĩ pi ĩmivé jũrú rĩ pi agásĩ, ĩmi jịkí sẽé ágó ãmbúgú rĩ ní fẽfẽ rú. Ĩmi tõkí ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni, ọ̃nyụ́, ngá tị́bị́ áꞌdízú ẹ̃jị́ be ngụ̃ꞌbá ndrị̃ndrị̃ ni pi, mị́rẹ̃, kụmụrọ́, ãzini ãlĩmóndã. ");
INSERT INTO kbo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ĩmi ꞌdụkí mũfẽngã fífí ĩmi ní ị́sụ́ ĩmivé jũrú agá rĩ pi mụzú ĩndĩ, ĩmi ꞌdụkí mũfẽngã rĩ ãzi gbã ĩmi ní ị́sụ́ ꞌdĩri pí mụzú ĩndĩ, ĩmi újákí ĩmi ní ị́sụ́ jũrú rĩ pi agá rĩ pi gõzú vúlé, sâ ãzi ni sĩ ꞌbá ãzi ku mũfẽngã fífí ꞌdĩri tãlãvĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ĩmi jịkí ĩmi ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ rĩ mụzú ĩndĩ, koro ĩmi ꞌdekí mụụ́ ágó ãmbúgú rĩ vúgá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Múngú Ũkpõ ꞌDị́pa ã sẽ ágó rĩ ẽ ẹ́sị́ ã adri ĩdríkídri ĩmi ní, ã ọyụ rí Sĩmĩyónã pi Bẹ̃nyẹ̃mị́nẹ̃ be ĩgõó vúlé. Dõ mávé anjiŋá rĩ pi ãvĩ dẹ má drị́gé sĩ céré, kộpi ãvĩkí ĩngá ĩyí.” ");
INSERT INTO kbo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yõkóbũ vé anji rĩ pi ní fẽfẽ Yõkóbũ ní lẽé ã jịkí sẽé ágó ãmbúgú rĩ ní rĩ pi ꞌdụzú, kộpi ꞌdụkí mũfẽngã fífí ĩ ní ị́sụ́ jũrú agá rĩ pi, kộpi ꞌdụkí kpá ãzini gbã ĩ ní ị́sụ́ jũrú agá ꞌdĩri pí, kộpi jịkí Bẹ̃nyẹ̃mị́nẹ̃ ri mụzú ĩndĩ. Kộpi ní mụzú cazú Ẽjẽpétõ gá ꞌdãlé, kộpi ní ĩ iꞌdazú Yõsépã ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yõsépã kã Bẹ̃nyẹ̃mị́nẹ̃ pi ndreé ꞌí ẹ́drị́pị́ị be, ĩri ní ꞌyozú ívé ꞌbá riípi ívé ngá jó agá rĩ pi ũtẽépi rĩ ní kĩnĩ, “ꞌÍ jị ꞌbá ꞌdĩꞌbée mụzú mávé jó agá ꞌdãá, ꞌí lị ndrị̃ị́, mí áꞌdí, ꞌbâ nyakí rí kộpi be ụ̃tụ́ mgbímgbi gé ꞌdĩgé.” ");
INSERT INTO kbo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ágó rĩ ní ndrị̃ị́ rĩ lịzú áꞌdízú, sụ̃ Yõsépã ní ꞌyoó ꞌí ní rĩ tị́nị, ĩri ní kộpi jịzú mụzú Yõsépã vé jó agá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kâ kộpi jịị́ mụzú Yõsépã vé jó agá ꞌdãá, kộpi ꞌokí ụ̃rị̃ sĩ. Kộpi íꞌdókí rií ụ̃sụ̃ụ́ kínĩ, “Íjị́kí ꞌbâ nõgó mũfẽngã fífí ĩ ní ándúrú ũꞌbãá gõó ꞌbávé jũrú agá rĩ pi vé tã sĩ. Ágó ãmbúgú rĩ lẽ ꞌbâ urụụ́ ꞌbãá adrií tụ́gẹ̃rị̃ ívé ni rú, lẽ dõngí ꞌbávé rĩ pi uꞌdụụ́ ꞌbá drị́gé sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kúru kộpi ní ꞌdezú mụzú átázú Yõsépã vé ágó riípi ĩrivé ngá jó agá rĩ ũtẽépi rĩ ní kẹ̃ẹ́tịlé gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Kộpi kínĩ, “Ãmbúgú ꞌbávé rĩ, ándúrú ꞌbá ímụ́kí drị̃drị̃ ni ãnyãngã jeé nõgó rá. ");
INSERT INTO kbo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ꞌBo vũrã ꞌbá ní mụzú lazú rĩ gé, ꞌbá kâ ꞌbávé jũrú rĩ pi ẽ tị ọyụụ́, ꞌbá ãlu ãlu gõ ívé mũfẽngã fífí ãnyãngã jezú rĩ ị́sụ́ vúgú rĩ vú sĩ. ꞌBá íjị́kí mũfẽngã fífí rĩ pi ĩgõó vúlé nõ. ");
INSERT INTO kbo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ꞌBá nị̃kí kuyé ãꞌdi ũꞌbã ꞌbávé mũfẽngã fífí rĩ pi gõó ꞌbávé jũrú rĩ pi agá nĩ. ꞌBá íjị́kí kpá mũfẽngã ãzi ímụ́zú ĩndĩ ãnyãngã ãzi jezú ãní.” ");
INSERT INTO kbo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ágó riípi ngá jó agá rĩ ũtẽépi rĩ ní ꞌyozú kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku, má ẹ́ꞌyị́ ĩmivé mũfẽngã fífí rĩ pi gí. Múngú ĩmi ní rií ị̃njị̃ị́ ĩmi ẹ́tẹ́pị pi be rĩ, ũꞌbã mũfẽngã fífí rĩ pi gõó ĩmivé jũrú rĩ pi agásĩ nĩ.” Kúru ĩri ní Sĩmĩyónã ri íjị́zú ĩfũzú jó ãngũ ũꞌyĩzú rĩ agá ꞌdãásĩ ãmvé kộpi vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ágó riípi ngá jó agá rĩ ũtẽépi rĩ ní ãgõ ꞌdĩꞌbée jịzú mụzú Yõsépã vé jó agá ꞌdãá. Ĩri ní kộpi ní yị̃ị́ sẽzú, kộpi ã ũjĩkí rí ĩ pá ãní. Ĩri ní kpá ãnyãngã sẽzú kộpivé dõngí rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kộpi údékí fẽfẽ ĩ ní lẽé sẽé Yõsépã ní rĩ kú ị́nọ́gọ́sị́ rizú Yõsépã ri ũtẽzú, kãdõ ícá ụ̃tụ́ mgbímgbi gé ꞌdĩgé, ĩ sẽkí rí ĩri ní, ãꞌdiãtãsĩyã kộpi yịkí kínĩ, ĩ ímụ́ ínyá nya Yõsépã pi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yõsépã kã ícá ꞌbẹ̃tị́ nõlé, kộpi ní fẽfẽ ĩ ní íjị́ rĩ pi íꞌdụ́zú sẽzú ĩri ní. Kộpi ní kũmũcí ũtị̃zú, ĩ drị̃ sị̃zú vũgá ĩri ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yõsépã kã kộpi ẹzịị́, ĩri ní zịzú kĩnĩ, “Ĩmivé ẹ́tẹ́pị adriípi ãrãkã rú ĩmi ní tã ni lũú má ní rĩ ĩri íngóni? Ĩri drĩ ídri rú?” ");
INSERT INTO kbo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kộpi ní újázú ĩri ní kínĩ, “Mívé ãtíꞌbá ꞌbá ẹ́tẹ́pị ri drĩ ídri rú, ĩri múké.” Kộpi ní kũmũcí ũtị̃zú vũgá ĩri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yõsépã kã ꞌí ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ ĩ ní adrií ĩri be ẹ́ndrẹ́pị ãlu rĩ ndreé, ĩri ní zịzú kĩnĩ, “Ĩmivé ẹ́drị́pị ụ̃dụ́ rú ĩmi ní tã ni lũú má ní rĩ ĩri adriípi ꞌdĩ?” Ĩri ní gõzú ꞌyozú kĩnĩ, “Mâ mvá rĩ, Múngú ã ꞌbã ẹ́sị́ múké mí ní.” ");
INSERT INTO kbo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Koro Yõsépã ní fũzú jó rĩ agásĩ, ĩri ní mụzú fizú ívé jó lazú rĩ agá, ĩri ní íꞌdózú ngozú, ãꞌdiãtãsĩyã lẽ ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ ri ambamba. ");
INSERT INTO kbo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kã ꞌî mịlẹ́tị ũjĩí gí, ĩri ní ẹ́sị́ úmbézú, ĩri ní ĩfũzú ãmvé. Ĩri ní ꞌyozú ãtíꞌbá rĩ pi ní kínĩ, “Ĩmi íjị́kí ínyá rĩ awaá.” ");
INSERT INTO kbo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Sẽkí Yõsépã ní ínyá rĩ ọ́ꞌdụ́kụ́lẹ, ĩrivé ẹ́drị́pị́ị ní sẽkí túngú, ꞌbá Ẽjẽpétõ vé rĩ pi ní sẽkí túngú, ãꞌdiãtãsĩyã ꞌbá Ẽjẽpétõ vé rĩ pi nyakí ínyá ꞌbá Ẽbérẽ vé rĩ pi be trụ́ ku, kộpi gãkí ꞌbá Ẽbérẽ vé rĩ pi sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ꞌBãkí Yõsépã ẹ́drị́pị́ị úrí Yõsépã ẹndrẹtị gé ílí ĩ ní kộpi tịzú rĩ vú sĩ, íꞌdózú mvá kãyú rĩ vúgá cazú mvá ụ̃dụ́ rĩ vúgá, kộpi rikí ĩ úndré ĩ ãsámvú gé sĩ, sẽ kộpi ãyãkí ãní ãyãyã. ");
INSERT INTO kbo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Awakí ínyá Yõsépã vé mísá drị̃gé rĩ, jịkí sẽé kộpi ní, sẽkí Bẹ̃nyẹ̃mị́nẹ̃ vé rĩ caá vú sĩ tọ̃wụ́ ndẽ ẹ́drị́pị́ị vé rĩ rá. Yõsépã ẹ́drị́pị́ị rikí ngá nyaá, ãzini ngá mvụụ́ Yõsépã pi be trụ́, ꞌbá ãzi uga kộpi kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yõsépã ní ꞌyozú ívé ágó riípi ívé ngá jó agá rĩ ũtẽépi rĩ ní kĩnĩ, “Mí ũtõ ãnyãngã ãgõ ꞌdĩꞌbée vé jũrú rĩ pi agásĩ tré tré, kộpi ní ícó ꞌdụụ́ bã rá ni. Mí ũꞌbã ꞌbá ãlu ãlu vé mũfẽngã gõó ĩrivé jũrú agá ꞌdãá vúlé. ");
INSERT INTO kbo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ꞌÍ ꞌbã mávé kópõ ọ́gụ́pị ọ́gụ́ọ̃gụ̃ rĩ mvá ụ̃dụ́ rĩ vé jũrú agá, ꞌí ꞌbã kpá ĩrivé mũfẽngã ãnyãngã jezú rĩ gõó jũrú rĩ agá ꞌdãá vúlé.” Ágó rĩ ꞌdụ tã rĩ ngaá sụ̃ Yõsépã ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ãngũ rĩ kã ọ́wụ́, ĩ ní ãgõ ꞌdĩꞌbée pẽzú mụzú ĩvé dõngí rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kộpi kâ drĩ mụụ́ vụ̃ụ́ kụ̃rụ́ rĩ agásĩ rárá rú kuyé, Yõsépã ní ꞌyozú ívé ágó riípi ívé ngá jó agá rĩ pi ũtẽépi rĩ ní kĩnĩ, “ꞌÍ mụ ãgõ ꞌdĩꞌbée ã vụ́drị̃ gé sĩ, mí ị́sụ́ dõ kộpi gí, ꞌí zị kộpi ꞌdíni, ‘Á ꞌo ĩmi ní tã múké, ngá ĩmi ní tã ũnjí ꞌozú ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kópõ ꞌdĩri mávé ãmbúgú rĩ ní rizú ngá mvụzú ãní rĩ, ĩri kpá ri ẹ̃ndrị́ ndrị ãní. Tã ĩmi ní ꞌoó ꞌdĩri ũnjí.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ágó rĩ kã mụụ́ kộpi ị́sụ́, ĩri ní ꞌyozú kộpi ní sụ̃ Yõsépã ní ꞌyoó ꞌí ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kộpi ní újázú ĩri ní kínĩ, “Tã mí ní rií átá ꞌdíni rĩ ãꞌdi? ꞌBâ ãtíꞌbá mívé ni, ꞌbá ícókí tã ꞌoó ꞌdíni ku. ");
INSERT INTO kbo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mũfẽngã fífí ꞌbá ní ị́sụ́ ꞌbávé jũrú agá rĩ pi, ꞌbá íjị́kí Kãnánã gá ꞌdãásĩ sẽé gõó mí ní rá. ꞌBâ ícó mívé ãmbúgú rĩ vé ngá ọ́gụ́pị ọ́gụ́ọ̃gụ̃, dõku dábũ ụ̃gụ̃ ĩrivé jó agá ꞌdãásĩ ímụ́zú ĩndĩ íngóni ngóni? ");
INSERT INTO kbo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Dõ mí ị́sụ́ ãmbúgú rĩ vé kópõ ꞌbá ãlu vúgá ꞌbâ ãsámvú gé nõgó rá, ã ꞌdịkí ꞌbá ꞌdĩri drãá rá, ꞌbâ ị̃mbị́tã ĩ ní kuú nõꞌbée gõ adri tụ́gẹ̃rị̃ mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ágó rĩ ní újázú kộpi ní kĩnĩ, “Múké, ã adri sụ̃ ĩmi ní ꞌyoó rĩ tị́nị. ꞌBá ĩ ní kópõ rĩ ị́sụ́ ĩri vúgá rĩ, ĩri adri tụ́gẹ̃rị̃ rú nĩ. Ĩmi ị̃mbị́tã ĩ ní kuú ꞌdĩꞌbée, ĩmi adri tã ãkó, ĩ ĩmi ọyụ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Koro ꞌbá ãlu ãlu ní ívé jũrú íꞌdụ́zú ꞌbãzú vũgá, kộpi ní tị ni ọyụzú. ");
INSERT INTO kbo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kúru ágó riípi Yõsépã vé ngá jó agá rĩ pi ũtẽépi rĩ ní íꞌdózú kộpivé jũrú ã ꞌa ndãzú, íꞌdó ndãá mvá kãyú rĩ vé rĩ agá, cĩmgbá cazú mvá ụ̃dụ́ rĩ vé rĩ agá. Ị́sụ́ kópõ rĩ Bẹ̃nyẹ̃mị́nẹ̃ vé jũrú agá. ");
INSERT INTO kbo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bẹ̃nyẹ̃mị́nẹ̃ ẹ́drị́pị́ị kâ tã ꞌdĩri ndreé, kộpi ũsĩkí ĩvé bõngó ĩ rụ́ꞌbá gá sĩ kpélékpélé. Kộpi ní ĩvé ãnyãngã rĩ pi ũdrõzú ĩvé dõngí rĩ pi ã úgóró gá, kộpi ní ĩ újázú gõzú vúlé kụ̃rụ́ rĩ agá ꞌdãlé ũzi. ");
INSERT INTO kbo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yụ́dã pi ẹ́drị́pị́ị be, kộpi kâ caá ꞌdãlé, kộpi ị́sụ́kí Yõsépã ri drĩ jó agá, kộpi úꞌbékí ĩ vũgá sĩ Yõsépã ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yõsépã ní ꞌyozú kĩnĩ, “Ngá ĩmi ní ꞌoó ꞌdíni rĩ ãꞌdi? Ĩmi nị̃kí ꞌyozú kínĩ, ꞌbá má tị́nị nõri, ma ícó ẹ̃ndrị́ ndrị tã rĩ nị̃zú ámázú ãní rá ꞌdíni kuyé?” ");
INSERT INTO kbo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yụ́dã ní újázú kĩnĩ, “Ãmbúgú mávé rĩ, ꞌbâ ꞌyokí rí mí ní íngóni? Tã lũúpi kínĩ ꞌbâ tã ãkó rĩ ãꞌdi? Múngú iꞌda tã ꞌbá ní ꞌoó ũnjí rĩ ãmvé gí. Ãmbúgú mávé rĩ, ꞌbâ ꞌbá ẹ́drị́pị ĩ ní kópõ rĩ ị́sụ́ ĩrivé jũrú agá rĩ pi be, ꞌbâ nóni tụ́gẹ̃rị̃ mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ꞌBo Yõsépã ní ꞌyozú kĩnĩ, “Má ícó tã ꞌoó sụ̃ ꞌdĩri tị́nị ku! ꞌYéŋá ágó ĩ ní kópõ rĩ ị́sụ́ vú ni gé rĩ, ĩri adri mávé tụ́gẹ̃rị̃ rú nĩ. Ĩmi ị̃mbị́tã ĩ ní kuú ꞌdĩꞌbée, ĩmi tã ãkó, ĩmi ícó gõ ĩmi ẹ́tẹ́pị vúgá ꞌdãá rá tã be kíri.” ");
INSERT INTO kbo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kúru Yụ́dã ní ꞌdezú mụzú Yõsépã vúgá ꞌdãá, ĩri ní Yõsépã ri mãzú kĩnĩ, “Ãmbúgú mávé rĩ, ma ãtíꞌbá mívé ni, mí ãꞌyĩ, mâ ꞌyo tã má tị gé sĩ mí ẹndrẹtị gé nõgó. Mívé ũkpõ ã adri dõ sụ̃ ꞌbãgú rĩ vé rĩ tị́nị drãáãsĩyã, lẽ mî ꞌa ã ve má ní ku. ");
INSERT INTO kbo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ãmbúgú mávé rĩ, ándúrú ꞌí zị ꞌbâ ãtíꞌbá mívé rĩ pi, mí kĩnĩ, ‘Ĩmivé ẹ́tẹ́pị anigé? Dõku ĩmivé ẹ́drị́pị anigé?’ ");
INSERT INTO kbo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ꞌBá újákí mí ní, ꞌbá kĩnĩ, ‘ꞌBávé ẹ́tẹ́pị ri anigé, ĩri ãrãkã rú, tị mvá ágóŋá ãzi ị́sụ́ ãkũdẽ ĩri ãrãkã rú. Mvá ágóŋá rĩ vé ẹ́drị́pị drã gí, kộpivé ẹ́ndrẹ́pị agá, mvá ꞌyéŋá ĩ ní kuú rĩ ĩri ꞌi, ẹ́tẹ́pị lẽ ĩri ambamba.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“ꞌÍ ꞌyo ꞌbá ní, mí kĩnĩ, ‘Ĩmi íjị́kí ĩri má vúgá nõó, mâ ndre ĩri mâ mị sĩ.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ꞌBá ꞌyokí mí ní, ꞌbá kĩnĩ, ‘Mvá ágó rĩ ícó ꞌí ẹ́tẹ́pị ri kuú ku, ku dõ ẹ́tẹ́pị ri gí, ẹ́tẹ́pị ri drã rá.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ꞌBo ꞌí ꞌyo ꞌbá ní, mí kĩnĩ, ‘Ĩmi íjị́kí dõ ĩmi ẹ́drị́pị ụ̃dụ́ rĩ ímụ́ má vúgá nõó ku, úmvúlésĩ ĩmi ndrekí mâ ẹndrẹtị dị̃ị́ ku.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ꞌBá kâ gõó vúlé mívé ãtíꞌbá ꞌbá ẹ́tẹ́pị vúgá ꞌdãlé, ꞌbá ũlũkí ĩri ní tã mí ní ꞌyoó rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ꞌBá ẹ́tẹ́pị gõ ꞌyoó kĩnĩ, ‘Ĩmi gõkí mụụ́ ꞌbá ní ãnyãngã ãzi jeé.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ꞌBo ꞌbá újákí ĩri ní, ꞌbá kĩnĩ, ‘Mí ãꞌyĩ dõ ꞌbá ẹ́drị́pị ụ̃dụ́ rĩ mụụ́ ꞌbá be ku, ꞌbá ícókí mụụ́ ku. ꞌBá ẹ́drị́pị ụ̃dụ́ rĩ mụ dõ ꞌbá be kuyé, ꞌbá ícókí ágó ãmbúgú rĩ ẽ mịlẹ́tị ndreé ku.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“ꞌBá ẹ́tẹ́pị ní ꞌyozú ꞌbá ní kĩnĩ, ‘Ĩmi nị̃kí rá ꞌyozú kínĩ, ũkú mávé rĩ tị má ní anji ãgõ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mvá ágó rĩ ãzi fũ mụzú ãmvé mâ rụ́ꞌbá gá sĩ gí, má kĩnĩ, “Ũndĩkí ĩri kpélékpélé gí.” Íꞌdózú ị́nọ́gọ́sị́ ꞌdãá, á gõ ĩri ndreé kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ĩmi jịkí dõ mvá ị̃mbị́tã ãlu ꞌdĩri mụzú ĩndĩ, tã ũnjí ị́sụ́ dõ ĩri gí, ĩmi sẽ mávé ãrãkã nõri fi ꞌbụ́ agá ĩzãngã agá.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ãmbúgú mávé rĩ, má ícó mvií gõó má ẹ́tẹ́pị vúgá ꞌdãá mvá rĩ ãkó ku, ꞌbá ẹ́tẹ́pị ri adri ídri rú mvá rĩ ní adrií ídri rú rĩ sĩ, ");
INSERT INTO kbo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ꞌbá ẹ́tẹ́pị ndre dõ mvá ágó rĩ ꞌbâ ãsámvú gé ꞌdãáyo, ꞌbá ẹ́tẹ́pị ri drã rá. ꞌBâ mívé ãtíꞌbá nõꞌbée, ꞌbâ sẽ ꞌbá ẹ́tẹ́pị dẽépi gí ꞌdãri drã rá. ");
INSERT INTO kbo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ãmbúgú mávé rĩ, á ꞌyo má ẹ́tẹ́pị ní, má kĩnĩ, ‘Ma ícó mvá ágó rĩ ã tã mba rá. Má íjị́ dõ mvá ágó rĩ ĩgõó vúlé nõó kuyé, tã ni ã adri má drị̃gé mụzú nyonyo.’ ");
INSERT INTO kbo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ãmbúgú mávé rĩ, lẽ mâ áwí adrií nõgó tụ́gẹ̃rị̃ rú mvá ágó rĩ ã vũrã gá, mí ãꞌyĩ mvá ágó rĩ, kộpi ã mvikí gõó ꞌí ẹ́drị́pị́ị be ꞌbẹ̃tị́ ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mvá ágó rĩ mụ dõ má vúgá sĩ ĩndĩ kuyé, ma ícó mvi gõ má ẹ́tẹ́pị vúgá ꞌdãlé íngóni? Á lẽ ĩzãngã má ẹ́tẹ́pị vé rĩ ndreé ku.” ");
INSERT INTO kbo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yõsépã kã ndreé ꞌí ícó ꞌî ẹ́sị́ úmbé ívé ãtíꞌbá rĩ pi ẹndrẹtị gé bã ku, ĩri ní ꞌyozú ívé ãtíꞌbá rĩ pi ní kĩnĩ, “Lẽ ĩmi fũkí má gãrã gá nõósĩ céré ãmvé!” Sâ Yõsépã ní ꞌi iꞌdazú ẹ́drị́pị́ị ní rĩ gé, ꞌbá ãzi túngú ni ꞌdãáyo, kộpi ꞌyéŋá ẹ́drị́pị́ị be. ");
INSERT INTO kbo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ĩri ní íꞌdózú ngozú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, ꞌbá Ẽjẽpétõ vé rĩ pi yịkí rá, ũlũkí tã Yõsépã ní ngozú ꞌdĩri ꞌbá ꞌbãgú rĩ vé jó ãsámvú gé rĩ pi ní rá. ");
INSERT INTO kbo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yõsépã ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “ꞌBá rĩ ma ꞌi, Yõsépã ꞌi! Má ẹ́tẹ́pị ri drĩ nyo ídri rú?” ꞌBo Yõsépã ẹ́drị́pị́ị ícókí ĩri ní tã ꞌdĩri újá bã ku, ãꞌdiãtãsĩyã ụ̃rị̃ fụ kộpi ambamba, kộpi ní Yõsépã ã rụ́ꞌbá ndreé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kúru Yõsépã ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “Ĩmi ítrúkí ĩmi ĩnyiŋá má vúgá nõó.” Kộpi kâ ĩ útrú ĩri vúgá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Ma ĩmivé ẹ́drị́pị Yõsépã ĩmi ní ọ́tụ́ sẽé jeé, ĩ ní íjị́ ãngũ Ẽjẽpétõ vé rĩ agá rĩ ꞌi! ");
INSERT INTO kbo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ꞌBo lẽ ĩmi adrikí ĩzãngã sĩ ku, ãzini lẽ ĩmî ẹ́sị́ ã ri veé ĩmi ãsámvú gé sĩ tã ĩmi ní ma sẽé jeé rĩ ã tã sĩ ku. Múngú ĩpẽ ma ímụ́zú ĩmi ní nõó drị̃drị̃, mâ ímụ́ rí ĩmi ídrí bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ẹ̃bị́rị́ ꞌde ãngũ rĩ agá ũnjí ũnjí, ꞌdụ nóni caá ílí ị̃rị̃, ẹ̃bị́rị́ rĩ ãzi ri gõ ꞌde ca ílí tọ̃wụ́, ꞌbá ãzi gõ ọ́mvụ́ ꞌãá ku, gõkí kpá ãnyãngã ĩkũnãá ku. ");
INSERT INTO kbo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ꞌBo Múngú ĩpẽ ma ímụ́zú ĩmi ní drị̃drị̃, mâ ímụ́ rí ĩmi tã mbaá ĩmivé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, ĩmi adrikí rí ídri rú. ");
INSERT INTO kbo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Adri ꞌyozú kínĩ, ĩmi ĩpẽkí ma nõgó nĩ ꞌdíni kuyé, Múngú ĩpẽ ma nĩ. Múngú ꞌbã ma adrií ũgalaku ꞌbãgú rĩ vé ni, ãzini ꞌbã ma adrií ãmbúgú rú ꞌbá ãngũ Ẽjẽpétõ vé rĩ agá rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ĩmi újákí ĩmi gõó vúlé má ẹ́tẹ́pị vúgá ꞌdãlé mbẽlẽ, ĩmi ꞌyokí ĩri ní, ‘Mî mvọ́pị Yõsépã ꞌyo ꞌdíni kĩnĩ, “Múngú ꞌbã ma ãmbúgú rú ãngũ Ẽjẽpétõ vé rĩ drị̃gé. Lẽ ẽ ímụ́ má vúgá nõó mbẽlẽ, ẽ iza sâ ku.” ’ ");
INSERT INTO kbo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ĩri ímụ́ adri ãngũ Gõsénĩ vé rĩ agá, ĩnyiŋá má gãrã gá. Ĩri adri anjiŋá ívé rĩ pi be, anjiŋá ẹnjịpị́ị ní tịị́ rĩ pi be, ívé kãbĩlõ rĩ pi be, ndrị̃ị́ rĩ pi be, tị́ rĩ pi be, ngá ãrẽvú ívé rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ma ĩri ní ãnyãngã sẽ rá, ãꞌdiãtãsĩyã ẹ̃bị́rị́ rĩ ãzi ri gõ ímụ́ ꞌde ílí tọ̃wụ́ ũnjí ũnjí. Ímụ́ dõ ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, ãzini ívé ãnyãpá rĩ pi be ku, kộpi ímụ́ ũdrã rá ẹ̃bị́rị́ rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yõsépã ní gõzú ꞌyozú kộpi ní kĩnĩ, “Ĩmi ndrekí nóni ma ĩmî mị sĩ gí, má ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ ndre kpá ma ꞌî mị sĩ gí, ádarú ꞌbá átángá átápi rĩ ma ꞌi, Yõsépã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ĩmi mụkí tã ꞌbá rĩ pi ní ma ị̃njị̃zú ãngũ Ẽjẽpétõ vé rĩ agá nõgó, ãzini tã ãrẽvú céré ĩmi ní ndreé rĩ pi ũlũú má ẹ́tẹ́pị ní. Ĩmi íjị́kí má ẹ́tẹ́pị ri ímụ́ má vúgá nõlé mbẽlẽ.” ");
INSERT INTO kbo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yõsépã pi ní ĩ uꞌdezú ẹzịzú bẹ̃drị̃ sĩ ẹ́drị́pị Bẹ̃nyẹ̃mị́nẹ̃ be, ãyĩkõ sĩ, kộpi ní íꞌdózú ngozú. ");
INSERT INTO kbo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yõsépã ní rizú ꞌí ẹ́drị́pị́ị uꞌdezú ẹzịzú mụzú ãlu ãlu bẹ̃drị̃ sĩ, ãyĩkõ sĩ, ĩri ní íꞌdózú ngozú. Vụ́drị̃ ni gé, ẹ́drị́pị́ị ní íꞌdózú átázú ĩri be. ");
INSERT INTO kbo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ụ́ꞌdụ́kọ́ rĩ kã caá ꞌbãgú rĩ vé kání agá ꞌdãá kínĩ, Yõsépã ẹ́drị́pị́ị ícákí gí, ꞌbãgú rĩ ívé ũgalaku rĩ pi be, adrikí céré ãyĩkõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ꞌBãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “ꞌÍ lũ mí ẹ́drị́pị́ị ní, kộpi ã ũꞌbãkí ĩvé ãnyãngã rĩ pi céré ĩvé dõngí rĩ pi ã úgóró gá, kộpi ã újákí ĩ gõó vúlé Kãnánã gá ꞌdãá ũzi. ");
INSERT INTO kbo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kộpi ã mụkí ĩ ẹ́tẹ́pị ri íjị́ ímụ́zú ĩrivé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be nõlé, ma kộpi ní vũrã múké ni sẽ ãngũ Ẽjẽpétõ vé rĩ agá nõgó rá, kộpi ãnyãngã ị́sụ́ nya ꞌa ni gé, ĩri kộpi ní ãyĩkõ sẽ. ");
INSERT INTO kbo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ꞌÍ lũ kộpi ní, kộpi ã jịkí ãrãbíyã ĩ ní rií seése rĩ pi mụzú Ẽjẽpétõ agá nõósĩ ĩndĩ, kộpi ẽ íjị́kí rí ĩvé anjiŋá rĩ pi ímụ́zú ãní ũkú rĩ pi be, ãzini kộpi ẽ íjị́kí rí ĩ ẹ́tẹ́pị ri ímụ́zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kộpi ã kukí ngá ĩvé rĩ pi kú vúlé ꞌdãá, ãꞌdiãtãsĩyã kộpi ímụ́ ngá múké múké ni pi ị́sụ́ ãngũ Ẽjẽpétõ vé rĩ agá nõgó rá.” ");
INSERT INTO kbo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ĩsẽrélẽ vé anji ãgõ rĩ pi ãꞌyĩkí tã ꞌbãgú rĩ ní ꞌyoó rĩ ꞌdụụ́ ngaá rá. Yõsépã sẽ kộpi ní ãrãbíyã ĩ ní rií seése rĩ pi, ãnyãngã be, kộpi ã mvikí rí gõó ãní ꞌbẹ̃tị́, sụ̃ ꞌbãgú rĩ ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yõsépã awa kộpi ní bõngó úꞌdí rú ni pi, ꞌbo sẽ Bẹ̃nyẹ̃mị́nẹ̃ ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ni mụ̃dụ̃rụ̃lụ̃ na (300), sẽ kpá ĩri ní bõngó úꞌdí rú ni pi tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ngá Yõsépã ní pẽé mụzú ꞌí ẹ́tẹ́pị ní rĩ pi dõngí ãgõ mụdrị́, ũꞌbãkí ngá múké múké Ẽjẽpétõ vé rĩ pi kộpi ã úgóró gá, dõngí ũkú rú ni pi mụdrị́, ũꞌbãkí ãnyãngã fífí, pánga, ãzini ngá ụrụkọ nyaánya ni pi, ã tu rí ẹ̃cị̃ rĩ ímụ́zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ĩri ní kộpi pẽzú mụzú. Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi ãwãkí ĩmi ãsámvú gé sĩ lẹ́tị gé ꞌdĩgé ku!” ");
INSERT INTO kbo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kộpi ní ngazú fũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ, kộpi ní mvizú gõzú ĩ ẹ́tẹ́pị Yõkóbũ vúgá ãngũ Kãnánã vé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kộpi ní ũlũzú Yõkóbũ ní kínĩ, “Yõsépã ri drĩ ídri rú! ꞌBãkí ĩri gávãnã rú ãngũ Ẽjẽpétõ vé rĩ agá.” ꞌBo tã ꞌdĩri sẽ Yõkóbũ ní ãyãngárá, ẹ̃ꞌyị̃ tã kộpi ní ũlũú ꞌí ní ꞌdĩri kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kộpi kâ tã Yõsépã ní ꞌyoó ĩ ní rĩ ũlũú Yõkóbũ ní, Yõkóbũ kã ãrãbíyã ĩ ní rií seése Yõsépã ní ĩpẽé ímụ́ ꞌi bĩí ꞌdĩꞌbée ndreé, ĩrivé yị̃kị̂ gõ ícá múké. ");
INSERT INTO kbo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ĩsẽrélẽ ní kúru ꞌyozú kĩnĩ, “Ĩri ícó adri tã ẹ́gbị! Mávé mvá Yõsépã ri drĩ ídri rú! Á lẽ mụụ́ ĩri ndreé ũgbále, ma íbí drã ndõ.” ");
INSERT INTO kbo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kúru Ĩsẽrélẽ ní ꞌdezú mụzú ãngũ Ẽjẽpétõ vé rĩ gé ꞌdãá, ꞌdụ ívé ngá rĩ pi ãrẽvú céré mụzú ĩndĩ. Kã mụụ́ caá kụ̃rụ́ Bẽrĩsébã vé rĩ gé, ĩri ní rọ̃bọ̃ŋọ̃ zãzú Múngú ꞌí ẹ́tẹ́pị Ĩsákã vé rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Múngú ní átázú Ĩsẽrélẽ be urobí agá ị́nị́ŋá rĩ sĩ kĩnĩ, “Yõkóbũ, Yõkóbũ.” Yõkóbũ ní újázú kĩnĩ, “Ma nõ.” ");
INSERT INTO kbo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Múngú ní ꞌyozú kĩnĩ, “Ma Múngú ꞌi, Múngú mí ẹ́tẹ́pị vé rĩ. ꞌÍ ꞌo ụ̃rị̃ sĩ ku, ꞌí mụ ãngũ Ẽjẽpétõ vé rĩ gé, ma úmvúlésĩ sụ́rụ́ mívé rĩ sẽ ízú tré, kộpi ícá sụ́rụ́ ãmbúgú. ");
INSERT INTO kbo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ꞌBâ mụ mí be trụ́ Ẽjẽpétõ gá ꞌdãlé. Ádarú ma úmvúlésĩ mi íjị́ ĩgõ vúlé nõlé dị̃ị́ rá. Mi úmvúlésĩ drã Yõsépã gãrã gá, ĩri mî mị ọ̃zụ̃ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kúru Yõkóbũ ní fũzú kụ̃rụ́ Bẽrĩsébã vé rĩ agásĩ, ĩrivé anji ãgõ rĩ pi ní ĩvé ẹ́tẹ́pị Yõkóbũ ri jịzú tụzú ĩvé anjiŋá rĩ pi be, ĩvé ũkú pi be, ãrãbíyã ĩ ní seése ꞌbãgú rĩ ní ĩpẽé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kộpi jịkí ĩvé ãnyãpá rĩ pi, ãzini ãꞌbú ĩ ní ị́sụ́ ãngũ Kãnánã vé rĩ gé ꞌdãlé rĩ pi mụzú ĩndĩ. Yõkóbũ pi ívé anjiŋá rĩ pi be céré ꞌdekí mụụ́ ãngũ Ẽjẽpétõ vé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yõkóbũ jị ívé anji ãgõ rĩ pi, ívé anjiŋá rĩ pi vé anji ãgõ rĩ pi, ãzini jị ívé anji ũkú rĩ pi, ívé anjiŋá rĩ pi vé anji ũkú rĩ pi be mụzú Ẽjẽpétõ gá ꞌdãá ĩndĩ, jị úyú ívé rĩ pi mụzú céré. ");
INSERT INTO kbo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Anji Ĩsẽrélẽ vé mụꞌbá Ẽjẽpétõ gá rĩ pi ã rụ́ ꞌdĩ. Drị̃drị̃ ni, Ĩsẽrélẽ vé rụ́ Yõkóbũ. Mvá kãyú Yõkóbũ vé rĩ Rũbénã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Anji ãgõ Rũbénã vé rĩ pi ã rụ́, Ẽnókã ꞌi, Pálũ ꞌi, Ẽzĩrónã ꞌi, Kãrímĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Anji ãgõ Sĩmĩyónã vé rĩ pi ã rụ́, Yẽmũyélẽ ꞌi, Yãmínĩ ꞌi, Õhádĩ ꞌi, Yãkínĩ ꞌi, Zõhárã ꞌi, Sáwũlã sĩ, Sáwũlã vé ẹ́ndrẹ́pị Kãnánãzị́. ");
INSERT INTO kbo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Anji ãgõ Lẹ́vị̃ vé rĩ pi ã rụ́, Gẽrẽsónã ꞌi, Kõhátã ꞌi, Mẽrárã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Anji ãgõ Yụ́dã vé rĩ pi ã rụ́, Érẽ ꞌi, Õnánĩ ꞌi, Sélã ꞌi, Pẽrízĩ ꞌi, Zérã sĩ. (ꞌBo ọ́tụ́ Érẽ pi Õnánĩ be ũdrãkí ãngũ Kãnánã vé rĩ agá ꞌdãlé.) Anji ãgõ Pẽrézĩ vé rĩ pi, Ẽzĩrónã pi Ãmúlã be. ");
INSERT INTO kbo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Anji ãgõ Ĩsãkárã vé rĩ pi ã rụ́, Tólã ꞌi, Púvã ꞌi, Yãsúbã ꞌi, Sĩmĩrónã sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Anji ãgõ Jẽbũlúnã vé rĩ pi ã rụ́, Sẽrédẽ ꞌi, Ẽlónĩ ꞌi, Jãhãlélẽ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Anji ãgõ ꞌdĩꞌbée Léyã ní tịị́ Yõkóbũ ní Pãdãnã Ãrámã gá rĩ pi, anji ãgõ ꞌdĩꞌbée ãsámvú gé, tị mvá ũkú rá, mvá ũkú rĩ ã rụ́ Dị́nã ꞌi. Ĩrivé anji ãgõ rĩ pi, mvá ũkú rĩ be, kộpivé kãlãfe céré pụ̃kụ́ na drị̃ ni na. ");
INSERT INTO kbo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Anji ãgõ Gádĩ vé rĩ pi ã rụ́, Zẽfónã ꞌi, Hágĩ ꞌi, Súnĩ ꞌi, Ẽzĩbónĩ ꞌi, Érĩ ꞌi, Ãródĩ ꞌi, Ãrélĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Anji ãgõ Ãsérã vé rĩ pi ã rụ́, Ĩmínã ꞌi, Ísĩvã ꞌi, Ísĩvĩ ꞌi, Bẽríyã sĩ. Kộpivé ọ́mvụ́pị Sérã ꞌi. Anji ãgõ Bẽríyã vé rĩ pi, Ẽbérẽ pi Mãlẽkĩélẽ be. ");
INSERT INTO kbo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Anji ãgõ mụdrị́ drị̃ ni ázíyá ꞌdĩꞌbée Jẽléfã ní tịị́ Yõkóbũ ní rĩ pi, Jẽléfã ri Lãbánã ní sẽé ívé mvá ũkú Léyã ní ãtíꞌbá rú rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Anji ãgõ Yõkóbũ pi ní tịị́ ꞌî ũkú ni Rãélẽ be rĩ, Yõsépã pi Bẹ̃nyẹ̃mị́nẹ̃ be. ");
INSERT INTO kbo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Anji ãgõ Yõsépã pi ní tịị́ Ãsẽnétã be Ẽjẽpétõ gá ꞌdãlé rĩ, Mãnásẽ pi Ẽfẽrémã be. Ãsẽnétã ri átálágú Põtĩférã Ónõ vé rĩ vé mvá ũkú. ");
INSERT INTO kbo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Anji ãgõ Bẹ̃nyẹ̃mị́nẹ̃ vé rĩ pi ã rụ́, Bélã ꞌi, Békẽrĩ ꞌi, Ãsĩbélẽ ꞌi, Gérã ꞌi, Nãmánã ꞌi, Éhĩ ꞌi, Rósĩ ꞌi, Mũpímũ ꞌi, Ũpímũ ꞌi, Ãrídĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Úyú mụdrị́ drị̃ ni sụ ꞌdĩꞌbée, íbíkí ĩfũú Yõkóbũ pi ã rụ́ꞌbá gá Rãélẽ be. ");
INSERT INTO kbo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dánã vé mvá Hũsímũ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Anji ãgõ Nãfãtálĩ vé rĩ pi ã rụ́, Yãzĩyélẽ ꞌi, Gúnĩ ꞌi, Jẽzérẽ ꞌi, Sĩlémũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Úyú ẹ́zị̂rị̃ ꞌdĩꞌbée íbíkí ĩfũú Yõkóbũ pi ã rụ́ꞌbá gá Bílã be. Bílã ri Lãbánã ní sẽé ívé mvá ũkú Rãélẽ ní ãtíꞌbá rú rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yõkóbũ vé úyú mụꞌbá ĩri be Ẽjẽpétõ gá ꞌdãlé rĩ pi pụ̃kụ́ ázíyá drị̃ ni ázíyá, lãkí ĩrivé anji ãgõ rĩ pi vé ũkú rĩ pi kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Anji ãgõ ĩ ní tịị́ Yõsépã ní Ẽjẽpétõ gá ꞌdãlé rĩ pi ị̃rị̃. Yõkóbũ vé ꞌbá ꞌbẹ̃tị́ ãsámvú gé mụꞌbá Ẽjẽpétõ gá ꞌdãlé rĩ pi céré pụ̃kụ́ ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yõkóbũ ní Yụ́dã ri pẽzú mụzú drị̃drị̃ Yõsépã vúgá ꞌdãlé, Yõsépã ã lũ rí ĩ ní lẹ́tị mụzú Gõsénĩ gé rĩ. Kộpi kâ caá Gõsénĩ gé ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yõsépã ní ꞌyozú ẽ íjị́kí ívé ãrãbíyã hũsánĩ ní rií seé rĩ ꞌí vú nõó, ĩri ní tụzú ꞌa ni gé, ꞌdezú mụzú ẹ́tẹ́pị Ĩsẽrélẽ vúgá ꞌdãá. Yõsépã kã caá ẹ́tẹ́pị vúgá ꞌdãá, ĩri ní ẹ́tẹ́pị ri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ, ãyĩkõ sĩ, ĩri ní íꞌdózú ngozú sâ be ãco. ");
INSERT INTO kbo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ĩsẽrélẽ ní ꞌyozú Yõsépã ní kĩnĩ, “Nóni ma ícó drã rá, ãꞌdiãtãsĩyã á ndre mi mâ mị sĩ gí, mi ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kúru Yõsépã ní ꞌyozú ꞌí ẹ́drị́pị́ị ní, ãzini ꞌbá ẹ́tẹ́pị vé jó ãsámvú gé rĩ pi ní kĩnĩ “Á lẽ mụụ́ átá ꞌbãgú rĩ be, á lẽ ꞌyoó ĩri ní, ‘Má ẹ́drị́pị́ị, ãzini ꞌbá má ẹ́tẹ́pị vé jó ãsámvú gé ándúrú adriꞌbá ãngũ Kãnánã vé rĩ agá rĩ pi ícákí má vúgá nõó gí. ");
INSERT INTO kbo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ꞌBá ꞌdĩꞌbée ꞌbá ãnyãpá úcéꞌbá ni pi, kộpi íjị́kí kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi, ngá kộpi ní ị́sụ́ ꞌdãlé rĩ pi be céré ímụ́zú ĩndĩ.’ ");
INSERT INTO kbo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ꞌBãgú rĩ zị dõ ĩmi mụụ́ ꞌí vúgá ꞌdãá, zị dõ ĩmi, ‘Ĩmivé ẹ̃zị́ ãꞌdi?’ ");
INSERT INTO kbo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ĩmi újákí ĩri ní ꞌdíni, ‘ꞌBâ mívé ãtíꞌbá, ꞌbávé ẹ̃zị́ rizú ãnyãpá úcézú ni, ꞌbá íꞌdókí ãnyãpá úcé ãnjĩŋã sĩ, sụ̃ ꞌbá ẹ́ꞌbị́pị ní rií úcé rĩ tị́nị.’ Ĩmi lũkí dõ ĩri ní sụ̃ ꞌdĩri tị́nị, ĩri ĩmi ãꞌyĩ adri ãngũ Gõsénĩ vé rĩ agá nõgó rá, ãꞌdiãtãsĩyã ꞌbá Ẽjẽpétõ vé rĩ pi lẽkí ꞌbá ãnyãpá úcéꞌbá rĩ pi ã tã ku.” ");
INSERT INTO kbo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yõsépã ní ngazú mụzú lũzú ꞌbãgú Ẽjẽpétõ vé rĩ ní kĩnĩ, “Má ẹ́tẹ́pị pi má ẹ́drị́pị́ị be, ĩvé kãbĩlõ rĩ pi be, ndrị̃ị́ rĩ pi be, tị́ rĩ pi be, ngá ĩvé rĩ pi be céré, kộpi ímụ́kí ãngũ Kãnánã vé rĩ gé ꞌdãásĩ, kộpi nóni Gõsénĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yõsépã ní ꞌí ẹ́drị́pị́ị ũpẽzú tọ̃wụ́ jịzú iꞌdazú ꞌbãgú rĩ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ꞌBãgú rĩ ní Yõsépã ẹ́drị́pị́ị zịzú kĩnĩ, “Ẹ̃zị́ ĩmivé rií ngaá rĩ ãꞌdi?” Kộpi ní újázú ꞌbãgú rĩ ní kínĩ, “Ẹ̃zị́ ꞌbávé rĩ, ꞌbâ ri ãnyãpá úcé, sụ̃ ꞌbá ẹ́ꞌbị́pị́ị ní ọ́tụ́ rií úcé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kộpi ní kpá gõzú ꞌyozú ĩri ní kínĩ, “ꞌBá ímụ́kí adrií nõgó ũkõlõ, ãꞌdiãtãsĩyã ẹ̃bị́rị́ ꞌde ãngũ Kãnánã vé rĩ agá ꞌdãá ũnjí ũnjí, ị̃rị́bị̃ ꞌbá ní ꞌbávé ãnyãpá rĩ pi úcézú ni ꞌdãáyo. Ícó dõ rá, mí ãꞌyĩ ꞌbâ adrikí ãngũ Gõsénĩ vé rĩ agá nõgó.” ");
INSERT INTO kbo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ꞌBãgú rĩ ní ꞌyozú Yõsépã ní kĩnĩ, “Mí ẹ́tẹ́pị pi mí ẹ́drị́pị́ị be, kộpi ímụ́kí mí vúgá. ");
INSERT INTO kbo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Lẽ mî ndre vũrã ãngũ Ẽjẽpétõ vé rĩ agá nõgó, ꞌí jị mí ẹ́tẹ́pị pi, mí ẹ́drị́pị́ị be mụụ́ adrií vũrã múké rĩ gé. Lẽ kộpi adrikí Gõsénĩ gé. ꞌÍ nị̃ dõ ꞌbá ãnyãpá úcéꞌbá múké ni pi kộpi ãsámvú gé ꞌdĩgé rá, ꞌí ꞌbã kộpi mávé ãnyãpá úcé.” ");
INSERT INTO kbo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kúru Yõsépã ní ẹ́tẹ́pị Yõkóbũ ri jịzú ꞌbãgú rĩ vúgá jó agá ꞌdãá, ĩri ní ẹ́tẹ́pị ri iꞌdazú ꞌbãgú rĩ ẹndrẹtị gé. Vụ́drị̃ ni gé, Yõkóbũ ní ꞌbãgú rĩ ẹzịzú, ĩri ní tãkíri sẽzú ꞌbãgú rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ꞌBãgú rĩ ní Yõkóbũ ri zịzú kĩnĩ, “Mívé ílí ca ngõpí?” ");
INSERT INTO kbo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yõkóbũ ní újázú ꞌbãgú rĩ ní kĩnĩ, “Ma ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na (130). Ílí ꞌdĩri mãdãŋá, ꞌbo á nya ĩzãngã ꞌa ni gé ambamba, má ẹ́cị́ mụzú vũrã rĩ pi agásĩ céré. Má ẹ́tẹ́pị́ị pi má ẹ́ꞌbị́pị́ị be ẹ́cị́kí mụzú vũrã rĩ pi agásĩ céré. ꞌBo kộpi adrikí caá ílí be ãco, kộpi nyakí ĩzãngã sụ̃ má ní nyaá rĩ tị́nị kuyé.” ");
INSERT INTO kbo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kúru Yõkóbũ ní tãkíri sẽzú ꞌbãgú rĩ ní, ĩri ní ꞌbãgú rĩ ẹzịzú. Ĩri ní ngazú ꞌbãgú rĩ ã gãrã gá sĩ, ĩri ní fũzú mụzú ãmvé. ");
INSERT INTO kbo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yõsépã ní ẹ́tẹ́pị pi ꞌbãzú adrizú ẹ́drị́pị́ị be ãngũ Ẽjẽpétõ vé rĩ agá, sẽ kộpi ní vũrã múké ni, vũrã rĩ ĩnyiŋá kụ̃rụ́ Rãmãsésẽ vé rĩ ã gãrã gá, sụ̃ ꞌbãgú rĩ ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yõsépã ní ãnyãngã sẽzú ꞌí ẹ́tẹ́pị ní, ꞌí ẹ́drị́pị́ị ní, ãzini ꞌbá ꞌí ẹ́tẹ́pị vé jó ãsámvú gé rĩ pi ní, sẽ kộpi ní ãnyãngã rĩ kộpivé anjiŋá rĩ pi vé kãlãfe vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ẹ̃bị́rị́ ꞌde ũnjí ũnjí ãngũ Ẽjẽpétõ vé rĩ agásĩ céré, ãzini ãngũ Kãnánã vé rĩ agásĩ céré, ãꞌdiãtãsĩyã ꞌbá rĩ pi nyakí ãnyãngã ĩvé rĩ pi dẹẹ́ céré gí. ");
INSERT INTO kbo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kúru Yõsépã ní ãnyãngã ĩ ní ꞌbãá jó ãnyãngã ꞌbãzú rĩ pi agá rĩ ụzịzú ꞌbá rĩ pi ní, ĩri ní mũfẽngã ꞌbá Ẽjẽpétõ vé rĩ pi ní ãnyãngã jezú, ãzini ꞌbá Kãnánã vé rĩ pi ní ãnyãngã rĩ jezú rĩ jịzú céré ꞌbãzú ꞌbãgú rĩ vé jó mũfẽngã ꞌbãzú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ꞌBá Ẽjẽpétõ vé rĩ pi, ꞌbá Kãnánã vé rĩ pi be, kộpivé mũfẽngã kã dẹẹ́ kộpi drị́gé sĩ gí, kộpi ní mụzú céré Yõsépã vúgá, kộpi ní ꞌyozú kínĩ, “Mũfẽngã dẹ ꞌbá drị́gé sĩ gí! Mi ꞌbâ ku ũdrã rá ãsĩ? Mí sẽ ꞌbá ní ãnyãngã.” ");
INSERT INTO kbo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yõsépã ní újázú kộpi ní kĩnĩ, “Ĩmi íjị́kí ĩmivé ãnyãpá rĩ pi sẽé má ní, ma ĩmi ní ãnyãngã rĩ sẽ ufu ãnyãpá rĩ pi sĩ rá, ãꞌdiãtãsĩyã ĩmivé mũfẽngã dẹ ĩmi drị́gé sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kộpi ní kúru ĩvé ãnyãpá rĩ pi jịzú mụzú Yõsépã vúgá ꞌdãá. Ĩri ní kộpi ní ãnyãngã sẽzú, kộpi ní ĩvé hũsánĩ rĩ pi, kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi, dõngí rĩ pi jịzú sẽzú ãnyãngã rĩ ufuzú ãní. Ílí ꞌdãri agá, Yõsépã ri kộpi ní ãnyãngã sẽé ãnyãpá kộpivé rĩ pi ufuzú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ílí ꞌdãri kã dẹẹ́, kã mụụ́ adrií ílí ãzi rĩ gé, kộpi ní mụzú Yõsépã vúgá ꞌdãá, kộpi ní ꞌyozú kínĩ, “Ãmbúgú ꞌbávé rĩ, ꞌbá ícókí úcí mí ní ku, ꞌbávé mũfẽngã dẹ ꞌbá drị̃gé sĩ gí, ꞌbávé ãnyãpá rĩ pi mívé ni. Ãmbúgú ꞌbávé rĩ, ngá ãzi aceépi ꞌbá drị́gé ꞌbá ní sẽé mí ní ni ꞌdãáyo, ngá aceépi rĩ ꞌyéŋá ꞌbâ úlúngu, ãzini vũrã ꞌbá ní adrizú rĩ. ");
INSERT INTO kbo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mi ꞌbâ ku ũdrã rá ãsĩ? Mi sẽ ꞌbávé vũrã ri adri ándrú rú ãsĩ? Lẽ mî je ꞌbâ vũrã ꞌbávé rĩ be ãnyãngã sĩ. ꞌBâ adri tụ́gẹ̃rị̃ ꞌbãgú rĩ vé ni, ꞌbávé vũrã ri adri ĩrivé ni. ꞌÍ sẽ ꞌbá ní úri, ꞌbâ adrikí rí ídri rú, ꞌbâ ũdrãkí rí ku, vũrã rĩ ẽ ícá rí ándrú rú ku.” ");
INSERT INTO kbo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kúru Yõsépã ní nyọ̃ọ́kụ́ ꞌbá Ẽjẽpétõ vé rĩ pi vé rĩ jezú céré ꞌbãgú rĩ ní. ꞌBá Ẽjẽpétõ vé rĩ pi ãrẽvú céré ụzịkí nyọ̃ọ́kụ́ ĩvé rĩ rá, ãꞌdiãtãsĩyã ẹ̃bị́rị́ rĩ ꞌde ũnjí ũnjí. Nyọ̃ọ́kụ́ rĩ gõ adrií céré ꞌbãgú rĩ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yõsépã ꞌbã ꞌbá Ẽjẽpétõ vé rĩ pi ãrẽvú céré adrií tụ́gẹ̃rị̃ ꞌbãgú rĩ vé ni. ");
INSERT INTO kbo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Nyọ̃ọ́kụ́ ꞌyéŋá ĩri ní jeé kuyé rĩ atala rĩ pi vé rĩ, ãꞌdiãtãsĩyã ꞌbãgú rĩ ri kộpi ní ãnyãngã sẽé nĩ, kộpi ní ĩvé nyọ̃ọ́kụ́ sẽzú jezú kuyé ãní. ");
INSERT INTO kbo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yõsépã ní ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “Nóni á je ĩmi gí, ãzini á je nyọ̃ọ́kụ́ ĩmivé rĩ sẽé ꞌbãgú rĩ ní gí, ĩmi ní úri ꞌdĩ, ĩmi sakí nyọ̃ọ́kụ́ rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sâ ĩ ní ãnyãngã ĩkũnãzú rĩ gé, ngá tọ̃wụ́ agá, ãlu ni ĩmi íꞌdụ́kí sẽé ꞌbãgú rĩ ní. Ị̃mbị́tã ni, ĩmi ꞌbãkí ĩmi ní úri rú, ãzini ãnyãngã rú, ĩmi nyakí rí ĩmivé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, ãzini ĩmivé anjiŋá rĩ pi be.” ");
INSERT INTO kbo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kộpi ní ꞌyozú kínĩ, “Ãmbúgú ꞌbávé rĩ, ꞌí pa ꞌbâ drã agásĩ gí, lẽ mî ꞌbã ẹ́sị́ múké ꞌbá ní, ꞌbâ ícó adri tụ́gẹ̃rị̃ ꞌbãgú rĩ vé ni rá.” ");
INSERT INTO kbo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kúru Yõsépã ní tãị́mbị́ sẽzú ꞌbá ãngũ Ẽjẽpétõ vé rĩ agá rĩ pi ní kĩnĩ, kộpi ĩkũnãkí dõ ãnyãngã rĩ gí, ngá tọ̃wụ́ agá, ãlu ni kộpi ã sẽkí ꞌbãgú rĩ ní. Tãị́mbị́ ꞌdĩri ꞌbá Ẽjẽpétõ vé rĩ pi ri ꞌdụ nganga cĩmgbá ụ́ꞌdụ́ ãndrũ rĩ gé. ꞌYéŋá nyọ̃ọ́kụ́ atala rĩ pi vé rĩ, sẽkí ꞌbãgú rĩ ní kuyé. ");
INSERT INTO kbo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kúru ꞌbá Ĩsẽrélẽ vé rĩ pi ní adrizú Gõsénĩ gé, ãngũ Ẽjẽpétõ vé rĩ agá. Kộpi ị́sụ́kí ngá ꞌdãlé ambamba, kộpi tịkí ãnji ízú tré, kộpivé kãlãfe gõ ícá kárákará. ");
INSERT INTO kbo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yõkóbũ adri ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãlé ílí mụdrị́ drị̃ ni ẹ́zị̂rị̃, ĩrivé ílí adrizú vũ drị̃gé rĩ mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ sụ drị̃ ni ẹ́zị̂rị̃. (147) ");
INSERT INTO kbo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ĩsẽrélẽ vé sâ drãzú rĩ kã ꞌbãá ícá ĩnyiŋá, ĩri ní mvọ́pị Yõsépã ri zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ lẽ dõ ma rá, lẽ mî sõ ũyõ má ẹndrẹtị gé ꞌyozú kínĩ, mi ẹ́sị́ múké ꞌbã má ní rá, ãzini mi tã má ní ꞌyoó rĩ ꞌdụ nga rá. Ã sị̃kí ma ãngũ Ẽjẽpétõ vé rĩ agá nõgó ku. ");
INSERT INTO kbo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Má kãdõ drãá, ꞌí ꞌdụ ma ãngũ Ẽjẽpétõ vé rĩ agá nõósĩ, ꞌí jị mụụ́ sị̃ị́ ụ̃jị́ ĩ ní má ẹ́ꞌbị́pị́ị sị̃zú rĩ agá.” Yõsépã ní ꞌyozú kĩnĩ, “Ma ꞌo rá sụ̃ mí ní ꞌyoó rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ĩsẽrélẽ ní gõzú ꞌyozú Yõsépã ní dị̃ị́ kĩnĩ, “ꞌÍ sõ ũyõ má ẹndrẹtị gé nõgó lũzú kínĩ, mi tã ꞌdĩri ꞌo rá.” Kúru Yõsépã ní ũyõ sõzú Ĩsẽrélẽ ẹndrẹtị gé, Yõkóbũ ní ọ̃vụ̃zú ꞌî drị̃ sị̃zú ívé gbọ́lọ́ drị̃gé ꞌdãá, ĩri ní Múngú ri zịzú. ");
INSERT INTO kbo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Vụ́drị̃ ni kã vụ̃ụ́ mãdã, ꞌbá ãzi ní mụzú lũzú Yõsépã ní kĩnĩ, “Mí ẹ́tẹ́pị Yõkóbũ ri ãzó rú.” Yõsépã ní ꞌdezú mụzú ĩri ndrezú, jị ívé anji ãgõ ị̃rị̃ Mãnásẽ pi Ẽfẽrémã be mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yõsépã kã caá ꞌdãlé, ꞌbá ãzi ní lũzú Yõkóbũ ní kĩnĩ, “Mívé mvá Yõsépã ícá gí.” Yõkóbũ ní ũkpõ ꞌbãzú, ĩri ní íngázú úrízú ụrụ sĩ ívé gbọ́lọ́ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yõkóbũ ní ꞌyozú Yõsépã ní kĩnĩ, “Múngú Ũkpõ ꞌDị́pa iꞌda ꞌi má ní ándúrú Lụ́zị̃ gé ãngũ Kãnánã vé rĩ agá ꞌdãlé, sẽ má ní tãkíri, ");
INSERT INTO kbo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ꞌyo má ní kĩnĩ, ‘Ma sẽ mi ímụ́ anji tị tré, mívé úyú rĩ pi ízú kárákará. Ma sẽ mi ímụ́ adri sụ́rụ́ be kárákará, ma ãngũ nõri sẽ úyú mívé rĩ pi ní mụzú nyonyo.’ ” ");
INSERT INTO kbo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yõkóbũ ní gõzú ꞌyozú Yõsépã ní kĩnĩ, “Mívé anji ãgõ ị̃rị̃ Ẽfẽrémã pi Mãnásẽ be ĩ ní tịị́ ãngũ Ẽjẽpétõ vé rĩ agá nõgó ꞌdĩꞌbée, kộpi adri anji mávé ni, sụ̃ Rũbénã pi ní adrií Sĩmĩyónã be anji mávé ni rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ꞌBo anji ĩ ní ímụ́ tịị́ mí ní anji ꞌdĩꞌbée ã vụ́drị̃ gé rĩ pi, kộpi adri mívé ni, nyọ̃ọ́kụ́ kộpi ẹ́drị́pị Ẽfẽrémã vé rĩ, ãzini Mãnásẽ vé rĩ ã vúgú, ĩri ímụ́ adri kộpivé ni. ");
INSERT INTO kbo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ọ́tụ́ má ní rizú ímvízú Pãdãnã Ãrámã gálésĩ rĩ gé, Rãélẽ drã lẹ́tị gé, ãngũ Kãnánã vé rĩ agá, ị́sụ́ ꞌbá cakí drĩ kụ̃rụ́ Ẽfãrátã vé rĩ gé ꞌdãlé kuyé, mâ ẹ́sị́ ị́sụ́ ĩzãngã ãní rá. Á sị̃ ĩri lẹ́tị mụụ́pi kụ̃rụ́ Ẽfãrátã vé rĩ gé rĩ ã gãrã gá.” (Kụ̃rụ́ Ẽfãrátã ꞌdĩri ĩ kpá zị Bẽtẽlémẽ.) ");
INSERT INTO kbo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ĩsẽrélẽ kã anji ãgõ Yõsépã vé rĩ pi ndreé, ĩri ní zịzú kĩnĩ, “Anji ꞌdĩꞌbée ãꞌdi pi?” ");
INSERT INTO kbo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yõsépã ní újázú ẹ́tẹ́pị ní kĩnĩ, “Anji ꞌdĩꞌbée Múngú ní sẽé má ní ãngũ Ẽjẽpétõ vé rĩ agá nõgó rĩ pi.” Yõkóbũ ní ꞌyozú kĩnĩ, “Mí íjị́ kộpi má vúgá nõó, mâ sẽ rí kộpi ní tãkíri.” ");
INSERT INTO kbo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ĩsẽrélẽ ẽ mị ẹ̃sị̃ gí, ĩri ní dẽé gí rĩ sĩ, ndre ãngũ ku. Yõsépã ní ívé anjiŋá rĩ pi jịzú vú ni gé ꞌdãá, Yõkóbũ ní kộpi ẽ tị ndruzú, ĩri ní kộpi uꞌdezú ẹzịzú bẹ̃drị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ĩsẽrélẽ ní ꞌyozú Yõsépã ní kĩnĩ, “Má ụ̃sụ̃ má ícó gõó mi ndreé dị̃ị́ ku, ꞌbo Múngú ãꞌyĩ rá sẽ á ndre kpá mívé anjiŋá rĩ pi gí.” ");
INSERT INTO kbo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yõsépã ní ívé anjiŋá rĩ pi uꞌdụzú ꞌí ẹ́tẹ́pị ã ụ̃ꞌdụ́ drị̃gé sĩ rá, ĩri ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vúgá. ");
INSERT INTO kbo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yõsépã uꞌdụ kộpi ị̃rị̃trọ́, ꞌbã Ẽfẽrémã ri Ĩsẽrélẽ vé drị́ ị̃jị́ gélésĩ, ꞌbã Mãnásẽ ri ĩrivé drị́ ẹ̃ndẹ́pị gélésĩ, útrú kộpi ĩnyiŋá Yõkóbũ vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ẽfẽrémã ã adri dõ mvá ụ̃dụ́ drãáãsĩyã, Ĩsẽrélẽ újá ꞌî drị́ ẹ̃ndẹ́pị rĩ ꞌbãá Ẽfẽrémã drị̃gé, Mãnásẽ ã adri dõ mvá kãyú drãáãsĩyã, Yõkóbũ újá ꞌî drị́ ị̃jị́ rĩ ꞌbãá Mãnásẽ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ĩri ní tãkíri sẽzú Yõsépã ní, ĩri ní ꞌyozú kĩnĩ, “Múngú má ẹ́ꞌbị́pị Ãbũrámã, ãzini má ẹ́tẹ́pị Ĩsákã pi ní rií ĩrivé tã ꞌdụụ́ ngaá rĩ, Múngú ma úcépi íꞌdózú ãnjĩŋã gá ꞌdãá cĩmgbá ãndrũ sĩ rĩ, ");
INSERT INTO kbo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mãlãyíkã ma ípápi tã ũnjí lẽépi ma ị́sụ́pi rĩ agásĩ rĩ, ã ꞌbã tãkíri anji ãgõ ꞌdĩꞌbée drị̃gé. Kộpi ã tã sĩ, mâ rụ́ ã adri rí ũgõgõ, má ẹ́ꞌbị́pị Ãbũrámã ã rụ́ ã adri rí ũgõgõ, ãzini má ẹ́tẹ́pị Ĩsákã ã rụ́ ã adri rí ũgõgõ. Lẽ kộpi ã tịkí ízú tré vũ drị̃gé nõgó.” ");
INSERT INTO kbo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yõsépã kã ndreé ẹ́tẹ́pị ꞌbã ꞌî drị́ ẹ̃ndẹ́pị rĩ Ẽfẽrémã drị̃gé, adri ãní ãyĩkõ sĩ kuyé, ĩri ní ẹ́tẹ́pị ẽ drị́ rụzú ꞌdụzú Ẽfẽrémã drị̃gé sĩ rá, ĩri ní ꞌbãzú Mãnásẽ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yõsépã ní ꞌyozú Yõkóbũ ní kĩnĩ, “Adri ꞌdíni ku, ma ẹ́tẹ́pị, mvá kãyú rĩ ꞌdĩ, ꞌí ꞌbã mî drị́ ẹ̃ndẹ́pị rĩ drị̃ ni gé.” ");
INSERT INTO kbo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ꞌBo Yõkóbũ gã sĩ, kĩnĩ, “Mâ mvá rĩ, á nị̃ tã má ní ꞌoó rĩ rá. Mãnásẽ ri kpá úmvúlésĩ ímụ́ adri sụ́rụ́ be ãmbúgú, ĩ kpá ĩri ị̃njị̃njị̃. Ĩrivé ẹ́drị́pị ụ̃dụ́ Ẽfẽrémã ri ĩri ndẽ ãmbũgũ sĩ rá. Úyú ĩrivé rĩ pi ímụ́ adri sụ́rụ́ be kárákará.” ");
INSERT INTO kbo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kúru Yõkóbũ ní tãkíri sẽzú anji ãgõ ꞌdĩꞌbée ní ụ́ꞌdụ́ ꞌdãri gé, ĩri ní ꞌyozú kĩnĩ, “ꞌBá Ĩsẽrélẽ vé rĩ pi kádõ úmvúlésĩ lẽé tãkíri sẽé, kộpi ĩmî rụ́ zị tãkíri rĩ sẽzú ãní, kộpi ꞌyo, ‘Múngú ã sẽ ĩmi ní tãkíri sụ̃ ĩri ní sẽé Ẽfẽrémã pi ní Mãnásẽ be rĩ tị́nị.’ ” Ĩsẽrélẽ zị Ẽfẽrémã ã rụ́ drị̃drị̃, ꞌî ꞌbã rí Ẽfẽrémã ri ãmbúgú Mãnásẽ ri ndẽé. ");
INSERT INTO kbo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ĩsẽrélẽ ní ꞌyozú Yõsépã ní kĩnĩ, “Ẹ̃sị̃ mãdã, ma ímụ́ drãdrã, ꞌbo Múngú ri adri ĩmi be trụ́, ĩri ĩmi jị gõ vúlé ãngũ ĩmi ẹ́ꞌbị́pị́ị vé rĩ gé Kãnánã gá ꞌdãlé rá. ");
INSERT INTO kbo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ãngũ má ní rụụ́ ẹ̃ꞌdị́ sĩ ꞌbá Ãmórã vé rĩ pi drị́gé rĩ, ma lị sẽ mí ní ãmbúgú, ĩri mí ẹ́drị́pị́ị vé rĩ ndẽ.” ");
INSERT INTO kbo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kúru Yõkóbũ ní ívé anji ãgõ rĩ pi zịzú ímụ́zú, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ímụ́kí má gãrã gá nõó, mâ ũlũ rí ĩmi ní tã ímụ́pi ꞌi ngaápi ĩmî rụ́ꞌbá gá drị̃drị̃ ꞌdĩlé rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Má anji rĩ, ma ĩmivé ẹ́tẹ́pị Yõkóbũ ꞌi, ĩmi ímụ́kí má vúgá nõó tã yịị́ má tị gé. Ma ĩmivé ẹ́tẹ́pị Ĩsẽrélẽ ꞌi, ĩmi yịkí tã má tị gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rũbénã, mi mávé mvá kãyú, á tị mi ị́sụ́ ãkũdẽ ma ũkpõ be, ã tị mi ị́sụ́ ãkũdẽ ma kẹ̃rị́ŋá rú ũkpõ be lũzú kínĩ, ma anji tị rá. Mi ꞌbá ĩ ní ị̃njị̃ị́ ị̃njị̃ ni, mi ꞌbá ũkpõ be ni. ");
INSERT INTO kbo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mi ímụ́ ẹ́cị́ sụ̃ ĩgãŋá ní rií ẹ́cị́ yị̃ị́ drị̃gé sĩ ngãlángãlá rĩ tị́nị, mí gõ adrií kãyú ku, ãꞌdiãtãsĩyã ꞌí la mávé ũkú sĩ mávé gbọ́lọ́ drị̃gé, ꞌí ꞌo tã drị̃njá sẽépi ni mávé gbọ́lọ́ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Sĩmĩyónã ĩmi Lẹ́vị̃ be, ĩmi ẹ́drị́pị, ĩmi rikí ĩmivé ngá ẹ̃ꞌdị́ vé rĩ pi áyú tã ũnjí ꞌozú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Á lẽ fií tã ĩmi ní rií ụ̃sụ̃ụ́ ꞌdĩri agá ku, á lẽ fií tã ĩmi ní ĩmi úmú rií átá ꞌdĩri agá ku, ãꞌdiãtãsĩyã ĩmivé ẹ́sị́ ũká ũká rĩ sĩ, ĩmi úꞌdị́kí ꞌbá rĩ pi ũdrãá rá, ãzini ĩmi úlị́kí tị́ ãgõ rĩ pi vé ị́sụ́bãá pá gá rĩ pi tã ã pá ãkó. ");
INSERT INTO kbo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Jĩkó ĩmivé rĩ ã tã sĩ, á tri ĩmi gí, ãꞌdiãtãsĩyã ĩmî ẹ́sị́ ũká ũká, ꞌa vengárá ĩmivé rĩ ã tã sĩ, á tri ĩmi gí, ãꞌdiãtãsĩyã ĩmi ũmbá rú! Ma ímụ́ ĩmi íré mụ adri úyú Yõkóbũ vé rĩ pi ãsámvú gé, ãzini ma ímụ́ ĩmi íré mụ adri sụ́rụ́ Ĩsẽrélẽ vé rĩ pi ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yụ́dã, mí ẹ́drị́pị́ị ímụ́ mi íngú rá, mi ímụ́ mívé ariꞌba rĩ pi ã ụ́lẹ́lẹ́ rụ ínjí rá, mí ẹ́drị́pị́ị ímụ́ kũmũcí ũtị̃ mí ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Á Yụ́dã mâ mvá rĩ, mí adri sụ̃ kẹ̃mị̃rọ́ mvá ímvípi zãá nyangárá gálésĩla rĩ tị́nị. Mí adri sụ̃ kẹ̃mị̃rọ́ ọ̃vụ̃ụ́pi laápi vũgá rĩ tị́nị. Mí adri sụ̃ kẹ̃mị̃rọ́ ũkú tị́nị, ãꞌdi ri ícó mi aru ụ́ꞌdụ́ gélésĩ nĩ? ");
INSERT INTO kbo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ĩmi ꞌbá Yụ́dã vé rĩ pi, ꞌbá ãzi ícó túré ãmbũgũ vé rĩ ꞌdụụ́ ĩmi drị́gé sĩ ku, ꞌbá ãzi ícó kpá túré ãmbũgũ vé rĩ ꞌdụụ́ úyú mívé rĩ pi drị́gé sĩ ku, cĩmgbá cazú sâ ꞌbá ímụ́pi túré rĩ rụụ́pi rĩ vé rĩ gé, ꞌbá ãngũ rĩ pi agásĩ rĩ pi céré ĩri ị̃njị̃. ");
INSERT INTO kbo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yụ́dã, mi ímụ́ mívé dõngí ꞌyĩ pẹtị vị́nyọ̃ vé rĩ ã rụ́ꞌbá gá, mi ímụ́ mívé dõngí mbaápi úꞌdí rú rĩ ꞌyĩ pẹtị vị́nyọ̃ vé múké rĩ ã rụ́ꞌbá gá, mi mívé bõngó ũjĩ vị́nyọ̃ rĩ vé sụ́ sĩ, mi mívé bõngó ũjĩ vị́nyọ̃ kaápi ãrí rú rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mî mị ri ímụ́ ka ku ikamgbiri vị́nyọ̃ rĩ ã sụ́ sĩ, Mî sị́ ri ímụ́ mve ku imvesírílí, lé sụ́ rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Jẽbũlúnã, mi adri yị̃ị́ tafu ã gãrã gá, ãngũ mívé rĩ ímụ́ adri vũrã múké kũlúmgba ambugu rĩ pi ní pá tuzú ni, mívé ãngũ rĩ vé lõkókõrí ri ímụ́ ꞌi útrú ca ãngũ Sĩdónã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ĩsãkárã, mi adri sụ̃ dõngí ũkpõ be laápi ãndẽ vuúpi jũrú ị̃rị̃ rĩ pi ãsámvú gé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mí kãdõ ndreé mi ri uvu vũrã múké ni gé, vũrã rĩ mí ní ãyĩkõ sẽ, mi ẹ̃zị́ nga ũkpõ sĩ, ꞌbá rĩ pi mi ꞌbã ẹ̃zị́ nga tụ́gẹ̃rị̃ rú. ");
INSERT INTO kbo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dánã, mi ímụ́ adri sụ́rụ́ Ĩsẽrélẽ rĩ pi vé rĩ ãzi, mi ímụ́ ꞌbá mívé rĩ pi vé tã lị pịrị. ");
INSERT INTO kbo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dánã, mi adri ọ̃jọ́gọ́ ọ̃jọ́gọ́ sụ̃ ị̃nị̃ riípi adriípi lẹ́tị gãrã gá rĩ tị́nị, mi adri sụ̃ ꞌbóro riípi adriípi lẹ́tị gãrã gá, riípi hũsánĩ ã pá ugaápi, ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi ã uꞌdekí rí ãní vũgá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Á Úpí Múngú, á ꞌbã ẹ́sị́ mí drị̃gé, mî pa rí ma! ");
INSERT INTO kbo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gádĩ, ꞌbá rĩ pi ímụ́ ẹ̃ꞌdị́ ꞌdị mí be, ꞌbo mi ímụ́ ẹ̃ꞌdị́ ꞌdị ꞌbá ímụ́ꞌbá ẹ̃ꞌdị́ ꞌdịꞌbá mí be rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ãsérã, mi ímụ́ ínyá múké ni nya, mi ímụ́ ínyá ẹ̃jị́ be múké ꞌbãgú ní rií nyaá rĩ nya. ");
INSERT INTO kbo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nãfãtálĩ, mi ímụ́ adri sụ̃ nyámáta ẹ́cị́pi ásé agásĩ, anji tịị́pi ũnyĩ be rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yõsépã, mi ímụ́ anji tị ízú sụ̃ pẹtị vị́nyọ̃ vé rĩ ní ꞌaá rĩ tị́nị, mi anji tị ízú sụ̃ pẹtị vị́nyọ̃ vé yị̃ị́ gãrã gá rĩ ní ꞌaá rĩ tị́nị, vị́nyọ̃ drị́tị be ĩgãrãápi, tụụ́pi ãbi drị̃gé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yõsépã, ariꞌba rĩ pi ꞌdịkí ẹ̃ꞌdị́ mi be ũnjí ũnjí, kộpi úꞌbúkí íꞌyé ĩvé rĩ pi mụzú mí vúgá ꞌdãá, kộpi ꞌokí mi ũnjí. ");
INSERT INTO kbo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ꞌBo ꞌí njõ mívé ụ̃sụ̃ kú ị́nọ́gọ́sị́, mî drị́ ũrõ kuyé Múngú Yõkóbũ vé rĩ vé ũkpõ sĩ, Múngú riípi ãngũ úcépi rĩ vé ũkpõ sĩ, ꞌbá Ĩsẽrélẽ vé rĩ pi vé Múngú adriípi írã rú rĩ vé ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Múngú mí ẹ́tẹ́pị vé rĩ ko mî ĩzã nĩ, Múngú Ũkpõ ꞌDị́pa sẽ mí ní yị̃ị́gọ́ tãkíri rú íngázú ꞌbụ̃ gélésĩ nĩ, sẽ mí ní yị̃ị́ tãkíri rú vũ drị̃gé nõgó nĩ, sẽ mí ní tãkíri anji tịzú nĩ. ");
INSERT INTO kbo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mâ mvá rĩ, tãkíri má ní sẽé mí ní ꞌdĩri, ndẽ tãkíri ĩ ní ị́sụ́ írã adriípi mụzú ꞌdániꞌdáni rĩ agá rĩ rá, ãzini ánga adriípi mụzú ꞌdániꞌdáni rĩ agá rĩ rá. Yõsépã, lẽ tãkíri ꞌdĩri ã adri mí drị̃gé, mi adri ãmbúgú mí ẹ́drị́pị́ị ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bẹ̃nyẹ̃mị́nẹ̃, mí adri sụ̃ ãrãkílaŋá ẹ́sị́ be ũká ũká, ụ̃ꞌbụ́tịŋá sĩ ãnyãpá rĩ pi úcípi nyaápi, ũndréŋá sĩ zãá ni acoópi sẽépi ꞌî ọ̃gụ̃pị́ị ní rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Anji mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée ímụ́ adri ẹ́ꞌbị́pị́ị sụ́rụ́ mụdrị́ drị̃ ni ị̃rị̃ ꞌbá Ĩsẽrélẽ vé rĩ pi vé ni. Yõkóbũ ní rizú kộpi ní tãkíri sẽzú rĩ gé, ri átángá rĩ átá mụzú ꞌdíni, sẽ tãkíri ꞌbá ãlu ãlu ní tã ꞌbá rĩ ní ꞌoó rĩ vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kúru Yõkóbũ ní tã ẹzịzú ꞌí ẹnjịpị́ị ní kĩnĩ, “Ẹ̃sị̃ mãdã, ma drãdrã. Á drã dõ gí, ĩmi jịkí mávé ãvũ mụụ́ sị̃ị́ má ẹ́ꞌbị́pị́ị ã gãrã gá, ụ̃jị́ ĩ ní rizú ãvũ sị̃zú rĩ agá, ụ̃jị́ rĩ Ẽfõrónã Hị́tị̃gú rĩ vé nyọ̃ọ́kụ́ agá, ");
INSERT INTO kbo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ụ̃jị́ rĩ Mãkãpélã gá, ĩnyiŋá Mãmúrẽ be, ãngũ Kãnánã vé rĩ agá. Ãbũrámã je vũrã rĩ rizú ãvũ sị̃zú ãní, je Ẽfõrónã Hị́tị̃gú rĩ drị́gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Sị̃kí Ãbũrámã pi ũkú ni Sárã be vũrã ꞌdãri gé, sị̃kí kpá Ĩsákã pi ũkú ni Rẽbékã be vũrã ꞌdãri gé, á sị̃ Léyã ri vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Má ẹ́ꞌbị́pị Ãbũrámã je nyọ̃ọ́kụ́ rĩ ụ̃jị́ rĩ be ꞌbá Hị́tị̃ vé rĩ pi drị́gé.” ");
INSERT INTO kbo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yõkóbũ kã tã rĩ ẹzịị́ dẹẹ́ ẹnjịpị́ị ní gí, ĩri ní lazú ívé gbọ́lọ́ drị̃gé, ĩri ní kúru drãzú. ");
INSERT INTO kbo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yõsépã ní ọ̃vụ̃zú ẹ́tẹ́pị ri uꞌdezú bẹ̃drị̃ sĩ, ĩri ní íꞌdózú ngozú ĩzãngã ĩzãngã rú, ĩri ní ẹ́tẹ́pị ã gbángírí ndruzú. ");
INSERT INTO kbo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yõsépã ní ꞌyozú ívé ꞌbá riꞌbá ẹ̃zị́ dáwã vé rĩ ngaꞌbá rĩ pi ní, lẽ kộpi ã njõkí ꞌí ẹ́tẹ́pị Ĩsẽrélẽ vé ãvũ dáwã ãvũ ní ŋmazú ku rĩ sĩ. Kúru ꞌbá dáwã njõꞌbá rĩ pi ní ãvũ rĩ ã rụ́ꞌbá njõzú dáwã rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dáwã rĩ vé njõngárá ꞌdụ ụ́ꞌdụ́ pụ̃kụ́ sụ, ãꞌdiãtãsĩyã ãrẽni dáwã rĩ vé njõngárá ĩri ụ́ꞌdụ́ ꞌdụ ꞌdĩri tị́nị. ꞌBá Ẽjẽpétõ vé rĩ pi ngokí Yõkóbũ ri caá ụ́ꞌdụ́ pụ̃kụ́ ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ụ́ꞌdụ́ ãvũ ngozú rĩ kã dẹẹ́, Yõsépã ní ꞌyozú ũgalaku ꞌbãgú rĩ vé rĩ pi ní kĩnĩ, “Lẽ ĩmi ꞌbãkí ẹ́sị́ múké má ní, lẽ ĩmi ꞌyokí ꞌbãgú rĩ ní ꞌdíni, ");
INSERT INTO kbo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","má ẹ́tẹ́pị sẽ ma ũyõ sõó ꞌí ẹndrẹtị gé, ꞌyo má ní kĩnĩ, ‘Ma ri drãdrã, á drã dõ gí, ꞌí jị ma mụụ́ sị̃ị́ ꞌbụ́ má ní gaá mâ úlúngu ní ãngũ Kãnánã vé rĩ agá ꞌdãá.’ Lẽ ꞌbãgú rĩ ọyụ ma, mâ jị má ẹ́tẹ́pị ri mụụ́ sị̃ị́. Á sị̃ dõ ĩri gí, ma ma újá ĩgõ rá.” ");
INSERT INTO kbo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ꞌBãgú rĩ ãꞌyĩ tã Yõsépã ní zịị́ rĩ rá, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ jị mí ẹ́tẹ́pị ri mụụ́ sị̃ị́ ĩyí, sụ̃ ĩri ní mi sẽé ũyõ sõó ꞌí ẹndrẹtị gé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kúru Yõsépã ní ꞌdezú mụzú ẹ́tẹ́pị ri sị̃zú. ꞌBãgú rĩ vé ũgalaku rĩ pi, ꞌbá ambugu ꞌbãgú rĩ vé kání agá rĩ pi, ãzini ꞌbá ambugu ãngũ Ẽjẽpétõ vé rĩ agá rĩ pi, kộpi ꞌdekí mụụ́ Yõsépã vúgá sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yõsépã jị ꞌbá ívé ꞌbẹ̃tị́ ãsámvú gé rĩ pi, ꞌí ẹ́drị́pị́ị be, ꞌbá adriꞌbá ẹ́tẹ́pị vé jó ãsámvú gé rĩ pi be mụzú ĩndĩ. Ku anjiŋá rĩ pi, kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi be kú vúlé Gõsénĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ãngáráwá rĩ pi útụ́kí ãrãbíyã hũsánĩ ní rií seé rĩ pi agá, ụrụkọꞌbée útụ́kí hũsánĩ drị̃gé, kộpi ꞌdekí mụụ́ Yõsépã vúgá sĩ ĩndĩ. ꞌBá mụꞌbá rĩ pi kárákará. ");
INSERT INTO kbo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kộpi kâ mụụ́ caá Ãtádĩ gé, vũrã ĩ ní rizú ãnyãngã fífí cozú ĩnyiŋá yị̃ị́ Yárídénĩ ã gãrã gá rĩ gé, kộpi íꞌdókí rií ãá ngoó ĩzãngã ĩzãngã rú, kộpi ẹ́sị́ ŋõ ambamba, Yõsépã ꞌbã ẹ́tẹ́pị vé ãá ngoó ụ́ꞌdụ́ ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ꞌBá Kãnánã vé rĩ pi kâ ndreé kộpi ri ãá ngo vũrã ãnyãngã fífí cozú rĩ gé Ãtádĩ gé ꞌdãá, kộpi ní ꞌyozú kínĩ, “ꞌBá Ẽjẽpétõ vé rĩ pi ri ãá rĩ ngo ĩzãngã ĩzãngã rú nĩ.” Sẽ ĩ ní vũrã Yárídénĩ ã jẽlé gá ꞌdãri ã rụ́ zịzú Ẽbélẽ Mĩzĩrãyímũ ãní. ");
INSERT INTO kbo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yõkóbũ vé anji ãgõ rĩ pi ꞌdụkí tã rĩ ngaá sụ̃ ĩ ẹ́tẹ́pị ní ẹzịị́ ĩ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kộpi ꞌdụkí ĩrivé ãvũ jịị́ mụzú Kãnánã gá, kộpi sị̃kí ĩri ụ̃jị́ adriípi nyọ̃ọ́kụ́ Mãkãpélã vé rĩ agá, ĩnyiŋá Mãmúrẽ be, nyọ̃ọ́kụ́ rĩ Ãbũrámã je Ẽfõrónã Hị́tị̃gú rĩ drị́gé rizú ãvũ sị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yõsépã kã ẹ́tẹ́pị ri sị̃ị́ gí, ĩri ní ꞌi újázú gõzú vúlé Ẽjẽpétõ gá ꞌdãá, kộpi újákí ĩ gõó ẹ́drị́pị́ị be, ꞌbá mụꞌbá vú ni gé sĩ ẹ́tẹ́pị ri sị̃ngárá gá rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yõkóbũ ní drãá gí rĩ sĩ, Yõsépã ẹ́drị́pị́ị gõkí adrií ụ̃rị̃ sĩ, kộpi ní ꞌyozú kínĩ, “Yõsépã ꞌbã dõ tã ꞌbá ní ọ́tụ́ ꞌi ꞌozú ũnjí ꞌdãri ꞌí ẹ́sị́ agá, ũfẽ dõ tã rĩ ãrígó, ꞌo dõ ꞌbâ ũnjí, ꞌbâ ꞌokí rí íngóni?” ");
INSERT INTO kbo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kúru kộpi ní ụ́ꞌdụ́kọ́ pẽzú mụzú Yõsépã ní, kộpi kínĩ, “Mí ẹ́tẹ́pị ní drĩ drãzú kuyé rĩ gé, ẹzị ꞌdíni kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ĩmi lũkí Yõsépã ní ꞌdíni, lẽ mî trũ mí ẹ́drị́pị́ị ũnjĩkãnyã kộpi ní mi ꞌozú ũnjí ꞌdĩri agásĩ rá.’ ꞌBâ ãtíꞌbá Múngú mí ẹ́tẹ́pị vé rĩ vé ni, lẽ mî trũ ꞌbâ ũnjĩkãnyã ꞌbá ní ꞌoó mí ní rĩ agásĩ rá.” Ụ́ꞌdụ́kọ́ rĩ kã caá Yõsépã vúgá ꞌdãá, Yõsépã ní íꞌdózú ngozú. ");
INSERT INTO kbo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kúru Yõsépã ẹ́drị́pị́ị ní ímụ́zú kũmũcí ũtị̃zú ĩ drị̃ sị̃zú vũgá Yõsépã ẹndrẹtị gé. Kộpi ní ꞌyozú kínĩ, “ꞌBâ tụ́gẹ̃rị̃ mívé ni.” ");
INSERT INTO kbo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yõsépã ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adrikí ụ̃rị̃ sĩ ku. Ĩmi ụ̃sụ̃kí ma Múngú ꞌi ícópi ĩmi ĩrĩŋãápi? ");
INSERT INTO kbo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ĩmi lẽkí kõdô ma ꞌoó ũnjí, ꞌbo Múngú újá tã ũnjí ĩmi ní lẽé ꞌoó mâ rụ́ꞌbá gá rĩ ícá tã múké rú, tã ꞌi ngaápi nõri, ã nga rí ꞌi fũú tị ni gé bẽnĩ, mâ pa rí ꞌbá kárákará pi vé ídri. ");
INSERT INTO kbo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Lẽ ĩmi ꞌokí ụ̃rị̃ sĩ ku, ma ngá ĩmi ní lẽé rĩ pi sẽ ĩmi ní rá, ãzini ma ngá ĩmivé anjiŋá rĩ pi ní lẽé rĩ sẽ kộpi ní rá.” Yõsépã ũmĩ ẹ́drị́pị́ị ẽ ẹ́sị́, átá átángá rĩ ẹ́sị́ be mãdã, sẽ kộpi ẽ ẹ́sị́ adri ãní ãyĩkõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yõsépã pi rikí adrií ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá ꞌí ẹ́tẹ́pị vé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be trụ́. Yõsépã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu mụdrị́ (110). ");
INSERT INTO kbo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yõsépã adri ílí be ãco, ndre Ẽfẽrémã vé anji ĩ ní tịị́ úyú na gá rĩ pi rá. Ndre kpá anji Mákĩrĩ vé rĩ pi rá. Mákĩrĩ ri mvá Mãnásẽ vé ni, Yõsépã ꞌdụ anji Mákĩrĩ vé rĩ pi adrií anji ívé ni rú. ");
INSERT INTO kbo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yõsépã ní ꞌyozú ẹ́drị́pị́ị ní kĩnĩ, “Ma ri drãdrã. ꞌBo Múngú ri ímụ́ ĩmi tã mba rá, ĩri ĩmi jị fũ ãngũ Ẽjẽpétõ vé nõri agásĩ, ĩri ĩmî drị̃ ko mụzú ãngũ ĩri ní ẹzịị́ Ãbũrámã ní, Ĩsákã ní, ãzini Yõkóbũ ní rĩ agá ꞌdãlé rá.” ");
INSERT INTO kbo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kúru Yõsépã ní Ĩsẽrélẽ ẹnjịpị́ị sẽzú ũyõ sõzú ꞌí ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Múngú kãdõ ímụ́ ĩmi ĩzã koó, ĩmî drị̃ koó mụzú vúlé ꞌdãá, ĩmi jịkí mávé fã mụzú ĩndĩ.” ");
INSERT INTO kbo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yõsépã ní kúru drãzú Ẽjẽpétõ gá ꞌdãlé, ị́sụ́ ãkũdẽ ĩri ílí be mụ̃dụ̃rụ̃lụ̃ ãlu mụdrị́. Kộpi ní ĩrivé ãvũ njõzú dáwã ãvũ ní ŋmazú ku rĩ sĩ, kộpi ní ãvũ rĩ ꞌbãzú sọ̃ndụ́kụ̃ agá.");
INSERT INTO kbo_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yõkóbũ ĩ ní zịị́ Ĩsẽrélẽ rĩ vé anji ãgõ mụꞌbá ĩri be Ẽjẽpétõ gá ꞌdãlé rĩ pi, ꞌbá ãlu ãlu mụ ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi be, kộpivé rụ́ pi ꞌdĩ: ");
INSERT INTO kbo_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rũbénã ꞌi, Sĩmĩyónã ꞌi, Lẹ́vị̃ ꞌi, Yụ́dã ꞌi, ");
INSERT INTO kbo_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ĩsãkárã ꞌi, Jẽbũlúnã ꞌi, Bẹ̃nyẹ̃mị́nẹ̃ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dánã ꞌi, Nãfãtálĩ ꞌi, Gádĩ ꞌi, Ãsérã sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yõkóbũ vé úyú mụꞌbá rĩ pi vé kãlãfe céré pụ̃kụ́ ẹ́zị̂rị̃. Kộpi cakí Yõsépã ri ị́sụ́ ãkũdẽ ĩri ri adri Ẽjẽpétõ gá ꞌdãáꞌdã. ");
INSERT INTO kbo_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yõsépã pi ũdrãkí ẹ́drị́pị́ị be céré, úyú lókí ꞌdãri gé rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ꞌBo ꞌbá Ĩsẽrélẽ vé rĩ pi ízúkí kárákará ãngũ ꞌdãri gé, kộpi ícákí ũkpõ be ambamba, kộpi gõkí gaá tré ãngũ Ẽjẽpétõ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kúru ꞌbãgú úꞌdí Yõsépã vé tã nị̃ị́pi kuyé ni ní gõzú mãlũngã Ẽjẽpétõ vé rĩ rụzú nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ĩri ní ꞌyozú ívé ꞌbá rĩ pi ní kĩnĩ, “Ĩmi ndrekí drĩ ká, ꞌbá Ĩsẽrélẽ vé rĩ pi ízúkí nóni ambamba, kộpi ndẽkí ꞌbâ ũkpõ sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ĩmi ímụ́kí, ꞌbâ ndãkí lẹ́tị kộpi ugazú, kộpi ẽ ízúkí rí kárákará ku, ãꞌdiãtãsĩyã ẹ̃ꞌdị́ ꞌde dõ nĩ, kộpi ímụ́ ĩ úmú ꞌbávé ariꞌba rĩ pi be, kộpi ímụ́ ẹ̃ꞌdị́ ꞌdị ꞌbá be, kộpi ímụ́ ápá fũ ãngũ nõri agásĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kúru ꞌbá ambugu Ẽjẽpétõ vé rĩ pi ꞌdụkí ꞌbá Ĩsẽrélẽ vé rĩ pi ꞌbãá kuú tụ́gẹ̃rị̃ rú, kộpi ũꞌbãkí ꞌbá Ẽjẽpétõ vé rĩ pi ꞌbá Ĩsẽrélẽ vé rĩ pi drị̃gé ꞌbá ambugu rú, mĩkí kộpi rií ẹ̃zị́ ũkpó ũkpó ni pi ngaá. Tụ́gẹ̃rị̃ rĩ pi sịkí jó ambugu ambugu ĩrá rú ni pi kụ̃rụ́ Pĩtómĩ vé rĩ agá, ãzini Rãmãsésẽ vé rĩ agá ꞌbãgú Ẽjẽpétõ vé rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ꞌBo ã rikí dõ ꞌbá Ĩsẽrélẽ vé rĩ pi ọ̃cụ̃ụ́ mụzú ꞌdíni drãáãsĩyã, kộpi rikí ízú mụzú drị̃gélé, kộpi írékí ĩ adrií ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ꞌBá Ẽjẽpétõ vé rĩ pi gõkí ꞌoó kộpi sĩ ụ̃rị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mĩkí kộpi rií ẹ̃zị́ ũkpó ũkpó ni pi ngaá. ");
INSERT INTO kbo_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Mĩkí kộpi rií ũtrẽtrẽ usaá gbãá bị̃rị́kị̃ rú, ãzini rií ẹ̃zị́ ngaá lẹ́tị be ãndíãndí ọ́mvụ́ rĩ pi agásĩ, sẽ ꞌbá Ĩsẽrélẽ vé rĩ pi adrikí céré kuú ãní ĩzãngã ĩzãngã rú. ");
INSERT INTO kbo_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ꞌBãgú Ẽjẽpétõ vé rĩ ní Sĩpúrã pi zịzú Púwã be, ũkú ꞌdĩꞌbée ri ũkú Ẽbérẽ vé tĩꞌbá tĩtĩ rĩ pi ẽ ĩzã ko tĩngárá rĩ gé nĩ, ĩri ní ꞌyozú kộpi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ĩmi dõ ri ũkú Ẽbérẽ vé rĩ pi ẽ ĩzã ko anji tĩngárá gá, sâ kộpi ní rizú anji tĩzú rĩ gé, ĩmi ndrekí dõ mváŋá rĩ ágóŋá, ĩmi ꞌdịkí ĩri drãá ꞌdĩísĩ rá, dõ mváŋá rĩ ũkúŋá, ĩmi kukí ã adri ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ꞌBo ũkú riꞌbá ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koꞌbá tĩngárá sĩ ꞌdĩꞌbée ní Múngú ri ị̃njị̃ị́ ị̃njị̃ rĩ sĩ, kộpi ꞌdụkí tã ꞌbãgú Ẽjẽpétõ vé rĩ ní ꞌyoó ĩ ní ꞌdĩri ẹ̃zị́ ngazú kuyé, kộpi úꞌdị́kí anji ãgõ rĩ pi ũdrãá kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kúru ꞌbãgú Ẽjẽpétõ vé rĩ ní ũkú ꞌdĩꞌbée zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌokí ꞌdíni ãsĩ? Ĩmi kukí anji ãgõŋá rĩ pi ídri rú, ĩmi úꞌdị́kí kộpi kuyé ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ũkú riꞌbá ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koꞌbá tĩngárá sĩ ꞌdĩꞌbée ní újázú ꞌbãgú rĩ ní kínĩ, “Ũkú Ẽbérẽ vé rĩ pi adrikí sụ̃ụ́ ũkú Ẽjẽpétõ vé rĩ pi tị́nị ku. Kộpi ĩvé anjiŋá pi tĩ ĩfũ mbẽlẽŋá. ꞌBá kãdõ caá, ꞌbâ ị́sụ́ ãkũdẽ kộpi tĩkí gí.” ");
INSERT INTO kbo_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Múngú ꞌbã ẹ́sị́ múké ũkú riꞌbá ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koꞌbá tĩngárá sĩ rĩ pi ní, sẽ Ĩsẽrélẽ rĩ pi gõkí ízú mụzú drị̃gélé. ");
INSERT INTO kbo_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ũkú riꞌbá ũkú anji tĩꞌbá rĩ pi ẽ ĩzã koꞌbá rĩ pi ní Múngú ri ị̃njị̃ị́ ị̃njị̃ rĩ sĩ, Múngú sẽ kộpi tịkí anjiŋá rá. ");
INSERT INTO kbo_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ꞌBãgú rĩ ní gõzú tãị́mbị́ sẽzú ívé ꞌbá rĩ pi ní kĩnĩ, “Ĩmi úꞌbékí anji ãgõŋá Ẽbérẽ ũkú rĩ pi ní tịị́ rĩ pi céré yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá, ꞌbo ĩmi kukí anji ũkúŋá rĩ pi ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lókí ꞌdãri gé, ágó ãzi sụ́rụ́ Lẹ́vị̃ vé rĩ agá, je ũkú sụ́rụ́ ívé rĩ agá ũgõgõ. ");
INSERT INTO kbo_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ũkú rĩ ní ꞌa ị́sụ́zú, ĩri ní mváŋá rĩ tịzú ágóŋá. Kã ndreé mváŋá rĩ ũnyĩ be ambamba, ũzụ̃ mváŋá rĩ caá mbãá be na. ");
INSERT INTO kbo_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ꞌBo kã ámá tí, ꞌí ícó mváŋá rĩ ũzụ̃ụ́ bã ku, ĩri ní wụ̃rụ̃gụ̃ íꞌdụ́zú, ĩri ní rụ́ꞌbá ni ũmbĩzú ngá ụ̃drị rú ni sĩ. Ĩri ní mváŋá rĩ ꞌbãzú wụ̃rụ̃gụ̃ rĩ agá, ĩri ní jịzú zụ̃zú yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ jẽlé gá, lómí agá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mváŋá rĩ vé ọ́mvụ́pị mụ ꞌi zụ̃ụ́ rárá rú, tẽ rí ndreé, dõ tã ngóni ri ímụ́ ꞌi nga mváŋá rĩ rụ́ꞌbá gá nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kúru ꞌbãgú Ẽjẽpétõ vé rĩ vé mvá ũkú rĩ ní ꞌdezú mụzú ꞌi jĩngárá gá yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá ꞌdãlé, mvá ũkú rĩ kâ caá yị̃ị́ gé ꞌdãá, ĩrivé tụ́gẹ̃rị̃ ũkú rú rĩ pi ri ẹ́cị́ yị̃ị́ rĩ ã gãrã gá sĩ. ꞌBãgú rĩ vé mvá ũkú rĩ ní wụ̃rụ̃gụ̃ rĩ ndrezú, ĩri ní ívé tụ́gẹ̃rị̃zị́ ãlu pẽzú mụzú wụ̃rụ̃gụ̃ rĩ íꞌdụ́zú. ");
INSERT INTO kbo_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ꞌBãgú rĩ vé mvá ũkú rĩ ní wụ̃rụ̃gụ̃ rĩ ẽ tị zị̃zú, ĩri ní mvá ágóŋá rĩ ndrezú wụ̃rụ̃gụ̃ rĩ agá ꞌdãá, ĩri ri ngongo. Sẽ mvá ũkú rĩ ní ĩzãngã, ĩri ní ꞌyozú kĩnĩ, “Mváŋá nõri Ẽbérẽ rĩ pi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kúru mváŋá rĩ vé ọ́mvụ́pị ní ĩri zịzú kĩnĩ, “Mí ãꞌyĩ rá mâ mụ mí ní ũkú Ẽbérẽ vé ni bĩí, ã jị rí mí ní mváŋá rĩ úcé?” ");
INSERT INTO kbo_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ꞌBãgú rĩ vé mvá ũkú rĩ ní ꞌyozú kĩnĩ “ꞌÍ mụ bĩí.” Kúru mváŋá rĩ vé ọ́mvụ́pị ní mụzú mváŋá rĩ vé ẹ́ndrẹ́pị ĩri tịị́pi rĩ bĩzú ímụ́zú. ");
INSERT INTO kbo_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mváŋá rĩ vé ẹ́ndrẹ́pị kã ícá ꞌbãgú rĩ vé mvá ũkú rĩ vúgá nõlé, mvá ũkú rĩ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ jị má ní mváŋá nõri úcé, mváŋá rĩ ku dõ bã gí, mí íjị́ ĩri ĩgõó má vú nõlé, ma ímụ́ mi ũfẽ rá.” Mváŋá rĩ vé ẹ́ndrẹ́pị ní kúru mváŋá rĩ jịzú úcézú. ");
INSERT INTO kbo_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mváŋá rĩ kã mbaá ícá ãmbúgú gí, ẹ́ndrẹ́pị ní ĩri jịzú gõzú ꞌbãgú rĩ vé mvá ũkú rĩ vúgá ꞌdãlé. Mvá ũkú rĩ ní mváŋá rĩ ꞌdụzú ꞌí ní mvá ágóŋá rú. Ĩri ní rụ́ ni ꞌdazú Mósẽ ꞌi, kĩnĩ, “Má ísé ĩri yị̃ị́ agálésĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mósẽ kã mbaá ícá ãmbúgú gí, ụ́ꞌdụ́ ãlu, ꞌde mụụ́ ívé ꞌbá Ẽbérẽ vé rĩ pi úndré, ca ị́sụ́ ꞌbá rĩ pi ri ẹ̃zị́ ũkpó ũkpó ni pi nga. Ĩri ní Ẽjẽpétõgú ndrezú, ĩri ri ívé ꞌbá Ẽbérẽ vé ni ũgbã. ");
INSERT INTO kbo_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mósẽ ní ãngũ úndrézú ꞌí gãrã gá sĩ kụ́rụ̃, ndre ꞌbá ãzi ꞌí gãrã gá ꞌdãáyo, ĩri ní Ẽjẽpétõgú rĩ ꞌdịzú drãzú, ĩri ní cínyáfã kụ̃zú drị̃ ni gé. ");
INSERT INTO kbo_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kã mụụ́ caá drụ̃ ꞌdíni, Mósẽ gõ mụụ́ ívé ꞌbá rĩ pi ndreé. Kã caá ꞌdãlé, ị́sụ́ kpá ꞌbá ị̃rị̃ Ẽbérẽ vé ni pi ri ũmbã fụ ĩ drị̃kã sĩ. Mósẽ ní ꞌyozú ágó tã ã ndụ́ íꞌdópi rĩ ní kĩnĩ, “Mi ri mí ọ́gụ́pị ri fụ ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ágó tã rĩ ã ndụ́ íꞌdópi rĩ ní ꞌyozú kĩnĩ, “Ãꞌdi ꞌbã mi ãmbúgú rú rií ꞌbávé tã lịị́ nĩ? ꞌÍ lẽ ma ꞌdịị́ sụ̃ mí ní Ẽjẽpétõgú rĩ ꞌdịị́ drãá rĩ tị́nị?” Tã ꞌdĩri sẽ Mósẽ ní ụ̃rị̃ ambamba. Ĩri ní ụ̃sụ̃zú ẹ́sị́sị́lé sĩ kĩnĩ, “Tã má ní ꞌoó rĩ ꞌbá rĩ pi nị̃kí gí.” ");
INSERT INTO kbo_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ꞌBãgú Ẽjẽpétõ vé rĩ kã tã ꞌdĩri yịị́, lẽ kõdô lẹ́tị ndãá Mósẽ ri ꞌdịzú drãzú rá. ꞌBo ị́sụ́ Mósẽ nga ápá mụụ́ adrií rárá rú Mĩdĩyánã gá gí, Mósẽ kã caá Mĩdĩyánã gá ꞌdãlé, mụ úrí kuú kídí tị gé. ");
INSERT INTO kbo_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Átálágú ãzi Mĩdĩyánã vé ni, rụ́ ni Yétẽrõ ꞌi, ĩri anji ũkú be ẹ́zị̂rị̃. Anji ũkú ꞌdĩꞌbée jịkí ĩrivé ndrị̃ị́ rĩ pi kãbĩlõ rĩ pi be mụụ́ yị̃ị́ mvụụ́. ");
INSERT INTO kbo_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ꞌBá ụrụkọ ndrị̃ị́ úcéꞌbá ni pi ícákí ímụ́ kộpi údró yị̃ị́ rĩ tị gé sĩ ꞌdĩísĩ rá. ꞌBo Mósẽ ní ngazú ụrụ, ĩri ní anji ũkú ꞌdĩꞌbée ẹ́rị́zú, ĩri ní yị̃ị́ sẽzú mvụzú kộpivé ndrị̃ị́ rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Anji ũkú rĩ pi kâ mvií caá ĩ ẹ́tẹ́pị Rẽúlẽ vúgá ꞌdãlé, ĩri ní kộpi zịzú kĩnĩ, “Ĩmi ímvíkí ãndrũ ị́nọ́gọ́sị́ ꞌdíni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kộpi ní újázú ĩri ní kínĩ, “ꞌBá ị́sụ́kí Ẽjẽpétõgú ãzi kídí rĩ tị gé ꞌdãlé, pa ꞌbâ ꞌbá ndrị̃ị́ úcéꞌbá rĩ pi drị́gé sĩ, ĩbẽ yị̃ị́ sẽé mvụụ́ ꞌbávé ndrị̃ị́ rĩ pi ní, ãzini kãbĩlõ rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yétẽrõ ní kộpi zịzú kĩnĩ, “Ĩri íngãá? Ĩmi kukí ĩri ꞌdãlé ãsĩ? Ĩmi gõkí mụụ́ ĩri bĩí, ẽ ímụ́ rí ngá nyaá.” ");
INSERT INTO kbo_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mósẽ ãꞌyĩ adrií Yétẽrõ vé ãngá ꞌdãá rá, Yétẽrõ ní ívé mvá ũkú Sĩpúrã ri sẽzú jezú Mósẽ ní ũkú rú. ");
INSERT INTO kbo_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sĩpúrã ní Mósẽ ní mvá ágó tịzú. Mósẽ ní ꞌyozú kĩnĩ, “Ma jãkã ãngũ nõri gé, ma ĩri ã rụ́ ꞌda Gẽrẽsómã ꞌi.” Ífífí ni jãkã. ");
INSERT INTO kbo_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Vụ́drị̃ ni kã vụ̃ụ́ ílí be ãco, ꞌbãgú Ẽjẽpétõ vé rĩ ní drãzú. ꞌBo rikí nyo ꞌbá Ĩsẽrélẽ vé rĩ pi ọ̃cụ̃ụ́ mụzú drị̃gélé. ꞌBá Ĩsẽrélẽ vé rĩ pi rikí ngoó Múngú ẹndrẹtị gé, Múngú ã ko rí ĩ ĩzã bẽnĩ. Kộpivé ngongárá ca Múngú vúgá ꞌdãlé rá. ");
INSERT INTO kbo_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Múngú yị kộpivé ngongárá rá, ĩri ní ívé ũndĩ ꞌí ní rụụ́ Ãbũrámã be Ĩsákã be, Yõkóbũ be rĩ ã tã ígázú. ");
INSERT INTO kbo_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Múngú ndre ꞌbá Ĩsẽrélẽ vé rĩ pi vé ĩzãngã rií nya rĩ, tã ni fi ẹ́sị́ ni gé ambamba. ");
INSERT INTO kbo_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ụ́ꞌdụ́ ãlu, Mósẽ ri ẹ́nyẹ́pị Yétẽrõ átálágú Mĩdĩyánã vé rĩ vé kãbĩlõ pi úcé ndrị̃ị́ rĩ pi be, jị ãnyãpá rĩ pi ãngũ ãꞌwí cínyáfã rú rĩ gé, írã Múngú vé rĩ gé Sĩnáyĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mãlãyíkã Úpí Múngú vé rĩ ní ꞌi iꞌdazú Mósẽ ní ãcí dị̃ị́pi pẹtị amuúpi kụ̃mvụ̃ ni agá ꞌdãá. Mósẽ ndre ãcí rĩ ri dị̃ị́ pẹtị amuúpi kụ̃mvụ̃ rĩ agá ꞌdãá, ꞌbo pẹtị rĩ ve kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mósẽ ní ụ̃sụ̃zú kĩnĩ, “Tã ꞌi ꞌoópi ꞌdĩri ụ̃kụ ni á ndre kuyé, á lẽ ma útrú ĩnyiŋá mụụ́ ndreé mâ mị sĩ, ngá sẽépi pẹtị amuúpi kụ̃mvụ̃ rĩ ní vezú ku rĩ ãꞌdi.” ");
INSERT INTO kbo_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Úpí Múngú kã ndreé Mósẽ útrú ꞌi ĩnyiŋá ãcí riípi dị̃ị́pi ꞌdĩri ndreé, Múngú ní Mósẽ ri zịzú pẹtị ãcí ní rií dị̃ị́ ꞌa ni gé rĩ agá ꞌdãá kĩnĩ, “Mósẽ! Mósẽ!” Mósẽ ní ãꞌyĩzú kĩnĩ, “Ma nõ.” ");
INSERT INTO kbo_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Mí ítrú mi ĩnyiŋá nõó ku, ꞌí nje mívé mọ̃rọ̃kụ́ mí pá gá sĩ rá, ãꞌdiãtãsĩyã vũrã mí ní pá tuzú ꞌdĩri vũrã uletere ni.” ");
INSERT INTO kbo_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Úpí Múngú ní ꞌyozú kĩnĩ, “Ma Múngú mí ẹ́ꞌbị́pị́ị vé rĩ, Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, Múngú Yõkóbũ vé rĩ.” Mósẽ ní kúru drị́ ꞌbãzú ꞌî mị ọ̃zụ̃zú ãní cí, ãꞌdiãtãsĩyã ꞌo ụ̃rị̃ sĩ Múngú ẽ ẹndrẹtị ndrengárá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Úpí Múngú ní ꞌyozú kĩnĩ, “Á ndre ĩzãngã mávé ꞌbá rĩ pi ní nyaá Ẽjẽpétõ agá rĩ gí. Á yị kộpivé ngongárá ĩ ní rizú kộpi ọ̃cụ̃zú tụ́gẹ̃rị̃ rĩ vé tã gí, ĩzãngã kộpi ní nyaá rĩ ã tã fi má ẹ́sị́ agá ambamba. ");
INSERT INTO kbo_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kúru má ísị́ ímụ́ kộpi paá ꞌbá Ẽjẽpétõ vé rĩ pi drị́gé sĩ, kộpi íjị́zú ĩfũzú ãmvé ãngũ Ẽjẽpétõ vé rĩ agásĩ, ma kộpi jị mụ ãngũ múké wãlã ni gé, ãngũ ꞌdãri agá, lé anigé, ãzini ọ̃nyụ́ anigé, ãngũ ꞌdãri ꞌbá Kãnánã vé rĩ pi vé ni, ꞌbá Hị́tị̃ vé rĩ pi vé ni, ꞌbá Ãmórã vé rĩ pi vé ni, ꞌbá Pẽrízĩ vé rĩ pi vé ni, ꞌbá Hívĩ vé rĩ pi vé ni, ꞌbá Jẽbúsĩ vé rĩ pi vé ni. ");
INSERT INTO kbo_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Á yị ngongárá ꞌbá Ĩsẽrélẽ vé rĩ pi vé rĩ gí, á ndre ọ̃cụ̃ngárá ꞌbá Ẽjẽpétõ vé rĩ pi ní kộpi ọ̃cụ̃zú rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kúru nóni á lẽ mi pẽé, ꞌí mụ ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãlé, mí íjị́ mávé ꞌbá Ĩsẽrélẽ vé rĩ pi ĩfũú Ẽjẽpétõ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ꞌBo Mósẽ ní ꞌyozú Múngú ní kĩnĩ, “Ma ãꞌdi ꞌi ícópi mụụ́pi ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãá, ꞌbá Ĩsẽrélẽ vé rĩ pi íjị́pi ĩfũúpi Ẽjẽpétõ agásĩ ãmvé?” ");
INSERT INTO kbo_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Múngú ní ꞌyozú kĩnĩ, “Ma adri mí be trụ́. Ngá ícópi iꞌdaápi kínĩ á pẽ mi nĩ rĩ, mí íjị́ dõ ꞌbá rĩ pi ĩfũú Ẽjẽpétõ agásĩ rá, ĩmi ímụ́ ma ị̃njị̃ írã nõri drị̃gé nõgó.” ");
INSERT INTO kbo_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mósẽ ní ꞌyozú Múngú ní kĩnĩ, “Á mụ dõ ꞌyoó ꞌbá Ĩsẽrélẽ vé rĩ pi ní, ‘Múngú ĩmi ẹ́ꞌbị́pị́ị vé rĩ ĩpẽ ma ímụ́zú ĩmi vúgá nõó nĩ,’ kộpi zịkí dõ rụ́ ni ãꞌdi ꞌi, mâ lũ kộpi ní ngóni?” ");
INSERT INTO kbo_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌBÁ RĨ MA ꞌI. ꞌÍ ꞌyo ꞌbá Ĩsẽrélẽ vé rĩ pi ní ꞌdíni. ‘ꞌBÁ RĨ MA ꞌI, ĩpẽ ma ímụ́zú ĩmi vúgá nõó nĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Múngú gõ ꞌyoó Mósẽ ní dị̃ị́ kĩnĩ, “ꞌÍ ꞌyo ꞌbá Ĩsẽrélẽ vé rĩ pi ní, ‘Úpí, Múngú ĩmi ẹ́ꞌbị́pị́ị vé rĩ, Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, Múngú Yõkóbũ vé rĩ ĩpẽ ma ímụ́zú ĩmi vúgá nõó nĩ.’ Rụ́ ꞌdĩri mávé adriípi mụzú ꞌdániꞌdáni rĩ, úyú ĩmi vụ́drị̃ gé rĩ pi céré, kộpi ã rikí mâ rụ́ zịị́ ꞌdíni. ");
INSERT INTO kbo_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“ꞌÍ mụ ambugu Ĩsẽrélẽ vé rĩ pi traá trụ́ vũrã ãlu gé, ꞌí ꞌyo kộpi ní, ‘Úpí Múngú ĩmi ẹ́ꞌbị́pị́ị vé rĩ, Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, Múngú Yõkóbũ vé rĩ iꞌda ꞌi má ní, ĩri ní ꞌyozú kĩnĩ, “Á ꞌbã mị rizú ĩmi ndrezú, á ndre tã ĩ ní ꞌoó ĩmi ní ũnjí Ẽjẽpétõ gá ꞌdĩlé rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ándúrú má ẹzị, má kĩnĩ, ma ĩmi íjị́ ĩfũ ĩzãngã ĩmi ní nyaá ũnjí ũnjí ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá rĩ agásĩ ãmvé, ma ĩmi jị mụ adri ãngũ ꞌbá Kãnánã vé rĩ pi ní adrizú rĩ gé, ꞌbá Hị́tị̃ vé rĩ pi ní adrizú rĩ gé, ꞌbá Ãmórã vé rĩ pi ní adrizú rĩ gé, ꞌbá Pẽrízĩ vé rĩ pi ní adrizú rĩ gé, ꞌbá Hívĩ vé rĩ pi ní adrizú rĩ gé, ãzini ꞌbá Jẽbúsĩ vé rĩ pi ní adrizú rĩ gé. Ãngũ ꞌdãri agá, lé anigé, ãzini ọ̃nyụ́ anigé.” ’ ");
INSERT INTO kbo_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ambugu Ĩsẽrélẽ vé rĩ pi mi yị rá. Kúru ĩmi ꞌdekí mụụ́ ambugu Ĩsẽrélẽ vé rĩ pi be ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãá, ĩmi ꞌyokí ĩri ní, ‘Úpí Múngú Ẽbérẽ rĩ pi vé rĩ iꞌda ꞌi ꞌbá ní rá. Mí ọyụ ꞌbâ ẹ̃cị̃ tuú mụzú ụ́ꞌdụ́ na ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ꞌbâ mụkí rí rọ̃bọ̃ŋọ̃ zãá Úpí Múngú ꞌbávé rĩ ní.’ ");
INSERT INTO kbo_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ꞌBo á nị̃ rá, ꞌbãgú Ẽjẽpétõ vé rĩ ícó ĩmi ãꞌyĩí mụụ́ ku, ꞌbãkí dõ tã ũkpó ũkpó drị̃ ni gé ká. ");
INSERT INTO kbo_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kúru ma mâ drị́ inga ꞌbá Ẽjẽpétõ vé rĩ pi gbãzú ãní, ma tã ãyãzú ãyãyã ni ꞌo ãndíãndí kộpi ãsámvú gé. Vụ́drị̃ ni gé, ĩri ĩmi ọyụ mụzú rá. ");
INSERT INTO kbo_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ma sẽ ꞌbá Ẽjẽpétõ vé rĩ pi ẽ ẹ́sị́ ri adri ĩmi ní múké, ĩmi kádõ fũú mụzú, ĩmi fũkí mụụ́ drị́ be kọ́lọ́mgbọ́ rú ku. ");
INSERT INTO kbo_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ũkú ãlu ãlu Ĩsẽrélẽ vé rĩ ã mụ ngá ĩ ní údé aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni pi sĩ, dábũ sĩ, ãzini bõngó ũnyĩ be ni pi zịị́ ꞌbá ívé jó ã gãrã gá rĩ pi vúgá, ãzini ã zị ꞌbá ívé ꞌbẹ̃tị́ ãsámvú gé rĩ pi vúgá, ĩmi úsúkí rí ĩmivé anji ãgõ rĩ pi, anji ũkú rĩ pi be ãní. Ĩmi kádõ fũú ãngũ Ẽjẽpétõ vé rĩ agásĩ, ĩmi wụ̃kí ngá ꞌdĩꞌbée ãrẽvú céré mụzú ĩndĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kúru Mósẽ ní újázú Úpí Múngú ní kĩnĩ, “ꞌBo ꞌbá Ĩsẽrélẽ vé rĩ pi ãꞌyĩkí dõ ma ku, kộpi yịkí dõ mávé tã ku, ꞌyokí dõ kínĩ mí índré má ẹndrẹtị gé kuyé, mâ ꞌo rí ngóni?” ");
INSERT INTO kbo_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Úpí Múngú ní ĩri zịzú kĩnĩ, “Ngá mí ní rụụ́ mí drị́gé ꞌdĩri ãꞌdi?” Ĩri ní újázú kĩnĩ, “Ngá rĩ túré.” ");
INSERT INTO kbo_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Úpí Múngú ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ ꞌbe ĩri vũgá ꞌdãá.” Mósẽ ní túré rĩ ꞌbezú vũgá ꞌdãá, túré rĩ ní ufuzú ị̃nị̃ rú, Mósẽ nga ápá rá. ");
INSERT INTO kbo_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ su mî drị́, ꞌí rụ ị̃nị̃ rĩ ã só.” Kúru Mósẽ ní ị̃nị̃ rĩ vé só rụzú, ị̃nị̃ rĩ ní gõzú ufuzú túré rú ũzi. ");
INSERT INTO kbo_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Úpí Múngú ní ꞌyozú kĩnĩ, “ꞌÍ ꞌo tã ꞌdĩri, ꞌbá Ĩsẽrélẽ vé rĩ pi ẽ ẹ̃ꞌyị̃kí rí ꞌyozú kínĩ, ma Úpí Múngú kộpi ẹ́ꞌbị́pị́ị vé rĩ, Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, Múngú Yõkóbũ vé rĩ iꞌda ꞌi mí ní rá.” ");
INSERT INTO kbo_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kúru Úpí Múngú ní gõzú ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ su mî drị́ mívé bõngó akoóko rĩ agá ꞌdãá.” Mósẽ ní ꞌî drị́ suzú ívé bõngó akoó rụ̃kụ̃ rĩ agá ꞌdãlé, kã ꞌî drị́ ínjé ãmvé nõó, ũfú fu drị́ ni mveé kú gbũ. ");
INSERT INTO kbo_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ su mî drị́ gõó bõngó akoóko rĩ agá ꞌdãá dị̃ị́.” Mósẽ ní ꞌî drị́ suzú bõngó akoó rụ̃kụ̃ rĩ agá ꞌdãá, kã ꞌî drị́ ínjé ãmvé nõó, drị́ ni gõ ícá ule, sụ̃ ụ̃kụ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Úpí Múngú ní ꞌyozú kĩnĩ, “Kộpi ãꞌyĩkí dõ mi kuyé, dõku kộpi ụ̃sụ̃kí dõ tã mí ní ꞌoó ãyãzú ãyãyã drị̃drị̃ ꞌdãri kuyé, kộpi ícó tã ãyãzú ãyãyã mí ní ꞌoó vúlé nõri ãꞌyĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ꞌBo kộpi ãꞌyĩkí dõ tã ãyãzú ãyãyã ị̃rị̃ ꞌdĩꞌbée kuyé, dõku kộpi yịkí dõ tã mí ní ꞌyoó rĩ kuyé, mí ĩbẽ yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ vé rĩ dãá nyọ̃ọ́kụ́ drị̃gé ꞌdãá. Yị̃ị́ mí ní ĩbẽé yị̃ị́ Náyĩlĩ vé rĩ agá dãá nyọ̃ọ́kụ́ drị̃gé ꞌdĩri gõ ꞌi újá ãrí rú.” ");
INSERT INTO kbo_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ꞌBo Mósẽ ní gõzú újázú Úpí Múngú ní kĩnĩ, “Á Úpí Múngú, íꞌdózú ị́nọ́gọ́sị́, á nị̃ átángá átá be múké ku, mâ ádra ẹ̃njị̃ẹ̃njị̃, ma ri aꞌbu aꞌbu.” ");
INSERT INTO kbo_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Ãꞌdi ri sẽ ꞌbá ri ícó átángá átá nĩ, dõku átá ku nĩ? Ãꞌdi ri sẽ bị́ ni ri tã yị nĩ, dõku bị́ ni yị tã ku nĩ? Ãꞌdi ri sẽ mị ni ri ãngũ ndre nĩ, dõku mị ni ndre ãngũ ku nĩ? ꞌBá rĩ adri ma Úpí Múngú ꞌi kuyé? ");
INSERT INTO kbo_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ꞌÍ mụ, ma mî ĩzã ko, mi ícó átángá rĩ átá rá, ma tã rĩ ímbá mí ní, mi ícó átángá rĩ átá rá.” ");
INSERT INTO kbo_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mósẽ ní ꞌyozú ĩri ní kĩnĩ, “Á Úpí Múngú, ꞌí pẽ ꞌbá ãzi mụzú áyu.” ");
INSERT INTO kbo_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kúru jĩkó ní ꞌdezú Úpí Múngú agá, ĩri ní ꞌyozú Mósẽ ní kĩnĩ, “Mí ẹ́drị́pị Ãrónã Lẹ́vị̃gú rĩ ꞌdãáyo? Á nị̃ rá ĩri ícó átá múké rá. Ĩri nóni ri ímụ́ mí vúgá nõlé. Kãdõ mi ndreé, ẹ́sị́ ni ri adri ãyĩkõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Mi ícó tã mí ní lẽé átá rĩ ũlũ ĩri ní rá, ma ĩmi ĩzã ko ị̃rị̃trọ́ átángá rĩ sĩ rá, ãzini ma ĩmi ímbá tã ĩmi ní lẽé ꞌoó rĩ sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ãrónã ri átángá rĩ átá ꞌbá rĩ pi ní mî vũrã gá nĩ, sụ̃ mí ní kõdô átá nĩ rĩ tị́nị, mi adri ĩri ní sụ̃ Múngú tị́nị, mi átángá ĩri ní lẽé átá rĩ ũlũ ĩri ní nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ꞌÍ ꞌdụ túré ꞌdĩri mụzú mí drị́gé sĩ ĩndĩ, ꞌí ꞌo tã ãyãzú ãyãyã ni ãní.” ");
INSERT INTO kbo_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kúru Mósẽ ní ꞌi újázú gõzú ẹ́nyẹ́pị Yétẽrõ vúgá ꞌdãlé, ĩri ní ꞌyozú Yétẽrõ ní kĩnĩ, “Mí ọyụ ma, á lẽ gõó mụụ́ Ẽjẽpétõ gá má ẹ́ꞌdị́páa pi ndreé, kộpi dõ ídri rú.” Yétẽrõ ní ꞌyozú kĩnĩ, “ꞌÍ mụ, tãkíri ã adri mí be.” ");
INSERT INTO kbo_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mósẽ ní drĩ adrií Mĩdĩyánã gá ꞌdãlé rĩ gé, Úpí Múngú ní átázú ĩri ní kĩnĩ, “ꞌÍ gõ vúlé Ẽjẽpétõ gá ꞌdãlé ũzi, ꞌbá lẽꞌbá mi ꞌdịꞌbá rĩ pi ũdrãkí gí.” ");
INSERT INTO kbo_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kúru Mósẽ ní ívé ũkú ꞌdụzú anjiŋá rĩ pi be ꞌbãzú dõngí úgóró gá, kộpi ní mụzú Ẽjẽpétõ gá ꞌdãlé. ꞌDụ túré Múngú ní ꞌyoó ã jị rĩ mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ gõ dõ Ẽjẽpétõ gá ꞌdãlé gí, mî nị̃ múké ꞌyozú kínĩ, ũkpõ má ní sẽé mí ní ꞌdĩri, lẽ mî ꞌo tã ãyãzú ãyãyã ni pi ꞌbãgú rĩ ẽ ẹndrẹtị gé. ꞌBo ma sẽ ĩrivé ẹ́sị́ ri te te, ícó ꞌbá rĩ pi ọyụụ́ mụzú ku. ");
INSERT INTO kbo_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kúru ꞌí ꞌyo ꞌbãgú rĩ ní, ‘Tã Úpí ní ꞌyoó rĩ ĩri ꞌdíni, Ĩsẽrélẽ ri mávé mvá ágó kãyú rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ándúrú á ꞌyo mí ní, má kĩnĩ, “Mî ọyụ mávé mvá ágó, ã mụ rí ma ị̃njị̃ị́,” ꞌbo mí gã ĩri ọyụgá sĩ, kúru ma mívé mvá ágó kãyú rĩ ꞌdị drã rá.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Vũrã Mósẽ pi ní lazú rĩ gé, Úpí Múngú ícá ímụ́ Mósẽ ri ị́sụ́, lẽ kõdô Mósẽ ri ꞌdịị́ drãá ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sĩpúrã ní ị́lị́ íꞌdụ́zú ívé mvá ágó rĩ vé ágélé ẽ tị lịzú ãní. Ĩri ní lãꞌbú rĩ ĩkpãzú Mósẽ pá gá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Ãrí ĩfũúpi ꞌdĩri úmú nóni ꞌbávé ãjẽ mí be rĩ ícá ngá ãlu gí.” ");
INSERT INTO kbo_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Kúru Úpí Múngú gõ Mósẽ ri ꞌdịị́ kuyé. Sĩpúrã ní ꞌyozú kĩnĩ, “Ágélé ẽ tị má ní lịị́ ꞌdĩri pa mi drã sị́gé sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Úpí Múngú ní ꞌyozú Ãrónã ní kĩnĩ, “ꞌÍ mụ ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ĩmi mụkí rí ĩmi ị́sụ́ Mósẽ be.” Kúru Ãrónã ní mụzú Mósẽ ri ị́sụ́zú írã Múngú vé rĩ drị̃gé ꞌdãlé, kộpi ní ĩ uꞌdezú ẹzịzú bẹ̃drị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kúru Mósẽ ní tã Úpí Múngú ní ꞌi pẽzú mụzú Ẽjẽpétõ gá rĩ ũlũzú Ãrónã ní céré, ãzini ũkpõ Múngú ní sẽé ꞌí ní tã ãyãzú ãyãyã ni ꞌozú rĩ ũlũzú ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kúru Mósẽ pi ní ꞌdezú mụzú Ãrónã be Ẽjẽpétõ gá ꞌdãlé. Kộpi ní ambugu Ĩsẽrélẽ vé rĩ pi úmúzú céré vũrã ãlu gé. ");
INSERT INTO kbo_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ãrónã ní tã Úpí Múngú ní ꞌyoó Mósẽ ní rĩ ũlũzú kộpi ní céré. Kúru Mósẽ ní tã ãyãzú ãyãyã ni ꞌozú ꞌbá rĩ pi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ꞌBá rĩ pi ẹ̃ꞌyị̃kí tã Ãrónã ní átá rĩ rá. Kộpi kâ nị̃ị́ ámá ꞌyozú kínĩ Úpí Múngú ụ̃sụ̃ ĩvé tã gí, ãzini ndre ĩvé ĩzãngã gí, kộpi ní kũmũcí ũtị̃zú, ĩ drị̃ sị̃zú vũgá Úpí Múngú ri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mósẽ pi Ãrónã be, kộpi ní ꞌdezú mụzú ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãlé. Kộpi ní ꞌyozú ĩri ní kínĩ, “Úpí Múngú Ĩsẽrélẽ rĩ pi vé rĩ kĩnĩ, ‘Lẽ mî ọyụ ꞌbá mávé rĩ pi fũú nõósĩ rá, kộpi ã mụkí rí ụ̃mụ̃ údé ma ị̃njị̃zú ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ꞌBãgú rĩ ní ꞌyozú kộpi ní kĩnĩ, “Úpí Múngú ĩmi ní ꞌyoó mâ ꞌdụ ĩrivé tã ngaá, mâ ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi fũú nõósĩ rá ꞌdĩri ãꞌdi ꞌi? Á nị̃ Úpí Múngú ꞌdĩri kuyé, má ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi fũú nõósĩ ãluŋáni ku.” ");
INSERT INTO kbo_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mósẽ pi Ãrónã be, kộpi ní ꞌyozú ꞌbãgú rĩ ní kínĩ, “Múngú Ẽbérẽ rĩ pi vé rĩ, iꞌda ꞌi ꞌbá ẹndrẹtị gé rá. Mí ọyụ ꞌbâ fũú nõósĩ rá, ꞌbâ tukí rí ẹ̃cị̃ ụ́ꞌdụ́ na ãngũ ãꞌwí cínyáfã rú rĩ agásĩ, ꞌbâ mụkí rí rọ̃bọ̃ŋọ̃ zãá Úpí Múngú ꞌbávé rĩ ní, ꞌbá mụkí dõ ku, ĩri drã ũnjí ĩpẽ ꞌbá drị̃gé, dõku ĩri ariꞌba ĩpẽ ímụ́ ꞌbâ úꞌdị́ ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ꞌBo ꞌbãgú Ẽjẽpétõ vé rĩ ní ꞌyozú kĩnĩ, “Mósẽ, ĩmi Ãrónã be, ꞌbá rĩ pi ri ẹ̃zị́ ngá pírí, ngá ĩmi ní lẽzú kộpi jịzú mụzú rá rĩ ãꞌdi? Ĩmi gõkí vúlé ẹ̃zị́ gé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kúru ꞌbãgú rĩ ní ꞌyozú kĩnĩ, “Ĩmi ndrekí drĩ ká, ꞌbá Ĩsẽrélẽ vé rĩ pi ízúkí nóni ambamba, ĩmi lẽkí kộpi ã ngakí ẹ̃zị́ ku!” ");
INSERT INTO kbo_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ụ́ꞌdụ́ ãlu ãlu ꞌdãri sĩ, ꞌbãgú rĩ ní tãị́mbị́ sẽzú ꞌbá ẹ̃zị́ ũlũꞌbá tụ́gẹ̃rị̃ rĩ pi ní rĩ pi ní, ãzini Ĩsẽrélẽ ĩ ní ũpẽé ũꞌbãá ꞌbá ambugu rú Ĩsẽrélẽ rĩ pi drị̃gé rĩ pi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Nóni ã sẽkí ásé ĩ ní rizú bị̃rị́kị̃ vé ũtrẽtrẽ tuzú rĩ ꞌbá Ĩsẽrélẽ vé rĩ pi ní dị̃ị́ ku. Kộpi ã mụkí ĩngá ndãá nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ꞌBo ĩmi ꞌbãkí kộpi ã gbãkí bị̃rị́kị̃ rĩ vé kãlãfe caá gbã ándúrú kộpi ní gbãá drị̃drị̃ rĩ pí, lẽ kộpi ã gbãkí kãlãfe ni mãdãŋá ku. Kộpi kpũnũkũ rú, kộpi ní rizú útrézú ãní kínĩ, ‘Mí ọyụ ꞌbâ fũú nõósĩ rá, ꞌbá lẽkí mụụ́ rọ̃bọ̃ŋọ̃ zãá ꞌbávé Múngú ní.’ ");
INSERT INTO kbo_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ĩmi ꞌbãkí kộpi ã ngakí ẹ̃zị́ ũkpó ũkpó ni pi, kộpi ã rikí pá tuú tẽé rií tã ũnjõ vé ꞌdĩri yịị́ ku.” ");
INSERT INTO kbo_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kúru ꞌbá ẹ̃zị́ ũlũꞌbá tụ́gẹ̃rị̃ rĩ pi ní rĩ pi, Ĩsẽrélẽ ꞌí ní ũpẽé ũꞌbãá ꞌbá ambugu rú Ĩsẽrélẽ rĩ pi drị̃gé rĩ pi be, kộpi ní fũzú mụzú átángá ꞌbãgú rĩ ní ꞌyoó rĩ ũlũzú ꞌbá Ĩsẽrélẽ vé rĩ pi ní kínĩ, “ꞌBãgú rĩ ꞌyo ꞌdíni kĩnĩ, ‘Á gõ ĩmi ní ásé bị̃rị́kị̃ vé ũtrẽtrẽ tuzú ni sẽé dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ĩmi mụkí ndãá ĩmi ngúlúpí sĩ, vũrã ĩmi ní ícózú ị́sụ́zú rá rĩ gé. ꞌBo lẽ ĩmi gbãkí bị̃rị́kị̃ rĩ vé kãlãfe caá gbã ándúrú ĩmi ní gbãá drị̃drị̃ rĩ pí.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kúru ꞌbá rĩ pi ní ayizú mụzú ásé bị̃rị́kị̃ vé ũtrẽtrẽ tuzú rĩ ndã be ãngũ Ẽjẽpétõ vé rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ꞌBá ẹ̃zị́ ũlũꞌbá tụ́gẹ̃rị̃ rĩ pi ní rĩ pi rikí tụ́gẹ̃rị̃ rĩ pi mĩí rií ẹ̃zị́ rĩ ngaá ũkpõ sĩ. Kộpi ri ꞌyo tụ́gẹ̃rị̃ rĩ pi ní, “Lẽ ụ́ꞌdụ́ ãlu ãlu, ĩmi gbãkí bị̃rị́kị̃ rĩ gbã ándúrú ĩmi ní rií gbãá ꞌbá ní rií ĩmi ní ásé bị̃rị́kị̃ tuzú rĩ sẽé nĩ rĩ pí.” ");
INSERT INTO kbo_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ꞌBãgú rĩ vé ꞌbá ẹ̃zị́ ũlũꞌbá rĩ pi rikí ꞌbá Ĩsẽrélẽ vé ĩ ní ũꞌbãá ambugu rú rĩ pi ũgbãá, kộpi rikí ꞌyoó kínĩ, “Íꞌdózú ájée ícázú ãndrũ, ĩmivé ꞌbá rĩ pi gbãkí bị̃rị́kị̃ rĩ gbã ándúrú rĩ pí kuyé ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ĩsẽrélẽ ĩ ní ũpẽé ũꞌbãá ꞌbá ambugu rú Ĩsẽrélẽ rĩ pi drị̃gé rĩ pi ní ꞌdezú mụzú ꞌbãgú rĩ vúgá ꞌdãlé, kộpi ní ĩri mãzú drị́ ị̃rị̃ sĩ kínĩ, “ꞌBâ ãtíꞌbá mívé ni, mi ri ꞌbâ ꞌo ꞌdíni ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ꞌBá ẹ̃zị́ ũlũꞌbá rĩ pi gãkí ꞌbá ní ásé ũtrẽtrẽ tuzú rĩ sẽgá sĩ, kộpi ri ꞌyo ꞌbâ gbãkí bị̃rị́kị̃, kộpi dị̃ ri ꞌbâ ũgbã be, tã ũnjí ꞌdĩri, ꞌbá mívé rĩ pi ri íjị́ ꞌbá drị̃gé nĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ꞌBãgú rĩ ní újázú kộpi ní kĩnĩ, “Ĩmi kpũnũkũ rú, ĩmi gãkí ẹ̃zị́ ngagá sĩ, sẽ ĩmi ní rizú ꞌyozú kínĩ, ‘Mí ọyụ ꞌbâ fũú nõósĩ, mụụ́ rọ̃bọ̃ŋọ̃ zãá Úpí Múngú ní ãní.’ ");
INSERT INTO kbo_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ĩmi ngakí mụụ́ ẹ̃zị́ rĩ ngangárá gá, sẽkí ĩmi ní ásé bị̃rị́kị̃ tuzú rĩ ãluŋáni ku. ꞌBo lẽ ĩmi gbãkí bị̃rị́kị̃ rĩ gbã ándúrú ĩmi ní rií gbãá rĩ pí.” ");
INSERT INTO kbo_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ĩsẽrélẽ ĩ ní ũpẽé ũꞌbãá ꞌbá ambugu rú Ĩsẽrélẽ rĩ pi drị̃gé rĩ pi kâ yịị́ kínĩ, ụ́ꞌdụ́ ãlu agá, lẽ ĩ gbãkí kãlãfe bị̃rị́kị̃ vé rĩ mãdãŋá ku, sẽ kộpi nị̃kí ámá ꞌyozú kínĩ ĩ nóni ĩzãngã agá. ");
INSERT INTO kbo_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kộpi kâ ꞌbãgú rĩ kuú, kộpi ị́sụ́kí Mósẽ pi ri ĩ tẽ Ãrónã be lẹ́tị gé ꞌdãáꞌdã. ");
INSERT INTO kbo_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kộpi ní ꞌyozú Mósẽ pi ní Ãrónã be kínĩ, “Úpí Múngú ã ndre tã ĩmivé ꞌdĩri, ã lị tã ĩmi drị̃gé, ãꞌdiãtãsĩyã ĩmi sẽkí nóni ꞌbãgú rĩ ívé ũgalaku rĩ pi be, kộpi ngụ̃kí ꞌbâ ũnjí, tã ĩmi ní ꞌoó ꞌdĩri índré sụ̃ ĩmi sẽkí ị́lị́ ãco ꞌbá Ẽjẽpétõ vé rĩ pi drị́gé ꞌbâ úꞌdị́zú ũdrãzú ãní rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mósẽ ní kộpi kuzú, ĩri ní mụzú Múngú ri zịzú kĩnĩ, “Á! Úpí Múngú, mi ri ĩzãngã sẽ mívé ꞌbá rĩ pi ní ꞌdíni ãsĩ? Mí ĩpẽ ma ímụ́zú nõgó ãlé? ");
INSERT INTO kbo_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Íꞌdózú sâ má ní mụzú ꞌbãgú rĩ vúgá tã mívé rĩ ũlũzú rĩ gé, ꞌbãgú rĩ sẽ ĩzãngã ꞌbá mívé rĩ pi ní ũnjí ũnjí, ꞌbo ꞌí pa ꞌbá mívé rĩ pi kuyé.” ");
INSERT INTO kbo_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Mi ímụ́ tã má ní lẽé ꞌoó ꞌbãgú rĩ ní rĩ ndre rá. Mávé ũkpõ sĩ, ĩri ꞌbá mávé rĩ pi ọyụ mụzú rá, mávé ũkpõ sĩ, ĩri ꞌbá rĩ pi dro fũ ívé ãngũ agásĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Múngú gõ ꞌyoó Mósẽ ní kĩnĩ, “Ma Úpí Múngú ꞌi. ");
INSERT INTO kbo_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ọ́tụ́ má iꞌda ma Ãbũrámã ẹndrẹtị gé, Ĩsákã ẹndrẹtị gé, ãzini Yõkóbũ ẹndrẹtị gé rá, Ma Múngú Ũkpõ ꞌDị́pa ꞌi, ꞌbo á sẽ mávé rụ́ Úpí Múngú ꞌdĩri nị̃ị́ kộpi ní kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Á rụ kpá ũndĩ kộpi be, ma ãngũ Kãnánã vé kộpi ní ándúrú adrií ꞌa ni gé ꞌdãá jãkã rú rĩ sẽ kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Á yị ĩzãngã ꞌbá Ẽjẽpétõ vé rĩ pi ní rizú ꞌbá Ĩsẽrélẽ vé rĩ pi ọ̃cụ̃zú tụ́gẹ̃rị̃ rú rĩ gí, sẽ má ígá ũndĩ má ní rụụ́ kộpi be rĩ vé tã gí. ");
INSERT INTO kbo_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kúru ꞌí ꞌyo ꞌbá Ĩsẽrélẽ vé rĩ pi ní kínĩ, ‘Ma Úpí Múngú ꞌi, ma ĩmi íjị́ ĩfũ ẹ̃zị́ ũkpó ũkpó ꞌbá Ẽjẽpétõ vé rĩ pi ní rií ĩmi ọ̃cụ̃zú rĩ agásĩ rá. Ma ĩmi ọyụ adringárá tụ́gẹ̃rị̃ rú rĩ agásĩ rá, ũkpõ mávé rĩ sĩ, ma ĩmi pa, ma kộpi ĩrĩŋã ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ĩmi adri ꞌbá mávé ní pi, ma adri Múngú ĩmivé ni. Ĩmi kúru ímụ́ nị̃ ámá ꞌyozú kínĩ, ma Úpí Múngú ĩmivé rĩ, ĩmi íjị́pi ĩfũúpi ẹ̃zị́ ũkpó ũkpó ꞌbá Ẽjẽpétõ vé rĩ pi ní rizú ĩmi ọ̃cụ̃zú rĩ agásĩ rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ma ĩmi íjị́ adri ãngũ má ní ũyõ ni sõó sẽé Ãbũrámã ní, Ĩsákã ní, ãzini Yõkóbũ ní rĩ agá. Ma ãngũ rĩ sẽ ĩmi ní, ĩri adri ngá ĩmivé ni. Ma Úpí Múngú ꞌi.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mósẽ ní tã Múngú ní ꞌyoó ꞌdĩri ũlũzú ꞌbá Ĩsẽrélẽ vé rĩ pi ní, ꞌbo kộpi gãkí Mósẽ ri yịgá sĩ, ãꞌdiãtãsĩyã kộpi ẽ ẹ́sị́ ị́sụ́ ĩzãngã ĩ ní ĩ ọ̃cụ̃ụ́ tụ́gẹ̃rị̃ rú rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ꞌÍ mụ ꞌyoó ꞌbãgú Ẽjẽpétõ vé rĩ ní ꞌdíni, lẽ ã ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi fũú ívé ãngũ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ꞌBo Mósẽ ní újázú Úpí Múngú ní kĩnĩ, “Dõ ꞌbá Ĩsẽrélẽ vé rĩ pi yịkí ma ku pírí, ꞌbãgú rĩ ícó ma yị íngóni, ị́sụ́zú ma ri aꞌbu aꞌbu?” ");
INSERT INTO kbo_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Úpí Múngú ní tãị́mbị́ sẽzú Mósẽ pi ní Ãrónã be kĩnĩ, “Ĩmi újákí ĩmi gõó ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãá, ĩmi íjị́kí ꞌbá Ĩsẽrélẽ vé rĩ pi ĩfũú Ẽjẽpétõ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Úyú Ĩsẽrélẽ vé rĩ pi ꞌdĩ: Ĩsẽrélẽ vé mvá kãyú Rũbénã vé anji ãgõ rĩ pi ã rụ́ ꞌdĩ, Ẽnókã ꞌi, Pálũ ꞌi, Ẽzĩrónã ꞌi, Kãrímĩ sĩ. Úyú ꞌdĩꞌbée Rũbénã vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Anji ãgõ Sĩmĩyónã vé rĩ pi ꞌdĩ, Yẽmũyélẽ ꞌi, Yãmínĩ ꞌi, Õhádĩ ꞌi, Yãkínĩ ꞌi, Zõhárã ꞌi, Kãnánãzị́ rĩ vé mvá Sáwũlã sĩ. Úyú ꞌdĩꞌbée Sĩmĩyónã vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Anji ãgõ Lẹ́vị̃ vé ĩ ní sĩí rĩ pi ã rụ́ ꞌdĩ: Gẽrẽsónã ꞌi, Kõhátã ꞌi, Mẽrárã sĩ. Lẹ́vị̃ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na drị̃ ni ẹ́zị̂rị̃ (137). ");
INSERT INTO kbo_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Anji ãgõ Gẽrẽsónã vé rĩ pi, Lị̃bị́nị̃ pi Sĩméyĩ be. ");
INSERT INTO kbo_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Anji ãgõ Kõhátã vé rĩ pi ã rụ́ ꞌdĩ, Ãmũrámũ ꞌi, Ĩzĩhárĩ ꞌi, Hẽbẽrónã ꞌi, Ũzĩyélẽ sĩ. Kõhátã adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na drị̃ ni na (133). ");
INSERT INTO kbo_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Anji ãgõ Mẽrárã vé rĩ pi, Mãhúlĩ pi Músĩ be. Úyú ĩ ní sĩí ꞌdĩꞌbée íbíkí ĩfũú sụ́rụ́ Lẹ́vị̃ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ãmũrámũ je ꞌí ẹ́tẹ́pị vé ọ́mvụ́pị Yõkõbédẽ ri, tị ĩri ní Ãrónã pi Mósẽ be. Ãmũrámũ adri caá ílí be mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ na drị̃ ni ẹ́zị̂rị̃. (137) ");
INSERT INTO kbo_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Anji ãgõ Ĩzĩhárĩ vé rĩ pi ꞌdĩ, Kórã ꞌi, Nẽfégẽ ꞌi, Zíkĩrĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Anji ãgõ Ũzĩyélẽ vé rĩ pi ꞌdĩ, Mĩsãyélẽ ꞌi, Ẽlẽzãfánã ꞌi, Sítĩrĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ãrónã je Ẽlĩsébã ri, Ẽlĩsébã ri Ãmĩnãdábã vé mvá ũkú, ĩri Nãsónã ọ́mvụ́pị, tị Nãdábũ ri, Ãbúhũ ri, Ẽlẽzárã ri, Ĩtãmárã sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Anji ãgõ Kórã vé rĩ pi ꞌdĩ, Ãsírĩ ꞌi, Ẽlẽkánã ꞌi, Ãbĩyãsáfã sĩ. Úyú ꞌdĩꞌbée Kórã vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ãrónã vé mvá Ẽlẽzárã je Pũtĩyélẽ vé mvá ũkú, mvá ũkú rĩ tị ĩri ní Fĩnásã ri. Úyú ꞌdĩꞌbée íbíkí ĩfũú sụ́rụ́ Lẹ́vị̃ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ãrónã pi Mósẽ be, ꞌbá ꞌdĩꞌbée Úpí Múngú ní ꞌyoó kộpi ní, “Ĩmi íjị́kí sụ́rụ́ Ĩsẽrélẽ vé rĩ pi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ ãmvé ĩvé sụ́rụ́ rĩ pi vúgá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ꞌBá ꞌdĩꞌbée ꞌyoꞌbá ꞌbãgú Ẽjẽpétõ vé rĩ ã ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ ãmvé rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Úpí Múngú átá ándúrú Mósẽ ní Ẽjẽpétõ gá ꞌdãlé, ");
INSERT INTO kbo_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kĩnĩ, “Ma Úpí Múngú ꞌi. Lẽ mî ũlũ ꞌbãgú Ẽjẽpétõ vé rĩ ní tã má ní ꞌyoó mí ní rĩ pi ãrẽvú céré.” ");
INSERT INTO kbo_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ꞌBo Mósẽ újá Úpí Múngú ní kĩnĩ, “Mí nị̃ rá ma ri aꞌbu aꞌbu, ꞌbãgú rĩ ícó ma yị íngóni?” ");
INSERT INTO kbo_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ ndre drĩ ká, á ꞌbã mi adrií sụ̃ Múngú tị́nị ꞌbãgú rĩ ẹndrẹtị gé, mí ẹ́drị́pị Ãrónã ri adri nẹ́bị̃ rú, ri mívé ụ́ꞌdụ́kọ́ rĩ ũlũ ꞌbãgú rĩ ní nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mí ũlũ tã má ní ꞌyoó mí ní rĩ pi céré mí ẹ́drị́pị Ãrónã ní, Ãrónã ã mụ ꞌyoó ꞌbãgú rĩ ní kínĩ, lẽ ã ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi fũú ívé ãngũ agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ꞌBo ma sẽ ꞌbãgú rĩ vé ẹ́sị́ ri tete, átã mâ ꞌo dõ tã ãyãzú ãyãyã ni ãngũ Ẽjẽpétõ vé rĩ agá kárákará drãáãsĩyã, ");
INSERT INTO kbo_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ꞌbãgú rĩ ícó ĩmi yịị́ ku. Kúru mávé ũkpõ sĩ, ma ꞌbá Ẽjẽpétõ vé rĩ pi ĩrĩŋã tã ũnjí ũnjí ni pi sĩ, ma sụ́rụ́ ãndíãndí Ĩsẽrélẽ vé rĩ pi íjị́ ĩfũ ãngũ Ẽjẽpétõ vé rĩ agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Má kãdõ mávé ũkpõ lũú ꞌbá Ẽjẽpétõ vé rĩ pi ní, ãzini ma kãdõ ꞌbá Ĩsẽrélẽ vé rĩ pi íjị́ ĩfũú Ẽjẽpétõ agásĩ ãmvé, ꞌbá Ẽjẽpétõ vé rĩ pi kúru ímụ́ nị̃ ámá ꞌyozú kínĩ, ma Úpí Múngú ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mósẽ pi Ãrónã be ꞌokí tã rĩ sụ̃ Úpí Múngú ní ẹzịị́ ĩ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Lókí kộpi ní átázú ꞌbãgú rĩ be rĩ gé, ị́sụ́ Mósẽ ri ílí be pụ̃kụ́ ãrõ, Ãrónã ri ílí be pụ̃kụ́ ãrõ drị̃ ni na. ");
INSERT INTO kbo_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Úpí Múngú ní ꞌyozú Mósẽ pi ní Ãrónã be kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ꞌBãgú rĩ ꞌyo dõ ĩmi ní, ‘Ĩmi ꞌokí tã ãyãzú ãyãyã ni,’ ꞌí ꞌyo Ãrónã ní, ‘Mí íꞌdụ́ mívé túré, ꞌí ꞌbe ꞌbãgú rĩ ẹndrẹtị gé vũgá ꞌdãá,’ ĩri gõ ꞌi újá ufu ị̃nị̃ rú.” ");
INSERT INTO kbo_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kúru Mósẽ pi ní mụzú Ãrónã be ꞌbãgú rĩ vúgá ꞌdãá, kộpi ꞌokí tã rĩ sụ̃ Úpí Múngú ní ẹzịị́ ĩ ní rĩ tị́nị. Ãrónã ní ívé túré ꞌbezú vũgá ꞌbãgú rĩ ẹndrẹtị gé, ãzini ĩrivé ũgalaku rĩ pi ẹndrẹtị gé, túré rĩ újá ꞌi ufuú ị̃nị̃ rú. ");
INSERT INTO kbo_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kúru ꞌbãgú rĩ ní ívé ꞌbá tã nị̃ꞌbá ambamba rĩ pi zịzú ꞌbá újógú rú rĩ pi be, ãzini ꞌbá ũjõgũ vé ẹ̃zị́ ngaꞌbá ãngũ Ẽjẽpétõ vé rĩ agá rĩ pi be, kộpi ꞌokí kpá tã rĩ nyo sụ̃ ꞌdĩri tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ꞌBá ãlu ãlu ꞌbe ívé túré vũgá ꞌdãá, túré rĩ pi újákí ĩ ufuú céré ị̃nị̃ rú. ꞌBo Ãrónã vé túré ufuúpi ị̃nị̃ rú rĩ, ute kộpivé túré ufuꞌbá ị̃nị̃ rú rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ꞌBãgú rĩ vé ẹ́sị́ gõ teéte sụ̃ Úpí Múngú ní ꞌyoó rĩ tị́nị, gã Mósẽ pi yịgá Ãrónã be sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌBãgú rĩ vé ẹ́sị́ tete, gã ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụgá mụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kúru drụ̃ sĩ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, ꞌí mụ ꞌbãgú rĩ tẽé yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ vé rĩ gé ꞌdãá, ị́sụ́ mụ drĩ yị̃ị́ gé ꞌdãlé kuyé. Kãdõ mụụ́ yị̃ị́ gé ꞌdãá, ĩmi ị́sụ́kí rí ĩmi ĩri be, ꞌí ꞌdụ mívé túré ꞌi újápi ufuúpi ị̃nị̃ rú rĩ mụụ́ mí drị́gé sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kúru ꞌí ꞌyo ꞌbãgú rĩ ní, ‘Úpí Múngú Ẽbérẽ rĩ pi vé rĩ ĩpẽ ma ímụ́ ꞌyo mí ní kĩnĩ, “Lẽ mî ọyụ ꞌbá mávé rĩ pi mụụ́ rá, kộpi ã mụkí rí ma ị̃njị̃ị́ ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá.” ꞌBo cĩmgbá ãndrũ sĩ, mí gã tã ꞌdĩri yịgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Úpí Múngú ní ꞌyozú kĩnĩ, ꞌi tã ãzi ꞌo lũzú kínĩ ádarú ꞌi Úpí ꞌi, ꞌi yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ vé rĩ gbã túré ꞌí drị́gé ꞌdĩri sĩ, yị̃ị́ rĩ gõ ꞌi újá ka ku ãrí rú. ");
INSERT INTO kbo_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ị̃ꞌbị́ yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá rĩ pi ímụ́ ũdrã rá, yị̃ị́ rĩ gõ ngụ̃ ũnjíkãnyãkãnyã. ꞌBá Ẽjẽpétõ vé rĩ pi ícókí mvụụ́ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ ꞌyo Ãrónã ní, ‘ꞌÍ ꞌdụ mívé túré, mí inga suú yị̃ị́ Ẽjẽpétõ vé rĩ pi drị̃gé ꞌdãá, yị̃ị́ dịꞌbá dịdị rĩ pi drị̃gé ꞌdãá, yị̃ị́ ĩ ní gaága rĩ pi drị̃gé ꞌdãá, átápárá rĩ pi drị̃gé ꞌdãá, yị̃ị́ rĩ pi gõ ĩ újá céré ku ãrí rú. Ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá, yị̃ị́ ũdrí agá rĩ pi, yị̃ị́ kụ̃lụ́kụ́ agá rĩ pi céré ĩ újá adri ku ãrí rú.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Kúru Mósẽ pi Ãrónã be ꞌdụkí tã rĩ ngaá sụ̃ Úpí Múngú ní ẹzịị́ ĩ ní rĩ tị́nị. Ãrónã ní ívé túré íꞌdụ́zú, ĩri ní yị̃ị́ Náyĩlĩ ẽ mị gbãzú ꞌbãgú rĩ ẹndrẹtị gé ꞌdĩgé, ãzini ĩrivé ũgalaku rĩ pi ẹndrẹtị gé ꞌdĩgé, yị̃ị́ rĩ újá ꞌi céré kuú ãrí rú. ");
INSERT INTO kbo_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ị̃ꞌbị́ yị̃ị́ Náyĩlĩ agá rĩ pi ũdrãkí rá, yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ rĩ gõ ngụ̃ụ́ ũnjíkãnyãkãnyã, ꞌbá Ẽjẽpétõ vé rĩ pi ícókí mvụụ́ ku. Yị̃ị́ ãngũ Ẽjẽpétõ vé rĩ agá rĩ gõ céré adrií ãrí rú. ");
INSERT INTO kbo_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ꞌBo újógú Ẽjẽpétõ agá rĩ pi ụ̃ꞌbị̃kí kpá ĩvé ũkpõ ũjõgũ vé rĩ áyú, yị̃ị́ rĩ újá ꞌi ufuú ãrí rú. Sẽ ꞌbãgú rĩ vé ẹ́sị́ gõ teé mụzú drị̃gélé, gã Mósẽ pi vé tã Ãrónã be rĩ yịgá sĩ, sụ̃ Úpí Múngú ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Tã ꞌdĩri fi ẹ́sị́ ni agá ꞌdãá ãluŋáni kuyé, ĩri ní ꞌi újázú gõzú ívé jó agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ꞌBá Ẽjẽpétõ vé rĩ pi gakí yị̃ị́ Náyĩlĩ ã gãrã céré kuú kídí rú, ĩ ị́sụ́kí rí yị̃ị́ mvụụ́ ãní, ãꞌdiãtãsĩyã kộpi ícókí yị̃ị́ Náyĩlĩ ri mvụụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Úpí Múngú kã yị̃ị́ Náyĩlĩ rĩ ẽ mị gbãá, vụ́drị̃ ni gõ adrií caá ụ́ꞌdụ́ ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ mụ ꞌyoó ꞌbãgú rĩ ní, ‘Úpí Múngú kĩnĩ, mî ọyụ ívé ꞌbá rĩ pi fũú nõósĩ rá, kộpi ã mụkí rí ꞌi ị̃njị̃ị́ bẽsĩnĩ. ");
INSERT INTO kbo_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ꞌÍ gã dõ kộpi ọyụgá sĩ, ꞌi sẽ mívé ãngũ rĩ ga céré ku ụ́drụ́kụ́drụ́ rú, ");
INSERT INTO kbo_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ ã ꞌa ri ga céré ku ụ́drụ́kụ́drụ́ rú. Kộpi ĩfũ yị̃ị́ rĩ agásĩ, kộpi fi mívé jó agá, kộpi útụ́ mívé gbọ́lọ́ drị̃gé sĩ, kộpi úfí ũgalaku rĩ pi vé jó agá, kộpi úfí mívé ãti sị́lé gá sĩ, dõku kộpi útụ́ úfí mívé sángú rĩ pi agá. ");
INSERT INTO kbo_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kộpi útụ́ mî rụ́ꞌbá gá sĩ, mívé ꞌbá rĩ pi ã rụ́ꞌbá gá sĩ, ãzini mívé ũgalaku rĩ pi ã rụ́ꞌbá gá sĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ ꞌyo Ãrónã ẽ inga ívé túré úsú yị̃ị́ dịꞌbá dịdị Ẽjẽpétõ vé rĩ pi drị̃gé sĩ, yị̃ị́ ĩ ní gaága rĩ pi drị̃gé sĩ, átápárá rĩ pi drị̃gé sĩ, ụ́drụ́kụ́drụ́ rĩ pi ẽ ĩfũkí rí ayií ãngũ Ẽjẽpétõ vé rĩ agásĩ céré.” ");
INSERT INTO kbo_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kúru Ãrónã ní ívé túré ingazú úsúzú yị̃ị́ Ẽjẽpétõ vé rĩ pi drị̃gé sĩ, ụ̃drụ́kụ́drụ́ rĩ pi ĩfũkí gaá ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ꞌBo újógú rĩ pi ꞌokí kpá ĩvé ũkpõ ũjõgũ vé rĩ sụ̃ ꞌdĩri tị́nị, sẽ ụ́drụ́kụ́drụ́ rĩ pi ĩfũkí kpá ãngũ Ẽjẽpétõ vé rĩ agá rá. ");
INSERT INTO kbo_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ꞌBãgú rĩ ní Mósẽ pi zịzú ímụ́zú Ãrónã be, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi zịkí Úpí Múngú ri, ã dro rí ụ́drụ́kụ́drụ́ rĩ pi mâ rụ́ꞌbá gá sĩ, ãzini mávé ꞌbá rĩ pi ã rụ́ꞌbá gá sĩ rá. Ma ꞌbá ĩmivé rĩ pi ọyụ mụ rọ̃bọ̃ŋọ̃ zã Úpí Múngú ní rá.” ");
INSERT INTO kbo_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mósẽ ní újázú ꞌbãgú rĩ ní kĩnĩ, “Mí ĩpẽ sâ ni, ma ícó Múngú ri zị mí ní, mívé ũgalaku rĩ pi ní, ãzini mívé ꞌbá rĩ pi ní rá, ụ́drụ́kụ́drụ́ rĩ pi ícó ãngũ rĩ ku rá, ꞌyéŋá yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ agá rĩ pi áwí adri nĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ꞌBãgú rĩ ní ꞌyozú kĩnĩ, “Ĩmi ímụ́kí zịị́ má ní drụ̃ sĩ.” Mósẽ ní újázú ꞌbãgú rĩ ní kĩnĩ, “Ma ícó mụ zị mí ní rá, sụ̃ mí ní ꞌyoó rĩ tị́nị, mî nị̃ rí ámá ꞌyozú kínĩ, múngú ãzi adriípi sụ̃ Úpí Múngú ꞌbávé rĩ tị́nị ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ụ̃drụ́kụ́drụ́ rĩ pi ĩmi ku rá, ãzini kộpi mívé ũgalaku rĩ pi ku mívé ꞌbá rĩ pi be rá, ꞌyéŋá yị̃ị́ ãmbúgú dịị́pi dịdị agá rĩ pi áwí adri nĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mósẽ pi Ãrónã be, kộpi kâ ꞌbãgú rĩ kuú gí, Mósẽ ní Úpí Múngú ri zịzú, ã dro rí ụ́drụ́kụ́drụ́ ĩri ní ĩpẽé ꞌbãgú rĩ drị̃gé rĩ ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Úpí Múngú yị Mósẽ vé zịngárá rá, ụ́drụ́kụ́drụ́ rĩ pi ũdrãkí jó rĩ pi agásĩ, bóró rĩ pi agásĩ, ãngũ rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ꞌBá Ẽjẽpétõ vé rĩ pi ĩkũnãkí ụ́drụ́kụ́drụ́ ũdrãꞌbée rĩ pi kuú amuku rú, amuku rú, ãngũ rĩ ngụ̃ kú ãní ũnjíkãnyãkãnyã. ");
INSERT INTO kbo_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ꞌBo ꞌbãgú rĩ kã ndreé ụ́drụ́kụ́drụ́ rĩ pi ũdrãkí céré gí, ẹ́sị́ ni gõ teéte, gã Mósẽ pi ve tã Ãrónã be rĩ yịgá sĩ, sụ̃ Úpí Múngú ní ándúrú ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ ꞌyo Ãrónã ní, ẽ inga ívé túré, ã gbã fụ́rụ́ndị́ nyọ̃ọ́kụ́ agá ꞌdĩri ãní, fụ́rụ́ndị́ Ẽjẽpétõ agá rĩ gõ ꞌi újá ufu céré mọ̃nyụ́ŋá rú.” ");
INSERT INTO kbo_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kúru Mósẽ pi ní ꞌozú Ãrónã be sụ̃ Úpí Múngú ní ꞌyoó ĩ ní rĩ tị́nị. Ãrónã kã fụ́rụ́ndị́ rĩ gbãá, fụ́rụ́ndị́ rĩ gõ ꞌi újá ufuú kuú céré mọ̃nyụ́ŋá rú, mọ̃nyụ́ŋá rĩ pi gũkí ꞌbá rĩ pi drị̃gé, ãzini ãnyãpá rĩ pi drị̃gé. Fụ́rụ́ndị́ ãngũ Ẽjẽpétõ vé rĩ agá rĩ, gõ ꞌi újá ufuú kuú céré mọ̃nyụ́ŋá rú. ");
INSERT INTO kbo_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ꞌBo újógú rĩ pi kâ kõdô ụ̃ꞌbị̃ị́ ĩvé ũkpõ ũjõgũ vé rĩ áyú mọ̃nyụ́ŋá rĩ pi ẽ ĩfũkí rí ãní ãmvé, kộpi ụ̃ꞌbị̃kí tí. Mọ̃nyụ́ŋá rĩ pi áwíkí gũú kuú ꞌbá rĩ pi drị̃gé, ãzini ãnyãpá rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Újógú rĩ pi ní ꞌyozú ꞌbãgú rĩ ní kínĩ, “Tã ꞌdĩri Múngú ꞌo nĩ.” ꞌBo ꞌbãgú rĩ vé ẹ́sị́ áwí teéte, gã tã ꞌdĩri yịgá sĩ, sụ̃ Úpí Múngú ní ándúrú ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Drụ̃ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, ꞌí kpu mụụ́ ꞌbãgú rĩ vúgá ꞌdãá, kãdõ lẽé mụụ́ yị̃ị́ gé ꞌdãá, ꞌí ꞌyo ĩri ní, ‘Úpí Múngú kĩnĩ, mí ọyụ mávé ꞌbá rĩ pi fũú nõósĩ rá, kộpi ã mụkí rí ma ị̃njị̃ị́ bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Mí gã dõ kộpi ọyụgá sĩ, ma ụ́nyụ́nyụ́ bị́trị́ká ĩpẽ ímụ́ mí drị̃gé, mívé ũgalaku rĩ pi drị̃gé, ãzini mívé ꞌbá rĩ pi drị̃gé, kộpi úfí ĩmivé jó agásĩ céré. ꞌBá Ẽjẽpétõ vé rĩ pi vé jó ã ꞌa ri ga céré ku ụ́nyụ́nyụ́ rú, ãngũ kộpivé rĩ ga céré ku ụ́nyụ́nyụ́ rú. ");
INSERT INTO kbo_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘ꞌBo ụ́ꞌdụ́ ꞌdãri sĩ, ụ́nyụ́nyụ́ bị́trị́ká rĩ pi cakí mávé ꞌbá adriꞌbá ãngũ Gõsénĩ vé rĩ agá rĩ pi vúgá ꞌdãá ku. Ma tã ꞌdĩri ꞌo ꞌdíni, mî nị̃ rí ámá ꞌyozú kínĩ, ma Úpí Múngú ꞌi, ma ũkpõ be ãngũ nõri agá. ");
INSERT INTO kbo_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ma mávé ꞌbá rĩ pi ãsámvú aco mívé ꞌbá rĩ pi be rá. Tã ãyãzú ãyãyã ꞌdĩri, ĩri ꞌi ꞌo drụ̃ sĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Úpí Múngú ní tã rĩ ꞌozú sụ̃ ꞌí ní ꞌyoó rĩ tị́nị. Ụ́nyụ́nyụ́ bị́trị́ká pi ní ĩ tõzú ꞌbãgú rĩ vé jó agá, ũgalaku rĩ pi vé jó agásĩ, ãngũ Ẽjẽpétõ vé rĩ ã ꞌa ga céré kuú ụ́nyụ́nyụ́ rú, iza ãngũ Ẽjẽpétõ vé rĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kúru ꞌbãgú rĩ ní Mósẽ pi zịzú ímụ́zú Ãrónã be ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí rọ̃bọ̃ŋọ̃ zãá Múngú ĩmivé rĩ ní, ꞌbo ĩmi zãkí ãngũ Ẽjẽpétõ vé rĩ agá nõgó ũgõgõ.” ");
INSERT INTO kbo_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ꞌBo Mósẽ ní újázú ꞌbãgú rĩ ní kĩnĩ, “Tã mí ní ꞌyoó ꞌdĩri adri múké ku. Rọ̃bọ̃ŋọ̃ ꞌbá ní lẽé zãá Úpí Múngú ꞌbávé rĩ ní rĩ pi, ꞌbá Ẽjẽpétõ vé rĩ pi ꞌbâ ngụ̃ ãní ũnjí. Dõ ꞌbá zãkí rọ̃bọ̃ŋọ̃ ꞌbá Ẽjẽpétõ vé rĩ pi ní lẽé ku ni nõgó, kộpi ícókí nyo ꞌbâ úvị́ ũdrãá írã sĩ ku? ");
INSERT INTO kbo_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Lẽ ꞌbâ tukí ẹ̃cị̃ caá ụ́ꞌdụ́ na, mụzú ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ꞌbâ zãkí rí rọ̃bọ̃ŋọ̃ Úpí Múngú ꞌbávé rĩ ní, sụ̃ ĩri ní ẹzịị́ ꞌbá ní rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ꞌBãgú rĩ ní ꞌyozú kĩnĩ, “Ma ĩmi ọyụ mụzú rọ̃bọ̃ŋọ̃ zã Úpí Múngú ĩmivé rĩ ní ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãlé rá, ꞌbo lẽ ĩmi mụkí rárá rú ku. Nóni ĩmi zịkí má ní Múngú ri.” ");
INSERT INTO kbo_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mósẽ ní újázú ꞌbãgú rĩ ní kĩnĩ, “Má kãdõ mi kuú, ma koro mụ Úpí Múngú ri zị, drụ̃ sĩ, ụ́nyụ́nyụ́ bị́trị́ká rĩ pi nga mụ rá. Kộpi ĩmi ku mívé ũgalaku rĩ pi be, mívé ꞌbá rĩ pi be rá. ꞌBo lẽ mî ũꞌbã ꞌbâ mị ku, ãzini mî uga ꞌbâ ku, ádarú lẽ mî ọyụ ꞌbâ mụụ́ rọ̃bọ̃ŋọ̃ zãá Úpí Múngú ní rá.” ");
INSERT INTO kbo_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mósẽ ní kúru ꞌbãgú rĩ kuzú ꞌdãgá, ĩri ní mụzú Úpí Múngú ri zịzú, ");
INSERT INTO kbo_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Úpí Múngú ꞌo tã rĩ sụ̃ Mósẽ ní zịị́ rĩ tị́nị. Ụ́nyụ́nyụ́ rĩ pi ní ngazú fũzú ꞌbãgú rĩ vé jó agásĩ, ĩrivé ũgalaku rĩ pi vé jó agásĩ, ĩrivé ꞌbá rĩ pi vé jó agásĩ. Ụ́nyụ́nyụ́ ace ꞌdãlé ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ꞌBo ꞌbãgú rĩ vé ẹ́sị́ gõ áwí teéte, gã ꞌbá rĩ pi ọyụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ mụ ꞌbãgú Ẽjẽpétõ vé rĩ vúgá ꞌdãá, ꞌí ꞌyo ĩri ní, ‘Úpí Múngú Ẽbérẽ rĩ pi vé rĩ kĩnĩ, “Mí ọyụ mávé ꞌbá rĩ pi fũú nõósĩ rá, kộpi ã mụkí ma ị̃njị̃ị́.” ");
INSERT INTO kbo_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Mí gã dõ kộpi ọyụgá sĩ, ");
INSERT INTO kbo_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Úpí Múngú ri drã ũnjí ĩpẽ mívé ãnyãpá rĩ pi úꞌdị́ ũdrã rá. Íꞌdózú mívé hũsánĩ, dõngí, kámĩlõ, tị́, kãbĩlõ, ndrị̃ị́ rĩ pi be, ĩri úꞌdị́ ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ꞌBo Úpí Múngú ri ꞌbá Ĩsẽrélẽ vé rĩ pi vé ãnyãpá gụ̃ túngú, ĩri ꞌbá Ẽjẽpétõ vé rĩ pi vé rĩ gụ̃ túngú, Ĩsẽrélẽ rĩ pi vé ãnyãpá ã ũdrãkí rí ĩndĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Úpí Múngú útú sâ tã ꞌdĩri ꞌozú rĩ gí, Úpí Múngú kĩnĩ, ꞌi tã ꞌdĩri ꞌo drụ̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kã caá drụ̃ ꞌdíni, Úpí Múngú ní tã rĩ ꞌozú sụ̃ ꞌí ní ꞌyoó rĩ tị́nị. ꞌBá Ẽjẽpétõ vé rĩ pi vé ãnyãpá ũdrãkí céré. ꞌBo ꞌbá Ĩsẽrélẽ vé rĩ pi vé rĩ ũdrã kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ꞌBãgú rĩ ní ãgõ ụrụkọ pẽzú mụzú ꞌbá Ĩsẽrélẽ vé rĩ pi vé ãnyãpá rĩ pi ndrezú, kộpi cakí ị́sụ́ ꞌbá Ĩsẽrélẽ vé rĩ pi vé ãnyãpá drã ãluŋáni kuyé. ꞌBo kộpi kâ ímụ́ ũlũú ꞌbãgú rĩ ní, ꞌbãgú rĩ vé ẹ́sị́ áwí nyo teéte, gã ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Úpí Múngú ní ꞌyozú Mósẽ pi ní Ãrónã be kĩnĩ, “Ĩmi úmvúkí úfúrágú ãcí vũrã gá rĩ drị́ sĩ tré tré, Mósẽ ã yĩ úfúrágú rĩ ụrụ ꞌdãá, ꞌbãgú rĩ ã tẽ rí ndreé. ");
INSERT INTO kbo_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Úfúrágú rĩ ꞌi újá ufu fụ́rụ́ndị́ rú, ĩri ayi ãngũ Ẽjẽpétõ vé rĩ agásĩ céré, ĩri ufu ụ̃pị́pịŋá rú, ĩri ꞌbá Ẽjẽpétõ vé rĩ pi ã rụ́ꞌbá ũꞌbã, ĩvé ãnyãpá rĩ pi be, ụ̃pị́pịŋá rĩ pi ũfĩ ku ãzó rú.” ");
INSERT INTO kbo_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kúru kộpi ní úfúrágú ãcí vũrã gá rĩ úmvúzú, kộpi ní ꞌdezú mụzú ꞌbãgú rĩ vúgá ꞌdãá. Mósẽ ní úfúrágú rĩ yĩzú ụrụ ꞌdãá, sẽ ụ̃pị́pịŋá ũꞌbã ꞌbá Ẽjẽpétõ vé rĩ pi ã rụ́ꞌbá, ãnyãpá rĩ pi be, ụ̃pị́pịŋá rĩ pi ũfĩkí kú ãzó rú. ");
INSERT INTO kbo_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Újógú rĩ pi ícókí pá tuú Mósẽ ẹndrẹtị gé bã ku, ãꞌdiãtãsĩyã ụ̃pị́pịŋá rĩ ní kộpi ã rụ́ꞌbá ũꞌbãá kuú ãzó rú, ꞌbá Ẽjẽpétõ vé rĩ pi be rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ꞌBo Úpí Múngú sẽ ꞌbãgú rĩ vé ẹ́sị́ áwí teéte, gã Mósẽ pi vé tã Ãrónã be rĩ yịgá sĩ, sụ̃ Úpí Múngú ní ándúrú ꞌyoó Mósẽ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Drụ̃ sĩ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, ꞌí kpu mụzú ꞌbãgú rĩ vúgá ꞌdãá, ꞌí ꞌyo ĩri ní, Úpí Múngú ꞌbá Ẽbérẽ vé rĩ pi ní rií ị̃njị̃ị́ rĩ kĩnĩ, ‘Mí ọyụ mávé ꞌbá rĩ pi fũú nõósĩ rá, kộpi ã mụkí rí ma ị̃njị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mí gã dõ kộpi ọyụgá sĩ, ma wọ̃nyọ́kị́ ũnjí ĩpẽ mí drị̃gé, mívé ũgalaku rĩ pi drị̃gé, ãzini ꞌbá mívé ãngũ agá rĩ pi drị̃gé, mî nị̃ rí ꞌyozú kínĩ, ꞌbá ãzi sụ̃ụ́pi má tị́nị vũ drị̃gé nõgó ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mâ ẹ́sị́ ã lẽ té dõ nĩ, ma mávé ũkpõ lũ, ma té drã ị̃wọ̃nyọ̃ mí ní, ãzini mívé ꞌbá rĩ pi ní, ĩmi té ũdrã mívé ꞌbá rĩ pi be vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ꞌBo tã má ní mi kuzú adrizú ídri rú rĩ, mî nị̃ rí mávé ũkpõ ámá ãní, mâ rụ́ ã kụ rí ayií mụzú vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ꞌBo mi drĩ ri pá tu tị́tị́ ꞌbá mávé rĩ pi drị̃gé, mí gã kộpi ọyụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Drụ̃ sĩ sâ nõri tị́nị rĩ gé, ma fí ụ̃kụ ni ꞌdeépi Ẽjẽpétõ agá nõgó kuyé ni sẽ ꞌde ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ꞌÍ sẽ tãị́mbị́ mívé ũgalaku rĩ pi ní, kộpi ã mụkí ĩvé ãnyãpá rĩ pi íjị́ ꞌbá rĩ pi be ápãlá ã ndụ́gé nõó mbẽlẽ, ãꞌdiãtãsĩyã íjị́kí dõ ꞌbá rĩ pi ãnyãpá rĩ pi be kuyé, fí ri ímụ́ ꞌde, ĩri kộpi gbã ũdrã rá!’ ” ");
INSERT INTO kbo_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ꞌBãgú rĩ vé ũgalaku rĩ pi ã ụrụkọ ãꞌyĩkí átángá Úpí Múngú ní ꞌyoó Mósẽ tị gé rĩ rá, koro kộpi njukí mụụ́ ĩvé tụ́gẹ̃rị̃ rĩ pi íjị́ ãnyãpá rĩ pi be ápãlá ã ndụ́gé nõó. ");
INSERT INTO kbo_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ꞌBo ꞌbá gãꞌbá tã Úpí Múngú ní ꞌyoó rĩ yịgá sĩ rĩ pi, kukí ĩvé tụ́gẹ̃rị̃ rĩ pi, ãnyãpá rĩ pi be kú ãmvé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Mí inga mívé túré suú ụrụ ꞌdãá, fí ã ꞌde rí ãngũ Ẽjẽpétõ vé rĩ agásĩ céré, fí rĩ ã gbã rí ꞌbá Ẽjẽpétõ vé rĩ pi, ĩvé ãnyãpá rĩ pi be, ngá ọ́mvụ́ agá rĩ pi be céré.” ");
INSERT INTO kbo_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mósẽ kã ívé túré rĩ ingaá suú ụrụ ꞌdãá, Úpí Múngú ní fí ĩpẽzú ũvi be, ãngũ rĩ ga lọ́kụ́ ụrụ ꞌdãá cĩmgbá ícázú vũgá nõó. Úpí Múngú ĩpẽ fí ꞌdeé ãngũ Ẽjẽpétõ vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Fí rĩ ꞌde, ãngũ rĩ ga lọ́kụ́lọ́kụ́. Ũlí vịị́pi ũkpõ be ꞌdãri, ị́nọ́gọ́sị́ ni vị drĩ ãngũ Ẽjẽpétõ vé rĩ agá kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Fí ꞌdeépi ꞌdãri gbã ꞌbá Ẽjẽpétõ vé rĩ pi ãnyãpá rĩ pi be ũnjí ũnjí, gbã kộpivé ngá ọ́mvụ́ agá rĩ pi rúwí rúwí, gbã pẹtị rĩ pi ũŋõó vũgá. ");
INSERT INTO kbo_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Vũrã fí rĩ ní ꞌdezú kuyé rĩ ꞌyéŋá Gõsénĩ vé rĩ. Gõsénĩ ri vũrã ꞌbá Ĩsẽrélẽ vé rĩ pi ní adrizú rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ꞌBãgú rĩ ní tị pẽzú Mósẽ pi vú sĩ Ãrónã be. Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ẹ̃ndẹ́pị á ꞌo ũnjí, tã Úpí Múngú vé rĩ ĩri pịrị, ma ꞌbá mávé rĩ pi be, tã ꞌbá ní ꞌoó rĩ adri pịrị kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ĩmi zịkí Úpí Múngú ri, fí ꞌdeépi ũvi be ꞌdĩri ã tu pá rá. Ma ĩmi ọyụ fũ mụzú rá, ĩmi gõkí adrií nõgó dị̃ị́ ku.” ");
INSERT INTO kbo_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mósẽ ní újázú ĩri ní kĩnĩ, “Má kãdõ fũú kụ̃rụ́ rĩ agá nõósĩ, ma koro mụ Múngú ri mã drị́ ị̃rị̃ sĩ, ma ĩri zị, ũvi rĩ pá tu rá, fí rĩ vé ꞌdengárá, ĩri kpá pá tu rá. Mi kúru nị̃ ámá ꞌyozú kínĩ, vũ nõri ẹ̃ndẹ́pị Úpí Múngú vé ni. ");
INSERT INTO kbo_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ꞌBo á nị̃ rá, mi mívé ũgalaku rĩ pi be, ĩmi rukí Úpí Múngú ri kuyé.” ");
INSERT INTO kbo_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Fí rĩ gbã ngá ĩ ní saása rĩ pi rúwí rúwí, ị́sụ́zú ụrụkọꞌbée ũꞌa be, ụrụkọꞌbée zokí fũ gí. ");
INSERT INTO kbo_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ꞌBo fí rĩ gbã ũndú rĩ pi kuyé, ãꞌdiãtãsĩyã ũndú rĩ pi kakí vúlé rú. ");
INSERT INTO kbo_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mósẽ ní kúru ꞌbãgú rĩ kuzú, ĩri ní ꞌdezú fũzú kụ̃rụ́ rĩ agásĩ ãmvé, ĩri ní Úpí Múngú ri mãzú drị́ ị̃rị̃ sĩ, ĩri ní Múngú ri zịzú, ũvi rĩ vé gangárá, ãzini fí rĩ vé ꞌdengárá ní pá tuzú, yị̃ị́gọ́ rĩ ní ãtĩzú. ");
INSERT INTO kbo_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ꞌBãgú rĩ kã ndreé yị̃ị́gọ́ rĩ vé ꞌdịngárá, fí rĩ vé ꞌdengárá, ãzini ũvi rĩ vé gangárá tu pá gí, ꞌbãgú rĩ pi ívé ũgalaku rĩ pi be, kộpi gõkí ꞌdeé rií ũnjĩkãnyã ꞌoó dị̃ị́, kộpi ẽ ẹ́sị́ gõ teéte. ");
INSERT INTO kbo_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ꞌBãgú rĩ gã ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụgá sĩ, sụ̃ Úpí Múngú ní ándúrú ꞌyoó Mósẽ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ gõ mụụ́ ꞌbãgú rĩ vú ꞌdãá, á ꞌo ꞌbãgú rĩ vé ẹ́sị́ teéte, ívé ũgalaku rĩ pi be gí, mâ ꞌo rí tã ãyãzú ãyãyã ni pi ãní kộpi ãsámvú gé, ");
INSERT INTO kbo_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","tã má ní ꞌoó ãyãzú ãyãyã ꞌbá Ẽjẽpétõ vé rĩ pi ãsámvú gé kộpi ĩrĩŋãzú ꞌdĩri, ĩmi ũlũkí rí úꞌdógúꞌdógú ni ĩmivé anjiŋá rĩ pi ní, ãzini kộpivé anjiŋá rĩ pi ní, ĩmi nị̃kí rí ꞌyozú kínĩ, ma Úpí Múngú ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kúru Mósẽ pi ní ꞌdezú mụzú Ãrónã be ꞌbãgú rĩ vũgá ꞌdãá, kộpi ní ꞌyozú ꞌbãgú rĩ ní kínĩ, “Úpí Múngú Ẽbérẽ rĩ pi ní rií ị̃njị̃ị́ rĩ kĩnĩ, ‘Ngá sẽépi mî drị̃ ní adrizú ũkpó ũkpó, mí ní ma ị̃njị̃zú ku rĩ ãꞌdi? Mí ọyụ ꞌbá mávé rĩ pi mụụ́, kộpi ã mụkí rí ma ị̃njị̃ị́ bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ꞌÍ gã dõ kộpi ọyụgá sĩ, ꞌí ndre múké! Drụ̃ sĩ, ma úmbí ĩpẽ mívé ãngũ agá. ");
INSERT INTO kbo_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kộpi nyọ̃ọ́kụ́ rĩ ẽ drị̃ ĩmũlũ céré. Kộpi mívé ngá ẽ ị̃mbị́tã fí ní izaá kuyé rĩ nya ngá ọ́mvụ́ agá rĩ pi be céré. ");
INSERT INTO kbo_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Kộpi ĩ tõ ĩmivé jó agásĩ, ũgalaku rĩ pi vé jó agásĩ, ꞌbá Ẽjẽpétõ vé rĩ pi vé jó agásĩ céré, úmbí ímụ́pi ꞌdeépi ꞌdĩri, ụ̃kụ ni ꞌde drĩ ãngũ Ẽjẽpétõ vé rĩ agá ꞌdíni kuyé, íꞌdózú lókí ĩmi ẹ́ꞌbị́pị́ị ní rizú adrizú ãngũ rĩ agá rĩ gé.’ ” Kúru Mósẽ ní ꞌi újázú, ĩri ní ꞌdezú mụzú ꞌbãgú rĩ ẹndrẹtị gé ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ꞌBãgú rĩ vé ũgalaku rĩ pi ní ꞌyozú ꞌbãgú rĩ ní kínĩ, “Mí lẽ ꞌbâ nyakí ĩzãngã rĩ ágó ꞌdĩri drị́gé caá gbụ ngọ̃tụ́? Mí ọyụ ꞌbá Ĩsẽrélẽ vé rĩ pi mụụ́ ꞌdĩísĩ rá, kộpi ã mụkí rí ĩvé Úpí Múngú ri ị̃njị̃ị́. Mí nị̃ kuyé ꞌyozú kínĩ, Ẽjẽpétõ ábá gí?” ");
INSERT INTO kbo_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kúru ũgalaku rĩ pi ní Mósẽ pi zịzú Ãrónã be ĩgõzú ꞌbãgú rĩ vúgá nõlé, ꞌbãgú rĩ ní ꞌyozú kộpi ní kĩnĩ, “Múké, ĩmi ícó mụ ĩmivé Úpí Múngú ri ị̃njị̃ rá. ꞌBo ꞌí lũ má ní, ãꞌdi pi mụ nĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mósẽ ní újázú ꞌbãgú rĩ ní kĩnĩ, “ꞌBâ mụ ꞌbávé anjiŋá rĩ pi be, ꞌbá ãká rú rĩ pi be, anji ãgõ rĩ pi be, anji ũkú rĩ pi be, kãbĩlõ rĩ pi be, ndrị̃ị́ rĩ pi be, tị́ rĩ pi be, ãꞌdiãtãsĩyã ꞌbâ mụ ụ̃mụ̃ údé Úpí Múngú ri ị̃njị̃zú.” ");
INSERT INTO kbo_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ꞌBãgú rĩ ní ꞌyozú kĩnĩ, “Má ọyụ dõ ĩmi mụụ́ ĩmivé ũkú rĩ pi be, anjiŋá rĩ pi be gí, Úpí Múngú ã adri ĩmi be! Tã ĩmi ní rií ụ̃sụ̃ụ́ rĩ adri múké ku. ");
INSERT INTO kbo_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Á lẽ ku ĩmi ní mụzú céré! Á lẽ ꞌyéŋá ãgõ rĩ pi ã mụkí nĩ, kộpi ã mụkí rí Úpí Múngú rĩ ị̃njị̃ị́ sụ̃ mí ní zịị́ rĩ tị́nị.” Kúru ꞌbãgú rĩ ní Mósẽ pi drozú fũzú Ãrónã be ꞌí andregá sĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Mí inga mívé túré suú ãngũ Ẽjẽpétõ vé rĩ drị̃gé ꞌdãá, úmbí ẽ ĩmũlũ rí ãngũ rĩ, kộpi ã nyakí rí ngá ọ́mvụ́ agá rĩ pi, ãzini ngá ị̃mbị́tã fí ní gbãá kuyé rĩ pi céré ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kúru Mósẽ ní ívé túré ingazú suzú ãngũ Ẽjẽpétõ vé rĩ drị̃gé ꞌdãá, Úpí Múngú ní ũlí ĩpẽzú ãngũ rĩ agá ụ̃tụ́ ní ĩfũngárá gálésĩla, ũlí rĩ vị ụ̃tụ́ njị̃ị́, ị́nị́ŋá be rã. Kã mụụ́ caá ụ̃ꞌbụ́tịŋá gá, ị́sụ́ ũlí rĩ ívị́ úmbí rĩ pi íjị́ gí. ");
INSERT INTO kbo_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Úmbí rĩ ꞌde, ĩmũlũ ãngũ Ẽjẽpétõ vé rĩ ẽ drị̃ céré. Úmbí ꞌdeépi ꞌdãri, ụ̃kụ ni ꞌde drĩ ꞌdáni kuyé, gõ kpá ꞌdeé dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Úmbí rĩ pi ĩmũlũkí ãngũ rĩ nịị́ kuú gị̃. Kộpi nyakí ngá ẽ ị̃mbị́tã fí rĩ ní gbãá kuyé ọ́mvụ́ agásĩ rĩ pi, pẹtị ũꞌa rĩ pi be céré, ngá ọ́mvụ́ agá rĩ pi, pẹtị rĩ pi be, kộpi ẽ bị́ gõ adrií ꞌdãáyo ãngũ Ẽjẽpétõ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Koro ꞌbãgú rĩ ní Mósẽ pi zịzú ímụ́zú Ãrónã be. Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Á ꞌo ũnjí Úpí Múngú ĩmivé rĩ ẹndrẹtị gé, ãzini ĩmi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ĩmi trũkí ma mávé ũnjĩkãnyã agásĩ dị̃ị́, ĩmi zịkí má ní Úpí Múngú ĩmivé rĩ, ã ꞌdụ rí wọ̃nyọ́kị́ ũnjí nõri mâ rụ́ꞌbá gá sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kúru Mósẽ ní ꞌbãgú rĩ kuzú, ĩri ní mụzú Úpí Múngú ri zịzú. ");
INSERT INTO kbo_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Úpí Múngú ní ũlí rĩ újázú, ũlí rĩ gõ íꞌdó vịị́ ũkpõ be ụ̃tụ́ ní ꞌdengárá gálésĩla, gõ úmbí rĩ pi vịị́ mụzú Yị̃ị́ Tafu Ika rĩ gé ꞌdãá. Úmbí ace ãluŋáni ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ꞌBo Úpí Múngú sẽ ꞌbãgú rĩ vé ẹ́sị́ gõ teéte, gã ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ su mî drị́ ꞌbụ̃ gé ꞌdãá, ãngũ Ẽjẽpétõ vé rĩ ã bĩ rí nịị́ kuú cịcị, ꞌbá ãzi ã ndre rí ãngũ ãní ku.” ");
INSERT INTO kbo_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kúru Mósẽ ní ꞌî drị́ suzú ꞌbụ̃ gé ꞌdãá, ãngũ rĩ ní bĩzú nịzú cịcị, ꞌdụ caá ụ́ꞌdụ́ na, ãngũ Ẽjẽpétõ vé rĩ agá sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ꞌBá ãzi ndre ọ́gụ́pị ã rụ́ꞌbá ku, ꞌbá ãzi tu ẹ̃cị̃ ku. ꞌBo vũrã ꞌbá Ĩsẽrélẽ vé rĩ pi ní adrizú rĩ gé, ãngũ rĩ ụ̃tụ́ŋá rú. ");
INSERT INTO kbo_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kúru ꞌbãgú rĩ ní Mósẽ ri zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kĩnĩ, “Ĩmi mụkí Úpí Múngú ri ị̃njị̃ị́ ĩyí. Ĩmi ícó mụ ĩmivé ũkú rĩ pi be, anjiŋá rĩ pi be rá, ꞌbo ĩmi kukí ĩmivé kãbĩlõ rĩ pi, ndrị̃ị́ rĩ pi, tị́ rĩ pi be adrií nõgó.” ");
INSERT INTO kbo_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ꞌBo Mósẽ ní ꞌyozú kĩnĩ, “Mí ọyụ ꞌbá ní ãnyãpá rĩ pi, ꞌbâ jịkí rí zãá ꞌbávé Úpí Múngú ní rọ̃bọ̃ŋọ̃ rú. ");
INSERT INTO kbo_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ꞌBâ ꞌbávé ãnyãpá rĩ pi jị céré mụzú ĩndĩ, ꞌbá ícókí ãzi ni kuú vúlé ku. ꞌBâ ụrụkọꞌbée zã ꞌbávé Úpí Múngú ri ị̃njị̃zú ãní, ꞌbo ꞌbá nị̃kí drĩ kuyé, ꞌbâ ãnyãpá ngõri zã Múngú ní rọ̃bọ̃ŋọ̃ rú, cĩmgbá ꞌbá ní cazú ꞌdãlé rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ꞌBo Úpí Múngú sẽ ꞌbãgú rĩ vé ẹ́sị́ gõ teéte, ꞌbãgú rĩ gã kộpi ọyụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ꞌBãgú rĩ ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ dẹ̃ mi má ẹndrẹtị gé ꞌdĩísĩ rá! Mî nị̃ múké, lẽ mî gõ índré má ẹndrẹtị gé dị̃ị́ ku! ꞌÍ gõ dõ ímụ́ má vúgá nõó dị̃ị́, mi drã rá!” ");
INSERT INTO kbo_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mósẽ ní újázú ĩri ní kĩnĩ, “Ĩri múké, sụ̃ mí ní ꞌyoó rĩ tị́nị, má ícó índré mí ẹndrẹtị gé dị̃ị́ ku!” ");
INSERT INTO kbo_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Á lẽ wọ̃nyọ́kị́ ãzi ũnjí ni ĩpẽé ãlu ꞌbãgú rĩ drị̃gé, ívé ꞌbá Ẽjẽpétõ agá rĩ pi be. Tã ꞌdĩri ã vụ́drị̃ gé, ꞌbãgú rĩ ĩmi ọyụ mụzú rá. Ĩri ĩmi dro fũ ãngũ rĩ agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ꞌÍ mụ lũú ãgõ Ĩsẽrélẽ vé rĩ pi ní, ãzini ũkú rĩ pi ní kínĩ, kộpi ã mụkí ngá ĩ ní údé aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni pi sĩ, ãzini dábũ sĩ ni pi zịị́ ꞌbá adriꞌbá ĩvé jó gãrã gá rĩ pi vúgá.” ");
INSERT INTO kbo_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Úpí Múngú sẽ ꞌbá Ẽjẽpétõ vé rĩ pi ị̃njị̃kí ꞌbá Ĩsẽrélẽ vé rĩ pi ị̃njị̃njị̃. Mósẽ ri Ẽjẽpétõ gá ꞌdãá ꞌbá ãmbúgú, ꞌbãgú rĩ vé ũgalaku rĩ pi ꞌbá Ẽjẽpétõ vé rĩ pi be, ị̃njị̃kí ĩri ị̃njị̃njị̃. ");
INSERT INTO kbo_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kúru Mósẽ ní ꞌyozú ꞌbãgú rĩ ní kĩnĩ, “Úpí Múngú kĩnĩ, ‘Kãdõ mụụ́ caá ị́nị́ŋá ágágá, ma ẹlị mụzú ãngũ Ẽjẽpétõ vé rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Anji ãgõ ꞌbá Ẽjẽpétõ vé rĩ pi ní tịị́ kãyú rĩ pi céré ímụ́ ũdrã rá, ꞌbãgú rĩ vé mvá kãyú ímụ́pi úrípi lúpá mãlũngã vé rĩ drị̃gé rĩ íꞌdó drã nĩ, anji kãyú rĩ pi ũdrã cĩmgbá cazú tụ́gẹ̃rị̃ riípi ngá ꞌyịị́pi rĩ vé mvá ágó kãyú rĩ vúgá, ãzini ꞌbá Ẽjẽpétõ vé rĩ pi vé ãnyãpá rĩ pi vé anji ãgõ kãyú rĩ pi kpá céré ímụ́ ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ãngũ Ẽjẽpétõ vé rĩ agásĩ céré, ꞌbá rĩ pi ímụ́ lụ̃ụ́lụ́ ga, lụ̃ụ́lụ́ ĩ ní ímụ́ gaá ꞌdĩri, ụ̃kụ ni gakí drĩ ãngũ Ẽjẽpétõ vé rĩ agá kuyé, ꞌbo lụ̃ụ́lụ́ sụ̃ ꞌdĩri tị́nị ícókí gõó gaá dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ꞌBo ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé ꞌdãá, ãngũ rĩ újí ku kíri, ũcógú ágbó ꞌbá ãzi sĩ ku, dõku ágbó ãnyãpá sĩ ku.’ Kúru ĩmi ícó nị̃ ámá ꞌyozú kínĩ, Úpí Múngú ri ẹ́sị́ múké ꞌbã ꞌbá Ĩsẽrélẽ vé rĩ pi ní, ĩmi ꞌbá Ẽjẽpétõ vé rĩ pi, ĩri ĩmi ĩrĩŋã rá. ");
INSERT INTO kbo_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ũgalaku Ẽjẽpétõ vé rĩ pi ãrẽvú céré ímụ́ kũmũcí ũtị̃ má ẹndrẹtị gé, kộpi ma mã drị́ ị̃rị̃ sĩ, kộpi ꞌyo, mâ jị mávé ꞌbá rĩ pi mụzú. Tã ꞌdĩri ã vụ́drị̃ gé, ma kúru ꞌde mụ.” Jĩkó ní ꞌdeé Mósẽ agá rĩ sĩ, ĩri ní ꞌbãgú rĩ kuzú, ĩri ní fũzú mụzú ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Úpí Múngú ꞌyo ándúrú Mósẽ ní kĩnĩ, “ꞌBãgú rĩ ícó ĩmi yịị́ ku. Kúru ĩri sẽ ma tã ãyãzú ãyãyã ni pi ꞌo tré ãngũ Ẽjẽpétõ vé rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mósẽ pi Ãrónã be ꞌokí tã ãyãzú ãyãyã ꞌdĩꞌbée céré ꞌbãgú rĩ ẹndrẹtị gé rá, ꞌbo Úpí Múngú sẽ ꞌbãgú rĩ ẹ́sị́ gõ teéte, lẽ ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụụ́ fụụ́ ívé ãngũ Ẽjẽpétõ vé rĩ agásĩ ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ pi ní Ãrónã be Ẽjẽpétõ gá ꞌdãlé kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mbãá nõri ĩri adri ĩmi ní mbãá ĩmi ní íꞌdózú ĩmivé ílí lãzú rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mí áyú ꞌbá Ĩsẽrélẽ vé rĩ pi ní céré kínĩ, ụ́ꞌdụ́ mụdrị́ mbãá nõri vé rĩ gé, ꞌbẹ̃tị́ ãlu ãlu ẽ íꞌdụ́ kãbĩlõ mvá dõku ndrị̃ị́ mbaápi fõlõ ni. ");
INSERT INTO kbo_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Dõ ꞌbá rĩ pi vé kãlãfe ꞌbẹ̃tị́ ꞌdĩgé rĩ mãdãŋá, ícókí kãbĩlõ rĩ nyaá dẹẹ́ céré ku, kộpi ã úmúkí ĩ ꞌbẹ̃tị́ ãzi ĩnyiŋáŋá ni be, kộpi ẽ ĩpẽkí kãbĩlõ ĩ ní ícó nyaá céré rá ni. ");
INSERT INTO kbo_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ãnyãpá ĩmi ní ĩpẽé rĩ ã adri kãbĩlõ ágó, dõku ndrị̃ị́ ágó adriípi ílí be ãlu, rụ́ꞌbá be múké ni. ");
INSERT INTO kbo_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ĩmi ũtẽkí kộpi múké cĩmgbá cazú ụ́ꞌdụ́ mụdrị́ drị̃ ni sụ mbãá ꞌdĩri vé rĩ agá, kúru ꞌbẹ̃tị́ ãlu ãlu Ĩsẽrélẽ vé rĩ pi ã úlị́kí kãbĩlõ rĩ pi ndrị̃ị́ rĩ pi be, ụ̃tụ́ rĩ ní ꞌdengárá gá nyã rĩ gé ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kộpi ẽ íꞌdụ́kí kãbĩlõ rĩ vé ãrí, dõku ndrị̃ị́ rĩ vé ãrí ũbẽé jó kộpi ní ngá nyazú rĩ vé kẹ̃ẹ́tị ẽ ẹ̃rị̃fe ị̃rị̃ ꞌdĩꞌbée ã rụ́ꞌbá gá sĩ, ãzini ụrụ rĩ ã rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ị́nị́ŋá ãlu ãlu ꞌdãri sĩ, kộpi ã úzókí kãbĩlõ rĩ vé zãá, dõku ndrị̃ị́ rĩ vé zãá úzózõ, ã nyakí pánga ĩ ní áꞌdí ãkụ́fị́ ãkó ni sĩ, tị́bị́ nị̃ị́ draápi dradra ni sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ã nyakí zãá rĩ ụ́bụ̃rụ́ ku, dõku ã áꞌdíkí áꞌdí ãꞌdi ku. Ã úzókí céré úzózõ, drị̃ ni pi, pá ni pi, fí ni pi, úgú ni pi be céré ã úzókí úzózõ. ");
INSERT INTO kbo_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ã kukí zãá rĩ ẽ ị̃mbị́tã caá drụ̃ ụ̃ꞌbụ́tịŋá gá ku. Zãá rĩ ẽ ị̃mbị́tã ace dõ rá, ã zãkí veé ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ĩmi kãdõ rií ínyá rĩ nyaá, ĩmi trakí ĩmivé bõngó akoó rụ̃kụ̃ rĩ pi úsú ĩmivé gõ rụ́ꞌbá gá, ĩmi úsúkí mọ̃rọ̃kụ́ ĩmi pá gá, ĩmi íꞌdụ́kí ĩmivé túré rụụ́ kuú ĩmi drị́gé. Ĩmi nyakí ínyá rĩ mbẽlẽ mbẽlẽ, Ụ́ꞌdụ́ ꞌdĩri Úpí Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ị́nị́ŋá ãlu ãlu ꞌdãri sĩ, ma ímụ́ ẹlị trãá ãngũ Ẽjẽpétõ vé rĩ agásĩ, ma ꞌbá Ẽjẽpétõ vé rĩ pi vé anji ãgõ tịlé kãyú rĩ pi úꞌdị́ ãnyãpá ãgõ kãyú rĩ pi be céré, ma múngú Ẽjẽpétõ vé rĩ pi ĩrĩŋã rá, ãꞌdiãtãsĩyã ma Úpí Múngú ꞌi. ");
INSERT INTO kbo_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ãrí ĩmi ní ũbẽé kẹ̃ẹ́tị ẹ̃rị̃fe gá sĩ rĩ pi, ĩri lũ ꞌyozú kínĩ, jó ĩmi ní rizú adrizú rĩ pi ꞌdĩ. Má kãdõ ãrí ĩmi ní ũbẽé rĩ ndreé, ma ẹlị ĩmi drị̃gé sĩ. Má kãdõ ꞌbá Ẽjẽpétõ vé rĩ pi vé anji ãgõ kãyú rĩ pi úꞌdị́, má ícó ĩmivé anji ãgõ úꞌdị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ụ́ꞌdụ́ ꞌdĩri lẽ ĩmi ꞌbãkí tã ni kú ĩmi drị̃gé, ílí ãlu ãlu, lẽ úyú ĩmivé rĩ pi ã rikí ụ̃mụ̃ ꞌdĩri nyaá Úpí Múngú ri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ụ́ꞌdụ́ ẹ́zị̂rị̃, lẽ ĩmi nyakí pánga ĩ ní áꞌdílé ãkụ́fị́ ãkó ni áyu. Ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩꞌbée vé íꞌdóngárá gá, lẽ ĩmi uꞌdụkí ãkụ́fị́ ĩmivé jó agá rĩ pi céré ãmvé, ꞌbá pánga ãkụ́fị́ be ni nyaápi ãkã ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá rĩ, ĩ ĩri gụ̃ ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé sĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ụ́ꞌdụ́ ãlu rĩ gé, lẽ ĩmi úmúkí ĩmi trụ́ Múngú ri ị̃njị̃ị́, ãzini ụ́ꞌdụ́ ẹ́zị̂rị̃ rĩ gé, lẽ ĩmi úmúkí ĩmi trụ́ Úpí Múngú ri ị̃njị̃ị́. Ụ́ꞌdụ́ ị̃rị̃ ꞌdĩꞌbée agá, lẽ ꞌbá ãzi ã nga ẹ̃zị́ ku. Ngá ĩmi ní ícó ꞌoó rá rĩ, ꞌyéŋá ĩmi ínyá áꞌdí áyu. ");
INSERT INTO kbo_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Ĩmi údékí ụ̃mụ̃, ĩmi áꞌdíkí pánga ãkụ́fị́ ãkó ni ĩmi nyakí, ĩmi ígákí rí ụ́ꞌdụ́ má ní ĩmi íjị́zú ĩfũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ ꞌdãri ãní. Ụ̃mụ̃ ꞌdĩri ĩmi nyakí ĩri mụzú ílí ãlu ãlu vú sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mbãá ílí rĩ ní íꞌdózú rĩ vé ụ́ꞌdụ́ kãdõ caá mụdrị́ drị̃ ni sụ rĩ vé ũndréŋá gá, ĩmi nyakí pánga áꞌdílé ãkụ́fị́ ãkó ni cĩmgbá cazú ụ́ꞌdụ́ pụ̃kụ́ ị̃rị̃ drị̃ ni ãlu vé ũndréŋá gá. ");
INSERT INTO kbo_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá, lẽ ẽ ị́sụ́kí ãkụ́fị́ jó ĩmivé rĩ pi agásĩ ku. ꞌBá pánga ãkụ́fị́ be ni nyaápi ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá ãkã rĩ, dõ ĩri Ĩsẽrélẽgú yã dõku jãkã yã, ĩ ĩri gụ̃ ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé sĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vũrã céré ĩmi ní adrizú rĩ pi gé sĩ, ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá, ꞌbá ãzi ã nya ngá ãkụ́fị́ be ni ku, ã nyakí pánga áꞌdílé ãkụ́fị́ ãkó ni áyu.” ");
INSERT INTO kbo_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kúru Mósẽ ní ꞌbá ambugu Ĩsẽrélẽ vé rĩ pi zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ꞌbẹ̃tị́ ãlu ãlu ẽ ĩpẽ ãnyãpá ĩ ní lẽé úlị́ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ĩmi ꞌbãkí kãbĩlõ rĩ pi vé ãrí, dõku ndrị̃ị́ rĩ pi vé ãrí raá ĩgãŋá agá, ĩmi íꞌdụ́kí ị̃bị́bị́, ĩmi sukí ãrí rĩ agá ꞌdãá, ĩmi ũbẽkí ãrí rĩ kẹ̃ẹ́tị ẽ ẹ̃rị̃fe ị̃rị̃ ꞌdĩꞌbée ã rụ́ꞌbá gá sĩ, ãzini ụrụ rĩ ã rụ́ꞌbá gá. ꞌBá ãzi ẽ ĩfũ ívé jó agásĩ ãmvé ku cĩmgbá ụ̃ꞌbụ́tịŋá gá. ");
INSERT INTO kbo_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Úpí Múngú kãdõ ẹlịị́ mụụ́ ãngũ Ẽjẽpétõ vé rĩ agásĩ, rií ꞌbá Ẽjẽpétõ vé rĩ pi úꞌdị́, ĩri ãrí ĩmi ní ũbẽé kẹ̃ẹ́tị ẹ̃rị̃fe ụrụ rĩ ã rụ́ꞌbá gá, ãzini ẹ̃rị̃fe ị̃rị̃ ꞌdĩꞌbée ã rụ́ꞌbá gá rĩ ndre. Mãlãyíkã Múngú ní ímụ́ ĩpẽé ãngũ úꞌdị́pi rĩ ícó fií ĩmivé jó agá ĩmivé anji ãgõ kãyú rĩ pi úꞌdị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Tã má ní ũlũú ĩmi ní ꞌdĩri, lẽ ĩmi ꞌdụkí tã ni ngaá mụzú nyonyo, íꞌdózú ĩmi vúgá, cazú ĩmivé úyú rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ĩmi kádõ caá ãngũ Úpí Múngú ní ẹzịị́, ĩri ní lẽé sẽé ĩmi ní rĩ gé ꞌdãá, lẽ ĩmi rikí ụ̃mụ̃ rĩ vé tã ꞌoó mụzú dị̃ị́ dị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Anji ĩmivé rĩ pi zịkí dõ ĩmi kínĩ, ‘Ụ̃mụ̃ ꞌbá ní rií ꞌoó nõri vé ífífí ãꞌdi?’ ");
INSERT INTO kbo_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ĩmi ũlũkí kộpi ní ꞌdíni, ‘ꞌBâ ri ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ nya Úpí ri ị̃njị̃zú, Úpí Múngú kã rií ꞌbá Ẽjẽpétõ vé rĩ pi úꞌdị́, ẹlị ꞌbá Ĩsẽrélẽ vé adriꞌbá Ẽjẽpétõ agá rĩ pi vé jó drị̃gé sĩ, úló ꞌbá ãzi ã rụ́ꞌbá ãluŋáni kuyé.’ ” ꞌBá rĩ pi kâ tã Mósẽ ní ũlũú rĩ yịị́, kộpi ní drị̃ sị̃zú Múngú ri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ꞌBá Ĩsẽrélẽ vé rĩ pi ꞌdụkí tã rĩ ngaá sụ̃ Úpí Múngú ní ẹzịị́ Mósẽ pi ní Ãrónã be rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kã adrií ị́nị́ŋá ágágá, Úpí Múngú ní ꞌbá Ẽjẽpétõ vé rĩ pi vé anji ãgõ kãyú rĩ pi úꞌdị́zú, íꞌdó ꞌbãgú mãlũngã rụụ́pi rĩ vé mvá ágó kãyú rĩ ꞌdịị́ drãá, úꞌdị́ anji ãgõ kãyú rĩ pi cĩmgbá cazú ꞌbá ĩ ní ꞌyĩí kuú ꞌbụ́ agá rĩ vé mvá ágó kãyú rĩ vúgá, ãzini úꞌdị́ ãnyãpá rĩ pi vé anji tịlé kãyú rĩ pi ũdrãá céré. ");
INSERT INTO kbo_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ị́nị́ŋá ꞌdãri sĩ, ꞌbãgú rĩ ívé ũgalaku rĩ pi be, ꞌbá Ẽjẽpétõ vé rĩ pi be arukí ụ́ꞌdụ́ gélésĩ, kộpi ní íꞌdózú lụ̃ụ́lụ́ gazú ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãá, ãꞌdiãtãsĩyã ꞌbẹ̃tị́ ãzi ãvũ ní drãá ꞌa ni gé kuyé ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ị́nị́ŋá ꞌdãri sĩ, ꞌbãgú rĩ ní Mósẽ pi zịzú Ãrónã be ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kĩnĩ, “Ĩmi ĩmivé ꞌbá ĩsẽrélẽ vé rĩ pi be, ĩmi ngakí fũú mávé ꞌbá rĩ pi ãsámvú gé sĩ ꞌdĩísĩ rá, ĩmi mụkí ĩmivé Úpí Múngú ĩmi ní tã ni zịị́ má tị gé rĩ ị̃njị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ĩmi ꞌdụkí ĩmivé kãbĩlõ, ndrị̃ị́, tị́ rĩ pi be céré mụzú ĩndĩ. ꞌBo ĩmi kukí má ní tãkíri ũgbále.” ");
INSERT INTO kbo_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ꞌBá Ẽjẽpétõ vé rĩ pi ní ꞌyozú ꞌbá Ĩsẽrélẽ vé rĩ pi ní kínĩ, “Ĩmi fũkí ꞌbávé ãngũ agásĩ mbẽlẽ mbẽlẽ, ĩmi fũkí dõ kuyé, ꞌbâ céré ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kúru ꞌbá Ĩsẽrélẽ vé rĩ pi ní fúndru ĩ ní usaá yị̃ị́ sĩ, ĩ ní drĩ ãkụ́fị́ yĩí ꞌa ni gé kuyé ni íꞌdụ́zú ũdãzú lãálã rĩ pi agásĩ, kộpi ní lãálã rĩ pi úmbézú bõngó sĩ, kộpi ní uꞌdụzú ꞌbãzú ĩ kị́dị́ gé, kộpi ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ꞌBá Ĩsẽrélẽ vé rĩ pi ꞌdụkí tã rĩ ngaá sụ̃ Mósẽ ní ũlũú ĩ ní rĩ tị́nị, kộpi zịkí ngá ĩ ní údé dábũ sĩ ni pi, aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ sĩ ni pi, bõngó ũnyĩ be ni pi be ꞌbá Ẽjẽpétõ vé rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Úpí Múngú sẽ ꞌbá Ẽjẽpétõ vé rĩ pi ꞌbãkí ẹ́sị́ múké ꞌbá Ĩsẽrélẽ vé rĩ pi ní, kộpi sẽkí ngá ꞌbá Ĩsẽrélẽ vé rĩ pi ní zịị́ rĩ pi rá, sâ kộpi ní fũzú Ẽjẽpétõ agásĩ rĩ gé, kộpi ꞌdụkí ãꞌbú Ẽjẽpétõ vé rĩ pi mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ị́nị́ŋá ꞌdãri sĩ, ꞌbá Ĩsẽrélẽ vé rĩ pi íꞌdókí ẹ̃cị̃ tuú kụ̃rụ́ Rãmãsésẽ vé rĩ gé, cĩmgbá cazú kụ̃rụ́ Sõkótõ vé rĩ gé. ꞌBá mụꞌbá rĩ pi élĩfũ mụ̃dụ̃rụ̃lụ̃ ázíyá (600,000), ꞌdĩꞌbée céré ãgõ, ꞌbo lãkí ũkú rĩ pi anjiŋá rĩ pi be kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ꞌBá ụrụkọ kárákará ꞌdekí mụụ́ ꞌbá Ĩsẽrélẽ vé rĩ pi vúgá sĩ ĩndĩ. Tị́, ndrị̃ị́, ãzini kãbĩlõ kárákará ꞌdekí mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kộpi ní fúndru ĩ ní usaá yị̃ị́ sĩ ãkụ́fị́ ãkó ĩ ní íjị́ Ẽjẽpétõ gálésĩ rĩ ꞌbãzú áꞌdízú pánga rú. Ãꞌdiãtãsĩyã ídrókí kộpi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agá ꞌdãásĩ, kộpi ị́sụ́kí sâ ínyá áꞌdízú ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ꞌBá Ĩsẽrélẽ vé rĩ pi adrikí Ẽjẽpétõ agá ꞌdãlé caá ílí mụ̃dụ̃rụ̃lụ̃ sụ pụ̃kụ́ na (430). ");
INSERT INTO kbo_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ílí mụ̃dụ̃rụ̃lụ̃ sụ pụ̃kụ́ na (430) ꞌdĩri vé ụ̃dụ̃ gé, Úpí Múngú vé ꞌbá Ĩsẽrélẽ vé rĩ pi ní fũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ úyú ĩvé rĩ vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ị́nị́ŋá ꞌdãri sĩ, Úpí Múngú ꞌbã mị kộpi ndrezú, íjị́ kộpi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ rá. Ílí ãlu ãlu, lẽ ꞌbá Ĩsẽrélẽ vé rĩ pi ẽ ígákí ị́nị́ŋá ꞌdãri vé tã, kộpi ã rikí Úpí Múngú ri ị̃njị̃ị́ úyú ĩvé rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Úpí Múngú ní ꞌyozú Mósẽ pi ní Ãrónã be kĩnĩ, “Tãị́mbị́ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ pi ꞌdĩ: “Lẽ jãkãgú ã nya ụ̃mụ̃ rĩ ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tụ́gẹ̃rị̃ mí ní jeé, mí ní ágélé ni ẽ tị lịị́ gí rĩ, ĩri ícó ụ̃mụ̃ ꞌdĩri nya rá. ");
INSERT INTO kbo_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ụ̃mụ́ ímụ́pi adriípi mívé ãngá, ãzini ꞌbá riípi ẹ̃zị́ ngaápi mí ní, mí ní rií ũfẽfẽ rĩ, ã nya ụ̃mụ̃ rĩ ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ꞌBá Ĩsẽrélẽ vé rĩ pi ã nyakí zãá ụ̃mụ̃ vé rĩ jó agá ꞌdãá ũgõgõ. Ã jịkí zãá rĩ fũú ãmvé ku. Ã ŋõkí zãá rĩ vé fã ãluŋáni ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Lẽ ꞌbá Ĩsẽrélẽ vé rĩ pi ãrẽvú céré ã nyakí ụ̃mụ̃ ụ́ꞌdụ́ ꞌdãri ị̃njị̃zú ãní. ");
INSERT INTO kbo_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Jãkãgú riípi adriípi ĩmi ãsámvú gé, lẽépi ụ̃mụ̃ Ụ́ꞌdụ́ Úpí Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ nyaápi rĩ, lẽ ã úlị́ anji ãgõ adriꞌbá ívé ãngá rĩ pi vé ágélé ẽ tị rá. Kúru kộpi ícó ụ̃mụ̃ rĩ nya rá, sụ̃ ꞌbá Ĩsẽrélẽ vé ni tị́nị. ꞌBá ágó ĩ ní ágélé ni ẽ tị lịị́ kuyé rĩ, ã nya ku. ");
INSERT INTO kbo_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tãị́mbị́ ãlu ãlu ĩ ní rizú ágélé ẽ tị lịzú ꞌdĩri, ĩri ꞌi nga ꞌbá Ĩsẽrélẽ vé rĩ pi ní ãzini jãkã adriꞌbá ĩmi ãsámvú gé rĩ pi be céré.” ");
INSERT INTO kbo_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ĩsẽrélẽ rĩ pi ãrẽvú céré ꞌdụkí tã Úpí Múngú ní ẹzịị́ Mósẽ pi ní Ãrónã be rĩ ngaá rá. ");
INSERT INTO kbo_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ụ́ꞌdụ́ ãlu ãlu ꞌdãri sĩ, Úpí Múngú íjị́ ꞌbá Ĩsẽrélẽ vé rĩ pi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ ãmvé úyú ĩvé rĩ vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ꞌÍ gụ̃ ꞌbá Ĩsẽrélẽ vé rĩ pi vé anji ãgõ kãyú rĩ pi adrií túngú. Ãnji Ĩsẽrélẽ vé ĩ ní tịị́ kãyú rĩ pi, ãnyãpá ĩ ní tịị́ kãyú rĩ pi be, kộpi mávé ni.” ");
INSERT INTO kbo_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kúru Mósẽ ní ꞌyozú ꞌbá Ĩsẽrélẽ vé rĩ pi ní kĩnĩ, “Lẽ ĩmi ígákí ụ́ꞌdụ́ ĩmi ní ĩfũzú Ẽjẽpétõ agásĩ, ĩmi ní ĩzãngã nyazú tụ́gẹ̃rị̃ rú ꞌdãri, ãꞌdiãtãsĩyã Úpí Múngú íjị́ ĩmi ĩfũú ũkpõ ívé rĩ sĩ nĩ. ꞌBá ãzi ã nya pánga ĩ ní áꞌdí ãkụ́fị́ sĩ ni ku. ");
INSERT INTO kbo_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lẽ ĩmi ígákí ụ́ꞌdụ́ ĩmi ní ĩfũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ mbãá Ãbị́bụ̃ agá rĩ vé tã. ");
INSERT INTO kbo_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Úpí Múngú ẹzị ĩmi ẹ́ꞌbị́pị́ị ní ãngũ ꞌbá Kãnánã vé rĩ pi vé rĩ, Hị́tị̃ rĩ pi vé rĩ, Ãmórã rĩ pi vé rĩ, Hívĩ rĩ pi vé rĩ, ãzini Jẽbúsĩ rĩ pi vé rĩ, sẽ ĩmi ní, ãngũ ꞌdãri múké, lé be, ãzini ọ̃nyụ́ be. Ĩmi cakí dõ ãngũ ꞌdãri agá gí, ílí ãlu ãlu, mbãá Ãbị́bụ̃ vé rĩ gé, lẽ ĩmi údékí ụ̃mụ̃, ĩmi nyakí ụ́ꞌdụ́ ĩmi ní ĩfũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ ꞌdãri ígázú ãní. ");
INSERT INTO kbo_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Lẽ ĩmi nyakí pánga ĩ ní áꞌdí ãkụ́fị́ ãkó ni caá ụ́ꞌdụ́ ẹ́zị̂rị̃, ca dõ ụ́ꞌdụ́ ẹ́zị̂rị̃ gí, lẽ ĩmi údékí ụ̃mụ̃ Úpí Múngú ri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá, lẽ ĩmi nyakí pánga ĩ ní áꞌdí ãkụ́fị́ ãkó ni, lẽ ãkụ́fị́ ã adri ĩmivé jó agá ku, ãngũ ĩmi ní adrizú rĩ agásĩ céré, ãkụ́fị́ ã adri ku. ");
INSERT INTO kbo_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ụ́ꞌdụ́ ẹ́zị̂rị̃ ꞌdĩri agá, lẽ ꞌbẹ̃tị́ ãlu ãlu ã ũlũ anji ívé rĩ pi ní ꞌdíni, ‘Ma ri tã ꞌdĩri ꞌo ꞌdíni, ãꞌdiãtãsĩyã tã Úpí Múngú ní ꞌoó má ní, ĩri ní ma íjị́ ĩfũú Ẽjẽpétõ agásĩ ãmvé rĩ sĩ.’ ");
INSERT INTO kbo_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ụ̃mụ̃ nõri adri sụ̃ ngá ĩ ní ꞌyĩí drị́gé rĩ tị́nị, dõku ngá ĩ ní ꞌbãá ẹndrẹtị gé rĩ tị́nị, ĩmi ígákí rí tã Múngú ní ẹzịị́ ĩmi ní rĩ ãní, ĩmi ũlũkí rí ĩmivé anjiŋá rĩ pi ní. Ĩmi ndrekí drĩ ká, Úpí Múngú íjị́ ĩmi ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ ũkpõ ívé rĩ sĩ nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ílí ãlu ãlu, ĩmi údékí ụ̃mụ̃ rií nyaá ụ́ꞌdụ́ ꞌdĩri gé. ");
INSERT INTO kbo_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Úpí Múngú ri ímụ́ ãngũ ꞌbá Kãnánã vé rĩ pi ní adrizú rĩ sẽ ĩmi ní, sụ̃ ĩri ní ẹzịị́ ĩmi ní, ãzini ĩmi ẹ́ꞌbị́pị́ị ní rĩ tị́nị. Ĩmi kádõ caá ãngũ rĩ agá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ĩmi gụ̃kí anji ãgõ kãyú rĩ pi, ãnyãpá ãgõ kãyú rĩ pi be céré sẽé Úpí Múngú ní. ");
INSERT INTO kbo_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ꞌBá ãlu ãlu ã újá ívé dõngí ágó kãyú rĩ ívé kãbĩlõ mvá ágó rú ni sĩ, dõngí rĩ ẽ drị̃ jezú ãní. ꞌBo újá dõ dõngí rĩ kuyé, ã pi umbe ni ŋõó rá. Lẽ ꞌbá ãlu ãlu ã je ívé mvá ágó kãyú rĩ ẽ drị̃ jeje. ");
INSERT INTO kbo_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Úmvúlésĩ anji ĩmivé rĩ pi zịkí dõ ĩmi, ‘Tã ĩ ní rizú anji ãgõ kãyú rĩ pi ẽ drị̃ jezú rĩ vé ífífí ãꞌdi?’ Ĩmi ꞌyokí kộpi ní kínĩ, ‘Úpí Múngú íjị́ ꞌbâ ĩfũú ãngũ Ẽjẽpétõ vé ꞌbá ní adrizú ãní tụ́gẹ̃rị̃ rú rĩ agásĩ ũkpõ ívé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ọ́tụ́ ꞌbãgú Ẽjẽpétõ vé rĩ kã gãá ꞌbâ ọyụgá sĩ, Úpí Múngú úꞌdị́ ꞌbá Ẽjẽpétõ vé rĩ pi vé anji ãgõ kãyú rĩ pi, ãnyãpá ãgõ kãyú rĩ pi be ũdrãá rá. Sẽ ꞌbá ní rizú ãnyãpá ãgõ kãyú rĩ pi sẽzú zãzú Úpí Múngú ní rọ̃bọ̃ŋọ̃ rú ꞌbávé anji ãgõ kãyú rĩ pi ẽ drị̃ jezú kãbĩlõ mvá sĩ ãní.’ ");
INSERT INTO kbo_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Tã ĩ ní rizú anji ãgõ kãyú rĩ pi ẽ drị̃ jezú rĩ adri sụ̃ ngá ĩ ní ꞌyĩí drị́gé rĩ tị́nị, dõku ngá ĩ ní ꞌyĩí ẹndrẹtị gé rĩ tị́nị, ĩmi ígákí rí tã Úpí Múngú ní ꞌbâ íjị́zú ĩfũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ ívé ũkpõ sĩ rĩ ãní.” ");
INSERT INTO kbo_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ꞌBãgú Ẽjẽpétõ vé rĩ kã ꞌbá Ĩsẽrélẽ vé rĩ pi ọyụụ́ mụzú, Múngú ko kộpi ẽ drị̃ mụzú lẹ́tị mụụ́pi ãngũ Fẽlẽsétẽ vé rĩ gé sĩ kuyé, lẹ́tị rĩ ẽ ẹlị dõ ẹlị ẹlị drãáãsĩyã. Múngú kĩnĩ, “Kộpi fikí dõ ẹ̃ꞌdị́ agá, kộpi ĩvé úmĩ újá gõzú ãní vúlé Ẽjẽpétõ gá ũzi.” ");
INSERT INTO kbo_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ꞌBo Múngú ko kộpi ẽ drị̃ mụzú lẹ́tị ꞌi ánápi trãá ãngũ ãꞌwí cínyáfã rú rĩ gélésĩla, Yị̃ị́ Tafu Ika rĩ gélé rú. ꞌBá Ĩsẽrélẽ vé rĩ pi fũkí ãngũ Ẽjẽpétõ vé rĩ agásĩ sụ̃ ꞌbá mụꞌbá ẹ̃ꞌdị́ ꞌdịꞌbá rĩ pi tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mósẽ kã ĩfũú Ẽjẽpétõ agásĩ, ꞌdụ fã Yõsépã vé rĩ mụzú ĩndĩ, ãꞌdiãtãsĩyã Yõsépã ẹzị ọ́tụ́ ꞌbá Ĩsẽrélẽ vé rĩ pi ní kĩnĩ, “Á nị̃ rá Múngú ri úmvúlésĩ ímụ́ ĩmi ĩzã ko rá, kúru ĩmi kádõ fũú mụzú, ĩmi jịkí mávé fã mụzú ĩndĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ kụ̃rụ́ Sõkótõ vé rĩ kuú, kộpi mụkí mõrõgó ꞌbeé kụ̃rụ́ Ẽtámã vé rĩ gé, ĩnyiŋá ãngũ ãꞌwí cínyáfã rú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kãdõ adrií ụ̃tụ́ŋá sĩ, Úpí Múngú ri ị́rị́bị́tị sẽ ãsõ kộpi ẹndrẹtị gé ri kộpi ẽ drị̃ ko mụzú. Kãdõ kpá adrií ị́nị́ŋá sĩ, ĩri sẽ ãcí ri dị̃ kộpi ẹndrẹtị gé, kộpi ã ndrekí rí ãngũ ãní ị́nị́ŋá rĩ sĩ, kộpi ã tukí rí ẹ̃cị̃ ụ̃tụ́ŋá sĩ, dõku ị́nị́ŋá sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ị́rị́bị́tị rĩ ri ꞌbá Ĩsẽrélẽ vé rĩ pi ẽ drị̃ koó mụzú ụ̃tụ́ŋá rĩ sĩ, ãzini ãcí ãsõópi rĩ, ri kộpi ẽ drị̃ koó mụzú ị́nị́ŋá rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ꞌÍ ꞌyo ꞌbá Ĩsẽrélẽ vé rĩ pi ní, kộpi ã újákí ĩ gõó mụụ́ mõrõgó rĩ ꞌbeé kụ̃rụ́ Pĩ Hãhĩrótã vé rĩ gé, Mĩgõdólã pi vé ãsámvú yị̃ị́ tafu ika rĩ be rĩ gé. Kộpi ã ꞌbekí mõrõgó rĩ yị̃ị́ tafu ika rĩ ã gãrã gá, ĩnyiŋá kụ̃rụ́ Bãlã Zẽfónã vé rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ꞌBãgú Ẽjẽpétõ vé rĩ ímụ́ ụ̃sụ̃, ĩri ꞌyo, ‘ꞌBá Ĩsẽrélẽ vé rĩ pi ndãkí lẹ́tị tí, kộpi ri ájá ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdĩíꞌdĩ.’ ");
INSERT INTO kbo_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ma sẽ ꞌbãgú rĩ vé ẹ́sị́ ri tete, ĩri gõ ĩmi vụ́drị̃ dro, ꞌbo ma ꞌbãgú rĩ ndẽ ívé ãngáráwá rĩ pi be rá. Tã má ní ímụ́zú kộpi ndẽzú rĩ, ĩri sẽ ꞌbá rĩ pi céré ímụ́ ma íngú ãní rá. ꞌBá Ẽjẽpétõ vé rĩ pi ímụ́ nị̃ ꞌyozú kínĩ, ádarú ma Úpí Múngú ꞌi.” Kúru ꞌbá Ĩsẽrélẽ vé rĩ pi ní mõrõgó ꞌbezú vũrã Úpí Múngú ní lũú ĩ ní rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ꞌBãgú Ẽjẽpétõ vé rĩ kã yịị́ kínĩ ꞌbá Ĩsẽrélẽ vé rĩ pi ápákí mụzú gí, ꞌbãgú rĩ ívé ũgalaku rĩ pi be, kộpi ní ĩvé yị̃kị̂ újázú ꞌyozú kínĩ, “Ĩ ndrekí drĩ tã ꞌbá ní ꞌoó ꞌdĩri ká, ꞌbá kukí ꞌbá ꞌdĩꞌbée ápá rá ãsĩ? Kộpi gõkí ꞌbá ní ẹ̃zị́ ngaá dị̃ị́ ku!” ");
INSERT INTO kbo_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kúru ꞌbãgú rĩ útú ívé ãrãbíyã ĩ ní rií useé hũsánĩ sĩ rĩ kú ị́nọ́gọ́sị́, ꞌdụ ívé ãngáráwá rĩ pi mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ꞌDụ ãrãbíyã múké múké ĩ ní rií useé hũsánĩ sĩ rĩ pi mụ̃dụ̃rụ̃lụ̃ ázíyá, ꞌdụ kpá ãrãbíyã ĩ ní rií useé hũsánĩ sĩ Ẽjẽpétõ agá ꞌdãá rĩ pi, ũꞌbã ũgalaku rĩ pi adrií drị̃koma rú ãrãbíyã ĩ ní rií useé hũsánĩ sĩ rĩ pi drị̃gé sĩ ãlu ãlu céré. ");
INSERT INTO kbo_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Úpí Múngú sẽ ꞌbãgú Ẽjẽpétõ vé rĩ ẽ ẹ́sị́ teéte, ã dro rí ꞌbá Ĩsẽrélẽ vé riꞌbá ápáꞌbá mụꞌbá ụ̃rị̃ ãkó ꞌdĩꞌbée ã vụ́drị̃ mụzú. ");
INSERT INTO kbo_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ꞌBá Ẽjẽpétõ vé rĩ pi, ãngáráwá ꞌbãgú rĩ vé rĩ pi, ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi, ãzini únjúꞌbá ãrãbíyã ĩ ní useé hũsánĩ sĩ rĩ pi be rikí ꞌbá Ĩsẽrélẽ vé rĩ pi ã vụ́drị̃ droó mụzú, kộpi cakí mụụ́ Ĩsẽrélẽ rĩ pi ị́sụ́ vũrã kộpi ní mụzú adrizú rĩ gé yị̃ị́ tafu ika rĩ ã gãrã gá ĩnyiŋá Pĩ Hãhĩrótã gá, ĩnyiŋá kụ̃rụ́ Bãlã Zẽfónã vé rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ ndreé ꞌbãgú rĩ ri ímụ́ ívé ꞌbá Ẽjẽpétõ vé rĩ pi be ĩ vúgálé rú, ụ̃rị̃ ị́mvụ́ kộpi ambamba, kộpi ní útrézú Úpí Múngú ẹndrẹtị gé, Múngú ã ko ĩ ĩzã. ");
INSERT INTO kbo_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Kộpi ní ꞌyozú Mósẽ ní kínĩ, “Mí íjị́ ꞌbâ ũdrãá ãngũ ãꞌwí cínyáfã rú rĩ gé nõgó ãꞌdi ã tã sĩ? Ẽjẽpétõ agá ꞌdãá, nyọ̃ọ́kụ́ ãvũ sị̃zú ni ꞌdãáyo? ꞌÍ ꞌo mi ngóni ngóni ꞌbâ íjị́zú ĩfũzú Ẽjẽpétõ agásĩ ãmvé? ");
INSERT INTO kbo_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ꞌBá ꞌyokí mí ní ándúrú Ẽjẽpétõ gá ꞌdãlé rá, ꞌbá kĩnĩ, ‘Mî ku ꞌbâ adrikí ꞌbá Ẽjẽpétõ vé rĩ pi ní tụ́gẹ̃rị̃ rú, rií ẹ̃zị́ ngaá kộpi ní.’ ꞌBávé adringárá tụ́gẹ̃rị̃ rú Ẽjẽpétõ gá ꞌdãlé rĩ múké, ndẽ ꞌbá ní ímụ́zú ũdrãzú ãngũ ãꞌwí cínyáfã rú rĩ agá nõgó rĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mósẽ ní újázú ꞌbá Ĩsẽrélẽ vé rĩ pi ní kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku! Ĩmi úmbékí ẹ́sị́, ĩmi ãndrũ tã Úpí Múngú ní ĩmi pazú rĩ ndre rá, ꞌbá Ẽjẽpétõ vé ĩmi ní ndreé ímụ́ꞌbá ꞌdĩꞌbée, ĩmi gõkí kộpi ndreé dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Úpí Múngú ri ĩmi ní ũmbã rĩ fụ nĩ, lẽ ĩmi adrikí mãdã.” ");
INSERT INTO kbo_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Ngá mí ní rizú mi ĩmãmãlãzú mâ ko mî ĩzã rĩ ãꞌdi? ꞌÍ lũ ꞌbá Ĩsẽrélẽ vé rĩ pi ní, kộpi ã útrúkí ĩ mụzú drị̃drị̃. ");
INSERT INTO kbo_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mí inga mívé túré suú yị̃ị́ tafu ika rĩ drị̃gé ꞌdãlé, yị̃ị́ rĩ ẽ ẹ́dị́ rí ꞌi, ꞌbá Ĩsẽrélẽ vé rĩ pi ẽ ẹlịkí rí mụzú ãngũ ãꞌwí rú rĩ agásĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ma sẽ ãngáráwá Ẽjẽpétõ vé rĩ pi ẽ ẹ́sị́ ri tete, kộpi Ĩsẽrélẽ rĩ pi ã vụ́drị̃ dro mụzú yị̃ị́ tafu ika rĩ agásĩ, ma ꞌbãgú rĩ ndẽ ívé ãngáráwá rĩ pi be, ãrãbíyã ĩ ní useé hũsánĩ sĩ rĩ pi be, ĩ kúru ma ị̃njị̃ ãní rá. ");
INSERT INTO kbo_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Má kãdõ ꞌbãgú rĩ ndẽé ívé ãngáráwá rĩ pi be gí, ꞌbá Ẽjẽpétõ vé rĩ pi ímụ́ nị̃ ámá ꞌyozú kínĩ, ma Úpí Múngú ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kúru Múngú vé mãlãyíkã riípi ãngáráwá Ĩsẽrélẽ vé rĩ pi ẽ drị̃ koópi rĩ gõ ꞌi újá adrií kộpi ã úgóró gá. Ị́rị́bị́tị ãsõópi kộpi ẹndrẹtị gé rĩ gõ ꞌi újá adrií kộpi ã úgóró gá. ");
INSERT INTO kbo_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ị́rị́bị́tị rĩ mụ adrií ãngáráwá Ẽjẽpétõ vé rĩ pi ãsámvú gé ꞌbá Ĩsẽrélẽ vé rĩ pi be. Ãngũ rĩ kã nịị́ cịcị, ị́rị́bị́tị rĩ gõ ꞌi újá dị̃ị́ ꞌbá Ĩsẽrélẽ vé rĩ pi ní ãcí rú ị́nị́ be rã. ꞌBo ị́rị́bị́tị rĩ sẽ ãngũ rĩ nị kú cịcị ãngáráwá Ẽjẽpétõ vé rĩ pi ní, sẽ ãngáráwá Ẽjẽpétõ vé rĩ pi útrúkí ĩ caá ꞌbá Ĩsẽrélẽ vé rĩ pi ã gãrã gá ꞌdãá kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kúru Mósẽ ní ívé túré ingazú suzú yị̃ị́ tafu ika rĩ drị̃gé ꞌdãá, ị́nị́ŋá ꞌdãri sĩ, Úpí Múngú ní ũlí ĩpẽzú ụ̃tụ́ ní ĩfũngárá gálésĩla ũkpõ be, vịzú ị́nị́ be rã, yị̃ị́ tafu rĩ ní ꞌi ẹ́dị́zú, sẽ ãngũ rĩ gõ adrií ãꞌwí rú. ");
INSERT INTO kbo_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kúru ꞌbá Ĩsẽrélẽ vé rĩ pi ní ẹlịzú mụzú ãngũ ãꞌwí rú, yị̃ị́ ꞌi ẹ́dị́pi ngaápi kú ngẹ́njị rĩ ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ꞌBá Ẽjẽpétõ vé rĩ pi, ãngáráwá ꞌbãgú rĩ vé rĩ pi be, kộpi ní ꞌbá Ĩsẽrélẽ vé rĩ pi ã vụ́drị̃ drozú mụzú, kộpi njukí mụzú ĩvé hũsánĩ rĩ pi sĩ, ãzini ãrãbíyã ĩ ní useé hũsánĩ sĩ rĩ pi sĩ mụzú yị̃ị́ tafu ika ꞌi ẹ́dị́pi kú ngẹ́njị rĩ ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ꞌBo kã mụụ́ adrií ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, Úpí Múngú ndre ãngũ ímụ́zú ꞌbá Ẽjẽpétõ vé rĩ pi drị̃gé vũgá nõó ị́rị́bị́tị dị̃ị́pi ãcí rú rĩ agásĩ, sẽ ụ̃rị̃ ị́mvụ́ kộpi ambamba. ");
INSERT INTO kbo_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Múngú sẽ ꞌbá Ẽjẽpétõ vé rĩ pi vé ãrãbíyã rĩ pi ã pá ate ũtrẽtrẽ agá, ícókí njuú ku. ꞌBá Ẽjẽpétõ vé rĩ pi ní ꞌdezú útrézú kínĩ, “Lẽ ꞌbâ ꞌdekí fũú mụzú nõósĩ rá! Úpí Múngú ꞌde ꞌbá Ĩsẽrélẽ vé rĩ pi vúgálésĩ, ĩri ri ũmbã rĩ fụ ꞌbá be nĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Mí inga mívé túré suú yị̃ị́ tafu ika rĩ drị̃gé ꞌdãá, yị̃ị́ rĩ ẽ ící rí ꞌi ꞌbá Ẽjẽpétõ vé rĩ pi ĩmũlũú ĩvé ãrãbíyã useé hũsánĩ sĩ rĩ pi be, ãzini ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi be.” ");
INSERT INTO kbo_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kúru Mósẽ ní ívé túré ingazú suzú yị̃ị́ tafu ika rĩ drị̃gé ꞌdãá, kã mụụ́ adrií ụ̃ꞌbụ́tịŋá sĩ, yị̃ị́ rĩ ní ꞌi ícízú kpụ̃kụ́. ꞌBá Ẽjẽpétõ vé rĩ pi ꞌbị̃kí kõdô ápá fũú yị̃ị́ rĩ agásĩ, ꞌbo Úpí Múngú úꞌbé kộpi gõó yị̃ị́ tafu ika rĩ agá ꞌdãá ũzi. ");
INSERT INTO kbo_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Yị̃ị́ rĩ ĩmũlũ ãrãbíyã ĩ ní useé hũsánĩ sĩ rĩ pi, ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi be, ꞌbãgú rĩ vé ãngáráwá ꞌbá Ĩsẽrélẽ vé rĩ pi ã vụ́drị̃ droꞌbá rĩ pi be céré, ꞌbá ãzi pa ꞌi ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ꞌBo ꞌbá Ĩsẽrélẽ vé rĩ pi ní ẹlịzú mụzú ãngũ ãꞌwí rú rĩ gé sĩ, yị̃ị́ ꞌi ẹ́dị́pi ngaápi kú ngẹ́njị rĩ ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ụ́ꞌdụ́ ꞌdãri gé, Úpí Múngú pa ꞌbá Ĩsẽrélẽ vé rĩ pi ꞌbá Ẽjẽpétõ vé rĩ pi drị́gé sĩ rá, ꞌbá Ĩsẽrélẽ vé rĩ pi ndrekí ꞌbá Ẽjẽpétõ vé rĩ pi vé ãvũ ũdrãꞌbá kú yị̃ị́ ã gãrã gá sĩ rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ Úpí Múngú vé ũkpõ ꞌbá Ẽjẽpétõ vé rĩ pi ndẽzú rĩ ndreé, sẽ kộpi ị̃njị̃kí Úpí Múngú ri ãní rá, kộpi ꞌbãkí ẹ́sị́ Úpí Múngú drị̃gé, ãzini ĩrivé ãtíꞌbá Mósẽ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kúru Mósẽ pi ní úngó ꞌdĩri ngozú ꞌbá Ĩsẽrélẽ vé rĩ pi be Úpí Múngú ní, “Ma úngó ngo Úpí Múngú ní, ãꞌdiãtãsĩyã ĩri ní ariꞌba rĩ pi ã ũkpõ ndẽé rá rĩ sĩ. Úꞌbé ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi ĩvé hũsánĩ rĩ pi be céré yị̃ị́ tafu agá. ");
INSERT INTO kbo_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Úpí Múngú ri má ní ũkpõ sẽ nĩ, ãzini ĩri sẽ ma úngó ngo nĩ, pa ma ariꞌba rĩ pi drị́gé sĩ nĩ, ĩri mávé Múngú, ma ĩri íngú, ĩri Múngú má ẹ́tẹ́pị vé ni, ma ĩri íngúngũ. ");
INSERT INTO kbo_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Úpí Múngú ri ꞌbá ẹ̃ꞌdị́ ꞌdịị́pi ndẽépi rá ni, ĩrivé rụ́ Úpí ꞌi. ");
INSERT INTO kbo_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ꞌBãgú rĩ vé ãngáráwá rĩ pi ĩvé ãrãbíyã ĩ ní useése rĩ pi be, Múngú úꞌbé kộpi Yị̃ị́ Tafu Ika rĩ agá. ꞌBãgú rĩ vé ũgalaku ẹ̃ꞌdị́ ã tã nị̃ꞌbá múké múké rĩ pi uꞌdekí ũdrãá Yị̃ị́ Tafu Ika rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Yị̃ị́ kụụ́pi kụkụ rĩ ĩmũlũ kộpi, kộpi uꞌdekí áwí yị̃ị́ ã ndụ́gé ꞌdãá, sụ̃ írã ní ꞌdeé áwí yị̃ị́ ã ndụ́gé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Úpí Múngú, mívé ũkpõ aga rá, mívé ũkpõ úꞌdị́ ariꞌba rĩ pi ũdrãá céré. ");
INSERT INTO kbo_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mívé ũkpõ agaápi rá rĩ sĩ, ꞌí ndẽ ꞌbá mi ọwụꞌbá rĩ pi rá, jĩkó mívé rĩ sĩ, ꞌí zã ꞌbá ꞌdĩꞌbée veé kuú úfúrágú rú, sụ̃ ásé ní veé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ẹ̃vị̃vị̃ mívé rĩ sĩ, yị̃ị́ rĩ aco ꞌi ngaá kuú ngẹ́njị, yị̃ị́ riípi dịị́pi rĩ gõ ꞌi újá troó kuú ngũ, Mị ni kụụ́pi kụkụ rĩ gõ dịị́ ku. ");
INSERT INTO kbo_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ariꞌba rĩ pi rikí ĩ íngú kínĩ, ‘Ma kộpi ã vụ́drị̃ dro, ma kộpi urụ rá, ma kộpivé ãꞌbú uꞌdụ kộpi drị́gé sĩ, ma kộpi úꞌdị́ ũdrã céré, ma mávé ị́lị́ ãco rĩ ínjé, ma kộpi úꞌdị́ ũdrã rá.’ ");
INSERT INTO kbo_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ꞌBo Úpí Múngú, ꞌí vu mívé ẹ̃vị̃vị̃, sẽ yị̃ị́ tafu rĩ ĩmũlũ kộpi, kộpi uꞌdekí tĩí yị̃ị́ ã ndụ́gé sụ̃ írã ní ꞌdeé tĩí yị̃ị́ ã ndụ́gé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Úpí Múngú, múngú ãzi sụ̃ụ́pi mí tị́nị ꞌdãáyo, Ãꞌdi adri sụ̃ mí tị́nị, uleteretere ũkpõ be nĩ? ꞌBá ĩ ní ruú, ãzini ĩ ní íngú sụ̃ mí tị́nị rĩ ãꞌdi ꞌi? Ãꞌdi ri ícó tã ãyãzú ãyãyã ni ꞌo sụ̃ mí tị́nị nĩ? ");
INSERT INTO kbo_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Mí iꞌda mívé ũkpõ, nyọ̃ọ́kụ́ rĩ zị̃ ꞌi, ute kộpi céré. ");
INSERT INTO kbo_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lẽngárá mívé agaápi rá rĩ sĩ, mi ꞌbá mí ní kộpi ípá rĩ pi ẽ drị̃ ko mụzú rá. Ũkpõ mívé rĩ ícó kộpi ũtẽ ca mívé vũrã uletere rĩ gé rá. ");
INSERT INTO kbo_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Sụ́rụ́ rĩ pi kádõ tã ꞌdĩri yịị́, ĩri sẽ kộpi ã rụ́ꞌbá ri yãyã. Ụ̃rị̃ ri ꞌbá Fẽlẽsétẽ vé rĩ pi ị́mvụ́ ambamba. ");
INSERT INTO kbo_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ụ̃rị̃ ri ímụ́ drị̃koma Ẽdómã vé rĩ pi ị́mvụ́ ũnjí ũnjí. Ambugu Mõábã vé rĩ pi ímụ́ yã ambamba, ꞌbá Kãnánã vé rĩ pi ímụ́ adri ụ̃rị́ rú, ");
INSERT INTO kbo_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ụ̃rị̃ ri ímụ́ kộpi ị́mvụ́ ũnjí ũnjí. Úpí Múngú, ũkpõ mívé rĩ sĩ, kộpi áwí pá tu sụ̃ írã ní pá tuú vũrãvũrã rĩ tị́nị. Cĩmgbá ꞌbá mívé mí ní ípá rĩ pi ní agazú mụzú. ");
INSERT INTO kbo_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Mi kộpi jị mụ adri írã mí ní adrizú rĩ drị̃gé, Á Úpí Múngú, vũrã ꞌdãri mí ní rizú adrizú rĩ, Á Úpí, mí údé vũrã rĩ nĩ uletere. ");
INSERT INTO kbo_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Úpí Múngú, mi ãngũ rụ mụzú nyonyo.” ");
INSERT INTO kbo_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ꞌBá Ĩsẽrélẽ vé rĩ pi zokí fũú yị̃ị́ Múngú ní ẹ́dị́ kuú ngẹ́njị rĩ ãsámvú gé sĩ múké. ꞌBo ꞌbãgú Ẽjẽpétõ vé rĩ pi ívé ãngáráwá rĩ pi be, kộpi kâ lẽé zoó mụzú, Úpí Múngú sẽ yị̃ị́ rĩ ĩmũlũ kộpi kpụ̃kụ́ ĩvé hũsánĩ rĩ pi be, ĩvé ãrãbíyã ĩ ní rií useése hũsánĩ sĩ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Mĩrĩyámã Ãrónã ọ́mvụ́pị ri nẹ́bị̃. Kúru ĩri ní kõyõ íꞌdụ́zú rizú cozú, ũkú rĩ pi ní ꞌdezú vụ́drị̃ ni gé sĩ, pí ĩvé kõyõ pi be, kộpi ní rizú úngó tuzú mụzú. ");
INSERT INTO kbo_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Kúru Mĩrĩyámã ní íꞌdózú úngó rĩ ngozú kộpi ní, “Ĩmi ngokí úngó Úpí Múngú ri íngúzú, ĩri ní ẹ̃ꞌdị́ rĩ ndẽé gí rĩ sĩ! Úꞌbé ꞌbá únjúꞌbá hũsánĩ sĩ rĩ pi ĩvé hũsánĩ rĩ pi be céré yị̃ị́ tafu rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kúru Mósẽ ní ꞌbá Ĩsẽrélẽ vé rĩ pi ẽ drị̃ kozú Yị̃ị́ Tafu Ika rĩ gé ꞌdãásĩ mụzú ãngũ ãꞌwí cínyáfã rú ĩ ní zịị́ Sụ́rụ̃ rĩ gé ꞌdãá. Kộpi ẹ́cị́kí caá ụ́ꞌdụ́ na, ị́sụ́kí yị̃ị́ mvụụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kúru kộpi kâ caá Márã gá ꞌdãá, kộpi ị́sụ́kí yị̃ị́ rá, ꞌbo yị̃ị́ rĩ ní draádra rĩ sĩ, kộpi mvụkí yị̃ị́ rĩ kuyé. (Zịkí ãngũ ꞌdãri ã rụ́ Márã, yị̃ị́ rĩ ní draádra rĩ sĩ.) ");
INSERT INTO kbo_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ꞌBá rĩ pi rikí unuú Mósẽ bị́lé gá kínĩ, “Mósẽ, yị̃ị́ rĩ dradra, ꞌbâ mvụkí rí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mósẽ ní Úpí Múngú rĩ zịzú ẹ́sị́ be céré. Úpí Múngú ní pẹtị ẹ̃lị́ŋá ni iꞌdazú ĩri ní. Mósẽ ní pẹtị ẹ̃lị́ŋá ꞌdĩri ꞌbezú yị̃ị́ agá ꞌdãá, yị̃ị́ rĩ gõ ícá múké, ĩ ícó mvụ rá. Márã gá ꞌdãá, Úpí sẽ tãị́mbị́ kộpi ní, ãzini ụ̃ꞌbị̃ kộpi. ");
INSERT INTO kbo_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kĩnĩ, “Ma Úpí Múngú ĩmivé rĩ, ĩmi yịkí dõ ụ́ꞌdụ́kọ́ mávé rĩ rá, ĩmi ꞌokí dõ tã pịrị má ẹndrẹtị gé, ãzini ĩmi ꞌdụkí dõ tã má ní ẹzịị́ rĩ ngaá rá, má ícó drã ũnjí má ní ọ́tụ́ pẽé ꞌbá Ẽjẽpétõ vé rĩ pi drị̃gé rĩ pẽé ĩmi drị̃gé ku. Ma Úpí Múngú riípi ĩmi ídrípi rĩ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ꞌBá Ĩsẽrélẽ vé rĩ pi ní gõzú ĩ útrúzú cazú Ẽlímũ gé, vũrã ꞌdãri gé, yị̃ị́ riꞌbá ídị́ꞌbá ĩfũꞌbá nyọ̃ọ́kụ́ agálésĩ mãdã mãdã ni pi anigé mụdrị́ drị̃ ni ị̃rị̃, ãzini mbírã pẹtị vũrã ꞌdãri gé anigé pụ̃kụ́ ẹ́zị̂rị̃. Kộpi ní kúru áwízú adrizú vũrã yị̃ị́ be ꞌdãri ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ꞌBá Ĩsẽrélẽ vé rĩ pi ní ngazú ãngũ Ẽlímũ vé rĩ agásĩ, kộpi ní mụzú ãngũ ãꞌwí cínyáfã rú Sínĩ vé rĩ gé, ãngũ ꞌdãri ĩri ãsámvú Ẽlímũ pi vé írã Sĩnáyĩ be rĩ gé. Mbãá ụ́ꞌdụ́ mụdrị́ drị̃ ni tọ̃wụ́, mbãá ị̃rị̃ gé, kộpi ní fũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ, kộpi ní cazú Sĩnáyĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ꞌbá Ĩsẽrélẽ vé rĩ pi rikí unuú Mósẽ pi bị́lé gá Ãrónã be. ");
INSERT INTO kbo_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ꞌBá Ĩsẽrélẽ vé rĩ pi ní ꞌyozú Mósẽ pi ní Ãrónã be kínĩ, “Úpí Múngú ã úꞌdị́ té dõ ꞌbâ ũdrãá Ẽjẽpétõ gá ꞌdãlé múké! ꞌDãlé zãá anigé, ãnyãngã anigé, ꞌbá rikí nyaá, ꞌbo ĩmi íjị́kí ꞌbâ ímụ́ ũdrãá ẹ̃bị́rị́ sĩ ãngũ ãꞌwí cínyáfã rú nõri agá ãlé?” ");
INSERT INTO kbo_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Ma ĩmi ní ãnyãngã sẽ íngázú ꞌbụ̃ gé ꞌdãásĩ sụ̃ yị̃ị́gọ́ ní ꞌdịị́ rĩ tị́nị. Ụ́ꞌdụ́ ãlu ãlu, lẽ ꞌbá rĩ pi ã mụkí ãnyãngã ĩkũnãá ĩ ní nyaá ꞌyéŋá ụ́ꞌdụ́ ãlu vé ni. Á lẽ kộpi ụ̃ꞌbị̃ị́, mâ ndre rí dõ kộpi ícó tã má ní ꞌyoó ꞌdĩri ꞌdụ nga rá. ");
INSERT INTO kbo_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Kãdõ adrií ụ́ꞌdụ́ ázíyá sĩ, lẽ kộpi ẽ ĩkũnãkí ãnyãngã ĩ ní nyaá caá ụ́ꞌdụ́ ị̃rị̃ vé ni, sụ̃ ándúrú kộpi ní rií ĩkũnãá rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kúru Mósẽ pi Ãrónã be, kộpi ní ꞌyozú ꞌbá Ĩsẽrélẽ vé rĩ pi ní kínĩ, “Ũndréŋá ãndrũ nõri sĩ, ĩmi ícó nị̃ ámá ꞌyozú kínĩ, Úpí Múngú íjị́ ĩmi ĩfũú ãmvé ãngũ Ẽjẽpétõ vé rĩ agásĩ nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Drụ̃ ụ̃ꞌbụ́tịŋá rĩ sĩ, ĩmi Úpí Múngú vé dị̃ngárá ũkpõ be rĩ ndre rá, ãꞌdiãtãsĩyã yị ĩmivé unungárá ĩmi ní rií unuú ꞌí rụ́ꞌbá gá rĩ gí. Ĩmi ri unu ꞌbâ rụ́ꞌbá gá, ꞌbá ꞌokí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mósẽ gõ kpá ꞌyoó kộpi ní kĩnĩ, “Ĩmi ndrekí dõ sẽkí ĩmi ní zãá ũndréŋá sĩ, ãzini sẽkí dõ ĩmi ní pánga ụ̃ꞌbụ́tị sĩ, ĩmi ímụ́ nị̃ ámá ꞌyozú kínĩ, Úpí Múngú sẽ ĩmi ní ngá ꞌdĩꞌbée nĩ, ãꞌdiãtãsĩyã yị ĩmivé unungárá ĩmi ní rií unuú ꞌí rụ́ꞌbá gá rĩ gí. ꞌBá ꞌokí ãꞌdi ĩmi ní rizú unuzú ꞌbâ rụ́ꞌbá gá? Ĩmi ri unu ꞌbâ rụ́ꞌbá gá kuyé, ĩmi ri unu Úpí Múngú rụ́ꞌbá gá.” ");
INSERT INTO kbo_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kúru Mósẽ ní ꞌyozú Ãrónã ní kĩnĩ, “ꞌÍ lũ ꞌbá Ĩsẽrélẽ vé rĩ pi ní, lẽ kộpi ẽ ímụ́kí Úpí Múngú vúgá nõó, ãꞌdiãtãsĩyã Úpí Múngú yị kộpivé unungárá gí.” ");
INSERT INTO kbo_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ãrónã kã rií átá ꞌbá Ĩsẽrélẽ vé rĩ pi be, kộpi ndrekí ãngũ gõó ãngũ ãꞌwí cínyáfã rú rĩ gélé rú, kộpi ndrekí dị̃ngárá Úpí Múngú vé rĩ ị́rị́bị́tị rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Á yị ꞌbá Ĩsẽrélẽ vé rĩ pi vé unungárá gí. ꞌÍ lũ kộpi ní, ‘Ũndréŋá ãlu ãlu, kộpi zãá ị́sụ́ nya rá, ụ̃ꞌbụ́tịŋá ãlu ãlu, kộpi pánga ị́sụ́ ambamba. Ĩmi kúru nị̃ ámá ꞌyozú kínĩ, ma Úpí Múngú ꞌi, ma Múngú ĩmivé rĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ũndréŋá ꞌdãri sĩ, ãlíꞌbo ímụ́kí kárákará, ọ̃zụ̃kí vũrã ꞌbá Ĩsẽrélẽ vé rĩ pi ní adrizú rĩ céré. Kã mụụ́ caá drụ̃ ụ̃ꞌbụ́tịŋá sĩ, ãngũ rĩ ꞌa céré kuú ẹndrịlị́gọ́ rú. ");
INSERT INTO kbo_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ẹndrịlị́gọ́ rĩ kã ụ́ngụ́ dẹẹ́, ngá ụrụkọ nyíríŋá ni pi ọ̃zụ̃kí ãngũ ãꞌwí cínyáfã rú ꞌdãri ẽ drị̃ céré, sụ̃ fí yị̃ị́gọ́ vé ꞌdeépi nyíríŋá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ ngá ꞌdĩꞌbée ndreé, kộpi rikí átá ĩ ãsámvú gé sĩ kínĩ, “Ngá ꞌdĩꞌbée ãꞌdi?” Ãꞌdiãtãsĩyã kộpi nị̃kí ngá rĩ kuyé. Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “Ngá rĩ pánga, Úpí Múngú sẽ ĩmi ní ãnyãngã rú. ");
INSERT INTO kbo_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tã Úpí Múngú ní ẹzịị́ ĩmi ní rĩ ꞌdĩ, ‘ꞌBá ãlu ãlu ẽ ĩkũnã caá ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní céré, ꞌbá ãlu ẽ ị́sụ́ rí õmérĩ ã ꞌa ãlu.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ꞌBá Ĩsẽrélẽ vé rĩ pi ĩkũnãkí ãnyãngã rĩ sụ̃ ĩ ní lũú ĩ ní rĩ tị́nị. ꞌBá ụrụkọ ĩkũnãkí ãnyãngã rĩ ãmbúgú, ꞌbá ụrụkọ ĩkũnãkí mãdãŋá. ");
INSERT INTO kbo_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kộpi kâ ãnyãngã ĩ ní ĩkũnãá rĩ ụ̃ꞌbị̃ị́ õmérĩ sĩ, ꞌbá ãnyãngã ĩkũnãápi ãmbúgú rĩ vé ãnyãngã ẽ ị̃mbị́tã ku ꞌi kuyé, ꞌbá ĩkũnãápi mãdãŋá rĩ vé ãnyãngã ca ĩri ní rá. ꞌBá ãlu ãlu ĩkũnã ãnyãngã rĩ caá ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní céré. ");
INSERT INTO kbo_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kúru Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá ãzi ã ku ãnyãngã rĩ laá ị́nị́ be rã caá ụ̃ꞌbụ́tịŋá gá ku.” ");
INSERT INTO kbo_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ꞌBo ꞌbá ụrụkọ yịkí Mósẽ vé tã kuyé, kộpi kukí ãnyãngã rĩ ã ụrụkọ laá rã, ãnyãngã rĩ gõ cií ụ̃ꞌbụ̃ rú, gõ ngụ̃ụ́ ũnjí. Sẽ Mósẽ ẽ ẹ́sị́ ve kộpi ní ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ụ̃ꞌbụ́tịŋá ãlu ãlu, ꞌbá ãlu ãlu ri ãnyãngã rĩ ĩkũnã ca ívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní céré. Ụ̃tụ́ rĩ kãdõ koó gbírílí, ãnyãngã rĩ áká ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kãdõ caá ụ́ꞌdụ́ ázíyá sĩ, kộpi ãnyãngã rĩ ĩkũnã ca kụ́rã ã ꞌa sụ vú ị̃rị̃, ándúrú rĩ agá, ꞌbá drị̃koma ꞌbá rĩ pi ũtẽꞌbá rĩ pi ꞌde mụ tã ꞌdĩri ũlũ Mósẽ ní. ");
INSERT INTO kbo_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “Úpí Múngú ẹzị tã rĩ ꞌdíni, ‘Ụ́ꞌdụ́ drụ̃ rĩ, ĩri ụ́ꞌdụ́ uvuzú ni, ĩri Sãbátã uletere Úpí Múngú vé ni. Ĩmi áꞌdíkí ãnyãngã rĩ ãmbúgú, dõku ĩmi ụsịkí ụsịsị. Ĩmi ꞌbãkí ụrụkọꞌbée ụ́ꞌdụ́ drụ̃ vé rĩ ã tã mbazú ãní.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kộpi ní ãnyãngã rĩ pi ꞌbãzú lazú cĩmgbá cazú ụ̃ꞌbụ́tịŋá gá, sụ̃ Mósẽ ní ẹzịị́ ĩ ní rĩ tị́nị, ꞌbo ngụ̃ ũnjí kuyé, ci kpá ụ̃ꞌbụ̃ rú kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “Ãnyãngã ꞌdĩri, ĩmi nyakí ụ́ꞌdụ́ ãndrũ nõri gé, ãꞌdiãtãsĩyã ụ́ꞌdụ́ ãndrũ nõri ĩri Sãbátã Úpí Múngú vé ni. Ĩmi ícókí ãndrũ ãnyãngã ị́sụ́ vũgá nyọ̃ọ́kụ́ drị̃gé ku. ");
INSERT INTO kbo_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ĩmi ícó ãnyãngã rĩ ĩkũnã ca ụ́ꞌdụ́ be ázíyá, ꞌbo ụ́ꞌdụ́ ẹ́zị̂rị̃ ĩ ní zịị́ Sãbátã ꞌdĩri gé, ãnyãngã ri adri ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ꞌBá ụrụkọꞌbée mụkí kõdô ãnyãngã rĩ ĩkũnãá ụ́ꞌdụ́ ẹ́zị̂rị̃ gé, ꞌbo kộpi ị́sụ́kí ãnyãngã kuyé. ");
INSERT INTO kbo_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Tã má ní ẹzịị́ ĩmi ní, ãzini má ní ímbá ĩmi ní rĩ, ĩmi gã ca gbụ ngọ̃tụ́? ");
INSERT INTO kbo_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Lẽ ĩmi nị̃kí múké ꞌyozú kínĩ, ma Úpí Múngú ꞌi, má ĩpẽ ĩmi ní ụ́ꞌdụ́ Sãbátã vé rĩ, má ní ĩmi ní ụ́ꞌdụ́ ázíyá ri ĩpẽzú, ĩmi ĩkũnãkí rí ãnyãngã caápi ụ́ꞌdụ́ ị̃rị̃ vé ni ãní. Ụ́ꞌdụ́ Sãbátã vé rĩ sĩ, lẽ ꞌbá ãlu ãlu ã adri vũrã ívé ꞌí ní rizú adrizú rĩ gé, ã fũ ãmvé ku.” ");
INSERT INTO kbo_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kúru ꞌbá rĩ pi ní uvuzú ụ́ꞌdụ́ Sãbátã vé ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ꞌBá Ĩsẽrélẽ vé rĩ pi zịkí ãnyãngã ꞌdãri ã rụ́ mánã. Ngá rĩ adri kú imve sụ̃ mgbáyá ã fí tị́nị, ẹ̃jị́ ni íní sụ̃ ãnyãngã ĩ ní usaá ọ̃nyụ́ sĩ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “Tã Úpí Múngú ní ẹzịị́ ĩmi ní rĩ ĩri ꞌdíni kĩnĩ, ‘Lẽ ĩmi ꞌbãkí mánã rĩ õmérĩ ãlu, anji úmvúlésĩ ĩ ní ímụ́ tịị́ vúlé ꞌdĩí rĩ pi ã nị̃kí rí ámá ꞌyozú kínĩ ãnyãngã ándúrú má ní sẽé ĩmi ní rií nyaá ãngũ ãꞌwí cínyáfã rú rĩ gé, lókí má ní ĩmi íjị́zú ĩfũzú Ẽjẽpétõ agásĩ rĩ adriípi ꞌdĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mósẽ ní kúru ꞌyozú Ãrónã ní kĩnĩ, “Mí íꞌdụ́ ũdrí, ꞌí dã mánã rĩ õmérĩ ã ꞌa ãlu ũdrí rĩ agá ꞌdãá, ꞌí ꞌbã vũrã múké ĩ ní rizú Úpí Múngú ri ị̃njị̃zú rĩ gé, anji úmvúlésĩ ĩ ní ímụ́ tịị́ vúlé ꞌdĩí rĩ pi ẽ ímụ́kí rí ndreé bẽnĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ãrónã ꞌdụ tã rĩ ngaá sụ̃ Úpí Múngú ní ẹzịị́ Mósẽ ní rĩ tị́nị. Ãrónã ꞌdụ mánã rĩ ꞌbãá sọ̃ndụ́kụ̃ Úpí Múngú ní ũndĩ rụzú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ꞌBá Ĩsẽrélẽ vé rĩ pi nyakí mánã rĩ caá ílí pụ̃kụ́ sụ, cĩmgbá kộpi ní cazú vũrã ĩ ní mụzú adrizú rĩ gé. Kộpi rikí mánã rĩ nyaá cĩmgbá kộpi ní cazú ãngũ Kãnánã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Épã ri acokí dõ caá mụdrị́, ãlu ni ri adri õmérĩ ãlu.) ");
INSERT INTO kbo_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ꞌBá Ĩsẽrélẽ vé rĩ pi ní ngazú fũzú ãngũ ãꞌwí cínyáfã rú Sínĩ vé rĩ agásĩ, kộpi ní ngazú vũrã ꞌdĩri agásĩ, kộpi ní mụzú cazú vũrã ãzi gé, sụ̃ Úpí Múngú ní ẹzịị́ rĩ tị́nị. Kộpi ní mụzú adrizú ãngũ Rẽfĩdímũ vé rĩ agá, ꞌbo ꞌdãlé yị̃ị́ ꞌbá rĩ pi ní mvụụ́mvụ ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kộpi ní rizú ãwãzú Mósẽ ní kínĩ, “ꞌÍ sẽ ꞌbá ní yị̃ị́ mvụụ́.” Mósẽ ní ꞌyozú kộpi ní kĩnĩ, “Ngá ĩmi ní rizú ãwãzú má ní ꞌdíni rĩ ãꞌdi? Ĩmi ri Úpí Múngú ri ụ̃ꞌbị̃ ꞌdíni ãꞌdiãtãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ꞌBo yị̃ị́ úvá ní ꞌbá rĩ pi ndẽé káyĩ káyĩ rĩ sĩ, kộpi rikí unuú Mósẽ rụ́ꞌbá gá. Kộpi kínĩ, “Ngá mí ní ꞌbâ íjị́zú ĩfũzú Ẽjẽpétõ agásĩ ímụ́zú ũdrãzú ꞌbávé anjiŋá pi be, ãnyãpá rĩ pi be yị̃ị́ úvá sĩ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mósẽ ní kúru ngozú Úpí Múngú ẹndrẹtị gé kĩnĩ, “Mâ ꞌo rí ꞌbá nõꞌbée ní ãꞌdi? Ẹ̃sị̃ mãdã, kộpi lẽkí ma úvị́ írã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Úpí Múngú ní újázú Mósẽ ní kĩnĩ, “ꞌÍ ꞌde mụụ́ ꞌbá rĩ pi ẹndrẹtị gé sĩ drị̃drị̃. ꞌÍ ꞌdụ ambugu ụrụkọ Ĩsẽrélẽ vé rĩ pi mụụ́ mí vú sĩ ĩndĩ, ꞌí ꞌdụ kpá túré mí ní yị̃ị́ ãmbúgú dịị́pi dịdị Náyĩlĩ ẽ mị gbãzú rĩ mụzú mí drị́gé sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mí kãdõ caá írã Sĩnáyĩ vé rĩ gé ꞌdãá, ma adri mí be trụ́. ꞌÍ gbã ị̃jị́gọ́ írã rĩ ã pálé gá rĩ, yị̃ị́ ri ĩfũ ị̃jị́gọ́ rĩ agásĩ rá, ꞌbá Ĩsẽrélẽ vé rĩ pi ã mvụkí rí.” Mósẽ ní kúru tã rĩ ꞌdụzú ngazú sụ̃ Múngú ní lũú ꞌí ní rĩ tị́nị, drị̃koma Ĩsẽrélẽ vé rĩ pi tẽkí nyo rií ndreé. ");
INSERT INTO kbo_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mósẽ ní ãngũ rĩ ã rụ́ ꞌdazú Másã, ãzini Mẽríbã, ãꞌdiãtãsĩyã ꞌbá Ĩsẽrélẽ vé rĩ pi rikí unuú, ãzini rikí ꞌyoó kínĩ, “Úpí Múngú ri nyo ꞌbâ ãsámvú gé nõgó anigé, dõku ĩri ꞌdãáyo?” ");
INSERT INTO kbo_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ꞌBá Ãmãlékẽ vé rĩ pi ímụ́kí ẹ̃ꞌdị́ ꞌdịị́ ꞌbá Ĩsẽrélẽ vé rĩ pi be ãngũ Rẽfĩdímũ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mósẽ ní ꞌyozú Yósũwã ní kĩnĩ, “Mí ũpẽ ꞌbávé ãgõ ụrụkọꞌbée mụụ́ ẹ̃ꞌdị́ ꞌdịị́ ꞌbá Ãmãlékẽ vé rĩ pi be. Drụ̃ sĩ, ma pá tu ánga drị̃gé ꞌdãá, ma túré Múngú vé ũkpõ be rĩ rụ má drị́gé.” ");
INSERT INTO kbo_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yósũwã ní ãgõ rĩ pi ẽ drị̃ kozú mụzú ẹ̃ꞌdị́ rĩ ꞌdịzú ꞌbá Ãmãlékẽ vé rĩ pi be sụ̃ Mósẽ ní ẹzịị́ rĩ tị́nị. Mósẽ pi Ãrónã be, Hụ́rị̃ sĩ, tụkí mụụ́ adrií ánga drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mósẽ kãdõ túré rĩ suú ụrụ ꞌdãá, ꞌbá Ĩsẽrélẽ vé rĩ pi ẹ̃ꞌdị́ rĩ ndẽ nĩ, kãdõ túré rĩ ísị́ vũgá nõó, ꞌbá Ãmãlékẽ vé rĩ pi ẹ̃ꞌdị́ rĩ ndẽ nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mósẽ ẽ drị́ kã ũrõó túré rĩ ã rụngárá sĩ gí, Ãrónã pi Hụ́rị̃ be íꞌdụ́kí írã ꞌbãá, Mósẽ úrí drị̃ ni gé. Kộpi tukí pá Mósẽ ã gãrã gá, kộpi ẹ̃tị̃kí Mósẽ ẽ drị́ ílébe ílébe ingaá ụrụgégé cĩmgbá cazú ụ̃tụ́ ní ꞌdengárá gá. ");
INSERT INTO kbo_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yósũwã ꞌdị ẹ̃ꞌdị́ ꞌbá Ãmãlékẽ vé rĩ pi be, ndẽ kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ sĩ tã Yósũwã ní ẹ̃ꞌdị́ ndẽzú ꞌdĩri búkũ agá, ꞌí lã tã ni Yósũwã ní, ã yị, á lẽ ꞌbá Ãmãlékẽ vé rĩ pi vé úri ꞌbeé ãvĩí vũ drị̃gé sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mósẽ ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni sịzú, ĩri ní rụ́ ni ꞌdazú, “Úpí Múngú sẽ á ndẽ ẹ̃ꞌdị́ rĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ĩri ní ꞌyozú kĩnĩ, “Úpí Múngú sẽ má ní ũkpõ ẹ̃ꞌdị́ rĩ ꞌdịzú nĩ, ãꞌdiãtãsĩyã má inga mâ drị́ ụrụ ũkpõ zịzú vú ni gé. Úpí Múngú ri ímụ́ ẹ̃ꞌdị́ ꞌdị mụzú úyú Ãmãlékẽ vé rĩ pi be.” ");
INSERT INTO kbo_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yétẽrõ ri átálágú Mĩdĩyánã vé ni, ĩri Mósẽ ẹ́nyẹ́pị, yị tã Múngú ní ꞌoó Mósẽ ní, ãzini ꞌbá Ĩsẽrélẽ vé rĩ pi ní rĩ rá, yị kpá tã Úpí Múngú ní ꞌbá Ĩsẽrélẽ vé rĩ pi íjị́zú ĩfũzú ãngũ Ẽjẽpétõ vé rĩ agásĩ rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mósẽ kã ꞌî ũkú ni Sĩpúrã ri pẽé mụụ́ ívé anji ãgõ ị̃rị̃ rĩ pi be ẹ́nyẹ́pị Yétẽrõ vúgá ꞌdãá, Mósẽ ẹ́nyẹ́pị ẹ́ꞌyị́ kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Mvá kãyú rĩ ã rụ́ Gẽrẽsómã ꞌi, Mósẽ ꞌyo mvá kãyú rĩ vé tã kĩnĩ, tịkí mvá ꞌdĩri ị́sụ́ ãkũdẽ ma jãkã rú ãngũ ãzi gé. ");
INSERT INTO kbo_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mvá ãzi rĩ ã rụ́ Ẽlĩzérẽ ꞌi, Mósẽ ní ꞌyozú kĩnĩ, “Múngú má ẹ́ꞌbị́pị́ị vé rĩ ko mâ ĩzã nĩ, pa ma drã agásĩ ꞌbãgú Ẽjẽpétõ vé rĩ drị́gé sĩ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mósẽ ẹ́nyẹ́pị Yétẽrõ pi, Mósẽ vé anji ãgõ rĩ pi be, Mósẽ ũkú ni sĩ, kộpi ní ꞌdezú mụzú Mósẽ ri ndrezú ãngũ ãꞌwí cínyáfã rú rĩ gé, vũrã Mósẽ ní adrizú ĩnyiŋá írã Sĩnáyĩ vé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yétẽrõ ní ụ́ꞌdụ́kọ́ pẽzú Mósẽ ní kĩnĩ, “Ma mí ẹ́nyẹ́pị Yétẽrõ ꞌi, ꞌbá lẽkí mụụ́ mî ũkú ni be, mívé anji ãgõ ị̃rị̃ rĩ pi be mí vúgá ꞌdĩí.” ");
INSERT INTO kbo_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kộpi kâ caá ꞌdãlé, Mósẽ ní fũzú mụzú ẹ́nyẹ́pị ri ẹ́ꞌyị́zú, ĩri ní kũmũcí ũtị̃zú ẹ́nyẹ́pị ẹndrẹtị gé, ĩri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ, kộpi ní fizú gãkũ rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mósẽ ní tã Úpí Múngú ní ꞌoó ꞌbãgú Ẽjẽpétõ vé rĩ ní, ãzini ĩri ní ꞌoó ꞌbá Ẽjẽpétõ vé rĩ pi ní ꞌbá Ĩsẽrélẽ vé rĩ pi ã tã sĩ rĩ ũlũzú ẹ́nyẹ́pị ní, ĩri ní kpá tã ũkpó ũkpó ĩ ị́sụ́ꞌbá ĩ ní ímụ́ngárá gá lẹ́tị gé ꞌdĩgé Múngú ní ĩ pazú rĩ ũlũzú ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yétẽrõ kã tã múké Úpí Múngú ní ꞌbá Ĩsẽrélẽ vé rĩ pi pazú ꞌbá Ẽjẽpétõ vé rĩ pi drị́gé sĩ ꞌdĩri vé tã yịị́, sẽ ĩri ní ãyĩkõ ambamba. ");
INSERT INTO kbo_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ĩri ní ꞌyozú kĩnĩ, “Ẽ íngúkí Úpí Múngú ĩmi paápi ꞌbá Ẽjẽpétõ vé rĩ pi drị́gé sĩ, ãzini ꞌbãgú Ẽjẽpétõ vé rĩ drị́gé sĩ ꞌdĩri. ");
INSERT INTO kbo_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nóni á nị̃ rá Úpí Múngú ri ãmbúgú ũkpõ be múngú adriꞌbá túngú rĩ pi drị̃gé sĩ céré, ãꞌdiãtãsĩyã pa ꞌbá Ĩsẽrélẽ vé rĩ pi ariꞌba ẹ́sị́ be ũká ũká rĩ pi drị́gé sĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mósẽ ẹ́nyẹ́pị Yétẽrõ ní ãnyãpá íjị́zú ngá ụrụkọꞌbée be zãzú Múngú ní rọ̃bọ̃ŋọ̃ rú, Ãrónã pi ní ímụ́zú ambugu Ĩsẽrélẽ vé rĩ pi be Yétẽrõ vúgá nõó ínyá rĩ ã nyangárá gá vũrã ĩ ní rizú Múngú ri ị̃njị̃zú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kã mụụ́ adrií drụ̃ ꞌdíni, Mósẽ ní úrízú ꞌbá rĩ pi vé tã lịngárá gá sụ̃ ándúrú rĩ tị́nị, ꞌbá rĩ pi ímụ́kí pá tuú kuú Mósẽ ã gãrã gá sĩ kụ́rụ̃ cĩmgbá cazú ũndréŋá gá. ");
INSERT INTO kbo_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mósẽ ẹ́nyẹ́pị kã tã Mósẽ ní rií ꞌoó ꞌbá rĩ pi ní ꞌdĩri ndreé, ĩri ní Mósẽ ri zịzú kĩnĩ, “Ngá mí ní rizú tã lịzú ọ́ꞌdụ́kụ́lẹgúsĩ sẽzú ꞌbá rĩ pi ní íꞌdózú pá tuzú ụ̃ꞌbụ́tị cĩmgbá ũndréŋá gá ꞌdíni rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mósẽ ní újázú ẹ́nyẹ́pị ní kĩnĩ, “ꞌBá rĩ pi ri ímụ́ má vúgá nõó, ãꞌdiãtãsĩyã kộpi lẽkí tã Múngú ní lẽé ã ꞌokí rĩ nị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kộpi dõ tã be ĩ ãsámvú gé sĩ anigé, kộpi íjị́ má vúgá, ma kúru kộpivé tã ãsámvú aco, ma tã Múngú ní lẽé ã ꞌokí rĩ ũlũ kộpi ní, ãzini ma tãị́mbị́ Múngú vé rĩ ímbá kộpi ní.” ");
INSERT INTO kbo_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mósẽ ẹ́nyẹ́pị ní újázú Mósẽ ní kĩnĩ, “Tã mí ní rií ꞌoó ꞌdĩri adri múké ku. ");
INSERT INTO kbo_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Mi, ꞌbá ímụ́ꞌbá mí vúgá ꞌdĩꞌbée be, ĩmi ímụ́ ãndẽ rá. Ẹ̃zị́ rĩ mi ŋõŋõ, mí ícó ngaá ọ́ꞌdụ́kụ́lẹgúsĩ ku. ");
INSERT INTO kbo_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ꞌÍ yị drĩ ma ká, á lẽ mî ĩzã koó tã ꞌdĩri sĩ, Múngú ã adri mí be. ꞌÍ tu pá ꞌbá rĩ pi vé tã tị gé, ꞌí jị kộpivé tã ũlũú Múngú ní. ");
INSERT INTO kbo_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Mí ímbá kộpi ní tã Múngú ní lẽé ã ꞌokí rĩ, ãzini mí ímbá tãị́mbị́ Múngú vé rĩ, mí iꞌda kộpi ní lẹ́tị adrizú ãní múké rĩ, ãzini lẹ́tị ẹ̃zị́ ngazú rĩ. ");
INSERT INTO kbo_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Lẽ mî ũpẽ ꞌbá ẹ̃zị́ ngaꞌbée múké Múngú ri ị̃njị̃ꞌbá ị̃njị̃njị̃, tã ꞌoꞌbá pịrị, ẹ́sị́ ꞌbãꞌbée ngá drị̃gé ku ni pi ꞌbá ꞌdĩꞌbée ãsámvú gé. Mí ũꞌbã kộpi drị̃koma rú ngúlúmũ ꞌbá be élĩfũ ãlu rĩ pi drị̃gé, ngúlúmũ ꞌbá be mụ̃dụ̃rụ̃lụ̃ ãlu rĩ pi drị̃gé, ngúlúmũ ꞌbá be pụ̃kụ́ tọ̃wụ́ rĩ pi drị̃gé, ngúlúmũ ꞌbá be mụdrị́ rĩ pi drị̃gé, kộpi ã rikí ꞌbá ꞌdĩꞌbée vé tã ãsámvú acoó. ");
INSERT INTO kbo_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Lẽ ꞌbá ꞌdĩꞌbée ã rikí ꞌbá rĩ pi vé tã lịị́ sâ be céré, lẽ kộpi ẽ íjị́kí tã ũkpó ũkpó rĩ pi mí ẹndrẹtị gé, tã adriꞌbá mũnyámúnya rĩ pi, lẽ kộpi ã lịkí tã ni. ꞌÍ ꞌo dõ sụ̃ ꞌdĩri tị́nị, ĩri sẽ ẹ̃zị́ riípi mi ŋõópi rĩ ĩri ícá kọ̃wụ́kọ́wụ, ãꞌdiãtãsĩyã ĩmi ri tã rĩ ãlẽ kộpi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ꞌÍ ꞌdụ dõ tã má ní ẹzịị́ mí ní ꞌdĩri ngaá rá, ãzini Múngú lũ dõ mí ní kĩnĩ, mî ꞌo ꞌdíni, mî ẹ́sị́ ri adri ũkpó ũkpó, sẽ mí ãndẽ ku, ꞌbá ꞌdĩꞌbée kúru céré nga mụ ꞌbẹ̃tị́ ꞌdãá, ị́sụ́ kộpi ẹ́pị́kí tã rĩ sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mósẽ yị tã ẹ́nyẹ́pị ní ímbá ꞌí ní rĩ rá, ꞌdụ tã ẹ́nyẹ́pị ní ꞌyoó rĩ pi ãrẽvú ngaá céré rá. ");
INSERT INTO kbo_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ĩri ní ꞌbá ẹ̃zị́ ngaꞌbée múké ni pi ũpẽzú ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé, ũꞌbã kộpi drị̃koma rú, ngúlúmũ ꞌbá be élĩfũ ãlu (1,000) rĩ pi drị̃gé, ngúlúmũ ꞌbá be mụ̃dụ̃rụ̃lụ̃ ãlu (100) rĩ pi drị̃gé, ngúlúmũ ꞌbá be pụ̃kụ́ tọ̃wụ́ (50) rĩ pi drị̃gé, ãzini ngúlúmũ ꞌbá be mụdrị́ rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Kộpi rikí ꞌbá rĩ pi vé tã lịị́ sâ be céré. Tã ũkpó ũkpó rĩ pi kộpi rikí íjị́ Mósẽ ẹndrẹtị gé, tã adriꞌbá mũnyámúnya rĩ pi kộpi rikí lịị́ nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mósẽ ní kúru ẹ́nyẹ́pị Yétẽrõ ri jịzú kuzú lẹ́tị gé, ĩri ní ꞌyozú, mí ẹ́cị́ múké. Yétẽrõ ní ꞌi újázú gõzú vúlé ãngũ ꞌí ní adrizú rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ ĩfũú ãngũ Ẽjẽpétõ vé rĩ agásĩ, kộpi tukí ẹ̃cị̃ caá mbãá ị̃rị̃, kộpi cakí ãngũ ãꞌwí cínyáfã rú rĩ gé Sĩnáyĩ gé ꞌdãá ụ́ꞌdụ́ ãlu mbãá na vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ꞌBá Ĩsẽrélẽ vé rĩ pi kâ fũú ãngũ Rẽfĩdímũ vé rĩ agásĩ, kộpi cakí mụụ́ adrií ãngũ ãꞌwí cínyáfã rú Sĩnáyĩ vé rĩ gé, kộpi ní áwízú adrizú írã rĩ ã pálé gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mósẽ ní kúru tụzú mụzú Múngú vúgá írã drị̃gé ꞌdãá, Úpí Múngú ní ĩri zịzú írã drị̃gé ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Tã má ní lẽé mî ꞌyo Yõkóbũ vé úyú Ĩsẽrélẽ rĩ pi ní rĩ ĩri ꞌdĩ, ");
INSERT INTO kbo_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Ĩmi ndrekí tã má ní ꞌoó ꞌbá Ẽjẽpétõ vé rĩ pi ní rĩ rá, má íꞌdụ́ ĩmi íjị́ má vúgá nõó sụ̃ bị̃bị̃ ní ívé anjiŋá uꞌdụụ́ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ĩmi ꞌdụkí dõ tã mávé rĩ ngaá ẹ́sị́ be céré, ãzini ĩmi ꞌdụkí dõ ũndĩ má ní rụụ́ ĩmi be ꞌdĩri vé tã ngaá rá, ĩmi adri ꞌbá mávé ni ꞌbá vũ drị̃gé rĩ pi ãsámvú gé sĩ céré. ꞌBá vũ drị̃gé rĩ pi céré adri mávé ni, ");
INSERT INTO kbo_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ꞌbo ĩmi ímụ́ adri sụ́rụ́ uletere, ri ẹ̃zị́ nga má ní atala rú.’ Ụ́ꞌdụ́kọ́ má ní lẽé mî átá ꞌbá Ĩsẽrélẽ vé rĩ pi ní rĩ ĩri adriípi ꞌdĩ.” ");
INSERT INTO kbo_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mósẽ ní kúru ĩgõzú írã drị̃gé ꞌdãásĩ, ĩri ní ꞌbá ĩ ní ũꞌbãá drị̃koma rú rĩ pi zịzú ímụ́zú vũrã ãlu gé, ĩri ní tã Úpí Múngú ní ẹzịị́ ꞌí ní rĩ ũlũzú kộpi ní céré. ");
INSERT INTO kbo_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ꞌBá rĩ pi ngakí céré tã ꞌdĩri ẹ̃ꞌyị̃ị́ kínĩ, “Tã ãrẽvú céré Úpí Múngú ní ẹzịị́ rĩ ꞌbâ ꞌdụ nga rá.” Mósẽ ní kúru tã kộpi ní ẹ̃ꞌyị̃ị́ rĩ jịzú mụzú ũlũzú Úpí Múngú ní. ");
INSERT INTO kbo_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “Ma mụ mí vúgá ꞌdĩí ị́rị́bị́tị ãsõópi nịị́pi cịcị ni agásĩ, má kãdõ rií átá mí be, ꞌbá rĩ pi ã yịkí rí mávé ụ́ꞌdụ́kọ́, kộpi ã ꞌbãkí rí ẹ́sị́ céré kuú mí drị̃gé.” Mósẽ ní kúru tã ꞌbá rĩ pi ní ꞌyoó rĩ ũlũzú Úpí Múngú ní. ");
INSERT INTO kbo_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ mụ lũú ꞌbá rĩ pi ní, íꞌdózú ãndrũ cazú drụ̃ sĩ, lẽ kộpi ã gụ̃kí ĩ adrií uletere. Kộpi ã ũjĩkí ĩvé bõngó ũjĩjĩ. ");
INSERT INTO kbo_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ụ́ꞌdụ́ na ni gé, lẽ ꞌbá rĩ pi ã útúkí ĩ kú ũrẽ, ãꞌdiãtãsĩyã Úpí Múngú ri ísị́ ímụ́ adri írã Sĩnáyĩ vé rĩ drị̃gé, ꞌbá rĩ pi céré nga ma ndre rá. ");
INSERT INTO kbo_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ꞌÍ sĩ légéré írã rĩ ã gãrã gá sĩ kụ́rụ̃, ꞌí lũ ꞌbá rĩ pi ní, ‘Lẽ ku ĩmi ní ọvụzú légéré rĩ drị̃gé sĩ, ímụ́zú ĩnyiŋá írã rĩ ã rụ́ꞌbá gá nõó, ãzini lẽ ĩmi úlókí írã rĩ ã rụ́ꞌbá ku. ꞌBá rĩ úló dõ írã rĩ ã rụ́ꞌbá gí, ĩ ĩri ꞌdị drã ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ĩ ĩri úvị́ írã sĩ, dõku ĩ ĩri gbi íꞌyé sĩ, ꞌdịkí dõ ĩri drãá ꞌdíni, lẽ ꞌbá ãzi ã úló ãvũ ni ã rụ́ꞌbá ku. Ngá rĩ dõ ꞌbá, dõku ãnyãpá, ícókí ĩri kuú adrií ídri rú ku.’ ꞌBá rĩ pi yịkí dõ jẽlẽgú ã ụ́ꞌdụ́kọ́ gí, kộpi ẽ íbíkí rí tụụ́ írã drị̃gé ꞌdãá ndõ.” ");
INSERT INTO kbo_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mósẽ kã ísị́ írã drị̃gé ꞌdãásĩ ꞌbá rĩ pi vúgá nõó, ĩri ní ꞌyozú kộpi ã gụ̃kí ĩ adrií uletere, kộpi ní ĩvé bõngó ũjĩzú. ");
INSERT INTO kbo_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ĩri ní ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “Lẽ ĩmi útúkí ĩmi kú ị́nọ́gọ́sị́ rizú ụ́ꞌdụ́ na ꞌdãri ũtẽzú, ꞌbá ãzi ã lã ũkú be ku.” ");
INSERT INTO kbo_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kã mụụ́ caá ụ́ꞌdụ́ na ni gé, ụ̃ꞌbụ́tịŋá rĩ sĩ, ũvi ní lĩzú, ãngũ rĩ ní gazú lọ́kụ́lọ́kụ́, ị́rị́bị́tị ní ãsõzú ịnịkụrụkụrụ írã drị̃gé ꞌdãá, gũké ní kúru ꞌụzú kụ́bị́ be ụrụ ꞌdãá. ꞌBá adriꞌbá vũrã ꞌdãri gé rĩ pi ã rụ́ꞌbá ngakí céré yãáyã. ");
INSERT INTO kbo_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mósẽ ní kúru ꞌbá rĩ pi ẽ drị̃ kozú fũzú vũrã kộpi ní adrizú rĩ agásĩ Múngú vúgá ꞌdãá, ꞌbá rĩ pi áwíkí pá tuú kuú írã rĩ ã pálé gá. ");
INSERT INTO kbo_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ãcígã ọ̃zụ̃ írã Sĩnáyĩ vé rĩ ẽ drị̃ céré, ãꞌdiãtãsĩyã Úpí Múngú ísị́ ímụ́ írã drị̃gé nõó ãcí dị̃ị́pi dị̃dị̃ ni agásĩ. Ãcígã rĩ tụ ụrụgégé ꞌdãá, sụ̃ ãcígã tụụ́pi ãcí ĩ ní ũdẽé kuú ãmbúgú ãmbúgú rĩ agásĩ rĩ tị́nị, írã rĩ aya ꞌi ũkpõ be dĩngídĩngí. ");
INSERT INTO kbo_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Jẽlẽgú rĩ vé ụ́ꞌdụ́kọ́ ri ọ́ꞌụ́ mụzú mgbuwa, mgbuwa. Mósẽ ní átázú, Múngú ní újázú ĩri ní ụ́ꞌdụ́kọ́ be sụ̃ ũvi ní lĩí rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Úpí Múngú ní ísị́zú ímụ́zú írã Sĩnáyĩ vé rĩ drị̃gé ꞌdãá, ĩri ní Mósẽ ri zịzú mụzú ꞌí vúgá írã drị̃gé ꞌdãá. Mósẽ ní kúru tụzú mụzú írã drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ sị mụụ́ ꞌbá rĩ pi vũgá ꞌdãá, ꞌí mụ ꞌyoó kộpi ní, lẽ kộpi ã ọvụkí légéré mí ní sĩí ꞌdĩri drị̃gé sĩ ímụ́ ma ndreé ku, kộpi ọvụkí dõ légéré rĩ gí, kộpi ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Atala lẽꞌbá ímụ́ꞌbá Úpí Múngú vúgá nõó rĩ pi, lẽ kộpi ã gụ̃kí ĩ adrií uletere. Kộpi gụ̃kí dõ ĩ adrií uletere ku, Úpí Múngú ri kộpi úꞌdị́ ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mósẽ ní ꞌyozú Úpí Múngú ní kĩnĩ, “ꞌBá rĩ pi ícókí ítụ́ írã Sĩnáyĩ vé rĩ drị̃gé nõó ku, ãꞌdiãtãsĩyã mí ꞌyo ꞌbá ní, mí kĩnĩ, ꞌbâ ítrúkí ꞌbâ írã rĩ ã pálé gá ĩnyiŋá nõó ku, ãꞌdiãtãsĩyã vũrã ꞌdĩri ĩri uletere.” ");
INSERT INTO kbo_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Úpí Múngú ní újázú Mósẽ ní kĩnĩ, “ꞌÍ sị mụụ́ vũgá ꞌdãá, mí íjị́ Ãrónã ri ímụ́ írã drị̃gé nõó. ꞌBo atala rĩ pi ꞌbá rĩ pi be, lẽ kộpi ã sikí ĩ ímụ́ má vúgá nõó ũkpó sĩ ku, kộpi sĩkí dõ ĩ ímụ́ ũkpõ sĩ, ma kộpi úꞌdị́ ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mósẽ ní kúru ísị́zú ímụ́zú ꞌbá rĩ pi vúgá nõó, ĩri ní tã Úpí Múngú ní ꞌyoó rĩ ũlũzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Tã Múngú ní ẹzịị́ ꞌbá rĩ pi ní rĩ ĩri ꞌdíni kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ma Úpí Múngú ĩmivé rĩ, má íjị́ ĩmi ĩfũú ĩzãngã ĩmi ní nyaá tụ́gẹ̃rị̃ rú Ẽjẽpétõ agá ꞌdãá rĩ agásĩ nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Lẽ ĩmi ị̃njị̃kí múngú ãzi túngú ni ku, ĩmi ị̃njị̃kí ꞌyéŋá ma áyu. ");
INSERT INTO kbo_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Lẽ ĩmi údékí ngá ãzi índré múngú rú sụ̃ ngá ꞌbụ̃ gé ni tị́nị ku, dõku ngá vũ drị̃gé ni tị́nị ku, dõku ngá yị̃ị́ agá ni tị́nị ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Lẽ ĩmi ọ̃vụ̃kí drị̃ sị̃ị́ vũgá ngá ĩ ní údé múngú rú ꞌdĩꞌbée ị̃njị̃zú ku, ãꞌdiãtãsĩyã ma Úpí Múngú ĩmivé rĩ, á lẽ ꞌbá ãzi ẽ ị̃njị̃ múngú ãzi ku. ꞌBá ma gãꞌbá sĩ rĩ pi, ma kộpivé anjiŋá ĩrĩŋã ũnjĩkãnyã kộpivé ẹ́tẹ́pị ní ꞌoó rĩ sĩ, ma íꞌdó ĩrĩŋã úyú na rĩ gé cĩmgbá cazú úyú sụ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ꞌBo ꞌbá rĩ lẽ dõ ma rá, ãzini ꞌdụ dõ tã má ní ẹzịị́ rĩ ngaá rá, ma ẹ́sị́ múké ꞌbã ĩrivé úyú rĩ pi drị̃gé cĩmgbá cazú úyú élĩfũ kárákará rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Lẽ ĩmi rikí Úpí Múngú ĩmivé rĩ ã rụ́ zịị́ tã ũnjí ꞌozú ku, ĩmi zịkí dõ Múngú ã rụ́ tã ũnjí ꞌozú, Úpí Múngú ri ĩmi ĩrĩŋã rá. ");
INSERT INTO kbo_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Lẽ ĩmi ígákí ụ́ꞌdụ́ Sãbátã vé rĩ, ĩmi ꞌbãkí ĩri adrií uletere. ");
INSERT INTO kbo_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lẽ ĩmi ngakí ĩmivé ẹ̃zị́ ãrẽvú céré dẹẹ́ ụ́ꞌdụ́ ázíyá gá, ");
INSERT INTO kbo_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ꞌbo Sãbátã ri ụ́ꞌdụ́ uvuzú ni, ĩri ụ́ꞌdụ́ Úpí Múngú ĩmivé rĩ vé ni. Ụ́ꞌdụ́ ꞌdĩri gé, lẽ ĩmi ngakí ẹ̃zị́ ku, mí úlúngu, dõku mívé mvá ágó, dõku mívé mvá ũkú, dõku mívé ãtíꞌbá ágó rú rĩ, dõku mívé ãtíꞌbá ũkú rú rĩ, dõku mívé ãnyãpá rĩ pi, dõku ꞌbá jãkã rú ímụ́pi adriípi mívé ꞌbẹ̃tị́ ãsámvú gé rĩ, ã nga ẹ̃zị́ ụ́ꞌdụ́ Sãbátã vé rĩ gé ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ãꞌdiãtãsĩyã Úpí Múngú gbi ꞌbụ̃ pi vũ be, yị̃ị́ tafu rĩ be, ngá ꞌa ni agá rĩ pi be céré ꞌdụ caá ụ́ꞌdụ́ ázíyá, ꞌbo kã mụụ́ caá ụ́ꞌdụ́ ẹ́zị̂rị̃ ni gé, ĩri ní uvuzú. Úpí Múngú ní kúru tãkíri ꞌbãzú ụ́ꞌdụ́ Sãbátã vé ꞌdĩri drị̃gé, ã adri uletere. ");
INSERT INTO kbo_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Lẽ mî ị̃njị̃ mí ẹ́tẹ́pị pi mí ẹ́ndrẹ́pị be ị̃njị̃njị̃, mî adri rí caá ílí be aco ãngũ Úpí Múngú mívé rĩ ní sẽé mí ní rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Lẽ mî ꞌdị ꞌbá ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Lẽ mî ꞌbã ọ̃wụ̃ ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Lẽ mî ụ̃gụ̃ ngá ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Lẽ mî úlị́ ũnjõ ꞌbá mî gãrã gá rĩ drị̃gé ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Lẽ mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé jó drị̃gé ku. Lẽ mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé ũkú drị̃gé ku, dõku mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé ãtíꞌbá ágó rú rĩ drị̃gé ku, dõku mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé ãtíꞌbá ũkú rú rĩ drị̃gé ku, dõku mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé tị́ drị̃gé ku, dõku mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé dõngí drị̃gé ku, dõku mî ꞌbã ẹ́sị́ ꞌbá mî gãrã gá rĩ vé ngá drị̃gé ku.” ");
INSERT INTO kbo_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ꞌBá rĩ pi kâ ũvi rĩ vé lĩngárá, ãzini jẽlẽgú rĩ vé ꞌụngárá yịị́, ãzini kộpi kâ ũvi rĩ vé gangárá lọ́kụ́lọ́kụ́ rĩ ndreé ãcígã írã ẽ drị̃ ọ̃zụ̃ụ́pi rĩ be, sẽ ụ̃rị̃ ị́mvụ́ kộpi ambamba, kộpi yãkí ãní kpĩríkpĩrí, kộpi áwíkí pá tuú rárá rú. ");
INSERT INTO kbo_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kộpi ní ꞌyozú Mósẽ ní kínĩ, “Lẽ mî átá ꞌbá ní átángá rĩ nĩ, ꞌbâ ícó yị rá. ꞌBo lẽ mî ku Múngú átá átángá rĩ ꞌbá ní nĩ ku, ĩri sẽ ꞌbâ ũdrã rá.” ");
INSERT INTO kbo_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mósẽ ní újázú kộpi ní kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku, Múngú ímụ́ ĩmi ụ̃ꞌbị̃ị́, ụ̃rị̃ ã rụ rí ĩmi, ĩmi ꞌokí rí ũnjĩkãnyã ku.” ");
INSERT INTO kbo_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ꞌBá rĩ pi áwíkí pá tuú kuú rárá rú. Mósẽ fi ãngũ nịị́pi cịcị Múngú ní adrizú rĩ agá ꞌdãá nĩ. ");
INSERT INTO kbo_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kúru Úpí Múngú ní ꞌyozú Mósẽ ní kĩnĩ, “ꞌÍ lũ ꞌbá Ĩsẽrélẽ vé rĩ pi ní ꞌdíni, ‘Ĩmi ndrekí ĩmî mị sĩ rá, á ri átá íngázú ꞌbụ̃ gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Lẽ ĩmi údékí aya ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ni pi rií ị̃njị̃ị́ múngú rú ku, dõku lẽ ĩmi údékí dábũ rií ị̃njị̃ị́ múngú rú ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Lẽ ĩmi usakí nyọ̃ọ́kụ́, ĩmi sịkí má ní vũrã rọ̃bọ̃ŋọ̃ zãzú ni, ĩmi zãkí rí má ní kãbĩlõ, ndrị̃ị́, ãzini tị́ rọ̃bọ̃ŋọ̃ rú ãní. Ma sị mụzú vũgá ꞌdĩí, ma mụ ĩmi ní tãkíri sẽ vũrã ĩ ní rizú ma ị̃njị̃zú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ĩmi sịkí dõ má ní vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ írã sĩ, lẽ ĩmi sịkí írã ĩ ní rụ́ꞌbá ni upaá kuyé ni sĩ, ã upakí rụ́ꞌbá ni ayaŋá sĩ ku, ãꞌdiãtãsĩyã ĩri sẽ vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ adri ãní uletere ku. ");
INSERT INTO kbo_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Lẽ ĩmi tụkí mụzú vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ gé ꞌdãá vũrã pá ũꞌbãzú rĩ gé sĩ ku, ꞌbâ ãzi ã ndre rí ĩmî rụ́ꞌbá ule rĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Lókí ꞌbá tã lịꞌbá rĩ pi ní ãngũ rụzú ãngũ Ĩsẽrélẽ vé rĩ agá rĩ gé, ẹ̃bị́rị́ ꞌde ãngũ rĩ agá ũnjí ũnjí. Ágó ãzi kụ̃rụ́ Bẽtẽlémẽ vé rĩ agá, ãngũ Yụ́dã vé rĩ agá, ꞌdụ ívé ũkú ívé anji ãgõ ị̃rị̃ rĩ pi be, ꞌde mụụ́ adrií ãngũ Mõábã vé rĩ agá ꞌdãlé ũkõlõ. ");
INSERT INTO kbo_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ágó rĩ ã rụ́ Ẽlĩmẽlékẽ ꞌi, ũkú ni ã rụ́ Nõómé ꞌi, ĩrivé anji ị̃rị̃ ꞌdĩꞌbée, ãzi rĩ ã rụ́ Mãlónã ꞌi, ãzi rĩ Kĩlĩyónã ꞌi. Kộpivé sụ́rụ́ Ẽfãrátã, kộpi kụ̃rụ́ Bẽtẽlémẽ vé rĩ agá, ãngũ Yụ́dã vé rĩ agá. Kộpi ꞌdekí mụụ́ adrií ãngũ Mõábã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Nõómé ágó ni Ẽlĩmẽlékẽ ní drãzú, ku Nõómé pi kú ĩrivé anji ãgõ ị̃rị̃ ꞌdĩꞌbée be. ");
INSERT INTO kbo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Anji ãgõ ị̃rị̃ ꞌdĩꞌbée ní anji ũkú Mõábã vé ni pi jezú ĩ ní ũkú rú, ũkú ãzi rĩ ã rụ́ Úrũpã ꞌi, ãzi rĩ Rụ́tã ꞌi. Kộpi kâ adrií caá ꞌdãlé ílí mụdrị́, ");
INSERT INTO kbo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Mãlónã pi ní ũdrãzú Kĩlĩyónã be ị̃rị̃trọ́, kukí Nõómé ri kú anji ãkó, ágó ãkó. ");
INSERT INTO kbo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nõómé kã yịị́ ãngũ Mõábã vé rĩ gé ꞌdãlé kínĩ, Úpí sẽ ãnyãngã ka ꞌbá rĩ pi ní ãngũ Yụ́dã vé rĩ gé ꞌdãá, Nõómé pi ní ĩ útúzú ívé anji ị̃rị̃ ꞌdĩꞌbée vé ũkú pi be ãngũ Mõábã vé rĩ gé ꞌdãlé, lẽzú ĩ újázú gõzú vúlé ãngũ Yụ́dã vé rĩ gé ꞌdãlé ũzi. ");
INSERT INTO kbo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Kộpi ní vũrã ĩ ní rizú adrizú ꞌdãri kuzú, Nõómé pi ní mụzú ívé anji ũdrãꞌbá ị̃rị̃ ꞌdĩꞌbée vé ũkú pi be, kộpi ꞌdụkí lẹ́tị mụụpi Yụ́dã gá rĩ, kộpi újákí ĩ gõzú vúlé ãngũ Yụ́dã vé rĩ gé ꞌdãlé ũzi. ");
INSERT INTO kbo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kúru Nõómé ní ꞌyozú ívé anji ị̃rị̃ ꞌdĩꞌbée vé ũkú pi ní kĩnĩ, “Ĩmi mvikí gõó ĩmivé ãngá ĩmi ẹ́ndrẹ́pị́ị vúgá. Úpí ã ꞌbã ẹ́sị́ múké ĩmi ní, sụ̃ ĩmi ní ẹ́sị́ múké ꞌbãá ĩmivé ãgõ ũdrãꞌbée gí rĩ pi ní, ãzini ĩmi ní ꞌbãá má ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Úpí ã sẽ ĩmi ní ãgõ ĩmi tã mbaꞌbée múké ni pi.” Kúru ĩri ní kộpi uꞌdezú ẹzịzú bẹ̃drị̃ sĩ, Rụ́tã pi Úrũpã be, kộpi ní íꞌdózú ngozú. ");
INSERT INTO kbo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Kộpi ní ꞌyozú Nõómé ní kínĩ, “ꞌBá lẽkí ꞌbâ újá gõó mụụ́ mí be trụ́ mívé ꞌbá rĩ pi vúgá ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nõómé ní ꞌyozú kĩnĩ, “Má anji rĩ, ĩmi újákí ĩmi gõó ĩmivé ãngá ꞌdãlé ũzi. Ngá ĩmi ní lẽzú mụzú má vúgá sĩ ĩndĩ rĩ ãꞌdi? Ma gõ anji ãgõ tị dị̃ị́, kộpi ã adrikí rí ĩmi ní ãgõ rú? ");
INSERT INTO kbo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Má anji rĩ, ĩmi újákí ĩmi gõó ĩmivé ãngá ꞌdãlé ũzi, á dẽ gí, má ícó gõó ágó jeé dị̃ị́ ku. Mâ ꞌbã dõ ẹ́sị́ ágó jezú, ãzini mâ adri dõ ágó be ị́nị́ŋá ãndrũ nõri gé, mâ tị dõ anji ãgõ, ");
INSERT INTO kbo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ĩmi nyo ícó tẽ cĩmgbá cazú lókí kộpi ní mbazú rĩ gé rá? Ĩmi nyo ícó adri ãgõ ãkó kộpi ũtẽzú rá? Má anji rĩ, ĩmi ícókí ũtẽé bã ku. Tã ĩmivé ꞌdĩri sẽ má ní ĩzãngã, ndẽ ĩzãngã ĩmivé rĩ rá, ãꞌdiãtãsĩyã Úpí sẽ nóni ma ri ĩzãngã nya.” ");
INSERT INTO kbo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kộpi gõkí ngoó dị̃ị́ ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá. Kúru Úrũpã ní ị̃drẹ́pị ri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ, ĩri ní ꞌdezú mụzú, ꞌbo Rụ́tã áwí ívé rĩ adrií kuú ị̃drẹ́pị Nõómé be. ");
INSERT INTO kbo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nõómé ní ꞌyozú Rụ́tã ní kĩnĩ, “ꞌÍ ndre drĩ ká, mí ẹ̃ꞌyẹ́pị ri ꞌde mụzú ívé ꞌbá rĩ pi vúgá, ãzini ívé múngú rĩ pi vúgá, ĩmi ꞌdekí mụụ́ ĩri be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rụ́tã ní ꞌyozú kĩnĩ, “Mî ꞌyo mâ ku mi, dõku mâ gõ vúlé ꞌdíni ku. Vũrã mí ní mụzú rĩ gé, ma mụ ĩndĩ. Vũrã mí ní mụzú adrizú rĩ gé, ma kpá mụ adri mí be trụ́. ꞌBá mívé rĩ pi, kộpi adri ꞌbá mávé ni, Múngú mívé rĩ, ĩri adri Múngú mávé ni. ");
INSERT INTO kbo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Vũrã mí ní drãzú rĩ gé, ma kpá drã, ĩ ma sị̃ vũrã ꞌdãri gé. Á ꞌdụ dõ tã rĩ ngaá sụ̃ má ní ꞌyoó rĩ tị́nị kuyé, lẽ Úpí ẽ ĩrĩŋã ma ũnjí ũnjí, drã ri ꞌbâ ãsámvú aco mí be nĩ.” ");
INSERT INTO kbo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nõómé kã ndreé Rụ́tã lẽ mụụ́ ꞌí vúgá sĩ ĩndĩ, gõ tã ãzi ꞌyoó dị̃ị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kúru ũkú ị̃rị̃ ꞌdĩꞌbée ní ꞌdezú mụzú, kộpi ní cazú Bẽtẽlémẽ gá ꞌdãlé. Kộpi kâ caá Bẽtẽlémẽ gá ꞌdãá, ꞌbá kụ̃rụ́ agá ꞌdãlé rĩ pi céré ãyãkí ãyãyã kộpivé ícángárá sĩ. Ũkú rĩ pi ní ꞌyozú kínĩ, “ꞌBá ꞌdĩri nyo Nõómé ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nõómé ní újázú kộpi ní kĩnĩ, “Ã zịkí ma Nõómé ꞌi ku. Ĩmi zịkí ma Márã, ãꞌdiãtãsĩyã Múngú Ũkpõ ꞌDị́pa sẽ á cị drị̃ ambamba. ");
INSERT INTO kbo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ọ́tụ́ má ní fũzú mụzú rĩ gé, ma ágó be, ma anjiŋá be, ꞌbo Úpí sẽ má újá ma ĩgõó lị́kị́cọ́ rú. Ngá ĩmi ní ma zịzú Nõómé rĩ ãꞌdi? Úpí sẽ á nya ĩzãngã, ãzini Múngú Ũkpõ ꞌDị́pa sẽ má ị́sụ́ drị̃lé ũnjí.” ");
INSERT INTO kbo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nõómé ímví ĩgõó ãngũ Mõábã vé rĩ gé ꞌdãásĩ, kộpi ímvíkí Rụ́tã Mõábãzị́ rĩ be trụ́. Kộpi cakí Bẽtẽlémẽ gá ꞌdãá lókí ĩ ní rizú ũndú lịzú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ágó ãzi rụ́ ni Bõójã ꞌi, ágó rĩ Nõómé ágó ni Ẽlĩmẽlékẽ vé máríté, ĩri ãꞌbú be, ĩri ꞌbá ĩ ní ị̃njị̃ị́ ị̃njị̃ ni. ");
INSERT INTO kbo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ụ́ꞌdụ́ ãlu, Rụ́tã Mõábãzị́ rĩ ní ꞌyozú Nõómé ní kĩnĩ, “Á lẽ mụụ́ ũndú uꞌdeꞌbá vũgá sĩ rĩ pi uꞌdụụ́ ꞌbá ẹ́sị́ be múké ícópi mâ ĩzã koópi ni vé ọ́mvụ́ agá.” Nõómé ní ꞌyozú ĩri ní kĩnĩ, “Mâ mvá rĩ, ꞌí ꞌde mụụ́ ĩyí.” ");
INSERT INTO kbo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kúru Rụ́tã ní ꞌdezú mụzú, ĩri ní fizú ọ́mvụ́ agá ꞌdãá, ĩri ní íꞌdózú ũndú rĩ uꞌdụzú ꞌbá ũndú lịꞌbá rĩ pi ã vụ́drị̃ gé sĩ. Gõ ámá ị́sụ́ ãkũdẽ ꞌi ri ẹ̃zị́ rĩ nga Bõójã adriípi sụ́rụ́ Ẽlĩmẽlékẽ vé rĩ agá rĩ vé ọ́mvụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Bõójã ní ícázú Bẽtẽlémẽ gá ꞌdãásĩ, ĩri ní ꞌbá ũndú lịꞌbá rĩ pi ẹzịzú kĩnĩ, “Úpí ã adri ĩmi be!” Kộpi ní újázú kínĩ, “Úpí ã sẽ mí ní tãkíri!” ");
INSERT INTO kbo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bõójã ní ꞌbá ũndú lịꞌbá rĩ pi vé ãmbúgú zịzú kĩnĩ, “Ũkú adriípi ízóŋá rú ꞌdãri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","ꞌBá ũndú lịꞌbá rĩ pi vé ãmbúgú rĩ ní ꞌyozú kĩnĩ, “Ũkú rĩ Mõábãzị́, kộpi íbíkí ímụ́ ãngũ Mõábã vé rĩ gélésĩ Nõómé be trụ́. ");
INSERT INTO kbo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ũkú rĩ zị té ma ụ̃ꞌbụ́tịŋá rĩ sĩ kĩnĩ, ꞌí lẽ ũndú uꞌdeꞌbá vũgá sĩ rĩ pi uꞌdụụ́ ꞌbá ũndú lịꞌbá rĩ pi ã vụ́drị̃ gé sĩ. Ũkú rĩ íꞌdó té ẹ̃zị́ ngaá ụ̃ꞌbụ́tị, cĩmgbá ícázú sâ nõri gé, mụ uvuú sâŋá be mãdã ápãlá ã ndụ́gé.” ");
INSERT INTO kbo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Kúru Bõójã ní ꞌyozú Rụ́tã ní kĩnĩ, “Mâ mvá rĩ, ꞌí yị drĩ ma ká, ã mụkí ũndú uꞌdeꞌbá vũgá sĩ rĩ uꞌdụụ́ ọ́mvụ́ ãzi agá ku, lẽ mî fũ ọ́mvụ́ nõri agásĩ ku. Ĩmi adrikí mávé ãtíꞌbá ũkú rú nõꞌbée be nõgó. ");
INSERT INTO kbo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Lẽ mî ndre ãgõ rĩ pi dõ ri ũndú rĩ lị ọ́mvụ́ agá ꞌdãá wọ̃ọ́kọ̃ ngõri gé, ꞌí ꞌde ũkú adriꞌbá ãtíꞌbá rú rĩ pi ã vụ́drị̃ gé sĩ. Á ꞌyo ãgõ rĩ pi ní gí, kộpi ã ꞌokí mi ũnjí ku. Yị̃ị́ úvá ndẽ dõ mi gí, ꞌí mụ yị̃ị́ ãgõ rĩ pi ní dãá ũdrí agá ꞌdãri ĩbẽé mvụụ́.” ");
INSERT INTO kbo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rụ́tã ní kũmũcí ũtị̃zú vũgá, ĩri ní ꞌî drị̃ sị̃zú nyọ̃ọ́kụ́ gé ꞌdãá, ĩri ní Bõójã ri zịzú kĩnĩ, “Ma jãkãzị́, ngá mí ní ẹ́sị́ múké ꞌbãzú má ní, ãzini mí ní mâ tã ꞌdụzú ꞌbãzú ãmbúgú rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bõójã ní újázú ĩri ní kĩnĩ, “Mí ágó ni ní drãzú rĩ ã vụ́drị̃ gé, tã mí ní ꞌoó mî ị̃drẹ́pị ní rĩ, ũlũkí má ní céré. Tã mí ní mí ẹ́tẹ́pị ri kuzú, mí ẹ́ndrẹ́pị ri kuzú, mívé ãngũ kuzú ímụ́zú adrizú ꞌbá mí ní ụ̃kụ ni nị̃ị́ kuyé nõꞌbée be nõri, ũlũkí má ní gí. ");
INSERT INTO kbo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Lẽ Úpí ã sẽ mí ní ãndẽma ãmbúgú tã mí ní ꞌoó rĩ sĩ, Múngú Ĩsẽrélẽ rĩ pi vé mí ní ífí ĩrivé ụ̃pịlẹ́ꞌbí ã ndụ́gé rĩ ã ũtẽ mi.” ");
INSERT INTO kbo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rụ́tã ní ꞌyozú kĩnĩ, “Ãmbúgú mávé rĩ, lẽ mî ꞌbã ẹ́sị́ múké má ní mụzú nyonyo, mâ ã adri dõ ãtíꞌbá mívé ni kuyé drãáãsĩyã, tã mí ní átá múké mâ ẹ́sị́ ũmĩzú ꞌdĩri, sẽ má ní ãyĩkõ.” ");
INSERT INTO kbo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kã caá sâ ínyá nyazú rĩ gé, Bõójã ní ꞌyozú ĩri ní kĩnĩ, “Mí ímụ́ nõgó, ꞌí ꞌdụ pánga rĩ dũú tị́bị́ agá ꞌdãá.” Kúru Rụ́tã ní úrízú ꞌbá ũndú lịꞌbá rĩ pi ã gãrã gá, Bõójã ní ũndú ĩ ní ụsịị́ rĩ sẽzú ĩri ní, Rụ́tã ní ũndú rĩ cizú ẹ́pị́zú, ĩri ní ị̃mbị́tã ni kuzú. ");
INSERT INTO kbo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rụ́tã kã gõó ngaá ũndú rĩ uꞌdụngárá gá ꞌdãá, Bõójã ní átázú ívé ãtíꞌbá ãgõ rú rĩ pi ní kĩnĩ, “Rụ́tã lẽ dõ ũndú rĩ uꞌdụụ́ úlíli ĩ ní úmbé rĩ pi ãsámvú gé sĩ, ã ꞌyokí ĩri ní tã ũnjí ku. ");
INSERT INTO kbo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ĩmi unjekí ũndú rĩ pi úlíli rĩ pi agásĩ úꞌbé vũgá, ã uꞌdụ rí ꞌí ní, ã ꞌyokí ĩri ní tã ũnjí ku.” ");
INSERT INTO kbo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rụ́tã ní ũndú rĩ uꞌdụzú cĩmgbá ũndréŋá gá, co ũndú rĩ ũvú sĩ tré mĩlĩmĩlĩ, ụ̃ꞌbị̃ ũndú rĩ caá kílõ mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ĩri ní ũndú rĩ ꞌdụzú mụzú kụ̃rụ́ agá ꞌdãá, ĩri ní iꞌdazú ꞌî ị̃drẹ́pị ní. Ĩri ní ũndú ĩ ní ụsịị́, ꞌí ní cií tí rĩ vé ị̃mbị́tã jịzú sẽzú ꞌî ị̃drẹ́pị ní. ");
INSERT INTO kbo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ị̃drẹ́pị ní ĩri zịzú kĩnĩ, “Ãndrũ ꞌí mụ ũndú rĩ uꞌdụụ́ íngũgá? ꞌÍ nga ẹ̃zị́ rĩ íngũgá? Tãkíri ã adri ꞌbá mî ĩzã koópi rĩ be.” Kúru Rụ́tã ní ꞌbá ꞌí ní ẹ̃zị́ ngazú vú ni gé rĩ lũzú ꞌî ị̃drẹ́pị ní kĩnĩ, “Ágó má ní ẹ̃zị́ ngaá ĩri vúgá ãndrũ rĩ, rụ́ ni Bõójã ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nõómé ní ꞌyozú ꞌî ũkú ni ní kĩnĩ, “Úpí riípi ẹ́sị́ múké ꞌbãápi ꞌbá ídri rú rĩ pi ní, ãzini ꞌbá ũdrãꞌbá gí rĩ pi ní rĩ, ã ꞌbã tãkíri ágó ꞌdãri drị̃gé. Ágó ꞌdãri ꞌbávé máríté pịrị ni, ĩri ꞌbávé nyọ̃ọ́kụ́ je gõ vúlé nĩ.” ");
INSERT INTO kbo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rụ́tã Mõábãzị́ rĩ ní ꞌyozú kĩnĩ, “Ágó rĩ ꞌyo má ní kĩnĩ, mâ áwí adrií ꞌbá ũndú lịꞌbá rĩ pi be trụ́ cĩmgbá sâ kộpi ní ĩvé ãnyãngã ĩkũnãzú dẹzú céré rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nõómé ní ꞌyozú Rụ́tã ní kĩnĩ, “Mâ mvá rĩ, ĩri múké, ꞌí mụ ũndú rĩ uꞌdụụ́ ĩrivé ãtíꞌbá ũkú rú riꞌbá ãnyãngã ĩkũnãꞌbá rĩ pi ã vụ́drị̃ gé sĩ, ãꞌdiãtãsĩyã ꞌbá ãzi vé ọ́mvụ́ agá, ã ꞌokí rí mi ũnjí ku.” ");
INSERT INTO kbo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kúru Rụ́tã ní rizú ũndú rĩ ã vụ́drị̃ uꞌdụzú ãtíꞌbá ũkú rú riꞌbá ẹ̃zị́ ngaꞌbée Bõójã ní rĩ pi ã vụ́drị̃ gé sĩ, cĩmgbá kộpi ní ãnyãngã rĩ ĩkũnãzú dẹzú rĩ gé. Rụ́tã pi rikí adrií ị̃drẹ́pị be trụ́. ");
INSERT INTO kbo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ụ́ꞌdụ́ ãlu, Rụ́tã ị̃drẹ́pị Nõómé ní ꞌyozú Rụ́tã ní kĩnĩ, “Mâ mvá rĩ, lẽ mâ ndã mí ní ꞌbẹ̃tị́ mi rụụ́pi múké ni. ");
INSERT INTO kbo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Bõójã mí ní ũndú rĩ uꞌdụụ́ ĩrivé ãtíꞌbá ũkú rú ẹ̃zị́ ngaꞌbée rĩ pi ã vụ́drị̃ gé sĩ rĩ, ĩri ꞌbávé máríté. Ãndrũ ị́nị́ŋá sĩ, Bõójã ri mụ ũndú ndrị vũrã ĩ ní rizú ũndú cozú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Mí ũjĩ mi, ꞌí trị mi ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni sĩ, ꞌí su bõngó múké ni. ꞌÍ ꞌde mụụ́ vũrã ĩ ní ũndú cozú rĩ gé ꞌdãá, ꞌbo mî sẽ ã nị̃ ámá ꞌyozú kínĩ mi ꞌdãáꞌdã ꞌdíni ku, ꞌí tẽ, ã nya ívé ínyá, ãzini ã mvụ ívé ngá dẹẹ́. ");
INSERT INTO kbo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Bõójã la dõ vũgá gí, ꞌí ndre vũrã ĩri ní lazú rĩ, ꞌí mụ bẹ̃lẹ̃ngị́tị̃ rĩ ọ́wụ́ pá ni gé sĩ, ꞌí la vũgá. Ĩri tã ꞌí ní lẽé mî ꞌdụ ngaá rĩ lũ mí ní rá.” ");
INSERT INTO kbo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rụ́tã ní újázú ĩri ní kĩnĩ, “Tã mí ní ꞌyoó ꞌdĩri, ma ꞌdụ nga rá.” ");
INSERT INTO kbo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Rụ́tã ní ꞌdezú mụzú vũrã ĩ ní rizú ũndú cozú rĩ gé ꞌdãá, sụ̃ ị̃drẹ́pị ní lũú ꞌí ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bõójã kã ínyá rĩ nyaá, ãzini kã ívé ngá mvụụ́ dẹẹ́, gõ adrií ãyĩkõ sĩ, ĩri ní mụzú lazú vũgá, la ũndú ĩ ní drõó rĩ ã gãrã gá. Rụ́tã ní ꞌi njezú mụzú, ĩri ní bẹ̃lẹ̃ngị́tị̃ pá ni gé rĩ ọ́wụ́zú, ĩri ní lazú pápálésĩla. ");
INSERT INTO kbo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kã caá ị́nị́ ágágá, Bõójã ní aruzú ãyãngárá be, kã ꞌi újá, ị́sụ́ ũkú la kú ꞌî pápálé gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bõójã ní zịzú kĩnĩ, “Mi ãꞌdi ꞌi?” Ũkú rĩ ní ꞌyozú kĩnĩ, “ꞌBá rĩ ma ꞌi mívé ãtíꞌbá Rụ́tã ꞌi. Mí ísé mívé bẹ̃lẹ̃ngị́tị̃ ẽ tị mâ drị̃ ọ̃zụ̃zú ãní, ãꞌdiãtãsĩyã mi mávé máríté, mi ꞌbávé máríté pịrị ni, mi ꞌbávé nyọ̃ọ́kụ́ je gõ vúlé nĩ.” ");
INSERT INTO kbo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bõójã ní újázú kĩnĩ, “Mâ mvá rĩ, Úpí ã ꞌbã tãkíri mí drị̃gé. Ẹ́sị́ múké mí ní ꞌbãá má ní ꞌdĩri, ndẽ mí ní ꞌbãá mí ị̃drẹ́pị ní rĩ rá. ꞌÍ ꞌbã mị anji ãgõ adriꞌbá ãꞌbú be, dõku ãꞌbú ãkó rĩ pi drị̃gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Mâ mvá rĩ, ꞌí ꞌo ụ̃rị̃ sĩ ku. Ngá mí ní zịị́ má tị gé rĩ, má sẽ mí ní rá. ꞌBá kụ̃rụ́ agá rĩ pi ãrẽvú céré nị̃kí ámá rá ꞌyozú kínĩ, mi ũkú adriípi tã be múké ni. ");
INSERT INTO kbo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ádarú ma kõdô ícó nyọ̃ọ́kụ́ rĩ je gõ vúlé nĩ, ꞌbo máríté ãzi pịrị pịrị nyọ̃ọ́kụ́ rĩ jeépi ni anigé. ");
INSERT INTO kbo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Lẽ mî adri nõgó ị́nị́ŋá nõri sĩ, ãngũ rĩ kãdõ ọ́wụ́, máríté rĩ ãꞌyĩ dõ nyọ̃ọ́kụ́ rĩ jeé gõó vúlé rá, ĩri múké, ã je gõó ĩyí. ꞌBo gã dõ jegá sĩ, ádarú Úpí ẹndrẹtị gé, ma tã rĩ ꞌdụ nga rá. ꞌÍ la nõgó cĩmgbá cazú ụ̃ꞌbụ́tịŋá gá.” ");
INSERT INTO kbo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kúru Rụ́tã ní áwízú lazú ágó rĩ ã pápálé gá ꞌdĩgé, cĩmgbá ụ̃ꞌbụ́tịŋá gá, ꞌbo íngá ị́nọ́gọ́sị́, sâ ꞌdãri ꞌbá ãzi ícó ọ́gụ́pị ri nị̃ị́ ámá ku. Kúru Bõójã ní ꞌyozú kĩnĩ, “Lẽ ꞌbá ãzi ã nị̃ ámá ꞌyozú kínĩ, mi vũrã ũndú cozú rĩ gé nõgónõ ꞌdíni ku.” ");
INSERT INTO kbo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bõójã ní kpá ꞌyozú kĩnĩ, “Mí íjị́ mívé bõngó mí ní ꞌbeé mî rụ́ꞌbá gá ꞌdĩri, mí aja vũgá ꞌdĩgé.” Bõójã ní ũndú rĩ yĩzú ngá ã ꞌa ázíyá, ụ̃ꞌbị̃ caá kílõ pụ̃kụ́ na, ĩri ní dãzú bõngó rĩ agá ꞌdãá, ĩri ní ꞌdụzú ꞌbãzú Rụ́tã drị̃gé. Kúru Bõójã ní ꞌi újázú gõzú vúlé kụ̃rụ́ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rụ́tã kã caá ꞌî ị̃drẹ́pị Nõómé vúgá ꞌdãá, ị̃drẹ́pị ní ꞌyozú ĩri ní kĩnĩ, “Mâ mvá rĩ, tã rĩ ꞌo ꞌi íngóni?” Kúru Rụ́tã ní tã Bõójã ní ꞌoó ꞌí ní rĩ ũlũzú céré ꞌî ị̃drẹ́pị ní. ");
INSERT INTO kbo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ĩri ní gõzú ꞌyozú kĩnĩ, “Sẽ má ní ũndú ngá ã ꞌa ázíyá, ãꞌdiãtãsĩyã kĩnĩ, má ícó ĩgõó mâ ị̃drẹ́pị vúgá nõlé drị́ be ule ku.” ");
INSERT INTO kbo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kúru Nõómé ní ꞌyozú kĩnĩ, “Mâ mvá rĩ, lẽ mî ũtẽ tã ímụ́pi ꞌi ngaápi rĩ ẹ́sị́ be mãdã. Tã ꞌdĩri sẽ ágó rĩ ã úmĩ tu pá ãndrũ ku, cĩmgbá ĩri ní tã ꞌdĩri útúngárá gá.” ");
INSERT INTO kbo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bõójã mụ úrí kuú kụ̃rụ́ rĩ vé kẹ̃ẹ́tịlé gá ꞌdãá. Máríté Bõójã ní tã ni ꞌyoó ĩri nyọ̃ọ́kụ́ rĩ je nĩ rĩ kã ícá, Bõójã ní ĩri zịzú kĩnĩ, “Ũndĩgó, mí ímụ́ má vúgá nõó, mí ímụ́ úrí vũgá.” Kúru máríté rĩ ní mụzú úrízú vũgá. ");
INSERT INTO kbo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bõójã ní ꞌbá ambugu rĩ pi ũpẽzú mụdrị́, ĩri ní ꞌyozú kĩnĩ, “Lẽ ĩmi úríkí ꞌdĩgé.” Kúru kộpi ní úrízú vũgá. ");
INSERT INTO kbo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kúru ĩri ní ꞌyozú máríté rĩ ní kĩnĩ, “Nõómé ímụ́pi ãngũ Mõábã vé rĩ gélésĩ rĩ, lẽ ꞌbá ẹ́drị́pị Ẽlĩmẽlékẽ vé nyọ̃ọ́kụ́ ụrụkọ ụzịị́ rá. ");
INSERT INTO kbo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Má ụ̃sụ̃, á lẽ tã ni íjị́ ũlũú mí ní, mî je rí nyọ̃ọ́kụ́ rĩ, ꞌbá úríꞌbá nõꞌbée ã nị̃kí rí ĩndĩ, ãzini mávé ꞌbá ambugu rĩ pi ã nị̃kí rí tã ni ĩndĩ. Mi dõ je rá, ꞌí je. ꞌBo ꞌi je dõ ku, ꞌí lũ má ní, mâ nị̃ rí ꞌyozú kínĩ, ꞌí je ku. Ãꞌdiãtãsĩyã nyọ̃ọ́kụ́ rĩ ícókí sẽé jeé ꞌbá túngú ni ní ku, mi je nĩ, ãzini ma je nĩ.” Máríté rĩ ní ꞌyozú kĩnĩ, “Ma je rá.” ");
INSERT INTO kbo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kúru Bõójã ní ꞌyozú kĩnĩ, “Ụ́ꞌdụ́ mí ní nyọ̃ọ́kụ́ rĩ jezú Nõómé vúgá rĩ gé, mi kpá Rụ́tã ọ̃wụ́zị́gọ́ ágó ni drãápi gí ꞌdĩri ẹ́ꞌyị́ mí ní ũkú rú, nyọ̃ọ́kụ́ ꞌdĩri ã adri rí ãvũ rĩ vé ni, ãzini ĩrivé úyú rĩ pi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Kúru máríté rĩ ní ꞌyozú kĩnĩ, “Má ícó nyọ̃ọ́kụ́ rĩ jeé ku, ãꞌdiãtãsĩyã nyọ̃ọ́kụ́ má ní jeé ꞌdĩri, ĩ ímụ́ ꞌdụ má drị́gé sĩ rá. Lẽ mî je nyọ̃ọ́kụ́ rĩ nĩ, á je ku.” ");
INSERT INTO kbo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ọ́tụ́ mẽrẽ Ĩsẽrélẽ rĩ pi vé rĩ gé, kộpi kádõ ngá ufuú, ꞌbá ãzi ri ívé mọ̃rọ̃kụ́ nje sẽ ꞌí ọ́gụ́pị ní. ꞌDĩri lũ ꞌyozú kínĩ, tã rĩ útúkí gí. ");
INSERT INTO kbo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kúru máríté rĩ ní ꞌyozú Bõójã ní kĩnĩ, “ꞌÍ je nyọ̃ọ́kụ́ rĩ ĩyí.” Ĩri ní ívé mọ̃rọ̃kụ́ njezú ꞌí pá gá sĩ. ");
INSERT INTO kbo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kúru Bõójã ní ꞌyozú ꞌbá ambugu rĩ pi ní, ãzini ꞌbá rĩ pi ní céré kĩnĩ, “Ãndrũ sĩ, ĩmi ndrekí tã rĩ ĩmî mị sĩ gí, á je ngá Ẽlĩmẽlékẽ vé rĩ, Kĩlĩyónã vé rĩ, ãzini Mãlónã vé rĩ Nõómé vúgá gí. ");
INSERT INTO kbo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Má ẹ́ꞌyị́ kpá Mãlónã vé ọ̃wụ́zị́ Rụ́tã Mõábãzị́ rĩ má ní ũkú rú gí, ãvũ rĩ vé rụ́ ã adri rí ũgõgõ, ãzini mâ mba rí ngá ĩrivé rĩ ã tã. Ĩrivé rụ́ ã ãvĩ rí ꞌbá ĩrivé rĩ pi ãsámvú gé sĩ ku, ãzini ĩrivé kụ̃rụ́ agásĩ ku, ãndrũ sĩ, ĩmi ndrekí tã rĩ ĩmî mị sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Kúru ꞌbá ambugu rĩ pi ꞌbá adriꞌbá kẹ̃ẹ́tịlé gá rĩ pi be, kộpi ní ꞌyozú kínĩ, “ꞌBá ndrekí tã ꞌdĩri ꞌbâ mị sĩ gí. Úpí ã sẽ ũkú riípi ímụ́pi mí vúgá ꞌdĩri ní anjiŋá sụ̃ ĩri ní sẽé Rãélẽ pi ní Léyã be rĩ tị́nị, ũkú ꞌdĩꞌbée tịkí úyú Ĩsẽrélẽ vé rĩ pi nĩ. Lẽ mî adri ãꞌbú be kụ̃rụ́ Ẽfãrátã vé rĩ agá ꞌdĩgé, mî rụ́ ã kụkụ Bẽtẽlémẽ gá ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Lẽ Úpí ã sẽ ĩmi ní anjiŋá ũkú mváŋá rú ꞌdĩri be, ꞌbẹ̃tị́ mívé rĩ ãsámvú gé, lẽ ĩmi tịkí anjiŋá sụ̃ Pẽrézĩ vé rĩ tị́nị, Yụ́dã pi Tãmárã be, kộpi tịkí Pẽrézĩ rĩ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kúru Bõójã ní Rụ́tã ri ẹ́ꞌyị́zú ꞌí ní ũkú rú. Bõójã pi ní adrizú Rụ́tã be, Úpí sẽ Rụ́tã ị́sụ́ ꞌa, ĩri ní mvá ágóŋá tịzú. ");
INSERT INTO kbo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ũkú rĩ pi ní ꞌyozú Nõómé ní kínĩ, “Ẽ íngúkí Úpí ri, ãndrũ sĩ, Úpí sẽ mí ní mvá ágóŋá ímụ́pi mívé ngá ẽ tị rụụ́pi ni gí, ĩrivé rụ́ ã kụ ãngũ Ĩsẽrélẽ vé rĩ agá mụzú nyonyo. ");
INSERT INTO kbo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ĩri sẽ mi adri ãyĩkõ sĩ, mí kãdõ ícá ãrãkã rú, ĩri mî tã mba nĩ. Ãꞌdiãtãsĩyã mî ũkú ni mi lẽépi lẽlẽ rĩ, tị ĩri nĩ. Ĩrivé tã ꞌoó múké rĩ, ndẽ anji ẹ́zị̂rị̃ pi vé rĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nõómé ní mváŋá rĩ ꞌdụzú rụzú ꞌí drị́gé, ĩri ní mváŋá rĩ ã tã mbazú. ");
INSERT INTO kbo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ũkú adriꞌbá ꞌdãgá rĩ pi kínĩ, “Nõómé ri mvá be.” Kộpi ní mváŋá rĩ ã rụ́ ꞌdazú Õbédẽ ꞌi. Õbédẽ ní Yésẽ rĩ tịzú, Yésẽ ní Dãwụ́dị̃ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Úyú Pẽrézĩ vé rĩ pi ꞌdĩ: Pẽrézĩ tị Ẽzĩrónã ri, ");
INSERT INTO kbo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ẽzĩrónã tị Rámã ri, Rámã tị Ãmĩnãdábã ri, ");
INSERT INTO kbo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Ãmĩnãdábã tị Nãsónã ri, Nãsónã tị Sãlĩmónĩ ri, ");
INSERT INTO kbo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Sãlĩmónĩ tị Bõójã ri, Bõójã tị Õbédẽ ri, ");
INSERT INTO kbo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Õbédẽ tị Yésẽ ri, Yésẽ ní Dãwụ́dị̃ rĩ tịzú.");
INSERT INTO kbo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ụ́ꞌdụ́ ãlu, Úpí Múngú átá Yónã Ãmĩtáyĩ mvọ́pị be kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“ꞌÍ nga mụụ́ kụ̃rụ́ ãmbúgú Nĩnéwẽ vé rĩ gé ꞌdãá, ꞌí ꞌyo ꞌbá rĩ pi ní, á ndre tã ũnjí kộpi ní ꞌoó rĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","ꞌBo Yónã gã tã Úpí Múngú ní ẹzịị́ ꞌí ní rĩ sĩ, nga ápá mụzú Tãrãsísã gá. ꞌDe mụzú kị̃jị́ Yópã vé rĩ gé ꞌdãá, ĩri ní kũlúmgba lẽépi mụụ́pi Tãrãsísã gá ni ị́sụ́zú, ĩri ní ẹ̃cị̃ rĩ vé mũfẽngã ũfẽzú, ĩri ní fizú úrízú kũlúmgba rĩ agá, ĩri ní mụzú Tãrãsísã gá ꞌdãá, nga ápá Úpí Múngú ẹndrẹtị gé ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Kúru Úpí Múngú ní ũlí ĩpẽzú vịzú ũkpõ be yị̃ị́ tafu rĩ agá ꞌdãá, ũlí rĩ lẽ kõdô kũlúmgba rĩ vịị́ ũŋõó kpélékpélé. ");
INSERT INTO kbo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","ꞌBá riꞌbá kũlúmgba rĩ újị́ꞌbá rĩ pi céré ꞌokí ụ̃rị̃ sĩ, ꞌbá ãlu ãlu ꞌde rií ngoó ívé Múngú ẹndrẹtị gé. Kộpi ní ngá ẹ̃njị̃ꞌbá ẹ̃njị̃ẹ̃njị̃ kũlúmgba agá ꞌdãá rĩ pi uꞌdụzú úꞌbézú yị̃ị́ agá ꞌdãá, kũlúmgba rĩ ẽ ẹ̃njị̃ rí ãní ku. ꞌBo Yónã fi laá ụ́ꞌdụ́ koó kpílíkpílí kũlúmgba rĩ vé ꞌa ĩ ní ẹlịị́ vũgálésĩla rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","ꞌBá kũlúmgba rĩ újị́ꞌbá rĩ pi vé ãmbúgú ní ꞌdezú mụzú ĩri vúgá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mi ri ụ́ꞌdụ́ ko áyu ãsĩ? Mí íngá ụrụ, ꞌí zị mívé Múngú! Sâ ãzi sĩ ĩri ícó ꞌbâ ĩzã ko rá, ꞌbá ícókí ũdrãá ku.” ");
INSERT INTO kbo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","ꞌBá kũlúmgba rĩ újị́ꞌbá rĩ pi ní átázú ĩ ãsámvú gé sĩ kínĩ, “Ĩmi ímụ́kí ꞌbá ꞌbekí jẽké, ꞌbâ nị̃kí rí ꞌbá tã nõri íjị́pi ꞌbá drị̃gé rĩ ámá ãní.” Kộpi ní jẽké rĩ ꞌbezú, jẽké rĩ ꞌde Yónã ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Kúru kộpi ní Yónã ri zịzú kínĩ, “ꞌÍ lũ ꞌbá ní, ꞌbá tã ũnjí nõri íjị́pi ꞌbá drị̃gé rĩ ãꞌdi ꞌi? ꞌÍ ꞌo ãꞌdi? Mí íbí ímụ́ íngõósĩla? Ãngũ mívé rĩ ã rụ́ ãꞌdi? ꞌBá mívé rĩ ãꞌdi pi?” ");
INSERT INTO kbo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yónã ní újázú kĩnĩ, “Ma Ẽbérẽgú, ma ri Úpí Múngú adriípi ꞌbụ̃ gé, nyọ̃ọ́kụ́ rĩ gbiípi yị̃ị́ tafu rĩ be rĩ ị̃njị̃.” ");
INSERT INTO kbo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Tã Yónã ní ꞌyoó ꞌdĩri sẽ kộpi ní ụ̃rị̃, kộpi ní ĩri zịzú kínĩ, “ꞌÍ ꞌo ãꞌdi?” (Kộpi nị̃kí ámá rá ꞌyozú kínĩ, Yónã ápá Úpí Múngú ẹndrẹtị gé sĩ ápápã, ãꞌdiãtãsĩyã Yónã lũ kộpi ní drị̃drị̃ rá.) ");
INSERT INTO kbo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ũlí rĩ kã yị̃ị́ rĩ vịị́, yị̃ị́ rĩ úvá ngũyá ngũyá. Kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌBâ ꞌokí mi íngóni ũlí vịị́pi ũkpõ be ambamba ꞌdĩri ã tu rí pá ãní?” ");
INSERT INTO kbo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yónã ní újázú kộpi ní kĩnĩ, “Ĩmi ꞌdụkí ma ꞌbeé yị̃ị́ tafu rĩ agá ꞌdãá, ũlí vịị́pi ũkpõ be ꞌdĩri, ĩri ícó pá tu rá. Á nị̃ rá á ꞌo ũnjĩkãnyã rĩ ma ꞌi, ũlí rĩ ní vịzú ũkpõ be ꞌdíni ãní.” ");
INSERT INTO kbo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","ꞌBá kũlúmgba rĩ újị́ꞌbá rĩ pi ụ̃ꞌbị̃kí kõdô ũkpõ sĩ kũlúmgba rĩ sõó gõó vúlé ãngũ nyọ̃ọ́kụ́ rú rĩ gé ꞌdãá, ꞌbo kộpi ícókí ku, ãꞌdiãtãsĩyã ũlí rĩ gõ vịị́ drị̃drị̃ ꞌdãri ndẽé rá. ");
INSERT INTO kbo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Kúru kộpi ní ngozú Úpí Múngú ẹndrẹtị gé, “Á Úpí Múngú, ꞌbá ní lẽé ágó nõri vé ídri ꞌbeé ãvĩí rĩ sĩ, mî ku ꞌbâ ũdrãá ku. ꞌBá ní lẽé ágó tã ãkó nõri ꞌdịị́ drãá rĩ sĩ, lẽ mî lị tã ãní ꞌbá drị̃gé ũnjí ku. Á Úpí Múngú, tã rĩ nga ꞌi sụ̃ mí ní lẽé ã nga ꞌi rĩ tị́nị gí.” ");
INSERT INTO kbo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Kúru kộpi ní Yónã ri ꞌdụzú ꞌbezú yị̃ị́ tafu rĩ agá ꞌdãá, koro yị̃ị́ riípi úvápi ngũyá ngũyá rĩ ní pá tuzú. ");
INSERT INTO kbo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Tã ꞌdĩri sẽ ꞌbá kũlúmgba rĩ újị́ꞌbá rĩ pi rukí Úpí Múngú ri ãní rá, kộpi íꞌdụ́kí rọ̃bọ̃ŋọ̃ zãá Úpí Múngú ní, ãzini kộpi sõkí ũyõ ẹ̃zị́ ngazú ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","ꞌBo Úpí Múngú sẽ ị̃ꞌbị́ ãmbúgú te Yónã ri, Yónã adri caá ị̃ꞌbị́ rĩ agá ꞌdãá ụ̃tụ́ŋá na ị́nị́ŋá na. ");
INSERT INTO kbo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yónã ri ívé Úpí Múngú ri zịị́ ị̃ꞌbị́ agá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ĩri ní ꞌyozú kĩnĩ, “Ĩzãngã má ní ị́sụ́ rĩ agá, Úpí Múngú, á zị mi, ꞌí yị ma rá. ꞌBụ́ ãngũ sị̃zú rĩ agá ꞌdãá, á zị mi mâ ĩzã koó, ꞌí yị ma rá. ");
INSERT INTO kbo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","ꞌÍ ꞌbe ma tĩí yị̃ị́ tafu rĩ ã ndụ́gé ꞌdãá, á tĩ yị̃ị́ tafu kụụ́pi kụkụ rĩ ã ndụ́gé ꞌdãá, yị̃ị́ rĩ ĩmũlũ ma rá. Ũlí mí ní sẽé vịị́ ũkpõ be ꞌdĩri, sẽ yị̃ị́ rĩ ĩmũlũ ma céré. ");
INSERT INTO kbo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Má ụ̃sụ̃ déna, mí adi ma gí, má ícó gõó mívé jó ãmbúgú uletere rĩ ndreé dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Á tĩ yị̃ị́ kụụ́pi kụkụ rĩ ã ndụ́gé ꞌdãá, yị̃ị́ rĩ ĩmũlũ ma céré, ásé dụụ́pi yị̃ị́ agá ꞌdãá rĩ ĩmũlũ mâ drị̃ céré. ");
INSERT INTO kbo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Á ꞌde tĩí írã ã ndụ́gé ꞌdãá, nyọ̃ọ́kụ́ rĩ ọ̃zụ̃ mâ drị̃ céré, ꞌbo mávé Úpí Múngú, mí ídrí ma ꞌbụ́ agá ꞌdãásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Úpí Múngú, má kã ámá mávé ídrí lẽ fũúfũ, á zị mi, mávé zịngárá ca mívé jó ãmbúgú uletere rĩ agá ꞌdãá, ꞌí yị ma rá. ");
INSERT INTO kbo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","ꞌBá riꞌbá ngá ĩ ní údé drị́ sĩ rĩ ị̃njị̃ꞌbá múngú rú rĩ pi, kộpi gãkí ẹ́sị́ múké Múngú vé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","ꞌBo ma mí ní úngó õwõꞌdĩfô sẽzú ni ngo, ma mí ní rọ̃bọ̃ŋọ̃ zã. Ũyõ má ní sõó rĩ, ma tã ni ꞌdụ nga rá. Úpí Múngú ri ꞌbâ pa tã ũnjí agásĩ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Úpí Múngú ní ꞌyozú kĩnĩ, ị̃ꞌbị́ rĩ ẽ íwé Yónã ri ãmvé, ị̃ꞌbị́ rĩ ní Yónã rĩ íwézú nyọ̃ọ́kụ́ ãꞌwí rú rĩ drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Kúru Úpí Múngú ní gõzú átázú Yónã ní dị̃ị́ kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“ꞌÍ ꞌde mụụ́ kụ̃rụ́ ãmbúgú Nĩnéwẽ vé rĩ agá ꞌdãá, mí ũlũ ụ́ꞌdụ́kọ́ má ní ũlũú mí ní rĩ ꞌbá rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yónã mụ Nĩnéwẽ gá ꞌdãá rá, sụ̃ Úpí Múngú ní ẹzịị́ ĩri ní rĩ tị́nị. Nĩnéwẽ ri kụ̃rụ́ ãmbúgú, ꞌbá rĩ ícó ẹ́cị́ ꞌa ni gé sĩ ca ụ́ꞌdụ́ na. ");
INSERT INTO kbo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ụ́ꞌdụ́ Yónã ní fizú cazú kụ̃rụ́ rĩ agá ꞌdãá rĩ gé, ĩri ní áyúzú ꞌbá rĩ pi ní kĩnĩ, “Ẹ̃sị̃ ụ́ꞌdụ́ pụ̃kụ́ sụ, ĩ ímụ́ Nĩnéwẽ rĩ iza ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","ꞌBá Nĩnéwẽ vé rĩ pi ẹ̃ꞌyị̃kí Múngú ri ãní rá. Kúru kộpi ní áyúzú kínĩ, lẽ ꞌbá rĩ pi ãrẽvú céré ã aꞌbikí ĩ aꞌbiaꞌbi, ã nyakí ngá ku, íꞌdózú ꞌbá ambugu rĩ pi vúgá, cazú anji nyíríŋá rĩ pi vúgá, lẽ kộpi ã úsúkí bõngó ị́rị́kọ́ rú ni áyu. ");
INSERT INTO kbo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ụ́ꞌdụ́kọ́ ꞌdĩri kã caá ꞌbãgú Nĩnéwẽ vé rĩ vúgá ꞌdãá, íngá ívé lúpá mãlũngã vé rĩ drị̃gé sĩ ụrụ, unje ívé bõngó ãmbũgũ vé rĩ ꞌî rụ́ꞌbá gá sĩ rá, íꞌdụ́ bõngó ị́rị́kọ́ rú ni suú ꞌî rụ́ꞌbá gá áyu, ĩri ní gõzú úrízú vũgá fụ́rụ́ndị́ agá. ");
INSERT INTO kbo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","ꞌBãgú rĩ ívé ũgalaku rĩ pi be, kộpi ní áyúzú ꞌbá Nĩnéwẽ vé rĩ pi ní kínĩ, “Lẽ ꞌbá rĩ pi, dõku tị́ rĩ pi, dõku kãbĩlõ rĩ pi ã nyakí ngá ku, dõku ã mvụkí yịị́ ku. ");
INSERT INTO kbo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","ꞌBá rĩ pi ãnyãpá rĩ pi be céré, lẽ kộpi ã sukí bõngó ị́rị́kọ́ rú ni áyu. Lẽ ꞌbá ãlu ãlu ã zị Úpí Múngú ri, ã ku ívé tã ꞌí ní rií ꞌoó ũnjí rĩ rá, ãzini ã ku adringárá gbórókó rú rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Sâ ãzi sĩ, Múngú ri ívé yị̃kị̂ újá rá, ẹ́sị́ ni gõ veé ku, ꞌbá ícókí ũdrãá ku.” ");
INSERT INTO kbo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Múngú kã tã kộpi ní ꞌoó rĩ ndreé, ãzini kã ndreé kộpi kukí tã ũnjí ꞌongárá gí, gõ ívé yị̃kị̂ újá rá, ĩrĩŋã kộpi kuyé, sụ̃ ĩri ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","ꞌBo tã ꞌdĩri sẽ Yónã adri ãyĩkõ sĩ kuyé, ẹ́sị́ ni ve rá. ");
INSERT INTO kbo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Kúru ĩri ní Úpí Múngú ri zịzú kĩnĩ, “Á Úpí, á nị̃ ámá rá ꞌyozú kínĩ, mí ícó ꞌbá Nĩnéwẽ vé rĩ pi úꞌdị́ ũdrãá ku, sẽ má ní mávé ãngũ kuzú, má ní ápázú mụzú Tãrãsísã gá ãní. Á nị̃ rá, mî ẹ́sị́ múké, ãzini mî ẹ́sị́ ĩdríkídri, mî ẹ́sị́ ve tã sĩ mbẽlẽŋá ku, mívé lẽngárá aga rá, mi Múngú riípi ꞌbá trũúpi ũnjĩkãnyã agásĩ ni, ãzini mi ri mî yị̃kị̂ újá, mí lẽ ꞌbá ꞌdịị́ ku. ");
INSERT INTO kbo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Úpí Múngú, lẽ mâ drã ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ĩri múké má ní drãzú ꞌdĩísĩ rá, ndẽ má ní adrizú ídri rú rĩ.” ");
INSERT INTO kbo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","ꞌBo Úpí Múngú ní újázú ĩri ní kĩnĩ, “Ngá mî ẹ́sị́ ní vezú rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yónã ní fũzú mụzú kụ̃rụ́ rĩ vé wọ̃ọ́kọ̃ ụ̃tụ́ ní ĩfũngárá gálé rú rĩ gé ꞌdãá. Ĩri ní ápãlá ꞌbezú vũrã ꞌdãri gé, ĩri ní úrízú ápãlá rĩ ã ndụ́gé, tẽ rií ndreé dõ tã íngóni ri ꞌi nga kụ̃rụ́ Nĩnéwẽ vé rĩ agá nĩ. ");
INSERT INTO kbo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Kúru Úpí Múngú ní pẹtị sẽzú ꞌdụzú Yónã ní índrĩ rú, Yónã ã adri rí ãní múké. Pẹtị rĩ ní ĩfũú dụụ́ rĩ sĩ, sẽ Yónã ní ãyĩkõ. ");
INSERT INTO kbo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Kã mụụ́ adrií drụ̃ ꞌdíni, ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, Múngú ní ụ̃ꞌbụ̃ ĩpẽzú ímụ́zú pẹtị rĩ nyazú, pẹtị rĩ gõ ꞌwií rá. ");
INSERT INTO kbo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ụ̃tụ́ rĩ kã ĩfũú, Múngú ní ũlí ãcí ãcí ni ĩpẽzú ụ̃tụ́ ní ĩfũngárá gálésĩla, ụ̃tụ́ rĩ zã Yónã ẽ drị̃, ũkpõ ni dẹ ãní rá, lẽ kõdô drãá ãní drãdrã. Ĩri ní ꞌyozú kĩnĩ, “Má ní adrizú ídri rú, ícó ku, lẽ mâ drã ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","ꞌBo Múngú ní ꞌyozú Yónã ní kĩnĩ, “Ngá sẽépi mî ẹ́sị́ ní vezú pẹtị rĩ vé tã sĩ rĩ ãꞌdi?” Yónã ní ꞌyozú kĩnĩ, “Tã mâ ẹ́sị́ ní vezú rĩ, ĩri tã áda, lẽ mâ drã ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","ꞌBo Úpí Múngú ní ꞌyozú Yónã ní kĩnĩ, “ꞌÍ sa pẹtị rĩ nĩ kuyé, mí údé ndụ̃ụ́ ni nĩ kuyé, á ndre pẹtị rĩ vé tã fi mí ẹ́sị́ agá ambamba. Pẹtị rĩ dụ ị́nị́ŋá rĩ sĩ, gõ drãá ị́nị́ŋá rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Kụ̃rụ́ Nĩnéwẽ vé rĩ agá ꞌdãá, ꞌbá rĩ pi vé kãlãfe aga élĩfũ mụ̃dụ̃rụ̃lụ̃ ãlu pụ̃kụ́ ị̃rị̃ (120,000) rĩ rá, ꞌbá rĩ pi acokí tã múké pi ãsámvú tã ũnjí be ku, ãnyãpá rĩ pi ꞌdãlé kárákará. ꞌÍ lẽ mâ ꞌbã ẹ́sị́ múké ꞌbá ꞌdãꞌbée ní ku?”");
INSERT INTO kbo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ẹ́ꞌbị́pị́ị Yẹ́sụ̃ Kúrísítõ vé rĩ pi ã rụ́ ꞌdĩ, Yẹ́sụ̃ Kúrísítõ ri úyú Dãwụ́dị̃ vé ni, Dãwụ́dị̃ ri úyú Ãbũrámã vé ni. ");
INSERT INTO kbo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ãbũrámã tị Ĩsákã ri, Ĩsákã tị Yõkóbũ ri, Yõkóbũ tị Yụ́dã pi ẹ́drị́pị́ị be, ");
INSERT INTO kbo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yụ́dã tị Pẽrézĩ pi Zérã be, kộpivé ẹ́ndrẹ́pị Tãmárã ꞌi, Pẽrézĩ tị Ẽzĩrónã ri, Ẽzĩrónã tị Rámã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rámã tị Ãmĩnãdábã ri, Ãmĩnãdábã tị Nãsónã ri, Nãsónã tị Sãlĩmónĩ ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sãlĩmónĩ tị Bõójã ri, Bõójã vé ẹ́ndrẹ́pị Rábã ꞌi, Bõójã tị Õbédẽ ri, Õbédẽ vé ẹ́ndrẹ́pị Rụ́tã ꞌi, Õbédẽ tị Yésẽ ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yésẽ tị ꞌbãgú Dãwụ́dị̃ ri, Dãwụ́dị̃ tị Sõlõmónã ri, Sõlõmónã vé ẹ́ndrẹ́pị ĩri ọ́tụ́ ũkú Ụ̃rị́yã vé ni, ");
INSERT INTO kbo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sõlõmónã tị Rõbámã ri, Rõbámã tị Ãbíjã ri, Ãbíjã tị Ásã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ásã tị Yõsĩpátã ri, Yõsĩpátã tị Yõrámã ri, Yõrámã tị Ụ̃zị́yã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ụ̃zị́yã tị Yõtómã ri, Yõtómã tị Ãkázã ri, Ãkázã tị Ĩjĩkíyã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ĩjĩkíyã tị Mãnásẽ ri, Mãnásẽ tị Ãmónã ri, Ãmónã tị Yõsíyã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yõsíyã tị Yékóníyã pi ẹ́drị́pị́ị be lókí kộpi ní ápázú mụzú Bãbẽlónã gá rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kộpi ní ápázú mụzú Bãbẽlónã gá ꞌdãlé rĩ ã vụ́drị̃ gé, Yékóníyã tị Sãlĩtĩyélẽ ri, Sãlĩtĩyélẽ tị Zẽrũbãbélã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zẽrũbãbélã tị Ãbị̃yụ́dã ri, Ãbị̃yụ́dã tị Ẽlĩyãkímã ri, Ẽlĩyãkímã tị Ãzórã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ãzórã tị Zãdókã ri, Zãdókã tị Ãkímũ ri, Ãkímũ tị Ẹ̃lị̃yụ́dã ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ẹ̃lị̃yụ́dã tị Ẽlẽzárã ri, Ẽlẽzárã tị Mãtánã ri, Mãtánã tị Yõkóbũ ri, ");
INSERT INTO kbo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yõkóbũ tị Yõsépã Mãríyã ágó ni ri, Mãríyã ní Yẹ́sụ̃ ĩ ní zịị́ Kúrísítõ ri tịzú. ");
INSERT INTO kbo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Íꞌdózú Ãbũrámã vúgá cazú Dãwụ́dị̃ vúgá, ca úyú mụdrị́ drị̃ ni sụ. Íꞌdózú Dãwụ́dị̃ vúgá cazú ĩ ní ꞌbá rĩ pi urụzú mụzú Bãbẽlónã gá rĩ gé, ca úyú mụdrị́ drị̃ ni sụ. Íꞌdózú ĩ ní ꞌbá rĩ pi urụzú mụzú Bãbẽlónã gá rĩ gé cazú Kúrísítõ vúgá, ca úyú mụdrị́ drị̃ ni sụ. ");
INSERT INTO kbo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yẹ́sụ̃ Kúrísítõ vé tịngárá ĩri ꞌdíni, Yõsépã ãꞌyĩ Mãríyã Yẹ́sụ̃ ẹ́ndrẹ́pị ri jeé ꞌí ní ũkú rú. ꞌBo kộpi ní drĩ ĩ úmúzú trụ́ kuyé rĩ gé, ị́sụ́ Mãríyã ri ꞌa be, ꞌa ꞌdĩri Mãríyã ị́sụ́ Índrí Uletere rĩ vé ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yõsépã ní adrií ꞌbá tã be pịrị rĩ sĩ, lẽ tã ꞌdĩri áyú gúnyá agá drị̃njá sẽzú Mãríyã ní ku, ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãlé, ꞌí lẽ Mãríyã ri gãá, ꞌbá ãzi ã nị̃ ku. ");
INSERT INTO kbo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yõsépã kã tã ꞌdĩri ụ̃sụ̃ụ́ ꞌdíni, Úpí vé mãlãyíkã ní ꞌi iꞌdazú ĩri ní urobí agá, ꞌyozú ĩri ní kĩnĩ, “Yõsépã Dãwụ́dị̃ ã mvá rĩ, lẽ mî ru ku, ꞌí je Mãríyã ri mí ní ũkú rú, ꞌa ĩri ní ị́sụ́ ꞌdĩri, ị́sụ́ Índrí Uletere rĩ vé ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ĩri ímụ́ mvá rĩ tĩ ágó, mi rụ́ ni ꞌda Yẹ́sụ̃ ꞌi, ãꞌdiãtãsĩyã ĩri ímụ́ ꞌbá rĩ pi pa ĩvé ũnjĩkãnyã agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tã ꞌdĩri ꞌo ꞌi ꞌdíni, átángá Úpí ní átá nẹ́bị̃ tị gé ꞌdãri ã nga rí ꞌi fũú tị ni gé bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Átángá rĩ kĩnĩ, “Ũkú kácáŋá rú ni ímụ́ ꞌa ị́sụ́, ĩri mvá ágó tị, kộpi ímụ́ rụ́ ni ꞌda Ẽmánũẽlẽ ꞌi.” Ífífí ni Múngú ri ꞌbá be trụ́. ");
INSERT INTO kbo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yõsépã kã aruú ụ́ꞌdụ́ gélésĩ, ꞌdụ tã rĩ ngaá sụ̃ Úpí vé mãlãyíkã ní ẹzịị́ ꞌí ní rĩ tị́nị, jị Mãríyã ri mụzú ꞌbẹ̃tị́ ꞌí ní ũkú rú, ");
INSERT INTO kbo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ꞌbo kộpi úmúkí ĩ trụ́ kuyé cĩmgbá Mãríyã ní mváŋá rĩ tĩngárá gá. Mãríyã kã mváŋá rĩ tĩí, Yõsépã ní mváŋá rĩ ã rụ́ ꞌdazú Yẹ́sụ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tịkí Yẹ́sụ̃ ri Bẽtẽlémẽ gá, ãngũ Yụ̃dáyã vé rĩ agá, ị́sụ́ ãkũdẽ Ẽródẽ ri ꞌbãgú rú nĩ. Sâ ꞌdãri gé, ꞌbá úmĩ be ni pi íngákí ụ̃tụ́ ní ĩfũngárá gálésĩla, kộpi ícákí Yẹ̃rụ́sãlémã gá, ãngũ Yụ̃dáyã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kộpi ní zịzú kínĩ, “ꞌBá ĩ ní tịị́ Yãhụ́dị̃ rĩ pi vé ꞌbãgú rú rĩ íngãá? ꞌBá ndrekí ĩrivé línyã dị̃ị́pi rĩ ụ̃tụ́ ní ĩfũngárá gá ꞌdãlé, ꞌbá ímụ́kí ĩri ị̃njị̃ngárá gá.” ");
INSERT INTO kbo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ꞌBãgú Ẽródẽ kã tã ꞌdĩri yịị́, sẽ ĩri ní tã ụ̃sụ̃ngárá ambamba, sẽ kpá ꞌbá Yẹ̃rụ́sãlémã gá rĩ pi ní tã ụ̃sụ̃ngárá ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ꞌBãgú rĩ ní atala atala rĩ pi drị̃gé rĩ pi zịzú ímụ́zú ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be ꞌí vúgá nõlé, ĩri ní kộpi zịzú kĩnĩ, “Ĩ ímụ́ Kúrísítõ ri tị íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kộpi ní újázú kínĩ, “Ĩ ímụ́ ĩri tị Bẽtẽlémẽ gá, ãngũ Yụ̃dáyã vé rĩ agá, ãꞌdiãtãsĩyã tã nẹ́bị̃ rĩ pi ní sĩí rĩ ĩri ꞌdíni, ");
INSERT INTO kbo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Mi kụ̃rụ́ Bẽtẽlémẽ ãngũ Yụ̃dáyã vé rĩ agá rĩ, mi kụ̃rụ́ tã be ãmbúgú ni, ãꞌdiãtãsĩyã ĩ ímụ́ ꞌbá ãngũ rụụ́pi ni tị mí agá, ĩri ímụ́ mávé ꞌbá Ĩsẽrélẽ vé rĩ pi úcé nĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kúru Ẽródẽ ní ꞌbá úmĩ be ꞌdĩꞌbée zịzú gãrã gá, lẽ nị̃ị́ kộpi vúgá línyã rĩ ĩfũ dõ pịrị ni sâ ngõri gé. ");
INSERT INTO kbo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ĩri ní kúru kộpi pẽzú mụzú Bẽtẽlémẽ gá ꞌdãá, ĩri ní ꞌyozú kộpi ní kĩnĩ, ĩmi mụkí mváŋá rĩ ndãá múké múké, ĩmi ị́sụ́kí dõ ĩri gí, koro ĩmi íjị́kí tã ni lũú má ní, mâ mụ rí kpá ĩri ị̃njị̃ị́ bẽsĩnĩ. ");
INSERT INTO kbo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kộpi kâ tã ꞌbãgú rĩ ní ꞌyoó ꞌdĩri yịị́, kộpi ní ꞌdezú mụzú, línyã kộpi ní ndreé ụ̃tụ́ ní ĩfũngárá gá ꞌdãri ri dị̃ị́ mụzú kộpi ẹndrẹtị gé sĩ drị̃drị̃, línyã rĩ mụ pá tuú vũrã mváŋá rĩ ní adrizú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kộpi kâ línyã rĩ ndreé, ãyĩkõ fụ kộpi agaá rá. ");
INSERT INTO kbo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kộpi kâ fií jó agá ꞌdãlé, kộpi ndrekí mváŋá rĩ pi ẹ́ndrẹ́pị Mãríyã be, kộpi ní kũmũcí ũtị̃zú vũgá, ĩri ị̃njị̃zú. Kộpi ní kúru ĩvé sọ̃ndụ́kụ̃ ãꞌbú vé rĩ pi ẽ tị ũzị̃zú, kộpi íꞌdụ́kí dábũ, ngá ĩ ní zãá ngụ̃ụ́pi ndrị̃ndrị̃ ni, ãzini mị́rẹ̃ sẽé mváŋá rĩ ní fẽfẽ rú. ");
INSERT INTO kbo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Múngú ní átázú kộpi ní urobí agá kĩnĩ, kộpi ã újákí ĩ gõó vúlé Ẽródẽ vúgá ꞌdãlé ku, kộpi ní gõzú ꞌdezú mụzú ĩvé ãngũ gé ꞌdãlé lẹ́tị ãzi túngú ni gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ꞌBá úmĩ be ꞌdĩꞌbée kâ ꞌdeé mụụ́ gí, Úpí vé mãlãyíkã ní ímụ́zú átázú Yõsépã ní urobí agá kĩnĩ, “ꞌÍ nga, ꞌí ꞌdụ mváŋá rĩ pi ẹ́ndrẹ́pị be, mí ápá mụzú Ẽjẽpétõ gá. Mí adri ꞌdãlé, cĩmgbá á lũ dõ mí ní ụ́ꞌdụ́ mí ní ĩgõzú rĩ gí ká, ãꞌdiãtãsĩyã Ẽródẽ lẽ lẹ́tị ndãá mváŋá rĩ ꞌdịzú drãzú ꞌdĩísĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yõsépã ní ẹ̃cị̃ íꞌdózú, ĩri ní mváŋá rĩ pi jịzú ẹ́ndrẹ́pị be ị́nị́ŋá sĩ mụzú Ẽjẽpétõ gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yõsépã adri ꞌdãlé cĩmgbá Ẽródẽ drã ĩri ị́sụ́ ꞌdãá. Kúru tã ọ́tụ́ Úpí ní ẹzị nẹ́bị̃ rĩ tị gé rĩ nga ꞌi fũú tị ni gé gí kĩnĩ, “Á zị mávé mvá ĩfũú Ẽjẽpétõ agásĩ ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ẽródẽ kã nị̃ị́ ámá ꞌyozú kínĩ ꞌbá úmĩ be rĩ pi ũꞌbãkí ꞌî mị gí, ẹ́sị́ ni ve ũnjí ũnjí, ĩri ní tãị́mbị́ sẽzú ãngáráwá rĩ pi ní, kộpi ã mụkí anji ãgõ ílí be ị̃rị̃, dõku ílí be caꞌbá ị̃rị̃ kuyé Bẽtẽlémẽ agá rĩ pi úꞌdị́, ãzini anji Bẽtẽlémẽ gãrã gá sĩ rĩ pi úꞌdị́ ũdrãá céré ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ꞌbá úmĩ be rĩ pi ũlũkí ĩri ní kínĩ, ĩ ndrekí línyã rĩ, vụ́drị̃ ni ꞌdụ nóni caá ílí ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tã Múngú ní ẹzịị́ nẹ́bị̃ Yẽrẽmíyã tị gé rĩ nga ꞌi fũú tị ni gé gí kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ụ́ꞌdụ́kọ́ ãá vé ni íbí íkụ́ Rámã gá ꞌdãásĩ, ꞌbá rĩ pi rikí ngoó ĩzãngã ĩzãngã rú, rikí lụ̃ụ́lụ́ gaá ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, Rãélẽ ri ngoó ívé anjiŋá rĩ pi sĩ, lẽ ꞌbá ãzi ã ũmĩ ꞌî ẹ́sị́ ku, ãꞌdiãtãsĩyã ĩ ní anjiŋá rĩ pi úꞌdị́ ũdrãá gí rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ẽródẽ kã drãá, Úpí vé mãlãyíkã ní ímụ́zú átázú Yõsépã ní urobí agá Ẽjẽpétõ gá ꞌdãlé, ");
INSERT INTO kbo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kĩnĩ, “ꞌÍ nga, ꞌí ꞌdụ mváŋá rĩ pi ẹ́ndrẹ́pị be, ꞌí ꞌde mụụ́ ãngũ Ĩsẽrélẽ vé rĩ gé, ãꞌdiãtãsĩyã ꞌbá lẽꞌbá mváŋá rĩ ꞌdịꞌbá rĩ pi ũdrãkí gí.” ");
INSERT INTO kbo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kúru Yõsépã ní mváŋá rĩ pi ꞌdụzú ẹ́ndrẹ́pị be, kộpi ní ĩ újázú gõzú ãngũ Ĩsẽrélẽ vé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yõsépã kã yịị́ kínĩ Ãrãkãláwũ rụ ãngũ Yụ̃dáyã vé rĩ nĩ ẹ́tẹ́pị Ẽródẽ ã vũrã gá, gõ ꞌoó ụ̃rị̃ sĩ mụngárá ꞌdãlé rĩ sĩ. Kúru ĩ ní lũzú Yõsépã ní urobí agá kínĩ, ã ꞌde mụụ́ ãngũ Gãlĩláyã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kộpi ní ꞌdezú mụzú adrizú kụ̃rụ́ Nãzẽrétã vé rĩ agá, tã ọ́tụ́ nẹ́bị̃ rĩ pi ní átá ꞌbá ꞌbâ paápi rĩ ã tã sĩ rĩ nga ꞌi fũú tị ni gé gí kĩnĩ, “Ĩ ímụ́ ĩri zị Nãzẽrétãgú.” ");
INSERT INTO kbo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ílí ꞌdãꞌbée ã vụ́drị̃ gé, Yũwánĩ Bãtízĩmũ sẽépi rĩ ímụ́ rií tị sẽé ãngũ ãꞌwí cínyáfã rú rĩ agá ãngũ Yụ̃dáyã vé rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kĩnĩ, “Ĩmi újákí ẹ́sị́, ãꞌdiãtãsĩyã mãlũngã ꞌbụ̃ vé rĩ ícá ĩnyiŋá gí.” ");
INSERT INTO kbo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ꞌBá nẹ́bị̃ Ĩsáyã ní tã ni átá rĩ, ĩri adriípi ꞌdĩ. “Ụ́ꞌdụ́kọ́ ꞌbá ãzi vé ni ri ọ́ꞌụ́ ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá kĩnĩ, ‘Ĩmi údékí lẹ́tị Úpí ní, ĩmi útúkí lẹ́tị ĩrivé rĩ ã adri pịrị.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bõngó Yũwánĩ ní suú rĩ údékí kámĩlõ ã ꞌbí, gõ ĩri ní ꞌyĩí ꞌí ụ́pị́lẹ́ gá rĩ údékí lãꞌbú. Ĩrivé ãnyãngã ĩri ní rií nyaá rĩ, úmbí, ãzini ọ̃nyụ́ ásé agá ꞌdãá rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ꞌBá kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agá rĩ pi, ãngũ Yụ̃dáyã vé rĩ agá rĩ pi, ãngũ Yárídénĩ vé rĩ agá rĩ pi be céré ꞌdekí mụụ́ Yũwánĩ vúgá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","kộpi ũlũkí ĩvé ũnjĩkãnyã, Yũwánĩ ní kộpi ní bãtízĩmũ sẽzú, ri bãtízĩmũ rĩ sẽé yị̃ị́ ãmbúgú dịị́pi dịdị Yárídénĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yũwánĩ kã ndreé Fãrụ́sị̃ rĩ pi Sãdókẽ rĩ pi be ri ímụ́ kárákará ꞌí vúgá vũrã ꞌí ní rizú bãtízĩmũ sẽzú rĩ gé nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adriꞌbée sụ̃ ị̃nị̃ tị́nị ꞌdĩꞌbée, ãꞌdi ĩmgbẽ ĩmî mị ápázú Múngú vé jĩkó úmvúlésĩ ímụ́pi drị̃drị̃ ꞌdĩlé rĩ gé sĩ nĩ? ");
INSERT INTO kbo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lẽ ĩmi ꞌokí tã lũúpi ꞌyozú kínĩ, ĩmi újákí ẹ́sị́ ũnjĩkãnyã agásĩ gí ni áyu. ");
INSERT INTO kbo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lẽ ĩmi rikí ụ̃sụ̃ụ́ ĩmî ẹ́sị́ agá ꞌdãlé ꞌyozú kínĩ, ‘Ãbũrámã ri ĩmivé ẹ́tẹ́pị ꞌdíni’ ku. Á ꞌyo ĩmi ní, Múngú ri ícó írã nõri újá ízú úyú Ãbũrámã vé ni pi rú rá. ");
INSERT INTO kbo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Múngú íꞌdụ́ ụ̃bọ́lụ́ pẹtị ã úlá ugazú rĩ ꞌí drị́gé gí, pẹtị ꞌaꞌbée ũꞌa be múké ku rĩ pi ãrẽvú céré ĩ uga vũgá, ĩ kộpi ꞌdụ úꞌbé ãcí agá. ");
INSERT INTO kbo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ma ri ĩmi ní bãtízĩmũ sẽ yị̃ị́ sĩ lũzú kínĩ, ĩmi újákí ẹ́sị́ ũnjĩkãnyã agásĩ gí. ꞌBo ꞌbá ãzi ri ímụ́ mâ vụ́drị̃ gé ꞌdĩíꞌdĩ, ĩrivé ãmbũgũ ndẽ mávé rĩ rá, má ícó ĩrivé ngá pá gá ꞌdụụ́ bã ku. Ĩri ímụ́ bãtízĩmũ rĩ sẽ Índrí Uletere rĩ sĩ, ãzini ãcí sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ĩri kọ́bị ngá ụ́ꞌbị́zú ni be drị́gé, ĩri ímụ́ ívé ãnyá ụ́ꞌbị́ ãní. Ãnyá rĩ vé fí, ĩri dã ĩrá agá, ꞌbí ni, ĩri zã ve ãcí sĩ, ãcí ꞌdĩri ícó drãá ku.” ");
INSERT INTO kbo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yẹ́sụ̃ ní íngázú ímụ́zú ãngũ Gãlĩláyã vé rĩ gé ꞌdãásĩ, ĩri ní ímụ́zú Yũwánĩ vúgá Yárídénĩ gé nõlé, lẽ Yũwánĩ ã sẽ ꞌí ní bãtízĩmũ. ");
INSERT INTO kbo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ꞌBo Yũwánĩ lẽ kõdô gãá ĩri ní bãtízĩmũ sẽgá sĩ. Yũwánĩ kĩnĩ, “Mi té ícó má ní bãtízĩmũ sẽ nĩ, ngá mí ní ímụ́zú má vúgá ꞌyozú kínĩ mâ sẽ mí ní bãtízĩmũ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Lẽ tã rĩ ã ꞌdụ ꞌi ngaá sụ̃ má ní ꞌyoó ꞌdĩri tị́nị, ãꞌdiãtãsĩyã Múngú lẽ ꞌbâ ꞌdụkí tã rĩ pi ãrẽvú céré ngaá pịrị sụ̃ ꞌí ní lẽé rĩ tị́nị.” Kúru Yũwánĩ ní ĩri ní bãtízĩmũ rĩ sẽzú. ");
INSERT INTO kbo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yũwánĩ kã Yẹ́sụ̃ ní bãtízĩmũ rĩ sẽé, Yẹ́sụ̃ ní ĩfũzú yị̃ị́ rĩ agásĩ ãmvé. Koro sâ ꞌdãri gé, ꞌbụ̃ rĩ zị̃ ꞌi kú mgbọ, Índrí Múngú vé rĩ ní ísị́zú ímụ́zú sụ̃ ãmámũ tị́nị, úrízú ĩri drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kúru ụ́ꞌdụ́kọ́ ní íkụ́zú ꞌbụ̃ gé ꞌdãásĩ ꞌyozú kĩnĩ, “Mvá ꞌdĩri mávé ni, á lẽ ĩri lẽlẽ, ma ĩri sĩ ãyĩkõ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kúru Índrí Uletere rĩ ní Yẹ́sụ̃ ri jịzú mụzú ásé agá ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ãdróko ní ĩri ụ̃ꞌbị̃zú. ");
INSERT INTO kbo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yẹ́sụ̃ aꞌbi ꞌi caá ụ̃tụ́ŋá pụ̃kụ́ sụ ị́nị́ŋá pụ̃kụ́ sụ, nya ngá ãzi kuyé, ẹ̃bị́rị́ fụ ĩri káyĩ. ");
INSERT INTO kbo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ãdróko ní ímụ́zú ĩri ụ̃ꞌbị̃zú, ꞌyozú ĩri ní kĩnĩ, “Mi dõ Mvá Múngú vé ni, ꞌí ꞌyo írã anji ꞌdĩꞌbée ní, kộpi ã újákí ĩ ufuú pánga rú.” ");
INSERT INTO kbo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Sĩkí Búkũ Múngú vé rĩ agá kínĩ, ‘ꞌBá ícó adrií ídri rú ꞌyéŋá pánga sĩ ọ́ꞌdụ́kụ́lẹ ku, ꞌbá rĩ adri ídri rú ụ́ꞌdụ́kọ́ múké Múngú ní átá ĩfũú ꞌí tị gé sĩ rĩ sĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kúru Ãdróko ní Yẹ́sụ̃ ri jịzú mụzú kụ̃rụ́ uletere Yẹ̃rụ́sãlémã vé rĩ gé ꞌdãá, ĩri ní Yẹ́sụ̃ ri jịzú tụzú Jó Múngú vé rĩ drị̃gé ụrụ ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ĩri ní ꞌyozú kĩnĩ, “Mi dõ Mvá Múngú vé ni, ꞌí wa vũgá ꞌdãá, ãꞌdiãtãsĩyã sĩkí Búkũ Múngú vé rĩ agá kínĩ, “ ‘Múngú ri ívé mãlãyíkã rĩ pi ĩpẽ ímụ́ mî ĩzã ko rá, kộpi mi ko ĩ drị́gé ụrụ ꞌdĩgé, mî sị̃ rí mî pá írã rụ́ꞌbá gá ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Sĩkí kpá Búkũ Múngú vé rĩ agá kínĩ, ‘Lẽ mî ụ̃ꞌbị̃ Úpí Múngú mívé rĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ãdróko rĩ gõ kpá ĩri jịị́ tụụ́ írã ãco ni drị̃gé ụrụgégé ꞌdãá, ĩri ní ãngũ ꞌbãgú rĩ pi ní rụụ́ vũ drị̃gé nõgó rĩ pi iꞌdazú Yẹ́sụ̃ ní céré, ãzini kộpivé ngá ũnyĩ be vũ drị̃gé nõgó rĩ pi iꞌdazú ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ĩri ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Mí ũtị̃ dõ kũmũcí má ẹndrẹtị gé ma ị̃njị̃zú rá, ma ngá vũ drị̃gé rĩ pi ãrẽvú sẽ céré mí ní.” ");
INSERT INTO kbo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Sãtánã, ꞌí dẹ mi má gãrã gá ꞌdĩísĩ rá! Ãꞌdiãtãsĩyã sĩkí Búkũ Múngú vé rĩ agá kínĩ, ‘Lẽ mî ị̃njị̃ ꞌyéŋá Úpí Múngú mívé rĩ áyu, mî nga ĩri ní ẹ̃zị́.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kúru Ãdróko rĩ ní ĩri kuzú, mãlãyíkã rĩ pi ní ímụ́zú ĩri ẽ ĩzã kozú. ");
INSERT INTO kbo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yẹ́sụ̃ kã yịị́ kínĩ ꞌbekí Yũwánĩ ri jó ãngũ ũꞌyĩzú rĩ agá gí, ĩri ní ꞌi újázú gõzú ãngũ Gãlĩláyã vé rĩ gé ꞌdãá ũzi. ");
INSERT INTO kbo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ĩri ní fũzú Nãzẽrétã agásĩ, ꞌdezú mụzú adrizú Kãpãrãnãụ́mã gá, ĩnyiŋá yị̃ị́ bãlãlã rĩ ã gãrã gá, ãngũ Jẽbũlúnã pi vé Nãfãtálĩ be rĩ gé, ");
INSERT INTO kbo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tã nẹ́bị̃ Ĩsáyã ní ọ́tụ́ ꞌyoó rĩ ã nga rí ꞌi fũú tị ni gé bẽnĩ kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ãngũ Jẽbũlúnã vé rĩ, ãngũ Nãfãtálĩ vé rĩ, lẹ́tị mụzú ãní yị̃ị́ bãlãlã rĩ gé rĩ, ãngũ yị̃ị́ ãmbúgú dịị́pi dịdị Yárídénĩ vé rĩ ã gãrã gá rĩ, ꞌbá adriꞌbá Yãhụ́dị̃ rú ku ãngũ Gãlĩláyã vé rĩ agá rĩ pi, ");
INSERT INTO kbo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ãzini ꞌbá adriꞌbá ị́nị́ŋá agá rĩ pi ndrekí ụ̃tụ́ŋá ãngũ ĩmgbẽrẽépi uletere rĩ gí, ꞌbá drã ruꞌbá ruru rĩ pi ndrekí ụ̃tụ́ŋá ãngũ ĩmgbẽrẽépi uletere rĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ꞌÍꞌdózú sâ ꞌdãri gé mụzú drị̃drị̃, Yẹ́sụ̃ íꞌdó rií tị sẽé mụzú kĩnĩ, “Lẽ ĩmi újákí ẹ́sị́, ãꞌdiãtãsĩyã mãlũngã ꞌbụ̃ vé rĩ ícá ĩnyiŋá gí.” ");
INSERT INTO kbo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yẹ́sụ̃ kã rií ẹ́cị́ yị̃ị́ bãlãlã Gãlĩláyã vé rĩ ã gãrã gá sĩ, ndre ꞌbá ị̃rị̃, ꞌbá ꞌdĩꞌbée ị̃rị̃trọ́ ẹ́drị́pị. ꞌBá rĩ Sị̃mọ́nã ĩ ní zịị́ Pétẽró pi ẹ́drị́pị Ãndẽréyã be, kộpi ri ímbá ꞌbe yị̃ị́ bãlãlã rĩ agá, ãꞌdiãtãsĩyã kộpi ꞌbá riꞌbá ị̃ꞌbị́ ꞌbeꞌbá ímbá sĩ ni pi. ");
INSERT INTO kbo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ímụ́kí mâ pámvú ũbĩí, ma sẽ ĩmi ímụ́ ꞌbá ísé íjị́ má ní sụ̃ ĩmi ní ị̃ꞌbị́ ꞌbeé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Koro kộpi ní ĩvé ímbá rĩ pi kuzú, kộpi ní ꞌdezú mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yẹ́sụ̃ kã ꞌi útrú mụzú drị̃drị̃, ndre ꞌbá ụrụkọ ị̃rị̃, kộpi ị̃rị̃trọ́ ẹ́drị́pị, ꞌbá rĩ Yõkóbũ pi Yũwánĩ be, kộpi anji Zẽbẽdáyõ vé ni. Kộpi úríkí kuú kũlúmgba agá ꞌdãá ĩ ẹ́tẹ́pị Zẽbẽdáyõ be trụ́, kộpi ri ĩvé ímbá aꞌdi. Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi ímụ́kí má vúgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Koro kộpi ní kũlúmgba rĩ kuzú, ĩ ẹ́tẹ́pị ri kuzú, kộpi ní ꞌdezú mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yẹ́sụ̃ ri ẹ́cị́ mụzú ãngũ Gãlĩláyã vé rĩ agásĩ, ri ꞌbá rĩ pi ímbá kộpivé Jó Múngú ri Zịzú rĩ pi agásĩ, ri ụ́ꞌdụ́kọ́ múké mãlũngã vé rĩ ũlũú mụzú, ãzini ri ꞌbá drã be ãndíãndí rĩ pi ídrí mụzú ꞌbá rĩ pi ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yẹ́sụ̃ vé tã ã kụ́bị́ kụ mụzú ãngũ Sírĩyã vé rĩ agásĩ céré. ꞌBá rĩ pi ní ꞌbá drã be ũnjí ũnjí rĩ pi íjị́zú ímụ́zú ĩri vúgá nõlé, ꞌbá riꞌbá drị̃ cịꞌbá drã ũkpó ũkpó ni sĩ rĩ pi, ꞌbá índrí ũnjí ní fií kộpi drị̃gé rĩ pi, ꞌbá drã ní nyií kuú ꞌbẽléꞌbéle rĩ pi be, Yẹ́sụ̃ ídrí kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ꞌBá kárákará íngáꞌbá ãngũ Gãlĩláyã vé rĩ agá rĩ pi, kụ̃rụ́ Dẽkãpólĩsĩ vé rĩ agá rĩ pi, Yẹ̃rụ́sãlémã agá rĩ pi, ãngũ Yụ̃dáyã vé rĩ agá rĩ pi, ãzini ãngũ Yárídénĩ vé álésĩ rĩ agá rĩ pi ãrẽvú céré ꞌdekí mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yẹ́sụ̃ kã ꞌbá bị́trị́ká rĩ pi ndreé, ĩri ní ꞌdezú mụzú írã drị̃gé ꞌdãlé, ĩri ní úrízú vũgá. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú ĩri vúgá nõlé. ");
INSERT INTO kbo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ĩri ní íꞌdózú kộpi ímbázú, ĩri ní ꞌyozú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ꞌBá ẹ́sị́ ꞌbãꞌbée Múngú drị̃gé rĩ pi, Múngú ri kộpi ní tãkíri sẽ rá, ãꞌdiãtãsĩyã kộpi fi mãlũngã ꞌbụ̃ vé rĩ agá rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ꞌBá riꞌbá ngoꞌbá ĩzãngã ĩzãngã rú rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã ĩ ímụ́ kộpi ẽ ẹ́sị́ ũmĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ꞌBá adriꞌbée tã be mãdã rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã kộpi ímụ́ ngá Múngú ní ẹzịị́ rĩ ị́sụ́ vũ drị̃gé nõgó rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ꞌBá ẹ̃bị́rị́ be, ãzini úvá ꞌbãꞌbá tã pịrị ꞌozú rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã tã pịrị kộpi ní lẽé rĩ, kộpi ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ꞌBá ẹ́sị́ be múké rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã Múngú ri ímụ́ ẹ́sị́ múké ꞌbã kộpi ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ꞌBá ẹ́sị́ be ule rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã kộpi ímụ́ Múngú ri ndre rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ꞌBá tãkíri íjị́ꞌbá ꞌbá rĩ pi ãsámvú gé rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã Múngú ri ímụ́ kộpi zị anji ívé ni. ");
INSERT INTO kbo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ꞌBá ĩ ní ọ̃cụ̃ụ́ ĩzãngã nyaá tã pịrị ã tã sĩ rĩ pi, kộpi tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã mãlũngã ꞌbụ̃ vé rĩ adri kộpivé ni. ");
INSERT INTO kbo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ĩmi ꞌbá ĩ ní rií uꞌdaá, ĩ ní rií ọ̃cụ̃ụ́ ĩzãngã nyaá, ãzini ĩ ní rií ũnjõ ụ́lị́ ĩmi drị̃gé mâ tã sĩ rĩ pi, ĩmi tãkíri ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ĩmi únjíkí, ĩmi adrikí ãyĩkõ sĩ, ãꞌdiãtãsĩyã ãndẽma ãmbúgú ĩmi ũfẽzú rĩ, ĩri ĩmi tẽ ꞌbụ̃ gé ꞌdãáꞌdã. Nẹ́bị̃ ọ́tụ́ ĩmi sĩ drị̃drị̃ rĩ pi, ọ̃cụ̃kí nyo kộpi ĩzãngã nyaá sụ̃ ĩmi ní nyaá ꞌdĩri tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ĩmi adrikí sụ̃ ẹ̃ꞌyị́ tị́nị vũ drị̃gé nõgó. ꞌBo ẹ̃ꞌyị́ rĩ vé sị́ asuúpi asuasu rĩ ícá dõ ãlákála gí, ĩ ícó gõ ĩri údé, ã asu rí asuasu íngóni? Gõ adrií múké ngá áꞌdízú ãní ku, ĩ ꞌdụ dã vũgá, ꞌbá rĩ pi utu pá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ĩmi adrikí sụ̃ụ́ ụ̃tụ́ŋá riípi ãngũ ĩmgbẽrẽépi vũ drị̃gé nõgó rĩ tị́nị. Kụ̃rụ́ ĩ ní sịị́ ánga drị̃gé rĩ, ĩri índré ku ãngũ ule gá. ");
INSERT INTO kbo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ꞌBá ãzi ícó lámbã ꞌyũú ũdrí ụ̃pị̃ị́ drị̃ ni gé cí ku, ĩri lámbã rĩ ꞌbã mísá drị̃gé, ĩri ãngũ ĩmgbẽrẽ ku uletere ꞌbá rĩ pi ní jó agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lẽ kpá ĩmivé ãcí ã dị̃ dị̃ ꞌbá rĩ pi ẹndrẹtị gé, kộpi ã ndrekí rí tã múké ĩmi ní ꞌoó rĩ, kộpi ẽ íngúkí rí ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ãní. ");
INSERT INTO kbo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Lẽ ĩmi rikí ụ̃sụ̃ụ́ ꞌyozú kínĩ má ímụ́ tãị́mbị́ Mósẽ vé rĩ fụụ́ drãá ꞌdíni ku, dõku má ímụ́ tã nẹ́bị̃ rĩ pi ní sĩí rĩ fụụ́ drãá ꞌdíni ku, má ímụ́ ĩmi ní tã rĩ vé ífífí ũlũú. ");
INSERT INTO kbo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ádarú á ꞌyo ĩmi ní ꞌdíni, tã ã fí tãị́mbị́ rĩ vé ĩ ní sĩí rĩ ícó ãvĩí ãluŋáni ku, cĩmgbá cazú ꞌbụ̃ pi ní áfízú vũ be rĩ gé, tã ĩ ní sĩí tãị́mbị́ rĩ agá rĩ pi ãrẽvú céré ímụ́ ĩ nga rá. ");
INSERT INTO kbo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ꞌBá tãị́mbị́ ĩ ní ndreé kuú mãdãŋá rĩ ŋõópi, gõópi ꞌbá rĩ pi ímbápi tã ãlu ãlu ꞌdĩri ꞌdụụ́pi ngaápi rĩ, ĩ ímụ́ ĩri ndre ku mãdãŋáŋá mãlũngã ꞌbụ̃ vé rĩ gé ꞌdãá, ꞌbo ꞌbá tã ĩ ní ẹzịị́ rĩ ꞌdụụ́pi ngaápi rá rĩ, ĩ ímụ́ ĩri ꞌdụ ꞌbã ãmbúgú mãlũngã ꞌbụ̃ vé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lẽ ĩmi ꞌdụkí tãị́mbị́ Múngú vé rĩ ngaá pịrị, ã ndẽ Fãrụ́sị̃ rĩ pi ní rií ꞌdụụ́ ngaá rĩ rá, ãzini ã ndẽ ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi ní rií ꞌdụụ́ ngaá rĩ rá. Ĩmi ꞌokí dõ ꞌdíni ku, á sõ ũyõ, ĩmi ícókí fií mãlũngã ꞌbụ̃ vé rĩ agá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ĩmi yịkí rá, ꞌyokí ꞌbá ị́nọ́gọ́sị́ ꞌdãꞌbée ní kínĩ, ‘Lẽ mî ꞌdị ꞌbá ku, ꞌbá rĩ ꞌdị dõ ꞌbá, ĩ ĩri ĩrĩŋã rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ꞌBo á ꞌyo ĩmi ní ꞌdíni, ꞌbá rĩ ẽ ẹ́sị́ ve dõ ẹ́drị́pị ní, ĩ ꞌbá ꞌdĩri ĩrĩŋã rá. ꞌBá rĩ ꞌda dõ ẹ́drị́pị ri, átá dõ átángá ũnjí ĩri ní, ĩ ꞌbá ꞌdĩri jị ꞌbá tã lịꞌbá rĩ pi ẹndrẹtị gé. ꞌBo ꞌbá rĩ ꞌyo dõ, ‘Mi azakaza rú!’ ĩ ꞌbá ꞌdĩri ꞌdụ ꞌbe ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kúru mi dõ ri fẽfẽ jị sẽ Múngú ní vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ gé ꞌdãá, ꞌí mụ dõ ígá mí ẹ́sị́ agá ꞌdãá, mí ꞌo mí ẹ́drị́pị ri ũnjí, ");
INSERT INTO kbo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ꞌí ku fẽfẽ mí ní lẽé jịị́ sẽé Múngú ní rĩ kú vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ gé ꞌdãá, drị̃drị̃ ni, ĩmi údékí ĩmi ãsámvú mí ẹ́drị́pị be rĩ ũgbále, kúru ꞌí gõ rí mụụ́ fẽfẽ mí ní lẽé sẽé Múngú ní rĩ sẽé ndõ. ");
INSERT INTO kbo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ꞌBá ãzi lẽ dõ mi tõó, lẽ dõ mi jịị́ jó ĩ ní tã lịzú rĩ agá, ĩmi kádõ rií mụụ́ ĩri be lẹ́tị gé ꞌdĩgé, ĩmi údékí ĩmivé tã ĩmi ãsámvú gé ĩri be rĩ mbẽlẽŋá, ꞌí ꞌo dõ ꞌdíni kuyé, ꞌbá mi tõópi rĩ, ĩri mi jị pá tu ꞌbá tã lịị́pi rĩ ẹndrẹtị gé, ꞌbá tã lịị́pi rĩ mi sẽ ũgalaku drị́gé, ũgalaku rĩ mi jị ꞌbe jó ãngũ ũꞌyĩzú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ádarú á ꞌyo ĩmi ní ꞌdíni, ꞌdụkí dõ mi ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá gí, mí ĩfũ ãmvé ku, mi ngá ĩ ní lịị́ mí drị̃gé rĩ ũfẽ ũgbále ká, mi íbí ĩfũ ãmvé ndõ. ");
INSERT INTO kbo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ĩmi yịkí rá tãị́mbị́ rĩ kĩnĩ, ‘Lẽ mî ꞌbã ọ̃wụ̃ ku.’ ");
INSERT INTO kbo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ꞌBo á ꞌyo ĩmi ní ꞌdíni, ꞌbá rĩ ndre dõ ũkú mụzú gbĩígbĩí, ꞌbá ꞌdĩri ẹ́sị́ agá ꞌdãá ꞌbã ọ̃wụ̃ gí. ");
INSERT INTO kbo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mívé mị drị́ ẹ̃ndẹ́pị gé rĩ sẽ dõ mi fií ũnjĩkãnyã ꞌoó nĩ, lẽ mî ínjé ĩri ꞌbeé ꞌdĩísĩ ãmvé. ꞌÍ nje dõ ĩgélé ãzi mî rụ́ꞌbá gá rĩ ꞌbeé vũgá, ĩri múké, ndẽ mí ní fizú mî rụ́ꞌbá be ngị ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mívé drị́ ẹ̃ndẹ́pị sẽ dõ mi fií ũnjĩkãnyã ꞌoó nĩ, lẽ mî lị ĩri ꞌbeé ꞌdĩísĩ rá. ꞌÍ lị dõ ĩgélé ãzi mî rụ́ꞌbá gá rĩ ꞌbeé vũgá, ĩri múké, ũnjí ni mí ní fizú mî rụ́ꞌbá be ngị ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ĩmi yịkí rá tãị́mbị́ Mósẽ vé rĩ kĩnĩ, ‘ꞌBá rĩ dro dõ ívé ũkú, lẽ ã sĩ kọ̃kọ̃bị́ sẽé ũkú rĩ drị́gé ĩri drozú ãní.’ ");
INSERT INTO kbo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ dro dõ ívé ũkú gí, ꞌdĩri lũ ũkú rĩ ní lẹ́tị ọ̃wụ̃ ꞌbãzú ni. Ũkú rĩ adri dõ ágó ãzi be ká, ꞌbá rĩ íbí ũkú rĩ dro ndõ, ꞌbá ũkú ꞌdĩri jeépi rĩ, ꞌbã ꞌdĩri ꞌbã ọ̃wụ̃ ꞌbá ãzi vé ũkú sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ĩmi yịkí kpá rá ꞌyokí ꞌbá ị́nọ́gọ́sị́ rĩ pi ní kínĩ, ‘Mí sõ dõ ũyõ, lẽ mî ŋõ ũyõ mí ní sõó rĩ ku, ũyõ mí ní sõó Úpí ẹndrẹtị gé rĩ, lẽ mî ꞌdụ tã ni ngaánga. ");
INSERT INTO kbo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ꞌBo á ꞌyo ĩmi ní ꞌdíni, lẽ ĩmi sõkí ũyõ ku. Lẽ ĩmi rikí ꞌbụ̃ ã rụ́ ẹ́dị́ ũyõ sõzú ãní ku, ãꞌdiãtãsĩyã ꞌbụ̃ rĩ lúpá Múngú vé ni, ");
INSERT INTO kbo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","dõku ĩmi rikí vũ ã rụ́ ẹ́dị́ ũyõ sõzú ãní ku, ãꞌdiãtãsĩyã vũ rĩ Múngú vé ni, ĩri pá ꞌbã ãní, dõku ĩmi rikí Yẹ̃rụ́sãlémã ã rụ́ ẹ́dị́ ũyõ sõzú ãní ku, ãꞌdiãtãsĩyã ĩri kụ̃rụ́ ꞌBãgú ãmbúgú rĩ vé ni. ");
INSERT INTO kbo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Lẽ mî ri mî drị̃ ẹ́dị́ ũyõ sõzú ãní ku, ãꞌdiãtãsĩyã mí ícó mî drị̃ꞌbí újá ícá imve dõku ịnị ku. ");
INSERT INTO kbo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tã mí ní újá rĩ, ĩri dõ ẽ, ã adri ẽ, dõ kuyé, ã adri kuyé. Tã rĩ dõ ũꞌdũ be túngú, tã ꞌdĩri íbí íngá ãdróko vúgálésĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ĩmi yịkí rá ọ́tụ́ ꞌyokí kínĩ, ‘ꞌBá ãzi sõ dõ mî mị ọfụụ́, ꞌbá ãzi ri kpá ĩri ẽ mị sõ ọfụ rá, ꞌbá ãzi kpu dõ mî sị́, ꞌbá ãzi ri kpá ĩri ẽ sị́ kpu rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ꞌBo á ꞌyo ĩmi ní ꞌdíni, ꞌbá rĩ ꞌo dõ mi ũnjí, ã ꞌokí ĩri ũnjí sụ̃ ĩri ní mi ꞌoó rĩ tị́nị ku. ꞌBá rĩ sa dõ mî gbángírí drị́ ẹ̃ndẹ́pị gé rĩ, lẽ mî újá kpá mî gbángírí drị́ ị̃jị́ gé rĩ ã sa. ");
INSERT INTO kbo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ꞌBá ãzi lẽ dõ mi jịị́ mụụ́ ꞌbá tã lịꞌbá rĩ pi ẹndrẹtị gé, ꞌî ꞌdụ rí mívé bõngó ágá vé rĩ, lẽ mî sẽ kpá ĩri ní mívé bõngó akoó rụ̃kụ̃ rĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ꞌBá ãzi si dõ mi ũkpõ sĩ, kĩnĩ mî jị ꞌi máyĩlĩ ãlu, lẽ mî jị ĩri caá máyĩlĩ ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ꞌBá ãzi zị dõ ngá mí tị gé, lẽ mî sẽ ĩri ní ngá ĩri ní zịị́ rĩ, ꞌbá ãzi lẽ dõ ngá ẹ́ꞌyị́ mí vúgá, lẽ mî uga ĩri ní ngá rĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ĩmi yịkí ándúrú rá kínĩ, ‘Lẽ mî lẽ ꞌbá mí gãrã gá rĩ lẽlẽ, ãzini lẽ mî ndre mívé ariꞌba rĩ pi ũnjí.’ ");
INSERT INTO kbo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, lẽ ĩmi lẽkí ariꞌba ĩmivé rĩ pi lẽlẽ, ꞌbá ĩmi ꞌoꞌbá ũnjí rĩ pi, lẽ ĩmi zịkí kộpi ní Múngú ri. ");
INSERT INTO kbo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ĩmi ꞌokí dõ tã rĩ ꞌdíni, ĩri lũ ꞌyozú kínĩ ádarú ĩmi anji ꞌbá Ẹ́tẹ́pị Múngú ꞌbụ̃ gé rĩ vé ni. Múngú ri ụ̃tụ́ sẽ ka ꞌbá múké rĩ pi ní, ãzini ꞌbá ũnjí rĩ pi ní ĩndĩ, ãzini ĩri yị̃ị́gọ́ sẽ ꞌdị ꞌbá tã ꞌoꞌbá pịrị rĩ pi ní, ãzini ꞌbá tã ꞌoꞌbá ũnjí rĩ pi ní ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ꞌÍ ri dõ ꞌyéŋá ꞌbá mi lẽꞌbá rĩ pi lẽé áyu, mi nyo ícó tã múké ị́sụ́ ãní rá? ꞌBá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi lẽkí kpá ꞌbá ĩ lẽꞌbá rĩ pi lẽlẽ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi dõ ꞌyéŋá ri mõdó sẽ mí ẹ́drị́pị́ị ní, tã múké mí ní ị́sụ́ ꞌa ní gé ꞌdĩgé rĩ ãꞌdi? Pãgánõ rĩ pi ꞌokí nyo tã sụ̃ụ́ ꞌdĩri tị́nị ku? ");
INSERT INTO kbo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sâ céré sĩ, lẽ ĩmi ꞌokí tã pịrị, sụ̃ sâ céré sĩ ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ní tã ꞌoó pịrị rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Lẽ ĩmi ndrekí múké, ĩmi dõ ri tã múké ꞌo, tã ĩmi ní ꞌoó rĩ, lẽ ĩmi rikí ꞌoó ꞌbá rĩ pi ẹndrẹtị gé andrekelemgbe kộpi ã ndrekí rí ꞌyozú kínĩ, ĩmi ri tã múké ꞌo ꞌdíni ku. Ĩmi ꞌokí dõ ꞌdíni, ĩmi ícókí ngá ĩmi Ẹ́tẹ́pị ní úmvúlésĩ lẽé sẽé ĩmi ní ꞌbụ̃ gé ꞌdãá rĩ ị́sụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mi dõ ri ngá sẽ ꞌbá ngá ãkó rĩ pi ní, lẽ mî ri tã ni áyú mụzú ꞌbá rĩ pi ní sụ̃ ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị riꞌbá ngá ĩ ní sẽé ꞌbá ngá ãkó rĩ pi ní rĩ ã tã áyúꞌbá Jó Múngú ri Zịzú rĩ pi agásĩ, ãzini lẹ́tị drị̃gé sĩ, ꞌbá rĩ pi ẽ íngúkí rí ĩ ãní rĩ pi tị́nị ku. Ádarú á lẽ lũú ĩmi ní ꞌdíni, ngá ꞌyéŋá kộpi ní ị́sụ́ rĩ, ĩri tã ꞌbá rĩ pi ní kộpi íngúzú ꞌdãri. ");
INSERT INTO kbo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ꞌBo mi dõ ri ngá sẽ ꞌbá ngá ãkó rĩ pi ní, lẽ ꞌbá ãzi ã nị̃ ngá mí ní sẽé rĩ vé tã ku. ");
INSERT INTO kbo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Lẽ mî sẽ ngá rĩ kíri, ꞌbá ãzi ã nị̃ tã ni ku. Kúru mí Ẹ́tẹ́pị riípi tã ĩ ní ꞌoó kíri rĩ ndreépi rĩ, ĩri mi ũfẽ rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ĩmi kádõ rií Múngú ri zịị́, lẽ ĩmi adrikí sụ̃ ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị rĩ pi tị́nị ku, kộpi lẽkí rií pá tuú ụrụ sĩ Múngú ri zịị́ Jó Múngú ri Zịzú rĩ pi agásĩ, ãzini lẹ́tị drị̃gé sĩ, ꞌbá rĩ pi ẽ íngúkí rí ĩ ãní bẽnĩ. Ádarú á lẽ lũú ĩmi ní ꞌdíni, Ngá ꞌyéŋá kộpi ní ị́sụ́ rĩ, ĩri tã ꞌbá rĩ pi ní kộpi íngúzú ꞌdãri. ");
INSERT INTO kbo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mi dõ ri Múngú ri zị, lẽ mî fi jó agá, mî ụ̃pị̃ kẹ̃ẹ́tị rĩ cí, ꞌí zị mí Ẹ́tẹ́pị ĩ ní rụ́ꞌbá ni ndreé ku rĩ, kúru mí Ẹ́tẹ́pị riípi tã ĩ ní ꞌoó kíri rĩ vé tã nị̃ị́pi céré rĩ, ĩri mi ũfẽ rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ĩmi kádõ rií Múngú ri zịị́, lẽ ĩmi rikí átángá ífífí ãkó ni pi ẹndịị́ zịị́ mụzú dị̃ị́ dị̃ị́ sụ̃ ꞌbá Múngú ri nị̃ꞌbá kuyé rĩ pi tị́nị ku, kộpi ụ̃sụ̃kí Múngú ri ícó ĩvé átángá ĩ ní átá kárákará ꞌdĩꞌbée yị rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lẽ ĩmi adrikí sụ̃ kộpi tị́nị ku, ãꞌdiãtãsĩyã tã ĩmi lẽé zịị́ rĩ, ĩmi Ẹ́tẹ́pị nị̃ ị́nọ́gọ́sị́ gí. ");
INSERT INTO kbo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ĩmi lẽkí dõ Múngú ri zịị́, ĩmi zịkí ꞌdíni, “ ‘ꞌBávé Ẹ́tẹ́pị ꞌbụ̃ gé rĩ, rụ́ mívé rĩ ẽ ị̃njị̃kí ị̃njị̃njị̃. ");
INSERT INTO kbo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lẽ mãlũngã mívé rĩ ẽ ímụ́ ĩyí, lẽ ã ngakí tã mî ẹ́sị́ ní lẽé rĩ vũ drị̃gé nõgó sụ̃ ꞌbụ̃ gé ꞌdĩlé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌÍ sẽ ꞌbá ní ãnyãngã ụ́ꞌdụ́ ãndrũ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞌÍ trũ ꞌbâ ũnjĩkãnyã ꞌbá ní ꞌoó rĩ agásĩ rá, sụ̃ ꞌbá ní ꞌbá ꞌbâ ꞌoꞌbá ũnjí rĩ pi trũú rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Lẽ mî sẽ tã ũnjí ã ụ̃ꞌbị̃ ꞌbâ ku, lẽ mî pa ꞌbâ ãdróko drị́gé sĩ rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ãꞌdiãtãsĩyã ĩmi trũkí dõ ꞌbá ĩmi ꞌoꞌbá ũnjí rĩ pi rá, ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ kpá ĩmi trũ rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ꞌBo ĩmi trũkí dõ ꞌbá ĩmi ꞌoꞌbá ũnjí rĩ pi ku, ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ trũ kpá ĩmi ku. ");
INSERT INTO kbo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ĩmi dõ ri ĩmi aꞌbi ngá nyanya sĩ, lẽ ĩmi rikí adrií ĩzãngã sĩ sụ̃ ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị rĩ pi tị́nị ku, kộpi ri adri ku ĩzãngã ĩzãngã rú, ꞌbá rĩ pi ã ndrekí rí ꞌyozú kínĩ ĩ ri ãnyãngã aꞌbi. Ádarú á lẽ lũú ĩmi ní ꞌdíni, ngá ꞌyéŋá kộpi ní ị́sụ́ rĩ, ĩri tã ꞌbá rĩ pi ní kộpi íngúzú ꞌdãri. ");
INSERT INTO kbo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ꞌBo mi dõ ri mi aꞌbi ngá nyangárá sĩ, lẽ mî inga mî drị̃ꞌbí inganga, mî ũjĩ mî ẹndrẹtị yị̃ị́ sĩ, ");
INSERT INTO kbo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌbá rĩ pi ã nị̃kí rí ꞌyozú kínĩ mi ri mi aꞌbi ngá nyangárá sĩ ꞌdíni ku. ꞌBo ꞌyéŋá mí Ẹ́tẹ́pị riípi tã ĩ ní ũzụ̃ụ́zụ̃ rĩ vé tã nị̃ị́pi céré rĩ, ĩri mi ũfẽ rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Lẽ ĩmi rikí ãꞌbú ꞌbãá kuú ĩmi ní vũ drị̃gé nõgó ku, vũ drị̃gé nõgó, ị́jị́rị́kọ́ ri ngá mbembe, ngá ri ụ́drị́drị̃, ụ̃gụ́ꞌbá ri ngá ụ̃gụ̃gụ̃. ");
INSERT INTO kbo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lẽ ĩmi ꞌbãkí ĩmi ní ngá múké rĩ pi kú ꞌbụ̃ gé ꞌdãá, vũrã ị́jị́rị́kọ́ ní ngá izazú ku, ngá ní ụ́drị́zú ku, ụ̃gụ́ꞌbá ní ngá ụ̃gụ̃zú ku rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ãꞌdiãtãsĩyã mi mî ẹ́sị́ ꞌbã ku vũrã mí ní mívé ãꞌbú ꞌbãzú rĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mị ri lámbã rụ́ꞌbá nõri vé ni. Mî mị dõ múké, ĩri sẽ tã mî rụ́ꞌbá gá rĩ pi céré adri múké. ");
INSERT INTO kbo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mî mị dõ ũnjí, ĩri sẽ mî rụ́ꞌbá ri céré adri ị́nị́ŋá agá. Mí újá dõ mi rií tã ị́nị́ŋá vé ni ꞌoó, tã mívé rĩ gõ adri ũnjíkãnyãkãnyã. ");
INSERT INTO kbo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ꞌBá ãlu ícó ẹ̃zị́ ngaá ꞌbá ị̃rị̃ pi ní ku. Sâ ãzi sĩ, ĩri ãzi rĩ gã sĩ, ĩri ãzi rĩ lẽlẽ, dõku ĩri ẹ̃zị́ nga ãzi rĩ ní, ĩri ãzi rĩ idede. Mi dõ ri ẹ̃zị́ nga Múngú ní, lẽ mî ꞌbã ẹ́sị́ ãmbúgú mũfẽngã drị̃gé ku. ");
INSERT INTO kbo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kúru á lẽ ꞌyoó ĩmi ní ꞌdíni, lẽ ĩmi rikí ĩmi ụ̃sụ̃ụ́ drãá rụ́ꞌbá nõri vé tã sĩ ku. Ãnyãngã vé tã, ngá mvụụ́mvụ rĩ vé tã, ãzini bõngó sũúsu rĩ vé tã, ĩmi rikí ĩmi ụ̃sụ̃ụ́ drãá ãní ku. Ĩmi kádõ ụ̃sụ̃ụ́, ídri vé tã ndẽ nyo ãnyãngã ꞌbá ní rií nyaá rĩ kuyé? Rụ́ꞌbá ꞌbávé rĩ ndẽ nyo bõngó ꞌbá ní rií suú ꞌbâ rụ́ꞌbá gá rĩ kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ĩmi ndrekí drĩ ãríŋá ungaꞌbá ụrụ ꞌdĩꞌbée ká, kộpi ꞌãkí ọ́mvụ́ ku, dõku kộpi ĩkũnãkí ãnyãngã ku, dõku kộpi ꞌbãkí ãnyãngã ĩrá agá ku. Ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ri kộpi ní ãnyãngã sẽ nĩ. Múngú mịlé gá ꞌdãá, ĩmivé tã ndẽ ãríŋá rĩ pi vé rĩ rá, ĩri ngá ĩmi ní lẽé rĩ sẽ ĩmi ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ĩmi dõ ri ĩmi ụ̃sụ̃ drã tã sĩ sụ̃ ꞌdĩri tị́nị, ĩmi nyo ícó adri ca lókí be ãco rá? ");
INSERT INTO kbo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ngá ĩmi ní rizú ĩmi ụ̃sụ̃zú drãzú bõngó ã tã sĩ rĩ ãꞌdi? Ĩmi ndrekí drĩ pẹtị ã fũ ásé agá ꞌdĩꞌbée ká. Kộpi ngakí ẹ̃zị́ ku, dõku kộpi údékí bõngó ku. ");
INSERT INTO kbo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbãgú Sõlõmónã ri ọ́tụ́ bõngó ũnyĩ be ni suú, bõngó ĩri ní suú rĩ vé ũnyĩ ndẽ fũ rĩ pi vé rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Múngú ri dõ pẹtị ã fũ zoópi ãndrũ, drụ̃ ĩri ụ́nyụ́ rá rĩ pi ã tã mba rá pírí, Múngú ícó nyo ĩmi ní bõngó sẽé suú ku? Ẹ̃ꞌyị̃ngárá ĩmivé rĩ mãdãŋá. ");
INSERT INTO kbo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kúru lẽ ĩmi rikí ĩmi ụ̃sụ̃ụ́ drãá ꞌyozú kínĩ, ‘ꞌBâ ãꞌdi nya?’ dõku ‘ꞌBâ ãꞌdi mvụ?’ dõku ‘ꞌBâ ãꞌdi su yã ꞌdíni ku?’ ");
INSERT INTO kbo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pãgánõ rĩ pi ri tã ꞌdĩꞌbée ꞌo nĩ. Ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ nị̃ ngá ĩmi ní lẽé rĩ pi ãrẽvú céré gí. ");
INSERT INTO kbo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Drị̃drị̃ ni, lẽ ĩmi ꞌbãkí ẹ́sị́ céré rizú mãlũngã Múngú vé rĩ vé ẹ̃zị́ ngazú, lẽ ĩmi ꞌokí tã pịrị, ngá ĩmi ní lẽé rĩ pi, Múngú ri ícó sẽ ĩmi ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lẽ ĩmi rikí ĩmi ụ̃sụ̃ụ́ drãá tã drụ̃ vé rĩ sĩ ku, tã drụ̃ vé rĩ, ĩri ꞌi nga drụ̃. Ụ́ꞌdụ́ ãlu ãlu ri ívé ĩzãngã be. ");
INSERT INTO kbo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ã lịkí ꞌbá ãzi vé tã ꞌyozú kínĩ ĩri ũnjí ku, Múngú ã lị rí mívé tã ũnjí ku. ");
INSERT INTO kbo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ãꞌdiãtãsĩyã ĩmi lịkí dõ ꞌbá ụrụkọꞌbée vé tã ꞌyozú kínĩ kộpi ũnjí, Múngú ri kpá ĩmivé tã lị ũnjí, sụ̃ ĩmi ní kộpivé tã lịị́ ꞌyoó kínĩ kộpi ũnjí rĩ tị́nị. Tã ĩmi ní ꞌoó ꞌbá ụrụkọꞌbée ní rĩ, Múngú ri kpá ꞌo ĩmi ní sụ̃ ĩmi ní ꞌoó kộpi ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Mi ngá mãdãŋá ꞌdeépi mí ọ́gụ́pị mị gé rĩ ndre rá pírí, ꞌbo ngá ꞌdeépi mí mị gé usegúgú ꞌdĩri, ꞌí ndre ku ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mi ícó ꞌyo ꞌí lẽ ngá mãdãŋá ꞌdeépi mí ọ́gụ́pị mị gé ꞌdĩri ĩpẽé rá, ꞌbo mí ícó ngá usegúgú ꞌdeépi mí mị gé ꞌdĩri ĩpẽé ku ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mi ꞌbá mi ꞌbãápi kú tã be pịrị ꞌdĩri, lẽ mî ĩpẽ ngá usegúgú ꞌdeépi mí mị gé ꞌdĩri ũgbále, mî ndre rí ãngũ uletere, mí íbí rí ngá mãdãŋá ꞌdeépi mí ọ́gụ́pị mị gé ꞌdĩri ĩpẽé ndõ. ");
INSERT INTO kbo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ngá múké ĩ ní lẽé sẽé Múngú ní rĩ, ã sẽkí ꞌbá adriꞌbée sụ̃ ũcógú tị́nị rĩ pi ní ku. Mãyãkã ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ãjẽ be ãmbúgú ĩ ní zịị́ pálĩ rĩ pi, ã sẽkí ꞌbá adriꞌbée sụ̃ ĩgá tị́nị rĩ pi ní ku, ĩmi sẽkí dõ ꞌbá sụ̃ ꞌdĩꞌbée tị́nị rĩ pi ní, kộpi utu ị́nị́ pá sĩ, kộpi gõ ĩmi nya drị̃ ni gé kpãá. ");
INSERT INTO kbo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ĩmi zịkí, ĩ sẽ ĩmi ní rá, ĩmi ndãkí, ĩmi ị́sụ́ rá, ĩmi gakí kẹ̃ẹ́tị rĩ, ĩ zị̃ ĩmi ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ꞌBá rĩ zị dõ ngá, ĩ sẽ ĩri ní rá. ꞌBá rĩ ndã dõ ngá, ĩri ị́sụ́ rá. ꞌBá rĩ ga dõ kẹ̃ẹ́tị rĩ, ĩ zị̃ ĩri ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ĩmi ãsámvú gé ꞌdĩgé, mívé mváŋá zị dõ pánga mí tị gé, mi nyo ícó ĩri ní írã sẽ áyu rá? ");
INSERT INTO kbo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Dõku zị dõ ị̃ꞌbị́, mi ícó ĩri ní ị̃nị̃ sẽ áyu rá? ");
INSERT INTO kbo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ĩmi ꞌbá adriꞌbée ũnjĩkãnyã be ꞌdĩꞌbée, ĩmi dõ ícó ngá múké sẽ ĩmivé anjiŋá rĩ pi ní fẽfẽ rú rá pírí, kúru ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ícó nyo ngá múké sẽé fẽfẽ rú ꞌbá ngá zịꞌbá ꞌí vúgá rĩ pi ní ku? ");
INSERT INTO kbo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lẽ ĩmi ꞌokí ꞌbá rĩ pi múké, sụ̃ ĩmi ní lẽé ꞌbá rĩ pi ã ꞌokí ĩmi múké rĩ tị́nị. Tãị́mbị́ Mósẽ vé rĩ, ãzini tã nẹ́bị̃ rĩ pi ní sĩí rĩ vé ífífí adriípi ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Lẽ ĩmi fikí kẹ̃ẹ́tị mãdãŋá rĩ agásĩ. Ãꞌdiãtãsĩyã kẹ̃ẹ́tị ẹ̃pị rĩ, ãzini lẹ́tị ẹ̃pị rĩ, ĩri ꞌbá rĩ jị fi drãngárá agá, ꞌbá kárákará pi fi mụzú ꞌa ni gé sĩ nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ꞌBo kẹ̃ẹ́tị mãdãŋá rĩ, ãzini lẹ́tị ure rĩ, ꞌbá rĩ mụ ãní ídríngárá ị́sụ́, ꞌbá kíníkiniŋá ni pi ꞌyéŋá fi ídri rĩ ị́sụ́ nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Lẽ ĩmi adrikí mị be kọwụ nẹ́bị̃ ũnjó rú ꞌdĩꞌbée sĩ. Kộpi ri ĩ ꞌbã adri sụ̃ kãbĩlõ ĩdríkídri rĩ tị́nị, ꞌbo ẹ́sị́ gélésĩ, kộpi índrékí sụ̃ ãrãkíla ãngũ ũndĩípi kpélékpélé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mi kộpi nị̃ ámá tã kộpi ní ꞌoó rĩ sĩ, sụ̃ mí ní pẹtị rĩ pi nị̃ị́ ámá ĩvé ũꞌa sĩ rĩ tị́nị. ꞌBá rĩ pi nyo ícó ũꞌa vị́nyọ̃ vé rĩ, dõku fị́gị̃ vé rĩ ũtĩ pẹtị ũcékúcé be rĩ sị́gé rá? ");
INSERT INTO kbo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pẹtị múké rĩ, ũꞌa ni ri adri múké, ꞌbo pẹtị ũnjí rĩ, ũꞌa ni ri adri ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pẹtị múké rĩ ícó ꞌaá ũꞌa be ũnjí ku, ãzini pẹtị ũnjí rĩ ícó ꞌaá ũꞌa be múké ku. ");
INSERT INTO kbo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pẹtị ꞌaápi múké ku rĩ, ĩ ĩri ga íꞌdé vũgá, ĩ ꞌdụ ꞌbe ãcí agá. ");
INSERT INTO kbo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ĩ pẹtị rĩ nị̃ ámá ũꞌa ĩrivé rĩ sĩ, kúru ĩ ꞌbá ũnjó rú rĩ pi nị̃ ámá tã kộpi ní ꞌoó rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ꞌBá riꞌbá ma zịꞌbá tị sĩ ‘Úpí, Úpí,’ ꞌdĩꞌbée ãsámvú gé, ụrụkọꞌbée ícókí fií mãlũngã ꞌbụ̃ vé rĩ agá ku, ꞌyéŋá ꞌbá riꞌbá tã má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ní lẽé ã ꞌdụkí ngaá rĩ ꞌdụꞌbá ngaꞌbá rá rĩ pi ícó fi ꞌbụ̃ gé ꞌdãá nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ụ́ꞌdụ́ ĩ ní ímụ́zú tã lịzú ꞌdãri sĩ, ꞌbá kárákará pi ma zị, ‘Úpí, Úpí, ꞌbá ũlũkí nyo ụ́ꞌdụ́kọ́ múké rĩ mî rụ́ sĩ kuyé? Ãzini ꞌbá údrókí nyo índrí ũnjí rĩ pi mî rụ́ sĩ kuyé? Ãzini ꞌbá ꞌokí nyo tã ãyãzú ãyãyã ni ũkpõ mívé rĩ sĩ kuyé?’ ");
INSERT INTO kbo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kúru ma ímụ́ ꞌyo kộpi ní, ‘Á nị̃ ĩmi kuyé. Ĩmi ꞌbá tã ꞌoꞌbá ũnjí ꞌdĩꞌbée, ĩmi dẹ̃kí ĩmi ꞌdĩísĩ rá!’ ");
INSERT INTO kbo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ꞌBá tã mávé rĩ yịị́pi rá, ãzini tã ni ꞌdụụ́pi ngaápi rá rĩ, adri sụ̃ ꞌbá úmĩ be, jó sịị́pi ndụ̃ụ́ ni ãꞌbãápi ũkpó ũkpó írã sĩ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yị̃ị́gọ́ ꞌdị ãmbúgú, yị̃ị́ tị jó rĩ ĩmũlũú, ũlí vị jó rĩ, ꞌbo jó rĩ árí kuyé, ãꞌdiãtãsĩyã sị jó rĩ ũkpó ũkpó. ");
INSERT INTO kbo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ꞌBá tã má ní ímbá rĩ yịị́pi ku, ãzini tã ni ꞌdụụ́pi ngaápi ku rĩ, adri sụ̃ ꞌbá azakaza rú, jó sịị́pi cínyáfã agá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yị̃ị́gọ́ ꞌdị ãmbúgú, yị̃ị́ tị̃ jó rĩ ĩmũlũú, ũlí vị jó rĩ, jó rĩ árí rụ̃yụ̃ vũgá.” ");
INSERT INTO kbo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yẹ́sụ̃ kã átángá rĩ átá dẹẹ́ gí, ꞌbá bị́trị́ká rĩ pi ãyãkí ãyãyã tã ĩri ní ímbá ꞌdĩri sĩ, ");
INSERT INTO kbo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ãꞌdiãtãsĩyã Yẹ́sụ̃ ímbá tã rĩ ũkpõ be, ímbá tã rĩ sụ̃ ꞌbá Mósẽ vé tãị́mbị́ ímbáꞌbá rĩ pi ní ímbá rĩ tị́nị kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yẹ́sụ̃ kã ísị́ írã drị̃gé ꞌdãásĩ vũgá nõó, ꞌbá bị́trị́ká ꞌdekí mụzú vụ́drị̃ ni gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ágó ãzi ũfú ní nyaá ni ímụ́ kũmũcí ũtị̃ị́ Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Úpí, mí ãꞌyĩ dõ rá, mí ídrí ma.” ");
INSERT INTO kbo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yẹ́sụ̃ ní ꞌî drị́ suzú ágó rĩ ã rụ́ꞌbá úlózú, ĩri ní ꞌyozú kĩnĩ, “Má ãꞌyĩ rá, lẽ mî rụ́ꞌbá ã adri ule.” Koro ũfú rĩ ní dẹzú ágó rĩ ã rụ́ꞌbá gá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kúru Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “Lẽ mî lũ tã ꞌdĩri ꞌbá ãzi ní ku. ꞌÍ mụ mi iꞌdaá átálágú rĩ ẹndrẹtị gé, ꞌí ꞌyo ĩri ní mî rụ́ꞌbá ícá múké gí. Kúru ꞌí jị fẽfẽ sẽé átálágú rĩ ní, sụ̃ tãị́mbị́ Mósẽ ní sẽé rĩ tị́nị, ꞌbá rĩ pi ã nị̃kí rí ꞌyozú kínĩ mî rụ́ꞌbá ícá múké gí.” ");
INSERT INTO kbo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yẹ́sụ̃ kã fií Kãpãrãnãụ́mã gá ꞌdãá, ũgalaku ãngáráwá rĩ pi vé rĩ ní ímụ́zú Yẹ́sụ̃ vúgá nõó, ĩri ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ĩri ní ꞌyozú kĩnĩ, “Úpí, mávé ãtíꞌbá la kú gbọ́lọ́ drị̃gé, ícó ẹ̃cị̃ tuú ꞌbã ku, ĩri ri ĩzãngã nya ambamba.” ");
INSERT INTO kbo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Ma mụ ĩri ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ũgalaku rĩ ní ꞌyozú kĩnĩ, “Úpí, má ícó mi ãꞌyĩí mụụ́ mávé ãngá ꞌdãá ku. Mí átá átángá rĩ nõgó, mávé ãtíꞌbá rĩ ícó ídrí rá. ");
INSERT INTO kbo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ũgalaku ambugu ni pi anigé má drị̃lé gá, ma ãmbúgú ãngáráwá rĩ pi drị̃gé, kộpi tã yị má tị gé. Ma ícó ꞌyo ãlu ni ní, ‘ꞌÍ mụ,’ ĩri ícó mụ rá. Ma ícó ꞌyo ãzini ní, ‘Mí ímụ́,’ ĩri ímụ́ rá, Ma ícó ꞌyo mávé ãtíꞌbá ní, ‘ꞌÍ ꞌdụ tã ꞌdĩri ngaá,’ ĩri tã rĩ ꞌdụ nga rá.” ");
INSERT INTO kbo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yẹ́sụ̃ kã tã ꞌdĩri yịị́, sẽ ĩri ní ãyãngárá, ĩri ní ꞌyozú ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ádarú á lẽ lũú ĩmi ní ꞌdíni, Ĩsẽrélẽ rĩ pi ãsámvú gé, ꞌbá ãzi má ní ị́sụ́ ẹ̃ꞌyị̃ngárá be ágó nõri vé rĩ tị́nị ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Á ꞌyo mí ní ꞌdíni, ꞌbá kárákará pi íbí íngá ụ̃tụ́ ní ĩfũngárá gálésĩ, ãzini ụ̃tụ́ ní ꞌdengárá gálésĩ, kộpi ímụ́ ĩ úmú ụ̃mụ̃ nya Ãbũrámã pi be, Ĩsákã pi be Yõkóbũ pi be, mãlũngã ꞌbụ̃ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ꞌBo Yãhụ́dị̃ Múngú rĩ ẹ̃ꞌyị̃ꞌbá kuyé rĩ pi, ĩ ímụ́ kộpi dro fũ mãlũngã Múngú vé rĩ agásĩ ãmvé, kộpi mụ adri vũrã bĩípi nịị́pi cịcị rĩ agá, kộpi ímụ́ ngo, ãzini sị́kányá ci ãcí rĩ vé fingárá ĩ rụ́ꞌbá gá rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kúru Yẹ́sụ̃ ní ꞌyozú ũgalaku ãngáráwá rĩ pi vé rĩ ní kĩnĩ, “ꞌÍ mvi gõó ꞌbẹ̃tị́, sụ̃ mí ní ẹ̃ꞌyị̃ị́ ꞌyozú kínĩ, ãtíꞌbá mívé rĩ ídrí rá rĩ tị́nị, ãtíꞌbá rĩ ídrí gí.” Ãngáráwá rĩ pi vé ãmbúgú rĩ ca mụụ́ ị́sụ́ ívé ãtíꞌbá rĩ ídrí gí, ídrí sâ Yẹ́sụ̃ ní ꞌyoó ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yẹ́sụ̃ kã fií Pétẽró vé jó agá ꞌdãá, ị́sụ́ Pétẽró ị̃drẹ́pị la kú gbọ́lọ́ drị̃gé, rụ́ꞌbá ni ko gbírílí. ");
INSERT INTO kbo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yẹ́sụ̃ ní ũkú rĩ ẽ drị́ rụzú, drã rĩ ní dẹzú ũkú rĩ rụ́ꞌbá gá sĩ. Kúru ĩri ní íngázú ụrụ, ĩri ní ínyá áꞌdízú sẽzú Yẹ́sụ̃ ní. ");
INSERT INTO kbo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ũndréŋá ꞌdãri sĩ, íjị́kí ꞌbá kárákará índrí ũnjí be ni pi ímụ́ Yẹ́sụ̃ vúgá nõó, Yẹ́sụ̃ kã átá, índrí ũnjí rĩ pi fũkí ꞌbá ꞌdĩꞌbée drị̃gé sĩ rá. Yẹ́sụ̃ ídrí ꞌbá drã be rĩ pi ãrẽvú céré. ");
INSERT INTO kbo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tã ọ́tụ́ Múngú ní ẹzịị́, nẹ́bị̃ Ĩsáyã ní ꞌyoó rĩ nga ꞌi fũú tị ni gé gí kĩnĩ, “Sẽ ꞌbávé drã dẹ ꞌbâ rụ́ꞌbá gá sĩ gí, ãzini ꞌdụ drã dẹꞌbá ku rĩ pi ꞌbâ rụ́ꞌbá gá sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yẹ́sụ̃ kã ndreé ꞌbá kárákará trakí ꞌî gãrã kụ́rụ̃, ĩri ní ꞌyozú kĩnĩ, lẽ ꞌbâ zokí yị̃ị́ bãlãlã rĩ mụzú álé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kúru ꞌbá riípi tãị́mbị́ Mósẽ vé rĩ ímbápi rĩ ní ímụ́zú Yẹ́sụ̃ vúgá nõó, ĩri ní ꞌyozú kĩnĩ, “Ímbápi, ma ꞌde mụzú mí vúgá sĩ ĩndĩ vũrã mí ní lẽzú mụzú rĩ gé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Ũfá pi ꞌbụ́ be rizú lazú ãní, ãríŋá ungaꞌbá ụrụ sĩ rĩ pi ĩvé jó be, ꞌbo ma ꞌBá Mvá ꞌi, vũrã má ní mâ drị̃ suzú adrizú ni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ꞌBá ĩri ã pámvú ũbĩꞌbá rĩ pi vé ãzi ní ꞌyozú ĩri ní kĩnĩ, “Úpí, mâ mụ drĩ má ẹ́tẹ́pị ri sị̃ị́ ũgbále ká.” ");
INSERT INTO kbo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ꞌBo Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Mí ímụ́ mâ pámvú ũbĩí, ꞌí ku ꞌbá ũdrãꞌbá gí rĩ pi ã sị̃kí ĩvé ꞌbá ũdrãꞌbá gí rĩ pi.” ");
INSERT INTO kbo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kúru Yẹ́sụ̃ pi ní tụzú kũlúmgba agá ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Koro ũlí ní íngázú vịzú ũkpõ be, sẽ yị̃ị́ rĩ úvá ngũyá ngũyá, lẽ tị̃ị́ kũlúmgba rĩ agá. ꞌBo ị́sụ́ ãkũdẽ Yẹ́sụ̃ ri ụ́ꞌdụ́ ko. ");
INSERT INTO kbo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ĩrivé ꞌbá ĩri ãpámvú ũbĩꞌbá rĩ pi ní ĩri aruzú ụ́ꞌdụ́ gélésĩ, kộpi ní ꞌyozú ĩri ní kínĩ, “Úpí, ꞌbâ ri tĩ yị̃ị́ ã ndụ́gé, ꞌí pa ꞌbâ fô!” ");
INSERT INTO kbo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ngá ĩmi ní adrizú ụ̃rị̃ sĩ rĩ ãꞌdi? Ĩmivé ẹ̃ꞌyị̃ngárá mãdãŋá.” Kúru ĩri ní ngazú ụrụ sĩ, ĩri ní átázú ũkpõ be kĩnĩ, ũlí vịị́pi ũkpõ be ꞌdĩri, ãzini yị̃ị́ riípi úvápi ngũyá ngũyá ꞌdĩri ã tu pá, ũlí vịị́pi rĩ, ãzini yị̃ị́ riípi úvápi ngũyá ngũyá rĩ gõ pá tuú rá! ");
INSERT INTO kbo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ãgõ kũlúmgba agá rĩ pi ãyãkí tã ꞌdĩri sĩ ãyãyã, kộpi ní zịzú kínĩ, “Ágó ũlí vịị́pi ũkpõ be ꞌdĩri ugaápi, ãzini yị̃ị́ riípi úvápi ngũyá ngũyá ꞌdĩri ugaápi pá tuúpi ꞌdĩri ꞌbá íngóni ni?” ");
INSERT INTO kbo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yẹ́sụ̃ kã yịị́ bãlãlã rĩ zoó caá ãngũ Gẽrásã vé rĩ gé ꞌdãá, ãgõ ị̃rị̃ índrí ũnjí be ni pi ri adri ꞌbụ́rẹ̃drị̃ rĩ pi ãsámvú gé ꞌdãá, kộpi ní ímụ́zú Yẹ́sụ̃ vúgá nõó. Kộpi ọ̃jọ́gọ́ ọ̃jọ́gọ́, ꞌbá ãzi ícó ẹlịị́ lẹ́tị ꞌdãri gé sĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ãgõ ꞌdĩꞌbée ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Yẹ́sụ̃ Mvá Múngú vé rĩ, ngá mí ní lẽé ꞌbá vúgá rĩ ãꞌdi? Mí ímụ́ ꞌbá ní ĩzãngã sẽé ị́sụ́zú sâ ni ícó drĩ kuyé?” ");
INSERT INTO kbo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vũrã ꞌdãri ĩ ri ĩgá úcé ãní, ãsámvú ni vụ̃ kộpi be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Índrí ũnjí rĩ pi ní Yẹ́sụ̃ ri mãzú kínĩ, “ꞌÍ lẽ dõ ꞌbâ droó fũú ãmvé, ꞌí pẽ ꞌbâ mụụ́ úfí ĩgá rĩ pi agá.” ");
INSERT INTO kbo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí!” Índrí ũnjí rĩ pi ní fũzú ãgõ ꞌdĩꞌbée rụ́ꞌbá gá sĩ, mụzú úfízú ĩgá rĩ pi agá, ĩgá rĩ pi ní njuzú mụzú ọ́ngụ́ sĩ ãngũ úlúpi úlúlũ rĩ gé ꞌdãá, kộpi ní uꞌdezú ũdrãzú yị̃ị́ bãlãlã rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ꞌBá riꞌbá ĩgá rĩ pi úcéꞌbá rĩ pi ní njuzú mụzú kụ̃rụ́ agá ꞌdãá, kộpi ní mụzú tã ꞌi ngaápi ꞌdĩri ũlũzú, ãzini kộpi ní tã ꞌi ngaápi ãgõ ị̃rị̃ índrí ũnjí be ꞌdĩꞌbée rụ́ꞌbá gá rĩ pi ũlũzú. ");
INSERT INTO kbo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ꞌBá kụ̃rụ́ agá rĩ pi céré ngakí ĩfũú ímụ́ Yẹ́sụ̃ vúgá nõó. Kộpi kâ Yẹ́sụ̃ ri ndreé, kộpi mãkí Yẹ́sụ̃ ri kínĩ, Yẹ́sụ̃ ã fũ ĩvé ãngũ agásĩ ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yẹ́sụ̃ ní tụzú kũlúmgba agá, gõ yị̃ị́ bãlãlã rĩ zoó mụzú álé kụ̃rụ́ ĩri ní rizú adrizú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ãgõ ụrụkọꞌbée ní ágó pá be ꞌbẽléꞌbéle ni íꞌdụ́zú pọ́rọ̃sị̃ sĩ íjị́zú Yẹ́sụ̃ vúgá nõó. Yẹ́sụ̃ kã kộpivé ẹ̃ꞌyị̃ngárá nị̃ị́ ámá, ĩri ní ꞌyozú ágó pá be ꞌbẽléꞌbéle rĩ ní kĩnĩ, “Mâ mvá rĩ, mí adri ĩzãngã sĩ ku! Trũkí mi mívé ũnjĩkãnyã agásĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ꞌBá Mósẽ vé tãị́mbị́ ímbáꞌbá rĩ pi ã ụrụkọ ní rizú átázú ĩ ãsámvú gé sĩ kínĩ, “Ágó ꞌdĩri ị̃njị̃ Múngú ri ku! Ágó rĩ ụ̃sụ̃ ꞌi Múngú ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ rĩ rá, ĩri ní ꞌyozú kĩnĩ, “Ngá ĩmi ní rizú tã ũnjí ụ̃sụ̃zú ĩmî ẹ́sị́ agá ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mâ ꞌyo rí tã rĩ íngóni? Mâ ꞌyo rí, ‘Trũkí mi mívé ũnjĩkãnyã agásĩ gí ꞌdíni,’ dõku mâ ꞌyo, ‘ꞌÍ nga ụrụ ẹ̃cị̃ tuú’? ");
INSERT INTO kbo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ꞌBo á lẽ lũú ĩmi ní ꞌyozú kínĩ, ma ꞌBá Mvá ꞌi, ma ũkpõ be ũnjĩkãnyã trũzú vũ drị̃gé nõgó” Ĩri ní kúru ꞌyozú ágó pá be ꞌbẽléꞌbéle rĩ ní kĩnĩ, “ꞌÍ nga ụrụ, ꞌí ꞌdụ mívé pọ́rọ̃sị̃, ꞌí mvi ꞌbẹ̃tị́.” ");
INSERT INTO kbo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ágó rĩ ní kúru ngazú ụrụ, ĩri ní ꞌdezú mụzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ꞌBá bị́trị́ká rĩ pi kâ tã ꞌdĩri ndreé, sẽ kộpi ní ụ̃rị̃, kộpi ngakí rií Múngú ũkpõ sẽépi ꞌbá rĩ pi ní ꞌdĩri íngú. ");
INSERT INTO kbo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yẹ́sụ̃ kã rií ꞌdeé mụzú lẹ́tị gé sĩ, ĩri ní Mãtáyo ri ndrezú, úrí kuú jó ĩ ní rizú mũfẽngã umbe jezú rĩ uꞌdụzú ꞌbãgú ãmbúgú Rómã vé rĩ ní rĩ agá. Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Mí ímụ́ adrií ꞌbá mâ pámvú ũbĩípi ni,” Mãtáyo ní koro ngazú ụrụ, ĩri ní ꞌdezú mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yẹ́sụ̃ pi kâ rií ínyá ũndréŋá vé rĩ nyaá Mãtáyo vé ãngá ꞌdãá, ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi, ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be, ímụ́kí úrí ínyá nyaá Yẹ́sụ̃ pi be trụ́, ãzini ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fãrụ́sị̃ rĩ pi kâ tã ꞌdĩri ndreé ꞌdíni, kộpi ní ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi zịzú kínĩ, “Ĩmivé ꞌbá riípi ãngũ ímbápi rĩ ri ínyá nya ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi be, ãzini ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ ãꞌdiãtãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yẹ́sụ̃ kã ta kộpivé ꞌdĩri yịị́, ĩri ní ꞌyozú kĩnĩ, “ꞌBá drã ãkó rĩ ndã ꞌbá ũjó sẽépi ni ku, ꞌbá drã be rĩ, ĩri ꞌbá ũjó sẽépi ni ndã nĩ ");
INSERT INTO kbo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ꞌBo ĩmi mụkí tã ĩ ní sĩí ꞌdĩri ã fífí ụ̃nị̃ị́, ‘Á lẽ ĩmî ẹ́sị́ ã adri ĩdríkídri, adri ꞌyozú kínĩ á lẽ ĩmi zãkí má ní rọ̃bọ̃ŋọ̃ yã ꞌdíni kuyé.’ Má ímụ́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi zịị́ kuyé, má ímụ́ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi zịị́.” ");
INSERT INTO kbo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ụ́ꞌdụ́ ãlu, ꞌbá Yũwánĩ ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBâ Fãrụ́sị̃ rĩ pi be ri ꞌbâ aꞌbi ngá nyanya sĩ rá pírí, mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi aꞌbikí ĩ ngá nyangárá sĩ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Kẹ̃rẹ́gú ọ̃mụ́rụ́gọ́ rĩ vé rĩ dõ drĩ ụ̃mụ́ ímụ́ꞌbá ọ̃mụ́rụ́gọ́ rĩ jengárá gá rĩ pi ãsámvú gé anigé, ụ̃mụ́ rĩ pi nyo ícó adri ĩzãngã sĩ rá? Sâ ãzi ri ímụ́ ꞌdĩíꞌdĩ, kádõ ímụ́ ọ̃mụ́rụ́gọ́ rĩ vé kẹ̃rẹ́gú ꞌdụụ́ kộpi ãsámvú gé sĩ, kúru kộpi ímụ́ ĩ aꞌbi ngá nyangárá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Bõngó dẽépi gí rĩ, ícókí bõngó úꞌdí ĩsĩí vũrã ãsĩípi gí rĩ ící ãní ku, ãꞌdiãtãsĩyã bõngó ꞌi nyaápi kú ị́rị́kọ́ rú gí rĩ, ícíkí dõ úlẽ ni ọ̃zụ̃ụ́ bõngó úꞌdí ni sĩ, ĩri gõ ãsĩ mụzú drị̃gélé, úlẽ ni gõ adri ãmbúgú. ");
INSERT INTO kbo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ꞌBá ãzi ícó vị́nyọ̃ ĩ ní zoó úꞌdí rú rĩ tõó lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá ku. ꞌBá rĩ tõ dõ vị́nyọ̃ rĩ lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá, jũrú rĩ ãfĩ rá, ĩri sẽ vị́nyọ̃ rĩ dã vũgá. Lẽ ã tõkí vị́nyọ̃ rĩ jũrú úꞌdí ni agá, ĩri sẽ lãꞌbú rĩ ícó ãfĩí ku, vị́nyọ̃ rĩ ícó dãá vũgá ku.” ");
INSERT INTO kbo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yẹ́sụ̃ kã rií átá, drị̃koma ãzi ní ímụ́zú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé kĩnĩ, “Mávé mvá ũkúŋá drã sâ ꞌdĩri sĩ gí. Mí ímụ́ drị́ ꞌbãá drị̃ ni gé, ẽ ídrí rí gõó ũzi.” ");
INSERT INTO kbo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yẹ́sụ̃ pi ní ꞌdezú mụzú vụ́drị̃ ni gé sĩ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sâ ꞌdãri gé, ũkú ãzi ãrí ri ẹ́cị́ rụ́ꞌbá ni gé sĩ caá ílí mụdrị́ drị̃ ni ị̃rị̃, ũkú rĩ ímụ́ Yẹ́sụ̃ ã úgóró gálésĩ, ĩri ní Yẹ́sụ̃ vé bõngó akoó rụ̃kụ̃ rĩ ẽ tị úlózú. ");
INSERT INTO kbo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãlé kĩnĩ, “Má úló dõ Yẹ́sụ̃ vé bõngó akoóko rĩ ẽ tị, ma ícó ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yẹ́sụ̃ ní ꞌi újázú ĩri ndrezú, Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Mvá ũkúŋá ꞌdĩri, mí adri ĩzãngã sĩ ku, mívé ẹ̃ꞌyị̃ngárá sẽ mí ídrí gí.” Sâŋá ꞌdãri gé, ãrí rĩ vé ẹ́cị́ngárá gõ pá tuú rá. ");
INSERT INTO kbo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yẹ́sụ̃ kã fií drị̃koma rĩ vé jó agá ꞌdãá, kã yịị́ ꞌbá bị́trị́ká rĩ pi ri ẹ́rị́ co ãvũ rĩ ngozú, ");
INSERT INTO kbo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ĩri ní ꞌyozú kĩnĩ, “Ĩmi fũkí ãmvé, mvá ũkúŋá rĩ drã kuyé, ĩri ri ụ́ꞌdụ́ ko.” ꞌBo kộpi rikí gụụ́gụ tã Yẹ́sụ̃ ní ꞌyoó ꞌdĩri sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yẹ́sụ̃ kã ꞌbá kárákará rĩ pi pẽé fũú mụzú ãmvé ꞌdãá gí, ĩri ní fizú mụzú jó agá ꞌdãá, ĩri ní mvá ũkúŋá rĩ ẽ drị́ rụzú, mvá ũkúŋá rĩ ní íngázú ụrụ. ");
INSERT INTO kbo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tã ꞌdĩri ayi mụzú kụ̃rụ́ ꞌdãri agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yẹ́sụ̃ kã ngaá mụzú, ꞌbá ị̃rị̃ mị be ẹ̃sị̃ꞌbá gí ni pi ꞌdekí mụụ́ Yẹ́sụ̃ vúgá sĩ, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã ꞌbávé rĩ fô!” ");
INSERT INTO kbo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yẹ́sụ̃ kã fií mụzú jó agá ꞌdãá, ꞌbá mị be ẹ̃sị̃ꞌbá gí rĩ pi ní fizú mụzú Yẹ́sụ̃ vúgá ꞌdãá, Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi ẹ̃ꞌyị̃kí ꞌyozú kínĩ ma ícó ĩmî mị zị̃ rá ꞌdíni rá?” Kộpi ní újázú kínĩ, “Úpí, ꞌbá ẹ̃ꞌyị̃kí rá, mi ꞌbâ mị zị̃ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kúru Yẹ́sụ̃ ní kộpi ẽ mị úlózú ãlu ãlu céré, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ní ẹ̃ꞌyị̃ị́ gí rĩ sĩ, ma ĩmi ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Koro kộpi ẽ mị ní ꞌi zị̃zú ãngũ ndrezú. Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi ũlũkí tã ꞌdĩri ꞌbá ãzi ní ku.” ");
INSERT INTO kbo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kộpi ní ꞌdezú mụzú, ꞌbo kộpi gõkí tã rĩ ũlũú mụzú kụ̃rụ́ rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yẹ́sụ̃ pi kâ rií ꞌdeé mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, ꞌbá ụrụkọ ní ágó ãzi índrí ũnjí be átápi ku ni íjị́zú Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yẹ́sụ̃ ní índrí ũnjí rĩ drozú fũzú ágó rĩ drị̃gé sĩ, ágó ándúrú átápi ku rĩ ní íꞌdózú átázú. ꞌBá bị́trị́ká rĩ pi ãyãkí tã ꞌdĩri sĩ ãyãyã, kộpi ní ꞌyozú kínĩ, “Tã ãzi nga drĩ ꞌi ãngũ Ĩsẽrélẽ vé rĩ agá sụ̃ ꞌdĩri tị́nị kuyé!” ");
INSERT INTO kbo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ꞌBo Fãrụ́sị̃ rĩ pi ní ꞌyozú kínĩ, “Ágó ꞌdĩri ri índrí ũnjí rĩ pi údró ũkpõ ãmbúgú índrí ũnjí rĩ pi vé rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yẹ́sụ̃ ní ẹ́cị́zú kụ̃rụ́ rĩ agásĩ, ãzini gụ́rụ́ rĩ pi agásĩ, ri ꞌbá rĩ pi ímbá Jó Múngú ri Zịzú rĩ pi agásĩ, ri ụ́ꞌdụ́kọ́ múké mãlũngã vé rĩ ã tã ũlũú, ri ꞌbá drã be ãndíãndí rĩ pi ídrí mụzú. ");
INSERT INTO kbo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yẹ́sụ̃ kã ꞌbá bị́trị́ká rĩ pi ndreé, sẽ ĩri ní ĩzãngã, ãꞌdiãtãsĩyã ĩzãngã kộpivé rĩ aga rá, ꞌbá ãzi kộpi ẽ ĩzã koópi ni ꞌdãáyo, kộpi índrékí sụ̃ kãbĩlõ ꞌbá úcépi ni ní adrií ꞌdãáyo rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ĩri ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ãnyãngã rĩ ka ambamba, ꞌbo ꞌbá ãnyãngã rĩ ĩkũnãꞌbá rĩ pi gãrú.” ");
INSERT INTO kbo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lẽ ĩmi zịkí Úpí ọ́mvụ́ ꞌdị́pa rĩ, ã pẽ rí ꞌbá rĩ pi mụụ́ ívé ọ́mvụ́ agá ꞌdãá ãnyãngã rĩ ĩkũnãá. ");
INSERT INTO kbo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi zịzú, sẽ kộpi ní ũkpõ índrí ũnjí rĩ pi údrózú, ãzini ꞌbá drã be ãndíãndí rĩ pi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi vé rụ́ pi ꞌdĩ, ꞌbá drị̃drị̃ rĩ, Sị̃mọ́nã ꞌi, ĩrivé rụ́ ãzi Pétẽró ꞌi, ãzi rĩ Pétẽró ẹ́drị́pị Ãndẽréyã ꞌi, Yõkóbũ Zẽbẽdáyõ mvọ́pị ꞌi, Yõkóbũ ẹ́drị́pị Yũwánĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pĩlípũ ꞌi, Bãtĩlĩmáyõ ꞌi, Tómã ꞌi, Mãtáyo ꞌi, Mãtáyo ri ꞌbá mũfẽngã umbe jezú rĩ uꞌdụụ́pi ni, Yõkóbũ Ãlãfáyõ mvọ́pị ꞌi, Tãdáyõ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sị̃mọ́nã ẹ́sị́ ꞌbãápi ꞌbá ívé rĩ pi ẽ ị́sụ́kí rí drị̃wãlã rĩ ꞌi, ãzini Yụ́dã Ĩsĩkãrĩyótã gõópi Yẹ́sụ̃ ã ũli ꞌbeépi rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yẹ́sụ̃ ní ꞌbá mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée pẽzú mụzú, ĩri ní ẹzịzú kộpi ní kĩnĩ, “Lẽ ĩmi mụkí ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi ãsámvú gé ꞌdãá ku, dõku lẽ ĩmi fikí kụ̃rụ́ ꞌbá Sãmãríyã vé rĩ pi ní adrizú rĩ agá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ĩmi mụkí Ĩsẽrélẽ adriꞌbá sụ̃ kãbĩlõ ãvĩꞌbá gí rĩ pi tị́nị rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ĩmi cakí dõ gí, ĩmi ũlũkí kộpi ní kínĩ, ‘Mãlũngã ꞌbụ̃ vé rĩ ícá ĩnyiŋá gí.’ ");
INSERT INTO kbo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ĩmi ídríkí ꞌbá drã be rĩ pi, ĩmi ingakí ꞌbá ũdrãꞌbá gí rĩ pi gõó ídri rú, ĩmi ídríkí ꞌbá ũfú ní nyaá rĩ pi, ĩmi údrókí índrí ũnjí rĩ pi. Á sẽ ĩmi ní ũkpõ ꞌdĩri kána, ꞌbo lẽ ĩmi kokí kpá ꞌbá rĩ pi ẽ ĩzã kána. ");
INSERT INTO kbo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ã ꞌdụkí mũfẽngã jịị́ mụzú ĩndĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ĩmi kádõ mụụ́ ẹ̃cị̃ rĩ gé ꞌdãá, ã ꞌdụkí jũrú mụzú ĩndĩ ku, dõku ã ꞌdụkí bõngó ãzi ãndõ rú mụzú ĩndĩ ku, dõku ã ꞌdụkí ngá pá gá ni pi mụzú ĩndĩ ku, dõku ã ꞌdụkí túré mụzú ĩndĩ ku, ãꞌdiãtãsĩyã ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi, lẽ ã sẽkí kộpi ní ngá nyanya. ");
INSERT INTO kbo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kụ̃rụ́ ĩmi ní caá ꞌa ni gé rĩ, ãzini gụ́rụ́ ĩmi ní caá ꞌa ni gé rĩ, lẽ ĩmi ndãkí ꞌbá múké ni ị́sụ́ vũrã ꞌdãri agá, ĩmi adrikí ĩrivé ãngá ꞌdãá, cĩmgbá ĩmi ní ngazú mụzú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ĩmi fikí dõ caá ꞌbẹ̃tị́ ꞌdãri agá, ĩmi sẽkí mõdó ꞌbá ꞌbẹ̃tị́ ꞌdãri ãsámvú gé rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ꞌBá ꞌbẹ̃tị́ ꞌdãri ãsámvú gé rĩ pi ẹ́ꞌyị́kí dõ ĩmi rá, ĩmi sẽkí kộpi ní tãkíri, dõ ꞌbá ꞌbẹ̃tị́ ꞌdãri ãsámvú gé rĩ pi gãkí ĩmi ẹ́ꞌyị́gá sĩ, ã sẽkí kộpi ní tãkíri ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ꞌBá rĩ ẹ́ꞌyị́ dõ ĩmi kuyé, dõku gã dõ ĩmivé tã yịgá sĩ, ĩmi kádõ ĩfũú ꞌbẹ̃tị́ ꞌdãri agásĩ, dõku kụ̃rụ́ ꞌdãri agásĩ, lẽ ĩmi wekí nyọ̃ọ́kụ́ ĩmi pá ágélé gá rĩ kú ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ádarú á ꞌyo ĩmi ní ꞌdíni, ụ́ꞌdụ́ ĩ ní ímụ́zú tã lịzú rĩ gé, kụ̃rụ́ Sõdómõ vé rĩ, ãzini Gõmórã vé rĩ, ĩ tã lị kộpi drị̃gé mãdã, ꞌbo ĩ ímụ́ tã lị kụ̃rụ́ ꞌdãri drị̃gé aga rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ma ĩmi pẽ mụzú sụ̃ ĩ ní kãbĩlõ pẽé ãrãkíla rĩ pi ãsámvú gé rĩ tị́nị, kúru lẽ ĩmi adrikí úmĩ be sụ̃ ị̃nị̃ vé rĩ tị́nị, ãzini ĩmi adrikí tã be pịrị sụ̃ ãmámũ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ꞌBo ĩmi ndrekí múké! ꞌBá rĩ pi ímụ́ ĩmi urụ jị tõ ꞌbá tã lịꞌbá rĩ pi ẹndrẹtị gé rá, kộpi ĩmi ũgbã ĩvé Jó Múngú ri Zịzú rĩ pi agá ꞌdãá rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ĩmi ní rií mâ pámvú ũbĩí rĩ sĩ, ĩ ímụ́ ĩmi jị tõ gávãnã ẹndrẹtị gé, ãzini ꞌbãgú rĩ pi ẹndrẹtị gé, ĩri sẽ ĩmi ụ́ꞌdụ́kọ́ múké rĩ ũlũ ãní kộpi ní, ãzini ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ꞌBo kộpi rụkí dõ ĩmi gí, lẽ ĩmi rikí ụ̃sụ̃ụ́ ꞌyozú kínĩ ĩmi átá íngóni yã ꞌdíni ku, ãꞌdiãtãsĩyã tã ĩmi ní lẽé átá sâ ꞌdãri gé rĩ, Índrí Uletere rĩ ũlũ ĩmi ní nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ĩmi átákí tã rĩ nĩ ku, tã ĩmi ní lẽé átá rĩ, Índrí ĩmi Ẹ́tẹ́pị Múngú vé rĩ átá ĩmi ní nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ẹ́drị́pị ri ímụ́ ẹ́drị́pị ã ũli ꞌbe, ĩri ẹ́drị́pị ri sẽ ꞌdị drã rá. Ẹ́tẹ́pị ri ímụ́ ívé anjiŋá rĩ pi ã ũli ꞌbe, ĩri kộpi sẽ úꞌdị́ ũdrã rá, anjiŋá rĩ pi ímụ́ ufu ku ariꞌba rú, kộpi ꞌbá ĩ tịꞌbá rĩ pi sẽ úꞌdị́ ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ꞌBá rĩ pi céré ímụ́ ĩmi gã sĩ mâ tã sĩ, ꞌbo ꞌbá pá tuúpi tị́tị́ ívé ẹ̃ꞌyị̃ngárá agá cĩmgbá ụ̃dụ̃ gé rĩ, Múngú ri ímụ́ ĩri pa rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ꞌBá rĩ pi ꞌokí dõ ĩmi ũnjí kụ̃rụ́ ãzi agá, ĩmi ápákí mụzú kụ̃rụ́ ãzi agá. Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ma ꞌBá Mvá ꞌi, má ní drĩ ícázú kuyé rĩ gé, ĩmi ícókí ẹ́cị́ kụ̃rụ́ Ĩsẽrélẽ vé rĩ pi agásĩ céré ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ꞌBá ĩ ní rií ímbá rĩ ícó ꞌbá ꞌi ímbápi rĩ ndẽé tã sĩ ku, ãtíꞌbá ícó adrií ꞌbá ꞌí ní rií ẹ̃zị́ ngaá vú ni gé rĩ drị̃gé ãmbúgú rú ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lẽ ꞌbá ĩ ní rií ímbá rĩ ã adri sụ̃ ꞌbá riípi ꞌi ímbápi rĩ tị́nị, lẽ ãtíꞌbá rĩ ã adri sụ̃ ívé ãmbúgú tị́nị. Ma adriípi jó ꞌdị́pa nõri, ꞌbá rĩ pi dõ ri ma zị Bẽlẽzẽbúlã, ĩmi ꞌbá adriꞌbée mávé jó ãsámvú gé nõꞌbée, kộpi ímụ́ rụ́ ũnjí ꞌda ĩmî rụ́ꞌbá gá rá! ");
INSERT INTO kbo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ꞌBo lẽ ĩmi adrikí ꞌbá ꞌdĩꞌbée sĩ ụ̃rị̃ sĩ ku. Ngá ãzi ícópi ꞌi zụ̃ụ́pi, ꞌi iꞌdaápi ãmvé ku ni ꞌdãáyo, dõku ngá ãzi ꞌi zụ̃ụ́pi ĩ ní ícó nị̃ị́ ku ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tã má ní ũlũú ĩmi ní kíri nõri, lẽ ĩmi jịkí mụụ́ ũlũú ꞌbá rĩ pi ní. Átángá má ní átá ĩmi ní ũyõkõyõ sĩ nõri, ĩmi mụkí áyú ꞌbá rĩ pi ní ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lẽ ĩmi rukí ꞌbá riꞌbá ãngũ úꞌdị́ꞌbá rĩ pi ku, kộpi ícókí índrí rĩ ꞌdịị́ drãá ku. Lẽ ĩmi rukí ꞌyéŋá Múngú índrí rĩ sẽépi fiípi ãcí agá, ãzini rụ́ꞌbá rĩ sẽépi fiípi ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá rĩ áyu. ");
INSERT INTO kbo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ãríŋá mãdã mãdã ị̃rị̃ ĩ ꞌyéŋá ụzị mũfẽngã ã fí ãlu. ꞌBo ãlu ni ícó drãá ku, ĩmi Ẹ́tẹ́pị ãꞌyĩ dõ tã ni nĩ ká, ĩri íbí drã ndõ. ");
INSERT INTO kbo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Múngú lã drị̃ꞌbí ĩmi drị̃gé rĩ pi céré gí. ");
INSERT INTO kbo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lẽ ĩmi adrikí ụ̃rị̃ sĩ ku, ĩmivé tã ndẽ ãríŋá kárákará rĩ pi vé rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ꞌBá rĩ ãꞌyĩ dõ ma rá ꞌbá rĩ pi ẹndrẹtị gé, ꞌyo dõ ꞌí ãꞌyĩ ma gí, ma kpá ĩri ãꞌyĩ má Ẹ́tẹ́pị ꞌbụ̃ gé ꞌdãlé rĩ ẹndrẹtị gé rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ꞌBá rĩ gã dõ ma sĩ vũ drị̃gé nõgó, ma kpá ĩri gã sĩ má Ẹ́tẹ́pị ẹndrẹtị gé ꞌbụ̃ gé ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ĩmi rikí ụ̃sụ̃ụ́ ꞌyozú kínĩ, má íjị́ tãkíri vũ drị̃gé nõgó ꞌdíni ku. Má íjị́ tãkíri kuyé, mávé ímụ́ngárá nõri, ꞌbá rĩ pi ẽ ímụ́kí rí ĩ ngụ̃ụ́ ãní ũnjí mâ tã sĩ bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mávé ímụ́ngárá nõri ĩri sẽ, “ ‘mvá ágó pi ímụ́ ĩ aco ẹ́tẹ́pị be, mvá ũkú pi ímụ́ ĩ aco ẹ́ndrẹ́pị be, ũkú ágó tị gé rĩ, kộpi ímụ́ ĩ aco ị̃drẹ́pị be. ");
INSERT INTO kbo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ãríꞌbá mívé rĩ pi íbí ĩfũ mívé ꞌbẹ̃tị́ ãsámvú gé ꞌdĩgé.’ ");
INSERT INTO kbo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ꞌBá rĩ lẽ dõ ꞌí ẹ́tẹ́pị ri dõku ꞌí ẹ́ndrẹ́pị ri ma ndẽé, ꞌbá ꞌdĩri ícó adrií ꞌbá mâ pámvú ũbĩípi ni ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ꞌBá rĩ gã dõ ívé pẹtị alambaku ꞌdụgá sĩ, ãzini gã dõ mâ pámvú ũbĩgá sĩ, ꞌbá ꞌdĩri ícó adrií ꞌbá mâ pámvú ũbĩípi ni ku. ");
INSERT INTO kbo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ꞌBá riípi ívé ídri ã tã mbaápi nyọ̃ọ́kụ́ drị̃gé nõgó rĩ, ícó ídri ꞌdániꞌdáni rĩ ị́sụ́ ku. ꞌBá rĩ adi dõ ívé ídri sẽé drãá mâ tã sĩ, ĩri ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ꞌBá rĩ ẹ́ꞌyị́ dõ ĩmi, ẹ́ꞌyị́ ꞌdĩri ma, ꞌbá rĩ ẹ́ꞌyị́ dõ ma, ẹ́ꞌyị́ ꞌdĩri má Ẹ́tẹ́pị ma ĩpẽépi rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ꞌBá rĩ ẹ́ꞌyị́ dõ nẹ́bị̃ riípi tã Múngú vé rĩ ũlũúpi rĩ ívé ãngá, ĩ ímụ́ ĩri ũfẽ sụ̃ ĩ ní nẹ́bị̃ rĩ ũfẽé rĩ tị́nị. Ãzini ꞌbá rĩ ẹ́ꞌyị́ dõ ꞌbá tã be pịrị Múngú vé ni ívé ãngá, ĩri ní tã ꞌoó pịrị rĩ sĩ, ĩ ímụ́ ĩri ũfẽ sụ̃ ĩ ní ꞌbá tã be pịrị ꞌdĩri ũfẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ꞌBá rĩ sẽ dõ yị̃ị́ ĩdríkídri ni mvụụ́ ꞌbá mâ pámvú ũbĩꞌbá tã be mãdã rĩ pi vé ãlu ni ní rá, ádarú ĩ ímụ́ ĩri ũfẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yẹ́sụ̃ kã tã rĩ ẹzịị́ dẹẹ́ ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi ní gí, ĩri ní ꞌdezú mụzú ꞌbá rĩ pi ímbázú, ãzini tị sẽzú mụzú kụ̃rụ́ Gãlĩláyã vé rĩ pi agásĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yũwánĩ Bãtízĩmũ sẽépi ĩ ní ꞌyĩí kuú jó ãngũ ũꞌyĩzú rĩ agá rĩ kã tã Kúrísítõ ní rií ꞌoó rĩ yịị́, ĩri ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi pẽzú mụzú ");
INSERT INTO kbo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBá ĩ ní ꞌyoó kínĩ ĩri ímụ́ ꞌdĩíꞌdĩ rĩ, ĩri mi ꞌi, dõku ꞌbá ĩ ní ꞌyoó ĩri ímụ́ rĩ túngú?” ");
INSERT INTO kbo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi újákí ĩmi gõó vúlé Yũwánĩ vúgá ꞌdãá, ĩmi ũlũkí ĩri ní tã ĩmi ní yịị́, ãzini ĩmi ní ndreé rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ꞌBá mị be ẹ̃sị̃ꞌbá gí rĩ pi, kộpi nóni ãngũ ndre rá. ꞌBá pá be ábáꞌbá gí rĩ pi, kộpi nóni ẹ̃cị̃ tu rá. ꞌBá ũfú ní nyaá rĩ pi, kộpi ã rụ́ꞌbá ícá nóni ule gí. ꞌBá bị́ be ẹ̃sị̃ꞌbá gí rĩ pi, kộpi nóni tã yị rá. ꞌBá ũdrãꞌbá gí rĩ pi gõkí íngá ídri rú gí. Ãzini ụ́ꞌdụ́kọ́ múké rĩ, ĩ ri ũlũ ꞌbá ngá ãkó rĩ pi ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ꞌBá ma gãꞌbá kuyé rĩ pi, Múngú ri kộpi ní tãkíri sẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yũwánĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi kâ ꞌdeé mụụ́ gí, Yẹ́sụ̃ ní íꞌdózú átázú Yũwánĩ vé tã sĩ ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, “ꞌBá ĩmi ní mụụ́ ndreé ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá rĩ ãꞌdi ꞌi? Ĩmi ị́sụ́kí ꞌbá rĩ ndreé adri sụ̃ ásé mbaápi ãco ũlí ní bị̃ị́ vũgá rĩ tị́nị? ");
INSERT INTO kbo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dõ adri ꞌdíni kuyé, ngá ĩmi ní ndreé rĩ aꞌdi? Ĩmi ị́sụ́kí ágó ãzi su bõngó ũnyĩ be ni rá? Adri ꞌdíni kuyé, ꞌbá adriꞌbée ꞌbãgú vé ãngá rĩ pi bõngó ũnyĩ be ni pi su nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kúru ngá ĩmi ní mụụ́ ndreé rĩ ãꞌdi? Ĩmi mụkí nẹ́bị̃ ri ndreé? Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá ĩmi ní mụụ́ ndreé rĩ ndẽ nẹ́bị̃ ri rá. ");
INSERT INTO kbo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ꞌBá ꞌdĩri Yũwánĩ ꞌi, ĩ ní tã ni sĩí Búkũ Múngú vé rĩ agá rĩ kínĩ: “ ‘Ma mávé ꞌbá áyúãyũ ni pẽ mụzú mí ní drị̃drị̃, ĩri mụ mí ní lẹ́tị údé.’ ");
INSERT INTO kbo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ádarú á lẽ lũú ĩmi ní ꞌdíni, ꞌbá ĩ ní tịị́ vũ drị̃gé nõgó rĩ pi ãsámvú gé, ꞌbá ãzi Yũwánĩ Bãtízĩmũ sẽépi rĩ ndẽépi ãmbũgũ sĩ ni ꞌdãáyo. ꞌBo ꞌbá ĩ ní ĩrivé tã ꞌdụụ́ ꞌbãá mãdãŋá mãlũngã ꞌbụ̃ vé rĩ gé ꞌdãlé rĩ, ndẽ Yũwánĩ ri ãmbũgũ sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Íꞌdózú lókí Yũwánĩ Bãtízĩmũ sẽépi rĩ vé rĩ gé ꞌdãá, cĩmgbá ãndrũ sĩ, ꞌbá rĩ pi rikí ẹ̃ꞌdị́ ꞌdịị́ mãlũngã ꞌbụ̃ vé rĩ ã tã sĩ, ꞌbá ũnjí rĩ pi lẽkí mãlũngã ꞌbụ̃ vé rĩ ẹ́rị́ ĩ ní ũkpõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Búkũ nẹ́bị̃ rĩ pi vé rĩ, ãzini tãị́mbị́ Mósẽ vé rĩ, ũlũ tã ímụ́pi ꞌi ngaápi rĩ cĩmgbá cazú lókí Yũwánĩ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ĩmi ãꞌyĩkí dõ tã má ní átá ꞌdĩri rá, Ẽlíyã ĩ ní ꞌyoó kínĩ ĩri ímụ́ ꞌdĩíꞌdĩ rĩ, ĩri Yũwánĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ꞌBá bị́ be rĩ, ã yị ꞌí ní tã ꞌdĩri. ");
INSERT INTO kbo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mâ ụ̃ꞌbị̃ rí ꞌbá lókí ãndrũ nõri vé rĩ pi ngá íngóni ni sĩ? Kộpi adrikí sụ̃ anjiŋá úríꞌbá jọ̃kọ́nị̃ agá, riꞌbá ĩ ọ̃gụ̃pị́ị zịꞌbá rĩ pi tị́nị, kộpi ri ꞌyo, ");
INSERT INTO kbo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘ꞌBá rikí ĩmi ní ẹ́rị́ coó, ꞌbo ĩmi gãkí úngó tugá sĩ, ꞌbá ngokí ĩmi ní úngó ĩzãngã vé ni, ꞌbo ĩmi gãkí ãá ngogá sĩ.’ ");
INSERT INTO kbo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yũwánĩ riípi bãtízĩmũ sẽépi rĩ ri ꞌi aꞌbií, nya ngá kuyé, ãzini mvụ ngá kuyé, ꞌbo kộpi kínĩ, ‘Índrí ũnjí fi drị̃ ni gé gí.’ ");
INSERT INTO kbo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ꞌBo ma ꞌBá Mvá ꞌi, ma ri ngá nya rá, ãzini ma ri ngá mvụ rá, kộpi kínĩ, ma ri ngá nya ambamba, ãzini ma ri ĩmẽrẽ ambamba, ma ũndĩ ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi vé ni, ãzini ma ũndĩ ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi vé ni. ꞌBá tã ꞌoópi pịrị rĩ, ĩ nị̃ ámá ꞌyozú kínĩ, ádarú ĩri úmĩ be.” ");
INSERT INTO kbo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kúru Yẹ́sụ̃ ní kụ̃rụ́ ꞌí ní tã ãyãzú ãyãyã ꞌozú ꞌa ni agá kárákará rĩ pi vé tã átázú ũkpó ũkpó, ãꞌdiãtãsĩyã ꞌbá kụ̃rụ́ rĩ pi agá rĩ pi gãkí ẹ́sị́ újágá sĩ ĩvé ũnjĩkãnyã agásĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ĩmi ꞌbá adriꞌbá kụ̃rụ́ Kõrãzínĩ vé rĩ agá ꞌdĩꞌbée, ãzini kụ̃rụ́ Bẽtẽsãyídã vé rĩ agá ꞌdĩꞌbée, ĩmi ímụ́ ĩzãngã nya rá! Tã ãyãzú ãyãyã má ní ꞌoó ĩmi ní ꞌdĩꞌbée, mâ ꞌo té dõ kụ̃rụ́ Táyã vé rĩ agá, ãzini kụ̃rụ́ Sĩdónã vé rĩ agá, ꞌbá kụ̃rụ́ rĩ pi agá rĩ pi újákí té ẹ́sị́ ị́nọ́gọ́sị́ Múngú ri ẹ̃ꞌyị̃zú gí. Kộpi té bõngó ị́rị́kọ́ rú ni pi úsú ĩ rụ́ꞌbá gá, kộpi úfúrágú úmvú dã ĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, ụ́ꞌdụ́ ĩ ní ímụ́zú tã lịzú rĩ gé, ĩ ímụ́ ĩmi ĩrĩŋã ꞌbá kụ̃rụ́ Táyã vé rĩ agá, ãzini kụ̃rụ́ Sĩdónã vé rĩ agá rĩ pi vé rĩ ndẽ rá. ");
INSERT INTO kbo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ĩmi ꞌbá adriꞌbá Kãpãrãnãụ́mã agá ꞌdĩꞌbée, ĩmi ụ̃sụ̃kí ĩmi nyo ícó fi ꞌbụ̃ gé rá? Ĩmi ícókí fií ku, ĩmi fi mụ adri ꞌbụ́ ãvũ rĩ pi vé rĩ agá. Tã ãyãzú ãyãyã má ní ꞌoó ĩmi ní ꞌdĩꞌbée, mâ ꞌo té dõ kụ̃rụ́ Sõdómõ vé rĩ agá, ꞌbá Sõdómõ vé rĩ pi té ẹ́sị́ újá rá, kộpivé kụ̃rụ́ ri té adri ũgõgõ. ");
INSERT INTO kbo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Á lẽ ꞌyoó ĩmi ní ꞌdíni, ụ́ꞌdụ́ ĩ ní ímụ́zú tã lịzú rĩ gé, ĩ ímụ́ ĩmi ĩrĩŋã Sõdómõ vé rĩ ndẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sâ ꞌdãri gé, Yẹ́sụ̃ ní Múngú ri zịzú kĩnĩ, “Má Ẹ́tẹ́pị, Úpí mãlũngã ꞌbụ̃ vé rĩ rụụ́pi vũ drị̃gé rĩ be rĩ, õwõꞌdĩfô mí ní tã áda rĩ ũzụ̃ụ́ ꞌbá úmĩ be rĩ pi ní, ãzini ꞌbá tã nị̃ꞌbá ambamba rĩ pi ní rĩ sĩ, ãzini mí ní tã rĩ iꞌdaá ꞌbá tã be mãdã sụ̃ anjiŋá nyíríŋá tã ãkó rĩ pi tị́nị rĩ pi ní rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ẽ, má Ẹ́tẹ́pị, ꞌí lẽ tã rĩ ã nga ꞌi sụ̃ ꞌdĩri tị́nị, ĩri mí ní ãyĩkõ sẽ. ");
INSERT INTO kbo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Má Ẹ́tẹ́pị sẽ ngá rĩ pi ãrẽvú céré kú má drị́gé, ma Mvá rú, ꞌbá ãzi nị̃ ma kuyé, ꞌyéŋá má Ẹ́tẹ́pị nị̃ ma nĩ, ꞌbá ãzi nị̃ má Ẹ́tẹ́pị ri kuyé, ꞌyéŋá ma Mvá rú, á nị̃ má Ẹ́tẹ́pị ri nị̃, ãzini ꞌbá má ní ũpẽé rĩ pi nị̃kí ĩri nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kúru Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ãndẽꞌbá ọgụ ꞌdụngárá sĩ gí ꞌdĩꞌbée, ĩmi ímụ́kí má vúgá nõó, ma sẽ ĩmi ímụ́ uvu rá.” ");
INSERT INTO kbo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ĩmi ꞌdụkí ọgụ má ní ꞌdụụ́ nõri áyu, ĩmi ụ̃nị̃kí tã má ní ꞌoó rĩ, ãꞌdiãtãsĩyã ma ẹ́sị́ be mãdã, ãzini tã be mãdã, ĩmî ẹ́sị́ ri ícó uvungárá ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ọgụ mávé nõri vé ꞌdụngárá ẹ̃njị̃ ku, ꞌdụngárá ni kọ̃wụ́kọ́wụ. ");
INSERT INTO kbo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sâ ꞌdãri gé, Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be rikí ẹlịị́ mụzú ọ́mvụ́ ãnyá vé ni agásĩ ụ́ꞌdụ́ Sãbátã vé rĩ gé, ẹ̃bị́rị́ fụ ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi káyĩ, kộpi ní ãnyá rĩ pi ẽ drị̃ ucezú anyizú cizú. ");
INSERT INTO kbo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fãrụ́sị̃ rĩ pi kâ tã ꞌdĩri ndreé, kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi ícókí té ãnyá rĩ pi ẽ drị̃ uceé ụ́ꞌdụ́ Sãbátã vé rĩ gé ku, ãꞌdiãtãsĩyã tãị́mbị́ Mósẽ vé rĩ ãꞌyĩ ku ĩ ní ẹ̃zị́ ngazú ụ́ꞌdụ́ Sãbátã vé rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi lãkí tã Dãwụ́dị̃ pi ní ꞌoó ívé ꞌbá rĩ pi be sâ ẹ̃bị́rị́ ní kộpi fụzú rĩ gé ꞌdãri kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dãwụ́dị̃ fi Jó Múngú vé rĩ agá ꞌdãá, kộpi nyakí pánga ĩ ní ꞌbãá kuú Múngú vé jó agá rĩ ívé ꞌbá rĩ pi be, pánga ꞌdãri ꞌbãkí ꞌyéŋá kuú atala rĩ pi ní, kộpi ícókí kõdô nyaá ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ĩmi lãkí tãị́mbị́ Mósẽ vé rĩ agá ꞌyozú kínĩ, atala rĩ pi ri ẹ̃zị́ nga Jó Múngú vé rĩ aga ụ́ꞌdụ́ Sãbátã vé rĩ gé ĩndĩ, kộpi tã ãkó ꞌdíni kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Á lẽ lũú ĩmi ní ꞌdíni, ꞌbá Jó Múngú vé rĩ ndẽépi rá rĩ nõgó anigé. ");
INSERT INTO kbo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ĩmi nị̃kí té dõ tã ĩ ní sĩí Búkũ Múngú vé rĩ agá ĩ ní ꞌyoó kínĩ, ‘Á lẽ ĩmî ẹ́sị́ ã adri ĩdríkídri, adri ꞌyozú kínĩ á lẽ ĩmi zãkí má ní rọ̃bọ̃ŋọ̃ yã ꞌdíni kuyé,’ ꞌdĩri vé ífífí rá, ĩmi ícókí té tã lịị́ ꞌbá tã ãkó rĩ pi drị̃gé ũnjí ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ma ꞌBá Mvá ꞌi, ma Úpí ụ́ꞌdụ́ Sãbátã vé rĩ drị̃gé ãmbúgú nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kúru Yẹ́sụ̃ ní ngazú fũzú vũrã ꞌdãri agásĩ, ĩri ní mụzú fizú Jó Múngú ri Zịzú rĩ agá, ");
INSERT INTO kbo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ị́sụ́ ágó ãzi ꞌdãá, drị́ ni ábá kuú ꞌbẽléꞌbéle. Fãrụ́sị̃ rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “Tãị́mbị́ ãꞌyĩ nyo ĩ ícó ꞌbá ídrí ụ́ꞌdụ́ Sãbátã vé rĩ gé rá?” Kộpi zịkí ĩri ꞌdíni, ĩ ị́sụ́kí rí tã ũnjí vú ni gé, ĩ tõkí rí ĩri ãní. ");
INSERT INTO kbo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ãsámvú gé ꞌdĩgé, ꞌbá rĩ vé kãbĩlõ ꞌde dõ ꞌbụ́ agá ụ́ꞌdụ́ Sãbátã vé rĩ gé, ícó kãbĩlõ rĩ ísé ꞌbụ́ agá ꞌdãásĩ ãmvé ku?” ");
INSERT INTO kbo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ꞌBo ꞌbá ndẽ kãbĩlõ ri tã sĩ rá! Tãị́mbị́ ãꞌyĩ rá, ĩ ícó tã múké ꞌo ụ́ꞌdụ́ Sãbátã vé rĩ gé rá. ");
INSERT INTO kbo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kúru Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “Mí ũjũ mî drị́.” Ágó rĩ ní ꞌî drị́ ũjũzú, drị́ ni gõ ícá múké sụ̃ ĩrivé drị́ ãzi rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ꞌBo Fãrụ́sị̃ rĩ pi ní fũzú mụzú ãmvé ꞌdãá, kộpi rikí lẹ́tị ĩ ní lẽzú Yẹ́sụ̃ ri ꞌdịzú drãzú rĩ ndãá. ");
INSERT INTO kbo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ꞌBo Yẹ́sụ̃ nị̃ tã kộpi ní lẽé ꞌoó rĩ rá, ĩri ní fũzú vũrã ꞌdãri agásĩ rá. ꞌBá kárákará ꞌdekí mụụ́ vụ́drị̃ ni gé sĩ, ídrí ꞌbá drã be rĩ pi céré, ");
INSERT INTO kbo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ꞌbo ímbá kộpi kĩnĩ, lẽ kộpi ã lũkí ívé tã ꞌbá ãzi ní ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tã ọ́tụ́ Múngú ní ẹzịị́, nẹ́bị̃ Ĩsáyã ní ꞌyoó rĩ nga ꞌi fũú tị ni gé gí kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ĩri ãtíꞌbá mávé ni, má ĩpẽ ĩri nĩ, á lẽ ĩri lẽlẽ, ma ĩri sĩ ãyĩkõ sĩ, ma sẽ Índrí Uletere rĩ, ĩri ní ũkpõ sẽ, ĩri ímụ́ ꞌyo ꞌbá ãngũ rĩ pi agásĩ rĩ pi ã ꞌokí tã pịrị. ");
INSERT INTO kbo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ícó ãwãá ꞌbá ãzi ní ku, dõku ícó útré ꞌbá ãzi drị̃gé ku, ícó átá ụ́ꞌdụ́kọ́ ãsĩrã rú ni sĩ ꞌbá rĩ pi ãsámvú gé ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ícó ꞌbá ẹ́sị́ be ŋõꞌbá gí rĩ pi ꞌoó ũnjí ku, dõku ĩri ẹ́sị́ múké ꞌbã ꞌbá adriꞌbá ũkpõ ãkó rĩ pi ní, ꞌbo ĩri ímụ́ ꞌbá rĩ pi vé tã lị pịrị. ");
INSERT INTO kbo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sụ́rụ́ ãngũ rĩ pi agásĩ rĩ pi céré ímụ́ ẹ́sị́ ꞌbã drị̃ ni gé.” ");
INSERT INTO kbo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kúru ꞌbá rĩ pi ní ágó ãzi mị be ẹ̃sị̃ị́pi gí, átápi ku ni íjị́zú Yẹ́sụ̃ vúgá nõó, ágó rĩ índrí ũnjí be, Yẹ́sụ̃ ídrí ágó rĩ rá, ágó rĩ ẽ mị gõ ãngũ ndreé rá, gõ kpá átá rá. ");
INSERT INTO kbo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ꞌBá rĩ pi ãrẽvú céré ngakí ãyãá tã ꞌdĩri sĩ ãyãyã, kộpi ní ꞌyozú kínĩ, “Ágó ꞌdĩri adri nyo Dãwụ́dị̃ Mvọ́pị ꞌi kuyé?” ");
INSERT INTO kbo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fãrụ́sị̃ rĩ pi kâ tã ꞌdĩri yịị́, kộpi kínĩ, “Ágó ꞌdĩri ri índrí ũnjí rĩ pi údró ũkpõ Bẽlẽzẽbúlã vé rĩ sĩ, Bẽlẽzẽbúlã ri ãmbúgú índrí ũnjí rĩ pi vé rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ rĩ rá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá mãlũngã rụꞌbá rĩ pi rikí dõ ĩ fụụ́ ĩ drị̃kã sĩ, ĩri sẽ kộpivé mãlũngã ri ábá rá. ꞌBá kụ̃rụ́ agá rĩ pi, dõku ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi rikí dõ ĩ fụụ́ ĩ drị̃kã sĩ, ĩri sẽ kụ̃rụ́ ꞌdĩri, dõku ꞌbẹ̃tị́ ꞌdĩri ábá rá. ");
INSERT INTO kbo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sãtánã dro dõ ꞌí ọ̃gụ̃pị́ị índrí ũnjí rĩ pi, kộpi ri ĩ fụ ĩ drị̃kã sĩ, ĩrivé mãlũngã ri ícó pá tu íngóni? ");
INSERT INTO kbo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma dõ ri índrí ũnjí rĩ pi dro ũkpõ Bẽlẽzẽbúlã vé rĩ sĩ pírí, kúru ꞌbá ĩmivé rĩ pi ri índrí ũnjí rĩ pi dro ãꞌdi vé ũkpõ sĩ? ꞌBá ĩmivé rĩ pi ímụ́ ĩmivé tã lị, kộpi ꞌyo tã ĩmi ni ꞌyoó rĩ adri pịrị ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ꞌBo ma dõ ri índrí ũnjí rĩ pi dro Múngú vé Índrí Uletere rĩ vé ũkpõ sĩ, ĩri lũ ꞌyozú kínĩ mãlũngã Múngú vé rĩ ícá ĩmi ãsámvú gé gí. ");
INSERT INTO kbo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Dõku ꞌbá ri ícó fi ꞌbá ũkpõ be ni vé jó agá mụ ĩrivé ngá ali íngóni íngóni? Drị̃drị̃ ni, ĩri drĩ ꞌbá ũkpõ be ꞌdĩri rụ úmbé, ĩri kúru íbí mụ ngá ĩrivé jó agá rĩ pi ali ndõ. ");
INSERT INTO kbo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ꞌBá rĩ adri dõ má be trụ́ ku, ꞌbá ꞌdĩri mávé ãríꞌbá, ꞌbá rĩ úmú dõ kãbĩlõ rĩ pi adrií má be trụ́ ku, ꞌbá ꞌdĩri kãbĩlõ rĩ pi írérẽ. ");
INSERT INTO kbo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ ꞌo dõ ũnjĩkãnyã, ãzini ide dõ ꞌbá ãzi, ĩ ícó ĩri trũ rá, ꞌbo ꞌbá rĩ ide dõ Índrí Uletere rĩ vé tã, ícókí ĩri trũú ãluŋáni ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma ꞌBá Mvá ꞌi, ꞌbá rĩ átá dõ mávé tã ũnjí, ĩ ícó ĩri trũ rá, ꞌbo ꞌbá rĩ átá dõ Índrí Uletere rĩ vé tã ũnjí, ícókí ĩri trũú ku, íꞌdózú ãndrũ, dõku lókí ímụ́pi drị̃drị̃ ꞌdĩí rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pẹtị rĩ dõ múké, ĩrivé ũꞌa ri adri múké, pẹtị rĩ dõ ũnjí, ĩrivé ũꞌa ri adri ũnjí, ãꞌdiãtãsĩyã ĩ pẹtị rĩ nị̃ ámá ĩrivé ũꞌa sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ĩmi adriꞌbée sụ̃ ị̃nị̃ tị́nị riꞌbá ũnjĩkãnyã ꞌoꞌbá ꞌdĩꞌbée, ĩmi ícó tã múké átá íngóni? Tã ĩmi ní rií átá rĩ, ĩri íbí íngá ĩmî ẹ́sị́ agá. ");
INSERT INTO kbo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ꞌBá adriípi múké rĩ, tã ĩri ní rií átá ĩfũú ꞌí ẹ́sị́ agásĩ rĩ pi céré múké, ꞌbá adriípi ũnjí rĩ, tã ĩri ní rií átá ĩfũú ꞌí ẹ́sị́ agásĩ rĩ pi céré ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá riípi átángá átápi, tã ni ụ̃sụ̃ụ́pi drị̃drị̃ ku rĩ, ụ́ꞌdụ́ ĩ ní tã lịzú rĩ gé, ĩri ímụ́ tã ꞌí ní átá rĩ ũlũ ꞌî tị sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Átángá ĩfũúpi mí tị gé sĩ múké rĩ, ĩri sẽ ĩ mi trũ ãní rá, ꞌbo átángá ĩfũúpi mí tị gé sĩ ũnjí rĩ, ĩri sẽ ĩ tã lị ãní mí drị̃gé.” ");
INSERT INTO kbo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kúru Fãrụ́sị̃ ụrụkọꞌbée, ãzini ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi ã ụrụkọꞌbée be, kộpi ní ꞌyozú ĩri ní kínĩ, “Ímbápi, ꞌbá lẽkí mî ꞌo ꞌbá ní tã ãyãzú ãyãyã ni.” ");
INSERT INTO kbo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ꞌBo Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Úyú ũnjĩkãnyã be riꞌbá ọ̃wụ̃ ꞌbãꞌbée rĩ pi kínĩ mâ ꞌo ĩ ní tã ãyãzú ãyãyã ni! ꞌBo tã ãyãzú ãyãyã má ní lẽé ꞌoó kộpi ní rĩ, ĩri tã nẹ́bị̃ Yónã vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sụ̃ Yónã ní laá caá ị̃ꞌbị́ ãmbúgú rĩ agá ụ̃tụ́ŋá na ị́nị́ŋá na rĩ tị́nị, kúru ma ꞌBá Mvá ꞌi, ma ímụ́ la ca ꞌbụ́ agá ụ̃tụ́ŋá na ị́nị́ŋá na. ");
INSERT INTO kbo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kúru ꞌbá Nĩnéwẽ vé rĩ pi ní ẹ́sị́ újá gí rĩ sĩ, kộpi ímụ́ úyú ãndrũ nõri tõ nĩ, ãzini kộpi tã lị úyú ãndrũ nõri drị̃gé nĩ, ãꞌdiãtãsĩyã kộpi újákí ẹ́sị́ tị Yónã ní sẽé rĩ sĩ gí, ꞌbo ꞌbá Yónã ri ndẽépi ãmbũgũ sĩ rĩ, ĩri nõgónõ. ");
INSERT INTO kbo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ꞌBãgú ũkú rú ãngũ ándrélé rú rĩ gé rĩ úmvúlésĩ ímụ́ pá tu tã lị úyú ãndrũ nõri drị̃gé nĩ, ãꞌdiãtãsĩyã íbí ímụ́ ãngũ rárá rú ni gélésĩ, ímụ́ Sõlõmónã vé úmĩ tã ꞌozú rĩ yịị́, ꞌbo ꞌbá ãzi nõgónõ ndẽ Sõlõmónã rĩ ãmbũgũ sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Índrí ũnjí ĩfũ dõ ꞌbá ãzi agásĩ gí, ĩri ꞌde mụ ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ĩri mụ vũrã uvuzú ni ndã, ꞌbo ị́sụ́ vũrã uvuzú ni ku. ");
INSERT INTO kbo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ĩri kúru ꞌyo, ‘Á lẽ ma újá gõó mụụ́ adrií jó má ní ĩfũzú rĩ agá.’ Ca dõ mụụ́ jó rĩ ã ꞌa ị́sụ́ kálámgbá rú, ꞌbá ãzi ꞌa ni agá ꞌdãáyo, wekí ꞌa ni kú uletere, ");
INSERT INTO kbo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ĩri mụ ꞌî ọ̃gụ̃pị́ị índrí ũnjí be agaꞌbée rá ẹ́zị̂rị̃ ni pi bĩ, kộpi fi mụ adri jó rĩ agá ꞌdãá. ꞌBá ꞌdĩri vé adringárá ũnjĩkãnyã ni gõ drị̃drị̃ ꞌdãri agá rá. Tã ꞌdĩri ímụ́ ꞌi ngá úyú ũnjĩkãnyã be nõꞌbée rụ́ꞌbá gá.” ");
INSERT INTO kbo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yẹ́sụ̃ kã rií átá ꞌbá bị́trị́ká rĩ pi ní, ẹ́ndrẹ́pị pi ẹ́drị́pị́ị be tukí pá kuú ãmvé ꞌdãá, kộpi lẽkí átá ĩri be. ");
INSERT INTO kbo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ꞌBá ãzi ní lũzú Yẹ́sụ̃ ní kĩnĩ, “Mí ẹ́ndrẹ́pị pi mí ẹ́drị́pị́ị be tukí pá kuú ãmvé ꞌdãáꞌdã, kộpi lẽkí átá mí be.” ");
INSERT INTO kbo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yẹ́sụ̃ ní ágó rĩ zịzú kĩnĩ, “Má ẹ́ndrẹ́pị ri ãꞌdi ꞌi? Má ẹ́drị́pị́ị ãꞌdi pi?” ");
INSERT INTO kbo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yẹ́sụ̃ ní drị́ suzú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vú ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mávé ẹ́ndrẹ́pị, ãzini mávé ẹ́drị́pị́ị kộpi adriꞌbá nõ. ");
INSERT INTO kbo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ꞌBá rĩ ꞌdụ dõ tã má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ní lẽé rĩ ngaá rá, ꞌbá ꞌdĩri ĩri adri má ẹ́drị́pị, ĩri adri má ọ́mvụ́pị, ĩri adri má ẹ́ndrẹ́pị.” ");
INSERT INTO kbo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ụ́ꞌdụ́ ãlu ãlu ꞌdãri sĩ, Yẹ́sụ̃ nga fũú jó rĩ agásĩ, mụ adrií yị̃ị́ bãlãlã rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ꞌBá bị́trị́ká trakí ĩ Yẹ́sụ̃ ã gãrã gá sĩ kụ́rụ̃, Yẹ́sụ̃ ní ngazú tụzú kũlúmgba agá, ĩri ní úrízú vũgá, ꞌbá rĩ pi áwíkí pá tuú kuú yị̃ị́ rĩ ã gãrã gá. ");
INSERT INTO kbo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yẹ́sụ̃ ũlũ ꞌbá rĩ pi ní tã kárákará nãpí sĩ kĩnĩ, “Ágó ãzi ọ́mvụ́ be ni mụ úri rií ívé ọ́mvụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ágó rĩ kã úri rĩ rií, úri rĩ pi ụrụkọ uꞌdekí lẹ́tị drị̃gé, ãríŋá rĩ pi ímụ́kí úri uꞌdeꞌbá lẹ́tị drị̃gé rĩ pi teé céré. ");
INSERT INTO kbo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ írã drị̃gé ni agá. Úri rĩ pi ĩfũkí mbẽlẽŋá, nyọ̃ọ́kụ́ rĩ ní adrií nyetele rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ꞌBo ụ̃tụ́ rĩ kã koó gbírílí, úri ĩfũꞌbá rĩ pi ꞌwikí ũdrãá céré, ãꞌdiãtãsĩyã úlá ni pi ní fií vũgá ꞌdãá kuyé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Úri rĩ pi ã ụrụkọ uꞌdekí ũcékúcé ãsámvú gé, ũcékúcé rĩ dụ amuú, ọ̃zụ̃ úri ĩfũꞌbá dụꞌbá rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ múké ni agá, kộpi dụkí ꞌaá mị be gbálígbálí. Drị̃ ni ãlu rĩ gé, ụrụkọ ni ã fí mụ̃dụ̃rụ̃lụ̃ ãlu, ụrụkọ ni pụ̃kụ́ ázíyá, ụrụkọ ni pụ̃kụ́ na. ");
INSERT INTO kbo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ꞌBá bị́ be rĩ, ã yị ꞌí ní tã ꞌdĩri.” ");
INSERT INTO kbo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú ĩri zịzú kínĩ, “Mi ri átá ꞌbá rĩ pi ní nãpí sĩ ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Sẽkí ĩmi ní úmĩ mãlũngã ꞌbụ̃ vé ĩ ní ũzụ̃ụ́ kuú mũdũmũdũ rú rĩ vé tã nị̃zú ámázú rĩ rá, ꞌbo sẽkí úmĩ ꞌdĩri ꞌbá ụrụkọ ní kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ꞌBá tã má ní ímbá rĩ yịị́pi rá rĩ, ĩ ĩri ní tã nị̃ngárá sẽ ãmbúgú, ꞌbo ꞌbá tã mávé rĩ yịị́pi ku rĩ, ĩ ĩrivé tã nị̃ngárá ꞌdụ úmĩ ni gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ma kộpi ní tã rĩ átá nãpí sĩ ãꞌdiãtãsĩyã, “ ‘Kộpi mị ꞌbã tã má ní ꞌoó rĩ ndrezú rá, ꞌbo kộpi ndrekí ku, kộpi bị́ ꞌbã tã rĩ yịzú rá, ꞌbo kộpi yịkí ku, dõku tã rĩ fi kộpi drị̃gé ku.’ ");
INSERT INTO kbo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tã ꞌdĩri nga ꞌi fũú tị ni gé gí, sụ̃ nẹ́bị̃ Ĩsáyã ní átá rĩ tị́nị kĩnĩ, ‘Ĩmi mávé ụ́ꞌdụ́kọ́ yị rá, ꞌbo ĩmi ícókí ífífí ni nị̃ị́ ámá ku, ĩmi tã má ní ꞌoó rĩ ndre rá, ꞌbo ĩmi ícókí tã ni nị̃ị́ ámá ku. ");
INSERT INTO kbo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ꞌBá ꞌdĩꞌbée ẽ ẹ́sị́ tete, kộpi ẽ bị́ yị tã ku, kộpi bĩkí ĩ mị cí, kộpi ã bĩkí té dõ ĩ mị cí ku, kộpi ẽ mị ri té ãngũ ndre rá, kộpi ẽ bị́ ri té tã yị rá, kộpi ẽ ẹ́sị́ ri té tã nị̃ ámá rá, kộpi ã újákí dõ ẹ́sị́ rá, ma té kộpi ídrí rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ꞌBo nóni Múngú sẽ ĩmi ní tãkíri gí, ãꞌdiãtãsĩyã ĩmî mị ri ãngũ ndre rá, ãzini ĩmî bị́ ri tã yị rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, nẹ́bị̃ kárákará, ãzini ꞌbá tã ꞌoꞌbá pịrị kárákará ándúrú rĩ pi ꞌbãkí úvá lẽzú tã ĩmi ní ndreé ꞌdĩri ndrezú, ꞌbo kộpi ndrekí kuyé, ãzini kộpi lẽkí tã ĩmi ní yịị́ ꞌdĩri yịị́, ꞌbo kộpi yịkí tã rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kúru ĩmi yịkí ífífí nãpí ágó úri riípi rĩ vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Úri uꞌdeꞌbá lẹ́tị drị̃gé rĩ vé ífífí, ĩri ꞌbá ụ́ꞌdụ́kọ́ múké mãlũngã vé rĩ ã tã yịꞌbá rá, tã ni ní fií kộpi drị̃gé kuyé rĩ pi. Ãdróko ímụ́ úri rĩ pi uꞌdụụ́ kộpi ẽ ẹ́sị́ agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Úri uꞌdeꞌbá nyọ̃ọ́kụ́ írã drị̃gé rĩ agá rĩ pi, ĩri ꞌbá ụ́ꞌdụ́kọ́ múké rĩ yịꞌbá rá, ãzini ãꞌyĩꞌbá ãyĩkõ sĩ rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kộpi ã úlá ní fií vũgá ꞌdãá kuyé rĩ sĩ, kộpi ícókí adrií lókí be ãco ku. Tã ũkpó ũkpó kãdõ kộpi ị́sụ́, dõku kádõ kộpi ọ̃cụ̃ụ́ ụ́ꞌdụ́kọ́ múké rĩ vé tã sĩ, kộpi gõ ẹ̃ꞌyị̃ngárá rĩ adi ĩ drị́gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Úri uꞌdeꞌbá ũcékúcé ãsámvú gé rĩ pi, ĩri ꞌbá ụ́ꞌdụ́kọ́ múké rĩ yịꞌbá rá rĩ pi. ꞌBo kộpi ní rií tã rụ́ꞌbá nõri vé rĩ ụ̃sụ̃ụ́ áyu rĩ sĩ, ãzini kộpi ní rií ãꞌbú vé tã ꞌdụụ́ ꞌbãá ãmbúgú rĩ sĩ, sẽ úri múké rĩ adri kộpi ẽ ẹ́sị́ agá ku. ");
INSERT INTO kbo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ꞌBo úri uꞌdeꞌbá nyọ̃ọ́kụ́ múké rĩ agá rĩ pi, ĩri ꞌbá ụ́ꞌdụ́kọ́ múké rĩ yịꞌbá rá, tã ni ní fií kộpi drị̃gé múké múké rĩ pi, ꞌbá ꞌdĩꞌbée vé ãnyãngã ri ka, drị̃ ni ãlu rĩ gé, fí ni ri adri mụ̃dụ̃rụ̃lụ̃ ãlu, ụrụkọ ni pụ̃kụ́ ázíyá, ụrụkọ ni pụ̃kụ́ na, ĩ ní úri rĩ saá rĩ vú sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yẹ́sụ̃ gõ kộpi ní nãpí ãzi ũlũú dị̃ị́ kĩnĩ, “Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ꞌbá úri múké ni riípi ọ́mvụ́ agá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ꞌBá rĩ pi kâ céré ꞌdeé ụ́ꞌdụ́ kongárá gá, ĩrivé ãríꞌbá ímụ́ jõótã fí rií ĩrivé ãnyá agá, gõ ꞌdeé mụụ́ ꞌdĩísĩ rá, jõótã rĩ vé fí ĩfũ dụụ́ ãnyá rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ãnyá rĩ kã ĩfũú, jõótã rĩ ní kpá ĩfũzú. ");
INSERT INTO kbo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ãtíꞌbá rĩ pi ní ímụ́zú ọ́mvụ́ ꞌdị́pa rĩ zịzú kínĩ, ‘Ãmbúgú mávé rĩ, úri mí ní rií mívé ọ́mvụ́ agá rĩ adri úri múké ni pi kuyé? Jõótã ĩfũúpi rĩ íbí íngá ngũgá?’ ");
INSERT INTO kbo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ĩri ní újázú kộpi ní kĩnĩ, ‘Ãríꞌbá ꞌo tã ꞌdĩri nĩ.’ “Ãtíꞌbá rĩ pi ní ĩri zịzú kínĩ, ‘Mí ãꞌyĩ ꞌyozú kínĩ, ꞌbâ mụkí jõótã rĩ unjeé ãnyá rĩ agásĩ ãmvé ꞌdíni rá?’ ");
INSERT INTO kbo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ọ́mvụ́ ꞌdị́pa rĩ ní újázú kĩnĩ, ‘Adri ꞌdíni kuyé, ĩmi unjekí dõ jõótã rĩ pi ãnyá rĩ agásĩ ãmvé, ĩmi kpá ãnyá rĩ pi unje ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ĩmi kukí jõótã rĩ ã dụ mụzú ãnyá rĩ be trụ́ cĩmgbá cazú sâ ĩ ní ímụ́zú ãnyá rĩ lịzú rĩ gé. Kádõ ímụ́ ãnyá rĩ lịị́, ma lũ ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi ní, “Drị̃drị̃ ni, ĩmi unjekí jõótã rĩ ãnyá rĩ agásĩ, ĩmi úmbékí, ĩmi zãkí veé ãcí sĩ. Kúru ĩmi ĩkũnãkí ãnyá rĩ íjị́ ímụ́ ꞌbãá mávé ĩrá agá.” ’ ” ");
INSERT INTO kbo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yẹ́sụ̃ átá kpá kộpi ní nãpí ãzi kĩnĩ, “Mãlũngã ꞌbụ̃ vé rĩ vé tã adri sụ̃ marígó ã fí mãdãŋáŋá ĩ ní saá ọ́mvụ́ agá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Marígó rĩ ã fí ã adri dõ kíníkiniŋá drãáãsĩyã, kãdõ dụụ́, ĩri dụ ọ́mvụ́ agá ꞌdãá ícá ãmbúgú. Ãríŋá rĩ pi mụ ĩvé jó sị drị́tị ni pi gé sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yẹ́sụ̃ ũlũ nãpí ãzi dị̃ị́ kĩnĩ, “Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ãkụ́fị́ ũkú rĩ ní íꞌdụ́ dãá íwá ĩ ní uruú gí rĩ agá rĩ tị́nị, ãkụ́fị́ rĩ sẽ íwá rĩ dra kọ̃fụ́tọ̃ be.” ");
INSERT INTO kbo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yẹ́sụ̃ ri tã ꞌdĩꞌbée ũlũú ꞌbá bị́trị́ká rĩ pi ní céré nãpí sĩ. Tã ãzi ĩri ní átá ꞌbá bị́trị́ká rĩ pi ní nãpí sĩ kuyé ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tã Múngú ní átá nẹ́bị̃ rĩ pi ní rĩ fũ tị ni gé gí kĩnĩ: “Ma ĩmi ní tã rĩ ũlũ nãpí sĩ, Tã ĩ ní ũzụ̃ụ́zụ̃ íꞌdózú ĩ ní vũ ri gbingárá gá ꞌdãá rĩ, ma ífífí ni ũlũ ĩmi ní rá.” ");
INSERT INTO kbo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kúru Yẹ́sụ̃ ní fũzú ꞌbá bị́trị́ká rĩ pi ãsámvú gé sĩ, ĩri ní fizú mụzú adrizú jó agá. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú ĩri vúgá, kộpi ní ꞌyozú ĩri ní kínĩ, “Mí ũlũ ꞌbá ní nãpí jõótã dụụ́pi ãnyá agá rĩ vé ífífí.” ");
INSERT INTO kbo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ma ꞌBá Mvá ꞌi, ágó úri múké rĩ riípi rĩ, ĩri ma ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ọ́mvụ́ rĩ, ĩri ꞌbá vũ drị̃gé rĩ pi, úri múké rĩ, ĩri ꞌbá fiꞌbá mãlũngã ꞌbụ̃ vé rĩ agá rĩ pi. Jõótã dụụ́pi ãnyá agá rĩ, ĩri ꞌbá ãdróko vé rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ãríꞌbágú jõótã riípi ãnyá agá rĩ, ĩri ãdróko ꞌi. Ãnyá rĩ vé ĩkũnãngárá, ĩri ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ, ꞌbá ãnyá ĩkũnãꞌbá rĩ pi, mãlãyíkã rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ĩkũnãkí jõótã ãnyá agá rĩ zãá ãcí sĩ, tã ꞌdĩri ímụ́ ꞌi nga ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ma ꞌBá Mvá ꞌi, ma mávé mãlãyíkã rĩ pi ĩpẽ ímụ́ ngá sẽépi ꞌbá rĩ pi ní tã ꞌozú pịrị ku, ãzini ꞌbá rĩ pi sẽépi fiípi ũnjĩkãnyã agá rĩ pi unje mávé mãlũngã agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mãlãyíkã rĩ pi ímụ́ kộpi ꞌdụ úꞌbé ãcí ciípi kú nyãlũ rĩ agá, ꞌdãlé kộpi ímụ́ útré ãcí rĩ vé fingárá kộpi rụ́ꞌbá gá rĩ sĩ, ãzini kộpi ímụ́ sị́kányá ci rá. ");
INSERT INTO kbo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ꞌBo ꞌbá tã ꞌoꞌbá pịrị rĩ pi, kộpi ímụ́ dị̃ ĩ Ẹ́tẹ́pị vé mãlũngã agá ꞌdãá sụ̃ ụ̃tụ́ ní dị̃ị́ rĩ tị́nị. ꞌBá bị́ be rĩ, ã yị ꞌí ní tã ꞌdĩri. ");
INSERT INTO kbo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ngá ãjẽ be ãmbúgú ĩ ní zụ̃ụ́ kuú nyọ̃ọ́kụ́ agá rĩ tị́nị. Ágó rĩ kã ngá ãjẽ be ãmbúgú ꞌdĩri ị́sụ́, gõ mụụ́ zụ̃ụ́ dị̃ị́. Ãyĩkõ fiípi ẹ́sị́ ni agá rĩ sĩ, sẽ ngá rĩ jeé, mụ nyọ̃ọ́kụ́ ꞌdãri jeé ãní. ");
INSERT INTO kbo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ꞌbá riípi mãyãkã ọ́gụ́ꞌbá ọ́gụ́ọ̃gụ̃ ãjẽ be ãmbúgú ĩ ní zịị́ pálĩ rĩ pi ndãá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kã mụụ́ mãyãkã múké ọ́gụ́pi ọ́gụ́ọ̃gụ̃ ãjẽ be ãmbúgú ꞌdĩri ị́sụ́, ụzị ívé ngá ãrẽvú céré, gõ mụụ́ írã ọ́gụ́pi ọ́gụ́ọ̃gụ̃ ꞌdãri jeé ãní. ");
INSERT INTO kbo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Mãlũngã ꞌbụ̃ vé rĩ adri kpá sụ̃ ímbá ĩ ní ꞌbeé yị̃ị́ bãlãlã rĩ agá ị̃ꞌbị́ ọ̃sụ̃kã be ãndíãndí rĩ pi urụzú rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ị̃ꞌbị́ rĩ pi kâ ĩ tõó gaá ímbá rĩ agá ꞌdãá tré, ãgõ ị̃ꞌbị́ ꞌbeꞌbá rĩ pi ísékí ímbá rĩ yị̃ị́ rĩ agásĩ ãmvé nõó. Kộpi ní kúru úrízú vũgá, kộpi ní ị̃ꞌbị́ múké múké rĩ pi ũpẽzú ũꞌbãzú ũvú rĩ pi agá, ꞌbo kộpi úꞌbékí ị̃ꞌbị́ ũnjí rĩ pi ásé agá. ");
INSERT INTO kbo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lókí ụ̃dụ̃ vé rĩ gé, tã rĩ ímụ́ ꞌi nga sụ̃ ꞌdĩri tị́nị. Múngú ri ímụ́ mãlãyíkã rĩ pi ĩpẽ ímụ́ ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi ãsámvú aco ꞌbá tã ꞌoꞌbá pịrị rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kộpi ímụ́ ꞌbá tã ꞌoꞌbá ũnjí rĩ pi úꞌbé ãcí ciípi kú nyãlũ rĩ agá, kộpi ímụ́ ngo ãzini sị́kányá ci ãcí rĩ vé fingárá ĩ rụ́ꞌbá gá rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Tã má ní átá ꞌdĩꞌbée fi nyo ĩmi drị̃gé rá?” Kộpi ní újázú kínĩ, “Ẽ, tã rĩ fi ꞌbá drị̃gé rá.” ");
INSERT INTO kbo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá ãlu ãlu riípi tãị́mbị́ ímbápi rĩ, ímbákí ĩri mãlũngã ꞌbụ̃ vé rĩ vé tã sĩ gí, ꞌbá ꞌdĩri adri sụ̃ jó ꞌdị́pa ívé ngá úꞌdí rĩ íꞌdụ́pi ngá ụ̃kụ rĩ be ívé jó agásĩ ãmvé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yẹ́sụ̃ kã nãpí rĩ ũlũú dẹẹ́, ĩri ní fũzú ãngũ ꞌdãri agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gõ ꞌdeé mụụ́ Nãzẽrétã gá kụ̃rụ́ ĩri ní mbazú rĩ gé, ĩri ní íꞌdózú ꞌbá rĩ pi ímbázú Jó Múngú ri Zịzú rĩ agá ꞌdãá, sẽ ꞌbá rĩ pi ní ãyãngárá, kộpi ní ꞌyozú kínĩ, “Ágó ꞌdĩri ị́sụ́ úmĩ rizú tã ãyãzú ãyãyã ꞌdĩri ꞌozú rĩ íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kộpi ní kpá gõzú zịzú kínĩ, “Ágó ꞌdĩri adri ꞌbá riípi párángi faápi rĩ vé mvá kuyé? Ágó ꞌdĩri vé ẹ́ndrẹ́pị adri Mãríyã ꞌi kuyé? Ĩrivé ẹ́drị́pị́ị adri Yõkóbũ ꞌi, Yõsépã ꞌi, Sị̃mọ́nã ꞌi, ãzini Yụ́dã ꞌi kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ĩrivé ọ́mvụ́pị́ị ꞌdĩꞌbée rikí nyo adrií ꞌbá be trụ́ kuyé? Ágó ꞌdĩri ị́sụ́ tã ꞌdĩꞌbée íngázú íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ꞌBá rĩ pi ã ꞌa vekí ũnjí ũnjí tã ĩri ní ꞌoó ꞌdĩꞌbée sĩ. Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Nẹ́bị̃ rĩ dõ vũrã ãzi gé, ꞌbá rĩ pi ĩri ị̃njị̃ rá, ꞌbo ĩri dõ ꞌbá ívé rĩ pi ãsámvú gé, ị̃njị̃kí ĩri ku.” ");
INSERT INTO kbo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yẹ́sụ̃ ꞌo tã ãyãzú ãyãyã ni ãngũ ꞌdãri agá kárákará kuyé, ãꞌdiãtãsĩyã ꞌbá ãngũ ꞌdãri agá rĩ pi ẹ̃ꞌyị̃ngárá ãkó. ");
INSERT INTO kbo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sâ ꞌdãri gé, ꞌbãgú Ẽródẽ ãngũ Gãlĩláyã vé rĩ rụụ́pi rĩ kã Yẹ́sụ̃ vé tã yịị́, ");
INSERT INTO kbo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ĩri ní ꞌyozú ívé ãtíꞌbá rĩ pi ní kĩnĩ, “ꞌBá ꞌdĩri Yũwánĩ Bãtízĩmũ sẽépi rĩ íngá gõó ídri rú nĩ! Sẽzú ĩri ní rizú tã ãyãzú ãyãyã ꞌdĩꞌbée ꞌozú ꞌdíni ãní.” ");
INSERT INTO kbo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ãꞌdiãtãsĩyã ọ́tụ́ Ẽródẽ rụ Yũwánĩ ri, úmbé ĩri, jị ĩri mụụ́ ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá, ꞌí ẹ́drị́pị Pĩlípũ vé ũkú Ẽrõdíyã ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yũwánĩ ꞌyo ándúrú Ẽródẽ ní kĩnĩ, “Tãị́mbị́ Múngú vé rĩ ãꞌyĩ ku mí ní mívé ẹ́drị́pị vé ũkú jezú mí ní ũkú rú.” ");
INSERT INTO kbo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ẽródẽ lẽ Yũwánĩ ri ꞌdịị́, ꞌbo ri ꞌoó ụ̃rị̃ sĩ ꞌbá rĩ pi sĩ, ãꞌdiãtãsĩyã kộpi ãꞌyĩkí rá ꞌyozú kínĩ, Yũwánĩ ri nẹ́bị̃. ");
INSERT INTO kbo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ụ́ꞌdụ́ ĩ ní Ẽródẽ ri tịzú rĩ kã ícá, údékí ụ̃mụ̃, ụ́ꞌdụ́ ꞌdãri gé, mvá ũkúŋá Ẽrõdíyã vé rĩ tu úngó Ẽródẽ ẹndrẹtị gé, sẽ Ẽródẽ ní ãyĩkõ. ");
INSERT INTO kbo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ẽródẽ sõ ũyõ kĩnĩ, ngá mvá ũkúŋá rĩ ní lẽé rĩ, ꞌi sẽ ĩri ní rá. ");
INSERT INTO kbo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ẽrõdíyã ní ꞌyozú ívé mvá ũkúŋá rĩ ní kĩnĩ, “ꞌÍ ꞌyo Ẽródẽ ní, ã sẽ mí ní Yũwánĩ Bãtízĩmũ sẽépi rĩ ẽ drị̃ sákãnĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tã ꞌdĩri sẽ ꞌbãgú Ẽródẽ ní ĩzãngã, ꞌbo ĩri ní ũyõ sõó ívé ụ̃mụ́ rĩ pi ẹndrẹtị gé gí rĩ sĩ, ĩri ní ꞌyozú kĩnĩ, ngá mvá ũkúŋá rĩ ní lẽé rĩ, ã sẽkí ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ĩri ní ãngáráwá rĩ pi pẽzú mụzú Yũwánĩ ẽ drị̃ lịzú jó ĩ ní ãngũ ũꞌyĩzú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ãngáráwá rĩ pi ní Yũwánĩ ẽ drị̃ íꞌdụ́zú íjị́zú sákãnĩ agá, ímụ́ sẽé mvá ũkú rĩ drị́gé, mvá ũkú rĩ ní jịzú sẽzú ẹ́ndrẹ́pị ní. ");
INSERT INTO kbo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yũwánĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yũwánĩ vé ãvũ ꞌdụzú jịzú mụzú sị̃zú. Vụ́drị̃ ni gé, kộpi ní mụzú tã ni ũlũzú Yẹ́sụ̃ ní. ");
INSERT INTO kbo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yẹ́sụ̃ kã tã Yũwánĩ vé rĩ yịị́, ĩri ní ꞌdezú mụzú kũlúmgba sĩ, mụ adrií vũrã ãzi gé ọ́ꞌdụ́kụ́lẹgúsĩ. ꞌBá bị́trị́ká rĩ pi kâ tã ꞌdĩri yịị́, kộpi ngakí fũú kụ̃rụ́ rĩ pi agásĩ, kộpi ꞌdekí mụụ́ Yẹ́sụ̃ vúgá sĩ pá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yẹ́sụ̃ kã ísị́ kũlúmgba rĩ agásĩ vũgá nõó, kã ꞌbá bị́trị́ká rĩ pi ndreé, sẽ ẹ́sị́ ni ị́sụ́ ĩzãngã ambamba, ĩri ní kúru ꞌdezú rizú ꞌbá drã be rĩ pi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kã mụụ́ adrií ũndréŋá rĩ sĩ, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yẹ́sụ̃ vúgá nõó. Kộpi ní ꞌyozú ĩri ní kínĩ, “Ụ̃tụ́ rĩ ꞌde nóni gí, ãngũ nõri ásé agá, lẽ mî pẽ ꞌbá bị́trị́ká ꞌdĩꞌbée mụụ́ ãnyãngã jeé kụ̃rụ́ mãdã mãdã rĩ pi agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ꞌbá ꞌdĩꞌbée ã mụkí vũrã ãzi gé ku. Ĩmi sẽkí kộpi ní ngá nyanya, kộpi ã nyakí.” ");
INSERT INTO kbo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Ngá ꞌbá vúgá nõgó anigé rĩ ꞌyéŋá pánga tọ̃wụ́ ị̃ꞌbị́ be ị̃rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi íjị́kí má vúgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ĩri ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní, kộpi ã úríkí vũgá ásé drị̃gé ꞌdĩgé. Ĩri ní pánga tọ̃wụ́ ꞌdĩꞌbée íꞌdụ́zụ́ ị̃ꞌbị́ ị̃rị̃ rĩ be, ĩri ní ãngũ ndrezú ꞌbụ̃ gé ꞌdãá, ĩri ní õwõꞌdĩfô sẽzú, ĩri ní pánga rĩ ãndĩzú, ĩri ní sẽzú ị̃ꞌbị́ rĩ be ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi drị́gé, ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní awazú ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ꞌBá rĩ pi ãrẽvú céré nyakí ãnyãngã rĩ ẹ́pị́zú ãní rá, ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ĩkũnãkí ãnyãngã ĩ ní nyaá rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ãgõ ãnyãngã nyaꞌbée rĩ pi vé kãlãfe ri ícó ca élĩfũ tọ̃wụ́ (5,000) rá, kãlãfe ꞌdĩri agá ꞌdĩgé, lãkí ũkú rĩ pi anjiŋá rĩ pi be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tã ꞌdĩri ã vụ́drị̃ gé, koro Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, kộpi ã tụkí gõó kũlúmgba agá ꞌdãá ũzi, kộpi ã zokí yị̃ị́ bãlãlã rĩ mụzú álé ꞌdãá. Vúlé ꞌdãá, ĩri ní ꞌbá rĩ pi ayizú mụzú ĩvé ãngá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kã ꞌbá rĩ pi ayií mụzú gí, ĩri ní tụzú mụzú írã drị̃gé ꞌdãá ọ́ꞌdụ́kụ́lẹgúsĩ, ĩri ní Múngú rĩ zịzú. Ụ̃tụ́ rĩ kã ꞌdeé, ị́sụ́ ĩri ꞌdãlé ọ́ꞌdụ́kụ́lẹgúsĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sâ ꞌdãri gé, kũlúmgba rĩ vụ̃ rárá rú nyọ̃ọ́kụ́ rĩ be. Ũlí ní vịzú ũkpõ be, sẽ yị̃ị́ rĩ úvá ãní ngũyá ngũyá, sẽ kũlúmgba rĩ ícó mụụ́ ãní bã ku. ");
INSERT INTO kbo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ãngũ rĩ kã lẽé ọ́wụ́, Yẹ́sụ̃ ní rizú ímụ́zú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá nõlé yị̃ị́ bãlãlã rĩ drị̃gé sĩ pá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ Yẹ́sụ̃ ri ndreé ĩri ri ímụ́ yị̃ị́ bãlãlã rĩ drị̃gé sĩ pá sĩ, ụ̃rị̃ fi kộpi ẽ ẹ́sị́ agá ambamba. Kộpi ní ꞌyozú kínĩ, “Ngá rĩ índrí.” Ụ̃rị̃ fiípi kộpi ẽ ẹ́sị́ agá rĩ sĩ, kộpi ní ngazú útrézú. ");
INSERT INTO kbo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ꞌBo koro Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmî ẹ́sị́ ã wa ku! ꞌBá rĩ ma ꞌi. Ĩmi ꞌokí ụ̃rị̃ sĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pétẽró ní újázú Yẹ́sụ̃ ní kĩnĩ, “Úpí, ádarú ꞌbá rĩ dõ mi ꞌi, lẽ mî ꞌyo, mâ mụ mí vúgá ꞌdĩí yị̃ị́ rĩ drị̃gé sĩ pá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yẹ́sụ̃ ní ꞌyozú Pétẽró ní kĩnĩ, “Mí ímụ́.” Kúru Pétẽró ní ísị́zú kũlúmgba rĩ agásĩ, ĩri ní ꞌdezú mụzú Yẹ́sụ̃ vúgá ꞌdãá yị̃ị́ rĩ drị̃gé sĩ pá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pétẽró kã nị̃ị́ ámá ꞌyozú kínĩ, ũlí rĩ vị ũkpõ be, gõ rií ꞌoó ụ̃rị̃ sĩ, íꞌdó rií tĩí mụzú yị̃ị́ ã ndụ́gé ꞌdãá, ĩri ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Úpí, ꞌi pa ma!” ");
INSERT INTO kbo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Koro Yẹ́sụ̃ ní ꞌî drị́ suzú Pétẽró ri ísézú ꞌí vúgá nõó, ĩri ní ꞌyozú Pétẽró ní kĩnĩ, “Mívé ẹ̃ꞌyị̃ngárá mãdãŋá, ngá mí ní ꞌozú ụ̃rị̃ sĩ mávé tã ãꞌyĩzú ku rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yẹ́sụ̃ pi kâ tụụ́ Pétẽró be kũlúmgba rĩ agá ꞌdãá, ũlí rĩ ní pá tuzú. ");
INSERT INTO kbo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ꞌdezú ĩri ị̃njị̃zú, kộpi kínĩ, “Ádarú mi Mvá Múngú vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kộpi kâ zoó álé ꞌdãá, kộpi ní ĩfũzú kũlúmgba rĩ agásĩ ãmvé, kộpi ní ꞌdezú mụzú kụ̃rụ́ Gẽnẽsãrétã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ꞌBá kụ̃rụ́ ꞌdãri agá rĩ pi kâ nị̃ị́ ámá ꞌyozú kínĩ, ꞌbá rĩ Yẹ́sụ̃ ꞌi, kộpi ní ụ́ꞌdụ́kọ́ pẽzú mụzú ꞌbá adriꞌbá kụ̃rụ́ ꞌdãri ã gãrã gá sĩ rĩ pi ní. ꞌBá rĩ pi ní ĩvé ꞌbá drã be rĩ pi íjị́zú ímụ́zú Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ꞌBá drã be rĩ pi ní Yẹ́sụ̃ ri mãzú kínĩ, lẽ Yẹ́sụ̃ ã ãꞌyĩ ĩ ní, ĩ úlókí rí ĩrivé bõngó akoóko rĩ ẽ tị. ꞌBá céré ĩrivé bõngó úlóꞌbá rĩ pi vé drã dẹ̃ kộpi ã rụ́ꞌbá gá sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Vụ́drị̃ ni gé, Fãrụ́sị̃ ụrụkọ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be íbíkí ímụ́ Yẹ̃rụ́sãlémã gálésĩ, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, ");
INSERT INTO kbo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ngá mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi ní mẽrẽ ꞌbá ambugu rĩ pi vé rĩ ŋõzú rá rĩ ãꞌdi? Ãꞌdiãtãsĩyã kộpi kádõ rií ngá nyaá, kộpi ũjĩkí ĩ drị́ sụ̃ ꞌbávé mẽrẽ ní lẽé rĩ tị́nị ku!” ");
INSERT INTO kbo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ngá ĩmi ní tãị́mbị́ Múngú ní ꞌyoó rĩ ŋõzú ĩmivé mẽrẽ ã tã sĩ rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Múngú ẹzị kĩnĩ, ‘Lẽ mî ị̃njị̃ mí ẹ́tẹ́pị pi mí ẹ́ndrẹ́pị be ị̃njị̃njị̃.’ ‘ꞌBá átángá átápi ẹ́tẹ́pị ní, dõku ẹ́ndrẹ́pị ní ũnjí rĩ, ã ꞌdịkí ĩri drã ꞌdĩísĩ rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ꞌBo ĩmi kínĩ ꞌbá rĩ ꞌyo dõ ẹ́tẹ́pị ní, dõku ẹ́ndrẹ́pị ní kĩnĩ, ‘Fẽfẽ má ní kõdô lẽé sẽé ĩmi ní rĩ, á sẽ Múngú ní gí,’ ");
INSERT INTO kbo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ꞌdĩri lũ ꞌyozú kínĩ, ꞌbá ꞌdĩri ị̃njị̃ ẹ́tẹ́pị pi ẹ́ndrẹ́pị be kuyé. Ĩmi gãkí ụ́ꞌdụ́kọ́ Múngú vé rĩ sĩ, ĩmivé mẽrẽ ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ĩmi ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị ꞌdĩꞌbée, tã Múngú ní lũú nẹ́bị̃ Ĩsáyã ní átá ĩmi tã sĩ ꞌdĩri ĩri tã áda kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘ꞌBá ꞌdĩꞌbée ri ma íngú tị sĩ kána, ꞌbo kộpi ꞌbãkí ẹ́sị́ má drị̃gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kộpi ma ị̃njị̃ ku kána, tãị́mbị́ kộpi ní rií ímbá rĩ pi, ꞌbá áda ụ̃tị̃ nĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yẹ́sụ̃ ní ꞌbá bị́trị́ká rĩ pi zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌbãkí bị́ tã má ní ꞌyoó rĩ yịzú, tã rĩ ã fi rí ĩmi drị̃gé ꞌdãá múké múké. ");
INSERT INTO kbo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngá nyanya ꞌbá rĩ ní nyaá rĩ íjị́ ũnjĩkãnyã ku, átángá ũnjí ĩfũúpi ꞌbá rĩ tị gé sĩ rĩ, ĩri ũnjĩkãnyã íjị́ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní Yẹ́sụ̃ rĩ zịzú kínĩ, “ꞌÍ nị̃ kuyé ꞌyozú kínĩ, átángá mí ní átá ꞌdĩri sĩ, Fãrụ́sị̃ rĩ pi ã ꞌa ve rá?” ");
INSERT INTO kbo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yẹ́sụ̃ ní újázú kộpi kĩnĩ, “Ngá ãrẽvú céré má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ní saá nĩ kuyé rĩ pi, ĩ ímụ́ kộpi unje céré vũgá. ");
INSERT INTO kbo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lẽ ĩmi ụ̃sụ̃kí Fãrụ́sị̃ ꞌdĩꞌbée vé tã ku, kộpi drị̃koma mị ãkó ni pi. ꞌBá rĩ dõ mị ãkó, ícó ọ́gụ́pị ẽ drị́ rụụ́ sẽé ku, ĩri sẽ kộpi ị̃rị̃trọ́ mụ uꞌde ꞌbụ́ agá.” ");
INSERT INTO kbo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Mí ũlũ ꞌbá ní nãpí mí ní ꞌyoó kínĩ ngá ụrụkọ ĩri ꞌbá ní ũnjĩkãnyã íjị́ ꞌdĩri vé ífífí.” ");
INSERT INTO kbo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi ãsámvú gé ꞌdĩgé, ꞌbá ãzi nyo tã má ní átá nõri nị̃ị́pi kuyé ni anigé? ");
INSERT INTO kbo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ĩmi nị̃kí ámá ꞌyozú kínĩ, ngá ꞌbá ní nyaá fií ꞌbá agá rĩ, ĩri fũ ꞌbá agásĩ ãmvé ꞌdíni kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ꞌBo átángá ĩfũúpi ꞌbá tị gé sĩ rĩ, ĩri íbí íngá ꞌbá ẹ́sị́ agá, ĩri sẽ ꞌbá rĩ tã ‘ãzãvũ rú’ ni ꞌo. ");
INSERT INTO kbo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ãꞌdiãtãsĩyã yị̃kị̂ ũnjí rĩ, ĩri íbí ĩfũ ẹ́sị́ agálésĩ, ĩri sẽ ꞌbá rĩ ãngũ ꞌdị, ĩri la ꞌbá ãzi vé ũkú sĩ, dõku ũkú rĩ la ꞌbá ãzi vé ágó be, ĩri ọ̃wụ̃ ꞌbã, ĩri ngá ụ̃gụ̃, ĩri ũnjõ ụ́lị́, ãzini ĩri ãngũ ꞌyoꞌyo. ");
INSERT INTO kbo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tã ĩ ní ũlãá ꞌdĩꞌbée, ĩri sẽ ꞌbá rĩ adri ‘ãzãvũ rú’ Múngú ẹndrẹtị gé. ꞌBá rĩ nya dõ ngá ị́sụ́ ũjĩ ꞌî drị́ kuyé, sẽ ꞌbá rĩ ꞌo tã ‘ãzãvũ rú’ ni ku.” ");
INSERT INTO kbo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yẹ́sụ̃ nga fũú vũrã ꞌdãri agásĩ, ꞌde mụụ́ ãngũ ãmbúgú Táyã vé rĩ agá, ãzini Sĩdónã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ũkú ãzi Kãnánãzị́, ĩri ní ímụ́zú Yẹ́sụ̃ ri mãzú, rizú ngozú ẹndrẹtị ni gé kĩnĩ, “Úpí, Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã mávé nõri fô, mávé mvá ũkúŋá ꞌdãáꞌdã índrí ũnjí fi drị̃ ni gé, índrí ũnjí rĩ ri ĩri ní ĩzãngã sẽ ambamba.” ");
INSERT INTO kbo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yẹ́sụ̃ zị̃ ꞌî tị átángá ꞌyozú kuyé. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩri mãzú, kộpi kínĩ, “ꞌÍ pẽ ũkú ꞌdĩri mụụ́ ꞌdĩísĩ rá, ĩri ri ngo ímụ́zú ꞌbâ vụ́drị̃ gé sĩ ambamba.” ");
INSERT INTO kbo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩpẽkí ma ímụ́ ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé, kộpi índrékí sụ̃ kãbĩlõ ãvĩꞌbá gí rĩ pi tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ũkú rĩ ní ímụ́zú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Úpí, ꞌí ko mâ ĩzã!” ");
INSERT INTO kbo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yẹ́sụ̃ ní újázú ũkú rĩ ní kĩnĩ, “Adri múké ku ĩ ní ínyá anjiŋá úcézú rĩ pi íꞌdụ́zú sẽzú ũcógú rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ũkú rĩ ní ꞌyozú kĩnĩ, “Úpí, tã mí ní átá rĩ, ĩri tã áda, ꞌbo ũcógú rĩ pi ícó ínyá uꞌdeꞌbá ĩ ẹ́ꞌdị́páa vé mísá drị̃gé sĩ vũgá rĩ nya rá.” ");
INSERT INTO kbo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yẹ́sụ̃ ní újázú kĩnĩ, “Ũkú ꞌdĩri, ẹ̃ꞌyị̃ngárá mívé rĩ ãmbúgú! Tã mí ní zịị́ má tị gé gí rĩ, ĩ ícó sẽ mí ní rá.” Sâ ꞌdãri gé, ũkú rĩ vé mvá ũkúŋá rĩ gõ ícá múké. ");
INSERT INTO kbo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yẹ́sụ̃ ní ngazú fũzú vũrã ꞌdãri agásĩ, ĩri ní ꞌdezú mụzú yị̃ị́ bãlãlã Gãlĩláyã vé rĩ gé ꞌdãá, ĩri ní mụzú yị̃ị́ bãlãlã rĩ ã gãrã gá sĩ. Ĩri ní tụzú mụzú írã drị̃gé, ĩri ní úrízú vũgá. ");
INSERT INTO kbo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ꞌBá bị́trị́ká rĩ pi ní ímụ́zú ĩri vúgá nõó, kộpi íjị́kí ꞌbá pá be ábáꞌbá gí rĩ pi, ꞌbá mị ãkó rĩ pi, ꞌbá ọ̃gọ̃rọ̃vụ̃ rú rĩ pi, ꞌbá átáꞌbée ku rĩ pi, ꞌbá ụrụkọꞌbée be ímụ́ ꞌbãá Yẹ́sụ̃ ẹndrẹtị gé, Yẹ́sụ̃ ídrí kộpi céré rá. ");
INSERT INTO kbo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ꞌBá rĩ pi kâ ndreé ꞌbá ándúrú átáꞌbá ku rĩ pi nóni ri átátã, ꞌbá pá be ábáꞌbá gí rĩ pi ã pá ícá nóni múké gí, ꞌbá adriꞌbá ọ̃gọ̃rọ̃vụ̃ rú ri pi nóni ri ẹ̃cị̃ tu rá, ꞌbá mị be ẹ̃sị̃ꞌbá gí rĩ pi nóni ãngũ ndre rá. Tã ꞌdĩri sẽ kộpi ní ãyãngárá, sẽ kộpi íngúkí Múngú Ĩsẽrélẽ vé rĩ ãní rá. ");
INSERT INTO kbo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ma ĩzãngã sĩ ꞌbá nõꞌbée sĩ, kộpi adrikí má be nõgó caá ụ́ꞌdụ́ be na, ngá ãzi kộpi ní nyaánya ní ꞌdãáyo. Á lẽ kộpi pẽé mụzú nõósĩ ẹ̃bị́rị́ sĩ ku. Ĩri sẽ kộpi ícó ĩdrãkã ẹ̃bị́rị́ sĩ lẹ́tị gé rá.” ");
INSERT INTO kbo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ꞌyozú ĩri ní kínĩ, “Ãngũ nõri rárá rú ásé agá, ꞌbá nõꞌbée kárákará, ꞌbâ ị́sụ́kí rí ãnyãngã caápi kộpi ní rĩ íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Pánga ĩmi vúgá ꞌdĩí ngõpí?” Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “Pánga ꞌbá vúgá nõó ẹ́zị̂rị̃ anigé, ãzini ị̃ꞌbị́ ꞌbá vúgá nõó nyíríŋá ni pi anigé, ꞌbo adri kárákará kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, ꞌbá bị́trị́ká rĩ pi ã úríkí vũgá. ");
INSERT INTO kbo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kúru Yẹ́sụ̃ ní pánga ẹ́zị̂rị̃ ꞌdĩꞌbée íꞌdụ́zú ị̃ꞌbị́ rĩ pi be, ĩri ní õwõꞌdĩfô sẽzú, ĩri ní ũndĩzú, ĩri ní íꞌdụ́zú sẽzú ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi drị́gé, kộpi ní awazú ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ꞌBá rĩ pi céré nyakí ãnyãngã rĩ ẹ́pị́zú ã ní rá. Vụ́drị̃ ni gé, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ĩkũnãkí pánga ĩ ní ũndĩí ĩ ní nyaá rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ꞌBá ãnyãngã rĩ nyaꞌbée rĩ pi vé kãlãfe ca élĩfũ sụ, lãkí ũkú rĩ pi anjiŋá rĩ pi be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yẹ́sụ̃ kã ꞌbá bị́trị́ká rĩ pi ayií mụzú ꞌdĩísĩ gí, ĩri ní tụzú kũlúmgba agá, ĩri ní mụzú vũrã ĩnyiŋá kụ̃rụ́ Mãgãdánã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fãrụ́sị̃ rĩ pi Sãdókẽ rĩ pi be ímụ́kí Yẹ́sụ̃ ri ụ̃ꞌbị̃ị́, kộpi zịkí ĩri kínĩ, ã ꞌo ĩ ní tã ãyãzú ãyãyã ni, ã lũ rí ĩ ní ꞌyozú kínĩ, ũkpõ ĩri ní tã ãyãzú ãyãyã ꞌdĩri ꞌozú rĩ íbí íngá ꞌbụ̃ gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ri ꞌyo, ‘Ũndréŋá rĩ sĩ, ãngũ rĩ ka dõ kú mgbã, ãngũ rĩ adri ule, yị̃ị́gọ́ ꞌdị ku.’ ");
INSERT INTO kbo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ụ̃ꞌbụ́tịŋá rĩ sĩ, ĩmi ri ꞌyo, ‘Ãndrũ sĩ yị̃ị́gọ́ ri ꞌdị rá, ãꞌdiãtãsĩyã ãngũ rĩ ẽ mịlẹ́tị índré ika, kú ị́rị́bị́tị rú.’ Ĩmi nị̃kí ãngũ rĩ vé mịlẹ́tị ã tã ũlũngárá rá, ꞌbo tã ꞌi ngaápi mâ rụ́ꞌbá gá ãndrũ nõri, ĩmi nị̃kí ífífí ni ámá kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Úyú ũnjĩkãnyã ꞌoꞌbá, ẹ̃ꞌyị̃ꞌbá kuyé rĩ pi, kộpi lẽkí ã ꞌokí ĩ ní tã ãyãzú ãyãyã ni, ꞌbo á ꞌo kộpi ní tã ãyãzú ãyãyã ni ku, ma ꞌyéŋá tã ãyãzú ãyãyã Yónã vé rĩ iꞌda kộpi ní áyu.” Kúru Yẹ́sụ̃ ní ꞌdezú mụzú, ĩri ní kộpi kuzú kú ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yẹ́sụ̃ pi kâ zoó yị̃ị́ bãlãlã rĩ agásĩ álé ꞌdãá, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ã tã ãvĩ, jịkí pánga mụzú ĩndĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi adrikí mị be kọwụ ãkụ́fị́ Fãrụ́sị̃ rĩ pi vé Sãdókẽ rĩ pi be rĩ ã tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní átázú ĩ ãsámvú gé sĩ kínĩ, “Yẹ́sụ̃ átá ꞌbá ní tã rĩ ꞌdíni, ãꞌdiãtãsĩyã ꞌbá ní pánga íjị́ ĩndĩ kuyé rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yẹ́sụ̃ nị̃ tã kộpi ní átá ĩ ãsámvú gé sĩ rĩ rá, ĩri ní kộpi zịzú kĩnĩ, “Ĩmi adriꞌbée ẹ̃ꞌyị̃ngárá be mãdã ꞌdĩꞌbée, ngá ĩmi ní rizú átázú ꞌyozú kínĩ pánga ꞌdãáyo rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tã ꞌdĩri fi drĩ ĩmi drị̃gé kuyé? Ĩmi ndrekí pánga tọ̃wụ́ ándúrú ꞌbá élĩfũ tọ̃wụ́ pi ní nyaá tí ꞌdãri kuyé? Ĩmi ĩkũnãkí ándúrú ị̃mbị́tã ni caá ũvú ã ꞌa ngõpí? ");
INSERT INTO kbo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pánga ẹ́zị̂rị̃ ꞌbá élĩfũ sụ pi ní nyaá rĩ, ĩmi ĩkũnãkí ándúrú ị̃mbị́tã ni caá ũvú ã ꞌa ngõpí? ");
INSERT INTO kbo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Má átá tã pánga vé ni ku. Tã má ní átá rĩ vé tã fi ĩmi drị̃gé ku ãsĩ? ꞌBo lẽ ĩmi adrikí mị be kọwụ ãkụ́fị́ Fãrụ́sị̃ rĩ pi vé Sãdókẽ rĩ pi be rĩ ã tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kúru kộpi ní nị̃zú ámázú ꞌyozú kínĩ, tã Yẹ́sụ̃ ní ũlũú ĩ ní ꞌdĩri adri ꞌyozú kínĩ, ãkụ́fị́ ĩ ní pánga áꞌdízú rĩ kuyé, ĩri tã Fãrụ́sị̃ rĩ pi ní rií ímbá ũnjí Sãdókẽ rĩ pi be rĩ vé tã ũlũ. ");
INSERT INTO kbo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yẹ́sụ̃ pi kâ caá ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be kụ̃rụ́ Sĩzérĩyã Pị̃lị̃pọ́yị̃ vé rĩ agá ꞌdãá, ĩri ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú kĩnĩ, “ꞌBá ꞌbá rĩ pi ní ꞌyoó kínĩ ĩri ꞌBá Mvá ꞌi ꞌdĩri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kộpi ní újázú kínĩ, “ꞌBá ụrụkọꞌbée kínĩ, ꞌbá rĩ Yũwánĩ Bãtízĩmũ sẽépi rĩ ꞌi. Ụ̃rụkọꞌbée kínĩ, ꞌbá rĩ Ẽlíyã ꞌi. Ụ̃rụkọꞌbée kínĩ, ꞌbá rĩ Yẽrẽmíyã ꞌi, dõku ꞌbá rĩ nẹ́bị̃ rĩ pi vé ãzi.” ");
INSERT INTO kbo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “ꞌBo ĩmi ꞌyo ma ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sị̃mọ́nã Pétẽró ní újázú kĩnĩ, “Mi Kúrísítõ ꞌi, Múngú adriípi ídri rú rĩ vé Mvá.” ");
INSERT INTO kbo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Sị̃mọ́nã Yónã ã mvá rĩ, tãkíri ã adri mi be, tã ꞌdĩri ꞌbá áda lũ mí ní nĩ kuyé, má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ lũ mí ní tã ꞌdĩri nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ãndrũ á ꞌyo mí ní ꞌdíni, mî rụ́ ri adri Pétẽró ꞌi, ífífí ni írã. Ma ímụ́ mávé kãnísã sị írã ꞌdĩri drị̃gé, drã ícó kãnísã rĩ ndẽé ũkpõ sĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mãlũngã ꞌbụ̃ vé rĩ vé mãfũtá, ma sẽ mí drị́gé, tã mí ní úmbé vũ drị̃gé nõgó gí rĩ, Múngú ri úmbé ꞌbụ̃ gé ꞌdãlé rá. ꞌBo tã mí ní ọyụụ́ vũ drị̃gé nõgó gí rĩ, Múngú rĩ kpá ọyụ ꞌbụ̃ gé ꞌdãlé rá.” ");
INSERT INTO kbo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yẹ́sụ̃ átá ũkpó ũkpó ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ꞌbá ãzi ã lũ ꞌyozú kínĩ, ꞌi Kúrísítõ ꞌi ꞌdíni ku. ");
INSERT INTO kbo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Íꞌdózú lókí ꞌdãri gé, Yẹ́sụ̃ ri ũlũú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ꞌí lẽ mụụ́ Yẹ̃rụ́sãlémã gá. ꞌDãlé ꞌi mụ ĩzãngã nya lẹ́tị be ãndíãndí ꞌbá ambugu rĩ pi drị́gé, atala atala rĩ pi drị̃gé rĩ pi drị́gé, ãzini ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi drị́gé, ĩ ímụ́ ꞌi ꞌdị drã rá. Ụ́ꞌdụ́ na ni gé, ꞌi gõ íngá ídri rú ũzi. ");
INSERT INTO kbo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pétẽró ní Yẹ́sụ̃ ri sezú gãrã gá, ĩri ní ꞌyozú ĩri ní kĩnĩ, “Úpí, lẽ mî átá ꞌdíni ku, tã ꞌdĩri ícó ꞌi ngaá mî rụ́ꞌbá gá sụ̃ụ́ ꞌdĩri tị́nị ku!” ");
INSERT INTO kbo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yẹ́sụ̃ ní ꞌi újázú ãngũ ndrezú Pétẽró vúgá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mi Sãtánã! Mi ri mâ lẹ́tị uga, yị̃kị̂ mívé rĩ, ĩri ꞌbá áda vé ni, yị̃kị̂ ꞌdĩri íbí íngá Múngú vúgálésĩ kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kúru Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “ꞌBá rĩ lẽ dõ mâ pámvú ũbĩí, ã adi ꞌî rụ́ꞌbá, ã ꞌdụ ívé pẹtị alambaku, ã ũbĩ mâ pámvú. ");
INSERT INTO kbo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ꞌBá rĩ ri dõ ívé ídri rụ́ꞌbá nõri vé rĩ ã tã ụ̃sụ̃ụ́ áyu, ĩri ímụ́ ívé ídri ꞌbe ãvĩ ꞌdĩísĩ rá, ꞌbo ꞌbá rĩ adi dõ ꞌi drãá mâ tã sĩ, ĩri ímụ́ ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ꞌBá rĩ ị́sụ́ dõ ngá múké nyọ̃ọ́kụ́ drị̃gé nõgó rĩ pi ãrẽvú céré, ꞌbo ꞌbe dõ ívé ídri ãvĩí rá, ngá múké ĩri ní ị́sụ́ ꞌa ni gé ꞌdĩgé rĩ ãꞌdi? Dõku ngá ꞌbá rĩ ní ícó sẽé ívé ídri ẽ drị̃ jezú rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ma ꞌBá Mvá ꞌi, ma ímụ́ mávé mãlãyíkã rĩ pi be, ma dị̃ pọ̃wụ̃pọ̃wụ̃ sụ̃ má Ẹ́tẹ́pị ní dị̃ị́ pọ̃wụ̃pọ̃wụ̃ rĩ tị́nị, má ímụ́ ꞌbá ãlu ãlu ũfẽ tã ĩri ní ꞌoó rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá ụrụkọ pá tuꞌbá nõꞌbée ícókí drĩ ũdrãá ku, kộpi ꞌBá Mvá vé ímụ́ngárá ívé mãlũngã rụzú rĩ ndre ũgbále.” ");
INSERT INTO kbo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vụ́drị̃ ni kã caá ụ́ꞌdụ́ ázíyá, Yẹ́sụ̃ ní Pétẽró pi jịzú Yõkóbũ be, Yũwánĩ Yõkóbũ ẹ́drị́pị be ꞌí vúgá sĩ. Kộpi ní tụzú mụzú írã drị̃gé ụrụ ꞌdãá, ĩ mụkí rí adrií túngú ĩ drị̃kã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ꞌDãlé Yẹ́sụ̃ újá ꞌi índré ũꞌdũ be túngú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ẹndrẹtị gé. Ẹndrẹtị ni dị̃ ọ́gụ́ imvesírílílí sụ̃ ụ̃tụ́ ní dị̃ị́ rĩ tị́nị, ĩrivé bõngó újá ꞌi dị̃ị́ imvesírílílí, sụ̃ ụ̃tụ́ ní dị̃ị́ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ꞌDãlé Mósẽ pi ní ĩfũzú Ẽlíyã be kộpi ẹndrẹtị gé, Mósẽ pi Ẽlíyã be rikí átá Yẹ́sụ̃ be. ");
INSERT INTO kbo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Úpí, múké ni, lẽ ꞌbâ adrikí nõgó. Mí ãꞌyĩ dõ rá, á lẽ mõrõgó ꞌbeé na, ãlu ni mí ní, ãlu ni Mósẽ ní, ãlu ni Ẽlíyã ní.” ");
INSERT INTO kbo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pétẽró kã rií átá, koro ị́rị́bị́tị imvesírílílí ĩmũlũ kộpi, ụ́ꞌdụ́kọ́ ní íkụ́zú ị́rị́bị́tị agá ꞌdãásĩ kĩnĩ, “Mvá ꞌdĩri mávé ni má ní lẽélẽ rĩ, ma ĩri sĩ ãyĩkõ sĩ. Lẽ ĩmi yịkí tị ni yịyị!” ");
INSERT INTO kbo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ ụ́ꞌdụ́kọ́ ꞌdĩri yịị́, ụ̃rị̃ sĩ, kộpi uꞌdekí ĩ ẹndrẹtị úsú vũgá. ");
INSERT INTO kbo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ꞌBo Yẹ́sụ̃ ní ímụ́zú kộpi úlózú, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi íngákí ụrụ, ĩmi ꞌokí ụ̃rị̃ sĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kộpi kâ ĩ mị ingaá ãngũ ndreé ụrụ ꞌdãá, ꞌbá ãzi ãluŋáni ꞌdãáyo, ꞌbá rĩ ꞌyéŋá Yẹ́sụ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kộpi kâ rií ísị́ ímụ́zú írã drị̃gé ꞌdãásĩ vũgá nõó, Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Tã ĩmi ní ndreé ꞌdĩri, ã lũkí ꞌbá ãzi ní ku, cĩmgbá cazú ĩ ní ꞌBá Mvá ri ingazú drãngárá gálésĩla rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi ri ꞌyo kínĩ, Ẽlíyã ri ímụ́ Kúrísítõ sĩ drị̃drị̃ ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ádarú Ẽlíyã ri ímụ́ drị̃drị̃, ĩri ímụ́ tã rĩ pi ãrẽvú útú ku céré ũrẽ. ");
INSERT INTO kbo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ꞌBo á lẽ ꞌyoó ĩmi ní ꞌdíni, Ẽlíyã ímụ́ ị́nọ́gọ́sị́ gí, ꞌbo ꞌbá rĩ pi ámákí ĩri kuyé, ꞌbá rĩ pi ꞌokí ĩri ũnjí, sụ̃ ĩ ní lẽé rĩ tị́nị. Ma ꞌBá Mvá ꞌi, ma kpá ímụ́ ĩzãngã nya kộpi drị́gé sụ̃ ꞌdĩri tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi nị̃kí ámá rá ꞌyozú kínĩ, ꞌbá Yẹ́sụ̃ ní rií tã ni átá ꞌdĩri Yũwánĩ Bãtízĩmũ sẽépi rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yẹ́sụ̃ pi kâ ĩ újá ĩgõó ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ꞌbá bị́trị́ká rĩ pi vúgá nõó, ágó ãzi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ĩri ní ꞌyozú kĩnĩ, “Úpí, ꞌí ndre mávé mvá ágó rĩ vé ĩzãngã fô, ãjĩꞌbílĩkí ri ĩri úꞌbé, ĩri ri ĩzãngã nya ambamba, ãjĩꞌbílĩkí ri njị̃ị́ ĩri úꞌbé ãcí agá, dõku yị̃ị́ agá. ");
INSERT INTO kbo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Má íjị́ mvá rĩ mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi vúgá, ꞌbo kộpi ídríkí ĩri kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ꞌbá lókí ãndrũ nõri vé ẹ̃ꞌyị̃ngárá ãkó ꞌdĩꞌbée, mâ adri rí ĩmi be vụ̃ụ́ caá lókí be gbã ngõpí? Mâ nya rí ĩzãngã ĩmi tã sĩ caá lókí be gbã ngõpí? Ĩmi íjị́kí mvá ágó rĩ má vúgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yẹ́sụ̃ ní átázú índrí ũnjí rĩ ní ụ́ꞌdụ́kọ́ ũkpó ũkpó ni sĩ, índrí ũnjí rĩ ní fũzú mvá ágó rĩ rụ́ꞌbá gá sĩ. Sâŋá ꞌdãri agá, drã rĩ gõ dẹẹ́ mvá ágó rĩ ã rụ́ꞌbá gá sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Vụ́drị̃ ni gé, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ĩ ínjézú ímụ́zú Yẹ́sụ̃ vúgá nõó kíri, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBá ícókí íni índrí ũnjí rĩ droó fũú ãmvé ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ẹ̃ꞌyị̃ngárá ĩmivé rĩ mãdãŋáŋá. Ádarú á lẽ lũú ĩmi ní ꞌdíni, ĩmi dõ ẹ̃ꞌyị̃ngárá be mãdãŋá anigé sụ̃ marígó ã fí ní adrií mãdãŋá rĩ tị́nị, ĩmi ícó ꞌyo írã ãmbúgú ꞌdĩri ã njị̃ ꞌi vũrã nõri gé sĩ mụụ́ vũrã ãzi gé, írã rĩ ꞌi njị̃ mụzú rá. Tã ãzi mbaápi mbamba ĩmi ní ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Índrí ũnjí ꞌdíni ꞌdĩri, aꞌbikí dõ ngá nyanya ãní ku, ãzini zịkí dõ Múngú ri ku, ícó fũú ku. ");
INSERT INTO kbo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yẹ́sụ̃ pi kâ ĩ úmú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ãngũ Gãlĩláyã vé rĩ gé ꞌdãá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ma ꞌBá Mvá ꞌi, ĩ ímụ́ mâ ũli ꞌbe, ĩ ma sẽ ariꞌba rĩ pi drị́gé. ");
INSERT INTO kbo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kộpi ímụ́ ma ꞌdị drã rá, ụ́ꞌdụ́ na ni gé, ma gõ íngá ídri rú ũzi.” Tã ꞌdĩri sẽ ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩzãngã ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi kâ caá Kãpãrãnãụ́mã gá ꞌdãá, ꞌbá riꞌbá Jó Múngú vé rĩ vé mũfẽngã uꞌdụꞌbá rĩ pi ní ímụ́zú Pétẽró ri zịzú kínĩ, “Ĩmivé ágó riípi ãngũ ímbápi rĩ, ĩri nyo ri Jó Múngú vé rĩ vé mũfẽngã sẽ rá?” ");
INSERT INTO kbo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pétẽró ní újázú kộpi ní kĩnĩ “Ĩri ícó sẽ rá.” Pétẽró kã fií jó agá ꞌdãá, ĩri ní drĩ átázú kuyé rĩ gé, Yẹ́sụ̃ zị ĩri drị̃drị̃ kĩnĩ, “Sị̃mọ́nã, mí ụ̃sụ̃ ngóni? ꞌBãgú vũ drị̃gé nõꞌbée ri mũfẽngã umbe jezú rĩ uꞌdụ ãꞌdi pi drị́gé sĩ? Kộpi ri uꞌdụ ĩvé anjiŋá rĩ pi drị́gé sĩ, dõku kộpi ri uꞌdụ ꞌbá ụrụkọ túngú ni pi drị́gé sĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pétẽró ní újázú kĩnĩ “Kộpi ri mũfẽngã rĩ uꞌdụ ꞌbá ụrụkọ túngú ni pi drị́gé sĩ.” Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “ꞌBãgú rĩ vé anji ãgõ rĩ pi ũfẽkí mũfẽngã rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ꞌBo Yẹ́sụ̃ ní ꞌyozú Pétẽró ní kĩnĩ, “Lẽ ꞌbâ sẽkí ꞌbá mũfẽngã uꞌdụꞌbá ꞌdĩꞌbée ẽ ẹ́sị́ ã ve ꞌbá ní ku, ꞌí mụ yị̃ị́ bãlãlã rĩ agá ꞌdãá, ꞌí ꞌbe mívé jãbádã yị̃ị́ bãlãlã rĩ agá ꞌdãá, ị̃ꞌbị́ mí ní íꞌbé drị̃drị̃ rĩ, ꞌí zị̃ tị ni, mi mũfẽngã ã fí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ni ị́sụ́ tị ni gé ꞌdãá. ꞌÍ ꞌdụ mũfẽngã ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ꞌdĩri, mí ũfẽ Jó Múngú vé rĩ vé mũfẽngã ãní, mí ũfẽ mávé rĩ, ãzini mí ũfẽ mívé rĩ ãní.” ");
INSERT INTO kbo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lókí ꞌdãri gé, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yẹ́sụ̃ ri zịzú kínĩ, “Mãlũngã ꞌbụ̃ vé rĩ agá ꞌdãá, ãꞌdi ri mụ adri ãmbúgú nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yẹ́sụ̃ ní mváŋá mãdãŋá ni zịzú ímụ́zú pá tuzú ĩ ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ újá dõ ẹ́sị́ adrizú sụ̃ mváŋá mãdãŋá nõri vé rĩ tị́nị ku, ícó fií mãlũngã ꞌbụ̃ vé rĩ agá ku. ");
INSERT INTO kbo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kúru ꞌbá rĩ ꞌbã dõ ꞌi kú tã be mãdã sụ̃ mváŋá mãdãŋá nõri tị́nị, ĩri mụ adri ãmbúgú mãlũngã ꞌbụ̃ vé rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ꞌBá rĩ ẹ́ꞌyị́ dõ mváŋá mãdãŋá sụ̃ má andregá nõri tị́nị ni mâ rụ́ sĩ, ꞌbá ꞌdĩri ẹ́ꞌyị́ ma. ");
INSERT INTO kbo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ꞌBo mváŋá mãdãŋá ma ẹ̃ꞌyị̃ị́pi gí nõri, ꞌbá rĩ sẽ dõ ĩri fií ũnjĩkãnyã ꞌoó, múké ni kõdô lẽ ã úmbékí írã ãmbúgú umbe ni gé, ã ꞌbekí ĩri yị̃ị́ tafu agá. ");
INSERT INTO kbo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ꞌBá vũ drị̃gé rĩ pi ímụ́ ĩzãngã ị́sụ́ ambamba, ãꞌdiãtãsĩyã tã vũ drị̃gé nõgó rĩ sẽ ꞌbá rĩ pi ri fi ũnjĩkãnyã ꞌo nĩ! Tã ꞌdĩꞌbée ímụ́ ĩ nga rá, ꞌbo ꞌbá ọ́gụ́pi ri sẽépi ꞌdeépi ũnjĩkãnyã agá rĩ, ĩri ímụ́ ĩzãngã ị́sụ́ ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mívé drị́ ẹ̃ndẹ́pị sẽ dõ mi fií ũnjĩkãnyã ꞌoó nĩ, lẽ mî lị ĩri ꞌbeé ꞌdĩísĩ ãmvé. Mî rụ́ꞌbá ĩgélé ãzi ábá dõ nĩ, ĩri múké, ndẽ mí ní fizú mî rụ́ꞌbá be ngị ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mívé mị drị́ ẹ̃ndẹ́pị gé rĩ sẽ dõ mi fií ũnjĩkãnyã ꞌoó nĩ, lẽ mî nje ĩri ꞌbeé ꞌdĩísĩ ãmvé. Ĩgélé ãzi mî rụ́ꞌbá gá ꞌdĩgé ábá dõ nĩ, ĩri múké, ndẽ mí ní fizú mî rụ́ꞌbá be ngị ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ndrekí múké, lẽ ĩmi ụ̃sụ̃kí ꞌyozú kínĩ anjiŋá nyíríŋá rĩ pi índrékí ĩmi mịlé gá ẹ̃zị́ ãkó ꞌdíni ku. ꞌBo á lẽ lũú ĩmi ní ꞌdíni, kộpivé mãlãyíkã ꞌbụ̃ gé ꞌdãá anigé, kộpi ri njị̃ị́ átá má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ be anjiŋá rĩ pi vé tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma ꞌBá Mvá ꞌi, má ímụ́ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi paá ĩvé ũnjĩkãnyã agásĩ. ");
INSERT INTO kbo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ꞌBá rĩ dõ kãbĩlõ be mụ̃dụ̃rụ̃lụ̃ ãlu, ãlu ni ãvĩ dõ gí, ĩri ꞌo íngóni? Ícó pụ̃kụ́ úrõmĩ drị̃ ni úrõmĩ (99) ꞌdĩꞌbée kuú ánga drị̃gé ꞌdĩgé, ꞌde mụụ́ ãlu ãvĩípi gí ꞌdãri ndãá ku? ");
INSERT INTO kbo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ádarú á ꞌyo ĩmi ní ꞌdíni, ị́sụ́ dõ ívé kãbĩlõ ãlu ãvĩípi rĩ gí, ãyĩkõ ri ĩri fụ aga rá, ndẽ ãyĩkõ ĩri fụụ́pi kãbĩlõ pụ̃kụ́ úrõmĩ drị̃ ni úrõmĩ (99) ãvĩꞌbá kuyé rĩ pi ã tã sĩ rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ĩri kpá adri sụ̃ ꞌdĩri tị́nị, má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ lẽ anji nyíríŋá rĩ pi ã ãvĩkí sụ̃ kãbĩlõ ní ãvĩí rĩ tị́nị ku. ");
INSERT INTO kbo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mí ẹ́drị́pị, dõku mí ọ́mvụ́pị ꞌo dõ mi ũnjí, ꞌí nga mụụ́ vú ni gé ꞌdãá, ꞌí lũ ĩri ní tã ĩri ní ꞌoó mí ní ũnjí rĩ. Lẽ mî lũ tã rĩ gúnyá agá ku. Yị dõ mi rá, ꞌyo dõ ꞌî tị sĩ kĩnĩ, ꞌí ꞌo mi ũnjí, ꞌbá ꞌdĩri gõ ꞌi újá ícá mí ní ẹ́drị́pị, dõku mí ọ́mvụ́pị. ");
INSERT INTO kbo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ꞌBo yị dõ mi kuyé, ꞌí jị ꞌbá ãlu, dõku ꞌbá ị̃rị̃ ụrụkọꞌbée mụzú mí vúgá sĩ ĩndĩ, ãꞌdiãtãsĩyã ‘Tã ãrẽvú céré lẽkí dõ útú ícá pịrị, lẽ ꞌbá ị̃rị̃, dõku ꞌbá na tã rĩ ndreꞌbá ĩ mị sĩ rá ni pi ã adrikí ĩndĩ.’ ");
INSERT INTO kbo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Gã dõ ꞌbá mí ní jịị́ ꞌdĩꞌbée ẽ tị yịgá sĩ, ꞌí jị tã ni mụụ́ ũlũú ꞌbá kãnísã vé rĩ pi ní. Gã dõ ꞌbá kãnísã vé rĩ pi ẽ tị yịgá sĩ, ꞌí ku ã adri kú pãgánõ rú, dõku ã adri kú ꞌbá mũfẽngã umbe jezú rĩ uꞌdụụ́pi ni tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, tã ĩmi ní úmbé vũ drị̃gé nõgó gí rĩ, Múngú ri kpá úmbé ꞌbụ̃ gé ꞌdãlé rá, tã ĩmi ní ọyụụ́ vũ drị̃gé nõgó gí rĩ, Múngú ri kpá ọyụ ꞌbụ̃ gé ꞌdãlé rá. ");
INSERT INTO kbo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Á lẽ ꞌyoó ĩmi ní dị̃ị́, ꞌbá ị̃rị̃ úmúkí dõ ĩ tị tã ãzi zịzú vũ drị̃gé nõgó, má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ kộpivé tã rĩ ãꞌyĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kúru ꞌbá ị̃rị̃, dõku ꞌbá na, úmúkí dõ ĩ mâ rụ́ sĩ, ma adri kộpi ãsámvú gé.” ");
INSERT INTO kbo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kúru Pétẽró ní ímụ́zú Yẹ́sụ̃ ri zịzú kĩnĩ, “Úpí, má ẹ́drị́pị ꞌo dõ ma ũnjí, mâ trũ ĩri caá vú be ngõpí? Mâ trũ ĩri caá vú be ẹ́zị̂rị̃?” ");
INSERT INTO kbo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yẹ́sụ̃ ní újázú Pétẽró ní kĩnĩ, “Adri ꞌyéŋá vú be ẹ́zị̂rị̃ ku, ꞌbo ã adri vú be pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kúru ụ̃ꞌbị̃kí mãlũngã ꞌbụ̃ vé rĩ ꞌbãgú lẽépi mũfẽngã ꞌí ní sẽé ívé ãtíꞌbá rĩ pi ní mẹ̃rị́ rú rĩ ã tã nị̃ị́pi rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ꞌBãgú rĩ kã íꞌdó ívé mũfẽngã rĩ úmú gõó, ĩ ní ágó mũfẽngã ẹ́ꞌyị́pi jũrú ãmbúgú sĩ élĩfũ mụdrị́ rĩ íjị́zú ímụ́zú pá tuzú ꞌbãgú rĩ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ꞌBo ãtíꞌbágú rĩ ní mẹ̃rị́ rĩ ũfẽé kuyé rĩ sĩ, ꞌbãgú rĩ kĩnĩ, ã ụzịkí ĩrivé ngá ãrẽvú céré, ã ụzịkí kpá ĩrivé ũkú anjiŋá rĩ pi be ĩndĩ, ã ũfẽ rí mẹ̃rị́ rĩ ãní. ");
INSERT INTO kbo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kúru ãtíꞌbágú rĩ ní kũmũcí ũtị̃zú ꞌbãgú rĩ ẹndrẹtị gé, ĩri ní ꞌbãgú rĩ mãzú kĩnĩ, ‘ꞌÍ ku má ní sâ, ma ímụ́ mívé mũfẽngã ãrẽvú ũfẽ gõ céré rá!’ ");
INSERT INTO kbo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ꞌBãgú rĩ ndre ĩrivé ĩzãngã, gõ mẹ̃rị́ rĩ vé tã kuú rá, ọyụ ãtíꞌbá rĩ mụzú rá. ");
INSERT INTO kbo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ꞌBo ãtíꞌbágú rĩ kã ꞌdeé mụụ́ gí, kộpi mụkí ĩ ị́sụ́ ọ́gụ́pị ãtíꞌbágú ívé mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ rĩ ẹ́ꞌyị́pi mụ̃dụ̃rụ̃lụ̃ ãlu rĩ be. Ĩri ní ãtíꞌbágú rĩ rụzú, ụ́lẹ́lẹ́ ni ínjízú. Ĩri ní ꞌyozú kĩnĩ, ‘Mí ũfẽ mávé mũfẽngã úꞌdíkírĩŋá nõgó!’ ");
INSERT INTO kbo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ãtíꞌbágú rĩ ní kũmũcí ũtị̃zú ĩri ẹndrẹtị gé, ĩri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, ‘ꞌÍ ku má ní sâ, ma ímụ́ mívé mũfẽngã ũfẽ gõ vúlé rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“ꞌBo ágó rĩ gã ĩrivé tã ãꞌyĩgá sĩ, gõ ĩri ꞌbeé jó ĩ ní rizú ãngũ ũꞌyĩzú rĩ agá, ã mụ adrií ꞌdãlé cĩmgbá ũfẽ dõ ívé mũfẽngã ũgbále gí ká. ");
INSERT INTO kbo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ãtíꞌbá ụrụkọ kâ tã ꞌi ngaápi ꞌdĩri ndreé, kộpi gõkí adrií ĩzãngã sĩ. Kộpi ní mụzú tã ꞌi ngaápi ꞌdĩri ũlũzú ꞌbãgú rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kúru ꞌbãgú rĩ ní ãtíꞌbágú drị̃drị̃ ꞌdãri zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú ĩri ní kĩnĩ, ‘Mi ãtíꞌbá ũnjí, á ku ándúrú mẹ̃rị́ mí ní ꞌdụụ́ rĩ rá, ãꞌdiãtãsĩyã mí ímụ́ ándúrú ngoó má ẹndrẹtị gé rá. ");
INSERT INTO kbo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mi té mí ọ́gụ́pị ãtíꞌbágú rĩ vé ĩzãngã ndre sụ̃ má ní mívé ĩzãngã ndreé rĩ tị́nị.’ ");
INSERT INTO kbo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ꞌBãgú rĩ ẽ ẹ́sị́ ve ũnjí ũnjí, jị ãtíꞌbágú rĩ mụụ́ suú jó ĩ ní rizú ãngũ ũꞌyĩzú rĩ agá, ã mụ adrií ꞌdãlé cĩmgbá ũfẽ dõ ívé mũfẽngã ũgbále gí ká. ");
INSERT INTO kbo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ĩmi trũkí dõ ĩmi ọ̃gụ̃pị́ị Yẹ́sụ̃ ri ẹ̃ꞌyị̃ꞌbá gí rĩ pi ku, má Ẹ́tẹ́pị ꞌbụ̃ gé rĩ trũ kpá ĩmi ku.” ");
INSERT INTO kbo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yẹ́sụ̃ kã tã ꞌdĩꞌbée átá dẹẹ́, ĩri ní fũzú ãngũ Gãlĩláyã vé rĩ agásĩ, ĩri ní mụzú ãngũ Yụ̃dáyã vé rĩ gé yị̃ị́ ãmbúgú dịị́pi dịdị Yárídénĩ vé rĩ ã wọ̃ọ́kọ̃ gá álésĩ. ");
INSERT INTO kbo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ꞌBá bị́trị́ká ꞌdekí mụzú Yẹ́sụ̃ ã vụ́drị̃ gé sĩ, Yẹ́sụ̃ ídrí ꞌbá drã be rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fãrụ́sị̃ ụrụkọꞌbée ímụ́kí vú ni gé, kộpi lẽkí ĩri ụ̃ꞌbị̃ị́. Kộpi ní ĩri zịzú kínĩ, “Tãị́mbị́ ãꞌyĩ nyo ꞌyozú kínĩ, ꞌbá ágó ri ícó ívé ũkú dro tã ã pá ãzi sĩ ꞌdíni rá?” ");
INSERT INTO kbo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi lãkí búkũ Múngú vé rĩ agá ꞌyozú kínĩ, íꞌdóngárá gá ꞌdãá, ‘Múngú gbi ágó pi ũkú be’ ꞌdíni kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Múngú ꞌyo kĩnĩ, ‘Tã ꞌdĩri sĩ, ꞌbá ágó ri ívé ẹ́tẹ́pị ku, ĩri ívé ẹ́ndrẹ́pị ku, kộpi ĩ úmú ũkú ni be, ꞌbá ị̃rị̃ ꞌdĩꞌbée ĩ úmú adri rụ́ꞌbá ãlu.’ ");
INSERT INTO kbo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ꞌBo kộpi acokí ĩ ku, kộpi adri rụ́ꞌbá ãlu. Kúru ꞌbá Múngú ní úmú gí ꞌdĩꞌbée, lẽ ꞌbá ãzi ã aco kộpi ãsámvú ku.” ");
INSERT INTO kbo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fãrụ́sị̃ rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “Mósẽ sẽ tãị́mbị́ kĩnĩ, ‘Ágó ri kọ̃kọ̃bị́ sẽ ũkú ni ní, ĩri drozú ãní rá’ ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Mósẽ ãꞌyĩ ĩmi ní, ĩmi ícó ĩmi ayi ĩmi ũkúpị́ị be rá, ãꞌdiãtãsĩyã ĩmî ẹ́sị́ tete. ꞌBo íꞌdóngárá gá ꞌdãá, tã rĩ adri ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Á lẽ lũú ĩmi ní ꞌdíni, ꞌbá ívé ũkú droópi rá, gõópi ũkú ãzi túngú ni jeépi rĩ, ꞌo ꞌdĩri tã ũnjí ọ̃wụ̃ vé ni, tã ágó ní ícózú ívé ũkú drozú ãní rá rĩ, ũkú rĩ fũ dõ mụụ́ laá ágó ãzi túngú ni be ká.” ");
INSERT INTO kbo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ꞌyozú kínĩ, “Tã ágó pi vé ũkú be rĩ, ĩri dõ ꞌdĩri tị́nị, múké ni, lẽ ꞌbá rĩ ní adrizú ũkú ãkó.” ");
INSERT INTO kbo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá céré ngakí tã ĩmi ní ꞌyoó ꞌdĩri ãꞌyĩí ku, Múngú ꞌbã dõ tã ꞌdĩri ꞌbá rĩ ẹ́sị́ agá nĩ ká, ícó ũkú jeé ku. ");
INSERT INTO kbo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ãgõ ụrụkọꞌbée tịkí kộpi kú ꞌbáŋá rú. Ụrụkọꞌbée ícákí ꞌbáŋá rú ãꞌdiãtãsĩyã íꞌdụ́kí kộpi ágélé gí, ụrụkọꞌbée lẽkí ĩngá adrií ꞌdíni ũkú ãkó, mãlũngã ꞌbụ̃ vé rĩ ã tã sĩ. ꞌBá rĩ lẽ dõ tã ĩ ní ꞌyoó ꞌdĩri ꞌdụụ́ ngaá, ã ꞌdụ ngaá ĩyí.” ");
INSERT INTO kbo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kúru ꞌbá ụrụkọ ní ĩvé anjiŋá nyíríŋá rĩ pi íjị́zú Yẹ́sụ̃ vúgá nõó, Yẹ́sụ̃ ã tị̃ rí drị́ kộpi drị̃gé, ãzini ã zị rí kộpi ní Múngú ri. ꞌBo Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi kínĩ, lẽ ꞌbá rĩ pi ẽ íjị́kí anjiŋá rĩ pi Yẹ́sụ̃ vú nõó ku. ");
INSERT INTO kbo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ã ugakí anjiŋá nyíríŋá rĩ pi ní lẹ́tị ku, ĩmi kukí kộpi ẽ ímụ́kí má vúgá nõó! Ãꞌdiãtãsĩyã mãlũngã ꞌbụ̃ vé rĩ, ĩri adri ꞌbá adriꞌbée sụ̃ anjiŋá nyíríŋá nõꞌbée tị́nị rĩ pi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yẹ́sụ̃ ní drị́ tị̃zú anjiŋá nyíríŋá rĩ pi drị̃gé, vụ́drị̃ ni gé, ĩri ní gõzú ꞌdezú mụzú ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ágó ãzi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, ĩri ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ngá múké má ní ícó ꞌoó, mâ ị́sụ́ rí ídri ꞌdániꞌdáni rĩ ãní rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “Ngá mí ní ma zịzú tã múké ã tã sĩ rĩ ãꞌdi? ꞌBá múké rĩ ꞌyéŋá Múngú ꞌi. ꞌÍ lẽ dõ ídri ꞌdániꞌdáni rĩ ị́sụ́, ngá múké rĩ, lẽ mî ꞌdụ tãị́mbị́ rĩ vé tã ngaá.” ");
INSERT INTO kbo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ágó rĩ ní Yẹ́sụ̃ ri zịzú kĩnĩ, “Tãị́mbị́ ngõri?” Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “ ‘Lẽ mî ꞌdị ꞌbá ku, lẽ mî ꞌbã ọ̃wụ̃ ku, lẽ mî ụ̃gụ̃ ꞌbá ãzi ã ngá ku, lẽ mî úlị́ ũnjõ ꞌbá ãzi drị̃gé ku, ");
INSERT INTO kbo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","lẽ mî ị̃njị̃ mí ẹ́tẹ́pị pi mí ẹ́ndrẹ́pị be ị̃njị̃njị̃.’ ‘Lẽ mî lẽ ꞌbá mî gãrã gá rĩ sụ̃ mí ní mî rụ́ꞌbá lẽé rĩ tị́nị.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ágó rĩ ní újázú Yẹ́sụ̃ ní kĩnĩ, “Á ꞌdụ tãị́mbị́ ꞌdĩꞌbée vé tã ngaá céré rá. Ngá ãzi nyo má ní gõó ꞌoó dị̃ị́ ni anigé?” ");
INSERT INTO kbo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “ꞌÍ lẽ dõ mî adri múké ẹ̃zị́ Múngú vé rĩ ã ngangárá gá, mí ụzị ngá mívé rĩ pi ãrẽvú céré, mí awa mũfẽngã ni ꞌbá ngá ãkó rĩ pi ní, mí ímụ́ mâ pámvú ũbĩí, mi kúru ãꞌbú ꞌbụ̃ gé ꞌdãá rĩ ị́sụ́ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ágó rĩ kã tã ꞌdĩri yịị́, ẹ́sị́ ni ị́sụ́ ĩzãngã, gõ ꞌdeé mụụ́ ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ĩri ãꞌbú be ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá ãꞌbú be rĩ vé fingárá mãlũngã ꞌbụ̃ vé rĩ agá rĩ, tã ni ũkpó ũkpó. ");
INSERT INTO kbo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Á lẽ ꞌyoó ĩmi ní dị̃ị́ kínĩ, kámĩlõ vé fingárá sĩndánĩ ã úlẽ gá sĩ rĩ mbamba, ꞌbo ꞌbá ãꞌbú be rĩ vé fingárá mãlũngã Múngú vé rĩ agá rĩ mba ndẽé rá.” ");
INSERT INTO kbo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ tã ꞌdĩri yịị́, sẽ kộpi ẽ drị̃ ábá ãní rá, kộpi ní zịzú kínĩ, “ꞌBá ĩ ní ícó paá rá rĩ, ĩri adri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yẹ́sụ̃ ní ãngũ ndrezú kộpi vúgá ꞌdãlé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Tã ꞌdĩri mbamba ꞌbá áda ní, ꞌbo tã ãrẽvú céré Múngú ri ícó ꞌo rá.” ");
INSERT INTO kbo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pétẽró ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ ndre drĩ ká! ꞌBá kukí ꞌbávé ngá ãrẽvú céré, ꞌbâ ri mî pámvú ũbĩ! Ngá úmvúlésĩ ꞌbá ní ị́sụ́ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á lẽ lũú ĩmi ní ꞌdíni, ma ꞌBá Mvá ꞌi, sâ má ní ímụ́zú vũ rĩ údézú ícázú úꞌdí, ãzini má ní ímụ́zú úrízú mávé lúpá mãlũngã vé ĩ ní íngúngũ rĩ drị̃gé rĩ kãdõ ícó, ĩmi riꞌbá mâ pámvú ũbĩꞌbá ꞌdĩꞌbée, ĩmi kpá ímụ́ úrí lúpá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi drị̃gé, ĩmi tã lị sụ́rụ́ mụdrị́ drị̃ ni ị̃rị̃ Ĩsẽrélẽ vé rĩ pi drị̃gé nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ꞌBá céré ĩvé jó kuꞌbá, ẹ́drị́pị́ị kuꞌbá, ọ́mvụ́pị́ị kuꞌbá, ẹ́tẹ́pị́ị kuꞌbá, ẹ́ndrẹ́pị́ị kuꞌbá, anjiŋá kuꞌbá, ãzini ĩvé ọ́mvụ́ kuꞌbá mâ tã sĩ rĩ pi, ĩ ímụ́ kộpi ní ꞌbá kộpi ní kuú, ãzini ngá kộpi ní kuú rĩ pi ũfẽ vú be mụ̃dụ̃rụ̃lụ̃ ãlu, ãzini kộpi ímụ́ ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ꞌBá kárákará ꞌyoꞌbá kínĩ, ĩ drị̃drị̃ rĩ pi, kộpi ímụ́ adri ụ̃dụ̃mbị́tã. ꞌBá kárákará adriꞌbá ụ̃dụ̃mbị́tã rĩ pi, kộpi ímụ́ adri drị̃drị̃.” ");
INSERT INTO kbo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Mãlũngã ꞌbụ̃ vé rĩ vé tã adri sụ̃ ágó ọ́mvụ́ ꞌãápi, mụụ́pi ụ̃ꞌbụ́tị ꞌbá ẹ̃zị́ vé ni ndãápi ꞌî ũfẽ rí kộpi ũfẽfẽ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ágó rĩ ãꞌyĩ ꞌbá ẹ̃zị́ vé rĩ pi ũfẽé mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ãlu ĩ ní rizú ãngũ ũfẽzú ãní ụ́ꞌdụ́ ãlu vé rĩ sĩ, ĩri ní kúru kộpi pẽzú mụzú ọ́mvụ́ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kã mụụ́ adrií sâ úrõmĩ ụ̃ꞌbụ́tịŋá vé rĩ gé, ĩri ní ꞌdezú mụzú jọ̃kọ́nị̃ gé, kã mụụ́ caá jọ̃kọ́nị̃ gé ꞌdãá, ị́sụ́ ꞌbá ụrụkọ tukí pá kuú jọ̃kọ́nị̃ agá ꞌdãá, ẹ̃zị́ kộpi ní ngaánga ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ĩri ní ꞌyozú kộpi ní kĩnĩ, ‘Ĩmi mụkí ẹ̃zị́ ngaá mávé ọ́mvụ́ agá, ma ícó ĩmi ũfẽ múké rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kúru kộpi ní ꞌdezú mụzú. “Gõ kpá ꞌdeé mụzú jọ̃kọ́nị̃ gé ꞌdãá dị̃ị́, ụ̃tụ́ mgbímgbi gé ꞌdĩgé, gõ kpá ꞌi ẹndịị́ mụụ́ dị̃ị́ sâ na ũndréŋá vé rĩ gé, átá kpá tã rĩ sụ̃ ꞌí ní átá drị̃drị̃ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sâ tọ̃wụ́ ũndréŋá vé rĩ gé, gõ kpá mụụ́ jọ̃kọ́nị̃ gé ꞌdãá dị̃ị́. Ị́sụ́ kpá ꞌbá ụrụkọ tukí pá kú jọ̃kọ́nị̃ agá ꞌdãá, ẹ̃zị́ kộpi ní ngaánga ni ꞌdãáyo. Ĩri ní kộpi zịzú kĩnĩ, ‘Ngá ĩmi ní pá tuzú kuú jọ̃kọ́nị̃ agá nõgó ụ̃tụ́ njị̃ị́ ẹ̃zị́ ãkó rĩ ãꞌdi?’ ");
INSERT INTO kbo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Kộpi ní újázú ĩri ní kínĩ, ‘ꞌBá ãzi zị ꞌbâ ẹ̃zị́ gé kuyé.’ “Ágó rĩ ní újázú kộpi ní kĩnĩ, ‘Ĩmi mụkí ẹ̃zị́ ngaá mávé ọ́mvụ́ agá.’ ");
INSERT INTO kbo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ụ̃tụ́ rĩ kã mụụ́ ꞌdeé, ọ́mvụ́ ꞌdị́pa ní ágó ĩ ní ꞌbãá drị̃koma rú rĩ zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, ‘ꞌÍ zị ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi, mî ũfẽ kộpivé mũfẽngã, mí íꞌdó ꞌbá ímụ́ꞌbá vúlé rú rĩ pi ũfẽé drị̃drị̃, mí ũfẽ ꞌbá rĩ pi mụzú cĩmgbá cazú ímụ́ꞌbá drị̃drị̃ rĩ pi vúgá.’ ");
INSERT INTO kbo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“ꞌBá ẹ̃zị́ ngaꞌbá rĩ pi kâ ẹ̃zị́ rĩ ngaá caá sâ tọ̃wụ́ ũndréŋá vé rĩ gé gí, ĩ ní ꞌbá ãlu ãlu ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ãlu ni sẽzú ụ́ꞌdụ́ ãlu vé ni. ");
INSERT INTO kbo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ꞌBá ĩ ní ꞌbãá ẹ̃zị́ rĩ ngaá drị̃drị̃ rĩ pi kâ ícá, kộpi ụ̃sụ̃kí déna ĩ mũfẽngã rĩ sẽ ĩ ní aga rá. ꞌBo kộpi ị́sụ́kí céré trõtrõ. ");
INSERT INTO kbo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kộpi kâ mũfẽngã rĩ ị́sụ́, kộpi ꞌdekí rií unuú ọ́mvụ́ ꞌdị́pa ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kộpi ní ꞌyozú kínĩ, ‘ꞌBá ĩ ní íjị́ ẹ̃zị́ ngaá vúlé rú nõꞌbée ngakí ẹ̃zị́ rĩ ꞌyéŋá sâ ãlu, mí ũfẽ ꞌbâ kộpi be céré trõtrõ, ị́sụ́zú ꞌbá ngakí ẹ̃zị́ rĩ ụ̃tụ́ njị̃ị́, ụ̃tụ́ ri ꞌbâ zãá ọ́mvụ́ rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ꞌBo ọ́mvụ́ ꞌdị́pa ní újázú ãlu ni ní kĩnĩ, ‘Mâ ũndĩ, á ꞌo mi ũnjí kuyé. ꞌBá yịkí ꞌbâ mi be, mí ẹ̃ꞌyị̃ rá ꞌyozú kínĩ, ụ́ꞌdụ́ ãlu, mâ ũfẽ mi mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ãlu ni sĩ ꞌdíni kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mí ẹ́ꞌyị́ mívé mũfẽngã, ꞌí ꞌde mụụ́ ꞌbẹ̃tị́. Á lẽ mũfẽngã rĩ sẽé ágó ẹ̃zị́ ngaápi vúlé rú nõri ní gbã má ní sẽé mí ní rĩ pí. ");
INSERT INTO kbo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mũfẽngã mávé rĩ sĩ, ma ícó tã má ní lẽé ꞌoó rĩ ꞌo ãní rá. Ngá mí ní ẹ́sị́ ũnjí ꞌbãzú tã má ní ꞌoó múké ꞌbá rĩ pi ní rĩ sĩ rĩ ãꞌdi?’ ");
INSERT INTO kbo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ꞌBá adriꞌbá ụ̃dụ̃mbị́tã rĩ pi, kộpi ímụ́ adri drị̃drị̃, ꞌbá adriꞌbá drị̃drị̃ rĩ pi, kộpi ímụ́ adri ụ̃dụ̃mbị́tã.” ");
INSERT INTO kbo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yẹ́sụ̃ kã rií ꞌdeé mụụ́ Yẹ̃rụ́sãlémã gá ꞌdãá, ĩri ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ị̃rị̃ rĩ pi zịzú gãrã gá, ĩri ní ꞌyozú kộpi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ꞌBá kãdõ caá Yẹ̃rụ́sãlémã gá ꞌdãá, atala atala rĩ pi drị̃gé rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, kộpi ímụ́ ꞌBá Mvá ã ũli ꞌbe rá. Kộpi ímụ́ ꞌyo, ã ꞌdịkí ĩri drãá ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kộpi ímụ́ ĩri sẽ ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi drị́gé, ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi ímụ́ gụ ĩri sĩ gụgụ, kộpi ĩri ũgbã, kộpi ĩri gbã pẹtị alambaku sị́gé. ꞌBo ụ́ꞌdụ́ na ni gé, ĩri gõ íngá ídri rú drãngárá gálésĩ rá!” ");
INSERT INTO kbo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kúru Zẽbẽdáyõ ũkú ni ní ímụ́zú Yẹ́sụ̃ vúgá ívé anji ãgõ ị̃rị̃ rĩ pi be, ĩri ní kũmũcí ũtị̃zú vũgá, ĩri ní Yẹ́sụ̃ ri zịzú Yẹ́sụ̃ ã ꞌo ꞌí ní tã múké. ");
INSERT INTO kbo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yẹ́sụ̃ ní ĩri zịzú kĩnĩ, “Ngá mí ní lẽé mâ ꞌo mí ní rĩ ãꞌdi?” Ũkú rĩ ní újázú Yẹ́sụ̃ ní kĩnĩ, “Mí kãdõ mívé mãlũngã rụụ́, lẽ mî ꞌbã mávé anji ãgõ ị̃rị̃ ꞌdĩꞌbée, ãlu rĩ ã úrí mívé drị́ ẹ̃ndẹ́pị gé, ãzi rĩ ã úrí mívé drị́ ị̃jị́ gé.” ");
INSERT INTO kbo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi nị̃kí tã zịbe kuyé, ĩmi nyo ícó ãꞌyĩ ĩzãngã nya sụ̃ má ní nyaá rĩ tị́nị rá?” Kộpi ní újázú kínĩ, “ꞌBâ ícó rá.” ");
INSERT INTO kbo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ímụ́ ĩzãngã nya sụ̃ má ní nyaá rĩ tị́nị, ꞌbo má ícó ĩmi ní vũrã sẽé mụzú úrízú mâ drị́ ẹ̃ndẹ́pị gé, dõku mâ drị́ ị̃jị́ gé ꞌdíni ku, má Ẹ́tẹ́pị údé vũrã rĩ pi ꞌbá ꞌí ní ũpẽé kuú ị́nọ́gọ́sị́ gí rĩ pi ní, kộpi ã mụkí rí adrií vũrã rĩ pi agá.” ");
INSERT INTO kbo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá mụdrị́ rĩ pi kâ tã ꞌdĩri yịị́, kộpi ẽ ẹ́sị́ ve ꞌbá ị̃rị̃ adriꞌbée ẹ́drị́pị́ị rú ꞌdĩꞌbée ní ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ꞌBo Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú ímụ́zú ꞌí vúgá nõlé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi nị̃kí rá, ꞌbãgú ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi vé rĩ pi ri ĩvé ũkpõ iꞌda rizú tã ẹ̃njị̃ẹ̃njị̃ ꞌbãzú ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi drị̃gé, kộpivé ũgalaku rĩ pi kpá ri tã ẹ̃njị̃ꞌbá ẹ̃njị̃ẹ̃njị̃ ni pi ũꞌbã ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ĩmi ãsámvú gé ꞌdĩgé, lẽ tã rĩ ã adri sụ̃ ꞌdĩri tị́nị ku. Ĩmi ãsámvú gé ꞌdĩgé, ꞌbá rĩ lẽ dõ adrií ꞌbá ãmbúgú rú, lẽ ã ꞌbã ꞌi adrií ãtíꞌbá ĩmivé ni. ");
INSERT INTO kbo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ꞌBá rĩ lẽ dõ adrií ãmbúgú ꞌbá rĩ pi drị̃gé sĩ céré, lẽ ã ꞌbã ꞌi adrií tụ́gẹ̃rị̃ ĩmivé ni. ");
INSERT INTO kbo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ma ꞌBá Mvá ꞌi, má ímụ́ adrií ꞌyozú kínĩ, ꞌbá rĩ pi ẽ ímụ́kí rí má ní ẹ̃zị́ ngaá yã ꞌdíni ku, má ímụ́ ẹ̃zị́ ngaá ꞌbá rĩ pi ẽ ĩzã kozú, má adi mávé ídri ꞌbá kárákará pi ẽ drị̃ jezú ãní.” ");
INSERT INTO kbo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi kâ rií fũú mụzú Yẹ́rị̃kọ̃ agásĩ, ꞌbá bị́trị́ká ꞌdekí mụụ́ kộpi ã vụ́drị̃ gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ꞌBá ị̃rị̃ mị be ẹ̃sị̃ꞌbá gí ni pi úríkí kuú lẹ́tị ã gãrã gá. Kộpi kâ yịị́ Yẹ́sụ̃ ri aga mụzú ĩ gãrã gá sĩ, kộpi ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Úpí, Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã ꞌbávé rĩ fô!” ");
INSERT INTO kbo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ꞌBá bị́trị́ká rĩ pi trekí kộpi drị̃gé kínĩ, “Ĩmi újíkí kíri.” ꞌBo kộpi gõkí treé ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Úpí, Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã ꞌbávé rĩ fô!” ");
INSERT INTO kbo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yẹ́sụ̃ ní pá tuzú, ĩri ní kộpi zịzú kĩnĩ, “ꞌÍ lẽkí mâ ꞌo ĩmi ní ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Úpí, ꞌbá lẽkí mî zị̃ ꞌbâ mị, ꞌbâ ndrekí rí ãngũ fô.” ");
INSERT INTO kbo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yẹ́sụ̃ ẽ ẹ́sị́ ị́sụ́ ĩzãngã kộpi sĩ, ĩri ní kộpi ẽ mị úlózú. Koro kộpi ẽ mị ní ꞌi zịzú ãngũ ndrezú, kộpi ní ꞌdezú mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi kâ rií mụụ́ Yẹ̃rụ́sãlémã gá ꞌdãá, drị̃drị̃ ni, kộpi cakí kụ̃rụ́ mãdãŋá Bẽtẽfágẽ vé rĩ gé, Írã Õlívẽ vé rĩ drị̃gé, kụ̃rụ́ rĩ ĩnyiŋá Yẹ̃rụ́sãlémã ã jẽlé gá. Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi pẽzú ị̃rị̃, ");
INSERT INTO kbo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí kụ̃rụ́ mãdãŋá ĩmî drị̃lé gá ꞌdãri agá, ĩmi ca mụ dõngí ị́sụ́ ꞌyĩkí kuú ꞌdãlé mvọ́pị be trụ́, ĩmi ĩtrũkí kộpi íjị́ má vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ꞌBá ãzi zị dõ ĩmi, ngá ĩmi ní rií ꞌoó ꞌdíni rĩ ãꞌdi, ĩmi ꞌyokí ĩri ní kínĩ, ‘Úpí lẽ kộpi nĩ,’ ꞌbá ꞌdãri ícó dõngí rĩ pi ĩpẽ ímụ́zú rá.” ");
INSERT INTO kbo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tã ꞌdĩri nga ꞌi ꞌdíni, tã nẹ́bị̃ ní ꞌyoó rĩ ã nga rí ꞌi fũú tị́nị gé bẽnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ꞌÍ lũ ꞌbá Sĩónã vé rĩ pi ní kínĩ, ‘Ĩmi ndrekí drĩ ká, ĩmivé ꞌbãgú ri ímụ́ ĩmi vúgá ꞌdĩíꞌdĩ, ĩri ꞌbá tã be mãdã ni, ĩri ri ínjú ímụ́zú dõngí sĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ꞌdụkí tã rĩ ngaá sụ̃ Yẹ́sụ̃ ní lũú ĩ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kộpi íjị́kí dõngí rĩ pi mvọ́pị be ị̃rị̃trọ́, kộpi ũtrũkí ĩvé bõngó akoó rụ̃kụ̃ rĩ pi ũꞌbãá dõngí rĩ pi ã úgóró gá, Yẹ́sụ̃ úrí bõngó rĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ꞌBá kárákará ũtrũkí ĩvé bõngó akoó rụ̃kụ̃ rĩ pi ũꞌbãá lẹ́tị drị̃gé, ụrụkọꞌbée mụkí ị̃bị́bị́ vãá ũꞌbãá mụzú lẹ́tị rĩ drị̃gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ꞌBá bị́trị́ká ꞌdeꞌbá Yẹ́sụ̃ ẽ ẹndrẹtị gé drị̃drị̃ rĩ pi, ꞌdeꞌbá ĩri ã vụ́drị̃ gé rĩ pi be, kộpi ní rizú ọ́ꞌụ́zú mụzú kínĩ, “Hõsánã Mvá Dãwụ́dị̃ vé rĩ!” “Tãkíri ã adri ꞌbá ímụ́pi Úpí ã rụ́ sĩ rĩ drị̃gé!” “Ẽ íngúkí Múngú ụrụgégé ꞌbụ̃ gé rĩ!” ");
INSERT INTO kbo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yẹ́sụ̃ ka fií caá Yẹ̃rụ́sãlémã gá ꞌdãá, sẽ ꞌbá kụ̃rụ́ agá rĩ pi ní céré ãyãngárá. Kộpi ní zịzú kínĩ, “ꞌBá ꞌdĩri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ꞌBá bị́trị́ká rĩ pi ní újázú kínĩ, “Ágó ꞌdĩri Yẹ́sụ̃ ꞌi, ĩri nẹ́bị̃, íbí íngá Nãzẽrétã gálésĩ, ãngũ Gãlĩláyã vé rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yẹ́sụ̃ ní fizú Jó Múngú vé rĩ ã bóró gá ꞌdãá, údró ꞌbá riꞌbá ngá jeꞌbá, ãzini ꞌbá riꞌbá ngá ụzịꞌbá rĩ pi céré. Uze mísá ꞌbá riꞌbá mũfẽngã ufuꞌbá, ãzini ãmámũ ụzịꞌbá rĩ pi vé rĩ céré uꞌdeé ụ̃lị̃ rú vũgá. ");
INSERT INTO kbo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Múngú ꞌyo ívé búkũ agá kĩnĩ, ‘Jó mávé rĩ ĩ zị jó rizú ma zịzú ni,’ ꞌbo ĩmi újákí jó rĩ ícá vũrã ụ̃gụ́ꞌbá rĩ pi ní rizú adrizú ni.” ");
INSERT INTO kbo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ꞌBá mị be ẹ̃sị̃ꞌbá gí rĩ pi, ꞌbá pá be ábáꞌbá gí rĩ pi be, kộpi ní ímụ́zú Yẹ́sụ̃ vúgá Jó Múngú vé rĩ ã bóró gá nõó, ĩri ní kộpi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ꞌBo atala atala rĩ pi drị̃gé rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, kộpi kâ tã ãyãzú ãyãyã Yẹ́sụ̃ ní ꞌoó ꞌdĩri ndreé, ãzini kộpi kâ yịị́ anjiŋá rĩ pi ri útré Jó Múngú vé rĩ ã bóró gá ꞌdãá, “Hõsánã Mvá Dãwụ́dị̃ vé rĩ,” tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri sĩ, sẽ kộpi ã ꞌa ve ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌÍ yị nyo tã anjiŋá rĩ pi ní rií átá ꞌdĩri rá?” Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ẽ, ĩmi lãkí Búkũ Múngú vé rĩ agá ꞌyozú kínĩ, “ ‘Anjiŋá ambugu rĩ pi nyíríŋá rĩ pi be ímụ́ úngó ãyĩkõ vé ni ngo ꞌdíni’ kuyé?” ");
INSERT INTO kbo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kúru Yẹ́sụ̃ ní kộpi kuzú, ĩri ní ngazú mụzú kụ̃rụ́ Bẽtẽníyã vé rĩ gé, adri ꞌdãlé ị́nị́ be rã. ");
INSERT INTO kbo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kã mụụ́ adrií ụ̃ꞌbụ́tị, Yẹ́sụ̃ ní ꞌi újázú gõzú kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agá ꞌdãá, ẹ̃bị́rị́ fụ ĩri káyĩ. ");
INSERT INTO kbo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yẹ́sụ̃ kã rií ꞌdeé mụzú lẹ́tị gé sĩ, ĩri ní pẹtị ĩ ní zịị́ fị́gị̃ rĩ ndrezú, ĩri ní ꞌi útrúzú ĩnyiŋáŋá pẹtị rĩ ã gãrã gá ꞌdãá, ị́sụ́ pẹtị rĩ ꞌa ãluŋáni kuyé, ꞌyéŋá bị́ ni amu kú nĩ. Ĩri ní ꞌyozú pẹtị rĩ ní kĩnĩ, “Mî gõ ꞌaá dị̃ị́ ãluŋáni ku!” Koro pẹtị rĩ ní ꞌwizú. ");
INSERT INTO kbo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ pẹtị rĩ ndreé, sẽ kộpi ní ãyãngárá. Kộpi ní zịzú kínĩ, “Pẹtị nõri ꞌwi mbẽlẽŋá ngóni ngóni?” ");
INSERT INTO kbo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á ꞌyo ĩmi ní ꞌdíni, ĩmi dõ ẹ̃ꞌyị̃ngárá be, ãzini ĩmivé yị̃kị̂ awa dõ ꞌi ị̃rị̃ kuyé, ĩmi ícó tã má ní ꞌoó pẹtị ꞌdĩri ã rụ́ꞌbá gá rĩ ꞌo rá, ĩmi ícó tã ụrụkọꞌbée ꞌo rá. Ĩmi dõ ẹ̃ꞌyị̃ngárá be, ĩmi ícó ꞌyo írã ꞌdĩri ní, ‘ꞌÍ njị̃ mi ngaá mụụ́ ꞌdeé yị̃ị́ tafu rĩ agá ꞌdãá,’ ĩri ícó ꞌi nga rá. ");
INSERT INTO kbo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ĩmi dõ ẹ̃ꞌyị̃ngárá be, ngá ĩmi ní zịị́ Múngú vúgá rĩ, ĩmi ícó ị́sụ́ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yẹ́sụ̃ kã fií mụzú Jó Múngú vé rĩ ã bóró gá ꞌdãá, kã íꞌdó ꞌbá rĩ pi ímbá, atala atala rĩ pi drị̃gé rĩ pi, drị̃koma rĩ pi be, kộpi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní ĩri zịzú kínĩ, “Mí ị́sụ́ ũkpõ mí ní rizú tã ꞌdĩꞌbée ꞌozú rĩ ãꞌdi vúgá? Ãꞌdi sẽ mí ní ũkpõ rizú tã ꞌdĩꞌbée ꞌozú rĩ nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Á lẽ ĩmi zịị́ tã ãlu sĩ, ĩmi újákí dõ má ní gí, ma ícó ĩmi ní ũkpõ má ní rizú tã ꞌdĩꞌbée ꞌozú rĩ lũ rá. ");
INSERT INTO kbo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ũkpõ Yũwánĩ ní bãtízĩmũ sẽzú rĩ íbí íngá ꞌbụ̃ gélésĩ, dõku íbí íngá ꞌbá áda vúgá?” Kộpi ní rizú tã ꞌdĩri átázú ĩ ãsámvú gé sĩ kínĩ, “ꞌBá ꞌyokí dõ, ‘Ũkpõ ꞌdĩri íngá ꞌbụ̃ gélésĩ,’ ĩri ꞌbâ zị, ‘Ĩmi ẹ̃ꞌyị̃kí dí ĩri kuyé ã sĩ?’ ");
INSERT INTO kbo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ꞌBo ꞌbá ꞌyokí dõ, ‘Ũkpõ ꞌdĩri íngá ꞌbá áda vúgálésĩ,’ ꞌbá rĩ pi íngá ꞌbá drị̃gé ũnjí ũnjí, ãꞌdiãtãsĩyã ꞌbá ꞌdĩꞌbée ụ̃sụ̃kí kínĩ, Yũwánĩ ri nẹ́bị̃.” ");
INSERT INTO kbo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kúru kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “ꞌBá nị̃kí kuyé.” Kúru Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Má ícó ũkpõ má ní tã ꞌozú rĩ lũú ĩmi ní ku.” ");
INSERT INTO kbo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Á lẽ ĩmi ní úꞌdógúꞌdógú ãnji ãgõ ị̃rị̃ pi vé ni ũlũú, ĩmi kúru tã ĩmi ní ụ̃sụ̃ụ́ rĩ lũ má ní. Ágó ãzi anji ãgõ be ị̃rị̃, ágó ri ꞌde mụụ́ ívé mvá kãyú rĩ vúgá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, ‘Mâ mvá rĩ, ãndrũ sĩ lẽ mî mụ ẹ̃zị́ ngaá ọ́mvụ́ agá.’ ");
INSERT INTO kbo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Mvá rĩ ní újázú ẹ́tẹ́pị ní kĩnĩ, ‘Á mụ ku!’ ꞌBo gõ ꞌî úmĩ újá, ꞌdeé mụụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ẹ́tẹ́pị gõ ꞌdeé mụụ́ ívé mvá ãzi rĩ vúgá, ꞌyo kpá ĩri ní tã rĩ sụ̃ ĩri ní ꞌyoó mvá kãyú rĩ ní rĩ tị́nị. Mvá rĩ újá ẹ́tẹ́pị ní kĩnĩ, ‘Bãbá, ma mụ rá,’ ꞌbo mụ kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Anji ị̃rị̃ ꞌdĩꞌbée ãsámvú gé, mvá ẹ́tẹ́pị vé tã ꞌdụụ́pi ngaápi rá rĩ, ĩri mvá ngõri?” Kộpi ní újázú kínĩ, “Mvá kãyú rĩ.” Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi ụrụkọ, ũkú ụrụkọ ọ̃wụ́ rú riꞌbá ĩ rụ́ꞌbá ụzịꞌbá rĩ pi be, kộpi fi mãlũngã Múngú vé rĩ agá ꞌdãá ĩmi sĩ drị̃drị̃. ");
INSERT INTO kbo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yũwánĩ ímụ́ ĩmi ní lẹ́tị pịrị Múngú vé rĩ ũlũú, ꞌbo ĩmi ẹ̃ꞌyị̃kí ĩri kuyé, ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi, ãzini ũkú ọ̃wụ́ rú riꞌbá ĩ rụ́ꞌbá ụzịꞌbá rĩ pi ẹ̃ꞌyị̃kí ĩri rá. Ĩmi ndrekí drĩ ká, ꞌbá mũfẽngã uꞌdụꞌbá rĩ pi, ãzini ũkú ọ̃wụ́ rú ĩ rụ́ꞌbá ụzịꞌbá rĩ pi újákí ẹ́sị́ ụ́ꞌdụ́kọ́ ĩri ní ũlũú rĩ sĩ rá, ꞌbo ĩmi újákí ẹ́sị́ ĩri ẹ̃ꞌyị̃zú kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yẹ́sụ̃ ní ꞌyozú atala atala rĩ pi drị̃gé rĩ pi ní, ãzini Fãrụ́sị̃ rĩ pi ní kĩnĩ, “Nãpí ãzi ꞌdĩ, ĩmi yịkí drĩ ká, ágó ãzi ꞌã ọ́mvụ́, sa pẹtị vị́nyọ̃ vé rĩ pi ọ́mvụ́ rĩ agá, sị ãbi ọ́mvụ́ rĩ ã gãrã gá sĩ kụ́rụ̃, ga ꞌbụ́ rizú ũꞌa rĩ zozú vị́nyọ̃ rú. Sị lágáráka ụrụ ꞌdãá rizú ọ́mvụ́ rĩ ũtẽzú ãní. Kúru ĩri ní ꞌbá ꞌbãzú rizú ẹ̃zị́ ngazú ívé ọ́mvụ́ rĩ agá, ĩri ní ꞌdezú mụzú ãngũ ãzi gé. ");
INSERT INTO kbo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lókí ĩ ní vị́nyọ̃ ã ũꞌa ĩkũnãzú rĩ kã ícó, ĩri ní ívé ãtíꞌbá rĩ pi pẽzú mụzú ívé vị́nyọ̃ ã vúgú ĩ ní ĩkũnãá rĩ íjị́zú. ");
INSERT INTO kbo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“ꞌBá ẹ̃zị́ ngaꞌbá rĩ pi ní ĩrivé ãtíꞌbá ãlu ni rụzú fụzú, kộpi ꞌdịkí ãlu ni drãá rá, kộpi úvị́kí ãzi rĩ írã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kúru ọ́mvụ́ ꞌdị́pa ní ívé ãtíꞌbá ụrụkọꞌbée pẽzú mụzú kárákará kộpi vúgá ꞌdãá, kãlãfe ni aga ĩri ní pẽé drị̃drị̃ ꞌdãꞌbée rá. ꞌBo ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi ꞌokí ãtíꞌbá rĩ pi ũnjí, sụ̃ ĩ ní drị̃drị̃ ꞌdãꞌbée ꞌoó ũnjí rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ụ̃dụ̃ ni gé, pẽ ívé mvá mụzú kộpi vúgá ꞌdãá, ụ̃sụ̃ ꞌí ẹ́sị́ agá ꞌdãlé kĩnĩ, ‘Kộpi ícó mávé mvá ị̃njị̃ rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“ꞌBo ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi kâ ágó rĩ vé mvá ágó rĩ ndreé, kộpi ní átázú ĩ ãsámvú gé sĩ kínĩ, ‘Mvá ꞌdĩri ímụ́ úrí ẹ́tẹ́pị vé ãꞌbú tị gé nĩ. Lẽ ꞌbâ ꞌdịkí ĩri rá, ꞌbâ úríkí rí ãꞌbú rĩ tị gé nĩ.’ ");
INSERT INTO kbo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kộpi ní mvá rĩ rụzú, kộpi sekí ĩri mụzú ọ́mvụ́ rĩ agásĩ ãmvé, kộpi ꞌdịkí ĩri drãá rá.” ");
INSERT INTO kbo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Kúru ọ́mvụ́ ꞌdị́pa kãdõ ícá, ĩri tã ngóni ni ꞌo ꞌbá ẹ̃zị́ ngaꞌbá rĩ pi ní?” ");
INSERT INTO kbo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Atala atala rĩ pi drị̃gé rĩ pi, Fãrụ́sị̃ rĩ pi be, kộpi ní ꞌyozú kínĩ, “Ágó rĩ ícó ꞌbá ẹ́sị́ be ũnjí ꞌdĩꞌbée úꞌdị́ ũdrã céré ꞌdĩísĩ rá. Kúru ĩri ímụ́ ꞌbá ụrụkọꞌbée ꞌbã ẹ̃zị́ nga ívé ọ́mvụ́ vị́nyọ̃ vé rĩ agá, ĩkũnãkí dõ vị́nyọ̃ rĩ gí, kộpi ã sẽkí rí ívé rĩ ã vúgú.” ");
INSERT INTO kbo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi lãkí tã ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ kuyé? Kĩnĩ, “ ‘Írã ándúrú ꞌbá jó sịꞌbá rĩ pi ní gãá sĩ rĩ, újá nóni ꞌi ícá írã sẽépi jó rĩ ní pá tuzú ãní ũkpó ũkpó ni. Úpí ꞌo tã ꞌdĩri nĩ, sẽ ꞌbá ní ãyãngárá.’ ");
INSERT INTO kbo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kúru á ꞌyoó ĩmi ní ꞌdíni, mãlũngã Múngú vé rĩ ĩ ímụ́ ꞌdụ ĩmi drị́gé sĩ rá, ĩ ímụ́ sẽ ꞌbá ĩrivé tã ꞌdụꞌbá ngaꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ꞌBá ãzi íꞌdé dõ írã ꞌdĩri drị̃gé, ĩri ŋõ rá. Írã rĩ íꞌdé dõ ꞌbá rĩ drị̃gé, ĩri ꞌbá rĩ ínjí drã vũgá ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Atala atala rĩ pi drị̃gé rĩ pi, Fãrụ́sị̃ rĩ pi be, kộpi kâ nãpí Yẹ́sụ̃ ní ũlũú ꞌdĩri yịị́, kộpi nị̃kí ámá rá ꞌyozú kínĩ, Yẹ́sụ̃ ri átá ĩvé tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kộpi lẽkí kõdô Yẹ́sụ̃ ri rụụ́, ꞌbo kộpi ꞌokí ụ̃rị̃ sĩ, ãꞌdiãtãsĩyã kộpi nị̃kí ámá rá ꞌyozú kínĩ, ꞌbá bị́trị́ká rĩ pi kínĩ, Yẹ́sụ̃ ri nẹ́bị̃. ");
INSERT INTO kbo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yẹ́sụ̃ ní gõzú átázú atala atala rĩ pi drị̃gé rĩ pi ní, ãzini Fãrụ́sị̃ rĩ pi ní nãpí sĩ dị̃ị́ kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ꞌbãgú ụ̃mụ̃ ꞌbãápi ꞌî mvọ́pị ní ũkú jezú rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ꞌBãgú rĩ pẽ ívé ãtíꞌbá rĩ pi mụụ́ ꞌbá ꞌí ní zịị́ ímụ́ ụ̃mụ̃ gé nõó rĩ pi zịị́, ꞌbo ꞌbá rĩ pi ímụ́kí ụ̃mụ̃ rĩ gé nõó kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kúru ĩri ní ívé ãtíꞌbá ụrụkọ pẽzú mụzú, ĩri ní ꞌyozú kộpi ní kĩnĩ, ‘Ĩmi mụkí lũú ꞌbá ĩ ní zịị́ gí rĩ pi ní kínĩ, má úlị́ tị́ rụ́ꞌbá be mũnyãmũnyã ni pi, má ãꞌdi ínyá rĩ kú ị́nọ́gọ́sị́ gí, ngá ãrẽvú céré anigé. Lẽ ꞌbá ĩ ní zịị́ gí rĩ pi ẽ ímụ́kí ụ̃mụ̃ ũkú jezú rĩ gé nõó!’ ");
INSERT INTO kbo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“ꞌBo ꞌbá ĩ ní mụụ́ zịị́ rĩ pi gãkí ímụ́gá ụ̃mụ̃ rĩ gé sĩ, ꞌbá rĩ pi ụrụkọ mụkí ẹ̃zị́ ngaá ĩvé ọ́mvụ́ agá, ụrụkọ ni pi mụkí ĩvé ngá ụzịngárá gá. ");
INSERT INTO kbo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ꞌBá rĩ pi ụrụkọ urụkí ꞌbãgú rĩ vé ãtíꞌbá rĩ pi, ũgbãkí kộpi, úꞌdị́kí kộpi ũdrãá rá. ");
INSERT INTO kbo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ꞌBãgú rĩ ã ꞌa vé ũnjí ũnjí. Ĩri ní ívé ãngáráwá rĩ pi pẽzú mụzú ꞌbá ívé ãtíꞌbá rĩ pi úꞌdị́ꞌbá rĩ pi úꞌdị́zú drãzú ꞌdĩísĩ rá, ãngáráwá rĩ pi zãkí kộpivé kụ̃rụ́ veé ãcí sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kúru ꞌbãgú rĩ ní ꞌyozú ívé ãtíꞌbá rĩ pi ní kĩnĩ, ‘Ụ̃mụ̃ ũkú jezú rĩ má útú tã ni dẹẹ́ gí, ꞌbo ꞌbá má ní zịị́ rĩ pi ũnjí, ícókí kộpi zịị́ ímụ́ ụ̃mụ̃ rĩ gé ku. ");
INSERT INTO kbo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ĩmi mụkí lẹ́tị kụ̃rụ́ agásĩ rĩ pi gé sĩ, ĩmi zịkí ꞌbá ĩmi ní ị́sụ́ rĩ pi ãrẽvú céré, kộpi ẽ ímụ́kí ụ̃mụ̃ ũkú jezú rĩ gé nõó.’ ");
INSERT INTO kbo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kúru ãtíꞌbá rĩ pi ní ꞌdezú mụzú lẹ́tị kụ̃rụ́ agá rĩ pi agásĩ, kộpi zịkí ꞌbá tã ꞌoꞌbá pịrị rĩ pi, ꞌbá tã ꞌoꞌbá ũnjí rĩ pi be ímụ́ ụ̃mụ̃ rĩ gé nõó, jó ĩ ní ụ̃mụ̃ ꞌbãzú rĩ agá dãá, ụ̃mụ́ rĩ pi gakí tré. ");
INSERT INTO kbo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ꞌBãgú rĩ kã ímụ́ ụ̃mụ́ rĩ pi ndreé, ị́sụ́ ágó ãzi ụ̃mụ́ rĩ pi ãsámvú gé ꞌdãá su bõngó ụ̃mụ̃ vé rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ꞌBãgú rĩ ní ágó rĩ zịzú kĩnĩ, ‘Ũndĩgó, ꞌí su bõngó ụ̃mụ̃ vé rĩ kuyé, mí ímụ́ nõgó ngóni ngóni?’ Ágó rĩ újí kíri. ");
INSERT INTO kbo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“ꞌBãgú rĩ ní ꞌyozú ívé ãtíꞌbá rĩ pi ní kĩnĩ, ‘Ĩmi úmbékí ágó rĩ ẽ drị́ pi pá ni be, ĩ ꞌbekí ĩri ãmvé ãngũ nịị́pi cịcị rĩ agá ꞌdãá, ã mụ rí ngoó, ãzini sị́kányá cií ꞌdãlé.’ ");
INSERT INTO kbo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ãꞌdiãtãsĩyã zịkí ꞌbá rĩ pi kárákará, ꞌbo ĩ ní ũpẽé rĩ pi kíníkiniŋá.” ");
INSERT INTO kbo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kúru Fãrụ́sị̃ rĩ pi ní fũzú mụzú ãmvé, kộpi lẽkí lẹ́tị ndãá Yẹ́sụ̃ rĩ ụ̃ꞌbị̃zú, ã ꞌyo rí tã ũnjí bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Fãrụ́sị̃ rĩ pi ní ĩvé ꞌbá ĩ pámvú ũbĩꞌbá rĩ pi pẽzú mụzú Ẽródẽ vé ꞌbá ĩri ẹ̃tị̃ꞌbá rĩ pi be Yẹ́sụ̃ vúgá ꞌdãá. ꞌBá ĩ ní pẽé ꞌdĩꞌbée ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Ímbápi, ꞌbá nị̃kí rá ꞌyozú kínĩ, mi ꞌbá tã ꞌoópi pịrị ni, mi ri tã áda Múngú vé rĩ ímbá. Mi ri ꞌbá rĩ pi ọ́ꞌdụ́ céré trõtrõ ị̃njị̃ngárá be, ãꞌdiãtãsĩyã mí ũpẽ ꞌbá ku. ");
INSERT INTO kbo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ꞌÍ lũ ꞌbá ní, mívé yị̃kị̂ íngóni? Ĩri múké ꞌbá ní mũfẽngã umbe jezú rĩ ũfẽzú ꞌbãgú ãmbúgú Rómã vé rĩ ní, dõku ꞌbâ ũfẽkí ku?” ");
INSERT INTO kbo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ꞌBo Yẹ́sụ̃ nị̃ tã ũnjí kộpi ẽ ẹ́sị́ agá ꞌdãlé rĩ rá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị ꞌdĩꞌbée, ngá ĩmi ní lẽzú ma ụ̃ꞌbị̃zú rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ĩmi iꞌdakí má ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ĩ ní ũfẽé ꞌbãgú rĩ ní umbe jezú ãní rĩ.” Kộpi ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ rĩ íꞌdụ́zú sẽzú Yẹ́sụ̃ drị́gé, ");
INSERT INTO kbo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ị́ndrị́lị́kị́ ĩ ní údé, ãzini rụ́ ĩ ní sĩí mũfẽngã fífí rĩ ã rụ́ꞌbá gá ꞌdĩri ãꞌdi vé ni?” ");
INSERT INTO kbo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “Ị́ndrị́lị́kị́ rĩ, ãzini rụ́ rĩ, ꞌbãgú ãmbúgú Rómã vé rĩ vé ni.” Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ngá rĩ dõ ꞌbãgú Rómã vé rĩ vé ni, ĩmi sẽkí ꞌbãgú Rómã vé rĩ ní, ngá rĩ dõ Múngú vé ni, ĩmi sẽkí Múngú ní.” ");
INSERT INTO kbo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ꞌBá ꞌdĩꞌbée kâ tã ꞌdĩri yịị́, sẽ kộpi ní ãyãngárá. Kúru kộpi ní ngazú mụzú, kộpi kukí Yẹ́sụ̃ ri kuú ọ́ꞌdụ́kụ́lẹgúsĩ. ");
INSERT INTO kbo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ụ́ꞌdụ́ ꞌdãri gé, Sãdókẽ ꞌyoꞌbá kínĩ ꞌbá rĩ drã dõ gí, ícó íngá gõó ídri rú ku rĩ pi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, ");
INSERT INTO kbo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ímbápi, tãị́mbị́ Mósẽ vé rĩ kĩnĩ, ꞌbá ágó drã dõ mvá ãkó, ẹ́drị́pị ri ícó ọ̃wụ́zị́ rĩ ẹ́ꞌyị́ rá, kộpi tịkí dõ anji, anjiŋá ꞌdĩꞌbée adri ẹ́drị́pị drãápi gí rĩ vé ni. ");
INSERT INTO kbo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anji ãgõ ẹ́zị̂rị̃, kộpi céré ẹ́drị́pị́ị rú, Mvá ágó kãyú rĩ ní ũkú jezú, drã úyé, kộpi tịkí mvá ũkú rĩ be kuyé, ẹ́drị́pị ꞌdeépi vú ni gé sĩ rĩ ní ũkú rĩ ẹ́ꞌyị́zú. ");
INSERT INTO kbo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ẹ́drị́pị ꞌdĩri drã kpá rá, kộpi tịkí mvá ũkú rĩ be kuyé. Ẹ́drị́pị ꞌdeépi ꞌdĩri vúgá sĩ rĩ gõ kpá ũkú rĩ ẹ́ꞌyị́, anji ẹ́drị́pị́ị rú ẹ́zị̂rị̃ ꞌdĩꞌbée céré rikí ũkú ãlu ꞌdĩri jeé, kộpi ũdrãkí céré, tịkí mvá ũkú ꞌdĩri be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ụ̃dụ̃ ni gé, ũkú rĩ ní kpá drãzú. ");
INSERT INTO kbo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Anji ãgõ ẹ́zị̂rị̃ ꞌdĩꞌbée céré rikí ũkú ãlu ꞌdĩri jeé pírí, kãdõ caá ụ́ꞌdụ́ ꞌbá ũdrãꞌbá gí rĩ pi ní íngázú gõzú ídri rú rĩ gé, ũkú ꞌdĩri pịrị ni úmvúlésĩ adri ãꞌdi vé ni?” ");
INSERT INTO kbo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Tã ĩmi ní zịị́ ꞌdĩri adri pịrị ku, tã Búkũ Múngú vé rĩ agá rĩ fi ĩmi drị̃gé kuyé, dõku ĩmi nị̃kí ũkpõ Múngú vé rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ꞌBá ũdrãꞌbá gí rĩ pi kádõ gõó íngá ídri rú, ãgõ rĩ pi jekí ũkú ku, ũkú rĩ pi jekí ãgõ ku. Kộpi mụ adri ꞌbụ̃ gé ꞌdãá sụ̃ mãlãyíkã rĩ pi tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ꞌBo ĩmi lãkí tã Múngú ní ꞌyoó kínĩ, ꞌbá ũdrãꞌbá gí rĩ pi gõ íngá ídri rú rá rĩ kuyé? ");
INSERT INTO kbo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Múngú kĩnĩ, ‘Ma Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, ãzini Múngú Yõkóbũ vé rĩ,’ Múngú adri ꞌbá ũdrãꞌbá gí rĩ pi vé ni ku, ĩri Múngú ꞌbá adriꞌbá ídri rú rĩ pi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ꞌBá bị́trị́ká rĩ pi kâ tã Yẹ́sụ̃ ní ímbá ꞌdĩri yịị́, sẽ kộpi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fãrụ́sị̃ rĩ pi kâ yịị́ kínĩ, tã Yẹ́sụ̃ ní újá rĩ sẽ Sãdókẽ rĩ pi újíkí kíri, Fãrụ́sị̃ rĩ pi gõkí ĩ úmú trụ́ vũrã ãlu gé. ");
INSERT INTO kbo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ágó ãzi ãlu kộpi ãsámvú gé riípi tãị́mbị́ ímbápi rĩ ní Yẹ́sụ̃ ri ụ̃ꞌbị̃zú, ĩri zịzú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ímbápi, tãị́mbị́ Mósẽ vé rĩ agá, tãị́mbị́ agaápi rá rĩ, ĩri íngõri?” ");
INSERT INTO kbo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “ ‘Lẽ mî lẽ Úpí Múngú mívé rĩ ẹ́sị́ be céré, índrí mívé rĩ be céré, yị̃kị̂ mívé rĩ be céré.’ ");
INSERT INTO kbo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tãị́mbị́ agaápi rá rĩ ĩri ꞌdĩ, ĩri tãị́mbị́ drị̃drị̃ rĩ. ");
INSERT INTO kbo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tãị́mbị́ ị̃rị̃ rĩ kpá tã be ãmbúgú, ‘Lẽ mî lẽ ꞌbá mî gãrã gá rĩ sụ̃ mí ní mî rụ́ꞌbá lẽé rĩ tị́nị.’ ");
INSERT INTO kbo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tãị́mbị́ ambugu ị̃rị̃ ꞌdĩꞌbée, ꞌbá rĩ ꞌdụ dõ tã ni ngaá rá, ị̃njị̃ tãị́mbị́ Mósẽ vé rĩ rá, ãzini ị̃njị̃ tã nẹ́bị̃ rĩ pi ní ímbá rĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fãrụ́sị̃ rĩ pi kâ ĩ úmú trụ́ ãlu, Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ĩmi ní ụ̃sụ̃zú rĩ gé, Kúrísítõ rĩ ãꞌdi ꞌi? Ĩri ãꞌdi ã mvá?” Kộpi ní újázú kínĩ, “Ĩri Dãwụ́dị̃ ã mvá.” ");
INSERT INTO kbo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Índrí Uletere rĩ kĩnĩ Dãwụ́dị̃ ã zị Kúrísítõ ri Úpí ãsĩ? Dãwụ́dị̃ kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Úpí ꞌyo mávé Úpí ní kĩnĩ, “Mí úrí mâ drị́ ẹ̃ndẹ́pị gé, cĩmgbá má ní mívé ariꞌba rĩ pi ꞌbãzú mî pálé gá rĩ gé.” ’ ");
INSERT INTO kbo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dãwụ́dị̃ zị dõ ĩri ‘Úpí ꞌi pírí,’ ĩri ícó adri Dãwụ́dị̃ ã mvá íngóni?” ");
INSERT INTO kbo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ꞌBá ãzi ícópi tã ĩri ní zịị́ ꞌdĩri újápi ni ꞌdãáyo. Íꞌdózú lókí ꞌdãri gé, ꞌbá ãzi gõ ĩri zịị́ dị̃ị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní, ãzini ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ꞌBá tãị́mbị́ ímbáꞌbá rĩ pi Fãrụ́sị̃ rĩ pi be, kộpi ũkpõ be tãị́mbị́ Mósẽ vé rĩ ímbázú. ");
INSERT INTO kbo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kúru tã kộpi ní lũú ĩmi ní rĩ, ĩmi ꞌdụkí ngaánga. ꞌBo lẽ ĩmi ꞌokí tã sụ̃ kộpi ní ꞌoó rĩ tị́nị ku, ãꞌdiãtãsĩyã tã kộpi ní ímbá rĩ, kộpi ꞌdụkí ngaá ku. ");
INSERT INTO kbo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kộpi ri ꞌbá rĩ pi mĩ tãị́mbị́ ũkpó ũkpó ni pi ꞌdụ nga, sụ̃ ĩ ní ọgụ ꞌbãá kộpi drị̃gé rĩ tị́nị, ꞌbo kộpi lẽkí ꞌbá rĩ pi ẽ ĩzã koó ọgụ ꞌdĩri ọ́ꞌdụ́zú kộpi drị̃gé sĩ vũgá ku. ");
INSERT INTO kbo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tã ãrẽvú céré kộpi ní rií ꞌoó rĩ, kộpi ri ꞌo, ꞌbá rĩ pi ã ndrekí rí ꞌyozú kínĩ, ĩ ꞌbá múké. Kộpi údékí sọ̃ndụ́kụ̃ ambugu ambugu ni pi, kộpi sĩkí vẹ́rẹ̃sị̃ Búkũ Múngú vé rĩ agá rĩ pi ꞌbãá sọ̃ndụ́kụ̃ rĩ pi agá, kộpi ũꞌyĩkí ĩ ẹndrẹtị gé sĩ, ãzini kộpi ũꞌyĩkí ĩ drị́gé sĩ, ꞌbá rĩ pi ã ndrekí rí, ãzini kộpi úsúkí bõngó, ũꞌyĩkí bõngó bãá ãcoco ni pi bõngó rĩ pi tị gé sĩ, ꞌbá rĩ pi ã ndrekí ĩ ꞌyozú kínĩ, ĩ ꞌbá múké. ");
INSERT INTO kbo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kộpi kádõ rií úrí ụ̃mụ̃ nyangárá gá, ãzini Jó Múngú ri Zịzú rĩ pi agá, kộpi lẽkí úrí lúpá ĩ ní ãngũ ị̃njị̃zú ị̃njị̃njị̃ rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kộpi kádõ rií adrií jọ̃kọ́nị̃ agá, ꞌbá rĩ pi kádõ kộpi ẹzịị́, kộpi lẽkí ꞌbá rĩ pi ẽ ị̃njị̃kí ĩ ị̃njị̃njị̃, lẽ ꞌbá rĩ pi ã zịkí ĩ ‘ímbápi.’ ");
INSERT INTO kbo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“ꞌBo lẽ ĩmi ãꞌyĩkí ꞌbá ãzi ã zị mi ímbápi ꞌdíni ku, ꞌbá riípi ĩmi ímbápi rĩ ꞌyéŋá ãlu, ĩmi céré ẹ́drị́pị́ị, ãzini ọ́mvụ́pị́ị. ");
INSERT INTO kbo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Vũ drị̃gé nõgó, lẽ ĩmi zịkí ꞌbá ãzi ꞌyozú kínĩ, ĩri ĩmi ẹ́tẹ́pị ꞌdíni ku. Ãꞌdiãtãsĩyã ĩmivé Ẹ́tẹ́pị ĩri ꞌyéŋá ãlu ꞌbụ̃ gé ꞌdãáꞌdã. ");
INSERT INTO kbo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lẽ ĩmi íngúkí ĩmi ꞌyozú kínĩ ĩmi ꞌbá ãngũ ímbáꞌbá ni pi ꞌdíni ku, ꞌbá ãngũ ímbápi rĩ ꞌyéŋá Kúrísítõ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ꞌBá rĩ lẽ dõ adrií ꞌbá ãmbúgú rú, lẽ ã ꞌbã ꞌi adrií ãtíꞌbá rú. ");
INSERT INTO kbo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ꞌBá riípi ꞌi íngúpi kínĩ ꞌi ꞌbá ãmbúgú rĩ, ĩrivé ãmbũgũ ri ísị́ ícá ku mãdãŋáŋá, ꞌbá ꞌi ꞌbãápi kú tã be mãdã rĩ, ĩ ĩri íngúngũ. ");
INSERT INTO kbo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ĩmi ꞌbá riꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, úmvúlésĩ ĩzãngã rĩ ímụ́ adri ĩmivé ni! Ĩmi ọ̃zụ̃kí ꞌbá rĩ pi ní lẹ́tị fizú ãní mãlũngã ꞌbụ̃ vé rĩ gé rĩ gí, ꞌbo ĩmi ícókí fií ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ĩmi ꞌbá riꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ãzini ĩmi ꞌbá ĩmi ꞌbãꞌbée kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú ꞌdĩꞌbée, ĩzãngã rĩ adri ĩmivé ni. Ĩmi ri ọwụzị rĩ pi ẽ mị ũꞌbã rizú kộpivé ngá jó ãsámvú gé rĩ pi uꞌdụzú kộpi drị́gé sĩ. Ĩmi ri Múngú ri zị sâ be ãco, ꞌbá rĩ pi ã ndrekí rí ĩmi, ꞌbo Múngú ri ímụ́ ĩmi ĩrĩŋã ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ĩmi ꞌbá riꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, úmvúlésĩ ĩzãngã rĩ ímụ́ adri ĩmivé ni! Ĩmi ri ẹ́cị́ vũ drị̃gé sĩ, ãzini ĩmi ri yị̃ị́ bãlãlã rĩ pi zo, ĩmi lẽkí kõdô ꞌbá ãzi ã újá ẹ́sị́, ꞌbá ãzi újá té dõ ẹ́sị́ rá, ĩmi sẽ ĩri ímụ́ fi ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá, ĩzãngã ĩri ní nyaá rĩ ĩri ímụ́ ĩmivé rĩ ndẽ rá. ");
INSERT INTO kbo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ĩmi drị̃koma adriꞌbá mị ãkó ꞌdĩꞌbée, ĩzãngã rĩ ímụ́ adri ĩmivé ni. Ĩmi kínĩ, ‘ꞌBá rĩ sõ dõ ũyõ Jó Múngú vé rĩ ã rụ́ sĩ, ũyõ ĩri ní sõó ꞌdĩri ẹ̃zị́ ãkó, ꞌbo ꞌbá rĩ sõ dõ ũyõ dábũ ĩ ní ꞌbãá Jó Múngú vé rĩ agá rĩ ã rụ́ sĩ, ã ꞌdụ ũyõ rĩ vé tã ngaá.’ ");
INSERT INTO kbo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ĩmi drị̃koma mị ãkó adriꞌbá azakaza rú ꞌdĩꞌbée, ngá ꞌdĩgé tã be ndẽépi rá rĩ ãꞌdi, ĩri dábũ rĩ, dõku ĩri Jó Múngú vé ĩ ní dábũ rĩ ꞌbãá ꞌa ni gé kú Múngú ní rĩ? ");
INSERT INTO kbo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ĩmi ꞌyokí kpá kínĩ, ‘ꞌBá rĩ sõ dõ ũyõ vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ ã rụ́ sĩ, ũyõ ĩri ní sõó ꞌdĩri ẹ̃zị́ ãkó, ꞌbo ꞌbá rĩ sõ dõ ũyõ fẽfẽ ĩ ní sẽé ꞌbãá vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ drị̃gé rĩ ã rụ́ sĩ, ã ꞌdụ ũyõ rĩ vé tã ngaá.’ ");
INSERT INTO kbo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ĩmi drị̃koma adriꞌbá mị ãkó ꞌdĩꞌbée, ngá ꞌdĩgé tã be ndẽépi rá rĩ ãꞌdi? Ĩri fẽfẽ ĩ ní sẽé rĩ pi, dõku vũrã rọ̃bọ̃ŋọ̃ zãzú ĩ ní fẽfẽ ꞌbãá drị̃ ni gé Múngú ní rĩ? ");
INSERT INTO kbo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ꞌBá rĩ sõ dõ ũyõ vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ ã rụ́ sĩ, sõ ũyõ rĩ vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ ã rụ́ sĩ, ãzini sõ ũyõ rĩ ngá ĩ ní ũꞌbãá vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ drị̃gé ꞌdĩꞌbée ã rụ́ sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ꞌBá rĩ sõ dõ ũyõ Jó Múngú vé rĩ ã rụ́ sĩ, sõ ꞌdĩri ũyõ Múngú adriípi Jó rĩ agá rĩ ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ꞌBá rĩ sõ dõ ũyõ ꞌbụ̃ ã rụ́ sĩ, sõ ũyõ ꞌdĩri Múngú vé lúpá ã rụ́ sĩ, ãzini Múngú riípi úrípi lúpá rĩ drị̃gé rĩ ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ĩmi ꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, ĩzãngã rĩ ímụ́ adri ĩmivé ni. Ngá ĩmi ní saá ĩmivé ọ́mvụ́ agá sụ̃ nãná tị́nị, ị̃ngị́rị̃ŋá tị́nị ꞌdĩꞌbée, ngá mụdrị́ agá, ĩmi ri ãlu ni íꞌdụ́ sẽ Múngú ní rá. ꞌBo tãị́mbị́ rĩ vé tã ãmbúgú ĩ ní ꞌyoó, ã lịkí tã pịrị, ã adrikí ẹ́sị́ be múké, ã ꞌdụkí Múngú vé tã ngaá ẹ́sị́ be ãlu ꞌdĩri, ĩmi ꞌdụkí ngaá kuyé. Lẽ ĩmi ꞌdụkí tã ꞌdĩꞌbée ngaá, ꞌbo lẽ ĩmi kukí ngá sẽngárá Múngú ní rĩ ã vúgú ku. ");
INSERT INTO kbo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ĩmi drị̃koma adriꞌbá mị ãkó ꞌdĩꞌbée, ụ́nyụ́nyụ́ kádõ ꞌdeé ĩmivé yị̃ị́ mvụụ́mvụ rĩ agá, ĩmi ri úrá yị̃ị́ rĩ agásĩ ãmvé, ꞌbo ĩmi tekí kámĩlõ kú ĩmi agá. ");
INSERT INTO kbo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ĩmi ꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, ĩmi ri ĩmivé kópõ, ãzini sákãnĩ ã rụ́ꞌbá ãmvé rĩ ũjĩ áyu, ꞌbo ĩmi ri ꞌa ni ku ãzãvũ rú, ĩmi adrikí sụ̃ ꞌdĩri tị́nị, ĩmivé ẹ́sị́ agá ꞌdãá, ĩmi kpá ẹ́sị́ be ãmbúgú ngá drị̃gé, ãzini ĩmi ĩndrá rú. ");
INSERT INTO kbo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ĩmi Fãrụ́sị̃ mị ãkó ꞌdĩꞌbée! Drị̃drị̃ ni, lẽ ĩmi ũjĩkí ĩmivé kópõ, ãzini sákãnĩ ã ꞌa ũjĩjĩ, úgóró ni ã adri rí kpá ule. ");
INSERT INTO kbo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ĩmi ꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, ĩmi índrékí sụ̃ ꞌbụ́rẹ̃drị̃ ĩ ní njõó kuú imvesírílílí ũnyĩ be ambamba rĩ tị́nị, ꞌbo ꞌa ni gé ꞌdãlé, ꞌbá ũdrãꞌbá gí rĩ pi ŋmakí, kộpivé fã adri kú ãzãvũ rú. ");
INSERT INTO kbo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ĩmi índrékí ꞌbá riꞌbá tã ꞌoꞌbá pịrị ni pi tị́nị, ꞌbo tã pịrị ĩmî ẹ́sị́ agá ꞌdãáyo, ĩmi ri ũnjĩkãnyã ꞌo. ");
INSERT INTO kbo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ĩmi ꞌbá tãị́mbị́ ímbáꞌbá ꞌdĩꞌbée, ãzini ĩmi Fãrụ́sị̃ ꞌdĩꞌbée, ĩmi ꞌbãkí ĩmi kú ꞌbá tã ꞌoꞌbá pịrị ni pi rú, ĩmi gbikí nẹ́bị̃ rĩ pi vé ꞌbụ́rẹ̃drị̃, ãzini ĩmi njõkí ꞌbụ́rẹ̃drị̃ ꞌbá tã ꞌoꞌbá pịrị rĩ pi vé rĩ kú ũnyĩ be ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ĩmi ri ꞌyo, ‘Lókí ꞌbá ẹ́ꞌbị́pị́ị vé rĩ gé, ꞌbâ adrikí dõ anigé, ꞌbá ícókí ꞌbá úmú ꞌbá ẹ́tẹ́pị́ị be nẹ́bị̃ rĩ pi úꞌdị́ ku.’ ");
INSERT INTO kbo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tã ĩmi ní átá ĩmî tị sĩ ꞌdĩri, lũ ꞌyozú kínĩ ĩmi ꞌbá nẹ́bị̃ rĩ pi úꞌdị́ꞌbá rĩ pi vé anji. ");
INSERT INTO kbo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ĩmi lẽkí ũnjĩkãnyã ꞌoó sụ̃ ĩmi ẹ́ꞌbị́pị́ị ní ꞌoó rĩ tị́nị, ĩmi ꞌokí! ");
INSERT INTO kbo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ĩmi índrékí sụ̃ ị̃nị̃ tị́nị, ĩmi anji ị̃nị̃ vé ni pi! Ĩmi nyo ícó ápá tã ĩ ní lịị́ ĩmi drị̃gé, ĩmi jịị́pi fiípi ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá rĩ sị́lé gá sĩ bã rá? ");
INSERT INTO kbo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kúru á lẽ ꞌyoó ĩmi ní ꞌdíni, ma ímụ́ ĩmi ní nẹ́bị̃ rĩ pi pẽ ꞌbá ũmĩ be rĩ pi be, ãzini ꞌbá ãngũ ímbáꞌbá rĩ pi be, ĩmi ímụ́ ụrụkọꞌbée úꞌdị́ rá, ĩmi ụrụkọꞌbée gbã pẹtị alambaku sị́gé, ĩmi ụrụkọꞌbée ũgbã kẹ̃lị́ŋá sĩ ĩmivé Jó Múngú ri Zịzú rĩ pi agásĩ, ĩmi ímụ́ kộpi údró fũ mụzú kụ̃rụ́ rĩ pi agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ꞌBá Múngú vé tã be pịrị ĩ ní úꞌdị́ rĩ pi vé ãrí ri ímụ́ ngo ĩmi drị̃gé, úꞌdị́ngárá rĩ íꞌdó Ẽbélẽ tã be pịrị rĩ rụ́ꞌbá gá, cĩmgbá cazú Zãkãríyã Bãrãkíyã mvọ́pị rụ́ꞌbá gá, ꞌdịkí Zãkãríyã ri Jó Múngú vé rĩ pi vé ãsámvú vũrã rọ̃bọ̃ŋọ̃ zãzú rĩ be rĩ gé, kộpivé ãrí ri ímụ́ ngo ĩmi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ĩ ímụ́ úyú ãndrũ nõꞌbée ĩrĩŋã tã ꞌi ngaꞌbée ꞌdĩꞌbée ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Á, ĩmi ꞌbá Yẹ̃rụ́sãlémã vé rĩ pi! Ĩmi úꞌdị́kí nẹ́bị̃ ĩ ní pẽé mụụ́ ĩmi vúgá ꞌdĩí rĩ pi ũdrãá rá, ãzini ĩmi úvị́kí kpá ꞌbá Múngú ní pẽé mụụ́ ĩmi vúgá rĩ pi ũdrãá írã sĩ. Vú be kárákará, á lẽ kõdô ĩmivé ꞌbá rĩ pi ĩkũnãá ímụ́ adrií vũrã ãlu gé, sụ̃ ãꞌụ́ ní ívé anjiŋá ĩkũnãá adrií ꞌî ụ̃pẹlẹ́ꞌbị́ ã ndụ́gé rĩ tị́nị, ꞌbo ĩmi ãꞌyĩkí ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ĩmi ndrekí drĩ ká, ĩmivé jó ꞌdĩri ímụ́ adri ku ándrú rú. ");
INSERT INTO kbo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Á lẽ ꞌyoó ĩmi ní ꞌdíni, íꞌdózú ãndrũ sĩ, ĩmi ícókí ma ndreé dị̃ị́ ku, cĩmgbá ĩmi ní ímụ́zú ꞌyozú, ‘Tãkíri ã adri ꞌbá ímụ́pi Úpí ã rụ́ sĩ rĩ be.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yẹ́sụ̃ kã rií fũú mụzú Jó Múngú vé rĩ agásĩ ãmvé, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú ĩri vúgá, kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌÍ ndre drĩ Jó Múngú vé rĩ, ãzini ꞌí ndre drĩ jó ĩ ní sịị́ gãrã ni gé sĩ ꞌdĩꞌbée ká.” ");
INSERT INTO kbo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, jó ĩmi ní ndreé ꞌdĩꞌbée, ĩ ímụ́ kộpi ũŋõ céré vũgá, ícókí írã ãzi kuú ọ́gụ́pị drị̃gé ãluŋáni ku.” ");
INSERT INTO kbo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yẹ́sụ̃ kã úrí kuú Írã Õlívẽ vé rĩ drị̃gé ꞌdãá, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩ njezú mụzú ĩri vúgá ꞌdãá, kộpi ní ĩri zịzú kínĩ, “Tã ꞌdĩri ímụ́ ꞌi nga ngọ̃tụ́? Ngá ícópi mívé ímụ́ngárá ã tã iꞌdaápi rĩ ãꞌdi? Ãzini ngá ícópi ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ ã tã iꞌdaápi rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi adrikí mị be kọwụ, lẽ ꞌbá ãzi ã ũꞌbã ĩmî mị ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ꞌBá kárákará pi ímụ́ mâ rụ́ sĩ, kộpi ꞌyo, ‘Ma Kúrísítõ ꞌi.’ Kộpi ímụ́ ꞌbá kárákará pi ẽ mị ũꞌbã rá. ");
INSERT INTO kbo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ĩmi ímụ́ ẹ̃ꞌdị́ ĩ ní rií ꞌdịị́ rĩ vé tã yị, ãzini ĩmi ímụ́ tã ꞌbá rĩ pi ní lẽzú ẹ̃ꞌdị́ ꞌdịzú rĩ vé tã yị rá, ꞌbo tã ꞌdĩri ã sẽ ĩmi ní ụ̃rị̃ ku. Tã ꞌdĩꞌbée ímụ́ ĩ nga rá, ꞌbo ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ ícó drĩ ícá mbẽlẽŋá ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ꞌBá ãngũ ãzi agá rĩ pi ímụ́ ẹ̃ꞌdị́ ꞌdị ꞌbá ãngũ ãzi agá rĩ pi be, ꞌbãgú ãngũ ãzi agá rĩ pi ímụ́ ẹ̃ꞌdị́ ꞌdị ꞌbãgú ãngũ ãzi agá rĩ pi be. Ẹ̃bị́rị́ ri ímụ́ ꞌde ũgã vũgá sĩ, ãzini nyọ̃ọ́kụ́ rĩ ímụ́ ꞌi aya dĩngídĩngí ãngũ rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tã ꞌdĩꞌbée ĩzãngã rĩ vé íꞌdóngárá, sụ̃ ũkú ní íꞌdó ĩzãngã nyaá mvá tĩngárá gá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ĩ ímụ́ ĩmi urụ sẽ ꞌbá ãngũ ọ̃cụ̃ꞌbá rĩ pi drị́gé, kộpi ĩmi úꞌdị́, ꞌbá ãngũ rĩ pi agásĩ rĩ pi céré ímụ́ ĩmi ndre ũnjí mâ tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sâ ꞌdãri gé, ꞌbá kárákará pi ímụ́ ĩvé ẹ̃ꞌyị̃ngárá ku rá, kộpi ímụ́ ĩ ọ̃gụ̃pị́ị ã ũli ꞌbe, ãzini kộpi ímụ́ ĩ ọ̃gụ̃pị́ị ndre ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nẹ́bị̃ kárákará ũnjó rú ni pi ímụ́ ĩfũ, kộpi ímụ́ ꞌbá kárákará pi ẽ mị ũꞌbã. ");
INSERT INTO kbo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ũnjĩkãnyã ní rií tị mụzú drị̃gélé rĩ sĩ, ĩri sẽ ꞌbá ụrụkọ lẽkí ĩ ọ̃gụ̃pị́ị ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ꞌBo ꞌbá pá tuúpi ũkpó ũkpó cĩmgbá cazú ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ gé rĩ, Múngú ri ímụ́ ĩri pa rá. ");
INSERT INTO kbo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ụ́ꞌdụ́kọ́ múké mãlũngã vé rĩ, ĩ ímụ́ ũlũ mụzú ãngũ rĩ pi agásĩ céré. ꞌBá rĩ pi yịkí dõ céré gí, ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ kúru ícá. ");
INSERT INTO kbo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ĩmi kádõ ‘Ngá Ũnjí ãngũ izaápi rá,’ nẹ́bị̃ Dãnyélẽ ní ọ́tụ́ tã ni ꞌyoó tu pá kuú vũrã uletere rĩ agá rĩ ndre, ꞌbá tã ni lãápi rĩ, ã nị̃ tã ni vé ífífí múké. ");
INSERT INTO kbo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kúru sâ ꞌdãri gé, ĩmi dõ ri adri ãngũ Yụ̃dáyã vé rĩ agá, lẽ ĩmi njukí tụụ́ mụzú írã drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ꞌBá tụꞌbá ĩvé jó drị̃gé rĩ pi, lẽ kộpi ẽ ísị́kí vũgá mụụ́ ngá ãzi íꞌdụ́ ĩvé jó agá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ꞌBá adriꞌbá ĩvé ọ́mvụ́ agá rĩ pi, lẽ kộpi ã gõkí mụụ́ ĩvé bõngó akoó rụ̃kụ̃ rĩ íꞌdụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sâ ꞌdãri gé, ĩzãngã rĩ adri ãmbúgú ũkú ꞌa be rĩ pi ní, ãzini ũkú riꞌbá anji undruꞌbá undrundru rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lẽ ĩmi zịkí Múngú ri, lókí ĩmi ní ápázú rĩ ã adri lókí kílóngóro vé rĩ gé ku, dõku ã adri ụ́ꞌdụ́ Sãbátã vé rĩ gé ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lókí ꞌdĩri, ĩri lókí ũnjí ĩzãngã nyazú ni. Íꞌdózú ĩ ní ꞌbụ̃ pi gbizú vũ be rĩ gé, cĩmgbá ícázú ãndrũ sĩ, tã ꞌdĩri ãvũ ni nga drĩ ꞌi ꞌdíni kuyé. Tã ꞌdĩri gõ ꞌi ngaá ꞌdĩri tị́nị dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Múngú ẽ ítrú té dõ ụ́ꞌdụ́ ꞌdĩꞌbée ícá ẹ̃lị́ŋá ku, ꞌbá ãzi ícó té adrií ídri rú ku, Múngú ítrú ụ́ꞌdụ́ ꞌdĩꞌbée ẹ̃lị́ŋá, ãꞌdiãtãsĩyã ĩrivé ꞌbá ĩri ní ũpẽé gí rĩ pi ã tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Sâ ꞌdãri gé, ꞌbá ãzi ꞌyo dõ mí ní, ‘ꞌÍ ndre drĩ ká, Kúrísítõ ri nõ!’ dõku ‘Ĩri ꞌdã!’ lẽ mî ẹ̃ꞌyị̃ ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ꞌBá ũnjó rú ꞌyoꞌbá kínĩ ĩ Kúrísítõ rĩ pi nẹ́bị̃ ũnjó rú rĩ pi be, kộpi ímụ́ tã ambugu ambugu ni pi ꞌo, ãzini tã ãyãzú ãyãyã ni pi ꞌo ꞌbá rĩ pi ẽ mị ũꞌbãzú, kộpi kpá ụ̃ꞌbị̃ ꞌbá Múngú ní ũpẽé ívé ni rĩ pi ẽ mị ũꞌbã ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ĩmi ndrekí drĩ ká, ã lũ ĩmi ní tã ꞌdĩri drị̃drị̃ ị́sụ́ ãkũdẽ lókí ꞌdãri ícá drĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ꞌBá ãzi lũ dõ ĩmi ní kĩnĩ, ‘Ĩmi ndrekí drĩ ká, Kúrísítõ ri ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãáꞌdã,’ ĩmi izakí sâ mụzú ĩri ndãzú ku, dõku ꞌyo dõ ĩmi ní kĩnĩ, ‘Kúrísítõ ri jó agálésĩ rĩ agá ꞌdãáꞌdã,’ lẽ ĩmi ẹ̃ꞌyị̃kí ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ꞌBá Mvá vé ímụ́ngárá ĩri ímụ́ adri sụ̃ ũvi gaápi ãngũ ĩmgbẽrẽépi íꞌdózú ụ̃tụ́ ní ĩfũngárá gá, cĩmgbá cazú ụ̃tụ́ ní ꞌdengárá gá rĩ tị́nị, ꞌbá rĩ pi ndre ãngũ rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vũrã ãvũ rĩ pi ní ulazú rĩ, lógúnũ rĩ pi unga mụ uꞌde vũrã ꞌdãri gé. ");
INSERT INTO kbo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Koro ụ́ꞌdụ́ ĩzãngã nyazú ꞌdãꞌbée ã vụ́drị̃ gé, “ ‘Ụ̃tụ́ rĩ ẽ mị ri ímụ́ bĩ nị ku ị́nị́ŋá rú, mbãá rĩ gõ kaá ku, Línyã rĩ pi ímụ́ lụ̃ ꞌbụ̃ gé ꞌdãásĩ vũgá, ãngũ ꞌbụ̃ gé ꞌdãá rĩ ímụ́ ꞌi aya dĩngídĩngí.’ ");
INSERT INTO kbo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Sâ ꞌdãri gé, ma ꞌBá Mvá ꞌi, tã ãyãzú ãyãyã ni ímụ́ ꞌi nga ꞌbụ̃ gé ꞌdãá mávé ímụ́ngárá ã tã iꞌdazú, ꞌbá vũ drị̃gé rĩ pi céré nga rĩ ngo ĩzãngã ĩzãngã rú. Ma ꞌBá Mvá ꞌi, kộpi ímụ́ mávé ímụ́ngárá ị́rị́bị́tị agásĩ ũkpõ be rĩ ndre, ãzini mávé dị̃ngárá pọ̃wụ̃pọ̃wụ̃ rĩ ndre ĩ mị sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ĩri ímụ́ ívé mãlãyíkã rĩ pi ĩpẽ gũké vu ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá ꞌbá rĩ pi zịzú, kộpi ímụ́ ꞌbá ĩri ní ũpẽé gí rĩ pi ĩkũnã vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Lẽ ĩmi nị̃kí tã ꞌi ngaápi pẹtị ĩ ní zịị́ fị́gị̃ rĩ ã rụ́ꞌbá gá rĩ. Pẹtị rĩ vé drị́tị íꞌdó dõ rũú bị́ be gí, ĩmi nị̃ ámá ꞌyozú kínĩ, ãngũ rĩ ícá ẹ̃ẹ́zụ̃ rú gí. ");
INSERT INTO kbo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ĩri kpá adri sụ̃ ꞌdĩri tị́nị, ĩmi ndrekí dõ tã ꞌdĩꞌbée ri ĩ nga, ĩmi nị̃ ámá ꞌyozú kínĩ, ẹ̃sị̃ mãdã, ma ílókõ ímụ́mụ̃, ma nóni kẹ̃ẹ́tịlé gá. ");
INSERT INTO kbo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá úyú nõri vé rĩ pi ã ụrụkọ ũdrãkí drĩ ku, cĩmgbá tã ꞌdĩꞌbée ní ĩ ngangárá gá. ");
INSERT INTO kbo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ꞌBụ̃ pi vũ be, kộpi dẹ rá, ꞌbo ụ́ꞌdụ́kọ́ má ní átá rĩ dẹ ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ꞌBá ãzi nị̃ ụ́ꞌdụ́, dõku sâ má ní ímụ́zú rĩ kuyé, mãlãyíkã ꞌbụ̃ gé rĩ pi nị̃kí kuyé, ma Mvá rú, á nị̃ kpá kuyé, ꞌbo má Ẹ́tẹ́pị nị̃ ꞌyéŋá nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma ꞌBá Mvá ꞌi, mávé ĩgõngárá, ĩri ímụ́ adri sụ̃ lókí Núwã vé rĩ gé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lókí yị̃ị́gọ́ rĩ ní drĩ ꞌdịzú tị̃zú kuyé rĩ gé, ꞌbá rĩ pi rikí ngá nyaá, kộpi rikí ngá mvụụ́, kộpi rikí ũkú jeé, ãzini kộpi rikí ĩvé anji ũkú rĩ pi sẽé jeé ãgõ rĩ pi ní, cĩmgbá cazú lókí Núwã ní fizú ívé kũlúmgba mọ̃ọ́ngụ́ rĩ agá rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kộpi nị̃kí ꞌyozú kínĩ, tã ãzi ri ímụ́ ꞌi nga ꞌdíni kuyé, cĩmgbá cazú lókí yị̃ị́gọ́ rĩ ní tị̃zú kộpi ĩmũlũzú úꞌdị́zú drãzú rĩ gé. Ma ꞌBá Mvá ꞌi, mávé ĩgõngárá ri ímụ́ adri sụ̃ ꞌdĩri tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tã ꞌdĩri ímụ́ ꞌbá ị̃rị̃ pi ị́sụ́ ọ́mvụ́ agá, ĩ ãlu ni ꞌdụ, ĩ ãlu ni ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ĩri ímụ́ ũkú ị̃rị̃ pi ị́sụ́ ngá ꞌyịngárá gá, ĩ ãlu ni ꞌdụ, ĩ ãlu ni ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kúru lẽ ĩmi adrikí mị be kọwụ, ãꞌdiãtãsĩyã ụ́ꞌdụ́ Úpí ní ímụ́zú ĩgõzú rĩ, ĩmi nị̃kí kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ꞌBo lẽ ĩmi nị̃kí tã ꞌdĩri múké, jó ꞌdị́pa rĩ ã nị̃ té dõ sâ ụ̃gụ́ꞌbá ní ímụ́zú ꞌí vúgá ị́nị́ sĩ rĩ rá, ĩri té adri mị be kọwụ, ícó té ụ̃gụ́ꞌbá rĩ kuú mụụ́ ngá ụ̃gụ̃ụ́ ívé jó agá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lẽ ĩmi adrikí kpá ũrẽ, ãꞌdiãtãsĩyã ma ꞌBá Mvá ꞌi, sâ má ní ímụ́zú rĩ, ĩmi ícókí tã ni ꞌbãá ĩmi drị̃gé ꞌyozú kínĩ, ma ri ímụ́ ꞌdĩíꞌdĩ ꞌdíni ku. ");
INSERT INTO kbo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ãtíꞌbá ẹ́sị́ ꞌbãápi ívé ãmbúgú rĩ vé tã ꞌdụụ́pi ngaápi rá, adriípi úmĩ be, ãmbúgú rĩ ní ꞌbãá ãtíꞌbá rĩ pi drị̃gé ãmbúgú rú ícópi ãnyãngã sẽépi ãtíꞌbá ụrụkọꞌbée ní sâ múké gá rĩ ãꞌdi ꞌi? ");
INSERT INTO kbo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ꞌBá ãmbúgú rĩ kãdõ ĩgõó, ị́sụ́ dõ ívé ãtíꞌbá rĩ nga ẹ̃zị́ rĩ múké, ãtíꞌbá rĩ tãkíri ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ádarú á ꞌyo ĩmi ní ꞌdíni, ꞌbá ãmbúgú rĩ ícó ãtíꞌbá ꞌdĩri ꞌbã ívé ngá jó ãsámvú gé rĩ pi ãrẽvú ũtẽ céré nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ꞌBo ãtíꞌbá rĩ dõ ꞌbá tã ꞌoópi ũnjí ni, ꞌyo dõ, ‘Mávé ãmbúgú rĩ mụ adrií ãmvé sâ be ãco,’ ");
INSERT INTO kbo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","íꞌdó dõ rií ꞌî ọ̃gụ̃pị́ị ãtíꞌbá rĩ pi fụụ́, ãzini fi dõ rií íwá mvụụ́ ꞌbá riꞌbá íwá mvụꞌbá ĩmẽrẽzú rĩ pi be trụ́, ");
INSERT INTO kbo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ãmbúgú ãtíꞌbá ꞌdĩri vé rĩ ímụ́ ícá lókí ãtíꞌbá rĩ ní nị̃ị́ kuyé ni gé. ");
INSERT INTO kbo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ĩri ímụ́ ãtíꞌbá ꞌdĩri uga kpélékpélé, ĩri ꞌdụ ꞌbe ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị rĩ pi ãsámvú gé, ꞌdãlé kộpi ã mụkí rí ãá ngoó ãzini sị́kányá cií. ");
INSERT INTO kbo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ anji ũkú mụdrị́ kácáŋá rú ĩvé lámbã ꞌdụꞌbá mụzú ĩndĩ kẹ̃rẹ́gú rĩ ẽ drị̃ ũtẽzú rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Anji ũkú tọ̃wụ́ rĩ pi azakaza rú, tọ̃wụ́ rĩ pi úmĩ be. ");
INSERT INTO kbo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Anji ũkú azakaza rú rĩ pi ꞌdụkí ĩvé lámbã mụzú ĩndĩ, ꞌbo kộpi jịkí ũdu ãndõ rú ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anji ũkú tọ̃wụ́ úmĩ be rĩ pi tõkí ũdu mãlãngĩ agá, kộpi ꞌdụkí mụzú ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kẹ̃rẹ́gú rĩ ꞌdụ sâ ãco, ímụ́ ícá ndõ, ị́sụ́ ãkũdẽ anji ũkú rĩ pi kokí ụ́ꞌdụ́ gí. ");
INSERT INTO kbo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kã mụụ́ adrií ị́nị́ ágágá, ꞌbá ãzi ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, ‘Kẹ̃rẹ́gú rĩ ri ímụ́ ꞌdã! Ĩmi ĩfũkí ãmvé ĩri vú nõó.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kúru anji ũkú rĩ pi ní aruzú ụ́ꞌdụ́ gélésĩ, kộpi ní ĩvé lámbã rĩ pi vé bãákú veꞌbá rĩ pi ẽ tị úlị́zú ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anji ũkú azakaza rú rĩ pi ní ꞌyozú anji ũkú úmĩ be rĩ pi ní kínĩ, ‘Ĩmi sẽkí ꞌbá ní ũdu, ꞌbávé lámbã rĩ pi vé ãcí ri ũdrãdrã.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Anji ũkú úmĩ be rĩ pi ní újázú kộpi ní kínĩ, ‘ꞌBá ícókí ĩmi ní ũdu sẽé ku, ũdu rĩ ícó caá ꞌbá ní ĩmi be ku, ĩmi mụkí ũdu jeé ꞌbá riꞌbá ũdu ụzịꞌbá rĩ pi vúgá.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kộpi kâ ꞌdeé mụụ́ ũdu jengárá gá ꞌdãá, kẹ̃rẹ́gú rĩ ní ícázú. Anji ũkú ĩ útúꞌbá kú ũrẽ rĩ pi ní ꞌdezú mụzú vũrã ũkú jezú rĩ gé ꞌdãá. Ãtíꞌbá rĩ pi ní kẹ̃ẹ́tị rĩ ụ̃pị̃zú cí. ");
INSERT INTO kbo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vúlé vúlé rú anji ũkú azakaza rú rĩ pi ní kpá ícázú, kộpi kínĩ, ‘Ãmbúgú ꞌbávé rĩ, ꞌí zị ꞌbá ní kẹ̃ẹ́tị rĩ!’ ");
INSERT INTO kbo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“ꞌBo ĩri ní újázú kộpi ní kĩnĩ, ‘Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, á nị̃ ĩmi kuyé.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Kúru ĩmi ꞌbá mâ pámvú ũbĩꞌbá ꞌdĩꞌbée, lẽ ĩmi útúkí ĩmi kú ũrẽ, ãꞌdiãtãsĩyã ĩmi nị̃kí ụ́ꞌdụ́, dõku sâ má ní ímụ́zú ĩgõzú rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Á lẽ ꞌyoó ĩmi ní dị̃ị́ ꞌyozú kínĩ, mãlũngã ꞌbụ̃ vé rĩ adri sụ̃ ágó mụụ́pi ãngũ vụ̃rá gá rĩ vé rĩ tị́nị. Ágó rĩ kã lẽé ngaá mụzú, zị ívé ãtíꞌbá na rĩ pi, awa kộpi ní mũfẽngã, kộpi ã ngakí rí ẹ̃zị́ ãní. ");
INSERT INTO kbo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sẽ ãzi rĩ ní mũfẽngã jũrú ãmbúgú tọ̃wụ́, ãzi rĩ ní mũfẽngã jũrú ãmbúgú ị̃rị̃, ãzi rĩ ní mũfẽngã jũrú ãmbúgú ãlu. Ĩri ní kúru ꞌdezú mụzú ívé ẹ̃cị̃ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ágó ĩ ní mũfẽngã sẽé ĩri ní jũrú ãmbúgú tọ̃wụ́ rĩ, ꞌdụ mũfẽngã rĩ mụzú ẹ̃zị́ ngazú ãní, gõ ãzini ị́sụ́ drị̃ ni gé caá jũrú ãmbúgú tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ꞌBo ágó ĩ ní mũfẽngã sẽé ĩri ní jũrú ãmbúgú ị̃rị̃ rĩ, ꞌdụ mũfẽngã rĩ mụzú ẹ̃zị́ ngazú ãní, gõ ãzini ị́sụ́ drị̃ ni gé caá jũrú ãmbúgú ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ꞌBo ágó ĩ ní mũfẽngã sẽé ĩri ní jũrú ãmbúgú ãlu rĩ, jị mũfẽngã ívé ãmbúgú rĩ vé rĩ sị̃ị́ ꞌbụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vụ́drị̃ ni kã vụ̃ụ́ caá sâ ãco, ágó ãmbúgú rĩ ní ímvízú. Ĩri ní ívé ãtíꞌbá rĩ pi zịzú, lẽ nị̃ị́ ámá dõ kộpi ngakí ẹ̃zị́ mũfẽngã rĩ sĩ íngóni. ");
INSERT INTO kbo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ágó ĩ ní mũfẽngã sẽé ĩri ní élĩfũ tọ̃wụ́ rĩ, gõ élĩfũ ãzi ị́sụ́ caá tọ̃wụ́. Ĩri ní ꞌyozú ívé ãmbúgú rĩ ní kĩnĩ, ‘ꞌÍ sẽ ándúrú má ní mũfẽngã élĩfũ tọ̃wụ́, nóni á gõ ãzi ni ị́sụ́ caá drị̃ ni gé élĩfũ tọ̃wụ́.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ĩrivé ãmbúgú rĩ ní újázú ĩri ní kĩnĩ, ‘ꞌÍ nga ẹ̃zị́ rĩ múké, mi ãtíꞌbá múké, ꞌí ꞌbã mívé ẹ́sị́ céré rizú ẹ̃zị́ rĩ ngazú. ꞌÍ ꞌbã ẹ́sị́ rizú ngá mãdãŋá ꞌdĩri ã tã mbazú, ma nóni mi ꞌbã ngá ãmbúgú ni ã tã mba. Mí ímụ́, ꞌbá ímụ́kí ãyĩkõ ꞌbãá mí be trụ́.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ágó ĩ ní mũfẽngã sẽé ĩri ní élĩfũ ị̃rị̃ rĩ ní ímụ́zú, ĩri ní ꞌyozú ívé ãmbúgú rĩ ní kĩnĩ, ‘Mũfẽngã mí ní sẽé má ní élĩfũ ị̃rị̃ rĩ, á gõ ãzini ị́sụ́ caá drị̃ ni gé élĩfũ ị̃rị̃.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ĩrivé ãmbúgú rĩ ní újázú kĩnĩ, ‘ꞌÍ nga ẹ̃zị́ rĩ múké, mi ãtíꞌbá múké, ꞌí ꞌbã mívé ẹ́sị́ céré rizú ẹ̃zị́ rĩ ngazú. ꞌÍ ꞌbã ẹ́sị́ rizú ngá mãdãŋá ꞌdĩri ã tã mbazú, ma nóni mi ꞌbã ngá ãmbúgú ni ã tã mba. Mí ímụ́, ꞌbá ímụ́kí ãyĩkõ ꞌbãá mí be trụ́.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ãtíꞌbá ĩ ní mũfẽngã sẽé ĩri ní jũrú ãmbúgú ãlu rĩ ní ímụ́zú, ĩri ní ꞌyozú ívé ãmbúgú rĩ ní kĩnĩ, ‘Ãmbúgú, á nị̃ rá mî tã ẽ sị́ mbamba, ãnyãngã mí ní rií ĩkũnãá rĩ, ꞌí ꞌã ọ́mvụ́ ni mi ꞌi kuyé, ãnyãngã mí ní rií ĩkũnãá rĩ, ꞌí ri úri ni nĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Á ꞌo ụ̃rị̃ sĩ, á jị mívé mũfẽngã jũrú ãmbúgú ãlu rĩ sị̃ị́ ꞌbụ́ agá, mívé mũfẽngã rĩ má ní íjị́ nõ.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ĩrivé ãmbúgú rĩ ní újázú ĩri ní kĩnĩ, ‘Mi ãtíꞌbá ũnjí, mi ũvú rú! ꞌÍ nị̃ rá ꞌyozú kínĩ, ãnyãngã má ní ĩkũnãá rĩ, á sa nĩ kuyé, ãzini ãnyãngã má ní ĩkũnãá rĩ, á ri úri ni nĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Múké ni, mi té mávé mũfẽngã jị ꞌbã jó ĩ ní rizú mũfẽngã ꞌbãzú rĩ agá, má kãdõ ĩgõó, ma té ị́sụ́ ãkũdẽ mávé mũfẽngã rĩ tị gí.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Kúru ãmbúgú rĩ ní ꞌyozú kĩnĩ, ‘Ĩmi ꞌdụkí mũfẽngã jũrú ãmbúgú ãlu ꞌdĩri drị́ ni gé sĩ rá, ĩmi sẽkí mũfẽngã rĩ ãtíꞌbá adriípi mũfẽngã jũrú ãmbúgú be mụdrị́ rĩ nĩ! ");
INSERT INTO kbo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ꞌBá ívé mũfẽngã áyúpi lẹ́tị be múké rĩ, ĩ ímụ́ ĩri ní ãzi ni sẽ drị̃drị̃ ꞌdãri aga rá, ĩri ímụ́ adri mũfẽngã be ambamba. ꞌBo ꞌbá ívé mũfẽngã áyúpi lẹ́tị be múké kuyé rĩ, ĩ ímụ́ ĩrivé rĩ ꞌdụ drị́ ni gé sĩ ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ãtíꞌbá ꞌdĩri ẹ̃zị́ ãkó, ĩmi ꞌdụkí ĩri ꞌbeé ãmvé ị́nị́ŋá agá ꞌdãá, ã mụ rí ãá ngoó, ãzini sị́kányá cií ꞌdãá.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ma ꞌBá Mvá ꞌi, má kãdõ ĩgõó mãlãyíkã rĩ pi be sụ̃ ꞌbãgú tị́nị, ma ímụ́ úrí lúpá mãlũngã vé ꞌbụ̃ gé ĩ ní íngúngũ rĩ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ĩ ímụ́ ꞌbá rĩ pi úmú ãngũ rĩ pi agásĩ céré, ĩ kộpi íjị́ má ẹndrẹtị gé, ma ímụ́ kộpi ãsámvú aco sụ̃ ĩ ní kãbĩlõ pi acoó ndrị̃ị́ be rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma ímụ́ kãbĩlõ rĩ pi ꞌbã mávé drị́ ẹ̃ndẹ́pị gé, ma ndrị̃ị́ rĩ pi ꞌbã mávé drị́ ị̃jị́ gé. ");
INSERT INTO kbo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ma ꞌbãgú rú, ma ímụ́ ꞌyo kãbĩlõ mávé drị́ ẹ̃ndẹ́pị gé rĩ pi ní, ‘Ĩmi ímụ́kí, má Ẹ́tẹ́pị ꞌbã tãkíri ĩmi drị̃gé gí. Ĩmi ímụ́kí fií mãlũngã ĩ ní údé kuú ĩmi ní ị́nọ́gọ́sị́ ĩ ní drĩ ꞌbụ̃ pi gbizú vũ be kuyé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ãꞌdiãtãsĩyã ẹ̃bị́rị́ kã ma fụụ́, ĩmi sẽkí má ní ngá nyanya, á nya rá. Yị̃ị́ úvá kã ma ndẽé, ĩmi sẽkí má ní yị̃ị́, á mvụ rá. Ma jãkãgú, ĩmi ẹ́ꞌyị́kí ma fií ĩmivé ꞌbẹ̃tị́ ãsámvú gé rá. ");
INSERT INTO kbo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Má kã adrií bõngó ãkó, ĩmi sẽkí má ní bõngó suú rá. Drã kã ma rụụ́, ĩmi kokí mâ ĩzã rá. Kâ ma ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá, ĩmi mụkí ma ndreé rá.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kúru ꞌbá tã ꞌoꞌbá pịrị rĩ pi ímụ́ újá má ní, kộpi ꞌyo, ‘Úpí, ꞌbá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ, ẹ̃bị́rị́ fụ mi gí, ꞌbá sẽkí mí ní ngá nyanya nyaá ngọ̃tụ́, dõku ꞌbá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ yị̃ị́ úvá ndẽ mi gí, ꞌbá sẽkí mí ní yị̃ị́ mvụụ́ ngọ̃tụ́? ");
INSERT INTO kbo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ꞌBá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ, mi jãkãgú, ꞌbá ẹ́ꞌyị́kí mi ífí ꞌbávé ꞌbẹ̃tị́ ãsámvú gé ngọ̃tụ́, dõku ꞌbá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ, mi bõngó ãkó, ꞌbá sẽkí mí ní bõngó suú ngọ̃tụ́? ");
INSERT INTO kbo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ꞌBá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ, mi drã rú, dõku ꞌbekí mi jó ĩ ní rizú ãngũ ũꞌyĩzú rĩ agá, ꞌbá mụkí mi ndreé ngọ̃tụ́?’ ");
INSERT INTO kbo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma ꞌbãgú rú, ma ímụ́ ꞌyo kộpi ní, ‘Ádarú á ꞌyo ĩmi ní ꞌdíni, tã ĩmi ní ꞌoó ꞌbá índréꞌbá kú ẹ̃zị́ ãkó rĩ pi ní ꞌdĩri, ĩmi ꞌokí tã ꞌdĩri má ní.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma ímụ́ ꞌyo ꞌbá mávé drị́ ị̃jị́ gé rĩ pi ní, ‘Ĩmi ngakí mụụ́ mâ gãrã gá ꞌdĩísĩ rá! Múngú tri ĩmi gí, ĩmi fikí ãcí vezú ãní ụ̃dụ̃ ãkó, ĩ ní údé ãdróko pi ní ívé índrí ũnjí rĩ pi be rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ãꞌdiãtãsĩyã ẹ̃bị́rị́ fụ ándúrú ma rá, ĩmi sẽkí má ní ngá nyanya nyaá kuyé. Yị̃ị́ úvá ndẽ ándúrú ma rá, ĩmi sẽkí má ní yị̃ị́ mvụụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma ándúrú jãkã, ĩmi ẹ́ꞌyị́kí ma fií ĩmivé ꞌbẹ̃tị́ ãsámvú gé kuyé. Ma ándúrú bõngó ãkó, ĩmi gãkí má ní bõngó sẽgá sĩ. Ma ándúrú drã rú, ãzini ꞌbekí ma jó ĩ ní rizú ãngũ ũꞌyĩzú rĩ agá, ĩmi gãkí mâ ĩzã kogá sĩ.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kộpi ímụ́ zị kínĩ, ‘Úpí, ꞌbá nị̃kí ngọ̃tụ́ ꞌyozú kínĩ ándúrú ẹ̃bị́rị́ fụ mi gí, dõku yị̃ị́ úvá ndẽ mi gí, dõku mi jãkãgú, dõku mi bõngó ãkó, dõku mi drã rú, dõku ꞌbekí mi jó ĩ ní rizú ãngũ ũꞌyĩzú rĩ agá, ꞌbá kokí mî ĩzã kuyé ngóni?’ ");
INSERT INTO kbo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma ímụ́ újá kộpi ní, ‘Ádarú á ꞌyo ĩmi ní ꞌdíni, tã ĩmi ní ꞌoó ꞌbá índréꞌbá kú ẹ̃zị́ ãkó rĩ pi ní kuyé rĩ, ĩmi ꞌokí kpá má ní kuyé.’ ");
INSERT INTO kbo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“ꞌBá tã ꞌoꞌbá pịrị ku rĩ pi, ĩ ímụ́ kộpi ĩrĩŋã ụ̃dụ̃ ãkó, ꞌbo ꞌbá tã ꞌoꞌbá pịrị rĩ pi, kộpi ímụ́ ídri ꞌdániꞌdáni rĩ ị́sụ́ rá.” ");
INSERT INTO kbo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yẹ́sụ̃ kã átángá rĩ átá dẹẹ́ gí, ĩri ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ĩmi nị̃kí rá, Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ ace nóni ụ́ꞌdụ́ ị̃rị̃, ma ꞌBá Mvá ꞌi, ĩ ímụ́ ma rụ sẽ ariꞌba rĩ pi drị́gé ụ́ꞌdụ́ ꞌdãri gé, kộpi ímụ́ ma gbã pẹtị alambaku sị́gé.” ");
INSERT INTO kbo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sâ ꞌdãri gé, atala atala rĩ pi drị̃gé rĩ pi, drị̃koma rĩ pi be, úmúkí ĩ átálágú ãmbúgú ĩ ní zịị́ Kãyáfã rĩ vé jó agá. ");
INSERT INTO kbo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kộpi rikí lẹ́tị ndãá kíri kíri Yẹ́sụ̃ ri rụzú, ĩ ꞌdịkí rí ĩri drãá ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kộpi ní ꞌyozú kínĩ, “Lẽ ꞌbâ rụkí ĩri ụ́ꞌdụ́ ụ̃mụ̃ nyazú rĩ gé ku, ãꞌdiãtãsĩyã ꞌbá rĩ pi ímụ́ íngá mgbárãsĩ ꞌbá drị̃gé gí.” ");
INSERT INTO kbo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yẹ́sụ̃ kã rií adrií Bẽtẽníyã gá Sị̃mọ́nã ũfú ní ándúrú nyaá rĩ vé ãngá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ũkú ãzi ní ímụ́zú ũdu ẹ̃jị́ be ngụ̃ụ́pi ndrị̃ndrị̃ ni be mãlãngĩ agá, ũdu rĩ ãjẽ be ãmbúgú, ũkú rĩ íꞌdụ́ ũdu rĩ ũdãá Yẹ́sụ̃ drị̃gé, ị́sụ́ ãkũdẽ Yẹ́sụ̃ ri ínyá nya. ");
INSERT INTO kbo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ tã ꞌdĩri ndreé, sẽ kộpi ẽ ẹ́sị́ ve rá. Kộpi ní zịzú kínĩ, “Ngá ũkú rĩ ní ũdu rĩ izazú ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ĩ té ũdu ꞌdĩri sẽ je ãjẽ be ãmbúgú, ĩ té ícó mũfẽngã ni awa ꞌbá ngá ãkó rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yẹ́sụ̃ kã tã kộpi ní ꞌyoó ꞌdĩri yịị́, ĩri ní ꞌyozú kĩnĩ, “Ngá ĩmi ní rizú unuzú ũkú ꞌdĩri vé tã sĩ rĩ ãꞌdi? Ngá ĩri ní ꞌoó má ní ꞌdĩri, ĩri tã múké. ");
INSERT INTO kbo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ĩmi njị̃ị́ ri adri ꞌbá ngá ãkó rĩ pi be, ꞌbo má ícó adrií ĩmi be caá sâ be ãco ku. ");
INSERT INTO kbo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ũdu ũkú rĩ ní dãá má drị̃gé ꞌdĩri, ĩri ri mâ rụ́ꞌbá údé, úmvúlésĩ ĩ ímụ́ ma sị̃ ãní ꞌbụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ pi rikí dõ ụ́ꞌdụ́kọ́ múké rĩ ũlũú mụzú vũ drị̃gé sĩ, kộpi kpá ímụ́ tã ũkú ꞌdĩri ní ꞌoó má ní rĩ ũlũ rá, ꞌbá rĩ pi ẽ ígákí rí ĩrivé tã ãní.” ");
INSERT INTO kbo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kúru Yẹ́sụ̃ vé ꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi vé ãlu, ĩ ní zịị́ Yụ́dã Ĩsĩkãrĩyótã ní ꞌdezú mụzú atala atala rĩ pi drị̃gé rĩ pi vúgá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ĩri ní zịzú kĩnĩ, “Á sẽ dõ Yẹ́sụ̃ ri rụụ́ ĩmi ní gí, ĩmi má ní ãꞌdi sẽ?” Kúru kộpi ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ni pi lãzú pụ̃kụ́ na, sẽzú ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Íꞌdózú sâ ꞌdãri gé, Yụ́dã íꞌdó rií lẹ́tị ndãá, ã rụkí rí Yẹ́sụ̃ ri ãní. ");
INSERT INTO kbo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ụ́ꞌdụ́ ĩ ní íꞌdózú Ụ̃mụ̃ ĩ ní Pánga ni ꞌBãá Údrá ku rĩ nyazú rĩ gé, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní ĩri zịzú kínĩ, “Mí lẽ ꞌbâ mụkí ínyá mí ní lẽé nyaá Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ áꞌdí íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi mụkí kụ̃rụ́ agá ꞌdaá, ĩmi ágó ãzi ị́sụ́, ĩmi ꞌyokí ĩri ní kínĩ, ‘Ímbápi kĩnĩ, mávé sâ ícó gí, á lẽ mụụ́ ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ nyaá ꞌbá mâ pámvú ũbĩꞌbá rĩ pi be mívé ãngá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kúru ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní mụzú tã rĩ ꞌozú sụ̃ Yẹ́sụ̃ ní lũú ĩ ní rĩ tị́nị, kộpi ní mụzú ínyá Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ áꞌdízú ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ụ̃tụ́ rĩ kã ꞌdeé, Yẹ́sụ̃ pi ní úrízú ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi be ínyá nyangárá gá. ");
INSERT INTO kbo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kộpi kâ rií ínyá rĩ nyaá, Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á ꞌyo ĩmi ní ꞌdíni, ꞌbá ãlu ĩmi ãsámvú gé ꞌdĩgé, ĩri ímụ́ mâ ũli ꞌbe nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tã ꞌdĩri sẽ ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ĩzãngã, ꞌbá ãlu ãlu íꞌdó rií ꞌyoó Yẹ́sụ̃ ní, “Úpí, ꞌbá déna ímụ́pi mî ũli ꞌbeépi rĩ ĩri ma ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “ꞌBá ꞌbá ní rií ngá nyaá ĩri be sákãnĩ ãlu agá rĩ ímụ́ mâ ũli ꞌbe nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma ꞌBá Mvá ꞌi, ma ímụ́ drã rá, sụ̃ ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ tị́nị. ꞌBo ĩzãngã rĩ úmvúlésĩ ímụ́ adri ágó mâ ũli ꞌbeépi rĩ vé ni, ĩ ímụ́ ĩri sẽ ꞌdị drã rá. ꞌBá tã ꞌoópi ꞌdíni ꞌdĩri, tịkí té dõ ĩri kuyé múké.” ");
INSERT INTO kbo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yụ́dã lẽépi Yẹ́sụ̃ ã ũli ꞌbeépi rĩ ní ĩri zịzú kĩnĩ, “Ímbápi, ꞌbá mí ní tã ni átá ꞌdĩri, mí ụ̃sụ̃ ꞌbá rĩ ma ꞌi?” Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ “Ẽ, ꞌbá rĩ mi ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kộpi kâ íꞌdó ínyá rĩ nyaá, Yẹ́sụ̃ ní pánga rĩ íꞌdụ́zú, ĩri ní õwõꞌdĩfô sẽzú, ĩri ní ꞌa ni ãndĩzú, ĩri ní sẽzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní, ĩri ní ꞌyozú kĩnĩ, “Ĩmi ꞌdụkí, ĩmi nyakí, ꞌdĩri rụ́ꞌbá mávé rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ĩri ní kópõ rĩ íꞌdụ́zú, ĩri ní õwõꞌdĩfô sẽzú Múngú ní, ĩri ní sẽzú kộpi ní, ĩri ní ꞌyozú kĩnĩ, “Ĩmi ãrẽvú céré, ĩmi mvụkí. ");
INSERT INTO kbo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ꞌDĩri mávé ãrí má ní ũndĩ rụzú ꞌbá kárákará pi be rĩ. Ãrí mávé dãápi vũgá ꞌdĩri ĩri sẽ Múngú ri ꞌbá rĩ pi trũ ĩvé ũnjĩkãnyã agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, má ícó gõó vị́nyọ̃ mvụụ́ dị̃ị́ ku, cĩmgbá cazú ụ́ꞌdụ́ má ní mụzú vị́nyọ̃ úꞌdí mvụzú ĩmi be trụ́ má Ẹ́tẹ́pị vé mãlũngã agá ꞌdãri gé.” ");
INSERT INTO kbo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kộpi kâ úngó ngoó, vụ́drị̃ ni gé, kộpi ní ꞌdezú mụzú Írã Õlívẽ vé rĩ drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kúru Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ị́nị́ŋá nõri sĩ, ĩmi céré ímụ́ nga ápá rá tã ímụ́pi ꞌi ngaápi mâ rụ́ꞌbá gá rĩ sĩ, ĩmi ma ku ọ́ꞌdụ́kụ́lẹ, ãꞌdiãtãsĩyã sĩkí Búkũ Múngú vé rĩ agá kínĩ, “ ‘Ma ímụ́ ꞌbá kãbĩlõ úcépi rĩ ꞌdị drã rá, kãbĩlõ rĩ pi ímụ́ ayi kpélékpélé.’ ");
INSERT INTO kbo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ꞌBo má kãdõ gõó íngá ídri rú, ma ꞌde mụzú ĩmi ẹndrẹtị gé sĩ drị̃drị̃, ꞌbâ mụ ꞌbâ ị́sụ́ ĩmi be ãngũ Gãlĩláyã vé rĩ gé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pétẽró ní ꞌyozú kĩnĩ, “ꞌBá rĩ pi dõ ápá tã ímụ́pi ꞌi ngaápi mî rụ́ꞌbá gá rĩ sĩ rá drãáãsĩyã, má ícó mi kuú ãluŋáni ku.” ");
INSERT INTO kbo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yẹ́sụ̃ ní újázú Pétẽró ní kĩnĩ, “Ádarú á lẽ ꞌyoó mí ní ꞌdíni, ị́nị́ŋá ãndrũ nõri sĩ, lõgúlõgú ní drĩ cẽré ꞌbezú kuyé rĩ gé, mi ímụ́ ma gã ca vú sĩ na, mi ꞌyo, ꞌí nị̃ ma kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pétẽró ní gõzú újázú kĩnĩ, “Má ícó ꞌyoó kínĩ á nị̃ mi kuyé ꞌdíni ku, ꞌbâ ũdrã mí be trụ́.” ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ã ụrụkọ céré átákí nyo sụ̃ Pétẽró ní átá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kúru Yẹ́sụ̃ ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be vũrã ĩ ní zịị́ Gẽtẽsẽmánĩ rĩ gé ꞌdãá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi úríkí ꞌdĩgé, ma drĩ mụ Múngú ri zị.” ");
INSERT INTO kbo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jị Pétẽró ri, ãzini Zẽbẽdáyõ ẹnjịpị́ị Yõkóbũ pi Yũwánĩ be mụzú ꞌí vúgá sĩ ĩndĩ. Ĩzãngã íꞌdó fií ẹ́sị́ ni agá ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ĩri ní ꞌyozú kĩnĩ, “Ĩzãngã ŋõ mâ ẹ́sị́ drãdrã ẽ tị ị́sụ́. Ĩmi adrikí ꞌdĩgé, lẽ ĩmi adrikí mị be mgbọ.” ");
INSERT INTO kbo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yẹ́sụ̃ kã mụụ́ vụ̃ụ́ mãdã, ĩri ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá, ĩri ní Múngú ri zịzú kĩnĩ, “Má Ẹ́tẹ́pị, ícó dõ rá, mî ku ma rií ĩzãngã nyaá nóni ku. ꞌBo lẽ tã rĩ ã nga ꞌi sụ̃ mî ẹ́sị́ ní lẽé rĩ tị́nị, ã adri sụ̃ má ní lẽé rĩ tị́nị ku.” ");
INSERT INTO kbo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yẹ́sụ̃ kã ꞌi újá gõó vúlé ívé ꞌbá ꞌî pámvú ũbĩꞌbá na rĩ pi vúgá ꞌdãá, ị́sụ́ kộpi ri ụ́ꞌdụ́ ko. Ĩri ní ꞌyozú Pétẽró ní kĩnĩ, “Ĩmi ícókí nyo adrií caá sâ ãlu mị be mgbọ ku? ");
INSERT INTO kbo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lẽ ĩmi adrikí mị be mgbọ, ĩmi zịkí Múngú ri, tã ũnjí ã ụ̃ꞌbị̃ rí ĩmi ku. Ĩmî ẹ́sị́ lẽ kõdô Múngú ri zịị́ rá, ꞌbo rụ́ꞌbá gá, ĩmi mũnyámúnya.” ");
INSERT INTO kbo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yẹ́sụ̃ ní gõzú mụzú Múngú ri zịzú dị̃ị́, ĩri ní ꞌyozú kĩnĩ, “Má Ẹ́tẹ́pị, ꞌí ꞌdụ dõ ĩzãngã nõri mâ rụ́ꞌbá gá sĩ kuyé, múké ni, lẽ mâ nya ĩzãngã rĩ mụzú ĩyí, tã mî ẹ́sị́ ní lẽé rĩ ã nga ꞌi ĩyí.” ");
INSERT INTO kbo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yẹ́sụ̃ kã gõó ímụ́, ị́sụ́ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi kokí ụ́ꞌdụ́ kpílíkpílí, ãꞌdiãtãsĩyã ụ́ꞌdụ́ rĩ ŋõ kộpi ẽ mị ambamba. ");
INSERT INTO kbo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Vú na ni gé, gõ kpá kộpi kuú ꞌdĩgé, ꞌde mụụ́ Múngú ri zịị́ ĩri ní té zịị́ drị̃drị̃ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ĩri ní ꞌi újázú ĩgõzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi drĩ ri ụ́ꞌdụ́ rĩ koko, ãzini ĩmi ri ãndẽ vu? Ĩmi ndrekí, sâ rĩ ícá ĩnyiŋá gí, ĩ ímụ́ ꞌBá Mvá ri rụ sẽ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi drị́gé. ");
INSERT INTO kbo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ĩmi íngákí ụrụ, ꞌbâ mụkí! ꞌBá lẽépi mâ ũli ꞌbeépi rĩ ícá ĩnyiŋá gí!” ");
INSERT INTO kbo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yẹ́sụ̃ kã rií átá, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi vé ãlu Yụ́dã ní ícázú, ꞌbá bị́trị́ká ímụ́kí vú ni gé sĩ, kộpi céré ị́lị́ ãco ãco ni pi be ĩ drị́gé sĩ, ãzini túré pi be ĩ drị́gé sĩ. Atala atala rĩ pi drị̃gé rĩ pi, ãzini ꞌbá drị̃koma rú rĩ pi be ĩpẽkí ꞌbá ꞌdĩꞌbée ímụ́zú nĩ. ");
INSERT INTO kbo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yụ́dã lũ kộpi ní tã rĩ drị̃drị̃ kĩnĩ, “Má uꞌde dõ ꞌbá rĩ ẹzịị́ bẹ̃drị̃ sĩ, ágó rĩ adriípi ꞌdĩ, ĩmi rụkí ĩri.” ");
INSERT INTO kbo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kúru Yụ́dã ní mụzú Yẹ́sụ̃ vúgá ꞌdãá, ĩri ní ꞌyozú, “Ímbápi, mõdó mí ní!” Ĩri ní kúru Yẹ́sụ̃ ri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ũndĩgó, mí ímụ́ gí, ꞌí ꞌo tã mí ní lẽé ꞌoó rĩ.” Ãgõ ụrụkọꞌbée ní kúru ímụ́zú Yẹ́sụ̃ ri uꞌdezú rụzú. ");
INSERT INTO kbo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi vé ãlu ní ívé ị́lị́ ãco rĩ ínjézú, ĩri ní átálágú ãmbúgú rĩ vé ãtíꞌbá ẽ bị́ gazú mvọ́rụ́ ꞌdezú vũgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ su mívé ị́lị́ ãco rĩ gõó ívé vũrã gá ꞌdãá ũzi. ꞌBá céré ãngũ úꞌdị́ꞌbá drãꞌbée ị́lị́ ãco sĩ rĩ pi, ĩ kpá ímụ́ kộpi úꞌdị́ ũdrã ị́lị́ ãco sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mí ụ̃sụ̃ má ícó má Ẹ́tẹ́pị ri zịị́, ícó má ní mãlãyíkã ẹ̃ꞌdị́ ꞌdịꞌbée ngúlúmũ mụdrị́ drị̃ ni ị̃rị̃ ĩpẽé ímụ́ mâ ĩzã koó úꞌdíkírĩŋá nõgó ku? ");
INSERT INTO kbo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ꞌBo á ꞌo dõ tã rĩ ꞌdíni, tã Búkũ Múngú vé rĩ ní átá ꞌdĩri ã nga rí ꞌi fũú tị ni gé ngóni?” ");
INSERT INTO kbo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sâ ꞌdãri gé, Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, “Ĩmi ri ímụ́ ị́lị́ ãco ãco ni pi be, túré be, ĩmi lẽkí ímụ́ ma rụụ́, ĩmi ụ̃sụ̃kí ma ꞌbá ũnjí riípi ẹ̃ꞌdị́ ꞌdịị́pi ꞌbá ãngũ rụụ́pi ni pi be ni? Ụ́ꞌdụ́ céré, á ri ꞌbá rĩ pi ímbá Jó Múngú vé rĩ ã bóró gá ꞌdãá, ꞌbo ĩmi rụkí ma kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ꞌBo tã ꞌdĩri nga ꞌi ꞌdíni, tã nẹ́bị̃ rĩ pi ní sĩí Búkũ Múngú vé rĩ agá rĩ, ã nga rí ꞌi fũú tị ni gé bẽnĩ.” Kúru ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní ngazú ápázú ꞌdĩísĩ rá, kukí Yẹ́sụ̃ ri kú ọ́ꞌdụ́kụ́lẹgúsĩ. ");
INSERT INTO kbo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ꞌBá Yẹ́sụ̃ ri rụꞌbá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú Kãyáfã vé ãngá ꞌdãá, Kãyáfã ri átálágú ãmbúgú. ꞌBá tãị́mbị́ ímbáꞌbá rĩ pi, ambugu Yãhụ́dị̃ rĩ pi vé rĩ pi be, kộpi ri ĩ úmú ĩrivé ãngá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ꞌBo Pétẽró ꞌde mụzú Yẹ́sụ̃ vúgá sĩ, kộpi rikí mụụ́ ãsámvú sĩ, cĩmgbá ĩri ní cazú átálágú ãmbúgú rĩ vé bóró gá ꞌdãá. Ĩri ní fizú bóró agá ꞌdãá, ĩri ní úrízú ꞌbá ãngũ ũtẽꞌbá rĩ pi be trụ́, lẽ tẽé ndreé dõ tã Yẹ́sụ̃ vé rĩ ã ụ̃dụ̃ ĩri adri ngóni. ");
INSERT INTO kbo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tã lịꞌbá rĩ pi be, kộpi lẽkí tã ũnjõ vé ni ndãá ị́sụ́ Yẹ́sụ̃ rụ́ꞌbá gá, ĩ ꞌdịkí rí ĩri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ꞌBá kárákará ã átákí dõ tã rĩ ũnjõ sĩ Yẹ́sụ̃ rụ́ꞌbá gá drãáãsĩyã, kộpi ị́sụ́kí tã ãzi ĩ ní ícózú Yẹ́sụ̃ ri ꞌdịzú ni kuyé. Ụ̃dụ̃ ni gé, ꞌbá ị̃rị̃ pi ímụ́kí pá tuú, ");
INSERT INTO kbo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kộpi kínĩ, “Ágó ꞌdĩri ꞌyo ándúrú kĩnĩ, ‘Ma Jó Múngú vé rĩ ũsị̃ vũgá, ma gõ sị ụ́ꞌdụ́ na agá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Átálágú ãmbúgú rĩ ní íngázú pá tuzú ụrụ sĩ, ĩri ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Tã ãgõ ꞌdĩꞌbée ní rií ũmbĩí mí drị̃gé kárákará ꞌdĩꞌbée, ꞌí ꞌyo átángá mí tị gé sĩ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ꞌBo Yẹ́sụ̃ újí ꞌî kíri. Átálágú ãmbúgú rĩ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ sõ ũyõ Múngú adriípi ídri rú rĩ ẹndrẹtị gé, ꞌí lũ ꞌbá ní, mi Kúrísítõ Múngú Mvọ́pị ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Tã mí ní átá ꞌdĩri pịrị. Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ma ꞌBá Mvá ꞌi, úmvúlésĩ ĩmi ímụ́ ma ndre, ma úrí Múngú Ũkpõ ꞌDị́pa vé drị́ ẹ̃ndẹ́pị gé, ma ĩgõ ímụ́ ꞌbụ̃ gé ꞌdãásĩ vũgá nõó ị́rị́bị́tị agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Átálágú ãmbúgú rĩ ã ꞌa ve ũnjí ũnjí, rụ ívé bõngó ãsĩí, ĩri ní ꞌyozú kĩnĩ, “Ágó nõri ide Múngú ri! Ngá ꞌbá ní ꞌbá ãzi lẽzú ẽ ímụ́ ágó ꞌdĩri vé tã ũlũú rĩ ãꞌdi? Ĩmi yịkí tã ágó rĩ ní Múngú ri idezú rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ĩmi lẽkí ã lịkí tã drị̃ ni gé íngóni?” Kộpi ní újázú kínĩ, “Ágó ꞌdĩri, lẽ ã ꞌdịkí ĩri drãá rá.” ");
INSERT INTO kbo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kộpi ní tụ̃sụ́ úwézú ẹndrẹtị ni gé, kộpi ní ꞌdezú ĩri ũgbãzú. Ụrụkọꞌbée ní ĩri usazú. ");
INSERT INTO kbo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kộpi ní ꞌyozú ĩri ní kínĩ, “Kúrísítõ, mí ámá, ãꞌdi gbã mi nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sâ ꞌdãri gé, Pétẽró úrí kuú ãmvé jó rizú tã lịzú rĩ ã bóró gá ꞌdãá, mvá ũkú ãzi ãtíꞌbá rú ni ní ímụ́zú, ĩri ní ꞌyozú Pétẽró ní kĩnĩ, “Ĩmi rikí ándúrú adrií Yẹ́sụ̃ adriípi Gãlĩláyãgú rĩ be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pétẽró ní gãzú ꞌbá rĩ pi ẹndrẹtị gé ꞌdĩgé kĩnĩ, “Á nị̃ kuyé mi dõ ri tã ngõri átá!” ");
INSERT INTO kbo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kúru Pétẽró ní ꞌdezú mụzú kání rĩ vé kẹ̃ẹ́tịlé gá ꞌdãá, mvá ũkú ãzi ní ĩri ndrezú, mvá ũkú rĩ ní ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “Ágó nõri, kộpi rikí ándúrú adrií Yẹ́sụ̃ Nãzẽrétãgú rĩ be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pétẽró gõ kpá gãá dị̃ị́, ĩri ní ũyõ sõzú kĩnĩ, “Á nị̃ mâ ágó ꞌdĩri kuyé!” ");
INSERT INTO kbo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kã adrií mãdã, vụ́drị̃ ni gé, ꞌbá ụrụkọꞌbée pá tuꞌbá ꞌdãlé rĩ pi ní ímụ́zú Pétẽró vúgá nõó, kộpi ní ꞌyozú kínĩ, “ꞌBá nị̃kí rá, mi ꞌbá ꞌdĩꞌbée vé ọ́gụ́pị. Ụ́ꞌdụ́kọ́ mí ní rizú átázú rĩ lũ ꞌbá ní kínĩ, mi Gãlĩláyãgú.” ");
INSERT INTO kbo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pétẽró ní ꞌi trizú ũgõgõlé rú kĩnĩ, “Múngú ã sẽ mâ ị́sụ́ drị̃lé ũnjí, á nị̃ mâ ágó ꞌdĩri kuyé.” Koro lõgúlõgú ní cẽré ꞌbezú. ");
INSERT INTO kbo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pétẽró ní tã Yẹ́sụ̃ ní ándúrú ꞌyoó ꞌí ní, “Lõgúlõgú ní drĩ cẽré ꞌbézú kuyé rĩ gé, mi ma gã ca vú na” ꞌdãri ã tã ígázú. Kúru Pétẽró ní fũzú mụzú ãmvé ꞌdãá, ĩri ní íꞌdózú ngozú mádrã mádrã rú. ");
INSERT INTO kbo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ụ̃bụ́tị kụ̃nị̃kụ̃nị̃, atala atala rĩ pi drị̃gé rĩ pi, ꞌbá ambugu rĩ pi be céré, úmúkí tị trụ́, kộpi lẽkí ã ꞌdịkí Yẹ́sụ̃ ri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kộpi ũdrõkí ĩri, jịkí ĩri mụzú Pĩlátõ ẹndrẹtị gé, Pĩlátõ ri gávãnã. ");
INSERT INTO kbo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yụ́dã Yẹ́sụ̃ ã ũli ꞌbeépi rĩ kã ndreé lịkí Yẹ́sụ̃ vé tã, lẽkí ĩri ꞌdịị́ꞌdị, tã rĩ sẽ ĩri ní ĩzãngã ãmbúgú, ĩri ní mũfẽngã fífí pụ̃kụ́ na rĩ újázú gõzú atala atala rĩ pi drị̃gé rĩ pi ní ꞌbá ambugu rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ĩri ní ꞌyozú kĩnĩ, “Á ꞌo ũnjĩkãnyã ꞌbá tã ũnjí ꞌoópi kuyé ni ã ũli ꞌbezú.” Kộpi ní újázú ĩri ní kínĩ, “Tã ꞌdĩri adri tã ꞌbávé ni ku, tã ꞌdĩri mi pá tu tị́ ni gé nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yụ́dã ní mũfẽngã rĩ ꞌbezú ꞌí drị́gé sĩ Jó Múngú vé rĩ agá ꞌdãá, ĩri ní ꞌdezú mụzú ꞌi ꞌyĩzú bãákú sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Atala atala rĩ pi drị̃gé rĩ pi ní mũfẽngã fífí rĩ pi uꞌdụzú, kộpi ní ꞌyozú kínĩ, “Tãị́mbị́ ãꞌyĩ ku ĩ ní mũfẽngã ꞌdĩri ꞌbãzú jó ĩ ní rizú mũfẽngã ꞌbãzú rĩ agá, ãꞌdiãtãsĩyã mũfẽngã ꞌdĩri dãkí ãní ãrí gí.” ");
INSERT INTO kbo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kộpi ụ̃sụ̃kí kínĩ, mũfẽngã ꞌdĩri sĩ, lẽ ã jekí vũrã ãní, ꞌbá ímụ́ꞌbá jãkã rú rĩ pi kádõ ũdrãá, ã sị̃kí rí kộpivé ãvũ ãní. ");
INSERT INTO kbo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cĩmgbá ãndrũ sĩ, zịkí vũrã rĩ ã rụ́, Vũrã Ãrí vé ni. ");
INSERT INTO kbo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tã ọ́tụ́ nẹ́bị̃ Yẽrẽmíyã ní ꞌyoó rĩ, nga ꞌi fũú tị ni gé gí kĩnĩ, “Kộpi ꞌdụkí mũfẽngã fífí pụ̃kụ́ na, ꞌbá Ĩsẽrélẽ vé rĩ pi kínĩ ꞌbá rĩ rụ dõ ĩri gí, ĩ mũfẽngã ꞌdĩri sẽ ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mũfẽngã rĩ sĩ, kộpi jekí vũrã ꞌbá riípi ụ̃rụ́tẹ́ ũdrí gbizú ni vé ni ãní, sụ̃ Úpí ní ẹzịị́ má ní rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yẹ́sụ̃ kã pá tuú gávãnã Pĩlátõ ẹndrẹtị gé ꞌdãá, Pĩlátõ ní ĩri zịzú kĩnĩ, “Mi nyo ꞌbãgú Yãhụ́dị̃ rĩ pi vé rĩ?” Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Tã rĩ mí ní ꞌyoó gí ꞌdĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá ambugu rĩ pi be, kộpi kâ ĩri tõó, Yẹ́sụ̃ zị̃ ꞌî tị átángá ꞌyozú kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pĩlátõ ní ĩri zịzú kĩnĩ, “ꞌÍ yị tã ꞌbá rĩ pi ní rií ꞌyoó mî rụ́ꞌbá gá ũnjí ꞌdĩri kuyé?” ");
INSERT INTO kbo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ꞌBo Yẹ́sụ̃ újá ĩri ní átángá ãluŋáni kuyé, sẽ gávãnã ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mẽrẽ gávãnã vé rĩ gé, kádõ rií Ụ̃mụ̃ Múngú ní Ẹlịzú Jó tị gé sĩ rĩ nyaá, ꞌbá bị́trị́ká rĩ pi ꞌbá ĩ ní ũꞌyĩí kuú jó ãngũ ũꞌyĩzú rĩ agá rĩ pi vé ãlu ĩpẽ, ĩ ĩri ọyụ ĩfũ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sâ ꞌdãri gé, ágó ãzi rụ́ be kụụ́pi tã ũnjí sĩ ni ꞌyĩkí ĩri kú jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá, ágó rĩ ã rụ́ Bãrãbã ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ꞌBá bị́trị́ká rĩ pi kâ ĩ úmú Pĩlátõ vé ãngá ꞌdãá, Pĩlátõ ní kộpi zịzú kĩnĩ, “Ĩmi lẽkí mâ ọyụ ĩmi ní ãꞌdi ri sẽé? Mâ ọyụ Bãrãbã ri sẽé, dõku mâ ọyụ Yẹ́sụ̃ ĩ ní zịị́ Kúrísítõ ri sẽé?” ");
INSERT INTO kbo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pĩlátõ nị̃ rá ꞌyozú kínĩ, Yãhụ́dị̃ ambugu rĩ pi íjị́kí Yẹ́sụ̃ ri ꞌí ẹndrẹtị gé nõó, ãꞌdiãtãsĩyã kộpi ꞌbãkí ẹ́sị́ ũnjí Yẹ́sụ̃ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pĩlátõ kã úrí ívé lúpá tã lịzú rĩ drị̃gé, ũkú ni ní ụ́ꞌdụ́kọ́ pẽzú vú ni gé ꞌdãá kĩnĩ, “Ágó tã ũnjí ꞌoópi kuyé ꞌdãri, ã ꞌokí ĩri ũnjí ku, ị́nị́ŋá ãndrũ rĩ sĩ, urobí ũbĩ ma ĩrivé tã sĩ, mâ ẹ́sị́ ị́sụ́ ãní ĩzãngã ambamba.” ");
INSERT INTO kbo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ꞌBo atala atala rĩ pi drị̃gé rĩ pi, ꞌbá ambugu rĩ pi be, rikí ꞌbá bị́trị́ká rĩ pi ẽ drị̃ ụ́cị́ kínĩ, kộpi ã ꞌyokí, ã ọyụkí Bãrãbã ri áyu, ã ꞌdịkí Yẹ́sụ̃ ri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kúru gávãnã Pĩlátõ ní ꞌbá bị́trị́ká rĩ pi zịzú kĩnĩ, “ꞌBá ị̃rị̃ ꞌdĩꞌbée ãsámvú gé, ĩmi lẽkí mâ ọyụ ĩmi ní ãꞌdi ri sẽé?” Kộpi ní újázú kínĩ, “Mí ọyụ Bãrãbã ri áyu.” ");
INSERT INTO kbo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pĩlátõ ní kộpi zịzú kĩnĩ, “Kúru Yẹ́sụ̃ ĩ ní zịị́ Kúrísítõ ꞌdĩri, mâ ꞌo ĩri ãꞌdi rú?” Kộpi ní céré újázú kínĩ, “Ã gbãkí ĩri pẹtị alambaku sị́gé!” ");
INSERT INTO kbo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pĩlátõ ní kộpi zịzú kĩnĩ, “Ãsĩ? Tã ũnjí ĩri ní ꞌoó rĩ ãꞌdi?” Kộpi gõkí ọ́ꞌụ́ ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ã gbãkí ĩri pẹtị alambaku sị́gé.” ");
INSERT INTO kbo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pĩlátõ kã ndreé tã ãzi ꞌí ní ícó ꞌoó ni ꞌdãáyo, ꞌbá rĩ pi lẽkí íngá mgbárãsĩ, ĩri ní yị̃ị́ íꞌdụ́zú ꞌî drị́ ũjĩzú ꞌbá bị́trị́ká rĩ pi ẹndrẹtị gé ꞌdĩgé. Ĩri ní ꞌyozú kĩnĩ, “Ágó nõri vé ãrí, tã ni adri má drị̃gé ku, tã ni ri adri ĩmi drị̃gé!” ");
INSERT INTO kbo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ꞌBá rĩ pi ní céré újázú kínĩ, “Ĩrivé ãrí, tã ni ã adri ꞌbá drị̃gé, ãzini ꞌbávé anjiŋá rĩ pi drị̃gé!” ");
INSERT INTO kbo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kúru Pĩlátõ ní Bãrãbã ri ọyụzú. Ĩri ní tãị́mbị́ sẽzú ívé ãngáráwá rĩ pi ní, kộpi ã ũgbãkí Yẹ́sụ̃ ri, kộpi ã gbãkí ĩri pẹtị alambaku sị́gé. ");
INSERT INTO kbo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kúru gávãnã Pĩlátõ vé ãngáráwá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú vũrã ĩvé rĩ gé ꞌdãá, kộpi ní ãngáráwá rĩ pi úmúzú céré, kộpi trakí ĩ Yẹ́sụ̃ ã gãrã gá sĩ kụ́rụ̃. ");
INSERT INTO kbo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kộpi njekí ĩrivé bõngó akoóko rụ̃kụ̃ rĩ rụ́ꞌbá ni gé sĩ, kộpi sukí bõngó ika ãco ni rụ́ꞌbá ni gé, ");
INSERT INTO kbo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kộpi údékí ũcékúcé suú drị̃ ni gé kụ̃lá rú. Kộpi ꞌbãkí túré ĩrivé drị́ ẹ̃ndẹ́pị gé, kộpi ũtị̃kí kũmũcí ĩri ẹndrẹtị gé, kộpi ní ĩri ẽ drị̃ ínjázú ꞌyozú kínĩ, “ꞌBãgú Yãhụ́dị̃ rĩ pi vé rĩ, ꞌbá ị̃njị̃kí mi rá!” ");
INSERT INTO kbo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kộpi úwékí tụ̃sụ́ rụ́ꞌbá ni gé, kộpi íꞌdụ́kí túré ĩri drị́gé rĩ, rikí ĩri ẽ drị̃ ũgbãá ãní. ");
INSERT INTO kbo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kộpi kâ ĩri ẽ drị̃ ínjá, kộpi ní bõngó akoóko rụ̃kụ̃ rĩ njezú rụ́ꞌbá ni gé sĩ, kộpi gõkí ĩrivé bõngó suú ĩri rụ́ꞌbá gá ꞌdãá ũzi. Kúru kộpi ní ĩri jịzú mụzú, ã mụkí rí ĩri gbãá pẹtị alambaku sị́gé. ");
INSERT INTO kbo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kộpi kâ rií ꞌdeé mụzú, kộpi cakí ágó ãzi ị́sụ́, ágó rĩ íbí ímụ́ Kũrénẽ gélésĩla, ágó rĩ ã rụ́ Sị̃mọ́nã ꞌi. Kộpi mĩkí ágó rĩ pẹtị alambaku Yẹ́sụ̃ vé rĩ ꞌdụụ́ mụzú. ");
INSERT INTO kbo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kộpi ní cazú vũrã ĩ ní zịị́ Gõlõgótã rĩ gé ꞌdãá, (Gõlõgótã vé ífífí, vũrã drị̃ kọ́lọ̃mgbọ́ vé ni). ");
INSERT INTO kbo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kộpi ní vị́nyọ̃ usazú ngá drãápi ụ̃kẹ́ngẹlị ni sĩ, sẽzú Yẹ́sụ̃ ní, ã mvụ, Yẹ́sụ̃ kã ngá rĩ ꞌbị̃ị́, gã mvụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kộpi kâ ĩri gbãá pẹtị alambaku sị́gé ꞌdãá gí, kộpi ꞌbekí ĩrivé bõngó jẽké sĩ, awakí ĩ ní. ");
INSERT INTO kbo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kúru kộpi ní úrízú vũgá, kộpi tẽkí rií ĩri ndreé. ");
INSERT INTO kbo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kộpi sĩkí tã ĩ ní ĩri tõzú rĩ gbãá ĩri drị̃lé gá ụrụ ꞌdãá, kộpi sĩkí tã rĩ ꞌdíni, ꞌDĨRI YẸ́SỤ̃, ꞌBÃGÚ YÃHỤ́DỊ̃ RĨ PI VÉ RĨ. ");
INSERT INTO kbo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Gbãkí ụ̃gụ́ꞌbá ị̃rị̃ pẹtị alambaku sị́gé Yẹ́sụ̃ be trụ́, gbãkí ãzi rĩ ĩrivé drị́ ẹ̃ndẹ́pị gélésĩla, ãzi rĩ ĩrivé drị́ ị̃jị́ gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ꞌBá riꞌbá ẹlịꞌbá ẹlị ẹlị rĩ pi rikí ĩri uꞌdaá, kộpi rikí ĩ drị̃ yaá ĩri idezú ãní, ");
INSERT INTO kbo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kộpi rikí ꞌyoó kínĩ, “Mi ándúrú ꞌyoópi, mi Jó Múngú vé rĩ ĩŋãnyã, mi gõ sị̃ ụ́ꞌdụ́ na agá rĩ, mí dõ Mvá Múngú vé ni, ꞌí pa mi! Mí ísị́ pẹtị alambaku rĩ sị́gé sĩ vũgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi, ãzini ꞌbá ambugu rĩ pi, rikí kpá Yẹ́sụ̃ ẽ drị̃ ínjá. ");
INSERT INTO kbo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kộpi kínĩ, “Ídrí ꞌbá ụrụkọꞌbée rá pírí, ꞌbo ídrí ꞌi ngúlúpí ku ãsĩ? Ĩri dõ ꞌbãgú Ĩsẽrélẽ rĩ pi vé ni, ẽ ísị́ pẹtị alambaku rĩ sị́gé sĩ vũgá nõó, kúru ꞌbâ ĩri ẹ̃ꞌyị̃ rá. ");
INSERT INTO kbo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ꞌBã ívé ẹ́sị́ céré Múngú drị̃gé. Lẽ Múngú ẽ ídrí ĩri, dõ Múngú lẽ ĩri rá, ãꞌdiãtãsĩyã ꞌyo ꞌdíni kĩnĩ, ‘Ma Mvá Múngú vé ni.’ ” ");
INSERT INTO kbo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ụ̃gụ́ꞌbá ĩ ní gbãá ĩri be trụ́ rĩ pi rikí kpá ĩri ẽ drị̃ ínjá ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Íꞌdózú ụ̃tụ́ mgbímgbi gé ꞌdĩgé, cazú sâ na ũndréŋá vé rĩ gé, ãngũ rĩ bĩ nịị́ kuú cịcị. ");
INSERT INTO kbo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kã mụụ́ caá sâ na gá, Yẹ́sụ̃ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Ẹ̃lọ́yị̃, Ẹ̃lọ́yị̃, lãmã sãbãkãtánĩ?” Ífífí ni kĩnĩ, “Múngú mávé rĩ, Múngú mávé rĩ, ngá mí ní ma adizú rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ꞌBá pá tuꞌbá ꞌdãlé rĩ pi kâ tã ĩri ní ꞌyoó rĩ yịị́, kộpi kínĩ, “Ĩri ri Ẽlíyã ri zị.” ");
INSERT INTO kbo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Koro kộpi ãsámvú gé ꞌdĩgé, ꞌbá ãlu ní njuzú lífã íꞌdụ́zú, ĩri ní suzú vị́nyọ̃ údrápi gí ni agá, ĩri ní suzú pẹtị sị́gé, ĩri ní suzú mụzú Yẹ́sụ̃ vúgá ụrụ ꞌdãá, Yẹ́sụ̃ ã mvụ. ");
INSERT INTO kbo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ꞌBá rĩ pi ụrụkọꞌbée kínĩ, “Ĩ kukí ĩri ọ́ꞌdụ́kụ́lẹ, Ẽlíyã ri dõ ímụ́ ĩri ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yẹ́sụ̃ gõ treé dị̃ị́ ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, ĩrivé índrí ní kúru fũzú. ");
INSERT INTO kbo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sâ ꞌdãri gé, bõngó ĩ ní Jó Múngú vé rĩ ã ꞌa ẹlịzú rĩ ãsĩ ꞌi ị̃rị̃, íꞌdózú ụrụ ꞌdãá, cĩmgbá vũgá nõó. Nyọ̃ọ́kụ́ rĩ aya ꞌi dĩngídĩngí, írã rĩ pi undakí ĩ kpélékpélé. ");
INSERT INTO kbo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ꞌBụ́ ãvũ sị̃zú rĩ pi zịkí ĩ tị kú mgbọ, ꞌbá kárákará Múngú ri ẹ̃ꞌyị̃ꞌbá, ũdrãꞌbá gí rĩ pi, ingakí kộpi gõó ídri rú ũzi. ");
INSERT INTO kbo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kộpi ĩfũkí ꞌbụ́ rĩ pi agásĩ ãmvé. Yẹ́sụ̃ kã íngá gõó ídri rú gí, kộpi ꞌdekí mụzú kụ̃rụ́ uletere Yẹ̃rụ́sãlémã vé rĩ gé ꞌdãá, kộpi iꞌdakí ĩ ꞌbá kárákará pi ẹndrẹtị gé rá. ");
INSERT INTO kbo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ũgalaku rĩ pi ívé ãngáráwá Yẹ́sụ̃ ri ũtẽꞌbá rĩ pi be, kộpi kâ ãngũ ꞌi ayaápi dĩngídĩngí ꞌdĩri ndreé, sẽ kộpi ní ụ̃rị̃ ambamba, kộpi kínĩ, “Ádarú ágó nõri Mvá Múngú vé ni!” ");
INSERT INTO kbo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ũkú kárákará tukí pá kuú rárá rú, kộpi tẽkí nyo rií ndreé. Ũkú ꞌdĩꞌbée íbíkí ímụ́ Yẹ́sụ̃ be trụ́ ãngũ Gãlĩláyã vé rĩ gálésĩla, kộpi lẽkí Yẹ́sụ̃ ẽ ĩzã koó. ");
INSERT INTO kbo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kộpi ãsámvú gé ꞌdãá, ꞌbá rĩ Mãríyã Mãgãdẽlénã ꞌi, Mãríyã Yõkóbũ pi vé ẹ́ndrẹ́pị Yõsépã be rĩ ꞌi, ãzini Zẽbẽdáyõ ẹnjịpị́ị vé ẹ́ndrẹ́pị sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ũndréŋá ꞌdãri sĩ, Ãrĩmãtáyõgú ãzi ãꞌbú be ni, rụ́ ni Yõsépã ꞌi, ĩri ándúrú ꞌbá Yẹ́sụ̃ ã pámvú ũbĩípi ni. ");
INSERT INTO kbo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ĩri ní ꞌdezú mụzú Pĩlátõ vúgá ꞌdãá, ĩri ní Yẹ́sụ̃ vé ãvũ ã tã zịzú Pĩlátõ tị gé, Pĩlátõ ní tãị́mbị́ sẽzú kĩnĩ, ã ọyụkí ãvũ rĩ sẽé ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yõsépã ní ãvũ rĩ ꞌdụzú, ĩri ní ĩmũlũzú bõngó múké ule ni sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ĩri ní ãvũ rĩ jịzú sị̃zú ívé ꞌbụ́ ꞌí ní gaá lũú írã agá rĩ agá. Ĩri ní írã ãmbúgú ni gũzú ꞌbãzú ꞌbụ́ rĩ tị gé, ĩri ní kúru ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mãríyã Mãgãdẽlénã pi Mãríyã ãzi rĩ be úríkí kuú ꞌbụ́rẹ̃drị̃ rĩ ã gãrã gá, kộpi tẽkí rií ndreé. ");
INSERT INTO kbo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kã mụụ́ adrií drụ̃ ꞌdíni, ụ́ꞌdụ́ Sãbátã vé rĩ gé, atala atala rĩ pi drị̃gé rĩ pi, Fãrụ́sị̃ rĩ pi be, kộpi ní ꞌdezú mụzú Pĩlátõ vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kộpi ní ꞌyozú kínĩ, “Ãmbúgú ꞌbávé rĩ, ꞌbá ígákí tã ágó ũnjó rú rĩ ní ándúrú ꞌyoó lókí ĩri ní drĩ adrizú ídrí rú rĩ gé ꞌdãri gí kĩnĩ, ‘Ụ́ꞌdụ́ na ã vụ́drị̃ gé, ma gõ íngá ídri rú ũzi.’ ");
INSERT INTO kbo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kúru lẽ mî sẽ tãị́mbị́, ã ũtẽkí ꞌbụ́rẹ̃drị̃ rĩ caá ụ́ꞌdụ́ na. ꞌÍ ꞌo dõ ꞌdíni ku, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ímụ́ ĩrivé ãvũ ụ̃gụ̃ rá, kộpi ímụ́ ꞌyo ꞌbá rĩ pi ní, íngá gõó ídri rú gí. Ũnjõ vúlé ꞌdĩri, ĩri ímụ́ drị̃drị̃ ꞌdãri aga rá.” ");
INSERT INTO kbo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pĩlátõ ní ꞌyozú kĩnĩ, “Ĩmi pẽkí ãngáráwá rĩ pi mụụ́ ꞌbụ́rẹ̃drị̃ rĩ ũtẽé sụ̃ ĩmi ní nị̃ị́ gí rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kúru kộpi ní ꞌdezú mụzú ꞌbụ́rẹ̃drị̃ rĩ ũtẽzú, kộpi ní írã rĩ gũzú ꞌbãzú ꞌbụ́ rĩ tị gé, kộpi ní mbĩzú ụ̃drị sĩ, kộpi ní ãngáráwá rĩ pi ꞌbãzú rizú ꞌbụ́rẹ̃drị̃ rĩ ũtẽzú. ");
INSERT INTO kbo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ụ́ꞌdụ́ Sãbátã vé rĩ ã vụ́drị̃ gé, kã adrií Yĩngã sĩ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, Mãríyã Mãgãdẽlénã pi Mãríyã ãzi rĩ be, ꞌdekí mụụ́ ꞌbụ́rẹ̃drị̃ rĩ ndreé. ");
INSERT INTO kbo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Koro ãngũ rĩ ní ꞌi ayazú dĩngídĩngí, ãꞌdiãtãsĩyã mãlãyíkã Úpí vé rĩ ímụ́ ꞌbụ̃ gé ꞌdãásĩ, ꞌde mụụ́ ꞌbụ́rẹ̃drị̃ gé ꞌdãá, gũ írã rĩ ꞌbụ́ rĩ tị gé sĩ, úrí drị̃ ni gé. ");
INSERT INTO kbo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mãlãyíkã rĩ vé ẹndrẹtị ọ́gụ́ sụ̃ ãngũ ní gaá ọ́gụ́ lọ́kụ́lọ́kụ́ rĩ tị́nị, ĩrivé bõngó imvesírílílí sụ̃ ụ̃tụ́ ní ọ́gụ́ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ꞌBá ꞌbụ́rẹ̃drị̃ ũtẽꞌbá rĩ pi kâ ĩri ndreé, ụ̃rị̃ ị́mvụ́ kộpi ambamba, kộpi ã rụ́ꞌbá yã kpĩríkpĩrí, kộpi uꞌdekí vũgá sụ̃ ꞌbá ũdrãꞌbá gí ni pi tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mãlãyíkã rĩ ní ꞌyozú ũkú ꞌdĩꞌbée ní kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku, á nị̃ rá ĩmi ri Yẹ́sụ̃ ĩ ní gbãá pẹtị alambaku sị́gé rĩ ndã. ");
INSERT INTO kbo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yẹ́sụ̃ ri nõgó ꞌdãáyo, Múngú inga ĩri drãngárá gálésĩ gõó ídri rú gí, sụ̃ ándúrú ĩri ní ꞌyoó rĩ tị́nị. Ĩmi ímụ́kí vũrã ĩ ní ĩri ꞌbãzú lazú rĩ ndreé. ");
INSERT INTO kbo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ĩmi mụkí mbẽlẽ lũú ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní kínĩ, ‘Íngá drãngárá gálésĩla gõó ídri rú gí, ĩri ri mụ ãngũ Gãlĩláyã vé rĩ gé ĩmi ẹndrẹtị gé drị̃drị̃ ꞌdĩíꞌdĩ, ĩmi ca mụ ĩri ị́sụ́ ndre ꞌdãá.’ Tã má ní ímụ́ lũú ĩmi ní rĩ adriípi ꞌdĩ.” ");
INSERT INTO kbo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ũkú rĩ pi ní ngazú mụzú rụ́ꞌbá sĩ ꞌbụ́rẹ̃drị̃ gé ꞌdĩísĩ rá. Ụ̃rị̃ ị́mvụ́ kộpi rá, ꞌbo ãyĩkõ fụ kộpi ambamba, kộpi ní njuzú mụzú tã rĩ ũlũzú Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Koro Yẹ́sụ̃ pi ní drị̃ ị́sụ́zú kộpi be, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Mõdó ĩmi ní.” Kộpi ní ímụ́zú ĩri vúgá nõó, kộpi ní kũmũcí ũtị̃zú ĩri ẹndrẹtị gé, kộpi ní ĩri ị̃njị̃zú. ");
INSERT INTO kbo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kúru Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku. Ĩmi mụkí lũú má ẹ́drị́pị́ị ní, kộpi ã mụkí ãngũ Gãlĩláyã vé rĩ gé, kộpi mụ ma ị́sụ́ ndre ꞌdãlé.” ");
INSERT INTO kbo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ũkú rĩ pi kâ rií ꞌdeé mụzú kụ̃rụ́ agá ꞌdãá, ꞌbá ꞌbụ́rẹ̃drị̃ ũtẽꞌbá rĩ pi ã ụrụkọ ní ꞌdezú mụzú tã ꞌi ngaápi rĩ ũlũzú atala atala rĩ pi drị̃gé rĩ pi ní céré. ");
INSERT INTO kbo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Atala atala rĩ pi drị̃gé rĩ pi kâ ĩ úmú ꞌbá ambugu rĩ pi be, kộpi ụ̃sụ̃kí kínĩ, lẽ ĩ sẽkí mũfẽngã ãmbúgú ãngáráwá rĩ pi vé rĩ ní. ");
INSERT INTO kbo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kộpi ní ꞌyozú ãngáráwá rĩ pi ní kínĩ, “Ĩmi ꞌyokí, ‘Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá ri pi ímụ́kí ị́nị́ŋá sĩ, kộpi ụ̃gụ̃kí ĩrivé ãvũ mụzú gí, ị́sụ́ ãkũdẽ ꞌbâ ụ́ꞌdụ́ gé.’ ");
INSERT INTO kbo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gávãnã kãdõ tã ꞌdĩri yịị́, ꞌbâ mụ ẹ́sị́ ni ꞌyo, tã ãzi ícó ĩmi ị́sụ́ ku.” ");
INSERT INTO kbo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kúru ãngáráwá rĩ pi ní mũfẽngã rĩ ꞌdụzú, kộpi ꞌdụkí tã rĩ ngaá sụ̃ ĩ ní lũú ĩ ní rĩ tị́nị. Tã ꞌdĩri ayi Yãhụ́dị̃ rĩ pi ãsámvú gé sĩ céré, úꞌdógúꞌdógú ꞌdĩri ĩ drĩ ri ũlũlũ Yãhụ́dị̃ rĩ pi ãsámvú gé cĩmgbá ãndrũ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kúru ꞌbá ĩri ã pámvú ũbĩꞌbá mụdrị́ drị̃ ni ãlu rĩ pi ní ꞌdezú mụzú ãngũ Gãlĩláyã vé rĩ gé írã Yẹ́sụ̃ ní ándúrú ꞌyoó kộpi ã mụkí drị̃ ni gé ꞌdãri gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kộpi kâ ĩri ndreé, kộpi ní ĩri ị̃njị̃zú, ꞌbo tã ꞌdĩri fi ụrụkọꞌbée drị̃gé ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kúru Yẹ́sụ̃ ní ímụ́zú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ũkpõ ꞌbụ̃ gé ꞌdãlé rĩ, ãzini vũ drị̃gé nõgó rĩ, sẽkí céré kú má drị́gé. ");
INSERT INTO kbo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kúru ĩmi mụkí ũlũú ãngũ rĩ pi agásĩ céré, ꞌbá rĩ pi ẽ ímụ́kí mâ pámvú ũbĩí, ĩmi sẽkí kộpi ní bãtízĩmũ Ẹ́tẹ́pị ã rụ́ sĩ, Mvọ́pị ã rụ́ sĩ, ãzini Índrí Uletere rĩ ã rụ́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ĩmi ímbákí tã má ní ẹzịị́ ĩmi ní ꞌdĩri kộpi ní, kộpi ã ꞌdụkí tã ni ngaánga. Ádarú ụ́ꞌdụ́ céré ma adri ĩmi be trụ́, cĩmgbá cazú ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ gé.”");
INSERT INTO kbo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ụ́ꞌdụ́kọ́ múké Yẹ́sụ̃ Kúrísítõ Múngú Mvọ́pị vé tã sĩí rĩ íꞌdó ꞌi ꞌdíni. ");
INSERT INTO kbo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nẹ́bị̃ Ĩsáyã sĩ ívé búkũ agá ꞌdíni, “Ma mávé ꞌbá áyúãyũ ni pẽ mụzú mí ní drị̃drị̃, ĩri mụ mí ní lẹ́tị údé.” ");
INSERT INTO kbo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ụ́ꞌdụ́kọ́ ꞌbá ãzi vé ni ri ọ́ꞌụ́ ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá kĩnĩ, ‘Ĩmi údékí lẹ́tị Úpí ní, ĩmi útúkí lẹ́tị ĩrivé rĩ ã adri pịrị.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yũwánĩ ní kúru ĩfũzú ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá, ĩri ní rizú tị sẽzú ꞌbá rĩ pi ní kĩnĩ, “Ĩmi újákí ẹ́sị́, ĩmi kukí ũnjĩkãnyã ãní, Múngú ã trũ rí ĩmi ĩmivé ũnjĩkãnyã agásĩ rá. Ĩri ní ꞌdezú rizú ꞌbá rĩ pi ní bãtízĩmũ sẽzú.” ");
INSERT INTO kbo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ꞌBá rĩ pi ní ímụ́zú ãngũ Yụ̃dáyã vé rĩ agásĩ, ãzini kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agásĩ céré Yũwánĩ vúgá nõó. Kộpi ní ĩvé ũnjĩkãnyã ũlũzú, Yũwánĩ ní kộpi ní bãtízĩmũ sẽzú yị̃ị́ ãmbúgú dịị́pi dịdị Yárídénĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bõngó Yũwánĩ ní suú rĩ, údékí kámĩlõ ã ꞌbí. ꞌYĩ gõ lãꞌbú rú ni ꞌí ụ́pị́lẹ́ gá, ĩrivé ãnyãngã rií nyaá rĩ, úmbí, ãzini ọ̃nyụ́ ásé agá rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yũwánĩ ní áyúzú ꞌbá rĩ pi ní kĩnĩ, “ꞌBá ãzi ri ímụ́ mâ vụ́drị̃ gé ꞌdĩíꞌdĩ, ĩri ũkpõ be ambamba, ndẽ ma ũkpõ sĩ rá, má ícó ọ̃vụ̃ụ́ ĩrivé ngá pá gá ã bãá ọyụụ́ bã ku. ");
INSERT INTO kbo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Á sẽ ĩmi ní bãtízĩmũ yị̃ị́ sĩ, ꞌbo ĩri ímụ́ ĩmi ní bãtízĩmũ sẽ ũkpõ Índrí Uletere rĩ vé rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lókí ꞌdãri gé, Yẹ́sụ̃ ímụ́ Nãzẽrétã gálésĩla, Nãzẽrétã ri ãngũ Gãlĩláyã vé rĩ agá. Yũwánĩ ní bãtízĩmũ sẽzú ĩri ní yị̃ị́ Yárídénĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yẹ́sụ̃ kã rií ĩfũú yị̃ị́ rĩ agásĩ, ndre ꞌbụ̃ zị̃ ꞌi kú mgbọ. Índrí Uletere rĩ ní ísị́zú ímụ́zú sụ̃ ãmámũ tị́nị, úrízú drị̃gé ni gé. ");
INSERT INTO kbo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kúru ụ́ꞌdụ́kọ́ ní íkụ́zú ꞌbụ̃ gé ꞌdãásĩ kĩnĩ, “Mi Mvá mávé ni, á lẽ mi ambamba, ma ãyĩkõ sĩ mí sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Índrí Uletere rĩ ní Yẹ́sụ̃ ẽ tị pẽzú mụzú mbẽlẽŋá ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yẹ́sụ̃ mụ adrií ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá ụ́ꞌdụ́ pụ̃kụ́ sụ̃, Sãtánã ri ĩri ụ̃ꞌbị̃ị́ ásé agá ꞌdãá. Fi mụụ́ adrií ãꞌá ásé agá rĩ pi ãsámvú gé, ꞌbo mãlãyíkã rĩ pi rikí ĩri ũtẽé nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kâ Yũwánĩ ri ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá gí, Yẹ́sụ̃ ní ꞌdezú mụzú ãngũ Gãlĩláyã vé rĩ gé, ĩri ní ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũzú mụzú. ");
INSERT INTO kbo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ĩri ní ꞌyozú kĩnĩ, “Mãlũngã Múngú vé rĩ ícá ĩnyiŋá gí, ĩmi újákí ẹ́sị́, ĩmi ẹ̃ꞌyị̃kí ụ́ꞌdụ́kọ́ múké má ní ũlũú nõri.” ");
INSERT INTO kbo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yẹ́sụ̃ kã rií ẹ́cị́ yị̃ị́ bãlãlã Gãlĩláyã gãrã gá sĩ, ĩri ní ꞌbá ị̃rị̃ ị̃ꞌbị́ ꞌbeꞌbá ni pi ndrezú, ꞌbá rĩ Sị̃mọ́nã pi ẹ́drị́pị Ãndẽréyã be, kộpi ri ị̃ꞌbị́ ꞌbe ímbá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ímụ́kí mâ pámvú ũbĩí, ma sẽ ĩmi ímụ́ ꞌbá ísé íjị́ má ní sụ̃ ĩmi ní ị̃ꞌbị́ ꞌbeé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Koro kộpi ní ĩvé ímbá kuzú, kộpi ní ꞌdezú mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yẹ́sụ̃ kã ꞌi útrú mụzú drị̃drị̃, ĩri ní Zẽbẽdáyõ ẹnjịpị́ị Yõkóbũ pi ndrezú ẹ́drị́pị Yũwánĩ be, kộpi ri ĩvé ímbá aꞌdi kũlúmgba agá ꞌdãá ị̃ꞌbị́ ꞌbezú ãní. ");
INSERT INTO kbo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yẹ́sụ̃ ní koro kộpi zịzú, kộpi ní ĩ ẹ́tẹ́pị Zẽbẽdáyõ ri kuzú ĩvé ꞌbá ẹ̃zị́ vé rĩ pi be kũlúmgba rĩ agá ꞌdãá, kộpi ní mụzú Yẹ́sụ̃ vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Kãpãrãnãụ́mã gá. ꞌBo ụ́ꞌdụ́ Sãbátã vé rĩ kã ícá, Yẹ́sụ̃ ní mụzú Jó Múngú ri Zịzú rĩ agá ꞌdãá, ĩri ní ꞌdezú rizú ꞌbá rĩ pi ímbázú. ");
INSERT INTO kbo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ꞌBá rĩ pi ãyãkí tã ĩri ní ímbá rĩ sĩ rá, ãꞌdiãtãsĩyã tã ĩri ní ímbá rĩ ũkpõ be ambamba, ndẽ ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi vé rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ágó ãzi índrí ũnjí ní fií drị̃ ni gé ni ri adrií ĩvé Jó Múngú ri Zịzú rĩ agá ꞌdãá, ágó rĩ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yẹ́sụ̃ Nãzẽrétãgú rĩ, ngá mí ní rizú ꞌbâ drị̃ izazú rĩ ãꞌdi? Mí ímụ́ ꞌbâ úꞌdị́ ũdrãá? Á nị̃ mi rá, mi ꞌBá Uletere Múngú vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yẹ́sụ̃ ní trezú índrí ũnjí rĩ drị̃gé kĩnĩ, “Mí újí kíri, ꞌí fũ ágó rĩ drị̃gé sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Índrí ũnjí rĩ ní ágó rĩ ayazú ũkpõ sĩ, ĩri ní ngazú fũzú ágó rĩ drị̃gé sĩ útréngárá be ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ꞌBá rĩ pi kâ tã ꞌdĩri ndreé, sẽ kộpi ní céré ãyãngárá. Kộpi rikí átá ĩ ãsámvú gé sĩ kínĩ, “Ímbángárá úꞌdí ĩ ní ímbá ũkpõ be índrí ũnjí rĩ pi ní tã ni ꞌdụụ́ ẹ̃zị́ ngazú rá ꞌdĩri, ímbángárá íngóni ni?” ");
INSERT INTO kbo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri íré ꞌi mụzú mbẽlẽŋá ãngũ Gãlĩláyã vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yẹ́sụ̃ pi Yõkóbũ be Yũwánĩ sĩ, ngakí fũú Jó Múngú ri Zịzú rĩ agásĩ, kộpi ꞌdekí mụụ́ Sị̃mọ́nã pi vé ãngá Ãndẽréyã be. ");
INSERT INTO kbo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kộpi kâ mụụ́ caá ꞌdãlé, lũkí Yẹ́sụ̃ ní kínĩ, Sị̃mọ́nã ị̃drẹ́pị ri ãzó rú, rụ́ꞌbá ni ko gbírílílí, la kú gbọ́lọ́ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yẹ́sụ̃ ní mụzú ũkú rĩ vúgá ꞌdãá, drị́ ni rụzú, ĩri ingazú ụrụgégé. Drã rĩ ní dẹzú ũkú rĩ rụ́ꞌbá gá sĩ, ĩri ní ínyá áꞌdízú sẽzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ũndréŋá Sãbátã vé rĩ kã dẹẹ́, ụ̃tụ́ rĩ kã ꞌdeé gí, ꞌbá rĩ pi ũlĩkí ĩvé ꞌbá drã be rĩ pi, ꞌbá índrí ũnjí ní fií kộpi drị̃gé rĩ pi be ímụ́ Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ꞌBá kụ̃rụ́ Kãpãrãnãụ́mã agá rĩ pi úmúkí ĩ céré ímụ́ adrií kuú jó rĩ vé kẹ̃ẹ́tịlé gá. ");
INSERT INTO kbo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kúru Yẹ́sụ̃ ídrí ꞌbá drã be rĩ pi kárákará, drã ꞌbá ꞌdĩꞌbée rụꞌbá gá rĩ pi drã ãndíãndí ni pi, ãzini Yẹ́sụ̃ údró índrí ũnjí kárákará ũfũú ꞌbá rĩ pi drị̃gé sĩ. ꞌBo índrí ũnjí rĩ pi ní Yẹ́sụ̃ ri nị̃ị́ rá rĩ sĩ, Yẹ́sụ̃ ãꞌyĩ kộpi átángá átá kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kã mụụ́ caá drụ̃ ụ̃ꞌbụ́tị kụ̃nị̃kụ̃nị̃, Yẹ́sụ̃ ní íngázú ụrụ, ĩri ní mụzú adrizú ọ́ꞌdụ́kụ́lẹgúsĩ, ꞌdãlé ri Múngú ri zịị́. ");
INSERT INTO kbo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Vụ́drị̃ ni gé, Sị̃mọ́nã pi ꞌí ọ̃gụ̃pị́ị be, kộpi ní ꞌdezú mụzú Yẹ́sụ̃ ri ndãzú. ");
INSERT INTO kbo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kộpi kâ ĩri ị́sụ́, kộpi kínĩ, “ꞌBá rĩ pi ri mi ndã.” ");
INSERT INTO kbo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Lẽ ꞌbâ mụkí vũrã ãzi túngú ni gé, mâ ũlũ rí kpá tị Múngú vé rĩ mụzú kụ̃rụ́ ụrụkọꞌbée agásĩ ĩndĩ, ãꞌdiãtãsĩyã ꞌdĩri ẹ̃zị́ Múngú ní ma ĩpẽzú rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yẹ́sụ̃ ní kúru ẹ́cị́zú Múngú vé tị ũlũzú Jó Múngú ri Zịzú rĩ pi agásĩ, ãngũ Gãlĩláyã vé rĩ agásĩ céré, ri índrí ũnjí rĩ pi údró ũfũú ꞌbá rĩ pi drị̃gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ágó ãzi ũfú ní nyaá ni ímụ́ kũmũcí ũtị̃ị́ Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, “Mí ãꞌyĩ dõ rá, mí sẽ mâ rụ́ꞌbá ẽ ícá ule fô.” ");
INSERT INTO kbo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tã ꞌdĩri sẽ Yẹ́sụ̃ ẽ ẹ́sị́ ị́sụ́ ĩzãngã ambamba, ĩri ní drị́ suzú ágó rĩ úlózú, ĩri ní ꞌyozú kĩnĩ, “Á lẽ rá, mî rụ́ꞌbá ẽ ícá ule.” ");
INSERT INTO kbo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Koro ũfú rĩ ní dẹzú ágó rĩ ã rụ́ꞌbá gá sĩ, rụ́ꞌbá ni ní ícázú ule. ");
INSERT INTO kbo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yẹ́sụ̃ ní ágó rĩ pẽzú mụzú, ẹzịzú ĩri ní trị̃trị̃, ");
INSERT INTO kbo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, “Lẽ mî lũ tã ꞌdĩri ꞌbá ãzi ní ku. ꞌÍ mụ mi iꞌdaá ꞌbá átálágú rú ni ẹndrẹtị gé, ꞌí jị ngá ãzi mụzú rọ̃bọ̃ŋọ̃ rú mí drị́gé sĩ ĩndĩ, sụ̃ tãị́mbị́ Mósẽ vé rĩ ní ꞌyoó rĩ tị́nị, ꞌbá céré ã nị̃kí rí ꞌyozú kínĩ, mî rụ́ꞌbá ícá ule gí.” ");
INSERT INTO kbo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ꞌBo ágó rĩ kã ꞌdeé mụzú, íꞌdó rií tã rĩ ũlũú mụzú ꞌbá rĩ pi ní. Ãní sẽ Yẹ́sụ̃ gõ fií mụụ́ ẹ́cị́ kụ̃rụ́ rĩ agá ꞌdãá ꞌbá rĩ pi ãsámvú gé sĩ andrekelemgbe kuyé. Yẹ́sụ̃ ã ugo dõ ꞌi fingárá kụ̃rụ́ rĩ agá ꞌdãá rĩ sĩ ugogo drãáãsĩyã, ꞌbá rĩ pi rikí nyo ẹ́cị́ ĩri vúgá nõó íngázú vũrã rĩ pi gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ụ́ꞌdụ́ mãdã ã vú drị̃gé, Yẹ́sụ̃ ní kpá gõzú fizú Kãpãrãnãụ́mã gá ꞌdãá dị̃ị́. ꞌBá rĩ pi yịkí kínĩ, Yẹ́sụ̃ ícá ĩgõó ꞌbẹ̃tị́ gí. ");
INSERT INTO kbo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ꞌBá rĩ pi ní ĩ úmúzú kárákará, sẽ vũrã rĩ ca ku. ꞌBá rĩ pi gakí jó rĩ agá ꞌdãá tré, cĩmgbá cazú kẹ̃ẹ́tịlé gá ãmvé ꞌdãá, Yẹ́sụ̃ ri ụ́ꞌdụ́kọ́ múké rĩ ũlũú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ãgõ ụrụkọꞌbée sụ íꞌdụ́kí ágó ãzi ọ̃gọ̃rọ̃vụ̃ rú ni íjị́ Yẹ́sụ̃ vú nõó. ");
INSERT INTO kbo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ꞌBá rĩ pi ní adrií bị́trị́ká rĩ sĩ, kộpi ndãkí ũꞌdũ tí, kộpi ní tụzú jó drị̃gé ꞌdãá, kộpi ní jó rĩ ẽ drị̃ ĩŋãnyãzú, kộpi ní ágó pá be ꞌbẽléꞌbéle rĩ ísúzú ímụ́zú ĩrivé pọ́rọ̃sị̃ ĩri ní laá drị̃ ni gé rĩ be vũgá Yẹ́sụ̃ ẹndrẹtị gé nõó. ");
INSERT INTO kbo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yẹ́sụ̃ kã nị̃ị́ ámá ꞌyoó kínĩ, ãgõ ꞌdĩꞌbée ẹ̃ꞌyị̃kí ꞌi gí, ĩri ní ꞌyozú ágó ọ̃gọ̃rọ̃vụ̃ rú rĩ ní kĩnĩ, “Mvá ágó ꞌdĩri, á trũ mi mívé ũnjĩkãnyã agásĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ꞌBá riꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi úríkí kuú ꞌdãá, kộpi rikí ụ̃sụ̃ụ́ ẹ́sị́sị́lé sĩ kínĩ, ");
INSERT INTO kbo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ngá ágó ꞌdĩri ní rizú átázú ꞌdíni rĩ ãꞌdi? Ágó ꞌdĩri ị̃njị̃ Múngú ri ku! ꞌBá ãzi ãluŋáni ãngũ trũúpi ũnjĩkãnyã agásĩ ni ꞌdãáyo, ꞌyéŋá Múngú ꞌi ọ́ꞌdụ́kụ́lẹgúsĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Koro Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ ĩ ẹ́sị́ agá ꞌdãlé rĩ ámá bá. Kúru ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ngá ĩmi ní rizú tã ụ̃sụ̃zú ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mâ ꞌyo rí tã rĩ íngóni? Mâ ꞌyo rí ágó pá be ꞌbẽléꞌbéle nõri ní, ‘Trũkí mi mívé ũnjĩkãnyã agásĩ gí ꞌdíni,’ dõku mâ ꞌyo, ‘ꞌÍ nga ụrụ, ꞌí ꞌdụ mívé pọ́rọ̃sị̃, ꞌí ꞌde mụụ́’ ꞌdíni? ");
INSERT INTO kbo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ꞌBo á lẽ lũú ĩmi ní ꞌyozú kínĩ, ma ꞌBá Mvá ꞌi, ma ũkpõ be ũnjĩkãnyã trũzú vũ drị̃gé nõgó” Yẹ́sụ̃ ní ꞌyozú ágó pá be ꞌbẽléꞌbéle rĩ ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Á ꞌyo mí ní, ꞌí nga ụrụ, ꞌí ꞌdụ mívé pọ́rọ̃sị̃, ꞌí mvi ꞌbẹ̃tị́.” ");
INSERT INTO kbo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ágó rĩ ní ngazú ụrụ, ĩri ní ívé pọ́rọ̃sị̃ ꞌdụzú, ĩri ní ꞌdezú mụzú, ꞌbá rĩ pi rikí ĩri ndreé mụzú. Tã ꞌdĩri sẽ ꞌbá rĩ pi ní ãyãngárá, ãzini sẽ kộpi rikí Múngú ri íngú kínĩ, “ꞌBá ndrekí tã ãzi ụ̃kụ ni ꞌdĩri tị́nị kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yẹ́sụ̃ gõ ꞌi ẹndịị́ mụụ́ yị̃ị́ bãlãlã Gãlĩláyã tị gé ꞌdãá dị̃ị́. ꞌBá rĩ pi ní ĩ úmúzú kárákará Yẹ́sụ̃ ã gãrã gá, ĩri ní íꞌdózú kộpi ímbázú. ");
INSERT INTO kbo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yẹ́sụ̃ kã rií ẹ́cị́ yị̃ị́ bãlãlã rĩ ã gãrã gá sĩ, ĩri ní Lẹ́vị̃ Ãlãfáyõ mvọ́pị riípi mũfẽngã umbe jezú rĩ uꞌdụụ́pi rĩ ndrezú, ãkũdẽ úrí kuú ívé jó rizú mũfẽngã umbe jezú rĩ uꞌdụzú rĩ agá ꞌdãá. Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Mí ímụ́ mâ pámvú ũbĩí.” Koro Lẹ́vị̃ ní ngazú ꞌdezú mụzú ĩri vúgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lẹ́vị̃ zị Yẹ́sụ̃ pi ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi be mụụ́ ínyá nyaá ívé ãngá. ꞌBá kárákará mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi, ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be, kộpi ínyá rĩ ã nyangárá gá ꞌdãá ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ꞌBá tãị́mbị́ ímbáꞌbá adriꞌbá Fãrụ́sị̃ rĩ pi kâ ndreé Yẹ́sụ̃ pi ri ínyá nya ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be, ãzini ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi be trụ́, kộpi ní ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi zịzú kínĩ, “Ngá ĩmi ní rizú ínyá nyazú ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi be, ãzini ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yẹ́sụ̃ kã tã ꞌdĩri yịị́, ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá drã ãkó rĩ ndã ꞌbá ũjó sẽépi ni ku, ꞌbá drã be rĩ, ĩri ꞌbá ũjó sẽépi ni ndã nĩ. Má ímụ́ ꞌbá tã be pịrị rĩ pi zịị́ kuyé, má ímụ́ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi zịị́ ẹ́sị́ újá.” ");
INSERT INTO kbo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ꞌBá Yũwánĩ ã pámvú ũbĩꞌbá rĩ pi Fãrụ́sị̃ rĩ pi be, kộpi ri ĩ aꞌbi ãnyãngã ã nyangárá sĩ aꞌbiaꞌbi. ꞌBá ụrụkọ ímụ́kí Yẹ́sụ̃ ri zịị́ kínĩ, “ꞌBá Yũwánĩ ã pámvú ũbĩꞌbá rĩ pi Fãrụ́sị̃ rĩ pi be, kộpi ri ĩ aꞌbi ãnyãngã nyangárá sĩ aꞌbiaꞌbi, ꞌbo mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi aꞌbikí ĩ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “ꞌBá rĩ pi mụkí dõ ũkú jengárá gá, ọ̃mụ́rụ́gọ́ rĩ vé kẹ̃rẹ́gú dõ ãjẽ rĩ gé ꞌdãlé anigé, ĩrivé ũndĩ mụꞌbá vú ni gé sĩ rĩ pi ícókí ĩ aꞌbií ngá nyangárá sĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ꞌBo sâ ãzi ri ímụ́ ꞌdĩíꞌdĩ, kádõ ímụ́ ọ̃mụ́rụ́gọ́ rĩ vé kẹ̃rẹ́gú ꞌdụụ́ kộpi ãsámvú gé sĩ, kúru ụ́ꞌdụ́ ꞌdãri gé, kộpi ímụ́ ĩ aꞌbi ngá nyangárá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ꞌBá ãzi ícó bõngó úꞌdí ĩsĩí bõngó dẽépi kú ị́rị́kọ́ rú ni vé úlẽ ící ọ̃zụ̃ụ́ ãní ku, ãꞌdiãtãsĩyã bõngó ꞌi nyaápi kú ị́rị́kọ́ rú gí rĩ, ícíkí dõ úlẽ ni ọ̃zụ̃ụ́ bõngó úꞌdí sĩ, ĩri gõ ãsĩ mụzú drị̃gélé. ");
INSERT INTO kbo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ꞌBá ãzi ícó vị́nyọ̃ ĩ ní zoó úꞌdí rú rĩ tõó lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá ku. ꞌBá rĩ tõ dõ vị́nyọ̃ rĩ lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá, vị́nyọ̃ rĩ íngá kọ̃fụ́tọ̃ be, ĩri sẽ jũrú rĩ ãfĩ rá, vị́nyọ̃ rĩ dã vũgá. Lẽ ã tõkí vị́nyọ̃ rĩ jũrú úꞌdí ni agá.” ");
INSERT INTO kbo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ụ́ꞌdụ́ ãlu Yẹ́sụ̃ pi rikí ẹlịị́ mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ọ́mvụ́ ãnyá vé ni agásĩ ụ́ꞌdụ́ Sãbátã vé rĩ gé. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ã ụrụkọꞌbée ní rizú ãnyá rĩ pi ẽ drị̃ ucezú anyizú cizú. ");
INSERT INTO kbo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fãrụ́sị̃ rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBávé tãị́mbị́ kĩnĩ, ã ngakí ẹ̃zị́ ụ́ꞌdụ́ Sãbátã vé rĩ gé ku pírí, ngá ꞌbá mî pámvú ũbĩꞌbá rĩ pi ní tãị́mbị́ rĩ ŋõzú, ãnyá ẽ drị̃ ucezú ụ́ꞌdụ́ Sãbátã vé rĩ gé rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi lãkí tã ꞌbãgú Dãwụ́dị̃ ní ꞌoó ívé ꞌbá rĩ pi be lókí ẹ̃bị́rị́ ní kộpi fụzú rĩ gé rĩ kuyé? ");
INSERT INTO kbo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lókí átálágú ãmbúgú Ãbĩyãtárĩ vé rĩ gé, Dãwụ́dị̃ nga fií Jó Múngú vé rĩ agá ꞌdãá, ꞌdụ pánga ĩ ní ꞌbãá Múngú ẹndrẹtị gé, ĩ ní nyaá bãdãrú ku, ꞌyéŋá atala rĩ pi ní rií nyaá nĩ rĩ nyaá, sẽ kpá ụrụkọ ni nyaá ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yẹ́sụ̃ ní ꞌyozú Fãrụ́sị̃ rĩ pi ní kĩnĩ, “Múngú údé ụ́ꞌdụ́ Sãbátã vé rĩ ꞌbá rĩ pi ã uvukí rí ãní, ꞌbã ụ́ꞌdụ́ Sãbátã vé rĩ tã ẹ̃njị̃ẹ̃njị̃ rú ꞌbá rĩ pi drị̃gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ma ꞌBá Mvá ꞌi, ma Úpí ụ́ꞌdụ́ Sãbátã vé rĩ drị̃gé ãmbúgú nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ụ́ꞌdụ́ ãzi gé, Yẹ́sụ̃ gõ mụụ́ fií Jó Múngú ri Zịzú rĩ agá ꞌdãá dị̃ị́, ị́sụ́ ágó ãzi drã ní drị́ ni nyií kuú ꞌbẽléꞌbéle ni adri kú ꞌbá rĩ pi ãsámvú gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fãrụ́sị̃ rĩ pi ã ụrụkọ rikí lẹ́tị ndãá, ĩ tõkí rí Yẹ́sụ̃ ri ãní bẽnĩ, kộpi tẽkí nyo rií Yẹ́sụ̃ ri ndreé, dõ tãnâ ĩri ágó ꞌdĩri ídrí ụ́ꞌdụ́ Sãbátã vé rĩ gé rá. ");
INSERT INTO kbo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yẹ́sụ̃ ní ꞌyozú ágó drã ní drị́ ni nyií kuú ꞌbẽléꞌbéle rĩ ní kĩnĩ, “Mí íngá ụrụ, mí ímụ́ pá tuú ꞌbá rĩ pi ẹndrẹtị gé nõgó.” ");
INSERT INTO kbo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ngá ĩmivé tãị́mbị́ ní lẽé ã ꞌokí ụ́ꞌdụ́ Sãbátã vé rĩ gé ku rĩ ãꞌdi? Ĩri tã múké ꞌongárá, dõku tã ũnjí ꞌongárá? Ĩri ꞌbá drã be ꞌdíni ꞌdĩri kuzú drãzú, dõku ẽ ídríkí ĩri?” Kộpi zị̃kí ĩ tị átángá ꞌyozú kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yẹ́sụ̃ kã ãngũ ndreé kộpi vúgá ꞌdãá, ẹ́sị́ ni ve kộpi ní ambamba. Tã ní fií kộpi ẽ ẹ́sị́ agá ku rĩ sĩ, sẽ Yẹ́sụ̃ ní ĩzãngã ambamba. Ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, “Mí ũjũ mî drị́.” Ágó rĩ ní ꞌî drị́ ũjũzú. Ágó rĩ ẽ drị́ ní ícázú múké. ");
INSERT INTO kbo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Koro Fãrụ́sị̃ rĩ pi ní fũzú mụzú ꞌbá Ẽródẽ ri ẹ̃tị̃ꞌbá rĩ pi be Yẹ́sụ̃ ã tã lizú, lẽzú ĩri ꞌdịzú drãzú ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be yị̃ị́ bãlãlã Gãlĩláyã vé rĩ gé ꞌdãá, ꞌbá kárákará íbíkí íngá ãngũ Gãlĩláyã vé rĩ gé, ãzini ãngũ Yụ̃dáyã vé rĩ gé, kộpi ꞌdekí mụzú Yẹ́sụ̃ ã vụ́drị̃ gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kộpi kâ tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri yịị́, ꞌbá kárákará ímụ́kí Yẹ́sụ̃ vúgá nõó, kộpi íbíkí íngá Yụ̃dáyã gá, Yẹ̃rụ́sãlémã gá, ãngũ Ĩdũmíyã vé rĩ gé, gụ́rụ́ Yárídénĩ vé rĩ gé, kụ̃rụ́ Táyã vé rĩ gé, ãzini kụ̃rụ́ Sĩdónã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yẹ́sụ̃ kã mụụ́ ndreé ꞌbá rĩ pi gakí ambamba, ĩri ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, kộpi ẽ íꞌdụ́kí kũlúmgba mãdãŋá ni ꞌbãá tẽétẽ, ꞌbá bị́trị́ká rĩ pi ẽ ímụ́kí rí ĩ ĩmũlũú ku. ");
INSERT INTO kbo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yẹ́sụ̃ ídrí ꞌbá kárákará, ãní sẽ ꞌbá drã be rĩ pi rikí ĩ ĩmĩí ímụ́zú Yẹ́sụ̃ vúgá nõó ũkpõ sĩ, ĩ úlókí rí ĩri ã rụ́ꞌbá bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ꞌBá índrí ũnjí ní fií kộpi drị̃gé rĩ pi kádõ Yẹ́sụ̃ ri ndreé, índrí ũnjí rĩ pi kộpi ꞌdụ aꞌbe vũgá Yẹ́sụ̃ ẹndrẹtị gé ꞌdĩgé, kộpi útré ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, “Mi Mvá Múngú vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ꞌBo Yẹ́sụ̃ átá índrí ũnjí rĩ pi ní ũkpõ sĩ kĩnĩ, kộpi ã lũkí ꞌî tã ꞌbá ãzi ní ku. ");
INSERT INTO kbo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Vụ́drị̃ ni gé, Yẹ́sụ̃ tụ mụụ́ írã drị̃gé ꞌdãá, ĩri ní ꞌbá ꞌî ẹ́sị́ ní lẽé rĩ pi zịzú mụzú ꞌí vú sĩ, kộpi ní mụzú Yẹ́sụ̃ vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ĩri ní ꞌbá ũpẽzú mụdrị́ drị̃ ni ị̃rị̃, kộpi ã adrikí rí ívé ꞌbá áyúãyũ ni pi rú, ĩri ní kộpi pẽzú mụzú, kộpi ã ũlũkí rí tị Múngú vé rĩ mụzú. ");
INSERT INTO kbo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yẹ́sụ̃ sẽ kộpi ní ũkpõ, kộpi ã údrókí rí índrí ũnjí rĩ pi fũú ꞌbá rĩ pi drị̃gé sĩ ãní. ");
INSERT INTO kbo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ꞌBá ĩri ní ũpẽé mụdrị́ drị̃ ni ị̃rị̃ rĩ pi vé rụ́ pi ꞌdĩ, Sị̃mọ́nã ꞌi, Yẹ́sụ̃ gõ ĩri ní rụ́ ãzi ꞌdaá Pétẽró ꞌi, ");
INSERT INTO kbo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yõkóbũ Zẽbẽdáyõ mvọ́pị pi ẹ́drị́pị Yũwánĩ be, Yẹ́sụ̃ gõ kộpi ní rụ́ ãzi ꞌdaá Bõnãgésĩ ꞌi, rú ꞌdĩri vé ífífí, anji ũvi vé ni pi. ");
INSERT INTO kbo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ꞌBá rĩ ãzi Ãndẽréyã ꞌi, Pĩlípũ ꞌi, Bãtĩlĩmáyõ ꞌi, Mãtáyo ꞌi, Tómã ꞌi, Yõkóbũ Ãlãfáyõ mvọ́pị ꞌi, Tãdáyõ ꞌi, Sị̃mọ́nã úvá ꞌbãápi ꞌbá ívé rĩ pi ẽ ị́sụ́kí rí drị̃wãlã rĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ãzini Yụ́dã Ĩsĩkãrĩyótã gõópi Yẹ́sụ̃ ã ũli ꞌbeépi rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kúru Yẹ́sụ̃ kã ꞌi újá gõó ꞌbẹ̃tị́ ꞌdãá, ĩri ní fizú jó agá, ꞌbá bị́trị́ká bịkí mụzú vú ni gé sĩ, sẽ Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ị́sụ́kí sâ ãnyãngã nyazú ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yẹ́sụ̃ ẹ́ꞌdị́páa kâ tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri yịị́, kộpi ụ̃sụ̃kí kínĩ, Yẹ́sụ̃ ẽ drị̃ ábá gí, ĩ lẽkí ĩri jịị́ mụzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ꞌBá riꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá, ímụ́ꞌbá Yẹ̃rụ́sãlémã gálésĩla rĩ pi kínĩ, “Ágó ꞌdĩri Bẽlẽzẽbúlã fi drị̃ ni gé gí, ĩri ri índrí ũnjí rĩ pi údró ũkpõ ãdróko vé rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yẹ́sụ̃ ní kộpi zịzú, ĩri ní átázú kộpi ní nãpí sĩ kĩnĩ, “Sãtánã ri ícó ꞌí ọ́gụ́pị Sãtánã ri dro fũ íngóni ngóni? ");
INSERT INTO kbo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ꞌBá ãngũ ãlu agá ni pi acokí dõ ĩ rií ẹ̃ꞌdị́ ꞌdịị́ ĩ ọ̃gụ̃pị́ị be, mãlũngã kộpi ní rụụ́ ꞌdĩri ícó pá tuú ku. ");
INSERT INTO kbo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ꞌBá jó ãlu tị gé rĩ pi acokí dõ ĩ gí, ꞌbẹ̃tị́ ꞌdĩri ícó pá tuú ku. ");
INSERT INTO kbo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sãtánã vé mãlũngã aco dõ ꞌí ãsámvú ị̃rị̃ rií ẹ̃ꞌdị́ ꞌdịị́, mãlũngã ꞌdĩri ícó pá tuú ku, ĩrivé ụ̃dụ̃ dẹẹ́pi ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ꞌBá adriípi ọ̃jọ́gọ́ ọ̃jọ́gọ́ rĩ, ꞌbá ãzi ícó ĩrivé ngá alií ku, úmbékí dõ ĩri vũgá ká, ĩ íbí ĩrivé ngá ali ndõ. ");
INSERT INTO kbo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ ꞌo dõ ũnjĩkãnyã, ãzini ide dõ ãngũ, ĩ ícó ĩri trũ rá. ");
INSERT INTO kbo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ꞌBo ꞌbá rĩ ide dõ Índrí Uletere rĩ, ícókí ĩri trũú ãluŋáni ku, ũnjĩkãnyã ĩrivé rĩ áwí adri mụzú ꞌdániꞌdáni.” ");
INSERT INTO kbo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yẹ́sụ̃ ꞌyo tã ꞌdĩri ꞌdíni, ãꞌdiãtãsĩyã ꞌbá rĩ pi rikí átá kínĩ, “Yẹ́sụ̃ ri índrí ũnjí be.” ");
INSERT INTO kbo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yẹ́sụ̃ ẹ́ndrẹ́pị ní ícázú Yẹ́sụ̃ ẹ́drị́pị́ị be, kộpi áwíkí pá tuú kuú ãmvé ꞌdãá. Kộpi ní ꞌbá ãzi pẽzú mụzú Yẹ́sụ̃ ri zịzú. ");
INSERT INTO kbo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ꞌBá kárákará úríkí kuú Yẹ́sụ̃ ã gãrã gá sĩ kụ́rụ̃. Kộpi ní lũzú Yẹ́sụ̃ ní kínĩ, “Mí ẹ́ndrẹ́pị pi mí ẹ́drị́pị́ị be tukí pá kuú ãmvé ꞌdãáꞌdã, kộpi lẽkí mi ndreé.” ");
INSERT INTO kbo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “ꞌBá ĩmi ní ꞌyoó ĩri má ẹ́ndrẹ́pị, ãzini má ẹ́drị́pị́ị ꞌdĩꞌbée ãꞌdi pi?” ");
INSERT INTO kbo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ĩri ní ꞌbá úríꞌbá ꞌî gãrã gá sĩ ꞌdĩꞌbée úndrézú kụ́rụ̃, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Mávé ẹ́ndrẹ́pị ãzini mávé ẹ́drị́pị́ị, kộpi ꞌbá úríꞌbá má gãrã gá sĩ nõꞌbée. ");
INSERT INTO kbo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ꞌBá Múngú vé tã ꞌdụụ́pi ngaápi rĩ, ĩri má ẹ́drị́pị, ĩri má ọ́mvụ́pị, ãzini ĩri má ẹ́ndrẹ́pị.” ");
INSERT INTO kbo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yẹ́sụ̃ gõ íꞌdó ꞌbá rĩ pi ímbá yị̃ị́ bãlãlã Gãlĩláyã tị gé ꞌdãá dị̃ị́. ꞌBá kárákará úmúkí ĩ Yẹ́sụ̃ ã gãrã gá, sẽ Yẹ́sụ̃ tụ mụụ́ úrí kũlúmgba agá yị̃ị́ agá ꞌdãá. ꞌBá rĩ pi tukí pá kuú yị̃ị́ rĩ tị gé. ");
INSERT INTO kbo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yẹ́sụ̃ ímbá ꞌbá rĩ pi ní tã kárákará nãpí sĩ. Tã ĩri ní ímbá rĩ pi ꞌdíni kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ĩmi yịkí drĩ ká! Ágó ãzi mụ úri rií ívé ọ́mvụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kã rií úri rĩ rií, úri rĩ pi ã ụrụkọ uꞌdekí lẹ́tị drị̃gé, ãríŋá rĩ pi tekí kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ írã drị̃gé ni agá, úri rĩ pi ĩfũkí mbẽlẽŋá, ãꞌdiãtãsĩyã nyọ̃ọ́kụ́ rĩ ní adrií nyetele rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ꞌBo ụ̃tụ́ rĩ kã koó gbírílí, úri ĩfũꞌbá rĩ pi ꞌwikí ũdrãá céré, ãꞌdiãtãsĩyã úlá ni pi ní fií vũgá ꞌdãá kuyé rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Úri rĩ pi ã ụrụkọ uꞌdekí ũcékúcé ãsámvú gé, ũcékúcé rĩ dụ amuú, ọ̃zụ̃ úri ĩfũꞌbá dụꞌbá rĩ pi rá, sẽ úri ĩfũꞌbá rĩ pi ꞌakí kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ múké múké ni agá, dụkí ꞌaá mị be gbálígbálí. Ụrụkọ ni pi ꞌakí caá mị be pụ̃kụ́ na, ụrụkọ ni pi pụ̃kụ́ ázíyá, ụrụkọ ni pi mụ̃dụ̃rụ̃lụ̃ ãlu.” ");
INSERT INTO kbo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yẹ́sụ̃ ní kúru ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “ꞌBá bị́ be rĩ, ã yị ꞌí ní tã ꞌdĩri.” ");
INSERT INTO kbo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kâ Yẹ́sụ̃ ri kuú ọ́ꞌdụ́kụ́lẹgúsĩ, ĩrivé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi, ꞌbá ụrụkọ ĩ traꞌbá ĩri ã gãrã gá rĩ pi be, kộpi ní Yẹ́sụ̃ rĩ zịzú kínĩ, “Nãpí mí ní ũlũú ꞌdĩri vé ífífí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ĩri ní újázú kộpi ní kĩnĩ, “Má iꞌda ĩmi ní mãlũngã Múngú vé ĩ ní tã ni ũzụ̃ụ́zụ̃ rĩ ãmvé gí. ꞌBo ma ꞌbá ụrụkọ ní tã rĩ átá nãpí sĩ, ");
INSERT INTO kbo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tã ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ ã nga rí ꞌi fũú tị ni gé bẽsĩnĩ kĩnĩ, “ ‘Kộpi tã má ní ꞌoó rĩ ndre rá, ꞌbo kộpi nị̃kí ífífí ni ku, kộpi tã má ní ꞌyoó rĩ yị rá, ꞌbo fi kộpi drị̃gé ku. Kộpi ã nị̃kí té dõ tã rĩ vé ífífí rá, kộpi té ẹ́sị́ újá, Múngú ri té kộpi trũ rá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yẹ́sụ̃ ní kúru kộpi zịzú kĩnĩ, “Nãpí má ní ũlũú ꞌdĩri, ĩmi nị̃kí nyo ífífí ni kuyé? Má átá dõ ĩmi ní nãpí rĩ ãzi, ĩri ícó fi ĩmi drị̃gé íngóni? ");
INSERT INTO kbo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ꞌBá úri riípi rĩ, ĩri ꞌbá Múngú vé tị ũlũúpi rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Úri uꞌdeꞌbá lẹ́tị drị̃gé rĩ pi vé ífífí, ĩri ꞌbá Múngú vé tị yịꞌbá rá rĩ pi, vụ́drị̃ ni gé, koro Sãtánã ri ímụ́ Múngú vé tị kộpi ní yịị́ ꞌdĩri iza kộpi ẽ ẹ́sị́ agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Úri uꞌdeꞌbá nyọ̃ọ́kụ́ írã drị̃gé rĩ agá rĩ vé ífífí, ĩri ꞌbá Múngú vé tị̃ yịꞌbá ãyĩkõ sĩ rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ꞌBo kộpi kádõ tị Múngú vé rĩ yịị́, tị Múngú vé rĩ ní vũrã ị́sụ́ úrízú kộpi ẽ ẹ́sị́ agá ꞌdãlé kuyé rĩ sĩ, tã ãzi ũkpó ũkpó kãdõ kộpi ayaá, tị Múngú vé rĩ gõ ãvĩ kộpi ẽ ẹ́sị́ agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Úri uꞌdeꞌbá ũcékúcé ãsámvú gé sĩ rĩ pi, ĩri ꞌbá Múngú vé tị yịꞌbá, ẹ̃ꞌyị̃ꞌbá rá rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ꞌBo kộpi ní rií tã rụ́ꞌbá nõri vé rĩ ụ̃sụ̃ụ́ áyu rĩ sĩ, ãzini kộpi ní rií ãꞌbú vé tã ꞌdụụ́ ꞌbãá ãmbúgú rĩ sĩ, ãzini kộpi ní rií ẹ́sị́ ꞌbãá ngá ụrụkọꞌbée drị̃gé rĩ sĩ, sẽ kộpi ꞌbãkí ẹ́sị́ tị Múngú vé rĩ yịzú ku, ĩri sẽ kộpi adri sụ̃ pẹtị ꞌaápi ku rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Úri uꞌdeꞌbá nyọ̃ọ́kụ́ múké agá rĩ pi, kộpi ꞌbá Múngú vé tã yịꞌbá rá, ꞌbãꞌbée ĩ ẹ́sị́ agá tị́tị́ rĩ pi. Kộpivé tã ꞌoó múké rĩ índré sụ̃ ãnyá ꞌaápi mị be gbálígbálí rĩ tị́nị, drị̃ ni ãlu rĩ gé, ꞌa caá pụ̃kụ́ na, pụ̃kụ́ ázíyá, dõku mụ̃dụ̃rụ̃lụ̃ ãlu.” ");
INSERT INTO kbo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yẹ́sụ̃ ní gõzú kộpi ní nãpí ãzi ũlũzú kĩnĩ, “ꞌBá ãzi ri nyo ícó lámbã ꞌyũ su gbọ́lọ́ ã ndụ́gé, dõku ũdrí íꞌdụ́ lámbã dị̃ị́pi ãngũ ĩmgbẽrẽépi rĩ ẽ drị̃ ako ãní cí rá? Ícó ꞌoó ꞌdíni ku, ĩri lámbã rĩ ꞌyũ ꞌbã mísá drị̃gé, vũrã ĩri ní ícózú ãngũ ĩmgbẽrẽzú jó agásĩ céré rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ụ́ꞌdụ́ ãzi ri ímụ́ ꞌdĩíꞌdĩ, tã ꞌbá rĩ pi ní ũzụ̃ụ́zụ̃ rĩ, ĩ ímụ́ iꞌda ãmvé, tã ĩ ní ũzụ̃ụ́zụ̃ rĩ pi ãrẽvú céré, ĩ ímụ́ iꞌda ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ꞌBá rĩ dõ bị́ be, ã yị ꞌí ní tã ꞌdĩri.” ");
INSERT INTO kbo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yẹ́sụ̃ gõ kpá ꞌyoó kộpi ní kĩnĩ, “Ĩmi ꞌbãkí bị́ rizú tã má ní ũlũú ĩmi ní ꞌdĩꞌbée yịzú múké múké. Múngú ri ĩmi ní úmĩ sẽ ĩmi ní ẹ̃bị́rị́ ꞌbãá lẽzú ĩrivé tã nị̃zú rĩ sĩ. Ádarú Múngú ri ĩmi ní tã nị̃ngárá sẽ ambamba. ");
INSERT INTO kbo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ꞌBá ẹ́sị́ ꞌbãápi tã má ní ímbá rĩ drị̃gé rĩ, ma ĩri ní tã nị̃ngárá sẽ ãmbúgú, ꞌbo ꞌbá mávé tã yịị́pi ku rĩ, ma ĩrivé tã nị̃ngárá ꞌdụ úmĩ ni gé sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Mãlũngã Múngú vé rĩ adri sụ̃ ágó úri riípi ívé ọ́mvụ́ agá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kãdõ adrií ị́nị́ sĩ, dõku ụ̃tụ́ sĩ, ágó rĩ dõ ụ́ꞌdụ́ ko yã, dõ ko ụ́ꞌdụ́ ku yã, úri rĩ ĩfũ, ĩri dụ mụzú dụdụ, ágó rĩ nị̃ kuyé dõ úri ĩfũúpi rĩ ri dụ ngóni ngóni. ");
INSERT INTO kbo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nyọ̃ọ́kụ́ rĩ sẽ úri rĩ ĩfũ dụ múké, drị̃drị̃ ni, bị́ ni ri íꞌdó ĩfũ, ãnyá rĩ ẽ drị̃ ri kúru íꞌdó ayi, ụ̃dụ̃ ni gé, ĩri kúru ꞌa mị be gbálígbálí. ");
INSERT INTO kbo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ãnyãngã rĩ ka dõ gí, ọ́mvụ́ ꞌdị́pa ri méngẽlẽsĩ íꞌdụ́ ãnyãngã rĩ lịzú ãní, ãꞌdiãtãsĩyã sâ ãnyãngã ĩkũnãzú rĩ ícá gí.” ");
INSERT INTO kbo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yẹ́sụ̃ ní gõzú ꞌyozú dị̃ị́ kĩnĩ, “Mãlũngã Múngú vé rĩ adri sụ̃ ãꞌdi tị́nị? Dõku Mâ áyú rí nãpí ngóni ni mãlũngã Múngú vé rĩ ã tã ũlũzú ãní? ");
INSERT INTO kbo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mãlũngã Múngú vé rĩ índré sụ̃ marígó fí be mãdãŋáŋá rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kádõ ĩri saá, ĩri ĩfũ dụ mba ãmbúgú, ĩri pẹtị ọ́mvụ́ agá rĩ pi ndẽ céré, drị́tị ni pi ĩgãrã ãcoco, ãríŋá rĩ pi ímụ́ jó sị sị́ ni gé.” ");
INSERT INTO kbo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yẹ́sụ̃ ímbá ꞌbá rĩ pi nãpí ãndíãndí ni pi sĩ, ãzini lẹ́tị ãndíãndí ni pi sĩ, kộpi ã ámákí rí tã rĩ ãní. ");
INSERT INTO kbo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yẹ́sụ̃ kãdõ rií tị Múngú vé rĩ ũlũú ꞌbá rĩ pi ní, ĩri ũlũ mụzú nãpí sĩ. ꞌBo ĩri dõ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ọ́ꞌdụ́kụ́lẹgúsĩ, ĩri tã rĩ vé ífífí ũlũ kộpi ní céré. ");
INSERT INTO kbo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ụ́ꞌdụ́ ãlu ãlu ꞌdãri sĩ ũndrésĩ, Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá áyúãyũ rĩ pi ní kĩnĩ, “Lẽ ꞌbâ zokí mụụ́ yị̃ị́ bãlãlã rĩ agásĩ álé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kộpi ní ꞌbá bị́trị́ká rĩ pi kuzú, Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi ní tụzú kũlúmgba Yẹ́sụ̃ ní tụzú rĩ agá, kộpi ní ꞌdezú zozú mụzú yị̃ị́ rĩ agásĩ. Kũlúmgba ã ụrụkọ anigé ꞌdekí mụụ́ kộpi ã vụ́drị̃ gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kúru ũlí vịị́pi ũkpõ be ni ní íngázú vịzú yị̃ị́ bãlãlã rĩ drị́gé sĩ. Yị̃ị́ rĩ ní ꞌbãzú úvázú kũlúmgba rĩ úvị́zú ngẽlé ngẽlé. Yị̃ị́ ní íꞌdózú tị̃zú kũlúmgba rĩ agá ꞌdãá, sẽ kũlúmgba rĩ lẽ tĩí ãní yị̃ị́ ã ndụ́gé. ");
INSERT INTO kbo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ị́sụ́zú Yẹ́sụ̃ la ụ́ꞌdụ́ koó kũlúmgba rĩ agá vúlé ꞌdãá, ẹ̃tị̃ ꞌî drị̃ mãkádã sĩ. Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi ní Yẹ́sụ̃ ri zịzú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ímbápi, ꞌbâ ri tĩ yị̃ị́ ã ndụ́gé, mí ásí ꞌbá sĩ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yẹ́sụ̃ ní aruzú ụ́ꞌdụ́ gélésĩ, ĩri ní trezú ũlí vịị́pi ũkpõ be rĩ drị̃gé kĩnĩ, “ꞌÍ tu pá, ꞌdĩri ícó gí.” Koro ũlí vịị́pi ũkpõ be rĩ ní pá tuzú, ãngũ rĩ ní újízú kíri. ");
INSERT INTO kbo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú kĩnĩ, “Ngá ĩmi ní adrizú ụ̃rị̃ sĩ rĩ ãꞌdi? Ĩmi ẹ̃ꞌyị̃ngárá ãkó?” ");
INSERT INTO kbo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi, ụ̃rị̃ fi kộpi ẽ ẹ́sị́ agá ambamba, kộpi ní ꞌdezú ĩ uzịzú ĩ ãsámvú gé sĩ kínĩ, “ꞌBá ꞌdĩri ꞌbá íngóni ni, átángá átápi ũlí vịị́pi ũkpõ be rĩ ní tị ni yịị́ ĩndĩ ꞌdĩri?” ");
INSERT INTO kbo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yẹ́sụ̃ pi ní kúru zozú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be yị̃ị́ bãlãlã rĩ agásĩ, kộpi ní cazú ãngũ Gẽrásã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yẹ́sụ̃ kã ĩfũú kũlúmgba rĩ agásĩ, koro ágó índrí ũnjí ní fií drị̃ ni gé ni ní ĩfũzú vũrã ĩ ní rizú ãvũ sị̃zú rĩ gé ꞌdãásĩ, ímụ́zú Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ágó rĩ ri adri ꞌbụ́rẹ̃drị̃ rĩ pi ãsámvú gé ꞌdãá, ꞌbá ãzi ícó ĩri úmbé ímvẽ sĩ bã ku. ");
INSERT INTO kbo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ándúrú ĩ njị̃ị́ ri ágó rĩ ẽ drị́ pi úmbé pá ni pi be ímvẽ sĩ, ꞌbo ĩri ímvẽ ĩ ní ꞌî drị́ pi úmbézú ꞌî pá be ꞌdĩꞌbée ũŋõ kpélékpélé ꞌdĩísĩ rá, ꞌbá ãzi ícópi ágó ꞌdĩri ã ũkpõ ndẽépi ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ụ̃tụ́ŋá sĩ ãzini ị́nị́ŋá sĩ, ágó rĩ ri ẹ́cị́ ꞌbụ́rẹ̃drị̃ rĩ pi ãsámvú gé sĩ, ãngũ ánga rú rĩ pi ãsámvú gé sĩ, pí útréngárá be, ĩri ri írã anjiŋá íꞌdụ́ ꞌî rụ́ꞌbá ũsĩ ãní. ");
INSERT INTO kbo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ágó rĩ kã Yẹ́sụ̃ ri ndreé rárá rú ꞌdãá, ĩri ní njuzú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ĩri ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Yẹ́sụ̃, Mvá Múngú Ũkpõ ꞌDị́pa vé rĩ, ngá mí ní lẽé má vúgá rĩ ãꞌdi? ꞌÍ sõ ũyõ Múngú ẹndrẹtị gé ꞌyozú kínĩ, mí ícó ma ꞌoó ũnjí ku!” ");
INSERT INTO kbo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ágó rĩ átá ꞌdíni, ãꞌdiãtãsĩyã Yẹ́sụ̃ ní ꞌyoó índrí ũnjí rĩ pi ní, kộpi ã fũkí ágó rĩ drị̃gé sĩ rá rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yẹ́sụ̃ ní kúru ágó rĩ zịzú kĩnĩ, “Mî rụ́ ãꞌdi ꞌi?” Ágó rĩ ní újázú Yẹ́sụ̃ ní kĩnĩ, “Mâ rụ́ Bị́trị́ká ꞌi, ãꞌdiãtãsĩyã ꞌbâ kárákará.” ");
INSERT INTO kbo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kúru índrí ũnjí rĩ pi ní Yẹ́sụ̃ ri mãzú kínĩ, Yẹ́sụ̃ ã dro ĩ fũú ãngũ rĩ agásĩ ãmvé ku. ");
INSERT INTO kbo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ánga ꞌdãri ã pálé gá ꞌdãá, ĩ ri ĩgá úcé, ĩgá rĩ pi kárákará. ");
INSERT INTO kbo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Índrí ũnjí rĩ pi ní rizú Yẹ́sụ̃ ri mãzú kínĩ, “ꞌÍ pẽ ꞌbâ mụụ́ adrií ĩgá ꞌdãꞌbée ãsámvú gé fô, mí ãꞌyĩ ꞌbá ní, ꞌbâ mụkí úfí ĩgá rĩ pi agá.” ");
INSERT INTO kbo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yẹ́sụ̃ ní ãꞌyĩzú kộpi ní. Índrí ũnjí rĩ pi ní úkpúzú ágó rĩ drị̃gé sĩ, mụzú úfízú ĩgá rĩ pi agá. Ĩgá rĩ pi élĩfũ ị̃rị̃. Ĩgá rĩ pi ní njuzú mụzú ọ́ngụ́ sĩ ãngũ úlúpi úlúlũ rĩ gé ꞌdãá, kộpi ní uꞌdezú yị̃ị́ bãlãlã rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ꞌBá riꞌbá ĩgá úcéꞌbá rĩ pi kâ tã ꞌdĩri ndreé, kộpi ngakí únjú mụzú tã ꞌdĩri ũlũú ꞌbá kụ̃rụ́ agá ꞌdãlé rĩ pi ní, ãzini ꞌbá adriꞌbá gụ́rụ́ kụ̃rụ́ rĩ ã gãrã gá sĩ rĩ agá rĩ pi ní. ꞌBá rĩ pi ní mụzú tã ꞌi ꞌoópi ꞌdĩri ndrezú. ");
INSERT INTO kbo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kộpi kâ caá Yẹ́sụ̃ vúgá ꞌdãlé, kộpi ị́sụ́kí ágó índrí ũnjí ní fií drị̃ ni gé kárákará rĩ ícá múké gí, úrí kuú Yẹ́sụ̃ ẹndrẹtị gé, su bõngó ꞌî rụ́ꞌbá gá, úmĩ ni ícá múké gí. Tã ꞌdĩri sẽ kộpi ní ụ̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ꞌBá tã ꞌi ngaápi ágó rĩ ã rụ́ꞌbá gá rĩ ndreꞌbá, ãzini ĩgá rĩ pi ã rụ́ꞌbá gá rĩ ndreꞌbá ĩ mị sĩ rĩ pi ní mụzú tã rĩ ũlũzú ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kúru ꞌbá ãngũ ꞌdãri agá rĩ pi ní ꞌyozú kínĩ, Yẹ́sụ̃ ã nga mụụ́ ĩvé ãngũ agásĩ ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yẹ́sụ̃ kã rií tụụ́ kũlúmgba rĩ agá ꞌdãá, ágó Yẹ́sụ̃ ní índrí ũnjí droó fũú drị̃ ni gé sĩ rĩ ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, ꞌí lẽ mụụ́ Yẹ́sụ̃ vúgá sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ꞌBo Yẹ́sụ̃ ãꞌyĩ ĩri mụụ́ ꞌí vúgá sĩ kuyé, pẽ ĩri ẽ tị kĩnĩ, “ꞌÍ mvi ꞌbẹ̃tị́, ꞌí mụ tã ãyãzú ãyãyã Úpí ní ꞌoó mî rụ́ꞌbá gá, ãzini ẹ́sị́ ĩdríkídri ĩri ní ꞌbãá mí ní ꞌdĩri vé tã ũlũú mívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ágó rĩ ní kúru ꞌdezú ẹ́cị́zú tã Yẹ́sụ̃ ní ꞌoó ꞌí ní rĩ ũlũzú mụzú kụ̃rụ́ mụdrị́ ĩ ní zịị́ Dẽkãpólĩsĩ vé rĩ agásĩ. Tã ágó rĩ ní ũlũú rĩ sẽ ꞌbá rĩ pi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yẹ́sụ̃ kã ꞌi újá gõó zoó mụzú álé ꞌdãá kũlúmgba sĩ, ꞌbá bị́trị́ká ímụ́kí ĩ úmú adrií Yẹ́sụ̃ ã gãrã gá sĩ kụ́rụ̃ yị̃ị́ tị gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ágó ãzi rụ́ ni Yáyĩrõ ꞌi, ĩri drị̃koma Jó Múngú ri Zịzú rĩ vé ni, ĩri ní ímụ́zú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ");
INSERT INTO kbo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ĩri ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, “Mávé mvá ũkúŋá rĩ ꞌdãlé drã be ũnjíkãnyãkãnyã, lẽ drãádrã, ꞌí mụ drị́ tị̃ị́ drị̃ ni gé, ẽ ídrí rí bẽnĩ fô.” ");
INSERT INTO kbo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kúru Yẹ́sụ̃ pi ní ꞌdezú mụzú ĩri be ĩrivé ãngá ꞌdãá. ꞌBá bị́trị́ká ꞌdekí mụụ́ ĩri vúgá sĩ ĩndĩ, kộpi rikí ĩri ũmĩí mụzú ũmĩmĩ, ãꞌdiãtãsĩyã ꞌbá rĩ pi ní adrií tré rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ụ́ꞌdụ́ ꞌdãri sĩ, ũkú ãzi ꞌbá bị́trị́ká rĩ pi ãsámvú gé ꞌdãá, mbãá ụ́ꞌdụ́ ri ẹ́cị́ rụ́ꞌbá ni gé sĩ, gã dẹgá sĩ, ꞌdụ caá ílí mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ũkú rĩ ẹ́cị́ ꞌbá kárákará ũjó sẽꞌbá ni pi vúgá sĩ ílí be aco, iza ívé mũfẽngã ambamba ũjó ãrẽgá sĩ drã ꞌdĩri vé tã sĩ, ꞌbo ꞌbá ãzi ícópi ĩri ní ũjó sẽépi ĩrivé drã ꞌdĩri ní dẹzú ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ũkú rĩ kã Yẹ́sụ̃ vé tã yịị́, ĩri ní ꞌi útrúzú ĩnyiŋá Yẹ́sụ̃ ã úgóró gá ꞌbá bị́trị́ká rĩ pi ãsámvú gé ꞌdãá, ĩri ní Yẹ́sụ̃ vé bõngó akoóko rĩ úlózú. ");
INSERT INTO kbo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ũkú rĩ ụ̃sụ̃ kĩnĩ, “Má úló dõ Yẹ́sụ̃ vé bõngó, ma ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ũkú rĩ kã Yẹ́sụ̃ vé bõngó ẽ tị úló, mbẽlẽŋá ãrí ẹ́cị́pi rụ́ꞌbá ni gé sĩ rĩ ní pá tuzú, koro ũkú rĩ gõ ámá ꞌî rụ́ꞌbá ícá múké gí. ");
INSERT INTO kbo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sâŋá ꞌdãri gé, Yẹ́sụ̃ nị̃ ámá rá ꞌyozú kínĩ, ívé ũkpõ fũ ꞌî rụ́ꞌbá gá sĩ gí. Yẹ́sụ̃ ní ꞌi újázú ãngũ ndrezú ꞌbá bị́trị́ká rĩ pi vúgá ꞌdãá, ĩri ní kộpi zịzú kĩnĩ, “Ãꞌdi úló mávé bõngó nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní újázú ĩri ní kínĩ, “Mí nị̃ rá ꞌbá rĩ pi kárákará ri ĩ mĩ ímụ́zú mî rụ́ꞌbá gá nõó, ngá mí ní ꞌbâ zịzú ꞌyozú kínĩ, ãꞌdi úló mívé bõngó nĩ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ꞌBo Yẹ́sụ̃ ri ꞌbá ívé bõngó úlópi rĩ úndré ꞌbá rĩ pi ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ũkú rĩ kã tã ꞌi ngaápi ꞌî rụ́ꞌbá gá ꞌdĩri nị̃ị́ ámá, ụ̃rị̃ sĩ, rụ́ꞌbá ni íꞌdó rií yãáyã. Ĩri ní ímụ́zú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní tã ꞌí ní bõngó rĩ úlózú rĩ ũlũzú Yẹ́sụ̃ ní céré. ");
INSERT INTO kbo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yẹ́sụ̃ ní kúru ꞌyozú ũkú rĩ ní kĩnĩ, “Mvá ũkú ꞌdĩri, ẹ̃ꞌyị̃ngárá mívé rĩ sẽ mí ídrí gí. ꞌÍ mụ ĩyí, tãkíri Múngú vé rĩ ã adri mí be, mî rụ́ꞌbá ã adri ule.” ");
INSERT INTO kbo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yẹ́sụ̃ kã rií átá ũkú rĩ be, koro ãgõ ụrụkọꞌbée ní ícázú, kộpi íbíkí ímụ́ Yáyĩrõ vé ãngá ꞌdãásĩ, kộpi ní ꞌyozú Yáyĩrõ ní kínĩ, “Mívé mvá ũkúŋá rĩ drã gí, lẽ mî ri sâ izaá átázú ꞌbá riípi ãngũ ímbápi rĩ be ku.” ");
INSERT INTO kbo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yẹ́sụ̃ kã tã ꞌdĩri yịị́, ĩri ní ꞌyozú Yáyĩrõ ní kĩnĩ, “Lẽ mî ẹ́sị́ ã ũtĩ ku, mí ẹ̃ꞌyị̃ mávé tã.” ");
INSERT INTO kbo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yẹ́sụ̃ lẽ ꞌbá ãzi ã mụ ꞌí vúgá sĩ ku, ãꞌyĩ ꞌyéŋá Pétẽró pi, Yõkóbũ be, Yũwánĩ Yõkóbũ ẹ́drị́pị sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kộpi kâ mụụ́ caá Yáyĩrõ vé ãngá ꞌdãá, Yẹ́sụ̃ ndre ꞌbá rĩ pi ri lụ̃ụ́lụ́ gá. ");
INSERT INTO kbo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yẹ́sụ̃ ní fizú jó agá ꞌdãá, ĩri ní ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “Ngá ĩmi ní rizú lụ̃ụ́lụ́ gazú ꞌdíni rĩ ãꞌdi? Mvá ũkúŋá rĩ drã kuyé, ĩri ụ́ꞌdụ́ ko.” ");
INSERT INTO kbo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ꞌBo ꞌbá rĩ pi rikí gụụ́ ĩri sĩ gụgụ. Yẹ́sụ̃ ní ꞌyozú kĩnĩ, ꞌbá rĩ pi ã fũkí céré ãmvé, ãꞌyĩ ꞌyéŋá ãvũ rĩ vé ẹ́tẹ́pị pi ẹ́ndrẹ́pị be, ãzini ívé ꞌbá áyúãyũ na ꞌdĩꞌbée be, kộpi fikí mụzú jó ãvũ rĩ ꞌbãzú rĩ agá ꞌdãá nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ĩri ní mvá ũkúŋá rĩ ẽ drị́ rụzú, ĩri ní ꞌyozú kĩnĩ, “Tãlítã kụ́mị̃!” Ífífí ni kĩnĩ, “Mvá ũkúŋá mãdãŋá ꞌdĩri, á ꞌyo mí ní, ꞌí nga ụrụ.” ");
INSERT INTO kbo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mvá ũkúŋá rĩ ní koro íngázú ụrụ, ĩri ní ꞌdezú ẹ́cị́zú ụrụ sĩ. Mvá ũkúŋá rĩ ílí be mụdrị́ drị̃ ni ị̃rị̃. Tã ꞌdĩri sẽ ꞌbá rĩ pi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ꞌBo Yẹ́sụ̃ ní átázú kộpi ní ũkpó ũkpó kĩnĩ, lẽ kộpi ã ũlũkí tã ꞌdĩri ꞌbá ãzi ní ku. Ĩri ní ꞌyozú kộpi ní kĩnĩ, lẽ kộpi ã sẽkí mvá ũkúŋá rĩ ní ngá nyaá. ");
INSERT INTO kbo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yẹ́sụ̃ ní ngazú ꞌdãásĩ, ĩri ní ꞌdezú mụzú Nãzẽrétã gá, kụ̃rụ́ ĩri ní mbazú rĩ gé. Kộpi mụkí ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be trụ́. ");
INSERT INTO kbo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ụ́ꞌdụ́ Sãbátã vé rĩ kã ícá, Yẹ́sụ̃ íꞌdó rií ꞌbá rĩ pi ímbá Jó Múngú ri Zịzú rĩ agá ꞌdãá. ꞌBá kárákará ĩrivé tã yịꞌbá rĩ pi ãyãkí tã ĩri ní átá ꞌdĩri sĩ ãyãyã. Kộpi rikí ĩ uzịị́ ĩ ãsámvú gé sĩ kínĩ, “Ágó ꞌdĩri ị́sụ́ tã nị̃ngárá, ãzini ũkpõ tã ãyãzú ãyãyã ꞌozú ꞌdĩri íngũgá? ");
INSERT INTO kbo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ágó ꞌdĩri adri nyo Mãríyã mvọ́pị ándúrú riípi párángi faápi ꞌdĩgé rĩ ꞌi kuyé? Yõkóbũ pi Yósẽ be, Yụ́dã be, Sị̃mọ́nã sĩ, adrikí ĩri ẹ́drị́pị kuyé? Ĩrivé ọ́mvụ́pị́ị riꞌbá adriꞌbée ꞌbá be kụ̃rụ́ ꞌbávé rĩ agá nõꞌbée kuyé?” Tã ándúrú Yẹ́sụ̃ ní ꞌoó ꞌdĩꞌbée sĩ, ꞌbá rĩ pi gãkí ĩri sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩ nẹ́bị̃ rĩ pi ị̃njị̃ vũrã ụrụkọ agásĩ ị̃njị̃njị̃, ꞌbo kụ̃rụ́ ĩrivé rĩ agá, ị̃njị̃kí ĩri ku, ꞌbá ĩrivé ꞌbẹ̃tị́ ãsámvú gé rĩ pi, ĩrivé máríté rĩ pi be, kộpi ị̃njị̃kí ĩri ku.” ");
INSERT INTO kbo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yẹ́sụ̃ gõ tã ãyãzú ãyãyã ni ꞌoó ãngũ ꞌdãri gé dị̃ị́ kuyé, tã ĩri ní ꞌoó rá rĩ, Yẹ́sụ̃ tị̃ drị́ ꞌbá drã be ni pi drị̃gé, kộpi ídríkí rá, ꞌbá ĩri ní drị́ tị̃ị́ kộpi drị̃gé rĩ pi vé kãlãfe mãdãŋá. ");
INSERT INTO kbo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tã ꞌdĩri sẽ Yẹ́sụ̃ ní ãyãngárá, ꞌbá rĩ pi ní gãá ꞌi ẹ̃ꞌyị̃gá sĩ rĩ sĩ. Yẹ́sụ̃ ní kúru ꞌdezú rizú ꞌbá rĩ pi ímbázú mụzú gụ́rụ́ ãlu ãlu agásĩ. ");
INSERT INTO kbo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yẹ́sụ̃ ní ívé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi zịzú ímụ́zú vũrã ãlu gé, pẽ kộpi mụzú ị̃rị̃ ị̃rị̃, sẽ kộpi ní ũkpõ índrí ũnjí rĩ pi údrózú. ");
INSERT INTO kbo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi ꞌdụkí ngá ãzi mụzú ĩmi drị́gé sĩ ĩndĩ ku, ꞌyéŋá ĩmi ꞌdụkí túré ẹ̃cị̃ tuzú ni áyu. Ĩmi kádõ rií mụụ́, lẽ ĩmi ꞌdụkí kũmvũ mụzú ĩndĩ ku, ĩmi ꞌdụkí ãnyãngã dõku mũfẽngã mụzú ĩndĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ĩmi úsúkí ngá pá gá ni pi mụzú, ꞌbo ã ꞌdụkí bõngó ãzi ãndõ rú mụzú ĩndĩ ku. ");
INSERT INTO kbo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kụ̃rụ́ ãlu ãlu ĩmi ní cazú rĩ agá, ꞌbẹ̃tị́ ĩ ní ĩmi ẹ́ꞌyị́zú drị̃drị̃ rĩ, ĩmi áwíkí adrií ꞌdãgá, cĩmgbá ĩmi ní fũzú kụ̃rụ́ rĩ agásĩ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Vũrã ãlu ãlu ĩmi ní fizú cazú rĩ agá, ꞌbá rĩ pi gãkí dõ ĩmi ẹ́ꞌyị́gá sĩ, ãzini gãkí dõ ụ́ꞌdụ́kọ́ múké ĩmi ní ũlũú rĩ yịgá sĩ, ĩmi kádõ ngaá mụụ́, ĩmi wekí nyọ̃ọ́kụ́ ĩmî pá ágélé gá rĩ kú ꞌdĩgé. Ĩri lũ ꞌyozú kínĩ, ĩmi gãkí ꞌbá gụ́rụ́ ꞌdãri agá rĩ pi sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi ní kúru ꞌdezú mụzú ụ́ꞌdụ́kọ́ múké rĩ ũlũngárá gá kínĩ, lẽ ꞌbá rĩ pi ã újákí ẹ́sị́, kộpi ã kukí ũnjĩkãnyã ãní. ");
INSERT INTO kbo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kộpi údrókí índrí ũnjí kárákará ũfũú ꞌbá rĩ pi drị̃gé sĩ, ũbẽkí ũdu ꞌbá drã be rĩ pi rụ́ꞌbá gá sĩ, kộpivé drã dẹ ãní rá. ");
INSERT INTO kbo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ꞌBãgú Ẽródẽ yị ꞌbá rĩ pi ãrẽvú céré rikí átá Yẹ́sụ̃ vé tã sĩ. ꞌBá rĩ pi ụrụkọ rikí átá kínĩ, “Yũwánĩ Bãtízĩmũ sẽépi rĩ ingakí ĩri gõó ídri rú drãngárá gálésĩ gí, ĩri ní rizú tã ãyãzú ãyãyã ꞌdĩꞌbée ꞌozú ũkpõ be ꞌdíni ãní.” ");
INSERT INTO kbo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ꞌBá ụrụkọꞌbée rikí ꞌyoó kínĩ, “ꞌBá rĩ Ẽlíyã ꞌi.” Ụrụkọꞌbée kínĩ, “ꞌBá rĩ índré sụ̃ nẹ́bị̃ ọ́tụ́ ụ̃kụ rĩ pi vé ãzi tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ẽródẽ kã tã ꞌdĩri yịị́, ĩri ní ꞌyozú kĩnĩ, “Índrézú ꞌbá ꞌdĩri Yũwánĩ má ní ọ́tụ́ drị̃ ni lịị́ ꞌdãri íngá gõó ídri rú drãngárá gálésĩ nĩ!” ");
INSERT INTO kbo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ọ́tụ́ Ẽródẽ sẽ tãị́mbị́ kĩnĩ, ã rụkí Yũwánĩ ri, ã ꞌbekí ĩri jó ãngũ ũꞌyĩzú rĩ agá. Ẽródẽ ꞌo tã ꞌdĩri ꞌdíni, ãꞌdiãtãsĩyã ꞌí ní ẹ́drị́pị Pĩlípũ vé ũkú Ẽrõdíyã ri jeé ꞌí ní ũkú rú rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ãꞌdiãtãsĩyã Yũwánĩ ri ꞌyoó Ẽródẽ ní kĩnĩ, “Tãị́mbị́ ãꞌyĩ kuyé ꞌyozú kínĩ, mí ní mí ẹ́drị́pị vé ũkú jezú.” ");
INSERT INTO kbo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ãní sẽ Ẽrõdíyã ꞌbã ẹ́sị́ ũnjí Yũwánĩ ní, lẽ ĩri ꞌdịị́ drãá ꞌdĩísĩ rá. ꞌBo Ẽródẽ ní ãꞌyĩí kuyé rĩ sĩ, Yũwánĩ vé ꞌdịngárá ã tã mba Ẽrõdíyã ní mbamba. ");
INSERT INTO kbo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ẽródẽ ru Yũwánĩ ri ruru, nị̃ ámá rá ꞌyozú kínĩ, Yũwánĩ ri ꞌbá tã be pịrị ni, ãzini ꞌbá uletere ni, sẽ Ẽródẽ ri Yũwánĩ ã tã mbaá múké. Ẽródẽ kã tã Yũwánĩ ní átá rĩ yịị́, sẽ drị̃ ni ábá ãní céré céré, ꞌbo ꞌbã úvá rizú Yũwánĩ vé tã yịzú. ");
INSERT INTO kbo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kúru Ẽródẽ ní ụ̃mụ̃ údézú ívé ụ́ꞌdụ́ ĩ ní ꞌi tịzú rĩ ị̃njị̃zú ãní. Ĩri ní ũgalaku ambugu rĩ pi zịzú ũgalaku ambugu ãngáráwá rĩ pi vé rĩ pi be, ãzini drị̃koma ãngũ Gãlĩláyã vé rĩ agá rĩ pi be ímụ́zú ụ̃mụ̃ rĩ gé. Ụ̃mụ̃ ꞌdĩri zị̃ nóni lẹ́tị Ẽrõdíyã ní Yũwánĩ ri ꞌdịzú drãzú ãní. ");
INSERT INTO kbo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ẽrõdíyã vé mvá ũkúŋá rĩ ní ífízú úngó tuzú ꞌbá rĩ pi ẹndrẹtị gé ꞌdĩgé, sẽ ãyĩkõ fụ Ẽródẽ pi ívé ụ̃mụ́ rĩ pi be ambamba. Ẽródẽ ní ꞌyozú mvá ũkúŋá rĩ ní kĩnĩ, “Ngá mí ní lẽé rĩ, ma sẽ mí ní rá.” ");
INSERT INTO kbo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ẽródẽ ní ũyõ sõzú kĩnĩ, “Ngá mí ní lẽé rĩ, ma ícó sẽ mí ní rá, mãlũngã má ní rụụ́ nõri, ma ĩgélé ni ãmbúgú rĩ sẽ mí ní rá.” ");
INSERT INTO kbo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mvá ũkúŋá rĩ ní fũzú mụzú ẹ́ndrẹ́pị ri zịzú kĩnĩ, “Mâ zị ngá íngóni ni?” Ẹ́ndrẹ́pị ní újázú ĩri ní kĩnĩ, “ꞌÍ ꞌyo ã lịkí mí ní Yũwánĩ Bãtízĩmũ sẽépi rĩ ẽ drị̃ sẽé.” ");
INSERT INTO kbo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mvá ũkúŋá rĩ ní gõzú ꞌi újázú mụzú rụ́ꞌbá sĩ Ẽródẽ vúgá ꞌdãá, ꞌyozú ĩri ní kĩnĩ, “Ngá má ní lẽé mî sẽ má ní úꞌdíkírĩŋá nõgó rĩ, ã lịkí Yũwánĩ Bãtízĩmũ sẽépi rĩ ẽ drị̃ ꞌbãá ĩgã agá.” ");
INSERT INTO kbo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tã ꞌdĩri sẽ ꞌbãgú rĩ ní ĩzãngã ambamba, ꞌbo lẽ ũyõ ꞌí ní sõó ụ̃mụ́ rĩ pi ẹndrẹtị gé ꞌdĩri ŋõó ku. ");
INSERT INTO kbo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Koro ĩri ní ãngáráwá ãlu pẽzú mụzú jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá, ꞌyozú ĩri ní kĩnĩ, ã lị Yũwánĩ ẽ drị̃ íjị́ ꞌí vú nõó. Ãngáráwá rĩ ní kúru mụzú jó ãngũ ũꞌyĩzú rĩ agá ꞌdãá, ĩri ní Yũwánĩ ẽ drị̃ lịzú. ");
INSERT INTO kbo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ĩri ní Yũwánĩ ẽ drị̃ ꞌbãzú ĩgã agá, íjị́zú sẽzú mvá ũkúŋá rĩ ní. Mvá ũkúŋá rĩ ní kúru Yũwánĩ ẽ drị̃ jịzú mụzú sẽzú ẹ́ndrẹ́pị drị́gé. ");
INSERT INTO kbo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yũwánĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi kâ tã ꞌdĩri yịị́, kộpi ní mụzú Yũwánĩ vé ãvũ ꞌdụzú jịzú mụzú sị̃zú vũrã ĩ ní rizú ãvũ sị̃zú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi kâ ímví ĩgõó vúlé nõó, kộpi ꞌdekí rií ẹ̃zị́ ĩ ní ngaá, ãzini tã ĩ ní ímbá rĩ vé tã ũlũú Yẹ́sụ̃ ní. ");
INSERT INTO kbo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ꞌBá bị́trị́ká riꞌbá ẹ́cị́ꞌbá rĩ pi, ụrụkọꞌbée dị̃ ífí be, ụrụkọꞌbée dị̃ fũ be mụzú, sẽ Yẹ́sụ̃ pi ívé ꞌbá áyúãyũ rĩ pi be ị́sụ́kí sâ ãnyãngã nyazú ni kuyé. Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá áyúãyũ rĩ pi ní kĩnĩ, “Ĩmi ngakí, ꞌbâ mụkí uvuú vũrã kíri ni gé.” ");
INSERT INTO kbo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kúru Yẹ́sụ̃ pi ní tụzú ívé ꞌbá áyúãyũ rĩ pi be kũlúmgba agá, kộpi ní mụzú adrizú vũrã kíri ꞌbá ãkó ni gé. ");
INSERT INTO kbo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ꞌBo ꞌbá rĩ pi kâ ndreé Yẹ́sụ̃ pi ꞌdekí mụzú gí, ꞌbá rĩ pi ngakí njuú mụzú ọ́ngụ́ sĩ, íngázú kụ̃rụ́ ãndíãndí ni pi agásĩ, kộpi njukí caá vũrã Yẹ́sụ̃ pi ní lẽzú mụzú uvuzú rĩ gé ꞌdãá drị̃drị̃. ");
INSERT INTO kbo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yẹ́sụ̃ ísị́ kũlúmgba rĩ agásĩ, kã ꞌbá bị́trị́ká rĩ pi ndreé, kộpivé tã fi ẹ́sị́ ni gé ĩzãngã rú, ãꞌdiãtãsĩyã kộpi índrékí sụ̃ kãbĩlõ ꞌbá úcépi ni ní adrií ꞌdãáyo rĩ tị́nị. Yẹ́sụ̃ ní kúru íꞌdózú kộpi ímbázú, ímbá kộpi ní tã kárákará. ");
INSERT INTO kbo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ụ̃tụ́ rĩ kã ꞌdeé, Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ímụ́zú ꞌyozú Yẹ́sụ̃ ní kínĩ, “ꞌBá ímụ́kí kuú rárá rú ãngũ ꞌbá ãkó ni gé, ụ̃tụ́ rĩ ꞌde nóni gí. ");
INSERT INTO kbo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Lẽ mî pẽ ꞌbá rĩ pi mụzú, kộpi ã mụkí rí ĩ ní ãnyãngã ndãá gụ́rụ́ ĩnyiŋá rĩ pi agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ꞌBo Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi sẽkí kộpi ní ngá nyanya, kộpi ã nyakí.” Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “ꞌBâ ị́sụ́kí rí mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ mụ̃dụ̃rụ̃lụ̃ ị̃rị̃ ãnyãngã jezú ꞌbá bị́trị́ká nõꞌbée ní ngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Pánga ĩmi vúgá ꞌdĩlé ngõpí? Ĩmi mụkí ndreé.” Kộpi kâ ị́sụ́ nị̃ị́, kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “Ngá ꞌbá ní ị́sụ́ anigé rĩ, ĩri ꞌyéŋá pánga tọ̃wụ́, ị̃ꞌbị́ be ị̃rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yẹ́sụ̃ ní kúru ꞌyozú kộpi ní kĩnĩ, ĩmi lũkí ꞌbá rĩ pi ã úríkí vũgá ngúlúmũ rú ngúlúmũ rú ásé drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kộpi ní kúru ꞌbá rĩ pi trazú úrízú ngúlúmũ rú ngúlúmũ rú. Ngúlúmũ ụrụkọ agá, ꞌbá rĩ pi úríkí mụ̃dụ̃rụ̃lụ̃ ãlu ãlu, ụrụkọ ni agá, ꞌbá rĩ pi úríkí pụ̃kụ́ tọ̃wụ́ tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yẹ́sụ̃ ní pánga tọ̃wụ́ ꞌdĩꞌbée íꞌdụzú ị̃ꞌbị́ ị̃rị̃ rĩ be, ĩri ní ingazú suzú ụrụ, ĩri ní ãngũ ndrezú ꞌbụ̃ gé ꞌdãá, ĩri ní õwõꞌdĩfô sẽzú Múngú ní, ĩri ní pánga rĩ ũndĩzú sẽzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi drị́gé, ĩri ní kpá ị̃ꞌbị́ ị̃rị̃ ꞌdĩꞌbée íꞌdụ́zú sẽzú kộpi drị́gé, kộpi ní kúru awazú mụzú ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ꞌBá ãlu ãlu ị́sụ́ ãnyãngã nyaá ẹ́pị́zú ãní rá. ");
INSERT INTO kbo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ĩkũnãkí pánga, ãzini ị̃ꞌbị́ ĩ ní awaá nyaá ꞌbá rĩ pi ní rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ãgõ ãnyãngã rĩ nyaꞌbá rĩ pi vé kãlãfe ca élĩfũ tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Koro Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi sẽzú tụzú kũlúmgba agá, kộpi ã ꞌdekí mụụ́ Bẽtẽsãyídã gá ꞌdãlé drị̃drị̃, ị́sụ́zú ĩri ri ꞌbá bị́trị́ká rĩ pi ayi vúlé nõó. ");
INSERT INTO kbo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yẹ́sụ̃ kã ꞌbá rĩ pi ayií gí, ĩri ní mụzú írã drị̃gé Múngú ri zịngárá gá. ");
INSERT INTO kbo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kã mụụ́ caá ị́nị́ŋá sĩ, ị́sụ́ kũlúmgba rĩ fi caá Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi be yị̃ị́ bãlãlã rĩ agá bị̃lị́bị́lị ꞌdãá gí, kukí Yẹ́sụ̃ ri kú ọ́ꞌdụ́kụ́lẹgúsĩ ãmvé nõó. ");
INSERT INTO kbo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yẹ́sụ̃ ndre ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ri ĩzãngã ị́sụ́ ambamba kũlúmgba rĩ ã sõngárá gá, ãꞌdiãtãsĩyã ũlí rĩ ri kũlúmgba rĩ vịị́ ayaá ũkpõ sĩ. Ãngũ rĩ ní drĩ ọ́wụ́zú kuyé rĩ gé, Yẹ́sụ̃ ní rizú ímụ́zú kộpi vúgá nõó yị̃ị́ rĩ drị̃gé sĩ pá sĩ, lẽ kõdô agaá kộpi ã gãrã gá sĩ, ");
INSERT INTO kbo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ꞌbo kộpi kâ ndreé Yẹ́sụ̃ ri ímụ́ yị̃ị́ rĩ drị̃gé sĩ pá sĩ, kộpi ngakí rií útré ụ̃rị̃ sĩ, kộpi ụ̃sụ̃kí kínĩ tãnâ ngá rĩ índrí. ");
INSERT INTO kbo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kộpi kâ ndreé Yẹ́sụ̃ ri ímụ́ yị̃ị́ rĩ drị̃gé sĩ pá sĩ, kộpi adrikí céré ụ̃rị̃ sĩ. Koro Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌokí ụ̃rị̃ sĩ ku, ꞌbá rĩ ma ꞌi, ĩmi úmbékí ẹ́sị́.” ");
INSERT INTO kbo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yẹ́sụ̃ ní kúru tụzú kũlúmgba rĩ agá ꞌdãá, ũlí rĩ ní pá tuzú. Sẽ Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kộpi nị̃kí ãnyãngã Yẹ́sụ̃ ní sẽé vaápi ꞌdĩri vé ífífí kuyé, ọ̃zụ̃kí kộpivé úmĩ rá, sẽ kộpi nị̃kí tã ꞌdĩri ámá kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yẹ́sụ̃ pi kâ yị̃ị́ bãlãlã rĩ zoó, kộpi ní mụzú ísị́zú Gẽnẽsãrétã gá, kộpi ũꞌyĩkí ụ̃mgbụ̃ aya rú ni pi bãákú sĩ, úꞌbé yị̃ị́ agá ꞌdãá, kũlúmgba rĩ ní pá tuzú ꞌdãgá. ");
INSERT INTO kbo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kộpi kâ ísị́ kũlúmgba rĩ agásĩ, ꞌbá rĩ pi nị̃kí Yẹ́sụ̃ ri ámá bá. ");
INSERT INTO kbo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ꞌBá ãngũ ꞌdãri agá rĩ pi ní ínjúzú céré ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní ĩvé ꞌbá drã be rĩ pi uꞌdụzú íjị́zú ĩri vúgá nõó pọ́rọ̃sị̃ sĩ vũrã kộpi ní yịị́ ĩri ní adrizú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yẹ́sụ̃ ri ẹ́cị́ mụzú gụ́rụ́ rĩ pi agásĩ, kụ̃rụ́ rĩ pi agásĩ, ãzini ꞌbẹ̃tị́ rĩ pi agásĩ. Vũrã ĩri ní ẹ́cị́zú ꞌdĩꞌbée agásĩ, ꞌbá rĩ pi rikí ĩvé ꞌbá drã be rĩ pi íjị́ ímụ́zú vũrã jọ̃kọ́nị̃ vé rĩ gé. ꞌBá rĩ pi rikí Yẹ́sụ̃ ri mãá kínĩ, ꞌbá drã be rĩ pi ã úlókí ĩrivé bõngó ẽ tị. ꞌBá céré Yẹ́sụ̃ vé bõngó akoóko rĩ ẽ tị úlóꞌbá rá rĩ pi, kộpivé drã dẹ kộpi ã rụ́ꞌbá gá sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fãrụ́sị̃ rĩ pi ã ụrụkọ ãzini ꞌbá Mósẽ vé tãị́mbị́ ímbáꞌbá íngáꞌbá Yẹ̃rụ́sãlémã gálésĩ rĩ pi ã ụrụkọꞌbée be, ímụ́kí ĩ traá Yẹ́sụ̃ ã gãrã gá sĩ kụ́rụ̃. ");
INSERT INTO kbo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kộpi ndrekí Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi íꞌdókí rií ínyá nyaá, ũjĩkí ĩ drị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fãrụ́sị̃ rĩ pi Yãhụ́dị̃ ụrụkọꞌbée be, kộpi kádõ íꞌdó ínyá nyaá, kộpi céré ĩ drị́ ũjĩ ꞌdéꞌdé sụ̃ ĩvé mẽrẽ ĩ ẹ́ꞌbị́pị́ị vé rĩ ní lẽé rĩ tị́nị, kộpi íbí ínyá rĩ nya ndõ. ");
INSERT INTO kbo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kộpi jekí dõ ngá ãzi jọ̃kọ́nị̃ gé, ũjĩkí dõ kuyé, ꞌbá ãzi ícó drĩ nyaá ku. Mẽrẽ ꞌdĩri kộpivé ni, kộpi áwíkí tã ni ꞌbãá kuú ũkpó ũkpó, kộpi ri ĩvé ngá ãnyãngã nyazú sụ̃ kópõ, sákãnĩ, ãzini bị̃nị́gã tị́nị rĩ pi ã ꞌa ũjĩ céré ũjĩjĩ. ");
INSERT INTO kbo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fãrụ́sị̃ rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “Mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi ꞌdụkí tã ꞌbá ẹ́ꞌbị́pị́ị ní ímbá rĩ ngaá ku ãsĩ? Kộpi kádõ rií ngá nyaá, kộpi ũjĩkí ĩ drị́ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi ꞌbá ĩ ꞌbãꞌbée kú tã be pịrị ꞌdĩꞌbée! Tã nẹ́bị̃ Ĩsáyã ní ꞌyoó ĩmi tã sĩ rĩ, ĩri pịrị. Sĩ ꞌdíni kĩnĩ, “ ‘ꞌBá ꞌdĩꞌbée ri ma íngú tị sĩ kána, ꞌbo kộpi ꞌbãkí ẹ́sị́ má drị̃gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kộpi ma ị̃njị̃ ku kána, tãị́mbị́ kộpi ní rií ímbá rĩ pi, ꞌbá áda ụ̃tị̃ nĩ.’ ");
INSERT INTO kbo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ĩmi gãkí tã Múngú vé rĩ ꞌdụgá ngagá sĩ. Ĩmi ꞌdụkí ĩmivé tã mẽrẽ vé rĩ ꞌbãá tã ãmbúgú rú.” ");
INSERT INTO kbo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yẹ́sụ̃ ní kúru ꞌyozú kộpi ní kĩnĩ, “Ĩmi kínĩ, ĩmi úmĩ be tãị́mbị́ Múngú vé rĩ gãzú, ĩmi áwíkí rí tã ĩmivé mẽrẽ vé rĩ ꞌdụụ́ ngaá áyu! ");
INSERT INTO kbo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mósẽ sẽ tãị́mbị́ ꞌdíni kĩnĩ, ‘Lẽ mî ị̃njị̃ mí ẹ́tẹ́pị pi mí ẹ́ndrẹ́pị be ị̃njị̃njị̃,’ ãzini ‘ꞌBá ẹ́tẹ́pị ri triípi, dõku ẹ́ndrẹ́pị ri triípi rĩ, ã ꞌdịkí ĩri drãá ꞌdĩísĩ rá.’ ");
INSERT INTO kbo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ꞌBo ĩmi ri ꞌbá rĩ pi ímbá, kộpi ícó ꞌyo ĩ ẹ́tẹ́pị́ị ní, ãzini ĩ ẹ́ndrẹ́pị́ị ní, ‘Má ícó ĩmi ĩzã koó ku, ãꞌdiãtãsĩyã á sõ ũyõ gí, fẽfẽ kõdô má ní lẽé sẽé ĩmi ní rĩ, ma sẽ Múngú ní.’ ");
INSERT INTO kbo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ĩmi ãꞌyĩkí ku ꞌbá ꞌdĩꞌbée ní ĩ ẹ́tẹ́pị́ị ẽ ĩzã kozú, ãzini ĩ ẹ́ndrẹ́pị́ị ẽ ĩzã kozú. ");
INSERT INTO kbo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ĩmi gãkí tã Múngú ní ẹzịị́ ĩmi ní rĩ sĩ, ĩmi ꞌdụkí rí tã mẽrẽ vé rĩ pi ngaá áyu. Tã ĩmi ní rií ngaá kárákará ꞌdĩꞌbée ĩri tã ũnjí.” ");
INSERT INTO kbo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yẹ́sụ̃ ní ꞌbá bị́trị́ká rĩ pi zịzú ímụ́zú ꞌí vúgá nõó dị̃ị́, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi yịkí ma, ĩmi ꞌdụkí tã má ní lũú ĩmi ní ꞌdĩri ꞌbãá ĩmi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngá ꞌbá rĩ ní nyaá fií ꞌí agá rĩ sẽ adri ãní ãzãvũ rú ku, tã ãmbúgú rĩ, átángá ĩri ní átá ĩfũú ꞌí tị gé sĩ rĩ sẽ ĩri adri ãzãvũ rú nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ꞌBá rĩ dõ bị́ be, ã yị ꞌí ní tã ꞌdĩri.” ");
INSERT INTO kbo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yẹ́sụ̃ kã ꞌbá bị́trị́ká rĩ pi kuú, ĩri ní fizú jó agá. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi zịkí ĩri kínĩ, ã ũlũ ĩ ní nãpí rĩ vé ífífí. ");
INSERT INTO kbo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ĩri ní kộpi zịzú kĩnĩ, “Tã má ní rií átá ꞌdĩri fi drĩ ĩmi drị̃gé kuyé? Ádarú ĩmi nị̃kí ꞌyozú kínĩ, ngá ĩmi ní nyaá rĩ sẽ ĩmi adrií ãzãvũ rú ku ꞌdíni kuyé? ");
INSERT INTO kbo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngá ĩmi ní nyaá rĩ ícó fií ĩmî ẹ́sị́ agá ku, ĩri fi ĩmi ꞌa agá, ĩri kúru fũ ĩmi agásĩ ãmvé.” Tã Yẹ́sụ̃ ní ꞌyoó ꞌdĩri vé ífífí, ãnyãngã rĩ pi ãrẽvú céré ãzãvũ ãkó, ĩ ícó nya rá. ");
INSERT INTO kbo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Tã ĩfũúpi mí ẹ́sị́ agásĩ rĩ, ĩri sẽ mi adri ãzãvũ rú nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tã ĩfũꞌbá ꞌbá rĩ vé ẹ́sị́ agá rĩ pi ꞌdĩ, yị̃kị̂ ũnjí, ọ̃wụ̃ ꞌbãngárá, ụ̃gụ̃, ꞌbá ꞌdịngárá, ");
INSERT INTO kbo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ágó ũkú be rĩ ní lazú ũkú ãzi sĩ, dõku ũkú ágó be rĩ ní lazú ágó ãzi be, ẹ́sị́ ãmbúgú, yị̃kị̂ tã ũnjí ꞌozú ni, mị ũꞌbãngárá, ẹ̃bị́rị́ ũkú vé ni, dõku ẹ̃bị́rị́ ágó vé ni, ẹ́sị́ ꞌbãngárá ꞌbá ãzi vé ngá drị̃gé, ãꞌyóngárá, ãfú, ãzini tã ꞌongárá azakaza rú rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tã ũnjí ĩ ní ũlãá ꞌdĩꞌbée céré, ĩri íbí ĩfũ ꞌbá rĩ vé ẹ́sị́ agá, tã ꞌdĩꞌbée sẽ ꞌbá rĩ adri ãní ãzãvũ rú.” ");
INSERT INTO kbo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yẹ́sụ̃ nga fũú Gãlĩláyã agásĩ, ꞌde mụụ́ ãngũ Táyã vé rĩ gé, ꞌdãlé mụ rií adrií ꞌbá ãzi vé jó agá. Yẹ́sụ̃ lẽ ꞌbá ãzi ã nị̃ ꞌyozú kínĩ, ꞌi ꞌdãáꞌdã ꞌdíni ku, ꞌbo ꞌbá rĩ pi nị̃kí rá ꞌyozú kínĩ, Yẹ́sụ̃ ri ꞌdãáꞌdã. ");
INSERT INTO kbo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ũkú ãzi ĩrivé mvá ũkúŋá índrí ũnjí ní fií drị̃ ni gé ni kã mụụ́ vũrã Yẹ́sụ̃ ní adrizú rĩ nị̃ị́ ámá, ĩri ní mụzú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ũkú ꞌdĩri adri Yãhụ́dị̃zị́ ku, tịkí ĩri Sírĩyã gá, vũrã ĩ ní zịị́ Fõnísĩyã rĩ agá. Ũkú rĩ mã Yẹ́sụ̃ ri kĩnĩ, Yẹ́sụ̃ ã dro índrí ũnjí rĩ fũú ívé mvá ũkúŋá rĩ drị̃gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yẹ́sụ̃ ní ꞌyozú ũkú rĩ ní kĩnĩ, “Drị̃drị̃ ni, lẽ ã sẽkí ãnyãngã nyaá anjiŋá rĩ pi ní, adri múké kuyé ĩ ní ãnyãngã anjiŋá úcézú rĩ úꞌbézú ũcógú ní.” ");
INSERT INTO kbo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ũkú rĩ ní újázú kĩnĩ, “Úpí, ũcógú ulaꞌbá mísá ã ndụ́gé rĩ pi nyakí ínyá uꞌdeꞌbá anjiŋá rĩ pi drị́gé sĩ vúgá rĩ ĩndĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yẹ́sụ̃ ní ꞌyozú ũkú rĩ ní kĩnĩ, “Tã mí ní újá múké ꞌdĩri sĩ, á dro índrí ũnjí rĩ fũú mívé mvá ũkúŋá rĩ drị̃gé sĩ ãmvé gí, ꞌí mụ ꞌbẹ̃tị́.” ");
INSERT INTO kbo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ũkú rĩ ꞌde mụụ́ ꞌbẹ̃tị́ ꞌdãá, ca mụụ́ ị́sụ́ ívé mvá ũkúŋá rĩ la kú gbọ́lọ́ drị̃gé, índrí ũnjí rĩ fũ drị̃ ni gé sĩ gí. ");
INSERT INTO kbo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yẹ́sụ̃ ní fũzú ãngũ Táyã vé rĩ agásĩ, ĩri ní ꞌdezú mụzú Sĩdónã gá, ĩri ní úlúzú mụzú yị̃ị́ bãlãlã Gãlĩláyã vé rĩ gé, ĩri ní cazú ãngũ Dẽkãpólĩsĩ vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ꞌDãlé ꞌbá ụrụkọꞌbée ní ágó bị́ be ẹ̃sị̃ị́pi gí átápi ku ni íjị́zú Yẹ́sụ̃ vúgá. Kộpi mãkí Yẹ́sụ̃ ri kínĩ, ã ꞌbã ꞌî drị́ ágó rĩ drị̃gé, ágó rĩ ẽ bị́ ã zị̃ rí, ã átá rí bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yẹ́sụ̃ ní ágó rĩ jịzú ꞌbá bị́trị́ká rĩ pi ãsámvú gé sĩ gãrã gá, ĩri ní ꞌî drị́ suzú ágó rĩ ẽ bị́ úlózú ãní, ãzini we tụ̃sụ́ ꞌí drị́gé ágó rĩ ã ádra úlózú ãní. ");
INSERT INTO kbo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yẹ́sụ̃ ní ãngũ ndrezú mụzú ꞌbụ̃ gé ꞌdãá, ĩri ní áꞌázú fụ̃, ĩri ní ꞌyozú kĩnĩ, “Ẽfátã!” Ífífí ni kĩnĩ, “Mî bị́ ã zị̃ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Koro ágó rĩ ẽ bị́ ní ꞌi zị̃zú, ádra ni ní ꞌi ọyụzú, ĩri ní íꞌdózú átázú ụ́ꞌdụ́kọ́ be uletere. ");
INSERT INTO kbo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, ã lũkí tã má ní ágó ꞌdĩri ídrízú rĩ ꞌbá ãzi ní ku. ꞌBo Yẹ́sụ̃ kã ꞌyoó kộpi ã lũkí tã ꞌdĩri ꞌbá ãzi ní ku, kộpi rikí nyo tã rĩ ũlũú mụzú ꞌbá rĩ pi ní ũlũlũ. ");
INSERT INTO kbo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tã ꞌdĩri sẽ ꞌbá rĩ pi ní ãyãngárá. Kộpi gõkí rií átá kínĩ, “Tã ágó ꞌdĩri ní ꞌoó ꞌdĩri, ĩri múké. Ídrí ꞌbá bị́ be ẹ̃sị̃ị́pi gí, átápi ku rĩ, ĩri tã yị rá, ĩri átá rá.” ");
INSERT INTO kbo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sâ ꞌdãri gé, ꞌbá bị́trị́ká trakí ĩ Yẹ́sụ̃ ã gãrã gá. Ãnyãngã kộpi ní nyaánya ni ꞌdãáyo. Kúru Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú, ĩri ní ꞌyozú kộpi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ma ĩzãngã sĩ ꞌbá nõꞌbée sĩ, ꞌbá nõꞌbée adrikí caá má be ụ́ꞌdụ́ na, kộpi nyakí ngá ãzi kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ꞌBá nõꞌbée ụrụkọ íngákí rárá rú, á pẽ dõ kộpi mụụ́ ẹ̃bị́rị́ sĩ, kộpi mụ ĩdrãkã lẹ́tị gé.” ");
INSERT INTO kbo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ꞌyozú ĩri ní kínĩ, “ꞌBo ãngũ vụ̃ụ́pi rárá rú ꞌbá ãkó nõri gé, ꞌbâ ãnyãngã ị́sụ́ ngũgá caápi ꞌbá nõꞌbée ní céré?” ");
INSERT INTO kbo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Pánga ĩmi vúgá ꞌdĩí ngõpí?” Kộpi ní újázú kínĩ, “Pánga ꞌbá vúgá nõó ẹ́zị̂rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, kộpi ã úríkí vúgá. Ĩri ní pánga ẹ́zị̂rị̃ ꞌdĩꞌbée íꞌdụ́zú ꞌí drị́gé, ĩri ní õwõꞌdĩfô sẽzú Múngú ní, ĩri ní ꞌa ni pi ũndĩzú, ꞌdụzú sẽzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi drị́gé, kộpi ã jịkí mụụ́ ũꞌbãá ꞌbá rĩ pi ẹndrẹtị gé sĩ, kộpi ꞌdụkí ngaá sụ̃ Yẹ́sụ̃ ní ꞌyoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ị̃ꞌbị́ mãdãŋáŋá kộpi vúgá anigé, ꞌbo ị̃ꞌbị́ rĩ pi nyírínyírí. Yẹ́sụ̃ ní ị̃ꞌbị́ rĩ íꞌdụ́zú, ĩri ní kpá õwõꞌdĩfô sẽzú, ĩri ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, kộpi ã jịkí awaá ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ꞌBá rĩ pi nyakí ínyá rĩ ẹ́pị́zú rá. Vụ́drị̃ ni gé, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ĩkũnãkí ãnyãngã ĩ ní nyaá rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa ẹ́zị̂rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ụ́ꞌdụ́ ꞌdãri gé, ãgõ rĩ pi ícó ca élĩfũ sụ rá. Kộpi kâ ãnyãngã rĩ nyaá dẹẹ́, Yẹ́sụ̃ ní kộpi pẽzú mụzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Koro vụ́drị̃ ni gé, Yẹ́sụ̃ pi ní ngazú tụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be kũlúmgba agá, kộpi ní ꞌdezú mụzú ãngũ Dãlãmãnútã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fãrụ́sị̃ rĩ pi kâ yịị́ kínĩ Yẹ́sụ̃ ícá gí, kộpi ícákí ímụ́ íꞌdó rií ãgátá gãá ĩri be, ĩri ụ̃ꞌbị̃zú. Kộpi lẽkí Yẹ́sụ̃ ã ꞌo ĩ ní tã ãyãzú ãyãyã íngápi ꞌbụ̃ gélésĩ ni. ");
INSERT INTO kbo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yẹ́sụ̃ kã mụụ́ tã ꞌdĩri yịị́, ĩri ní áꞌázú fụ̃, ĩri ní ꞌyozú ꞌbá ꞌdĩꞌbée ní kĩnĩ, “Úyú lókí ãndrũ nõri gé rĩ pi lẽkí mâ ꞌo ĩ ní tã ãyãzú ãyãyã ni ãsĩ? Ádarú ã lẽ lũú ĩmi ní, á ꞌo tã ãyãzú ãyãyã ni ĩmi ní ku.” ");
INSERT INTO kbo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kúru ĩri ní ꞌbá ꞌdĩꞌbée kuzú, ĩri ní tụzú kũlúmgba agá, yị̃ị́ bãlãlã rĩ zozú mụzú álé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ã tã ãvĩ, kộpi íjị́kí pánga ímụ́zú ĩndĩ kuyé, ngá kộpi vúgá anigé rĩ ꞌyéŋá pánga ãlu kũlúmgba rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adrikí mị be kọwụ ãkụ́fị́ Fãrụ́sị̃ rĩ pi vé rĩ ã tã sĩ, ãzini Ẽródẽ vé rĩ ã tã sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kộpi rikí tã ꞌdĩri átá ĩ ãsámvú gé sĩ ĩ ọ̃gụ̃pị́ị be kínĩ, “Yẹ́sụ̃ átá tã rĩ ꞌdíni, ꞌbá ní pánga íjị́ ĩndĩ kuyé rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yẹ́sụ̃ nị̃ tã kộpi ní rií átá rĩ rá, ĩri ní kộpi zịzú kĩnĩ, “Ngá ĩmi ní rizú átázú ĩmi ãsámvú gé sĩ ꞌyozú kínĩ pánga ꞌdãáyo rĩ ãꞌdi?” Tã ꞌdĩri fi drĩ ĩmi drị̃gé kuyé? Ĩmi úmĩ ãkó tã ꞌdĩri nị̃zú ámázú? ");
INSERT INTO kbo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ĩmi kõdô mị be pírí, ĩmî mị ndre ãngũ ku? Ĩmi kõdô bị́ be pírí, ĩmî bị́ yị tã ku? Ĩmi ícókí tã má ní ãnyãngã sẽzú ꞌbá bị́trị́ká rĩ pi ní ꞌdãri ígá ku? ");
INSERT INTO kbo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Má kã pánga tọ̃wụ́ rĩ ũndĩí sẽé nyaá ꞌbá élĩfũ tọ̃wụ́ rĩ pi ní, ĩmi ĩkũnãkí pánga ĩ ní nyaá tí rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa ngõpí? Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “ꞌBá ĩkũnãkí caá ũvú ã ꞌa mụdrị́ drị̃ ni ị̃rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Pánga má ní ũndĩí sẽé nyaá ꞌbá élĩfũ sụ pi ní rĩ, ĩmi ĩkũnãkí pánga ĩ ní nyaá tí rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa ngõpí?” Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “ꞌBá ĩkũnãkí caá ũvú ã ꞌa ẹ́zị̂rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Tã ꞌdĩri fi drĩ ĩmi drị̃gé kuyé?” ");
INSERT INTO kbo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yẹ́sụ̃ pi kâ caá Bẽtẽsãyídã gá ꞌdãlé, ꞌbá ụrụkọ íjị́kí ágó ãzi mị be ẹ̃sị̃ị́pi gí ni ímụ́ Yẹ́sụ̃ vúgá nõó. Kộpi mãkí Yẹ́sụ̃ ri, ã úló rí ágó rĩ ã rụ́ꞌbá, ágó rĩ ẽ mị ã zị̃ rí ꞌi bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yẹ́sụ̃ ní ágó rĩ ẽ drị́ rụzú, ĩri sẽzú fũzú mụzú gụ́rụ́ rĩ agásĩ ãmvé. Yẹ́sụ̃ ní kúru tụ̃sụ́ wezú ágó rĩ mị gé, ĩri ní ꞌî drị́ tị̃zú ágó rĩ drị̃gé, ĩri ní ágó rĩ zịzú kĩnĩ, “Mi nóni ícó ãngũ ndre rá?” ");
INSERT INTO kbo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ágó rĩ ní ãngũ ndrezú ụrụ, ĩri ni ꞌyozú kĩnĩ, “Á ndre ꞌbá, kộpi ri ẹ́cị́ má gãrã gá sĩ sụ̃ pẹtị ní rií ẹ́cị́ má gãrã gá sĩ kụ́rụ̃ rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yẹ́sụ̃ gõ ꞌî drị́ ꞌbãá ágó rĩ ẽ mị gé dị̃ị́, ágó rĩ ẽ mị ní kúru ꞌi zị̃zú gõzú ãngũ ndrezú uletere. ");
INSERT INTO kbo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yẹ́sụ̃ ní ágó rĩ pẽzú mụzú ꞌbẹ̃tị́, ꞌyozú ĩri ní kĩnĩ, “Lẽ mî újá mi gõó vúlé gụ́rụ́ agá ꞌdãá ku.” ");
INSERT INTO kbo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi ní ꞌdezú mụzú ẹ́cị́zú gụ́rụ́ Sĩzérĩyã Pị̃lị̃pọ́yị̃ vé rĩ pi agásĩ. Kộpi kâ rií mụụ́ lẹ́tị gé ꞌdĩgé, Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “ꞌBá rĩ pi ụ̃sụ̃kí kínĩ, ma ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kộpi ní újázú Yẹ́sụ̃ ní, “Ụrụkọꞌbée kínĩ, mi Yũwánĩ riípi bãtízĩmũ sẽépi rĩ ꞌi. Ụrụkọꞌbée kínĩ, mi Ẽlíyã ꞌi. Ụrụkọꞌbée kínĩ, mi nẹ́bị̃ rĩ pi vé ọ́gụ́pị.” ");
INSERT INTO kbo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú kĩnĩ, “Ĩmi ꞌdĩꞌbée, ĩmi ụ̃sụ̃kí kínĩ, ma ãꞌdi ꞌi?” Pétẽró ní újázú kĩnĩ, “Mi Kúrísítõ ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yẹ́sụ̃ átá kộpi ní ũkpó ũkpó kĩnĩ, kộpi ã lũkí ꞌi ꞌbá ãzi ní ku. ");
INSERT INTO kbo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yẹ́sụ̃ ní átázú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ma ꞌBá Mvá ꞌi, ma ímụ́ ĩzãngã nya lẹ́tị be ãndíãndí, ꞌbá ambugu rĩ pi, atala atala rĩ pi drị̃gé rĩ pi be, ãzini ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, kộpi ímụ́ ma gã sĩ, kộpi ímụ́ ma ꞌdị drã rá. ꞌBo ụ́ꞌdụ́ na ã vụ́drị̃ gé, ma ímụ́ íngá gõ ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yẹ́sụ̃ ũlũ kộpi ní tã rĩ ẽ mị uletere, Pétẽró ní Yẹ́sụ̃ ri sezú gãrã gá, ĩri ẽ drị̃ ãvãzú. ");
INSERT INTO kbo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ꞌBo Yẹ́sụ̃ kã ꞌi újá ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá ꞌdãá, ĩri ní trezú Pétẽró drị̃gé kĩnĩ, “Mi Sãtánã! ꞌÍ dẹ mi ꞌdĩísĩ rá, mívé tã rií ụ̃sụ̃ụ́ rĩ adri tã Múngú vé ni kuyé, ĩri tã ꞌbá nyọ̃ọ́kụ́ nõri vé rĩ pi vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kúru ĩri ní ꞌbá bị́trị́ká ꞌdĩꞌbée zịzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ímụ́zú ꞌí vúgá nõlé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá rĩ lẽ dõ mâ pámvú ũbĩí, ã adi ꞌî rụ́ꞌbá, ã ꞌdụ ívé pẹtị alambaku, ã ũbĩ mâ pámvú. ");
INSERT INTO kbo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ꞌBá riípi sụụ́pi ꞌî rụ́ꞌbá gá ꞌî drã rí ku rĩ, ị́sụ́ ídri ꞌdániꞌdáni rĩ ku. ꞌBá ꞌi sẽépi drãápi mâ tã sĩ, ãzini ụ́ꞌdụ́kọ́ múké rĩ ã tã sĩ rĩ, ĩri ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ꞌBá rĩ ꞌbã dõ ẹ́sị́ céré ngá nyọ̃ọ́kụ́ nõri vé rĩ drị̃gé, api dõ ídri ꞌdániꞌdáni rĩ sĩ, ngá múké ĩri ní ị́sụ́ ꞌdĩgé rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngá ãzi mí ní ícó sẽé Múngú ní mî drị̃ jezú ídri ꞌdániꞌdáni rĩ ị́sụ́zú ni nyo anigé? ");
INSERT INTO kbo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ꞌBá rĩ ẽ drị̃ ri dõ nja má sĩ, ãzini ụ́ꞌdụ́kọ́ múké má ní ũlũú rĩ sĩ ꞌbá ọ̃wụ́ rú rĩ pi ẹndrẹtị gé, ãzini ꞌbá riꞌbá ũnjĩkãnyã ꞌoꞌbá lókí nõri gé rĩ pi ẹndrẹtị gé, ma ꞌBá Mvá ꞌi, ụ́ꞌdụ́ má ní ímụ́zú ĩgõzú má Ẹ́tẹ́pị vé dị̃ngárá be, ãzini mãlãyíkã uletere rĩ pi be rĩ gé, ma adri ĩri sĩ drị̃njá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yẹ́sụ̃ ní gõzú ꞌyozú kộpi ní kĩnĩ, “Ĩmi ꞌbá pá tuꞌbá ꞌdĩꞌbée, ádarú á lẽ lũú ĩmi ní ꞌdíni, ꞌbá ụrụkọ ĩmi ãsámvú gé ꞌdĩgé, ícókí drĩ drãá ku, kộpi mãlũngã Múngú vé ímụ́pi ũkpõ be rĩ ndre drị̃drị̃ ũgbále.” ");
INSERT INTO kbo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ụ́ꞌdụ́ ázíyá ã vụ́drị̃ gé, Yẹ́sụ̃ ní Pétẽró pi jịzú Yõkóbũ be Yũwánĩ sĩ mụzú ꞌí vú sĩ, kộpi ní tụzú mụzú írã drị̃gé ụrụ ꞌdãá, ĩ mụkí rí adrií túngú ĩ drị̃kã sĩ. Kộpi kâ tụụ́ caá írã drị̃gé ꞌdãá, Yẹ́sụ̃ ã rụ́ꞌbá újá ꞌi índré ũꞌdũ be túngú ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ẹndrẹtị gé ꞌdĩgé. ");
INSERT INTO kbo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ĩrivé bõngó újá ꞌi ọ́gụ́ imvesírílílí, bõngó rĩ vé mvengárá aga ngá céré ĩ ní údé nyọ̃ọ́kụ́ drị̃gé nõgó rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ẽlíyã pi ní ĩfũzú Mósẽ be ímụ́zú ĩ iꞌdazú Yẹ́sụ̃ pi ẹndrẹtị gé, kộpi ní rizú átázú Yẹ́sụ̃ be. ");
INSERT INTO kbo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ĩri múké ꞌbá ní adrizú nõgó, lẽ ꞌbâ ꞌbekí mõrõgó na, ãlu ni mí ní, ãlu ni Mósẽ ní, ãlu ni Ẽlíyã ní.” ");
INSERT INTO kbo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ꞌBo ụ̃rị̃ fụ Pétẽró pi ꞌí ọ̃gụ̃pị́ị be ambamba, sẽ Pétẽró nị̃ tã ꞌí ní átá rĩ ã pámvú ámá kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ị́rị́bị́tị ní ísị́zú ímụ́zú kộpi ọ̃zụ̃zú, ụ́ꞌdụ́kọ́ ní íkụ́zú ị́rị́bị́tị rĩ agá ꞌdãásĩ kĩnĩ, “Mvá ꞌdĩri mávé ni má ní lẽélẽ rĩ. Lẽ ĩmi yịkí tị ni yịyị!” ");
INSERT INTO kbo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Koro Pétẽró pi kâ ĩ gãrã úndré kụ́rụ̃, Mósẽ pi Ẽlíyã be kộpi ãsámvú gé ꞌdãáyo, ꞌbá ĩ ní kuú kộpi ãsámvú gé rĩ Yẹ́sụ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yẹ́sụ̃ pi kâ rií ísị́ ímụ́ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be írã drị̃gé ꞌdãásĩ vũgá nõó, Yẹ́sụ̃ ní átázú kộpi ní kĩnĩ, “Tã ĩmi ní ndreé ĩmî mị sĩ ꞌdĩꞌbée, ã lũkí ꞌbá ãzi ní ku. Ĩmi úcíkí tã ꞌdĩri kú ĩmî ẹ́sị́ agá, cĩmgbá cazú lókí ꞌBá Mvá ní ímụ́zú drãzú gõzú íngázú ídri rú rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kúru kộpi úcíkí tã rĩ kú ĩ ẹ́sị́ agá, ꞌbo kộpi rikí átá ĩ ãsámvú gé sĩ kínĩ, “Tã Yẹ́sụ̃ ní ꞌyoó ꞌi drã, ꞌi gõ íngá ídri rú ꞌdĩri vé ífífí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBá tãị́mbị́ ímbáꞌbá rĩ pi ꞌyokí kínĩ, Ẽlíyã ri ímụ́ drị̃drị̃ nĩ ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ádarú Ẽlíyã ri ímụ́ drị̃drị̃, ĩri ímụ́ tã rĩ pi ãrẽvú útú céré ícá pịrị. Sĩkí Búkũ Múngú vé rĩ agá kínĩ, ꞌBá Mvá ri ímụ́ ĩzãngã nya, ꞌbá rĩ pi ĩri gã sĩ ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ꞌBo á lẽ lũú ĩmi ní, Ẽlíyã ícá ị́nọ́gọ́sị́ gí, ꞌbá rĩ pi ꞌokí ĩri ũnjí sụ̃ ĩ ní ĩrivé tã sĩí Búkũ Múngú vé rĩ agá rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yẹ́sụ̃ pi kâ ísị́ ímụ́zú írã drị̃gé ꞌdãásĩ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be vũgá nõó, kộpi ndrekí ꞌbá bị́trị́ká trakí ĩ Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá, ĩri ní kuú vúlé ꞌdãá rĩ pi ã gãrã gá sĩ kụ́rụ̃. ꞌBá Mósẽ vé tãị́mbị́ ímbáꞌbá rĩ pi ri ãgátá gã kộpi be. ");
INSERT INTO kbo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ꞌBá rĩ pi kâ Yẹ́sụ̃ ri ndreé, sẽ kộpi ní ãyãngárá, kộpi ní njuzú mụzú Yẹ́sụ̃ ri ẹzịzú. ");
INSERT INTO kbo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ngá ĩmi ní rizú ãgátá gãzú rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ágó ãzi ãlu ꞌbá bị́trị́ká rĩ pi ãsámvú gé ꞌdãá, ĩri ní újázú kĩnĩ, “Ímbápi, má íjị́ mávé mvá ágóŋá nõri ímụ́ mí vúgá, mî ídrí rí ĩri, ãꞌdiãtãsĩyã índrí ũnjí rĩ sẽ tị ni ọ̃zụ̃, átá ku. ");
INSERT INTO kbo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Índrí ũnjí rĩ kãdõ fií drị̃ ni gé, índrí ũnjí rĩ ĩri ꞌdụ ꞌbe vũgá, ĩri ꞌî sị́ nya, ụ́ꞌbụ́rụ́sã ri kpu tị ni gé sĩ, rụ́ꞌbá ni ri mba ku potokonyo. Má ẹ́ꞌyị́ mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi índrí ũnjí rĩ droó mvá ágóŋá rĩ drị̃gé sĩ, ꞌbo kộpi ụ̃ꞌbị̃kí droó tí.” ");
INSERT INTO kbo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, “Ĩmi ẹ̃ꞌyị̃ngárá ãkó ꞌdĩꞌbée, mâ adri rí caá ĩmi be lókí be gbã ngõpí? Mâ ẹ́sị́ ã nya rí ĩzãngã caá lókí be gbã ngõpí ĩmî tã sĩ? Ĩmi íjị́kí mvá ágóŋá rĩ ímụ́ má vúgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kúru kộpi ní mvá ágóŋá rĩ íjị́zú Yẹ́sụ̃ vú nõó. Índrí ũnjí rĩ kã Yẹ́sụ̃ ri ndreé, ĩri ní mvá ágóŋá rĩ ꞌdụzú aꞌbezú vũgá ꞌdãá ũkpõ sĩ, ĩri ní rizú ꞌi úlízú nyọ̃ọ́kụ́ gé sĩ pí ụ́ꞌbụ́rụ́sã be tị gé. ");
INSERT INTO kbo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yẹ́sụ̃ ní mvá ágóŋá rĩ vé ẹ́tẹ́pị zịzú kĩnĩ, “Índrí ũnjí rĩ ri mvá ágóŋá rĩ úꞌbé sụ̃ụ́ ꞌdĩri tị́nị vụ̃ụ́ caá lókí be gbã ngõpí?” Mvá ágóŋá rĩ vé ẹ́tẹ́pị ní újázú Yẹ́sụ̃ ní kĩnĩ, “Índrí ũnjí rĩ íꞌdó mvá ágóŋá rĩ úꞌbé ꞌdíni íꞌdózú ãnjĩŋã gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Índrí ũnjí rĩ ri mvá ágóŋá rĩ úꞌbé njị̃ị́ ãcí agá, ãzini yị̃ị́ agá, ã drã rí kõdô rá. ꞌBo mi dõ ícó mvá ágóŋá rĩ ídrí rá, lẽ mî ndre ꞌbávé ĩzãngã nõri.” ");
INSERT INTO kbo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yẹ́sụ̃ ní újázú ágó rĩ ní kĩnĩ, “Tã mí ní ꞌyoó kínĩ, ma dõ ícó mvá ágóŋá rĩ ídrí rá ꞌdĩri vé ífífí ãꞌdi? ꞌBá rĩ ẹ̃ꞌyị̃ dõ ma rá, tã ãzi ícópi ma ndẽépi ni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Koro mvá ágóŋá rĩ vé ẹ́tẹ́pị ní trezú ụrụ ꞌdãá kĩnĩ, “Yẹ́sụ̃, má ẹ̃ꞌyị̃ mi gí, ꞌbo ꞌí ko má ĩzã, á lẽ mi ẹ̃ꞌyị̃ị́ dị̃ị́ agaá rá!” ");
INSERT INTO kbo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yẹ́sụ̃ kã ndreé ꞌbá bị́trị́ká rĩ pi ri ímụ́ tã rĩ ã ndrengárá gá, Yẹ́sụ̃ ní trezú índrí ũnjí rĩ drị̃gé kĩnĩ, “Mi índrí ũnjí ꞌdĩri, ꞌí fũ mvá ágóŋá ꞌdĩri drị̃gé sĩ ãmvé, mî gõ fií drị̃ ni gé dị̃ị́ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kúru índrí ũnjí rĩ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, mvá ágóŋá rĩ ayazú, fũzú ĩri ã drị̃gé sĩ ãmvé. ꞌBá bị́trị́ká rĩ pi kâ ndreé mvá ágóŋá rĩ la kú kpílíkpílí ꞌbá drãápi gí ni tị́nị. ꞌBá rĩ pi kínĩ, “Mvá ágóŋá rĩ drã gí.” ");
INSERT INTO kbo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ꞌBo Yẹ́sụ̃ ní mvá ágóŋá rĩ ẽ drị́ rụzú, ĩri ingazú pá tuzú ụrụ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vụ́drị̃ ni gé, Yẹ́sụ̃ kã mvií gõó ꞌbẹ̃tị́ gí, Yẹ́sụ̃ pi ní fizú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be jó agá, Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní Yẹ́sụ̃ ri zịzú ãkũdẽ ꞌbá ãzi kộpi ã gãrã gá ꞌdãáyo, kộpi kínĩ, “Ngá ꞌbá ní ícózú índrí ũnjí drozú ku rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Índrí ũnjí rĩ vé drongárá, lẽ ꞌbá rĩ ã zị Múngú ri.” ");
INSERT INTO kbo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yẹ́sụ̃ nga fũú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be vũrã kộpi ní adrizú ꞌdãri agásĩ, kộpi mụkí trãá ãngũ Gãlĩláyã vé rĩ agásĩ. Yẹ́sụ̃ lẽ ꞌbá ãzi ã nị̃ vũrã ĩ ní mụzú adrizú ꞌdãri ku, ");
INSERT INTO kbo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ãꞌdiãtãsĩyã Yẹ́sụ̃ ri ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ímbá kĩnĩ, “Ĩ ímụ́ ꞌBá Mvá ã ũli ꞌbe, ĩ ĩri rụ sẽ ꞌbá ẹ́sị́ be ũnjí rĩ pi drị́gé, ĩ ĩri ꞌdị drã rá. Ụ́ꞌdụ́ na ã vụ́drị̃ gé, ĩri ímụ́ íngá gõ ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tã Yẹ́sụ̃ ní átá ꞌdĩri fi ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá ꞌdĩꞌbée drị̃gé ꞌdãlé kuyé. Ụ̃rị̃ sĩ, sẽ kộpi gõkí tã Yẹ́sụ̃ ní átá ꞌdĩri vé ífífí zịị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi ní cazú Kãpãrãnãụ́mã gá, kộpi ní kúru fizú mụzú adrizú jó agá. Kộpi ní rizú adrizú jó agá ꞌdãá rĩ gé, Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú kĩnĩ, “Ngá ĩmi ní té rizú ãgátá gãzú ímụ́zú lẹ́tị gé sĩ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ꞌBo kộpi újíkí kíri, ãꞌdiãtãsĩyã kộpi ní rizú ímụ́ngárá gá lẹ́tị gé sĩ rĩ gé, kộpi rikí ãgátá gãá ĩ ãsámvú gé sĩ kínĩ, ãꞌdi ri adri ãmbúgú rú nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kúru Yẹ́sụ̃ ní úrízú vũgá, ĩri ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée zịzú ímụ́zú úrízú ꞌî gãrã gá sĩ kụ́rụ̃, ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá rĩ lẽ dõ adrií ꞌbá rĩ pi drị̃gé ãmbúgú rú, lẽ ã adri ꞌbá ụ̃dụ̃mbị́tã rú ni, ã adri ãtíꞌbá rú rií ꞌbá rĩ pi ní ẹ̃zị́ ngaá.” ");
INSERT INTO kbo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yẹ́sụ̃ ní mváŋá mãdãŋá ni íjị́zú pá tuzú ꞌbá ꞌî pámvú ũbĩꞌbá ꞌdĩꞌbée ẹndrẹtị gé, ĩri ní ꞌî drị́ ꞌbãzú mváŋá rĩ ã kị́dị́ gé. Ĩri ní ꞌyozú ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ꞌBá mváŋá mãdãŋá nõri ẹ́ꞌyị́pi mâ rụ́ sĩ rĩ, ẹ́ꞌyị́ ꞌdĩri ma, ꞌbá ma ẹ́ꞌyị́pi rĩ, ẹ́ꞌyị́ ꞌdĩri má Ẹ́tẹ́pị ma ĩpẽépi rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yũwánĩ ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ꞌbá ndrekí ágó ãzi ri índrí ũnjí údró mî rụ́ sĩ, ꞌbá ugakí ĩri sĩ, ãꞌdiãtãsĩyã ágó rĩ adri ꞌbá ọ́gụ́pị kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yẹ́sụ̃ ní újázú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ĩmi ugakí ágó rĩ ku, ꞌbá riípi tã ãyãzú ãyãyã ni ꞌoópi rĩ, ícó gõó ꞌi újá mâ tã átá ũnjí ku. ");
INSERT INTO kbo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ꞌBá ꞌbâ tã ndreépi ũnjí ku rĩ, ĩri ꞌbá ꞌbávé ni. ");
INSERT INTO kbo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ꞌBá ĩmi ní yị̃ị́ sẽépi mvụụ́pi mâ rụ́ sĩ, ĩmi ní ma ẹ̃ꞌyị̃ị́ Kúrísítõ rú rá rĩ sĩ rĩ, ĩri ãndẽma ị́sụ́ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ꞌBá ãzi úbé dõ anjiŋá nyíríŋá ma ẹ̃ꞌyị̃ꞌbá gí nõꞌbée ꞌdeé fií tã ũnjí agá, ã ꞌyĩkí írã usegúgú ni umbe ni gé, ã ꞌbekí ĩri yị̃ị́ agá. ");
INSERT INTO kbo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mî drị́ úló dõ ũnjĩkãnyã, lẽ mî ga ĩri ꞌdĩísĩ rá, ĩri múké mí ní fizú ꞌbụ̃ gé ꞌdãlé drị́ be ãlu, ndẽ mí ní fizú ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá drị́ be ị̃rị̃ rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Vũrã ꞌdãri agá, ụ̃ꞌbụ̃ rĩ pi ũdrãkí ku, ãzini ãcí vũrã ꞌdãri agá rĩ drã kpá ku. ");
INSERT INTO kbo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mî pá jị dõ mi fií ũnjĩkãnyã ꞌoó, lẽ mî ga ĩri ꞌdĩísĩ rá, ĩri múké mí ní fizú ꞌbụ̃ gé ꞌdãlé pá be ãlu, ndẽ mí ní fizú ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá pá be ị̃rị̃ rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Vũrã ꞌdãri gé, ụ̃ꞌbụ̃ rĩ pi ũdrãkí ku, ãzini ãcí vũrã ꞌdãri gé rĩ drã kpá ku. ");
INSERT INTO kbo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mî mị ndre dõ ngá ãzi mi sẽépi fiípi ũnjĩkãnyã agá ni, lẽ mî ínjé ĩri ꞌdĩísĩ rá, ĩri múké mí ní fizú mãlũngã Múngú vé rĩ agá ꞌdãá mị be ãlu, ndẽ mí ní fizú ãcí vezú ãní ụ̃dụ̃ ãkó rĩ agá ꞌdãá mị be ị̃rị̃ rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vũrã ꞌdãri gé, ụ̃ꞌbụ̃ rĩ pi ũdrãkí ku, ãzini ãcí vũrã ꞌdãri gé rĩ drã kpá ku. ");
INSERT INTO kbo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ꞌBá rĩ pi ãrẽvú céré ĩ ímụ́ kộpi ụ̃ꞌbị̃ ãcí sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ẹ̃ꞌyị́ ri ngá múké, ꞌbo ẹ̃ꞌyị́ rĩ vé sị́ asuúpi asuasu rĩ ícá dõ ãlákála gí, ẹ̃ꞌyị́ rĩ gõ adri múké ngóni? Lẽ ĩmi adrikí ĩmi ãsámvú gé sĩ múké, sụ̃ ẹ̃ꞌyị́ sị́ be múké rĩ tị́nị, ãzini lẽ ĩmi adrikí ĩmi ãsámvú gé sĩ tã be kíri.” ");
INSERT INTO kbo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yẹ́sụ̃ nga fũú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Kãpãrãnãụ́mã agásĩ, mụụ́ ãngũ Yụ̃dáyã vé rĩ gé. Ĩri ní yị̃ị́ ãmbúgú dịị́pi dịdị Yárídénĩ vé rĩ zozú mụzú álé ꞌdãá. ꞌBá bị́trị́ká rĩ pi gõkí ímụ́ vú ni gé nõó dị̃ị́, ĩri ní kộpi ímbázú, sụ̃ ĩri ní rií kộpi ímbá njị̃ị́ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fãrụ́sị̃ ụrụkọꞌbée ímụ́kí Yẹ́sụ̃ ri zịị́ ĩri ụ̃ꞌbị̃zú ãní kínĩ, “Tãị́mbị́ Mósẽ vé rĩ ãꞌyĩ nyo ágó ni ívé ũkú ayizú rá?” ");
INSERT INTO kbo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Tãị́mbị́ Mósẽ vé rĩ átá tã ꞌdĩri drị̃gé íngóni?” ");
INSERT INTO kbo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “Mósẽ ãꞌyĩ rá kĩnĩ, ‘Ágó ri kọ̃kọ̃bị́ sĩ sẽ ũkú ni ní, ĩri ayizú ãní rá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Mósẽ sĩ tãị́mbị́ ꞌdĩri ĩmi ní, ãꞌdiãtãsĩyã ĩmivé ẹ́sị́ ní teéte rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Múngú ní íꞌdózú ꞌbụ̃ pi gbizú vũ be rĩ gé, ‘Múngú gbi ágó pi ũkú be’ ");
INSERT INTO kbo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tã ꞌdĩri sĩ, ꞌbá ágó ri ívé ẹ́tẹ́pị ku, ĩri ívé ẹ́ndrẹ́pị ku, kộpi ĩ úmú ũkú ni be. ");
INSERT INTO kbo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ꞌBá ị̃rị̃ ꞌdĩꞌbée ĩ úmú adri rụ́ꞌbá ãlu.’ ");
INSERT INTO kbo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ãjẽ Múngú ní úmú gí rĩ, lẽ ꞌbá ãzi ã ayi ãjẽ rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yẹ́sụ̃ pi kâ ímví ĩgõó ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ꞌbẹ̃tị́ nõó, kộpi gõkí Yẹ́sụ̃ ri zịị́ ágó pi vé ayingárá ũkú be rĩ vé tã sĩ dị̃ị́. ");
INSERT INTO kbo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ágó ívé ũkú ayiípi, gõópi ũkú ãzi jeépi rĩ, fi ꞌdĩri tã ọ̃wụ̃ vé ni ꞌoó. ");
INSERT INTO kbo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ũkú ívé ágó gãápi sĩ, gõópi ágó ãzi jeépi rĩ, fi ꞌdĩri tã ọ̃wụ̃ vé ni ꞌoó.” ");
INSERT INTO kbo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ꞌBá ụrụkọꞌbée íjị́kí ĩvé anjiŋá nyíríŋá rĩ pi Yẹ́sụ̃ vúgá, ã tị̃ rí drị́ kộpi drị̃gé, ã sẽ rí kộpi ní tãkíri. ꞌBo ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní trezú ꞌbá ĩvé anjiŋá íjị́ꞌbá Yẹ́sụ̃ vúgá ꞌdĩꞌbée drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yẹ́sụ̃ kã tã kộpi ní ꞌoó ꞌdĩri ndreé, Yẹ́sụ̃ ẽ ẹ́sị́ ve kộpi ní rá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi kukí anjiŋá nyíríŋá rĩ pi ẽ ímụ́kí má vúgá nõó! Ĩmi ugakí kộpi ku. ꞌBá adriꞌbá sụ̃ anjiŋá nyíríŋá ꞌdĩꞌbée tị́nị rĩ pi, kộpi mãlũngã Múngú vé rĩ ị́sụ́ nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ ãꞌyĩ dõ mãlũngã Múngú vé rĩ sụ̃ anjiŋá nyíríŋá rĩ pi ní ãꞌyĩí rĩ tị́nị ku, ícó fií mãlũngã Múngú vé rĩ agá ku. ");
INSERT INTO kbo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kúru Yẹ́sụ̃ ní anjiŋá rĩ pi íꞌdụ́zú ꞌí drị́gé, ĩri ní drị́ tị̃zú mụzú kộpi drị̃gé sĩ ãlu ãlu, ãzini ĩri ní tãkíri sẽzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yẹ́sụ̃ kã ívé ẹ̃cị̃ íꞌdó, ágó ãzi ní njuzú mụzú Yẹ́sụ̃ vúgá ꞌdãá, kã caá Yẹ́sụ̃ vúgá ꞌdãá, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní Yẹ́sụ̃ rĩ zịzú kĩnĩ, “Ímbápi, mi ꞌbá múké, mâ ꞌo ãꞌdi mâ ị́sụ́ rí ídri ꞌdániꞌdáni rĩ ãní?” ");
INSERT INTO kbo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yẹ́sụ̃ ní ágó rĩ zịzú kĩnĩ, “Ngá mí ní ma zịzú ꞌbá múké ãꞌdi? ꞌBá ãzi múké ni ꞌdãáyo, ꞌyéŋá Múngú ri múké nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mí nị̃ tãị́mbị́ rĩ rá kĩnĩ, ‘Lẽ mî ꞌdị ꞌbá ku, lẽ mî ꞌbã ọ̃wụ̃ ku, lẽ mî ụ̃gụ̃ ꞌbá ãzi ã ngá ku, lẽ mî úlị́ ũnjõ ꞌbá ãzi drị̃gé ku, lẽ mî ũꞌbã ꞌbá ãzi ẽ mị ĩrivé ngá ꞌdụzú ku, lẽ mî ị̃njị̃ mí ẹ́tẹ́pị pi mí ẹ́ndrẹ́pị be ị̃njị̃njị̃.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ágó rĩ ní újázú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, á ꞌdụ tãị́mbị́ ꞌdĩꞌbée vé tã ngaá céré rá, íꞌdózú má ní adrizú mváŋá rú rĩ gé ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yẹ́sụ̃ ní ãngũ ndrezú ágó rĩ vúgá ꞌdãá, lẽ ágó rĩ lẽlẽ, ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, “Tã mí ní ꞌoó kuyé rĩ ꞌyéŋá ãlu, ꞌí mụ, mí ụzị ngá mívé rĩ pi ãrẽvú céré, mí awa mũfẽngã ni ꞌbá ngá ãkó rĩ pi ní, úmvúlésĩ mi mụ ãꞌbú ị́sụ́ ꞌbụ̃ gé ꞌdãlé ambamba, mí ímụ́ mâ pámvú ũbĩí.” ");
INSERT INTO kbo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ágó rĩ kã tã Yẹ́sụ̃ ní ꞌyoó ꞌdĩri yịị́, mịlẹ́tị ni ísị́ kuú ãní kị̃njị̃, ĩri ní ꞌdezú mụzú, ẹ́sị́ ni ị́sụ́ ĩzãngã, ãꞌdiãtãsĩyã ágó rĩ ãꞌbú be ambamba. ");
INSERT INTO kbo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yẹ́sụ̃ ní ãngũ úndrézú ꞌî gãrã gá sĩ kụ́rụ̃, ĩri ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “ꞌBá ãꞌbú be rĩ vé fingárá mãlũngã Múngú vé rĩ agá ꞌdãlé rĩ, tã ni mbamba!” ");
INSERT INTO kbo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tã Yẹ́sụ̃ ní ꞌyoó ꞌdĩri sẽ ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ãyãngárá. ꞌBo Yẹ́sụ̃ gõ tã rĩ ẹndịị́ ꞌyoó kộpi ní dị̃ị́ kĩnĩ, “Mâ anji rĩ, ꞌBá ãꞌbú be rĩ vé fingárá mãlũngã Múngú vé rĩ agá ꞌdãlé rĩ, tã ni ũkpó ũkpó! ");
INSERT INTO kbo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kámĩlõ vé fingárá sĩndánĩ ã úlẽ gá sĩ rĩ mbamba, ꞌbo ꞌbá ãꞌbú be rĩ vé fingárá mãlũngã Múngú vé rĩ agá rĩ mba ndẽé rá.” ");
INSERT INTO kbo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ãyãkí tã ꞌdĩri sĩ ambamba, kộpi rikí átá ĩ ãsámvú gé sĩ kínĩ, “ꞌBá ĩ ní ícó paá ũnjĩkãnyã agásĩ ꞌbá ãsámvú gé nõgó rĩ, ĩri adri ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yẹ́sụ̃ ndre ãngũ kộpi vũgá ꞌdãá gõgõ, ĩri ní ꞌyozú kĩnĩ, “ꞌBá áda ícó tã ꞌdĩri ꞌdụụ́ ngaá ku, ꞌbo Múngú ri ꞌdụ nga rá, ãꞌdiãtãsĩyã Múngú ri ícó tã rĩ pi ãrẽvú ꞌdụ nga céré.” ");
INSERT INTO kbo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pétẽró ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ ndre drĩ ká, ꞌbá kukí ꞌbávé ngá ãrẽvú céré, ꞌbâ ri mî pámvú ũbĩ!” ");
INSERT INTO kbo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yẹ́sụ̃ ní újázú kĩnĩ, “Ádarú á ꞌyo ĩmi ní ꞌdíni, ꞌbá ívé ꞌbẹ̃tị́ kuúpi, ívé ẹ́drị́pị kuúpi, ívé ọ́mvụ́pị kuúpi, ívé ẹ́tẹ́pị kuúpi, ívé ẹ́ndrẹ́pị kuúpi, ívé anjiŋá kuúpi, ívé ọ́mvụ́ kuúpi mâ tã sĩ, ãzini ụ́ꞌdụ́kọ́ múké mávé rĩ ã tã sĩ rĩ, ");
INSERT INTO kbo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ĩri jó ị́sụ́, ẹ́drị́pị ị́sụ́, ọ́mvụ́pị ị́sụ́, ẹ́ndrẹ́pị ị́sụ́, anjiŋá ị́sụ́, ãꞌbú ị́sụ́ ca mụ̃dụ̃rụ̃lụ̃ kárákará vũ drị̃gé nõgó. Ã nya dõ ĩzãngã drãáãsĩyã, ụ́ꞌdụ́ ụ̃dụ̃ vé ímụ́pi ꞌdãri gé, ĩri ímụ́ ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ꞌBá kárákará ꞌyoꞌbá kínĩ, ĩ drị̃drị̃ rĩ pi, kộpi ímụ́ adri ụ̃dụ̃mbị́tã. ꞌBá adriꞌbá ụ̃dụ̃mbị́tã rĩ pi, kộpi ímụ́ adri drị̃drị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Yẹ̃rụ́sãlémã gálé rú, Yẹ́sụ̃ ko kộpi ẽ drị̃ mụzú nĩ. ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ẽ drị̃ ábákí céré céré, ãzini ꞌbá mụꞌbá vú ni gé sĩ rĩ pi, ụ̃rị̃ ị́mvụ́ kộpi rá. Yẹ́sụ̃ ní ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée jịzú gãrã gá, ĩri ní tã lẽépi ímụ́pi ꞌi ngaápi ꞌî rụ́ꞌbá gá rĩ ũlũzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá kãdõ mụụ́ caá Yẹ̃rụ́sãlémã gá ꞌdãá, ma ꞌBá Mvá ꞌi, ĩ ímụ́ mâ ũli ꞌbe rá, ĩ ma jị pá tu atala atala rĩ pi drị̃gé rĩ pi ẹndrẹtị gé, ãzini ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi ẹndrẹtị gé. Kộpi ímụ́ mávé tã lị, ma ꞌdịzú ãní rá, kộpi ma jị pá tu ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kộpi ímụ́ mâ drị̃ ínjá, kộpi tụ̃sụ́ úwé mâ rụ́ꞌbá gá, kộpi ma ũgbã, kộpi ma ꞌdị drã rá, ꞌbo ụ́ꞌdụ́ na ã vụ́drị̃ gé, ma gõ íngá ídri rú.” ");
INSERT INTO kbo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kúru Zẽbẽdáyõ ẹnjịpị́ị Yõkóbũ pi Yũwánĩ be, kộpi ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Ímbápi, tã ãzi anigé ꞌbá lẽkí zịị́ mí tị gé, mî ꞌo ꞌbá ní.” ");
INSERT INTO kbo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ngá ĩmi ní lẽé mâ ꞌo ĩmi ní rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kộpi ní újázú kínĩ, “Mí kãdõ úrí mívé lúpá mãlũngã vé ꞌbá rĩ pi ní mi íngúzú íngúngũ rĩ drị̃gé, lẽ mî ãꞌyĩ ꞌbá ãlu ã úrí mî drị́ ẹ̃ndẹ́pị gé, ãzi rĩ ã úrí mî drị́ ị̃jị́ gé.” ");
INSERT INTO kbo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi nị̃kí ngá zị be ku. Ĩmi nyo ícó ngá kópõ agá draápi dradra má ní ímụ́ mvụụ́ ꞌdĩri mvụ rá? Dõku bãtízĩmũ ĩ ní sẽé má ní ĩzãngã nyazú ꞌdĩri, ĩmi nyo ícó ãꞌyĩ ã sẽkí ĩmi ní, sụ̃ ĩ ní sẽé má ní rĩ tị́nị rá?” ");
INSERT INTO kbo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kộpi ní ꞌyozú kínĩ, “ꞌBâ ícó rá.” Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi ícó ngá kópõ agá draápi dradra má ní mvụụ́ rĩ mvụ rá, ãzini bãtízĩmũ ĩ ní sẽé má ní ĩzãngã nyazú ꞌdĩri, ĩmi ícó ãꞌyĩ, ĩ sẽ ĩmi ní rá, ");
INSERT INTO kbo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ꞌbo úríngárá mâ drị́ ẹ̃ndẹ́pị gé, ãzini mâ drị́ ị̃jị́ gé rĩ, má ícó tã ni ãꞌyĩí ĩmi ní nĩ ku. Vũrã ꞌdĩꞌbée Múngú údé îngá ꞌbá ꞌí ní ũpẽé gí rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ã ụrụkọ mụdrị́ rĩ pi kâ tã Yõkóbũ pi ní ꞌyoó Yũwánĩ be ꞌdĩri yịị́, kộpi ẽ ẹ́sị́ ve ꞌbá ị̃rị̃ ꞌdĩꞌbée ní rá. ");
INSERT INTO kbo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kúru Yẹ́sụ̃ ní kộpi zịzú ímụ́zú vũrã ãlu gé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá adriꞌbá Yãhụ́dị̃ rú ku ĩ ní ꞌbãá ꞌbá rĩ pi drị̃gé ꞌbãgú rú ꞌdĩꞌbée, kộpi ri ũkpõ áyú ĩvé ꞌbá rĩ pi drị̃gé, ĩvé ũgalaku ambugu rĩ pi ri ũkpõ áyú ꞌbá ĩ ní rụụ́ rĩ pi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ĩmi ãsámvú gé ꞌdĩgé, lẽ tã rĩ ã adri sụ̃ ꞌdĩri tị́nị ku. Ĩmi ãsámvú gé ꞌdĩgé, ꞌbá rĩ lẽ dõ adrií ꞌbá ãmbúgú rú, lẽ ã ꞌbã ꞌi adrií ãtíꞌbá ĩmivé ni, ");
INSERT INTO kbo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ãzini ꞌbá rĩ lẽ dõ ꞌî adri ãmbúgú ꞌbá rĩ pi drị̃gé céré, lẽ ã ꞌbã ꞌi adrií tụ́gẹ̃rị̃ rú rií ẹ̃zị́ ngaá ꞌbá rĩ pi ní céré. ");
INSERT INTO kbo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma ꞌBá Mvá ꞌi, má ímụ́ ꞌyozú kínĩ, ꞌbá rĩ pi ã ngakí má ní ẹ̃zị́ ꞌdíni kuyé, má ímụ́ ẹ̃zị́ ngaá ꞌbá rĩ pi ní, ãzini má ímụ́ ma sẽé ꞌdịị́ drãá ꞌbá kárákará pi ẽ drị̃ jezú.” ");
INSERT INTO kbo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kúru Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi ní cazú kụ̃rụ́ Yẹ́rị̃kọ̃ vé rĩ gé. Kộpi kâ lẽé fũú mụzú kụ̃rụ́ rĩ agásĩ, ꞌbá bị́trị́ká rĩ pi ꞌdekí mụụ́ kộpi ã vụ́drị̃ gé sĩ. Ágó ãzi mị be ẹ̃sị̃ị́pi gí ni rụ́ ni Bãrĩtĩmáyõ ꞌi, ĩri Tĩmáyõ ã mvá, ĩri ri úrí lẹ́tị ã jẽlé gá, ri ngá mã ꞌbá rĩ pi vúgá. ");
INSERT INTO kbo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bãrĩtĩmáyõ kã yịị́ kínĩ, ꞌbá rĩ Yẹ́sụ̃ Nãzẽrétãgú rĩ ri ẹlị mụzú nĩ, ĩri ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Yẹ́sụ̃ Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã mávé nõri fô!” ");
INSERT INTO kbo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ꞌBá ụrụkọꞌbée trekí ágó rĩ drị̃gé kínĩ, ã újí kíri. ꞌBo ágó rĩ gõ treé mụzú drị̃gélé kĩnĩ, “Dãwụ́dị̃ ã Mvá rĩ, ꞌí ndre ĩzãngã mávé nõri fô!” ");
INSERT INTO kbo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yẹ́sụ̃ ní pá tuzú, ĩri ní ꞌyozú kĩnĩ, “Ĩmi zịkí ĩri.” Kộpi ní ágó mị be ẹ̃sị̃ị́pi gí rĩ zịzú kínĩ, “Mí adri ụ̃rị̃ sĩ ku, ꞌí nga ụrụ, Yẹ́sụ̃ ri mi zị.” ");
INSERT INTO kbo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bãrĩtĩmáyõ ní ívé bõngó akoó rụ̃kụ̃ rĩ njezú ꞌbezú vũgá, ĩri ní wazú ụrụ, ĩri ní mụzú Yẹ́sụ̃ vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yẹ́sụ̃ ní ĩri zịzú kĩnĩ, “Ngá mí ní lẽé mâ ꞌo mí ní rĩ ãꞌdi?” Ágó mị be ẹ̃sị̃ị́pi gí ꞌdĩri ní újázú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, á lẽ ãngũ ndreé.” ");
INSERT INTO kbo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “ꞌÍ ꞌde mụụ́ ĩyí, mí ní ma ẹ̃ꞌyị̃ị́ gí rĩ sĩ, mí ídrí gí.” Koro ágó rĩ ẽ mị ní ꞌi zị̃zú ãngũ ndrezú, ĩri ní ꞌdezú mụzú Yẹ́sụ̃ pi ã vụ́drị̃ gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yẹ́sụ̃ pi ní cazú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Bẽtẽfágẽ gá, ãzini Bẽtẽníyã gá, kụ̃rụ́ ꞌdĩꞌbée ĩnyiŋá Írã Õlívẽ vé rĩ jẽlé gá. Kộpi kâ mụụ́ caá ĩnyiŋá kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ gé ꞌdãá, Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá ị̃rị̃ ni pi pẽzú mụzú drị̃drị̃. ");
INSERT INTO kbo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí gụ́rụ́ ĩmi ẹndrẹtị gé ꞌdãri gé, ĩmi kádõ fií caá gụ́rụ́ rĩ agá ꞌdãá, ĩmi dõngí mbaápi úꞌdí rú ꞌbá ãzi ní drĩ únjúzú ãní kuyé ni ị́sụ́ ꞌyĩkí kú ꞌdãáꞌdã, ĩmi ọyụkí dõngí rĩ íjị́ má vú nõó. ");
INSERT INTO kbo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ꞌBá ãzi zị dõ ĩmi, ‘Ngá ĩmi ní rií ꞌoó ꞌdíni rĩ ãꞌdi?’ Ĩmi újákí ĩri ní ꞌdíni, ‘Úpí lẽ dõngí rĩ nĩ, ĩ dõngí rĩ újá gõ ĩmi ní vúlé rá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá ị̃rị̃ ꞌdĩꞌbée ní ꞌdezú mụzú, kộpi ní cazú dõngí mbaápi úꞌdí rú ni ị́sụ́zú ꞌyĩkí ĩri ĩnyiŋá kẹ̃ẹ́tịlé ãngũ ndreépi mụzú lẹ́tị ĩ ní fizú mụzú kụ̃rụ́ rĩ gé ꞌdãlé rĩ gé, kộpi ní dõngí rĩ ọyụzú. ");
INSERT INTO kbo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ꞌBá ụrụkọ pá tuꞌbá ꞌdãlé rĩ pi ní kộpi zịzú kínĩ, “Ĩmi ri dõngí rĩ ọyụ ãlé?” ");
INSERT INTO kbo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kộpi ní tã rĩ újázú ꞌbá pá tuꞌbá rĩ pi ní sụ̃ Yẹ́sụ̃ ní ꞌyoó ĩ ní rĩ tị́nị, ꞌbá pá tuꞌbá rĩ pi ní ãꞌyĩzú kínĩ, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ã jịkí dõngí rĩ mụzú ĩyí. ");
INSERT INTO kbo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kộpi ní dõngí rĩ jịzú mụzú Yẹ́sụ̃ vúgá ꞌdãlé, kộpi ní ĩvé bõngó akoó rụ̃kụ̃ rĩ pi ꞌbezú dõngí rĩ ã úgóró gá, Yẹ́sụ̃ ní tụzú úrízú drị̃ ni gé. ");
INSERT INTO kbo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ꞌBá kárákará ajakí ĩvé bõngó akoó rụ̃kụ̃ rĩ pi mụzú lẹ́tị rĩ drị̃gé sĩ, ụrụkọꞌbée vãkí ị̃bị́bị́ ọ́mvụ́ agá rĩ pi ũꞌbãá mụzú lẹ́tị rĩ drị̃gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ꞌBá ꞌdeꞌbá Yẹ́sụ̃ ẹndrẹtị gé drị̃drị̃ rĩ pi, ꞌdeꞌbá ĩri ã vụ́drị̃ gé rĩ pi be, rikí gbĩlílí gaá mụzú kínĩ, “Hõsánã!” “Tãkíri ã adri ꞌbá ímụ́pi Úpí ã rụ́ sĩ rĩ ní!” ");
INSERT INTO kbo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Múngú ã ꞌbã tãkíri mãlũngã úyú Dãwụ́dị̃ vé rĩ ní ímụ́ rụụ́ rĩ drị̃gé!” “Hõsánã Múngú ụrụgégé ꞌbụ̃ gé rĩ!” ");
INSERT INTO kbo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kúru Yẹ́sụ̃ ní cazú kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ gé ꞌdãá, ĩri ní fizú Jó Múngú vé rĩ agá ꞌdãá, ĩri ní ꞌdezú rizú ngá rĩ pi úndrézú ánázú kụ́rụ̃. ꞌBo ụ̃tụ́ rĩ ní ꞌdeé gí rĩ sĩ, Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi be gụ́rụ́ Bẽtẽníyã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kã mụụ́ adrií drụ̃ ꞌdíni, Yẹ́sụ̃ pi ní fũzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be gụ́rụ́ Bẽtẽníyã vé rĩ agásĩ ãmvé, ẹ̃bị́rị́ fụ Yẹ́sụ̃ ri káyĩ. ");
INSERT INTO kbo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ĩri ní pẹtị ĩ ní zịị́ fị́gị̃ rĩ ndrezú rárá rú, bị́ ni amu kú kụ̃mvụ̃, ĩri ní ꞌdezú mụzú pẹtị rĩ ã gãrã gá ĩnyiŋáŋá ꞌdãá, lẽ ndreé dõ pẹtị rĩ ꞌa rá. Kã mụụ́ caá pẹtị rĩ ã gãrã gá ꞌdãá, ị́sụ́ pẹtị rĩ ꞌa kuyé, ꞌyéŋá bị́ ni amu kú nĩ, ãꞌdiãtãsĩyã lókí ꞌdãri adri pẹtị ní ꞌazú ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yẹ́sụ̃ ní ꞌyozú pẹtị rĩ ní kĩnĩ, “Lẽ ꞌbá ãzi ã gõ mívé ũꞌa nyaá dị̃ị́ ãluŋáni ku.” ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi yịkí tã ĩri ní ꞌyoó ꞌdĩri rá. ");
INSERT INTO kbo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yẹ́sụ̃ pi kâ caá ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Yẹ̃rụ́sãlémã gá ꞌdãá, ĩri ní fizú mụzú Jó Múngú vé rĩ ã bóró gá ꞌdãá, ĩri ní íꞌdózú ꞌbá riꞌbá ngá jeꞌbá, ãzini riꞌbá ngá ụzịꞌbá rĩ pi údrózú. Ĩri ní ꞌbá riꞌbá mũfẽngã ufuꞌbá rĩ pi vé mísá uzezú uꞌdezú ụ̃lị̃ rú, ãzini ꞌbá ãmámũ ụzịꞌbá rĩ pi vé kị́trị̃ uzezú uꞌdezú ụ̃lị̃ rú. ");
INSERT INTO kbo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yẹ́sụ̃ ãꞌyĩ ꞌbá ãzi ní ngá jịzú ụzịzú Jó Múngú vé rĩ ã bóró gá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yẹ́sụ̃ ní kộpi ímbázú, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Sĩkí nyo Búkũ Múngú vé rĩ agá ꞌyozú kínĩ, “ ‘Jó mávé rĩ ĩ zị jó ꞌbá ãngũ rĩ pi agásĩ rĩ pi ní ma zịzú ni’ ꞌdíni kuyé? ꞌBo ĩmi újákí jó rĩ ícá ‘vũrã ụ̃gụ́ꞌbá rĩ pi ní rizú adrizú ni.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi be, kộpi kâ tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri yịị́, kộpi íꞌdókí lẹ́tị ndãá lẽzú Yẹ́sụ̃ ri ꞌdịzú drãzú rá. ꞌBo kộpi ꞌokí ĩri sĩ ụ̃rị̃ sĩ, ãꞌdiãtãsĩyã ꞌbá kárákará ãyãkí tã ĩri ní ímbá rĩ sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kã mụụ́ adrií ũndréŋá rĩ sĩ, Yẹ́sụ̃ pi ní fũzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be kụ̃rụ́ rĩ agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kã mụụ́ adrií drụ̃ ꞌdíni, kộpi kâ rií ẹlịị́ mụzú pẹtị ĩ ní zịị́ fị́gị̃ rĩ ã gãrã gá sĩ, Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní pẹtị Yẹ́sụ̃ ní trií ꞌdãri ndrezú, pẹtị rĩ íꞌdó ꞌwií úlá ni gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pétẽró ní tã ándúrú Yẹ́sụ̃ ní pẹtị rĩ trizú ꞌdãri ã tã ígázú. Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ꞌí ndre drĩ ká! Pẹtị mí ní trií ꞌdãri ꞌwi gí.” ");
INSERT INTO kbo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Lẽ ĩmi ẹ̃ꞌyị̃kí Múngú ri. ");
INSERT INTO kbo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ádarú á ꞌyo ĩmi ní, ꞌbá rĩ ẹ̃ꞌyị̃ dõ Múngú ri rá, yị̃kị̂ ni awa dõ ꞌi ị̃rị̃ kuyé, ĩri ícó ꞌyo írã ꞌdĩri ní ã njị̃ ꞌi ꞌdeé yị̃ị́ bãlãlã rĩ agá ꞌdãá, írã rĩ ícó ꞌi njị̃ ꞌde yị̃ị́ bãlãlã rĩ agá ꞌdãá rá. ");
INSERT INTO kbo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ꞌÍ ꞌbã dõ ẹ́sị́ rizú ngá zịzú Múngú vúgá, ngá mí ní zịị́ rĩ, Múngú ri sẽ mí ní rá. ");
INSERT INTO kbo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ꞌBo mi dõ ri Múngú ri zị, ꞌí ꞌbã dõ ꞌbá ãzi ã tã kú mí ẹ́sị́ agá, lẽ mî trũ ĩri rá, mí Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ã trũ rí mi mívé ũnjĩkãnyã agásĩ bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ꞌBo ꞌí trũ dõ mí ọ́gụ́pị ri ívé ũnjĩkãnyã agásĩ ku, mí Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ícó mi trũú mívé ũnjĩkãnyã agásĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yẹ́sụ̃ pi ní gõzú cazú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be Yẹ̃rụ́sãlémã gá ꞌdãá dị̃ị́. Yẹ́sụ̃ kã rií ẹ́cị́ Jó Múngú vé rĩ ã bóró agásĩ, atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi be, ꞌbá ambugu ụrụkọꞌbée be, kộpi ní ímụ́zú Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “Ũkpõ mí ní ꞌbá ngá ụzịꞌbá ꞌdĩꞌbée údrózú Jó Múngú vé rĩ ã bóró agásĩ ꞌdĩri, mí ị́sụ́ íngũgá? Ãꞌdi sẽ mí ní ũkpõ ꞌdĩri nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ma drĩ ĩmi zị, ĩmi újákí dõ tã má ní ĩmi zịzú ꞌdĩri rá, ma kúru ũkpõ má ní tã ꞌozú rĩ vé tã ũlũ ĩmi ní rá.” ");
INSERT INTO kbo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kúru ĩri ní kộpi zịzú kĩnĩ, “Ãꞌdi sẽ Yũwánĩ ní ũkpõ bãtízĩmũ sẽzú ꞌdĩri nĩ? Yũwánĩ vé bãtízĩmũ sẽé ꞌdĩri íbí íngá ꞌbụ̃ gélésĩla yã, dõku íbí íngá ꞌbá áda vúgálésĩ? Ĩmi újákí má ní!” ");
INSERT INTO kbo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kộpi ní rizú átázú ĩ ãsámvú gé sĩ kínĩ, “ꞌBá ꞌyokí dõ, ‘Ũkpõ Yũwánĩ ní bãtízĩmũ sẽzú ꞌdĩri íbí íngá ꞌbụ̃ gélésĩla,’ ĩri gõ ꞌbâ zị, ‘Ĩmi ẹ̃ꞌyị̃kí Yũwánĩ ri kuyé ãsĩ?’ ");
INSERT INTO kbo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ꞌBo ꞌbá rĩ pi ní ꞌyoó Yũwánĩ ri nẹ́bị̃ rĩ sĩ, ꞌbá ícókí ꞌyoó, bãtízĩmũ Yũwánĩ ní sẽé ꞌdĩri, ꞌbá áda sẽ ĩri ní ũkpõ ni nĩ ꞌdíni ku.” ");
INSERT INTO kbo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “ꞌBá nị̃kí kuyé.” Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Má ícó ũkpõ má ní tã ꞌozú rĩ vé tã ũlũú ĩmi ní ku.” ");
INSERT INTO kbo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kúru Yẹ́sụ̃ ní átázú atala atala rĩ pi drị̃gé rĩ pi ní, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi ní, ãzini ꞌbá ambugu ụrụkọꞌbée ní nãpí sĩ kĩnĩ, “Ágó ãzi sa pẹtị vị́nyọ̃ vé rĩ pi, sị ãbi ọ́mvụ́ rĩ ã gãrã sĩ kụ́rụ̃, ga ꞌbụ́ kụụ́ vũgá ꞌdãá, rizú vị́nyọ̃ rĩ zozú ãní, ãzini sị lágáráka ãco ụrụgégé ꞌdãá, rizú ãngũ úndrézú. Kúru ĩri ní ívé vị́nyọ̃ ọ́mvụ́ agá rĩ kuzú ꞌbá ụrụkọꞌbée ọ́mvụ́ ꞌãꞌbá ni pi ní ũkõlõ, kộpi ũfẽkí ĩri ní mũfẽngã, ĩri ní ꞌdezú mụzú ãngũ ãzi gé. ");
INSERT INTO kbo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lókí ĩ ní rizú ũꞌa rĩ ũtĩzú pẹtị vị́nyọ̃ vé rĩ pi sị́gé sĩ rĩ kã ícó, ĩri ní ívé ãtíꞌbá pẽzú mụzú ꞌbá ĩri ní ọ́mvụ́ rĩ kuú kộpi ní ũkõlõ ꞌdãꞌbée vúgá ꞌdãá, ãtíꞌbá rĩ mụ ĩrivé ũꞌa rĩ ã vúgú íjị́. ");
INSERT INTO kbo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ꞌBo ꞌbá ĩ ní ọ́mvụ́ rĩ kuú kộpi ní ũkõlõ ꞌdãꞌbée ní ĩri rụzú, kộpi ní ĩri ũgbãzú, ĩri pẽzú mụzú drị́ be ule. ");
INSERT INTO kbo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ĩri ní ãtíꞌbá ãzi pẽzú mụzú kộpi vúgá ꞌdãlé dị̃ị́, ꞌbo kộpi ã gbãkí ĩri ẽ drị̃, kộpi uꞌdakí ĩri ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ĩri ní gõzú ãtíꞌbá ãzi pẽzú, kộpi ꞌdịkí ãtíꞌbá ꞌdĩri drãá rá. Ri nyo ãtíꞌbá rĩ pi ũpẽé mụzú dị̃ị́ dị̃ị́, kộpi ũgbãkí ụrụkọꞌbée, úꞌdị́kí ụrụkọꞌbée ũdrãá rá. ");
INSERT INTO kbo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“ꞌBá rĩ ẽ ị̃mbị́tã ace ãlu, ꞌbá aceépi rĩ, ĩri ọ́mvụ́ ꞌdị́pa rĩ vé mvá ĩri ní lẽé ambamba rĩ. Ĩri ní mvá rĩ pẽzú mụzú ꞌbá ĩri ní ọ́mvụ́ rĩ kuú kộpi ní ũkõlõ rĩ pi vúgá ꞌdãá kĩnĩ, ‘Kộpi ícó mávé mvá ị̃njị̃ rá.’ ");
INSERT INTO kbo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“ꞌBo ꞌbá ĩri ní ọ́mvụ́ rĩ kuú kộpi ní ũkõlõ rĩ pi ní rizú átázú ĩ ãsámvú gé sĩ kínĩ, ‘ꞌBá ímụ́pi ĩrivé ngá ẽ tị rụụ́pi rĩ, ĩri ímụ́ ꞌdã, lẽ ꞌbâ ꞌdịkí ĩri drãá ꞌdĩísĩ rá, ꞌbâ ꞌdụkí rí ọ́mvụ́ rĩ ꞌbá ní.’ ");
INSERT INTO kbo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kộpi ní ĩri rụzú, ĩri ꞌdịzú drãzú rá, kộpi ní ĩrivé ãvũ ꞌdụzú ọ́mvụ́ rĩ agásĩ, jịzú ꞌbezú ãmvé.” ");
INSERT INTO kbo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi kádõ ụ̃sụ̃ụ́, ọ́mvụ́ ꞌdị́pa ri gõ tã íngóni ni ꞌo? Á lẽ lũú ĩmi ní ꞌyozú kínĩ, ĩri ímụ́ ꞌbá ĩri ní ọ́mvụ́ rĩ kuú kộpi ní ꞌdãꞌbée úꞌdị́ ũdrã rá, ĩri gõ ọ́mvụ́ rĩ sẽ ꞌbá ụrụkọꞌbée ní. ");
INSERT INTO kbo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ĩmi lãkí tã ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ kuyé? Búkũ rĩ kĩnĩ, “ ‘Írã ándúrú ꞌbá jó sịꞌbá rĩ pi ní gãá sĩ rĩ, újá nóni ꞌi ícá írã sẽépi jó rĩ ní pá tuzú ãní ũkpó ũkpó ni. ");
INSERT INTO kbo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Úpí ꞌo tã ꞌdĩri nĩ, sẽ ꞌbá ní ãyãngárá.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ꞌBá Yẹ́sụ̃ ní átá kộpi be ꞌdĩꞌbée nị̃kí ámá rá, nãpí Yẹ́sụ̃ ní ũlũú ꞌdĩri, Yẹ́sụ̃ ri tã rĩ pi nãpí rú ĩ rụ́ꞌbá gá. Kộpi lẽkí kõdô ĩri rụụ́, ꞌbo kộpi rukí ꞌbá bị́trị́ká rĩ pi, kộpi kukí ĩri ãní, kộpi gõkí mụụ́ ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Drị̃koma ꞌdĩꞌbée ní Fãrụ́sị̃ rĩ pi ã ụrụkọ pẽzú ꞌbá Ẽródẽ ri ẹ̃tị̃ꞌbá rĩ pi be mụzú Yẹ́sụ̃ ri uzịzú, ã ꞌyo rí tã, ĩ tõkí rí ĩri ãní bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kộpi ní cazú ĩri vúgá ꞌdãá, kộpi ní ꞌyozú ĩri ní kínĩ, “Ímbápi, ꞌbá nị̃kí rá mi ꞌbá tã ꞌoópi pịrị ni, ꞌbá ãzi ícó mívé yị̃kị̂ tã ꞌozú rĩ újá ku, mi ꞌbá rĩ pi vé tã ꞌdụ nga céré trõtrõ, átã dõ ꞌbá rĩ ãꞌdi ꞌi, mi ri tã áda Múngú vé rĩ ímbá. Ĩri nyo múké ĩ ní mũfẽngã umbe jezú rĩ ũfẽzú ꞌbãgú ãmbúgú Rómã vé rĩ ní, dõku ã ũfẽkí ku? ");
INSERT INTO kbo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ꞌBâ ũfẽkí ĩyí, dõku ꞌbâ ũfẽkí ku?” ꞌBo Yẹ́sụ̃ nị̃ tã kộpi ẽ ẹ́sị́ agá rĩ rá. Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ĩmi ri tã ndã mâ rụ́ꞌbá gá ꞌdíni ãsĩ? Ĩmi íjị́kí má ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ ãlu, mâ ndre drĩ ká.” ");
INSERT INTO kbo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kộpi ní mũfẽngã ã fífí íjị́zú ãlu Yẹ́sụ̃ vú nõó, Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ị́ndrị́lị́kị́ ĩ ní údé mũfẽngã rụ́ꞌbá gá nõri, ãzini rụ́ ĩ ní sĩí rụ́ꞌbá ni gé nõri ãꞌdi vé ni?” Kộpi ní újázú Yẹ́sụ̃ ní kínĩ, “Ị́ndrị́lị́kị́ rĩ, ãzini rụ́ rĩ ꞌbãgú ãmbúgú Rómã vé rĩ vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ngá rĩ dõ ꞌbãgú ãmbúgú Rómã vé rĩ vé ni, ĩmi sẽkí ꞌbãgú ãmbúgú Rómã vé rĩ ní, ngá rĩ dõ Múngú vé ni, ĩmi sẽkí Múngú ní.” Tã Yẹ́sụ̃ ní újá kộpi ní ꞌdĩri, sẽ kộpi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kúru ꞌbá ĩ ní zịị́ Sãdókẽ, ꞌyoꞌbá kínĩ, ꞌbá rĩ drã dõ gí ícó gõó íngá ídri rú ku ꞌdĩꞌbée ní ímụ́zú Yẹ́sụ̃ vúgá nõó, kộpi ní Yẹ́sụ̃ ri zịzú ");
INSERT INTO kbo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","kínĩ, “Ímbápi, Mósẽ sĩ ꞌbá ní kínĩ, ‘ꞌBá rĩ vé ẹ́drị́pị drã dõ, ku dõ ọ̃wụ́zị́ kú mvá ãkó, ꞌbá drãápi rĩ vé ẹ́drị́pị rĩ gõ ọ̃wụ́zị́ rĩ ẹ́ꞌyị́ ꞌí ní ũkú rú, kộpi anji tị ọ̃wụ́zị́ rĩ be, anji kộpi ní tịị́ rĩ pi adri ẹ́drị́pị drãápi ꞌdãri vé ni.’ ");
INSERT INTO kbo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ándúrú anji ãgõ ẹ́zị̂rị̃, kộpi ẹ́drị́pị́ị rú, mvá kãyú rĩ je ũkú, ĩri ní drãzú, kộpi tịkí mvá ũkú rĩ be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ẹ́drị́pị ãzi rĩ ní gõzú ũkú rĩ ẹ́ꞌyị́zú, ĩri ní kpá drãzú mvá ãkó, ẹ́drị́pị ãzi rĩ ní kpá ũkú rĩ ẹ́ꞌyị́zú, drã kpá ꞌdíni, kộpi tịkí mvá ũkú rĩ be kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anji ẹ́zị̂rị̃ ꞌdĩꞌbée ũdrãkí céré, tịkí anji ũkú rĩ be kuyé. Ụ̃dụ̃ ni gé, ũkú rĩ ní kpá drãzú. ");
INSERT INTO kbo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kúru ꞌí lũ ꞌbá ní, ãgõ ũdrãꞌbá ẹ́zị̂rị̃ ꞌdĩꞌbée céré rikí ũkú ãlu ꞌdĩri jeé, kãdõ mụụ́ caá ụ́ꞌdụ́ ꞌbá rĩ pi ní íngázú gõzú ídri rú rĩ gé, ũkú ꞌdĩri adri ãꞌdi vé ni?” ");
INSERT INTO kbo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Tã ĩmi ní átá ꞌdĩri adri pịrị ku! Ĩmi nị̃kí tã ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ kuyé! Ĩmi nị̃kí ũkpõ Múngú vé rĩ kuyé! ");
INSERT INTO kbo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ꞌBá ũdrãꞌbá gí rĩ pi kádõ íngá gõó ídri rú, ágó gõ ũkú jeé ku, ũkú gõ ágó jeé ku. Kộpi adri sụ̃ mãlãyíkã ꞌbụ̃ gé ꞌdãlé rĩ pi tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ꞌBá ũdrãꞌbá gí rĩ pi vé íngángárá gõó ídri rú rĩ vé tã, ĩmi lãkí búkũ Mósẽ ní sĩí rĩ agá rá. Ĩmi nị̃kí tã ãcí ní dị̃zú rụ̃dụ́ agá rĩ rá, Múngú ꞌyo Mósẽ ní kĩnĩ, ‘Ma Múngú Ãbũrámã vé rĩ, Múngú Ĩsákã vé rĩ, ãzini Múngú Yõkóbũ vé rĩ,’ ");
INSERT INTO kbo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Múngú adri ꞌyozú kínĩ, ĩri Múngú ꞌbá ũdrãꞌbá gí rĩ pi vé ni kuyé, ĩri Múngú ꞌbá ídri rú rĩ pi vé ni. Ĩmi Sãdókẽ ꞌdĩꞌbée, tã ĩmi ní ꞌyoó kínĩ, ꞌbá ũdrãꞌbée gí rĩ pi íngákí gõó ídri rú ku ꞌdĩri ũnjõ.” ");
INSERT INTO kbo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ꞌBá tãị́mbị́ ímbáꞌbá rĩ pi vé ãlu ní ícázú, ị́sụ́ Yẹ́sụ̃ pi ri ãgátá gã Sãdókẽ rĩ pi be. Kã ímụ́ ị́sụ́ Yẹ́sụ̃ újá tã rĩ pịrị, ĩri ní Yẹ́sụ̃ ri zịzú kĩnĩ, “Tãị́mbị́ ꞌdĩꞌbée agásĩ céré, ngõri ndẽ nĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Tãị́mbị́ agaápi rá rĩ, ĩri ꞌdĩ, ‘Ĩmi anji Ĩsẽrélẽ vé ꞌdĩꞌbée, ĩmi yịkí drĩ ká! Úpí ꞌbávé rĩ, ĩri ꞌyéŋá Úpí Múngú ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lẽ mî lẽ Úpí Múngú mívé rĩ ẹ́sị́ be céré, índrí mívé rĩ be céré, yị̃kị̂ mívé rĩ be céré, ũkpõ mívé rĩ be céré.’ ");
INSERT INTO kbo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tãị́mbị́ ị̃rị̃ rĩ ꞌdíni, ‘Lẽ mî lẽ ꞌbá mî gãrã gá rĩ sụ̃ mí ní mî rụ́ꞌbá lẽé rĩ tị́nị.’ Tãị́mbị́ ãzi tãị́mbị́ ị̃rị̃ ꞌdĩꞌbée ndẽépi rá ni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ágó riípi tãị́mbị́ ímbápi rĩ ní ꞌyozú kĩnĩ, “Ímbápi, tã mí ní ꞌyoó kínĩ, Múngú ri ꞌyéŋá ãlu, Múngú ãzi túngú ni ꞌdãáyo ꞌdĩri, ĩri tã áda. ");
INSERT INTO kbo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ádarú lẽ mî lẽ ĩri ẹ́sị́ be céré, yị̃kị̂ mívé rĩ be céré, ũkpõ mívé rĩ be céré, ãzini ꞌí lẽ dõ ꞌbá mî gãrã gá rĩ sụ̃ mí ní mî rụ́ꞌbá lẽé rĩ tị́nị, ndẽ ngá mí ní sẽé rĩ pi rá, ãzini ndẽ rọ̃bọ̃ŋọ̃ mí ní zãá rĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yẹ́sụ̃ kã ndreé ágó rĩ újá tã rĩ pịrị, ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, “Mí ítrú nóni mi ícá ĩnyiŋá mãlũngã Múngú vé rĩ ã jẽlé gá gí.” Vụ́drị̃ ni gé, ꞌbá ãzi gõ Yẹ́sụ̃ ri zịị́ tã ãzi sĩ dị̃ị́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yẹ́sụ̃ kã rií ꞌbá rĩ pi ímbá Jó Múngú vé rĩ ã bóró gá ꞌdãá, ĩri ní ꞌbá rĩ pi zịzú kĩnĩ, “ꞌBá tãị́mbị́ ímbáꞌbá rĩ pi ri ꞌyo kínĩ, Kúrísítõ ri ímụ́ ĩfũ úyú Dãwụ́dị̃ vé rĩ agá, tã kộpi ní ꞌyoó ꞌdĩri, kộpi ụ̃sụ̃kí ífífí ni aꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Índrí Uletere rĩ ású Dãwụ́dị̃ ri, sẽ átá ꞌdíni kĩnĩ, “ ‘Úpí Múngú ꞌyo mávé Úpí ní kĩnĩ, “Mí úrí mâ drị́ ẹ̃ndẹ́pị gé, cĩmgbá má ní mívé ariꞌba rĩ pi ꞌbãzú mî pálé gá rĩ gé.” ’ ");
INSERT INTO kbo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dãwụ́dị̃ zị dõ Kúrísítõ ri ívé Úpí pírí, Kúrísítõ ri ícó adri Dãwụ́dị̃ ã mvá íngóni ngóni?” ꞌBá kárákará ꞌbãkí úvá rizú tã ĩri ní ímbá ꞌdĩri yịzú ãyĩkõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yẹ́sụ̃ kã rií ꞌbá rĩ pi ímbá, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adrikí mị be kọwụ ꞌbá riꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá ꞌdĩꞌbée ã tã sĩ. Kộpi lẽkí ĩ úsú bõngó ãcoco ni pi sĩ, rií ẹ́cị́ jọ̃kọ́nị̃ agásĩ, ꞌbá rĩ pi kádõ ĩ ẹzịị́, kộpi ẽ ị̃njị̃kí rí ĩ ị̃njị̃njị̃. ");
INSERT INTO kbo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ãzini kộpi lẽkí ã ꞌbãkí ĩ úrí vũrã ꞌbá ambugu rĩ pi vé rizú úrízú Jó Múngú ri Zịzú rĩ pi agá ꞌdãá rĩ gé, ãzini vũrã ꞌbá ị̃njị̃zú ị̃njị̃njị̃ rizú ụ̃mụ̃ nyazú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kộpi ri ọwụzị rĩ pi ẽ mị ũꞌbã rizú kộpivé ngá jó ãsámvú gé rĩ pi uꞌdụzú kộpi drị́gé sĩ. Kộpi ri Múngú ri zị sâ be ãco, ꞌbá rĩ pi ã ndrekí rí ĩ. ꞌBá tã ꞌoꞌbá ꞌdíni ꞌdĩꞌbée, Múngú ri ímụ́ kộpi ĩrĩŋã ũnjí ũnjí.” ");
INSERT INTO kbo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yẹ́sụ̃ ní ꞌdezú mụzú úrízú sọ̃ndụ́kụ̃ ĩ ní ꞌbãá kuú Jó Múngú vé rĩ agá, ĩ ní rizú mũfẽngã ꞌbezú ꞌa ni gé rĩ ã gãrã gá. Tẽ rií ꞌbá kárákará mũfẽngã jịꞌbá ꞌbeꞌbá rĩ pi ndreé. Ndre ꞌbá ãꞌbú be rĩ pi ꞌbekí mũfẽngã ĩvé rĩ ãmbúgú. ");
INSERT INTO kbo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kúru ọ̃wụ́zị́gọ́ ãzi íjị́ ívé rĩ mũfẽngã fífí nyíríŋá ẹ̃njị̃ị́pi ku ni ꞌbeé ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ádarú á ꞌyo ĩmi ní ꞌdíni, ũkú ọ̃wụ́zị́gọ́ ngá ãkó ꞌdĩri vé mũfẽngã ꞌbeé rĩ, ndẽ ꞌbá ꞌbeꞌbá ãmbúgú rĩ pi vé rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngá ꞌbá ãꞌbú be rĩ pi ní sẽé rĩ, kộpi íꞌdụ́kí ĩvé ãꞌbú kárákará rĩ pi agá, ꞌbo ũkú ngá ãkó ꞌdĩri sẽ ívé ngá ꞌí ní kõdô ꞌî ĩzã kozú rĩ ãrẽvú céré.” ");
INSERT INTO kbo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yẹ́sụ̃ kã rií fũú mụzú Jó Múngú vé rĩ agásĩ, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi vé ãlu ní ꞌyozú ĩri ní kĩnĩ, “Ímbápi, ꞌí ndre drĩ írã ũnyĩ be ꞌdĩꞌbée ká, ãzini ꞌí ndre drĩ jó ĩ ní sịị́ jó Múngú ri ị̃njị̃zú rĩ ã gãrã gá sĩ ũnyĩ be ꞌdĩꞌbée ká!” ");
INSERT INTO kbo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Jó mí ní ndreé ambugu ambugu ꞌdĩꞌbée, ĩ ímụ́ kộpi ũŋõ céré uꞌde vũgá, írã ĩ ní jó rĩ pi ũꞌbãzú ãní ꞌdĩꞌbée, ĩ ímụ́ kộpi ũŋõ úꞌbé céré vũgá.” ");
INSERT INTO kbo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Vụ́drị̃ ni gé, Yẹ́sụ̃ mụ úrí kuú Írã Õlívẽ vé rĩ drị̃gé, ị́ꞌbụ́ŋá aco kộpi ãsámvú Jó Múngú vé rĩ be nĩ. Pétẽró pi Yõkóbũ be, Yũwánĩ sĩ, ãzini Ãndẽréyã sĩ, kộpi ní ĩ njezú mụzú Yẹ́sụ̃ vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “Tã ꞌdĩꞌbée ímụ́ ĩ nga ngọ̃tụ́? Ngá ímụ́pi lũúpi kínĩ, tã ꞌdĩꞌbée ímụ́ ĩ nga rá rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi ndrekí múké, lẽ ꞌbá ãzi ã ũꞌbã ĩmî mị ku, ");
INSERT INTO kbo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ãꞌdiãtãsĩyã ꞌbá kárákará pi ímụ́ ũnjõ ụ́lị́ mâ rụ́ sĩ, kộpi ꞌyo, ĩ Kúrísítõ ꞌi. Kộpi ꞌbá kárákará pi ẽ mị ũꞌbã rá. ");
INSERT INTO kbo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ĩmi kádõ tã ẹ̃ꞌdị́ vé ni yịị́, ãzini ĩmi kádõ tã ẹ̃ꞌdị́ vé ĩ ní rií átá rĩ ã tã yịị́, lẽ ĩmi adrikí ụ̃rị̃ sĩ ku. Tã ꞌdíni ꞌdĩꞌbée ímụ́ ĩ nga rá, ꞌbo adri ꞌyozú kínĩ, ụ̃dụ̃ nyọ̃ọ́kụ́ nõri vé rĩ, ĩri ꞌi dẹẹ́pi ꞌdĩ ꞌdíni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ꞌBá ãngũ ãzi agá rĩ pi ímụ́ ẹ̃ꞌdị́ ꞌdị ĩ ãsámvú gé sĩ ꞌbá ãngũ ãzi agá rĩ pi be. ꞌBá mãlũngã rụꞌbá rĩ pi ímụ́ ẹ̃ꞌdị́ ꞌdị ĩ ọ̃gụ̃pị́ị mãlũngã rụꞌbá rĩ pi be, dĩngídĩngí ri ímụ́ ãngũ aya vũrã kárákará ni pi agásĩ, ẹ̃bị́rị́ ri ímụ́ ꞌde ũnjí ũnjí. ꞌBo tã ꞌdĩꞌbée drĩ ĩzãngã rĩ vé íꞌdóngárá. ");
INSERT INTO kbo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ĩmi adrikí mị be kọwụ! Ĩ ímụ́ ĩmi urụ jị mụ tõ ꞌbá tã lịꞌbá rĩ pi ẹndrẹtị gé, ĩ ĩmi ũgbã Jó Múngú ri Zịzú rĩ pi agásĩ kẹ̃lị́ŋá sĩ. Ĩ ímụ́ ĩmi jị mụ pá tu ũgalaku ambugu rĩ pi ẹndrẹtị gé, ãzini ꞌbãgú rĩ pi ẹndrẹtị gé mâ tã sĩ, ĩri adri drị̃lé múké ĩmi ní mávé tã ũlũzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ụ́ꞌdụ́ ụ̃dụ̃ vé rĩ ní drĩ ícázú kuyé rĩ gé, lẽ ã ũlũkí ụ́ꞌdụ́kọ́ múké rĩ mụzú ãngũ rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Urụkí dõ ĩmi, ãzini tõkí dõ ĩmi ꞌbá tã lịꞌbá rĩ pi ẹndrẹtị gé, lẽ ĩmi rikí ĩmi ụ̃sụ̃ụ́ drãá átángá ĩmi ní lẽé mụụ́ átá rĩ vé tã sĩ ku. Sâ ni kãdõ ícá, átángá ĩmi ní mụụ́ átá rĩ, Múngú ri ũlũ ĩmi ní nĩ. Ĩmi átákí átángá rĩ nĩ ku, Índrí Uletere rĩ átá nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ẹ́drị́pị ri ímụ́ ẹ́drị́pị ã ũli ꞌbe, ĩri ẹ́drị́pị ri sẽ ꞌdị drã rá. Ẹ́tẹ́pị ri ímụ́ ívé anjiŋá rĩ pi ã ũli ꞌbe, ĩri kộpi sẽ úꞌdị́ ũdrã rá, anjiŋá rĩ pi ímụ́ ufu ku ariꞌba rú, kộpi ꞌbá ĩ tịꞌbá rĩ pi sẽ úꞌdị́ ũdrã rá. ");
INSERT INTO kbo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ꞌBá rĩ pi ímụ́ ĩmi ngụ̃ ũnjí mâ tã sĩ, ꞌbo ꞌbá pá tuúpi tị́tị́ ívé ẹ̃ꞌyị̃ngárá agá cĩmgbá cazú ụ̃dụ̃ gé rĩ, Múngú ri ímụ́ ĩri pa rá. ");
INSERT INTO kbo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ĩmi kádõ ‘Ngá Ũnjí ãngũ izaápi’ ni ndreé tu pá kuú vũrã ĩri ní kõdô pá tuzú ku rĩ gé, ꞌbá tã ni lãápi rĩ ã nị̃ tã ni vé ífífí múké. Sâ ꞌdãri gé, ꞌbá adriꞌbá ãngũ Yụ̃dáyã vé rĩ agá rĩ pi, lẽ kộpi ã ápákí mụzú írã drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tã ꞌdĩri ị́sụ́ dõ ꞌbá rĩ jó drị̃gé, ẽ ísị́ fií jó agá ꞌdãá, mụụ́ ngá ãzi íꞌdụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tã ꞌdĩri ị́sụ́ dõ ꞌbá rĩ ọ́mvụ́ agá, lẽ ꞌbá rĩ ã gõ vúlé mụụ́ ívé bõngó akoó rụ̃kụ̃ rĩ íꞌdụ́ ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lókí ꞌdãri gé, tã rĩ ímụ́ adri ũkpó ũkpó ũkú ꞌa be rĩ pi ní, ãzini ũkú anji be drĩ ũdéŋá rú bã ndruꞌbá ndrundru rĩ pi ní! ");
INSERT INTO kbo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lẽ ĩmi zịkí Múngú ri, tã ꞌdĩꞌbée ã ngá rí ꞌi lókí kílóngóro vé rĩ gé ku, ");
INSERT INTO kbo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ãꞌdiãtãsĩyã sâ ꞌdãri gé, ĩzãngã ꞌbá rĩ pi ní ímụ́ nyaá rĩ, Múngú ní íꞌdózú vũ rĩ gbingárá gá ꞌdãá, kộpi nyakí drĩ ãvũ ni kuyé. ꞌBo ĩzãngã sụ̃ ꞌdĩri tị́nị ni, ícó gõó ꞌi ngaá dị̃ị́ ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Úpí ẽ ítrú dõ ụ́ꞌdụ́ ĩzãngã nyazú rĩ ícá ẹ̃lị́ŋá ku, ꞌbá ãzi ícó adrií ídri rú ku. ꞌBo ĩrivé ꞌbá ĩri ní îngá ũpẽé rĩ pi ã tã sĩ, ĩri ụ́ꞌdụ́ rĩ ítrú ícá ẹ̃lị́ŋá. ");
INSERT INTO kbo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lókí ꞌdãri gé, ꞌbá rĩ ꞌyo dõ, ‘ꞌÍ ndre, Kúrísítõ ri nõ!’ dõku ‘Ĩri ꞌdã!’ lẽ mî ẹ̃ꞌyị̃ ĩrivé tã ĩri ní ꞌyoó ꞌdĩri ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ꞌBá ũnjó rú ꞌyoꞌbá kínĩ ĩ Kúrísítõ ꞌi rĩ pi nẹ́bị̃ ũnjó rú rĩ pi be, kộpi ímụ́ ĩfũ ri tã ãyãzú ãyãyã ni pi ꞌo ꞌbá Múngú ní ũpẽé rĩ pi ẽ mị ũꞌbãzú ãní, ꞌbo kộpi ícókí ũꞌbãá bã ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ꞌBo ĩmi adrikí mị be kọwụ! Má ũlũ ĩmi ní tã ímụ́ꞌbá ꞌi ngaꞌbá rĩ pi ãrẽvú céré drị̃drị̃ gí. ");
INSERT INTO kbo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lókí ꞌdãri gé, ĩzãngã ꞌbá rĩ pi ní nyaá rĩ ã vụ́drị̃ gé, “ ‘Ụ̃tụ́ rĩ ẽ mị ri ímụ́ bĩ nị ku ị́nị́ŋá rú, mbãá rĩ gõ kaá ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Línyã rĩ pi ímụ́ lụ̃ ꞌbụ̃ gé ꞌdãásĩ vũgá, ĩ ímụ́ ngá ꞌbụ̃ gé ꞌdãlé rĩ pi aya rá.’ ");
INSERT INTO kbo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sâ ꞌdãri gé, ma ꞌBá Mvá ꞌi, ꞌbá rĩ pi ímụ́ mávé ímụ́ngárá ị́rị́bị́tị agásĩ ũkpõ be ãmbúgú rĩ ndre, ãzini mávé dị̃ngárá pọ̃wụ̃pọ̃wụ̃ rĩ ndre ĩ mị sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma ímụ́ mávé mãlãyíkã rĩ pi ĩpẽ ímụ́ ꞌbá ĩ ní ũpẽé gí rĩ pi tra vũ drị̃gé sĩ céré, cĩmgbá cazú ꞌbụ̃ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Lẽ ĩmi nị̃kí tã ꞌdĩri ámá pẹtị rụ́ꞌbá gá, pẹtị ĩ ní zịị́ fị́gị̃ rĩ ẽ bị́ íꞌdó dõ rũú gí, mi ícó nị̃ ámá ꞌyozú kínĩ, ẹ̃ẹ́zụ̃ ícá ĩnyiŋá gí. ");
INSERT INTO kbo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kúru ĩmi ndrekí dõ tã má ní ũlũú ꞌdĩꞌbée ri ĩ ꞌo, ĩmi ícó nị̃ ámá ꞌyozú kínĩ, lókí má ní ĩgõzú rĩ ícá ĩnyiŋáŋá gí. ");
INSERT INTO kbo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá ụrụkọ lókí nõri vé rĩ pi ũdrãkí drĩ ku, tã ꞌdĩꞌbée ãrẽvú céré ímụ́ ĩ nga drị̃drị̃ ũgbále ká. ");
INSERT INTO kbo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ꞌBụ̃ pi vũ be, kộpi ímụ́ dẹ rá, ꞌbo átángá má ní átá rĩ tã áda, ĩri adri mụzú ꞌdániꞌdáni. ");
INSERT INTO kbo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ꞌBo ꞌbá ãzi nị̃ ụ́ꞌdụ́, dõku sâ tã ꞌdĩꞌbée ní ꞌi ngazú rĩ kuyé, mãlãyíkã ꞌbụ̃ gé rĩ pi nị̃kí kpá kuyé, Ma Mvá rú, á nị̃ kpá kuyé, ꞌyéŋá má Ẹ́tẹ́pị Múngú nị̃ îngá nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lẽ ĩmi adrikí mị be kọwụ, ĩmi adrikí ũrẽ, ãꞌdiãtãsĩyã ĩmi nị̃kí sâ tã rĩ ní ímụ́zú ꞌi ngazú rĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tã má ní átá ꞌdĩri, ĩri adri sụ̃ ágó ãzi ní ívé ꞌbẹ̃tị́ kuú, ĩri ní ꞌdeé mụụ́ ẹ̃cị̃ gé rárá rú, ĩri ní ẹ̃zị́ awaá ívé ãtíꞌbá rĩ pi ní, ĩri ní ꞌyoó ívé ãtíꞌbá kẹ̃ẹ́tịlé ũtẽépi rĩ ní, ã adri mị be mgbọ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kúru lẽ ĩmi adrikí mị be mgbọ, ãꞌdiãtãsĩyã lókí jó ꞌdị́pa ní ícázú rĩ, dõ ĩri ícá ũndréŋá sĩ yã, dõ ị́nị́ŋá útú gé yã, dõ ụ̃ꞌbụ́tị sĩ yã, ĩmi nị̃kí kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ꞌBo jó ꞌdị́pa ícá dõ mbẽlẽŋá, ẽ ícá rí ĩmi ị́sụ́ ụ́ꞌdụ́ kongárá gá ku. ");
INSERT INTO kbo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tã má ní ꞌyoó ĩmi ní ꞌdĩri, á ꞌyo ꞌbá céré ní, lẽ ĩmi adrikí mị be mgbọ, ĩmi ũtẽkí ĩrivé ĩgõngárá!” ");
INSERT INTO kbo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ, ãzini Ụ̃mụ̃ ĩ ní Pánga ni ꞌBãá Údrá ku rĩ nyazú rĩ vé ụ́ꞌdụ́ kã aceé ị̃rị̃, atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, rikí Yẹ́sụ̃ ã tã ndrĩí lẽzú ĩri rụzú, ĩ ꞌdịkí rí ĩri drãá ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kộpi rikí ꞌyoó kínĩ, “Lẽ ꞌbâ rụkí Yẹ́sụ̃ ri ụ́ꞌdụ́ ụ̃mụ̃ nyazú rĩ gé ku, ãꞌdiãtãsĩyã ꞌbá rĩ pi ímụ́ íngá ꞌbá drị̃gé gí.” ");
INSERT INTO kbo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yẹ́sụ̃ kã rií adrií Bẽtẽníyã gá ꞌdãá, ri adrií Sị̃mọ́nã ọ́tụ́ ũfú ní nyaá rĩ vé ãngá. Yẹ́sụ̃ kã úrí ínyá nyangárá gá, ũkú ãzi ní ímụ́zú ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni be drị́gé mãlãngĩ agá, ũdu rĩ ãjẽ be ãmbúgú. Ũkú rĩ ní mãlãngĩ rĩ ẽ tị zị̃zú, ĩri ní ũdu rĩ dãzú Yẹ́sụ̃ drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tã ꞌdĩri sẽ ꞌbá ụrụkọ ụ̃mụ̃ rĩ gé ꞌdãlé rĩ pi ẽ ẹ́sị́ ve rá, kộpi ní rizú unuzú ĩ ãsámvú gé sĩ kínĩ, “Ngá ũkú rĩ ní rizú ũdu rĩ izazú ꞌdíni rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kộpi íngákí ũkú rĩ drị̃gé mgbárãsĩ. Kộpi kínĩ, “Ũkú rĩ té ũdu rĩ ụzị mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ mụ̃dụ̃rụ̃lụ̃ na, ĩri té mũfẽngã ni awa ꞌbá ngá ãkó rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Lẽ ĩmi kukí ũkú rĩ, ngá ĩmi ní rizú ũkú rĩ ẽ drị̃ izazú ꞌdíni rĩ ãꞌdi? Tã ũkú rĩ ní ꞌoó má ní ꞌdĩri, ĩri tã múké, ");
INSERT INTO kbo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ãꞌdiãtãsĩyã ụ́ꞌdụ́ céré ĩmi ri adri ꞌbá ngá ãkó rĩ pi be trụ́, ĩmi lẽkí dõ kộpi ẽ ĩzã koó, ĩmi ícó ko rá. ꞌBo má ícó áwí adrií ĩmi be nõgó rõ ku. ");
INSERT INTO kbo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ũkú ꞌdĩri ꞌo ngá ꞌí ní lẽé ꞌoó má ní rĩ gí. Má ní drĩ adrizú ídri rú rĩ gé, ũkú rĩ dã ũdu mâ rụ́ꞌbá trịzú ãní, má kãdõ ímụ́ drãá, ị́sụ́ trị mâ rụ́ꞌbá ũdu rĩ sĩ ị́nọ́gọ́sị́ gí. ");
INSERT INTO kbo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ pi kádõ rií ụ́ꞌdụ́kọ́ múké rĩ ũlũú mụzú vũ drị̃gé sĩ, kộpi tã ũkú rĩ ní ꞌoó rĩ ígá, kộpi ũlũ mụzú ꞌbá rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kúru Yụ́dã Ĩsĩkãrĩyótã Yẹ́sụ̃ vé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi vé ãzi ní ꞌdezú mụzú atala atala rĩ pi drị̃gé rĩ pi vúgá ꞌdãá, ꞌî ꞌbe rí Yẹ́sụ̃ ã ũli, kộpi ã rụkí rí ĩri. ");
INSERT INTO kbo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Atala atala rĩ pi drị̃gé ꞌdĩꞌbée kâ tã ꞌdĩri yịị́, kộpi adrikí ãní ãyĩkõ sĩ, kộpi ꞌyokí ĩ tị sĩ kínĩ, ĩ Yụ́dã ní mũfẽngã sẽ rá. Kúru Yụ́dã ní lẹ́tị ndãzú Yẹ́sụ̃ ã ũli ꞌbezú ãní. ");
INSERT INTO kbo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ụ́ꞌdụ́ ĩ ní íꞌdózú Ụ̃mụ̃ ĩ ní Pánga ni ꞌBãá Údrá ku rĩ nyazú rĩ gé, Yãhụ́dị̃ rĩ pi céré ãlu ãlu kãbĩlõ mvá íꞌdụ́ lị rọ̃bọ̃ŋọ̃ rú Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ gé, Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩri zịzú kínĩ, “Mí lẽ ꞌbâ mụkí ínyá mí ní lẽé nyaá Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ áꞌdí íngũgá?” ");
INSERT INTO kbo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kúru Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá ị̃rị̃ ni pi pẽzú, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi mụkí kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agá ꞌdãá, ĩmi ca mụ ágó ãzi ị́sụ́ ꞌdãlé, ĩri ri ũdrí ꞌdụ mụzú yịị́ be agá. Ĩmi ꞌdekí mụụ́ vú ni gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jó ꞌdị́pa rĩ kãdõ fií jó agá ꞌdãá, ĩmi lũkí ĩri ní kínĩ, ‘Ímbápi kĩnĩ, “ꞌBâ ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ nya mávé ꞌbá mâ pámvú ũbĩꞌbá rĩ pi be íngũgá?” ’ ");
INSERT INTO kbo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jó ꞌdị́pa ri ĩmi jị tụ mụzú jó ꞌa be ãmbúgú ụrụgégé, ĩ ní ngá ụ̃mụ̃ vé rĩ útú ũꞌbãá kuú ꞌa ni gé ị́nọ́gọ́sị́ gí rĩ agá ꞌdãá, ĩri ĩmi ní jó rĩ iꞌda. Kúru ĩmi áꞌdíkí ínyá rĩ, ĩmi ũꞌbãkí jó rĩ agá ꞌdãá.” ");
INSERT INTO kbo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kúru ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá ị̃rị̃ ꞌdĩꞌbée ní ngazú ꞌdezú mụzú kụ̃rụ́ rĩ agá ꞌdãá, kộpi cakí tã rĩ ị́sụ́, sụ̃ nyo Yẹ́sụ̃ ní ꞌyoó rĩ tị́nị. Kộpi ní ínyá ĩ ní lẽé mụụ́ nyaá ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ vé rĩ áꞌdízú, kộpi ní ũꞌbãzú jó rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kã mụụ́ adrií ũndré sĩ, Yẹ́sụ̃ pi ní ícázú ívé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yẹ́sụ̃ pi kâ úrí ínyá rĩ nyangárá gá ívé ꞌbá áyúãyũ rĩ pi be, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ádarú ĩmi ãsámvú gé ꞌdĩgé, ꞌbá ꞌbá ní rií ngá nyaá ĩri be trụ́ rĩ ímụ́ mâ ũli ꞌbe nĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tã Yẹ́sụ̃ ní ꞌyoó ꞌdĩri sẽ ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá ꞌdĩꞌbée ní ĩzãngã ambamba, ꞌbá ãlu ãlu ꞌde rí Yẹ́sụ̃ ri zịị́, “ꞌBá rĩ adri nyo ma ꞌi ku?” ");
INSERT INTO kbo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi ꞌbá mụdrị́ drị̃ ni ị̃rị̃ ꞌdĩꞌbée, ĩmi ãsámvú gé ꞌdĩgé, ꞌbá ínyá dũúpi má be trụ́ sákãnĩ nõri agá rĩ, ꞌbá rĩ adriípi ꞌdĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma ꞌBá Mvá ꞌi, ĩ ímụ́ ma ꞌdị drã rá, sụ̃ ĩ ní sĩí Búkũ Múngú vé rĩ agá rĩ tị́nị. ꞌBo ĩzãngã rĩ ímụ́ adri ꞌbá mâ ũli ꞌbeépi rĩ vé ni! Ọ́tụ́ ã tịkí dõ ágó ꞌdĩri kuyé, ĩri té adri múké. ");
INSERT INTO kbo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yẹ́sụ̃ pi kâ úrí ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ngá nyangárá gá, ĩri ní pánga íꞌdụ́zú, ĩri ní õwõꞌdĩfô sẽzú Múngú ní, ĩri ní ꞌa ni ãndĩzú, ĩri ní sẽzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní, ĩri ní ꞌyozú kĩnĩ, “Ĩmi ẹ́ꞌyị́kí nyaá, ꞌdĩri rụ́ꞌbá mávé rĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ĩri ní kpá kópõ vị́nyọ̃ be agá rĩ íꞌdụ́zú, ĩri ní õwõꞌdĩfô sẽzú Múngú ní, ĩri ní sẽzú kộpi ní, kộpi ní céré ẹ́ꞌyị́zú mvụzú. ");
INSERT INTO kbo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kúru ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌDĩri mávé ãrí dãápi, má ní ũndĩ rụzú ꞌbá kárákará pi ã tã sĩ rĩ. ");
INSERT INTO kbo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ádarú ã lẽ ꞌyoó ĩmi ní ꞌdíni, íꞌdózú ãndrũ mụzú drị̃drị̃, á gõ vị́nyọ̃ mvụụ́ dị̃ị́ ku, ma mụ vị́nyọ̃ úꞌdí mvụ mãlũngã Múngú vé rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kúru kộpi ní úngó ngozú, kộpi ní ꞌdezú mụzú ánga ĩ ní zịị́ Írã Õlívẽ vé rĩ drị̃gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kộpi ní rií mụngárá gá lẹ́tị gé ꞌdĩgé, Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ĩmi céré ímụ́ ápá mâ rụ́ꞌbá gá sĩ rá, ãꞌdiãtãsĩyã sĩkí Búkũ Múngú vé rĩ agá kínĩ, “ ‘Ma ímụ́ ꞌbá kãbĩlõ úcépi rĩ ꞌdị drã rá, kãbĩlõ rĩ pi ímụ́ ayi kpélékpélé.’ ");
INSERT INTO kbo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ꞌBo má kãdõ íngá gõó ídri rú, ma ꞌde mụzú ĩmî drị̃lé gá sĩ drị̃drị̃ ãngũ Gãlĩláyã vé rĩ gé ꞌdãlé, ꞌbâ mụ ꞌbâ ị́sụ́ ĩmi be ꞌdãlé.” ");
INSERT INTO kbo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pétẽró ní ꞌyozú ĩri ní kĩnĩ, “ꞌBá rĩ pi dõ céré ápá mî rụ́ꞌbá gá sĩ rá drãáãsĩyã, má ícó ápá ku.” ");
INSERT INTO kbo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Pétẽró, ị́nị́ŋá ãndrũ nõri sĩ, mi ímụ́ ma gã ca vú na, vụ́drị̃ ni gé, lõgúlõgú ri ímụ́ cẽré ꞌbe vú ị̃rị̃.” ");
INSERT INTO kbo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pétẽró gõ rií tã rĩ sií dị̃ị́ dị̃ị́ kĩnĩ, “Má ícó ãluŋáni ꞌyoó á gã mi sĩ ꞌdíni ku, ꞌbâ ũdrã mí be trụ́.” ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi céré ngakí ꞌyoó, sụ̃ Pétẽró ní ꞌyoó ꞌdĩri tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yẹ́sụ̃ pi ní ꞌdezú mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ãngũ ĩ ní zịị́ Gẽtẽsẽmánĩ rĩ gé ꞌdãlé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi úríkí ꞌdĩgé, ma drĩ mụ Múngú ri zị.” ");
INSERT INTO kbo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yẹ́sụ̃ jị Pétẽró pi Yõkóbũ be, Yũwánĩ sĩ mụzú ꞌí vúgá sĩ ĩndĩ. Ĩzãngã ŋõ ẹ́sị́ ni ambamba. ");
INSERT INTO kbo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩzãngã fi má ẹ́sị́ agá nõlé, lẽ ma ꞌdịị́ drãá. Ĩmi adrikí ꞌdĩgé, ꞌbo ĩmi adrikí mị be mgbọ, ã kokí ụ́ꞌdụ́ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yẹ́sụ̃ gõ ꞌi útrú drị̃drị̃ mãdã, ĩri ní kũmũcí ũtị̃zú, ĩri ní Múngú ri zịzú kĩnĩ, “Ícó dõ rá, lẽ tã ũkpó ũkpó ꞌdíni ꞌdĩri ã nga ꞌi mâ rụ́ꞌbá gá ku.” ");
INSERT INTO kbo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ĩri ní ꞌyozú kĩnĩ, “Ábã, má Ẹ́tẹ́pị, tã ãzi mi ndẽépi ni ꞌdãáyo. Ícó dõ rá, ꞌí ꞌdụ kópõ ĩzãngã vé ꞌdĩri mâ rụ́ꞌbá gá sĩ rá. ꞌÍ ꞌo tã mî ẹ́sị́ ní lẽé rĩ, adri ꞌyozú kínĩ tã mâ ẹ́sị́ ní lẽé rĩ ku.” ");
INSERT INTO kbo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yẹ́sụ̃ ní ꞌi újázú gõzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá ꞌdãá, ị́sụ́ kộpi ri ụ́ꞌdụ́ ko. Ĩri ní ꞌyozú Sị̃mọ́nã Pétẽró ní kĩnĩ, “Ĩmi ri ụ́ꞌdụ́ ko? Ĩmi ícókí nyo adrií mị be mgbọ sâ be ãlu ku? ");
INSERT INTO kbo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lẽ ĩmi adrikí mị be mgbọ, ĩmi zịkí Múngú ri, tã ũkpó ũkpó ni ẽ ímụ́ rí ĩmi ụ̃ꞌbị̃ị́ ku. Ẹ́sị́ ĩmivé rĩ lẽ kõdô tã ꞌoó pịrị, ꞌbo ĩmî rụ́ꞌbá ní adrií ũkpõ ãkó rĩ sĩ, ĩmi ícókí tã pịrị ꞌoó ku.” ");
INSERT INTO kbo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yẹ́sụ̃ gõ kpá ꞌdeé mụụ́ Múngú ri zịị́ dị̃ị́, sụ̃ ꞌí ní té zịị́ drị̃drị̃ rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yẹ́sụ̃ kã ꞌi újá gõó vúlé ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi vúgá ꞌdãá dị̃ị́, ị́sụ́ kộpi ri ụ́ꞌdụ́ ko, ãꞌdiãtãsĩyã ụ́ꞌdụ́ rĩ drĩ kộpi mị gé ꞌdãá ũgõgõ, sẽ kộpi ndãkí átángá ĩ ní lẽé átá rĩ tí. ");
INSERT INTO kbo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yẹ́sụ̃ kã ꞌi újá caá kộpi vúgá ꞌdãá vú na ni gé, ĩri ní ꞌyozú kĩnĩ, “Ĩmi drĩ ri ụ́ꞌdụ́ rĩ koko, ãzini ĩmi drĩ ri uvuvu? Ĩmi kokí ụ́ꞌdụ́ rĩ ẹ̃sị́rị́! Sâ ĩ ní ꞌBá Mvá ri rụzú sẽzú ꞌbá ũnjí rĩ pi drị́gé rĩ ícó gí. ");
INSERT INTO kbo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ĩmi íngákí ụrụ! ꞌBá ꞌdekí mụụ́! ꞌBá mâ ũli ꞌbeépi rĩ ícá gí.” ");
INSERT INTO kbo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yẹ́sụ̃ kã drĩ átángá rĩ átá dẹẹ́ ꞌí tị gé sĩ kuyé, koro Yụ́dã Yẹ́sụ̃ ã ũli ꞌbeépi rĩ ní ícázú, Yụ́dã ri ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá mụdrị́ drị̃ ni ị̃rị̃ rĩ pi vé ãzi. ꞌBá kárákará ímụ́kí Yụ́dã pi be trụ́, kộpi íꞌdụ́kí ị́lị́ ãco ãco ni pi, ãzini túré pi be ímụ́zú ĩ drị́gé sĩ ĩndĩ. Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi, ãzini ꞌbá ambugu rĩ pi be, ĩpẽkí kộpi ímụ́zú nĩ. ");
INSERT INTO kbo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yụ́dã lũ ãngáráwá rĩ pi ní drị̃drị̃ kĩnĩ, “Ágó má ní mụụ́ uꞌdeé ẹzịị́ bẹ̃drị̃ sĩ rĩ, ꞌbá rĩ ĩri adriípi ꞌdĩ. Ĩmi rụkí ĩri, ĩmi jịkí ĩri mụzú, ĩmi ũtẽkí ĩri mụzú ũtẽtẽ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kộpi kâ caá, koro Yụ́dã ní ꞌdezú mụzú Yẹ́sụ̃ vúgá ꞌdãá, ĩri ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi!” Ĩri ní kúru Yẹ́sụ̃ ri uꞌdezú ẹzịzú bẹ̃drị̃ sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kúru ãgõ ímụ́ꞌbá Yụ́dã pi be ꞌdĩꞌbée ní Yẹ́sụ̃ ri rụzú. ");
INSERT INTO kbo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ãgõ pá tuꞌbá Yẹ́sụ̃ ã gãrã gá ꞌdĩꞌbée vé ãlu ní ívé ị́lị́ ãco rĩ ínjézú kẽréwũ rĩ agásĩ, ĩri ní átálágú ãmbúgú rĩ vé ãtíꞌbá ẽ bị́ gazú mvọ́rụ́ ꞌdezú vũgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yẹ́sụ̃ ní ꞌyozú ꞌbá ꞌi rụꞌbá rĩ pi ní kĩnĩ, “Ngá ĩmi ní ímụ́zú ị́lị́ ãco ãco ni pi be, ãzini túré pi be drị́gé, ma rụzú sụ̃ ꞌbá tã ũnjí ꞌoópi rĩ tị́nị rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ụ́ꞌdụ́ céré ꞌbá rikí adrií ĩmi be trụ́, á ri ĩmi ímbá Jó Múngú vé rĩ ã bóró gá ꞌdãá, ĩmi rụkí ma kuyé. ꞌBo tã ꞌi ngaápi mâ rụ́ꞌbá gá ãndrũ nõri, ã sẽ rí tã ĩ ní sĩí kú Búkũ Múngú vé rĩ agá rĩ, ã nga rí ꞌi fũú tị́nị gé bẽnĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kúru Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ngakí ápá céré, kukí Yẹ́sụ̃ ri kú ọ́ꞌdụ́kụ́lẹgúsĩ. ");
INSERT INTO kbo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kẹ̃rị́mvá ãzi ri ꞌdeé mụzú Yẹ́sụ̃ ã vụ́drị̃ gé sĩ, ndrã bõngó ꞌî rụ́ꞌbá gá. ꞌBá rĩ pi kâ lẽé ĩri rụụ́, ");
INSERT INTO kbo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kẹ̃rị́mvá rĩ ánjó ꞌi kộpi drị́gé sĩ, ku ívé bõngó kuú kộpi drị́gé, ápá mụzú rụ́ꞌbá be ule. ");
INSERT INTO kbo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ꞌBá Yẹ́sụ̃ ri rụꞌbá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú átálágú ãmbúgú rĩ vé ãngá. Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá drị̃koma rú rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi be, úmúkí ĩ céré vũrã ãlu gé. ");
INSERT INTO kbo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pétẽró ri ꞌdeé mụzú Yẹ́sụ̃ ã vụ́drị̃ gé sĩ, se ꞌi gõó vúlé rú ãsámvú sĩ. Kã caá átálágú ãmbúgú rĩ vé bóró gá ꞌdãá, mụ úrí ꞌbá ãngũ ũtẽꞌbá rĩ pi be trụ́, rií ãcí yuú. ");
INSERT INTO kbo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tã lịꞌbá rĩ pi be céré, rikí lẹ́tị ndãá lẽzú tã ũnjí ị́sụ́zú Yẹ́sụ̃ ã rụ́ꞌbá gá, ĩ ꞌdịkí rí ĩri drãá ãní, ꞌbo kộpi ị́sụ́kí tã ũnjí rụ́ꞌbá ni gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ꞌBá kárákará ꞌdekí rií ũnjõ ụ́lị́ Yẹ́sụ̃ drị̃gé, ꞌbo átángá kộpivé rĩ, úmú ꞌi trụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kúru ꞌbá ụrụkọꞌbée ní ngazú pá tuzú ụrụ sĩ, ũnjõ úlị́zú Yẹ́sụ̃ drị̃gé, kộpi kínĩ, ");
INSERT INTO kbo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ꞌBá yịkí rá, Yẹ́sụ̃ ri ꞌyoó kĩnĩ, ‘Ma Jó Múngú vé ꞌbá áda ní sịị́ rĩ ũŋõ kpélékpélé, ma gõ ãzi ni sị ụ́ꞌdụ́ na agá, ꞌbá áda sị nĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ꞌBo átángá kộpi ní átá rĩ úmú ꞌi trụ́ kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Átálágú ãmbúgú rĩ ní íngázú pá tuzú ụrụ sĩ ꞌbá tã lịꞌbá ꞌdĩꞌbée ãsámvú gé, ĩri ní Yẹ́sụ̃ ri zịzú kĩnĩ, “Tã ãgõ ꞌdĩꞌbée ní rií ũmbĩí mí drị̃gé kárákará ꞌdĩꞌbée, ꞌí ꞌyo átángá mí tị gé sĩ ku ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ꞌBo Yẹ́sụ̃ újí kíri, zị̃ ꞌî tị átángá ꞌyozú ãluŋáni kuyé. Átálágú ãmbúgú rĩ ní gõzú ĩri zịzú dị̃ị́ kĩnĩ, “Mi Kúrísítõ, Múngú ĩ ní íngúngũ rĩ vé Mvá?” ");
INSERT INTO kbo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “ꞌBá rĩ ma ꞌi, ma ꞌBá Mvá ꞌi, úmvúlésĩ ĩmi ímụ́ ma ndre, ma úrí Múngú Ũkpõ ꞌDị́pa vé drị́ ẹ̃ndẹ́pị gé, ma ĩgõ ímụ́ ꞌbụ̃ gé ꞌdãásĩ vũgá nõó ị́rị́bị́tị agásĩ.” ");
INSERT INTO kbo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Átálágú ãmbúgú rĩ ní ívé bõngó ãsĩzú, ĩri ní ꞌyozú kĩnĩ, “Ngá ꞌbá ní ãdúꞌbá ụrụkọ lẽzú dị̃ị́ rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ĩmi yịkí ĩmî bị́ sĩ rá, ị̃njị̃ Múngú ri ku. Ĩmi ụ̃sụ̃kí tã ꞌdĩri drị̃gé ngóni?” Kộpi ngakí ãꞌyĩí céré kínĩ, ã ꞌdịkí ĩri drãá rá. ");
INSERT INTO kbo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ꞌBá rĩ pi ã ụrụkọꞌbée íꞌdókí rií tụ̃sụ́ úwé Yẹ́sụ̃ ã rụ́ꞌbá gá, kộpi úmbékí mị ni bõngó sĩ cí, kộpi íꞌdókí rií ĩri udịị́, kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌÍ lũ ꞌbá ní, ꞌbá mi udịꞌbá rĩ pi ãꞌdi pi?” ꞌBá ãngũ ũtẽꞌbá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú ꞌdĩísĩ rá, kộpi ní rizú ĩri ũgbãzú mụzú. ");
INSERT INTO kbo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pétẽró kã rií adrií jó tã lịzú rĩ vé bóró gá ꞌdãá, átálágú ãmbúgú rĩ vé ãtíꞌbá ũkúŋá rú rĩ ní ímụ́zú. ");
INSERT INTO kbo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ĩri ní Pétẽró ri ndrezú, ĩri ri ãcí yu. Ãtíꞌbá ũkúŋá rú rĩ ndre Pétẽró ri gõgõ. Ĩri ní ꞌyozú kĩnĩ, “ꞌBá rĩ ãzi mi ꞌi, ĩmi rikí ándúrú adrií Yẹ́sụ̃ Nãzẽrétãgú rĩ be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pétẽró gã, kĩnĩ, “ꞌBá rĩ adri ma ꞌi ku! Tã mí ní átá ꞌdĩri fi má drị̃gé ãluŋáni kuyé.” Pétẽró ní ꞌdezú mụzú kání rĩ vé kẹ̃ẹ́tịlé gá ꞌdãá, lõgúlõgú ní cẽré ꞌbezú. ");
INSERT INTO kbo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ãtíꞌbá ũkúŋá rú rĩ kã ndreé Pétẽró tu pá kuú ꞌdãá, ĩri ní ꞌyozú ꞌbá pá tuꞌbá ꞌí gãrã gá rĩ pi ní kĩnĩ, “Ágó ꞌdĩri, ĩri ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi vé ãzi!” ");
INSERT INTO kbo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pétẽró gã kĩnĩ, “ꞌBá rĩ adri ma ꞌi ku!” Vụ́drị̃ ni kã vụ̃ụ́ mãdã, ꞌbá pá tuꞌbá Pétẽró gãrã gá rĩ pi ní ꞌyozú Pétẽró ní kínĩ, “Ádarú mi ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi vé ãzi! Mi Gãlĩláyãgú!” ");
INSERT INTO kbo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pétẽró ní ꞌi trizú, ĩri ní ũyõ sõzú kĩnĩ, “Múngú ẹndrẹtị gé, á nị̃ mâ ágó ĩmi ní rií tã ni ꞌyoó ꞌdĩri kuyé.” ");
INSERT INTO kbo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Koro lõgúlõgú ní gõzú cẽré vú ị̃rị̃ ni ꞌbezú. Pétẽró ní tã Yẹ́sụ̃ ní ándúrú ꞌyoó ꞌí ní kínĩ, “Mi ímụ́ ma gã ca vú na, vụ́drị̃ ni gé, lõgúlõgú ri ímụ́ cẽré ꞌbe ca vú ị̃rị̃” ꞌdãri ígázú. Pétẽró íꞌdó rií ngoóngo. ");
INSERT INTO kbo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kã mụụ́ adrií ụ̃ꞌbụ́tịŋá rĩ sĩ, atala atala rĩ pi drị̃gé rĩ pi, ꞌbá drị̃koma rú rĩ pi be, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi be, ꞌbá tã lịꞌbá rĩ pi be céré úríkí átá trụ́, kộpi ní Yẹ́sụ̃ ri úmbézú, ĩri jịzú mụzú pá tuzú Pĩlátõ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pĩlátõ ní Yẹ́sụ̃ ri zịzú kĩnĩ, “Mi ꞌbãgú Yãhụ́dị̃ rĩ pi vé rĩ?” Yẹ́sụ̃ ní újázú Pĩlátõ ní kĩnĩ, “ꞌÍ ꞌyo tã ꞌdĩri mi ꞌi.” ");
INSERT INTO kbo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Atala atala rĩ pi drị̃gé rĩ pi tõkí Yẹ́sụ̃ ri, kộpi úlị́kí ũnjõ drị̃ ni gé kárákará. ");
INSERT INTO kbo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pĩlátõ ní gõzú ĩri zịzú dị̃ị́ kĩnĩ, “ꞌÍ ꞌyo tã mí tị gé sĩ ku ãsĩ? ꞌÍ yị drĩ tã ĩ ní ũmbĩí mí drị̃gé kárákará ꞌdĩꞌbée ká!” ");
INSERT INTO kbo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yẹ́sụ̃ újí tị́tị́, ꞌyo tã ãzi kuyé, ĩri ní ꞌî tị zị̃ị́ tã ꞌyozú kuyé rĩ sĩ, sẽ Pĩlátõ ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ílí ãlu ãlu, ụ́ꞌdụ́ ĩ ní rizú ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ ã nyangárá gá, ꞌbá ĩ ní ũꞌyĩí rĩ pi ãsámvú gé, Pĩlátõ ri ꞌbá ãlu ꞌbá rĩ pi ní lẽé ẽ ĩtrũkí rĩ ĩtrũ. ");
INSERT INTO kbo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ágó ãzi rụ́ ni Bãrãbã ꞌi, ágó ꞌdĩri ꞌyĩkí kộpi ꞌbá waꞌbá ariꞌba rú tã Rómã vé rĩ gãꞌbá sĩ rĩ pi be, ágó ꞌdĩri ꞌdị ꞌbá drãá rá. ");
INSERT INTO kbo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ꞌBá kárákará pi ní ímụ́zú Pĩlátõ vúgá nõó, kộpi ní ĩri zịzú kínĩ, lẽ Pĩlátõ ẽ ĩtrũ ĩ ní ꞌbá ãlu, ꞌbá ĩ ní ũꞌyĩí ꞌdĩꞌbée ãsámvú gé, sụ̃ ĩri ní ándúrú rií ꞌoó rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pĩlátõ ní ꞌbá kárákará ꞌdĩꞌbée zịzú kĩnĩ, “Ĩmi lẽkí mâ ĩtrũ ĩmi ní ꞌbãgú Yãhụ́dị̃ rĩ pi vé rĩ?” ");
INSERT INTO kbo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pĩlátõ nị̃ ámá múké ꞌyozú kínĩ, atala atala rĩ pi drị̃gé rĩ pi ĩpẽkí Yẹ́sụ̃ ri ímụ́ ꞌí vúgá nõlé nĩ, ãꞌdiãtãsĩyã Yẹ́sụ̃ vé tã ꞌde kộpi ẽ ẹ́sị́ agá ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ꞌBo atala atala rĩ pi drị̃gé rĩ pi rikí ꞌbá kárákará ꞌdĩꞌbée ĩcĩcĩkĩí, kộpi ã ꞌyokí rí, ẽ ĩtrũkí ĩ ní Bãrãbã ri áyu Yẹ́sụ̃ ã vũrã gá. ");
INSERT INTO kbo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pĩlátõ ní kộpi zịzú kĩnĩ, “ꞌBo á trũ dõ Bãrãbã ri gí, ágó ĩmi ní zịị́ ꞌbãgú Yãhụ́dị̃ rĩ pi vé ꞌdĩri, mâ ꞌo ĩri íngóni?” ");
INSERT INTO kbo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ꞌBá rĩ pi ní ọ́ꞌụ́zú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ã gbãkí ĩri pẹtị alambaku sị́gé.” ");
INSERT INTO kbo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pĩlátõ ní kộpi zịzú kĩnĩ, “Tã ũnjí Yẹ́sụ̃ ní ꞌoó rĩ ãꞌdi?” ꞌBo kộpi gõkí ọ́ꞌụ́ mụzú drị̃gélé kínĩ, “Ã gbãkí ĩri pẹtị alambaku sị́gé!” ");
INSERT INTO kbo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pĩlátõ ní lẽé ꞌbá bị́trị́ká ꞌdĩꞌbée ẽ ẹ́sị́ ã ve ꞌí ní ku rĩ sĩ, ĩri ní Bãrãbã ri trũzú, ĩri ní tãị́mbị́ sẽzú ívé ãngáráwá rĩ pi ní, kộpi ã ũgbãkí Yẹ́sụ̃ ri kẹ̃lị́ŋá sĩ, kộpi ã jịkí ĩri gbãá pẹtị alambaku sị́gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ãngáráwá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú vũrã ꞌbãgú Pĩlátõ ní adrizú rĩ gé ꞌdãá, kộpi ní ĩ ọ̃gụ̃pị́ị zịzú ímụ́zú céré vũrã ãlu gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kộpi ꞌyĩkí bõngó ika akoóko rụ̃kụ̃ ni Yẹ́sụ̃ ã rụ́ꞌbá gá, kộpi údékí ũcékúcé suú drị̃ ni gé kụ̃lá rú. ");
INSERT INTO kbo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kộpi íꞌdókí rií gụụ́ Yẹ́sụ̃ sĩ, kộpi ꞌyokí ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Ĩ ndrekí drĩ ꞌbãgú Yãhụ́dị̃ rĩ pi vé rĩ ká!” ");
INSERT INTO kbo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kộpi ní drị̃ ni ãgbãzú pẹtị sĩ, kộpi ní kpá tụ̃sụ́ úwézú rụ́ꞌbá ni gé, kộpi ũtị̃kí kũmũcí vũgá Yẹ́sụ̃ ri ị̃njị̃zú, ꞌbo adri ị̃njị̃ngárá áda ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ãngáráwá rĩ pi kâ gụụ́ Yẹ́sụ̃ sĩ gí, kộpi ní bõngó ika akoóko rụ̃kụ̃ rĩ njezú rụ́ꞌbá ni gé sĩ, kộpi ní gõzú ĩrivé bõngó íꞌdụ́zú suzú rụ́ꞌbá ni gé ũzi, kộpi ní ĩri jịzú mụzú vũrã ĩ ní lẽzú ĩri gbãzú pẹtị alambaku sị́gé rĩ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ágó ãzi rụ́ ni Sị̃mọ́nã ꞌi, ĩri Kũrénẽgú, íbí ímụ́ ọ́mvụ́ gélésĩ, kộpi mĩkí ĩri pẹtị alambaku ĩ ní mụzú Yẹ́sụ̃ ri gbãzú rĩ ꞌdụụ́ mụzú. Sị̃mọ́nã ri Ãlẽkĩzándã pi vé ẹ́tẹ́pị Rụ́fãsĩ be. ");
INSERT INTO kbo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ãngáráwá rĩ pi ní Yẹ́sụ̃ ri jịzú mụzú vũrã ĩ ní zịị́ Gõlõgótã rĩ gé ꞌdãá (ífífí ni, vũrã drị̃ kọ́lọ̃mgbọ́ vé ni). ");
INSERT INTO kbo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kộpi sẽkí ĩri ní vị́nyọ̃, usakí pí ũjó be sẽé mvụụ́ ĩri ní, rụ́ꞌbá ni ásópi rĩ ã ndrĩ rí ãní, ꞌbo gã mvụgá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kộpi ní Yẹ́sụ̃ ri gbãzú pẹtị alambaku sị́gé. Kộpi ꞌbekí ĩrivé bõngó jẽké sĩ, ꞌbá ngõri dõ ngõri ꞌdụ. ");
INSERT INTO kbo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kộpi gbãkí Yẹ́sụ̃ ri pẹtị alambaku sị́gé ꞌdãá sâ úrõmĩ ụ̃ꞌbụ́tịŋá vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sĩkí tã drị̃lé ni gé ꞌdíni, “ꞌBÃGÚ YÃHỤ́DỊ̃ RĨ PI VÉ RĨ.” ");
INSERT INTO kbo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ãngáráwá rĩ pi gbãkí kpá ụ̃gụ́ꞌbá ị̃rị̃ pẹtị alambaku sị́gé, ãzi rĩ Yẹ́sụ̃ vé drị́ ẹ̃ndẹ́pị gélésĩla, ãzi rĩ ĩrivé drị́ ị̃jị́ gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tã ĩ ní sĩí Búkũ Múngú vé rĩ agá, ĩ ní ꞌyoó, “Lãkí ĩri ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ ꞌdĩri, nga ꞌi fũú tị ni gé gí.” ");
INSERT INTO kbo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ꞌBá riꞌbá ẹlịꞌbá ẹlị ẹlị rĩ pi rikí ĩri uꞌdaá, kộpi rikí drị̃ yaá ĩri idezú ãní, kộpi rikí ꞌyoó kínĩ, “Mi ándúrú ꞌyoópi, mi Jó Múngú vé rĩ ĩŋãnyã, mi gõ sị ụ́ꞌdụ́ na agá rĩ, mi adriípi ꞌdĩ? ");
INSERT INTO kbo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ꞌÍ pa mi pẹtị alambaku rĩ sị́gé sĩ, mí ísị́ vũgá nõó!” ");
INSERT INTO kbo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atala atala rĩ pi drị̃gé rĩ pi, ꞌbá tãị́mbị́ Mósẽ vé rĩ ímbáꞌbá rĩ pi be, kộpi gụkí kpá Yẹ́sụ̃ sĩ, kộpi kínĩ, “Ídrí ꞌbá ụrụkọ rá pírí, ꞌbo ídrí ꞌî ngúlúpí ku ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kĩnĩ dõ ꞌi Kúrísítõ ꞌi, ꞌi ꞌbãgú Ĩsẽrélẽ rĩ pi vé rĩ, lẽ ẽ ísị́ pẹtị alambaku rĩ sị́gé sĩ vũgá nõó! ꞌBá ndrekí dõ gí, ꞌbâ íbí ẹ̃ꞌyị̃ ndõ.” Ụ̃gụ́ꞌbá ị̃rị̃ ĩ ní gbãá Yẹ́sụ̃ be trụ́ ꞌdĩꞌbée idekí kpá Yẹ́sụ̃ ri rá. ");
INSERT INTO kbo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kã mụụ́ adrií ụ̃tụ́ mgbímgbi gé ꞌdĩgé, ãngũ rĩ bĩ nịị́ kuú cịcị vũ drị̃gé sĩ céré, ãngũ rĩ nị caá sâ na ũndréŋá vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kã mụụ́ adrií sâ na ũndréŋá vé rĩ gé, Yẹ́sụ̃ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Ẹ̃lọ́yị̃, Ẹ̃lọ́yị̃, lãmã sãbãkãtánĩ?” Ífífí ni kĩnĩ, “Múngú mávé rĩ, Múngú mávé rĩ, ngá mí ní ma adizú rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ꞌBá ụrụkọ pá tuꞌbá ꞌdãlé rĩ pi yịkí tã Yẹ́sụ̃ ní átá ꞌdĩri, kộpi nị̃kí ífífí ni kuyé, kộpi ní ꞌyozú kínĩ, ĩri ri Ẽlíyã ri zị. ");
INSERT INTO kbo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ágó ãzi ní njuzú mụzú lífã suzú vị́nyọ̃ údrápi gí ni agá, ĩri ní suzú pẹtị sị́gé, suzú mụzú ụrụ Yẹ́sụ̃ tị gé pẹtị alambaku sị́gé ꞌdãá, ã mvụ rí, ĩri ní ꞌyozú kĩnĩ, “ꞌBá tẽkí drĩ ndreé ká, dõ Ẽlíyã ri ímụ́ ĩri pa pẹtị alambaku rĩ sị́gé sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yẹ́sụ̃ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, ĩrivé ídri ní kúru fũzú. ");
INSERT INTO kbo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bõngó ĩ ní Jó Múngú vé rĩ ã ꞌa ẹlịzú rĩ ní ꞌi ãsĩzú ị̃rị̃, íꞌdózú ụrụ ꞌdãá, cĩmgbá vũgá nõó. ");
INSERT INTO kbo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ũgalaku ãngáráwá rĩ pi vé pá tuúpi Yẹ́sụ̃ ẹndrẹtị gé rĩ kã ndreé Yẹ́sụ̃ drã gí, ĩri ní ꞌyozú kĩnĩ, “Ádarú ágó ꞌdĩri Mvá Múngú vé ni.” ");
INSERT INTO kbo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ũkú ụrụkọꞌbée tukí pá kuú rárá rú, kộpi tẽkí nyo rí tã ꞌdĩri ndreé. Kộpi ãsámvú gé ꞌdãá, ꞌbá rĩ Mãríyã Mãgãdẽlénã pi Mãríyã ãzi rĩ be, Sãlómẽ sĩ. Mãríyã ãzi ꞌdĩri Yõkóbũ mvá ụ̃dụ́ rĩ vé ẹ́ndrẹ́pị, ẹ́drị́pị ri Yósẽ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ãngũ Gãlĩláyã vé rĩ gé ꞌdãlé, ũkú ꞌdĩꞌbée rikí Yẹ́sụ̃ ã pámvú ũbĩí, kộpi rikí kpá ĩri ẽ ĩzã koó ẹ̃zị́ sĩ nĩ. Ũkú ụrụkọ kárákará mụkí kộpi be trụ́ Yẹ̃rụ́sãlémã gá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kã mụụ́ adrií ụ́ꞌdụ́ tọ̃wụ́ sĩ, ụ̃tụ́ rĩ kã rií ꞌdeé, ụ́ꞌdụ́ ꞌdãri ní adrií Yãhụ́dị̃ rĩ pi vé ni rizú ĩ útúzú cazú ụ́ꞌdụ́ Sãbátã vé rĩ gé rĩ sĩ, ");
INSERT INTO kbo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ágó ãzi rụ́ ni Yõsépã ꞌi, ĩri Ãrĩmãtáyõgú, ĩri ꞌbá ĩ ní ị̃njị̃ị́ ị̃njị̃ ni Yãhụ́dị̃ rĩ pi vé ꞌbá tã lịꞌbá rĩ pi ãsámvú gé, ri mãlũngã Múngú vé úmvúlésĩ ímụ́pi rĩ ũtẽé. Nga mụụ́ ụ̃rị̃ ãkó Yẹ́sụ̃ vé ãvũ ã tã zịị́ Pĩlátõ tị gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pĩlátõ kã yịị́ kínĩ Yẹ́sụ̃ drã gí, sẽ ĩri ní ãyãngárá. Ĩri ní ũgalaku ãngáráwá rĩ pi vé rĩ zịzú ímụ́zú, lẽ nị̃ị́ dõ ádarú Yẹ́sụ̃ drã gí. ");
INSERT INTO kbo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ũgalaku rĩ kã lũú ĩri ní, Yẹ́sụ̃ drã gí, ĩri ní kúru ãvũ Yẹ́sụ̃ vé rĩ ọyụzú sẽzú Yõsépã drị́gé. ");
INSERT INTO kbo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yõsépã ní kúru bõngó jezú, ĩri ní ãvũ rĩ íꞌdụ́zú pẹtị alambaku sị́gé ꞌdãásĩ vũgá nõó, ĩri ní ĩmũlũzú bõngó rĩ sĩ, jịzú mụzú sị̃zú ꞌbụ́ ĩ ní gaá lũú ị́nọ́gọ́sị́ írã rụ́ꞌbá gá rĩ agá. Ĩri ní kúru írã ãmbúgú ni ĩgũzú, ꞌbụ́ rĩ ẽ tị ọ̃zụ̃zú ãní cí. ");
INSERT INTO kbo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mãríyã Mãgãdẽlénã pi, Mãríyã Yósẽ ẹ́ndrẹ́pị be, kộpi ndrekí vũrã ĩ ní ãvũ rĩ sị̃zú rĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ụ́ꞌdụ́ Sãbátã vé rĩ kã dẹẹ́ gí, Mãríyã Mãgãdẽlénã pi Mãríyã Yõkóbũ ẹ́ndrẹ́pị be, Sãlómẽ sĩ, kộpi jekí ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni, kộpi lẽkí mụụ́ Yẹ́sụ̃ vé ãvũ trịị́ ãní. ");
INSERT INTO kbo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kã mụụ́ adrií Yĩngã sĩ ụ̃ꞌbụ́tị, ụ̃tụ́ ní rií ĩfũngárá gá ꞌdĩgé, kộpi ní ꞌdezú mụzú ꞌbụ́rẹ̃drị̃ gé ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kộpi ní rií mụngárá gá lẹ́tị gé ꞌdĩgé, kộpi rikí ĩ uzịị́ ĩ ãsámvú gé sĩ kínĩ, ãꞌdi ã gũ rí ꞌbá ní írã rĩ ꞌbụ́ rĩ tị gé sĩ ãmvé nĩ? ");
INSERT INTO kbo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ꞌBo kộpi kâ caá, kộpi ndrekí gũkí írã ãmbúgú ꞌdĩri ꞌbụ́ rĩ tị gé sĩ gãrã gá gí! ");
INSERT INTO kbo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kộpi ní fizú mụzú ꞌbụ́ rĩ agá ꞌdãá, kộpi ndrekí kẹ̃rị́mvá ãzi úrí kuú drị́ ẹ̃ndẹ́pị gélésĩ, su bõngó imvesírílílí akoóko rụ̃kụ̃ ni. Sẽ kộpi ní ụ̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kẹ̃rị́mvá rĩ ní ꞌyozú kĩnĩ, “Lẽ ĩmi adrikí ụ̃rị̃ sĩ ku! Á nị̃ rá ĩmi ri Yẹ́sụ̃ Nãzẽrétãgú ĩ ní gbãá pẹtị alambaku sị́gé rĩ ndã. Múngú inga ĩri gõó ídri rú gí! Ĩri nõgó ꞌdãáyo. Ĩmi ndrekí vũrã ĩ ní ĩrivé ãvũ ꞌbãzú rĩ ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lẽ ĩmi mụkí lũú ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní, agaápi rá rĩ, lẽ ĩmi lũkí Pétẽró ní kínĩ, Yẹ́sụ̃ ri ꞌde mụzú ĩmi ẹndrẹtị gé sĩ ãngũ Gãlĩláyã vé rĩ gé ꞌdãáꞌdã, sụ̃ ĩri ní lũú ĩmi ní rĩ tị́nị, ĩmi ca mụ ĩri ị́sụ́ ꞌdãlé.” ");
INSERT INTO kbo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ũkú rĩ pi kâ ĩfũú ꞌbụ́ rĩ agá ꞌdãásĩ, kộpi ẽ drị̃ ábá céré céré, kộpi ã rụ́ꞌbá yã kpĩríkpĩrí, ụ̃rị̃ ị́mvụ́ kộpi, kộpi ngakí njuú mụzú ọ́ngụ́ sĩ, kộpi lũkí tã ꞌi ngaápi ꞌdĩri ꞌbá ãzi ní kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ụ̃ꞌbụ́tị Yĩngã sĩ, Yẹ́sụ̃ kã íngá drãngárá gálésĩ, ĩri ní ꞌi iꞌdazú Mãríyã Mãgãdẽlénã ándúrú ĩri ní índrí ũnjí ẹ́zị̂rị̃ droó fũú drị̃ ni gé sĩ rĩ ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mãríyã Mãgãdẽlénã ní mụzú tã ꞌdĩri ũlũzú ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá, riꞌbá ĩzãngã ꞌbãꞌbá, ãá ngoꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kộpi kâ yịị́ kínĩ, Yẹ́sụ̃ ri ídri rú, Mãríyã ndre ĩri rá, kộpi ẹ̃ꞌyị̃kí ĩrivé tã ꞌdĩri kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vụ́drị̃ ni gé, Yẹ́sụ̃ ní ꞌi iꞌdazú índrézú ũꞌdũ be túngú ívé ꞌbá ꞌî pámvú ũbĩꞌbá ị̃rị̃ ni pi ẹndrẹtị gé, ị́sụ́ kộpi ri fũ mụzú kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agásĩ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi kâ nị̃ị́ ámá ꞌbá rĩ Yẹ́sụ̃ ꞌi, kộpi ní njuzú gõzú vúlé, mụzú ũlũzú ĩ ọ̃gụ̃pị́ị ní, ꞌbo ọ̃gụ̃pị́ị ẹ̃ꞌyị̃kí tã kộpi ní ũlũú ꞌdĩri kuyé. ");
INSERT INTO kbo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vụ́drị̃ ni gé, Yẹ́sụ̃ ní gõzú ꞌi iꞌdazú ívé ꞌbá ꞌî pámvú ũbĩꞌbá mụdrị́ drị̃ ni ãlu, riꞌbá ngá nyaꞌbá rĩ pi ẹndrẹtị gé. Átá kộpi drị̃gé ũkpõ ũkpó, ãꞌdiãtãsĩyã ꞌbá ívé íngángárá ndreꞌbá rá rĩ pi kâ ívé íngángárá ã tã ũlũú kộpi ní, kộpi ẽ ẹ́sị́ mbamba, kộpi gãkí tã rĩ ẹ̃ꞌyị̃gá sĩ. ");
INSERT INTO kbo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ĩmi mụkí ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũú mụzú ꞌbá rĩ pi ní vũ drị̃gé sĩ céré. ");
INSERT INTO kbo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ꞌBá ụ́ꞌdụ́kọ́ múké ꞌdĩri ẹ̃ꞌyị̃ị́pi rá, ãzini bãtízĩmũ ị́sụ́pi rá rĩ, ĩri ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ꞌBo ꞌbá ụ́ꞌdụ́kọ́ múké rĩ ẹ̃ꞌyị̃ị́pi kuyé rĩ, ĩ tã lị drị̃ ni gé ũnjí. ");
INSERT INTO kbo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ꞌBá ma ẹ̃ꞌyị̃ꞌbá rá rĩ pi, kộpi ícó tã ãyãzú ãyãyã ni pi ꞌo rá. Mávé rụ́ sĩ, kộpi índrí ũnjí údró fũ ꞌbá rĩ pi drị̃gé sĩ rá, kộpi ícó átá tị ãndíãndí ĩ ní nị̃ị́ kuyé ni pi sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kộpi ícó ị̃nị̃ rụ drị́ sĩ rá, kộpi mvụkí dõ kícú, kícú rĩ ícó kộpi ꞌoó ũnjí ku. Kộpi ícó drị́ tị̃ ꞌbá drã be rĩ pi drị̃gé, drã rĩ dẹ kộpi rụ́ꞌbá gá sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Úpí Yẹ́sụ̃ kã átángá rĩ átá dẹẹ́ ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be gí, Múngú ní ĩri ꞌdụzú mụzú ꞌbụ̃ gé ꞌdãá, mụ úrí Múngú vé drị́ ẹ̃ndẹ́pị gé. ");
INSERT INTO kbo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní mụzú ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũzú mụzú ꞌbá rĩ pi ní céré, Úpí vé ũkpõ nga ẹ̃zị́ kộpi rụ́ꞌbá gá rá, tã ãyãzú ãyãyã kộpi ní ꞌoó rĩ lũ ꞌyozú kínĩ, ụ́ꞌdụ́kọ́ múké kộpi ní ũlũú rĩ, ĩri tã áda.");
INSERT INTO kbo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ãmbúgú Tõfílĩ, ꞌbá kárákará ꞌbị̃kí tã Múngú ní ngaá ꞌbá ãsámvú gé nõgó rĩ sĩí rá. ");
INSERT INTO kbo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kộpi sĩkí tã ꞌbá rĩ pi ní ũlũú ꞌbá ní rĩ, ꞌbá tã rĩ ũlũꞌbá rĩ pi ndrekí tã ĩ ꞌoꞌbá rĩ pi ĩ mị sĩ íꞌdóngárá gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ãmbúgú Tõfílĩ, á ꞌbã ẹ́sị́ tã rĩ pi ụ̃nị̃zú múké múké ĩri ní ꞌi íꞌdóngárá gá ꞌdãá, má ụ̃sụ̃ á lẽ tã ꞌi ngaápi rĩ sĩí sẽé mí ní. ");
INSERT INTO kbo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ãꞌdiãtãsĩyã mî nị̃ rí ꞌyozú kínĩ tã ĩ ní ímbá mí ní rĩ, ĩri tã áda. ");
INSERT INTO kbo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lókí Ẽródẽ ní adrizú ꞌbãgú rú ãngũ Yụ̃dáyã vé rĩ agá rĩ gé, átálágú ãzi rụ́ ni Zãkãríyã ꞌi. Ágó rĩ íbí ĩfũú úyú atala rĩ pi vé rĩ agá, úyú Ãbíjã vé rĩ agá. Ũkú ni Ẽlĩsãbétã íbí ĩfũú úyú Ãrónã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kộpi ị̃rị̃trọ́ tã ꞌo pịrị Múngú ẹndrẹtị gé, kộpi ri tãị́mbị́ Úpí vé rĩ ꞌdụ nga rá, ãzini kộpi ri tã ĩ ní ẹzịị́ rĩ ꞌdụ nga rá. ");
INSERT INTO kbo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kộpi tịkí anji kuyé, ãꞌdiãtãsĩyã Ẽlĩsãbétã ní adrií úndó rú rĩ sĩ, kộpi ị̃rị̃trọ́ dẽkí kuú ãrãkã rú. ");
INSERT INTO kbo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ụ́ꞌdụ́ ãlu, Zãkãríyã ri ẹ̃zị́ ngaá Jó Múngú vé rĩ agá ꞌdãá, ãꞌdiãtãsĩyã ụ́ꞌdụ́ ꞌdãri gé, ngúlúmũ Ãbíjã vé rĩ pi rikí ẹ̃zị́ rĩ ngaá nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ĩpẽkí Zãkãríyã ri mụụ́ ẹ̃jị́ngụ̃rụ́ zãá Jó Múngú vé rĩ agá ꞌdãá, sụ̃ mẽrẽ atala rĩ pi vé rĩ ní lẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lókí ẹ̃jị́ngụ̃rụ́ zãzú rĩ kã ícó, ꞌbá ĩ úmúꞌbá rĩ pi rikí Múngú ri zịị́ ãmvé. ");
INSERT INTO kbo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kúru Úpí vé mãlãyíkã ní índrézú Zãkãríyã ẹndrẹtị gé, mãlãyíkã rĩ tu pá vũrã ẹ̃jị́ngụ̃rụ́ zãzú rĩ gé drị́ ẹ̃ndẹ́pị gélésĩla. ");
INSERT INTO kbo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zãkãríyã kã mãlãyíkã rĩ ndreé, ẹ́sị́ ni tĩ rụ̃cụ̃, ụ̃rị̃ ị́mvụ́ ĩri ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ꞌBo mãlãyíkã rĩ ní ꞌyozú ĩri ní kĩnĩ, “Zãkãríyã, mî ꞌo ụ̃rị̃ sĩ ku! Múngú yị mívé zịngárá gí. Mî ũkú ni Ẽlĩsãbétã ri ímụ́ mí ní mvá ágó tị rá, ꞌí ꞌda mváŋá rĩ ã rụ́ Yũwánĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ãyĩkõ ri ímụ́ mi fụ ambamba, mi únjí ãní rá. ꞌBá kárákará pi ímụ́ únjí ĩ ní ĩri tịị́ rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ĩri ímụ́ adri ãmbúgú Úpí ẹndrẹtị gé. Mvụ vị́nyọ̃ ku, ãzini mvụ íwá ku, ĩri ẹ́pị́ Índrí Uletere rĩ sĩ íꞌdózú ẹ́ndrẹ́pị agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ĩri ímụ́ ꞌbá Ĩsẽrélẽ vé rĩ pi íjị́ kárákará ĩgõ ĩvé Úpí Múngú vúgá. ");
INSERT INTO kbo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ĩri ꞌde mụzú Úpí ní drị̃drị̃, Índrí Uletere rĩ ĩri ású, ãzini ĩri ũkpõ ị́sụ́ sụ̃ Ẽlíyã vé rĩ tị́nị. Ĩri ímụ́ anji ẹ́tẹ́pị́ị vé ẹ́sị́ újá, kộpi ĩvé anji lẽ ãní lẽlẽ, ãzini ĩri ímụ́ ꞌbá drị̃ be ũkpó ũkpó rĩ pi újá tã nị̃ sụ̃ ꞌbá Múngú vé adriꞌbá pịrị rĩ pi ní tã nị̃ị́ rĩ tị́nị, ĩri ímụ́ ꞌbá rĩ pi údé ku ũrẽ Úpí ri ũtẽngárá gá.” ");
INSERT INTO kbo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zãkãríyã ní mãlãyíkã rĩ zịzú kĩnĩ, “Ma ícó nị̃ ámá íngóni ꞌyozú kínĩ tã ꞌdĩri ꞌi nga rá? Á dẽ kú ãrãkã rú gí, mâ ũkú ni dẽ kpá ãrãkã rú gí.” ");
INSERT INTO kbo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mãlãyíkã rĩ ní újázú ĩri ní kĩnĩ, “Ma Gãbũrélẽ ꞌi. Ma ãtíꞌbá Múngú vé ni, Múngú ĩpẽ ma ímụ́ mí ní ụ́ꞌdụ́kọ́ múké ꞌdĩri ũlũú. ");
INSERT INTO kbo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ꞌÍ ndre drĩ ká, íꞌdózú ãndrũ sĩ, mî tị ri ọ̃zụ̃, mí átá ku, cĩmgbá ĩ ní mváŋá rĩ tịzú rĩ gé, ãꞌdiãtãsĩyã mí ẹ̃ꞌyị̃ tã má ní ꞌyoó ĩri ímụ́ ꞌi nga sâ pịrị ni gé rĩ kuyé.” ");
INSERT INTO kbo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ꞌBá rĩ pi kâ rií Zãkãríyã ri tẽé, kộpi rikí ụ̃sụ̃ụ́ kínĩ, Zãkãríyã áwí Jó Múngú vé rĩ agá ꞌdãá sâ be ãco ꞌdíni ãsĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zãkãríyã kã ĩfũú ãmvé nõó, ícó átá kộpi be ku. Kộpi ní nị̃zú ámázú ꞌyozú kínĩ tã ãzi iꞌda ꞌi ĩri ní ị́ndrị́lị́kị́ agá Jó Múngú vé rĩ agá ꞌdãá gí, gõ rií kộpi ní tã rĩ ũlũú drị́ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zãkãríyã kã ívé ẹ̃zị́ dẹẹ́, ĩri ní mvizú mụzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tã ꞌdĩri ã vụ́drị̃ gé, koro ũkú ni Ẽlĩsãbétã ní ꞌa ị́sụ́zú, Ẽlĩsãbétã adri mbãá tọ̃wụ́ kú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ĩri ní ꞌyozú kĩnĩ, “Tã Úpí ní ꞌoó mâ rụ́ꞌbá gá nõri, ꞌdụ drị̃njá má drị̃gé sĩ gí, sẽ ꞌbá rĩ pi ínjákí mâ drị̃ ku.” ");
INSERT INTO kbo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ẽlĩsãbétã vé ꞌa rĩ kã mbaá caá mbãá ázíyá, Múngú ní mãlãyíkã Gãbũrélẽ ri ĩpẽzú ímụ́zú kụ̃rụ́ Nãzẽrétã vé rĩ gé, ãngũ Gãlĩláyã vé rĩ agá, ");
INSERT INTO kbo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ĩpẽ ĩri ímụ́ Mãríyã adriípi kácáŋá rú Yõsépã ní lẽé jeé ꞌí ní ũkú rú rĩ vúgá, Yõsépã ĩfũ úyú Dãwụ́dị̃ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mãlãyíkã rĩ ní fizú ĩri vúgá ꞌdãá, ꞌyozú ĩri ní kĩnĩ, “Mõdó mí ní, sẽkí mí ní tãkíri gí, Úpí ri mí be trụ́.” ");
INSERT INTO kbo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mãríyã ẽ drị̃ ábá céré céré tã mãlãyíkã rĩ ní ꞌyoó rĩ sĩ, ri ụ̃sụ̃ụ́ ꞌí ẹ́sị́ agá ꞌdãá, mõdó ꞌdĩri vé ífífí ãꞌdi. ");
INSERT INTO kbo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mãlãyíkã rĩ ní ꞌyozú Mãríyã ní kĩnĩ, “Mî ꞌo ụ̃rị̃ sĩ ku. Múngú ꞌbã tãkíri mí drị̃gé gí. ");
INSERT INTO kbo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mi ímụ́ ꞌa ị́sụ́, mi mvá ágóŋá tị, ꞌí ꞌda rụ́ ni Yẹ́sụ̃ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ĩri ímụ́ adri ãmbúgú, ĩ ímụ́ ĩri zị Mvá Múngú ãmbúgú ꞌbá drị̃gé céré rĩ vé ni. Úpí Múngú ri ímụ́ sẽ ĩri ẹ́ꞌbị́pị Dãwụ́dị̃ vé mãlũngã rụ nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ĩri ímụ́ adri ꞌbãgú rú sụ́rụ́ Yõkóbũ vé rĩ pi drị̃gé. Ĩri ímụ́ mãlũngã rụ mụzú ụ̃dụ̃ ãkó.” ");
INSERT INTO kbo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mãríyã ní mãlãyíkã rĩ zịzú kĩnĩ, “Ma drĩ ágó ãkó pírí, tã ꞌdĩri ímụ́ ꞌi nga mâ rụ́ꞌbá gá íngóni ngóni?” ");
INSERT INTO kbo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mãlãyíkã rĩ ní ꞌyozú Mãríyã ní kĩnĩ, “Índrí Uletere rĩ ímụ́ mi ású, ãzini ũkpõ Múngú vé rĩ ímụ́ mi ású rá. Mvá mí ní ímụ́ tịị́ rĩ, ĩri adri uletere, ĩ ĩri zị Mvá Múngú vé ni. ");
INSERT INTO kbo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mívé máríté Ẽlĩsãbétã ri nóni ꞌa be, ĩri ímụ́ mvá ágó tị rá, ị́sụ́zú dẽ kú ãrãkã rú, ꞌa ni mba nóni caá mbãá ázíyá, ꞌbá rĩ pi rikí ꞌyoó kínĩ ĩri úndó rú. ");
INSERT INTO kbo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tã ãzi Múngú ri ndẽépi ni ãluŋáni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mãríyã ní ꞌyozú kĩnĩ, “Ma ãtíꞌbá Úpí vé ni. Tã rĩ ã nga ꞌi mâ rụ́ꞌbá gá sụ̃ mí ní ꞌyoó rĩ tị́nị.” Kúru mãlãyíkã rĩ ní ĩri kuzú, ĩri ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sâ ꞌdãri gé, Mãríyã ní ꞌdezú mụzú rụ́ꞌbá sĩ kụ̃rụ́ ánga rú Yụ̃dáyã vé rĩ gé ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ĩri ní mụzú kụ̃rụ́ Zãkãríyã ní adrizú rĩ gé, ĩri ní fizú Zãkãríyã vé jó agá ꞌdãá, ĩri ní Ẽlĩsãbétã ri ẹzịzú. ");
INSERT INTO kbo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ẽlĩsãbétã kã Mãríyã vé ẹzịngárá ꞌdĩri yịị́, mváŋá rĩ ní ꞌi úlózú Ẽlĩsãbétã agá ꞌdãá. Índrí Uletere rĩ ní Ẽlĩsãbétã ri ásúzú. ");
INSERT INTO kbo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ĩri ní íꞌdózú átázú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Ũkú rĩ pi ãsámvú gé, ꞌbãkí tãkíri mí drị̃gé gí, mvá mí ní ímụ́ tịị́ rĩ, ꞌbãkí tãkíri drị̃ ni gé gí! ");
INSERT INTO kbo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ꞌBo ngá sẽépi Múngú ní ma ị̃njị̃zú, ĩri ní Úpí ẹ́ndrẹ́pị ri ĩpẽzú ímụ́zú ma ndrezú rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Má kã mõdó mí ní sẽé rĩ yịị́, koro mvá má agá rĩ adri ãyĩkõ sĩ, úló ꞌi má ꞌa gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Múngú ꞌbã tãkíri mí drị̃gé gí, ãꞌdiãtãsĩyã mí ãꞌyĩ tã Úpí ní ꞌyoó ĩri ꞌi nga mî rụ́ꞌbá gá rĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mãríyã ní ꞌyozú kĩnĩ, “Má íngú Múngú ri ẹ́sị́ be céré. ");
INSERT INTO kbo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mâ ẽ ẹ́sị́ ị́sụ́ ãyĩkõ Múngú ma Paápi rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ãꞌdiãtãsĩyã ma ãtíꞌbá ĩ ní ndreé kuú ẹ̃zị́ ãkó ni, Múngú ụ̃sụ̃ mâ tã gí. Íꞌdózú ãndrũ mụzú drị̃drị̃, anji ĩ ní ímụ́ tịị́ vúlé ꞌdĩí rĩ pi ímụ́ ꞌyo kínĩ, Múngú ꞌbã tãkíri má drị̃gé gí, ");
INSERT INTO kbo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ãꞌdiãtãsĩyã Múngú Ũkpõ ꞌDị́pa ꞌo tã ãmbúgú mâ rụ́ꞌbá gá gí, ĩrivé rụ́ uletere. ");
INSERT INTO kbo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ẹ́sị́ ni ri adri ĩdríkídri ꞌbá ꞌi ruꞌbá ruru rĩ pi ní mụzú ꞌdániꞌdáni. ");
INSERT INTO kbo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inga ꞌî drị́ ũkpõ be rĩ tã ꞌozú ãní, íré ꞌbá ãfú rú rĩ pi kpélékpélé. ");
INSERT INTO kbo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ísị́ ꞌbá ãngũ rụꞌbá rĩ pi ĩvé lúpá drị̃gé sĩ vũgá, gõ ꞌbá tã be mãdã rĩ pi ingaá ụrụ. ");
INSERT INTO kbo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sẽ ngá múké nyaá ꞌbá ẹ̃bị́rị́ ní fụụ́ rĩ pi ní, ꞌbo pẽ ꞌbá ãꞌbú be rĩ pi mụzú drị́ be ule. ");
INSERT INTO kbo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ko ívé ãtíꞌbá Ĩsẽrélẽ vé rĩ pi ẽ ĩzã rá. Ãvĩ ũyõ ꞌí ní sõó lẽzú ẹ́sị́ ĩdríkídri ꞌbãzú kộpi ní ꞌdãri ã tã sĩ kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sõ ũyõ ꞌbá ẹ́ꞌbị́pị Ãbũrámã ní ĩrivé úyú pi be kĩnĩ, ꞌi adri kộpi ní ẹ́sị́ be múké mụzú nyonyo.” ");
INSERT INTO kbo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mãríyã áwí adrií Ẽlĩsãbétã vé ãngá ꞌdãá mbãá na, ĩri ní kúru mvizú mụzú ꞌbẹ̃tị́. ");
INSERT INTO kbo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sâ Ẽlĩsãbétã ní mváŋá rĩ tĩzú rĩ kã ícó, tĩ mváŋá rĩ ágóŋá. ");
INSERT INTO kbo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ꞌBá ĩrivé jó gãrã gá rĩ pi máríté rĩ pi be kâ yịị́ kínĩ, Úpí ꞌbã ẹ́sị́ múké ĩri ní, tĩ mváŋá rĩ gí, kộpi adrikí ãní ãyĩkõ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mváŋá rĩ kã adrií caá ụ́ꞌdụ́ ãrõ, Zãkãríyã ẹ́ꞌdị́páa pi ĩrivé ũndĩ rĩ pi be, úmúkí ĩ mváŋá rĩ vé ágélé ẽ tị lịngárá gá, kộpi lẽkí kõdô mváŋá rĩ vé ẹ́tẹ́pị vé rụ́ Zãkãríyã ꞌdĩri ꞌdaá mváŋá rĩ ã rụ́ꞌbá gá. ");
INSERT INTO kbo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ꞌBo ẹ́ndrẹ́pị gã sĩ, kĩnĩ, “Ã ꞌdakí mvá rĩ ã rụ́ Yũwánĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ꞌBá rĩ pi ní ꞌyozú kínĩ, “Mívé máríté rĩ pi ãsámvú gé, ꞌbá ãzi rụ́ be ꞌdíni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kúru kộpi rikí átá Zãkãríyã ní drị́ sĩ, kộpi lẽkí nị̃ị́ vú ni gé, lẽ ã ꞌdakí mvá rĩ ã rụ́ ãꞌdi ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zãkãríyã ní ngá kpọlọꞌbụ ni zịzú, ꞌî sĩ rí mváŋá rĩ ã rụ́ ãní, ĩri ní mváŋá rĩ ã rụ́ sĩzú kĩnĩ, “Rụ́ ni Yũwánĩ ꞌi.” ꞌBá rĩ pi céré ãyãkí tã ꞌdĩri sĩ ãyãyã. ");
INSERT INTO kbo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Koro Zãkãríyã ẽ tị ní ꞌi zị̃zú, ádra ni ní ꞌi ọyụzú, ĩri ní íꞌdózú átángá átázú, Múngú ri íngúzú. ");
INSERT INTO kbo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ꞌBá adriꞌbá ĩri ã gãrã gá rĩ pi ãrẽvú céré ãyãkí tã ꞌdĩri sĩ ãyãyã. ꞌBá adriꞌbá ãngũ Yụ̃dáyã vé ánga rú rĩ gé rĩ pi ãrẽvú céré rikí átá tã ꞌdĩꞌbée sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ꞌBá tã ꞌdĩri yịꞌbá rĩ pi ãrẽvú céré ngakí ãyãá tã ꞌdĩri sĩ ãyãyã, kộpi ní zịzú kínĩ, “Mváŋá ꞌdĩri úmvúlésĩ ímụ́ adri ꞌbá íngóni ni?” Ãꞌdiãtãsĩyã kộpi ndrekí, Úpí ri ĩri be trụ́. ");
INSERT INTO kbo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Índrí Uletere rĩ ní mváŋá rĩ vé ẹ́tẹ́pị Zãkãríyã ri ásúzú, Zãkãríyã ní kúru ụ́ꞌdụ́kọ́ íngápi Múngú vúgálésĩ rĩ ũlũzú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ẽ íngúkí Úpí Múngú Ĩsẽrélẽ vé rĩ íngúngũ, ãꞌdiãtãsĩyã ímụ́ ívé ꞌbá rĩ pi paá gí. ");
INSERT INTO kbo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ĩpẽ ꞌbá ní ꞌbá ũkpõ be ni ímụ́ ꞌbâ paá, ĩpẽ íngázú ívé ãtíꞌbágú Dãwụ́dị̃ vé úyú agá. ");
INSERT INTO kbo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Úpí ẹzị tã ꞌdĩri kú ívé nẹ́bị̃ uletere rĩ pi ní ọ́tụ́ ị́nọ́gọ́sị́, ");
INSERT INTO kbo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kĩnĩ, ĩ ímụ́ ꞌbâ pa ꞌbávé ariꞌba rĩ pi drị́gé sĩ, ãzini ꞌbá ꞌbâ ndreꞌbá ũnjí rĩ pi drị́gé sĩ rá. ");
INSERT INTO kbo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Múngú kĩnĩ ꞌî ẹ́sị́ ri adri ĩdríkídri ꞌbávé ẹ́tẹ́pị́ị ní, ãzini ꞌi ívé ũndĩ ꞌí ní rụụ́ uletere rĩ vé tã ígá rá. ");
INSERT INTO kbo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sõ ũyõ rĩ ꞌbá ẹ́ꞌbị́pị Ãbũrámã ní ");
INSERT INTO kbo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kĩnĩ, ꞌi ꞌbâ pa ꞌbávé ariꞌba rĩ pi drị́gé sĩ rá, ꞌbâ ngakí rí ꞌí ní ẹ̃zị́ ụ̃rị̃ ãkó, ");
INSERT INTO kbo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ụ́ꞌdụ́ céré ꞌbâ adrikí rí uletere, ãzini ꞌbâ ꞌokí rí tã pịrị ꞌí ẹndrẹtị gé. ");
INSERT INTO kbo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mâ mvá rĩ, ĩ ímụ́ mi zị nẹ́bị̃ Múngú ũkpõ be ꞌbá rĩ pi drị̃gé céré rĩ vé ni, ãꞌdiãtãsĩyã mi ímụ́ mụ drị̃drị̃ Úpí ní lẹ́tị údé. ");
INSERT INTO kbo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mi ímụ́ lũ ĩrivé ꞌbá rĩ pi ní, ĩ ícó kộpi pa rá, Múngú trũ dõ kộpi ĩvé ũnjĩkãnyã agásĩ gí. ");
INSERT INTO kbo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Múngú ní adrií ẹ́sị́ be múké rĩ sĩ, ĩri ímụ́ ꞌbá ní ụ̃tụ́ŋá ĩpẽ ꞌbụ̃ gé ꞌdãásĩ dị̃ ꞌbá drị̃gé, ");
INSERT INTO kbo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ĩri ímụ́ dị̃ ꞌbá adriꞌbée ị́nị́ŋá agá rĩ pi drị̃gé, ãzini ꞌbá riꞌbá drãngárá ũtẽꞌbá rĩ pi drị̃gé, ĩri ꞌbá ní lẹ́tị pịrị tãkíri ị́sụ́zú ni iꞌda.” ");
INSERT INTO kbo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yũwánĩ kã mbaá, Índrí Múngú vé rĩ sẽ ĩri ní ũkpõ. Yũwánĩ adri ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá cĩmgbá cazú ụ́ꞌdụ́ ĩ ní ĩri pẽzú mụzú ꞌbá Ĩsẽrélẽ vé rĩ pi ãsámvú gé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lókí ꞌdãri gé, ꞌbãgú ãmbúgú Rómã vé Ãgósĩtõ sẽ tãị́mbị́ kĩnĩ, lẽ ꞌbá Rómã vé rĩ pi céré, ã sĩkí kộpi ã rụ́ búkũ agá. ");
INSERT INTO kbo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(ꞌDĩri rụ́ ĩ ní íꞌdó sĩí drị̃drị̃ ꞌbá rĩ pi lãzú, ị́sụ́ ãkũdẽ Kụ̃rị̃nị́yã ri gávãnã ãngũ Sírĩyã vé rĩ agá rĩ.) ");
INSERT INTO kbo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ꞌBá ãlu ãlu nga mụụ́ ꞌî rụ́ sĩí ĩvé kụ̃rụ́ agá. ");
INSERT INTO kbo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kúru Yõsépã pi ní ngazú ãngũ Gãlĩláyã vé rĩ agá, kụ̃rụ́ Nãzẽrétã vé rĩ agásĩ, kộpi ní ꞌdezú mụzú ãngũ Yụ̃dáyã vé rĩ gé, kụ̃rụ́ Bẽtẽlémẽ vé rĩ agá, ãꞌdiãtãsĩyã Yõsépã ĩfũ úyú Dãwụ́dị̃ vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jị Mãríyã ĩri ní lẽé jeé ꞌí ní ũkú rú rĩ mụzú ꞌí vúgá sĩ ĩndĩ, ị́sụ́ Mãríyã ã ꞌa mba dẹẹ́ gí, ĩri ílókõ tĩtĩ. ");
INSERT INTO kbo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kộpi kâ rií adrií ꞌdãlé, sâ Mãríyã vé mvá rĩ tĩzú rĩ ní ícázú. ");
INSERT INTO kbo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mãríyã ní ívé mvá kãyú rĩ tĩzú ágóŋá. Ĩri ní ĩmũlũzú bõngó sĩ, ĩri ní ꞌbãzú lazú sọ̃ndụ́kụ̃ ãnyãpá rĩ pi ní rizú ngá nyazú rĩ agá. ꞌBã mváŋá rĩ laá sọ̃ndụ́kụ̃ rĩ agá, ãꞌdiãtãsĩyã jó ụ̃mụ́ rĩ pi ní lazú rĩ agá ꞌdãá, kộpi ị́sụ́kí vũrã lazú ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ị́nị́ŋá ꞌdãri sĩ, ꞌbá ụrụkọ kãbĩlõ úcéꞌbá ni pi rikí ĩvé kãbĩlõ ũtẽé ásé agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mãlãyíkã ãlu Úpí vé rĩ ní índrézú kộpi ẹndrẹtị gé, dị̃ngárá Úpí vé rĩ ní ãngũ ĩmgbẽrẽzú kộpi ã gãrã gá sĩ, sẽ ụ̃rị̃ fụ kộpi ambamba. ");
INSERT INTO kbo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kúru mãlãyíkã rĩ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adrikí ụ̃rị̃ sĩ ku. Má íjị́ ĩmi ní ụ́ꞌdụ́kọ́ múké, ꞌbá rĩ pi céré ímụ́ adri ãní ãyĩkõ sĩ ãmbúgú. ");
INSERT INTO kbo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ị́nị́ŋá ãndrũ nõri sĩ, tĩkí ĩmi ní ꞌbá ĩmi Paápi ni gí kụ̃rụ́ Dãwụ́dị̃ vé rĩ agá Bẽtẽlémẽ agá, ĩri Úpí Kúrísítõ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ngá ĩmi ní ícózú ĩri nị̃zú ámázú rĩ ĩri ꞌdíni, ĩmi mụ ũdéŋá rĩ ị́sụ́ ĩmũlũkí bõngó sĩ, ꞌbãkí ĩri laá sọ̃ndụ́kụ̃ ãnyãpá rĩ pi ní ngá nyazú rĩ agá.” ");
INSERT INTO kbo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Koro mãlãyíkã ụrụkọ kárákará íngákí ꞌbụ̃ gé ꞌdãásĩ, kộpi úmúkí ĩ mãlãyíkã índrépi ꞌdĩri be trụ́, kộpi rikí Múngú ri íngú, rikí ꞌyoó kínĩ, ");
INSERT INTO kbo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ẽ íngúkí Múngú ꞌbụ̃ gé ꞌdãá rĩ íngúngũ, tãkíri ã adri vũ drị̃gé nõgó ꞌbá Múngú ní ãyĩkõ sẽꞌbá rĩ pi ãsámvú gé.” ");
INSERT INTO kbo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mãlãyíkã rĩ pi kâ ĩ újá gõó mụụ́ ꞌbụ̃ gé ꞌdãá, ꞌbá kãbĩlõ úcéꞌbá rĩ pi ní átázú ĩ ãsámvú gé sĩ kínĩ, “Lẽ ꞌbâ ꞌdekí mụụ́ Bẽtẽlémẽ gá ꞌdãá tã ꞌi ngaápi Úpí ní lũú ꞌbá ní rĩ ndreé ꞌbâ mị sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kộpi alikí ĩ mụzú rụ́ꞌbá sĩ, kộpi cakí Mãríyã pi ị́sụ́ Yõsépã be ũdéŋá rĩ sĩ, ꞌbãkí ũdéŋá rĩ laá sọ̃ndụ́kụ̃ ãnyãpá rĩ pi ní ngá nyazú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ꞌBá kãbĩlõ úcéꞌbá ꞌdĩꞌbée kâ mụụ́ caá mváŋá rĩ ndreé, kộpi ũlũkí tã mãlãyíkã rĩ ní lũú ĩ ní mváŋá rĩ ã tã sĩ rĩ ꞌbá rĩ pi ní céré. ");
INSERT INTO kbo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ꞌBá rĩ pi kâ tã ꞌbá kãbĩlõ úcéꞌbá rĩ pi ní ũlũú ꞌdĩri yịị́, sẽ kộpi ní ãyãngárá. ");
INSERT INTO kbo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ꞌBo Mãríyã ꞌbã tã ꞌdĩꞌbée céré kuú ꞌí ẹ́sị́ agá, ri tã ni ụ̃sụ̃ụ́ ẹ́sị́sị́lé sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ꞌBá kãbĩlõ úcéꞌbá rĩ pi kâ mvií gõó, kộpi rikí dị̃ngárá Múngú vé rĩ íngú, ãꞌdiãtãsĩyã tã kộpi ní ndreé, ãzini kộpi ní yịị́ rĩ nga ꞌi sụ̃ mãlãyíkã rĩ ní lũú ĩ ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mváŋá rĩ kã adrií caá ụ́ꞌdụ́ ãrõ, ĩ ní ágélé ni ẽ tị lịzú, ĩ ní rụ́ ni ꞌdazú Yẹ́sụ̃ ꞌi, rụ́ ꞌdĩri mãlãyíkã lũ nĩ drị̃drị̃, ị́sụ́ ãkũdẽ ẹ́ndrẹ́pị ri drĩ ꞌa ãkó. ");
INSERT INTO kbo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mãríyã pi Yõsépã be, kộpivé ụ́ꞌdụ́ lãꞌbĩ vé ĩfũzú yị̃ị́ agásĩ rĩ kã dẹẹ́, kộpi ní mváŋá rĩ jịzú mụzú iꞌdazú Úpí ẹndrẹtị gé Yẹ̃rụ́sãlémã gá ꞌdãá, sụ̃ tãị́mbị́ Mósẽ vé rĩ ní lẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tãị́mbị́ Úpí vé rĩ ꞌyo kĩnĩ, “Anji ãgõ ĩ ní tịị́ kãyú rĩ pi ãrẽvú céré, ĩ kộpi sẽ Úpí Múngú ní.” ");
INSERT INTO kbo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kúru kộpi ní rọ̃bọ̃ŋọ̃ sẽzú zãzú sụ̃ tãị́mbị́ Úpí vé rĩ ní ꞌyoó, “Ã sẽkí ãmámũ ị̃rị̃, dõku ũꞌbõlõgú ị̃rị̃ rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lókí ꞌdãri gé, ágó ãzi ri adri Yẹ̃rụ́sãlémã gá ꞌdãá, rụ́ ni Sĩmĩyónã ꞌi, ĩri tã ꞌo pịrị, ĩri ri Múngú ri zị ụ́ꞌdụ́ céré, ẹ́pị́ Índrí Uletere Múngú vé rĩ sĩ, ri ꞌbá Ĩsẽrélẽ vé rĩ pi vé pangárá ũtẽé. ");
INSERT INTO kbo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Índrí Uletere rĩ lũ ĩri ní kĩnĩ, ícó drĩ drãá ku, ĩri Kúrísítõ Úpí Múngú ní úmvúlésĩ ĩpẽé rĩ ndre ũgbále, ĩri íbí drã ndõ. ");
INSERT INTO kbo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ụ́ꞌdụ́ ꞌdãri gé, Índrí Uletere rĩ ko Sĩmĩyónã ẽ drị̃ mụzú Jó Múngú vé rĩ ã bóró gá ꞌdãá. Mãríyã pi Yõsépã be, kộpi kâ mváŋá Yẹ́sụ̃ ri jịị́ Úpí vúgá ꞌdãá sụ̃ tãị́mbị́ Mósẽ vé rĩ ní lẽé rĩ tị́nị, ");
INSERT INTO kbo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sĩmĩyónã ní mváŋá rĩ íꞌdụ́zú rụzú ꞌí drị́gé, ĩri ní Múngú ri íngúzú, ĩri ní ꞌyozú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Úpí, ma ãtíꞌbá mívé ni, mî sẽ mâ drã tã be kíri. ꞌÍ ꞌo tã mí ní ẹzịị́ rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Á ndre ꞌbá ãngũ paápi, ");
INSERT INTO kbo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mí ní ĩpẽé ꞌbá céré pi ní rĩ gí. ");
INSERT INTO kbo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ĩri ụ̃tụ́ŋá, ĩri Múngú ri iꞌda ꞌbá adriꞌbá Yãhụ́dị̃ rú ku rĩ pi ní, ĩri sẽ ꞌbá rĩ pi ꞌbá Ĩsẽrélẽ vé rĩ pi íngúngũ!” ");
INSERT INTO kbo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tã Sĩmĩyónã ní ꞌyoó ꞌdĩri sẽ Yõsépã pi Mãríyã be ãyãkí ãní ãyãyã. ");
INSERT INTO kbo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kúru Sĩmĩyónã ní kộpi ní tãkíri sẽzú, ĩri ní ꞌyozú Mãríyã ní kĩnĩ, “Mívé mváŋá ꞌdĩri, ꞌbá ụrụkọ Ĩsẽrélẽ vé rĩ pi ímụ́ ĩri gã sĩ, ĩ ímụ́ kộpi ĩrĩŋã ãní rá, ụrụkọꞌbée ímụ́ ĩrivé tã ãꞌyĩ rá, kộpi ímụ́ ídríngárá ị́sụ́ ãní rá. Kãdõ ímụ́ ꞌi iꞌdaá, ꞌbá rĩ pi ĩri gã sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mvá ꞌdĩri ímụ́ tã ꞌbá rĩ pi ní rií ụ̃sụ̃ụ́ ĩ ẹ́sị́ agá ꞌdãlé rĩ pi iꞌda céré ãmvé. Mãríyã, mî ẹ́sị́ ri ímụ́ ĩzãngã ị́sụ́ sụ̃ sõkí ị́lị́ ãco sĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ũkú ãzi nẹ́bị̃, rụ́ ni Ánã ꞌi, ĩri Pãnũélẽ ã mvá, ĩri Ãsérãzị́, ĩri ãrãkã rú. Kộpi ní ĩ jezú rĩ gé, kộpi adrikí ágó ni be caá ílí ẹ́zị̂rị̃, ágó rĩ ní drãzú. ");
INSERT INTO kbo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ánã adri ọ̃wụ́zị́ rú, ĩrivé ílí ca pụ̃kụ́ ãrõ drị̃ ni sụ, ku Jó Múngú vé rĩ kuyé, ri Múngú ri ị̃njị̃ị́ ụ̃tụ́ŋá pi ị́nị́ŋá be, ri ꞌi aꞌbií ngá nyangárá sĩ, ãzini ri Múngú ri zịị́. ");
INSERT INTO kbo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ánã ní koro ícázú, ị́sụ́ ãkũdẽ Sĩmĩyónã ri átá Mãríyã pi ní Yõsépã be. Ánã ní Múngú ní õwõꞌdĩfô sẽzú, ĩri ní mváŋá rĩ vé tã átázú ꞌbá céré riꞌbá Yẹ̃rụ́sãlémã vé pangárá ũtẽꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yõsépã pi Mãríyã be, kộpi kâ lãꞌbĩ tãị́mbị́ Úpí vé rĩ ní lẽé rĩ ꞌoó dẹẹ́ céré gí, kộpi ní mvizú gõzú ĩvé kụ̃rụ́ Nãzẽrétã vé rĩ gé ãngũ Gãlĩláyã vé rĩ agá ꞌdãlé ũzi. ");
INSERT INTO kbo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mváŋá rĩ mba ícá ũkpõ be, tã nị̃ngárá be, Múngú ꞌbã ẹ́sị́ múké ĩri ní. ");
INSERT INTO kbo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ílí ãlu ãlu, Yẹ́sụ̃ ẹ́tẹ́pị pi ẹ́ndrẹ́pị be, kộpi ri ẹ́cị́ Yẹ̃rụ́sãlémã gá ụ̃mụ̃ Ụ́ꞌdụ́ Múngú ní Ẹlịzú Jó rĩ pi tị gé sĩ rĩ ã nyangárá gá. ");
INSERT INTO kbo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yẹ́sụ̃ kã adrií ílí be mụdrị́ drị̃ ni ị̃rị̃, kộpi ꞌdekí mụụ́ ẹ́tẹ́pị be ẹ́ndrẹ́pị sĩ ụ̃mụ̃ rĩ gé, sụ̃ ĩvé mẽrẽ ní lẽé rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ụ̃mụ̃ rĩ kã dẹẹ́, Yẹ́sụ̃ ẹ́tẹ́pị pi ẹ́ndrẹ́pị be, kộpi kâ rií mvií mụzú ꞌbẹ̃tị́ Nãzẽrétã gá ꞌdãá, Yẹ́sụ̃ áwí kuú vúlé Yẹ̃rụ́sãlémã gá ꞌdãá, ẹ́tẹ́pị pi ẹ́ndrẹ́pị be nị̃kí ámá kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kộpi ụ̃sụ̃kí déna ĩri ꞌbá ĩ ní rií ẹ̃cị̃ tuú kộpi be trụ́ rĩ pi ãsámvú gé, kộpi ẹ́cị́kí ụ̃tụ́ njị̃ị́. Kộpi ní kúru íꞌdózú Yẹ́sụ̃ ri ndãzú ĩvé máríté rĩ pi ãsámvú gé sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kộpi kâ ĩri ị́sụ́ kuyé, kộpi ní gõzú mụzú ĩri ndãzú vúlé Yẹ̃rụ́sãlémã gá ꞌdãlé. ");
INSERT INTO kbo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ụ́ꞌdụ́ na ã vụ́drị̃ gé, kộpi cakí mụụ́ Yẹ́sụ̃ ri ị́sụ́ Jó Múngú vé rĩ ã bóró gá, úrí kuú ꞌbá ãngũ ímbáꞌbá rĩ pi ãsámvú gé, ĩri ri kộpivé tã yị, ãzini ĩri ri kộpi uzị tã sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ꞌBá rĩ pi kâ tã nị̃ngárá ĩri ní átázú, ãzini tã újázú rĩ yịị́, kộpi ãyãkí ãní ãyãyã. ");
INSERT INTO kbo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yẹ́sụ̃ ẹ́tẹ́pị pi ẹ́ndrẹ́pị be, kộpi kâ ĩri ndreé, sẽ kộpi ní ãyãngárá. Ẹ́ndrẹ́pị ní ꞌyozú ĩri ní kĩnĩ, “Mâ mvá rĩ, ꞌbâ mí ẹ́tẹ́pị be, ꞌbá rikí mi ndãá ĩzãngã ĩzãngã rú. ꞌÍ ꞌo ꞌbâ ꞌdíni ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yẹ́sụ̃ ní kộpi zịzú kĩnĩ, “Ngá ĩmi ní rizú ma ndãzú rĩ ãꞌdi? Ĩmi nị̃kí kuyé ꞌyozú kínĩ, lẽ mâ adri má Ẹ́tẹ́pị vé jó agá?” ");
INSERT INTO kbo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ꞌBo tã ĩri ní átá kộpi ní ꞌdĩri fi kộpi drị̃gé kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kúru ĩri ní ꞌdezú mụzú kộpi be trụ́ Nãzẽrétã gá ꞌdãlé, ꞌdụ kộpivé tã ngaá rá. ꞌBo ẹ́ndrẹ́pị ꞌbã tã ĩ ngaꞌbée ꞌdĩꞌbée céré kuú ꞌí ẹ́sị́ agá. ");
INSERT INTO kbo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yẹ́sụ̃ mba tã nị̃ngárá be, ãzini mba rụ́ꞌbá be múké múké. Múngú lẽ ĩri rá, ꞌbá rĩ pi lẽkí kpá ĩri rá. ");
INSERT INTO kbo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ꞌBãgú ãmbúgú Rómã vé Tị̃bẹ́rị̃yã rụ mãlũngã rĩ caá ílí mụdrị́ drị̃ ni tọ̃wụ́, ị́sụ́zú Pónítĩyõ Pĩlátõ ri gávãnã ãngũ Yụ̃dáyã vé rĩ agá, Ẽródẽ rụ ãngũ Gãlĩláyã vé rĩ nĩ. Ẽródẽ ẹ́drị́pị Pĩlípũ rụ ãngũ Ĩtúrĩyã vé rĩ pi Tũrãkõnítĩ vé rĩ be, Lĩsánĩyãsĩ rụ ívé rĩ ãngũ Ãbĩlénẽ vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Lókí ꞌdãri gé, Ãnásĩ pi Kãyáfã be, kộpi atala ambugu, ụ́ꞌdụ́kọ́ Múngú vé rĩ ní ícázú Zãkãríyã mvọ́pị Yũwánĩ vúgá ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yũwánĩ ní mụzú yị̃ị́ Yárídénĩ vé rĩ ẽ mịlé gá sĩ, ri tị sẽé mụzú ꞌbá rĩ pi ní kĩnĩ, ꞌbá rĩ pi ã újákí ẹ́sị́, kộpi ã rụkí bãtízĩmũ, Múngú ã trũ rí kộpi ĩvé ũnjĩkãnyã agásĩ rá. ");
INSERT INTO kbo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tã ꞌdĩri nẹ́bị̃ Ĩsáyã sĩ ọ́tụ́ ị́nọ́gọ́sị́ ívé búkũ agá kĩnĩ, “Ụ́ꞌdụ́kọ́ ꞌbá ãzi vé ni ri ọ́ꞌụ́ ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá, kĩnĩ, ‘Ĩmi údékí lẹ́tị Úpí ní, ĩmi útúkí lẹ́tị ĩrivé rĩ ã adri pịrị. ");
INSERT INTO kbo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ĩmi ọ́tụ́kí ãngũ ị́ꞌbụ́ŋá rú rĩ pi rá, ĩmi udịkí írã rĩ pi, ãzini ĩmi gakí ãngũ ánga rú rĩ pi, ã adri kpãkpã, ĩmi útúkí lẹ́tị gõrõŋõ rú rĩ pi ẽ ícá pịrị, ĩmi ọ́tụ́kí lẹ́tị ꞌbụ́ rú rĩ pi ícá kpãkpã. ");
INSERT INTO kbo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ꞌBá rĩ pi ímụ́ ũkpõ Múngú ní ãngũ pazú rĩ ndre ĩ mị sĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ꞌBá bị́trị́ká ímụ́kí, kộpi lẽkí Yũwánĩ ã sẽ ĩ ní bãtízĩmũ, Yũwánĩ ní ꞌyozú kộpi ní kĩnĩ, “Ĩmi adriꞌbée sụ̃ ị̃nị̃ tị́nị ꞌdĩꞌbée, ãꞌdi ĩmgbẽ ĩmî mị ápázú Múngú vé jĩkó úmvúlésĩ ímụ́pi drị̃drị̃ ꞌdĩlé rĩ gé sĩ nĩ? ");
INSERT INTO kbo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lẽ ĩmi ꞌokí tã lũúpi ꞌyozú kínĩ, ádarú ĩmi újákí ẹ́sị́ ĩmivé ũnjĩkãnyã agásĩ gí ni áyu, lẽ ĩmi rikí ꞌyoó, Ãbũrámã ri ĩmi ẹ́ꞌbị́pị ꞌdíni ku. Á ꞌyo ĩmi ní ꞌdíni, Múngú ri ícó írã anjiŋá ꞌdĩꞌbée újá ufu anjiŋá Ãbũrámã vé ni rú rá. ");
INSERT INTO kbo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Múngú íꞌdụ́ ụ̃bọ́lụ́ pẹtị ã úlá ugazú rĩ ꞌí drị́gé gí, pẹtị ꞌaꞌbée ũꞌa be múké ku rĩ pi ãrẽvú céré ĩ uga vũgá, ĩ kộpi ꞌdụ úꞌbé ãcí agá.” ");
INSERT INTO kbo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ꞌBá bị́trị́ká rĩ pi ní Yũwánĩ ri zịzú kínĩ, “Kúru lẽ ꞌbâ ꞌokí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yũwánĩ ní újázú kộpi ní kĩnĩ, “ꞌBá rĩ dõ bõngó be ị̃rị̃, ã sẽ ãlu ni ꞌbá bõngó ãkó rĩ ní, ꞌbá rĩ dõ ãnyãngã be, ã sẽ ãnyãngã ꞌbá ãnyãngã ãkó rĩ ní.” ");
INSERT INTO kbo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ꞌBá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi ímụ́kí kpá Yũwánĩ vúgá, Yũwánĩ ã sẽ ĩ ní bãtízĩmũ. Kộpi ní ĩri zịzú kínĩ, “Ímbápi, kúru lẽ ꞌbâ ꞌokí ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yũwánĩ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ ĩmi uꞌdụkí mũfẽngã rĩ ꞌbá rĩ pi vúgá sĩ sụ̃ tãị́mbị́ ní lẽé rĩ tị́nị, ã uꞌdụkí ãndõ be ku.” ");
INSERT INTO kbo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ãngáráwá ụrụkọ ímụ́kí kpá Yũwánĩ ri zịị́ kínĩ, “Kúru lẽ ꞌbâ ꞌokí ãꞌdi?” Ĩri ní újázú kộpi ní kĩnĩ, “Ẽ ẹ́rị́kí ꞌbá ãzi ã ngá ũkpõ sĩ ku, ãzini ã tõkí ꞌbá ãzi ũnjõ sĩ ku, lẽ ĩmi adrikí ãyĩkõ sĩ ngá ĩ ní ĩmi ũfẽzú rĩ sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ꞌBá rĩ pi rikí céré ẹ́sị́ ꞌbãá Kúrísítõ ri ũtẽzú, kộpi rikí ụ̃sụ̃ụ́ ĩ ẹ́sị́ agá ꞌdãlé kínĩ, déna Yũwánĩ ri Kúrísítõ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yũwánĩ ní ꞌyozú kộpi ní kĩnĩ, “Ma ri ĩmi ní bãtízĩmũ rĩ sẽ yị̃ị́ sĩ. ꞌBo ꞌbá ãzi ri ímụ́ vúlé ꞌdĩíꞌdĩ, ĩrivé ãmbũgũ ndẽ mávé rĩ rá. Má ícó ĩrivé ngá pá gá rĩ vé bãá ọyụụ́ bã ku. Ĩri ímụ́ ĩmi ní bãtízĩmũ sẽ ũkpõ Índrí Uletere rĩ vé rĩ sĩ, ãzini ãcí sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ĩri kọ́bị be drị́gé ãnyá ụ́ꞌbị́zú ãní, ĩri ãnyá rĩ ụ́ꞌbị́, ĩri ãnyá rĩ vé fí dã ĩrá agá, ĩri ꞌbí ni zã ve ãcí drãápi ku ni sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yũwánĩ ũlũ Múngú vé ụ́ꞌdụ́kọ́ múké rĩ ꞌbá rĩ pi ní lẹ́tị be ãndíãndí. ");
INSERT INTO kbo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ꞌBo Yũwánĩ ní Ẽródẽ ẽ drị̃ ínjázú ĩri ní ẹ́drị́pị Pĩlípũ vé ũkú Ẽrõdíyã ri ꞌdụụ́ ꞌí ní ũkú rú rĩ sĩ, ãzini ĩri ní tã ũnjí ꞌoó tré rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ẽródẽ gõ ũnjĩkãnyã ãzi ꞌoó agaá rá, ꞌdụ Yũwánĩ ri ꞌbeé jó ãngũ ũꞌyĩzú rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sâ Yũwánĩ ní rizú ꞌbá rĩ pi ní bãtízĩmũ sẽzú rĩ gé, sẽ kpá Yẹ́sụ̃ ní bãtízĩmũ ĩndĩ. Yũwánĩ kã rií Múngú ri zịị́, ꞌbụ̃ ní ꞌi zị̃zú, ");
INSERT INTO kbo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Índrí Uletere rĩ ní ísị́zú ímụ́zú sụ̃ ãmámũ tị́nị, úrízú Yẹ́sụ̃ drị̃gé. Kúru ụ́ꞌdụ́kọ́ ní íkụ́zú ꞌbụ̃ gé ꞌdãásĩ kĩnĩ, “Mi Mvá mávé ni, á lẽ mi ambamba, ma ãyĩkõ sĩ mí sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yẹ́sụ̃ kã ívé ẹ̃zị́ íꞌdó, ị́sụ́ ĩrivé ílí ri ílókõ ca pụ̃kụ́ na. ꞌBá rĩ pi céré ụ̃sụ̃kí kínĩ, ĩri Yõsépã ã mvá, Yõsépã ri Hélĩ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hélĩ ri Mãtátã ã mvá, Mãtátã ri Lẹ́vị̃ ã mvá, Lẹ́vị̃ ri Mẽlékĩ ã mvá, Mẽlékĩ ri Yãnáyĩ ã mvá, Yãnáyĩ ri Yõsépã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yõsépã ri Mãtãtíyã ã mvá, Mãtãtíyã ri Ãmósã ã mvá, Ãmósã ri Nãhúmũ ã mvá, Nãhúmũ ri Ẽsélĩ ã mvá, Ẽsélĩ ri Nãgáyĩ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nãgáyĩ ri Mátã ã mvá, Mátã ri Mãtãtíyã ã mvá, Mãtãtíyã ri Sẽmẽyínĩ ã mvá, Sẽmẽyínĩ ri Yõsékẽ ã mvá, Yõsékẽ ri Yódã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yódã ri Yõnánã ã mvá, Yõnánã ri Résã ã mvá, Résã ri Zẽrũbãbélã ã mvá, Zẽrũbãbélã ri Sãlĩtĩyélẽ ã mvá, Sãlĩtĩyélẽ ri Nérĩ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérĩ ri Mẽlékĩ ã mvá, Mẽlékĩ ri Ádĩ ã mvá, Ádĩ ri Kõsámã ã mvá, Kõsámã ri Ẽlẽmãdámã ã mvá, Ẽlẽmãdámã ri Érẽ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Érẽ ri Yósũwã ã mvá, Yósũwã ri Ẽlĩzérẽ ã mvá, Ẽlĩzérẽ ri Yõrímã ã mvá, Yõrímã ri Mãtátã ã mvá, Mãtátã ri Lẹ́vị̃ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lẹ́vị̃ ri Sĩmĩyónã ã mvá, Sĩmĩyónã ri Yụ́dã ã mvá, Yụ́dã ri Yõsépã ã mvá, Yõsépã ri Yõnámũ ã mvá, Yõnámũ ri Ẽlĩyãkímã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ẽlĩyãkímã ri Mẽléyã ã mvá, Mẽléyã ri Ménã ã mvá, Ménã ri Mãtátã ã mvá, Mãtátã ri Nãtánã ã mvá, Nãtánã ri Dãwụ́dị̃ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dãwụ́dị̃ ri Yésẽ ã mvá, Yésẽ ri Õbédẽ ã mvá, Õbédẽ ri Bõójã ã mvá, Bõójã ri Sãlĩmónĩ ã mvá, Sãlĩmónĩ ri Nãsónã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nãsónã ri Ãmĩnãdábã ã mvá, Ãmĩnãdábã ri Ãdĩmínĩ ã mvá, Ãdĩmínĩ ri Ãrínĩ ã mvá, Ãrínĩ ri Ẽzĩrónã ã mvá, Ẽzĩrónã ri Pẽrézĩ ã mvá, Pẽrézĩ ri Yụ́dã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yụ́dã ri Yõkóbũ ã mvá, Yõkóbũ ri Ĩsákã ã mvá, Ĩsákã ri Ãbũrámã ã mvá, Ãbũrámã ri Térã ã mvá, Térã ri Nãhórã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nãhórã ri Sẽrúgã ã mvá, Sẽrúgã ri Réwũ ã mvá, Réwũ ri Pẽlégẽ ã mvá, Pẽlégẽ ri Ẽbérẽ ã mvá, Ẽbérẽ ri Sélã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélã ri Kãyĩnánã ã mvá, Kãyĩnánã ri Ãrĩpãkãsádã ã mvá, Ãrĩpãkãsádã ri Sémẽ ã mvá, Sémẽ ri Núwã ã mvá, Núwã ri Lẽmékẽ ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lẽmékẽ ri Mẽtũsélã ã mvá, Mẽtũsélã ri Ẽnókã ã mvá, Ẽnókã ri Yãrédẽ ã mvá, Yãrédẽ ri Mãhãlãlélĩ ã mvá, Mãhãlãlélĩ ri Kẽnánã ã mvá, ");
INSERT INTO kbo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kẽnánã ri Ẽnósã ã mvá, Ẽnósã ri Sétẽ ã mvá, Sétẽ ri Ãdámã ã mvá, Ãdámã ri, Múngú gbi ĩri nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yẹ́sụ̃ kã ĩfũú yị̃ị́ Yárídénĩ agásĩ, Índrí Uletere rĩ ní ĩri ásúzú, Índrí Uletere rĩ ko ĩri ẽ drị̃ mụzú ãngũ ãꞌwí cínyáfã rú rĩ gé ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ꞌDãlé ãdróko ụ̃ꞌbị̃ Yẹ́sụ̃ ri ụ́ꞌdụ́ pụ̃kụ́ sụ. Ụ́ꞌdụ́ ꞌdĩꞌbée agá, nya ngá ãzi kuyé, ẹ̃bị́rị́ fụ ĩri rá. ");
INSERT INTO kbo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ãdróko rĩ ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Mi dõ Mvá Múngú vé ni, mí újá írã mvá ꞌdĩri ufuú pánga rú.” ");
INSERT INTO kbo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Sĩkí búkũ Múngú vé rĩ agá kínĩ, ‘ꞌBá ícó adrií ídri rú ꞌyéŋá ãnyãngã sĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ãdróko rĩ ní ĩri jịzú tụzú ánga drị̃gé ụrụgégé ꞌdãá, ĩri ní ãngũ vũ drị̃gé rĩ pi iꞌdazú ĩri ní céré. ");
INSERT INTO kbo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ĩri ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ma sẽ mi ãngũ vũ drị̃gé nõꞌbée rụ céré nĩ, ngá ũnyĩ be rĩ pi ãrẽvú céré, ma sẽ mí ní, ãꞌdiãtãsĩyã sẽkí kộpi kú má drị́gé, ma ícó sẽ ꞌbá má ní lẽé rĩ ní rá. ");
INSERT INTO kbo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mí ũtị̃ dõ kũmũcí ma ị̃njị̃zú rá, ma ngá rĩ pi ãrẽvú sẽ céré mí ní.” ");
INSERT INTO kbo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “Sĩkí búkũ Múngú vé rĩ agá kínĩ, ‘Lẽ mî ị̃njị̃ ꞌyéŋá Úpí Múngú mívé rĩ áyu, mî nga ĩri ní ẹ̃zị́.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ãdróko rĩ ní Yẹ́sụ̃ ri jịzú mụzú Yẹ̃rụ́sãlémã gá ꞌdãá, ĩri ní Yẹ́sụ̃ ri jịzú tụzú Jó Múngú vé rĩ drị̃gé ụrụ ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mi dõ Mvá Múngú vé ni, ꞌí wa vũgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ãꞌdiãtãsĩyã sĩkí Búkũ Múngú vé rĩ agá kínĩ, “ ‘Múngú ri ívé mãlãyíkã rĩ pi ĩpẽ ímụ́ mî ĩzã ko rá, ");
INSERT INTO kbo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kộpi mi ko ĩ drị́gé ụrụ ꞌdĩgé, mî sị̃ rí mî pá írã rụ́ꞌbá gá ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yẹ́sụ̃ ní újázú ãdróko rĩ ní kĩnĩ, “Sĩkí búkũ Múngú vé rĩ agá kínĩ, ‘Lẽ mî ụ̃ꞌbị̃ Úpí Múngú mívé rĩ ku.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ãdróko kã Yẹ́sụ̃ ri ụ̃ꞌbị̃ị́ lẹ́tị be ãndíãndí tí, ĩri ní Yẹ́sụ̃ ri kuzú kuú ꞌdãá, ꞌí íbí rí ĩgõó ndõ. ");
INSERT INTO kbo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yẹ́sụ̃ ní ꞌi újázú gõzú ãngũ Gãlĩláyã vé rĩ gé ꞌdãlé, Índrí Uletere rĩ vé ũkpõ ású ĩri rá. Ĩrivé tã ayi mụzú ãngũ rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yẹ́sụ̃ ri ꞌbá rĩ pi ímbá Jó Múngú ri Zịzú rĩ pi agásĩ, ꞌbá rĩ pi ãrẽvú céré íngúkí ĩri rá. ");
INSERT INTO kbo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yẹ́sụ̃ ní ꞌi újázú gõzú vúlé Nãzẽrétã gá, vũrã ĩri ní mbazú rĩ gé ꞌdãá, ụ́ꞌdụ́ Sãbátã vé rĩ gé, ĩri ní ꞌdezú mụzú Jó Múngú ri Zịzú rĩ agá ꞌdãá, sụ̃ ĩri ní rií ꞌoó njị̃ị́ rĩ tị́nị. Ĩri ní ngazú ụrụ sĩ Búkũ Múngú vé rĩ lãzú. ");
INSERT INTO kbo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ĩ ní búkũ nẹ́bị̃ Ĩsáyã vé rĩ íꞌdụ́zú sẽzú drị́ ni gé. Ĩri ní búkũ rĩ zị̃zú, ị́sụ́ vũrã ĩ ní sĩí kínĩ, ");
INSERT INTO kbo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Índrí Uletere Úpí vé rĩ ású ma gí, ãꞌdiãtãsĩyã ĩpẽ ma ímụ́ ụ́ꞌdụ́kọ́ múké rĩ ũlũú ꞌbá ngá ãkó rĩ pi ní. Ĩpẽ ma ímụ́ ꞌbá ĩ ní ũꞌyĩí jó agá rĩ pi vé ọyụngárá ã tã ũlũú, ãzini ꞌbá mị be ẹ̃sị̃ꞌbá gí rĩ pi vé ãngũ ndrengárá ã tã ũlũú, ꞌbá ĩ ní kộpi ẽ drị̃ ọ́rụ́ rĩ pi ẽ ị́sụ́kí rí drị̃wãlã. ");
INSERT INTO kbo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Lókí Úpí ní lẽzú ẹ́sị́ múké ꞌbãzú ꞌbá rĩ pi ní rĩ ícó gí, ĩpẽ ma ímụ́ tã ni ũlũú.” ");
INSERT INTO kbo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yẹ́sụ̃ ní búkũ rĩ ụ̃pị̃zú, ĩri ní sẽzú ꞌbá riípi búkũ rĩ ã tã mbaápi rĩ drị́gé, ĩri ní úrízú vũgá. ꞌBá Jó Múngú ri Zịzú rĩ agá rĩ pi ãrẽvú céré ꞌbãkí mị rizú ĩri ndrezú. ");
INSERT INTO kbo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kúru ĩri ní ꞌyozú ꞌbá rĩ pi ní kĩnĩ, “Búkũ Múngú vé má ní lãá, ĩmi ní yịị́ ãndrũ ꞌdĩri, tã ni nga ꞌi fũú tị ni gé gí.” ");
INSERT INTO kbo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ꞌBá rĩ pi ãrẽvú céré ngakí átá kínĩ, ĩri múké, kộpi ãyãkí tã ĩri ní átá múké ꞌdĩri sĩ rá, kộpi ní rizú ĩ uzịzú ĩ ãsámvú gé sĩ kínĩ, “Mvá ꞌdĩri adri nyo Yõsépã mvọ́pị ꞌi kuyé?” ");
INSERT INTO kbo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ádarú ĩmi ímụ́ átá má ní nãpí sĩ ꞌdíni, ‘Mi riípi ãngũ ídrípi rĩ, mí ídrí mî úlúngu! Tã ꞌbá ní yịị́ mí ní ꞌoó Kãpãrãnãụ́mã gá ꞌdãlé rĩ, lẽ mî ꞌo kpá mívé kụ̃rụ́ agá nõgó.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yẹ́sụ̃ ní gõzú ꞌyozú kĩnĩ, “Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá rĩ dõ nẹ́bị̃, ị̃njị̃kí ĩri ĩrivé kụ̃rụ́ agá ku. ");
INSERT INTO kbo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ádarú á ꞌyo ĩmi ní ꞌdíni, ọ́tụ́ lókí Ẽlíyã rú rĩ pi kárákará ãngũ Ĩsẽrélẽ vé rĩ agá, ílí na ẹ̃lị́ sĩ, yị̃ị́gọ́ ꞌdị kuyé, ẹ̃bị́rị́ ꞌde ũnjí ũnjí ãngũ rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ꞌBo Múngú pẽ nẹ́bị̃ Ẽlíyã ri mụụ́ ọwụzị Ĩsẽrélẽ vé rĩ pi vúgá kuyé, pẽ ĩri mụụ́ ọ̃wụ́zị́gọ́ adriípi kụ̃rụ́ Zãrẽfátã vé rĩ agá rĩ vúgá, ãngũ Sĩdónã vé rĩ agá. ");
INSERT INTO kbo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ọ́tụ́ lókí nẹ́bị̃ Ẽlísã vé rĩ gé, ꞌbá ũfú ní nyaá rĩ pi kárákará ãngũ Ĩsẽrélẽ vé rĩ agá ꞌdãá, ꞌbo ꞌbá ãzi ũfú ní dẹẹ́ rụ́ꞌbá ni gé sĩ ni ꞌdãáyo, ꞌyéŋá ũfú rĩ dẹ Nãmánã Sírĩyãgú rĩ rụ́ꞌbá gá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ꞌBá adriꞌbá Jó Múngú ri Zịzú rĩ agá rĩ pi kâ tã ꞌdĩri yịị́, kộpi ẽ ẹ́sị́ ve ũnjí ũnjí. ");
INSERT INTO kbo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kộpi ní ungazú ụrụ, kộpi ní ĩri zezú mụzú kụ̃rụ́ rĩ agásĩ ãmvé. Kộpi jịkí ĩri mụzú ánga ĩ ní kụ̃rụ́ rĩ sịzú rĩ drị̃gé ꞌdãá, kộpi lẽkí kõdô ĩri zeé ꞌdeé wị̃lị̃wị́lị́ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ꞌBo Yẹ́sụ̃ ní ꞌdezú mụzú ꞌbá bị́trị́ká rĩ pi ãsámvú gé sĩ ꞌdĩísĩ rá, ĩri ní kộpi kuzú. ");
INSERT INTO kbo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kúru Yẹ́sụ̃ ní ꞌdezú mụzú kụ̃rụ́ Kãpãrãnãụ́mã vé rĩ gé, ãngũ Gãlĩláyã vé rĩ agá, ri ꞌbá rĩ pi ímbá ụ́ꞌdụ́ Sãbátã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ꞌBá rĩ pi ãyãkí tã ĩri ní ímbá rĩ sĩ rá, ãꞌdiãtãsĩyã tã ĩri ní átá rĩ ũkpõ be. ");
INSERT INTO kbo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ụ́ꞌdụ́ ãlu, Yẹ́sụ̃ kã adrií Jó Múngú ri Zịzú rĩ agá ꞌdãá, ágó ãzi índrí ũnjí ní fií drị̃ ni gé ni kpá ꞌdãáꞌdã, ágó rĩ ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Á! Yẹ́sụ̃ Nãzẽrétãgú rĩ, ngá mí ní lẽé ꞌbá vúgá rĩ ãꞌdi? Mí ímụ́ ꞌdĩri ꞌbâ ꞌdịị́? Á nị̃ mi rá! Mi ꞌBá Uletere Múngú vé ni.” ");
INSERT INTO kbo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yẹ́sụ̃ ní trezú índrí ũnjí rĩ drị̃gé kĩnĩ, “Mí újí kíri. ꞌÍ fũ ágó ꞌdĩri drị̃gé sĩ!” Índrí ũnjí rĩ ní ágó rĩ ꞌdụzú aꞌbezú vũgá ꞌbá rĩ pi andregá ꞌdĩgé, ĩri ní ngazú kpuzú mụzú, ꞌo ágó rĩ ũnjí kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ꞌBá rĩ pi céré ãyãkí tã ꞌdĩri sĩ ãyãyã, kộpi rikí ĩ uzịị́ ĩ ãsámvú gé sĩ kínĩ, “Tã ágó ꞌdĩri ní átá ꞌdĩri íngóni? Ĩri ri átá ũkpõ be, ĩri ri ꞌyo índrí ũnjí rĩ pi ní, kộpi ã fũkí ãmvé ꞌbá rĩ pi drị̃gé sĩ, kộpi nga fũ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yẹ́sụ̃ vé tã ayi mụzú ãngũ ꞌdãri agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yẹ́sụ̃ ní fũzú Jó Múngú ri Zịzú rĩ agásĩ, ĩri ní ꞌdezú mụzú Sị̃mọ́nã vé ãngá. Ca mụụ́ ị́sụ́ Sị̃mọ́nã ị̃drẹ́pị ri drã rú, rụ́ꞌbá ni ko gbírílílí. ꞌBá ãlu ãlu ní Yẹ́sụ̃ ri mãzú kínĩ, “Mí ídrí ꞌbá ní ũkú nõri fô!” ");
INSERT INTO kbo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yẹ́sụ̃ ní ꞌi útrúzú ĩnyiŋáŋá ũkú rĩ vé gbọ́lọ́ gãrã gá ꞌdãá. Ĩri ní ꞌyozú kĩnĩ, drã rĩ ã nga ũkú rĩ drị̃gé sĩ. Drã rĩ ní dẹzú ũkú rĩ rụ́ꞌbá gá sĩ, koro ĩri ní íngázú ụrụ, ĩri ní ínyá áꞌdízú sẽzú kộpi ní. ");
INSERT INTO kbo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ụ̃tụ́ rĩ kã ꞌdeé, ꞌbá rĩ pi ní ĩvé ꞌbá drã be ãndíãndí rĩ pi íjị́zú Yẹ́sụ̃ vúgá nõó, ĩri ní drị́ ꞌbãzú ꞌbá drã be ꞌdĩꞌbée drị̃gé sĩ ãlu ãlu céré, ĩri ní kộpi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Índrí ũnjí rĩ pi ní úkpúzú ꞌbá kárákará rĩ pi drị̃gé sĩ, rikí útré ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kínĩ, “Mi Mvá Múngú vé ni!” ꞌBo Yẹ́sụ̃ ní trezú kộpi drị̃gé kĩnĩ, lẽ kộpi ã újíkí kíri, ãꞌdiãtãsĩyã kộpi nị̃kí rá ꞌyozú kínĩ, ĩri Kúrísítõ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ãngũ rĩ kã ọ́wụ́, Yẹ́sụ̃ ní fũzú mụzú vũrã ꞌbá ãkó ni gé. ꞌBá rĩ pi ní ꞌdezú rizú ĩri ndãzú. Kộpi kâ ĩri ị́sụ́, kộpi lẽkí kõdô ĩri ugaá ã mụ ílélé ku. ");
INSERT INTO kbo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ꞌBo Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Lẽ mâ ũlũ kpá ụ́ꞌdụ́kọ́ múké mãlũngã Múngú vé rĩ ã tã mụzú kụ̃rụ́ ụrụkọꞌbée agásĩ ĩndĩ, ãꞌdiãtãsĩyã ĩpẽkí ma ẹ̃zị́ ꞌdĩri ngaá.” ");
INSERT INTO kbo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kúru Yẹ́sụ̃ ní ẹ́cị́zú ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũzú mụzú Jó Múngú ri Zịzú rĩ pi agásĩ, ãngũ Yụ̃dáyã vé rĩ agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ụ́ꞌdụ́ ãlu, Yẹ́sụ̃ kã rií tị Múngú vé rĩ ũlũú yị̃ị́ bãlãlã Gẽnẽsãrétã vé rĩ tị gé ꞌdãá, ꞌbá bị́trị́ká trakí ĩri ã gãrã kụ́rụ̃, rikí tị Múngú vé rĩ yịị́. ");
INSERT INTO kbo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yẹ́sụ̃ ní kũlúmgba ị̃rị̃ ndrezú yị̃ị́ bãlãlã rĩ tị gé ꞌdãá, ꞌbá ị̃ꞌbị́ ꞌbeꞌbá rĩ pi kukí kũlúmgba rĩ pi kú nĩ, kộpi ri ĩvé ímbá ũjĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yẹ́sụ̃ ní tụzú fizú kũlúmgba Sị̃mọ́nã vé rĩ agá. Ĩri ní ꞌyozú Sị̃mọ́nã ní ã ze kũlúmgba rĩ fizú yị̃ị́ agálé rú mãdã. Ĩri ní kúru úrízú kũlúmgba rĩ agá ꞌdãá, ĩri ní ꞌbá bị́trị́ká rĩ pi ímbázú. ");
INSERT INTO kbo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yẹ́sụ̃ kã átángá rĩ átá dẹẹ́, ĩri ní ꞌyozú Sị̃mọ́nã ní kĩnĩ, “Mí útrú kũlúmgba rĩ mụzú yị̃ị́ kụụ́pi kụkụ rĩ agá ꞌdãá, ꞌí ꞌbe ímbá rĩ ꞌdeé ẹ́lị́ agá ꞌdãá, mi ị̃ꞌbị́ urụ kárákará.” ");
INSERT INTO kbo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sị̃mọ́nã ní újázú kĩnĩ, “Ãmbúgú mávé rĩ, ꞌbá ụ̃ꞌbị̃kí kõdô ị̃ꞌbị́ rĩ ꞌbeé ị́nị́ be rã, ꞌbo ꞌbá rụkí ị̃ꞌbị́ ãluŋáni kuyé. ꞌBo ꞌí ꞌyo dõ ꞌdíni, ma ícó ụ̃ꞌbị̃ dị̃ị́ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kộpi kâ ĩvé ímbá rĩ pi ꞌbeé yị̃ị́ agá ꞌdãá, kộpi urụkí ị̃ꞌbị́ kárákará, sẽ ímbá rĩ pi lẽkí uceé ãní ucece. ");
INSERT INTO kbo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kộpi ní ĩ ọ̃gụ̃pị́ị kũlúmgba be rĩ pi ọ́gụ́zú ímụ́zú ĩ ĩzã kozú. Ọ̃gụ̃pị́ị kâ ícá, kộpi uꞌdụkí ị̃ꞌbị́ rĩ pi ũꞌbãá kũlúmgba ị̃rị̃ ni pi agá tré tré, kũlúmgba rĩ pi íꞌdókí rií tĩí yị̃ị́ ã ndụ́gé. ");
INSERT INTO kbo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sị̃mọ́nã Pétẽró kã tã ꞌdĩri ndreé ꞌdíni, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní ꞌyozú kĩnĩ, “Úpí, ꞌí mụ mâ jẽlé gá ꞌdĩísĩ rá, mávé ũnjĩkãnyã ambamba.” ");
INSERT INTO kbo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sị̃mọ́nã Pétẽró pi ꞌbá adriꞌbée ĩri be trụ́ rĩ pi be céré ãyãkí tã kộpi ní ị̃ꞌbị́ urụzú ꞌdĩri sĩ ãyãyã. ");
INSERT INTO kbo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ĩri ọ̃gụ̃pị́ị Zẽbẽdáyõ ẹnjịpị́ị Yõkóbũ pi Yũwánĩ be, ãyãkí kpá tã ꞌdĩri sĩ ãyãyã. Yẹ́sụ̃ ní ꞌyozú Sị̃mọ́nã ní kĩnĩ, “Mí adri ụ̃rị̃ sĩ ku. Íꞌdózú ãndrũ mụzú drị̃drị̃, ĩmi ímụ́ ꞌbá ísé íjị́ má ní, sụ̃ ĩmi ní ị̃ꞌbị́ ꞌbeé rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kúru kộpi ní ĩvé kũlúmgba rĩ pi jịzú mụzú yị̃ị́ tị gé ꞌdãá, kộpi kukí ĩvé ngá rĩ pi ãrẽvú céré kú ꞌdĩgé, kộpi ꞌdekí mụụ́ Yẹ́sụ̃ vú sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yẹ́sụ̃ kã rií adrií kụ̃rụ́ ãzi agá ꞌdãá, ágó ãzi ũfú ní nyaá ni kã Yẹ́sụ̃ ri ndreé, ĩri ní kũmũcí ũtị̃zú, ꞌî drị̃ sị̃zú vũgá Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, “Úpí, ícó dõ rá, mî sẽ ũfú nõri ã dẹ mâ rụ́ꞌbá gá sĩ, mâ rụ́ꞌbá ẽ ícá rí ule.” ");
INSERT INTO kbo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yẹ́sụ̃ ní ꞌî drị́ suzú ágó rĩ úlózú, ĩri ní ꞌyozú kĩnĩ, “Á lẽ mi ídrí rá. Ũfú ꞌdĩri ã dẹ mî rụ́ꞌbá gá sĩ rá!” Koro ũfú rĩ ní dẹzú ágó rĩ ã rụ́ꞌbá gá sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “Lẽ mî lũ tã ꞌdĩri ꞌbá ãzi ní ku, ꞌí mụ mi iꞌdaá átálágú rĩ ẹndrẹtị gé, ꞌí sẽ ngá ĩ ní zãá rọ̃bọ̃ŋọ̃ rú ni pi sụ̃ tãị́mbị́ Mósẽ vé rĩ ní ꞌyoó rĩ tị́nị, ꞌbá rĩ pi ã nị̃kí rí ꞌyozú kínĩ, ũfú rĩ dẹ mî rụ́ꞌbá gá sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kúru Yẹ́sụ̃ vé tã ní ayizú mụzú ãngũ rĩ pi agásĩ, ꞌbá bị́trị́ká ímụ́kí tã ĩri ní rií ímbá rĩ yịị́, ãzini ẽ ídrí rí ĩ ĩvé drã agásĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ꞌBo Yẹ́sụ̃ ri ꞌi ẹndịị́ mụụ́ vũrã ꞌbá ãkó ni gé Múngú ri zịị́. ");
INSERT INTO kbo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ụ́ꞌdụ́ ãlu, Yẹ́sụ̃ kã rií ꞌbá rĩ pi ímbá, Fãrụ́sị̃ rĩ pi, ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, ímụ́kí gụ́rụ́ ãndíãndí ãngũ Gãlĩláyã vé rĩ agá rĩ pi agásĩ, ãzini gụ́rụ́ ãndíãndí ãngũ Yụ̃dáyã vé rĩ agá rĩ pi agásĩ, ụrụkọꞌbée íngákí kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ agá, kộpi rikí tã Yẹ́sụ̃ ní ímbá rĩ yịị́. Úpí sẽ Yẹ́sụ̃ ní ũkpõ ꞌbá drã be rĩ pi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ãgõ ụrụkọꞌbée íꞌdụ́kí ágó pá be ꞌbẽléꞌbéle ni ímụ́zú pọ́rọ̃sị̃ sĩ. Kộpi ụ̃ꞌbị̃kí kõdô ũkpõ sĩ, lẽkí ágó rĩ jịị́ mụụ́ ꞌbãá Yẹ́sụ̃ ẹndrẹtị gé jó agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ꞌBá rĩ pi ní adrií bị́trị́ká rĩ sĩ, kộpi ndãkí ũꞌdũ tí, kộpi ní tụzú jó rĩ drị̃gé ꞌdãá, kộpi ní jó rĩ ẽ drị̃ ĩŋãnyãzú, kộpi ní ágó rĩ ísúzú ímụ́zú ĩrivé pọ́rọ̃sị̃ rĩ be vũgá Yẹ́sụ̃ ẹndrẹtị gé ꞌbá bị́trị́ká rĩ pi ãsámvú gé nõó. ");
INSERT INTO kbo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yẹ́sụ̃ kã ꞌbá ꞌdĩꞌbée vé ẹ̃ꞌyị̃ngárá ndreé, ĩri ní ꞌyozú ágó pá be ꞌbẽléꞌbéle rĩ ní kĩnĩ, “Má ũndĩgó, á trũ mi mívé ũnjĩkãnyã agásĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fãrụ́sị̃ rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, rikí ụ̃sụ̃ụ́ ĩ ẹ́sị́ agá ꞌdãlé kínĩ, “ꞌBá ꞌdĩri ãꞌdi ꞌi Múngú ri ị̃njị̃ị́pi ku ꞌdĩri? Ãꞌdi ri ícó ꞌbá trũ ũnjĩkãnyã agásĩ nĩ? Adri ꞌyéŋá Múngú ri ꞌbá trũ ũnjĩkãnyã agásĩ nĩ kuyé?” ");
INSERT INTO kbo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ rĩ rá, ĩri ní kộpi zịzú kĩnĩ, “Ngá ĩmi ní rizú tã ụ̃sụ̃zú ĩmî ẹ́sị́ agá ꞌdíni rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tã adriípi mũnyámúnya rĩ íngõri? Mâ ꞌyo rí, ‘Trũkí mi mívé ũnjĩkãnyã agásĩ gí’ ꞌdíni? Dõku mâ ꞌyo, ‘ꞌÍ nga ụrụ ẹ̃cị̃ tuú’? ");
INSERT INTO kbo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ꞌBo á lẽ lũú ĩmi ní ꞌyozú kínĩ, ma ꞌBá Mvá ꞌi, ma ũkpõ be ũnjĩkãnyã trũzú vũ drị̃gé nõgó.” Ĩri ní ꞌyozú ágó pá be ꞌbẽléꞌbéle rĩ ní kĩnĩ, “ꞌÍ nga ụrụ, ꞌí ꞌdụ mívé pọ́rọ̃sị̃, ꞌí mvi ꞌbẹ̃tị́.” ");
INSERT INTO kbo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Koro ágó rĩ ní íngázú kộpi ẹndrẹtị gé ꞌdĩgé, ĩri ní ívé pọ́rọ̃sị̃ ꞌdụzú, ĩri ní ꞌdezú mụzú, ri Múngú ri íngú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ꞌBá rĩ pi ãrẽvú céré ãyãkí tã ꞌdĩri sĩ ãyãyã, kộpi íngúkí Múngú ri rá. Ụ̃rị̃ ị́mvụ́ kộpi rá, kộpi ní ꞌyozú kínĩ, “ꞌBá ndrekí tã ãyãzú ãyãyã ni ãndrũ gí.” ");
INSERT INTO kbo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tã ꞌdĩri ã vụ́drị̃ gé, Yẹ́sụ̃ ní fũzú kụ̃rụ́ rĩ agásĩ, ĩri ní ágó ãzi mũfẽngã umbe jezú rĩ uꞌdụụ́pi ni ndrezú, rụ́ ni Lẹ́vị̃ ꞌi, úrí kuú ívé jó rizú mũfẽngã umbe jezú rĩ uꞌdụzú ꞌbãgú ãmbúgú Rómã vé rĩ ní rĩ agá. Yẹ́sụ̃ ní ꞌyozú ĩri ní kínĩ, “Mí ímụ́ mâ pámvú ũbĩí.” ");
INSERT INTO kbo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lẹ́vị̃ ní ngá rĩ pi ãrẽvú kuzú céré, ĩri ní Yẹ́sụ̃ ã pámvú ũbĩzú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kúru Lẹ́vị̃ ní ụ̃mụ̃ údézú ãmbúgú ívé ãngá ꞌdãá, ĩri ní Yẹ́sụ̃ ri zịzú ụ̃mụ̃ rĩ gé, zị ꞌbá kárákará mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi ꞌbá ụrụkọꞌbée be ụ̃mụ̃ rĩ gé ꞌdãá ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ꞌBo Fãrụ́sị̃ rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, rikí unuú ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní kínĩ, “Ngá ĩmi ní rizú ngá nyazú, ãzini ngá mvụzú ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi be, ãzini ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi be trụ́ rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá drã ãkó rĩ ndã ꞌbá ũjó sẽépi ni ku, ꞌbá drã be rĩ, ĩri ꞌbá ũjó sẽépi rĩ ndã nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Má ímụ́ ꞌbá tã ꞌoꞌbá pịrị rĩ pi zịị́ ẹ́sị́ újá kuyé, ꞌbo má ímụ́ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi zịị́, kộpi ã újákí ẹ́sị́.” ");
INSERT INTO kbo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Yũwánĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ri ĩ aꞌbi ngá nyangárá sĩ rá, kộpi ri Múngú ri zị rá, ãzini ꞌbá Fãrụ́sị̃ rĩ pi vé tã ꞌdụꞌbá ngaꞌbá rĩ pi kpá ri ꞌo ꞌdíni rá pírí, ꞌbo mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi ri ngá nya rá, ãzini ngá mvụ rá ãsĩ?” ");
INSERT INTO kbo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Kẹ̃rẹ́gú ọ̃mụ́rụ́gọ́ rĩ vé rĩ dõ drĩ ụ̃mụ́ ímụ́ꞌbá ọ̃mụ́rụ́gọ́ rĩ jengárá gá rĩ pi ãsámvú gé anigé, ĩmi ícó ꞌyo kẹ̃rẹ́gú rĩ vé ụ̃mụ́ rĩ pi ã aꞌbikí ĩ ngá nyangárá sĩ ꞌdíni rá? ");
INSERT INTO kbo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ꞌBo sâ ãzi ri ímụ́ ꞌdĩíꞌdĩ, kádõ ímụ́ ọ̃mụ́rụ́gọ́ rĩ vé kẹ̃rẹ́gú ꞌdụụ́ kộpi ãsámvú gé sĩ, kúru ụ́ꞌdụ́ ꞌdãri gé, kộpi ímụ́ ĩ aꞌbi ngá nyangárá sĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kúru Yẹ́sụ̃ ní nãpí ãzi ũlũzú kộpi ní kĩnĩ, “ꞌBá ãzi ícó bõngó úꞌdí ni ĩsĩí bõngó dẽépi gí ni vé úlẽ ící ọ̃zụ̃ụ́ ãní ku. ꞌO dõ ꞌdíni, ĩri sẽ bõngó úꞌdí rĩ ãsĩ rá, bõngó úꞌdí rĩ pi úmúkí ĩ bõngó ụ̃kụ rĩ be ku. ");
INSERT INTO kbo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ꞌBá ãzi ícó vị́nyọ̃ ĩ ní zoó úꞌdí rú ni tõó lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá ku. ꞌBá rĩ tõ dõ vị́nyọ̃ rĩ lãꞌbú ĩ ní ící jũrú rú ụ̃kụ ni agá, jũrú rĩ ãfĩ rá, ĩri sẽ vị́nyọ̃ rĩ dã vũgá, jũrú rĩ gõ ábá rá. ");
INSERT INTO kbo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lẽ vị́nyọ̃ úꞌdí rĩ, ã dãkí jũrú úꞌdí agá. ");
INSERT INTO kbo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ꞌBá rĩ mvụ dõ vị́nyọ̃ draápi dradra rĩ gí, ícó vị́nyọ̃ úꞌdí rú draápi ku rĩ mvụụ́ ku, ĩri ꞌyo, ‘Vị́nyọ̃ draápi dradra rĩ múké nĩ.’ ” ");
INSERT INTO kbo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ụ́ꞌdụ́ ãlu Sãbátã sĩ, Yẹ́sụ̃ pi rikí ẹlịị́ mụzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be ọ́mvụ́ ãnyá vé ni agásĩ, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ã ụrụkọ ní ãnyá rĩ pi ẽ drị̃ ucezú anyizú cizú. ");
INSERT INTO kbo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fãrụ́sị̃ rĩ pi ní Yẹ́sụ̃ ri zịzú kínĩ, “ꞌBávé tãị́mbị́ kĩnĩ, ã ngakí ẹ̃zị́ ụ́ꞌdụ́ Sãbátã vé rĩ gé ku pírí, ngá ĩmi ní tãị́mbị́ rĩ ŋõzú, ãnyá ẽ drị̃ ucezú anyizú cizú ụ́ꞌdụ́ Sãbátã vé rĩ gé rĩ ãꞌdi?” ");
INSERT INTO kbo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yẹ́sụ̃ ní újázú kộpi ní kĩnĩ, “Ĩmi lãkí tã ꞌbãgú Dãwụ́dị̃ ní ꞌoó ívé ꞌbá rĩ pi be sâ ẹ̃bị́rị́ ní kộpi fụzú rĩ gé rĩ kuyé? ");
INSERT INTO kbo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ꞌBãgú Dãwụ́dị̃ nga fií Jó Múngú vé rĩ agá ꞌdãá, íꞌdụ́ pánga ĩ ní údé ꞌbãá kuú Múngú ẹndrẹtị gé tã be uletere ꞌyéŋá atala rĩ pi ní rií nyaá nĩ rĩ nyaá, sẽ ụrụkọ ni nyaá ívé ꞌbá rĩ pi ní.” ");
INSERT INTO kbo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yẹ́sụ̃ ní kúru ꞌyozú kộpi ní kĩnĩ, “Ma ꞌBá Mvá ꞌi, ma Úpí ụ́ꞌdụ́ Sãbátã vé rĩ drị̃gé ãmbúgú nĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ụ́ꞌdụ́ Sãbátã vé rĩ ãzi gé, Yẹ́sụ̃ ní mụzú fizú Jó Múngú ri Zịzú rĩ agá ꞌdãá, ĩri ní rizú ꞌbá rĩ pi ímbázú, ị́sụ́ ágó ãzi drị́ ẹ̃ndẹ́pị be ꞌbẽléꞌbéle ni jó rĩ agá ꞌdãáꞌdã. ");
INSERT INTO kbo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fãrụ́sị̃ rĩ pi ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be, rikí lẹ́tị ndãá, ĩ tõkí rí Yẹ́sụ̃ ri ãní bẽnĩ, kộpi tẽkí nyo rií Yẹ́sụ̃ ri ndreé, dõ tãnâ ĩri ágó ꞌdĩri ídrí ụ́ꞌdụ́ Sãbátã vé rĩ gé rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ꞌBo Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ rĩ rá, ĩri ní ꞌyozú ágó drị́ be ꞌbẽléꞌbéle rĩ ní kĩnĩ, “ꞌÍ nga ụrụ, mí ímụ́ pá tuú ꞌbá rĩ pi ẹndrẹtị gé ꞌdĩgé.” Ágó rĩ ní íngázú ímụ́zú. ");
INSERT INTO kbo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yẹ́sụ̃ ní kúru ꞌyozú Fãrụ́sị̃ rĩ pi ní ꞌbá tãị́mbị́ ímbáꞌbá rĩ be kĩnĩ, “Á lẽ drĩ ĩmi zịị́, ngá ĩ ní lẽé ã ꞌokí ụ́ꞌdụ́ Sãbátã vé rĩ gé rĩ ãꞌdi? Ã ꞌokí tã múké yã, dõku ã ꞌokí tã ũnjí? Ẽ ídríkí ꞌbá rĩ pi yã, dõku ã úꞌdị́kí ꞌbá rĩ pi?” ");
INSERT INTO kbo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yẹ́sụ̃ ní ꞌbá rĩ pi úndrézú ꞌí gãrã gá sĩ kụ́rụ̃, ĩri ní ꞌyozú ágó rĩ ní kĩnĩ, “Mí ũjũ mî drị́.” Ágó rĩ ní ꞌî drị́ ũjũzú. Ágó rĩ ẽ drị́ gõ ícá múké. ");
INSERT INTO kbo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ꞌBo ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi Fãrụ́sị̃ rĩ pi be, kộpi ã ꞌa ve Yẹ́sụ̃ ní ũnjí ũnjí. Kộpi ꞌbãkí rií Yẹ́sụ̃ ã tã lií, lẽzú ĩri ꞌdịzú drãzú ꞌdĩísĩ rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ụ́ꞌdụ́ ãzi sĩ, Yẹ́sụ̃ nga tụụ́ mụụ́ írã drị̃gé Múngú ri zịị́, zị Múngú ri ꞌdãlé ị́nị́ be rã. ");
INSERT INTO kbo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ãngũ rĩ kã ọ́wụ́, ĩri ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú ímụ́zú ꞌí vúgá nõlé, ũpẽ ꞌbá mụdrị́ drị̃ ni ị̃rị̃ adrií ívé ꞌbá áyúãyũ ni pi rú. ");
INSERT INTO kbo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ꞌBá ĩri ní ũpẽé rĩ pi ã rụ́ ꞌdĩ, Sị̃mọ́nã (ĩri ní zịị́ Pétẽró rĩ ꞌi), ẹ́drị́pị Ãndẽréyã ꞌi, Yũwánĩ ꞌi, Yũwánĩ ẹ́drị́pị Yõkóbũ ꞌi, Pĩlípũ ꞌi, Bãtĩlĩmáyõ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mãtáyo ꞌi, Tómã ꞌi, Yõkóbũ Ãlãfáyõ mvọ́pị ꞌi, Sị̃mọ́nã úvá ꞌbãápi ꞌbá ívé rĩ pi ẽ ị́sụ́kí rí drị̃wãlã rĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yụ́dã Yõkóbũ mvọ́pị ꞌi, ãzini Yụ́dã Ĩsĩkãrĩyótã gõópi Yẹ́sụ̃ ã ũli ꞌbeépi rĩ ꞌi. ");
INSERT INTO kbo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi kâ ísị́ ímụ́zú írã drị̃gé ꞌdãásĩ, kộpi ímụ́kí áwí adrií kuú ãngũ kpãkpã ni gé. Ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ã ụrụkọ kárákará tukí pá kuú ꞌdãá. Ãzini ꞌbá bị́trị́ká íngáꞌbá ãngũ Yụ̃dáyã vé rĩ gé, kụ̃rụ́ Yẹ̃rụ́sãlémã vé rĩ gé, kụ̃rụ́ Táyã vé rĩ gé, ãzini kụ̃rụ́ Sĩdónã vé rĩ gé rĩ pi be úmúkí ĩ céré kuú ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kộpi ímụ́kí tã Yẹ́sụ̃ tị gé rĩ yịị́, kộpi lẽkí Yẹ́sụ̃ ẽ ídrí ĩ. ꞌBá riꞌbá ĩzãngã nyaꞌbá índrí ũnjí rĩ pi drị́gé rĩ pi, Yẹ́sụ̃ ídrí kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ꞌBá ãlu ãlu lẽ Yẹ́sụ̃ ã rụ́ꞌbá úló, ãꞌdiãtãsĩyã ũkpõ ꞌbá ídrízú rĩ íbí ĩfũú rụ́ꞌbá ni gélésĩ, ídrí ꞌbá rĩ pi ãrẽvú céré. ");
INSERT INTO kbo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yẹ́sụ̃ ní ꞌi újázú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ndrezú, ĩri ní ꞌyozú kĩnĩ, “Ĩmi ꞌbá ngá ãkó rĩ pi, ĩmi ímụ́ tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã mãlũngã Múngú vé rĩ ímụ́ adri ĩmivé ni. ");
INSERT INTO kbo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ĩmi ꞌbá ẹ̃bị́rị́ ní rií fụụ́ rĩ pi, ĩmi ímụ́ tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã ĩmi ímụ́ ngá ị́sụ́ ẹ́pị́zú ãní rá. Ĩmi ꞌbá riꞌbá ãá ngoꞌbée rĩ pi, ĩmi ímụ́ tãkíri ị́sụ́ rá, ãꞌdiãtãsĩyã ĩmi ímụ́ ọ̃gụ́ngárá gụ rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ꞌBá rĩ pi ndrekí dõ ĩmi ũnjí, kộpi gãkí dõ ĩmi sĩ, kộpi dõ ri ĩmi uꞌda, kộpi dõ ri ĩmi rụ́ ꞌyo ũnjí ꞌBá Mvá vé tã sĩ, ĩmi ímụ́ tãkíri ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ọ́tụ́ kộpivé ẹ́tẹ́pị́ị ꞌokí nyo nẹ́bị̃ rĩ pi ꞌdíni. Kúru tã ꞌdĩꞌbée kãdõ ímụ́ ĩ ꞌoó, lẽ ĩmi adrikí ãyĩkõ sĩ, ãꞌdiãtãsĩyã Múngú ri ímụ́ ĩmi ũfẽ ꞌbụ̃ gé ꞌdãlé rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ꞌBo ĩzãngã rĩ úmvúlésĩ ímụ́ adri ĩmivé ni, ĩmi adriꞌbá ãꞌbú be ambamba ꞌdĩꞌbée, ãꞌdiãtãsĩyã ĩmi ị́sụ́kí ãyĩkõ nyọ̃ọ́kụ́ drị̃gé nõgó gí. ");
INSERT INTO kbo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ĩzãngã rĩ úmvúlésĩ ímụ́ adri ĩmivé ni, ĩmi ꞌbá adriꞌbée ãnyãngã be kárákará ꞌdĩꞌbée, ãꞌdiãtãsĩyã ĩmi úmvúlésĩ ímụ́ adri ẹ̃bị́rị́ sĩ. Ĩzãngã rĩ úmvúlésĩ ímụ́ adri ĩmivé ni, ĩmi riꞌbá ọ̃gụ́ngárá gụꞌbá ꞌdĩꞌbée, ãꞌdiãtãsĩyã ĩmi úmvúlésĩ ímụ́ ĩzãngã ị́sụ́, ãzini ĩmi ãá ngo. ");
INSERT INTO kbo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ĩzãngã rĩ úmvúlésĩ ímụ́ adri ĩmivé ni, ĩmi ꞌbá ĩ ní rií íngúngũ ꞌdĩꞌbée, ãꞌdiãtãsĩyã ĩmi ẹ́ꞌbị́pị́ị rikí nyo ọ́tụ́ nẹ́bị̃ ũnjó rú rĩ pi íngú ꞌdĩri tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ꞌBo ĩmi riꞌbá ma yịꞌbá ꞌdĩꞌbée, á lẽ ꞌyoó ĩmi ní ꞌdíni, lẽ ĩmi lẽkí ĩmivé ariꞌba rĩ pi lẽlẽ, lẽ ĩmi ꞌokí tã múké ꞌbá ĩmi ndreꞌbá ũnjí rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ĩmi zịkí Múngú ri, ã sẽ rí tãkíri ꞌbá ĩmi wãꞌbá rĩ pi ní, ãzini ꞌbá ĩmi ꞌoꞌbá ũnjí rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ꞌBá ãzi sa dõ mî gbángírí, mí újá ĩri ní ãzi rĩ, ã sa. ꞌBá ãzi ꞌdụ dõ mívé bõngó akoóko rĩ, ꞌí sẽ ĩri ní mívé bõngó ágá vé rĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ꞌBá ãzi zị dõ ngá mí vúgá, ꞌí sẽ ĩri ní ngá ĩri ní zịị́ rĩ. ꞌBá ãzi ꞌdụ dõ ngá mívé ni, lẽ mî zị gõó vúlé ku. ");
INSERT INTO kbo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lẽ ĩmi ꞌokí tã múké ꞌbá ụrụkọꞌbée ní, sụ̃ ĩmi ní lẽé kộpi ã ꞌokí ĩmi ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ĩmi lẽkí dõ ꞌyéŋá ꞌbá ĩmi lẽꞌbá rĩ pi áyu, Múngú ri nyo ícó ĩmi ní tãkíri sẽ rá? Ị́sụ́zú ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi lẽkí kpá ꞌbá ĩ lẽꞌbá rĩ pi ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ĩmi ꞌokí dõ tã múké rĩ ꞌyéŋá ꞌbá ĩmi ꞌoꞌbá múké rĩ pi ní, ĩmi tãkíri ị́sụ́ íngóni? Ị́sụ́zú ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi ri ẹ́sị́ múké ꞌbã ꞌbá ĩ ꞌoꞌbá múké rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ĩmi dõ ꞌyéŋá ri ngá sẽ mẹ̃rị́ rú ꞌbá ícóꞌbá mẹ̃rị́ rĩ ũfẽꞌbá rá rĩ pi ní, ngá múké ĩmi ní ị́sụ́ ꞌa ni gé ꞌdĩgé rĩ ãꞌdi? ꞌBá ũnjĩkãnyã ꞌoꞌbá rĩ pi kpá ri ngá sẽ ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi ní mẹ̃rị́ rú ĩndĩ, ãꞌdiãtãsĩyã kộpi ụ̃sụ̃kí kínĩ, ngá ĩ ní sẽé rĩ, ĩ ícó ũfẽ gõ ĩ ní vúlé rá. ");
INSERT INTO kbo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“ꞌBo lẽ ĩmi lẽkí ĩmivé ariꞌba rĩ pi lẽlẽ, lẽ ĩmi ꞌokí kộpi múké. Lẽ ĩmi sẽkí mẹ̃rị́ kộpi ní, lẽ ĩmi ꞌbãkí ẹ́sị́ ꞌyozú kínĩ, kộpi ã újákí ngá ĩmi ní sẽé mẹ̃rị́ rú rĩ gõó vúlé ꞌdíni ku. Kúru ĩmi ímụ́ ãndẽma ị́sụ́ ãmbúgú. ꞌBụ̃ gé ꞌdãlé, ĩmi ímụ́ adri anji Múngú Ũkpõ ꞌDị́pa vé ni, ãꞌdiãtãsĩyã ĩrivé ẹ́sị́ múké ꞌbá õwõꞌdĩfô sẽꞌbá ku rĩ pi ní, ãzini ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lẽ ĩmî ẹ́sị́ ã adri ĩdríkídri ꞌbá ụrụkọꞌbée ní, sụ̃ ĩmi Ẹ́tẹ́pị ꞌbụ̃ gé rĩ ẽ ẹ́sị́ ní adrií ĩdríkídri ĩmi ní rĩ tị́nị. ");
INSERT INTO kbo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Lẽ ĩmi lịkí tã ꞌbá ãzi drị̃gé ku, ã lịkí rí kpá tã ĩmi drị̃gé ku. Lẽ ĩmi ꞌyokí ꞌbá ãzi ní ĩri ꞌbá ũnjí ꞌdíni ku, ã ꞌyokí rí kpá ĩmi ꞌbá ũnjí ku. Lẽ ĩmi trũkí ꞌbá ụrụkọꞌbée ĩvé ũnjĩkãnyã agásĩ rá, Múngú ã trũ rí ĩmi ĩmivé ũnjĩkãnyã agásĩ bẽsĩnĩ. ");
INSERT INTO kbo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ĩmi sẽkí dõ ngá ꞌbá ãzi ní, ĩ kpá újá sẽ ĩmi ní ãmbúgú. Ĩ ngá rĩ ụ̃ꞌbị̃ ĩmi ní ãmbúgú, ĩ ũmĩmĩ, ĩ ya, drị̃ ni ri ayi vũgá sĩ, ĩ kúru dã ĩmivé ngá agá. Ngá ĩmi ní ngá ụ̃ꞌbị̃zú rĩ, ĩ kpá gõ ngá ụ̃ꞌbị̃ sẽ ĩmi ní ãní.” ");
INSERT INTO kbo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yẹ́sụ̃ gõ ꞌbá rĩ pi ní nãpí ãzi ũlũú kĩnĩ, “ꞌBá mị be ẹ̃sị̃ị́pi gí rĩ nyo ícó ọ́gụ́pị mị be ẹ̃sị̃ị́pi gí rĩ se mụzú ꞌí vúgá sĩ rá? Kộpi ícókí nyo uꞌdeé ị̃rị̃trọ́ ꞌbụ́ agá ku? ");
INSERT INTO kbo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ꞌBá ĩ ní rií ímbá rĩ ícó ꞌbá ĩ ímbápi rĩ ndẽé ku, ꞌbo ímbákí dõ ꞌbá rĩ gí, ĩri ímụ́ adri sụ̃ ꞌbá ꞌi ímbápi rĩ tị́nị.” ");
INSERT INTO kbo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mi ngá mãdãŋá ꞌdeépi mí ọ́gụ́pị mị gé rĩ ndre rá pírí, ꞌbo ngá ꞌdeépi mí mị gé usegúgú ꞌdĩri, ꞌí ndre ku ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mi ícó ꞌyo mívé ũndĩ ní, ꞌí sẽ mâ ĩpẽ ngá ꞌdeépi mí mị gé ꞌdĩri ãmvé, ꞌbo ngá ꞌdeépi mí mị gé usegúgú ꞌdĩri, ꞌí ndre ku ãsĩ? Mi ꞌbá riípi mi ꞌbãápi kú tã bẽ pịrị ꞌdĩri, lẽ mî ĩpẽ ngá ꞌdeépi mí mị gé usegúgú ꞌdĩri ũgbále, mí íbí rí ngá ꞌdeépi mí ọ́gụ́pị mị gé rĩ ĩpẽé ndõ. ");
INSERT INTO kbo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pẹtị múké rĩ, ícó ꞌaá ũꞌa be ũnjí ku, pẹtị ũnjí rĩ, ícó ꞌaá ũꞌa be múké ku. ");
INSERT INTO kbo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ĩ pẹtị rĩ nị̃ ámá ĩrivé ũꞌa sĩ. ꞌBá ãzi ícó pẹtị ĩ ní zịị́ fị́gị̃ ꞌdĩri vé ũꞌa ĩtĩí pẹtị ũcékúcé be ni sị́gé ku, dõku ꞌbá ãzi ícó vị́nyọ̃ vé ũꞌa ĩtĩí pẹtị túngú ni sị́gé ku. ");
INSERT INTO kbo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ꞌBá múké rĩ, ĩri tã múké ꞌo, ãꞌdiãtãsĩyã ĩrivé ẹ́sị́ múké. ꞌBá ũnjí rĩ, ĩri tã ũnjí ꞌo, ãꞌdiãtãsĩyã ĩrivé ẹ́sị́ ũnjí. Átángá ĩri ní átá rĩ, ĩri íbí íngá ĩri ẹ́sị́ agá.” ");
INSERT INTO kbo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kúru Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ri ma zị ‘Úpí, Úpí’, tã má ní lũú ĩmi ní rĩ, ĩmi ꞌdụkí ngaá ku ãsĩ? ");
INSERT INTO kbo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ꞌBá mávé tã yịị́pi rá, tã ni ꞌdụụ́pi ngaápi rá rĩ, ");
INSERT INTO kbo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ĩri adri sụ̃ ꞌbá jó sịị́pi írã drị̃gé, ꞌbụ́ ni gaápi kụụ́pi vũgá ꞌdãá rĩ tị́nị. Yị̃ị́ kã tị̃ị́ jó rĩ ĩmũlũú lẽé jó rĩ ayaá íꞌdé vũgá, jó rĩ árí kuyé, ãꞌdiãtãsĩyã sịkí jó rĩ ũkpó ũkpó. ");
INSERT INTO kbo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ꞌBo ꞌbá mávé tã yịị́pi rá, tã ni ꞌdụụ́pi ngaápi ku rĩ, índré sụ̃ ꞌbá jó sịị́pi nyọ̃ọ́kụ́ agá, ndụ̃ụ́ ni ãꞌbãápi ũkpó ũkpó kuyé rĩ tị́nị. Yị̃ị́ kã tị̃ị́ jó rĩ ĩmũlũú, ze jó rĩ ũŋõó íꞌdé vũgá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yẹ́sụ̃ kã tã ꞌdĩꞌbée átá dẹẹ́ ꞌbá rĩ pi ní gí, ĩri ní ꞌdezú mụzú Kãpãrãnãụ́mã gá. ");
INSERT INTO kbo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kụ̃rụ́ rĩ agá ꞌdãá, ũgalaku ãngáráwá rĩ pi vé rĩ vé ãtíꞌbá ĩri ní lẽé ambamba rĩ, drã rụ ĩri ũnjí ũnjí, lẽ drãádrã. ");
INSERT INTO kbo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ũgalaku rĩ kã Yẹ́sụ̃ vé tã yịị́, ĩri ní ꞌbá ambugu Yãhụ́dị̃ rĩ pi vé rĩ pi ã ụrụkọ pẽzú mụzú Yẹ́sụ̃ ri zịzú, ẽ ímụ́ rí ívé ãtíꞌbágú rĩ ídrí. ");
INSERT INTO kbo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kộpi kâ caá Yẹ́sụ̃ vúgá ꞌdãá, kộpi ní Yẹ́sụ̃ ri mãzú kínĩ, “Ãngáráwá ãmbúgú rĩ, ĩri ꞌbá múké, lẽ mî ímụ́ ĩrivé ãtíꞌbá drã ní rụụ́ rĩ ídrí, ");
INSERT INTO kbo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ãꞌdiãtãsĩyã ãngáráwá rĩ lẽ ꞌbávé ꞌbá rĩ pi ambamba, sị ꞌbá ní Jó Múngú ri Zịzú ni.” ");
INSERT INTO kbo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kúru Yẹ́sụ̃ ní ꞌdezú mụzú kộpi be trụ́. Kộpi kâ caá ĩnyiŋá ꞌdãá, ãngáráwá rĩ pi vé ãmbúgú rĩ ní ívé ũndĩ ụrụkọꞌbée pẽzú mụzú Yẹ́sụ̃ vúgá ꞌdãá, kộpi ní ãngáráwá rĩ vé átángá ũlũzú Yẹ́sụ̃ ní kínĩ, “Úpí, mî iza mî sâ ímụ́zú mávé ãngá nõó ku, ãꞌdiãtãsĩyã ꞌí ndẽ ma ãmbũgũ sĩ rá, mí ícó ímụ́ mávé ãngá nõó ku. ");
INSERT INTO kbo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Á mụ mí vúgá ꞌdĩlé kuyé, ãꞌdiãtãsĩyã ꞌí ndẽ ma ãmbũgũ sĩ rá. Lẽ mî átá átángá rĩ, mávé ãtíꞌbá rĩ ícó ídrí rá. ");
INSERT INTO kbo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ãngáráwá ụrụkọꞌbée anigé má drị̃lé gá, kộpi má ní tãị́mbị́ sẽ nĩ, ãngáráwá ụrụkọꞌbée anigé mâ pálé gá, ma kộpi ní tãị́mbị́ sẽ nĩ. Ma ícó ꞌyo ãlu ni ní, ‘ꞌÍ mụ,’ ĩri mụ rá. Ma ícó ꞌyo ãzi ni ní, ‘Mí ímụ́,’ ĩri ímụ́ rá. Ma ícó ꞌyo mávé ãtíꞌbá rĩ ní, ‘ꞌÍ ꞌo ꞌdíni,’ ĩri tã rĩ ꞌo rá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yẹ́sụ̃ kã tã ĩ ní ũlũú ꞌí ní ꞌdĩri yịị́, sẽ ĩri ní ãyãngárá, ĩri ní ꞌi újázú ꞌbá bị́trị́ká mụꞌbá ꞌî vụ́drị̃ gé sĩ rĩ pi vúgálé, ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ĩsẽrélẽ agá nõgó, má ị́sụ́ drĩ ꞌbá ãzi ẹ̃ꞌyị̃ngárá be ũkpó ũkpó sụ̃ ágó ꞌdĩri vé rĩ tị́nị kuyé!” ");
INSERT INTO kbo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ãgõ ĩ ní pẽé ꞌdãꞌbée kâ ĩ újá gõó ꞌbẹ̃tị́ ꞌdãá, kộpi cakí ị́sụ́ ãngáráwá rĩ vé ãtíꞌbá rĩ ídrí gí. ");
INSERT INTO kbo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tã ꞌdĩri ã vụ́drị̃ gé, koro Yẹ́sụ̃ ní ꞌdezú mụzú kụ̃rụ́ Nãínĩ vé rĩ gé, ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ꞌbá bị́trị́ká rĩ pi be ꞌdekí mụzú ĩri ã vụ́drị̃ gé sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kộpi kâ caá ĩnyiŋá kụ̃rụ́ rĩ vé kẹ̃ẹ́tịlé gá ꞌdãá, kộpi ndrekí ꞌbá rĩ pi ri ọ̃wụ́zị́gọ́ rĩ vé mvá ãlukúta drãápi gí rĩ vé ãvũ ꞌdụ mụzú. ꞌBá bị́trị́ká ꞌdekí mụzú ũkú rĩ vúgá sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Úpí Yẹ́sụ̃ kã ọ̃wụ́zị́gọ́ rĩ ndreé, ĩzãngã fi ẹ́sị́ ni agá, ĩri ní ꞌyozú kĩnĩ, “ꞌÍ ngo ku.” ");
INSERT INTO kbo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yẹ́sụ̃ ní áꞌya ãvũ rĩ ꞌdụzú rĩ úlózú, ꞌbá ãvũ ꞌdụꞌbá rĩ pi ní pá tuzú. Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Kẹ̃rị́mvá ꞌdĩri, ꞌí nga ụrụ.” ");
INSERT INTO kbo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ãvũ rĩ ní íngázú úrízú ụrụ sĩ, ĩri ní íꞌdózú átázú, Yẹ́sụ̃ ní ĩri sẽzú gõzú ẹ́ndrẹ́pị vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ꞌBá rĩ pi ãrẽvú céré rukí tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri rá, sẽ kộpi íngúkí Múngú ri rá. Kộpi kínĩ, “Nẹ́bị̃ ãmbúgú ĩfũ ꞌbá ãsámvú gé gí. Múngú ímụ́ ívé ꞌbá rĩ pi ẽ ĩzã kongárá gá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri ayi mụzú ãngũ Yụ̃dáyã vé rĩ agásĩ, ãzini ãngũ jẽlé gá sĩ rĩ pi agásĩ céré. ");
INSERT INTO kbo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yũwánĩ Bãtízĩmũ sẽépi rĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní tã Yẹ́sụ̃ ní ꞌoó rĩ pi ũlũzú Yũwánĩ ní céré. Kúru Yũwánĩ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú ị̃rị̃, ");
INSERT INTO kbo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ĩri ní kộpi pẽzú mụzú Úpí ri zịzú kĩnĩ, “Mi ꞌbá ĩ ní ꞌyoó kínĩ, ĩri ímụ́ ꞌdĩíꞌdĩ rĩ ꞌi, dõku ꞌbá ꞌbá ní rií ũtẽé rĩ ĩri túngú?” ");
INSERT INTO kbo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yũwánĩ vé ꞌbá ĩri ã pámvú ũbĩꞌbá ị̃rị̃ ꞌdĩꞌbée kâ caá Yẹ́sụ̃ vúgá ꞌdãá, kộpi ní ꞌyozú Yẹ́sụ̃ ní kínĩ, “Yũwánĩ Bãtízĩmũ sẽépi rĩ ĩpẽ ꞌbâ ímụ́ mi zịị́, ‘Mi ꞌbá ĩ ní ꞌyoó kínĩ, ĩri ímụ́ ꞌdĩíꞌdĩ rĩ ꞌi, dõku ꞌbá ꞌbá ní rií ũtẽé rĩ ĩri túngú?’ ” ");
INSERT INTO kbo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sâ ꞌdãri gé, Yẹ́sụ̃ ídrí ꞌbá drã be ãndíãndí ni pi, ꞌbá índrí ũnjí be ni pi kárákará, zị̃ ꞌbá kárákará mị be ẹ̃sị̃ꞌbá gí ni pi ẽ mị ãngũ ndreé rá. ");
INSERT INTO kbo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kúru Yẹ́sụ̃ ní újázú ꞌbá Yũwánĩ vé áyúãyũ rĩ pi ní kĩnĩ, “Ĩmi mvikí gõó Yũwánĩ vúgá ꞌdãá, ĩmi ũlũkí ĩri ní tã ĩmi ní ndreé ĩmî mị sĩ, ãzini ĩmi ní yịị́ ĩmî bị́ sĩ rĩ. ꞌBá mị ãkó rĩ pi nóni ãngũ ndre rá, ꞌbá bãtrá rú rĩ pi ngakí ẹ̃cị̃ tuú rá, ꞌbá ũfú ní nyaá rĩ pi ã rụ́ꞌbá ícákí céré ule rá, ꞌbá bị́ be ẹ̃sị̃ꞌbá gí rĩ pi ẽ bị́ zị̃ ꞌi tã yịị́ rá, ꞌbá ũdrãꞌbá gí rĩ pi íngákí gõó ídri rú rá, ãzini ĩ nóni ri ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũ ꞌbá ngá ãkó rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ĩmi lũkí Yũwánĩ ní ꞌyozú kínĩ, tã má ní ꞌoó, ãzini tã má ní ꞌyoó rĩ, ꞌbá rĩ gã dõ ma kuyé, Múngú ri ĩri ní tãkíri sẽ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yũwánĩ vé ꞌbá áyúãyũ rĩ pi kâ ꞌdeé mụụ́ gí, Yẹ́sụ̃ ní íꞌdózú Yũwánĩ vé tã átázú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, “Ngá ĩmi ní mụụ́ ndreé ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá rĩ ãꞌdi? Ĩmi mụkí ꞌbá ũkpõ ãkó sụ̃ ĩzíríkõ ũlí ní rií úvị́ rĩ tị́nị ni ndreé? ");
INSERT INTO kbo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dõ ꞌdíni kuyé, ngá ĩmi ní mụụ́ ndreé rĩ ãꞌdi? Ĩmi mụkí ágó bõngó suúpi ũnyĩ be ni ndreé? ꞌBá bõngó ãjẽ be ni pi suꞌbá rĩ pi, kộpi ãꞌbú be ambamba, kộpi ri adri vũrã ꞌbãgú ní rizú adrizú rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ꞌBo ngá ĩmi ní mụụ́ ndreé ãngũ ãꞌwí cínyáfã rú rĩ agá ꞌdãá rĩ ãꞌdi? Ĩmi mụkí nẹ́bị̃ ndreé? Ẽ, á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá ĩmi ní mụụ́ ndreé ꞌdãri ndẽ nẹ́bị̃ rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ꞌBá ꞌdĩri Yũwánĩ ꞌi, sĩkí ĩrivé tã Búkũ Múngú vé rĩ agá kínĩ: “ ‘Ma mávé ꞌbá áyúãyũ ni pẽ mụzú mí ní drị̃drị̃, ĩri mụ mí ní lẹ́tị údé.’ ");
INSERT INTO kbo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Á lẽ lũú ĩmi ní kínĩ, ꞌbá ũkú ní tịị́ rĩ pi ãsámvú gé, ꞌbá ãzi Yũwánĩ ri ndẽépi ãmbũgũ sĩ ni ãluŋáni ꞌdãáyo. ꞌBo ꞌbá mãlũngã Múngú vé rĩ agá ꞌdãá ụ̃dụ̃mbị́tã rú rĩ, ndẽ Yũwánĩ ri ãmbũgũ sĩ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ꞌBá rĩ pi ãrẽvú céré, ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi be, kộpi kâ tã Yẹ́sụ̃ ní átá ꞌdĩri yịị́, kộpi ẹ̃ꞌyị̃kí rá ꞌyozú kínĩ, tã Múngú vé ꞌoó rĩ, ĩri pịrị, ãꞌdiãtãsĩyã Yũwánĩ sẽ ĩ ní bãtízĩmũ nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ꞌBo Fãrụ́sị̃ rĩ pi, ꞌbá ĩ ní ímbá tãị́mbị́ Mósẽ vé rĩ nị̃ꞌbá múké múké rĩ pi be, gãkí tã Múngú ní lẽé kộpi ã ꞌokí rĩ sĩ, ãꞌdiãtãsĩyã kộpi lẽkí Yũwánĩ ã sẽ ĩ ní bãtízĩmũ ku. ");
INSERT INTO kbo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yẹ́sụ̃ ní gõzú ꞌyozú kĩnĩ, “Mâ ụ̃ꞌbị̃ rí úyú lókí nõri vé rĩ pi ngá íngóni ni sĩ? Kộpi adrikí sụ̃ ngá íngóni ni tị́nị? ");
INSERT INTO kbo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kộpi adrikí sụ̃ anjiŋá ĩ úmúꞌbá áví ávíꞌbée jọ̃kọ́nị̃ agá rĩ pi tị́nị, kộpi ri ꞌyo, “ ‘ꞌBá cokí ĩmi ní kụ̃ꞌdị́, ꞌbo ĩmi tukí úngó kuyé, ꞌBá ngokí úngó ãvũ vé ni, ꞌbo ĩmi ngokí ãá kuyé.’ ");
INSERT INTO kbo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ãꞌdiãtãsĩyã Yũwánĩ Bãtízĩmũ sẽépi rĩ ímụ́, nya pánga kuyé, ãzini mvụ vị́nyọ̃ kuyé, ꞌbo ĩmi kínĩ, ‘Índrí ũnjí fi drị̃ ni gé gí.’ ");
INSERT INTO kbo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ma ꞌBá Mvá ꞌi, má ímụ́, á nya ngá rá, ãzini á mvụ ngá rá, ĩmi kínĩ, ‘Ma ri ngá nya ambamba, ãzini ma ri ĩmẽrẽ ambamba, ma ũndĩ ꞌbá mũfẽngã umbe jezú rĩ uꞌdụꞌbá rĩ pi vé ni, ãzini ꞌbá ũnjĩkãnyã ꞌoꞌbá rĩ pi vé ni.’ ");
INSERT INTO kbo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tã ꞌbá úmĩ be rĩ ní ngaá rĩ ĩri lũ ꞌyozú kínĩ tã ĩri ní ꞌoó rĩ pịrị.” ");
INSERT INTO kbo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fãrụ́sị̃gú ãzi zị Yẹ́sụ̃ ri mụụ́ ínyá nyaá ívé ãngá, kúru Yẹ́sụ̃ ní ꞌdezú mụzú ágó rĩ vé ãngá ꞌdãá, kộpi ní úrízú vũgá ínyá rĩ ã nyangárá gá. ");
INSERT INTO kbo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ũkú ãzi ũnjĩkãnyã be ni kụ̃rụ́ ꞌdãri agá, ũkú rĩ kã yịị́ kínĩ, Yẹ́sụ̃ ri ínyá nya Fãrụ́sị̃gú rĩ vé ãngá ꞌdãáꞌdã, ĩri ní ũdu ãjẽ be ãmbúgú ni íjị́zú mãlãngĩ agá, ");
INSERT INTO kbo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ĩri ní ímụ́zú pá tuzú Yẹ́sụ̃ ã úgóró gá, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ã pá gálésĩ, ĩri ní rizú ngozú, ĩrivé mị̃ị́ndrẹ ri uꞌdeé Yẹ́sụ̃ ã pá gá. Kúru ĩri ní mị̃ị́ndrẹ rĩ ị́nị́zú ꞌî drị̃ꞌbí sĩ, ĩri ní Yẹ́sụ̃ ã pá undruzú, ĩri ní ũdu ngụ̃ụ́pi ndrị̃ndrị̃ ni dãzú Yẹ́sụ̃ ã pá gá. ");
INSERT INTO kbo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fãrụ́sị̃gú Yẹ́sụ̃ ri zịị́pi rĩ kã tã ꞌdĩri ndreé, ri ụ̃sụ̃ụ́ ꞌí ẹ́sị́ agá ꞌdãlé kĩnĩ, “Ágó ꞌdĩri dõ nẹ́bị̃, ícó té nị̃ị́ ámá ꞌyozú kínĩ, ũkú riípi drị́ ꞌbãápi ꞌî rụ́ꞌbá gá ꞌdĩri, ĩri ꞌbá ũnjĩkãnyã be ni ku?” ");
INSERT INTO kbo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yẹ́sụ̃ ní ꞌyozú Fãrụ́sị̃gú rĩ ní kĩnĩ, “Sị̃mọ́nã, á lẽ mí ní tã ãzi lũú ꞌdĩ.” Sị̃mọ́nã ní ẹ̃ꞌyị̃zú kĩnĩ, “Ímbápi, mi ícó tã rĩ lũ má ní rá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yẹ́sụ̃ ní ꞌyozú ĩri ní kĩnĩ, “Ágó ãzi sẽ mũfẽngã ꞌbá ị̃rị̃ pi ní mẹ̃rị́ rú. Sẽ ágó ãzi rĩ ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ mụ̃dụ̃rụ̃lụ̃ tọ̃wụ́, sẽ ãzi rĩ ní mũfẽngã fífí ẹ̃njị̃ị́pi ẹ̃njị̃ẹ̃njị̃ pụ̃kụ́ tọ̃wụ́. ");
INSERT INTO kbo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ãgõ ị̃rị̃ ꞌdĩꞌbée ndãkí ũꞌdũ tí mẹ̃rị́ ꞌdĩꞌbée ũfẽzú. Mẹ̃rị́ ꞌdị́pa kã ndreé ꞌdíni, gõ mũfẽngã rĩ vé tã ọyụụ́ ꞌí ẹ́sị́ agásĩ rá. ꞌBá ị̃rị̃ ꞌdĩꞌbée pi ãsámvú gé, ꞌbá mẹ̃rị́ ꞌdị́pa rĩ lẽépi agaápi rá rĩ íngõri?” ");
INSERT INTO kbo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sị̃mọ́nã ní újázú kĩnĩ, “Má ígá ꞌbá mẹ̃rị́ ꞌdụụ́pi ãmbúgú rĩ ꞌi.” Yẹ́sụ̃ ní ꞌyozú ĩri ní kínĩ, “Tã mí ní újá ꞌdĩri pịrị.” ");
INSERT INTO kbo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kúru Yẹ́sụ̃ ní ꞌi újázú ũkú rĩ ndrezú, ĩri ní ꞌyozú Sị̃mọ́nã ní kĩnĩ, “ꞌÍ ndre drĩ ũkú ꞌdĩri ká, má ní ícázú mívé ãngá nõgó rĩ gé, ꞌí sẽ má ní yị̃ị́ pá ũjĩzú ni kuyé, ꞌbo ũkú nõri ũjĩ mâ pá mị̃ị́ndrẹ ꞌí mị gé rĩ sĩ, ị́nị́ mâ pá ꞌî drị̃ꞌbí sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mí uꞌde ma ẹzịị́ bẹ̃drị̃ sĩ kuyé, ꞌbo sâ má ní ífízú nõgó rĩ gé, ũkú rĩ ri mâ pá ndruú, ku ndrungárá ni kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ꞌÍ dã ũdu má drị̃gé kuyé, ꞌbo ũkú rĩ ũdã ũdu ngụ̃ụ́pi ndrị̃ndrị̃ rĩ má pá gá nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kúru á lẽ ꞌyoó mí ní ꞌdíni, ũnjĩkãnyã ũkú rĩ ní ꞌoó kárákará ꞌdĩꞌbée, á trũ ĩri gí, ãꞌdiãtãsĩyã lẽ ma ambamba. ꞌBo ꞌbá ĩ ní ĩrivé ũnjĩkãnyã trũú céré kuyé rĩ, ĩrivé lẽngárá mãdãŋá.” ");
INSERT INTO kbo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kúru Yẹ́sụ̃ ní ꞌyozú ũkú rĩ ní kĩnĩ, “Á trũ mi mívé ũnjĩkãnyã agásĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ụ̃mụ́ rĩ pi ní rizú átázú ĩ ãsámvú gé sĩ kínĩ, “ꞌBá ꞌdĩri ụ̃sụ̃ ꞌi ãꞌdi ꞌi ícópi ũnjĩkãnyã trũúpi rá ni?” ");
INSERT INTO kbo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yẹ́sụ̃ ní ꞌyozú ũkú rĩ ní kĩnĩ, “Mívé ẹ̃ꞌyị̃ngárá ídrí mi gí, ꞌí mụ, tãkíri ã adri mí be.” ");
INSERT INTO kbo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tã ꞌdĩri ã vụ́drị̃ gé, Yẹ́sụ̃ ri ẹ́cị́ mụzú kụ̃rụ́ rĩ pi agásĩ, gụ́rụ́ rĩ pi agásĩ, ri ụ́ꞌdụ́kọ́ múké mãlũngã Múngú vé rĩ ã tã ũlũú ꞌbá rĩ pi ní. Ĩrivé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi rikí ẹ́cị́ ĩri be trụ́. ");
INSERT INTO kbo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ũkú ụrụkọ ĩri ní índrí ũnjí údró kộpi drị̃gé sĩ, ãzini ũkú ụrụkọ ĩri ní ídrí drã ãndíãndí agásĩ rĩ pi, kộpi rikí kpá ẹ́cị́ ĩri be trụ́, ũkú ãzi rĩ ã rụ́ Mãríyã Mãgãdẽlénã ꞌi, ũkú ꞌdĩri ọ́tụ́ Yẹ́sụ̃ ní índrí ũnjí ẹ́zị̂rị̃ rĩ pi droó fũú drị̃ ni gé sĩ rĩ ꞌi, ");
INSERT INTO kbo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ãzi rĩ vé rụ́ Jũwánã ꞌi, ĩri Kúzã vé ũkú, Kúzã ri ꞌbá riípi Ẽródẽ vé ngá ꞌbẹ̃tị́ agá rĩ pi vé tã mbaápi rĩ, ãzi rĩ ã rụ́ Sũzánã ꞌi, ũkú ụrụkọ kárákará ni pi be. Ũkú ꞌdĩꞌbée ri ngá ĩvé rĩ pi sẽ Yẹ́sụ̃ pi ẽ ĩzã kozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be. ");
INSERT INTO kbo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ụ́ꞌdụ́ ãlu, ꞌbá bị́trị́ká ímụ́kí ĩ úmú Yẹ́sụ̃ ã gãrã gá, kộpi íbíkí ímụ́ kụ̃rụ́ ãndíãndí ni pi gélésĩ, Yẹ́sụ̃ ní kộpi ní nãpí ꞌdĩri ũlũzú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ágó ãzi ọ́mvụ́ be ni mụ úri rií ívé ọ́mvụ́ agá, ágó rĩ kã úri rĩ rií, úri rĩ pi ã ụrụkọ uꞌdekí lẹ́tị drị̃gé, ꞌbá rĩ pi rikí utuú pá sĩ, ãríŋá rĩ pi tekí kộpi rá. ");
INSERT INTO kbo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ írã drị̃gé ni agá, kộpi kâ ĩfũú, kộpi ꞌwikí rá, ãꞌdiãtãsĩyã yị̃ị́ nyọ̃ọ́kụ́ rĩ agá ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Úri rĩ pi ã ụrụkọ uꞌdekí ũcékúcé ãsámvú gé, ũcékúcé rĩ dụ kộpi be trụ́, ọ̃zụ̃ úri ĩfũꞌbá dụꞌbá rĩ pi rá. ");
INSERT INTO kbo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Úri rĩ pi ã ụrụkọ uꞌdekí nyọ̃ọ́kụ́ múké ni agá, kộpi ĩfũkí dụụ́ rá, ãlu rĩ ꞌa caá mụ̃dụ̃rụ̃lụ̃ ãlu.” Yẹ́sụ̃ kã nãpí rĩ ũlũú dẹẹ́, ĩri ní ꞌyozú kĩnĩ, “ꞌBá bị́ be rĩ, ã yị ꞌí ní tã ꞌdĩri.” ");
INSERT INTO kbo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩri zịzú kínĩ, nãpí ꞌdĩri vé ífífí íngóni. ");
INSERT INTO kbo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ĩri ní ꞌyozú kĩnĩ, “Sẽkí ĩmi ní úmĩ mãlũngã Múngú vé ĩ ní ũzụ̃ụ́ kuú mũdũmũdũ rú rĩ vé tã nị̃zú ámázú rĩ rá, ꞌbo ma tã rĩ átá ꞌbá ụrụkọꞌbée ní nãpí sĩ, lũzú kínĩ, “ ‘Kộpi ãngũ ndre rá, ꞌbo kộpi ámákí ngá rĩ ndreé ku, kộpi tã rĩ yị rá, ꞌbo tã rĩ fi kộpi drị̃gé ku.’ ");
INSERT INTO kbo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nãpí rĩ vé ífífí ꞌdíni, úri rĩ tị Múngú vé rĩ. ");
INSERT INTO kbo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Úri uꞌdeꞌbá lẹ́tị drị̃gé rĩ pi, ĩri ꞌbá Múngú vé tị yịꞌbá rá rĩ pi, ꞌbo ãdróko ri ímụ́ tị Múngú vé rĩ ꞌdụ kộpi ẽ ẹ́sị́ agásĩ rá, kộpi ẽ ẹ̃ꞌyị̃kí rí ku, ãzini kộpi ẽ ị́sụ́kí rí ídríngárá ku. ");
INSERT INTO kbo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Úri uꞌdeꞌbá nyọ̃ọ́kụ́ írã drị̃gé rĩ agá rĩ pi, ĩri ꞌbá tị Múngú vé rĩ yịꞌbá, ẹ́ꞌyị́ꞌbá ãyĩkõ sĩ rĩ pi, ꞌbo kộpi ã úlá fi vũgá ꞌdãá kuyé, kộpi ẹ̃ꞌyị̃ lókíŋá be mãdã, ꞌbo tã ũkpó ũkpó kádõ kộpi ị́sụ́, kộpi ẹ̃ꞌyị̃ngárá rĩ ku rá. ");
INSERT INTO kbo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Úri uꞌdeꞌbá ũcékúcé ãsámvú gé rĩ pi, ĩri ꞌbá tị Múngú vé rĩ yịꞌbá rá rĩ pi, ꞌbo ĩzãngã nyọ̃ọ́kụ́ nõri vé rĩ, ãꞌbú nyọ̃ọ́kụ́ nõri vé rĩ, ãzini ãyĩkõ nyọ̃ọ́kụ́ nõri vé rĩ sẽ kộpi adri ũꞌa ãkó. ");
INSERT INTO kbo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ꞌBo úri uꞌdeꞌbá nyọ̃ọ́kụ́ múké rĩ agá rĩ pi, ĩri ꞌbá adriꞌbá tã be múké, ãzini ẹ́sị́ be múké rĩ pi, kộpi tị Múngú vé rĩ yị rá, kộpi tã ni ꞌdụ nga rá, kộpi ꞌa ũꞌa be múké. ");
INSERT INTO kbo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ꞌBá ãzi ícó lámbã ꞌyũú, drị̃ ni ụ̃pị̃ị́ ũdrí sĩ cí ku, dõku ícó lámbã rĩ suú gbọ́lọ́ ã ndụ́gé ku. Ĩri lámbã rĩ ꞌbã mísá drị̃gé, ꞌbá ífíꞌbá jó agá rĩ pi ã ndrekí rí ãngũ ãní bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngá ãrẽvú céré ĩ ní zụ̃ụ́ kuú mũdũmũdũ rú rĩ ĩ ímụ́ iꞌda ãngũ ule gá, ngá ãzi ꞌi zụ̃ụ́pi ĩ ní ícó nị̃ị́ ku ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ĩmi ndrekí múké, lẽ ĩmi ꞌbãkí bị́ tã rĩ yịzú. ꞌBá ngá be rĩ, ĩ ĩri ní ãzi ni sẽ ãmbúgú, ꞌbá ngá ãkó rĩ, ã ụ̃sụ̃ dõ ꞌyozú kínĩ, ꞌi ngá be drãáãsĩyã, ĩ ngá ĩrivé ꞌdĩri ꞌdụ rá.” ");
INSERT INTO kbo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Vụ́drị̃ ni gé, Yẹ́sụ̃ ẹ́ndrẹ́pị pi ímụ́kí ẹ́drị́pị́ị be Yẹ́sụ̃ ri ndreé, ꞌbo kộpi ndãkí ũꞌdũ tí fizú cazú ĩri vúgá ꞌdãá, ãꞌdiãtãsĩyã ꞌbá rĩ pi gakí ambamba. ");
INSERT INTO kbo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ꞌBá ãzi ní lũzú Yẹ́sụ̃ ní kĩnĩ, “Mí ẹ́ndrẹ́pị pi mí ẹ́drị́pị́ị be tukí pá kuú ãmvé ꞌdãáꞌdã, kộpi lẽkí mi ndreé.” ");
INSERT INTO kbo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “ꞌBá Múngú vé tị yịꞌbá rá, tã ni ꞌdụꞌbá ngaꞌbá rá rĩ pi, kộpi mávé ẹ́ndrẹ́pị, ãzini mávé ẹ́drị́pị́ị.” ");
INSERT INTO kbo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ụ́ꞌdụ́ ãlu, Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “ꞌBâ zokí mụụ́ yị̃ị́ bãlãlã rĩ agásĩ álé ꞌdãá.” Kúru kộpi ní tụzú kũlúmgba agá, kộpi ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kộpi kâ rií zoó mụzú, Yẹ́sụ̃ ní ụ́ꞌdụ́ kozú. Kúru ũlí vịị́pi ũkpõ be ni ní íngázú vịzú yị̃ị́ bãlãlã rĩ drị́gé sĩ, yị̃ị́ ní írízú tị̃zú kũlúmgba rĩ agá ꞌdãá, sẽ kũlúmgba rĩ lẽ tĩí ãní yị̃ị́ ã ndụ́gé. ");
INSERT INTO kbo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi ní ĩri aruzú ꞌyozú ĩri ní kínĩ, “Úpí, Úpí, ꞌbâ ri tĩ yị̃ị́ ã ndụ́gé!” Yẹ́sụ̃ ní ngazú ụrụ sĩ, ĩri ní trezú ũlí rĩ drị̃gé, ãzini yị̃ị́ úvápi ngũyá ngũyá rĩ drị̃gé, ũlí vịị́pi ũkpõ be rĩ ní pá tuzú. ");
INSERT INTO kbo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yẹ́sụ̃ ní ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi zịzú kĩnĩ, “Ĩmi ẹ̃ꞌyị̃ngárá ãkó ãsĩ?” Ụ̃rị̃ fụ kộpi, tã ꞌdĩri sẽ kộpi ní ãyãngárá, ọ́gụ́pị ní ọ́gụ́pị ri zịzú, “ꞌBá ꞌdĩri ãꞌdi ꞌi átángá átápi ũlí ní tị ni yịị́, ãzini yị̃ị́ úvápi ngũyá ngũyá rĩ ní tị ni yịị́ ĩndĩ ꞌdĩri?” ");
INSERT INTO kbo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yẹ́sụ̃ pi ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi be, kộpi ní yị̃ị́ bãlãlã Gãlĩláyã ri zozú álé ꞌdãá, kộpi ní cazú ãngũ Gẽrásã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yẹ́sụ̃ kã ísị́ kũlúmgba rĩ agásĩ, ágó ãzi índrí ũnjí ní fií drị̃ ni gé ni ní ímụ́zú Yẹ́sụ̃ vúgá nõó. Ágó rĩ adri lókí be aco, su bõngó ꞌî rụ́ꞌbá gá ku, adri ꞌbẹ̃tị́ ku, ĩri ri adri ꞌbụ́rẹ̃drị̃ rĩ pi ãsámvú gé. ");
INSERT INTO kbo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ágó rĩ kã Yẹ́sụ̃ ri ndreé, ĩri ní trezú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní ꞌyozú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Yẹ́sụ̃, Mvá Múngú Ũkpõ ꞌDị́pa vé rĩ, ꞌí lẽ má vúgá ãꞌdi? Á mã mi drị́ ị̃rị̃ sĩ, ã ꞌokí ma ũnjí ku fô!” ");
INSERT INTO kbo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Drị̃drị̃ ni, Yẹ́sụ̃ ꞌyo índrí ũnjí rĩ ní rá kĩnĩ, índrí ũnjí rĩ ã fũ ágó rĩ drị̃gé sĩ rá. (Ágó ꞌdĩri índrí ũnjí rĩ fi rụ́ꞌbá ni gé ọ́tụ́ ị́nọ́gọ́sị́, kádõ drị́ ni pi úmbé pá ni pi be ímvẽ sĩ, kádõ rií ĩri ũtẽé, ĩri ímvẽ rĩ uce ꞌdĩísĩ rá, índrí ũnjí rĩ ĩri jị mụ ásé agá ãngũ ꞌbá ãkó ni agá.) ");
INSERT INTO kbo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yẹ́sụ̃ ní ágó rĩ zịzú kĩnĩ, “Mî rụ́ ãꞌdi ꞌi?” Ágó rĩ ní újázú Yẹ́sụ̃ ní kĩnĩ, “Mâ rụ́ Bị́trị́ká ꞌi.” Ágó rĩ ꞌyo ꞌdíni, ãꞌdiãtãsĩyã índrí ũnjí fiꞌbá rụ́ꞌbá ni gé rĩ pi kárákará. ");
INSERT INTO kbo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Índrí ũnjí rĩ pi ní rizú Yẹ́sụ̃ ri mãzú kínĩ, Yẹ́sụ̃ ã pẽ ĩ mụụ́ ꞌbụ́ kụụ́pi ụ̃dụ̃ ãkó rĩ agá ꞌdãá ku. ");
INSERT INTO kbo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ĩgá kárákará ꞌbá rĩ pi ri kộpi úcé ánga rĩ drị̃gé ꞌdãá. Índrí ũnjí rĩ pi ní Yẹ́sụ̃ ri mãzú kínĩ, Yẹ́sụ̃ ã pẽ ĩ mụụ́ úfí ĩgá rĩ pi agá, Yẹ́sụ̃ ní kộpi pẽzú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Índrí ũnjí rĩ pi ní úkpúzú ágó rĩ drị̃gé sĩ, mụzú úfízú ĩgá rĩ pi agá, ĩgá rĩ pi ní njuzú mụzú ọ́ngụ́ sĩ ãngũ úlúpi úlúlũ rĩ gé ꞌdãá, kộpi ní uꞌdezú yị̃ị́ bãlãlã rĩ agá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ꞌBá riꞌbá ĩgá rĩ úcéꞌbá rĩ pi kâ tã ꞌi ꞌoópi ꞌdĩri ndreé, kộpi ní njuzú mụzú tã ꞌdĩri ũlũzú ꞌbá kụ̃rụ́ agá rĩ pi ní, ãzini ꞌbá kụ̃rụ́ rĩ ã gãrã gá sĩ rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ꞌBá rĩ pi ní ngazú mụzú tã ꞌi ꞌoópi rĩ ndrezú. Kộpi kâ caá Yẹ́sụ̃ vúgá ꞌdãlé, kộpi ị́sụ́kí ágó ándúrú índrí ũnjí rĩ pi ní fũú drị̃ ni gé sĩ gí rĩ, úrí kuú Yẹ́sụ̃ ẹndrẹtị gé, úsú ꞌi bõngó sĩ, úmĩ ni ícá múké gí, sẽ kộpi ní ụ̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ꞌBá tã rĩ ndreꞌbá rĩ pi ní mụzú tã ĩ ní ágó índrí ũnjí be rĩ ídrízú ꞌdĩri ũlũzú ꞌbá ụrụkọꞌbée ní. ");
INSERT INTO kbo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kúru ꞌbá céré ãngũ Gẽrásã vé rĩ agá rĩ pi ní Yẹ́sụ̃ ri mãzú kínĩ, Yẹ́sụ̃ ã nga mụụ́ ꞌdĩísĩ rá, ãꞌdiãtãsĩyã ụ̃rị̃ fi kộpi ẹ́sị́ agá ambamba. Kúru Yẹ́sụ̃ ní tụzú fizú kũlúmgba agá, ĩri ní ꞌdezú mụzú. ");
INSERT INTO kbo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ágó Yẹ́sụ̃ ní índrí ũnjí droó fũú drị̃ ni gé sĩ rĩ ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, ĩ mụkí Yẹ́sụ̃ be trụ́, ꞌbo Yẹ́sụ̃ ní ĩri pẽzú mụzú, ĩri ní ꞌyozú kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ꞌÍ mvi gõó ꞌbẹ̃tị́, ꞌí mụ tã ãyãzú ãyãyã Múngú ní ꞌoó mí ní ꞌdĩri ũlũú mívé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní.” Ágó rĩ ní ꞌdezú mụzú kụ̃rụ́ rĩ agá ꞌdãá, ĩri ní tã Yẹ́sụ̃ ní ꞌoó ꞌí ní ꞌdĩri ũlũzú mụzú ꞌbá rĩ pi ní céré. ");
INSERT INTO kbo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kúru Yẹ́sụ̃ kã ꞌi újá zoó gõó álé ꞌdãá, ꞌbá bị́trị́ká riꞌbá ĩri ũtẽꞌbá rĩ pi ní ĩri ẹ́ꞌyị́zú. ");
INSERT INTO kbo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ágó ãzi rụ́ ni Yáyĩrõ ꞌi, ĩri Jó Múngú ri Zịzú rĩ vé drị̃koma, ágó rĩ ní ímụ́zú kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní Yẹ́sụ̃ ri mãzú drị́ ị̃rị̃ sĩ kĩnĩ, ĩ mụkí Yẹ́sụ̃ be trụ́ ívé ãngá ꞌdãá, ");
INSERT INTO kbo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ãꞌdiãtãsĩyã ívé mvá ũkú ãlukútaŋá ílí be mụdrị́ drị̃ ni ị̃rị̃ rĩ, drã rụ ĩri ũnjí ũnjí, lẽ drãádrã. Yẹ́sụ̃ kã rií ꞌdeé mụụ́ Yáyĩrõ vé ãngá ꞌdãlé, ꞌbá bị́trị́ká rĩ pi rikí ĩ mĩí mụzú Yẹ́sụ̃ rụ́ꞌbá gá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ũkú ãzi kộpi ãsámvú gé ꞌdãlé, ãrí ri ẹ́cị́ rụ́ꞌbá ni gé sĩ ílí mụdrị́ drị̃ ni ị̃rị̃, ꞌbo ꞌbá ãzi ĩri ídrípi ni ꞌdãáyo. ");
INSERT INTO kbo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ũkú rĩ ní ꞌi útrúzú ĩnyiŋá Yẹ́sụ̃ ã úgóró gá, ĩri ní Yẹ́sụ̃ vé bõngó akoóko rĩ ẽ tị úlózú, koro ãrí ẹ́cị́pi rĩ ní pá tuzú. ");
INSERT INTO kbo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yẹ́sụ̃ ní zịzú kĩnĩ, “ꞌBá ma úlópi rĩ ãꞌdi ꞌi?” ꞌBá bị́trị́ká rĩ pi ní ꞌyozú kínĩ, ĩ nị̃kí kuyé. Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Úpí, ꞌbá rĩ pi kárákará ri ĩ ĩmĩ ímụ́zú mî rụ́ꞌbá gá nõó.” ");
INSERT INTO kbo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ꞌBo Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “ꞌBá ãzi úló ma gí, ãꞌdiãtãsĩyã á nị̃ rá ũkpõ ãngũ ídrízú rĩ fũ mâ rụ́ꞌbá gá sĩ gí.” ");
INSERT INTO kbo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ũkú rĩ kã ndreé Yẹ́sụ̃ nị̃ tã ꞌdĩri ámá gí, rụ́ꞌbá ni ní íꞌdózú yãzú, ĩri ní kũmũcí ũtị̃zú Yẹ́sụ̃ ẹndrẹtị gé, ĩri ní tã ꞌí ní Yẹ́sụ̃ vé bõngó úlózú, ãzini ꞌí ní koro ídrízú rĩ vé tã ũlũzú ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kúru Yẹ́sụ̃ ní ꞌyozú ũkú rĩ ní kĩnĩ, “Mâ mvá rĩ, ẹ̃ꞌyị̃ngárá mívé rĩ ídri mi gí. ꞌÍ mụ, tãkíri ã adri mí be.” ");
INSERT INTO kbo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yẹ́sụ̃ kã rií átángá rĩ átá, ꞌbá ãzi ní ímụ́zú Yáyĩrõ drị̃koma Jó Múngú ri Zịzú rĩ vé rĩ vé ãngá ꞌdãásĩ, ĩri ní ꞌyozú Yáyĩrõ ní kĩnĩ, “Mívé mvá ũkú rĩ drã gí, mî ri ímbápi ẽ drị̃ izaá ku.” ");
INSERT INTO kbo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yẹ́sụ̃ kã tã ꞌdĩri yịị́, ĩri ní ꞌyozú Yáyĩrõ ní kĩnĩ, “Lẽ mî adri ụ̃rị̃ sĩ ku, mí ẹ̃ꞌyị̃ ma, mvá ũkú rĩ ícó ídrí rá.” ");
INSERT INTO kbo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yẹ́sụ̃ kã mụụ́ caá Yáyĩrõ vé ãngá ꞌdãlé, ãꞌyĩ ꞌbá ãzi fií ꞌí vúgá sĩ jó agá ꞌdãlé kuyé, kộpi fikí ꞌyéŋá Pétẽró be, Yũwánĩ be, Yõkóbũ sĩ, ãzini mvá ũkú rĩ vé ẹ́tẹ́pị be ẹ́ndrẹ́pị sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ꞌBá rĩ pi céré rikí ngoó ĩzãngã ĩzãngã rú mvá ũkú ri vé drãngárá sĩ. Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ngokí ku, mvá ũkú rĩ drã kuyé, ĩri ri ụ́ꞌdụ́ ko.” ");
INSERT INTO kbo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ꞌBo ꞌbá rĩ pi rikí gụụ́gụ ĩrivé tã ꞌdĩri sĩ, ãꞌdiãtãsĩyã kộpi nị̃kí rá ꞌyozú kínĩ mvá ũkú rĩ drã gí. ");
INSERT INTO kbo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ꞌBo Yẹ́sụ̃ ní mvá ũkú rĩ ẽ drị́ rụzú, ĩri ní ꞌyozú kĩnĩ, “Mâ mvá rĩ, mí íngá ụrụ.” ");
INSERT INTO kbo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mvá ũkú rĩ vé índrí ní ímvízú ĩgõzú, koro ĩri ní ngazú ụrụ. Kúru Yẹ́sụ̃ ní ꞌyozú mvá ũkú rĩ vé ẹ́tẹ́pị pi ní ẹ́ndrẹ́pị be kĩnĩ, “Ĩmi sẽkí ĩri ní ngá nyaá.” ");
INSERT INTO kbo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mvá ũkú rĩ vé ẹ́tẹ́pị pi ẹ́ndrẹ́pị be ãyãkí tã ꞌdĩri sĩ ãyãyã, ꞌbo Yẹ́sụ̃ ní tãị́mbị́ sẽzú kộpi ní kĩnĩ, lẽ kộpi ã ũlũkí tã ꞌi ngaápi ꞌdĩri ꞌbá ãzi ní ku. ");
INSERT INTO kbo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kúru Yẹ́sụ̃ ní ívé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi zịzú ímụ́zú ꞌí vúgá nõó, ĩri ní ũkpõ sẽzú kộpi ní, kộpi ã údrókí rí índrí ũnjí rĩ pi ãní, ãzini kộpi ẽ ídríkí rí ꞌbá drã be ãndíãndí rĩ pi ãní. ");
INSERT INTO kbo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ĩri ní kộpi pẽzú mụzú mãlũngã Múngú vé rĩ ã tã ũlũzú ꞌbá rĩ pi ní, ãzini kộpi ẽ ídríkí ꞌbá drã be rĩ pi. ");
INSERT INTO kbo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yẹ́sụ̃ ní ꞌyozú kộpi ní kĩnĩ, “Ã ꞌdụkí túré, kũmvũ, ãnyãngã, mũfẽngã mụzú ĩndĩ ku, ãzini ã ꞌdụkí bõngó ãzi ãndõ rú mụzú ĩndĩ ku. ");
INSERT INTO kbo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ꞌBẹ̃tị́ ĩmi ní cazú ꞌa ni gé rĩ, lẽ ĩmi áwíkí adrií ꞌbẹ̃tị́ ꞌdãri agá cĩmgbá ụ́ꞌdụ́ ĩmi ní fũzú kụ̃rụ́ ꞌdãri agásĩ rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ꞌBá rĩ pi gãkí dõ ĩmi ẹ́ꞌyị́gá sĩ, ĩmi kádõ fũú kộpivé kụ̃rụ́ agásĩ, ĩmi wekí nyọ̃ọ́kụ́ ĩmî pá ágélé gá rĩ kú ꞌdĩgé, ĩri lũ ꞌyozú kínĩ, ĩmi kukí kộpi ní tã ũnjí gí.” ");
INSERT INTO kbo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kúru kộpi ní ꞌdezú rizú ẹ́cị́zú gụ́rụ́ rĩ pi agásĩ, kộpi rikí ụ́ꞌdụ́kọ́ múké Múngú vé rĩ ũlũú mụzú, ãzini ꞌbá drã be rĩ pi ídrí mụzú ãngũ rĩ pi agásĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ẽródẽ kã tã ãyãzú ãyãyã Yẹ́sụ̃ ní rií ꞌoó rĩ yịị́, drị̃ ni ábá ãní céré céré, ãꞌdiãtãsĩyã ꞌbá ụrụkọꞌbée kínĩ, Yũwánĩ bãtízĩmũ sẽépi rĩ íngá gõó ídri rú nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ụrụkọꞌbée kínĩ, ꞌbá rĩ Ẽlíyã ímụ́ nĩ, ụrụkọꞌbée kínĩ, ꞌbá rĩ nẹ́bị̃ ọ́tụ́ ị́nọ́gọ́sị́ rĩ pi vé ãlu íngá gõó ídri rú nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ꞌBo Ẽródẽ ní ꞌyozú kĩnĩ, “Á lị Yũwánĩ ẽ drị̃ gí pírí, ꞌbá má ní tã ni yịị́ ꞌdĩri ãꞌdi ꞌi?” Ẽródẽ ụ̃ꞌbị̃ ũkpõ sĩ, lẽ Yẹ́sụ̃ rĩ ndreé. ");
INSERT INTO kbo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi kâ ímví ĩgõó, kộpi ũlũkí tã ĩ ní ꞌoó rĩ pi ãrẽvú céré Yẹ́sụ̃ ní. Kúru Yẹ́sụ̃ pi ní ngazú fũzú ꞌbá rĩ pi ãsámvú gé sĩ, kộpi ní ꞌdezú mụzú kụ̃rụ́ Bẽtẽsãyídã vé rĩ gé. ");
INSERT INTO kbo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ꞌBo ꞌbá bị́trị́ká rĩ pi kâ vũrã Yẹ́sụ̃ ní mụzú rĩ nị̃ị́ ámá, kộpi ꞌdekí mụụ́ vú ni gé sĩ. Ĩri ní kộpi ẹ́ꞌyị́zú, ĩri ní mãlũngã Múngú vé rĩ ã tã ũlũzú kộpi ní, ĩri ní ꞌbá drã be rĩ pi ídrízú. ");
INSERT INTO kbo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ụ̃tụ́ rĩ kã ꞌbãá rií ꞌdeé, Yẹ́sụ̃ vé ꞌbá áyúãyũ mụdrị́ drị̃ ni ị̃rị̃ rĩ pi ní ímụ́zú Yẹ́sụ̃ vúgá, kộpi ní ꞌyozú ĩri ní kínĩ, “ꞌÍ pẽ ꞌbá bị́trị́ká ꞌdĩꞌbée mụụ́ gụ́rụ́ ĩnyiŋá rĩ pi agásĩ, ãzini ãngũ rĩ agásĩ, kộpi ã mụkí ĩ ní ãnyãngã ndãá, ãzini vũrã lazú ni ndãá, ãꞌdiãtãsĩyã ngá nyanya nõgó ꞌdãáyo, ãzini vũrã lazú ni nõgó ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi sẽkí kộpi ní ngá nyanya, kộpi ã nyakí.” ꞌBá áyúãyũ rĩ pi ní újázú kínĩ, “Ngá ꞌbá vúgá nõgó rĩ ꞌyéŋá pánga tọ̃wụ́, ị̃ꞌbị́ be ị̃rị̃. ꞌBá lẽkí dõ ꞌbá bị́trị́ká nõꞌbée ã nyakí ngá, lẽ ꞌbâ mụkí kộpi ní ãnyãngã jeé.” ");
INSERT INTO kbo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ãgõ rĩ pi ícó ca élĩfũ tọ̃wụ́ rá. Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, “Ĩmi ꞌbãkí ꞌbá rĩ pi úrí ngúlúmũ rú, pụ̃kụ́ tọ̃wụ́ pụ̃kụ́ tọ̃wụ́.” ");
INSERT INTO kbo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kộpi ní ꞌozú sụ̃ Yẹ́sụ̃ ní ꞌyoó rĩ tị́nị, kộpi ní ꞌbá rĩ pi ꞌbãzú úrízú céré vũgá. ");
INSERT INTO kbo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yẹ́sụ̃ ní pánga tọ̃wụ́ rĩ pi íꞌdụ́zú ị̃ꞌbị́ ị̃rị̃ rĩ be, ĩri ní ãngũ ndrezú ụrụ, ĩri ní õwõꞌdĩfô sẽzú, ĩri ní kộpi ũndĩzú, ĩri ní sẽzú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní, kộpi ã awakí ꞌbá rĩ pi ní. ");
INSERT INTO kbo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ꞌBá rĩ pi ãrẽvú céré nyakí, kộpi ẹ́pị́kí ãní rá, ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ĩkũnãkí ngá ĩ ní nyaá tí rĩ ẽ ị̃mbị́tã caá ũvú ã ꞌa mụdrị́ drị̃ ni ị̃rị̃. ");
INSERT INTO kbo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ụ́ꞌdụ́ ãlu, Yẹ́sụ̃ ri Múngú ri zịị́ ọ́ꞌdụ́kụ́lẹgúsĩ, ĩrivé ꞌbá ĩri ã pámvú ũbĩꞌbá rĩ pi rikí adrií ĩri be trụ́, ĩri ní kộpi zịzú kĩnĩ, “ꞌBá rĩ pi ri ꞌyo, ma ãꞌdi ꞌi?” ");
INSERT INTO kbo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kộpi ní újázú kínĩ, “ꞌBá ụrụkọ kínĩ, mi Yũwánĩ Bãtízĩmũ sẽépi rĩ ꞌi. Ụrụkọꞌbée kínĩ, mi Ẽlíyã ꞌi. Ụrụkọꞌbée kínĩ, mi nẹ́bị̃ ọ́tụ́ ị́nọ́gọ́sị́ ũdrãꞌbá gí rĩ pi vé ãlu íngá gõó ídri rú nĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kúru ĩri ní kộpi zịzú kĩnĩ, “ꞌBo ĩmi ní ụ̃sụ̃zú rĩ gé, ma ãꞌdi ꞌi?” Pétẽró ní újázú kĩnĩ, “Mi Kúrísítõ ꞌi, Múngú ní ĩpẽé rĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yẹ́sụ̃ átá kộpi ní ũkpó ũkpó kĩnĩ, kộpi ã lũkí tã ꞌdĩri ꞌbá ãzi ní ku. ");
INSERT INTO kbo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ma ꞌBá Mvá ꞌi, ma ímụ́ ĩzãngã nya lẹ́tị be ãndíãndí, ꞌbá ambugu rĩ pi, atala atala rĩ pi drị̃gé rĩ pi, ãzini ꞌbá tãị́mbị́ ímbáꞌbá rĩ pi be céré ímụ́ ma gã sĩ, kộpi ma ꞌdị drã rá, ꞌbo ụ́ꞌdụ́ na ni gé, ĩ ma inga gõ ídri rú ũzi.” ");
INSERT INTO kbo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kúru Yẹ́sụ̃ ní ꞌyozú ꞌbá bị́trị́ká rĩ pi ní kĩnĩ, “ꞌBá rĩ lẽ dõ mâ pámvú ũbĩí, ã adi ꞌî rụ́ꞌbá, ụ́ꞌdụ́ céré ã ꞌdụ ívé pẹtị alambaku, ã ũbĩ mâ pámvú. ");
INSERT INTO kbo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ꞌBá lẽépi ívé ídri rụ́ꞌbá nõri vé rĩ ã tã mbaápi áyu rĩ, ĩri api ídri ꞌdániꞌdáni rĩ sĩ rá. ꞌBo ꞌbá ívé ídri rụ́ꞌbá nõri vé rĩ adiípi, drãápi mâ tã sĩ rĩ, ĩri ídri ꞌdániꞌdáni rĩ ị́sụ́ rá. ");
INSERT INTO kbo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ꞌBá rĩ ị́sụ́ dõ ngá nyọ̃ọ́kụ́ drị̃gé nõgó rĩ pi ãrẽvú céré, api dõ ídri ꞌdániꞌdáni rĩ sĩ rá, tã múké ĩri ní ị́sụ́ ꞌa ni gé ꞌdĩgé rĩ ãꞌdi? ");
INSERT INTO kbo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ꞌBá rĩ ẽ drị̃ ri dõ nja má sĩ, ãzini átángá má ní rií átá rĩ sĩ, Ma ꞌBá Mvá ꞌi, má kãdõ ímụ́ dị̃ngárá be pọ̃wụ̃pọ̃wụ̃, ãzini má Ẹ́tẹ́pị vé dị̃ngárá pọ̃wụ̃pọ̃wụ̃ rĩ be, ãzini mãlãyíkã uletere rĩ pi vé dị̃ngárá be, ma kpá adri ĩri sĩ drị̃njá sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ádarú á lẽ ꞌyoó ĩmi ní ꞌdíni, ꞌbá pá tuꞌbá nõꞌbée ãsámvú gé, ꞌbá ụrụkọꞌbée ícókí drĩ ũdrãá ku, kộpi mãlũngã Múngú vé rĩ ndre ũgbále.” ");
INSERT INTO kbo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tã Yẹ́sụ̃ ní átá ꞌdĩri ã vụ́drị̃ kã caá ụ́ꞌdụ́ ãrõ, ĩri ní tụzú mụzú írã drị̃gé Múngú ri zịzú, jị Pétẽró pi Yũwánĩ be Yõkóbũ sĩ mụzú ꞌí vúgá sĩ ĩndĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yẹ́sụ̃ kã rií Múngú ri zịị́, ẹndrẹtị ni újá ꞌi, dị̃ ọ́gụ́ ũꞌdũ be túngú, ĩrivé bõngó gõ ꞌi újá imvesírílílí, dị̃ ọ́gụ́ pọ̃wụ̃pọ̃wụ̃. ");
INSERT INTO kbo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mósẽ pi Ẽlíyã be rikí átá ĩri be, ");
INSERT INTO kbo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kộpi ã rụ́ꞌbá dị̃ ọ́gụ́ pọ̃wụ̃pọ̃wụ̃. Kộpi rikí drãngárá Yẹ́sụ̃ ní úmvúlésĩ ímụ́zú drãzú Yẹ̃rụ́sãlémã gá rĩ vé tã átá, tã Múngú ní ụ̃tị̃ị́ gí rĩ, ã nga rí ꞌi fũú tị ni gé bẽnĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pétẽró pi ꞌí ọ̃gụ̃pị́ị be, ụ́ꞌdụ́ ꞌbe kộpi ẽ tị, kộpi kâ aruú ụ́ꞌdụ́ gélésĩ, kộpi ndrekí Yẹ́sụ̃ vé dị̃ngárá pọ̃wụ̃pọ̃wụ̃ rĩ, ãzini ndrekí ꞌbá ị̃rị̃ tukí pá kuú ĩri be trụ́. ");
INSERT INTO kbo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mósẽ pi Ẽlíyã be, kộpi kâ lẽé mụụ́, Pétẽró ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ĩri múké ꞌbá ní adrizú nõgó. Lẽ ꞌbâ ꞌbekí mõrõgó na, ãlu ni mí ní, ãlu ni Mósẽ ní, ãlu ni Ẽlíyã ní.” ꞌBo Pétẽró nị̃ tã ꞌí ní átá rĩ vé ífífí kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pétẽró kã rií tã rĩ átá, ị́rị́bị́tị ní ímụ́zú kộpi ọ̃zụ̃zú, ụ̃rị̃ fụ Yẹ́sụ̃ vé ꞌbá áyúãyũ rĩ pi rá, ị́rị́bị́tị rĩ ní kộpi ọ̃zụ̃ụ́ rĩ sĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ụ́ꞌdụ́kọ́ ní átázú ị́rị́bị́tị rĩ agá ꞌdãá, ĩri ní ꞌyozú kĩnĩ, “Mvá ꞌdĩri mávé ni, má ĩpẽ ĩri nĩ, lẽ ĩmi yịkí tị ni yịyị!” ");
INSERT INTO kbo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ụ́ꞌdụ́kọ́ átápi rĩ kã újí, kộpi ndrekí Yẹ́sụ̃ ri ọ́ꞌdụ́kụ́lẹ. Kộpi újíkí kuú tã ꞌdĩri be ĩ ẹ́sị́ agá, kộpi lũkí tã ĩ ní ndreé ꞌdĩri ꞌbá ãzi ní ãluŋáni kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kã adrií drụ̃ ụ̃ꞌbụ́tị, kộpi kâ ísị́ írã rĩ drị̃gé ꞌdãásĩ vũgá nõó, ꞌbá bị́trị́ká ímụ́kí Yẹ́sụ̃ vúgá nõó. ");
INSERT INTO kbo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ágó ãzi ꞌbá bị́trị́ká rĩ pi ãsámvú gé ꞌdãá, ĩri ní Yẹ́sụ̃ ri zịzú ụ́ꞌdụ́kọ́ be ụrụ ꞌdãá kĩnĩ, “Ímbápi, á mã mi drị́ ị̃rị̃ sĩ, ꞌí ndre mávé mvá, ꞌí ko ĩri ẽ ĩzã, ãꞌdiãtãsĩyã mávé mvá ꞌyéŋá ãlukúta ꞌdĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Índrí ũnjí rĩ kãdõ mváŋá rĩ ꞌdụụ́ aꞌbeé, ĩri útré, ụ́ꞌbụ́rụ́sã rĩ kpu tị ni gé sĩ. Índrí ũnjí rĩ ĩri nyi ũnjí ũnjí, ku ĩri mbẽlẽ ku. ");
INSERT INTO kbo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Á mã mívé ꞌbá mî pámvú ũbĩꞌbá rĩ pi ímụ́ índrí ũnjí rĩ droó fũú mvá rĩ drị̃gé sĩ rá, ꞌbo kộpi ícókí droó bã ku.” ");
INSERT INTO kbo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ꞌbá tã ꞌoꞌbá pịrị ku, ẹ̃ꞌyị̃ngárá ãkó ꞌdĩꞌbée, mâ adri rí ĩmi be vụ̃ụ́ lókí be gbã ngõpí? Mâ ẹ́sị́ ẽ ị́sụ́ rí ĩzãngã ĩmivé tã sĩ vụ̃ụ́ lókí be gbã ngõpí?” Kúru Yẹ́sụ̃ ní ꞌyozú ágó rĩ ní kĩnĩ, “Mí íjị́ mívé mvá rĩ ímụ́ má vúgá nõó.” ");
INSERT INTO kbo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mvá rĩ kã rií ímụ́ Yẹ́sụ̃ vúgá nõó, índrí ũnjí rĩ ꞌdụ ĩri aꞌbeé, ri ĩri nyií vũgá ꞌdĩgé, ꞌbo Yẹ́sụ̃ ní trezú índrí ũnjí rĩ drị̃gé, ĩri ní mvá rĩ ídrízú, ĩri ní sẽzú gõzú ẹ́tẹ́pị vúgá ꞌdãá. ");
INSERT INTO kbo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ꞌBá rĩ pi ãrẽvú céré ãyãkí ãyãyã ũkpõ Múngú vé ꞌdĩri sĩ. ꞌBá rĩ pi kâ ãyãá tã Yẹ́sụ̃ ní ꞌoó ꞌdĩri sĩ, Yẹ́sụ̃ ní ꞌyozú ívé ꞌbá ꞌî pámvú ũbĩꞌbá rĩ pi ní kĩnĩ, ");
INSERT INTO kbo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ĩmi ꞌbãkí bị́ átángá má ní lẽé ꞌyoó rĩ yịzú, Ma ꞌBá Mvá ꞌi, ĩ ímụ́ mâ ũli ꞌbe, ĩ ímụ́ ma sẽ mávé ariꞌba rĩ pi drị́gé.” ");
INSERT INTO kbo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ꞌBo ꞌbá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi nị̃kí tã ĩri ní ꞌyoó ꞌdĩri vé ífífí kuyé. Múngú úcí kộpi ní tã rĩ vé ífífí úcícĩ, kộpi ã nị̃kí rí tã Yẹ́sụ̃ ní ꞌyoó rĩ ku, kộpi ꞌokí ụ̃rị̃ sĩ, zịkí tã rĩ vé ífífí kuyé. ");
INSERT INTO kbo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ꞌBá Yẹ́sụ̃ ã pámvú ũbĩꞌbá rĩ pi ní íꞌdózú ãgátá gãzú ĩ ãsámvú gé sĩ kínĩ, ĩ ãsámvú gé ꞌdĩgé, ãꞌdi ri adri ãmbúgú nĩ. ");
INSERT INTO kbo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ꞌBo Yẹ́sụ̃ nị̃ tã kộpi ní rií ụ̃sụ̃ụ́ ĩ ẹ́sị́ agá ꞌdãlé rĩ rá, ĩri ní mváŋá mãdãŋá ni íjị́zú pá tuzú ꞌí jẽlé gá. ");
INSERT INTO kbo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kúru ĩri ní ꞌyozú kộpi ní kĩnĩ, “ꞌBá mváŋá mãdãŋá nõri ẹ́ꞌyị́pi mâ rụ́ sĩ rĩ, ẹ́ꞌyị́ ꞌdĩri ma. ꞌBá ma ẹ́ꞌyị́pi rĩ, ẹ́ꞌyị́ ꞌdĩri ꞌbá ma ĩpẽépi rĩ. Ĩmi ãsámvú gé ꞌdĩgé, ꞌbá ĩ ní ndreé kuú ẹ̃zị́ ãkó rĩ, ĩri adri ãmbúgú nĩ.” ");
INSERT INTO kbo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yũwánĩ ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Ímbápi, ꞌbá ndrekí ꞌbá ãzi ri índrí ũnjí rĩ pi údró ũfũ ꞌbá rĩ pi drị̃gé sĩ mî rụ́ sĩ, ꞌbo ꞌbá ugakí ĩri sĩ, ãꞌdiãtãsĩyã adri ꞌbávé ọ́gụ́pị ku.” ");
INSERT INTO kbo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Ĩmi ugakí ĩri ku, ãꞌdiãtãsĩyã ꞌbá ĩmi ꞌoópi ũnjí ku rĩ, ĩri ĩmi ọ́gụ́pị.” ");
INSERT INTO kbo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sâ ĩ ní lẽzú Yẹ́sụ̃ ri ꞌdụzú mụzú ꞌbụ̃ gé rĩ kã ícá ĩnyiŋá gí, Yẹ́sụ̃ ꞌbã ẹ́sị́ lẽzú mụzú Yẹ̃rụ́sãlémã gá. ");
INSERT INTO kbo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ĩri ní ꞌbá áyúãyũ ni pi pẽzú mụzú drị̃drị̃, kộpi ã mụkí gụ́rụ́ Sãmãríyã vé rĩ agá ꞌí ní vũrã údé. ");
INSERT INTO kbo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ꞌBo ꞌbá ꞌdãlé rĩ pi ẹ́ꞌyị́kí ĩri kuyé, ãꞌdiãtãsĩyã ĩri ri mụ Yẹ̃rụ́sãlémã gá. ");
INSERT INTO kbo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yẹ́sụ̃ vé ꞌbá ĩri ã pámvú ũbĩꞌbá Yõkóbũ pi Yũwánĩ be, kộpi kâ tã ꞌi ngaápi ꞌdĩri yịị́, kộpi ní Yẹ́sụ̃ ri zịzú kínĩ, “Úpí, mí ãꞌyĩ rá, ꞌbâ zịkí ãcí ꞌbụ̃ gé ꞌdãásĩ ímụ́ ꞌbá ꞌdĩꞌbée úꞌdị́ ũdrãá?” ");
INSERT INTO kbo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ꞌBo Yẹ́sụ̃ ní ꞌi újázú, ĩri ní trezú kộpi drị̃gé. ");
INSERT INTO kbo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kúru kộpi ní ꞌdezú mụzú gụ́rụ́ ãzi gé. ");
INSERT INTO kbo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yẹ́sụ̃ pi kâ rií mụụ́ lẹ́tị agásĩ, ágó ãzi ní ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Á lẽ mî pámvú ũbĩí cĩmgbá cazú vũrã mí ní mụzú rĩ gé.” ");
INSERT INTO kbo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yẹ́sụ̃ ní ꞌyozú kĩnĩ, “Mgbũwá rĩ pi vũrã lazú ni be, ãríŋá rĩ pi jó lazú ni be, ꞌbo ma ꞌBá Mvá ꞌi, vũrã má ní mâ drị̃ suzú adrizú ni ꞌdãáyo.” ");
INSERT INTO kbo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yẹ́sụ̃ ní gõzú ꞌyozú ágó ãzi ní kĩnĩ, “Mí ímụ́ mâ pámvú ũbĩí.” ꞌBo ágó rĩ ní újázú kĩnĩ, “Úpí, ꞌí sẽ mâ mụ drĩ má ẹ́tẹ́pị ri sị̃ị́ ũgbále ká.” ");
INSERT INTO kbo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yẹ́sụ̃ ní újázú ágó rĩ ní kĩnĩ, “ꞌÍ ku ꞌbá ũdrãꞌbá gí rĩ pi ã mụkí ĩvé ꞌbá ũdrãꞌbá gí rĩ pi sị̃ngárá gá, ꞌbo ꞌí mụ mãlũngã Múngú vé rĩ vé tã ũlũú.” ");
INSERT INTO kbo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ꞌBá ãzi ní kpá ꞌyozú Yẹ́sụ̃ ní kĩnĩ, “Úpí, ma mî pámvú ũbĩ rá, ꞌbo ꞌí ku mâ gõ drĩ mụụ́ tã ẹzịị́ mávé ꞌbá ꞌbẹ̃tị́ ãsámvú gé rĩ pi ní ũgbále ká.” ");
INSERT INTO kbo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yẹ́sụ̃ ní újázú ĩri ní kĩnĩ, “ꞌBá íꞌdópi ọ́mvụ́ ꞌaápi, ãngũ ndreépi vúlé rĩ, ícó mãlũngã Múngú vé rĩ gé ku.” ");
INSERT INTO kbo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tã ꞌdĩri ã vụ́drị̃ gé, Úpí ní ꞌbá ụrụkọ ũpẽzú pụ̃kụ́ ẹ́zị̂rị̃ drị̃ ni ị̃rị̃, pẽ kộpi mụzú ị̃rị̃ ị̃rị̃, pẽ kộpi mụzú drị̃drị̃ kụ̃rụ́ ꞌí ní lẽé mụụ́ rĩ pi agá, ãzini gụ́rụ́ ꞌí ní lẽé mụụ́ rĩ pi agá. ");
INSERT INTO kbo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ĩri ní ꞌyozú kộpi ní kĩnĩ, “Ãnyãngã rĩ ka kú ambamba, ꞌbo ꞌbá ãnyãngã rĩ ĩkũnãꞌbá rĩ pi vé kãlãfe mãdãŋá. Ĩmi mãkí ãnyãngã rĩ vé ẹ́ꞌdị́pa Úpí ri, ã pẽ rí ꞌbá ẹ̃zị́ ngaꞌbá ni pi m