﻿USE sofia;
DROP TABLE IF EXISTS sofia.kbm_vpl;
CREATE TABLE kbm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kbm_vpl WRITE;
INSERT INTO kbm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yisu ane luev ebe tine gikuv ok dang-eteik, Dawit ane vaku Yisu, be Ablaham ane vaku Dawit, be givang mul ve atengge ve gile ");
INSERT INTO kbm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","16","Malia gikuv Yisu be Yisu ei Amol ebe Pomate geb ve nemb amolmol ru ok, be Josep tame Jekop, be Jekop tame Matan, be Matan tame Eliesa, be Eliesa tame Eliat. Eliat tame Ekin, be Ekin tame Sedok, be Sedok tame Eso, be Eso tame Eliakim, be Eliakim tame Abiat, be Abiat tame Serababel, be Serababel tame Sialtial, be Sialtial tame Jekonaia. Be givin etok amolmol nangge Isrel be tis Jekonaia tis malenggen ile imbweg kapual-lu nangge nam bamo Babilon, be Jekonaia tame Josia. Be Josia tame Emos, be Emos tame Manasa, be Manasa tame Hesekia, be Hesekia tame Ehas, be Ehas tame Jotam, be Jotam tame Asaia, be Asaia tame Joram, be Joram tame Jihosafat, be Jihosafat tame Esa, be Esa tame Abaisa, be Abaisa tame Riaboam be Riaboam tame Solomon, Devit girwel Yuria arue bekob ei gikuv Solomon. Be Solomon tame Devit ebe geb Isrel dabin ok. Devit tame Jesi, be Jesi tame Obet, be Rut gikuv Obet. Obet tame Boas, be Rehap gikuv Boas. Be Boas tame Salmon, be Salmon tame Nason, be Nason tame Aminadap, be Aminadap tame Ram, be Ram tame Hesron, be Hesron tame Peres, Tema gikuv Peres gabu Sara. Be Peres tame Juda, be Juda nok tis malenggen tamas Jakop. Be Jakop tame Isak, be Isak tame Ebraham. ");
INSERT INTO kbm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Be Ablaham natunggen as natusgen weik etok ge gile gitangi bulwer 14, be Devit natunggen as natusgen weik etok ge gile gitangi bulwer 14 be ile imbweg kapual-lu nangge Babilon. Be eisir ete imbweg kapual-lu ok natusgen as natusgen weik etok ge gile gitangi bulwer 14 be Malia gikuv Amol ebe Pomate geb ve nemb amolmol ru ok. ");
INSERT INTO kbm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Malia gikuv Yisu Kilisi ane luev dang eteik. Yisu tine Malia be amolmol bambamo inei Malia nok ane yaun ve atob nemb Josep, bemem sulu emb isate ite nangge. (Be Malia ande gitpweng are gikwai ginei atob ei nikuv nunus ti, ve Pomate ane Ngalau Yamar gilgum gen bambo etok gitangi ei). ");
INSERT INTO kbm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ei amol vie be as-mate walang ok ei gilgum gen gitangi ebe amolmol ili vie ane ok ge, be ei ginei bwat Malia gili amol ti beti ei bua ve ret nilgum Malia maimae beti veve nitin ei bwaya-gege. ");
INSERT INTO kbm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep ta gitung yaun etok giengk aplo ge givang be Pomate gisu mev gitangi ei be geb ane ngalau kulkul ane ti gitangi Josep gile be ginei, “Josep, Dawit ane vaku mie. Tam itung walang ano bwaya be omb Malia ve am avie, ve nunus ete giengk Malia subwe aplo ok, etok Pomate ane Ngalau Yamar ane gwangne geb gitangi ei. ");
INSERT INTO kbm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Atob ei nikuv nunus amol ti be mie nutal nunus etok are Yisu, ve atob Ei nikaiwel ane amolmol-gen inkwai gen tiate aplo.” ");
INSERT INTO kbm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gen bambamo etok atob ano nile dang ebe warik Pomate ginei gitangi ane amol ebe ginei Pomate avo ok, ");
INSERT INTO kbm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ve avie vuivuei ti atob tis ta be nikuv nunus amol ti be atob intal are inei Emanyuel.” Emanyuel ane dabe dang eteik Pomate givang givin eitit. ");
INSERT INTO kbm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep gimdil be gile gigas arue Maria ginme gibweg givin ei, gitangi ebe galkik Pomate ane ngalau kulkul ane ginei gitangi ei ok, ");
INSERT INTO kbm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bemem Josep giyamar ate be givang givin arue ite love Malia gikuv nunus nok be Josep gital are ginei Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malia gikuv Yisu nangge Betlehem nangge Judia as taku, givin ebe amol bamo Herodes geb amolmol dabin ok. Be bwayage kob amolmol bambamo subu nangge as giru ebe ili viteukawe be kakie gipil gipil ok, ili viteukawe vaku ti mang-gihlang be imdil ile ve indi ane ano. ");
INSERT INTO kbm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Eisir imbielk Jerusalem be iutani amolmol be inei, “Wali nunus amol ebe atob nemb amolmol dabin nangge Juda ok giengk inend? Amei ali ei ane viteukawe vaku meng-gihlang givin ebe ambweg as gireu ok, be amei atpweng are anei amol bamo ti (King) ebe ve nemb amolmol dabin ok, ande meng-gihlang, beti amei anme ve anro vangg-amei dubi supwe be anei uye be anes miengk nitangi ei.” ");
INSERT INTO kbm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Givin ebe Herodes giute yaun etok ok be gikuri vunungge be aplo bunam ve atob amol vaku etok ninggas ei ane amolmolgen, be amolmol tepwengge nangge Jerusalem ok ikuri givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes geb yaun ve bambamo ebe emb lum yamar bamo dabin ok be tis didung subu ebe emb Mose ane yaun dabin ok, be ile ipil dongke be giutani eisir be ginei, “Wali Mesia amol ebe Pomate geb ve nemb amolmol ru nangge Judia ok, atob tine nikuv nangge inend?” ");
INSERT INTO kbm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Be eisir iwel Herodes avo be inei, “Nunus etok atob tine nikuv nangge Betlehem nangge Juda as taku. Be gen etenik gitangi yaun ebe warik Pomate ane amol ebe ginei Pomate avo ok, giro ok, ");
INSERT INTO kbm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ve amolmol nangge Betlehem ebe imbweg Juda as taku ok, yem gitangi ebe atob untau unde Juda as amol bamo ebe geb amolmol dabin ok ite, ve amol ti atob menihlang nangge yem, be amol nok atob menihlang weik amol bamo ti be atob Ei nemb awangg amolmol Israel ane dabin.’” ");
INSERT INTO kbm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Beti Herot geb yaun ve amolmol bambamo ebe nangge as gireu ok bwaya-gege ve intangi ei inde be niutani eisir ve asger eisir ili nunus etok ane viteukawe ebe meng-gihlang ok. Herodes giutani eisir ve nitpweng are ve nunus etok ane aiweng aivir ande gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bekob gihlin eisir ve inde Betlehem be ginei gitangi eisir be ginei, “Yem unde be unrek nunus etok love ginei ule vunge ve nunus nok okob unemb yaun nitangi ayeu ninme ve ayeu ok ve nali ei be nanei uye be nas miengk nitangi ei nivin.” ");
INSERT INTO kbm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Amolmol bambamo ebe nangge as gireu ok iute Herodes ane yaun gikwai be ile, be viteukawe ebe eisir ili nangge as gireu ok, viteukawe nok gimungg be eisir itau ile, love viteukawe etok gile givarkei nam ebe Yisu giengk ok dobo. ");
INSERT INTO kbm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eisiri ili viteukawe ebe gile givarkei nam ebe Yisu giengk ok dobo be tas veviasge. ");
INSERT INTO kbm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Be isov nam aplo ile be ili Malia gabu natu Yisu imbweg be iro vas dubi supwe gitangi Yisu be inei uye be es miengk gitangi ei gikwai kob ivier gol be tis ei tui ukwas ukwas subu be marasin ukwas subu givin nangge as vak be emb gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Givin tambok Pomate gisu mev gitangi eisir ve indumul inde be inei Yisu binge nitangi Herodes bwaya, beti eisir imdil be ivang luev ti ile ve ivang as nam ane. ");
INSERT INTO kbm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Amolmol bambamo ebe nangge as gireu ok ivang ikwai kob Josep giengk mev be Pomate ane ngalau kulkul ane ti ginme be ginei gitangi ei, “Umdil be unggas Malia gabu natu be unpelk unde unambweg Isip love ayeu nanei kob yem unkwai Isip. Ve Herodes gilgum ve ninei yaun nitangi ane amolmol valir ane ve inrek mie natum vaku ebe tine gikuv ok be ines vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep gimdil seukie-ngge be gigas Malia gabu natu be ivang tambok ile Isip. ");
INSERT INTO kbm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Malia gabu natu Yisu be Josep imbweb Isip love Herodes gimat vunu gikwai kob, be yaun ebe warik Pomate ginei gitangi ane amol ebe ginei ei avo ok, ano gile. Ve Pomate ginei, “Ayeu gagas Natungg gikwai Aigipten.” ");
INSERT INTO kbm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Givin ebe Herodes gitpweng are ve amolmol bambamo ebe nangge as gireu iyo ei ok, beti ei ta vavis anongge be gihlin ane amolmolgen ve inde be ines nunus amol ebe as Sonda bamo gitangi ailu ok be tis eisir ebe as Sonda bamo ma nangge ok, tepwengge vun-kunu nangge Betlehem be tis nam dabe subu ebe gibloblo Betlehem ok nivin. Ve ei giute aiweng ebe Yisu ane viteukawe meng-gihlang ok bing gikwai ve nolge Sonda bamo ailu gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Beti yaun ebe warik Pomate ane amol ebe ginei ei avo ok are Jelemia ginei ok ande ano gile dang eteik. ");
INSERT INTO kbm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Amolmol iteng tangir bwal nangge Rama, be ingas bunam be yayai be avos bambamo-ngge. Be Resel giteng ve natunggen ane be amolmol ilgum ve emb bing bwaibwaya gitangi ei, bemem gitangi ite. Ve ei natunggen tepwengge imat vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes gimat vunu gikwai kob Josep giengk mev nangge Aigipten be Pomate ane ngalau kulkul ane ti gitangi ei gile, ");
INSERT INTO kbm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","be ginei, “Umdil be unggas Malia gabu natu be undumul unde Isrel as taku, ve Herodes ebe gilgum ve ines nunus vunkunu ok, ande gimat vunu gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep gimdil be gigas Malia gabu natu be ilumul ile Isrel as taku. ");
INSERT INTO kbm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep giute ebe Akeleas giwel tame Herodes be gigas tame ane kulkul ok binge be gipelk ve tis natunggen inambweg ete Juda as taku ok, bekob ete Pomate gisu mev ti gitangi Josep be ginei gitangi ei ve ninggas Yisu gabu tine be invang Galili ane. ");
INSERT INTO kbm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Josep tis natunggen ile ihlang nam dabe ti are Nasaret be imbweg etok, gitangi ebe warik amolmol ebe inei Pomate avo be inei yaun gipil Yisu ok, be yaun nok ande ano gile, “Ve atob amolmol intal ei inei amol Nasaret ane.” ");
INSERT INTO kbm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Givin ebe Jon ebe ges bui sanggu gipil amolmol ok meng-gihlang be ginei mateu givang taku sawa ebe Juda as taku ok, ");
INSERT INTO kbm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","be ginei gitangi amolmol be ginei, “Unro aim ate vukir unkwai tiate aplo ve gibloblo ve Pomate nemb amolmol dabin.” ");
INSERT INTO kbm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ebe ges bui sanggu gipil amolmol ok ei amol etok ebe warik amol ti are Aisaia ebe ginei Pomate avo ok ginei yaun gipil ok. Ve Aisaia ginei dangeteik; “Amol ti atob nital yaun nangge taku sawa be ninei, ‘Unpasang Amol Bamo ane luev ebe ve nivang ok vevie.’” ");
INSERT INTO kbm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ei ate gino kup vei ti ite, ei gino kup ebe ipasang ve bwelk kamel buplu ok be gibitit bika bwelk ulis gibagi luvwe pale, be gen sapauk tis munei ve ane ben. ");
INSERT INTO kbm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jon givang taku sawa etok bekob amolmol nangge nam bamo Jerusalem be nangge Juda as taku, be nange taku Jodan ane, iro isate sut itangi ei ile, ");
INSERT INTO kbm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","be inei as tiate vusa gitang ei bekob ges bui sanggu gipil eisir nangge bui Jodan. ");
INSERT INTO kbm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon gili Farisai subu be tis Sadukai subu ebe itangi ei ile ve nes bui sanggu nipil eisir ok, beti ginei yaun gwangne molge gitangi eisir be ginei, “Ret ginei beti yem upelk ve gen bunam ete asonge Pmate nemb nitangi yem ok. Yem amolmol tiate ane. Ret ginei beti usu aim ate sin-ge utangi ayeu unme ve nas bui sanggu nipil aim? ");
INSERT INTO kbm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yem unro aim ate vukir unkwai tiate aplo be unalgum gen weik ebe amolmol vie ane ok okob, veik amolmol indi yem aim gen vie ebe ulgum ok. ");
INSERT INTO kbm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yem unei bwat Ablaham ane dani yem beti etok weik ebe Pomate ane amolmol-gen yem ok, bemem etok gitangi ite. Pomate gitangi ebe atob nipasang vat bambamo etenik be menihlang weik Ablaham natu-nggen ok.” ");
INSERT INTO kbm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jon ginei yaun gitangi Parisai tis Sadukai be ginei, “Yem weik ben ebe givarkei um ok ve atob um tivie nile be nili ane ben etok anos ma kob atob nivwat buyag nile be nispe ben etok gilkili be nikari nireu yev nile. ");
INSERT INTO kbm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ayeu gas bui sanggu gipil yem ve bui sin-ge ve nes ru nitangi amolmol ve yem ande uro aim ate vukir be uvkir dumangg aim gitangi gen tiate gikwai, bemem amol ete atob nivang mul ve ayeu be ninme ok amol etok ane gwangne gitlek awangg, be atob nemb Ngalau Yamar ebe ve nisin yem aim gen tiate nikwai ok, nitangi yem. Amol etok ei amol bamo ti be ayeu weik gen sin-ge. ");
INSERT INTO kbm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Amol nok atob ninme be nimbwas amolmol tepwengge, bekob ninggas ane amolmol ebe aplos givin ei ok be atob nitak eisir ebe aplos givin ei ite ok inreu yev bamo ebe giengk dang etok painge-ngge ok inde. ");
INSERT INTO kbm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Givin sawa etok Yisu nangge Galilaia be gitangi Jon gile ve Jon nes bui sanggu nipil Ei nangge bui Jodan. ");
INSERT INTO kbm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bemem Jon gilgum ve nes ate gili beti ginei gitangi Yisu be ginei, “Ginei mie nos bui sanggu nipil ayeu okob vie, be ayeu gitangi ebe ve nas bui sanggu nipil mie ok ite, be nam-nambed be mie gutangi ayeu gunme?” ");
INSERT INTO kbm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bemem Yisu ginei gitangi Jon be ginei, “Nute awangg yaun ge, ve tutlu gitangi tanalgum Pomate ane yaun walang ok ano nile.” Beti Jon giute Yisu ane yaun ge be ges bui sanggu gipil Ei. ");
INSERT INTO kbm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon ges bui sanggu gipil Yisu gikwai kob Yisu gipil gile givarkei bui kire love gili gulumb sawa gisov, be Pomate ane Ngalau Yamar geb na gile mank bubu be gisov ginme giwei Ei. ");
INSERT INTO kbm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Be Pomate ginei yaun ti nangge gulumb, dang eteik, “Ayeu Natungg dongke etenok, ebe gali Ei vie be tangg givin Ei gtlek ok.” ");
INSERT INTO kbm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Givin sawa etok Ngalau Yamar gitwem Yisu gile taku sawa ve Sadam nitpungi Ei. ");
INSERT INTO kbm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yisu givang taku sawa etok gitangi asmate 40 be tambok 40 be gen ben ite love marav ges vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Be Sadam gile gibloblo Yisu be ginei, “Ginei Pomate Natu mie okob nunei be vat bambamo etenik menihlang ve ben be non.” ");
INSERT INTO kbm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yisu giwel Sadam avo be ginei, “Yaun ebe warik Pomate ane amol ebe ginei Pomate avo ginei ok ginei, ‘Ben dongke-ngge giro amolmol ta ite, yaun ebe meng-gihlang nangge Pomate avo ok ete giro amolmol ta givin.’” ");
INSERT INTO kbm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bekob Sadam gigas Yisu be gabu ile taku ebe itav lum yamar bamo givarkei ok be Sadam gitak Yisu gile givarkei giwei lum yamar bamo etok nangge ebe ei-nggoto ok. ");
INSERT INTO kbm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Be ginei gitangi Yisu be ginei, “Ginei mie Pomate Natu okob vepiem usov motak ete nalk ik, be atob nos imate ite ve yaun ebe giengk Pomate ane kapia ok ginei dang-eteik ginei, ‘Atob Pomate nihlin ane ngalau kulkul ane inme be inrun mie itin ve bais veik nutut vam nipil vat etenik bwaya.’ ");
INSERT INTO kbm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Be Yisu giwel Sadam avo be ginei, “Ayeu atob nalgum dang-etenok ite, ve yaun ebe warik Pomate ane amol ebe ginei Pomate avo ginei ok ginei ‘Mie nuhle Pomate miam Pomate ite.’ ");
INSERT INTO kbm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bekob Sadam gigas Yisu vukuri be gabu ireu matendubi undib ti ile. Be Sadam ges taku walang ok tis ane gen vevies tepwengge ru gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bekob ginei, “Ginei mie nusov awangg yaun ane lu ge be nos miengk nitangi ayeu atob ayeu namb gen bambamo etok tepwengge nitangi mie be nomb dabin.” ");
INSERT INTO kbm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yisu giwel Sadam avo be ginei, “Sadam. Ule ukwai. Yaun ebe giengk Pomate ane kapia ok ginei, ‘Nusov am Pomate dongke-ngge ane ayun ane lu be nos miengk nitangi Ei dongke-ngge.’” ");
INSERT INTO kbm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Beti Sadam na vier ve Yisu be gile ve givang be Pomate ane ngalau kulkul ane inme ivang ivin Yisu be emb Ei dabin. ");
INSERT INTO kbm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yisu giute ebe eisir itak Jon gibweg kapual-lu ok binge, be Ei gilumul gile Galilaia. ");
INSERT INTO kbm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ei gikwai Nasaret be gile gibweg Kapanaum gibloblo bui kapul nangge Galilaia nangge Sebulon gabu Naptali as taku. ");
INSERT INTO kbm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Beti yaun ebe warik amol ebe ginei Pomate avo are Aisaia ginei ok ande ano gile. Ve Aisaia ginei dang-eteik: ");
INSERT INTO kbm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebulon gabu Naptali as nalk gile gitangi bui kapul Galili be gile gipil bui Jodan tavlu ane givin. Be nangge Galilaia amolmol anongge nangge taku undib undib ane inme imbweg etok. ");
INSERT INTO kbm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Amolmol ebe imbweg isov aiweng tumi aplo ok atob indi gen bogbogo bamo ti be amolmol ebe ibweg isov taku tiate ebe ve inmate vunu ane ok atob gen bogbogo nok niro eisir.” ");
INSERT INTO kbm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Be givin sawa etok ge ete Yisu geb kulkul vaku-ngge ve ginei mateu gitangi amolmol be ginei, “Unro aim ate vukir unkwai tiate aplo, ve sawa ebe Pomate ve nemb amolmol dabin ok ande gibloblo.” ");
INSERT INTO kbm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yisu gilauk givang bui kapul Galilaia ane kire be gili Saimon ebe ital inei Pita ok, gabu male Endru. Sulu itak as wasang wenk ane ivang ve sulu isgabu amol wenk ane. ");
INSERT INTO kbm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Be Yisu ginei gitangi sulu, “Gabu unme unvang mul ve ayeu be atob ayeu nambul yemlu ve unro awangg amolmolgen sut, dang ete gabu uro wenk sut gisov aim wasang ok.” ");
INSERT INTO kbm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sulu iute Yisu avo be seukie-ngge gabu imdil ikwai as wasang be ile ivang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sotol ivang kasop-gege ile be Yisu gili Sebedi natunggen Jems gabu male Jon. Sulu imbweg as ei-vovo ivin tamas be iyumi as wasang. Yisu gili Jems gabu male Jon be ginei gitangi sulu, “Gabu unme be unvang mul ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Be seukie-ngge Jems gabu male Jon ivang ikwai as ei-vovo be tis tamas Sebedi bamo be gabu ile ivang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisu givang geb taku avut nangge Galilaia be gibul amolmol ve Pomate ane yaun nangge as lum yamar aplo gitang-tangi ge, be ginei yaun ebe Pomate ve nemb eisir dabin ok lavo lavo gitangi eisir. Be gilgum amolmol ebe inggas gimat walang ano ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yisu ane binge geb taku avut nangge Siria as taku beti amolmol iute be inggas eisir ebe tis gimat walang ano be inggas vavavne bamo molge ok be tis amolmol be tulkwas giru bingbleng ok be eisir ebe ngalau tiate givang givin is ok, itangi Yisu ile be Yisu gilgum eisir tepwengge be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Be amolmol anongge nangge Galilaia be nangge nam dabe bage isgabu be nangge Jerusalem be Judia be nangge taku ebe giengk bui Joldan tavlu ane ok, eisir itau ile Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisu gili amolmol anongge ebe iro isate sut itangi ei ile ok beti gireu matendubi ti gile gibweg. Be ane singamolomb-gen itangi ei ile. ");
INSERT INTO kbm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Be ginei yaun (mateu) gitangi eisir be ginei; ");
INSERT INTO kbm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Amolmol ebe aplos givin Pomate be ilgum is-ate tiate tiate ve inaute Pomate ane mateu ok, tas vevias ge ve Pomate geb eisir dabin. ");
INSERT INTO kbm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Eisir ebe aplos bunam ok tas vevias ge ve atob Pomate nilgum eisir aplos vie. ");
INSERT INTO kbm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amolmol ebe induel is-ate love weik gen sin-ge ok tas vevias ge ve atob eisir in-gas gen vie ebe Pomate gibiti ane yaun yapin ok. ");
INSERT INTO kbm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Eisir ebe aplos givin anongge ve insov Pomate ane yaun ane lu ge ok tas vevias ge ve atob Pomate nipasang eisir be na nili eisir vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Eisir ebe tas viti ve amolmol ok tas vevias ge ve atob Pomate ta viti ve eisir. ");
INSERT INTO kbm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Amolmol ebe tas gitung inei ve inalgum gen vie-ngge ok tas vevias ge ve atob eisir indi Pomate. ");
INSERT INTO kbm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Eisir ebe inei yaun bwaibwaya gitangi amolmol ok tas vevias ge ve atob Pomate nital eisir ninei natu-nggen. ");
INSERT INTO kbm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Eisir ebe amolmol emb bunam gitangi eisir ve ebe ilgum Pomate ane yaun ano gile ok tas vevias ge ve Pomate geb eisir dabin. ");
INSERT INTO kbm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yem amolmol ebe amolmol subu inggo aim be inei yaun ungglus ungglus be yaun bing kas-kasop gipil aim be ilgum aim tiate tiate ve ebe uvang mul ve ayeu ok, yem tanggaim vevie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yem tanggaim vevie-ngge ve asonge yem un-gas gen vevies ebe giengk Pomate ane taku ok. Warik amolmol tiate ane ilgum gen dang etenik gitangi Pomate ane amolmol ebe inei ei avo ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Yem weik amolmol as gielk. Gielk ei gen vavis vie bemem ginei gielk vavis ma be bwalum weik ebe bui ok, okob gen ti giengk ebe atob tanalgum be gielk etok vavis vukuri ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yem weik yev ebe giro amolmol tepwengge ok. Ginei amolmol nangge nam dabe ti inambweg matendubi ti, okob eisir etok gitangi ebe atob inmumu is-ate ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Amol ti gitangi nitung lam be nivandung kilkiel niwei ok ite. Atob ei nitak lam etok niengk nitip ge veik niro amolmol tepwengge nangge nam aplo. ");
INSERT INTO kbm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dang-etok yem unes aim luev vie weik etok ge, veik amolmol indi gen vevies ebe yem ulgum ok be avos nivwat Pomate ebe gibweg gulumb ok.” ");
INSERT INTO kbm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yem tanggaim nitung unei ayeu ganme ve nayaing Mose ane yaun be tis Pomate ane yaun ebe warik ane amolmol ebe inei ei avo ok inei ok ite ma. Ayeu ganme veik nalgum yaun etok ano nile. ");
INSERT INTO kbm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ayeu nanei bingano-ngge nitangi yem, gulumb tis nalk asonge ma nikwai bemem Pomate ane yaun ake natu ti wat ma nikwai ite ma yapin, atob niengk dang etok love yaun tepwe-ngge ano nile. ");
INSERT INTO kbm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amol ti ginei giro Pomate ane yaun ake natu ti vukir be gile gibul amolmol subu ve inalgum gen weik ete ei ate ane ta gitung ok, atob amol etok nisov Pomate ane taku ebe ve nemb amolmol dabin ok nile bemem atob ei nimbweg vie molge ite. Be ginei amol ti aplo givin Pomate be gibul amolmol ve invang mul ve Pomate ane yaun, amol etok atob nimbweg vie molge nangge Pomate ane taku ebe ve nemb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ayeu nanei bingano-ngge nitangi yem, ginei yem aplongg-aim givin Pomate be ulgum ei ane ayun ano gile gitlek ebe Parisai be tis gidung ebe emb Mose ane yaun dabin ok ilgum ok, atob yem unsov Pomate ane taku ebe ve nemb yem dabin ok unde.” ");
INSERT INTO kbm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Yem utpweng yaun ebe warik eitit tumbud-gen iute ok are gikwai, ve Pomate ane amolmol kulkul ane inei, ‘Unes amolmol vunu ite.’ ");
INSERT INTO kbm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bemem ayeu nanei nitangi yem, amol ti ginei ta vavis ve ane nune atob amol etok ninggas yaun bamo molge nang-ge bambamo yaun ane. Be ginei amol ti ninei yaun ungglus-ungglus nipil amol ti, okob amol etok atob nivarkei bambamo yaun ane nas. Be ti ginei gigo ane nune ti ginei, ‘Mie gen singe be dabem gwet ma,’ amol etok kasopge nireu yev bamo ebe giengk dang etok painge ge ok nile. ");
INSERT INTO kbm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ginei mie guvwat am ben gutangi taku da ane gule ve nomb da nitangi Pomate be seukie-ngge mie tam giro yaun ebe yemlu am nune ti ung-go aim ate ok, ");
INSERT INTO kbm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","okob nutak am da ningk nimbloblo taku da ane be nunumul nule be gabu am nune etok unpasang aim yaun etok be ma nikwai kob nule be nomb am da nitangi Pomate. ");
INSERT INTO kbm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ginei amol ti ve ninggas mie nutangi eisir ebe ilgum amolmol as yaun ok nule, okob gabu unpasang aim yaun seukie-ngge tis ete gabu uvang luev ve ule ok, veik am nune etok ning-gas mie nutangi bambamo ebe ilgum amolmol as yaun ok nule ite, velob eisir etok inemb mie nutangi amolmol ebe emb kapual-lu dabin ok nule. Kob atob eisir ebe emb kapual-lu dabin ok, intak mie nusov kapual-lu nule numbweg. ");
INSERT INTO kbm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ayeu nanei bingano-ngge nitangi mie, atob mie menuhlang nukwai kapual-lu ite love nos am gen bambamo ebe gulgum ok ane den vunu kob atob menuhlang nukwai kapual-lu.” ");
INSERT INTO kbm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Yem ute warik Pomate ane amolmol kulkul ane inei unalgum gen wasi ane ite. ");
INSERT INTO kbm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bebem ayeu nanei nitangi yem, amol ti ginei gili avie ti ve matano ge, be ta gitung ve nes luev wasi ane nitangi avie nok, okob etok weik ebe ande ei gilgum wasi ok nang-ge ei ate aplo. ");
INSERT INTO kbm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ginei mie matanom tavlu gilgum be mie gulgum gen tiate, okob nuptit vurupwe be nukari. Be etok vie ve utlem ane gen ti nikwai be tiate ve nureu yev tis utlem ane gen walang ok nule. ");
INSERT INTO kbm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Be ginei mie bagem tavlu gilgum be mie gulgum gen tiate, okob nudbwen gili nikwai, be gen etok vie ve mie nuvang tis bagem tavlu ge, bemem tiate ve nureu yev tis bagem isgabu nule.” ");
INSERT INTO kbm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pomate ane amolmol kulkul ane inei yaun ti givin dang-eteik; Amol ti ginei bua ve arue, okob amol nok atob niro yaun ebe ve bua ve arue ok nireu kapia den ti, be nemb nitangi arue nile. ");
INSERT INTO kbm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bemem ayeu nanei nitangi yem, amol ti ginei bua ve arue be gitin ei bemem avie nok gilgum gen wasi ane ite be mul-ane avie nok gile geb amol vaku ti vukuri, okob amol etok gilgum arue avie weik ebe avie wasi ane ti ok. Be amol ti ginei gile geb avie ti ebe warik arue amol bua ve ane be gitin ok, okob amol etok gilgum gen wasi ane weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Yem ute yaun ti ebe warik Pomate ane amolmol kulkul ane inei ok be inei, ‘Amol ti ginei gibiti yaun ti be girusu bage, okob ei nilgum ane yaun ano nile ve gisov ei gibiti yaun be girusu bage gitangi Pomate.” ");
INSERT INTO kbm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bemem ayeu nanei nitangi yem, unei yaun be unrusu baingg-aim nivin ite molge. Unrusu baingg-aim nitangi gulumb ite ve etok Pomate ane taku ebe geb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Be unrusu baingg-aim nitangi nalk ite ve etok Pomate ane taku givin. Be unrusu baingg-aim nitangi Jerusalem ite ve etok Amol Bamo ebe geb amolmol dabin ok ane nam. ");
INSERT INTO kbm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Be nurusu bagem nitangi dabem tulkwe ite nivin weik etok ge ve mie gitangi ebe atob nulgum dabem lan ano donke-ngge be menihlang bogbogo me tumtumi ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yaun ebe yem ve unei ok eteik, ‘E-e, atob ayeu nalgum,’ me ‘Ma, atob ayeu nalgum ite.’ Be ginei yem une yaun subu givin, okob ayun etok ginme nang-ge Sadam ane.” ");
INSERT INTO kbm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Yem ute Pomate ane amolmol kulkul ane inei yaun ti givin dang-eteik, ‘Amol ti ginei ges mie matanom, okob mie nos ei ane niwel. Be ginei amol ti ges mie nivom be gible, mie nos ei ane ve nitung.’ ");
INSERT INTO kbm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bemem ayeu nanei nitangi yem; Unemb tiate niwel tiate ite. Amol ti ginei givtav mie paptem tavlu, mie nomb tavlu be ei nivtav nivin. ");
INSERT INTO kbm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Amol ti ginei ta gitung ve nilgum miam yaun nitangi eisir ebe ilgum amolmol as yaun ok ve nivwat miam kup, be eisir nok inei gitangi mie ve nomb am kup nitangi ei, okob mie nomb am kup malar ane nitangi ei nivin. ");
INSERT INTO kbm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Be ginei amol valir ane ti lolo ve mie nuvwat ei ane wambal nuvang luev ake dongke-ngge, mie nuvang luev ake ailu nuvin ei. ");
INSERT INTO kbm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Be amol ti ginei giutani gen ti nang-ge mie, okob nomb gen etok nitangi ei. Be ginei amol ti ta givin ve nivwat gen ti nangge mie be mulane kob ei nemb gen ti niwel miam gen etok, okob mie nuvkir dumem nitangi ei bwaya.” ");
INSERT INTO kbm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yem ute Pomate ane amolmol kulkul ane inei tam nivin am nune-nggen be nuvkir dumem nitangi amolmol ebe ilgum mie ok. ");
INSERT INTO kbm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bemem galkik ayeu nanei nitangi yem; Tangg-aim nivin amolmol ebe ilgum yem tiate tiate ok be unes miengk nitangi Pomate ve eisir ebe ilgum gen ungglus ungglus gitangi yem ok ane nivin, ");
INSERT INTO kbm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","veik atob Tamangg-aim ebe gibweg gulumb ok nili yem ninei natu-nggen. Ve Ei geb ane as tis ur ve amolmol vie be tiate ane givin. ");
INSERT INTO kbm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ginei yem tangg-aim nivin amolmol ebe tas givin yem ok ge, okob gitangi ebe atob Pomate nemb gen vevies ge nitangi yem ok ite, ve amolmol tiate ane ok ilgum gen etok givin. ");
INSERT INTO kbm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Be ginei yem kakie unvin aim nune-nggen ge, okob gen etok ok vie ite weik etok ge ve amolmol tiate ane ilgum gen etok givin. ");
INSERT INTO kbm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Unemb aim ate dabin vie-ngge weik ete Pomate geb ate dabin vie-ngge nangge gulumb ok.” ");
INSERT INTO kbm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Yem undi aim ate-ngge. Unemb Pomate ane kulkul be unalgum gen vevies ge nangge amolmol nas ite velob amolmol indi be avos nivwat aim. Ginei yem ulgum dang etok okob atob un-gas gen vie ti nangge Pomate ebe gibweg gulumb ok ane ite. ");
INSERT INTO kbm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ginei yem ve unemb gen ve amolmol ebe gen ma ve is ok, okob unalgum unvwaivun ge velob amolmol subu indi be avos nivwat yem arengg-aim, dang ebe amolmol binkasop ane subu ilgum nangge lum mateu ane aplo be nangge luev gil-kili ok. Eisir ilgum dang-etok veik amolmol indi be avos nivwat eisir ares. Bemen ayeu nanei nitangi yem, eisir etok ande ivwat as gen vie gikwai, ve amolmol avos givwat eisir be gitangi ebe atob eisir in-gas gen vie ti vukuri nindeb mulane ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dang-etok be ginei yem ve unemb gen ve amolmol okob unalgum bwaya-gege veik amolmol ebe imbweg imbloblo aim ok indi bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be yem aim kulkul vie ete ulgum ok atob nivwaivun ate-ngge. Be Tamangg-aim ebe gili gen ebe givwaivun ate-ngge ok, atob nemb gen vevies ge nitangi yem.” ");
INSERT INTO kbm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ginei yem ve unes miengk nitangi Pomate, okob unalgum weik ete amolmol bingkasop ane ilgum ilgum ok bwaya. Eisir etok tas givin ve ines miengk invarkei lum mateu ane aplo be nangge kasa lavo veik amolmol indi e avos nivwat eisir. Bemen eisir ande inggas as gen vie gikwai, ve amolmol avos givwat eisir. ");
INSERT INTO kbm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bemem ginei yem ve unes aim miengk nitangi Pomate, okob unsov aim nam aplo unde be unes nam-avo nile kob unes aim miengk nitangi Pomate ebe givang givwaivun ate-ngge ok, kob atob Ei nili gen ebe yem ulgum ok be nemb gen vevies ge nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ginei yem ve unes miengk okob unei yaun walang ano be undib bamo dang ete amolmol dabas ungglus ane ilgum ok bwaya. Eisir tas gitung dang-eteik inei atob Pomate niute eisir as yaun ve gisov eisir es miengk undib molge. ");
INSERT INTO kbm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dang-etok be yem unalgum weik ete eisir ok bwaya, ve Pomate ei gitpweng gen walang ete yem tangg-aim givin be ve unautani ei ok are gimungg gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dang-etok be yem unes aim miengk dang eteik: ‘Tamangg-amei ebe gubweg gulumb ok, amei tangg-amei givin anei amolmol avos nivwat mie arem nemb ta-ngge ma. ");
INSERT INTO kbm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mie nomb amei dabin ve am gwang-ne be amei anvang mul ve miam tam givin ge nangge nalk, denang ebe nangge gulumb ok. ");
INSERT INTO kbm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amei-mei ben asmate walang ok ane galkik etek mie gob gitangi amei. ");
INSERT INTO kbm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mie tam nivalngan amei-mei tiate ebe algum ok, dang ete amei tangg-amei givalngan tiate ebe amolmol ilgum gitangi amei ok. ");
INSERT INTO kbm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mi nung-gas amei antangi gen tiate ande bwaya, be nung-gas amei ankwai Sadam tis ane gen tiate. (Mie-ngge gitangi ve nob amolmol dabin, be Amol gwangne be Amol bogbogo ane, be asonge numbweg dang etok nemb ta-ngge. Bingano.’) ");
INSERT INTO kbm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Be unaute kob. Ginei yem tangg-aim givalngan gen tiate ebe amolmol ilgum gitangi aim ok, okob Tamangg-aim ebe gibweg gulumb ok atob ta nivalngan yem aim gen tiate ebe ulgum ok weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Be ginei yem tangg-aim givalngan amolmol as gen tiate ebe inei gipil yem ok ite, okob Pomate ok atob ta nivalngan yem aim gen tiate ebe ulgum be unei ok ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ginei yem ve unyamar ben ve miengk ane, okob unalgum nangg-aim tiate weik ete amolmol binkasop ane ilgum ok bwaya. Eisir etok ilgum ve ilgum nas tiate veik ines is-ate ru nitangi amolmol, veik amolmol indi be inei eisir iyamar is ate ve miengk ane. Bemem ayeu nanei nitangi yem; Eisir ande inggas as gen walang ok gikwai, be gitangi ebe atob Pomate nemb gen ti vukuri nitangi eisir nindeb mulane ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dang-etok be ginei yem ve unyamar aim ate ve miengk ane, okob unrau dabangg-aim lan be unvuk nangg-aim, ");
INSERT INTO kbm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","veik unes aim ate ru nitangi amolmol be indi denang ebe yem uyamar aim ate ve miengk ane ok ite. Bemem Tamangg-aim ebe uli ite ok ete atob nili gen ebe yem ulgum uvwaivun ge ok, be atob nemb gen subu niwel gen ete yem ulgum uvwaivun ge ok nitangi aim.” ");
INSERT INTO kbm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yem unro aim gen vevies nalk etenik ane sut niengk nalk etenik ite, ve gwaleseng atob nidbwen be gen subu atob galgale. Be atob amolmol vaina ane inme be invaina nikwai. ");
INSERT INTO kbm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yem unro aim gen vevies sut niengk gulumb veik atob gwaleseng nidbwen me galgale ite, be amolmol vaina ane atob inme be invaina nikwai ite. ");
INSERT INTO kbm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ve taku ete yem uro aim gen vevies sut gienk ok, ete atob yem ate ok tangg-aim nivin taku etok nivin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yem ginei tanggaim nitung gen vie-ngge niengk aplongg-aim atob unalgum gen vevies ge. ");
INSERT INTO kbm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Be ginei tanggaim gitung gen tiate giengk aplongg-aim atob unalgum gen tiate weik etok ge. Be gen tiate ete yem tanggaim gitung ok atob unalgum nemb ta-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Amol ti gitangi nemb tivie ailu as kulkul nipil dongke ite ve atob ei bua ve tivie ti be ta nivin tivie dongke-ngge. Be tivie ailu nok dang eteik Pomate ane kulkul be kulkul mone ane. Dang-etok be unemb tivie ailu as kulkul nipil dongke ite.” ");
INSERT INTO kbm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Dang-etok be ayeu nanei nitangi yem. Aplongg-aim bunam be tanggaim nitung walang ano unei atob unen be unum gen ret ebe ve niro aim ta be tis gen ebe ve uno be unro ok bwaya. Ve tanambweg matawand etok gen vie molge gitlek ben, be utland ulis etok gen vie molge gitlek kup tis babal. ");
INSERT INTO kbm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yem uli mank bambamo ete ilwep ilwep ivang nik, eisir ivro ben me iro ben sut gisov as nam aplo gile ite, bemem Pomate be gibweg gulumb ok ete givkwen eisir. Be yem gen vie molge gitlek mank, be atob Pomate nemb gen walang ok nitangi yem ite me? ");
INSERT INTO kbm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Amol ti gitangi ebe ta nitung dang-eteik ninei asonge ei nimbweg sawa undib siting-ge nivin nangge nalk ok ite. Ma yapin. ");
INSERT INTO kbm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Yem tanggaim nitung kup tis kambam bamo molge ite. Tau yem undi monok bambamo ebe geb taku walang ok avut ok, eisir emb kulkul ben ane me ipasang kup tis kambam ti ite. ");
INSERT INTO kbm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bemem ayeu nanei nitangi yem; Warik amol ti are Solomon, ei amol bamo ti ebe tis wambal walang ok bemem ei ane gen ti bwalbwale vie molge weik ete monok ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Monok ei gen galkik ane ge be asongkob atob ainggwen be nes ulur nikwai. Be yem amolmol yem gen vie molge gitlek monk. Bemem yem aplongg-aim givin Pomate ano molge ite, ");
INSERT INTO kbm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","beti tanggaim gitung walng ano unei atob unen be unum gen ret be uno kup tis kambam ret. ");
INSERT INTO kbm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Amolmol ebe aplos givin Pomate ite ok, eisir atob tas nitung gen dang dang-etenik. Bemem yem Tamangg-aim ebe gibweg gulumb ok ei gitpweng gen walang ete yem tangg-aim givin ve un-gas ok are gimungg gikwai, be atob ei nemb yem dabin vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bemem ginei yem aplongg-aim givin dang-etok unei Pomate geb yem dabin bingano ge, be ulgum ei ane yaun ano gile, okob atob ei nemb gen subu subu nitangi yem nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dang-etok be aplongg-aim bunam be tanggaim nitung walang ano ve gen bunam asongkob ane ite, ve etok gen asongkob ane-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Yem undi aim ate unei yem vie molge gitlek be unalgum amolmol subu as yaun ite, ");
INSERT INTO kbm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ve atob Pomate nilgum yem aim yaun nivin weik etok ge. Be gen ete yem ulgum gitangi amolmol subu ok ete atob Pomate nilgum nitangi yem nivin. ");
INSERT INTO kbm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mie nam be nuli am luev ebe guvang be gulgum ok nimungg, bekob nunei amol ti ane tiate ane yaun. ");
INSERT INTO kbm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Be uli ve nunei amol ti ebe gilgum tiate ok ane yaun ve mie ok gilgum gen tiate walang ano gitlek ei. ");
INSERT INTO kbm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mie amol binkasop ane. Mie nupasang am tiate ebe gulgum ok nimungg be ma nikwai kob nulgum amol ti ebe gilgum tiate ok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ginei amolmol subu tas givin ve inaute Pomate ane yaun, okob yem unbul eisir ve Pomate ane binge vie. Be ginei eisir bwais, okob unei yaun ti nitangi eisir bwaya ve atob indi yaun etok denang gen sin-ge be inei yaun ungglus ungglus nipil aim.” ");
INSERT INTO kbm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ginei eitit tanau-tani Pomate ve gen ti ane, atob Ei nemb nitangi eitit. Be ginei tanrek gen atob tandi, be ginei tantal Pomate atob Pomate nemb eitit avond ru. ");
INSERT INTO kbm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ve amol ti ginei giutani Pomate ve gen ti ane, atob Pomate nemb, be amol ti ginei girek gen atob nili. Be ti ginei gital Pomate atob Pomate nemb ei avo ru. ");
INSERT INTO kbm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nunus ti ginei niutani tine ve bat ane, atob tine nemb vat nitangi ei ite. ");
INSERT INTO kbm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Be nunus ti ginei giutani tame ve wenk ane, atob tame nemb mwat nitangi ei ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Amolmol tiate ane nangge nalk tas givin natus-gen be emb gen vevies-ge gitangi eisir, bemem yem Tamangg-aim ebe gibweg gulumb ok ei ta givin amolmol gitlek molge be ginei yem unautani ei ve gen vie ti ane, atob ei nemb. ");
INSERT INTO kbm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Be gen walang ete yem tangg-aim givin ve amolmol inalgum nitangi yem ok, ete unalgum gen etok nitangi eisir. Ve Mose ane yaun be tis Pomate ane amolmol ebe warik inei ei avo ok as yaun ane dabe etenik.” ");
INSERT INTO kbm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Tansov Pomate ane taku ebe geb amolmol dabin ok tande, ane nam avo natu molge, be luev ebe gitangi yev bamo ebe giengk dang etok gile ok, ete gen ti givarkei avut ite ma. Be atob amolmol anongge invangg luev bamo etok intangi yev bamo ebe gienk dang etok ok inde. ");
INSERT INTO kbm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Be luev natu ebe gitangi Pomate ane taku ebe geb amolmol dabin ok gile ok, ete bunam molge be atob amolmol dongke dongke-ngge invang intangi luev etok inde.” ");
INSERT INTO kbm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nangg-aim undi aim ate-ngge ve amolmol bingkasop ane ebe iyo inei eisir inei Pomate avo ok. Eisir nok atob invang be inalgum as gen weik ebe amolmol vevies ane ok, veik amolmol indi eisir vie. Bemem nangge eisir aplos eisir tas-gitung gen tiate walang ano molge. ");
INSERT INTO kbm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yem atob unatwpeng eisir are niengk as luev ete ivang ok ge. Wal duduli gitangi ebe nes ano weik weiwei ok ite, ");
INSERT INTO kbm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","be ei ebe ges ano vevies ok gitangi ebe nes ano tiate ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Be ei ebe ges ano tiate ok gitangi ebe atob nes ano vevies ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Be ei ebe ges ano tiate ok ete atob um tivie nile be nitle nile nitak be nikari nireu yev nile. ");
INSERT INTO kbm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Dang etok be atob yem unatpweng amolmol bingkasop ane nok are niengk as leuv ete ivang ok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Velob yem tangg-aim nitung dang-eteik unei; Amolmol tepwengge ebe ital ayeu inei, ‘Pomate, mie awangg Amol Bamo ok,’ ete atob tepwengge insov taku gulumb ane inde, bemem dang-etok ite ma. Eisir be iute Tamangg ane yaun be tas givin ve inalgum ano nile ok, eisir etok ge ete atob insov Pomata ane taku ebe ve nemb amolmol dabin ok inde. ");
INSERT INTO kbm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Asonge nindeb mul-ane nivin ebe ayeu ve nanumul name nalk ok, atob amolmol anongge intangi ayeu inme be inei, “Amol Bamo, amei anei Pomate ane avo be anei gisov mie arem, be aitin ngalau tiate anongge gikwai amolmol ve miam gwangne, be algum gen bwalbwale anongge ve miam gwang-ne.” ");
INSERT INTO kbm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bemem atob ayeu nanei roro-ngge nitangi eisir nanei, ‘Ayeu ganini yem. Yem amolmol tiate ane, be unkwai ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Amolmol ebe iute awangg yaun be tas givin ve inalgum ano nile ok, eisir etok weik amol ebe gitpweng gen are be gitav ane nam tis twelk ok. ");
INSERT INTO kbm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Be ur bamo gisov be bui vot bamo molge, be wavin bamo givang bemem ges nam etok butu ite, ve nam etok ane twelk gisov nalk aplo gile beti giro ta be nam givarkei gwangne. ");
INSERT INTO kbm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Be amolmol ebe iute awangg yaun eteik be ilgum ano gile ite ok, ete weik amol ti ebe gitpweng gen are ite be gitak ane nam giwe nalk dobo sin-ge ok. ");
INSERT INTO kbm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Be ur bamo gisov be bui vot bamo giriv, be wavin bamo givang be ges namb etok be gihlu gile gitak nalk, ve nam nok ane twelk ma ebe ve niro ta be nivarkei gwangne ok.” ");
INSERT INTO kbm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisu ginei ane yaun bambamo etok love ma, be amolmol tepwengge ikuri vunu-ngge ve ei ane yaun ebe ginei ok, ");
INSERT INTO kbm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ve Ei gibul eisir weik gidung ebe emb Mose ane yaun dabin ok ite ma. Yisu gibul eisir tis ane gwang-ne ge. ");
INSERT INTO kbm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu gisov nangge matendubi gile be amolmol ano-ngge itau ile ei. ");
INSERT INTO kbm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Be amol ti ebe tis bid namvu ok gitangi Yisu gile be giro va-ndubi supwe gisov nalk gideb Yisu na ane be ginei gitangi Yisu. “Ginei mie tam givin kob nulgum ayeu utlangg be vie vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisu gito bage gile be gitak bage giwei amol nok be ginei, “Ayeu tag givin ve nalgum mie utlem be vie vukuri, be ande ayeu galgum mie utlem be vie.” Be seukie-ngge amol nok utle gile lavo vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bekob Yisu ginei gitangi ei; ‘Uli ve nunei gen etenik binge nitangi amolmol, bemem mie nuvang roro-ngge nutangi amol bamo ebe geb da nangge lum yamar ok nule be nos imate ru nitangi ei, bekob nomb am da nitangi Pomate, dang ebe warik Mose ginei ok veik atob amolmol tepwengge inatpweng are inei ande mie utlem vie gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisu gile gihlang Kapanaum be amol Rom ane ti ebe geb amolmol valir ane dabin ok gile vunge ve ei be ginei yaun gwang-ne gitangi ei be lolo ve nilgum ei ane amol kulkul ane be vie vukuri, ");
INSERT INTO kbm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","be ginei, “Awangg amol kulkul ane ti gigas gimat tiate-ngge be va be bage tulkwe giru bingbleng, be gitangi ebe ve nilauk ok ite. Be ei gigas vavavne bamo molge be giengk nam aplo ge.” ");
INSERT INTO kbm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Be Yisu ginei gitangi amol ebe geb amolmol valir ane dabin ok, “Atob ayeu nale be nalgum miam amol kulkul ane etok be utle vie vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Be ei giwel Yisu avo be ginei, “Bemem ayeu amol vie ite gitangi ebe atob nanggas mie be tande awangg nam ok ite. Be mie gitangi ebe atob nunei yaun ve avom ge be awangg amol kulkul ane etok utle vie ok. ");
INSERT INTO kbm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ve ayeu ok ayeu gasov amol ebe tis are ok ane lu, be ei geb ayeu dabin be ayeu gab angg amolmol valir ane dubi ti dabin. Be ginei ayeu nanei nitangi angg amol ti be nanei ‘Ule!’ atob ei nile. Be ginei nanei nitangi angg amol kulkul ane ti ve nilgum gen etok, atob ei nilgum.” ");
INSERT INTO kbm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yisu gikuri vunu-ngge ve amol etok ane yaun ebe ginei ok, be ginei gitangi amolmol ebe ivang mul ve ei ok be ginei, “Ayeu nanei nitangi yem. Ayeu gali amol ti aplo givin ayeu dang ete amol etenik ok nangge Isrel be tis taku subu givin ite molge. ");
INSERT INTO kbm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dang-etok be ayeu nanei nitangi yem, amolmol nangge taku walang ok atob inme be inambweg invin Ablaham gabu Isak be Jakop be inen ben nangge Pomate ane taku ebe ve nemb amolmol dabin ok ebe gipasang ve eisir ane yapin ok. ");
INSERT INTO kbm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bemem eisir ebe aplos givin Pomate ite ok, ete atob Pomate nitin eisir inde insov aiweng tumi aplo. Be nangge taku etok atob eisir in-gas bunam be inteng ano-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bekob Yisu ginei gitangi amol galkok be ginei, “Uvang am nam ane ve mie aplom givin beti atob nilgum be am amol kulkul ane utle vie vukuri.” Be seukie-ngge amol nok ane amol kulkul ane utle vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisu gile Pita ane nam be gili Pita lawa-vie ebe gimat utle vavavne be giengk nam aplo ok. ");
INSERT INTO kbm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yisu geb ei gibweg bage be seukie-ngge gimat gihlang gikwai ei be gimdil be gipasang ben ve tis Yisu inen. ");
INSERT INTO kbm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Givin gibok etok amolmol inggas eisir ebe ngalau tiate givang givin is ok be itangi Yisu ile. Be Yisu ginei yaun ve avo ge gitangi ngalau tiates nok be ile ihlang ikwai amolmol, be gilgum eisir ebe tis gimat ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yisu gilgum gen dang-etok beti ande gilgum yaun ebe warik Pomate ane amol ebe ginei Pomate avo ok are Aisaia ginei ok be ano gile. Aisaia ginei dang-eteik: ‘Ei ate gigas eitit and gen bunam tis vavavne.’ ");
INSERT INTO kbm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yisu gili ebe amolmol ano-ngge ivarkei meidbul ei ok be ginei gitangi ane singamolomb-gen ve ines bui gili inde inpil bui tavlu ane. ");
INSERT INTO kbm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Be gidung ti ebe geb Moses ane yaun dabin ok ginme be ginei gitangi Yisu be ginei, “Gidung, taku walang ete mie ve nule ok atob ayeu navang mul ve mie painge-ge.” ");
INSERT INTO kbm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yisu giwel ei avo be ginei, “Uruv tis as nalk avo be mank walng etenik tis as niu bemem Pomate Natu Ayeu, ebe meng-gahlang weik amolmol ok, angg taku ti giengk ebe ve nayap nambweg ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Be eisir sigamolomb as amol ti gile be ginei gitangi Yisu be ginei, “Ayeu nale be naspun tamangg nikwai kob nanme be navang mul ve mie.” ");
INSERT INTO kbm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bemem Yisu giwel ei avo be ginei, “Gitangi ite! Amolmol ebe aplos givin ayeu ite ok inaspun eisir ete imat vun-kunu ok be mie nunme be nutau nile ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisu tis ane singamolomb-gen ile ipil ei-vovo be ile, ");
INSERT INTO kbm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","be seukie-ngge wavin givang bamo molge be ane tine bamo tiate nangge bui kapul be ngal gikari gisov ei-vovo aplo. Bemem Yisu ande giengk kukwe gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Be ane singamolomb-gen itangi ei ile es ei itin be inei, “Omb eitit ru ma! ve kasop ge atob tansov gielk be tanmat vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yisu ginei gitangi ane singamolomb-gen be ginei, “Yem upelk dang etok ve ret ane? Yem wat aplongg-aim givin ayeu ano molge ite me?” Bekob Yisu gimdil givarkei be ginei yaun ve avo ge gitangi wavin tis ngal be wavin bongong be ngal gitak love bongong vie molge. ");
INSERT INTO kbm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eisir singamolomb ili love ilat bais be inei gitangi is ate be inei, “Amol ret dang etenik, ve wavin tis ngal ok be iute ei avo ge ba?” ");
INSERT INTO kbm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yisu tis ane singamolomb-gen ile isov Gadara as taku gideb bui kapul tavlu ane be amol ailu ebe ngalau tiate givang givin is ok meihlang nangge taku gimat ane, be ile vunge ve Yisu. Amol ailu nok as gwang-ne gitlek molge be amolmol ipelk ve is ate ane be ivang luev etok ite. ");
INSERT INTO kbm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ngalau tiate etok ili Yisu be yayai be inei, “Pomate Natu mie, sawa ebe mie ve nulgum amei-mei yaun ok giengk nangge, be mie wat gunme ve nomb vavavne nitangi amei nok etenki me?” ");
INSERT INTO kbm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Be amolmol ebe emb bwelk dabin ok ivkwen bwelk dubi bamo ti ivang imbloblo taku ete Yisu tis amol ailu etok ivarkei ok. ");
INSERT INTO kbm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Beti ngalau tiate etok inei gitangi Yisu be inei, “Ginei mie tam givin ve nuitin amei ankwai taku etenik, okob mie nuhlin amei be ande anatwep bwelk bambamo etok aplos ande.” ");
INSERT INTO kbm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Be Yisu ginei, “Unde!” Ngalau tiates nok ile ihlang ikwai amol ailu etok be ile itwep bwelk etok aplos ile, love ilgum be bwelk etok tepwengge ituvki isov matendubi ile isov bui be tepwengge inum bui be imat vunkunu. ");
INSERT INTO kbm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amolmol ebe emb bwelk nok dabin ok ipelk be ituvki ile ve ivang nam ane, be inei bwelk nok as yaun be tis gen ebe Yisu gilgum gitangi amol ailu ebe ngalau tiate givang givin is ok lavo gitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bekob ete amolmol tepwengge nangge nam dabe etok iro Yisu avkavut nangge luev ile, love imbielk ve Yisu be inei gitangi ei ve nikwai eisir as taku be nile ve nivang. ");
INSERT INTO kbm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisu tis ane singamolomb-gen ile ipil as ei-vovo vukuri be ilumul ile ipil bui tavlu ane vukuri, be ile imbielk ve ei ate ane nam roro. ");
INSERT INTO kbm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Be amolmol nangge nam dabe etok inggas amol ti ebe gigas gimat be va tis bage dubi giru bingbleng ok giwei ane yemb be itangi Yisu ile. Yisu gili eisir as aplos givin ei, beti ginei gitangi amol gimat nok be ginei, “Natum. Aplom bunam bwaya, ve miam gen tiate ebe gulgum ok ande ayeu gasin gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Be gidung subu ebe emb Mose ane yaun dabin ok iute be inei ve isate, “Amol etenik wat ve nilgum molok nile Pomate me?” ");
INSERT INTO kbm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bemem Yisu ande gitpweng yaun ete eisir tas gitung be inei ve is ate ok are gikwai beti ginei gitangi eisir be ginei; ");
INSERT INTO kbm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Ginei ayeu nanei ve yaun ge nitangi amol gimat etenik be nanei, ‘Umdil be uvwat am yemb be uvang,’ bemem awangg yaun etok ano ma, atob ayeu mai-mayangg ano-ngge. Bemem ginei ayeu nanei; ‘Ande ayeu gasin miam gen tiate gikwai,’ be awangg yaun etok ano gile ite, okob atob ayeu mai-mayangg ite. Ve amolmol gitangi ebe atob indi gen etok ane ano be inatpweng are ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bemem ayeu tangg givin ganei yem unatpweng yaun eteik are vevie kob. Pomate Natu ayeu ebe meng-gahland weik amolmol ok angg gwangne gitangi ebe ve nasin amolmol as tiate nikwai nangge nalk etenik ok.” Bekob Yisu ginei gitangi amol gimat etok be ginei, “Umdil be uvwat am yem be uvang am nam ane.” ");
INSERT INTO kbm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amol gimat etok gimdil be givwat ane yemb be givang ane nam ane. ");
INSERT INTO kbm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Amolmol ili gen etok be ikuri vunungge love yaun ok ma be avos givwat Pomate are ve ebe geb ane gwangne dang dang-etok gitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu tis ane singamolomb-gen ikwai taku etok be ivang ve ile be Yisu gili amol ti ebe geb kulkul takes ane ok, are Matai gibweg ane nam aplo kulk ane. Be Yisu ginei gitangi ei, “Unme be uvang mul ve ayeu.” Matai gimdil be gitau gile Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Givin sawa ti Yisu tis ane singamolomb-gen en ben nangge Matai nok ane nam be amolmol subu ebe emb kulkul takes ane be iyo iyo amolmol be inggas as mone subu sinsin-ge givin ok be tis amolmol tiate ane subu ile be en ben ivin Yisu tis ane singamolomb-gen. ");
INSERT INTO kbm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Be amolmol subu nangge Parisai ili be ile iutani Yisu ane singamolomb-gen be inei, “Nam-nambed be yem aim gidung gen ben givin amolmol ebe emb kulkul takes ane be iyo iyo amolmol be inggas as mone subu singsin-ge givin ok, be tis eisir tiate ane bambamo etok?” ");
INSERT INTO kbm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu giute Parisai as yaun etok be giwel eisir avos be ginei, “Amolmol ebe utlas vie ok itangi amol marasin ane ile ite ma, eisir ebe tis gimat ok ge ete ivang itangi amol marasin ane ile. ");
INSERT INTO kbm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Unde be unatlo Pomate ane yaun (ebe warik ane amol ebe ginei ei avo ok, ginei ok vevie be undi kob). Ayeu tag givin ve ganei yem unemb da ge nitangi ayeu ite, bemem ayeu tag givin ganei yem tangg-aim viti ve aim ate be unambweg vie-ngge. Ayeu ganme ve amolmol vie ane ge ite ma, ayeu ganme ve amolmol tiate ane givin. ");
INSERT INTO kbm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Be givin sawa etok ge Jon ane singamolomb-gen itangi Yisu ile be iutani ei be inei; “Nam-nambed be amei tis parisai ayamar ben givin as-mate subu be as miengk be miam singamolomb-gen ilgum ite. ");
INSERT INTO kbm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yisu giwel eisir avos be ginei, “Ginei ayeu nambweg navin angg amolmol-gen atob eisir aplos bunam ite bemem ginei ayeu navang nakwai eisir, kob atob aplos bunam be atob inen ben ite. ");
INSERT INTO kbm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Amol ti gitangi ebe nivwat waingg mwanggane ti be nidgin ane ei-vovo vaku ti ok ite. Ginei ei nilgum, atob ngal niyuki ei-vovo nok okob atob waingg niti-titip kob atob ei-vovo nile nitav gielk. ");
INSERT INTO kbm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Be amol ti gitav nam vaku ti be gitak ark mwanggane gireu ane nam vaku etok ite. Ginei ei nilgum dang etok okob atob ur tis wavin nilgum be ark muanggane etok niti-titip kob atob ur nisov nam aplo. Tanemb gen vaku isgabu kob atob isgabu ge niengk vie.” ");
INSERT INTO kbm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisu ginei yaun gitangi amolmol givang, be amol ti ebe geb lum mateu ane dabin ok ginme be giro vandubi supwe gisov nalk gitangi Ei be ginei, “Ayeu natungg avie ande gimat vunu gikwai bemem ayeu tag givin ganei mie nunme be nutak bagem niwei ei veik matawe vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yisu tis ane singamolomb-gen imdil be itau ile amol bamo nok be tepwe ile. ");
INSERT INTO kbm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Be avie ti ebe gigas avie as gimat be giengk dang etok gitangi Sonda bamo 12 ok, gile gibloblo Yisu dume be bage gile Yisu ane kup ge, ");
INSERT INTO kbm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","be ta gitung dang etok ginei, “Ginei ayeu baingg niwei Yisu utle ulis me ane kup ge, okob etok gitangi ebe atob nilgum be ayeu utlangg vie vukuri ok.” ");
INSERT INTO kbm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yisu giro na vukir be gili avie nok bekob ginei, “Avie natu. Aplom bunam bwaya, mie aplom givin beti gilgum be utlem vie vukuri.” Be seukie-ngge avie nok utle vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yisu tis ane singamolomb-gen imbielk ve amol bamo galkok ane nam be Yisu gili ebe amolmol ilgum tangir be es uye be avos bambamo-ngge ok, ");
INSERT INTO kbm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","be ginei, “Unde unahlang unkwai! Avie natu etnok gimat vunu ite, etenok ei matano giengk beti giengk.” Be amolmol tepwengge imalk be inei yaun ungglus ungglus gipil Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amolmol tepwengge ile ihlang ikwai kob Yisu gisov nam aplo gile be geb avie natu nok gibweg bage be seukie-ngge avie natu matawe be gimdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Be gen etok ane binge givang geb taku walang ok avut. ");
INSERT INTO kbm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisu gikwai taku etok be givang ve gile be amol ailu itau ile ei, sulu ailu nok matanos bop ge isgabu. Be gabu ital yaun avos bamo-ngge gitangi Yisu, be inei, “Devit ane dani mie, tam viti ve eilu ma.” ");
INSERT INTO kbm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yisu gisov nam aplo gile gibweg bekob ete amolmol subu inggas matanos bop ailu nok itangi ei ile. Be Yisu ginei gitangi sulu be ginei, “Yemlu aplongg-aim givin unei atob ayeu nalgum yemlu matanongg-aim be vie vukuri me ma?” Be sulu inei, “Amol Bamo, eilu aplongg-amei givin.” ");
INSERT INTO kbm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Beti Yisu gitak bage giwei sulu matanos be ginei; “Yemlu aplongg-aim givin ayeu beti atob gen ebe gabu tangg-aim givin ve un-gas ok atob ano nile.” ");
INSERT INTO kbm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Beti gabu matanos ponge be ili taku. Be Yisu geb yaun gwangne molge gitangi sulu be gine, “Gabu undi ge! Unei gen etenik ginge nitangi amolmol be inaute bwaya.” ");
INSERT INTO kbm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bemem sulu ile be inei Yisu ane binge gitangi amolmol nangge taku etok be nangge taku subu givin. ");
INSERT INTO kbm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yisu tis ane singamolomb-gen ivang ve ile be amolmol subu inggas amol ti ebe ngalau tiate gilgum be gitangi ve ninei yaun ite ok, itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yisu gitin ngalau tiate etok be gile gihlang gikwai amol nok bekob ete ginei yaun vusa. Amolmol tepwengge ili be ilat bais be inei, “Eitit tali gen bamo ti dang etenik nangge Israel ite molge.” ");
INSERT INTO kbm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bemem amolmol subu nangge Parisai inei, “Ei gitin ngalau tiate etok ve ngalau tiates as amol bamo ebe geb eisir dabin ok ane gwangen.” ");
INSERT INTO kbm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisu givang geb taku etok avut, be gibul amolmol nangge as lum mateu ane aplo gitang-tangi ge, be ginei yaun ebe Pomate ve nemb amolmol dabin ok lavo lavo gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Be gilgum amolmol ebe inggas gimat walang ano ok utlas vie vukuri, be ta viti ve eisir ano-ngge ve gili ebe eisir aplos bunam be imbweg vie ite molge, weik bwelk ebe tivie ma ok. ");
INSERT INTO kbm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Be ginei gitangi ane singamolomb-gen be ginei, “Um etenik ande ane ben gipasang ate gikwai bemem amolmol ebe ve inro ben sut ok aitol ge. ");
INSERT INTO kbm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dang etok be yem unes miengk be unau-tani um tivie veik nihlin ane amolmol kulkul ane subu inme be inro ane ben ano sut nisov ane nam ben ano ane nile.” ");
INSERT INTO kbm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisu gital ane amolmol kulkul ane gitangi 12 be itangi ei ile. Be geb ane gwangne gitangi eisir ve inaitin ngalau tiate nikwai amolmol, be inalgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yisu ane singamolomb-gen 12 etok nok ares eteik: Saimon, ebe ital are ti inei Pita ok, gabu male Endru, be Sebedi natu-nggen Jems gabu male Jon. ");
INSERT INTO kbm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip gabu Batolomyu be Tomas gabu Matai ebe warik geb kulkul takes ane ok. Be Alfias natu Jems gabu Tadias, ");
INSERT INTO kbm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","be Saimon gabu Judas Iskariot ebe asonge ninei Yisu binge nitangi amolmol valir ane ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu gihlin ane singamolomb-gen 12 etok ve inde be inbul Pomate ane yaun nitangi amolmol be ginei gitangi eisir, “Unde amolmol ebe nangge Juda ite ok be tis Samaria as taku bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yem unvang nambe Israel as taku ane unde ve eisir etok imbweg weik ebe bwelk as tivie ma be isov sangas ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Be unbul eisir ve Pomate ane mateu be unei, ‘Gibloblo ve Pomate nemb ane amolmol-gen dabin.’ ");
INSERT INTO kbm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yem unalgum amolmol ebe inggas gimat walang ano ok be tis eisir ebe ngalau tiate givang givin is ok, be eisir ebe inggas gimat bid namvu ok, be utlas vie vukuri. Be unes amolmol ebe imat vunkunu ok itin vukuri. Pomate geb ane gwangne gitangi yem sin-gege be uvgo ite ma, dang etok be atob yem unalgum kulkul sinsin-ge. ");
INSERT INTO kbm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Untak mone ti nisov aim vak ite, ");
INSERT INTO kbm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","be unvwat ben me kup ti nivin ite, uno aim su be unvwat aim kabut luev ane nivin ite. Ve amolmol ete yem ve unemb kulkul ve eisir ane ok atob inemb gen ve yem.” ");
INSERT INTO kbm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ginei yem umbielk nam dabe ti be amol vie ti nangge nam etok ve ninggas yem unpil ane nam unde, okob yem unambweg uvin ei ge love nitangi ebe ve unkwai nam etok ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ginei yem upil nam ti ule, okob avongg-aim nes amolmol nam etok ane be unemb yaun bwaibwaya ane nitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Be ginei eisir tas givin ve in-gas yem unpil as nam unde, okob yem unautani Pomate ve nipasang eisir. Bemem ginei bwais ve ret in-gas yem unpil as nam, okob yem unalgum gen ti bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Be ginei eisir ivkir dumas ve yem be bwais ve ret inaute yem aim yaun, okob unrau nangg-aim lili be guni nitangi eisir be kuku ninumul, be unkwai nam etok. Be atob yem unes eisir as gen tiate ebe ilgum ilgum ok ru nitangi eisir ate. ");
INSERT INTO kbm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ayeu nanei bingano-ngge nitangi yem, asonge nindeb mulane nivin ebe ayeu ve nanumul nanme be nalgum amolmol as yaun ok atob nam dabe etok in-gas bunam tis vavavne bamo molge nitlek ebe warik amolmol tiate ane nangge Sodom tis Gomora inggas ok.” ");
INSERT INTO kbm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Be unaute. Ayeu gahlin yem weik bwelk sipsip ebe ivang isov uvun utap aplo ok. Dang etok be unemb aim ate dabin vie-ngge weik ebe amolmol bwaibwaya ane ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Be undi aim ate-ngge ve atob amolmol inemb aim ta be ingas aim unde be inalgum aim yaun. Be atob inrau aim nangge as lum mateu ane aplo, ");
INSERT INTO kbm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","be intak aim unvarkei amolmol bambamo ebe emb amolmol dabin ok nas, be inalgum yem aim yaun ve gisov ebe ulgum awangg kulkul, be unei Pomate ane binge vie gitangi eisir be tis amolmol gitip ane ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ginei eisir inggas yem ule be iutani yem ve unei aim yaun lavo, okob aplongg-aim bunam ve ebe atob unei yaun ret ok bwaya, me tanggaim nitung walang ano ve atob wali unei aim yaun dang inend ok ite. Ve atob nivin ete yem ve unvarkei amolmol bambambo nas ok atob Pomate nemb yaun ebe yem ve unei ok nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Be yaun ete yem ve unei ok, atob Pomate ane ngalau ninei. ");
INSERT INTO kbm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Be atob amolmol tas nitung as male-nggen ite be inemb eisir nitangi amolmol valir ane be ines eisir vunkunu. Be nunus tamas-gen ok atob inalgum weik etok ge nitangi natus-gen, be nunus atob bwais ve tamas-gen tis tinas-gen be atob amolmol valir ane ines eisir vunkunu. ");
INSERT INTO kbm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amolmol subu atob bwais ve yem ve gisov ebe ulgum awangg kulkul ok, bemem amol ti ginei ta gitung ayeu be giro ate ta be gigas vavavne painge love gen bunam bamo etok ma, atob Pomate ninggas ei be nimbweg vie nindeb mulane. ");
INSERT INTO kbm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ginei amolmol nangge namb dabe ti bwais ve yem be inei yaun ungglus ungglus gipil yem, okob unkwai nam etok be unde nam dabe ti. Ayeu nanei bingano-ngge nitangi yem, yem gitangi ebe atob unemb Pomate ane kulkul unemb Israel as nalk etenik avwut ok ite, be atob Pomate Natu ayeu ebe meng-gahlang weik amolmol ok atob nanumul nanme.” ");
INSERT INTO kbm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nunus lum ane gitangi inatlek as gidung ite. Ginei eisir inaute as gidung ane yaun ge kob atob eisir meinahlang weik ete as gidung ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amol kulkul ane ti gitangi nitlek ane amol bamo ebe geb ei dabin ok ite. Ginei amol etok niute ane amol bamo ane yaun ge kob atob ei menihlang weik ete ane amol bamo ok. Be ginei amolmol intal ngalau tiate tamas are nipil amol bamo ti, okob atob intal ngalau tiate ares nipil amol bamo nok natu-nggen nivin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dang etok be eitit tanpelk ve amol ti ite. Gen walang ebe givwaivun ate ok atob niengk nitip ge be yaun bambamo ebe giengk aplo-ngge ok atob amolmol inatpweng are be ma. ");
INSERT INTO kbm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Be yaun ebe ayeu ganei gitangi yem bwaya-gege ok, yem unei nile nihlang. Be yaun ebe ayeu ganei be yem ate-ngge ute ok, yem unei nitangi amolmo nivin. ");
INSERT INTO kbm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Be unpelk ve Pomate ebe asonge nitin amolmol tis dalgos matawas ane ge insov taku tiate ebe tis yev bamo ebe gienk dang etok inde ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","30","Tamangg-aim Pomate ei gitpweng gen nalk ane are tepwengge love givnawi amolmol dabas lan ok givin. Be gitpweng gen natu natu ebe ve inmat vunkunu ok are givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Dang-etok be yem unpelk ve aim ate bwaya, ve yem gen vie molge gitlek mank be tis gen walang ok.” ");
INSERT INTO kbm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","33","“Amol ti ginei ninei ayeu arengg binge nitangi amolmol, atob ayeu nanei amol etok are vusa nitangi Pomate nindeb mulane. Be ginei amol ti maimae ve ayeu ite be ninei ayeu binge nitangi amolmol, atob ayeu mai-mayangg ve amol etok ite ma be atob nanei ei binge nitangi Pomate ebe gibweg gulumb ok.” ");
INSERT INTO kbm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayeu ganme ve nalgum gen bwaibwaya ane ite ma, ayeu ganme ve nambwas amolmol. ");
INSERT INTO kbm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kob atob amolmol subu bwais ve tamas-gen ve gisov ebe tamas-gen aplos givin ayeu ok, be avie gaptol subu ok atob bwais ve tinasgen be tis lawas avie-nggen ve gisov ebe aplos givin ayeu ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eisir vu ti ginei tepwengge aplos nivin Pomate atob eisir inabweg vie-ngge. Bemem ginei eisir subu aplos givin Pomate ite, atob eisir vu etok inemb is-ate vus-vusa be bwais ve isate. ");
INSERT INTO kbm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Amol ti ginei ta givin tame me tine ano-ngge gitlek ayeu, atob ayeu nali amol etok weik angg amol ti ite. Be ti ginei ta givin natu-nggen ano-ngge gitlek ayeu, atob ayeu nali amol etok weik angg amol ti ite. ");
INSERT INTO kbm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Amol ti ginei bua ve ret ninggas gen bunam tis vavavne nivin ayeu, atob Pomate nital ei ninei natu ite. ");
INSERT INTO kbm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amol ti ginei ta gitung utle ulis bamo molge gitlek ayeu atob amol etok nimbweg vie ite nindeb mul ane. Be ti ginei aplo givin ayeu be ta givin ve nilgum awangg yaun ano nile, be ei gimat vunu ve awangg kulkul, atob amol etok nimbweg vie nideb mulane nangge Pomate ane taku.” ");
INSERT INTO kbm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Amolmol ebe inggas mie gupil as nam gule ok weik ebe inggas ayeu be tis Amol ebe gihlin ayeu be ganme ok. ");
INSERT INTO kbm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amolmol ebe ili amol ebe ginei Pomate ane avo ok ti be itpweng are inei etok Pomate ane amol kulkul ane ti, be inggas ei gipil as nam gile ok, eisir etok atob in-gas gen vie ete amol etok atob ninggas nindeb mul ane ok invin. Be amolmol ebe inggas amol vie molge ti ipil as nam ile ve gisov ebe ei amol vie ane ok, ete atob in-gas gen vie ete amol mok ve niggas nindeb mul ane ok invin ei. ");
INSERT INTO kbm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Amol ti ginei gili awangg singamolomb ti be gitpweng are ginei etok awangg singamolomb-gen ti be geb bui luvus ge ve ei ginum, atob amol etok ninggas gen vie nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisu geb yaun kulkul ane gitangi ane singamolomb-gen 12 etok gikwai, kob ete gimdil gikwai taku etok be gile ve gibul be ginei mateu ve amolmol nangge nam dabe subu ebe gibloblo taku etok ok. ");
INSERT INTO kbm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Givin ebe Jon ebe ges bui sanggu gipil amolmol ok gibweg kapual-lu be ei giute gen bwalbwale bambamo ebe Kilisi gilgum ok binge, be gihlin ane singamolomb-gen subu be itangi Yisu ile be iutani ei be inei, ");
INSERT INTO kbm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Mie amol etenik ebe warik Jon ginei asonge ninme ok, me amol etok givang nangge?” ");
INSERT INTO kbm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yisu giwel eisir avos be ginei, “Undumul unde be unei gen ete ande uli be ute nik binge itangi Jon. ");
INSERT INTO kbm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Be unei amolmol ebe matanos bop ok ande ili gen vukuri, be ebe vas dubi bingbleng ok ande ivang vie vukuri, be eisir ebe inggas bid namvu be tis eisir ebe talngas-avo gitu ok ande utlas vie be iute yaun vukuri. Be amolmol ebe imat vunkunu ok imdil vukuri be Pomate ane amolmol imbul ei ane binge vie gitangi amolmol ebe aplos givin Pomate gwangne ite ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Be ginei amol ti aplo ailu ailu ve ayeu ane ite, amol etok atob nivang tis ta vevie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon ane singamolomb-gen ile ikwai kob Yisu ginei yaun gipil Jon gitangi amolmol be gine, “Warik yem ule taku sawa ve undi amolmol me gen sin-ge ti? ");
INSERT INTO kbm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me yem ule ve undi amol ti ebe gino kup vevies ge ok? Ma yapin. Amolmol ebe ino kup vevies ge ok eisir imbweg nangge amol bamo ebe geb amolmol dabin ok ane nam ge. ");
INSERT INTO kbm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Be yem ule ve undi gen ret, ve undi Pomate ane amol ti ebe ginei ei avo ok me? Bingano. Ayeu nanei nitangi yem. Amol etok ei gitlek Pomate ane amolmol kulkul ane walang ok. ");
INSERT INTO kbm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Be amol nok etok ebe warik Pomate ane amolmol ebe inei ei avo ok inei yaun gipil ei ok. Ve Pomate ginei gitangi Kilisi. Amol ebe ve nemb amolmol ru ok be ginei; ‘Atob ayeu nahlin angg amol yaun ane ti be nimungg nile be nipasang miam liev yapin.’ ");
INSERT INTO kbm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dang etok be ayeu nanei bingano-ngge nitangi yem nanei, Jon ebe ges bui sanggu gipil amolmol ok ei amol vie molge gitlek amolmol tepwengge nangge nalk. Bemem amol sin-ge ti ginei ta givin ano-ngge ve Pomate nemb ei dabin, okob amol etok ei vie molge gitlek Jon. Ve Jon ei gisov taku ebe ve Pomate nemb ei dabin ok gile ite nangge, be ei ginei ane yaun ge. ");
INSERT INTO kbm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Givin ebe Jon ebe ges bui sanggu gipil amolmol meng-gihilang ok be ginme love galkik asmate etenik, amolmol walang ano lolos ve insov taku ebe Pomate ve nemb amolmol dabin ok inde. ");
INSERT INTO kbm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amolmol ebe inei Pomate avo be tis Mose ane yaun ok, inei yaun binge gipil taku ete Pomate ve nemb amolmol dabin ok painge ginme love Jon ebe ges bui sanggu gipil amolmol ok ande meng-gihlang. ");
INSERT INTO kbm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Be ginei yem aplongg-aim nivin eisir as yaun ge atob yem unatpweng are unei Jon ei weik Ilaija ebe warik Pomate ane amolmol kulkul ane inei ‘Asonge ninme’ ok. ");
INSERT INTO kbm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ginei yem talngangg-aim avo giengk be unaute awangg yaun ma.” ");
INSERT INTO kbm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ayeu atob namb bing-ai ti nipil yem bekob. Yem weik nunus ebe ivang as nam luvwe ok be atob eisir intal nitangi nunus dubi ti be inei, ");
INSERT INTO kbm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Amei as amb benmem yem tangg-aim givin ve unes uye ite. Be amei as uye tangir ane bemem yem tanggaim givin ve unalgum tangir ite.’ ");
INSERT INTO kbm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon ebe ges bui sanggu gipil amolmol ok ginme be gen ben be ginum bui vavis ite, be amolmol ili be inei ngalau tiate ti wat givang givin amol etenik. ");
INSERT INTO kbm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Be Pomate Natu ayeu ebe meng-gahlang weik amolmol ok ganme be gan be ganum kob amolmol ili be inei; ‘Ta-undi amolmol ebe ilgum kulkul takes ane ok tis amolmol tiate ane as nune ebenik bom-tine tiate molge.’ Bemem Pomate ges ane dabe-gwet ru gitangi eitit gipil ane kulkul ebe gilgum ok, beti eitit tatpweng are tane Pomate ane yaun, etok yaun ano molge.” ");
INSERT INTO kbm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisu ta vavis be gigo amolmol ebe nolge ili gen bwalbwale ebe warik ei gilgum ok gikwai, bemem iro is-ate vukir ite ok be ginei; “Ayeu galgum gen bwalbwale ano-ngge nangge yem aim taku be uli gikwai, bemem aplongg-aim givin ayeu be uro aim ate vukir ukwai aim tiate aplo ite molge ba. ");
INSERT INTO kbm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yem amolmol nangge Korasin be nangge Betsaida, asonge yem un-gas vavavne bamo molge. Gen bwalbwale ete ayeu galgum nangge yem aim taku ok, ginei ayeu nalgum nangge amolmol tiate ane as taku nangge Taia tis Saidon, atob eisir aplos nivin be inro is-ate vukir inkwai as tiate aplo seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Asonge nindeb mul ane atob Pomate nipasang amolmol nangge Taia be Saidon vie molge nitlek yem. ");
INSERT INTO kbm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Be yem amolmol nangge Kapenaum, yem ulgum ve avongg-aim givwat aim ate bemem asonge yem unreu yev. Gen bwalbwale ete ayeu galgum nangge yem aim taku nik ginei ayeu nalgum nangge Sodom as taku, atob eisir inambweg nik nangge. ");
INSERT INTO kbm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bemen ayeu nanei bingano-ngge nitangi yem, asonge nindeb mul ane atob yem un-gas vavavne bamo molge nitlek ebe amolmol Sodom ane ve in-gas ok.” ");
INSERT INTO kbm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Givin sawa etok Yisu ges miengk gitangi Pomate be ginei, “Tamangg. Mie Amol bamo ebe gob gulumb tis nalk dabin ok. Ayeu tag vie-ngge gitangi mie ve amolmol ebe tas gitung inei eisir dabas-gwet vie molge ok, ete iute miam yaun bemem itpweng are be aplos givin mie ite. Bemem eisir ebe ili is-ate weik nunus ok ete iute miam yaun be itpweng are be aplos givin mie. ");
INSERT INTO kbm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tamangg, gen etok ano gile gitangi ebe mie ate tam gitung ok.” ");
INSERT INTO kbm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Be Yisu ginei gitangi eisir, “Tamangg ei geb gen walang ok gitangi ayeu gikwai, be amol ti gitpweng Pomate Natu are ite. Tamangg ei dongke-ngge, be amol ti gitpweng Tamangg are ite, Ayeu dongke-ngge gatpweng Tamangg are. Be amolmol ebe ayeu ganei Tamangg ane yaun binge gitangi eisir be tas givin ve inalgaum yaun etok ano nile ok, eisir etok ete itpweng Tamangg are givin. ");
INSERT INTO kbm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Amolmol ebe ivang be inggas bunam walang ano ok, ginei intangi ayeu inme be invang mul ve ayeu, atob inambweg vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ve ayeu amol bwaibwaya ane be ayeu amol ebe gab amolmol dabin nangg gali ok, be atob yem unambweg luvus vie. ");
INSERT INTO kbm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Be gen bunam ete ayeu ve nanggas ok atob yem un-gas nivin. Bemem gen etok bunam molge ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Givin Sonda Sabat luvwe ti Yisu tis ane singamolomb-gen ilauk ivang um ti aplo. Be eisir singamolomb marav ges is be ile ipis yanggo ebe givarkei um aplo ok be en. ");
INSERT INTO kbm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Be Farisai subu ili be ile inei gitangi Yisube inei, “Miam singamolomb-gen ilgum gen gitangi ebe ve tanalgum nivin Sonda ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yisu giwel eisir avos be ginei, “Yem uvnauwi (usam) yaun be Dawit tis ane amolmol-gen marav ges is be ilgum ok gikwai me ma? Dawit tis ane amolmol-gen ben ma be marav ges is. ");
INSERT INTO kbm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Be Dawit gisov Pomate ane nam mateu ane aplo gile be amol bamo ebe geb lum yamar dabin ok geb ben ebe Juda emb ve da gitangi Pomate ok, gitangi Dawit be givwat gile be tis ane amolmol-gen en. Be ben etok gitangi ebe amolmol ebeok sinsin-ge inen ok ite, etok bambamo ebe emb kulkul da ane nangge lum yamar ok ge gitangi inen ben etok. ");
INSERT INTO kbm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Be usam Mose ane yaun gikwai me ma? Givin Sonda walang ok amolmol ebe emb kulkul da ane nangge lum yamar ok, eisir ilgum kulkul tis Sonda givin. Bemem eisir ilgum gen tiate ti ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ayeu nanei bingano-ngge nitangi yem. Gen ebe vie molge gitlek lum yamar ok ete galkik giengk yem nangg-aim gili nik. ");
INSERT INTO kbm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bemem ginei yem unatpweng yaun eteik: ‘Ayeu bwaingg ve ret yem unemb da ge. Ayeu tangg givin ganei yem tangg-aim nivin aim ate be unvang vie-ngge,’ are vevie okob atob gitangi ebe ve unemb bunam nitangi amolmol ebe ilgum tiate ite ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Be Sonda tivie Pomate Natu ayeu ebe meng-gahlang weik amolmol ok givin.” ");
INSERT INTO kbm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisu gikwai taku etok be gile gisov eisir nok as lum mateu ane aplo gile. ");
INSERT INTO kbm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Be amol ti ebe bage tavlu gimat ok gisov lum aplo gile givin ve niute Yisu ane yaun ebe ginei ginei ok. Be amolmol ebe irek Yisu ane luev ve inemb ei ta ok, itangi Yisu ile be iutani ei be inei. “Gitangi ebe tanalgum amolmol ebe tis gimat ok be utlas vie vukuri nivin Sonda ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yisu giwel eisir avos be ginei, “Ginei yem ate aim amol ti ane bwelk ti gibieg gisov nalk avo undib ti givin Sonda, okob amol nok atob nile be nemb kulkul ve nirwel ane bwelk nok nikwai nalk avo etok tis Sonda me ma? ");
INSERT INTO kbm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yem amolmol, yem gen vie molge gitlek bwelk dang-etok be gitangi ginei tanalgum amolmol ebe tis gimat ok be utlas vie vukuri tis Sonda ok nivin.” ");
INSERT INTO kbm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bekob Yisu ginei gitangi amol bage gimat ebok be ginei: “Uto bagem!” Amol nok gito bage be bage vie vukuri weik ebe bage tavlu ok. ");
INSERT INTO kbm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Beti eisir Parisai imdil be ile ihlang ikwai lum aplo ve kakie gipil luev ebe ve ines Yisu vunu ok. ");
INSERT INTO kbm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisu gitpweng Parisai as yaun ebe ilgum ok are gikwai beti gikwai taku etok be gile. Be amolmol anongge itau ile ei ve ile be Yisu gilgum amolmol ebe tis gimat ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Be ginei yaun gwangne molge gitangi eisir ve inei ete Pomate Natu ei ok binge nitangi amolmol subi bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Beti yaun ebe warik Pomate ane amol ebe ginei ei avo ok, Aisaia ginei ok ande ano gile. Ve Pomate ginei dang-eteik; ");
INSERT INTO kbm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ayeu angg amol kulkul ane dongke etenok ebe gab ei be gali ei vie molge ok. Atob ayeu namb angg ngalau vie nile nivang nivin ei be atob ei ninei yaun ebe asonge ayeu nalgum amolmol as yaun ok binge nitangi amolmol tepwengge. ");
INSERT INTO kbm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Be ei gitangi ebe ve ninggo amolmol me avo bambamo nitangi amolmol nangge luev bambamo ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Atob ei na nili eisir ebe tulkwas ma ok be nipasang eisir vie-ngge. Be gitangi ebe atob niyaing eisir ok ite. Ei atob nilgum kulkul dang-etok painge viek nilgum be luev yaun ano ane menihlang bamo ge. ");
INSERT INTO kbm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Be amolmol gitip ane atob aplos nivin ei, be inambweg be nas niengk ei ge.” ");
INSERT INTO kbm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Givin sawa etok ge amolmol subu inggas amol matano bop ti ebe ngalau tiate givang givin ei be gitangi ve ninei yaun ite ok itangi Yisu ile. Yisu gilgum amol nok be matano ponge be gili taku be ginei yaun vusa. ");
INSERT INTO kbm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amolmol tepwengge ili be ikuri vunungge be inei, “Etenik wat Dawit ane vaku ebe ve nemb eitit ru ok me?” ");
INSERT INTO kbm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisai subu iute be inei, “Amol etenik gitin ngalau tiate ve ngalau tiate tamas (Belsebul) ane gwangne.” ");
INSERT INTO kbm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yisu ande gitpweng eisir as yaun are gikwai beti ginei, “Nam dabe ti ginei inemb is-ate vusa be ines is-ate, atob eisir etok inambweg vie ite. Be eisir vu ti ginei inemb is-ate vusa be ines is-ate atob inambweg vie ite. ");
INSERT INTO kbm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Be Sadam ane amolmol-gen ok weik etok ge. Ginei eisir inemb is-ate vusa be ines valir nitangi is-ate, atob eisir indi is-ate inei eisir vu ti ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yem unei ayeu gaitin ngalau tiate ve Sadam ane gwangne, be amol ret geb ane gwangne gitangi yem aim amolmol-gen ete itin ngalau tiate gikwai amolmol ok? Kob yem ate aim amolmol-gen inei yaun etok lavo itangi yem. ");
INSERT INTO kbm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bemem ginei ayeu gaitin ngalau tiate ve Pomate ane Ngalau Yamar ane gwangne, atob yem unatpweng are unei Pomate ande geb yem dabin asmate etenik.” ");
INSERT INTO kbm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Be Yisu ginei yaun ti vukuri be ginei, “Amol ti gitangi nisov Sadam ane nam aplo nile be nivwat ei ane wambal nikwai ite. Ei nidgin amol lai etok ta okob atob nisov amol etok ane nam aplo nile be nivwat ei ane wambal nikwai. ");
INSERT INTO kbm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Amol ti ginei ta nivin ayeu ite, amol etok ebe gili ayeu tiate be ve nes valir nitangi awangg amolmol-gen ok. Be amol ti ginei giute awangg yaun, bemem bua ve ret nemb awangg amolmol-gen ru, amol etok weik ebe ve nitin awangg amolmol-gen be nivin-vin is niriv be nira ok. ");
INSERT INTO kbm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dang-etok be ayeu nanei bingano-ngge nitangi yem nanei, Pomate gitangi ebe atob nisin amolmol as gen tiate ebe ilgum be inei ok tepwengge nikwai ginei eisir inei as tiate vusa nitangi Pomate. Bemem amol ti ginei ninei yaun tiate ti nipil Ngalau Yamar. Atob Pomate nisin ei ane tiate etok nikwai ite ma yapin. ");
INSERT INTO kbm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Be amol ti ginei ninei yaun tiate nipil Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, atob Pomate nisin ei ane tiate etok nikwai. Bemem ti ginei ninei yaun ungglus ungglus nipil Ngalau Yamar, okob Pomate gitangi ebe atob nisin amol etok ane tiate etok nikwai ti galkik be mul ane ok ite, ei ane tiate etok atob niengk dang etok.” ");
INSERT INTO kbm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ei ebe vie ok ges ane ano vie, be ei ebe tiate ok ges ane ano tiate weik etok ge. Amolmol itpweng ei ebe vie be tiate ok are giengk ei nok ane ano be inei, ei etok vie be etok taite. ");
INSERT INTO kbm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Be yem weik ebe mwat valir ane ok. Yem amolmol tiate ane roro be gitangi ebe atob unei yaun vie ti menihlang avongg-aim ok ite ma yapin. Amolmol tas gitanung yaun walang ano nangge aplos bekob inei gile gihlang. ");
INSERT INTO kbm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amol ti ginei ta gitung yaun vie-ngge giengk aplo atob ei ninei yaun vie-ngge menihlang avo. Be amol ti ginei ta gitung yaun tiate giengk aplo, atob ei ninei yaun tiate menihlang avo weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Bemem ayeu nanei nitangi yem. Asonge nindeb mul ane nivin ebe Pomate ve nilgum amolmol tepwengge as yaun ok, atob Ei niutani amolmol ve yaun bambamo ebe inei inei ok ane. ");
INSERT INTO kbm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Be ginei amol ti ginei yaun vie-ngge, atob Pomate nital ei ninei amol vie, be ginei amol ti ginei yaun tiate-ngge, atob Pomate nital ei ninei amol tiate.” ");
INSERT INTO kbm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Givin sawa etok gidung subu ebe emb Mose ane yaun dabin ok be tis Parisai subu ile inei gitangi Yisu be inei; “Gdung amei tanggamei givin anei mie nulgum gen bwalbwale ti be amei andi kob veik anatpweng are anei mie nangge Pomate ane be gunme.” ");
INSERT INTO kbm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yisu giwel eisir avos be ginei, “Yem wasi tinangg-aim. Yem utani ayeu ve gen bwalbwale ane, bemem ayeu wat nalgum gen bwalbwale ti be yem undi ite. Gen bwalbwale dongke ebe warik Pomate gilgum gitangi ane amol kulkul ane Jona ok ge, ete atob ayeu nas ru nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Warik Jona giengk wenk (bagola) bamo ti aplo gitangi tambok aitol be asmate aitol. Dang-etok be atob Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob namat vunu be nayengk nalk aplo nitangi tambok aitol be asmate aitol weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Be unaute! Asonge nindeb mul ane nivin ebe amolmol tepwengge ve invarkei Pomate na ok, atob amolmol Niniwe ane inamdil be inalgum amolmol galkik ane as yaun invarkei Pomate na. Ve eisir iute Pomate ane yaun ebe Jona ginei gitangi is ok be iro is-ate vukir seukie-ngge ikwai as tiate aplo. Be Pomate Natu Ayeu, Ayeu gatlek Jona bemem yem ute awangg yaun be aplongg-aim givin be uro aim ate vukir ukwai aim tiate aplo ite molge. ");
INSERT INTO kbm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Be gen dang etok ve asonge nindeb mul ane atob avie bamo ti (kwin) ebe geb amolmol dabin nangge as gireu ok atob nivarkei Pomate na be ninei amolmol as-mate etenik ane as tiate bambamo ebe ilgum ilgum ok binge nitangi Pomate. Ve gisov avie bamo nok ei gibweg taku undib molge gibweg ebe nalk ane den ok, bemem ei gimdil nangge taku undib etok be ginme ve niute Solomon ane avo ukwas. Be ayeu nanei nitangi yem, Pomate Natu Ayeu ebe meng-gahlang weik amolmol gatlek Solomon bemem yem ute awangg yaun be aplongg-aim givin awangg yaun ite.” ");
INSERT INTO kbm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ngalau tiate ti ginei gile gihlang gikwai amol ti, atob ngalau tiate nok nile ve nivang taku raras ane ve nirek taku ebe ve nimbweg ok. Bemem ginei ei nili taku ti ebe ve nimbweg ok ite, ");
INSERT INTO kbm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","okob atob ninei ve ate be ninei, “Ayeu nanumul nale angg nam ebe warik meng-gahlang nangge ok vukuri.” Be ginei ei nimbielk ve ane nam warik ok vukuri be nili ane nam nok ebe aplo sawa viengge giengk ok, ");
INSERT INTO kbm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","okob atob ninumul nile be ninggas ngalau tiate 7 vukuri ebe as gwangne gitlek ngalau tiate mate ane etok ane ok, be inde tepwe inambweg invin ei. Kob atob amol etok nimbweg vie ite nitlek ebe warik gimungg ane ok. Amolmol tiate as-mate etenik ane atob invang weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisu ginei yaun gitangi amolmol givang ge be tine tis male-nggen mimbielk ve nam ete Yisu gibweg ok be ile ivarkei sagin dume, be ilgum ve inei yaun nitangi ei. ");
INSERT INTO kbm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Beti amol ti gile ginei gitangi Yisu be ginei, “Tinem tis am male-nggen ete ande inme be ivarkei sagin dume ok, be tas givin ve indi mie.” ");
INSERT INTO kbm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yisu giwel amol etok avo be ginei, “Ayeu nanei tinangg-gen tis angg male-nggen lavo nitangi yem be unaute okob,” ");
INSERT INTO kbm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","be girusu bage gitangi ane singamolomb-gen be ginei. “Ayeu tinangg-gen be tis angg male-nggen eisir nok etenik. ");
INSERT INTO kbm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Amolmol ebe iute Tamangg ebe gibweg gulumb ok ane yaun be tas givin ve inalgum ano nile ok, eisir etok ete ayeu tinangg-gen be angg male-nggen.” ");
INSERT INTO kbm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Givin sawa etok ge Yisu nangge nam aplo gile gitak be gile ve givang alus ane. ");
INSERT INTO kbm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Be amolmol anongge iro is-ate sut itangi ei ile love ile isung-sungi ei ge, beti gile gipil ei-vovo natu ti be gile giivwev aikawe gikwai alus den. Be amolmol tepweng ivarkei alus. ");
INSERT INTO kbm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yisu ginei yaun avo walang ano gitangi eisir, be ginei gipil bing-ai ge be ginei, “Amol ti gile be gidawi ben uve nangge ane um. ");
INSERT INTO kbm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ei gidawi givang be ben uve subu beleinge gile gitak luev, be gisov nalk aplo gile ite, beti mank ile be en gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Be ben uve subu beleinge gile gitak nalk ebe tis vat ok, be nalk etok sisi ma, be ben nok gireu bemem wakas gisov nalk aplo gile ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Be as gireu be ges ben etok love ainggwen be gimat. ");
INSERT INTO kbm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Be subu beleinge gisov euk dabe dabe, be euk gireu love ges vunu be ben etok ges ano ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Be ben uve subu gisov nalk ebe vie ok be gireu love ges ano vevies ge. Subu ges ano gitangi 100, be subu ges gitangi 60, be subu ges ano gitangi 30.” ");
INSERT INTO kbm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Be Yisu ginei gitangi eisir, “Ginei yem talngangg-aim avo gienk okob unaute yaun etok vevie.” ");
INSERT INTO kbm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bwayage kob Yisu ane singamolomb-gen itangi ei ile be inei, “Namnambed be mie gob yaun gipil bing-ai ge gitangi eisir?” ");
INSERT INTO kbm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yisu giwel eisir avos be ginei, “Pomate geb dabas-gwet ebe ve inatpweng gen are ok gitangi yem gikwai beti yem utpweng yaun ebe givwaivun ate-ngge nangge Pomate ane taku ebe geb amolmol dabin ok are gikwai, bemem eisir etenik ge ete itpweng are ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amol ti ginei gitpweng luev ebe Pomate ve nemb amolmol dabin ok are, atob ei nitpweng Pomate ane kulkul walang ok are. Bemem amol ti ginei gitpweng luev ebe Pomate ve nemb amolmol dabin ok are ite, atob ei nitpweng Pomate ane kulkul are ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bing-ai bambamo ete ayeu ganei gitangi eisir ok, gisov eisir matanos ok giengk bemem bwais ve ret indi gen vevie. Be talngas-avo ok giengk bemem bwais ve ret inaute yaun vevie be inatpweng are. ");
INSERT INTO kbm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Beti ande yaun ebe warik Pomate geb gitangi ane amol kulkul ane Aisaia be ginei vusa ok ande ano gile. Aisaia ginei dang-eteik: ‘Yem ok atob lolongg-aim ve unaute yaun bemem atob tanggaim nisgil yaun ane dabe. Be matanongg-aim ok atob undi gen bemem atob undi gen ti ano ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eisir etenik aplos dadani gikwai, be talngas-avo bua ve ret niute yaun, be imbiti matanos avwut be bwais ve ret indi gen. Eisir iute yaun bemem tas gisgil yaun ane dabe. Be ginei eisir aplos dadani ite be talngas-avo inaute yaun be matanos indi gen be inatpweng gen ar-kare, atob eisir invang intangi ayeu inme be ayeu nalgum eisir be vias.’ ");
INSERT INTO kbm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bemem yem, yem unvang tis tanggaim vevie-ngge ve yem matanongg-aim gili gen be talngangg-aim avo giute yaun. ");
INSERT INTO kbm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ayeu nanei bingano-ngge nitangi yem. Warik Pomate ane amolmol kulkul ane ebe inei ei avo ok be tis amolmol vevies ane subu, ilgum ve indi gen ete ayeu galgum nik, bemem ili ite. Be eisir ilgum ve inaute yaun ete ayeu ganei nik, bemem iute ite.” ");
INSERT INTO kbm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Be unaute. Bing-ai etok ane dabe dang-eteik: ");
INSERT INTO kbm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amolmol ebe iute yaun ebe Pomate ve nemb amolmol dabin ok bemem itpweng are ite ok, eisir etok ete weik ben uve ebe beleinge gile gitak luev ok, be Sadam ginme be girwel mateu ete eisir iute ok gikwai eisir aplos. ");
INSERT INTO kbm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Be ben uve ebe gisov nalk tis vat ok, ete weik amolmol ebe iute mateu, ");
INSERT INTO kbm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","be tas vevias ge, bemem givin ebe amolmol subu inggo eisir gisov mateu ok, eisir ivkir dumas gitangi mateu etok seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Be ben uve ebe gisov euk dabe ok, ete weik amolmol ebe iute mateu ok iute bemem gen nalk ane geb eisir nas lili be tas gitung yaun mone ane gitlek ok. Be mateu ete eisir iute ok, gitangi ebe atob inbul nitangi amolmol subu nivin ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Be amolmol ebe iute Pomate ane mateu be itpweng are be tas givin ve inalgum ano nile ok, ete weik ben uve ebe gisov nalk vie be ges ano gitangi 100, be subu gitangi 60, be subu gitangi 30 ok.” ");
INSERT INTO kbm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu ginei bing-ai ti vukuri gitangi eisir be ginei, “Pomate geb amolmol dabin ane luev weik amol ebe gidawi ben uve nangge ane um ok. ");
INSERT INTO kbm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Be givin tambok amolmol tepwengge iengk ikwai kob amol ebe ta vavis ve amol etok ok gile be givro taku ebeok sinsin-ge gile givin ben uve ebe um tivie gidawi ok be gile ve givang. ");
INSERT INTO kbm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ben etok gireu givang love ve nes ano be um tivie ane amolmol kulkul ane ili ebe taku ebeok sinsin givarkei givin ben ok, ");
INSERT INTO kbm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","be ile inei gitangi um tivie inei, “Mie gudawi ben uve vevies ge gisov am um bemem wali taku tiate bambamo ete givarkei givin ben ok ginme nangge inend?” ");
INSERT INTO kbm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Um tivie giwel eisir avos be ginei, “Etok amol tiate ane ete gilgum gen etok.” Be eisir inei gitangi ei, “Amei ande be anaival taku tiate bambamo etok be ankari nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Be um tivie ginei, “Untau velob unalgum be unaival tis ben subu nivin. ");
INSERT INTO kbm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Be nangg-aim vier be ivarkei tis taku ge dang etok love aiweng ebe ve inro ben ano sut ok, okob atob ayeu nanei nitangi angg amolmol kulkul ane, “Unde be unaival taku tiate bambamo etok nimungg, be unadgin tis vorko tis vorko be unkari nireu yev nile nimungg, bekob unro ben ano sut nisov awangg nam ben ano ane nile.” ");
INSERT INTO kbm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisu ginei bingai ti vukuri gitangi eisir be ginei, “Pomate geb amolmol dabin weik ete wer sivsiev ano ane vatu ok. Wer sivsiev ano ane vatu etok gen natu molge gitlek gen subu. Be amol ti givwat gile be gispun gisov ane um, ");
INSERT INTO kbm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","be bwayage kob gen etok gireu love bamo weik ebe ei ok, be mank ile ipasang as niu gile range.” ");
INSERT INTO kbm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Be Yisu ginei bing-ai ti vukuri be ginei, “Pomate geb amolmol dabin weik ete gielk ok. Avie ti giker siti-ngge gisov ane ul tis ben bekob gitak gile yev, be bwayage kob gielk etok gilgum ben tepwengge be kavkavse.” ");
INSERT INTO kbm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisu ginei yaun gipil bing-ai ge gitangi amolmol, be ei ginei yaun ti ano vusa gitangi eisir ite. ");
INSERT INTO kbm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yisu gilgum gen dang-etok veik nilgum be yaun ebe giengk Pomate ane kapia ok ano nile. Ve yaun ebe giengk Pomate ane kapia ok ginei dang-eteik: ‘Atob ayeu nanei yaun nipil bing-ai ge nitangi amolmol be atob nanei yaun ebe givwaivun ate-ngge givin ebe Pomate gipasang nalk tis gulumb ok nitangi eisir.’ ");
INSERT INTO kbm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yisu gimdil gikwai amolmol be gisov nam aplo gile bekob ane singamolomb-gen itani ei ile be inei, “Mie unei bing-ai ete gipil vuavwe ok ane dabe itangi amei kob.” ");
INSERT INTO kbm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yisu giwel eisir avos be ginei, “Amol ebe gidawi ben uve vie nangge um ok, etok Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok. ");
INSERT INTO kbm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Be um etok weik nalk etenik, be ben uve vie etok weik amolmol ebe Pomate geb is dabin ok. Be vwavwe etok weik Sadam ane amolmol gen. ");
INSERT INTO kbm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Be amol ebe givro taku tiate etok gile givin ben ok etok Sadam ei ate. Be aiweng ebe ve inro ben ano sut ok, etok weik ebe asonge nindeb mul ane ok. Be amolmol ebe ve inro ben ano sut ok, etok Pomate ane ngalau kulkul ane. ");
INSERT INTO kbm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Be Taku tiate ete ve inkari nireu yev nile ok, ete asonge nindeb mul ane atob Pomate nilgum weik etok ge nitangi Sadam ane amolmol-gen. ");
INSERT INTO kbm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Atob Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob nahlin angg ngalau kulkul ane be inde be in-gas amolmol ebe imbul amolmol subu ve gen tiate be tis eisir ebe ilgum tiate ok inkwai Pomate ane amolmol-gen nangge ane taku ebe geb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Be atob inkari eisir etok tepwengge inreu yev bamo etok aplo inde, be atob eisir inteng be ingas vavavne bamo molge. ");
INSERT INTO kbm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Be amolmol ebe aplos givin Pomate be tas givin ve inalgum ei ane yaun ano nile ok, atob inambweg tis tas vevias ge be as bogbogo atob niro nangge Tamas Pomate ane taku. Ginei yem talngangg-aim avo giengk okob unaute yaun etenik vevie.” ");
INSERT INTO kbm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pomate geb amolmol dabin weik gen vie molge ti ebe givwaivun ate giengk nalk sawa ti ok. Be amol ti gile love gili gen vie etok ebe giengk ok, be gile givwaivun vukuri. Bekob givang ane nam ane tis ta vevie-ngge ve gile be geb ane gen walang ok be amolmol ivgo. Be bwayage kob givwat gen etok ane mone gile be givgo nalk sawa etok be gigas tis gen vie etok givin.” ");
INSERT INTO kbm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yisu ginei bing-ai ti givin be ginei, “Pomate geb amolmol dabin weik ebe amol ti girek gen vie molge ti ve nivgo ok. ");
INSERT INTO kbm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Be givin ebe amol nok gili gen vie etok ok, ei gilumul gile be geb ane gen walang ok gitangi amolmol be ivgo. Bekob givwat gen etok ane mone be gile givgo ane gen vie etok.” ");
INSERT INTO kbm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pomate geb amolmol dabin weik ebe amol ti geb kulkul ve gitak ane wasang gisov gielk be giro wenk walang ok sut gisov ane wasang gile, ");
INSERT INTO kbm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","love ane wasang etok gingik ve wenk ge ok. Be bwayage kob ei girwel ane wasang tis wenk etok tepwengge gipil alus gile, bekob givli wenk ebe vevies ok be gitak giengk atane, be wenk ebe tiate ok ei gikari gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dangetok be asonge nideb mul ane atob Pomate nilgum weik etok ge nitangi amolmol. Atob Ei ninei nitangi ane ngalau kulkul ane be atob inme be inavli amolmol ebe aplos givin Pomate ok inkwai eisir ebe ilgum gen tiate nangge nalk etenik ok. ");
INSERT INTO kbm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Be atob inkari amolmol tiate ane etok tepwengge inreu yev bamo eb giengk dang etok ok inde. Be nangre tok atob eisir ingas vavavne bamo molge be atob inteng anongge nangge yev bamo etok aplo.” ");
INSERT INTO kbm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bekob Yisu giutani eisir be ginei, “Ande utpweng yaun bambamo etok are me ma?” Be eisir iwel Yisu avo be inei, “Ande amei atpweng are.” ");
INSERT INTO kbm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Be Yisu ginei, “Dangetok be amolmol bambamo ebe emb Mose ane yaun dabin ok ebe itpweng yaun ebe gipil Pomate ane taku ebe geb amolmol dabin ok are gikwai ok, atob eisir etok weik amolmol ebe itpweng yaun mwanggane be tis yaun vaku galkik ane are ok.” ");
INSERT INTO kbm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisu ginei bing-ai etok be ma gikwai kob gikwai taku etok be gile. ");
INSERT INTO kbm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yisu gibielk ve ei ate ane nam roro be ginei mateu gitangi amolmol nangge as lum mateu ane aplo. Be amolmol tepwengge ikuri vunungge be inei, “Ei gigas dabe-gwet vie be tis gen bwalbwale bambamo ete gilgum nik nangge inend? Ve ei amol sin-ge ti weik ete eitit nik. ");
INSERT INTO kbm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Amol etenik wat kapenda ti natu me? Be wat tine ete Malia ok be male-nggen ete Jems gabu Josep, be Saimon gabu Judas ok me. ");
INSERT INTO kbm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Be luvu avie-nggen ete wat imbweg ivin eitit nik. Be gen walang etok wali ei gigas nangge?” ");
INSERT INTO kbm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eisir inei yaun walang ano love gilgum be tas vavis gitangi Yisu be bwais ve ret inaute ane yaun. Bemem Yisu ginei gitangi eisir be ginei, “Amolmol nangge nam dabe subu tas givin Pomate ane amol ebe ginei ei avo ok, bemem nangge ei ate ane nam roro amolmol bwais ve ei.” ");
INSERT INTO kbm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Be Yisu gilgum gen bwalbwale ti vukuri nangge ane nam ite ve gili amolmol aplos givin ei ite. ");
INSERT INTO kbm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Givin ebe Herodes geb amolmol dabin nangge Galilaia ok, be ei giute Yisu ane binge ");
INSERT INTO kbm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","be ginei gitangi ane amolmol kulkul ane be ginei, “Amol etok ei Jon ebe ges bui sanggu gipil amolmol ok bingano molge. Be ande wat matawe be gimdil nangge taku gimat ane vukuri me, beti meng-gihlang tis ane gwangne ge be gilgum gen bwalbwale bambamo dang dang-etok. ");
INSERT INTO kbm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Eisir itak Jon gibweg kapual-lu ve gisov Herodes geb male Pilip arue Herodias ponge, beti Jon ebe ges bui sanggu gipil amolmol ok ginei gitangi Herodes nok be ginei; “Mie gulgum gisov ve gob am male Pilip arue ponge.” Beti Herodes ta vavis be ve nes Jon vunu bemem gipelk ve amolmol, ve amolmol ili Jon inei Pomate ane amol ti ebe ginei ei avo ok. ");
INSERT INTO kbm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Givin ebe Herodes gilgum ben ve ei ate ane aiweng ebe tine gikuv ok, be ei geb yaun gile ve amolmol bambamo subu nangge Galilaia ve inme be inen ben etok invin. Be Herodias natu avie gile gihlang be ges uye givarkei amolmol tepwengge nas. Herodes gili love ta vevie anongge, ");
INSERT INTO kbm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","beti gile ginei gitangi Herodias natu avie nok be ginei, “Ayeu nanei bingano-ngge nitangi mie, ginei mie nutani ayeu ve gen ret ret ane, atob ayeu yab-ge be namb nitangi mie.” ");
INSERT INTO kbm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Herodias ginei yaun gisov natu avie be ginei, “Mie nutani ve Jon ebe ges bui sanggu gipil amolmol ok dabe tulkwe ane, veik ayeu nali be natpweng are nanei ande Jon gimat vunu gikwai.” Beti avie natu gile be ginei gitangi Herodes, “Ayeu tangg givin ganei galkik etenik ge mie nudbwen Jon ebe ges bui sanggu gipil amolmol ok savwalo gili be nomb dabe tulkwe nisov bele taptape ti nitangi ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes giute yaun etok be aplo bunam molge bemem ei ta gitung ane yaun ebe galkik ginei nangge amolmol bambamo nas be ginei bingano molge ok. Beti ginei be ane amolmol valir ane ilgum ei ane yaun ano gile. ");
INSERT INTO kbm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herodes gihlin ane amolmol valir ane be ile idbwen Jon savwalo gili nangge ete kapual-lu ok, ");
INSERT INTO kbm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","be itak dabe tulkwe gisov bele taptape ti ile emb gitangi Herodias natu avie, be avie natu givwat gile geb gitangi tine. ");
INSERT INTO kbm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bwayage kob Jon ane singamolomb-gen ile ivwat ei utle ulis ile ispun, bekob ile inei binge gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisu giute ebe Jon gimat vunu ok binge, be gikwai taku etok be tis ane singamolomb-gen ile ipil ei-vovo be es bui kapul gili ile ipil bui tavlu ane ve invang as sawa ti atane-ngge. Amolmol nangge nam nam iute Yisu binge be imdil nangge as nam gitang-tangi ge be itaumul Yisu tis ane singamolomb-gen be ivang ve alus. ");
INSERT INTO kbm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yisu tis ane singamolomb-gen ile itung alus, be Yisu gile gitak gikwai ei-vovo love gili amolmol anongge ebe itangi ei ile ok, be ta viti ve eisir, be gilgum amolmol ebe inggas gimat walang ano ok, be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Givin gibok etok eisir singamolomb itangi Yisu ile be inei, “Ande as gile gikwai be taku etenik taku sawa, be uhlin amolmol be invang intangi nam dabe subu inde veik inavgo ben be inen ma?” ");
INSERT INTO kbm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yisu giwel ane singamolomb-gen avos be ginei, “Eisir atob invang ite, be yem ate-ngge kob unemb ben ve eisir inen.” ");
INSERT INTO kbm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Be eisir singamolomb inei gitangi Yisu, “Amei mei ben siti-ngge be tis wenk ailu-ngge ete giengk ik.” ");
INSERT INTO kbm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Be Yisu ginei gitangi ane singamolomb-gen, “Unvwat gen etok untangi ayeu unme kob.” ");
INSERT INTO kbm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Be ginei gitangi amolmol ve inambweg golonge inwei taku dobo dobo. Yisu geb ben siti tis wenk ailu etok be gidank gireu gulumb be ges miengk gitangi Pomate gikwai kob gible ben tis wenk etok vusvusa be geb gitangi ane singamolomb-gen ve inbwas nitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Amolmol tepwengge en ben siti tis wenk ailu-ngge etok love gibon is vie-ngge, bekob eisir singamolomb iro ben dadanis ebe giengk ok sut gisov sab 12. ");
INSERT INTO kbm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Amolmol ebe en ben etok ok gitangi 5000, bemem ivnawi avie gaptol tis nunus givin ite. ");
INSERT INTO kbm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yisu gihlin ane singamolomb-gen ve inde inpil bui tavlu ane vukuri. Be ei ate ve nimbweg be nihlin amolmol be invang inkwai kob atob nitau nile ane singamolomb-gen. ");
INSERT INTO kbm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yisu gihlin amolmol be ivang ikwai kob ei gireu matendubi ti gile givang ane atane-ngge nangge etok ve nes miengk. ");
INSERT INTO kbm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Be eisir singamolomb tis as ei-vovo ande ile love ile ivwev bui luvwe ge be wavin gituvki be giro is ta tiate molge. ");
INSERT INTO kbm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kavkavav giteng gikwai kob Yisu givang giwei bui dobo ge gitangi ane singamolomb-gen gile. ");
INSERT INTO kbm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eisir singamolomb ili Yisu ebe givang giwei bui dobo ge gitangi eisir gile ok, be ikuri vunu-ngge be inei bwat taku ate ti ete gitangi eisir gile ok, beti ipelk be yayai. ");
INSERT INTO kbm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Be Yisu ginei, “Atengg-aim ireu be unpelk dangetok bwaya, ve ebeik ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita giwel Yisu avo be ginei, “Ginei mie Amol Bamo bingano ge okob nunei be ayeu navang nawei bui dobo ge natangi mie nalek.” ");
INSERT INTO kbm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Be Yisu ginei gitangi Pita, “Unme ma.” Pita gikwai ei-vovo be givang giwei bui dobo ge gitangi Yisu gile. ");
INSERT INTO kbm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bemem Pita gili wavin ane tine be gipelk love gile ges vuew bui dobo be ginei gitangi Yisu, “Amol Bamo, omb ayeu itin.” ");
INSERT INTO kbm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yisu gito bage gile geb Pita itin be ginei gitangi ei, “Mie aplom givin ayeu ano molge ite ve mie aplom ailu ailu.” ");
INSERT INTO kbm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bekob gabu ile ipil ei-vovo be wavin gituvi, ");
INSERT INTO kbm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","be eisir singamolomb tavlu ebe imbweg ei-vovo ok, avos givwat Yisu are be inei, “Mie Pomate Natu bingano molge.” ");
INSERT INTO kbm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yisu tis ane singamolomb-gen es bui kapul gili ile ipil alus nangge Genesaret. ");
INSERT INTO kbm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Be givin ebe amolmol taku etok ane itpweng Yisu are ok, be emb yaun gitangi nam dabe walang ok gile. Be amolmol inggas eisir ebe tis gimat walang ano ok itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Be iutani ei ve inei eisir ebe tis gimat ok bais nile ei utle ulis me ane kup ge. Beti amolmol ebe bais gile Yisu utle ulis me ane kup ge ok tepwengge utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Givin sawa etok ge Parisai subu be tis gidung subu ebe emb Mose ane yaun dabin ok nangge Jerusalem inme be itangi Yisu ile be iutani ei be inei, ");
INSERT INTO kbm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nam-nambed be miam singamolomb-gen ilgum gen gitangi ebe bambamo as luev ok ite, be ivuk bais kob ite be en ben?” ");
INSERT INTO kbm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yisu giwel eisir avos be ginei, “Be yem ate ete uvang mul ve aim bambamo-nggen as luev nik, yem bwaingg-aim ve Pomate ane luev weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pomate ginei dang etok ginei, “Nusov tamem gabu tinem as yaun ane lu vie-ngge, be Amol ti ginei ninei yaun ungglus ungglus nipil tame me tine, atob ines amol etok vunu. ");
INSERT INTO kbm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bemem yem unei dang etok unei, “Gen etok vie ve amol ti ginei ane gen subu weik mone me gen subu subu giengk ebe ve nemb nitangi tame gabu tine ok, bemem atob amol nok ninei nitangi tine gabu tame, ‘Gen galkok atob ayeu namb ve da nitangi Pomate.’ ");
INSERT INTO kbm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Okob etok gitangi, be tame me tine ok ininem.” Ke, yem ulgum gen dang-etok beti uli yem ate aim luev weik gen vie molge be bwaingg-aim ve Pomate ane luev. ");
INSERT INTO kbm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yem amolmol bingkasop ane roro. Pomate ane amol ebe ginei ei avo ok are Aisaia ginei yaun eteik vusa gipil yem etenik bingano ge. Ve Pomate ginei: ");
INSERT INTO kbm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Amolmol nangge taku etenik avos givwat ayeu arengg ve giblus den ge, be aplos giengk aikawe molge gikwai ayeu. ");
INSERT INTO kbm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eisir aplos givin ayeu ano ite, be ivang mul ve eisir ate as luev be iyo innei, ‘Etenik Pomate ane luev.’ ");
INSERT INTO kbm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bekob Yisu gital amolmol be itangi ei ile be ginei gitangi eisir be ginei, “Unaute vevie ge. ");
INSERT INTO kbm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gen ete gisov amolmol avos gile ok giaing amolmol ite ma, bemem gen ete meng-gihlang nangge amolmol avos be inei ok, ete giaing amolmol.” ");
INSERT INTO kbm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Eisir singamolomb itangi Yisu ile be inei, “Eisir Parisai iute yaun ete mie gunei nok be gilgum aplos tiate molge, be mie ate ok wat ande gutpweng are gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yisu giwel ane singamolomb-gen avos be ginei, “Amolmol ebe aplos givin Tamangg ebe gibweg gulumb ok ite ok, ete asonge nindeb mul ane atob ei nitin eisir etok insov yev bamo ebe giengk dang etok ok inde. ");
INSERT INTO kbm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Be nangg-aim vier be invang as gen, ve eisir etok weik ebe amolmol matanos bop ok. Amol matano bop ti ginei nitwem matano bop nune atob sulu isgabu ge invang inriv be inra sinsin-ge love ok-ti gabu inambieg insov bui kapkapul.” ");
INSERT INTO kbm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Be Pita ginei gitangi Yisu, “Mie unei bing-ai galkok ane dabe itangi amei kob.” ");
INSERT INTO kbm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yisu ginei gitangi ane singamolomb-gen be ginei, “Yem ok weik ete eisir Parisai ok, yem utpweng gen are vevie ite, nangge. ");
INSERT INTO kbm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ben ete amolmol en ok, gisov amolmol aplos gile ok bekob gile gihlang vukuri, ");
INSERT INTO kbm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","bemem gen ebe amolmol tas gitung giengk aplos be inei gile gihlang ok, ete gilgum amolmol tiate. ");
INSERT INTO kbm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ve nangge amolmol aplos eisir tas gitung gen tiate walang ano giengk aplos dang-eteik: ines amolmol vunu, invaina gen, inyo inyo amolmol, inei yaun ungglus ungglus nipil amolmol, bwais ve aruas-gen be emb avie gaptol vaku vaku be tis gen ungglus ungglus subu givin. ");
INSERT INTO kbm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gen bambamo etok ete giaing amolmol. Bemem ginei tanen ben tis baind tomtom ge, atob nilgum eitit tiate ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisu tis ane singamolomb-gen ikwai taku etok be ile nam dabe ti ebe gibloblo Taia tis Saidon as taku ok. ");
INSERT INTO kbm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Be avie Kana-an ane ti ebe gibweg taku etok ok gitangi Yisu gile be ginei, “Amol Bamo, Dawit ane vaku mie, tam viti ve ayeu be uitin ngalau tiate ikwai ayeu natungg avie ma, ve ngalau tiate nok gilgum avie natu tiate molge.” Be avie nok ei avie gitip ane ti. ");
INSERT INTO kbm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bemem Yisu ginei yaun ti gitangi avie nok ite, beti eisir singamolomb ile inei gitangi Yisu be inei, “Uhlin avie ete gitau gile eitit be giteng painge-painge ge nik be ile ve ivang ma!” ");
INSERT INTO kbm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yisu giwel avie nok avo be ginei, “Pomate gihlin ayeu ganme ve amolmol Israel ane ge ve eisir etok ivang weik ebe bwelk as tivias ma ok, be amolmol gitip ane ite.” ");
INSERT INTO kbm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bemem avie nok ginme be giro va dubi supwe gisov nalk gitangi Yisu be ginei, “Amol Bamo, omb ayeu ru ma.” ");
INSERT INTO kbm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yisu giwel avie nok avo be ginei, “Gitangi ebe tanemb nunus as ben be tankari nitangi uvun be inen ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Be ei giwel Yisu avo be ginei, “Yaun etenok bingano. Bemem uvun subu ok en ben suksukus ebe amolmol ilgum be beleinge gile gitak lir ok givin.” ");
INSERT INTO kbm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yisu giwel ei avo be ginei, “Mie avie etenik aplom givin ayeu gwangne molge. Beti gen ret ete mie tam givin ve ayeu nalgum nitangi mie ok, atob ano nile.” Be sawa etok ge avie nok natu avie utle vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisu tis ane singamolomb-gen ikwai taku etok be ivang ito ivin bui kapul Galilaia ane ge ve ile. Yisu gireu matendubi ti gile gibweg, ");
INSERT INTO kbm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","be amolmol dubi bamo ti inggas amolmol kubuk ane, be tis eisir ebe matanos bop ok, tis amolmol ebe inggas gimat walang ano ok, be itangi ei ile be itak eisir imbweg imbloblo Yisu. Be Yisu gilgum eisir ebe tis gimat ok tepwengge be utlas vie vukuri, be eisir ebe avos ma ok inei yaun vusa vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Amolmol tepwengge ili ebe ande avos ma inei yaun, be kubuk ane ivang vie, be matanos bop ili gen ok, be tis eisir ebe inggas gimat walang ano be ande utlas vie vukuri ok, be ilat bais be avos givwat Israel as Pomate. ");
INSERT INTO kbm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu gital ane singamolomb-gen be itangi ei ile be ginei gitangi eisir, “Ayeu tangg viti ve eisir etenik ane anongge, ve eisir ivang ivin ayeu gitangi asmate aitol, love ande as ben ebe ve inen ok ande ma gikwai. Be ayeu bwaingg ve ret nahlin eisir be invang as nam ane tis marav nes is ge, velob inde love matanos tumtumi nangge luev be inambieg.” ");
INSERT INTO kbm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eisir singamolomb inei gitangi Yisu be inei, “Wali atob eitit tanvwat ben nangge inend be tanemb nitangi amolmol dubi bamo etenik be inen, ve etenik taku sawa?” ");
INSERT INTO kbm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Be Yisu giutani ane singamolomb-gen be ginei, “Yem aim ben siti giengk me ma?” Be eisir iwel ei avo be inei, “Amei mei ben siti be tis wenk natu dongke-ngge ete giengk ik.” ");
INSERT INTO kbm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Beti Yisu ginei gitangi amolmol ve inambweg golonge, ");
INSERT INTO kbm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bekob geb wenk tis ben siti etok be ges miengk gitangi Pomate gikwai kob gible vusvusa be geb gitangi ane singamolomb-gen ve inbwas nitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amolmol tepwengge en ben etok love gibon is vie-ngge, bekob eisir singamolomb iro ben dadanis ebe giengk ok sut gisov sab 7. ");
INSERT INTO kbm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amolmol ebe en ben etok ok gitangi 4000, be ivnawi avie gaptol tis nunus givin ite. ");
INSERT INTO kbm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yisu gihlin amolmol be ivang as nam ane ikwai kob tis ane singamolomb-gen ile ipil as ei-vovo vukuri be es bui gili ile ipil Magadan as taku. ");
INSERT INTO kbm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eisir Parisai be tis Sadukai subu itangi Yisu ile, be eisir nok ebe ilgum ve inemb Yisu ta ok. Beti iutani Yisu ve nilgum gen bwalbwale ti be eisir indi, veik inatpweng are inei Pomate ane gwangne givang givin ei. ");
INSERT INTO kbm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bemem Yisu giwel eisir avos be ginei, “Yem uli taku vie givin gibok be unei, ‘Atob taku vie molge,’ ");
INSERT INTO kbm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","be givin tistumi uli gulumb dabe ande tumtumi gavul be unei, ‘Atob wavin tis ur ninme.’ Yem uli gen be utpweng are seukie-ngge bemem yem gitangi ebe atob unatpweng gen ete ayeu galgum givin sawa etenik ok are ok ite molge. ");
INSERT INTO kbm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yem amolmol nangge taku etenik aplongg-aim givin ayeu ite molge. Yem amolmol tiate ane roro, yem unei ve undi gen bwalbwale, bemem atob undi gen bwalbwale ebe Pomate gilgum gitangi Jona ok ge. Warik Jona giengk wenk bamo ti (bagola) aplo gitangi asmate aitol be tambok aitol bekob meng-gihlang vukuri.” Be Yisu gikwai eisir be gile. ");
INSERT INTO kbm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","12","Yisu tis ane singamolomb-gen es bui gili ile ipil bui tavlu ane, be Yisu geb Parisai tis Sadukai as luev tiate subu tuvweng gipil yis be ginei gitangi ane singamolomb-gen be ginei, “Nangg aim undi aim ate-ngge ve Parisai tis Sadukai as yis.” Beti eisir singamolomb iute be inei ve isate, “Ei wat ginei yaun etenik ve gisov ebe eitit tavwat ben subu givin ite ok me?” Yisu gitpweng yaun ete eisir inei ok are gikwai be ginei, “Yem tangg-aim gitung ete uvwat ben givin aim ate ite ok ve ret ane? Yem wat aplongg-aim givin ayeu ano molge ite me, beti utpweng gen are ite. Yem tanggaim gitung ben tis wenk siti ebe warik ayeu gab gitangi amolmol 5000 en ok me ma? Be yem uro ben etok ane dadanis ebe en be giengk ok sut gisov sab aivir? Be tis ben be wenk siti ebe ayeu gab gitangi amolmol 4000 en ok, be uro ben etok ane dadanis sut gisov sab aivir? Yem uli gen etok gikwai bemem utpweng are ite, beti unei yaun walang ano gisov ebe uvwat ben subu givin ite ok. Ayeu ganei, Unemb aim ate dabin vie-ngge ve Parisai tis Sadukai as luev.” Be givin etok ge ete eisir singamolomb itpweng are ve Yisu ginei yaun etok gipil eisir Parisai be tis Sadukai as luev ebe ivang ok, be ei ginei yaun ben ane ite. ");
INSERT INTO kbm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisu tis ane singamolomb-gen ile Sisaria Filipai as taku be Yisu ginei gitangi ane singamolomb-gen be ginei, “Amolmol ital Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, inei ret?” ");
INSERT INTO kbm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Be eisir singamolomb iwel Yisu avo be inei, “Amolmol subu ital mie inei Jon ebe ges bui sanggu gipil amolmol ok, be subu inei Ilaija, be eisir subu inei Jeremaia me wat Pomate ane amol ti ebe warik gimungg ane ginei Pomate avo ok.” ");
INSERT INTO kbm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Be Yisu giutani ane singamolomb-gen be ginei, “Be yem ate utal ayeu unei ret?” ");
INSERT INTO kbm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Be Pita ebe ital are ti inei Saimon ok giwel Yisu avo be ginei, “Mie Amol ebe ve nemb amolmol ru ok, be Mie Pomate ebe gibweg einggoto ok ane Natu.” ");
INSERT INTO kbm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yisu giwel Pita avo be ginei, “Jon natu Saimon, mie tam vevie-ngge ve yaun ano ete mie gunei nok, amol ti ginei gitangi mie ite bemem Tamangg ebe gibweg gulumb ok, ginei gitangi mie ginei Ayeu Pomate ane Natu. ");
INSERT INTO kbm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Be ayeu nanei nitangi mie, mie arem Pita ane dabe vat, be asonge ayeu natak angg amolmol-gen invarkei inwei vat nok. Be Sadam ane gen tiate ti gitangi ebe atob nihlu awangg amolmol-gen ponge inkwai vat etok ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Be atob ayeu namb gwangne nitangi mie ve nomb Pomate ane amolmol-gen dabin nangge nalk etenik. Be nangge Pomate ane taku atob ei nemb mie dabin weik etok ge. Mie gitangi unei amolmol as luev vie ebe eisir ve invang ok, be luev tiate gitangi ebe tanvang mul ite ok nitangi eisir. Mie gitangi ebe atob nunei ve amolmol be intau luev etok ok. Be Pomate atob nilgum weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Be Yisu ges bing gwangne molge gitangi ane singamolomb-gen ve inei ete Ei Amol ebe geb amolmol ru ok binge nitangi amolmol bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Givin sawa etok ge Yisu ginei ate lavo gitangi ane singamolomb-gen be ginei, “Atob Ayeu nareu nale Jerusalem ok, okob atob bambamo ebe emb lum mateu ane dabin ok, tis gidung subu ebe emb Mose ane yaun dabin ok, be tis eisir bambamo ebe emb da gitangi Pomate ok, atob inalgum awangg yaun ve ines ays beu vunu, be as-mate ebe ve aitol ane ok okob atob ayeu matawangg be namdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita gigas Yisu gile aikawe kob ginei, “Amol Bamo, ayeu tangg givin ganei Pomate nivarkei gen etok gili, ve ayeu bwaingg ve ret inalgum gen dang etok nitangi mie.” ");
INSERT INTO kbm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yisu giraulili be gigo Pita be ginei, “Sadam, ule aikawe ukwai ayeu. Mie gunei yaun etenok gitangi ebe amolmol ge as tas gitung ok, bemem Pomate ta gitung yaun dang etenok ite ma molge.” ");
INSERT INTO kbm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Be Yisu ginei gitangi ane singamolomb-gen be ginei, “Amol ti ginei ta givin ve nivang mul ve ayeu, okob nipasang ate ve ninggas gen bunam tis vavavne ete ve nipil ayeu ok nivin. ");
INSERT INTO kbm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Be ti ginei ta gitung utle ulis bamo molge, atob nindeb mul ane atob amol etok nimat vunu. Bemem amol ti ginei gimat vunu ve awangg kulkul ane, atob nindeb mul ane amol etok atob nimbweg matawe. ");
INSERT INTO kbm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gen etok vie ite ginei amol ti ninggas gen nalk ane tepwengge be nireu yev nile. Be gen vie ti giengk ebe ve amolmol inemb nitangi Pomate niwel dalgos matawas ane ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, gibloblo ve nanumul nanme tis Pomate ane bogbogo tis ane gwang-ne be ane ngalau kulkul ane vevies invin. Kob atob ayeu nalgum gen ebe amolmol ilgum nangge nalk ok nitangi eisir ate vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ayeu nanei nitangi yem, amolmol subu ete imbweg nik, atob eisir inmat vunu ite nangge, be atob indi Pomate Natu Ayeu ebe atob nanumul nanme tis angg gwangne ebe ve namb amolmol dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Asmate 6 gile gikwai kob, Yisu gigas Jems gabu male Jon be Pita be ireu matendubi undib ti ile ivang atane-ngge nangge eteok. ");
INSERT INTO kbm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Be sotol singamolomb aitol nok ili Yisu utle ulis ebe giro ate vukir ok, be na ringenk molge weik ebe as-matano ok. Yisu utle ulis ringenk molge be ane kup bogbogo molge weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bekob eisir singamolomb aitol nok ili Mose gabu Ilaija ebe ande nangge gulumb inme be kakie ivin Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Be Pita ginei gitangi Yisu be ginei, “Eitit tavang taku etenik be vie molge, be ginei mie tam givin kob ayeu napasang bes natu aitol, ti ve mie, be ti ve Mose, be ti ve Ilaija.” ");
INSERT INTO kbm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Givin ebe Pita ginei yaun gitangi Yisu givang ok be umbim bogbogo ti ginme be gitav tulu ve sotol, be yaun ti nangge umbim etok ginme, be yaun etok nangge Pomate avo be ginei, “Ayeu Natungg dongke etenok ebe tangg givin ei be gali ei vie molge ok, be unaute ei ane yaun ge.” ");
INSERT INTO kbm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eisir singamolomb iute yaun etok be ikuri vunungge love imbieg ile itle nas gile lu giwei nalk. ");
INSERT INTO kbm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bekob Yisu gitangi sotol gile gitak bage giwei is be ginei, “Unamdil be unpelk dang-etok bwaya.” ");
INSERT INTO kbm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eisir singamolomb emb nas itin bemem ili amol ti ite, be Yisu ei ate-ngge givarkei. ");
INSERT INTO kbm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Givin ebe Yisu tis ane singamolomb-gen aitol nok isov nangge matendubi ile ok, be Yisu ges bing ve sotol ve ginei inei gen ete gaptol ili ok nitangi amol ti ite love Pomate Natu Ei ebe meng-gihlang weik amolmol ok nimdil vukuri nangge taku gimat ane nikwai kob. ");
INSERT INTO kbm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Be sotol iutani Yisu be inei, “Nam-nambed be gidung subu ebe emb Mose ane yaun dabin ok inei atob Ilaija nimungg ninme bekob amol ebe ve nemb amolmol ru ok, ve ret?” ");
INSERT INTO kbm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yisu giwel sotol avos be ginei, “Ilaija atob nimungg ninme ve nipasang gen walang ok yapin. ");
INSERT INTO kbm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bemem ayeu nanei nitangi yemtol, Ilaija ginme gikwai bemem amolmol itpweng ei are ite be inei yaun ungglus gipil ei be ilgum gen gitangi ebe tas gitung ok. Be galkik etenik ok atob amolmol inalgum weik etok ge nitangi Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok.” ");
INSERT INTO kbm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Be givin etok ete sotol itpweng are ve Yisu ginei yaun etok gitangi sotol gipil Jon ebe ges bui sanggu gipil amolmol ok. ");
INSERT INTO kbm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yisu tis ane singamolomb-gen aitol nok imbeilk ve eisir singamolomb tavlu be tis amolmol dubi bamo ti ebe imbweg ok. Be amol ti gitangi Yisu gile be giro va-ndubi supwe gisov nalk gideb Yisu na ane, ");
INSERT INTO kbm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","be ginei, “Amol Bamo, tam viti ve ayeu natungg, ve ngalau tiate gilgum amol natu be gibweg vie ite molge. Ei gikari ate gireu yev be gisov bui tis as-mate walang ok. ");
INSERT INTO kbm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ayeu gagas ei gatangi miam singamolomb-gen gale ve inaitin ngalau tiate etok nikwai amol natu bemem eisir ilgum be gitangi ite.” ");
INSERT INTO kbm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisu giwel amol nok avo be ginei gitangi amolmol tepwengge be ginei, “Yem amolmol nangge taku etenik aplongg-aim givin ayeu ite molge, yem amolmol tiate ane roro. Ayeu gavang gavin yem ebe warik be gagas yem aim gen bunam ebe warik, be asger kob yem aplongg-aim nivin ayeu subu? Un-gas amol natu unme kob.” ");
INSERT INTO kbm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yisu ginei yaun gwangne gitangi ngalau tiate etok be gile gihlang gikwai amol natu nok, be givin sawa etok ge amol natu nok utle vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bekob eisir singamolomb itangi Yisu ile iutani ei bwaya-gege be inei, “Nam-nambed be amei algum ve anaitin ngalau tiate etok nikwai bemem gitangi ite?” ");
INSERT INTO kbm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yisu giwel eisir avos be ginei, “Yem gitangi ebe ve unaitin ngalau tiate nikwai amolmol ok bemem yem aplongg-aim givin Pomate ano molge ite. Dang etok be ayeu nanei nitangi yem, ginei yem aplongg-aim givin Pomate ano molge, okob yem gitangi ebe atob unei nitangi matendubi etok be nemb ate itin nangge etenik be nile niengk taku sawa ti ok. Be gen walang ok gitangi ebe atob yem unalgum ok, ");
INSERT INTO kbm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(bemem ginei yem un-yamar ben be unes miengk gwang-ne ge nitangi Pomate, atob yem gitangi ebe ve unaitin ngalau tiate dang dang etenik nikwai amolmol ok. Be gen ti ebe yem ve unalgum nivin ok giengk ite.”) ");
INSERT INTO kbm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yisu tis ane singamolomb-gen ivang nangge ete Galilaia as taku ok ge nangge be Yisu gine gitangi eisir be ginei, “Gibloblo ve inemb Pomate Natu Ayeu ebe meng-gahlang weik amolmol nitangi amolmol ebe ve ines ayeu vunu ok nale, ");
INSERT INTO kbm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bemem atob as-mate ebe ve aitol ane ok okob atob Pomate nes Ayeu itin vukuri nangge taku gimat ane.” Eisir singamolomb iute yaun etok be aplos bunam molge. ");
INSERT INTO kbm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yisu tis ane singamolomb-gen imbeilk Kapenaum be amolmol ebe inggas mone lum yamar ane ok itangi Pita ile be inei, “Atob yem aim gidung nemb mone lum yamar ane nivin me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Be Pita giwel eisir avos be ginei, “Atob ei nivgo nivin.” Givin ebe Pita gisov nam aplo gile ok be seukie-ngge Yisu ginei gitangi ei be ginei, “Mie tam gitung nam-nambed? Amolmol bambamo ebe emb amolmol dabin ok inggas mone takes ane nangge asav? Nangge eisir ate as amolmol-gen me nangge amolmol taku ti ane?” ");
INSERT INTO kbm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Be Pita giwel Yisu avo be ginei, “Nangge amolmol taku ti ane” Beti Yisu ginei, “Amok dang etok be atob eisir ate natus-gen inemb mone ite ve ayeu ok nangge taku etenik givin beti atob ayeu navgo ite. ");
INSERT INTO kbm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bemem eitit tanalgum eisir aplos be inei yaun walang ano bwaya, dang etok be mie uvwat golgol be ule bui ok. Be wenk ete mie ve nurwel ulu ok mie nomb wenk etok avo ponge be atob nuli mone ti niengk wenk nok avo. Be mone etok gitangi tutlu be mie nuvwat nule nomb nitangi amolmol ebe inggas mone lum yamar ane ok.” ");
INSERT INTO kbm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Givin sawa etok ge eisir singamolomb itangi Yisu ile be iutani ei be inei, “Pomate gili amol ret ginei amol bamo nangge eisir ete ei ve nemb is dabin ok?” ");
INSERT INTO kbm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yisu gital nunus natu ti gitangi ei gile, be gitak nunus nok givarkei ane singamolomb-gen nas, ");
INSERT INTO kbm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","be ginei, “Ayeu nanei bingano-ngge nitangi yem nanei, amol ti ginei gisov yaun ane lu-ngge be meng-gihlang weik nunus eteik ite, atob nisov Pomate ane taku ebe ve nemb amolmol dabin ok nile ite molge. ");
INSERT INTO kbm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amol ti ebe ges ane luev vie-ngge be gilgum gen vie-ngge gitangi amolmol bemem ei bua ve ret amolmol avos nivwat ei are ok, amolmol dang dang-etok ete atob nimbweg weik amol bamo nangge amolmol ebe Pomate ve nemb eisir dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Be ti ginei ta gitung ayeu be geb nunus ti weik eteik dabin, ete weik ebe gilgum gen vie gitangi ayeu ok.” ");
INSERT INTO kbm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Amol ti ginei ta gitung ve nirwel nunus ti me amol bamo ti ebe aplos givin Pomate ok be isov tiate aplo ile, okob etok vie ve amolmol inadgin vat bamo ti nile amol nok savwalo be inkari ei nisov kaumb gimil nile. Bemem tiate ve amol nok nilgum amolmol ebe aplos givin Pomate ok be insov gen tiate aplo inde. Ve atob ei ninggas vavavne bamo molge nitlek ete mate ane ok nangge Pomate ane nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Be Yisu ginei “Ayeu tangg-viti anongge ve amolmol ete imbweg nalk nik, ve gisov amolmol subu ilgum ve inarwel Pomate ane amolmol-gen inde insov gen tiate aplo. Bemem amolmol ebe ilgum gen dang dang-etok ok, ayeu tangg viti ve eisir anongge. ");
INSERT INTO kbm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ginei mie vam me bagem tavlu gilgum mie be gusov tiate aplo gule, okob nudbuen vam me bagem tavlu ete gilgum mie be gusov tiate aplo gule ok gili be nukari nikwai. Be etok vie ve mie numbweg matawem tis bagem me vam dongke-ngge, bemem tiate ve nureu yev bamo ebe giengk dang etok ok nule tis vam be bagem isgabu ge. ");
INSERT INTO kbm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Be ginei mie matanom tavlu gili gen tiate, okob nuptit vurupwe nikwai be nukari. Be etok vie ve mie nusov Pomate ane taku nule tis matanom tavlu-ngge, bemem tiate ve nureu yev bamo ebe giengk dang etok ok nule tis matanom isgabu ge.” ");
INSERT INTO kbm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Undi aim ate-ngge, velob undi nunus natu natu etenik weik gen sin-ge. Ayeu nanei nitangi yem nanei, nangge gulumb Pomate ane ngalau kulkul ane ebe emb nunus natu natu weik etenik dabin ok, eisir ili Tamangg ebe gibweg gulumb ok na geb ta-ngge be atob eisir inei yem aim gen tiate ebe ulgum ulgum ok binge nitangi ei. ");
INSERT INTO kbm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ve Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ganme ve namb amolmol ebe isov gen tiate aplo ile ok ru.) ");
INSERT INTO kbm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ayeu nanei nitangi yem, amol ti ginei geb ane bwelk sipsip dubi ti gitangi 100 dabin love ti gisov sangas, atob ei na vier ve ane bwelk subu be invarkei be nile ve nirek bwelk ete gisov sangas ok love nili kob. ");
INSERT INTO kbm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ayeu nanei bingano-ngge nitangi yem nanei, amol nok ginei nirek ane bwelk nok nivang love nile nili, atob ei ta vevie anongge ve ane bwelk dongke etok ane nitlek bwelk subu ebe isov sangas ite ok. ");
INSERT INTO kbm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dang-etok be Pomate ebe gibweg gulumb ok ginei bua ve ret ane nunus ti nisov gen tiate aplo nile.” ");
INSERT INTO kbm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Amol ti ginei gilgum gen tiate gitangi mie, mie nutangi ei nule be nupasang gen tiate ete ei gilgum gitangi mie ok ane yaun, bemem gabu unpasang yaun nitangi aim ate nangg-aim bwaya-gege. Be ginei amol etok giute miam yaun okob gabu undi aimate weik kawe be male vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Be ginei ei gute miam yaun ite, okob mie nule be nunggas amol dongke me ailu meinvin mie dang ete Pomate ane kapia ginei ok, veik sulu ailu me sotol aitol etok inaute miam yaun be inro ta nivin. ");
INSERT INTO kbm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Be ginei amol etok giute sotol as yaun ite, okob mie nunei nitangi Pomate ane amolmol-gen. Be ginei ei giute amolmol bambamo as yaun ite, okob mie nuli ei weik ebe amol gitip ane ti ebe gilgum gen tiate ok.” ");
INSERT INTO kbm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yem gitangi ebe unei amolmol as luev vie ebe ve invang ok, be tis luev tiate ebe gitangi ve tanvang mul ite ok. Yem gitangi ebe atob unei ve amolmol be intau luev tiate etok ok. Be Pomate atob nilgum weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ayeu nanei nitangi yem, ginei yem aim amol ailu nangge nalk etenik aplos gisov dongke be tas givin gen ti be gabu es miengk gitangi Pomate ve gen etok ane, atob Pomate nilgum gen etok ano nile nitangi sulu. ");
INSERT INTO kbm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Be ginei amol ailu me aitol ipil dongke be es miengk gitangi Pomate ve awangg gwangne, atob ayeu nambweg navin sotol.” ");
INSERT INTO kbm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita gitangi Yisu gile be giutani ei be ginei, “Amol ti ginei nilgum gen tiate nitangi ayeu, okob atob ayeu tangg nivalngan ei ane gen tiate etok bulwer aivir? ");
INSERT INTO kbm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yisu giwel Pita avo be ginei, “Ayeu nanei nitangi mie, mie tam nivalngan amol etok ane tiate nitangi asmate walang ok.” ");
INSERT INTO kbm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Pomate gilgum amolmol ebe ei ve nemb is dabin ok as yaun weik ebe amol bamo ti ve nili ane amolmol kulkul ane as gen ebe ivwat nangge ei be es as gen etok ane den vunu ite ok. ");
INSERT INTO kbm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ei gimdil ve nilgum kulkul etok, be ane amolmol kulkul ane inggas amol ti ebe ges ane gen ane den vunu ite, be gen etok ane mone bamo molge ok, itangi as amol bamo ebe geb eisir dabin ok ile. ");
INSERT INTO kbm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bemem amol nok ane mone gitangi ebe atob nes ane gen bambamo etok vunu ok ite, beti amol bamo ebe geb eisir dabin ok ginei in-gas amol nok gabu arue be natus-gen be tis as wambal tepwengge inde be amolmol inavgo, be invwat mone etok inde ines ei ane gen ebe givwat givwat ok ane den vunu. ");
INSERT INTO kbm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bemem amol nok giro vandubi supwe gisov nalk gitangi ane amol bamo be ginei, “Tam viti ve ayeu be nusge ge, ve atob ayeu nas angg gen walang ok ane den vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Beti ei ane amol bamo nok ta viti ve ei be gihlin ei be gile. ");
INSERT INTO kbm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amol nok gile love gile vunge ve ane nune ti ebe emb kulkul ivin isate ok, be amol nok ebe givwat gen nangge ei be ges ane gen etok ane den vunu ite be ei ane gen etok ane mone bamo molge ite. Beti amol galkok geb ei ta be ginei, “Os am gen ebe givwat ok ane den vunu okob.” ");
INSERT INTO kbm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Be amol etok ginei gitangi ei, “Mie tam vavis bwaya, be asonge kob atob ayeu nas angg gen walang ok ane den vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bemem amol etok giute ane nune ane yaun ite, be gile gitak ei gibweg kapual-lu. Be amol nok atob nimbweg kapual-lu dang-etok love nes ane gen etok ane den vunu okob.” ");
INSERT INTO kbm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Bwayage kob amol galkok ane nune-nggen subu ili gen etok be tas vavis anongge be ile inei gen etok tepwengge binge gitangi as amol bamo. ");
INSERT INTO kbm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Beti amol bamo gital amol nok ginumul ginme be ginei gitangi ei, “Mie amol tiate molge. Ayeu tangg givalngan miam gen tiate walang ok ve miam tangir ane, ");
INSERT INTO kbm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","dang-etok be mie ok nulgum dang etok ge nitangi am nune etok weik ete ayeu galgum gitangi mie ok ma.” ");
INSERT INTO kbm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amol nok ane amol bamo ebe geb ei dabin ok ta vavis anongge be geb ei gitangi amolmol ebe emb kapual-lu dabin ok gile ve intak ei nisov kapual-lu nile nimbweg. Be eisir ebe emb kapual-lu dabin ok atob inalgum amol nok tiate molge, love nes ane gen bambamo etok ane den vunu tepwengge kob.” ");
INSERT INTO kbm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Be Yisu ginei, “Ginei yem tangg-aim nivalngan gen tiate ebe ulgum gitangi aim ate ok ite, atob Pomate ebe gibweg gulumb ok ta nivalngan yem aim gen tiate ebe ilgum ok ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisu ginei yaun bambamo etok be ma gikwai kob tis ane singamolomb-gen ikwai Galilaia as taku be es bui Joldan gili ile ipil Judia as taku. ");
INSERT INTO kbm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Be amolmol dubi bamo ti itau ile Yisu tis ane singamolomb-gen be ile, be nangge etok ete Yisu gilgum amolmol ebe tis gimat ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bekob Parisai subu itangi Yisu ile be ilgum ve inyo inyo ei, beti iutani ei be inei, “Eitit and luev giengk dang etok ve atob amol ti ginei bua ve arue kob atob nitin me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yisu giwel eisir avos be ginei, “Yem usam yaun ebe giengk Pomate ane kapia ok gikwai me ma? Warik mate ane Pomate gipasang amol ti be avie ti, ");
INSERT INTO kbm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","be ginei, “Amol atob nikwai tame gabu tine be nile nivang nivin arue, be atob gabu invang weik gen ano dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Be gen ete ande Pomate gidgin gikwai ok, gitangi ebe atob sulu as ti nidbwen gen etok gili ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Be eisir Parisai iutani Yisu vukuri be inei, “Be nam-nambed be Mose geb yaun ti gitangi amei be ginei, ‘Amol ti ginei bua ve arue be ve nitin okob niro yaun ebe ve bua ve arue ok, nireu kapia den ti be nemb nitangi arue nile?’” ");
INSERT INTO kbm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yisu giwel eisir avos be ginei, “Mose geb yaun etok gitangi yem ve gili yem aplongg-aim dadani molge be gitangi ebe ve unatpweng gen arkares ok ite. Bemem warik gimungg ane luev ti dang etok giengk ite molge. ");
INSERT INTO kbm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Be ayeu nanei nitangi yem, amol ti ginei bua ve arue be ve nitin ei bemem avie nok gilgum gen wasi ane ite, be amol etok gile geb avie vaku ti, okob amol etok giyaing luev ebe ve inemb isate ane ok.” ");
INSERT INTO kbm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bekob eisir singamolomb itangi Yisu ile be inei, “Ginei amolmol ilgum gen dang dang-etok gitangi aruasgen, okob gen etok vie ve amol be avie nemb isate bwaya.” ");
INSERT INTO kbm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yisu giwel ane singamolomb-gen avos be ginei, “Yaun etenok gitangi ebe atob amolmol tepwengge inatpweng are ok ite ma, bemem amolmol ebe Pomate ginei yaun etenik ane dabe gitangi eisir ok ge, gitangi atob inatpweng are. ");
INSERT INTO kbm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ve yaun ete amol be avie inemb isate ite nik ane dabe walang giengk. Amolmol subu tinas-gen ikuv is be gitangi ebe atob inemb avie ok ite, be subu ete amolmol iro eisir vukir be be tas gitung ete ve nemb avie ok ite ma. Be eisir subu bwais ve inemb avie giwei eisir tas gitung Pomate ane kulkul ebe ve nemb amolmol dabin ok. Amol ti ginei gitpweng yaun etenik are atob nilgum.” ");
INSERT INTO kbm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Amolmol subu inggas nunus natu natu itangi Yisu ile ve nitak bage niwei is be nes miengk niwei eisir, bemem eisir singamolomb inggo eisir nok. ");
INSERT INTO kbm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bemem Yisu ginei gitangi ane singamolomb-gen be ginei, “Untau nunus etenok be intangi ayeu inme, be unvarkei eisir avut bwaya. Ve Pomate ane taku giengk ve amolmol dang dangetenok ane. ");
INSERT INTO kbm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bekob gitak bage giwei nunus nok dabas be geb avo ukwas giwei eisir gikwai kob tis ane singamolomb-gen ile. ");
INSERT INTO kbm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Be seukie-ngge amol singamolomb ti gitangi Yisu gile be giutani ei be ginei, “Gidung, gen vie ret giengk ebe ve ayeu nalgum veik nambweg matawangg dang etok ok?” ");
INSERT INTO kbm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisu giwel ei avo be ginei, “Nam-nambed be mie gutani ayeu ve gen vie ane? Gen vie dongke-ngge ete giengk nik; Pomate dongke-ngge ei Amol vie, be ginei mie tam givin ve numbweg matawem nemb ta-ngge, okob nusov Ei ane yaun ane lu ge.” ");
INSERT INTO kbm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Be amol nok giutani Yisu, “Yaun ret?” Be Yisu ginei, “Nos amolmol vunu ite, nulgum gen wasi ane ite, nunei yaun bingkas kasop nipil amolmol ite, nuvaina gen ite, ");
INSERT INTO kbm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nusov tamem gabu tinem as yaun ane lu ge, be tam nivin am nune-nggen weik ete mie ate tam givin imate ok.” ");
INSERT INTO kbm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Be amol nok ginei, “Ayeu galgum yaun walang etok ano gile gikwai, be gen ret giengk ebe ve ayeu nalgum vukuri ok?” ");
INSERT INTO kbm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yisu ginei gitangi ei, “Ginei mie gupasang gen walang etok love gitangi ge okob vie, be nule be nomb am wambal tepwengge be amolmol inavgo. Bekob nuvwat am gen etok ane mone nule be numbwas nitangi amolmol ebe gen ma ve is ok, be nindeb mul ane atob mie nunggas am gen vevies ge nangge Pomate ane taku. Bekob nunme be nuvang mul ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Givin ebe amol nok giute yaun etok ok be givang gikwai tis aplo bunam ge ve gile, ve gisov ei amol ti ebe tis wambal bamo ok be ei bua ve ret nikari ane gen ti. ");
INSERT INTO kbm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Be Yisu ginei gitangi ane singamolomb-gen be ginei, “Ayeu nanei bingano-ngge nitangi yem, gen etok bunam molge gitangi amolmol ebe tis wambal ok ebe ve insov Pomate ane taku ebe ve nemb amolmol dabin inde ok. ");
INSERT INTO kbm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ayeu nanei vukuri. Gen etok bunam ve gen bamo ti weik bwelk ok nisov gen avo natu ti weik nil avo ok nile, bemem bunam molge gitangi amolmol ebe tis wambal ok, ebe ve insov Pomate ane taku ebe ve nemb amolmol dabin inde ok.” ");
INSERT INTO kbm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eisir singamolomb iute yaun etok be tas gitung walang ano be ile iutani Yisu be inei, “Ginei dang-etok, okob amol ret gitangi ebe atob nimbweg vie ok?” ");
INSERT INTO kbm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yisu na giro ane singamolomb-gen be ginei, “Amol ti gitangi nilgum gen dang-etok ite, bemem Pomate ei dongke-ngge gitangi atob nilgum gen walang ok.” ");
INSERT INTO kbm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Be Pita ginei gitangi Yisu, “Amei avang akwai amei gen walang ok be anme avang mul ve mie. Be asonge amei an-gas gen vie ret?” ");
INSERT INTO kbm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Be Yisu ginei gitangi eisir, “Asonge nindeb mul ane nivin ebe gen walang ok ve menihlang vaku vukuri ok, atob Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob nambweg nawei angg lopong tis angg bogbogo ve naute amolmol as yaun. Be nivin etok atob yem ete uvang mul ve ayeu nik, atob unambweg unvin ayeu be unalgum amolmol nangge Israel as yaun. ");
INSERT INTO kbm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Amolmol ebe ivang ikwai tamas-gen tis tinas-gen be as nam tis natus-gen be luvus avie-nggen be as male-nggen tis as taku, ve awangg kulkul ane ok, atob in-gas gen walang molge nitlek as gen etok nindeb mul ane, be atob inambweg matawas nemb ta-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bemem amolmol ete galkik imungg nik atob inde indeb mul ane, be eisir ete mul ane ok atob inde inmungg.” ");
INSERT INTO kbm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Pomate geb amolmol dabin weik ebe um wain ti ane tivie ok. Givin tistumi-ngge amol nok gimdil be gile ve ninggas amolmol subu ve inde be inemb kulkul wain ane nangge ane um. ");
INSERT INTO kbm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Be um tivie nok tis ane amolmol kulkul ane inei yaun gisov dongke love ande vie, ve um tivie atob nivgo eisir nitangi ebe mone as-mate dongke-ngge ane ok. Bekob gihlin eisir be ivang kulkul ane. ");
INSERT INTO kbm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","As gireu ginme kasopge be um tivie gile be gili amolmol subu ebe tas gisgil ei ane yaun ge be iriv be ira sinsin-ge ivang nam luvwe ok. ");
INSERT INTO kbm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Be ginei gitangi eisir; “Unde be unalgum awangg kulkul wain ane unvin be atob ayeu navgo yem nivin.” Beti eisir nok ile be ilgum kulkul givin. ");
INSERT INTO kbm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Be givin as mate luvwe be tis ebe as gile ve nile nisov ok, be um tivie gilumul gile be gilgum weik etok ge gitangi amolmol subu givin.” ");
INSERT INTO kbm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Be givin ebe as giro ringenk ok um tivie gilumul gile be gili amolmol subu ebe ilauk ivang nam luvwe sinsin-ge ok, be giutani eisir be ginei, “Nam-nambed be yem omb wayam ve aim ate be uvang kulkul ane uvin ite?” ");
INSERT INTO kbm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Be eisir iwel ei avo be inei, “Amol ti giutani amei ebe ve ande be analgum kulkul ok ite.” Be ei ginei gitangi eisir, “Amok dang-etok be yem unde be unalgum awangg kulkul unvin.” ");
INSERT INTO kbm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Givin gibok um tivie gitangi amol ebe geb eisir kulkul ane dabin ok gile be ginei, “Mie nuvgo eisir ebe ile isov kulkul givin gibok ok nimungg bekob nuvgo eisir ebe imungg ile emb kulkul givin tistumi-ngge ok nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Amolmol ebe ile isov kulkul tis gibok ok imungg ile be inggas as mone gitangi ebe as-mate dongke-ngge ane ok, ");
INSERT INTO kbm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","bekob amolmol ebe emb kulkul givin tistumi-ngge ok ile be inei bwat atob eisir in-gas mone nireu siti, bemem eisir tepwengge inggas mone gitangi ate-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eisir inggas as mone gikwai kob ile be tas vavis be inei yaun ungglus ungglus gipil um tivie be inei, ");
INSERT INTO kbm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Eisir etok emb kulkul siti-ngge givin gibok ge be amei amb kulkul givin tistumi-ngge be as givse amei love ande gibok sin-ge be akwes anongge. Bemem mie guvgo amei tepwengge gitangi ate-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Be um tivie giwel eisir as amol ti avo be ginei, “Ayeu galgum gen ti tiate gitangi yem ite ma, bemem yem ate unei gikwai unei atob yem tepwengge ungas mone nitangi as-mate dongke-ngge ane, ");
INSERT INTO kbm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","be unvwat aim mone be unvang aim nam ane unkwai. Ayeu tangg givin ve ganei navgo yem tepwengge ve mone nitangi ate-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Be um tivie ginei gitangi eisir, “Mone etenik awangg gen be ayeu gitangi nalgum gen nitangi ebe tangg givin ok nipil mone etenik. Be yem uli aim ate tiate gisov etok ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Beti Yisu ginei, “Amol ti ginei gilgum Pomate ane kulkul be ta gitung ve ginei atob ei nimbweg weik ebe amol bamo ti ok, ete atob ei nile nindeb mul ane. Bemem amol ti ginei geb Pomate ane kulkul be ta gitung yaun ti dang-etok giengk aplo ite, atob amol etok menile nimungg be atob ei nimbweg weik amol bamo ti nangge Pomate ane taku.” ");
INSERT INTO kbm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisu ve nireu nile Jerusalem beti gigas ane singamolomb-gen 12 ebok ivin be tepwe ile ve invang dang-eteok ane inde, be ginei gitangi ane singamolomb-gen be ginei; ");
INSERT INTO kbm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Unaute kob. Atob eitit tanreu tande ete Jerusalem ok, okob atob bambamo ebe emb da gitangi Pomate nangge lum yamar aplo ok be tis gidung subu ebe emb Mose ane yaun dabin ok, atob inalgum yaun nipil Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ve ines ayeu vunu. ");
INSERT INTO kbm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Be atob inemb ayeu nitangi amolmol ebe nangge Juda ite ok be inei yaun ungglus ungglus nipil ayeu, be inrau ayeu, bekob ines ayeu nareu ei givsangin nale. Be as-mate ebe ve aitol ane ok okob atob matawangg be namdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi natu-nggen Jems gabu Jon be tis tinas bamo itangi Yisu ile be tinas giro vandubi supwe gisov nalk gitangi Yisu, be giutani ei ve nilgum gen vie ti nitangi natu-nggen. ");
INSERT INTO kbm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Beti Yisu ginei gitangi ei be ginei, “Mie tam givin gen ret?” Be ei giwel Yisu avo be ginei, “Asonge nindeb mul ane nivin ebe mie ve nomb amolmol dabin ok, okob nunei be ayeu natu-nggen eilu eteik indek inambweg inambloblo mie invin. ");
INSERT INTO kbm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yisu giwel ei avo be ginei, “Yemtol ebenok, gaptol utpweng yaun ete unei nok are ite, yemlu gitangi ebe atob un-gas gen bunam ete atob ayeu nanggas ok unvin me ma?” Be sulu iwel Yisu avo be inei, “Eilu gitangi.” ");
INSERT INTO kbm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Be Yisu ginei, “Vie molge. Bemem ayeu gitangi ebe atob nalgum gen dang etok nitangi yemlu ok ite. Ve gen etok Pomate ei ate-ngge atob nilgum.” ");
INSERT INTO kbm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Givin ebe eisir singamolomb tavlu iute yaun etok ok be tas vavis anongge gitangi Jems gabu male Jon. ");
INSERT INTO kbm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Beti Yisu gital ane singamolomb-gen tepwengge ile ipil dongke be ginei ve is be ginei; “Yem uli, Amolmol bambamo ebe emb amolmol dabin ok ve eisir ate as gwangne, be lolos be avos gwangne molge gitangi amolmol ve inei amolmol inaute eisir avos ge. ");
INSERT INTO kbm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bemem yem unalgum gen dang-etok bwaya. Ginei yem aim amol ti ta gitung ve menihlang weik yem aim amol bamo, okob ei nilgum ate love weik ebe yem aim amol kulkul ane ti ok. ");
INSERT INTO kbm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Be ginei amol ti ta gitung ve menihlang weik amol bamo ti, okob ei nilgum ate weik amolmol tepwengge as amol kulkul ane singe singe ti. ");
INSERT INTO kbm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Dang-ete Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok. Ayeu ganme ve amolmol inalgum kulkul ve ayeu ane ite ma. Ayeu ganme ve namb amolmol walang ok ru, be galgum kulkul be gab au-ate ve amolmol walang ok ane.” ");
INSERT INTO kbm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisu tis ane singamolomb-gen imdil nangge Jeriko be ile be amolmol dubi bamo ti itau ile eisir. ");
INSERT INTO kbm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Be amol matanos bop ailu imbweg luev bane be iute ebe amolmol avos bambamo be inei ane avo ve Yisu ebe givang ginme ok. Beti gabu ital avos bamo ge be inei, “Amol bamo, Dawit ane vaku mie. Tam viti ve eilu ma.” ");
INSERT INTO kbm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Beti amolmol inggo sulu be inei, Gabu tumi-ngge. Bemem sulu ital avos bamo-ngge vukuri be inei, “Amol Bamo, Dawit ane bwatlus mie. Tam viti ve eilu ma.” ");
INSERT INTO kbm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisu givarkei va ta be gital sulu be itangi ei ile be giutani sulu be ginei, “Yemlu tanggaim givin ve ayeu nalgum ret nitangi yemlu?” ");
INSERT INTO kbm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Be sulu iwel Yisu avo be inei, “Gidung, eilu tangg-amei givin ve mie mulgum eilu matanongg-amei be ponge.” ");
INSERT INTO kbm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yisu ta viti ve sulu be gitak bage giwei sulu matanos, be seukie-ngge sulu matanos ponge be gabu ili taku. Be gabu ivang mul ve Yisu be ile. ");
INSERT INTO kbm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yisu tis ane singamolomb-gen ile imbloblo Jerusalem be ile ihlang nam dabe ti are Betfasi ebe giengk matendubi ebe ei oliv anongge givarkei ok. Be Yisu gihlin ane singamolomb-gen ailu ve inmungg inde inahlang ebe nam ok ");
INSERT INTO kbm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","be ginei gitangi sulu. “Gabu unde be unvang roro-ngge untangi nam ete givarkei mate ane ok, be nangge etok atob gabu undi bwelk dongki ti gabu natu be amolmol idgin ta be iro wal gile twelk nam ane be ivarkei. Be gabu unahlang isgabu ge be unatwem unme etenik. ");
INSERT INTO kbm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Be ginei amol ti ve niutani yemlu be ninei, yemlu ve unamdom, okob gabu unei nitangi amol etok unei, “Amei-mei Amol Bamo ta givin.” Kob atob amol nok nihlin yemlu be unatwem bwelk etok undumul unme etenik seukie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gen etenik meng-gihlang dang-etok veik nilgum be yaun ebe warik amol ebe ginei Pomate avo ok ginei ok ano nile. Ve Pomate ginei dang-eteik: ");
INSERT INTO kbm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Unei ve amolmol Jerusalem ane unei, Galkik etenik yem aim Amol Bamo ebe ve nemb amolmol dabin ok ve nitangi aim nilek. Ei Amol bwaibwaya ane be gibweg giwei bwelk dongki vaku ti.’ ");
INSERT INTO kbm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yisu ane singamolomb-gen ailu etok imungg ile be ilgum gen walang ok gitangi ebe galkik Yisu ginei gitangi sulu ok. ");
INSERT INTO kbm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Be gabu itwem bwelk dongki etok gabu natu itangi Yisu ile be iwaulu as kup malar ane be ival giwei bwelk dongki nok dume tulkwe, bekob Yisu gipil gile gibweg giwei. ");
INSERT INTO kbm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amolmol anongge ival as kup giwei luev be eisir subu ile ispe niuk lan be ile ival giwei luev givin. ");
INSERT INTO kbm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Be amolmol ebe ivang mate ane ok be tis eisir ebe ivang mul ane ok ital dang eteik inei, ‘Eitit avond nivwat Amol ebe nangge Dawit ane dani ok ebe ve nemb eitit dabin ok, be avond nivwat Pomate are. Pomate geb ane gwangne gitangi ei, eitit avond nivwat ei.’ ");
INSERT INTO kbm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Givin ebe Yisu gile gihlang Jerusalem ok be amolmol tepwengge ebe imbweg nam ok ikuri vunungge be iutani, “Amol ret etenik?” ");
INSERT INTO kbm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Be amolmol ebe itau gile Yisu ok iwel eisir avos be inei, “Etenik Pomate ane Amol ebe ginei Pomate ei avo ok, are Yisu. Ei amol Nasaret ane gideb Galilaia as taku ane.” ");
INSERT INTO kbm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisu gisov lum yamar aplo gile be gitin amolmol ebe ile ve ivgo gen be emb gen giwel ate nangge lum yamar aplo ok ile ihlang ikwai, be gitle amolmol ebe emb mone giwel ate ok as tebol mone ane vukir be gitut as lopong ebe imbweg be ivgo mank ok giriv be gira. ");
INSERT INTO kbm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Be ginei gitangi eisir, “Yaun ebe giengk Pomate ane kapia ok ginei dang eteik, Pomate ginei, ‘Awangg nam atob tantal tanei amolmol tepwengge as nam miengk ane.’ Bemem ande yem ulgum love weik ebe amolmol vaina ane as taku ok.” ");
INSERT INTO kbm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yisu givang ete lum yamar aplo ok, bekob amolmol ebe matanos bop ok be tis eisir ebe tulkwas giru bingbleng ok itangi Ei ile be gilgum eisir tepwengge be utlas vie vukuri nangge ete lum yamar aplo ok. ");
INSERT INTO kbm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Be bambamo mateu ane subu be tis gidung subu ebe emb Mose ane yaun dabin ok ili gen bambamo ete Yisu gilgum nangge lum yamar aplo ok, be iute ebe nunus avos bambamo-ngge nangge lum yamar aplo be inei, “Avond nivwat Dawit ane dani” ok, be eisir tas vavis anongge. ");
INSERT INTO kbm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Beti itangi Yisu ile be inei, “Ande mie gute yaun ete eisir inei ok me ma?” Yisu giwel eisir avos be ginei, “Ande ayeu gaute. Be namnambed? Yem ok nolge usam Pomate ane yaun ebe warik ok gikwai me ma? Yaun etok ginei dang-eteik: ‘Mie gob nunus natu natu subu be tis nunus ebe godos gisa rur ge nangge ok avos ponge be eisir avos givwat mie arem vie molge.’” ");
INSERT INTO kbm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Be Yisu gikwai eisir be gile giengk nam dabe ti are Betani. ");
INSERT INTO kbm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Givin tistumi-ngge Yisu tis ane singamolomb-gen imdil nangge Betani be ilumul ile Jerusalem vukuri. Be Yisu ande marav-ges vunu-ngge, ");
INSERT INTO kbm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","be na gile gili ei-nambwel dabe ti givarkei luev bane be givang gitangi ei-nambwel dabe nok gile ve nili ano ebe yu ok be nipis ve nen. Bemem gili ei-nambwel nok ano ti gikaiwel ite be lan sin-ge. Yisu ta-vavis be ginei yaun gwang-ne molge gitangi ei-nambwel dabe etok be ginei; “Asonge mie nos ano vukuri ite ma.” Be seukie-ngge ei-nambwel dabe etok lan ges ulur gikwai be gimat. ");
INSERT INTO kbm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eisir singamolomb ili gen etok be avos poke-ngge be iutani is-ate be inei; “Nam-nambed be ei-nambwel dabe etok vasov nik-ge lan matas be givarkei be ande aing-gwen seukie-ngge?” ");
INSERT INTO kbm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yisu giwel ane singamolomb-gen avos be ginei: “Ayeu nanei bingano-ngge nitangi yem nanei, Ginei yem aplongg-aim givin Pomate ano molge be aplongg-aim ailu ailu ite, yem gitangi atob unalgum gen weik ete ayeu galgum gitangi ei-nambwel dabe etok ok. Be gen etok ge ite. Yem gitangi atob unei nitangi matendubi etok be unei, “Umdil ule ukari im-ate isov gielk,” be atob nilgum. ");
INSERT INTO kbm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Be ginei yem aplongg-aim givin anongge unei atob un-gas gen ete utani gisov aim miengk aplo ok, atob un-gas.” ");
INSERT INTO kbm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisu tis ane singamolomb-gen inumul ile Jerusalem vukuri be Yisu gisov lum yamar aplo gile be gibul amolmol givang. Be bambamo ebe emb lum mateu ane dabin ok be tis amolmol bambamo ebe emb amolmol dabin angge Juda as taku ok, itangi ei ile be inei; “Mie gulgum gen walang etenik ve amol ret ane gwang-ne? Be amol ret geb ane gwang-ne gitangi mie?” ");
INSERT INTO kbm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yisu giwel eisir avos be ginei; “Atob ayeu nautani yem ve yaun ti ane bekob. Be ginei yem unei yaun eteik ano vusa nitangi ayeu, okob atob ayeu nanei amol ebe geb ane gwang-ne gitangi ayeu be galgum gen walang etenik ok lavo nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wali Jon gigas gwang-ne nangge inend, beti ges bui-sanggu gipil amolmol? Nangge Pomate ane, me nangge amolmol as?” Beti eisir nok inei ve is-ate be inei, “Atob eitit tanei ret? Ginei eitit tanei dang-etok tanei ‘Nangge Pomate ane.’ Be atob ei ninei, ‘Be nam-nambed be yem aplongg-aim givin Jon ane yaun ite?’ ");
INSERT INTO kbm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Be ginei eitit tanei, ‘Nangge amolmol as.’ Atob amolmol in-go eitit. Ve gisov amolmol tepwengge ili Jon inei Pomate ane amol ti ebe ginei Pomate ei avo ukwas binge ok. ");
INSERT INTO kbm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Beti eisir iwel Yisu avo be inei, “Amei tangg-amei gisgil.” Be Yisu ginei, “Dang-etok be atob ayeu ok nanei amol ebe geb ane gwang-ne gitangi ayeu ok, binge nitangi yem ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Be Yisu ginei gitangi eisir be ginei; “Unaute kob. Amol ti natu ailu imbweg. Be amol bamo nok ginei ve amol mate ane be ginei, ‘Mie ule be ulgum kulkul nangge awangg um-wain tis as-mate etek.’ ");
INSERT INTO kbm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Be amol nok giwel tame avo be ginei, ‘Ayeu bwaingg.’ Bemem bwayage kob ei ta-gitung tame ane yaun be givang kulkul ane. ");
INSERT INTO kbm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Beti amol bamo nok gile be ginei yaun nok ge gitangi amol mul ane, be amol mul ane giwel tame avo be ginei, ‘Ec-e, kob ayeu ale.’ Bemem giyo be gile ite. ");
INSERT INTO kbm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Be Yisu ginei; ‘Sulu ailu etok as amol ret gilgum tamas ane yaun ano gile?’ Be eisir iwel Yisu avo be inei, “Amol mate ane.” Be Yisu ginei gitangi eisir, “Ayeu nanei bingano-ngge nitangi yem: “Eisir ebe emb kulkul takes ane be iyo iyo amolmol be inggas as mone subu givin sinsin-ge ok, be tis avie-gaptol ebe emb is-ate gitangi amol-gaptol ve mone ane ok, asonge insov Pomate ane taku ebe ve nemb amolmol dabin ok inde inmungg bekob yem. ");
INSERT INTO kbm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ve Jon ebe ges bui-sanggu gipil amolmol ok ginme be gibul yem ve luev vie ebe ve yem unvang mul ok, bemem yem aplongg-aim givin ei ane yaun ite. Bemem amolmol ebe iyo iyo amolmol be inggas as gen subu sinsin-ge givin ok be tis avie gaptol ebe emb is-ate itangi amol gaptol ve mone ane ok, eisir etok ete aplos givin Jon ane yaun. Yem uli gen ebe Jon gilgum ok gikwai, bemem uro aim ate vukir be aplongg-aim givin ei ite.” ");
INSERT INTO kbm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yisu ginei bing-ai ti vukuri gitangi amolmol be ginei, “Amol ti givro um wain ti be givkwe-el gile gidbul, be gitav nalk avo ebe ve ingig wain ane ano nisov ok yapin, bekob gitav nam va tulkwe undib ti ebe ve nimbweg be nemb wain dabin velob amolmol vaina ane inde be invaina wain ano. Bekob geb um wain etok gisov amolmol ebe ve inemb kulkul etok dabin ok bais be ei-ate gile ve givang taku undib ge ti. ");
INSERT INTO kbm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gile love aiweng ebe ve inpis wain ano ok meng-gihlang kob gihlin ane amolmol kulkul ane subu be ile ve invwat wain ane ano tavlu nangge amolmol ebe emb wain dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Be eisir ebe emb wain dabin ok irau amol bamo nok ane amolmol kulkul ane nok subu, be es subu vunu, be es subu ve vat. ");
INSERT INTO kbm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Beti um tivie gihlin ane amolmol kulkul ane dubi bamo ti vukuri gitlek ete mate ane ok be ile. Bemem amolmol ebe emb wain dabin ok ilgum dang-etok ge gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Be mul ane kob ete um tivie gihlin ei-ate natu be gile. Be ei tangg gitung dangeteik ginei; “Eteik ayeu natungg be atob eisir ebe emb um wain dabin ok nas indi ei vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bemem givin ebe eisir ili um tivie natu ebe gitangi eisir gile ok be inei ve is-ate, “Um tivie natu ete ginme nik be tanes ei vunu nikwai veik tan-gas ei ane gen vie etenik ve it.” ");
INSERT INTO kbm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Beti eisir emb ei ta be ikari gile gihlang gikwai um aplo be es ei vunu.” ");
INSERT INTO kbm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Be Yisu giutani amolmol be ginei; “Ginei um tivie ninme, kob atob nimdom nitangi amolmol ete emb ei ane um wain ane dabin ok?” ");
INSERT INTO kbm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Be eisir iwel Yisu avo be inei, “Atob ei nes amolmol tiate ane etok tiate molge be nemb kulkul etok nisov amolmol subu ebe vevies ok bais. Ve eisir etok okob gitangi ebe atob inemb um tivie ane gen dabin vie-ngge love ane aiweng ebe um tivie ve ninggas ane wain ane ano ok.” ");
INSERT INTO kbm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Be Yisu ginei gitangi eisir, “Yem usam yaun ebe giengk Pomate ane kapia ok gikwai me ma? Yaun etok ginei dang-eteik: ‘Twelk ebe warik amolmol gimungg ane itav as nam giwei ok ande amolmol bwais be itin. Bemem galkik etenik ande twelk nok meng-gihlang be weik gen vie molge ti. Beti ande eitit tali gen vie molge ebe Pomate gilgum ok.’ ");
INSERT INTO kbm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Be Yisu ginei, dang-etok be ayeu nanei nitangi yem, Pomate atob nivkir dume nitangi yem ebe aplongg-aim givin ei ite ok, be nemb amolmol ebe iute ei ane yaun be tas givin ve inalgum ano nile ok ge dabin. ");
INSERT INTO kbm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Amol ti ginei bua ve awangg yaun atob ei nimbweg vie ite. Bemem ginei ayeu ve nas amol ti, atob amol etok nile suk-sukus weik gen molok-molok natu ti.) ");
INSERT INTO kbm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bambamo ebe emb lum mateu ane dabin be tis eisir Parisai iute Yisu ane bing-ai ete ginei ok be itpweng are inei Yisu ginei yaun etok gipil eisir roro-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Beti eisir ve inemb Yisu ta bemem ipelk ve amolmol, ve gisov amolmol ili Yisu inei Pomate ane amol kulkul ane ti ebe ginei Pomate avo ok. ");
INSERT INTO kbm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisu ginei mateu be ginei gipil bing-ai ge gitangi amolmol vukuri be ginei: ");
INSERT INTO kbm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pomate geb amolmol dabin weik ebe amol bamo ti ve nilgum ben ve natu ebe ve nemb avie ok ane. ");
INSERT INTO kbm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Be ei gihlin ane amolmol kulkul ane subu ve inde be inei yaun nitangi amolmol ebe warik ei geb yaun ve eisir yapin ok be inme. Bemem amolmol ebe inggas yaun ben etok ane gikwai ok, bwais ve inde. ");
INSERT INTO kbm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Beti amol bamo nok gihlin ane amolmol kulkul ane subu vukuri be ginei, “Unde be unei nitangi eisir ebe ayeu gab yaun gitangi eisir ok be unei, ben tis wenk be gen walang ok ande ayeu gapasang gikwai, be inme be inen amol gabu avie as ben.” ");
INSERT INTO kbm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bemem eisir etok iute ei ane yaun ite be ile ve ivang iriv be ira. Amol ti givang ane um ane be ti gile ve geb ane kulkul mone ane. ");
INSERT INTO kbm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Be eisir nok as amolmol subu emb amol bamo nok ane amolmol kulkul ane ta be ilgum is tiate tiate, be es is vunkunu. ");
INSERT INTO kbm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Amol bamo nok ande ta-vavis vunu-ngge be gihlin ane amolmol valir ane ile be es amolmol ete es ei ane amolmol kulkul ane vunkunu ok, be itak yev gisov as nam be yev gen givin. ");
INSERT INTO kbm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bekob ei gital ane amolmol kulkul ane ile be ginei, “Ayeu ande gapasang angg ben gikwai bemem amolmol ebe ayeu gab yaun ve eisir ok tas givin awangg ben ite be bwais ve ret inme. ");
INSERT INTO kbm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dang-etok be yem unde unvarkei luev bamo walang ok avwut, be unei nitangi amolmol ebe ile vunge ve aim ok be inme be inen ben bamo etenik nivin.” ");
INSERT INTO kbm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Beti ei ane amolmol kulkul ane etok ile be ilgum gitangi ebe galkik ei ginei ok be iro amolmol anongge molge sut, amolmol vie ane be tiate ane gipil dongke. Love amol bamo nok ane nam aplo gingik ve amolmol ge. ");
INSERT INTO kbm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Bekob ei gisov nam aplo gile ve na nitung amolmol be gili amol ti ebe gino kup ben dang dang-etok ane ok ti ite gibweg givin. ");
INSERT INTO kbm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Be amol bamo nok ginei gitangi amol etok, “Nam-nambed be mie guli ben etenik weik gen sin-ge be gusov nam-aplo etenik gunme be guno kup ben dang dang-etenik ane ti ite?” Bemem amol etok ginei yaun ti ite be tumi-ngge gibweg. ");
INSERT INTO kbm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Beti amol bamo nok ginei be ane amolmol kulkul ane idgin amol nok bage tis va ta be ikari ei gile gihlang aiweng tumi aplo. Be taku etok ebe amolmol inggas vavane be yayai be iteng anongge nangge ok.” ");
INSERT INTO kbm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Be Yisu ginei gitangi amolmol be ginei, “Asonge Pomate nital amolmol anongge weik etok ge, bemem atob amolmol dongke dongke ebe aplos givin Pomate ok ge, ete atob insov Pomate ane taku ebe ve nemb amolmol dabin ok inde.” ");
INSERT INTO kbm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eisir Parisai irek luev ebe ve inemb Yisu ta ok. Beti ihlin as amolmol kulkul ane subu be tis Herodes ane amolmol subu be itangi Yisu ile be iutani ei be inei, ");
INSERT INTO kbm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","“Gidung amei atpweng mie are anei mie amol yaun ano ane, be mie gubul amolmol ve luev yaun ano ane ebe Pomate tang-givin ok ge. Be mie tam vadbu ve yaun ebe amolmol inei me tam givin yaun ete amolmol inei inei ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Be unei itangi amei kob, gitangi ebe amei anavgo takes nitangi Rom as amol bamo ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yisu ande gitpweng eisir as yaun bingkasop etok are gikwai be ginei, “Yem amolmol tiate ane yem wat veve inyo inyo ayeu me? ");
INSERT INTO kbm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Unemb mone nok ti inme be ayeu ali kob.” Be eisir emb mone ti gile Yisu gili, bekob giutani eisir be ginei, ");
INSERT INTO kbm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Amol ret dalgo be tis are eteik?” ");
INSERT INTO kbm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Be eisir iwel Yisu avo be inei, “Etenok Rom as amol bamo are be tis dalgo etenok.” Be Yisu ginei gitangi eisir, “Dang-etok okob unemb Rom as mone ninumul nitangi eisir as amol bamo nile, be unemb Pomate ane gen nitangi Pomate.” ");
INSERT INTO kbm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Givin ebe eisir iute yaun ete Yisu ginei ok, be ikuri vunu-ngge be ihlang ikwai Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Givin as-mate etok ge Sadukai subu itangi Yisu ile. Be eisir etok ebe inei amolmol ebe imat vunu ok atob inamdil vukuri ite ok. ");
INSERT INTO kbm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Eisir nok ile be inei gitangi Yisu, “Gidung. Mose giro yaun ti gitangi amei be ginei, ‘Amol ti ginei geb avie ti be sulu natus ma be amol etok gimat vunu gikwai areu, kob atob amol etok male nemb avie tupe etok veik ei nes nunus vier niwel kawe ebe gimat vunu ok.’ ");
INSERT INTO kbm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dang-etok be amol ti tis male-nggen imbweg eisir nok gitangi bage tavlu be ano ailu (7). Be amol mate ane geb avie ti be gabu natus ma be amol nok gimat vunu. Be bwayage-kob amol nok male geb avie tupe etok vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bemem gen weik etok ge gipil sotol kawe be male etok tepwengge. ");
INSERT INTO kbm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Be mulane kob avie nok gimat vunu weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dang-etok be wali atob nindeb mulane nivin ebe amolmol ebe imat vunu ok ve inamdil vukuri ok, okob eisir etok as amol ret atob nemb avie etok ve arue? Ve eisir bage tavlu be ano ailu etok tepwengge emb avie dongke etok ge?” ");
INSERT INTO kbm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Be Yisu giwel eisir avos be ginei, “Yem unei yaun etenok gitlek molge. Yem wat utpweng yaun ebe giengk Pomate ane kapia ok be tis Pomate ane gwang-ne are ite me? ");
INSERT INTO kbm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asonge nindeb mulane nivin ebe amolmol tepwengge ve inamdil vukuri ok, atob eisir meinahlang weik ebe Pomate ane ngalau kulkul ane ebe ivang gulumb ok. Be atob amol be avie inemb isate vukuri ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Be yaun ete amolmol imat vunu be inamdil vukuri ane ok, ane dabe dang eteik. Yem utpweng yaun ebe Pomate ginei gitangi yem ok gikwai me ma? Pomate ginei dang-eteik ginei: ");
INSERT INTO kbm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ablaham gabu Isak be Jakop as Pomate Ayeu.’ Be Yisu ginei, Pomate ei amolmol ebe asonge inambweg matawas ok ge as Pomate. Be amolmol ebe asonge inmat vunu vukuri nindeb mul-ane ok as Pomate ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Amolmol tepwengge iute yaun etok ok love ikuri vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisai subu iute ebe Yisu ges eisir Sadukai avos avut ok, be eisir iro is-ate sut ile ipil dongke. ");
INSERT INTO kbm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Be as amol ti ebe geb Mose ane yaun dabin ok gitangi Yisu gile be gilgum ve niutani Yisu be ginei. ");
INSERT INTO kbm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Gidung, wali Pomate ane yaun ake inend ete gwangne be vie molge?” ");
INSERT INTO kbm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisu giwel ei avo be ginei, “Tam nivin am Amol Bamo Pomate tis aplom be dabem-gwet tepwengge.” ");
INSERT INTO kbm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Yaun etenik ete vie molge. Be ti vukuri eteik; ‘Tam nivin am nune-nggen weik ete mie ate tam givin imate ok.’ ");
INSERT INTO kbm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mose ane yaun be tis Pomate ane amolmol kulkul ane as yaun walang ok gigas gireu yaun ake ailu etenik ge.” ");
INSERT INTO kbm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisai iro is-ate sut imbweg be Yisu giutani eisir be ginei. ");
INSERT INTO kbm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yem tangg-aim gitung nam-nambed gipil amol ebe ve nemb amolmol tepwengge ru ok? Be ei ane bambamo-nggen asav?” Be eisir iwel Yisu avo be inei, “Amol etok ane bambamo-nggen ete Dawit ane amolmol-gen ok.” ");
INSERT INTO kbm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Be Yisu ginei gitangi eisir, “Pomate ane Ngalau Yamar geb Dawit avut be Dawit gital amol etok ginei, Amol Bamo, be ginei dang-eteik. ");
INSERT INTO kbm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Pomate ginei gitangi awangg Amol Bamo. Umbweg umbloblo ayeu love amolmol valir ane tepwengge inatwep miam gwangne ane lu kob.’ ");
INSERT INTO kbm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Be Yisu ginei, Ginei Dawit nital amol ebe ve nemb amolmol ru ok ninei ane Amol Bamo, okob atob tandi amol nok tanei Dawit natu nam-nambed?” ");
INSERT INTO kbm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bemem eisir Parisai as amol ti gitangi ebe ve niwel Yisu avo be ninei yaun ti ok ite. Be givin sawa etok ge amol ti gile giutani Yisu ve yaun ti ane vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yisu ginei yaun gitangi amolmol be tis ei-ate ane singamolomb-gen givin be ginei. ");
INSERT INTO kbm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Eisir Parisai be tis gidung, ebe emb Mose ane yaun dabin ok, ginei ve inei yaun nitangi yem, ");
INSERT INTO kbm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","okob unaute eisir as yaun ge, be unalgum gen walang ok nitangi ete eisir inei gitangi yem ok. Bemem gen ret ete eisir ve inalgum ok, yem unalgum nivin ite. Ve yaun ete eisir inei ok, eisir inei ve avos ge be ilgum ano gile ite, ");
INSERT INTO kbm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","bekob avos gwang-ne molge gitle amolmol gili, be inei amolmol invang mul ve eisir as luev ge. Bemem kob eisir ate ok ivang mul ve as yaun ete inei ok ite ma yapin. ");
INSERT INTO kbm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Be Gen walang ete eisir ilgum ok, eisir ilgum veik amolmol indi eisir vie ane ok ge. Be ivnu gen weik ven-venu ok ve isbang Pomate ane kapia ebe ginei ane luev lavo ok gisov, be inggolong as kup tis kambam denden. ");
INSERT INTO kbm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Be as ete ve inambweg mate-ngge nangge taku ben ane be nangge lum mateu ane aplo ok yapin. ");
INSERT INTO kbm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Be tas givin ve inei amolmol avos nes eisir nangge nam luvwe-luvwe be intal eisir inei ‘Gidung.’ ");
INSERT INTO kbm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bemem yem, yem undi aim-ate weik ‘Gidung’ ite ve yem tepwengge weik ebe kawe be male ok be aim gidung dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Be undi amol ti nangge nalk etenik unei ei amol bamo be untal ei unei ‘Tamangg-aim’ ite. Ve yem tepwengge ‘Tamangg-aim’ dongke ebe gibweg gulumb ok. ");
INSERT INTO kbm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yem undi amol ti unei amol bamo ite ma, amol dongke-ngge ebe geb amolmol ru ok ete ei Amol Bamo. ");
INSERT INTO kbm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Be ginei yem aim amol ti ta gitung ve menihlang weik amol bamo ti, okob amol etok nilgum ate weik ebe yem tepwengge aim amol kulkul ane ti ok. ");
INSERT INTO kbm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amol ti ginei avo givwat ate, atob Pomate nili ei weik gen sin-ge. Be amol ti ginei gili ate weik gen sin-ge atob Pomate nili ei weik ebe amol bamo ok. ");
INSERT INTO kbm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, yem amolmol bingkasop ane roro. Asonge nindeb mul ane atob yem un-gas vavavne bamo molge, ve yem uvarkei luev ebe gitangi Pomate ane taku gile ok avut ve amolmol. Amolmol ok ilgum ve invang mul ve Pomate ane yaun bemem yem uvarkei eisir gili. Bemem yem ate ok gitangi ebe atob unsov Pomate ane taku unde ok ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Yem Parisai tis gidung ebe omb Mose ane yaun dabin ok, yem amolmol bingkasop ane. Yem ulgum ve uvaina avie gaptol, ebe aruas-gen imat vunkunu ok as nam be uvaina as wambal tis as mone givin, bekob usum aim tiate etok ve miengk undib bambamo molge gitangi Pomate. Bemem asonge yem un-gas vavavne bamo molge nindeb mul ane.) ");
INSERT INTO kbm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, yem undi aim-ate ge. Yem uvang omb taku avwut be urwel amolmol ilek ve invang mul ve yem aim luev ge. Bemem undi kob, ve eisir ete yem urwel is inme isov yem aim gen tiate aplo ok, atob inalgum gen tiate molge nitlek yem. ");
INSERT INTO kbm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, yem weik amolmol ebe matanos bop ok. Yem umbul amolmol be unei, ‘Amol ti ginei ninei yaun ti be nital lum yamar are be ninei bingano molge,’ ok bemem atob yem unei etok gen sin-ge. Bemem ginei amol ti ninei yaun ti be nital gen vie ebe giengk lum yamar aplo ok are be ninei bingano molge, okob ei nilgum ane yaun etok ano nile. ");
INSERT INTO kbm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yem utpweng gen are ite molge, yem weik amolmol ebe matanos bop ok. Yem uli gen vie ebe giengk lum yamar aplo ok unei gen vie molge gitlek gen bambamo etok. ");
INSERT INTO kbm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Be amol ti ginei ninei yaun ti be nital taku da ane are be ninei bingano molge, bemem yem unei etok gen sin-ge. Be ginei amol ti ninei yaun ti be nital da ebe giengk taku da ane ok are be ninei bingano molge, okob ei nilgum ane yaun etok ano nile. ");
INSERT INTO kbm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Be Yisu ginei, Bemem gen ebe vie molge gitlek da ok ete taku da ane. ");
INSERT INTO kbm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Beti ginei amol ti ninei yaun ti nipil taku da ane, okob ei ginei yaun gipil taku da ane be tis da ebe giengk taku etok ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Be amol ti ginei gibiti yaun ti be gital lum yamar are, okob ei gital lum yamar be tis Pomate are givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Amol ti ginei gibiti yaun ti be gital Pomate ane taku are, ei gital Pomate ane taku be tis Pomate are givin. ");
INSERT INTO kbm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, yem avongg-aim kire ailu. Yem ulgum vie ve uvwat aim gen walang ok nangge um be omb gen walang ok ane ano dongke dongke gitangi ge gitangi 10-10 ve da gitangi Pomate, bemem luev vie molge ebe ve tangg-aim nivin amolmol be aplongg-aim nivin Pomate ok, ete yem bwaingg-aim. Bemem gitangi ebe ve tanalgum gen ti be bwaind ve ti ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yem matanongg-aim bop, yem ulgum ve unatwem amolmol be yaun natu natu walang ok yem ulgum vie ve usov ane lu, bemem yaun ebe vie be gwangne molge ok ete yem bwaingg-aim. ");
INSERT INTO kbm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, asonge yem un-gas gen bunam molge, ve yem unei yaun bingkasop walang ano. Bekob upasang utlangg-aim ulis love vie molge ve ebe amolmol indi yem vie ane ok ge, bemem gen tiate walang ano gingik giengk yem aplongg-aim. Be gen tiate nok ete subu dang-eteik: Tangg-aim givin ve un-gas amolmol as gen, be ulgum gen gitangi ebe yem ate aim tangg-aim givin ok. ");
INSERT INTO kbm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yem matanongg-aim bop. Ginei yem aplongg-aim vie atob amolmol indi yem vie weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yem Parisai be tis gidung yaun ane, yem weik umbub ti ebe itak pen bogbogo gipil love vie molge ok, bemem nangge nalk aplo ane gingik ve amolmol ebe imat vunu ok tulkwas be tis gen tiate walang ano. ");
INSERT INTO kbm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Be yem ok weik etok ge. Yem upasang utlangg-aim ulis love vie molge veik ebe amolmol indi yem vie ane ok ge, bmeme luev bingkasop ane be tis mongai tinas ane gingik nangge yem aplongg-aim. ");
INSERT INTO kbm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yem Parisai be tis gidung ebe omb Mose ane yaun dabin ok, yem amolmol bingkasop ane. Asonge nindeb mul ane atob yem un-gas vavavne bamo molge. Yem omb Pomate ane amolmol ebe inei Pomate avo be tis amolmol ebe aplos givin Pomate ok as umbub dabin vie molge. ");
INSERT INTO kbm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Be yem unei, ginei yem unambweg nivin sawa ete tumbungg-aim gen imbweg ok, atob yem gitangi ebe unes Pomate ane amolmol ebe inei ei avo ok vunkunu ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bemem yem aim yaun etenok ete ginei lavo, ve amolmol ebe es Pomate ane amolmol ebe inei ei avo ok vunkunu ok, ete natus-gen yem etenik. ");
INSERT INTO kbm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Unde be unvang mul ve tumbungg-aim gen as luev ungglus ungglus etok ile beleinge yapin kob. ");
INSERT INTO kbm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yem weik muat tine ti tis natu-nggen, yem gitangi ebe atob unpelk unkwai gen bunam ete asonge Pomate nemb ninme ok nam-nambed? Likok-aim, asonge unreu yev bamo ebe giengk dang etok ok unde. ");
INSERT INTO kbm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Be unaute! Atob ayeu nahlin angg amolmol ebe inei ayeu avongg ok subu be tis amolmol mateu ane subu be gidung subu ebe emb Mose ane yaun dabin ok be inme. Kob atob yem unes eisir etok subu vunkunu, be unes subu inreu ei-givsangin, be unrau eisir subu nangge aim lum yamar aplo, be unvinvin subu nangge nam dabe walang ok. ");
INSERT INTO kbm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dang-etok be atob yem un-gas vavavne ve yem ate aim tiate ebe ulgum ok ane, be tis amolmol mate ane as tiate ebe warik es Pomate ane amolmol kulkul ane vunkunu ok as vavavne nivin. Eisir es Abel vunu gimungg be ginme love es Berekia natu Sakarias vunu nangge lum yamar aplo be tis taku da ane ane luvwe ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dang-etok be ayeu nanei bingano-ngge nitangi yem nanei, gen bambamo etok ete atob amolmol as-mate etenik ane in-gas ane vavavne nivin.” ");
INSERT INTO kbm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yem amolmol nangge Jerusalem, yem os Pomate ane amolmol kulkul ane be os amolmol ebe inei Pomate binge gitangi amolmol ok ve vat. Be ayeu galgum ve naro yem sut unme unambweg unambloblo ayeu weik ebe kavkavav tine ti giro natu-nggen sut gisov bage lan ane lu gile ok, bemem yem bwaingg-aim ve ayeu. ");
INSERT INTO kbm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dang-etok be unaute kob! yem aim taku asonge niengk bun sin-ge. ");
INSERT INTO kbm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Be galkik as-mate etenik be asonge niengk dang-etok, atob yem undi ayeu vukuri ite, love sawa ebe ayeu ve nanumul nanme nalk ok, okob atob yem unei, ‘Avond nivwat Pomate Natu are ve ginme tis Tame ane gwang-ne.’” ");
INSERT INTO kbm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yisu gile gihlang gikwai lum yamar aplo, be ane singamolomb-gen itangi ei ile ve ines lum yamar bamo etok ru nitangi Ei. ");
INSERT INTO kbm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Beti Yisu ginei gitangi ane singamolomb-gen be ginei, “Ayeu nanei nitangi yem, lum yamar bamo ete ande uli nik, asonge ane gen ti nivarkei vie be nivarkei lavo ite, atob tepwengge tiate nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisu gile gibweg matendubi ebe ei oliv anongge givarkei ok, be ane singamolomb-gen itangi ei bwaya-gege ile be inei, “Unei itangi amei kob ve wali gen etok atob menihlang tis asger? Be gen ret atob amei andi nimungg veik anatpweng sawa ete mie ve nunumul nunme nalk ok are?” ");
INSERT INTO kbm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yisu giwel eisir avos be ginei, “Undi ge, velob amolmol subu inme be inyo inyo aim. ");
INSERT INTO kbm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Asonge amolmol anongge inme be intal ayeu arengg nipil is ate be inei, “Ayeu amol ebe ve namb amolmol ru ok eteik,” kob atob eisir inyo inyo amolmol anongge. ");
INSERT INTO kbm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Be ginei yem ute valir ebe giengk taku undib undib ok be tis taku ebe gibloblo yem ok binge, okob unkur-kuri bwaya, ve gen dang-etok atob menihlang bemem gulumb tis nalk ane aiweng ite nangge. ");
INSERT INTO kbm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Atob nam dabe ti inamdil be ines valir nitangi nam dabe ti, be eisir vu ti atob inamdil be ines valir nitangi eisir vu ti, be atob gikuri nes nemb taku avut, be amolmol marav nes is anongge. ");
INSERT INTO kbm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Be gen tiate walang ano dang-etok atob menihlang, be vavavne etok atob nimungg ninme bekob. ");
INSERT INTO kbm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Be atob sawa ebe ve gen tiate bambamo etok ve menihlang ok, atob amolmol inemb yem ta be intak yem unambweg kapual-lu, be atob ines aim vunkunu. Atob amolmol anongge nangge taku walang ok atob bwais ve yem ve gisov awangg kulkul. ");
INSERT INTO kbm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Amolmol anongge atob inavkir dumas nitangi Pomate, be atob tas nitung as nune-nggen ite be inemb is-ate nitangi amolmol valir ane be ines is vunkunu. Be eisir ate ok atob inalgum dang-etok ge nitangi is-ate. ");
INSERT INTO kbm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Be amolmol anongge atob inme be inyo inei eisir Pomate ane amolmol-gen ebe inei Pomate avo ok, okob atob inyo inyo amolmol anongge. ");
INSERT INTO kbm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Be atob amolmol inalgum gen ungglus ungglus walang ano nemb taku avut, be atob inalgum be amolmol wat tas-viti is-ate ane vukuri ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bemem amol ti ginei giro ate ta be gigas gen bunam etok painge love gen bunam etok gile ma, atob amol etok nimbweg matawe nangge Pomate ane taku nindeb mulane. ");
INSERT INTO kbm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Atob inei mateu nipil luev ebe Pomate ve nemb amolmol dabin ok be amolmol nalk ane tepwengge inaute be ma nikwai kob atob sawa ebe nalk tis gulumb ma nikwai ok menihlang.” ");
INSERT INTO kbm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(Amolmol ebe isam yaun etenik ok inatpweng are vevie.) Yisu ginei, “Atob yem undi Sadam ane gen tiate bamo ti atob nisov lum yamar aplo nile nivarkei, dang ebe warik Pomate ane amol ti ebe ginei ei avo ok, are Daniel ginei ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kob atob amolmol ebe imbweg Juda as taku ok atob inpelk inreu matendubi-dubi inde. ");
INSERT INTO kbm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Be eisir ebe imbweg as nam luvwe ok gitangi ebe atob insov as nam aplo inde ve invwat as gen ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Be eisir ebe ivang as um aplo ok gitangi ebe atob indumul inde as nam ve invwat as kup tis as kambam ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Be sawa ete gen bunam etok ve menihlang ok atob avie gaptol ebe tis tas ok be tis eisir ebe emb rur ve natus-gen ge nangge ok atob in-gas vavavne bamo molge. ");
INSERT INTO kbm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dang-etok be unes miengk gwang-ne ge nitangi Pomate veik gen bunam etok menihlang tis urwemb me nivin sawa ebe eisir Juda ve indi as Sonda ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Givin ebe Pomate gipasang gulumb tis nalk vaku ge ok, be ginme love galkik as-mate etenik gen bunam ti dang-etenik meng-gihlang ite. Ma molge. Be asonge nindeb mulane ok atob gen bunam ti vukuri dang-etenik menihlang ite ma. ");
INSERT INTO kbm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ginei Pomate nes gen bunam etok gili seukie ite, atob amolmol tepwengge in-gas tiate be inmat vunkunu be ma. Bemem gisov amolmol ebe Pomate ande geb is yapin ve ane gen ok ane ge, beti atob ei nes gen bunam etok gili seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dang-etok be ginei nivin sawa etok ginei amol ti ginme be ginei, ‘Taundi. Amol ebe Pomate gihlin ve nemb amolmol ru ok ande ginme, ei meng-gihlang nangge taku eteok.’ Ginei amol ti ginme be ginei yaun dang-etok gitangi yem, okob tangg-aim nivin ei ane yaun bwaya. ");
INSERT INTO kbm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ve atob amolmol bingkasop ane anongge inme, be atob inyo inei eisir amolmol ebe emb amolmol ru ok be tis amolmol ebe inei Pomate avo ok, be atob inalgum gen bwalbwale anongge nangge yem nangg-aim. Be ginei eisir gitangi ebe ve inalgum gen dang-etok ok, okob gitangi atob inro amolmol ebe aplos givin Pomate ok vukir nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Be unaute. Ande ayeu ganei gen bambamo ebe asonge tepwe menihlang ok binge gitangi yem gimungg gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Be ginei amolmol subu ve inei ei meng-gihlang nangge taku sawa etok, be yem unde ite molge. Me ginei eisir inei ei gimumu nangge taku etok yem aplongg-aim nivin eisir as yaun ite. ");
INSERT INTO kbm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ve Pomate Natu Ayeu, ebe meng-gahlang weik amolmol ok, atob nanumul nanme weik ebe bilip geb ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Asonge nindeb mulane nivin ebe ayeu ve nanumul nanme nalk ok atob weik ebe man-gilavie iro isate sut itangi taku ebe gen gimat giengk ile ok.” ");
INSERT INTO kbm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Gen bunam etok nile ma nikwai, bekob atob as-matano tis aiweng atob niro ite, be viteukawe atob bingbleng nangge gulumb, be gen gwang-ne gwang-ne tepwe ebe giengk gulumb ok atob gigikie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bekob atob amolmol indi Pomate Natu ayeu ebe meng-gahlang weik amolmol ok, angg tuvweng menihlang nangge gulumb, be atob amolmol tepwengge inteng weik ebe tangir gimat ane ok. Be atob indi Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob nambweg nasov umbim aplo be nanumul nanme tis angg gwang-ne be tis angg bogbogo. ");
INSERT INTO kbm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Be atob nahlin angg ngalau kulkul ane tis tavulk be invang intangi nalk ane den ge inde, be inro Pomate ane amolmol tepwengge sut nangge gulumb tis nalk ane den. ");
INSERT INTO kbm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yem uli ei-ambla ebe lan gireu vaku ok, be utpweng are unei asausa gibloblo. ");
INSERT INTO kbm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dang-etok, be atob gen weik etok ge. Ginei yem uli gen bambamo ete galkok ve menihlang, okob tangg-aim nitung unei sawa ebe Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ve nanumul nanme ok ande gibloblo tepwe. ");
INSERT INTO kbm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ayeu nanei roro-ngge nitangi yem nanei: ‘Gen bambamo etok atob menihlang bekob amolmol as-mate etenik ane inmat vunkunu be ma.’ ");
INSERT INTO kbm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gulumb tis nalk asonge ma nikwai, bemem awangg yaun atob niengk dang etok.” ");
INSERT INTO kbm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Be Yisu ginei; “Amol ti gitpweng sawa ebe ayeu ve nanumul nanme ok are ite. Pomate ane ngalau kulkul ane be tis ei ate Natu Ayeu ok be anini givin weik etok ge. Pomate ei ate-ngge gitpweng are. ");
INSERT INTO kbm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nivin ebe Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ve nanumul nanme ok, atob weik ebe warik Noak tis ane amolmol-gen ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ve bui meng-gihlang ite nangge, be amolmol en be inum be ivang ti tas vevie-ngge. Be givin ebe Noak gisov ane ei-vovo aplo gile ok, ");
INSERT INTO kbm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","be amolmol tas gisgil isate ge love bui girun be gitimb amolmol tepwengge be bui gitun is be imat vunkunu be ma. Dang-etok be asonge sawa ebe Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ve nanumul nanme ok atob weik etok. ");
INSERT INTO kbm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nivin sawa etok atob amol ailu inemb kulkul invin is-ate nangge um aplo, be atob Pomate ninggas amol ti, be amol ti atob nimbweg em. ");
INSERT INTO kbm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Be avie ailu atob inemb kulkul ve indu ben nisov dongke invang, be atob Pomate ninggas avie ti be avie ti atob nimbweg em. ");
INSERT INTO kbm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Dang-etok be unpasang aim-ate yapin be unemb aim-ate dabin vie-ngge, ve yem tangg-aim gisgil sawa ebe Amol Bamo atob ninumul ninme ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yem uli be utpweng are gikwai, ve nam ti ane tivie ginei gitpweng are ginei atob tambok etenik amolmol vaina ane atob inme be inpil ei ane nam inde be invaina ei ane wambal, kob atob ei niengk ite ma, atob ei nimbweg be na niengk painge love nemb amolmol vaina ane etok ta kob. ");
INSERT INTO kbm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dang-etok be unpasang aimate weik etok ge. Ve Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob nanme nivin sawa ebe yem unei bwat ayeu ve nanme ite ok.” ");
INSERT INTO kbm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Amol kulkul ane vie ti ei gisov ane amol bamo ane yaun ane lu ge, be geb ane kulkul vie-ngge, be ei ane amol bamo geb ei ve nemb ane amolmol kulkul ane subu dabin be nemb ben nitangi eisir nivin. ");
INSERT INTO kbm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Be givin ebe amol bamo etok ginumul ginme ok, be ei ta vevie-ngge ve ane amol kulkul ane etok ebe geb ane kulkul vie-ngge ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Be Yisu ginei, ayeu nanei nitangi yem, amol bamo nok atob nemb ane amol kulkul ane etok ve nemb ei ane gen walang ok dabin. ");
INSERT INTO kbm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bemem ginei amol kulkul ane tiate ti, atob ei ninei nitangi ate, ‘Ayeu angg amol bamo gitangi ebe atob ninme seukie ok ite.’ ");
INSERT INTO kbm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Be atob ei nes ane amolmol kulkul ane subu, be nile ve nen be ninum nivin amolmol bui vavis ane nivang. ");
INSERT INTO kbm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Be amol bamo atob ninme tis sawa ebe ei ginei bwat atob ninme ite ok. ");
INSERT INTO kbm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Okob atob amol bamo nok nes ane amol kulkul ane etok tiate ge be nitin ei nile nimbweg nivin amolmol bingkasop ane. Be nangge taku etok atob eisir inteng be in-gas vavavne bamo molge.” ");
INSERT INTO kbm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Be Yisu ginei, “Sawa ebe Pomate ve nemb amolmol dabin ok, weik ebe avie vwivwei bage isgabu ivwat as lam be iro amol ebe ve nemb avie ok, avkavut nangge luev ile ok. ");
INSERT INTO kbm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Eisir bage tavlu dabas-gwet ma be bage tavlu eisir tis dabas-gwet vie be itpweng gen are. ");
INSERT INTO kbm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sotol bage tavlu ebe itpweng gen are ite ok, ivwat as lam bemem ivwat karasin subu givin ite. ");
INSERT INTO kbm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Be sotol ebe itpweng gen are ok, ete ivwat as lam be tis karasin subu gisov gen mate givin is-ate. ");
INSERT INTO kbm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Amol ebe ve nemb avie ok ginme seukie ite, be avie gaptol bage isgabu nok matanos bunam molge be iengk. ");
INSERT INTO kbm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Be givin tambok luvwe amol ti gital ginei, “Amol ebe ve nemb avie ok ete ginme nik be unamdil be unro ei avkavut unde.” ");
INSERT INTO kbm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Beti eisir imdil be itung as lam gitang-tangi ge. ");
INSERT INTO kbm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Be sotol bage tavlu ebe itpweng gen are ite ok inei gitangi as nune-nggen be inei, ‘Unemb karasin subu ve amei kob ve ande amei karasin ma. ");
INSERT INTO kbm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Be eisir ebe itpweng gen are ok inei, ‘Karasin eteik gitangi eitit tepwengge ite. Be unde be unavgo karasin ve aim.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Beti sotol ebe itpweng gen are ite ok ile ve inavgo karasin ve is. Be givin ebe sotol ile ok, be amol ebe ve nemb avie ok gibielk. Be sotol bage tavlu ebe ipasang is-ate yapin ok, ile isov nam aplo ivin amol ebe ve nemb avie ok, be es nam avo avwut. ");
INSERT INTO kbm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Be givin ebe avie gaptol tavlu ebe ile ve inavgo as karasin ok, imbielk be ital ve amol ebe ve nemb avie ok be inei, ‘Amol bamo os nam avo ponge ve amei.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bemem amol ebe ve nemb avie ok ginei, ‘Ayeu tangg gisgil yem.’ Be Yisu ginei; ");
INSERT INTO kbm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Dang-etok be yemunpasang aim-ate yapin, ve yem unini sawa ebe atob ayeu nanumul nanme ok.” ");
INSERT INTO kbm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Asonge nindeb mulane atob weik ebe amol bamo ti ve nivang taku undib ge ti, be ei gital ane amolmol kulkul ane inme be geb ane gen walang ok gisov eisir bais ve inemb dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ei geb K5,000 gitangi amol ti, be K2,000 gitangi amol ti, be K1,000 gitangi amol ti. Ei geb gen etok gitangi ane amolmol kulkul ane ve inalgum kulkul nipil bekob givang. ");
INSERT INTO kbm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amol ebe gigas K5,000 ok gile be geb kulkul gipl mone etok be gigas K5,000 vukuri meng-givin. ");
INSERT INTO kbm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be amol ebe gigas K2,000 ok gile be gilum weik etok ge be gigas K2,000 meng-givin. ");
INSERT INTO kbm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bemem amol ebe gigas K1,000 ok gile be gitav nalk avo be givwaivun ane amol bamo etok ane mone giengk nalk aplo. ");
INSERT INTO kbm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bwayage kob amol bamo nok ginumul ginme ve nili ane mone ebe geb gitangi ane amolmol kulkul ane ok ane ano. ");
INSERT INTO kbm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Beti amol ebe gigas K5,000 ok gitangi ane amol bamo gile be givwat mone ebe geb kulkul be gigas ok givin ei ate be gile. Ei ginei gitangi ane amol bamo be ginei, ‘Mie gob K5,000 ge gitangi ayeu be ayeu gale be gab kulkul gipil be gagas K5,000 eteik ginme givin.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Be amol bamo ginei gitangi ei, ‘Mie amol vie molge be amol kulkul ane vie ti be gob gen siti-ngge etok dabin vie molge. Beti atob ayeu namb mie ve nomb gen walang ok dabin. Unme be umbweg tis tam vevie-ngge nuvin ayeu.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Be amol ebe gigas K2,000 ok ginme be ginei gitangi ane amol bamo, ‘Mie gob K2,000 ge gitangi ayeu, be ayeu gab kulkul gipil be gagas K2,000 eteik ginme givin.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Be ei ane amol bamo ginei gitangi ei, ‘Mie amol kulkul ane vie molge be gob gen siti-ngge etok dabin vie molge. Usov unme be umbweg tis tam vevie-ngge uvin ayeu. Be atob ayeu namb gen walang ok nitangi mie ve nomb dabin.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Be bwayage kob amol ebe gigas K1,000 ok gitangi ane amol bamo gile be gine, ‘Amol bamo. Ayeu gatpweng mie are ganei mie amol gwang-ne be amol tis arem ti, be gen ebe amolmol subu ivro ok, bemem mie gugas ane ano. ");
INSERT INTO kbm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dang-etok beti ayeu gapelk be gale gaspun miam mone etok gisov nalk, be am gen nok etebeik.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Be ei ane amol bamo ginei gitangi ei, ‘Mie amol tiate be amol wayam ane roro. Ginei mie gutpweng ayeu are gunei ayeu amol ebe gagas gen ebe amolmol subu emb ane kulkul ok ane ano, ");
INSERT INTO kbm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","okob etok vie ve mie nomb mone etenok nitangi amolmol ebe emb mone giwel ate ok veik atob mie nunggas mone subu nile nivin mone ete ayeu gab gitangi mie ok, be nomb nitangi ayeu. ");
INSERT INTO kbm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dang-etok be unemb mone etok ikwai ei be unemb itangi amol ebe gigas K10,000 ok, ");
INSERT INTO kbm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ve amol ti ginei geb ane gen dabin vie-ngge atob ei ninggas subu nile nivin. Be amol ti ginei geb ane gen dabin vie ite, atob in-gas ei ane gen siti ebe giengk givin ei-ate ok nikwai weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Be unkari amol wayam ane etok isov aiweng tumi aplo ile, be nangge etok atob ei yayai be niteng anongge.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Asonge Pomate Natu Ayeu ebe meng-gahlang weik amolmol, nanumul nanme weik amol bamo ebe ve nemb amolmol dabin ok be angg bogbogo tis angg ngalau kulkul ane tepwengge atob nivin ayeu. Be atob ayeu nambweg taku ebe ve naute amolmol as yaun ok. ");
INSERT INTO kbm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Be amolmol nalk ane tepwengge atob inro is-ate sut inme be invarkei nindeb ayeu nangg ane. Be atob ayeu namb amolmol vusa nile dubi ailu-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Amolmol ebe aplos givin Pomate ok ete atob inambweg nindeb ayeu baingg mol ane, be amolmol tiate ane atob inambweg nindeb ayeu baingg kase ane. ");
INSERT INTO kbm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Be atob ayeu nanei nitangi amolmol ebe Tamangg gili eisir ginei amolmol vie ane ok be nanei; ‘Unsov unme be unabweg taku vie ebe warik Tamangg gipasang nalk tis gulumb vaku-ngge be gipasang ve yem yapin ok. ");
INSERT INTO kbm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ve ayeu marav ges au be bui ges au, be yem omb ben tis bui luvus ve ayeu gan be ganum, ayeu amol taku ti ane bemem yem unggas ayeu gapil aim nam gale. ");
INSERT INTO kbm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ayeu kup ma be yem omb kup ve ayeu gano, gimat gilgum ayeu be yem omb ayeu dabin vie-ngge, ayeu gabweg nangge kapual-lu be ule ve utlek nangg-aim ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Be atob amolmol ebe aplos givin ayeu ok atob inwel ayeu avongg be inei, ‘Amol Bamo, asger amei ali mie marav ges im be avkwen mie, mie bui ges im be amb bui luvus ve mie gunum? ");
INSERT INTO kbm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Be asger amei ali mie weik amol taku ti ane be anggas mie gupil amei nam me mie kup ma be amei amb kambam ve mie guro? ");
INSERT INTO kbm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Be asger mie gumat me gubweg nangge kapual-lu be amei alek atlek nangg-amei ve mie?’ ");
INSERT INTO kbm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Be atob ayeu nawel eisir avos be nanei. ‘Gen bambamo ebe yem ulgum gitangi awangg amol sin-ge ti ok, ete weik ebe ulgum gitangi ayeu givin ok.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Bekob narau-lili be nanei nitangi eisir ebe ivkir dumas gitangi Pomate ok, ‘Unde ebeok unkwai ayeu. Yem amolmol tiate ane. Unkwai ayeu be untangi yev bamo ebe giengk dang-etok ok unde. Ve Pomate gipasang yev bamo etok ve Sadam tis ane amolmol-gen tiate ane yapin. ");
INSERT INTO kbm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ayeu marav ges au bemem yem uvkwen ayeu ite, bui ges ayeu be yem omb bui ve ayeu ganum ite. ");
INSERT INTO kbm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ayeu amol taku ti ane be yem unggas ayeu gapil yem aim nam ite. Ayeu kup ma bemem yem omb kambam ve ayeu garo ite. Ayeu gamat be gabweg nangge kapual-lu bemem yem omb ayeu dabin ite.’ ");
INSERT INTO kbm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kob atob amolmol tiate ane nok inei nitangi ayeu dang-eteik, ‘Amol Bamo, asger amei ali mie marav ges im, be bui ges im, be kup ma, me gimat gilgum mie, me gubweg nangge kapual-lu be amei amb mie ru ite?’ ");
INSERT INTO kbm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Be atob ayeu nawel eisir avos be nanei, ‘Givin ebe yem uvkir dumangg-aim gitangi awangg amol sin-ge ti ok, ete yem uvkir dumangg-aim gitangi ayeu givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dang-etok be gen ret ret ete yem ulgum ulgum ok ete atob ni-itin aim unde unsov yev bamo ebe giengk dang-etok ok aplo unde. Be amolmol ebe aplos givin ayeu be ilgum awangg yaun ano gile ok ge, ete atob inambweg matawas dang etok invin ayeu nangge Pomate ane taku vie.” ");
INSERT INTO kbm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yisu ginei yaun bambamo etok love ma gikwai kob ginei gitangi ane singamolomb-gen amei be ginei. ");
INSERT INTO kbm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yem utpweng are gikwai ve ande as-mate ailungge giengk ebe ve Juda inalgum ben Pasova ane ok. (Eisir Juda ital as ben bamo etok inei Pasova, ve gisov eisir tas gitung as bambamo-nggen ebe warik Pomate ane ngalau kulkul ane ges is vunkunu ite ok.) Be atob amolmol inalgum awangg yaun ve ines ayeu nareu ei-givsangin.” ");
INSERT INTO kbm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Givin sawa etok eisir bambamo ebe ilgum amolmol as yaun ok iro isate sut isov amol bamo mateu ane ti ane nam. Eisir ital amol bamo nok inei Kaiafas. ");
INSERT INTO kbm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Be irek luev ebe ve inemb Yisu ta be ines ei vunu bwaya-gege ok. ");
INSERT INTO kbm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bemem inei, “Eitit tanalgum gen etenik nivin ben Pasova ane bwaya, velob eitit tanalgum amolmol aplos tiate.” ");
INSERT INTO kbm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yisu gibweg amol ti ebe warik gigas bid namvu, be Yisu gilgum ei be utle vie vukuri ok ane nam nangge Betani. Amol nok are Saimon. ");
INSERT INTO kbm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Be avie ti givwat marasin ukwas ti gisov gen mate ti be gitangi Yisu gile. Marasin ukwas etok ane mone bamo molge. Givin ebe Yisu gen ben gibweg ok, be avie nok gile be gimsuli marasin ukwas etok giwei Yisu dabe tulkwe. ");
INSERT INTO kbm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eisir singamolomb ili gen etok be tas vavis anongge be inei gitangi avie etok, “Mie gukari mone bamo molge gipil marasin ukwas etenok bekob guyaing ve ret ane? ");
INSERT INTO kbm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ginei tanemb marasin ukwas etenok nitangi amolmol subu be inavgo, atob tan-gas mone bamo molge be tanemb mone etok nitangi amolmol ebe wambal ma ve is ok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisu ande gitpweng ane singamolomb-gen as yaun are be ginei, “Unalgum ei be aplo bunam bwaya ve ei gilgum gen vie molge gitangi ayeu. ");
INSERT INTO kbm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yem asonge unvang unvin eisir ebe wambal ma ve is ok nemb ta-ngge, bemem ayeu atob navang navin yem nemb ta-ngge ite. ");
INSERT INTO kbm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Be avie etenik gilgum vie ve gimsul marasin ukwas etok gireu ayeu utlangg ulis ve gipasang ayeu utlangg ulis nalk avo gimat ane yapin. ");
INSERT INTO kbm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ayeu nanei bingano-ngge nitangi yem nanei; “Atob amolmol inei awangg binge nemb taku avut. Be avie etenik ane yaun ok atob inei nemb taku avut nivin veik amolmol tas nitung ei nivin.” ");
INSERT INTO kbm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bekob eisir singamolomb 12 etok as amol ti are Judas Iskariot gitangi bambamo ebe emb lum mateu ane dabin ok gile, ");
INSERT INTO kbm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","be ginei, “Atob yem unemb gen ret ve ayeu, ginei ayeu natak Yisu nisov yem baingg-aim?” Be eisir emb mone siliwa gitangi 30 ve Judas Iskariot. ");
INSERT INTO kbm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Givin sawa etok ge Judas Iskariot gilgum ve nili sawa vie-ngge ti kob nile ninei Yisu binge nitangi amolmol valir ane. ");
INSERT INTO kbm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Givin ebe amolmol ipasang is-ate ve inalgum as ben bamo etok ok. Be eisir singamolomb itangi Yisu ile be inei, “Mie tam givin gunei amei anpasang ben nangge nam inend ve eitit?” ");
INSERT INTO kbm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Be Yisu ginei gitangi ane singamolomb-gen, “Unde unahlang nam bamo Jerusalem ok be undi amol ti be unei nitangi ei be unei, ‘Amei-mei gidung ginei gibloblo ve ei nimat vunu, be ei tis ane singamolomb-gen ve inen ben inambweg miam nam.’” ");
INSERT INTO kbm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Beti esir singamolomb ile be ilgum gitangi ebe galkik Yisu ginei gitangi eisir ok be ipasang tepwe tis Yisu as ben nangge etok. ");
INSERT INTO kbm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Givin gibok Yisu tis ane singamolomb-gen imbweg be en ben. ");
INSERT INTO kbm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eisir en ben imbweg bekob ete Yisu ginei gitangi eisir be ginei; “Ayeu nanei bingano-ngge nitangi yem, yem aim amol ti atob ninei ayeu binge nitangi amolmol valir ane.” ");
INSERT INTO kbm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eisir singamolomb iute yaun etok be aplos bunam molge be emb is-ate dongke dongke itangi Yisu ile be iutani ei be inei, “Mie tam gitung gunei atob ayeu nalgum me?” ");
INSERT INTO kbm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Be Yisu giwel eisir avos be ginei, “Amol ti ete gibweg gisov yem aplo nik, amol nok eilu an ben gisov bele dongke. ");
INSERT INTO kbm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob namat vunu nitangi ebe warik Pomate ane amolmol ebe inei ei avo ok inei ok. Bemem amol ete ve ninei Pomate Natu Ayeu binge nitangi amolmol valir ane ok likok, atob ninggas vavavne bamo molge. Gen etok vie ve amol nok tine nikuv ei bwaya ma.” ");
INSERT INTO kbm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas Iskariot giutani Yisu be ginei, “Gidung, mie guli gunei atob ayeu nalgum me?” Be Yisu giwel ei avo be ginei, “Nok ete ande Mie ate gunei imate vusa nok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Givin ebe Yisu tis ane singamolomb-gen en ben imbweg ok, be Yisu geb ben siti be ges miengk be ginei ane ta-vie gitangi Pomate bekob geb ben etok vusvusa be gibwas gitangi ane singamolomb-gen be ginei, “Unemb ilek unen. Etenik weik ebe ayeu virongg ok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bekob geb wain tis kap be ges miengk be ginei ane ta-vie gitangi Pomate bekob geb gitangi ane singamolomb-gen be ginei, ");
INSERT INTO kbm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Tepwengge unemb ilek be unum. Etenik weik awangg tuwerk ebe atob nilgum Pomate ane yaun ebe warik gibiti ok ane nile ok. Awangg twerk atob nimsuli ve nisin amolmol tepwengge as tiate nikwai. ");
INSERT INTO kbm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Be Ayeu nanei bingano-ngge nitangi yem nanei, atob ayeu nanum wain etenik vukuri ite love Pomate nemb amolmol dabin nangge ane taku okob atob ayeu nanum wain vaku etok navin yem nangge Tamangg ane taku.” ");
INSERT INTO kbm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yisu tis ane singamolomb-gen inei uye mateu ti gikwai kob imdil ile ihlang be ile ireu matendubi ebe ei oliv anongge givarkei ok ile. ");
INSERT INTO kbm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yisu ginei gitangi ane singamolomb-gen be ginei; “Atob tambok etenik atob yem tepwengge unpelk unkwai ayeu. Ve warik Pomate ane amolmol ebe inei ei avo ok inei yapin inei, ‘Atob Pomate nes amol ebe geb bwelk sipsip dabin ok vunu kob atob bwelk etok invang inriv be inra nangge taku walang ok.’ ");
INSERT INTO kbm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bemem atob ayeu namdil vukuri nangge taku gimat ane be atob namungg nale bui kapul ebe Galilaia ok, bekob yem.” ");
INSERT INTO kbm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Be Pita ginei gitangi Yisu, “Eisir tepwengge ginei bwais ve mie be inpelk inkwai mie ok inde, bemem ayeu wat bwaingg ve mie be napelk nakwai mie ite.” ");
INSERT INTO kbm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Be Yisu ginei gitangi ei, “Ayeu nanei bingano-ngge nitangi mie nanei, atob tambok etenik kavkavav atob niteng bulwer aitol ane ite nangge be atob mie nos ayeu arengg ta be nunei, ‘Ayeu ganini amol etenok.’” ");
INSERT INTO kbm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Be Pita giwel Yisu avo be ginei, “Ayeu ganei bingano ganei atob ayeu namat vunu navin mie, be ayeu gitangi ebe atob nas mie arem ta ok ite.” Be eisir singamolomb tepwengge ok inei yaun avo ete Pita ginei ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisu tis ane singamolomb-gen imbielk ve taku ti are Getsemani, be Yisu ginei gitangi ane singamolomb-gen, “Unambweg etenik be ayeu ve nale nas miengk nangge eteok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Be gigas Pita be Sebedi natu-nggen Jems gabu Jon ivin ei be ile. Yisu aplo bunam molge, ");
INSERT INTO kbm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","be ginei ve sotol; “Ayeu gagas bunam walang ano be bunam bambamo etok gisak ayeu love kasop ge be namat vunu. Dang-etok be unambweg matanongg-aim sang-sangas unvin ayeu nangge etenik.” ");
INSERT INTO kbm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yisu givang siti-ngge gile be gikari ate gile gitak nalk be ges miengk gitangi Pomate ve ginei gen bunam etok nipil ei bwaya. Yisu ge miengk dang-eteik: “Tamangg. Mie gitangi atob nuitin gen bunam etok nikwai ayeu. Bemem mie nulgum nitangi ebe ayeu tangg givin ok ite. Nulgum nitangi miam tam gitung.” ");
INSERT INTO kbm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yisu gilumul gitangi Pita gabu Jems be Jon gile be gili sotol ande iengk, be ei ginei gitangi Pita be ginei; “Yemtol gitangi ebe atob unambweg matanongg-aim sang-sangas unvin ayeu nitangi as-matano sawa dongke-ngge ok me ma? ");
INSERT INTO kbm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Unambweg matanongg-aim sang-sangas be unes miengk veik gen bunam etok nipil yem nivin ite. Yem tangg-aim givin ve unalgum gen dang-etok bemem matanongg-aim ge bunam beti gilgum be utlangg-aim bua.” ");
INSERT INTO kbm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yisu gilumul gile ve nes miengk vukuri be ginei, “Tamangg. Mie gitangi atob nuitin gen bunam etok nikwai ayeu. Bemem miam yaun atob ano nile.” ");
INSERT INTO kbm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yisu gilumul ginme be gili ane singamolomb-gen aitol ebok ande iengk ikwai. Sotol gitangi ebe ve inambweg matanos sang-sangas ok ite. ");
INSERT INTO kbm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yisu gikwai sotol be gilumul gile ve nes miengk vukuri be ginei yaun dongke nok ge vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bekob gilumul gitangi ane singamolomb-gen gile be ginei, “Ande uyengk be uyap gitangi be unamdil be tanvang. Ve sawa ebe amol ebe ve nemb Pomate Natu Ayeu nitangi amolmol tiate ane bais ok etenik. ");
INSERT INTO kbm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Taundi-e. Amol ebe ve ninei ayeu binge ok etenik.” ");
INSERT INTO kbm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu ginei yaun gitangi Pita gabu Jems be Jon givang ge be Judas Iskariot gibielk. Judas Iskariot nok ei Yisu ane singamolomb ti. Be bambamo ebe emb lum mateu ane dabin ok be tis juda as amolmol ebe ipasang amolmol as yaun ok ihlin amolmol valir ane dubi bamo ti be ivwat buyag valir ane tis as kumungg be ivang mul ve Judas Iskariot be ile. ");
INSERT INTO kbm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Be ande Judas Iskariot ginei yaun ve amolmol valir ane nok yapin be ginei; “Tande be ginei uli amol ete ayeu gavang gatangi gale ve nasavi ei ok, okti amol nok etok ebe yem tangg-aim givin ve unemb ei ta ok. Be baingg-aim nisov ei be un-gas ei unde.” ");
INSERT INTO kbm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Givin ebe Judas Iskariot givang roron-gge gitangi Yisu gile ok be ginei, “Tambok vie Gidung,” be gisavi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Be Yisu giwel Judas Iskariot avo be ginei, “Angg nune. Ulgum am gen ete ve nulgum nok seukie ma?” Be amolmol valir ane ebok bais gisov Yisu be emb ei ta gwang-ne ge be inggas ei be ile. ");
INSERT INTO kbm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Be amolmol ebe ivang ivin Yisu ok as amol ti bage gisov ane buyag valir ane be ges amol bamo ebe geb kulkul da ane ok ane amol kulkul ane ti talngelan tavlu gili. ");
INSERT INTO kbm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Beti Yisu ginei gitangi amol nok, “Utak am buyag inumul isov ile iengk lavo, ve eisir tepwengge ete ivwat buyag valir ane nik asonge inmat vunkunu ve buyag etok ane. ");
INSERT INTO kbm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mie wat gutpweng are ite me? Ginei ayeu nautani Tamangg ve nemb ayeu ru, atob ei nihlin ane ngalau kulkul ane walang ano be inme. ");
INSERT INTO kbm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bemem gisov yaun ebe warik Pomate ane amolmol ebe inei ei avo ok inei gimungg gikwai ok ane ge, beti atob yaun etok ano nile.” ");
INSERT INTO kbm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Be Yisu ginei gitangi amolmol valir ane be ginei; “Yem uvang tis buyag valir ane be tis kumungg bambamo etenik be unme ve un-gas ayeu weik ebe amol vaina ane ti ok ba? Asmate walang ok ayeu gabweg gavin yem be gabul yem nangge lum yamar bamo eteok aplo bemem yem omb ayeu ta ite ve ret ane? ");
INSERT INTO kbm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bemem galkik gen walang etenik meng-gihlang gitangi yaun ebe warik Pomate ane amolmol ebe inei Pomate avo ok inei yapin ok. Beti atob yaun etok ano nile.” Be eisir singamolomb tepwengge ikwai Yisu be ipelk iriv be ira. ");
INSERT INTO kbm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Amolmol valir ane ebe emb Yisu ta ok inggas Yisu itangi amol bamo ti ebe geb amolmol ebe emb kulkul da ane dabin ok, are Kaiapas ane nam ile. Ve nangge etok gidung ebe emb Mose ane yaun dabin ok be tis bambamo ebe emb lum mateu ane dabin ok ande iro is-ate sut isov taku dongke etok yapin be imbweg. ");
INSERT INTO kbm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita gitau gile Yisu bemem ei givang aikawe kasopge. Ei gisov Kaiapas ane simbel aplo gile be gibweg givin Kaiapas ane amolmol kulkul ane ve niute ninei yaun ret ete eisir ve inalgum nipil Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amolmol ebe emb lum mateu ane dabin ok be tis eisir ebe ipas-pasang amolmol as yaun ok inei yaun bingkasop walang ano gipil Yisu be ilgum veik ebe ines ei vunu ok. ");
INSERT INTO kbm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amolmol anongge imdil be inei yaun bingkasop anongge, bemem eisir as yaun ti ano gile ite. Be bwayage-kob amol ailu imdil, ");
INSERT INTO kbm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","be inei, “Amol etenik ginei ei gitangi ve niyaing Pomate ane lum yamar nikwai bekob nitav vukuri nitangi as-mate aitol ge.” ");
INSERT INTO kbm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Be Kaiapas gimdil be ginei gitangi Yisu, “Mie gitangi ebe atob nuwel amolmol bambamo etenik avos ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bemem Yisu tumi-ngge be ginei yaun ti ite. Beti Kaiapas giutani ei vukuri be ginei, “Mie unei itangi amei kob. “Mie amol etenik ebe ve nomb amolmol dabin ok me? Be Pomate Natu mie me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yisu giwel Kaiapas avo be ginei, “Yaun nok ete ande mie ate gunei nok. Bemem ayeu nanei nitangi yem. Asonge nindeb mulane atob yem undi Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob nambweg nambloblo Tamangg nangge Tamangg ane taku vie. Be atob ayeu nambweg nawei umbim gulumb ane be nanumul nanme.” ");
INSERT INTO kbm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Givin sawa etok ge Kaiapas ande tavavis anongge be gisiel ei ate ane kup be ginei, “Eitit tanasge amol ti vukuri ebe ve inei yaun nipil Yisu ok vukuri ite, ve ande eitit tepwe taute yaun ungglus ungglus ebe ei ginei gipil Pomate ok gikwai. ");
INSERT INTO kbm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Be yem tangg-aim gitung nam-nambed?” Be amolmol tepwengge iwel Kaiapas avo be inei, “Ei gilgum gen tiate be tanes ei vunu nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Amolmol tepwengge inei yaun etok gikwai kob subu iluk gireu Yisu na be subu isumsumi bais be es ei, be subu ivtav ei, ");
INSERT INTO kbm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","be inei, “Mie amol ebe gob amolmol ru ok etenik mera? Be dang mie unei itangi amei unei amol ret ete ges mie nik?” ");
INSERT INTO kbm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita gibweg nam luvwe be na giengk gen ebe eisir ilgum gitangi Yisu ok, be Kaiapas ane avie kulkul ane ti gitangi ei gile be gine, “Mie amol etenik ebe guvang guvin Yisu ebe nangge Galilaia ok mera?” ");
INSERT INTO kbm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bemem Pita ginei gitangi eisir tepwengge be ginei, “Ayeu tangg gisgil yaun ete yem unei nok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita gile givarkei sagin dume bekob Kaiapas ane avie kulkul ane ti gili ei vukuri be ginei gitangi amolmol ebe ivarkei ok, “Amol etenok ebe givin Yisu Nasaret ane ok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bemem Pita ginei yaun gwangne molge be ginei, “Bingano molge, ayeu tangg gisgil amol etenok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Be bwayage-kob amolmol ebe tepwe ivarkei etok ok inei gitangi Pita be inei; “Bingano molge, mie Yisu ane amol ti, ve ande amei atpweng mie are giengk miam yaun ebe gunei ok.” ");
INSERT INTO kbm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bemem Pita ginei yaun gwangne molge be girusu bage givin be ginei, “Bingano molge, ayeu tangg gisgil amol etenok.” Pita ginei yaun etok givang ge be kavkavav giteng. ");
INSERT INTO kbm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Beti ei ta giro yaun ebe warik Yisu ginei gitangi ei ok ve, “Atob kavkavav niteng bulwer aitol ane ite nangge be atob mie nunei mie tam gisgil ayeu.” Beti Pita givang gile gihlang gikwai Kaiapas ane nam avo be giteng anongge. ");
INSERT INTO kbm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Givin tistumi-ngge bambamo ebe emb lum mateu ane dabin ok be tis eisir yaun ane irek luev ebe ve ines Yisu vunu ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beti idgin Yisu bage ta ve seng be inggas itangi amol bamo Pilata ile. ");
INSERT INTO kbm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Givin ebe Judas Iskariot amol ebe gitak Yisu gisov amolmol valir ane bais ok, gili ebe amolmol ilgum Yisu ane yaun avo vie ite ok, love gitangi ei aplo ite beti givwat mone ebe bambamo lum yamar ane ivgo ei ok ginumul gile geb gitangi eisir ate vukuri be ginei. ");
INSERT INTO kbm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Ayeu galgum tiate ve gatak amol vie molge etenik gisov amolmol valir ane bais.” “Be eisir iwel Judas Iskariot avo be inei “Gen etenik amei-mei gen ite, etenik miam gen.” ");
INSERT INTO kbm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Be Judas Iskariot gikari mone etok gile gitak lum yamar aplo be gikwai eisir be gile gig-luen ve ate be gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bekob bambamo lum yamar ane bais gisov mone etok be inei, “Etenik mone twerk ane, be gitangi ebe atob tantak niengk nivin mone lum yamar ane ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Beti bambamo ebe emb lum yamar dabin ok be tis amolmol yaun ane subu inei yaun gisov dongke be ile ivgo amol ebe gipasang ul ve nalk ok ane nalk sawa ti ve mone etok, ve inaspun amolmol taku ti ane inyengk nalk sawa etok. ");
INSERT INTO kbm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Be ital taku nok are inei taku twerk ane love galkik asmate etenik ok givin. ");
INSERT INTO kbm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Beti yaun ebe warik Pomate ane amol ebe ginei Pomate avo ok are Jelemia ginei ok ande ano gile. Ve Pomate ginei dang-eteik; ‘Atob amolmol invwat mone siliwa nitangi 30, ebe amolmol nangge Israel emb ve inavgo ei ok, ");
INSERT INTO kbm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","be inde inavgo amol ebe gipasang ul ve nalk ok ane nalk sawa ti.’ ");
INSERT INTO kbm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisu givarkei nangge Pilata na be Pilata giutani ei be ginei, “Mie amol bamo ebe gob amolmol dabin nangge Juda as taku ok etenik me?” Be Yisu giwel Pilata avo be ginei, “Yaun nok ete ande miate gunei nok.” ");
INSERT INTO kbm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Be Pilata ginei gitangi Yisu, “Be bambamo ebe emb lum yamar dabin ok tis amolmol yaun ane subu inei yaun bingkas-kasop gipil mie. ");
INSERT INTO kbm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kob ande gute yaun bambamo ete eisir inei gipil mie ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bemem Yisu ginei yaun ti vukuri ite ok. Be Pilata gikuri vunu-ngge ve gili ebe Yisu ginei yaun ti vukuri ite be tumi-ngge givarkei ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Givin Sonda bamo walang ok Juda ilgum ben Pasova ane, be amol bamo ebe geb amolmol dabin ok atob nihlang amolmol ebe imbweg nangge kapual-lu ok dongke dongke nitangi ebe amolmol tas givin ok be menihlang nikwai kapual-lu. ");
INSERT INTO kbm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Be givin sawa etok ete amol tiate ti gibweg nangge kapual-lu givin, amol nok are Barabas. ");
INSERT INTO kbm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Amolmol tepwengge iro isate sut gikwai kob, Pilata giutani eisir be ginei; “Yem tangg-aim givin ve ayeu nahlang amol ret nangge kapual-lu be nitangi yem nilek? Barabas me Yisu ebe amolmol ital ei inei Amol ebe geb amolmol ru ok?” ");
INSERT INTO kbm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilata ande gitpweng are gikwai ginei bambamo ebe emb lum yamar dabin ok inggas Yisu itangi ei ile ve gisov eisir tas vadbu ve ebe amolmol tas givin Yisu anongge gitlek eisir ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Givin ebe Pilata gile gibweg taku ebe ve niute amolmol as yaun ok be arue geb yaun gitangi ei gile be ginei, “Uli ve nulgum gen ti nitangi amol vie etenok, ve galkik tambok etenik ayeu gayengk mev giro amol etenok, be ayeu aplongg bunam molge.” ");
INSERT INTO kbm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bambamo ebe emb lum yamar dabin ok be tis amolmol yaun ane inei yaun gisov amolmol ve inei nitangi Pilata be nihlang Barabas nitangi eisir nile, be ines Yisu vunu. ");
INSERT INTO kbm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilata giutani eisir vukuri be ginei, “Amol ailu ete imbweg kapual-lu imbweg nik, be yem tangg-aim givin ve ayeu nahlang sulu as amol ret nitangi yem nilek?” Eisir iwel Pilata avo be inei, “Mie nuhlang Barabas nitangi amei ninme.” ");
INSERT INTO kbm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Be Pilata ginei, “Be atob ayeu namdom nitangi Yisu ebe amolmol ital ei inei Amol ebe geb amolmol ru ok?” Be amolmol tepwengge iwel Pilata avo be inei, “Tanes Ei nireu ei-givsangin nile.” ");
INSERT INTO kbm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bemem Pilata giutani eisir vukuri be ginei, “Yisu gilgum gen tiate ret?” Be amolmol tepwengge ital yaun iro av-kavut ge inei, “Tanes Ei nireu ei-givsangin. Tanes Ei nireu ei-givsangin.” ");
INSERT INTO kbm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilata gilgum ve nilgum amolmol aplos vie, beti gile givuk bage nangge amolmol tepwengge nas be ginei, “Ayeu gitangi ebe nanei be yem unes amol etenik vunu ok ite, be yem aim gen.” ");
INSERT INTO kbm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Be amolmol tepwengge iwel Pilata avo be inei, “Amei tis natungg-amei-nggen gitangi atob an-gas amol etenik ane twerk ane den.” ");
INSERT INTO kbm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be Pilata gihlang Barabas gitangi eisir gile, be geb Yisu gitangi amolmol valir ane gile ve inrau ei bekob ines ei nireu ei-givsangin. ");
INSERT INTO kbm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilata ane amolmol valir ane inggas Yisu isov amol bamo ebe geb eisir dabin ok ane simbel aplo ile, be amolmol valir ane tepwengge iro isate sut ile idbul Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bekob iwaulu Yisu ane kup gikwai be ino kup mwele ti gireu, ");
INSERT INTO kbm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","be ipasang gululung ti ve wal duduli subu be es gisov Yisu dabe, be emb kabut ti gile bage tavlu bekob ilgum molok gile ei be iro vas dubi supwe gisov nalk gitangi be inei yaun ungglus ungglus gipil ei be inei. “As-mate mie. Mie amol bamo ebe gob amolmol dabin nangge Juda as taku ok etenik mera?” ");
INSERT INTO kbm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Amolmol iluk gireu Yisu be irau ei ve kabut nok gisov dabe. ");
INSERT INTO kbm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eisir valir ane ilgum gen ungglus ungglus bambamo etok gipil Yisu gikwai kob, iwaulu kup mwele etok gikwai ei be ino ei ate ane kup gireu vukuri be inggas ile ve ines nireu ei-givsangin. ");
INSERT INTO kbm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Amolmol valir ane inggas Yisu ile ve ines nireu ei-givsangin be ile vunge ve amol ti are Saimon nangge luev. Amol nok ei nangge Sairini as taku. Be amolmol valir ane avos girau ei ve nemb Yisu ru be nivwat ane ei-givsangin. ");
INSERT INTO kbm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Eisir inggas Yisu ile taku ti are Golgada, are etok ane dabe dangeteik; Taku ebe amolmol dabas tulkwe anongge giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Be emb wain tis gen vavis ti ve Yisu ninum veik nili ebe es ei be viti ok ite, bemem Yisu bua ve ninum. ");
INSERT INTO kbm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eisir valir ane es Yisu gireu ei-givsangin gile gikwai kob es bwas ve indi inei atob amol ret nivwat Yisu ane kup. ");
INSERT INTO kbm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Be eisir imbweg etok ve nas ginal Yisu ebe gikaiwel ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Be eisir iro yaun ake ebe es ei vunu gisov ok bwalbwale dang eteik inei, ‘Amol etenik are Yisu. Amol Bamo (King) ebe geb amolmol dabin nangge Judia as taku ok.’ Be es gireu Yisu ane ei-givsangin giengk einggoto ane. ");
INSERT INTO kbm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Be amolmol valir ane nok es amol ailu ebe as amolmol vunkunu be ivaina gen ok gireu ei-givsangin gile givin ivin Yisu. Amol ti gikaiwel gideb Yisu bage mol ane be ti gikaiwel gideb kase ane. ");
INSERT INTO kbm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Amolmol ebe ilek be inme ivang luev sawa etok ok indank be ili be ilailai dabas be inei: ");
INSERT INTO kbm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mie amol etenik ebe gunei nuyaing lum yamar nikwai, bekob nutav vukuri nitangi as-mate aitol ge ok etenik mera? Dang-etok, be ginei Pomate Natu mie bingano, okob omb im ate ru be usov motak ukwai ei-givsangin ma?” ");
INSERT INTO kbm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Be bambamo lum yamar ane be tis eisir ebe emb Mose ane yaun dabin ok inei yaun ungglus ungglus gipil Yisu weik etok ge be inei. ");
INSERT INTO kbm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ei gitangi ve nemb amolmol ebe ok ge ru, be gitangi ebe ve nemb ate ru ok ite. O Israel as amol bamo ebe geb eisir dabin ok, galkik etenik ginei ei geb ate ru be gisov meng-gitak gikwai ei-givsangin okob atob eitit tandi be aplond nivin ei. ");
INSERT INTO kbm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ei aplo givin Pomate be ginei Pomate ane Natu ei mera? Dang-etok okob tanasge be tandi, tanei atob Pomate ta nivin ei be nemb ei ru me ma?” ");
INSERT INTO kbm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Be amol ailu ebe amolmol valir ane es sulu gireu ei-givsangin givin ok inei yaun ungglus ungglus gipil Yisu weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Givin as-mate luvwe taku tumi bamo molge geb taku avut. ");
INSERT INTO kbm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Be givin as-matano aitol givin gibok Yisu gital yaun avo bamo dongke be ginei, “Eli Eli lama sabatani.” Yaun ake etok ane dabe dangeteik; “Pomate, awangg Pomate nam-nambed ete ande mie ve tam nivalngan ayeu nik?” ");
INSERT INTO kbm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Beti amolmol ebe ivarkei etok ok inei, “Ei gital Ilaija mera?” ");
INSERT INTO kbm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Beti amol ti gituvki seukie-ngge gile be giro gen mwaimuai ti utuv gisov bui vavis ti be gidgin gisa kabut ti be gisu gireu gitangi Yisu gile ve ninum. ");
INSERT INTO kbm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bemem amolmol subu inei, “Utau ge. Be eitit tanvarkei ge be tandi kob, velob Ilaija ninme be nemb ei ru.” ");
INSERT INTO kbm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Be Yisu gital avo bamo ti vukuri be gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Be babal bamo ebe gikaiwel lum yamar aplo ok gisiel vusa gile ailu. Givin sawa etok ge gikuri ges bamo molge be vat bambamo gipuek vusvusa gile ailu ailu. ");
INSERT INTO kbm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Be nangge taku gimat ane nalk avo pingpong be Pomate ane amolmol gimungg ane ebe warik imat vunkunu ok matawas be imdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","56","Eisir etok imdil vukuri nangge taku gimat ane, be bwayage Yisu gimdil gikwai taku gimat ane, kob ete tepwengge ile taku ebe lum yamar bamo givarkei ok be amolmol tepwengge matanos gitut gipil eisir. Be avie gaptol subu ebe ivang mul ve Yisu nangge Galilaia be emb ei dabin ok ivarkei aikawe ge be nas ile ili. Avie gaptol nok subu are eteik. Malia Magdala, be Jems gabu Josep tinas Malia be Sebedi natu-nggen Jems gabu Jon tinas. Givin ebe amolmol valir ane tis as amol bamo ebe gitwem eisir ok ivarkei ve emb Yisu utle ulis dabin ok, be ili gikuri bamo ebe ges ok be tis gen bambamo ebe meng-gihlang ok be ikuri vunu-ngge be inei, “Amol etenik Pomate Natu bingano molge.” ");
INSERT INTO kbm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Givin gibok etok amol ti ebe tis wambal walang ok gibielk. Amol nok are Josep be ei nangge Arimatia as taku. Josep nok ei Yisu ane amol singamolomb ti. ");
INSERT INTO kbm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ei givang gitangi Pilata gile be giutani Pilata ve nivwat Yisu utle ulis nile nispun. Beti Pilata ginei gitangi ane amolmol valir ane ve inemb Yisu utle ulis nitangi Josep. ");
INSERT INTO kbm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep givgo kambam bogbogo vaku ti be gile gisum Yisu utle ulis gisov. ");
INSERT INTO kbm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bekob givwat gile gispun gisov nalk avo vaku ti ebe Josep ei ate gitav ok. Be gidugdug vat bamo ti gile giengk giwei nalk avo ebe Yisu giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Magdala be Jems gabu Josep tinas Malia, sulu imbweg etok be nas giengk umbub ebe Josep gispun Yisu gisov ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","As-mate ebe Juda ipasang isate ve indi as Sonda ok gile gikwai kob, be imdil tistumi ti ane kob, bambamo ebe emb lum mateu ane dabin ok be tis eisir Parisai itangi Pilata ile ");
INSERT INTO kbm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","be inei, “Amol bamo, amei tangg-amei gitung yaun ebe amol bingkasop ane etok ginei givin ebe gimat vunu ite nangge ok, ve ei ginei atob nivin as-mate ebe ve aitol ane ok, okob atob ei matawe be nimdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dang-etok be unei yaun itangi am amolmol valir ane, be inde inemb ei ane umbub dabin love as-mate aitol etok ma nikwai kob. Velob ei ane singamolomb-gen inde be invwat ei utle ulis nikwai nalk avo, bekob inde inei nitangi amolmol inei Yisu ande gimdil vukuri nangge taku gimat ane. Kob atob yaun bingkasop ete eisir ve inei nitangi amolmol ok atob nivang nemb taku walang ok avut nitlek mate ane.” ");
INSERT INTO kbm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Beti Pilata ginei gitangi eisir be ginei, “Un-gas amolmol valir ane subu be unde be unvarkei umbub avwut love gwang-ne nitangi ebe ulgum ulgum ok. ");
INSERT INTO kbm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Beti eisir ile be runggwei gile Yisu ane umbub love gwang-ne, be emb eisir valir ane subu ve inemb umbub dabin. ");
INSERT INTO kbm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juda as Sonda ma gikwai be givin Sonda tistumi-ngge givin ebe tumi gisov nalk ge nangge ok, be Malia Magdala be Jems gabu Josep tinas Malia sulu ile ve invail Yisu ane umbub. ");
INSERT INTO kbm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Be seukie-ngge gikuri ges bamo molge be Pomate ane ngalau kulkul ane ti gisov nangge gulumb ginme be gidugdug vat bamo ebe giengk giwei Yisu ane umbub dobo ok gikwai be gibweg giwei vat bamo nok. ");
INSERT INTO kbm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pomate ane ngalau kulkul ane nok utle ulis ringenk weik ebe bilip geb be ringenk ok, be ane kup bogbogo molge. ");
INSERT INTO kbm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Be amolmol valir ane ebe emb Yisu ane umbub dabin ok ikuri vunu-ngge love dalgos givang be imbieg ile itak nalk be iengk weik ebe gen gimat ok. ");
INSERT INTO kbm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Be angela galkok ginei yaun gitangi avie ailu ebok be ginei, “Gabu unpelk bwaya. Ayeu ande gatpweng are gikwai ve yemlu urek Yisu Nasaret ane ebe warik amolmol valir ane es ei gireu ei-givsangin ok. ");
INSERT INTO kbm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bemem ei giengk etenik ite, ei ande matawe be gimdil vukuri dang ebe warik ginei gitangi ane singamolomb-gen ok. Tau gabu unme be undi lavo ebe Josep gitak ei giengk ok okob.” ");
INSERT INTO kbm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bekob angela ginei gitangi sulu, “Gabu seukie unde be unei nitangi Yisu ane singamolomb-gen unei Yisu ande matawe be gimdil vukuri nangge taku gimat ane. Be atob ei nimungg nile Galilaia ok bekob yem, be atob undi ei nangge eteok. Yaun nok ete ande ayeu ganei gitangi yemlu nok.” ");
INSERT INTO kbm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Be Malia Magdala be Jems gabu Josep tinas Malia, sulu ipelk anongge be ile ihlang ikwai taku gimat ane seukie-ngge bemem sulu tas vevias ge be gabu ituvki ge ile ve inei yaun lavo nitangi Yisu ane singamolomb-gen. ");
INSERT INTO kbm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Be seukie-ngge Yisu gile vunge ve sulu nangge luev be ginei, “Gabu atengg-aim ireu bwaya!” Be sulu ile imbloblo Yisu be bais gile emb Yisu va ta be gabu iro vas dubi supwe gisov nalk gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Be Yisu ginei gitangi sulu “Gabu unpelk bwaya be unde be unei nitangi awangg singamolomb-gen be unei inde Galilaia ok, okob atob indi ayeu nangge eteok.” ");
INSERT INTO kbm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Malia Magdala be Jems gabu Josep tinas Malia ivang nangge be amolmol valir ane ebe emb Yisu ane umbub dabin ok imungg ile imbielk nam be inei gen bambamo ete meng-gihlang nangge taku gimat ane ok binge gitangi bambamo ebe emb lum mateu ane dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Be bambamo ebe emb lum mateu ane dabin ok be tis eisir ebe ipas-pasang amolmol as yaun ok iro isate sut be inei yaun gisov dongke ve inavgo amolmol valir ane ebe emb Yisu ane umbub dabin ok ve mone bamo molge, ");
INSERT INTO kbm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","be inei gitangi eisir ebe emb Yisu ane umbub dabin ok ve inei nitangi amolmol dang eteik inei, “Amei ayengk be ali ite be Yisu ane singamolomb-gen inme be ivaina ei utle ulis givin tambok.” ");
INSERT INTO kbm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Be ginei amol bamo ebe geb eitit dabin ok niute yaun etenik nivin, okob amei gitangi ebe atob analgum ei aplo bwaibwaya ok, be yem atob unvang vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Amolmol valir ane ebe emb Yisu ane umbub dabin ok ivwat mone etok be ile be ilgum yaun ebe galkik amolmol bambamo inei gitangi eisir ok ano gile. Beti galkik as-mate etenik yaun bingkasop etok geb taku avut nangge Juda as taku. ");
INSERT INTO kbm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Amei singamolomb 11 etok amdil ale Galilaia be areu matendubi ebe warik Yisu ginei gitangi amei yapin ok ale. ");
INSERT INTO kbm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Be givin ebe amei ali Yisu ok be ale aro vangg-amei dubi supwe gisov nalk gitangi Ei, bemem amei aplongg-amei ailu ailu. ");
INSERT INTO kbm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Be Yisu ginme gibloblo amei be ginei, “Tamangg geb ane gwang-ne gitangi ayeu ve namb gulumb tis nalk dabin. ");
INSERT INTO kbm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dangetok be unde be unro awangg amolmol tepwengge sut nangge taku walang ok be unes bui sanggu nipil eisir ve eilu Tamangg be Ngalau Yamar arengg-amei. ");
INSERT INTO kbm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Be unbul eisir be unei invang mul ve yaun walang ete ayeu ganei gitangi yem ok. Be unaute. Ayeu atob navang navin yem dang-etok love nalk tis gulumb ane den ma ge.” ");
INSERT INTO kbm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kapia etenik ginei Pomate Natu Yisu Kilisi ane kulkul be tis ane yaun binge vie lavo. ");
INSERT INTO kbm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Warik Pomate ane amol yaun ane ti are Aisaia, ei giro yaun ebe Pomate ginei gipil Jon ok dang-eteik ginei; Pomate ginei: ‘Atob ayeu namb angg amol ti nimungg ve mie be ninei binge nitangi amolmol. Ei atob nimungg ve nipasang miam luev yapin. ");
INSERT INTO kbm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Amol nok atob nital yaun nangge taku sawa, be atob nital dang-etok ninei, Unpasang Amol Bamo ane luev ebe ve nivang ok vevie!’ ");
INSERT INTO kbm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bwayage kob Jon ei ate meng-gihlang nangge taku sawa, taku etok amolmol ti gibweg ite ma. Ei ginei yaun giengk gitip ge gitangi amolmol be ginei, “Unavkir dumangg-aim nitangi gen tiate be unro aim ate vukir be unringk bui sanggu, veik Pomate nisin yem aim tiate nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Be amolmol anongge nangge ete Juda as taku ok be nangge nam bamo Jerusalem itangi Jon ile be inei as tiate binge gitangi ei, bekob ges bui sanggu gipil eisir nangge bui Joldan. ");
INSERT INTO kbm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ane babal tis kup bwelk kamel buplu, be gibiti bika bwelk ulis gibagi luvwe pale be gen sapauk tis munei tine sangas ane ve ane ben. ");
INSERT INTO kbm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Be ginei yaun ve amolmol be ginei; “Amol ti atob nitau nile ayeu be ninme. Amol nok ane gwang-ne gitlek ayeu angg. Be ayeu gasov ei ane lu. ");
INSERT INTO kbm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ayeu gas bui sanggu gipil yem ve bui sin ge, bemem amol etok atob nemb Ngalau Yamar nitangi yem.” ");
INSERT INTO kbm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Givin sawa etok Yisu nangge Nasaret gideb Galilaia ane be gitangi Jon gile ve Jon nes bui sanggu nipil ei nangge bui Joldan. ");
INSERT INTO kbm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yisu gipil gikwai bui love gili gulumb ponge be Ngalau Yamar geb na gile mank bubu be gisov menggiwei ei. ");
INSERT INTO kbm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Be yaun ti ginme nangge Pomate avo nangge gulumb dang-eteik, “Ayeu Natungg mie ebe gali mie vie be tangg givin mie anongge ok.” ");
INSERT INTO kbm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Manang ite be Ngalau Yamar gitwem Yisu gile taku sawa avuavu sin-ge ti bui ma be ei ma. ");
INSERT INTO kbm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yisu givang taku sawa etok gitangi as 40, be Sadam ane kulkul ve gitpungi ei. Yisu givang givin bwelk kusing bemem angela emb ei dabin. ");
INSERT INTO kbm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Amol bamo Herodes ginei be ane amolmol valir ane itak Jon gibweg kapual-lu gikwai bekob ete Yisu gimdil gile Galilaia be geb kulkul ve ginei Pomate ane binge vie (mateu) gitangi amolmol be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Galkik etenik ande gibloblo ve Pomate nemb amolmol dabin, be unro aim ate vukir unkwai gen tiate, be aplongg-aim nivin binge vie.” ");
INSERT INTO kbm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisu givang gito givin bui kapul Galilaia ane kire ge ve gile be gili Saimon gabu male Endru itak wasang ivang ve sulu isgabu amol wenk ane. ");
INSERT INTO kbm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Be Yisu ginei gitangi sulu, “Gabu unme be unvang mul ve ayeu. Be atob ayeu nambul yemlu ve unro amolmol sut dangete uro wenk sut gisov wasang ok.” ");
INSERT INTO kbm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sulu imdil ikwai as wasang be giengk em giengk be gabu ivang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yisu givang kasop gege gile be gili Sebedi bamo natu-nggen Jems gabu male Jon. Sulu imbweg as ei-vovo ve iyumi as wasang imbweg. ");
INSERT INTO kbm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Be Yisu ginei gitangi sulu, ve ginei gabu inde be invang mul ve ei. Beti sulu imdil ikwai tamas Sebedi bamo tis ane amolmol kulkul ane, be gabu ile ivang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nangge etok be ile ihlang Kapanaum. Be givin Sonda Sabat Yisu gisov lum mateu ane aplo gile be ginei mateu ve amolmol givang. ");
INSERT INTO kbm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ei ginei mateu givang be amolmol iute love ikuri vunungge ve ei ane yaun ebe ginei ginei ok ane. Ve ei gibul eisir weik ebe Juda as gidung subu ok ite ma, ei gibul eisir tis Pomate ane gwang-ne ge. ");
INSERT INTO kbm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Givin sawa etok amol ti ebe ngalau tiate givang givin ei ok gibweg lum aplo givin ve giute giute yaun ebe Yisu ginei ginei ok. Ngalau tiate etok gilgum amol nok be gital yaun avo bamo ge be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yisu Nasaret ane, mie gunme ve nulgum ret nitangi amei? Mie gunme ve nos amei me? Ayeu gatpweng mie are ganei mie Pomate ane amol yamar.” ");
INSERT INTO kbm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Be Yisu ginei gitangi ngalau tiate etok be ginei, “Kamoke be unde unahlang nukwai amol etenok.” ");
INSERT INTO kbm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ngalau tiate etok gilgum amol nok tiate molge be yayai avo bamo ge be gile gihlang gikwai ei. ");
INSERT INTO kbm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Amolmol tepwengge ili be ikuri vunungge be inei ve isate, “Gen ret dang-etenik? Etek wat yaun vaku ti me? Amol etenik ane gwang-ne gitlek ngalau tiate, beti ei ginei yaun ge gitangi ngalau tiate be iute ei avo ge.” ");
INSERT INTO kbm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Be Yisu ane binge geb taku avut nangge Galilaia. ");
INSERT INTO kbm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Eisir ile ihlang ikwai nam mateu ane be tepwe tis Jems gabu Jon ok ile ipil Saimon gabu Endru as nam. ");
INSERT INTO kbm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Be Saimon lawavie gimat utle vavane bamo molge be giengk. Amolmol iute ebe Yisu ande ginme ok binge be ile inei gimat nok binge gitangi ei. ");
INSERT INTO kbm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yisu gitangi ei gile be geb ei gibweg bage be girun ei itin ve ginei nimdil be nimbweg. Be seukie-ngge gimat vavavne bamo etok gihlang gikwai ei bekob ete geb kulkul ve gipasang eisir as ben. ");
INSERT INTO kbm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Givin gibok as gile gisov okob amolmol inggas eisir ebe tis gimat ok be tis amolmol ebe ngalau tiate givang givin is ok, itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Amolmol nam dabe etok ane iro isate sut ile ivarkei nam avo. ");
INSERT INTO kbm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Be Yisu gilgum eisir ebe tis gimat walang ano ok be utlas vie vukuri, be gitin ngalau tiate gikwai amolmol ebe ngalau tiate givang givin is ok givin. Ngalau tiate nok ande itpweng Yisu are gikwai, beti Yisu geb yaun gwang-ne gitangi eisir ve ginei inei yaun ti bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Givin tistumi-ngge Yisu gimdil be gile taku sawa ti ebe amolmol ma ok ve nes miengk. ");
INSERT INTO kbm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Be Saimon tis ane sukus-gen imdil be irek ei. ");
INSERT INTO kbm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eisir ile vunge ve Yisu be inei gitangi ei, “Amolmol iutau-tani mie giriv be gira anongge.” ");
INSERT INTO kbm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Be Yisu giwel eisir avos be ginei, “Nangg-aim vier. Be eitit tande ete nam dabe eteok subu nivin be Ayeu nanei Pomate ane yaun nitangi eisir nivin, ve ayeu ganme ve kulkul etenik ane.” ");
INSERT INTO kbm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yisu givang geb taku avwut nangge Galili be ginei mateu ve amolmol nangge as lum mateu ane aplo gitang-tangi ge givang, be gitin ngalau tiate gikwai amolmol ebe ngalau tiate givang givin is ok. ");
INSERT INTO kbm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","As-mate ti amol tis bid namvu ti gitangi Yisu gile be giro va dubi supwe gisov nalk be ginei gitangi Yisu. “Ginei mie tam givin kob nulgum ayeu utlangg ulis be vie vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yisu ta viti ve ei be gitak bage giwei ei be ginei, “Ayeu tangg givin ve nalgum mie be utlem vie vukuri. Be ande ayeu galgum mie utlem be vie gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Be seukie-ngge gimat bid namvu tiate etok ge ulur gikwai amol nok be givang vie. ");
INSERT INTO kbm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yisu ges bing ve ei gikwai, bekob amol nok ve nivang ane be Yisu geb yaun gwang-ne gitangi ei be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Uli ve nule be nunei gen bamo etenik nitangi amolmol ti be ti ite. Mie nuvang roro-ngge nutangi amol bamo ebe geb kulkul da ane ok nule be nos imate ru nitangi ei, bekob nomb am da utlem vie ane nitangi Pomate dang-ebe Mose ginei ve yem unalgum ok. Bekob atob amolmol inatpweng are inei ande miam gimat ma gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bemem amol nok gile be ginei gen etok binge gitangi amolmol, ve ande Yisu gilgum ei be utle vie vukuri. Ei ginei yaun etok gitangi amolmol tepwengge be iute love geb taku avwut. Beti Yisu gitangi ebe ve nile nam dabe subu be nivang ao-nmolmol nas dang-ebe warik gilgum gilgum ok ite ma. Ei givang taku bage bage ane ge ebe amolmol ma ok, bekob amolmol nangge taku walang ok iro isate sut itangi ei ile. ");
INSERT INTO kbm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","As-mate subu gile gikwai kob Yisu ginumul gile Kapenaum vukuri. Be amolmol anongge iute ebe ande Yisu gibiek ok binge, ");
INSERT INTO kbm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","beti iro is ate sut isov nam aplo ile love sawa mamolge be ivarkei meidbul sagin dume ane givin be Yisu ginei mateu gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Be amol aivat inggas amol gimat ti giengk giwei ane yemb be itangi Yisu ile. Amol nok gigas gimat va be bage dubi giru bingbleng be giengk ge. ");
INSERT INTO kbm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nam aplo gingik ve amolmol anongge be luev ma ebe sotol in-gas ei insov inde inambloblo Yisu ok. Beti sotol ireu ile nam dobo be emb ark ponge gitangi ete Yisu givarkei ok bekob itu amol gimat nok tis ane yemb ge gisov gitangi Yisu gile. ");
INSERT INTO kbm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yisu gili sotol be gitpweng are ginei sotol aplos givin ei anongge. Beti Yisu ginei gitangi amol gimat etok be ginei; “Ande ayeu gasin miam gen tiate tepwengge gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gidung subu ebe emb Mose ane yaun dabin ok imbweg ivin be iute yaun ete Yisu ginei ok be tas vavis anongge be tas gitung giengk aplos ge inei; ");
INSERT INTO kbm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Amol etenik wat ve ninei yaun bing kasop me? Amol ti gitangi ebe nisin amolmol as tiate nikwai ok ite, Pomate ei dongke-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bemem Yisu ande gitpweng yaun ete eisir tas gitung ok are gikwai be ginei gitangi eisir be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Ginei ayeu nanei ve yaun ge nitangi amol gimat etenik be nanei, ‘Umdil be uvwat am yemb be uvang,’ bemem ginei awangg yaun etok ano ma, atob ayeu mai-mayangg anongge. Bemem ginei ayeu nanei ‘Ande ayeu gasin miam gen tiate gikwai,’ be awangg yaun etok ano gile ite, atob ayeu mai-mayangg ite ve amolmol gitangi ebe atob indi gen etok ane ano be inatpweng are ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bemem ayeu tangg givin ve ganei yem unatpweng gen etok are kob. Ve Pomate Natu Ayeu, awangg gwang-ne gitangi ebe nilgum gen bamo ti dang etenik ok.” Bekob Yisu ginei gitangi amol gimat bage be va dubi mwaimwai nok be ginei. ");
INSERT INTO kbm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ayeu nanei ve mie, Umdil be uvwat am yemb be uvang am nam ane.” ");
INSERT INTO kbm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Amol nok gimdil be gimwal ane yemb givarkei amolmol tepwengge nas be givang gikwai. Amolmol tepwengge ili be ikuri vunungge be avos givwat Pomate be inei, “Eitit tali gen ti dang etenik ite ebe warik.” ");
INSERT INTO kbm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yisu ginumul gile bui kapul vukuri be amolmol dubi bamo ti itangi ei ile be Yisu gibul eisir ve Pomate ane yaun. ");
INSERT INTO kbm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yisu givang gile be gili Alapai natu Liwi ebe geb kulkul takes ane ok gibweg ane nam aplo kulkul ane. Be Yisu ginei gitangi ei, “Utau ile ayeu.” Liwi gimdil be givang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bwayage kob Yisu tis ane singamolomb-gen en ben nangge Liwi nok ane nam. Be amolmol ebe emb kulkul takes ane be iyo iyo amolmol be inggas as mone subu sinsin ge givin ok be tis amolmol tiate ane dubi bamo ivang mul ve Yisu ile. Eisir nok as amolmol subu ile imbweg ivin Yisu tis ane nune-ngge be tepwe en ben gisov dongke. ");
INSERT INTO kbm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bekob gidung Parisai ane subu ebe emb Mose ane yaun dabin ok, ili ebe Yisu gen ben givin amolmol tiate ane be tis eisir takes ane ebe iyo iyo amolmol be inggas as mone subu sinsin ge ok, bmem ei gilgum gen gitangi ebe Juda as luev ite ok. Beti ile iutani Yisu ane singamolomb-gen be inei, “Nam-nambed be ei gile gibweg be gen ben givin amolmol tiate ane bambamo etok be tis eisir takes ane ebe inggas amolmol as mone subu sinsin ge givin ok?” ");
INSERT INTO kbm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yisu giute yaun etok be giwel eisir avos be ginei; “Amolmol ebe utlas vie ok tas givin dokta ite ma. Amolmol ebe tis gimat ok ge ete tas givin dokta. Ayeu ganme ve amolmol ebe tas gitung inei eisir amolmol vie ane ok ite, ayeu ganme ve amolmol ebe itpweng are inei eisir tiate ane ok.” ");
INSERT INTO kbm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","As-mate ti Jon ane singamolomb-gen ebe imbul Pomate ane yaun gitang-tangi amolmol ok, be tis Parisai subu iyamar ben. Bekob amolmol ebe ok subu itangi Yisu ile be iutani ei be inei; “Nam-nambed be Jon ane singamolomb-gen be tis Parisai subu iyamar ben, be miam singamolomb-gen ilgum ite?” ");
INSERT INTO kbm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Be Yisu giwel eisir avos be ginei, “Ginei ayeu nambweg navin angg amolmol-gen atob eisir aplos bunam ite, ");
INSERT INTO kbm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","bemem ginei ayeu navang nakwai eisir, kob atob eisir aplos bunam. ");
INSERT INTO kbm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Amol ti gitangi nivwat waingg mwanggane ti be nidgin ane eivovo vaku ti ok ite. Ginei ei gilgum atob wavin ane tine niyuki eivovo etok okob atob waingg niti-titip. ");
INSERT INTO kbm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","(Be galkik etek amol ti gitangi nisov Pomate ane taku nile tis ane tiate ge ite. Ei niro ate vukir be menihlang weik nunus muele ok okob.)” ");
INSERT INTO kbm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sonda ti Yisu tis ane singamolomb-gen ilauk ivang um aplo love marav ges is be ile ipis yanggo be en. ");
INSERT INTO kbm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Be Parisai subu ili be ile inei gitangi Yisu be inei; “Miam singamolomb-gen ilgum gen gitangi ebe ve tanalgum nivin Sonda Sabat ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yisu giwel eisir avos be ginei, “Yem uvnawi (usam) yaun ebe Dawit gilgum ve tis ane amolmol-gen marav ges is be ilgum ok gikwai me ma? Ve givin sawa etok amol bamo ebe geb eisir da ane tepwengge dabin ok are Abiata gibweg ge. ");
INSERT INTO kbm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Be Dawit gisov Pomate ane nam mateu ane aplo gile be givwat ben ebe emb ve da gitangi Pomate ok gile be geb gitangi ane amolmol-gen be tepwe en. Be ben etok gitangi ebe atob amolmol ebeok sinsin inen ok ite ma. Amolmol ebe emb kulkul da ane nangge lum yamar ok ge gitangi inen ben ete emb ve da ok.” ");
INSERT INTO kbm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Be Yisu ginei gitangi eisir vukuri be ginei; “Pomate gitak as-mate ete Sonda ok gile givarkei be geb gitangi amolmol veik amolmol inambweg be inyap. Be amolmol eisir gen vie molge gitlek as-mate ete Sonda ok. ");
INSERT INTO kbm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Be Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, ete Sonda ane tivie ayeu givin.” ");
INSERT INTO kbm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisu gisov lum mateu ane aplo gile vukuri be amol ti ebe bage tavlu tiate (gimat) ok gisov lum aplo givin gile gibweg. ");
INSERT INTO kbm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Be Amolmol anongge ilgum ve indi velob Yisu nilgum amol nok bage be vie vukuri tis Sonda me ma. Eisir ilgum etok ve gisov eisir irek luev ebe ve inemb Yisu ta ok. ");
INSERT INTO kbm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yisu ginei gitangi amol ebe bage tiate ok be ginei, “Umdil be unme uvarkei ebe mate ane ik.” ");
INSERT INTO kbm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bekob Yisu giutani amolmol be ginei, “Eitit taute yaun ret givin Sonda? Tanalgum gen vie me tanalgum gen tiate tis Sonda? Tanpasang amolmol me tanes amolmol vunkunu?” Bemem eisir inei yaun ti ite. ");
INSERT INTO kbm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yisu ta vavis be gitlo eisir giwei giwei, be gili ebe iute yaun siti ite ok be ta viti ve is anongge. Bekob ginei gitangi amol bage tiate ebok be ginei, “Uto bagem!” Ei gito bage be seukie-ngge bage vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisai ili be imdil ile ihlang ikwai lum aplo be ile ivin Herodes ane amolmol subu, be kakie gipil luev ebe ve ines Yisu vunu ok. ");
INSERT INTO kbm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisu tis ane singamolomb-gen ikwai nam etok be ivang bui kapul Galilaia ane be amolmol anongge itaumul ei be ile. Eisir nok nangge Galilaia be nangge Juda, ");
INSERT INTO kbm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","be Jerusalem tis Idumia, be nangge bui Joldan tavlu ane, be Taia tis Saidon as nam dabe subu givin. Eisir iute gen ebe Yisu gilgum ok binge, beti itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yisu gilgum amolmol anongge utlas vie vukuri be eisir ebe gimat gitun is tiate tiate molge ok isu isate itangi Yisu ile ve bais nile ei. Beti Yisu ginei gitangi ane singamolomb-gen ve indi eivovo ti be insu ei tis eivovo nok nile nivwev aikawe nikwai alus veik amolmol inde insung-sungi ei ge bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Be amolmol ebe ngalau tiate ivang ivin is ok ili Yisu be ikari is ate ile itak itak nalk gideb Yisu na ane be yayai be ital yaun avos bambamo-ngge be inei, “Pomate ane Natu mie.” ");
INSERT INTO kbm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Beti Yisu geb yaun gwang-ne molge gitangi ngalau tiates nok ve ginei intal ei are vusa bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bekob Yisu gireu matendubi ti gile be gital eisir 12 ebe ei tang givin ve inalgum ei ane kulkul ok, be itangi ei ile. ");
INSERT INTO kbm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yisu geb amolmol 12 etok ile ivarei bekob ginei gitangi eisir be ginei; “Ayeu gab yem ve unemb kulkul unvin ayeu, be atob ayeu naro yem ta be unbul amolmol ve Pomate ane yaun (mateu). ");
INSERT INTO kbm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Be atob ayeu namb gwang-ne nitangi yem ve unaitin ngalau tiates nikwai amolmol nivin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yisu geb ane singamolomb-gen 12 etok be gital ares ginei Aposel. Be eisir nok ares eteik: Saimon, (be Yisu gital are ti Pita), ");
INSERT INTO kbm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","be Sebedi natu-nggen Jems gabu Jon. (Be Yisu gital sulu ares ti ginei Boanesis weik walpap, ve sulu ivang be avos bambamo sinsin ge). ");
INSERT INTO kbm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Be Endru gabu Pilip, be Batolomai gabu Matai, Tomas gabu Alapai natu Jems be Tadai gabu Saimon. ");
INSERT INTO kbm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Be Judas Iskariot ebe asonge nitak Yisu nisov amolmol valir ane bais ok. ");
INSERT INTO kbm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisu ginumul gile ane nam ebe giengk ok vukuri be amolmol anongge iro isate sut ile ipil dongke vukuri. Be Yisu tis ane singamolomb-gen ve inen ben bemem sawa ma molge. ");
INSERT INTO kbm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Beti Yisu tine be tis male-nggen iute yaun etok be inme ve inggas ei, ve amolmol inei dang-etok inei gen ti wat gilgum ei. ");
INSERT INTO kbm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gidung subu ebe emb Mose ane yaun dabin ok nangge Jerusalem inme be inei Belsebul givang givin Yisu. Belsebul etok Sadam are ti be ei ngalau tiate as tamas. ");
INSERT INTO kbm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Beti Yisu gital amolmol be itangi ei ile be ginei ve bingai gitangi eisir be ginei; “Sadam gitangi ebe nitin ei ate ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Be nam dabe ti ginei inemb isate vusa be ines isate atob amolmol inambweg vie ite. ");
INSERT INTO kbm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Eisir vu ti ginei inemb isate vusa atob inambweg vie ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Be ginei Sadam ane amolmol-gen ok ines valir nitangi isate be inemb isate vusa nile dubi ailu, atob eisir indi isate weik eisir vu dongke ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Amol ti gitangi nisov amol lai ti ane nam aplo nile be nivwat amol etok ane wambal nikwai ite. Ei nidgin amol lai etok ta nikwai okob atob nisov amol nok ane nam aplo nile be nivwat ei ane wambal nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Bingano, Ayeu nanei bingano-ngge nitangi yem. Pomate atob nisin amolmol as tiate ebe ilgum be inei ok nikwai, ");
INSERT INTO kbm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","bemem amolmol ebe ital Sadam are gipil Pomate ane Ngalau Yamar ok, ete Pomate atob nisin eisir as tiate etok nikwai ite ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisu ginei yaun etok gitangi eisir, ve gisov gidung subu ebe emb Mose ane yaun dabin ok inei Yisu gitin ngalau tiate gikwai amolmol ve Sadam ane gwang-ne. ");
INSERT INTO kbm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yisu tine be tis male-nggen ile ve indi ei be ivarkei ebe sagin dume ok ge be emb yaun gile ve Yisu. Eisir tas givin ve Yisu ninme nile eisir kob. ");
INSERT INTO kbm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Amolmol anongge imbweg meidbul Yisu love sawa ma molge. Bekob ete amol ti ginei gitangi Yisu be ginei, “Tinem be tis am male-nggen ete ande inme ok ve indi mie, be ete ivarkei sagin dume ivarkei ok.” ");
INSERT INTO kbm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Be Yisu ginei gitangi amolmol tepwengge be ginei, “Ayeu anei angg bambamo-nggen lavo itangi yem be unaute kob.” ");
INSERT INTO kbm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yisu na giro amolmol bambamo ebe imbweg meidbul ei ok ta be ginei, “Awangg bambamo-nggen yem nok ete tepwengge etenik. ");
INSERT INTO kbm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Amolmol ebe tas givin Pomate ane yaun be ilgum ei ane kulkul ok, eisir etok ete awangg bambamo-nggen.” ");
INSERT INTO kbm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kob Yisu gilumul gile be gibul amolmol vukuri gibweg alus den gibloblo bui kapul Galilaia vukuri, be amolmol anongge molge iro isate sut itangi ei ile love ivarkei ile isung-sungi ei ge. Beti Yisu gipil eivovo ti gile gibweg be isu ei tis eivovo nok gile givwev aikawe kasop gege gikwai alus, be amolmol tepwengge ivarkei ebe alus ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yisu geb yaun anongge gitangi eisir be ginei gipil bingai ge be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Unaute kob. Amol ti gile ve nindawi ben uve nangge ane um. ");
INSERT INTO kbm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ei gidawi givang be subu beleinge gisov luev be mank inme be en gikwai, ");
INSERT INTO kbm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","be ben uve subu gisov nalk tis vat, be nalk etok sisi ma, be ben gireu bemem wakas gisov nalk aplo gile ite. ");
INSERT INTO kbm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Be givin ebe as gwang-ne givse taku ok be as ges love ainggwen be gimat. ");
INSERT INTO kbm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Be subu gisov vwavwe aplo be vwavwe gireu love ges vunu be ben ges ano ite. ");
INSERT INTO kbm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Be subu gisov nalk vie be gireu love ges ano vevies ge. Subu ges ano 30, be subu ges gitangi 60, be subu ges ano gitangi 100.” ");
INSERT INTO kbm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yisu ginei gitangi eisir; “Ginei talngangg-aim avo giengk okob unaute vevie.” ");
INSERT INTO kbm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Givin ebe Yisu ge givang ane atane-ngge ok, okob ete ane singamolomb-gen tis amolmol ebe ivang ivin ei ok itangi ei ile be iutani bingai nok ane dabe. ");
INSERT INTO kbm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Beti Yisu ginei gitangi eisir be ginei, “Pomate ges ane kulkul ebe geb yem dabin ok ru gitangi yem gikwai, bemem amolmol ebe isov Pomate ane yaun ane lu ite ok, ete iute denang ebe bingai sin-gege ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Eisir ok ili be iute, bemem itpweng gen ti are ite. Dang-etok be ginei eisir inro isate vukir ite, atob Pomate nisin eisir as gen tiate ebe ilgum ok nikwai ite ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bekob Yisu giutani eisir be ginei; “Yem utpweng bingai etok ane dabe are ite, be wali atob unatpweng bingai subu ane dabe are nam-nambed? ");
INSERT INTO kbm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Unaute. Amol ebe gidawi ben uve ok ei gidawi Pomate ane mateu. ");
INSERT INTO kbm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Be ben uve ebe gisov luev ok, ete weik amolmol ebe iute Pomate ane yaun, bemem itak giengk aplos ite be givin ebe iute mateu ok Sadam ginme be girwel gikwai eisir aplos painge ge ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Be amolmol subu ete weik ben uve ebe gisov nalk tis vat ok. Eisir iute mateu be tas vevias ge, ");
INSERT INTO kbm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bemem yaun etok eisir itak giengk aplos ite ma, ve ginei gen bunam ti me amol ti ginei ninggo eisir ve Pomate ane mateu ane, atob eisir inavkir dumas nitangi Pomate seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Be ben uve ebe gisov vwavwe aplo ok ete weik amolmol ebe iute Pomate ane mateu ");
INSERT INTO kbm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bemem gen nalk ane geb eisir aplos avut be tas gitung mone be tas gitung gen utlas ulis ane gitlek molge ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Be amolmol ebe iute mateu be ipasang giengk aplos be tas givin ve inalgum ano nile ok, ete weik ben uve ebe gisov nalk vie ok. Be ben etok ete ges ano subu gitangi 30, be subu ges gitangi 60, be subu ges gitangi 100. ");
INSERT INTO kbm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Be Yisu ginei bingai ti vukuri gitangi amolmol be ginei; “Yem utung lam be uvandung ve kilkiel ite ma. Yem uravi lam giengk gitip ge. ");
INSERT INTO kbm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Be gen walang ete giengk givwaivun ate ok, atob niengk nitip ge, be gen walang ebe idbwem ok atob menihlang. ");
INSERT INTO kbm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amolmol talngas-avo ginei giengk okob inaute vevie.” ");
INSERT INTO kbm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Be Yisu ginei; “Yaun ete yem ute nik tangg-aim nitung vevie-ngge. Ve gen ret ret ete yem ulgum gitangi amolmol subu ok, gen etok ge ete atob Pomate nilgum nitangi yem vukuri be atob ei nemb nitlek ete yem ulgum gitangi amolmol ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Amol ti ginei dabe gwet giengk atob nitpweng gen subu are nivin, be amol ti ginei dabe gwet ma atob nitpweng gen ti are ite molge.” ");
INSERT INTO kbm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Be Yisu ginei, “Amolmol ebe Pomate geb is dabin ok weik amol ebe gidawi ben uve nangge ane um ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ei giengk givin tambok, be as ei gimdil be givang. Be ben etok gireu love bamo be amol nok gitpweng are ite. ");
INSERT INTO kbm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nalk ei ate gilgum be ben gireu. Ben gireu aitine gimungg bekob vue gile bekob ete ano gile gikaiwel. ");
INSERT INTO kbm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ben etok ano be yu, okob um tivie atob nemb kulkul ve ninggas ane gen. ");
INSERT INTO kbm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisu ginei gitangi eisir be ginei; “Ayeu atob nanei yaun nipil amolmol ebe Pomate geb is dabin ok, be nanei nipil bingai ge. ");
INSERT INTO kbm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pomate geb amolmol dabin weik wer sivsiev ano ane vatu. Wer sivsiev ano ane vatu nok, ei gen natu molge gitangi gen subu vatu ite. ");
INSERT INTO kbm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bemem tanavro nisov nalk nile be bwayage kob atob nireu love bamo nitlek ben subu, bekob atob niro range nile be mank inde inalgum as niu nile be inambweg ane tulu.” ");
INSERT INTO kbm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisu ginei mateu gitangi amolmol be ginei gipil bingai anongge gitangi ebe ve eisir inatpweng are ok. ");
INSERT INTO kbm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ei ginei yaun ti ano vusa gitangi eisir ite ma, ginei gipil bingai ge. Bemem bwayage be tis ane singamolomb-gen ivang as sawa ge kob ete ei ginei yaun walang etok lavo gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Givin as-mate etok ane gibok Yisu ginei gitangi ane singamolomb-gen be ginei; “Eitit tanes gili tande tanpil bui kapul tavlu ane.” ");
INSERT INTO kbm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yisu tis ane singamolomb-gen ivang ikwai amolmol ebe ivarkei alus ok, be eivovo subu ivin eisir. ");
INSERT INTO kbm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Givin etok wavin givang be ane tine bamo molge, be bui gikari gisov eivovo aplo. ");
INSERT INTO kbm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Be Yisu ande gitak lopong be gisov be giengk ebe eivovo mul ok. Eisir singamolomb ile es ei itin be inei gitangi ei, “Mie guli ebe atob eitit tansov bui ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yisu gimdil be ginei ve avo ge gitangi wavin tis ngal be ginei; “Kamoke!” Be wavin gituvi be ngal gitak love bongong vie molge. ");
INSERT INTO kbm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bekob girau lili be ginei gitangi ane singamolomb-gen be ginei, “Yem upelk dang-etok ve ret ane? Yem wat aplongg-aim givin ayeu ano molge ite me?” ");
INSERT INTO kbm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eisir singamolomb ande dalgos givang be inei ve isate be inei; “Amol ret dang-etenik, ete wavin tis ngal ok be iute ei ane yaun ge nik?” ");
INSERT INTO kbm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","10","Yisu tis ane singamolomb-gen es bui kapul Galilaia gili ile isov Gerasa as taku. Be Yisu vepie nangge eivovo gile gitak alus love gile vunge ve amol ti ebe ngalau tiate givang givin ei ok. Amol nok ei amol lai ti be amolmol gitangi ebe inemb ei ta ok ite. As-mate walang ok amolmol idgin ei bage be va ta ve bidbid tis seng, bemem ei giati seng tis bidbid etok be ngalau tiate nok inggas ei be ivang taku gimat ane. Ei gibweg nam ta ite ma, ei gile ve givang matendubi dubi be tis taku gimat ane gigas ta-ngge, yayai be giure giure ate ve vat. Ei gili Yisu aikawe ge be gituvki gile be giro va dubi supwe gisov nalk gitangi Yisu. Be Yisu ginei gitangi ngalau tiate nok be ginei; “Unkwai amol etenok!” Be ngalau tiate nok ti gital yaun avo bamo-ngge ginei, “Yisu, mie Pomate ane Natu. Mie ve nulgum ret nitangi ayeu? Ayeu nanei bingano-ngge nitangi mie nanei, uli ve nomb vavavne nitangi amei.” Be Yisu giutani amol nok be ginei; “Mie arem ret?” Be ngalau tiate etok ti ginei, “Amei arengg-amei amolmol anongge, ve amei walang molge ete avang avin amol etenik.” Be ngalau tiate etok as ti ginei gitangi Yisu, “Mie nuhlin amei be anvang ankwai taku etenik bwaya.” ");
INSERT INTO kbm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Be taku etok bwelk nam dubi bamo ti en rual ivarkei papte tavlu. ");
INSERT INTO kbm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Beti ngalau tiate nok ti ginei gitangi Yisu be ginei; “Mie nuhlin amei antangi bwelk eteok ande be anatwep eisir aplos ande.” ");
INSERT INTO kbm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Be Yisu ginei, “Unde!” Ngalau tiate nok meihlang ikwai amol etok be ile itwep bwelk bambamo etok aplos ile. Ngalau tiate nok ilgum bwelk bambamo etok be ituvki isov matendubi ile love vepias isov bui be inum bui be imat vunu be ma. Bwelk nok tepwengge gitangi 2,000. ");
INSERT INTO kbm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Amolmol ebe emb bwelk bambamo etok dabin ok ituvki ile be inei binge gitangi amolmol nam ane be tis taku subu givin, beti amolmol anongge imdil be ile ve indi gen etok. ");
INSERT INTO kbm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Amolmol anongge itangi Yisu ile be ili amol ebe warik ngalau tiate givang givin ok ande gibweg kamoke be gino kup, be ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Be amolmol ebe ivarkei be ili gen etok givin ok inei lavo gitangi eisir ebe inme ve indi ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Beti eisir tepwengge ile inei yaun gwang-ne gitangi Yisu ve nikwai eisir as taku be nile ve nivang. Ve gisov ebe ei gilgum gen dang dang-etok ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yisu gile gipil eivovo be amol ebe warik ngalau tiate givang givin ok ginei gitangi Yisu be ginei; “Ayeu ve navin mie.” ");
INSERT INTO kbm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bemem Yisu ginei gitangi ei, “Ulumul ule am nam be nunei gen bamo ete Pomate ta viti ve mie be gilgum gitangi mie ok lavo itangi amolmol.” ");
INSERT INTO kbm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Beti amol nok gile be ginei gen bamo ete Yisu gilgum gitangi ei ok binge gitangi amolmol nangge nam bage isgabu. Amolmol tepwengge iute yaun etok love ikuri vunungge be yaun ok ma. ");
INSERT INTO kbm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisu gile gipil eivovo be ges bui gili gile gipil tavlu vukuri. Be amolmol anongge iro sut itangi ei ile, nangge ete bui kire ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bekob amol ti are Jairus, ei amol bamo ti ebe geb lum mateu ane dabin nangge nam etok ok, ginme be gili Yisu love gikari ate gile gitak Yisu va ane. ");
INSERT INTO kbm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Be ginei yaun gwang-ne molge gitangi Yisu be ginei; “Ayeu natungg avie gimat tiate molge be kasop gege atob nimat vunu. Dang-etok be unme tale be utak bagem iwei avie natu veik gimat etok ihlang ikwai ei be ivang vie.” ");
INSERT INTO kbm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Beti Yisu gimdil be gabu ile. Be amolmol anongge itau ile Yisu be ivang ile isung-sungi ei ge. ");
INSERT INTO kbm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Be avie ti ebe gigas gimat aiweng be giengk gitangi Sonda bamo 12, ");
INSERT INTO kbm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","be gikari ane mone tepwengge gipil amolmol marasin ane subu, bemem gimat etok ma ite, be gimat meng-gihlang bamo ge. ");
INSERT INTO kbm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Avie nok giute Yisu binge be gile givang gisov amolmol dubi bamo etok aplo be givang gile gisa ete Yisu dume mul ok ge. ");
INSERT INTO kbm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Be ta gitung, “Ginei ayeu natak baingg niwei Yisu utle ulis me ane kup ge, atob ayeu viangg vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ei bage gile geb Yisu ane kup be gimat etok gikwai ei seukie-ngge. Be ei gitpweng are ginei gimat etok ande gikwai ei. ");
INSERT INTO kbm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yisu ande gitpweng are ve ei ane gwang-ne subu ande gikwai ei be gile, beti givarkei va ta be giutani, “Amol ret bage gile geb awangg kup?” ");
INSERT INTO kbm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Be ane singamolomb-gen inei gitangi ei be inei, “Mie guli ebe amolmol anongge ile isung sungi mie-ngge ok ite me, beti gutani gunei ‘ret bage gile awangg kup?’ ");
INSERT INTO kbm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bemem Yisu na gitung amolmol vevie ve nili amol me avie ret ete bage gile ei ane kup ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Be avie ebe gilgum gen etok ok ande gitpweng ate are gikwai be givang tis ate gireu gireu ge gile be gikari ate gile gitak Yisu na ane, be ginei ane yaun tepwengge binge gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bekob ete Yisu ginei gitangi ei, “Mie aplom givin ano molge, beti gilgum be utlem vie, be nule tis aplom bwaibwaya be nuvang vie-ngge. Miam gimat ande ma gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisu ginei yaun gitangi avie nok ge nangge be amolmol subu nangge Jairus ane nam inme be inei gitangi Jairus, “Natum avie ande gimat vunu, be gen ti giengk ginei Yisu nile ite.” ");
INSERT INTO kbm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yisu giute eisir as yaun bemem geb gile mulane be ginei gitangi Jairus be ginei, “Nupelk bwaya be aplom nivin ge.” ");
INSERT INTO kbm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bekob ginei be amolmol tepwe imbueg be gigas Pita be Jems gabu male Jon ge invin ei be ile. ");
INSERT INTO kbm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eisir imbielk Jairus ane nam be Yisu gili ebe amolmol iteng be ilgum uye tangir bambamo ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yisu gisov gile be ginei gitangi eisir, “Yem ulgum tangir bwal bamo etenik ve ret ane? Avie natu etenik gimat vunu ite, etenik ei matano giengk beti giengk.” ");
INSERT INTO kbm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Be eisir imalk ve ei anongge, bekob ete gitin eisir tepwengge ile ihlang ikwai nam aplo, be gigas avie nok tine gabu tame ge be tis ane singamolomb gen aitol ebok be isov ile nam aplo itangi ebe gimat giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yisu gile geb avie natu nok gibweg bage be ginei, “Avie natu, umdil.” ");
INSERT INTO kbm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Avie natu pumue gimdil be gilauk givang ebe nam aplo ok. Be sotol singamolomb aitol ebok be tis gen nok tine gabu tame ili be ikuri vunungge. ");
INSERT INTO kbm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Be Yisu ginei gwangne ge gitangi sotol, “Ve ginei inei yaun ti nitangi amolmol subu bwaya. Bekob ginei gitangi avie natu tine ve nemb ben nile avie natu nen. ");
INSERT INTO kbm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisu gikwai taku etok be tis ane singamolomb-gen ivang ei ate ane nam Nasaret ane. ");
INSERT INTO kbm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Givin Sonda Yisu ginei Tame ane yaun (mateu) gitangi amolmol ebe imbweg lum mateu ane aplo ok be iute love ikuri vunu-ngge be inei. “Amol etek gigas yaun etenik nangge inend, be dabas-gwet ete ei gigas ok wali nangge? Be gen bwalbwale ete ei gilgum gilgum ok ane dabe namnambed? ");
INSERT INTO kbm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Amol etenik wat kapenda ti me, be tine ete Malia ok be male-nggen ete Jems gabu Josep be Judas gabu Saimon ok, be luvu avie gen ete ivang ivin eitit nik me?” Eisir tas gitung yaun dang-etok beti gilgum be bwais ve ret indi ei. ");
INSERT INTO kbm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Be Yisu ginei gitangi eisir be ginei, “Amolmol nangge nam dabe subu tas givin Pomate ane amol (propet) ebe ginei Pomate avo ukwas vusa ok, be iute ei ane yaun, bemem nangge amol etenik ane nam ei ane bambamo-nggen tas givin ei be iute ei ane yaun ite.” ");
INSERT INTO kbm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Beti Yisu bua ve ret nilgum gen bwalbwale subu nangge etok, bemem gitak bage giwei amolmol dongke dongke ebe tis gimat ok ge be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yisu gili eisir love aplo bunam molge, ve gili ebe aplos givin ite ok. Yisu givang gitangi nam dabe ge gile be gibul amolmol. ");
INSERT INTO kbm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bekob gital ane singamolomb gen 12 ebok itangi ei ile, be gihlin eisir ivang ailu ailu itangi nam dabe ge ile, Yisu geb ane gwang-ne gitangi eisir ve inaitin ngalau tiate nikwai amolmol, ");
INSERT INTO kbm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","be ginei gitangi eisir, “Unvwat gen subu nivin aim ate ite, ben ma, vak ma be mone ma, bemem unvwat aim kabut luev ane ge. ");
INSERT INTO kbm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Uno aim vangg-aim taptape (su) bemem uno kup ailu ailu ite, uno kup dongke dongke.” ");
INSERT INTO kbm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yisu ginei gitangi eisir givin be ginei; “Ginei yem umbielk nam ti be amolmol nam etok ane inei, ‘Unambweg etok,’ okob yem unambweg unvin eisir nitangi ebe ve unkwai nam etok ok. ");
INSERT INTO kbm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ginei yem umbielk nam dabe ti be amolmol inggas aim upil as nam ule ite, be iute yem aim yaun ite, okob unrau nangg-aim lili be guni nitangi eisir be kuku ninumul, be gen etok atob nes eisir as tiate ru nitangi eisir ate.” ");
INSERT INTO kbm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bekob ete eisir singamolomb imdil ivang gitangi ebe Yisu galkik ginei gitangi ok, ile be inei mateu gitangi amolmol veik amolmol inro isate vukir inkwai as tiate. ");
INSERT INTO kbm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Eisir singamolomb ile be itin ngalau tiate gikwai amolmol anongge, be es miengk be itak wel gipil amolmol ebe tis gimat ok dabas be ilgum eisir utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","29","Herodes gilgum gen gisov molge ve geb male Filip arue Herodias ponge. Beti Jon ebe ges bui gipil amolmol ok ginei gitangi Herodes nok be ginei, “Mie gulgum gen gisov molge ve gob am male Pilip ane avie ponge.” Beti Herodias ta vavis ve Jon be ve nes ei vunu, bemem Herodes ginei gitangi ite. Beti ginei be ane amolmol valir ane itak Jon gibweg kapual-lu ge ve Herodes gipelk ve Jon, ve Jon ei Pomate ane amol kulkul ane vie ti. Beti geb ei dabin be gibweg matawe. Herodes ta givin anongge ve niute Jon ane yaun ebe ginei ginei ok, bemem aplo bunam molge ve ei ate ane ve ei gili ginei ei amol tiate. Bwayage kob Herodes gilgum ben bamo ti ve ei ate ane aiweng ebe tine gikuv ok ane, be gital amolmol bambamo subu nangge Galilaia be inme ve inen ben etok. Be Herodias natu avie gile gihlang be ges uye be Herodes tis amolmol bambamo nok imbweg be ili ei ges uye vie molge be tas vevias anongge. Beti Herodes ginei gitangi ei be ginei, “Ginei mie tam givin awangg gen ti me tam givin ve nunggas awangg nalk tavlu atob ayeu namb nitangi mie.” Avie natu gituvki seukie-ngge gitangi tine gile be ginei, “Mie tam givin ve ayeu nanggas gen ret nangge Herodes?” Be tine ginei, “Ayeu tang givin ganei mie nunggas Jon ebe ges bui sanggu gipil amolmol ok dabe tulkwe.” Be avie natu gituvki gitangi Herodes gile be ginei, “Ayeu tang givin ve galkik etenik ge mie nomb Jon ebe ges bui sanggu gipil amolmol ok dabe tulkwe nisov bele taptape ti be nomb nitangi ayeu.” Herodes giute yaun etok be aplo bunam molge, bemem galkik ei gibiti yaun etok gimungg be amolmol bambamo iute gikwai, beti ei gili ma be gihlin ane amol valir ane ti gile be gidbwen Jon savwalo gili nangge nam kapual-lu ane, be gitak dabe tulkwe gisov bele taptape ti be givwat gile geb gitangi avie natu. Be avie natu givwat gile geb gitangi tine. Bwayage kob Jon ane singamolomb-gen iute ebe ei gimat vunu ok binge be inme ivwat ei utle ulis ile ispun nangge taku gimat ane. Be gideb mul ane kob ete amolmol subu iute ebe Yisu gilgum gen bambamo etok ok ane binge, be inei yaun gipil Yisu nok be inei Jon ebe ges bui sanggu gipil amolmol ok ande gimdil vukuri. Be amolmol subu inei etok Ilaija, be subu inei etok profet gimungg ane ti ebe warik ginei Pomate avo ukwas vusa ok. Yisu ane binge givang geb taku avut be Herot giute be ginei, “Etok Jon ebe ges bui sanggu gipil amolmol ok ebe warik awangg amol valir ane ti gidbwen ei savwalo gili ok bingano ge. Ete ande matawe be gimdil vukuri ok.” ");
INSERT INTO kbm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yisu ane singamolomb-gen inumul itangi ei ile be inei gen bambamo ebe eisir ilgum be imbul ok gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Be givin sawa etok molmol anongge itlek isate ilek be inme be Yisu tis ane singamolomb-gen ve inen ben bemem sawa ma molge. Beti Yisu ginei gitangi ane singamolomb-gen be ginei, “Unamdil be tale taku sawa ti ebe amolmol ma ok be unyap siti bekob.” ");
INSERT INTO kbm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Beti eisir ile ipil eivovo ti be ile ve ivang taku sawa ti atane-ngge. ");
INSERT INTO kbm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Amolmol ili eisir ebe ile ok be itpweng eisir are gikwai, beti amolmol nangge nam dabe walang ok ituvki ivang alus imungg ile imbeilk ve taku ebe Yisu tis ane singamolomb-gen atob inde insov ok gimungg. ");
INSERT INTO kbm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yisu gile gitak gikwai eivovo be gili amolmol dubi bamo etok love ta viti ve is anongge, ve gili eisir weik bwelk ebe tivias ma ok. Beti Yisu gibul eisir ve gen walang ano. ");
INSERT INTO kbm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","As gile ve nile nisov beti eisir singamolomb itangi Yisu ile be inei, “Ande gibok gikwai, be etenik taku sawa ete eitit tavang nik, ");
INSERT INTO kbm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","be me uli be uhlin eisir etenik inde nam dabe subu eteok be inavgo as ben bekob ma?” ");
INSERT INTO kbm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yisu giwel ane singamolomb-gen avos be ginei. “Yem ate kob undi eisir etenik ve ben ane.” Be eissir singamolomb inei, “Ginei K400 niengk ok bemem etok gitangi ebe atob amei anavgo ben ve amolmol dubi bamo etenik inen be nitangi ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Be Yisu giutani ane singamolomb-gen be ginei, “Unde be undi kob, unei yem ate aim ben siti giengk me ma?” Eisir ile ili gikwai be inme inei gitangi Yisu, “Ameimei ben siti be tis wenk ailu ete giengk ik.” ");
INSERT INTO kbm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Be kob Yisu ginei gitangi ane singamolomb-gen ve intak amolmol inambweg dubi atatane inwei taku dobo dobo. ");
INSERT INTO kbm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Amolmol imbweg tis dubi dubi, dubi ti ane amolmol gitangi 100, be subu gitangi 50. ");
INSERT INTO kbm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yisu geb ben siti tis wenk ailu etok be gidank be ges miengk gitangi Pomate. Bekob gible ben tis wenk etok vusvusa be geb gitangi ane singamolomb gen be imbwas gitangi amolmol tepwengge. ");
INSERT INTO kbm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amolmol tepwengge en ben etok love gibon is. ");
INSERT INTO kbm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bekob eisir singamolomb ivwat sab bage isgabu be ano ailu (12) be isbang ben be wenk dadanis ebe giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Amol gaptol ge ebe en ben etok ok gitangi 5,000. ");
INSERT INTO kbm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yisu gihlin ane singamolomb gen ve ginei inde inpil eivovo be ines bui gili inmungg inde insov Betsaida, be Yisu ei ate gibweg ve nihlin amolmol be invang inkwai kob. ");
INSERT INTO kbm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yisu gihlin amolmol tepwengge be ivang ikwai kob, ei gireu matendubi ti gile ve nes miengk. ");
INSERT INTO kbm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Givin gibok tumi eisir singamlomb ile love ande ile ivwev bui luvwe ge, be Yisu ei ate givarkei ebe alus ok. ");
INSERT INTO kbm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yisu gili ane singamolomb gen ebe wavin giro is ta tiate molge ok, be kavkavav giteng gikwai be gibloblo ve as bamo ane kob ete ei givang giwei bui dobo ge gitangi ane singamolomb gen gile be ve ve nitlek eisir. ");
INSERT INTO kbm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bemem eisir ili ei ebe givang giwei bui dobo ge ok be ipelk be yayai avos bambamo ge. ");
INSERT INTO kbm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Eisir tepwengge ili ei be inei bwat guk me taku ate, be ipelk be yayai anongge. Bekob ete Yisu geb avo ponge be ginei gitangi eisir be ginei, “Atengg-aim ireu be unpelk dangetok bwaya ve ebeik ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Be Yisu gile gipil eivovo ve ane singamolomb gen be wavin gituvi be bongong. Be eisir ikuri vunungge be avos poke-ngge imbweg. ");
INSERT INTO kbm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ve eisir aplos dadani molge, be itpweng ben tis wenk siti ebe Yisu geb be amolmol anongge en love gibon is vie-ngge ok are ite. ");
INSERT INTO kbm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yisu tis ane singamolomb gen es bui gili ile ipil Genesaret be idgin eivovo ta gikwai kob, ");
INSERT INTO kbm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ile itak ikwai eivovo be ile bemem amolmol tepwengge ande itpweng Yisu are seukiengge. ");
INSERT INTO kbm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Beti emb yaun gile ve taku walang ok be inggas amolmol ebe tis gimat ok giwei as yemb be itangi taku ebe iute Yisu gibweg ok ile. ");
INSERT INTO kbm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Be taku walang ete Yisu givang gile ok, amolmol itak eisir ebe tis gimat ok iengk itangi nam luvwe ge, be inei gitangi Yisu ve eisir ebe tis gimat ok bais nile ei utle ulis me ane kup den ge. Beti amolmol ebe bais gile emb Yisu ane kup ge ok, tepwengge utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisai be tis gidung subu ebe emb Mose ane yaun dabin ok nangge inme Jerusalem, be iro isate sut itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eisir ili Yisu ane singamolomb gen subu ebe ilgum gen gitangi ebe eisir ate as bambamo-nggen as luev ok ite, ");
INSERT INTO kbm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ve eisir ivuk bais ite be en ben. Ve Parisai be tis eisir Juda subu ivang mul ve as bambamo-nggen as luev painge ge ete ivang nik. ");
INSERT INTO kbm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Eisir en ben ite love ivuk bais gikwai okob, be ben ete ivgo nangge taku ben ane (maket) ok eisir ivuk okob en. Be ivang mul ve as bambamo-nggen as tumbu subu givin weik ivuk bele, kap, ul, be yemb. ");
INSERT INTO kbm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Beti Parisai be tis gidung yaun ane nok iutani Yisu be inei, “Namnambed be miam singamolomb gen itaugile ameimei bambamo nggen as tumbu ite, be ivuk bais kob ite be en ben?” ");
INSERT INTO kbm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yisu giwel eisir avos be ginei, “Warik Pomate ane amol ti ebe ginei Pomate avo ukwas vusa ok are Aisaia, ei giro yaun eteik gipil yem bingano molge ve, yem amolmol bingkasop ane roro. Ve Aisaia ginei dang eteik. ‘Eisir etenik avos givwat Pomate are ve giblus den ge be aplos giengk aikawe molge. ");
INSERT INTO kbm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eisir inei uye be inei mateu sinsin ge, be ivang mul ve as bambamo-nggen as tumbu, be iyo inei etenik Pomate ane luev.’ ");
INSERT INTO kbm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Be Yisu ginei gitangi eisir, “Yem bwaingg-aim ve Pomate ane luev be uvang mul ve luev ebe amolmol ipasang be itak ok.” ");
INSERT INTO kbm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Be Yisu ginei vukuri, “Yem tangg-aim givin anongge ve unvang mul ve amolmol ge as luev, be uitin Pomate ane luev. ");
INSERT INTO kbm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ve Mose ane ginei ginei dang eteik, ‘Nusov tamem gabu tinem as yaun ane lu ge, be amol ti ginei ninei yaun tiate nipil tine me tame atob bambamo ines amol etok vunu.’ ");
INSERT INTO kbm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bemem yem uro yaun etok vukir be unei, ‘Ginei amol ti ane gen subu giengk be ve nemb nitangi tine gabu tame, bemem atob amol etok ninei nitangi tinei gabu tame, ‘Gen eteik ande ayeu gab ve namb ve da nitangi Pomate.’ ");
INSERT INTO kbm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Okob atob amol etok niute tine gabu tame avos vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ke, yem ulgum gen dang dang-etok, beti uvang mul ve aim bambamo nggen as tumbu painge ge, be uli Pomate ane luev denang gen sin ge, be umbul amolmol ve yem ate aim tumbu be tis gen walang ebe ulgum ulgum ok.” ");
INSERT INTO kbm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yisu gital amolmol be iro sut itangi ei ile vukuri, be ginei yaun gitangi eisir be ginei, “Tepwengge unaute be unatpweng are! ");
INSERT INTO kbm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pomate gili ben ti ebe amolmol en be gilgum eisir tiate weik ete Parisai be tis eisir Juda subu as luev ginei ok ite ma. Bemem gen ebe amolmol tas gitung giengk aplos ok ete gilgum amolmol tiate. ");
INSERT INTO kbm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Ginei yem talngangg aim avo giengk okob inaute be unatpweng ane vevie!”) ");
INSERT INTO kbm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yisu gikwai amolmol be gisov nam aplo gile kob ete ane singamolomb-gen ile iutani ei ve bing-ai etok ane dabe ane. ");
INSERT INTO kbm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Be Yisu ginei gitangi ane singamolomb-gen ginei, “Namnambed be yem utpweng yaun etok are ite? Ben ti amolmol en be gilgum amolmol tiate ite ma, ");
INSERT INTO kbm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ve ben etok gisov amolmol subwas gile bekob gile gihlang vukuri.” “Ben tepwengge gitangi ve tanen.” ");
INSERT INTO kbm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Be Yisu ginei, “Gen ebe giengk amolmol aplos yapin ok ete gilgum amolmol tiate. ");
INSERT INTO kbm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ve nangge amolmol aplos eisir tas gitung gen tiate walang ano weik vaina, yaun bingkasop, es amolmol vunu, bwais ve aruasgen be emb avie gaptol vakuvaku, ivalval amolmol as gen, ihle amolmol, inei amolmol susweng, es luev wasi ane tas vavis, isov yaun ane lu ite, tas gitung gen tiate giengk aplos, be tis gen tiate subu givin. ");
INSERT INTO kbm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gen tiate bambamo etok ebe amolmol tas gitung giengk aplos ok ete gilgum amolmol be isov tiate aplo ile, beti Pomate gili gen etok tiate. ");
INSERT INTO kbm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisu gikwai nam etok be gile Taia as taku. Be gipil nam ti gile gibweg be gilgum ve ginei amolmol indi ei ru ebe gibweg etok ok bwaya, bemem gilgum be gitangi ite. ");
INSERT INTO kbm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Avie ti giute ebe Yisu gibweg nam etok ok binge beti givang gitangi Yisu gile. Avie nok ngalau tiate givang givin natu avie beti ei givang gitangi Yisu seukie-ngge gile be giro vandubi supwe gisov nalk gibloblo Yisu va. ");
INSERT INTO kbm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Be avie nok ei Juda ti ite, ei nangge Finisia gideb Siria ane. Ei giutani Yisu ve ginei nitin ngalau tiate nikwai ei natu avie. ");
INSERT INTO kbm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Beti Yisu ginei bingai ti gitangi ei be ginei, “Eitit tanavkwen nunus nimungg. Be gitangi ebe atob tanemb nunus as ben be uvun inen ok ite ma.” Yisu ginei bingai etok ane dabe dang-eteik. Eisir Juda in-gas Pomate ane yaun nimungg, be bwayage kob amolmol gitip ane in-gas ve mul. ");
INSERT INTO kbm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Be avie nok giwel Yisu avo be ginei, “Amol Bamo! Mie gunei bingano, bemem uvun subu ok en ben suksukus ebe nunus ilgum be bingbleng gile gitak nalk ok.” Avie etok ginei yaun etok ve gisov ei gitpweng are ginei ei nangge Juda ite, bemem ei ta givin ve ginei Yisu nemb ei ru. ");
INSERT INTO kbm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Beti Yisu ginei gitangi ei, “Mie gunei yaun etenok vie molge, be ule. Ve ande ayeu gaitin ngalau tiate gikwai mie natum avie gikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Avie nok ginumul gile ane nam ok be gili natu avie ande vie be giengk ve ngalau tiate ande gile gihlang gikwai ei. ");
INSERT INTO kbm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisu nangge Taia as taku be gile Saidon as taku be gile love gile gihlang taku ebe ital inei nam bage isgabu ok, bekob gile gihlang bui kapul Galilaia. ");
INSERT INTO kbm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Be amolmol subu inggas amol ti talngavo mongai be avo ma itangi Yisu ile be inei gitangi Yisu ve nitak bage niwei amol nok veik talngavo golonge be avo ninei yaun vusa. ");
INSERT INTO kbm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yisu gigas amol nok be gabu ile aikawe ikwai amolmol tepwengge, kob Yisu gitak bage kuku gisov amol nok talngavo isgabu be giluk avo rulu giwei bage be bage giwei amol nok amble. ");
INSERT INTO kbm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yisu gidank gireu gulumb be ongonge giro gireu bekob ginei gitangi amol nok be ginei; “Talngavom tis avom ponge!” ");
INSERT INTO kbm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Be seukie-ngge amol nok talngavo tis avo ponge be giute be ginei yaun vusa. ");
INSERT INTO kbm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bekob Yisu ginei yaun gwangne molge gitangi amolmol ve ginei inei gen etok binge nitangi amolmol bwaya. Bemem eisir iute Yisu ane yaun ite be ile be inei gen etok binge gitangi amolmol be iute love geb taku avut. ");
INSERT INTO kbm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amolmol tepwengge ebe iute gen etok binge ok ikuri be ilat bais be inei ei gilgum ane gen walang ok vie molge be gilgum amolmol ebe talngas-avo gitu be avos ma ok, be iute yaun be inei yaun vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Givin sawa etok ge amolmol dubi bamo ti iro isate sut itangi Yisu ile vukuri, be ivang love ande as ben ebe ve inen ok ande ma. Beti Yisu gital ane singamolomb-gen itangi ei ile be ginei; ");
INSERT INTO kbm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ayeu tangg viti anongge ve amolmol dubi bamo etenik ane. Ve eisir ivang ivin ayeu love ande asmate aitol gile gikwai, be ande as ben ebe ve inen ok ma gikwai. ");
INSERT INTO kbm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Be ginei ayeu nahlin eisir be invang as nam ane tis marav nes is ge inde, atob matanos tumtumi be inambieg nangge luev kob atob ines is ate vunkunu, ve amolmol subu nangge taku undib undib ane ivin.” ");
INSERT INTO kbm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Be eisir singamolomb iutani ei be inei, “Eitit tavang taku sawa etenik, be atob wali eitit tanvwat ben nangge inend be tanemb ve eisir etenik inen?” ");
INSERT INTO kbm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Be Yisu giutani eisir be ginei, “Yem aim ben subu giengk me ma?” Be eisir inei, “Ameimei ben siti ete giengk ik.” ");
INSERT INTO kbm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bekob Yisu ginei gitangi amolmol ve inambweg golonge, bekob geb ben siti etok be ges miengk gitangi Pomate, be geb ben etok vusvusa bekob geb gitangi ane singamolomb-gen ve inbwas nitangi amolmol be inen, be eisir singamolomb ilgum. ");
INSERT INTO kbm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Be eisir nok subu as wenk natu natu subu giengk givin. Yisu ges miengk ve wenk etok ane bekob ginei gitangi ane singamolomb-gen ve inbwas nitangi amolmol nivin. ");
INSERT INTO kbm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Amolmol tepwengge en ben etok be gile gitangi bekob eisir singamolomb ivwat sab gitangi 7 be isbang ben dadanis ebe giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Be eisir ebe en ben etok ok tepwengge gitangi 4,000. Bekob ete Yisu gihlin is be ivang as nam ane ikwai kob, ");
INSERT INTO kbm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tis ane singamolomb-gen ile ipil ei-vovo seukie-ngge be ile Dalmanuta as taku. ");
INSERT INTO kbm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisai subu inme be es valir ve avos ge gitangi Yisu, be inei gitangi ei ve nilgum gen bwalbwale ti be eisir indi veik inatpweng are inei ei gilgum gen bambamo etok ve Pomate ane gwangne. ");
INSERT INTO kbm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yisu giute yaun etok be aplo bunam be ginei gitangi eisir, “Nam-nambed be amolmol as-mate etenik ane iutani ve indi gen bwalbwale? Bingano, ayeu nanei nitangi yem, atob ayeu nalgum gen bwalbwale ti be amolmol indi nivin sawa etenik ite ma molge.” ");
INSERT INTO kbm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Be Yisu gikwai eisir be tis ane singamolomb-gen ile ipil ei-vovo vukuri be es bui gili ile ipil bui tavlu ane vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","17","Eisir singamolomb tas givalngan ebe ve invwat ben subu nivin nisa isate ok, be ivwat beret dongke-ngge. Be Yisu ginei bing-ai ti gitangi ane singamolomb-gen be ginei yaun gwangne molge gitangi eisir be ginei, “Undi aimate-ngge! Unemb aimate dabin viengge. Ve Herodes be tis eisir Parisai as yis.” Yisu ginei yaun gipil eisir Parisai be tis Herodes as luev tiate subu be ginei ve bing-ai ge gipil yis ebe ivse givin beret veik nilgum be beret nirun be bamo ok. Beti eisir singamolomb inei bwat Yisu ginei yaun etok gipil eisir ve gisov ebe tas givalngan ve invwat ben nisa isate ok. Yisu ande gitpweng yaun ete ane singamolomb-gen inei ve is ate ok are gikwai, be ginei, “Nam-nambed be yem unei yaun walang ano gitangi aimate gisov ebe uvwat ben subu gisa aimate ite ok? Yem dabangg-aim gwet ma be utpweng gen etok are ite nangge. Yem wat aplongg-aim dadani ge nangge me? ");
INSERT INTO kbm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yem matanongg-aim ok giengk bemem uli gen ti ano ite. Be talngangg-aim avo ok giengk bemem ute yaun be utpweng are ite ma. Yem wat ande tanggaim givalngan gen, ");
INSERT INTO kbm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ebe warik ayeu galgum ve gab beret bage tavlu ve amolmol gitangi 5,000 en ok me? Be yem usbang ben etok ane dadanis gisov sab aivir?” Be eisir singamolomb inei, “Sab 12.” ");
INSERT INTO kbm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Be givin ebe ayeu gab ben siti-ngge ve amolmol 4,000 en ok, okob yem usbang ben nok ane dadanis gisov sab aivir?” Be eisir inei, “Sab 7.” ");
INSERT INTO kbm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Be Yisu ginei gitangi ane singamolomb-gen, “Bemem yem wat utpweng gen etok are ite nangge me?” ");
INSERT INTO kbm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yisu tis ane singamolomb-gen imbielk Betsaida be amolmol subu inggas amol matano bop ti itangi ei ile be inei gitangi ei ve nitak bage niwei amol nok. ");
INSERT INTO kbm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yisu geb amol nok gibweg bage be gigas ei be gabu ile ihlang ikwai nam luvwe. Yisu avo rulu gile amol matano bop nok matano gikwai kob gitak bage giwei ei be ginei. “Ande mie guli gen me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Be amol nok ginei, “Ande. Bemem gali amolmol subu ilek be inme weik ei ebe givarkei sangas ok.” Ei matano avwavu nangge, ");
INSERT INTO kbm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","beti Yisu gitak bage giwei amol nok matano vukuri bekob ete gili gen walang ok giengk gitip ge. ");
INSERT INTO kbm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bekob Yisu gihlin ei ve nivang be ginei gitangi ei. “Uvang am nam ane, be nunumul nunme Betsaida vukuri ite.” ");
INSERT INTO kbm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisu tis ane singamolomb-gen imdil be ivang itangi Sisaria Pilipai as nam dabe subu ile, ivang ete luev ok ge be Yisu giutani ane singamolomb-gen be ginei; “Amolmol ital ayeu inei ret?” ");
INSERT INTO kbm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eisir singamolomb iwel Yisu avo be inei, “Amolmol subu ital mie inei Jon ebe ges ges bui sanggu gipil amolmol ok, be subu inei mie Ilaija, be subu inei mie profet gimungg ane ti ebe warik ginei Pomate avo ukwas binge ok.” ");
INSERT INTO kbm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bekob Yisu giutani ane singamolomb-gen vukuri be ginei; “Be yem ate utal ayeu unei ret?” Pita giwel ei avo be ginei, “Mie Kilisi. Mie Amol ebe Pomate gihlin ginme ve nemb amei Juda dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Be Yisu ginei gitangi eisir ve ginei inei ei binge nitangi amolmol subu bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yisu gibul ane singamolomb-gen be ginei. “Pomate Natu ayeu ebe meng-gahlang weik amolmol ok atob nanggas vavavne bamo molge nangge eisir, bambamo mateu ane be amolmol ebe emb da nangge lum mateu ane ok be tis eisir ebe emb Mose ane yaun dabin ok bais, bekob atob ines ayeu vunu. Be nivin as-mate ebe ve aitol ane ok okob atob matawangg be namdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisu ginei yaun etok vusa bupwe ge gitangi ane singamolomb-gen. Bekob ete Pita gigas ei be gabu ile aikawe kob gigo ei. ");
INSERT INTO kbm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bemem Yisu girau lili be gitlo ane singamolomb-gen be gigo Pita be ginei; “Sadam ule ukwai ayeu! Mie guvang mul ve Pomate ane ta gitung ite ma. Etenok mie guvang mul ve amolmol ge as tas gitung.” ");
INSERT INTO kbm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bekob Yisu gital ane singamolomb-gen be tis amolmol tepwengge itangi ei ile be ginei gitangi eisir be ginei; “Ginei amol ti ta givin ve ginei nivang mul ve ayeu, okob ei nipasang ate ve ninggas vavane ete ayeu ve nanggas ok nivin. ");
INSERT INTO kbm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amol ti ginei ta gitung utle ulis bamo molge, atob ei nimat vunu nindeb mul ane. Be amol ti ebe gimat vunu ve ayeu tis angg binge vie ane ok, amol etok atob nimbweg matawe nindeb mulane. ");
INSERT INTO kbm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Gen etok vie ite ve amol ti ninggas ane gen nalk ane walang ok be nireu yev bamo ebe giengk dangetok ok nile nindeb mulane. Be Gen ti giengk ebe ve amolmol inemb niwel dalgos be inambweg matawas vukuri ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Galkik as-mate etenik amolmol ilgum gen ungglus ungglus walang ano, bemem amol ti ginei nivkir dume nitangi ayeu be tis angg yaun, atob nindeb mulane nivin ebe Pomate Natu ayeu ebe meng-gahlang weik amolmol ok ve nanumul nanme tis Tamangg ane bogbogo be tis angela vevies invin ok, atob ayeu navkir dumangg nitangi ei weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Be Yisu ginei gitangi eisir, “Bingano, ayeu nanei nitangi yem nanei; Amolmol subu ete ivarkei nik atob inmat vunu ite love indi Pomate ane gwangne ebe ve nemb amolmol dabin ok okob. ");
INSERT INTO kbm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","As-mate 6 gile gikwai kob Yisu gigas Pita gabu Jems be Jon invin ei. Be gigas sotol ireu matendubi undib ti ile ivang atane-ngge nangge eteok, be sotol ili ebe Yisu utle ulis giro ate vukir ok. ");
INSERT INTO kbm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Be ane kup ringenk be bogbogo molge. Amol ti nangge nalk etek gitangi ginei nivuk ane kup love bogbogo dangetok ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bekob sotol ili ebe ande Ilaija gabu Mose inme ivarkei be kakie ivin Yisu ivarkei ok. ");
INSERT INTO kbm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Pita gabu Jon be Jems ili Yisu utle ulis ebe giro ate vukir be ringenk molge ok, be gaptol ipelk anongge, be inei wali atob inei yaun avos nam-nambed? Pita gili ma be ginei yaun giengk gublu den ok ge gitangi Yisu be ginei, “Gidung, Eitit tavang taku etenik be vie molge. Be ginei mie tam givin kob amei anpasang bes natu aitol, ti ve mie, ti ve Mose, be ti ve Ilaija. ");
INSERT INTO kbm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pita ginei yaun etok gikwai be umbim ti ginme gitav tulu ve sotol be Pomate ginei yaun ti nangge umbim etok aplo be ginei, “Ayeu Natungg dongke etenok ebe tangg givin ei gitlek ok. Be unaute ei ane yaun ge.” ");
INSERT INTO kbm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sotol singamolomb aitol ebok nas welewele seukie-ngge bemem ili amol ti ite, be Yisu ei ate ge givarkei givin sotol. ");
INSERT INTO kbm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bekob tis ane singamolomb-gen aitol nok isov nangge matendubi ile be Yisu ginei gitangi sotol be ginei; “Undi velob unei gen ete galkik gaptol uli be ute ok nitangi amolmol. Love Pomate Natu ayeu ebe meng-gahlang weik amolmol ok namdil vukuri nangge taku gimat ane kob.” ");
INSERT INTO kbm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sotol iute Yisu ane yaun be isov ane lu ge. Bekob inei ve is ate be inei; “Wali yaun ete galkik ei ginei “Nimdil vukuri” ok ane dabe nam-nambed?” ");
INSERT INTO kbm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bekob ete iutani ei be inei; “Nam-nambed be amolmol bambamo ebe emb Mose ane yaun dabin ok inei atob Ilaija nimungg ninme bekob ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Be Yisu ginei gitangi sotol; “Bingano, Ilaija atob nimungg ninme ve nipasang gen walang ok yapin ge. Bemem gimdom be amolmol gimungg ane ebe iro Pomate avo ukwas bwalbwale ok inei, ‘Asonge Pomate Natu ebe ve menihlang weik amolmol ok atob ninggas vavane be atob amolmol bwais ve ei be inaitin ei?’” ");
INSERT INTO kbm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Be Yisu ginei; “Ilaija ande ginme gikwai, be gen ret ret ete amolmol ilgum gitangi tas gitung ok gipil ei ok, etok gitau gile yaun ebe giengk Pomate ane kapia ok.” ");
INSERT INTO kbm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisu tis ane singamolomb-gen aitol ebok ile vunge ve amolmol dubi bamo ti be tis eisir singamolomb tavlu ebe tis gidung subu ebe emb Mose ane yaun dabin ok es valir ve avos ge gitangi is ate ivang ok. ");
INSERT INTO kbm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Givin ebe Yisu gile gihlang ok be amolmol ili be ikuri vunungge, be ituvki itangi ei ile be inei, “Asmate Mie.” ");
INSERT INTO kbm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bekob Yisu giutani ane singamolomb-gen be ginei; “Yem avongg-aim bambamo ete galkok gitangi aim ate ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Be amolmol dubi bamo etok as amol ti gitlek ate be ginei gitangi Yisu be ginei; “Gidung, Ayeu gagas natungg gatagni mie ganme ve nagalau tiate ti givang givin ei be gilgum be amol natu gitangi ebe ve ninei yaun vusa ok ite. ");
INSERT INTO kbm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Be asmate walang ok ngalau tiate nok ges amol natu be gikari ei gile gitak nalk be avo vurvurk meng-gihlang avo be gilat nivo gipil ate be roro gwangne tiate. Be ayeu ganei gitangi miam singamolomb-gen ve inaitin ngalau tiate nok nikwai, bemem ilgum be gitangi ite.” ");
INSERT INTO kbm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Be Yisu ginei gitangi eisir tepwe be ginei; “Yem etenik ge aplongg-aim givin ayeu ite molge ba. Ayeu gavang gavin yem ebe warik, be asger ge kob yem aplongg-aim nivin ayeu subu? Omb amol natu inme kob.” ");
INSERT INTO kbm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Be eisir inggas amol natu itangi Yisu ile. Ngalau tiate etok gili Yisu be gikari amol natu nok gile gitak Yisu va be gimwalmwal gilek be ginme be avo vurvurk gisov avo. ");
INSERT INTO kbm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Be Yisu giutani amol natu nok tame be ginei, “Asger ngalau tiate gigas mie natum?” Be Amol natu tame giwel Yisu avo be ginei; “Ebe warik ei nunus ge ok. ");
INSERT INTO kbm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Be As-mate walang ok nagalau tiate etok gilgum ve nes ei vunu be gikari ei gireu yev be gisov bui gigas ta-ngge. Be ginei mie gitangi kob tam viti ve amei be omb amei ru.” ");
INSERT INTO kbm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Be Yisu giwel ei avo be ginei, “Ayeu gitangi! Be nam-nambed be mie gutani ayeu lili dangetok? Gen walang etenik gitangi ebe ve amolmol inalgum ok, ginei eisir aplo givin Pomate ano molge.” ");
INSERT INTO kbm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Be Amol natu tame ginei yaun gwangne molge be ginei, “Ayeu aplongg givin Pomate, bemem ayeu gitangi ite nangge be mie omb ayeu ru veik ayeu aplongg nivin Pomate gwangne ge.” ");
INSERT INTO kbm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yisu gili amolmol anongge ebe itangi ei ile ok, beti ginei yaun gitangi ngalau tiate etok be ginei; “Mie ngalau tiate, avom itu be talngem-avo itu. Ayeu gahlin mie ve ganei nule nuhlang nukwai amol natu etenok, be nunumul nunme nuvang nuvin amol natu etenok vukuri ite.” ");
INSERT INTO kbm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Be ngalau tiate etok gilgum amol natu nok be yayai tiate molge bekob gile gihlang gikwai ei. Be amol natu giengk weik ebe amolmol imat vunu ok, beti amolmol tepwengge inei, “Ande ei gimat vunu.” ");
INSERT INTO kbm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bemem Yisu geb amol natu nok be girun itin be gimdil givarkei. ");
INSERT INTO kbm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yisu gisov nam aplo gile kob ane singamolomb-gen iutani ei bwaya gege be inei; “Nam-nambed be amei algum ve aitin ngalau tiate etok nile nihlang be gitangi ite?” ");
INSERT INTO kbm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yisu giwel eisir avos be ginei; “Miengk dongke-ngge gitangi nitin gen dangetok nikwai, be gen ti givin ite.” ");
INSERT INTO kbm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yisu tis ane singamolomb-gen ikwai nam etok be ivang nambe Galilaia ane ile. Yisu bua ve ret amolmol inaute ebe ei givang etok ok binge, ");
INSERT INTO kbm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ve ei gilgum ve nimbul ane singamolomb-gen. Yisu ginei ve eisir singamolomb be ginei; “Atob amolmol bambamo inemb Pomate Natu ayeu ebe meng-gahlang weik amolmol ok nitangi amolmol ebe be ines ayeu vunu ok. Be atob eisir ines ayeu vunu be nivin as-mate ebe ve aitol ane ok okob atob ayeu matawangg be namdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bemem eisir singamolomb itpweng yaun etok are ite be ipelk ve inautani Yisu vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yisu tis ane singamolomb-gen imbielk Kapenaum be isov nam aplo ile kob Yisu giutani ane singamolomb-gen be ginei; “Yem unei yaun ret ve aim ate nangge luev?” ");
INSERT INTO kbm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bemem eisir iwel Yisu ane yaun ite, ve gisov eisir inei yaun ve isate nangge luev inei, “amol ret nangge eitit atob menihlang weik amol bamo?” ");
INSERT INTO kbm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yisu gibweg golonge kob gital ane singamolomb-gen 12 ebok itangi ei ile be ginei gitangi eisir be ginei; “Ginei amol ti ta givin ve menihlang weik amol bamo, okob nemb ate nile mul be nemb kulkul ve amolmol tepwengge ane.” ");
INSERT INTO kbm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bekob Yisu bage gisov nunus natu ti be gile gitak ei givarkei amolmol tepwengge nas gideb mate ane be gimwal bage gitle nunus natu nok gili be ginei gitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Amol ti ginei ta gitung ayeu arengg be geb nunus natu ti dang-eteik dabin, etok weik ebe gilgum gen vie gitangi ayeu ok. Be amol ti ginei gilgum gen vie gitangi ayeu, okob etok weik ebe gilgum gen vie gitangi Pomate ebe gihlin ayeu be ganme ok.” ");
INSERT INTO kbm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bekob Jon ginei gitangi Yisu be ginei, “Gidung, Amei ali amol ti gilgum kulkul ve gitin ngalau tiate gikwai amolmol ve mie arem ane. Bemem amei anei gitangi ei ve nitau, ve miam singamolomb ti ei ite.” ");
INSERT INTO kbm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Be Yisu ginei; “Untau! Amol ti ginei gilgum gen bwalbwale ti ve awangg gwangne, okob ei gitangi ebe atob ninei yaun tiate nipil ayeu ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Be amol ti ginei ges valir gitangi eitit ite, okob etok weik eitit and nune ti ete ei ok. ");
INSERT INTO kbm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amol ti ginei gitpweng yem are ginei awangg amolmol-gen yem be geb bui luvus ve yem unum, atob amol etok ninggas gen vie nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Amol ti ginei ta gitung ve nilgum nunus me amol bamo ti ebe aplos givin Pomate ok be nisov tiate aplo nile, okob vie ve amolmol inadgin vat bamo ti nile amol nok savwalo be inkari ei nisov gielk nile. Bemem etok tiate ve amol nok ebe ve nilgum amolmol ebe aplos givin Pomate ok be insov gen tiate aplo inde ok. Ve atob ei ninggas vavavne bamo molge nitlek ete mate ane ok nangge Pomate ane nindeb mulane. ");
INSERT INTO kbm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ginei mie bagem tavlu gulgum gen tiate, okob nudbuen gili nikwai be etok vie ve mie numbweg matawem tis bagem tavlu ge. Bemem tiate ve nureu yev bamo ebe giengk dangetok be gimat ite ok nule tis bagem isgabu ge. ");
INSERT INTO kbm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Be mwatmwat ebe en amolmol ebe imat vunu ok utlas ulis ok ete ivang etok givin bemem eisir imat vunu ite.) ");
INSERT INTO kbm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ginei mie vam tavlu gilgum gen tiate okob nudbwen gili nikwai, be etok vie ve numbweg matawem tis vam tavlu ge bemem tiate ve nureu yev nule tis vam isgabu. ");
INSERT INTO kbm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Taku ebe mwatmwat en amolmol ebe imat vunu utlas ulis ok ete ivang etok bemem eisir imat vunu ite.) ");
INSERT INTO kbm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ginei mie matanom tavlu gili gen tiate okob nuptit vurupwe nikwai, be etok vie ve mie nusov Pomate ane taku ebe ve nemb mie dabin ok nule tis matanom tavlu ge, bemem tiate ve nureu yev nule tis matanom isgabu ge. ");
INSERT INTO kbm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Be yev etok tis mwatmwat ebe en amolmol ebe imat vunu ok utlas ulis ok ete ivang etok bemem eisir imat vunu ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","Gielk ei gen vavis vie molge ebe ve nilgum ben be kavkavse ok, bemem ginei gielk vavis ma be bwalum weik ete bui ok, okob atob nilgum ben be kavkavse nam-nambed? Dangetok be amolmol tepwengge tas nitung taku ebe yev giengk ok be as tas gitung etok ete atob nilgum be inpelk ve isate ane be atob inalgum gen vie-ngge, weik ete gielk gilgum ben be kavkavse ok. Yem tangg-aim nitung taku ete yev giengk ok be unvang vie-ngge tis tanggaim vevie-ngge, be tanggaim nitung aim ate nivin.” ");
INSERT INTO kbm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisu tis ane singamolomb-gen ikwai taku etok be ile Juda be tis nam dabe subu ebe giengk bui Joldan tavlu ane ok givin. Be amolmol anongge iro isate sut itangi Yisu ile vukuri be ei gibul eisir weik ebe gilgum gilgum gitangi amolmol ok. ");
INSERT INTO kbm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bekob Parisai subu itangi ei ile be ilgum ve inyo inyo ei be inei; “Eitit and luev ti giengk dangetok ve amol ti ginei bua ve arue kob atob nitin ei me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yisu giwel eisir avos be giutani eisir be ginei; “Mose geb yaun ret gitangi yem?” ");
INSERT INTO kbm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Be eisir inei, “Mose ginei gitangi ameidang-eteik ginei; Amol ti ginei bua ve arue, okob ei niro kapia ti be nemb nitangi arue nile be nitin ei.” ");
INSERT INTO kbm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Beti Yisu ginei gitangi eisir be ginei; “Mose geb yaun etok gitangi yem ve gili yem aplongg-aim dadani molge. ");
INSERT INTO kbm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bemem warik gimungg ane, Pomate gipasang gulumb tis nalk be ‘gipasang avie ti be amol ti.’ ");
INSERT INTO kbm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dangetok be atob amol nikwai tame gabu tine be nile nivang nivin arue, ");
INSERT INTO kbm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","be sulu atob invang weik gen ano donke be wat invang weik gen ailu vukuri ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Be gen ete Pomate ande gidgin gikwai ok gitangi ebe atob amol ti nidbwen gili ok ite gitangi ite molge.” ");
INSERT INTO kbm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yisu tis ane singamolomb-gen ilumul ile ebe nam ok bekob eisir singamolomb iutani Yisu ve yaun etok ane vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Beti Yisu ginei gitangi ane singamolomb-gen be ginei; “Amol ti ginei bua ve arue be gitin gikwai, bekob gile geb avie vaku ti vukuri, amol etok giyaing luev ebe amol be avie emb isate ane ok. ");
INSERT INTO kbm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Be ginei avie ti bua ve ane amol be gile geb amol ti vukuri, okob avie etok giyaing luev ebe amol be avie emb isate ane ok givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Amolmol subu inggas nunus natunatu itangi Yisu ile ve nitak bage niwei eisir, bemem eisir singamolomb inggo eisir nok. ");
INSERT INTO kbm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisu gili be ta vavis be ginei gitangi ane singamolomb-gen be ginei; “Untau nunus be intangi ayeu inme. Be unvarkei eisir gili bwaya. Ve Pomate ta givin ve nemb amolmol dang dang-etenik dabin. ");
INSERT INTO kbm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bingano. Ayeu nanei nitangi yem nanei, amol ti ginei aplo givin Pomate ane yaun dang ete nunus aplos givin amolmol as yaun ok ite, atob Pomate nemb ei dabin ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bekob Yisu gitak bage giwei nunus nok dabas be geb avo ukwas giwei eisir. ");
INSERT INTO kbm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yisu gimdil ve nivang ane be amol ti gituvki gitangi ei gile be giro vandubi supwe gisov nalk gideb ei na ane be giutani ei be ginei; “Gidung vie. Ayeu nalgum ret veik nambweg matawangg nemb ta-ngge?” ");
INSERT INTO kbm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Be Yisu ginei gitangi amol nok be ginei; “Nam-nambed be mie gutal ayeu gunei gidung vie? Pomate dongke-ngge ei amol vie. ");
INSERT INTO kbm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Be mie gute Pomate ginei: Nos amolmol vunu ite, nuyaing luev ebe amol be avie emb isate ane ok ite, nuvaina ite, nuyo nuyo amolmol ve yaun bingkas-kasop be nuvwat as gen ite, nusov tinem gabu tamem as yaun ane lu-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Be amol nok ginei gitangi Yisu be ginei; “Gidung, ayeu nunus ge be gaute be galgum yaun etok tepwengge ano gile be ma.” ");
INSERT INTO kbm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yisu na giro amol nok ta be ta givin ei anongge beti ginei gitangi ei be ginei; “Mie tam givin gen dongke-ngge nangge. Nule be nomb am wambal tepwengge be amolmol inavgo be nomb gen etok ane mone nitangi amolmol ebe wambal ma ve is ok, be bwayage kob atob mie nunggas am gen vevies ge nindeb mul ane. Be unme be uvang mul ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Amol nok giute yaun etok love aplo bunam be givang gikwai tis aplo bunam ge, ve gisov ei amol ti ebe tis wambal bamo ok. ");
INSERT INTO kbm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yisu na giro ane singamolomb-gen ta bekob ginei gitangi eisir be ginei; “Gen etok bunam ve amolmol ebe tas givin wambal ok, ebe ve insov taku ebe Pomate ve nemb eisir dabin ok inde ok.” ");
INSERT INTO kbm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eisir singamolomb iute Yisu ane yaun etok be ikuri vunu-ngge. Bemem Yisu ginei gitangi eisir vukuri be ginei; “Angg nune-nggen, amolmol ebe tas givin ve Pomate nemb eisir dabin ok, atob inalgum kulkul bamo molge invang bekob atob insov taku etok inde. ");
INSERT INTO kbm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gen etok bunam ve gen bamo ti weik bwelk kamel ok nisov gen natu ti weik ulank avo ok nile, bemem etok bunam molge ve amolmol ebe tas givin wambal ok ve insov Pomate ane taku inde ok.” ");
INSERT INTO kbm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eisir singamolomb ikuri vunu-ngge be inei ve is ate be inei; “Ginei dangetok okob amol ret gitangi ebe atob nimbweg matawe ok?” ");
INSERT INTO kbm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yisu gitlo eisir be ginei; “Amol ti gitangi nilgum gen dangetok ite ma. Pomate dongke-ngge gitangi nilgum gen walang ok.” ");
INSERT INTO kbm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Be Pita ginei gitangi Yisu be ginei, “Tauli, amei avang akwai amei gen walang ok be avang mul ve mie.” ");
INSERT INTO kbm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Be Yisu ginei gitangi eisir, “Bingano, ayeu nanei nitangi yem. Amol ti ginei geb awangg kulkul be givang gikwai ane nam be tis ane bambamo-nggen be gikwai ane kulkul be gilgum kulkul mateu ane, atob ei ninggas gen walang ano niwel ane nam be malenggen tis luvu avie-nggen be tame gabu tine be tis ane kulkul. Bemem atob ei ninggas vavavne be tis bunam nivin be nisov mul ane atob ei nimbweg matawe nemb ta ge. ");
INSERT INTO kbm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bemem amolmol subu ebe tis ares gimungg ane ok ete atob inde indeb mul ane be eisir ebe mul ane ok atob inde inmungg.” ");
INSERT INTO kbm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yisu tis ane singamolomb-gen ireu ve inde Jerusalem. Yisu gimungg be ane singamolomb-gen itau ile ei. Eisir singamolomb tas gitung walang ano be aplos bunam molge, be amolmol ebe itaumul eisir ok ipelk anongge. Bekob Yisu gigas ane singamolomb-gen 12 ebok vukuri ile be ginei gen ebe atob amolmol inalgum nipil ei ok binge gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yisu ginei gitangi ane singamolomb-gen be ginei; “Atob eitit tanreu tande Jerusalem ok okob atob amolmol mateu ane subu be tis gidung ebe emb Mose ane yaun dabin ok, atob inalgum awangg yaun ve ines ayeu vunu, bekob inemb ayeu natangi amolmol gitip ane nale. ");
INSERT INTO kbm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Be atob eisir etok inei yaun ungglus ungglus nipil ayeu, be inluk nireu ayeu, be inrau ayeu, bekob ines ayeu vunu. Bemem as-mate ebe ve aitol ane ok, okob atob ayeu matawangg be namdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi natu-nggen Jems gabu Jon sulu itangi Yisu ile be inei; “Gidung. Eilu tangg-amei givin anei mie nulgum gen vie ti nitangi eilu.” ");
INSERT INTO kbm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Be Yisu ginei gitangi sulu; “Yemlu tangg-aim givin ve ayeu nalgum ret nitangi yemlu?” ");
INSERT INTO kbm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Be sulu inei gitangi Yisu be inei; “Eilu tangg-amei givin anei mie nutak eilu anambweg anvin mie nangge miam taku nivin ebe mie ve nomb amolmol dabin ok. Amol ti nimbweg nindeb mie bagem mol ane be ti nimbweg nindeb bagem kase ane.” ");
INSERT INTO kbm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Be Yisu ginei gitangi sulu be ginei; “Amol gabu, Yemlu utpweng yaun ete unei nok are gikwai me ma? Yemlu gitangi ebe atob un-gas vavavne ete atob ayeu nanggas ok unvin me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Be sulu iwel Yisu avo be inei; “Eilu gitangi.” Be Yisu ginei gitangi sulu; “Bingano, yemlu ok gitangi ebe atob un-gas gen bunam tis vavavne ebe atob ayeu nanggas ok nivin. ");
INSERT INTO kbm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bemem ayeu gitangi ebe atob natak yemlu amol ti nimbweg nindeb baingg mol be ti nimbweg baingg kase ok ite ma. Ve etok Pomate ei ate-ngge atob nemb amolmol intangi taku ebe ei gipasang ve eisir ane yapin ok.” ");
INSERT INTO kbm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eisir singamolomb 10 ebok iute yaun etok be tas vavis anongge gitangi Jon gabu Jems. ");
INSERT INTO kbm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Beti Yisu gital ane singamolomb-gen tepwengge ipil dongke be ginei gitangi eisir be ginei; “Yem uli, amolmol bambamo subu nangge nalk etek emb amolmol dabin be imbweg amolmol vovo be emb eisir dabin ve eisir ate as gwangne be as tas gitung. ");
INSERT INTO kbm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bemem nangge yem ane, ginei amol ti ta gitung ve menihlang weik amol bamo, okob ei nemb kulkul ve amolmol tepwengge ane. ");
INSERT INTO kbm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Be amol ti ginei ta gitung ve menihlang weik yem aim amol mate ane ti, okob amol nok nilgum ate weik ebe amolmol tepwengge as amol kulkul ane sin-ge ti ok. ");
INSERT INTO kbm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pomate Natu ayeu ebe meng-gahlang weik amolmol ok ganme ve yem unemb kulkul ve ayeu ane ite ma. Ayeu ganme ve namb kulkul ve yem ane be namb au-ate niwel amolmol veik nanggas eisir intangi Pomate inde vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisu tis ane singamolomb-gen imbielk Jeriko, be givin ebe eisir imdil ve invang ok be amolmol dubi bamo ti itaumul Yisu tis ane singamolomb-gen nok be ile. Be Timias natu matano bop ti are Batimai ei gibweg luev bane be giutau-tani gen nangge amolmol ebe ilek be inme ivang luev ok. ");
INSERT INTO kbm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Amolmol subu ande inei Yisu binge gitangi Batimai nok gikwai, beti ei gital dang-eteik ginei; “Yisu Nasaret ane, Dawit ane dani mie, tam viti ve ayeu ma!” ");
INSERT INTO kbm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Be amolmol inggo ei be inei, “Tumingge!” Bemem Batimai gital avo bamo-ngge vukuri be ginei; “Dawit ane dani mie, tam viti ve ayeu ma!” ");
INSERT INTO kbm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yisu givarkei va ta be ginei; “Untal ei inme!” Be amolmol ital amol matano bop nok be inei gitangi ei, “Umdil tis tam vevie-ngge ve Yisu gital mie.” ");
INSERT INTO kbm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batimai gikari ane kup malar ane giengk be gimdil be givang gitangi Yisu gile. ");
INSERT INTO kbm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Be Yisu ginei gitangi ei be ginei; “Mie tam givin gunei ayeu nalgum gen ret nitangi mie?” Be ei giwel Yisu avo be ginei; “Gidung, ayeu ve nali gen vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yisu ginei gitangi ei, “Ule! Mie aplom givin ayeu beti gilgum be matanom ande ponge.” Be seukie-ngge amol nok matano ponge be ma ve givang mul ve Yisu nangge ete luev ok. ");
INSERT INTO kbm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisu tis ane singamolomb-gen ile imbloblo Jerusalem be ile ihlang nam dabe ailu ares Betpasi tis Betani nangge matendubi ebe ei oliv anongge givarkei ok. Be Yisu gihlin ane singamolomb ailu ve inmungg inde inahlang Jerusale, ");
INSERT INTO kbm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","be ginei gitangi sulu be ginei; “Gabu unde unahlang nam luvwe be unvang roro-ngge untangi nam ete givarkei mate ane ok unde. Atob yemlu unambielk eteok okob atob undi bwelk dongki ti iro wal gile be givarkei. Be bwelk dongki nok amol ti gibweg giwei ite molge, be gabu unahlang wal nikwai be unatwem unme etenik. ");
INSERT INTO kbm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Be ginei amol ti ve niutani yemlu be ninei yemlu ulgum gen etok ve ret ane, okob gabu unei nitangi amol nok unei; ‘Amol Bamo ta givin.’ Kob atob ei nihlin yemlu be unatwem bwelk dongki nok seukie-ngge undumul unme etenik vukuri.” ");
INSERT INTO kbm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yisu ane singamolomb-gen ailu nok ile be ili bwelk dongki vaku ti be bwelk nok ane tivie giro wal gile be giro wal dani gile tuelk nam ane be givarkei gibloblo luev. Sulu ile ve inahlang wal nikwai bwelk nok. ");
INSERT INTO kbm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Be amolmol subu ebe ivarkei imbloblo etok ok iutani sulu be inei; “Yemlu ve unamdom beti uhlang wal gikwai bwelk etenok?” ");
INSERT INTO kbm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Be sulu inei yaun gitangi ebe galkik Yisu ginei ve sulu ok gitangi eisir, beti amolmol nas vier ve sulu be gabu itwem bwelk nok be ile. ");
INSERT INTO kbm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sulu itwem bwelk dongki nok be itangi Yisu ile bekob iwaulu as kup malar ane be ivwal giwei bwelk nok dume tulkwe be Yisu gipil gile gibweg giwei. ");
INSERT INTO kbm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Amolmol anongge ivwal as kup giwei luev be subu ile itwel ei lan tis range tis range be niuk lan be, be ile ivwal giwei luev. ");
INSERT INTO kbm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Be amolmol ebe ivang mate ane ok be tis eisir ebe itau gile ok ital avos bambamo ge inei; “Vie molge! Pomate gitangi ebe atob nemb eitit and Amol Bamo ebe ve nemb eitit dabin ok, be ei ginme tis Pomate ane gwangne ge. ");
INSERT INTO kbm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pomate geb ane gwangne gitangi ei be gitangi ebe atob nemb eitit dabin ok. Dangebe warik Dawit geb eitit tumbud-gen dabin ok. Avond nivwat Amol Bamo are niengk einggoto ge.” ");
INSERT INTO kbm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisu gile gihlang Jerusalem be gisov lum yamar aplo gile be na gitung gen walang ok. Bemem ande as gile gikwai beti tis ane singamolomb-gen ivang Betani ane ile iengk etok. ");
INSERT INTO kbm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Givin tistumi-ngge Yisu tis ane singamolomb-gen imdil be inumul ve inde ebe Jerusalem ok vukuri, be Yisu ande marav ges vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Be givarkei aikawe-ngge kob na gile gili ei-nambwel dabe ti givarkei beti gile gibloblo ve nili velob ano subu nikaiwel. Yisu gile gibloblo be gili ei-nambwel nok ano ti gikaiwel ite be lan singe, ve ei etok ane aiweng ebe ve nes ano ok nangge. ");
INSERT INTO kbm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Beti Yisu ginei gitangi ei-nambwel dabe nok be ginei; “Mie wat nos vukuri ite ma!” Be eisir singamolomb ok ivarkei be iute yaun ete Yisu ginei gitangi ei-nambwel dabe etok ok givin. ");
INSERT INTO kbm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yisu tis ane singamolomb-gen imbielk Jerusalem ok bekob ete Yisu gisov lum yamar aplo gile be givinvin amolmol ebe ile ve ivgo gen be emb gen giwel ate ivang lum yamar aplo ok ile ihalng ikwai. Yisu ta vavis anongge be gitin amolmol ebe ilgum Tame ane lum yamar weik ebe maket ok ile ihlang ikwai be gitle as tebol mone ane vukir be gitut eisir as lopong ebe imbweg ve ivgo mank ok giriv be gira. ");
INSERT INTO kbm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Be geb yaun gwangne molge gitangi amolmol ve ginei invwat gen dang dang-etok insov lum yamar aplo inde vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bekob ete gibul eisir be ginei yaun ebe giengk Pomate ane kapia ok gitangi eisir be ginei; “Pomate ane nam atob tantal tanei amolmol tepwengge as nam mateu ane. Bemem ande yem ulgum love weik ebe amolmol vaina ane as taku ok.” ");
INSERT INTO kbm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bambamo ebe emb kulkul da ane ok subu be tis gidung ebe emb Mose ane yaun dabin ok iute yaun etok be irek luev ebe ve ines ei vunu nikwai ok. Ve eisir tas vadbu ve Yisu ve ei ane yaun ebe ginei ginei ok gilgum be amolmol walang ano tas gitung walang ano. ");
INSERT INTO kbm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Givin gibok Yisu tis ane singamolomb-gen ikwai Jerusalem be inumul ile iyengk Betani vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tistumi-ngge Yisu tis ane singamolomb-gen imdil vukuri be ile love imbielk ve taku ebe ei-nambwel dabe etok givarkei ok, be ili ei-nambwel dabe nok ande ainggwen gisov love gile ebe wakas ok. ");
INSERT INTO kbm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Beti Pita ta giro yaun ebe nolik Yisu ginei ok be ginei gitangi Yisu be ginei; “Gidung, Tauli ei-nambwel dabe ebe nolik mie gunei yaun gwangne gitangi ok ande ainggwen.” ");
INSERT INTO kbm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Be Yisu ginei gitangi eisir be ginei; “Bingano, Ayeu nanei nitangi yem nanei, ginei yem aplongg-aim givin Pomate ano molge, ");
INSERT INTO kbm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","okob yem gitangi ebe unei nitangi matendubi etok be unei, ‘Umdil be ule ukari imate isov gielk.’ Be ginei yem aplongg-aim ailu ailu ite be aplongg-aim nivin yaun ete unei ok ve atob ano nile, okob atob ano nile. ");
INSERT INTO kbm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Be ayeu nanei nitangi yem: Ginei yem os miengk be utani gen ti nangge Pomate be aplongg-aim givin ge unei atob un-gas gen etok, atob yem un-gas. Be atob Pomate nemb gen walang ok nitangi yem nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Be ginei yem ve unes miengk nitangi Pomate ebe gibweg gulumb ok be seukie-ngge yem tangg-aim giro amol ti ane gen tiate ebe gilgum gitangi yem ok, okob tangg-aim nivalngan ei ane tiate etok be tangg-aim nitung vukuri ite. Ginei yem unalgum gen dang etok, okob Tamangg-aim ebe gibweg gulumb ok atob ta nivalngan yem aim tiate ebe ulgum ok weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Ginei mie tam givalngan tiate ebe amolmol ilgum gitangi mie ok ite, okob Pomate ok atob ta nivalngan miam tiate ebe gulgum ok ite weik etok ge.”) ");
INSERT INTO kbm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yisu tis ane singamolomb-gen ilumul ile Jerusalem. Be Yisu gile givang givang ebe lum yamar aplo ok, be bambamo subu ebe emb da gitangi Pomate ok be tis gidung ebe emb Mose ane yaun dabin ok tis bambamo mateu ane subu itangi ei ile, ");
INSERT INTO kbm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","be iutani ei be inei; “Mie gulgum gen walang etok ve amol ret ane gwangne be amol ret geb ane gwangne gitangi mie?” ");
INSERT INTO kbm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Be Yisu giwel eisir avos be ginei, “Atob ayeu nautani yem ve yaun ti ane bekob, be ginei yem unei vusa, kob atob ayeu nanei amol ebe geb gwangne gitangi ayeu be galgum gen walang etok ok binge nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Unei kob, Wali Jon ebe ges bui sanggu gipil amolmol ok gigas gwangne nangge inend? Nangge Pomate me nangge amolmol?” ");
INSERT INTO kbm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Be eisir tepwengge inei yaun ve isate be inei; “Wali atob eitit tanei etok avond nam-nambed? Ginei eitit tanei Jon gigas gwangne nangge Pomate ane, okob atob ei ninei nitangi eitit ninei; ‘Be nam-nambed be yem aplongg-aim givin Jon ite?’ ");
INSERT INTO kbm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bemem ginei eitit tanei Jon gigas gwangne nagge amolmol as, atob nitangi ite.” Eisir inei dangetok ve gisov eisir ipelk ve amolmol, ve amolmol tepwengge ili inei Jon ei Pomate ane amol yaun ane ti roro. ");
INSERT INTO kbm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Beti eisir ili ma be iwel Yisu avo be inei; “Amei tangg-amei gisgil.” Be Yisu ginei gitangi eisir; “Dangetok be ayeu ok atob nanei gwangne ebe giro ayeu ta be galgum gen walang etenik gipil ok lavo nitangi yem ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bekob Yisu ginei bin-gai ti gitangi amolmol be ginei; “Amol ti givro um wain ti be givkwe el meng-gidbul be gitav nalk avo ebe ve in-gig wain ano nisov ok yapin be gitav nam va tulkwe undib ti ebe ve nimbweg be nemb wain dabin velob amolmol invaina wain ano ok. Bekob geb kulkul etok gisov amolmol ebe ve inemb kulkul etok dabin ok bais be ei ate gile ve givang taku undib ge ti. ");
INSERT INTO kbm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gile love aiweng ebe amolmol kulkul ane ve inpis wain ano ok meng-gihlang kob ete um tivie nok gihlin ane amol kulkul ane ti be gile ve nivwat kulkul etok ane ano nagge amolmol ebe emb wain dabin ok. ");
INSERT INTO kbm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Be amolmol ebe emb wain dabin ok emb amol nok ta be es ei bekob ihlin be givang bage apo ginumul gile. ");
INSERT INTO kbm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Beti um tivie gihlin ane amol kulkul ane ti vukuri be gile bemem amolmol ebe emb um dabin ok es amol nok weik etok ge gisov ete dabe ok be ilgum ei tiate tiate molge. ");
INSERT INTO kbm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bemem um tivie gihlin ane amol kulkul ane ti vukuri be gile be amolmol ebe emb wain dabin ok es ei vunu. Be ilgum weik etok ge gitangi amol bamo nok ane amolmol kulkul ane subu givin. Eisir es amolmol subu tiate molge be es subu vunkunu. ");
INSERT INTO kbm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Love ma be amol dongke-ngge gibweg, etok um tivie nok natu ebe ta givin ei gitlek ok. Bekob ete gihlin natu etok vemul ge gitangi eisir gile be ta gitung giengk aplo ge ginei; “Atob ei nile kob amolmol ebe emb um dabin ok atob tas nitung inei etok ayeu natungg be atob nas indi ei vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bemem givin ebe eisir ebe emb um dabin ok ili amol nok ebe gitangi eisir gile ok, be inei ve isate inei; “Um tivie natu ete ginme nik, be unme tanes ei vunu nikwai, be tan-gas um wain etenik ve it.” ");
INSERT INTO kbm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Beti eisir imdil ile bais gisov amol nok be es ei vunu, bekob ikari utle ulis gile gihlang gikwai um wain aplo. ");
INSERT INTO kbm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Be Yisu ginei gitangi amolmol be ginei; “Atob um tivie ninme kob atob nemb um wain nok nikwai eisir etok be nemb nitangi amolmol subu be inemb dabin, be atob ei nes eisir ete es ei ane amolmol kulkul ane vunkunu ok vunkunu nikwai. ");
INSERT INTO kbm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yem ok nolge usam yaun ake ti ebe giengk Pomate ane kapia ok gikwai me ma? Yaun nok ginei dang-eteik: ‘Twelk ebe warik amolmol gimungg ane itav nam giwei ok ete ande amolmol bwais be itin gikwai. Bemem galkik etek ande twelk etok meng-gihlang be ande vie molge ve nam ane. ");
INSERT INTO kbm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pomate gilgum gen etok be meng-gihlang be eitit tali tanei vie molge.’” ");
INSERT INTO kbm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bekob amolmol bambamo subu nangge Juda ilgum ve inemb Yisu ta ve ande eisir itpweng are inei Yisu ginei bing-ai etok gipil eisir roro-ngge. Bemem eisir ipelk ve amolmol velob amolmol ines is beti ikwai Yisu be ile. ");
INSERT INTO kbm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Parisai subu be tis Herodes ane amolmol subu itangi Yisu ile be ilgum ve inyo inyo ei be inei; ");
INSERT INTO kbm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","“Gidung, amei atpweng are anei mie amol yaun ano ane roro, be mie tam gitung yaun ete amolmol inei ok bamo molge ite ma. Be mie guli amolmol be gutpweng eisir are rorongge be gubul amolmol gitangi ebe Pomate ane ta gitung ok roro-ngge. Be mie unei itangi amei kob ve ameimei luev ti giengk dang etok ve atob amei ankari takes nitangi Rom as amol bamo. Bemem mie unei nitangi amei kob, ve gen etok gitangi me gitangi ite?” ");
INSERT INTO kbm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bemem Yisu ande gitpweng eisir as yaun ete tas gitung giengk aplos ok are gikwai be ginei gitangi eisir be ginei; “Yem ulgum ve unyo unyo ayeu etenik. Unemb mone nok ti inme be ayeu ali kob!” ");
INSERT INTO kbm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Be eisir emb mone ti gile Yisu gili bekob ginei; “Amol ret dalgo be tis are eteik?” Be eisir inei, “Etenok amolmol Rom ane as amol bamo are be tis dalgo etenok.” ");
INSERT INTO kbm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Beti Yisu ginei gitangi eisir be ginei; “Amok dangetok be unemb Rom as mone ninumul nitangi eisir ate nile, be unemb Pomate ane gen nitangi Pomate nile.” Amolmol tepwengge ikuri vunu-ngge be ilat bais ve Yisu ane yaun ebe ginei ok ane. ");
INSERT INTO kbm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eisir Sadukai ebe inei dang etok inei amolmol ebe imat vunu ok atob inamdil vukuri ite ok, as amolmol subu itangi Yisu ile ");
INSERT INTO kbm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","be inei; “Gidung, Mose giro yaun ti gitangi eitit dang-eteik: ‘Amol ti ginei gimat vunu gikwai arue be sulu natus ma, okob amol nok male nemb avie tupe etok veik nes nunus vier niwel amol ete gimat vunu ok.’ ");
INSERT INTO kbm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dang etok be eisir vu ti imbweg, eisir nok gitangi bage tavlu be ano ailu (7). Be amol mate ane geb avie ti be gimat gikwai arue be sulu natus ma. ");
INSERT INTO kbm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bekob male ebe gile gisa ei ok geb avie nok vukuri bemem gimat vunu weik etok ge be sulu natus ma. Be luev dongke nok ge gipil male luvwe ti ane, ");
INSERT INTO kbm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","be tis sotol aivat ebok. Sotol kawe be male etok tepwengge emb avie dongke-ngge etok bemem imat vunu ikwai avie etok be antus-gen ma. Be mulane kob avie nok gimat vunu.” ");
INSERT INTO kbm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Be eisir Sadukai inei gitangi Yisu be inei; “Atob mulane nivin ebe amolmol tepwengge ve inamdil vukuri ok okob atob eisir vu etok as amol ret nemb avie etok vukuri ve arwe ve eisir bage tavlu be ano ailu etok tepwengge emb avie dongke etok ge?” ");
INSERT INTO kbm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Be Yisu ginei gitangi eisir be ginei; “Yem utpweng yaun ebe giengk Pomate ane kapia ok are ite be utpweng Pomate ane gwangne are ite givin weik etok ge. Beti yem unei yaun etenok gitlek molge. ");
INSERT INTO kbm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Be unaute! Nivin ebe amolmol tepwengge matawas be inamdil vukuri ok, atob eisir meinahlang weik angela ebe ivang gulumb ok. Be atob wat amol be avie inemb isate vukuri ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bekob Yisu ginei yaun gipil amolmol ebe imat vunu be ve inamdil vukuri ok be ginei; “Yem wat usam yaun ebe giengk Mose ane kapia ok ite me? Ebe gipil yev ebe meng-gihlang nangge ei natunatu aplo bemem yev gen ei etok ite ok? Ve yaun etok ginei dang-eteik: Pomate ginei gitangi Mose be ginei; ‘Ablaham gabu Isak be Jakob as Pomate ayeu!’ ");
INSERT INTO kbm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pomate gili eisir ete imat vunu ok ginei imbweg matawas, beti ei ginei; ‘Eisir ete imbweg matawas ok ge as Pomate ayeu.’ Be yem unei yaun etenok gitlek molge.” ");
INSERT INTO kbm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Gidung ebe emb Mose ane yaun dabin ok as amol ti giute yaun etok be gili Yisu ebe ginei yaun avo vie-ngge gitangi eisir Sadukai ok, beti ei gitangi Yisu gile ve niutani ei be ginei; “Pomate ane yaun ake inend ete vie molge gitlek yaun subu subu?” ");
INSERT INTO kbm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Be Yisu ginei gitangi ei be ginei; “Yaun ebe vie molge ok eteik ebe Moses giro bwalbwale ok. Be yaun nok ginei dang-eteik: ‘O Israel, Unaute kob! Eitit and Pomate dongke-ngge ei Pomate ano. ");
INSERT INTO kbm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Be mie tam nivin am Pomate tis aplom be dabem gwet be tis am gwangne tepwengge.’ ");
INSERT INTO kbm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Be yaun ake ti vukuri ebe vie molge ok eteik: ‘Tam nivin am nune-nggen weik ete mie ate tam givin imate ok.’ Be yaun ti vie molge gitlek yaun ailu etenik ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bekob amol nok ginei gitangi Yisu be ginei; “Gidung, Bingano, mie gunei yaun ano. Ve Pomate ei dongke-ngge ei Amol Bamo be amol ti ebe bamo weik ei ok givang ite ma yapin. ");
INSERT INTO kbm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dang etok be eitit tand nivin ei tis aplond be daband gwet be and gwangne tepwengge. Be tand nivin and nune-nggen dang ete tand givin itate ok. Eitit amolmol tamb da gitangi Pomate etok vie. Bemem ginei eitit tansov yaun ailu etok ane lu vie-ngge nivin atob vie molge nitlek.” ");
INSERT INTO kbm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yisu giute amol nok ebe ginei yaun vie-ngge ok be ginei gitangi ei; “Gibloblo ve Pomate nemb mie dabin.” Yaun etok ma gikwai, bekob ete amolmol ipelk be inautani Yisu vukuri ve gen ti ane ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Givin ebe Yisu givang lum yamar aplo ok be ginei gitangi amolmol be ginei; “Gidung mateu ane t ane bambamo-nggen. ");
INSERT INTO kbm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bemem ayeu nanei nitangi yem: Pomate ane Ngalau Yamar geb Dawit avut be ginei; Pomate ginei gitangi awangg Amol Bamo ebe ve nemb amolmol dabin ok dang-eteik: ‘Umbweg umbloblo ayeu ge love ayeu natak amolmol ebe ve ines valir nitangi mie ok tepwengge insov miam gwangne ane lu inde kob.’ ");
INSERT INTO kbm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Be Yisu ginei, Ginei Dawit ei ate nital amol etok ninei awangg ‘Amol Bamo’ okob atob amol nok menihlang nangge Devit ane vaku namnambed?” Amolmol iute Yisu ane yaun be tas vevias anongge ve Yisu ginei yaun tis dabe gwet ge. ");
INSERT INTO kbm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisu gibul amolmol givang be ginei gitangi eisir be ginei; “Undi aimate-ngge ve gidung subu emb Mose ane yaun dabin ok. Eisir iro kambam undib bambamo be ivang amolmol nas gilkili nangge taku ebe amolmol iro isate sut isov ok veik amolmol indi eisir be inei eisir tis ares be avos nivwat eisir ares. ");
INSERT INTO kbm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Be ginei eisir as kasa ti nangge lum mateu ane aplo atob eisir nok inde inambweg as atane-ngge, be nangge taku ebe ilgum ben bambamo ok givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eisir nok ilgum ve inggas avie gaptol ebe aruas-gen imat ikwai is ok as nam be ivaina as mone, bekob isum as tiate etok ve es miengk undib molge veik amolmol indi be inei eisir amolmol mateu ane roro. Eisir etok atob nindeb mulane atob in-gas vavavne bamo molge.” ");
INSERT INTO kbm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisu gisov lum yamar aplo gile be gibweg gibloblo nam aplo mone ane be na giengk amolmol ebe itak itak as mone gisov ting mone ane ok. Be amolmol anongge ebe tis mone bamo ok itak as mone bamo gisov ting mone ane gile. ");
INSERT INTO kbm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bemem avie tupe ti ei ane mone mwele natu ailu gili ge giengk, bemem ei gitak ane mone nok tepwengge gisov ting aplo gile. ");
INSERT INTO kbm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bekob Yisu gital ane singamolomb-gen ipil dongke be ginei gitangi eisir be ginei; “Ayeu nanei nitangi yem, avie tupe etok gitak ane mone tepwengge gisov ting da ane gile gitlek eisir subu, ");
INSERT INTO kbm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ve eisir subu emb as mone be tavlu giengk ve eisir as mone bamo. Bemem avie tupe etok ei ane mone bamo ite bemem geb ane mone nok tepwengge gile be ti giengk ite.” ");
INSERT INTO kbm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisu nangge lum yamar aplo be meng-gihlang kob ete ane singamolomb ti gile ginei gitangi ei be ginei; “Gidung, tauli nam bamo etok ebe ipasang ve vat vevies ge ok.” ");
INSERT INTO kbm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Be Yisu ginei gitangi ei, “Nam bamo etok ane gen vevies tepwe ete ande guli nik, asonge vat nam etok ane ti nivarkei lavo ite ma. Asonge tepwengge tiate be nes ulur love ma.” ");
INSERT INTO kbm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisu gile gibweg matendubi ebe ei oliv givarkei ok, be na gile gipil taku ebe lum yamar givarkei ok. Bekob Pita gabu Jems be Jon gabu Endru itangi ei ile be inei; ");
INSERT INTO kbm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Unei lavo itangi amei kob. Gen ete galkik mie gunei ane yaun ok asger kob menihlang. Be gen ret atob nes gen bambamo ete ve tiate ok ru nitangi amei nimungg veik andi be anatpweng are?” ");
INSERT INTO kbm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bekob Yisu gibul eisir be ginei; “Gaptol unemb aim ate dabin vie-ngge, velob amolmol subu inme be inyo inyo aim. ");
INSERT INTO kbm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Asonge amolmol anongge inme be ital ayeu arengg nipil is ate be inei ‘Ayeu nok etenik,’ okob atob inro amolmol anongge aplos vukir. ");
INSERT INTO kbm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ginei yem ute valir ebe giengk taku undib undib ok be tis taku ebe gibloblo yem ok binge, okob atengg-aim nireu be unkur-kuri bwaya. Ve gen dangetok ok atob menihlang bemem nalk tis gulumb ane as-mate ite nangge. ");
INSERT INTO kbm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mulane kob atob nam dabe ti inamdil be ines valir nitangi nam dabe ti, be atob gikuri nes nangge nam dabe subu, be amolmol atob marav nes is nemb taku avwut. Gen etok atob menihlang nimungg be ane vavavne atob weik ebe avie gaptol ve inkuv nunus ok. ");
INSERT INTO kbm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dang etok be unemb aim ate dabin vie-ngge, ve atob amolmol intak yem unvarkei amolmol bambamo nas, be ines yem nangge lum mateu ane aplo. Be atob intak yem unvarkei amolmol bambamo nas ve awangg kulkul ane, kob atob yem unei awangg yaun nitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Be Pomate ane yaun atob nivang nemb taku walang ok avut be amolmol inaute nimungg. ");
INSERT INTO kbm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Be ginei nivin ete amolmol ve inme in-gas yem unde be inautani aim ve unei aim yaun lavo ok, okob aplongg-aim bunam be unpelk bwaya. Ve atob Ngalau Yamar nemb yaun ete yem ve unei ok nitangi yem be unei. ");
INSERT INTO kbm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Be amolmol atob tas nitung as male-nggen ite be atob inemb eisir intangi amolmol valir ane be ines eisir vunkunu. Be atob amolmol inalgum weik etok ge nitangi natus-gen, be atob natus-gen bwais ve tamas-gen tis tinas-gen. ");
INSERT INTO kbm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Amolmol tepwengge atob bwais ve yem ve awangg kulkul ane. Bemem amol ti ginei niro ate ta be ninggas vavavne be ta nitung ayeu painge love gen bunam bamo etok ma ge, atob Pomate ninggas ei be nimbweg vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Be atob yem undi Sadam ane gen tiate bamo ti atob nisov lum yamar aplo nile nivarkei. (Yem unsam yaun etenik be tangg-aim nitung vevie-ngge). Amolmol ebe imbweg Juda as taku ok atob inpelk inreu matendubi dubi inde. ");
INSERT INTO kbm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Be ginei gen bunam etok meng-gihlang, be yem umbweg ve kakie umbweg ebe aim nam luvwe ok, okob yem gitangi ebe atob undumul unsov aim nam aplo unde vukuri ve unvwat aim gen ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Me ginei yem uvang ebe aim um aplo ok, okob tanggaim nitung ve undumul unde aim nam ok ve unvwat kambam tis kup ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nivin sawa etok atob avie gaptol ebe tis subwas ok be tis avie gaptol ebe emb rur ve natus-gen ge nangge ok, atob in-gas vavavne bamo molge. ");
INSERT INTO kbm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dang etok be yem unes miengk gwangne ge nitangi Pomate veik gen bunam etok menihlang tis ebe urwemb ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nivin sawa etok atob amolmol tepwengge in-gas tiate. Givin ebe Pomate geb nalk tis gulumb vaku ge ok be painge love galkik as mate etenik, gen bunam ti dang etok meng-gihlang ite ma. Be asonge nindeb mul ane ok atob gen bunam ti vukuri dang-etenik menihlang ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ginei Pomate nes gen bunam etok gili ite atob amolmol tepwengge in-gas tiate be inmat vunkunu be ma. Bemem gisov amolmol ebe Pomate geb is gikwai ve ane gen ane ok ge, beti atob ei nes gen bunam bamo etok gili seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ginei sawa etok amol ti ginme be ginei gitangi yem be ginei, ‘Taundi e, Amol (Kilisi) ebe Pomate gihlin ginme ve nemb eitit dabin ok ande ginme,’ be ginei amolmol subu inei, ‘Ei meng-gihlang nangge taku etok.’ Okob aplongg-aim nivin eisir as yaun ite. ");
INSERT INTO kbm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ve atob amolmol anongge inme be inei yaun bingkas kasop nitangi yem be inei; ‘Ayeu Amol (Kilisi) ebe ve namb amolmol dabin ok’ me ‘ayeu amol (propet) ebe ganei Pomate avo ukwas vusa ok.’ Be atob inalgum gen bambamo be tis gen bwalbwale walang ano. Be ginei gitangi, okob atob inro Pomate ane amolmol-gen ok aplos vukir nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dang etok be unemb aim ate dabin vie-ngge. Ande ayeu ganei gen bambamo ebe asonge menihlang ok tepwengge binge gitangi yem gimungg gikwai. Be unpasang aim ate yapin ve gen bunam ete ve ninme ok ane.” ");
INSERT INTO kbm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Gen bunam etok nile ma nikwai kob atob as matano niro vie ite, be aiweng ok atob niro ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Be gen gwangne gwangne tepwe ebe giengk gulumb ok atob gigikie ge be viteukawe atob bingbleng. ");
INSERT INTO kbm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Be nivin sawa etok atob amolmol indi Pomate Natu ayeu atob nambweg nasov umbim aplo be nanumul nanme tis Pomate ane gwangne be ane bogbogo. ");
INSERT INTO kbm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atob ayeu nahlin angg angela be invang itangi nalk ane kuni walang ok be inro awangg amolmol ebe aplos givin ayeu ok sut inpil dongke. Atob angela invang love inambielk ebe gulumb tis nalk ane den ok be inro eisir etok tepwengge sut.” ");
INSERT INTO kbm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Be Yisu ginei; “Ayeu nanei bing-ai ti nipil ei-ambla viek yem unatpweng are: Ginei yem uli ei-ambla lan ges ulur be ningge gireu vukuri atob yem unatpweng are unei asausa ande gibloblo tepwe. ");
INSERT INTO kbm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Dang etok be asonge ginei yem uli gen bambamo ete galkok ve menihlang, okob tangg-aim nitung sawa ebe ayeu ve nanumul nanme ok ande gibloblo tepwe.” ");
INSERT INTO kbm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yisu ginei yaun etok gitangi eisir be ginei; “Amolmol subu ete ande imbweg nik atob inmat vunu ite love gen walang etok menihlang bekob. ");
INSERT INTO kbm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gulumb tis nalk atob ma nikwai, bemem awangg yaun atob niengk dang etok be niengk.” ");
INSERT INTO kbm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Amol ti gitpweng sawa ebe Yisu ve ninumul inme ok are ite ma. Angela tepwengge ebe ivang gulumb ok inini, be Ayeu ate ok ganini weik etok ge. Tamangg ei ate ge gitpweng sawa ebe ve niyaing gen tepwengge nangge nalk be gulumb nikwai ok are. ");
INSERT INTO kbm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dang etok be unemb aim ate dabin vie-ngge, ve yem unini sawa ebe ayeu atob nanumul nanme ok. ");
INSERT INTO kbm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ayeu ve nanei bing-ai ti nitangi yem nipil amol ti ebe geb ane nam be tis ane gen walang ok gitangi ane amolmol kulkul ane ve inemb dabin ok. Ei geb kulkul walang ok gisov amolmol dongke dongke bais gitangi ge. Be givin ebe nam tivie gimdil gile ve nivang taku undib ge ti ok, be ei ginei gitangi ane amol kulkul ane ti ve nemb ei ane nam dabin, bekob gile ve givang. Be amol nok ta gisgil sawa ebe atob nam tivie ninumul ninme ok. ");
INSERT INTO kbm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dang etok be yem unambweg matanongg-aim sang sangas be nangg-aim niengk nam tivie ge. Yem unini, atob nam tivie nimbielk vukuri nivin sawa inend. Ayeu atob nalek tis gibok, me tambok luvwe, me ayeu atob nalek tis ebe kavkavav giteng ok me tistumi. ");
INSERT INTO kbm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Me ginei ayeu galek gakuri yem ge, okob ayeu bwaingg ve ret nali yem unambweg weik amolmol ebe ande iengk ikwai ok. ");
INSERT INTO kbm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ayeu ganei yaun etenik gitangi yem, be ganei gatangi amolmol walang ok givin weik etok ge. Gaptol unambweg be unasge ayeu ge.” ");
INSERT INTO kbm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Givin sawa etok bambamo subu ebe emb kulkul da ane nangge lum yamar aplo ok, be tis eisir ebe emb Mose ane yaun dabin ok, irek luev ebe ve ines Yisu vunu ok. Eisir ilgum ve inei invwaivun gen etok ge ve amolmol. Be givin sawa etok ande as-mate ailu ge giengk ebe ve eisir inalgum as ben bamo ebe ital inei Pasova ok, be atob amolmol tepwengge inro isate sut insov Jerusalem dongke-ngge inde. Eisir Yuda ital ben bamo etok inei Pasova ve eisir tas gitung as bambamo-ngen ebe warik Pomate ane ngalau kulkul ane (angela) ges eisir ite be ges amolmol Aigipten ane ge vunkunu ok, beti eisir ilgum ben bamo etok. ");
INSERT INTO kbm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Beti eisir bambamo nok inei ve is ate be inei; “Wali atob eitit tanalgum nam-nambed veik tanemb amol etenik ta be tanes ei vunu nikwai? Bekob inei, eitit tanes Yisu vunu nivin ete ve tanalgum ben Pasova ane ok bwaya, ve atob amolmol inamdil be ines eitit.” ");
INSERT INTO kbm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Givin sawa etok Yisu gibweg nangge Betani, ei gibweg amol ti ane nam, amol nok ebe warik gigas bid namvu ok are Saimon. Be givin ebe eisir tis Yisu en ben imbweg ok, be avie ti givwat marasin ukwas ti gisov gen mate ti be marasin nok ane mone bamo molge. Avie nok gitangi Yisu gile be ges gen mate ane gao ponge be gimsuli marasin ukwas etok gisov Yisu dabe. ");
INSERT INTO kbm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Be amolmol subu ebe imbweg imbloblo etok ok ili be tas vavis anongge be inei ve isate, “Ei gikari mone bamo molge gipil marasin ukwas etok bekob giyaing ve ret ane? ");
INSERT INTO kbm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ginei tanemb nitangi amolmol be inavgo atob ane mone bamo molge nitlek K300, be tanemb mone etok nitangi amolmol ebe gen ma ve is ok.” Be eisir inei yaun ungglus ungglus gipil avie nok. ");
INSERT INTO kbm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bemem Yisu ginei gitangi eisir be ginei; “Unggo ei bwaya, ve ei gilgum gen ukwas vie molge etok gitangi ayeu. ");
INSERT INTO kbm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yem asonge unemb amolmol ebe gen ma ve is ok dabin unvang nitangi ebe yem tangg-aim givin ok nemb ta ge. Bemem ayeu wat navang navin yem nemb ta ge ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Be avie etenik gilgum gen gitangi ebe ei ta gitung ve nilgum ok ete ande gilgum gikwai nik. Ei gimsuli marasin ukwas etok giwei ayeu utlangg ulis ve nipasang ayeu utlangg ulis taku gimat ane yapin.” (Yuda as luev giengk dangetok ve ginei amolmol inmat vunu, atob eisir inamsuli marasin ukwas etok nireu amolmol ete imat vunu ok utlas ulis, veik inyengk be utlas nipiel ite). ");
INSERT INTO kbm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Ayeu nanei bingano ge nitangi yem. Awangg yaun atob amolmol inei nemb taku avut, be avie etenik ane yaun ok atob nemb taku avut nivin veik amolmol insam be tas nitung ei nivin.” ");
INSERT INTO kbm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Givin sawa etok ete eisir singamolomb 12 etok as amol ti are Judas Iskariot gitangi bambamo ebe emb kulkul da ane ok gile ve ninei ebe atob nitak Yisu nisov eisir bais ok lavo nitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Amolmol bambamo ebe emb kulkul da ane ok iute Judas Iskariot ane yaun be tas vevias ge, be eisir tas gitung ve inemb mone subu ve ei. Beti Judas Iskariot nok ta gitung ve ginei nili sawa vie-ngge ti okob ninei Yisu binge nitangi amolmol valir ane. ");
INSERT INTO kbm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Givin ebe amolmol ve inalgum ben bamo ebe ital inei Pasova ok, ve eisir tas gitung tumbus-gen ebe warik Pomate ane ngalau kulkul ane ges is ite ok. Beti amolmol es bwelk sipsip vunkunu ve inalgum ben, be eisir singamolomb ile inei gitangi Yisu be inei; “Mie tam givin gunei atob amei anpasang eitit and ben nangge nam inend?” ");
INSERT INTO kbm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Beti Yisu gihlin ane singamolomb-gen ailu ve inmungg inde inahlang ebe Jerusalem ok be ginei gitangi sulu be ginei; “Yemlu unde unahlang nam ok be atob undi amol ti atob nivwat bui nisov ul bamo ti, be gabu untaumul amol nok unde. ");
INSERT INTO kbm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Be nam ete atob amol etok nile nipil ok, okob gabu unautani nam tivie be unei; ‘Ameimei gidung ginei wali nam aplo ebe atob ei tis ane singamolomb-gen inen ben Pasova ane inambweg ok giengk inend?’ ");
INSERT INTO kbm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kob atob nam tivie ninggas yemlu unde be nes nam aplo ti ebe giengk ei goto ane ok ru nitangi yemlu. Be nam aplo nok nam tivie gipasang love vie yapin, be gabu unpasang eitit and ben nangge nam aplo etok.” ");
INSERT INTO kbm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Beti eisir singamolomb ailu nok imungg ile ebe Jerusalem ok be gabu ili gen walang ok gitangi ebe galkik Yisu ginei gitangi sulu yapin ok, be gabu ipasang ben Pasova ane nangge nam aplo etok. ");
INSERT INTO kbm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Givin gibok okob Yisu tis ane singamolomb-gen imbielk ve sulu ailu ebok nangge nam nok. ");
INSERT INTO kbm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eisir singamolomb 12 etok tis Yisu en ben imbweg, be Yisu ginei gitangi eisir be ginei; “Ayeu nanei bingano-ngge nitangi yem. Yem aim amol ti atob ninei ayeu binge nitangi amolmol ebe ve ines ayeu vunu ok, amol etok ete eilu amei gabu an ben gisov dongke ok.” ");
INSERT INTO kbm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eisir singamolomb iute yaun etok love aplos bunam molge be emb isate dongke dongke itangi Yisu ile be iutani ei be inei; “Mie tam gitung gunei atob ayeu nalgum me?” ");
INSERT INTO kbm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Be Yisu giwel eisir avos be ginei; “Amol ti ete gibweg gisov yem aplo nik, amol etok eilu an ben gisov dongke. ");
INSERT INTO kbm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bingano, Pomate Natu ebe meng-gihlang weik amolmol ok atob nimat vunu nitangi ete warik Pomate ane amolmol kulkul ane inei atob ei nimat vunu ok. Bemem amol ete ve ninei Pomate Natu Ayeu binge nitangi amolmol valir ane ok likok e. Atob likok ninggas tiate molge. Gen etok vie ve amol nok tine nikuv ei bwaya ma!” ");
INSERT INTO kbm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yisu tis ane singamolomb-gen en ben imbweg, bekob Yisu geb ben siti be ges miengk gitangi Pomate bekob gible ben etok vusvusa be gbiwas gitangi ane singamolomb-gen be ginei; “Monemb ilek unen. Etenik weik ebe ayeu virongg ok.” ");
INSERT INTO kbm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bekob geb wain tis kap be ges miengk gitangi Pomate bekob geb gitangi eisir tepwengge be inum. ");
INSERT INTO kbm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bekob ginei gitangi ane singamolomb-gen be ginei; “Wain etenik weik awangg twerk. Awangg twerk atob nimsuli ve nisin amolmol tepwengge as tiate nikwai. Be awangg twerk nok atob nilgum Pomate ane yaun ebe warik gibiti ok ano nile. ");
INSERT INTO kbm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ayeu nanei bingano-ngge nitangi yem, atob ayeu nanum wain etenik vukuri ite, love Pomate nemb amolmol dabin nangge ane taku, okob atob ayeu nanum wain vaku etok nangge Pomate ane taku.” ");
INSERT INTO kbm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yisu tis ane singamolomb-gen inei uye mateu ben ane ti gikwai kob imdil ile ihlang be ile ireu matendubi ebe ei oliv anongge givarkei ok ile. ");
INSERT INTO kbm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisu ginei gitangi ane singamolomb-gen be ginei; “Atob tambok etenik, atob yem tanggaim nitung ayeu ite, be atob tepwengge bwaingg-aim ve ayeu. Atob yem unalgum weik yaun ti ebe warik Pomate geb gitangi ane amol yaun ane ti are Sakarias be ginei vusa ok. Ve Sakarias ginei dang-eteik: ‘Atob ayeu nas bwelk sipsip as amol ebe geb eisir dabin ok vunu, kob atob bwelk sipsip nok inpelk inriv be inra nangge taku walang ok.’ ");
INSERT INTO kbm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Be Yisu ginei; Bemem atob ayeu namdil vukuri nangge taku gimat ane, be atob namungg nale Galilaia ok bekob yem.” ");
INSERT INTO kbm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Be Pita ginei gitangi Yisu be ginei; “Eisir tepwengge atob bwais ve mie bemem ayeu wat bwaingg ve mie ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yisu ginei gitangi Pita be ginei; “Ayeu nanei bingano-ngge nitangi mie nanei, Atob tambok etenik atob kavkavav niteng bulwer ailu ane ite nangge be atob amolmol valir ane inautani mie ve ayeu ane kob atob mie nos ayeu arengg ta be nunei, ‘Ayeu ganini amol etenok’ nitangi bulwer aitol.” ");
INSERT INTO kbm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bemem Pita giwel Yisu avo be ginei gwangne molge ginei; “Ayeu ganei yaun ano ganei ayeu atob namat vunu navin mie. Be ayeu wat nas mie arem ta ite ma yapin.” Be eisir singamolomb tavlu ok inei yaun weik ete Pita ginei ok. ");
INSERT INTO kbm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yisu tis ane singamolomb-gen imbielk taku ti are Getsemani, be Yisu ginei gitangi ane singamolomb-gen be ginei; “Unambweg etenik, be ayeu ve nale nas miengk.” ");
INSERT INTO kbm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Be gigas Pita gabu Jems be Jon ivin ei be ile. Yisu aplo bunam molge ");
INSERT INTO kbm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","be ginei gitangi sotol be ginei; “Ayeu ande aplongg bunam tiate molge be gitangi ginei namat vunu ge nakwai. Be gaptol unambweg nangg-aim sang sangas unambweg etenik.” ");
INSERT INTO kbm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yisu givang siti gile be gikari ate gile gitak nalk be ges miengk ve ginei gitangi okob ei ninggas gen bunam etok bwaya. ");
INSERT INTO kbm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yisu ges miengk dang-eteik ginei; “Tamangg, mie gitangi nulgum gen walang ok be ano nile. Dang etok be ayeu tangg givin ganei mie nuitin gen bunam eteik nikwai ayeu. Bemem mie nuvang mul ve awangg tangg givin ite ma. Mie nulgum nitangi ete mie ate am tam givin ok.” ");
INSERT INTO kbm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yisu gilumul gile be gili ane singamolomb-gen aitol ebok ande iengk, be Yisu ginei gitangi Pita, “Saimon, mie guengk e? Mie gitangi ebe atob numbweg matanom sang sangas nitangi as matano sawa dongke-ngge ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bekob gine ve sotol tepwe be ginei; “Unyengk bwaya be unes miengk veik yem unsov gen tiate etok aplo unvin ite. Yem tanggaim givin ve unalgum gen dangetok, bemem matanongg-aim giengk beti gilgum be utlangg-aim bua.” ");
INSERT INTO kbm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Be Yisu gilumul gile ve nes miengk vukuri be ginei yaun ebe galkik ginei gimungg ok vukuri. ");
INSERT INTO kbm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bekob gilumul gitangi ane singamolomb-gen gile vukuri be gili sotol ande iengk, sotol matanos bunam beti iengk, be tas gisgil yaun ebe ve inei nitangi Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yisu gile ve nes miengk vukuri bekob gilumul ginme be ginei gitangi ane singamolomb-gen aitol nok be ginei; “Ande uyengk be uyap gitangi, be tande be tandi ve atob amol ebe ve ninei ayeu binge ok, atob ninggas Pomate Natu ayeu natangi amolmol valir ane nale. ");
INSERT INTO kbm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Unamdil be tale. Taundi e, amol ebe ve ninei ayeu binge ok ete ginme nik.” ");
INSERT INTO kbm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisu ginei yaun nangge be Judas Iskariot gibielk. Judas Iskariot nok ei Yisu ane singamolomb ti gibielk. Be bambamo ebe emb kulkul da ane dabin ok be tis gidung ebe emb Mose ane yaun dabin ok be tis amolmol ebe ilgum amolmol as yaun ok emb amolmol valir ane dubi bamo ti. Be ivang ivin Judas Iskariot nok be ivwat kumungg tis buyag valir ane givin givin. ");
INSERT INTO kbm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Be Judas Iskariot ande ginei gitangi amolmol valir ane yapin be ginei; “Tande be undi amol ete ayeu ve nasavi ei ok, ok-ti amol nok etok ebe yem tanggaim givin ok be unadgin ei bage ta be ungas unde.” ");
INSERT INTO kbm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Givin ebe Judas Iskariot gibielk ok, ei gitangi Yisu gile be ginei, “Gidung.” be gisavi Yisu bage, ");
INSERT INTO kbm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","be amolmol valir ane bais gisov Yisu be emb ei ta love gwangne. ");
INSERT INTO kbm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bemem amol ti ebe givang givin Yisu ok bage gisov ane buyag valir ane be ges amol bamo ebe geb kulkul da ane nangge lum yamar ok ane amol kulkul ane ti talngelan tavlu gili. ");
INSERT INTO kbm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bekob ete Yisu geb avo ponge be ginei gitangi amolmol valir ane be ginei; “Yem unme ve un-gas ayeu be uvwat buyag valir ane tis kumungg givin givin weik ebe ve un-gas amol vaina ane ti ok ba. ");
INSERT INTO kbm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","As mate walang ok ayeu gabweg gavin yem nangge lum yamar bambamo aplo be yem omb ayeu ta ite ve ret ane? Bemem galkik atob yaun ebe warik Pomate ane amolmol kulkul ane inei ok atob ano nile.” ");
INSERT INTO kbm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Be eisir singamolomb ikwai Yisu be ipelk ile ve ivang. ");
INSERT INTO kbm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Be amol ti giro babal ge be givarkei be gili ebe amolmol valir ane inggas Yisu be ile ok, beti ei gitaumul eisir gile, be amolmol valir ane ilgum ve inemb ei ta, ");
INSERT INTO kbm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bemem emb ei ane babal ge ta be ei gipelk be ve nituvki beti ane babal beleinge gile gitak, be gituvki tis tavo rial ge ve gile. ");
INSERT INTO kbm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Amolmol valir ane inggas Yisu itangi amol bamo ebe geb amolmol da ane subu dabin ok ane nam ile, be amolmol ebe emb kulkul da ane ok be tis gidung ebe emb Mose ane yaun dabin ok be amolmol bambamo ebe ilgum amolmol as yaun ok iro isate sut ile, ve inalgum Yisu ane yaun. ");
INSERT INTO kbm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita gitau gile eisir, bemem ei givang aikawe kasop gege. Ei gisov amol bamo nok ane simbel aplo bwaya gege gile gibweg gibloblo yev. ");
INSERT INTO kbm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Be amolmol ebe emb kulkul da ane ok tis eisir ebe ilgum amolmol Juda ane as yaun ok ilgum yaun bamo molge gipil Yisu. Eisir ilgum ve indi Yisu ane tiate ti ebe gilgum ok veik ines ei vunu, bemem ilgum be ili ma. ");
INSERT INTO kbm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Amolmol anongge inei yaun bingkas kasop walang ano gipil Yisu bemem eisir as yaun bambamo etok gitangi ate ite ma. ");
INSERT INTO kbm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bekob amolmol subu imdil be inei as yaun bingkasop ti gitangi amolmol ebe ve inatpweng yaun are ok be inei; ");
INSERT INTO kbm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amei aute Yisu ginei asonge ei niyaing lum yamar ebe amolmol ipasang ok nikwai bekob atob nipasang lum yamar nok ti vukuri, be atob weik ete amolmol ipas-pasang ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bemem yaun walang ete eisir inei ok ano ite, be eisir ilgum yaun gitlek ate painge-ngge. ");
INSERT INTO kbm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bekob amol bamo ebe geb eisir da ane subu dabin ok gimdil givarkei amolmol tepwengge nas be giutani Yisu be ginei; “Miam yaun ti giengk ebe ve nuwel yaun bambamo ete amolmol emb gitangi mie gilek ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bemem Yisu tumi-ngge be ginei yaun ti ite. Be amol bamo nok giutani Yisu vukuri be ginei; “Mie amol etenik ebe ve nomb amolmol dabin ok me? Be Pomate Natu mie me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yisu giwel amol nok avo be ginei; “Ayeu ate nok eteik. Be bwayage kob atob yem tepwengge undi Pomate Natu ayeu ebe meng-gahlang weik amolmol ok atob nambweg nambloblo Tamangg ebe ane gwangne gitlek gwangne walang etenik ok. Be atob ayeu nambweg nasov umbim aplo be nanumul nanme. ");
INSERT INTO kbm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Amol bamo nok ande ta vavis anongge be gisiel ei ate ane kup be ginei; “Eitit tanautani amolmol subu ebe ve inei Yisu ane yaun ok vukuri ite, ");
INSERT INTO kbm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ve ande yem ute yaun ungglus ungglus ebe ei ginei gipil Pomate ok gikwai. Be yem tanggaim gitung nam-nambed?” Be amolmol tepwengge inei Yisu ane yaun dangeteik, “Ei gilgum gen tiate be tanes ei vunu nikwai.” ");
INSERT INTO kbm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bekob ete amolmol subu iluk gireu ei, be isum ei matano avwut ve babal be es ei be inei; “Unei itangi amei kob, unei amol ret ete ges mie nik?” Be amolmol valir ane inggas ei ile be ivtav ei. ");
INSERT INTO kbm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita gimwailuv yev gibweg nam etok ane lu, be amol bamo ebe geb kulkul da ane ok ane avie kulkul ane ti ginme, ");
INSERT INTO kbm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","be gili Pita ebe gimwailuv yev gibweg ok be na giro Pita ta be ginei; “Mie amol ti etenik ebe guvang guvin Yisu Nasaret ane ok?” ");
INSERT INTO kbm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bemem Pita ginei “Iye! Ayeu ganini amol etenok. Be ayeu tangg gisgil yaun ete mie gunei nok.” Be Pita givang gile gihlang be kavkavav giteng bulwer mate ane. ");
INSERT INTO kbm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bekob avie kulkul ane galkok gili Pita be gile ginei gitangi amolmol ebe ivarkei imbloblo ei ok vukuri be ginei; “Yisu ane amol ti etenok mera?” ");
INSERT INTO kbm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bemem Pita ginei vukuri gitangi eisir be ginei; “Ayeu tangg gisgil amol etenok.” Be bwayage kob amolmol ebe ivarkei imbloblo ei ok inei, “Bingano molge, mie Yisu ane amol ti ve mie amol Galilaia ane ti etenik.” ");
INSERT INTO kbm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Be Pita ginei gwangne molge be ginei; “Bingano molge. Ginei ayeu nanei yaun bingkasop okob Pomate nes ayeu vunu nikwai. Ayeu tangg gisgil amol ete yem unei ane yaun nok.” ");
INSERT INTO kbm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Be kavkavav giteng ti vukuri be Pita ta giro yaun ebe warik Yisu ginei gitangi ei ok, “Ve atob kavkavav niteng bulwer ailu ane ite nangge, be atob mie nos ayeu arengg ta nitangi bulwer aitol.” Be Pita gile be giteng anongge. ");
INSERT INTO kbm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Givin tistumi-ngge bambamo da ane be tis amolmol yaun ane subu be tis eisir ebe emb Mose ane yaun dabin ok be amolmol ebe ilgum amolmol as yaun ok, ilgum yaun ve inei inadgin Yisu ta ve seng be in-gas ei intangi Pilata inde. ");
INSERT INTO kbm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilata giutani Yisu be ginei; “Mie amol bamo ebe gob amolmol dabin nangge Juda ok etenik me?” Be Yisu giwel Pilata avo be ginei; “Yaun nok ete ande miate gunei nok.” ");
INSERT INTO kbm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Be bambamo da ane ilgum yaun bingkas-kasop walang ano gipil ei. ");
INSERT INTO kbm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Be Pilata giutani ei vukuri be ginei; “Amolmol inei yaun bingkasop anongge gipil mie, bemem mie guwel eisir avos ite ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bemem Yisu ginei yaun ti ite be tumi ge givarkei. Beti Pilata ta gitung walang ano ve gili ebe Yisu ginei yaun ti ite be tumi ge givarkei ok. ");
INSERT INTO kbm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Givin Sonda bamo walang ok Juda ilgum as ben bamo ti ebe tas gitung as bambamo-nggen as natus gen ebe warik angela es eisir vunkunu ite ok, be Pilata atob nihlang amolmol kapual-lu ane ti be nitangi amolmol nile gitangi ebe amolmol eisir ate as tas givin ok. ");
INSERT INTO kbm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Be givin sawa etok ete amol ti gibweg nam kapual-lu ane givin, amol nok are Barabas. Ei gibweg kapual-lu ve gisov ei ok gibweg givin amolmol ebe ilgum yaun ve inaitin Rom as amol bamo ebe geb eisir dabin ok nikwai, be eisir es amolmol subu nangge Rom vunkunu givin. ");
INSERT INTO kbm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Be givin ebe amolmol tepwengge iro isate sut ok, be inei gitangi Pilata ve nilgum dang ebe warik gilgum gilgum ok nitangi eisir, ve nihlang amol kapual-lu ane ti be nitangi eisir nile. ");
INSERT INTO kbm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Beti Pilata giutani eisir be ginei; “Yem tanggaim givin kob ayeu nahlang Juda as amol bamo ebe geb eisir dabin ok nikwai kapual-lu be nile.” ");
INSERT INTO kbm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilata gitpweng are ginei amolmol bambamo ebe emb kulkul da ane ok tas vadbu ve ili ebe amolmol tas givin Yisu anongge gitlek eisir ok beti ilgum yaun bamo etok sin-gege gipil Yisu. ");
INSERT INTO kbm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bemem bambamo da ane inei gisov amolmol be gilgum amolmol be tas vavis anongge be inei gitangi Pilata ve nihlang Barabas nitangi eisir nile. ");
INSERT INTO kbm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Be Pilata ginei gitangi eisir be ginei; “Yem tanggaim givin ve ayeu nalgum ret nitangi amol ebe yem utal unei amol bamo ebe geb yem dabin ok?” ");
INSERT INTO kbm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Be amolmol tepwengge ital avos bambamo ge be inei; “Nos ei nireu ei givsangin!” ");
INSERT INTO kbm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bemem Pilata ginei; “Ei gilgum gen tiate ret?” Be amolmol tepwengge ital avos bambamo ge vukuri be inei; “Nos ei nireu ei givsangin!” ");
INSERT INTO kbm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilata gilgum ve nilgum amolmol aplos vie ane beti gihlang Barabas gitangi eisir gile. Be geb Yisu gitangi amolmol valir ane gile ve inrau ei bekob ines ei nireu ei givsangin nile. ");
INSERT INTO kbm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Amolmol valir ane inggas Yisu isov amol bamo ebe geb amolmol dabin ok ane simbel aplo ile, be iro amolmol valir ane tepwengge sut ile ipil dongke. ");
INSERT INTO kbm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bekob ise molok gile Yisu be inggolong ei weik amol bamo (king) ti be iro kambam mwele ti gile ei be ipasang gululung ti ve wal duduli be es gisov Yisu dabe gile. ");
INSERT INTO kbm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","bekob imdil be itle dabas gitangi ei be inei; “Asmate mie. Mei amol bamo ebe gob Juda dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Be irau gisov ete dabe ok ve bweng be iluk gireu ei, be iro vas dubi supwe gisov nalk gitangi ei. ");
INSERT INTO kbm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Amolmol ilgum gen bambamo etok gitangi ei gikwai kob iwaulu kambam mwele etok gikwai ei be ino ei ate ane kup gireu vukuri be inggas ei ile ve ines ei nireu ei givsangin. ");
INSERT INTO kbm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Amolmol valir ane inggas Yisu ile ve ines nireu ei givsangin be ile vunge ve amol ti are Saimon nangge luev. Ei amol Sairini ane, be natu-nggen ete Aleksanda gabu Rufus ok. Saimon nok givang ve nile nihlang ebe nam ok, beti amolmol valir ane avos girau ei ve nemb Yisu ane ei givsangin ru. ");
INSERT INTO kbm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eisir inggas Yisu ile taku ti are Golgada. Are etok ane dabe dang-eteik: Taku ebe amolmol dabas tulkwe anongge giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amolmol valir ane ve inemb wain tis gen vavis ti nitangi Yisu be ninum veik nile ebe es ei be viti ok ite, bemem Yisu bua ve ret ninum gen etok. ");
INSERT INTO kbm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eisir valir ane es Yisu gireu ei givsangin gile gikwai kob es bwas ve indi inei atob amol ret nivwat ei ane kup. ");
INSERT INTO kbm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","As matano givarkei gitangi bage tavlu be ano aivat (9 kilok) tistumi be amolmol valir ane es Yisu gireu ei givsangin gile. ");
INSERT INTO kbm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Be eisir as luev ti giengk dang etok ve atob inro amolmol as gen tiate ebe es eisir vunu gosov ok bwalbwale niengk ei givsangin den ei goto ane. Beti eisir iro yaun ebe es Yisu vunu gisov ok bwalbwale gireu Yisu ane ei givsangin giengk einggoto ane dang-eteik inei; “Juda as amol bamo ebe geb eisir dabin ok etenik!” ");
INSERT INTO kbm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Be eisir es amol ailu ebe es amolmol vunkunu be ivaina gen ok ireu ei givsangin ivin Yisu, amol ti gikaiwel gideb Yisu bage mol ane be ti gikaiwel gideb bage kase ane. ");
INSERT INTO kbm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Beti yaun ti ebe warik Pomate ane amol yaun ane ti ginei vusa ok ande ano gile Ve yaun nok ginei dang-eteik: ‘Atob Yisu nimat vunu nivin amolmol tiate ane.’) ");
INSERT INTO kbm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Be amolmol ebe ivang ilek be inme ok ile imbloblo Yisu ebe gikaiwel ok, be inei be imalk be ilailai dabas be inei; “Mie amol etenik ebe gunei nuyaing lum yamar bamo ebe givarkei Jerusalem ok nikwai bekob nupasang vukuri nitangi as mate aitol ge ok etenik mera? ");
INSERT INTO kbm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ok omb imate ru be usov motak ukwai ei givsangin ma!” ");
INSERT INTO kbm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Be bambamo ebe emb kulkul da ane ok, be tis gidung ebe emb Mose ane yaun dabin ok, ise molok gile Yisu be inei ve isate be inei; “Ei gitangi ebe ve nilgum amolmol ebe imat ok ge be vias vukuri, bemem gitangi ebe ve nemb ate ru ok ite.” ");
INSERT INTO kbm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eisir ihle ei be inei yaun ungglus ungglus gipil ei dang dang etok be inei; “Mie amol etenik ebe Pomate gihlin gunme ve nomb amolmol dabin ok mera? Be tau usov nangge ei givsangin etenok motak, okob amei andi be aplongg amei nivin mie.” Be amol ailu ebe amolmol valir ane es sulu gireu ei ivin ok inei yaun ungglus ungglus gipil Yisu givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Givin as mate luvwe taku tumi bamo molge geb taku avut, ");
INSERT INTO kbm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","be as matano aitol (3 kilok) givin gibok okob Yisu gital avo bamo ge be ginei; “Eloi Eloi, lama sabatani?” Yaun etok ane dabe dang-eteik: “Pomate, awangg Pomate. Mie ande tam givalngan ayeu ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Be amolmol subu ebe ivarkei etok ok iute be inei; “Taunaute! Ei wat gital Ilaija me?” ");
INSERT INTO kbm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Be amol ti gituvki gile givwat gen mwaimwai ti weik ebe kol gielk ane ok be gile giro utuv gisov bui vavis ti, be gidgin gireu kabut ti be gisu gireu gitangi Yisu avo gile ve ninum, be amolmol subu inei; “Utau be tanvarkei ge be tandi kob ve atob Ilaija ninme be niru ei nangge ei givsangin nisov menitak me ma?” ");
INSERT INTO kbm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bekob Yisu gital yaun avo bamo ge vukuri be gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Be babal bamo ebe gikaiwel lum yamar aplo ok gisiel vusa gile ailu. ");
INSERT INTO kbm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Be amolmol valir ane as amol bamo ebe gitwem is ok givarkei gile gibloblo Yisu ebe gikaiwel ok, be gili Yisu ebe yayai avo bamo be gimat vunu ok, bekob ginei; “Bingano, amol etenik Pomate ane Natu bingano ge!” ");
INSERT INTO kbm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Be avie gaptol subu ivarkei aikawe-ngge be nas gile ili. Avie gaptol nok ti are Malia Magdala, be Jems kuti gabu Josep tinas Malia be Salomi. ");
INSERT INTO kbm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Givin ebe Yisu givang Galilaia ge ok be sotol avie aitol etok itau ile ei be emb ei dabin. Be avie gaptol subu ebe warik ivang ivin Yisu be ireu Jerusalem ile ok ivarkei ivin sotol. ");
INSERT INTO kbm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Givin gibok amol bamo ti nangge Arimatia are Josep ginme. ");
INSERT INTO kbm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ei Juda as amol ti ebe ili ei inei amol vie molge ti ok, be ei ok gisge Amol (Kilisi) ebe Pomate ve nihlin be be ninme ve nemb amolmol dabin ok. Be givin etok eisir ande ipasang isate gikwai ve ebe asongkob Soki be eisir atob inalgum kulkul ti nivin Soki ite ok, ve etok eisir as Sonda. Beti Josep gipelk ite be givang gitangi Pilata gile be giutani ei ve nivwat Yisu utle ulis nile be nispun. ");
INSERT INTO kbm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilata giute ebe ande Yisu gimat vunu ok be gikuri vunungge be gital amolmol valir ane as amol mate ane ti gile be giutani ei be ginei; “Asger Yisu gimat vunu?” ");
INSERT INTO kbm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Be amol nok ginei lavo gitangi Pilata gikwai kob ete Pilata ginei ve Josep ve nile be nivwat Yisu utle ulis. ");
INSERT INTO kbm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep givgo kambam bogbogo vaku ti be gile be geb Yisu utle ulis nangge ei givsangin gisov meng-gitak be gisum ve kambam bogbogo etok. Bekob givwat gile gispun gisov nalk avo ti ebe itav nangge vat bambamo ok. Be gidugdug vat taptape bamo ti gile gisil nalk avo ete Yisu giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Be Malia Magdala gabu Josep tine Malia ili taku ebe Josep gitak Yisu giengk ok givin. ");
INSERT INTO kbm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Amolmol ili Sonda gikwai bekob Malia Magdala gabu Jems tine Malia be Salomi, sotol imdil tistumi ge be ivwat marasin ukwas subu, ebe ivgo ok, be ile ve inro nireu Yisu utle ulis. ");
INSERT INTO kbm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Givin Sonda tistumi ge sotol imdil be ve invang taku gimat ane. ");
INSERT INTO kbm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Be gaptol inei ve isate nangge luev be inei; “Atob ret nemb eitit ru be nindugdug vat taptape bamo etok nikwai nalk avo ebe Yisu giengk ok.” ");
INSERT INTO kbm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(Sotol iutani isate dang etok, ve vat etok bamo molge be sotol gitangi ebe atob indugdug nikwai ok ite). Bekob nas gile be ili vat bamo nok ebe ande gidugdug gikwai nalk avo ebe Yisu giengk ok. ");
INSERT INTO kbm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Be gaptol iwav isov nalk avo ile be ili amol ti gino kup bogbogo ge be gibweg, love ikuri vunu-ngge be ipelk. ");
INSERT INTO kbm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Be amol nok ginei gitangi sotol be ginei; “Unpelk bwaya! Ve Ayeu ande gatpweng yemtol are gikwai. Yemtol urek Yisu Nasaret ane, ebe warik amolmol valir ane es ei gireu ei ok. Bemem ei giengk etenik ite ma. Ei ande gimdil gikwai. Taundi e. Lavo ebe Josep gitak ei giengk ok ande bun. ");
INSERT INTO kbm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Be unde be unei nitangi Pita be tis eisir singamolomb tavlu be unei; Yisu atob nimungg nile Galilaia ok bekob yem. Be atob yem undi ei nangge eteok dang ebe warik ginei gitangi aim ok.” ");
INSERT INTO kbm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Beti sotol ile ihlang ikwai nalk avo be ituvki ile ihlang ikwai taku gimat ane seukie-ngge, ve sotol ikurkuri be ipelk tiate molge. Be inei yaun ti gitangi amolmol ite ve ipelk. ");
INSERT INTO kbm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yisu gimdil tis Sonda tis tumi ge gikwai kob ete Malia Magdala ebe warik Yisu gitin ngalau tiate 7 gikwai ei ok gili ei ulu. ");
INSERT INTO kbm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Bekob gile be gili eisir singamolomb ebe aplos bunam ve Yisu ane be ilgum tangir imbweg ok, be ginei gitangi eisir be ginei; “Yisu ande matawe be gimdil vukuri. Be Ande ayeu gali ei gikwai.” Bemem eisir singamolomb aplos givin Malia ane yaun ite. ");
INSERT INTO kbm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","As mate ailu gile gikwai kob eisir singamolomb as amol ailu imdil be ivang ve ile. Bekob Yisu geb na gile amol ebeok ti be gile gihlang ve sulu nangge luev. ");
INSERT INTO kbm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bekob ete gabu ile be iput yaun etok gitangi eisir singamolomb tavlu, bemem eisir aplos givin sulu as yaun ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bwayage kob givin ebe eisir singamolomb 11 etok en ben imbweg nam aplo ok, okob Yisu ei ate gibielk ve eisir. Be gigo is gisov ebe iute amol be avie ebe ili ei gimdil vukuri ano ok as yaun ite ok. ");
INSERT INTO kbm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bekob ginei gitangi eisir be ginei; “Yem unvang untangi taku walang ok unde, be unbul amolmol tepwengge ve awangg yaun. ");
INSERT INTO kbm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Amol ti ginei aplo givin ayeu ano ge be giringk bui sanggu atob amol etok nimbweg matawe nindeb mulane. Be ginei amol ti aplo givin ayeu ite be giringk bui sanggu ite, atob amol etok ninggas yaun bamo molge be nireu yev bamo ebe giengk dang etok painge-ngge ok nile. ");
INSERT INTO kbm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Amolmol ebe aplos givin ayeu ok eisir gitangi inalgum gen gwangne ti weik inaitin ngalau tiate nikwai amolmol ve ayeu arengg ane. Be eisir gitangi ebe atob inei yaun niengk amolmol walang ok as yaun ok. ");
INSERT INTO kbm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Be ginei eisir emb mwat me inum marasin ebe gitangi ve nes amolmol vunu ok, bemem gen etok gitangi ebe atob niaing eisir ok ite ma. Be eisir gitangi ebe atob ines miengk nitangi Pomate be intak bais niwei amolmol ebe tis gimat ok be utlas vie vukuri ok. ");
INSERT INTO kbm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Amol Bamo Yisu kakie givin ane singamolomb-gen gikwai kob ete Pomate gigas ei gireu gulumb gile gibweg gibloblo Pomate be gigas Pomate ane gwangne. ");
INSERT INTO kbm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Be eisir singamolomb ivang emb taku walang ok avut be imbul amolmol ve Yisu ane yaun. Be Pomate geb kulkul givin eisir be geb ane gwangne gitangi eisir be inei Yisu ane yaun gitangi amolmol. Be amolmol ili gen bwalbwale bambamo ebe Yisu ane singamolomb-gen ilgum ok beti itpweng yaun etok are inei yaun ano molge. ");
INSERT INTO kbm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Tiopili, Amolmol anongge ilgum ve inro gen bambamo ebe warik Yisu gipasang be gilgum be amei ali ok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bemem eisir iro gitau gile yaun ebe warik amolmol subu ili gen etok gisov matanos givin ebe Yisu geb ane kulkul vaku ge be eisir inei ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Beti ayeu Luk garo yaun etenok gitangi mie gilek. Be ayeu gagas gen walang ok ebe warik amolmol ebe ili gen etok gisov matanos be inei gitangi amei ok ane dabe vevie ge beti gaden yaun walang ok vie-ngge be garo gitangi mie gilek. ");
INSERT INTO kbm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Veik mie nutpweng are ve yaun ete amolmol imbul mie nok etok yaun ano molge. ");
INSERT INTO kbm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Givin ebe amol bamo Herodes geb amolmol dabin nangge Juda as taku ok, be amol bamo ti ebe geb kulkul da ane ok are Sakarias, ei gigas kulkul ge givin sawa etok. Be ei geb kulkul givin Abia ane amolmol da ane subu. Sakarias nok arwe are Elisabet, be Elisabet nok ei nangge Alon ane amolmol gen, be Alon ei Mose ane male. ");
INSERT INTO kbm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakarias gabu arwe ivang be gabu tas givin anongge ve inalgum Pomate ane yaun walang ok ano nile, be Pomate gili sulu vie be ta givin sulu anongge. ");
INSERT INTO kbm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sulu natusgen ma ve Elisabet gitangi ebe ve nikuv nunus ok ite, be gabu ivang sin-ge love nolge babamos avie be amol gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Be givin ebe Sakarias tis ane amolmol gen ve inde inemb as kulkul nangge lum yamar aplo ok, be Sakarias gisov lum aplo gile be gilgum ane kulkul givang. ");
INSERT INTO kbm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Be bambamo lum yamar ane ilgum gen gitangi eisir as luev ebe ilgum kulkul nangge lum yamar aplo ok. Beti emb Sakarias ve nisov nile be nemb da yev ukwas ane nitangi Pomate tis sawa etok. ");
INSERT INTO kbm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakarias gisov lum yamar aplo gile, be amolmol Juda ane ile be es miengk ivarkei sagin dume givin ebe ve inemb da yev ukwas ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Be Amol Bamo ane ngalau kulkul ane (angela) ti gibielk ve Sakarias nangge ete lum yamar aplo ok be givarkei gideb bais mol ane ebe da yev ukwas ane giengk ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Givin ebe Sakarias gili angela etok ok be gikuri vunungge be veve nipelk. ");
INSERT INTO kbm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bemem angela nok ginei gitangi ei be ginei, “Sakarias Upelk bwaya, Ve Pomate ande giute miam tangir gikwai, be mie arwem Elisabet atob nikuv nunus ti be mie nutal nunus nok are nunei Jon. ");
INSERT INTO kbm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Be yemlu arwem atob tanggaim vevie ve nunus etok ane anongge. Be nivin ebe nunus nok ve menihlang ok, atob amolmol walang ok tas vevias nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ve atob ei menihlang weik amol bamo ti be nilgum Pomate ane kulkul. Be ei wat ninum wain me bui gwangne ti ite ma. Pomate ane Ngalau Yamar atob nemb ei avwut tis ebe giengk tine subwe aplo ge nangge ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Be ei atob nirwel amolmol walang ano nangge Israel be indumul intangi as Pomate inde vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ei atob ninggas gwangne weik ete Ilaija, amol ebe ginei Pomate avo ok, be atob niro nunus tis tinas-gen sut, be niro amolmol ebe isov yaun ane lu ite ok vukir intangi eisir ebe es as luev vie-ngge ok inde. Be atob ei ninei nitangi amolmol ve inpasang is ate, ve kasop ge atob Amol Bamo ninme.” ");
INSERT INTO kbm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Be Sakarias giwel angela nok avo be ginei, “Yaun ete mie gunei nok atob ano nile nam nambed? Ve eilu amei gabu nolge babamos avie be amol gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Be angela ginei gitangi Sakarias be ginei, “Ayeu Gabriel ebe gavarkei Pomate na ok, be Pomate gihlin ayeu ve nanme be nanei binge vie etenik binge nitangi mie. ");
INSERT INTO kbm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Be yaun etenik asonge ano nile nindeb mul ane, bemem ande mie aplom givin ite, dangetok be atob mie avom nitu be nunei yaun vusa ite love yaun etenik ano nile okob.” ");
INSERT INTO kbm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sulu iwel is ate avos ivang ete lum aplo ok manang vie ivang, be amolmol isge Sakarias love ili ma be inei ei avo, ve ande givang sawa manang molge nangge ete lum yamar aplo ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bekob ete Sakarias meng gihlang nangge lum aplo be veve ninei yaun nitangi amolmol, bemem gilgum be gili ma beti ges bage ge ve amolmol. ");
INSERT INTO kbm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakarias ane as mate ebe geb kulkul nangge lum yamar ok ma gikwai kob ginumul gile ebe ane nam ok vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Elisabet givang tis maimae ge ve ebe gikuv nunus ite ok love as mate subu gile gikwai kob ei gilgum utle be gibweg nam aplo ge gitangi aiweng bage tavlu. ");
INSERT INTO kbm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Be ei ginei, “Amol Bamo ta viti ve ayeu beti gilgum gen etenik. Be ei ande giro ayeu mai-mayangg ebe gakuv nunus ite ok ponge gikwai veik navang amolmol tepwengge nas.” ");
INSERT INTO kbm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet tis ta be givang love aiweng 6 gile gikwai kob, Pomate gihlin angela Gabriel vukuri gile nam dabe ti are Nasaret, gideb Galilaia ane. ");
INSERT INTO kbm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","28","Ei givang gitangi avie vwivwei ti gile be avo ges ei be ginei, “As mate mie, Amol Bamo ta viti ve mie be ane avo ukwas giwei mie.” Avie nok are Malia. Be ei givang geb ate dabin vie-ngge be givang givin amol ti ite molge. Be bambamo emb ei gitangi amol ti are Josep ve gabu inemb isate. Josep nok ei nangge Dawit ane amolmol gen. ");
INSERT INTO kbm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia giute yaun ete angela Gabriel ginei gitangi ei ok love aplo bunam molge be ta gitung walang ano be ginei, “Ayeu gatpweng yaun etenik are ite ba?” ");
INSERT INTO kbm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Be Gabriel ginei gitangi ei, “Malia, upelk bwaya, ve Pomate gili mie aplom givin ei ano-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Be ute kob, atob mie nukuv nunus amol ti be nutal nunus nok are nunei Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Be nunus nok asonge tis are be atob amolmol intal ei inei Pomate gen walang ok ane, ane Natu. Be Amol Bamo Pomate atob nemb ei ve nemb amolmol dabin weik ebe tumbu Dawit ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Be ei atob nemb Jakob ane amolmol gen dabin be atob niengk dangetok nemb ta-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Be Malia ginei gitangi angela nok be ginei, Ayeu avie vuivuei be atob gen etok menihlang nam nambed ve ayeu gab amol ite?” ");
INSERT INTO kbm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Be angela ginei gitangi ei, “Pomate atob nemb ane Ngalau Yamar tis ane gwangne ninme nemb mie avut. Be nunus ete asonge mie nukuv ok atob amolmol intal ei inei Pomate Natu, be ei Amol Yamar. ");
INSERT INTO kbm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Be ute, Wamavie Elisabet nolge babamos avie gikwai bemem ei ande tis ta be ete givang ok. Warik amolmol inei ei gitangi ebe ve nikuv nunus ok ite bemem ande ei tis ta be ande aiweng 6 gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dangetok be yaun etenik atob ano nile, ve Pomate ei gitangi nilgum gen walang ok.” ");
INSERT INTO kbm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Be Malia ginei gitangi angela, “Ayeu Pomate ane avie kulkul ane be Pomate atob nilgum yaun ete mie gunei nok ano nile nipil ayeu.” Be angela gikwai Malia be gile ve givang. ");
INSERT INTO kbm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Givin sawa etok ge Malia gimdil be gile nam dabe ti ebe giengk Judaia as taku rae ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Malia gisov Sakarias ane nam aplo gile be avo ges Elisabet. ");
INSERT INTO kbm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Givin ebe Elisabet giute ebe Malia avo ges ei ok, be nunus ebe giengk Elisabet subwe aplo ok ges ate nangge tine subwe aplo. Ngalau Yamar geb Elisabet avut be giwel Malia avo be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Pomate ane avo ukwas giwei mie gitlek avie gaptol subu, be giwei nunus ete asonge mie nukuv nok givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Be ayeu avie vie ite ebe ve avie ebe ve nikuv awangg Amol Bamo ok nirngav ayeu ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Be ute kob, givin ebe mie avom ges ayeu ok, be nunus ete giengk ayeu subwangg aplo ik ta vevie be ges ate nangge ayeu subwangg aplo givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dangetok be mie tam vevie ge, ve mie aplom givin Pomate ane yaun ebe ginei gitangi mie ok, ve yaun etok atob ano nile.” ");
INSERT INTO kbm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Be Malia ginei, “Ayeu avongg givwat Amol Bamo are, ");
INSERT INTO kbm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","be tangg veviangg ge ve Pomate ei awangg Amol ebe geb ayeu ru ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ve ei ane avie kulkul ane ayeu, be ayeu gen sin ge ti bemem ei ta viti ve ayeu. Be galkik etenik be asonge niengk dangetok atob amolmol avos nivwat ayeu, ");
INSERT INTO kbm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ve gisov gen bamo ete Amol gwangne Pomate gilgum gitangi ayeu ok ane. Ei are Yamar, ");
INSERT INTO kbm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ei ta viti ve amolmol ebe isov ei ane yaun ane lu ge ok, be asonge nilgum weik etok ge nitangi eisir natus gen weik etok ge be niengk dangetok. ");
INSERT INTO kbm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ei bage gilgum gen gwangne gwangne be ges amolmol ebe isov yaun ane lu ite ok be tis as gen ebe tas gitung giengk aplos ok vusvusa be ivang iriv be ira. ");
INSERT INTO kbm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ei gili amolmol bambamo ebe emb amolmol dabin ve eisir ate as gwangne ok weik gen sin ge, be gitin is ikwai as kulkul, be avo givwat eisir ebe ili is ate weik gen sin ge ok ares. ");
INSERT INTO kbm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ei ta givin amolmol ebe ikuk lili ve inaute ei ane yaun (mateu) ok, beti geb ane yaun gitangi eisir be iute be tas vevias ge. Bemem ei gigilgili ane gen vevies gitangi amolmol ebe ivkir dumas gitangi ei ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ei ta gitung ane yaun ebe warik gibiti givin eitit tumbund gen ok, beti galkik as mate etenik ei geb ane amolmol kulkul ane nangge Israel ru. ");
INSERT INTO kbm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Be warik ei ginei gitangi eitit tumbund gen dang eteik, Ayeu atob tangg viti ve Ablaham tis ane amolmol gen be as vaku gen ebe asonge meinahlang nindeb mul ane ok nivin weik etok ge be atob niengk dangetok nemb ta ge.” ");
INSERT INTO kbm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia gibweg givin Elisabet gitangi aiweng aitol bekob ete ginumul gile ane nam vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Givin ebe Elisabet vie ve nunus ok, ");
INSERT INTO kbm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","be ei ane bambamo gen iute gen vie molge ebe Amol Bamo gilgum gitangi ei ok binge, beti eisir tepwengge tas vevias anongge ivin ei. ");
INSERT INTO kbm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","As mate 8 gile gikwai kob Elisabet ane bambamo gen iro is ate sut ile ve inaure nunus nok utle ulis nitangi ebe Juda as tumbu ok, be veve intal nunus nok tame Sakarias are nimbweg natu. ");
INSERT INTO kbm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bemem nunus nok tine ginei, “Ma. Eitit tantal nunus etenik are Jon.” ");
INSERT INTO kbm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Be eisir ikuri vunungge be inei gitangi Elisabet, “Miam bambamo gen ti ares weik etenok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Beti eisir es bais ge ve nunus nok tame Sakarias inei ei ta givin ve intal nunus etok are ret? ");
INSERT INTO kbm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarias ges bage ge ve ginei inemb tapele natu ti nile be ei niro nunus nok are bwalbwale nipil. Be ei giro nunus nok are ginei Jon. Amolmol tepwengge ili be avos poke ngge. ");
INSERT INTO kbm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Be givin sawa etok ge Sakarias ginei yaun vusa vukuri, be gimdil be avo givwat Pomate are. ");
INSERT INTO kbm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Amolmol tepwengge ili gen etok love avos poke ngge be inei gen etok ane yaun love geb nam dabe walang ok avwut nangge Juda as taku gideb rae ane. ");
INSERT INTO kbm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Amolmol iute nunus etok binge be itpweng are inei Pomate ane gwangne givang givin ei, be asonge ei menihlang weik amol bamo ti. ");
INSERT INTO kbm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ngalau Yamar geb Jon tame Sakarias avwut be ginei Pomate ane ta gitung vusa be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Eitit amolmol Israel ane avond nivwat Amol Bamo eitit and Pomate are. Ei ginme ve nemb ane amolmol eitit ru be nitak eitit tanambweg vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ei geb eitit and Amol gwangne ti ebe ve nemb eitit ru ok be meng gihlang nangge Dawit ane vaku gen. ");
INSERT INTO kbm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Be gen etenik gitangi yaun ebe warik amolmol ebe inei Pomate avo ok inei ok, ve ");
INSERT INTO kbm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ei ginei yapin ginei, atob ei nemb eitit ru be nirwel eitit tankwai gen tiate aplo, be nangge amolmol valir ane bais. ");
INSERT INTO kbm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ei ginei gitangi eitit tumbund gen be ginei, ei atob ta viti ve eitit. Beti galkik ei gilgum ane yaun nok ano gile. ");
INSERT INTO kbm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ei ginei gitangi eitit tumbund Ablaham, be girusu bage givin be ginei ei atob nemb eitit ru be nirwel eitit tankwai gen tiate aplo, be nemb eitit ve tanalgum ei ane kulkul be tanpelk ve ei dongke ngge. ");
INSERT INTO kbm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Be tanvang weik amolmol yamar ane be tanalgum gen vie-ngge nitangi ebe ei ta givin ok, tis ete tavang matawand nangge nalk nik.” ");
INSERT INTO kbm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","(Be Sakarias ginei ve natu mwele ebok be ginei), “Asonge amolmol intal ayeu natungg mie inei Pomate gen walang ok ane, ane amol kulkul ane mie. Be mie atob numungg be nunei Amol Bamo ane yaun ebe ve ninme ok binge nitangi amolmol nimungg, ");
INSERT INTO kbm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","be nunei nitangi amolmol ve Pomate atob ta nivalngan eisir as gen tiate ebe ilgum ilgum ok be atob nemb eisir ru. ");
INSERT INTO kbm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eitit and Pomate ei Amol ta viti ve amolmol ane, be atob ei nemb eitit ru be nemb ane bogbogo ninme niro eitit weik ebe yev ok. ");
INSERT INTO kbm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Be yev ete nangge gulumb ginme ok atob ane bogbogo niro amolmol ebe imbweg isov gen aiweng tumi ane ebe gitangi ve niyaing dalgond matawand ane ok be atob meinahlang taku gitip bamo. Be yev nok atob niro eitit vand lavo be tanvang tantangi luev ebe ve tanambweg vie ok tande.” ");
INSERT INTO kbm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nunus nok gitumk love bamo be gitpweng gen walang ok are gikwai kob gile ve givang givang taku sawa ebe amolmol imbweg ite ok, ei gimumu ate givang etok love sawa ebe ei ve nes ate ru nitangi amolmol Israel ane ok meng gihlang, okob ete gile gihlang be givang amolmol tepwengge nas. ");
INSERT INTO kbm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Givin sawa etok ge amolmol Rom ane as amol bamo ti ebe geb amolmol dabin ok are Augustas geb yaun ve in-gas amolmol tepwengge ares. ");
INSERT INTO kbm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Be kulkul etok eisir es vu givin ebe amol bamo ti are Sairinias geb amolmol dabin nangge Siria as taku ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Beti amolmol walang ok imdil be itangi as nam dabe ge ile ve inro ares. ");
INSERT INTO kbm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Be Josep ei nangge Dawit ane vaku gen beti ei gimdil nangge Nasaret gideb Galilaia as taku ane be gile nam dabe ti are Betlehem, ebe warik vias ve Dawit nangge ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep gigas avie (Malia) ebe bambamo emb gitangi ei ve gabu inemb is ate ok givin be gabu ile ve inro sulu ares nangge etok. Be Malia nok ande tis ta. ");
INSERT INTO kbm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Be givin ebe sulu imbweg Betlehem ok be nunus gitun ei. ");
INSERT INTO kbm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nam taulop ane ande gingik be sawa ma molge beti Josep gabu Malia ile iengk nam bwelk ane. Malia vie ve natu amol mate ane nangge etok be gisum ei ve kambam be gihle ru gile gitak bwelk as bele ebe en ben gisov ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Be givin etok amolmol subu ebe emb as bwelk sipsip dabin nangge taku etok ok, eisir imbweg aikawe ikwai nam ve emb as bwelk dabin tis tambok givin. ");
INSERT INTO kbm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Be Amol Bamo ane angela ti gibielk ve eisir be ane bogbogo geb eisir avwut love ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bemem angela ginei gitangi eisir be ginei; “Unpelk bwaya, Ayeu ganme ve nanei binge vie ti nitangi yem, be asonge amolmol walang ok tas vevias ge nangge nalk. ");
INSERT INTO kbm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Unaute kob, Galkik as mate etenik yem aim Amol ebe ve nemb yem ru ok ande meng-gihlang nangge Dawit ane nam, Amol nok are Kilisi. ");
INSERT INTO kbm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Atob yem unatpweng ei are nipil gen dang eteik, nunus ti tine gisum ve kambam be gihle ru gile gitak bwelk as bele ebe en ben gisov ok be giengk bwelk as nam, ok ti amol nok etok. ");
INSERT INTO kbm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Be seukie-ngge angela anongge meivin angela dongke etok be inei uye be avos givwat Pomate are be inei, ");
INSERT INTO kbm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Avond nivwat Pomate are niengk ei goto ge, be nangge nalk atob amolmol ebe Pomate gili is vie ok atob invang vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angela ile ikwai bekob amolmol ebe emb as bwelk dabin ok inei ve is ate be inei, Tamdil talek ebe Betlehem nok be tali gen ebe galkik Amol Bamo ane angela ginei binge gitangi it ok okob ma. ");
INSERT INTO kbm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Beti gaptol imdil giengk ti ge be ile love imbielk ve Malia gabu Josep be nunus muele ebe giengk gisov bwelk as bele nangge bwelk as nam ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eisir ili nunus nok gikwai bekob iput nunus nok ane yaun ebe angela ginei gitangi eisir ok lavo gitangi Malia gabu Josep be tis amolmol ebe imbweg ivin sulu ok be iute. ");
INSERT INTO kbm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Amolmol iute eisir bwelk ane as yaun ebe iput ok love avos poke ge. ");
INSERT INTO kbm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Be Malia gipasang yaun bambamo etok tepwengge giengk aplo. ");
INSERT INTO kbm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Eisir bwelk ane ile be ili gen walang ok gitangi yaun ebe galkik angela ginei gitangi eisir ok bekob ilumul ile lavos vukuri be avos givwat Pomate are ve gen bambamo etok ane. ");
INSERT INTO kbm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","As mate 8 gile gikwai kob iure nunus nok utle ulis be ital are Yisu, gitangi ebe warik nunus nok giengk tine subwe aplo ite nangge be Pomate ane angela ti gir ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Givin sawa ebe Josep gabu Malia ve inalgum gen nitangi ebe Mose ane yaun ginei ok, ve inemb da nunus vaku ane be tis da gen ebe givalval Malia gili ok, beti sulu imdil be inggas Yisu be ireu ile Jerusalem ve inemb ei nitangi Pomate. ");
INSERT INTO kbm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ve Amol Bamo ane yaun ebe giengk ane kapia ok ginei dang eteik; ‘Nunus amol mate ane ebe tinas gen ikuv is ulu ok atob inemb eisir nitangi Amol Bamo nile.’ ");
INSERT INTO kbm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Beti Josep gabu Malia ireu Jerusalem ile, be sulu ile ve inemb as da nivin weik etok ge ve yaun ebe giengk Amol Bamo ane kapia ok ginei; ‘Amolmol inemb man-gum me man-bubu natu ailu ve da nitangi Pomate.’ ");
INSERT INTO kbm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Be givin sawa etok amol ti are Saimon gibweg ete Jerusalem. Be Saimon nok ei amol ti ebe aplo givin Pomate be gisge sawa ebe Pomate ve nemb amolmol Israel ane ru ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Be Ngalau Yamar geb ei avwut be ginei gitangi ei ve atob nimat vunu ite love nili Amol Bamo ane Amol ebe ve nemb amolmol ru ok ebe warik ginei ane yaun ge gimungg ok bekob. ");
INSERT INTO kbm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Be givin sawa etok Ngalau Yamar gitwem Saimon gisov lum yamar aplo gile. Be Josep gabu Malia inggas Yisu be isov ile ve inalgum kulkul nipil ei weik ebe Amol Bamo ane yaun ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Be Saimon gile geb Yisu ginme giwei bage taptape be avo givwat Pomate are be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Amol Bamo, Mie gupasang am yaun ebe warik gubiti ok be giengk love galkik ande ano gile, dangetok be mie nunggas am amol kulkul ane ayeu nalek tis tangg vevie ge. ");
INSERT INTO kbm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ve galkik etenik ande ayeu gali miam Amol ebe gob ginme ve nemb amolmol ru ok gisov matanongg, mie gupasang luev etok giengk gitip ge veik amolmol tepwengge indi. ");
INSERT INTO kbm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Amol nok weik ebe yev ok be atob ane aivi niro nipil amolmol gitip ane be meinahlang ve miam amolmol-gen, be miam amolmol Israel ane atob in-gas ares bamo ve Amol nok ane.” ");
INSERT INTO kbm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Malia gabu Josep avos poke ge ve yaun bambamo ete Saimon ginei gipil Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Saimon geb avo ukwas giwei sotol gikwai kob ginei ve Yisu tine Malia be ginei, “Nunus ete Pomate ei ate geb nik, asonge nilgum amolmol walang molge nangge Israel be inambieg be atob nilgum amolmol anongge be inamdil vukuri weik etok ge. Ei atob nivang weik Pomate ei ate dalgo, be atob amolmol inei yaun ungglus-ungglus walang ano nipil ei. ");
INSERT INTO kbm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Veik yaun ebe eisir tas gitung giengk aplos ge ok atob inei nile nihlang. Be nangge mie ate aplom, atob mie tam viti bamo molge weik ebe emb buyag valir ane ane mate gitangi mie atem ok.” ");
INSERT INTO kbm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Be givin etok Pomate ane avie kulkul ane ti ebe ginei Pomate avo ok are Ana, ei ok gisov lum yamar aplo gile givin. Be Ana tame nangge Asel ane vaku gen are Panuel. Ana geb amol be gabu ivang love Sonda bamo 7 gile gikwai kob arwe amol gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Be ei givang dangetok love nolge babamos avie be ei ane Sonda bamo gitangi 84, bemem ei utle bua ve lum yamar ite molge. As mate walang ok ei ginum numul lum yamar painge ngge ve ginei uye be avo givwat Pomate are gigas ta ge givin tambok be as, be giyamar ben be ges miengk gitangi Pomate. ");
INSERT INTO kbm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Be givin sawa etok ge Ana gibielk ve Josep gabu Malia be Yisu nangge lum yamar aplo be ges miengk be ginei ane ta vie gitangi Pomate gikwai kob ginei yaun gipil Yisu, gitangi amolmol ebe isge ve Pomate nemb amolmol Jerusalem ane ru ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep gabu Malia ilgum gen walang ok gitangi ebe Amol Bamo ginei inalgum ok love ma gikwai kob gabu inggas Yisu be inumul ile as nam Nasaret gideb Galilaia as taku ane vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yisu gitumk love bamo be ane dabe gwet vie molge, be Pomate ta givin ei anongge. ");
INSERT INTO kbm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Givin Sonda bamo walang ok Yisu tine gabu tame ireu Jerusalem ile ve inalgum ben Sonda ebe ital inei Pasova ok ane. ");
INSERT INTO kbm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Be givin sawa etok ande Yisu ane Sonda bamo gitangi 12 be tame gabu tine inggas ei givin be ireu Jerusalem ile vukuri ve inalgum as ben bamo ebe ilgum-ilgum ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eisir as as-mate ebe ilgum ben etok ande gile ma gikwai be Josep gabu Malia veve indumul inde ebe Nasaret ok vukuri, bemem Amol natu Yisu ei gibweg Jerusalem mangmangi be tame gabu tine tas gisgil ge. ");
INSERT INTO kbm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sulu inei bwat ande ei givang givin ane nune-gen subu beti gabu tas gitung yaun ti ite, be gabu ivang love ande as gile gisov be gabu ili ei mama ge beti ile iutani as nune-gen subu velob ei nivang nivin eisir. ");
INSERT INTO kbm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bemem gabu irek ei ivang love ili ma, ");
INSERT INTO kbm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","be ande as mate ailu gile gikwai be ti menggivin ve aitol ane okob gabu ile ili ei ebe gibweg givin eisir Juda as amolmol bambamo mateu ane ve giute eisir as yaun be giutau-tani is gibweg ok. ");
INSERT INTO kbm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eisir bambamo mateu ane ebe imbweg lum yamar aplo ok iute ei ane yaun ebe ginei ginei ok love avos poke ge. ");
INSERT INTO kbm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Be tame gabu tine ili ei ebe gibweg givin bambamo mateu ane nangge lum yamar aplo ok be yaun ok ma, be tine ginei gitangi ei be ginei, “Natum, Mie gulgum dangetok gitangi eilu ve ret ane? Eilu tamem arek mie love ali ma be aplongg-amei bunam molge ve mie ane.” ");
INSERT INTO kbm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Be Yisu ginei gitangi sulu be ginei, “Yemlu urek ayeu ve ret ane. Yemlu uli ebe ayeu tanggivin ve nambweg Tamangg ane nam ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bemem sulu itpweng yaun ete ei ginei gitangi sulu ok are ite. ");
INSERT INTO kbm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bekob Yisu gimdil be givin tame gabu tine be tepwe inumul ile Nasaret. Be as mate walang ok Yisu gisov tine gabu tame as yaun ane lu vie ngge. Be Malia gipasang gen bambamo etok tepwengge giengk aplo. ");
INSERT INTO kbm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisu gitumk love bamo be ane dabe gwet vie molge, be amolmol be tis Pomate ei ate ok tas givin ei anongge molge. ");
INSERT INTO kbm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Amol bamo Taibirias geb amolmol dabin givang love ande Sonda bamo gitangi 15, be givin sawa etok Pontias Pilata geb amolmol dabin nangge Juda as taku. Be Herodes geb amolmol dabin nangge Galilaia as taku, be kawe Pilip geb amolmol dabin nangge Ituria tis Trekonaitis as taku. Be Laisenias geb amolmol dabin nangge Abilini as taku, ");
INSERT INTO kbm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","be Anas gabu Kaiapas sulu ailu etok ebe emb amolmol ebe emb kulkul da ane dabin ok. Be givin sawa etok ge Pomate geb ane yaun (mateu) gitangi Sakarias natu Jon, givin ebe Jon gibweg taku sawa ok. ");
INSERT INTO kbm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Beti Jon givang geb taku walang ebe giengk gibloblo bui Joldan ok avwut be ginei mateu gitangi amolmol be ginei, “Unro aim ate vukir unkwai gen tiate aplo be unringk bui sanggu veik nes ru ve yem ande uro aim ate vukir gikwai, be atob Pomate nisin yem aim gen tiate ebe ulgum ok nikwai. ");
INSERT INTO kbm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Be yaun etenik weik ebe warik Pomate ane amol ti ebe ginei Pomate avo ok ginei ok, be yaun ete ei ginei ok dang eteik, “Amol ti atob nital yaun nangge taku sawa ebe amolmol ma ok be ninei, “Unpasang Amol Bamo ane luev ebe ve nivang ok vevie. ");
INSERT INTO kbm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Be luev ete kapkapul-kapkapul ok unaspun nile roro, be nalk ete girul gireu ok unatle nile galav. Be luev ete kiukiwis ok unemb nile roro vie-ngge, be luev ete ei wakas be tis vat bambamo giengk ok, yem unpasang love vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Be amolmol tepwengge atob matanos nitut nimbweg Pomate ane Amol ebe ve nemb amolmol ru ok.” ");
INSERT INTO kbm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon gili Parisai be Sadukai subu ebe itangi ei ile ve nes bui sanggu nipil eisir ok, beti ei geb yaun gwangne molge gitangi eisir be ginei, ‘Ret ginei beti yem upelk ve gen bunam ete asonge Pomate nemb nitangi yem ok beti usu aim ate sin-gege utangi ayeu unme? Yem amolmol tiate ane. ");
INSERT INTO kbm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yem unro aim ate vukir unkwai gen tiate aplo be unalgum gen weik ebe amolmol vevies ane ilgum ok okob, veik amolmol indi yem aim gen vevies ete ulgum ok! Yem unei bwat yem mohlang nangge Ablaham ane vaku gen beti unei yaun walang ano be unei Pomate ane amolmol gen yem, bemem etok gitangi ite. Pomate gitangi nipasang vat bambamo etenik be menihlang weik ete Ablaham ane natu-nggen ok. ");
INSERT INTO kbm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yem weik wei-wei ebe ges ano vie ite beti ane tivie ta vavis be givwat bongaya gile ve nitle nile nitak be nispe gilkili be nikari nireu yev nile ok. ");
INSERT INTO kbm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Be amolmol iutani Jon be inei, “Jon, Ginei dangetok okob atob amei anamdom?” ");
INSERT INTO kbm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Be Jon giwel eisir avos be ginei, “Ginei amol ti ane kup ailu giengk, okob ei nemb ane gen ti nitangi amol ti ebe gen ma molge ve ane ok. Be ginei amol ti ane ben walang molge giengk, okob ei nimbwas ane ben etok nitangi amolmol ebe ben ma ve is ok nitangi ge nile.” ");
INSERT INTO kbm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Be sawa etok ge amolmol subu ebe emb kulkul takes ane ok, itangi Jon ile ve Jon nes bui sanggu nipil eisir, be eisir nok iutani Jon be inei, “Gidung, Atob amei anamdom?” Be Jon giwel eisir avos be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Yem un-gas mone rorongge nitangi ete aim amol bamo ginei ok nangge amolmol, be unyo-unyo amolmol be un-gas as mone subu nivin sinsin-ge ite.” ");
INSERT INTO kbm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Be amolmol valir ane subu ok iutani Jon be inei, “Wali atob amei analgum amei ate namnambed?” Be Jon ginei gitangi eisir, “Yem unyo-unyo amolmol be unalgum yaun bingkas-kasop nipil eisir veik un-gas eisir as mone menivin yem ate aim mone aim kulkul ane ite. Be tangg-aim vavis ve ebe unggas mone tiate ok bwaya, ve mone ete yem unggas ok etok yem aim mone aim kulkul ane roro.” ");
INSERT INTO kbm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Amolmol tepwengge tas gitung gile ma be inei yaun walang ano gipil Jon be inei, “Amol etenik wat ei amol ebe ve nemb amolmol ru ok (Mesia) me?” ");
INSERT INTO kbm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Be Jon ginei gitangi eisir be ginei, “Ayeu gas bui sanggu gipil yem ve bui sin-ge, bemem amol ete ve nitau nile ayeu be ninme ok ei ane gwangne gitlek awangg. Be ayeu gitangi ebe ve nalgum ei ane kulkul ok ite ve ayeu amol vie ite. Be amol nok atob nemb Ngalau Yamar weik ebe yev ok nitangi yem veik nisin yem aim gen tiate nikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Be Jon ginei bing-ai ti gitangi amolmol be ginei, “Amol nok atob ninme be nimbwas ane ben, be ben nok ane ano ebe ve inen ok ete atob intak nisov ane nam ben ano ane nile niengk. Be ebe tiate ok atob inkari nireu yev bamo ebe giengk dangetok ok nile be yev nen nikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ginei mateu gitangi amolmol be ginei gipil bing-ai walang ano givin gitangi amolmol veik amolmol inaute mateu be inatpweng are be inro is ate vukir. ");
INSERT INTO kbm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Amolmol ebe tas givin ve Jon nes bui sanggu nipil eisir ok, iringk bui sanggu gikwai kob ei ges bui sanggu gipil Yisu givin weik etok ge. Givin ebe Jon ges bui sanggu gipil Yisu ok, be Yisu ges miengk givarkei be gulumb ande sawa gisov be Pomate ane Ngalau Yamar geb na gile man-bubu be gisov ginme gikuv-kuvi giwei Yisu dabe, be Pomate ginei yaun ti nangge gulumb dang eteik; “Ayeu Natungg dongke mie ebe gali mie vie be tang givin mie gitlek ok.” Givin sawa etok Herodes geb amolmol dabin, be Herodes nok gilgum gen gisov molge ve geb kawe Pilip ane avie Herodias ponge. Beti Jon ginei Herodes nok ane tiate etok binge gitangi ei ate be tis ane gen tiate subu ebe gilgum-gilgum ok binge givin. Beti Herodes ta vavis be gilgum gen tiate molge ti givin, ve ginei be ane amolmol valir ane itak Jon gisov kapual-lu gile. ");
INSERT INTO kbm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisu gimdil be ges ane kulkul mateu ane vu givin ebe ane Sonda bamo gitangi 30 ok, be amolmol ili ei be inei bwat Yisu tame ete Josep ok. Be Josep tame Eli, ");
INSERT INTO kbm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","be Eli tame Matat be Mata tame Liwi, be Liwi tame Melki, be Melki tame Janai be Janai tame Josep. ");
INSERT INTO kbm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Be Josep tame Matatia be Matatia tame Amos, be Amos tame Naum be Naum tame Esli be Esli tame Nagai, ");
INSERT INTO kbm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Be Nagai tame Mat be Mat tame Matatia be Matatia tame Semein, be Semein tame Josek be Josek tame Joda. ");
INSERT INTO kbm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Be Joda tame Joana be Joana tame Resa be Resa tame Serubabel, be Serubabel tame Sieltiel be Sieltiel tame Neri, ");
INSERT INTO kbm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Be Neri tame Melki be Melki tame Adi be Adi tame Kosam. Be Kosam tame Elmadam be Elmadam tame Ea. ");
INSERT INTO kbm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Be Ea tame Josua be Josua tame Eliesel be Eliesel tame Jorim, be Jorim tame Matat be Matat tame Liwi. ");
INSERT INTO kbm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Be Liwi tame Simion be Simion tame Juda be Juda tame Josep, be Josep tame Jonam be Jonam tame Eliakim, ");
INSERT INTO kbm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Be Eliakim tame Melea be Melea tame Mena be Mena tame Matata be Matata tame Natan be Natan tame Dawit. ");
INSERT INTO kbm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Be Dawit tame Isai be Isai tame Obet be Obet tame Boas, be Boas tame Salmon, be Salmon tame Nason. ");
INSERT INTO kbm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Be Nason tame Aminadab be Aminadab tame Admin be Admin tame Arni, be Arni tame Hesron be Hesron tame Peres be Peres tame Juda. ");
INSERT INTO kbm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Be Juda tame Jakop be Jakop tame Isak be Isak tame Ablaham, be Ablaham tame Tara be Tara tame Nahol, ");
INSERT INTO kbm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","be Nahol tame Serug be Serug tame Reu be Reu tame Peleg be Peleg tame Eber be Eber tame Sela. ");
INSERT INTO kbm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Be Sela tame Kainan be Kainan tame Apaksad be Apaksad tame Sem, be Sem tame Noak be Noak tame Lamek. ");
INSERT INTO kbm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Be Lamek tame Metusala be Metusala tame Inok be Inok tame Jared, be Jared tame Mahalalel be Mahalalel tame Kainan. ");
INSERT INTO kbm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Be Kainan tame Inos be Inos tame Set be Set tame Adam be Adam tame Tivie Pomate. ");
INSERT INTO kbm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yisu gipil gikwai bui kire gile love Ngalau Yamar geb ei avwut, be Ngalau Yamar gitwem ei gile taku sawa ");
INSERT INTO kbm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","be Sadam ane kulkul ve gitpungi ei. Yisu givang taku sawa etok be gen ben ite gitangi as mate 40 be tambok 40 love maravges vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Be Sadam ginei gitangi ei be ginei, “Ginei Pomate Natu mie, okob nunei be vat bambamo etenik menihlang ve ben be non.” ");
INSERT INTO kbm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Be Yisu giwel Sadam avo be ginei, “Yaun ebe giengk Pomate ane kapia ok ginei dang eteik, ‘Ben dongke-ngge giro amolmol ta ite.’” ");
INSERT INTO kbm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bekob Sadam gigas Yisu be gabu ireu Matendubi undib ti ile, be seukie-ngge Sadam ges taku walang ok tis ane gen vevies tepwengge ru gitangi Yisu ");
INSERT INTO kbm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","be ginei, “Ayeu gab gen walang ete ande guli ok tepwengge dabin be ayeu gitangi ebe ve namb gen etok tepwengge nitangi amol ti ebe ayeu ate tang givin ok, dangetok be ginei mie nusov awangg yaun ane lu ge be nuro vam dubi supwe nisov nalk be nos miengk nitangi ayeu, atob ayeu namb gen bambamo etok tepwengge nitangi mie be nomb dabin.” ");
INSERT INTO kbm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Be Yisu giwel Sadam avo be ginei, “Yaun giengk dangetok ginei, ‘Nusov am Amol Bamo Pomate ane yaun ane lu be nos miengk nitangi ei dongke-ngge.’” ");
INSERT INTO kbm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Be Sadam gigas Yisu vukuri be gabu ireu ile Jerusalem be gitak Yisu gile gibweg giwei lum yamar bamo ebe givarkei etok ok ane bwelk-dume bekob ginei gitangi ei, “Ginei Pomate Natu mie, okob vepiem nangge etenok nunme nutak be mie gitangi ebe atob nos im ate ok ite, ma. ");
INSERT INTO kbm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Ve Yaun giengk dangetok ginei, ‘Atob Pomate nihlin ane angela inme inemb mie dabin be atob inrun mie itin ve bais nile einggoto veik nutut vam nipil vat bambamo etenik ite.’” ");
INSERT INTO kbm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yisu giwel Sadam avo be ginei; “Yaun ti ginei weik etok ge dangeteik, ‘Mie nuhle am Amol Bamo Pomate ite.’” ");
INSERT INTO kbm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sadam gilgum veik Yisu nisov ei ane yaun ane lu ge beti gitpungi ei ve luev walang ok bemem Yisu gisov ei ane yaun ti ane lu ite molge. Beti Sadam gili ma be gikwai Yisu be gile ve givang. Be Sadam ta gitung ve ginei sawa ti kob ninumul nile be nitpungi Yisu vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yisu ginumul gile Galilaia vukuri, be Ngalau Yamar ane gwangne geb ei avwut be amolmol inei ei ane bing love geb taku walang ok avwut. ");
INSERT INTO kbm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yisu gisov lum mateu ane aplo gile be ginei mateu givang be amolmol tepwengge avos givwat ei are. ");
INSERT INTO kbm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisu ginumul gile Nasaret, ei ane nam ebe warik bamo nangge ok. Be givin as mate ebe Juda ve indi as Sonda ebe ital inei Sabat ok be ei ok gisov lum aplo gile givin weik ebe gilgum-gilgum ok. ");
INSERT INTO kbm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Be amolmol emb kapia ti ebe warik Jesaia, amol ebe ginei Pomate avo ok giro ok gitangi Yisu ve nisam. Beti Yisu givdu kapia nok givang love gile gili yaun ake ti ebe ginei dang eteik: ");
INSERT INTO kbm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Amol Bamo ane Ngalau Yamar givang givin ayeu. Ve gisov ei geb ayeu ve nanme be nanei mateu nitangi amolmol ebe gen ma ve is ok. Be Pomate gihlin ayeu ve nanme be narwel amolmol inkwai Sadam tis ane gen tiate walang ok aplo, be nalgum amolmol ebe matanos bop ok be indi taku vukuri be nalgum eisir ebe ivang tis bunam ge nangge nalk ok be inambweg vie. ");
INSERT INTO kbm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Be nanei lavo nitangi amolmol nanei galkik as mate etenik Pomate atob nemb ane amolmol gen dabin.” ");
INSERT INTO kbm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisu ges kapia avwut be geb gitangi amol ti ebe geb lum mateu ane dabin ok gile, be gibweg golonge ve ninei yaun nitangi eisir. Be amolmol tepwengge ebe imbweg lum aplo ok nas gitangi ei ge. ");
INSERT INTO kbm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Be Yisu ginei: “Yaun ete galkik ayeu gavnawi ok ebe warik Pomate ane amol ti ebe ginei Pomate avo ok giro ok. Be galkik as mate etenik ande yaun etok ano gile.” ");
INSERT INTO kbm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Amolmol tepwengge iute Yisu ane yaun vie ebe ginei ok love avos poke-ngge be inei, “Amol etenik wat tame ete Josep ok me?” ");
INSERT INTO kbm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Be Yisu ginei gitangi eisir, “Bingano molge, Ayeu gatpweng are roro-ngge ganei asonge yem unei yaun ake eteik nipil ayeu be unei, ‘Dokta, Ulgum mi ate be utlem vie vukuri ma?’ Be atob unei yaun ti nivin weik etok ge dang eteik, ‘Ulgum gen bambamo ebe gulgum nangge Kapenaum be amei aute binge ge ok nangge ete mie ate am nam nik ivin ma?’” ");
INSERT INTO kbm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Be Yisu ginei, “Ayeu nanei bingano ge nitangi yem, Amolmol nangge nam dabe subu tas givin Pomate ane amol ebe ginei Pomate avo ok, be isov ei ane yaun ane lu ge. Bemem nangge amol etenik ane nam ei ane bambamo gen tas givin ei be isov ei ane yaun ane lu ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Be unaute, Givin ebe Pomate ane amol kulkul ane ti are Elia gibweg ok, be givin sawa etok ge avie gaptol ebe arwasgen imat vunkunu ikwai is ok walang molge imbweg nangge Israel. Be sawa etok ur gisov ite molge be as gwangne tiate molge gitangi Sonda bamo aitol be aiweng 6, be amolmol nangge Israel marav-ges is geb taku walang ok avwut. ");
INSERT INTO kbm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bemem Pomate gihlin Elia be givang gitangi avie gaptol etok as avie ti gile ite ma, Elia givang gitangi avie tupe ti ebe gibweg nangge nam dabe ti are Sarepat ok gile nangge Sidon as taku. ");
INSERT INTO kbm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Be givin ebe Pomate ane amol kulkul ane ti are Elisa gibweg ok, be givin sawa etok bid tiate ti ebe ital inei bid namvu ok gen amolmol anongge nangge Israel vunkunu. Bemem eisir nok as amol ti utle vie vukuri ite ma. Amol Suria ane ti are Naiman, ei dongke-ngge ete utle vie vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Amolmol ebe imbweg lum aplo ok iute Yisu ane yaun ebe ginei-ginei ok love gilgum be aplos tiate molge, ve eisir itpweng are inei Yisu gigo eisir. ");
INSERT INTO kbm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Beti imdil be bais gisov Yisu be inggas ei ile ihlang ikwai as nam luvwe. Be eisir nok imbweg matendubi ti, beti inggas Yisu ile veve inasgul ei nisov papte nile be nes ate vunu. ");
INSERT INTO kbm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bemem Yisu gimumu ate ge gisov amolmol bambamo nok aplo be gile ve givang. ");
INSERT INTO kbm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisu gikwai nam dabe etok be gile Kapenaum nangge Galilaia as taku. Be givin Sonda Sabat ei gisov lum mateu ane aplo gile be gibul amolmol givang. ");
INSERT INTO kbm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Amolmol iute ei ane mateu ebe ginei ok love yaun ok ma, ve ei ane yaun mate be gwangne molge weik ete ei ate ane gwangne ok. ");
INSERT INTO kbm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Be givin sawa etok amol ti ebe ngalau tiate givang givin ei ok gile gibweg lum aplo givin ve giute Yisu ane yaun ebe ginei-ginei ok. Be ngalau tiate nok as amol ti yayai avo bamo molge be ginei. ");
INSERT INTO kbm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yisu Nasaret ane, Mie gunme ve numdom nitangi amei? Mie gunme ve nuyaing amei me? Ayeu ande gatpweng mie are gikwai, Mie Pomate ane Amol Yamar ebe gihlin be ginme ok.” ");
INSERT INTO kbm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Be Yisu gigo ngalau tiates nok be ginei, “Kamoke, be unde unahlang unkwai amol etenok.” Be ngalau tiates nok ilgum amol nok love gikari ate gile gitak nalk bemem ges ate ite. ");
INSERT INTO kbm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amolmol ili gen bamo etok love yaun ok ma be inei ve is ate. “Amol etenik avo vavavne be mate molge ba. Ve ei ginei yaun ge gitangi ngalau tiates bemem isov ei ane yaun ane lu ge be ile ihlang ikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Be amolmol walang ok kakie gipil Yisu ane yaun ge love geb taku walang ok avwut nangge ete Galilaia as taku ok. ");
INSERT INTO kbm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisu gile gihlang gikwai lum aplo be gile ve nile nipil Saimon ane nam. Be Saimon nok lawavie gimat utle vavavne bamo molge be giengk, beti amolmol ile inei lavo gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yisu gisov nam aplo gile be gile givarkei gibloblo avie nok be gihlin gimat etok ve nikwai avie nok, be seukie-ngge gimat vavavnas nok gihlang gikwai avie nok be ei gimdil be gipasang ben ve tepwe tis Yisu inen. ");
INSERT INTO kbm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Be givin gibok etok amolmol inggas as nune-nggen ebe tis gimat walang ano ok be itangi Yisu ile ve nilgum as gimat be vias vukuri, beti Yisu gitak bage giwei eisir ebe tis gimat ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Be amolmol ebe ngalau tiate ivang ivin is ok ete ngalau tiates nok ile ihlang ikwai eisir be yayai be inei gitangi Yisu, “Mie Pomate Natu mie. Be Yisu ges bing be ginei yaun gwangne gitangi eisir ve ginei inei yaun ti be ti ite. Ngalau tiate itpweng Yisu are gikwai inei Yisu ei Pomate ane Amol ebe geb ginme ve nemb amolmol ru ok. Beti Yisu ges bing ve eisir be ginei inei ei binge bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Givin tistumi ge Yisu gimdil gikwai taku etok be gile ve givang ane atane ge nangge taku sawa ti ve nes miengk. Be amolmol taku etok ane irek ei love ile vunge ve ei beti eisir ilgum ve inemb ei ta be nimbweg nivin eisir nangge taku etok. ");
INSERT INTO kbm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bemem Yisu ginei gitangi eisir, “Pomate gihlin ayeu be ganme ve nanei mateu be nanei yaun nipil luev ebe Pomate ve nemb amolmol dabin ok nitangi amolmol nangge taku walang ok. Beti ayeu ganme ve kulkul nok ane.” ");
INSERT INTO kbm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bekob Yisu givang geb taku walang ok avwut nangge Judaia as taku ve ginei mateu gitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Givin sawa ti Yisu gile givarkei gibloblo bui kapul ti are Genesaret ebe giengk Galilaia as taku ok, be amolmol anongge ivarkei meidbul ei ve inaute mateu ebe ei ginei-ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yisu na gile gili amolmol wenk ane as ei-vovo ebe ande ikuk gipil alus be giengk ok, be ei-vovo nok ane tivias gen ande ikwai ei-vovo be ile ivuk as wasang. ");
INSERT INTO kbm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yisu gipil gile gibweg giwei amol ti ane ei-vovo be ginei gitangi amol nok ve nisu ei tis ei-vovo nile nivwev aikawe kasopge nikwai alus kob ninei mateu nitangi amolmol. Amol nok are Saimon. ");
INSERT INTO kbm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yisu ginei mateu gitangi amolmol givang love ma gikwai kob ginei gitangi Saimon tis ane nunus gen be ginei, “Unvwes aim wasang unde ete kaumb ok be baingg-aim vier ve wasang isov gielk ile, be atob un-gas wenk anongge nangge etok.” ");
INSERT INTO kbm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Be Saimon giwel Yisu avo be ginei, “Amol Bamo, Amei algum kulkul ve atak wasang etek tis tambok undib galkik love as bamo sin-ge bemem anggas wenk ti ite molge, bemem ande mie gunei beti atob amei andumul ande be baingg-amei vier ve wasang nisov gielk nile vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Beti Saimon tis ane nune-nggen inumul ile be bais vier ve as wasang gisov gielk gile vukuri love wenk anongge gile gisov wasang be gilgum love kasopge be wasang ni-tititip. ");
INSERT INTO kbm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Beti ital gile ve amolmol ei-vovo ti ane ve inme be inemb eisir ru. Gaptol es wenk gisov ei-vovo isgabu ivang love kasop ge be ei-vovo isgabu bududu-pwe. ");
INSERT INTO kbm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Be Saimon, ital ei are ti inei Pita, gili gen bambamo etok be gile giro va dubi supwe gisov nalk gitangi Yisu be ginei, “Amol Bamo, Ule aikawe ukwai ayeu ve ayeu amol tiate ane.” ");
INSERT INTO kbm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon ginei yaun dangetok gitangi Yisu, ve gisov ei tis ane nunus gen ili wenk bambamo ebe inggas gisov wasang ok love yaun ok ma, ve eisir inggas wenk gitlek molge. ");
INSERT INTO kbm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Be Sebedi natu-nggen Jakobos gabu Jon ebe emb kulkul wenk ane ivin Saimon ok, sulu ok ili wenk bambamo etok love avos poke-ngge weik etok ge. Be Yisu ginei gitangi Saimon, “Avom poke bwaya, ve atob ayeu nambul mie ve nuro awangg amolmol gen sut dangete ande guro wenk etenik sut gisov wasang nik.” ");
INSERT INTO kbm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Saimon tis ane nunus gen ikuk as ei-vovo gipil gile giengk ebe aplo ok be as gen walang ok giengk-em giengk tis as ei-vovo be ile ivang mul ve Yisu be ile. ");
INSERT INTO kbm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yisu gibweg nangge nam dabe ti, be amol taku etok ane ti bid gen utle ulis tepwengge avwut, be givin ebe ei gili Yisu ok be ei givswen va dubi supwe gisov nalk gitangi Yisu be ginei, “Amol Bamo, Ginei mie tam givin okob nulgum ayeu utlangg be vie vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yisu utle gipelk ve amol nok ane bid ite be gile gitak bage giwei amol nok utle ulis be ginei, “Ayeu tang givin ve nalgum mie utlem be vie vukuri.” Be seukie-ngge bid tiate bambamo nok ges ulur gikwai amol nok utle ulis be ande utle vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Be Yisu ges bing gitangi amol nok be ginei, “Mie nunei gen etenik binge nitangi amol ti be ti ite, mie nuvang roro-ngge nutangi amol bamo ebe geb kulkul da ane ok nule be nos imate ru nitangi ei, bekob nulgum gen ebe Mose ane yaun ginei ok be nomb am da, veik amolmol inatpweng are inei mie ande utlem vie gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bemem amol nok giute Yisu avo ite be gile be ginei gen ebe Yisu gilgum gitangi ei ok binge gitangi amolmol love geb taku avwut. Beti amolmol anongge iute Yisu binge be itangi ei ile ve inaute mateu ebe ei ginei-ginei ok, be nilgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bemem Yisu ande gikwai taku etok be gile ve givang taku sawa ti ebe amolmol ma ok ve nes miengk. ");
INSERT INTO kbm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","As mate ti Yisu ginei mateu gitangi amolmol givang be Parisai tis gidung subu ebe emb Mose ane yaun dabin ok, eisir ok imbweg ve iute Yisu ane yaun ebe ginei-ginei ok. Be eisir nok inme nangge nam dabe walang ok, nangge Galilaia as taku be nangge Judaia be tis Jerusalem. Be givin etok Pomate ane gwangne ande gile givang givin Yisu ve nilgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Be sawa etok ge amolmol subu inggas amol gimat ti itangi Yisu ile, amol nok bage be tis va dubi giru bingbleng be gitangi ebe ve ei ate nivang ok ite. Beti amolmol ebe inggas ei ok lolos ve in-gas ei insov nam aplo inde intak ei niengk Yisu na ane, ");
INSERT INTO kbm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","bemem ilgum be gitangi ite ve amolmol iro is ate sut isov nam aplo ile love ande sawa ma molge. Beti eisir nok ireu nam dobo ile bekob irwel amol gimat nok gireu gile nam dobo bekob irun gen ti weik ebe sanggalai ok ponge gitangi ete Yisu givarkei ok be itu amol gimat nok gisov gile gitak nam aplo gitangi Yisu na ngge. ");
INSERT INTO kbm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yisu gili eisir ebe itu amol etok gisov nangge nam dobo gitangi ei gile ok be gitpweng eisir are ginei eisir ili inei atob ei nilgum amol gimat etok be vie vukuri. Beti Yisu ginei gitangi amol gimat nok be ginei; “Angg nune, Ande ayeu gasin miam gen tiate ebe gulgum ok gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisai tis gidung ebe emb Mose ane yaun dabin ok iute yaun ete Yisu ginei gitangi amol gimat etok ok, be inei gitangi is ate be inei, “Amol etenik ei amol ret? Beti ginei yaun ungglus-ungglus dang dang-etenik gipil Pomate.” Bekob inei ve is ate, “Amol sin-ge ti gitangi ebe ve nisin amolmol as gen tiate ebe ilgum ok nikwai ok ite Pomate ei dongke-ngge gitangi.” ");
INSERT INTO kbm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bemem Yisu ande gitpweng eisir as yaun ete inei ve is ate ok are gikwai beti ginei, “Yem unei yaun etenok gitlek molge.” ");
INSERT INTO kbm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Be Yisu ginei, “Ginei ayeu nanei yaun sin-gege nitangi amol gimat etenik be nanei, ‘Ande ayeu gasin miam gen tiate ebe gulgum ok gikwai,’ bemem ginei awangg yaun ete ganei ok ano nile ite atob ayeu mai mayangg ite, ve amolmol gitangi ebe atob indi gen etok ano nisov matanos ok ite. Bemem ginei ayeu nanei, ‘Umdil be umual amb yemb be uvwat be uvang am nam ane,’ bemem ginei awangg yaun etok ano ma, okob atob ayeu mai mayangg anongge.” ");
INSERT INTO kbm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Be Yisu ginei, “Dangetok be ayeu nanei yaun lavo nitangi yem okob. Pomate geb ane gwangne gitangi Natu Ayeu ebe meng-gahlang weik amolmol ok givin weik etok ge ve nasin amolmol as gen tiate ebe ilgum nangge nalk ok nikwai.” Bekob ete ginei gitangi amol bage be va dubi muai muai ebok be ginei, “Ayeu nanei nitangi mie, Umdil be umual amb yemb ebe galkik guyengk guwei ok be uvwat am gen be uvang am nam ane.” ");
INSERT INTO kbm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Be seukie-ngge amol nok pumue gimdil be gimual ane yemb nangge amolmol tepwengge nas be givwat ane gen be givang ane nam ane, gile be avo givwat Pomate are. ");
INSERT INTO kbm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amolmol tepwengge ili love avos poke ge be avos givwat Pomate are tis ates gikurkuri ge be inei, “Galkik as mate etenik amei ali gen nangglus ge ti.” ");
INSERT INTO kbm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yisu gilgum gen bamo etok gikwai bekob gigas ane singamolomb gen be ile ihlang ikwai nam dabe etok be ile ve ivang. Ivang ve ile be Yisu na gile gili amol ti ebe geb kulkul takes ane ok gibweg ane nam aplo kulkul ane be Yisu ginei gitangi amol nok be ginei, “Utau ile Ayeu.” ");
INSERT INTO kbm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Liwi gimdil gikwai ane gen walang ok be giengk em giengk be gile givang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","As mate subu gile gikwai kob Liwi nok gilgum ben ve Yisu tis ane singamolomb-gen, beti amolmol subu ebe emb kulkul takes ane ok be tis eisir ebe amolmol ili eisir inei amolmol tiate ane ok, ile be imbweg ivin Yisu tis ane singamolomb-gen be tepwe en ben gisov dongke imbweg. ");
INSERT INTO kbm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bekob eisir Parisai be tis as gidung subu ebe emb Mose ane yaun dabin ok itangi Yisu ane singamolomb-gen ile be inei, “Gimdom be yem tis aim gidung umbweg uvin amolmol tiate ane be tis eisir ebe emb kulkul takes ane be iyo-iyo amolmol be inggas amolmol as mone subu givin sinsin-ge ok be on ben uvin eisir?” ");
INSERT INTO kbm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Beti Yisu giwel eisir Parisai avos be ginei bing-ai ti dang eteik, “Amolmol ebe utlas vie ok eisir ivang itangi amol ebe geb-geb marasin ve amolmol gimat ane ok ite ma, bemem eisir ebe tis gimat ok ge ete itangi amol marasin ane ile ve in-gas marasin.” ");
INSERT INTO kbm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Be Yisu ginei, “Ayeu ganme ve namb amolmol ebe ili is ate inei eisir amolmol vie ane ok ru ite, bemem ayeu ganme ve namb amolmol ebe ivang isov aiweng tumi aplo ok ge ru.” ");
INSERT INTO kbm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amolmol subu ile be iutani Yisu be inei: “Nam nambed be Jon ane singamolomb-gen tis eisir Parisai iyamar ben tis as mate subu ve miengk ane be miam singamolomb-gen ilgum dangetok ite?” ");
INSERT INTO kbm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Be Yisu giwel eisir avos be ginei, “Ginei ayeu nambweg navin angg amolmol-gen, okob sawa ete ayeu gabweg gavin eisir ok atob eisir aplos bunam ite ma. ");
INSERT INTO kbm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bemem ginei ayeu navang nakwai eisir okob atob eisir aplos bunam be inen ben ite.” ");
INSERT INTO kbm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bekob Yisu ginei bing-ai ti gipil Pomate ane luev be tis eisir Juda as luev, ve ginei intak gen ailu etok nipil dongke bwaya, be ginei, “Amol ti giker wain ebe vaku ok gisov bwelk ulis ebe muanggane ok ite, ve ginei ei nilgum dangetok okob atob wain vaku etok nitun bwelk ulis muanggane etok be nitip kob atob wain nimsuli. ");
INSERT INTO kbm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Be amol ti gitav ane nam vaku ti bekob geb ark ebe nolge muanggane be giti-titip ok gipil ane nam vaku etok ite, ve atob wavin tis ur nilgum be ark etok atob niti-titip seukie-ngge nikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Be Yisu ginei, “Dangetok be eitit tanemb gen vaku isgabu ge nipil dongke okob atob gen etok isgabu ge niengk vie.” ");
INSERT INTO kbm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Be Yisu ginei, “Amolmol ebe ivang mul ve luev muanggane etok ge nangge ok, eisir bwais ve luev vaku etenik be inei, luev muanggane ebe warik ok okob vie molge gitlek.” ");
INSERT INTO kbm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yisu tis ane singamolomb-gen ilauk ivang um ti aplo givin Sonda Sabat, be eisir singamolomb marav-ges is be ile ipis yanggo ve inavse be inen. ");
INSERT INTO kbm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Beti eisir Parisai ili be ile inei gitangi Yisu be inei, “Miam singamolomb-gen ilgum gen gitlek molge, ve galkik as mate etenik etek Sonda be amol ti gitangi ebe ve nilgum kulkul tis Sonda ok ite bemem miam singamolomb-gen ande ilgum. ");
INSERT INTO kbm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Be Yisu giwel eisir avos be ginei. “Yem wat usam yaun ebe Dawit gilgum ok ite me?” Be Yisu ginei, ");
INSERT INTO kbm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“Dawit tis ane amolmol-gen marav-ges is love Dawit gisov Pomate ane lum mateu ane aplo gile be amol ebe geb kulkul da ane ok geb ben ebe emb ve da gitangi Pomate ok gitangi Dawit be givwat gile be tis ane amolmol-gen en ben etok. Be ben etok gitangi ebe atob amolmol ebeok ane sinsin-ge inen ok ite ma, etok eisir ebe emb kulkul da ane ok ge atob inen ben etok.” Yisu ginei yaun etok veik amolmol inatpweng are inei gitangi ebe ve tanalgum kulkul tis Sonda ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Be Yisu ginei, “Sonda ane tame Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, be Ayeu Amol eteik ebe ve nanei be amolmol inalgum kulkul tis Sonda nivin ok.” ");
INSERT INTO kbm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Givin Sonda Sabat ti vukuri Yisu gisov lum mateu ane aplo gile be ginei mateu gitangi amolmol givang. Be amol ti ebe bage tavlu muaimuai ok ei gibweg lum aplo givin ve giute giute mateu ebe Yisu ginei ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Be givin sawa etok eisir Parisai be tis gidung subu ebe emb Mose ane yaun dabin ok irek luev ebe ve inalgum yaun nipil Yisu ok. Beti eisir nas ginal Yisu vie-ngge be ilgum ve indi velob Yisu nilgum kulkul ve nilgum amolmol ebe tis gimat ok be utlas vie vukuri tis Sonda me ma? ");
INSERT INTO kbm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bemem Yisu ande gitpweng yaun ete eisir tas gitung ok are gikwai, beti ginei gitangi amol bage muai-muai ebok be ginei, “Umdil be unme uvarkei ebe mate ane ik.” Amol nok gimdil be gile givarkei mate ane, ");
INSERT INTO kbm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","bekob Yisu giutani amolmol tepwengge be ginei, “Eitit taute yaun ret givin Sonda walang ok? Tanemb amolmol ru, me tanes amolmol vunkunu?” ");
INSERT INTO kbm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yisu na giro amolmol tepwengge ta giwei-giwei love kob ginei gitangi amol bage muai-muai ebok be ginei, “Uto bagem.” Amol nok gilgum gitangi ete Yisu ginei ok be seukie-ngge bage ande gile vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bemem eisir Parisai be tis gidung ebe emb Mose ane yaun dabin ok ebe imbweg lum aplo ok, aplos tiate molge gitangi Yisu ve ebe gilgum amol etok bage be vie vukuri givin Sonda ok be inei ve is ate be inei, “Atob eitit tanalgum amol etenik nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Givin sawa ti Yisu gireu mate dubi ti gile ve nes miengk nitangi Pomate. Ei givang ete matendubi ok gitangi tambok ti ungglus ve ges miengk. ");
INSERT INTO kbm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Be givin tistumi ei gital ane amolmol gen ebe itau ile ei ok be itangi ei ile be geb eisir nok gitangi 12 be gital eisir ares ginei “Aposolo.” ");
INSERT INTO kbm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eisir nok as amol ti are Saimon, (be Yisu gital ei are ti ginei Pita), gabu male Endru be Jakobos gabu Jon, Pilip gabu Batolomai, ");
INSERT INTO kbm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","be Matai gabu Tomas be Alapai natu Jakobos. Be Saimon ebe warik gilgum ve nitin amolmol Rom ane inkwai Israel as taku ok, ");
INSERT INTO kbm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","be Jakobos natu Judas, be Judas Iskariot, amol ebe asonge ninei Yisu binge nitangi amolmol valir ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisu tis ane amolmol 12 etok isov nangge mate dubi ile love ile vunge ve amolmol dubi bamo ti nangge taku galav ti be tepwe ivarkei etok. Be amolmo nangge Jerusalem be nangge Judaia be Taia tis Saidon as taku gideb gielk ane inggas as amolmol ebe tis gimat ok be ile imbweg etok ");
INSERT INTO kbm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ve inaute mateu ebe Yisu ginei ok. Be eisir tas givin ve Yisu nilgum eisir as amolmol ebe tis gimat ok be utlas vie vukuri beti inggas eisir ebe tis gimat ok givin be ile. Beti Yisu gilgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri be gitin ngalau tiates ile ihlang ikwai amolmol ebe ngalau tiate givang givin is ok weik etok ge. Amolmol ebe tis gimat ok, bais gile giwei Yisu utle ulis ge be seukie-ngge Yisu ane gwangne gilgum eisir utlas be vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Beti amolmol tepwengge ili be lolos ve inde be intak bais niwei utle ulis ge. ");
INSERT INTO kbm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisu na giro ane singamolomb-gen ta be ginei; “Yem amolmol ebe lolongg aim ve un-gas Pomate ane gen vevies ok, yem unvang tis tangg aim vevie-ngge ve Pomate ei yem aim Amol Bamo (King) ebe geb yem dabin ok, be ei ane gen walang ok, etok yem ge aim gen. ");
INSERT INTO kbm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Be yem amolmol ete galkik marav-ges aim nik, yem tangg aim vevie-ngge ve asonge yem un-gas aim gen vevies ge nindeb mul ane. Be yem amolmol ete galkik uteng uvang nik, yem tangg aim vevie-ngge, ve asonge yem unambweg be unmalk ge unambweg. ");
INSERT INTO kbm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Be yem ete ande uvang mul ve Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, asonge amolmol indi aim be tas vavis be inaitin aim, be atob inei yaun ungglus-ungglus be intal gen tiates arkares nipil yem. Bemem ayeu nanei nitangi yem. Yem tangg-aim vevie-ngge ve gen ete eisir veve inalgum nitangi yem ok ane. ");
INSERT INTO kbm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Warik eisir tumbus-gen ilgum gen weik etok ge gitangi Pomate ane amolmol kulkul ane. Be unaute kob: Asonge nindeb mul ane atob yem un-gas aim gen vevies tepwe. ");
INSERT INTO kbm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bemem gen etok bunam molge ve amolmol ete galkik imbweg tis tas vevias ge ok, ve eisir ande inggas as gen walang ok gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Be yem amolmol ete galkik omb kulkul ve uvkwen aim ate ge uvang nik, yem ok undi aim ate ge. Ve asonge nindeb mul ane atob yem marav-nes aim vunkunu. ");
INSERT INTO kbm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Be yem ebe amolmol subu avos givwat yem arengg aim ok, yem undi aim ate ge, ve gen vevies ete amolmol ilgum gitangi yem ok ete atob nilgum yem ate weik ebe gen sin-ge ti ok. Be unaute, Warik yem aim bambamo-nggen ilgum gen weik etok ge gitangi amolmol ebe iyo inei eisir Pomate ane amolmol kulkul ane ebe inei Pomate avo ok.” ");
INSERT INTO kbm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Be Yisu ginei, “Ayeu nanei nitangi yem ete galkik umbweg etenik be ute awangg yaun nik: Tangg aim nivin amolmol ete ve ines valir nitangi yem ok, be unalgum gen vie-ngge nitangi amolmol ete ili yem tiate be utlas bua ve yem ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Be unes miengk nitangi Pomate be unautani ei ve nemb eisir ete ilgum yem tiate be tis amolmol ete veve ines valir nitangi yem ok ru. ");
INSERT INTO kbm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ginei amol ti givtav mie gisov paptem tavlu, okob mie nuro imate vukir be ei nivtav tavlu nivin weik etok ge. Be ginei amol ti giutani mie ve nomb am kup ti nitangi ei, okob mie nomb am kup malar ane nitangi ei nivin. ");
INSERT INTO kbm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Be ginei amol ti giutani mie ve am gen ti ane, okob mie nomb am gen etok nitangi ei, be ginei amol ti niutani mie ve nivwat miam gen ti, okob mie nutani ei ve atob ei nemb gen ret niwel miam gen etok ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Be gen ret ret ete yem tangg-aim givin ve amolmol inalgum nitangi yem ok, ete yem unalgum gen weindongke nok ge nitangi eisir weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Be tangg-aim nivin amolmol ete tas givin yem ok ge ite ve etok vie ite. Ve etok amolmol valir ane be tis amolmol ebe iute mateu ite ok as luev etok. Eisir tas givin amolmol ebe tas givin eisir ok ge. ");
INSERT INTO kbm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Be ginei yem tangg aim nivin amolmol ete tas givin yem ok ge, okob Pomate gitangi ebe atob nemb ane gen vevies nitangi yem ok ite. Ve amolmol tiate ane ok ilgum gen weik etok ge, eisir tas givin amolmol ebe tas givin eisir ok ge. ");
INSERT INTO kbm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ginei yem unemb gen nitangi amolmol be tangg-aim nitung unei eisir inemb gen ti niwel yem aim gen ete omb gile ve eisir ok, okob Pomate atob nemb gen vie ti nitangi yem ite, ve amolmol tiate ane ok ilgum gen weik ete yem ulgum ok givin. ");
INSERT INTO kbm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yem tangg-aim nivin amolmol ebe ili yem tiate ok, be ginei veve unemb gen nitangi amolmol, okob tangg aim nitung ete ve unvwat aim gen etok ane den ninumul ok bwaya. Ginei yem unalgum dangetok, okob atob Pomate ebe gibweg gulumb ok nital yem ninei natu-nggen, be atob yem un-gas aim gen vevies ge nindeb mul ane. Ve Pomate ei ta givin amolmol walang ok, vie be tiate gipil dongke. ");
INSERT INTO kbm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dangetok be yem tangg aim viti ve amolmol dangete Pomate ta viti ve yem ok.” ");
INSERT INTO kbm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yem undi aim ate weik ebe Pomate ok be unalgum amolmol subu as yaun nitlek molge nile ite, ve Pomate atob nilgum yem ok aim yaun weik etok ge. Be gen ete yem ulgum gitangi amolmol sukus ok ete atob Pomate nilgum gen nok ge nitangi yem nivin weik etok ge. Yem tangg aim nivalngan gen tiate ete amolmol ilgum gitangi yem ok, veik atob Pomate ta nivalngan yem aim gen tiate ebe ulgum ulgum ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Be kaleuk ve amolmol bwaya ve Pomate ei kaleuk ve yem ite, ei geb gen walang ok gitangi yem tis as mate walang ok, veik ginei nindeb mul ane atob yem un-gas aim gen vevies ge. Be yaun ret ret ete yem unei gipil amolmol sukus ok yaun nok ge ete asonge Pomate ninei nipil yem nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be Yisu ginei bing-ai ti gitangi eisir be ginei; “Amol matano bop ti gitangi ebe ve nitwem ane nune ti ebe matano bop weik ei ate ane ok ite, ve atob gabu inrau inde ei dabe be amolmol ebe ivang nam luvwe ok. ");
INSERT INTO kbm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Be nunus lum ane ti gitangi nitlek ane gidung be nimbul nunus ok ite, ei nisov ane gidung ane yaun ane lu be nilgum gen walang ok love yapin kob atob ei menihlang weik ete ane gidung ok.” ");
INSERT INTO kbm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Be Yisu ginei, “Nam nambed be mie guli be gupasang mie ate am gen tiate ebe gulgum ok gimungg ite be guli amol ti ane tiate ebe gilgum ok be gunei, ");
INSERT INTO kbm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","‘Ret ginei beti mie gulgum gen tiate etok?’ Bemem mie ate ok gulgum gen tiate walang ano gitlek amol etok ane tiate ete gilgum ok. Mie amol bingkasop ane, Mie nuli be nupasang mie ate am tiate nimungg bekob nupasang amol ti ane nindeb mul ane. ");
INSERT INTO kbm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Be Yisu ginei, “Ei ebe vie ok ti ges ano tiate ti ite ma, be ei ebe ges ano tiate ok, ges ano vie ti ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Be ei walang etenik amolmol itpweng are giengk ane ano gitang-tangi ge, be ile isut weiwei nangge wal duduli aplo ite, me avi nangge gigwangk aplo ite ma! ");
INSERT INTO kbm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dangetok be amol ti ginei ta nitung yaun vie-ngge niengk aplo, atob ei nilgum ane gen walang ok vie-ngge. Be amol ti ginei ta nitung gen tiate nemb aplo avwut atob ei nilgum gen tiate weik etok ge. Ve gen ret ebe amolmol tas gitung giengk aplos ge ok ete inei vusa gile gihlang avos.” ");
INSERT INTO kbm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Be Yisu ginei, “Gimdom be yem utal ayeu unei “Amol Bamo,” bekob ulgum gen walang ebe ayeu ganei gitangi aim ve unalgum ok ano gile ite? ");
INSERT INTO kbm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amolmol ebe itangai ayeu inme be iute awangg yaun be tas givin ve inalgum ano nile ok, ");
INSERT INTO kbm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","eisir etok ete weik amol ebe gitav ane nam tis twelk ok. Be givin ebe ur gisov be bui-vot gitimb taku ok bemem nam nok givarkei gwangne, ve gisov nam nok ane twelk gisov nalk aplo gile ve giminem beti givarkei gwangne. ");
INSERT INTO kbm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bemem amolmol ebe iute awangg yaun be bwais ve inalgum ano nile ok, eisir etok ete weik amol ebe gitav ane nam twelk ma be gitak giwei nalk dobo sin-gege ok. Be givin ebe ur gisov be bui-vot gitimb taku ok be bui gitut nam nok be gihlu gile gitak seukie-ngge be bui gitut gen walang ok giriv be gira.” ");
INSERT INTO kbm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisu ginei yaun walang etok gitangi amolmol love ma gikwai kob tis ane singamolomb-gen imdil ile Kapenaum. ");
INSERT INTO kbm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Be nangge etok amolmol Rom ane as amolmol valir ane as amol bamo ti ebe geb is dabin nangge taku etok ok, ane amol kulkul ane ti ebe ei ta givin gitlek ok gigas gimat love kasopge be nimat vunu. ");
INSERT INTO kbm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amol bamo nok giute Yisu binge beti gihlin bambamo subu (awaga) ebe emb lum mateu ane dabin nangge Judia as taku ok ve inde be inei nitangi Yisu ve nile be nilgum ei ane amolmol kulkul ane nok be utle vie kob. ");
INSERT INTO kbm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Beti bambamo nok ile love imbielk ve Yisu be inei yaun gwangne gitangi ei be inei, ");
INSERT INTO kbm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“Amol etok ei amol vie ti be ei ta givin amolmol gitlek, ei geb mone gitangi amei be pasang amei nam ti ebe ve anei uye be anes miengk nitangi Pomate nangge ok. Be amol nok ta givin anongge ve ginei mie nule be nomb ei ru be nulgum ei ane amol kulkul ane etok be utle vie kob.” ");
INSERT INTO kbm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Beti Yisu givin eisir nok be inumul ile. Yisu givang love gile gibloblo nam be amol bamo nok gihlin ane nune-nggen subu be itangi Yisu ile be inei ei avo gitangi Yisu dang eteik; “Amol Bamo, Uli velob nuyaing imate be nusov awangg nam aplo nunme. Ve ayeu gali ganei ayeu gitangi ebe ve mie nusov awangg nam aplo nule ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Be givin ve ayeu gitangi ebe atob natangi mie nalek ok ite weik etok ge ve ayeu amol tiate ane roro. Bemem ayeu gatpweng are ginei mie gitangi atob nunei yaun ve avom ge be awangg amol kulkul ane etok utle vie vukuri ok. ");
INSERT INTO kbm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Be ayeu ok weik etok ge, ayeu gavang gasov angg amol bamo ebe geb ayeu dabin ok ane gwangne ane lu, be awangg amolmol valir ane ebe gab is dabin ok, eisir ivang isov awangg gwangne ane lu weik etok ge. Dangetok be ginei ayeu nanei nitangi angg amol ti be nanei, “Ule!” Atob ei nile, be ginei nanei “Unme!” Atob ei ninme. Be ginei nanei nitangi angg amol kulkul ane ti be nanei, “Ulgum gen etok!” Atob ei nilgum dangete ayeu ganei ok.” ");
INSERT INTO kbm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yisu giute amol bamo nok ane yaun etok be gikuri vunungge be girau lili be ginei gitangi amolmol ebe itau ile ei ok be ginei, “Ayeu gali amol ti ebe aplo givin ayeu weik ete amol etenik ok ti givang ite molge, love nangge Israel be tis taku subu ok givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bekob amolmol ebe ile inei yaun lavo gitangi Yisu ok inumul ile be ili amol bamo nok ane amol kulkul ane ebok ande utle vie be gimdil be gibweg. ");
INSERT INTO kbm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yisu gilgum gen bamo etok gikwai bekob tis ane singamolomb-gen ikwai nam dabe etok be ile nam dabe ti are Nain, be amolmol dubi bamo ti itau ile ei tis ane singamolomb gen ve ile. ");
INSERT INTO kbm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yisu tis ane singamolomb gen ivang love ile imbloblo nam be ili amolmol dubi bamo ti ebe inggas gimat ti ile ve inaspun ok. Be gimat nok avie tupe ti natu amol dongke etok ge be ande gimat vunu beti amolmol inggas ile ve inaspun. ");
INSERT INTO kbm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Amol Bamo (Yisu) gili avie tupe nok love ta viti anongge ve avie nok ane beti ginei gitangi ei be ginei, “Kamoke, be uteng bwaya.” ");
INSERT INTO kbm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Be Yisu givang gitangi eisir ebe ivwat gimat ok gile be gitak bage giwei ei-pakpak be amolmol ebe ivwat gimat ok ivarkei ta. Be Yisu geb avo ponge be ginei, “Amol natu, Ayeu nanei be mie matawem be numdil vukuri!” ");
INSERT INTO kbm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Be seukie-ngge amol nok matawe vukuri be gimdil be kakie, bekob Yisu geb ei gitangi tine gile vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Amolmol tepwengge ili gen etok love avos poke-ngge be avos givwat Pomate are be inei, “Eitit and amol gwangne ti ebe ginei Pomate avo ok (Propet) galkik gimdil nangge eitit be givarkei. Be galkik etenik Pomate ande ginme ve nemb ane amolmol gen ru.” ");
INSERT INTO kbm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Be gen bamo ete Yisu gilgum ve ges amolmol ebe imat vunkunu ok itkitin vukuri ok, ane binge givang geb Judaia as taku be tis nam dabe subu ebe giengk gibloblo Judaia as taku ok avwut. ");
INSERT INTO kbm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon ane singamolomb-gen inei gen bambamo ebe Yisu gilgum gilgum ok binge gitangi ei be giute, beti gital ane amol ailu be itangi ei ile ");
INSERT INTO kbm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","be gihlin sulu be ivang itangi Amol Bamo (Yisu) ile be iutani ei be inei, “Mie Amol etenik ebe warik Jon ginei ane yaun ve asonge ninme ok, me amol nok givang nangge?” ");
INSERT INTO kbm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Givin ebe amol ailu nok imbielk ve Yisu ok be gabu inei, “Jon ebe ges bui sanggu gipil amolmol ok gihlin eilu beti anme ve anautani mie be anaute lavo, ve Mie Amol etenik ebe Jon ginei ane yaun ve asonge ninme ok me amol nok givang nangge?” ");
INSERT INTO kbm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Be givin sawa etok ge Yisu gilgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri, be gitin ngalau tiate ile ihlang ikwai amolmol ebe ngalau tiate ivang ivin is ok, be gilgum amolmol ebe matanos bop ok be ili taku vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Beti Yisu giwel amol ailu nok avos be ginei, “Gabu undumul unde be unei gen bambamo ete ande uli be ute nik binge nitangi Jon be unei, Amolmol ebe matanos bop ok ande ili gen vukuri be eisir kubuk ane ande ivang vie, be amolmol ebe tis bid nam vu ok ande utlas vie vukuri. Be eisir ebe talngas avo tiate be gitangi ebe ve inaute yaun ite ok ande iute yaun. Be Pomate ane yaun (mateu) ande amolmol inei geb taku avwut.” ");
INSERT INTO kbm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Be Yisu ginei, “Amolmol ebe tas givin ayeu ano molge ok, eisir invang tis tas vevias ge.” ");
INSERT INTO kbm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon ane amol ailu ebok ile ikwai kob Yisu ginei Jon nok ane yaun gitangi amolmol bambamo ebe imbweg ok be ginei, “Warik yem ule taku sawa ve undi amolmol me, ve undi gen sin-ge ti? ");
INSERT INTO kbm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Me yem ule ve undi amol ti ebe gino kup vevies ge ok? Ma yapin! Amolmol ebe ino kup vevies ge ok eisir imbweg nangge amol bamo (king) ebe geb amolmol dabin ok ane nam ge! ");
INSERT INTO kbm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Be yem ule ve undi amol ret? Ve undi Pomate ane amol kulkul ane (Propet) ti ebe ginei Pomate avo ok me?” Be Yisu ginei, “Bingano, Ayeu nanei nitangi yem, Amol etok ei gitlek Pomate ane amolmol kulkul ane subu. ");
INSERT INTO kbm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Be amol nok ete warik Pomate ane amolmol kulkul ane ebe inei Pomate avo ok inei ei ane yaun ok. Ve Pomate ginei gitangi Amol (Kilisi) ebe ve nemb amolmol ru ok be ginei, ‘Atob ayeu nahlin angg amol yaun ane ti be nimungg nile be nipasang miam luev nangge amolmol aplos yapin.’” ");
INSERT INTO kbm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Be Yisu ginei, “Ayeu nanei nitangi yem, Jon ebe givarguv amolmol ok ei amol vie molge gitlek amolmol tepwengge nangge nalk. Bemem amol sin-ge ti ginei ta givin ve Pomate nemb ei dabin, okob amol etok ei atob nitlek Jon, ve Jon ei ate gisov taku ebe Pomate geb amolmol dabin ok gile ite ma, ei ginei taku nok ane yaun ge gimungg.” ");
INSERT INTO kbm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Amolmol ebe emb kulkul takes ane ok be tis eisir ebe warik iute mateu ebe Jon ginei be isov ane lu ge be iringk bui sanggu ok, tepwe imbweg be itu talngas ve yaun ete Yisu ginei ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bemem eisir Parisai be tis gidung ebe emb Mose ane yaun dabin ok eisir ivkir dumas gitangi luev vie ete Pomate geb gitangi eisir ok be bwais ve Jon nes bui sanggu nipil eisir. ");
INSERT INTO kbm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Be Yisu ginei atob ayeu namb bing-ai ti nipil amolmol as mate etenik ane bekob. “Amolmol as mate etenik ane bwais ve ret indi amolmol ebe ve inei mateu nitangi eisir ok. ");
INSERT INTO kbm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bemem eisir ilgum gen weik nunus natu-natu ebe ivang nam luvwe-luvwe ok. Ve nunus dubi ti atob intal yaun nitangi eisir dubi ti be inei, ‘Amei as amb bemem yem bwaingg aim ve ret vangg-ai dubi supsupwe. Be amei algum uye tangir ane, bemem yem bwaingg aim ve ret unalgum tangir.’” ");
INSERT INTO kbm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Be Yisu ginei, “Jon ebe ges bui sanggu gipil amolmol ok ginme be gen ben be ginum bui vevie ite be yem uli be unei ngalau tiate ti wat givang givin ei. ");
INSERT INTO kbm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Be Pomate Natu Ayeu ebe meng gahlang weik amolmol ok, ganme be gan be ganum, kob yem unei ayeu bom-tinangg tiate molge. Be amolmol ebe emb kulkul takes ane ok be tis eisir tiate ane as nune ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bemem amolmol ebe tas givin ve inaute Pomate ane mateu ok, eisir itpweng are inei Pomate ane luev ei gen vie dongke.” ");
INSERT INTO kbm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisai amol ti gigas Yisu gile ve nen ben nangge ane nam. Yisu gisov amol nok ane nam aplo gile gibweg ve nen ben, ");
INSERT INTO kbm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","be avie wasi tine ti ebe gibweg nam dabe etok ok giute ebe Yisu ande gile gibweg Parisai amol etok ane nam ve nen ben ok binge, beti ei givwat marasin ukwas vie molge ti gisov ane genmate ti be gile. ");
INSERT INTO kbm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Avie nok gile givarkei gideb Yisu dume mul ane gibloblo Yisu va be giteng be matano rulu ting-teng gisov Yisu va bekob gisin ve ei ate dabe lan. Bekob gimsuli marasin ukwas etok be giro gireu Yisu dabe. ");
INSERT INTO kbm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Be amol ebe gigas Yisu gile ane nam ok gili gen ebe vie wasi tine etok gilgum gitangi Yisu ok be ta gitung, “Ginei amol etenik ei Pomate ane amol kulkul ane ti roro-ngge atob ei nitpweng avie ete bage gile ei nik are seukie-ngge ve ei avie wasi tine ti etenik.” ");
INSERT INTO kbm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yisu ande gitpweng amol nok ane ta gitung etok are gikwai beti ginei, “Saimon, Ayeu veve nanei yaun ti nitangi mie okob.” Be Saimon ginei, “Gidung, Unei ma!” ");
INSERT INTO kbm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Be Yisu ginei, “Amol ailu ivwat mone nangge amol ti be gabu inei bwayage kob atob sulu inwel ei ane mone etok. Amol ti givwat K500. be nune givwat K50. ");
INSERT INTO kbm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bemem sulu isgabu ge gitangi ebe ve ines mone nok ane den vunu ok ite beti amol ebe sulu ivwat mone nangge ok ginei gitangi sulu ve tas nitung yaun mone nok ane vukuri ite ve ande ei ta givalngan gikwai.” Beti Yisu ginei gitangi Saimon be ginei, “Mie tam gitung gunei sulu ailu etok as amol ret atob ta nivin amol ebe sulu ivwat mone nangge ok nitlek molge?” ");
INSERT INTO kbm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon giwel Yisu avo be ginei, “Amol ebe givwat K500. ok. Be Yisu ginei, “Mie gunei gile gitangi roro-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bekob Yisu giro na vukir gitangi avie ebok be ginei gitangi Saimon be ginei, “Ande mie guli avie eteik me ma? Ayeu gapil miam nam ganme bemem mie gob bui ebe ve ayeu navuk vangg ok gitangi ayeu ite, bemem avie etenik ei givuk ayeu vangg ve matano rulu bekob gisin gibui ve dabe lan. ");
INSERT INTO kbm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Be mie gulgum gen gitangi ebe amei Juda amei luev ebe asavi baingg amei ok be gusavi ayeu baingg ite, bemem avie etenik ei gilgum gen vie molge gitangi ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Be mie gutak gen ukwas ti gireu ayeu dabangg lan weik ebe amei Juda algum algum ok ite, bemem avie etenik gitak marasin ukwas vie molge etok gireu ayeu vangg. ");
INSERT INTO kbm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dangetok be ayeu nanei nitangi mie, Avie etenik ta givin ayeu ano molge, be ei ane ta givin etok ges ru ve ei ane gen tiate ebe gilgum gilgum ok ande Ayeu gasin gikwai.” Be Yisu ginei, “Amol ti ginei gitpweng are ginei ei gilgum gen tiate walang ano bemem ei gili ginei ande Pomate gisin ei ane gen tiate etok tepwengge gikwai, amol etok ei ta givin Pomate ano molge.” ");
INSERT INTO kbm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bekob Yisu ginei gitangi avie ebok be ginei, “Ande ayeu gasin miam gen tiate ebe gulgum ok gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Be amolmol subu ebe imbweg ve en ben ivin Yisu ok iute yaun ete Yisu ginei gitangi avie etok ok be inei ve isate be inei, “Amol etenik ei amol ret, beti ginei ei gitangi ebe ve nisin amolmol as gen tiate ebe ilgum ok nikwai ok?” ");
INSERT INTO kbm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bemem Yisu ginei gitangi avie ebok be ginei, “Mie aplom givin Pomate beti miam aplo givin etok ge ete gilgum mie be viem vukuri. Dangetok be nule tis tam vevie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","As mate subu gile gikwai kob Yisu tis ane singamolomb-gen ivang emb nam dabe walang ok avwut be inei mateu gitangi amolmol gipil luev ebe Pomate geb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Be avie gaptol subu ebe warik Yisu gitin ngalau tiate ile ihlang gikwai is be gilgum as gimat be utlas vie vukuri ok itau gile Yisu tis ane singamolomb-gen. Avie gaptol nok ete Malia, (ebe ital are ti inei Magdala ok) ebe warik Yisu gitin ngalau tiate gitangi 7 ile ihlang ikwai ei ok, ");
INSERT INTO kbm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","be amol bamo Herodes ane amol ebe geb ei ane nam dabin ok, Kusa arwe Joana gabu Susana be tis avie gaptol subu givin. Eisir avie dubi etok ebe ivang ivin Yisu tis ane singamolomb gen be emb is dabin ok. ");
INSERT INTO kbm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Givin ebe Yisu gibielk nam dabe walang ok, be amolmol iro is-ate sut itangi ei ile gitang tangi nam ge ve gile. Beti Yisu ginei bing-ai ti dang eteik, ");
INSERT INTO kbm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amol ti gile ve nindawi ben uve nangge ane um. Amol nok gidawi ane ben uve givang be subu bingbleng gisov luev be amolmol ivang iwei be mank ile be en gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Be subu gisov nalk ebe tis vat ok, beti ben nok gireu vie molge bemem bwayage kob gireu maingo-maingo love ok ti gimat ve nalk etok sisi ma. ");
INSERT INTO kbm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Be ben uve subu bingbleng gisov euk dabe dabe be euk nok gireu love ges ben etok vunkunu. ");
INSERT INTO kbm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bemem ben uve subu ebe bingbleng gisov nalk vie ok, ete gireu vie-ngge love ges ano anongge molge.” Be Yisu ginei gitangi amolmol, “Ginei yem talngangg aim avo giengk, okob unaute yaun ete ayeu ganei nik vevie.” ");
INSERT INTO kbm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eisir singamolomb itangi Yisu ile be iutani ei be inei, “Bing-ai ete galkik mie gunei ok ane dabe nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Be Yisu giwel eisir avos be ginei, “Pomate ges yaun ebe givuaivun ete ge gipil taku ebe geb amolmol dabin ok ru gitangi yem gikwai. Bemem amolmol subu iute yaun etenik be ili weik ebe bing-ai sin-gege ok, beti eisir ok ili gen ve matanos bemem atob indi gen ano ti ite, be eisir ok talngas-avo iute yaun bemem atob inatpweng gen ti are ite, ma.” ");
INSERT INTO kbm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Be Yisu ginei, “Bing-ai etok ane dabe dangeteik, Ben uve etok weik Pomate ane yaun (mateu). ");
INSERT INTO kbm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Be ben uve ete gisov luev ok ete weik amolmol ebe iute mateu bemem Sadam ta gitung ve ginei lob eisir aplos nivin Pomate be Pomate nemb is ru, beti ei ginme be girwel mateu nok gikwai eisir aplos. ");
INSERT INTO kbm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Be ben uve ete gisov nalk tis vat ok weik amolmol ebe iute mateu be itpweng are seukie-ngge be tas vevias ge, bemem ginei gen bunam nalk etenik ane ti, me amolmol in-go eisir nisov mateu, atob eisir inavkir dumas nitangi Pomate seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Be ben uve ete gisov euk dabe-dabe ok, etok weik amolmol ebe iute mateu ok iute, bemem eisir aplos bunam be tas gitung mone be tis gen nalk ane geb aplos avwut. Beti eisir gitangi ebe atob inalgum yaun ete iute ok ano nile ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bemem ben uve ebe gisov nalk vie ok, ete weik amolmol ebe iute mateu be ipasang giengk aplos be tas givin ve inalgum yaun etok ano nile ok.” ");
INSERT INTO kbm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Be Yisu ginei, Amol ti gitung lam bekob givandung kikiel giwei ite ma, ei giravi gikaiwel lavo ebe iravi gikaiwel ok veik niro be amolmol ebe ve inde ei ane nam ok atob indi vas lavo vevie. ");
INSERT INTO kbm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Be gen ebe giengk aiweng tumi ok atob niengk nitip ge, be gen ebe givuaivun ate ge ok atob indi be inde inemb nile nihlang.” ");
INSERT INTO kbm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Be Yisu ginei gitangi eisir be ginei, “Yaun ete yem ute nik, tangg aim nitung vevie-ngge. Ve amol ti ginei ninggas ane ta gitung vie ebe giengk aplo ok ta gwangne ge, atob ei nitpweng gen subu are nivin. Bemem amol ti ginei bua ve ninggas ane ta gitung vie ebe giengk aplo ok ta, atob Pomate ninggil-gili dabas gwet gen subu ane nitangi ei weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yisu tine be tis male-nggen ile ve indi ei, bemem sotol gitangi ebe ve inde inambloblo Yisu be kakie invin ei ok ite ve amolmol iro isate sut itangi Yisu ile love sawa ma molge. ");
INSERT INTO kbm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Beti amolmol inei gitangi Yisu be inei, “Am male-nggen tis tinas ete ande inme ok be eisir tas givin ve indi mie.” ");
INSERT INTO kbm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Beti Yisu ginei gitangi amolmol tepwengge be ginei, “Amolmol ebe iute mateu be tas givin ve inalgum ano nile ok, eisir etok ete weik ayeu tinanggen be angg male-nggen.” ");
INSERT INTO kbm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","As mate ti Yisu ginei gitangi ane singamolomb-gen ve ines bui gili inde inpil bui tavlu, -beti ile ipil as ei-vovo be ilaik ve ile. ");
INSERT INTO kbm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Givin ebe ei-vovo gituvki givang ok be Yisu matano giengk beti gile bupwe be giengk. Be wavin givang bamo molge love ane tine tiate molge be gielk gikari gisov ei-vovo be eisir singamolomb ilgum love ili ma. ");
INSERT INTO kbm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Beti ile es Yisu itin be inei; “Amol Bamo, Eitit atob tansov gielk be tanmat vunu tankwai!” Yisu gimdil be ges bing ve wavin tis ngal be seukie-ngge wavin gituvi be ngal gitak love bongong vie molge. ");
INSERT INTO kbm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bekob ginei gitangi ane singamolomb-gen be ginei, ‘Nam nambed be yem uvarkei gwangne ite be aplongg aim ailu-ailu?” Bemem eisir singamolomb iute ei ane yaun ete ginei gitangi eisir ok ge, be inei yaun ti ite ve eisir avos poke ge ve wavin tis gielk ebe iute ei avo ge be wavin gituvi be ngal gitak ok, be inei ve is ate be inei, “Amol ret dang etenik, ve ei ginei yaun ge gitangi wavin tis ngal bemem iute ei avo ge weik ebe amolmol ok.” ");
INSERT INTO kbm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","30","Yisu tis ane singamolomb-gen ivang love ile isov Gadarene as taku gideb bui tavlu ane. Be Yisu nangge ei-vovo be gile gitak ebe alus ok love gile vunge ve amol ti ebe ngalau tiate givang givin ei muanggane molge ok, be ngalau tiate nok ilgum be amol nok givang rial-rial ge. Be as mate walang ok amolmol emb ei ta be idgin ei bage tis va ta ve seng tis bidbid bemem ei giatyati seng tis bidbid etok be gile ve givang taku gimat ane, ei gibweg ta nangge nam ite molge. Ei gile ve givang matendubi bambamo be tis taku gimat ane gigas ta ge, be yayai be giure ate ve vat givang givang etok. Amol nok gili Yisu ebe givang aikawe nangge ok be yayai be gile givswen va dubi gitangi Yisu, be ngalau tiate ebe ivang ivin ei ok as amol ti gital yaun avo bamo ge be ginei, “Pomate Natu mie. Mie ve numdom nitangi ayeu? Ayeu nanei bingano-ngge nitangi mie, Uli ve nomb vavavne nitangi amei!” ");
INSERT INTO kbm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Be Yisu ginei yaun gwangne gitangi ngalau tiate nok be ginei, “Unde unahlang unkwai amol etenok.” Bekob Yisu giutani amol nok be ginei, “Mie arem ret?” Be ngalau tiate nok as amol ti ginei, “Amei arengg amei amolmol anongge.” Ve amei walang ano avang avin amol etenik! Be ngalau tiate nok ti ginei gitangi Yisu be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","“Mie nuhlin amei be anvang ankwai taku etenik be ande taku ebe ve an-gas vavavne nangge ok bwaya.” Be nangge taku etok bwelk nam dubi bamo ti en ben ivarkei matendubi ti gibloblo ge, beti ngalau tiate nok inei gitangi Yisu be inei, “Mie nuhlin amei be ande anatwep bweik bambamo etok aplos ande.” Be Yisu ginei; “Unde!” ");
INSERT INTO kbm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ngalau tiate nok ile ihlang ikwai amol etok be ile itwep bwelk bambamo nok aplos ile love ilgum be bwelk nok tepwengge ituvki isov rumbuk tiate ti ile love ile isov bui be inum bui be tepwengge imat vunkunu ikwai. ");
INSERT INTO kbm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Amolmol ebe emb bwelk etok dabin ok ili gen etok be ile inei binge gitangi amolmol nam ane be tis taku subu givin. ");
INSERT INTO kbm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Beti amolmol imdil ile ve indi inei gen ret ete ande meng-gihlang ok, eisir ivang itangi Yisu ile be ili amol ebe warik ngalau tiate givang givin ok ande gino kup be gibweg kamoke, be eisir avos poke-ngge ve gen bamo ete Yisu gilgum ok ane. ");
INSERT INTO kbm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Be eisir ebe ili gen etok gisov matanos ok iput lavo-lavo gitangi amolmol ebe ile ve indi ok givin. ");
INSERT INTO kbm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Be amolmol Gadarene ane ipelk ve isate ane anongge beti ile inei gitangi Yisu ve nikwai eisir as taku be nile ve nivang. Beti Yisu tis ane singamolomb-gen ile ipil as ei-vovo vukuri be ve ines bui gili inde inpil tavlu vukuri, ");
INSERT INTO kbm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","be amol ebe galk Yisu gitin ngalau tiate gikwai ei ok gile be ginei gitangi Yisu be ginei, “Ayeu ve navin mie!” Bemem Yisu gihlin ei ve nivang ane nam ane be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Unumul ule am nam ok be nunei gen bamo ete Pomate gilgum gitangi mie nik binge nitangi amolmol.” ");
INSERT INTO kbm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Amolmol anongge ile ve isge Yisu tis ane singamolomb-gen imbweg ete alus ok love ile isov be inggas ei tis ane singamolomb-gen nangge etok. ");
INSERT INTO kbm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bekob amol ti ebe geb lum mateu ane dabin nangge taku etok ok, are Jairus givang gitangi Yisu gile be gikari ate gile gitak nalk gideb Yisu na ane be ginei gitangi Yisu ve nivin ei be gabu inde ei ane nam ok bekob, ");
INSERT INTO kbm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ve ei natu avie dongke-ngge ane Sonda bamo gitangi 12 be gigas gimat love kasopge be nimat vunu. Beti Yisu gimdil be givin amol nok be gabu ile. Amolmol anongge molge ivang ile isung-sungi Yisu be tepwe ivang ve ile. ");
INSERT INTO kbm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Be avie ti ebe gigas avie as gimat tis as mate walang ok, be ei ane gimat etok giengk gitangi Sonda bamo 12. Be ei gilgum ve gikari ane mone bamo molge gipil amolmol marasin ane bemem ilgum ei ane gimat nok be vie ite. ");
INSERT INTO kbm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Avie nok givang gisov amolmol bambamo etok aplo love gile gibloblo Yisu dume be bage gile geb Yisu ane kup ge, bemem gimat etok gikwai ei seukie-ngge be ande utle gile lavo vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yisu ande gitpweng are gikwai beti giutani amolmol be ginei, “Amol me avie ret bage gile ayeu?” Bemem amolmol tepwengge tumi-ngge be inei yaun ti ite. Beti Pita ginei; “Gidung, Amolmol anongge molge ivang ile isung-sungi mie ge be amol ti wat girau gile mie me?” ");
INSERT INTO kbm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bemem Yisu ginei; “Ma yapin! Amol me avie ti wat bage gile ayeu. Ve sawa ete avie me amol etok bage gile ayeu ok ete awangg gwangne subu gile gihlang gikwai ayeu be gile!” ");
INSERT INTO kbm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Be avie ebe bage gile Yisu ane kup ok gilgum ve nimumu ate-ngge bemem gilgum be gitangi ite. Beti ei givang gitangi Yisu tis ate gireu ge gile be gikari ate gile gitak nalk gibloblo Yisu va nangge amolmol tepwengge nas be ginei ate lavo lavo gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Beti Yisu ginei gitangi ei be ginei; “Mie aplom givin, beti gilgum be utlem vie vukuri, dangetok be nule tis tam vevie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Givin ebe Yisu ginei yaun givang ge nangge ok, be amol ruer ane ti nangge Jairus ane nam ok gile be ginei gitangi Jairus be ginei; “Natum avie ande gimat vunu, be unggas Yisu ule didil ge bwaya.” ");
INSERT INTO kbm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yisu giute yaun etok be ginei gitangi Jairus, “Aplom bunam bwaya, be tam nivin ge kob atob natum avie matawe be nimdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Yisu givang love gile gibloblo Jairus ane nam be giute ebe amolmol ilgum tangir ivang ok, beti ginei gitangi eisir be ginei, “Unteng bwaya, ve avie natu etenok gimat vunu ite etenok ei giengk matano ete giengk nok.” Amolmol imalk ve Yisu ane yaun ete ginei ok ve eisir ili inei avie natu ande gimat vunu gikwai. Bekob ete Yisu gitin amolmol tepwengge ile ihlang ikwai nam aplo be gigas Pita gabu Jon be Jakobos ge be tis avie natu nok tine gabu tame be isov nam aplo ile. ");
INSERT INTO kbm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yisu gile geb avie natu nok gibweg bage be ginei, “Avie natu, Ayeu nanei be mie numdil vukuri!” ");
INSERT INTO kbm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","be seukie-ngge avie natu nok matawe be gimdil vukuri. Be Yisu ginei ve avie nok tine gabu tame ve inemb ben nile natus avie nen. ");
INSERT INTO kbm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jairus gabu arwe ili gen bamo ete Yisu gilgum gitangi natus avie ok love avos poke-ngge. Be Yisu ges bing ve sulu ve ginei inei gen etok binge nitangi amolmol bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisu gital ane singamolomb gen 12 ebok be itangi ei ile be geb ane gwangne gitangi eisir ve inaitin ngalau tiate nikwai amolmol be tis ebe ve inalgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri ok nivin. ");
INSERT INTO kbm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bekob gihlin is be ivang itangi nam dabe ge ile ve inei mateu nitangi amolmol be inalgum amolmol ebe tis gimat ok utlas vie vukuri, be inei luev ebe Pomate geb amolmol dabin ok lavo-lavo nitangi amolmol nivin. ");
INSERT INTO kbm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bekob ginei gitangi ane singamolomb-gen 12 nok be ginei: “Yem unvwat gen ti nisa aim-ate bwaya. Unvwat aim kabut luev ane me aim vak me ben me mone be tis kup ti nivin aim-ate ite. ");
INSERT INTO kbm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Be ginei yem umbielk nam dabe ti be amol nam etok ane ti gigas yem upil ane nam ule, okob unambweg nam dongke etok ge be unde unpil nam ti be ti ite love nitangi ebe yem veve unkwai nam dabe etok ok ge. ");
INSERT INTO kbm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Be ginei nam dabe ti bwais ve in-gas yem unpil as nam be bwais ve inaute yem avongg aim, okob yem unro nangg-aim vukir, be guni nitangi eisir be kuku ninumul be unde unahlang unkwai eisir as nam luvwe. Be gen ete yem ulgum ok atob nes eisir as gen tiate ru nitangi eisir ate vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yisu ginei yaun eteok gitangi ane singamolomb gen be ma gikwai kob eisir singamolomb imdil be ivang itangi nam dabe ge ile, be inei mateu be ilgum amolmol ebe tis gimat ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes ei amol bamo ebe geb amolmol dabin nangge Galilaia as taku ok, be ei giute gen bambamo ebe Yisu gilgum ok ane binge love ta gitung gile ma molge ve amolmol subu inei Yisu ei Jon ebe ges bui sanggu gipil amolmol ok be ande matawe be gimdil vukuri nangge taku gimat ane. ");
INSERT INTO kbm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Be eisir subu inei ei Elia be ande meng-gihlang vukuri, be subu inei etok Pomate ane amol kulkul ane ti ebe nolge gimat vunu gikwai ok beti ande matawe be gimdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Beti Herodes giute yaun bambamo ete amolmol inei ok be ginei: “Ayeu ganei be angg amolmol valir ane idbwen Jon savwalo gili gikwai bemem wali amol ret dangete gilgum gen bambamo dang dangeteok?” Beti Herodes lolo be gilgum ve nili Yisu roro-ngge nisov matano kob. ");
INSERT INTO kbm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eisir singamolomb inumul ile be iput gen bambamo ebe ilgum be inei gitangi amolmol ok lavo-lavo gitangi Yisu. Bekob gigas is be ile imbweg as atane-ngge nangge nam dabe ti are Betsaida. Bemem amolmol iute ebe atob ei tis ane singamolomb-gen inde inambweg taku etok ok binge be itau ile ei tis ane singamolomb-gen. ");
INSERT INTO kbm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yisu gili ebe amolmol anongge itau ile ei ve ile ok beti ta vevie-ngge ve eisir ane be ginei mateu gipil luev ebe Pomate geb amolmol dabin ok gitangi eisir, be gilgum amolmol ebe tis gimat walang ano ok be utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Be givin ebe as gile gisov ok okob eisir singamolomb itangi Yisu ile be inei, “Etenik taku sawa ete eitit tambweg nik, dangetok be mie uli be uhlin amolmol bambamo etenik inde ve invang nam ane inkwai veik inavgo as ben be indi taku ebe ve atob inyengk ok nivin.” ");
INSERT INTO kbm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bemem Yisu ginei gitangi ane singamolomb-gen be ginei, “Eisir atob invang inde ti be ti ite, be yem ate ge kob undi ben ebe ve eisir inen ok.” Beti eisir singamolomb iwel Yisu avo be inei; “Bemem amei ok gitangi ebe atob anavgo ben be eisir bambamo etenik tepwengge inen love nile nitangi ge ok ite. Be amei ate amei wenk ailu be tis ben siti-ngge ete giengk nik bemem etok ok gitangi ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Amolmol dubi bamo nok gitangi 5,000, bemem ivnawi avie gaptol tis nunus givin ite.) Yisu ginei gitangi ane singamolomb gen ve inden amolmol nitangi 50 inambweg dubi dongke dongke nitangi ge ve nile. ");
INSERT INTO kbm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Beti eisir singamolomb ilgum gitangi ete Yisu ginei ok be inei gitangi amolmol ve inambweg golonge. ");
INSERT INTO kbm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yisu geb ben siti tis wenk ailu etok be gidank gireu gulumb be ges miengk gitangi Pomate gikwai bekob gible wenk tis ben nok vusvusa be geb gitangi ane singamolomb-gen ve inbwas nitangi amolmol be inen. ");
INSERT INTO kbm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amolmol dubi bamo etok en ben siti be tis wenk ailu-ngge etok, love gibon is vie-ngge bekob eisir singamolomb isbang ben dadanis ebe giengk ok gisov sab 12. ");
INSERT INTO kbm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Givin sawa ti Yisu gile ve givang taku sawa ti ve ges miengk, bekob ane singamolomb-gen imdil be itangi ei ile. Bekob Yisu giutani ane singamolomb-gen be ginei: “Amolmol ital Ayeu inei Ayeu amol ret?” ");
INSERT INTO kbm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eisir singamolomb iwel Yisu avo be inei, “Amolmol subu ital mie inei Jon ebe ges bui sanggu gipil amolmol ok, be subu ital inei Elia be ande ginumul ginme nangge gulumb vukuri. Be eisir subu inei Pomate ane amol kulkul ane ti ebe warik gimat vunu ok beti ande matawe be gimdil vukuri nangge taku gimat ane.” ");
INSERT INTO kbm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Be Yisu ginei gitangi ane singamolomb-gen be ginei; “Be yem ate utal ayeu unei ret?” Pita giwel Yisu avo be ginei, “Mie Pomate ane Amol (Mesia) ebe ve nemb amolmol ru ok.” ");
INSERT INTO kbm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yisu ges bing ve ane singamolomb-gen be ginei inei yaun ete galkik Pita ginei ok binge nitangi amolmol ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bekob ginei; “Asonge bambamo mateu ane be tis eisir ebe emb kulkul da ane nangge lum yamar ok tis gidung yaun ane atob bwais ve Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, be atob inalgum awangg yaun be ines Ayeu vunu. Bemem as mate ebe ve aitol ane ok, okob atob ayeu namdil nangge taku gimat ane vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Be Yisu ginei gitangi amolmol tepwengge be ginei; “Amol ti ginei ta givin anongge ve nivang nivin Ayeu, okob ei nes ate bago be nipasang ate ve ninggas gen bunam be tis vavavne ete atob Ayeu nanggas ok nivin tis as mate walang ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ve ginei amol ti gimat vunu ve awangg kulkul ane, okob amol etok atob nimbweg matawe nemb ta ge nindeb mul ane. Bemem ginei amol ti ta gitung utle ulis bamo molge, atob ei nimat vunu nindeb mul ane nivin ebe Pomate ve ninumul ninme nalk ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dangetok be amol ti ginei gigas gen nalk ane walang molge be ta givin ane gen etok gitlek molge, be ginei ei nimat vunu be Pomate nitin ei dalgo matawe ane nikwai, okob ei ane gen vevies bambamo nok atob gitangi ebe ve nemb ei ru ok nam nambed? Atob ma yapin! ");
INSERT INTO kbm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Be amol ti ginei maimae ve Ayeu tis angg yaun (mateu), okob Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok atob mai mayangg ve ei weik etok ge nivin ebe ayeu ve nanumul nanme tis Tamangg ane gwangne be tis ane angela vevies as gwangne ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ayeu nanei nitangi yem, Amolmol subu ete imbweg matawas imbweg nik, atob eisir inmat vunu ite love indi Pomate ebe ginumul ginme nalk ok okob.” ");
INSERT INTO kbm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisu ginei yaun etok gikwai be ivang love as mate 8 gile gikwai kob gigas Pita gabu Jon be Jakobos be gaptol ireu matendubi ti ile ve Yisu nes miengk. ");
INSERT INTO kbm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Givin ebe Yisu ges miengk givang ok, be utle ulis ande giro ate vukir love ane kup be na ok bogbogo be ringenk tiate. ");
INSERT INTO kbm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Be seukie-ngge amol ailu meihlang be kakie ivin ei, sulu ailu nok ete Mose gabu Elia. ");
INSERT INTO kbm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sulu meihlang tis utlas ulis gulumb ane ge be gaptol ivarkei be kakie gipil yaun ebe warik Pomate gibiti ok ve yaun nok atob ano nile nivin sawa ete Yisu ve ninggas vavavne be nimat vunu nangge Jerusalem ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita gabu Jon be Jakobos matanos bunam molge be veve inyengk, bemem gaptol iro is ate ta be nas giengk Yisu ebe givarkei givin sulu ailu ebok tis ane bogbogo ge ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mose gabu Elia veve invang, beti Pita ginei gitangi Yisu be ginei; “Gidung! Eitit tambweg taku etenik be vie molge, dangetok be atob amei anpasang bes natu aitol ti ve mie be ti ve Mose, be ti ve Elia.” (Pita ta gitung yaun ti roro-ngge giengk aplo ebe ve ninei ok ite ma, be ei ginei yaun etok sin-gege be ta gisgil ate). ");
INSERT INTO kbm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ginei yaun etok nangge be umbim ti ginme be gitav tulu ve sotol tis Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Be Pomate ginei yaun ti nangge umbim nok aplo dang eteik; “Ayeu Natungg dongke-ngge ete gahlin be gilek nok, be amolmol unaute Ei avo ge ma!” ");
INSERT INTO kbm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yaun avo etok gile ma gikwai kob sotol singamolomb aitol ebok emb nas itin bemem ili amol ti givin sotol ite be Yisu ei ate ge. Be sotol avos poke-ngge ve gen bambamo etok ane be tumi-ngge ivarkei. Be givin sawa etok sotol inei yaun ti gipil gen ebe ili ok gitangi amolmol ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Imdil tistumi ti vukuri kob Yisu tis ane singamolomb-gen aitol nok isov nangge matendubi ile love ile vunge ve amolmol dubi bamo ti nangge luev. ");
INSERT INTO kbm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Be amol ti nangge eisir dubi bamo nok gili Yisu ebe ginme ok beti gital yaun avo bamo-ngge be ginei, “Gidung, Ayeu natungg dongke-ngge gibweg be ngalau tiate ti givang givin ei be gilgum ei tiate tiate molge, ei gikari ate gile gitak nalk be yayai be avo vurvurk gisov avo givin-givin. Be ngalau tiate nok gikwai amol natu ite molge, be gilgum be amol natu gitangi ebe ve nimbweg vie siti ok ite molge. Beti ayeu gautani mie ve nuitin ngalau tiate etok nikwai amol natu okob. ");
INSERT INTO kbm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ve ayeu ganei gitangi miam singamolomb-gen ve inaitin ngalau tiate nok nikwai amol natu bemem eisir ilgum be gitangi ite.” ");
INSERT INTO kbm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yisu giwel amol nok avo be ginei, “Yem amolmol taku etenik ane aplongg aim dadani molge. Ayeu gavang gavin yem tis ebe warik be asger kob yem unro aim ate vukir be aplongg aim nivin ayeu siti.” Bekob ginei gitangi amol nok, “Unggas natum nok unme kob.” ");
INSERT INTO kbm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Givin ebe amol natu nok gabu tame ivang ve ile ok be ngalau tiate etok gilgum amol natu nok tiate molge love gikari ate gile gitak nalk be gimual-mual giengk ebe nalk ok. Yisu ges bing ve ngalau tiate etok be gile gihlang gikwai amol natu nok be seukie-ngge amol nok ande gibweg vie bekob Yisu geb ei ginumul gitangi tame gile vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Amolmol tepwengge ili gen bamo etok be ikuri vunu-ngge be avos poke-ngge ve Pomate ane gwangne ebe geb gitangi Natu Yisu ok ane. Amolmol tepwengge inei gen bambamo ebe Yisu gilgum gilgum ok ane avo ivang, be Yisu ginei gitangi ane singamolomb-gen be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Undi velob tangg aim nivalngan yaun ete ayeu veve nanei nitangi yem nik! Be Yisu ginei, Atob amolmol inemb Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ta be inalgum awangg yaun ve ines ayeu vunu. ");
INSERT INTO kbm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bemem eisir singamolomb itpweng yaun ete ei ginei ok ane dabe are ite ve yaun etok ane dabe givuaivun ate. Beti eisir ipelk ve inautani Yisu vukuri ve yaun nok ane dabe ane. ");
INSERT INTO kbm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Givin sawa etok ge eisir singamolomb iutau-tani is ate ve eisir as amol ret atob menihlang weik eisir tepwengge as amol mate ane. ");
INSERT INTO kbm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bemem Yisu ande gitpweng eisir as yaun ete tas gitung be inei ve is ate ok are gikwai. Beti gile geb nunus natu ti ginme givarkei gibloblo ei ate, ");
INSERT INTO kbm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","be ginei ve ane singamolomb-gen be ginei; “Amol ti ginei ta gitung Ayeu be geb nunus natu ti weik eteik dabin, okob amol etok ei gilgum gen vie molge gitangi Ayeu givin weik etok ge. Be amol ti ginei gilgum gen vie gitangi Ayeu, okob ei gilgum gen vie gitangi Amol ebe gihlin Ayeu be ganme ok givin weik etok ge. Bemem amol ti ebe gilgum gen vevies ge gitangi amolmol bemem ei bua ve amolmol avos nivwat ei are ok, amol etok ei amol vie molge gitlek amolmol subu. ");
INSERT INTO kbm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Be Jon ginei gitangi Yisu be ginei; “Amol Bamo, Amei ali amol ebeok ti gitin ngalau tiate ve mie arem (miam gwangne), beti amei anei gitangi ei ve nitau etok ve etok ei ane kulkul ite.” ");
INSERT INTO kbm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yisu giwel Jon avo be ginei ve ane singamolomb-gen tepwengge be ginei, “Yem unvarkei ei gili bwaya, ve amol ti ginei ges valir gitangi yem ite okob amol etok ei yem aim nune ti.” ");
INSERT INTO kbm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yisu ta gitung ve nireu nile Jerusalem ve as mate ebe ei ve nimat vunu ok ande gibloblo gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Beti gihlin Jakobos gabu Jon ve inmungg inde inahlang ebe nam ok be inpasang nam ti ve ei ane yapin. ");
INSERT INTO kbm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bemem amolmol nam dabe etok ane bwais ve in-gas Yisu inpil as nam. Ve eisir ili inei Yisu ande wat bua ve eisir as lum mateu ane beti veve nireu nile ebe Jerusalem ok. ");
INSERT INTO kbm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jon gabu Jakobos iute yaun etok beti gabu inumul ile be inei gitangi Yisu be inei, “Amol Bamo, Mie tam givin ve amei anautani Pomate be nemb yev nangge gulumb nisov ninme be nen eisir nam dabe etenik nikwai me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bemem Yisu girau lili be gigo ane singamolomb-gen, ");
INSERT INTO kbm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","bekob itlek nam dabe etok be ile imbielk ve nam dabe ti vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yisu tis ane singamolomb-gen ivang ve ile be amol ti ginei gitangi Yisu dang eteik; “Taku walang ete mie veve nule ok, atob ayeu nasasa mie painge-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yisu gilgum ve nes gen ret-ret ebe atob nipil amol etok ok ru nitangi ei ate beti giwel amol nok avo be ginei; “Uruv tis as nalk avo, be mank walang ete iluep ivang nik tis as niu -ngge, bemem Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok, angg taku sawa ti giengk ebe ve nayap nambweg ok ite molge, ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Be Yisu ginei gitangi amol ti be ginei, “Uvang mul ve ayeu.” Be amol nok giwel Yisu avo be ginei, “Amol Bamo, ande ayeu gaute, bemem ayeu nanumul nale be nambweg love naspun tamangg nikwai kob.” ");
INSERT INTO kbm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Be Yisu ginei gitangi ei be ginei, “Amolmol ebe aplos gimat vunu gikwai ok inaspun eisir ete imat vunkunu ok. Be mie nule be nunei mateu nitangi amolmol nipil luev ebe Pomate geb amolmol dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Be amol ti ginei gitangi Yisu be ginei; “Amol Bamo, Ayeu tang gitung ve navang mul ve mie bemem ayeu nale be nasavi angg bambamo gen bais okob.” ");
INSERT INTO kbm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Be Yisu ginei gitangi ei, “Amol ti ginei geb ulieng ei-vovo ti ane be na gilek be ginme ve gitlo gen subu-subu givin, atob ei-vovo nok nivang vie ite. Dangetok be amolmol dang dangetok gitangi ebe atob inalgum Pomate ane kulkul ok ite molge.” ");
INSERT INTO kbm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bekob Yisu geb amolmol gitangi 70 be ivang ailu ailu ve inmungg inde nam dabe walang ok ebe ei ate ande ta gitung yapin ve atob vemul nile ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Be ei geb bing-ai ti gipil amolmol ebe tas givin anongge ve inaute mateu ok be ginei, “Aiweng ebe ve inro ben ano sut ok etenik bemem amolmol kulkul ane ebe ve inro ben ano sut ok gitangi ite nangge. Dangetok be yem unes miengk be unautani um tivie veik ei nihlin amolmol kulkul ane subu inme invin yem be unro ane ben ano sut nisov ane nam ben ano ane nile.” ");
INSERT INTO kbm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Be Yisu ginei; “Unaute kob, Ayeu gahlin yem weik bwelk sipsip ebe ivang isov uvun valir ane aplo ok.” ");
INSERT INTO kbm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bekob ginei; “Unvwat aim mone tis paos me aim vak me gen ti nisa aim ate ite, be uno aim vangg aim taptape (su) nivin ite. Be unvarkei be kakie unvin amolmol ete ule vunge ve is nangge luev sawa ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Be ginei amol ti gigas yem upil ane nam ule, okob unei nitangi nam nok ane tivie dang eteik, ‘Pomate givang givin mie tis am amolmol-gen nam etenik ane.’ ");
INSERT INTO kbm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Be ginei amol yaun bwaibwaya ane ti gibweg nam etok okob yem unemb yaun bwaibwaya nitangi ei, be ginei ma okob unei yaun ti bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ginei yem upil nam ti ule, okob unambweg nam dongke etok ge be unde unpil ti be ti ite. Be ben tis bui ete eisir nam etok ane ve inemb nitangi yem ok, yem unen be unum bui ete eisir emb gitangi yem ok. Ve amolmol kulkul ane gitangi ebe atob inen be inum gen nangge amolmol ebe eisir ilgum kulkul ve is ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Be ginei yem umbielk nam dabe ti be amolmol nam dabe etok ane inggas yem upil as nam ule, okob unen ben ete eisir emb gitangi yem ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Be unalgum amolmol taku etok ane ebe tis gimat ok be utlas vie vukuri be unei nitangi eisir unei, ‘Gibloblo ve Pomate nemb em dabin.’ ");
INSERT INTO kbm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Be ginei umbielk nam dabe ti be amolmol nam etok ane inggas yem upil as nam ule ite, okob unde unahlang unkwai eisir as nam luvwe be unei, “Yem aim seksek aim nam luvwe ane ete gisa amei vangg amei taptape ik atob amei antiti nile nitak be aim gen niengk yapin.” ");
INSERT INTO kbm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Veik gen ete yem ulgum ok atob nes eisir nam etok ane as gen tiate ebe ilgum ilgum ok ru nitangi eisir ate.” Be Yisu ginei; “Unaute kob! Gibloblo ve Pomate nemb yem dabin. ");
INSERT INTO kbm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Dangetok be ayeu nanei nitangi yem, Asonge nindeb mul ane atob amolmol taku etok ane atob in-gas vavavne bamo molge nitlek ebe amolmol Sodom ane ve in-gas ok.” ");
INSERT INTO kbm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Yem amolmol nangge Korasin be tis Betsaida, asonge yem un-gas gen bunam bamo molge nindeb mul ane. Ve gen bwalbwale ete ayeu galgum nangge yem aim taku nik, ginei ayeu nalgum nangge amolmol tiate ane as nam, nangge Taia tis Saidon atob eisir inro isate vukir inkwai as gen tiate aplo seukie-ngge be aplos nivin ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dangetok beti asonge nindeb mul ane atob Pomate nemb vavavne nitangi amolmol Taia be tis Saidon ane, bemem atob yem un-gas vavavne bamo molge nitlek ete eisir ve inggas ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Be yem amolmol Kapenaum ane ok weik etok ge, yem ulgum ve avongg aim givwat aim ate gitlek molge bemem asonge nindeb mul ane atob Pomate nitin yem unde unsov yev bamo ebe giengk dangetok ok unde.” ");
INSERT INTO kbm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Be Yisu ginei gitangi ane singamolomb-gen be ginei, “Amol ti ginei giute yem aim yaun ge, amol etok ei giute awangg yaun ge weik etok ge. Be amol ti ginei bua ve yem be givkir dume gitangi yem, amol etok ei bua ve ayeu be givkir dume gitangi ayeu givin weik etok ge. Be amol ete givkir dume gitangi ayeu ok, ei givkir dume gitangi amol ebe gihlin ayeu be ganme ok givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bwayage kob amolmol 70 ebe warik Yisu gihlin is be ivang kulkul mateu ane ok imbielk ve Yisu vukuri tis tas vevias ge be inei, “Amol Bamo, Amei algum gen walang ok love aitin ngalau tiate gikwai amolmol givin weik etok ge ve miam gwangne be ngalau tiate isov ameimei yaun ane lu ge be ile ihlang ikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Be Yisu ginei gitangi eisir, “Givin ebe yem ulgum gen etok ok, be ayeu gali gen ti be gali weik ebe Sadam gibieg nangge gulumb weik ebe bilip geb ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Be unaute, Ande ayeu gab angg gwangne gitangi yem gilek gikwai be yem gitangi ebe ve unambweg unwei amol tiate Sadam ane gwangne ok, be ei ane gen ti gitangi ebe ve nilgum yem tiate ok ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bemem yem undang aim ate be tangg aim vevie-ngge ve ebe ande ngalau tiate isov yem aim yaun ane lu ge be ile ihlang ikwai amolmol ok bwaya, bemem tangg-aim vevie-ngge ve Pomate ande giro yem arengg aim bwalbwale giengk ane taku vie ebe gulumb ok gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Givin sawa etok Ngalau Yamar geb Yisu avwut love ta vevie anongge be ginei, “Tamangg, Mie Amol Bamo ebe gob gulumb tis nalk dabin ok. Ayeu nanei angg tangg-vie nitangi mie ve mie gos gen ebe guvwaivun ve amolmol ebe isov lum be ili is ate inei eisir amolmol dabas gwet bambamo ane ok ru gitangi eisir ebe ili is ate weik nunus mwelu be itpweng gen ti are ite ok. Tamangg, bingano, Mie guli gen etok vie beti gulgum gitangi ebe am tam gitung ok.” ");
INSERT INTO kbm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Be Yisu ginei, “Tamangg geb gen walang ok gitangi Ayeu gikwai ve namb dabin. Be amol ti gitpweng Pomate Natu ayeu are ite, Tamangg ei dongke-ngge. Be amol ti gitpweng Tamangg are ite, Natu ayeu dongke-ngge be tis amolmol ebe ayeu ve nas Tamangg ru nitangi eisir ok, ete itpweng Tamangg are givin.” ");
INSERT INTO kbm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bekob Yisu giro na vukir gitangi ane singamolomb-gen be ginei bwaya gege gitangi eisir be ginei, “Yem tangg-aim vevie-ngge ve gen ebe warik Pomate ginei ok ete ande yem uli nik.” ");
INSERT INTO kbm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Be ayeu nanei nitangi yem, “Warik Pomate ane amolmol subu ebe inei Pomate avo ok (Propet) be tis eisir bambamo ebe emb amolmol dabin ok, eisir ilgum ve indi gen bwalbwale ete Ayeu galgum be yem uli nik, bemem eisir ili ite. Be eisir lolos ve inaute yaun ete ande yem ute nik, bemem iute ite.” ");
INSERT INTO kbm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bekob Gidung ti ebe geb Mose ane yaun dabin ok ei girek luev ebe ve nemb Yisu ta ok, beti gitangi Yisu gile be ginei, “Gidung, Ayeu nalgum gen ret veik nambweg matawangg nemb ta-ngge?” ");
INSERT INTO kbm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yisu giwel amol nok avo be ginei, “Pomate ane yaun ebe geb gitangi Mose ok ginei yaun ret? Be mie gusam yaun etok okob ginei ret gitangi mie?” ");
INSERT INTO kbm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Be amol nok ginei, “Yaun etok ginei dang eteik; ‘Tam nivin am Pomate ei dongke-ngge tis am gwangne be dalgom be aplom be tis dabem gwet tepwengge nitangi ei-ngge. Be tam nivin am nune-nggen nitlek ete mie ate tam givin im ate ok.’” ");
INSERT INTO kbm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Be Yisu ginei gitangi ei, “Mie gunei yaun ano. Dangetok be nule be nulgum weik ete ande gunei ok veik numbweg matawem ninggas ta-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bemem amol nok gilgum ve nindang ate nivin beti giutani Yisu vukuri be ginei, “Awangg nune-nggen asav?” ");
INSERT INTO kbm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yisu giwel ei avo be ginei bing-ai ti dangeteik; “Juda amol ti gimdil nangge Jerusalem be gisov ve nile Jeriko, ei gile love gile vunge ve amolmol tiate ane ebe es amolmol vunkunu be ivai vaina amolmol as gen giriv be gira ok nangge luev sawa. Eisir etok emb amol nok ta be ivwat ane mone be tis ane gen walang ok love ma bekob es ei love tiate-ngge be bais vier gile gitak luev bane be gimat viti giengk etok. ");
INSERT INTO kbm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Be givin sawa etok ge amol bamo ti ebe givang-givang lum yamar aplo ve geb da gitangi Pomate ok, ei givang luev nok ge ve gile love gile vunge ve amol ebe gimat viti giengk luev bane ok. Be ei ande gili amol etok ebe gimat viti giengk ok gikwai, bemem geb giyai gile gipil luev tavlu be gile ve givang. ");
INSERT INTO kbm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Be as mate dongke nok ge eisir Juda as amolmol ebe emb kulkul takes ane ok as amol ti givang luev dongke nok ge ve gile. Amol nok givang gile love gili amol ebe amolmol vaina ane es be giengk luev ok, bemem ei geb giyai be gile ve givang weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Be bwayage kob amol Samaria ane ti, be eisir Samaria nok ebe amolmol Juda ane ili eisir inei amolmol tiate ane ok. Amol nok givang luev galkok ve gile love gili amol ebe ande es be gimat viti giengk luev ok, be ei gili love ta viti ve amol nok anongge. ");
INSERT INTO kbm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Beti givang gitangi amol nok gile be gitak marasing gipil amol nok ane bid bekob geb itin gile giwei ei ate ane bwelk dongki be gigas ei gile nam taulop ane be geb ei dabin nangge etok. ");
INSERT INTO kbm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Be givin tistumi Samaria amol nok gimdil ve nivang beti gile geb mone ebe gitangi as mate ailu-ngge ane ok gitangi nam tivie be ginei, ‘Mie nomb amol gimat etenik dabin vie-ngge love ayeu nanumul nanme kob atob namb gen subu niwel miam gen ret-ret ete gob gitangi amol gimat etenik ok.’” ");
INSERT INTO kbm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Be Yisu ginei gitangi gidung yaun ane ebe galkik giutani ei ok be ginei, ‘Mie tam gitung gunei sotol aitol etok as amol ret gilgum gen vie gitangi amol ebe amolmol vaina ane es be giengk luev ok?” ");
INSERT INTO kbm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Be gidung yaun ane nok giwel Yisu avo be ginei, “Amol ebe ta viti ve ei be givko ei ane bid ok.” Be Yisu ginei, “Dangetok be mie nule be nulgum weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bekob Yisu tis ane singamolomb-gen ivang ve ile love imbielk nam dabe ti, be avie ti are Mata gigas is gipil ane nam gile. ");
INSERT INTO kbm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata nok malavie ti are Malia be sulu imbweg etok. Be givin etok Malia ande gile gibweg gibloblo Yisu be giute Yisu ane yaun ebe ginei-ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Be Mata ge geb kulkul ve gidu ben ve Yisu tis ane singamolomb-gen. Mata ande ta vavis vunungge beti gitangi Yisu gile be ginei, “Amol Bamo, Mie guli gen etok gitangi ve awangg malavie etenok nimbweg sinsin-ge be ayeu ge namb kulkul ve nandu eitit and ben me ma? Mie unei itangi ei veik ninme be nemb ayeu ru!” ");
INSERT INTO kbm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Be Amol Bamo giwel Mata avo be ginei, “Mata, Mie tamgitung gen walang molge beti gilgum be aplom bunam anongge, ");
INSERT INTO kbm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","bemem gen dongke eteik ete mie gugas ite nangge. Bemem ande Malia gigas gen etok gikwai be gitangi ebe atob tanemb nikwai ei ok ite, ma molge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","As mate ti Yisu ges miengk givang taku sawa ti. Ei ges miengk givang love ma gikwai kob ane singamolomb ti gitangi ei gile be ginei; “Amol Bamol, Mie umbul am singamolomb-gen amei veik anes miengk dangete Jon gibul ane singamolomb-gen ok ma?” ");
INSERT INTO kbm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Beti Yisu ginei gitangi ane singamolomb gen be ginei, “Yem unes miengk dangeteik; Tamangg amei ebe gubweg gulumb ok Mie arem niengk vie-ngge. Amei tangg amei givin anei sawa ebe mie ve nomb amei dabin ve am gwangne ok menihlang. ");
INSERT INTO kbm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nomb ameimei ben as mate walang ok ane nitangi-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mie tam nivalngan ameimei gen tiate ebe algum ok, dangete amei tangg amei givalngan amolmol as gen tiate ebe ilgum gitangi amei ok. Be nunggas amei antangi gen ebe ve nilgum amei be anambieg ansov gen tiate aplo ok ande bwaya.” ");
INSERT INTO kbm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Be Yisu ginei gitangi ane singamolomb-gen be ginei, “Ginei yem aim amol ti nitangi ane nune ti ane nam nile tis tambok luvwe be ninei nitangi ane nune etok be ninei, ‘Omb ben siti ve ayeu bekob, ");
INSERT INTO kbm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ve awangg nune ti ginme nangge taku undib ti be vasov nik ge gibielk ve ayeu tis tambok luvwe, be ayeu ben ti giengk ebe atob namb nitangi ei be nen ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Be ginei miam nune etok niwel mie avom be ninei, ‘Ande amei ayengk be as amei nam avo gile gikwai be ayeu gitangi ebe atob namdil be namb gen ti nitangi mie ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ginei miam nune etok ninei yaun dangetok nitangi mie okob atob nam nambed?” Be Yisu ginei, “Ayeu nanei nitangi yem okob, Ginei amol etok nimdil ite ve gisov etok miam nune ete ei ok, bemem atob ei nimdil be nemb gen walang ok nitangi mie ve gisov mie avom kolkolonge ge be gutani ei ve gen ane.” ");
INSERT INTO kbm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Be Yisu ginei; “Dangetok be ayeu nanei nitangi yem, Ginei yem unautani Pomate ve gen ti ane, atob ei nemb nitangi yem. Be ginei yem unrek gen, atob undi, be ginei utal Pomate, atob Pomate niute be nemb yem avongg aim ru. ");
INSERT INTO kbm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ve amolmol walang ok ginei inautani gen, atob invwat, be amol ti ginei girek gen atob ei nili. Be ginei amol ti nital Pomate, atob Pomate niute ei avo be nemb ei avo ru.” ");
INSERT INTO kbm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Be Yisu ginei; “Nunus natu-natu ete ivang nik ginei inautani tinas gen ve wenk tis mank gaglus ane, atob tinas-gen inemb muat me vat nitangi eisir ite, ma yapin! Atob eisir inemb gen ete natus gen iutani ok roro-ngge nitangi natus gen.” ");
INSERT INTO kbm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","“Yem amolmol tiate ane! Yem utpweng luev etok are gikwai be omb gen vevies ge gitangi natungg aimgen. Dangetok be Tamangg aim ebe gibweg gulumb ok gitangi ebe atob nemb gen vevies ge weik etok be tis Ngalau Yamar nitangi amolmol ebe iutani ei ve gen ane ok ite me?” ");
INSERT INTO kbm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngalau tiate givang givin amol ti be gilgum amol nok love gitangi ebe ve ninei yaun vusa ok ite beti Yisu gitin ngalau tiate nok gile gihlang gikwai amol etok be seukie-ngge amol nok ginei yaun vusa vukuri. Be amolmol tepwengge ili love avos poke-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bemem amolmol subu inei; “Etok ngalau tiate as amol bamo ebe geb is dabin ok (are Belsebul) geb ane gwangne gitangi Yisu beti gitin ngalau tiate gikwai amolmol.” ");
INSERT INTO kbm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Beti eisir ilgum ve inemb Yisu ta be iutani ei ve nilgum gen bwalbwale ti be eisir indi veik inatpweng are inei Pomate ane gwangne givang givin ei bingano. ");
INSERT INTO kbm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bemem Yisu ande gitpweng yaun ete eisir tas gitung ok are gikwai beti ginei gitangi eisir be ginei; “Nam dabe ti ginei inemb is ate vusa nile dubi ailu be ines is ate, okob amolmol nam dabe etok ane atob inambweg vie me ma? Be eisir vu ti ginei inemb is ate vusa be ines is ate atob eisir vu etok invang vie me ma? ");
INSERT INTO kbm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dangetok be ginei Sadam tis ane amolmol gen inemb is ate vusa nile ailu, okob atob eisir indi is ate weik eisir vu dongke ite ma yapin! Be yem unei ngalau tiate as amol bamo ebe geb is dabin ok geb ane gwangne gitangi ayeu beti gaitin ngalau tiate gikwai amolmol, bemem Sadam gitangi ebe ve nes valir nitangi ei ate ane amolmol gen ok ite. Be ande yem unei ayeu galgum kulkul etok ve Sadam ane gwangne, ");
INSERT INTO kbm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","be ginei dangetok, okob amol ret geb ane gwangne gitangi yem aim amolmol gen beti eisir itin ngalau tiate gikwai amolmol? Kob yem ate-ngge aim amolmolgen inei yaun etenik lavo itangi yem. Ve yaun ete galkik yem unei gipil ayeu ok, yaun etok gitlek molge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Be Yisu ginei, “Ayeu nanei nitangi yem; Pomate geb ane gwangne gitangi Ayeu ve naitin ngalau tiate nikwai amolmol veik yem unatpweng are, unei Pomate geb Ayeu ve yem aim Amol Bamo be ei geb ane gwangne gitangi ayeu ve namb yem dabin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Amol ti ginei bage nisov ane gen (wambal) valir ane be nivo ane nam nimbweg, okob amol ebeok ti gitangi ebe atob nisov ei ane nam aplo nile be nivwat ei ane wambal tis ane gen walang ok nikwai ok ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bemem ginei amol ti ebe tulkwe gavgavul tiate gitlek ei ok nile be nes valir nivin ei love nemb ei ane ralau tis i etok beleinge nikwai ei, okob amol tulkwe gavgavul nok atob nisov amol etok ane nam aplo nile be nivwat ei ane gen walang ok tepwengge nikwai be nimbwas nitangi amolmol ebeok sinsin-ge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Be Yisu ginei, “Amolmol ebe bwais ve Ayeu be ivkir dumas gitangi ayeu ok, eisir etok ebe es valir gitangi ayeu tis angg amolmol gen ok. Be amolmol ebe bwais ve inemb ayeu ru be inro awangg amolmol sut ok, eisir dang dangetok ebe ivin-vin awangg amolmol gen giriv be gira ok.” ");
INSERT INTO kbm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Be Yisu ginei, “Ngalau tiate ti ginei gile gihlang gikwai amol ti, okob ngalau tiate nok atob nile ve niriv be nira nivang taku sawa ve nirek taku ebe ve nimbweg ok. Be ginei ei nili sawa ebe ve nile nimbweg ok ti giengk ite, okob atob ei ninei nitangi ate dang eteik; “Ayeu nanumul nale angg nam ebe warik meng gahlang nangge ok vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Be ginei ei ninumul nile love nili ane nam ebe warik meng gihlang nangge ok ande ipasang aplo be inggolong love vie-ngge giengk, ");
INSERT INTO kbm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","okob atob ninumul nile be ninggas ngalau tiate 7 vukuri ebe as gwangne gitlek ei ane ok be tepwe inde inambweg nam dongke etok. Okob amol nok atob nimbweg vie ite molge nitlek ebe warik mate ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Givin sawa etok amolmol dubi bamo ti imbweg ve iute Yisu ane yaun ebe ginei ginei ok. Be avie ti gimdil nangge eisir dubi bamo nok aplo be ginei gitangi Yisu, “Avie ebe gikuv mie be geb rur ve mie ok, avie etok asonge wat ta vevie anongge nitlek.” ");
INSERT INTO kbm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bemem Yisu giwel avie nok avo be ginei; “Bingano, bemem amolmol ebe iute Pomate ane yaun (mateu) be ilgum ano gile ok, eisir etok atob tas vevias anongge nitlek avie ebe gikuv be geb rur ve ayeu ok!” ");
INSERT INTO kbm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amolmol anongge iro is ate sut itangi Yisu ile painge-ngge, be Yisu geb avo ponge be ginei, “Amolmol as mate etenik ane eisir amolmol tiate ane roro-ngge. Eisir iutani Ayeu painge-ngge ve nalgum gen bwalbwale ti be eisir indi veik inatpweng are inei Ayeu amol ebe ve namb amolmol dabin ok (Mesia) me ma? Be Pomate ane gwangne givang givin Ayeu bingano-ngge me ma?” Bemem Yisu ginei; “Ayeu atob nalgum gen bwalbwale ti be eisir indi ite molge. Be gen bwalbwale ti ebe warik Pomate gilgum gipil ane amol kulkul ane ti are Jona ok ge ete atob eisir indi gen bwalbwale ti weik etok vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ve amolmol nangge Niniwe itpweng Pomate ane gwangne are gipil gen bwalbwale ete gilgum gipil ane amol kulkul ane Jona ok. Dangetok be Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob nas Pomate ane gwangne ru nitangi amolmol as mate etenik ane be indi weik etok ge nivin sawa ebe atob ayeu namat vunu be as mate ebe ve aitol ane ok, okob namdil vukuri nangge taku gimat ane ok.” ");
INSERT INTO kbm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Be Yisu ginei, “Dangetok be asonge nindeb mul ane nivin ebe Pomate Natu ve ninumul ninme ok, okob atob avie bamo ti ebe geb amolmol dabin nangge taku undib ti are Siba ok, atob nimdil be nilgum amolmol as mate etenik ane as yaun. Ve avie bamo nok ei gibweg taku undib molge bemem ei ta gitung ete luev undib molge ok ite ma. Ei gimdil be gile ve niute yaun vevies tepwe ebe amol bamo ti are Solomon ginei-ginei ok.” Be Yisu ginei, “ayeu angg dabangg gwet vie be bamo molge gitlek Solomon ane bemem yem ute awangg yaun ite. Dangetok be ayeu nanei nitangi yem, asonge nindeb mul ane atob avie bamo etok nimdil be nilgum yem aim yaun. ");
INSERT INTO kbm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Be amolmol Niniwe ane ok atob inamdil be inalgum amolmol as mate etenik ane as yaun nivin weik etok ge. Ve gisov eisir iute Pomate ane yaun (mateu) ebe ane amol kulkul ane Jona ginei ok, be eisir iro is ate vukir seukie-ngge ikwai gen tiate aplo be aplos givin Pomate. Be Ayeu nanei nitangi yem, Pomate Natu ayeu, gatlek Jona bemem yem ute awangg yaun be aplongg aim givin ayeu ite molge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Be Yisu ginei, “Amol ti gitung lam bekob givandung kilkiel giwei ite ma, ei giravi gikaiwel lavo ebe gikaiwel ok veik niro amolmol ebe imbweg nam aplo ok, be amolmol ebe ve inde ei ane nam ok atob indi vas lavo vevie weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dangetok be matanond etok weik utland ulis ane yev. Ginei mie matanom gili gen vevies ge, okob mie aplom ok atob niengk sang vie-ngge weik etok ge. Bemem ginei mie matanom gili gen tiate, atob gen tiate walang ano ningik niengk mie aplom weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Dangetok be yem unemb aim ate dabin vie-ngge velob gen tiate walang ano ningik niengk yem aplongg aim. ");
INSERT INTO kbm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Be unalgum aim gen walang ok niengk nitip ge unvang amolmol nas ge. ");
INSERT INTO kbm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisu ginei yaun etok givang love ma gikwai bekob Parisai amol ti gile ginei gitangi ei ve nile be nen ben nivin ei nangge ane nam. Beti Yisu gile be gipil amol nok ane nam aplo gile gibweg ve nen ben. ");
INSERT INTO kbm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amol nok gili ebe Yisu givuk bage ite be ve nen ben ok, be avo poke-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Beti Yisu ginei gitangi ei be ginei, “Yem Parisai, yem upasang utlangg aim ulis gideb dume ane-ngge love vie molge, bemem nangge aplongg aim gen tiate walang ano molge gingik giengk. ");
INSERT INTO kbm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yem dabangg-aim gwet ma molge, Pomate gipasang gen walang ok, dume be aplo ok gitangi ate-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bemem ginei yem unemb amolmol ebe gen ma ve is ok ru be unemb aim wambal subu nitangi eisir, atob amolmol indi yem aim luev walang ok vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yem Parisai yem amolmol tiate ane roro-ngge, yem undi aim ate-ngge, yem uvwat aim gen natu natu walang ok nangge aim um be omb ve da gitangi Pomate, bemem luev vie molge ebe ve tand nivin amolmol be tis ebe ve aplond nivin Pomate ok ete yem uvkir dumangg aim gitangi. Bemem gitangi ebe ve tanalgum gen ti be bwaind ve ti ok ite, gitangi ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yem Parisai yem amolmol tiate ane, as mate walang ok yem tangg aim givin ve unambweg nindeb taku ebe amolmol tepwengge matanos gitut gibweg ok nangge lum mateu ane aplo gigas ta-ngge, be tangg aim givin ve amolmol avos nivwat yem arengg aim nangge nam luvwe luvwe. ");
INSERT INTO kbm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yem undi aim ate-ngge, yem weik umbub muanggane ti ebe nolge amolmol tulkwas gipiel giengk nalk aplo be amolmol tas gisgil be ivang iwei dobo ok.” ");
INSERT INTO kbm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bekob gidung yaun ane ti ginei gitangi Yisu be ginei, “Gidung, Mie gunei yaun etenok be gilgum amei ebe amb Mose ane yaun dabin ok tiate givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Be Yisu giwel amol nok avo be ginei, “Yem amolmol ebe omb Mose ane yaun dabin ok yem ok weik etok ge! Be undi aim ate-ngge. Yem unei yaun gwangne molge gitangi amolmol be unei eisir invang mul ve yem aim yaun ge, bemem yem ate ulgum aim yaun ete unei ok ano gile ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Warik gimungg ane yem aim bambamo-nggen es Pomate ane amolmol kulkul ane ebe inei Pomate avo ok (propet) vunkunu, beti galkik yem uli gen ete eisir ilgum ok weik ebe aim gen vie molge ti ok beti upasang eisir as umbub love vie molge be ete ulgum painge-ngge uvang nik. ");
INSERT INTO kbm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dangetok beti yaun ti ebe warik Pomate ginei gimungg ok, yaun etok gipil yem etenik roro-ngge. Ve Pomate ginei dang eteik; “Atob ayeu nahlin angg amolmol kulkul ane ebe inei ayeu avongg (propet) ok be invang intangi eisir inde, kob atob eisir ines awangg amolmol kulkul ane nok subu vunkunu be ines subu nireu ei-givsangin be atob invinvin subu nangge nam dabe walang ok nitangi-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Dangetok beti atob gen ebe warik Pomate geb nalk tis gulumb vaku-ngge be yem tumbungg aimgen ilgum be painge love galkik as mate etenik ok, ete atob yem amolmol as mate etenik ane un-gas gen bambamo etok ane vavavne nivin weik etok ge. Eisir es Abel vunu be ginme love es Sakarias, amol bamo ebe geb kulkul da ane nangge lum yamar ok vunu nangge lum yamar aplo gibloblo taku da yev ukwas ane. Dangetok be ayeu nanei bingano-ngge nitangi yem nanei, amolmol as mate etenik ane atob in-gas gen bambamo etok ane vavavne nivin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Be Yisu ginei, “Yem gidung yaun ane, yem undi aim ate-ngge, Amolmol ilgum ve insov Pomate ane taku inde bemem yem uvarkei eisir as luev avwut painge-ngge. Bemem yem ate ok gitangi ebe atob unsov unde ok ite weik etok ge!” ");
INSERT INTO kbm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yisu gimdil ve nile nihlang nikwai nam ete gibweg ve gen ben ok, be amolmol ebe emb Moses ane yaun dabin ok be tis eisir Parisai subu ilgum ve inemb ei ta beti iutani ei ve yaun walang ano molge. Eisir ilgum veik Yisu ninei yaun ti nitlek be eisir inemb ei ta be in-gas ei intangi bambamo yaun ane inde be inalgum ei ane yaun. ");
INSERT INTO kbm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amolmol anongge iro is ate sut itangi Yisu ile love sawa ma molge be ivarkei iwei-iwei is ate. Beti Yisu ginei gitangi ane singamolomb gen be ginei; “Eisir Parisai amblas ailu weik ebe vap ok, dangetok be unemb aim ate dabin vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","3","Be gen ret-ret ete givuaivun ate-ngge ok atob niengk nitip ge, be yaun ebe amolmol tas gisgil ok atob inatpweng are be ma. Be yaun ret ebe yem unei uvang aikai-kawe-ngge ok, ete atob inei yaun etok nitangi amolmol be inaute. Be yaun ebe yem ate-ngge unei bwaibwayage gitangi aim ate-ngge nangge nam aplo ok ete atob inei nile nihlang nam luvwe be amolmol tepwengge inaute. ");
INSERT INTO kbm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Angg nune-nggen, ayeu nanei nitangi yem, Unpelk ve amolmol ebe gitangi ve ines amolmol utlas ulis ge vunu bemem gitangi ebe atob inalgum gen tiate molge ti nitlek etok nindeb mul ane ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bemem amol ebe yem unpelk ve ei ok eteik. Yem unpelk ve Pomate ei dongke-ngge ebe asonge nes amolmol vunu bekob ane gwangne nitin eisir inde insov yev bamo ebe giengk dangetok ok aplo inde ok. Dangetok be unpelk ve ei dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ve Pomate geb gen walang etenik dabin, be ei gili be givnawi gen bambamo etenik love givnawi mank natu natu ebe amolmol ili weik gen sin-ge ok, ");
INSERT INTO kbm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","be givnawi amolmol dabaslan givin weik etok ge. Be yem unpelk ve amolmol ebeok sinsin-ge ite, ve yem amolmol yem gen vie molge gitlek mank natu ebe uli weik gen sin-ge ok bemem Pomate ta givalngan eisir ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Amol ti ginei ninei ayeu arengg vusa nitangi amolmol be ninei, ei ane kawe bamo ayeu. Atob Pomate Natu ayeu ebe meng gahlang weik amolmol ok nanei amol etok are vusa nitangi Pomate ane angela weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bemem ginei amol ti ninei nitangi amolmol be ninei ei ane kawe bamo ayeu ite, okob atob Pomate Natu ayeu ok atob nalgum ei weik etok ge nitangi Pomate ane angela nivin. ");
INSERT INTO kbm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Amol ti ginei ninei yaun ungglus-ungglus nipil Pomate Natu ayeu ebe meng gahlang weik amolmol ok, atob Pomate ta nivalngan ei ane tiate etok nikwai. Bemem amol ti ginei ninei yaun ungglus-ungglus nipil Ngalau Yamar, okob Pomate atob nisin ei ane gen tiate etok nikwai ite molge, ei ane tiate etok atob niengk dangetok. ");
INSERT INTO kbm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ginei amolmol emb yem ta be inggas aim isov as lum mateu ane aplo ule ve inalgum yem aim yaun, me itak yem uvarkei amolmol bambamo nas, okob aplongg aim bunam be tangg aim nitung walang ano ve ebe atob unei aim yaun nam nambed ok ane bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ve sawa ete yem ve unvarkei bambamo yaun ane nas ok, atob Ngalau Yamar nemb yaun ebe yem ve unei niwel eisir avos ok nitangi yem be unei.” ");
INSERT INTO kbm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bekob amol ti gimdil be ginei, “Amol Bamo, ayeu tang givin ve mie nunei nitangi awangg kawe be ei nemb eilu amei gen ebe tamangg amei geb ok tavlu nitangi ayeu.” ");
INSERT INTO kbm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Be Yisu giwel amol nok avo be ginei, “Amol ret geb ayeu be ginei ayeu navang ve napasang amolmol as yaun be nambwas as gen nitangi is ate? Ma yapin! Be etenik awangg kulkul ite ma.” ");
INSERT INTO kbm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Beti Yisu ginei gitangi amolmol tepwengge be ginei, “Amolmol as gen vevies walang ano molge ete giengk nik, dangetok be yem undi aim ate-ngge velob unvalval as gen. Tanambweg matawand ane dabe gisov wambal ite, ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bekob Yisu ginei bing-ai ti gitangi eisir be ginei, “Amol ti ei tis are ti, be ane wambal eteik bamo molge, be amol nok givro ane ben gisov nalk sawa ti be ei ane ben etok ges ano anongge molge. ");
INSERT INTO kbm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Beti amol nok tang gitung gile ma ve ei ane nam ben ano ane etok natu molge be gitangi ebe atob nitak ane ben etok tepwengge nisov nile niengk ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Amol nok ta gitung givang bekob ginei ve ate be ginei, “Ayeu nali be nasang angg nam ben ane etenik nikwai bekob natav ebe nambe bamo ok ti vukuri. Veik naro angg ben walang ok be tis angg wambal tepwengge sut nisov nile niengk. ");
INSERT INTO kbm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Be Yisu ginei, Amol nok atob ninei ve ate dangeteik: Ayeu amol vie molge, awangg gen walang ok ande giro ate sut love ande gisov taku dongke-ngge gile gikwai, dangetok be atob ayeu nalgum kulkul ben ane ti vukuri ite ayeu atob nambweg sinsin-ge be nan be nanum be nambweg tis tanggvevie-ngge tis as mate walang ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bemem kob atob Pomate ninei nitangi amol nok be ginei, ‘Kuelk girau gile mie, atob tambok etenik ge ayeu nanggas mie dalgom matawem ane nikwai utlem ulis okob mie gitangi ebe atob nunggas am gen vevies etok tepwengge nivin mie ate ok me ma?’ ");
INSERT INTO kbm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Be Yisu ginei gitangi amolmol tepwengge be ginei, Amolmol ebe tis wambal walang be ili is ate inei eisir tis mone bamo weik ete amol etok gilgum ok, eisir etok ete Pomate gili eisir weik ebe gen sin-ge ti ok.” ");
INSERT INTO kbm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Be Yisu ginei gitangi ane singamolomb gen be ginei, “Dangetok be aplongg-aim bunam be tangg-aim nitung gen ete ve unen be unum ok, be tis kup be kambam ebe ve nisil utlangg-aim ulis ok nitlek molge-ge ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ve tanambweg matawand etok gen vie molge gitlek ben. Be utland ulis etok gen vie molge gitlek kup be kambam. ");
INSERT INTO kbm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Be Yisu ginei, Yem undi mank bambamo ete ivang nik, eisir um ma ve is be as nam ben ano ane ti giengk ite ma molge, bemem Pomate ei ate givkwen eisir. Be yem amolmol yem gen vie molge gitlek mank be Pomate atob nemb yem dabin vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bekob ginei, Amol ti ginei ta nitung ve ginei atob ei nimbweg matawe sawa undib siti nivin bekob, okob ei gitangi ebe atob nilgum dangete ande ta gitung ok me ma? Ma yapin! ");
INSERT INTO kbm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dangetok be yem tangg-aim nitung gen ete ve unum be unen ok be tis kup be kambam ebe ve nisil utlangg-aim ulis ok nitlek molge-ge ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yem undi monok bambamo ete givarkei sangas be nam luvwe-luvwe nik, eisir emb kulkul ben ane me emb kulkul ve ipasang kup tis kambam ite, bemem ayeu nanei nitangi yem, amol bamo Solomon ei amol tis are ti be ei ane wambal bamo molge, bemem ei ane kup me kambam ti bwalbwale vie molge weik ete monok ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Be monok bambamo ete galkik ivarkei nik, eisir gen galkik ane-ngge be asongkob atob ainggwen be nes ulur nikwai. Bemem Pomate ei ate gigolong eisir utlas ulis ve gen bwalbwale vevies ge. Dangetok be Pomate ok atob nemb gen vevies ge nitangi yem nitlek ete ei gilgum gitangi monok ok, bemem yem aplongg-aim givin ei ano molge ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Beti gilgum be aplongg-aim bunam be tangg-aim gitung yaun walang ano molge. ");
INSERT INTO kbm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Amolmol gitip ane ebe itpweng Pomate are ite ok, eisir ilgum gen weik etenik. Eisir tas gitung walang ano be aplos bunam ve atob inen be inum gen nangge inend). ");
INSERT INTO kbm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bemem yem, yem Tamangg aim ebe gibweg gulumb ok ei gili be gitpweng are gikwai ginei yem tangg-aim givin ve un-gas gen etok be ebeik. ");
INSERT INTO kbm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Dangetok be yem undi Pomate weik aim Amol Bamo, be atob ei nemb gen walang etok nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Be Yisu ginei ve amolmol ebe imbweg ve iute ei ane yaun ok be ginei, Yem amolmol dubi natu etenik, amolmol subu ili yem weik gen sin-ge bemem Tamangg aim ebe gibweg gulumb ok ei ta vevie anongge ve ginei nemb yem dabin. ");
INSERT INTO kbm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dangetok be unemb aim wambal nitangi amolmol be inavgo be unemb gen etok ane mone nitangi amolmol ebe gen ma ve is ok. Be unemb kulkul ve unro aim gen vevies sut nisov Pomate ane taku nile niengk, ve amolmol vaina ane gitangi ebe atob insov inde be invwat nikwai ok ite, me gwaleseng wat nidbwen aim gen gilkili ok ite ma molge. Ve taku ete yem ve unro aim gen vevies sut nisov nile niengk ok, ");
INSERT INTO kbm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ete atob yem ate ok tangg-aim nivin ve unde unambweg taku etok nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Be Yisu ginei, “Yem tangg-aim gisgil gen ret-ret ebe atob ninme ok, dangetok be unpasang aim ate yapin ge kob unambweg. Unro aim kambam love gwangne vie be unban aim yev be aivi veik niro taku, ");
INSERT INTO kbm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","weik amolmol kulkul ane ebe ipasang is ate yapin be imbweg ve isge as amol bamo ebe gile ve gen avie gabu amol vaku as ben givang bekob ninumul ninme ok. Ginei amol bamo nok nimbielk be nile ninding-ding nam avo, atob ane amolmol kulkul ane nok inamdil seukie-ngge inde ines nam avo ponge. ");
INSERT INTO kbm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Be amolmol kulkul ane nok atob tas vevias ge, gisov eisir ipasang is ate yapin be nas giengk as amol bamo-ngge love ande gibielk sin-ge. ");
INSERT INTO kbm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Be Yisu ginei ayeu nanei nitangi yem, Ginei amol bamo nok nimbielk tis tambok luvwe me tis ebe kavkavav giteng mate ane ok be nili ane amolmol kulkul ane ebe ande ipasang is ate yapin be isge ei-ngge ok, okob atob ei nimbiti ane kup ta love gwangne be atob ninei nitangi ane amolmol kulkul ane nok ve inambweg golonge be ei ate atob nemb kulkul ve nindu ben be eisir inen. ");
INSERT INTO kbm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Be Yisu ginei, Yem tangg-aim nitung yaun ete ayeu ganei nik vevie be undi kob! Amol ti ginei gitpweng as matano sawa ebe amolmol vaina ane atob inme be invaina ei ane gen nangge ane nam aplo ok are gikwai, okob amol nok atob nipasang ate be nimbweg ve na niengk amolmol vaina ane ebe atob inme ok. ");
INSERT INTO kbm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dangetok be yem ok unpasang aim ate yapin weik etok ge, ve Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob nanumul nanme nivin sawa ebe yem tangg-aim gitung unei atob ayeu nanme ite ok.” ");
INSERT INTO kbm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Be Pita ginei gitangi Yisu be ginei; “Amol Bamo, mie gunei bing-ai etok gitangi amei singamolomb ge me mie gunei guro amolmol tepwengge avwut gipil dongke?” ");
INSERT INTO kbm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Be Amol Bamo giwel Pita avo be ginei, Ayeu ganei yaun galkok gitangi amolmol tepwengge be ganei gipil amol dongke-ngge dangeteik, amol kulkul ane vie ti ei gisov ane amol bamo ane yaun walang ok ane lu vie-ngge be geb ane kulkul walang ok vie-ngge. Beti ei ane amol bamo geb ei ve nemb ane sukus-gen dabin be nemb ben nitangi eisir nivin. ");
INSERT INTO kbm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Be givin ebe amol bamo nok ginumul ginme be gili ebe ane amol kulkul ane nok geb ane kulkul vie-ngge givang ok, be ei ta vevie-ngge ve ane amol kulkul ane etok anongge. ");
INSERT INTO kbm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Be Yisu ginei ayeu nanei nitangi yem, amol bamo nok atob nemb ane amol kulkul ane etok ve nemb ei ane gen walang ok dabin. Bemem ginei amol kulkul ane nok weik amol tiate ti, okob atob ei ninei ve ate dangeteik, Awangg amol bamo gitangi ebe atob ninumul ninme ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Okob atob ei nimdil be nes ane sukus-gen ebe tepwe emb kulkul ivin is ate ok, be nile ve nen be ninum nivin amolmol bui vavis ane. Be amol nok atob ane amol bamo ninumul ninme nivin sawa ebe ei ginei bwat atob ane amol bamo ninme ite ok, kob atob amol bamo nok nes ane amol kulkul ane etok tiate molge be nitin ei be nile nimbweg nivin amolmol wayam tinas ane. Be nangge taku etok atob ei ninggas vavavne bamo molge. ");
INSERT INTO kbm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Be Yisu ginei, “Amol ti ginei gitpweng gen ebe ane amol bamo tang givin ve ei nilgum ok are gikwai, bemem amol nok gipasang ate be gilgum gen ebe ane amol bamo ginei ei nilgum ok ano gile ite, amol etok atob ninggas vavavne bamo molge nangge ane amol bamo. ");
INSERT INTO kbm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bemem amol kulkul ane ti ebe ta gisgil gen ebe ane amol bamo tang givin ve ei nilgum ok, be ei gilgum gen subu-subu be gitangi ebe atob ei ninggas vavavne ve gen etok ane ok, bemem atob ei ninggas vavavne ano ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Be Yisu ginei, Ayeu ganme ve nalgum yev be niro nangge nalk, be ayeu tang givin anongge ve ganei nali yev nok ane aivi ebe giro taku be bogbogo ok. ");
INSERT INTO kbm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Be gen bunam ti ebe atob ayeu nanggas ok ete giengk nik nangge, be ayeu aplongg bunam molge ve ganei gen bunam etok menile nikwai kob. ");
INSERT INTO kbm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Be Yisu ginei, Yem unei bwat ayeu ganme nalk ve nalgum amolmol be inambweg vie bemem ma! Ayeu ganme nalk be atob amolmol indi is ate tiate be inemb is ate vusvusa. ");
INSERT INTO kbm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Galkik as mate etenik ginei eisir vu ti inambweg nam dongke-ngge, atob eisir inemb is ate vusa be inambweg atatane ve gisov eisir subu aplos givin ayeu, bemem eisir tavlu aplos givin ayeu ite. ");
INSERT INTO kbm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Be amolmol walang ok atob inalgum weik etok ge, amol ti gabu natu atob indi is ate, be avie ti gabu natu-avie atob bwais ve is ate, be avie ti gabu lawa-vie ok atob bwais ve is ate weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bekob Yisu ginei yaun eteik givin gitangi amolmol be ginei, Givin ebe yem uli tumi bamo molge gile givarkei gielk dabe ok be unei, atob ur tis wavin ninme, be yem aim yaun etok ano gile. ");
INSERT INTO kbm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Be givin ebe wavin givang be ane vavavne bamo molge geb taku avwut ok, be yem unei atob asausa nimbielk, okti gen etok ano gile gitangi ete yem unei ok. ");
INSERT INTO kbm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Be Yisu ginei, Yem uli gen ebe giengk nalk ok be tis gen ebe giengk gulumb ane lu ok be utpweng sawa ebe gen etok ve menihlang ok are seukie-ngge, bemem gimdom beti utpweng gen as mate etenik ane ebe asonge Pomate nilgum nitangi yem ok are ite? Yem amolmol bingkasop ane. ");
INSERT INTO kbm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Be luev roro ebe ve tanpasang yaun ane ok ete yem utpweng are ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ginei miam nune ti ve ninggas mie nitangi bambamo ebe ilgum amolmol as yaun ok nile, okob gabu unpasang aim yaun etok seukie-ngge tis ete gabu uvang dongke nangge luev ve ule ok. Veik ei ninggas mie nutangi bambamo ebe ilgum amolmol as yaun ok nule bwaya, velob eisir etok inemb mie nitangi amolmol ebe emb nam kapual-lu ane dabin ok nule. Be atob eisir ebe emb nam kapual-lu ane dabin ok intak mie nusov kapual-lu nule numbweg. ");
INSERT INTO kbm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Be Yisu ginei, Ayeu nanei nitangi mie, atob mie menuhlang nukwai nam kapual-lu ane seukie ite love nos am gen bambamo ebe gulgum ok ane den vunkunu nikwai kob. Yisu ginei bing-ai etenik gipil Pomate be tis amolmol. ");
INSERT INTO kbm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Givin sawa etok ge amolmol subu itangi Yisu ile be inei amolmol Galilaia ane subu as yaun ebe warik Pilata ges is vunu givin ebe emb as da gitangi Pomate ok, lavo gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Beti Yisu giwel eisir avos be ginei; “Pilata ges eisir etok vunkunu beti wat yem tangg-aim gitung unei eisir etok ebe ilgum gen tiate walang molge gitlek amolmol tepwengge nangge Galilaia ok me? ");
INSERT INTO kbm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Be Yisu ginei, Ma yapin! Ayeu nanei nitangi yem, ginei yem uro aim ate vukir ukwai aim gen tiate aplo ite, atob yem ok unmat vunu weik ete eisir ok weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Be amolmol 18 ebe nam undib bamo ti gible be giduel eisir be imat vunu nangge Siloam ok, wat yem tangg-aim gitung unei eisir etok ebe ilgum gen tiate walang ano gitlek amolmol tepwengge ebe imbweg Jerusalem ok me? ");
INSERT INTO kbm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma yapin! Dangetok be ayeu nanei nitangi yem, ginei yem uro aim ate vukir ukwai aim gen tiate aplo ite, atob yem tepwengge ok unmat vunu weik ete eisir ok weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bekob Yisu ginei bing-ai eteik gitangi eisir be ginei, “Amol ti givro avi ti givarkei ane um aplo, avi nok gireu love ande bamo be sawa ti amol nok gile ve ninggas ane avi nok ane ano ve nen, bemem avi nok ano ma. ");
INSERT INTO kbm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Beti amol nok ginei gitangi ane amol ebe geb ei ane um dabin ok be ginei, Ayeu gavail avi etenik gitangi Sonda Bamo aitol bemem gagas ano ti ite molge. Dangetok be ule be utle ikwai ve givarkei be girwel nalk ane sisi sinsin-ge be ges ano ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bemem amol ebe geb um dabin ok giwel ei avo be ginei, ‘Amol Bamo, utau be ivarkei Sonda bamo dongke etenik nivin be ayeu atle nalk be aro bwelk ta ile dabe be tandi kob. ");
INSERT INTO kbm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Be ginei ges ano givin Sonda bamo etenik givin ite kob tanatle nikwai.’” ");
INSERT INTO kbm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Givin Juda as Sonda ti Yisu gisov lum mateu ane aplo gile be ginei mateu ve amolmol givang. ");
INSERT INTO kbm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Be avie nam etok ane ti ebe ngalau tiate ti geb gimat gitangi ei be gitangi ebe ve nivang dume roro ok ite, be gimat etok gisa ei dangetok gitangi Sonda bamo 18, be gilgum avie nok love givang dume kumb-kumb tiate molge. Avie nok gisov lum mateu ane aplo gile gibweg be giute mateu ebe Yisu ginei ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisu na gile gili avie nok be gital ei be ginei, “Miam gimat ande ma gikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yisu gitak bage giwei avie nok be seukie-ngge ei gito ate be dume gile roro vukuri be avo givwat Pomate are. ");
INSERT INTO kbm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bemem amol ebe geb lum mateu ane dabin ok gili ebe Yisu gilgum kulkul givin Sonda Sabat ve gilgum avie dume kumb etok be vie vukuri ok be ta vavis anongge. Be ginei gitangi amolmol tepwengge be ginei, “As mate ebe eitit ve tanalgum kulkul ok gitangi 6 ete giengk nik, dangetok be yem un-gas aim nune-nggen ebe tis gimat walang ano ok untangi Yisu unde nivin as mate 6 etok ge ve nili eisir as gimat. Be unalgum nivin Sonda ite!” ");
INSERT INTO kbm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Be Yisu giwel amol nok avo be ginei, “Yem amblangg aim weik vap ane. Yem ate ok ulgum kulkul tis Sonda givin ite me? Givin Sonda walang ok yem amolmol ebe tis bwelk ok ule be os aim bwelk gile gihlang gikwai el aplo be utwem eisir ile ve inum bui me me? ");
INSERT INTO kbm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Be avie etenik ei Ablaham ane dani ti, be Sadam gidgin ei ta love gwangne molge be givang dangetok ebe warik gitangi Sonda bamo 18, dangetok be gitangi ebe atob ayeu nalgum kulkul tis Sonda ve nahlang Sadam ane wal etok nikwai ei veik nivang vie vukuri ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yisu ane yaun etok gilgum amolmol ebe ili ei tiate ok mai mayas anongge, be giwel amolmol tepwengge tas vevias ge ve gen vevies bambamo ebe Yisu gilgum gilgum ok ane. ");
INSERT INTO kbm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Be Yisu ginei ve amolmol be ginei; “Atob ayeu namb luev ebe Pomate geb amolmol dabin ok tuvweng nipil wer-sivsiev ano ane vatu. ");
INSERT INTO kbm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wer-sivsiev ano ane vatu nok ei gen natu pisik molge, be amol ti givwat gile givro nangge ane um. Bemem bwayage kob gen nok gireu love bamo weik ebe ei ok, be mank ile ipasang as niu gile range be imbweg.” ");
INSERT INTO kbm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yisu ginei bing-ai ti vukuri gipil Pomate ane gwangne ebe givang givin amolmol ebe ili Pomate inei as Amol Bamo ok, be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“Pomate ane gwangne givang geb taku walang ok avwut weik ebe gielk ok. ");
INSERT INTO kbm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisu ta gitung ve nireu nile Jerusalem, beti ei ta gitung ve ginei nivang nitangi nam dabe ge nile be ninei mateu ve amolmol nile nile love nimbielk Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Be amol ti giutani Yisu be ginei; “Amol Bamo, amolmol ebe asonge inambweg matawas ok atob wat aitol ge me?” Yisu giwel amol nok avo be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yem unemb tulkwangg-aim vier veik unsov nam avo natu pisik ebe gitangi Pomate ane taku ebe ve nemb amolmol dabin ok unde. Ayeu nanei roro-ngge nitangi yem, Amolmol anongge molge atob lolos ve insov nam avo natu pisik etok inde bemem atob inalgum be nitangi ite. ");
INSERT INTO kbm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Be ginei Amol Bamo nes ane nam avo avwut nitle yem gili be unvarkei dume ane be ule unding ding nam avo be unei, “Amol Bamo os nam avo ponge ve amei ma!” Okob atob ei niwel yem avongg-aim be ninei, ‘Wali yem unme nangge, ve ayeu tangg gisgil yem?’ ");
INSERT INTO kbm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Be atob yem unwel ei avo be unei, “Amei ebe an be anum gisov dongke avin mie, be mie guvarkei amei-mei nam luvwe be gunei mateu gitangi amei ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bemem atob ei niwel yem avongg-aim vukuri be ninei, ‘Yem unme nangge sawa inend, ve ayeu tangg gisgil yem? Yem etenok tepwengge tiate ane ge be unde aikawe unkwai ayeu!’ ");
INSERT INTO kbm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Be Yisu ginei, Nivin sawa etok atob yem undi Ablaham gabu Isak be Jakop be tis Pomate ane amolmol kulkul ane ebe inei Pomate avo ok (propet) tepwengge ebe isov ile be imbweg tis tas vevias ge nangge Pomate ane taku ok. Bemem yem ate atob unvarkei dume ane be yayai be unlat nivongg aim nipil ate be atob un-gas vavavne bamo molge. ");
INSERT INTO kbm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Be amolmol anongge atob inme nangge taku walang ok, nangge nalk ane den dani be dani be atob inde inambweg invin Pomate nangge ane taku vie ebe ve nemb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Be unaute, Amolmol ete galkik imungg nik atob inde indeb mul ane, be amolmol ete galkik vemul nik atob inde inmungg.” ");
INSERT INTO kbm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Givin as mate etok ge eisir Parisai subu itangi Yisu ile be inei, “Mie uli be ukwai taku etenik be ule sawa ti ve Herodes gilgum ve nes mie vunu.” ");
INSERT INTO kbm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Be Yisu giwel eisir nok avos be ginei, “Unde be unei ve uvun tiate etok (Herodes) be unei ayeu gapelk ve ei ite, ayeu atob namb angg kulkul tis as mate etenik be asongkob nivin, be tanamdil ti ane kob atob ayeu nas angg kulkul vunu. ");
INSERT INTO kbm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bemem atob ayeu naro angg luev dani itin vukuri tis as mate etenik be asongkob be tanamdil ti ane nivin, ve nareu nale Jerusalem. Ve gitangi ebe ines Pomate ane amolmol kulkul ane ti (propet) vunu nangge nam dabe ti ok ite, bemem nangge Jerusalem dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yisu tang gitung amolmol Jerusalem ane love aplo bunam be ginei, “O yem amolmol Jerusalem ane, yem os Pomate ane amolmol kulkul ane ebe inei Pomate avo ok (propet) vunkunu be os ane amolmol ebe gihlin eisir be itangi yem inme ve inemb yem ru ok ve vat. Be ayeu galgum ve naro yem sut unme unambloblo ayeu weik ebe kavkavav tine ti giro natu-nggen sut gisov bage-lan ane lu gile ok, bemem yem bwaingg aim ve ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dangetok be unaute kob, Galkik as mate etenik atob taku nitu niwei yem aim nam luvwe be atob niengk dangetok. Be ayeu nanei nitangi yem, atob yem undi ayeu vukuri ite love nindeb mul ane kob atob yem unei, ‘Avond nivwat Amol etenik are ve Pomate givang givin ei.’” ");
INSERT INTO kbm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Givin Sonda Sabat ti Yisu gen ben nangge Parisai as amol bamo ti ane nam. ");
INSERT INTO kbm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Be givin sawa etok ge amol ti ebe gigas gimat tiate ti love bage tis va givonk givonk ok gitangi Yisu gile, beti amolmol nas giengk Yisu vie-ngge ve indi ve atob ei nilgum amol nok be utle vie vukuri me ma? ");
INSERT INTO kbm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bemem Yisu ande gitpweng eisir as tas gitung etok are gikwai beti ginei gitangi eisir Parisai be tis gidung ebe emb Mose ane yaun dabin ok be ginei; “Eitit gitangi ebe ve tanalgum amolmol ebe tis gimat ok be utlas vie vukuri tis as mate ebe yem utak ve aim Sonda ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bemem eisir Parisai be tis gidung yaun ane inei yaun ti ite be tumingge imbweg. Beti Yisu gilgum amol nok ane gimat be vie gikwai kob gihlin ei be gile ve givang. ");
INSERT INTO kbm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bekob Yisu ginei gitangi eisir be ginei; “Ginei yem aim amol ti ane bwelk me ei ate natu nimbieg nisov bui kapkapul tiate ti nivin Sonda, okob amol nok atob nile be nemb kulkul tis Sonda ve nirwel ane bwelk me natu etok nikwai bui kapkapul etok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bemem eisir gitangi ebe ve inwel Yisu avo be inei yaun ti nipil gen etok ok ite beti tumi-ngge imbweg. ");
INSERT INTO kbm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisu gili amolmol subu ebe imbweg gideb mate ane-ngge ve ben ane ok beti ginei bing-ai ti gitangi eisir tepwengge be ginei, ");
INSERT INTO kbm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ginei amol ti gital mie ve nule be non ben avie gabu amol ane, okob mie nule be numbweg nindeb ete mate ane ok bwaya. Velob amol ti ebe vie molge gitlek mie ok atob ninme ve nen ben etok nivin, ");
INSERT INTO kbm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","okob atob amol ebe geb yaun ve yemlu aim-gabu ok atob ninme be ninei nitangi mie be ninei, ‘Mie umdil ukwai sawa etenik be amol etok inme imbweg.’ Okob atob mie maimaem anongge be atob nule numbweg ebe mul ane molge ok. ");
INSERT INTO kbm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dangetok be ginei amol ti gital mie ve nule be non ben nuvin ei, okob mie nule bemem nule be numbweg nindeb ebe mul molge ok. Veik amol ebe gital mie ok atob ninme be ninei nitangi mie be ninei, ‘Angg nune, Umdil unme umbweg taku vie ebeik.’ Okob atob mie numbweg weik ebe amol bamo ti ok nangge amolmol tepwengge nas.” ");
INSERT INTO kbm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Be Yisu ginei; “Bingano, amolmol ebe avos givwat is ate ok ete Pomate gili eisir weik ebe gen sin-ge ok. Bemem amolmol ebe ili is ate weik gen sin-ge ok ete Pomate avo givwat eisir ares.” ");
INSERT INTO kbm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bekob Yisu ginei gitangi amol ebe gigas ei gile ane nam ve gen ben ok be ginei; “Ginei mie ve nulgum ben ve amolmol inen, okob mie nomb yaun ve am nune-nggen me am kawe-nggen me amolmol ebe tis ares ok bwaya, ve eisir dang dangetok ete atob inalgum ben ve mie niwel miam ben ete gulgum ve eisir ok ane. Okob atob miam gen vevies ebe asonge nunggas nindeb mul ane ok ete ande gugas yapin ok be wat atob nunggas ti vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dangetok be ginei mie ve nulgum ben, okob mie nomb yaun ve eisir kubuk ane be tis amolmol ebe wambal ma ve is ok be inme be inen miam ben etok. ");
INSERT INTO kbm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Veik miam gen vevies ete ve nunggas niwel am ben ete gulgum ok atob niengk yapin, ve eisir ete en miam ben ok gitangi ebe atob inalgum ben ti niwel miam ben ete gulgum ve eisir ane ok ite. Bemem nindeb mul ane atob mie numbweg tis tam vevie-ngge nivin ebe amolmol vevies ane inamdil vukuri nangge taku gimat ane ok, ve Pomate ei ate atob nemb gen nitangi mie niwel miam ben ete gulgum ok.” ");
INSERT INTO kbm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amol ti gibweg ve giute Yisu ane yaun ebe ginei ginei ok love kob ginei gitangi Yisu be ginei; “Amolmol ebe asonge inambweg invin Pomate nangge ane taku be inen ben ok, eisir etok atob tas vevias ge.” ");
INSERT INTO kbm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Beti Yisu ginei bing-ai ti gipil ei ate be tis eisir Juda be ginei; “Amol ti ta gitung ve nilgum ben bamo ti beti ei geb yaun ve amolmol walang ok yapin ve ben nok ane. ");
INSERT INTO kbm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Be givin as mate ebe eisir veve inambweg ve inen ben etok ok be amol bamo nok gihlin ane amol kulkul ane ti be ginei, ‘Mie nule be nunei ve amolmol ebe ayeu gab ayun ve eisir yapin ok be inme ve inen ben ve ande ayeu gapasang gen walang ok gikwai.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bemem amolmol ebe warik inggas yaun ben etok ane yapin ok imdil be inei is ate lavo-lavo gitangi amol bamo etok ane amol kulkul ane nok dang eteik; Amol ti gimdil be ginei, ‘Ayeu ande gavgo nalk sawa ti gikwai beti atob nale be nali kob, be mie nok ule kob unei ayeu lavo.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Be ti gimdil be ginei, ‘Ayeu gavgo bwelk gitangi 10 be atob nale ve nali angg gen, be atob nalek ite be mie nok ule kob unei ayeu lavo.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ba amol ti gimdil be ginei, ‘Vasov nik ge ayeu gab avie be atob nalek ite, dangetok be mie ate nok ule kob unei ayeu lavo.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Amol nok ginumul gile be ginei yaun bambamo etok gitangi ane amol bamo be giute love ta vavis anongge ve amolmol ebe ande bwais ve inde be inen ben ok, beti avo girau ane amol kulkul ane be ginei, ‘Mie nule be nuvang nutangi nam etok ane luev bamo be natu walang ok be nunggas amolmol kubuk ane be tis eisir ebe wambal ma ve is ok be inme inambweg awangg nam aplo.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Amol kulkul ane nok gilgum gitangi ete ane amol bamo ginei ok, bekob gile ginei gitangi ane amol bamo be ginei, ‘Ayeu gasov miam yaun ane lu ge be gagas amolmol inme imbweg miam nam aplo bemem nam aplo sawa ete giengk nik nangge.’ ");
INSERT INTO kbm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Be amol bamo gihlin ane amol kulkul ane nok vukuri be ginei, ‘Mie nule be nukaiwel amolmol ebe ilauk as gen sinsin-ge ivang luev bambamo ok be inpil awangg nam inme veik inambweg sawa ete giengk nik avwut. ");
INSERT INTO kbm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Be ayeu nanei nitangi mie, amolmol ete ayeu gab yaun gile ve is be bwais ok atob ti ninme nen awangg ben etenik ite molge.’” ");
INSERT INTO kbm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Amolmol dubi bamo ti itau gile Yisu ve ile be Yisu girau-lili be ginei gitangi eisir; ");
INSERT INTO kbm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amol ti ginei tang givin ei ate be tame gabu tine be tis arwe-nggen be natu-nggen anongge, amol etok ei awangg nune ite. ");
INSERT INTO kbm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Be amol ti ginei bua ve amolmol inya-yaing ei be bua ve ninggas gen bunam ebe gitangi ve nimat vunu weik ete ayeu gagas be gamat vunu ok ite, atob Pomate nili ei weik natu ite. ");
INSERT INTO kbm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ginei amol ti ve nitav nam ti, atob ei nimbweg be ta nitung luev ebe ve niro nam nok ane tulkwe sut ok nimungg bekob, ");
INSERT INTO kbm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","be ginei ei ta gitung gen dangetok gimungg ite, okob atob ei nemb ane nam etok avwut ite be atob salang-salang ge nivarkei. Kob atob amolmol indi be inalgum molok nile ei be inei, ");
INSERT INTO kbm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Amol etenik gili ate gitangi beti gitav nam etenik me ei gilgum sinsin-ge?’ ");
INSERT INTO kbm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Be ginei amol bamo ti ane amolmol valir ane dubi ti gitangi 10,000 ivang be eisir veve ines valir nitangi amol bamo ti ebe ane amolmol valir ane gitangi 20,000 ok, okob atob amol ebe ane amolmol gitangi 10,000 ok atob nimbweg be ta nitung vevie-ngge be nili kob. Ve ei tis ane amolmol gen gitangi ebe atob ines valir invin amolmol 20,000 etok be inambweg inwei eisir ok me ma? ");
INSERT INTO kbm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Be ginei ei gili ei gitangi ite, okob amolmol 20,000 etok atob invang undib ge nangge be atob ei nemb ane amolmol subu be inde invin eisir 20,000 etok be tepwe inpasang yaun valir nok ane be ines vunu nikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Be Yisu ginei, “Dangetok be amol ti ginei ta givin gen nalk ane bamo molge gilek ayeu, atob Pomate nili ei weik ane amol ti ite, ma molge!” ");
INSERT INTO kbm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Gielk ei gen vavis vie molge, bemem ginei ei ane vavis etok ma be bwalum sin-ge weik ete bui ok, okob gen ti giengk gitangi ebe atob tanalgum be vavis vukuri ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dangetok be atob eitit bwaind ve gielk nok be niengk em, atob tandu ben ve gielk etok vukuri ite. Be Yisu ginei, “Ginei yem talngangg-aim avo giengk, be unaute yaun ge ma!” ");
INSERT INTO kbm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sawa ti amolmol ebe emb kulkul takes ane ok be tis eisir ebe amolmol ili eisir inei amolmol tiate ane ok ile imbloblo Yisu ve inaute yaun (mateu) ebe Yisu ginei ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Be eisir Parisai be tis gidung ebe emb Mose ane yaun dabin ok ili be tas vavis anongge ve Yisu be inei, “Amol etenik ta givin amolmol tiate ane ge be gile ve gen ben givin eisir!” ");
INSERT INTO kbm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Beti Yisu ginei bing-ai ti gitangi eisir Parisai be tis gidung yaun ane be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ginei yem aim amol ti ane bwelk sipsip dubi ti gitangi 100 ivarkei el aplo love bwelk nok ti gitut el be gile gihlang be gisov sangas, okob atob amol nok nilgum nam nambed? Be Yisu ginei, Amol nok atob na vier ve ane bwelk 99 etok be invarkei ete el aplo ok invarkei be ei atob nile be nemb kulkul ve nirek ane bwelk dongke ete gitut el be gisov sangas ok love nili kob. ");
INSERT INTO kbm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Be ginei ei girek givang love gile gili, atob ei ta vevie anongge ve ane bwelk dongke etok ane be atob nikari ane gen nipil vo be nivang ane nam ane tis ta vevie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Be atob ninei nitangi ane nune-nggen be tas vevias invin ei ve ande ei gili ane bwelk dongke ebe gisov sangas ok be gigas ane gen ginumul vukuri.’ ");
INSERT INTO kbm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Be Yisu ginei, Dangetok be ayeu nanei nitangi yem, Amolmol gulumb ane atob tas vevias anongge ve amol tiate ane ti ebe giro ate vukir ok nitlek amolmol ebe ili is ate inei eisir amolmol vie ane be bwais ve inro is ate vukir ok. ");
INSERT INTO kbm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Me ginei avie ti ane mone siliwa bage-isgabu giengk, be ti ande beleinge givin tambok, okob atob ei nitung lam be nisin seksek tepwengge nile nihlang nikwai ane nam aplo be na nitung vevie-ngge love nili ane gen kob, ve mone dongke ete beleinge ok etok weik amolmol kulkul ane as vat as mate dongke-ngge ane. ");
INSERT INTO kbm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dangetok be ginei ei nirek nivang love nili ane gen, okob atob nital nile ve ane nune-nggen be tas vevias invin ei ve ebe ande gili ane gen vukuri ok. ");
INSERT INTO kbm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Be Yisu ginei dangetok be ayeu nanei nitangi yem, Pomate ane angela atob tas vevias ge ve amol tiate ane ti ebe giro ate vukir gikwai gen tiate aplo ok anongge. ");
INSERT INTO kbm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisu ginei bing-ai ti vukuri be ginei, “Amol ti natu ailu imbweg ");
INSERT INTO kbm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","be amol mul ane ginei ve tame be ginei, ‘Tamangg, ayeu tang givin ganei galkik etenik ge mie nomb am gen walang ok vusa be numbwas nitangi eilu.’ Beti amol bamo nok geb ane gen walang ok vusa gile dubi ailu be geb gitangi natu-nggen. ");
INSERT INTO kbm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","As mate subu gile gikwai kob amol mul ane geb ane gen walang ok be amolmol ivgo, bekob givwat mone gen etok ane be gimdil gile ve givang taku undib ge ti. Ei gile be gikari ane mone be tis ane gen walang ok love ma gikwai, ");
INSERT INTO kbm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","be bwayage kob gen bunam bamo ti meng gihlang nangge taku ete ei gibweg ok ve amolmol marav-ges is geb taku walang ok avwut. Be amol nok gibweg be maravges tiate molge. ");
INSERT INTO kbm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amol nok geb amolmol taku etok ane ti ane bwelk dabin, ");
INSERT INTO kbm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","be ei ta gitung ve nen ben ete bwelk en-en ok nivin, bemem amol ti geb bwelk as ben gitangi ei ite. ");
INSERT INTO kbm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Be ei gibweg be ta gitung gitung ate love kob ginei, ‘Tamangg ane amolmol kulkul ane as ben walang molge, be ayeu ganme gabweg taku etenik be maravges-au love kasop-gege be namat vunu. ");
INSERT INTO kbm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dangetok be atob ayeu namdil be natangi tamangg nale vukuri be nanei Tamangg, Ayeu galgum gen tiate gitangi mie be tis Pomate. ");
INSERT INTO kbm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dangetok be galkik etenik mie nutal ayeu nunei natum vukuri ite, Mie nuli ayeu weik ebe am amol kulkul ane ti ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Beti amol nok gimdil be gitangi tame gile vukuri. Be givin ebe amol nok tame gili ei nangge aikawe-ngge ok be ta viti bamo molge ve natu ane be gituvki gile be gimual bage gitle natu gili be geb gile gireu bobo. ");
INSERT INTO kbm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Be amol nok ginei gitangi tame be ginei, ‘Tamangg, Ayeu galgum gen tiate gitangi mie be gitangi Pomate givin weik etok ge. Dangetok be galkik etenik mie nutal ayeu nunei natum vukuri ite.’ ");
INSERT INTO kbm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bemem amol bamo nok gital ane amolmol kulkul ane ile be ginei, ‘Unde unvwat kup ebe vie molge ok ti unme seukie-ngge be uno nireu ei be unes wal-mas nireu ei bage be untak vas taptape nile ei va. ");
INSERT INTO kbm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bekob unde be unes bwelk natu vaku ti vunu be eitit tanambweg nam be tanalgum ben ve ei ane, ");
INSERT INTO kbm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ve ayeu natungg etenik ei gile ve givang taku undib ge ti be ayeu ganei bwat nolge gimat vunu, bemem galkik as mate etenik ande ei gibielk ve eitit vukuri.’ Beti eisir ilgum ben bamo etok be tepwe en tis tas vevias ge ivin is ate. ");
INSERT INTO kbm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Givin as mate etok ge amol bamo nok natu mate ane gile ve geb kulkul givang ebe ane um ok love ma be ve nivang nam ane, ei givang love gile gibloblo nam be giute ebe amolmol es uye tis amb ok, ");
INSERT INTO kbm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","beti gital tame ane amol kulkul ane ti gile be giutani ei be ginei, ‘Yem umdom ebe os uye tis amb tis as gwangne lalalnge bamo nik?’ ");
INSERT INTO kbm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Be amol kulkul ane etok giwel ei avo be ginei, ‘Am male ebe warik givang ok ete ande gibielk vukuri ok, beti tamem ginei be amei as bwelk natu vaku ti vunu be algum ben ve ei ane.’ ");
INSERT INTO kbm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Amol nok ande ta vavis vunungge be bua ve ret nipil nile ebe nam aplo ok. Beti tame gile gihlang be ginei gitangi ei ve nipil nile ebe nam aplo ok okob. ");
INSERT INTO kbm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bemem amol nok ta vavis vunungge be giwel tame avo be ginei, ‘Givin Sonda bamo walang ok ayeu gab kulkul gavin mie weik ebe miam amol kulkul ane ti ayeu ok. Be ayeu bwaingg ve miam yaun ti ite molge, ma molge. Bemem mie gob gen ti dang etenik gitangi ayeu ve nalgum ben be tis angg nune-nggen anen ok ite molge, ma yapin! ");
INSERT INTO kbm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Be mie natum etenik ei gile ve givang ane sawa ti be giya-yaing miam gen walang ok gipil avie-gaptol wasi ane love ande ma gikwai, bemem galkik as mate etenik ei gibielk ve mie be mie tam vevie anongge ve ei ane be gos bwelk natu ti vunu be gulgum ben ve ei ane merav?’ ");
INSERT INTO kbm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Be tame giwel ei avo be ginei, ‘As mate walang ok tutlu tambweg tavin itate nangge nam, be awangg gen walang ete giengk nam nik etok mie ge am gen. ");
INSERT INTO kbm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bemem miam male etenik ei gile ve givang taku undib ge ti be eitit tanei bwat nolge gimat vunu bemem galkik as mate ande ei gibielk ve eitit vukuri. Dangetok be etok vie ve eitit tanambweg dongke be tand-vevie ve ei ane bekob.’” ");
INSERT INTO kbm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisu ginei gitangi ane singamolombgen be ginei, “Amol tis are ti ane amol kulkul ane ebe geb ei ane gen dabin ok gibweg, be amolmol subu ile inei yaun bingkasop gitangi ei ane amol bamo be inei, ‘Miam amol kulkul ane giya-yaing miam mone be tis am gen vevies subu givin.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Beti amol bamo nok gital ane amol kulkul ane etok gile be ginei, ‘Ayeu gaute miam yaun ti beti ayeu tang givin ve naute yaun nok lavo vevie kob. Be ayeu bwaingg ve ret mie nomb awangg gen dabin vukuri.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Beti amol kulkul ane nok ta gitung giengk aplo ge be ginei, ‘Ginei awangg amol bamo nitin ayeu nakwai angg kulkul, okob atob ayeu namdom au-ate? Ve ayeu gitangi ebe atob natle nalk be navro ben ok ite, be ginei ayeu nautani amolmol ve ben be tis gen subu-subu ane atob nilgum be ayeu mai mayangg.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Amol nok ta gitung gitung love kob ginei ande ayeu gatpweng gen ebe atob nalgum ok are, be ginei ayeu nalgum dangete ande tang gitung ik okob atob awangg nune-nggen in-gas ayeu napil as nam nale nivin ebe awangg amol bamo ve nitin ayeu nakwai angg kulkul ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Beti amol nok gital eisir ebe ivwat gen nangge ei ane amol bamo be es as gen etok ane den vunkunu ite nangge ok be itangi ei ile. Amol ti gimungg gile be ei giutani be ginei, ‘Mie guvwat gen aivir nangge awangg amol bamo?’ ");
INSERT INTO kbm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Be amol ebe givwat gen ok giwel ei avo be ginei, ‘Ayeu gavwat giris ebe ivse ben ok, ebe gisov daram ok gitangi daram 20.’ Be amol ebe ane amol bamo gitin ei ok ginei gitangi ei, ‘Atob mie nuro am gen ebe guvwat ok ane yaun nireu kapia vaku eteik be nuro nunei mie guvwat gen gitangi 10 ge.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bekob amol ti gile be amol nok giutani ei be ginei, ‘Mie guvwat gen aivir nangge awangg amol bamo?’ Be amol ebe givwat gen ok ginei, ‘Ayeu gavwat padi tis bek gitangi 1,000.’ Be amol ebe ane amol bamo gitin ok ginei, ‘Atob mie nuro am gen ebe guvwat ok ane yaun nireu kapia vaku eteik be nuro nunei mie guvwat gen gitangi 800 ge.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Amol nok gilgum gen bingkasop etok be ges ane luev vie molge weik ebe amolmol dabas gwet bambamo ane ilgum gen ok, beti ane amol bamo gili be ta vevie be avo givwat ei anongge ve gen ete gilgum ok ane. Be Yisu ginei, ‘Amolmol ebe ivkir dumas gitangi Pomate ok, eisir itpweng luev ebe ve inyo-inyo amolmol ok are vie molge gilek amolmol ebe aplos givin Pomate ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Be Yisu ginei ayeu nanei nitangi yem, “Unemb aim wambal nalk etenik ane nitangi amolmol ebe gen ma ve is ok, veik ginei gen ete yem omb gitangi eisir ok ma nikwai okob atob Pomate ninggas yem unde unambweg unvin ei nangge ane taku vie ninggas ta-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Amol ti ginei geb gen siti-ngge dabin vie molge, atob ei nemb gen walang ok dabin vie-ngge weik etok ge. Be amol ti ginei geb gen natu ti dabin vie ite, okob ei gitangi ebe atob nemb gen bamo ti dabin ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Be ginei yem unemb aim gen nalk ane dabin vevie ite, okob yem gitangi ebe atob unemb Pomate ane gen dabin ok ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Be ginei omb amolmol subu as gen dabin vevie ite okob gitangi ebe atob unemb yem ate aim gen dabin ok ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Amol ti gitangi ebe ve nemb tivie ailu as kulkul nipil dongke ok ite, ve atob ei bua ve tivie ti be ta nivin ti. Dangetok be yem unemb Pomate ane kulkul be tis kulkul mone ane nipil dongke ite.” ");
INSERT INTO kbm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eisir Parisai iute Yusi ane yaun bambamo ete ginei ok be ilgum molok gile ei, ve eisir nok ebe tas givin mone gitlek molge ok. ");
INSERT INTO kbm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Beti Yisu ginei yaun gitangi eisir be ginei, “Yem etenik ete upasang aim ate love vie molge veik amolmol indi be inei yem amolmol vie ane bemem Pomate gitpweng yem aplongg-aim are gikwai. Gen ebe amolmol ge ili inei gen vie be bamo ok ete Pomate gili ginei etok gen sin-ge. ");
INSERT INTO kbm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bekob Yisu ginei, Mose be tis amolmol ebe inei Pomate avo ukwas binge ok (propet), as yaun geb yem dabin painge love sawa ebe Jon ebe ges bui sanggu gipil amolmol ok meng gihlang. Jon meng gihlang kob ei ginei mateu gitangi amolmol gipil Pomate ane taku be ginei, ‘Gibloblo ve Pomate nemb amolmol dabin.’ Be Yisu ginei, ‘Dangetok beti galkik etenik amolmol ete lolos ivang nik ve insov Pomate ane el aplo inde. ");
INSERT INTO kbm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Be ginei, Gulumb tis nalk asonge ma nikwai, bemem Pomate ane yaun poke natu ti gitangi ebe atob ta nivalngan ane gen be niengk em ok ite, ma yapin.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Amol ti ginei bua ve arwe be gile geb avie vaku ti vukuri, amol etok giyaing luev ebe emb is ate ane ok. Be ginei amol ti bua ve arwe be gitin ei, bekob amol ti gile geb avie ete arwe bua ve ane ok, okob amol ete gile geb avie etok vukuri ok ei giyaing luev ebe emb is ate ane ok givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Be Yisu ginei, “Warik amol ti ebe tis are ok gibweg, be as mate walang ok ei gino ane kup vevies ge be gen ane ben vevies ge. ");
INSERT INTO kbm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Be nangge taku etok amol ti are lasarus gibweg, bid gen ei love geb utle ulis tepwengge avwut. Be as mate ti ei ane nune-nggen subu ivwat ei ile be itak gibweg gibloblo amol tis are nok ane nam avo, ");
INSERT INTO kbm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Be ei ta gitung ve nivkwen ate ve ben suk-sukus ebe amol tis are etok gen be gilgum be bingbleng gile gitak gitak nalk ok. Be uvun ok inme be es amblas givang ei ane bid bambamo ebe giengk utle ulis ok. ");
INSERT INTO kbm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ivwang be bwayage kob Lasarus gimat vunu, be Pomate ane angela inme inggas ei ile itak ei gibweg vie-ngge givin Ablaham. Bekob amol tis are etok gimat vunu weik etok ge be ispun. ");
INSERT INTO kbm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Be amol nok mang-mangi gile taku ebe yev giengk ok be gibweg etok, bemem nangge taku nok ei gigas vavavne bamo tiate. Be ei geb na itin kob gili Ablaham gabu Lasarus imbweg aikawe molge. ");
INSERT INTO kbm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Beti amol nok gital be ginei, ‘Tamangg Ablaham, tam viti ve ayeu be uhlin Lasarus inme be emb bui luvus siti be ayeu anum kob ve ayeu gagas vavavne bamo molge nangge yev bamo eteik aplo.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bemem Ablaham giwel amol nok avo be ginei, ‘Angg nune, tam itung vevie be uli kob, ve nolge mie gugas am gen vevies walang ok tepwengge gikwai givin ebe gubweg matawem nangge nalk ok! Be Lasarus likok ei gen walang ok ma ve ane be gikuk lili tiate, bemem galkik etenik ande ei gibweg tis ta vevie-ngge nangge taku vie eteik be giwel mie gugas bunam nangge etenok. ");
INSERT INTO kbm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Be givin ve luev ti giengk ebe ve amei andek andi yem be anemb yem ru ok ite ma molge. Be yem ok gitangi ebe atob unme undeb tavlu ete amei ambweg ik ok ite weik etok ge.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Be amol nok ginei, ‘Tamangg, (Ablaham) ayeu nanei nitangi mie, ginei dangetok okob mie nuhlin Lasarus be ninumul nile tamangg ane nam ok ");
INSERT INTO kbm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","be nes bing gwangne-ngge nitangi awangg male-nggen bage-tavlu ete imbweg ok velob eisir invang mul ve luev ete ande ayeu ganme ik, ve taku eteik tiate be ane vavavne bamo molge.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bemem Ablaham giwel amol nok avo be ginei, ‘Eisir isam Mose be tis amolmol ebe inei Pomate avo ukwas binge ok (propet) as yaun be itpweng are gikwai!’ ");
INSERT INTO kbm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Be amol nok ginei, ‘Ablaham, Eisir ok isam yaun etok bemem yaun etok gitangi ite weik etok ge, bemem ginei amol ti nimdil vukuri nangge taku gimat ane be nile be ninei yaun ve eisir, okob atob eisir inaute yaun be inro is ate vukir inkwai as gen tiate aplo.’ ");
INSERT INTO kbm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bemem Ablaham ginei, ‘Ginei eisir aplos givin Mose be tis amolmol ebe inei Pomate avo ukwas binge (propet) ok as yaun ite, okob atob aplos nivin amol ti ebe gimdil vukuri nangge taku gimat ane ok ane yaun nam nambed? Atob ma weik etok ge!’ ");
INSERT INTO kbm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Be Yisu ginei gitangi ane singamolomb gen be ginei, “Gen walang ano atob nilgum amolmol be insov gen tiate aplo inde. Bemem amol ret ete girwel amolmol be isov gen tiate aplo ile ok asonge ninggas vavavne bamo molge nindeb mul ane. ");
INSERT INTO kbm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dangetok be vie ve amolmol inadgin vat bamo ti nile amol nok savwalo be inkari ei nisov gielk nile, velob nimbweg be nirwel amolmol ebe as aplos givin gwangne ite ok be insov gen tiate aplo inde. ");
INSERT INTO kbm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dangetok be yem unemb aim ate dabin vie-ngge. Amol ti ginei gilgum gen tiate gitangi mie, okob mie nunei yaun be nomb bing bwaibwaya nitangi ei, be ginei ei giute miam yaun ge be giro ate vukir okob mie tam nivalngan ei ane tiate ete gilgum ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Be ginei amol nok gilgum gen tiate gitangi mie vukuri be vukuri, bekob gitangi mie gilek tis as mate walang ok be gipasang yaun gitangi mie, okob mie tam nivalngan ei ane tiate ete gilgum ok.” ");
INSERT INTO kbm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Be eisir singamolomb itangi Yisu ile be inei, “Amol Bamo, Mie nulgum amei-mei aplongg amei givin menihlang gwangne-ngge ma!” ");
INSERT INTO kbm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Be Yisu giwel eisir avos be ginei, “Yem utpweng wer-sivsiev ano ane vatu are gikwai ve gen etok ane vatu natu-natu molge bemem kob gireu love bamo weik ebe ei ok. Dangetok be ginei yem aim aplongg aim givin siti-ngge weik ete wer-sivsiev ano ane vatu ok, okob etok gitangi ebe atob yem unei nitangi ei-weiwei etenik dang eteik, ‘Uhlu imate ukwai taku sawa etenik be ule uspun imate isov taku sawa ti.’ Atob ei-weiwei etok talngavo-ngge ve yem aim yaun be nile.” ");
INSERT INTO kbm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Be Yisu ginei, “Amol bamo ti ane amol kulkul ane gile ve geb ane kulkul givang love gibok be ginumul gile ebe nam ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Be ane amol bamo nok ginei gitangi ei be ginei, ‘Mie nupasang imate be nundu awangg ben be nan nimungg be bwayage kob nundu am be non nindeb mul ane.’ ");
INSERT INTO kbm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Be amol kulkul ane nok atob talngavo-ngge be nilgum nitangi ete ane amol bamo ginei ok. Bemem amol bamo nok wat ninei yaun vie ti nitangi ane amol kulkul ane etok ve ebe gisov ei ane yaun ane lu-ngge ok ite, ve etok ei ane kulkul roro. ");
INSERT INTO kbm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Be Yisu ginei, Dangetok be yem ok unalgum weik etok ge. Yem unalgum aim kulkul walang ok tis aplongg-aim dongke-ngge be unei, amei algum kulkul ebe mie gob gitangi amei ok roro-ngge be amb kulkul ti givin ite.” ");
INSERT INTO kbm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisu ve nireu nile Jerusalem, beti givang gito givin Samaria tis Galilaia as taku-ngge ve gile ");
INSERT INTO kbm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","love gibielk nam dabe ti be gile vunge ve eisir dubi ti nangge etok. Be eisir nok gitangi bage isgabu (10), be tepwengge inggas gimat bid nam-vu. Be gimat ete eisir inggas ok, gitangi ebe ve invang me inambweg invin amolmol sukus ok ite, beti eisir ivarkei aikawe-ngge ");
INSERT INTO kbm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","be ital gile ve Yisu be inei, “Yisu Mie Amol Bamo, Tam-viti ve amei.” ");
INSERT INTO kbm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yisu gili eisir be ginei, “Unde be unes aim-ate ru itangi bambamo ebe emb kulkul da ane ok be indi yem utlangg aim.” Beti eisir iute Yisu avo-ngge be ile, be givin ebe eisir ivang luev ge nangge ve ile ok, be bid tiate bambamo etok ges ulur gikwai utlas ulis be ande utlas ulis vie vukuri nangge ete luev sawa ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Eisir nok as amol ti gili ginei ande ei utle vie vukuri, beti ginumul gitangi Yisu gile be gikari ate gile gitak nalk gideb Yisu na ane be avo givwat Pomate are. Be amol nok nangge Samaria. ");
INSERT INTO kbm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Be Yisu ginei, “Ayeu galgum amolmol gitangi bage-isgabu (10) be utlas vie vukuri bemem wali ande subu ivang inend ");
INSERT INTO kbm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","beti as amol ti ginumul ginme be avo givwat Pomate are ite? Ve etenik amol taku ti ane ete galkik ei-ngge ginumul ginme be avo givwat Pomate are nik?” ");
INSERT INTO kbm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bekob ginei ve amol nok be ginei, “Umdil be ule, ve mie aplom givin Pomate beti gilgum be utlem vie.” ");
INSERT INTO kbm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Eisir Parisai subu itangi Yisu ile be iutani ei be inei, “Asger kob Pomate nihlin amei-mei Amol Bamo be ninme?” Be Yisu giwel eisir avos be ginei, “Eitit gitangi ebe atob tandi gen ti veik tanatpweng are tanei Amol Bamo ande ginme ok ite, ");
INSERT INTO kbm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ve gen etok atob yem ate tangg-aim nitung.” ");
INSERT INTO kbm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bekob Yisu ginei gitangi ane singamolomb gen be ginei, “Asonge mul ane atob yem tangg-aim nitung ve undi Pomate Natu Ayeu ebe meng gahlang weik amolmol ok, bemem atob undi ite. ");
INSERT INTO kbm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Be atob amolmol anongge inme be inei nitangi yem be inei, ‘Taundi, Ei ande meng gihlang nangge taku eteok me nangge ebeik.’ Bemem yem unaute eisir avos be unrek ayeu unde bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ve Pomate Natu ayeu ebe meng gahlang weik amolmol ok atob nanumul nanme weik ebe bilip geb be geb taku avut ok, be atob amolmol tepwengge nangge nalk matanos nitut nimbweg ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bemem gen mate ane eteik, Ayeu atob nanggas gen bunam nalk etenik ane be amolmol as mate etenik ane bwais be inavkir dumas nitangi ayeu nimungg bekob. ");
INSERT INTO kbm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pomate Natu ayeu ebe meng-gahlang weik amolmol ok atob nanumul nanme weik ebe warik bui gitimb Noak ane amolmol-gen ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ve givin sawa etok amolmol en be inum be emb is ate ane emb be ilgum as gen sinsin-ge ivang love givin ebe Noak gisov ane ei-vovo aplo gile ok, be bui girun love amolmol tepwengge inum bui be imat vunkunu be ma. ");
INSERT INTO kbm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Asonge sawa ebe Pomate Natu ayeu ve nanumul nanme ok, atob weik ebe warik yev gen amolmol nangga Sodom tis Gomora ok. Ve givin sawa etok amolmol nangge Sodom tis Gomora en be inum be ivgo gen nangge is ate be emb kulkul ve ivro ben be itav nam undib bambamo, be ilgum as gen sin-ge ivang ");
INSERT INTO kbm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","love sawa ebe Lot gimdil gikwai Sodom gile ok be seukie-ngge yev gisov nangge gulumb ginme be gen amolmol be tis gen walang ok love ti giengk ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dangetok be asonge Pomate Natu ayeu ok atob nakuri yem ge weik ete eisir Sodom tis Gomora ikuri-ngge ve ebe yev gen is ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Be nivin sawa etok atob amolmol ebe imbweg as nam luvwe ok gitangi ebe ve indumul insov as nam aplo inde vukuri ve invwat as wambal ok ite. Be eisir ebe ivang as um aplo ok gitangi ebe ve indumul inde as nam ve invwat as kup tis kambam ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tangg aim nitung Lot arwe ebe girau na lili be gile ve vat ok. ");
INSERT INTO kbm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Be Yisu ginei, Amol ti ginei tang gitung utle ulis bamo molge atob nindeb mul ane atob ei nimbweg ite, be amol ti ginei gimat vunu ve awangg kulkul ane, amol etok atob nimbweg matawe nindeb mul ane. ");
INSERT INTO kbm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Be Yisu ginei ayeu nanei nitangi yem, Amol ailu atob niyengk dongke, bemem Pomate atob ninggas amol ti nikwai be nune atob nimbweg em. ");
INSERT INTO kbm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Be avie ailu atob inemb kulkul ve indu ben nisov dongke invang be Pomate atob ninggas avie ti be avie ti atob nimbweg em. ");
INSERT INTO kbm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Be amol ailu atob inemb kulkul invin is ate invang as um aplo be atob Pomate ninggas amol ti nikwai ti.” ");
INSERT INTO kbm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Eisir singamolomb iute yaun etok be iutani Yisu be inei, “Gen bambamo ete ande mie gunei ok atob menihlang nangge taku sawa inend?” Be Yisu giwel eisir avos be ginei, “Asonge nindeb mul ane nivin ebe ayeu ve nanumul nanme nalk ok, atob weik mank-gilavie ebe iro is ate sut itangi taku ebe gen gimat giengk ile ok.” ");
INSERT INTO kbm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Be Yisu ginei bing-ai ti gitangi ane singamolomb gen be gibul is ve ginei ines miengk gwangne-ngge be utlas bua bwaya be ginei: ");
INSERT INTO kbm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Amol bamo ti ebe gilgum amolmol as yaun ok gibweg nam dabe ti, be amol nok ei gipelk ve Pomate ite be tang givin amolmol ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Be givin sawa etok avie tupe ti ebe nolge arwe gimat vunu gikwai ok gibweg nam dabe etok givin. Be avie nok givang gitangi amol bamo nok gile gigas ta-ngge be ginei ane gen bunam ebe amolmol ilgum gitangi ei ok binge gitangi amol bamo nok veik niute be nemb ei ru. ");
INSERT INTO kbm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bemem amol bamo nok bua ve nemb avie tupe etok ru. Be bwayage kob amol bamo nok ginei, ‘Ayeu gapelk ve Pomate be tis amolmol ok ite weik etok ge, ");
INSERT INTO kbm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bemem gisov avie tupe etenik ane tangir gitangi ayeu gigas ta-ngge beti atob ayeu namb ei ru, velob ei nivang nitangi ayeu painge-ngge love nakwes.’” ");
INSERT INTO kbm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Be Yisu ginei gitangi ane singamolomb gen be ginei, “Ande yem ute amol tiate etok ane yaun ebe ginei ok gikwai me ma? ");
INSERT INTO kbm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Be Pomate ei Amol vie molge, dangetok be ginei yem unautani Ei ve aim gen bunam ane ninggas ta-ngge atob ei nemb yem ru seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Be ayeu nanei nitangi yem, Pomate gitangi ebe atob nemb amolmol ebe iutani ei ve as gen bunam ane ok ru seukie-ngge. Bemem nivin sawa ebe Pomate Natu Ayeu ebe meng-gahlang weik amolmol ok ve nanumul nanme ok, okob ayeu tang givin ve nali amolmol ebe aplos givin Pomate ok. ");
INSERT INTO kbm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yisu ginei bing-ai ti gipil amolmol ebe indang isate be ili amolmol subu weik gen sin-ge ");
INSERT INTO kbm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ok be ginei; “Amol ailu isov lum yamar aplo ile ve ines miengk. Amol ti nangge Parisai, be eisir Parisai nok ebe indang isate be inei eisir amolmol vie ane ok. Be amol ti ebe geb kulkul takes ane ok, be eisir kulkul takes ane nok ebe amolmol Parisai ane ili eisir inei amolmol tiate ane ok. ");
INSERT INTO kbm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisai amol nok gimdil be ges ane miengk dangeteik; ‘O Pomate, ayeu tangg vevie-ngge ve mie, ve ayeu weik amol tiate ane eteik ebe geb kulkul takes ane ok be tis amolmol tiate ane subu ok ite. Ve eisir etok ebe ivalval amolmol as gen be inei yaun bingkas-kasop anongge ok, be wasi tinas givin. ");
INSERT INTO kbm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bemem ayeu, ayeu gayamar ben givin as mate ailu ailu tis Sonda walang ok, be gavwat angg gen walang ok nangge um be gab ano ti ano ti gitangi bage isgabu ve da gitangi mie.’ ");
INSERT INTO kbm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bemem amol ebe geb kulkul takes ane ok givarkei aikawe-ngge be bua ve nindank nireu gulumb, be ei gituk be ginei ane yaun gitangi Pomate dangeteik; ‘Pomate, Tam viti ve ayeu ve ayeu amol tiate ane.’ ");
INSERT INTO kbm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Beti Yisu ginei gitangi amolmol be ginei Ayeu nanei nitangi yem; Amol ete geb kulkul takes ane ok Pomate gili ei ginei ei amol vie molge gitlek Parisai amol etok. Ve amol ti ginei nindang ate be avo nivwat ate, atob Pomate nili ei weik gen sin-ge. Bemem amol ti ebe bua ve ret amolmol avos nivwat ei are ok ete atob Pomate nili ei weik amol bamo ti.” ");
INSERT INTO kbm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amolmol subu inggas natus gen itangi Yisu ile ve Yisu nitak bage niwei nunus natu natu nok be nemb avo ukwas niwei eisir. Beti eisir singamolomb ili ebe amolmol inggas natus gen itangi Yisu ile ok be inggo is. ");
INSERT INTO kbm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bemem Yisu ginei gitangi ane singamolomb gen be ginei, “Untau nunus etenok be intangi ayeu inme, be unvarkei eisir as luev avwut bwaya. Ve Pomate tang givin ve nemb amolmol dang dang etenik dabin. ");
INSERT INTO kbm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Be Yisu ginei ayeu nanei bingano-ngge nitangi yem; Amol ti ginei aplo givin Pomate ane yaun weik ete nunus natu natu aplos givin amolmol as yaun ok ite, atob Pomate nemb ei dabin ite ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bekob Juda as amol bamo ti ebe geb eisir dabin ok gitangi Yisu gile be giutani Yisu be ginei; “Gidung vie, Ayeu nalgum gen ret veik nambweg matawangg dangetok?” ");
INSERT INTO kbm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Be Yisu giwel amol nok avo be giutani ei be ginei, “Mie gutal ayeu gunei Gidung vie, be ande mie gutpweng yaun ake ete gunei nok are me ma?” Be Yisu ginei, Amol vie ti givang nalk etenik ite molge, Pomate dongke-ngge ei amol vie. ");
INSERT INTO kbm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Be mie gutpweng Pomate ane yaun ebe geb gitangi Mose ok are gikwai, ve yaun etok ginei dangeteik; ‘Nos amolmol vunu ite; Nulgum gen wasi ane ite, be nunei yaun sinsin-ge nipil amolmol ite. Nuvaina ite; Nusov tinem gabu tamem as yaun ane lu-ngge.’ ");
INSERT INTO kbm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Be amol nok giwel Yisu avo be ginei, “Givin ebe ayeu nunus ge ok be ginme love galkik as mate etenik ayeu gapasang yaun etenok vie-ngge be galgum ano gile ete gavang nik.” ");
INSERT INTO kbm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yisu giute amol nok ane yaun ebe ginei ok gikwai bekob ginei gitangi ei be ginei; “Gen dongke-ngge giengk nangge. Be gen nok dang eteik; Mie nule be nomb am wambal tepwengge be amolmol inavgo bekob nomb am gen etok ane mone nitangi amolmol ebe gen ma ve is ok. Bekob nunme be nuvang mul ve ayeu. Veik atob mie nunggas am gen vevies ge nindeb mul ane nangge Pomate ane taku.” ");
INSERT INTO kbm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bemem givin ebe amol nok giute ebe Yisu ginei yaun dangetok gitangi ei ok be aplo bunam molge, ve ei amol ti ebe tis wambal walang ok be bua ve ret nikarkari ane gen sinsin. ");
INSERT INTO kbm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yisu gili love aplo bunam molge be ginei, “Gen etok bunam molge ve amolmol ebe tis wambal walang ok ebe ve insov Pomate ane taku inde ok. ");
INSERT INTO kbm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ayeu nanei yaun ti nitangi yem bekob, Gen bamo ti gitangi ebe atob nisov gen avo natu ti nile bwayagege ok ite, bemem etok bunam molge ve amolmol ebe tis wambal bamo ok, ebe ve insov Pomate ane taku inde ok.” ");
INSERT INTO kbm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Amolmol ebe imbweg be iute Yisu ane yaun etok ok, iutani Yisu be inei, “Ginei dang etok, okob amol ret atob nimbweg vie?” ");
INSERT INTO kbm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yisu giwel eisir avos be ginei, “Amol ti gitangi ebe ve nilgum gen dangetok ok ite molge, bemem Pomate ei gitangi ve nilgum gen walang ok, be Ei ate-ngge atob nilgum gen dangetok.” ");
INSERT INTO kbm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bekob Pita ginei gitangi Yisu be ginei, “Miam singamolomb gen amei, amei avang akwai amei nam be galkik anme avang mul ve mie. Be wali asonge amei an-gas gen ret nindeb mul ane?” ");
INSERT INTO kbm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Be Yisu ginei gitangi eisir be ginei; “Bingano, ayeu nanei nitangi yem; Amol ti ginei givang gikwai arwe-nggen tis natu-nggen, me male-nggen, me ane bambamo-nggen ve Pomate ane kulkul ane, ");
INSERT INTO kbm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","atob amol etok ninggas gen vevies walang ano molge nindeb mul ane, be atob ei nimbweg vie molge nangge Pomate ane taku.” ");
INSERT INTO kbm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisu gigas ane singamolomb gen 12 ebok ile aikawe ikwai amolmol bekob ginei gitangi eisir be ginei; “Unaute kob, Atob eitit tanreu tande Jerusalem ok okob atob yaun bambamo ebe warik Pomate ane amolmol kulkul ane ebe inei Pomate avo ok iro gipil Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob ano nile. ");
INSERT INTO kbm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ve atob amolmol inemb ayeu nitangi amolmol gitip ane be atob eisir gitip ane inalgum gen ungglus-ungglus nitangi ayeu be inluk nireu ayeu be inmalk ve ayeu. ");
INSERT INTO kbm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Be atob inrau ayeu bekob ines ayeu vunu. Bemem as mate ebe ve aitol ane ok okob atob ayeu matawangg be namdil vukuri nangge taku gimat ane.” ");
INSERT INTO kbm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Eisir singamolomb iute yaun bambamo ete Yisu ginei ok bemem itpweng are ite, ve yaun etok ane dabe givwaivun ate gitangi eisir. Be tas gisgil gen ete Yisu ginei yaun gipil ok. ");
INSERT INTO kbm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisu tis ane singamolomb gen ivang love ile imbloblo nam dabe ti are Jeriko, be amol matano bop ti gibweg luev bane ve giutau-tani gen nangge amolmol ebe iriv be ira ivang luev ok. ");
INSERT INTO kbm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Be givin ebe matano bop nok giute ebe amolmol ilgum ve indi Yisu be ilgum be kakie bambamo ok, beti ei giutani be ginei “Gen ret dangeteok?” ");
INSERT INTO kbm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Beti amolmol inei lavo gitangi ei be inei, “Yisu Nasaret ane ebe Pomate gihlin be ginme ve nemb amolmol ru ok ete ginme nik.” ");
INSERT INTO kbm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Beti amol matano bop nok gital avo bamo be ginei, “Yisu, Dawit ane natu mie, Tam viti ve ayeu!” ");
INSERT INTO kbm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Be amolmol ebe ande imungg ile ok inggo amol nok be inei, “Tuminnge.” Bemem amol nok gital yaun avo bamo-ngge vukuri be ginei, “Dawit natu mie, tam viti ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Beti Yisu givarkei va ta be ginei gitangi amolmol ve in-gas amol matano bop nok nitangi ei nile. Amolmol inggas amol matano bop nok be ivang ile love ile imbloblo Yisu be Yisu giutani ei be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mie tam givin gunei ayeu nalgum gen ret nitangi mie?” Be amol nok giwel Yisu avo be ginei, “Amol Bamo, ayeu tang givin ve nali taku vukuri.” ");
INSERT INTO kbm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Bekob Yisu ginei gitangi ei be ginei, “Mie aplom givin Pomate beti atob nilgum mie matanom be ponge. Dangetok be matanom ponge be nuli taku!” ");
INSERT INTO kbm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Be seukie-ngge amol nok matano ponge be gili gen vukuri, be ei givang mul ve Yisu be avo givwat Pomate are. Be amolmol ebe ili gen etok givin ok avos givwat Pomate are givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisu gibielk Jeriko gikwai be veve mang-mangi nireu nile ebe Jerusalem ok. ");
INSERT INTO kbm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Be amolmol ebe emb kulkul takes ane ok as amol bamo ti ebe geb eisir dabin ok, are Sakai ei gibweg ete Jeriko ok. Be ei amol ti ebe tis wambal walang ok. ");
INSERT INTO kbm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ei gilgum ve nili Yisu nisov matano roro-ngge bemem gilgum be gitangi ite ve amolmol anongge molge ivarkei isil Yisu. Be givin ve Sakai nok ei amol tupe molge be gitangi ebe atob na nipar-kar amolmol be nili Yisu ok ite. ");
INSERT INTO kbm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Beti ei gituvki gimungg gile be gireu ei ti ebe givarkei luev bane ok ve nili Yisu, ve atob Yisu nivang nitwep ei eteok ane lu ve nile. ");
INSERT INTO kbm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yisu givang gile love gitwep ei ete Sakai gireu gile gibweg ok ane lu, be gidank be gili Sakai ebe gibweg ei-nggoto ok, be ginei gitangi ei be ginei; “Sakai, usov unme utak seukie-ngge, ve as mate etenik atob ayeu nambweg navin mie nangge miam nam!” ");
INSERT INTO kbm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakai gisov mengg gitak nalk seukie-ngge be gigas Yisu tis ta vevie-ngge gile ebe ane nam ok. ");
INSERT INTO kbm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amolmol tepwengge ili be tas vavis anongge be inei, “Ret ginei beti Yisu gile ve nimbweg nivin amol tiate ane etok nangge ane nam?” ");
INSERT INTO kbm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bekob Sakai gimdil be ginei gitangi Yisu be ginei; “Amol Bamo, as mate etenik atob ayeu nambwas angg wambal be namb tavlu nitangi amolmol ebe gen ma ve is ok. Be ginei ayeu gayo amol ti be gavwat ei ane gen ti gikwai, okob atob ayeu namb gen aivat nitangi ei niwel ei ane gen dongke ete ayeu gavwat gimungg ok.” ");
INSERT INTO kbm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Be Yisu ginei yaun gipil Sakai nok gitangi amolmol be ginei; “Galkik as mate etenik ge Pomate givang givin nam etenik. Be amol etenik ei Ablaham ane vaku ti. ");
INSERT INTO kbm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Be Pomate Natu ayeu ebe meng gahlang weik amolmol ok ganme ve namb amolmol ebe ivang aikawe ikwai Pomate ane luev ok ru weik ete ande galgum gitangi Sakai nik!” ");
INSERT INTO kbm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Be Yisu ginei bing-ai ti gitangi amolmol ebe iute ei ane yaun ok ve gisov ei ande gile gibloblo Jerusalem be amolmol inei bwat atob etenik ge Pomate nemb ei ve eisir as amol bamo. ");
INSERT INTO kbm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Beti ei ta gitung ve ninei lavo nitangi amolmol bemem ginei gipil bing-ai ge dangeteik; “Amol ti ve nivang nam dabe ti ve amol bamo ebe geb amolmol dabin ok nemb ei ve nemb amolmol dabin. ");
INSERT INTO kbm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Be givin ebe amol nok ve nimdil ane ok be ei gital ane amolmol kulkul ane be itangi ei ile, be ei geb mone gol dongke-dongke gitangi ane amolmol kulkul ane 10 etok gitangi-ngge. Be mone ete ei geb gitangi ane amolmol kulkul ane ok, gitangi ebe mone aiweng aitol ane ok. Be amol nok ginei, ‘Yem unemb kulkul nipil mone etenik be unawkwen nivin tis ete ayeu ve navang ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bemem amol nok ane bambamo-nggen nangge ei ate ane nam eisir bwais ve ret ei nemb amolmol dabin. Beti eisir emb yaun givang mul gile ve amolanmol ebe atob amol nok nimbielk ve eisir ok be inei, ‘Amei bwaingg amei ve ret amol etenok nemb eitit dabin.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bemem bwayage kob emb amol nok ve nemb eisir dabin. Bekob amol nok ginumul gile ane nam vukuri be ginei be amolmol ital ei ane amolmol kulkul ane ebe warik geb mone gol ano dongke-dongke gitangi eisir ok be itangi ei ile be ginei, ‘Ayeu veve nali mone ebe warik gab gitangi yem be ganei unalgum kulkul nipil ok ane ano.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beti eisir kulkul ane nok as amol ti gimungg gitangi ane amol bamo gile be ginei, ‘Mie gob mone gol dongke-ngge gitangi ayeu, be ayeu gab kulkul gipil mone nok be gagas mone gol nok bage isgabu meng givin.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Be ei ane amol bamo ginei gitangi ei, ‘Miam kulkul vie. Be mie amol kulkul ane vie ti ebe gob gen siti-ngge dabin vie molge ok. Dangetok be atob ayeu namb mie ve amol bamo ti be nomb nam bage isgabu dabin.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bekob amol luvwe ti ane gitangi ane amol bamo gile be ginei, ‘Amol bamo, ayeu gab kulkul gipil mone gol dongke ebe mie gob gitangi ayeu ok be gagas mone gol nok gitangi bage tavlu meng givin.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Be ei ane amol bamo ginei gitangi ei, ‘Atob ayeu namb mie ve nomb nam dabe bage tavlu dabin.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Be amol ti vukuri gile be ginei, ‘Amol bamo, ayeu gatak miam mone ebe gob gitangi ayeu ok gisov kambam den natu ti be am gen nok ete giengk ik. ");
INSERT INTO kbm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ve ayeu gapelk ve mie, ve mie amol gwangne, be gen ebe amolmol subu ivro ok, bemem atob mie nunggas gen etok ane ano.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Be amol bamo nok ta vavis vunungge be ginei gitangi ei, ‘Mie amol kulkul ane tiate ti, be mie ate ande gunei am wayam vusa gikwai. Ginei mie gutpweng are gunei ayeu amol eteik ebe gavwat gen ebe gab ane kulkul ite ok ane ano, ");
INSERT INTO kbm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","okob vie ve mie nomb kulkul nipil awangg mone etenik be nuvkwen awangg gen be bamo yapin. Veik nivin ebe ayeu ve nanumul nanme ok okob navwat angg gen tepwengge nikwai. Bemem gimdom be mie gulgum dangetok ite?’ ");
INSERT INTO kbm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bekob amol bamo nok ginei gitangi amolmol ebe ivarkei etok ok be ginei, ‘Unemb mone gol dongke etok ikwai amol etenok be unemb itangi amol ebe gigas mone gol gitangi bage isgabu ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bemem amolmol inei gitangi amol bamo nok be inei, ‘Ma yapin! Amol etenok ande gigas mone gol gitangi bage isgabu gikwai.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Be amol bamo nok ginei gitangi eisir be ginei ayeu nanei nitangi yem, ‘Amol ti ginei geb ane gen dabin na gili, atob ei ninggas gen subu nile nivin. Bemem amol ti ginei geb ane gen dabin vevie ite, atob inemb gen siti ebe giengk givin ei ate ok nikwai. ");
INSERT INTO kbm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Be ayeu nanei nitangi yem, Unde be un-gas amolmol ebe walirik inei bwais ve ayeu namb yem dabin ok unme be unes eisir vunkunu nangge ayeu nangg.’” ");
INSERT INTO kbm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisu ginei yaun etok be ma gikwai kob tis ane singamolomb gen imdil ve inreu inde Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eisir ivang painge love ile imbloblo Betepage be tis Betania as taku nangge matendubi ebe ei oliv anongge givarkei ok, beti Yisu gihlin ane singamolomb gen ailu ve inmungg inde inahlang nam dabe ailu etok. ");
INSERT INTO kbm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Be ginei gitangi sulu be ginei, “Yemlu unmungg unde unahlang nam ok, be nam ete givarkei mate ge nik atob gabu undi bwelk dongki ti amolmol iro wal gile be givarkei. Be bwelk nok amol ti gibweg giwei ite molge, be gabu unahlang wal nikwai be unatwem unme etenik. ");
INSERT INTO kbm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Be ginei amol ti ve niutani yemlu be ninei, ‘Yemlu ve unamdom etenik?’ Okob gabu unei nitangi amol etok be unei, ‘Amei-mei Amol Bamo ginei bwelk etenik ane kulkul giengk.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Beti eisir singamolomb ailu nok imdil be imungg ile, gabu ivang love imbielk nam be gabu ili gen walang ok gitangi ebe galkik Yisu ginei gitangi sulu yapin ok. ");
INSERT INTO kbm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Be givin ebe gabu ihlang wal gikwai bwelk dongki etok ivarkei ok, be bwelk nok tivie giutani sulu be ginei, ‘Yemlu ve unamdom beti uhlang wal gikwai bwelk etenok?’ ");
INSERT INTO kbm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Be sulu iwel amol nok avo be inei, ‘Amei-mei Amol Bamo ginei bwelk etenik tis kulkul.’ ");
INSERT INTO kbm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Beti amol nok na vier ve sulu be itwem bwelk nok be itangi Yisu ile. Be gabu iwaulu as kup be ival gile bwelk nok dume tulkwe bekob Yisu gipil gile gibweg giwei. ");
INSERT INTO kbm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yisu gibweg giwei bwelk dongki nok be givang ve gile be amolmol anongge iwaulu as kup be ival gile luev gili be Yisu tis bwelk nok ivang iwei dobo ve ile. ");
INSERT INTO kbm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yisu ande gile gibloblo Jerusalem gikwai be gisov nangge matendubi ebe ei oliv anongge givarkei ok ve gile be ei ate ane amolmol gen imdil be avos givwat Pomate are ve gen bambamo ebe eisir ili ok ane. ");
INSERT INTO kbm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Be inei, “Eitit avond nivwat Pomate are, ve Ei gihlin Amol ebe ve nemb eitit dabin ok be ginme tis Tame ane gwangne. Be Pomate ande ta vie-ngge ve eitit, dangetok be eitit avond nivwat Ei are niengk ei-nggoto ge.” ");
INSERT INTO kbm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eisir Parisai iute ebe amolmol avos bambamo-ngge ve avos givwat Pomate are ok, beti ile inei gitangi Yisu be inei, “Gidung, Mie unei yaun itangi am amolmol gen veik eisir tumingge siti ma?” ");
INSERT INTO kbm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Be Yisu giwel eisir Parisai avos be ginei, ‘Ayeu nanei roro-ngge nitangi yem, Ginei eisir etenik tumingge inambweg, atob vat bambamo ete iyengk nik intal yaun vusa!’ ");
INSERT INTO kbm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisu givang love gile gibloblo Jerusalem be gili taku nok love giteng anongge ");
INSERT INTO kbm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","be ginei, “Galkik as mate etenik ginei yem unatpweng luev ebe ve unambweg matawangg aim ok are, atob vie molge. Bemem yem ande bwaingg aim, dangetok be asonge yem un-gas gen bunam bamo molge. ");
INSERT INTO kbm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Be asonge amolmol valir ane inme be vepias indek insov yem aim nam luvwe be atob insum ");
INSERT INTO kbm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","yem be ines yem tis natungg aimgen vunkunu love ma. Be gen ti wat nivarkei lavo vukuri dangete galkik givarkei nik ite, atob inyaing tepwengge nikwai. Ve Pomate ta givin ve ginei nemb yem dabin, bemem yem bwaingg-aim be uvkir dumangg-aim gitangi Ei.” ");
INSERT INTO kbm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yisu gisov lum yamar aplo gile be gitin amolmol ebe ile ve ivgo gen be emb gen giwel ate nangge lum yamar aplo ok be ile ihlang ikwai. ");
INSERT INTO kbm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Bekob ginei gitangi eisir be ginei, “Yaun ebe warik Pomate ane amolmol kulkul ane iro ok ginei dang eteik; ‘Pomate ginei awangg nam atob tantal tanei amolmol tepwengge as nam mateu ane.’ Bemem yem ulgum love ande weik ebe amolmol vaina ane as taku ok.” ");
INSERT INTO kbm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Be givin sawa etok Yisu gisov lum yamar aplo gile tis as mate walang ok be ginei mateu gitangi amolmol. Be gidung subu ebe emb Mose ane yaun dabin ok be tis eisir bambamo subu ebe emb kulkul da ane ok irek luev ve ines Yisu vunu, ");
INSERT INTO kbm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bemem ilgum be gitangi ite. Ve as mate walang ok amolmol iro isate sut itangi Yisu ile painge-ngge ve inaute mateu ebe Ei ginei ginei ok, be sawa ti giengk ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","As mate ti Yisu gisov lum yamar aplo gile be ginei mateu ve amolmol givang. Be bambamo ebe emb kulkul da ane ok tis gidung ebe emb Mose ane yaun dabin ok be tis Juda as awaga subu, eisir iro is ate sut bekob ");
INSERT INTO kbm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ete ivang itangi Yisu ile be inei; “Mie unei lavo itangi amei kob. Wali mie gulgum gen bambamo etenik ve amol ret ane gwangne? Be amol ret geb ane gwangne gitangi mie beti nolik mie gubielk Jerusalem be gulgum ve guvinvin amolmol tepwengge ile ihlang ikwai lum yamar aplo?” ");
INSERT INTO kbm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Be Yisu giwel eisir avos be ginei atob ayeu nautani yem ve yaun ti ane nimungg bekob; “Ande ma, be yem unei yaun etek lavo itangi ayeu kob. ");
INSERT INTO kbm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wali Jon ebe ges bui sanggu gipil amolmol ok gigas gwangne nangge inend beti gilgum kulkul etok? Nangge amolmol me nangge Pomate ane?” ");
INSERT INTO kbm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Be eisir ebe iutani Yisu ok inei ve is ate be inei, “Atob eitit tanei ret? Ginei eitit tanei Pomate geb ane gwangne gitangi Jon, ok-ti atob ei ninei; ‘Be nam nambed be yem aplongg aim givin Jon ite?’ ");
INSERT INTO kbm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bemem ginei eitit tanei Jon gigas ane gwangne nangge amolmol, atob amolmol bambamo etenik ines eitit ve vat. Ve eisir itpweng are gikwai inei Jon ei Pomate ane amol kulkul ane ti ebe ginei Pomate avo ok.” ");
INSERT INTO kbm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Beti eisir iwel Yisu avo be inei, “Amei tangg amei gisgil.” ");
INSERT INTO kbm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Be Yisu ginei gitangi eisir, “Dangetok be ayeu ok atob nanei Amol ebe geb ane gwangne gitangi ayeu be galgum gen bambamo etok ok binge nitangi yem ite weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bekob Yisu ginei bingai ti gitangi amolmol be ginei; “Amol ti givro ane wain um ti. Bekob amol nok tis ane amolmol kulkul ane kakie gisov dongke be inei atob um nok ane tivie ninggas kulkul etok ane ano tavlu nivin. Beti amol nok geb ane um wain nok gisov amolmol ebe ve inemb ei ane gen dabin ok bais ve inemb dabin, be ei ate gimdil be gile ve gibweg nam dabe ti nangge taku undib ge ti. ");
INSERT INTO kbm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ei gibweg etok love aiweng ebe ve inpis wain ano ok meng gihlang, kob ei gihlin ane amol kulkul ane ti be gile ve nivwat ane amol bamo nok ane mone nangge eisir ebe ipis wain nok ane ano ok. Bemem eisir ebe emb wain dabin ok es amol nok bekob ihlin be givang bage apo-ngge ve ginumul gile. ");
INSERT INTO kbm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Beti um tivie gihlin ane amol kulkul ane ti vukuri be gile. Bemem eisir ebe emb wain dabin ok es amol nok be ilgum ei tiate-tiate bekob ihlin ei be givang sin-ge ve ginumul gile weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Be um tivie gihlin ane amol ti vukuri gile bemem eisir ebe emb um wain dabin ok es amol nok weik etok ge be ikari ei gihlang gikwai um aplo. ");
INSERT INTO kbm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Beti um tivie gibweg be tang gitung, atob ayeu nalgum eisir etenik nam nambed? Bekob ginei, ‘Ayeu nalek nahlin natungg dongke ebe tang givin ei gitlek ok be nile, veik atob eisir indi be inei etok ayeu natungg be atob inpasang ei vie-ngge niwei bais taptape-ngge.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bemem givin ebe amolmol ebe emb um wain dabin ok ili ebe um nok tivie natu ebe gitangi eisir gile ok, be inei ve is ate be inei, ‘Um etenik ane tivie natu ete ginme nik be eitit tanes ei vunu nikwai. Veik tan-gas um wain etenik ve it.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Beti eisir emb amol nok ta be ikari gile gihlang gikwai um aplo bekob ile es ei vunu. Be Yisu ginei, Ginei um nok ane tivie nimbielk, okob atob nilgum ret nitangi amolmol ete emb ei ane um dabin ok? ");
INSERT INTO kbm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Atob ei nes eisir ete emb ei ane um dabin ok vunkunu be nemb kulkul etok nisov amolmol vaku bais ve inemb dabin. Bemem amolmol iute yaun etok be inei, “Ma yapin! Etok gitangi ite.” ");
INSERT INTO kbm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yisu na giro eisir ta bekob ginei, “Yem usam yaun ebe warik Pomate ane amolmol kulkul ane iro ok be utpweng are gikwai me ma? Yaun nok ginei dangeteik; ‘Twelk ebe warik amolmol gimungg ane itav as nam giwei ok, ande amolmol bwais gikwai. Bemem galkik as mate etenik ande twelk nok meng gihlang weik twelk ebe givarkei wavin tiate na ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Amol ti ginei gibieg gisov twelk etok atob ei ninggas tiate, bemem ginei Pomate nes amol ti, amol etok atob nile suksukus weik ebe seksek ok.” ");
INSERT INTO kbm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gidung ebe emb Mose ane yaun dabin ok be tis bambamo ebe emb kulkul da ane ok, itpweng are inei Yisu ginei bing-ai etok gipil eisir. Beti eisir tas vavis be ilgum ve inemb Yisu ta tis sawa etok ge bemem ipelk ve amolmol. ");
INSERT INTO kbm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Beti eisir tas gitung ve inei bwayage be indi sawa vie-ngge ti okob. Be eisir nok ivgo amolmol subu be inei yaun gisov eisir ve inde be inaute Yisu ane yaun ebe ginei-ginei ok be ginei Yisu ginei yaun ti gitlek okob eisir inemb ei ta be in-gas ei intangi amol bamo ebe geb eisir dabin ok inde. ");
INSERT INTO kbm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Beti eisir nok ile be ilgum weik ebe eisir amolmol yaun ano ane ok be iutani Yisu be inei; “Gidung, Amei atpweng are gikwai anei miam yaun ebe gunei be gubul amolmol nangge lum mateu ane aplo ok, yaun etok ano molge. Be mie tam gitung amolmol ebe tis ares ok, me eisir ebe tis ares ite ok bamo molge ite. Mie gubul amolmol ve yaun ano ebe Pomate tang gitung ve atob nilgum nitangi amolmol ok roro-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dangetok be Mie unei yaun etenik lavo itangi amei kob, ve gitangi ebe atob amei anemb mone takes ane nitangi Rom as amol bamo ebe geb amolmol dabin ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bemem Yisu ande gitpweng gen ebe eisir tas gitung giengk aplos ge ok are gikwai, beti ginei gitangi eisir be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Unes mone nok ano ti ru be ayeu nali kob, nanei amol ret dalgo be tis are ete giengk mone nik?” ");
INSERT INTO kbm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Be eisir iwel Yisu avo be inei, “Eteik Rom as amol bamo ebe geb amolmol dabin ok are be tis dalgo ete giengk mone eteik.” Be Yisu ginei, “Dangetok be unemb Rom as amol bamo ane gen ninumul nitangi ei ate nile, be unemb Pomate ane gen nitangi Pomate nile!” ");
INSERT INTO kbm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eisir nok tas gitung yapin ve inei inautani Yisu ve yaun takes nok ane veik ginei Yisu ninei yaun ti nitlek okob eisir atob inemb ei ta, bemem ilgum be ili ma. Be ikuri vunu-ngge ve Yisu ane yaun ebe ginei ok ane be tumi-ngge ivarkei. ");
INSERT INTO kbm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukai subu ivang itangi Yisu ile, (Eisir Sadukai nok ebe inei amolmol ebe imat vunu ok asonge matawas be inamdil vukuri ite ok) be iutani Yisu be inei, ");
INSERT INTO kbm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mose giro yaun eteik be geb gitangi amei; ‘Ve amol ti ginei gimat vunu gikwai arwe be sulu natus ma, okob amol nok male atob nemb avie tupe nok veik nes nunus vier niwel amol ebe gimat vunu ok.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Dangetok be amol ti tis male-nggen imbweg, eisir nok gitangi bage tavlu be ano ailu (7). Be amol mate ane geb avie ti bemem kob gimat vunu be gabu natus ma. ");
INSERT INTO kbm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bekob amol ebe gile gisa amol mate ane ok geb avie tupe nok, bemem bwayage kob ei gimat vunu weik etok ge be gabu natus ma. ");
INSERT INTO kbm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bekob amol luvwe ti ane geb avie nok vukuri, bemem gimat dongke nok ge gipil sotol kawe be male etok tepwengge be imat vunkunu be ma. ");
INSERT INTO kbm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Be bwayage kob avie etok ok gimat vunu givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Be eisir Sadukai inei gitangi Yisu be inei, “Asonge nindeb mul ane nivin ebe amolmol ebe imat vunkunu ok ve matawas be inamdil vukuri ok, okob atob eisir bage tavlu be ano ailu etok as amol ret ninggas avie etok ve arwe? Ve sotol kawe be male etok tepwengge emb avie dongke etok ve arwas.” ");
INSERT INTO kbm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Be Yisu giwel Sadukai avos be ginei; “Galkik sawa etenik ge ete avie be amol emb is ate. ");
INSERT INTO kbm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bemem asonge nindeb mul ane nivin ebe amolmol ebe imat vunkunu ok ve inamdil vukuri nangge taku gimat ane ok, okob avie be amol ebe aplos givin Pomate ok wat inemb is ate vukuri dangete galkik ilgum-ilgum nik ite. ");
INSERT INTO kbm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Atob eisir meinahlang weik ebe Pomate ane angela kulkul ane ok be wat inmat vunu vukuri ite, ve Pomate ei ate ges eisir itin vukuri nangge taku gimat ane be gili eisir weik ebe natu-nggen ok. ");
INSERT INTO kbm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bemem luev ebe ve tanamdil vukuri nangge taku gimat ane ok ete Mose ginei lavo ve eitit gikwai, ve Mose ginei yaun gipil yev ebe meng gihlang sin-gege nangge sangas be gen taku tis ei natunatu ite ok be ginei; ‘Amol Bamo ei Ablaham gabu Isak be Jakob as Pomate. Be Ei gibweg ebe warik be atob nimbweg dangetok.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Be yaun etok ane dabe dangeteik, Pomate gili eisir weik ebe imbweg matawas ok. Be Pomate Ei amolmol ebe asonge inmat vunu vukuri ok as Pomate ite, Ei amolmol ebe asonge inambweg matawas nemb ta-ngge nindeb mul ane ok as Pomate.” ");
INSERT INTO kbm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Be gidung ebe emb Mose ane yaun dabin ok inei, “Gidung, Mie gunei am yaun etenok avo vie molge.” ");
INSERT INTO kbm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Be eisir ipelk be iutani Yisu ve yaun dangetok ane vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Be givin sawa etok ge Yisu giutani amolmol be ginei; “Namnambed be yem utal Amol Bamo ebe geb amolmol tepwengge ru ok unei Dawit Natu?” ");
INSERT INTO kbm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ve Dawit ei ate giro yaun etenik gisov kapia ti are Sam (Pesalem), be ginei; ‘Pomate ginei gitangi Amol ebe ve nemb amolmol tepwengge dabin ok be ginei, Numbweg numbloblo Ayeu ge ");
INSERT INTO kbm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","love amolmol valir ane tepwengge inatwep miam gwangne ane lu inde okob.’ ");
INSERT INTO kbm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Be Yisu ginei, Ginei Dawit nital amol nok ninei Pomate, okob atob tantal amol nok tanei Dawit Natu ge ite, bemem Dawit ane Amol Bamo ei givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amolmol tepwengge imbweg ve iute Yisu ane yaun ebe ginei ginei ok. Bekob Yisu ginei gitangi ane singamolomb gen be ginei; ");
INSERT INTO kbm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Eisir ebe emb Mose ane yaun dabin ok as luev subu tiate molge, dangetok be nangg-aim undi aim ate-ngge. Eisir iro kambam undib bambamo be ilauk ivang nam luvwe luvwe be tas givin ve amolmol inde vunge ve eisir be avos nivwat eisir ares. Be tas givin ve inambweg nindeb taku ebe ve amolmol tepwengge matanos nitut nimbweg eisir ok. ");
INSERT INTO kbm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eisir ilgum ve ivalval avie gaptol ebe nolge arwas-gen imat ikwai is ok as nam be ivai-vaina as gen. Bekob es-miengk undib molge gitangi Pomate. Bemem asonge nindeb mul ane atob eisir in-gas vavavne bamo molge.” ");
INSERT INTO kbm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisu na giengk amolmol ebe ilek be inme ve itak as da gisov bukuel mone ane nangge lum yamar aplo ok. ");
INSERT INTO kbm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Be gili avie tupe ti ebe nolge arwe gimat vunu gikwai ok, be avie nok gen walang ok ma ve ane. Be ei ane mone muele natu ailu-ngge giengk ebe ve nivgo ben be nen ok, bemem ei geb ane mone nok tepwengge ve da be gile bage vier gisov ting da ane gile. ");
INSERT INTO kbm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yisu gili be ginei, “Ayeu nanei nitangi yem, Pomate gili avie tupe etenik ane mone muele natu ailu ete geb ve da ok, vie molge gitlek amolmol subu as. ");
INSERT INTO kbm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ve gisov eisir subu ebe tis mone bamo ok, eisir emb as gen tavlu gile ve da bemem emb as gen tavlu ta. Bemem avie tupe etenik ei gen walang ok ma ve ane be ei ane mone muele natu ailu etok ge giengk bemem gitak ane gen tepwengge gisov ting da ane gile be ti giengk ite.” ");
INSERT INTO kbm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eisir singamolomb subu kakie gipil lum yamar be inei, “Lum yamar bamo etenik tis ane gen walang ok be tis gen ebe amolmol emb ve da gitangi Pomate ok vevies ge.” Be Yisu ginei gitangi eisir; ");
INSERT INTO kbm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gen bambamo ete ande uli gikwai nik, asonge nindeb mul ane atob ti vie be nivarkei lavo dang etenik ite tepwengge atob tiate nikwai.” ");
INSERT INTO kbm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Beti eisir singamolomb iutani Yisu be inei, “Gidung, Gen ete ve niyaing lum yamar bamo etok ok atob menihlang nivin sawa inend? Be gen ret ebe atob amei andi nimungg veik anatpweng are anei sawa etok atob gen bunam etok menihlang ok?” ");
INSERT INTO kbm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Be Yisu giwel eisir avos be ginei, “Unemb aim ate dabin vie-ngge velob amolmol subu inme be inyo-inyo aim. Ve amolmol anongge atob inme be intal Ayeu arengg nipil eisir ate be inei, ‘Ayeu amol eteik ebe gab amolmol ru ok.’ Be atob eisir inei gibloblo ve gen dangetok menihlang. Bemem yem unaute eisir as yaun be unsov ane lu bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Be ginei yem unaute valir ebe meng gihlang nangge taku undib undib ok me ebe giengk gibloblo yem aim taku ok, okob unkur-kuri bwaya. Ve gen dang dangetok atob menihlang nimungg, bemem gulumb tis nalk ane aiweng giengk nangge. ");
INSERT INTO kbm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Be Yisu ginei; Nangge taku walang ok atob amolmol nam dabe ti ane inamdil be ines valir nitangi nam dabe ti, be amol bamo (king) ti ane amolmol gen atob inamdil be ines valir nitangi amol bamo (king) ti ane amolmol gen. ");
INSERT INTO kbm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Be atob gikuri nes tiate tiate molge be atob amolmol marav-nes is nemb taku avwut. Be gimat walang ano atob nituvki nemb taku walang ok avwut, be atob yem undi tuweng vaku vaku subu menihlang nangge gulumb. ");
INSERT INTO kbm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bemem gen bambamo etok atob menihlang ite nangge, be atob amolmol inemb yem ta be inalgum gen ungglus ungglus nitangi yem be in-gas yem unsov as lum mateu ane aplo unde ve unei aim yaun lavo nimungg bekob. Be atob eisir intak yem unvarkei amolmol bambamo nas be inalgum yem aim yaun bekob intak aim nisov kapual-lu ve awangg kulkul ane. ");
INSERT INTO kbm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Be sawa etok ge atob yem unei Pomate ane yaun (mateu) nitangi amolmol walang ok be inaute. ");
INSERT INTO kbm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dangetok be nivin ebe eisir veve inautani yem ok, okob aplongg-aim bunam ve ebe atob unwel eisir as yaun be unei ret ok bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ve sawa ete eisir veve inautani yem ok, atob ayeu nanei yaun ebe tis ane gwangne ok nitangi yem be unei. Be amolmol valir ane gitangi ebe ve ines yem, me inwel yaun ete yem unei ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Be asonge nivin sawa etok atob yem ate aim bambamo-nggen inemb yem nitangi amolmol valir ane be atob amolmol valir ane nok ines yem aim amolmol subu vunkunu. ");
INSERT INTO kbm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Be amolmol walang ok atob bwais ve yem ve awangg kulkul ane. ");
INSERT INTO kbm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bemem yem utlangg-aim ulis ane gen walang ok atob niengk vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bemem unro aim ate ta painge love gen bunam etok ninme be nile nikwai kob, veik atob yem unambweg vie-ngge nindeb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Be ginei yem uli amolmol valir ane ebe inme be ivarkei ile idbul Jerusalem ok, okob atob yem unatpweng are ve sawa etok atob gen bambamo ebe givarkei Jerusalem nam luvwe ok atob tepwengge tiate love ma. ");
INSERT INTO kbm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Be atob sawa etok ge amolmol ebe imbweg Juda as taku ok atob inpelk inreu matendubi inde inambweg. Be amolmol ebe imbweg Jerusalem ok atob inpelk inde inambweg taku sawa ti, be eisir ebe imbweg imbloblo Jerusalem ok atob inde inahlang Jerusalem vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ve as mate etok ebe Pomate ve nemb vavavne nitangi amolmol ebe ivkir dumas gitangi ei ok. Be yaun ebe warik Pomate ane amolmol kulkul ane inei ok atob ano nile nivin sawa etok. ");
INSERT INTO kbm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Be nivin sawa etok atob avie gaptol ebe tis tas ok be tis avie gaptol ebe emb rur ve natus gen ge nangge ok, atob in-gas vavavne bamo molge. Gen bunam dang dang etok atob menihlang nangge nalk, ve Pomate ve nilgum ane ta vavis ano nile nipil amolmol ebe ivkir dumas gitangi ei ok. ");
INSERT INTO kbm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Be atob amolmol valir ane ines amolmol subu vunkunu be in-gas subu inde be intak is nisov kapual-lu nangge nam dabe walang ok. Be amolmol gitip ane atob inambweg Jerusalem dangetok painge love Pomate-ngge ninei kob eisir inkwai. ");
INSERT INTO kbm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aiweng tis as matano atob niro ite, be viteuk-awe atob bing-bleng nangge gulumb. Be amolmol tepwengge atob inpelk be inteng ve gielk ebe gible tiate molge be givil-kilir gipil alus ok. ");
INSERT INTO kbm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Amolmol anongge atob inpelk ve gen bunam bambamo etok ane be atob matanos tumtumi. Be gen walang ebe giengk gulumb ok, weik viteuk-awe, be aiweng tis as matano atob gigikias sinsin. ");
INSERT INTO kbm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Be bwayage kob atob Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob nasov umbim aplo be nanumul nanme tis Pomate ane gwangne tis ane bogbogo. ");
INSERT INTO kbm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Be nivin sawa ebe gen bambamo etok ve menihlang ok, yem unamdil be unvarkei tis tangg-aim vevie-ngge ge ve gibloblo ve Pomate nemb ane amolmol gen dabin. ");
INSERT INTO kbm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Be Yisu ginei bing-ai ti gitangi amolmol be ginei; “Yem utpweng gen ebe ve menihlang ok arkares gipil ei-yambla be tis gen subu subu givin. ");
INSERT INTO kbm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ve givin ebe yem uli ei-yambla be tis ei subu ningge gireu vukuri ok, be utpweng are seukie-ngge be unei kasopge be atob asausa nimbielk. ");
INSERT INTO kbm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Dangetok be ginei yem undi gen walang etok ebe ande meng gihlang ok, okob atob unatpweng are ve gibloblo ve Pomate nemb ane amolmol gen dabin. ");
INSERT INTO kbm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Be Ayeu nanei nitangi yem; Amolmol subu ete ande imbweg matawas imbweg nik atob inmat ite love indi gen bambamo etok ebe meng gihlang ok okob. ");
INSERT INTO kbm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gulumb tis nalk asonge ma nikwai bemem Pomate ane yaun (mateu) atob niengk be niengk dangetok. ");
INSERT INTO kbm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Dangetok be yem unemb aim ate dabin vie-ngge velob gen nalk etenik ane nemb yem nangg-aim lili be tangg-aim nitung gen ebe ve unen be unum ok nitlek molge ite, velob Pomate nimbielk ve yem seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pomate atob nikuri amolmol tepwengge nangge nalk weik ebe wal mate ges bwelk ok. ");
INSERT INTO kbm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dangetok be unambweg matanongg aim sang-sangas be unes miengk nitangi Pomate veik niro yem ta ve gen bunam bambamo ete ve menihlang ok ane. Be atob yem unvarkei nindeb Pomate Natu Ayeu ebe meng gahlang weik amolmol ok nangg.” ");
INSERT INTO kbm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Givin ebe Yisu gireu gile Jerusalem ok, be as mate walang ok ei gile ve ginei mateu gitangi amolmol nangge lum yamar aplo, bemem givin gibok ei gile ve ges miengk givang matendubi ebe ei-oliv anongge givarkei ok. ");
INSERT INTO kbm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Be givin tis-tumi walang ok amolmol iro is ate sut isov lum yamar aplo ile ve inaute mateu ebe Yisu ginei ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gibloblo ve eisir Juda inalgum as ben bamo ebe ital inei Pasova ok. ");
INSERT INTO kbm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Be bambamo ebe emb kulkul da ane ok be tis gidung ebe emb Mose ane yaun dabin ok, irek luev ebe ve ines Yisu vunu ok bemem eisir ipelk ve amolmol. ");
INSERT INTO kbm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Be Judas Iskariot etok Yisu ane amol singamolomb ti. Be Sadam ande gile givang givin ei gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas Iskariot nok givang gitangi bambamo ebe emb kulkul da ane ok be tis gidung ebe emb Mose ane yaun dabin ok gile be gipasang yaun ebe ve nitak Yisu nisov eisir bais ok gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Beti eisir bambamo nok iute be tas vevias ge be inei atob inavgo ei ve mone. ");
INSERT INTO kbm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas Iskariot nok ande tang gitung dongke-ngge ve nilgum ane yaun etok ano nile, beti ei gilgum ve nili sawa vie-ngge ti ebe ande amolmol tepwengge ikwai Yisu be Ei ate-ngge gibweg ok okob. Veik ei ninggas bambamo ebe emb kulkul da ane ok be tis eisir ebe emb Mose ane yaun dabin ok be inde be inemb Yisu ta bwayage-ge. ");
INSERT INTO kbm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gibloblo ve amolmol Juda ane inalgum as ben bamo ebe ital inei Pasova ok, beti as mate etok ebe amolmol veve ines bwelk sipsip vunkunu ve inalgum ben ok. ");
INSERT INTO kbm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Beti Yisu tang gitung ve nihlin Pita gabu Jon inde be inpasang eisir as ben, beti ginei gitangi sulu be ginei; “Yemlu unde be unpasang eitit and ben ebe ve tanen ok yapin.” ");
INSERT INTO kbm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Be sulu iutani Yisu be inei, “Mie tam-givin gunei eilu anpasang eitit and ben nangge nam inend?” ");
INSERT INTO kbm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Be Yisu ginei gitangi sulu, “Gabu unde unahlang Jerusalem ok be atob undi amol ti givwat bui gisov ul bui ane bamo ti, be gabu un-sasa ei unde love unpil nam ete ei ve nipil ok unde. ");
INSERT INTO kbm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Be gabu unei nitangi nam nok ane tivie dang eteik, ‘Amei-mei Gidung ginei mie nomb nam aplo ti nitangi amei ve anen amei ben Pasova ane anambweg.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kob atob amol nok nes nam aplo bamo ti ru nitangi yemlu. Bekob gabu unpasang eitit and ben nangge etok.” ");
INSERT INTO kbm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pita gabu Jon ile love ili gen walang ok gitangi ebe galkik Yisu ginei gitangi sulu yapin ok, beti gabu emb kulkul ve ipasang tis Yisu as ben Pasova ane nangge etok. ");
INSERT INTO kbm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yisu tis ane aposel gen isov nam aplo ile imbweg ve inen ben. ");
INSERT INTO kbm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Be Yisu ginei gitangi eisir be ginei; “Ayeu tangg givin ano-ngge ve ganei nan ben etenik navin yem nimungg bekob nanggas vavavne. ");
INSERT INTO kbm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Dangetok be Ayeu nanei nitangi yem, Ayeu atob nan ben etenik vukuri ite love gen bunam etok ane dabe ano nile be niengk nitip ge nangge Pomate ane taku ebe geb amolmol dabin ok okob. ");
INSERT INTO kbm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bekob Yisu geb wain tis kap be ges miengk gitangi Pomate bekob geb gitangi ane singamolomb gen be ginei, ‘Unemb wain etenik itangi aim ate be unum.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ayeu nanei nitangi yem, ‘Ayeu atob nanum wain etenik vukuri ite love Pomate nemb amolmol dabin nangge ane taku okob atob ayeu nanum wain vaku etok navin yem nangge taku ebe Pomate ve nemb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bekob geb ben (beret) be ges miengk gitangi Pomate bekob geb gitangi ane singamolomb gen be ginei; ‘Etenik weik Ayeu utlangg ulis ebe gab ve amolmol tepwengge ane ok. Be unen be tangg-aim nitung Ayeu.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","En ben gikwai kob Yisu geb wain tis kap be gilgum weik etok ge be ginei, ‘Etenik weik awangg twerk ebe gimsuli ve niro luev vaku ebe Pomate ve nisin amolmol as tiate nikwai ta ok etenik. ");
INSERT INTO kbm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bemem tau undi kob, ve amol ebe atob ninei Ayeu binge nitangi amolmol valir ane ok ete ande gibweg be gen ben givin Ayeu nik. ");
INSERT INTO kbm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob namat vunu dang-ebe warik Pomate ei ate tang gitung yapin ok. Bemem amol ete ve ninei Ayeu binge nitangi amolmol valir ane ok likok e, atob ninggas vavavne bamo molge.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eisir singamolomb iute be inei ve is ate be inei, ‘Amol ret ete atob nilgum gen dangetok ok?’ ");
INSERT INTO kbm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eisir singamolomb iutau-tani is ate ve eisir as amol ret atob menihlang weik eisir as amol bamo. ");
INSERT INTO kbm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Beti Yisu ginei gitangi eisir be ginei. “Amolmol bambamo ebe emb amolmol dabin nangge nalk etenik ok, tis as gwangne-ngge. Be ginei eisir inei yaun ti ok-ti atob amolmol insov eisir as yaun ane lu-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","27","Bemem yem unalgum dangete eisir ok bwaya. Ginei yem aim amol ti tang gitung ve menihlang weik amol bamo, okob ei nilgum ate weik ebe amolmol tepwengge as amol kulkul ane ti ok. Be Ayeu ate ete gavang gavin yem nik, ayeu gab kulkul ve amolmol tepwengge ane. ");
INSERT INTO kbm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ayeu gagas bunam walang ano bemem yem uvang uvin ayeu geb ta-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pomate geb ane gwangne gitangi ayeu beti gab amolmol dabin. ");
INSERT INTO kbm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dangetok be atob ayeu namb angg gwangne nitangi yem weik etok ge, be nindeb mul ane atob yem unambweg unvin ayeu nivin ebe ayeu ve menahlang ve Amol Bamo (King) ebe ve namb gen tepwengge dabin ok. Be atob yem unalgum amolmol Israel ane as yaun. ");
INSERT INTO kbm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Be Yisu ginei gitangi Pita be ginei; “Pita, Sadam gigas gwangne be ei gitangi ebe atob nilgum mie weik ebe ilir kopi ulis gikwai ano ok. ");
INSERT INTO kbm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bemem ayeu gas miengk gitangi Pomate ve mie ane veik mie aplom ninggas ayeu ta painge-ngge. Veik ginei mie guro im ate vukir be gutangi ayeu gunme vukuri, okob mie gitangi ebe atob nuro am nune-nggen ta ok weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Be Pita giwel Yisu avo be ginei, “Amol Bamo, Ayeu ande gas au-ate bago gikwai ve atob nambweg kapual-lu navin mie, be atob namat vunu navin mie weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yisu giwel Pita avo be ginei, “Pita, Ayeu nanei nitangi mie, Atob tambok etenik kavkavav niteng ite nangge be atob mie nuvkir dumem nitangi ayeu nimungg.” ");
INSERT INTO kbm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Be Yisu ginei gitangi ane singamolomb gen be ginei, “Warik Ayeu gahlin yem be uvang utangi nam dabe ge ule, be uvwat aim vak me mone, me kup ti givin aim ate ite, be givin sawa etok okob yem urek aim ate ve gen ti ane me ma?” Be eisir singamolomb iwel Yisu avo be inei, ‘Ma molge!’ ");
INSERT INTO kbm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Beti Yisu ginei gen ebe asonge menihlang nipil eisir ok be ginei, “Galkik as mate etenik ginei amol ti ane mone tis vak giengk, okob ei nivwat ane gen nivin. Be ginei amol ti ane buyag valir ane ti giengk ite, okob ei nemb ane kup ve amolmol inavgo bekob nivwat gen etok ane mone nile be nivgo buyag valir ane ti ve ane. ");
INSERT INTO kbm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Be ayeu nanei nitangi yem, yaun ebe warik Pomate ane amolmol kulkul ane inei ok, atob ano nile, be yaun nok dang eteik; ‘Atob amolmol intal ayeu inei amol ebe gavang gavin amolmol tiate ane ok.’ Yaun etok ete warik Pomate ane amolmol kulkul ane inei. Be Yaun nok eisir inei gipil ayeu, beti atob yaun etok ano nile. ");
INSERT INTO kbm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Be eisir singamolomb inei gitangi Yisu be inei, ‘Amol Bamo, Eitit and buyag valir ane ailu-ngge ete giengk nik.’ Be Yisu ginei gitangi eisir, ‘Etok gitangi.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yisu gimdil be gile ve nireu matendubi ebe ei-oliv anongge givarkei ok nile ve nes miengk dangebe gilgum gilgum ok. Beti eisir singamolomb itau ile ei be ile. ");
INSERT INTO kbm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eisir imbielk ve taku nok gikwai kob Yisu ginei ve ane singamolomb gen be ginei, “Yem unes miengk gwangne-ngge weik gen bunam dang dang etok nipil yem bwaya.” ");
INSERT INTO kbm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bekob Yisu gikwai ane singamolomb gen be givang gile aikawe kasop-gege be givswen va-ndubi gisov nalk be ges miengk dang eteik: ");
INSERT INTO kbm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamangg, Mie gitangi ebe ve nuitin gen bunam bamo etok nikwai ayeu ok. Bemem mie nulgum nitangi ebe ayeu angg tang gitung ok ite, Mie nulgum nitangi ebe mie ate am tam gitung ok.” ");
INSERT INTO kbm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Gen bunam etok gilgum Yisu be aplo bunam tiate be givin ebe ei ges miengk ok, be vavank gisov love weik ebe twerk gimsuli gisov nalk ok. Beti Pomate ane angela ti gisov nangge gulumb ginme be giro Ei ta. ");
INSERT INTO kbm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yisu ges miengk gikwai kob ginumul gitangi ane singamolomb gen gile be gili eisir ande tepwengge isov be iengk ge, ve eisir aplos bunam molge. ");
INSERT INTO kbm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Beti Yisu ges is itin be ginei, “Unyengk bwaya, be unambweg matawangg-aim be unes miengk gwangne-ngge veik gen bunam ete ve ninme ok nipil yem nivin bwaya.” ");
INSERT INTO kbm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisu ginei yaun ve ane singamolomb gen givang nangge be Judas Iskariot, ei Yisu ane singamolomb ti, ei gigas amolmol dubi bamo ti be imbielk ve Yisu tis ane singamolomb gen tavlu nangge etok. Judas Iskariot nok givang gitangi Yisu gile ve nisavi ei bage. ");
INSERT INTO kbm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Beti Yisu ginei gitangi ei be ginei, “Mie gunme ve nusavi ayeu baingg veik nos ayeu ru nitangi amolmol valir ane dubi bamo etenik merav?” ");
INSERT INTO kbm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Be eisir singamolomb ili ebe amolmol valir ane ile ve inemb Yisu ta ok, beti inei gitangi Yisu be inei, “Amol Bamo, Gitangi ebe amei anes eisir etenik ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Be eisir singamolomb nok as amol ti girun ane buyag valir ane be gispe amol bamo ti ebe geb kulkul da ane ok ane amol kulkul ane ti talngelan tavlu gili gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bemem Yisu ginei gitangi ane singamolomb gen be ginei, “Ande ulgum etok gitangi.” Bekob ete Yisu gilgum amol nok talngelan be vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Be Yisu ginei gitangi bambamo ebe emb kulkul da ane ok be tis amolmol valir ane ebe emb lum yamar dabin ok tis eisir bambamo yaun ane ebe inme ve in-gas Ei ok be ginei, “Wat Ayeu amol vaina ane ti me, beti yem unme tis gen valir ane-ngge ve un-gas Ayeu? ");
INSERT INTO kbm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","As mate walang ok Ayeu gavang gavin yem be ganei mateu gitangi yem nangge lum yamar aplo bemem yem omb Ayeu ta ite? Bemem galkik as mate etenik atob amol aiweng tumi (Sadam) ane be tis yem unalgum gen nitangi ebe yem ate tangg-aim gitung ve unalgum ok.” ");
INSERT INTO kbm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Amolmol valir ane bais gisov Yisu be inggas ile amol bamo ti ebe geb amolmol dabin ok ane nam. Be Pita gitau gile eisir bemem ei givang aikai-kawe-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Be givin etok ande amolmol imban yev gile nam luvwe yapin be imbweg ve inaute Yisu ane yaun. Beti Pita gile be gile gibweg givin amolmol ebe imbweg ile idbul yev ok be gibweg. ");
INSERT INTO kbm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Be amol bamo ebe giute giute amolmol as yaun ok ane avie kulkul ane ti gili Pita ebe gibweg ve gimuailuv yev ok, be na giro ei ta be ginei, “Amol etenik ok ebe givang givin Yisu ok.” ");
INSERT INTO kbm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bemem Pita ges Yisu are ta be ginei, ‘Ayeu tangg gisgil amol etenok.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Be bwayage kob amol ti gili Pita vukuri be ginei, “Mie etenik ete Yisu ane singamolomb ti!” Bemem Pita giwel amol nok avo be ginei, ‘Ma! Ayeu ite!’ ");
INSERT INTO kbm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Be imbweg love ande sawa manang kasop-gege, bekob amol ti ginei yaun girwel na-ngge gitangi Pita be ginei, “Bingano molge, Yisu ane singamolomb ti etenik ve ei ginei yaun weik ebe amolmol Galilaia ane ok!” ");
INSERT INTO kbm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bemem Pita giwel amol nok avo be ginei, “Ayeu tangg gisgil amol ete yem unei ane yaun nok!” Pita ginei yaun etok givang nangge be seukie-ngge kavkavav ti giteng. ");
INSERT INTO kbm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Beti Amol Bamo (Yisu) giro na vukir gitangi Pita be na giro ei ta be seukie-ngge Pita ta-nggiro Yaun ebe Yisu ginei gitangi ei gimungg yapin ok. Ve Yisu ginei gitangi Pita dang eteik, ‘Atob tambok etenik kavkavav niteng ite nangge be atob mie nos Ayeu arengg ta nimungg.’ ");
INSERT INTO kbm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Beti Pita gimdil gile gihlang gikwai nam luvwe be giteng anongge. ");
INSERT INTO kbm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Amolmol ebe emb Yisu ta ok ilgum molok gile ei be idgin matano avwut ve kambam ti bekob es ei be iutani be inei, ‘Mie unei itangi amei kob, unei amol ret ete ges Mie nik?’ ");
INSERT INTO kbm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Be inei yaun ungglus-ungglus subu gipil Yisu givin. ");
INSERT INTO kbm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Givin sawa etok ge bambamo subu ebe emb kulkul da ane ok be tis gidung ebe emb Mose ane yaun dabin ok, be tis bambamo yaun ane subu iro is ate sut bekob inggas Yisu itangi eisir awaga as kasa ile, ");
INSERT INTO kbm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","be iutani Ei be inei, “Mie unei itangi amei kob. Mie Amol etenik ebe gob amolmol ru ok me?” Be Yisu giwel eisir avos be ginei, “Ginei Ayeu ate nanei Ayeu amol ebe gab amolmol ru ok, atob yem aplongg-aim nivin awangg yaun ite. ");
INSERT INTO kbm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Be ginei Ayeu nautani yem ve yaun ti ane, atob yem unwel awangg yaun ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bemem galkik as mate etenik be asonge niengk dangetok, atob Pomate Natu Ayeu ebe meng gahlang weik amolmol ok atob nambweg nambloblo Tamangg nangge ane taku vie.” ");
INSERT INTO kbm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Be eisir tepwengge inei, ‘Mie amol dang etenik ete gunei Pomate Natu mie merav?’ Be Yisu giwel eisir avos be ginei, “Yem ate nok ete unei Pomate ane Natu Ayeu.” ");
INSERT INTO kbm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Beti amolmol tepwengge imdil be inei, “Eitit tanasge amol yaun ane bwaya, ve ande eitit tepwengge taute Ei ane yaun ebe ginei ok gikwai!” ");
INSERT INTO kbm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Beti eisir imdil be inggas Yisu ile be itak Ei givarkei Pilata na, ");
INSERT INTO kbm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","be inei, “Amei ali Amol etenik gilgum ve niyaing eitit and luev be ges amolmol gili be ginei amolmol inemb mone takes ane nitangi Rom as amol bamo bwaya. Be Ei ginei Ei Amol Bamo be ei Amol ebe geb eitit ru ok!” ");
INSERT INTO kbm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Beti Pilata giutani Yisu be ginei, “Mie amol bamo ebe gob amolmol dabin nangge Juda as taku ok me?” Be Yisu giwel Pilata avo be ginei. “Yaun nok ete ande mie ate gunei nok!” ");
INSERT INTO kbm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Be Pilata ginei gitangi bambamo ebe emb kulkul da ane ok be tis amolmol tepwengge be ginei, “Ayeu gali Amol eteik ane gen tiate ti ebe gilgum ok ite!” ");
INSERT INTO kbm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bemem amolmol tepwengge iwel Pilata avo be inei, “Amol etenik gibul amolmol nangge Juda as taku walang ok be gilgum be amolmol ilgum gen ungglus-ungglus walang ano molge. Be ei geb ane kulkul etok gimungg nangge Galilaia as taku be painge love galkik as mate etenik gibielk ve eitit.” ");
INSERT INTO kbm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilata giute yaun ebe amolmol inei ok beti ei giutani eisir be ginei, “Amol etenik nangge Galilaia as taku merav?” ");
INSERT INTO kbm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Beti amolmol inei lavo gitangi ei. Pilata ande gitpweng are ginei Yisu ei ginme nangge taku ebe amol bamo Herodes geb dabin ok. Be givin sawa etok Herodes geb amolmol dabin ge nangge Jerusalem, beti Pilata gihlin Yisu gireu gile Jerusalem gitangi Herodes gile. ");
INSERT INTO kbm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Givin ebe Herodes gili Yisu ok be ta vevie anongge ve ei giute Yisu binge-ngge be gilgum ve ginei nili Ei siti kob ok love gili ma molge. Herodes gilgum ve ginei Yisu nilgum gen bwalbwale ti be ei nili kob, ");
INSERT INTO kbm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","beti giutani Yisu ve yaun walang ano molge bemem Yisu ginei yaun ti ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Beti bambamo ebe emb kulkul da ane ok be tis gidung yaun ane ile ihlang be inei yaun ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bekob Herodes tis ane amolmol valir ane ilgum molok gile Ei be inei King, be ino kup bogbogo bamo ti gireu Yisu bekob emb ei ginumul gitangi Pilata gile vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Warik Herodes gabu Pilata ili is ate tiate painge-ngge bemem sawa etok ge ete ande gabu tas givin is ate be ivang vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilata gital bambamo ebe emb kulkul da ane ok be tis eisir bambamo ebe ilgum amolmol as yaun ok be iro is ate sut, ");
INSERT INTO kbm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bekob ginei gitangi eisir be ginei, “Yem unggas Amol etenik utangi ayeu unme be unei Ei gilgum gen ve nitin eitit and gavman nikwai, bemem galkik ayeu gautani Ei nangge eitit tepwengge nand be ayeu gali ei ane gen tiate ti ebe gilgum ok it molge. ");
INSERT INTO kbm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Be Herodes ok gilgum ve ginei nili ei ane gen tiate ebe gilgum ok bemem ma weik etok ge, beti geb Yisu ginumul gitangi eitit ginme vukuri. Dangetok be ayeu gali Ei ane tiate ti ebe atob eitit tanes Ei vunu nisov ok ite, ");
INSERT INTO kbm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","be atob ayeu narau Ei-ngge bekob baingg vier ve Ei be nile.” ");
INSERT INTO kbm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Givin Sonda Bamo walang ok atob Pilata nihlang amolmol ebe imbweg kapual-lu ok as amol ti gitangi ebe amolmol eisir ate as tas givin be inei gitangi ei ve nihlang ok be nitangi eisir nile tis Sonda Pasova ane walang ok. ");
INSERT INTO kbm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Beti amolmol tepwengge ital yaun avos bambamo-ngge be inei, “Tanes Yisu vunu be mie nomb Banabas nitangi amei ninme.” ");
INSERT INTO kbm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Banabas ei ges amol ti vunu be ei gilgum beti amolmol nangge Jerusalem es is ate, beti Pilata gitak ei gibweg kapual-lu ve ane gen tiate etok ane.) ");
INSERT INTO kbm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilata tang givin ve nihlang Yisu nikwai nam kapual-lu ane beti giutani amolmol vukuri, ");
INSERT INTO kbm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","bemem amolmol tepwengge ital yaun avos bamo-ngge ginumul gitangi Pilata be inei, “Tanes Yisu nireu ei-givsangin.” ");
INSERT INTO kbm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Be Pilata giutani amolmol vukuri be ginei, Nam nambed? Ayeu gali Ei ane gen tiate ti ebe gilgum be gitangi ebe ve tanes Ei vunu nisov ok ite, be atob tanes Ei vunu sin-gege ve ret ane? Ayeu tangg givin ve narau Ei ve rauk ge bekob baingg vier ve Ei be nile.” ");
INSERT INTO kbm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bemem amolmol tepwengge ital yaun giro ta-ngge gidbwem Pilata avo be inei, “Tanes Ei nireu ei-nggivsangin nile.” Beti eisir ande imbweg Pilata vovo gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilata ande tang gitung ve nilgum gen nitangi ete ande eisir inei ok be ines Yisu nireu ei-nggivsangin. ");
INSERT INTO kbm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Beti gihlang Banabas gikwai nam kapual-lu ane be geb ei gitangi amolmol gile, bekob geb Yisu gitangi eisir gile ve inalgum gen nitangi ebe galkik inei ok. ");
INSERT INTO kbm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amolmol valir ane inggas Yisu ile ve ines ei nireu ei-nggivsangin, be givin ebe inggas Ei be ivang luev ve ile ok, be ile vunge ve amol ti are Simon be ei nangge Sairini as taku. Ei gireu gile ve nivang Jerusalem ane love amolmol valir ane ile vunge ve ei nangge luev beti avos girau ei ve nemb Yisu ru be nivwat Yisu ane ei-nggivsangin be nitau nile eisir. ");
INSERT INTO kbm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Be amolmol anongge molge itau ile eisir valir ane ebe inggas Yisu ile ve ines nireu ei-nggivsangin ok. Be avie gaptol subu ebe warik emb Yisu tis ane singamolomb gen dabin ok ivang ivin amolmol dubi bamo etok ve ile be tas bua be iteng ano-ngge ve Yisu ane. ");
INSERT INTO kbm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bemem Yisu giro na vukir be ginei gitangi avie gaptol nok be ginei, “Yem avie gaptol Jerusalem ane, Unteng ve Ayeu ane bwaya. Bemem unteng ve aim ate be tis natungg aimgen ane. ");
INSERT INTO kbm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ve asonge kob atob amolmol inei, ‘Avie gaptol ebe gitangi ve inkuv nunus ite ok, be tis avie gaptol ebe ikuv nunus ite ok, be tis avie gaptol ebe emb rur ve nunus ite ok, eisir tas vevias ge ve eisir gitangi ebe atob indi gen bunam ti dangetok ok ite ve eisir natusgen ma.’ ");
INSERT INTO kbm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Be nivin sawa etok atob amolmol inei nitangi matendubi bambamo be inei, ‘Umble unme be uspun amei seukie-ngge.’ ");
INSERT INTO kbm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Be Yisu ginei, ‘Ginei atob etenik eisir inalgum ayeu tiate, okob atob inalgum gen tiate molge ti nitlek etenik nitangi yem.’ ");
INSERT INTO kbm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Be givin etok amolmol valir ane inggas amol ailu ebe ilgum gen tiate weik es amolmol vunkunu be ivai-vaina gen ok ile ve ines sulu nireu ei-nggivsangin nivin. ");
INSERT INTO kbm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Amolmol valir ane inggas Yisu ile love imbielk taku sawa ti ebe nalk numnumbu numnumbu weik amolmol dabas tulkwe giengk ok, okob es ei gireu ei-nggivsangin nangge taku etok. Be es tis amol tiate ane ailu ebok gireu ei-nggivsangin givin, amol ti gikaiwel gideb Yisu rarali tavlu be ti gikaiwel tavlu. ");
INSERT INTO kbm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yisu ges miengk be ginei gitangi Tame be ginei, “Tamangg, Mie tam nivalngan eisir as gen tiate ete ilgum ik ve eisir tas gisgil gen ete ilgum ok.” Be amolmol valir ane es bwas ve indi inei, amol ret atob nivwat Yisu ane kup ve ane. ");
INSERT INTO kbm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Be amolmol anongge ile ivarkei be nas giengk Yisu ebe gikaiwel ei-nggivsangin ok. Be bambamo subu inei yaun ungglus-ungglus gipil Yisu be inei, ‘Ei gitangi ve nemb amolmol ebeok ge ru, be ginei ei amol ebe Pomate gihlin be ginme ve nemb amolmol dabin ok bingano, okob emb ate ru ma!’ ");
INSERT INTO kbm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Be amolmol valir ane ok inei yaun ungglus-ungglus gipil Yisu weik etok ge. Bekob ivang ile imbloblo ebe Yisu gikaiwel ok be emb bui vavis ti ve Yisu ninum, ");
INSERT INTO kbm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","be inei, “Ginei Mie amol bamo ebe gob amolmol dabin nangge Juda as taku ok, okob omb im ate ru.” ");
INSERT INTO kbm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Be iro yaun ti gireu Yisu ane ei-nggivsangin gideb dabe ane dang eteik, “JUDA AS AMOL BAMO EBE GEB AMOLMOL DABIN OK ETENIK.” ");
INSERT INTO kbm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Be amol ailu ebe es sulu ireu ei-nggivsangin givin ok, as amol ti gihle Yisu be ginei, “Ginei Mie amol ebe gob amolmol dabin ok bingano-ngge, okob omb totol ru ma?” ");
INSERT INTO kbm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bemem amol nok ane nune gigo ei be ginei, “Totol tepwe tanggas vavavne gitangi ate-ngge, bemem mie wat gupelk ve Pomate ite me? ");
INSERT INTO kbm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tau mie uli kob, ve tutlu tanggas vavavne dang etenik ok gitangi ve and gen tiate ebe talgum talgum ok ane. Bemem Amol etenik Ei gilgum gen tiate ti ite molge be gigas vavavne bamo etenik sin-gege!” ");
INSERT INTO kbm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Be amol nok ginei gitangi Yisu be ginei, “Asonge nindeb mul ane nivin ebe Mie ve nunumul nunme weik Amol Bamo (King) ve nunggas am amolmol gen ok, okob tam nitung ayeu nivin.” ");
INSERT INTO kbm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Be Yisu ginei gitangi amol nok be ginei, “Ayeu nanei bingano-ngge nitangi mie, galkik as mate etenik ge atob mie numbweg nuvin Ayeu nangge Pomate ane taku vie.” ");
INSERT INTO kbm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Givin as mate luvwe tumi bamo molge geb taku walang ok avwut be giengk dangetok painge love gibok as matano aitol (3 kilok). ");
INSERT INTO kbm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Be kambam ebe gikaiwel Lum yamar bamo aplo ve gisil amolmol ve indi Pomate bwaya ok, gisiel vusa gile ake ailu. ");
INSERT INTO kbm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Be Yisu gital yaun avo bamo dongke be ginei, “Tamangg, Ayeu ve nahlin dalgongg matawangg ane nitangi Mie nilek.” Yisu ginei yaun etok gikwai be gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Be Rom as amolmol valir ane as amol bamo ebe gitwem eisir ok, gili gen etok love avo givwat Pomate are be ginei, “Bingano molge, Amol etenik Ei Amol vie molge ti.” ");
INSERT INTO kbm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Be amolmol ebe ile ivarkei ve indi gen ebe ilgum gitangi Yisu ok, ili love ilai-lai dabas be inumul ile ve ivang as nam ane. ");
INSERT INTO kbm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Be Yisu ane nune-nggen ebe ivang ivin ei ok be tis avie gaptol ebe imdil nangge Galilaia as taku be ivang mul ve Yisu be ile ok, eisir ivarkei aikawe-ngge be nas giengk gen bambamo ebe amolmol valir ane ilgum gitangi Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Bekob amol ti ebe geb lum mateu ane dabin ok are Josep nangge nam dabe ti are Arimatia ebe giengk Juda as taku ok. Be ei amol ti ebe aplo givin Pomate be gisge sawa ebe Pomate ve nemb ane amolmol dabin ok. Beti gen walang ete bambamo subu ebe emb lum mateu ane dabin ok ilgum gitangi Yisu ok, ei ginei gen etok ane yaun ti givin ite. ");
INSERT INTO kbm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Be ei gipelk ite be givang roro-ngge gitangi Pilata gile be giutani Yisu utle ulis ve nivwat nile be nispun. ");
INSERT INTO kbm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Beti gile be giru Yisu utle ulis nangge ei-nggivsangin gisov meng gitak nalk bekob gisum ve kambam bogbogo vaku ti be givwat gile gispun gisov nalk avo ti ebe itav nangge vat bambamo aplo ok. Be nalk avo nok, ispun amol ti gisov ite molge. ");
INSERT INTO kbm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Josep gispun Yisu givin dabe-butu (Friday) be imdil Soki tistumi etok ebe amolmol Juda ane ve indi as Sonda ebe ital inei Sabat ok. ");
INSERT INTO kbm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Givin ebe Josep givwat Yisu utle ulis gile ve nispun ok, be avie gaptol ebe warik ivang ivin Yisu tis ane singamolomb gen nangge Galilaia ok ivin ile be ili nalk avo ebe Josep gispun Yisu gisov ok givin. ");
INSERT INTO kbm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bekob inumul ile as nam ok be ipasang marasin ukwas-ukwas subu ve invwat inde be inro nireu Yisu utle ulis. Be givin Juda as Sonda Sabat, avie gaptol nok ilgum gen ti ite be imbweg sinsin-ge tis as mate etok. Gitangi ebe Juda as luev Sonda ane ginei ok. ");
INSERT INTO kbm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Givin Sonda tistumi-ngge avie gaptol nok imdil be ivwat marasin ukwas ukwas ebe ipasang yapin ok be ve invang Yisu ane umbub ane inde be inro marasin nok nireu Yisu utle ulis. ");
INSERT INTO kbm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Sotol ivang ile love ile imbloblo umbub ebe Yisu giengk ok be ili vat bamo ebe gisil nalk avo ok ande gidug-dug gile giengk aikawe gikwai nalk avo. ");
INSERT INTO kbm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Beti sotol mang-mangi-ngge isov nalk avo ile be ili Yisu utle ulis ebe ve niengk nalk avo ok ma, ");
INSERT INTO kbm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","be tas gitung gile ma-ngge ivarkei. Be seukie-ngge amol ailu inme ivarkei ivin sotol, amol ailu nok as kup eteik bogbogo be ringenk molge. ");
INSERT INTO kbm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Avie gaptol nok ikuri vunungge be ituk ge ivarkei. Be amol ailu nok inei gitangi sotol be inei, “Amol etenik ande matawe gikwai be unrek Ei nangge ete taku gimat ane nik bwaya! Ve Ei giengk etenik ite, Ei ande gimdil gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gaptol tangg aim itung ane yaun ebe warik gibweg matawe-ngge be ginei gitangi aim yapin nangge Galilaia ok. ");
INSERT INTO kbm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ve Ei ate avo ukwas ebe ginei ok eteik; ‘Atob amolmol tiate ane ines Pomate Natu Ayeu ebe meng gahlang weik amolmol ok nareu ei-nggivsangin nale, be atob namat vunu. Bemem as mate ebe ve aitol ane ok, okob atob Ayeu matawangg be namdil nakwai taku gimat ane.’” ");
INSERT INTO kbm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kob ete avie gaptol nok tas giro yaun nok ebe warik Yisu Ei ate ginei gitangi eisir ok, ");
INSERT INTO kbm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","beti inumul ile be inei gen bambamo etok binge gitangi eisir singamolomb (11) ebok be tis amolmol subu givin. ");
INSERT INTO kbm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Avie gaptol nok ares Malia Magadala ane gabu Joana, be Jakobos tine Malia. Bekob avie gapto ebeok subu ivang ivin sotol aitol etok be tepwe inei gen etok lavo-lavo gitangi eisir singamolomb. ");
INSERT INTO kbm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bemem eisir singamolomb inei bwat avie gaptol inei yaun bingkasop beti aplos givin eisir as yaun ite. ");
INSERT INTO kbm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Beti Pita gimdil be gituvki gile ebe matmat ok be gile gitlek na gisov nalk avo ebe Yisu giengk ok bemem gili kambam ebe Josep gisum Yisu utle ulis gisov ok ge giengk nalk avo. Pita gili gen etok love gilai-lai dabe. ");
INSERT INTO kbm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Givin sawa etok ge amol ailu ebe warik ivang mul ve Yisu tis ane singamolomb gen ok imdil ve inde nam dabe ti are Emaos. Be nangge Jerusalem be gile Emaos etok sawa undib siti. ");
INSERT INTO kbm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amol ailu nok ivang ve ile be gabu kakie gipil gen bambamo ebe meng-gihlang nangge taku matmat ok be iutau-tani is ate nangge luev ile-ile. ");
INSERT INTO kbm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gabu kakie be inei gen bambamo etok ane avo ve ile be Yisu Ei ate gibielk ve sulu nangge luev be gaptol ivang dongke ve ile. ");
INSERT INTO kbm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amol ailu nok ili Yisu ebe givang givin sulu ok, bemem weik ebe sulu matanos avuavu ok be itpweng Ei are ite. ");
INSERT INTO kbm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Be Yisu giutani sulu be ginei, “Yemlu kakie be unei ret bambamo ete galkik nangge luev ok?” Be sulu ande aplos bunam be tongas ge ivarkei. ");
INSERT INTO kbm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bekob sulu ailu nok as ti are Kilaupas giutani Ei be ginei; “Wali mie guvang sawa inend be guli gen bambamo ete walirik amolmol ilgum ok ite?” ");
INSERT INTO kbm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Be Yisu giwel Kilaupas avo be giutani; “Gen ret?” Be sulu isgabu iwel Yisu avo be inei; “Gen bambamo ebe walirik amolmol ilgum gitangi Yisu Nasaret ane ok. Be Amol nok ei Pomate ane amol kulkul ane vie molge ti, be ei ginei ane yaun be gilgum ane gen walang ok ve Pomate ane gwangne giengk gitip ge nangge amolmol tepwengge nas. ");
INSERT INTO kbm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bemem amei-mei amolmol bambamo ebe emb kulkul da ane ok be tis eisir ebe emb amei dabin ok inei be Rom as amolmol valir ane es ei gireu ei-nggivsangin. ");
INSERT INTO kbm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Be amei tangg amei giluni ve anei Amol etok ebe ve nemb amolmol Israel ane ru nangge Rom as amol bamo (Gavman) bage ok. Beti gilgum be amei aplongg amei bunam molge ve ei ane be ete avang nik. Be gen etok meng gihlang tis walirik be galkik ande as mate aitol gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Be amei-mei avie gaptol subu ebe ivang ivin amei ok ile ve invail ei nangge ebe ane umbub ok ");
INSERT INTO kbm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bemem ili ei utle ulis ebe ve niengk nalk avo ok ma. Beti inumul inme be inei eisir ili gen weik mev ok be Pomate ane angela ailu inme be inei gitangi eisir be inei Yisu ande matawe vukuri be gimdil nangge taku gimat ane, beti gilgum be amei akuri vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Be amei-mei amolmol subu ile taku gimat ane ok be ili weik ete galkik avie gaptol inei ok, bemem ili Yisu nok ano ite.” ");
INSERT INTO kbm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Beti Yisu ginei gitangi sulu be ginei; “Yemlu tangg-aim gitung ailu ailu ve yaun ebe warik Pomate ane amolmol kulkul ane (Propet) inei ok ve ret ane? ");
INSERT INTO kbm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Yaun ebe Pomate ane amolmol kulkul ane inei ok ginei dangeteik; ‘Amol ebe ginme ve nemb amolmol dabin ok (Kilisi) atob ninggas vavavne nimungg, bekob atob nimbweg tis Tame ane gwangne tis ane bogbogo.’” ");
INSERT INTO kbm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bekob Yisu ginei yaun ebe warik Mose be tis Pomate ane amolmol kulkul ane subu (Propet) inei gipil ei ate ok, ane ano vus-vusa gitangi sulu. ");
INSERT INTO kbm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gaptol ivang ile love ande ile imbloblo nam dabe ebe amol ailu nok tas gitung ve inde ok, be Yisu gilgum ve nitlek nam dabe nok be mang-mangi nile. ");
INSERT INTO kbm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Beti sulu inei gitangi ei be inei, “Tepwe tayengk etek be asongkob ve ande as gile gikwai be kasopge be tambok.” Beti Yisu gile be gibweg givin sulu. ");
INSERT INTO kbm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bwayage kob sotol ile imbweg golonge ve inen ben, be Yisu geb ben siti be ges miengk gitangi Pomate bekob geb gitangi sulu ve inen. ");
INSERT INTO kbm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Be givin sawa etok ge sulu matanos ili ei be itpweng are, bemem ande ei lavo bun seukie-ngge. ");
INSERT INTO kbm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Be sulu inei ve is ate be inei, “Amol etenik kakie givin tutlu be ginei yaun ebe warik Pomate ane amolmol kulkul ane inei ok lavo-lavo ve tutlu be totol tepwe tavang gile dongke ve tanme, be givin sawa etok ete tutlu tatpweng yaun etok are ano-ngge.” ");
INSERT INTO kbm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Beti givin sawa etok ge sulu imdil vukuri be inumul ile Jerusalem, ile imbielk ve eisir singamolomb tavlu ebok be tis amolmol subu ebe imbweg ok. ");
INSERT INTO kbm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Be eisir nok inei gitangi sulu be inei; “Bingano molge Yisu ande matawe be gimdil nangge taku gimat ane gikwai, be ande ges ate ru gitangi Saimon!” ");
INSERT INTO kbm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Beti sulu iput gen bambamo ebe meng gihlang nangge luev be sulu tas gisgil ok lavo-lavo gitangi eisir be gabu inei; “Givin ebe Ei geb ben be ges miengk gitangi Pomate bekob geb gitangi eilu ve anen ok, okob ete eilu atpweng Ei are gipil ebe geb ben be ges miengk ok.” ");
INSERT INTO kbm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Amol gabu inei gen bambamo etok lavo-lavo gitangi eisir imbweg ge, be seukie-ngge Yisu ei ate gile givarkei givin eisir tepwe be ginei; “Gaptol unambweg vie-ngge be tangg-aim itung walang walang bwaya!” ");
INSERT INTO kbm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bemem eisir ikuri vunungge be ipelk ve inei bwat taku ate (guk). ");
INSERT INTO kbm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bemem Yisu ginei gitangi eisir be ginei; “Aplongg-aim ailu ailu be unpelk bwaya. ");
INSERT INTO kbm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ve Ayeu ate nok etenik. Yem ate unme be undi bili lavo ebe giengk Ayeu baingg be tis vangg ik be baingg aim ile Ayeu utlangg ulis be undi kob, ve taku ate (guk) eisir utlas ulis viro be tis tulkwe weik ete ande uli awangg nik ite, ma!” ");
INSERT INTO kbm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(Ei ginei yaun etok gitangi eisir gikwai bekob ges bili lavo ebe giengk bage be va ok ru gitangi eisir be ili). ");
INSERT INTO kbm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eisir singamolomb ili be tas vevias ge bemem aplos givin Yisu ane yaun ete ginei gitangi eisir ok ite, be tas gitung walang ano molge. Beti Yisu giutani eisir be ginei; “Yem aim ben subu ete giengk nik me ma?” ");
INSERT INTO kbm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Beti eisir emb wenk ake ti ebe ande indu be yu yapin ok gitangi Ei. ");
INSERT INTO kbm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yisu geb wenk nok be gen nangge eisir tepwengge nas be eisir tepwe ili. ");
INSERT INTO kbm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bekob ginei gitangi eisir be ginei; “Warik Ayeu gavang gavin yem be ganei gitangi yem yapin, ve Mose be tis Pomate ane amolmol kulkul ane as yaun be tis yaun ebe giengk nangge Sam (Pesalem) ok, ebe inei gipil Ayeu ate ok atob ano nile.” ");
INSERT INTO kbm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Be Ei ginei ginei lavo gitangi eisir love kob ete itpweng yaun ebe warik Pomate ane amolmol kulkul ane iro ok are. ");
INSERT INTO kbm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bekob ginei gitangi eisir be ginei, “Yaun ete Pomate ane amolmol kulkul ane inei ok, gipil Ayeu roro-ngge. Ve yaun nok ginei dangeteik; ‘Amol ebe ve nemb amolmol dabin ok (Kilisi) atob ninggas vavavne be nimat vunu, be as mate ebe ve aitol ane ok okob atob matawe vukuri be nimdil nangge taku gimat ane ");
INSERT INTO kbm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Be atob yem unei mateu ve Ei ane gwangne nitangi amolmol walang ok, veik unro amolmol tiate ane aplos vukir, veik Pomate nemb eisir ru. Dangetok be yem unes kulkul etenik vu nimungg nangge Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Be yem ate atob unvang ve unei gen bambamo ebe uli uli ok binge nitangi amolmol nangge taku walang ok. ");
INSERT INTO kbm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Be Unaute! Gen ebe warik Tamangg ginei ane yaun ge gimungg ve atob nemb nitangi yem ok, ete atob ayeu namb nitangi yem nilek. Bemem yem unambweg ta-ngge nangge Jerusalem love un-gas gen etok (Ngalau Yamar) yapin kob unriv be unra.” ");
INSERT INTO kbm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yisu gigas ane singamolomb gen be ile ihlang ikwai Jerusalem be ve inde nam dabe ti are Betania. Be gitak bage giwei eisir be ges miengk giwei eisir. ");
INSERT INTO kbm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yisu ges miengk giwei ane singamolomb-gen givang nangge be seukie-ngge Pomate gigas Ei gikwai eisir be gireu gulumb gile. ");
INSERT INTO kbm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Eisir singamolomb inumul ile Jerusalem ok vukuri be tas vevias anongge. ");
INSERT INTO kbm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Be givin as mate walang ok eisir inum-numul lum yamar ge ve inei uye be es miengk gitangi Pomate be avos givwat Pomate are. ");
INSERT INTO kbm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Warik gimungg ane Pomate geb nalk ite nangge, be amol (propet) ti ebe ginei Pomate avo ok ei givang givin Pomate gimungg. Amol nok ei Pomate. ");
INSERT INTO kbm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Be ei givang givin Pomate. ");
INSERT INTO kbm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pomate gipasang gen walang ok ve Amol nok ane gwangne, be gen ti ei ate meng gihlang ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Be matawas ane dabe, ebe gilgum be amolmol imbweg matawas ok. ");
INSERT INTO kbm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Be Ei yev ebe giro gen aiweng tumi ane be bogbogo ok. ");
INSERT INTO kbm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bwayage kob Pomate gihlin ane amol kulkul ane ti are Jon be ginme, ");
INSERT INTO kbm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ve ninei yev nok ane yaun nitangi amolmol tepwengge be inaute veik aplos nivin. ");
INSERT INTO kbm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Be Jon ei ate ei yev etok ite ma, ei ginme ve ninei yaun yev nok ane ge nitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Amol nok atob ninme nalk be ane bogbogo atob niro amolmol nalk ane tepwengge weik ebe yev giro taku be bogbogo ok. ");
INSERT INTO kbm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Amol nok gibweg givin ebe Pomate gipasang nalk ok, bemem amolmol nalk ane tas gisgil ei. ");
INSERT INTO kbm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ei meng-gihlang ve ane bambamo-nggen nangge as nam, bemem ane bambamo-nggen bwais ve ret indi ei. ");
INSERT INTO kbm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bemem amolmol ebe iute ei ane yaun be aplos givin ok ge ete tas gitung ei giengk aplos. Beti ei ande giro eisir etok vukir be meihlang ve Pomate ane natu-nggen. ");
INSERT INTO kbm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eisir meihlang ve Pomate natu-nggen ve tamasgen tis tinasgen as twerk roro ite ma, be eisir tamasgen nalk ane ok ivang, bemem gisov ebe eisir aplos givin Pomate ok ane ge ete Pomate gital eisir ginei natu-nggen. ");
INSERT INTO kbm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Amol ebe ginei Pomate avo ok ete meng gihlang weik amolmol be givang givin amei. Amei ali ei ane gwangne ebe Tame tang givin ei be geb gwangne etok gitangi ei ok gikwai. Ei amol bwai bwaya be amol yaun ano ane roro. ");
INSERT INTO kbm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ginei yaun gipil Amol nok be ginei avo bamo ge be ginei; “Amol etenik ebe warik ayeu ganei ane yaun gitangi yem be ganei; ‘Amol ete ve nitau nile ayeu be ninme nik, ei ane gwangne gitlek awangg ok. Ve ayeu ok ma nangge be Amol nok gibweg gimungg givin ebe Pomate geb nalk ite nangge ok.’” ");
INSERT INTO kbm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eitit tepwengge tanggas gen vevies walang ok ginme nangge ei dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ve Mose geb yaun (bingsu) ebe Pomate geb gitangi ei ok ge gitangi eitit. Bemem yaun ano be tis gen vevies walang ok, ebe gitangi ve nemb eitit ru ok ete ginme nangge Yisu Kilisi dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Amol ti gili Pomate ite molge ma yapin. Pomate Natu dongke ebe gibweg gibloblo Tame ok ge ete ges Pomate ru gitangi eitit. ");
INSERT INTO kbm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Eisir Juda ihlin bambamo da ane be tis Liwi subu nangge Jerusalem be ile be iutani Jon be inei; “Mie amol ret?” ");
INSERT INTO kbm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jon ges yaun ti ta ite, be giwel eisir avos be ginei; “Ayeu amol (Kilisi) ebe ve namb amolmol dabin ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Be eisir iutani Jon vukuri be inei; “Mie gunei mie amol ebe ve nomb amolmol dabin ok ite, be mie amol ret? Mie Elia ebe warik Pomate ginei asonge nihlin be ninme ok me?” Be Jon giwel eisir avos be ginei; “Ayeu Elia ite ma.” Beti eisir inei gitangi Jon be inei; “Wat mie Pomate ane amol ti ebe gunei Pomate avo, weik ebe warik Mose ok me? Ebe Pomate ginei ve atob nihlin be ninme ok?” Be Jon ginei; “Ma, ayeu amol etok ite.” ");
INSERT INTO kbm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Beti eisir inei gitangi Jon be inei; “Dangetok be mie nunei im ate lavo nitangi amei kob nunei mie amol ret? Veik amei andumul ande be anei lavo nitangi amolmol ebe ihlin amei be anme ok?” ");
INSERT INTO kbm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon giwel eisir avos be ginei; “Warik Pomate ane amolmol kulkul ane ti are Aisai ginei yaun ti dang eteik, Amol ti atob nital yaun nangge taku sawa be ninei ‘Unpasang Amol Bamo ane luev ebe ve nivang ok vevie.’ Amol ete gital yaun nangge taku sawa ok ete ayeu nok eteik.” ");
INSERT INTO kbm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Beti eisir ebe Parisai ihlin is be ile ve inautani Jon ok, ");
INSERT INTO kbm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","inei gitangi Jon be inei; “Mie gunei mie amol ebe ve nomb amolmol dabin ok ite, be mie Elia ite be mie amol ebe ginei Pomate avo ok ite, be nam nambed be mie gos bui sanggu gipil amolmol?” ");
INSERT INTO kbm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon giwel eisir avos be ginei; “Ayeu gas bui sanggu gipil amolmol ve bui sin-ge. Bemem amol ti ete galkik givarkei givin yem, bemem yem utpweng ei are ite nik, ");
INSERT INTO kbm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ete amol nok atob nitau nile ayeu be ninme. Amol nok ei amol bamo, be ei ane gwangne gitlek awangg. Ayeu gen molok molok ti gitangi ebe ve nalgum ei ane kulkul ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yaun bambamo etok meng gihlang nangge Betania, gideb bui Joldan tavlu ane nangge taku ebe Jon ges bui sanggu gipil amolmol givang ok. ");
INSERT INTO kbm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Imdil as mate ti ane be Jon gili Yisu ebe givang gitangi ei gile ok be ginei; “Ta-undi! Pomate ane bwelk Sipsip ebe asonge nemb ate ve da be nimat vunu nangge nalk etenik ve amolmol tepwengge as tiate ane ok ete ginme nik. ");
INSERT INTO kbm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amol nok etenik ebe ayeu ganei ane yaun be ganei; ‘Amol ti ete atob nitau nile ayeu be ninme ok, ei ane gwangne gitlek awangg. Ve ayeu meng gahlang ite nangge be Amol etenik gibweg gimungg. Be amol nok ete eiate etenik.’ ");
INSERT INTO kbm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Be ayeu ok gali siti ite, asonge ei menihlang nam nambed? Bemem ayeu ganme ve nas bui sanggu nipil amolmol ve bui sin-ge, be nanei Ei ane yaun binge nitangi amolmol Israel ane veik inatpweng ei are.” ");
INSERT INTO kbm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Be Jon be ginei; “Ayeu gali Ngalau Yamar ebe geb na gile mank bubu be gisov nangge gulumb ginme giwei Ei ok, ");
INSERT INTO kbm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","be tis tangg gisgil ge ve wali amol ret dang etenik. Bemem amol ebe gihlin ayeu be ganme ve nas bui sanggu nipil amolmol ve bui sin-ge ok, ginei gitangi ayeu dang eteik; ‘Atob mie nuli Ngalau Yamar nisov ninme niwei amol ti, ok-ti amol etok ebe ve namb Ngalau Yamar nitangi amolmol ok.’ ");
INSERT INTO kbm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ayeu ate gali gen etok gikwai beti galkik ganei ane yaun gitangi yem, ve etenik Pomate Natu etenik.” ");
INSERT INTO kbm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Imdil tistumi ge be Jon tis ane singamolomb ailu inumul ile ivarkei lavos vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jon gili Yisu ebe givang gitangi sotol gile ok be ginei ve ane singamolomb ailu nok be ginei; “Pomate ane Amol (bwelk Sipsip) ebe atob nimat vunu ve amolmol tepwengge as tiate ane ok ete givang ginme nik.” ");
INSERT INTO kbm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon ane singamolomb ailu nok iute ebe Jon ginei dangetok ok, be gabu ile ivang mul ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yisu giro na vukir be gili sulu ebe ivang mul ve ei ok, be giutani sulu be ginei; “Amol gabu, yemlu urek ret?” Be sulu iwel Yisu avo be inei; Rabi (Gidung), wali mie guyengk? ");
INSERT INTO kbm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisu giwel sulu avos be ginei; “Gabu unme be undi.” Beti sulu ile love imbielk ve nam ebe Yisu gibweg ok be gabu imbweg ivin ei nangge etok. Ve sotol ivang love gibok okob imbielk. ");
INSERT INTO kbm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Amol ailu ebe iute Jon ane yaun be gabu ile ivang mul ve Yisu ok, as amol ti are Endru, Saimon Pita male. ");
INSERT INTO kbm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Endru nok gile gili kawe Saimon be ginei gitangi ei be ginei; “Ande amei ali Amol Bamo ebe ve nemb amolmol dabin ok, ebe ital giengk Grik avos ge inei Mesia ok gikwai.” ");
INSERT INTO kbm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bekob gigas ei be gabu itangi Yisu ile. Yisu gili ei be ginei; “Jon natu Saimon. Mul ane atob intal mie inei Sifas.” Tanro are etok vukir tanei “Pita.” Weik ebe “Vat” ok. ");
INSERT INTO kbm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Be imdil kob Yisu ta gitung ve nile Galilaia. Ei gile vunge ve Pilip be ginei gitangi ei; “Utau ile ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip nok ei amol Betsaida ane, nangge Endru gabu Saimon as nam. ");
INSERT INTO kbm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip gile vunge ve Natanael be ginei gitangi ei be ginei; “Ande amei ali Amol ebe warik Mose be tis Pomate ane amolmol kulkul ane inei ane yaun ok gikwai. Amol nok are Yisu Nasaret ane, be Josep ane natu ei.” ");
INSERT INTO kbm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael giwel Pilip avo be ginei; “Gen vie ti gitangi ebe atob menihlang nangge Nasaret ok ite ma yapin.” Be Pilip ginei gitangi Natanael be ginei; “Unme! Tale be uli kob.” ");
INSERT INTO kbm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yisu gili Natanael ebe givang ve ginme ok be ginei yaun gipil ei be ginei; “Amol etenik ei amol Israel ane roro, be yaun bingkasop ane ti giengk ei aplo ite molge.” ");
INSERT INTO kbm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ginei gitangi Yisu be ginei; “Mie gutpweng ayeu are nam nambed?” Yisu ginei gitangi ei be ginei; “Ayeu gali mie gimungg givin ebe guvarkei ei-nambwel dabe ane lu ok, bekob Pilip gital mie gideb mul ane.” ");
INSERT INTO kbm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael gikuri vunu-ngge be ginei gitangi Yisu be ginei; “Gidung! Pomate Natu mie, be mie Amol ebe ve nomb amolmol dabin nangge Israel ok etenik.” ");
INSERT INTO kbm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Be Yisu ginei; “Ayeu ganei ebe gali mie gimungg givin ebe guvarkei ei-nambwel dabe ane lu ok, beti wat mie aplom givin ayeu me? Asonge kob atob mie nuli gen bambamo subu nitlek etenik.” ");
INSERT INTO kbm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Be Yisu ginei gitangi ei be ginei; “Ayeu nanei bingano ge nitangi yem nanei, asonge yem undi gulumb ponge be atob undi Pomate ane angela atob insov be inpil inme inwei Pomate Natu ayeu ebe meng gahlang ve amolmol ok.” ");
INSERT INTO kbm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","As mate ailu gile gikwai be imdil ti ane kob, amolmol ilgum ben avie gabu amol ane nangge nam dabe ti are Kana-an gideb Galilaia ane. Be Yisu tine ok gile ve nili ben bamo etok givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Eisir emb yaun ginme ve Yisu tis ane singamolomb gen amei ve ande be anen ben etok anvin. ");
INSERT INTO kbm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Be amolmol inum wain ivang love ande wain nok ma, bekob Yisu tine gile ginei gitangi ei be ginei; “Ande eisir as wain ebe ve inum ok ma gikwai.” ");
INSERT INTO kbm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yisu giwel tine avo be ginei; “Avie, gen etenok giengk ayeu ik nangge. Ve saw a ebe ayeu ve nalgum gen bwal-bwale ok meng gihlang ite nangge.” ");
INSERT INTO kbm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bemem Yisu tine gile ginei gitangi amolmol yev ane be ginei; “Ginei ei ve ninei yaun ti nitangi yem, okob unsov ane lu ge be unalgum.” ");
INSERT INTO kbm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Be eisir Juda as ul nalk bambamo gitangi 6, ebe iker bui gisov be giengk ve ivarguv is ate gitangi Juda as luev ebe ilgum ilgum ok giengk. Ul nalk nok gitangi ebe ve inamsuli bui ul (baket) 10 me 15 nisov ul nok dongke dongke be nituvki nipil ok. ");
INSERT INTO kbm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisu ginei gitangi amolmol yev ane be ginei; “Unker bui isov ul nalk bambamo etok.” Eisir yev ane iker bui gisov ul bambamo nok love gituvki gipil ul avo. ");
INSERT INTO kbm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bekob Yisu ginei gitangi eisir be ginei; “Ande ma be unrau bui nok subu be unvwat untangi amol bwas ane unde.” Beti eisir yev ane isov Yisu ane yaun ane lu ge be irau bui nok subu be ivwat ile emb gitangi amol bwas ane. ");
INSERT INTO kbm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amol bwas ane ginum bui etok siti be gili weik ebe wain ok roro ngge, bemem ta gisgil ve wali bui nok ginme nangge inend. Bemem amolmol yev ane ebe ilgum kulkul ve irkwev bui etok ok, ge ete ande itpweng are. Beti amol bwas ane nok gital amol ebe ve nemb avie ok gile be ginei gitangi ei be ginei; ");
INSERT INTO kbm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Amolmol walang ok ilgum ben bambamo be emb wain ebe vevies ok gile gihlang be amolmol inum ulu. Bemem mie, mie gos wain vie etenik ta giengk love vasov gob gile gihlang.” ");
INSERT INTO kbm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yisu ane gen bwal bwale mate ane etok ebe gilgum ulu nangge Kana-an gideb Galilaia ane, be ges ane gwangne ru gitangi amolmol ve indi ok etok. Be ei ate ane singamolomb gen amei ok ali givin be aplongg amei givin ei. ");
INSERT INTO kbm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yisu gilgum gen bwal bwale etok gikwai, bekob tis tine-gen be male-nggen be ane singamolomb gen amei, asov ale Kapenaum be ambweg as mate subu nangge etok. ");
INSERT INTO kbm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gibloblo ve amolmol Juda ane inalgum as ben bamo ti ebe ital inei Pasova ok. (Eisir Juda ital as as mate etok inei Pasova, gisov eisir tas gitung as bambamo-nggen ebe warik Pomate ane angela ges is vun-kunu ite ok.) Beti Yisu gireu gile Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yisu gisov lum yamar aplo gile love gili amolmol ebe ilgum ivang ve ivgo gen be emb mone giwel ate, be tis eisir ebe inggas as bwelk bulimakao tis sipsip be mank ile ve inavgo ok, ilgum ivang lum yamar aplo. ");
INSERT INTO kbm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yisu geb bueng ti ve rauk be givin amolmol tis bwelk be mank ebe inggas ile ve inemb ve da ok, tepwengge ile ihlang ikwai lum yamar aplo. Be gitle amolmol mone ane as tebol tis mone vukir gile gitak nalk. ");
INSERT INTO kbm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Be ginei ve amolmol ebe inggas as mank ile ve inavgo ok be ginei; “Unvwat aim gen etok unde unahlang unkwai. Ret ginei beti yem ulgum Tamangg ane nam weik nam (sutua) ebe ve inavgo gen nangge ok?” ");
INSERT INTO kbm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Be givin sawa etok amei singamolomb tangg amei giro yaun ebe giengk Pomate ane kapia ok. Yaun nok ginei dangeteik: “Ayeu galgum kulkul bamo molge ve ganei Miam nam nimbweg vie ge.” ");
INSERT INTO kbm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eisir bambamo Juda ane ili ebe Yisu gitin eisir ile ihlang ikwai lum yamar aplo ok, beti ile inei gitangi ei be inei; “Mie ulgum gen bwal bwale ti be amei andi kob, veik anatpweng are anei mie gitangi ebe ve nulgum gen dang etenik ok?” ");
INSERT INTO kbm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yisu giwel eisir avos be ginei; “Atob yem unyaing lum yamar etenik nikwai, bemem atob ayeu napasang vukuri nitangi as mate aitol ge.” ");
INSERT INTO kbm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Be eisir Juda inei gitangi ei be inei; “Mie ebenok, amolmol ilgum kulkul bamo molge ve ipasang lum yamar bamo etenik gitangi Sonda bamo 46 bekob ete emb avwut. Be ande mie gunei atob nupasang lum yamar bamo etenik vukuri tis as mate aitol ge me-rav?” ");
INSERT INTO kbm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bemem Yisu ginei yaun etok gipil ei ate. ");
INSERT INTO kbm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Beti givin ebe Pomate ges Yisu itin vukuri nangge taku gimat ane ok, be givin etok ete amei singamolomb tangg amei gitung gile yaun ebe warik ei ginei ok, be aplongg amei givin Pomate ane yaun ebe giengk ane kapia ok be tis yaun ebe Yisu ei ate ginei ok. ");
INSERT INTO kbm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yisu gibweg nangge Jerusalem ve gili Juda as Sonda ebe ital inei Pasova ok, be ei gilgum gen bwal bwale walang ano be amolmol anongge ili love aplos givin ei. ");
INSERT INTO kbm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bemem Yisu ta gitung eisir as aplos givin etok bamo molge ite ma, ");
INSERT INTO kbm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ve gisov ei gitpweng amolmol tepwengge ar-kare be ma gikwai. Ei gitpweng amolmol walang ok as luev are be ma gikwai, be amol ti gitangi ebe atob ninei amolmol as luev lavo lavo nitangi ei ok ite ma yapin. Ei gitpweng amolmol tepwengge as tas gitung are gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisai amol ti gibweg etok, are Nikodimos. Be ei Juda as awaga ti. ");
INSERT INTO kbm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Amol nok givang gitangi Yisu gile givin tambok ti be ginei gitangi ei be ginei; “Gidung, amei atpweng are gikwai anei Pomate gihlin mie beti gunme. Ve amol ebeok ti gitangi ebe atob nilgum gen bwal bwale bambamo dang dang ete mie gulgum nik ite ma yapin. Pomate nivang nivin ei be nemb ane gwangne nitangi ei okob.” ");
INSERT INTO kbm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Be Yisu ginei gitangi ei be ginei; “Ayeu nanei bingano ge nitangi mie nanei, amol ti ginei giro ate vukir be meng gihlang weik ete nunus muele ok ite, atob ei nili Pomate ane taku ebe gibweg ok ite molge.” ");
INSERT INTO kbm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimos giwel Yisu avo be ginei; “Amol bamo ti gitangi ebe ve nisov tine subwe aplo nile bekob tine nikuv ei vukuri ok nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yisu giwel ei avo be ginei; “Ayeu nanei bingano ge nitangi mie nanei, amol ti ginei niringk bui sanggu ite be Ngalau yamar ane gwangne niro ei vukir be menihlang weik ete nunus muele ok ite, atob ei nisov Pomate ane taku nile ite molge. ");
INSERT INTO kbm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Gen ete utlas ulis geb ok etok gen ulis ane ge be etok gitangi ite. Bemem gen ete Ngalau geb ok etok gen Ngalau ane, be Ngalau ane gwangne givang givin gen etok. ");
INSERT INTO kbm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mie avom poke be nulat bagem ve yaun ete ayeu ganei gitangi mie nik ane bwaya. Yem tepwengge unro aim ate vukir be monahlang weik ete nunus muele ok vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wavin gituvki be mie gute ebe vu-vuvunge ok ge, bemem tam gisgil ane dabe ebe gimdil nangge ok, be gile gimat giengk inend etok mie tam gisgil weik etok ge. Be Ngalau Yamar ane kulkul ebe giro amolmol vukir ok ane luev weik ete wavin ok.” ");
INSERT INTO kbm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimos ginei gitangi Yisu be ginei; “Gen etok atob menihlang nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yisu giwel Nikodimos avo be ginei; “Amolmol Israel ane as gidung mateu ane mie, bemem wat gutpweng gen etenik are ite me? ");
INSERT INTO kbm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ayeu nanei bingano ge nitangi mie nanei; Amei anei yaun gipil gen ebe ali be atpweng are ok. Bemem yem bwaingg aim be uvkir dumangg aim gitangi yaun ete amei anei ok. ");
INSERT INTO kbm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ayeu ganei yaun gipil gen nalk ane be yem aplongg aim givin ite. Be ginei ayeu nanei yaun nipil gen gulumb ane, okob atob yem gitangi ebe ve aplongg aim nivin ok me ma? ");
INSERT INTO kbm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Amol ti gile ete gulumb ok ite molge ma yapin. Pomate Natu ayeu dongke-ngge, ebe meng gahlang ve amolmol ok ge ete gasov nangge gulumb meng gatak nalk. ");
INSERT INTO kbm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Warik Mose ges muwat dalgo gireu ei-givsangin nangge taku sawa, veik ginei amol ti matano nitut nimbweg muwat dalgo ete Mose ges gireu ei-givsangin gile ok, okob amol etok atob nimat vunu mang-mangi ge ite ma. Dang etok be asonge amolmol valir ane ines Pomate Natu ayeu ebe meng gahlang ve amolmol ok nireu ei-givsangin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Be amolmol tepwengge ebe aplos givin ayeu ok, ete atob inmat vunu mang-mangi ge ite ma, atob matawas be inamdil vukuri be atob inambweg matawas nemb ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ve Pomate ta givin amolmol tepwengge nangge nalk gitlek molge, beti geb Natu dongke ge etok ginme veik amolmol aplos nivin ei, be in-gas ebe ve inambweg matawas nemb ta ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pomate gihlin Natu ginme nalk ve niute be nipasang amolmol nalk ane as yaun, weik amol ebe giute giute amolmol as yaun ok ite ma. Ei gihlin Natu be ginme ve nemb amolmol ru. ");
INSERT INTO kbm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Amolmol ebe aplos givin ei ok, ete yaun ti giengk ite. Bemem amolmol ebe aplos givin ei ite ok, ete galkik ivang tis yaun ge ivang nik. Ve gisov eisir bwais ve ret aplos nivin Pomate Natu dongke ge etok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pomate atob niute amolmol as yaun be nemb vavavne nitangi amolmol, ve gisov Ei geb ane bogbogo ginme nalk gikwai ve niro amolmol. Bemem amolmol bwais ve invang insov bogbogo etok aplo, eisir tas givin ve invang insov aiweng tumi ge aplo veik inalgum gen ungglus ungglus painge invang. ");
INSERT INTO kbm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Amolmol tepwengge ebe ilgum gen ungglus ungglus ok, eisir bwais ve ret yev niro is velob amolmol indi gen ebe eisir ilgum ilgum ok. ");
INSERT INTO kbm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bemem amolmol ebe ivang mul ve luev yaun ano ane ok ete emb as kulkul ivang gitip gitip ge, veik amolmol indi be inatpweng are inei Pomate giro eisir ta ve ane gwangne be eisir ivang isov Pomate ane lu ge. ");
INSERT INTO kbm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yisu ginei yaun etok gikwai kob tis ane singamolomb-gen amei amdil ale Juda as taku. Be nangge etok amei singamolomb algum kulkul ve as bui sanggu gipil amolmol. ");
INSERT INTO kbm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Be amolmol anongge itangi Jon ile ve inringk bui sanggu, beti Jon ges bui sanggu gipil eisir nangge Inon, gibloblo Salim as taku. ");
INSERT INTO kbm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Givin sawa etok Herodes gitak Jon gisov kapual-lu ite nangge. ");
INSERT INTO kbm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon ane singamolomb-gen es valir ve yaun ge gitangi amol Juda ane ti, gisov eisir Juda as luev ebe ivarguv is ate gimungg bekob en ben ok ane. ");
INSERT INTO kbm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bekob eisir singamolomb nok itangi Jon ile be inei Yisu ane yaun gitangi ei be inei; “Gidung, Amol ebe warik yemlu aim gabu uvang dongke nangge Bui Joldan tavlu ane be mie gunei yaun gipil ei ok eteok. Amol nok ges bui sanggu gipil amolmol givin weik etok ge, be ande amolmol tepwengge bwais ve eitit be ivang itangi ei ge ile.” ");
INSERT INTO kbm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Beti Jon giwel ane singamolomb-gen avos be ginei; “Pomate dongke ge ebe gibweg gulumb ok ete geb ane gwangne gitangi ayeu be amolmol subu givin weik etok ge ve analgum ei ane kulkul. ");
INSERT INTO kbm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Be warik ayeu ganei yaun ti gitangi yem dang eteik; ‘Ayeu amol (Kilisi) ebe ve namb amolmol dabin ok ite ma. Bemem Pomate gihlin ayeu be gamungg ganme ve nanei Amol nok binge nitangi amolmol.’ ");
INSERT INTO kbm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Be Jon ginei bing ai ti gipil sulu Yisu be ginei; Amol ebe veve nemb avie ok ti givang be amol nok ane nune ti gibweg love giute ebe ane nune etok ve nemb avie ok binge be ta vevie anongge. Be Jon ginei, dang etok be ande ayeu tangg vevie anongge ve amol ebe ve ninggas ane amolmol gen ok ande ginme gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Amol nok ei amol tis are be ayeu gen sin-ge. ");
INSERT INTO kbm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Amol ebe ginme nangge ei-goto ok ete geb gen walang ok dabin. Be amol ebe meng gihlang nangge nalk ok, etok ei amol nalk ane be ei ginei yaun gipil gen nalk ane ge. Be gen bambamo etenik as Amol Bamo dongke amol ete ginme nangge gulumb ok. ");
INSERT INTO kbm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Amol nok ginei yaun gipil gen ebe ei gili be giute ok ge, bemem amol ti gipasang yaun bambamo ete ei ginei ginei ok giengk aplo ite molge. ");
INSERT INTO kbm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bemem amolmol ebe iute ei ane yaun be ipasang giengk aplos ok, ete inei dang etok inei bingano, Pomate ei Amol yaun ano ane. ");
INSERT INTO kbm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Amol ete Pomate gihlin be ginme ok, ei ginei yaun ebe giute nangge Pomate avo ok ge gitangi amolmol. Ve gisov Pomate geb Ngalau Yamar ungglus ge gitangi ei beti ginme. ");
INSERT INTO kbm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tame ta givin Natu etok gitlek molge be geb gen tepwengge gitangi Natu gile ve nemb dabin. ");
INSERT INTO kbm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dang etok be amolmol ebe aplos givin Pomate Natu etok ok, ete galkik ande inggas ebe ve inambweg matawas nemb ta ge ok gikwai. Be amolmol ebe isov Ei ane yaun ane lu ite ok, ete gitangi ebe atob inambweg matawas nemb ta ge ok ite ma. Eisir ande ivang isov Pomate ane ta vavis aplo gikwai be ete ivang nik. ");
INSERT INTO kbm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Givin sawa etok eisir Parisai iute inei yaun ti dang eteik inei; “Yisu giro amolmol anongge vukir be meihlang ve ane singamolomb-gen, be ges bui sanggu gipil amolmol anongge molge gitlek Jon.” ");
INSERT INTO kbm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Bemem Yisu ei ate bage ges bui sanggu gipil amolmol ite ma, ei ane singamolomb-gen ge es bui sanggu gipil amolmol. ");
INSERT INTO kbm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yisu giute ebe eisir Parisai iute yaun avo dangetok ok, beti gimdil gikwai Juda as taku be gilumul gile Galilaia vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yisu ta gitung ve nitau nile luev ebe givang gitangi Samaria as taku ane ok nile. ");
INSERT INTO kbm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ei givang love gibielk ve Samaria as nam dabe ti ital inei Saika. Nam dabe nok giengk gibloblo nalk walo ti ebe warik Jakob geb gitangi natu Josep ok. ");
INSERT INTO kbm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Be bui dedemk ti ebe warik Jakob gitav ok ete giengk taku etok. Yisu givang love ande as mate luvwe be gikwes anongge, beti gile gibweg gibloblo bui dedemk nok. ");
INSERT INTO kbm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Be Samaria avie ti gile ve nirkwev bui nangge bui dedemk nok be Yisu ginei ve avie nok be ginei; “Uvwat bui unme be muanum subu kob ve ayeu bui ges-au.” ");
INSERT INTO kbm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yisu ane singamolomb gen ande imungg ile ihlang ebe nam ok ve ivgo as ben. ");
INSERT INTO kbm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria avie nok giwel Yisu avo be ginei; “Mie Juda, be ayeu avie Samaria ane be nam nambed be mie gutani ayeu ve bui luvus ane?” Eisir Juda tis Samaria en be inum gen gisov dongke ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yisu giwel avie nok avo be ginei; “Ginei mie nutpweng gen vevies bambamo ebe Pomate geb sin sin-ge be nutpweng tis Amol ete giutani mie ve bui luvus ane nik are, atob mie nutani ei be nemb bui matawas ane nitangi mie.” ");
INSERT INTO kbm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Be avie nok ginei; “Amol Bamo, nalk avo ebe bui dedemk etenik meng gihlang nangge ok gile gulunge molge be mie ul ma ebe ve nutu nisov nile be nukating bui ok, be wali atob mie nuvwat bui ebe tis dabe ok nangge inend? ");
INSERT INTO kbm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Eitit tumbund Jakob bamo gipasang bui dedemk etenik be geb gitangi amei, be warik ei ate tis natu-nggen be ane bwelk bulimakao tis sipsip inum bui nangge bui dedemk dongke etenik ge. Be mie wat gulgum ve nulgum im-ate weik ebe amol bamo ti ok nutlek ei me?” ");
INSERT INTO kbm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Beti Yisu giwel avie nok avo be ginei; “Amol ti ginei ninum bui etenik, atob bui nes ei vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bemem ginei amol ti ninum bui ete ayeu ve namb nitangi ei ok, atob bui nes ei vukuri ite. Ve bui ete ayeu ve namb nitangi avie me amol etok ok, atob menihlang weik ebe bui dedemk ok nangge amol me avie etok aplo.” ");
INSERT INTO kbm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Be Samaria avie nok tis ta gisgil ate ge, be ginei; “Amol Bamo, omb bui etok inme ayeu anum ma, veik bui es-au be nanumul nanme etenik ve narkwev bui vukuri bwaya.” ");
INSERT INTO kbm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Be Yisu ginei gitangi ei; “Ule utal arwem be gabu undumul unme etenik bekob.” ");
INSERT INTO kbm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Be avie nok ginei; “Ayeu gab amol ite.” Be Yisu ginei gitangi ei; “Mie gunei mie gob amol ite, etok mie gunei gile gitangi roro-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ve warik mie guvang guvin amol bage tavlu, be amol ete galkik mie guvang guvin nik etok miam amol roro ite ma. Be mie gunei gile gitangi ve mie amol ma.” ");
INSERT INTO kbm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Beti avie nok ginei gitangi ei be ginei; “Amol Bamo, ande ayeu gatpweng mie are, mie Pomate ane amol (profet) kulkul ane ti. ");
INSERT INTO kbm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Amei tumbungg amei gen iro is ate sut ile matendubi etok ve inei uiye be es miengk gitangi Ei nangge etok. Bemem yem amolmol Juda ane unei taku ebe ve tanei uiye be tanes miengk nitangi Pomate ok, giengk Jerusalem dongke ge.” ");
INSERT INTO kbm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yisu giwel avie nok avo be ginei; “Avie, aplom nivin awangg yaun ge! Asonge as mate ti atob yem unes miengk nitangi Tamangg nangge matendubi etenik me nangge Jerusalem ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yem Samaria ane os miengk gitangi amol ebe utpweng ei are vevie ite, be amei Juda amei as miengk gitangi amol ebe atpweng ei are ok. Ve kulkul ebe Pomate gilgum ve nemb amolmol ru ok, kulkul etok meng gihlang nangge amei Juda ulu. ");
INSERT INTO kbm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bemem ginei sawa etok menihlang, be ande meng gihlang gikwai, be atob ammolmol ebe aplos givin Pomate ok atob inei uiye be ines miengk nitangi Pomate ve Ngalau Yamar tis yaun ano ge. Ve Tamangg ta givin amolmol dang dang etok ge inei uiye be ines miengk nitangi ei. ");
INSERT INTO kbm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pomate ei Ngalau, dang etok be ginei amolmol veve inei uiye be ines miengk nitangi ei, ok ti inei uiye be ines miengk tis Ngalau be tis yaun ano ror ge nitangi ei.” ");
INSERT INTO kbm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Be Samaria avie nok ginei; “Galkik ande ayeu gatpweng are ganei asonge Amol ebe ve nemb amolmol dabin ok, ebe ital giengk Grik avos ge inei Kilisi ok ginei ninme, atob ei ninei gen walang ok binge nitangi amei.” ");
INSERT INTO kbm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Be Yisu ginei gitangi ei be ginei; “Amol ebe ve nemb amolmol dabin ok ete Ayeu nok ete kakie gavin mie nik.” ");
INSERT INTO kbm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Be givin sawa etok ge eisir singamolomb imbielk be ikuri vunungge ve ili ebe Yisu kakie givin avie etok ok. Ve eisir Juda as luev ti giengk dang etok ginei amolmol ebe inei mateu gitangi amolmol ok, atob kakie invin avie gaptol nangge luev sawa ite ma. Bemem eisir singamolomb nok as amol ti giutani avie nok me giutani Yisu ve ebe kakie givin avie etok ve ret ane ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bekob avie nok gitak ane bui tis ul giengk be ginumul gile nam ok, gile ginei gitangi amolmol be ginei; ");
INSERT INTO kbm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Unme tale be undi amol eteik okob, ei ginei awangg gen bambamo ebe warik galgum be gavuaivun ge ok binge gitangi ayeu ate vukuri. Be wat ei amol (Kilisi) ebe ve nemb amolmol dabin ok me?” ");
INSERT INTO kbm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Beti amolmol tepwengge imdil be itangi Yisu ile. ");
INSERT INTO kbm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Be eisir singamolomb inei ve Yisu be inei; “Gidung, mie on ben kob ma!” ");
INSERT INTO kbm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bemem Yisu giwel eisir avos be ginei; “Awangg ben ete giengk nik, yem utpweng awangg ben etok are ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Beti eisir singamolomb inei ve is ate be inei; “Amol ti ande wat giwat ben ve ei ginme me?” ");
INSERT INTO kbm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Beti Yisu ginei gitangi ane singamolomb-gen be ginei; “Awangg ben ebe ve nan ok ete dang eteik: Ayeu nasov Amol ebe gihlin ayeu be ganme ok ane yaun ane lu ge be nalgum kulkul ebe ei geb gitangi ayeu ok love nas vunu kob. ");
INSERT INTO kbm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","As mate subu yem unei dang eteik unei; ‘Aiweng aivat ge giengk ebe ve tanro ben ano sut nisov nam ben ano ane nile ok.’ Dang etok be ayeu nanei nitangi yem, ta-unemb nangg aim itin be unatlo um walang ok vevie be undi kob, ve ben ande gipasang ate gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Amol ebe geb kulkul ve giro ben matawas ane sut ok, atob ninggas ane kulkul etok ane ano. Veik sulu amol ebe givro ben ok atob tas vevias invin is ate. ");
INSERT INTO kbm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Beti yaun ebe amei anei ve amol ti atob nivro ben nimungg nimungg be amol ti atob ninggas ben etok ane ano nitau nile ok, yaun etok ande ano gile. ");
INSERT INTO kbm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ayeu gahlin yem ve unde be unro ben ano sut nangge um ebe amolmol subu ilgum kulkul ve ivro ok. Be um nok yem ulgum ane kulkul ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Amolmol Samaria ane anongge nangge nam dabe etok iute ebe avie etok ginei Yisu ginei ei ane gen bambamo ebe gilgum gilgum ok binge gitangi ei ate vukuri ok, beti eisir aplos givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Be ile inei gitangi Yisu ve nimbweg nivin eisir siti bekob. Beti Yisu gibweg etok givin eisir gitangi as mate ailu. ");
INSERT INTO kbm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Amolmol anongge molge iute yaun ebe Yisu ei ate ginei gisov avo ok, be aplos givin Yisu, be ile inei gitangi avie galkok be inei; “Amei aplongg amei givin Yisu ve gisov yaun ete mie gunei gitangi amei ok ane ge ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bemem amei ate aute yaun ebe ei ginei ginei ok beti atpweng are anei Amol etenik ebe ve nemb amolmol nalk ane dabin ok bingano ge. ");
INSERT INTO kbm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","As mate ailu etok gile gikwai kob Yisu gimdil nangge nam etok be gile Galilaia. ");
INSERT INTO kbm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yisu ei ate avo ukwas ti ebe ginei ok dang eteik; “Pomate ane amolmol (profet) kulkul ane ti ginei nile nimbielk ve ane bambamo gen nangge ei ate ane nam, atob ane bambamo gen tas vevias be avos nivwat ei are ite ma.” Beti Yisu ta gitung ve nile Galilaia, ve ei gitpweng are gikwai ginei amolmol Galilaia ane atob tas vevias be avos nivwat ei are. ");
INSERT INTO kbm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yisu gibielk Galilaia be amolmol ili ei be tas vevias anongge, ve gisov eisir itpweng ei are gikwai givin ebe ireu ile Jerusalem ve Juda as Sonda Pasova ane, be ili gen bambamo ebe ei gilgum ok gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bekob Yisu gimdil nangge etok vukuri be ginumul gile Kana-an ebe warik giro bui vukir be meng gihlang weik wain ok vukuri. Be nangge Kapenaum amol bamo (king) ti ane amol ebe geb amolmol dabin ok natu gigas gimat be giengk. ");
INSERT INTO kbm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Amol nok giute ebe ande Yisu gikwai Judaia as taku be ginme gibweg Galilaia ok binge, beti ei givang gitangi Yisu gile be ginei gitangi ei ve nisov nile Kapanaum be nilgum ei natu be utle vie kob. Ve amol nok natu gigas gimat love kasop ge be nimat vunu. ");
INSERT INTO kbm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yisu ginei gitangi amol nok be ginei; “Yem ulgum ve unei undi gen bwal bwale ebe ayeu galgum ok veik aplongg aim nivin ayeu. Be bwaingg aim ve ret unaute awangg yaun ge be aplongg aim nivin ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bemem amol nok giwel Yisu avo be ginei; “Amol Bamo, unme be tale seukie-ngge velob amol natu nimat vunu.” ");
INSERT INTO kbm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Beti Yisu ginei gitangi ei be ginei; “Ule! Ve natum atob nimbweg matawe.” Amol nok giute Yisu ane yaun ge be ginumul gile. ");
INSERT INTO kbm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Be givin tistumi amol nok givang luev ge nangge be ei ate ane amolmol kulkul ane ile vunge ve ei nangge luev be inei; “Natum ande utle vie.” ");
INSERT INTO kbm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Beti amol nok giutani eisir ve as matano ret be amol natu ane gimat gituvi. Be eisir inei gitangi ei be inei; “Ei ane gimat gituvi givin nolik as mate luvwe.” ");
INSERT INTO kbm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Beti amol natu nok tame gitpweng are ve nolik as mate luvwe dang etok be Yisu ginei gitangi ei be ginei; “Mie natum atob nimbweg matawe.” Beti amol nok tis arwe-nggen be natu-nggen be ane bambamo-nggen tepwengge aplos givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisu gimdil gikwai Juda as taku be gile Galilaia ok, okob ete gilgum gen bwal bwale bamo etok. ");
INSERT INTO kbm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yisu gilgum gen bwal bwale bamo etok gikwai, bekob sawa ebe amolmol Juda ane ve indi as Sonda Pasova ok meng gihlang beti Yisu gireu Jerusalem gile. ");
INSERT INTO kbm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Be nangge Jerusalem nok ete bui kapul ti giengk etok gibloblo bwelk sipsip as nam avo ge. Ital bui kapul nok giengk Hibru avos ge inei Betesda. Be nangge bui kapul nok kire ete ipasang samuak gitangi bage tavlu (5) giengk etok. ");
INSERT INTO kbm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Be amolmol anongge ebe tis gimat ok, be tis amolmol ebe matanos bop ok be eisir ebe vas tiate ok, be tis amolmol ebe vas be bais gimat ok, ile ve imbweg samuak nok. (Eisir imbweg etok ve isge bui kapul nok ebe ve vil-vilinge ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ve givin sawa dongke dongke atob Pomate ane angela ti nisov nile be niyimb nisov bui kapul nok nile be nilgum bui be vil-vilinge. Bui vil-vilinge etok ma nikwai kob ginei amol gimat ti vepie nisov bui nok nile ulu, okob gimat ret ete gigas ei ok atob ma nikwai be atob ei utle vie vukuri.) ");
INSERT INTO kbm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Be amol gimat ti gibweg gibweg samuak etok ve gisge gisge bui ebe ve vil-vilinge ok, amol nok ane gimat etok giengk gitangi Sonda bamo 38. ");
INSERT INTO kbm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisu gili amol nok be gitpweng are ginei ei gigas gimat etok muang-gane molge. Beti giutani amol gimat nok be ginei; “Mie tam givin ve utlem vie vukuri me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Amol gimat nok giwel Yisu avo be ginei; “Amol Bamo, awangg nune ti ebe ve nemb ayeu ru be nale nasov bui ulu ok gibweg ite ma. Be ayeu ok lo-longg painge ge ve ganei nale nasov bui ulu, bemem galgum be gitangi ite ve amol ti gitlek ayeu be gile vepie gisov bui ulu.” ");
INSERT INTO kbm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Beti Yisu ginei gitangi amol nok be ginei; “Umdil be uvwat am yemb be uvang.” ");
INSERT INTO kbm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Be seukie-ngge amol nok utle vie be givwat ane yemb be givang ve gile. Yisu gilgum gen bamo etok givin Juda as Sonda Sabat. ");
INSERT INTO kbm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Beti eisir Juda ile inei gitangi amol gimat ebe galkik utle vie ok be inei; “As mate etenik, etek Sonda Sabat be gitangi ebe atob mie nulgum kulkul ve nuvwat amb yemb be nuvang luev ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bemem amol nok giwel eisir Juda avos be ginei; “Amol ebe gilgum be ayeu utlangg vie ok ete ginei gitangi ayeu ve navwat angg yemb be navang.” ");
INSERT INTO kbm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Be eisir inei gitangi ei be inei; “Amol ret ete ginei gitangi mie ve nuvwat am yemb be nuvang ok?” ");
INSERT INTO kbm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bemem amol ebe galkik Yisu gilgum utle be vie ok ta gisgil ge, ve amolmol anongge molge nangge nam dabe etok be Yisu ande gimumu ate ge be gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bwayage kob Yisu gili amol nok vukuri nangge lum yamar aplo be ginei gitangi ei be ginei; “Ute kob! Ande mie utlem vie gikwai, be nu-numul nule be nulgum tiate vukuri ite. Velob mie nunggas vavavne bamo molge nitlek ete warik mate ane ok.” ");
INSERT INTO kbm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Bekob amol nok gile be ginei gitangi eisir Juda be ginei; “Etok Yisu ete walirik gilgum be ayeu utlangg vie ok.” ");
INSERT INTO kbm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Beti eisir Juda imdil be ilgum ve ines Yisu, ve eisir ili etok tiate ve Yisu gilgum gen etok givin Sonda Sabat. ");
INSERT INTO kbm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bemem Yisu gimdil be giwel eisir avos be ginei; “Tamangg geb ane kulkul painge love galkik as mate etenik ok givin, dang etok be Ayeu ok atob namb angg kulkul painge weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yisu ginei yaun etok gile be gilgum eisir Juda tepwengge aplos tiate molge be veve ines Ei vunu ge nikwai, ve gisov ebe ei gilgum kulkul givin Sonda Sabat ane ge ok ite ma. Bemem gisov ebe ei gilgum ate weik Pomate be ginei Pomate ane Natu ei ok givin. ");
INSERT INTO kbm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Beti Yisu giwel eisir avos be ginei; “Ayeu nanei bingano ge nitangi yem nanei Pomate Natu ayeu galgum gen gitangi ebe ayeu ate angg tangg gitung ok ite ma. Ayeu galgum gen ebe Tamangg gilgum be ayeu gali ok ge. Be gen ete Tamangg gilgum ok ete Natu ayeu ok galgum givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamangg ta givin Natu ayeu anongge molge, beti ges gen bambamo ete ayeu galgum galgum ok ru gitangi ayeu ve nalgum. Be atob ei nes gen bambamo subu ebe gitlek etenik ok ru nitangi ayeu be nalgum, kob atob yem avongg aim poke ge be tangg aim nitung walang ano. ");
INSERT INTO kbm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tamangg ges amolmol ebe nolge imat vunkunu ok itin be imbweg matawas vukuri. Dang etok be Natu ayeu ok atob nas amolmol ebe ayeu tangg givin eisir ok itin be inambweg matawas weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Be Tamangg wat atob nilgum amolmol as yaun vukuri ite ma, ve ande ei geb kulkul ete ve niute amolmol as yaun ok tepwengge gisov Natu ayeu baingg gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Be atob amolmol tepwengge avos nivwat Pomate Natu ayeu arengg, dangete avos givwat Tamangg are ok weik etok ge. Amol ti ginei avo givwat Pomate Natu ayeu arengg ite, okob etok weik ebe ei avo givwat Tamangg ebe gihlin Ayeu be ganme ok are ite ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Bingano, Ayeu nanei bingano ge nitangi yem nanei; Amol ete giute awangg yaun be aplo givin Amol ebe gihlin ayeu be ganme ok, amol etok ande gigas ebe ve nimbweg matawe ninggas ta ge ok gikwai. Be Pomate wat nilgum ei ane yaun nindeb mul ane ite ma, ve galkik etenik ande tanmat vunu ane gwangne geb ei ta vukuri ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Bingano, Ayeu nanei nitangi yem nanei as mate ti atob ninme, be sawa nok ande ginme gikwai. Be atob amolmol ebe asonge inmat vunu mang-mangi ge ok atob inaute Pomate Natu ayeu avongg. Be eisir ebe iute be aplos givin ok ete atob in-gas ebe ve inambweg matawas ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Inambweg matawas ane dabe giengk Tamangg dongke ge. Be ei geb gwangne gitangi Natu ayeu beti ayeu ok luev ebe ve inambweg matawas ok weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pomate Natu ayeu roro, meng gahlang weik ebe amolmol ok. Beti Tamangg geb ane gwangne gitangi Ayeu ve nalgum be naute amolmol as yaun be napasang. ");
INSERT INTO kbm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Avongg aim poke bwaya. Sawa etok ginei gibielk, atob amolmol tepwengge ebe iyengk taku gimat ane ok atob inaute Ayeu avongg, ");
INSERT INTO kbm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","okob atob inamdil inkwai nalk avo be meinahlang. Amolmol ebe es as luev vie ge ok, atob inamdil be inambweg matawas vie-ngge. Be eisir ebe ivang mul ve luev gen tiate ane ok ete atob inamdil be inde invarkei Pomate na be inei as yaun lavo lavo. ");
INSERT INTO kbm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ayeu galgum gen ti gitangi ebe ayeu ate ge angg tangg gitung ok ite ma, ayeu galgum amolmol as yaun gitau gile luev ebe Tamangg geb gitangi ayeu ok ge. Beti awangg luev ebe gapas pasang amolmol as yaun ok vie be roro dongke. Ve gisov Ayeu galgum gen ti gitangi ebe angg tangg gitung ok ite ma. Ayeu galgum gen givang mul ve Amol ebe gihlin ayeu be ganme ok ge ane ta gitung. ");
INSERT INTO kbm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ginei ayeu ate navarkei be nanei au-ate lavo nitangi yem, okob etok gitangi ginei yem undi awangg yaun weik gen sin-ge. ");
INSERT INTO kbm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bemem amol ti ete givang nik, be amol nok ete ginei ayeu lavo gitangi yem. Be yaun ete ei ginei gitangi yem gipil ayeu ok, yaun etok ano molge ve ayeu ate ok gali givin. Be amol nok ete Pomate ei ate. ");
INSERT INTO kbm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Warik yem omb yaun gile ve Jon, be Jon ginei yaun vusa ge gipil yaun ano. ");
INSERT INTO kbm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ayeu tangg gitung ete amol ve nimdil be ninei yaun nipil ayeu ok bamo molge ite ma. Bemem ayeu tangg givin anongge ve ganei Pomate nemb yem ru ge, beti ganei yaun etenik. ");
INSERT INTO kbm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ei weik ebe yev ok, be ei ane aivi giro yem weik ebe lam giro be ane bogbogo ok be yem tangg aim vevie sawa sitingge ve ei ane gen vevies ebe gilgum ok ane. ");
INSERT INTO kbm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bemem gen ebe vie molge gitlek Jon, be ginei ayeu lavo ok eteik; Kulkul bambamo ebe Tamangg geb gitangi ayeu ve nalgum love nas vunu ok, kulkul etok ete ayeu galgum painge ge gavang nik. Be kulkul etok ge ete ginei ayeu lavo gitangi amolmol be galkik ande eisir itpweng are inei Tamangg gihlin ayeu beti ganme. ");
INSERT INTO kbm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Be Tamangg ebe gihlin ayeu be ganme ok, ei ok ginei ayeu lavo givin weik etok ge, bemem yem ute ei avo siti ite molge. Yem uli ei na ite ma molge, ");
INSERT INTO kbm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","be upasang ane yaun ti giengk aplongg aim ite weik etok ge. Ve gisov yem bwaingg aim ve ret aplongg aim nivin amol (ayeu) ete Tame gihlin be ginme ok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yem tangg aim gitung dang eteik unei yaun ebe Pomate ane amolmol kulkul ane inei ok ge ete gitangi ebe ve niro yem be unambweg matawangg aim nemb ta ge ok. Beti lolongg aim painge ge ve utau gile yaun bambamo etok. Be yaun bambamo etok ete ginei ayeu lavo givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bemem yem bwaingg aim ve ret untangi ayeu unme, be un-gas ebe ve unambweg matawangg aim nemb ta ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ayeu bwaingg ve ret amolmol avos nivwat ayeu arengg. ");
INSERT INTO kbm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bemem yem, ayeu gatpweng yem are gikwai ve yem aim tangg aim givin Pomate ane giengk aplongg aim ite yapin. ");
INSERT INTO kbm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tamangg gihlin ayeu beti ganme, bemem yem bwaingg aim ve unaute awangg yaun. Bemem ginei amol ti nilgum ve avo nivwat ate be nitangi yem ninme, atob yem unpasang aim ate seukie-ngge ve unaute amol etok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yem tangg aim givin ve amolmol ge indi yem vie be avos nivwat yem arengg aim, be bwaingg aim ve ret Pomate dongke ge avo nivwat yem arengg aim. Be ginei dang etok, okob atob yem aplongg aim nivin Pomate nam nambed? ");
INSERT INTO kbm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lob yem tangg aim nitung unei atob ayeu namb yem aim yaun nitangi Tamangg nile, bemem ma. Amol ebe ve nemb yem aim yaun nitangi Pomate nile ok ete Mose, ebe yem tangg aim giluni ei ve nemb aim ru ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bingano, ginei yem aplongg aim nivin Mose ane yaun, atob yem aplongg aim nivin ayeu weik etok ge. Ve etok awangg yaun bambamo ete Mose giro bwalbwale be geb gitangi yem ok. ");
INSERT INTO kbm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bemem ginei yem aplongg aim nivin yaun ete Mose giro bwalbwale ok ite, okob atob aplongg aim nivin awangg yaun nam nambed? ");
INSERT INTO kbm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yisu ginei yaun etok gikwai kob tis ane singamolomb-gen es bui kapul Galilaia gili ile ipil tavlu. Bui kapul nok ital are ti inei Taibirias. ");
INSERT INTO kbm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Be Amolmol dubi bamo ti eisir ili gen bwal bwale bambamo ebe ei gilgum ok gikwai beti itau ile ei be ile. ");
INSERT INTO kbm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Be Yisu nok ande gireu matendubi ti gile gibweg givin ane singamolomb gen. ");
INSERT INTO kbm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Be as mate ebe eisir Juda ve indi as Sonda Pasova ane ok ande gibloblo. ");
INSERT INTO kbm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisu geb na itin love gili amolmol dubi bamo etok ebe itangi ei ile ok, be ginei gitangi Pilip be ginei; “Wali atob eitit tanvwat ben nangge inend be tanemb nitangi amolmol dubi bamo etenik be inen?” ");
INSERT INTO kbm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisu ei ate gitpweng gen ebe atob nilgum ok are gikwai, bemem ei gilgum ve nili ninei atob Pilip ninei yaun ret, beti ei ginei yaun etok gitangi Pilip. ");
INSERT INTO kbm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip giwel Yisu avo be ginei; “Ginei eitit tanavgo ben ve aiweng bage tavlu be ano aitol (8) ane mone, weik 200 Kina be tanemb nitangi amolmol dubi bamo etenik inen atob nio is.” ");
INSERT INTO kbm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Be Saimon Pita male Endru, be Endru nok ei Yisu ane singamolomb ti, ei ginei gitangi Yisu be ginei; ");
INSERT INTO kbm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nunus natu ti ane ben siti be tis wenk ailu ete giengk ok, bemem ben siti etok gitangi ebe atob amolmol dubi bamo ti dang etenik inen be nitangi ok ite ma molge.” ");
INSERT INTO kbm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Be Yisu ginei gitangi ane singamolomb gen be ginei; “Unei itangi amolmol ve inambweg golonge.” Beti amolmol imbweg golonge ile itak taku dobo-dobo, be eisir nok as amol gaptol ge gitangi 5,000. ");
INSERT INTO kbm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Amolmol tepwengge imbweg golonge gikwai kob Yisu geb ben siti etok be ginei ane ta vie gitangi Pomate bekob geb vus-vusa be gibwas gitangi amolmol ve inen. Bekob gilgum dang etok ge gitangi wenk ailu ebok givin weik etok ge. Yisu geb ben tis wenk ailu etok gitangi eisir love gile gitangi ebe eisir ate tas gitung ve inei inen ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amolmol tepwengge en ben siti tis wenk ailu etok love gibon is gikwai kob Yisu ginei gitangi ane singamolomb-gen ve inro ben dadanis ebe giengk ok sut nisov dongke, veik ben dadanis ebe giengk ok niyaing ate bwaya. ");
INSERT INTO kbm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Beti eisir singamolomb iro ben siti etok ane dadanis ebe amolmol en be giengk ok sut gisov sab bage isgabu be ano ailu (12). ");
INSERT INTO kbm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eisir ili gen bwal bwale ete Yisu gilgum ok love inei; “Pomate ane amol (propet) kulkul ane ebe inei ve ninme nalk ok etenik bingano molge.” ");
INSERT INTO kbm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Be Yisu ande gitpweng are gikwai ginei eisir veve bais nisov ei be in-gas ei inde be inemb ei ve as amol bamo (king) ebe ve nemb is dabin ok. Beti ei gimdil gikwai eisir be gireu matendubi gile vukuri, gile ve givang ane atane ge nangge etok. ");
INSERT INTO kbm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Be givin gibok etok eisir singamolomb isov ile itak bui kire ");
INSERT INTO kbm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","be ile ipil ei-vovo ti be es bui kapul nok gile ve ile. Eisir tas gitung ve invang nambe Kapenaum ane. Taku ande tumi gikwai be Yisu gibielk ve eisir ite nangge. ");
INSERT INTO kbm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Be wavin givang natu ite be ane tine tiate molge. ");
INSERT INTO kbm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eisir singamolomb ivwes love ande ile undib ge ikwai alus, bekob ili Yisu ebe givang giwei bui dobo ge gile love ande gile gibloblo eisir tis ei-vovo ok be ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bemem Yisu ginei gitangi eisir be ginei; Unpelk bwaya. Ve ebeik ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Beti eisir ile ve in-gas ei, be seukie-ngge ei-vovo godo gile giro gitung alus. ");
INSERT INTO kbm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Givin tistumi kob amolmol ebe nolik imbweg em imbweg bui tavlu ok inei ve is ate be inei nolik ei-vovo ti givwev etenik givin ite ma, be ei-vovo dongke ge. Be Yisu gile gipil ei-vovo etok givin ane singamolomb-gen ite, etok eisir singamolomb ge ete nolik ile ok be Yisu gibweg tavlu etenik yapin. ");
INSERT INTO kbm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bemem givin sawa etok ete amolmol Taibirias ane subu ilaik as ei-vovo love ile ivwev imbloblo taku ete Amol Bamo geb ben siti etok be ginei ane ta vie gitangi Pomate bekob geb gitangi amolmol dubi bamo etok en imbweg ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Amolmol irek Yisu tis ane singamolomb-gen nangge etok love ili ma, beti ile vepias ipil ei-vovo subu be es bui gili ile ipil bui tavlu be ile ve irek Yisu nangge Kapenaum. ");
INSERT INTO kbm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Eisir nok ile vunge ve Yisu nangge ete bui tavlu ok be iutani ei be inei; “Gidung. Wali mie guvang dang gunme etenik?” ");
INSERT INTO kbm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yisu giwel eisir avos be ginei; “Ayeu nanei bingano ge nitangi yem nanei: Yem urek ayeu ve gisov gen bwal bwale ebe ayeu galgum be yem uli ok ane ite ma. Yem urek ayeu ve gisov ben sitingge ebe nolik ayeu gab gitangi yem be on love gibon aim vie-ngge ok ane, beti ete unme nik. ");
INSERT INTO kbm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yem unalgum gen utlangg aim ulis ane ge ite ma. Yem unalgum gen dalgongg aim matawas ane painge ge. Ve etok ben matawas ane roro. Be ben matawas ane nok, atob Pomate Natu ayeu ebe meng gahlang ve amolmol ok namb nitangi yem. Ve Tamangg Pomate gili ayeu gitangi gikwai be geb ane gwangne gitangi ayeu ve ginei nalgum kulkul etenik.” ");
INSERT INTO kbm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Beti eisir nok iwel Yisu avo be inei; “Dang etok be atob amei analgum gen ret veik nilgum be Pomate ta vevie?” ");
INSERT INTO kbm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yisu giwel eisir avos be ginei; “Pomate ta givin ve yem unalgum gen dang eteik: Aplongg aim nivin Amol (ayeu) ete Pomate gihlin be ginme ok.” ");
INSERT INTO kbm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Beti eisir iwel Yisu avo be inei; “Ataob mie nulgum gen bwal bwale ret veik amei andi be aplongg amei nivin mie? ");
INSERT INTO kbm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Amei-mei bambamo gen en ben (mana) nangge taku sawa, be etok gitangi yaun ebe giengk Pomate ane kapia ginei. Ve yaun etok ginei dang eteik: ‘Ei geb ben gulumb ane gitangi eisir be en.’ Dang etok be mie gitangi ebe atob nulgum gen ti weik ete Mose gilgum ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Be Yisu giwel eisir avos be ginei; “Ayeu nanei bingano ge nitangi yem nanei, Mose ei ate geb ben gulumb ane etok gitangi eisir ite ma. Tamangg dongke ge ete geb ben ano gulumb ane gitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Be ben ete Tamangg geb ok, ete gisov nangge gulumb ginme gitak be gilgum amolmol nalk ane be imbweg matawas.” ");
INSERT INTO kbm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Beti eisir inei gitangi ei be inei; “Amol Bamo, mie nomb ben matawas ane etok nitangi amei nivin as mate walang ok.” ");
INSERT INTO kbm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Be Yisu ginei gitangi eisir; “Ayeu ate ayeu ben matawas ane. Be amolmol ebe itangi ayeu inme ok atob marav-nes is vukuri ite ma, be amolmol ebe aplos givin ayeu ok atob bui luvus nes is vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ayeu ganei gitangi yem gikwai ganei, yem ok ande uli ayeu gisov matanongg aim gikwai bemem aplongg aim givin ayeu ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Amolmol tepwengge ebe Tamangg geb is gitangi ayeu ok, atob invang intangi ayeu ge inme. Be amol ti ginei nitangi ayeu ninme, okob ayeu gitangi ebe ve naitin ei ok ite molge ma yapin. ");
INSERT INTO kbm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ve ayeu gasov nangge gulumb ganme ve natau nale ayeu ate angg tangg gitung ite ma. Ayeu ganme ve navang mul ve Amol (Pomate) ebe gihlin ayeu be ganme ok ge ane ta gitung. ");
INSERT INTO kbm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Amol nok ta givin ve ayeu nalgum gen dang eteik: Ei bua ve ret ayeu nangg vier ve amolmol tepwengge ebe ande ei geb gitangi ayeu gikwai ok as amol ti be niengk em niengk nalk aplo ite ma. Ayeu atob nas eisir etok tepwengge itin vukuri nindeb mul ane. ");
INSERT INTO kbm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ve Tamangg ta givin ve ginei amolmol tepwengge ebe ili ei Natu ayeu be aplos givin ei ok, atob in-gas ebe ve inambweg matawas nemb ta ge ok. Be atob ayeu nas eisir itin vukuri nangge taku gimat ane nivin ebe Pomate ve niaing gen walang etenik nikwai ok.” ");
INSERT INTO kbm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bambamo Juda ane iute ebe Yisu ginei ei ben matawas ane ebe gisov nangge gulumb ginme ok, be tas vavis be inei yaun walang ano gipil ei ");
INSERT INTO kbm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","be inei; “Etenik Josep natu ebe ital inei Yisu ok etenik. Be eitit tali be tatpweng tine gabu tame are gikwai, be namnambed be ei ginei, ‘Ayeu gasov nangge gulumb meng gatak nalk?’” ");
INSERT INTO kbm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yisu giwel eisir avos be ginei; “Gaptol unei gen etok ane-avo bwaya. ");
INSERT INTO kbm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ve amol ti gitangi ebe nisu ate sin-gege nitangi ayeu ninme ok ite ma. Tamangg ebe gihlin ayeu be ganme ok dongke ge atob nirwel amolmol intangi ayeu inme. Be atob ayeu nas eisir itin vukuri nindeb mul ane. ");
INSERT INTO kbm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Be yaun ti ebe warik Pomate ane amolmol (profet) kulkul ane iro ok ginei dang eteik, ‘Amolmol walang ok atob inaute Pomate ane yaun love ma.’ Be Yisu ginei, amolmol tepwengge ebe iute Tamangg avo be isov ane lu ge ok, eisir etok ete tas givin ve invang intangi ayeu inme. ");
INSERT INTO kbm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Amol ti gili Tamangg ite molge ma yapin. Amol (ayeu) ebe gibweg givin Pomate beti ginme ok dongke ge ete nolge gili Tamangg. ");
INSERT INTO kbm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ayeu nanei bingano ge nitangi yem nanei, amolmol ebe aplos givin ayeu ok atob in-gas ebe ve inambweg matawas nemb ta ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ayeu ate ik ayeu ben matawas ane. ");
INSERT INTO kbm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Warik yem tumbungg aim gen en mana (ben ti ital inei mana) nangge taku sawa, bemem eisir etok tepwengge nolge imat vun-kunu be ma. ");
INSERT INTO kbm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bemem ginei amol ti nen ben ete gisov nangge gulumb ginme ok, okob ei ok atob nimat vunu bemem atob niengk em niengk nalk aplo ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ben matawas ane ete gisov nangge gulumb ginme ok ete ayeu ate eteik. Be amol ti ginei nen ben etok, atob ei ninggas ebe ve nimbweg matawe nemb ta ge ok. Be ben ete ayeu ve namb nitangi ei be nen ok, etok ayeu virongg ebe atob namb nitangi amolmol tepwengge nangge nalk be inen veik in-gas ebe ve inambweg matawas nemb ta ge ok ane.” ");
INSERT INTO kbm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yaun etok gilgum bambamo Juda ane aplos, be ivlap yaun gilek be ginme gitangi is ate be inei; “Amol etenik atob nemb utle ulis nitangi eitit be tanen weik ebe ben ok nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Be Yisu ginei gitangi eisir be ginei; “Bingano ayeu nanei bingano ge nitangi yem nanei: Ginei yem unen Pomate Natu ayeu ebe meng gahlang ve amolmol ok virongg be unum angg tuerk ite, atob yem un-gas ebe ve unambweg matawangg aim nemb ta ge ok niengk aplongg aim ite ma yapin. ");
INSERT INTO kbm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Amolmol ebe en ayeu virongg be inum awangg tuerk ok ge ete ande inggas ebe ve inambweg matawas nemb ta ge ok gikwai, be atob ayeu nas eisir itin vukuri nangge taku gimat ane nivin ebe Pomate ve niaing gen walang ok nikwai ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ve ayeu virongg tis angg tuerk, etok ben ane roro ebe ve amolmol inen be inum ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Amolmol ebe en ayeu virongg be inum awangg tuerk ok ete ivang ivin ayeu be ayeu gavang gavin eisir. ");
INSERT INTO kbm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Matawas ane dabe giengk Tamangg ebe gihlin ayeu be ganme ok, be ayeu gabweg matawangg ve Tamangg ane gwangne ane. Dang etok be amolmol ebe en ayeu virongg ok atob inambweg matawas ve ayeu angg gwangne ane weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ben ano roro etok ebe gisov nangge gulumb ginme gitak nalk ok. Be ben nok weik ben ete warik tumbungg aim gen en be imat vun-kunu ok ite ma. Amol ti ginei nen ben ete gisov nangge gulumb ginme ok, atob ei ninggas ebe ve nimbweg matawe nemb ta ge ok.” ");
INSERT INTO kbm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisu gibul eisir nangge lum mateu ane ti aplo nangge Kapenaum, be ginei yaun etenik gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yisu ane singamolomb gen anongge iute yaun etok be inei ve is ate be inei, “Amol ret gitangi ebe atob nipasang yaun etok tepwengge niengk aplo ok, ve yaun etok bunam molge?” ");
INSERT INTO kbm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bemem Yisu ande gitpweng are gikwai ginei ane singamolomb gen inei yaun walang ano ve yaun galkik ei ginei ginei ok ane, beti ginei gitangi eisir be ginei; “Yaun ete galkik ayeu ganei ok wat geb bunam gitangi yem me? ");
INSERT INTO kbm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ginei dangetok, okob asonge nivin sawa ebe yem ve undi Pomate Natu ayeu ebe meng-gahlang ve amolmol ok ve nareu nale taku ebe warik gabweg ok okob atob yem tangg aim nitung ret? ");
INSERT INTO kbm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ngalau Yamar dongke ge gilgum amolmol be imbweg matawas. Be utland ulis gitangi ebe atob nemb it ru ok ite ma molge. Be yaun ete galkik ayeu ganei gitangi yem gile gikwai ok, etok yaun matawas ane be etok Ngalau. ");
INSERT INTO kbm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bemem yem ate nik aim amolmol subu ete galkik uvang dongke nik aplos givin yaun etok ite ma.” Yisu gitpweng amolmol ebe atob aplos nivin ei ite ok, be tis amol ebe atob ninei ei binge nitangi amolmol valir ane ok are gimungg gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Beti warik ei ginei yaun ti dang eteik be ginei; “Ginei Tamangg nemb ane gwangne nitangi amol ti ite, okob gitangi ebe atob amol etok nitangi ayeu ninme ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yisu ginei yaun etok be ma gikwai kob, ete ane singamolomb gen be tis amolmol ebe itau gile ei ok ikwai ei be ile ve ivang be itau gile ei vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Beti Yisu ginei gitangi eisir 12 ebok be ginei; “Yem etenik ok ve unkwai ayeu be unde me?” ");
INSERT INTO kbm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Be Saimon Pita giwel ei avo be ginei; “Amol Bamo, atob amei anvang antangi amol ret ande? Ve mie dongke ge am yaun ete gilgum amolmol be atob in-gas ebe ve inambweg matawas nemb ta ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Be amei aplongg amei givin be atpweng are anei Pomate geb mie ve ane gen roro.” ");
INSERT INTO kbm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Be Yisu ginei gitangi eisir be ginei; “Ayeu gab yem 12 etenik ve unvang unvin ayeu. Bemem galkik ande Sadam givang givin yem aim amol ti be ete givang nik.” ");
INSERT INTO kbm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yisu ginei yaun etok gipil Saimon Iskariot natu Judas. Be Judas nok ei Yisu ane singamolomb ti, bemem bwayage kob ete ei ginei Yisu binge gitangi amolmol ebe ve ines ei vunu ok. ");
INSERT INTO kbm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yisu ginei yaun etok gikwai bekob givang gideb Galilaia as taku ane ge ve eisir Juda ilgum ve ines ei vunu, beti ei bua ve ret nivang nambe Juda as taku ane nile. ");
INSERT INTO kbm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Be gibloblo ve eisir Juda indi as Sonda ebe ital inei Sonda lum bes ane ok. ");
INSERT INTO kbm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Beti Yisu male gen itangi ei ile be inei; “Umdil ukwai taku etenik be ule ebe Judaia as taku ok, veik nulgum am kulkul be am amolmolgen nangge taku eteok indi nivin. ");
INSERT INTO kbm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ve amol ti ginei ta givin ve ane binge nivang nemb taku avwut, okob ei atob nilgum ane gen walang ok nivwaivun ate ge ite ma. Be mie ande ve nulgum gen dang etenik ok-ti nulgum am gen walang ok niengk nitip nitip ge veik amolmol tepwengge indi.” ");
INSERT INTO kbm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yisu ei ate male gen ok aplos givin ei ite weik etok ge beti inei yaun dangetok gitangi ei. ");
INSERT INTO kbm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Beti Yisu ginei gitangi eisir be ginei; “Sawa ebe ayeu ve nalgum gen dang dangetok ok meng gihlang ite nangge. Be as mate walang etek etok yem ge aim sawa ebe ve unalgum gen ret nitangi ebe tangg aim gitung ok. ");
INSERT INTO kbm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Amolmol tepwengge ebe aplos givin ite ok gitangi ve inemb vavavne nitangi yem ok ite ma, eisir ve inemb vavavne nitangi ayeu ge. Ve gisov as mate walang ok ayeu ganei yaun gipil eisir as luev gen tiate ane bambamo ebe ilgum ilgum ok beti. ");
INSERT INTO kbm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Be yem ate nok unde be undi Sonda etok, be ayeu wat nale ite ma. Ayeu atob nambweg love nali sawa vie ti kob nale.” ");
INSERT INTO kbm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yisu ginei yaun etok gitangi male gen gikwai, be ma ve gibweg ete Galilaia ok yapin. ");
INSERT INTO kbm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yisu male gen ile ikwai kob ete ei gimdil be gitau gile eisir. Bemem ei givang gi-mumu ate ge. ");
INSERT INTO kbm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Givin sawa etok ete eisir bambamo Juda ane nas gitung Yisu ve indi, be inei ve is ate be inei; “Wali ande amol etenik gibweg sawa inend ge?” ");
INSERT INTO kbm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Be amolmol anongge inei Yisu ane yaun bwayage bwayage gitangi is ate be inei; “Ei amol vie molge.” Be eisir subu inei; “Ma! Amol etenok ebe giyo giyo amolmol ok.” ");
INSERT INTO kbm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Eisir ipelk ve amolmol Juda ane beti inei yaun etok gile gihlang be amolmol tepwengge iute ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Amolmol imbweg ve ili Sonda lum bes ane ivang love ande gile gipil luvwe, bekob ete Yisu gisov lum yamar aplo gile be ginei mateu gitangi amolmol givarkei. ");
INSERT INTO kbm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Eisir Juda ili ebe ei givnawi kapia ane bwalbwale ok be ikuri vunu-ngge be inei; “Amol etenik gisov lum ti ite, bemem ei ane dabe gwet vie molge ba?” ");
INSERT INTO kbm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Beti Yisu giwel eisir avos be ginei; “Yaun ete ayeu gab gitangi yem gilek nok, etok awangg yaun ite ma. Etenok Pomate ebe gihlin ayeu be ganme ok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Amol ti ginei ta gitung ve nilgum Pomate ane yaun ano nile, atob ei nitpweng yaun ete ayeu ganei nik ane dabe are. Ve yaun etenik ginme nangge Pomate ane, me ayeu ganei gitangi ebe angg tangg gitung ok. ");
INSERT INTO kbm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amolmol ebe ilgum gen gitangi ebe eisir ate as tas gitung ok, eisir ilgum gen eisir ate ares ane ge. Bemem eisir ebe tas givin ve avos nivwat Amol ebe gihlin ayeu be ganme ok are ok, eisir etok ete amolmol yaun ano ane roro be yaun bingkasop ane ti giengk eisir aplos ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Be Yisu ginei, “Mose geb yaun (lo, me bingsu) subu gitangi yem gikwai, bemem yem tepwengge bwaingg aim ve ret unvang mul ve yaun ete Mose geb gitangi aim ok. Be yem ulgum veve unes ayeu vunu ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Be eisir iwel ei avo be inei; “Gen giwel mie me. Wali ret ve nes mie vunu?” ");
INSERT INTO kbm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Beti Yisu ginei gitangi eisir be ginei; “Ayeu galgum gen bwal bwale ti givin Sonda Sabat, be yem uli love ulat baingg aim be avongg aim poke ge. ");
INSERT INTO kbm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Be warik Mose geb luev ti gitangi yem ve unaure nunus muele utlas ulis. Bingano, bemem luev etok ginme nangge Mose roro ite ma. Luev ete ve inaure utlas ulis ok meng gihlang nangge yem ate aim bambamo-nggen ulu. Be yem ate ok ulgum kulkul ve ure utlangg aim ulis givin Sonda Sabat weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yem ulgum ve unei unvang mul ve yaun ete Mose geb gitangi yem ok vie ge, beti ulgum kulkul ve ure nunus muele utlas ulis givin Sonda Sabat ok givin weik etok. Be nam nambed be yem tangg aim vavis ve ayeu ve gisov ebe galgum amol gimat ti be utle vie vukuri givin Sonda Sabat ok? ");
INSERT INTO kbm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Undi amolmol niengk nas ge be unalgum as yaun ite ma. Undi eisir as luev ebe ivang be ilgum ok nimungg bekob unei eisir as yaun.” ");
INSERT INTO kbm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amolmol Jerusalem ane subu inei ve is ate be inei; “Amol etenik ebe wat eisir ilgum ve ines ei vunu ok me? ");
INSERT INTO kbm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bemem taundi ande ei givarkei amolmol nas be ginei ginei yaun bemem amol ti ginei yaun ti gipil ei ite ma molge. Be ande wat eisir awaga ok itpweng ei are inei ei amol (Kilisi) ebe ve nemb amolmol dabin ok me? ");
INSERT INTO kbm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bemem ginei amol (Kilisi) ebe ve nemb amolmol dabin ok ninme, atob amol ti gitangi ebe ve nitpweng taku ebe ei ginme nangge ok are ok ite ma molge. Be amol etenik eitit tepwengge tatpweng ei ane nam ebe ginme nangge ok are gikwai.” ");
INSERT INTO kbm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisu givarkei lum yamar aplo ve ginei ginei mateu gitangi amolmol givarkei, be ginei avo bamo ge be ginei; “Yem unei yem ok ande utpweng ayeu be tis angg nam are gikwai. Bemem ayeu ganme gitangi ebe angg tangg givin ok ite ma. Tamangg gihlin ayeu beti ganme. Be Tamangg ei amol yaun ano ane. Bemem yem utpweng ei are ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ayeu dongke ge gatpweng ei are. Be ayeu gabweg gavin ei, beti ve ei gihlin ayeu be ganme.” ");
INSERT INTO kbm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Beti eisir Juda as awaga-gen ilgum ve inemb ei ta, ve yaun ete ei ginei ok ane, bemem amol ti gikari bage gipil ei ite ve sawa ebe ve ines ei vunu ok giengk nangge. ");
INSERT INTO kbm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Be amolmol anongge aplos givin ei be inei; “Amol (Kilisi) ebe ve nemb amolmol dabin ok ginei ninme, atob wat ei nilgum gen bambamo subu nitlek gen ete ande amol etenik gilgum ok.” ");
INSERT INTO kbm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisai subu iute ebe amolmol inei yaun walang ano gipil Yisu be ilgum ve avos givwat ei are ok binge be tas vavis anongge. Beti Parisai nok tis bambamo da ane ihlin eisir kambam tupe subu be ile ve inemb Yisu ta. ");
INSERT INTO kbm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yisu ginei yaun gitangi amolmol givang be ginei; “Atob ayeu navang navin yem sawa siti ge nivin, bekob atob nakwai yem be natangi amol ebe gihlin ayeu be ganme ok nale. ");
INSERT INTO kbm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Be atob yem unalgum ve unrek ayeu bemem atob undi ite, be yem gitangi ebe atob unde taku ete ayeu ve nale nambweg ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Beti bambamo Juda ane inei ve is ate be inei; “Taku inend ete atob ei nile be eitit tandi ei vukuri ite ok? Ei atob wat nivang taku undib ge ti, nile Grik as taku be ninei mateu nitangi Grik eisir ate be tis Juda ebe ile imbweg etok ok me? ");
INSERT INTO kbm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ei ginei atob eitit lolond ve tandi ei bemem atob tandi siti ite. Be taku ete ei ve nile ok, eitit gitangi ebe atob tande tanambielk ve taku etok ite ma. Wali ei ta gitung namnambed?” ");
INSERT INTO kbm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","As mate mul ane ane ebe eisir Juda ve indi as Sonda lum bes ane etok be ma nikwai ok ande meng gihlang. Eisir ili as mate mul ane etok inei as mate bamo be vie molge ti. Be givin as mate etok ete Yisu gimdil givarkei be ginei yaun avo bamo ge be ginei; “Amol ti ginei bui luvus ges be ve ninum bui, ei nivang nitangi ayeu ninme be ninum. ");
INSERT INTO kbm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ve yaun ebe giengk Pomate ane kapia ok ginei dang eteik: Amol ti ginei aplo givin ayeu, atob ei nimbweg matawe nemb ta ge weik ebe bui tis dabe ok.” ");
INSERT INTO kbm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisu ginei yaun etok gipil Ngalau yamar, ve amolmol ebe aplos givin ei ok ete atob in-gas Ngalau Yamar. Ve givin etok Yisu ginumul gireu gile ebe gulumb ok ite nangge, beti Ngalau Yamar ginme nalk ite. ");
INSERT INTO kbm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amolmol subu iute Yisu ane yaun ebe ginei ginei ok love inei; “Etenik Pomate ane amol kulkul ane (Profet) ti ebe eitit tasge ve atob ninme ok bingano molge.” ");
INSERT INTO kbm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Be eisir subu inei; “Etok Amol (Kilisi) ebe ve nemb amolmol dabin ok.” Bemem eisir subu inei; “Amol (Kilisi) ebe ve nemb amolmol dabin ok gitangi ebe atob menihlang nangge Galilaia as taku ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ve yaun ebe giengk Pomate ane kapia ok ginei dang eteik ginei: Amol (Kilisi) ebe ve nemb amolmol dabin ok atob nimdil nangge Dawit ane amolmol-gen, be atob tine nikuv ei nangge Betlehem. Be taku etok ebe warik Dawit gibweg ok.” ");
INSERT INTO kbm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Amolmol inei yaun avo walang ano dangetok gipil Yisu, beti gilgum be eisir emb is ate vusa gile dubi ailu. ");
INSERT INTO kbm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eisir subu ilgum ve inemb ei ta, bemem amol ti gikari bage gipil ei ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Beti eisir kambam tupe ivang sin-ge inumul itangi Parisai be tis awaga Juda ane ile vukuri. Parisai tis eisir awaga ili ebe eisir kambam tupe ivang sin-ge ve inumul ile ok be iutani eisir be inei; “Nam nambed be yem uvang sin-ge unumul unme be unggas Yisu givin ite?” ");
INSERT INTO kbm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Be eisir kambam tupe iwel Parisai tis eisir awaga avos be inei; “Gimungg ane amol ti ginei yaun avo weik ete amol (Yisu) eteok ginei ok ite ma molge.” ");
INSERT INTO kbm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Beti eisir Parisai iwel eisir avos be inei; “Ei giyo giyo yem givin me ma? ");
INSERT INTO kbm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Amei Parisai tis eisir awaga, amei amol ti aplo givin amol etenok ite molge ma yapin. ");
INSERT INTO kbm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bemem amolmol bambamo ete ande aplos givin ei ok ete ande Pomate gili eisir etok tiate gikwai, ve gisov eisir itpweng yaun ebe warik Mose geb gitangi eitit ok are ite ma. Amei aplongg amei givin amol etenok ite yapin.” ");
INSERT INTO kbm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Eisir Parisai nok as amol ti are Nikodimos, amol nok ebe warik gile ve gili Yisu tis tambok be kakie givin ei ok. Nikodimos nok gimdil be ginei; ");
INSERT INTO kbm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mose ane yaun ginei gitangi eitit ginei, eitit tanaute amolmol as yaun be tandi gen tiate ret ebe eisir ilgum ok nimungg, bekob tanalgum eisir as yaun.” ");
INSERT INTO kbm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eisir Parisai iwel Nikodimos avo be inei; “Mie amol Galilaia ane ti etenik merav? Ebe gabu Yisu unme nangge etok ok? Ule be uvnawi yaun ebe warik Pomate ane amolmol kulkul ane iro bwalbwale ok vevie be uli kob. Amol (profet) ebe ginei Pomate avo ok ti gitangi ebe atob menihlang nangge Galilaia ok ite ma molge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Amolmol tepwengge ivang itangi as nam ge ile, be Yisu gireu matendubi ebe ei oliv givarkei ok gile ve givang etok. ");
INSERT INTO kbm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Be givin tistumi ge ei gisov nangge matendubi gile gitak be gisov lum yamar aplo gile vukuri, be amolmol iro is ate sut itangi ei ile. Yisu gibweg golonge be ginei ginei mateu gitangi eisir gibweg. ");
INSERT INTO kbm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Be gidung yaun ane subu ebe emb Mose ane yaun dabin ok tis eisir Parisai inggas avie ti ebe ili ei ges luev wasi ane ok isov lum aplo ile itak ei givarkei amolmol tepwengge nas. ");
INSERT INTO kbm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bekob inei gitangi Yisu be inei; “Gidung, amolmol ili avie etenik givang mul ve luev wasi ane. ");
INSERT INTO kbm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dangetok be Mose ane yaun ginei dangetok ginei, tanes amolmol ebe ilgum gen dang dang etenik ok vun-kunu ve vat ge. Be wali mie tam gitung nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eisir Parisai tis gidung yaun ane nok irek luev ebe ve inemb Yisu ta ok beti inei yaun dangetok gitangi ei. Veik ginei ei ninei yaun ti nitlek, okob atob eisir inemb ei ta. Yisu gituk ve gito gito yaun ve bage kuku gireu nalk gibweg. ");
INSERT INTO kbm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Be eisir nok as kulkul ve iutani ei painge ge ivang, beti ei gimdil givarkei be ginei gitangi eisir be ginei; “Yem aim amol ret ebe gilgum gen tiate ti ite molge ok, amol etok nikari vat nipil avie etenik ulu.” ");
INSERT INTO kbm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yisu ginei yaun etok gikwai be ma ve gibweg golonge be gito gito yaun gireu nalk vukuri gibweg. ");
INSERT INTO kbm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eisir iute Yisu ane yaun etok, love imdil dongke dongke ile ihlang ikwai lum aplo. Eisir awaga ile ihlang ulu bekob amolmol ebeok itau gile, love ikwai Yisu ei ate ge gabu avie ebe galkik givarkei amolmol tepwengge nas ok. ");
INSERT INTO kbm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisu gimdil givarkei be giutani avie nok be ginei; “Avie, wali ande amolmol ivang? Eisir as amol ti ande ginei miam yaun me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Avie nok giwel Yisu avo be ginei; “Amol Bamo, ma yapin.” Be Yisu ginei gitangi ei; “Ayeu ok atob nalgum miam yaun ite weik etok ge. Be ule, bemem nulgum tiate vukuri bwaya.” ");
INSERT INTO kbm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Be givin ebe Yisu gibul amolmol vukuri ok, okob ete ginei gitangi eisir be ginei; “Ayeu yev ebe giro nalk be bogbogo ok. Amolmol ebe itau ile ayeu ok gitangi ebe atob invang insov aiweng tumi aplo ok ite ma. Atob matawas ane yev niro nipil eisir.” ");
INSERT INTO kbm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Beti eisir Parisai inei gitangi ei be inei; “Mie gulgum ve mie ate gunei im ate lavo, beti am yaun ete gunei nok ginei lavo ve mie amol bingkasop ane.” ");
INSERT INTO kbm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yisu giwel eisir avos be ginei; “Bingano ayeu ate ganei au-ate lavo, bemem yaun ete ayeu ganei ik etok yaun ano molge. Ve gisov ayeu gatpweng taku ebe gamdil nangge be ganme ok are, be gatpweng taku ebe atob nanumul nale nambweg ok are givin gikwai. Bemem yem, yem utpweng taku ebe ayeu gamdil nangge be ganme ok are ite ma. Be taku ete atob ayeu nale nambweg ok yem uni-ni weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yem ulgum amolmol as yaun gitau gile amolmol ge as luev. Be ayeu galgum amol ti ane yaun ite ma, ");
INSERT INTO kbm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","bemem ginei ayeu nalgum amolmol subu as yaun, atob awangg luev ebe galgum yaun ane ok vie be roro dongke. Ve etok ayeu ate ge ete galgum amolmol as yaun ok ite ma. Tamangg ebe gihlin ayeu be ganme ok, ete gilgum kulkul givin ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Be yem ate nok aim yaun ti ginei dang-eteik ginei: Ginei amol ailu inei yaun gen ti ane be sulu as yaun avo givang dongke ge, okob yaun ete sulu inei ok etok yaun ano. ");
INSERT INTO kbm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Dangetok be ayeu ganei au-ate lavo, be Tamangg ebe gihlin ayeu be ganme ok ei ginei ayeu lavo givin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Beti eisir inei gitangi ei be inei, “Wali mie tamem gibweg taku inend?” Be Yisu giwel eisir avos be ginei; “Yem utpweng ayeu are ite, beti atob unatpweng Tamangg are ite. Be ginei unatpweng ayeu are atob unatpweng Tamangg are nivin weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisu ginei yaun etok gitangi eisir givarkei lum yamar aplo ti ebe itak bukuel mone ane giengk giengk ok. Bemem amol ti geb ei ta ite ma, ve sawa ebe ve inemb ei ta ok giengk nangge. ");
INSERT INTO kbm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bekob ginei gitangi eisir be ginei; “Ayeu ve navang, be atob yem lolongg aim be unalgum ve undi ayeu ok, love undi ma, be atob unmat vunkunu tis aim tiate ge. Be yem gitangi ebe atob unde unambielk ve taku ete atob ayeu nambweg ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Beti eisir Juda inei ve is ate be inei, “Ei ginei, ‘Yem gitangi ebe atob unde unambielk taku ete ayeu ve nambweg ok ite.’ Wali ei ta gitung nam nambed? Ei wat atob nes ate vunu me?” ");
INSERT INTO kbm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Be Yisu ginei gitangi eisir be ginei; “Yem unme nangge nalk lu ane, be ayeu, ayeu amol ei goto ane. ");
INSERT INTO kbm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Beti ayeu ganei gitangi yem gikwai ganei, atob yem unmat vunu tis aim tiate ge. Bingano, ginei yem aplongg aim nivin dang etok unei ayeu ate nok eteik ite, okob atob yem unmat vunu tis aim tiate ge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Be eisir inei gitangi ei be inei, “Mie amol ret?” Be Yisu giwel eisir avos be ginei, “Ayeu ande ganei gitangi yem gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Awangg yaun ebe ve nanei nitangi yem, be tis ebe ve nalgum yem aim yaun ok walang molge ete giengk nik, bemem atob ayeu nalgum ite ma. Yaun ebe gaute nangge Amol ebe gihlin ayeu be ganme ok ge ete ayeu ganei vusa gitangi amolmol nalk ane tepwengge. Be Amol nok ei amol yaun ano ane.” ");
INSERT INTO kbm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yisu ginei yaun etok gipil Tame, bemem eisir itpweng are ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Beti ei ginei gitangi eisir be ginei, “Asonge nivin sawa ebe yem ve unrun Pomate Natu ayeu ebe meng gahlang ve amolmol ok itin nile ei-goto ok, okob atob unatpweng are nivin sawa etok unei ayeu ate nok eteik. Kob atob unatpweng are nivin unei ayeu galgum gen walang ok gitangi ebe au-ate angg tangg gitung ok ite ma. Ayeu ganei yaun ebe Tamangg geb gitangi ayeu ok ge. ");
INSERT INTO kbm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Be Tamangg ebe gihlin ayeu be ganme ok, ete givang givin ayeu painge ge. Ei na vier ve ayeu be ayeu ate ge gavang angg gen ite ma. Be as mata walang ok ayeu galgum gen ebe gipasang ei aplo ok gigas ta ge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ei ginei yaun etok gitangi eisir, love amolmol walang molge aplos givin ei. ");
INSERT INTO kbm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Beti Yisu ginei gitangi eisir Juda ebe nolge aplos givin ei gikwai ok be ginei, “Ginei yem un-gas awangg yaun ta gwangne ge niengk aplongg aim, okob etok weik awangg amolmol-gen yem roro. ");
INSERT INTO kbm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Be atob yem unatpweng yaun ano are kob atob yaun ano nilgum yem be unvang aim gen vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Be eisir iwel Yisu avo be inei: “Ablaham ane vaku amei. Be amei tangg amei gisgil ebe amol ti gigas amei ve ane amolmol kulkul ane tis as mate ti ok, ma molge. Be nam nambed be ande mie gunei atob nunggas amei ankwai be anvang amei gen vie-ngge?” ");
INSERT INTO kbm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yisu giwel eisir avos be ginei; “Ayeu nanei bingano ge nitangi yem nanei: Amolmol tepwengge ebe ilgum tiate ok, ete gen tiate ane amolmol kulkul ane eisir. ");
INSERT INTO kbm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Amol kulkul ane atob nimbweg nam ta ninggas ta ite ma. Bemem nam etok tame ane natu dongke ge ete atob nimbweg nam ta ninggas ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dangetok be ginei Natu nilgum yem be unvang aim gen vie-ngge, atob yem unvang aim gen vie-ngge dangetok ninggas ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ayeu ok gali gikwai ganei Ablaham ane vaku-gen yem. Bemem yem utau ule Ablaham ane luev ebe gilgum be givang ok ite ma. Beti yem ulgum gen ve unes ayeu vunu. ");
INSERT INTO kbm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","As mate walang ok ayeu ganei yaun gipil gen ebe Tamangg ges ru gitangi ayeu be gali gikwai ok ge. Bemem yem, yem ulgum gen gitau gile luev ebe unggas nangge tamangg aim-gen ok.” ");
INSERT INTO kbm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Be eisir iwel Yisu avo be inei, “Amei tamangg amei-gen nangge Ablaham ane amolmolgen.” Beti Yisu giwel eisir avos be ginei, “Ginei Ablaham ane vaku-gen yem bingano ge, atob yem unalgum gen dangete Ablaham gilgum ok. ");
INSERT INTO kbm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ayeu ganei yaun ano ebe gaute nangge Pomate avo ok ane yaun gitangi yem, be yem ulgum ve unes ayeu vunu ge nakwai. Bemem Ablaham gilgum gen ti dang etenik ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Be etenik yem uvang mul ve tamangg aim-gen as luev ete ulgum uvang nik.” Be eisir iwel ei avo be inei. “Amei tinangg amei-gen ikuv amei sinsin-ge ite ma. Amei Tamangg amei Pomate dongke ge.” ");
INSERT INTO kbm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Be Yisu ginei gitangi eisir be ginei, “Ginei yem tamangg aim ete Pomate ok bingano ge, okob atob atob yem tangg aim nivin ayeu. Ve ayeu gabweg gavin Pomate beti ganme. Be ayeu ate gamdil be ganme gitangi ebe tangg gitung ok ite ma. Pomate gihlin ayeu beti ganme. ");
INSERT INTO kbm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yem tangg aim nitung awangg yaun vevie be undi kob ma? Be gen etenik ane dabe gisov yem bwaingg aim ve ret unaute awangg yaun. ");
INSERT INTO kbm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Tamangg aim ete Sadam ok. Beti yem lolongg aim gwangne ge ve unalgum gen ebe tamangg aim etok ta givin ve unalgum ok. Ei are giengk yapin dangetok inei, amol ebe ges amolmol vunu ok. Be ei ta gisgil ebe gitau gile luev yaun ano ane ok ma molge, ve yaun ano ti giengk ei aplo ite ma. Ei ane nok ete ve ninei yaun bing kas-kasop ane ok ge, be etok ete ei ane yaun roro. Ei amol bing-kasop ane, be yaun bing-kasop ane walang ok ane tame ei dongke ge. ");
INSERT INTO kbm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bemem ayeu, ayeu ganei yaun ano ane yaun bemem yem aplongg aim givin awangg yaun ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yem wat tangg aim gitung unei ayeu galgum gen tiate me? Ginei yem uli dangetok okob etok vie ve yem unalgum awangg yaun ve gen tiate ebe galgum ok ane. Bemem gimdom be ayeu ganei yaun ano ane yaun gitangi yem be yem bwaingg aim ve ret aplongg aim nivin awangg yaun? ");
INSERT INTO kbm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Amolmol ebe meihlang ve Pomate ane natunggen ok, eisir isov Pomate ane yaun walang ok ane lu vie-ngge. Be yem etek ge ete Pomate ane natunggen yem ite, beti bwaingg aim ve ret unaute ei ane yaun.” ");
INSERT INTO kbm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Eisir Juda iwel Yisu avo be inei, “Amei anei gitangi mie gikwai anei Mie amol Samaria ane ti etenik be ngalau tiate ti wat givang givin mie. Me wat amei ayo me?” ");
INSERT INTO kbm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yisu giwel eisir avos be ginei: “Ngalau tiate ivang ivin ayeu ite ma molge. Ayeu galgum ve avongg givwat Tamangg are, be yem ulgum ve unei ayeu susweng. ");
INSERT INTO kbm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ayeu galgum gen arengg ane ite ma. Amol ebe ve avo nivwat ayeu arengg ok ete gibweg nik, be ei amol etok ebe atob nilgum amolmol tepwengge as yaun ok. ");
INSERT INTO kbm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Be ayeu nanei bingano ge nitangi yem nanei: Amol ti ginei gisov awangg yaun ane lu ge, amol etok ande gigas ebe ve nimbweg matawe nemb ta ge ok gikwai, be gitangi ebe atob ei nimat vunu mang-mangi ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Be eisir Juda inei gitangi ei be inei, “Ande amei atpweng are roro ge anei ngalau tiate givang givin mie. Ablaham noge gimat vunu gikwai, be eisir (profet) ebe inei Pomate avo ukwas binge ok nolge imat vun-kunu weik etok ge. Bemem galkik ande mie gunei ti gunei, ‘Amol ti ginei nisov awangg yaun walang ok ane lu vie-ngge, atob ei nimbweg matawe dangetok me rav?’ ");
INSERT INTO kbm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nam nambed? Mie wat gulgum ve nulgum im-ate nutlek eitit tumbund Ablaham me? Ei nolge gimat vunu gikwai be eisir ebe inei Pomate avo ok, nolge imat vun-kunu ikwai weik etok ge. Be mie amol ret dangete-nik?” ");
INSERT INTO kbm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yisu giwel eisir avos be ginei: “Ginei ayeu ate nalgum ve avongg nivwat arengg, atob awangg yaun ete ganei gipil au-ate ok weik ebe gen sin-ge ok. Bemem Tamangg ebe yem utal ei unei aim Pomate ok, ei dongke ge ete avo givwat ayeu arengg. ");
INSERT INTO kbm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bemem yem utpweng ei are ite ma. Be ayeu, ayeu gatpweng ei are gikwai. Ginei ayeu nanei dang etok nanei ayeu gatpweng ei are ite, atob ayeu weik ebe amol bingkasop ane ti weik ete yem ate nik. Bemem ayeu gatpweng ei are gikwai be gasov ei ane yaun walang ok ane lu vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tumbungg aim Ablaham bamo lolo givang ve nili sawa ebe ayeu ve menahlang ok love gili be ta vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Be eisir bambamo Juda ane inei gitangi ei be inei, “Mie guli Ablaham ite ve miam Sonda bamo gitangi ei ane ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Be Yisu giwel eisir avos be ginei, “Ayeu nanei bingano ge nitangi yem nanei: Ablaham tine gikuv ei ite nangge be ayeu gabweg gimungg.” ");
INSERT INTO kbm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Be Juda as awaga-gen tas vavis be bais gisov vat veve ines Yisu vunu, ve gisov Yisu gilgum ve nilgum ate weik ebe Pomate ok. Bemem Yisu gimumu ate ge be gile gihlang gikwai lum yamar aplo. ");
INSERT INTO kbm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisu givang gile love gili amol ti ebe warik tine gikuv ei tis matano bop yapin ok. ");
INSERT INTO kbm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Be ane singamolomb-gen iutani ei be inei, “Gidung, amol ret ane tiate ane vavavne ete gilgum be amol etenik tine gikuv ei tis matano bop ge nik? Ei ate ane tiate me tame gabu tine as?” ");
INSERT INTO kbm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yisu giwel ane singamolomb-gen avos be ginei, “Ei ane tiate me tame gabu tine as tiate gilgum beti ei matano bop ite ma. Bemem ei ve matano bop dangetok yapin veik Pomate nemb kulkul nipil ei be nes ane gwangne ru be amolmol indi. ");
INSERT INTO kbm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dangetok be eitit tanalgum Amol ebe gihlin ayeu be ganme ok ane kulkul painge ge tis ete as nik, be ginei tambok ninme okob amol ti gitangi ebe atob nilgum kulkul ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ayeu gavang nalk etenik be ayeu weik yev ebe aivi be ane bogbogo giro nalk tepwengge ok.” ");
INSERT INTO kbm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yisu ginei yaun etok gikwai kob giluk avo rulu gisov nalk be gilmu nalk tis avo rulu nok love muai muai kob giro gireu amol matano bop nok matano. ");
INSERT INTO kbm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Be ginei gitangi amol nok be ginei, “Ule be uvuk nam isov bui kapul Siloam.” (Are ete Siloam ok, ane dabe dangeteik inei, “Ihlin ei be gile.”) Beti amol nok gile be givuk nalk etok gikwai na, bekob ete matano ponge be gili gen. Bekob ginumul ve gile. ");
INSERT INTO kbm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amol nok ane nune-nggen ebe nangge nam dongke ok be tis eisir ebe ok subu ebe warik ili ei gibweg tis matano bop ge ve giutau-tani mone nangge amolmol ok, ili ei be iutani is ate be inei, “Amol etenik ebe wat warik matano bop, be gibweg ve giutau-tani mone nangge amolmol ok, amol nok etenik me?” ");
INSERT INTO kbm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Be eisir nok as amolmol subu inei, “Gen nok etenik.” Be subu inei, “Ma, etenik amol ebeok ti bemem na love weik amol ete matano bop ok.” Beti amol nok ginei gitangi eisir be ginei, “Ayeu nok eteik.” ");
INSERT INTO kbm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Be eisir iutani ei be inei, “Wali mie matanom ponge namnambed?” ");
INSERT INTO kbm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Be ei giwel eisir avos be ginei, “Amol ebe ital are inei Yisu ok, ei gilmu nalk tis bui love muai muai kob giro nalk nok gireu ayeu matanongg bekob gihlin ayeu be ginei nale be navuk nalk nok nikwai nangge bui kapul Siloam. Beti ayeu gale, be givin ebe gavuk nalk etok gikwai matanongg ok, be seukie-ngge ande matanongg ponge be gali taku.” ");
INSERT INTO kbm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Be eisir iwel amol nok avo be inei, “Wali ande amol nok givang?” Be ei giwel eisir avos be ginei, “Ayeu gali ite.” ");
INSERT INTO kbm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bwayage kob amolmol inggas amol nok itangi eisir Parisai ile. ");
INSERT INTO kbm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yisu gilgum amol matano bop etok be matano ponge givin Sonda Sabat. ");
INSERT INTO kbm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Beti eisir iutani amol nok vukuri be inei, “Wali mie matanom ponge nam nambed?” Be amol nok ginei lavo gitangi eisir be ginei, “Amol ti giro nalk muai muai siti gireu ayeu nangg, bekob gavuk nalk nok gikwai be seukie-ngge matanongg ponge be gali taku.” ");
INSERT INTO kbm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Beti eisir Parisai subu inei, “Amol ebe gilgum gen etenik ok, Pomate gihlin ei beti ginme ite ma. Ve ei gilgum kulkul ve gilgum amolmol ebe tis gimat ok be utlas vie tis Sonda Sabat givin givin.” Bemem eisir subu inei, “Amol ti ebe gilgum gen tiate ok, gitangi ebe ve nilgum gen bwal bwale ti dang-ete amol etenik gilgum ok ite ma yapin.” Beti eisir emb is ate vusa gile dubi ailu. ");
INSERT INTO kbm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Beti eisir nok inei gitangi amol ete warik matano bop ok be inei, “Atob mie nunei ret nipil amol ete gilgum mie matanom be ponge ok?” Be amol nok giwel eisir avos be ginei, “Ei Pomate ane amol (profet) kulkul ane ti ebe ginei Pomate avo ok.” ");
INSERT INTO kbm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bingano, amol ebe warik matano bop ok nok etok, be ande matano ponge be gili gen. Bemem eisir Juda aplos givin inei amol nok etok ite. Beti ital amol nok tine gabu tame ile ");
INSERT INTO kbm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","be iutani sulu be inei, “Yemlu natungg aim ebe unei tine gikuv ei tis matano bop yapin ok eteik me? Be nam nambed be ande ei matano ponge be gili taku?” ");
INSERT INTO kbm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Amol nok tine gabu tame iwel eisir bambamo Juda ane avos be inei, “Eilu atpweng are anei eilu natungg amei ebe warik tine gikuv ei tis matano bop yapin ok etenik. ");
INSERT INTO kbm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bemem gen ret gilgum ei beti ande matano ponge be gili taku, etok eilu tangg amei gisgil. Be amol ret gilgum ei matano be ponge, etok ok eilu tangg amei gisgil weik etok ge, be unautani ei ate nok. Ve ei ande bamo gitangi ebe ve ninei ate lavo ok.” ");
INSERT INTO kbm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Amol nok tame gabu tine itin yaun etok gireu natus ge ve sulu ipelk ve bambamo Juda. Ve gisov eisir imbiti as yaun ti gimungg gikwai dangetok inei, Ginei amol ti gital Yisu ginei Amol (Kilisi) ebe ve nemb amolmol dabin ok, atob inaitin amol etok nile nihlang be ninei uiye me nes miengk nivin eisir ite. ");
INSERT INTO kbm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Be gisov yaun etok ane ge, beti amol nok tine gabu tame ipelk ve is ate ane, be itin yaun etok gireu natus ge. ");
INSERT INTO kbm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Beti bambamo Juda ane ital amol nok gile vukuri be inei gitangi ei be inei, “Avom nivwat Pomate dongke ge are be nam vier ve Yisu. Ve amei atpweng ei are gikwai anei ei amol tiate ane ti.” ");
INSERT INTO kbm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Beti amol nok giwel eisi ande ayeu matanongg ponge be gali taku.” ");
INSERT INTO kbm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Be eisir iutani ei be inei, “Wali ei gilgum be mie matanom ponge nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Amol nok giwel eisir avos be ginei, “Ayeu ande ginei gitangi yem gikwai. Bemem yem bwaingg aim ve ret unaute, be yem ve unaute ret vukuri? Wat yem ulgum ve unei monahlang ve ei ane singamolomb gen unvin me?” ");
INSERT INTO kbm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Beti eisir inei gitangi ei be inei, “Mie ate nok ete ande mengguhlang ve ei ane singamolomb ti. Bemem amei eteik ete Mose ane singamolomb gen amei. ");
INSERT INTO kbm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Be amei atpweng are gikwai anei warik Pomate ei ate kakie givin Mose. Be wali amol etenok gigas ane gwangne nangge sawa inend ve amei tangg amei gisgil.” ");
INSERT INTO kbm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Be amol ebe warik matano bop ok giwel eisir avos be ginei, “Etenik gen nangglus ti etenik. Yem unei yem tangg aim gisgil ei, be wali ei gigas ane gwangne etok nangge inend? Bemem ei gilgum ayeu matanongg be ande gali taku. ");
INSERT INTO kbm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Be eitit tatpweng are gikwai ve Pomate gitangi ebe ve niute amol tiate ti ane yaun ok ite ma. Bemem amol ebe ginei uiye be ges miengk gitangi Pomate, be ta givin ve nilgum Pomate ane yaun walang ok ano nile ok ge, ete atob Pomate niute ei avo. ");
INSERT INTO kbm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Warik gimungg ane be ginme love galkik as mate etenik, eitit taute yaun ti dang etenik gipil amol ti ebe tine gikuv tis matano bop yapin, bekob amol ti gilgum be ponge ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dangetok be ginei Pomate nihlin Amol etok ite bingano ge, okob gitangi ebe atob ei nilgum gen ti dang etenik ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Be eisir iwel ei avo be inei, “Tinem gikuv mie tis tiate yapin. Dangetok be mie gitangi ebe atob numbul amei ok ite, gitangi ite molge.” Bekob itin ei gile gihlang gikwai lum mateu ane aplo. ");
INSERT INTO kbm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yisu giute binge ve eisir Parisai itin amol ebe warik matano bop ok. Be bwayage kob ei gile vunge ve amol nok be ginei gitangi ei be ginei, “Mie aplom givin Pomate Natu ebe meng gihlang ve amolmol ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Amol nok giwel Yisu avo be ginei, “Amol Bamo, os amol etok ru itangi ayeu be ali ma, veik aplongg nivin ei?” ");
INSERT INTO kbm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Be Yisu ginei gitangi ei be ginei, “Amol nok ete kakie givin mie givarkei nik.” ");
INSERT INTO kbm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Be amol nok ginei gitangi Yisu be ginei, “Amol Bamo, ayeu aplongg givin mie. Be giro va dubi supwe gisov nalk be ges miengk gitangi Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Be Yisu ginei gitangi amol nok be ginei, “Ayeu ganme nalk etenik ve nalgum amolmol as yaun. Be amolmol ebe ili gen bemem itpweng are ite ok, atob inatpweng gen ar-kares, be eisir ebe itpweng gen ar-kares ok, atob inatpweng gen ti are ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Eisir Parisai subu ebe ivarkei be iute yaun etok ok, tas gitung ve inei atob Yisu ninei yaun ret nipil eisir as luev ebe ivang ok, beti iutani Yisu be inei; “Amei ok matanongg amei bop givin me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Be Yisu giwel eisir avos be ginei, “Ginei yem matanongg aim bop, atob yem unalgum gen tiate ite ma. Bemem yem unei dangeteik unei, ‘Amei matanongg amei sang-sangas vie molge.’ Dangetok, be yem aim gen tiate ete giengk nik.” ");
INSERT INTO kbm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Be Yisu ginei, “Ayeu nanei bingano ge nitangi yem nanei: Amol ti ebe gisov bwelk as el ane nam avo roro gile ite, be ei ges kiemk gireu sawa ti gile gisov el aplo ok, amol etok ei amol vaina ane ti, be ei amol ti ebe girwel amolmol as gen giriv be gira ok. ");
INSERT INTO kbm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bemem amol ebe givang gitangi nam avo roro-ngge gile be gile gisov el aplo ok, amol etok ete bwelk as tivias ei bingano ge. ");
INSERT INTO kbm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Be amol ebe geb nam avo dabin ok, atob nes nam avo ponge be amol nok nisov el aplo nile be nital ane bwelk ar-kares, be nitwem is inde inahlang inkwai el aplo. ");
INSERT INTO kbm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Amol nok atob nes ane bwelk inde inahlang inkwai el aplo, bekob atob ei ate nimungg be ane bwelk tepwengge atob intau inde ei, ve eisir itpweng ei avo are gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Be bwelk etok wat atob inde intau nile amol ebeok ti sin-ge ite ma, atob inpelk inkwai ve gisov eisir itpweng amolmol ebeok sinsin ge avos are ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisu ginei yaun ai etok gitangi eisir Parisai, bemem eisir itpweng yaun etok ane dabe are ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Beti Yisu ginei yaun nok vukuri be ginei; “Ayeu nanei bingano ge nitangi yem nanei: Bwelk sipsip as nam avo ayeu ate eteik. ");
INSERT INTO kbm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Be amolmol bambamo ete warik imungg inme inme ok, etok amolmol vaina ane be amolmol ebe irwel amolmol as gen giriv be gira ok ge tepwe etok. Eisir imungg inme bemem bwelk sipsip iute eisir avos ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Bemem ayeu, ayeu nam avo ebe ve insov bwelk sipsip as el aplo inde ok eteik. Dangetok be ginei amol ti nivang nitangi ayeu ninme be nisov el aplo nile, ei wat ninggas tiate ite ma, atob Pomate nemb ei ru be nimbweg vie-ngge. Be atob ei nisov nile be menihlang be nilgum dangetok nivang be atob ninggas ane gen vevies ge. ");
INSERT INTO kbm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Amolmol vaina ane inme ve gen ti ane givin ite ma. Eisir inme ve invaina bwelk be tis ebe ve ines bwelk vun-kunu, be ebe ve invin-vin bwelk niriv be nira ok ge. Bemem ayeu, ayeu ganme veik nalgum be eisir inambweg matawas vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Bwelk sipsip as amol vie ebe geb is dabin ok ete ayeu ik. Be atob namb au-ate nawel bwelk sipsip nok be namat vunu ve eisir ane. ");
INSERT INTO kbm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Amol ebe geb kulkul ve geb bwelk dabin be ei gilgum ve mone ane ge ok, etok bwelk as tivias ei roro ite ma, be etok ei ane bwelk roro ite. Dangetok be ginei ei nili uvun valir ane ebe gituvki gitangi ei tis bwelk gile ok, kob atob nipelk nikwai bwelk be uvun inde be inlat is be in-vinvin is inriv be inra. ");
INSERT INTO kbm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ve gisov ei geb kulkul ve none ane ge, be ei gitangi ebe ve nemb ta ve bwelk is likok ane ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ayeu amol vie molge ebe gab bwelk sipsip dabin ok. Be ayeu gatpweng angg bwelk are be eisir ok itpweng ayeu are, ");
INSERT INTO kbm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Dangete Tamangg gitpweng ayeu are be ayeu gatpweng Tamangg are ok. Be atob ayeu namb au-ate natangi tanmat vunu ane gwangne nale nawel eisir. ");
INSERT INTO kbm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Awangg bwelk sipsip dubi ti ete ivang nik. Bemem eisir ivang dongke ivin bwelk etenik ite ma, beti atob ayeu namb kulkul ve nanggas eisir inme inpil dongke kob. Veik eisir inaute ayeu avongg, be invang weik bwelk vu dongke ge be tivias dongke. ");
INSERT INTO kbm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamangg ta givin ayeu anongge, ve gisov atob ayeu namb au-ate natangi gimat ane gwangne nale be namat vunu, bekob atob matawangg be namdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amol ti gigas ayeu dalgongg matawangg ane gikwai ite ma. Etok ayeu ate angg tangg givin beti gab au-ate gatangi tanmat vunu ane gwangne gale. Ayeu angg gwangne gitangi ebe ve namat vunu, bekob matawangg be namdil vukuri ok. Yaun etenik ayeu gaute nangge Tamangg avo.” ");
INSERT INTO kbm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bambamo Juda ane iute yaun etok love emb is ate vusa gile dubi ailu vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Amolmol tavlu bamo ge inei yaun gipil Yisu be inei, “Ngalau tiate givang givin amol etenok beti gilgum ei be wele-wele, be yem ute ei ane yaun ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Be eisir subu inei, “Ngalau tiate ginei nivang nivin amol ti, atob amol etok ninei yaun dang-dang etenik be nilgum amolmol ebe matanos bop ok be ponge ok ite ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aiweng ebe warik eisir Juda ilgum ben ve es lum yamar bamo ebe givarkei Jerusalem ok ane nam avo ponge ok ande meng gihlang. Beti eisir veve inalgum ben bamo nok vukuri. Be etok aiweng urwemb ane roro. ");
INSERT INTO kbm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Be Yisu gilauk givang lum yamar bamo nok ane aplo ti ebe ital inei Solomon ane samuak ok. ");
INSERT INTO kbm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Beti bambamo Juda ane ile be ivarkei ile idbul ei be iutani ei be inei, “Atob mie nulgum be amei tangg amei nitung walang walang dangetok anvang love asger kob? Ginei mie amol (Kilisi) ebe ve nomb amolmol dabin ok bingano ge, okob unei im ate lavo itangi amei ma?” ");
INSERT INTO kbm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Beti Yisu giwel eisir avos be ginei, “Ayeu ganei gitangi yem gikwai bemem yem aplongg aim givin ite. Kulkul bambamo ete ayeu galgum ve Tamangg ane gwangne ane ok, kulkul etok ete ginei ayeu lavo gitangi yem gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bemem awangg bwelk sipsip subu ete yem nok ite, beti aplongg aim givin ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Awangg bwelk sipsip eisir itpweng ayeu avongg are be isov ane lu ge be itau ile ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eisir ande inggas ebe ve inambweg matawas nemb ta ge ok gikwai, be gitangi ebe atob inmat vunu mang-mangi ok ite ma. Be amol ti gitangi ebe atob ninggas eisir nangge ayeu baingg be inde ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tamangg geb eisir etok gisov ayeu baingg. Be gen walang etenik isov Tamangg dongke ge ane gwangne ane lu ge, dangetok be amol ti gitangi ebe ve ninggas eisir etok nangge ei bage ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Be eilu Tamangg eilu gen dongke ge.” ");
INSERT INTO kbm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yaun etok gilgum eisir bambamo Juda ane be aplos tiate molge, beti bais gisov vat vukuri ve ines Yisu vunu. ");
INSERT INTO kbm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Beti Yisu ginei gitangi eisir be ginei, “Ayeu gas Tamangg ane kulkul vevies walang ano ru gitangi yem be uli gikwai. Be yem ve unes ayeu vunu nisov gen vie ret?” ");
INSERT INTO kbm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Be bambamo Juda ane iwel Yisu avo be inei, “Amei algum ve anes mie ve vat gisov gen vevies ete mie gulgum ok ane ite ma. Bemem gisov mie amol ebeok sin-ge ti, bekob guhle Pomate be avom givwat im-ate ve gunei mie Pomate me-rav?” ");
INSERT INTO kbm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yisu giwel eisir avos be ginei, “Yem ate aim yaun ti ginei dang eteik ginei: ‘Ayeu ganei gikwai ganei yem pomate.’ ");
INSERT INTO kbm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ei gital amolmol ebe warik inggas Pomate ane yaun gimungg ok ginei pomate. Dangetok be yaun ete ande iro bwalbwale gisov Pomate ane kapia gile gikwai ok gitangi ebe atob tansin nikwai ok ite ma, atob niengk be niengk dangetok. ");
INSERT INTO kbm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Be ayeu ok weik etok ge, Tamangg Pomate geb ayeu beti gihlin ayeu be gasov nalk ganme. Be namnambed be yem unei ayeu ganei yaun ungglus ungglus gipil Pomate, gisov ebe ganei Pomate Natu ayeu ok? ");
INSERT INTO kbm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Bingano, ginei ayeu nalgum Tamangg ane kulkul ite, okob etok gitangi ginei yem aplongg aim nivin awangg yaun bwaya. ");
INSERT INTO kbm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bemem ayeu galgum ei ane kulkul, be ginei yem ande bwaingg aim ve ret aplongg aim nivin awangg yaun okob etok gitangi ebe yem undi niengk kulkul bambamo ete ayeu galgum ok be aplongg aim nivin ok. Veik unatpweng are be tangg aim nitung dangeteik unei: Tamangg givang givin ayeu, be ayeu gavang gavin Tamangg.” ");
INSERT INTO kbm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Beti eisir bambamo Juda ane ilgum veve inemb Yisu ta vukuri, ve gisov ebe ei ginei dangetok ginei, ‘Ayeu gabweg gavin Tamangg,’ ok, bemem ei geb ate lili gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yisu ginumul gile vukuri love ges bui Joldan gili gile gipil tavlu be gile gihlang nam dabe ti ebe warik Jon gilgum kulkul ve ges bui sanggu gipil amolmol nangge ok, be gibweg etok. ");
INSERT INTO kbm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bekob amolmol anongge ivang itangi ei ile, be eisir nok inei ve is ate be inei, “Bingano, Jon ei gilgum gen bwal bwale ti ite ma. Bemem yaun bambamo ete ei ginei gipil amol etenik ok, yaun etok ano molge.” ");
INSERT INTO kbm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Be amolmol anongge nangge taku etok aplos givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Amol gimat ti are Lasarus nangge nam Betania. Malia gabu mala-vie Mata, sulu as nam etok. ");
INSERT INTO kbm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Be Malia etok ebe warik gimsuli marasin ukwas ti gireu Yisu utle ulis bekob gisin gibui ve ei ate dabe-lan ok. Be gen nok luvu Lasarus ete gigas gimat ok.) ");
INSERT INTO kbm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Malia gabu mala-vie Mata nok emb yaun gile ve Yisu be inei, “Amol Bamo, am nune ebe tam givin ei gitlek molge ok ete ande gigas gimat be giengk ik.” ");
INSERT INTO kbm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yisu giute ebe Lasarus gigas gimat ok binge be ginei, “Gimat ete Lasarus gigas ok ebe ve nes amolmol vunu ok ite ma, ei ane gimat etok atob nes Pomate ane gwangne be tis ane bogbogo ru nitangi amolmol be indi, kob atob avos nivwat Pomate Natu ayeu arengg ve ebe gas Lasarus itin ok.” ");
INSERT INTO kbm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisu ta givin Malia gabu mala-vie Mata be luvus Lasarus anongge. ");
INSERT INTO kbm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Be ei ande giute ebe Lasarus gigas gimat ok binge gikwai, bemem gibweg as mate ailu givin nangge taku ete gibweg ok. ");
INSERT INTO kbm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","As mate ailu etok gile gikwai kob ei ginei gitangi ane singamolomb gen amei be ginei, “Eitit tandumul tande Juda as taku vukuri.” ");
INSERT INTO kbm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Beti amei singamolomb inei gitangi ei be anei, “Gidung, vasov-nik ge bambamo Juda ane ilgum ve ines mie ve vat, be mie ve nunumul nule eteok ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Be Yisu ginei bing ai ti gitangi amei singamolomb gipil sawa ebe Pomate geb yapin ve atob ei nimat vunu ane ok be ginei, “As mate ti ane as matano sawa gitangi 12. Dangetok be amol ti ginei nivang tis ebe as givarkei nangge ok, atob ei nirau nile ei dabe me nitut va nipil vat be tis ei wakas ite ma. Ve atob as niro taku be bogbogo be atob ei nile va lavo ebe ve nivang ok vevie. ");
INSERT INTO kbm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bemem ginei ei nivang tis tambok atob ei ninding taku niriv be nira ve etok tambok aiweng tumi tiate.” ");
INSERT INTO kbm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisu ginei yaun etok gikwai kob ginei gitangi amei singamolomb vukuri be ginei, “Eitit and nune Lasarus ande giengk, bemem atob tande kob ayeu nas ei itin.” ");
INSERT INTO kbm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Be amei awel ei avo be anei, “Amol bamo, ginei ei matano giengk beti giengk, atob ei matano sang-sangas kob nimdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yisu ginei ebe ande Lasarus gimat vunu ok. Bemem amei singamolomb anei bwat ei ginei Lasarus matano giengk beti giengk. ");
INSERT INTO kbm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Beti ei ginei lavo gitangi amei be ginei, “Lasarus ande gimat vunu gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bemem etok vie ve ayeu gabweg gavin tis sawa ete ei gimat vunu ok ite. Be ayeu galgum etok veik yem undi awangg gwangne ebe atob namb kulkul nipil ei ok veik aplongg aim nivin ayeu. Dangetok be unamdil be tale.” ");
INSERT INTO kbm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Be Tomas (ebe ital are ti inei bwa-bwak ok) ginei gitangi amei singamolomb subu be ginei, “Unamdil be tale, veik eitit ok tanmat vunu tavin ei.” ");
INSERT INTO kbm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisu givang love gibielk Betania be giute inei ispun Lasarus tis ebe walirik, be ande as-mate aivat gile gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania nok giengk gile gibloblo Jerusalem ge, ");
INSERT INTO kbm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","beti amolmol Juda ane anongge inme ve imbweg ivin Malia gabu mala-vie Mata be emb bing bwai bwaya gitangi sulu veik aplos bunam molge ve luvus ane bwaya. ");
INSERT INTO kbm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata giute ebe inei Yisu ete givang ve ginme nik ok, be ei gile gihlang be gile ve niro Yisu ta nangge luev. Bemem Malia ei gibweg ebe nam aplo ok yapin. ");
INSERT INTO kbm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata gile vunge ve Yisu be ginei gitangi Yisu be ginei, “Amol Bamo, ginei walirik mie numbweg etenik atob ayeu luvungg nimat vunu ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bemem ayeu gatpweng are dangetok ganei gen ret ete galkik mie ve nutani Pomate be nilgum ok, atob Pomate nemb gen etok nitangi mie bingano ge.” ");
INSERT INTO kbm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yisu ginei gitangi Mata be ginei, “Mie luvum atob matawe be nimdil vukuri.” ");
INSERT INTO kbm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Be Mata giwel Yisu avo be ginei, “Ayeu ok gatpweng are, ve asonge ei matawe be nimdil vukuri nindeb mul ane, nivin ebe amolmol ebe imat vun-kunu ok ve inamdil vukuri ok.” ");
INSERT INTO kbm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Be Yisu ginei, “Inamdil vukuri nangge taku gimat ane, ane dabe ayeu. Be inambweg matawas ane dabe ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amolmol ete galkik imbweg nik ginei aplos nivin ayeu, okob eisir ok atob inmat vunu, bemem dalgos atob nimbweg matawe dangetok nindeb mul ane. Mie aplom givin yaun etok me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata giwel Yisu avo be ginei, “Amol Bamo, ayeu aplongg givin ganei mie amol (Kilisi) ebe ve nomb amolmol dabin ok. Be Pomate ane Natu mie, ebe warik Pomate ginei atob ninme nalk ok.” ");
INSERT INTO kbm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata ginei yaun etok gikwai bekob gile gital kawa-vie Malia ginme be gigas ei gile aikawe kob ginei bwaya-gege gitangi ei be ginei, “Gidung ete ande ginme ok, be ei giutani mie.” ");
INSERT INTO kbm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia giute yaun etok be seukie-ngge gimdil be gitangi Yisu gile. ");
INSERT INTO kbm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Ve Yisu gibielk ebe nam ok ite nangge, ei givang taku ebe galkik Mata gile vunge ve ei nangge ok ge nangge.) ");
INSERT INTO kbm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Beti eisir Juda ebe imbweg ivin Malia nangge nam aplo ve emb bing bwai bwaya gitangi ei ok, ili ebe ei gimdil be seukie-ngge gile gihlang ok be ivang mul ve ei ile. Eisir inei bwat Malia gile ve nilgum tangir nangge ebe taku gimat ane ok. ");
INSERT INTO kbm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia gile love gibielk ve taku ebe Yisu gibweg ok be gili ei, be giro va dubi supwe gisov nalk gibloblo Yisu va be ginei, “Amol Bamo, ginei mie numbweg etenik atob ayeu luvungg nimat vunu ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yisu gili Malia be tis eisir Juda ebe ivin Malia ok iteng ok, be aplo bunam molge be veve niteng. ");
INSERT INTO kbm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Be ginei, “Yem uspun Lasarus giengk inend?” Be eisir inei gitangi ei be inei, “Amol Bamo, unme tale be uli.” ");
INSERT INTO kbm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yisu matano rulu bwal bwale. ");
INSERT INTO kbm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Beti eisir Juda ili be inei ve is ate be inei, “Ta-undi e, ei ta givin amol (Lasarus) etenik gitlek molge.” ");
INSERT INTO kbm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bemem amolmol subu inei, “Amol etenik ebe gilgum amol matano bop ti be matano ponge ok. Be ei gitangi ebe atob nemb Lasarus ru be nimat vunu ite ok me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisu aplo bunam molge, be gile love gibielk Lasarus ane umbub. Be nalk avo nok itav gisov vat avo bamo ti, be itak vat tap-tape ti ve gisil nalk avo avut. ");
INSERT INTO kbm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Be Yisu ginei, “Undug-dug vat bamo etok ikwai nalk avo.” Be Lasarus nok luvu-avie Mata ginei gitangi Yisu be ginei, “Amol Bamo, amei aspun ei tis ebe walirik ba ande as mate aivat gile gikwai be atob uve tiate molge.” ");
INSERT INTO kbm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Be Yisu ginei gitangi ei be ginei, “Ayeu ganei gitangi mie gikwai ganei ginei mie aplom nivin, atob mie nuli Pomate ane gwangne nisov matanom. Bemem ande wat mie tam-givalngan yaun ete ayeu ganei gitangi mie ok me?” ");
INSERT INTO kbm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Beti eisir indug-dug vat bamo etok gikwai nalk avo. Yisu gidank gireu gulumb be ginei, “Tamangg, ayeu ve nanei angg tangg vie nitangi mie ve mie gute awangg tanggir gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ayeu gatpweng are gikwai ganei mie gute awangg yaun tis as mate walang ok gigas ta ge. Bemem gisov amolmol bambamo ete ivarkei meid-bul ayeu ik ane ge, beti ayeu ganei yaun etenok. Veik eisir inatpweng are roro-ngge inei mie guhlin ayeu beti ganme.” ");
INSERT INTO kbm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yisu ginei yaun etok gikwai kob gital avo bamo ge be ginei, “Lasarus, umdil be mohlang.” ");
INSERT INTO kbm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasarus gimdil be meng gihlang gikwai nalk avo tis kambam den-den ebe idgin ei bage tis va be dabe ta ok ge. Beti Yisu ginei gitangi eisir be ginei, “Unahlang kambam den-den etok ikwai ei be ile.” ");
INSERT INTO kbm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Eisir Juda ebe itau ile Malia be ile ok, ili gen bamo ete Yisu gilgum ok love aplos givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bemem eisir Juda nok subu inumul itangi eisir Parisai ile be inei gen ete Yisu gilgum ok binge gitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Beti eisir Parisai be bambamo ebe emb da nangge lum yamar ok, iro eisir awaga sut be inei gitangi eisir be inei, “Amol etenik ande gilgum gen bwal-bwale walang ano molge be atob eitit tanalgum ei nam-nambed? ");
INSERT INTO kbm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ve ginei eitit nand niro ei ta ge be nilgum ane gen painge ge, atob amolmol tepwengge aplos nivin ei ge. Kob atob amolmol Rom ane as amol bamo atob ninme be niyaing eitit and lum yamar, be ninggas eitit and amolmol gen tepwengge.” ");
INSERT INTO kbm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Be givin Sonda bamo etok ete eisir emb amol ti are Kaiapas, ve nemb ane sukus-gen ebe tepwe emb kulkul da ane nangge lum yamar ok dabin. Kaiapas nok gimdil be ginei gitangi eisir be ginei, “Wat yem utpweng are ite me? ");
INSERT INTO kbm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Me wat ande yem tangg aim givalngan yaun etok me? Gen etok vie ve amol dongke etenik ge nimat vunu niwel amolmol tepwengge, veik amolmol tepwengge inambweg matawas.” ");
INSERT INTO kbm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas ginei yaun etok gitangi ebe ei-ate ta gitung ok ite ma. Ve givin Sonda bamo etok ete emb ei ve nemb ane amolmol gen ebe tepwe emb kulkul da ane nangge lum yamar ok dabin ok, beti ei ginei yaun etok gipil gen ebe atob menihlang nindeb mul ane ok. Ve atob Yisu nimat vunu niwel amolmol Juda ane. ");
INSERT INTO kbm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Be ei atob nimat vunu ve eisir Juda ane ge ite ma. Bemem atob ei nimat vunu veik niro Pomate ane amolmol gen ebe imbweg iriv be ira nangge nalk etenik sut insov dongke be inambweg weik ebe eisir vu dongke ok. ");
INSERT INTO kbm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Be givin as mate etok ge ete eisir ilgum yaun be irek luev ebe ve ines Yisu vunu ok. ");
INSERT INTO kbm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Beti Yisu gilek be ginme givang eisir Juda nas vukuri ite ma. Ei tis ane singamolomb gen imdil ikwai taku etok be ile love imbielk nam dabe ti are Epraim be imbweg etok. Nam dabe etok giengk gibloblo taku sawa ebe amolmol ti gibweg ite ok. ");
INSERT INTO kbm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Be sawa ebe amolmol Juda ane ve inalgum as ben Sonda Pasova ane ok ande ginme gibloblo. Beti eisir Juda nangge taku walang ok imdil be ireu Jerusalem ile ve in-pasang is ate yapin. ");
INSERT INTO kbm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eisir Parisai tis bambamo Juda ane nok ilgum ve indi Yisu nangge ete Jerusalem ok, be isov lum yamar aplo ile be iutau-tani is ate be inei, “Yem tangg aim gitung nam-nambed? Atob ei ok ninme ve nili Sonda nivin me ma?” ");
INSERT INTO kbm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bambamo Juda ane tis eisir Parisai nok ande inei gitangi amolmol tepwengge gikwai inei, Ginei amol ti gili Yisu nangge sawa ti okob nile ninei binge nitangi eisir. Veik inde be inemb ei ta. ");
INSERT INTO kbm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","As mate bage tavlu be ano dongke (6) ge giengk nangge ebe ve Juda as Sonda Pasova menihlang ok. Be givin sawa etok ete Yisu gimdil gile Betania. Be nam dabe nok, ete Lasarus, amol ebe warik Yisu ges itin nangge taku gimat ane vukuri ok ane nam. ");
INSERT INTO kbm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Be givin as mate etok ete eisir ilgum ben ve Yisu tis ane singamolomb gen nangge nam dabe nok. Mata ei geb kulkul ve giro giro ben be luvu Lasarus gile gibweg givin Yisu tis amolmol subu ebe imbweg ve en ben ok. ");
INSERT INTO kbm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bekob Malia givwat marasin ukwas ti ebe ane vat (mone) bamo molge ok, gisov gen-mate ti be gitangi Yisu gile be giro marasin ukwas nok gireu Yisu va bekob gisin gibui ve ei ate dabe-lan. Marasin etok ane ukwas givir-viri nam aplo ete eisir imbweg ve en ben ok tiate molge. ");
INSERT INTO kbm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yisu ane singamolomb ti are Judas Iskariot, amol nok ebe atob bwayage kob ninei Yisu binge nitangi amolmol ebe ve ines ei vunu ok, gimdil be ginei, ");
INSERT INTO kbm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Marasin etenik gitangi ebe ve tanemb nitangi amolmol be inavgo ve mone Sonda bamo ti ane, be tanemb mone nok nitangi amolmol ebe wambal ma ve is ok.” ");
INSERT INTO kbm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ei ta gitung amolmol ebe wambal ma ve is ok beti ginei yaun avo etok ite ma. Ve ei amol ebe geb eisir singamolomb as ting mone ane dabin ok, bemem ei amol vaina tine ti. Be gen subu subu ebe amolmol bais vier gisov ting etok ok, ete ei givwat givwat gigas ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Beti Yisu ginei, “Nangg aim vier, ve avie etenik gilgum gen vie etenik ve gipasang ayeu utlangg ulis nalk avo ane yapin. ");
INSERT INTO kbm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yem asonge unambweg unvin amolmol ebe wambal ma ve is ok ninggas ta ge, kob atob unemb eisir ru. Bemem ayeu gitangi ebe atob navang navin yem ninggas ta ge ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eisir Juda dubi bamo ti iute ebe Yisu gibweg nangge Betania ok binge beti imdil be ivang itangi ei ile. Be eisir nok ile ve Yisu ane ge ite ma, eisir ve indi Lasarus ebe warik Yisu ges ei itin nangge taku gimat ane vukuri ok nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Beti bambamo ebe emb kulkul da ane ok ilgum Lasarus ane yaun be inei atob ines ei vunu nivin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ve gisov eisir Juda anongge molge tas gitung Lasarus ebe gimdil nangge taku gimat ane vukuri ok, beti eisir bwais ve bambamo da ane be aplos givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Amolmol bamo ge ande imbweg nangge Jerusalem gikwai ebe ve indi Sonda Pasova ane ok, be givin tistumi eisir iute binge inei Yisu atob nireu nile Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Beti eisir imdil be bais gisov ei-lan tis range tis range be iro Yisu avkavut nangge luev be ital dangeteik inei: “Avond nivwat Pomate are! Ve gihlin Amol ebe ve nemb eitit dabin ok, be ginme weik Amol Bamo (King) ti. Pomate geb ane gwangne gitangi ei, ebe ve nemb eitit dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Be givin etok ete Yisu gibweg giwei bwelk dongki ti be givang ve gile. Be gen etok gitangi yaun ebe giengk Pomate ane kapia ok. Ve yaun etok ginei dang eteik: ");
INSERT INTO kbm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Atob yem unei nitangi amolmol Jerusalem ane unei, Unpelk bwaya. Galkik etenik yem aim Amol (King) Bamo ebe ve nemb aim dabin ok, gibweg giwei bwelk dongki vaku ti be gitangi aim gilek.” ");
INSERT INTO kbm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Be givin sawa etok ete amei singamolomb tangg amei gisgil yaun etok ane dabe. Bemem givin ebe Yisu matawe be gimdil gikwai taku gimat ane be gigas ane bogbogo ok, okob ete amei atpweng are anei avo ete giengk Pomate ane kapia ok ginei yaun gipil ei bingano ge. Beti amei tangg amei gitung gile gen ebe warik amolmol ilgum gitangi ei ok vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Amolmol ebe ivarkei ivin, givin ebe Yisu gital Lasarus be gimdil gikwai nalk avo be meng gihlang vukuri be ili gisov matanos givin ok, inei gen ete Yisu gilum ok ane yaun gitangi amolmol subu givin be iute. ");
INSERT INTO kbm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Beti amolmol ebe iute gen bwal bwale etok ane binge ge ok, tepwengge imdil be iro Yisu av-kavut nangge luev ile. ");
INSERT INTO kbm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Beti eisir Parisai inei ve is ate be inei, “Undi kob. Ve eitit and yaun ebe tanei ok atob ano ma. Ve amolmol tepwengge ete ande ivang itangi ei ge ile ok.” ");
INSERT INTO kbm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amolmol Grik ane subu ivin eisir bambamo ebe ireu ile Jerusalem ve ines miengk nivin Sonda Pasova ane ok be ile. ");
INSERT INTO kbm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Eisir nok ivang itangi Pilip ile be inei, “Amei veve andi Yisu.” (Pilip ei amol Betsaida ane gideb Galilaia ane.) ");
INSERT INTO kbm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Beti Pilip gile ginei ve Endru be gabu ile inei lavo ve Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yisu giwel sulu avos be ginei yaun-ai ti gipil ei ate ebe atob nimat vunu ok be ginei, “Sawa ebe Pomate Natu Ayeu ebe meng gahlang weik amolmol ok ve nanggas angg bogbogo ok ande gibloblo tepwe. ");
INSERT INTO kbm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Be Ayeu nanei bingano ge nitangi yem nanei: Yanggo ano natu dongke ge ginei gisov nalk aplo gile be gipiel ite, atob nes ano ite ma. Ei nisov nalk aplo nile be nipiel nikwai bekob atob tuvu vukuri be nireu love nes ano anongge nitlek ano dongke ete mate ane ok. ");
INSERT INTO kbm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Amolmol ebe tas gitung utlas ulis bamo molge ok, atob inmat vunu vukuri nindeb mul ane be atob inyengk em inyengk nalk aplo. Bemem amolmol ebe tas gitung utlas ulis ite be inggas vavavne be imat vunu ve awangg kulkul ane ok, ete atob inambweg matawas vie-ngge nindeb mul ane ninggas ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Amol Grik ane ti me amol ebeok ti ginei ta gitung ve nilgum awangg kulkul, okob ei nitau nile awangg luev ge. Be taku ete ayeu ve nambweg ok ete atob angg amolmol kulkul ane inambweg invin ayeu nangge taku etok invin. Ve ginei amol ti nilgum awangg kulkul, atob Tamangg avo nivwat amol etok are. ");
INSERT INTO kbm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Be Yisu ginei, Ayeu ande atengg giro gireu gireu be gakur-kuri anongge. Be atob ayeu namdom au-ate? Gitangi ebe ayeu nanei ve Tamangg be nanei, ‘Tamangg, omb ayeu ru be uitin gen bunam ete ve menihlang nipil ayeu ok nikwai ok me ma?’ Ma yapin. Ayeu atob nanei yaun dangetok ite. Ve etok awangg gen bunam ebe ve nanggas ok roro. ");
INSERT INTO kbm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamangg, ulgum veik am binge nivang nemb taku avut.” Yisu ginei yaun etok gikwai, bekob avo ti gisov nangge gulumb dang eteik: “Ayeu ande galgum be arengg bamo gikwai, be atob nalgum vukuri be menihlang bamo ge.” ");
INSERT INTO kbm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Amolmol ebe tis dubi-dubi ivarkei etok ok iute avo etok be inei, “Ta-unaute walpap bamo ti ebe gitut ok.” Be eisir subu inei, “Angela ti wat ginei yaun gitangi ei me?” ");
INSERT INTO kbm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Be Yisu giwel yaun ete eisir inei ok be ginei, “Avo etok meng gihlang ve nemb ayeu ru ite ma. Avo etok meng gihlang ve nemb yem ru. ");
INSERT INTO kbm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Be galkik as mate etenik, etek sawa ebe Pomate ve nilgum amolmol as yaun ok. Be atob ei nitin nalk etenik ane tivie nikwai. ");
INSERT INTO kbm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Galkik etenik ayeu gavarkei gawei nalk, bemem bwayage kob nivin ebe amolmol valir ane veve inrun ayeu itin nale nawei ei-givsangin ok, okob atob ayeu narwel amolmol tepwengge intangi ayeu inme.” ");
INSERT INTO kbm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yisu ve nes luev ebe atob nimat vunu ane ok ru nitangi amolmol, beti ginei yaun etok. ");
INSERT INTO kbm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Beti amolmol iwel Yisu avo be inei, “Mose ane yaun ginei yaun ti gitangi amei dang eteik: Amol (Kilisi) Bamo ebe ve nemb amolmol dabin ok, gitangi ebe atob nimat vunu ok ite molge. Be nam nambed ande mie gunei, ‘Atob eisir inrun Pomate Natu ebe meng gihlang weik amolmol ok itin?’ Be Pomate Natu ete meng gihlang weik amolmol ok, wali nangge?” ");
INSERT INTO kbm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Be Yisu giwel eisir avos be ginei: “Ayeu weik yev ebe giro taku be bogbogo ok, be atob niro yem sawa sitingge nivin bekob. Dangetok be yem unalgum aim kulkul tis ete yev giro aim nangge nik. Velob aiweng tumi ninme nisum aim avut. Ve amol ti ginei nimdil be nivang tis tambok aiweng tumi tiate, atob ei ta nisgil taku ebe ve nile ok. ");
INSERT INTO kbm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dangetok be aplongg aim nivin yev nok, tis sawa ete yev etok giengk givin yem nik. Veik unvang weik amolmol ebe ivang tis yev ge ok. Yisu ginei yaun etok gikwai kob gile be givang givuai-vun ate ge be givang eisir nas gil-kili vukuri ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yisu gilgum gen bwal bwale walang ano molge be eisir ili gikwai, bemem aplos givin ei ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Be gen dangetok, beti yaun ti ebe warik Pomate ane amol kulkul ane ti are Aisaia ginei ok ande ano gile. Ve Aisaia ginei dang eteik: “Amol Bamo, Asav ge aplos givin mateu ete amei anei anei ok? Be Mie gos am gwangne ru gitangi asav? Ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eisir aplos givin Yisu ite, ve gisov Aisaia nok ge giro yaun ti vukuri dangeteik; ");
INSERT INTO kbm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pomate gilgum eisir matanos be avu-avu gikwai, beti eisir ok atob indi gen bemem atob indi gen ano ti ite ma. Be gilgum aplos love dad-dani be tulkwe weik ebe vat ok. Beti bwais ve ret tas nitung gen vevie niengk aplos be inro is ate vukir, be invang intangi ayeu inme veik nalgum be meinahlang amolmol vie ane.” ");
INSERT INTO kbm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Warik Aisaia gili gen ti weik ebe mev ok be gili Kilisi ane gwangne, beti ei ginei yaun etok gipil Kilisi ei ate. ");
INSERT INTO kbm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bingano, eisir awaga subu nangge Juda ok aplos givin Yisu givin. Bemem inei is ate vusa ite ve ipelk ve eisir Parisai. Ve eisir tas gitung inei lob Parisai inaitin eisir inde invarkei dume ane inkwai amolmol bui ane. ");
INSERT INTO kbm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Be givin ve eisir tas givin ve amolmol ge avos nivwat eisir ares, be bwais ve Pomate avo nivwat eisir ares. ");
INSERT INTO kbm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisu ginei yaun avo bamo ge gitangi amolmol be gine; “Amolmol ebe aplos givin ayeu ok, eisir aplos givin ayeu ge ite ma. Bemem etok weik ebe eisir aplos givin Tamangg ebe gihlin ayeu be ganme ok givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Be amolmol ebe ili ayeu ok, etok weik eisir ili Tamangg givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ayeu ganme nalk etenik weik yev ti ebe giro taku be bogbogo ok. Veik amolmol tepwengge ebe aplos givin ok, invang insov bogbogo etok aplo. ");
INSERT INTO kbm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Be amol ti ginei giute awangg yaun bemem bua ve ret nilgum ano nile, okob ayeu wat nalgum ei ane yaun ite ma. Ve ayeu ganme ve nalgum amolmol as yaun okob-ti, ayeu ganme ve namb eisir ru. ");
INSERT INTO kbm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bemem amolmol ebe ivkir dumas gitangi ayeu be bwais ve inaute awangg ok, eisir etok ete atob in-gas yaun nindeb mul ane. Be yaun bambamo ebe ayeu ganei ganei ok ete atob nemb vavavne nitangi eisir, nivin ebe gen bambamo etenik ve ma nikwai ok. ");
INSERT INTO kbm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ve gisov ayeu galgum gen be ganei yaun ti gitangi ebe angg tangg gitung ok ite ma. Tamangg ebe gihlin ayeu be ganme ok, ete ginei yaun be tis gen bambamo ete ayeu galgum be ganei ok, gitangi ayeu ve nalgum be nanei. ");
INSERT INTO kbm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Be ayeu gatpweng are ganei Tamangg ane yaun etok ete gilgum amolmol be atob inambweg matawas nemb ta ge. Beti yaun bambamo ete ayeu ganei ganei ok, ebe ga-gas nangge Tamangg ok ge.” ");
INSERT INTO kbm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gibloblo ve eisir Juda inalgum as ben Sonda Pasova ane. Be givin etok Yisu gitpweng are gikwai ginei sawa ebe ei ve nikwai nalk etenik be ninumul nitangi Tame nile ok, ande gibloblo tepwe. Be ei ta viti ve ane amolmol gen ebe imbweg nangge nalk ok, be givang tis aplo bunam ge ve eisir ane painge love gimat vunu sin-ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Be givin as mate etok ane gibok Yisu tis ane singamolomb gen amei an ben ambweg. Be Sadam ande gitwep Saimon Iskariot natu Judas gile gikwai, ve ninei Yisu binge nitangi amolmol ebe ve inalgum Ei tiate tiate ok. ");
INSERT INTO kbm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisu gitpweng are ginei Tame ande geb gen walang ok gitangi ei gikwai. Be gitpweng are givin ginei Pomate gihlin ei be ginme, beti atob ninumul nitangi Pomate nile vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yisu ve nes ane ta givin amei singamolomb ru nitangi amei beti gimdil nangge lavo ebe gibweg ok be giwaulu ane kup malar ane gikwai be gile giro taol ti. ");
INSERT INTO kbm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bekob gimsuli bui gisov bele kap-kapul bambe givuk amei singamolomb vangg amei, bekob gisin gibui ve taol ebe galkik giro. ");
INSERT INTO kbm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yisu gilgum dangetok ge giwei giwei love gibielk ve Saimon (ebe ital are ti inei Pita ok). Be Pita ginei gitangi ei be ginei; “Amol Bamo, mie ve nuvuk ayeu vangg me?” ");
INSERT INTO kbm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yisu giwel Pita avo be ginei; “Mie tam gisgil gen ete ayeu ve nalgum nik. Bemem mul ane kob atob mie nutpweng are.” ");
INSERT INTO kbm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be Pita ginei gitangi Yisu be ginei; “Amol Bamo, ginei dangetok okob mie nuvuk ayeu vangg ge Yisu giwel Pita avo be ginei; “Ginei ayeu navuk mie vam ite, atob ayeu nali mie weik angg singamolomb ti ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pita giwel Yisu avo be ginei; “Amol Bamo, mie nuvuk ayeu vangg ge ite bemem baingg tis dabangg ok nivin.” ");
INSERT INTO kbm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Be Yisu ginei gitangi ei be geb bing ai ti gipil amolmol aplond be ginei: “Ginei amol ti ande giringk bui gikwai atob ei utle tom ite ma, atob ei nivuk va ge be atob utle tepwengge vie. Be yem tepwengge ande utlangg aim vie love amol dongke-ngge.” ");
INSERT INTO kbm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yisu gitpweng amol ebe atob ninei Ei binge nitangi amolmol ebe ve inalgum ei tiate tiate ok are gikwai, beti ginei yem tepwengge ande utlangg aim vie gikwai bemem amol dongke ge ete ma). ");
INSERT INTO kbm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yisu givuk ane singamolomb gen amei vangg amei gikwai kob gino ane kup vukuri be ginumul gile gibweg lavo vukuri. Bekob giutani amei be ginei; “Ande yem utpweng gen ete galkik ayeu galgum gitangi yem ok are me ma? ");
INSERT INTO kbm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yem utal ayeu unei Gidung, be utal ti unei Amol Bamo, yem utal etok ok gile gitangi roro ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ayeu Gidung be ayeu Amol Bamo, be vasov nik-ge ayeu gavuk yem vangg aim. Dangetok be yem ok unvuk aim nune-nggen vas weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ayeu gas luev etok ru gitangi yem, dangetok be yem ok unvang mul ve luev ete galkik ayeu galgum gitangi yem be uli nik ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ayeu nanei bingano ge nitangi yem nanei: Amol kulkul ane ti gitlek ane amol bamo ebe geb ei dabin ok ite, be amol ruer ane ti gitlek amol ebe gihlin ei be gile. ");
INSERT INTO kbm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dangetok be ginei yem unvang mul ve luev ete galkik ayeu gas ru gitangi yem ok, atob yem unvang tis tangg aim vevie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ayeu ganei yaun etenik gitangi yem tepwengge ite ma. Ayeu gatpweng amolmol ebe gab eisir ve awangg gen ok are gikwai. Bemem yaun ebe giengk Pomate ane kapia ok galkik yaun etok ande ano gile. Be yaun nok dangeteik; ‘Amol ebe eilu an ben gisov bele dongke ok, geb va itin ve nivkwe ayeu pal-palali.’ ");
INSERT INTO kbm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gen etok ano gile ite nangge bemem ande ayeu ganei ane yaun gimungg gitangi yem gikwai. Dangetok be asonge nivin ebe gen etok ve menihlang ok, atob yem unatpweng are roro ge unei Ayeu ate nok eteik. ");
INSERT INTO kbm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Be ayeu nanei bingano ge nitangi yem nanei; “Ginei amol ti ninggas amol kulkul ane ti ebe ayeu gahlin gile ok nipil ane nam nile, etok weik ei gigas ayeu givin. Be amol ete gigas ayeu ok weik ebe gigas Tamangg ebe gihlin ayeu be ganme ok. ");
INSERT INTO kbm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisu ginei yaun etok givang be aplo bunam molge. Be ginei vusa ge gitangi amei singamolomb be ginei: “Ayeu nanei bingano ge nitangi yem nanei; Yem ate etenik aim amol ti atob ninei ayeu binge nitangi amolmol ebe ve inalgum ayeu tiate tiate ok.” ");
INSERT INTO kbm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yisu ginei dangetok beti amei singamolomb nangg amei giro amei ate ta avarkei be tangg amei gisgil amei ate ge, ve wali ei ginei yaun etok gipil amol ret roro ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Amei singamolomb amei amol ti ebe Yisu ta givin ei gitlek ok, amol nok gibweg gile gibloblo Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Beti Pita giruk na ve amol nok be ginei; “Mie utani Ei ma. Unei Ei ginei yaun etok gipil amol ret?” ");
INSERT INTO kbm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Beti amol nok gile gibloblo Yisu be giutani ei be ginei; “Amol Bamo; Mie gunei yaun galkok gipil amol ret?” ");
INSERT INTO kbm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yisu giwel amol nok avo be ginei; “Amol etok atob ayeu nasgil ben siti tis rulk be namb nitangi ei.” Bekob Yisu gisgil ben siti tis rulk be geb gitangi Saimon Iskariot natu Judas. ");
INSERT INTO kbm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas gen ben etok givang nangge, be Sadam ande gitwep ei aplo gile gikwai tis ebe galkik. Be Yisu ginei gitangi ei be ginei; “Gen ret ete mie tam gitung ve nulgum nok, ulgum seukie.” ");
INSERT INTO kbm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amei singamolomb tavlu ebe ambweg ve an ben ok, tangg amei gisgil yaun ete Yisu ginei gitangi Judas Iskariot ok ane dabe. ");
INSERT INTO kbm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas Iskariot nok ei amol ebe geb amei-mei ting mone ane dabin ok, beti eisir singamolomb tavlu inei bwat Yisu ginei gitangi ei ve nile be nivgo ben Sonda Pasova ane, me nemb gen ve amolmol subu ebe gen ma ve is ok. ");
INSERT INTO kbm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas gen ben etok gikwai bok-ti gimdil be seukie-ngge gile gihlang gikwai nam aplo, be givin etok ete taku ande tumi ve tambok. ");
INSERT INTO kbm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas Iskariot gile gihlang gikwai kob Yisu ginei gitangi amei singamolomb tavlu ebe ambweg ok be ginei; “As mate etenik atob Pomate ane Amol ayeu, atob nanggas angg bogbogo. Be atob amolmol avos nivwat Pomate are, ve gisov Pomate ane Amol ayeu ane ge. ");
INSERT INTO kbm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Be ginei Ayeu nalgum be amolmol avos nivwat Pomate are, atob Pomate avo nivwat ane Amol ayeu, be tis Ei ate ok arengg amei. Be kasop ge atob Ei nemb bogbogo nitangi Ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nunus gaptol, gibloblo ve atob ayeu navang nakwai yem. Be atob unrek ayeu love undi ma. Nolge ayeu ganei yaun eteik gitangi eisir Juda gikwai beti ve nanei nitangi yem vukuri nanei; Taku ete ayeu ve nale ok, yem gitangi ebe atob unde ok ite. ");
INSERT INTO kbm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Dangetok be ayeu ve namb luev vaku eteik nitangi yem: Tangg aim nivin aim nune-nggen dangete ayeu tangg givin yem ok. ");
INSERT INTO kbm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ginei yem tangg aim nivin aim nune-nggen ano molge, atob amolmol tepwengge inatpweng yem are inei awangg singamolomb gen yem bingano molge.” ");
INSERT INTO kbm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pita giutani Yisu be ginei; “Amol Bamo. Wali atob mie nuvang?” Yisu giwel ei avo be ginei; “Galkik as mate etenik atob mie gitangi ebe ve nutau nile ayeu love nule taku ete ayeu ve nale ok ite ma. Bemem mul ane kob atob mie nutau nile ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita giutani Yisu vukuri be ginei; “Amol Bamo, nam nambed beti atob ayeu natau nale mie tis as mate etenik ite? Ayeu gapasang au-ate gikwai ve atob namat vunu navin mie ane?” ");
INSERT INTO kbm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yisu giwel Pita avo be ginei; “Mie gunei atob numat vunu nuvin ayeu me-rav? Ayeu nanei bingano ge nitangi mie nanei: Atob kav-kavav niteng ite nangge be atob mie nos ayeu arengg ta nitangi bulwer aitol.” ");
INSERT INTO kbm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Be Yisu ginei gitangi amei singamolomb be ginei; “Atengg aim ireu be tangg aim itung walan-walang bwaya. Be aplongg aim nivin Ayeu ge weik ete aplongg aim givin Pomate ok. ");
INSERT INTO kbm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tamangg ane nam aplo walang molge ete giengk ok. Be ginei dangetok ite, okob nolge ayeu nanei nitangi yem nikwai nanei; Ayeu atob nale be napasang yem lavongg aim yapin. ");
INSERT INTO kbm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Be ginei ayeu nale be napasang yem lavongg aim nikwai, kob atob nanumul nanme be nanggas yem tande unambweg unvin ayeu. Veik taku ete ayeu ve nale ok, ete yem ok atob unambweg unvin ayeu nangge taku etok unvin. ");
INSERT INTO kbm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yem ande utpweng luev ebe givang gitangi taku ete ayeu ve nale ok are gikwai.” ");
INSERT INTO kbm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Be Tomas ginei gitangi ei be ginei; “Amol Bamo, amei tangg amei gisgil taku ete mie ve nule ok, be atob amei anatpweng luev etok are nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yisu giwel ei avo be ginei: “Ayeu luev, be yaun ano ane dabe ayeu, be inambweg matawas ane dabe ayeu. Amol ti gitangi nisu ate sin-ge nitangi Tamangg nile ite ma yapin. Ayeu navin ei okob. ");
INSERT INTO kbm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ginei galkik ande yem utpweng ayeu are, okob atob unatpweng Tamangg are weik etok ge. Be galkik etenik ande yem utpweng Tamangg are gikwai, be ande uli Ei gikwai.” ");
INSERT INTO kbm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Be Pilip ginei gitangi Yisu be ginei; “Amol Bamo, amei tangg amei givin anei Mie nos Tamem ru be amei andi, veik anautani Mie vukuri bwaya.” ");
INSERT INTO kbm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Be Yisu ginei: “Pilip; Ayeu gavang gavin yem tis ebe warik bemem mie gutpweng ayeu are ite me-rav? Amol ti ginei gili Ayeu, etok weik ebe ei gili Tamangg ok. Be nam nambed be mie gunei; ‘Os Tamem ru itangi amei?’ ");
INSERT INTO kbm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ayeu gavang gavin Tamangg be Tamangg givang givin ayeu. Bemem mie wat aplom givin ite me? Be yaun bambamo ete ayeu ganei gitangi yem ok, etok ayeu ganei gitangi ebe tangg gitung ok ite ma. Tamangg ebe givang givin ayeu ok, ete Ei ate gilgum ane kulkul. ");
INSERT INTO kbm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dangetok be aplongg aim nivin ge, ve Ayeu gavang givin Tamangg be Tamangg givang givin ayeu. Be ginei ma kob tangg aim nitung nile kulkul bambamo ebe ayeu galgum ok, veik aplongg aim nivin ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Bingano; Ayeu nanei bingano ge nitangi yem nanei: Amol ti ginei aplo givin ayeu, atob ei nilgum gen bwal-bwale bambamo weik ete ayeu galgum galgum ok. Be atob ei nilgum gen bambamo subu nivin nitlek ete ayeu galgum ok. Ve Ayeu atob natangi Tamangg nale, ");
INSERT INTO kbm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","be gen ret ret ete yem veve unautani ve ayeu arengg ane ok, atob ayeu nalgum nitangi ete yem unei ok. Be gen walang ete yem utani ayeu ve nalgum nitangi yem ok, atob naute yem aim yaun ge. Veik nas Tamangg ane bogbogo ru nitangi amolmol. ");
INSERT INTO kbm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ginei yem tangg aim givin ayeu ano-ngge, okob unsov awangg yaun walang ok ane lu vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Be ayeu atob nautani Tamangg be nemb amol ebe ve nemb yem avongg aim ru ok be ninme, veik niro yem ta. Be atob nivang nivin yem nemb ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Be etok Ngalau Yamar yaun ano ane. Amolmol ebe iute mateu bemem aplos givin ite ok, gitangi ebe atob in-gas Ngalau Yamar nok ok ite ma. Ve eisir ili ei ite be itpweng ei are ite weik etok ge. Bemem yem utpweng ei are gikwai, ve ei givang givin yem, be atob yem un-gas ei be nimbweg nangge aplongg aim. ");
INSERT INTO kbm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ve ayeu bwaingg ve ret navang nakwai yem be unkuk lili weik ebe nunus mandav ok. Beti atob ayeu nanumul natangi yem nanme vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kasop gege atob amolmol ebe dabas ungglus ok indi ayeu vukuri ite ma, bemem yem ge ete atob undi ayeu. Ayeu gabweg matawangg beti atob yem ok unambweg matawangg aim weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Be nivin sawa etok okob atob yem unatpweng are unei Ayeu gavang gavin Tamangg, be yem uvang uvin ayeu be ayeu gavang gavin yem weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Amol ti ginei giute awangg yaun be gisov ane lu vie-ngge, amol etok ete ta givin ayeu ano ge, be atob Tamangg ta nivin ei. Be ayeu ok atob tangg nivin ei weik etok ge, be atob nas au-ate ru nitangi ei nivin.” ");
INSERT INTO kbm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yisu ginei yaun dangetok beti Juda ginei gitangi ei be ginei; “Amol Bamo, gimdom beti mie gunei atob amei ge andi mie be amolmol ebe dabas ungglus ok atob indi mie ite?” ");
INSERT INTO kbm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yisu giwel Juda avo be ginei; “Amol ti ginei ta givin ayeu anongge, okob ei nisov awangg yaun walang ok ane lu vie-ngge. Be atob Tamangg ta nivin ei. Be eilu Tamangg amei-gabu atob anme be anvang anvin ei tis as mate walang ok. ");
INSERT INTO kbm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Amol ti ginei ta givin ayeu ano molge ite, amol etok ei givang mul ve ayeu avongg vevie ite ma. Be yaun (mateu) bambamo ete yem ute ayeu ganei ganei ok, etok ayeu ate angg yaun ite ma. Etok Tamangg ebe gihlin ayeu be ganme ok ane yaun. ");
INSERT INTO kbm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ayeu ganei gen walang ok ane yaun gitangi aim tis ete gavang gavin yem nangge nik. ");
INSERT INTO kbm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bemem yem aim amol ebe ve nemb yem ru be niro yem ta ok ete Ngalau Yamar ei ate. Be atob Tamangg nihlin be ninme ve awangg gwangne ane. Kob atob ninei gen walang ok lavo-lavo nitangi yem. Be atob ei nilgum kob atob yem tangg aim nitung nile yaun bambamo ebe warik ayeu ganei gitangi yem ok. ");
INSERT INTO kbm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ayeu atob navang nakwai yem, beti gab angg yaun bongong gitangi yem gilek ve niengk nivin yem. Awangg yaun bongong ete gab gitangi yem gilek nok, weik ebe amolmol dabas ungglus ane emb ok ite ma. Dangetok be gaptol tangg aim itung walang ano be unpelk bwaya. ");
INSERT INTO kbm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ayeu ganei gitangi yem gikwai ganei: ‘Atob ayeu nakwai yem be nale, bekob atob nanumul natangi yem nanme vukuri.’ Be warik ginei yem tangg aim nivin ayeu ano molge, okob sawa etenik atob yem tangg aim vevie-ngge, ve gisov ayeu atob natangi Tamangg nale. Ve Tamangg ei Amol Bamo gitlek ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ayeu ande ganei gen bambamo etok ane yaun gimungg gitangi yem be ute gikwai. Be asonge ginei gen etok ano nile be yem undi, kob atob unatpweng are unei awangg yaun ano molge. ");
INSERT INTO kbm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ayeu atob kakie vu-vung gwangne navin yem vukuri ite. Ve nalk etenik ane tivie ete ginme nik ve nes ayeu vunu. Amol nok gitangi ebe ve nilgum gen ti dangetok nitangi ayeu ok ite, ve ei ane gwangne gitangi awangg ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bemem ayeu galgum ve ganei amolmol nalk ane inatpweng are ro-ro ge inei, Ayeu tangg givin Tamangg gitlek molge, beti gasov Tamangg ane yaun ane lu ge. Dangetok be unamdil be tale. ");
INSERT INTO kbm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wain ane dabe Ayeu, be Tamangg ei um wain ane tivie. ");
INSERT INTO kbm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Be Ayeu angg walo ebe ges ano ite ok, ete Tamangg gidbwen gil-kili gikwai, be walo ebe ges ano ok ete Tamangg ges ningge pik-pok be gipasang love sang vie ge veik nes ano anongge. ");
INSERT INTO kbm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Dangetok be yem ande aplongg aim sang gikwai, givin ebe ayeu ganei yaun (mateu) gitangi aim ok. Ve gisov yem aplongg aim givin yaun ete ayeu ganei ok. ");
INSERT INTO kbm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dangetok be yem unvang unvin ayeu nemb ta ge kob atob ayeu navang navin yem weik etok ge. Ve wain walo sin-ge ti gitangi ebe atob nes ano ok ite ma, walo etok nitu nangge dabe be nile kob atob nes ane ano. Dangetok be ginei yem unvang unvin ayeu ite, atob yem ok unes ano ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ayeu weik wain dabe be yem weik ebe wain nok ane walo ok. Amol ti ginei givang givin ayeu be ayeu gavang gavin ei, atob ei nes ane ano walang ano molge. Ve ginei yem bwaingg aim ve ayeu, okob yem ate ge gitangi ebe atob unalgum gen ti ok ite ma molge. ");
INSERT INTO kbm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Amol ti ginei nivkir dume nitangi ayeu, atob inkari ei nile nihlang nikwai weik wain walo ebe nolge ainggwen gikwai ok. Be um tivie atob niro wain walo ete ainggwen ok sut nisov dongke be nitak yev nisov. ");
INSERT INTO kbm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ginei yem unvang unvin ayeu, be upasang awangg yaun (mateu) vie-ngge giengk aplongg aim okob gen ret ret ete yem tangg aim givin ve un-gas, be utani ayeu ve gen etok ane ok, atob ayeu namb nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ginei yem omb aim kulkul love aim kulkul etok ges ane ano vevies ge, atob yem aim gen ete ulgum ok nes Pomate ane bogbogo ru nitangi amolmol be atob ayeu nali yem nanei angg amolmol gen yem roro. ");
INSERT INTO kbm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamangg ta givin ayeu, beti ayeu ok tangg givin yem weik etok ge. Dangetok, be yem unvang unsov awangg tangg givin etok ane lu nemb ta ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ginei yem unsov awangg yaun walang ok ane lu vie-ngge, atob yem unvang unsov awangg tangg givin ebe tangg givin yem ok aplo nemb ta ge. Dangete ayeu gasov Tamangg ane yaun ane lu ge beti gavang gasov Tamangg ane ta givin ebe ta givin ayeu ok ane lu ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ayeu ganei yaun etenik gitangi yem, gisov ayeu tangg givin ve angg tangg-vevie nilek nivang nivin yem be nilgum be yem tangg aim vevie nemb avut ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Be awangg luev ebe tangg givin ve yem unvang mul ok dangeteik: Tangg aim nivin aim ate dangete ayeu tangg givin yem ok. ");
INSERT INTO kbm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Amol ti ginei geb ate giwel ane nune-gen be gimat vunu ve eisir ane, okob amol etok ta givin ane nune-gen anongge gitlek gen subu subu. ");
INSERT INTO kbm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ginei yem unsov awangg yaun ete ganei gitangi yem ok ane lu ge, atob ayeu natal yem nanei angg nune-nggen. ");
INSERT INTO kbm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Be atob natal yem nanei amolmol kulkul ane vukuri ite ma. Ve gisov amolmol kulkul ane, eisir itpweng gen ebe as amol bamo ta gitung ok are ite ma. Bemem yem, ayeu gatal yem ganei angg nune-nggen ve gisov yaun bambamo ebe ayeu gaute nangge Tamangg ok, ete ganei tepwengge binge gitangi yem be utpweng are gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yem omb ayeu ve aim gen ite ma. Ayeu kob gab yem ve angg gen gikwai. Be gatak yem usov kulkul veik unalgum love aim kulkul nok nes ane ano vevies ge. Dangetok be ginei yem utani Tamangg ve gen ti ane, be unei gisov ayeu arengg, atob Tamangg nemb nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Be ayeu gab luev ti gitangi yem gikwai be ganei: Tangg aim nivin aim nune-nggen bingano ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Dangetok be ginei amolmol dabas ungglus ane ginei ve inalgum yem tiate tiate, okob atob yem unatpweng are ve eisir ilgum gen etok gitangi ayeu gimungg gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bingano, ginei yem dabangg aim ungglus dangete eisir ok, okob atob eisir indi yem weik as nune-nggen be atob tas nivin yem weik ete eisir ate tas givin is ate ok. Bemem ayeu gab yem ve angg gen gikwai be atob yem unvang mul ve amolmol dabas ungglus ane as luev vukuri ite ma. Beti atob amolmol dabas ungglus ane bwais ve yem be inalgum yem tiate tiate. ");
INSERT INTO kbm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bemem yem tangg aim nitung nile yaun ebe warik ayeu ganei gitangi yem gikwai ok. Ayeu ganei dang eteik: Amol kulkul ane ti gitangi ebe atob nitlek ane amol bamo ebe geb ei dabin ok ite ma. Eisir emb bunam gitangi ayeu, beti atob inalgum nitangi yem ok weik etok ge. Be ginei eisir inaute awangg yaun be insov ane lu ge, okob gitangi ebe atob inaute yem aim yaun be insov ane lu ok weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bemem atob eisir inalgum gen bambamo etok nitangi yem, ve gisov yem ande mohlang ve awangg amolmol gen gikwai. Be givin ve eisir itpweng Tamangg ebe gihlin ayeu be ganme ok are ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bingano, ginei ayeu nale be nanei mateu nitangi eisir ite, okob Pomate atob nili eisir ninei amolmol tiate ane ite ma. Bemem galkik etenik Pomate gili eisir ginei amolmol tiate ane roro, ve gisov ayeu gale be ganei mateu gitangi eisir gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Amol ti ginei givkir dume gitangi ayeu, etok weik ebe ei givkir dume gitangi Tamangg ok. ");
INSERT INTO kbm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amol ti gitangi ebe atob nilgum kulkul bamo dangete ayeu galgum ve eisir ane ok ite ma, be bingano ginei ayeu nalgum kulkul etok ve eisir ane ite, okob Pomate atob nili eisir ninei amolmol tiate ane ite. Bemem ayeu galgum gen bambamo etok be eisir ili gikwai, bemem bwais be ivkir dumas gitangi eilu Tamangg amei gabu. ");
INSERT INTO kbm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dangetok be eisir as luev etok galkik gilgum yaun ebe giengk Pomate ane kapia ok be ano gile. Yaun nok ginei dang eteik: ‘Eisir ilgum ayeu tiate tiate sin-gege be ane dabe ma.’ ");
INSERT INTO kbm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bemem atob ayeu nahlin amol ebe ve niro yem ta ok be nitangi yem ninme. Amol nok ei gibweg givin Tamangg, be amol nok ei Ngalau Yamar yaun ano ane. Be atob ei ninme kob ninei ayeu lavo nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Dangetok be yem ok unalgum kulkul ve unei awangg yaun nivin weik etok ge. Ve gisov yem uvang uvin ayeu tis ebe warik vaku ge ok be painge love galkik as mate etenik. ");
INSERT INTO kbm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ayeu ganei yaun etenik gitangi yem, ve gisov ayeu tangg givin ganei yem unvarkei gwangne be aplongg aim nivin ayeu gwangne ge. ");
INSERT INTO kbm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Atob eisir inaitin yem unde unahlang unkwai lum mateu ane aplo be unde ve unvang unkwai eisir. Be asonge nivin sawa ebe amolmol ebe ve ines yem vunu ane ok ve menihlang ok, atob eisir tas nitung inei eisir ilgum gen vie gitau gile ebe Pomate ane luev ok. ");
INSERT INTO kbm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eisir itpweng eilu Tamangg are ite, beti atob inalgum gen bambamo etok nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bemem ande ayeu ganei gen bambamo etok ane yaun binge gimungg gitangi yem gikwai, dangetok be ginei nivin ebe eisir ve inalgum gen dangetok nitangi yem ok, okob atob yem unatpweng are unei ayeu ganei gen bambamo etok ane yaun gimungg gitangi yem gikwai. Warik ayeu ate gavang gavin yem beti ganei yaun etenik gitangi yem ite. ");
INSERT INTO kbm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Bemem galkik etenik ayeu ve nanumul natangi Amol ebe gihlin ayeu be ganme ok, nale vukuri. Bemem yem aim amol ti giutani ayeu be ginei; Wali mie ve nuvang? Amol ti giutani ayeu dangetok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ve gisov yaun ete galkik ayeu ganei gitangi yem ok gilgum yem be aplongg aim bunam molge. ");
INSERT INTO kbm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bemem ayeu nanei bingano ge nitangi yem nanei; Gen etok vie ve ayeu nakwai yem be nale. Ve ginei ayeu nakwai yem be nale ite, okob Ngalau ebe ve niro yem ta ok atob nitangi yem ninme ite ma. Bemem ginei ayeu nale, okob atob ayeu nahlin ei be ninme. ");
INSERT INTO kbm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nivin ebe amol nok (Ngalau Yamar) ve ninme ok, okob atob ei nes gen tiate ane dabe ru, be nes luev gen vevies ane ru be luev ebe Pomate gilgum amolmol as yaun ok ane dabe ru nivin nitangi amolmol ebe dabas ungglus ok. ");
INSERT INTO kbm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Be gen ebe gilgum beti eisir ilgum gen tiate ok, ebe atob Ngalau nes ru nitangi eisir ok dang eteik: Eisir aplos givin Ayeu ite. ");
INSERT INTO kbm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Be luev gen vevies ane ane dabe ebe atob ei nes ru nitangi eisir nivin ok dang eteik: Ayeu atob natangi Tamangg nale, be atob yem undi ayeu vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Be luev ebe Pomate gilgum amolmol as yaun ok ane dabe ebe atob ei nes ru nitangi eisir ok ete dangeteik: Pomate gilgum amol bamo (Sadam) ebe geb nalk etenik dabin ok ane yaun be ande gitin ei gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Awangg yaun ebe ve namb nitangi yem ok walang molge ete giengk nik. Bemem galkik atob kulkul bamo molge nitangi yem, ebe ve unatpweng awangg yaun bambamo etok tepwengge are ok. ");
INSERT INTO kbm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bemem nivin ebe Ngalau yaun ano ane ve ninme ok, okob atob ei nitwem yem be unatpweng yaun ano walang ok are be ma. Atob ei ninei yaun nitangi ebe ei ate ane ta gitung ok ite ma, yaun ebe ei giute nangge Pomate ok ge ete atob ninei yaun etok ge nitangi yem. Be atob ninei gen ebe ve menihlang nindeb mul ane ane ok ane yaun binge nitangi yem nivin. ");
INSERT INTO kbm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Atob ei ninggas awangg yaun nilek be ninei nitangi yem. Ei atob nilgum dangetok, kob atob amolmol avos nivwat ayeu arengg. ");
INSERT INTO kbm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Be Tamangg ane gen walang ete giengk givin ei ate ok, etok ayeu angg gen tepwengge. Beti ayeu ganei dangetok ganei: Atob Ngalau Yamar ninggas yaun ebe ayeu gab gitangi ei ok nilek be ninei binge nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kasop-gege atob yem undi ayeu vukuri ite nitangi sawa undib siti-ngge, bekob atob undi ayeu vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Be eisir singamolomb subu inei ve is ate be inei: Yaun ete ei ginei gitangi eitit ok ane dabe nam nambed? Ei ginei; Kasop-gege atob yem undi ayeu vukuri ite nitangi sawa undib siti-ngge bekob atob undi ayeu vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Be ginei ti givin ginei: Ayeu ve navangg Tamangg ane. Be sawa undib siti ete ei ginei ok, ane dabe nam nambed? Eitit tatpweng ei ane yaun ete ginei nik ane dabe are ite ba. ");
INSERT INTO kbm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yisu ande gitpweng are ginei amei singamolomb veve anautani ei. Beti ei ginei gitangi amei be ginei: Wat yem utau-tani aim ate ve yaun ebe galkik ayeu ganei gitangi yem be ganei; Kasop-gege atob yem undi ayeu vukuri ite nitangi sawa undib siti-ngge bekob atob undi ayeu vukuri ok ane me? ");
INSERT INTO kbm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ayeu nanei roro ge nitangi yem nanei: Atob yem unteng be aplongg aim bunam anongge ve ebe ande ayeu gamat vunu ok ane. Bemem amolmol ebe dabas ungglus ok atob tas vevias ge. Bemem yem aim aplongg aim bunam etok atob nirau-lili kob atob tangg aim vevie anongge. ");
INSERT INTO kbm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ginei avie ti gitpweng are ginei kasop-gege be atob ei ninggas nunus, atob ei aplo bunam molge ve sawa etok ebe atob ei ninggas vavavne bamo molge ok. Bemem mul ane kob, nivin ebe ande ei vie ve nunus gikwai ok okob atob ei ta nitung gen bunam etok vukuri ite ma. Atob ei ta vevie ge ve ande ei vie ve nunus etok gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dangetok be galkik etenik ande yem aplonggaim bunam. Bemem asonge nivin ebe yem ve undi ayeu vukuri ok, okob atob tangg-aim vevei anongge. Kob atob amol ti gitangi ebe ve nemb yem aim tangg-aim vevie etok nikwai ok ite molge. ");
INSERT INTO kbm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Be Yisu ginei; Sawa etok ma nikwai kob atob yem unautani ayeu vukuri ve gen ane dabe dabe ane ite ma. Be ayeu nanei bingano ge nitangi yem nanei; Ginei yem utani Tamangg ve gen ti ane, be unei gisov ayeu arengg, atob Tamangg nemb nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Warik yem utani ve gen ti ane bemem unei gisov ayeu arengg ite ma. Bemem galkik ginei yem ve unautani gen be unei nisov ayeu arengg, atob yem un-gas gen ete utani ve un-gas ok. Kob atob tangg aim vevie ge. ");
INSERT INTO kbm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ayeu ganei yaun bambamo etenik be ganei gipil bing ai ge gitangi yem. Bemem nindeb mul ane atob ayeu nanei bing ai ti vukuri ite ma. Atob ayeu nanei Tamangg ane yaun be nanei yaun ano vusa bupwe ge nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Be nivin sawa etok ete atob yem ate ge unautani Tamangg ve gen ane be unei nisov ayeu arengg. Be ayeu wat nautani Tamangg ve yem ane ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ve Tamangg ei ate ta givin yem, be gitangi ebe atob nemb yem ru ok. Be ei ta givin yem ve gisov ebe yem tangg aim givin ayeu, be aplongg aim givin unei ayeu gabweg gavin Pomate beti ganme ok. ");
INSERT INTO kbm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Warik ayeu gabweg gavin Tamangg beti gamdil gakwai ei be gasov nalk ganme, beti galkik ve nakwai nalk be nanumul natangi Tamangg nale vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Beti amei singamolomb anei; “Ke, ande mie gunei yaun ano vusa roro-ngge, be gunei gipil bingai ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Be ande amei atpweng are anei mie gusge ve gunei amol ti niutani mie bekob ok ite ma. Ve mie ate gutpweng gen walang ok are gikwai. Beti amei aplongg amei givin anei Mie gubweg guvin Pomate beti gunme. ");
INSERT INTO kbm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisu giwel ane singamolomb gen amei avongg amei be ginei: “Galkik etenik ge ete yem aplongg aim givin me-rav? ");
INSERT INTO kbm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Be unaute. Ginei as mate etok menihlang, bingano ande meng gihlang gikwai be atob amolmol invin-vin yem tepwengge be atob unvang ata-tane untangi aim nam dabe ge unde. Be yem tepwengge atob unvang unkwai ayeu be ayeu ate ge atob nambweg. Bemem ayeu ate ge atob nalgum au-ate bwam-bwam nambweg ite ma, Tamangg ei givang givin ayeu. ");
INSERT INTO kbm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ayeu tangg givin ve ganei yem unvang unvin ayeu gwangne ge be unvang aim gen bongong vie-ngge, beti ganei yaun etok gitangi yem. Be atob amolmol inemb bunam walang ano nitangi yem. Bemem yem unro aim ate ta be unvarkei gwangne ge. Ve ayeu gabweg gawei nalk etenik ane gen walang ok gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisu ginei yaun etok gikwai bekob gidank gireu gulumb ve nes miengk be ginei; “Tamangg, as mate ebe ayeu ve namat vunu ane ok ande meng gihlang gikwai. Be os Natum ane bogbogo ru itangi amolmol, veik atob Natum nes miam bogbogo ru nitangi eisir. ");
INSERT INTO kbm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ve mie gob am gwangne gitangi ei gikwai. Be mie gob ei ve nemb amolmol tepwengge dabin, be ei gitangi atob nitak amolmol ebe mie gob eisir gitangi ei ok inambweg matawas nem ta ge ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Be inambweg matawas nemb ta ge, ane dabe dangeteik: Eisir itpweng are inei Mie dongke ge Mie Pomate bingano molge. Be itpweng are givin inei Mie guhlin Yisu Kilisi beti ginme. ");
INSERT INTO kbm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ayeu gas miam bogbogo ru gitangi amolmol nalk ane be ili gikwai. Be kulkul ebe mie gob gitangi ayeu ve nalgum ok, ete ande ayeu galgum be ma gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamangg, os awangg bogbogo as mate etenik ane ru itangi eisir. Bogbogo ebe warik gabweg gavin mie, givin ebe gupasang nalk ite nangge be gob gitangi ayeu ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ayeu ganei mie arem binge gitangi amolmol nalk eteik ane, ebe mie gob eisir gitangi ayeu ok gikwai. Be etok miam amolmol gen ebe gob eisir gitangi ayeu ok. Be eisir nok ande isov miam yaun ane lu vie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Be galkik ande eisir itpweng are inei gen bambamo ete mie gob gitangi ayeu gikwai ok, gen etok tepwengge ginme nangge mie dongke ge. ");
INSERT INTO kbm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Be yaun bambamo ete mie gob gitangi ayeu ok, ete ande ayeu gab gitangi eisir gikwai, be ipasang vie-ngge giengk aplos. Be itpweng are roro ge inei, warik ayeu gabweg gavin mie beti ganme. Be aplos givin inei mie guhlin ayeu beti ganme. ");
INSERT INTO kbm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ayeu gas miengk ve eisir eteik ge ane, be gas miengk ve amolmol ebe dabas ungglus ane ok givin ite ma. Ayeu gas miengk ve amolmol ebe mie gob gitangi ayeu ok ge. Ve eisir etok ande meihlang ve miam amolmol gen gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Be gen bambamo ebe giengk givin ayeu ok, etok miam gen, be ebe giengk givin mie ok etok awangg gen, be mie gos awangg bogbogo ru gitangi eisir gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ayeu atob navang nalk eteik vukuri ite ma, Ayeu ve natangi mie nalek bemem eisir eteik ete atob invang ete nalk ik. O Tamangg, Mie nam nuli eisir vie-ngge veik invang insov ares ete mie gob gitangi ayeu ok, ane gwangne ane lu ge. Veik invang weik gen ano dongke dangete tutlu gen ano dongke ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Givin ebe ayeu gavang gavin eisir ok, ayeu gab eisir dabin vie-ngge be ivang isov mie arem ebe gob gitangi ayeu ok ane gwangne ane lu ge. Be eisir as amol ti lavo bun ite ma. Amol dongke ge (Judas Iskariot) ebe are giengk yapin ve atob nimat vunu mang mangi ok, ete ei dongke ge ande lavo bun. Be ei gilgum dangetok, beti yaun ebe giengk miam kapia ok ande ano gile. ");
INSERT INTO kbm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Be Ayeu ete ve natangi mie nalek nok, beti ganei yaun eteik nangge nalk veik awangg yaun bwai bwaya nemb eisir eteik avut be invang tis tas vevie-ngge. ");
INSERT INTO kbm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ayeu ganei miam yaun (mateu) gitangi eisir eteik, be amolmol ebe dabas ungglus ok bwais ve eisir. Ve gisov eisir eteik ivang mul ve luev nalk eteik ane ite dangete ayeu ok, ve ayeu amol ebe gavang mul ve luev nalk eteik ane ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ayeu gautani mie ve ganei nunggas eisir inkwai nalk eteik ite ma. Ayeu gas miengk be gautani mie ve ganei nam nuli eisir vie-ngge be invang aikawe inkwai Sadam tis ane gwangne. ");
INSERT INTO kbm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ayeu amol nalk eteik ane ite ma, beti eisir ok weik amolmol nalk eteik ane ite weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Miam yaun, etok yaun ano ano molge. Be ayeu tangg givin ve ganei mie nomb am yaun ano nok nisov eisir aplos nile be nemb kulkul nangge eisir aplos love nilgum be inro is ate vukir be meinahlang ve miam amolmol gen bingano ge. ");
INSERT INTO kbm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Warik mie guhlin ayeu ganme be gavang gasov amolmol ebe dabas ungglus ok aplo nangge nalk, beti galkik ayeu ve nahlin eisir ebe mie gob gitangi ayeu ok, ve inde be invang insov amolmol dabas ungglus ane aplo nangge nalk weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ayeu atob nawel eisir be namb dalgongg matawangg ane nitangi mie, veik namb eisir ru. Be bingano molge, eisir atob meinahlang ve miam amolmol gen roro. ");
INSERT INTO kbm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Be ayeu gas miengk ve eisir eteik ane ge ite ma, ayeu gas miengk ve amolmol ebe iute yaun (mateu) ebe eisir inei, be aplos givin ayeu ok ane givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ayeu tangg givin ve ganei eisir etok tepwengge invang invin is ate weik gen ano dongke ge, dangete ayeu Tamangg mie guvang guvin ayeu be ayeu gavang gavin mie ok. Dangetok be ayeu tangg givin ve ganei eisir ok invang invin tutlu weik etok ge. Veik amolmol nalk ane subu ebeok tepwengge aplos nivin inei mie guhlin ayeu beti ganme. ");
INSERT INTO kbm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Be miam gwangne ebe gob gitangi ayeu gikwai ok, ete ande ayeu gab gitangi eisir gile veik miam gwangne etok niro eisir ta be invang invin is ate weik gen dongke ge dangete tutlu ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ayeu gavang gavin eisir be mie guvang guvin ayeu, dangetok be ayeu tangg givin ve mie nulgum eisir be tas nivin is ate anongge be invang weik gen ano dongke. Veik amolmol nalk ane subu ebeok tepwengge inatpweng are roro-ngge inei mie guhlin ayeu beti ganme. Be mie tam givin eisir dangete tam givin ayeu ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamangg, Ayeu tangg givin ganei amolmol ebe mie gob eisir gitangi ayeu ok, atob inambweg taku ebe ayeu ve nambweg ok invin. Ayeu tangg givin ve eisir indi awangg gwangne ebe warik mie tam givin ayeu be gob gwangne etok gitangi ayeu gimungg bekob gob nalk etenik gideb mul ane ok. ");
INSERT INTO kbm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Tamangg, Mie amol yaun ano ane bingano molge. Amolmol nalk ane itpweng mie are ite ma. Bemem ayeu ge ete gatpweng mie are. Be amolmol ebe mie gob eisir gitangi ayeu ok ge ete itpweng are inei Mie guhlin ayeu beti ganme. ");
INSERT INTO kbm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ayeu ganei mie arem vusa gitangi eisir gikwai, be eisir ok atob inei mie arem vusa nitangi amolmol ebeok subu nivin weik etok ge. Eisir atob invang mul ve luev tas nivin is ate ane be atob tas nivin amolmol ebeok subu nivin, weik ete mie tam givin ayeu ok. Be ayeu ok atob navang navin eisir weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisu ges miengk etok gikwai kob tis ane singamolomb-gen amei as bui Kidron ane kap-kapul gili ale apil tavlu. Be um ti giengk etok beti amei avang ale asov um nok aplo. ");
INSERT INTO kbm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Be Judas, amol ebe atob ninei Yisu binge nitangi amolmol valir ane ok ei ok gitpweng taku etok are gikwai. Ve as mate walang ok Yisu tis ane singamolomb gen amei aro amei ate sut asov taku dongke etok ge. Be ei gitpweng are gikwai ginei Yisu atob nile taku etok. ");
INSERT INTO kbm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Beti Judas nok gitwem amolmol valir ane subu be tis amolmol ebe emb kulkul da ane nangge lum yamar ok, as amolmol kambam tupe ane subu be tis eisir Parisai be ile love imbielk ve taku ete Yisu givang ok. ");
INSERT INTO kbm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yisu ande gitpweng gen walang ete ve menihlang nipil ei ok are gikwai, beti ei givang gile gibloblo Judas nok tis ane amolmol-gen be ginei: “Yem urek amol ret?” ");
INSERT INTO kbm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Be eisir iwel ei avo be inei; “Amei arek Yisu Nasaret ane ete anme nik.” Be Yisu ginei gitangi eisir; “Ayeu nok eteik.” Be Judas, amol ebe ve ninei Yisu binge ok, givarkei givin amolmol valir ane nok. ");
INSERT INTO kbm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Be givin ebe Yisu ginei gitangi eisir be ginei; “Ayeu nok eteik” ok, be eisir tepwengge iteru inumul be imbieg ile itak nalk. ");
INSERT INTO kbm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Be Yisu giutani eisir vukuri be ginei; “Yem urek amol ret?” Be eisir iwel Yisu avo be inei; “Yisu Nasaret ane.” ");
INSERT INTO kbm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Be Yisu giwel eisir avos be ginei: “Ayeu ganei gitangi yem gikwai ganei Ayeu nok eteik. Be ginei yem urek ayeu ete unme nik, okob nangg aim vier ve eisir eteik be inde.” ");
INSERT INTO kbm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yisu ginei yaun avo etok givang mul ve yaun ake ti ebe warik ginei gimungg ok. Be yaun ake nok dangeteik; “Eisir ebe Mie gob is gitangi ayeu ok, as amol ti lavo bun ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Be Pita ane buyag valir ane ti giengk, beti ei bage gisov ane buyag nok be gispe amol bamo ebe geb kulkul da ane nangge lum yamar ok, ane amol kulkul ane ti are Malkus talngelan tavlu gideb bage mol ane gili. ");
INSERT INTO kbm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Beti Yisu ginei gitangi Pita be ginei; “Bagem vier ve am buyag inumul isov lavo ile iengk. Mie wat tam gitung ve gunei ayeu nanggas gen bunam ete ve ninme nik bwaya me?” ");
INSERT INTO kbm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Amolmol valir ane dubi bamo etok tis as amol bamo ebe gitwem is ok, be tis eisir kambam tupe ane subu ebe emb lum mateu ane dabin ok emb Yisu ta be idgin bage ta, ");
INSERT INTO kbm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","bekob inggas ei itangi Anas ile gimungg. Anas nok lawe ete Kaiapas ok, Kaiapas nok ei amol bamo ti ebe geb amolmol kulkul da ane dabin givin sawa etok ok. ");
INSERT INTO kbm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Be ei nok ete warik ginei gitangi eisir bambamo Juda ane be ginei; “Etok vie ve amol dongke etenik ge nimat vunu niwel amolmol tepwengge” ok. ");
INSERT INTO kbm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pita be tis eisir singamolomb nok as amol ti itau ile Yisu be ile. Be amol bamo ebe geb amolmol kulkul da ane subu dabin ok, ei gitpweng amol nune etok are gikwai beti amol nok gile gisov taku ebe ve inalgum amolmol as yaun ok aplo gile givin Yisu. ");
INSERT INTO kbm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Be Pita givarkei dume ane yapin gibloblo nam avo. Beti amol ebe galkik givin Yisu be gabu isov nam aplo ile ok, gile ginei gitangi avie kulkul ane ti ebe geb nam avo dabin ok, be gigas Pita gisov gile. ");
INSERT INTO kbm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Avie nok giutani Pita be ginei; “Amol etok ane singamolomb ti ete mie nik me-rav?” Be Pita ginei; “Ma, ayeu ma.” ");
INSERT INTO kbm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Taku luvus bamo molge beti amolmol kulkul ane subu be tis eisir kambam tupe subu imban yev ti be ivarkei ile idbul be imuailuv ivarkei. Be Pita ok givarkei etok givin eisir ve gimuailuv yev. ");
INSERT INTO kbm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Amol bamo ebe geb amolmol da ane subu dabin ok, giutani Yisu ve ane singamolomb gen ane be tis yaun ebe ei ginei ginei gitangi amolmol ok ane. ");
INSERT INTO kbm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Beti Yisu giwel ei avo be ginei dang eteik: “As mate walang ok ayeu ganei yaun gavarkei amolmol tepwengge nas nangge taku gitip bamo, be gabul amolmol nangge lum mateu ane aplo be nangge lum yamar bamo ebe eisir Juda iro is ate sut isov ok aplo. Be ayeu ganei yaun ti gavuaivun au-ate ge ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Be mie gutani ayeu ve ret ane? Mie nutani amolmol ebe iute awangg yaun ebe ganei ganei ok. Ve eisir ok itpweng yaun ebe ayeu ganei ganei ok are. ");
INSERT INTO kbm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Beti eisir kambam tupe as amol ti givtav Yisu be ginei, “Ret ginei beti mie nunei yaun avom dangetok nitangi amol bamo da ane?” ");
INSERT INTO kbm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yisu giwel amol nok avo be ginei; “Ginei ayeu ganei yaun tiate ti, okob mie unei yaun tiate ete ayeu ganei ok vusa itangi amolmol tepwengge be inautema. Bemem ginei ayeu ganei yaun avo roro gitangi ebe ganei ok, okob mie guvtav ayeu sin-gege ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bekob ete Anas geb Yisu tis wal ebe geb bage ta ge gitangi Kaiapas gile. ");
INSERT INTO kbm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita givarkei lavo ok ge ve gimuailuv yev givarkei. Beti eisir inei gitangi ei be inei; “Mie etenik ete wat Amol etok ane singamolomb ti givin me?” Be Pita ginei; “Ma, ayeu ite.” ");
INSERT INTO kbm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bekob amol bamo ebe geb amolmol da ane subu dabin ok, ane amol kulkul ane ti, be amol nok ane gwade ete Pita gispe talngelan tavlu gili ok, be ei ginei gitangi Pita be ginei; “Bingano molge, mie amol etenik ete ayeu gali mie guvang guvin amol etenik nangge ete um aplo ok.” ");
INSERT INTO kbm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Be Pita ginei vukuri ginei; “Ma ayeu ite.” Be seukie-ngge kavkavav giteng as bamo ane. ");
INSERT INTO kbm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gn tistumi-ngge amolmol valir ane inggas Yisu nangge Kaiapas ane nam be itangi amol bamo Rom ane, ebe geb eisir dabin ok ile. Be eisir Juda eisir ate isov Rom as amol bamo nok ane simbel aplo ile ite ma, ve eisir iyamar is ate ve atob inatwep amol ebeok ti ane nam inde ite. Eisir ipelk ve ande ipasang is ate gikwai ve inen ben Sonda Pasova ane. ");
INSERT INTO kbm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Beti Pilata gimdil be gitangi eisir gile be giutani is be ginei; “Amol etenik gilgum gen ret beti yem ve unalgum ei ane yaun?” ");
INSERT INTO kbm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Be eisir iwel Pilata avo be inei; “Ginei amol etenik nilgum gen tiate ite, okob atob amei an-gas ei antanggi mie anme ve ret ane?” ");
INSERT INTO kbm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Be Pilata ginei gitangi eisir be ginei; “Dangetok be kob yem ate nok unalgum ei ane yaun iatngi yem ate aim luev ebe ulgum ulgum amolmol as yaun ok.” Eisir Juda iwel Pilata avo be inei; “Yem Rom unei gikwai unei amei Juda gitangi ebe atob anes amolmol vunu ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Warik Yisu ginei yaun ebe ve nimat vunu ane ok, be gineuev ebe atob nimat vunu ane ok lavo givin. Beti galkik ei ane yaun etok atob ano nile. Ve luev ete ve ines amolmol nireu ei givsangin ok, etok amolmol Rom ane ge as luev etok. ");
INSERT INTO kbm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Beti Pilata ginumul gile givarkei taku ebe ve inaute amolmol as yaun ok, be gital Yisu gile be giutani ei be ginei; “Mie Juda as Amol Bamo (King) ebe gob eisir dabin ok me?” ");
INSERT INTO kbm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yisu giwel Pilata avo be giutani ei be ginei: “Yaun etenok meng gihlang nangge mie ate am tam gitung me lob ubu inei lavo gitangi mie, inei ayeu Amol ti dangetok?” ");
INSERT INTO kbm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilata giwel Yisu avo be ginei; “Ayeu amol Juda ane ti beti mie gunei yaun dangetok gitangi ayeu e? Mie ate am bambamo gen be tis eisir bambamo ebe emb kulkul da ane nangge lum yamar ok, ete inggas mie itangi ayeu inme. Be wali mie gulgum gen tiate ret?” ");
INSERT INTO kbm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Beti Yisu giwel Pilata avo be ginei: “Luev ebe ayeu ve menahlang weik Amol Bamo ok, etok weik ebe luev nalk etenik ane ok ite ma. Ve ginei ayeu ve luev nalk etenik ane, okob awangg amolmol gen atob ines valir nitangi eisir Juda, kob atob amol ti gitangi ebe atob nemb ayeu natangi amolmol valir ane nale ok ite. Bemem luev ete ayeu ve menahlang weik Amol Bamo ok, etok weik luev nalk etenik ane ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Beti Pilata giwel ei avo be ginei; “Dangetok beti mie Amol Bamo ti ebe gob amolmol dabin ok me-rav?” Yisu giwel Pilata avo be ginei; “Yaun nok ete ande mie ate gunei nok. Ayeu Amol Bamo (King) ebe gab engge dabin ok. Einangg gikuv ayeu be ganme nalk etenik ve gisov gen dongke eteik ge ane: Ayeu ganme ve nanei yaun ano ane yaun nitangi amolmol. Dangetok be amolmol tepwengge ebe ivang mul ve yaun ano ane luev ok, eisir iute awangg yaun be isov ane lu ge.” ");
INSERT INTO kbm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","39","Be Pilata ginei gitangi ei be ginei; “Yaun ano, etok gen ret?” Pilata ginei yaun etok bekob ginumul gitangi eisir bambamo Juda ane gile be ginei gitangi eisir be ginei; “Ayeu gali amol eteik ane tiate ti ebe gilgum ok ite ma. Bema yem tangg aim givin ve ayeu dabin ok be nitangi aim nilek me nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Be eisir tepwengge iwel Pilata avo be ital yaun avos bambamo ge be inei; “Ma, Amol etenok ite. Amei tangg amei givin anei mie nuhlang Barabas.” (Barabas nok ei amol ti ebe ges amolmol vun-kunu, be girwel amolmol as gen giriv be gira ok.) ");
INSERT INTO kbm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Beti Pilata ginei be amolmol valir ane irau Yisu ve bidbid, ");
INSERT INTO kbm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","bekob inggolong ei weik ebe king ok be ipasang wal du-duli ti ve gululung be es gisov Yisu dabe gile be ino kup muele ti gireu utle ulis. ");
INSERT INTO kbm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bekob ivang itangi ei na ile be inei; “As mate mie. Juda as amol bamo (king) ebe gob eisir dabin ok.” Be ivtav ei. ");
INSERT INTO kbm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilata gitangi eisir bambamo Juda ane gile vukuri be ginei; “Taunaute, ayeu gab ei gitangi yem ate gilek vukuri, veik undi be unatpweng are roro ge ve ayeu gali gen tiate ti ebe ei gilgum ok ite.” ");
INSERT INTO kbm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Be Pilata geb Yisu gitangi eisir gile tis gululung ebe ipasang ve wal du-duli ok be tis kup muele ebe ino gireu ei utle ulis ok ge. Be ginei gitangi eisir be ginei; “Taundi Amol e.” ");
INSERT INTO kbm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Amolmol bambamo ebe emb kulkul da ane nangge lum yamar ok be tis eisir kambam tupe ane, nas gile giwei Yisu be ital yaun avos bambamo ge be inei; “Os ei ireu ei-givsangin ile, Os ei ireu ei-givsangin ile.” Be Pilata ginei gitangi eisir be ginei; “Yem ate nok un-gas ei unde be unes ireu ei-givsangin ile. Ve ayeu gali gen tiate ti ebe ei gilgum ok ite ma.” ");
INSERT INTO kbm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Beti eisir bambamo Juda ane iwel Pilata avo be inei; “Amei-mei luev ti giengk dangetok ginei amol etenik nimat vunu nikwai. Ve ei ginei yaun gipil ate be ginei, ‘Pomate ane Natu Ayeu.’” ");
INSERT INTO kbm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilata giute yaun etok be ta ongo-nge bamo molge. ");
INSERT INTO kbm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Beti ginumul gile givarkei taku ebe ve inaute amolmol as yaun ok vukuri be giutani Yisu be ginei; “Mie amol nam inend ane?” Bemem Yisu ginei yaun ti gitangi ei ite. ");
INSERT INTO kbm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Beti Pilata ginei gitangi ei be ginei; “Namnambed be mie guwel awangg yaun ite? Awangg gwangne gitangi ebe ve nahlang mie be nule ok, be awangg gwangne gitangi ebe ve nas mie nireu ei-givsangin ok. Bemem mie wat gutpweng etok are ite me?” ");
INSERT INTO kbm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yisu giwel Pilata avo be ginei; “Ginei Pomate ebe gibweg einggoto ok nemb gwangne nitangi mie ite, atob miam gwangne etenok gitangi ebe atob numbweg nuwei ayeu ok ite ma. Dangetok be amol ebe gitak ayeu gisov mie bagem ok, ei ane tiate bamo molge gitlek miam.” ");
INSERT INTO kbm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilata giute yaun etok beti gilgum ve ginei nihlang Yisu be nile. Bemem eisir bambamo Juda ane ital yaun avos bambamo ge gitangi ei be inei; “Ginei mie guhlang amol etenok be gile, atob amei andi mie weik amol ti ebe ges valir gitangi amol bamo Rom ane (Sisa) ebe geb amolmol tepwengge dabin ok. Amol ebe gital ate ginei king ok, amol etok ebe ges valir gitangi amol bamo (Sisa) ebe geb amolmol tepwengge dabin ok.” ");
INSERT INTO kbm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilata giute yaun etok be gigas Yisu gitangi eisir gile, be ei ate gile gibweg giwei lopong ebe imbweg ve iute iute amolmol as yaun ok nangge taku ebe ital inei vat tap-tape ok. Be ital are etok giengk Hibru avos inei Gabata. ");
INSERT INTO kbm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Be as mate dongke etok ge giengk ebe ve inamdil ti vukuri be Juda undi as Sonda Pasova ane ok. Be givin etok ande as matano gile givarkei luvwe ge, be Pilata ginei gitangi eisir bambamo Juda ane be ginei; “Taundi aim amol bamo (king) ebe geb aim dabin ok e.” ");
INSERT INTO kbm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Be eisir ital yaun avos bamo ge ginumul gitangi Pilata be inei; “Os ei vunu ireu ei-givsangin ile ikwai.” Beti Pilata giutani eisir be ginei; “Yem tangg aim givin ve ayeu nas yem aim amol bamo (king) ebe geb yem dabin ok nireu ei-givsangin nile me?” Be eisir bambamo ebe emb kulkul da ane nangge lum yamar ok iwel Pilata avo be inei; “Amei-mei amol bamo ti ebe geb amei dabin givin ok ti givang ite ma. Be amol bamo ebe geb amei dabin ok, ete Rom as amol bamo (Sisa) ei dongke ge.” ");
INSERT INTO kbm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Beti Pilata geb Yisu gitangi eisir gile ve ines ei nireu ei-givsangin. ");
INSERT INTO kbm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Beti eisir itwem Yisu be ile. Yisu ei ate gigas ane ei-givsangin be amolmol valir ane itwem ei be ile love imbielk ve taku ti ebe ital inei dabas tulkwe ok. Be ital giengk Hibru avos inei Golgada. ");
INSERT INTO kbm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kob ete es ei gireu ei-givsangin nangge taku etok. Amolmol valir ane es amol ailu gireu ei-givsangin givin, amol ti gikaiwel tavlu be ti gikaiwel tavlu be Yisu gisov luvwe. ");
INSERT INTO kbm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Be Pilata giro yaun ake ti bwalbwale dang eteik: Juda as Amol Bamo (King) ebe geb eisir dabin ok etenik. Ei Yisu Nasaret ane. Be es yaun etok gile Yisu ane ei-givsangin gideb dabe ane. ");
INSERT INTO kbm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Be taku ete es Yisu gireu ei-givsangin nangge ok giengk gibloblo nam luvwe ge, be amolmol Juda ane ebe ilauk ilek be inme ok, ili be isam yaun nok. Be Pilata giro yaun nok ve Hibru be tis Rom be Grik as yaun givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Beti eisir Juda as amolmol bambamo ebe emb kulkul da ane nangge lum yamar ok, ile inei gitangi Pilata be inei; “Mie nuro nunei ‘Juda as Amol Bamo (King)’ ite ma. Mie nuro dang eteik nunei, “Amol etenik ginei, ‘Amolmol Juda ane as Amol Bamo (King) ayeu.’” ");
INSERT INTO kbm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Be Pilata giwel eisir avos be ginei; “Gitangi ite. Yaun ete ande ayeu garo bwalbwale gikwai ok, atob niengk lavo.” ");
INSERT INTO kbm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Amolmol valir ane es Yisu gireu ei-givsangin gile gikwai kob bais gisov ane kup malar ane be isiel gil-kili gile ake aivat, be ivwat ake dongke dongke gitangi is ate ge. Be ivwat ane kup undib bamo ebe nangge savwalo be gisov love gile gitak va ok givin. Bemem Yisu ane kup undib bamo etok ane lavo ebe iril ok giengk ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Beti eisir valir ane nok inei ve is ate be inei; “Eitit tanaure kup undib bamo etenik gil-kili bwaya, be tanes bwas be tandi, tanei amol ret atob nivwat kup etenik.” Amolmol valir ane ilgum gen dangetok beti yaun ti ebe giengk Pomate ane kapia ok ande ano gile. Ve yaun nok ginei dangeteik: “Eisir imbwas awangg kup gitangi is ate ge be ivwat. Be es bwas ve indi inei amol ret atob nivwat awangg kup undib bamo ebe nangge savwalongg be gisov love gile gitak vangg ok.” ");
INSERT INTO kbm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yisu tine gabu malavie ebe Kilaupas arwe ok be tis Malia Magdala ane, sotol ivarkei imbloblo Yisu ane ei-givsangin ebe gikaiwel. ");
INSERT INTO kbm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yisu gili tine be tis ane singamolomb ayeu (Jon) ebe ta givin ayeu gitlek ok, ebe avarkei ale ambloblo ei ane ei-givsangin ebe gikaiwel ok, be ginei gitangi tine be ginei: “Ute kob; Galkik etenik ande mie natum etenok.” ");
INSERT INTO kbm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bekob ginei gitangi ayeu be ginei: “Galkik etenik ande mie tinem etenok.” Beti givin sawa etok ge ayeu gagas Malia gale ebe angg nam ok be gab ei dabin. ");
INSERT INTO kbm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yisu gitpweng are ginei ande ei geb ane kulkul walang ok love ande ma gikwai, be ei gilgum veik nilgum yaun ebe giengk Pomate ane kapia ok be ano nile. Beti ginei: “Ayeu bui ges au.” ");
INSERT INTO kbm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Be bui vavis (viniga) gen-mate ti gibweg etok, beti eisir iro gen muai-muai ti weik ebe kol muai-muai ok utuv gisov bui vavis nok bekob idgin gisa kabut ti be isu gireu gitangi Yisu gile ve ninum. ");
INSERT INTO kbm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yisu ginum bui nok gikwai bekob ginei; “Ande ma gikwai.” Ei ginei yaun etok gikwai be gitle atle dubi butu be gimat vunu. ");
INSERT INTO kbm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Be givin as mate etok ete eisir Juda ipasang is ate ve Sonda Pasova ane. Beti eisir ile iutani Pilata veik ninei be eisir inde be ines amolmol ebe ikaiwel ei givsangin ok vas bud-butu, veik inmat vunu seukie-ngge, be inemb eisir inde intak inkwai ei-givsangin. Ve eisir bwais ve amolmol ebe ve inmat vun-kunu ok utlas ulis nikaiwel ei givsangin sinsin-ge nivin ete Sonda Sabat ok. ");
INSERT INTO kbm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Beti amolmol valir ane ile be es amol ailu ebe es is gireu ei ivin Yisu ok vas bud-butu. ");
INSERT INTO kbm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bekob itangi Yisu ile, bemem ili ebe ande ei gimat vunu gikwai ok beti es ei va butu ite. ");
INSERT INTO kbm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bemem eisir valir ane nok as amol ti giro Yisu gisov ete ra-rali ok ve i. Be seukie-ngge twerk tis bui givwat dodo-donge gisov i nok lavo. ");
INSERT INTO kbm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ayeu Jon ebe gali gen etok gisov matanongg ok, ete ganei gen etok ane yaun. Be ayeu ate gali ganei yaun ete ayeu ganei ok, etok yaun ano molge. Dangetok be yem aplongg aim nivin ge. ");
INSERT INTO kbm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gen bambamo etok meng gihlang, beti yaun ebe giengk Pomate ane kapia ok ande ano gile. Ve yaun nok ginei dang eteik: “Atob eisir ines ei tulkwe ti butu ite.” ");
INSERT INTO kbm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Be yaun nok ti vukuri ginei dang eteik: “Atob eisir matanos nitut nimbweg amol ebe warik iro ve i ok.” ");
INSERT INTO kbm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bwayage kob Josep Arimatia ane gile be giutani Pilata ve nivwat Yisu utle ulis nile be nispun. Be Josep nok ei amol ti ebe givang mul ve Yisu ane yaun ge ok, bemem ei ginei ate vusa ite ve gipelk ve eisir bambamo Juda ane. Beti Pilata ginei gitangi ei ve nile be nivwat. Josep gile be geb Yisu utle ulis nangge ei givsangin gisov meng gitak nalk. ");
INSERT INTO kbm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Be Nikodimos, amol ebe warik gitangi Yisu gile gimungg mate ge ok, givwat ei ailu ane tui ebe itak gisov gen-mate dongke ge ok be givang givin Josep. Be ei tui etok ane bunam gitlek padi bek ti ane bunam. ");
INSERT INTO kbm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Amol gabu ile be ilgum gen gitangi eisir Juda as luev ebe ispun ispun as gimat ok, be gabu iravu Yisu utle ulis tis ei tui ukwas etok ve kambam bogbogo bamo ti. ");
INSERT INTO kbm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Be nalk avo gimat ane ti giengk gibloblo taku ete es Yisu gireu ei nangge ok. Be nalk avo nok giengk aikawe molge gikwai nam ite, be ispun gimat ti gisov nalk avo nok ite nangge. ");
INSERT INTO kbm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Be as mate etok ete eisir Juda ipas-pasang is ate ve Sonda Pasova ane, be Josep gabu Nikodimos gitangi ebe atob invwat Yisu utle ulis inde sawa ti kob inaspun ok ite, beti gabu itak Yisu utle ulis gisov nalk avo etok tupe ge. ");
INSERT INTO kbm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Givin Sonda tistumi-ngge, tumi gisov nalk ge nangge be Malia Magdala ane be tis avie gaptol subu ile ve invail Yisu ane umbub. Malia Magdala ane nok gili vat bamo ebe giengk gisil Yisu ane nalk avo ok, ande gidug-dug gile giengk aikawe gikwai nalk avo. ");
INSERT INTO kbm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Beti ei gituvki ge gitangi Pita be tis ayeu Jon ebe Yisu ta givin ayeu gitlek ok, ginme be ginei; “Ande ivwat Amol Bamo gikwai nalk avo be amei tangg amei gisgil. Wali ande ile itak ei giengk sawa inend?” ");
INSERT INTO kbm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Beti eilu Pita amdil be ale ete nalk avo ok. ");
INSERT INTO kbm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Eilu Pita amei gabu ge atuvki ve ale, bemem ayeu gab tulkwangg vier be gabielk ebe nalk avo ok gimungg bekob Pita. ");
INSERT INTO kbm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ayeu gabielk be gavarkei ete nalk dobo ok ge be gatlek nangg gisov nalk avo ebe Yisu giengk ok, okob gali kambam bogbogo ebe giengk nalk aplo ok bemem gasov nalk avo nok gale ite. ");
INSERT INTO kbm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Be Pita vemul ginme kob mang-mangi gisov nalk avo gile. Pita vepie gisov nalk aplo gile be gili kambam bogbogo bamo ebok be tis kambam den-den subu be tis kambam den ebe iravu Yisu dabe ok ge giengk nalk aplo. Be imual kambam ebe iravu Yisu dabe ok love vie-ngge be itak giengk atane ge. ");
INSERT INTO kbm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bekob ayeu vepiangg gasov nalk avo gale gavin be gali gen bambamo etok be aplongg givin ge ganei Yisu ande matawe be gimdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Givin sawa etok ete eisir itpweng yaun ebe giengk Pomate ane kapia ok are ite nangge.) Ve yaun etok ginei dangeteik; Atob Yisu matawe be nimdil nangge taku gimat ane vukuri. ");
INSERT INTO kbm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bekob eilu anumul ale ebe nam ok. ");
INSERT INTO kbm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia ginumul gile givarkei gibloblo nalk avo be gitlek na gisov nalk avo be giteng giteng givarkei. ");
INSERT INTO kbm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bekob gili angela ailu ino gen bogbogo ge be ande ile imbweg Yisu lavo ebe giengk ok nangge ebe nalk avo ok. Amol ti gibweg gideb dabe ane be ti gibweg gideb va ane. ");
INSERT INTO kbm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Be sulu iutani Malia be inei; “Mie guteng ve ret?” Malia giwel sulu avos be ginei; “Ande amolmol inme be ivwat awangg Amol Bamo gikwai, be ayeu gali taku ebe ande ile itak ei giengk ok ite.” ");
INSERT INTO kbm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Malia ginei yaun etok gikwai be veve niro na vukir ok gili Yisu ete givarkei nik. Bemem Malia gitpweng ei are ite. ");
INSERT INTO kbm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yisu giutani Malia be ginei; “Mie guteng ve ret?” Malia gili ei be ginei bwat amol ebe geb taku etok dabin ok, beti giwel ei avo be ginei; “Amol bamo, ginei mie guvwat ei gikwai, kob unei taku ebe gule gutak ei giengk ok binge itangi ayeu, veik nale be navwat ei.” ");
INSERT INTO kbm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yisu ginei gitangi ei be ginei; “Malia.” Malia giro na vukir be ginei gitangi ei giengk Hibru avos ge be ginei; “Raboni.” Tanro are etok vukir tanei “Gidung.” ");
INSERT INTO kbm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yisu ginei gitangi ei be ginei; “Bagem inme omb Ayeu bwaya. Ve Ayeu gareu gale ebe Tamangg ok ite nangge. Bemem mie nu-numul nutangi awangg male gen nule be nunei; ‘Ayeu ve nareu natangi Tamangg, be yem Tamangg aim nale. Ayeu atob natangi angg Pomate, be yem aim Pomate nale.’” ");
INSERT INTO kbm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Beti Malia Magdala ane nok ginumul gitangi amei singamolomb ginme be ginei; “Ande ayeu gali Amol Bamo gikwai.” Be ei ginei yaun ebe Yisu ginei gitangi ei ok gitangi amei. ");
INSERT INTO kbm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Givin Sonda etok ane gibok, amei singamolomb aro amei ate sut asov nam ebe ayengk ok aplo ale ambweg be as nam avo gile. Ve amei anei bwat atob bambamo Juda ane ines amei vunu nivin, beti apelk be as nam avo gile. Bekob Yisu ginme givarkei gisov amei luvwe butu ge be ginei gitangi amei be ginei; “Aplongg aim bunam bwaya.” ");
INSERT INTO kbm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ei ginei yaun etok gikwai kob ges bili lavo ebe giengk bage be tis ra-rali ok ru gitangi amei. Beti amei tangg amei vevie-ngge ve ande ali Amol Bamo. ");
INSERT INTO kbm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Be Yisu ginei gitangi amei vukuri be ginei; “Aplongg aim bunam bwaya. Tamangg gihlin ayeu be ganme, dangetok beti atob ayeu nahlin yem be unde weik etok ge.” ");
INSERT INTO kbm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ei ginei yaun etok bekob giyuw avo ukwas giwei amei be ginei; “Un-gas Ngalau Yamar ilek. ");
INSERT INTO kbm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ginei yem tangg aim nivalngan amolmol subu as gen tiate ebe ilgum ok, okob eisir as tiate etok atob ma nikwai. Be ginei yem unggas eisir as tiate etok ane yaun ta niengk, okob atob eisir as tiate etok atob niengk dangetok. ");
INSERT INTO kbm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Givin ebe Yisu ges ate ru gitangi amei ok, be givin etok ete amei-mei amol ti gibweg givin ite. Amol nok are Tomas, be ital are ti inei (bwa-bwak ve tine vie ve sulu ailu gipil dongke.) ");
INSERT INTO kbm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Beti amei subu ebe ali Yisu gikwai ok, anei gitangi ei be anei; “Ande amei ali Amol Bamo.” Bemem Tomas nok ginei gitangi amei be ginei; “Ginei ayeu nali bili lavo ebe giengk ei bage tap-tape ok ite, be natak baingg kuku nisov bili lavo ebe giengk ei ra-rali ok ite, atob ayeu aplongg nivin ite. Ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Amei singamolomb ambweg amei nam aplo ge dangetok love ande Sonda ti gile gikwai. Be givin etok ete Tomas ok gibweg givin amei be tepwe ambweg ebe nam aplo ok be as nam avo gile. Bekob Yisu ginme givarkei gisov amei luvwe butu ge be ginei; “Aplongg aim bunam bwaya.” ");
INSERT INTO kbm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bekob ginei gitangi Tomas be ginei: “Utak bagem iwei ayeu baingg tap-tape be uli bili lavo ebe giengk ayeu baingg tap-tape ok. Be bagem kuku isov bili lavo ebe giengk ayeu ra-ralingg ok ile be uli. Be aplom ailu ailu bwaya be aplom nivin ge.” ");
INSERT INTO kbm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Be Tomas giwel ei avo be ginei; “Amol Bamo, Mie awangg Pomate.” ");
INSERT INTO kbm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yisu ginei gitangi Tomas be ginei; “Ande mie guli ayeu gisov matanom beti aplom givin me-ra? Bemem ayeu avongg nivwat eisir ebe ili gen ano ite, be aplos givin ge ok ares.” ");
INSERT INTO kbm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisu gilgum gen bambamo walang molge giengk ane singamolomb-gen amei nangg amei be ali, bemem ayeu Jon garo gen etok tepwengge ane yaun gisov kapia etenik ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bemem ete ande ayeu garo gikwai nik, etok ayeu galgum veik yem aplongg aim nivin unei Yisu ei eitit and Amol Bamo (Mesia) ebe ve nemb eitit dabin ok. Be Pomate ane Natu ei. Dangetok be ginei eitit aplond nivin ei, atob eitit tanambweg matawand nemb ta ge ve ei ane. ");
INSERT INTO kbm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bwayage kob Yisu ges ate ru gitangi ane singamolomb-gen amei dubi ti nangge bui kapul Taibirias. Ei ane luev ebe ges ate ru gitangi amei ok dang eteik; ");
INSERT INTO kbm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Givin sawa etok ete Saimon ebe ital are ti inei Pita ok gabu Tomas ebe ital inei Bwa-bwak ok, be Natanael Kana-an ane nangge Galilaia as taku. Be eilu Jems be tis Yisu ane singamolomb-gen subu as amol ailu ivin. ");
INSERT INTO kbm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pita ginei gitangi amei be ginei: “Ayeu ve nale ve nalgum wenk.” Beti amei anei gitangi ei; “Tale ma.” Beti amei ale be asu ei-vovo ti gile givwew be ale, bemem tambok undib etok amei anggas wenk natu ti ite molge ma yapin. ");
INSERT INTO kbm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Be gibloblo ve niro vusa ane, be Yisu ande gile givarkei ebe alus ok. Bemem amei ali ei be tangg amei gisgil ve anei bwat amol ebeok ti. ");
INSERT INTO kbm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Be bwayage kob Yisu giutani amei be ginei; “Nunus gaptol, ande ulgum wenk subu me ma?” Be amei awel ei avo be anei; “Ma yapin.” ");
INSERT INTO kbm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Be ei ginei gitangi amei be ginei; “Baingg aim vier ve aim wasang isov gielk indeb ei-vovo tavlu ane indeb baingg aim mol ane, be atob un-gas wenk subu.” Beti amei atak amei wasang gisov gielk gile vukuri love ande wenk anongge molge gisov wasang gile, be amei algum ve anarwel wasang nipil bemem gitangi ite. ");
INSERT INTO kbm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Beti amei singamolomb amei amol ti ayeu, ebe Yisu ta givin gitlek ok ganei gitangi Pita be ganei; “Amol Bamo nok eteok.” Pita giute ebe, Amol Bamo nok eteok ok, beti givir-viri ane kup ebe galkik giwaulu be giengk ok gireu ate be vepie gisov bui be gikut-kwet. ");
INSERT INTO kbm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Be amei subu avwes ei-vovo be arwel wasang tis wenk ale apil ebe alus ok, ve amei avwew aikawe kasop gege akwai ebe alus ok. ");
INSERT INTO kbm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Amei avwes love ale atung alus be ali yev mate ti giengk etok be ande itak wenk gile yev nok be yev gen giengk, be ben subu ok giengk givin. ");
INSERT INTO kbm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yisu ginei gitangi amei be ginei; “Unde unvwat wenk galk gisov wasang ok subu unme.” ");
INSERT INTO kbm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Beti Pita gile ebe ei-vovo ok, be girwel wenk tis wasang gipil aplo gile. Be wenk ete gisov wasang ok, anongge be bambamo ge. Wenk nok gitangi 153. Wenk etok gitlek molge bemem wasang giti-titip ite ma. ");
INSERT INTO kbm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Be Yisu ginei gitangi amei be ginei; “Unme be unen ben kob.” Be amei mei amol ti gitangi ebe ve niutani Yisu be ninei; “Mie amol ret,” ok ite ma. Ve amei atpweng are gikwai anei Amol Bamo nok etenik. ");
INSERT INTO kbm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Bekob Yisu geb ben tis wenk gitangi amei be an. ");
INSERT INTO kbm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisu matawe be gimdil nangge taku gimat ane gikwai kob ete ges ate ru gitangi ane singamolomb-gen amei. Be etenik ei ges ate ru bulwer aitol ane etenik, ve nolge ei ges ate ru mate ane beti ve luvwe ti ane be amei ali ei gikwai. ");
INSERT INTO kbm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Amei tis Yisu an ben be ma gikwai kob ei ginei gitangi Pita be ginei; “Jon natu Saimon, Mie wat tam givin ayeu anongge gitlek eisir subu etenik me?” Pita ginei gitangi ei be ginei; “Amol Bamo bingano, mie guli gikwai gunei ayeu tangg givin mie.” Be Yisu ginei gitangi ei be ginei; “Mie nomb ben nitangi awangg bwelk sipsip be nomb eisir dabin vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yisu giutani Pita vukuri be ginei; “Jon natu Saimon, mie tam givin ayeu me ma?” Pita giwel Yisu avo be ginei; “Amol Bamo, bingano. Mie guli gikwai gunei ayeu tangg givin mie.” Be Yisu ginei gitangi ei be ginei; “Mie nomb ben nitangi awangg bwelk sipsip be nomb is dabin vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yisu giutani Pita bulwer aitol ane be ginei; “Jon natu Saimon, mie tam givin ayeu me ma?” Be Pita aplo bunam ve ebe Yisu gituani ei ve yaun dongke nok ge bulwer ailu gikwai beti ve ti vukuri ok. Beti ei giwel Yisu avo be ginei; “Amol Bamo, mie gutpweng gen walang ok are be ma gikwai, be mie guli gikwai gunei ayeu tangg givin mie.” Be Yisu ginei gitangi ei, “Nam nuli awangg bwelk vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ayeu nanei bingano ge nitangi mie nanei: “Mie guvang utlem ulis matas ge ete mie ate gubiti am bika be guvang gitangi ebe am tam gitung ok. Bemem asonge nivin ebe mie babamos amol ok, okob atob mie nurun bagem itin be amol ti atob nidgin mie bagem ta weik ete warik idgin ayeu baingg ta ok. Be atob in-gas mie nule taku ebe mie buam ve nule ok.” ");
INSERT INTO kbm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yisu ginei yaun etok ve ges luev ebe asonge Pita nimat vunu nireu ei-givsangin, be nilgum Pomate are menihlang bamo ge ok ru yapin). Yisu ginei yaun etok be ma gikwai kob ginei gitangi Pita be ginei; “Uvang mul ve ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita girau na lili be gili eisir singamolomb as amol ti ebe Yisu ta givin ei gitlek ok, gitau gile sulu Yisu ve gile. Amol nok ebe warik gibweg gile gibloblo Yisu be en ben imbweg be giutani Yisu be ginei; “Amol Bamo, amol ret atob ninei mie binge nitangi bambamo valir ane ok.” ");
INSERT INTO kbm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ete Pita gili amol nok be giutani Yisu be ginei; “Amol Bamo, amol etok atob nam nambed?” ");
INSERT INTO kbm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yisu giwel Pita avo be ginei; “Ginei ayeu tangg nitung ti ve amol etok atob nimbweg painge love ayeu nanumul nanme sin-ge, okob etok miam gen givin ite ma. Be mie unme be utau ile ayeu.” ");
INSERT INTO kbm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Beti yaun ete amol etok atob nimat vunu ite ok, ande eisir singamolomb subu ok iute be ma. Bemem Yisu ginei ete atob amol etok nimat vunu ite ok ite ma. Ei ginei dangeteik ginei; “Ginei ayeu tangg nivin ve amol etok nimbweg love ayeu nanumul nanme kob ok, okob etok miam gen givin ite.” ");
INSERT INTO kbm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Be amol etok, ete ayeu ate nok ete ganei gen bambamo etok ane yaun nik. Be ande ayeu garo yaun etenik gisov kapia gikwai. Be ande eitit tatpweng are tanei yaun ete ayeu ganei ok, ano molge. ");
INSERT INTO kbm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisu gilgum gen bambamo subu givin be amei ali. Bemem ginei amol ta gitung ve niro gen bambamo etok tepwengge ane yaun nitangi ge nisov kapia, atob kapia nok niengk nalk bamo nik avut. ");
INSERT INTO kbm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiopili, Ayeu garo yaun mate ane gikwai gipil gen bambamo ebe Yisu gilgum be gibul ok, givin ebe ei geb ane kulkul vaku-ngge, ");
INSERT INTO kbm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","be ginme love gitangi ebe Pomate gigas ei gireu gile gulumb ok. Givin sawa etok Pomate gigas Yisu gireu gile ite nangge, be Ngalau Yamar geb Yisu avwut be ginei yaun kulkul ane gitangi amolmol ebe warik ei geb eisir yapin ve in-gas mateu intangi nam-nam ge inde ok. ");
INSERT INTO kbm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ei gigas vavavne be gimat vunu bekob matawe be gimdil vukuri be ges ate ru gitangi ane amolmol kulkul ane be givang givin eisir gitangi as-mate 40. Be gilgum kulkul walang ano nangge eisir nas veik indi be inatpweng are roro-ngge inei ei gimat vunu bemem ande matawe vukuri. Be ei ginei yaun gipil ebe Pomate ve nemb amolmol dabin ok lavo gitangi eisir givin. ");
INSERT INTO kbm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yisu givang givin eisir ge nangge be ges bing ve eisir be ginei; “Yem unamdil unkwai Jerusalem bwaya, be unambweg love Tamangg nemb gen ebe warik gibiti ane yaun ge be ayeu ganei binge gitangi yem ok, nikwai kob unvang! ");
INSERT INTO kbm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ve Jon ges bui sanggu gipil yem ve bui singe, bemem bwayage kob atob yem un-gas Ngalau Yamar.” ");
INSERT INTO kbm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Givin sawa etok eisir aposel imbweg dongke ivin Yisu, be eisir iutani ei be inei, “Amol Bamo, atob sawa etenik ge mie nomb amei ru be nomb gwang-ne nitangi amei Israel be amei ate anemb amei nalk dabin dang warik me ma?” ");
INSERT INTO kbm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Be Yisu ginei gitangi eisir, “Yem gitangi ebe atob unatpweng sawa ebe Tamangg ei ate ta gitung ok are ok ite. ");
INSERT INTO kbm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bemem Ngalau Yamar atob niro yem ta be unei awangg yaun ebe gamat vunu be gamdil vukuri ok, nangge Jerusalem be nangge Juda as taku be nangge Samaria as taku be tis taku walang ok.” ");
INSERT INTO kbm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yisu ginei yaun etok gikwai kob eisir ivarkei be itlo ei ebe gireu gulumb gile ok, be umbim ti ginme gisil Yisu be eisir ili ei vukuri ite. ");
INSERT INTO kbm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eisir ivarkei be nas giro gulumb ta ivarkei be seukie-ngge ili amol ailu ino kup bogbogo ge be inme ivarkei imbloblo eisir. ");
INSERT INTO kbm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Be sulu inei, “Yem amolmol Galilaia ane ebenik, unvarkei be nangg-aim iro gulumb ta dang-etok bwaya, ve Yisu ebe galkik uli ok ete ande Pomate gigas ei gikwai yem be gireu gulumb gile gikwai. Be Yisu nok atob ninumul ninme weik ete galkik uli ei gireu gulumb gile ok.” ");
INSERT INTO kbm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bwayage-kob eisir aposel nangge matendubi ebe ei oliv givarkei ok, be ilumul ile itak Jerusalem vukuri. Matendubi nok, giengk aikawe kasop-gege gikwai nam bamo Jerusalem. ");
INSERT INTO kbm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eisir isov Jerusalem ile be ipil as nam ile imbweg nam aplo ei-nggoto ane. Be eisir nok ares eteik, Saimon Pita gabu Jon, be Jems gabu Endru, Pilip gabu Tomas, be Batolomai gabu Matai be Alapai natu Jems. Be Saimon, amol ebe gilgum ve nitin amolmol Rom ane inkwai Israel ok, gabu Judas Jems natu. ");
INSERT INTO kbm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eisir etok tis avie gaptol subu be tis Yisu tine Malia be male-nggen tepwengge ipil dongke be es miengk geb ta-ngge tis as-mate walang ok. ");
INSERT INTO kbm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Be bwayage-kob Yisu ane amolmol-gen gitangi 120 iro isate sut ve inkasa, be Pita gimdil givarkei amolmol tepwengge nas ve ninei yaun be ginei; ");
INSERT INTO kbm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Angg nune-nggen, Warik Ngalau Yamar geb Dawit avut be ginei yaun ebe giengk kapia Sam ane ok gipil Judas ve asonge Judas nitwem amolmol valir ane be inemb Yisu ta. Be yaun etok galkik ande ano gile. Yaun nok ginei dang-eteik: ‘Ei ane nam atob niengk bun sin-ge.’ Be yaun nok ake ti givin weik eteik, ‘Amol ti atob niwel ei be ninggas ei ane kulkul.’ (Judas gigluend ve ate be gikaiwel love subwe girun bekob beleinge gile gitak be ta ges vier gile gihlang. Be amolmol ivwat ei ane kulkul tiate ebe gilgum ok ane mone ile be ivgo nalk sawa ete ei gimat giengk ok ve ei ate utle ulis ane. Be gideb mul ane kob amolmol Jerusalem ane iute binge inei nolge Judas gimat vunu, beti eisir ital taku ete Judas gimat giengk ok inei, “Taku twerk ane.”) Judas nok ei ameimei amol ti ebe warik Yisu geb amei ve analgum kulkul anvin amei ate ok. ");
INSERT INTO kbm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Dang-etok be eitit tanemb amol vaku ti ve ninggas Judas ane kulkul be nivang nivin eitit veik ninei Amol Bamo Yisu ane binge ebe gimat vunu bemem ande matawe be gimdil vukuri ok nitangi amolmol. Bemem eitit tandi amol ti ebe givang givin eitit givin ebe Jon ges bui sanggu gipil Yisu be ginme love ebe Yisu gikwai eitit be gireu gulumb gile ok.” ");
INSERT INTO kbm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Beti eisir ital amol ailu ares gile gihlang, amol ti are Josep ebe ital inei Basabas ok (be are ti Jastas.) Be amol ti are Matias. ");
INSERT INTO kbm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bekob es miengk gitangi Pomate be inei, “Amol Bamo, Mie gutpweng amolmol tepwengge aplos are gikwai, dang-etok be mie nos sulu ailu eteik as amol ti ebe mie tam givin ok ru nitangi amei, ");
INSERT INTO kbm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ebe ve ninggas kulkul etenik niwel Judas ok. Ve nolge Judas gikwai kulkul etenik be givang taku tiate ebe ei gilgum ve nimbweg ok ane gikwai.” ");
INSERT INTO kbm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Be eisir es bwas ivang love emb Matias ve nemb kulkul niwel Judas be nivang nivin eisir aposel 11 ebe ivang yapin ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Givin as-mate etok eisir Juda iro as ben sut veve indi as Sonda Pendekos, be Yisu ane amolmol-gen tepwengge iro is-ate sut isov taku dongke-ngge be imbweg. ");
INSERT INTO kbm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Be seukie-ngge avo bil-bilinge ti meng-gihlang nangge gulumb weik ebe wavin vuvu-vunge ve ginme ok, love geb nam ete eisir imbweg ok avut. ");
INSERT INTO kbm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Be eisir ili gen weik ebe yev ane amble ok gile gitak be gen etok gitip gilkili be gibwas ate gitangi eisir ananos ge. ");
INSERT INTO kbm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ngalau Yamar geb eisir avut be givin sawa etok ge Ngalau Yamar geb eisir avos ru be inei yaun giengk amolmol walang ok avos gitangi ge gile. ");
INSERT INTO kbm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Be givin etok amolmol Juda ane as amolmol mateu ane subu ebe imbweg itangi taku walang ok ge gile ok, iro is-ate sut isov Jerusalem ge be imbweg etok. ");
INSERT INTO kbm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Amolmol tepwengge iute gen bil-bilinge etok be tepwengge iro isate sut ile ipil dongke-ngge. Bekob iute ebe Yisu ane amolmol-gen inei yaun giengk eisir avos gitangi ge ok, be ikuri vunu-ngge. ");
INSERT INTO kbm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Be tas gitung gile ma be ilat bais be inei, “Nam-nambed ete ande eisir etenik inei yaun giengk eitit avond gitang-tangi ge nik? Ve etok eisir Galilaia ane ge bambamo etenik? ");
INSERT INTO kbm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Be wali nam-nambed ete ande eitit etenik tepwengge taute ebe eisir inei yaun giengk eitit avond be gile gitangi roro-ngge weik ebe eitit ate taute be tanei nangge tamand-gen tis tinand-gen avos ok? ");
INSERT INTO kbm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ve etenik eitit amolmol avo ti ane ti ane nangge Patia be Midia be nangge Ilam tis Mesopotamia be Judia tis Kapadosia, be nangge Pontas be Esia. ");
INSERT INTO kbm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Be nangge Frisia tis Pampilia be Aigipten, be nangge Libia as taku ebe gibloblo Sairini ok, be tis eitit Rom ane ebe tanme tambweg etek ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Be eitit Juda be tis amolmol subu ebe ivang mul ve eitit Juda and luev ok be eitit Krit be tis Arabia ane bambamo ete taro it-ate sut tanme tambweg etek? Bemem ande eitit etenik tepwengge taute ebe eisir inei Pomate ane gen bwalbwale bambamo giengk eitit and yaun be gile gitangi roro-ngge.” ");
INSERT INTO kbm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Be tas gitung gile ma be inei, “Gen etenik wat tis ane lavo ti?” ");
INSERT INTO kbm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bemem eisir nok as amolmol subu ilgum molok gile Yisu ane amolmol-gen be inei eisir inum bui vavis. ");
INSERT INTO kbm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bwayage-kob Pita gimdil be givarkei givin aposel 11 ebok be gital yaun avo bamo gitangi amolmol tepwengge be ginei, “Eitit Juda be tis amolmol tepwengge ete galkik tanme tambweg Jerusalem nik unaute kob! Gen bamo etenik ane dabe dang eteik: ");
INSERT INTO kbm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yem unei amei anum bui vavis beti gilgum dabangg-amei gwet be tiate, bemem dang-etenok ite. Vasov nik ge 9 kilok tistumi be gitangi ebe ve inum bui vavis ok ite nangge. ");
INSERT INTO kbm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bemem gen etenik gitangi yaun ebe warik Joel amol ebe ginei Pomate avo ok ginei ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","21","Ve Pomate ginei; ‘Atob ayeu nalgum dang-eteik nindeb mul ane. Ayeu atob namb angg Ngalau Yamar nitangi amolmol tepwengge. Be yem natungg-aimgen tepwengge amol be avie, atob inei mateu avos weik amolmol ebe inei Pomate avo ok. Be aim amol gaptol singamolomb atob indi gen walang ano weik ebe mev ok, be atob nasu mev nitangi tumbungg-aimgen. Be atob ayeu namb Ngalau Yamar nitangi angg amolmol kulkul ane weik etok ge, avie be amol. Be atob eisir inei mateu avos weik amolmol ebe inei Pomate avo ok. Atob ayeu nalgum as-matano be menihlang weik tambok, be nalgum aiweng be niro mwele weik ebe twerk ok. Be nangge nalk atob ayeu nalgum gen bwalbwale bamo ti. Atob twerk tis yev be yev umkumk bamo nimungg, bekob atob Amol Bamo ane as-mate ebe ve ninumul ninme ok menihlang. Be ei ane as-mate etok atob tandi tanei as-mate bamo ti, be atob bogbogo weik ebe yev giro taku be bogbogo ok. Be nivin etok atob amolmol tepwengge ebe as tangir gitangi Pomate gile ok, ete atob Pomate nemb eisir ru.’” ");
INSERT INTO kbm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Be Pita ginei; “Yem amolmol Israel ane, unaute yaun eteik okob. Pomate ginei Yisu Nasaret ane lavo gitangi yem gipil gen bwalbwale be tis gen bambamo ebe Yisu gilgum ok be yem utpweng are gikwai, ve gen etok Yisu gilgum nangge yem aim taku. ");
INSERT INTO kbm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Be Pomate gili be gitpweng are gimungg ginei, atob ei nemb Yisu nitangi yem ninme. Bemem kob atob yem unemb ei nitangi amolmol tiate ane nile be ines ei nireu ei-givsangin. Be etok weik ebe yem ate os ei vunu ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bemem Pomate ges ei itin vukuri be gihlang ei gikwai tanmat vunu ane gwang-ne, ve gitangi ebe atob tanmat vunu ane gwang-ne nemb ei ta ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ve warik Dawit ginei yaun gipil Yisu nok be ginei; ‘Ayeu gali Amol Bamo givang gibloblo ayeu geb ta-ngge, be ei givang givin ayeu beti gen ti gitangi ebe atob nisgul ayeu be nambieg ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Beti ayeu ganei aplongg vusa tis ta-ngg vevie-ngge. Be ayeu utlangg ulis ok weik etok ge, atob nisge gen vie nivang painge ge. ");
INSERT INTO kbm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ve atob mie tam nivalngan ayeu dalgongg matawas ane be niengk em niengk taku gimat ane ite. Be atob tam nivalngan am amol vie be nimat vunu be utle nipiel ite. ");
INSERT INTO kbm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mie gos luev matawas ane ru gitangi ayeu gikwai, be atob nutak ayeu nambweg navin mie tis ta-ngg vevie-ngg ge.’ ");
INSERT INTO kbm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Be Pita ginei gitangi eisir be ginei, “Angg nune-nggen, ayeu nanei eitit tumbund Dawit ane yaun lavo vevie nitangi yem be unaute kob. Dawit ginei yaun etok gipil ei ate ite ma. Ei gimat vunu be ispun ei gikwai, be ane umbub ete eitit tamb dabin tavang nik. ");
INSERT INTO kbm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bemem Dawit ei Pomate ane amol ti ebe ginei Pomate avo ok, be ei gitpweng Pomate ane yaun ebe gibiti be ginei ‘bingano molge’ ok are gikwai. Ve Pomate ginei; ‘Atob ayeu namb miam vaku ti ve nemb amolmol dabin weik ete mie nik.’ ");
INSERT INTO kbm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawit gili be gitpweng gen ebe Pomate ve nilgum ok are gimungg gikwai, beti ei ginei yaun gipil Kilisi ebe atob matawe be nimdil vukuri ok be ginei; ‘Pomate gitangi ebe atob nes ei bal nangge taku gimat ane love utle nipiel ok ite.’ ");
INSERT INTO kbm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Be Pita ginei, Yisu nok ete Pomate ges ei itin vukuri nangge taku gimat ane be amei tepwengge matanongg-amei gitut gibweg ei, beti anei ane yaun. ");
INSERT INTO kbm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Be galkik ande ei gireu gile gibweg gibloblo Pomate be gigas Ngalau Yamar nangge Tame ane, ebe warik ginei yapin ve nemb nitangi ei ok. Beti galkik ei nok ge ane gwang-ne ete gilgum gen bambamo ete ande yem uli be ute nik. ");
INSERT INTO kbm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawit ei ate gireu gulumb gile ite, bemem ei ginei, ‘Pomate ginei gitangi Amol Bamo dang-eteik, ");
INSERT INTO kbm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","‘Mie numbweg numbloblo ayeu ge love ayeu natak amolmol ebe ili mie tiate ok tepwengge insov miam gwang-ne ane lu okob.’ ");
INSERT INTO kbm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dang-etok be eitit Israel ane tepwengge tanatpweng gen etok are vevie okob. Ve Yisu ebe yem os ei gireu ei-givsangin gile ok, ete ande Pomate gitak ei ve Amol Bamo ebe ve nemb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Amolmol iute yaun etok love aplos bunam molge be tas gitung gile ma be inei gitangi Pita be tis ane sukus-gen be inei, “Atob amei analgum amei ate nam-nambed ge?” ");
INSERT INTO kbm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Be Pita ginei gitangi eisir be ginei, “Tepwengge unro aim ate vukir be unringk bui sanggu ve Yisu Kilisi ane gwang-ne ane veik nisin aim tiate walang ok nikwai. Be Pomate atob nemb Ngalau Yamar nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ve warik Pomate ginei yapin ginei atob nemb gen etok nitangi yem tis natungg-aimgen be tis amolmol taku ti ane nivin. Bingano, Pomate ei eitit and Amol Bamo, be ei ginei gikwai ginei ei tang-givin ve nemb Ngalau Yamar nitangi amolmol tepwengge ebe gital eisir be itangi ei ile ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Be Pita ginei yaun subu givin gitangi eisir be ginei gwang-ne ge be ginei, “Nangg-aim undi aim ate-ngge, velob unyaing aim ate be un-gas vavavne unvin amolmol tiate ane. ");
INSERT INTO kbm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Amolmol bon ge aplos givin Pita ane yaun be iringk bui sanggu. Be givin as-mate etok ge amolmol ebe iro is-ate vukir be meihlang ve Pomate ane amolmol-gen ok gitangi 3,000. ");
INSERT INTO kbm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Be eisir nok ivang ivin aposel be en Pasa ve tas gitung Yisu be aposel imbul eisir, be en ben gisov dongke be es miengk ivin is-ate gigas ta-ngge. ");
INSERT INTO kbm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Amolmol tepwengge ili gen bambamo be tis gen bwalbwale bambamo ebe aposel ilgum ok be ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Be Pomate ane amolmol-gen tepwengge ivang ivin is-ate vie-ngge be ili eisir ate as gen weik ebe eisir tepwengge as gen ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Eisir nok emb as nalk tavlu be tis as gen subu subu gitang-tangi ge be amolmol ebeok ivgo, bekob ivwat mone gen etok ane ile be imbwas gitangi amolmol ebe ben be gen walang ok ma ve is ok. ");
INSERT INTO kbm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eisir tepwengge aplos dongke-ngge be as-mate walang ok eisir isov lum yamar bamo aplo ile. Be en ben ivin is-ate gitang-tangi as nam ge tis tas vevias ge be aplos dongke-ngge. ");
INSERT INTO kbm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Be avos ges Pomate tis as-mate walang ok, be amolmol ebeok tepwengge tas givin eisir be ipasang eisir vie-ngge. Be as-mate walang ok Amol Bamo geb kulkul ve gigas amolmol ebe geb eisir ru ok ile isov ei ane amolmol-gen aplo ivin. ");
INSERT INTO kbm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","2","As-mate ti givin gibok (3 kilok) Pita gabu Jon ile ve insov lum yamar aplo inde ve eisir as as-matano ebe ve ines miengk ok givin gibok. Be amol kubuk ane ti gibweg gibloblo lum yamar bamo etok ane nam avo bamo ti ebe ital are inei ‘Vie Molge’ ok. Amol nok ane Sonda bamo gitangi 40. Ei va mwaimuai (gimat) yapin givin ebe tine gikuv ei ok, be gitangi ebe ve nivang ok ite. Be as-mate walang ok amolmol ivwat amol nok ile itak ei gibweg gibloblo lum yamar bamo etok ane nam avo bamo ebe ital inei ‘Vie Molge’ ok, veik niutau-tani mone be tis gen subu subu nangge amolmol ebe ile ve insov lum yamar aplo inde ve miengk ane ok. ");
INSERT INTO kbm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Amol nok gili Pita gabu Jon ebe ile ve inde insov lum aplo ok, be giutani sulu ve ginei inemb ei ru be inemb mone siti ve ei. ");
INSERT INTO kbm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita gabu Jon ivarkei vas ta be nas giro amol nok ta ivarkei, bekob Pita ginei gitangi ei be ginei, “Nam roro-ngge nitangi eilu.” ");
INSERT INTO kbm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amol nok girau na lili gitangi sulu be ginei bwat atob sulu inemb gen ti nitangi ei. ");
INSERT INTO kbm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bekob Pita ginei, “Ayeu mone ma ebe ve namb mie ru be namb nitangi mie ok. Bemem gen ebe ayeu ve namb nitangi mie ok ete dang-eteik: Ayeu nanei nitangi mie ve Yisu Nasaret ane ane gwang-ne be nanei ‘Umdil be uvang.’” ");
INSERT INTO kbm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bekob Pita bage gile geb amol nok gibweg bage mol be girun ei itin ve nivarkei, be seukie-ngge amol nok va gwang-ne be vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Be vepie gile givarkei bekob givang givin Pita gabu Jon be isov lum aplo ile. Amol nok givang be vepie vepie be avo givwat Pomate are. ");
INSERT INTO kbm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Amolmol bambamo ebe imbweg lum yamar aplo ok, ili amol nok ebe ande va walo gwang-ne be ei ate givang be avo givwat Pomate are ok, ");
INSERT INTO kbm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","be itpweng are inei amol etenik ebe warik va mwai muai be gen ma ve ane be gibweg gibloblo nam avo lum yamar bamo etenik ane ebe ital inei vie molge ok, ve giutau-tani mone be gen nangge amolmol ok. Be eisir avos poke-ngge be tasgitung gile ma-ngge ve gen ete meng-gihlang gipil ei ok. ");
INSERT INTO kbm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amol nok bua ve ret nikwai Pita gabu Jon, be ei geb sulu bais be sotol tepwe ile ivarkei lum yamar bamo nok ane aplo ti ebe ital inei ‘Solomon ane nam aplo’ ok, be nam aplo etok isil avwut ite be salang salang ge weik ete samuak ok. Amolmol tepwengge ili be ikuri is-ate vunu-ngge be iro isate sut ile idbul sotol. ");
INSERT INTO kbm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","16","Pita gili amolmol anongge ebe inme be ingik is-ate be ilgum ve indi amol etok ok, be ginei gitangi eisir be ginei, “Avongg-aim pikpok ve gen etenik ane bwaya ve etek eitit Israel ane ge tepwe etenik. Be eilu mei gwang-ne gitangi ebe ve unalgum gen ti dang-etenik ok ite. Velob yem tangg-aim nitung unei eilu algum gen gitangi ebe Pomate ane luev ok beti gilgum be amol etenik va walo gwang-ne be givang, bemem ma. Be tangg-aim itung yaun dang-etok be unatlo eilu vun-kunu bwaya. Ve etenik Amol ebe yem omb ei gitangi bambamo mateu ane be tis bambamo ebe emb amolmol dabin ok, ane gwang-ne ete giro amol ete ande uli be utpweng are nik ta. Givin ebe yem ulgum ei ane yaun ok, be Pilata gilgum ve ginei nihlang ei be nile, bemem gitangi ite, ve yem bwaingg-aim ve ei. Be Amol nok ei Pomate ane amol vie molge ti be ei amol yaun ano ane. Bemem yem uvkir dumangg-aim gitangi ei be unei gitangi Pilata ve nihlang amol ti ebe ges amolmol vunkunu ok nikwai kapual-lu be nitangi yem nilek. Be Amol vie dongke ebe ve ninggas eitit tantangi luev matawas ane tande ok ete yem os ei vunu. Bemem eitit tumbud-gen Ablaham gabu Isak as Pomate (ebe warik inei uye be es miengk gitangi ok,) ete ges ane Amol kulkul ane Yisu nok ane gwang-ne be tis ane bogbogo ru gitangi eitit ve ges ei itin vukuri nangge taku gimat ane, be eilu avang ve anei yaun nipil gen etok. Be eilu aplongg-amei givin ei beti ei ane gwang-ne gilgum amol etenik be vie be yem tepwe-ngge ande uli gisov matanongg-aim. ");
INSERT INTO kbm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Angg nune-nggen. Ayeu nanei bingano-ngge nitangi yem nanei, yem tis aim bambamo-nggen ebe emb lum mateu ane dabin ok utpweng gen etok are vevie ite beti ulgum gen dang-etok gipil Yisu. ");
INSERT INTO kbm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bemem yaun ebe warik Pomate ane amolmol kulkul ane ebe inei Pomate avo ok inei ok ginei dang-eteik: Pomate ginei, ‘Awangg amol ebe gab gitangi yem gilek ve nemb aim dabin ok atob ninggas bunam tis vavavne.’ Beti galkik gen ete yem ulgum ok, ande gilgum be yaun etok ano gile. ");
INSERT INTO kbm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dang-etok be unro aim-ate vukir be unvang mul ve Pomate ane luev, veik atob ei nisin yem aim gen tiate walang ok nikwai. ");
INSERT INTO kbm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ginei yem unalgum dang-etok atob Amol Bamo nemb ane gwang-ne ninme niro yem ta. Be atob ei nihlin Yisu, Amol Bamo ebe ve nemb amolmol dabin ok ebe warik ei ate geb yapin ok nitangi yem. ");
INSERT INTO kbm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Bemem atob nimbweg nangge gulumb ok love Pomate nipasang gen walang ok be nile lavo vukuri okob, dang-ebe warik Pomate ei ate ginei gitangi ane amolmol yaun ane ebe inei ane yaun ano vusa ok. ");
INSERT INTO kbm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ve Mose ginei dang-eteik; Pomate ei eitit and Amol Bamo, be atob ei nemb eitit ate and amol ti be nitak ei be nivarkei ve yem aim amol ebe ve ninei Pomate avo ok weik ete ayeu ik. Be eitit tansov amol nok ane yaun walang ok ane lu ge. ");
INSERT INTO kbm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Be ginei amol ti nivkir dume nitangi Pomate ane amol kulkul ane etok ane yaun, atob ei nimbweg matawe nivin Pomate ane amolmol ite, Pomate atob nes ei vunu nikwai. ");
INSERT INTO kbm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Amolmol ebe warik inei Pomate avo ok, ete Samuel ei-ate be tis eisir subu ebe meihlang gideb mul ane ok. Be eisir inei yaun gipil gen ete galkik meng-gihlang givin as-mate etenik ok. ");
INSERT INTO kbm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Be yaun ebe Pomate gibiti be ginei gitangi ane amolmol kulkul ane ebe inei ei avo ok, yaun etok inei gipil yem roro. Dang-etok beti atob yem un-gas gen ebe warik Pomate ginei ane yaun ge gitangi tumbungg-aim gen ok unvin. Ve Pomate ginei gitangi Ablaham be ginei, ‘Atob ayeu namb gen vie molge ti nitangi amolmol tepwengge nangge nalk. Be gen vie etok atob menihlang nangge miam amolmol-gen.’ ");
INSERT INTO kbm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pomate geb ane amol kulkul ane gitangi yem gilek gimungg, be ei tang-givin ve ginei yem untau aim luev gen tiate walang ok ane, veik atob ei na nili yem be unambweg vie-ngge.” ");
INSERT INTO kbm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita gabu Jon inei yaun gitangi amolmol ivang, be amolmol subu ebe emb da gitangi Pomate ok be tis amol bamo ebe geb eisir kambam tupe lum yamar ane dabin ok, be tis Sadukai subu ivang itangi sulu ile. ");
INSERT INTO kbm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Eisir nok tas-vavis anongge gitangi sulu, ve ebe imbul amolmol be inei yaun gipil Yisu ebe gimdil nangge taku gimat ane ok be inei, ei ges luev ru ve amolmol ebe imat vunkunu ok atob inamdil vukuri. ");
INSERT INTO kbm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Beti eisir emb sulu ta be ile itak sulu imbweg kapual-lu givin gibok, be imdil kob inei sulu as yaun. ");
INSERT INTO kbm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bemem amolmol ebe iute Pita ane yaun be aplos givin ok, ete amol gaptol ge gitangi 5,000. ");
INSERT INTO kbm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Givin tistumi eisir Juda as amolmol bambamo be tis awaga be gidung yaun ane subu iro is-ate sut isov Jerusalem ile ve inkasa. ");
INSERT INTO kbm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Be amolmol subu ebe emb da gitangi Pomate ok tis as amol bamo Anas, tis ane amolmol gen subu be Kaiapas gabu Jon be Aleksanda ok ile isov kasa etok aplo ivin. ");
INSERT INTO kbm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eisir itak Pita gabu Jon ivarkei amolmol tepwengge nas be iutani sulu be inei, “Amol ret geb gwang-ne gitangi yemlu be ginei beti yemlu ulgum kulkul etenik?” ");
INSERT INTO kbm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ngalau Yamar geb Pita avut be ginei gitangi eisir, “Yem bambamo be tis awaga Israel ane, ");
INSERT INTO kbm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yem wat galkik ve unautani eilu ve gen vie ebe eilu algum gitangi amol kubuk ane etok be givang vie vukuri ok me? ");
INSERT INTO kbm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ginei dang-etok, okob yem ate be tis amolmol Israel ane tepwengge unaute kob! Yisu Nasaret ane ebe warik yem os ei gireu ei-givsangin gile bekob Pomate ges ei itin vukuri nangge taku gimat ane ok, ete gilgum amol etenik be givang vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Be yaun ti ebe giengk Pomate ane kapia ok ginei yaun gipil Yisu nok dang-eteik; ‘Twelk ebe warik yem amolmol kulkul ane uli taite be bwaingg-aim ok, ete ande meng-gihlang ve twelk nam ane vie molge ti.’ ");
INSERT INTO kbm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Be Pita ginei, amol nok ete Pomate gihlin ei, be meng-gihlang be givarkei ve nemb eitit ru. Be amol ti nangge nalk gitangi ebe ve nemb eitit ru ok givang ite molge. ");
INSERT INTO kbm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Beti eisir ili Pita gabu Jon ebe ipelk ite be gabu inei yaun gwang-ne ge ok, be tas-gitung walang ano. Be itpweng are givin inei sulu isov lum bamo ti ite, sulu amol nam ane ebe warik ivang ivin Yisu ok. ");
INSERT INTO kbm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Be eisir ili amol kubuk ane ebok ebe givarkei givin sulu ok, beti inei yaun ti gitangi sulu ite. ");
INSERT INTO kbm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Beti eisir inei gitangi sulu ve inde inahlang inkwai be inde ve invang. Sulu ile ihlang ikwai kob eisir ate-ngge kakie be iutani isate be inei. ");
INSERT INTO kbm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Atob eitit tanalgum amol ailu etenik nam-nambed ge? Ve amolmol tepwengge nangge Jerusalem ok ande ili be itpweng gen bwalbwale ebe sulu ilgum gitangi amol kubuk ane etok ok are love ma. Be eitit gitangi ebe atob tan-vuaivun yaun gen etenik ane ge ok ite ma. ");
INSERT INTO kbm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bemem lob yaun etenik nivang nemb taku walang ok avut be amolmol inaute be ma. Dang-etok be eitit tandi be tanes bing gwang-ne ge nitangi amol ailu etenik be tanei nitangi sulu tanei inbul amolmol ve Yisu are ane vukuri bwaya.” ");
INSERT INTO kbm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Beti eisir ital Pita gabu Jon inumul ile, be es bing gwang-ne ge gitangi sulu be inei sulu inei Yisu ane yaun be inbul amolmol ve Yisu are ane vukuri bwaya. ");
INSERT INTO kbm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bemem Pita gabu Jon iwel eisir avos be inei, “Yem ate tangg-aim itung vevie be undi kob, unei Pomate gili luev inend vie, tansov yem aim yaun ane lu me tansov Pomate ane yaun ane lu? ");
INSERT INTO kbm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bemem eilu wat avongg-amei nitu ite, eilu atob anei yaun nipil gen ebe eilu ate ali be aute ok painge-ngge.” ");
INSERT INTO kbm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Bambamo yaun ane be tis awaga es bing gwang-ne ge gitangi sulu vukuri bekob ihlin sulu be ile. Ve eisir irek luev ebe ve intak sulu inambweg kapual-lu ok love ili ma. Ve eisir ipelk ve amolmol, ve gisov amolmol tepwengge avos givwat Pomate are ve gen ebe gilgum gitangi amol kubuk ane etok ok ane. Amol nok ane Sonda bamo gitlek 40 be gireu. ");
INSERT INTO kbm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bambamo yaun ane tis eisir awaga ilgum Pita gabu Jon as yaun be ma gikwai, bekob gabu inumul itangi as nune-nggen ile be iput yaun ebe bambamo yaun ane be tis awaga be amolmol ebe emb da gitangi Pomate ok, inei gitangi sulu ok lavo gitangi as nune-nggen. ");
INSERT INTO kbm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eisir iute gikwai kob tepwengge aplos gisov dongke be es miengk gitangi Pomate be inei; “Amol Bamo. Mie gupasang gulumb tis nalk be gielk be tis gen walang ebe givang aplo givin ok. ");
INSERT INTO kbm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Warik miam Ngalau Yamar geb amei tumbungg-amei be miam amol kulkul ane Dawit avut be ei ginei, ‘Nam-nambed be amolmol ebe nangge Juda ite ok tas-vavis ve Amol Bamo, be ilgum yaun sinsin ge gipil ei? ");
INSERT INTO kbm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Be amolmol bambamo ebe emb amolmol dabin nangge nalk ok, be tis eisir bambamo subu ipil dongke be ilgum yaun ve ines Amol Bamo ane Amol ebe geb ve nemb eitit dabin ok?’ ");
INSERT INTO kbm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Bingano. Yaun etenik ano molge. Ve Herodes geb yaun be Pilata tis amolmol ebe nangge Juda ite ok be tis amolmol Israel ane iro isate sut isov nam dabe bamo etenik be ilgum yaun ve ines miam amol kulkul ane vie Yisu, ebe gob ve nemb amei dabin ok vunu. ");
INSERT INTO kbm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eisir ipil dongke ve inalgum gen tepwe ebe warik mie gunei ane yaun ge ve atob menihlang ok, be ano nile. ");
INSERT INTO kbm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Amol Bamo, galkik mie tam-nitung yaun ete eisir inei ok, be nuro am amolmol kulkul ane amei ta veik anvarkei gwang-ne be anei miam mateu. ");
INSERT INTO kbm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mie nos am gwang-ne ru nitangi amolmol be nulgum amolmol ebe tis gimat ok utlas vie vukuri. Be nulgum gen bwalbwale be tis gen bambamo subu ve am amol kulkul ane vie, Yisu ane gwang-ne.” ");
INSERT INTO kbm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eisir es miengk love ma, ok ili nam ete iro is-ate sut isov be imbweg ok gigikie be Ngalau Yamar ginme geb eisir tepwengge avut, be inei Pomate ane mateu gwang-ne ge ivang be ipelk ite. ");
INSERT INTO kbm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Amolmol ebe aplos givin Pomate ok tepwengge aplos dongke be as tas-gitung gen gile dongke-ngge. Amol ti galkik gili ane gen ginei etok ei-ate ge ane gen ok ite, ma molge. Etok ei ane gen roro bemem eisir tepwengge as gen. ");
INSERT INTO kbm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Eisir aposel ilgum kulkul gwang-ne ge ve inei Amol Bamo Yisu ane binge ebe gimdil vukuri ok. Be Pomate geb ane yaun bwaibwaya gitangi ane amolmol tepwengge. ");
INSERT INTO kbm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Be as amol ti gisut ate ve gen ti ane ite molge, ve amolmol emb as nalk tis nam be amolmol nam dani ane ivgo, ");
INSERT INTO kbm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bekob ivwat gen etok ane mone ile itak giengk eisir aposel nas. Bekob aposel imbwas mone nok gitangi amolmol ebe gen ma ve is ok. ");
INSERT INTO kbm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Givin sawa etok amol ti gibweg, amol nok are Josep be eisir aposel ital ei are ti inei Banabas. Tanro are etok vukir tanei, amol ebe ges amolmol tas ta ok. Amol nok nangge eisir vu Liwi ane nangge nusawa Saipras. ");
INSERT INTO kbm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ei geb ane nalk sawa ti be amol ti givgo bekob givwat mone nalk etok ane gile geb gitangi eisir aposel be eisir emb gitangi amolmol ebe gen ma ve is ok. ");
INSERT INTO kbm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amol ti are Ananias gabu arwe Sapaira imbweg etok. Ananias nok geb ane nalk tavlu siti be amol ti givgo. ");
INSERT INTO kbm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bemem ei gitak mone nalk etok ane tavlu giengk ve ane be arwe gili gen etok givin, be ei givwat mone tavlu-ngge gile be geb gitangi aposel. ");
INSERT INTO kbm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bekob Pita gimdil be ginei gitangi ei be ginei, “Sadam girau gile mie. Mie guyo Ngalau Yamar be gutak mone nalk etok ane tavlu giengk ve im ve ret ane? ");
INSERT INTO kbm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wat givin ebe amolmol ivgo nalk etok ite nangge ok be wat mie tam-gitung ve gunei etok mie ate ge am nalk sawa etok. Beti givin ebe mie gob nalk nok gitangi amolmol be ivgo ok ete mie tam-gitung gunei mone etok, etok mie-ate ge am gen. Be galkik mie ve numdom etenik? Be mie guyo amolmol ge ite mie guyo Pomate givin.” ");
INSERT INTO kbm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias giute yaun etok gikwai be seukie-ngge gibieg gile gitak be gimat vunu. Amolmol ebeok tepwengge iute gen etok ane binge be ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bekob amol gaptol subu ile isum ei utle ulis gisov babal be ivwat ile ispun nangge taku gimat ane. ");
INSERT INTO kbm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","As-matano sawa aitol gile gikwai kob Ananias nok arwe gile, be ei giute gen bunam etok ane binge ite. ");
INSERT INTO kbm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Be Pita giutani ei be ginei, “Yemlu uvwat mone dang-etok ge ve aim nalk sawa etok ane me?” Be ei giwel Pita avo be ginei, “Bingano mone nok etenok ge.” ");
INSERT INTO kbm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Be Pita ginei gitangi ei, “Nam-nambed be yemlu am amol uli Pomate ane Ngalau Yamar weik gen molok molok ti be ve unyo unyo ei? Ute, amol gaptol etenik ivwat arwem ile ispun beti ete ande inme ivarkei nam avo nik ve atob invwat mie nule nuvin.” ");
INSERT INTO kbm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Be seukie-ngge avie nok gibieg gile gitak nalk gibloblo Pita va be gimat vunu. Be amol gaptol nok isov ile be ili avie nok ebe ande gimat vunu be giengk ik, beti ivwat ei ile ispun gibloblo arwe. ");
INSERT INTO kbm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pomate ane amolmol-gen be tis amolmol ebeok tepwengge iute gen etok ane binge be ipelk anongge. ");
INSERT INTO kbm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Eisir aposel ilgum gen bwalbwale be tis gen bambamo walang ano molge gitangi amolmol. Be amolmol ebe aplos givin Pomate ok tepwengge iro is-ate sut isov dongke be imbweg nangge Solomon ane samwak. ");
INSERT INTO kbm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amolmol ebeok avos givwat aposel ares bemem eisir subu ipelk ve is-ate ane be inme ikasa ivin ite. ");
INSERT INTO kbm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bemem amol be avie anongge molge aplos givin Amol Bamo be ile isov ei ane amolmol-gen aplo tis as-mate walang ok. ");
INSERT INTO kbm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Be eisir nok inggas as amolmol ebe tis gimat ok giwei as yemb be ile itak giengk nam luvwe, veik Pita nitak bage niwei eisir me nivang nilek be ninme be ane dalgo ge nitav tulu ve eisir be vias vukuri. ");
INSERT INTO kbm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Be amolmol nangge nam dabe subu ebe gibloblo Jerusalem ok, inggas amolmol ebe tis gimat ok be tis eisir ebe ngalau tiate givang givin is ok be inme ge. Be amolmol ebe tis gimat walang ano ok tepwengge utlas vie vukuri. ");
INSERT INTO kbm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Beti amolmol ebe emb da gitangi Pomate ok tis as amol bamo ebe geb eisir dabin ok dubis tinas be tas-vavis anongge gitangi eisir aposel. Be emb eisir ta be ile itak is imbweg kapual-lu ivin amolmol tiate ane, amolmol da ane nok nangge Sadukai. ");
INSERT INTO kbm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bemem givin tambok, Amol Bamo ane angela ane ti gisov gile be ges nam avo kapual-lu ane ponge be gihlin eisir aposel ile ihlang, be ginei gitangi eisir be ginei; ");
INSERT INTO kbm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yem unde be unsov lum yamar aplo unde be unbul amolmol ve luev ebe ve tanambweg matawand ane ok.” ");
INSERT INTO kbm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eisir aposel iute yaun etok be isov ane lu ge, be ile isov lum yamar bamo nok aplo ile givin tistumi-ngge be emb kulkul ve inei mateu gitangi amolmol ivang. Be amolmol da ane nok tis as amol bamo ital bambamo yaun ane subu tis awaga tepwengge be inme ipil dongke, bekob emb yaun gile nam kapual-lu ane ok ve in-gas aposel inme. ");
INSERT INTO kbm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Givin ebe eisir kambam tupe imbielk nam kapual-lu ane ok, be ili aposel lavos bun. Beti ilumul ile be inei yaun gwang-ne gitangi bambamo yaun ane be inei, ");
INSERT INTO kbm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Amei ambielk nam kapual-lu ane be ali es nam avo avut love gwang-ne molge, be amolmol ebe emb nam kapual-lu ane dabin ok ivarkei nam avo walang ok avwut gitangi-ngge. Be amei as nam avo ponge be asov nam aplo ale, bemem ali amol ti gibweg ite.” ");
INSERT INTO kbm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eisir kambam tupe lum yamar ane as amol bamo be tis amolmol da ane iute dang-etok, be tas-gitung walang ano be inei, wali atob tanei yaun etek avond dang? ");
INSERT INTO kbm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Bekob amol ti gitangi eisir gile be ginei, “Unaute kob. Amolmol ebe yem utak is imbweg kapual-lu ok, ete ande ile be isov lum yamar aplo ile be imbul amolmol ivang ok.” ");
INSERT INTO kbm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Beti eisir kambam tupe nok tis as amol bamo ile be inggas aposel inme, bemem es eisir ite ve ipelk velob amolmol ines eisir vunkunu ve vat. ");
INSERT INTO kbm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Eisir kambam tupe inggas aposel ile be itak eisir ivarkei bambamo yaun ane nas. Be amol bamo ebe geb da gitangi Pomate ok giutani eisir be ginei. ");
INSERT INTO kbm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Amei as bing be anei gwang-ne molge gitangi yem be anei yem unbul Yisu ane yaun nitangi amolmol vukuri ite. Bemem ande yem umbul aim yaun etenik be amolmol tepwengge nangge Jerusalem iute love ma. Wat yem ulgum ebe veik unei nitangi amolmol be unei amei eteik ebe as Yisu vunu ok me?” ");
INSERT INTO kbm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Beti Pita tis ane sukus-gen iwel eisir avos be inei, “Amei atob anvang mul ve Pomate ge ane yaun be wat anvang mul ve amol ti ane yaun ite ma. ");
INSERT INTO kbm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yem os Yisu vunu gireu ei-givsangin gile, bemem eitit tamand-gen as Pomate ges ei itin vukuri nangge taku gimat ane, ");
INSERT INTO kbm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","be gigas ei gireu gile einggoto be gitak ei gibweg givin ane gwang-ne nangge ane taku vie givin ei-ate. Be galkik etenik ande ei weik eitit and Amol Bamo ebe ve nemb it ru ok. Veik amolmol nangge Israel inavkir dumas nitangi as gen tiate be Pomate atob ta nivalngan eisir as tiate etok. ");
INSERT INTO kbm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yaun bambamo etenik amei ali ane ano gikwai beti amei be tis Ngalau Yamar ebe Pomate geb sin-ge gitangi amolmol ebe isov ei ane yaun ane lu ge ok anei ane yaun.” ");
INSERT INTO kbm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bambamo yaun ane be tis awaga iute yaun etok love gilgum aplos tiate molge be ve ines eisir aposel vunkunu. ");
INSERT INTO kbm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bemem gidung ti ebe geb Mose ane yaun dabin ok, are Gamaliel be ei Parisai ti, be amolmol ili ei inei amol vie ti. Gamaliel nok givarkei be ginei gitangi bambamo yaun ane be tis awaga ve inemb aposel inde inahlang siti bekob. ");
INSERT INTO kbm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bekob ginei, “Yem amolmol Israel ane, yem tangg-aim itung love vie kob unalgum gen ete tangg-aim gitung ve unalgum ok nipil eisir etenik. ");
INSERT INTO kbm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yem uli, warik Tiudas gimdil be ginei, Ayeu amol gwang-ne ti, be gilgum be amolmol gitangi 400 itau ile ei. Bemem bwayage-kob amolmol es ei vunu be ane amolmol-gen ebe ivang mul ve ei ok, ipelk iriv be ira be as kulkul ete ve inalgum ok gile gisole. ");
INSERT INTO kbm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Be bwayage-kob givin ebe gavman ve niro amolmol ares ok, be Judas nangge Galilaia ei gimdil be ginei yaun gisov amolmol weik etok ge be eisir itau ile ei be ilgum ve inaitin gavman. Bemem kob amolmol es ei vunu weik etok ge, be amolmol ebe itau ile ei ok ipelk iriv be ira. ");
INSERT INTO kbm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dang-etok be ayeu nanei nitangi yem nanei, unalgum gen ti nitangi eisir etenok bwaya be nangg-aim vier ve eisir be invang. Ve ginei amolmol ge tas-nitung be inalgum kulkul etenik, atob nitangi ite. ");
INSERT INTO kbm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bemem ginei Pomate nivarkei mate ve kulkul etenik ane, atob gitangi ebe ve yem unemb eisir etenik ta ok ite. Bemem lob yem weik amolmol ebe ve ines valir nitangi Pomate ok.” ");
INSERT INTO kbm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Beti bambamo yaun ane be tis awaga iute Gamaliel avo-ngge be ital eisir aposel inme be irau is bekob es bing be inei gwang-ne ge gitangi eisir be inei eisir inbul amolmol ve Yisu are ane vukuri bwaya. ");
INSERT INTO kbm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Eisir aposel ikwai bambamo yaun ane be ile ihlang tis tas-vevias ge, ve Pomate gili ginei eisir gitangi ebe ve in-gas gen bunam ve Yisu ane kulkul ane ok. ");
INSERT INTO kbm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Be givin as-mate walang ok eisir ilgum kulkul ve inei Yisu Kilisi ane binge gitangi amolmol nangge lum yamar bambamo aplo be nangge as nam be inei Yisu ei Amol ebe ve nemb amolmol dabin ok. ");
INSERT INTO kbm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","As-mate subu gile gikwai be amolmol ebe aplos givin Yisu ok ande meihlang anongge molge. Beti amolmol ebe inei Grik avos ok, tas vavis ve eisir ebe inei Juda avos roro ok, be inei, ‘As-mate walang ok yem Juda upasang amolmol ebe gen ma ve is ok vie molge, bemem yem uli amei-mei avie gaptol ebe arwas gen imat ikwai is ok givin ite.’ ");
INSERT INTO kbm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Beti eisir aposel 12 ebok ital eisir tepwengge ile ipil dongke be inei gitangi eisir be inei, “Ginei amei bwaingg-amei ve Pomate ane yaun be analgum ve anbwas ben be gen nitangi amolmol ge, atob vie ite. ");
INSERT INTO kbm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dang-etok be yem ate unemb aim amolmol subu ebe uli eisir unei eisir gitangi, be givin ve Ngalau Yamar givang givin eisir be itpweng gen walang ok are ok nitangi 7. Veik eitit tanemb eisir etok ve inemb kulkul bwas ane dabin. ");
INSERT INTO kbm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Be amei ate atob analgum kulkul tis as-mate walang ok ve anes miengk be anbul amolmol ve Pomate ane yaun ane.” ");
INSERT INTO kbm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Amolmol tepwengge iute yaun etok be tas-vevias ge, be emb Stiven ei amol ti ebe aplo givin Pomate gwang-ne molge ok, be Ngalau Yamar geb ei avut, be Pilip gabu Prokoras, be Naikena gabu Taimon, be Pamenas gabu Nikolas. Nikolas nok ei amol Antiok ane ti, be warik ginme givang givin eisir Juda be givang mul ve Juda as luev ok. ");
INSERT INTO kbm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bekob itak eisir dubi etok ile ivarkei aposel nas bekob eisir aposel itak bais giwei eisir be es miengk giwei eisir ve in-gas Pomate ane kulkul. ");
INSERT INTO kbm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Be givin etok Pomate ane yaun givang geb taku walang ok avut, be amolmol ebe aplos givin Pomate ok meihlang bon ge nangge Jerusalem. Be amolmol ebe emb kulkul da ane ok walang ge aplos givin Pomate givin weik etok ge, be isov mateu ane lu-ngge. ");
INSERT INTO kbm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","9","Pomate geb ane yaun bwaibwaya be tis ane gwang-ne gitangi Stiven be giro ei ta be gilgum gen bwalbwale be tis gen bambamo walang ano molge. Beti amolmol lum yamar (mateu) ti ane imdil be es valir ve avos ge gitangi Stiven. Eisir etok lum yamar ti ane nangge Juda as taku, ebe ital inei amolmol ebe emb kulkul sin sin-ge ivin as amol bamo ok as lum yamar. Be eisir nok nangge Sairini, Aleksandria, be Silisia tis Esia. ");
INSERT INTO kbm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bemem Ngalau Yamar geb dabas-gwet vie gitangi Stiven be givin ebe ei ginei yaun ok, be amolmol gitangi ebe ve inambweg inwei ei ane yaun ok ite. ");
INSERT INTO kbm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Beti eisir inei yaun bingkasop gisov amolmol subu be ile inei, “Amei aute amol etenik ginei yaun ungglus ungglus gipil Mose gabu Pomate.” ");
INSERT INTO kbm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Be eisir as yaun bingkasop etok ete gilgum amolmol tepwengge tis as awaga be gidung ebe emb Mose ane yaun dabin ok aplos tiate molge. Be imdil ile emb Stiven ta bekob inggas ei itangi bambamo yaun ane ile. ");
INSERT INTO kbm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bekob ile inggas amolmol ebe ve inalgum yaun bingkasop nipil ei ok inme. Be eisir nok inei, “Amol etenik ginei yaun ungglus ungglus gipil eitit and lum yamar be tis Mose ane yaun tis as-mate walang ok be amei aute. ");
INSERT INTO kbm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Be amei aute ei ginei ti givin ginei, ‘Yisu Nasaret ane atob niaing lum yamar bamo etenik nikwai be niwel Mose ane yaun ebe warik geb gitangi eitit ok vukuri.’” ");
INSERT INTO kbm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Amolmol tepwengge ebe imbweg nam yaun ane aplo ok nas giro Stiven ta be ili ei na meng-gihlang weik ebe Pomate ane Ngalau kulkul ane ti ok. ");
INSERT INTO kbm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Be amolmol ebe emb da gitangi Pomate ok as amol bamo giutani Stiven be ginei, “Yaun ete eisir inei gipil mie ok ano me ma?” ");
INSERT INTO kbm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Be Stiven giwel amol nok avo be ginei, “Angg nune-nggen be tamanggen, unaute kob. Warik eitit tumbund Ablaham gibweg Mesopotamia ge nangge be gimdil gile Heron ite nangge. Be givin etok Pomate ges ate ru gitangi ei be ginei; ");
INSERT INTO kbm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Umdil ukwai am nalk be tis am bambamo-nggen be ule nalk ebe atob ayeu nas ru nitangi mie ok.’ ");
INSERT INTO kbm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Beti Ablaham gimdil gikwai ane taku (nalk) be gile gibweg nangge Heron. Be gideb mul ane Ablaham tame gimat vunu gikwai kob Pomate gihlin ei be gile gibweg taku ete ande galkik Israel inggas ve as nalk ok. ");
INSERT INTO kbm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pomate geb nalk sawa ti gitangi Ablaham ebe ve ninggas ve ane nalk roro ok ite ma. Bemem Pomate ginei, nindeb mulane atob ei nemb nalk etok nitangi Ablaham ei ate be tis ane vaku gen ebe asonge inme inahlang nindeb mul ane ane ok. Givin sawa etok Ablaham natu ma nangge be Pomate ginei yaun etok. ");
INSERT INTO kbm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pomate ginei gitangi Ablaham be ginei; ‘Miam vaku-nggen atob inambweg amolmol taku ti ane as nalk be nalk tivie atob in-gas miam vaku-nggen ve as amolmol kulkul ane ebe ve inemb kulkul sinsin-ge be mone ma ve is ok. Be atob nalk tivie inalgum eisir tiate tiate dang-etok nitangi Sonda bamo 400.’ ");
INSERT INTO kbm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bemem bwayage-kob atob ayeu nalgum eisir ete iaing miam vaku-nggen ok as yaun, be atob miam vaku-nggen inamdil inkwai taku etok be inme inei uye be ines miengk nitangi ayeu nangge taku etenik.’ ");
INSERT INTO kbm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Be Stiven ginei, Pomate geb yaun gwang-ne ti gitangi Ablaham, ve niure amolmol utlas ulis veik meinahlang ve Pomate ane amolmol-gen. Beti givin ebe Ablaham arwe gikuv nunus amol ti ok, be ivang love ande nunus nok ane as-mate 8 gile gikwai kob tame Ablaham giure ei utle ulis, be ital nunus nok are inei Isak. Beti Isak giure Jakob, be Jakob gilgum weik etok ge gitangi natu-nggen be eitit tumbund-gen vu 12 etok givin. ");
INSERT INTO kbm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Eitit tumbund-gen vu 12 nok tas vavis ve Josep, be emb ei gitangi amolmol nam dani be ivgo be inggas ile kob amolmol Aigipten ane ivgo ei vukuri nangge eisir, ve nemb kulkul sinsin-ge nivin amolmol Aigipten ane. Bemem Pomate givang givin ei, ");
INSERT INTO kbm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","be bage gitin gen bunam walang ok gikwai ei. Be geb ane yaun bwaibwaya be tis dabas-gwet vie gitangi ei givin ebe givarkei Palao na ok. Palao nok ei amol bamo (king) ebe geb amolmol dabin nangge Aigipten ok. Palao gili Josep ei amol vie beti geb ei ve nemb amolmol dabin nangge Aigipten, be ei geb Palao ane nam dabin givin. ");
INSERT INTO kbm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Givin etok taku bom nangge Aigipten tis Kanaan as taku, be amolmol marav-ges is giriv be gira tiate molge. Be eitit tumbund-gen as ben ma ebe ve inen ok. ");
INSERT INTO kbm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Be Jekob guite binge inei ben giengk nangge Aigipten, beti ei gihlin natu-nggen, eitit tumbund-gen be ile. ");
INSERT INTO kbm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Be as-mate ti eisir ilumul ile vukuri, be givin etok Josep ginei ate lavo gitangi kawe-nggen. Be givin etok ete Palao gitpweng Josep ane bambamo-gen are. ");
INSERT INTO kbm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep geb yaun gile ve tame Jakop bamo be tis ane dani-nggen tepwengge ve intangi ei inde ete Aigipten ok, be eisir nok gitangi 75. ");
INSERT INTO kbm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Beti Jakop gimdil be gisov gile gibweg Aigipten love gimat vunu, be eitit tumbund-gen ok imat vunu givin weik etok ge. ");
INSERT INTO kbm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Be amolmol ivwat eisir utlas ulis ile ispun nangge nalk sawa ti ebe warik Ablaham givgo nangge Hemo nantu-nggen nangge Sikem ok. ");
INSERT INTO kbm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Gen ebe warik Pomate gibiti ane yaun ge gitangi Ablaham ok gibloblo ve ano nile. Be amolmol Israel ane meihlang bamo-ngge nangge Aigipten. ");
INSERT INTO kbm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Be bwayage-kob amol bamo (king vaku) ti meng-gihlang be geb amolmol dabin nangge Aigipten, bemem ei tang-gisgil Josep. ");
INSERT INTO kbm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Amol bamo nok geb kulkul bamo molge gitangi eitit tumbund-gen be gilgum eisir tiate tiate molge. Be avo girau is ve ginei intak natus-gen ebe vasov tinas-gen ikuv is ok inyengk nam luvwe veik inmat vunkunu. ");
INSERT INTO kbm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Be givin sawa etok ete Mose tine gikuv ei, nunus nok vie molge be Pomate ta givin ei. Mose tame gabu tine emb ei dabin nangge as nam gitangi aiweng aitol. ");
INSERT INTO kbm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Be bwayage-kob emb ei gile gihlang be giengk nam luvwe. Be amol bamo (king) natu avie gili be givwat ei gile givkwen be geb dabin weik ebe natu roro ok. ");
INSERT INTO kbm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Imbul Mose ve Aigipten as mateu (luev) be tis as itpweng gen arkares ane tepwengge be ei meng-gihlang weik amol gwang-ne ti, ve yaun be kulkul ane givin. ");
INSERT INTO kbm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mose ande ane Sonda bamo gitangi 40, be ei tang-gitung ve nile be nitlek na be nili ane bambamo-nggen Israel ane. ");
INSERT INTO kbm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ei givang ve gile be gili amol Aigipten ane ti gilgum Israel amol ti tiate, beti ei geb Israel etok ru be ges Aigipten etok vunu. ");
INSERT INTO kbm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Be Mose ginei bwat atob ei-ate ane bambamo-nggen ok inatpweng are inei Pomate geb ei ve nemb eisir ru bemem ma, eisir itpweng gen etok are ite. ");
INSERT INTO