﻿USE sofia;
DROP TABLE IF EXISTS sofia.kbh_vpl;
CREATE TABLE kbh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kbh_vpl WRITE;
INSERT INTO kbh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Quemënga imnamna Jesucristbe bëts taitanga: Jesucristna Rey David y Abrahámbents̈ana ents̈á inamna. ");
INSERT INTO kbh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Abraham yojamna Isaacbe taitá; Isaacna Jacobëbe taitá y Jacob, Judá y chabe cats̈átangbe taitá. Judá, Fares y Zarabe taitá; y chatbe mamá Tamar yojamna; Fares Esrombe taitá y mua Arambe taitá. Aram Aminadabëbe taitá; Aminadab Naasonbe taitá y Naasón Salmonbe taitá. Salmón Boozbe taitá y muabe mamá Rahab yojamna; Booz Obedbe taitá y muabe mamá Rut yojamna; y Obedna Isaíbe taitá. Isaí Rey Davidbe taitá; David Salomonbe taitá y muabe mamá yojamna chë Uríasbe shema inamná. ");
INSERT INTO kbh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Salomón Roboambe taitá; Roboam Abíasbe taitá y Abíasna Asabe taitá; Asa Josafatbe taitá; Josafat Jorambe taitá y Joramna Uzíasbe taitá. Uzías Jotambe taitá, Jotam Acazbe taitá y Acazna Ezequíasbe taitá. Ezequías Manasesbe taitá; Manasés Amonbe taitá y Amón Josíasbe taitá. Josíasna Jeconías y chabe cats̈átangbe taitá yojamna. Chë Babilonioca ents̈anga chë israelitënga tmojánishëche y choca imojanëtámena ora, Josías chë básenga yojánabamna. ");
INSERT INTO kbh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Ya Babilonioca ndutámenënga ora; Jeconías Salatielbe taitá; Salatiel Zorobabelbe taitá. Zorobabel Abiudbe taitá; Abiud Eliaquimbe taitá y Eliaquimna Azorbe taitá. Azor Sadocbe taitá; Sadoc Aquimbe taitá y Aquimna Eliudbe taitá. Eliud Eleazarbe taitá; Eleazar Matanbe taitá y Matán Jacobëbe taitá. Jacob Josebe taitá yojamna y Josena Mariybe boyá. María Jesusbe mamá, Jesús chë Bëngbe Bëtsabe Uámana Uabuayaná, chë Cristo ca uabainá. ");
INSERT INTO kbh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chcasna, Abrahámbents̈ana Davidbentscoñe bnë́tsana canta bëts pamíllanga imojëftsemna. Davídbents̈ana y chë israelitënga Babilonioca imojanëtamenëntscuana inÿe bnë́tsana canta bëts pamíllanga; y inÿe bnë́tsana canta bëts pamíllanga chë Israeloca ents̈anga imojanëtamenents̈ana, chë Cristo tojanonÿnántscoñe. ");
INSERT INTO kbh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo jónÿnanamna mënts̈á tojanopasá: María tbojans̈buachená Joséftaca jobouamayama, pero cabá ndoñe cánÿiñe ibontsiyena ora, tojanopasá Mariyna ngomamaná yojoquéda chë Uámana Espíritbe obenánaca. ");
INSERT INTO kbh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, Mariybe boyá, canÿe nÿetsca soyënguiñe ts̈abá jamama bos̈á inamna. Cha ndoñe yontsebos̈e ents̈angbe delante cha mal jaquédana; chíyecna tojanjuabó nÿe iytëcana Maríybents̈ana jtsojuánañana. ");
INSERT INTO kbh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y chca yojtsejuabnantscuana, mo otjenayoquëcá canÿe Bëngbe Bëtsabe ángel tbojáninÿe y chana Josébioye tbojaniyana: “José, Davídbents̈ana ents̈á, ndoñe matenócochinÿenana Maríaftaca jobouamayama, er chë bochántsebomna s̈es̈ona chë Uámana Espíritbe obenánaca cha bochántsebomna. ");
INSERT INTO kbh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María canÿe s̈es̈ona bochántsebomna y cha Jesús ca cochjuabaye. Chca echantsabaina er cha chabe ents̈anga chëngbe bacna soyënguents̈ana echanjátsebacaye ca” —chë ángel tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lempe chca tojanochnëngo, cachcá chaotsemnama nts̈amo Bëngbe Bëtsá chabe juabna oyebuambnayëngbiajana tojanayancá. Chë oyebuambnayá mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Chë cabá boyabása nduabuatmá ngomamaná echanjoquéda y canÿe s̈es̈ona boyabásetema bochántsebomna, y cha mochanjuabaye Emanuel ca. (Emanuel endayana “Bëngbe Bëtsá bë́ngaftaca ca”.) ");
INSERT INTO kbh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José chë otjénayents̈ana tojanofs̈ená ora, tojanma nts̈amo chë Bëngbe Bëtsabe ángel tbojanmandacá y Maríaftaca tojanobouamá. ");
INSERT INTO kbh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ndoñe cánÿiñe ibontsaniyena, sinó nÿe chë s̈es̈onatema tojanonÿná orscana. Chë s̈es̈onatema tojanonÿná orna, José chábioye Jesús ca tbojanabaye. ");
INSERT INTO kbh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes judiëngbe rey yojamna ora, canÿe pueblo Judeoca, Belén ca uabáinents̈e Jesús tojanonÿná. Chents̈ana, báseftanga, estrellënga uatsjéndayënga, magos ca uabáinënga, canÿe bëts puebloye Jerusalén ca uabáinoye tmojánashjajna. Chënga tmojánabo shinÿe bocanoye luarëngocana. ");
INSERT INTO kbh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalenocna chënga, Heródesbioye tmojána y tmojanënoticiá: “¿Ndayents̈e yojtsemna chë judiëngbe rey jtsemnama tojonÿná cha ca? Bëngbe luarëngoca shinÿe bocanoye chabe onÿnana estrella fsënjinÿe y as muents̈e cha jaboadórama tifjabo ca.” ");
INSERT INTO kbh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey Herodes chca tojanuena ora, corente yojtsenócochinÿena, y nÿetsca chë Jerusalenents̈e oyenë́ngnaca. ");
INSERT INTO kbh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Chents̈ana chë rey tojánachembo nÿetsca chë judiëngbe bachnangbe amë́ndayënga y chë judiëngbe ley abuátambayënga jenoyeunayëngama. Mënts̈á tojanatjá: —¿Ndayents̈e chë Bëngbe Bëtsabe Uámana Uabuayaná, chë Cristo ca uabainá, jónÿnama ibomna ca? ");
INSERT INTO kbh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chënga tmojanjuá: —Judeoca, Belén pueblents̈e ca. Bayté entsemna chë Bëngbe Bëtsabe juabna oyebuambnayá Miqueas mënts̈á tojanábema: ");
INSERT INTO kbh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y ts̈ëngaftanga, Judeoca Belenents̈e oyenënga, canÿe mandayá ts̈ëngaftangbents̈ana echanjabo. Cha nÿetsca chë Judeoca mándayëngbiama más uamaná echántsemna, y ats̈be ents̈anga Israeloca echántsanÿena. Chíyeca ts̈ëngaftangbe pueblo ndoñe nÿe bats̈á uámana pueblo quenátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chora Herodes iytëcana chë maguënga tojánachembo y cuedádoca tojanatjá ntseco ora chë estrella tmojáninÿama. ");
INSERT INTO kbh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herodes chë soyënga yojtsetáts̈ëmbo ora, Belenoye chë maguënga tojanichamó, y mënts̈á tojanë́yana: “Choye motsajna y ts̈abá chë s̈es̈ona s̈mochjánguango. Chas̈mojínÿena ora, s̈mochjabëuenaye, as áts̈naca chayobená jama chë s̈es̈ona jadórama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rey Herodes chë soyënga tojánëyanents̈ana, chë maguënga tmojtsatanoñe. Chora cachiñe tmojtaninÿe chë chëngbe luarëngoca tmojáninÿe estrella y yojtsanebnatsana chë s̈es̈ona yojtsemnë́ntscoñe. Chents̈a juatsbuacá chë estrella yojójayiye. ");
INSERT INTO kbh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Chë maguënga chë estrella tmojáninÿe orna, corente oyejuayënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chë yebnoye tmojánamashjna ora, chë s̈es̈ona tmojáninÿe chabe mamá Maríaftaca. Chorna, tmojanoshaments̈é y chë s̈es̈onatema tmojanadorá. Chora chëngbe cajontémënga tmojanëtsë́caca y tmojanats̈tá castellano, incienso y canÿe botamana uanguëts̈e soye, mirra ca uabáiniye. ");
INSERT INTO kbh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chents̈ana, mo canÿe otjenayoquëcá Bëngbe Bëtsá chë maguënga tojanabuayená rey Herodesbiajana ndoñe chamondesshëcuanama. As chënga chents̈ana inÿe benachëjana cachëngbe luarëngoye tmojésanshëcuana. ");
INSERT INTO kbh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chë maguënga tmojtsatanoñe ora, otjénayoca José canÿe Bëngbe Bëtsabe ángelbioye tbojáninÿe y cha mënts̈á tbojaniyana: “Motsbaná, chë s̈es̈onatema y chabe mamá mesë́biats̈e y Egiptoye motsachá. Herodes chë s̈es̈onatema bochanjánguango jtsóbama, chíyeca choca cochtsoquedañe ats̈e chacbochjábuayenantscuana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","As José tojantsbaná, chë s̈es̈onatema y chabe mamá tojesanë́biats̈e y ibeta Egiptó benache tojë́ftsanbocna. ");
INSERT INTO kbh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Y choca imojtsanomñe Herodes tojanóbanëntscuana. Chca tojanopasá, cachcá chaotsemnama nts̈amo Bëngbe Bëtsá chabe juabna oyebuambnayabiajana tojanayancá. Chë oyebuambnayá mënts̈á tojánayana: “Egiptocana ats̈be uaquiñá sënjanchembo ca.” ");
INSERT INTO kbh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Chë maguënga tmojtsaningñema Herodes tojántats̈ëmbona ora, puerte tbojánetna, y tojanmandá lempe jtsëbáyama base boyabásetemënga uta uata bomnënga y cabá uta uata ndbomnënga, Belén y chë juachañe pueblënguents̈ënga. Uta uatama cha tojanjuabó, er uta uata yojtsemna chë maguënga chë estrella tmojáninÿama. ");
INSERT INTO kbh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Jeremías tojanoyebuambacá, cachcá tojanochnëngo: ");
INSERT INTO kbh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá ca uabaina pueblents̈e canÿe oyebuambnayana tmojanuena, ngménaca os̈achiyana y becá tsets̈anánaca oyebuambnayana. Raquel yojamna chabe básengbiama os̈achiyiñe, pero ndoñe yontsebos̈e chamuatebiajuama, chabe básenga ya obanënga causa ca —cha tojanábema. ");
INSERT INTO kbh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","José cabá Egiptoca yojtsomñe ora, Herodes tojanóbana. Chents̈ana, otjénayoca José canÿe Bëngbe Bëtsabe ángelbioye tbojáninÿe y cha mënts̈á tbojaniyana: ");
INSERT INTO kbh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Motsbaná, chë s̈es̈onatema y chabe mamá mesë́biats̈e y Israeloye cochtá. Chë s̈es̈onatema jóbama bos̈ënga ya obanënga montsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","As José tojantsbaná y chë s̈es̈onatema y chabe mamá Israel luaroye tojtésanëbiats̈e. ");
INSERT INTO kbh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arquelao Judeoca yojanmánda chabe taitá Heródesbe cuentiñe, y José chca tojántats̈ëmbona orna, yojtsauatja choye jama. Pero otjénayoca Bëngbe Bëtsá Josébioye tbojanbuayená; chíyeca Josena Galilea ca uabaina luaroye tojána. ");
INSERT INTO kbh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Choye tojánashjango ora, José tojána canÿe pueblo Nazaret ca uabáinoye chents̈e joyénanama. Chca tojanochnëngo cachcá chaotsemnama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayënga tmojanayancá. Chënga tmojánayana: “Nazaretocá ca Jesús mochantsábobaina ca.” ");
INSERT INTO kbh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chë tempo, Juan chë Ubayaná, ents̈anga ndoyena luaroye Judeoca tojánbocna, Bëngbe Bëtsabe soyëngama jábuayenama. ");
INSERT INTO kbh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mënts̈á cha yojanëtsëtsnaye: “Bëngbe Bëtsabe amë́ndayana ya echanjóshjango. Ngménaca s̈mochtenójuaboye ts̈ëngaftangbe bacna soyëngama y chca amana s̈mochtsajbaná y Bëngbe Bëtsabe benache s̈mochtishache ca.” ");
INSERT INTO kbh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan yojamna canÿa ndabiama chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías mënts̈á tojánayana: Ents̈anga ndoyena luaroca canÿa enduáyebuache: “Bëngbe Utabná echanjabo ca; mo nda canÿe benache tojtseprontacá canÿe uámana ents̈á jashjanguama, ts̈ëngaftángnaca cachcá, Bëngbe Utabná jabama ainaniñe ts̈abe juabnë́ngaca s̈mochtseprontana ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanbe ents̈ayá inauapormana camellbe stjënasheca y bobache yojanasnana. Cha inasaye chapulinatémënga y tjoca tjouangbe méloye. ");
INSERT INTO kbh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalenoca ents̈anga, nÿetsca Judea luarents̈a ents̈anga y chë Jordán ca uabaina béjaye béconana oyenënga imojánbocana Juan joyeunayama. ");
INSERT INTO kbh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bëngbe Bëtsábioye chëngbe bacna soyëngama jaimpáda chents̈ana, Juan chë Jordán béjayiñe chënga yojanëbáyana. ");
INSERT INTO kbh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero Juan tojáninÿe ba fariseunga y saduceunga cha chaubáyama tmojánama. Chënga imojamna chë judië́ngbeñe uánatsanënga Bëngbe Bëtsá ndoñe corente ntseyeunanama; as chora tojanë́yana: “¡Mëts̈cuaye ents̈anga! ¿Nda tcmënjáuyana chë echanjóshjango uabouana castigüents̈ana s̈mochjotsbocá ca? ");
INSERT INTO kbh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bëngbe Bëtsábeñe ndegombre os̈buáchiyënga s̈mochtsemna, as chca chaotsinÿna chë bacna soyënga amana ts̈ëngaftanga ndegombre s̈mojtsajbanama. ");
INSERT INTO kbh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Y ndoñe s̈mattsejuabnaye cach ts̈ëngaftangbiama jayanama: ‘Abrahámbents̈ana ents̈anga fsëndmëna ca’. Er ats̈e s̈cuayana, Bëngbe Bëtsá quem ndëts̈béngacnaca Abrahámbents̈ana ents̈anga nanjábiama. ");
INSERT INTO kbh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chë tats̈nía ya entsaprontana chë betiyeshënga tbëtëjëngocana jtseshatë́tsets̈ama. Ndaye betiye ndoñe tontseshajo, jtseshatëts̈ana y iñoye jtsatmets̈ana. Ts̈ëngaftangaftácnaca cachcá, ts̈abe soyënga ndoñe s̈montsamëse, Bëngbe Bëtsá cmochanjácastigaye. ");
INSERT INTO kbh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ndegombre, ats̈na béjayeca cbondubáyana Bëngbe Bëtsabe benache chas̈muatishachama. Pero chë ats̈be ústonoye echanjabá, ats̈biama más obenana bomná comna, y ats̈e merecido taitsatobuajoñe ni mo chabe shecochëtjonëshe jtsámbañama. Chë chabe benache aíñe chamojtishachëngbiama Bëngbe Bëtsá echanjama chë echanjabábeyeca, chë Uámana Espíritu chëngbe ainaniñe cháuamashënguama. Pero chë benache ndoñe chamontishachëngbiamna, Bëngbe Bëtsá echanjama chë echanjabábeyeca, corente castigánënga chamotsemnama, mo iñeshequëcá. ");
INSERT INTO kbh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Canÿe ents̈á chabe mëts̈tá cucuats̈iñe jiyëbana, chabe trigo jtsóbobemana y chë ndoservena shácuanënga jtsejashtsëtsana. Chabe trigo chë grano uaquëcjnaye tsañe jtsabuájuana, y chë ndoservena shácuanëngna iñoye jtsatmets̈ana. Cachcá, chë ats̈be ústonoye echanjabana, chë ts̈abe ents̈anga echanjúbuaja, y chë bacna ents̈angna canÿe íñeshiñe echantsacastígaye, y chë iñe ndocna te queochátsfsana ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","As Jesús, Galileocana tojána Jordán béjayoye, Juan yojtsemnoye, cha chabuábayama. ");
INSERT INTO kbh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan ndoñe yontsebos̈e Jesús juabáyama, y mënts̈á tbojaniyana: —Ats̈e s̈ontsemna aca chas̈cuabaye, y ¿más ats̈e aca cbochjuabaye ca? ");
INSERT INTO kbh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Chora Jesús tbojanjuá: —Morna chca chaotsemna. Entsemna lempe nts̈amo Bëngbe Bëtsá tojamandacá jobedésana ca. As Juan yojouena Jesús juabáyama. ");
INSERT INTO kbh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús ya uabainá yojtsemna ora, chë buyeshoicana tojtanshë́bëbocna. Chorna Jesús tsbanánoye yojontjes̈iye y tojáninÿe chë celoca atëfjniñe y chë Uámana Espíritu mo canÿe palomatemcá chábioye yojtsastjajuana. ");
INSERT INTO kbh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chora celocana Bëngbe Bëtsá mënts̈á tojánayana: “Mua ats̈be bonshana uaquiñá endmëna. Chabiama corente sëntsoyejuá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chents̈ana chë Uámana Espíritu ents̈anga ndoyena luaroye Jesús tbojanánatse, as Satanás chauábama cha jisháchichiyama. ");
INSERT INTO kbh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chents̈e canta bnë́tsana te y canta bnë́tsana ibeta ntjascá tbojanjétana; chíyeca chora tbojaneshë́ntsena. ");
INSERT INTO kbh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","As Satanás tbojanobobeconá y tbojaniyana: —Aca ndegombre Bëngbe Bëtsabe Uaquiñá tcomnëse, momandá quem ndëts̈benga tandës̈e chaobiama ca. ");
INSERT INTO kbh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesús tbojanjuá: —Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Ents̈á nÿe tandë́s̈eca ndoñe vida ntsebomnana, sinó ents̈á endobena jtsiyenana lempe nts̈amo Bëngbe Bëtsá tojayancá tbojtseyeunanëse ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chents̈ana Satanás, Jerusalén, chë uámana bëts pueblo ca uabáinoye Jesús tbojanánatse, y chë Bëngbe Bëtsabe bëts yebnents̈e chë más tsbanánoca tbojanatsá. ");
INSERT INTO kbh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chents̈e Satanás mënts̈á tbojaniyana: —Aca ndegombre Bëngbe Bëtsabe Uaquiñá tcomnëse, muents̈ana fshantsoye montsënja, er Bëngbe Bëtsabe uabemana palabrënguiñe endayana: Bëngbe Bëtsá chabe angelënga echanjichamuá, chacmotsinÿenama. Chënga buacuats̈ë́ngaca cmochanjishache, shecuats̈e ndëts̈beñe ndocá chacondomama ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Chora Jesús tbojanjuá: —Cach Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Ndoñe matsbos̈ana acbe Bëtsá chë Utabná bacna soyëngama jacochënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Cabana, Satanás tbojanánatse canÿe bëts tjoye y betsco nÿetsca quem luarents̈a amëndayëngbenache y chents̈a nÿetsca uámana soyënga Jesúsbioye tbojaninÿinÿé. ");
INSERT INTO kbh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","As Satanás tbojaniyana: —Aca chacojoshëntsaments̈é y chas̈cojadorase, lempe chë soyënga cbochjats̈taye ca. ");
INSERT INTO kbh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Y Jesús tbojanjuá: —¡Satanás, áts̈bents̈ana mojuaná! Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Bëngbe Bëtsá cochtsadorana y nÿe cha cochtseservena ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","As Satanás cachcá tbojanonÿá. Cachora Bëngbe Bëtsábiocana angelotémënga tmojánabo Jesús jtseservénama. ");
INSERT INTO kbh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan chë Ubayaná cárceloye tmojanëtámiama Jesús tojanuena ora, Galilea luaroye cha tojtaná. ");
INSERT INTO kbh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero ndoñe tonjanoquedá Nazaret pueblents̈e, sinó Capernaumoca, uafjajónaye tsachañe; choye tojána joyénanama, chë uámana bëts taitata Zabulón y Neftalibe luariñe. ");
INSERT INTO kbh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chca tojanochnëngo, cachcá chaotsemnama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías tojanayancá. Isaías tojánayana: ");
INSERT INTO kbh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón y Neftalibe luare, Jordán béjaye chenguánoica, uafjajónaye tsachañe; Galilea luariñe, ndoñe judío ents̈anga oyenents̈e. ");
INSERT INTO kbh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chë mo ibetiñe cuaftsiyencá imojoyena ents̈anga, Bëngbe Bëtsabe soyënga nduabuatma causa, tmojinÿe canÿa ents̈angbe juabnënga binÿnayá. Chë chëngbe juabnënga binÿnayá entsebuashinÿinÿana chë Bëngbe Bëtsábioye nduabuatmëngbiama, y chë causa chabiama imomna mo obanëngcá, ndoñe binÿniñe jtsiyenëse ca —cha tojanábema. ");
INSERT INTO kbh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cach orscana Jesús tojanonts̈é ents̈anga jábuayenama: “Bëngbe Bëtsabe amë́ndayana ya echanjóshjango. Ngménaca s̈mochtenójuaboye ts̈ëngaftangbe bacna soyëngama y chca amana s̈mochtsajbaná ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Canÿe te, Jesús chë Galilea uafjajónaye tsachajana yojtsaye y ndeolpe uta boyabásata tojanÿe: canÿa yojamna Simón, chë Pedro cánaca uabainá, y chabe uabentsá Andrés. Chatna atarraiëshangá ibnetsashbuétsets̈añe, er beonga ashebuánayata ibnamna. ");
INSERT INTO kbh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús tojanë́yana: “Ats̈eftaca mabata; ats̈e cbochanjábiama Bëngbe Bëtsabiama ents̈anga anguayata, y morscana nÿe beonga ashebuánayata ya ndoñe ques̈ochátsmëna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Cachora chatbe atarraiëshangá cachcá tbojésanaboshjuana y Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Y más chcoye, Jesús inÿe uta cats̈átata tojánanÿe: Santiago y Juan, chë Zebedeobe uaquiñata. Chata ibojtsomñe canÿe barquë́shañe, chatbe taitáftaca, chëngbe atarraiëshangá atapórmayiñe. Jesús tojánachembo, ");
INSERT INTO kbh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","y cachora chë barquë́sha tbojésanaboshjona, chë taitá cachents̈e imojéseboshjona y Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús nÿets Galilea luarëjana yojánana, chents̈e judiëngbe enefjuana yebnënguenache abuátambaye. Chë ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama ents̈anga yojanabuayiyná y nÿetsca s̈ocanëngama y tsets̈anëngama yojánashnaye. ");
INSERT INTO kbh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nÿets Siria luarëjana ents̈anga cha imojtsebáyana. As ents̈anga nÿetsca s̈ocana bomnënga Jesúsbioye imojtsënachaye: s̈oquënga y tsets̈anana bomnënga, bacna bayëjbe juabna uambayënga, ataque osháchichanënga y jama ndobenënga. Jesús nÿetscanga yojánashnaye. ");
INSERT INTO kbh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mallajta ents̈anga Galileocana, Decápolis luarocana, Jerusalenocana, Judeocana y chë Jordán béjaye chenguanoicana Jesús imojústona. ");
INSERT INTO kbh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús chë mallajta ents̈anga tojánanÿe ora, batsjoye tojántsjua y tojanótbema. Chabe ústonënga tmojanobobeconá y ");
INSERT INTO kbh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús tojanonts̈é mënts̈á jabuátambana: ");
INSERT INTO kbh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Puerte oyejuayënga mochántsemna chë Bëngbe Bëtsabe soyënga ts̈a imuajaboto ca juabnayënga. Chca ents̈anga mochántsemna chë Bëngbe Bëtsabe amë́ndayoca mochtsiyenënga. ");
INSERT INTO kbh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Puerte oyejuayënga mochántsemna chë mondbétsos̈achiyënga; chënga Bëngbe Bëtsá entsëjabuáchana ngménaca ndoñe chamondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Puerte oyejuayënga mochántsemna chë uámanënga ndoñe mondbétsenobiamnayënga, er chënga mo chëngbe otocana soycá quem luare mochanjóyëngacñe. ");
INSERT INTO kbh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Puerte oyejuayënga mochántsemna chë nÿetsca soyënguiñe ts̈abá jamama bos̈ënga. Chëngbe bos̈ana entsemna mo chë oshëntsiyá y uajuendayabe bos̈ancá. Chë nÿetsca soyënguiñe ts̈abá jamama bos̈ënga mochanjobenaye jëftsinÿana lempe nts̈amo tmojtsebos̈cá. ");
INSERT INTO kbh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Puerte oyejuayënga mochántsemna chë ínÿengbiama ongmiayënga, er Bëngbe Bëtsá chëngbiama bochanjóngmia. ");
INSERT INTO kbh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Puerte oyejuayënga mochántsemna chë nÿe ts̈abe juabnënga ainaniñe bomnënga; chënga Bëngbe Bëtsá mochanjinÿe. ");
INSERT INTO kbh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Puerte oyejuayënga mochántsemna chë nÿetscanga natjë́mbana chamotsiyenama amënga, er chënga Bëngbe Bëtsabe básenga ca mochantsabaina. ");
INSERT INTO kbh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Puerte oyejuayënga mochántsemna chë ínÿenga tmojama chamotsesufrínënga, nts̈amo Bëngbe Bëtsá yobos̈cá bétsamama; chca ents̈anga mochántsemna chë Bëngbe Bëtsabe amë́ndayoca mochtsiyenënga. ");
INSERT INTO kbh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Puerte oyejuayënga ts̈ëngaftanga s̈mochtsemna, ents̈anga chacmojoyánguango y chacmojtsë́camena ora y nÿetscna soyë́ngaca chacmojtsëbuayatsenaye ora, ats̈be ústonënga bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Móyejuanga, puerte móyejuanga, ts̈ëngaftanga celoca becá s̈mochanjóyëngacñe. Er nts̈amo ents̈anga ts̈ëngaftanga cmë́camena, cachcá chë Bëngbe Bëtsabe juabna oyebuambnayë́ngbioye, chë ts̈ëngaftangbe natsana monjaniyenë́ngbioye ents̈anga monjanë́camena ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ts̈ëngaftanga, quem luarents̈a ents̈anga jtsëjabuáchanëse s̈mojtsiyena, Bëngbe Bëtsabe soyënga chamotsetats̈ëmbuama, as chëngbiama s̈mochántsemna mo chë mënts̈ena ndoñe chaondóndbemama tcojatboto tamocá. Pero chë tamó fténana tojtsóbemëse, ndoñe ntsopodénana tempcá sanana cachiñe jtëtsmënana. Chca, ya tondayama ntsoservénana; chíyeca chë tamó tsáshenoye jtsëts̈enana y ents̈anga jtsebotájayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ts̈ëngaftanga, nts̈amo ts̈abá yomncá s̈mojtsiyenëse, as quem luarents̈a ents̈angbiama s̈mochántsemna mo chë ibetiñe tojtsebínÿna soycá. Canÿe bëts pueblo batsjo juatsbuañe tomnëse, ndoñe ntsopodénana iytëmencá jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Canÿe uajuinÿanë́sha tcojuajuínÿena ora, ndoñe cajonëshe tajsoye jtsabuájuama, sinó tsbanánoca juajájuama, chca, nÿetsca ents̈anga chë yebnents̈e tmojtsemnëngbiama chaotsebínÿnama. ");
INSERT INTO kbh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cachcá ts̈ëngaftanga, ents̈angbe delante mo binÿnayëngcá s̈mochtsemna, as chënga ts̈ëngaftanga ts̈abe soyënga s̈muamama chamuinÿama, y chca, chënga chamuinÿanÿé chë Taitá, Bëngbe Bëtsá celoca endmëná, corente uamaná y obená bétsemnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ndoñe s̈mattsejuabnaye, nts̈amo Moisesbe leyiñe iuayancá y chë Bëngbe Bëtsabe juabna oyebuambnayënga tmojanayancá jabétsepochocama ats̈e tijabo ca. Ats̈e ndoñe chiyátabo chë soyënga jabétsepochocama, sinó jabábuayenama ndayá chë soyënga ndegombre bétsayanama. ");
INSERT INTO kbh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndegombre s̈cuayana: Celoca y quem luare chaojëftsemnëntscuana, ndocná queochatobenaye ni canÿe punto, ni canÿe letra chë leyënguents̈ana jtsejuánana, lempe nts̈amo jochnënguama yomncá chaojtsemnëntscuana. ");
INSERT INTO kbh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chíyeca, nda nÿe mo canÿe mando chë leyënguiñe ndoñe tonjoyeuná cha, masque nÿe base soye chë mando tojtsemna, y chë ínÿenga cachcá tojtsabuatambá, cha Bëngbe Bëtsabe amë́ndayoca chë más nduamaná echántsemna. Pero ndëmuanÿenga tmojtsama nts̈amo Bëngbe Bëtsá tojamëndacá y chë ínÿenga cachcá chamotsamama tmojtsabuátambase, chënga Bëngbe Bëtsabe amë́ndayoca uámanënga mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chë soyëngamna mënts̈á s̈cuayana: Ts̈ëngaftanga chë ley abuátambayënga y fariseúngbioye ndoñe s̈montsayënjanase, jtsamama nts̈amo Bëngbe Bëtsá tcmojamëndacá, ndocna te Bëngbe Bëtsabe amë́ndayoye ques̈mochátamashjna. ");
INSERT INTO kbh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ts̈ëngaftanga s̈mojouena nts̈amo Bëngbe Bëtsá ts̈ëngaftangbe bëts taitanga tojanamëndacá: ‘Ndoñe catjóba ca. Chca ochjajnayá bontsemna jobuambayana chë ents̈angbiama ts̈abá o ndoñe ts̈abá tmonjamama endbayanabe delante, ndáyeca chca ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero ats̈e s̈cuayana, nda cachabe cats̈átaftaca tbojetna, chánaca bontsemna jobuambayana chë ents̈angbiama ts̈abá o ndoñe ts̈abá tmonjamama endbayanabe delante, ndáyeca chca ca. Nda cachabe cats̈átbioye puerte tbojtsáboyënja, cha bontsemna chë Sanedrín ca uabaina mándayëngbe delante jobuambayana ndáyeca chca ca; y nda cachabe cats̈atbiama opjema ca tojayana, nts̈amo cha bétsamama, cha bontsemna chë infiernoca íñeshoye jama. ");
INSERT INTO kbh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Chíyeca, nderado ndayá Bëngbe Bëtsabe bëts yebnoye tcojuamba Bëngbe Bëtsá jëtschuayama y chora tcojenojuabó acbe cats̈ata ácaftaca etonaná yojtsemna ca, ");
INSERT INTO kbh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","as chë tcojiyëbo soye chë altarents̈a natsanoica cochjéseboshjona, cochtá y acbe cats̈átaftaca cochtenoyántsia. Chents̈ana cocayé altaroye cochjá y chë tcojuamba sóyeca Bëngbe Bëtsá cochjëtschuaye. ");
INSERT INTO kbh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nderado nda tcmojademandá y cabildoye jotsánama cmojtsemna, cabá choye ndáshjango ora, betsco cháftaca cochtenoyántsia. Chca ndóñese, chë demandayá mandádbioye cmochanjúshjango, chë mandado josticiëngbe cucuats̈iñe cmochanjáboshjona y chënga cárceloye cmochanjutame. ");
INSERT INTO kbh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ndegombre cbëyana: Chents̈ana ndoñe quecochtë́tsbocna lempe candesopagantscuana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ts̈ëngaftanga s̈mojouena nts̈amo Bëngbe Bëtsá tojanmandacá: ‘Acbe boyá o acbe shémbioye ínÿaftaca ndoñe catjaíngña.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero ats̈e cbë́yana: Nderado canÿe boyabása ndëmuanÿe shembásabioye tbojinÿe y tojajuabó ‘malaye cha ca’, chë boyabása chca tojajuabose, ainanoca ya chë inÿe shembásaftaca cachabe shémbioye tbojtseingñé. ");
INSERT INTO kbh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Chíyeca, nderado acbe cats̈bioica bomínÿeca bacna soye tcojinÿe y cachca soye tcojamëse, más ts̈abá nántsemna chë bominÿe cochtsenobuchjatsëca y cochtsë́ts̈ena. Nÿets cuerpo jtsebomnana y lémpeca infiernoye jama chacmotsë́ts̈enamna, acbiama más ts̈abá nántsemna nÿe canÿe soye acbe cuerpents̈ana chacoperdé. ");
INSERT INTO kbh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nderado acbe cats̈bioica cucuáts̈eca bacna soye tcojamëse, más ts̈abá nántsemna chë cucuats̈e cochtsenástjango y cochtsë́ts̈ena. Nÿets cuerpo jtsebomnana y lémpeca infiernoye chacmotsë́ts̈enamna, acbiama más ts̈abá nántsemna nÿe canÿe soye acbe cuerpents̈ana chacoperdé ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mënts̈ánaca leyiñe enduábemana: ‘Ndëmuanÿe boyá chabe shémaftaca tbojtsenë́ts̈ena, chë boyá bontsemna chabe shema canÿe tsbuanácha juiyiyana, ndayë́chañe chaotsayana cha ya ndoñe chabe shema yontsemna ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero ats̈e cbë́yana: Nda chabe shémaftaca tbojtsenë́ts̈ena y chca tojopasá ndoñe chë shema ínÿaftaca tbontseingñé causa, as chë boyá jtsamana cha chabotseingñema, chë shema ínÿaftaca tojtóbouamase. Y nda chë úts̈ena shémaftaca tojtobouamá, chana canÿe uabuatmá jtsebomnana, y chca, chë tsëm boyánaca canÿe bacna soye jamana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ts̈ëngaftanga s̈mojouena nts̈amo ts̈ëngaftangbe bëts taitángbioye tmojanëyancá: ‘Nderado tcojayana: De Dios chë soye chanjama ca; ojal chë soye ndoñe catjama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ats̈e cbë́yana: Tondayama s̈mattsejúraye; ni celocama, er choca Bëngbe Bëtsabe tbemaniñe endmëna. ");
INSERT INTO kbh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni quem luarama, er Bëngbe Bëtsabiama mo ts̈enëtemcá endmëna, chiñe chabe shecuats̈ënga jacjayama; ni Jerusalenama, er chë pueblo endmëna Bëngbe Bëtsá chë Bëts Reybe bëts pueblo. ");
INSERT INTO kbh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni ts̈ëngaftangbe bests̈as̈ama cach ndoñe, er ts̈ëngaftanga ndoñe ques̈mátobena ni mo canÿe stjënashe ftsenguëshe o fjantsëshe jabemana. ");
INSERT INTO kbh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ts̈ëngaftanga aíñe ca jayanama s̈mojtsebos̈ëse, nÿe aíñe ca s̈mochjayana, y ndoñe casna nÿe ndoñe. Ndayá chents̈ana más s̈mojatichamo soye, Satanásbiocana jtsóbocanana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ts̈ëngaftanga s̈mojouena nts̈amo ts̈ëngaftangbe bëts taitángbioye tmojanëyancá: ‘Nderado nda tcmojtsebuchjatsëca, ácnaca derecho contsebomna canÿebé cha jëtsbuchjátsëcama ca; y nderado nda canÿe juatsas̈e tcmojtsás̈iye, ácnaca derecho contsebomna cánÿës̈e cha jtas̈iyama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero ats̈e cbë́yana: Ndoñe matsbos̈ana chë ndayánaca tcmojaborlábioye jtachnë́nguama; chamna, ndánaca cats̈bioica tcmojajuebjants̈etase, cochjomiye chë ínÿoica cachcá chacmomama. ");
INSERT INTO kbh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nderado nda tcmojademandá y tojtsebos̈e acbe shabuanguanë́jua jtsabocñama, cha molesenciá acbe quëfsaíyanaca chauetsácñama. ");
INSERT INTO kbh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nderado nda tcmojuasmá y tcmojamandá bnë́tsana cuadroca juyambama, inÿe bnë́tsana cuadra cochjuyamba. ");
INSERT INTO kbh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nda ndaye soye tcmojotjañëse, cochjats̈taye; y nda ndaye soye tcmojuátjase, cha ndoñe stëts̈oye catjaquéda ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ts̈ëngaftanga s̈mojouena nts̈amo ts̈ëngaftangbe bëts taitángbioye tmojanëyancá: ‘Acbe amigo cochtsebobonshana y acbe uayayá cochtsaboyënja ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero ats̈e cbë́yana: Ts̈ëngaftangbe uayayënga s̈mochtsababuánÿeshana, y chë cmë́camenëngbiama Bëngbe Bëtsá s̈mochtseimpadana. ");
INSERT INTO kbh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chca ts̈ëngaftanga, chë Taitá, Bëngbe Bëtsá, chë celoca endmënabe básenga s̈mochántsemna; Bëngbe Bëtsá endbétsama ts̈abe y bacna ents̈ángbeñe chabe shinÿe chaotsebinÿnayama, y endbétsama chë nÿetsca soyënguiñe ts̈abá jamama bos̈ënga y ndoñe chca ents̈ángbeñe chauaftema. ");
INSERT INTO kbh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ts̈ëngaftanga nÿe chë ts̈ëngaftanga tcmojtsababuánÿeshanënga s̈mojtsababuánÿeshanëse, ¿Bëngbe Bëtsábiocana ndayá s̈mochjuacaná? Romocama crocénana ents̈ángbioye atjanayë́ngnaca chca monduamana. ");
INSERT INTO kbh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y nÿe chë amiguë́ngbioye s̈mojtsacheuanase, ¿ndaye bëts soye s̈mojtsama? Chë ndoñe judië́ngnaca chca mondbétsama. ");
INSERT INTO kbh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ts̈ëngaftangbe Taitá, Bëngbe Bëtsá celoca endmëná, nÿetsca ts̈abe soyënga bomná y amá endmëna. Ts̈ëngaftángnaca cachcá s̈mochtsemna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Cuedado s̈mochtsebomna ndoñe ntsamama ents̈ángbeñe ts̈ëngaftangbe ts̈abe soyënga, nÿe chënga chca chamuinÿama. Chca s̈mojamëse, ts̈ëngaftangbe Taitá, Bëngbe Bëtsá, celoca endmëná ndocna uacanana soye quecmochtë́tats̈ataye. ");
INSERT INTO kbh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Chcasna, nderado nda caridá tcojábemëse, chca ndoñe s̈matjama chë nts̈amo s̈mojtsamama nÿetscanga chamotsetats̈ëmbuama, mo canÿe trompetë́fjua cuaftsajatëtancá, chë caridá s̈mojábemama chaotsótats̈ëmbuama; chca monduamana chë bacna ents̈anga chë nts̈amo ndegombre tmojuabnacá ndinÿinÿnayënga, chë judiëngbe enefjuana yebnënguenache y tsáshenañe. Ndegombre cbë́yana, chë chca amënga ya chëngbe uacanana soye tmojóyëngacñe, nts̈amo chënga tmojamama ents̈anga ts̈abá chëngbiama tmojtsoyebuambná ora. ");
INSERT INTO kbh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chcasna, nda caridá tcojábema ora, ndocná más chaondë́tsetats̈ëmbo, mo chë uañicuayoica cucuats̈e ndoñe queondbatstats̈ëmbcá ndayá chë cats̈bioica cucuats̈e tojtsamama, ");
INSERT INTO kbh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","chca, acbe caridá iytëcana chaotsemnama. As, ts̈ëngaftangbe Taitá, nda bominÿe endbétsequëcjnaye chë iytëmencá tcojtsama soye, acbe uacanana soye cmochántats̈taye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bëngbe Bëtsáftaca s̈mojtsencuénta ora, ndoñe s̈mattsama chë bacna ents̈anga nts̈amo ndegombre tmojuabnacá ndinÿinÿnayëngcá. Chënga corente jtsogusetánana chë judiëngbe enefjuana yebnënguenache tsanana y tsashená tsëntsaca Bëngbe Bëtsáftaca jtsencuéntayana, chca, nÿe ents̈anga chë soye chamuinÿama. Ndegombre s̈cuayana: chënga nÿe morscama ya montsábouacanana, chënga ts̈abá imojtsama ca ents̈anga tmojayana ora. ");
INSERT INTO kbh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero aca Bëngbe Bëtsáftaca jencuéntama orna, acbe tsoye cochtamáshëngo, bës̈ás̈a cochtatame y cháftaca cochjencuénta. Chánaca chë iytë́menents̈e ácaftaca echántsemna. Bëngbe Taitá lempe bominÿe endetsequëcjná, masque cánÿenga s̈mojtsemna ora s̈mojtsama soyë́ngnaca. As Bëngbe Bëtsá, chca cháftaca chacojtsencuénta ora, cachá acbe uacanana soye cmochántats̈taye. ");
INSERT INTO kbh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bëngbe Bëtsáftaca s̈mojtsencuénta ora, ndoñe nÿe cachcá ndoservena palabrënga ba soye s̈mattsichamo. Chca mondbétsama chë Bëngbe Bëtsábioye nduabuátmënga. Chënga jtsejuabnayana becá chca tmojtsichámësna, Bëngbe Bëtsá chënga más yochjóyaunaye ca. ");
INSERT INTO kbh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ndoñe chëngcá s̈mattsemna. Cabá nduyana ora, Bëngbe Bëtsá ya jtsetats̈ëmbuana nts̈amo ts̈ëngaftanga cmojtsëjabotcá. ");
INSERT INTO kbh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chamna ts̈ëngaftanga mënts̈á cmontsë́tocana Bëngbe Bëtsáftaca jencuéntana: Bëngbe Taitá, celoca icotsomñe. Acbe uabaina chë más uámana uabainana chauesomñe. ");
INSERT INTO kbh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Acbe amë́ndayana chaóshjango. Celoca yojtsemna nts̈amo icobos̈cá; quem luaríñnaca cachcá chaotsemna. ");
INSERT INTO kbh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mënté s̈miyats̈atá cada te s̈netsëjaboto tandës̈e. ");
INSERT INTO kbh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bacna soyënga bënga fsënjama: s̈motsaperdónaye; cachcá nts̈amo chë bëngbiama bacna soyënga amënga fsëndbetsaperdonaycá. ");
INSERT INTO kbh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bacna soyënga jamama s̈ojocochëngo ora, s̈cochjujabuache chca ndenobuíyama. Nÿetsca bacna soyënguents̈ana s̈matsebacaye. ");
INSERT INTO kbh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Chë ts̈ëngaftangbiama bacna soyënga amënga s̈mojtsaperdónasna, Bëngbe Taitá chë celoca endëtsomñá, ts̈ëngaftanga cmochanjáperdonaye. ");
INSERT INTO kbh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero chë ts̈ëngaftangbiama bacna soyënga amënga ndoñe s̈montsaperdónasna, Bëngbe Taitá cachcá, ts̈ëngaftanga ndoñe quecmochátaperdonaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Y nderado ts̈ëngaftanga inÿe ora tondaye ntjascá s̈mojtsemna Bëngbe Bëtsáftaca jencuéntama, juebëngménënga ndoñe s̈mattsemna, nts̈amo chë bacna ents̈anga chë ndegombre tmojuabnacá ndinÿinÿnayënga mondbetsamcá, as chca, chënga imojtsayúnama ents̈anga chamuinÿama. Ndegombre s̈cuayana, chëngbe uacanana soye ya tmojóyëngacñe, chënga tmojayunáyeca ents̈anga ts̈abá chëngbiama tmojtsoyebuambná ora. ");
INSERT INTO kbh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aca nderado tcojtsayúna ora, cochtsojuebjabebiye y aceitíyeca botamana cochtenochquëca, ");
INSERT INTO kbh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","as chca, ents̈anga ndoñe chamondë́tsetats̈ëmbo aca tondaye ntjascá cojtsemnama. Nÿe acbe Taitá, lempe chë mo iytëmencá yomna soyëngama tats̈ëmbuá, chama echántsetats̈ëmbo. Y cha, chë iytëmencá tcojama soye bominÿe endbetsequëcjnayá, acbe uacanana soye cmochántats̈taye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bomnana quem luarents̈e ndoñe s̈mattsëjuabaye. Muents̈na chë mejojón y inÿe pochócaye soyënga lempe jtsendbiamana, chë atbëbanënga jtsamashjnana y chë juabana soyënga jesatbëbana. ");
INSERT INTO kbh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más ts̈abá ts̈ëngaftangbiama entsemna, mora quem luarents̈e ts̈abe soyënga s̈mojtsamamna, uacanana soyënga celoca chaotsójuabaye. Chents̈e ni chë mejojón, ni chë inÿe pochócaye soyënga acbe soyënga quemochatspochóca, ni atbëbanënga quemochátamashjna jatbëbama. ");
INSERT INTO kbh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Er chë ndayents̈e acbe bomnana tojtsemnents̈a soyëngama acbe ainánaca cochántsejuabnaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","“Acbe bominÿe ts̈abá totsomñëse, mo canÿe uajuinÿanëshacá acbe cuerpama jtsemnana, chíyeca aca jtsobenana nts̈amo tcojtsamcá chë bomínÿeca jtsonÿayana. Chë bominÿe ndoñe ts̈abá tontsemnësna, chë bominÿe tondaye ntsobenana jamana, nts̈amo tcojtsamcá chacobená jinÿama. Cachcá, acbe ainaniñe ts̈abe juabnënga tcojtsebomnëse, lempe nts̈amo chacojtsamcá ts̈abá echántsemna. Y acbe ainaniñe ndocna ts̈abe juabnënga tcontsebomnësna, lempe nts̈amo chacojtsamcá ndoñe ts̈abá queochátsmëna. Y chca, aca cochantsiyena soyënga jtsamëse mo puerte ibetiñcá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ndocná ntsobenana uta mandayata jtsaservénana: cánÿabioye bochantsáboyënja y chë ínÿabioyna bochántsebobonshana, o cánÿabiama ts̈abá echántsetrabajaye y chë ínÿabiamna ndoñe ts̈abá. Ndoñe quecátobena Bëngbe Bëtsá jtsebobonshánana, nÿe quem luarents̈a soyënga jtsebomnama yapa tcojtsebos̈ëse ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Chcasna ats̈e s̈cuayana: Ndoñe s̈mattsenócochinÿena ndayá s̈mochjase o s̈mochjofs̈iye vida jtsebomnama, ni ndaye ents̈ayá s̈mochjuíchëtjuama cach ndoñe. Ndegombre, vida chë sanama más enduámana y cuerpo chë ents̈ayama más. ");
INSERT INTO kbh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","S̈mochjanÿe chë shlofts̈ënga jtsongüefjnayana. Chënga tondaye ntjájena, ni jaja saná ntjátbanana, ni chë grano uaquëcjnaye yebnënguiñe quemnatsquëcjná; pero Bëngbe Bëtsá, celoca endmëná, chënga saná jtsats̈atnayana. ¡Y ts̈ëngaftanga chë shlofts̈etémëngbiama puerte más s̈monduámana! ");
INSERT INTO kbh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Masque chca endmëna, canÿa masque ts̈a tojtsenócochinÿena, ¿nts̈amo nanjobenaye jamana chë ntsachets̈á vida yochtsebomnents̈ana, canÿe hora vida más jabotiyana? ");
INSERT INTO kbh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Y ndayá s̈mochjuíchëtjuama, ¿ndáyeca s̈mojtsenócochinÿena? S̈mochjinÿe chë jajañe lirio uants̈efjushangá jtsajuajnana: ndoñe ntsetrabájayana, ni ntseshabiamnayana. ");
INSERT INTO kbh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero ats̈e cbë́yana, ndegombre ni mo Rey Salomón nÿetsca chabe bomnánaca nÿets̈á botamana mo chë lirio uants̈efjushangacá quenjatspormana. ");
INSERT INTO kbh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bëngbe Bëtsá ts̈a botamana shácuana tojuama, y chë shácuana mënté jajoca jtsamnana, yëfsana iñoca. Chca chë shácuanaca cha tojamëse, ndegombre ts̈ëngaftangbiámnaca Bëngbe Bëtsá echanjama ents̈ayá chas̈motsábomnama, ¡ents̈anga nÿe bats̈á Bëngbe Bëtsábeñe os̈buáchiyënga! ");
INSERT INTO kbh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndoñe s̈mattsenócochinÿena, mënts̈á jtsichámëse: ‘¿Ndayá mochjase?’ o ‘¿Ndayá mochjofs̈iye?’ o ‘¿Ndayá mochtichëtjo ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chë soyëngama, chë Bëngbe Bëtsábioye nduabuátmënga mondbétsenocochinÿena, pero ts̈ëngaftanga ndoñe. Ts̈ëngaftangbe Taitá, Bëngbe Bëtsá, ndayá cmojtsë́jabotama endë́tats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Chíyeca, ts̈ëngaftangna natsana s̈mochjshétsebos̈e Bëngbe Bëtsá ts̈ëngaftangbe ainaniñe chaotsemándama y lempe nts̈amo cha tojamandacá s̈mochtsama. Chca s̈mojamëse, Bëngbe Bëtsá lempe nts̈amo cmojtsëjabotcá cmochanjáts̈ataye. ");
INSERT INTO kbh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ndoñe matenócochinÿenana ndayá yëfse yochjochnënguama. Yëfse luare cochántsebomna chë soyënga jinÿama y jamama. Cada tescama endbétsemna yapa totcá soyënga jájandmanama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ndocá ínÿengbiama s̈mattsichamo chë ndoñe ts̈abá tmontsamama. Chca, Bëngbe Bëtsá ndoñe queochátichamo ts̈ëngaftanga ndoñe ts̈abá s̈monjama ca. ");
INSERT INTO kbh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chë nts̈amo ts̈ëngaftanga ínÿengbiama s̈mojtsichamcá ts̈abá o ndoñe ts̈abá tmontsamama, cachcá Bëngbe Bëtsá ts̈ëngaftangbiama chë nts̈amo s̈mojamama echántsichamo. Y nts̈amo ínÿengbioye chas̈mojábiama, uabouana o ndoñe jabuache soyënga, cachcá Bëngbe Bëtsá ts̈ëngaftangbioye cmochanjábiama. ");
INSERT INTO kbh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","“Nderado canÿa chabe bominÿiñe canÿe niñëfja tojtsebomnëse, cha ndoñe ntsobenana chabe cats̈ata jauyanama: ‘Acbe bominÿents̈ana canÿe polvështema jtsebuchjátsëcama s̈molesenciá ca’. Natsana cha bontsemna cachabe bominÿents̈ana chë niñëfja jtsenobuchjátsëcana ts̈abá jinÿama jobenayama, chabe cats̈atbe bominÿents̈a polvështema jtsebuchjátsëcama. Cachcá entsemna acbiama, ¡bacna ents̈á chë nts̈amo ndegombre tcojuabnacá ndinÿinÿnayá!, chë ts̈a bacna soye cojtsama ca acbe cats̈ata tcojauyana ora, cach aca ts̈a bëts bacna soyënga cojtsamama ntjenojuaboycá; y chca, aca jamana canÿe bacna soye. Natsana cmontsemna chë cach aca ndoñe ts̈abe soyënga cojtsamama ngménaca jshatenójuaboyana y chca amana jtsajbanana, y chents̈ana cocayé cochantsobena acbe cats̈ata juajabuáchana nts̈amo ts̈abá yomncá chaotsamama. ");
INSERT INTO kbh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Chë Bëngbe Bëtsabe soyëngama josértama ndë́bos̈e ents̈anga ndoñe s̈mattsabuayiynaye. Aíñese nántsemna mo chë Bëngbe Bëtsabe bëts yebnoca uáts̈ëmbona mënts̈ena ques̈ënga cuaftsëbuajocá; chorna chënga jobuértanana, jobotjajuana y jtsáshantsana. O mo chë uámana ndëts̈ëtémënga cots̈ë́ngbioye cuaftsëts̈ancá, chënga nÿe jtsebotájayana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“S̈mochjotjañe y Bëngbe Bëtsá cmochanjáts̈ataye; s̈mochjánguango y s̈mochanjínÿena; s̈mochjachembo y bës̈ás̈a cmochanjébëtafjo. ");
INSERT INTO kbh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Er ndánaca tojtsotjanañá, jóyëngacñana; y nda tojtsenguá cha, jónÿenana; y nda tojtsechembuanábioye jebiatëfjuana. ");
INSERT INTO kbh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Ndëmuanÿe boyabása ts̈ëngaftanguents̈á, canÿe tandës̈e chabe uaquiñá tbojtsotjanañe ora, canÿe ndëts̈bé chábioye buanjats̈taye? ");
INSERT INTO kbh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O canÿe mëts̈cuaye buanjats̈taye, beona tbojtsotjanañe ora? ");
INSERT INTO kbh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Y chca, ts̈ëngaftanga, bacna soye amënga, ts̈ëngaftangbe basetémënga ts̈abe soyënga jats̈atayama s̈mojtsamanëse, ¡más ts̈ëngaftangbe Taitá, Bëngbe Bëtsá celoca endmëná, chë tmojtsotjanañënga ts̈abe soyënga echanjáts̈ataye! ");
INSERT INTO kbh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Inÿengaftaca s̈mochtsama nts̈amo chë ínÿenga ts̈ëngaftangaftaca chamotsamama s̈mojtsebos̈cá. Chca endmëna nts̈amo Moisesbe leyiñe y chë Bëngbe Bëtsabe juabna oyebuambnayëngbe buatëmbana soyënguiñe endayancá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Chë base utënts̈á bës̈ás̈ajana s̈mochjámashjna. Chë utënts̈á bës̈ás̈ajana y chë paselo jóyenama benache, infiernoye cmochanjuánatse y banga chëjana mondámashjuana. ");
INSERT INTO kbh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Chë ts̈abe vida binÿnoye jamna base utënts̈á bës̈ás̈ajana endmëna y ndoñe paselo jóyenama benache, y chiñe báseftanga mondbínÿena. ");
INSERT INTO kbh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cuedado s̈mochtsebomna chë Bëngbe Bëtsabe ndoñe ndegombre juabna oyebuambnayëngbiama. Chëngna mo oveshëngcá ts̈ëngaftangbioye mochanjabo, pero ndegombre chënga mondmëna mo ts̈átjaye tjañe ques̈ëngcá. ");
INSERT INTO kbh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ts̈ëngaftanga betiyënga jtsabuatmana nts̈amo cada ona tojtseshajcá; cachcá ts̈ëngaftanga chcanga s̈mochantsëbuatma, ndayá chënga mochtsamama. Uchmas̈ëshe betiyents̈ana ndoñe uvas ntjuátabebiana, ni higuëbé cardo betiyents̈ana. ");
INSERT INTO kbh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chca, nÿetsca ts̈abe betiyiñe ts̈abe soye jashájonana; y chë ndoñe ts̈abeshiñna podesca soye. ");
INSERT INTO kbh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Canÿe ts̈abe betiyiñe quenátopodena podesca soyënga jashájonana, ni canÿe ndoñe ts̈abe betiyiñe ts̈abe soyënga jashájonana. ");
INSERT INTO kbh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ndaye betiye podesca shajuanëshe jtseshatëts̈ana y iñoye jtsatmets̈ana. ");
INSERT INTO kbh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","As chca ts̈ëngaftanga chënga s̈mochantsëbuatma, ndayá chënga mochtsamama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ndoñe nÿetscanga chë ‘¡Utabná! ¡Utabná ca!’ ats̈e s̈mojtsatsëtsnanga, Bëngbe Bëtsabe amë́ndayoye quemochátamashjna. Nÿe nts̈amo ats̈be Taitá, celoca endmëná, tojtsebos̈cá amëngna aíñe. ");
INSERT INTO kbh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quem luare jopochócama te banga ats̈e s̈mochanjauyana: ‘¡Bëngbe Utabná! ¡Bëngbe Utabná! Aca jóts̈ëmbonëse, ácbeñe betsos̈buáchema, bënga fsëndoyebuambná, y ácbeyeca bacna bayëjëngbe juabna ents̈ángbents̈ana fsëndëtabocana, y ácbeyeca bëts soyënga fsëndama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Chora ats̈e chanjójuaye: ‘Ndocna te checbaisëbuátmana. Ats̈bents̈ana mojuánanga, bacna soye ama ents̈anga ca’ ” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Chcasna, nda ats̈e s̈ojoyeuná y chë nts̈amo sëntsichamcá tojtsama, endmëna mo canÿe ts̈abá juabnaye boyabasacá. Chë boyabásana ndëts̈beñe chabe yebna yojajebo. ");
INSERT INTO kbh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Uaftena yojuáshjango, chë béjayënga yojóftjajna, chë yebnoye puerte yojtsebinÿiaye, pero chë yebna ndoñe ntjuáshajayana, chë yebna ndëts̈beñe inajéboyeca. ");
INSERT INTO kbh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero nda ats̈be palabra tojouena y nts̈amo sëntsichamcá ndoñe tontsama, endmëna mo canÿe ndëjuabnaye boyabasacá. Chë boyabásana chabe yebna cascajuiñe yojajebo. ");
INSERT INTO kbh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uaftena yojuáshjango, chë béjayënga yojóftjajna, chë yebnoye puerte yojtsebinÿiaye y chë yebna uabouancá yojtsáshajaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús chë soyënga jóyebuambayama tojanpochocá ora, chë ents̈anga ojnanánënga imojtsemna nts̈amo cha tojánabuatambama. ");
INSERT INTO kbh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús tojanabuatambá nÿets obenánaca, mo canÿa mando bomnacá y ndoñe nÿe mo chë ley abuatambayëngcá. ");
INSERT INTO kbh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús tjoicana tojtantsmá ora, ba ents̈anga tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chora canÿe boyabása bacna nguayanánaca s̈ocá Jesúsbioye tojanobeconá, chabe delante yojoshaments̈iye y tbojaniyana: —Utabná, aca tcojtsebos̈ëse, catjobenaye ats̈be s̈ocana jtsebojuánana ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","As Jesús tojanacuenÿanëjaná, chë boyabásabioye tbojánbojajo y tbojaniyana: —Aíñe, së́ntsebos̈e. S̈ocana cbotsebojuaná ca. Y cachora chabe s̈ocana tbojtsanóbojuanañe. ");
INSERT INTO kbh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús chë shnanábioye tbojaniyana: —Mouena, ndocnábeñe cattsecuéntaye; nÿe chë Jerusalenoca báchnëbioye motsa, y cha cochjinÿinÿiye mora aca ya ts̈abá cojtsatsmënama. Bayá cochtsambaye, Bëngbe Bëtsá chama jëtschuayama, nts̈amo Moisés tojëftsanmandacá, as chca nÿetscanga chamotats̈ëmbona mora aca ya ndoñe s̈ocá contsemnama ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaumoye tojánamashëngo ora, canÿe Romano soldadëngbe amëndayá Jesúsbioye tojanobeconá canÿe pavorama jaimpádama. ");
INSERT INTO kbh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jesúsbioye tbojaniyana: —Utabná, ats̈be bochichnayá yebnoca s̈ocá entsemna, jama ndoñe quenátobena y jabuache tsets̈anánaca entsobësná ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chora Jesús tbojanjuá: —Cha jáshnama chanjá ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","As chë soldadëngbe amëndayá tbojaniyana: —Señor, ats̈e merecido taitsatobuajoñe ats̈be yebnents̈e chacuamashënguama; nÿe mayana y ats̈be bochichnayá ts̈abá echántsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ats̈bioye mándayënga ats̈e sëndábamna y áts̈naca soldadëngbe amëndayá sëndmëna. Ats̈e canÿe soldado stjauyana “motsa ca”, cha cachora jana; y inÿa stjauyana “mabo ca”, cha cachora jabana; y nderado ats̈be bochichnayá ndayánaca chaomama stjamánda, chánaca cachora chë soye jamana ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús chca tojanuena ora, tojanenjnaná y chë ústonënga tojanë́yana: —Ndegombre cbë́yana, ni mo nÿets Israelents̈e ni canÿa quem boyabasacá Bëngbe Bëtsábeñe nÿets̈á os̈buachiyá chiyátinÿena. ");
INSERT INTO kbh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Y s̈cuayana, shinÿe bocanoicana y shinÿe uenatjë́mbambanoicana bëtscá ents̈anga mochanjabo, y Abraham, Isaac y Jacob, chë judiëngbe tempsca uámana bëts taitángaftaca mochanjotbiama Bëngbe Bëtsabe amë́ndayoca, cánÿiñe juasama. ");
INSERT INTO kbh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ba Israeloca ents̈anga, chë ndëmuanÿengbiama Bëngbe Bëtsabe amë́ndayana natsana yochtsanmëna, chocana mochantëbuacana chë ndëbinÿna luaroye, infiernoye. Chents̈e puerte mochanjenóbos̈achna y chë tsets̈anama juatsas̈ënga mochantsenoftë́s̈jojnaye ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chora Jesús chë soldadëngbe amëndayábioye tbojaniyana: —Acbe yebnoye motsatá y chë nts̈amo cojtsos̈buachecá cachcá chaotsemna ca. Cachora chë bochichnayá ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chents̈ana Jesús, Pédrëbe yebnoye tojána. Chents̈e Pédrëbe uambén mamá s̈ocá calentóraca yojtsejutsnajona. ");
INSERT INTO kbh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Chora Jesús chë uambén mamabe cucuats̈e tojánbojajo y cachora chë calentora tbojtsanóbojuanañe. Chorna chë uambén mamá tojtantsbaná y tojanonts̈é chënga jobuácuedana. ");
INSERT INTO kbh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chë te jaibétatama ora, Jesús yojtsemnoye banga bacna bayëjëngbe juabna uambaye ents̈anga tmojanënatse. Chora, nÿe canÿe Jesús jóyebuambayëse chë bacna bayëjënga imojtsaisebocana y nÿetsca s̈oquënga tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chca Jesús tojanma, cachcá chaotsemnama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías tojanayancá. Cha mënts̈á tojánayana: “Cha bëngbe s̈ocanënga tonjaftsanca y bëngbe nÿetsca tsets̈anana chábeñe tonjanoquedá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús tojánanÿe mallajta ents̈anga chabe shë́conana; as tojanmandá uafjajónaye chenguana jama. ");
INSERT INTO kbh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chorna, canÿe ley abuatambayá Jesúsbioye tbojanobobeconá y tbojaniyana: —Buatëmbayá, ats̈e së́ntsebos̈e aca juastama, ndë́moye chacojtsá choye ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","As Jesús tbojaniyana: —Chë zorrënga mondbomna cuevëshënga ndayents̈e jtsiyenama y chë shlofts̈ëngna uajajonëshangá, pero chë Bëngbe Bëtsá Ents̈á tbojanbemá ndoñe quenátsbomna ndayents̈e jóchnama ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chora inÿa, cach uatsjendayënguents̈á, Jesúsbioye tbojaniyana: —Bëngbe Utabná, s̈molesenciá ats̈be taitá chjshesabotbontsañe ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Chora Jesús tbojanjuá: —Nÿe s̈masto. Chë Bëngbe Bëtsabiama mo obanëngcá, nts̈amo Bëngbe Bëtsá yomandacá ndoñe tmontsama causa, chënga cachëngbe obanënga chamotsë́tebuantsañe ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chents̈ana Jesús canÿe barquë́shoye tojánamashëngo y chabe uatsjéndayënga imojtsetjëmbambnaye. ");
INSERT INTO kbh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ndeolpe ts̈a jabuache binÿia chë uafjajónaye béjayiñe yojóshjango; nÿets̈á jabuachana yojtsemna, chë olëshënga barquë́sha imojtsë́tsbotsana. Y Jesús chora inétsomañe. ");
INSERT INTO kbh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","As chabe uatsjéndayënga tmojána Jesús jetsefs̈enama y tmojaniyana: —¡Bëngbe Utabná, s̈matsebacá. Montsenatjë́mbambana ca! ");
INSERT INTO kbh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Chora Jesús tojanë́yana: —¿Ndáyeca ts̈a s̈mojtsauatja? ¿Ts̈a bats̈atema s̈mojtsos̈buaché, Bëngbe Bëtsá ts̈ëngaftanga jujuabuáchama yobenama ca? Chca tojanë́yana y tojantsbaná. Chora tojanmandá chë binÿia y chë búyeshe bonguana chaotsatsmënama, y lempe natjë́mbana yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chabe uatsjéndayënga ojnanánënga imojtsemna y mënts̈á imojtsichamo: “¿Nda quem boyabása yomna? Cha tonjayana y chë binÿia y chë búyeshe tmonjoyeuná ca.” ");
INSERT INTO kbh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús uafjajónaye chenguana tojánashjango, canÿe luare Gadara ca uabáinents̈e. Chorna chë utabuantsánëngbents̈ana útata, bayëjbe juabna uambayata, tbojánbocna y Jesúsbioye tbojanobobéconata. Puerte ts̈atjayata ibnamna, chíyeca ents̈anga ndoñe ntsobenana chëjana jtsachnëjuanana; ");
INSERT INTO kbh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","y chora tbojanonts̈é chë bacna bayëjë́ngbeyeca mënts̈á uayebuáchana: —¿Ndayá bë́ngaftaca cojtsebos̈e, Jesús, Bëngbe Bëtsabe Uaquiñá? ¿Moye tcojabo bënga chafsufrima, chama cabá ndoñe chë tempo yontsemna ora ca? ");
INSERT INTO kbh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chents̈a béconana ba cots̈ënga imnajena y chënga imnétsosañe. ");
INSERT INTO kbh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y chë bayëjënga Jesús tmojanimpadá: —Muents̈ana jésebocanama aca tcojamëse, cochjama bënga chë cots̈ë́ngbeñe fchayamashjnama ca. ");
INSERT INTO kbh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Y Jesús tojanë́yana: —Motsajna ca. Chora chë bayëjënga chë boyabásatbents̈ana tmojésanbocana y chë cots̈ë́ngbeñe tmojánamashjna; cachora chë cots̈ënga batsjocana penës̈ëjana uafjajónayoye imojtsoshbuets̈e y yojtsatajo. ");
INSERT INTO kbh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chora chë cots̈ënga anÿenënga tmojtsanacheta, y chë puebloye tmojánashjajna ora, tmojanonts̈é lempe nts̈amo yojochnëngcá jacuéntana y nts̈amo chë bayëjbe juabna uambayátaftaca tojanopasámnaca. ");
INSERT INTO kbh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chora nÿetsca ents̈anga chë pueblents̈ana tmojánbocana y Jesús yojtsemnoye tmojána. Chë ents̈anga Jesús tmojáninÿe ora, tmojanimpadá chë luarents̈ana chauesebocnama. ");
INSERT INTO kbh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chca tojanopasá chents̈ana, Jesús canÿe barquë́shoye tojánamashëngo, uafjajónaye chenguana tojána y cachabe puebloye Capernaumoye tojtanashjango. ");
INSERT INTO kbh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chora, canÿe jama ndobená, tjuashiñe jajoná, Jesús yojtsemnoye básefta boyabásenga tmojanamba. Jesús tojáninÿe chënga ts̈a imojtsos̈buáchema chë s̈ocábioye jáshnama cha bétsobenama; as chë s̈ocábioye tbojaniyana: “Sobreno, añemo matsca; acbe bacna soyënga tcbontseboperdoná ca.” ");
INSERT INTO kbh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chca causa, báseftanga ley abuátambayënga chents̈e imojtsemnënga imojtsejuabnaye: “Chca jayanëse, ndoñe ts̈abá quenátichamo Bëngbe Bëtsabiama; mo chábioye cuafjoyenguangcá entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesús yojtsetáts̈ëmbo nts̈amo chënga imojtsejuabnaycá; chíyeca tojanë́yana: “¿Ndáyeca nÿets̈á bacna juabnënga ainaniñe s̈mojtsebomna ca? ");
INSERT INTO kbh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ts̈ëngaftangbiama ndayá más paselo nántsemna ts̈ëngaftangbe delante jayanama: ‘Acbe bacna soyënga tcbontseboperdoná’ o ‘Matëtsbaná y motsa ca’? ");
INSERT INTO kbh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ats̈e cbochanjínÿanÿiye nts̈amo chë Bëngbe Bëtsá Ents̈á tbojanbemá quem luarents̈e mando yobomnama, ents̈anga bacna soyëngama jáperdonama ca” —Jesús tojanë́yana. As chë jama ndobenábioye tbojaniyana: “Matëtsbaná, acbe tjuashe mesocñe y acbe yebnoye motsatoñe ca.” ");
INSERT INTO kbh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chorna chë jama ndobená tojtantsbaná y cachabe yebnoye yojtsatoñe. ");
INSERT INTO kbh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chca tmojáninÿama chë ents̈anga auatjanánënga imojtsemna y Bëngbe Bëtsá imojtsatschuanaye, cha chca obenana ents̈anga tojánats̈atama. ");
INSERT INTO kbh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús chents̈ana tojtsanoñe y canÿe ents̈ábioye tbojáninÿe, Mateo ca uabainá, chë Romocama impuesto ents̈ángbioye atjanayents̈e inétsotbemañe. Chora Jesús tbojaniyana: “S̈masto ca.” As Mateo chents̈ana tojëftsantsbaná y tbojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús cach Mateobe yebnents̈e yojtsesaye ora, banga Romocama impuesto ents̈ángbioye atjanayënga y ínÿenga bacna soye amënga tmojánashjajna y mesë́shents̈e Jesús y chabe uatsjéndayëngaftaca imojotbiama. ");
INSERT INTO kbh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chë fariseunga chca tmojáninÿe ora, Jesusbe uatsjéndayëngbioye tmojanatjá: —¿Nts̈amo chca yojtsemna, ts̈ëngaftangbe buatëmbayá chë impuesto atjanayënga y bacna soye amë́ngaftaca entsesá ca? ");
INSERT INTO kbh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús chca tojanuena y chë fariseunga tojanë́yana: —Chë salud bomnënga ashnayá ndoñe ntsëjabótana, pero chë s̈oquënga aíñe. ");
INSERT INTO kbh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","S̈mochjá y nts̈amo ndegombre iuayancá s̈mochjuatsjinÿe quem Bëngbe Bëtsabe uabemana palabrënguiñe: Ats̈e së́ntsebos̈e ts̈ëngaftanga lastemadënga chas̈motsemna, y ndoñe nÿe bayënga chas̈motsëbánaye Bëngbe Bëtsá jëtschuayama ca. Ats̈e ndoñe chiyátabo chë Bëngbe Bëtsabe bominÿiñe ts̈abá amënga jabáchembuama, sinó chë bacna soye amënga imomna ca juabnayënga jabáchembuama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chents̈ana, Juan chë Ubayanabe ústonënga tmojanobeconá y Jesús tmojantjá: —Bënga y chë fariseunga fsënduamana ba soye tondaye ntjascá jtsemnana, Bëngbe Bëtsáftaca jencuéntama. ¿Ndáyeca acbe uatsjéndayënga ndoñe chca ca? ");
INSERT INTO kbh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","As Jesús tojanë́jua: —Chë casamentoye ófjanënga chë boyabása bouamná chë́ngaftaca tojtsemnëntscuana, chë́ngbioye saná ndoñe ntsabuáshebenana y ngménaca ndoñe ntsemnëngana. Pero ora echanjobuache y chë boyabása bouamná chents̈ana mochantsánatseñe; chora cocayé chë ófjanënga tondaye más jasama quemochátsbomna. Nts̈amo chë tojobouamá cha y chë ofjanë́ngaftaca endmëncá, cachcá endmëna ats̈e y ats̈be uatsjendayë́ngaftacnaca. ");
INSERT INTO kbh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ndocná canÿe uatanguá ents̈ayá base tsëm ents̈ë́juaca jtarméndana. Er chë tsëm ents̈ë́jua jtsabéconana y chë uatanguá ents̈ayá más jtsatanë́canana, y chca chë uátanëcniñe más bëtsiñe jtsabemana. ");
INSERT INTO kbh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y cach ndoñe chë tojtseshayana vínoye tanguá jasabenguiñe ntjataftsuámayana. Tcojuaftsuamasna, chë jasabenga jtseshébëfjuana y chë vínoye jtsabuáshanana, y chë vínoye y chë jasabenga tondayama ntjatoservénana. Chíyeca comna, chë tojtseshayana vínoyna tsëm jasabenguiñe juaftsuámana; y chca, chë jasabenga y chë vínoye jtsoservénana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús ents̈anga yojtsëtsëtsnantscuana, chë judiëngbe enefjuana yebnents̈a canÿe mandayá tojánashjango y Jesusbe shecuats̈ents̈e yojoshaments̈iye. Chë mandayá tbojaniyana: “Ats̈be bembe tontsóbana. Diosmanda ats̈be yebnoye mabo; cochjabojajo y cha echántayena ca.” ");
INSERT INTO kbh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chents̈ana Jesús y chabe uatsjéndayënga chë mandayá tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Imojtsaye ora, canÿe shembása stëts̈oicana Jesúsbioye yojobeconá. Bnë́tsana uta uatama oboftjajuanánaca cha inapadecena. Chë s̈ocá Jesúsbioye yojobeconá ora, yojtsejuabnaye: “Masque nÿe mo chabe ents̈ayá sibiájua chaijuábojajo, salud chantinÿena ca.” Chents̈ana chë s̈ocá Jesusbe ents̈ayá tojanábojajo. ");
INSERT INTO kbh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tojanábojajo ora, Jesús tojanobuértana, chë shembásabioye tbojáninÿe y tbojaniyana: “Añemo matsca, shembása. Bëngbe Bëtsábeñe icos̈buachéyeca, mora ts̈abá contsatsmëna ca.” Y cach orscana cha ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chënga tmojtëtanonts̈é ayana y chora chë mandayábioca chënga tmojánashjajna. Chents̈e Jesús tojánanÿe, ínÿengna chë veloriama imojtsanflautaye y ínÿengna ts̈a imojtsos̈achiye. ");
INSERT INTO kbh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chora Jesús tojanë́yana: “Muents̈ana mobocnënga. Chë shembásetema cabá ndoñe obaná quenátsmëna; nÿe endëtsomañe ca.” Pero chë ents̈anga Jesúsbioye nÿe imojtsáfchaye. ");
INSERT INTO kbh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero Jesús pronto chënga chë yebnents̈ana tojanëbuacna. Chora Jesús tojánamashëngo chë shembásetema yojtsemnoye; cucuats̈e tbojanábuacueshache y cachora chë shembásetema tojtantsbaná. ");
INSERT INTO kbh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Y nÿets chë luarëjana ndayá Jesús yojamama nÿetsca ents̈anga imojátats̈ëmbona. ");
INSERT INTO kbh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús chents̈ana tojë́ftsanbocna ora, uta jtanata tbojanasto y mënts̈á ibojtsaiuáyebuache: —¡Davídbents̈ana Ents̈á, bëndata s̈motsalastemá ca! ");
INSERT INTO kbh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús chë yebnoye tojánamashëngo ora, chë jtanata tbojanóbobeconata. As Jesús tojanatjá: —¿Tsëndata s̈ojtsos̈buaché ats̈e chca jamama chjobenaye ca? Y tmojanjuá: —Arseñor. Aíñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chora Jesús tojánabuchbojajo y tojanë́yana: —Nts̈amo tsëndatbe os̈buáchiyana yomncá, cachcá chaotsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y cachora jinÿama ibojtsobena. Jesús bëtscá chata mënts̈á tojanamëndá: —Ndocná más quem soye chaondë́tsetats̈ëmbo ca. ");
INSERT INTO kbh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero chata chents̈ana tbojë́ftsanbocna y cachora tbojanonts̈é ndayá Jesús chátaftaca tojanmama nÿets chë luarëjana jacúntana. ");
INSERT INTO kbh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chë jtanata ibojtsebocanëntscuana, básefta ents̈anga canÿe ndëbiá, bacna bayëjbe juabna uambayá, Jesúsbioye tmojanamba. ");
INSERT INTO kbh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús chë bacna bayëja chábents̈ana tbojtanábocna y cachora chë ndëbiá tojtanonts̈é oyebuambnayana. Ents̈anga ojnanánënga imojtsichamo: “¡Ndocna te Israelents̈e chca bëts soye chemuáisinÿe ca!” ");
INSERT INTO kbh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero chë fariseunga imojtsichamo: “Cach bacna bayëjëngbe amëndayá, Satanás, muábioye obenana tbojats̈tá chë bayëjënga ents̈ángbents̈ana jtëbuacanama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús nÿetsca pueblënguëjana y luarënguëjana yojtsachnëjuana y chë judiëngbe enefjuana yebnënguenache ents̈anga yojtsabuátambaye. Yojanabuayiyná chë ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama, y nÿetsca s̈ocanëngama y tsets̈anama yojánashnaye. ");
INSERT INTO kbh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y chë ents̈anga tojánanÿe ora, puerte tbojanongmé. Er chënga imojtsemna mo abuajë́nÿa ndbomna oveshëngcá, puerte uamënts̈nayënga ba soyëngama padecena causa, y chaújabuachama ndocná ntsebomncá. ");
INSERT INTO kbh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Chora chabe uatsjéndayënga tojanë́yana: “Canÿe bëts jajañe bëtscá játbanama entsemna, pero peonga nÿe báseftanga. Cachcá quem luarents̈e, bëtscá ents̈anga Bëngbe Bëtsábioye nduabuátmënga montsemna, y chë́ngbioye chabiama abuayiynayënga nÿe báseftanga. ");
INSERT INTO kbh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Peonga tmojtsashbenëse chë nduíñbioye jaimpádana ba peonga chauichamoma chë jaja saná játbanama. Cachcá, Bëngbe Bëtsábioye moimpadanga ba abuayiynayënga chauichamoma, quem ents̈anga chábioye chamúbuajama ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chents̈ana Jesús tojánachembo chabe bnë́tsana uta uatsjéndayënga, y obenana tojanats̈atá bacna bayëjëngbe juabna ents̈ángbents̈ana jtabocnama y nÿetsca s̈ocanëngama y tsets̈anama jashnayama. ");
INSERT INTO kbh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chë bnë́tsana uta uatsjéndayënga mënts̈á imojanabaina: chë natsaná Simón, Pedro cánaca uabainá y chabe uabentsá Andrés; Santiago y chabe uabentsá Juan, Zebedeobe uaquiñata; ");
INSERT INTO kbh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe y Bartolomé; Tomás y Mateo, chë Romocama impuesto ents̈ángbioye atjanayá; Santiago, Alfeobe uaquiñá y Tadeo; ");
INSERT INTO kbh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, chë celote ca uabobainá y Judas Iscariote, chë uayayëngbe cucuats̈iñe Jesúsbioye boshjuaná. ");
INSERT INTO kbh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús chë bnë́tsana uta boyabásenga tojanichamó chë ts̈abe noticiënga ents̈anga jabuátambama, y mënts̈á tojanabuayená: “Chë ndoñe judië́ngbeñe ndoñe s̈mattsana y ndaye pueblents̈e Samaria luaroca ndoñe s̈matjë́ftsamashjna. ");
INSERT INTO kbh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nÿe Israeloca pueblëngoye s̈mochjá. Choca ents̈anga mo óts̈ena oveshëngcá montsemna, Bëngbe Bëtsábioye corente nduabuatma causa. ");
INSERT INTO kbh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","S̈mochjá y ents̈anga s̈mochjábuayenaye Bëngbe Bëtsabe amë́ndayana echanjóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Chë s̈oquënga s̈mochjáshnaye, s̈mochjama chë obanënga chámuatayenama, bacna nguayanánaca s̈oquënga s̈mochjáshnaye y bacna bayëjëngbe juabna ents̈ángbents̈ana s̈mochtábocna. Chë obenana s̈monjóyëngacñe tondaye ntjëtsjajuacá; cachcá, chë soyënga s̈mojtsamama tondaye ents̈anga s̈mattsayëngacaye. ");
INSERT INTO kbh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ndoñe s̈mattsambaye crocénana uasnanëchiñe. ");
INSERT INTO kbh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni shecnaja sanaca benachiñama, ni inÿe ents̈ayá jtsenomódama, ni shecochëtjonëshënga, ni jatjonëfja, er chë ts̈abe trabajayá jtsomerecénana nts̈amo tbojtsajabotcá jóyëngacñama. ");
INSERT INTO kbh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nderado canÿe bëts pueblents̈e o base pueblents̈e chas̈mojáshjajna ora, s̈mochjánguango canÿe ts̈abe ents̈á, ínÿengbioye ndaingñayá, y chabe yebnents̈e s̈mochtsoquedañe, inÿe puebloye játantscuana. ");
INSERT INTO kbh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Canÿe yebnoye chas̈mojámashjna ora, nÿetsca chents̈a oyenënga mënts̈á s̈mochjácheuaye: ‘Chë bëngbe ainaniñe ts̈abe ebionana ts̈ëngaftangbe ainaniñe chaotsemna ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chë yebnents̈a ents̈anga ainaniñe ts̈abe ebionana jtsebomnama merecido tmojtsebuajonëse, chë ts̈ëngaftangbe ainaniñe ts̈abe ebionana chë́ngaftaca chaotsemna. Ndóñesna, nÿe cach ts̈ëngaftangaftaca chaotsomñe. ");
INSERT INTO kbh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y nderado canÿe pueblents̈e o bëts pueblents̈e chë ents̈anga ndoñe tcmonjúbuaja y ndoñe tcmonjóyaunase, chents̈ana s̈mochjésebocana y chë shecuats̈ents̈a polvëshe s̈mochjésenstoto. Chca, chë ents̈anga mochántsetats̈ëmbo chënga ts̈ëngaftangaftaca ndoñe ts̈abá tmonjamama. ");
INSERT INTO kbh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndegombre s̈cuayana, quem luare jopochócama te, chë ndoñe chacmonjúbuaja y ndoñe chacmonjoyauná ents̈anga Bëngbe Bëtsá puerte jabuache echantsacastígaye, y chë bacna ents̈anga Sodoma y Gomorra luaroquëngna ndoñe nÿa nÿets̈á jabuache queochatacastígaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“S̈mochjouena. Ats̈e cbontsachamná mo oveshënga cuenta tjañe ques̈ë́ngbeñe. Chíyeca studio bomnënga mo mëts̈cuayëngcá s̈mochtsemna y uamanënga mo palomatemëngcá. ");
INSERT INTO kbh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ents̈angbiama cuedado s̈mochtsebomna, chëngbe pueblents̈a amë́ndayëngbe cucuats̈iñe ts̈ëngaftanga cmochanjábashejuana y chëngbe enefjuana yebnënguenache cmochanjátsets̈enaye. ");
INSERT INTO kbh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ats̈be ústonënga bétsemnama, mandadë́ngbioye y reyë́ngbioye cmochanjunatse. Y chca, ts̈ëngaftanga s̈mochanjobenaye chë́ngbeñe y chë ndoñe judië́ngbeñe nts̈amo ats̈biama s̈motats̈ëmbcá jóyebuambayama. ");
INSERT INTO kbh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero chë mandadëngbe cucuats̈iñe chacmojábashejuana ora, nts̈amo o ndayá s̈mochjayanama ndoñe s̈mattsenócochinÿena. Chca orna, Bëngbe Bëtsá ts̈ëngaftanga cmochanjabuayená nts̈amo o ndayá jóyebuambayama. ");
INSERT INTO kbh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ts̈ëngaftanga ndoñe chë oyebuambnayënga ques̈mochátsmëna, sinó chë ts̈ëngaftangbe Taitá, Bëngbe Bëtsabe Espíritu, ts̈ëngaftangbiajana echantsóyebuambnaye. ");
INSERT INTO kbh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Y canÿe ents̈á cachabe cats̈átbioye uayayëngbe cucuats̈iñe bochanjáboshjona chamotsóbama; y canÿe taitá cachabe uaquiñábioynaca. Y chë básenga chëngbe bëtsë́tsangbe contra mochántsemna y uayayëngbe cucuats̈iñe mochanjábashejuana chamotsëbáyama. ");
INSERT INTO kbh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ts̈ëngaftanga ats̈be ústonënga bétsemnama, nÿetsca ents̈anga cmochantsë́buayënja; pero nda nÿets tempo áts̈beñe os̈buachiyá chaotsomñá, atsbocaná echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Canÿe pueblents̈e chacmojtsë́camena ora, inÿe puebloye s̈mochtsacheta. Ndegombre cbë́yana, Israelents̈a nÿetsca pueblëngoye cabá nda ora, chë Bëngbe Bëtsá Ents̈á tbojanbemá ya quem luaroye echanjabáshjango. ");
INSERT INTO kbh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ni canÿe uatsjendayá chabe buatëmbayabiama más uamaná ntsemnana, ni chë oservená chabe nduiñbiama más uamaná. ");
INSERT INTO kbh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chë uatsjendayá ya cachabe buatëmbayacá jtsemnama tojashjáchëse, ndayá más nanjátsbos̈e. Cachcá endmëna chë oservenáftaca, cachabe nduiñcá tojtsemnëse. Ats̈e sëndmëna mo canÿe yebnents̈a taitacá y ts̈ëngaftangna mo cach yebnents̈a basengcá. Ents̈anga jtsichámuana ats̈na Beelzebú o chë bacna bayëjëngbe amëndayá tsmëna ca. ¿Nts̈amo chënga ts̈ëngaftanga cmochtsëbobuatma ca?” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Chíyeca ents̈angbiama ndoñe matauatjëngana. Chë yoiytë́mena soyents̈ana tondaye ntjinÿcá queochaisoquéda, y chë ndótats̈ëmbo soye, ntsotats̈ëmbcá queochaisoquéda. ");
INSERT INTO kbh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chë mora cbontsëtsëtsná soyënga, chë ents̈angbiama mo ibetiñe cuaftsemncá soyënga, ts̈ëngaftanga s̈mochjama ents̈anga botamana chama chamotsetats̈ëmbuama. Y chë iytëcana cbontsëtsëtsná soyënga nÿetsca ents̈anga s̈mochtsabuayiynaye, mo nda canÿe yebnents̈a tsbanánocana noticiënga tojtsayebuachcá. ");
INSERT INTO kbh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ndoñe matauatjëngana nÿe chë ts̈ëngaftangbe cuerpo japochócama imobenëngbiama y ainana jtsepochócama ndoñe ntsobenana. Más s̈mochtsebiauatja chë nda endobena ts̈ëngaftangbe cuerpo y ts̈ëngaftangbe ainana jtsepochócama, nÿetsca tescama infiernoca. ");
INSERT INTO kbh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Uta jaja shlofts̈etémata nÿe canÿe denario crocenánama mondbétsena. Masque chca, ni cánÿetema obanatema fshantsoye jotsats̈ana, ts̈ëngaftangbe Taitá, Bëngbe Bëtsá ndoñe tontsebos̈ëse. ");
INSERT INTO kbh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y ts̈ëngaftangbiama, Bëngbe Bëtsá botamana jtsantjes̈nana, y chca, cha lempe ts̈ëngaftangbiama jtsetats̈ëmbuana, bueta stjënashënga ts̈ëngaftangbe bests̈as̈iñe yomnámnaca. ");
INSERT INTO kbh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chíyeca ndoñe matauatjëngana, ts̈ëngaftanga ba jaja shlofts̈etémëngbiama corente más s̈monduámana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nda ats̈be ents̈á yomna ca ents̈angbe delante tojayanabiama, áts̈naca, ats̈be Taitá, chë celoca endmënabe delante chanjayana cha ats̈be ents̈á yomna ca. ");
INSERT INTO kbh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero nda ents̈angbe delante ats̈be ents̈á ndoñe yondmëna ca tojayanabiama, áts̈naca, ats̈be Taitá, chë celoca endmënabe delante chanjayana cha ats̈be ents̈á ndoñe yondmëna ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ndoñe s̈mattsejuabnaye ats̈e quem luaroye tijabo nÿetsca ents̈anga natjë́mbana chamotsiyenama. Ats̈e chama ndoñe chiyátabo; ats̈e sënjabo causa, ents̈anga más mochántsentsjanaye. ");
INSERT INTO kbh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ats̈e sënjabo chë uaquiñá cachabe taitabe contra chaotsemnama, chë bembe cachabe mamabe contra y chë bebincuá chabe uambén mamabe contra chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Y chca, ba ents̈angbe uayayënga cachëngbe pamíllanga mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nda cachabe taitá o mamábioye ats̈biama más tbojtsebobonshánëse, cha ndoñe ntsomerecénana ats̈be ents̈á jtsemnama. Nda cachabe uaquiñá o bémbëbioye ats̈biama más tbojtsebobonshánëse, cha cach ndoñe. ");
INSERT INTO kbh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Y nda nÿetsca chabe quem luare soyënga ndoñe tonjéseboshjona ats̈e juastama, y ats̈biama jasúfriama ndoñe tontseprontana y cruciñe jobanámnaca, cha ndoñe ntsomerecénana ats̈be ents̈á jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nda tojtsents̈ena quem luarents̈e bëtscá soyënga jtsebomnama y ats̈biama jasúfriama ndoñe tontseprontana, chë nÿetsca tescama yomna ts̈abe vida echanjobuets̈e. Pero nda quem luarents̈a soyënga cachcá tojesonÿá ats̈e juastama, masque chaóbana, chë nÿetsca tescama yomna ts̈abe vida echántsebomna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nda ts̈ëngaftanga chacmojúbuaja, áts̈naca cha s̈ochanjofja; y nda ats̈e chas̈ojofja, chë nda s̈ojichmóbioynaca cha bochanjofja. ");
INSERT INTO kbh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nda canÿe Bëngbe Bëtsabe juabna oyebuambnayábioye tbojoyeuná, cha chca bétsemnama, chábioye Bëngbe Bëtsá canÿe uacanana soye bochántats̈etaye, mo cach Bëngbe Bëtsabe juabna oyebuambnayabe uacanana soycá. Y nda canÿe nÿetsca soyënguiñe ts̈abá amábioye tbojofja, cha chca uamanama, chábioye Bëngbe Bëtsá canÿe uacanana soye bochántats̈etaye, mo cach nÿetsca soyënguiñe ts̈abá amabe uacanana soycá. ");
INSERT INTO kbh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y ndánaca, ts̈ëngaftanguents̈á canÿe nduamanábioye masque nÿe mo base búyeshtema tbojuabuats̈etá, ats̈be ustoná bétsemnayeca, ndegombre Bëngbe Bëtsá canÿe uacanana soye chábioye bochántats̈etaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús tojanpochocá chabe bnë́tsana uta uatsjéndayënga jábuayenama, y chents̈ana tojtsanoñe chë luariñe pueblënguenache oyena ents̈anga Bëngbe Bëtsabe palabra jabuátambama y jábuayenama. ");
INSERT INTO kbh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chë tempo Juan chë Ubayaná cárceloye tmojanëtame. Choca cha yojouena ndayá Jesús yojtsamama. Y as, Jesús yojtsemnoye, básefta chabe ústonënga tojanichamó, ");
INSERT INTO kbh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mënts̈á jatjayama: —¿Aca ndegombre cojtsemna chë jabama ibojanmëná, chë Uámana Uabuayaná, o s̈ojtsamna ínÿabiama jatobátmama ca? ");
INSERT INTO kbh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chca tmojantjá orna, Jesús tojanë́jua: —S̈mochjá y Juan s̈mochjauyana nts̈amo s̈mojouena y s̈mojinÿcá. ");
INSERT INTO kbh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cha s̈mochjacuénta: Chë jtanënga ts̈abá entsatëbinÿna, chë coshetënga ts̈abá montsatana, chë bacna nguayanánaca s̈oquënga shnánënga montsatsmëna y chë tësmënga montsuenana, chë obanënga tmontayena y chë ndbomnëjémëngbioye chë ts̈abe noticiënga montsabuayiyná ca. ");
INSERT INTO kbh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Puerte oyejuayá chaotsemna chë nda ats̈e bacna soye ndoñe stsama ca jtsejuabnayëse, áts̈beñe os̈buáchiyana ndoñe tontsajbaná cha ca! —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chënga tmojtsatanoñe ora, Jesús tojanonts̈é Juanbiama chë ents̈anga jáuyanana, mënts̈á: “Juan jinÿama s̈mojánbocana ora, ¿ndayá jinÿama chë ents̈anga ndoyena luaroye s̈mojánbocana? ¿Canÿe ents̈á ainaniñe tondaye añemo ndbomná, mo canÿe s̈ës̈e bínÿiaca shatiyeynës̈cá? ");
INSERT INTO kbh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Y ndóñese, ¿ndayá jinÿama choye s̈mojánbocana? ¿Canÿe boyabása uámana ents̈ayaca bopormaná? Ndoñe. Ts̈ëngaftanga s̈mondë́tats̈ëmbo chë boyabásenga uámana ents̈ayaca bopormánëngna chë mándayëngbe yebnënguiñe mondbétsiyenama. ");
INSERT INTO kbh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Y asna, ¿ndayama choye s̈mojánbocana? ¿Canÿe Bëngbe Bëtsabe juabna oyebuambnayá jinÿama? Ndegombre, aíñe; y cbë́yana, ndegombre cha canÿe Bëngbe Bëtsabe juabna oyebuambnayabiama más bëtsá endmëna. ");
INSERT INTO kbh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cha, Juan, endmëna ndabiama Bëngbe Bëtsá chabe uabemana palabrënguiñe tojánayana mo chabe ichmonacá, mënts̈á tojánayana ora: Cristo, ats̈be ents̈á natsana sënjichmó acbiama chaóyebuambama, ents̈anga jábuayenama aca jabama ainaniñe ts̈abe juabnë́ngaca chamotseprontánama ca. ");
INSERT INTO kbh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndegombre cbë́yana: Nÿets tempo ents̈ángbeñe, ndocná quenátsmëna Juan chë Ubayanabiama más bëtsá; masque chca, Bëngbe Bëtsabe amë́ndayoca chë más bats̈á uamaná, más bëtsá echántsemna nts̈amo mora Juan yomnama. ");
INSERT INTO kbh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan chë Ubayaná tojánabo orscana më́ntscoñama, bëtscá ents̈anga ts̈a mondbos̈e Bëngbe Bëtsabe amë́ndayoye jamashënguama, y chë Bëngbe Bëtsabe amë́ndayama contra imomnëngna, chëngbe nÿets añémoca montsebos̈e chë mándayana jtsepochócama. ");
INSERT INTO kbh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan candabëntscuana, nÿetsca Bëngbe Bëtsabe juabna oyebuambnayënga y Moisesbe Ley nÿe Bëngbe Bëtsabe amë́ndayama tmonjanobuambá. ");
INSERT INTO kbh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Y ts̈ëngaftanga chë soyënga jóyëngacñama s̈mojtsebos̈ëse, Juan entsemna chë Bëngbe Bëtsabe juabna oyebuambnayá Eliascá, chë jabama ibojamná. ");
INSERT INTO kbh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chë jouenama tmojtsobenënga, chamouena ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mënts̈ánaca Jesús tojánayana: “¿Ndayacá morsca ents̈anga imomna? Chënga mondmëna mo chë plazëngoca mondbetsetbiámana basetemëngcá; chënga chëngbe enutë́ngbioye jtsayebuáchana ");
INSERT INTO kbh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","y mënts̈á jtsichámuana: ‘Ts̈ëngaftangbiama fsënjaflautá y ndoñe ches̈matslantsá; ngménaca fsënjaversiá y ndoñe ches̈matos̈achna ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan tonjánabo, y bëtscá ents̈ángbeñe ndoñe quenjatamana ni jasana, ni jofs̈iyana, y ents̈anga montsanichamo chana bacna bayëjbe juabna uambayá yojamna ca. ");
INSERT INTO kbh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Morna, chë Bëngbe Bëtsá Ents̈á tbojanbemá tonjabo, y chana aíñe entsamana bëtscá ents̈ángbeñe jtsesayana y jtsofs̈ës̈nayana, y ents̈anga montsichamo chana yapa uasayá y vínoye tmoyá entsemna ca y Romocama impuesto ents̈ángbioye atjanayënga y bacna soye amëngbe amigo ca. Pero Bëngbe Bëtsá endbétsinÿanÿnaye cha nÿets osertánana bomná yomnama, chë ndayá cha tojama ora ndayá chents̈ana tojóbocna soyë́ngaca ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chents̈ana Jesús tojanonts̈é jucácanana chë ents̈anga, ndëmuanÿenga imojoyena chë pueblënguiñe ndayenache ba chabe bëts soyënga tojanma, chënga bacna soyënga amana ndoñe tmontsanajbanama y Bëngbe Bëtsabe benache ndoñe tmontanishachama. Mënts̈á yojtsichamo: ");
INSERT INTO kbh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Ts̈a lastema, Corazín puebloca ents̈angbiama! ¡Ts̈a lastema, Betsaida puebloca ents̈angbiámnaca! Chë chents̈e sënjama bëts soyënga, Tiro y Sidón bëts pueblënguents̈e matënjochnënguse, chents̈a bacna ents̈anga ya tempo ngménaca matmëntenojuabó chëngbe bacna soyëngama y Bëngbe Bëtsabe benache matmë́ntishache; y chca tmojamama chaotsótats̈ëmbuama uajojësha ents̈ayangaca matmëntopormanga y chëngbe bests̈as̈iñe jatinÿá matmënjenotbótoto. ");
INSERT INTO kbh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero ndegombre cbë́yana, nts̈amo ents̈anga tmojamama, ts̈abá o ndoñe ts̈abá bétsemnama jayanama chaojobuache ora, ts̈ëngaftanga más bëts castigo s̈mochántsebomna, chë Tiro y Sidonoca bacna ents̈angbe castiguama. ");
INSERT INTO kbh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y ts̈ëngaftanga, Capernaumoca ents̈anga, ¿s̈mojtsejuabná celóntscoca atsebánanënga s̈mochtsemna ca? ¡Chë uabouana infiernoye cmochantsë́setjango! Chë muents̈e sënjama bëts soyënga Sodomoca matënjochnënguse, choca ents̈anga ya tempo ngménaca chëngbe bacna soyëngama matmëntenojuabó y Bëngbe Bëtsabe benache matmë́ntishache, y chë bëts pueblo cabá cachcá mëntscuana mantsomñe. ");
INSERT INTO kbh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero ndegombre cbë́yana, quem luare jopochócama te, Bëngbe Bëtsá puerte jabuache cmochantsacastígaye, y chë Sodoma luaroca ents̈ángbioye ndoñe nÿets̈á jabuache quemochatacastígaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chë tempo, Jesús tojánayana: “Ats̈e cbatschuá, Taita, celoca y quem luarents̈a Utabná. Aca, chë nÿe bats̈á tats̈ëmbënga tcojanÿanÿé, chë ts̈a tats̈ëmbënga y osertánëngbiama tcojaiytëme soyënga. ");
INSERT INTO kbh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aíñe, chama cbontsadorana, Taita, chca chaotsemnama tcojábos̈enayeca. ");
INSERT INTO kbh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ats̈be Taitá lempe chca s̈onjats̈tá. Chë Uaquiñábioye ndocná corente quebnatábuatma; nÿe chë Taitá aíñe. Y chë Taitábioye ndocná corente quebnatábuatma; nÿe chë Uaquiñá aíñe, y ndábioye chë Uaquiñá tojtsebos̈e nda chë Taitá yomnama jinÿanÿiyama, chánaca chë Taitábioye bochantsábuatma. ");
INSERT INTO kbh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ats̈bioye mabënga nÿetsca ts̈ëngaftanga uamënts̈nayënga y bëtscá trabajo uangménënga, y ats̈e chanjama ts̈ëngaftanga chas̈mochnama. ");
INSERT INTO kbh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nts̈amo canÿe ents̈á, uacná yuguës̈iñe juabatsëcana juanatsama, cachcá, ts̈ëngaftanga ats̈e s̈mochjaleséncia jobnatsayama y jabuátambama. Ats̈bents̈ana s̈mochjuatsjinÿe: ats̈e uantado mëná sëndmëna y ndoñe quetsatamana yapa uamaná jatenobiamnayana. Y chca, ts̈abá jóchnama s̈mochantsobena y ainaniñe más añemo s̈mochántsebomna. ");
INSERT INTO kbh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mo canÿe uacnacá, ndoñe tishuta yuguës̈eca o ndoñe uauta uasmanë́shaca, paselo jama jobenayana, cachcá ts̈ëngaftanga s̈mochántsemna ats̈e cbojtsabnatsana y cbojtsabuátambase; y chca, ts̈ëngaftanga más oyejuayënga s̈mochántsemna y más paselo nÿetsca soyënga jamama echántsemna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chë tempo, Jesús canÿe ochnayté canÿe jajajana yojtsachnëjuana. Chabe uatsjéndayëngna shë́ntseca imojtsemna, chíyeca tmojanonts̈é trigo juatabebiana y chë meshënga jasana. ");
INSERT INTO kbh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chë fariseunga chca tmojáninÿe ora, Jesús tmojaniyana: —Minÿe, acbe uatsjéndayënga canÿe soye montsama y chë soye ochnayté jamama ndoñe quenátslesenciana ca. ");
INSERT INTO kbh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","As Jesús tojanë́yana: —¿Ndoñe s̈mëndualía y s̈mondë́tats̈ëmbo ndayá David y chabe enutënga tmojanmama, shë́ntseca imojtsemna ora? ");
INSERT INTO kbh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chca orna, David, Bëngbe Bëtsabe bëts yebnoye yojámashëngo y chë Bëngbe Bëtsá chents̈e yojamnama inÿinÿnaye tandës̈ënga yojase. Chë tandës̈e nÿe ndánaca jasama ndoñe yonjalesenciana, ni Davidbiama, ni chabe enutëngbiama. Nÿe bachnangbiama belesenciana chë tandës̈e jasama. Masque David chca tojanma, Bëngbe Bëtsá chora ndoñe tonjánayana David canÿe bacna soye tojanma ca. ");
INSERT INTO kbh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O ndoñe s̈mëndualía y s̈mondë́tats̈ëmbo, Moisesbe leyiñe, chë bachnanga ochnayté Bëngbe Bëtsabe bëts yebnents̈e jtsetrabájayana, pero ndoñe bacna soye ntsemnana chë bachnanga ochnayté ndoñe mondbóchnama? ");
INSERT INTO kbh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Y ats̈e s̈cuayana: Muents̈e canÿa entsemna, cha chë Bëngbe Bëtsabe bëts yebnents̈a bachnangbiama más uamaná endmëna y chabe amë́ndayoca soyënga más entsámana chë bachnangbe mándayents̈a soyëngama. ");
INSERT INTO kbh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: Ats̈e së́ntsebos̈e ts̈ëngaftanga lastemadënga chas̈motsemna, y ndoñe nÿe bayënga chas̈motsëbánaye Bëngbe Bëtsá jëtschuayama ca. Nts̈amo chiñe entsayancá ndegombre cmojtsësertánëse, ts̈ëngaftanga ndoñe chëngbe contra s̈mattsichamo, chë ochnayté chca tmojtsamëngbiama. ");
INSERT INTO kbh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chë Bëngbe Bëtsá Ents̈á tbojanbemá, chë ents̈á ochnayté tojtsama sóynaca jtsemándayana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chents̈ana Jesús tojtsanoñe y chents̈a judiëngbe enefjuana yebnoye tojánamashëngo. ");
INSERT INTO kbh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chents̈e yojtsemna canÿe boyabása buashana buacuats̈e bomná. Chë fariseunga imojtsenguaye ndayánaca, as chca chënga jtsebomnama ndaye sóyeca Jesús mal jaquédama. Chcasna, chora chënga Jesús tmojantjá: —¿Queojtselesenciana canÿe ochnayté s̈ocá jáshnama ca? ");
INSERT INTO kbh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Y Jesús tojanë́jua: —¿Nda ts̈ëngaftanguents̈á, canÿe oveshá tbojtsebomna y nÿa chë ochnayté canÿe fshantsents̈e atëfjnoye chë oveshá tojtsótsats̈e, chora chë boyabása nanjá o ndoñe chë oveshá jatábocnama? ");
INSERT INTO kbh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ents̈á oveshabiama puerte más uamaná endmëna! Chcasna, entselesenciana chë ochnayté ts̈abe soye jamama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chora Jesús chë buashana buacuats̈e bomnábioye tbojaniyana: “Macuenÿanëjaná ca.” Y chë boyabásana tojanacuenÿanëjaná y chora chëts̈a ts̈abá yojtsatamna mo cach inÿets̈acá. ");
INSERT INTO kbh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero chë fariseunga tmojésanbocana ora, tmojanonts̈é juabnayana nts̈amo jamëse Jesús jóbama. ");
INSERT INTO kbh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús chë soye tojántats̈ëmbona ora, chents̈ana tojtsanoñe y ba ents̈anga tmojanasto. Nÿetsca s̈oquënga tojanashná, ");
INSERT INTO kbh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","y tojanamëndá chabiama ents̈ángbeñe ndoñe chamondëtsóyebuambnama. ");
INSERT INTO kbh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chca tojanamëndá, cachcá chaotsemnama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías tojanayancá. Cha mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Muents̈e ats̈be oservená entsemna. Ats̈e cha sënjabocacá, ats̈be bonshaná, y ats̈e corente chabiama sëntsoyejuá. Ats̈e chanjama ats̈be Espíritu chabe ainaniñe chaotsemnama y ents̈anga echanjabuayená, Bëngbe Bëtsá nÿetsca luarënguents̈ana ents̈angbiama yochjayanama chënga ts̈abá o ndoñe ts̈abá tmonjamama. ");
INSERT INTO kbh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Cha ndoñe queochátayajuatsana, ni queochátschembumbuana. Chabe oyebuambnayana tsáshenañe ndocná queochatuena. ");
INSERT INTO kbh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mo nda chë atcana s̈ës̈e ndoñe más jatsndbemana, chë ndobenënga cha ndoñe queochátapochocaye. Mo nda chë quinÿenë́fjua nÿe uabojáts̈ena uajuinÿnë́fjua ndoñe ntsafsanana, chë Bëngbe Bëtsábeñe jtsos̈buáchiyama imojtsebojáts̈angbe obatmanana chábeñe, cha ndoñe queochátabuajuanaye. Cha nÿets añémoca echanjëftsetrabája, ents̈anga chëngbe ainaniñe Bëngbe Bëtsabe ndegombre soyënga chamóyëngacñëntscuana. ");
INSERT INTO kbh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y nÿetsca luarënguents̈ana ents̈anga chábeñe mochantsobátmana ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chora, Jesús yojtsemnoye canÿe boyabása jtaná y ndëbiá tmojanánatse. Chana bacna bayëjbe juabna uambayá inamna; y Jesús chábioye tbojanshná, chabuatabínÿnama y chabuatauénanama. ");
INSERT INTO kbh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y nÿetsca ents̈anga ojnanánënga imojtsichamo: “¿Mua yojtsemna chë Davídbents̈ana Uámana Ents̈á, chë Cristo ca?” ");
INSERT INTO kbh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero chë fariseunga chca tmojanuena ora, imojtsichamo: “Beelzebú, cach Satanás, chë bacna bayëjëngbe amëndayá, quem boyabásabioye obenana tbojats̈tá chë bayëjënga chauatëbuacnama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y Jesús yojtsetáts̈ëmbo nts̈amo chënga imojtsejuabnayama; as tojanë́yana: “Canÿe amë́ndayents̈e ents̈anga tmojtsenojatá y tmojtsenáyase, cachënga jenpochócana. Cachcá, canÿe bëts pueblents̈a ents̈anga o canÿe yebnents̈a pamíllanga tmojtsenojatá y ndoñe tmontsenëyeunanëse, chënga ndoñe ts̈abá nÿets tempo quemochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cachcá, Satanás cachabe bayëjënga jtëbuacnama tojtsebos̈ëse, chana tojtsenojatá y cachabe contra yojtsemna. Y chca, ¿nts̈amo nantsobena chabe mándayana quem luarents̈e jëftsebomnana? ");
INSERT INTO kbh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ts̈ëngaftanga s̈montsichamo ats̈e Beelzebube obenánaca chë bayëjënga stsatëbuacana ca; pero chca ndegombre tojtsemnëse, ¿ndábeyeca ts̈ëngaftangbe usetonënga obenana imojtsebomna chë bacna bayëjënga jtëbuacnama? Chíyecna, chënga montsinÿinÿná nts̈amo ndegombre yomnana y ts̈ëngaftanga ndoñe ndegombre soye s̈montsichámuama. ");
INSERT INTO kbh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Y ats̈na, chë Bëngbe Bëtsabe Espíritbeyeca chë bayëjënga ents̈ángbents̈ana sëndëtëbuacana; y chë soye entsinÿinÿná Bëngbe Bëtsabe amë́ndayana ts̈ëngaftangbioye tojóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“¿Nts̈amo nda nanjobenaye canÿe corente añemo bomna ents̈abe yebnoye jamashënguana y chabe soyënga jtsebocana, ndoñe natsana chábioye tconjshétsebatsëquëse? Nÿe tcojshétsebatsëquësna aíñe cuanjobenaye cha jefcana. Ats̈e ya chca Satanásoftaca sënjama. ");
INSERT INTO kbh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nda ndoñe áts̈eftaca tontsemná, ats̈be uayayá jtsemnana. Y nda áts̈eftaca ndoñe tontsetrabája, chana ats̈be contra jtsetrabájayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Chíyeca cbë́yana, Bëngbe Bëtsá ents̈anga echanjáperdonaye nÿetsca chëngbe bacna soyënga y chë Bëngbe Bëtsabiama puerte bacá oyebuambnayana, mo chábioye cuafjoyenguangcá; pero ndoñe queochátaperdonaye chë Uámana Espíritbiama puerte bacá ichámënga. ");
INSERT INTO kbh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bëngbe Bëtsá bochanjaperdóna chë Cha Ents̈á tbojanbemabiama ndoñe ts̈abá ichamuábioye; pero chë Uámana Espíritbiama ndoñe ts̈abá ichamuábioyna, ni quem luarents̈e, ni ndocna te quebochatsperdóna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Canÿe betiye ts̈abá mobocuedanga y botamana echanjashájona; ndoñe ts̈abá matscuedánana y ts̈abe shajuana ndoñe queochátsbomna. Chë betiye ts̈abe betiye o ndoñe ts̈abe betiye tondmënama, jtsotats̈ëmbuana nts̈amo chëshe tojashajoncá. ");
INSERT INTO kbh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Mëts̈cuaye ents̈anga! ¿Nts̈amo s̈mattsobena ts̈abe soyëngama jtsóyebuambnayana, cach ts̈ëngaftanga bacna ents̈anga s̈mojtsemnëse? Er ndayá ainanoca becá tomnama ents̈á jtsóyebuambnayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Chë ts̈abe ents̈á, chë ainanoca ts̈abe juabnënga bomnents̈ana jtsóyebuambnayana, y chë bacna ents̈ana chë ainanoca bacna juabnënga tobomnents̈ana jtsóyebuambnayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y ndegombre cbë́yana, chë ents̈angbiama ts̈abá o ndoñe ts̈abá tmonjamama jayanama tempo chaojobuache ora, ndaye ndoservena palabra s̈mojóyebuambama, Bëngbe Bëtsabe delante s̈mochanjayana ndáyeca chca ca. ");
INSERT INTO kbh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Er nts̈amo tcojtsóyebuambnama Bëngbe Bëtsá echanjayana ts̈abá o ndoñe ts̈abá tconjamama, y cmochanjauyana aíñe o ndoñe cmontsemna castiganá jtsemnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chents̈ana, básefta fariseunga y Moisesbe ley abuátambayënga Jesús tmojantjá: —Buatëmbayá, bënga fsë́ntsebos̈e aca canÿe bëts soye chacoma, acbe obenana chas̈cuinÿanÿema ca. ");
INSERT INTO kbh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","As Jesús tojanë́jua: —Quem puerte bacna ents̈anga y ndos̈buáchiyënga montsebos̈e ats̈e canÿe bëts soye chaima, ats̈be obenana jinÿanÿiyama; pero chca soye ndoñe quemochátinÿe, sinó nÿe chë ndayá yomna mo chë Bëngbe Bëtsabe juabna oyebuambnayá Jonásoftaca tojanopasá soycá. ");
INSERT INTO kbh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nts̈amo Jonás unga te y unga ibeta chë bëts beonbe uafsbioye yojëftsemncá, cachcá chë Bëngbe Bëtsá Ents̈á tbojanbemá unga te y unga ibeta fshantse jashenoye echanjë́ftsemna. ");
INSERT INTO kbh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Morsca ents̈anga ts̈abá o ndoñe ts̈abá tmonjamama Bëngbe Bëtsá yochjayana te, Nínive bëts puebloca ents̈anga mochanjotsaye y morsca ents̈angbiama mochanjayana ndoñe ts̈abá tmonjama ca; er chënga, Jonás yojtsabuayiynaye ora, tmojanoyeuná y chë ts̈abe benache tmojtanishache, y chë mora muents̈e entsemnana, Jonasbiama más uamaná endmëna. ");
INSERT INTO kbh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Morsca ents̈anga ts̈abá o ndoñe ts̈abá tmonjamama Bëngbe Bëtsá yochjayana te, chë Sur luaroca reinánaca echanjotsaye y morsca ents̈angbiama echanjayana ndoñe ts̈abá tmonjama ca; er chana chë quem luare iuajbana luarëngocana tojánabo Salomonbe osertanánaca palabrënga jouenama, y chë mora muents̈e entsemnana, Salomonbiama más uamaná endmëna ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús mënts̈ánaca tojánayana: “Canÿe bacna bayëja canÿe ents̈ábents̈ana tojésebocna ora, chë bayëjna bojojo luarënguenache jtsanana ndayents̈e jóchnama onguayiñe, y canÿe luare ndoñe tonjínÿena ora cha jenójuaboyana: ");
INSERT INTO kbh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Ats̈be oyenoye, chë ndayents̈ana sënjëftsebocnoye chanjesshë́cona ca’. Y choye tojtashjango orna, jinÿenana lempe ts̈abá cha jtesamashënguama, mo chents̈e ndocná tontsiyencá, tsjajniñe y lempe botamaniñe cuaftsemncá. ");
INSERT INTO kbh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chorna chë bayëjna jana y inÿe canÿsëfta bayëjënga chabiama más opëjënga jobiats̈ana y nÿetscanga choye jamashjnana chë boyabásabeñe joyénanama. Y chca, chë boyabása tempscama más bacna ents̈á jtsemnana, chora chë natsanama más bayëjënga abamna causa. Morsca puerte bacna ents̈ángaftaca cachcá echanjochnëngo ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús cabá ents̈anga yojtsëtsëtsnaye ora, chabe mamá y cats̈átanga tmojánashjajna y imojtsebos̈e Jesúseftaca jóyebuambayama. Nÿe shjoca imojtsemna; ");
INSERT INTO kbh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","asna, canÿe boyabása Jesúsbioye tbojanbuayená: —Acbe mamá y acbe cats̈átanga shjoca montsemna y montsebos̈e ácaftaca jóyebuambayama ca. ");
INSERT INTO kbh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús chë jauenayama tojánabioye tbojaniyana: —¿Nda ats̈be mamá yomna, y ndëmuanÿenga ats̈be cats̈átanga ca? ");
INSERT INTO kbh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y cachora chabe cucuats̈e tojanatsbaná, chabe uatsjéndayënga tojanënÿanÿé y tojánayana: —Quemënga montsemna mo ats̈be mamacá y mo ats̈be cats̈atangcá. ");
INSERT INTO kbh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Er ndánaca, nts̈amo ats̈be Taitá, celoca endmëná yobos̈cá tojtsama, jtsemnana ats̈be cats̈ata, ats̈be uabena y ats̈be mamá, ats̈be ndegombre pamillanguents̈á ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Cach te, Jesús yebnents̈ana tojë́ftsanbocna y uafjajónaye tsachoca tojanótbema. ");
INSERT INTO kbh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mallajta ents̈anga choye tmojanobeconá; as Jesús, chë uafjajónayents̈e yojanamna canÿe barquë́shoye tojánas̈ëngo, tojanótbema; y chë ents̈angna tsachoca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chorna ba soyëngama cuentë́ngaca chënga tojanabuatambá. Mënts̈á tojanë́yana: “Canÿe jená chë jénaye jaujquëshama yojë́ftsebocna. ");
INSERT INTO kbh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yojtsëjquëshaye orna, básefta jénaye benache juachañe yojuatquë́cjana, pero chë jaja shlofts̈ënga imojástjajna y lempe imojtsósañe. ");
INSERT INTO kbh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inÿe meshëngna ndëts̈benguiñe yojuatquë́cjana, ndoñe yapa fshantse binÿnents̈e. Chiñna betsco yojuábocna, fshantse ndoñe jashenocana yonjanmëna causa, ");
INSERT INTO kbh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pero shinÿe yojábocna ora, puerte yojojënÿána y yojtsancta; y yojtsábojo, bëtscá tbëtëjënga tondaye causa. ");
INSERT INTO kbh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Inÿe meshëngna uchmë́shangañe yojuatquë́cjana, y chë uchmëshangá yojuájua orna, lempe yojtsatscué. ");
INSERT INTO kbh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Y inÿe meshëngna, uanguanëshiñe yojuatquë́cjana y puerte botamana chiñe yojuashajo: ínÿenache nÿe canÿe jénayents̈ana mo patse meshënga yojuashájona, ínÿeñna mo chnë́nguana bnë́tsana meshe y ínÿeñna mo unga bnë́tsana meshe.” ");
INSERT INTO kbh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesús chca jacuéntama tojanpochocá ora, mënts̈á tojánayana: “Chë jouenama tmojtsobenënga, s̈mochjouena ca.” ");
INSERT INTO kbh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chora chë uatsjéndayënga tmojanobeconá y Jesús tmojantjá: —¿Ndáyeca ents̈anga cuentë́ngaca cojtsabuatambá ca? ");
INSERT INTO kbh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","As Jesús tojanë́jua: —Bëngbe Bëtsá ts̈ëngaftanga cmontsinÿanÿná nÿetsca chë mo iytëmencá yomna soyënga chabe amë́ndayama, pero chë ínÿengbioyna ndoñe. ");
INSERT INTO kbh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nda tojtsebomnábioye más jats̈tayana y chca cha corente bëtscá jtsebomnana; pero chë tondaye tondbomnábioyna, chë bats̈atema tobomna sóynaca mochántseboca. ");
INSERT INTO kbh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chíyeca ats̈e cuentë́ngaca chënga sëntsëtsëtsná. Chca, masque corente chamotsafs̈na, ndoñe chamondobená Bëngbe Bëtsabe soyënga jinÿama; y masque becá chë soyënga chamouena, ndoñe ts̈abá quemochátuenana, ni queochátësertana. ");
INSERT INTO kbh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chcáyecna, chë́ngbeñe entsemna cachcá nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías tojanayancá: Masque becá chamouena, ndoñe queochátësertana. Masque puerte chamotsantjes̈na, ndoñe quemochátinÿe ");
INSERT INTO kbh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quem ents̈anga ndoñe quemátsbos̈e botamana jajuaboyana; chënga uamatsáchtonënga montsemna y chëngbe bomínÿnaca cachcá. Chca ndóñesna, chënga muantsobena jinÿama, jouenama y ainaniñe josértama; y chca, chënga bacna soyënga amana muantsajbaná y ats̈be benache muantishache, as ats̈e chënga chayatsebacama ca —cha tojë́ftsanbema. ");
INSERT INTO kbh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ts̈ëngaftangna oyejuayënga s̈mochanjoyena, er s̈mondbomna bominÿe y matscuas̈ënga Bëngbe Bëtsabe soyënga jinÿama y jouenama. ");
INSERT INTO kbh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndegombre cbë́yana, banga Bëngbe Bëtsabe juabna oyebuambnayënga y nÿetsca soyënguiñe ts̈abá amënga tmonjánbos̈ena chë ts̈ëngaftanga s̈montsonÿá soyënga jinÿama, y ndoñe chemátaninÿe; tmonjánbos̈ena chë ts̈ëngaftanga s̈montsuenana soyënga jouenama, y ndoñe chemátanuena ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Chcasna, oído s̈mochjajajo; chë jenabe cuento mënts̈á endayana: ");
INSERT INTO kbh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chë Bëngbe Bëtsabe amë́ndayama tmojouena y ndoñe tontsë́sertana ents̈anga mondmëna mo chë benache juachañe yojuatquë́cjana jenaycá; Satanás jabana Bëngbe Bëtsabe palabra chëngbe ainanents̈ana jabétsabuajuanama, chënga chiñe ndoñe chamondëtsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Y chë ndëts̈benguiñe yojuatquë́cjana jénaye entsemna mo chë aíñe Bëngbe Bëtsabe palabra tmojouena y Bëngbe Bëtsábeñe jtsos̈buáchiyama oyejuayënga tmojtsemna ents̈angcá; ");
INSERT INTO kbh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero ndoñe nÿets tempo chana jocochájuana, y chca, ndoñe bayté Bëngbe Bëtsáftaca ntjëftsemnëngana, ndoñe yapa tmontsas̈buaché causa. Inÿenga chë́ngbioye mochantsë́buayënja y Bëngbe Bëtsábeñe betsos̈buáchiyama mochanjasúfrianga; chíyeca chënga Bëngbe Bëtsabe palabra cachcá mochanjesonÿaye. ");
INSERT INTO kbh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chë uchmë́shangañe yojuatquë́cjana jénaye entsemna mo chë Bëngbe Bëtsabe palabra tmojouena ents̈angcá, pero quem luarents̈a soyë́ngaca oyejuayënga jtsemnama yapa mochántsenojuabnaye y mallajta crocénana y ba soyënga jtsebomnama mochántsebos̈e. Chíyeca chënga Bëngbe Bëtsabe palabra jtsebnë́tjombana y nts̈amo cha tojayancá ndoñe ntsamana. ");
INSERT INTO kbh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero chë uanguanëshiñe yojuatquë́cjana jénaye entsemna mo chë Bëngbe Bëtsabe palabra tmojouena y botamana jósertana ents̈angcá. Mo canÿe betiye puerte ts̈abá tojtseshajuancá, chënga bëtscá ts̈abe soyënga Bëngbe Bëtsabiama mochántsama. Inÿengna ínÿengbiama más bëtscá soyënga mochántsama, y chca, ínÿenga jtsemnana mo chë patse meshënga tojanshajo jenaycá, ínÿenga mo chë chnë́nguana bnëtsancá y ínÿengna mo chë unga bnë́tsana meshënga tojanshajo jenaycá ca” —Jesús tojanabuayená. ");
INSERT INTO kbh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús mënts̈ánaca tojanacuntá: “Bëngbe Bëtsabe amë́ndayana endmëna mo chë ts̈abe jenaycá, canÿe boyabása chabe jajañe yojáje. ");
INSERT INTO kbh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero nÿetscanga imojtsomañe orna, chabe uayayá yojáshjango y chë trigo jeniñe bacna shácuana yojesejé y yojtsatoñe. ");
INSERT INTO kbh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Y chë trigo yojuájua y ya yojtseshajuana orna, chë bacna shácuanënaca yojuábocna. ");
INSERT INTO kbh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","As chë peonga imojá chë nduiño jauyanama: ‘Bacó, chë jajañe ts̈abe jénaye tconjanjé y as, ¿ndáyeca chë bacna shácuana chiñe tojuábocna ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y chë nduiño yojáuyana: ‘Ats̈be uayayá chca tojama ca.’ Chora chë peonga imojatjaye: ‘¿Quectsebos̈e bënga fchayá chë bacna shácuana jetsejashtsëtsama ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero chë nduiño yojáuyana: ‘Ndoñe. Chë bacna shácuana s̈mojtsejashtsëtsana ora, chë trígnaca s̈mattsejashtse ca. ");
INSERT INTO kbh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Más ts̈abana, cachcá mochjonÿaye cánÿiñe chaójuama, chë jaja saná játbanama tempo chaojobuáchëntscuana. Chora chë trabájayënga chanjichamuá y chanjámëndaye natsana chë bacna shácuana chamotsejashtsëtse y chamotsentsacuacjuá jtsejuinÿiyama, y chents̈ana chë shajuana chamuatbaná y ats̈be grano uaquëcjnaye yebniñe chamotsatsuamá ca’ ” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús mënts̈ánaca tojanacuntá: “Bëngbe Bëtsabe amë́ndayana endmëna mo canÿe mostaza betiye jenaycá, canÿe boyabása chabe jajañe yojáje. ");
INSERT INTO kbh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndegombre, nÿetsca jenayëngama chë mostaza jénaye chë más básetema endmëna, pero tojójua orna, chë jajañents̈e chë más bëts betiye jóbemana. Ts̈a bëts betiye jtsemnana, chíyeca ba buacuashangá jtsabomnana y chë jaja shlofts̈ënga jana y chiñe uajajonëtemëngá jauábopormana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Quem inÿe cuéntnaca tojanë́yana: “Bëngbe Bëtsabe amë́ndayana endmëna mo levadurcá; canÿe shembása chana jenájuabana unga medida arninÿañe, nÿetsana chauabochama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús nÿetsca chë soyëngama lempe cuentë́ngaca ents̈anga jtsëtsëtsnayana, y cuentë́ngaca ndóñesna ndoñe yonjanoyebuambná. ");
INSERT INTO kbh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chca yojamna ndayá cachcá chaochnënguama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá tojanayancá, mënts̈á: Jabuátambamna cuentë́ngaca chanjóyebuambaye; chanjayana chë iytë́mena soyëngama y chë ents̈anga ndoñe mondë́tats̈ëmbo soyëngámnaca; Bëngbe Bëtsá quem luare tojanma orscana chë soyënga yomna ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chents̈ana Jesús chë ents̈anga tojtanichamó y yebnoye tojtanamáshëngo. Chents̈na chabe uatsjéndayënga tmojanimpadá ndayá chë bacna shacuanama cuento betsayancá chauabuayenama. ");
INSERT INTO kbh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","As Jesús tojanë́yana: “Chë ts̈abe jénaye jená endmëna chë Bëngbe Bëtsá Ents̈á tbojanbemá, ");
INSERT INTO kbh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","y chë jajañna, quem luare. Chë ts̈abe jénaye entsemna chë Bëngbe Bëtsabe amë́ndayoye mochjámashjna ents̈anga, y chë bacna shácuana entsemna chë bacna bayëjëngbe amëndayabe ents̈anga, ");
INSERT INTO kbh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","y chë uayayá, chë bacna shácuana yojáje chana, Satanás. Chë jaja saná atbanayana entsemna chë quem luare jopochócama chaojobuache ora, y chë trabájayëngna chë angelotémënga. ");
INSERT INTO kbh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nts̈amo chë bacna shácuana jtsejashtsëtsana y iñoye jtsatmets̈ana jtsejuinÿiyama, cachcá echántsemna quem luare jopochócama te. ");
INSERT INTO kbh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chorna, chë Bëngbe Bëtsá Ents̈á tbojanbemá chabe angelotémënga echanjichamuá chë ínÿenga bacna soye chamomama amënga y chë bacna soyënga amënga chabe amë́ndayents̈ana chamotsajuanayama. ");
INSERT INTO kbh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y chora chë́ngbioye chë uabouana íñeshoye mochantsë́setjango y chents̈e puerte mochanjenóbos̈achna y chë tsets̈anama juatsas̈ënga mochantsenoftë́s̈jojnaye. ");
INSERT INTO kbh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chora, chë nts̈amo Bëngbe Bëtsá yomandacá amëngna corente mo shinÿcá mochantsebuashinÿinÿana chëngbe Taitá, Bëngbe Bëtsabe amë́ndayoca. Chë jouenama tmojtsobenënga, s̈mochjouena ca” —chora Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Bëngbe Bëtsabe amë́ndayana endmëna mo chë fshantsiñe uaiytë́mena bomnancá. Canÿe boyabása chë bomnana yojuínÿena y chents̈ana iytëcana cachents̈e yojesatbontsá. Corente oyejuayá yojtá, nÿetsca chabe bomna soyënga yojetsatobuiye y chents̈ana chë fshantse yojtobuámiñe ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mo canÿe ents̈á uámana fjantse ndëts̈ëtémënga obuamnañacánaca endmëna chë Bëngbe Bëtsabe amë́ndayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chana, canÿe corente uámana ndëts̈ëtema yojínÿena ora, yojtá y lempe chë inabomna soyënga yojetsatobuiye y chë ndëts̈ëtema yojtobuámiñe ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Bëngbe Bëtsabe amë́ndayana endmëna mo canÿe atarraiëshacá, buyeshoye juts̈enana y nÿetsca beonga jashebuáyana. ");
INSERT INTO kbh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chë atarraië́sha jútjena tojtsamna orna, chë beonga ashebuánayënga jtsashëbjátsëcana, tsachoye juyambana y chents̈e juatbemana chë beonga jabocacayama; chë ts̈ábenga sbarëquënguiñe juatsuámana y chë ndoñe ts̈ábengna jtsëts̈anana. ");
INSERT INTO kbh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Cachcá echanjochnëngo quem luare jopochócama tempo chaojobuache ora. Chë angelotémënga mochanjábocana chë ts̈abe ents̈ángbents̈ana bacna ents̈anga jaluárama, ");
INSERT INTO kbh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","y chë bacna ents̈angna chë uabouana íñeshoye mochántsatquëcjaye, y chents̈e puerte mochanjenóbos̈achna y chë tsets̈anama juatsas̈ënga mochantsenoftë́s̈jojnaye ca” —Jesús tojanacuntá. ");
INSERT INTO kbh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chora chabe uatsjéndayënga Jesús tojanatjá: —¿Lempe chama quecmojtsë́sertana ca? Y chënga tmojanjuá: —Arseñor, aíñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","As Jesús tojanë́yana: —Canÿe ley abuatambayá jtsetats̈ëmbuana ndayá Bëngbe Bëtsá tempo Moisesbiajana yojanoyebuambná soyëngama. Nts̈amo Bëngbe Bëtsabe amë́ndayana bétsemnama cha tojtsatsjendá orna, mo canÿe yebnents̈a nduiñcá cha jtsemnana. Chë nduiñna chabe grano uaquëcjnaye yebnocana anteo y tsëm uámana bomnana juabocnana. Cachcá chë ley abuatambayá, Bëngbe Bëtsabe soyëngama jtsabuátambayana chë tempo Bëngbe Bëtsá tojanoyebuambá soyëngama y chë tsëm soyë́ngnaca Bëngbe Bëtsabe amë́ndayama ca —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús chë soyënga jacuéntama tojanpochocá ora, chents̈ana tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Y cachabe luaroye tojtanashjango y chents̈a judiëngbe enefjuana yebnents̈e tojanonts̈é jabuátambama. Ents̈anga ojnanánënga imojtsichamo: —¿Chë lempe yojtsetats̈ëmbcá ndë́moca mua tojuatsjinÿe ca? ¿Nts̈amo nantsobena chca bëts soyënga jamama ca? ");
INSERT INTO kbh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Mua ndoñe yondmëna chë calpinterbe uaquiñá y chabe mamá ndoñe María? ¿Mua ndoñe yondmëna Santiago, José, Simón y Júdasbe cats̈ata, ");
INSERT INTO kbh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","y chabe uabénanga ndoñe muents̈e bë́ngaftaca mondoyena? ¿Ndayents̈ana lempe chca mua yojtsebomna ca? —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y chë causa chë ents̈anga tmojanotjayaná y ndoñe imontsebos̈e cha joyeunayana. Pero Jesús tojanë́yana: —Nÿetsquénache canÿe Bëngbe Bëtsabe juabna oyebuambnayá bëtsá jabemëngana, pero cachabe luarents̈e, cachabe yebnents̈e ndoñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chíyeca chents̈e Jesús ndoñe tonjë́ftsanma ba bëts soyënga Bëngbe Bëtsabe obenánaca, chë ents̈anga chábeñe ndoñe montsanos̈buaché causa. ");
INSERT INTO kbh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chë tempo, Rey Herodes, chë Galileoca mandayá tojanuena nts̈amo nÿetsca ents̈anga Jesucristbiama imojtsichamcá. ");
INSERT INTO kbh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","As cha chabe oservénënga tojanë́yana: “Mua Juan chë Ubayaná ctsemna, obanënguents̈ana tojtayena, chíyeca chca obenana bëts soyënga jamama yojtsebomna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Juan cabá ainá ora, Herodes tojanmandá cha chamishache, cadenë́juangaca chamobátsëca y chca cárceloye jutámiama. Herodes chca tojanma Herodíasbe causa, chabe cats̈ata Felipbe shema. ");
INSERT INTO kbh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan Heródesbioye mënts̈á ibnauácacana: “Ndoñe quenátslesenciana aca acbe cats̈atbe shémaftaca jobouamayama, acbe cats̈ata cabá ainá yotsomñe ora ca.” ");
INSERT INTO kbh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y chama Herodes yojtsebos̈e Juan jóbana, pero ents̈angbiama yojtsauatja, er chënga imnajuabnaye Juan ndegombre Bëngbe Bëtsabe obenánaca yojanoyebuambná ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero Heródesbe cumpleaño oboyejuaye ora, Herodíasbe bembe ents̈angbe delante tojanlantsá y Herodes puerte chama yojtsóyejuaye. ");
INSERT INTO kbh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chíyeca Herodes, jajúrase, tbojans̈buachená ndayánaca jats̈etayana, nts̈amo tbojotjañcá. ");
INSERT INTO kbh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Y Herodíasna lempe bémbëbioye ibojabuayená nts̈amo Herodes jojuama. As chë bembe tbojaniyana: “Canÿe s̈cneniñe Juan chë Ubayanabe bests̈as̈e s̈mats̈etá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes chë soyama tbojanongmé, pero chë ófjanëngbe delante jajúrase tbojans̈buachená causa, yojamánda chca chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Y as tojanmandá chë Juan yojanëtámenoca chabe bests̈as̈e chamuetsë́stjanguama. ");
INSERT INTO kbh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chents̈ana, canÿe s̈cneniñe chë bests̈as̈e tmojanamba y chë tobias̈e tmojanënts̈abuaché y chana, chabe mamábioye. ");
INSERT INTO kbh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chents̈ana, Juanbe ústonënga tmojánashjajna, chabe cuerpo tmojésanocñe y tmojána jauátbontsama. Y chora, Jesús yojtsemnoye chënga tmojána y chë soyëngama tmojancuentá. ");
INSERT INTO kbh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús chca tojanuena ora, canÿe barquë́shañe tojtsanoñe canÿe bën luaroye, ents̈anga ndoyena luaroye. Pero ents̈anga chama imojátats̈ëmbona y chë pueblënguents̈ana tmojánbocana shecuáts̈eca cha juastama. ");
INSERT INTO kbh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chents̈ana, chë barquë́shoicana tojtanastjango ora, Jesús ba ents̈anga tojánanÿe, chë cha tmojánguanguënga. Chëngbiama tbojanongmé y chë ents̈anguents̈ana ba s̈oquënga tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ya jetiñe yojtsemna, chíyeca chë uatsjéndayënga Jesúsbioye tmojanobeconá y tmojaniyana: —Ya jetiñe entsemna y quem luariñe ndocná quenatiyena. Ents̈anga cuantichamuá, pueblotémëngoye chamotsoñama, saná chamobuámiñama ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","As Jesús tojanë́jua: —Ndoñe quenátsiyta chënga chamotsatoñama. Ts̈ëngaftanga saná s̈mochjacaredádaye ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y chënga tmojanjuá: —Muents̈e tondaye queftsátsbomna; nÿe shachna tandës̈e y uta beónata ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","As Jesús tojanë́yana: —Chë soyënga moye miyëbo ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Chents̈ana Jesús tojanmandá ents̈anga chamoshë́ntsjatbiamama. Chorna, chë shachna tandës̈e y chë uta beónata tojanca, celoye tojanontjes̈é y Bëngbe Bëtsábioye chama tbojtanchuá. Chora chë saná tojanjatá, chabe uatsjéndayënga tojanëjátaye, y chëngna nÿetsca ents̈anga tmojanacaredadó. ");
INSERT INTO kbh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nÿetsca ents̈anga tmojanse jtoshachaye nÿets̈á y cabá chë ojamnëtémëngaca bnë́tsana uta sbarë́cua tmojanajutjé. ");
INSERT INTO kbh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chë tmojansënga imojamna mo shachna uaranga boyabásenga, shembásenga y básenga ntjacuntacá. ");
INSERT INTO kbh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chents̈ana, Jesús chabe uatsjéndayënga tojanamëndá chë barquë́shoye jtamashjnama y chë uafjajónaye chenguánoica chabe natsana jashjajnana. Chëntscuana Jesús ents̈anga yojtichamuá. ");
INSERT INTO kbh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nÿetscanga tojtanichamó orna, Jesús canÿe tjoye tojántsjua canÿa jtsemnama, Bëngbe Bëtsáftaca jencuéntama. Yojaibétata ora, cha canÿa chents̈e yojtsemna, ");
INSERT INTO kbh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","y chë barquë́shana tsachocana bënoca yojtsamna. Y chë olëshënga chë barquë́sha yojtsájants̈etaye, chë binÿia chëngbe contra yojtsemna causa. ");
INSERT INTO kbh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ya bínÿanoyna, Jesús chë́ngbioye yojobeconá; béjaye juatsbuacá yojtsaye. ");
INSERT INTO kbh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Chabe uatsjéndayënga chca cha tmojáninÿe orna, ts̈a imojocochauatjaná y puerte auatjanánënga tmojanoyó: —¡Canÿe añemëse entsemna ca! ");
INSERT INTO kbh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero chora Jesús tojanë́yana: —¡Añemo s̈mochtsebomna, ats̈e Jesús sëndmëna; ndoñe matauatjëngana ca! ");
INSERT INTO kbh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chora Pedro, Jesúsbioye tbojaniyana: —Bëngbe Utabná, ndegombre aca tcojtsemnëse, momandá ats̈e béjaye juatsbuacá ácbioye chayá ca. ");
INSERT INTO kbh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y Jesús tbojaniyana: —Mabo ca. Chora Pedro chë barquë́shoicana tojánastjango y tojanonts̈é béjaye juatsbuacá Jesúsbioye jama. ");
INSERT INTO kbh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero chë binÿia ts̈a jabuache yojtsemnama tojáninÿe ora, Pedro puerte yojtsauatja y tbojanonts̈é jtsenatjë́mbambana. Chíyeca cha jabuache tojanchembo: —¡Bëngbe Utabná, s̈matsbocá ca! ");
INSERT INTO kbh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y cachora Jesús tbojtanobuácuetënts̈iye y tbojaniyana: —¡Ts̈a bats̈atema os̈buachiyá! ¿Ndáyeca ndoñe bëtscá áts̈beñe contsos̈buaché ca? ");
INSERT INTO kbh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chents̈ana chë barquë́shoye chata tbojtanamáshëngo y cachora chë binÿia bonguana yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y chora, chë barquë́shoye imojtsemnënga Jesusbe shecuats̈ents̈e tmojanoshaments̈é y tmojaniyana: —¡Aca ndegombre Bëngbe Bëtsabe Uaquiñá comna ca! ");
INSERT INTO kbh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Chë uafjajónaye tmojánenashbuachengo y canÿe luare Genesaret ca uabáinoye tmojánashjajna. ");
INSERT INTO kbh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chents̈a ents̈anga Jesús tmojantëmbá ora, chë luarents̈a nÿetsca ents̈anga chama tmojántats̈ëmbona. As chë ents̈anga chëngbe s̈oquënga Jesúsbioye tmojanënatse. ");
INSERT INTO kbh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y imojtseimpadana nÿe mo chabe ents̈ayá sibiájuanaca juabojajuama chë s̈oquënga chaualesenciama. Y nÿetscanga chabe ents̈ayá sibiájua tmojanábojajënga, shnánënga imojtsatoquédaye. ");
INSERT INTO kbh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chora básefta fariseunga y judiëngbe ley abuátambayënga, Jerusalenocana tmojánabënga, Jesúsbioye tmojanobeconá y tmojaniyana: ");
INSERT INTO kbh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ndáyeca acbe uatsjéndayënga ndoñe montsama chë nts̈amo bëngbe bëts taitanga monjanamancá ca? ¿Ndáyeca ndoñe ntsacuents̈abiana ndayá jasama ora, nts̈amo bënga chë judiënga fsënduamancá, Bëngbe Bëtsabe delante ts̈ábenga jtsatsmënama ca? ");
INSERT INTO kbh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","As Jesús tojanë́jua: —¿Y ndáyeca ts̈ëngaftanga ndoñe s̈montsama nts̈amo Bëngbe Bëtsá tojanmandacá, nÿe cach ts̈ëngaftangbe bëtsë́tsanga imnétsama soyënga jtsamama ca? ");
INSERT INTO kbh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bëngbe Bëtsá mënts̈á tojanmandá: “Acbe bëtsë́tsata stëts̈oye ndoñe catjáquedaye”, y “nda cachabe bëtsë́tsatbiama podesca tojóyebuambase, chana jóbanama jtsemnana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero ts̈ëngaftanga s̈mondbétsichamo canÿe ents̈á canobena chabe taitá o chabe mamá jauyanana: “Lempe nts̈amo sëndbomncá Bëngbe Bëtsá jasérviama entsemna, chíyeca tondaye quetsátsbomna aca juajabuáchama ca”; ");
INSERT INTO kbh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","y s̈mondbétsichamo nÿe ndánaca chca tojayanëse, ya ndoñe ntsemnana chabe taitá o chabe mamá stëts̈oye ndoñe ntjaquédana, ni ntjuajabuáchana ca. Y chca, ts̈ëngaftangbiama tondaye ntsámanana nts̈amo Bëngbe Bëtsá tojanmandacá, y aíñe s̈montsama nts̈amo ts̈ëngaftangbe bëtsë́tsanga imojanamancá. ");
INSERT INTO kbh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Bacna ents̈anga, nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga! Nÿe ts̈abá chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías ts̈ëngaftangbiama tojanoyebuambá, mënts̈á tojánayana ora: ");
INSERT INTO kbh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bëngbe Bëtsá tonjayana: “Quem ents̈anga mondbétsichamo Bëngbe Bëtsá ts̈a ts̈abia yomna ca; chca nÿe uayás̈aca, pero chëngbe ainanents̈e ats̈biama ndocna ts̈abe juabnë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chënga nÿe bonamente mondbétsichamo: Bëngbe Bëtsá ts̈a ts̈abia yomna ca; chënga nÿe ents̈angbe mandënga jtsabuátambayana y Bëngbe Bëtsabe mandënga ndoñe ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chents̈ana Jesús ents̈anga tojánachembo y tojanë́yana: —S̈mochjouena y chacmësertá. ");
INSERT INTO kbh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndayá ents̈á tojtsesacá, ndoñe quebochátsbema Bëngbe Bëtsabe delante ndoñe ts̈abia. Inÿets̈á comna: ndayá ents̈á tojtsejuabná y tojtsoyebuambnacá endobena cha jabemana Bëngbe Bëtsabe delante ndoñe ts̈abia ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chora chë uatsjéndayënga Jesúsbioye tmojanobeconá y tmojaniyana: —¿Quéctsetats̈ëmbo, nts̈amo tconjayanama chë fariseunga ndoñe ts̈abá chenatëuénana ca? ");
INSERT INTO kbh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","As Jesús tojanë́jua: —Ndaye betiye ats̈be Taitá celocá ndoñe tonjájese, tbëtëjocana mochántsejashtse. Cachcá echanjama chë nÿe ents̈angbe buatëmbana soyë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cachcá mónÿaye; chënga montsemna mo jtanënga inÿe jtanënga unachayëngcá. Y canÿe jtaná inÿe jtaná tbojtsánachase, nÿets útata canÿe tbuabents̈e bochanjetsótsats̈e ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chora Pedro, Jesúsbioye tbojaniyana: —Nts̈amo chë cuento bétsayanama s̈mabuayená ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","As Jesús tojanë́jua: —¿Ts̈ëngaftángnaca cabá ndoñe cmontsë́sertana ca? ");
INSERT INTO kbh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Cabá ndoñe cmontsë́sertana lempe nts̈amo s̈mojascá uafsbioye jomashënguana y chents̈ana cuerpents̈ana jtabocnana? ");
INSERT INTO kbh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero nts̈amo s̈mojtsoyebuambnacana lempe ainanocana jtsóbocanana y chë soye endobena ts̈ëngaftangbioye Bëngbe Bëtsabe delante ndoñe ts̈ábenga jábiamana. ");
INSERT INTO kbh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ainanocana jtsóbocanana bacna juabnënga: jenóbama, shema o boyábioye ínÿaftaca jaíngñama, shembása o boyabásaftaca bacna soye jamama, jatbëbama, jobostérama y ínÿabiama jtsayátsenayama. ");
INSERT INTO kbh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chë soyënga cocayé jtsobenana ents̈ábioye Bëngbe Bëtsabe delante ndoñe ts̈abia jabemama; pero chë ndoñe ntsacuents̈abiana ndayá jasama ora, ndoñe ntsobenana Bëngbe Bëtsabe delante ndoñe ts̈abia jabemama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús chents̈ana, Tiro y Sidón luarëngoye tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canÿe shembása Caná luarocá chents̈e inoyena; cha Jesúsbioye yojobeconá y mënts̈á yojtsáyebuache: —¡Utabná, Rey Davídbents̈ana Ents̈á, s̈motselastemá! ¡Ats̈be bembe puerte entsesufrina, bacna bayëjbe juabna entsebomna causa ca! ");
INSERT INTO kbh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús ndocá tbonjanjuá. As chabe uatsjéndayënga tmojanobobeconá y tmojanimpadá: —Chë shembása mëyana chaotsatoñe; bëngbe ústonoye yapa entsáyebuache ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","As Jesús tojánayana: —Bëngbe Bëtsá ats̈e s̈onjichmó jtsanÿenama nÿe chë ents̈anga, chë mo óts̈ena oveshëngcá imomnënga Israeloquënga, y chë ndoñe judiëngna ndoñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero chë shembása tojána, Jesusbe shecuats̈ents̈e tojanoshaments̈é y tbojaniyana: —¡Utabná! Diosmanda pavor s̈motsebema. ¡S̈motsajabuache ca! ");
INSERT INTO kbh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Y Jesús tbojanjuá: —Chë judiënga mondmëna mo Bëngbe Bëtsabe basengcá y ats̈e ácbioye tcbojuajabuache y chë́ngbioye ndóñesna, nántsemna mo chë básengbe saná chënga cuaftsëbaquëcá y ques̈ënga ftsëbuajocá. Chca jamana ndoñe ts̈abá quenátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","As cha tbojanjuá: —Arseñor. Pero chë ques̈ë́ngnaca chëngbe nduiñëngbe mesë́shents̈ana tmojatquë́cjanatemënga mondbase, chë nduiñënga tmojtsesá ora. Chcasna, Diosmanda s̈motsajabuache ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chora Jesús tbojaniyana: —¡Shembása, Bëngbe Bëtsábeñe ts̈a os̈buachiyá comna! Nts̈amo cojtsebos̈cá chca chaotsemna ca. Y cach orscana chabe bembe ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús chents̈ana tojë́ftsanbocna y chë Galilea uafjajónaye tsachoye tojána. Chents̈ana, canÿe batsjoye tojántsjua y choca tojanótbema. ");
INSERT INTO kbh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mallajta ents̈anga Jesús yojtsemnents̈e tmojánashjajna, y coshetënga, jtanënga, ts̈abá jobónjuama ndobenënga, ndëbianga y ba s̈ocana bomnënga imojtsënachaye. Jesusbe shecuats̈ents̈e tmojanë́shejango y cha nÿetscanga tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Y chca orna, chë ents̈anga tmojáninÿe: chë ndëbianga imojtsatoyebuambná, chë ts̈abá jobónjuama ndobenënga ts̈abá imojtsatsmëna, chë coshetënga ts̈abá imojtsatana y chë jtanëngna yojtsëbinÿna; y chama chënga corente ojnanánënga imojtsemna. Chora chënga tmojanonts̈é jëtschuayana chë Israelents̈a ents̈anga imojánadorana Bëngbe Bëtsá. ");
INSERT INTO kbh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chents̈ana Jesús, chabe uatsjéndayënga tojánachembo y tojanë́yana: —Quem ents̈angbiama s̈ontsengmena, er ya unga te chënga áts̈eftaca muents̈e montsemna y jasama tondaye quemátsbomna. Ats̈e ndoñe quetsátsbos̈e ntjascá cachëngbe yebnoye chënga jtichamuana, er benachiñe shëntsama nantsabuatëcja ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","As chabe uatsjéndayënga tmojantjá: —¿Nts̈amo muatjobenaye quem luarents̈e, ndocna ents̈á ndoyenents̈e, chëfta ents̈angbiama saná jinÿenama ca? ");
INSERT INTO kbh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Y Jesús tojanatjá: —¿Bueta tandës̈e s̈mojtsebomna ca? Y chënga tmojanjuá: —Canÿsëfta tandës̈e y básefta beonatémënga ca. ");
INSERT INTO kbh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chora Jesús tojanamëndá nÿetsca ents̈anga fshantsiñe chamotbiamama. ");
INSERT INTO kbh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","As chë canÿsëfta tandës̈e y chë beonatémënga tojanca; Bëngbe Bëtsábioye chama tbojtanchuá, chë saná tojanjatá y chabe uatsjéndayënga tojanëjatá. Chents̈ana nÿetsca ents̈ángbioye tmojanacaredadó. ");
INSERT INTO kbh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nÿetsca ents̈anga tmojanse jtoshachaye nÿets̈á. Y chents̈ana cabá canÿsëfta bëts sbarë́cua tmojanajutjé chë tojanójamëtemëngaca. ");
INSERT INTO kbh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chë tmojansënga imojamna canta uaranga boyabásenga, shembásenga y básenga ntjacuntacá. ");
INSERT INTO kbh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chents̈ana Jesús, chë ents̈anga tojtanichamó, barquë́shoye tojánamashëngo y Magadán luaroye tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseunga y saduceunga tmojána Jesús jinÿama, y jisháchichiyama imojtseimpadana canÿe bëts soye chaoma, as jtsetats̈ëmbuama Jesusbe obenana ndegombre Bëngbe Bëtsábiocana tainóbocanama. ");
INSERT INTO kbh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Jesús tojanë́jua: “Ts̈ëngaftanga jetiñoye s̈mondbétsichamo: ‘Yëfse ts̈abe te echántsemna, er celoca buánganiñe entsemna ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y cachëse s̈mondbétsichamo: ‘Mënté echanjuafté, er celoca buánganiñe y ibetiñe entsemna ca.’ Ts̈ëngaftanga celoye jontjes̈iyëse, nts̈amo chë tempo yochtsemnama ts̈a ts̈abá jayanama s̈mojtsobenëse, ¿ndáyeca ndoñe s̈montsobena jtsetats̈ëmbuana ndaye bëts soye Bëngbe Bëtsá quem tempo cmojtsinÿanÿnama? ");
INSERT INTO kbh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Quem puerte bacna ents̈anga y ndos̈buáchiyënga montsebos̈e ats̈e canÿe bëts soye chaima, obenana jinÿanÿiyama; pero ndoñe chca quemochátinÿe, sinó nÿe chë ndayá yomna mo chë Bëngbe Bëtsabe juabna oyebuambnayá Jonásoftaca tojanopasá soycá ca” —Jesús tojánayana. Chora Jesús tojésanabashejuana y chents̈ana tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Chë uafjajónaye chenguanoicana chënga tmojtanabo ora, chë uatsjéndayënga yojésebnëtjomba tandës̈e jesocñana. ");
INSERT INTO kbh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chora Jesús tojanë́yana: —S̈mochtsantjes̈na; cuedado s̈mochtsebomna chë fariseunga y saduceungbe levadurama ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pero chë uatsjéndayëngna imojtsenatsëtsnaye: —Chca entsichamo, bënga tandës̈e ndoñe tmonjesocñama ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús chë soye yojtsetáts̈ëmbo; chíyeca mënts̈á tojanë́yana: —¿Ndáyeca tandës̈ama s̈mojtsenatsëtsná ca? ¡Ts̈a bats̈atema os̈buáchiyana s̈mobomna! ");
INSERT INTO kbh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cabá ndoñe cmontsë́sertana y ndoñe s̈montsabouínÿna chë shachna tandës̈ents̈ana shachna uaranga ents̈anga sënjanëjuats̈ema y bnë́tsana uta sbarë́cua s̈monjánajutjema? ");
INSERT INTO kbh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Y ndoñe s̈montsabouínÿna chë canÿsëfta tandës̈ents̈ana canta uaranga ents̈anga sënjanëjuats̈ema y canÿsëfta sbarë́cua s̈monjánajutjema? ");
INSERT INTO kbh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ndáyeca ndoñe cmontsë́sertana ats̈e tandës̈ama ndoñe sëntsóyebuambnama? Cuedado s̈mochtsebomna fariseunga y saduceungbe levadurama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","As chora chë uatsjéndayënga tojanësertá, Jesús ndoñe tonjánayana chë tandës̈ents̈a levadurama cuedado jtsebomnana ca, sinó ndayá chë fariseunga y saduceungbe buatëmbana soyëngama. ");
INSERT INTO kbh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús, Cesarea de Filipo luaroye tojánashjango ora, chabe uatsjéndayënga tojanatjá: —¿Nda ca ents̈anga imojtsichamo chë Bëngbe Bëtsá Ents̈á tbojanbemá yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chënga tmojanjuá: —Báseftanga montsichamo Juan chë Ubayaná ca, ínÿengna Elías ca, ínÿengna Jeremías y ínÿengna tempsca inÿe Bëngbe Bëtsabe juabna oyebuambnayá ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","As Jesús tojanatjá: —Y ts̈ëngaftangna, ¿nda ats̈e bétsemnama nts̈amo s̈mochjayana ca? ");
INSERT INTO kbh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chora Simón Pedro tbojanjuá: —Acna chë Bëngbe Bëtsabe Uámana Uabuayaná condmëna, chë Bëngbe Bëtsá Ainabe Uaquiñá ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y Jesús tbojaniyana: —Simón, Jonasbe uaquiñá, oyejuayá cochanjoyena. Ndocna quem luarents̈a ents̈á chë soye checmatinÿinÿé, sinó ats̈be Taitá, celoca endmëná. ");
INSERT INTO kbh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Y mënts̈ánaca cbëyana: Mora acna Pedro o chë ndëts̈becá contsemna, y chë ndëts̈beñe ats̈be bëts yebna chanjajebo, y ni Satanás, chabe obenánaca ents̈á jóbanama, queochatobenaye jtsepochócama. ");
INSERT INTO kbh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ats̈e cbochanjáts̈etaye obenana, mo llavëfjcá, ents̈anga Bëngbe Bëtsabe amë́ndayoye jamashënguama chamobenama. Bëngbe Bëtsáftaca chacojtsencuénta ora, canÿe soye ndoñe chaondë́tsemna ca chacojayanëse, Bëngbe Bëtsá cachcá echanjayana. Y cháftaca chacojtsencuénta ora, canÿe soye aíñe chaotsemna ca chacojayanëse, Bëngbe Bëtsá echanjayana aíñe chca chaotsemna ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chents̈ana chabe uatsjéndayënga tojanamëndá ndocnábeñe ntsecuéntayana cha, Jesús, chë Bëngbe Bëtsabe Uámana Uabuayaná, chë Cristo bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chorscana Jesús tojanonts̈é chabe uatsjéndayënga jábuayenana cha ibojtsemna Jerusalenoye jama, y chocna chë bëtsëjemëngcá mándayënga, chë judiëngbe bachnangbe amë́ndayënga y chë ley abuátambayënga mochjanma cha puerte chaopadecema ca. Tojanë́yana cha mochjanóba, pero unga tianoye yochtanayena ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chora Pedro, Jesúseftaca tojanoluaré y tojanonts̈é mënts̈á uatsëtsnayana: —¡Ats̈be Utabná, Bëngbe Bëtsá ndoñe chaondëlesenciá chca chaopasama! ¡Ndocna te quenaisopodena chca ácaftaca jopásana ca! ");
INSERT INTO kbh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","As Jesús tojanobuértana y Pédrëbioye tbojaniyana: —¡Satanás, áts̈bents̈ana mojuaná! ¡Aca contsebos̈e ats̈e canÿe bacna soye chas̈ócochënguama! Pedro, acbe juabnënga Bëngbe Bëtsábiocana ndoñe quenatóbocana, sinó nÿe ents̈ángbents̈ana ca. ");
INSERT INTO kbh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chents̈ana Jesús chabe uatsjéndayënga tojanë́yana: —Nda ats̈be uatsjendayá jtsemnama tojtsebos̈e, cháuayana nÿe Bëngbe Bëtsá yobena sempre chabe vidiñe jtsemándayana ca, chabe quem luarents̈a soyënga cachcá chauesonÿá ats̈e juastama, y ats̈biama jasúfriama chaotseprontana y cruciñe jobanámnaca. ");
INSERT INTO kbh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nda tojtsama quem luarents̈e bëtscá soyënga jtsebomnama y ats̈biama jasúfriama ndoñe tontseprontana, chë nÿetsca tescama yomna ts̈abe vida echanjopérdia. Pero nda quem luarents̈a soyënga cachcá tojëftsonÿá ats̈e juastama, masque chaóbana, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ndayama ents̈á buanjosérvia nÿetsca quem luarents̈a soyënga jtsebomnana, chë nÿetsca tescama yomna ts̈abe vida tojtsoperdese? Ndegombre, canÿe ents̈á chë nÿetsca tescama yomna ts̈abe vida tojtsoperdese, ndocna soye quenátsmëna cha chaobená joyiyama, chë nÿetsca tescama yomna ts̈abe vida jtsebomnama. ");
INSERT INTO kbh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chë Bëngbe Bëtsá Ents̈á tbojanbemá, chabe Taitabe obenánaca y puerte buashinÿinÿaniñe echanjabo chabe angelotémëngaftaca, y chora cada cánÿabioye bochántats̈etaye cachcá nts̈amo cada ona tojëftsemcá. ");
INSERT INTO kbh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ndegombre s̈cuayana: Báseftanga muents̈e montsemnënga ndoñe quemochatóbana, Bëngbe Bëtsá Ents̈á tbojanbemá amëndayacá jabana ntjëftsinÿcá ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chents̈ana chnë́nguana tianoye, Jesús tojë́ftsanëbiats̈e Pedro, Santiago y chabe cats̈ata Juan, y ínÿoye tojanënatse nÿe chënga, canÿe bëts tjoye. ");
INSERT INTO kbh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chents̈e, chëngbe delante inÿets̈á cha tojanobinÿná. Chabe jubiá shinÿcá yojtsebuashinÿinÿana, y chabe uichëtjonë́juangana mo binÿniñcá uafjantsëjuangá yojtsamna. ");
INSERT INTO kbh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chca orna, chabe uatsjéndayënga tmojáninÿe Moisés y Elías tbojanobinÿná, Jesúseftaca encuéntaye. ");
INSERT INTO kbh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chora Pedro, Jesúsbioye tbojaniyana: “Bëngbe Utabná, ¡ts̈a ts̈abá bëngbiama cuanmëna muents̈e jtsemnana ca! Tcojtsebos̈ëse, unga tambotémënga ats̈e chjapórma: cánÿetema acbiama, ínÿetema Moisesbiama y ínÿetemna Elíasbiama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro chca yojtsóyebuambnantscuana, canÿe buashinÿinÿana jants̈etëshe nÿetscanga yojáutsbotse. Y chë jants̈etëshoicana canÿe oyebuambnayana tmojanuena mënts̈á: “Mua ats̈be bonshana Uaquiñá endmëna, ats̈e chabiama sëntsoyejuá. Cha s̈mochtseyeunana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y chë uatsjéndayënga chca tmojanuena ora, tmojanoshaments̈é y jubiaca fshantsóntscoñe tmojanotsejbéna, puerte auatjanánënga. ");
INSERT INTO kbh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chora Jesús chabe uatsjéndayëngbioye tojanobeconá, tojánabojajo y tojanë́yana: “Matëtsbananga; ndoñe matauatjëngana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Y tsbanánoye tmojanontjes̈é ora, Jesús nÿe canÿa tmojáninÿe, ndocná inÿa más. ");
INSERT INTO kbh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chë tjocana imojtsatstsmaye ora, Jesús tojanamëndá: —Bëngbe Bëtsá Ents̈á tbojanbemá obanënguents̈ana candë́tayenëntscuana, ndocnábeñe chë s̈monjinÿe soyama s̈mattsecuéntaye ca. ");
INSERT INTO kbh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","As chë uatsjéndayënga Jesús tmojantjá: —¿Ndáyeca chë ley abuátambayënga mondbétsichamo, canmëna Elías jabana chë Bëngbe Bëtsabe Uámana Uabuayanabe natsana ca? ");
INSERT INTO kbh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chora Jesús tojanë́jua: —Ndegombre canÿa Eliascá natsana echanjabo y nts̈amo jtsemnama yomncá, lempe echánjabatsma ca. ");
INSERT INTO kbh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero ats̈e cbë́yana, canÿa mo Eliascá ya tonjabo, ents̈anga ndoñe chematanotëmbá y cháftaca ents̈anga tmonjanma lempe nts̈amo tmojanbos̈encá. Y cachcá, chë Bëngbe Bëtsá Ents̈á tbojanbemá ents̈angbe cucuats̈iñe echanjasúfria ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chora chë uatsjéndayënga tojanësertá, Juan chë Ubayanabiama Jesús chca yojtsëtsëtsnama. ");
INSERT INTO kbh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ents̈anga imojtsemnoye chënga tmojtanashjajna ora, canÿe boyabása tojanobeconá, Jesusbe natsanoica yojoshaments̈iye y tbojaniyana: ");
INSERT INTO kbh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Utabná, ats̈be uaquiñá motselastemá. Cha ataque bontsësháchichana y puerte entsesufrina, er cha inÿe ora iñoye jtseshajayana y inÿe orna, buyeshoye jtsoshbuets̈ana. ");
INSERT INTO kbh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Acbe uatsjéndayëngbioye cha sënjuánatse y ndoñe chematobená jtseboshnama ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","As Jesús tojánayana: —¡Nÿets̈á ndos̈buáchiyënga y bacna ents̈anga ca! ¿Buetayté s̈ojtsemna ts̈ëngaftangaftaca jëftsemnana? ¿Buetayté uantado ts̈ëngaftangaftaca chjë́ftsemna? Moye chë básetema mánatse ca. ");
INSERT INTO kbh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chora Jesús, chë basetémbeñe bacna bayë́jbioye tbojanácacana y chábents̈ana cha tojésanbocna. Cach orscana chë básetema ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chents̈ana, chë uatsjéndayënga luaroca Jesúseftaca tmojanoyebuambá y tmojaniyana: —¿Ndáyeca bënga ndoñe fsënjobená chë bacna bayëja jtabocnama ca? ");
INSERT INTO kbh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y Jesús tojanë́yana: —Ts̈ëngaftanga ts̈a bats̈atema os̈buáchiyana bomna causa. Ndegombre s̈cuayana: ts̈ëngaftanga bats̈atema os̈buáchiyana s̈mojtsebomnëse, masque nÿe mo canÿe mostaza betiye jenaycá, quem tjoye s̈matjayana: “Muents̈ana mojuaná y choye motsa ca”, quem tjañe chca nanjama, y ts̈ëngaftanga lempe jamama s̈mattsobena. ");
INSERT INTO kbh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero chca bayëjënga jtëbuacnamna jobenayana nÿe Bëngbe Bëtsáftaca jencuéntase y chama tondaye ntjascá jtsemnëse ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús y chabe uatsjéndayënga cánÿiñe Galilea luaroye imojétsaye ora, cha tojanë́yana: “Chë Bëngbe Bëtsá Ents̈á tbojanbemá ents̈angbe cucuats̈iñe mochanjáboshjona, ");
INSERT INTO kbh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","mochanjóba, pero unga tianoye echántayena ca.” Chë causa chë uatsjéndayënga puerte ngménaca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús y chabe uatsjéndayënga Capernaumoye tmojánashjajna ora, chë Bëngbe Bëtsabe bëts yebnama ents̈ángbioye impuesto atjanayënga Pédrëbioye tmojána y tmojantjá: —¿Acbe buatëmbayá Bëngbe Bëtsabe bëts yebnama impuesto queonÿbetsatsquëcjnaye ca? ");
INSERT INTO kbh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y Pedro tojanë́jua: —Aíñe, cha endbetsatsquëcjnaye ca. Chents̈ana, Pedro chë yebnoye tojánamashëngo ora, Jesús natsana mënts̈á chábioye tbojaniyana: —Simón, ¿nts̈amo catjájuaboye? ¿Quem luarents̈a reyënga ndë́muanÿengbioye impuesto imnétsayëngacaye y crocénana imnétsatjanaye: cach luarents̈e oyenë́ngbioye o chë inÿe luarocana ashjajnë́ngbioye ca? ");
INSERT INTO kbh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","As Pedro tbojanjuá: —Chë inÿe luarocana ashjajnë́ngbioye ca. Y Jesús tbojaniyana: —Chcasna, ndoñe ques̈nátsmëna chë ats̈be Taitabe bëts yebnama impuesto jtsatsquë́cjnayana ca. ");
INSERT INTO kbh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero ndocná mal chabonduínÿnanamna uafjajónayoye motsa, anzuelë́fjua cochjúts̈ena y chë natsana chaojuásjana beona cochjuábocna. Cochjuayetëfjoná y choye crocénana cochanjínÿena y chánaca echanjoshjache ats̈biama y acbiama jëtsjájuama. Cochjëftsejatsëca y cochjatsboshjona ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chents̈ana chë uatsjéndayënga Jesúsbioye tmojanobeconá y tmojantjá: —¿Chë Bëngbe Bëtsábeyeca mandánëngbeñe nda chë más uamaná yomna ca? ");
INSERT INTO kbh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chora Jesús canÿe basetémbioye tbojanchembo y chëngbe tsëntsaca tbojanatsá. ");
INSERT INTO kbh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Y tojánayana: —Ndegombre cbë́yana, nda mo basetemcá ndoñe tontóbema y ndoñe chacá Bëngbe Bëtsabe soyënga tonjóyëngacñe, cha ndocna te queochatobenaye Bëngbe Bëtsabe amë́ndayoye jamashënguama. ");
INSERT INTO kbh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chca, nda tojtsejuabná canÿe nduamaná yomna y quem basetemcá yomna ca, cha chë Bëngbe Bëtsabe amë́ndayoca chë más uamaná echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Y nda áts̈beñe os̈buachiyá bétsemnayeca, tbojofja canÿa mo quem basetembioycá, chana ats̈e jofjana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nda canÿe básetema áts̈beñe os̈buachiyábioye tbojaingñé bacna soye jamama, chabiama más ts̈abá nántsemna canÿe bëts nantsnëbé chamotsetamos̈ë́nts̈bua y chë mar béjaye shbuatsëntsoye chamotsashbuets̈e chabotsenatjëmbama. ");
INSERT INTO kbh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ts̈a lastema quem luarents̈a ents̈angbiama, chë ínÿenga bacna soye jamama chaócochënguama tmojtsamëngbiama! Nÿets tempo chca amënga mochanjë́ftsemna. Pero, ¡payajema chë inÿa bacna soye chaomama tojtsamá ca! ");
INSERT INTO kbh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Chíyeca, acbe cucuáts̈eca o acbe shecuáts̈eca bacna soye tcojamëse, cochtsenástjango y bënoye cochtsë́ts̈ena. Acbiama más ts̈abá nántsemna celoye jamashënguana chë nÿetsca tescama yomna ts̈abe vida jtsebomnama, cucuats̈e ndbomná o cosheto, y ndoñe nÿets uta cucuáts̈eca o shecuáts̈eca chë nÿets tempo echanjesomñe íñeshoye chacmotsë́stjango. ");
INSERT INTO kbh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nderado acbe bomínÿeca bacna soye tcojinÿe y cachca soye tcojama, chë bominÿe cochtsenobuchjatsëca y bënoye cochtsë́ts̈ena. Acbiama más ts̈abá nántsemna, celoye jamashënguana nÿe canÿe bomínÿeca, y ndoñe nÿets uta bomínÿeca infiernoye chacmotsë́stjango, chë bëts íñeshoye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mënts̈ánaca Jesús tojánayana: “Ni mo cánÿabioye quem tsëm os̈buáchiyënguents̈ana, chë mo basetemëngcá mondmënënga, mo nduamanacá s̈mattsonÿaye. Ndegombre cbë́yana, chëngbe angelotémënga celoca, sempre ats̈be Taitá celocáftaca mondétsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Er chë Bëngbe Bëtsá Ents̈á tbojanbemá tonjabo chë pochocánënga jtsemnama imojtsajnënga jabátsebacama. ");
INSERT INTO kbh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Nts̈amo ts̈ëngaftanga s̈matjájuaboye? Canÿe boyabása patse oveshënga tojtsabamna y ndeolpe canÿe chents̈a oveshá tojtsots̈e. ¿Chë boyabása ndoñe chë inÿe esconëfta bnë́tsana y esconëfta oveshënga tjoca cachcá nanjesë́nÿaye, jama chë óts̈ena oveshá jetsenguanguama? ");
INSERT INTO kbh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y chë oveshá jetsinÿenama tojobenase, ndegombre chë boyabása más oyejuayá jtsemnana chë óts̈ena oveshabiama, y ndoñe nÿa chca chë inÿe esconëfta bnë́tsana y esconëfta oveshëngbiama chë ndoñe tmonjanots̈ëngbiama. ");
INSERT INTO kbh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cachcá, ts̈ëngaftangbe Taitá, Bëngbe Bëtsá, chë celoca endmëná, ndoñe quenátsbos̈e ni canÿa quem basenguents̈ana mo ots̈enacá chaotsemna, bacna soyënga jtsamëse oyena causa ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nderado acbe cats̈ata, bacna soye tcmojaborlase, cochjá, cánÿata s̈ochjencuénta y cochjama cha chauenójuaboma, ndegombre bacna soye tcmojaborlama. Cha chacmojóyeunasna, acbe cats̈ata cachiñe ts̈abá ácaftaca echántsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero ndoñe tcmonjóyeunasna, inÿe útata cochjáchembo chacmotjëmbambama, chca, chata chabouena nts̈amo cochjauyanama y chamuayana ndegombre chca yomnama. ");
INSERT INTO kbh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y chata ndoñe tonjóyaunase, chents̈a Bëngbe Bëtsábeñe os̈buáchiyënga macuntá. Y chënga ndoñe tonjóyaunasna, cochjayana cha yomna mo canÿa Bëngbe Bëtsábioye nduabuatmacá, mo canÿe ndoñe judiycá ca o canÿe bacna ents̈á mo canÿa Romocama impuesto ents̈ángbioye atjanayacá yomna ca. ");
INSERT INTO kbh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ndegombre cbë́yana: Ts̈ëngaftanga Bëngbe Bëtsáftaca chas̈mojtsencuénta ora, chas̈mojayana canÿe soye ndoñe chaondë́tsemna ca, Bëngbe Bëtsá cachcá echanjayana. Y cháftaca chas̈mojtsencuénta ora, chas̈mojayana canÿe soye aíñe chaotsemna ca, Bëngbe Bëtsá echanjayana aíñe chca chaotsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mënts̈ánaca cbë́yana: Nderado útata ts̈ëngaftanguents̈ana quem luarents̈e tbojenoyeuná Bëngbe Bëtsáftaca jencuéntama ndayánaca jótjañama, Bëngbe Bëtsá chë celoca endmëná pronto chë soye cmochanjáts̈ataye. ");
INSERT INTO kbh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ndayents̈e útata o únganga tmojénefjna, áts̈beñe os̈buáchiyënga bétsemnama, chents̈e ats̈e chëngbe tsëntsaca chántsemna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","As Pedro tojána y Jesúsbioye tbojantjá: —Bëngbe Utabná, ¿ats̈be cats̈ata bacna soye s̈ojaborlase, bueta soye s̈ojtsemna cha japerdónana? ¿Canÿsëfta soye ca? ");
INSERT INTO kbh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Y Jesús tbojanjuá: —Ndoñe nÿe canÿsëfta soyama quecbatatsëtsná, sinó canÿsëfta bnë́tsana soye canÿsëfta ca. ");
INSERT INTO kbh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mënts̈ánaca Jesús tojanë́yana: “Cbochanjáuyana nts̈amo Bëngbe Bëtsabe amë́ndayana yomnana. Endmëna nts̈amo canÿe réyeftaca tojanopasacá. Cha yojábos̈ena chabe oservénënga crocénana jtsëtjañana. ");
INSERT INTO kbh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jtsëtjañama yojónts̈a orna, canÿe boyabása imojuánatse, chë réybioye mallajta crocénana ibnandebena. ");
INSERT INTO kbh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chë oservená tondaye yonjábomna chë ndebénama jëtsjájuama; asna chë rey yojamánda cha chamotsiye nÿets tempo nÿe ínÿabiama chaotsoservénama, chabe shema y chabe básengnaca, y lempe nts̈amo yojanbomncánaca, y chca chë ndebénama jtopágama. ");
INSERT INTO kbh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Chora chë oservená chë reybe shecuats̈ents̈e yojoshaments̈iye y ibojtseimpáda: ‘Taita, Diosmanda s̈motsëuantajema. Ats̈e lempe cbochanjëtsë́nts̈abuachiye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Chë reyna chë boyabásabiama ibojóngmia; as chë ndebénana ibojtseperdóna y ibojë́tsboshjona. ");
INSERT INTO kbh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Chë oservenana chents̈ana yojésebocna y benachiñe inÿe oservenáftaca ibojenbets̈e, cach mandadbiama trabajayá. Chë inÿe oservenana nÿe bats̈atema crocénana chábioye ibnandebena. Chora chë oservená chë enutábioye tamos̈ajents̈ana ibojishache y ibojónts̈a jtsëtajuashbebiana y mënts̈á ibojauyana: ‘¡Ndebénana s̈matsënts̈abuaché ca!’ ");
INSERT INTO kbh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chora cha chë oservenabe shecuats̈ents̈e yojoshaments̈iye y ibojtseimpáda: ‘Diosmanda s̈motsëuantajema. Ats̈e lempe cbochanjëtsë́nts̈abuachiye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero chë oservená ndoñe yonjábos̈ena, sinó yojama chë inÿe oservenábioye cárceloye chamotsëtámiama, chë ndebénana candëtsjájëntscuana. ");
INSERT INTO kbh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Chë inÿe oservénënga chca imojinÿe ora, puerte yojóngmia y imojá lempe nts̈amo yojopasacá chëngbe rey jacuéntama. ");
INSERT INTO kbh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","As chë rey yojamánda chë boyabása jobets̈ana, y ibojauyana: ‘¡Puerte bacna oservená! S̈conjaimpadáyeca, nÿets ndebénana tcbontseperdoná. ");
INSERT INTO kbh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Acnaca cachcá cmondmëna chë cach aquëcá muents̈a trabájayabiama jóngmiana, nts̈amo ats̈e acbiama s̈onjongmecá ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y ts̈a chë rey ibojtsetna; as yojamánda jabuache chamotsetsets̈ená nÿets ndebénana candëtsjájuantscuana ca” —Jesús tojanacuntá. ");
INSERT INTO kbh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chora Jesús tojánayana: “Ats̈be Taitá, celoca endmëná, cachcá ts̈ëngaftangaftaca echanjama, ts̈ëngaftangbe cats̈ata ndoñe ndegombre nÿets ainánaca s̈monjaperdonase ca.” ");
INSERT INTO kbh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chë soyënga tojánayanents̈ana, Jesús Galilea luarents̈ana tojtsanoñe y Judeoye tojánashjango, Jordán chenguánoica. ");
INSERT INTO kbh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ba ents̈anga tmojanasto y chents̈e s̈oquënga tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Básefta fariseunga Jesúsbioye tmojanobeconá y jisháchichiyama mënts̈á tmojantjá: —¿Queojtselesenciana canÿe boyá nÿe ndayámnaca chabe shémbioye cachcá jesonÿayama ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","As Jesús tojanë́jua: —¿Ts̈ëngaftanga ndoñe chë Bëngbe Bëtsabe uabemana palabrënguiñe s̈mëndualía, Bëngbe Bëtsá, chë ents̈anga tojanabiamá, quem luare jobojáts̈ama ora “boyá y shema tojánabiamama”? ");
INSERT INTO kbh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y Bëngbe Bëtsá tojánayana: “Chíyeca boyabása chabe taitá y chabe mamá echanjésabashejuana, chabe shémaftaca jenútanama, y chë útata mo canÿacá bochántsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y chca, ya ndoñe útata quebochátsmëna, sinó mo nÿe canÿacá. Chcasna, ents̈á ndoñe chaondë́ndbema ndayá Bëngbe Bëtsá mo canÿiñcá tojë́ftsema soye ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Chora chë fariseunga tmojaniyana: —¿As, ndáyeca Moisés tojanmandá, chë shémbioye canÿe uabemana tsbuanácha juiyiyana jtsenë́ts̈enama y cachcá jesonÿayana ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y Jesús tojanë́yana: —Ts̈ëngaftanga Bëngbe Bëtsabe mandënga jóyëngacñama ndoñe ques̈mátsbos̈e causa, Moisés tcmojanalesenciá shémbioye jesë́ts̈enana. Pero quem luare jobojáts̈ama orna, ndoñe chca quenjatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ats̈e cbë́yana, nda chabe shémaftaca tbojtsenë́ts̈ena y chca tojopasá ndoñe chë shema chabe boyábioye ínÿaftaca tbontseingñé causa, y chë boyá ínÿaftaca tojtóbouamasna, cha chë natsana shémbioye ínÿaftaca jtseíngñayana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chora chabe uatsjéndayënga tmojaniyana: —Chca chë boyá y shémaftaca tojtsemnësna, ndoñe ts̈abá yontsemna jobouamayana ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y Jesús tojanë́yana: —Nÿetscanga ndoñe quemátobena chë palabrënga jóyëngacñana, nÿe chë Bëngbe Bëtsá tojama jóyëngacñama chamobenama, chëngna aíñe. ");
INSERT INTO kbh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ba soyënga comna ndaye causa chë boyabásenga ndoñe ntsobenana jobouamayana. Inÿenga jónÿnana jobouamayama ndobenënga, ínÿengbioye cach ents̈anga jábiamana jobouamayama ndobenënga y ínÿengna, nÿets tempo nÿe Bëngbe Bëtsabe amë́ndayama oservena causa ca —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ents̈anga basetémënga Jesúsbioye tmojanënatse, cha chauabojajuama y Bëngbe Bëtsábioye chëngbiama chaboimpadama. Pero chë uatsjéndayëngna tmojanonts̈é chë basetémënga unachayënga jtsëcácanana. ");
INSERT INTO kbh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chora Jesús tojanë́yana: “Cachcá mónÿaye chë basetémënga áts̈bioye chamuabo y ndoñe matë́uyanana; er Bëngbe Bëtsabe amë́ndayana endmëna mo quem basetemëngcá imomnëngbiama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","As chë basetémënga tojánabojajo, Bëngbe Bëtsá jaimpádase; y chents̈ana cha tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chents̈ana, canÿe boyabása tojána Jesús jinÿama y mënts̈á tbojantjá: —Buatëmbayá, ¿ndaye ts̈abe soye chjama chë nÿetsca tescama yomna ts̈abe vida jtsebomnama ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y Jesús tbojanjuá: —¿Ndáyeca chë ts̈abe soye ndayá bétsemnama s̈cojtsetjaná ca? Ts̈abia nÿe canÿa endmëna: Bëngbe Bëtsá. Aca chë nÿetsca tescama yomna ts̈abe vida jtsebomnama tcojtsebos̈ëse, mandënga cochtsobedecena ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chora chë bobontse tbojantjá: —¿Ndaye mandënga ca? Y Jesús tbojanjuá: —“Ndoñe catjóba, acbe shema ínÿaftaca ndoñe cattseíngñaye, ndoñe catjatbëba, ndoñe catjuaboínÿena. ");
INSERT INTO kbh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Acbe bëtsë́tsata stëts̈oye ndoñe catjáquedaye y ndëmua ents̈ánaca cochtsebobonshana nts̈amo cach aca cuenobobonshancá ca” —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chora chë bobontse tbojanjuá: —Ats̈e lempe chca nÿets tempo sëndocumplina. ¿Ndayá más s̈ojtsebuáshbena ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","As Jesús tbojaniyana: —Aca lempe ts̈abá jamama tcojtsebos̈ëse, motsa, acbe bomna soyënga cochjetsatobuiye y chë crocénana, ndbomnëjémënga cochtsats̈ataye; chca, bëts uacanana soye celoca cochántsebomna. Chents̈ana cochjabo y s̈cochjuasto ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chë bobontse chca tojanuena ora, ngménaca yojtsatoñe, cha corente bomná bemna causa. ");
INSERT INTO kbh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Chora Jesús chabe uatsjéndayënga tojanë́yana: —Ndegombre cbë́yana, puerte totcá entsemna canÿe bomnabiama Bëngbe Bëtsabe amë́ndayoye jamashënguama ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chë bomnabiama cachiñe s̈cuatayana: Más paselo entsemna canÿe camello chë coshufjents̈a atëfjnëjana chauachnëngo, y ndoñe canÿe bomná Bëngbe Bëtsabe amë́ndayoye jamashënguana ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chabe uatsjéndayënga chca tmojanuena ora, puerte ojnanánënga imojtsemna y imojtsichamo: —As, ¿nda yochjobenaye atsbocaná jtsemnama ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús chënga tojanënÿanÿé y tojanë́yana: —Ents̈anga ndoñe quemátobena jamama canÿa atsbocaná chaotsemnama, pero Bëngbe Bëtsá aíñe, er cha nÿetsca soyënga jamama endobena ca. ");
INSERT INTO kbh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chora Pedro tbojaniyana: —Aca contsonÿá, bënga lempe chë fsë́ndbomna soyënga fsënjéseboshjona y ácaftaca fsëntsajna. As, ¿ndayá bënga fchjóyëngacñe ca? ");
INSERT INTO kbh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","As Jesús tojanë́yana: —Ndegombre cbë́yana, nÿetsca quem luarents̈a soyëngama mo tsmëcá jtsemnama tempo chaojobuache ora, chë Bëngbe Bëtsá Ents̈á tbojanbemá chabe buashinÿinÿana bëts ts̈enës̈iñe reycá echanjótbema jtsemándayama; y ts̈ëngaftanga, chë ats̈e s̈mëstonëngna, chora bnë́tsana uta uámana tbemaniñe s̈mochanjotbiama mo reyëngcá, chë Israeloca bnë́tsana uta bëts pamillents̈a ents̈angbiama jayanama ts̈abá o ndoñe ts̈abá tmonjamama. ");
INSERT INTO kbh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y ndëmuanÿenga, ats̈e jasérviama tmojë́ftseboshjona cachëngbe yebna, cats̈átanga o uabénanga, befta o bebmá, básenga o fshantsënga, chë soyëngama patse soye más mochanjóyëngacñe y chë nÿetsca tescama yomna ts̈abe vídnaca. ");
INSERT INTO kbh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero banga mora uámanënga imomnënga, nduámanënga mochántsemna; y banga mora nduámanënga imomnëngna, uámanënga mochántsemna ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mënts̈ánaca Jesús tojánayana: “Bëngbe Bëtsabe amë́ndayana endmëna mo canÿe bëts jajañe nduiñcá. Chë nduiñna canÿe te cabá cachëse yojábocna peonga janguanguama, chabe uvas betiyënga jajañe chamotrabajama. ");
INSERT INTO kbh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chë nduiño peonga yojánÿena orna, imojenóyeunaye canÿe tescama canÿe denario crocénana jtëbuénayama. As chora yojichamuá chë uvas betiyënga jajoye jatrabájama. ");
INSERT INTO kbh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mo base mos̈enana ora, chë nduiño cachiñe yojábocna y plazoca atsanënga ínÿenga yojanÿe, tondaye ntsamcá. ");
INSERT INTO kbh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","As yojáuyana: ‘Ts̈ëngaftángnaca ats̈be uvas betiyënga jajoye motsajna jatrabájama y nts̈amo chas̈mojamcá cbochtëbuénaye ca.’ Y chë ents̈anga imojá. ");
INSERT INTO kbh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nÿetsto ora y bëts mos̈enana ora, chë nduiño cachiñe yojábocna y cachiñe cachcá yojopása. ");
INSERT INTO kbh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mo la cinco ora, chë nduiño cachiñe yojábocna y chenache ínÿenga yojánÿena, tondaye ntsamcá. As yojátjaye: ‘¿Ndáyeca ts̈ëngaftanga nÿets día ntjatrabajacá muents̈e s̈motsomñe ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y chënga imojojuá: ‘Ndocná bënga ches̈nataimpadá causa ca.’ As chë nduiño yojáuyana: ‘Ts̈ëngaftángnaca ats̈be uvas betiyënga jajoye motsajna jatrabájama y cbochtëbuénaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Y ya bien jetiñe yojtsemna orna, chë nduiño chabe caporálbioye ibojauyana: ‘Peonga metsachembo y cochtëbuénaye. Chë ústonoye tmojáshjajnënguents̈ana cochjabojáts̈a y chë natsana tmojáshjajnënga ústonoye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Y chë mo la cinco ora imojáshjajnënga imojobeconá, y cada ona canÿe denario crocénana yojtáyents̈buachiye. ");
INSERT INTO kbh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chents̈ana, chë natsana jatrabájama imojáshjajnënga yojtsamna jobéconama y chënga imojétsejuabnaye más crocénana mochjanóyëngacñe ca. Pero chë́ngnaca cach canÿe denario crocénana yojtëbuénaye. ");
INSERT INTO kbh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chca imojóyëngacñe orna, chënga imojónts̈a chë nduiñbiama bacá ichámuana, ");
INSERT INTO kbh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","mënts̈á: ‘Quemënga chë ústonoye tmonjáshjajnënga nÿe canÿe horatema tmonjatrabajá; nts̈amo bënga s̈contëbuenacá, cachcá chënga contëbuená y bëngna nÿets día jabuache fsënjatrabajá y corente jënÿá fsënjauantá ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pero chë nduiño canÿa chca yojtsichamuábioye ibojojuá: ‘Sobreno, acbiama ndocna ndoñe ts̈abe soye chiyatsma. ¿Ndoñe canÿe denario crocénana canÿe tescama tbonjenoyeuná ca? ");
INSERT INTO kbh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chcasna, acbe uacanana crocénana mesocñe y motsatoñe. Ats̈e së́ntsebos̈e chë ústonoye jatrabájama tojashjanguá jtabuénayana, cachcá nts̈amo aca tcbojtabuenacá. ");
INSERT INTO kbh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chca entsemna, er ats̈e sëndobena ats̈be crocenánaca nÿe ndayánaca jamana. ¿O aca envidia cojtsebomna, ats̈e ts̈abia tsmënama ca?’ ” —cha yojayana. ");
INSERT INTO kbh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chora Jesús tojánayana: “Y chca, chë mora nduámanënga imomnënga, uámanënga mochántsemna; y chë mora uámanënga imomnëngna, nduámanënga mochántsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Chënga Jerusalenoye imojtsaye ora, Jesús barie tojánachembo chabe bnë́tsana uta uatsjéndayënga y tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ts̈ëngaftanga s̈montsonÿá mora bënga Jerusalenoye montsajnama. Chocna chë Bëngbe Bëtsá Ents̈á tbojanbemá, chë bachnangbe amë́ndayënga y ley abuátambayëngbe cucuats̈iñe mochanjáboshjona, y chënga mochanjayana jóbanama cha ibojtsemna ca, ");
INSERT INTO kbh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","y chë ndoñe judiëngbe cucuats̈iñe mochanjáboshjona chënga chamotsáboyejuanama, chamotjanjama y chamocrucificama. Pero unga tianoye cha echántayena ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chents̈ana, Zebedeobe uaquiñatbe mamá chabe uaquiñátaftaca Jesúsbioye tojanobeconá, chabe shecuats̈ents̈e yojoshaments̈iye canÿe pavorama jaimpádama. ");
INSERT INTO kbh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","As Jesús tbojantjá: —¿Ndayá cojtsebos̈e ca? Y chë shembása tbojaniyana: —Aca reycá chacojtsemánda ora, cochjamánda ats̈be uaquiñata chabótbema canÿa acbe cats̈bioica y chë inÿa acbe uañicuayoica, ácaftaca chabotsemándama ca. ");
INSERT INTO kbh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Y Jesús tojanë́jua: —Nts̈amo s̈montsotjanañama, tsëndata ndoñe ques̈nátstats̈ëmbo ca. Nts̈amo ats̈e chjasufriacá, ¿tsëndátnaca cachcá jasúfriama tas̈atjobenaye ca? Y chata tbojanjuá: —Aíñe, fchanjobenaye ca. ");
INSERT INTO kbh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chora Jesús tojanë́jua: —Ndegombre, tsëndátnaca ats̈cá s̈ochanjasúfria, pero ats̈e ndoñe quetsátobena jamándana ats̈be cats̈bioica o ats̈be uañicuayoica chas̈ótbemama. Chë útents̈e entsemna ndëmuanÿengbiama ats̈be Taitá tojaprontacá ca. ");
INSERT INTO kbh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chë inÿe bnë́tsana uatsjéndayënga chca tmojanuena ora, chë uta cats̈átaftaca tmojanotjayaná. ");
INSERT INTO kbh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Chora Jesús chë uatsjéndayënga tojánachembo y tojanë́yana: —Ts̈ëngaftanga s̈mondë́tats̈ëmbo, chë ndoñe judië́ngbeñe chë reyënga lempe jtsemándayana nÿa mo nduiñënga cuaftsemncá; y chë bëtsëtsa ents̈angna chëngbe obenánaca jtsemándayana, ndayánaca jtsamëse, chë inÿe ents̈anga sempre chamotsayaunanama. ");
INSERT INTO kbh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ts̈ëngaftangbeñna ndoñe chca chaondë́tsemna. Inÿets̈á; masna, nda ts̈ëngaftanguents̈e chë más uamaná jtsemnama tojtsebos̈á bontsemna chë ínÿenga jtsaservénana. ");
INSERT INTO kbh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y ndánaca ts̈ëngaftanguents̈á chë más uamaná jtsemnama tojtsebos̈á bontsemna jtsemnana mo nÿe ínÿabiama nÿets tempo oservenacá. ");
INSERT INTO kbh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Cachcá, chë Bëngbe Bëtsá Ents̈á tbojanbemá ndoñe chenátabo cha chamotseservénama, ndayá ínÿenga jabáserviama. Y mo nda ínÿenga játsebacama cuafjëtsjajocá, cha echanjóbana, ba ents̈anga atsebácanënga chamotsemnama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Chënga, Jericó bëts pueblents̈ana tmojánbocana ora, ba ents̈anga Jesús imojtsë́stona. ");
INSERT INTO kbh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uta jtanata benache juachañe ibnatbemana. Jesús chëjana yojtsachnëjuanama chata tbojanuena ora, tbojanonts̈é uayebuáchana: —¡Utabná, Davídbents̈ana Ents̈á, s̈motsalastemá ca! ");
INSERT INTO kbh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ents̈anga chë jtanátbioye tmojtsanëcácana iytëca chabotsemnama, pero chatna más ibojtsáyebuache: —¡Utabná, Davídbents̈ana Ents̈á, s̈motsalastemá ca! ");
INSERT INTO kbh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","As Jesús yojotsaye, chë jtanata tojánachembo y tojanatjá: —¿Ndayá s̈ojtsebos̈e ats̈e tsëndatbiama chjamama ca? ");
INSERT INTO kbh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Y chata tbojanjuá: —Utabná, bëndata chabuatëbínÿnama ca. ");
INSERT INTO kbh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús chatbiama tbojanongmé y tojánabuchbojajo. Cachora chë jtanata ts̈abá yojtëbinÿna y Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ya Jerusalenoca béconana imojtsemna y canÿe pueblo Betfagé ca uabáinoca tmojánashjango, canÿe tjashe Olivos ca uabáinents̈e. Chora Jesús uta chabe uatsjéndayata tojanichamó, ");
INSERT INTO kbh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","y mënts̈á tojanë́yana: “Tsëndatbe natsana entsemna base pueblotémoye motsata. Cachora canÿe burrá utsbuaná s̈ochanjínÿena y cháftaca canÿe burrotema echántsemna. S̈ochjuajafjoná y s̈ochjuánatse. ");
INSERT INTO kbh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nderado nda ndayánaca chacmojáuyanëse, s̈ochjauyana: ‘Bëngbe Utabná bontsájaboto y chents̈ana camuents̈e echanjabáisabashejuana ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chca tojanopasá, cachcá chaotsemnama nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá tojanayancá. Cha mënts̈á tojanábema: ");
INSERT INTO kbh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén bëts pueblents̈e oyenënga më́yana: “Minÿënga, ts̈ëngaftangbe Rey chents̈e ts̈ëngaftangbioye entsabó, ndoñe mo canÿa cachá bëtsá enobiamnayacá; canÿe búrrbeñe enjaquená; canÿe burrotémiñe, canÿe uatrabájaye bayabe s̈es̈ónbeñe ca.” ");
INSERT INTO kbh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chora chë uatsjéndayata tbojána y tbojanma nts̈amo Jesús tojanamëndacá. ");
INSERT INTO kbh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chë uatsjéndayatna chë burrá y chë burrotema tmojanënatse, ents̈ayëjuangá chátbeñe tbojanájatse y chora Jesús chábeñe tojanenojayé. ");
INSERT INTO kbh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bëtscá ents̈anga chëngbe ents̈ayá chë benachëjana imojtsëtë́tsatsana, y ínÿengna betiyeshënguiñe buacuafjënga imojtsetcoye y chiñe imojtsequëcjná. ");
INSERT INTO kbh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y chë natsana imojtsajnënga y chë ústonoyënga mënts̈á imojtsaiuáyebuache: “¡Rey Davídbents̈ana Ents̈á matschuanga ca! ¡Corente bendición bomná, chë Bëngbe Utabnabe obenánaca tojabá! ¡Bëngbe Bëtsá celocá matschuanga ca!” ");
INSERT INTO kbh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusalenoye tojánamashëngo ora, nÿetsca ents̈anga imojtsenbouenana y banga imojtsenotíciaye: —¿Nda mua yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y chë ents̈anga imojtsëjuana: —Chë Bëngbe Bëtsabe juabna oyebuambnayá Jesús, chë Galileoca pueblo Nazaretocá ca. ");
INSERT INTO kbh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chents̈ana Jesús, Bëngbe Bëtsabe bëts yebnoye tojánamashëngo y chë ents̈anga chents̈e imojtsena y imojtsobuámnañënga chents̈ana tojtanëbuacna. Chénts̈naca imojtsemna ents̈anga canÿe crocénana enënga, y chë crocénana nÿe Bëngbe Bëtsabe bëts yebnents̈ama inoservena. Chëngbe mesëshangá tojtsanenásatajchquëca y chë palomatema enëngbe ts̈enës̈ë́ngnaca. ");
INSERT INTO kbh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Y tojanë́yana: “Bëngbe Bëtsabe uabemana palabrënguiñe cha mënts̈á tojánayana: ‘Ats̈be bëts yebna echantsabaina áts̈eftaca encuéntaye yebna ca’; pero ts̈ëngaftangna, atbëbanëngbe oyeniñe chë yebna s̈mojtsebema ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chents̈ana, Jesús yojtsemnoye Bëngbe Bëtsabe bëts yebnents̈e, jtanënga y coshetënga tmojanobeconá, y cha tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Chë bachnangbe más uámana amë́ndayënga y ley abuátambayënga, Jesús bëts soyënga yojtsamama tmojáninÿe ora, y chë basetémënga Bëngbe Bëtsabe bëts yebnents̈e imojtsayebuáchama tmojanuena ora, ts̈a tmojanotjáyananga. Chë basetémënga mënts̈á imojtsáyebuache: “¡Chë Rey Davídbents̈ana Ents̈á matschuanga ca!” ");
INSERT INTO kbh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","As Jesús tmojaniyana: —¿Nts̈amo chë basetémënga montsichamcá quectsuenana ca? Y Jesús tojanë́jua: —Aíñe, sëntsuenana. Pero, ¿ts̈ëngaftanga Bëngbe Bëtsabe uabemana palabrënguiñe chë soyama ndoñe s̈mëndualía? Chiñe mënts̈á endayana: Chë basetémënga y ochóchaye s̈es̈onatémëngbe cantë́ngaca aca tcojama ents̈anga chacmotsatschuanama ca. ");
INSERT INTO kbh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chora Jesús chënga tojésanabashejuana y Jerusalenents̈ana Betania puebloye tojtsanoñe; y chents̈e chë ibeta tbojánbobinÿna. ");
INSERT INTO kbh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chë te cachëse, Jesús cach bëts puebloye yojtésa ora, tbojánishëntsena. ");
INSERT INTO kbh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chora canÿe higo betiye benache juachaca yojinÿe; as choye yojobeconá, pero nÿe ena tsbuanáchënga chiñe yojínÿena. As Jesús chë higo betiyoye tojánayana: “¡Ndocna te más chacondëshájona ca!” Y betsco chë higo betiye tojtsanbuashá. ");
INSERT INTO kbh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chë uatsjéndayënga chca tmojáninÿe ora, imojenjnaná y Jesús tmojantjá: —¿Nts̈amo chca chë higo betiye canÿe ora tojtsebuashá ca? ");
INSERT INTO kbh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Y Jesús tojanë́jua: —Ndegombre cbë́yana, ts̈ëngaftanga Bëngbe Bëtsábeñe os̈buáchiyana s̈mojtsebomna y chabiama ainaniñe ndoñe inÿets̈á s̈monjátsjuabnase, s̈mochantsobena jamama ndoñe nÿe nts̈amo ats̈e quem higo betíyeca sënjamcá, sinó quem tjoye, “muents̈ana mojuaná y uafjajónayoye moshbuets̈e ca” s̈mojayanëse, chca jochnënguana. ");
INSERT INTO kbh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Y Bëngbe Bëtsáftaca chas̈mojtsencuénta ora, chábeñe jtsos̈buáchiyëse, lempe nts̈amo chas̈mojotjañcá s̈mochanjóyëngacñe ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chca tojanopasá chents̈ana, Jesús Bëngbe Bëtsabe bëts yebnoye tojánamashëngo. Chents̈e yojtsabuátambantscuana, bachnangbe amë́ndayënga y judië́ngbeñe bëtsëjemëngcá amë́ndayënga tmojanobobeconá y tmojantjá: —¿Ndaye deréchoca chë contsama soyënga aca cojtsama ca? ¿Chca jtsamama nda mando tcmënjats̈tá ca? ");
INSERT INTO kbh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","As Jesús mënts̈á tojanë́jua: —Ats̈naca canÿe soye së́ntsebomna ts̈ëngaftanga jatjayama, y ques̈mojojuase, áts̈naca cbochjáuyana ndaye deréchoca ats̈e chca stsama. ");
INSERT INTO kbh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Nda Juan chë Ubayaná tbojanichmó ents̈anga jubáyama, Bëngbe Bëtsá o ents̈anga ca? —Jesús tojanë́yana. Chama chënga tmojanonts̈é mënts̈á enatsëtsnayana: “ ‘Bëngbe Bëtsá ca’ chamojojuase, cha s̈ochanjáuyana: ‘As, ¿ndáyeca chë tcmojanabuayená soyënguiñe ndoñe s̈monjanos̈buaché ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero ndoñe quemuátobena jayanana ‘ents̈anga ca’; muents̈a ents̈angbiama bënga montsauatja, er nÿetscanga mondëjuabná Juan ndegombre Bëngbe Bëtsabe juabna oyebuambnayá yomna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chcasna chënga Jesús tmojanjuá: —Bënga ndoñe queftsátstats̈ëmbo ca. Y as Jesús tojanë́yana: —Ats̈e cach ndoñe quecbochatë́yana ndaye deréchoca chca stsama ca. ");
INSERT INTO kbh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chora Jesús ents̈anga tojanatjá: —¿Nts̈amo ts̈ëngaftanga quem soyama s̈matjayana? Canÿe boyabása uta uaquiñata yojánabamna, y cánÿabioye ibojauyana: “Uaquiñá, mënté motsa ats̈be uvas betiyënga jajoye jatrabájama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Chë uaquiñá ibojojuá: “¡Jama ndoñe quetsátsbos̈e ca!” Pero botamana yojenójuaboye y pronto choye yojá. ");
INSERT INTO kbh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chents̈ana chë taitá chë inÿe uaquiñábioye cachcá ibojauyana. As cha ibojojuá: “Arseñor, aíñe chanjá ca.” Pero ndoñe yonjá. ");
INSERT INTO kbh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Chë útatents̈ana ndëmuanÿá tojanma nts̈amo chë taitá yojabos̈cá ca? —Jesús tojanatjá. Y chënga tmojanjuá: —Chë natsaná ca. Chora Jesús tojanë́yana: —Ndegombre cbë́yana, chë Romocama ents̈ángbioye impuesto atjanayënga y chë bacna vida bomna shembásenga, ts̈ëngaftangbiama más montseprontana Bëngbe Bëtsabe amë́ndayoye jamashënguama. ");
INSERT INTO kbh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan chë Ubayaná tonjánabo ts̈ëngaftanga jábuayenama nts̈amo jtsiyenana cmamnama, nts̈amo Bëngbe Bëtsá yobos̈cá, y ts̈ëngaftanga chë tcmojanabuayená soyënguiñe ndoñe ches̈matanos̈buaché; y chë cuenta, chë Romocama ents̈ángbioye impuesto atjanayënga y bacna vida bomna shembásengna aíñe chábeñe montsanos̈buaché. Y ts̈ëngaftanga, masque nts̈amo chënga Bëngbe Bëtsábeñe imojtsos̈buáchema lempe s̈mojinÿëse, chë juabnayana ndoñe s̈monjatrocá, chábeñe jtsos̈buáchiyama ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mënts̈ánaca Jesús tojánayana: “Inÿe cuento s̈mochjatuena chas̈muatsjínÿama: Canÿe jajañe nduiño uvas betiyënga yojáje y chë shë́conana yojajétja. Chë uvasës̈angá juants̈ë́tetjiamna canÿe base luare yojajutjo y canÿe tsbanana jebna soye yojapórma chents̈e jtsaishanÿama. Chents̈ana, inÿe trabájayënga chë jajañe yojárrendaye y chana inÿe luaroye yojtsoñe. ");
INSERT INTO kbh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chë uvasës̈angá juashacama tempo yojobuache orna, chë jajañe nduiño básefta oservénënga yojichamuá chë arréndayënga jáuyanama ntsachets̈á chë nduiño ibojtsotocánama. ");
INSERT INTO kbh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero chë arréndayëngna chë oservénënga imojishëche: ínÿengbioyna imojtsajants̈etaye, ínÿengbioye imojtsëbaye y chë ínÿengbioyna ndëts̈béngaca imojtsatëchë́nganja. ");
INSERT INTO kbh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","As chë jajañe nduiño chë natsanama más ba oservénënga yojichamuá. Pero chë arréndayëngna, nts̈amo chë natsanë́ngaftaca imojamcá, cachcá chora imojama. ");
INSERT INTO kbh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Cabana, chë jajañe nduiño cachabe uaquiñá ibojíchmua; as mënts̈á yojtsejuabnaye: ‘Ats̈be uaquiñá cocayé mochanjóyeunaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero chë arréndayënga chë uaquiñá imojinÿe orna, imojeniyana: ‘Mua chë fshantse nduiñbe uaquiñá entsemna. Lempe chabe soyënga mua echanjóyëngacñe. Cuajna, motsóbanga y lempe chabe otocana soyënga bëngbiama echanjoquéda ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","As chë uaquiñá imojishache, chë uvas betiyënga jajañents̈ana imojtsábocna y imojtsóba.” ");
INSERT INTO kbh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chca jacuéntama tojanpochocá orna, Jesús tojánayana: —Y morna, chë jajañe nduiño chaojabo ora, ¿nts̈amo s̈mojtsejuabná chë arrendayë́ngaftaca cha yochjama ca? ");
INSERT INTO kbh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y chënga tmojanjuá: —Chë puerte bacna arréndayënga ni mo bats̈atema ntjalastemaycá echantsëbaye. Chë jajañe ínÿenga echanjárrendaye y chë uvasës̈angá juashacama tempo chaojobuache ora, nts̈amo chë nduiño chabojtsotocancá chënga mochantíyiye ca. ");
INSERT INTO kbh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Chora Jesús tojánayana: —¿Ts̈ëngaftanga ndocna te Bëngbe Bëtsabe uabemana palabra s̈mëndualía? Chiñe mënts̈á endayana: Chë yebna jebuanënga tmojtsanaboté ndëts̈bé, mora chë más bëts uashacuanës̈ents̈e entsejájona. Chë soye Bëngbe Utabná, Bëngbe Bëtsá chca tojama, y bënga chama ojnanánënga fsë́ntsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nts̈amo chë nduiño chë arréndayënga chë fshantse echántsabaca y ínÿenga echantsats̈ataye y chënga chabiama bëtscá shajuana mochanjatbanacá, cachcá, Bëngbe Bëtsabe amë́ndayana ts̈ëngaftangbents̈ana mochantsejuána y ínÿengbioye mochántsats̈ataye. Chënga Bëngbe Bëtsabe soyëngama mochanjouena y chë soyëngama ínÿengbioye mochanjabuayená, Bëngbe Bëtsabe amë́ndayoye jamashënguama. ");
INSERT INTO kbh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndánaca chë ndëts̈beñe chaojotsats̈á, chëbé bochántsatcacaye; y chë ndëts̈bé ndábeñnaca chaojótsats̈e, polvëshe bochántsebema ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chë bachnangbe amë́ndayënga y fariseunga, Jesús chë jabuátambama cuentënga yojtsëtsëtsnama, tmojanenótats̈ëmbona chëngbiama chca yojtsóyebuambnama. ");
INSERT INTO kbh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chora chënga tmojánbos̈ena Jesús jishachana, pero ents̈angbiama imojtsauatja; chënga imojanjuabná Jesús Bëngbe Bëtsabe juabna oyebuambnayá yojamna ca. ");
INSERT INTO kbh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Chents̈ana Jesús tojanonts̈é cachiñe cuentë́ngaca chënga jabuátambana. Mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Cbochanjáuyana nts̈amo Bëngbe Bëtsabe amë́ndayana yomnana. Endmëna mo nts̈amo canÿe réyeftaca tojanopasacá. Chë rey yojamánda canÿe bëts fiesta jamama, chabe uaquiñabe casamentama. ");
INSERT INTO kbh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chora chë rey chabe oservénënga yojichamuá chë ófjanënga jobiats̈ama, pero chë ófjanëngna ndoñe imonjouena jama. ");
INSERT INTO kbh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","As chë rey inÿe oservénënga yojichamuá y mënts̈á yojámëndaye: ‘Chë ófjanënga s̈mochjáuyana, ya saná stseboprontana ca. Sënjamandá, ats̈be uacnënga y uamna bayënga minÿicánënga jobáyama y lempe entseprontana; y chamuabo chë casamento fiestama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pero chë ófjanënga ndoñe imonjouena. Canÿa, cachabe fshantse inabomnoye yojtsoñe; ínÿana chabe obuámnayiñe trabajuama yojtsoñe; ");
INSERT INTO kbh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","y ínÿengna, chë reybe oservénënga imojishëche, jabuache imojtsatsets̈enaye y imojtsëbaye. ");
INSERT INTO kbh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Y chë rey chë soyama yojouena ora, corente ibojtsetna. As chabe soldadënga yojichamuá chë oservénënga obánayënga chamuetsëbáyama y chëngbe bëts pueblo jetsángbotjuama. ");
INSERT INTO kbh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chora chabe oservénënga yojáuyana: ‘Lempe entseprontana chë casamento fiestama, pero chë ófjanënga ndoñe quenjatëmerecena moye jabama. ");
INSERT INTO kbh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Motsajna tsashenangoye y ndëmuanÿéngnaca chas̈mojánÿenënga, chë casamento fiestama s̈mochjúbuaja ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","As chë oservénënga tsashenangoye imojábocana y nÿetscanga imojánÿenënga imojáchembo, cánÿiñe ts̈abe y bacna ents̈anga, y chca, chë tsbocnanoica jútjena yojtsemna ents̈ángaca. ");
INSERT INTO kbh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Chë ófjanënga jánÿama chë rey yojámashëngo ora, chents̈e cánÿabioye ibojinÿe y chana ndoñe yontsemna nts̈amo canÿe casamento fiestama endbetsemncá uichëtjoná. ");
INSERT INTO kbh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","As chë rey ibojauyana: ‘Sobreno, nts̈amo canÿe casamento fiestama endbetsemncá ndoñe quecatichë́tjona. ¿Nts̈amo chca moye tcojamáshëngo ca?’ Pero chë boyabásana nÿe iytëca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","As chë rey chë fiestents̈e ujuats̈nayënga yojámëndaye: ‘Shecuats̈e y cucuats̈e motsebatsëca y chë ndëbinÿna luaroye, infiernoye motsábocna. Chents̈e puerte echanjenóbos̈achna y chë tsets̈anama juatsas̈ënga echantsenoftë́s̈jojnaye ca’ —cha yojayana.” ");
INSERT INTO kbh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús chca jacuéntama tojanpochocá ora, mënts̈á tojánayana: “Chë fiestama ófjanënga banga montsemna, pero chë bocacánënga choca jtsemnama nÿe báseftanga. Er Bëngbe Bëtsá banga jáchembuana chabe amë́ndayoye jamashënguama, pero nÿe báseftanga choca mochántsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chents̈ana chë fariseunga tmojtsatanoñe y tmojanenoyeuná nts̈amo Jesús tojayaniñe cha jisháchichiyana, as chca, mandadë́ngbeñe cha mal jaquédama. ");
INSERT INTO kbh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chama chënga tmojanichamó básefta cachëngbe usetonënga y ínÿengna Heródesbe ústonënga, Jesús jauyanama: —Buatëmbayá, bënga fsëndë́tats̈ëmbo aca ndegombre soyënga cnetsabuátambama y contsabuatambá ndegombre ts̈abe vida jtsebomnama, nts̈amo Bëngbe Bëtsá yomandacá, y ndoñe jatuenanana nÿe nts̈amo ents̈anga tmojatichamcá, er acbiama tondaye quenatámana nda más uamaná o nduamaná tomnana. ");
INSERT INTO kbh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chcasna, ¿nts̈amo catjájuaboye? ¿Ts̈abá tayojtsemna, César, chë Romoca bëts mandadbiama, bënga impuesto jtsatsquë́cjnayana o ndoñe ca? ");
INSERT INTO kbh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús yojtsetáts̈ëmbo chëngbe bacna juabnëngama; chíyeca tojanë́yana: —Bacna ents̈anga, nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga. ¿Ndáyeca ts̈ëngaftanga s̈mojtsebos̈e chë sóyeca ats̈e jisháchichiyama? ");
INSERT INTO kbh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chë s̈matsquëcjná crocénana s̈minÿinÿé ca. As canÿe crocénana tmojanoyé. ");
INSERT INTO kbh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús tojanatjá: —¿Ndabe jubiá quem crocenániñe yojtsemna, y nts̈amo muents̈e entsabemancá nda chca iuabaina ca? ");
INSERT INTO kbh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y chënga tmojanjuá: —Césarbe jubiá; cha chca enduabaina ca. As Jesús tojanë́yana: —Césarbioye s̈mochtoyiye cha ibotocana soye; y Bëngbe Bëtsana cha ibotocana soye ca. ");
INSERT INTO kbh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chënga chca tmojanuena ora, ojnanánënga imojtsemna. As chënga cachcá Jesús tmojanonÿá y tmojtsatanoñe. ");
INSERT INTO kbh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Báseftanga judiëngbe amë́ndayënga, saduceos ca uabáinënga, imojanjuabná chë obanënga ndocna te ntayenana ca. Cach te, chë impuestama Jesús tojanoyebuambá te, básefta saduceunga tmojána y mënts̈á tmojantjá: ");
INSERT INTO kbh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Buatëmbayá, Moisés tojánayana nderado canÿe boyá tojóbana básenga ntjëftsabashejuancá, ana chabe uabentsá jtsemnana chë shémaftaca jtobouamayana, chca, chabe uabochená obanabiama básenga jtsabamnama ca. ");
INSERT INTO kbh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chcase, canÿe bë́ngbents̈e canÿsëfta cats̈átanga monjamna. Chë natsaná tonjanobouamá y tontsanóbana. Básenga ndoñe quenjátabamna, chíyeca chë shemna chë uabentsáftaca tontanobouamá. ");
INSERT INTO kbh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Y cháftaca cachcá tonjanopasá, chë inÿe uabentsáftaca cachcá, y cachcá chë ínÿengaftaca y chë ústonoca uabentsáftacnaca. ");
INSERT INTO kbh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y chents̈ana chë shembásanaca tontsanóbana. ");
INSERT INTO kbh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y morna, chë obanënga chamojtayena ora, ¿ndabe chë canÿsëfta cats̈atanguents̈abe shema chë shembása yochtsemna, nÿetscanga cháftaca tmojanobouamase ca? —chënga tmojantjá. ");
INSERT INTO kbh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","As Jesús tojanë́jua: —Nts̈amo ts̈ëngaftanga s̈monjayancá ndmëncá s̈montsoyebuambná, Bëngbe Bëtsabe uabemana palabra, ni chabe obenanama ndoñe quecmátësertana causa. ");
INSERT INTO kbh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chë obanënga chamojtayena ora, ni boyabásenga, ni shembásenga quemochatóbouamnaye, y chca, chënga mochántsemna mo celoca angelotemëngcá. ");
INSERT INTO kbh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Y chë obanënga jtayenamna, ¿ndoñe s̈mëndualía nts̈amo cach Bëngbe Bëtsá chabe uabemana palabrënguiñe tojánayanama? Cha tonjánayana: ");
INSERT INTO kbh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ats̈e sëndmëna Abraham, Isaac y Jacobëbe Bëtsá ca.” Bëngbe Bëtsá chca jayanëse entsichamo cha ndoñe yondmëna obanëngbe Bëtsá, sinó aina ents̈angbe Bëtsá ca, er masque chënga tmojanóbana, chënga cabá Bëngbe Bëtsáftaca mondoyena ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Chë ents̈anga chca tmojanuena ora, ojnanánënga imojtsemna nts̈amo Jesús yojtsabuátambama. ");
INSERT INTO kbh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús chë saduceúngbioye iytëca tojánabiamama fariseunga tmojántats̈ëmbona ora, chënga tmojánenefjna, ");
INSERT INTO kbh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","y canÿa chënguents̈á, ley abuatambayá, Jesúsbioye jisháchichiyama tbojantjá: ");
INSERT INTO kbh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Buatëmbayá, ¿Moisesbe leyiñe ndayá chë más bëts uámana mando yomna ca? ");
INSERT INTO kbh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","As Jesús tbojanjuá: —“Utabná Bëngbe Bëtsá cochtsebobonshana nÿets acbe ainánaca, nÿets espíritoca y nÿets juábnaca.” ");
INSERT INTO kbh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chë soye endmëna chë más bëts uámana mando y nÿetsca mandëngama chë natsanoca entsemna. ");
INSERT INTO kbh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y quem inÿe soye, chë natsana mandcá endenoparecena. Endayana: “Ndëmua ents̈ánaca cochtsebobonshana, nts̈amo cach aca cuenobobonshancá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chë uta mandents̈ana endóbocana lempe nts̈amo Moisesbe leyiñe endayancá y nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayënga mondbetsabuatambacá ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chë fariseunga cabá cachents̈e imojtsemnëntscuana, ");
INSERT INTO kbh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús tojanatjá: —¿Nts̈amo s̈mojtsejuabná chë Bëngbe Bëtsabe Uámana Uabuayanabiama, chë Cristo? ¿Ndábents̈ana cha iuabó ca? Y chënga tmojanjuá: —Davídbents̈ana ca. ");
INSERT INTO kbh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","As Jesús tojanë́yana: —¿Nts̈amo chca nántsemna, cach David, chë Uámana Espíritbe mándoca, Crístbioye Utabná ca tbojtsabobuátmëse? David mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bëngbe Bëtsá, ats̈be Utabná Crístbioye tbojaniyana: ats̈be cats̈bioica mótbema, ats̈be obenánaca acbe uayayënga acbe cucuats̈iñe chamoquedama chjamëntscuana ca. ");
INSERT INTO kbh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nts̈ámose Cristo, Davídbents̈ana Ents̈á nántsemna, cach David “Utabná ca” chábioye tbojtsabobuátmëse ca? —Jesús tojanatjá. ");
INSERT INTO kbh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chora ndocná tonjanobená ni mo canÿe palabra jojuana. Y chë tescana ndocná yonjenñémua Jesús más jatstjanayama. ");
INSERT INTO kbh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chora Jesús, ents̈anga y chabe uatsjéndayënga mënts̈á tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Chë fariseunga y chë ley abuátambayënga cmondbétsabuatambaye nts̈amo Moisesbe leyënguiñe iuayancá. ");
INSERT INTO kbh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chcasna, ts̈ëngaftanga cmontsamna chënga joyaunayana y nts̈amo tcmojauyancá, cachcá jtsamana. Pero ndoñe s̈mattsama nts̈amo chënga mondbetsamcá, er chënga ndoñe ntsamana nts̈amo mondbetsabuatambacá. ");
INSERT INTO kbh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mo canÿe ents̈á, couáybioye uauta uasmanë́sha juasmayana y cachá tondaye tontsasmancá, chënga ents̈anga jtsamë́ndayana bëtscá mandënga chamotsocumplínama, pero cachënga ni mo bats̈atema ntsamana chë mandënga jtsocumplínama. ");
INSERT INTO kbh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chënga lempe jtsamana nÿe ents̈anga chamotsë́nÿama. Chënga chë ínÿengbiama más Bëngbe Bëtsá imobobonshana ca chamotsejuabnama, chënga monduamana tënts̈a sëndachëjënguiñe juabemana nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá, y juentsaca y buacuats̈iñe chëjënga jenábatsëcana y sibiajana nÿa tënts̈a uasebtotonanëjuangá jtsichë́tjonana. ");
INSERT INTO kbh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chënga jtsebos̈ana chë fiestënguiñe nÿa quëfseroca jtsetbiámanama, y chë judiëngbe enefjuana yebnënguenache chë más uámana luarënguiñe. ");
INSERT INTO kbh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chënga jtsebos̈ana tsáshenañe ents̈anga nÿa respétoca chamotsacheuanama, y ‘abuátambayënga ca’ chamotsachembuanámnaca chënga jtsebos̈ana. ");
INSERT INTO kbh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero ts̈ëngaftangna ndoñe s̈mattsebos̈e ents̈anga ‘abuátambayënga ca’ chacmotsachembuanama, er nÿetsca ts̈ëngaftanga mo cats̈atangcá s̈mondmëna, Bëngbe Bëtsábeñe betsos̈buachéyeca, y nÿe canÿa endmëna ts̈ëngaftangbe Buatëmbayá. ");
INSERT INTO kbh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ts̈ëngaftanga ‘taitá ca’ chë ley abuátambayënga s̈mondbétsachembuana, pero ts̈ëngaftanga ndocna quem luarents̈á ‘taitá ca’ s̈mattsechembuana; ts̈ëngaftanga nÿe canÿe Taitá s̈mondbomna, chë celoca endmëná. ");
INSERT INTO kbh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndoñe s̈mattsebos̈e ents̈anga ‘mándayënga ca’ chacmotsachembuanama; er nÿe canÿe Mandayá endmëna y cha Cristo endmëna. ");
INSERT INTO kbh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nda ts̈ëngaftangbeñe chë más uamaná tojtsemná bontsemna chë ínÿenga jtsaservénana. ");
INSERT INTO kbh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nda cachá bëtsá tojtsenobiamná, nduamaná mochántsebema; y nda cachá nduamaná tojtsenobiamnana, más bëtsá mochanjábema. ");
INSERT INTO kbh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga s̈montsama ents̈angbiama puerte totcá chaotsemna Bëngbe Bëtsabe amë́ndayoye jamashënguama, mo bës̈ás̈a cuaftsebiatamiancá. Pero ni cach ts̈ëngaftanga choye ques̈mátamashjuana, ni ínÿenga choye jamashënguama bos̈ë́ngbioye chama ques̈mátalesenciana. ");
INSERT INTO kbh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ts̈a lastema ts̈ëngaftangbiama, nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga chë viudángbioye chë tmobomna soyënga jtsabacayana, y ents̈angbe delante ts̈abá chacmotsë́nÿama y chënga s̈mojtsaíngñayama ndoñe chamondëtsetats̈ëmbuamna, Bëngbe Bëtsáftaca ts̈a jtsencuéntayana. Chë causa, Bëngbe Bëtsá ts̈ëngaftanga más jabuache ínÿengbiama cmochanjácastigaye. ");
INSERT INTO kbh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga ba luarënguenache jtsajnana canÿa ts̈ëngaftangbe ustoná onguayiñe, y s̈mojínÿena ora, ts̈ëngaftanga jamana cha chaotsemna ts̈ëngaftangbiama uta soye más merecido buajoná infiernoye chaotsama. ");
INSERT INTO kbh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ts̈a lastema ts̈ëngaftangbiama; ts̈ëngaftanga s̈mondmëna mo jtanënga ents̈anga unachayëngcá! Ts̈ëngaftanga s̈mondbétsichamo: ‘Nda ínÿabioye tbojas̈buachená ndayánaca jamama y tojayana chë Bëngbe Bëtsabe bëts yebnama chca jamama ca, cha ndoñe ntsemnana chë tbojas̈buachená soye jamama ca. Pero chë Bëngbe Bëtsabe bëts yebnents̈a castellanama cha tojajurasna, aíñe jtsemnana chë tbojas̈buachená soye jamama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Obëjémënga y nduabínÿnënga! ¿Ndayá más uámana soye yomna, chë castellano o Bëngbe Bëtsabe bëts yebna? Chë castellano Bëngbe Bëtsabiama josérviama jtsemnana, nÿe Bëngbe Bëtsabe bëts yebnoca chë castellano tojtsemnayeca. ");
INSERT INTO kbh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ts̈ëngaftanga mënts̈ánaca s̈mondbétsichamo: ‘Nda ínÿabioye tbojas̈buachená ndayánaca jamama y tojayana chë altarama chca jamama ca, cha ndoñe ntsemnana chë tbojas̈buachená soye jamama ca. Pero chë Bëngbe Bëtsabiama altaroca tojtsejájona soyëngama tojajurasna, aíñe jtsemnana chë tbojas̈buachená soye jamama ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nduabínÿnënga! ¿Ndayá más uámana soye yomna, chë Bëngbe Bëtsabiama tmojacjá soyënga o chë altar? Chë tmojacjá soyënga Bëngbe Bëtsabiama josérviama jtsemnana, nÿe chë altaroca chë soyënga tmojacjáyeca. ");
INSERT INTO kbh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nda chë altarama tojajurá, ndoñe nÿe chë altarama ntsejúrayana. Lempe chë altar juatsboca tojtsemnámnaca cha jtsejúrayana. ");
INSERT INTO kbh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nda Bëngbe Bëtsabe bëts yebnama tojajurá, ndoñe nÿe Bëngbe Bëtsabe bëts yebnama ntsejúrayana. Bëngbe Bëtsabiama cha jtsejúrayana, cha chë chents̈e oyená. ");
INSERT INTO kbh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y nda celocama tojajurá, chents̈e reycá Bëngbe Bëtsabe tbemaniñama cha jtsejúrayana y cachora Bëngbe Bëtsabiámnaca, chents̈e yotbemanabiama. ");
INSERT INTO kbh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga Bëngbe Bëtsabiama jtsequëcjnayana chë jajañents̈a sananga bnë́tsanents̈ana canÿe soye; chë binche matatémënga menta, anis y chë cominents̈a sanángnaca. Pero ts̈ëngaftanga nÿe bats̈á jtsamana chë leyents̈a más uámana soyënga, mo chë nÿetsca ents̈anga cachca derechënga chamotsebomnama, ínÿenga jtsalastemánana y chë ts̈abe soyënguiñe jtsiyenana, chca, ents̈anga ts̈ëngaftangbeñe chamotsos̈buáchema. Chë soyënga cocayé cmontsamna jtsamama, chë inÿe ts̈abe soyënga amana ntjajbanacá. ");
INSERT INTO kbh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Jtanënga ents̈anga unachayënga! Ts̈ëngaftanga chë base soyënga jamama puerte jtsenócochinÿenana, pero jtsebnë́tjombana uámana soyënga jamama, Bëngbe Bëtsá tojanmandá soyënga. Y chca, ts̈ëngaftanga s̈montsemna mo canÿe ents̈á ndayá tojtsabuchetjcá bayëfja jtsejuánama, ndoñe ntjasama, jasama ndoñe yondëlesenciana ca chë leyiñe iuayana causa. Pero s̈mondmëna mo ents̈angcá ndëmuanÿenga camellbe mënts̈ena jasana, y chë leyiñe endayana chcana jasama ndoñe yondëlesenciana ca. ");
INSERT INTO kbh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga s̈mondmëna mo ents̈angcá ndëmuanÿenga platillëjënga y tazës̈ënga shjoicajana jtsóbojabiana, pero tsoyna nÿe cachcá jonÿayana. Ts̈ëngaftanga ts̈a jtsents̈énana ents̈angbiama mo ts̈abengcá jtsinÿnama, pero ts̈ëngaftangbe ainanents̈e jútjena entsemna nÿe jtsatbëbanama y nÿe bëtscá soyënga jésebomnama juabnë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Nduabinÿna fariseo! Cochjshetsajbaná ainaniñe bacna soyënga bomnana. Chamna nÿe ts̈abe juabnënga chents̈e cochtsebomna, y lempe nts̈amo chacojtsamcá y ents̈anga chamojtsonÿacá ts̈abá echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga s̈mondmëna mo obanëngbe cuevëshënga botamana uafjantsenëshëngcá; shjoicajana puerte botamanëshënga, pero tsoyna jútjena obanëngbe betashë́ngaca y janjuana soyë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ts̈ëngaftanga chca s̈mondmëna: ents̈angbe delante ts̈ëngaftanga jtsinÿnana mo nÿetsca soyënguiñe ts̈abá amëngcá, pero ndoñe chca ques̈mátsmëna. Ts̈ëngaftangbe ainanents̈na chë bacna ents̈anga nts̈amo ndegombre tmojuabnacá ndinÿinÿnayëngcá y chë bacna soye amëngcá s̈montsejuabná. ");
INSERT INTO kbh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Ts̈a lastema ts̈ëngaftangbiama, bacna ents̈anga nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga fariseunga y ley abuátambayënga! Ts̈ëngaftanga jtsamana chë Bëngbe Bëtsabe juabna oyebuambnayënga tempsquënga bëtsëtsa ents̈anga chamotsemnama, chëngbe cuevëshënga jtsatspórmayëse. Ts̈ëngaftanga cachcá jtsamana chë nÿetsca soyënguiñe ts̈abá amë́ngaftaca, chë chëngbiama jtenójuaboyama pormániñe jtsatsbótamnayëse; ");
INSERT INTO kbh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","y chents̈ana s̈mondbétsichamo: ‘Bënga chë bëngbe bëtsëjémëngbe tempo maftsjaniyenëse, chë́ngbioye ndoñe matmënjanë́jabuache chë Bëngbe Bëtsabe juabna oyebuambnayënga jobáyama ca.’ Pero mo chëngcá canÿe buayenana sóyeca tmojabë́ngbioyna ndoñe ntsayaunanana. ");
INSERT INTO kbh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero nts̈amo s̈mojtsamcá jtsamëse, ts̈ëngaftanga s̈montsinÿanÿná ndegombre chë Bëngbe Bëtsabe juabna oyebuambnayë́ngbioye tmojanëbayëngbe ents̈anguents̈ana s̈momnama. Y mora cach ts̈ëngaftangbe bëts taitangcá ts̈ëngaftanga s̈montsama. ");
INSERT INTO kbh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Mopochocanga jamama chë bacna soyënga, chë ts̈ëngaftangbe bëts taitanga tmojanbojats̈é jamama soyënga! ");
INSERT INTO kbh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Mëts̈cuayënga, mëts̈cuaye ents̈anga! ¿Ndayá s̈mochjama chë infiernoca uabouana castigüents̈ana jótsbocama? ");
INSERT INTO kbh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chíyeca ats̈e ts̈ëngaftangbioye chanjichamuá Bëngbe Bëtsabe juabna oyebuambnayënga, ts̈abe soye tats̈ëmbënga y abuátambayënga. Pero ts̈ëngaftangna, ínÿengbioye s̈mochantsëbaye y s̈mochanjácrucificaye; ínÿengbioyna chë enefjuana yebnënguenache s̈mochanjátsets̈enaye y nÿetsca bëts pueblënguenache chënga s̈mochandúcamena. ");
INSERT INTO kbh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chíyeca, ts̈ëngaftangbiama nÿets castigo echántsemna chë nÿetsca soyënguiñe ts̈abá amënga tmojëftsóbanama; Abel, chë jóbanama chabotsemnama tondaye tonjanmá, tmojanóba orscana y Zacarías tmojanóbantscoñe. Zacarías, Berequíasbe uaquiñana, Bëngbe Bëtsabe bëts yebnents̈e tmojanóba, altar y chë ents̈anga Bëngbe Bëtsábioye imojánadorana luariñe. ");
INSERT INTO kbh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ndegombre cbë́yana, lempe chë soyëngama castigo morsca ents̈angbiama echántsemna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mënts̈ánaca Jesús tojánayana: “¡Jerusalenents̈a ents̈anga, Jerusalenents̈a ents̈anga! Ts̈ëngaftanga chë Bëngbe Bëtsabe juabna oyebuambnayënga jtsëbáyana y chë Bëngbe Bëtsabe ichmónënga ndëts̈béngaca jtsatëchë́nganjana jtsëbáyama. Bueta soye ats̈e sënjábos̈ena ts̈ëngaftanga áts̈bioye júbuajana, mo canÿe tuamba chabe bolletotémënga chabe juatëngmiásha tajsoye cuaftajayecá, pero ts̈ëngaftanga ndoñe ches̈mátsbos̈ena. ");
INSERT INTO kbh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Y s̈mochjinÿe, ats̈e mora cachcá cbochanjesë́nÿaye, y chca, ats̈na enánanga cbochanjésabashejuana, mo canÿe yebna cachcá tcojesonÿá y énañe tcojeseboshjoncá. ");
INSERT INTO kbh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y ats̈e cbë́yana, ndegombre ts̈ëngaftanga morscana ats̈e ndoñe más ques̈mochátinÿe; y ats̈e s̈mochántinÿe mënts̈á chas̈mojtsichamo ora: ‘¡Corente bendición bomná, Bëngbe Utabnabe obenánaca tojabá ca!’ ” ");
INSERT INTO kbh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Bëngbe Bëtsabe bëts yebnents̈ana tojë́ftsanbocna y ya yojtsaye. Chorna chë uatsjéndayënga chábioye tmojanobeconá y tmojanonts̈é nÿetsca chents̈a bëts yebnënga cha jinÿinÿiyana. ");
INSERT INTO kbh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Chora Jesús tojanë́yana: “Ts̈ëngaftanga lempe s̈montsonÿá. Ndegombre s̈cuayana, quem Bëngbe Bëtsabe bëts yebnents̈e ndoñe queochaisoquéda ni mo canÿe ndëts̈bé inÿe ndëts̈bé juatsboye. Lempe mochantsepochóca ca.” ");
INSERT INTO kbh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chents̈ana chënga Olivos tjashoye tmojána. Jesús choca yojtsetbemana; as, chë uatsjéndayënga tmojanobobeconá nÿe chëngbiama jatjayama, mënts̈á: —S̈më́yana. ¿Mocna ora chë soyënga Bëngbe Bëtsabe bëts yebnoca yochjochnëngo ca? ¿Ndayá yochjochnëngo bënga jinÿanÿiyama aca jésabama ora ya yojtsemnama y quem luare jopochócama tempo yojtsobecuama ca? ");
INSERT INTO kbh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","As Jesús tojanjuá: —Cuedado s̈mochtsebomna ndocná chacmondáingñema. ");
INSERT INTO kbh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Banga mochanjabo y mochantsabíchamo chënga ats̈e imomna ca. Mochántsichamo: “Ats̈e chë Cristo sëndmëna ca” y chca, ba ents̈ángbioye mochanjáingñaye. ");
INSERT INTO kbh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ts̈ëngaftanga s̈mochanjouena canÿe luarents̈a ents̈anga inÿe luaroca ents̈ángaftaca imojtsentsjanama y nderado mochjentsjámnaca. Ndoñe matauatjëngana, er chca jochnënguama endmëna; pero masque chcase, quem luare jopochócama cabá ndoñe queochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Canÿe luarents̈a ents̈anga inÿe luaroca ents̈ángaftaca mochántsentsjanaye, y canÿe amëndayábents̈a ents̈anga inÿe amëndayábioca ents̈angaftácnaca; y ba luarënguiñe shëntsana echanjóshjango y chents̈a fshantsënga echanjuangmë́mana. ");
INSERT INTO kbh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Masque chca jasúfriase, más chcoye cabá más mochanjatssúfria. ");
INSERT INTO kbh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Chora, ents̈anga ínÿengbe cucuats̈iñe cmochanjábashejuana chacmatsets̈enama y cmochantsëbaye; y ats̈be ústonënga bétsemnayeca nÿetsca luarënguents̈a ents̈anga cmochantsë́buayënja. ");
INSERT INTO kbh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chë tempo, banga mora áts̈beñe os̈buáchiyënga, os̈buáchiyana mochantsajbaná y mochantsenáboyënja y jóbanama ínÿengbe cucuats̈iñe mochántsenboshjuana. ");
INSERT INTO kbh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Banga Bëngbe Bëtsabe ndoñe ndegombre juabna oyebuambnayënga mochanjábocana y ba ents̈anga mochanjáingñaye. ");
INSERT INTO kbh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nÿets̈á bacna juabnënga ents̈angbe ainaniñe echanjésemna, y chë causa banga ndoñe quemochátenbobonshana. ");
INSERT INTO kbh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero nda nÿets tempo áts̈beñe os̈buachiyá totsomñe, atsbocaná echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y quem ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama nÿets quem luariñe ents̈ángbioye mochántsabuayiynaye, chca, chë ndegombre soyënga Bëngbe Bëtsabiama chënga chamotsetats̈ëmbuama. Chents̈ana cocayé quem luare jopochócama tempo echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Chë Bëngbe Bëtsabe juabna oyebuambnayá Daniel chë puerte uabouana soye tojë́ftsanabema chë pochócaye soyama. Ts̈ëngaftanga chë puerte uabouana soye chë uámana ca uabaina luarents̈e chas̈mojinÿe ora (nda tojtsalía, chabosertá), s̈mochántsetats̈ëmbo chë puerte ngménana tempo tojóshjanguama; ");
INSERT INTO kbh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ents̈anga Judeoca chamojtsemnënga, batsjabengoye chamotsacheta. ");
INSERT INTO kbh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Y nda cachabe yebnents̈a tsbanánoca chaojtsemna, chaotsachá chocana ntjtastjangcá ndayá tsoicana jëftsábocnama. ");
INSERT INTO kbh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Y nda jajoca chaojtsemna, yebnoye ndoñe chaondë́ta ni mo chabe quëfsaíya jesácñama. ");
INSERT INTO kbh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ts̈a lastema chë tempo ngomámanënga chamojtsemnëngbiama o ochóchaye s̈es̈onga chamojtsabamnëngbiama! ");
INSERT INTO kbh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bëngbe Bëtsá s̈mochtseimpadana chë ts̈ëngaftanga jachetama, uaftena tempo ora o canÿe ochnayté ndoñe chaondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chca, chora puerte ngménana echántsemna. Ts̈a jabuache ngmenancá, quem luare jabojáts̈ama orscana y më́ntscoñama y más chcoye, cachcá ngménana ndoñe ntjamnana. ");
INSERT INTO kbh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chë puerte ngménana tempo yapa bën ndoñe chaondë́tsemnama Bëngbe Bëtsá ndoñe tonjalesenciase, ndocná quentatsbocá; pero chabe ubuáyanënga cha corente endábabuanÿeshanayeca, echanjama yapa bën tempo ndoñe chaondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Chora nderado nda cmochanjáuyana: ‘Minÿënga, muents̈e chë Cristo entsemna’, o ‘Choca cha entsemna ca’, chë soyëngama ndoñe s̈mattsayaunana. ");
INSERT INTO kbh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chora mochanjábocana ndoñe ndegombre uámana ubuáyanënga, chënga Cristo imomna ca jtsichámëse, y Bëngbe Bëtsabe ndoñe ndegombre juabna oyebuambnayë́ngnaca; y chënga mochanjama bëts soyënga chëngbe obenana jinÿanÿiyama, ents̈anga jáingñama, y tmojobenase, chë Bëngbe Bëtsabe bocacánëngnaca. ");
INSERT INTO kbh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ats̈e ya chama tcbonjabuayená chë tempo cabá ndóshjango ora. ");
INSERT INTO kbh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chíyeca, nderado chënga chacmojáuyana: ‘Minÿënga, chents̈e chë Cristo entsemna, ents̈anga ndoyenoca ca’, choye ndoñe s̈matjá; o chacmojáuyana: ‘Cha canÿe tsoca entsemna ca’, chama ndoñe s̈mattsayaunana. ");
INSERT INTO kbh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Er nts̈amo chë tojatcuinÿe ora, shinÿe bocanoicana y shinÿe uenatjëmbambanë́ntscoñe jabuashinÿinÿenancá y ba luarënguenache ents̈anga jobenayana jinÿama, cachcá, Bëngbe Bëtsá Ents̈á tbojanbemá quem luaroye chaojésabo te, ents̈anga nÿets luarents̈e mochanjobenaye cha jinÿama. ");
INSERT INTO kbh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Canÿe obanabe cuerpo tojtsemnama chë gallinacënga tmojátats̈ëmbona y cachora chë béconana jojotana. Cachcá, chë castigo echántsemna nÿa chama chë tempo chaojtsemna ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mënts̈ánaca Jesús tojánayana: “Chë puerte ngménana tempo chaojochnëngüents̈ana, shinÿe ndoñe queochátsbuashinÿinÿana, juashcona ndoñe queochátsbinÿnaye, celocana estrellënga echanjatquë́cjana y quem luarents̈a tsbanánoca espíritënga obenana bomnënga echanjángmëmana. ");
INSERT INTO kbh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chora canÿe soye celoca echanjónÿna ents̈anga jinÿanÿiyama Bëngbe Bëtsá Ents̈á tbojanbemá ya iuaisaboma, y nÿets luarenache ents̈anga mochanjenóbos̈achna, y Bëngbe Bëtsá Ents̈á tbojanbemábioye mochanjinÿe celoca jants̈etëshiñe echántsaboye, puerte obenánaca y corente buashinÿinÿaniñe. ");
INSERT INTO kbh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y canÿe trompetë́fjua jabuache chaojuénana ora, cha chabe angelotémënga echanjichamuá Bëngbe Bëtsabe ubuáyanënga júbuajama, nÿets luarëngocana, celoca cánÿoica juachoicana y chë ínÿoica juachóntscoñe. ");
INSERT INTO kbh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nts̈amo higo betíyeca endbétsopasanama s̈mochjuatsjinÿe: Tojtsaisabuacuana y tojtsaisë́jotsana ora, chë ts̈abe tempo ya tojtsaisobecuama jtsotats̈ëmbuana. ");
INSERT INTO kbh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cachcá, lempe chë ndayama ts̈ëngaftanga tcbonjauyancá chas̈mojinÿe ora, s̈mochántsetats̈ëmbo Bëngbe Bëtsá Ents̈á tbojanbemá ya jésabama yojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndegombre cbë́yana, lempe chca echanjochnëngo, morsca ents̈anga cabá ndóbana ora. ");
INSERT INTO kbh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Celoca y quem luare echanjopochóca, pero ats̈be palabra ndocna te queochaisopochóca. ");
INSERT INTO kbh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pero ndayté y ntseco ora Bëngbe Bëtsá Ents̈á tbojanbemá yochjésabama, ndocná quenátstats̈ëmbo, ni chë celoca angelotémënga, ni Bëngbe Bëtsabe Uaquiñá. Nÿe chë Taitá chama yotáts̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Nts̈amo Noé yojëftsiyena ora tojanopasacá, cachcá echanjopása chë Bëngbe Bëtsá Ents̈á tbojanbemá chaojésabo ora. ");
INSERT INTO kbh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noebe tempo, chë uabouana uaftena cabá nduáshjango ora, ents̈anga imnasaye, imnofs̈ës̈naye y imnóbouamnaye; natjë́mbana imojtsiyeñe, y chca imojtsomñe Noé chë barquë́shoye tojánamashënguëntscuana. ");
INSERT INTO kbh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chënga tondaye imonjántats̈ëmbo, nÿe chë uabouana uaftena tojánashjango y nÿetscanga tojtsanë́yamba ora cocayé. Cachcá echántsemna Bëngbe Bëtsá Ents̈á tbojanbemá chaojésabo ora; ya chaojochnëngo ora, ents̈anga chama mochanjátats̈ëmbona. ");
INSERT INTO kbh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chora uta boyabásata jajoca bochántsemna; canÿa mochanjesbets̈e y chë ínÿana ndoñe. ");
INSERT INTO kbh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uta shembásata bochántsejanÿcoye; canÿa mochanjesbets̈e y chë ínÿana ndoñe. ");
INSERT INTO kbh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Chíyeca cuedado s̈mochtsebomna y yejuana s̈mochtsantjes̈na, er ndoñe ques̈mátstats̈ëmbo ndayté ts̈ëngaftangbe Utabná yochjésabama. ");
INSERT INTO kbh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero quem soye ts̈abá chacmësertá: Chë yebnents̈a nduiño, ntseco ora ibeta atbëbaná yochjabama tojtsetats̈ëmbëse, cha nantsefs̈na y ndocnábioye buanjaleséncia jushañe chaotsendbemama tsoye jtsamashënguama y jtsatbëbama. ");
INSERT INTO kbh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chíyeca, ts̈ëngaftángnaca s̈mochtseprontana, er Bëngbe Bëtsá Ents̈á tbojanbemá echanjésabo, ents̈anga chama tondaye chamontsejuabná ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Nda yomna chë oservená nts̈amo chë nduiño tojtsebos̈cá amá y nÿets juábnaca amá? Cha jtsemnana nda chë nduiño bochjë́ftseboshjona chë yebnents̈ënga chaotsanÿenama y jasama tojtsemna ora chaújuats̈ema. ");
INSERT INTO kbh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chë nduiño tojtashjango ora, chë oservenábioye tbojínÿena nts̈amo ibomncá jtsamëse, chë oservená puerte oyejuayá echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndegombre cbë́yana, chë nduiño chábioye bochanjaimpáda lempe chabe soyënga chabotsinÿeñama. ");
INSERT INTO kbh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero chë oservená bacna ents̈á tomnësna, jajuaboyana chë nduiño ndoñe betsco yochantabo ca, ");
INSERT INTO kbh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y as, cha jónts̈ana chë inÿe oservénënga jtsajants̈etayana, becá jtsesana y jtsetmuana inÿe tëmië́ngaftaca. ");
INSERT INTO kbh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Y chabe nduiño jtashjanguama ndoñe tontsejuabná te y ndoñe tontsetáts̈ëmbo ora, cha echántashjango. ");
INSERT INTO kbh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chora chë nduiño jabuache bochantsecastíga, y nts̈amo chë bacna ents̈anga ndayá ndegombre tmojuabnacá ndinÿinÿnayënga jasúfriama entsamncá, cha echanjasúfria. Chora cha puerte echanjenóbos̈achna y chë tsets̈anama juatsas̈ënga echantsenoftë́s̈jojnaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mënts̈ánaca Jesús tojánayana: “Chë te chaojóshjango ora, Bëngbe Bëtsabe amë́ndayana echántsemna mo nts̈amo canÿe casamento fiestents̈e tojanopasacá. Mënts̈á yojopása: Bnë́tsana tobias̈ënga chëngbe querosine uajuinÿanëshangá imojëftsájaca y imojábocana chë casamentero boyabása jajébenguama. ");
INSERT INTO kbh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chë bnë́tsana tobias̈ënguents̈ana, shachnënga sempre enójuabnayënga imnamna, y chë inÿe shachnëngna, ndenójuabnayënga. ");
INSERT INTO kbh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Chë ndenójuabnayëngna chëngbe uajuinÿanëshangá imojëftsájaca, pero querosine ndoñe imonjuabuyamba chë uajuinÿanëshangañe cachiñe jtaftsuámama. ");
INSERT INTO kbh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero chë sempre enójuabnayëngna chëngbe uajuinÿanëshangá imojëftsájaca y querosínënaca botellës̈ënguiñe imojuabuyamba. ");
INSERT INTO kbh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chë casamentero boyabásana ndoñe betsco yonjabo, chíyeca nÿetsca tobias̈ënga ocnayana yojubuache y imojtsomaná. ");
INSERT INTO kbh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mo tsë́ntseto orna, chënga imojouena mënts̈á uayebuáchana: ‘¡Chë casamentero boyabása ya endabó! ¡Jajébenguama mobocana ca!’ ");
INSERT INTO kbh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Asna, nÿetsca tobias̈ënga imojotsbaná y imojónts̈a chë uajuinÿanëshangá juabopróntana. ");
INSERT INTO kbh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chorna, chë shachna ndenójuabnaye tobias̈ënga chë inÿe shachnënga sempre enójuabnayëngbioye imojáuyana: ‘Diosmanda ts̈ëngaftangbe querosinents̈ana baseytema s̈mëbuats̈atá, bëngbe uajuinÿanëshangá tojonts̈é jtsafsanana ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero chë sempre enójuabnayëngna imojayana: ‘Ndoñe. Tcbojubuats̈atase, ts̈ëngaftangbiama y bëngbiámnaca querosine echántsashbe. Más ts̈abá entsemna, chë querosine mondbétsenoye chas̈ma y ts̈ëngaftangbiama chas̈mauábuamiñe ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Chorna, chë shachna ndenójuabnaye tobias̈ënga imojá chë querosine jauabuámiyama; pero chëntscuana chë casamentero boyabása yojáshjango y chë sempre enójuabnayënga cháftaca chë casamento fiestoye imojámashjna, y chents̈a bës̈ás̈a imojtatame. ");
INSERT INTO kbh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chents̈ana chë inÿe tobias̈ënga imojáshjajna y mënts̈á imojtsichamo: ‘¡Taita, Taita, s̈mebëtafjo ca!’ ");
INSERT INTO kbh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero chë casamentero boyabása yojójua: ‘Ndegombre cbë́yana, ts̈ëngaftanga ndoñe quecbatëbuatma ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Cachcá echántsemna Bëngbe Bëtsá Ents̈á tbojanbemá chaojésabo ora; chíyeca s̈mochtseprontana, ts̈ëngaftanga ndoñe ques̈mátstats̈ëmbo ndayté, ni mocna ora chca yochjopásama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bëngbe Bëtsabe amë́ndayana endmëna mo nts̈amo canÿe boyabásaftaca tojanopasacá. Cha ibojtsemna inÿe luaroye jtsoñama; as chabe oservénënga yojáchembo y yojaimpádaye chabe crocénana chamotsinÿenama. ");
INSERT INTO kbh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Cánÿabioye ibojánts̈abuachiye shachna uaranga crocénana, ínÿabioyna uta uaranga y ínÿabioyna canÿe uaranga. Chca yojamna nts̈amo cada ona ibojobiashjachcá. Y as chë boyabása yojtsoñe. ");
INSERT INTO kbh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Cachora chë shachna uaranga yojoyëngacñá yojá trato jabemama, y chca, inÿe shachna uaranga crocénana yojábotiye. ");
INSERT INTO kbh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chë uta uaranga yojoyëngacñá cachcá yojama y inÿe uta uaranga yojábotiye. ");
INSERT INTO kbh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero chë canÿe uaranga yojoyëngacñana, yojá, fshantsiñe yojajutjo y chabe mandayabe crocénana chents̈e yojtseitëme. ");
INSERT INTO kbh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Chents̈ana baytese chë oservénëngbe amëndayá yojtashjango y yojónts̈a chë crocenánama chënga jatjayana. ");
INSERT INTO kbh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Natsana yojáshjango chë shachna uaranga yojoyëngacñá y chabe mandayábioye inÿe shachna uaranga crocénana ibojánts̈abuachiye y mënts̈á ibojauyana: ‘Taita, aca shachna uaranga s̈conjanoyé y muents̈e entsemna inÿe shachna uaranga sënjaboté ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","As chë mandayá ibojauyana: ‘Ts̈a ts̈abá, ts̈abe oservená y nts̈amo tsbos̈cá amá. Aca quem base soyiñe lempe nts̈amo tcbojamandacá tcojámayeca, ats̈e cbochanjaimpáda más bëtscá chas̈cotsinÿeñama. Mamáshëngo y áts̈eftaca cochjóyejuaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chents̈ana chë uta uaranga yojoyëngacñá yojáshjango y chë mandayábioye ibojauyana: ‘Taita, aca uta uaranga s̈conjanoyé y muents̈e entsemna inÿe uta uaranga sënjaboté ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","As chë mandayá ibojauyana: ‘Ts̈a ts̈abá, ts̈abe oservená y nts̈amo tsbos̈cá amá. Aca quem base soyiñe lempe nts̈amo tcbojamandacá tcojámayeca, ats̈e cbochanjaimpáda más bëtscá chas̈cotsinÿeñama. Mamáshëngo y áts̈eftaca cochjóyejuaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pero chë canÿe uaranga yojoyëngacñe oservená yojáshjango orna, chabe mandayábioye ibojauyana: ‘Taita, ats̈e sëndë́tats̈ëmbo aca canÿe ts̈átjaye ents̈á comnama; acna chë ndoñe tconjajé chents̈e saná jocñana y chë ndoñe tconjujquëshe luarents̈e jobuátbanana. ");
INSERT INTO kbh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chama ats̈e uatjana s̈juábuache, chíyeca ats̈e sënjá y fshantsiñe chë crocénana sënjetseitëme. Pero muents̈e acbe crocénana entsatsmëna ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","As chë mandayá ibojojuá: ‘¡Bacna oservená y oyënjayá! Chë ndayents̈e ndoñe tijajé chents̈e saná jocñana y chë ndoñe tijujquëshe luarents̈e jobuátbanana ats̈e tsuamanama icojátats̈ëmbëse, ");
INSERT INTO kbh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","aca cmonjamna ats̈be crocénana bancoca jetsobuájuana y ats̈e matijtabo ora, ats̈be crocénana matijtóyëngacñe y chë chents̈ana tojoboté crocénanënaca ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Y as yojamë́nda: ‘Chë uaranga motseboca y chë bnë́tsana uaranga entsebomnábioye chana motsats̈etá ca. ");
INSERT INTO kbh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Er nda tojtsebomnábioye, más jats̈etayana, y chca cha corente bëtscá jtsebomnana; pero tondaye tondbomnábioyna, chë bats̈atema tobomna sóynaca jtsebocana ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Y chora cha yojayana: ‘Quem ndoservena trabajayá shjoca ibetoye matábocna; choca puerte echanjenóbos̈achna y chë tsets̈anama juatsas̈ënga echantsenoftë́s̈jojnaye ca’ ” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mënts̈ánaca Jesús tojánayana: “Chë Bëngbe Bëtsá Ents̈á tbojanbemá chabe obenánaca, buashinÿinÿaniñe y nÿetsca chabe angelotémëngaftaca chaojésabo ora, chë reybiama puerte buashinÿinÿana tbemaniñe echanjótbema. ");
INSERT INTO kbh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chora nÿets luarëngoca ents̈anga chabe natsanoica mochanjénefjna, y cha, ents̈anguents̈ana ínÿenga echanjábacacaye, mo chë oveshënga abuajë́nÿa oveshënga chivë́ngbents̈ana endbetsabacacnaycá. ");
INSERT INTO kbh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chë abuajë́nÿana, oveshënga chabe cats̈bioica echanjáchembo y chivëngna chabe uañicuayoica. Bëngbe Bëtsá Ents̈á tbojanbemá cachcá echanjama: chë ubuáyanënga chabe cats̈bioica echanjúbuaja y chë bacna ents̈angna chabe uañicuayoica echanjátsaye. ");
INSERT INTO kbh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Chorna chë Rey, Bëngbe Utabná, chabe cats̈bioica chamojtsemna ents̈anga echanjáuyana: ‘Ts̈ëngaftanga, Ats̈be Taitá ts̈ábeñe cmë́tabna, mabënga ca; ats̈be amë́ndaye luare mo ts̈ëngaftangbiama otocana soycá mosháchiñënga; ts̈ëngaftangbiama endëprontana, Bëngbe Bëtsá quem luare tonjanma orscana. ");
INSERT INTO kbh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Er ats̈e s̈onjanishëntsana y ts̈ëngaftanga saná s̈monjancaredadó; s̈onjanajuendá y ts̈ëngaftanga s̈monjanafs̈é; inÿe luarocana ashjangonacá sënjánana y posada s̈monjanánts̈ame. ");
INSERT INTO kbh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Enas̈á sënjánana y ents̈ayá s̈monjanëts̈etá jtichëtjuama; s̈ocá sënjanjájona y s̈monjanatsëtsaye; cárceloca sënjanëtámena y jabëuatsëtsayama s̈monjánabo ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“As chë Bëngbe Bëtsá chabe bominÿiñe ts̈ábenga tojábiamënga mochanjatjaye: ‘Bëngbe Utabná, ¿ntseco shë́ntseca tcbënjáninÿe y tcbënjanajuats̈é? ¿Ntseco uajuendayá tcbënjáninÿe y tcbënjanafs̈é? ");
INSERT INTO kbh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O ntseco inÿe luarocana ashjangonacá tcbënjáninÿe y posada tcbënjanánts̈ame, o enas̈á y ents̈ayá jtichëtjuama tcbënjanëts̈etá? ");
INSERT INTO kbh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O ntseco s̈ocá o cárceloca utamená tcbënjáninÿe y jauatsëtsayama tifjána ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“As chë Utabná echanjójua: ‘Ndegombre cbë́yana, lempe nts̈amo chë ats̈be cats̈átanguents̈ana chë más bats̈á uámanëngaftaca s̈mojamcá, cach áts̈eftaca s̈monjanma ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Chents̈ana chë Utabná chabe uañicuayoica chamojtsemna ents̈anga echanjáuyana: ‘Ats̈bents̈ana mojuánanga ats̈be Bëtsabe uaboténënga. Infiernoye motsajna, chë ndocna te queochátsfsana íñeshoye; choca endëprontana Satanás y chabe ustonëngbiama. ");
INSERT INTO kbh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Er ats̈e shë́ntseca sënjánana y ts̈ëngaftanga saná ndoñe ches̈matancaredadó; s̈onjanajuendá y ndoñe ches̈matanafs̈é; ");
INSERT INTO kbh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","inÿe luarocana ashjangonacá sënjánana y ndoñe posada ches̈matanánts̈ame. Enas̈á sënjánana y ndoñe ents̈ayá ches̈matanëts̈etá; s̈ocá sënjanjájona y cárceloca sënjanëtámena y ndoñe ches̈matanatsëtsá ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“As chënga mochanjatjaye: ‘Bëngbe Utabná, ¿ntseco tcbënjáninÿe shë́ntseca o uajuendayá, o inÿe luarocana ashjangonacá, o enas̈á, o s̈ocá o cárceloca utamená y ndoñe tcbënjanajabuache ca?’ ");
INSERT INTO kbh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Y chë Utabná echanjójua: ‘Ndegombre cbë́yana, ts̈ëngaftanga nts̈amo chë ats̈be cats̈átanguents̈ana chë más bats̈á uámanëngaftaca, ndoñe s̈monjanmcá, áts̈eftaca cach ndoñe ches̈mátanma ca.’ ");
INSERT INTO kbh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Chëngna infiernoye nÿetsca tescama mochantsë́setjango, y chë Bëngbe Bëtsá chabe bominÿiñe ts̈ábenga tojábiamëngna chë nÿetsca tescama yomna ts̈abe vida mochántsebomna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lempe chca tojánayanents̈ana, Jesús chabe uatsjéndayënga tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ts̈ëngaftanga s̈mondë́tats̈ëmbo, uta te y chë Bashco fiesta echántsemna y Bëngbe Bëtsá Ents̈á tbojanbemá ínÿengbe cucuats̈iñe mochanjáboshjona chamocrucificama ca.” Chë fiesta inamna jtenójuaboyama Bëngbe Bëtsá chë judiëngbe bëts taitanga Egiptocana tojánatsebacama. ");
INSERT INTO kbh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chëntscuana, chë bachnangbe amë́ndayënga y chë judië́ngbeñe bëtsëjemëngcá mándayënga tmojánenefjna, Caifás, chë bachnangbe más uámana amëndayabe bëts yebnents̈e. ");
INSERT INTO kbh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tmojanenojuabó y tmojanenoyeuná jtseíngñase Jesús jishachama, y jtsóbama. ");
INSERT INTO kbh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero imojtsichamo: “Quem fiestëntscuana ndoñe, ents̈anga yapa muanjónts̈a enbouenanana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania pueblents̈e yojtsemna, Simón chë bacna nguayanánaca s̈ocá ca uabobuatmabe yebnents̈e. ");
INSERT INTO kbh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chëntscuana canÿe shembása Jesúsbioye tojanabeconá. Chë shembásana tojanamba canÿe alabastro jarrëtema, jútjena canÿe puerte uámana botamana uanguëts̈e béjayeca. Jesús mesë́shents̈e yojtsemnëntscuana, chë shembása chabe bests̈as̈iñe chë botamana uanguëts̈e béjaye tbojanbues̈cja. ");
INSERT INTO kbh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chë uatsjéndayënga chca tmojáninÿe orna, tmojanotjayaná y tmojanonts̈é ichámuana: —¿Ndáyeca nÿe bonamente chë soye chca yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chamna, matmënjobenanga chë béjaye becá crocenánama juiyana y chánaca ndbomnëjémënga matmënjújabuache ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús chë soye tojanuena; as tojanë́yana: —¿Ndáyeca ndoñe cachcá quem shembása s̈mochanjonÿaye ca? Nts̈amo tonjamcá ts̈abá entsemna. ");
INSERT INTO kbh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Er chë ndbomnëjémëngna nÿets tempo ts̈ëngaftangbeñe mochanjë́ftsemna, pero ats̈e ts̈ëngaftangaftaca ndoñe nÿets tempo quicháisemna. ");
INSERT INTO kbh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nts̈amo chë shembása tojamcá, chë botamana uanguëts̈e béjaye ats̈be cuerpiñe jabués̈cjëse, cha s̈ontseprónta ats̈e juatbontsa tescama. ");
INSERT INTO kbh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndegombre cbë́yana, quem luariñe ndayénts̈naca Bëngbe Bëtsabe soyëngama chamojtsabuayiyná chents̈e, nts̈amo quem shembása tojamámnaca becá mochanjëftsóyebuambaye, chca, ents̈anga chabiama chamotsenójuabnama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Canÿa chë bnë́tsana uta uatsjendayënguents̈á, Judas Iscariote ca uabainá, tojána bachnangbe amëndayë́ngaftaca jencuéntama. ");
INSERT INTO kbh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Y tojanatjá: “¿Ntsachets̈á s̈matjtabuénaye y Jesús ts̈ëngaftangbe cucuats̈iñe cbochjayents̈bashejuana ca?” As chëngna, unga bnë́tsana ralbenga tmojtanabuená. ");
INSERT INTO kbh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y cach orscana Judas yojtsenguaye nts̈ámose y ntseco ora, Jesús chëngbe cucuats̈iñe jayents̈báshejuanama. ");
INSERT INTO kbh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chë Bashco fiesta bojats̈enté, chë levadúraca ndëpormana tandës̈e jasama fiestëntscuana, chë uatsjéndayënga Jesúsbioye tmojanobeconá y tmojantjá: —¿Ndë́moca aca cojtsebos̈e bënga fchaiprontama Bashco saná chacosama ca? ");
INSERT INTO kbh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y Jesús tojanë́yana: —Chë bëts puebloye motsajna canÿe bacobe yebnoye y cha s̈mochjauyana: “Buatëmbayá tonjayana: ‘Ats̈be ora ya echanjobuache, y ats̈e acbe yebnoye sëntsá, Bashco fiesta jamama ats̈be uatsjéndayëngaftaca ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","As chë uatsjéndayënga tmojanma nts̈amo Jesús tojanamëndacá y chë Bashco fiesta saná tmojanprontá. ");
INSERT INTO kbh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Y tojanibétata orna, Jesús chë bnë́tsana uta uatsjéndayëngaftaca mesë́shents̈e yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y imojtsesantscuana, Jesús tojanë́yana: —Ndegombre cbë́yana, canÿa ts̈ëngaftanguents̈á uayayëngbe cucuats̈iñe s̈ochanjáboshjona ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chora chë uatsjéndayënga puerte ngménaca imojtsemna y tmojanonts̈é canÿánÿa Jesús jatjayama: —Bëngbe Utabná, ¿nderado ats̈e cha chtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","As Jesús tojanë́jua: —Canÿa nda chabe tandës̈e entsefchecuacná cach ats̈e sëntsefchecuacná s̈cnenents̈e, cha uayayëngbe cucuats̈iñe s̈ochanjáboshjona. ");
INSERT INTO kbh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ndegombre, Bëngbe Bëtsá Ents̈á tbojanbemáftaca echanjopása nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe chabiama iuayancá; pero, ¡ts̈a lastema chë bochjáboshjonabiama! Más ts̈abá chabiama manjamna ndoñe ntjónÿnana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","As Judas, chë boshjuaná, Jesúsbioye tbojantjá: —Buatëmbayá, ¿nderado ats̈e chtsemna ca? Y Jesús tbojanjuá: —Ndegombre tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Imojtsesantscuana, Jesús tandës̈e tojanca, Bëngbe Bëtsábioye chama tbojtanchuá, tojanjatá y chë uatsjéndayënga tojanats̈atá. Y mënts̈á tojánayana: “Mocñënga, mosënga. Ats̈be cuerpo entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chents̈ana, canÿe coptema vínoyeca tojanaca, Bëngbe Bëtsábioye tbojtanchuá y chë uatsjéndayënga tojanëfs̈as̈é. Y mënts̈á tojánayana: “Nÿetscanga quem coptéments̈ana mofs̈enga. ");
INSERT INTO kbh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Quem vínoye ats̈be buiñe entsemna. Ats̈be buiñe echanjuábuashana ents̈anga chamotsetats̈ëmbuama nts̈amo Bëngbe Bëtsá ents̈anga tojanas̈ebuachenacá aíñe yochjochnënguama. Chë buiñe bëtscá ents̈angbiama echanjuábuashana, chëngbe bacna soyëngama perdonánënga chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Y ndegombre cbë́yana, morscana ats̈e ya ndoñe más chë uvasents̈ana obocniye quichaisofs̈iye. Chë tsëm vínoye ts̈ëngaftangaftaca chanjofs̈iye, ats̈be Taitabe amë́ndayoca chamojtsemna ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bëngbe Bëtsá jëtschuayama tmojancantá chents̈ana, Olivos tjashoye tmojë́ftsanbocana. ");
INSERT INTO kbh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Choca Jesús tojanë́yana: —Ts̈ëngaftanga nÿetscanga quem ibeta áts̈beñe os̈buáchiyana s̈mochantsobuets̈e y s̈mochántsacheta, er Bëngbe Bëtsabe uabemana palabrënguiñe, cha mënts̈á tojánayana: “Chë oveshëngbe abuajë́nÿa chanjóba y chë oveshënga mochantsáshana ca.” Chca ts̈ëngaftangaftaca echanjopása, uayayënga chas̈mojishache ora. ");
INSERT INTO kbh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero obanënguents̈ana chaitayenents̈ana, ts̈ëngaftangbe natsana Galileoye chanjá ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chora Pedro tbojanjuá: —Masque nÿetscanga ácbeñe os̈buáchiyana chamotsobuets̈e y chamotsacheta, nts̈amo ácaftaca yochjopása causa, ats̈e ndocna te ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","As Jesús tbojaniyana: —Ndegombre cbëyana, cam ibeta, ngallo cabá ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero Pedro tbojaniyana: —Masque chas̈otsemna ácaftaca jóbanama, ats̈e ndoñe quichátayana ndoñe cbonduabuatma ca. Y nÿetsca uatsjéndayëngnaca cachcá imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chents̈ana, Jesús chabe uatsjéndayëngaftaca canÿe luare Getsemaní ca uabáinoye tojána. Choca tojanë́yana: “Muents̈e motbiama, chëntscuana ats̈e choye chanjá Bëngbe Bëtsáftaca jencuéntama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Y Pedro y chë Zebedeobe uta uaquiñata tojë́ftsanëbiats̈e. Choca yojónts̈a puerte ngménaca y corente cochtsets̈enaná jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesús tojanë́yana: “Ats̈be ainana puerte ngménaca entsemna, mo jobanamcá. Muents̈e moquedanga y áts̈eftaca s̈mochtsefs̈na ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chora Jesús más natsanoye tojána, tojanoshaments̈é y fshantsóntscoca yojotsejbéna, y mënts̈á Bëngbe Bëtsáftaca tbojanencuentá: “Ats̈be Taitá, jopódianëse moma ats̈e japadésama ndoñe chas̈ondë́tsemnama. Pero nts̈amo ats̈e stsebos̈cá ndoñe chaondë́tsemna, sinó nts̈amo aca cojtsebos̈cá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chents̈ana, Jesús chabe unga uatsjéndayëngbioye tojtanabo y chëngna imnétsomañe. Chca tojánanÿena ora, Pédrëbioye tbojaniyana: “¿Ni mo canÿe horatema ts̈ëngaftanga s̈monjobená áts̈eftaca jtsefs̈nana ca? ");
INSERT INTO kbh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","S̈mochtsefs̈na y Bëngbe Bëtsáftaca s̈mochtsencuéntaye, chca, bacna soye jamama ndoñe chacmondócochënguama. Ts̈ëngaftanga ndegombre s̈montsebos̈e espíritoca Bëngbe Bëtsá joyeunayama, pero cuerpiñe añemo ndoñe ques̈mátsbomna ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Uta soyama tojtesaná y mënts̈á Bëngbe Bëtsáftaca tbojanencuentá: “Ats̈be Taitá, ats̈e japadésama ndoñe chas̈ondë́tsemnama jamama ndoñe jopódianësna, nÿe nts̈amo aca cojtsebos̈cá chaotsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y tojtanabo ora, chë uatsjéndayënga cachiñe imnétsomañe; yapa ocnaye causa nÿe imojtsefshétana. ");
INSERT INTO kbh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","As Jesús cachcá yojëftsë́nÿaye, y ungama cachiñe tojtesaná Bëngbe Bëtsáftaca jencuéntama, y cach palabrënga tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chora chë uatsjéndayëngbioye tojtanabo y tojanë́yana: “¿Cabá s̈motsomañe y s̈motsochnañe ca? Ya ora tocjobuache, Bëngbe Bëtsá Ents̈á tbojanbemá bacna soye amëngbe cucuats̈iñe mochanjáboshjona. ");
INSERT INTO kbh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Motsbananga, cuajna. Minÿënga, chë boshjuaná ya entsebeconá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús cabá yojtsóyebuambnantscuana, Judas, canÿe chë bnë́tsana uta uatsjendayënguents̈á, tojánashjango, y cháftaca imojtsemna ba ents̈anga espadë́jangaca y ngarotbéngaca prontánënga. Chënga imojamna chë bachnangbe amë́ndayënga y chë judië́ngbeñe bëtsëjemëngcá amë́ndayëngbe ichmónënga. ");
INSERT INTO kbh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, chë boshjuaná, tojanjuabó nts̈amo jamana ents̈anga jinÿanÿiyama ndëmua Jesús bétsemnana. Chíyeca yojáuyana: “Nda chaijauámocho, cha echántsemna. S̈mochjishache ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cachora Judas Jesúsbioye tojanobeconá y tbojanchuá: —Buajtana, Buatëmbayá ca. Y tbojtanámocho. ");
INSERT INTO kbh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús tbojaniyana: —Enutá, moma chë ndayá jabomama tcojabo ca. Chorna, chë ents̈anga tmojanobeconá, Jesús tmojánishache y tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chca orna, canÿe enutá Jesúseftaca yojtsemná, chabe espadëja tojanenosë́ngbotënts̈ena, y chë bachnangbe más uámana amëndayabe oservenábioye canÿe matscuas̈e tbojtsanë́stjango. ");
INSERT INTO kbh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","As Jesús tbojaniyana: “Espadëja matosëngbuajonÿá. Nda espadë́jaca tbojóba chana, cach espadë́jaca echanjóbana. ");
INSERT INTO kbh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Aca ndoñe condë́tats̈ëmbo, ats̈e ats̈be Taitábioye stjaimpádase, cha cachora ats̈biama nanjichamuá bnë́tsana utama más ejércitënga angelotémëngaca? ");
INSERT INTO kbh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero chcasna, ¿ndayá Bëngbe Bëtsabe uabemana palabrënguiñe endayancá nts̈amo nanjochnëngo? Chiñe endayana nts̈amo entsopasancá jochnënguama canmëna ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Cachora Jesús ents̈anga tojanatjá: “¿Ndáyeca s̈mojabo espadë́jangaca y ngarotbéngaca ats̈e jishachama, mo ats̈e canÿe bacá uamana ents̈á cuaftsemncá ca? Ats̈e cada te Bëngbe Bëtsabe bëts yebnoca ts̈ëngaftangaftaca sënjántbemana abuátambaye, y choca ndoñe ches̈mátanishache. ");
INSERT INTO kbh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero lempe quem soyënga chca entsopasana, cachcá chaotsemnama nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe chë Bëngbe Bëtsabe juabna oyebuambnayënga tmojanayancá ca” —Jesús tojánayana. Cachora nÿetsca uatsjéndayënga tmojtsanëuatjaná y tmojtsanacheta, y Jesús chë uayayë́ngaftaca cachcá tmojesanonÿá. ");
INSERT INTO kbh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chë Jesús tmojánishachënga, tmojanánatse, Caifás chë bachnangbe más uámana amëndayabe yebnoye. Chents̈e chë ley abuátambayënga y chë judië́ngbeñe bëtsëjemëngcá amë́ndayënga tmojánenefjna. ");
INSERT INTO kbh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro bënocana Jesús tbojanasto, chë bachnangbe más uámana amëndayabe chashjóntscoñe; choye tojánamashëngo y chë Bëngbe Bëtsabe bëts yebnoca josticië́ngaftaca yojótbema, chca, jtsetats̈ëmbuama nts̈amo yochjopásama. ");
INSERT INTO kbh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chë bachnangbe amë́ndayënga, chë bëtsëjemëngcá amë́ndayënga y ínÿenga judiëngbe amë́ndayënga imojtsenguaye ndánaca masque uayátsenaye soye Jesusbe contra cháuayanama, as chënga jobenayama cha chaóbana ca jayanama, ");
INSERT INTO kbh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","pero ndoñe tmonjáninÿena, masque banga tmojánashjajna Jesusbe contra uayátsenaye soyënga jayanama. Cabana, útata tbojánashjango, ");
INSERT INTO kbh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","y chata tbojánayana: “Quem boyabása tonjayana canobena Bëngbe Bëtsabe bëts yebna jtsenásatajchcana y nÿe unga tese jtëtsjebuana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","As chë bachnangbe más uámana amëndayá tojantsá y Jesúsbioye tbojantjá: —¿Ndocá cochanjayana? ¿Ndayase yojtsemna chë acbe contra montsichamo soye ca? ");
INSERT INTO kbh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús nÿe iytëca yojtsemna. Chíyeca chë bachnangbe más uámana amëndayá tbojaniyana: —Bëngbe Bëtsá Ainabe mándoca cbomandá chas̈cuyana aca ndegombre chë Cristo, chë Bëngbe Bëtsabe Uaquiñá comna o ndoñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chora Jesús tbojanjuá: —Aca ndegombre yomncá tcjayana. Y quem sóynaca cbë́yana: Ts̈ëngaftanga s̈mochanjinÿe, ats̈e, Bëngbe Bëtsá Ents̈á tbojanbemá, chë nÿets obenana bomnabe cats̈bioica jtsetbemanana y celoca jants̈etëshiñe jtsaboyana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chora chë bachnangbe más uámana amëndayá chabe uichëtjonëjuangá yojtsenánts̈ajatanëca, puerte ibojtsetna causa, y tojánayana: —¡Nts̈amo quem boyabása tonjoyebuambacá, Bëngbe Bëtsabiama entsemna mo cha cuafjoyenguangcá, chë chabe Uaquiñá yomna ca cha tonjayana ora! ¿Ndayama más ents̈anga s̈ochjátëjaboto Jesusbe contra chamuayanama? ");
INSERT INTO kbh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nts̈amo s̈matjayana ca? —cha tojanatjá. As chë ents̈anga tmojanjuá: —Ndegombre cha bëts bacna soye entsebomna; jóbanama bontsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chora tmojanonts̈é Jesús juebëbuashëtjnayana, jabuache jants̈etayana y ínÿengna imojtsejuébjants̈etaye, ");
INSERT INTO kbh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","y imojtsatsëtsnaye: “Cristo, aca ndegombre Bëngbe Bëtsabe juabna oyebuambnayá tcomnëse, ¡momalisiá nda tcmënjajants̈etá ca!” ");
INSERT INTO kbh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chëntscuana Pédrëna shjoca yojtsemna, chashjoca yojtsetbemana. Chora, canÿe shembása chents̈a oservená tbojanobobeconá y tbojaniyana: —Acnaca, Jesús chë Galileocáftaca conjánana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero Pédrëna, nÿetscangbe delante tojánayana chábioye ndoñe bonjanabuátma ca, mënts̈á jayanëse: —Nts̈amo contsichamcá, ndoñe ques̈nátësertana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chora Pedro bës̈oye yojábocna. Chents̈na, inÿe shembása oservená chábioye tbojáninÿe y chë inÿe ents̈anga tojanë́yana: —Cha, Jesús chë Nazaretocáftaca enjánana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro cachiñe tojánayana ndoñe bonjanabuátma ca, y mënts̈á yojtsejúraye: —¡Chë boyabása ndoñe quetsatabuatma ca! ");
INSERT INTO kbh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chents̈ana, chë chents̈e imojtsemnënga Pédrëbioye tmojanobeconá y tmojaniyana: —Ndegombre, ácnaca chë uatsjendayënguents̈á condmëna. Chë contsoyebuambnacá contsoyátëmbana ca. ");
INSERT INTO kbh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chora Pedro tojanonts̈é ichámuana, Bëngbe Bëtsá chas̈otsecastigá ndoñe ndegombre soye stsichámëse ca; yojtsejúraye y yojtsichamo: —¡Chë boyabása ndoñe quetsatabuatma ca! Y cachora canÿe ngallo yojacánta. ");
INSERT INTO kbh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y Pedro yojenójuaboye nts̈amo Jesús tbojaniyanama. Cha mënts̈á tbojaniyana: “Cabá ngallo ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca.” Y chents̈ana tojésanbocna y corente ngménaca yojtsenóbos̈achna. ");
INSERT INTO kbh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tojanbinÿna ora, nÿetsca chë bachnangbe amë́ndayënga y judië́ngbeñe bëtsëjemëngcá amë́ndayënga tmojánenefjna jenóyeunayama nts̈amo jamëse Jesús chaóbanama. ");
INSERT INTO kbh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","As, Jesús tmojanëcuébatsëca y tmojanánatse, y chca, Pilato, chë Judeoca Romano mandadbe cucuats̈iñe tmojánboshjona. ");
INSERT INTO kbh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, chë boshjuaná, Jesús jóbanama ibojtsemnama tojanuena ora, puerte yojtsenócochinÿena nts̈amo tojánchjanguama, y chë unga bnë́tsana ralbenga chë bachnangbe amë́ndayënga y bëtsëjemë́ngbioye tojtanamba, ");
INSERT INTO kbh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","y mënts̈á tojanë́yana: —Puerte bacna soye tijama. Ats̈e canÿe bacna soye ndbomná ts̈ëngaftangbe cucuats̈iñe tijáboshjona chaóbanama ca. Pero chënga tmojanjuá: —¿Chë soye ndayá bëngbiama? Cach aca cochátotats̈ëmbñe ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","As Judas chë ralbenga Bëngbe Bëtsabe bëts yebnents̈e yojesëts̈ana, y yojá y yojétsentses̈aye. ");
INSERT INTO kbh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chë bachnangbe amë́ndayëngna chë ralbenga tmojtanatbaná y tmojánayana: —Quem crocenánama buiñe echanjuábuashana; nts̈amo leyiñe endayancá, bënga ndoñe quemuátobena chë Bëngbe Bëtsabiama soyënga quëcjnayëtémiñe chana jasegórana ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chcasna, chënga tmojanenoyeuná, chë crocenánacna chë Alfarerbe Luare ca uabaina fshantse jabuámiyana, y chca, canÿe luare jtsebomnama ndayents̈e chë inÿe luarëngocana ents̈anga áshjajnënga jutabuantsama. ");
INSERT INTO kbh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chíyeca, chë fshantse më́ntscoñama Buiñe Luare ca iuabaina. ");
INSERT INTO kbh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chca, tojanochnëngo nts̈amo Jeremías, chë Bëngbe Bëtsabe juabna oyebuambnayá, tempscá tojanayancá, ndayá yochjanchnënguama. Chana mënts̈á tojánayana: “Y chë unga bnë́tsana ralbenga tmonjanca, ntsachets̈á chë Israeloca ents̈anga cha tmojanamananacá, ");
INSERT INTO kbh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","y chánaca chë Alfarerbe Luare tmonjanbuamé, nts̈amo Bëngbe Bëtsá s̈onjanmandacá ca.” ");
INSERT INTO kbh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chents̈ana Jesús, chë mandado Pilátbioye tmojanánatse y cha mënts̈á tbojantjá: —¿Aca chë judiëngbe rey cojtsemna ca? Y Jesús tbojanjuá: —Aíñe, aca ndegombre yomncá tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chë bachnangbe amë́ndayënga y chë bëtsëjémënga Jesús mal imojtsequédantscuana, cha ndocá ntjojuana. ");
INSERT INTO kbh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chíyeca Pilato tbojantjá: —¿Ndoñe contsuenana lempe nts̈amo acbe contra montsichamcá ca? ");
INSERT INTO kbh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús ni canÿe palabra ndoñe ntjojuana. Chë causa, chë mandado ndoñe yontsetáts̈ëmbo nts̈amo jajuaboyana. ");
INSERT INTO kbh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bashco fiesta ora, chë mandado yojanamana canÿe utamená jëtsboshjonana, nda ents̈anga tmojuabuayaná. ");
INSERT INTO kbh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chë tempo canÿe uachuana utamená inamna, Jesús Barrabás ca uabainá. ");
INSERT INTO kbh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nÿetsca ents̈anga chents̈e imojtsemna ora, Pilato tojanatjá: “¿Ts̈ëngaftanga nda s̈mojtsebos̈e ats̈e chjëtsboshjonama, Jesús Barrabás o Jesús, chë Cristo ca monduabobuatmá ca?” ");
INSERT INTO kbh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Er chë mandado yojtsetáts̈ëmbo, ents̈angna envidia causa Jesús chabe cucuats̈iñe tmojánboshjonama. ");
INSERT INTO kbh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato chë tribunal ca uabáinents̈e yojtsetbemanëntscuana, chabe shema canÿa tbojanichmó mënts̈á cha jauyanama: “Chë nÿetsca soyënguiñe ts̈abá ama ents̈ábioye ndocá matsborlánana; chabe causa ibeta otjénayoca puerte sënjasufrí ca.” ");
INSERT INTO kbh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero chë bachnangbe amë́ndayënga y chë bëtsëjémënga ents̈anga tmojanayënjaná, Barrabás jëtsboshjonama y Jesús chaóbana ca chamuayanama. ");
INSERT INTO kbh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chora chë mandado cachiñe tojanatjá: —¿Chë útatents̈ana nda s̈mojtsebos̈e ats̈e chjëtsboshjonama ca? Y chënga tmojánayana: —¡Barrabás ca! ");
INSERT INTO kbh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato tojanatjá: —¿As, ndayá Jesús, chë Cristo ca uabobuatmáftaca ats̈e chjama ca? Y nÿetscanga tmojanjuá: —¡Motsecrucificá ca! ");
INSERT INTO kbh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Chora Pilato tojtëtanatjá: —¿Ndáyeca? ¿Nts̈amo cha tojobuachjanguá ca? Pero chënga cachiñe tmojanáyebuachena: —¡Motsecrucificá ca! ");
INSERT INTO kbh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ndocá jamama yontsobenama y ents̈anga más jabuache enbouenanama tmojanonts̈ema Pilato tojáninÿe ora, cha tojanmandá búyeshe juabuíyëboñana y nÿetscangbe delante yojtsenacuents̈abiá. Mënts̈á tojánayana: —Ats̈e ndocá chiyátayana, ni chiyatsma quem boyabása chaóbanama. Ts̈ëngaftanga lempe s̈monjama ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chora nÿetsca ents̈anga tmojanjuá: —¡Quemuá yochjóbanama, bënga y bëngbe básengbiama castigo chaotsemna ca! ");
INSERT INTO kbh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","As Pilato, Barrabás tbojtanboshjona; tojanmandá soldadënga Jesús jabuache chamotsetsets̈enama y chents̈ana ents̈angbe cucuats̈iñe tbojánboshjona chamocrucificama. ");
INSERT INTO kbh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chents̈ana, chë mandadbe soldadënga Jesús tmojanánatse chë mandadbe bëts yebnents̈a chashjoye y choca nÿetsca soldadënga chabe shë́conana tmojanójoto. ");
INSERT INTO kbh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chorna, ents̈ayá tmojtsanabotsca y shbuenda uafjatsenga ents̈ayá mo reycá tmojanichëtjo. ");
INSERT INTO kbh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Canÿe coronë́sha tmojanapormá uchmas̈ë́fjangaca y tmojanabests̈ajó, y cats̈bioica cucuats̈iñe canÿe niñëfja. Chorna, chabe shecuats̈ents̈e imojtsofshëntsaménts̈enaye y imojtsáboyejuana. Mënts̈á imojtsichamo: “¡Bayté judiëngbe Rey cochtsemna ca!” ");
INSERT INTO kbh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chë́ngnaca imojtsanbuashëtjnaye y cach niñë́fjaca bests̈as̈ents̈e imojtsë́tsjanjnaye. ");
INSERT INTO kbh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y chca imnaftsáboyejuanents̈ana, chë shbuenda uafjatsenga ents̈ayá tmojtsanabotsca y cachabe ents̈ayá tmojtanichëtjo, y chora, jacrucifícama tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chë ents̈anga chents̈ana tmojánbocana ora, tmojánenbets̈e canÿe bacóftaca, Simón ca uabainá, Cirene pueblocá. As, cha tmojanmandá Jesusbe cruz chauetsocutsama. ");
INSERT INTO kbh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Canÿe luare Gólgota ca uabáinoca tmojánashjajna ora (hebreo biyañe chca endayana “Obanabe Bests̈ashe Luare ca”), ");
INSERT INTO kbh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jesúsbioye vínoye hiéloyeca enájuabniye tmojanabuiyé chaofs̈ema; pero yojaftántia y ndoñe yonjábos̈ena chiye jofs̈iyama. ");
INSERT INTO kbh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ya tmojancrucificá orna, chë soldadënga Jesusbe ents̈ayamna, tsbanánoye tmojanë́ts̈ena, chca, jtsetats̈ëmbuama ndabiama yochjanáquedama. ");
INSERT INTO kbh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Y chora chënga chents̈e tmojanotbiama Jesús jtsebojanÿama. ");
INSERT INTO kbh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y chabe bests̈as̈e juatsboicna canÿe uabemana soye tmojananjo. Chiñe yojétsayana ndáyeca cha tmojancrucificama, mënts̈á: MUA JESÚS ENDMËNA, CHË JUDIËNGBE REY ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Utata bacna soye ochjajnayátnaca chënga chents̈e tmojanacrucificá, canÿa Jesusbe cats̈bioica y chë ínÿana chabe uañicuayoica. ");
INSERT INTO kbh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Y chëjana imojtsachnëjuana ents̈angna, Jesús imojtsóyenguaye, imojtsobests̈fshanenaye ");
INSERT INTO kbh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","y imojtsatsaye: “¡Aca chë icobena Bëngbe Bëtsabe bëts yebna jtsenásatajchcana y nÿe unga tese jëtsjebuana, cach aca mentsbocá! ¡Ndegombre Bëngbe Bëtsabe Uaquiñá tcomnëse, chë cruzocana matastjango ca!” ");
INSERT INTO kbh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chë bachnangbe amë́ndayënga, ley abuátambayënga y chë judië́ngbeñe bëtsëjemëngcá mándayënga cachcá imojtsóyenguaye. Mënts̈á imojtsichamo: ");
INSERT INTO kbh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Cha ínÿenga tojëftsatsebacá, pero cachá jéntsbocama ndoñe quenátobena. Cha Israeloca ents̈angbe Rey tojtsemnëse, chë cruzocana chauatastjango, y chca, bënga chábeñe fchtsos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cha tojayana Bëngbe Bëtsábeñe puerte yojtsos̈buaché ca. ¡Mora Bëngbe Bëtsá chabuatsbocá, cha ndegombre muábioye tbobobonshánëse!, er cha tonjánayana Bëngbe Bëtsabe Uaquiñá canmëna ca” —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y chë bacna soye ochjajnayata, Jesúseftaca ibojtsecrucificanátnaca cachcá ibojtsóyenguaye. ");
INSERT INTO kbh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nÿetsto orscana las tresë́ntscoñe, nÿets quem luare yojtseibétata. ");
INSERT INTO kbh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chca orna, Jesús chabe biyañe tojanáyebuachena: “Elí, Elí, ¿lema sabactani ca?” (Chca endayana “Ats̈be Bëtsá, ats̈be Bëtsá, ¿ndáyeca cachcá s̈cojonÿá ca?”) ");
INSERT INTO kbh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chca tmojanuena ora, báseftanga chents̈e imojtsemna ents̈anguents̈ana imojtsichamo: “Cha Elías, chë Bëngbe Bëtsabe juabna oyebuambnayá, bontsechembuana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","As chora, chents̈a canÿa tojëftsanótjajo canÿe esponjëshe janguanguama, untja vínoyeca chëshe tojanfchecuacuá, canÿe niñëfjiñe tojananguësëtjo y Jesúsbioye tojanbeconá chaofs̈ema. ");
INSERT INTO kbh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ínÿengna tmojánayana: “Cachcá mochjonÿaye, er Elías tayochjabo jabátsbocama ca.” ");
INSERT INTO kbh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero Jesús cachiñe jabuache tojanoyó y tojanóbana. ");
INSERT INTO kbh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y cachora, Bëngbe Bëngbe Bëtsabe bëts yebnoca yojújonÿana ents̈ë́jua tsëntsaca yojtsenájataye, tsbanánocana fshantsoye. Chëjua bënë́jua inauamna y chë tsatsëntsaca inaújonÿana. Fshantse yojuangmë́mana, ndëts̈benga yojtsashtëts̈ana, ");
INSERT INTO kbh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","y chë cuevëshënga obanë́ngaca yojtsëtëfjo y banga Bëngbe Bëtsabe ents̈anga tmojtanayena. ");
INSERT INTO kbh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Y chënga, Jesús tojtanayenents̈ana, chë cuevëshënguents̈ana tmojánbocana, y Jerusalén, chë uámana bëts pueblo ca uabáinoye tmojánamashjna y ba ents̈ángbioye tmojánebëbuacana. ");
INSERT INTO kbh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Chë soldadëngbe amëndayá y chë ínÿenga, Jesús jtsebojanÿama cháftaca tmojanoquedanga, chë fshantse yojuangmë́manama tmojáninÿe ora, y nÿetsca chë yojtsëchnëjuana soyëngama, puerte auatjanánënga imojtsemna y tmojánayana: “¡Ndegombre quem boyabása Bëngbe Bëtsabe Uaquiñá yomna ca!” ");
INSERT INTO kbh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ba shembásengnaca chents̈e imojtsemna y bënocana imojtserreparana. Chëngna, Galileocana Jesús tmojanasto y cha imojanájabuachana. ");
INSERT INTO kbh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chë shembásengbeñe imojtsemna María Magdalena; María, Santiago y Josebe mamá; y Zebedeobe uaquiñatbe mamá. ");
INSERT INTO kbh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ya yojtseibétatana ora, canÿe bomna boyabása, José ca uabainá, tojánashjango. Cha inamna Arimatea luarocá y Jesusbe ustoná. ");
INSERT INTO kbh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José tojána Pilato jinÿama, Jesusbe cuerpo jotjañama. As Pilato tojanmandá chë cuerpo chamonts̈abuáchema. ");
INSERT INTO kbh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José chë cuerpo tojanca y canÿe nduatsenga lino ents̈ë́juaca tbojanandmaná. ");
INSERT INTO kbh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Y canÿe chabe tsëm cuevëshiñe tbojanjajó. Tempo cha inamánda chë cuevëshna ndëts̈benguiñe chamopormama. Canÿe bëts ndëts̈bé tojansjoná y chë cuevëshoye amashjuanents̈e tojánachto; y chents̈ana José yojtsatoñe. ");
INSERT INTO kbh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pero María Magdalena y chë inÿe Mariyna chents̈e tbojtsanoquedañe y chë cuevëshe ndirichiñe tbojanótbema. ");
INSERT INTO kbh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yëfsana, chë ochnayté, chë bachnangbe amë́ndayënga y chë fariseunga cánÿiñe tmojána Pilato jinÿama. ");
INSERT INTO kbh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tmojaniyana: —Taita, bënga fsëntsejuabná nts̈amo chë bostero cabá ainá ora tonjánayanama, chë unga tianoye cha jtayenama ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chíyeca, momandá chë cuevëshe soldadënga chamotsashanÿá unga tentscuana. Chca, chabe uatsjéndayënga ndoñe ibeta chamondabo chabe cuerpo jabétsatbëbama, y chents̈ana chënga ents̈anga chamúyana, Jesús tojtayena ca. Y chca, chabiama quem ústonoye bostero soye, chë cachabiama tojánayana soyëngama puerte más bacá nántsemna ca —chënga tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","As Pilato tojanë́yana: —Ts̈ëngaftanga cach ts̈ëngaftangbiama soldadënga s̈mondábamna. Motsajna y chë cuevëshe cuedádoca s̈mochtsashanÿá, nts̈amo s̈mondëtats̈ëmbcá ca. ");
INSERT INTO kbh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chora chënga tmojána chë cuevëshe jtsashanÿama; chë ndëts̈bena, tsengájas̈eca imojuinÿnaná, ntsotats̈ëmbcá ndocná choye chaondámashënguama, y soldadënga chents̈e tmojë́ftsanabashejuana. ");
INSERT INTO kbh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ochnayté chents̈ana, chë inÿe semana bojats̈enté yojtsebínÿana ora, María Magdalena y chë inÿe María tbojána cuevëshoye jarrepárama. ");
INSERT INTO kbh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ndeolpe fshantse tojanangmë́mana, er Bëngbe Bëtsabe canÿe ángel celocana tojántsma, chë cuevëshoye tojanobeconá, chë atamiana ndëts̈bé tojtsanjuaná y chiñe tojanótbema. ");
INSERT INTO kbh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chë ángelna mo canÿe tcuinÿëjcá yojtsebuashinÿinÿana, y chabe uichëtjonëjuangá uafjantsëjuangá mo jants̈etëshcá yojtsamna. ");
INSERT INTO kbh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chë soldadënga chca tmojáninÿe ora, de auatja yojtsangmëmnaye y mo obanëngcá imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chora chë ángel chë shembásatbioye tojanë́yana: “Ndoñe batauatjana. Ats̈e së́ntsetats̈ëmbo ts̈ëngaftanga Jesús, chë tmonjancrucificá cha s̈mojtsenguama. ");
INSERT INTO kbh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Cha muents̈e ndoñe quenátsmëna; cha tontayena, nts̈amo cachá tonjanayancá. Mabata y s̈ochjinÿe cha endétsesegoranents̈e. ");
INSERT INTO kbh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Betsco motsata y chë uatsjéndayënga s̈ochjáuyana: ‘Jesús tontayena y ts̈ëngaftangbe natsana Galileoye echanjá; choca s̈mochanjinÿe ca.’ ” Y chora cha tojánayana: “Chca s̈ondmëna ts̈ëngaftanga jauyanana ca.” ");
INSERT INTO kbh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Cachora chë shembásata chë cuevëshents̈ana tbojésanbocna, auatjanánata pero puerte oyejuayata, y tbojë́ftsanotjajo chë soye chë uatsjendayë́ngbeñe jobuambayama. ");
INSERT INTO kbh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Y ndeolpe Jesús chata tojánebëbuacna y tojanacheuá. Chatna, chábioye tbojanobéconata, tbojtanadorata y chabe shecuats̈e shë́conana imojtobojcjuá. ");
INSERT INTO kbh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y Jesús tojanë́yana: “Ndoñe batauatjana. Motsata ats̈be uatsjéndayënga, ats̈be cats̈átanga jáuyanama Galileoye chamotsá y choca ats̈e s̈mochjinÿe ca.” ");
INSERT INTO kbh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chë shembásata ibojtsayëntscuana, básefta soldadënga chë bëts puebloye tmojána y nts̈amo tojanopasacá lempe chë bachnangbe amëndayë́ngbeñe tmojanobuambá. ");
INSERT INTO kbh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","As chë bachnangbe amë́ndayënga, chë judië́ngbeñe bëtsëjemëngcá mandayë́ngaftaca tmojánenefjna jenóyeunayama. Chëngna chë soldadë́ngbioye bëtscá crocénana tmojtanats̈atá, ");
INSERT INTO kbh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y mënts̈á tmojanabuayená: “Ts̈ëngaftanga s̈mochjayana, ibeta s̈motsomáñëntscuana, Jesusbe uatsjéndayënga tmojabo y chabe cuerpo tmojabétsatbëba ca. ");
INSERT INTO kbh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y chë mandado chë soyama chaojátats̈ëmbonëse, bënga lempe cháftaca fchjenóyeunaye, chca, ts̈ëngaftangaftaca ndocá chaondopasama ca” —chënga tmojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","As chë soldadënga chë crocénana tmojanóyëngacñe y tmojanma nts̈amo chë mándayënga tmojanabuayenacá. Ba ents̈anga chë cuento tmojanuena y më́ntscoñama judiënga cachcá mondbétsichamo. ");
INSERT INTO kbh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chents̈ana, chë bnë́tsana canÿe uatsjéndayënga Galileoye tmojána, chë ndëmua tjoye Jesús chënga tojanabuayená choye. ");
INSERT INTO kbh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y Jesús tmojáninÿe ora, tmojtanadorá. Pero báseftangna imojétsejuabnaye nderado cha ndoñe Jesús yontsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús chë́ngbioye tojanobeconá y tojanë́yana: “Bëngbe Bëtsá nÿets mando ats̈e s̈onjats̈etá celoca y quem luarents̈e. ");
INSERT INTO kbh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chcasna, motsajna, nÿets luarënguenache oyenënga ats̈be uatsjéndayënga s̈mochjábiama. Ents̈anga s̈mochjubaye ats̈be Taitá, ats̈e chabe Uaquiñá y chë Uámana Espíritbe uabaina jayanëse, áts̈beñe s̈mos̈buachéyeca, ");
INSERT INTO kbh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","y s̈mochjabuatambá lempe nts̈amo ats̈e tcbojamëndacá chënga chamóyeunama. Y ndegombre ats̈e nÿets tempo ts̈ëngaftangaftaca chanjë́ftsemna, quem luare jopochócantscuana ca” —Jesús tojanë́yana.");
INSERT INTO kbh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mënts̈á tojanobojats̈é chë ts̈abe noticiënga Bëngbe Bëtsabe Uaquiñá Jesucristbiama. ");
INSERT INTO kbh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nts̈amo bayté entsemna, chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías chabe librë́s̈añe yojëftsayancá, nts̈amo Bëngbe Bëtsá chabe Uaquiñábioye ibojauyanama cha tojanábema ora: Minÿe, ats̈be abuayiynayá acbe natsana sëntsichamná, chë aca jabama lempe echanjaprónta cha. ");
INSERT INTO kbh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ents̈anga ndoyena luaroca cha enduáyebuache mënts̈á: “Bëngbe Utabná echanjabo ca; mo nda canÿe benache tojtseprontacá canÿe uámana ents̈á jashjanguama, cachcá ts̈ëngaftanga, cha jabama ainaniñe ts̈abe juabnë́ngaca s̈mochtseprontana ca” —cha tojanábema. ");
INSERT INTO kbh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chcase, Bëngbe Bëtsá Juan tbojanichmó, y cha tojánbocna ents̈anga ndoyena luaroca, Bëngbe Bëtsabe soyëngama abuayiynaye y ents̈anga ubáyana. Cha ents̈anga yojanëtsëtsnaye: “Ts̈ëngaftangbe bacna soyëngama ngménaca s̈mochtenójuaboye, chca amana s̈ochtsajbaná, y Bëngbe Bëtsabe benache s̈mochtishache. Chora cbochjúbaye, y Bëngbe Bëtsá ts̈ëngaftangbe bacna soyëngama cmochanjáperdonaye ca.” ");
INSERT INTO kbh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nÿets Judea luarocana chábioye ents̈anga imojánbocana, y Jerusalenents̈ana nÿetsca ents̈ángnaca, y Bëngbe Bëtsábioye chëngbe bacna soyëngama jaimpáda chents̈ana, Juan Jordán ca uabaina béjayiñe chënga yojanëbáyana. ");
INSERT INTO kbh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanbe ents̈ayá inauapormana camellbe stjënasheca y bobache yojanasnana; chapulinatémënga y tjañe méloye inasaye. ");
INSERT INTO kbh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Y mënts̈á ents̈anga yojanëtsëtsnaye: “Ats̈be ústonoye inÿa echanjabo, ats̈biama más obenana bomná; chíyeca ats̈e merecido taitsatobuajoñe, ni mo jotsejbiyana chabe shecochëtjonëshents̈a corriëja jajafjonama. ");
INSERT INTO kbh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ats̈na búyesheca cbondëubáyana, pero chë echanjabábeyecna, Bëngbe Bëtsá bochanjíchmua chë Uámana Espíritu ts̈ëngaftangbe ainaniñe cháuamashënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chë tempo, Galilea luarocana Nazaret pueblents̈ana Jesús yojë́ftsebocna, y Juan yojtsemnoye tojána; y Jordán béjayiñe Jesúsbioye cha tbojanabaye. ");
INSERT INTO kbh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bejayoicana yojtashë́bëbocna orna, tojáninÿe celoca atëfjniñe, y chë Uámana Espíritu chábioye mo palomatemcá yojtsastjajuana. ");
INSERT INTO kbh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y celocana Bëngbe Bëtsá mënts̈á tbojaniyana: “Acna ats̈be bonshana Uaquiñá condmëna; acbiama corente sëntsoyejuá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chents̈ana chë Uámana Espíritu Jesúsbioye ents̈anga ndoyena luaroye tbojanánatse. ");
INSERT INTO kbh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Canta bnë́tsana te chë ents̈anga ndoyena luaroca tbojanjétana, y Satanasna yojanabó jisháchichiyama. Chë luarents̈e ts̈átjaye bayënga imnajena; chents̈ana, Bëngbe Bëtsabe angelënga cha imojtseservena. ");
INSERT INTO kbh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan cárceloye tmojanëtáments̈ana, Jesús Galileoye tojesaná; y chiñe cha yojanabuayiyná chë ts̈abe noticiënga Bëngbe Bëtsabiama. ");
INSERT INTO kbh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús ents̈anga yojanëtsëtsnaye: “Ora tocjobuache, Bëngbe Bëtsabe amë́ndayana echanjóshjango. Ts̈ëngaftangbe bacna soyëngama ngménaca s̈mochtenójuaboye, y chca amana s̈mochtsajbaná y Bëngbe Bëtsabe benache s̈mochtishache; y ainaniñe chë ts̈abe noticiënga Bëngbe Bëtsabiama s̈mochjóyëngacñe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea uafjajónaye tsachajana Jesús yojtsaye ora, cha tojánanÿe Simón y chabe uabentsá Andrés; chatna atarraiëshangá ibnetsashbuétsets̈añe, er beonga ashebuánayata chata ibnamna. ");
INSERT INTO kbh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chora Jesús tojanë́yana: “Ats̈eftaca mabata. Ats̈e cbochanjábiama Bëngbe Bëtsabiama ents̈anga anguayata; y morscana, nÿe beonga ashebuánayata ndoñe ques̈ochátsmëna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Y cachora chatbe atarraiëshangá cachcá tbojésanaboshjuana y Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Más chcoye yojátaye orna, Jesús tojánanÿe Santiago y chabe uabentsá Juan, Zebedeobe uaquiñata; chatna barquë́shañe ibnetsotbemañe, chatbe atarraiëshangá atapórmayiñe. ");
INSERT INTO kbh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Chora Jesús chë útata tojánachembo; as chatna, chatbe taitá Zebedeo chë barquë́shañe tmojésanboshjona chabe peóngaftaca y Jesúseftaca tbojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chents̈ana, Jesús y chabe uatsjéndayënga Capernaum ca uabaina puebloca tmojánashjajna. Chë ochnayté, Jesús chë judiëngbe enefjuana yebnents̈e tojánamashëngo y yojónts̈a ents̈anga jabuátambama. ");
INSERT INTO kbh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ents̈anga imojtsenjnanaye nts̈amo Jesús yojtsabuatambacá, er chama mo canÿe mando bomnacá yojtsóyebuambnaye, ndoñe nÿe nts̈amo Moisesbe ley abuátambayënga imojanabuatambacá. ");
INSERT INTO kbh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chë pueblents̈e judiëngbe enefjuana yebnents̈e yojtsemna canÿe ents̈á bacna bayëja uambayá, y chábeyeca chë boyabása yojónts̈a mënts̈á uayebuáchana: ");
INSERT INTO kbh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Ndayama bë́ngbioye tëcjabo, Jesús Nazaretocá? ¿Tcojabo bënga jabétsapochocama? Ats̈e sëndë́tats̈ëmbo nda aca comnama, aca chë Bëngbe Bëtsabe Uamaná ca. ");
INSERT INTO kbh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Chora Jesús chë bayë́jbioye tbojtsanácacana, y tbojaniyana: —¡Iytëca móbema y chábents̈ana maisebocna ca! ");
INSERT INTO kbh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chora chë bacna bayëjna tojanma chë boyabása ataque chaboshachama, jabuache tojanoyó y chábents̈ana tojésanbocna. ");
INSERT INTO kbh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chama, nÿetsca ents̈anga ojnanánënga imojtsemna, y mënts̈á imojtsentjanaye: “¿Ndayá chca yojtsemna? ¿Canÿe tsëm buatëmbana soye? ¡Quem boyabása mando bomnacá y obenacá entsabuatambá, y chca, chë bayëjënga cha jtsamë́ndayana y chë́ngnaca joyeunayana ca!” ");
INSERT INTO kbh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y betsco nÿets Galilea luarents̈a pueblënguenache Jesusbiama yojtsótats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chents̈ana, chë enefjuana yebnents̈ana tmojánbocana y Santiago y Juánoftaca Jesús tojána, Simón y Andresbe yebnoye. ");
INSERT INTO kbh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonbe uambén mamá s̈ocá inajájona, jabuache calentóraca, y Jesúsbioye chë s̈ocabiama tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","As chora, Jesús tojanobeconá, chë s̈ocábioye tbojanábuacueshache y tbojanatsbaná. Cachora chë calentora tbojtsanóbojuanañe; y cachora cha tojtantsbaná y tojanonts̈é chënga jobuácuedana. ");
INSERT INTO kbh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chë te jetiñe, shinÿe ya yojuenatjëmba ora, chë luarents̈a nÿetsca s̈oquënga y bacna bayëjënga uambayënga Jesúsbioye tmojanënatse; ");
INSERT INTO kbh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","y nÿetsca ents̈anga bës̈oye imojobeconá. ");
INSERT INTO kbh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús banga tojanashná, nÿetsca s̈ocana bomnënga, y ba bacna bayëjënga ents̈anguents̈ana tojtanëbuacna; y ndoñe tonjanalesenciá chë bayëjënga chamóyebuambama, er chënga imnatáts̈ëmbo cha chë Cristo bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yëfsana cabá cachëse, cabá ibetcá, Jesús tojëftsantsbaná, chë pueblents̈ana tojë́ftsanbocna y ents̈anga ndoyena luaroye tojtsanoñe, choca Bëngbe Bëtsáftaca jencuéntama. ");
INSERT INTO kbh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pero Simón y chabe enutëngna tmojána jetsenguanguama; ");
INSERT INTO kbh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","y tmojtsaninÿena ora tmojaniyana: —Nÿetscanga cmontsenguá ca. ");
INSERT INTO kbh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y Jesús tojanë́yana: —Inÿoye cuajna, cam béconana pueblëngoye, chíñnaca Bëngbe Bëtsabe soyëngama ents̈anga chayábuayenama; er chama ats̈e sënjabo ca. ");
INSERT INTO kbh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y chents̈ana, Jesús yojánana Bëngbe Bëtsabiama ents̈anga abuayiynaye chë judiëngbe enefjuana yebnënguenache, nÿets Galileiñe, y ents̈ángbents̈ana bacna bayëjënga yojtëbuacana. ");
INSERT INTO kbh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Chents̈ana, canÿe boyabása bacna nguayanánaca s̈ocá Jesúsbioye tojanobeconá; y joshaménts̈ase mënts̈á tbojanimpadá: —Aca tcojtsebos̈ëse, aca catjobenaye ats̈be s̈ocana jtsebojuánama ca. ");
INSERT INTO kbh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús chabiama tbojanongmé; cucuáts̈eca tbojánbojajo y tbojaniyana: —Aíñe së́ntsebos̈e. ¡S̈ocana cbotsebojuaná ca! ");
INSERT INTO kbh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y cachora chë s̈ocana tbojtsanóbojuanañe y ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chora Jesús chábioye tbojtanichmó, pero puerte mënts̈á tbojanmandá: ");
INSERT INTO kbh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Mouena; ndocnábeñe quem soye cattsecuéntaye; nÿe Jerusalenoca báchnëbioye motsa y cha cochjinÿinÿiye aca mora ya ts̈abá cojtsatsmënama. Chora cochjuáts̈ëmbona nts̈amo Moisés chabe leyiñe tojanmandacá, Bëngbe Bëtsábioye chama jëtschuayama, chca, nÿetsca ents̈anga chamotats̈ëmbona mora ya ts̈abá cojtsatsmënama ca. ");
INSERT INTO kbh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero chë boyabásana, chents̈ana tojë́ftsanbocna y cachora yojónts̈a nÿetsquénache ents̈anga yapa acúntayana Jesús tbojanshnama. Chë causa, Jesús ndoñe yontsobena ents̈angbe delante pueblënguenache jtsanana, ndayá nÿe chë pueblënga béconana y nÿetsca chë ents̈anga ndoyena luarënguiñe yojánana; pero nÿets luarëngocana chábioye ents̈anga imojánashjajuana. ");
INSERT INTO kbh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chents̈ana, Jesús Capernaumoye tojtanashjango; y ents̈anga imojátats̈ëmbona, Jesús yebnents̈e yojtsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mallajta ents̈anga chents̈e tmojanójoto; chë causa chë yebnents̈e ya tondaye más luare ents̈angbiama yontsemna, ni mo chë amashjuanents̈e, y Jesús Bëngbe Bëtsabe soyëngama yojtsabuayiynaye. ");
INSERT INTO kbh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chora tojanopasá, canta boyabásenga tmojánashjango, canÿe ents̈á jama ndobená imojtsaismana. ");
INSERT INTO kbh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ndoñe tmonjanobená Jesús yojtsemnoye cha juambana, ts̈a ents̈anga causa. Chcasna, chë canta boyabásenga yebna tsbanánoca, Jesusbe tatsëtsoca bats̈á tmojánatëfjo y chëjana chë jama ndobená tjuashiñe tmojanë́stjango. ");
INSERT INTO kbh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús tojáninÿe chënga ts̈a imojtsos̈buaché chë s̈ocá jáshnama cha yojanobenama; as chë jama ndobenábioye tbojaniyana: “Sobreno, mouena; acbe bacna soyënga tcbontseboperdoná ca.” ");
INSERT INTO kbh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chents̈e báseftanga judiëngbe ley abuátambayënga imnatbemana; chënga chora mënts̈á imojtsejuabnaye: ");
INSERT INTO kbh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nts̈ámoyeca quem boyabása chca yojtsichamo? Jesús ndoñe ts̈abá Bëngbe Bëtsabiama quenátichamo; mo chábioye cuafjoyenguangcá entsemna. Ndocna ents̈á quenátobena ínÿabioye bacna soyëngama japerdónana; nÿe Bëngbe Bëtsana aíñe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesús cachora lempe yojtsetáts̈ëmbo nts̈amo chënga ainanoca imojtsejuabnacá; as tojanë́yana: “¿Ndáyeca chca ts̈ëngaftanga ainaniñe s̈mojtsejuabná? ");
INSERT INTO kbh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ts̈ëngaftangbiama ndayá más paselo nántsemna ts̈ëngaftangbe delante chë jama ndobenábioye ats̈e jauyanana: ‘Acbe bacna soyënga tcbontseboperdoná’, o ‘Matëtsbaná, acbe tjuashe mesocñe y motsa ca’? ");
INSERT INTO kbh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Y chca, mora ats̈e cbochanjínÿanÿiye Bëngbe Bëtsá Ents̈á tbojanbemá quem luariñe obenana yobomnama, ents̈anga bacna soyëngama jáperdonama ca” —Jesús tojánayana. Y chë jama ndobenábioye tbojaniyana: ");
INSERT INTO kbh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ats̈e cbëyana, matëtsbaná, acbe tjuashe mesocñe y acbe yebnoye motsatoñe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cachora chë jama ndobená tojtantsbaná, chabe tjuashe yojesocñe, y ents̈angbiajana chents̈ana yojésebocna. Chama nÿetsca ents̈anga imojenjnaná y Bëngbe Bëtsábioye imojtsatschuanaye, y mënts̈á imojtsichamo: “Nÿa ndocna te ts̈a bëts soye chemuáisinÿe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chents̈ana, Jesús cachiñe chë uafjajónaye tsachoye tojesaná; ba ents̈anga chábioye imojobeconá, y Jesús yojtsabuátambaye. ");
INSERT INTO kbh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chents̈ana yojtsataye orna, Jesús tbojáninÿe Levíbioye, Alfeobe uaquiñá, yojtsanotbemañe, ents̈anga impuesto atjanayacá inétsotrabajañe. Chora Jesús tbojaniyana: “S̈masto ca.” Y Leví tojantsbaná y tbojanasto. ");
INSERT INTO kbh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tojanopasá, Jesús Levibe yebnents̈e yojtsesaye, y banga Romocama ents̈anga impuesto atjanayënga y inÿe bacna ents̈anga, mesë́shents̈e cánÿiñe imojtsetbiámana, Jesús y chabe uatsjéndayëngaftaca; er ba ents̈anga cha imojústona. ");
INSERT INTO kbh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chë fariseunga y chë ley abuátambayënga, chë ents̈ángaftaca Jesús yojtsesama tmojáninÿe ora, chabe uatsjéndayëngbioye tmojanatjá: —¿Ndáyeca ts̈ëngaftangbe buatëmbayá, ents̈anga impuesto atjanayë́ngaftaca y bacna soye amë́ngaftaca yojtsesá ca? ");
INSERT INTO kbh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús chca tojanuena; as mënts̈á tojanë́jua: —Chë salud tmotsobomñënga, ashnayá ndoñe ntsëjabótana, pero chë s̈oquëngna aíñe. Y ats̈e ndoñe chiyátabo chë Bëngbe Bëtsabe bominÿiñe ts̈abá amënga jabáchembuama, ndayá chë bacna soye amënga imomna ca juabnayënga áts̈bioye jabáchembuama ca. ");
INSERT INTO kbh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Canÿe, Juan chë Ubayanabe ústonënga y chë fariseungbe usetonënga, Bëngbe Bëtsáftaca jencuéntama tondaye ntjascá imojtsemna ora, básefta ents̈anga Jesúsbioye tmojanobeconá y mënts̈á tmojaniyana: —Juanbe ústonënga y chë fariseungbe usetonënga monduamana tondaye ntjascá jtsemnana Bëngbe Bëtsáftaca jencuéntama. ¿Ndáyeca acbe uatsjéndayënga ndoñe chca ca? ");
INSERT INTO kbh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","As Jesús tojanë́jua: —Chë casamento fiestents̈e, chë ófjanënga saná ndoñe ntsabuáshebenana. ¿Nts̈amo chca ndoñe nántsemna? Chë tojobouamá ents̈á chë́ngaftaca tojtsemnëntscuana, chë ófjanënga bëtscá jasana y cháftaca oyejuayënga jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ora echanjobuache y chë boyabása chë́ngbents̈ana mochantsánatseñe; chora cocayé chë ófjanënga echántsamna tondaye ntjascá jtsemnana. Nts̈amo chë tojobouamá boyabása y chë ofjanë́ngaftaca endmëncá, cachcá endmëna ats̈e y ats̈be uatsjendayë́ngaftacnaca. ");
INSERT INTO kbh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ndocná, canÿe tanguá ents̈ayá, base tsëm ents̈ë́juaca jtarméndana; chca tcojamëse, chë tsëm ents̈ë́jua jtsabéconana y chë tanguá ents̈ayá más jtsatanë́canana, y chca, chë uátanëcniñe más bëtsiñe jtsabemana. ");
INSERT INTO kbh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y cach ndoñe, chë tojtseshayana vínoye tanguá jasabenguiñe ntjataftsuámayana; er chë jasabenga jtseshébëfjuana y chë vínoye jtsabuáshanana, y chë vínoye y chë jasabenga tondayama ntjatoservénana. Chíyeca comna, chë tojtseshayana vínoyna tsëm jasabenguiñe juaftsuámana; chca, chë jasabenga y chë vínoye josérviana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Canÿe ochnayté, Jesús canÿe jajajana yojtsaye; y chabe uatsjéndayënga chëjana imojtsachnëjuana ora, tmojanonts̈é trigo juatabebiana. ");
INSERT INTO kbh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chë fariseunga chca imojinÿe ora, Jesúsbioye tmojaniyana: —Minÿe. ¿Nts̈amo acbe uatsjéndayënga montsamcá, ndoñe quenátslesenciana ochnayté jtsamama ca? ");
INSERT INTO kbh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero cha tojanë́jua: —¿Ndoñe s̈mëndualía y s̈mondë́tats̈ëmbo nts̈amo Rey David y chabe enutënga tmojanmama shë́ntseca imojtsemna ora y jasama yojtsëjaboto ora? ");
INSERT INTO kbh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Chca ora, Abiatar chë judiëngbe bachnangbe más uámana amëndayá inamna ora, David Bëngbe Bëtsabe yebnoye yojámashëngo, y chë luarents̈e Bëngbe Bëtsá yojamnama inÿinÿnaye tandës̈ënga yojase; y chë cháftaca imojánajna ents̈ángnaca yojáts̈ataye. Y chë tandës̈na nÿe bachnangbiama belesenciana jasama. Masque David chca tojanma, Bëngbe Bëtsá ndoñe tonjánayana David canÿe bacna soye tojanma ca. ");
INSERT INTO kbh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y Jesús más tojánayana: —Bëngbe Bëtsá ochnayté ents̈abiama tojama y ents̈á ndoñe tbonjánbema nÿe chë ochnayté ndoñe chaondëtrabajama. ");
INSERT INTO kbh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chíyeca, Bëngbe Bëtsá Ents̈á tbojanbemá, ndayá ents̈á ochnayté tojtsama sóynaca jtsemándayana ca. ");
INSERT INTO kbh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chents̈ana, Jesús cachiñe chë judiëngbe enefjuana yebnoye tojésanamashëngo; y chents̈e canÿe boyabása yojtsemna, buashana cucuats̈e bomná. ");
INSERT INTO kbh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chë fariseunga chiñe imojtserrondana jinÿama nderado Jesús chë ochnayté chábioye tabuanjashnama, as chca chënga jtsebomnama ndaye sóyeca cha mal jaquédana. ");
INSERT INTO kbh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Chora Jesús chë buashana cucuats̈e bomnábioye tbojaniyana: —Chents̈e, ents̈angbe delante motsa ca. ");
INSERT INTO kbh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y chë fariseunga tojanatjá: —¿Ndayá yojtselesenciana ochnayté jamama, ts̈abe soye o ndoñe ts̈abe soye? ¿Jatsbocama o jtsepochócama ca? Pero chënga ndocá tmonjanjuá, nÿe iytëca imojobiama. ");
INSERT INTO kbh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chora Jesús rábiaca y ngménaca chë fariseunga tojanënÿanÿé, chënga ainaniñe josértama ndoñe montsebos̈e causa; y chë buashana cucuats̈e bomnábioye tbojaniyana: —Macuenÿanëjaná ca. As chë boyabása tojanacuenÿanëjaná, y chora ts̈abá chëts̈a yojtsatamna cach inÿets̈acá. ");
INSERT INTO kbh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pero chë fariseungna, chents̈ana tmojésanbocana ora, Rey Heródesbe ustonë́ngaftaca tmojanenoyeuná Jesusbe contra, y tmojanonts̈é juabnayana nts̈amo jamëse Jesús jóbama. ");
INSERT INTO kbh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Chents̈ana, Jesús chabe uatsjéndayëngaftaca tojanoluaré mar béjaye tsachoye, y Galileocana bëtscá ents̈anga tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Inÿe ents̈ángnaca chábioye tmojanobeconá Judeocana, Jerusalenocana, Idumea ca uabaina luarocana, Jordán béjaye chenguanoicana, Tiro y Sidón pueblëngocana. Chënga tmojanobeconá, Jesús ts̈a bëts soyënga yojtsamama tmojanuena ora. ");
INSERT INTO kbh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús chabe uatsjéndayënga tojanë́yana: “Motsajna y canÿe barquë́sha ats̈biama s̈mochjuaprónta, ts̈a ents̈anga ndoñe chas̈mondë́tsatsënts̈nama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Er cha banga tojanashná, y chë causa, nÿetscanga s̈ocana bomnënga chábioye tmojanojuatsënts̈ená cha jabojajuama. ");
INSERT INTO kbh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y chë bacna bayëjënga uambayëngna, Jesús tmojinÿe ora, betsco chabe shecuats̈ents̈e imojtsofshëntsaménts̈enaye, y chë bacna bayëjë́ngbeyeca mënts̈á imojtsáyebuache: “¡Aca Bëngbe Bëtsabe Uaquiñá condmëna ca!” ");
INSERT INTO kbh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús puerte tojanamëndá, nda cha bétsemnama ents̈angbe delante ndoñe chamondëtsichámuama. ");
INSERT INTO kbh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chents̈ana, Jesús canÿe batsjoye tojántsjua, y ndëmuanÿenga ts̈abá tbojanínÿnanënga tojánachembo. Y chëngna chábioye tmojanobeconá. ");
INSERT INTO kbh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chora, chënguents̈ana bnë́tsana útata tojanëbuáyana, chamotsetjëmbambnama, y Bëngbe Bëtsabe soyëngama ents̈anga chámabuayenama; ");
INSERT INTO kbh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","y chënga obenana tojanats̈atá ents̈ángbents̈ana bacna bayëjënga jtëbuacanama. ");
INSERT INTO kbh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mënga mondmëna chë bnë́tsana uta bocacánënga: Simón, chë ndábioye Pedro ca Jesús tbojanabaye; ");
INSERT INTO kbh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago y chabe uabentsá Juan, Zebedeobe uaquiñata, chata tojanëbaye “boanerges ca”, y chca endayana “uajuesayabe uaquiñata ca”; ");
INSERT INTO kbh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago, Alfeobe uaquiñá; Tadeo, Simón chë celote ca uabobainá; ");
INSERT INTO kbh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judas Iscariote, chë chents̈ana ndoñe baytesna, Jesús uayayëngbe cucuats̈iñe bochjanboshjoná. ");
INSERT INTO kbh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chents̈ana, Jesús yebnoye tojtanamáshëngo, y ts̈a ents̈anga chents̈e tmojanójoto; chë causa, ni cha ni chabe uatsjéndayënga, ni mo jasama luare ndoñe imontsebomna. ");
INSERT INTO kbh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesusbe pamíllanga nts̈amo cha yojtsepásama tmojántats̈ëmbona ora, tmojána cha jetsbets̈ama, er ents̈anga imojtsencuéntaye cha opá tojtsanóbema ca. ");
INSERT INTO kbh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y chë ley abuátambayënga Jerusalenocana tmojánashjajnëngna Jesusbiama mënts̈á imojtsichamo: “Chabe ndegombre mandayá Beelzebú, cach Satanás yojtsemna. Cha, chë bacna bayëjënga amëndayá, Jesúsbioye obenana tbojats̈etá ents̈ángbents̈ana bacna bayëjënga chauatëbuacnama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chënga chca imojtsichámuama, Jesús chënga tojánachembo, y cuentë́ngaca tojanonts̈é jáuyanana, jinÿanÿiyama chënga canÿe ndoñe ndegombre soyiñe imojtsemnama, mënts̈á: “¿Nts̈amo Satanás nantsobena cachá jtenábocnama ca? ");
INSERT INTO kbh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Canÿe amëndayábents̈e ents̈anga tmojtsenojatá y tmojtsenáyase, chë amë́ndayana ndoñe ntjatotonana. ");
INSERT INTO kbh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Cachcá, canÿe yebnents̈e pamíllanga tmojtsenojatá y tmojtsenáyase, chë pamíllanga ndoñe ts̈abá nÿets tempo quemochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y cachcá, Satanás y chábenga ndoñe tmontsenëyeunana y cachabe contra tojtsemnëse, chabe amë́ndayana ndoñe más queochátstotona; y cha ya ndoñe más chëngbe amëndayá queochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ndocná quenátobena canÿe corente añemo bomna ents̈abe yebnoye jamashënguana y chabe soyënga jtsebocana, ndoñe natsana tconjshétsebatsëquëse. Nÿe tcojshétsebatsëquëse cocayé cuanjobenaye cha jefcana. ");
INSERT INTO kbh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ndegombre cbë́yana, Bëngbe Bëtsá ents̈angbe nÿetsca bacna soyënga echanjáperdonaye, y nts̈amo Bëngbe Bëtsabiama y ínÿengbiama ndoñe ts̈abá tmontsichamo soyë́ngnaca; ");
INSERT INTO kbh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero chë Uámana Espíritbiama ndoñe ts̈abá ichámëngna ndocna te queochátaperdonaye, er nÿetsca tescama castigánënga jtsemnama chënga jtsamnana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús chca tojanë́yana, er chënga imojtsichamo cha bacna bayëja ibojtsambá ca. ");
INSERT INTO kbh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chëntscuana, Jesusbe mamá y cats̈átanga choye tmojánashjajna, pero nÿe shjoca imojtsemna; y canÿa tmojanichmó cha jachembuama. ");
INSERT INTO kbh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chë ba ents̈anga chents̈e chabe shë́conana imojtsetbiámanëngna, chora tmojaniyana: —Acbe mamá, acbe cats̈átanga y uabénanga shjoca montsemna; aca cmontsenguá ca. ");
INSERT INTO kbh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Chora cha tojanë́jua: —¿Nda ats̈be mamá yomna, y ndëmuanÿenga ats̈be cats̈átanga ca? ");
INSERT INTO kbh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chents̈ana, chë chabe shëconanana tbiamanë́ngbioye jarrepárase, tojánayana: —Quemënga mondmëna ats̈be mamá y ats̈be cats̈átanga. ");
INSERT INTO kbh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Er ndánaca, nts̈amo Bëngbe Bëtsá yobos̈cá tojtsamá, jtsemnana ats̈be cats̈ata, ats̈be uabena y ats̈be mamá, ats̈be ndegombre pamillanguents̈á ca. ");
INSERT INTO kbh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chents̈ana, uafjajónaye tsachoca Jesús tojtëtanonts̈é Bëngbe Bëtsabe soyëngama jabuátambama. Mallajta ents̈anga tmojanobeconá causa, chë uafjajónayents̈e yojanamna canÿe barquë́shoye Jesús tojánas̈ëngo y tojanótbema; y chë ents̈anga tsachoca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chora cuentë́ngaca ba soyëngama tojanabuatambá. Mënts̈á tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“S̈mochjouena; canÿe jená chë jénaye jaujquëshama yojë́ftsebocna. ");
INSERT INTO kbh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yojtsëjquëshaye orna, básefta jénaye benache juachañe yojuatquë́cjana; pero jaja shlofts̈ënga imojástjajna y lempe imojtsósañe. ");
INSERT INTO kbh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Inÿe meshëngna ndëts̈benguiñe yojuatquë́cjana, ndoñe yapa fshantse binÿnents̈e. Chiñna betsco yojuábocna, ndoñe yapa jashenocana fshantse yojanmëna causa; ");
INSERT INTO kbh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","pero yojuábocna orna, puerte yojojënÿána y yojtsancta; y yojtsábojo yapa tbëtëjënga tondaye causa. ");
INSERT INTO kbh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Inÿe meshëngna uchmë́shangañe yojuatquë́cjana; chë uchmashá yojuájua ora, lempe yojtsatscué, y chca, chë jénayents̈ana tondaye yonjuashájona. ");
INSERT INTO kbh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero inÿe meshëngna, uanguaniñe yojuatquë́cjana, y bëtscá ts̈abe shajuanënga chiñe yojóbocna: ínÿenache, canÿe meshents̈ana unga bnë́tsana meshënga yojóbocna; ínÿenachna, chnë́nguana bnë́tsana meshënga; y ínÿenachna patse meshënga ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Y chents̈ana, Jesús más tojánayana: “Chë jouenama tmojtsobenënga, s̈mochjouena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chents̈ana, Jesús canÿa yojoquéda ora, chë chabe béconana imojtsemnënga chabe bnë́tsana uta uatsjéndayëngaftaca, tmojantjá ndayá chë cuento bétsayanama. ");
INSERT INTO kbh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","As Jesús tojanë́jua: “Bëngbe Bëtsá ts̈ëngaftanga cmontsinÿanÿná nÿetsca chë mo iytëmencá yomna soyënga chabe amë́ndayama, pero chë ínÿengbioye ndoñe; chë soyëngama chënga lempe cuentë́ngaca sëntsëtsëtsná. ");
INSERT INTO kbh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chca, masque becá chamotsafs̈na, ndoñe chamondobená chë Bëngbe Bëtsabe soyënga jinÿama; y masque becá chë soyënga chamouena, ndoñe queochátësertana, chënga Bëngbe Bëtsábioye ndoñe chamondëtobéconama, y cha ndoñe chaondáperdonama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chents̈ana, Jesús tojanë́yana: “¿Quem cuentama ndoñe tcmonjósertase, nts̈amo chcase nÿetsca cuentëngama cmochjóserta ca? ");
INSERT INTO kbh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Chë jená endmëna chë ts̈abe noticiëngama abuayiynayá. ");
INSERT INTO kbh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Básefta ents̈anga mondmëna mo chë benache juachañe yojuatquë́cjana jenaycá. Chëngna Bëngbe Bëtsabiama soyënga jouenana; pero chora Satanás betsco jabana, chëngbe ainaniñe yojtsemna Bëngbe Bëtsabe palabra jabétsabuajuanama, chënga chiñe ndoñe chamondëtsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inÿe ents̈anga mondmëna mo chë ndëts̈benguiñe yojuatquë́cjana jenaycá; chëngna Bëngbe Bëtsabe palabra jouenana y oyejuayënga jtsemnana; ");
INSERT INTO kbh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","pero ndoñe nÿets tempo chana jocochájuana; y chca, ndoñe bayté Bëngbe Bëtsáftaca ntjëftsemnëngana, ndoñe yapa tmontsas̈buaché causa. Inÿenga mochantsë́buayënja, y Bëngbe Bëtsábeñe betsos̈buáchiyama mochanjasúfrianga; chíyeca chënga Bëngbe Bëtsabe palabra cachcá mochanjesonÿaye. ");
INSERT INTO kbh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Inÿenga mondmëna mo chë uchmë́shangañe yojuatquë́cjana jenaycá. Chënga Bëngbe Bëtsabe palabra mochanjouena, ");
INSERT INTO kbh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero quem luarents̈a soyë́ngaca oyejuayënga jtsemnama yapa mochántsebos̈e, y nÿe bomnana jëftsebomnama yapa mochanjésenojuabnaye. Chë soyama y inÿe ba soyëngama yapa enócochinÿena causa, Bëngbe Bëtsabe soyëngama echantsebnë́tjomba, y ndoñe quemochátama nts̈amo Bëngbe Bëtsá tojayancá. ");
INSERT INTO kbh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ínÿenga mondmëna mo chë uanguaniñe yojuatquë́cjana jenaycá. Chëngna Bëngbe Bëtsabe palabra botamana mochanjouena; nÿets ainánaca mochántseprontana chiñe jtsos̈buáchiyama. Mo canÿe betiye becá ts̈abá tojtseshajuancá, chënga bëtscá ts̈abe soyënga Bëngbe Bëtsabiama mochántsama. Inÿenga ínÿengbiama más bëtscá soyënga mochanjama; y chca, ínÿenga mochántsemna mo chë unga bnë́tsana meshe tojanshajo jenaycá, ínÿenga mo chë chnë́nguana bnëtsancá, y ínÿengna mo chë patse meshënga tojanboté jenaycá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mënts̈ánaca Jesús tojánayana: “Ndocná juiyëbana canÿe uajuinÿanë́sha cajonëshe o jutsnë́sha tajsoye juajájuama. Ndoñe; uajuinÿanë́sha juiyëbana tsbanánoca juajájuama, lempe chaotsebínÿnama. ");
INSERT INTO kbh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ndocna yoiytë́mena soye ntjinÿencá queochaisoquéda, y chë ndótats̈ëmbo soye ntsotats̈ëmbcá queochaisoquéda. ");
INSERT INTO kbh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chë jouenama tmojtsobenënga, s̈mochjouena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y mënts̈ánaca Jesús tojanë́yana: “Ts̈abá s̈mochjájuaboye nts̈amo s̈mojtsuenanama. Nÿe bats̈atema s̈mojouenëse, nÿe bats̈atema cmochanjósertaye; pero aíñe ts̈abá s̈mojouenëse, chama corente cmochanjósertaye; y Bëngbe Bëtsá echanjama ts̈ëngaftanga más soyëngama chacmósertama. ");
INSERT INTO kbh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Er nda Bëngbe Bëtsabe soyëngama ts̈abá tbojosertá, Bëngbe Bëtsá echanjama cha más ba soyëngama chabosertama; pero nda chë soyëngama josértama ndoñe tontsebos̈á, chë nÿe bats̈á ibosertana soyëngama bochántsebnatjëmba ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús mënts̈ánaca tojanë́yana: “Bëngbe Bëtsabe amë́ndayana endmëna mo nts̈amo canÿe boyabása jénaye tojuatbontsá ora echandbopasacá: ");
INSERT INTO kbh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","masque cha cada ibeta jtsojájuana y bnëté jotsbanama, ibeta o bnëté, chë jénayents̈ana juabocnana y juájuana, nts̈amo chca yojtsájuajnama chë boyabása ntjatstats̈ëmbcá. ");
INSERT INTO kbh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chë fshantse cachabe ponto jamana ndayánaca chiñe chaójuama; natsana tsbuanachëtema jóbocnana, chents̈ana chë espiga, y chents̈ana chë meshënga jashájonana. ");
INSERT INTO kbh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y chë meshënga ya tojtsebóchichna orna, játbanama jabocnana, chë saná josháchiñama ora ya tojobuácheyeca ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús mënts̈ánaca tojanë́yana: “¿Ndayacá Bëngbe Bëtsabe amë́ndayana yomna, o ndaye sóyeca nanjopódia chama jábuayenama? ");
INSERT INTO kbh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Endmëna mo canÿe mostaza jénaye jajoca tcojajecá. Ndegombre, nÿetsca quem luarents̈a jenayëngama, mostaza jénaye chë más básetema endmëna; ");
INSERT INTO kbh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero tcojajé orna, jójuana, y jajañe chë más bëts betiye jóbemana, ba bëts buacuashë́ngaca; chíyeca chë jaja shlofts̈ënga jana y chiñe uajajonëtemëngá jauábopormana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chca Jesús Bëngbe Bëtsabe soyëngama ents̈anga yojanabuatambá, ba cuentënguents̈ana, mo chë tmonjouena cuentcá, ntsachets̈á chë ents̈anga josértama tmojobenacá. ");
INSERT INTO kbh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tondaye yonjanabuatambá ndoñe cuentë́ngaca ntsemëncá; pero chabe uatsjéndayëngna lempe yojanabuayiyná, cánÿenga tmojtsemna ora. ");
INSERT INTO kbh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Cach te, yojtseibétatana ora, Jesús chabe uatsjéndayënga tojanë́yana: “Uafjajónaye chenguana cuajna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chorna, chë ents̈anga jesabáshejuanëse, chë uatsjéndayënga Jesús tmojtsanánatseñe, cach yojánenjaquena barquë́shañe; y inÿe ents̈ángnaca inÿe barquë́shangañe tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Chents̈ana, chë uafjajónaye béjayiñe ts̈a jabuache binÿia yojóshjango; olëshënga chë barquë́sha imojtsë́tsbotsana, y chë causa chë barquë́sha yojónts̈a búyesheca jtsobuajútjiana. ");
INSERT INTO kbh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Y chëntscuana, barquë́sha stëts̈oica, tsënts̈enë́shañe Jesús yojtsomañe. Chora chë uatsjéndayënga tmojtsanfs̈ená y tmojaniyana: —¡Buatëmbayá! ¿Tondayana cmontsents̈amna bënga chas̈otsënatjëmbama ca? ");
INSERT INTO kbh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","As Jesús tojantsbaná, chë binÿia tbojanácacana, y chë bëts uafjajónayoye tojánayana: —¡Natjë́mbana cochtsemna! ¡Bonguana ca! Y cachora chë binÿia yojëtstëcja, y lempe bonguana yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chora chabe uatsjéndayënga tojanë́yana: —¿Ndáyeca ts̈a s̈mojtsauatja? ¿Bëngbe Bëtsá ts̈ëngaftanga jujabuáchama yobenama cabá ndoñe s̈montsos̈buaché ca? ");
INSERT INTO kbh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Chama, chënga puerte auatjanánënga imojtsemna y mënts̈á imojtsenatsëtsnaye: “¿Nda quem boyabása yomna? Cha tonjayana y chë binÿia y chë béjaye tmonjoyeuná ca.” ");
INSERT INTO kbh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chents̈ana, uafjajónaye chenguánoica tmojánashjajna, Geraseno ca uabaina ents̈angbe luaroye. ");
INSERT INTO kbh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús barquë́shoicana tojánastjango, y cachora, chë obanëngbe cuevëshënguents̈ana canÿe ents̈á, bacna bayëjbe juabna uambayá, tojánbocna y tbojanjébengo. ");
INSERT INTO kbh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chë boyabásana, obanëngbe cuevëshënguenache inoyena, y ndocná yonjobena cha jtsebátsëcana, ni mo cadenë́juangaca; ");
INSERT INTO kbh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","er ba soye cadenë́juangaca y inÿe soyë́ngaca cha nÿetsá tmojanbatsëca, pero cha nÿetsca soye yojtsátabebe y yojtsenájaca, y ndocná yonjobenaye cha bonguana chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nÿets tempo, bnëté y ibeta, obanëngbe cuevëshënguenache y tjañenache yojánana yoye, y ndëts̈béngaca enotsets̈enaye. ");
INSERT INTO kbh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesúsbioye bënocana tbojáninÿe ora, chábioye tojanótjajo y chabe natsanoica yojoshëntsaments̈iye; ");
INSERT INTO kbh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","y mënts̈á yojtsáyebuache: —¿Ndayá áts̈eftaca cojtsebos̈e, Jesús, celoca Bëngbe Bëtsabe Uaquiñá? ¡Bëngbe Bëtsabe delante cboimpadá, ndoñe s̈catjatsets̈ená ca! ");
INSERT INTO kbh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chca tbojaniyana, er Jesús chábioye tbojaniyana: —¡Bacna bayëjbe juabna, chábents̈ana maisebocna ca! ");
INSERT INTO kbh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chents̈ana Jesús tbojantjá: —¿Nts̈amo cabaina ca? Y chë bacna bayëjëngbe juábnaca cha tbojanjuá: —Ats̈na Legión ca sënduabaina, bëtscanga fsëndmëna causa ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y ts̈a Jesús ibojtserruana chë luarents̈ana ndoñe chaondëtëbuacanama. ");
INSERT INTO kbh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chents̈a béconana ba cots̈ënga imnajena, batsjoca imnétsosañe; ");
INSERT INTO kbh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","as chë bacna bayëjënga Jesúsbioye tmojanimpadá: —Chë cots̈ë́ngbioye s̈michamó, chë́ngbeñe fchayamashjna ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Y Jesús aíñe tojanalesenciá; as chë bacna bayëjënga chë ents̈ábents̈ana tmojésanbocana y chë cots̈ë́ngbeñe tmojánamashjna. Cachora chë mo uta uaranga cots̈ënga batsjocana peñës̈ëjana uafjajónayoye imojtsoshbuets̈e y yojtsatajo. ");
INSERT INTO kbh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chora, chë cots̈ënga anÿenënga tmojtsanacheta auatjanánënga, y tmojána chama jacuéntama chë puebloca y chabuenache; y ents̈anga tmojánabo nts̈amo tojanopasacá jinÿama. ");
INSERT INTO kbh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús yojtsemnoye chë ents̈anga tmojánashjajna ora, tmojáninÿe chë tempo bacna bayëjënga uambayá, inétsotbemañe, ents̈ayá uichëtjoná y chabe nÿets juábnaca. Y chë ents̈anga chama imojtsëuatjaná. ");
INSERT INTO kbh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chë tmojáninÿënga imojtsecuéntaye, nts̈amo chë bayëjbe juabna uambayáftaca tojanopasama, y chë cots̈ë́ngaftaca nts̈amo tojanopasámnaca. ");
INSERT INTO kbh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chora chë ents̈anga tmojanonts̈é Jesús impadánana chë luarents̈ana chaotsatoñama. ");
INSERT INTO kbh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús chë barquë́shoye tojtanás̈ëngo ora, chë tempo bacna bayëjbe juabna uambayá tbojanimpadá chabolesenciá cháftaca jama ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ndoñe tbonjanlesenciá, sinó mënts̈á tbojaniyana: “Acbe yebnoye motsatoñe, acbe pamíllangbioye, y cochjácuntaye ndayá Bëngbe Utabná ácaftaca tojamama, y nts̈amo cha ácbioye tcmojalastemama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chents̈ana, chë ents̈á yojtsatoñe y tojanonts̈é Decápolis uabaina pueblënguenache jacúntana lempe nts̈amo Jesús cháftaca tojanmcá; y nÿetscanga imojtsenjnanaye. ");
INSERT INTO kbh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Chents̈ana, Jesús cachiñe chë uafjajónaye chenguana tojesaná barquë́shañe. Chocna ba ents̈anga tmojanobuashconá, y Jesús chë uafjajónaye tsachañe yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chorna, tojánashjango chë judiëngbe enefjuana yebnents̈a canÿe mandayá, Jairo ca uabainá. Jesúsbioye tbojáninÿe ora, chábents̈e tojanoshëntsaments̈é, ");
INSERT INTO kbh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","y ts̈a ibojtseimpadana, mënts̈á: —Ats̈be bembetema ya echantsóbana; Diosmanda mabo, acbe cucuats̈ënga chábeñe cochjajájua, salud chauatinÿenama y cháuatayenama ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","As Jesús cháftaca tojána; pero bëtscá ents̈anga imojtsë́stona, chábioye imojtsenatsë́nts̈enaye. ");
INSERT INTO kbh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chë ents̈anguents̈e yojtsaye canÿe shembása s̈ocá; cha ya bnë́tsana uta uata oboftjajuanánaca inapadecena. ");
INSERT INTO kbh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cha puerte tojansufrí, ba ashnayëngbe cucuats̈iñe, y lempe ntsachets̈á inabomncá tojanpochocá jenóshnama; pero ndoñe ibontsatstë́cacjana, nÿe más peor ibojtsobiamnaye. ");
INSERT INTO kbh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chë shembása yojouena nts̈amo Jesús ba s̈oquënga tojánashnama, y as stëts̈oicana ents̈angbe tsëntsajana yojobeconá, y Jesusbe ents̈ayá yojauábojajo. ");
INSERT INTO kbh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Cha chca tojanma, er yojtsejuabnaye: “Masque nÿe mo chabe ents̈ayá sibiájua chaijuábojajo, y salud chantsatsbomna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y cachora chë oboftjajuanana ibojtsobojuána; y chabe cuerpiñe ibojebiónana ya ts̈abá yojtsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chora Jesús yojaséntia chábents̈ana obenana yojóbocnama, mo ndábioye tbojashná orcá; as cha tojanobuértana ents̈ángbeñe y tojanatjá: —¿Nda ats̈be ents̈ayá tojuabojajo ca? ");
INSERT INTO kbh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Chabe uatsjéndayënga tmojanjuá: —Aca contsonÿá chë ents̈anga cmontsatsënts̈ená, y cabá cochjátsnoticiaye nda ents̈ayá tojuabojajo ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús cátoye yojtserreparana jinÿama nda tbojánbojajuama. ");
INSERT INTO kbh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","As chë shembása, chë nts̈amo cháftaca yojopásama jtsetats̈ëmbëse, tojanobeconá ngmëmnayá y auatjananá, chabe natsanoica tojanoshëntsaments̈é, y lempe nts̈amo ndegombre cháftaca tojanopasacá Jesúsbioye tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chora Jesús tbojaniyana: —Bembe, Bëngbe Bëtsábeñe icos̈buachéyeca shnaná contsatsmëna. Natjë́mbana motsatoñe; acbe s̈ocana tontsopochocá ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús cabá yojtsóyebuambnantscuana, báseftanga tmojánashjajna chë judiëngbe enefjuana yebnents̈a mandayabe yebnocana, y chë shembásetembe taitá tmojaniyana: —Acbe bembe tontsóbana; ¿ndayama más Buatëmbayá chama cochjátebëyaboma ca? ");
INSERT INTO kbh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Y Jesús, nts̈amo chënga imojtsichamcá ntjatuenancá chë judiëngbe enefjuana yebnents̈a mandayábioye tbojaniyana: —Ndoñe matauatjana. Nÿe Bëngbe Bëtsábeñe cochtsos̈buáchiye cha ts̈abá chaotsatsmënama ca. ");
INSERT INTO kbh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y Jesús ndoñe tonjanalesenciá Jairëbe yebnoye banga chamuastama; nÿe Pedro, Santiago y Juan, Santiagbe uabentsana, aíñe. ");
INSERT INTO kbh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chents̈ana, chë mandayabe yebnoye tmojánashjajna ora, Jesús tojánanÿe ents̈anga ts̈a imojtsenbouenana, ents̈anga imojtsos̈achiye y puerte ngménaca imojtseyoye. ");
INSERT INTO kbh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","As chë yebnoye tojánamashëngo y chë ents̈anga tojanë́yana: “¿Ndayama ts̈a s̈mojtsenbouenana y ts̈a s̈mojtsendëntjana? Chë shembásetema ndoñe chenatóbana, nÿe endëtsomañe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero ents̈anga nÿe imojtsáfchaye. As Jesús nÿetsca ents̈anga shjoye tojtanëbuacna, y tojë́ftsanëbiats̈e chë basetembe bëtsë́tsata y chabe enutënga; y chë shembásetema yojtsemnoye tojánamashëngo. ");
INSERT INTO kbh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chora Jesús tbojanábuacueshache y cachëngbe biyañe tbojaniyana: “Talita, cum ca.” (Chca endayana “Shembásetema, matëtsbaná ca”.) ");
INSERT INTO kbh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cachora, chë bnë́tsana uta uata bomna shembásetema tojtantsbaná y yojtsobena jama. Y chë ents̈anga chama imojtsenjnanaye. ");
INSERT INTO kbh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Jesús corente tojanamëndá ndocnábeñe chama ntsecuéntayana ca, y tojanamëndá chë básetema saná chamuiyé chaosama. ");
INSERT INTO kbh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chents̈ana Jesús tojë́ftsanbocna y cachabe luaroye tojtanashjango, y chabe uatsjéndayënga cháftaca tmojána. ");
INSERT INTO kbh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ochnayté tojanobuache ora, Jesús tojanonts̈é chë judiëngbe enefjuana yebnents̈e ents̈anga jabuátambana. Chë ba ents̈anga cha jóyebuambayama tmojanuenënga, imojenjnaná y tmojánayana: “¿Ndë́moca quem boyabása lempe chca tojuatsjinÿe? ¿Ndaye osertánana mua tmojats̈etá, y nts̈ámoyeca cha yojtsobena chca bëts soyënga jtsamana ca? ");
INSERT INTO kbh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Mua ndoñe chë calpintero yondmëna, Mariybe uaquiñá, y chabe cats̈átanga ndoñe mondmëna Santiago, José, Judas y Simón; y chabe uabénangnaca muents̈e ndoñe bë́ngaftaca mondoyena ca?” —chënga imojtsichamo. Chë causa chënga tmojanotjayaná, y ndoñe montsebos̈e joyeunayana. ");
INSERT INTO kbh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","As Jesús tojanë́yana: “Nÿetsca luarënguenache canÿe Bëngbe Bëtsabe juabna oyebuambnayábioye bëtsá jabemana, pero ndoñe chca cachabe luarents̈e, ni cachabe pamíllangbenache, ni cachabe yebnents̈e ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chë ents̈anga chents̈e chábeñe ndoñe montsanos̈buaché causa, Jesús ndoñe tonjanobená ni canÿe bëts soye Bëngbe Bëtsabe obenánaca chents̈e jëftsemana; nÿe básefta s̈oquë́ngbeñe cucuats̈ënga tojanjajó y tojanashná. ");
INSERT INTO kbh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús ojnananá yojtsemna cachábents̈a ents̈anga chábeñe ndoñe montsanos̈buaché causa. Chents̈ana, chë chaboye base pueblënguenache Jesús yojánana, Bëngbe Bëtsabe soyëngama abuátambaye. ");
INSERT INTO kbh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Y chë bnë́tsana uta uatsjéndayënga Jesús tojánachembo, y utáta ínÿoye tojanichamó, ents̈ángbents̈ana bacna bayëjënga jtëbuacnama obenana jats̈atayëse; ");
INSERT INTO kbh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","y mënts̈á yojáuyana: “Benachiñama tondaye s̈mattsambaye, nÿe canÿe jatjonëfja; ndoñe s̈mattsambaye saná, ni shecnaja, ni crocénana uasnanëchiñe. ");
INSERT INTO kbh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nduámanëshe s̈mochjesóshecochëtjo, y nÿe canÿájua s̈mochjesíchëtjo ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mënts̈ánaca tojanë́yana: “Posada chacmojúyents̈ame yebnents̈e s̈mochtsoquedañe inÿe puebloye játantscuana. ");
INSERT INTO kbh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Canÿe luaroye chas̈mojáshjajna y ndocná posada chacmonjuyents̈ame, y joyeunayama ndoñe chamontsebos̈ëse, chents̈ana s̈mochjésebocana, y shecuats̈ents̈a polvëshe s̈mochjésenstoto, chca, chë́ngbioye jinÿanÿiyama chënga ndoñe ts̈abá ts̈ëngaftangaftaca tmonjamama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chents̈ana, chë uatsjéndayënga tmojë́ftsanbocana y ents̈anga imojánabuayiynaye, chë ts̈abe benache chámuatishachama, bacna soyënga amana jtsajbanase. ");
INSERT INTO kbh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ents̈ángbents̈ana ba bacna bayëjënga tmojtanëbuacna, y ba s̈oquënga aceitíyeca tmojananë́totjo y tmojanashná. ");
INSERT INTO kbh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodes Jesusbiama yojátats̈ëmbona, er nÿetsquénache nÿetsca ents̈anga chabiama imojtsóyebuambnaye. Ents̈anga Jesusbiama imojtsichamo: “Juan chë Ubayaná obanënguents̈ana tojtayena, chíyeca cha chca obenana yojtsebomna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inÿengna imojtsichamo: “Cha entsemna chë Bëngbe Bëtsabe juabna oyebuambnayá Elías ca.” Y ínÿengna: “Muana canÿa Bëngbe Bëtsabe juabna oyebuambnayá, mo chë tempsquëngcá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heródesna nts̈amo ents̈anga Jesusbiama imojtsichamcá tojanuena ora, tojánayana: “Mua Juan entsemna, chë ats̈e sënjanmandá bests̈as̈e chamotsëstjanguamá, mora obanënguents̈ana tojtayena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Juan cabá ainá ora, Herodes tojanmandá cha chamishache, cadenë́juangaca chamobátsëca y chca cárceloye jutámiama. Herodes chca tojanma Herodíasbe causa, chabe uabentsá Felipbe shema. Herodes chë shémaftaca tojanobouamá, Felipe cabá ainá ora. ");
INSERT INTO kbh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Y chama, Heródesbioye Juan ibojánbuayiynaye: “Ndoñe quenátslesenciana acbe uabentsabe shema acbe shema chaotsemnama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chë causa, Herodías Juánbioye puerte ibojuáya, y yojánbos̈e jtsóbama; pero ndoñe yontsobena, ");
INSERT INTO kbh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","er Herodes yojántats̈ëmbo, Juan canÿe nÿetsca soyënguiñe ts̈abá amá, nÿe Bëngbe Bëtsábioye sempre oservená inamnama. Chama cha yojánauatja y ndoñe yonjanaleséncia cha chamóbama. Y Juan Bëngbe Bëtsabe soyëngama Heródesbioye tbojtsebuayiyná ora, nts̈amo jajuaboyana ndoñe yontsetáts̈ëmbo, pero masque chca, oyejuayá Juánbioye ibnayeunana. ");
INSERT INTO kbh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero Herodías tojáninÿena mocna ora Juan chamóbama. Heródesbe cumpleaño oboyejuaye ora, bëtscá saná tmojanprontá, y Herodes yojúbuaja chabe amë́ndayënga, soldadëngbe amë́ndayënga y Galileoca uámana ents̈anga. ");
INSERT INTO kbh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chora, chë oboyejuaye luaroye Herodíasbe bembe tojánamashëngo, tojanlantsá, y Herodes y nÿetsca ófjanënga chama ts̈a imojtsóyejuaye. As chë rey, chë tobiás̈bioye tbojaniyana: —Ndayánaca s̈motjañe y ats̈e cbochjáts̈etaye ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Y jajúrase, mënts̈á tbojans̈buachená: —Nts̈amo chas̈cojotjañcá cbochjáts̈etaye, masque ats̈be amë́ndayents̈a bomnanents̈ana tsë́ntsañnaca ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chents̈ana, chë tobias̈e yojë́ftsebocna y chabe mamábioye ibojatjaye: —¿Ndayá chjotjañe ca? Y chabe mamá ibojojuá: —Juan chë Ubayanabe bests̈as̈e ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cachora chë tobias̈e betsco chë rey yojtsemnoye tojtanamáshëngo, y tbojaniyana: —Ats̈e së́ntsebos̈e, cam ora Juan chë Ubayanabe bests̈as̈e canÿe s̈cnenës̈iñe chas̈cuats̈etá ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes chama corente tbojanongmé, pero chë ents̈angbe delante y jajúrase tbojans̈buachená causa, ndoñe yonjobenaye nts̈amo tbojaniyancá jebëbuetámenana. ");
INSERT INTO kbh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Cachora chë rey canÿe soldado ibojíchmua, Juanbe bests̈as̈e chauiyëbama. ");
INSERT INTO kbh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","As chë soldado cárceloye tojána, Juánbioye bests̈as̈e tbojtsanë́stjango, y canÿe s̈cnenës̈iñe tojanamba. Chë tobiás̈bioye tbojanënts̈abuaché, y chana, chabe mamábioye. ");
INSERT INTO kbh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juanbe ústonënga chama imojátats̈ëmbona ora, choye tmojánashjajna, chabe cuerpo tmojésanocñe y jauátbontsama tmojána. ");
INSERT INTO kbh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chë Jesús tojánichamonga chábioye tmojtanashjajna ora, lempe nts̈amo tmojanmama y tmojanabuatambama cha tmojancuentá. ");
INSERT INTO kbh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chora Jesús tojanë́yana: “Cuajna ínÿoye, ents̈anga ndoyena luaroye, bats̈atema jóchnama ca.” Cha chca tojánayana, er ts̈a ents̈anga imojtsaye y imojtsabëbana; ni mo jasama ndoñe luare imontsebomna. ");
INSERT INTO kbh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","As cánÿenga barquë́shañe tmojtsanoñe, ents̈anga ndëbínÿnoye. ");
INSERT INTO kbh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero chënga imojtsoñama ents̈anga tmojánanÿe, y ndëmuanÿenga imojamnama imojtsetáts̈ëmbo; chcasna, chë ents̈anga shecuáts̈eca betsco tmojána, nÿetsca pueblënguents̈ana, y chëngbe natsana choye tmojánashjajna. ");
INSERT INTO kbh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Chents̈ana, chë barquë́shoicana tojánastjango ora, Jesús ba ents̈anga tojánanÿe; chëngbiama tbojanongmé, er imojtsemna mo abuajë́nÿa ndbomna oveshëngcá; y tojanonts̈é ba soyëngama jabuátambana. ");
INSERT INTO kbh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya jetiñe yojtsemna orna, chabe uatsjéndayënga tmojanobobeconá y tmojaniyana: —Ya jetiñe entsemna, y quem luariñe ndocná quenatiyena. ");
INSERT INTO kbh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ents̈anga cuantichamuá, pueblotémëngoye y inÿe luarëngoye chamotsoñama, ndayánaca jasama chamobuámiñama ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Y Jesús tojanë́yana: —Ts̈ëngaftanga saná chë́ngbioye s̈mochjacaredádaye ca. Chora chënga tmojaniyana: —Crocénana queftsátsbomna, uta patse denario nÿets̈á, chëfta ents̈angbiama saná jabuámiyama ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","As Jesús tojanë́yana: —¿Bueta tandës̈e s̈mojtsebomna? Marrepáranga ca. Ya imojtsetáts̈ëmbo ora, tmojaniyana: —Shachna tandës̈e y uta beónata fsë́ntsebomna ca. ");
INSERT INTO kbh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chora Jesús ents̈anga tojanamëndá ínÿoca ínÿoca chamoshë́ntsjatbiamama. ");
INSERT INTO kbh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","As chënga tmojanotbiama patse patsënga y shachna bnëtsátsanënga. ");
INSERT INTO kbh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Chora Jesús chë shachna tandës̈e y chë uta beónata tojanca, y celoye jontjes̈iyëse, Bëngbe Bëtsábioye chama tbojtanchuá. Chents̈ana chë tandës̈ënga tojanjatá y chabe uatsjéndayënga tojanayents̈buaché chë ents̈anga jats̈atayama. Y chë uta beónatnaca nÿetscanga tojanëjátaye. ");
INSERT INTO kbh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nÿetscanga tmojanse jtoshachaye nÿets̈á. ");
INSERT INTO kbh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y chents̈ana, chë tandës̈e y chë beonents̈ana ojamnëtémënga tmojanatbaná, y bnë́tsana uta sbarë́cua tmojanajutjé. ");
INSERT INTO kbh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chë saná tmojansënga imojamna shachna uaranga boyabásenga, shembásenga y básenga ntjacuntacá. ");
INSERT INTO kbh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chents̈ana, Jesús chabe uatsjéndayënga tojanamëndá chë barquë́shoye jtas̈jnama, chë uafjajónaye chenguana jangana y chabe natsana Betsaida ca uabaina puebloca jashjajnana. Chënga imojtsebocanëntscuana, Jesús chë ents̈anga yojtichamuá. ");
INSERT INTO kbh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nÿetscanga tojtanadios̈oftá ora, tjoye cha tojtsanoñe Bëngbe Bëtsáftaca jencuéntama. ");
INSERT INTO kbh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yojtseibétatana ora, chë barquë́sha uafjajónaye tsëntsaca yojtsamna, y Jesús, canÿa fshantsoca. ");
INSERT INTO kbh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús tojáninÿe chëngbiama totcá yojtsemna, chë barquë́shaca natsanoye jtsayana, er binÿia chëngbe contra yojtsemna. Ya binÿana ora, chë́ngbioye yojobeconá, béjaye juatsbuacá yojtsaye, y ya chëngbiajana nÿe ndericho jachnënguama yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Y chënga, chë béjaye juatsbuacá cha yojtsayama tmojáninÿe ora, tmojanjuabó cha canÿe añemëse yojtsemna ca, y tmojanonts̈é yoyana; ");
INSERT INTO kbh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","er nÿetscanga chca tmojáninÿe y cochauatjanánënga imojtsemna. Pero Jesús cachora tojanë́yana: “¡Añemo s̈mochtsebomna; ats̈e Jesús sëndmëna; ndoñe matauatjëngana ca!” ");
INSERT INTO kbh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chorna, chënga imojtsemna barquë́shoye cha tojánas̈ëngo, y chë jabuache binÿia tojanë́jbana, y nÿetscanga puerte auatjanánënga y ojnanánënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chënga tmojáninÿe chëfta ents̈anga tandës̈e jujátayana, pero chëngbe ainanoca cabá ndoñe imontsobena josértana, Jesús lempe jamama obená bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chë uafjajónaye tmojánenashbuachengo ora, Genesaret ca uabaina luaroye tmojánashjajna, y chë uafjajónaye tsachoca chë barquë́sha tmojanë́tsbua. ");
INSERT INTO kbh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chë barquë́shoicana tmojánastjajna y cachora ents̈anga Jesús tmojantëmbá. ");
INSERT INTO kbh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chíyeca, chë luariñe yebnënguenache betsco chënga tmojána, y tmojanonts̈é chë s̈oquënga tjuashënguiñe juyambana, chë ndë́moye tmojanuena Jesús yojtsemna luaroye. ");
INSERT INTO kbh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y ndayents̈e cha tojámashëngüents̈e, pueblënguiñe, bëts pueblënguiñe y base pueblotémënguiñnaca, chë s̈oquënga benachoye imojtsëbuacana, y Jesús corente imojtseimpadana chë s̈oquënga chaualesenciá, nÿe mo chabe ents̈ayá sibuájua juabojajuana. Y nÿetscanga tmojuábojajënga ts̈abá imojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chents̈ana, fariseunga Jesúsbioye tmojanobeconá y báseftanga ley abuátambayëngnaca, Jerusalenocana áshjajnënga. ");
INSERT INTO kbh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Chënga tmojáninÿe básefta Jesusbe uatsjéndayënga, cabá ndase ora, ndoñe montsacuents̈abiá nts̈amo chë judiënga imojanamancá. ");
INSERT INTO kbh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Er chë fariseunga y nÿetsca judiënga imojanamana jtsacuénts̈abiana ba soye, ndayá jasama ora, nts̈amo chëngbe bëts taitanga imojanamancá. Chënga imojanjuabná, chca jtsamëse Bëngbe Bëtsabe delante ts̈ábenga jtsatsmënama ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chë sananga enocana tmojtashjango ora, ba soye ndoñe tmontsácuents̈abese, tondaye ntjasana; y ba soyë́ngnaca imojánama, pero nÿe chëngbe bëts taitanga chca jamana imojanamánayeca, mo chë béjayeca juabáyana tazës̈ënga, matbajënga, calderëshënga y jutsnëshangá. ");
INSERT INTO kbh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chë causa, chë fariseunga y chë ley abuátambayënga Jesús tmojantjá: —¿Ndáyeca acbe uatsjéndayënga ndoñe montsama nts̈amo bëngbe bëts taitanga monjanamancá, y montsesá ntsacuénts̈abiase, ndoñe nts̈amo bënga judiënga fsënduamancá, Bëngbe Bëtsabe delante ts̈abá jtsatsmënama ca? ");
INSERT INTO kbh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Chora Jesús tojanë́yana: —Nÿe ts̈abá chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías ts̈ëngaftangbiama tojánayana, bacna ents̈anga chë nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga ca, mënts̈á enduabemanents̈e: Quem ents̈anga mondbétsichamo Bëngbe Bëtsá ts̈a ts̈abia yomna ca; chca nÿe uayás̈aca, pero chëngbe ainanents̈e ndocna ts̈abe juabnë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pero chënga nÿe bonamente mondbétsichamo Bëngbe Bëtsá ts̈a ts̈abia yomna ca; chënga nÿe ents̈angbe mandënga jtsabuátambayana, y Bëngbe Bëtsabe mandënga ndoñe ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chora Jesús tojanë́yana: —Nts̈amo Bëngbe Bëtsá tojanmandacá stëts̈oye ts̈ëngaftanga s̈mojtsequedá, nÿe nts̈amo ents̈anga monduamancá jtsamama ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y mënts̈ánaca tojanë́yana: “Ts̈ëngaftanga nts̈amo Bëngbe Bëtsá tojanmandacá stëts̈oye jtsequédana, nÿe nts̈amo ts̈ëngaftangbe anteunga imojanamancá jtsamama. Ts̈ëngaftanga jtsejuabnayana ts̈abá s̈mojtsama ca chca s̈mojtsama ora. ");
INSERT INTO kbh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés tonjánayana: ‘Acbe bëtsë́tsata ndoñe stëts̈oye catjáquedaye’, y ‘nda chabe bëtsë́tsatbiama ndoñe ts̈abá tonjoyebuambá chana, jóbanama jtsemnana ca.’ ");
INSERT INTO kbh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero ts̈ëngaftanga s̈mondbétsichamo, canÿe ents̈á yobena chabe taitá o chabe mamá jáuyanana: ‘Lempe së́ndbomna soyënga corbán entsemna, chíyeca ndoñe quetsátobena juajabuáchana ca’ (corbán endayana “Bëngbe Bëtsabiama uáts̈ëmbona soyënga ca”). ");
INSERT INTO kbh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ts̈ëngaftanga s̈mondbétsichamo, nda chca tojayanëse, ya ndoñe obligaciónaca ntsemnana chabe taitá o mamabiama ndayánaca jamama ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chca, ts̈ëngaftanga s̈montsama ents̈anga Bëngbe Bëtsabe palabra stëts̈oye chamoquedama, mo tondaye tontsamancá, chë cuenta jtsamama nts̈amo anteunga imojanamancá, nts̈amo ents̈ángbeñe tempscana y më́ntscoñama yochnëjuancá. Y ba soyënga ts̈ëngaftanga cachcá s̈montsama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chora Jesús, cachiñe ents̈anga tojtanachembo y tojanë́yana: “Nÿetscanga s̈mochjouena y chacmësertá. ");
INSERT INTO kbh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndayá ents̈á tojtsesacá, ndoñe ntjábemana ndoñe ts̈abia Bëngbe Bëtsabe delante. Inÿets̈á comna: nts̈amo ents̈á tojtsejuabná y tojtsoyebuambnacá endobena jabemana ndoñe ts̈abia Bëngbe Bëtsabe delante. ");
INSERT INTO kbh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chë jouenama tmojtsobenënga, s̈mochjouena ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús ents̈anga tojë́ftsanabashejuana y yebnoye tojtanamáshëngo ora, chabe uatsjéndayënga tmojantjá nts̈amo cha tojánayanama. ");
INSERT INTO kbh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","As cha tojanë́yana: “¿Ts̈ëngaftángnaca cabá ndoñe cmontsë́sertana ca? ¿Cabá ndoñe cmontsë́sertana, lempe nts̈amo ents̈á tojascá ndoñe ntsobenana chábioye jabemana ndoñe ts̈abia Bëngbe Bëtsabe delante; ");
INSERT INTO kbh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","er ainanoye ndoñe ntjómashënguana, sinó uafsbioye, y chents̈ana cuerpents̈ana jtabocnana ca?” Y chca, Jesús tojánayana nÿetsca sananga ts̈abá jasama yomna ca y chë saná ndoñe ntjamana canÿe ents̈á bacna soye chaotsamama ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y mënts̈ánaca tojánayana: “Nts̈amo chë ents̈á tojtsejuabná y tojtsoyebuambnacá, chë soye cocayé endobena ents̈á jabemana ndoñe ts̈abia Bëngbe Bëtsabe delante. ");
INSERT INTO kbh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Er ainanocana jtsóbocanana bacna juabnënga: shembásaftaca o boyabásaftaca bacna soye jamama, jatbëbama, jóbama, ");
INSERT INTO kbh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bacna juabnënga boyá o shémbioye ínÿaftaca jaíngñama, jtsatbomnayama, nÿetsca bacna soyënga jamama, ínÿenga jáingñama, nÿe cachá jenomándama ntsobencá jtsiyenama, ínÿabioye jtsánts̈abos̈ama, ínÿabiama jtsayátsenayama, jtsenábotamnayama y nÿe opënga jtsobiamnayama. ");
INSERT INTO kbh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nÿetsca quem bacna soyënga ents̈abe ainanocana jóbocnana, y cha jabemana ndoñe ts̈abia Bëngbe Bëtsabe delante ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús chents̈ana, Tiro ca uabaina luaroye tojtsanoñe, y canÿe yebnents̈e tojánamashëngo. Cha yojtsebos̈e ndocná chama chaondë́tsetats̈ëmbuama; pero ndoñe yonjobenaye iytëmenana jatsmënana. ");
INSERT INTO kbh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Y betsco, canÿe shembása, canÿe bembe bacna bayëjbe juabna uambayá ibnabomná, Jesusbiama oyebuambnayana yojouena ora, chábioye tojánabo y chabe shecuats̈ents̈e tojanoshëntsaments̈é. ");
INSERT INTO kbh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chë shembása ndoñe yonjamna judiá, sinó Sirofenicia luarocá. Tojánabo y Jesúsbioye tbojanimpadá chabe bembetémbents̈ana bacna bayëja chabuatábocnama. ");
INSERT INTO kbh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús tbojaniyana: —Ats̈e s̈ondmëna natsana judío ents̈angbiama chë soyënga jamana; chents̈ana cocayé chanjobenaye chca inÿe ents̈angbiama jamana. Ats̈e acbiama, canÿe ndoñe judiá, soyënga stjamëse, nántsemna mo chë básengbe saná ques̈ënga cuaftsëbuajocá ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Y cha tbojanjuá: —Arseñor, chca jtsemnana. Pero chë ques̈ë́ngnaca mondbase chë básenga tmojtsesá ora tmojatquë́cjanatemënga. Chcasna, Diosmanda áts̈naca s̈motsajabuache ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","As Jesús tbojaniyana: —Ts̈abá tcjayana; chcasna, acbe yebnoye motsatoñe. Chë bacna bayëja acbe bembetémbents̈ana tonjésebocna ca. ");
INSERT INTO kbh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chents̈ana, chë shembása chabe yebnoye tojtaná, y tbojáninÿena chë bembetema jutsnë́shents̈e yojtsojájoñe, y chë bacna bayëja ya ndoñe chábeñe yontsemna. ");
INSERT INTO kbh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro pueblents̈ana Jesús tojë́ftsanbocna, y Sidón y Decápolis luarents̈a pueblënguëjana jachnënguse, Galilea uafjajónayoye tojánashjango. ");
INSERT INTO kbh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cha chents̈e yojtsemna ora, chábioye tmojanánatse canÿe ents̈á tësmá y ndëbiá, y tmojanimpadá chabe cucuats̈ënga chë s̈ocábeñe chaojájoma, chaboshnama. ");
INSERT INTO kbh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chorna Jesús ents̈ángbents̈ana luaroye tbojanánatse, cánÿata. Chora chë s̈ocabe matscuas̈oye nts̈abuafjënga yojajué, cucuats̈iñe yojabuashëtjo, y chë s̈ocabe bichtaja yojábojajo. ");
INSERT INTO kbh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chents̈ana, Jesús celoye tojanontjes̈é, jabuache yojáshachna, y hebreo palabriñe tbojaniyana: “¡Efata ca!” (Chca endayana “¡Chacmotsauenana ca!”) ");
INSERT INTO kbh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Cachora, chë boyabásabe matscuas̈e ts̈abá yojtsatsmëna y ts̈abá yojtsuenana; chë bichtaja ts̈abá yojtóbema y ts̈abá yojtsóyebuambnaye. ");
INSERT INTO kbh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y Jesús chë ents̈anga tojanamëndá chama ndocnábeñe ntsecuéntayana. Pero masque ts̈a chama yojtsamë́ndaye, ents̈anga más chabiama imojtsencuéntaye. ");
INSERT INTO kbh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chama chë ents̈anga puerte imojtsenjnanaye, y mënts̈á imojtsichamo: “¡Lempe ts̈abá entsama! Chë tësmënga chamouenama, y chë ndëbianga chamóyebuambama entsama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chë tempo, ba ents̈anga Jesúsbioye cachiñe tmojanobeconá, y jasama tondaye imontsebomna. As Jesús chabe uatsjéndayënga tojánachembo y tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Quem ents̈angbiama s̈ontsengmena, er ya unga te áts̈eftaca montsemna y mora jasama tondaye quemátsbomna. ");
INSERT INTO kbh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cachëngbe yebnoye tondaye ntjascá stichamuase, shëntsama benachëjana nantsabuatëcja; y báseftanga bën luarocana tmojabo ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","As chabe uatsjéndayënga tmojaniyana: —¿Nts̈amo nda nanjobenaye quem luarents̈e, ndocna ents̈á ndoyenents̈e, chëfta ents̈angbiama saná jinÿenama ca? ");
INSERT INTO kbh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chora cha tojanatjá: —¿Bueta tandës̈e s̈mojtsebomna ca? Y chënga tmojanjuá: —Canÿsë́ftas̈e ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chents̈ana, Jesús tojanamëndá ents̈anga chamoshë́ntsjatbiamama. Chorna, chë canÿsëfta tandës̈e tojanca y Bëngbe Bëtsábioye chama tbojtanchuá. Chents̈ana tojanjatá, chabe uatsjéndayënga tojanëjatá, y chëngna chë ents̈ángbioye. ");
INSERT INTO kbh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Básefta beonatémëngnaca imnabomna; as Jesús, Bëngbe Bëtsábioye chama tbojtanchuá y chabe uatsjéndayënga tojanamëndá ents̈anga jujátayama. ");
INSERT INTO kbh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nÿetscanga tmojanse jtoshachaye nÿets̈á. Chents̈ana cabá canÿsëfta bëts sbarë́cua tmojanajutjé chë ojamnëtémëngaca. ");
INSERT INTO kbh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chë tmojansënga imojamna mo canta uaranga nÿets̈á. Chents̈ana Jesús chë ents̈anga tojtanadios̈oftá. ");
INSERT INTO kbh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chora Jesús barquë́shañe tojánenojayiye chabe uatsjéndayëngaftaca, y tmojtsanoñe Dalmanuta ca uabaina luaroye. ");
INSERT INTO kbh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chents̈ana, fariseunga tmojánabo y tmojanonts̈é Jesúseftaca enatsëtsnayana. Y jisháchichiyama, imojtseimpadana canÿe bëts soye chaoma, as jtsetats̈ëmbuama Jesusbe obenana Bëngbe Bëtsábiocana ndegombre tainóbocanama. ");
INSERT INTO kbh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Y Jesús ngménaca, jabuache yojáshachnëse, mënts̈á tojánayana: “¿Ndáyeca ts̈ëngaftanga, chë mora oyenënga, s̈mojtsebos̈e canÿe bëts soye chaimama ts̈ëngaftanga ats̈be obenana jinÿanÿiyama ca? Ndegombre cbë́yana, quem ents̈anga ndocna chca soye quemochátinÿe ca.” ");
INSERT INTO kbh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chorna chë ents̈anga cachcá tojesanënÿá, chë barquë́shoye yojtamáshëngo, y uafjajónaye chenguana yojtsoñe. ");
INSERT INTO kbh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Chë uatsjéndayënga yojésebnëtjomba ndaye soye jasama jesocñama, y chë barquë́shoye nÿe canÿe tandës̈e imojtsebomna. ");
INSERT INTO kbh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús tojanë́yana: —S̈mochtsantjes̈na; cuedado s̈mochtsebomna fariseunga y Heródesbe levadurama ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chora chë uatsjéndayënga tmojanonts̈é enatsëtsnayana: —Chca entsichamo, bënga tandës̈e ndoñe tmonjesocñama ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús yojtsetáts̈ëmbo, chabe uatsjéndayënga imojtsejuabnaye chana tandës̈ama yojtsëtsëtsnaye ca; pero ndegombre chana yojtsóyebuambnaye ndayá nts̈amo fariseunga y Herodes bacna soyënga jtsamëse imojoyenama. Chcasna, mënts̈á tojanë́yana: —¿Ndáyeca tandës̈ama s̈mojtsoyebuambná? ¿Cabá ndoñe cmontsë́sertana, ni s̈montsetáts̈ëmbo? ¿Ainanoca ndoñe s̈montsebos̈e chacmë́sertama? ");
INSERT INTO kbh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bominÿe s̈mondbomna, pero ndoñe ques̈mátobena jinÿana; jouenama s̈mondobena, y ndoñe ques̈mátuenana, y ndayá tijamama ndoñe ques̈matsjuabná. ");
INSERT INTO kbh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chë shachna uaranga ents̈anga shachna tandës̈ents̈ana sënjanëjatá chents̈ana, ¿bueta sbarë́cua chë ojamnëtémëngaca s̈mënjanajutjé ca? —cha tojanatjá. Y chënga tmojanjuá: —Bnë́tsana utácua ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Y chë canÿsëfta tandës̈ents̈ana canta uaranga ents̈anga sënjanëjatá chents̈ana, ¿bueta bëts sbarë́cua chë ojamnëtémëngaca s̈mënjanajutjé ca? Y chënga tmojanjuá: —Canÿsëftácua ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","As Jesús tojanë́yana: —¿Y cabá ndoñe cmontsë́sertana ca? ");
INSERT INTO kbh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chents̈ana tmojánashjajna Betsaida puebloca; y chora, ents̈anga canÿe boyabása jtaná Jesúsbioye tmojanánatse, y tmojanimpadá cha jabojajuana chabotseshnama. ");
INSERT INTO kbh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","As, chë jtanábioye tbojanábuacueshache, y chë pueblo chaboye tbojanánatse. Chorna, yebuáyeca ibojabuchanëtjo, y chábeñe cucuats̈ënga yojajájua, y tbojantjá nderado ndayá jinÿama tayojtsanobena ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","As chë jtaná yojontjes̈iye y tojánayana: —Boyabásenga sëntsë́nÿa; mo betiyëngcá montsemna, pero montsobonjná ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Chora Jesús, chë jtanabe fs̈nëbeñe cachiñe cucuats̈ënga yojajájua. Y chë boyabása yojtsobena lempe ts̈abá jinÿama; ya shnaná yojtoquéda. Y yojtsobena nÿetsca soyënga botamana jinÿana. ");
INSERT INTO kbh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chents̈ana, Jesús cachabe yebnoye tbojtanichmó y mënts̈á tbojaniyana: —Chë puebloye ndoñe catjë́ftsamashëngo ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chents̈ana, Jesús tojánbocna chabe uatsjéndayëngaftaca Cesarea de Filipo luaroca pueblëngoye, y benachiñe chabe uatsjéndayënga tojanatjá: —¿Nda ats̈e bétsemnama ca ents̈anga imojtsichamo ca? ");
INSERT INTO kbh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y chënga tmojaniyana: —Inÿenga montsichamo Juan chë Ubayaná ca, ínÿengna Elías ca, y ínÿengna, canÿe Bëngbe Bëtsabe juabna oyebuambnayá ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","As Jesús tojanatjá: —Y ts̈ëngaftangna, ¿nda ats̈e bétsemnama nts̈amo s̈mochjayana ca? Y Pedro tbojanjuá: —Acna chë Cristo condmëna, chë Bëngbe Bëtsabe Uámana Uabuayaná ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Chents̈ana Jesús corente chënga tojanamëndá, chë nda cha yojamnama ndocnábeñe ntsecuéntayana. ");
INSERT INTO kbh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y Jesús tojanonts̈é chabe uatsjéndayënga jabuátambana, cha, chë Bëngbe Bëtsá Ents̈á tbojanbemá, ibojamna puerte jasúfriana ca; chë judië́ngbeñe bëtsëjemëngcá amë́ndayëngbiama, chë judiëngbe más uámana bachnangbe amë́ndayënga y ley abuátambayëngbiama uabotená jtsemnana ca. Ents̈anga mochjanóba, pero unga tianoye yochtanayena ca. ");
INSERT INTO kbh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nÿetscanga catafjosertaycá chama yojtsóyebuambnaye. As Pedro, Jesúsbioye luaroye tbojanánatse, y tojanonts̈é jtsáuyanana. ");
INSERT INTO kbh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús yojobuértana, chabe uatsjéndayënga tojanënÿanÿé, y Pédrëbioye mënts̈á tbojtsanbochembo: “¡Satanás, áts̈bents̈ana mojuaná! Pedro, acbe juabnënga Bëngbe Bëtsábiocana ndoñe quenatóbocana, sinó nÿe ents̈ángbents̈ana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chents̈ana, Jesús chabe uatsjéndayënga y chë inÿe ents̈anga tojánachembo chamouenama, y tojanë́yana: “Nda ats̈be uatsjendayá jtsemnama tojtsebos̈e, cháuayana nÿe Bëngbe Bëtsá yobena sempre chabe vidiñe jtsemándayana ca, chabe quem luarents̈a soyënga cachcá chauesonÿá ats̈e juastama, y ats̈biama jasúfriama chaotseprontana y cruciñe jobanámnaca. ");
INSERT INTO kbh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nda tojtsama quem luarents̈e bëtscá soyënga jtsebomnama y ats̈biama jasúfriama ndoñe tontseprontana, chë nÿetsca tescama yomna ts̈abe vida echanjopérdia. Pero nda quem luarents̈a soyënga cachcá tojëftsonÿá ats̈e juastama, y chë ts̈abe noticiënga ats̈biama abuátambaye causa, masque chaóbana, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ndayama ents̈á buanjosérvia nÿetsca quem luarents̈a soyënga jtsebomnana, chë nÿetsca tescama yomna ts̈abe vida tojtsoperdese? ");
INSERT INTO kbh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Er canÿe ents̈á chë nÿetsca tescama yomna ts̈abe vida tojtsoperdese, ndocna soye quenátsmëna cha chaobená joyiyama, chë nÿetsca tescama yomna ts̈abe vida jtsebomnama. ");
INSERT INTO kbh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chcasna, nda mora ats̈biama y ats̈be buayenana soyëngama tojtsëuatja ents̈ángbeñe, chënga chë Bëngbe Bëtsabiama nduauenanënga y bacna soye amënga, chë Bëngbe Bëtsá Ents̈á tbojanbemánaca chabiama echantsëuatja, chabe Taitabe bëts obenánaca y chabe angelë́ngaftaca chaojésabo ora ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mënts̈ánaca Jesús tojanë́yana: “Ndegombre cbë́yana, báseftanga muents̈e montsemnënga ndoñe quemochatóbana, Bëngbe Bëtsá ents̈ángbeñe chabe obenánaca jabomándama jabana ntjëftsinÿcá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chents̈ana chnë́nguana tianoye, Jesús tojë́ftsanëbiats̈e Pedro, Santiago y Juan, y ínÿoye tojanënatse nÿe chënga, canÿe bëts tjoye. Y chëngbe delante Jesús inÿets̈á tojanobinÿná; ");
INSERT INTO kbh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","chabe uichëtjonëjuangá ts̈a yojtsabuashinÿinÿana; corente uafjantsëjuangá yojtsamna; nÿa chca juafjantsama ndocná quem luarents̈e quentatobenaye. ");
INSERT INTO kbh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chca orna, chë uatsjéndayënga tmojáninÿe, Moisés y Elías tbojanobinÿná Jesúseftaca encuéntaye. ");
INSERT INTO kbh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Chora Pedro, Jesúsbioye tbojaniyana: “¡Buatëmbayá, ts̈a ts̈abá bëngbiama cuanmëna muents̈e jtsemnana ca! Mora fchanjapórma unga tambotémënga: cánÿetema acbiama, ínÿetema Moisesbiama y ínÿetema Elíasbiama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chca tojánayana, chë uatsjéndayënga yapa auatjanánënga imojtsemna causa, y Pedro ndoñe yontsetáts̈ëmbo nts̈amo jayanana. ");
INSERT INTO kbh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chora canÿe jants̈etëshe yojóbema, y chë́ngbioye yojáutsbotse; y chë jants̈etëshoicana canÿe oyebuambnayana tojanóbocna, mënts̈á: “Mua ats̈be bonshana Uaquiñá endmëna; cha s̈mochtseyeunana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Y ndeolpe, chëngbe shë́conana tmojanrrepará ora, ya ndocná más tmonjáninÿe; nÿe Jesús canÿa chë́ngaftaca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chë tjocana imojtsatstsmaye ora, Jesús chë uatsjéndayënga tojanamëndá: —Bëngbe Bëtsá Ents̈á tbojanbemá obanënguents̈ana candë́tayenëntscuana, chë mënté tjoca s̈monjinÿe soyama ndocnábeñe s̈mattsecuéntaye ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chë uatsjéndayënga aíñe chca tmojanuena; pero chënga imojtsentjanaye ndayá cha yojtsents̈áyana, cha yochtanayena ca cha tojánayana ora. ");
INSERT INTO kbh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y Jesúsbioye imojtsetjanaye: —¿Ndáyeca chë ley abuátambayënga mondbétsichamo, canmëna Bëngbe Bëtsabe Uámana Uabuayanabe natsana Elías jabana ca? ");
INSERT INTO kbh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","As cha tojanë́jua: —Ndegombre, canÿa Eliascá natsana echanjabo, y nts̈amo jtsemnama yomncá lempe echánjabatsma. Pero nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancana, Bëngbe Bëtsá Ents̈á tbojanbemá puerte caochjasúfria, y ínÿenga puerte camochtsáboyënja ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ndegombre cbë́yana, canÿa Eliascá ya tonjabo, y cháftaca ents̈anga tmonjanma lempe nts̈amo tmojabos̈encá, nts̈amo chaochnënguama Bëngbe Bëtsabe uabemana palabrënguiñe endayancá. ");
INSERT INTO kbh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Chents̈ana, chënga tmojtaná chë inÿe uatsjéndayëngbioye. Chora, Jesús tojáninÿe ba ents̈anga chë uatsjéndayëngbe shë́conana imojtsemnama, y básefta ley abuátambayëngna chë́ngaftaca imojtsenatsëtsnaye. ");
INSERT INTO kbh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nÿetsca ents̈anga cha tmojáninÿe ora, imojenjnaná y tmojanótjajo cha jachuayama. ");
INSERT INTO kbh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chora Jesús chënga tojanatjá: —¿Ndayama chë́ngaftaca s̈menatsëtsná ca? ");
INSERT INTO kbh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Y canÿa ents̈anguents̈á tbojanjuá: —Buatëmbayá, muents̈e ácbioye sënjuánatse ats̈be uaquiñá; bacna bayëjbe juabna entsambá, y chë causa, jóyebuambayama ndoñe quenátobena. ");
INSERT INTO kbh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nÿe ndayénts̈naca cha tojtsemnents̈e, chë bayëja chábioye jishachana y jtsenajuáchesënjana; chents̈e uayoicana shashiye jtsabocanana, jtsenoftë́s̈fjojnayana y obanacá jtsatsjájonana. Acbe uatsjéndayënga sënjaimpadá chë bacna bayëja chamuatábocnama, pero ndoñe chematobená ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","As Jesús tojánayana: —¡Nÿets̈á ndos̈buáchiyënga ca! ¿Buetayté s̈ojtsemna ts̈ëngaftangaftaca jëftsemnana? ¿Buetayté uantado ts̈ëngaftangaftaca chjë́ftsemna? ¡Moye chë básetema mánatse ca! ");
INSERT INTO kbh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chora chë básetema chábioye tmojanánatse; y chë bayëja Jesúsbioye tbojáninÿe ora, tojanma chë basa ataque chaboshachama, y chë basa fshantsoye yojashajaye, yojtsojanduounaye y uayoicana shashiye yojtsábocana. ");
INSERT INTO kbh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","As Jesús chë básabe taitábioye tbojantjá: —¿Buetayté chca yojtsepása ca? Y cha tbojanjuá: —Básetema orscana chca; ");
INSERT INTO kbh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ba soye, chë bayëja chábioye iñoye jtsatmets̈ana y buyeshoye jtashbuets̈ana, jtsóbama. Chíyeca, nderado ndayá chabiama jamama tcojtsobenëse, bënga s̈motsalastemá y s̈motsë́jabuache ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chora Jesús tbojaniyana: —¿Ndáyeca “ndayá jamama tcojtsobenëse ca” s̈cjauyana? Nda Bëngbe Bëtsábeñe tojtsos̈buáchebiama lempe endopodena ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y cachora chë básabe taitá tojanáyebuachena: —Aíñe, Bëngbe Bëtsábeñe sëntsos̈buaché; Diosmanda, ¡más jtos̈buáchiyama s̈majabuache ca! ");
INSERT INTO kbh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Y bëtscá ents̈anga imojtsójotoma Jesús tojáninÿe ora, chë bacna bayëja tbojtsanbochembo mënts̈á: —¡Bacna bayëja, chë básetema tësmá y ndëbiá biamnayá; chábents̈ana maisebocna y ndocna te más chábeñe catjésamashëngo ca! ");
INSERT INTO kbh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y chë bayëja chábents̈ana yojésebocna, yojtseyoye y chë básabioye jabuache ibojeseshatiyiyé; y chë básana mo obanacá tojanoquedá, y chë causa banga imojtsichamo cha obaná yojtsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús tbojanábuacueshache y tbojtanatsbaná; y chë básana yojtëtsaye. ");
INSERT INTO kbh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chents̈ana, Jesús canÿe yebnoye tojánamashëngo, y chabe uatsjéndayëngna luaroca cha tmojantjá: —¿Ndáyeca bënga ndoñe fsënjobená chë bayëja jtabocnana ca? ");
INSERT INTO kbh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y Jesús tojanë́jua: —Chca bayëjënga jtëbuacanamna jobenayana nÿe Bëngbe Bëtsáftaca jencuéntase, chabuájabuachama jaimpádase ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chents̈ana tmojë́ftsanbocna ora, Galilea luarëjana imojtsajna; y Jesús yojtsebos̈e chama ndocná chaondë́tsetats̈ëmbuama, ");
INSERT INTO kbh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","er cha chabe uatsjéndayënga yojtsabuátambaye. Mënts̈á cachabiama yojanëtsëtsnaye: “Bëngbe Bëtsá Ents̈á tbojanbemá ents̈angbe cucuats̈iñe mochanjáboshjona; mochanjóba, pero chents̈ana unga tianoye echántayena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero chënga ndoñe yontsósertana nts̈amo Jesús yojtsanëtsëtsnacá, y chama jatstjanayamna chënga imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chora Capernaum puebloye chënga tmojánashjajna; y cach yebnents̈e imojtsemna ora, Jesús chë uatsjéndayënga tojanatjá: “¿Ndayama benachiñe s̈mabáyenatsëtsnaye ca?” ");
INSERT INTO kbh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Chëngna nÿe iytëca tmojanobiama, er benachëjana chënga imnayénatsëtsnaye, chënguents̈á nda chë más uamaná bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","As Jesús tojanótbema, chabe bnë́tsana uta uatsjéndayënga tojánachembo y tojanë́yana: “Ndánaca nÿetscangbiama chë más uamaná jtsemnama tojtsebos̈ëse, cha chë más nduamaná chaóbema y nÿetscanga chaotsaservena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chora Jesús canÿe básetema tbojánishache, chëngbe tsëntsaca tbojanatsá, tbojantbá y chënga tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ndánaca, áts̈beñe os̈buachiyá bétsemnayeca, tbojofja canÿa mo quem basetemcá, chana ats̈e jofjana; y nda ats̈e s̈ojofja, chora cha nÿe ats̈e ndoñe ntjofjana, sinó chë s̈ojichmó chábioynaca jofjana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan, Jesúsbioye tbojaniyana: —Buatëmbayá, bënga fsënjinÿe canÿe boyabása, y cha aca jóts̈ëmbonëse, bacna bayëjbe juabna ents̈ángbents̈ana endëtëbuacana; pero cha bë́ngaftaca ndoñe quenátsmëna causa, chama fsënjesauyaná ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","As Jesús tbojanjuá: —Ndoñe s̈matjuauyaná; er ndocná quenátobena canÿe bëts soye jamana Bëngbe Bëtsabe obenánaca, ats̈e jóts̈ëmbonëse, y chents̈ana ats̈be contra jatóyebuambnayana. ");
INSERT INTO kbh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndegombre, nda ndoñe bëngbe contra tontsemná, bë́ngaftaca jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y ndánaca, masque nÿe búyeshtema ts̈ëngaftanga tcmojubuats̈atá, ts̈ëngaftanga áts̈benga bétsemnayeca, chábioye Bëngbe Bëtsá canÿe uacanana soye bochántats̈etaye, cha chë ts̈abe soye tojamama ca. ");
INSERT INTO kbh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Chents̈ana Jesús tojánayana: “Canÿa áts̈beñe os̈buachiyábioye mo quem basetemcá, nda tbojaingñé ats̈e ustonama chaotsajbanama, más ts̈abá chabiama nántsemna canÿe bëts nantsnëbé chamotsetamos̈ë́nts̈bua y mar béjayoye asentoye chamotsashbuets̈e chabotsenatjëmbama. ");
INSERT INTO kbh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nderado acbe cucuáts̈eca bacna soye tcojama, más ts̈abá nántsemna chë cucuats̈e chacotsenacuéstjango. Acbiama más ts̈abá endmëna celoye jamashënguana nÿetsca tescama vida jtsebomnama, nÿe canÿe cucuats̈e bomná, y ndoñe nÿets útats̈eca infiernoye chacmotocá jama, chë ndocna te yochanjáfsana íñeshoye; ");
INSERT INTO kbh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","choca úts̈enënga puerte nÿetsca tescama mochanjasúfria. Chë́ngbioye mochtsasaye mamanga ndocna te quemochatóbana, y chë íñeshe ndocna te queochátsfsana. ");
INSERT INTO kbh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Nderado acbe shecuáts̈eca bacna soye tcojama, acbiama más ts̈abá nántsemna chë shecuats̈e chacotsenashecuástjango. Acbiama más ts̈abá endmëna cosheto celoye jamashënguana nÿetsca tescama vida jtsebomnama, y ndoñe nÿets útats̈eca infiernoye chacmotsë́ts̈ena; ");
INSERT INTO kbh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","choca úts̈enënga puerte nÿetsca tescama mochanjasúfria. Chë́ngbioye mochtsasaye mamanga ndocna te quemochatóbana, y chë íñeshe ndocna te queochátsfsana. ");
INSERT INTO kbh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nderado acbe bomínÿeca bacna soye tcojinÿe y cachca soye tcojama, más ts̈abá nántsemna chë bominÿe chacotsenobuchjátsëca. Acbiama más ts̈abá endmëna Bëngbe Bëtsabe amë́ndayoye jamashënguana nÿe canÿe bominÿe bomná, y ndoñe nÿets útabeca infiernoye chacmotsë́ts̈ena; ");
INSERT INTO kbh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","choca úts̈enënga puerte nÿetsca tescama mochanjasúfria. Chë́ngbioye mochtsasaye mamanga ndocna te quemochatóbana, y chë íñeshe ndocna te queochátsfsana. ");
INSERT INTO kbh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tamó ts̈abe soye endmëna. Nts̈amo chë tamó canÿe ts̈abe soye endmëncá, Bëngbe Bëtsá echanjama nÿetsca ts̈ëngaftangbiama ts̈ábenga chas̈motsemnama, chë áts̈beñe betsos̈buáchema s̈mojtsepadecena ora s̈mojauantase. ");
INSERT INTO kbh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tamó ts̈abe soye endmëna. Pero chë tamó fténana tojtsóbemëse, ndoñe ques̈mátobena jamana cachiñe chabe tempsca sanana chaotsatsbomnama, ni saná jatamuama. Mo ts̈abe tamocá ents̈angbiama s̈mochtsemna, chë́ngbeñe jtsiyenëse nts̈amo Bëngbe Bëtsá yobos̈cá, y nÿetscángaftaca natjë́mbana s̈mochtsiyena ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chents̈ana, Jesús chë luarents̈ana tojë́ftsanbocna y tojána Judea luaroye y Jordán chenguana. Ents̈anga cachiñe chábioye tmojánabo, y cha chënga yojtsabuátambaye, chë nts̈amo jamana yojanamancá. ");
INSERT INTO kbh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Básefta fariseunga chábioye tmojanobeconá, y jisháchichiyama mënts̈á imojtsetjanaye: —¿Queojtselesenciana canÿe boyá chabe shémbioye cachcá jesonÿayama ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chora cha tojanë́jua: —¿Nts̈amo Moisés chë soyëngama tcmënjanamë́ndaye ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y chënga tmojánayana: —Moisés tojanalesenciá chë boyá chabe shémbioye chabuiyé canÿe tsbuanácha, ndayë́chañe chaotsayana cha ya ndoñe chabe shema yontsemna ca, y chora cachcá chabe shema chabuesonÿá ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Chora Jesús tojanë́yana: —Ts̈ëngaftanga Bëngbe Bëtsabe mandënga ainaniñe jóyëngacñama ndoñe ques̈mátsbos̈e causa, Moisés chca ts̈ëngaftanga tcmojëftsanamëndá. ");
INSERT INTO kbh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero quem luare jobojáts̈ama orna, “Bëngbe Bëtsá canÿe boyabása y canÿe shembása tonjánabiama. ");
INSERT INTO kbh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chíyeca, chë boyabása chabe taitá y chabe mamá echanjésabashejuana, chabe shémaftaca jenútanama, ");
INSERT INTO kbh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y chë útatna mo canÿacá bochántsemna.” Y chca, ya ndoñe útata quebochátsmëna, sinó nÿe mo canÿacá. ");
INSERT INTO kbh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chcasna, ents̈á ndoñe chaondë́ndbema ndayá Bëngbe Bëtsá mo canÿiñcá tojë́ftsema soye ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ya cach yebnoca imojtsatsmëna ora, chabe uatsjéndayënga cach soyama imojtë́tstjaye. ");
INSERT INTO kbh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y Jesús tojanë́yana: “Nda chabe shémbioye cachcá tbojesonÿá y ínÿaftaca tojtóbouamase, cha chë natsana shémbioye inÿe shembásaftaca jtseíngñayana; chana canÿe uabuatmá jtsebomnana. ");
INSERT INTO kbh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y chë shema chabe boyábioye cachcá tbojesonÿá, y ínÿaftaca tojtóbouamase, chánaca chë natsana boyábioye ínÿaftaca jtseíngñayana; canÿe uabuatmá jtsebomnana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ents̈anga, basetémënga Jesúsbioye tmojanënatse, chauabájajuama y Bëngbe Bëtsábioye chëngbiama chaboimpadama; pero chabe uatsjéndayëngna tmojanonts̈é chë basetémënga unachayënga jtsëcácanana. ");
INSERT INTO kbh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús chca tojáninÿe ora, tbojánetna y chë uatsjéndayënga tojanë́yana: “Cachcá mónÿaye chë basetémënga áts̈bioye chamuabo y ndoñe matë́uyanana; er Bëngbe Bëtsabe amë́ndayana endmëna chë mo quem basetemëngcá imomnëngbiama. ");
INSERT INTO kbh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndegombre cbë́yana, nda Bëngbe Bëtsabe soyënga ndoñe tonjóyëngacñe mo canÿe basetemcá jtsos̈buáchiyëse, cha ndoñe queochatobenaye Bëngbe Bëtsabe amë́ndayoye jamashënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y chë basetémënga tojanchebá, y chë́ngbeñe cucuats̈ënga jajájuase, Bëngbe Bëtsábioye tbojanimpadá ts̈abe bendicionënga chë́ngbeñe chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús jama tojtëtanonts̈é ora, canÿe boyabása chábioye tojanótjajo, chabe shecuats̈ents̈e tojanoshëntsaments̈é, y mënts̈á tbojantjá: —Ts̈abe Buatëmbayá, ¿ndayá s̈ojtsemna jamana chë nÿetsca tescama yomna ts̈abe vida jtsebomnama ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y Jesús tbojanjuá: —¿Ndáyeca “ts̈abia ca” s̈cjauyana? Ts̈abia nÿe canÿa endmëna: Bëngbe Bëtsá. ");
INSERT INTO kbh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aca icotáts̈ëmbo Bëngbe Bëtsá tojanmandacá: “Ndoñe catjóba, acbe shema ínÿaftaca ndoñe cattseíngñaye, ndoñe catjatbëba, ndoñe catjuaboínÿena, ínÿengbioye ndoñe catjáingñaye ndayánaca jabacama, y acbe bëtsë́tsata ndoñe stëts̈oye catjáquedaye ca.” ");
INSERT INTO kbh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chora chë boyabása tbojanjuá: —Buatëmbayá, ats̈e lempe chë mandënga básetema orscana sëndocumplina ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús bonshanánaca tbojanonÿinÿé y mënts̈á tbojaniyana: —Canÿe soye cmontsebuáshbena jamana: Motsa, lempe nts̈amo icobomncá cochjetsatobuiye, y chë crocénana, ndbomnëjémënga cochtsats̈ataye; chca, celoca canÿe bëts bomnana cochántsebomna. Chents̈ana, cochjabo y s̈cochjuasto ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero chë bobóntsbioye inÿets̈á ibojtsínÿnana Jesús chca tbojaniyanama; y puerte ngménaca yojtá, cha puerte bomná inamna causa. ");
INSERT INTO kbh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chora Jesús cátoye tojanrrepará y chabe uatsjéndayënga tojanë́yana: —¡Puerte totcá entsemna bomnëngbiama Bëngbe Bëtsabe amë́ndayoye jamashënguama ca! ");
INSERT INTO kbh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chca imojouena ora, chë uatsjéndayënga ojnanánënga imojtsemna, pero Jesús cachiñe tojanoyebuambá y mënts̈á tojanë́yana: —Ats̈be básenga; ¡puerte totcá entsemna Bëngbe Bëtsabe amë́ndayoye jamashënguama! ");
INSERT INTO kbh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ndegombre, más paselo endmëna chë coshufjents̈a atëfjnëjana canÿe camello chauachnëngo, y ndoñe canÿe bomná Bëngbe Bëtsabe amë́ndayoye jamashënguana ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero chë uatsjéndayënga nÿe más imojtsenjnanaye y imojtsentjanaye: —¿As, nda yochjobenaye atsbocaná jtsemnana ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chora Jesús tojanënÿanÿé y tojanë́yana: —Ents̈anga ndoñe quemátobena jamana canÿa atsbocaná chaotsemnama, pero Bëngbe Bëtsá aíñe; er Bëngbe Bëtsá lempe jamama endobena ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chora Pedro tbojaniyana: —Aca contsonÿá, bënga lempe chë fsë́ndbomna soyënga fsënjéseboshjona y ácaftaca fsëntsajna ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","As Jesús tojánayana: —Ndegombre cbë́yana, ndánaca áts̈bioye jasérviama y chë ts̈abe noticiënga jábuayenama, tojéseboshjona chabe yebna, cats̈átanga o uabénanga, bebmá o befta, o básenga, o fshantsënga, ");
INSERT INTO kbh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cha mora quem luarents̈e echanjóyëngacñe chama patse soye más yebnënga, cats̈átanga, uabénanga, bebmanga, básenga y fshantsënga, masque puerte chaosufrima ínÿenga mochántsama; y chë inÿe luarocna, chë nÿetsca tescama yomna ts̈abe vida echanjónÿena. ");
INSERT INTO kbh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero banga, mora uámanënga imomnënga, nduámanënga mochántsemna; y banga, mora nduámanënga imomnëngna, uámanënga mochántsemna ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chents̈ana Jerusalenoye imojtsaye, y Jesús yojtsebnatsana. Chë uatsjéndayënga puerte ojnanánënga imojtsemna, Jesús ndauatjcá choye yojtsayama; y inÿe becá ents̈anga ústonoye imojtsajnëngna, imojtsayáuatja. Jesús cachiñe chabe bnë́tsana uta uatsjéndayënga barie tojánachembo y tojanonts̈é jáuyanana nts̈amo cháftaca jopásama yojtsemnana. ");
INSERT INTO kbh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mënts̈á tojanë́yana: “Ts̈ëngaftanga s̈montsonÿá, Jerusalenoye bënga mora montsajnama. Chocna, chë Bëngbe Bëtsá Ents̈á tbojanbemá, chë bachnangbe amë́ndayënga y ley abuátambayëngbe cucuats̈iñe mochanjáboshjona, y chënga mochanjayana cha chaóbana ca; y ndoñe judiëngbe cucuats̈iñe mochanjáboshjona. ");
INSERT INTO kbh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chënga mochantsáboyejuana, mochántsebuashëtotjo, mochántsetjanja y mochanjóba, pero chents̈ana unga tianoye cha echántayena ca.” ");
INSERT INTO kbh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Chora, Santiago y Juan, Zebedeobe uaquiñata, Jesúsbioye tbojanobeconá y tmojaniyana: —Buatëmbayá, bëndata fsë́ntsebos̈e pavor chas̈cuabiamama nts̈amo chacbojaimpadacá ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y Jesús tojanatjá: —¿Ndayá s̈ojtsebos̈e ats̈e tsëndatbiama chjamama ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y chata tbojaniyana: —Aca reycá chacojtsemánda ora, cochjaleséncia bëndata fchayobená jótbemana, canÿa acbe cats̈bioica y inÿa acbe uañicuayoica ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","As Jesús tojanë́jua: —Nts̈amo s̈montsotjanañama tsëndata ndoñe ques̈nátstats̈ëmbo. ¿Nts̈amo ats̈e chaitsesufrincá, tsëndátnaca cachcá jasúfriama tas̈atjobenaye? ¿Y ents̈anga puerte bacá chacmojtsëbuatsená ora, tas̈ochjauánta, nts̈amo ats̈e chjauantacá ca? ");
INSERT INTO kbh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y chata tbojaniyana: —Aíñe fchanjobenaye ca. Y Jesús tojanë́yana: —Ndegombre tsëndátnaca ats̈cá s̈ochanjasúfria, y ats̈be causa cmochántsamna bëtscá soyëngama jasúfriana. ");
INSERT INTO kbh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ats̈e ndoñe quetsátobena jamándana nda ats̈be cats̈bioica y ats̈be uañicuayoica chaótbemama. Chë útents̈e entsemna ndëmuanÿengbiama ats̈be Taitá tojaprontacá ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Chë inÿe bnë́tsana uatsjéndayënga chca tmojanuena ora, tmojanonts̈é Santiago y Juánoftaca jotjáyanana. ");
INSERT INTO kbh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesús nÿetsca uatsjéndayënga tojánachembo y tojanë́yana: “Ts̈ëngaftanga s̈mondë́tats̈ëmbo, quem luarents̈a amë́ndayënga lempe jtsemándayana, nÿa mo nduiñënga cuaftsemncá; y chë bëtsëtsa ents̈anga chëngbe obenánaca jtsemándayana, nts̈ámnaca jtsamëse, chë inÿe ents̈anga sempre chamotsayaunanama. ");
INSERT INTO kbh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ts̈ëngaftangbeñe ndoñe chca chaondë́tsemna. Inÿets̈á; masna, nda ts̈ëngaftangbeñe chë más uamaná jtsemnama tojtsebos̈e, cha bontsemna chë ínÿenga jtsaservénana; ");
INSERT INTO kbh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","y ndánaca ts̈ëngaftanguents̈á chë más uamaná jtsemnama tojtsebos̈á, bontsemna jtsemnana nÿetscangbiama, mo nÿe ínÿabiama nÿets tempo oservenacá. ");
INSERT INTO kbh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cachcá, Bëngbe Bëtsá Ents̈á tbojanbemá ndoñe chenátabo cha chamotseservénama, ndayá ínÿenga jabáserviama. Y mo nda, ínÿenga játsebacama cuafjopagacá, cha echanjóbana ba ents̈anga atsebácanënga chamotsemnama ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chents̈ana, Jesús y chabe uatsjéndayënga Jericó uabaina puebloye tmojánashjajna. Y Jesús chabe uatsjéndayëngaftaca y bëtscá ents̈ángaftaca Jericó pueblents̈ana yojtsaisebocana ora, Timeobe uaquiñá, Bartimeo ca uabainá, canÿe jtaná lemos̈na otjanañá, benache juachañe yojtsetbemana. ");
INSERT INTO kbh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y Jesús Nazaretocá chëjana yojtsachnëjuanama cha yojátats̈ëmbona ora, tojanonts̈é mënts̈á uayebuáchana: —¡Jesús, Davídbents̈ana Ents̈á, s̈motselastemá ca! ");
INSERT INTO kbh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chorna, banga chë jtaná imojtsácacana iytëca chaóbemama. Pero cha más yojtsáyebuache: —¡Davídbents̈ana Ents̈á, s̈motselastemá ca! ");
INSERT INTO kbh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chora Jesús tojantsá y chë ínÿenga tojanë́yana: —Chë jtaná mochembo ca. As chë jtaná tmojanchembo, y mënts̈á tmojaniyana: —¡Añemo cochtsebomna; motsbaná! Jesús cmontsechembuana ca. ");
INSERT INTO kbh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y chë jtaná, quefsaíya jtsenátsejquëse, yojontsënja y betsco Jesúsbioye yojobeconá. ");
INSERT INTO kbh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chora, Jesús chë jtanábioye tbojantjá: —¿Ndayá cojtsebos̈e ats̈e acbiama chjamama ca? Y chë jtaná tbojanjuá: —¡Buatëmbayá, s̈molesenciá ats̈e chas̈uatabínÿnama ca! ");
INSERT INTO kbh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","As Jesús tbojaniyana: —Motsatoñe. Ts̈abá jtsatsmënama Bëngbe Bëtsábeñe icos̈buachéyeca, ts̈abá contsatsmëna ca. Y cachora cha ts̈abá ibojtabinÿna, y Jesúsbioye benachëjana ibojtsë́stona. ");
INSERT INTO kbh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ya Jerusalenoye imojtsebeconá ora, Betfagé y Betania pueblënga béconana, Olivos ca uabaina tjashe juachañe, Jesús uta chabe uatsjéndayata tojanichamó, ");
INSERT INTO kbh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","y mënts̈á tojanë́yana: “Tsëndatbe natsana entsemna base pueblotémoye motsata. Chas̈ojáshjango y cachora s̈ochanjínÿena canÿe burrotema utsbuaná; chábeñe cabá ndocná tonjenojayé. S̈ochjuajafjoná y s̈ochjuánatse. ");
INSERT INTO kbh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nderado nda, ¿ndáyeca s̈mojtsanachá ca? chacmojátjase, s̈ochjojuá: ‘Bëngbe Utabná bontsájaboto y chora bochantabáiseboshjona ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","As chata tbojána, y tbojáninÿena chë burrotema tsáshenañe, canÿe bës̈ás̈añe utsbuaná, y imojuajafjoná. ");
INSERT INTO kbh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Y básefta ents̈anga chiñe imojtsemnënga, chátbioye tmojanë́yana: “¿Ndayá s̈ojtsama? ¿Ndáyeca chë burrotema s̈ojtsajafjná ca?” ");
INSERT INTO kbh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","As chata tbojanjuá nts̈amo Jesús tojanëyancá; y chë ents̈anga tmojanalesenciá chë burrotema chamuánatsama. ");
INSERT INTO kbh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chents̈ana, chë burrotema Jesúsbioye tmojanánatse; chë burrotémbeñe chatbe ents̈ayá tbojanájatse, y Jesús chábeñe tojanenojayé. ");
INSERT INTO kbh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bëtscá ents̈anga chëngbe ents̈ayá chë benachëjana imojtsanëtë́tsatsana, y ínÿengna chë jajoca imojuatë́tsets̈e buacuashangá chiñe imojuacjaye. ");
INSERT INTO kbh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y chë natsana imojtsajnënga y chë ústonoyënga mënts̈á imojtsaiuáyebuache: “¡Bëngbe Bëtsá matschuanga! ¡Corente bendición bomná, chë Bëngbe Utabnabe obenánaca tojabá! ");
INSERT INTO kbh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ts̈a ts̈abá chë echanjóshjango amë́ndayana, bëngbe bëts taitá David yojëftsemánda orcá! ¡Bëngbe Bëtsá celocá matschuanga ca!” ");
INSERT INTO kbh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús Jerusalenoye tojánashjango, y Bëngbe Bëtsabe bëts yebnoye tojánamashëngo. Chabe shë́conana lempe yojëftserrepárase, y ya yojtseibétatana causa, chabe bnë́tsana uta uatsjéndayëngaftaca tojë́ftsanbocna, Betania puebloye. ");
INSERT INTO kbh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yëfsana, Betaniocana Jerusalenoye chënga imojtésajna ora, Jesús tbojánishëntsena. ");
INSERT INTO kbh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bënocana canÿe higo betiye yojinÿe; as tojána jontjes̈iyama tainashajo o ndoñe. Pero nÿe tsbuanáchënga chiñe yojínÿena, chora ndoñe shajo tempo bétsemna causa. ");
INSERT INTO kbh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","As Jesús chë higo betiyoye tojánayana: “¡Ndocna te más chacondëshájona ents̈anga chamosama ca!” Y chabe uatsjéndayënga imojouena nts̈amo cha tojanayancá. ");
INSERT INTO kbh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalenoye tmojánashjajnents̈ana, Jesús Bëngbe Bëtsabe bëts yebnoye tojánamashëngo, y tojanonts̈é chents̈ana jtëbuacnana chë chents̈e imojtsena y imojtsobuámnañënga. Chénts̈naca imojtsemna ents̈anga canÿe crocénana enënga, y chë crocénana nÿe Bëngbe Bëtsabe bëts yebnents̈ama inoservena. Chë ents̈anga crocénana atrocayëngbe mesëshangá tojtsanenásatajchquëca, y chë palomatémënga enëngbe ts̈enës̈ë́ngnaca; ");
INSERT INTO kbh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","y ndoñe tonjanalesenciá ndocná Bëngbe Bëtsabe bëts yebnëjana chë soyënga chaotsëchnëjuanama. ");
INSERT INTO kbh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Y tojanonts̈é ents̈anga mënts̈á jabuátambana: “Ndegombre, Bëngbe Bëtsabe uabemana palabrënguiñe cha mënts̈á tojánayana: ‘Ats̈be bëts yebna echantsabaina nÿetsca luarents̈a ents̈angbiama áts̈eftaca encuéntaye yebna ca’; pero ts̈ëngaftangna atbëbanëngbe oyeniñe chë yebna s̈mojtsebema ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chë bachnangbe más uámana amë́ndayënga y chë ley abuátambayënga tmojántats̈ëmbona nts̈amo yojochnënguama; as tmojanonts̈é enójuabnayana nts̈amo jobenayana cha jóbana, cha imojtsebiauatja causa, er nÿetsca ents̈anga imojtsenjnanaye nts̈amo cha yojanabuátambama. ");
INSERT INTO kbh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero yojtseibétatana ora, Jesús chabe uatsjéndayëngaftaca chë bëts pueblents̈ana yojesóbocñe. ");
INSERT INTO kbh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yëfsana cachëse, cachëjana imojtésachnëjuana ora, tmojáninÿe chë higo betiye parejo tbëtëjë́ngaca yojtsebuashá. ");
INSERT INTO kbh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chora Pedro yojenójuaboye nts̈amo yojopásama; as Jesúsbioye tbojaniyana: —¡Buatëmbayá, minÿe; chë tconjayana ndocna te más ts̈abe betiye chaotsemnama betiye tojtsebuashá ca! ");
INSERT INTO kbh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Y Jesús tbojaniyana: —Bëngbe Bëtsábeñe s̈mochtsos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndegombre cbë́yana, nderado nda quem tjoye tojayana, “¡chents̈ana mojuaná y bëts uafjajónayoye motsëshbuets̈e ca!” y chca tojayana ainaniñe inÿets̈á juabna ntjatsbomncá, y ainaniñe puerte tojtsos̈buaché nts̈amo tojayancá aíñe yochjochnënguama, ndegombre chca echanjochnëngo. ");
INSERT INTO kbh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chíyeca cbochanjáuyana, lempe nts̈amo Bëngbe Bëtsáftaca chas̈mojtsencuénta ora chas̈mojtsotjanañama, ainaniñe corente s̈mochtsejuabnaye ya s̈mojóyëngacñe ca, y ndegombre chca s̈mochántsebomna. ");
INSERT INTO kbh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y Bëngbe Bëtsáftaca chas̈mojtsencuénta ora, s̈mochjenójuaboye nderado nda ndaye bacna soye ts̈ëngaftangbiama tojamama, y cháftaca cabá etonánënga s̈mojtsemnëse, s̈mochtseperdóna; chca, Bëngbe Bëtsá, celoca endmëná, ts̈ëngaftangbe bacna soyëngama chacmotsaperdonama. ");
INSERT INTO kbh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero inÿa ndoñe s̈monjaperdonasna, Bëngbe Taitá, celoca endmëná, cach ndoñe ts̈ëngaftanga quecmochátaperdonaye ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chca tojanopasá chents̈ana, Jerusalenoye chënga tmojesaná. Jesús Bëngbe Bëtsabe bëts yebnëjana yojtsobuertanëntscuana, chábioye tmojanobeconá bachnangbe amë́ndayënga, ley abuátambayënga y chë judië́ngbeñe bëtsëjemëngcá amë́ndayënga, ");
INSERT INTO kbh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","y mënts̈á tmojantjá: —¿Ndaye deréchoca chë contsama soyënga aca cojtsama ca? ¿Chca jtsamama nda obenana tcmënjats̈etá ca? ");
INSERT INTO kbh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","As Jesús tojanë́yana: —Ats̈naca së́ntsebomna canÿe soye ts̈ëngaftanga jatjayama. Chas̈mojojuase, áts̈naca cbochjáuyana ndaye deréchoca ats̈e chca stsama. ");
INSERT INTO kbh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nda Juan chë Ubayaná tbojanichmó ents̈anga jubáyama, Bëngbe Bëtsá o ents̈anga? S̈mëyana ca. ");
INSERT INTO kbh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chora chënga tmojanonts̈é mënts̈á enatsëtsnayana: “ ‘Bëngbe Bëtsá ca’ chamojojuase, cha s̈ochanjáuyana: ‘As ¿ndáyeca chë cha tcmojanabuayená soyënguiñe ndoñe s̈monjanos̈buaché ca?’ ");
INSERT INTO kbh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero ndoñe quemuátobena jayanana ‘ents̈anga ca’.” Chca tmojánayana, er chënga ents̈angbiama imojánauatja, er nÿetscanga imojanjuabná, Juan ndegombre Bëngbe Bëtsabe juabna oyebuambnayá yojamnama. ");
INSERT INTO kbh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chcasna, chënga tmojanjuá: —Bënga ndoñe queftsátstats̈ëmbo ca. Y Jesús tojanë́yana: —As ats̈e cach ndoñe quecbochatë́yana ndaye deréchoca ats̈e chca stsama ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chora Jesús tojanonts̈é cuentë́ngaca jabuátambana. Mënts̈á tojanë́yana: “Canÿe ents̈á bëtscá uvas betiyënga yojáje, y chë shë́conana yojajétja. Chë uvasës̈angá juants̈ë́tetjiamna canÿe base luare yojajutjo; y canÿe tsbanana jebna soye yojapórma chiñe jtsashanÿama. Chents̈ana, inÿe trabájayënga chë jajañe yojúyents̈ame, y chana inÿe luaroye yojtsoñe. ");
INSERT INTO kbh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chë uvasës̈angá juashacama tempo yojobuache orna, chë jajañe nduiño canÿe oservená ibojíchmua chë arréndayënga jáuyanama ntsachets̈á chë nduiño ibojtsotocánama. ");
INSERT INTO kbh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero chëngna, cha imojishache, imojtsejants̈etaye, y tondaye ntajatacá imojtichmuá. ");
INSERT INTO kbh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Chents̈ana, chë nduiño inÿe oservená ibojíchmua; pero chana, bests̈as̈e imojtselísia y podesca imojtsóyenguango. ");
INSERT INTO kbh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Chents̈ana inÿa ibojatichmuá, y chana chë arréndayënga imojtsóba. Y bángnaca yojichamuá; pero chëngna, ínÿengna imojtsajants̈etaye y ínÿengna imojtsëbaye. ");
INSERT INTO kbh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Chë nduiño cabá canÿa ibojtsábojamna jíchmuama: cachabe bonshana uaquiñá. Cabana, cha ibojíchmua y mënts̈á yojtsejuabnaye: ‘Ats̈be uaquiñá cocayé mochanjóyeunaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero chë arréndayënga cha imojinÿe ora, imojeniyana: ‘Mua chë fshantse nduiñbe uaquiñá entsemna. Lempe chabe soyënga mua echanjóyëngacñe. Cuajna, motsóbanga, y lempe chabe otocana soyënga bëngbiama echanjoquéda ca.’ ");
INSERT INTO kbh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chcasna, cha imojishache, imojtsóba y chë uvas betiyënga jajañents̈ana más chcoye imojetsë́ts̈ena ca” —Jesús tojancuentá. ");
INSERT INTO kbh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús chca jacuéntama tojanpochocá ora, tojánayana: “Y asna, ¿ndayá chë fshantse nduiño yochjama ca? Cha co echanjá y chë trabájayënga echanjetsëbaye, y inÿe trabájayënga chë uvas betiyënga jajañe echanjárrendaye. ");
INSERT INTO kbh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Ts̈ëngaftanga ndocna te Bëngbe Bëtsabe uabemana palabra s̈mëndualía? Chiñe mënts̈á endayana: Chë yebna jebuanënga tmojtsanaboté ndëts̈bé, mora chë más bëts uashacuanës̈ents̈e entsejájona. ");
INSERT INTO kbh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chë soye Bëngbe Utabná, Bëngbe Bëtsá chca tojama, y bënga chama ojnanánënga fsë́ntsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chora, chë bachnangbe amë́ndayënga y chë bëtsëjemëngcá mándayënga tmojánbos̈ena Jesús jishachana, er chënga tmojanenótats̈ëmbona cha chca tojancuentá jinÿanÿiyama chënga mo chë puerte bacna trabajayëngcá imojanmënama. Pero ents̈angbiama imojtsauatja, chíyeca cachcá tmojanonÿá y chents̈ana imojtsóñenga. ");
INSERT INTO kbh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chents̈ana chënga, básefta fariseunga y Heródesbe ústonënga Jesúsbioye tmojanichamó, ndayá cha tojayaniñe jisháchichiyama, as chca jtsebomnama ndaye sóyeca mandadë́ngbeñe cha mal jaquédana. ");
INSERT INTO kbh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chënga tmojána y Jesús tmojaniyana: —Buatëmbayá, bënga fsëndë́tats̈ëmbo aca ndegombre soyënga cnetsabuátambama, y ndoñe jatuenanana nÿe nts̈amo ents̈anga tmojatichamcá, er acbiama tondaye quenatámana nda más uamaná o nduamaná tomnana; y contsabuatambá ndegombre ts̈abe vida jtsebomnama, nts̈amo Bëngbe Bëtsá yomandacá. Chcasna, ¿ts̈abá tanántsemana, César, chë Romoca bëts mandadbiama bënga impuesto jtsatsquë́cjnayana? ¿Fchtsatsquëcjnaye o ndoñe ca? —chënga tmojantjá. ");
INSERT INTO kbh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús yojtsetáts̈ëmbo, chënga bacna ents̈anga nts̈amo ndegombre tmojuabnacá ndinÿinÿnayënga imojamnama; chíyeca tojanë́yana: —¿Ndáyeca ts̈ëngaftanga s̈mojtsebos̈e chë sóyeca ats̈e jisháchichiyama? Canÿe denario crocénana s̈miyëboñe, ats̈e chayobená jinÿama ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","As canÿe crocénana tmojanoyé y Jesús tojanë́yana: —¿Ndabe jubiá quem crocenániñe yojtsemna, y nts̈amo muents̈e entsabemancá nda chca iuabaina ca? Y chënga tmojanjuá: —Césarbe jubiá; cha chca enduabaina ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chora Jesús tojanë́yana: —Chcasna, César s̈mochtoyiye cha ibotocana soye; y Bëngbe Bëtsana cha ibotocana soye ca. Y nÿetscanga chama imojenjnaná. ");
INSERT INTO kbh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chents̈ana, báseftanga saduceo ca uabaina ents̈anga tmojána Jesús jinÿama. Chënga imojanjuabná obanënga ndocna te ntayenana ca. Chíyeca, Jesús mënts̈á tmojaniyana: ");
INSERT INTO kbh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Buatëmbayá, Moisés tojë́ftsanabema, nderado canÿe boyá tojóbana y básenga ndoñe tonjëftsabáshejuanësna, canmëna chë uabentsá chë shémaftaca jtobouamayana, chca, chabe uabochená obanabiama básenga jtsabamnama ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y chcase, canÿe, canÿsëfta cats̈átanga monjamna. Chë natsaná tonjanobouamá y tontsanóbana básenga ntjëftsabashejuancá. ");
INSERT INTO kbh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chents̈ana, chë ústona uabentsá chë shémaftaca tonjanobouamá, pero chana tontsanóbana, básenga ntjëftsabashejuancá; chë inÿe uabentsáftaca cachcá tonjanopasá. ");
INSERT INTO kbh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chca, nÿetsca canÿsëfta cats̈átangaftaca cha tonjanobouamá, pero ndocná básenga ntjëftsabáshejuanana. Y chents̈ana chë shembásanaca tontsanóbana. ");
INSERT INTO kbh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y morna, chë obanënga chamojtayena ora, ¿ndabe chë canÿsëfta cats̈atanguents̈abe shema chë shembása yochtsemna, nÿetscanga cháftaca tmojanobouamase ca? —chënga tmojantjá. ");
INSERT INTO kbh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","As Jesús tojanë́yana: —Nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá ndoñe tcmonjosertá, ni Bëngbe Bëtsabe obenanama. Chíyeca nts̈amo ndoñe yondmëncá s̈montsichamo. ");
INSERT INTO kbh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Er obanënga chamojtayena ora, ni boyabásenga ni shembásenga quemochatóbouamnaye, y chca, chënga mochántsemna mo celoca angelotemëngcá. ");
INSERT INTO kbh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Y chë obanënga jtayenama, ¿Moisesbe librë́s̈añe ndoñe s̈mëndualía nts̈amo Bëngbe Bëtsá tbojaniyanama, chë betiyetema yojtsángbototjuana ora? Bëngbe Bëtsá mënts̈á tbojaniyana: “Ats̈e sëndmëna Abraham, Isaac y Jacobëbe Bëtsá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bëngbe Bëtsá chca tojánayana ora, entsichamo cha ndoñe yondmëna obanëngbe Bëtsá, sinó aina ents̈angbe Bëtsá ca, er masque chënga tmojanóbana, chënga cabá Bëngbe Bëtsáftaca mondoyena. Ts̈ëngaftanga canÿe ndoñe ndegombre soyiñe s̈montsemna ca —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chents̈e yojtsemna canÿe ley abuatambayá. Cha yojouena nts̈amo Jesús y chënga imojtsenatsëtsnayana, y yojtsetáts̈ëmbo Jesús ts̈abá tojanë́juama. As, tojanobeconá y Jesúsbioye tbojantjá: —¿Ndayá chë más bëts uámana mando yomna ca? ");
INSERT INTO kbh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y Jesús tbojanjuá: —Chë más uámana mando mënts̈á endmëna: “Israeloquënga s̈mochjouena, Utabná, Bëngbe Bëtsá endmëna, y nÿe canÿe Bëngbe Utabná endmëna, ndocná más. ");
INSERT INTO kbh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Utabná Bëngbe Bëtsá cochtsebobonshana nÿets acbe ainánaca, nÿets espíritoca, nÿets juábnaca y nÿets añémoca.” ");
INSERT INTO kbh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y chents̈ana quem inÿe mándnaca: “Ndëmua ents̈ánaca cochtsebobonshana, nts̈amo cach aca cuenobobonshancá.” Ndocna mando quem uta mandama más quenatámana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chora, chë ley abuatambayá Jesúsbioye tbojaniyana: —Buatëmbayá, puerte ts̈abá tcjayana. Ndegombre yomncá contsichamo, nÿe canÿe Utabná endmëna y ndocná más. ");
INSERT INTO kbh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y cha jtsebobonshánana nÿets ainánaca, juábnaca y añémoca, y ndëmua ents̈ánaca jtsebobonshánana cachá cuenobobonshancá, puerte cuámana. Cach nÿets̈á ndoñe quenatámana bayënga jtsëbánayana, ni chë uáts̈ëmbona soyënga Bëngbe Bëtsá jëtschuayama ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cha nÿets juábnaca tbojanjuama Jesús tojáninÿe ora, tbojaniyana: —Bats̈atema cmontsebuáshbena jtseprontánama, Bëngbe Bëtsá chacolesenciama acbe ainanents̈e jtsemándayama ca. Y chents̈ana, ya ndocná yonjenñémua Jesús más jatstjanayama. ");
INSERT INTO kbh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Bëngbe Bëtsabe bëts yebnents̈e yojtsabuátambaye ora, tojánayana: “¿Ndáyeca chë ley abuátambayënga mondbétsichamo chë Uámana Uabuayaná Davídbents̈ana iuabó ca? ");
INSERT INTO kbh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cach David, chë Uámana Espíritbe mándoca mënts̈á tojánayana: Bëngbe Bëtsá, ats̈be Utabná Crístbioye tbonjaniyana: ats̈be cats̈bioica mótbema, ats̈be obenánaca, acbe uayayënga acbe cucuats̈iñe chamoquedama chjamëntscuana ca. ");
INSERT INTO kbh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nts̈ámose Cristo Davídbents̈ana Ents̈á nántsemna, cach David ‘Utabná ca’ chábioye tbojtsabobuátmëse ca?” —cha tojanë́yana. Y chë bëtscá ents̈anga, oyejuayënga imojtsuenana. ");
INSERT INTO kbh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mënts̈ánaca Jesús chënga yojtsabuátambaye: “Cuedado s̈mochtsebomna y ndoñe s̈mattsama chë ley abuatambayëngcá. Chënga jtsogusetánana bënëna ents̈ayangaca jtsajnana y jtsebos̈ana tsáshenañe ents̈anga nÿa respétoca chamotsacheuanama. ");
INSERT INTO kbh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chë judiëngbe enefjuana yebnënguenache, chë más uámana luarënguiñe jtsetbiámanana, y chë fiestënguenache nÿa quëfseroca. ");
INSERT INTO kbh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pero chënga, viudángbioye chë tmobomna soyënga jtsabacayana, y ents̈angbe delante ts̈abá chamotsë́nÿama, y chë́ngbioye imojtsaíngñama ndoñe chaondëtsótats̈ëmbuamna, Bëngbe Bëtsáftaca ts̈a jtsencuéntayana. Chë causa, Bëngbe Bëtsá ínÿengbiama más chënga echanjácastigaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús jabuátambama tojanpochocá ora, tojanótbema Bëngbe Bëtsabe bëts yebnents̈e, chë crocénana quëcjnayëtema ndirichiñe; y chë crocénana quëcjnayënga yojtsë́nÿaye. Bëtscá bomnëngna becá crocénana imojtsequëcjnaye. ");
INSERT INTO kbh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chora, canÿe viudá ndbomnëjémnaca yojobeconá y nÿe uta crocénana chëtémiñe yojaftsesegóra. ");
INSERT INTO kbh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chora Jesús chabe uatsjéndayënga tojánachembo chamobéconama, y mënts̈á tojanë́yana: “Ndegombre cbë́yana, quem viudá ndbomnëjema, Bëngbe Bëtsabiama nÿetscangbiama más tonjëftsesegorá. ");
INSERT INTO kbh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chë bomnëngna chë yojtsóyents̈jaments̈ana tmonjëftsesegorá, y cabá bomnana imotsóbomñe; y chë viudana tonjëftsesegorá lempe ntsachets̈á yobomncá; masque ts̈a ndbomnëjema, chë vida jtsebomnama lempe ntsachets̈á yobomncá tonjëftsesegorá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Bëngbe Bëtsabe bëts yebnents̈ana tojë́ftsanbocna ora, canÿe chabe uatsjendayá tbojaniyana: —Buatëmbayá, minÿe, ¡ts̈a bëts ndëts̈benga, y ts̈a botamana bëts yebnënga ca! ");
INSERT INTO kbh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Chora Jesús tbojaniyana: —Ts̈abá cochjinÿe ts̈a botamana bëts yebnënga. Pero muents̈e ndoñe queochaisoquéda ni mo canÿe ndëts̈bé inÿebé juatsboye. Lempe mochantsepochóca ca. ");
INSERT INTO kbh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chents̈ana, Olivos tjashoye chënga tmojána. Bëngbe Bëtsabe bëts yebnents̈a ndirichiñe yojamna; y Jesús tojanótbema ora, Pedro, Santiago, Juan y Andrés iytëcana tmojantjá, ");
INSERT INTO kbh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","nts̈amo cha tojanayancá ntseco yochjanopásama, y chca jopásama ya tojtsobecuama ents̈anga chamotsetats̈ëmbuama, ndayá Bëngbe Bëtsá yochjanma ca. ");
INSERT INTO kbh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chora Jesús tojanë́jua: “Cuedado s̈mochtsebomna ndocná chacmondáingñema. ");
INSERT INTO kbh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Banga mochanjabo y mochantsabíchamo chënga Jesús imomna ca. Mochántsichamo: ‘Ats̈e chë Cristo sëndmëna ca’, y chca, ba ents̈anga mochanjáingñaye. ");
INSERT INTO kbh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Ents̈anga tmojtsentsjanama y nderado mochjentsjámnaca ts̈ëngaftanga chas̈mojouena ora, ndoñe s̈mattsauatja; er chca chaochnënguama entsemna, pero masque chca, chora chë quem luare jopochócama tempo cabá ndoñe queochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Canÿe luarents̈a ents̈anga inÿe luaroca ents̈ángaftaca mochántsentsjanaye, y canÿe amëndayábents̈a ents̈anga inÿe amëndayábioca ents̈angaftácnaca; ba luarënguenache fshantse echanjuangmë́mana y bëts shëntsana echanjóshjango. Masque chca jasúfriase, más chcoye cabá más mochanjatssúfria. ");
INSERT INTO kbh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pero ts̈ëngaftangna cach ts̈ëngaftangbiama s̈mochtsantjes̈na; ents̈anga cmochanjíshëche y amë́ndayëngbe cucuats̈iñe cmochanjábashejuana, judiëngbe enefjuana yebnënguenache cmochanjátsets̈enaye. Ats̈be ústonënga bétsemna causa, mandadë́ngbioye y reyë́ngbioye cmochanjunatse, choca, chëngbe delante nts̈amo ats̈biama s̈motats̈ëmbcá chas̈muayanama. ");
INSERT INTO kbh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Er entseyta, quem luare cabá ndopochóca ora, Bëngbe Bëtsabe ts̈abe noticiënga nÿetsca luarënguents̈a ents̈ángbioye chaóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y ínÿengbe cucuats̈iñe jabáshejuanama chacmojtsënachá ora, ndoñe s̈mattsenócochinÿena nts̈amo chora s̈mochjayanama. Chora s̈mochjayana nts̈amo Bëngbe Bëtsá yochjamcá ts̈ëngaftanga chas̈muayanama, er ts̈ëngaftanga cánÿenga ndoñe chora ques̈mochátoyebuambnaye, ndayá chë Uámana Espíritu ts̈ëngaftangbiajana echantsóyebuambnaye. ");
INSERT INTO kbh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Canÿe cats̈ata cachabe cats̈ata ínÿengbe cucuats̈iñe bochanjáboshjona chamotsóbama, y bëtsë́tsanga cachëngbe básenga mochanjábashejuana chamotsëbáyama; y chë básengna chëngbe bëtsë́tsangbe contra mochántsemna y chamotsëbáyama mochanjábashejuana. ");
INSERT INTO kbh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ats̈be ústonënga bétsemna causa, nÿetsca luarënguents̈a ents̈anga cmochantsë́buayënja; pero nda nÿets tempo áts̈beñe os̈buachiyá totsomñe, atsbocaná echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Chë Bëngbe Bëtsabe juabna oyebuambnayá Daniel, chë puerte uabouana soye quem luare jopochócama tojë́ftsanabema. Chë puerte uabouana soye, chca jtsemnama ínÿoca ts̈ëngaftanga chas̈mojinÿe ora (nda tojtsalía, chabosertá), s̈mochántsetats̈ëmbo chë puerte ngménana tempo tojóshjanguama; chorna, chë Judeoca chamojtsemna ents̈anga, batsjabengoye chamotsacheta; ");
INSERT INTO kbh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","chama, nda cachabe yebnents̈a tsbanánoca chaojtsemna, chocana ndoñe chaondë́tastjango, ni chaondë́tamashëngo tsoicana ndayá jesábocnama; ");
INSERT INTO kbh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","y nda jajoca chaojtsemna, yebnoye ndoñe chaondë́ta ni mo chabe quëfsaíya jesácñama. ");
INSERT INTO kbh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ts̈a lastema chë tempo ngomámanënga o ochóchaye s̈es̈onga chamojtsabamna shembásengbiama! ");
INSERT INTO kbh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bëngbe Bëtsá s̈mochtseimpadana chë ngménana tempo ndoñe chaondóshjango uaftena tempo ora, ");
INSERT INTO kbh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","er chora puerte ngmenancá echántsemna. Ts̈a jabuache ngmenancá, quem luare jobojáts̈ama orscana y më́ntscoñama y más chcoye, cachcá ngménana ndoñe ntjamnana. ");
INSERT INTO kbh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Chë puerte ngménana tempo, yapa bën ndoñe chaondë́tsemnama Bëngbe Bëtsá ndoñe tonjalesenciase, ndocná quentatsbocá; pero cha, chabe ubuáyanënga, chabe bocacánënga corente endábabuanÿeshanayeca, echanjama yapa bën tempo ndoñe chaondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Chora nderado nda chacmojáuyana: ‘Minÿe, muents̈e chë Cristo entsemna’, o ‘Choca cha entsemna ca’, chë soyëngama ndoñe s̈mattsayaunana. ");
INSERT INTO kbh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Er mochanjábocana ndoñe ndegombre uámana ubuáyanënga, chënga Cristo imomna ca jtsichámëse, y Bëngbe Bëtsabe ndoñe ndegombre juabna oyebuambnayë́ngnaca; y chënga mochanjama bëts soyënga chëngbe obenana jinÿanÿiyama, ents̈anga jáingñama, y tmojobenase, chë Bëngbe Bëtsabe bocacánëngnaca. ");
INSERT INTO kbh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Cuedado s̈mochtsebomna! Cabá chca ndochnëngo ora, lempe tcbonjabuayená ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mënts̈ánaca Jesús tojanë́yana: “Pero chë tempo, ents̈anga puerte chamojasufrí chents̈ana, shinÿe ndoñe queochátsbuashinÿinÿana, juashcona ndoñe queochátsbinÿnaye, ");
INSERT INTO kbh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","celocana estrellënga echanjatquë́cjana, y quem luarents̈a tsbanánoca espíritënga obenana bomnënga echanjángmëmana. ");
INSERT INTO kbh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Y chora, ents̈anga mochanjinÿe, Bëngbe Bëtsá Ents̈á tbojanbemá jants̈etëshiñe echántsaboye, corente obenánaca y corente buashinÿinÿaniñe. ");
INSERT INTO kbh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chora cha chabe angelënga echanjámëndaye chë Bëngbe Bëtsabe ubuáyanënga júbuajama, nÿets luarëngocana, quem fshantsoca cánÿoica juachoicana, celoca ínÿoica juachóntscoñe. ");
INSERT INTO kbh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Chë higo betiyama s̈mochjuatsjinÿe: Tsëm buacuafjënga tojtsebomna ora y tojtsaisë́jotsana, jtsotats̈ëmbuana chë ts̈abe tempo ya tojtsaisobecuama. ");
INSERT INTO kbh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Cachcá, chë soyënga ndayama ts̈ëngaftanga tcbonjauyancá chas̈mojinÿe ora, s̈mochántsetats̈ëmbo Bëngbe Bëtsá Ents̈á tbojanbemá ya jésabama yojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ndegombre cbë́yana, lempe chca echanjochnëngo, morsca ents̈anga cabá ndóbana ora. ");
INSERT INTO kbh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Celoca y quem luare echanjopochóca, pero ats̈be palabra ndocna te queochaisopochóca. ");
INSERT INTO kbh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pero Bëngbe Bëtsá Ents̈á tbojanbemá ndayté y ntseco ora yochjésabama, ndocná quenátstats̈ëmbo, ni chë celoca angelënga, ni Bëngbe Bëtsabe Uaquiñá. Nÿe chë Taitá chama yotáts̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Chíyeca, cuedado s̈mochtsebomna y yejuana s̈mochtsantjes̈na, er ndoñe ques̈mátstats̈ëmbo mocna ora yochtsemna Bëngbe Bëtsá Ents̈á tbojanbemá jésabama tempo. ");
INSERT INTO kbh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Echántsemna mo canÿe ents̈acá; chana inÿe luaroye ya jëftsebocnama ora, chabe oservénënga jëftsamë́ndana chabe yebna chamotsinÿenama. Cada ona canÿe trabajo jëftsebónÿiyana, y chë shanÿá jëftsemándana botamana chaotsantjes̈nama. ");
INSERT INTO kbh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chcasna, cuedado s̈mochtsebomna, s̈mochtsantjes̈na, er nts̈amo chë trabajayëngcá chë yebna nduiño ntseco jtashjanguama, ndoñe ntsetats̈ëmbuana, mo nderado jétatana, tsë́ntseto ora, bínÿanoye o cachëse, ts̈ëngaftanga cachcá, Bëngbe Bëtsá Ents̈á tbojanbemá ntseco jésabama ndoñe ques̈mátstats̈ëmbo; ");
INSERT INTO kbh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ndoñe cuedado s̈montsebomnëse, nderado cha nÿe ndeolpe nántashjango, ts̈ëngaftanga ndëprontánënga s̈mojtsemna ora, mo ftsomañe cuenta. ");
INSERT INTO kbh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chíyeca, nts̈amo ts̈ëngaftanga cbochanjauyancá, nÿetscanga chanjáuyana: ¡Puerte cuedado s̈mochtsebomna ca!” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bashco fiestama uta te yojetsájamna, chë Bëngbe Bëtsá Egiptocana judiëngbe bëts taitanga tojánatsebacama jtenójuaboyama fiesta, chë levadúraca ndëpormana tandës̈e sayora. Chë judiëngbe bachnangbe amë́ndayënga y chë ley abuátambayënga imojtsenguaye nts̈amo Jesús jishachana jtseíngñase, y jtsóbama. ");
INSERT INTO kbh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Báseftanga imojtsichamo: “Quem fiestëntscuana ndoñe, er nderado ents̈anga yapa muanjónts̈a enbouenanana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betanioca yojtsemna, Simón chë bacna nguayanánaca s̈ocá ca uabobuatmabe yebnents̈e; mesë́shents̈e Jesús yojtsemna ora, canÿe shembása tojánashjango. Chë shembása yojúshjango canÿe alabastro jarrëtema jútjena canÿe becá uámana y botamana uanguëts̈e béjayeca, ena nardana uanguëts̈iye; chana chë jarrëtema yojátsba y chë béjaye Jesusbe bests̈as̈iñe tbojanbues̈cja. ");
INSERT INTO kbh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chca tmojáninÿe ora, báseftanga chents̈e imojtsemnënga tmojanotjayaná y mënts̈á imojtsenatsëtsnaye: —¿Ndáyeca nÿe bonamente chë soye yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chamna, matmënjobenanga chë béjaye unga patse denario crocenánama juiyana, y chánaca ndbomnëjémënga matmënjújabuache ca. Y chë shembásabiama podesca imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Chora Jesús tojanë́yana: —¿Ndáyeca quem shembása ndoñe cachcá s̈mochanjonÿaye ca? ¡Ndocá matatsana! Ats̈biama ts̈abe soye tonjama. ");
INSERT INTO kbh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Er ndbomnëjémënga nÿets tempo ts̈ëngaftangbeñe mochanjë́ftsemna, ndayténaca s̈mojábos̈ena ora, s̈matjobenaye ts̈abe soye chëngbiama jamana; er ats̈e ts̈ëngaftangaftaca ndoñe nÿets tempo quicháisemna. ");
INSERT INTO kbh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Quem shembása lempe nts̈amo tojobenacá ats̈biama tonjama. Chca tonjama ora, ats̈be cuerpo tonjaprontá ats̈e juatbontsa tescama, cabá ndoñe obaná së́ntsemna ora. ");
INSERT INTO kbh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndegombre cbë́yana, quem luaroca ndayénts̈naca Bëngbe Bëtsabe ts̈abe noticiënga chamojtsabuayiyná chents̈e, nts̈amo quem shembása tojamámnaca becá mochanjëftsóyebuambaye, chca, ents̈anga chabiama chamotsenójuabnama ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Chents̈ana, Judas Iscariote, canÿe chë bnë́tsana uta uatsjendayënguents̈á, tojána chë bachnangbe amëndayë́ngaftaca jencuéntama, Jesús chëngbe cucuats̈iñe jaboshjonama. ");
INSERT INTO kbh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chca tmojanuena ora, chënga imojóyejuaye y tmojans̈buachená crocénana jtabuénayana. Y cach orscana Judas yojtsenguaye nts̈amo jamana y ndëmua ora, Jesús chëngbe cucuats̈iñe jaboshjonana. ");
INSERT INTO kbh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chë Bashco fiesta bojats̈enté, chë levadúraca ndëpormana tandës̈e sayté, chë uatsjéndayënga Jesús tmojantjá: —¿Ndë́moca cojtsebos̈e bënga fchaiprontama, Bashco saná chacosama ca? Chca te chë judiënga imojanamana, Bëngbe Bëtsá jëtschuayamna canÿe oveshá jóbana chora jasama, chë Egiptocana chëngbe bëts taitanga Bëngbe Bëtsá tojánatsebacama jtenójuaboyama. ");
INSERT INTO kbh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","As Jesús uta chabe uatsjéndayata tojanichamó y mënts̈á tojanë́yana: —Chë bëts puebloye motsata. Chas̈ojáshjango ora, canÿe bacó cmochanjóbiats̈e, matbajiñe búyeshe echantsabuyambaye; cha s̈ochjuasto y s̈ochtserreparana ndëmuanÿe yebnents̈e yochjámashënguama; ");
INSERT INTO kbh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","y chë yebna nduiño s̈ochjauyana: “Buatëmbayá tonjayana: ¿Ndayents̈e chë tsañe yojtsemna, Bashco saná ats̈e ats̈be uatsjéndayëngaftaca jasama ca?” ");
INSERT INTO kbh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","As cha cmochanjínÿanÿiye canÿe bëts tsañe, tsbanana pisoca, lempe prontániñe; chents̈e s̈ochjaprónta bënga mochjasama ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","As chë uatsjéndayata tbojána y tbojáninÿena lempe nts̈amo Jesús tojanëyancá; y chents̈e chë Bashco saná tbojanprontata. ");
INSERT INTO kbh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tojanibétata ora, Jesús chë yebnoca tojánashjango, chabe bnë́tsana uta uatsjéndayëngaftaca. ");
INSERT INTO kbh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y mesë́shents̈e imojtsesaye ora, Jesús tojanë́yana: —Ndegombre cbë́yana, canÿa ts̈ëngaftanguents̈á, áts̈eftaca entsesá cha, uayayëngbe cucuats̈iñe s̈ochanjáboshjona ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chorna chë uatsjéndayënga ngménaca imojtsemna, y tmojanonts̈é canÿánÿa cha jatjayana: —¿Ats̈e chtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y Jesús tojanë́jua: —Canÿa chë bnë́tsana utatents̈á entsemna. Chabe tandës̈e cach ats̈e sëntsefchecuacná s̈cnenents̈e cha entsefchecuacná. ");
INSERT INTO kbh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndegombre, Bëngbe Bëtsá Ents̈á tbojanbemáftaca echanjopása nts̈amo chabiama Bëngbe Bëtsabe uabemana palabrënguiñe endayancá. Pero, ¡ts̈a lastema chë bochjáboshjonabiama! Chabiama más ts̈abá manjamna ndoñe ntjónÿnana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Imojtsesantscuana, tandës̈e tojanca, Bëngbe Bëtsábioye chama tbojtanchuá, tojanjataye y chabe uatsjéndayënga tojanëjatá, y mënts̈á tojánayana: “Mocñënga, mosënga, ats̈be cuerpo entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chents̈ana, canÿe coptema vínoyeca tojanaca, Bëngbe Bëtsábioye tbojtanchuá, chabe uatsjéndayënga tojanëfs̈as̈é, y nÿetscanga tmojanofs̈é. ");
INSERT INTO kbh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mënts̈á tojánayana: “Quem vínoye ats̈be buiñe entsemna. Ats̈be buiñe echanjuábuashana ents̈anga chamotsetats̈ëmbuama nts̈amo Bëngbe Bëtsá ents̈anga tojas̈ebuachenacá ndegombre yochjochnënguama. Chë buiñe bëtscá ents̈angbe ts̈abiama echanjuábuashana. ");
INSERT INTO kbh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Y ndegombre cbë́yana, morscana ya ndoñe más chë uvasës̈ents̈ana obocniye quichaisofs̈iye. Chë tsëm vínoye ts̈ëngaftangaftaca chanjofs̈iye, Bëngbe Bëtsabe amë́ndayoca chamojtsemna ora ca” —tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bëngbe Bëtsábioye jëtschuayama tmojancantá chents̈ana, Olivos tjashoye tmojë́ftsanbocana. ");
INSERT INTO kbh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús tojanë́yana: —Nÿetsca ts̈ëngaftanga quem ibeta áts̈beñe os̈buáchiyana s̈mochantsobuets̈e y s̈mochántsacheta, er Bëngbe Bëtsabe uabemana palabrënguiñe, cha mënts̈á tojánayana: “Chë oveshënga abuajë́nÿa chanjóba y chë oveshënga mochantsáshana ca.” Chca ts̈ëngaftangaftaca echanjopása, uayayënga chas̈mojishache ora. ");
INSERT INTO kbh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero obanënguents̈ana chaitayenents̈ana, ts̈ëngaftangbe natsana Galileoye chanjá ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chora Pedro tbojaniyana: —Masque nÿetscanga ácbeñe os̈buáchiyana chamotsobuets̈e y chamotsacheta, ats̈e nÿa ndocna te ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Chora Jesús tbojaniyana: —Ndegombre cbëyana, cam ibeta, ngallo cabá uta soye ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Pedro más yojtsichamo: —Masque chas̈otsemna ácaftaca jóbanama, ats̈e ndoñe quichátayana ndoñe cbonduabuatma ca. Y nÿetscanga cachcá imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Chents̈ana, canÿe luare Getsemaní ca uabáinoye tmojána. Chocna Jesús tojanë́yana: “Muents̈e motbiama, chëntscuana ats̈e choye chanjá, Bëngbe Bëtsáftaca jencuéntama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y tojë́ftsanëbiats̈e Pedro, Santiago y Juan. Choca cha yojónts̈a puerte ngménaca jtsemnama y corente cochtsets̈enaná. ");
INSERT INTO kbh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chë́ngbioye tojanë́yana: “Ats̈be ainana puerte ngménaca entsemna, mo jobanamcá. Muents̈e moquedanga y s̈mochtsefs̈na ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chents̈ana, Jesús más natsanoye tojána, tojanoshëntsaments̈é y fshantsóntscoca tojanotsejbéna y Bëngbe Bëtsábioye tbojanimpadá, jopódianëse, chë ts̈a japadésa ora ndoñe chaondóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mënts̈á yojtsichamo: “Ats̈be Taitá, aca lempe jamama condobena; tojopodese, cochjama ats̈e japadésama ndoñe chas̈ondë́tsemnama. Pero nts̈amo ats̈e stsebos̈cá ndoñe chaondë́tsemna, sinó nts̈amo aca cojtsebos̈cá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chents̈ana, chabe unga uatsjéndayëngbioye tojtanabo, y chëngna imnétsomañe. Chca tojánanÿena ora, Pédrëbioye tbojaniyana: “Simón, ¿cotsomañe? ¿Ni mo nÿe canÿe hora jtsefs̈nama ndoñe tconjobená? ");
INSERT INTO kbh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","S̈mochtsefs̈na y Bëngbe Bëtsáftaca s̈mochtsencuéntaye, bacna soye jamama ndoñe chacmondócochënguama. Ts̈ëngaftanga ndegombre s̈montsebos̈e espíritoca Bëngbe Bëtsá joyeunayana, pero cuerpiñe ndoñe añemo ques̈mátsbomna ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús cachiñe tojesaná y Bëngbe Bëtsáftaca tbojanencuentá, cach palabrënga jayanëse. ");
INSERT INTO kbh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yojtabo orna, chë uatsjéndayënga cachiñe imnétsomañe; chënga imojtsefshétana ocnaye causa, y ndoñe imontsobena nts̈amo jojuana. ");
INSERT INTO kbh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chents̈ana, tojtesaná y tojtanabo ora tojanë́yana: “¿Cabá s̈motsomañe y s̈motsochnañe? Nÿe nÿets̈á; hora tocjobuache, Bëngbe Bëtsá Ents̈á tbojanbemá bacna soye amëngbe cucuats̈iñe mochanjáboshjona. ");
INSERT INTO kbh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Motsbananga, cuajna. Minÿënga, ats̈e boshjuaná ya entsebeconá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús cabá yojtsóyebuambnantscuana, Judas, canÿe chë bnë́tsana uta uatsjendayënguents̈á, tojánashjango y cháftaca ba ents̈anga espadë́jangaca y ngarotbéngaca prontánënga. Chënga imojamna chë bachnangbe amë́ndayënga, ley abuátambayënga y judië́ngbeñe bëtsëjemëngcá mándayëngbe ichmónënga. ");
INSERT INTO kbh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, chë boshjuaná, tojanjuabó nts̈amo jamana ents̈anga jinÿanÿiyama ndëmua Jesús bétsemnana. Chíyeca, yojáuyana: “Nda chaijauámocho, cha echántsemna; s̈mochjishache y cuedádoca s̈mochjuánatse ca.” ");
INSERT INTO kbh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chcasna, Judas Jesúsbioye tojanobeconá y tbojaniyana: “¡Buatëmbayá ca!” Y tbojanámocho. ");
INSERT INTO kbh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chora chë ents̈anga tmojánishache y tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero canÿa chents̈e Jesúseftaca yojtsemná, chabe espadëja yojenosëngbotë́nts̈ena, y chë bachnangbe más uámana amëndayabe oservená canÿe matscuas̈e tbojtsanë́stjango. ");
INSERT INTO kbh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y Jesús chë ents̈anga tojanatjá: “¿Ndáyeca s̈mojabo espadë́jangaca y ngarotbéngaca ats̈e jishachama, mo ats̈e canÿe bacá uamana ents̈á cuaftsemncá ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ats̈e cada te ts̈ëngaftangbeñe sëndétsemna Bëngbe Bëtsabe bëts yebnoca abuátambaye, y ndocna te choca ches̈mátanishache. Pero ts̈ëngaftanga chca áts̈eftaca s̈montsama, cachcá nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá chaotsemnama ca” —tojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chorna, nÿetsca uatsjéndayënga tmojtsanëuatjaná y tmojtsanacheta, y Jesús cachcá chë uayayë́ngaftaca tmojesanonÿá. ");
INSERT INTO kbh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Canÿe bobontse Jesúsbioye ibojtsë́stona, nÿe canÿe uafjantse ents̈ë́jua uichëtjoná. Cha chë ents̈anga tmojánishache, ");
INSERT INTO kbh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero chëngbe cucuats̈iñe chë ents̈ë́jua jesáboshjonëse, chë bobontsna enas̈á yojtsachá. ");
INSERT INTO kbh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Chents̈ana, Jesús tmojanánatse chë bachnangbe más uámana amëndayábioye; y chocna, nÿetsca chë bachnangbe amë́ndayënga, bëtsëjemëngcá amë́ndayënga y ley abuátambayënga tmojánenefjna. ");
INSERT INTO kbh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro bënocana Jesús tbojanasto, chë bachnangbe más uámana amëndayabe yebnents̈a chashjóntscoñe; y chents̈e tojanoquedá. Chë Bëngbe Bëtsabe bëts yebnoca josticië́ngaftaca yojtsetbemana; iñe juachaca yojtses̈bonena. ");
INSERT INTO kbh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chë bachnangbe amë́ndayënga y chë judiëngbe uámana mándayënga imojtsenguaye canÿa, nda ndayánaca Jesusbe contra cháuayana, as jobenayama cha chaóbana ca jayanama; pero ndoñe montsaninÿana. ");
INSERT INTO kbh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Er masque banga Jesusbe contra uayátsenaye soyënga imojtsichamo, nÿetscanga ndoñe cachca soye montsanichamo. ");
INSERT INTO kbh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Báseftanga imojotsaye y mënts̈á Jesusbe contra, ndoñe ndegombre betsemncá tmojánayana: ");
INSERT INTO kbh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bënga cha fsënjoyeuná mënts̈á: ‘Ats̈e quem Bëngbe Bëtsabe bëts yebna, ents̈angbe pormana yebna, chantsepochóca; y unga tese inÿe Bëngbe Bëtsabe bëts yebna, ents̈ángbeyeca ndëpormana yebna chanjëtsjebo ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero masque chca imojtsichamo, nÿetscanga ndoñe cachca soye montsanichamo. ");
INSERT INTO kbh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chorna, chë bachnangbe más uámana amëndayá yojotsbaná, nÿetscangbe tsëntsaca yojotsaye, y Jesúsbioye tbojantjá: —¿Ndocá cochanjayana? ¿Ndayase yojtsemna chë acbe contra montsichamo soye ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero cha nÿe iytëca yojtsemna y ndocá ibontsëjuana. Chë bachnangbe más uámana amëndayá cachiñe tbojtëtantjá, mënts̈á: —¿Aca chë Cristo icomna, Bëngbe Bëtsá chë nda fsëndadoranabe Uaquiñá ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y Jesús tbojanjuá: —Arseñor, ats̈e cha sëndmëna; y ts̈ëngaftanga s̈mochanjinÿe, ats̈e, Bëngbe Bëtsá Ents̈á tbojanbemá, chë nÿets obenana bomnabe cats̈bioica chantsetbemana, y celoca jants̈etëshiñe chántsaboye ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chora, chë bachnangbe más uámana amëndayá chabe uichëtjonëjuangá yojtsenánts̈ajatanëca, puerte ibojtsetna causa, y tojánayana: —¿Ndayama más ents̈anga s̈ochjátëjaboto Jesusbe contra chamuayanama ca? ");
INSERT INTO kbh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ts̈ëngaftanga s̈monjouena nts̈amo chë ents̈á entsichamcá, y chca Bëngbe Bëtsabiama entsemna mo cha cuafjoyenguangcá, chë chabe Uaquiñá yomna ca cha tonjayana ora. ¿Nts̈amo ts̈ëngaftanga s̈matjayana ca? —cha tojanë́yana. Y nÿetscanga tmojánayana, cha ndegombre bacna soye yojtsebomna y jóbanama ibojtsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chorna báseftanga tmojanonts̈é Jesús buashëtjnayana; jubiá imojútsbotse, imojtsejants̈etaye y imojtsetjanaye: “¡Momalisiá nda tcmënjajants̈etá ca!” Y chë Bëngbe Bëtsabe bëts yebnoca josticiëngna imojtsajuebjants̈etaye. ");
INSERT INTO kbh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pédrëna, tsmanoca yojtsemna chashjoca. Chora, canÿe shembása, chë bachnangbe más uámana amëndayabe oservená yojáshjango; ");
INSERT INTO kbh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","y Pédrëbioye tbojáninÿe ora, cha iñe juachaca yojtsans̈bonena, yejuana ibojonÿinÿiye y tbojaniyana: —Acnaca, Jesús Nazaretocáftaca conjánana ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro tojánayana chábioye ndoñe bonjanabuátma ca; y mënts̈á tojánayana: —Ndayama cojtsichámuama ndoñe quetsátstats̈ëmbo, ni ques̈nátësertana ca. Y shjoye, amashjuanóntscoñe yojábocna; y chora canÿe ngallo yojacánta. ");
INSERT INTO kbh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chë oservená cachiñe Pédrëbioye tbojáninÿe y tojanonts̈é chë ínÿenga jauyanana: —Muánaca Jesusbe uatsjendayënguents̈á entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero chana cachiñe tojánayana Jesúsbioye ndoñe bonjanabuátma ca. Chents̈ana, chë chents̈e imojtsemnënga Pedro tmojátaniyana: —Ndegombre aca chënguents̈á contsemna; ácnaca Galileocá contsemna ca. ");
INSERT INTO kbh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero Pedro tojanonts̈é ichámuana: —¡Bëngbe Bëtsá chas̈otsecastigá ndoñe ndegombre soye stsichámëse ca! —y yojónts̈a júrayana— ¡Ats̈e chë ents̈á ndoñe quetsatabuatma, ndabiama ts̈ëngaftanga s̈montsatsëtsná ca! ");
INSERT INTO kbh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y cachora chë ngallo uta soyama yojacánta, y Pedro yojenójuaboye nts̈amo Jesús tbojaniyanama: “Ngallo cabá uta soye ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca.” Y tojanonts̈é enóbos̈achiyana. ");
INSERT INTO kbh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tojanbinÿna ora, chë bachnangbe amë́ndayënga, chë judië́ngbeñe bëtsëjemëngcá amë́ndayënga y ley abuátambayënga cánÿents̈e tmojánenefjna, nÿetsca chë luarents̈a más uámana mandayë́ngaftaca, jenóyeunayama nts̈amo jamëse Jesús jóbama. Jesús tmojanëcuébatsëca y tmojanánatse, y Pilato, chë Judeoca mandadbe cucuats̈iñe tmojánboshjona. ");
INSERT INTO kbh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesúsbioye tbojantjá: —¿Aca chë judiëngbe rey cojtsemna ca? Y Jesús tbojanjuá: —Aíñe, aca ndegombre yomncá tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chë bachnangbe amë́ndayënga bëtscá soyënga Jesusbe contra imojtsichamo; ");
INSERT INTO kbh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","chíyeca Pilato cachiñe Jesúsbioye tbojantjá: —¿Ndocá s̈cochanjojuá ca? Minÿe; bëtscá soyënga acbe contra montsichamo ca. ");
INSERT INTO kbh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús ndoñe más tbonjanjuá; chë causa, Pilato ndoñe yontsetáts̈ëmbo nts̈amo jajuaboyana. ");
INSERT INTO kbh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada Bashco fiesta ora, Pilato yojanamana canÿe utamená jëtsboshjonana, ndánaca ents̈anga tmojuabuayaná. ");
INSERT INTO kbh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chë tempo yojamna canÿa Barrabás ca uabainá; cárceloye inautámena chabe enutë́ngaftaca. Chëngna ents̈anga tmojtsanëbaye, mandadëngbe ents̈ángaftaca imojentsjaná ora. ");
INSERT INTO kbh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Chora, ents̈anga tmojánashjajna y tmojanonts̈é Pilátbioye jauyanana, nts̈amo Bashco fiesta ora jamama yojanamancá chaomama. ");
INSERT INTO kbh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y Pilato tojanë́jua: —¿Ts̈ëngaftanga s̈mojtsebos̈e ts̈ëngaftangbe rey ats̈e chjëtsboshjona ca? ");
INSERT INTO kbh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chca tojánayana, er Pilato yojtsetáts̈ëmbo, chë bachnangbe amë́ndayëngna envidia causa Jesús chabe cucuats̈iñe tmojánboshjonama. ");
INSERT INTO kbh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero chë bachnangbe amë́ndayëngna ents̈anga tmojanañemó chamuenbouénanama, Pilato jauyanama chëngbiama Barrabás chabuatsboshjona ca. ");
INSERT INTO kbh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y Pilato tojanatjá: —¿Y nts̈amo chjama chë “judiëngbe Rey ca” s̈monduabobuatmáftaca ca? ");
INSERT INTO kbh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y chënga tmojanáyebuachena: —¡Motsecrucificá ca! ");
INSERT INTO kbh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Y Pilato ents̈anga tojanë́yana: —¿Ndáyeca? ¿Nts̈amo cha tojobuachjanguá ca? Pero chëngna más añémoca tmojtë́tanayebuachena: —¡Motsecrucificá ca! ");
INSERT INTO kbh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","As Pilato, ents̈ángaftaca ts̈abá joquédama yojtsebós̈eyecna, Barrabás tbojtanboshjona. Yojámëndaye soldadënga jabuache Jesús chamotsets̈enama; y chents̈ana soldadëngbe cucuats̈iñe tbojánboshjona, chamocrucificama. ");
INSERT INTO kbh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chents̈ana, chë soldadënga Jesús tmojanánatse chë mandadbe bëts yebnents̈a chashjoye, y nÿetsca soldadënga tmojánachembo chamobéconama. ");
INSERT INTO kbh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Shbuenda uafjatsenga uinÿna ents̈ayá mo reycá tmojanichëtjo; canÿe coronë́sha tmojanapormá uchmas̈ë́fjangaca y tmojanabests̈ajó. ");
INSERT INTO kbh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Y chents̈ana tmojanonts̈é jachuayana: “¡Bayté judiëngbe Rey cochtsemna ca!” ");
INSERT INTO kbh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Canÿe niñë́fjaca Jesús bests̈as̈iñe imojtsë́tsjanjnaye, imojtsebuashëtjnaye, y chabe delante imojtsofshëntsaménts̈enaye. ");
INSERT INTO kbh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y chca imnaftsáboyejuanents̈ana, chë shbuenda uafjatsenga ents̈ayá tmojtsanabotsca y cachabe ents̈ayá tmojtanichëtjo, y pueblo chaboye tmojanánatse jacrucifícama. ");
INSERT INTO kbh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Chora, canÿe ents̈á chëjana yojtsatashjajuana, Simón ca uabainá, Cirene pueblocá, Alejandro y Rufbe taitá; jajocana yojtsatachnëjuana; y chë soldadëngna imojuatária Jesusbe cruz jëftsocutsayama. ");
INSERT INTO kbh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesús tmojanánatse Gólgota ca uabaina luaroye (hebreo biyañe endayana “Obanabe Bests̈ashe Luare ca”); ");
INSERT INTO kbh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","y tmojanabuiyé vínoye mírraca enájuabniye, pero Jesús ndoñe yonjuáyëngacñe. ");
INSERT INTO kbh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y chents̈ana tmojancrucificá; y chabe ents̈ayangamna, tsbanánoye tmojanë́ts̈ena jinÿama ndayá cada ona yochjëftsanácñama. ");
INSERT INTO kbh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cachëse, base mos̈enana ora Jesús tmojancrucificá. ");
INSERT INTO kbh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y chabe bests̈as̈e juatsboicna canÿe uabemana soye tmojananjo. Chiñe yojétsayana ndáyeca cha tmojancrucificama, mënts̈á: MUA CHË JUDIËNGBE REY ENDMËNA ca. ");
INSERT INTO kbh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y cháftaca útata bacna soye ochjajnayátnaca tmojanacrucificá, canÿa chabe cats̈bioica, y ínÿana chabe uañicuayoica. ");
INSERT INTO kbh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chca cháftaca tmojanma, chaochnënguama nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe chabiama iuayancá, mënts̈á: “Y chábioye tmonjáninÿe mo chë puerte bacna soye amënguents̈á canÿa cuaftsemncá ca.” ");
INSERT INTO kbh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Y chëjana imojtsachnëjuana ents̈anga, Jesús imojtsóyenguaye, imojtsobests̈fshanenaye y imojtsatsaye: “¡Aca chë Bëngbe Bëtsabe bëts yebna cochtsánenasatajchca y nÿe unga tese cochtanjebo, ");
INSERT INTO kbh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","cach aca mentsbocá y cruzocana matastjango ca!” ");
INSERT INTO kbh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Cachcá chë bachnangbe amë́ndayënga y chë ley abuátambayënga imojtsáboyejuana, y chënga imojtsenatsëtsnaye: “Cha ínÿenga tojëftsatsebacá, pero cachá jéntsbocama ndoñe quenátobena. ");
INSERT INTO kbh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Chë Cristo, chë Israeloca Rey! ¡Cruzocana chauatastjango, bënga jinÿama y chábeñe chaftsos̈buachema ca!” Y cháftaca ibojtsecrucificanátnaca ibojtsóyenguaye. ");
INSERT INTO kbh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nÿetsto orscana y las tresë́ntscoñe, nÿets quem luare yojtseibétata. ");
INSERT INTO kbh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chca orna, Jesús chabe biyañe tojanáyebuachena: “Eloi, Eloi, ¿lema sabactani ca?” (Chca endayana “Ats̈be Bëtsá, ats̈be Bëtsá, ¿ndáyeca cachcá s̈cojonÿá ca?”) ");
INSERT INTO kbh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chca tmojanuena ora, báseftanga chents̈e imojtsemnënga imojtsichamo: “Mouenënga, chë Bëngbe Bëtsabe juabna oyebuambnayá Elías bontsechembuana ca.” ");
INSERT INTO kbh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","As chora, canÿa tojanótjajo, untja vínoyeca canÿe esponjëshe tojanfchecuacuá, canÿe niñëfjiñe tojananguësëtjo y Jesúsbioye tojanbeconá chaofs̈ema; y tojánayana: “Cachcá mochjonÿaye, er Elías tayochjabo jabátëstjanguama ca.” ");
INSERT INTO kbh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero Jesusna, jabuache tojanoyó y tojanóbana. ");
INSERT INTO kbh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y chë Bëngbe Bëtsabe bëts yebnoca yojújonÿana ents̈ë́jua tsëntsaca yojtsenájataye, tsbanánocana fshantsoye. Chëjua bënë́jua inauamna y chë tsatsëntsaca inaújonÿana. ");
INSERT INTO kbh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chë romano soldadëngbe amëndayá, Jesusbe ndirichiñe yojtsemna; y nts̈amo cha tojanobancá tbojáninÿe ora, tojánayana: “¡Ndegombre quem boyabása Bëngbe Bëtsabe Uaquiñá yomna ca!” ");
INSERT INTO kbh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Básefta shembásengnaca chents̈e imojtsemna, bënocana imojtserreparana; chënguents̈e imojtsemna María Magdalena; María, Santiago chë más basa y Josebe mamá; y Salomé. ");
INSERT INTO kbh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Chë shembásengna Jesús tmojanasto y tmojanájabuache cha Galileoca yojamna ora; y inÿe ba shembásengnaca chents̈e imojtsemna, chë cháftaca Jerusalenoye tmojánanga. ");
INSERT INTO kbh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Chë yëfsana ochnayté yojtsémnayeca, cach te yojánamna saná japróntana chë yëfsana jasama. Ya yojtseibétatana ora, ");
INSERT INTO kbh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Pilato yojtsemnoye tojána canÿe boyabása, José ca uabainá, Arimatea pueblocá; cha inamna canÿe chë luarents̈a uámana mandayënguents̈á. Cha Bëngbe Bëtsábeñe yojtsos̈buáchiye y yojanobátmana chabe amë́ndayana chaóshjanguama. Ndauatjcá Pilátbioye Jesusbe cuerpo tbojanotjañe. ");
INSERT INTO kbh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato yojenjnaná Jesús ts̈a betsco yojóbanama; as tojanmandá chë soldadëngbe amëndayá chamuachembo, jatjayama Jesús ya bën obaná tayojétsemnama. ");
INSERT INTO kbh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chë soldadëngbe amë́ndayana Pilátbioye ibojauyana Jesús ya obaná yojtsemna ca; y as chora, Josébioye tbojanlesenciá Jesusbe cuerpo chabotsámbañama. ");
INSERT INTO kbh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chora, José canÿe uafjantse lino ents̈ë́jua tojanabuamé, Jesusbe cuerpo cruzocana tbojanë́stjango, chë lino ents̈ë́juaca tbojanandmaná, y canÿe cuevëshiñe ndëts̈beñe pormánëshiñe tbojanjajó; chents̈ana canÿe ndëts̈bé tojansjoná, y chë cuevëshoye amashjuanents̈e tojánachto. ");
INSERT INTO kbh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena y María, chë José y Santiagbe mamá, tbojáninÿe ndayents̈e Jesusbe cuerpo tbojanjájoma. ");
INSERT INTO kbh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ochnayté tojanopasá ora, María Magdalena, María Santiagbe mamá, y Salomé, botamana uanguëts̈e béjaye tmojanabuamé, chíyeca jama Jesusbe cuerpo janëtjuama; ");
INSERT INTO kbh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","y tmenguse, chë semana bojats̈éntena, cabá cachëse, shinÿe yojábocna ora, chë cuevëshoye tmojána. ");
INSERT INTO kbh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Imojtsaye ora imojtsayénatsëtsnaye: “¿Chë cuevëshoye amashjuanents̈a ndëts̈bé nda bochtsabuajuána ca?” ");
INSERT INTO kbh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero imojontjes̈iye ora, tmojáninÿe chë cuevëshoye amashjuanents̈a bëts ndëts̈bé, chents̈ana juanániñe. ");
INSERT INTO kbh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","As chënga choye tmojánamashjna y choye tmojáninÿe canÿe bobontse bën uafjantse ents̈ë́jua uichëtjoná, chë cuevëshents̈a cats̈bioica inétsotbemañe; y chë shembásenga imojouatjaná. ");
INSERT INTO kbh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero chë bobontse tojanë́yana: “Ndoñe matauatjëngana; ts̈ëngaftanga s̈mondënguá Jesús Nazaretocá, chë tmonjancrucificá cha. Cha ya tontayena; muents̈e ndoñe quenátsmëna. Minÿënga cha enjë́ftsejajonents̈e. ");
INSERT INTO kbh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Motsajna, y Pedro y chë inÿe uatsjéndayënga s̈mochjáuyana: ‘Jesús ts̈ëngaftangbe natsana Galileoye echanjá. Choca cha s̈mochanjinÿe, nts̈amo cachá tcmojanëyancá ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","As chë shembásenga betsco chë cuevëshents̈ana tmojésanbocana, er puerte auatjanánënga imojtsemna y ngmëmnayënga imojtsemna; y chë causa, chë soyama ndocná tmonjaniyana. ");
INSERT INTO kbh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús tojtanayenents̈ana, chë semana bojats̈enté, Jesús natsana María Magdalénbioye tbojánebëbocna. Tempo Jesús chábents̈ana canÿsëfta bacna bayëjënga tojtanë́buacana. ");
INSERT INTO kbh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cha Jesúsbioye ainá tbojáninÿents̈ana, tojána Jesúseftaca imojánajnënga chama jaúnayama; chëngna ngménaca y s̈achénaca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero chënga tmojanjuabó nderado mo ndoñe ndegombre yontsemna ca, chë Jesús ainá yojtsemna ca, y María Magdalena chábioye tbojáninÿe ca tmojanuena ora. ");
INSERT INTO kbh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chents̈ana, uta ustonátbioye, básefta yebnënga yojamna luaroye ibojétsaye ora, Jesús tojánebëbuacna, mo inÿa cuaftsemncá. ");
INSERT INTO kbh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chora chata tbojésanshëcona chë ínÿenga chama jacúntama; pero chëngna cach ndoñe ndegombre ca tmojanjuabó. ");
INSERT INTO kbh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cabana, Jesús chë bnë́tsana canÿe uatsjéndayënga tojánebëbuacna, chënga imojtsesaye ora; y tojanëcácana chë cha ainá yojtsemnama ndoñe ndegombre yontsemna ca tmojánjuaboma y nÿets ainánaca chábeñe ndoñe montsanos̈buachema, er cha ainá tmojáninÿënga chama tmojanacuntá ora, chca ndoñe ndegombre yontsemna ca chë uatsjéndayënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chents̈ana Jesús tojanë́yana: “Nÿets luarëngoye motsajna, y nÿetsca ents̈anga chë ts̈abe noticiëngama s̈mochtsabuayiynaye. ");
INSERT INTO kbh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nda chiñe chaojtsos̈buaché y ts̈ëngaftanga chas̈mojuabaye, cha atsbocaná echántsemna; pero nda ndoñe tontsos̈buaché, cha nÿets tempo castiganá echántsemna. ");
INSERT INTO kbh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chë áts̈beñe os̈buáchiyënga ndegombre soyënga imojtsabuayiynama, ents̈anga mënts̈á mochántsetats̈ëmbo: ats̈e jóts̈ëmbonëse, áts̈beñe betsos̈buachéyeca, ents̈ángbents̈ana bacna bayëjëngbe juabna mochantábocna; tempo chënga ndmabiyañe mochantsóyebuambnaye. ");
INSERT INTO kbh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Masque nderado cucuats̈iñe mëts̈cuayënga tmojishache o veneno tmojofs̈enga, ndocá quemochatspása; y s̈oquë́ngbeñe cucuats̈ënga chamojacjá ora, chënga shnánënga mochántsatsmëna ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bëngbe Utabná Jesús jóyebuambayama tojanpochocá chents̈ana, celoye cha tmojtanatsbaná, y uámana luarents̈e, Bëngbe Bëtsabe cats̈bioica yojtótbema jtsemándayama. ");
INSERT INTO kbh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y chë uatsjéndayëngna tmojánbocana y Bëngbe Bëtsabe soyëngama nÿetsquénache ents̈anga tmojanabuayená. Cach Bëngbe Utabná chënga yojanëjabuáchana, y yojánama ents̈anga chamotsetats̈ëmbuama chë buayenana soye ndegombre Bëngbe Bëtsabe soyënga bétsemnama, chë uatsjéndayënga bëts soyënga jamama obenana chamotsebomnama cha jtsamëse.");
INSERT INTO kbh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ba ents̈anga Jesusbe historia tmojuábema, nts̈amo bë́ngbeñe ndegombre tojopasacá. ");
INSERT INTO kbh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chë historia juabemamna, chënga tmojanuena nts̈amo Jesusbe uatsjéndayënga y inÿe ents̈anga chabiama imnencuentaycá. Chë ents̈angna tmojáninÿe y tmojanuena ndayá Jesús tojanmama y nts̈amo tojanayancá, y chents̈ana chabe ts̈abe noticiënga ents̈ángbioye tmojanabuayená. ");
INSERT INTO kbh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","As, áts̈naca sënjonts̈é cuedádoca juanotíciana lempe nts̈amo Jesusbiama imojtsichamcá, tojanobojats̈ents̈ana më́ntscoñe. Mora s̈ontsinÿana ts̈abá yojtsemna acbiama juabemana nts̈amo ndegombre yomncá, uámana taitá Teófilo, chë tijuanoticiá soyëngama, nts̈amo ndegombre bë́ngbeñe tojopasacá. ");
INSERT INTO kbh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ba soyënga Jesusbiama tcmojabuátëmbanga, y ats̈e së́ntsebos̈e aca chacotsetáts̈ëmbo, nts̈amo tcojouencá ndegombre yomnama. ");
INSERT INTO kbh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes Judea luaroca rey inamna ora, yojamna canÿe judiëngbe bachna, Zacarías ca uabainá. Cha yojamna Abíasbe bachnanguents̈a pamillo. Chabe shemna, Isabel ca yojanabaina, y chana Aarónbents̈ana ents̈á inamna (Aarón, chë más uámana bachnangbe natsana amëndayá). ");
INSERT INTO kbh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chatna ts̈abá amata ibnamna Bëngbe Bëtsabe bominÿiñe, y nts̈amo Bëngbe Bëtsá yomandacá ibojoyena; y chca, ndocná yonjanobena jayanana chata ndoñe ts̈abá ibonjánama ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Básenga tondaye ibonjánabamna, Isabel s̈es̈ona jtsebomnama ndobena causa, y chatna ya bëtsanánata ibojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Chë bachnanga Bëngbe Bëtsabe bëts yebnents̈e tmojtsoservena ora, sempre imojanamana jabocacayana, nda ts̈abá tbojtsonÿená, Bëngbe Bëtsábioye atschuanaye luaroye cháuama incienso jajuinÿiyama. Canÿe, Zacaríasbe ents̈anga Bëngbe Bëtsabe bëts yebnoca, Bëngbe Bëtsábents̈e imojtsoservena orna, Zacaríasbioye ts̈abá ibojonÿena; y chca, cha ibojotóca jana incienso jajuinÿiyana. ");
INSERT INTO kbh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías, incienso yojtsejuinÿnantscuana, ba ents̈anga shjoca imojtsemna, Bëngbe Bëtsáftaca encuéntaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nÿe ndeolpe, Bëngbe Utabnabe canÿe ángel tojanonÿná chë incienso jajuinÿiyama altarents̈a cats̈bioica. ");
INSERT INTO kbh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías chábioye tbojáninÿe ora, tojanenjnaná y corente uatjana tbojanábuache. ");
INSERT INTO kbh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chora chë ángel tbojaniyana: —Zacarías, ndoñe matauatjana. Bëngbe Bëtsá tonjouena nts̈amo tconjaimpadacá. Acbe shema Isabel canÿe s̈es̈ona bochántsebomna, boyabásetema, y chana Juan ca cochjuabaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chama aca corente oyejuayá cochántsemna, y bëtscá ents̈anga mochanjóyejuaye acbe uaquiñá tojonÿnama. ");
INSERT INTO kbh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Er cha, Bëngbe Bëtsabiama canÿe uámana ents̈á echántsemna. Ndocna te queochaisofs̈iye vínoye, ni jabuáchiye. Chë Uámana Espíritu chabe ainaniñe echantsemándaye, cha cabá ndonÿna orscana. ");
INSERT INTO kbh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Banga Israeloca ents̈anga, nts̈amo cha chaojayanama mochanjonts̈é joyeunayana Bëngbe Bëtsá, chëngbe Utabná. ");
INSERT INTO kbh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cha echanjáshjango chë Bëngbe Bëtsabe Uámana Uabuayanabe natsana, y echántsebomna obenana y canÿe espíritu nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Elías inabomncá. Chabe natsana echanjáshjango, bëtsë́tsanga chëngbe básengaftaca ndoñe chamondë́tsentsjanama, y chë nduauenanënga cachiñe chamotsatsjuabnama nts̈amo chë Bëngbe Bëtsabe bominÿiñe ts̈abá amënga mondbetsejuabnaycá. Y chca, ents̈anga cha echantsapróntaye Bëngbe Utabná jabama orscama ca —chë ángel tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","As Zacarías chë ángelbioye tbojantjá: —¿Nts̈amo ats̈e stjobenaye jtsetats̈ëmbuana chë s̈contsatsá soye ndegombre bétsemnama? Er ats̈e ya bëtsëjema së́ntsemna y ats̈be shémnaca cachcá ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chora chë ángel tbojanjuá: —Zacarías, ats̈e ángel Gabriel sëndmëna; ats̈e Bëngbe Bëtsábioca sëndoservena. Cha s̈onjichmó chë ts̈abe noticiënga aca jauyanama y juenayama. ");
INSERT INTO kbh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Morna, chë cbontsatsá soyiñe ndoñe quecatos̈buaché causa, ndëbiá cochanjoquéda, y nts̈amo cbontsatsacá chaojopasá ora, chama tempo chaojtsemna ora, chora jóyebuambayama cochantobenaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chë ángel Zacaríaseftaca yojtsóyebuambnantscuana, ents̈anga shjoca Zacaríasbiama imojtsobátmana, y mënts̈á imojtsejuabnaye: “¿Ndáyeca ts̈a bën Bëngbe Bëtsabe bëts yebnents̈e ibojtsobiamná ca?” ");
INSERT INTO kbh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías tojtanbocna ora, ndoñe yontsobena chë ents̈ángaftaca jóyebuambayana. Chënga tmojántats̈ëmbona, chë Bëngbe Bëtsábioye atschuanayents̈e Zacarías mo otjenayoquëcá Bëngbe Bëtsábiocana canÿe soye tojáninÿama, er chë́ngbioye jats̈ëmbombonana yojáuyana, ndëbiá yojoquéda causa. ");
INSERT INTO kbh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chabe tempo, chë Bëngbe Bëtsabe bëts yebnents̈e jtsetrabájayama tojanpochocá ora, Zacarías cachabe yebnoye tojtaná. ");
INSERT INTO kbh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chents̈ana baseftaytese, chabe shema Isabel ngomamaná yojoquéda, y chë causa, chë shema shachna ishinÿe cach tsoca yebnents̈e totanoquedá. ");
INSERT INTO kbh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cha mënts̈á yojtsichamo: “Bëngbe Utabná mora ats̈biama tojtenojuabó, ents̈ángbents̈e ats̈be ngménana jtsebojuánama, básenga tondaye béntsabamna causa ca.” ");
INSERT INTO kbh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel chnë́nguana ishinÿe ngomamaná yojtsemna ora, Bëngbe Bëtsá, ángel Gabriel tbojanichmó Galilea luaroye, Nazaret ca uabaina puebloye, ");
INSERT INTO kbh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","canÿe shembása María ca uabainá jauatsëtsayama. Mariyna cabá boyabása nduabuatmá inamna, pero Joséftaca jobouamayama tbojans̈buachená. Y Josena, rey Davídbents̈ana ents̈á inamna. ");
INSERT INTO kbh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chë ángel Maríybioye tojána y mënts̈á tbojanchuá: —¡Mouena. Bëngbe Bëtsá ts̈abe bendición acbiama tonjama! ¡Bëngbe Utabná ácaftaca entsemna ca! ");
INSERT INTO kbh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chca tojanuena ora, María yojenjnaná chë soyama, y yojtsejuabnaye ndáyeca chë ángel chca tbojanchuama. ");
INSERT INTO kbh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Chora chë ángel tbojaniyana: —María, ndoñe matauatjana, Bëngbe Bëtsá entsama ts̈abe bendicionënga chacotsebomnama. ");
INSERT INTO kbh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aca ngomamaná cochanjoquéda y canÿe s̈es̈ona boyabásetema cochántsebomna, y chana Jesús ca cochjuabaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Cha puerte echantsámana, y ents̈angna Bëngbe Bëtsabe Uaquiñá ca chábioye mochantsábobuatma. Y Bëngbe Bëtsá chë Utabná, chábioye canÿe rey bochanjábema, nts̈amo David yojamncá, ");
INSERT INTO kbh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","y Jacóbëbents̈ana ents̈anga nÿetsca tescama echántsamëndaye, y chabe mándayana ndocna te queochaisopochóca ca —chë ángel tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Chents̈ana María chë ángelbioye tbojantjá: —¿Nts̈amo chca yochjopása, cabá ndoñe boyá sëntsebomnëse ca? ");
INSERT INTO kbh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y chë ángel tbojanjuá: —Chë Uámana Espíritu echanjabo nÿets ácbeñe, y Bëngbe Bëtsabe obenánaca ngomamaná cochanjoquéda. Chabe obenana mo jants̈etëshcá cmochanjaboútsbotse; chíyeca chë echanjónÿna s̈es̈ona Uamaná echántsemna, y chábioye Bëngbe Bëtsabe Uaquiñá ca mochantsábobuatma. ");
INSERT INTO kbh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mouena, Isabel, acbe primá, canÿe s̈es̈ona bochántsebomna, masque ya bëtsananá cha entsemna; chë “s̈es̈ona ndbomná ca” monjanabobuatmá, mora ya chnë́nguana ishinÿe ngomamaná entsemna, ");
INSERT INTO kbh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","er Bëngbe Bëtsá lempe jamama endobena ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chora María chë ángelbioye tbojaniyana: —Bëngbe Bëtsabe oservená ats̈e së́ntsemna. Bëngbe Bëtsá áts̈eftaca chaoma nts̈amo s̈cojauyancá ca. Y chents̈ana chë ángel tojtsatanoñe. ");
INSERT INTO kbh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chents̈ana, María tojanoprontá y tojanochëmo canÿe puebloye, Judeoca tjañenache luariñe. ");
INSERT INTO kbh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chocna cha, Zacaríasbe yebnents̈e tojánamashëngo y Isabélbioye tbojanchuá. ");
INSERT INTO kbh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel nts̈amo María tbojanchuama tojanuena ora, Isabelbe s̈es̈ona chabe uafsbioye tojanobonjó, y chë Uámana Espíritu Isabélbeñe tojánamashëngo chabe ainaniñe jtsemándayama. ");
INSERT INTO kbh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chcasna, Isabel jabuache tojánayana: —¡Bëngbe Bëtsá acbiama más ts̈abe bendicionënga entsama nÿetsca shembásengbiama, y chë cochántsebomna s̈es̈onbiámnaca cachcá! ");
INSERT INTO kbh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ats̈e merecido taitsatobuajoñe, ats̈be Utabnabe mamá chas̈uabobuáchama; ");
INSERT INTO kbh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","er ats̈e sënjouena nts̈amo s̈conjachuá, y cachora ats̈be s̈es̈ona oyejuayá ats̈be uafsbioye tonjobonjó. ");
INSERT INTO kbh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Aca Bëngbe Bëtsábeñe tcojos̈buaché; cojtsetáts̈ëmbo Bëngbe Bëtsá nts̈amo tcmojas̈buachenacá yochjamama; chíyeca puerte oyejuayá cochántsemna ca! ");
INSERT INTO kbh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chora María tojánayana: “Nÿets ainánaca Bëngbe Utabná chantsadorana, ");
INSERT INTO kbh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","y Bëngbe Bëtsá, ats̈be Atsbocayabiama corente chanjóyejuaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bëngbe Bëtsá ats̈biama tojtenojuabó, ats̈e chabe oservénëjema. Er morscana muents̈a ents̈anga nÿetscanga puerte oyejuayá ca s̈mochantsábobuatma. ");
INSERT INTO kbh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bëngbe Bëtsá, chë nÿets obenana bomná, chabe obenánaca bëts soyënga ats̈biama tonjama. ¡Bëngbe Bëtsá puerte Uamaná ca entsabaina! ");
INSERT INTO kbh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","¡Morsca ents̈anga y más chcoyënga, chábioye yeunanëngbiama, cha sempre bochántsengmena! ");
INSERT INTO kbh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cha, chabe obenánaca bëts soyënga tojama, y chë nÿe cachënga bëtsë́tsanga enobiamnayëngbe juabna tojtsepochocá; ");
INSERT INTO kbh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","reyë́ngbioye chëngbe mándayents̈ana tojtsatsats̈e; pero chë nÿe cachënga bëtsë́tsanga ndenobiamnayë́ngbioye, uámanënga tojábiama. ");
INSERT INTO kbh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chë shë́ntseca imomnë́ngbioye, chamosama bëtscá cha tojats̈atá, pero chë bomnë́ngbioyna tondaye tonjats̈atá. ");
INSERT INTO kbh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cha tojanë́jabuache chabe ents̈anga Israeloca, chabe oservénënga, y ndoñe tbonjánebnatjëmba jtsalastemánana, ");
INSERT INTO kbh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nÿetsca tescama chë Abraham y chábents̈ana ents̈ángbioye, nts̈amo bëngbe bëts taitanga Bëngbe Bëtsá tojanas̈ebuachenacá ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyna unga ishinÿe Isabélaftaca tojanoquedá, y chents̈ana cachabe yebnoye tojtaná. ");
INSERT INTO kbh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabel jtses̈ócanama tojanónts̈abuache ora, canÿe s̈es̈ona boyabásetema tojanonÿná. ");
INSERT INTO kbh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Isabelbe juachañe oyenënga y chabe pamíllanga tmojántats̈ëmbona nts̈amo Bëngbe Bëtsá chábioye ibojalastemama, y chama corente Isabélaftaca tmojanoyejuanga. ");
INSERT INTO kbh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chë s̈es̈ona posuftayté yojtsebomna ora, tmojánashjango y chëtémbioye chë más delicadents̈e base bobachtema tmojantëts̈e, nts̈amo chë judiënga imojanamancá. Chënga imojétsebos̈e chë s̈es̈ónbioye Zacarías ca juabáyana, cach beftcá; ");
INSERT INTO kbh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","pero chabe mamá tojanë́yana: —Ndoñe. Quem s̈es̈ona echantsabaina Juan ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","As chënga Isabélbioye tmojaniyana: —Acbe pamíllangbeñe ndocná chca quenatabaina ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chora chënga jats̈ëmbombonana Zacaríasbioye tmojantjá, nts̈amo chë s̈es̈ona chaotsabainama cha yojtsebos̈e ca. ");
INSERT INTO kbh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacaríasna jats̈ëmbombonana canÿe tablëbé tojanëyá y chiñe tojanábema: “Cha entsabaina Juan ca”. Y chë causa, nÿetscanga ojnanánënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Y cachora Zacarías jóyebuambayama yojtobenaye, y yojonts̈é Bëngbe Bëtsábioye jëtschuayana. ");
INSERT INTO kbh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chë juachañe oyenënga nÿetscanga tmojanëuatjaná, y Judeoca nÿetsca chë tjañenache luariñe ents̈anga chë soyëngama imojtsencuéntaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nÿetscanga chë soyëngama tmojántats̈ëmbona ora, chë́ngnaca corente chama imojtsejuabnaye y mënts̈á imojtsichamo: “¿Chë básetema, bëtsá ora nda yochtsemna ca?” Y ndegombre, Bëngbe Bëtsabe obenana cháftaca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chë Uámana Espíritu tbojanmandá ora, Zacarías, chë basetembe taitá, Bëngbe Bëtsabe mándoca jtsóyebuambnayëse, mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Chë Utabná, chë Israeloca ents̈angbe Bëtsá matschuanga, er cha tonjabo chabe ents̈anga jabújabuachama y jabátsebacama! ");
INSERT INTO kbh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Cha bochanjíchmua canÿe atsebacayá puerte obenana bomná, y cha echántsemna Bëngbe Bëtsabe oservená Davídbents̈ana ents̈á; ");
INSERT INTO kbh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nts̈amo Bëngbe Bëtsá bayté entsemna, chë chabe juabna oyebuambnayëngbiajana, chë chábenga imomnëngbiajana bënga s̈ojanas̈ebuachenacá, mënts̈á: ");
INSERT INTO kbh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Cha canÿa bochjanichmuá bëngbe uayayënga y nÿetsca uaboyënjëngbiama bënga jabátsebacama; ");
INSERT INTO kbh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","bëngbe bëtsë́tsangbioye jálastemama, y jenójuaboyama y jamama chabe uámana trato, ");
INSERT INTO kbh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nts̈amo Bëngbe Bëtsá, bëts taitá Abrahámbioye tbojans̈buachenacá. ");
INSERT INTO kbh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Cha tbojans̈buachená bëngbe uayayëngbiama bënga jabátsebacama, chca, bënga ndauatjcá Bëngbe Bëtsá jasérviama, ");
INSERT INTO kbh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y chabe ents̈angcá, nÿetsca soyënguiñe ts̈abá amënga, Bëngbe Bëtsabe delante nÿetsca te bëngbe vidënguiñe jëftsiyenama. ");
INSERT INTO kbh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Y aca, ats̈be básetemna, Bëngbe Bëtsabe juabna oyebuambnayá ca cmochantsábobuatma, ents̈ángbioye Bëngbe Bëtsabe soyëngama cochtsabuayiynama, Bëngbe Utabná cabá ndáshjango ora, bacna soyënga amana chamuajbanama; as Bëngbe Bëtsá chëngbe bacna soyënga echanjáperdonaye, y Bëngbe Utabná jabama mochantsopróntaye. ");
INSERT INTO kbh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Bëngbe Bëtsá bënga puerte s̈ualastemánayeca, canÿa bëngbe juabnënga binÿnayá bochanjíchmua, bënga chë bacna soyënga causa mo ibetiñcá y obanëngbe luarents̈cá vida bomnë́ngbioye jabátsebacama, y jabuátambama nts̈amo natjë́mbana jtsiyenana ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chë básetema yojonts̈é jobóchana y chabe espíritnaca puerte. Bayté, ents̈anga ndoyena luarënguenache cha yojëftsiyena, Bëngbe Bëtsá Israeloca ents̈ángbioye cha tojáninÿanÿentscuana. Chents̈ana, chamuábuatmanamna tojanonts̈é Israeloca ents̈ángbeñe jóyebuambayana. ");
INSERT INTO kbh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chë tempo yojamna canÿe Romoca bëts mandado, Augusto ca uabainá; y cha, chë natsanama tojanmandá nÿetsca ents̈anga chamuenábemama. ");
INSERT INTO kbh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chë soye tojanochnëngo Cirenio ca uabainá Sirioca mandado yojamna ora. ");
INSERT INTO kbh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chamna, nÿetscanga tojanotocá jtangana jenábemëngama, cada ona ndë́moca chëngbe bëts taitanga imojëftsiyena puebloye. ");
INSERT INTO kbh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","As, Josénaca Galilea luarents̈ana Nazaretocana yojë́ftsebocna y Judeoye, Belén puebloye, tojtaná. Tempo, Josebe bëts taitá rey David, Belenoca inoyena. Y José, Davídbents̈ana ents̈á inámnayecna, choye jenábemama tojtaná. ");
INSERT INTO kbh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Maríaftaca tojána jenábemama, y muana tbojans̈buachená Joséftaca jobouamayama. María ngomamaná yojtsemna, ");
INSERT INTO kbh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","y Belenoca ibojtsemnëntscuana, chë ora tbojanónts̈abuache jtses̈ócanama. ");
INSERT INTO kbh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Y chents̈e María ibojtsebomna chabe natsana s̈es̈ona, canÿe boyabásetema. Posadoca tondaye luare yontsemna causna, chata nÿe uacnëngbe átana tambuents̈e tbojanoquedá. Y Jesús tojanonÿná orna, María tbojtanëntsacjuá y canÿe bachetémiñe tbojanjajó. ");
INSERT INTO kbh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén béconana, chë ibeta, oveshënga abuajë́nÿanga shëntsjoca cachëngbe oveshë́ngaftaca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nÿe ndeolpe, Bëngbe Bëtsábiocana canÿe ángel tojánebëbuacna, y Bëngbe Bëtsábents̈ana corente yojtsebuashinÿinÿana chëngbe shëconániñe. Chama chënga puerte imojocochauatjaná. ");
INSERT INTO kbh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Chora chë ángel tojanë́yana: “Ndoñe matauatjëngana. Sënjabo ts̈abe soyënga tonjopasama jábuayenama, nÿetscanga chamóyejuama. ");
INSERT INTO kbh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mora chë David tonjanonÿná pueblents̈e canÿe s̈es̈ona tonjonÿná. Cha ts̈ëngaftangbe atsebacayá echántsemna y ts̈ëngaftangbe ents̈angbiámnaca. Cha endmëna chë Bëngbe Bëtsabe Uámana Uabuayaná, Cristo ca uabainá, y Bëngbe Utabná. ");
INSERT INTO kbh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndegombre chca entsemnama mënts̈á s̈mochanjátats̈ëmbona: canÿe s̈es̈ona ntsacjuaná y uacnëngbe bachetémiñe jajoná s̈mochanjínÿena ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Cachora, celocana mallajta angelënga chë natsana ángelbents̈e tmojánbocana y Bëngbe Bëtsábioye mënts̈á imojtsatschuanaye: ");
INSERT INTO kbh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Bëngbe Bëtsá, celoca entsemná matschuanga! Bëngbe Bëtsábioye yeunanëngbiama, Bëngbe Bëtsá corente entsoyejuá; quem luariñe chë́ngbeñe puerte ts̈abá chaotsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chents̈ana chë angelënga celoye tmojésanshëcuana. Y chora chë oveshënga abuajë́nÿanga tmojanonts̈é jeniyanana: “Belenoye cuajna, chë quem tojopasá soye jinÿama. Ndegombre, Bëngbe Bëtsá chë soye s̈ojanÿanÿé ca.” ");
INSERT INTO kbh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","As betsco tmojána y tmojánanÿena María, José y chë s̈es̈onatema bachetémiñe jajoná. ");
INSERT INTO kbh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chë s̈es̈ona tmojáninÿe ora, chënga tmojanacuntá Jesusbe bëtsë́tsata y chë ínÿengbioye, nts̈amo chë s̈es̈onbiama chë ángel tojanëyancá. ");
INSERT INTO kbh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nÿetscanga chë tmojanuenënga tmojanenjnaná ndayá chë oveshënga abuajë́nÿanga imojtsacúntama. ");
INSERT INTO kbh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero Mariyna nÿe cachabe ainanoca quem soyëngama más bën inétsenojuabnañe. ");
INSERT INTO kbh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chents̈ana, chë oveshënga abuajë́nÿanga tmojtaná Bëngbe Bëtsá atschuanaye, ndayá tmojáninÿama y tmojanuenama. Nÿets̈á tojanopasá lempe nts̈amo chë ángel tojanëyancá. ");
INSERT INTO kbh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Posufta te tojánashjache ora, chë basetémbioye chë más delicadents̈e base bobachtema tmojantëts̈e, Bëngbe Bëtsabe ents̈á bétsemnama chaotsinÿnama, nts̈amo judiënga imojanamancá; y Jesús ca tmojanabaye, nts̈amo chë ángel tbojaniyancá, María cabá ndoñe ngomamaná yontsemna ora. ");
INSERT INTO kbh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y chë tempo tojanóshjango, ndaye ora José y María yojtsamna jamana nts̈amo Moisesbe leyiñe iuayancá, ndayá jamama yojanmëncá, canÿe shembása Bëngbe Bëtsabe delante ts̈abia jtsatsmënama, canÿe s̈es̈ona tbojtsebomnents̈ana. Asna, Jerusalenoye tbojánata y chë básetema tmojanamba, Bëngbe Bëtsabe bëts yebnoca jinÿinÿiyama, ");
INSERT INTO kbh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","nts̈amo chë Bëngbe Utabná Moisésbioye tbojaniyé leyënguiñe iuayancá, mënts̈á: “Canÿe yebnents̈e chë natsana s̈es̈ona boyabása tojtsemnësna, Bëngbe Bëtsábioye cha jinÿinÿiyana chábioye chabotseservénama ca.” Chcasna, chë básetema Bëngbe Bëtsabe bëts yebnoye tmojanamba. ");
INSERT INTO kbh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Y tmojanamba janshana uta shlofts̈e, Bëngbe Bëtsá jëtschuayama, nts̈amo Bëngbe Utabnabe leyiñe yomandancá. Chiñe mënts̈á endayana: “Chë natsana s̈es̈ona chaojonÿná ora, boyabásetema tojtsemnëse, janshana s̈mochjuamba uta fchetnatémata o uta s̈es̈ona palomatémata, Bëngbe Bëtsá jëtschuayama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalenoca inamna canÿe bacó, Simeón ca uabainá; cha inamna nÿetsca soyënguiñe ts̈abá amá, y yojaniyena nts̈amo Bëngbe Bëtsá yomandacá. Cha yojanobátmana chë tempo ndaye ora, Bëngbe Bëtsá bochjanichmuá canÿa Israeloca ents̈anga cháuatsebacama. Y chë Uámana Espíritu chabe ainaniñe yojtsemna; ");
INSERT INTO kbh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","chíyeca, cabá lempe chca ndopása ora, cha yojtsetáts̈ëmbo cha ndoñe yochjanóbanama, chë Bëngbe Bëtsabe Uámana Uabuayaná ntjëftsinÿcá. ");
INSERT INTO kbh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chë Uámana Espíritu tbojanmandáyeca, Simeón Bëngbe Bëtsabe bëts yebnoye tojána; y Jesusbe bëtsë́tsata chë básetema tmojanamba ora, nts̈amo Moisesbe leyiñe iuayancá chabiama jamama ora, ");
INSERT INTO kbh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón tbojanocutsá y Bëngbe Bëtsábioye tbojtanchuá. Cha mënts̈á tojánayana: ");
INSERT INTO kbh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bëngbe Utabná, mora s̈molesenciá, ats̈e acbe oservená natjë́mbana jóbanana, er ya tconjama nts̈amo s̈conjans̈buachenacá; ");
INSERT INTO kbh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ats̈e chë ents̈angbe Atsebacayá sënjinÿe. ");
INSERT INTO kbh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aca cha tcojichmó nÿets luarenache ents̈angbiama. ");
INSERT INTO kbh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cha chë ndoñe judiëngbe juabnënga binÿnayá echántsemna; y chábeyeca, nÿets quem luarents̈e mochanjátats̈ëmbona, chë acbe ents̈angbiama, Israeloquëngbiama ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José y María ibojenjnanata nts̈amo Simeón Jesusbiama yojtsichámuama. ");
INSERT INTO kbh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Chents̈ana, Simeón Bëngbe Bëtsábioye tbojanimpadá ts̈abe bendicionënga chata chabotsebomnama chaomama; y María, chë Jesusbe mamábioye tbojaniyana: “Quem soyënga corente cmochanjacochtsets̈enaná, mo ainana espadë́jaca cuafjenëchnëngcá. Cha Israeloca banga echanjápochocaye y banga echanjátsebacaye; y chca, nts̈amo banga ainaniñe imojuabnacá echantsótats̈ëmbo. Israeloca banga quem básetema mochantsábotena y chabe palabrë́ngnaca ca” —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chénts̈naca yojtsemna canÿe shembása Bëngbe Bëtsabe juabna oyebuambnayá, Ana ca uabainá; cha yojamna Fanuelbe bembe y Aserbe pamillents̈á; ya bëtsananá cha inamna. Nÿe canÿsëfta uata cha yojë́ftsebouamna; ");
INSERT INTO kbh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","y chabe boyá tojanóbanents̈ana, cha posufta bnë́tsana y canta uata viudá inamna. Ndocna te Bëngbe Bëtsabe bëts yebnents̈ana yonjábocana, y chents̈e tojanoquedá bnëté y ibeta, Bëngbe Bëtsáftaca encuéntaye y cha atschuanaye; y chama, ba soye yojanamana tondaye ntjascá jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón, María y Josébioye yojtsëtsëtsnaye ora, Ana chë́ngbioye yojobeconá, y chë Atsebacayá tojanonÿnama Bëngbe Bëtsábioye tbojtanchuá chents̈ana, Jerusalenoca ents̈ángbioye, chë canÿe atsebacayá Israeloca ents̈angbiama imojanobatmanë́ngbioye tojanë́yana, chana Jesús yojétsemna ca. ");
INSERT INTO kbh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José y María lempe nts̈amo chë Utabnabe leyënguiñe iuayancá tbojanma ora, Galilea luaroye tbojtanata, cachëngbe puebloye, Nazaretoye. ");
INSERT INTO kbh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y chë básetema yojtsobóchaye, y más añemo yojtsejacana y más osertánana yojtsebomna. Y Bëngbe Bëtsá yojánama cha bëtscá ts̈abe bendicionënga chaotsebomnama. ");
INSERT INTO kbh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Chabe bëtsë́tsata ibojanamana cada uata Jerusalenoye jana Bashco fiestama, chë Bëngbe Bëtsá chë judiëngbe bëts taitángbioye Egiptocana tojánatsebacama jtenójuaboyama fiesta. ");
INSERT INTO kbh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús bnë́tsana uta uata tojánashjache ora, Jerusalenoye tmojána, nts̈amo imojanamancá. ");
INSERT INTO kbh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chë fiesta tojanopochocá chents̈ana, chabe bëtsë́tsata yebnoye ibojtsataye, y chata ntsetats̈ëmbcá, Jesusna Jerusalenoca yojtsoquedañe. ");
INSERT INTO kbh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chata ibojétsejuabnaye Jesús chë inÿe ents̈ángaftaca yojtsataboye ca; chcasna, canÿe te nÿets̈á benachëjana tbojánata ora, tbojanonts̈é chabe pamíllangbeñe y ubuatmë́ngbeñe jtsenguanguana, ");
INSERT INTO kbh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero ndoñe ibonjobenaye jtsinÿenana. As, chata chora Jerusalenoye tbojésanshëcona choca cha jetsenguanguama. ");
INSERT INTO kbh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Unga tianoye chata tbojanobená Bëngbe Bëtsabe bëts yebnents̈e cha jetsinÿenana. Chana chë Moisesbe ley abuátambayëngbe tsëntsaca inétsotbemañe, chë́ngbioye inayaunana, inatjanaye. ");
INSERT INTO kbh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nÿetsca ouenanënga imojtsenjnanaye Jesús ts̈a osertaná inamnama, y ts̈a ts̈abá jojuama cha yojtsobenama. ");
INSERT INTO kbh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chabe bëtsë́tsata chca tbojáninÿe ora, chátnaca ibojenjnaná. Chora, chabe mamá tbojaniyana: —Uaquiñá, ¿ndáyeca chca bëndátaftaca tcojama? Taitá y ats̈e corente enócochinÿenata cbondënguá ca. ");
INSERT INTO kbh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","As Jesús tojanë́yana: —¿Ndáyeca ats̈e s̈monguá? ¿Ndoñe s̈ondë́tats̈ëmbo ats̈e s̈omna ats̈be Taitabe yebnents̈e jtsemnana ca? ");
INSERT INTO kbh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero chë bëtsë́tsata ndoñe tonjanësertá nts̈amo cha tojanëyancá. ");
INSERT INTO kbh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chents̈ana Jesús chë bëtsë́tsataftaca Nazaretoye tojtaná y chata yojtsayaunana. Y chabe mamana nÿe cachabe ainanoca chë soyëngama más bën inétsenojuabnañe. ");
INSERT INTO kbh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús yojtsobóchaye y más juabna yojtsebomna; y Bëngbe Bëtsá y nÿetsca ents̈anga corente oyejuayënga chabiama imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bnë́tsana shachna uatama Tiberio César Romoca bëts mandado yojamna ora, Poncio Pilato yojamna Judeoca mandado, Heródesna Galileoca rey, chabe cats̈ata Felipe Iturea y Traconitoca rey, y Lisániasna Abilinioca rey. ");
INSERT INTO kbh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás y Caifás chë bachnangbe más uámana amëndayata ibojamna. Cach tempo, canÿe luare ents̈anga ndoyenents̈e Bëngbe Bëtsá tbojanatsëtsá Juánbioye; Juan, Zacaríasbe uaquiñá. ");
INSERT INTO kbh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","As Juan nÿetsca luarënguëjana Jordán béjaye béconana tojánachnëngo, ents̈anga mënts̈á utsëtsnaye: “Ts̈ëngaftangbe bacna soyëngama ngménaca s̈mochtenójuaboye, chca amana s̈mochtsajbaná y Bëngbe Bëtsabe benache s̈mochtishache. Chora cbochjúbaye, y Bëngbe Bëtsá ts̈ëngaftangbe bacna soyëngama cmochanjáperdonaye ca.” ");
INSERT INTO kbh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chë soye tojanopasá, cachcá nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayá Isaías chabe librë́s̈añe yojëftsabemcá. Cha mënts̈á tojanábema: Ents̈anga ndoyena luaroca canÿa enduáyebuache: “Bëngbe Utabná echanjabo ca; mo nda canÿe benache tojtseprontacá canÿe uámana ents̈á jashjanguama, cachcá, ts̈ëngaftángnaca, Bëngbe Utabná jabama ainanents̈e ts̈abe juabnë́ngaca s̈mochtseprontana. ");
INSERT INTO kbh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nÿetsca jachañe echantojútjia, y tjañe y batsjabenga mochantenájachibiaye. Chë scundma benachënga ndirichëjënga echántsatsmëna, y chë bacá mana benachënga mochantenájachibiaye. Mo chë chca tmojtsamëngcá, canÿe benache japróntana canÿe rey cháuashjanguama, ts̈ëngaftángnaca bëtscá s̈mochtseprontana ts̈ëngaftangbe ainaniñe, Bëngbe Utabná jabama. ");
INSERT INTO kbh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y nÿetsca ents̈anga mochanjinÿe chë Atsebacayá Bëngbe Bëtsábents̈ana jabana ca” —cha tojanábema. ");
INSERT INTO kbh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chë ents̈anga Juan chaubáyama imojánbocana ora, Juan yojanëtsëtsnaye: “¡Mëts̈cuaye ents̈anga! ¿Nda tcmënjáuyana chë echanjóshjango uabouana castigüents̈ana s̈mochjotsbocá ca? ");
INSERT INTO kbh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bëngbe Bëtsábeñe ndegombre os̈buáchiyënga s̈mochtsemna, as chca chaotsinÿna, ts̈ëngaftanga chë bacna soyënga amana ndegombre s̈mojtsajbanama. Y ndoñe s̈mattsejuabnaye cach ts̈ëngaftangbiama jayanama: ‘Bëngna Abrahámbents̈ana ents̈anga, Bëngbe Bëtsabe ents̈anga fsëndmëna ca’. Er ats̈e chanjayana, Bëngbe Bëtsá quem ndëts̈béngacnaca Abrahámbents̈ana ents̈anga nanjábiama. ");
INSERT INTO kbh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tats̈nía ya entsaprontana chë betiyeshënga tbëtëjëngocana jtseshatë́tsets̈ama. Ndaye betiye ndoñe tonjashájona, jtseshatëts̈ana y iñoye jtsatmets̈ana; ts̈ëngaftangaftácnaca cachcá, ts̈abe soyënga ndoñe s̈montsamëse, Bëngbe Bëtsá cmochanjácastigaye ca” —cha yojanëtsëtsnaye. ");
INSERT INTO kbh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Y as, ndayá jamama s̈ojtsamna ca? —chora chë ents̈anga tmojantjá. ");
INSERT INTO kbh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y Juan tojanë́jua: —Chë uta quëfsaíya uabomná bontsemna canÿiyá juts̈tayana chë tondaye tonduabomná. Saná bomná bontsemna juajatayana chë tondaye saná tondbomnábioye ca. ");
INSERT INTO kbh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Romocama ents̈ángbioye impuesto atjanayë́ngnaca jenábayama tmojánabo. Chënga Juánbioye tmojantjá: —Buatëmbayá, ¿ndayá jamama s̈ojtsamna ca? ");
INSERT INTO kbh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y Juan tojanë́yana: —Nÿe nts̈amo chë leyiñe yomandancá ents̈ángbioye crocénana s̈mochtsayëngacaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Básefta soldadë́ngnaca chábioye tmojantjá: —¿Ndayá jamama s̈ojtsamna ca? Y Juan tojanë́yana: —Ndocnábioye tondaye s̈matjáboca, ni jauátjanase, ni nÿe ndayámnaca bonamente jobuáchëse; y nÿe ntsachets̈á s̈macaná crocenánaca oyejuayënga s̈mochtsomñe ca. ");
INSERT INTO kbh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ents̈anga chë Bëngbe Bëtsabe Uámana Uabuayanabiama imojtsobátmana, y chëngna Juanbiama imojétsejuabnaye nderado cha chë Bëngbe Bëtsabe Uámana Uabuayaná nanjamna ca; ");
INSERT INTO kbh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","pero Juan tojanë́yana: “Ndegombre, ats̈e béjayeca cbondubáyana. Pero chë echanjabá ats̈biama corente más obenana endbomna, y ats̈e merecido taitsatobuajoñe ni mo jotsejbiyana chabe shecochëtjonëshents̈a corriëja jajafjonama. Chë Bëngbe Bëtsabe benache chamojtishachëngbiama, Bëngbe Bëtsá echanjama chë echanjabábeyeca, chë Uámana Espíritu chëngbe ainaniñe cháuamashënguama. Pero chë ndoñe chamontishachëngbiamna, Bëngbe Bëtsá echanjama chë echanjabábeyeca, chënga corente castigánënga chamotsemnama, mo iñeshequëcá. ");
INSERT INTO kbh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Canÿe ents̈á chabe mëts̈tá cucuats̈iñe jiyëbana, chabe trigo jtsóbobemama, y chë ndoservena shácuanënga jtsejashtsëtsana. Chabe trigo chë grano uaquëcjnaye tsañe jtsabuájuana, y chë ndoservena shácuanëngna íñeshoye jtsatmets̈ana. Cachcá, chë áts̈bents̈ana echanjabá, chë ts̈abe ents̈anga echanjúbuaja, y chë bacna ents̈angna íñeshiñe echantsacastígaye, y chë iñe ndocna te queochátsfsana ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chca y inÿe palabrë́ngaca Juan chë ts̈abe noticiëngama yojanabuayiyná. ");
INSERT INTO kbh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tempo, Juan Heródesbioye tbojanácacana, cha tojanobouamama cachabe cats̈ata Felipbe shémaftaca, Felipe cabá oyena ora; chana Herodías ca uabainá. Chama Juan tbojanácacana y nÿetsca bacna soyënga Herodes tojanmámnaca. ");
INSERT INTO kbh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes Juánbioye joyeunaye luariñna, cabá inÿe más bëts bacna soye tojátanma: Juánbioye cárceloye tbojtsanëtame. ");
INSERT INTO kbh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero Herodes Juánbioye cabá ndutame ora, Juan ba ents̈anga tojanëbaye, y Jesúsnaca tojánabo jenábayama. Ibojtsabayanëntscuana, Jesús Bëngbe Bëtsáftaca ibojtsencuéntaye; y chora celoca yojotëfjo, ");
INSERT INTO kbh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y chë Uámana Espíritu mo canÿe palomatemcá Jesúsbioye yojtsastjajuana; y celocana Bëngbe Bëtsá tbojaniyana: “Acna ats̈be bonshana Uaquiñá condmëna. Acbiama corente sëntsoyejuá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Jesús unga bnë́tsana uata yojtsebomna, ents̈ángbeñe Bëngbe Bëtsabe soyëngama jóyebuambayama yojonts̈é ora. Ents̈anga imojanjuabná Jesús Josebe uaquiñá yojamna ca. José yojamna Elibe uaquiñá. Elí Matatbe uaquiñá y Matatna Levibe uaquiñá. Leví yojamna Melquibe uaquiñá, Melqui Janabe uaquiñá y Jana Josebe uaquiñá. José yojamna Matatíasbe uaquiñá, Matatíasna Amosbe uaquiñá. Amós Nahumbe uaquiñá, Nahúm Eslibe uaquiñá y Esli yojamna Nagaibe uaquiñá. Nagai yojamna Maatbe uaquiñá, Maatna Matatíasbe uaquiñá. Matatías Semeibe uaquiñá, Semei Josecbe uaquiñá y Josec yojamna Judabe uaquiñá. Judá yojamna Joananbe uaquiñá y Joanán Resabe uaquiñá. Resa Zorobabelbe uaquiñá, Zorobabel Salatielbe uaquiñá, y Salatielna Neribe uaquiñá yojamna. Neri yojamna Melquibe uaquiñá, Melqui Adibe uaquiñá. Adi Cosambe uaquiñá, Cosam Elmadambe uaquiñá, y Elmadamna yojamna Erbe uaquiñá. Er yojamna Jesusbe uaquiñá y Jesús Eliezerbe uaquiñá. Eliezer Jorimbe uaquiñá y Jorimna Matatbe uaquiñá. Matat yojamna Levibe uaquiñá, Leví Simeonbe uaquiñá y Simeón Judabe uaquiñá. Judá Josebe uaquiñá, José Jonambe uaquiñá, y Jonamna yojamna Eliaquimbe uaquiñá. Eliaquim yojamna Meleabe uaquiñá, Melea Menabe uaquiñá. Mena Matatbe uaquiñá, y Matata yojamna Natanbe uaquiñá. Natán yojamna Davidbe uaquiñá, David Isaíbe uaquiñá y Isaína Obedbe uaquiñá. Obed Boozbe uaquiñá, Booz Salabe uaquiñá y Sala yojamna Naasonbe uaquiñá. Naasón yojamna Aminadabëbe uaquiñá, Aminadab Adminbe uaquiñá y Admin Arnibe uaquiñá. Arni Esrombe uaquiñá, Esrom Fáresbe uaquiñá y Fáresna yojamna Judabe uaquiñá. Judá yojamna Jacobëbe uaquiñá, Jacob Isaacbe uaquiñá y Isaacna Abrahambe uaquiñá. Abraham Tarebe uaquiñá y Taré yojamna Nacorbe uaquiñá. Nacor yojamna Serugbe uaquiñá, Serug Ragaube uaquiñá y Ragauna Pelegbe uaquiñá. Peleg Heberbe uaquiñá, y Heber yojamna Salabe uaquiñá. Sala yojamna Cainanbe uaquiñá, Cainán Arfaxadbe uaquiñá y Arfaxadna Sembe uaquiñá. Sem Noebe uaquiñá y Noé yojamna Lamecbe uaquiñá. Lamec yojamna Matusalenbe uaquiñá, Matusalén Enocbe uaquiñá y Enocna Jaredbe uaquiñá. Jared Mahalaleelbe uaquiñá, y Mahalaleelna yojamna Cainanbe uaquiñá. Cainán yojamna Enosbe uaquiñá, Enós Setbe uaquiñá, Set Adanbe uaquiñá y Adán Bëngbe Bëtsabe uaquiñá. ");
INSERT INTO kbh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Juan, Jesúsbioye tbojanabáyents̈ana, chë Uámana Espíritu Jesusbe ainaniñe yojtsemándaye. Jesús Jordán bejayoicana tojtaná y chë Uámana Espíritna ents̈anga ndoyena luaroye tbojanánatse. ");
INSERT INTO kbh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chents̈e canta bnë́tsana te tbojanjétana, y Satanasna yojanabó Jesús jisháchichiyama. Chë canta bnë́tsana tentscuana Jesús tondaye tonjanse, y cabana ibojeshë́ntsena. ");
INSERT INTO kbh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chora Satanás tojésanabo y tbojaniyana: —Aca ndegombre Bëngbe Bëtsabe Uaquiñá tcomnëse, momandá quem ndëts̈benga tandës̈e chaobiama ca. ");
INSERT INTO kbh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","As Jesús tbojanjuá: —Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Ents̈á nÿe tandë́s̈eca ndoñe vida ntsebomnana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chents̈ana, Satanás canÿe bëts tjoye tbojanánatse y betsco nÿetsca quem luarents̈a amëndayëngbenache tbojaninÿinÿé. ");
INSERT INTO kbh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chora Satanás tbojaniyana: —Ats̈e nÿets obenana cbochjáts̈etaye y lempe quem amëndayëngbenache yobinÿna soyë́ngnaca. Ats̈e lempe chca sënjóyëngacñe y sëntsobena jats̈etayama nda stsebos̈ábioye. ");
INSERT INTO kbh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aca chacojoshëntsaments̈é y chas̈cojadorase, lempe nÿets̈á acbiama echántsemna ca. ");
INSERT INTO kbh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chora Jesús tbojanjuá: —Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Acbe Bëtsá, chë Utabná cochtsadorana y nÿe cha cochtseservena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chents̈ana, Satanás Jerusalenoye tbojanánatse y Bëngbe Bëtsabe bëts yebnents̈e chë más tsbanánoca tbojanatsá, y tbojaniyana: —Aca ndegombre Bëngbe Bëtsabe Uaquiñá tcomnëse, muents̈ana fshantsoye montsënja, ");
INSERT INTO kbh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","er Bëngbe Bëtsabe uabemana palabrënguiñe endayana: Bëngbe Bëtsá chabe angelënga echanjichamuá, chacmotsinÿenama. ");
INSERT INTO kbh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chënga buacuats̈ë́ngaca cmochanjishache, shecuats̈e ndocá ndëts̈beñe chacondomama ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Chora Jesús tbojanjuá: —Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Ndoñe matsbos̈ana acbe Bëtsá chë Utabná bacna soyëngama jacochënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cabana, Satanás tojanajbaná bos̈ana Jesúsbioye bacna soyëngama jacochënguama, y bënama Jesúsbents̈ana tojtsanojuánañe. ");
INSERT INTO kbh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Chents̈ana, Jesús Galileoye tojesaná chë Uámana Espíritbe obenánaca, y nÿetsca ents̈anga chë luariñe chabiama imojtsencuéntaye. ");
INSERT INTO kbh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús yojtsabuátambaye chë judiëngbe enefjuana yebnënguenache, y nÿetscanga cha imojtsatschuanaye. ");
INSERT INTO kbh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chents̈ana Jesús Nazaretoye tojtanashjango, chë pueblents̈e cha tojanoboché, y ochnayté, nts̈amo cha yojanamancá, chë judiëngbe enefjuana yebnents̈e tojánamashëngo. Y chocna tojantsbaná Bëngbe Bëtsabe palabra jualíama. ");
INSERT INTO kbh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chë Bëngbe Bëtsabe juabna oyebuambnayá Isaíasbe librë́s̈a tmojaniyé chaualiama. Chë librë́s̈a yojutë́fjona orna, tojáninÿena mënts̈á uábemanents̈e: ");
INSERT INTO kbh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Chë Utabnabe Espíritu áts̈eftaca entsemna, er ats̈e uabuayaná stsemna chë Bëngbe Bëtsabe ts̈abe noticiënga chë ndbomnë́ngbeñe jóyebuambayama. Cha s̈onjichmó jábuayenama, chë utámenënga chents̈ana ya chamuáisebocanama; jamama chë jtanënga chamobenama ts̈abá jubínÿnama; jamama chë ínÿengbe causa imosufrínënga, tempcá cachcá ts̈abá chamotsatsmënama; ");
INSERT INTO kbh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y ents̈anga jáuyanama ndëmua ora chë Utabná chabe ents̈anga yochjatsebacaye ca.” ");
INSERT INTO kbh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús jualíama tojanpochocá y chora chë uajabuachanábioye chës̈a tbojtaniyé y tojtanótbema. Nÿetsca ents̈anga chë enefjuana yebnents̈e imojtsemnënga Jesúsbioye imojtsobuáuatja. ");
INSERT INTO kbh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chora Jesús tojanonts̈é mënts̈á jayanana: —Camënté ts̈ëngaftangbeñe tonjopasá nts̈amo quem librë́s̈añe iuabemancá ca. ");
INSERT INTO kbh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nÿetscanga Jesusbiama ts̈abá imojtsencuéntaye y ojnanánënga imojtsemna ts̈a botamana cha yojtsóyebuambnama. Y chënga imojtsentjanaye: —¿Quem boyabása ndoñe Josebe uaquiñá yondmëna ca? ");
INSERT INTO kbh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús yojtsetáts̈ëmbo nts̈amo cha tojánayaniñe chënga ndoñe tmonjanós̈buachema. As tojanë́yana: —Ndegombre ts̈ëngaftanga nts̈amo ents̈anga mondënts̈ayancá ats̈e s̈mochanjauyana: “Ashnayá, cach aca menoshná ca”. Y ts̈ëngaftanga s̈mojtsejuabná ats̈e jauyanama: “Bënga fsënjouena chë bëts soyënga Bëngbe Bëtsabe obenánaca Capernaumoca tcojamama. Nts̈amo contsichamcá ndegombre tojtsemnëse, cach acbe pueblénts̈naca cachcá moma ca”. ");
INSERT INTO kbh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y cachora Jesús más tojanoyebuambá, mënts̈á: “Ndegombre cbë́yana, ni canÿe Bëngbe Bëtsabe juabna oyebuambnayábioye cachabe pueblents̈e ts̈abá quematonÿá. ");
INSERT INTO kbh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ndegombre cbë́yana, Elías, chë Bëngbe Bëtsabe juabna oyebuambnayá, Israeloca inamna ora, ba viudanga chents̈e imojamna. Chë tempo, unga uata y tsë́ntsañe nÿets̈á ndoñe tonjanafté y bëts shëntsana chë luariñe yojtsebinÿna. ");
INSERT INTO kbh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Bëngbe Bëtsá, Elíasbioye ndoñe tbonjanichmó ni mo canÿe Israelents̈a viudábioye, y aíñe tbojanichmó ínÿoye, Sarepta ca uabáinoye, Sidón béconana, canÿe chents̈a viudábioye. ");
INSERT INTO kbh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eliseo, chë Bëngbe Bëtsabe juabna oyebuambnayá, Israeloca inamna ora, chents̈e banga imojamna bacna nguayanánaca s̈oquënga, y ni mo canÿa chents̈a s̈ocábioye tbonjanshná, pero aíñe canÿe s̈ocábioye, Naamán ca uabainá, cach bacna nguayanánaca, Siriocá ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chë judiëngbe enefjuana yebnents̈e imojtsemna ents̈anga chca tmojanuena ora, puerte tojánetëna. ");
INSERT INTO kbh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","As, chora chënga tmojantsbaná, chë pueblents̈ana Jesús imojtábocna y más tsjuanoye canÿe peñës̈ëjana imojuánatse. Chënga imojanajebna cach peñës̈iñe, y chë ents̈anga imojtsebos̈e Jesús chocana jtsajuatsënts̈ana. ");
INSERT INTO kbh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesusna chëngbe tsëntsajana tojánachnëngo y ínÿoye tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Chents̈ana, Jesús cach Galileoye tojesaná, Capernaum puebloye, y choca tojanonts̈é, chë ochnayté, chë judiëngbe enefjuana yebnents̈e ents̈anga jabuátambana. ");
INSERT INTO kbh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ents̈anga imojtsenjnanaye nts̈amo Jesús yojtsabuátambama, er chamna mo canÿe mando bomnacá yojtsóyebuambnaye. ");
INSERT INTO kbh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chë enefjuana yebnents̈e, canÿe boyabása bacna bayëja uambayá yojtsemna, y chabe causa chë boyabása tojanonts̈é mënts̈á uayebuáchana: ");
INSERT INTO kbh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Cachcá s̈monÿá! ¿Ndayama bë́ngbioye tëcjabo, Jesús Nazaretocá? ¿Tcojabo bënga jabétsapochocama? Ats̈e sëndë́tats̈ëmbo nda aca comnama, aca chë Bëngbe Bëtsabe Uamaná ca. ");
INSERT INTO kbh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chora Jesús chë bacna bayë́jbioye tbojtsanácacana y tbojaniyana: —¡Iytëca móbema y chábents̈ana maisebocna ca! As chora chë bayëja ents̈anguents̈e chë boyabásabioye tbojanshajayé, y ndocá ntjëftsemcá chábents̈ana yojésebocna. ");
INSERT INTO kbh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chë soyama nÿetsca ents̈anga imojénjnanaye y mënts̈á imojtsenatsëtsnaye: “¡Ts̈a chca palabrënga! ¡Quem ents̈á mandayacá y obenacá chë bayëjënga entsamë́nda, y chënga montsaisebocana ca!” ");
INSERT INTO kbh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y Galileoca nÿetsca pueblënguiñe Jesusbiama yojtsótats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chents̈ana, Jesús chë judiëngbe enefjuana yebnents̈ana tojë́ftsanbocna y Simonbe yebnents̈e tojánamashëngo. Simonbe uambén mamá s̈ocá inajájona jabuache calentóraca, y chë chents̈e imojtsemna ents̈anga chabiama Jesúsbioye tmojanimpadá. ");
INSERT INTO kbh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chora Jesús chë s̈ocábioye yojotsejbéna y tojánayana: “¡Calentora mojuaná ca!” Y chë calentora tbojtsanóbojuanañe. Y cachora, cha tojtantsbaná y tojanonts̈é chënga jobuácuedana. ");
INSERT INTO kbh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Shinÿe yojuenatjëmba ora, banga inÿe y inÿe s̈ocana bomnënga Jesúsbioye tmojanënatse, y cha nÿetsca s̈oquë́ngbeñe cucuats̈ënga tojanjajó y tojanashná. ");
INSERT INTO kbh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chora, ba s̈oquëngbents̈ana bacna bayëjënga imojtsaisebocana y mënts̈á imojtsanchembumbuana: “¡Aca chë Bëngbe Bëtsabe Uaquiñá condmëna ca!” Pero Jesusna yojtsëcácana y ndoñe tonjanalesenciá chamóyebuambama, er chë bayëjënga imnatáts̈ëmbo cha chë Cristo bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yëfsana tojanbinÿna ora, Jesús chë pueblents̈ana tojë́ftsanbocna, y canÿe luaroye, ents̈anga ndoyenoye tojtsanoñe. Pero ents̈anga tmojána cha jetsenguanguama, y cha yojtsemnoye tmojánashjajna. Chënga imojétsebos̈e Jesús cach pueblents̈e chaotsoquedáñama, ");
INSERT INTO kbh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","pero Jesús tojanë́yana: “Ats̈e s̈ontsemna chë ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama inÿe pueblënguenáchnaca jábuayenana. Chama Bëngbe Bëtsá s̈onjichmó ca.” ");
INSERT INTO kbh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y chents̈ana, Jesús yojánana Bëngbe Bëtsabiama ents̈ángbioye abuayiynaye, chë judiëngbe enefjuana yebnënguenache Judeoca. ");
INSERT INTO kbh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Canÿe te, Jesús, Genesaret ca uabaina uafjajónaye tsachañe yojtsemna ora, ba ents̈anga tmojánashjajna, y chënga ts̈a imojtsenajuatsënts̈naye Bëngbe Bëtsabe palabra jouenama. ");
INSERT INTO kbh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús, chë uafjajónaye tsachañe bécoñe tojáninÿe uta ena barquë́sha; chë beonga ashebuánayëngna barquë́shanguents̈ana tmojë́ftsanbocna atarraiëshangá jetsáboshabiama. ");
INSERT INTO kbh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús canÿe barquë́shañe tojánamashëngo; chësha Simónbesha inauamna. Chora Simónbioye mënts̈á tbojaniyana: “Quem tsacháñents̈ana chcoye mëyamba ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tojanótbema ora, Jesús chë barquë́shoicana tojanonts̈é ents̈anga jabuátambama. Jabuátambama tojanpochocá orna, Simónbioye tbojaniyana: —Shbuatsëntsoye barquë́sha mëyamba y ts̈ëngaftangbe atarraiëshangá s̈mochjushbuets̈e, beonga jashebuáyama ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero Simón tbojanjuá: —Buatëmbayá, nÿets ibeta fsëndanguá y tondaye chibiátashebuaye. Pero aca chca tcjayánayecna, cachiñe atarraië́sha chantëtëshbuets̈e ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tmojanëshbuets̈e orna, bëtscá beonga tmojánishëche y chëngbe atarraiëshangá tojanonts̈é jtsatanë́canana. ");
INSERT INTO kbh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","As, chë inÿe barquë́shañe imojtsemna enutë́ngbioye tmojánefjats̈ëmbo, jabújabuachama chamuábama. Chora chënga tmojánabo, y nÿets uta barquë́sha beóngaca tmojanajutjé. Ts̈a chë́ftanga causa, tojanonts̈é chë uta barquë́sha jtsenatjë́mbambana. ");
INSERT INTO kbh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pedro chca tojáninÿe ora, Jesúsbents̈e tojanoshëntsaments̈é y tbojaniyana: —¡Bëngbe Utabná, ats̈e bacna soye amá sëndmëna, chíyeca áts̈bents̈ana mojuaná ca! ");
INSERT INTO kbh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chë ts̈a beonga jashebuáyama Jesús tojanmama, Simón y chë cháftaca imojtsemnënga imojouatjaná. ");
INSERT INTO kbh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiago y Juan, chë Zebedeobe uaquiñata y Simonbe enutata, chátnaca auatjanánata ibojtsemna. Chora Jesús Simónbioye tbojaniyana: —Ndoñe matauatjana. Morscana, ents̈anga Bëngbe Bëtsabiama cochántsanguaye, y nÿe beonga ashebuanayá ndoñe quecochátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","As chora chë barquëshangá tsachoye tmojtanëyamba y lempe jéseboshjonëse, Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús canÿe pueblents̈e yojtsemna ora, chents̈e tojánashjango canÿe ents̈á bacna nguayanánaca s̈ocá. Chë s̈ocá Jesúsbioye tbojáninÿe ora, tojanoshëntsaments̈é y jubiaca fshantsóntscoñe yojotsejbéna y tbojanimpadá: —Bëngbe Utabná, aca tcojtsebos̈ëse, aca catjobenaye ats̈be s̈ocana jtsebojuánana ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","As Jesús cucuáts̈eca tbojánbojajo y tbojaniyana: —Aíñe, së́ntsebos̈e. ¡S̈ocana cbotsebojuaná ca! Y cachora chë s̈ocana tbojtsanóbojuanañe. ");
INSERT INTO kbh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chora Jesús tbojanmandá: —Ndocnábeñe chë soye cattsecuéntaye; nÿe Jerusalenoca báchnëbioye motsa, y cha cochjinÿinÿiye aca mora ya ts̈abá cojtsatsmënama; y chora cochjuáts̈ëmbona nts̈amo Moisés chabe leyiñe tojanmandacá, Bëngbe Bëtsábioye chama jëtschuayama, chca, nÿetsca ents̈anga chamotats̈ëmbona mora ya ts̈abá cojtsatsmënama ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ndayá Jesús yojtsamama más ents̈anga imojátats̈ëmbona, y ba ents̈anga imojtsójotoye chábioye joyeunayama y chëngbe s̈ocanëngama chauashnama. ");
INSERT INTO kbh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús yojanamana jtsoñana ents̈anga ndoyena luarëngoye y choca Bëngbe Bëtsáftaca ibnéncuentaye. ");
INSERT INTO kbh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Canÿe te, Jesús yojtsabuatambá ora, chents̈e básefta fariseunga y ley abuátambayënga imojtsetbiámana, Galileoca nÿetsca pueblënguents̈ana áshjajnënga, Judeoquënga y Jerusalenoquënga. Y chora Jesús s̈oquënga yojtsashnaye, Bëngbe Bëtsabe obenánaca. ");
INSERT INTO kbh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chora tojanopasá, básefta boyabásenga canÿe s̈ocá, jama ndobená, tjuashiñe choye imojuamba. Chënga imojétsebos̈e tsoye cha juambana, Jesús yojtsemnoye, ");
INSERT INTO kbh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero jamashjnama ndoñe tmonjanobená, ts̈a ents̈anga causa. Chcasna, gradasës̈ënguëjana chë yebnents̈a tsbanánoye tmojánas̈ëngo y bats̈á tejëshe tmojtsanjuaná. Chorna, chë atëfjnëjana chë s̈ocá tjuashiñe tmojanë́stjango, ents̈angbe tsëntsaca, Jesusbe natsanoica. ");
INSERT INTO kbh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús tojáninÿe cha chë s̈ocá jáshnama bétsobenama chënga puerte imojtsos̈buáchema. As, chë jama ndobenábioye tbojaniyana: “Bacó, acbe bacna soyënga tcbontseboperdoná ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chora chë ley abuátambayënga y chë fariseunga mënts̈á tmojanonts̈é juabnayana: “Quem boyabása ndoñe ts̈abá Bëngbe Bëtsabiama quenátichamo; mo chábioye cuafjoyenguangcá entsemna. Ndocna ents̈á quenátobena bacna soyëngama inÿa japerdónana; nÿe Bëngbe Bëtsá aíñe ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús yojtsetáts̈ëmbo nts̈amo chënga imojtsejuabnayama; as tojanë́yana: “¿Ndáyeca ts̈ëngaftangbe ainaniñe chca s̈mojtsejuabná? ");
INSERT INTO kbh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Ts̈ëngaftangbiama ndayá más paselo nántsemna ts̈ëngaftangbe delante jayanama: ‘Acbe bacna soyënga tcbontseperdoná’, o jayanana: ‘Matëtsbaná y motsa ca’? ");
INSERT INTO kbh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Y chca, morna ats̈e cbochanjínÿanÿiye, chë Bëngbe Bëtsá Ents̈á tbojanbemá quem luariñe obenana yobomnama, ents̈anga bacna soyëngama jáperdonama ca” —Jesús tojánayana. As Jesús chë jama ndobenábioye tbojaniyana: “Ats̈e cbëyana, matëtsbaná, tjuashe mesocñe y acbe yebnoye motsatoñe ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cachora chë jama ndobená tojtantsbaná ents̈angbe delante, chë cha inajájona tjuashe yojesocñe y Bëngbe Bëtsábioye atschuanaye chents̈ana yojtsatoñe. ");
INSERT INTO kbh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chama nÿetsca ents̈anga imojénjnanaye y Bëngbe Bëtsá imojtsatschuanaye. Y corente auatjanánënga imojtsichamo: “Mënté bëts soyënga tmonjinÿe ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chca yojochnëngüents̈ana, Jesús chents̈ana tojë́ftsanbocna y canÿe ents̈ábioye tbojáninÿe, Leví ca uabainá, chë ents̈ángbioye impuesto Romocama atjanayents̈e inétsotbemañe. Chora Jesús tbojaniyana: “S̈masto ca.” ");
INSERT INTO kbh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y Leví lempe tojésanboshjona, tojantsbaná y Jesús tbojanasto. ");
INSERT INTO kbh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chents̈ana, Levina bëts fiesta chabe yebnents̈e Jesusbiama yojama. Y chë fiestents̈e imojtsemna banga impuesto atjanayënga; y inÿe ents̈ángnaca mesë́shents̈e imojtsetbiámana. ");
INSERT INTO kbh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chora, chë fariseunga y chë ley abuátambayënga tmojanonts̈é chë Jesusbe uatsjéndayëngbiama podesca oyebuambnayana; y chë́ngbioye mënts̈á tmojanë́yana: —¿Ndáyeca ts̈ëngaftanga impuesto atjanayë́ngaftaca y bacna soye amë́ngaftaca s̈mojtsesá y s̈mojtsofs̈ës̈ná ca? ");
INSERT INTO kbh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Y Jesús tojanë́jua: —Salud bomnënga ashnayá ndoñe ntsëjabótana, pero s̈oquëngna aíñe. ");
INSERT INTO kbh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Y ats̈e ndoñe chiyátabo chë Bëngbe Bëtsabe bominÿiñe ts̈abá amënga jabáchembuama, sinó chë bacna soye amënga imomna ca juabnayënga Bëngbe Bëtsábioye jabáchembuama ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chora chënga Jesúsbioye tmojaniyana: —Juan chë Ubayanabe uatsjéndayënga y chë fariseungbe usetonënga monduamana ba soye Bëngbe Bëtsáftaca jtsencuéntayana, y chama ba soye tondaye ntjascá jtsemnana; pero acbe uatsjéndayënga nÿe nÿets tempo jesosañana y jesofs̈ës̈nañana ca. ");
INSERT INTO kbh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Chora Jesús tojanë́jua: —Chë boyabása bouamná chë ofjanë́ngaftaca tojtsemnëntscuana, chë́ngbioye saná ndoñe ntsabuáshebenana. ¿Nts̈amo chca ndoñe nántsemna? Chë tojobouamá cha chë́ngaftaca tojtsemnëntscuana, chë ófjanënga bëtscá jasana y cháftaca oyejuayënga jtsemnana. Pero ora echanjóshjango y chë boyabása chë́ngbents̈ana mochantsánatseñe; chora cocayé chë ófjanënga echántsamna tondaye ntjascá jtsemnana. Nts̈amo chë tojobouamá cha y chë ofjanë́ngaftaca endmëncá, cachcá endmëna ats̈e, ats̈be uatsjendayë́ngaftacnaca ca —cha tojanë́jua. ");
INSERT INTO kbh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús mënts̈ánaca tojanacuntá jabuátambama: “Ndocná queonÿbatatëts̈e basájua tsëm ents̈ayañe, tanguá ents̈ayá jtarméndama. Chca tcojamëse, chë tsëm ents̈ayá jtsandbemana, y chë tcojuatëts̈e ents̈ë́jua chë tanguájuañe ndoñe ts̈abá ntsinÿnana. ");
INSERT INTO kbh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y cach ndoñe, chë tojtseshayana vínoye tanguá jasabenguiñe ntjataftsuámayana. Tcojuaftsuamasna, chë jasabenga jtseshébëfjuana y chë vínoye jtsabuáshanana; y chca, chë vínoye y chë jasabenga tondayama ntjatoservénana. ");
INSERT INTO kbh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chíyeca co, chë tojtseshayana vínoyna tsëm jasabenguiñe juaftsuámana. ");
INSERT INTO kbh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ndocná, chë bóchena vínoye tojatëmo y chents̈ana játsbos̈ana chë tojtseshayana vínoye jatofs̈iyana; cha jayanana: ‘Chë bóchena vínoye ts̈a ts̈abeye ca’.” ");
INSERT INTO kbh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Canÿe ochnayté, Jesús canÿe jajajana yojtsaye; chabe uatsjéndayënga trigo imojtsaiuatabnaye, imojtsaiúshenëcaye, y imojtsaiuasaye. ");
INSERT INTO kbh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chë causa, básefta fariseunga tmojanatjaye: —¿Ndáyeca s̈mojtsama chë ochnayté jamama ndoñe quenátslesenciana soye ca? ");
INSERT INTO kbh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Y Jesús tojanë́jua: —¿Ndoñe s̈mëndualía y s̈mondë́tats̈ëmbo, nts̈amo rey David y chabe enutënga tmojanmama shë́ntseca imojtsemna ora y jasama yojtsëjaboto ora? ");
INSERT INTO kbh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Chca orna, David Bëngbe Bëtsabe bëts yebnents̈e yojámashëngo y chë Bëngbe Bëtsá chents̈e yojamnama inÿinÿnaye tandës̈ënga yojase, y chë cháftaca imojánajna ents̈ángnaca yojáts̈ataye. Y chë tandës̈na nÿe bachnanga belesenciana jasama. Masque David chca yojama, Bëngbe Bëtsá chora ndoñe tonjánayana David canÿe bacna soye tojanma ca —Jesús tojanë́jua. ");
INSERT INTO kbh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y Jesús más tojanë́yana: “Chë Bëngbe Bëtsá Ents̈á tbojanbemá, chë ents̈á ochnayté tojtsama sóynaca jtsemándayana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Inÿe ochnayté, chë judiëngbe enefjuana yebnoye Jesús tojánamashëngo y tojanonts̈é jabuátambana. Y chents̈e yojtsemna canÿe ents̈á, cats̈bioica cucuats̈e buashanëts̈e bomná; ");
INSERT INTO kbh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","y chë ley abuátambayënga y fariseunga chiñe imojtserrondana jinÿama nderado Jesús chë ochnayté chábioye tabuanjashna, as chca chënga jtsebomnama ndaye sóyeca Jesús mal jaquédana. ");
INSERT INTO kbh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús chëngbe juabna yojtsetáts̈ëmbo; asna chë buashana cucuats̈e bomna boyabásabioye tbojaniyana: “¡Motsbaná y chents̈e tsëntsaca motsa ca!” Y chë ents̈á yojotsbaná y ents̈angbe tsëntsaca yojotsaye. ");
INSERT INTO kbh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chora Jesús chë ínÿengbioye tojanë́yana: “¿Ndayá yojtselesenciana ochnayté jamana, canÿe ts̈abe soye o canÿe ndoñe ts̈abe soye? ¿Jatsbocana o jtsepochócana ca?” ");
INSERT INTO kbh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y nÿetscanga chabe chabuajana imojtsemnënga tojanënÿanÿé, y chë buashana cucuats̈e bomnábioye tbojaniyana: “Macuenÿanëjaná ca.” Y chë boyabása tojanacuenÿanëjaná, y ts̈abá chëts̈a yojtsatamna. ");
INSERT INTO kbh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero chë ínÿengna puerte tmojanotjayaná, y tmojanonts̈é enatsëtsnayana ndayá muanjobenaye Jesusbe contra jamana ca. ");
INSERT INTO kbh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chë tempo, Jesús tjoye tojána Bëngbe Bëtsáftaca jencuéntama; y nÿets ibeta cháftaca tbojanencuentá. ");
INSERT INTO kbh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tojanbinÿna ora, chabe ústonënga tojánachembo, y chënguents̈ana tojanëbuáyana bnë́tsana uta uatsjéndayënga, chë ndëmuanÿenga “chabe ichmónënga cánaca” tojanë́bobaye. ");
INSERT INTO kbh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chënga imojamna: Simón, chë Pedro cánaca Jesús tbojanabobayá; Andrés, Simonbe cats̈ata; Santiago y Juan, Felipe y Bartolomé, ");
INSERT INTO kbh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo y Tomás, Santiago, Alfeobe uaquiñá; Simón, chë celote ca uabobainá; ");
INSERT INTO kbh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, Santiagbe uaquiñá; y Judas Iscariote, chë más chcoye, Jesús uayayëngbe cucuats̈iñe bochjanboshjoná. ");
INSERT INTO kbh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chents̈ana, Jesús chë́ngaftaca chë tjocana tojtantsmá y canÿe jachañe tojanoquedá ba chabe ustonë́ngaftaca y ba inÿe ents̈ángaftaca. Ba ents̈anga choye tmojánabo Judeocana, Jerusalenocana y Tiro y Sidón, chë mar béjaye béconana pueblënguents̈ana, Jesúsbioye oído jabuájuama y chëngbe s̈ocanëngama chauashnama. ");
INSERT INTO kbh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y chábeyeca chë bacna bayëjbe juabna uambayënga ts̈abá imojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nÿetsca ents̈anga ts̈a imojtsebos̈e y ndayánaca imojtsama Jesús jabojajuama, er chábents̈ana bëts obenana yojtsóbocana y nÿetscanga yojtsashnaye. ");
INSERT INTO kbh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús chabe uatsjéndayëngbioye tojanontjes̈é y tojanë́yana: “Puerte oyejuayënga ts̈ëngaftanga, chë quem luarents̈a soyënga ndbomnënga, er Bëngbe Bëtsabe amë́ndayents̈a soyënga ts̈ëngaftangbiama entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Puerte oyejuayënga ts̈ëngaftanga chë mora oshëntsiyënga, er becá s̈mochantóshachaye ca. “Puerte oyejuayënga ts̈ëngaftanga chë mora s̈mos̈achenga, er chents̈ana s̈mochántsatenbiajuaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Puerte oyejuayënga s̈mochtsemna, ents̈anga chacmojtsë́buayënja ora, chacmojtsatë́buacana ora, chacmojtsëyanguá ora, y ts̈ëngaftanga ndoñe ts̈abá s̈montsama ca chënga chamojtsichamo ora, ts̈ëngaftanga ats̈be ústonënga bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chë te puerte s̈mochjóyejuaye, er celoca canÿe bëts uacanánana s̈mochántsebomna. Chëngbe bëts taitanga, cachcá chë Bëngbe Bëtsabe juabna oyebuambnayë́ngaftaca tmonjanma ca. ");
INSERT INTO kbh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pero ¡ts̈a lastema ts̈ëngaftanga bomnëngbiama, er mora oyejuayënga jtsemnama ya bëtscá s̈mojóyëngacñe ca! ");
INSERT INTO kbh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Ts̈a lastema ts̈ëngaftanga chë mora shachanëngbiama, er shëntsana s̈mochántsebomna ca! “¡Ts̈a lastema ts̈ëngaftanga chë mora oyejuayëngbiama, er ngménama s̈mochanjenóbos̈achna ca! ");
INSERT INTO kbh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Ts̈a lastema ts̈ëngaftangbiama nÿetsca ents̈anga ts̈abá chamojtsoyebuambná ora; er cachcá chëngbe bëts taitanga monjánama chë Bëngbe Bëtsabe ndoñe ndegombre juabna oyebuambnayë́ngaftaca ca!” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pero ts̈ëngaftanga, áts̈bioye ouenanënga cbë́yana: Ts̈ëngaftangbe uayayënga s̈mochtsababuánÿeshana; chë tcmojtsë́buayënjëngbiama ts̈abe soyënga s̈mochtsama; ");
INSERT INTO kbh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","chë ts̈ëngaftangbiama bacna soyënga bos̈ëngbiama, Bëngbe Bëtsá s̈mochtseimpadana ts̈abe bendicionënga chamóyëngacñama; chë tcmojóyanguanguëngbiama, Bëngbe Bëtsá s̈mochtseimpadana. ");
INSERT INTO kbh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nderado ndánaca cánÿoica tcmojajuebjants̈etase, cochjomiye chë ínÿoica cachcá chacmomama; nderado ndánaca quëfsaíya tcmojuábocana, cachcá cochjonÿaye acbe shabuanguanë́juanaca chauetsácñama. ");
INSERT INTO kbh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ndánaca chacmojotjañábioyna, jats̈etayana; y nda ndayánaca chacmojefcábioyna, ndoñe catjonts̈ínÿena chacmatoyema. ");
INSERT INTO kbh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Inÿengaftaca s̈mochtsama, nts̈amo chë ínÿenga ts̈ëngaftangaftaca chamotsamama s̈mojtsebos̈cá. ");
INSERT INTO kbh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ts̈ëngaftanga, nÿe chë tcmojtsababuánÿeshanënga s̈mojtsababuánÿeshanëse, ¿ndaye ts̈abe soye chca s̈mattsama?; er chë bacna ents̈ángnaca chca mondbétsama. ");
INSERT INTO kbh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O nderado, nÿe chë ts̈ëngaftangbiama ts̈abe soyënga tmojtsamëngbiama ts̈abe soyënga s̈mojtsamëse, ¿ndaye ts̈abe soye chca s̈mattsama?; er bacna ents̈ángnaca chca mondbétsama. ");
INSERT INTO kbh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","O nÿe chë cmochtëchenanguama s̈mojtsejuabnángbioye s̈mojúyents̈amëse, ¿ndaye ts̈abe soye chca s̈mattsama?; er chë bacna ents̈ángnaca mondbetsenánts̈amiana, chë́ngbents̈ana cachcá jtóyëngacñama jtsobátmanëse. ");
INSERT INTO kbh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero ts̈ëngaftangna cmontsamna chë uayayënga jtsababuánÿeshanana; y ts̈abe soyënga chëngbiama jtsamana y júyents̈amiana, chë́ngbents̈ana ndayánaca jtóyëngacñama ntjatobatmancá. Chca, ts̈ëngaftanga uacanánana cuenta canÿe bëts soye s̈mochanjóyëngacñe, y celoca endmëna Bëngbe Bëtsabe básenga s̈mochántsemna; Bëngbe Bëtsá chë ndochuanayë́ngaftaca y bacna ents̈angaftácnaca ts̈abia comna. ");
INSERT INTO kbh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Inÿengbiama lastemadënga s̈mochtsemna, nts̈amo ts̈ëngaftangbe Taitá yomncá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ndocá ínÿengbiama s̈mattsichamo chë ndoñe ts̈abá tmontsamama, y Bëngbe Bëtsá ndoñe queochátichamo ts̈ëngaftanga ndoñe ts̈abá s̈monjama ca. Inÿengbiama ndoñe s̈mattsichamo ndoñe ts̈abá tmonjama ca, y Bëngbe Bëtsá ndoñe queochátichamo ts̈ëngaftanga ndoñe ts̈abá s̈monjama ca. Inÿenga s̈mochjáperdonaye y Bëngbe Bëtsá cmochanjáperdonaye. ");
INSERT INTO kbh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Inÿengbioye s̈mochjats̈ataye y Bëngbe Bëtsá cmochántats̈ataye. Mo nda canÿe biaco medidiñe bëtscá tojajutjé, uashëshe y cmojtiyecá, Bëngbe Bëtsá cachcá cmochántats̈ataye. Nts̈amo ts̈ëngaftanga ínÿengbioye chas̈mojábiama, uabouana o ndoñe jabuache soyënga, Bëngbe Bëtsá cachcá ts̈ëngaftangbioye cmochanjábiama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús quem cuéntnaca tojánayana jabuátambama: “¿Canÿe jtaná nantsobena inÿe jtaná jtsanachayama? ¿Chca ndoñe nÿets útata ndaye tbuabents̈e buanjótsats̈e? ");
INSERT INTO kbh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chë uatsjendayá ndoñe ntsemnana chë buatëmbayabiama más bëtsá. Pero chabe uatsjéndayana chaojapochocá ora, cach buatëmbayacá jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","“Canÿa chabe bominÿiñe canÿe niñëfja tojtsebomnëse, cha ndoñe ntsobenana chabe cats̈átbioye jauyanana: ‘Acbe bominÿents̈ana canÿe polvështema jtsebuchjátsëcama s̈molesenciá ca’. Natsana cha bontsemna cachabe bominÿents̈ana chë niñëfja jtsenobuchjátsëcana, ts̈abá jinÿama jobenayama, chabe cats̈atbe bominÿents̈ana chë polvotema jtsebuchjátsëcama. ¡Cachcá entsemna acbiama, bacna ents̈á chë nts̈amo ndegombre tcojuabnacá ndinÿinÿnayá! Chë ts̈a bacna soye cojtsama ca acbe cats̈átbioye tcojauyana ora, cach aca ts̈a bëts bacna soyënga cojtsamama ntjenojuaboycá; y chca, aca jamana canÿe bacna soye. Natsana cmontsemna chë cach aca ndoñe ts̈abe soyënga cojtsamama ngménaca jshatenójuaboyana y chca amana jshétsajbanana, y chents̈ana cocayé cochantsobena acbe cats̈ata juajabuáchana nts̈amo ts̈abá yomncá chaotsamama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ndoñe queonÿbatsmëna, chë canÿe ts̈abe betiyiñe podesca soye jashájonana; ni canÿe ndoñe ts̈abe betiyiñe ts̈abe soye jashájonana. ");
INSERT INTO kbh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Betiyënga jtsabuatmana nts̈amo cada betiye tojtseshajcá. Uchmas̈ëshents̈ana quenátopodena higuëbé jocñana; ni uvas̈ë́s̈a, shëshënts̈a betiyents̈ana. ");
INSERT INTO kbh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chë ts̈abe ents̈ana, chabe ainanoca ts̈abe juabnënga bomnents̈ana jtsóyebuambnayana; y chë bacna ents̈ana, chabe ainanoca ndoñe ts̈abe juabnënga bomnents̈ana jtsóyebuambnayana. Er ndayá becá ainanoca tomnama ents̈á jtsóyebuambnayana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Ndáyeca ts̈ëngaftanga ats̈e s̈mnétsatsaye, ‘Utabná, Utabná ca’, y nts̈amo ats̈e stsichamcá ndoñe ntsamana? ");
INSERT INTO kbh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cbochanjáuyana ndacá yomna nda áts̈bioye tojabo, ats̈be palabra tojouena y nts̈amo stsichamcá tojtsama: ");
INSERT INTO kbh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cha endmëna mo canÿe ents̈acá, nda canÿe yebna jajebuamna becá fshantse jashenoye yojajutjo y ndëts̈benguiñe yojúcuatjoye. Béjayënga yojtsóftjajna ora, chë yebnëjana yojobuachnëngo, pero ndoñe yonjobenaye juashajayana, er chë ndëts̈benguiñe jabuache yojaúcuatjona. ");
INSERT INTO kbh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero nda ats̈be palabra tojouena y nts̈amo stsichamcá ndoñe tontsama, endmëna mo canÿe ents̈acá, nda canÿe yebna yojajebo nÿe fshantsiñe, tondayiñe ntjucuatjoycá. Béjaye yojóftjango y jabuache chë yebnoye yojobuá ora, chë yebna yojtsáshajaye y lempe yojtsopochóca ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ents̈ángbioye chca jáuyanana tojanpochocá ora, Jesús Capernaum puebloye tojána. ");
INSERT INTO kbh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chents̈e yojoyena canÿe romano soldadëngbe amëndayá. Cha ibnabomna canÿe bochichnayá puerte bonshaná, y chora cha s̈ocá yojtsemna, ya jtsóbanama. ");
INSERT INTO kbh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesús ba s̈oquë́ngbioye yojáshnama encuéntayana chë amëndayá yojouena ora, báseftanga bëtsëjemëngcá amë́ndayënga cha tojanichamó, chauábama Jesús jaimpádama y chabe bochichnayábioye chabotseshnáñama. ");
INSERT INTO kbh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chënga Jesúsbioye tmojánashjango y ts̈a imojtseimpadana, mënts̈á: “Quem soldadëngbe amëndayá merecido entsebuájona chacotsájabuachama; ");
INSERT INTO kbh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","er cha bëngbe luarents̈a ents̈ángbioye corente endábabuanÿeshana, y cachá chë bëngbe enefjuana posada s̈onjayents̈jebo ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús chë́ngaftaca tojána. Pero chë mandayabe yebnoye imojtsebeconá ora, chë soldadëngbe amëndayá básefta amiguënga yojichamuá, Jesúsbioye mënts̈á chamuauyanama: “Ats̈be Utabná, ndoñe yapa matenócochinÿenana áts̈bioye jabama. Ats̈e merecido taitsatobuajoñe aca ats̈be yebnoye chacuamashënguama; ");
INSERT INTO kbh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","chíyeca ni mo añemo chiyatents̈etá jama aca jajébenguama. Morna nÿe cochjayana y ats̈be bochichnayá ts̈abá echántsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Er ats̈e sëndábamna áts̈bioye mándayënga y áts̈naca soldadëngbe amëndayá sëndmëna. Ats̈e canÿe soldádbioye stjauyana ‘motsa ca’, cha cachora jana; y ínÿabioye stjauyana ‘mabo ca’, cha cachora jabana; y nderado ats̈be bochichnayábioye ndayánaca chaomama stjamánda, chánaca cachora chë soye jamana ca” —cha yojáuyana. ");
INSERT INTO kbh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús chca tojanuena ora, chë mándayabiama yojenjnaná, y jobuértanëse chë ba ents̈anga cha ustonë́ngbioye tojanë́yana: “Ndegombre cbë́yana, ni mo nÿets Israelents̈e, ni canÿa quem boyabasacá ts̈a os̈buachiyá chiyátinÿena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y chë ichmónënga yebnoye tmojtaná orna, tmojáninÿena chë bochichnayá ya ts̈abá yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chca tojanopasá chents̈ana, Jesús yojétsaye Naín ca uabaina puebloye, y cháftaca chabe uatsjéndayënga y ba ents̈anga imojtsaye. ");
INSERT INTO kbh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chë pueblo amashjuanoye yojtsebeconá orna, ents̈anga chë pueblents̈ana canÿe obaná imojtsábocana jauátbontsama; chë obaná canÿe viudabe uaquiñá inamna y nÿe cha uaquiñá. Bëtscá ents̈anga chë obanabe mamá imojtsetjëmbambnaye. ");
INSERT INTO kbh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bëngbe Utabná chë viudábioye tbojáninÿe ora, chabiama tbojanongmé y tbojaniyana: “Ndoñe matos̈achena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y jobéconase, chë ataús̈e tojánbojajo, y chë obaná atambayënga tmojantsá. Y Jesús chë obanábioye tbojaniyana: “Bobontse, ats̈e cbëyana: ¡Matëtsbaná ca!” ");
INSERT INTO kbh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chora chë obaná tojtantsbaná y tojanonts̈é oyebuambnayana; y chabe mamábioye Jesús chë bobontse tbojtanánatse. ");
INSERT INTO kbh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nÿetsca ents̈anga ts̈a uatjana yojubuache chca tmojáninÿe ora, y Bëngbe Bëtsá imojtsatschuanaye, mënts̈á jayanëse: “Bë́ngbents̈e canÿe Bëngbe Bëtsabe juabna oyebuambnayá cuatënjonÿná ca.” Y mënts̈ánaca: “Bëngbe Bëtsá tojabo chabe ents̈anga jabújabuachama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y nÿets Judea luarëjana y chë chábuañe luarenache ents̈anga imojátats̈ëmbona ndayá Jesús tojanmama. ");
INSERT INTO kbh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan, lempe nts̈amo Jesús yojtsamama yojátats̈ëmbona; er chabe ústonënga chama tmojancuentá. As Juan, chënguents̈ana útata tojánachembo, ");
INSERT INTO kbh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y Jesúsbioye yojichamuá jatjayama cha tayojamna chë Cristo, chë jabama ibojanmëná, chë Uámana Uabuayaná, o ínÿabiama jatobátmama tayojétsamna ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","As chë Juanbe ichmónënga Jesúsbioye tmojanobeconá y tmojaniyana: —Juan chë Ubayaná s̈onjichamo jatjayama, aca ndegombre cojtsemna chë Cristo, chë jabama ibojanmëná, o s̈ojtsamna ínÿabiama jatobátmana ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chë ichmónata tbojánashjango ora, Jesús banga yojtsashnaye, s̈ocanëngama y tsets̈anëngama; bacna bayëjbe juabna uambayënga ts̈abá imojtsatsmëna, y jtanënga ts̈abá yojtsatëbinÿna. ");
INSERT INTO kbh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chora Jesús mënts̈á tojanë́jua: —Motsata y Juánbioye s̈ochjauyana nts̈amo s̈ojinÿe y s̈ojouencá: Chë jtanënga ts̈abá entsatëbinÿna, chë coshetënga ts̈abá montsatana, chë bacna nguayanánaca s̈oquënga shnánënga montsatsmëna, chë tësmënga montsuenana, chë obanënga tmontayena, y chë ndbomnëjémëngbioye chë ts̈abe noticiënga montsabuayiyná. ");
INSERT INTO kbh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Puerte oyejuayá chaotsemna, nda ats̈e ndoñe bacna soye stsama ca jtsejuabnayëse, áts̈beñe os̈buáchiyana ndoñe tontsajbaná cha ca! —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chë Juanbe ichmónata chents̈ana tbojésanbocnents̈ana, Jesús tojanonts̈é Juanbiama ents̈anga jáuyanana, mënts̈á: “Juan jinÿama s̈mojánbocna ora, ¿ndayá jinÿama s̈mojánbocana ents̈anga ndoyena luaroye? ¿Canÿe ents̈á ainaniñe tondaye añemo ndbomná, mo canÿe s̈ës̈e bínÿiaca shatiyeynës̈cá? ");
INSERT INTO kbh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Y ndóñese, ¿ndayá jinÿama choye s̈mojánbocana? ¿Canÿe boyabása uámana ents̈ayaca bopormaná? Ndoñe. Ts̈ëngaftanga s̈mondë́tats̈ëmbo chë uámana ents̈ayaca bopormánënga y chë bëtscá bomnánaca nÿe tondayama ntsecochinÿencá vida bomnëngna, reyëngbe yebnënguiñe mondbétsiyenama. ");
INSERT INTO kbh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Asna, ¿ndayá jinÿama choye s̈mojánbocana? ¿Canÿa Bëngbe Bëtsabe juabna oyebuambnayá? Ndegombre; y cbë́yana, canÿa Bëngbe Bëtsabe juabna oyebuambnayabiama más bëtsá. ");
INSERT INTO kbh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cha, Juan, endmëna ndabiama Bëngbe Bëtsá chabe uabemana palabrënguiñe tojánayana mo chabe ichmonacá, mënts̈á tojánayana ora: Cristo, ats̈be ents̈á natsana sënjichmó acbiama chaóyebuambama, ents̈anga jábuayenama aca jabama ainaniñe ts̈abe juabnë́ngaca chamotseprontánama ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ndegombre cbë́yana: Nÿets tempo ents̈ángbeñe, ndocná quenátsmëna Juan chë Ubayanabiama más bëtsá; masque chca, Bëngbe Bëtsabe amë́ndayoca chë más bats̈á uamaná, cha más bëtsá echántsemna nts̈amo mora Juan yomnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Nÿetsca ents̈anga chca Juánbioye tmojanóyeunanga y chë Romocama ents̈ángbioye impuesto atjanayë́ngnaca, nÿets ainánaca tmojánayana Bëngbe Bëtsá nÿetsca soyënguiñe ts̈abá amá yomna ca; er tmojánenabaye nts̈amo jubáyama Juan yojanamancá. ");
INSERT INTO kbh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero chë fariseunga y ley abuátambayënga, nts̈amo jubáyama Juan yojanamancá jóyëngacñama ndoñe tmonjánbos̈ena ora, tmojtsanaboté ndayá Bëngbe Bëtsá chëngbiama jamama yojanjuabnacá.” ");
INSERT INTO kbh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús mënts̈ánaca tojánayana: “Cbochanjáuyana ndayacá morsca ents̈anga imomna, y ndayëngcá chënga imomna. ");
INSERT INTO kbh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chënga mondmëna mo chë plazëngoca mondbetsetbiámana basetemëngcá; chëngna mënts̈á jabuache jtsenatsayana: ‘Ts̈ëngaftangbiama fsënjaflautá y ndoñe ches̈matslantsá; ngménaca fsënjaversiá y ndoñe ches̈matenóbos̈achna ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan chë Ubayaná tonjánabo y ndoñe quenjatamana bëtscá ents̈ángbeñe jtsemnana, ni tandës̈e jasana, ni vínoye jofs̈iyana; y ts̈ëngaftanga s̈montsichamo chana bacna bayëjbe juabna uambayá inamna ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Morna, chë Bëngbe Bëtsá Ents̈á tbojanbemá tonjabo y chana aíñe entsamana bëtscá ents̈ángbeñe jtsesayana y jtsofs̈ës̈nayana, y ts̈ëngaftanga chabiama s̈montsichamo: ‘Chana yapa uasayá y vínoye tmoyá entsemna y Romocama ents̈ángbioye impuesto atjanayënga y bacna soyënga amëngbe amigo ca’. ");
INSERT INTO kbh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero Bëngbe Bëtsá endbétsinÿinÿnaye cha nÿets osertánana bomná yomnama, chë ndayá cha tojama ora ndayá chents̈ana inobocna soyë́ngaca ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Canÿe fariseo Jesúsbioye tbojanofja saná jauasama, y Jesús chabe yebnoye tojána y mesë́shents̈e yojótbema. ");
INSERT INTO kbh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chë pueblents̈e yojamna canÿe shembása, bacna vida bomná. Jesús chë fariseobe yebnents̈e yojtsesama chë shembása yojátats̈ëmbona; as cha chë yebnoye tojánashjango y tojanamba canÿe alabastro botellës̈e, jútjena canÿe botamana uanguëts̈e béjayeca. ");
INSERT INTO kbh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesusbe shecuats̈ents̈e yojoshëntsaments̈iye, s̈achénaca; shëchbuíyeca chabe shecuats̈ënga yojtsefchecuacná y cachabe stjënashaca ibojtsatsshécbojuaye. Chabe shecuats̈ënga yojtonguëtsënts̈iye y chë botamana uanguëts̈e béjaye ibojtashecbués̈cacja. ");
INSERT INTO kbh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chë fariseo Jesúsbioye ofjaná chca tojáninÿe ora, mënts̈á Jesusbiama yojtsejuabnaye: “Cha ndegombre canÿe Bëngbe Bëtsabe juabna oyebuambnayá tojtsemnëse, nantsetáts̈ëmbo nda y mocna shembása yomna chë bontsebana shembása: canÿe bacna vida bomna shembása ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","As Jesús chë fariséobioye tbojaniyana: —Simón, cuentado palabra s̈motsoyeuná ca. Y chë fariseo tbojanjuá: —Arseñor, Buatëmbayá ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y Jesús tojánayana: —Canÿe ents̈á crocénana uyents̈amianá, uta ndebénata yojánabamna. Canÿa shachna patse denario crocénana ibojandebena, y chë ínÿana, shachna bnë́tsana. ");
INSERT INTO kbh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero chë útata tondaye ibontsebomna ndayents̈ana cha jëtsënts̈abuáchiyama; as chë uyents̈amianá nÿets útata chë ndebénana yojtsaperdónaye. Chora chë fariséobioye tbojaniyana: —Mora s̈mëyana, ¿chë útatents̈ana nda más chë uyents̈amianábioye buantsebobonshana ca? ");
INSERT INTO kbh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Y Simón tbojanjuá: —Ats̈e s̈ontsinÿana chë más bëtscá ndebená ca. Y Jesús tbojaniyana: —Ndegombre, nts̈amo endmëncá tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús, chë shembásabioye jontjes̈iyëse, Simónbioye tbojaniyana: —Minÿe quem shembása. Ats̈e acbe yebnoye sënjámashëngo y aca búyeshe ndoñe ches̈catabuats̈etá ats̈be shecuats̈ëngama. Y quem shembásana, cachabe shëchbuíyeca s̈ontseshecjabebé y chabe stjënashaca s̈ontseshecbojó. ");
INSERT INTO kbh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ndoñe ches̈catámocho, pero cha tonjámashëngo orscana ndoñe ntjájbanana ats̈be shecuats̈ënga onguëtsënts̈naye. ");
INSERT INTO kbh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Aca bests̈as̈iñe aceitiye ndoñe ches̈catsbues̈cja, y chana aíñe botamana uanguëts̈e béjaye s̈onjashecbues̈cja. ");
INSERT INTO kbh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chcasna ats̈e cbëyana, cha s̈onjinÿanÿé ats̈biama corente bonshánana yojtsebomna, er ats̈e chabe bëtscá bacna soyënga sëntseboperdoná; pero nda nÿe básefta bacna soyëngama stjaperdóna chana, nÿe bats̈atema bonshánana jtsebomnana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y chora Jesús chë shembásabioye tbojaniyana: “Acbe bacna soyëngama perdonaná contsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Chora chë ófjanënga chents̈e imnatbiámanëngna tmojanonts̈é enatsëtsnayana: “¿Nda quem ents̈á yojtsemna, chë bacna soyëngámnaca ents̈ángbioye jtsaperdónayana ca?” ");
INSERT INTO kbh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y Jesús más chë shembásabioye tbojaniyana: “Aca áts̈beñe icos̈buachéyeca, atsbocaná cochántsemna; natjë́mbana motsatoñe ca.” ");
INSERT INTO kbh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chca tojanopasá chents̈ana, Jesús bëts y base pueblënguëjana yojánana, ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama ents̈anga abuátambaye y abuayiynaye. Chë bnë́tsana uta uatsjéndayëngna cháftaca imojtsajna. ");
INSERT INTO kbh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Básefta shembásengnaca imojtsetjëmbambnaye; chë́ngbents̈ana Jesús bacna bayëjënga tojtanëbuacna y s̈ocanëngama tojanashná. Chënga imojamna, María chë Magdalena ca uabobainá, ndábents̈ana Jesús canÿsëfta bacna bayëjënga tojtanëbuacna; ");
INSERT INTO kbh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, Cuzbe shema (Cuza yojamna rey Heródesbe canÿe uajabuachaná); Susana y inÿe shembásenga; chëngna chë imojánbomna soyë́ngaca chë́ngbioye imojanëjabuáchana. ");
INSERT INTO kbh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ba pueblënguents̈ana mallajta ents̈anga tmojánbocana Jesús jinÿama. Ba ents̈anga jouenama tmojanobeconá ora, Jesús mënts̈á tojanacuntá: ");
INSERT INTO kbh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Canÿe, canÿe jená jénaye jaujquëshama yojë́ftsebocna. Yojtsëjquëshaye orna, básefta jénaye benache juachañe yojuatquë́cjana; chiñna ents̈anga imojtsebotájaye, y jaja shlofts̈ënga imojástjajna y imojtsósañe. ");
INSERT INTO kbh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Inÿe meshëngna ndëts̈benguiñe yojuatquë́cjana. Yojuábocna orna, betsco yojtsábojo, chë fshantsiñe ndoñe yapa búyeshe yonjamna causa. ");
INSERT INTO kbh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Inÿe meshëngna uchmë́shangañe yojuatquë́cjana y chë uchmëshangá lempe yojtsatscué, chë jénayeca cánÿiñe yojuábocna ora. ");
INSERT INTO kbh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Inÿe meshëngna, uanguaniñe yojuatquë́cjana. Yojuájua orna, bëtscá yojuashájona; canÿe jénayents̈ana nÿa mo patse meshënga yojuashájona.” Jesús chca jacuéntama tojanpochocá ora, tojanáyebuachena: “Chë jouenama tmojtsobenënga, s̈mochjouena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","As chora chabe uatsjéndayënga tmojantjá: —¿Nts̈amo chë cuento yojtsayana ca? ");
INSERT INTO kbh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y Jesús tojanë́yana: —Bëngbe Bëtsá ts̈ëngaftanga cmontsinÿanÿná nÿetsca chë mo iytëmencá yomna soyënga chabe amë́ndayama, pero chë ínÿengbioyna ndoñe; chë soyëngama chënga lempe cuentë́ngaca sëntsëtsëtsná. Chca, masque corente chamotsafs̈na, ndoñe chamondobená Bëngbe Bëtsabe soyënga jinÿama; y masque becá quem soyënga chamouena, ndoñe queochátësertana ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Chë cuento mënts̈á endayana: Chë jénaye Bëngbe Bëtsabe palabra entsemna. ");
INSERT INTO kbh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chë benache juachañe yojuatquë́cjana básefta jénaye endayana chë básefta ents̈anga Bëngbe Bëtsabiama soyënga tmojouenënga; pero chora Satanás betsco jabana chënga Bëngbe Bëtsabe palabra jabétsabuajuanama, chca, chënga ndoñe chamondëtsos̈buáchema y bacna soyënguents̈ana ndatsebácanënga chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Inÿe ents̈anga mondmëna mo chë ndëts̈benguiñe yojuatquë́cjana jenaycá. Chë ents̈angna Bëngbe Bëtsabe palabra jouenana y oyejuayënga jtsemnana. Pero ndoñe nÿets tempo chana jocochájuana; y chca, ndoñe bayté Bëngbe Bëtsáftaca ntjëftsemnëngana, cha ndoñe yapa tmontsas̈buaché causa. Inÿenga mochantsë́buayënja y Bëngbe Bëtsábeñe betsos̈buáchiyama mochanjasúfrianga; chë causa, Bëngbe Bëtsabe palabra cachcá chënga mochanjesonÿaye. ");
INSERT INTO kbh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Inÿe ents̈anga mondmëna mo chë uchmë́shangañe yojuatquë́cjana jenaycá. Chëngna Bëngbe Bëtsabe palabra jouenana, pero quem luarents̈a soyë́ngaca oyejuayënga jtsemnama yapa jesenójuabnayana, y mallajta crocénana y ba soyënga jtsebomnama yapa jésebos̈ana; chama y ba soyëngama yapa enócochinÿena causa, Bëngbe Bëtsabe soyëngama echantsebnë́tjomba y ndoñe quemochátama nts̈amo Bëngbe Bëtsá tojayancá. ");
INSERT INTO kbh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Inÿe ents̈angna mondmëna mo chë uanguaniñe yojuatquë́cjana jenaycá. Chëngna Bëngbe Bëtsabe palabra botamana mochanjouena; ts̈abe ainánaca Bëngbe Bëtsabe palabriñe jtsos̈buáchiyama jtseprontánëngana. Mo canÿe betiye puerte ts̈abá tojtseshajuancá, chënga bëtscá ts̈abe soyënga Bëngbe Bëtsabiama mochántsama. Chca mochántsama, Bëngbe Bëtsábeñe jtsos̈buáchiyëse y nÿetsca soyënguiñe puerte uantadënga jtsemnëse ca” —Jesús tojanabuayená. ");
INSERT INTO kbh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ndocná canÿe uajuinÿanë́sha juajuínÿenana, chents̈ana ndaye sóyeca chësha jtsëstama o jutsnë́sha tajsoye jtsajájuama; juajuínÿenana ndayá tsbanánoca juajájuama, chë luarents̈e amashjuanëngbiama chaotsebínÿnama. ");
INSERT INTO kbh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Er ndocna yoiytë́mena soye, ntjinÿcá queochaisoquéda, y chë ents̈angbiama ndótats̈ëmbo soye, ntsotats̈ëmbcá queochaisoquéda. ");
INSERT INTO kbh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Chcasna, botamana s̈mochjouena, er nda Bëngbe Bëtsabe soyëngama ts̈abá tbojosertá, Bëngbe Bëtsá echanjama cha más ba soyëngama chabosertama; pero nda chë soyëngama ndoñe tontsebos̈á, chë nÿe bats̈á ibosertana soyëngama bochántsebnatjëmba ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Chora, chabe mamá y chabe cats̈átanga chë Jesús yojtsemnents̈e tmojánashjajna, pero ndoñe imontsobena chábioye jobéconana, yapa ents̈anga causa. ");
INSERT INTO kbh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","As canÿa Jesúsbioye mënts̈á tbojaniyana: —Acbe mamá y acbe cats̈átanga shjoca montsemna y montsebos̈e aca jinÿama ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","As Jesús tojánayana: —Chë Bëngbe Bëtsabe palabra tmojouenënga y nts̈amo tmojouencá tmojtsamënga jtsemnana ats̈be mamá y ats̈be cats̈átanga, ats̈be ndegombre pamíllanguents̈ënga ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Canÿe te, Jesús chabe uatsjéndayëngaftaca canÿe barquë́shoye tojánamashëngo y chënga tojanë́yana: “Uafjajónaye chenguana cuajna ca.” As tmojána; ");
INSERT INTO kbh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","y imojtsenachnëjuanëntscuana Jesús yojtsomaná. Ndeolpe, chë béjayiñe corente jabuache binÿia yojóshjango y yojonts̈é béjaye chë barquë́shoye jtsobuajútjiana. Y chca, chëngbiama puerte resjo yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chora chë uatsjéndayënga tmojána Jesús jetsefs̈enama y mënts̈á tmojaniyana: —¡Buatëmbayá! ¡Buatëmbayá! ¡Montsenatjë́mbambana ca! Chora Jesús tojantsbaná y chë binÿia y chë bëts olëshëngoye tojanmandá: “Bonguana s̈ochtsemna ca.” Y chë binÿiayana tojanë́jbana y lempe bonguana yojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chents̈ana Jesús chabe uatsjéndayënga tojanë́yana: —¿Bëngbe Bëtsá ts̈ëngaftanga jujabuáchama yobenama, cabá ndoñe s̈montsos̈buaché ca? Y chënga auatjanánënga y ojnanánënga mënts̈á imojtsenatsëtsnaye: —¿Nda quem boyabása yomna? ¡Cha tojamandá ora, masque chë binÿia y chë béjaynaca joyeunayana ca! ");
INSERT INTO kbh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chents̈ana Gerasa ca uabaina luaroye tmojánashjajna, Galilea ndirichiñe. ");
INSERT INTO kbh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús fshantsoye tojánastjango ora, chë pueblocana canÿe ents̈á chábioye tojánabo. Cha ya bayté bayëjbe juabna yojtsebomna, ndocna ents̈ayá yonjanichë́tjona; y yebniñe ndoñe yonjaniyena, sinó obanëngbe cuevëshënguenache. ");
INSERT INTO kbh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chë ents̈á, Jesúsbioye tbojáninÿe ora, chabe natsanoica yojoshëntsaments̈iye y mënts̈á yojtsáyebuache: —¿Ndayá áts̈eftaca cojtsebos̈e, Jesús chë celoca Bëngbe Bëtsabe Uaquiñá? ¡Diosmanda ndoñe s̈catjatsets̈ená ca! ");
INSERT INTO kbh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chca tbojaniyana, er Jesús tojanmandá chë bacna bayëjbe juabna chábents̈ana chauesebocnama. Ba soye chë bayëja yojánama chë ents̈á ndoñe ts̈abá chaotsemnama. Chë ents̈anga imojuamana cucuats̈ents̈ana y shecuats̈ents̈ana cha jtsëtsbuayana bonguana chaotsemnama, pero chana jtsatabebiana, y chë bacna bayëjbe mándoca ents̈anga ndoyena luarëngoye yojánachana. ");
INSERT INTO kbh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús chë boyabásabioye tbojantjá: —¿Nts̈amo cabaina ca? Y cha tbojanjuá: —Ats̈e sënduabaina Legión ca. Cha chca tojánayana, er chábeñe ba bacna bayëjënga tmojánamashjna. ");
INSERT INTO kbh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y chë bayëjënga Jesús tmojanimpadá, chë corente uabouana tboye ndoñe chaondíchamuama. ");
INSERT INTO kbh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chents̈a béconana ba cots̈ënga imnajena, tjoca imnétsosañe; as chë bayëjënga Jesús tmojanimpadá chë cots̈ë́ngbeñe jamashjnama chaualesenciama, y Jesús aíñe chca tojanalesenciá. ");
INSERT INTO kbh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","As chë bayëjënga chë ents̈ábents̈ana tmojésanbocana y chë cots̈ë́ngbeñe tmojánamashjna; y chents̈ana, chë cots̈ënga batsjocana peñës̈ëjana uafjajónayoye imojtsoshbuets̈e y yojtsatajo. ");
INSERT INTO kbh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Chë cots̈ënga anÿenënga chca yojopásama tmojáninÿe ora, chents̈ana tmojtsanacheta y tmojána chë soye jacuéntama chë puebloca y chiñe luarenache. ");
INSERT INTO kbh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ents̈anga tmojánbocana ndayá tojanopasacá jinÿama, y Jesús yojtsemnoye tmojánashjajna ora, tmojáninÿe chë ents̈á chë ndábents̈ana bayëjënga tmojtanbocna, Jesusbe shecuats̈ents̈e yojtsótbemañe, ents̈ayá uichëtjoná y chabe nÿets juábnaca. Y chë ents̈anga chama corente imojouatjaná. ");
INSERT INTO kbh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nts̈amo yojopasacá tmojáninÿëngna ents̈ángbioye tmojanacuntá nts̈amo chca chë bacna bayëjbe juabna uambayá chora ya ts̈abá yojtsatsmënana. ");
INSERT INTO kbh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chents̈ana, nÿetscanga chë Gerasa luarents̈e oyenënga Jesúsbioye imojtseimpadana chë luarents̈ana ínÿoye chaotsoñama, er chënga corente imojtsauatja. As Jesús chë barquë́shoye tojtanamáshëngo y chents̈ana tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Chë ents̈á chë ndábents̈ana bacna bayëjënga tmojtanbocana, Jesúsbioye tbojanimpadá cháftaca jama chabolesenciama; pero cha ndoñe tbonjanlesenciá. Jesús tbojanmandá chauatoquedama y mënts̈á tbojaniyana: ");
INSERT INTO kbh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Acbe yebnoye motsatoñe y cochjácuntaye lempe nts̈amo Bëngbe Bëtsá acbiama tojamcá ca.” Chents̈ana chë boyabása yojtsatoñe, y nÿets pueblëjana tojanacuntá nts̈amo Jesús chabiama tojanmcá ");
INSERT INTO kbh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús chë uafjajónaye chenguánoica tojtanashjango ora, nÿetsca ents̈anga oyejuayënga tmojtanofja, er nÿetscanga chabiama imojanobátmana. ");
INSERT INTO kbh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chora tojánashjango canÿe ents̈á, Jairo ca uabainá. Cha inamna chë pueblents̈e chë judiëngbe enefjuana yebnents̈a mandayá. Jesusbe shecuats̈ents̈e yojoshëntsaments̈iye y ibojtseimpadana chabe yebnoye cháuama; ");
INSERT INTO kbh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","er chë nÿe canÿe bembe cha ibnabomná, bnë́tsana uta uata bomná, chora ya jóbanama yojtsemna. Y Jesús yojtsayëntscuana, chë ents̈anga chábioye imojtsojuatsë́nts̈enaye. ");
INSERT INTO kbh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chë ents̈anguents̈e yojtsaye canÿe shembása, oboftjajuanánaca s̈ocá; cha ya bnë́tsana uta uata chca inapadecena. Lempe nts̈amo yojanbomncá ashnayë́ngbioye atóbocayiñe yojtsepochóca, y ndocná yonjobenaye cha jáshnana. ");
INSERT INTO kbh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chë shembásana stëts̈oicana Jesúsbioye yojobeconá y chabe ents̈ayá sibuájua tojanábojajo. Y cachora chë oboftjajuanana ibojtsobojuána. ");
INSERT INTO kbh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chora Jesús tojanatjá: —¿Nda s̈jabojajo ca? Nÿetscanga imojtsichamo ndoñe ca; as Pedro tojánayana: —Buatëmbayá, ents̈anga cmontsatsënts̈ená y cmontsayájuatsënts̈enaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús cachiñe tojánayana: —Pronto nda s̈ojábojajo, er ats̈e sënjasenté obenana áts̈bents̈ana jóbocnana, mo nda stjashna orcá ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chë shembása tojáninÿe Jesús yojtsetáts̈ëmbo cha tbojánbojajuama. As chora, ngmëmnayá tojána y Jesusbe shecuats̈ents̈e yojoshëntsaments̈iye; y nÿetscangbe delante tojanobuambá, ndáyeca tbojánbojajuama, y nts̈amo cachora ts̈abá tojtanoquedama. ");
INSERT INTO kbh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chora Jesús tbojaniyana: —Bembe. Bëngbe Bëtsábeñe icos̈buachéyeca shnaná contsatsmëna. Natjë́mbana motsatoñe ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús cabá yojtsóyebuambnantscuana, chë judiëngbe enefjuana yebnents̈a mandayábiocana canÿa tojánashjango, y chë mandayábioye tbojaniyana: —Acbe bembe ya tontsóbana; ndoñe más chë Buatëmbayábioye matébëyabomana ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero Jesús chë soye tojanuena; as chë mandayábioye tbojaniyana: —Ndoñe matauatjana. Nÿe Bëngbe Bëtsábeñe cochtsos̈buáchiye y acbe bembe ts̈abá echántsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chë yebnoye tmojánashjajna ora, Jesús ndoñe tonjanalesenciá banga choye jamashjnama, nÿe Pedro, Juan y Santiago y chë shembásetembe bëtsë́tsatna aíñe. ");
INSERT INTO kbh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nÿetscanga imojtsenóbos̈achiye y ngménaca imojtsóyebuambnaye, pero Jesús tojanë́yana: “Ndoñe matenóbos̈achengana. Cha ndoñe chenatóbana; cha nÿe endëtsomañe ca.” ");
INSERT INTO kbh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chë ents̈anga Jesúsbioye nÿe imojtsáfchaye, er chënga imojtsetáts̈ëmbo chë shembásetema obaná yojétsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Chora Jesús chábioye tbojanábuacueshache y jabuache tbojaniyana: “¡Shembásetema, matëtsbaná ca!” ");
INSERT INTO kbh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y cha tojtanayena y cachora tojtantsbaná; y Jesús tojanamëndá chë shembásetema saná chamuajuats̈é, chaosama. ");
INSERT INTO kbh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chë shembásetembe bëtsë́tsata puerte ojnanánata ibojtsemna; y Jesús tojanamëndá, ndayá tojanopasama ndocnábeñe ntsecuéntayana. ");
INSERT INTO kbh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chents̈ana, Jesús chabe bnë́tsana uta uatsjéndayënga tojánachembo, y mando y obenana tojanats̈atá bacna bayëjënga ents̈ángbents̈ana jtëbuacanama y s̈ocanëngama jashnayama. ");
INSERT INTO kbh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tojanichamó Bëngbe Bëtsabe amë́ndayama jábuayenama y ents̈ángbioye jashnayama. ");
INSERT INTO kbh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y mënts̈á tojanë́yana: “Benachiñama tondaye s̈mattsambaye: ni jatjonëfja, ni shecnaja, ni saná, ni crocénana; ni inÿe ents̈ë́jua jenotrócama cach ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Canÿe yebnents̈e posada chacmojúyents̈ame ora, chents̈e s̈mochjoquéda inÿe puebloye játantscuana. ");
INSERT INTO kbh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nderado ndayents̈e posada ndoñe chacmonjuyents̈ame, chents̈ana s̈mochjésebocana y shecuats̈ents̈a polvëshe s̈mochjésenstoto, chca, chë́ngbioye jinÿanÿiyama chënga ndoñe ts̈abá ts̈ëngaftangaftaca tmonjamama ca” —Jesús tojanabuayená. ");
INSERT INTO kbh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Asna chë uatsjéndayënga tmojë́ftsanbocana y tmojána, nÿetsca chë base pueblotémënguenache chë ts̈abe noticiënga abuayiynaye y ents̈anga s̈ocanëngama áshnaye. ");
INSERT INTO kbh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jesusbiama y nts̈amo yojtsanopasánama rey Herodes tojántats̈ëmbona; y ndoñe yontsetáts̈ëmbo nts̈amo jtsejuabnayana, er báseftanga imojtsanichamo Juan chë Ubayaná obanënguents̈ana tojtanayena ca, ");
INSERT INTO kbh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ínÿenga imojtsanichamo chë Bëngbe Bëtsabe juabna oyebuambnayá Elías cachiñe tojánbocna ca, y ínÿengna canÿa chë tempo imojanmëna Bëngbe Bëtsabe juabna oyebuambnayënguents̈á obanënguents̈ana tojtanayena ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Heródesna tojánayana: “Cach ats̈e sënjanmandá Juanbe bests̈as̈e chamotsë́stjanguama. ¿As, nda cha nántsemna, chë ndabiama chca soyënga jtsóyebuambnayana sëntsuenana ca?” Chíyeca Herodes yojtsenguaye nts̈amo jamëse Jesús jinÿama. ");
INSERT INTO kbh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Chë Jesús tojánichamonga chábioye tmojtanashjango ora, lempe nts̈amo chënga tmojanmama tmojancuentá. Y Jesús, nÿe chënga jëftsëbiats̈ese ínÿoye tojtsanoñe, Betsaida ca uabaina puebloye. ");
INSERT INTO kbh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero chë ents̈anga chë soye tmojántats̈ëmbona, y as tmojanasto; y Jesusna ts̈abá chënga tojanë́buaja, y Bëngbe Bëtsabe amë́ndayama yojtsëtsëtsnaye, y chë s̈oquënga imojtsemnë́ngbioye tojanashná. ");
INSERT INTO kbh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ya jetiñe yojtsobiamná orna, chë bnë́tsana uta uatsjéndayënga Jesúsbioye tmojanobeconá y mënts̈á tmojaniyana: —Chë ents̈anga cuantichamuá, jóchnama y saná jonguangoñama chamotsama chë béconana pueblotémënguenache y luarënguenache; er quem luariñe ndocná quenatiyena ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús chora tojanë́yana: —Ts̈ëngaftanga saná chë́ngbioye s̈mochjacaredádaye ca. Pero chënga tmojanjuá: —Nÿe shachna tandës̈e y uta beónata fsë́ntsebomna; nÿetscangbiama saná jabuámiyama nderado nda tojasna, aíñe cuanjacaredádaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Er mo shachna uaranga boyabásenga imnamna. Pero Jesusna chabe uatsjéndayënga tojanë́yana: —Mamëndá nÿetscanga chamotbiamama shachna bnëtsátsanënga ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","As chënga chca tmojanma y nÿetsca ents̈anga tmojanotbiama. ");
INSERT INTO kbh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chora, Jesús chë shachna tandës̈e y chë uta beónata tojanca, y celoye tojanontjes̈é, Bëngbe Bëtsábioye chama tbojtanchuá, tojanjatá y chabe uatsjéndayënga tojanantregá ents̈ángbioye chamuats̈atama. ");
INSERT INTO kbh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nÿetsca ents̈anga tmojanse jtoshachaye nÿets̈á, y cabá bnë́tsana uta sbarëco tmojanajutjé chë ojamnëtémëngaca. ");
INSERT INTO kbh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Canÿe te, Jesús canÿa Bëngbe Bëtsáftaca ibojtsencuéntaye ora, chabe uatsjéndayënga cháftaca imojtsemna. Chora tojanatjá: —¿Nda ats̈e bétsemnama ents̈anga imojtsichamo ca? ");
INSERT INTO kbh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y chënga tmojanjuá: —Báseftanga montsichamo Juan ca, ínÿengna Elías ca, y ínÿengna canÿe Bëngbe Bëtsabe juabna oyebuambnayá tempscá mora tojtayena ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","As Jesús tojanatjá: —Y ts̈ëngaftangna, ¿nda ats̈e bétsemnama nts̈amo s̈mochjayana ca? Y Pedro tbojanjuá: —Acna chë Cristo condmëna, chë Bëngbe Bëtsabe Uámana Uabuayaná ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús corente chënga tojanamëndá ndocnábeñe chama ntsecuéntayana. ");
INSERT INTO kbh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y mënts̈á cachabiama tojánayana: —Chë Bëngbe Bëtsá Ents̈á tbojanbemá bontsemna puerte jasúfriana, chë judië́ngbeñe bëtsëjemëngcá amë́ndayëngbiama, chë judiëngbe bachnangbe más uámana amë́ndayëngbiama y ley abuátambayëngbiama uabotená jtsemnana. Ents̈anga mochanjóba, pero unga tianoye cha echántayena ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chents̈ana nÿetsca ents̈anga tojanë́yana: “Nda ats̈be uatsjendayá jtsemnama tojtsebos̈e, cháuayana nÿe Bëngbe Bëtsá yobena sempre chabe vidiñe jtsemándayama, chabe quem luarents̈a soyënga cachcá chauesonÿá ats̈e juastama, y cada te chaotseprontana áts̈beyeca jasúfriama, y cruciñe jobanámnaca. ");
INSERT INTO kbh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nda tojtsama quem luarents̈e bëtscá soyënga jtsebomnama y ats̈biama jasúfriama ndoñe tontseprontana, chë nÿetsca tescama yomna ts̈abe vida echanjobuets̈e. Pero nda quem luarents̈a soyënga cachcá tojëftsonÿá ats̈e juastama, masque chaóbana, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Er ¿ndayama ents̈á buanjosérvia nÿetsca quem luarents̈a soyënga jtsebomnana, cha pochocaná jtsemnama tojtsá y chë nÿetsca tescama yomna ts̈abe vida tojtsoperdese? ");
INSERT INTO kbh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Er ndëmuanÿe ents̈á, ats̈biama o ats̈be buayenana soyëngama tojtsëuatja, chë Bëngbe Bëtsá Ents̈á tbojanbemánaca chabiama echantsëuatja, cha chabe bëts buashinÿinÿaniñe chaojésabo ora, chabe Taitabe bëts obenánaca y chabe angelotémëngaftaca adoraná. ");
INSERT INTO kbh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndegombre cbë́yana, báseftanga muents̈e montsemnënga quemochatóbana, Bëngbe Bëtsá chabe obenánaca ents̈ángbeñe jabomándama jabana ntjëftsinÿcá ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mënts̈á tojanopasá: Chca palabrënga tojanoyebuambá chents̈ana posuftaytese, Jesús tojë́ftsanëbiats̈e Pedro, Santiago y Juan, y canÿe tjoye tojántsjua, Bëngbe Bëtsáftaca jencuéntama. ");
INSERT INTO kbh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bëngbe Bëtsáftaca ibojtsencuéntantscuana, chabe jubiá inÿets̈á yojtsinÿna, y chabe uichëtjonëjuangá ts̈a uafjantsëjuangá yojtsamna y ts̈a yojtsabuashinÿinÿana. ");
INSERT INTO kbh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chora uta boyabásata tbojanonÿná, Jesúseftaca ibojtsencuéntaye. Chata ibojamna Moisés y Elías; ");
INSERT INTO kbh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","corente buashinÿinÿaniñe ibojtsemna, y chënga imojtsencuéntaye nts̈amo Jesús Jerusalenoca jasúfriana y jóbanana. ");
INSERT INTO kbh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Masque Pedro y chabe enutata ts̈a ocnayënga imojtsemna, nÿe imojtsefs̈na y tmojáninÿe Jesusbe juachañe ts̈a yojtsebuashinÿinÿana y chë uta boyabásata cháftaca ibojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chë uta boyabásata Jesúsbents̈ana ibojoluára ora, Pedro, Jesúsbioye tbojaniyana: “Buatëmbayá, ¡ts̈a ts̈abá bëngbiama cuanmëna muents̈e jtsemnana ca! Mora fchanjapórma unga tambotémënga: cánÿetema acbiama, ínÿetema Moisesbiama y ínÿetemna Elíasbiama ca.” Pero Pedro ndoñe yontsetáts̈ëmbo nts̈amo yojtsichámuama. ");
INSERT INTO kbh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y chca yojtsóyebuambnantscuana, canÿe jants̈etëshe yojóbema, y chë́ngbioye yojáutsbotse, y chënga chë tsoye imojtsemnama tmojáninÿe ora, chë uatsjéndayënga chama imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chora chë jants̈etëshoicana canÿe oyebuambnayana tojanóbocna, mënts̈á: “Mua ats̈be Uaquiñá endmëna, ats̈be uabuayaná; cha s̈mochtseyeunana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chë oyebuambnayana tmojanuenents̈ana, tmojáninÿe Jesús canÿa yojtsemna. Chë uatsjéndayënga iytëca imojtsemna, y chë tempo ndocnábioye chama imonjuenaye. ");
INSERT INTO kbh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yëfsana, chë tjocana tmojtantsmá ora, ba ents̈anga tmojánbocana Jesús jajébenguama. ");
INSERT INTO kbh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chora, chë ents̈anguents̈ana canÿe boyabása tojanonts̈é mënts̈á uayebuáchana: —Buatëmbayá, Diosmanda ats̈be uaquiñá minÿe. Nÿe cha ats̈be uaquiñá endmëna; ");
INSERT INTO kbh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","y mora, bayëjbe juabna chábioye bontsësháchichana, y nÿe ndeolpe jónts̈ana yoyana, ataque joshachana y uayoicana shashiye jtsabocanana. Y chábents̈ana chë bayëja ndoñe betsco ntjésebocnana, y cuerpiñe corente maltrataná jeseboshjonana. ");
INSERT INTO kbh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Acbe uatsjéndayënga sënjaimpadá chë bayëja chábents̈ana chamuatábocnama, pero ndoñe chematobená ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","As Jesús tojánayana: —¡Nÿets̈á ndos̈buáchiyënga y bacna ents̈anga! ¿Buetayté s̈ojtsemna ts̈ëngaftangaftaca jëftsemnana y jtsëuantánana ca? Chora chë boyabásabioye tbojaniyana: —Moye chë uaquiñá mánatse ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chë basa yojtsebeconá ora, chë bacna bayëja chábioye tbojanshajayé y inÿe ataque tbojanëshache. Pero Jesús chë bayë́jbioye tbojanácacana, chë basetémbioye tbojanshná y chabe taitábioye tbojtanëntregá. ");
INSERT INTO kbh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y nÿetscanga puerte ojnanánënga imojtsemna, Bëngbe Bëtsá ts̈a obenana bomná inamnama. Nÿetsca ents̈anga, ndayá Jesús yojtsamama ojnanánënga imojtsemnëntscuana, chabe uatsjéndayënga cha tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Quem soye ts̈abá s̈mochjouena y ndoñe chacmondébnëtjomba: Chë Bëngbe Bëtsá Ents̈á tbojanbemá ents̈angbe cucuats̈iñe mochanjáboshjona ca.” ");
INSERT INTO kbh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero chënga ndoñe yontsósertana nts̈amo Jesús yojtsëtsëtsnacá, er Bëngbe Bëtsá ndoñe tonjanalesenciá chama chaósertama; y imojtsauatja Jesús jaimpádana chama chauabuayenama. ");
INSERT INTO kbh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chë tempo, chë uatsjéndayënga tmojanonts̈é enatsëtsnayana, nda chë más uamaná bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús yojtsetáts̈ëmbo nts̈amo chënga imojtsejuabnayama; asna, canÿe básetema tbojánishache, chabe juachaca tbojántbema, ");
INSERT INTO kbh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","y chë́ngbioye tojanë́yana: “Nda áts̈beñe os̈buachiyá bétsemnama, quem basetémbioye tbojofja, chana ats̈e jofjana; y nda ats̈e s̈ojofja, chana chë nda s̈ojichmó chábioynaca jofjana. Chíyeca, ts̈ëngaftanguents̈e chë más nduamaná, cha chë más uamaná entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan, Jesúsbioye tbojaniyana: —Buatëmbayá, bënga fsënjinÿe canÿe boyabása y cha aca jóts̈ëmbonëse, ents̈ángbents̈ana bacna bayëjbe juabna endëtëbuacana; pero cha bë́ngaftaca ndoñe quenátsmëna causa, chama fsënjesauyaná ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","As Jesús tbojanjuá: —Ndoñe s̈matjuauyaná; er nda bëngbe contra ndoñe tontsemná, bë́ngaftaca jtsemnana ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús celoye jtama yojtsobeco ora, nÿets añémoca cha yojtsejuabnaye Jerusalenoye jama. ");
INSERT INTO kbh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Natsana báseftanga tojanichamó, y chënga tmojána canÿe base pueblotémoye Samaria luaroca, posada chabiama janguangoñama; ");
INSERT INTO kbh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","pero chë luarents̈a ents̈anga ndoñe tmonjánbos̈ena posada juants̈amiana, er tmojántats̈ëmbona cha Jerusalenoye yojétsayama, chë chëngbe uayayëngbe uámana puebloye. ");
INSERT INTO kbh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chabe uatsjéndayata, Santiago y Juan, chë soye tbojáninÿe ora, Jesús tmojaniyana: “Bëngbe Utabná, ¿quectsebos̈e bëndata fchaimandá celocana íñeshe chaótsats̈e y quem ents̈anga chaotsapochócaye ca?” ");
INSERT INTO kbh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero Jesús yojobuértana y chátbioye tojtsanëcácana, chca juabna bomna causa. ");
INSERT INTO kbh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chents̈ana chënga inÿe pueblotémoye tmojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Benachëjana imojtsajna ora, canÿe boyabása Jesúsbioye tbojaniyana: —Ats̈be Utabná, ats̈e së́ntsebos̈e aca juastana ndë́moye chacojtsá choye ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Y Jesús tbojanjuá: —Chë zorrënga cuevëshënga mondbomna ndayents̈e jtsiyenama y chë shlofts̈etémëngna uajajonëshangá; pero chë Bëngbe Bëtsá Ents̈á tbojanbemá ndoñe quenátsbomna ndayents̈e jóchnama ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús inÿe ents̈ábioye tbojaniyana: —S̈masto ca. Pero cha tbojanjuá: —Ats̈be Utabná, s̈molesenciá ats̈be taitá chjshesabotbontsañe ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","As Jesús tbojaniyana: —Chë Bëngbe Bëtsabiama mo obanëngcá imomnënga, nts̈amo Bëngbe Bëtsá yomandacá ndoñe tmontsama causa, chënga cachëngbe obanënga chamotsë́tebuantsañe. Acna, motsa y Bëngbe Bëtsabe amë́ndayama ents̈anga cochjabuayená ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inÿana Jesúsbioye tbojaniyana: —Ats̈be Utabná, ats̈e së́ntsebos̈e aca juastama, pero s̈molesenciá natsana ats̈be pamíllangbiama jaisodiós̈oftama ca. ");
INSERT INTO kbh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","As Jesús tbojaniyana: —Nda cachabe soyëngama tbojtsengmena, Bëngbe Bëtsabe amë́ndayocama ndoñe ntsoservénana; er cha jtsemnana mo canÿe arayacá, chë tojtsetrabája ora, stëts̈oye tojtsaisantjes̈ncá ca. ");
INSERT INTO kbh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chë soyënga chents̈ana, Bëngbe Utabná Jesús inÿe canÿsëfta bnë́tsana y útatnaca tojanabacacá, y utáta chabe natsana tojanichamó, chë cha ibojtsemna jama pueblëngoye y luarëngoye. ");
INSERT INTO kbh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mënts̈á chënga tojanë́yana: “Canÿe bëts jajañe bëtscá játbanama entsemna, pero peonga báseftanga; chíyeca, chents̈a nduíñbioye jaimpádana ba peonga chauichamó chë jaja saná játbanama. Cachcá, quem luarents̈e bëtscá ents̈anga montsemna Bëngbe Bëtsábioye nduabuátmënga, y chë́ngbioye chabiama abuayiynayënga nÿe báseftanga. Chíyeca, Bëngbe Bëtsá moimpadanga ba abuayiynayënga chauichamó quem ents̈anga chábioye júbuajama. ");
INSERT INTO kbh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Motsajna; s̈mochjinÿe, ats̈e ts̈ëngaftanga cbontsichamná mo oveshënga cuenta, tjañe ques̈ë́ngbeñe. ");
INSERT INTO kbh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ndoñe s̈mattsambaye shecnaja, ni crocénana s̈mattsaiuábuenana, ni shecochëtjonëshe; y nda chacmojacheuá ora, ndoñe yapa bën chents̈e s̈matjáisenobiamnaye. ");
INSERT INTO kbh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ndaye yebnents̈e chas̈mojámashjna ora, natsana s̈mochjayana: ‘Lempe ts̈abá quem yebnents̈e chaotsomñe ca’. ");
INSERT INTO kbh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y chë yebnents̈e chca juabna bomna ents̈anga tmomnësna, chë ts̈abiana ndegombre chents̈e echántsemna; pero ndóñese, chca ts̈abiana chents̈e ndoñe queochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Canÿe yebnents̈e s̈mochjoquéda, y s̈mochjase y s̈mochjofs̈iye nts̈amo chents̈e chacmojacaredadaycá; er chë trabajayá merecido jtsebuájonana chca juácanama. Canÿe pueblents̈e nÿe inÿe y inÿe yebnënguenache ndoñe matajnana. ");
INSERT INTO kbh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ndaye pueblents̈e chas̈mojámashjna y ts̈abá chacmojúbuajents̈e, s̈mochjase nts̈amo chents̈e chacmojacaredadaycá; ");
INSERT INTO kbh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","chents̈a s̈oquënga s̈mochjáshnaye y s̈mochjáuyana: ‘Bëngbe Bëtsabe amë́ndayana ts̈ëngaftangbeñe entsemna ca’. ");
INSERT INTO kbh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero canÿe pueblents̈e chas̈mojáshjango y ndoñe chacmonjúbuaja, chents̈a tsashenangoye s̈mochjábocana y mënts̈á s̈mochjayana: ");
INSERT INTO kbh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Chë ts̈ëngaftangbe pueblents̈a polvëshe, chë bëngbe shecuats̈ënguiñe tojuanjëshe, camuents̈e fs̈cuesenstëtoná, chca, ts̈ëngaftanga chas̈motsetats̈ëmbuama ndoñe ts̈abá s̈monjamama! Pero masque chca, s̈mochtsetáts̈ëmbo chë Bëngbe Bëtsabe amë́ndayana ts̈ëngaftangbeñe entsemnama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndegombre cbë́yana, quem luare jopochócama te, chë luarents̈a ents̈ángbioye Bëngbe Bëtsá puerte jabuache echantsacastígaye, y Sodoma puebloca bacna ents̈ángbioye ndoñe nÿa nÿets̈á jabuache ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Ts̈a lastema Corazín puebloca ents̈angbiama! ¡Ts̈a lastema Betsaida puebloca ents̈angbiama! Er chë muents̈e Bëngbe Bëtsabe obenánaca sënjama soyënga, chë bëts pueblënga Tiro y Sidonoca chca matënjochnënguse, chents̈a bacna ents̈anga ya tempo chëngbe bacna soyëngama ngménaca matmëntenójuabonga y Bëngbe Bëtsabe benache matmë́ntishache, y chca tmojamama chaotsótats̈ëmbuama, uajojësha ents̈ayangaca matmëntopormanga y jatinÿashiñe matmënjotbiama. ");
INSERT INTO kbh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero nts̈amo ents̈anga tmojamama, ts̈abá o ndoñe ts̈abá bétsemnama jayanama chaojobuache ora, ts̈ëngaftanga más bëts castigo s̈mochántsebomna, chë Tiro y Sidonoca bacna ents̈angbe castiguama. ");
INSERT INTO kbh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y ts̈ëngaftanga, Capernaum pueblents̈a ents̈anga, ¿celóntscoca atsebánanënga s̈mochtsemna ca s̈mojtsejuabnanga? ¡Chë uabouana infiernoye cmochantsë́setjango! ");
INSERT INTO kbh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Nda ts̈ëngaftanga tcmojoyauná, chana ats̈e joyeunayana; y nda ts̈ëngaftanga tcmojtsëbaté, chana ats̈e jtsabotena; y nda ats̈e s̈ojtsaboté, chana chë nda s̈ojichmó chábioye jtsabotena.” ");
INSERT INTO kbh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chë canÿsëfta bnë́tsana y útatna Jesús yojtsemnoye tmojtanashjajna, puerte oyejuayënga; y chábioye mënts̈á tmojaniyana: —¡Bëngbe Utabná, aca jóts̈ëmbonëse, chë bacna bayëjë́ngnaca s̈onjoyauná ca! ");
INSERT INTO kbh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y Jesús tojanë́yana: —Ndegombre. Y ts̈ëngaftanga Satanásbioye chca s̈montseyënjaná ora, entsemna mo Satanás celocana canÿe tcuinÿcá jtsotsats̈ana stjinÿcá. ");
INSERT INTO kbh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ats̈na obenana tcbonjats̈atá mëts̈cuayënga y alacranë́ngbeñe chas̈motsajnama, y bëngbe uayayá Satanasbe nÿets obenana jáyënjanama, ts̈ëngaftanga ndocá ntjapasacá. ");
INSERT INTO kbh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero móyejuanga, ndoñe chë bacna bayëjënga chacmóyaunama obenana s̈mojtsebomnama, sinó ts̈ëngaftangbe uabaina celoca ya yojtsábemanama, er ts̈ëngaftanga chë nÿetsca tescama yomna ts̈abe vida s̈mochántsebomna ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chora Jesús, chë Uámana Espíritbeyeca, corente oyejuayá tojánayana: “Ats̈e cbatschuá, Taita, celoca y quem luarents̈a Utabná. Aca, chë nÿe bats̈á tats̈ëmbënga tconjanÿanÿé, chë ts̈a tats̈ëmbënga y osertánëngbiama tcojaiytëme soyënga. Aíñe, chama cbontsadorana, Taita, aca chca chaotsemnama tcojábos̈enayeca. ");
INSERT INTO kbh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ats̈be Taitá lempe chca s̈onjats̈etá. Chë Uaquiñábioye ndocná corente quebnatábuatma; nÿe chë Taitá aíñe. Y chë Taitábioye ndocná corente quebnatábuatma; nÿe chë Uaquiñá aíñe, y ndë́muanÿengbioye chë Uaquiñá tojtsebos̈e nda chë Taitá yomnama jinÿanÿiyama, chë́ngnaca chë Taitábioye mochantsábuatma ca.” ");
INSERT INTO kbh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chents̈ana, Jesús chabe uatsjéndayëngbioye tojanobuértana y nÿe chë́ngbioye tojanë́yana: “¡Puerte oyejuayënga chë nts̈amo ts̈ëngaftanga s̈montsonÿacá jinÿama tmojtsobenënga! ");
INSERT INTO kbh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Er ats̈e cbë́yana, banga Bëngbe Bëtsabe juabna oyebuambnayënga y reyënga tmojánbos̈ena chë ts̈ëngaftanga s̈montsonÿá soyënga jinÿana, pero ndoñe tmonjáninÿe; y tmojánbos̈ena chë s̈montsuenana soyënga jouenana, pero ndoñe tmonjanuena ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Canÿe judiëngbe ley abuatambayá yojonts̈é Jesúseftaca jóyebuambayama, y jisháchichiyamna mënts̈á tbojantjá: —Buatëmbayá, ¿ndayá s̈ojtsemna jamana chë nÿetsca tescama yomna ts̈abe vida jtsebomnama ca? ");
INSERT INTO kbh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Y Jesús tbojanjuá: —¿Nts̈amo leyiñe iuábemana? ¿Ndayá chiñe condbétsaliaye ca? ");
INSERT INTO kbh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chë ley abuatambayá tbojanjuá: —“Chë Utabná Bëngbe Bëtsá cochtsebobonshana nÿets ainánaca, nÿets espíritoca, nÿets añémoca y nÿets juábnaca”; y “ndëmua ents̈ánaca cochtsebobonshana, nts̈amo cach aca cuenobobonshancá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chora Jesús tbojaniyana: —Ts̈abá s̈conjojuá. Chca cochtsama y chë nÿetsca tescama yomna ts̈abe vida cochántsebomna ca. ");
INSERT INTO kbh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero chë ley abuatambayá ts̈abá jenoquédamna Jesúsbioye tbojantjá: —Y ¿ndase chë ndëmua ents̈ánaca yomna ca? ");
INSERT INTO kbh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","As Jesús tbojanjuá: —Canÿe, Jerusalenocana Jericó benache canÿe ents̈á yojtsetsmá, y básefta salteadorënga imojébëbocna. Lempe imojtsefca, chë ents̈ayánaca; imojtsejants̈etaye y chents̈ana imojtsatóñënga, y chë ents̈á bats̈á obaná imojéseboshjona. ");
INSERT INTO kbh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ndeolpe, chë benachëjana canÿe judiëngbe bachna yojtsachnëjuana. Chë ents̈ábioye ibojinÿe ora, nÿe chabuacá yojtsëchnë́nguañe. ");
INSERT INTO kbh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cachcá, canÿe Levita, chë canÿe Bëngbe Bëtsabe bëts yebnoca trabajayá chëjana yojtsachnëjuana; y chë ents̈ábioye ibojinÿe orna, nÿe chabuacá yojtsëchnë́nguañe. ");
INSERT INTO kbh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Chorna, cach benachëjana canÿe samaritano ináboye. Chë ents̈ábioye ibojinÿe orna, ibojóngmia. ");
INSERT INTO kbh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chábioye yojobeconá, aceitiye y vínoyeca ibojáshna, y lisianënguiñe ents̈ë́juaca ibojuantsacjuá. Chabe couayiñe ibojëftsenjayiye, canÿe yebnoye posada uyents̈amianoye ibojuánatse, y chents̈e chábioye ibojëftsinÿena. ");
INSERT INTO kbh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yëfsana, chë samaritano uta denario crocénana yojenóbojatsëca, chë mo uta tesca trabajuama crocénana nÿets̈á, y chë posada nduíñbioye ibojesabuenaye, y mënts̈á ibojauyana: ‘Quem boyabása cochtsinÿena, y nderado más crocénana muabiama chacojenábojafjonasna, mëjana chaitísachnëjuana ora, cbochjabáisabuenaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Y chcasna, ¿chë unganguents̈ana nda cmojtsinÿana chë ents̈abiama yojtsejuabnaye cha cachacá ents̈á inamnama ca?” ");
INSERT INTO kbh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y chë ley abuatambayá tbojanjuá: —Chë ents̈abiama tbojanongmé cha ca. Y Jesús tbojaniyana: —Asna, motsa y cachcá cochjama ca. ");
INSERT INTO kbh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chents̈ana, Jesús benachëjana yojtsaye y canÿe base pueblotémoye tojë́ftsanamashëngo; y canÿe shembása Marta ca uabainá, chabe yebnents̈e tbojanofja. ");
INSERT INTO kbh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martna canÿe quenata ibnabomna, María ca uabainá. Cha Jesusbe shecuats̈ents̈e yojótbema chabe palabra jouenama; ");
INSERT INTO kbh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","y chëntscuana Marta ba soyënga yojtsama. Cha Jesúsbioye tojanobeconá y tbojaniyana: —Utabná, ¿tondayana cmontsents̈amna, ats̈be quenata nÿe canÿa chas̈onÿá lempe jamama ca? Mëyana chas̈uájabuache ca. ");
INSERT INTO kbh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Chora Jesús tbojanjuá: —Marta, Marta, bëtscá soyëngama contsenócochinÿena y contsenomants̈ná; ");
INSERT INTO kbh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero nÿe canÿe soye endmëna chë yoiyta soye jamama. María chca jamama tojobuáyana, chë más ts̈abe soye, y ndocná queochatsma cha chaotsajbanama ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Canÿe, Jesús Bëngbe Bëtsáftaca ibojtsencuéntaye canÿe luarents̈e. Tojanpochocá orna, canÿa chabe uatsjendayënguents̈á tbojaniyana: —Bëngbe Utabná, Bëngbe Bëtsáftaca jencuéntama s̈mabuatambá, nts̈amo Juan chabe uatsjéndayëngaftaca tojanmcá ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y Jesús tojanë́yana: —Bëngbe Bëtsáftaca chas̈mojtsencuénta ora, s̈mochjayana: Bëngbe Taitá, acbe uabaina chë más uámana uabainana chauesomñe. Acbe amë́ndayana chaóshjango. ");
INSERT INTO kbh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mënté s̈miyats̈atá, cada te s̈netsëjaboto tandës̈e. ");
INSERT INTO kbh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bacna soyënga fsënjama: s̈motsaperdónaye; er bë́ngnaca nÿetscanga chë bëngbiama bacna soyënga amë́ngbioye fsëndbetsaperdónaye. Bacna soyënga jamama s̈ojocochëngo ora, s̈cochjujabuache chca ndenobuíyama. ");
INSERT INTO kbh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús mënts̈ánaca tojanë́yana: “Nderado aca acbe bacóbioye tsë́ntseto ora tcojá y tcojauyana: ‘Bacó, Diosmanda unga tandës̈e s̈motsemná, ");
INSERT INTO kbh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","er canÿe ats̈be amigo yebnoca tonjáshjango y tondaye quetsátsbomna cha jonánjama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ndegombre, cha tsocana tcmojojuá: ‘Ndoñe s̈matébeyabomana. Bës̈ás̈a ya entsatámena y ats̈e y ats̈be básenga ya fsëntsocjá; ndoñe quetsátobena mora jotsbanana y chë tandës̈e jámnana ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndegombre, chë bacó ndoñe tonjotsbaná chë tandës̈e jámnama, cháftaca s̈uenatsëtsnámase, cha pronto jotsbanana chca uébëyabomana ndoñe tconjajbaná causa, y lempe nts̈amo cmojtsajabotcá cha cmochanjoyiye. ");
INSERT INTO kbh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chcasna, ats̈e cbë́yana: S̈mochjotjañe y Bëngbe Bëtsá cmochanjáts̈ataye; s̈mochjánguango y s̈mochanjínÿena; s̈mochjachembo y cmochanjébëtafjo. ");
INSERT INTO kbh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Er ndánaca ndayá tojtsotjanañá, jóyëngacñana; y tojtsenguá cha, jónÿenana; y nda tojtsechembuanábioye jebiatëfjuana ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Nda ts̈ëngaftanguents̈ana nantsobena, taitá tojtsemnëse, cachabe uaquiñábioye canÿe mëts̈cuaye jats̈tayana, beona tbojtsotjanañe ora; ");
INSERT INTO kbh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","o canÿe alacránashe joyiyana, shëmnëbé tbojtsotjanañe ora? ");
INSERT INTO kbh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Y chca, ts̈ëngaftanga, bacna soyënga amënga, ts̈ëngaftangbe basetemë́ngbioye ts̈abe soyënga jats̈atayama s̈mojtsamanëse, ¡más chë celoca Taitá, chë Uámana Espíritu echanjáts̈ataye, chca tmojtsotjanañë́ngbioye ca!” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús canÿe ents̈ábents̈ana canÿe bacna bayëja tbojtanábocna. Chë bayëja ndëbiá chë ents̈ábioye tbojánbema, y chábents̈ana tojésanbocna ora, chë ndëbiá tojtanonts̈é oyebuambnayana. Y chë ents̈anga chama imojenjnaná; ");
INSERT INTO kbh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero báseftanga imojtsichamo: “Beelzebú, cach Satanás, chë bacna bayëjëngbe amëndayá, quem boyabásabioye obenana tbojats̈etá chë bayëjënga chauatëbuacnama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y ínÿenga, Jesús jisháchichiyamna tmojanimpadá canÿe bëts soye chaoma, jinÿanÿiyama cha celoca obenana inabomna o ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús yojtsetáts̈ëmbo nts̈amo chëngbe juabna bétsemnana. As tojanë́yana: “Canÿe amëndayábents̈e ents̈anga tmojtsenojatá y tmojtsenáyase, cachënga jtsenpochócana; y canÿe yebnents̈e oyenënga tmojtsenojatá y tmojtsenáyase, chë pamíllanga ts̈abá nÿets tempo ndoñe quemochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Cachcá, Satanás tojtsenojatá y cachabe contra tojtsemnëse, ¿nts̈amo nantsobena chabe mándayana quem luarents̈e jëftsebomnana? Chca së́ntsichamo, er ts̈ëngaftanga s̈montsichamo Beelzebube obenánaca chë bayëjënga stsatëbuacana ca; ");
INSERT INTO kbh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","pero chca ndegombre tojtsemnëse, ¿ndábeyeca ts̈ëngaftangbe usetonënga obenana imojtsebomna chë bacna bayëjënga jtëbuacnama? Chíyecna, cachënga montsinÿinÿná nts̈amo ndegombre yomnana, y ts̈ëngaftanga ndoñe ndegombre soye s̈montsichámuama. ");
INSERT INTO kbh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Y ats̈na, Bëngbe Bëtsabe obenánaca ents̈ángbents̈ana chë bayëjënga sëndëtëbuacana; y chë soye entsinÿinÿná, Bëngbe Bëtsabe amë́ndayana ts̈ëngaftangbioye tojóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Canÿe corente añemo bomna ents̈á, bëtscá ármangaca chabe yebna tojtsinÿenëse, chë tsoca tomna soyënga ndoñe ntjots̈ana. ");
INSERT INTO kbh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero inÿa chabiama más añemo bomná tojabo y tbojabetseyënjaná, chë cha yojanas̈buaché armangá jtsabocana y chë tobomna sóynaca; y nts̈amo chë inÿa tojtsebos̈cá chë soyë́ngaca jamana. ");
INSERT INTO kbh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nda ndoñe áts̈eftaca tontsemná, ats̈be uayayá jtsemnana. Y nda áts̈eftaca ndoñe tontsetrabája, chana ats̈be contra jtsetrabájayana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Canÿe bacna bayëja canÿe ents̈ábents̈ana tojésebocna ora, bojojo luarënguenache chë bayëja jtsanana, ndayents̈e jóchnama onguayiñe. Ndoñe tonjínÿena ora, jenójuaboyana: ‘Ats̈be oyenoye, chë ndayents̈ana sënjëftsebocnoye chanjesshë́cona ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y choye tojtashjango ora, jinÿenana lempe ts̈abá cha jtesamashënguama, mo tsjajniñe y prontániñe cuaftsemncá. ");
INSERT INTO kbh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chora chë bayëja jana y inÿe canÿsëfta bayëjënga, chabiama más opëjënga jobiats̈ana, nÿetscanga choye jamashjnama, chë boyabásabeñe joyénanama. Y chca, chë boyabása tempscama más bacna ents̈á jtoquédana, chora chë natsanama más bayëjënga abamna causa ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chë soyënga yojtsichamëntscuana, ents̈anguents̈e canÿe shembása yojuayebuáchena: —¡Puerte oyejuayá chë quem luaroye tcmojúshjango y tcmojëftseboché shembása ca! ");
INSERT INTO kbh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","As Jesús tbojaniyana: —Más oyejuayana bomnëngna, chë Bëngbe Bëtsabe palabra tmojouena y chca tmojtsamënga ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ents̈anga más imojtsójotoye Jesús yojtsemnents̈e, y Jesús tojanonts̈é jáuyanana: “Morsca ents̈anga puerte bacna ents̈anga; chënga montsotjanañe ats̈e canÿe bëts soye chaima ats̈be obenana jinÿama, pero ndoñe chca quemochátinÿe, sinó nÿe chë ndayá yomna mo chë Jonásoftaca tojanopasá soycá. ");
INSERT INTO kbh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Er chca, nts̈amo Jonás Nínive puebloca ents̈anga canÿe bëts soye tojaninÿanÿé Bëngbe Bëtsá obená yomnama chamotsetats̈ëmbuama, chë Bëngbe Bëtsá Ents̈á tbojanbemánaca entsinÿanÿná morsca ents̈ángbioye, Bëngbe Bëtsabe amë́ndayana tojóshjanguama. ");
INSERT INTO kbh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bëngbe Bëtsá nts̈amo morsca ents̈anga tmojanmama yochjayana te, chë Sur luaroca reiná echanjotsaye y morsca ents̈angbiama echanjayana ndoñe ts̈abá tmonjama ca; er chana chë quem luare iuajbana luarëngocana tojánabo Salomonbe osertanánaca palabrënga jouenama, y chë mora muents̈e entsemnana, Salomonbiama más uamaná endmëna. ");
INSERT INTO kbh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chë ents̈anga ts̈abá o ndoñe ts̈abá tmonjamama jayanama te, chë Nínive bëts puebloca ents̈ángnaca mochanjotsaye y mochanjayana morsca ents̈anga ndoñe ts̈abá tmonjama ca; er chënga, Jonás yojtsabuayiynaye ora, tmojanoyeuná y chë ts̈abe benache tmojtanishache, y chë mora muents̈e entsemnana, Jonasbiama más uamaná endmëna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ndocná canÿe uajuinÿanë́sha juajuínÿenana, canÿe iytë́mena luaroye juajájuama, ni canÿe cajonëshe tajsoye, sinó canÿe tsbanana luaroca juajájuama, chca, chë luaroye amashjuanëngbiama chaotsebínÿnama. ");
INSERT INTO kbh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Acbe bominÿe ts̈abá totsomñëse, acbe cuerpama mo canÿe uajuinÿanëshacá jtsemnana; chíyeca aca jtsobenana, nts̈amo tcojtsamcá chë bomínÿeca jtsonÿayana. Chë bominÿe ndoñe ts̈abá tontsemnësna, chë bominÿe tondaye ntsobenana jamana, nts̈amo tcojtsamcá chacobená jinÿama. Cachcá, acbe ainaniñe ts̈abe juabnënga tcojtsebomnëse, lempe nts̈amo chacojtsamcá ts̈abá echántsemna. Y acbe ainaniñe ndocna ts̈abe juabnënga tcontsebomnësna, lempe nts̈amo chacojtsamcá ndoñe ts̈abá queochátsmëna. ");
INSERT INTO kbh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuedado s̈mochtsebomna, ts̈ëngaftangbe ainaniñe nÿe ts̈abe juabnënga chaotsemnama, chca, lempe nts̈amo chas̈mojtsamcá ts̈abá chaotsemnama, y bacna juabnënga ndoñe chaondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chcasna, lempe nts̈amo s̈mojtsamcá ts̈abá tojtsemnëse y ndocna bacna sóyesna, ts̈ëngaftanga bëtscá ts̈abe soyënga s̈mochántsama; y chca, ts̈ëngaftanga s̈mochántsemna mo canÿe uajuinÿanë́sha puerte ts̈abá tojtsebinÿnacá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús chca jayanama tojanpochocá ora, chábioye canÿe fariseo tbojanofja chabe yebnoye jauasama. As Jesús tojánamashëngo y mesë́shents̈e tojanótbema. ");
INSERT INTO kbh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Chë fariseo tojanëuatjaná, Jesús ntsacuents̈abiacá jasama yojonts̈é causa, ndoñe nts̈amo chë judiënga imojanamancá, Bëngbe Bëtsabe delante ts̈ábenga jtsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Bëngbe Utabná tbojaniyana: “Ts̈ëngaftanga fariseunga s̈mondmëna mo ents̈angcá ndëmuanÿenga chë tazës̈ënga y s̈cnenënga shjoicajana jtsóbojabiana, pero tsoyna nÿe cachcá jonÿayana. Ts̈ëngaftanga becá jtsamana ents̈angbiama mo ts̈abengcá jtsinÿnama; pero ts̈ëngaftangbe ainanents̈e jútjena entsemna nÿe jtsatbëbanama y bacna soyënga jtsamama juabnë́ngaca. ");
INSERT INTO kbh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Juabna ndbomnënga! Ts̈ëngaftanga ndoñe s̈mondë́tats̈ëmbo, chë ts̈ëngaftangbents̈ana ents̈anga ndayá jinÿama imobencá tojamá, chë ts̈ëngaftangbe tsoye yomna soyë́ngnaca tojamama; y chíyeca, chabiama cachcá enduámana ndayá ts̈ëngaftangbe ainanoye yomna soyënga, y chë ents̈angbe delante s̈mojama soyënga. ");
INSERT INTO kbh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ts̈ëngaftanga cmontsamna, chë soyënguiñe ndayá ainaniñe yomnents̈ana ínÿengbioye jats̈atayana, y chca, lempe nts̈amo chas̈mojtsamcá Bëngbe Bëtsabe delante ts̈abá echántsemna ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Ts̈a lastema ts̈ëngaftangbiama fariseunga! Ts̈ëngaftanga Bëngbe Bëtsabiama jtsequëcjnayana chë jajañents̈a sananga bnë́tsanents̈ana canÿe soye nÿets̈á, y chë binche matatémënguents̈ana menta, ruda y nÿetsca binche matatemënguents̈ánënaca; pero nÿe bats̈á jtsamana chë nÿetscanga cachca derechënga chamotsebomnama y cha jtsebobonshánama. Quem soyënga cocayé cmontsamna jtsamana, chë inÿe ts̈abe soyënga ntjajbanacá ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Ts̈a lastema ts̈ëngaftangbiama fariseunga! Ts̈ëngaftanga ts̈a jtsebos̈ana chë judiëngbe enefjuana yebnënguenache chë más uámana luarënga jtsebomnama, y benachiñe nÿa puerte respétoca ents̈anga chacmotsacheuanayama ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Ts̈a lastema ts̈ëngaftangbiama! S̈mondmëna mo obanënga uatbontsaniñcá, ndoñe ntsinÿnana, y ents̈anga ntsetats̈ëmbcá chiñe jtsebotájayana. Chca s̈mondmëna, er ts̈ëngaftangbe ainana entsemna jútjena bacna juabnë́ngaca, pero ents̈angbiama ndoñe chca ques̈mátinÿna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesús chca tojánayana ora, canÿe ley abuatambayá tbojaniyana: —Buatëmbayá, chca palabrënga contsoyebuambná ora, bëngbiámnaca ndoñe ts̈abá quecátichamo ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús tojánayana: —¡Ts̈a lastema ts̈ëngaftangbiámnaca, chë ley abuátambayënga! Mo canÿe ents̈á, couáybioye canÿe uauta uasmanë́sha tbojuasmá, y chësha ndoñe yapa chaondëtsautama tondaye tontsamcá, ts̈ëngaftanga ents̈ángbioye jtsamë́ndayana bëtscá mandënga chamotsocumplínama, pero cach ts̈ëngaftanga ni mo bats̈atémnaca jtsamana chë mandënga jtsocumplínama ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Ts̈a lastema ts̈ëngaftangbiama! Ts̈ëngaftanga jtsamana chë Bëngbe Bëtsabe juabna oyebuambnayënga tempsquënga bëtsëtsa ents̈anga chamotsemnama, chëngbe cuevëshënga jtsatspórmayëse; pero chë mo chëngcá, canÿe buayenana sóyeca tmojabë́ngbioye ndoñe ntsayaunanana. Y chë tempsquënga chca oyebuambnayë́ngbioye ts̈ëngaftangbe bëts taitanga tmojtsanëbaye. ");
INSERT INTO kbh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chca jtsamëse, ts̈ëngaftanga s̈montsinÿanÿná, nts̈amo chë bëts taitanga tmojanmcá ts̈abá yomna ca ts̈ëngaftanga s̈mojtsejuabnama, er chënga chë oyebuambnayë́ngbioye tmojtsanëbaye y ts̈ëngaftangna chëngbe cuevëshënga jtsatspórmayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Chíyeca, Bëngbe Bëtsá chabe bëts osertanánaca tojánayana: ‘Ats̈e chë́ngbioye chanjichamuá ats̈be juabna oyebuambnayënga y ats̈biama abuayiynayënga, y báseftangbioye mochantsëbaye y ínÿengbioyna mochantsë́camiye ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Y chca, nÿets castigo morsca ents̈ángbeñe echántsemna, nÿetsca Bëngbe Bëtsabe juabna oyebuambnayënga tmojóbanama, Bëngbe Bëtsá quem luare tojanma orscana; ");
INSERT INTO kbh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abélbioye tbojanóba orscana, Zacarías tmojanóbantscoñe. Zacaríasna Bëngbe Bëtsabe bëts yebnents̈e tmojanóba, altar y chë ents̈anga Bëngbe Bëtsábioye imojánadorana luariñe. Chcasna, Bëngbe Bëtsá echanjama chë oyebuambnayënga tmojanóbanama, morsca ents̈ángbeñe nÿets castigo chaotsemnama ca. ");
INSERT INTO kbh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Ts̈a lastema ts̈ëngaftangbiama, chë ley abuátambayënga! Ts̈ëngaftanga jtsamana, Bëngbe Bëtsabe soyëngama jtsetats̈ëmbuama ents̈angbiama yapa totcá chaotsemnama. Cach ts̈ëngaftanga ndoñe ques̈mátobena chë soyëngama ts̈abá jtsetats̈ëmbuana, y chama jtsetats̈ëmbuama tmojtsebos̈ë́ngbioyna ndoñe ques̈matalesénciaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús chë soyënga tojánayanama, chë ley abuátambayënga y fariseunga puerte tojánetëna, y cha chents̈ana yojtsaisebocana ora, tmojanonts̈é chábioye becá tjanayana, y imojtsama ba soyëngama chaóyebuambama, ");
INSERT INTO kbh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chca, jisháchichiyama jtsebos̈ëse, cachá nts̈amo tojayana sóyeca chënga jtsebomnama ndáyeca chábioye mal jaquédana. ");
INSERT INTO kbh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chëntscuana, ba uaranga ents̈anga chents̈e tmojanójoto; ts̈a ents̈anga causa, nÿetscanga imojtsenatsë́nts̈enaye. Chora Jesús tojanonts̈é jóyebuambayama, y natsana chabe uatsjéndayëngbioye tojanë́yana: “Chë fariseungbe buatëmbana soyëngama cuedado s̈mochtsebomna, chënga mondmëna bacna ents̈anga, nts̈amo ndegombre tmojuabnacá ndinÿinÿnayënga. Nts̈amo chë levadura jamana nÿetsana chauábochema, cachcá chëngbe buatëmbana soyë́ngaca, chë fariseunga montsobena jamana bëtscá ents̈anga nts̈amo ndoñe ts̈abá tontsemncá chamotsamama. ");
INSERT INTO kbh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Er ndocna yoiytë́mena soye, ntjinÿcá queochaisoquéda; y chë ndótats̈ëmbo soye, ntsotats̈ëmbcá queochaisoquéda. ");
INSERT INTO kbh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chíyeca, chë mora nÿe ts̈ëngaftangbiama s̈mojtsichamo soyënga, chë ents̈angbiama mo ibetiñcá cuaftsemna soyënga, ents̈anga chama botamana mochanjátats̈ëmbona. Y chë iytëcana s̈mojtsichamo soyënga, nÿetsca ents̈ángbioye mochántsabuayiynaye, mo nda canÿe yebnents̈a tsbanánocana noticiënga tojtsayebuachcá ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ts̈ëngaftanga, ats̈be amiguënga, cbochjáuyana: Ndoñe matauatjëngana nÿe chë ts̈ëngaftangbe cuerpo japochócama imobenëngbiama, pero chents̈ana más jamana ndoñe ntsobenana. ");
INSERT INTO kbh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cbochanjabuayená ndábioye cmojtsamna jtsebiauatjana: s̈mochtsebiauatja chë nda vida jtsabuajuánama y chents̈ana infiernoye jtsichámuama obenana endbomnábioye; chábioye cocayé s̈mochtsebiauatja ca. ");
INSERT INTO kbh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Shachna jaja shlofts̈etémënga ndoñe nÿe uta denario crocenánama mondbétsena? Pero masque chca, Bëngbe Bëtsá chëngbiama sempre jesenójuabnayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y ts̈ëngaftangbiama Bëngbe Bëtsá lempe endë́tats̈ëmbo, y bueta stjënëjënga ts̈ëngaftangbe bests̈as̈iñe yomnámnaca. As ndoñe matauatjëngana; ts̈ëngaftanga ba jaja shlofts̈ëngbiama corente más s̈monduámana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ats̈e cbë́yana, nda ats̈be ents̈á yomna ca ents̈angbe delante tojayanabiama, chë Bëngbe Bëtsá Ents̈á tbojanbemánaca, Bëngbe Bëtsabe angelëngbe delante echanjayana chë ents̈á chabia yomna ca; ");
INSERT INTO kbh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","pero nda ents̈angbe delante, ats̈be ents̈á ndoñe yondmëna ca tojayanabiama, chë Bëngbe Bëtsá Ents̈á tbojanbemá, Bëngbe Bëtsabe angelëngbe delante echanjayana, cha chabe ents̈á ndoñe yondmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bëngbe Bëtsá bochanjaperdóna, nda chë Bëngbe Bëtsá Ents̈á tbojanbemabiama ndoñe ts̈abá tontsichamuábioye, pero chë Uámana Espíritbiama ndoñe ts̈abá tontsichamuábioyna ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ts̈ëngaftanga chë judiëngbe enefjuana yebnëngoye, nts̈amo ents̈anga bétsamama ichámëngbioye y mandadë́ngbioye chacmojunatse ora, ndoñe s̈mattsenócochinÿena nts̈amo o ndáyeca s̈mochjenë́uyanama, o ndayá s̈mochjayanama; ");
INSERT INTO kbh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","er chë Uámana Espíritu cmochanjabuayená nts̈amo jayanama tojtsemncá, jóyebuambayama chacmojtsamna ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chents̈ana, canÿa ents̈anguents̈á Jesúsbioye tbojaniyana: —Buatëmbayá, ats̈be cats̈ata momandá chë áts̈bioye otocana soyënga chas̈uatoyé ca. ");
INSERT INTO kbh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Y Jesús tbojaniyana: —Bacó, ¿nda ats̈e s̈ojábema tsëndatbe ujatanayá ca? ");
INSERT INTO kbh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y ents̈ángbioye tojanë́yana: —S̈mochjinÿe y cuedado s̈mochtsebomna chë nÿe yapa soyënga jtsebomnama bos̈ama; er masque bëtscá soyënga chas̈motsóbomñe, chca ndoñe ques̈mochátstats̈ëmbo aíñe ts̈abe vida tais̈mochjónÿenama ca. ");
INSERT INTO kbh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y chora mënts̈á tojanacuntá: “Inamna canÿe bomna ents̈á, y chabe fshantsënguiñe ts̈a jaja saná yojtsopodena. ");
INSERT INTO kbh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chë bomná chora mënts̈á yojtsejuabnaye, ‘¿Y morna, nts̈amo chjama? er ndoñe quetsátsbomna ndayents̈e ats̈be jaja saná jtsobocjayama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y mënts̈á yojeniyana: ‘Chë grano uaquëcjnaye yebnënga chantsendbiama, y inÿe más bëts yebnënga chanjëtsjebo, y chiñe nÿetsca ats̈be jaja saná chantsóbocjaye y nÿetsca ats̈be soyë́ngnaca. ");
INSERT INTO kbh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y chora ats̈e chjeniyana: Bacó, bëtscá soyënga contsebocjana, ba uatama cmochanjuáshjache. Morna, cochjóchna, cochjase, cochjatëmo, cochjóboyejuaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Bëngbe Bëtsá chábioye ibojauyana: ‘Obëjema, cach quem ibeta cochanjóbana; y asna, chë contsebocjana soye, ¿ndabiama yochtsemna ca?’ ” ");
INSERT INTO kbh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Y Jesús chora tojánayana: “Chca endbopása chë nÿe chabiama bomnana tojtsejuabá y bëtscá Bëngbe Bëtsabe soyënga ndoñe tonjëftsashjacháftaca ca.” ");
INSERT INTO kbh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chents̈ana, Jesús chabe uatsjéndayënga tojanë́yana: “Quem soye cbë́yana: Ndoñe s̈mattsenócochinÿena ndayá s̈mochjase o s̈mochjofs̈iye vida jtsebomnama, ni ndaye ents̈ayá s̈mochjuíchëtjuama cach ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndegombre, vida chë sanama más enduámana y cuerpo chë ents̈ayama más. ");
INSERT INTO kbh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chë ftsenga shlofts̈ënga s̈mochjanÿe: tondaye ntjájena, ni jaja saná ntjátbanana, ni grano uaquëcjnaye yebnënga ntsebomnana; pero Bëngbe Bëtsá chënga saná jtsats̈atnayana. ¡Y ts̈ëngaftanga chë ftsenga shlofts̈ëngbiama puerte más s̈monduámana! ");
INSERT INTO kbh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Masque chca endmëna, masque canÿa ts̈a tojesenócochinÿena, ¿nts̈amo nanjobenaye jamana, chë ntsachets̈á vida yochtsebomnents̈ana canÿe hora vida más jabotiyana? ");
INSERT INTO kbh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chcasna, nÿe chë base soye jamama ndoñe s̈montsobenëse, ¿ndayama chë inÿe soyëngama s̈mochjatenócochinÿena? ");
INSERT INTO kbh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“S̈mochjuinÿe chë lirio uants̈efjushangá jtsajuajnana: ndoñe ntsetrabájayana, ni ntseshabiamnayana. Pero ats̈e cbë́yana, ndegombre ni mo rey Salomón, nÿetsca chabe bomnánaca, chë lirio uants̈efjushangacá nÿets̈á botamana quenjatspormana. ");
INSERT INTO kbh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bëngbe Bëtsá ts̈a botamana shácuana tojuama, y chë shácuana mënté jajoca jtsamnana y yëfsana iñoca. Cha chë shácuanaca chca tojamëse, ndegombre ts̈ëngaftangbiámnaca Bëngbe Bëtsá echanjama ents̈ayá chas̈motsábomnama, ¡ents̈anga Bëngbe Bëtsábeñe nÿe bats̈á os̈buáchiyënga! ");
INSERT INTO kbh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chíyeca, ndoñe s̈mattsenócochinÿena ndayá jasama o jofs̈iyama onguayiñe; ");
INSERT INTO kbh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","er chë soyëngama quem luarents̈a ents̈anga mondbétsenocochinÿena, pero ts̈ëngaftanga ndoñe. Ts̈ëngaftangna canÿe Taitá s̈mondbomna, y cha endë́tats̈ëmbo ndayá cmëjabótama. ");
INSERT INTO kbh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Más ts̈abana, ts̈ëngaftanga s̈mochtsebos̈e Bëngbe Bëtsá ts̈ëngaftangbe ainaniñe chaotsemándama, y chë cmojtsëjaboto soyënga nÿe s̈mochanjóyëngacñe ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ndoñe matauatjëngana ats̈be ústonënga, ats̈be básefta oveshënga, er Bëngbe Bëtsá ts̈abá tbonjuínÿnana chabe amë́ndayana ts̈ëngaftanga jats̈atayama. ");
INSERT INTO kbh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lempe nts̈amo s̈mobomncá s̈mochtsatobuiye y chë ujabotë́ngbioye s̈mochtsats̈ataye. Mo ndotanguánaye shecnajiñe crocénana cuafjacjacá, celoca ts̈abe soyënga s̈mochjobuajo. Choca ndocna te queochaisopochóca, atbëbanënga choye ndoñe quemochátamashjna jatbëbama, y mejojón ndoñe queochatspochóca; ");
INSERT INTO kbh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","er chë ndayents̈e ts̈ëngaftangbe bomnana tojtsemnents̈a soyëngama, ainánaca ts̈ëngaftanga s̈mochántsejuabnaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mo chë oservénënga, chë ents̈ayá uichë́tjonënga y uajuinÿananë́shangaca chëngbe nduiño yochtashjanguama cuaftsobatmancá, ts̈ëngaftanga s̈mochtseprontana Bëngbe Utabná yochjésabama. ");
INSERT INTO kbh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chca, ts̈ëngaftanga s̈mochántsemna mo chë oservénënga, ts̈abe ents̈ayaca bopormánënga y uajuinÿananë́shangaca chëngbe amëndayá casamentocana yochtashjanguama cuaftsobatmancá; y chca, chë nduiño tojabochembo ora, cachora chë oservénënga jtebiatëfjuama. ");
INSERT INTO kbh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Puerte oyejuayënga chë oservénënga, chë nduiño tojtashjango ora tmojtsefs̈nënga. Ndegombre cbë́yana, chora chë mandayá sëndorëche echantásnaye, mesë́shents̈e chë oservénënga echanjátbiama, y saná echanjujuats̈iye. ");
INSERT INTO kbh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Puerte oyejuayënga chënga, chë tmojtsefs̈nënga cha tojtashjango ora, masque tsë́ntseto ora o bínÿanoye. ");
INSERT INTO kbh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Quem soye ts̈abá chacmësertá: chë yebnents̈a nduiño, ntseco ora atbëbaná yochjabama tojtsetats̈ëmbëse, cha ndoñe nanjaleséncia ndocná jushañe chaondbemama, chë yebnoye jtsamashënguama y jtsatbëbama. ");
INSERT INTO kbh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ts̈ëngaftángnaca s̈mochtseprontana, er chë Bëngbe Bëtsá Ents̈á tbojanbemá echanjésabo, ents̈anga chama tondaye tmontsejuabná ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro, Jesúsbioye tbojaniyana: —Utabná, ¿chë tconjayana cuento nÿe bëngbiama o nÿetscangbiama yochtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y Bëngbe Utabná tbojanjuá: —¿Nda yomna chë oservená, nts̈amo chë nduiño tojtsebos̈cá amá y nÿets juábnaca amá? Cha jtsemnana nda chë nduiño bochjë́ftseboshjona chë yebnents̈ënga chaotsanÿenama, y jasama tojtsemna ora chaújuats̈ema. ");
INSERT INTO kbh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Puerte oyejuayá chë oservená, chë nduiño tojtashjango ora, cha tbojínÿena jtsamëse nts̈amo tbojtsemncá. ");
INSERT INTO kbh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ndegombre cbë́yana, chë nduiño chábioye bochanjaimpáda nÿetsca chabe soyënga chabotsinÿeñama. ");
INSERT INTO kbh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero chë oservená, chabe nduiño betsco ndoñe yochantabo ca tojtsejuabná, y tojonts̈é chë inÿe oservénënga, boyabásenga y shembásenga jtsajants̈etayana, becá jtsesana, jofs̈iyana y jtsótmenana, ");
INSERT INTO kbh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","cha ndoñe tontsejuabná te y tontsetáts̈ëmbo ora, chabe nduiño echántashjango y puerte jabuache bochantsecastíga, y echanjama cha jasúfriama chabotsemnama, mo chë Bëngbe Bëtsábeñe ndos̈buáchiyënga mochanjasufriacá. ");
INSERT INTO kbh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Chë oservená, nda tojtsetáts̈ëmbo ndayá chë nduiño tojtsebos̈ama, pero ndoñe tontseprontana y ndoñe tontsobedecena, cha ba soye mochántsetjanja. ");
INSERT INTO kbh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Y chë oservená, ntsetats̈ëmbcá nts̈ámnaca tojabuachjuanguá, y chë causa chamotsetjanjama tbojtsemnësna, chana más bats̈á mochántsetjanja. Nda bëtscá soyënga tmojats̈tábioye jauyanana, bëtscá soyënga chaoma ca; y nda bëts trabajo tmojabonÿébioyna jauyanana, más bëts trabajo chaoma ca.” ");
INSERT INTO kbh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ats̈e sënjabo quem luariñe jabojuinÿiyama, y ¡ts̈a së́ntsebos̈e malaye ya ctsangbototjuana! ");
INSERT INTO kbh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ats̈e s̈ontsemna puerte jasúfriana, y ¡puerte ngménaca sëntsobátmana chca chaotsemnama! ");
INSERT INTO kbh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ts̈ëngaftanga s̈mojtsejuabná ats̈e tijabo quem luarents̈e ents̈anga natjë́mbana chamotsiyenama? Ndegombre ndoñe chca queochátsmëna; ats̈e sënjabo causa, ents̈anga más mochántsentsjanaye. ");
INSERT INTO kbh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Er mëntescana, canÿe yebnents̈e, shachnënga ndoñe quemochátenëyeunana, únganga útatbe contra y útata úngangbe contra mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taitá uaquiñabe contra echántsemna, y uaquiñá taitabe contra; bebmá, bembëbe contra, y bembe bebmabe contra; uambén mamá, bebincuabe contra, y bebincuá uambén mamabe contra ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mënts̈ánaca Jesús ents̈anga tojanë́yana: “Ts̈ëngaftanga, chë jants̈etëshënga shinÿe uenatjë́mbambanoicana tojóbocnama s̈mojinÿe ora s̈mondbétsichamo ‘echanjuafté ca’, y ndegombre chca jopásana. ");
INSERT INTO kbh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y tsmanoicana tojtsebínÿia orna, ts̈ëngaftanga s̈mondbétsichamo ‘echanjojënÿana ca’, y ndegombre chca jopásana. ");
INSERT INTO kbh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bacna ents̈anga, chë nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga! Nts̈amo quem luarents̈e yochtsemnama, ndayá celoca s̈mojinÿama ts̈a ts̈abá s̈mojtsetats̈ëmbëse, ¿ndáyeca ndoñe s̈montsobena jtsetats̈ëmbuana ndaye bëts soye quem tempo Bëngbe Bëtsá cmojtsinÿanÿnama ca?” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Ndáyeca cach ts̈ëngaftanga ndoñe s̈mondbáyana ndayá ts̈abá bétsemnana? ");
INSERT INTO kbh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nderado nda tcmojtsedemandá y cabildoye jotsánama cmojtsemna, cabá choye ndáshjango ora, betsco cháftaca cochtenoyántsia. Chca ndóñese, chë demandayá mandádbioye cmochanjúshjango, chë mandadna josticiëngbe cucuats̈iñe cmochanjáboshjona, y chënga cárceloye cmochanjutame. ");
INSERT INTO kbh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndegombre cbë́yana, chents̈ana ndoñe quecochtë́tsbocna, nÿets ndebénana candesopagantscuana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Cach ora, báseftanga tmojána Jesús jinÿama, y tmojancuentá ndayá chë mandado Pilato tojanmama; chana básefta Galileoca boyabásenga tojtsanëbaye, y chëngbe buiñe yojenajuabó chë Bëngbe Bëtsábioye jëtschuayama tmojanóba bayëngbe buíñeca. ");
INSERT INTO kbh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Y Jesús chënga tojanë́yana: “¿Ts̈ëngaftanga s̈mojtsejuabná, chë Galileoca ents̈anga chca tmojapasá, chë luarents̈a inÿe boyabásengbiama chënga más bacna soye amënga imojamna causa ca? ");
INSERT INTO kbh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ndegombre cbë́yana, ndoñe. Y cach ts̈ëngaftanga, bacna soyënga amama ndoñe s̈montsajbaná y Bëngbe Bëtsabe benache ndoñe s̈montishachëse, ts̈ëngaftángnaca s̈mochanjóbana. ");
INSERT INTO kbh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O, ¿ts̈ëngaftanga s̈mnétsejuabnaye, chë Jerusalenents̈a bnë́tsana posufta ents̈anga tmojanóbanënga, chë Jerusalenoca binche uafjajónaye Siloé béconana tsbanana jebna soye tojtsanáshajaye ora, chënga imojamna chë ínÿenga Jerusalenents̈e oyenëngbiama más bacna soyënga amënga ca? ");
INSERT INTO kbh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ndegombre cbë́yana, ndoñe. Y cach ts̈ëngaftanga, bacna soyënga amama ndoñe s̈montsajbaná y Bëngbe Bëtsabe benache ndoñe s̈montishachëse, ts̈ëngaftángnaca s̈mochanjóbana ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús mënts̈á tojanacuntá jabuátambama: “Canÿe ents̈á jajoca canÿe higo betiye inabomna, y yojá nderado nantseshájonama, pero tondaye yonjínÿena. ");
INSERT INTO kbh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chcasna, chë jajañe bojanÿábioye cha ibojauyana: ‘Mouena, ya unga uata tsabó quem higo betiyoye jaborrepárama, nderado nantseshájonama, pero ndocna te tondaye chiyátinÿena; chíyeca, motsetëts̈e. ¿Ndayama quem jajañe yochjátsjena ca?’ ");
INSERT INTO kbh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero chë jajañe inÿená ibojauyana: ‘Bacó, inÿe uata cachcá monÿá, fshantse chanjáboplojua y uanguanëshe chanjabotboto. ");
INSERT INTO kbh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nderado chca jamëse, nanjashájona; y ndóñesna, chora cocayé cuantsetëts̈e ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Canÿe, canÿe ochnayté Jesús yojonts̈é ents̈anga jabuátambana, chë judiëngbe enefjuana yebnents̈e, ");
INSERT INTO kbh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","y chents̈e yojtsemna canÿe shembása; cha ya bnë́tsana posufta uata yojtses̈oca. Canÿe bacna bayëja chábeñe tojánamashëngo y chca tses̈tjoná tbojtsanbema, y tondayama yontsobena jtondiríchana. ");
INSERT INTO kbh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús chábioye tbojáninÿe ora, tbojanchembo y mënts̈á tbojaniyana: “Batá, mora ya ndoñe s̈ocá quecátsmëna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chora Jesús chabe cucuats̈ënga chábeñe tojanjajó, y cachora chë shembása yojtondirícha, y tojanonts̈é Bëngbe Bëtsábioye jëtschuayama. ");
INSERT INTO kbh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero chë enefjuana yebnents̈a mándayana tbojánetna, Jesús chë shembása ochnayté tbojanshnama, y ents̈anga tojanë́yana: —Chnë́nguana te comna jatrabájama; chora s̈mochjabo jenóshnama; ochnaytese ndoñe ca. ");
INSERT INTO kbh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Y Bëngbe Utabná tbojanjuá: —¡Bacna ents̈anga, nts̈amo ndegombre s̈mojuabnacá ndinÿinÿnayënga! ¿Ts̈ëngaftanguents̈á ndocná chë ochnayté chabe uacná o chabe burrotema buanjuajafjoná, juanatsama béjaye chaofs̈ema? ");
INSERT INTO kbh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chcasna, quem shembása, canÿa Abrahámbents̈ana ents̈á, y Satanasbe causa bnë́tsana posufta uata s̈ocá yojtsemna, ¿ndoñe ts̈abá yondmëna canÿe ochnayté chë bayëja jtsebojuánana ca? ");
INSERT INTO kbh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús chca tojánayana ora, chabe uayayënga imojtsëuatja, y nÿetsca ents̈anga imojtsóyejuaye Jesús ts̈a bëts soyënga yojtsamama. ");
INSERT INTO kbh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús mënts̈ánaca tojánayana: “¿Ndayacá Bëngbe Bëtsabe amë́ndayana yomna, o ndaye sóyeca nanjopódia chama jábuayenana ca? ");
INSERT INTO kbh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Endmëna mo canÿe mostaza jénaye, canÿe ents̈á jajañe tojajecá; chiyna jójuana y canÿe bëts betiye jóbemana; ts̈a bë́tsashe jóbemana, chíyeca chë jaja shlofts̈ënga chë buacuashënguiñe uajajonëtemëngá jauábopormana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mënts̈ánaca Jesús tojánayana: “¿Ndaye sóyeca chjobenaye Bëngbe Bëtsabe amë́ndayama jábuayenama ca? ");
INSERT INTO kbh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Endmëna mo levadurcá; canÿe shembása chana jenájuabana unga medida arninÿañe, nÿetsana chauabochama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalenoye benache, Jesús ents̈anga yojtsabuátambaye bëts pueblënguiñe y base pueblotémënguiñe. ");
INSERT INTO kbh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Canÿa chábioye tbojantjá: —Bëngbe Utabná, ¿nÿe báseftanga imomna chë atsebácanënga mochtsemnënga ca? Y Jesús tbojanjuá: ");
INSERT INTO kbh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Puerte s̈mochtsents̈ena chë base utënts̈á bës̈ás̈ajana jamashjnama; er ndegombre cbë́yana, banga mochántsebos̈e chëjana jamashjnama, pero ndoñe quemochatobenaye. ");
INSERT INTO kbh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chë yebnents̈a nduiño chaojotsbaná y chë bës̈ás̈a chaojtatáments̈ana, ts̈ëngaftanga chë shjoca chas̈mojtsemnënga, s̈mochántsechembuana, mënts̈á jtsichámëse: “Utabná, s̈mebëtafjo ca.” Pero cha cmochanjáuyana, “Ats̈e ndoñe quetsátstats̈ëmbo ndëmoquënga ts̈ëngaftanga s̈momnama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chora ts̈ëngaftanga s̈mochanjonts̈é ichámuana: “Acaftaca cánÿiñe fsënjase y fsënjofs̈é, y aca bëngbe tsáshenañe tconjabuatambá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero cha cmochanjójuaye: “Ya tcbonjáuyana, ndëmoquënga s̈momnama ndoñe tstáts̈ëmbo ca. ¡Ats̈bents̈ana mojuánanga, bacna soyënga amënga ca! ");
INSERT INTO kbh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Chora chents̈e puerte s̈mochanjenóbos̈achna y tsets̈anama juatsas̈ënga s̈mochantsenoftë́s̈jojnaye, Abraham, Isaac, Jacob y nÿetscanga Bëngbe Bëtsabe juabna oyebuambnayënga Bëngbe Bëtsabe amë́ndayoca imojtsemnama chas̈mojinÿe ora, y ts̈ëngaftanga chents̈ana cmochtëbuacanama. ");
INSERT INTO kbh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y shinÿe bocanoicana y uenatjë́mbambanoicana, tsmanoicana y tsjuanoicana ents̈anga mochanjabo y juasama mochanjotbiama Bëngbe Bëtsabe amë́ndayents̈e. ");
INSERT INTO kbh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y banga mora nduámanënga imomnënga, chora uámanënga mochántsemna; y banga mora uámanënga imomnënga, chora nduámanënga mochántsemna ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesús chë soyënga tojanë́yana ora, básefta fariseunga tmojánashjajna y tmojaniyana: —Muents̈ana motsatoñe; Herodes entsebos̈e aca jtsóbama ca. ");
INSERT INTO kbh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Y Jesús tojanë́jua: —Motsajna y s̈mochjauyana chë corente studio bomná, mo tjañe mesetcá: “Minÿe, mënté y yëfse ents̈ángbents̈ana bacna bayëjënga sëndëtëbuacana y s̈oquënga sëndáshnaye, y baseftaytesna chanjapochóca ca.” ");
INSERT INTO kbh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero ats̈e s̈ontsemna mënté y yëfse jtsayana, y baseftaytesna Jerusalenoye jana, er ndoñe ts̈abá ntsemnana canÿa Bëngbe Bëtsabe juabna oyebuambnayá Jerusalenents̈a chábuañe chaóbana ca. ");
INSERT INTO kbh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerusalenents̈a ents̈anga, Jerusalenents̈a ents̈anga, ts̈ëngaftanga chë Bëngbe Bëtsabe juabna oyebuambnayënga jtsëbáyana, y chë Bëngbe Bëtsabe ichmónëngbioye ndëts̈béngaca jtsatëchë́nganjana jtsëbáyama! ¡Bueta soye ats̈e sënjábos̈ena ts̈ëngaftanga áts̈bioye júbuajama, mo canÿe tuamba chabe bolletotémënga juatëngmiásha tajsoye cuaftajayecá, pero ts̈ëngaftanga ndoñe ches̈mátsbos̈ena! ");
INSERT INTO kbh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Y s̈mochjinÿe, mora ats̈e cachcá cbochanjesë́nÿaye, y chca, ats̈na enánanga cbochanjésabashejuana, mo canÿe yebna cachcá tcojesonÿá y énañe tcojeseboshjoncá. Y ndegombre, ts̈ëngaftanga morscana ndoñe más ats̈e ques̈mochátinÿe; y ats̈e s̈mochántinÿe, chë: ‘¡Corente bendición bomná, Bëngbe Utabnabe obenánaca tojabá ca!’ chas̈mojtsichamo ora ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Canÿe ochnayté, Jesús tojána jasama fariseungbe canÿe amëndayabe yebnoye; y chë fariseunga yejuana imojtserreparana, er ndayá Jesús nanjama. ");
INSERT INTO kbh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chénts̈naca, chabe delante yojtsemna canÿe ents̈á uafshachanánaca s̈ocá. ");
INSERT INTO kbh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","As Jesús chë ley abuátambayënga y fariseunga tojanatjá: “¿Quenlesenciana canÿe ochnayté canÿe s̈ocá jáshnama o ndoñe ca?” ");
INSERT INTO kbh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chëngna ndocá tmonjanjuá. As Jesús chë s̈ocábioye tbojánishache, tbojanshná y tbojaniyana chaotsatoñe ca. ");
INSERT INTO kbh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y chë fariseunga tojanë́yana: “¿Nda ts̈ëngaftanguents̈á, nderado chabe uaquiñá o uacná canÿe tboye tojtsótsats̈e, cachora ndoñe nanjá jetsejátsëcama, masque ochnayté totsomñëse ca?” ");
INSERT INTO kbh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y chënga ndocá tmonjanobená cha jojuana. ");
INSERT INTO kbh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús tojáninÿe nts̈amo chë ófjanënga quëfseroye imojtsachnëjuana jotbiamama; as mënts̈á chënga tojanabuayená: ");
INSERT INTO kbh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Canÿe casamentama nda chacmojofja ora, quëfseroca ndoñe catjótbema, er nderado inÿe ofjaná acbiama más uamaná ústonoye nandaboye; ");
INSERT INTO kbh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nderado chë tsëndatbe ofjajaná nanjabo y cmatjauyana: ‘Mua chents̈e chaótbema, maluaré ca’, y chora cmatjotóca ouatjents̈e chafjoca jana jatótbemana. ");
INSERT INTO kbh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chamna, nda chacmojofja ora, chafjoca cochjótbema, chca, chë ofjajaná chaojabo ora chacmëyana: ‘Taita, quëfseroye motsëchnë́ngoñe ca’. Y chca, aca chë chents̈e tmojtsetbiámanëngbiama uamaná cochántsemna. ");
INSERT INTO kbh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Er nda cachá bëtsá tojtsenobiamná, nduamaná mochántsebema; y nda cachá nduamaná tojtsenobiamná, aíñe bëtsá mochanjábema ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y chë tbojanofja ents̈ábioynaca Jesús mënts̈á tbojaniyana: “Fiesta chacojama o sananga chacojtsebomna ora, ndoñe cattsëbuájajana acbe amiguënga, cats̈átanga, ni pamíllanga, ni acbe juachañe oyenënga bomnënga; er chë́ngnaca, fiesta chamojtsebomna ora, aca cmochantë́tofja, y chca ya acbe uacanana soye cochántsebomna. ");
INSERT INTO kbh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Chamna, canÿe fiesta chacojama ora, cochjúbuaja ndbomnëjémënga, jama ndobenënga, coshetënga y jtanënga, ");
INSERT INTO kbh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","y aca corente oyejuayá cochántsemna; er chënga ndoñe quemochatobenaye cachcá aca jtëtofjana, pero acna acbe uacanana soye cochántsebomna, chë Bëngbe Bëtsabe bominÿiñe ts̈ábenga imomnënga chamojtayena ora ca” —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chca tojanuena ora, canÿa chë mesë́shents̈e tbemaná tojánayana: —¡Puerte oyejuayá echántsemna Bëngbe Bëtsabe amë́ndayoca juasama chaojtsemná ca! ");
INSERT INTO kbh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chora Jesús tbojaniyana: —Canÿe bacó canÿe bëts saná yojaprónta y ba ents̈anga yojúbuaja. ");
INSERT INTO kbh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Juasama ya yojobuache ora, canÿe oservená ibojíchmua chë ófjanënga jáuyanama chamotsajna, ya lempe yojtseprontana ca. ");
INSERT INTO kbh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero chorna nÿetscanga imojonts̈é jtsoyáts̈ëmbuana. Canÿa yojayana: “Cabá mora canÿe fshantse sënjobuámiñe, y s̈ontsemna jana jarrepárama. Chcasna, aslëpaye s̈motsepacenciá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Inÿa yojayana: “Bnë́tsana toronga sënjobuámiñe, y s̈ontsemna jana jánÿama, jaárama taimochjosérvia. Chcasna, aslëpaye s̈motsepacenciá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y inÿa yojayana: “Cabá mora sëntsobouamá, y chë causa, ndoñe quichatobenaye jama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Chora chë oservená yojesshë́cona y lempe chabe nduíñbioye ibojauenaye. Chë nduiño ts̈a ibojtsetna, y chë oservenábioye ibojauyana: “Cam ora motsa tsashenangoye y benachëngoye, y moye cochjunatse ndbomnëjémënga, jama ndobenënga, jtanënga y coshetënga ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chents̈a bënë́ntscose, chë oservená chë nduíñbioye ibojauyana: “Bacó, ya sënjama nts̈amo s̈conjamandacá, y cabá ínÿengbiama luare entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","As chë nduiño ibojauyana: “Motsa benachëngoye y betiyetemë́ngaca jetjaniñëngoye, y ents̈anga cochjautáriaye moye chamuábama, ats̈be yebna chaojutjiama; ");
INSERT INTO kbh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","er ndegombre cbë́yana, chë natsana sënjobuajënguents̈á ndocná ats̈be saná queochatsse ca.” ");
INSERT INTO kbh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mallajta ents̈anga Jesús imojtsë́stona; as cha tojanobuértana y tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nderado nda áts̈bioye tojabo, y nts̈amo chabe taitá, chabe mamá, chabe shema, chabe básenga, chabe cats̈átanga y uabénanga tuababuánÿeshanama, y nts̈amo cachá tuenobobonshánama, ats̈e ndoñe más corente s̈ontsebobonshánëse, cha ndoñe ntsobenana ats̈be uatsjendayá jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Y nda, ats̈biama ndoñe tontseprontana jasúfriama y cruciñe jobanámnaca, y nÿetsca chabe quem luare soyënga ndoñe tonjéseboshjona ats̈e juastama, cha ndoñe ntsobenana ats̈be uatsjendayá jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nderado nda ts̈ëngaftanguents̈á tojtsejuabná canÿe tsbanana jebna soye japórmama, ¿cha natsana ndoñe nanjótbema jinÿama ntsachets̈á crocénana chents̈e yochjuába, y japochócama nÿets̈á crocénana tayojtsebomnama? ");
INSERT INTO kbh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chca ndóñese, nderado chë uajatsana ucuatjoniñe tojapormá y lempe jajebuama ndoñe tonjobenase, nÿetscanga chca tmojinÿënga, muantsáfchaye y mënts̈á muantsichamo: ");
INSERT INTO kbh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Quemëjema jajebuama tonjonts̈é, y japochócama ndoñe chenatobená ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O ¿ndaye rey inÿe réyeftaca jéntsjama tbojotocase, natsana ndoñe nanjótbema jajuaboyama, nderado nanjobenaye bnë́tsana uaranga soldadë́ngaftaca chë ínÿabioye jayë́njanana, chë inÿa uta bnë́tsana uaranga soldadë́ngaftaca tojtsabose? ");
INSERT INTO kbh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y ndóñesna, chë inÿe rey cabá bënoca tojtsemna ora, básefta ents̈anga echanjichamuá, cha jauyanama más ts̈abá yomna ndoñe jatentsjanayana ca. ");
INSERT INTO kbh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Chcasna, ndánaca ts̈ëngaftanguents̈á, lempe nts̈amo tobomncá ndoñe cachcá tonjesonÿá, cha ndoñe ntsobenana ats̈be uatsjendayá jtsemnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tamó ts̈abe soye endmëna; pero chë tamó fténana tojtsóbemëse, ts̈ëngaftanga ndoñe ques̈mátobena jamana tempcá sanana cachiñe chaotsatsmënama, ni saná jatamuama. Chë ftena tamó tondayama ntsoservénana, cachcá, chë ats̈be uatsjéndayënga jtsemnama tmojtsebos̈ënga, pero lempe jéseboshjonama ndoñe tmontsebos̈e, cach ndoñe chama ntsoservénana. ");
INSERT INTO kbh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chë ftena tamó ndoñe ntsoservénana ni fshantsama, ni uanguanëshama. Nÿe jtsëts̈enana. Chë jouenama tmojtsobenënga, s̈mochjouena ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nÿetsca chë Romocama impuesto ents̈ángbioye atjanayënga y inÿe bacna soyënga amënga, Jesúsbioye imojánajna chabe palabra jouenama; ");
INSERT INTO kbh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","y chë fariseunga y ley abuátambayënga chama Jesusbiama podesca imojtsoyebuambná, mënts̈á: —Mua bacna soyënga amë́ngaftaca entsenuta y chë́ngaftaca entsesá ca. ");
INSERT INTO kbh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","As Jesús mënts̈á tojanacuntá, chënga jabuátambama: ");
INSERT INTO kbh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Nda ts̈ëngaftanguents̈á, canÿe patse oveshënga tojtsabamna, y canÿa tbojtsobuéts̈ëse, chë inÿe esconëfta bnë́tsana y esconëfta oveshënga shëntsjañe ndoñe cachcá nanjesë́nÿaye, y nanjá chë ots̈ená jetsenguanguama candëtsónÿeñëntscuana? ");
INSERT INTO kbh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y tbojtsinÿena ora, oyejuayá chë oveshá jesotants̈ájuana; ");
INSERT INTO kbh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","y yebnoye tojtashjango orna, chabe amiguënga y juachañe oyenënga jáchembuana y mënts̈á jáuyanana: “Ats̈eftaca móyejuanga, er chë sëntsanobuets̈e oveshá së́ntsinÿena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ats̈e cbë́yana, cachcá, celócnaca más oyejuayana jtsebínÿnana, canÿe bacna soyënga amá ts̈abe benache tojtishachabiama, y ndoñe nÿa yapa, esconëfta bnë́tsana y esconëfta ts̈abe soyënga amëngbiama, chë ndoñe yondujaboto bacna soyënga amana jtsajbanana ca. ");
INSERT INTO kbh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O mënts̈á, ¿ndëmua shembása, bnë́tsana uámana crocénana tojtsebomna y cánÿana tojtsobuéts̈ëse, chora ndoñe canÿe uajuinÿanë́sha nanjuajuinÿená, y cuedádoca chë yebna nantsetsjajo y botamana chë crocénana nantsenguango candëtsónÿeñëntscuana? ");
INSERT INTO kbh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tojtsinÿena ora, chabe amiguënga y juachañe oyena shembásenga jáchembuana, y mënts̈á jáuyanana: ‘Ats̈eftaca móyejuanga, er chë sëntsanobuets̈e crocénana së́ntsinÿena ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ats̈e cbë́yana, cachcá, chë Bëngbe Bëtsabe angelotémëngbeñe oyejuayana jtsebínÿnana, nÿe canÿe bacna soyënga amá chë ts̈abe benache tojtishachabiama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús mënts̈ánaca tojanacuntá: “Canÿe ents̈á uta uaquiñata yojánabamna; ");
INSERT INTO kbh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","y canÿe, chë ngomënche uaquiñá chabe taitábioye ibojauyana: ‘Taita, ats̈be otocana soyënga s̈matats̈etá ca.’ As chë befta lempe chë uta uaquiñata yojtëjátaye. ");
INSERT INTO kbh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Chents̈ana baseftaytesna, chë más bobontse uaquiñá lempe nts̈amo ibojobuachcá yojtsatobuiye y chë crocenánaca bën luaroye yojtsoñe, y choca, cha nÿe nts̈amo ibojocochëngcá, mocá yojenobuiye, y chca, lempe yojtsepochóca. ");
INSERT INTO kbh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lempe crocénana yojtsoshañe orna, bëts shëntsana chë luarents̈e yojóshjango, y chë causa cha ibojotóca shë́ntseca jtsejétanana. ");
INSERT INTO kbh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","As, cha yojá trabajo jonguangoñama y yojínÿena chë luarents̈a canÿe ents̈ábents̈e; chana, chabe jajoye ibojíchmua cots̈ënga jtsanÿenama. ");
INSERT INTO kbh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chë bobontsna yojtsebos̈e chë cots̈be saná jtsesana, pero ndocná tondaye ibonjanájuats̈naye. ");
INSERT INTO kbh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Cabana, botamana yojinÿe nts̈amo yojtsepasacá, y mënts̈á yojenójuaboye: ‘¡Bueta trabájayënga ats̈be taitabe yebnents̈e bëtscá saná mondëtsóbomñe, y ats̈e muents̈e shëntsama chanjóbana ca! ");
INSERT INTO kbh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chantá ats̈be taitabe yebnoye y mënts̈á cha chanjauyana: Taita, s̈motseperdoná. Ats̈e tijama ndayá Bëngbe Bëtsá ndoñe yondbos̈cá, y nts̈amo aca ndoñe condbos̈cá. ");
INSERT INTO kbh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mora ya merecido taitsatobuajoñe acbe uaquiñá jtsabáinama; nÿe canÿe acbe trabajayacá Diosmanda s̈matofja ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chca jëftsenójuaboyëse, yojonts̈é cachabe yebnoye jtana. “Cabá bënoca yojtsemna ora, chabe taitá chábioye ibojinÿe, y chabe uaquiñabiama ibojóngmia, y jajébenguama betsco yojá; ibojajebengo, ibojtotsejcjuá y ts̈a yojtsóyejuayayama chë uaquiñábioye ibojtámocho. ");
INSERT INTO kbh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chora chë uaquiñá ibojauyana: ‘Taita, s̈motseperdoná. Ats̈e tijama ndayá Bëngbe Bëtsá ndoñe yondbos̈cá, y nts̈amo aca ndoñe condbos̈cá; mora ya merecido taitsatobuajoñe acbe uaquiñá jtsabáinama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero chë Taitana chabe oservénënga yojámëndaye: ‘Betsco chë más ts̈abe ents̈ayá mauaca y matspormanga, monts̈abuechëtjo y matsshecochëtjo. ");
INSERT INTO kbh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mora chë más minÿica uacná s̈mochjuánatse y s̈mochjáshbua. ¡Mochjase y mochjóboyejuaye ca! ");
INSERT INTO kbh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Quem ats̈be uaquiñá mo obanacá endánmëna y mora bënga montsetáts̈ëmbo cha ainá yotsomñama. Quem ats̈be uaquiñá mo ots̈enacá endánmëna y mora tmontsinÿena ca.’ Y chents̈ana imojonts̈é joboyejuayama. ");
INSERT INTO kbh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chë yebnoca fiesta yojtsemnëntscuana, chë mayor uaquiñana jajoca inétsomñe. Yebnoye yojtsataye y ya béconana yojtsemna orna, cha yojouena imojtsabuastoye y imojtselántsaye. ");
INSERT INTO kbh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","As chora cha canÿe oservenábioye ibojachembo y mënts̈á ibojatjaye: ‘¿Ndayá bëngbe yebnents̈e yojtsopasana ca?’ ");
INSERT INTO kbh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“As chë oservená ibojojuá: ‘Acbe uabentsá tontashjango y chama acbe taitá s̈onjutarié chë más minÿica uacná jáshbuama, cha ts̈abá tojtashjanguama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero chë uabóchena cats̈atna corente ibojtsetna y ndoñe yontsebos̈e tsoye jtamashënguana. As cach befta yojábocna chë cats̈átbioye jaimpádama chauatamashënguama. ");
INSERT INTO kbh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Chora cha chë taitábioye ibojauyana: ‘Taita, aca condë́tats̈ëmbo bueta uata cbetsajabuáchanama, nÿets tempo cbetseyeunanama, pero ndocna te ni mo canÿe chivotema ches̈caisats̈tá ats̈be amiguë́ngaftaca joboyejuayama. ");
INSERT INTO kbh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y masna, acbe uaquiñá chë bacna vida bomna shembásengaftaca acbe crocénana pochocayá tojtashjango ora, chë más minÿica uacná chabiama tcojáshbua ca’ —chë uaquiñá ibojauyana. ");
INSERT INTO kbh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Chora chë befta ibojojuá: ‘Ats̈be uaquiñá, aca sempre áts̈eftaca condétsemna y lempe nts̈amo ats̈e tsbomncá acbiámnaca endmëna. ");
INSERT INTO kbh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero mora ts̈abá entsemna joboyejuayama y joyejuayëngama; er acbe uabentsá mo obanacá endánmëna, y mora bënga montsetáts̈ëmbo cha ainá yotsomñama; mo ots̈enacá endánmëna, y mora tmontsinÿena ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús mënts̈ánaca chabe uatsjéndayënga tojanacuntá: “Inamna canÿe bomna ents̈á, y cha ibnabomna canÿe uajabuachaná chabe soyënga chaotsinÿenama; y chë nduiño imojuenaye chë uajabuachaná chabe soyë́ngaca ndoñe ts̈abá yontsamama. ");
INSERT INTO kbh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Asna, chë nduiño ibojachembo y mënts̈á ibojauyana: ‘¿Nts̈amo acbiama s̈montsatsëtsnacá ndegombre yojtsemna ca? Mora cuenta s̈matats̈tá nts̈amo ats̈be soyë́ngaca tcojamama, er morscana ya ndoñe ats̈be soyënga inÿená quecochátsmëna ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Chë uajabuachaná yojonts̈é jenójuaboyana, y mënts̈á yojeniyana: ‘¿Y mora nts̈amo chtsemana, chë nduiño ats̈be trabajuents̈ana s̈ojtabocna ora? Ndoñe añemo quetsátsbomna fshantse jatrabájama, y lemos̈na jótjañamna sëntsëuatja. ");
INSERT INTO kbh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya së́ntsetats̈ëmbo ndayá chjama, chca, ats̈be trabajuents̈ana chas̈ojtábocna ora, ats̈e jtsabamnama ndëmuanÿenga chëngbe yebnents̈e chas̈mofjama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Chents̈ana, canÿánÿa chë chabe nduíñbioye ndebénënga yojáchembo. Cánÿabioye ibojatjaye: ‘¿Ntsachets̈á ats̈be nduiño icondebena ca?’ ");
INSERT INTO kbh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y cha ibojojuá: ‘Canÿe patse barrilës̈angá aceitiye ca.’ As cha ibojauyana: ‘Muents̈e acbe recibë́cha entsamna; mora mótbema y inÿácha nÿe shachna bnë́tsana barrilës̈angama matapormá ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chents̈ana ínÿabioye ibojatjaye: ‘Y acna, ¿Ntsachets̈á icondebena ca?’ Y cha ibojojuá: ‘Canÿe patse medida trigo ca.’ As cha ibojauyana: ‘Muents̈e acbe recibë́cha entsamna; chiñe nÿe posufta bnëtsanama mábema ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chents̈ana, chë nduiño ts̈abá yojayana chë ndoñe ts̈abá ama mayordombiama, cha stúdioca yojamama. Chë nÿe quem luarama enójuabnaye ents̈anga, cachëngbe soyë́ngaca puerte studio bomnënga mondmëna; y chë ents̈angbe juabnënga binÿnayábenga ndoñe nÿa yapa ca. ");
INSERT INTO kbh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ats̈e cbabuayená, quem luarents̈e, chë bacna soyënga amëngbe luarents̈a bomnánaca amiguënga s̈mochjábiama, ínÿenga jtsëjabuáchanëse. Chca, chë bomnana tojtsopochocá ora chas̈motsabamna ndëmuanÿenga chë nÿetsca tescama oyenoye chacmúbuajama ca. ");
INSERT INTO kbh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nda básefta soyënguiñe lempe ts̈abá tojama, bëtscá soyënguíñnaca lempe ts̈abá echanjama; y nda básefta soyënguiñe ndoñe ts̈abá tonjama, bëtscá soyënguíñnaca cach ndoñe ts̈abá queochatsma. ");
INSERT INTO kbh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Chcasna, quem luarents̈e, chë bacna soyënga amëngbe luarents̈a bomnánaca ndoñe ts̈abá s̈monjamëse, ¿nda chë ndegombre bomnana, chë Bëngbe Bëtsabe soyënga cmochjábanÿiye? ");
INSERT INTO kbh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Y chë ndoñe ts̈ëngaftangbe sóyeca ndoñe ts̈abá s̈monjamëse, ¿nda cmochjants̈abuáchiye ndayá ts̈ëngaftangbiama yomncá ca? ");
INSERT INTO kbh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ndocná ntsobenana uta mandayata jtsaservénana; er cánÿabioye bochantsáboyënja y chë ínÿabioyna bochántsebobonshana, o cánÿabiama ts̈abá echántsetrabajaye, y chë ínÿabiamna ndoñe ts̈abá. Ndoñe quecátobena Bëngbe Bëtsá jtsebobonshánana, nÿe quem luarents̈a soyënga jtsebomnama tcojtsebos̈ëse ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chë fariseunga, becá crocénana jtsebomnama bos̈ënga imnamna, lempe chca chënga tmojanuena, y Jesúsbioye imojtsáboyejuana. ");
INSERT INTO kbh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","As Jesús tojanë́yana: “Ts̈ëngaftanga ents̈angbe delante mo ts̈ábenga cuaftsemncá jtsenobiamnayana, pero Bëngbe Bëtsá endë́tats̈ëmbo ndayá ts̈ëngaftangbe ainaniñe yomnama; er ndayá ents̈anga más tojtsebos̈cá, Bëngbe Bëtsá jtsáboyënjana ca. ");
INSERT INTO kbh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisesbe ley y chë Bëngbe Bëtsabe juabna oyebuambnayënga ts̈ëngaftanga cmonjanabuayiyná, Juan chë Ubayaná quem luaroye tonjánabëntscuana. Cha tonjánabo orscana montsabuayiyná chë ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayocama, y nÿetscanga ts̈a montsebos̈e choye jamashënguama ca. ");
INSERT INTO kbh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Más paselo endmëna, celoca y quem luare chaopochocá, y ndoñe chë nts̈amo leyiñe iuayancá, chë ndayá jopásama yomnama, ni mo canÿe punto ndoñe chca chaondë́tsemnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nda chabe shémbioye cachcá tbojesonÿá y ínÿaftaca tojtóbouamase, cha chë natsana shémbioye ínÿaftaca jtseíngñayana; y nda chë úts̈ena shembásaftaca tojobouamá chana, canÿe uabuatmá jtsebomnana, y chca, chana canÿe bacna soye jtsamana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Canÿe bomna ents̈á inamna; cha yojanamana uámana y botamana shbuenda uafjatsenga y lino ents̈ayangá jtichëtjuana, y cada te bëts fiestënga yojánama. ");
INSERT INTO kbh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Canÿe ndbomnëjémnaca inamna, Lázaro ca uabainá, bacna nguayanánaca s̈ocá; y cha yojanamana chë bomnabe bës̈ás̈ents̈e fshantsiñe jótbemana. ");
INSERT INTO kbh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Quem ndbomnëjema yojtsebos̈e chë bomná yojtsesayents̈ana yojatquëcjana sanángaca jtoshachayana; y chë ques̈ënga imnaboye chabe nguaye cuerpo jajáfjuama. ");
INSERT INTO kbh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Canÿe te Lázaro yojtsóbana, y Bëngbe Bëtsabe angelënga Abrahámbioye cha imojtamba, chë nÿetscanga oyejuayënga mondmëna luaroye. Chë bomnánaca yojóbana y imojuátbontsa. ");
INSERT INTO kbh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Chë bomná infiernoca puerte ngméniñe yojtsesufrina ora, tsbanánoye yojontjes̈iye y bënoca Abraham ibojinÿe, y Lázaro cháftaca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","As chë bomná yojuayebuáchena: ‘¡Taita Abraham, s̈molastemá! Lázaro michmó chabe nts̈abuafja chaofchecuacuá y ats̈be bichtaja chauabofchecuacuaye, er quem íñeshoca ts̈a së́ntsesufrina ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham ibojauyana: ‘Uaquiñá, menojuabó, aca fshantsoca vida conjánbomna ora, lempe nts̈amo icojabos̈cá tconjanóyëngacñe, y Lázaro chë cuenta tondaye quenjátsbomna; pero morna, cha ts̈abá y oyejuayá entsemna, y aca jabuache ngménana contsebomna. ");
INSERT INTO kbh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y inÿe soye, canÿe bëts tbuañe entsemna ts̈ëngaftangbiocana më́ntscoñe; chca, chë ts̈ëngaftangbioye muents̈ana jenachnënguama tmojtsebos̈ënga ndoñe chamondëtsobena, ni chocana bë́ngbioye cach ndoñe ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Y chë bomná ibojauyana: ‘Masque chca, Taita Abraham, Diosmanda Lázaro michmó ats̈be taitabe yebnoye; ");
INSERT INTO kbh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","choca sëndábamna shachna cats̈átanga; as chaúyana nts̈amo moca ats̈e stsepasana y nts̈amo jamëse chënga ndoñe chaondë́tsamna quem ngménënga luaroye jabama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Chora Abraham ibojauyana: ‘Chënga ya mondbomna ndayá Moisés y chë Bëngbe Bëtsabe juabna oyebuambnayënga tmojëftsanábema soyënga; ¡chë́ngbioye chamoyauná ca!’ ");
INSERT INTO kbh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Chë bomná ibojojuá: ‘Ndoñe, Taita Abraham; nderado obanënguents̈ana canÿa chë́ngbioye tojase, aíñe chë ts̈abe benache muantishache ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham ibojauyana: ‘Chënga ni mo Moisés, ni chë Bëngbe Bëtsabe juabna oyebuambnayë́ngbioye ndoñe tmonjóyaunase, Bëngbe Bëtsábeñe ndoñe quemochatos̈buáchiye, masque canÿe obaná chauatayenëse, chë́ngbioye jábuayenama ca’ ” —Jesús tojancuentá. ");
INSERT INTO kbh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús chabe uatsjéndayënga tojanë́yana: “Sempre echanjë́ftsemna juabnënga bacna soyënga jamama; pero, ¡ts̈a lastema chë ents̈abiama ndabe causa ínÿenga bacna soyënga tmojama! ");
INSERT INTO kbh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más ts̈abá chabiama nántsemna canÿe nantsnëbé chamotsetamos̈ë́nts̈bua y mar béjayoye chamotsashbuets̈e, y ndoñe chë canÿa Bëngbe Bëtsábeñe os̈buachiyá bacna soye chaomama juanatsana. ");
INSERT INTO kbh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuedado s̈mochtsebomna. “Acbe cats̈ata bacna soye tojamëse, cochjuácacana; y yochtsajbaná ca cha tojayanëse, cochtseperdóna. ");
INSERT INTO kbh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masque nÿe canÿe te, canÿsëfta soye nts̈ámnaca tcmojaborlá, y canÿsëfta soye ‘chca ndoñe más quecbochatsbórla ca’ tcmojauyanëse, aca cmontsemna cha jtseperdónana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chë uatsjéndayënga Bëngbe Utabnábioye tmojaniyana: —Os̈buáchiyana s̈mababuaté ca. ");
INSERT INTO kbh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Y chë Utabná tojanë́jua: —Ts̈ëngaftanga os̈buáchiyana, bats̈atema masque nÿe mo mostaza jenaycá s̈mojtsebomnëse, quem sicomoro betiyoye s̈matjauyana: “quemuents̈ana mojashtse y mar béjayoca mojé ca”, y quem betiye chca nanjama ca. ");
INSERT INTO kbh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nderado canÿa ts̈ëngaftanguents̈á canÿe bochichnayá tbojtsebomna, cha jajocana tojtashjango jajañe arayocana o uacnënga anÿenocana, ¿chábioye bochjauyana: ‘Matabo y mabose ca’? ");
INSERT INTO kbh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ndoñe, chamna mënts̈á bochanjauyana: ‘Jetiñe juasama cochjuábua, y moprontá ats̈e jasérviama ats̈e candëse y candofs̈entscuana; y chents̈ana aca cochjase y cochjofs̈iye ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Y chë bochichnayábioye ndoñe quebochtë́tschuaye ndayá tbojuatariecá cha tojamama. ");
INSERT INTO kbh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ts̈ëngaftángnaca cachcá, lempe nts̈amo Bëngbe Bëtsá tcmojutariecá chas̈mojama ora, cmontsamna jayanana: ‘Nduámana oservénënga fsëndmëna; er nÿe nts̈amo jamama s̈uamncá tifjama ca’ ” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalenoye benache, Jesús tojánachnëngo Samaria y Galilea luarëjana. ");
INSERT INTO kbh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y canÿe pueblotémoye tojánashjango ora, bnë́tsana boyabásenga bacna nguayanánaca s̈oquënga chábioye tmojána; chábents̈ana bënoca chënga tmojanoquedá, ");
INSERT INTO kbh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","y mënts̈á imojtsáyebuache: —¡Jesús, Buatëmbayá, s̈motsalastemá ca! ");
INSERT INTO kbh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús chënga tojánanÿe ora, tojanë́yana: —Jerusalenoca bachnángbioye motsajna, y chënga s̈mochjínÿanÿiye ts̈ëngaftanga mora ndës̈oquënga s̈mojtsemnama ca. Y tojanopasá, chë bnë́tsanënga cabá imojétsayëntscuana, ya shnánënga imojtoquédaye. ");
INSERT INTO kbh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Canÿa chënguents̈á, shnaná yojtsemnama tojáninÿe ora, yojesshë́cona Bëngbe Bëtsábioye jabuache atschuanaye; ");
INSERT INTO kbh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","y Jesusbe delante yojoshëntsaments̈iye, jubiaca fshantsóntscoñe yojotsejbéna, y chábioye ibojtsatschuanaye; y chë boyabásana Samarioca ents̈á inamna. ");
INSERT INTO kbh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chora Jesús tbojaniyana: —Bnë́tsanënga mondmëna chë shnánënga tmontoquedanga. ¿Ndayents̈e chë inÿe esconë́ftanga imojtsemna? ");
INSERT INTO kbh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Nÿe quem boyabása, inÿe luarocana ashjangoná, tojesshë́cona Bëngbe Bëtsá jëtschuayama? ¿Ndáyeca chë ínÿenga ndoñe ca? ");
INSERT INTO kbh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y chë ents̈ábioye tbojaniyana: —Matëtsbaná y motsatoñe; Bëngbe Bëtsábeñe aca icos̈buachéyeca shnaná contsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Canÿe, chë fariseunga Jesús tmojantjá, mocna ora chë Bëngbe Bëtsabe amë́ndayana yochjanóshjanguama; y cha tojanë́jua: “Bëngbe Bëtsabe amë́ndayana chaojóshjango ora, ts̈ëngaftanga ndoñe ques̈mochatobenaye chca jinÿana. ");
INSERT INTO kbh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chora ndoñe quemochátichamo ‘Muents̈e entsemna’ o ‘Choca entsemna ca’; er Bëngbe Bëtsabe amë́ndayana ya ts̈ëngaftangbeñe entsemna ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús chabe uatsjéndayënga tojanë́yana: “Canÿe tempo echanjóshjango, y chora ts̈ëngaftanga s̈mochántsebos̈e canÿe te jtsebomnana, nts̈amo chë Bëngbe Bëtsá Ents̈á tbojanbemá ts̈ëngaftangbeñe enjëftsemna orcá; pero chora ndoñe chca queochatóshjango. ");
INSERT INTO kbh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chora báseftanga mochántsichamo: ‘Muents̈e entsemna’ o ‘Choca entsemna ca’; pero choye ndoñe s̈matjá, ni s̈matjúseto. ");
INSERT INTO kbh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Er chë tojatcuinÿe ora, nts̈amo celoca catoica juachoica tojabuashinÿinÿenacá, chca echántsemna chë Bëngbe Bëtsá Ents̈á tbojanbemá quem luaroye chaojésabo te. ");
INSERT INTO kbh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero natsana cha bontsemna puerte jasúfriana, y morsca ents̈angbiama uabotená jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nts̈amo Noé yojaniyena ora tojanopasacá, cachcá echanjopása chë Bëngbe Bëtsá Ents̈á tbojanbemá quem luaroye chaojésabo ora. ");
INSERT INTO kbh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chë tempo, ents̈anga imnasaye, imnofs̈ës̈naye, imnóbouamnaye; natjë́mbana imojtsiyeñe, y chca, natjë́mbana imojtsomñe, Noé chë barquë́shoye tojánamashënguëntscuana; pero chora uabouana uaftena tojánashjango y chë ents̈anga tojtsanapochocá. ");
INSERT INTO kbh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Cachcá nts̈amo Lot yojaniyena ora tojanopasacá: ents̈anga imnasaye, imnofs̈ës̈naye, imnóbouamnaye, imojtsena, sananga imnajena y imnajebuana; ");
INSERT INTO kbh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","pero Lot Sodoma bëts pueblents̈ana tojë́ftsanbocna ora, Bëngbe Bëtsá tojanma celocana íñeshe y azufre chauaftema, y chents̈a ents̈anga tojtsanapochocá. ");
INSERT INTO kbh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cachcá echántsemna chë Bëngbe Bëtsá Ents̈á tbojanbemá chaojtonÿná ora. ");
INSERT INTO kbh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Chë tena, nda cachabe yebnents̈a tsbanánoca chaojtsemna, y chabe soyënga cach tsoca tojtsebomnëse, chocana ndoñe chaondë́tastjango chë soyënga jesabobocnama; y nda jajoca chaojtsemna, yebnoye ndoñe chaondë́ta. ");
INSERT INTO kbh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Menójuabonga nts̈amo Lotbe shémaftaca tojanopasama. ");
INSERT INTO kbh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nda tojtsents̈ena quem luarents̈e bëtscá jtsebomnama y ats̈biama jasúfriama ndoñe tontseprontana, chë nÿetsca tescama yomna ts̈abe vida echanjobuets̈e. Pero nda quem luarents̈a soyënga cachcá tojonÿá ats̈e juastama, masque chaóbana, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ats̈e cbë́yana, chë ibeta, chë Bëngbe Bëtsá Ents̈á tbojanbemá chaojtonÿná ora, útata canÿe jutsnë́shañe bochántsemna; canÿa mochanjesbets̈e y chë ínÿana ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uta shembásata cánÿiñe bochántsejanÿcoye; canÿa mochanjesbets̈e y chë ínÿana ndoñe. ");
INSERT INTO kbh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Uta boyabásata jajoca bochántsetrabajaye; canÿa mochanjesbets̈e y chë ínÿana ndoñe ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chora chë uatsjéndayënga Jesús tmojantjá: —Utabná, ¿ndë́moca chca yochjopása ca? Y cha tojanjuá: —Chë obanabe cuerpo tojtsemnents̈e chë gallinacënga jojotana ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús mënts̈á tojanacuntá, ents̈anga jabuátambama, Bëngbe Bëtsáftaca nÿets tempo jtsencuéntayana yomnama, ainaniñe añemo jtsebomnama ndocna te ntjajbanacá. ");
INSERT INTO kbh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mënts̈á tojánayana: “Canÿe pueblents̈e canÿe mandado inamna; chana ni Bëngbe Bëtsábioye ndoñe bonjánebiauatja, ni ents̈anga yonjánayaunana. ");
INSERT INTO kbh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chë pueblents̈e canÿe viudánaca inamna; chana canÿe demanda yojánbomna. As chë mandádbioye yojobeconá y mënts̈á ibojauyana: ‘Diosmanda ats̈be uayayá motsecastigá ndayá s̈ojaborlama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Bayté chë mandado ndoñe yonjábos̈ena chë viudábioye joyeunayama; pero chents̈ana cha yojenójuaboye: ‘Masque Bëngbe Bëtsá ndoñe quetsátebiauatja, ni ents̈anga ndoñe quetsátayaunana, ");
INSERT INTO kbh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero quem viudá cada ora endabó causa, aíñe chanjóyeunaye, chabe uayayá chanjacastíga; ndóñesna cada te nandaboye y cabana ya s̈ochanjanamë́nts̈a ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chents̈ana Bëngbe Utabná tojánayana: “S̈monjouena nts̈amo chë ndoñe ts̈abá ama mandado yojayancá. ");
INSERT INTO kbh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Y chca, ¿Bëngbe Bëtsá chabe bocacánënga ndoñe yochanjátsebacaye? Chënga mora ínÿengbe causa montsesufrina y cada te Bëngbe Bëtsá mondbétseimpadana chaújabuachama. ¿Más chamuatobatmá ca yochjáuyana? ");
INSERT INTO kbh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ats̈e cbë́yana, Bëngbe Bëtsá betsco ts̈ëngaftanga cmochanjátsebacaye, ts̈ëngaftanga chë ínÿengbe causa mora s̈mojtsesufrínënga. Pero chë Bëngbe Bëtsá Ents̈á tbojanbemá chaojésabo ora, ¿cabá Bëngbe Bëtsábeñe os̈buáchiyënga quem luarents̈e ents̈anga yochjánÿena ca?” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Báseftanga imojtsanjuabná chënga ts̈abe ents̈anga imnamna ca, pero chë ínÿengbioye imojtsëbuayënja; chíyeca Jesús mënts̈á tojanacuntá jabuátambama: ");
INSERT INTO kbh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Uta boyabásata Bëngbe Bëtsabe bëts yebnoye tbojána Bëngbe Bëtsáftaca jencuéntama: canÿa yojamna fariseo, y chë ínÿana, canÿe Romocama ents̈ángbioye impuesto atjanayá. ");
INSERT INTO kbh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chocna chë fariseo, tsanana Bëngbe Bëtsábioye mënts̈á ibojtsecuéntaye: ‘Bëngbe Bëtsá, cbontsatschuaná ats̈e chë inÿengcá ndoñe quetsatsmënama: atbëbanënga, puerte bacna soye amënga y shémbioye ínÿaftaca íngñayënga; y ni quem Romocama impuesto atjanayacá ndoñe quetsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ats̈e sënduamana, ácaftaca jencuéntamna, canÿe semaniñe uta soye tondaye ntjascá jtsemnana; y lempe stjonÿenents̈ana, bnë́tsanents̈ana canÿe soye acbiama sëndëquëcjná ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero chë Romocama impuesto atjanayana, bënoca yojtsemna, ni celoye ntjontjes̈iycá, yojtsenócochjants̈etaye y mënts̈á yojtsichamo: ‘¡Ats̈be Bëtsá, s̈motselastemá, ats̈ajema bacna soye amá tsmëna causa ca!’ ” ");
INSERT INTO kbh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Chents̈ana Jesús tojánayana: “Ats̈e cbë́yana, quem Romocama impuesto atjanayá chabe yebnoye tojtaná chabe bacna soyëngama perdonaná, pero chë fariseo ndoñe. Er nda cachá bëtsá tojtsenobiamná, nduamaná mochántsebema; y nda cachá nduamaná tojtsenobiamná, aíñe bëtsá mochanjábema.” ");
INSERT INTO kbh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ents̈anga imojanamana Jesúsbioye basetémënga junatsana chauabájajuama, y Bëngbe Bëtsábioye chëngbiama chaboimpadama; pero chë uatsjéndayënga chca tmojáninÿe ora, tmojanonts̈é chë basetémënga unachayënga jtsëcácanana. ");
INSERT INTO kbh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesusna chë basetémënga tojánachembo, y mënts̈á tojánayana: “Cachcá mónÿaye chë basetémënga áts̈bioye chamuabo, y ndoñe matë́uyanana; er Bëngbe Bëtsabe amë́ndayana endmëna chë mo quem basetemëngcá imomnëngbiama. ");
INSERT INTO kbh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ndegombre cbë́yana, nda Bëngbe Bëtsabe soyënga ndoñe tonjóyëngacñe mo canÿe basetemcá jtsos̈buáchiyëse, cha ndoñe queochatobenaye Bëngbe Bëtsabe amë́ndayoye jamashënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Canÿe mandayá Jesúsbioye tbojantjá: —Ts̈abe Buatëmbayá, ¿ndayá s̈ojtsemna jamana chë nÿetsca tescama yomna ts̈abe vida jtsebomnama ca? ");
INSERT INTO kbh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y Jesús tbojanjuá: —¿Ndáyeca s̈cjauyana “ts̈abia ca”? Ts̈abia nÿe canÿa endmëna: Bëngbe Bëtsá. ");
INSERT INTO kbh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aca condë́tats̈ëmbo nts̈amo Bëngbe Bëtsá tojanmandacá: “Acbe shema ínÿaftaca ndoñe cattseíngñaye, inÿa ndoñe catjóba, ndoñe catjatbëba, ndoñe catjuaboínÿena y acbe bëtsë́tsata ndoñe stëts̈oye catjáquedaye ca.” ");
INSERT INTO kbh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chora chë boyabása tbojanjuá: —Ats̈e lempe chca básetema orscana sëndocumplina ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús chca tojanuena ora, tbojaniyana: —Cabá canÿe soye cmontsebuáshbena jamana: lempe nts̈amo icobomncá cochjetsatobuiye, y chë crocénana, ndbomnëjémënga cochtsats̈ataye; chca, celoca canÿe bëts bomnana cochántsebomna. Chents̈ana, cochjabo y s̈cochjuasto ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chë ents̈á chca tojanuena ora, puerte ngménaca yojtsemna, er cha corente bomná inamna. ");
INSERT INTO kbh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chca ngmená tbojáninÿe ora, Jesús tojánayana: —¡Yapa totcá bomnëngbiama entsemna Bëngbe Bëtsabe amë́ndayoye jamashënguama! ");
INSERT INTO kbh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ndegombre, más paselo endmëna canÿe camello chë coshufjents̈a atëfjnëjana chauachnëngo, y ndoñe canÿe bomná Bëngbe Bëtsabe amë́ndayoye jamashënguana ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chora, chë chca imojouenënga tmojánayana: —¿As nda yochjobenaye atsbocaná jtsemnana ca? ");
INSERT INTO kbh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y Jesús tojanë́jua: —Ndayá ents̈anga ndoñe mondobena jamana, Bëngbe Bëtsá aíñe endobena jamana ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chora Pedro, Jesúsbioye tbojaniyana: —Bëngbe Utabná, aca contsonÿá, bënga lempe chë fsë́ndbomna soyënga fsënjéseboshjona, y ácaftaca fsëntsajna ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús chora tojanë́yana: —Ndegombre cbë́yana, ndánaca Bëngbe Bëtsábioye jasérviama, chabe amë́ndayama jtsabuayiynayëse, cachcá tojë́ftseboshjona chabe yebna, shema, cats̈átanga, bëtsë́tsanga o básenga, ");
INSERT INTO kbh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","cha mora quem luarents̈e chë soyëngama más echanjóyëngacñe, y chë inÿe luarocna, chë nÿetsca tescama yomna ts̈abe vida ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús chabe bnë́tsana uta uatsjéndayënga barie tojánachembo, y mënts̈á tojanë́yana: “S̈montsetáts̈ëmbo mora Jerusalenoye bënga montsajnama, y choca lempe echanjochnëngo nts̈amo chë Bëngbe Bëtsabe juabna oyebuambnayënga, chë Bëngbe Bëtsá Ents̈á tbojanbemabiama tmojanabemcá; ");
INSERT INTO kbh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","er choca cha chë ndoñe judiëngbe cucuats̈iñe mochanjáboshjona, y mochantsáboyejuana, mochanjóyenguango, mochántsebuashëtotjo; ");
INSERT INTO kbh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","y chamojátjanjents̈ana, mochanjóba, pero unga tianoye cha echántayena ca.” ");
INSERT INTO kbh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chë uatsjéndayënga tondaye tonjanësertá, ni montsetáts̈ëmbo ndayá bétsemnana nts̈amo Jesús yojtsëtsëtsnacá, er chëngbiama yojamna josértama ndopodena soyënga. ");
INSERT INTO kbh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tojanopasá, Jesús Jericó puebloye yojtsebéconaye ora, canÿe jtaná benache juachañe inatbemana, lemos̈na otjanañe. ");
INSERT INTO kbh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ents̈anga chëjana imojtsachnëjuanama tojanuena ora, yojanotícia ndayá yojtsopasana ca, ");
INSERT INTO kbh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","y chë ents̈anga tmojaniyana, —Jesús Nazaretocá entsebeconá ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","As cha yojonts̈é uayebuáchana: —¡Jesús, Davídbents̈ana Ents̈á, s̈motselastemá ca! ");
INSERT INTO kbh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Chë natsana imojtsajnënga chë jtaná imojtsácacana, iytëca chaóbemama; pero cha más yojtsáyebuache: —¡Davídbents̈ana Ents̈á, s̈motselastemá ca! ");
INSERT INTO kbh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","As Jesús tojantsá y tojanmandá cha chamobets̈ama. Cha ya bécoñe yojtsemna ora, Jesús tbojantjá: ");
INSERT INTO kbh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ndayá cojtsebos̈e ats̈e acbiama chjamama ca? Y chë jtaná tbojanjuá: —Ats̈be Utabná, ats̈e së́ntsebos̈e chas̈uatabínÿnama ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chora Jesús tbojaniyana: —Matinÿe, Bëngbe Bëtsábeñe betsos̈buachéyeca shnaná contsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y cachora cha ts̈abá ibojtabinÿna, y Jesúsbioye ibojtsë́stona, Bëngbe Bëtsá atschuanaye. Y nÿetsca ents̈anga, chca tmojáninÿe ora, Bëngbe Bëtsá imojtsatschuanaye. ");
INSERT INTO kbh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericó puebloca tojánashjango ora, chë pueblëjana cha yojtsachnëjuana. ");
INSERT INTO kbh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","3","Chora, canÿe bomna ents̈á, chë Romocama ents̈anga impuesto atjanayëngbe amëndayá, Zaqueo ca uabainá, yojtsebos̈e Jesús jinÿama. Pero ndoñe yontsobena jinÿama, bëtscá ents̈anga causa y cha becua inamna causa. ");
INSERT INTO kbh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chcasna, cha betsco natsanoye tojaftsanótjajo y canÿe sicomoro betiyeshoye tojánas̈ëngo, chca, Jesús chëjana tojtsachnëjuana ora, jinÿama jobenayama. ");
INSERT INTO kbh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús chë betiyeshoye tojánashjango ora, tsbanánoye tojanontjes̈é y Zaquéobioye tbojáninÿe. As Jesús tbojaniyana: “Betsco chocana matastjango, Zaqueo, er mënté chanjá acbe yebnoye jatema ca.” ");
INSERT INTO kbh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chora Zaqueo betsco tojtanastjango y chents̈ana puerte oyejuayá Jesúsbioye tbojanofja. ");
INSERT INTO kbh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ents̈anga chca tmojáninÿe ora, tmojanonts̈é Jesusbe contra mënts̈á ichámuana: “Jesús tonjá canÿe bacna soyënga amabe yebnents̈e jatema ca.” ");
INSERT INTO kbh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chora Zaqueo tojantsá, Bëngbe Utabná Jesúsbents̈e, y mënts̈á tbojaniyana: —Mouena, ats̈be Utabná, ats̈be bomna soyënguents̈ana tsë́ntsañe ndbomnëjémënga chanjáts̈ataye y nda más crocénana tijëftseyëngacá, chë ntsachets̈á tijë́ftsefcama canta soye más chantoyiye ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","As Jesús tbojaniyana: —Mënté, aca acbe bacna soyënguents̈ana atsbocaná contsemna, er Zaqueo, ácnaca Abrahámbents̈ana ents̈á condmëna. ");
INSERT INTO kbh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Er chë Bëngbe Bëtsá Ents̈á tbojanbemá tojabo chë pochocánënga jtsemnama imojtsajnënga jabétsanguanguama y jabátsebacama ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ents̈anga chë soyënga imojtsuenana, y Jesús inÿe soye tojanacuntá jabuátambama, er cha ya Jerusalén béconana yojtsemna, y ents̈anga imojtsejuabnaye chë Bëngbe Bëtsabe amë́ndayana ya yochjanóshjango ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jesús tojanë́yana: “Canÿe luarents̈a uámana ents̈á inÿe bën luaroye yojá, cachabe luarents̈a rey chamobemama y chents̈ana cachábioye jtama. ");
INSERT INTO kbh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cabá nda ora, chabe bnë́tsana oservénënga yojáchembo y bëtscá crocénana cada cánÿabioye yojë́ftsayents̈buachiye, y mënts̈á yojëftsë́yana: ‘Quem crocenánaca trato s̈mochjábema ats̈e candëtabëntscuana ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero cachabe luarents̈a ents̈anga cha imojuáya, as chëngna básefta ents̈anga imojichamuá chë inÿe bën luaroca mënts̈á chamuayanama: ‘bënga ndoñe queftsátsbos̈e cha bëngbe rey chaotsemnama ca’. ");
INSERT INTO kbh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pero pronto chë luarents̈a rey cha imojábema. Y chë luaroye yojtá orna yojamánda chë crocénana yojëftsayents̈buáchenga chamobéconama, jtsetats̈ëmbuama ntsachets̈á cada ona chë crocenánaca yojongánama. ");
INSERT INTO kbh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chë natsaná yojáshjango y yojayana: ‘Taita, acbe crocénana bnë́tsana soye más tonjoboté ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y chë rey ibojojuá: ‘Ts̈a ts̈abá, ts̈abe oservená. Aca quem base soyiñe nts̈amo tcbojamandacá ts̈abá tcojámayeca, bnë́tsana pueblents̈a mandado chacotsemnama cbojayé ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chents̈ana inÿa yojáshjango y yojayana: ‘Taita, acbe crocénana shachna soye más tonjoboté ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y chë rey ibojauyana: ‘Acnaca shachna pueblents̈a mandado cochántsemna ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Chorna inÿa yojobeconá y mënts̈á yojayana: ‘Taita, muents̈e acbe crocénana entsatsmëna; canÿe pañuelë́juañe bonguana sëntsejajo. ");
INSERT INTO kbh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ats̈e acbiama uatjana s̈onjuábuache, er aca canÿe ts̈átjaye ents̈á condmëna; aca chë ndoñe condbuajonents̈ana jocñana y chë ndoñe tconjajé luarents̈ana jaja saná jobuátbanana ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","As chë rey ibojauyana: ‘Bacna oservená, cach acbe palabrë́ngaca chanjínÿanÿiye aca ndoñe ts̈abá tconjamama. Ats̈e chë ndoñe sëndbuajonents̈ana jocñana y chë ndoñe sënjajé luarents̈ana jobuátbanana tsuamanama icojátats̈ëmbëse, ");
INSERT INTO kbh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿ndáyeca ndoñe tconjá chë crocénana bancoca jetsobuájuama, y ats̈e camoye matijtabo ora, mas̈ctoyé chë crocénana y chë chents̈ana tojoboté crocénanënaca ca?’ ");
INSERT INTO kbh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y chë chents̈e imojtsemna ents̈anga yojáuyana: ‘Chë crocénana motseboca y chë bnë́tsana soye más tojabotébioye chana motsats̈etá ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","As chënga imojojuá: ‘¡Pero cha ya bnë́tsana soye más entsebomna ca!’ ");
INSERT INTO kbh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Y chë rey yojójua: ‘Ats̈e cbë́yana, nda tojtsebomnábioye, más mochanjáts̈etaye; pero nda tondaye tondbomnábioye, chë tojtsejuabná bats̈atema yobomna sóynaca mochántseboca ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Y chë ats̈e uayayënga, chë chëngbe rey ats̈e chaitsemnama ndoñe monjánbos̈ëngna, moye mënatse y ats̈be delante s̈mochtsëbaye ca’ ” —cha chora yojayana. ");
INSERT INTO kbh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","29","Chca tojë́ftsanayana chents̈ana, Jerusalenoye yojétsaye ora, Jesús tojánashjango canÿe tjashoye, Olivos ca uabáiniñe, Betania y Betfagé pueblënga béconana. Chora, uta chabe uatsjéndayata tojanichamó, ");
INSERT INTO kbh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","mënts̈á jáuyanëse: “Tsëndatbe natsana entsemna base pueblotémoye motsata. Chas̈ojáshjango ora, canÿe burrotema utsbuaná s̈ochanjínÿena. Chábeñe cabá ndocná tonjenojayé. S̈ochjuajafjoná y s̈ochjuánatse. ");
INSERT INTO kbh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y nderado nda ndáyeca s̈ojtsajafjná ca chacmojátjasna, s̈ochjauyana: ‘Bëngbe Utabná bontsájaboto ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chë uatsjéndayata tbojána y lempe nts̈amo Jesús tojanëyancá tbojáninÿena. ");
INSERT INTO kbh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Y chë burrotema imojtsajafjná orna, chë burrotema nduiñënga tmojanë́yana: —¿Ndáyeca chë burrotema s̈ojtsajafjná ca? ");
INSERT INTO kbh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chora chata tbojánayana: —Bëngbe Utabná bontsajabótoyeca ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Chents̈ana Jesúsbioye chë burrotema tmojanánatse, y chë burrotémbeñe chatbe ents̈ayá tbojanájatse, y chábeñe Jesús tmojanenjayé. ");
INSERT INTO kbh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y cha yojtsachnëjuana ora, ents̈anga chëngbe ents̈ayá benachëjana imojtsëtë́tsatsana. ");
INSERT INTO kbh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos tjashe tsmanoye yojtsebeconá ora, chë bëtscá ents̈anga, Jesúsbeñe os̈buáchiyënga, tmojanonts̈é uayebuáchana y Bëngbe Bëtsá oyejuayënga jëtschuayana, Bëngbe Bëtsabe obenánaca bëts soyënga Jesús tojanmama. ");
INSERT INTO kbh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Chënga mënts̈á imojtsichamo: “¡Corente bendición bomná chaotsemna, chë Bëngbe Utabnabe obenánaca tojabo Rey ca! ¡Celoca ts̈abá entsemna! ¡Bëngbe Bëtsá matschuanga ca!” ");
INSERT INTO kbh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chë ents̈anguents̈e básefta fariseunga imojtsemnënga, Jesús tmojaniyana: —Buatëmbayá, acbe ústonënga mëcácana chca ndoñe chamondëtsáyebuachama ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús mënts̈á tojanë́jua: —Ndegombre cbë́yana, mënga iytëca tmojobiamëse, chë ndëts̈benga muanjuayebuáchena ca. ");
INSERT INTO kbh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén béconana tojánashjango, y chë bëts pueblo tojáninÿe ora, chents̈a ents̈angbiama tojánenobos̈achna. ");
INSERT INTO kbh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Y mënts̈á tojánayana: “¡Malaye s̈mëntsetáts̈ëmbo, nÿe mo mënténaca, ndayá yojtseita ts̈ëngaftangbeñe lempe ts̈abá chaotsomñama! Pero mora chë soye ts̈ëngaftangbe bominÿama entsëitë́mena. ");
INSERT INTO kbh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Er Jerusalenoca bacna tenga echanjóshjango; chora uayayënga chents̈a shëconánëjana canÿe tapiës̈e mochantsepórma, mochantsejétja y nÿetsca juachoicana mochanjonts̈é ts̈ëngaftanga jtsatsejana, ");
INSERT INTO kbh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","y lempe mochantsepochóca. Muents̈a oyenënga mochantsëbaye, y ni mo canÿe ndëts̈bé inÿebé juatsboca quemochaiseboshjona, chë Bëngbe Bëtsá ts̈ëngaftanga játsebacama tojabo ora, ndoñe ches̈matoyeuná causa ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Chents̈ana, Bëngbe Bëtsabe bëts yebnoye Jesús tojánamashëngo y tojanonts̈é chë chents̈e imojtsenënga chents̈ana jtëbuacnana, ");
INSERT INTO kbh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","y tojanë́yana: “Bëngbe Bëtsá chabe uabemana palabrënguiñe tojayana: ‘Ats̈be bëts yebna echántsemna áts̈eftaca encuéntaye yebna ca’, pero ts̈ëngaftangna, atbëbanëngbe oyeniñe chë yebna s̈mojtsebema ca.” ");
INSERT INTO kbh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y cada te, Bëngbe Bëtsabe bëts yebnents̈e Jesús ents̈anga yojtsabuátambaye; y bachnangbe amë́ndayënga, ley abuátambayënga y chë pueblents̈a mandayë́ngnaca imojtsenguaye nts̈amo jamëse cha jóbana. ");
INSERT INTO kbh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ndoñe tmonjáninÿena nts̈amo, er nÿetsca ents̈anga corente imojtseyeunana nts̈amo cha yojtsoyebuambnacá. ");
INSERT INTO kbh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Canÿe te, Bëngbe Bëtsabe bëts yebnents̈e Jesús yojtsabuátambaye, y chë ts̈abe noticiëngama yojtsabuayiyná ora, tmojánashjajna bachnangbe amë́ndayënga, ley abuátambayënga, judië́ngbeñe bëtsëjemëngcá mandayë́ngaftaca cánÿiñe; ");
INSERT INTO kbh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","y Jesús tmojaniyana: —S̈më́yana; ¿ndaye deréchoca chë contsama soyënga aca cojtsama ca? o ¿chca jtsamama nda obenana tcmënjats̈etá ca? ");
INSERT INTO kbh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chora Jesús tojanë́jua: —Ats̈naca canÿe soye së́ntsebomna ts̈ëngaftanga jatjayama. S̈mochjojuanga. ");
INSERT INTO kbh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nda Juan chë Ubayaná tbojanichmó ents̈anga jubáyama, Bëngbe Bëtsá o ents̈anga ca? ");
INSERT INTO kbh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chora chënga tmojanonts̈é enatsëtsnayana: “ ‘Bëngbe Bëtsá ca’ chamojojuase, cha s̈ochanjáuyana: ‘As ¿ndáyeca chábeñe ndoñe s̈monjanos̈buaché ca?’ ");
INSERT INTO kbh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y ndoñe quemuátobena jayanana ‘ents̈anga ca’; ents̈anga ndëts̈béngaca buattsë́baye, er nÿetscanga becá mondëjuabná Juan ndegombre Bëngbe Bëtsabe juabna oyebuambnayá yojamnama.” ");
INSERT INTO kbh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chcasna, chënga tmojanjuá ndoñe monjántats̈ëmbo nda Juan tbojanichmó ents̈anga jubáyama ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y Jesús tojanë́yana: —Asna ats̈e cach ndoñe quecbochatë́yana ndaye deréchoca chca stsama ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chents̈ana Jesús tojanonts̈é ents̈anga jáuyanana, y quem cuéntoca tojanabuatambá: “Canÿe ents̈á uvas betiyënga yojáje y chë fshantse inÿe trabájayënga yojúyents̈ame, y baytescama bën luaroye yojtsoñe. ");
INSERT INTO kbh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chë uvasës̈angá juashacama tempo yojobuache orna, chë jajañe nduiño canÿe oservená ibojíchmua chë trabájayënga jáuyanama ntsachets̈á cha ibojtsotocánama. Pero chëngna cha imojtsejants̈etaye, y tondaye ntoyiycá imojtichmuá. ");
INSERT INTO kbh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chents̈ana inÿa ibojíchmua; pero chë trabájayënga cha imojtsejants̈etaye, imojtsóyenguango, y tondaye ntoyiycá imojtichmuá. ");
INSERT INTO kbh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chë nduiño inÿa ibojatichmuá; pero chánaca chënga imojtsejants̈etaye, imojtselísia, y chents̈ana imojtábocna. ");
INSERT INTO kbh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Chora chë nduiño yojeniyana: ‘¿Y mora nts̈amo chjama ca? Cach ats̈be bonshana uaquiñá chanjíchmua; nderádose cha aíñe mochanjóyeunaye ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero chë trabájayënga, chë uaquiñá imojinÿe orna imojeniyana: ‘Mua chë fshantse nduiñbe uaquiñá entsemna. Lempe chabe soyënga mua echanjóyëngacñe; motsóbanga y nÿetsca chabe otocana soyënga bëngbiama echanjoquéda ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chcasna, chë uvas jajañents̈ana cha imojtsábocna y imojtsóba.” Chora Jesús tojanatjá: —Y asna, ¿nts̈amo s̈mojtsejuabná, ndayá chë jajañe nduiño chë trabajayë́ngaftaca yochjama ca? ");
INSERT INTO kbh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cha co echanjá y chë trabájayënga echanjetsëbaye, y chë uvas betiyënga jajañe inÿe trabájayënga echanjárrendaye ca. Chë ents̈anga chca tmojanuena ora, tmojánayana: —¡Bë́ngaftaca ndocna te chca chaondopasá ca! ");
INSERT INTO kbh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús tojanënÿanÿé y tojánayana: —As ¿ndayama Bëngbe Bëtsabe uabemana palabrënguiñe iuayana?: Chë yebna jebuanënga tmojtsanaboté ndëts̈bé, mora chë más bëts uashacuanës̈ents̈e entsejájona ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndánaca chë ndëts̈beñe chaojotsats̈á, chëbé bochántsatcacaye; y chë ndëts̈bé ndábeñnaca chaojótsats̈e, polvëshe bochántsebema ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chë bachnangbe amë́ndayënga y ley abuátambayënga tmojanenótats̈ëmbona Jesús chca tojanacuntá jinÿanÿiyama, chënga mo chë puerte bacna trabajayëngcá imojamnama; asna tmojánbos̈ena cachora jishachana, pero ents̈angbiama imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Chents̈ana chënga báseftanga tmojanichamó, mo ndegombre ts̈abe ents̈anga cuaftsemncá chamobiamëse, Jesús jisháchichiyama, nderado ndayá cha tojayaniñe; y chca chënga jobenayama cha jishachana y chëngbe mandádbioye juanatsama. ");
INSERT INTO kbh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","As chënga tmojantjá: —Buatëmbayá, bënga fsë́ntsetats̈ëmbo nts̈amo aca cojtsoyebuambná y cojtsabuatambacá ndegombre ts̈abá yomnama, nts̈amo ndegombre Bëngbe Bëtsá yobos̈cá, y acbiama tondaye quenatámana nda más uamaná o nduamaná tomnana. Aca contsabuatambá ndegombre ts̈abe vida jtsebomnama, nts̈amo Bëngbe Bëtsá yomandacá. ");
INSERT INTO kbh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chcasna, s̈më́yana, ¿ts̈abá tayojtsemna bënga, César, chë Romoca bëts mandadbiama, impuesto jtsatsquë́cjnayana o ndoñe ca? ");
INSERT INTO kbh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús yojtsetáts̈ëmbo, nts̈amo cha tojayaniñe jisháchichiyama chënga imojtsebos̈ama; as tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Chë s̈matsquëcjná crocénana s̈minÿinÿenga ca; ¿ndabe jubiá chë crocenániñe yojtsemna, y nts̈amo muents̈e entsabemancá nda chca iuabaina ca? Y chënga tmojanjuá: —Césarbe jubiá; cha chca enduabaina ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y Jesús tojanë́yana: —César s̈mochtoyiye cha ibotocana soye; y Bëngbe Bëtsana cha ibotocana soye ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y chca, chë ichmónënga ndoñe imonjobenaye jisháchichiyana, ndayá cha ents̈angbe delante tojayaniñe. Masna, nts̈amo tojanë́juama, ojnanánënga iytëca imojobiama. ");
INSERT INTO kbh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chents̈ana, báseftanga saduceo ca uabaina ents̈anga tmojána Jesús jinÿama. Chënga imojanjuabná obanënga ndocna te ntayenana ca. Jesús mënts̈á tmojantjá: ");
INSERT INTO kbh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Buatëmbayá, Moisés bëngbe leyënguiñe tojë́ftsanabema, nderado canÿe boyá tojtsóbana y básenga ndoñe tonjëftsabáshejuanësna, canmëna chë uabentsá chë shémaftaca jtobouamayana, chca, chë chabe uabochená obanabiama básenga jtsabamnama ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Chcase, canÿe bë́ngbents̈e canÿsëfta cats̈átanga monjamna. Chë natsaná tonjanobouamá y tontsanóbana, básenga ntjëftsabashejuancá; ");
INSERT INTO kbh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","chents̈ana chë inÿa chë shémaftaca tonjanobouamá, y cachcá tonjanopasá. ");
INSERT INTO kbh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chë inÿe uabentsá chora cháftaca tonjanobouamá, pero tontsanóbana básenga ntjëftsabashejuancá; y cachcá, chë inÿe uabentsë́ngnaca cháftaca tmonjanobouamá, pero nÿetscanga tmonjanóbana básenga ntjëftsabashejuancá. ");
INSERT INTO kbh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cabana, chë shembásanaca tontsanóbana. ");
INSERT INTO kbh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y chcasna, chë obanënga chamojtayena ora, ¿ndabe chë canÿsëfta cats̈atanguents̈abe shema chë shembása yochtsemna, nÿetscanga cháftaca tmojanobouamase ca? —chënga tmojantjá. ");
INSERT INTO kbh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Chora Jesús tojanë́jua: —Quem luarents̈e boyabásenga y shembásenga mondbétsobouamnaye; ");
INSERT INTO kbh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","pero chë echanjóshjango luaroye jama y obanënguents̈ana jtayenama merecido jtsebuájonama chamojobenangna, masque boyabásenga o shembásenga, ya ndoñe quemochatóbouamnaye, ");
INSERT INTO kbh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ni queochátopodena chënga chamóbanama, y chca, chënga mochántsemna mo angelëngcá, y Bëngbe Bëtsabe básenga mochántsemna, obanënguents̈ana mochtayénayeca. ");
INSERT INTO kbh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Y Moisésnaca, chë yojtsángbototjuana betiyetémama tojanábements̈e, bënga s̈ontsinÿanÿná chë obanënga imnátayenama; chents̈e Bëngbe Bëtsá tojánayana cha yomna Abraham, Isaac y Jacobëbe Bëtsá ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bëngbe Bëtsá chca tojánayana ora, entsichamo cha ndoñe yondmëna obanëngbe Bëtsá, sinó aina ents̈angbe Bëtsá ca, er masque chënga tmojanóbana, chënga cabá Bëngbe Bëtsáftaca mondoyena ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chora básefta ley abuátambayënga Jesús tmojaniyana: —Buatëmbayá, ts̈abá tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y ya ndoñe más montsenñémua inÿe soyëngama jatstjanayana. ");
INSERT INTO kbh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús tojanatjá: “¿Ndáyeca ts̈ëngaftanga s̈mnétsichamo chë Uámana Uabuayaná, chë Cristo, Rey Davídbents̈ana iuabó ca? ");
INSERT INTO kbh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Er cach David, chabe librë́s̈añe Salmos ca uabainë́s̈añe, tojánayana: Bëngbe Bëtsá, ats̈be Utabná Crístbioye tbojaniyana: ‘Ats̈be cats̈bioica mótbema, ");
INSERT INTO kbh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ats̈be obenánaca, acbe uayayënga acbe cucuats̈iñe chamoquedama chjamëntscuana ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Nts̈ámose, Cristo, Davídbents̈ana nántsemna, cach David ‘Utabná ca’ chábioye tbojtsabobuátmëse ca?” —cha tojanatjá. ");
INSERT INTO kbh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nÿetsca ents̈anga imojtsuenana, y Jesús chabe uatsjéndayënga tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cuedado s̈mochtsebomna, y ndoñe s̈mattsama chë ley abuatambayëngcá; chënga jtsogusetánana bënëna ents̈ayangaca jtsajnana, y jtsebos̈ana tsáshenañe ents̈anga becá respétoca chamotsacheuanayama. Chënga chë judiëngbe enefjuana yebnënguenache chë más uámana luarënguiñe jtsetbiámanana, y fiestënguiñe nÿa quëfseroca. ");
INSERT INTO kbh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero chë viudángbioye chë tmobomna soyënga jtsabacayana; y ents̈angbe delante ts̈abá chacmotsë́nÿama y chënga imojtsaíngñama ndoñe chaondëtsótats̈ëmbuamna, Bëngbe Bëtsáftaca ts̈a jtsencuéntayana. Chë causa, Bëngbe Bëtsá ínÿengbiama más chënga echanjácastigaye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bëngbe Bëtsabe bëts yebnents̈e, Jesús yojtsë́nÿaye chë bomnënga crocénana jtsequëcjnayana chë crocénana quëcjnayëtémiñe; ");
INSERT INTO kbh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","y canÿe viudá ndbomnëjémnaca tbojáninÿe, uta crocénana chëtémiñe yojaftsesegóra. ");
INSERT INTO kbh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chora Jesús tojánayana: “Ndegombre cbë́yana, quem viudá ndbomnëjema, Bëngbe Bëtsabiama nÿetscangbiama más becá tonjëftsesegorá; ");
INSERT INTO kbh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","er nÿetscanga tmonjëftsesegorá chë yojtsóyents̈jaments̈ana, pero chana, masque ts̈a ndbomnëjema, cha vida jtsebomnama lempe ntsachets̈á yobomncá tonjëftsesegorá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Báseftanga imojtsichamo chë Bëngbe Bëtsabe bëts yebnama, ts̈a yojtsebotamanana puerte uámana ndëts̈béngaca y chë ents̈anga imojanamana juambana Bëngbe Bëtsábioye uáts̈ëmbona soyë́ngaca ca. As Jesús tojánayana: ");
INSERT INTO kbh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Canÿe tempo echanjóshjango, y lempe nts̈amo mora muents̈e s̈montsonÿacá tondaye queochatoquéda, ni mo canÿe ndëts̈bé inÿebé juatsboye. Lempe mochantsepochóca ca. ");
INSERT INTO kbh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chora chënga tmojantjá: —Buatëmbayá, ¿ntseco chca yochjopása? ¿Y ndayá Bëngbe Bëtsá yochjama, chca jopásama yojtsobecuama ents̈anga chamotsetats̈ëmbuama ca? ");
INSERT INTO kbh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y Jesús tojánayana: —Cuedado s̈mochtsebomna ndocná chacmondáingñema. Er banga mochanjabo y mochantsabíchamo chënga ats̈e imomna ca. Mochántsichamo: “Ats̈e chë Cristo sëndmëna”, y “Mora chë tempo entsemna ca”. Pero ndoñe s̈matjóyaunaye. ");
INSERT INTO kbh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y ts̈ëngaftanga, ents̈anga imojtsentsjanama y ents̈anga mandadëngbe contra imojtsemnama chas̈mojtsuenana ora, ndoñe s̈mattsauatja, er entseyta natsana chë soyënga chaochnëngo; pero masque chca, chë quem luare jopochócama tempo cabá ndoñe queochátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y mënts̈ánaca Jesús tojanë́yana: “Canÿe luarents̈a ents̈anga, inÿe luaroca ents̈ángaftaca mochántsentsjanaye; y canÿe amëndayábents̈a ents̈anga, inÿe amëndayábioca ents̈angaftácnaca. ");
INSERT INTO kbh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ba luarënguiñe jabuache echanjuangmë́mana, bëts shëntsana, y ents̈anga pochócaye s̈ocanënga echanjóshjango; y celoca echántsemna puerte uabouana soyënga y bëts soyënga, ents̈anga jinÿanÿiyama quem luare ya yochtsopochócama. ");
INSERT INTO kbh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero cabá ndoñe chca chaondochnëngo ora, ts̈ëngaftanga cmochanjíshëche y chas̈mosufrima mochántsama; bënga judiëngbe enefjuana yebnëngoye cmochanjunatse játsets̈enama y cárceloynaca cmochanjáutame, y reyënga y mandadëngbióynaca cmochanjunatse, ats̈be ústonënga bétsemna causa. ");
INSERT INTO kbh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chca s̈mochanjapása, nts̈amo ats̈biama s̈motats̈ëmbcá chënga chas̈më́yanama. ");
INSERT INTO kbh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Natsana ndoñe s̈matjátsjuabnaye jenë́uyanama nts̈amo chora jóyebuambayana, ");
INSERT INTO kbh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","er ats̈e chanjama puerte ts̈abá y osertanánaca ts̈ëngaftanga chas̈móyebuambama; y chca, ts̈ëngaftangbe uayayënga ndoñe quemochatobenaye jayanana ndoñe ts̈abá s̈montsichamo ca, y ndocá jojuama quemochatobenaye. ");
INSERT INTO kbh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero uayayëngbe cucuats̈iñe cmochanjábashejuana cach ts̈ëngaftangbe bëtsë́tsanga, cats̈átanga, pamíllanga y amiguënga; y ts̈ëngaftanguents̈ana báseftanga cmochantsëbaye. ");
INSERT INTO kbh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Y nÿetsca ents̈anga cmochantsë́buayënja, ats̈be ústonënga bétsemna causa. ");
INSERT INTO kbh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ts̈ëngaftangbe bests̈as̈ents̈ana ni mo canÿe stjënëja quecmochátabajajo. ");
INSERT INTO kbh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ts̈ëngaftanga nÿets tempo áts̈beñe os̈buáchiyënga chas̈mojtsemnëse, chë nÿetsca tescama yomna ts̈abe vida s̈mochántsebomna ca. ");
INSERT INTO kbh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén nÿets shë́conana soldadënga chas̈mojanÿe ora, s̈mochtsetáts̈ëmbo Jerusalén jopochócama tojobuáchama. ");
INSERT INTO kbh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chorna, chë Judeoca oyenënga batsjabengoye chamotsacheta; Jerusalenents̈e chamojtsemnënga, chents̈ana chamuaisebocana; y chë jajenache chamojtsemnëngna, Jerusalenoye ndoñe chamondésamashjna. ");
INSERT INTO kbh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Er chora echántsemna chë ents̈angbe jabuache castigo; lempe nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá chora echanjochnëngo. ");
INSERT INTO kbh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ts̈a lastema chë tempo shembásenga ngomámanëngbiama o ochóchaye básenga chamojtsabamnëngbiama! Er chora corente ngménana quem luarents̈e echántsemna, y quem luarents̈a ents̈angbiama chë uabouana castigo. ");
INSERT INTO kbh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Inÿenga espadë́jaca mochanjóbana, y ínÿengbioye nÿetsca luarënguëjana utámenënga mochanjunatse; y chë ndoñe judiëngna, Jerusalenoca ents̈ángbioye mochántsatsejaye y mochantsëbaye, chca chaotsemnama Bëngbe Bëtsá tojalesenciantscuana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mënts̈ánaca Jesús tojánayana: “Chora bëts soyënga echantsinÿna shinÿiñe, juashconiñe y estrellënguiñe; y quem luarents̈a ents̈anga ts̈a mochántsauatja, ndayá jamama ntsetats̈ëmbcá, chë mar béjaye y olëshënga corente echantsefshauenana causa. ");
INSERT INTO kbh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ents̈anga echantsabuatëcja ts̈a auatja causa y ndayá quem luariñe yochjopásama enócochinÿena causa; er chë quem luarents̈a tsbanánoca espíritënga obenana bomnënga echanjángmëmana. ");
INSERT INTO kbh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y chora ents̈anga mochanjinÿe, chë Bëngbe Bëtsá Ents̈á tbojanbemá jants̈etëshiñe echántsaboye, puerte obenánaca y corente buashinÿinÿaniñe. ");
INSERT INTO kbh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Chë soyënga jochnënguama chaojobojats̈é ora, añemo s̈mochjents̈etaye y bests̈as̈e játsbanase s̈mochjarrepára, er chora echántsemna chë ts̈ëngaftangbe atsebacayana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mënts̈ánaca Jesús tojanë́yana jabuátambama: “S̈mochjinÿe canÿe higo betiye o ndaye inÿe betíynaca. ");
INSERT INTO kbh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tojtsaisë́jotsanama s̈mojinÿe ora, jtsetats̈ëmbuana chë ts̈abe tempo ya yojtsaisobecuama. ");
INSERT INTO kbh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Cachcá, chë soyënga yojtsëchnëjuanama chas̈mojinÿe ora, s̈mochtsetáts̈ëmbo chë Bëngbe Bëtsabe amë́ndayana ya yojtsobecuama. ");
INSERT INTO kbh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ndegombre cbë́yana, lempe chca echanjochnëngo, morsca ents̈anga cabá ndóbana ora. ");
INSERT INTO kbh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Celoca y quem luare echanjopochóca, pero ats̈be palabra ndocna te queochaisopochóca. ");
INSERT INTO kbh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Cuedado s̈mochtsebomna y ndoñe s̈matjaleséncia ts̈ëngaftangbe ainana bacna juabnë́ngaca chaotsemnama, jenomándama ntsobencá mocá enobuena causa, tmoye causa y nÿe quem luarents̈a soyëngama enócochinÿena causa; y ts̈ëngaftanga prontánënga s̈mochtsemna, nÿe ndeolpe chë te chaojobuache ora; y ts̈ëngaftanga ndëprontánënga ndoñe chas̈mondë́tsemna, mo ts̈ëngaftangbiama canÿe uachmaniñe cuaftsemncá. Er nÿetsca quem luarents̈a ents̈angbiama chca echántsemna. ");
INSERT INTO kbh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cuedado s̈mochtsebomna y yejuana s̈mochtsantjes̈na; nÿe ntseco órnaca Bëngbe Bëtsáftaca s̈mochtsencuéntaye, chca, chë echanjopása soyëngama jótsbocama chas̈mobenama, y chë Bëngbe Bëtsá Ents̈á tbojanbemabe delante jashjanguama ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús, bnëté Bëngbe Bëtsabe bëts yebnents̈e yojánabuatambaye, y ibetna, Olivos uabaina tjashoye yojánaye joquédama. ");
INSERT INTO kbh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y nÿetsca ents̈anga cabá cachëse Bëngbe Bëtsabe bëts yebnoye imojánajna Jesús joyeunayama. ");
INSERT INTO kbh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya yojétsobeco Bashco fiesta, chë levadúraca ndëpormana tandës̈e saye fiesta, chë Bëngbe Bëtsá Egiptocana judiëngbe bëts taitanga tojánatsebacama jtenójuaboyama. ");
INSERT INTO kbh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chë bachnangbe amë́ndayënga y ley abuátambayënga imojtsenguaye nts̈amo jamëse Jesús jóbana, pero ents̈angbiama imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chora Satanás, Judas chë Iscariote ca uabobuatmabe ainaniñe bacna juabnënga tojanjajó. Chánaca yojamna chë bnë́tsana uta uatsjendayënguents̈á; ");
INSERT INTO kbh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","y tojána, chë bachnangbe amë́ndayënga y Bëngbe Bëtsabe bëts yebnoca soldadëngbe amëndayë́ngaftaca jencuéntama, nts̈amo Jesús chëngbe cucuats̈iñe jayents̈báshejuanama. ");
INSERT INTO kbh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","As chënga imojóyejuaye, y Judas tmojans̈buachená crocénana chama jtats̈etayana. ");
INSERT INTO kbh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Y Júdasna aíñe ca tojánayana; y cach orscana cha yojtsenguaye nts̈amo jamana y ndëmua ora Jesús chë́ngbioye jayents̈báshejuanama, ndocna ents̈anga ora. ");
INSERT INTO kbh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chë Bashco fiesta ora tojanóshjango, chë levadúraca ndëpormana tandës̈e sayté; chë te yojamna, Bëngbe Bëtsá jëtschuayamna canÿe oveshá jóbana chora jasama. ");
INSERT INTO kbh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","As Jesús, Pedro y Juánbioye tojanë́yana: —Motsata y saná s̈ochjaprónta Bashco fiestama bënga mochjasama ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chora chata tbojantjá: —¿Ndë́moca cojtsebos̈e chë saná fchjapróntama ca? ");
INSERT INTO kbh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y Jesús tojanë́jua: —Jerusalenents̈e chas̈ojámashëngo ora, canÿe bacó cmochanjóbiats̈e, matbajiñe búyeshe echantsabuyambaye. Cha s̈ochjuasto, y s̈ochtsonÿaye ndëmuanÿe yebnents̈e cha yochjámashënguama; ");
INSERT INTO kbh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","y chents̈a nduiño s̈ochjauyana: “Chë Buatëmbayá s̈onjichamó aca jauyanama: ‘¿Ndayents̈e chë tsañe yojtsemna, Bashco saná ats̈e ats̈be uatsjéndayëngaftaca jasama ca?’ ” ");
INSERT INTO kbh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","As cha cmochanjínÿanÿiye canÿe bëts tsañe, tsbanana pisoca; ya lempe echántseprontana, y chents̈e, Bashco fiestama saná s̈ochjaprónta ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","As chë útata tbojána, y tbojáninÿena lempe nts̈amo Jesús tojanëyancá, y chents̈e chë Bashco saná tbojanprontata. ");
INSERT INTO kbh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jasama tojanobuache ora, Jesús mesë́shents̈e tojanótbema chabe uatsjéndayëngaftaca, chë cachënga más chcoye chabe ichmónënga ca uabáinënga. ");
INSERT INTO kbh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chora Jesús tojanë́yana: “Ts̈a sëndánbos̈e quem Bashco saná ts̈ëngaftangaftaca jasama, ats̈e cabá ndoñe chandësufrí ora. ");
INSERT INTO kbh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Muents̈ana ndoñe más quemënts̈a saná quicháisese, Bëngbe Bëtsabe amë́ndayana candóshjanguëntscuana. Chora echantsótats̈ëmbo nts̈amo quem fiesta ndegombre iuayancá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chorna canÿe coptema vínoyeca tojanaca, Bëngbe Bëtsábioye tbojtanchuá y mënts̈á tojánayana: “Quem coptema vínoye menáfs̈enga; y cbë́yana, ");
INSERT INTO kbh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","chë uvas betiyents̈a shajuanents̈ana obocniye ndoñe más quichaisofs̈iye, Bëngbe Bëtsabe amë́ndayana candóshjanguëntscuana ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chents̈ana, tandës̈e tojanca y Bëngbe Bëtsábioye tbojtanchuá; tojanjatá, tojanats̈atá y mënts̈á tojánayana: “Quem soye, ats̈be cuerpo entsemna, y chanjóbana ts̈ëngaftangbe ts̈abiama. Nts̈amo mora bënga montsamcá s̈mochtsama, ats̈biama jtenójuaboyama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tmojansents̈ana, chë coptémaca tojanma cachcá nts̈amo chë tandë́s̈eca tojanmcá y mënts̈á tojánayana: “Quem coptema vínoye entsemna chë Bëngbe Bëtsabe tsëm trato ents̈ángaftaca. Ats̈be buiñe echanjuábuashana, ts̈ëngaftanga chas̈motsetats̈ëmbuama nts̈amo Bëngbe Bëtsá ents̈anga tojanas̈ebuachenacá ndegombre yochjochnënguama. Chë buiñe ts̈ëngaftangbe ts̈abiama echanjuábuashana. ");
INSERT INTO kbh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero chë uayayëngbe cucuats̈iñe s̈ochjaboshjoná, mesë́shents̈e áts̈eftaca entsemna. ");
INSERT INTO kbh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ndegombre, chë Bëngbe Bëtsá Ents̈á tbojanbemáftaca echanjopása, nts̈amo Bëngbe Bëtsá chabiama tojanjuabocá. ¡Pero ts̈a lastema chë bochjáboshjonabiama ca!” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chorna chë uatsjéndayënga tmojanonts̈é entjanayana, chënguents̈á nda chë boshjuaná bétsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chë uatsjéndayënga imojtsenatsëtsnaye chënguents̈á nda chë más uamaná bétsemnana. ");
INSERT INTO kbh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","As Jesús tojanë́yana: “Chë ndoñe judië́ngbeñe, chë reyënga chëngbe ents̈ángbioye nÿe nts̈ámnaca jtsamë́ndayana, y chents̈a amë́ndayënga jtsamana, ents̈anga chë́ngbioye ts̈abe soye amënga ca chamotsëbobuátmama. ");
INSERT INTO kbh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero ts̈ëngaftangbeñe ndoñe chca chaondë́tsemna; chamna, ts̈ëngaftangbeñe chë más uamaná mo chë más basacá chaóbema, y chë mandayá mo chë oservenacá. ");
INSERT INTO kbh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Er, ¿ndase chë más uamaná yomna, chë mesë́shents̈e jasama tojotbemá o chë uajuats̈nayá? Ndegombre co chë mesë́shents̈e tojotbemá; pero ats̈na ts̈ëngaftangbeñe së́ntsemna mo chë oservenacá. ");
INSERT INTO kbh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ats̈be padecéniñe ts̈ëngaftanga sempre áts̈eftaca s̈mondétsemna. ");
INSERT INTO kbh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chíyeca, ats̈be bariëna, canÿe amë́ndayana cbochanjáts̈ataye, nts̈amo ats̈be taitá canÿe amë́ndayana s̈ojats̈tacá; ");
INSERT INTO kbh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","chca, ats̈be amë́ndayoca mesë́shents̈e áts̈eftaca s̈mochanjase y s̈mochanjofs̈iye, y uámana tbemaniñe mo reyëngcá s̈mochanjotbiama, chë Israeloca bnë́tsana uta pamíllanga ents̈angbiama chas̈muayanama ts̈abá o ndoñe ts̈abá chënga tmonjamama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús mënts̈ánaca tojánayana: —Simón, Simón; cochtsetáts̈ëmbo, Satanás obenana tonjotjañe ts̈ëngaftangaftaca nÿe nts̈ámnaca jamama, mo chë trigo matënga tcojtsashatiyeynacá; ");
INSERT INTO kbh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pero ats̈na Bëngbe Bëtsá sënjaimpadá, áts̈beñe os̈buáchiyana ndoñe chacmondëtsebuáshbenama. Y aca, nÿets os̈buáchiyana áts̈beñe chacojtsatsbomna ora, chë inÿe os̈buáchiyënga cochjújabuache áts̈beñe sempre chamotsos̈buáchema ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chora Simón tbojaniyana: —Bëngbe Utabná, ats̈e së́ntseprontana ácaftaca cárceloye jámnaca y jobanámnaca ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Y Jesús tbojaniyana: —Pedro, ats̈e cbëyana, cam ibeta bínÿanoye, ngallo cabá ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chents̈ana Jesús tojanatjá: —¿Chë ni shecnájaca, ni crocenánaca, ni shecochëtjonë́sheca tcbonjanichamó ora, nderado ndayá tcmojanabuáshebena ca? Y chënga tmojanjuá: —Tondaye ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chora tojanë́yana: —Mora ndoñe chca; shecnaja tobomná, chëja chauesocñe y crocenánama shecnëbénaca; y nda ndoñe espadëja tondbomna, chabe quëfsaíya chaotsatábuiye y canÿe espadëja chauatobuámiñe. ");
INSERT INTO kbh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Er cbë́yana, entseyta áts̈eftaca chaopasá, nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe ats̈biama iuayancá, mënts̈á: “Y chábioye tmonjáninÿe mo chë puerte bacna soye amënguents̈á canÿa cuaftsemncá ca.” Y lempe nts̈amo ats̈biama iuabemancá, mora ya echanjochnëngo ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","As chënga tmojaniyana: —Bëngbe Utabná, muents̈e uta espadëja entsemna ca. Y japochócamna cha tojánayana: —Nÿe nÿets̈á ponto ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chents̈ana, Jesús tojánbocna y nts̈amo yojanamancá Olivos tjashoye tojána, y chabe uatsjéndayënga tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Choca tmojánashjajna ora, Jesús tojanë́yana: “Bëngbe Bëtsá moimpadanga, bacna soye jamama ndoñe chacmondócochënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y chë uatsjéndayëngbents̈ana yojoluára, mo canÿe ndëts̈bé juts̈enë́ntscoca nÿets̈á, y yojoshëntsaments̈iye Bëngbe Bëtsáftaca jencuéntama. ");
INSERT INTO kbh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesús mënts̈á tojánayana: “Taita, aca tcojtsebos̈ëse, moma ats̈e ndoñe chas̈ondë́tsemna chca jasúfriana. Pero nts̈amo ats̈e stsebos̈cá ndoñe chaondë́tsemna, sinó nts̈amo aca cojtsebos̈cá ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chca orna celocana canÿe ángel tbojánebëbocna, añemo chaotsebomnama juajabuáchama. ");
INSERT INTO kbh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús ts̈a ngméniñe yojtsemna, y Bëngbe Bëtsáftaca más ibojtsencuéntaye. Y chabe bosese yojtsemna mo fshantsiñe buiñe cuaftsebuastëtjuancá. ");
INSERT INTO kbh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bëngbe Bëtsáftaca jencuéntama tojanpochocá ora, tojtantsbaná y chabe uatsjéndayënga imojtsemnoye tojána; y chënga imnétsomañe, ts̈a ngménaca imojtsemna causa. ");
INSERT INTO kbh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chora tojanë́yana: “¿Ndáyeca s̈motsomañe? Motsbananga y Bëngbe Bëtsá s̈mochtseimpadana, bacna soye jamama ndoñe chacmondócochënguama ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús cabá yojtsóyebuambnantscuana, ba ents̈anga chents̈e tmojánashjajna. Chë Judas ca uabainá, canÿa chë bnë́tsana uta uatsjendayënguents̈á, chë ents̈angbe natsana yojtsaye. Cha yojobeconá Jesús juamóchama; ");
INSERT INTO kbh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","pero Jesús tbojaniyana: “Judas, ¿canÿe juamochëse chë Bëngbe Bëtsá Ents̈á tbojanbemá uayayëngbe cucuats̈iñe cochjaboshjona ca?” ");
INSERT INTO kbh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chë Jesúseftaca imojtsemnënga tmojáninÿe nts̈amo chora yochjanopásama; as tmojaniyana: —Bëngbe Utabná, ¿espadë́jaca fs̈cotsatsejaye ca? ");
INSERT INTO kbh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y canÿa chënguents̈á, chë bachnangbe más uámana amëndayabe bochichnayábioye cats̈bioica matscuas̈e tbojtsantëts̈e, y tbojtsanë́stjango. ");
INSERT INTO kbh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chora Jesús tojanë́yana: —Cachcá monÿá; nÿe nÿets̈á ponto ca. Y chë bochichnayábioye chë matscuas̈e tbojánbojajo y tbojanshná. ");
INSERT INTO kbh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Chents̈ana, chë bachnangbe amë́ndayënga, chë Bëngbe Bëtsabe bëts yebnents̈a soldadëngbe amë́ndayënga y chë judië́ngbeñe bëtsëjemëngcá amë́ndayënga, chë cha juanatsama tmojánabënga, Jesús tojanë́yana: “¿Ndáyeca espadë́jangaca y ngarotbéngaca s̈mojabo ats̈e jishachama, mo ats̈e canÿe bacá uamana ents̈á cuaftsemncá ca? ");
INSERT INTO kbh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ats̈e cada te ts̈ëngaftangaftaca sënjamna Bëngbe Bëtsabe bëts yebnents̈e, y ni ches̈mátanbojajo. Pero ora tocjobuache ts̈ëngaftanga chca chas̈momama, y Satanás nts̈amo yojtsebos̈cá ts̈ëngaftangbeñe echantsemándaye ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Chents̈ana Jesús tmojánishache, y chë bachnangbe más uámana amëndayabe yebnoye tmojanánatse. Y Pedro bënocana ibojtsë́stona. ");
INSERT INTO kbh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Choca, chashja tsëntsaca, canÿe íñeshe tmojanangbotjó y ents̈anga chë shë́conana imojtsetbiámana; y Pédrënaca chents̈e chë́ngaftaca yojótbema. ");
INSERT INTO kbh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chora, canÿe shembása chents̈a oservená, Pédrëbioye tbojáninÿe chë iñe juachaca yojtsetbemana; tbojanonÿinÿé y tojánayana: —Muánaca cháftaca endánmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Pedro ndoñe ca tojánayana, y chë shembásabioye mënts̈á tbojaniyana: —Sobrená, ats̈e cha ndoñe quetsatabuatma ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ndoñe yapa bën y inÿa chábioye tbojátaninÿe y tbojaniyana: —Acnaca chë uatsjendayënguents̈á condmëna ca. Pero Pedro tbojanjuá: —Bacó, ats̈e ndoñe quetsátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chents̈a benë́ntscosna, inÿa más yojátayana: —Ndegombre, muánaca cháftaca enjánana; muánaca Galileocá entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Y Pedro tojánayana: —Bacó, ndayama cojtsichámuama ndoñe quetsátstats̈ëmbo ca. Cachora, y Pedro cabá yojtsóyebuambnantscuana, canÿe ngallo yojacánta. ");
INSERT INTO kbh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chora Bëngbe Utabná yojobuértana y Pédrëbioye tbojanonÿinÿé; y Pedro chora yojenójuaboye nts̈amo Bëngbe Utabná tbojaniyanama: “Cam ibeta bínÿanoye, ngallo cabá ndëcánta ora, aca unga soye cochanjayana ndoñe s̈conduabuatma ca.” ");
INSERT INTO kbh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","As Pedro shjoye tojánbocna, y corente ngménaca yojtsenóbos̈achna. ");
INSERT INTO kbh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chë Jesús imojtsebojanÿá ents̈anga cha imojtsáboyejuana y imojtsejants̈etaye; ");
INSERT INTO kbh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","y jtsabuchëntsacjuase, imojtsetjanaye: “¡Momalisiá, nda tcmënjajants̈etá ca!” ");
INSERT INTO kbh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y imojtsóyenguaye, nÿe mocá soyënga jtsatsëtsnayëse. ");
INSERT INTO kbh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tojanbinÿna ora, chë bëtsëjemëngcá amë́ndayënga, bachnangbe amë́ndayënga y ley abuátambayënga tmojánenefjna, y chë́ngbioye Jesús tmojanánatse. Choca tmojantjá: ");
INSERT INTO kbh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—S̈më́yana, ¿aca Bëngbe Bëtsabe Uámana Uabuayaná, chë Cristo comna ca? Y Jesús tojanë́jua: —Aíñe ca tcbojáuyanëse, ts̈ëngaftanga chama áts̈beñe ndoñe ques̈mochatos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y nderado tcbojátjasna, ts̈ëngaftanga ndoñe ques̈mochatojuá ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero cam orscana, chë Bëngbe Bëtsá Ents̈á tbojanbemá, chë Bëngbe Bëtsá nÿets obenana bomnabe cats̈bioica echántsatsbemana ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chora nÿetscanga tmojantjá: —¿As, aca chë Bëngbe Bëtsabe Uaquiñá comna ca? Y Jesús tojanë́jua: —Cach ts̈ëngaftanga chca s̈montsichamo; ats̈e cha sëndmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","As chora chënga tmojánayana: —¿Ndayama más ents̈anga s̈ochjátëjaboto Jesusbe contra chamuayanama? Er cach bënga chabe uayás̈ents̈ana chca tmonjouena ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nÿetsca mándayënga tmojëftsantsbaná, y Pilátbioye, chë Judeoca mandádbioye Jesús tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chents̈e tmojanonts̈é cha mal jaquédana, mënts̈á: —Bënga fsënjínÿena mua entsabuatambá bacna soyënga, quem luarents̈a ents̈angbe amë́ndayëngbioye ndëtsayaunanama. Cha entsichamo bënga ndoñe s̈ontsamna Césarbiama impuesto jtsatsquë́cjnayana ca; y entsichamo cha yomna chë Cristo, chë Bëngbe Bëtsabe Uámana Uabuayaná, mo canÿe reycá ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chora Pilato Jesúsbioye mënts̈á tbojantjá: —¿Aca chë judiëngbe Rey cojtsemna ca? Y Jesús tbojanjuá: —Aíñe, aca ndegombre yomncá tcjayana ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","As Pilato, chë bachnangbe amë́ndayënga y ents̈anga tojanë́yana: —Ats̈e ni mo canÿe soye chiyátinÿena, quem boyabása castiganá chaotsemnama jayanama ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero chënga más tmojanáyebuachena: —Nÿets Israel luarëjana entsabuatambá, Galilea ents̈angbe amë́ndayëngbe contra jtsemnama. Galilea luaroca chca tonjabojats̈é y mora moca Judeócnaca cachcá entsama ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","As Pilato, Galilea luarama yojouena ora, tojanatjá Jesús Galileocá tayojamnama. ");
INSERT INTO kbh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y Jesús aíñe Galileoca yojamnama cha tojántats̈ëmbona ora, Rey Heródesbioye cha tbojanichmó. Herodes inamna Galileoca mandado y chora Jerusalenents̈e cha yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes Jesúsbioye tbojáninÿe ora, corente tojanoyejuá. Chana tempscana inabos̈e Jesús jinÿama. Cha ba soyënga Jesusbiama tojanuena, y yojtsebos̈e jinÿama Jesús jamana canÿe bëts soye, Bëngbe Bëtsabe obenánaca. ");
INSERT INTO kbh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heródesna ba soyënga tbojantjá, pero cha ndocá tbonjanjuá. ");
INSERT INTO kbh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y chénts̈naca, chë bachnangbe amë́ndayënga y judiëngbe ley abuátambayënga imojtsemna, y Jesús corente mal imojtsequédaye. ");
INSERT INTO kbh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chora, Herodes y chabe soldadënga Jesúsbioye corente imojtsáboyënja, y jtsaboyejuanamna, botamana ents̈ayangá tmojanichëtjo, mo canÿe reycá; chents̈ana cachiñe Pilátbioye tmojesanichmó. ");
INSERT INTO kbh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cach te Herodes y Pilato tbojtanenatsëtsaye; tempna chata ibojenáyata. ");
INSERT INTO kbh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Chents̈ana Pilato, chë bachnangbe amë́ndayënga, chë pueblents̈a amë́ndayënga y nÿetsca ents̈anga tojánachembo, ");
INSERT INTO kbh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","y mënts̈á tojanë́yana: —Ts̈ëngaftanga quem ents̈á áts̈bioye s̈mojuánatse, mo bacna soye ents̈ángbeñe abuatambayacá, mandadënga ndëtsayaunanama ca; ts̈ëngaftangbe delante lempe sënjatjá, ts̈ëngaftanga ba soyënga muabiama s̈monjayana, pero ats̈na ni mo canÿe soye chiyátinÿena, quem boyabása castiganá jtsemnama ibojtsemna ca jayanama. ");
INSERT INTO kbh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes cach ndoñe, chíyeca cachiñe bë́ngbioye cha tbojesichmó. Quem boyabása ni mo canÿe ndoñe tonjobuachjanguá jóbanama chabotsemnama. ");
INSERT INTO kbh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chcasna, jabuache chamotsecastigá y chents̈ana chanjë́tsboshjona ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yojamna canÿe utamená jëtsboshjonana, nts̈amo Bashco fiesta ora jamana imojanamancá. ");
INSERT INTO kbh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero chora ents̈anga cánÿiñe tmojanáyebuachena: —¡Jesús chaóbana! ¡Barrabás matsboshjona ca! ");
INSERT INTO kbh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás inautámena, mandadë́ngbioye ndëtsayaunanama chë bëts pueblents̈e ents̈anga tojánenautanama y ents̈á óbanaye causa. ");
INSERT INTO kbh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato cachiñe tojánayana Jesúsbioye jëtsboshjonama yojtsanbos̈e ca; ");
INSERT INTO kbh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","pero ents̈angna más tmojtë́tanayebuachena: —¡Motsecrucificá! ¡Motsecrucificá ca! ");
INSERT INTO kbh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ya unga soyama tojtë́tanayana: —¿Nts̈amo bacna soye mua tojobuachjanguá ca? Ni mo canÿe bacna soye chiyátinÿena, mua jóbanama chabotsemnama. Chcasna, chanjacastíga y chora chanjë́tsboshjona ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero chëngna más imojtsechembumbuana Jesús chamotsecrucificama. Cabana, chë bachnangbe amë́ndayënga y chë ents̈angbe jabuache chembumbuanánaca, Pilato tmojanëyënjaná Jesús chamóbama. ");
INSERT INTO kbh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","As Pilato tojanmandá nts̈amo chë ents̈anga imojtsotjanañcá chaotsemnama; ");
INSERT INTO kbh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","as chora Pilato, Barrabásbioye cachcá tbojtanboshjona, chë nda inautámena mandadë́ngbioye ndëtsayaunanama ents̈ángbioye tojánenautanama y ents̈á óbanaye causa. Y Jesusna ents̈angbe cucuats̈iñe tbojánboshjona, nts̈amo chënga tmojtsebos̈cá chamomama. ");
INSERT INTO kbh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","As jacrucifícama Jesús tmojanánatse. Chora jajocana inátaboye canÿe boyabása, Simón ca uabainá, Cirene luarocá; y cha Jesusbe cruz tmojancutsá, Jesusbe ústonoye chaotsambama. ");
INSERT INTO kbh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y banga chë pueblents̈a ents̈anga imojtsë́stona; y chë shembásenga imojtsëstonëngna imojtsayos̈achiye y ngménaca imojtsanioye, Jesús chca yojtsepásama. ");
INSERT INTO kbh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","As Jesús chë́ngbioye tojanobuértana y tojanë́yana: “Jerusalenents̈a shembásenga, ats̈biama ndoñe matos̈achena; cach ts̈ëngaftangbiama y ts̈ëngaftangbe básengbiama s̈mochjenóbos̈achna. ");
INSERT INTO kbh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Canÿe te echanjóshjango y chë te s̈mochántsichamo: ‘Ts̈a ts̈abá chë shembásenga s̈es̈ona ndbomnëngbiama, chë quem luaroye s̈es̈onga ndoñe tmonjëftsëshejajnëngbiama, y chë s̈es̈onga ndoñe tmonjëftsabachengbiama ca.’ ");
INSERT INTO kbh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chora ents̈anga jetsóitanama mochántsebos̈e y mochanjonts̈é ichámuana: ‘¡Tjashënga s̈motsëtebuantsá y batsjabenga s̈motsaitame ca!’ ");
INSERT INTO kbh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ats̈e, chë ndocna bacna soye amá, chíyeca puerte obená, chca s̈mojaborlase, ¿nts̈amo mochjama chë ndegombre bacna soye amë́ngaftaca, chíyeca ndobenënga? O mënts̈á, ¿chë nguëfshna betíyeca chca tmojtsamëse, nts̈amo chë tojtsebuashá betíyeca mochjama ca?” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesúseftaca cruciñe jóbanama, útata bëts bacna soyënga ochjajnayátnaca imojtsënachaye. ");
INSERT INTO kbh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chë “Obanabe Bests̈ashe ca” uabaina luaroye tmojánashjajna ora, Jesús tmojancrucificá y chë bëts bacna soyënga ochjajnayátnaca, canÿa chabe cats̈bioica y chë ínÿana chabe uañicuayoica. ");
INSERT INTO kbh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chora Jesús mënts̈á tojánayana: “Taita, mëngbe bacna soye motsaperdónaye, er nts̈amo montsamama chënga ndoñe quemátstats̈ëmbo ca.” Chë soldadënga Jesusbe ents̈ayamna, tsbanánoye tmojanë́ts̈ena, chënga jtenájatayama. ");
INSERT INTO kbh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ents̈anga chents̈e imojtsemnënga chca imojtsonÿaye, y chë pueblents̈a mandayë́ngnaca Jesús imojtsáboyejuana y mënts̈á imojtsenatsëtsnaye: “Inÿengna aíñe tojëftsatsebacá; mora cachá chauentsbocá, cha ndegombre Cristo, chë Bëngbe Bëtsabe Uámana Uabuayaná tomnëse ca.” ");
INSERT INTO kbh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadë́ngnaca Jesús imojtsáboyejuana; tmojanobeconá y untja vínoye imojtsefs̈ës̈naye, ");
INSERT INTO kbh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y mënts̈á imojtsatsaye: “¡Chë judiëngbe Rey tcomnësna, cach aca mentsbocá ca!” ");
INSERT INTO kbh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesusbe bests̈as̈e juatsboicna canÿe uabemana soye tmojananjo; chiñe mënts̈á yojtsanábemana: MUA CHË JUDIËNGBE REY ENDMËNA ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Canÿe bëts bacna soyënga ochjajnayá yojtsecrucificaná, Jesúsbioye mënts̈á tbojanóyenguango: —Chë Bëngbe Bëtsabe Uámana Uabuayaná tcomnësna, mentsbocá y bëndátnaca s̈matsebocá ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero chë inÿe bëts bacna soyënga ochjajnayana mënts̈á tbojanácacana: —¿Ni mo Bëngbe Bëtsá ndoñe condërrespetana? Bëndátnaca bontsamna chacá jóbanama. ");
INSERT INTO kbh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ndegombre bëndata muents̈e bontsemna bëts bacna soyënga ochjajnaye causa, y chíyeca chca jasúfriama bontsamna. Pero quem boyabása ni mo canÿe bacna soye ndoñe tonjobuachjanguá ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y chorna, quem bëts bacna soyënga ochjajnayá Jesúsbioye tbojaniyana: —Jesús, ats̈biama cochtenójuaboye aca reycá jabomándama chacojtabo ora ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y Jesús tbojanjuá: —Ndegombre cbëyana, mënté áts̈eftaca celoca, chë nÿetscanga oyejuayënga mondbetsemnoca, aca cochantsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nÿetsto orscana las tresë́ntscoñe nÿets quem luare yojtseibétata. ");
INSERT INTO kbh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Y shinÿe yojtsajbaná binÿnayana, y Bëngbe Bëtsabe bëts yebnents̈e yojújonÿana ents̈ë́jua tsëntsaca yojtsenájataye. Chëjua bënë́jua inauamna y chë tsatsëntsaca inaújonÿana. ");
INSERT INTO kbh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","As Jesús tojanáyebuachena: “Taita, ats̈be espíritu acbe cucuats̈iñe s̈coboshjona ca.” Y chca jayanama tojanpochocá ora, tojanóbana. ");
INSERT INTO kbh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chë romano soldadëngbe amëndayá chca tojáninÿe ora, Bëngbe Bëtsábioye tbojtanadorá, mënts̈á jayanëse: “Ndegombre, quem boyabása ainaniñe ts̈abe juabnënga bomná inamna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nÿetsca ents̈anga chë soye jinÿama tmojánabënga, chca tojanopasama tmojáninÿe ora, tmojanonts̈é jtangana enocochjants̈etaye, ngménama. ");
INSERT INTO kbh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero Jesusbe nÿetsca ubuátmënga y chë shembásenga Galileocana tmojanastëngna, chaboca tmojanoquedá chë soyënga onÿayiñe. ");
INSERT INTO kbh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Yojanmëna canÿe boyabása, José ca uabainá, canÿe Judeoca pueblocá, Arimatea ca uabaina; cha inamna canÿa chë pueblents̈a uámana amëndayënguents̈á y canÿe ts̈abe ents̈á y nÿetsca soyënguiñe ts̈abá amá. ");
INSERT INTO kbh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Chánaca yojanobátmana chë Bëngbe Bëtsabe amë́ndayana chaóshjanguama, y tondaye tbonjanogustá nts̈amo chë inÿe amë́ndayënga tmojanjuabó y Jesúseftaca tmojanmcá. ");
INSERT INTO kbh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Cha Pilátbioye tojána y Jesusbe cuerpo tbojanotjañe. ");
INSERT INTO kbh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José chë cruzocana Jesusbe cuerpo tbojtanë́stjango, canÿe lino ents̈ë́juaca tbojanandmaná y canÿe cuevëshiñe, peñës̈iñe pormániñe, tbojanjajó. Chents̈e cabá ndocná mondëjajo. ");
INSERT INTO kbh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yëfsana ochnayté bétsemnayecna, cach te yojanotocana saná japróntana chë yëfsana jasama; y chë ochnayté ya yojtsebínÿana. ");
INSERT INTO kbh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chë shembásenga, Galileocana Jesús tmojantjëmbambanga, tmojána y chë cuevëshe tmojáninÿe, y tmojanrrepará nts̈amo Jesusbe cuerpo tmojanjajoma. ");
INSERT INTO kbh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yebnoye tmojtaná orna, tmojanprontá botamana uanguëts̈e béjayënga y soyënga chë cuerpiñe janëtjuama. Chë ochnaytena chënga tmojanochná, nts̈amo Moisesbe leyiñe yojanmandancá. ");
INSERT INTO kbh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y tmengo, chë inÿe semana bojats̈éntena, cabá cachëse, Jesús tmojanatbontsá cuevëshoye chë shembásenga tmojána, y tmojanamba chë tmojanprontá botamana uanguëts̈e soyënga. ");
INSERT INTO kbh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pero choye tmojánashjajna orna, tmojáninÿena chë cuevëshoye amashjuanents̈a ndëts̈bé chents̈ana juanániñe, ");
INSERT INTO kbh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","y choye tmojánamashjna ora, Bëngbe Utabná Jesusbe cuerpo ndoñe tmonjáninÿena. ");
INSERT INTO kbh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chë shembásengna ndoñe imontsetáts̈ëmbo nts̈amo jajuaboyana chë soyama; chora, uta boyabásata, uabuashinÿinÿana ents̈ayá uichë́tjonata chents̈e tbojabántsaye. ");
INSERT INTO kbh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y chë shembásenga tmojanëuatjanama y fshantsoye imojtsatsejbénama, chata tbojanë́yana: “¿Ndáyeca obanë́ngbents̈e chë vida totsobomñá s̈mojtsenguá ca? ");
INSERT INTO kbh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Muents̈e cha ndocná quenátsmëna, er cha ya tontayena. Menójuabonga ndayá cha tcmojanë́yanama, cha cabá Galileoca enjamna ora. Cha tonjánayana: ");
INSERT INTO kbh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Chë Bëngbe Bëtsá Ents̈á tbojanbemá bontsemna bacna soye amëngbe cucuats̈iñe chamoboshjonama, chamocrucificama y unga tianoye cháuatayenama ca’ ” —chata tbojánayana. ");
INSERT INTO kbh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chora chë shembásenga Jesusbe palabrëngama imojtenójuaboye, ");
INSERT INTO kbh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","y chë cuevëshents̈ana tmojtaná ora, chë ts̈abe noticiënga chë bnë́tsana canÿe uatsjéndayënga y inÿe ents̈ángbioye tmojanacuntá. ");
INSERT INTO kbh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Chë uatsjéndayëngbioye chca cuentayëngna imojamna María Magdalena, Juana, y María, chë Santiagbe mamá, y chë inÿe shembásenga chë́ngaftaca imojamnënga. ");
INSERT INTO kbh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero chë uatsjéndayëngna mënts̈á chë shembásengbiama imojétsejuabnaye: “Chënga montsoyebuambná mo corente juabna ndbomnëngcá ca.” Y chca, chënga chë soyiñe ndoñe montsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero chents̈ana, Pedro tojëftsantsbaná y ochamanana chë Jesús tmojanjajó cuevëshoye tojána. Y choca yojtsemna ora, yojotsejbéna tsoye jontjes̈iyama, pero nÿe ena ents̈ëjuangá yojuinÿe, chë Jesús tmojanbochmëjuangá. As Pedro ojnananá yebnoye yojtá, chca tojanopasama. ");
INSERT INTO kbh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Cach te, uta uatsjéndayata Emaús puebloye ibojtsaye. Emaús yojamna Jerusalenocana bnë́tsana canÿe kilómetroca. ");
INSERT INTO kbh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chata ibojtsayencuéntaye lempe nts̈amo tojanopasama. ");
INSERT INTO kbh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y tojanopasá, ibojtsencuéntaye y ibojtsenatsëtsnayëntscuana, cach Jesús tojanobeconá y chátaftaca cánÿiñe yojtsaye; ");
INSERT INTO kbh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","masque imojtsonÿaye, ndoñe ibontsobena cha jótëmbana. ");
INSERT INTO kbh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús tojanë́yana: —¿Ndayama benachiñe s̈uabanencuéntaye ca? As chata ngménaca ibojotsaye, ");
INSERT INTO kbh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","y canÿa, Cleofás ca uabainá, tbojaniyana: —¿Nÿe aca cojtsemna, inÿe luarocana ashjangoná Jerusalenents̈e oyená, ndayá chents̈e quem diënga yopasánama ndëtats̈ëmbuá ca? ");
INSERT INTO kbh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chora cha tojanë́yana: —¿Ndaye soyënga ca? Y chata tbojaniyana: —Chë Jesús Nazaretocáftaca tonjopasá soyëngama. Cha enjamna canÿe Bëngbe Bëtsabe juabna oyebuambnayá, puerte obenana bomná ndayá jamama y jayanama, Bëngbe Bëtsabe delante y nÿetsca ents̈angbe delante. ");
INSERT INTO kbh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Y nts̈amo, chë bachnangbe amë́ndayënga y chents̈a mandadënga ínÿengbe cucuats̈iñe tmonjáboshjona, jóbanama ibojtsemna ca ents̈anga chamuayanama y chamocrucificama. ");
INSERT INTO kbh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bënga chabiama fsënjanobátmana, Césarbe cucuats̈ents̈ana Israeloca ents̈angbe atsebacayá chaotsemnama; pero morna ya unga te entsemna chca tonjopasá. ");
INSERT INTO kbh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Y mora ndayá, básefta shembásenga bëngbe enutënga ójnanana soyënga s̈onjáuyana. Chënga cabá cachëse chë Jesusbe cuerpo tmonjanjajó cuevëshoye tmonjá, ");
INSERT INTO kbh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","y chabe cuerpo ndoñe tmonjínÿena; as chora chënga bë́ngbioye tmontabo y montsabíchamo angelënga tmojë́ftsanÿe y chënga catmënjayana cha ainá yojtsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bë́ngbents̈ana baseftángnaca chents̈ana chë cuevëshoye tmonjá, y tmojínÿena nts̈amo chë shembásenga tmonjayancá, pero Jesús ndoñe tmonjë́ftsinÿe ca —chata ibojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","As Jesús chata tojanë́yana: —¡Ts̈a juabna ndbomnënga y ts̈a uenana jos̈buáchiyama, chë Bëngbe Bëtsabe juabna oyebuambnayënga tmojánayana soyëngama! ");
INSERT INTO kbh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mo ndoñe yonjamna chë Uámana Uabuayaná chë soyënga chaosufrima, y chents̈ana nÿetsca ents̈anga corente cha chamuatschuama ca? ");
INSERT INTO kbh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chents̈ana Jesús tojanonts̈é chata jábuayenana, lempe nts̈amo chabiama yojanoyebuambnacá chë Bëngbe Bëtsabe uabemana palabrënguiñe; yojonts̈é Moisesbe librë́s̈angañe y chë Bëngbe Bëtsabe juabna oyebuambnayëngbe librës̈angáñnaca. ");
INSERT INTO kbh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Chë ibojétsaye puebloye imojtsebeconá ora, Jesús tojanma mo más chcoye cuaftsacá. ");
INSERT INTO kbh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero chatna tmojanatarié chents̈e chaotsoquedáñama, mënts̈á jauyanëse: —Bëndátaftaca motsoquedañe; ya jetiñe entsemna y ya echanjaibétata ca. As Jesús chátaftaca tojtsanoquedañe. ");
INSERT INTO kbh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chents̈ana tojanopasá, juasama mesë́shents̈e imojtsetbiámana ora, Jesús chë tandës̈e tojanca, Bëngbe Bëtsábioye tbojtanchuá, chë tandës̈e tojanjatá, y chata tojanats̈atá. ");
INSERT INTO kbh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","As, chora chë uatsjéndayata ibojobenaye Jesús jótëmbana; pero chana nÿe ndeolpe yojuenatjëmba. ");
INSERT INTO kbh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chora chata ibojtsenatsëtsnaye: “Chë benachiñe Bëngbe Bëtsabe uabemana palabrëngama s̈ondabuayiyná ora, ndegombre bëngbe ainaniñe más bontsebos̈e cha más chas̈otsabuayiynama, ¿ndoñe chca ca?” ");
INSERT INTO kbh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","As, cachora tbojëftsantsbanata y Jerusalenoye tbojtanata; choca tmojáninÿena chë bnë́tsana canÿe uatsjéndayënga cánÿents̈e imojtsemna y chëngbe enutë́ngnaca; ");
INSERT INTO kbh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","y mënts̈á imojtsichamo: —¡Ndegombre Bëngbe Utabná tojtayena; Simónbioye tbojébëbocna ca! ");
INSERT INTO kbh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","As chata tbojanonts̈é jacúntana, nts̈amo benachiñe tbojanpasacá, y nts̈amo Jesúsbioye imojótëmba, chë tandës̈e tojanjatá ora. ");
INSERT INTO kbh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chë uatsjéndayënga chë soyëngama cabá imojtsencuéntantscuana, Jesús chëngbe tsëntsaca tojabántsaye y mënts̈á tojanë́yana: “Chë ats̈be ainaniñe ts̈abe ebionana ts̈ëngaftangaftaca chaotsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero chënga ts̈a auatjanánënga imojtsemna, y canÿe añemëse imojétsonÿaye ca imojtsejuabnaye. ");
INSERT INTO kbh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús tojanë́yana: “¿Ndáyeca auatjanánënga s̈mojtsemna? y ¿ndáyeca ts̈ëngaftangbe ainaniñe chca s̈mojtsejuabná ca? ");
INSERT INTO kbh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ats̈be cucuats̈ënga y ats̈be shecuats̈ënga minÿënga; s̈mobojajo y s̈mochanjinÿe. Cach ats̈e së́ntsemna. Canÿe añemësna, ni mënts̈ena ni betas̈ënga ntsebomnana; pero ts̈ëngaftanga s̈montsonÿá, ats̈na aíñe ca” —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chca yojtsichámëse, chabe cucuats̈ënga y chabe shecuats̈ënga tojaninÿanÿé. ");
INSERT INTO kbh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Y chënga cabá ndoñe montsanos̈buaché, chca noticiama corente imojtsóyejuama y ts̈a ojnanánënga imojtsemna causa; as Jesús tojanatjá: “¿Muents̈e ndayá jasama ques̈mëbomna ca?” ");
INSERT INTO kbh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","As canÿe tabena buana beonbiana tmojanoyé; ");
INSERT INTO kbh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús tojanocñe y chë́ngbents̈e tojanse. ");
INSERT INTO kbh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chents̈ana Jesús tojanë́yana: “Quem palabrënga entsemna nts̈amo cabá ts̈ëngaftangaftaca sënjamna ora tcbonjanëyancá: Entsemna, lempe chaopasá nts̈amo ats̈biama iuabemancá, Moisesbe leyënguiñe, chë Bëngbe Bëtsabe juabna oyebuambnayëngbe uabemana librë́s̈angañe y Salmos librë́s̈añnaca ca.” ");
INSERT INTO kbh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Y chora chë uatsjéndayënga, Jesúsbeyeca tmojanobená chë Bëngbe Bëtsabe uabemana palabrëngama josértana. ");
INSERT INTO kbh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chents̈ana Jesús tojanë́yana: “Nts̈amo ats̈biama iuabemancana yomna, chë Bëngbe Bëtsá Ents̈á tbojanbemá chaosufrí y unga tianoye chauatayena ca. ");
INSERT INTO kbh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y morna ats̈be uabaina jayanëse, áts̈beñe betsos̈buáchema, nÿets quem luarents̈e s̈mochjónts̈a ents̈anga ats̈biama jábuayenama, bacna soyënga amana chamuajbanama, as chca, Bëngbe Bëtsá chëngbe bacna soyëngama cháuaperdonama; chë soyënga Jerusalenents̈e chaobojats̈é. ");
INSERT INTO kbh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ts̈ëngaftanga ats̈biama soyënga s̈monjinÿe y s̈mondë́tats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ats̈be Taitabe s̈buachenaná, ts̈ëngaftangbiama chanjíchmua. Pero morna camuents̈e Jerusalenents̈e moquedanga, Bëngbe Bëtsabe obenana chas̈móyëngacñëntscuana ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chents̈ana, Jesús chabe uatsjéndayënga ínÿoye tojanënatse, Betania pueblo béconana. Y chabe buacuats̈ënga játsbanase, Bëngbe Bëtsá tbojanimpadá chë uatsjéndayënga ts̈abe bendicionënga chamóyëngacñama. ");
INSERT INTO kbh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chca yojtsamëntscuana, cha chë́ngbents̈ana tojanoluaré y tojanonts̈é celoye játsjuana. ");
INSERT INTO kbh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chë uatsjéndayëngna, Jesús tmojtanadorá chents̈ana, Jerusalenoye oyejuayënga tmojtaná; ");
INSERT INTO kbh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","y cada te, Bëngbe Bëtsabe bëts yebnoye imojánajna, Bëngbe Bëtsá jëtschuayama.");
INSERT INTO kbh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Quem luare ndobojáts̈a ora, Cristo, chë Bëngbe Bëtsabe Uámana Oyebuambnayana ya yojtsemna; chora cha, chë chca uabainá, Bëngbe Bëtsáftaca yojtsanmëna, y cachá Bëngbe Bëtsá inamna. ");
INSERT INTO kbh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ndegombre cha, chë tempscana Bëngbe Bëtsáftaca yojtsanmëna. ");
INSERT INTO kbh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cháftaca, Bëngbe Bëtsá lempe tojanma; cháftaca ndóñesna, lempe nts̈amo mora yomncá, Bëngbe Bëtsá tondaye matënjanma. ");
INSERT INTO kbh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cachábeñe nÿets vida inamna, y quem vídaca tojánabo quem luarents̈a ents̈angbe juabnënga jabuábinÿnayama. ");
INSERT INTO kbh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cha tonjánabo moye, chë ents̈angbe juabnënga ndoñe binÿniñe yonjamnoye, chiñe jabobínÿnayama. Cha sempre chca yobínÿna, y Satanás chë ents̈angbe juabnënga ndoñe binÿniñe chaondë́tsemnama amá, ndoñe yondobena chë binÿnayabe obenana jtsejuánana. ");
INSERT INTO kbh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inamna canÿe boyabása, Juan ca uabainá; y Bëngbe Bëtsá tbojanichmó, ");
INSERT INTO kbh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","binÿnayabiama chaóyebuambama; ents̈ángbeñe binÿnayabiama cháuayanama, chca, nts̈amo Juan chë binÿnayabiama tojayana soyë́ngaca, nÿetscanga Jesúsbeñe chamotsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ndoñe yonjamna chë binÿnayá. Cha inamna canÿe ichmoná, chë nda binÿnayá yomnabiama ents̈ángbeñe chauabáyanama. ");
INSERT INTO kbh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chë ndegombrá quem luaroye tonjánabo chë ents̈angbe juabnënga jabuábinÿnayama. ");
INSERT INTO kbh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chë Bëngbe Bëtsabe Uámana Oyebuambnayana quem luariñe yojtsanmëna; masque cháftaca Bëngbe Bëtsá quem luare tojanma, nda cha yojamnama muents̈a oyenënga ndoñe monjántats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cachabe luare ents̈ángbioye tonjánabo, y ents̈anga ndoñe tmonjánbos̈ena cha jofjana. ");
INSERT INTO kbh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nÿetscanga, ndëmuanÿenga cha tmojanë́buaja y chábeñe tmojtsos̈buáchenga, cha derecho tonjanats̈atá jtsobenama Bëngbe Bëtsabe básenga ca jtsabáinama. ");
INSERT INTO kbh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Quem os̈buáchiyëngna, chca jtsemnama ndoñe tmonjanobená ents̈angbe buiñents̈ana tmojanonÿnáyeca, o ndaye ents̈abe juabnents̈ana. Nÿe Bëngbe Bëtsábeyeca chca chabe básenga imojtsabaina. ");
INSERT INTO kbh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cha, chë Bëngbe Bëtsabe Uámana Oyebuambnayana, ents̈á tojanóbema, y quem luare bë́ngaftaca yojëftsiyena. Cha yomna chë Bëngbe Bëtsabe nÿe canÿe Uaquiñá; chíyeca bënga tifjáninÿe chabe bëts obenana y chabe ts̈abe juabna, chë Bëngbe Bëtsábents̈ana tojanóyëngacñana. Cha corente jtsababuánÿeshanëse s̈ojánanÿena y yojëftsiyena nts̈amo ndegombre inamncá. ");
INSERT INTO kbh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan mënts̈á chabiama yojanáyebuache: “Chabiama sënjanoyebuambná, chë ndabiama chora ats̈e sënjánayana, chë áts̈bents̈ana jabamana ats̈biama más uamaná endmëna, er ats̈e cabá ndonÿna orna, cha ya yojtsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cha ts̈a ts̈abe ainana bómnayeca, bënga nÿetscanga mallajta ts̈abe bendicionënga tmojóyëngacñe. ");
INSERT INTO kbh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisesbiajana tifjanóyëngacñe chë Bëngbe Bëtsá tojanmandá soyënga. Pero Jesucrístbeyeca, Bëngbe Bëtsá ts̈abe bendicionënga bëngbiama tojama y chë ndegombre soyënga bënga tmojëftsashjache. ");
INSERT INTO kbh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndocná, ndocna te Bëngbe Bëtsábioye tbonjinÿe. Chë nÿe canÿe Uaquiñá ibobomná, cach Bëngbe Bëtsá yomna; y cha, Bëngbe Bëtsá chë Taitáftaca cánÿiñe mo canÿacá yomna. Mua, chë Uaquiñá, bëngbiama tojama, Bëngbe Bëtsá juabuátmanama chaotsopodénama. ");
INSERT INTO kbh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Canÿe te, Jerusalenoca judiënga tmojanichamó básefta chëngbe bachnanga y levitënga, chë Bëngbe Bëtsabe bëts yebnoca trabájayënga, Juan yojtsemnoye, cha nda bétsemnama chamuatjayama. ");
INSERT INTO kbh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chocna, Juan chë́ngbeñe ndegombre tojanobuambá: —Ats̈e, chë Bëngbe Bëtsabe Uámana Uabuayaná ndoñe quetsátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","As chora, cachiñe tmojantjá: —As, ¿ndase cojtsemna? ¿Chë Bëngbe Bëtsabe juabna oyebuambnayá Elías ca? Y Juan tojanë́jua: —Ats̈e cha ndoñe quetsátsmëna ca. Chora chënga tmojantjá: —As, ¿chë Bëngbe Bëtsabe juabna jabóyebuambayama jabamá ca? Y Juan tojanë́jua: —Ndoñe ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chora chënga tmojaniyana: —Asna, ¿aca ndase cojtsemna? Bënga s̈ontsamna nda aca cojtsemnama jtsetats̈ëmbuana, as chë s̈onjadespachenga jacúntama. ¿Ndayá cojtsobena cach acbiama jayanama ca? ");
INSERT INTO kbh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y Juan mënts̈á tojanë́jua: —Ats̈e së́ntsemna chë ndabiama Bëngbe Bëtsabe juabna oyebuambnayá Isaías mënts̈á tojanábema: “Ents̈anga ndoyenoca canÿe abuayiynayá echántsemna, y ents̈anga mënts̈á echántsabuayiynaye: Bëngbe Utabná echanjabo ca. Mo nda canÿe benache tojtseprontacá, ts̈ëngaftángnaca cachcá, cha jabama ts̈abe juabnë́ngaca s̈mochtseprontana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chorna, báseftanga chë fariseungbe ichmónënguents̈ana, ");
INSERT INTO kbh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Juan tmojantjá: —Chë Bëngbe Bëtsabe Uámana Uabuayaná, Cristo ca uabainá, ndoñe tcontsemnësna, ni Elías, ni chë Bëngbe Bëtsabe juabna jabóyebuambayama jabamá ndóñesna, ¿ndáyeca ents̈anga cojtsëbayana ca? ");
INSERT INTO kbh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chora Juan tojanë́jua: —Ats̈na, béjayeca ents̈anga sëndëubáyana. Pero ts̈ëngaftangbeñe canÿa entsemna; cha ndoñe ques̈matábuatma; ");
INSERT INTO kbh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y cha ats̈be ústonoye echanjáshjango. Ats̈e merecido taitsatobuajoñe, ni mo jotsejbiyama, chabe shecochëtjonëshents̈a corriëja jajafjonama ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Chca tojanopasá, canÿe pueblo Betania ca uabáinents̈e, Jordán béjaye chenguana. Cach béjayiñe, Juan ents̈anga yojanëbáyana. ");
INSERT INTO kbh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yëfsana, Juan yojtsemnoye Jesús yojtsebéconaye, y chë cháftaca imojtsemna ents̈anga tojanë́yana: “S̈mochjinÿe. Chë nda Bëngbe Bëtsá tbojichmó y iytanana Oveshatemcá entsobiamná cha, entsashjajuana ca. Cha jóbanëse, quem luarents̈a ents̈anga bacna soyëngama perdonánënga mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ats̈e chabiama cbonjutsëtsná, mënts̈á sënjánayana ora: ‘Ats̈be ústonoye canÿa echanjáshjango. Cha ats̈biama más uamaná endmëna, er ats̈e cabá ndonÿna ora, cha ya yojtsemna ca.’ ");
INSERT INTO kbh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tempna, cach ats̈e ndoñe quetsjátantats̈ëmbo nda cha bétsemnana. Pero ats̈na ínÿenga béjayeca ubáyana sëndabó, Israeloca ents̈anga quem boyabása chamuábuatmanama ca” —Juan tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chents̈ana Juan mënts̈ánaca tojanobuambá: “Chabiama mënts̈á bominÿe sënjanjajó: chë Uámana Espíritu, mo canÿe palomatemcá, celocana tonjánastjango y quem boyabásabe juatsbuañe tonjanototoná. ");
INSERT INTO kbh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ats̈e cabá ndoñe quetsjátantats̈ëmbo nda cha bétsemnana, pero chë béjayeca jubáyama s̈onjanichmó cha, mënts̈á s̈onjaniyana: ‘Nda chacojinÿe, chë Uámana Espíritu jastjanguana y chabe juatsbuañe jototonana, chábeyeca ats̈e chanjíchmua chë Uámana Espíritu ents̈angbe ainaniñe cháuamashënguama ca.’ ");
INSERT INTO kbh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Y morna, ats̈e aíñe chca tijinÿe, y ndegombre ts̈ëngaftanga cbë́yana, cha chë Bëngbe Bëtsabe Uaquiñá entsemna ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yëfsana, Juan chabe uatsjéndayënguents̈ana útataftaca cachoca yojtésemna. ");
INSERT INTO kbh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús yojtsachnëjuanama, Juan tbojáninÿe ora, tojanë́yana: “S̈ochjinÿe. Mua entsemna nda Bëngbe Bëtsá tbojichmó y iytanana Oveshatemcá entsobiamná cha ca.” ");
INSERT INTO kbh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chora chë Juanbe uta uatsjéndayata, chca tbojanuena ora, Jesús tmojanasto. ");
INSERT INTO kbh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús tojesanontjes̈é y tojánanÿe chata imojétsëstonama. As, tojanatjá: —¿Ndayá s̈ojtsenguá ca? Y chata tbojaniyana: —¿Rabí, ndayents̈e icoyena ca? (Rabí endayana “Buatëmbayá ca”.) ");
INSERT INTO kbh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chora Jesús tojanë́jua: —Mabo y s̈ochjinÿe ca. As chata tbojána y tbojáninÿe ndayents̈e cha yojaniyenana. Y chents̈e cháftaca tojë́ftsanajëtana, ya jetiñe mo las cuatro ora yojtsemna causa. ");
INSERT INTO kbh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chë Jesusbiama oyebuambnayana Juánbioye tbojanóyeunata y Jesús tbojanasto útatents̈ana cánÿana Andrés ca yojanabaina; cha yojamna Simón Pédrëbe cats̈ata. ");
INSERT INTO kbh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés, cabá ndocna inÿe soye ndëma ora, tojána chabe cats̈ata Simón janguanguama. Y tbojáninÿena ora, Simónbioye tbojaniyana: “Chë Bëngbe Bëtsabe Uámana Uabuayaná, Cristo, fsënjínÿena ca.” ");
INSERT INTO kbh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chents̈ana Andrés, Simónbioye tbojanánatse Jesús yojtsemnoye. Jesús, Simónbioye tbojáninÿe ora, tbojaniyana: “Aca condmëna Simón, Jonasbe uaquiñá, pero Cefas ca cochantsabaina ca.” (Chcana endayana “Pedro o ndëts̈bé ca”.) ");
INSERT INTO kbh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yëfsana, Jesús tojanjuabó Galilea luaroye jama. Benachiñe Felípbioye tbojáninÿena y tbojaniyana: “S̈masto ca.” ");
INSERT INTO kbh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Chë boyabása Felipe, Betsaida pueblocá inamna. Andrés y Pédrëna cach pueblocata ibnamna. ");
INSERT INTO kbh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chents̈ana Felipe tojána Natanael janguanguama; y tbojaniyana: —Chë ndabiama leyënga librë́s̈angañe Moisés tojanábema cha fsënjínÿena ca. Cachabiama, Bëngbe Bëtsabe juabna oyebuambnayë́ngnaca tmojanábema. Cha Jesús entsemna, Josebe uaquiñá, chë Nazaretocá ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chora Natanael tbojaniyana: —¿Ndaye ts̈abe soye Nazaretocana nanjopódia jóbocnama ca? Y Felipe tbojanjuá: —Mabo y cochjinÿe ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael yojtsebéconama, Jesús tbojáninÿe ora tojánayana: —Moye canÿe ents̈á entsabó; cha ndegombre endomerecena Israelbents̈ana ents̈á jtsemnama. Cha ts̈abe ents̈á endmëna; ndocnábioye quebnatsíngña ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chora Natanael Jesúsbioye tbojantjá: —¿Nts̈amo ats̈e s̈cuabuatma ca? Y Jesús tbojanjuá: —Felipe cabá aca ndëchembo ora, ats̈e tcbonjinÿe, chë higo betiye tëchets̈oye condëtsomñe ora ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","As, Natanael tbojaniyana: —Buatëmbayá, ¡aca chë Bëngbe Bëtsabe Uaquiñá comna! ¡Aca, chë Israeloca ents̈angbe Rey ca! ");
INSERT INTO kbh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chora Jesús tbojanjuá: —¿Aca áts̈beñe cojtsos̈buaché, nÿe chë higo betiye tëchets̈oye tcbojinÿe ca tcbojauyanama? Ndegombre, chë soyama más bëts soyënga cochanjinÿe ca. ");
INSERT INTO kbh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chents̈ana Jesús tojanë́yana: —Ndegombre s̈cuayana: Ts̈ëngaftanga s̈mochanjinÿe celoca atëfjniñe, y Bëngbe Bëtsabe angelotémënga jtsetsjuajnana y jtsastjajuanana Bëngbe Bëtsá Ents̈á tbojanbemabe tatsëtsoca. ");
INSERT INTO kbh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chents̈ana unga tianoye, canÿe casamento inamna, canÿe pueblents̈e Caná ca uabáinents̈e, Galileoca. Chë oboyejuayoca Jesusbe mamá yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús y chabe uatsjéndayëngnaca chë casamentoca ófjanënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chë oboyejuayents̈e, vínoye yojtsopochóca y Jesusbe mamá tbojaniyana: —Ya tondaye vínoye quemátsbomna ca. ");
INSERT INTO kbh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","As, Jesús tbojanjuá: —Mama, ¿ndáyeca chca ats̈e s̈cojtsatsá? Ats̈be ora cabá ndoñe ntjoshjanguana ca. ");
INSERT INTO kbh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chents̈ana, chabe mamá, chents̈a oservénënga tojanë́yana: —Lempe s̈mochjama, nts̈amo cha chacmojauyancá ca. ");
INSERT INTO kbh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chocna, chnë́nguana ndëts̈bé matbaja inamna. Chca matbajënguents̈a béjayeca, judiënga imojanamana jtsacuénts̈abiana cabá ndëse ora, nts̈amo tempo ents̈anga imojanamancá, Bëngbe Bëtsabe delante ts̈ábenga jtsatsmënama. Cada matbajiñe, mo shachna o canÿsëfta bnëtsanájua béjaye yojanába. ");
INSERT INTO kbh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Chora Jesús chë oservénënga tojanamëndá: “Quem matbajënga béjayeca mobuajutetjé ca.” Y chënga, chora lempe tmojanbuajutetjé. ");
INSERT INTO kbh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Y Jesús tojanë́yana: “Morna, báseye mobuatsjo y chë fiesta otocanábioye mabuyamba ca.” Y chënga chca tmojanma. ");
INSERT INTO kbh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Chora, chë fiesta otocaná, chë béjaye Jesús vínoye tojanbemiye tojanftantiá, ndë́mocana yojóbocnama ntsetats̈ëmbcá. Pero chë oservénëngna aíñe imojtsetáts̈ëmbo ndë́mocana, er cachënga chë béjaye tmojanbuatsjo. As, chë fiesta otocanana, chë bobontse bouamnábioye tbojanchembo, ");
INSERT INTO kbh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y tbojaniyana: “Nÿetscanga monduamana natsana chë más uámana vínoye jushebëcana, y chë ófjanënga becá tmojatëmo ora, chë más bats̈á uámaniye. Pero acna, chë más uámana vínoye morscama tcojtsabofjajó ca.” ");
INSERT INTO kbh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nts̈amo Jesús tojanmcá Caná pueblents̈e, Galileoca, yojamna chabe natsana bëts soye Bëngbe Bëtsabe obenánaca. Y chca, chabe bëts obenana y uámanana cha tojaninÿanÿé; y as, chabe uatsjéndayënga chábeñe imojtsos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chca tojanopasá chents̈ana, Jesús canÿe pueblo, Capernaum ca uabáinoye tojtsanoñe. Chorna, chabe mamá, chabe cats̈átanga y chabe uatsjéndayënga cha tmojantjëmbambá, y choca baseftatescama tmojanoquedá. ");
INSERT INTO kbh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ya canÿe judiëngbe bëts fiesta, chë Bashco fiesta yojétsobeco, chë nts̈amo Bëngbe Bëtsá chëngbe bëts taitanga Egiptocana tojánatsebacama jtenójuaboyama. Chë fiestama Jesús Jerusalenoye tojána. ");
INSERT INTO kbh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalenoca, Bëngbe Bëtsabe bëts yebnents̈e, Jesús tojánanÿena uacnënga, oveshënga y paloma enënga, y ents̈ángbioye crocénana atrócayënga, chëngbe luarënguenache imojtsetbiámana. ");
INSERT INTO kbh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús chca tojánanÿe ora, biajënga tojanaca, tjanjanëja tojanobopormá, y Bëngbe Bëtsabe bëts yebnents̈ana nÿetscanga tojtanëbuacna, chëngbe oveshënga y uacnë́ngaca. Chents̈ana Jesús, Bëngbe Bëtsabe bëts yebnents̈ama yojanoservena crocénana atrocayëngbe crocénana tojtsanëjquë́sheshe, y chë mesëshangá tojtsanenásatajchquëca. ");
INSERT INTO kbh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chë paloma enëngna Jesús tojanë́yana: —¡Quem soyënga lempe muents̈ana matábocana! ¡Ndoñe matsbuamnana ni mátenana ats̈be Bëtsabe yebnents̈e, mo cánÿents̈e jiyama luarents̈e cuaftsemncá ca! ");
INSERT INTO kbh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Y as, chabe uatsjéndayënga tmojanenojuabó nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe iuayanama: “Bëngbe Bëtsabe yebna jtseboguianama juabna, nÿets áts̈beñe entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Chora, judiënga Jesús tmojantjá: —¿Ndaye bëts soye cochjama bënga chas̈cuinÿanÿema, aca ndaye deréchoca bë́ngaftaca chca cojtsobenama ca? ");
INSERT INTO kbh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","As Jesús tojanë́jua: —Quem Bëngbe Bëtsabe yebna menásatajchca, y ats̈e unga tese chtëtsbaná ca. ");
INSERT INTO kbh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chora chë judiënga tmojaniyana: —Canta bnë́tsana chnë́nguana uatiñe, quem Bëngbe Bëtsabe yebna tmojanjebo. ¿Y aca, nÿe unga tese lempe cochtë́tsjebo ca? ");
INSERT INTO kbh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero Bëngbe Bëtsabe yebna, ndayama chora cha chca tojánayana, cachabe cuerpo yojtsemna, ndoñe chë jebna soye. ");
INSERT INTO kbh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chama, Jesús obanënguents̈ana tojtanayena ora, chabe uatsjéndayënga tmojanenojuabó nts̈amo muents̈e cha tojanë́yanama. Chca ora, Bëngbe Bëtsabe uabemana palabrënguiñe y Jesús chora tojánayana palabrënguiñe más chënga imojtsos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalenoca chë Bashco fiestama yojtsemnëntscuana, ents̈anga tmojáninÿe Jesús jamana bëts soyënga Bëngbe Bëtsabe obenánaca. Chíyeca, ba ents̈anga chábeñe imojtsos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús chë́ngbeñe ndoñe yontsos̈buaché, cha nÿetscanga yojanëbuatma causa. ");
INSERT INTO kbh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y Jesús ndoñe bonjanájaboto chë ents̈angbe soyëngama chabotsebuayiynama, er cachá ents̈angbe ainaniñe nÿetsca juabnënga yojanábuatma. ");
INSERT INTO kbh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Inamna canÿe boyabása Nicodemo ca uabainá. Cha yojamna fariseunguents̈á y judiëngbe canÿe amëndayá. ");
INSERT INTO kbh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chana ibeta Jesúsbioye tojána y tbojaniyana: —Buatëmbayá, bënga fsë́ntsetats̈ëmbo aca canÿe buatëmbayá comnama, Bëngbe Bëtsabe ichmoná. Ndocná quenátobena jamana quem bëts soyënga, aca contsama soyënga, Bëngbe Bëtsá cháftaca ndoñe tontsemnëse. Chíyeca bënga chca fsë́ntsetats̈ëmbo ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chora Jesús tbojanjuá: —Ndegombre cbëyana, nda ndoñe cachiñe tontonÿná, cha ndoñe quenátobena Bëngbe Bëtsabe amë́ndayana jinÿama ca. ");
INSERT INTO kbh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Y Nicodemo tbojantjá: —¿Nts̈amo, canÿe ents̈á ya bëtsá tojtsemna ora, nantsobena cachiñe jtónÿnama ca? Ndegombre, cha ndoñe ntsobenana cachabe mamabe cuerpiñe jtamashënguana cachiñe jtónÿnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chora Jesús tbojanjuá: —Ndegombre cbëyana, béjayeca y chë Uámana Espíritbeyeca ntjonÿnacá, ndocná quenátobena Bëngbe Bëtsabe amë́ndayoye jamashënguama. ");
INSERT INTO kbh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nda bëtsë́tsabents̈ana tojonÿná cha, quem luarents̈a ents̈angcá jtsemnana; pero chë Uámana Espíritbeyeca tojonÿná chana, jtsemnana canÿa chë Uámana Espíritu ainaniñe bomná. ");
INSERT INTO kbh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ndoñe matenjnanana nts̈amo tcbonjauyanama: “Nÿetscanga entsamna cachiñe jtónÿnama”. ");
INSERT INTO kbh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chë binÿia ndëmuajana tojtsebos̈e jtsemnama, chëjana jtsanana. Masque ents̈anga, chë binÿiayama jtsuenanana, ndoñe ntsetats̈ëmbuana ndë́mocana yobama y ndë́moye yojtsoma. Cachcá, ts̈ëngaftanga ndoñe ques̈mátstats̈ëmbo nts̈amo ents̈anga chë Uámana Espíritbeyeca tmojtsónÿnama; pero ts̈ëngaftanga s̈montsetáts̈ëmbo aíñe chca yomnama ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chora Nicodemo tbojantjá: —¿Nts̈amo chca nántsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Y Jesús tbojanjuá: —Aca, canÿe Israeloca abuatambayá, ¿chë soyëngama ndoñe condë́tats̈ëmbo ca? ");
INSERT INTO kbh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ndegombre cbëyana, bëngna chë fststáts̈ëmbo soyëngama fsëntsoyebuambná, y chë tifjinÿe soyëngama ndegombre bétsemnama fsë́ntsichamo. Pero ts̈ëngaftangna, chë cbontsëtsëtsná soyënguiñe ndoñe ques̈matos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ats̈e, quem luarents̈a soyëngama sënjoyebuambá y ts̈ëngaftanga áts̈beñe ndoñe ches̈matos̈buaché. Y as, ¿nts̈amo áts̈beñe s̈mochtsos̈buáchiye, celoca soyëngama cbojtsëtsëtsnase? ");
INSERT INTO kbh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Ndocná, nÿe cachábeyeca Bëngbe Bëtsábioye tonjátsjua. Nÿe chë celocana tojabá aíñe, chë Bëngbe Bëtsá Ents̈á tbojanbemá. ");
INSERT INTO kbh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y chcase, nts̈amo Moisés ents̈anga ndoyenoca bronce mëts̈cuaye tsbanánoca tbojananguësëtjcá, s̈oquënga ts̈abá chamotsatsmënama; cachcá entsemna, Bëngbe Bëtsá Ents̈á tbojanbemá ents̈anga chamuatsbanama; ");
INSERT INTO kbh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chca, nÿetscanga chábeñe tmojtsos̈buáchenga, chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama ca” —Jesús Nicodémbioye tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mënts̈ánaca Jesús tojánayana: —Bëngbe Bëtsá quem luare ents̈ángbioye ts̈a yojánababuanÿeshanayeca, chë nÿe canÿe Uaquiñá ibobomná, bë́ngbioye tbojichmó, nÿetsca chábeñe os̈buáchiyënga ndoñe chamondóbanama, y aíñe chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama. ");
INSERT INTO kbh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Er Bëngbe Bëtsá chabe Uaquiñá quem luaroye ndoñe tbonjichmó quem luare ents̈angbiama jabáyanama nts̈amo tmojamama castigánënga chaotsamnama ca, sinó, ents̈anga chábeyeca atsebácanënga chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Nda Bëngbe Bëtsabe Uaquiñábeñe tojtsos̈buáchebiama, Bëngbe Bëtsá ndoñe queochátayana nts̈amo cha tojamama, castiganá chaotsemna ca. Pero chë Uaquiñábeñe ndoñe tontsos̈buáchebiama, mora Bëngbe Bëtsá ya tojayana, nts̈amo tojamama cha castiganá chaotsemna ca, chë Bëngbe Bëtsá nÿe canÿe Uaquiñá ibobomnábeñe ndoñe yontsos̈buaché causa. ");
INSERT INTO kbh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chca, chë ndoñe tmontsos̈buáchengbiamna cha ya tojayana, nts̈amo tmojamama castigánënga chamotsemna ca; er chë ents̈angbe juabnënga binÿnayá quem luaroye tojabo, pero ba ents̈anga tmojábos̈ena jtsomñana, chë ents̈angbiama bacna juabnë́ngaca chamotsebomnama amáftaca. Chënga sempre bacna soyënga jtsamana; chíyeca chënga jtsebos̈ana cháftaca jtsomñama. ");
INSERT INTO kbh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chë bacna soyënga tojtsamá ndoñe ntsebos̈ana, chë binÿnayá chabe bacna soyënga chabuinÿinÿema, ni chabe bacna soyëngama chabuácacanama. Chíyeca, chë bacna soyënga jtsamëse oyená, chë binÿnayábioye jtsáboyënjana, y chë binÿnayábioye ndoñe ntjabana. ");
INSERT INTO kbh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero nda sempre tojtsiyena nts̈amo ndegombre yomncá jtsamëse, chana aíñe chë binÿnayábioye jabana, chë binÿnayá chabiama chabuinÿinÿema, chë tojama soyëngna, nts̈amo Bëngbe Bëtsá tojtsebos̈cá tojamama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chca tojanopasá chents̈ana, Jesús chabe uatsjéndayëngaftaca básefta Judeoca pueblëngoye tojtsanoñe. Chiñe, baseftatescama chë uatsjéndayëngaftaca tojanoquedá, ents̈anga ubáyana. ");
INSERT INTO kbh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Cach tempo, Juanënaca ents̈anga yojanëbáyana Enonoca, Salim béconana, er choca bëtscá béjaye inabinÿna. Ba ents̈anga choye imojtsaye, y Juan chënga yojanëbáyana. ");
INSERT INTO kbh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chca tojanopasá, chë Heródesbe soldadënga Juan cabá ndutame ora. ");
INSERT INTO kbh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Chë tempo, básefta Juanbe ústonënga tmojanonts̈é inÿe judíoftaca enatsëtsnayana nts̈amo tempo judiënga chë jtsacuénts̈abiama imojanámanama. ");
INSERT INTO kbh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chora, chënga Juánbioye tmojánabo y tmojaniyana: —Buatëmbayá, chë Jordán chenguánoica ácaftaca enjamná, ndabiama ts̈a ts̈abá conjanoyebuambná, mora ents̈anga entsëbayana y nÿetscanga cha montsë́stona ca. ");
INSERT INTO kbh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","As Juan tojanë́yana: —Ndocná quenátobena tondaye ntsebomnana, Bëngbe Bëtsá ndoñe tbonjats̈etase. ");
INSERT INTO kbh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Cach ts̈ëngaftanga ts̈abá s̈monjanuena y s̈montsobena ndegombre yomnama jayanana, ats̈e ndoñe chë Bëngbe Bëtsabe Uámana Uabuayaná tsjanmëna ca sënjánayanama; sinó, Bëngbe Bëtsá ats̈e s̈ojanichmó chë Uabuayanabe natsana, chabiama ents̈anga jabábuayenama. ");
INSERT INTO kbh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Chë tobias̈e tojtsobouamá ora, chë bobontse chábioye jtsebomnana; y chabe amigna, chabiama jtsobátmanana y chë bobontse bouamnabe oyebuambnayana jtsuenanana; y chca tojtsuenana ora, ts̈a oyejuayá cha jtsemnana. Cachcá, nts̈amo chë Uabuayaná yojtsamama y yojtsóyebuambnama sëntsuenana ora, áts̈naca corente oyejuayá së́ntsemna. ");
INSERT INTO kbh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cha bontsemna más uamaná jtsemnana, pero ats̈e s̈ontsemna más nduamaná jtsemnana ca —Juan tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mënts̈ánaca Juan tojánayana: “Chë tsbanánocana tojabá, nÿetsca ents̈angbiama más uamaná endmëna. Chë quem luare oyená quem luare ents̈angcá jtsemnana y quem luarents̈a soyëngama jtsóyebuambnayana, pero chë celocana tojabana, nÿetsca ents̈angbiama más uamaná endmëna. ");
INSERT INTO kbh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Cachá nts̈amo tojinÿe y tojouencá entsoyebuambná, pero chë entsichamo soyënguiñe ndocná quenatos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nda nts̈amo cha tojtsóyebuambnañe tojtsos̈buaché y chca tojtsama, jtsinÿanÿnayana Bëngbe Bëtsá ndegombre soyënga inetsichámuama. ");
INSERT INTO kbh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chcasna, Bëngbe Bëtsabe ichmonana, jtsóyebuambnayana nts̈amo Bëngbe Bëtsá tojtsichamcá. Bëngbe Bëtsana chë ichmonábioye tbojichmó chë Uámana Espíritu, nÿets tempo corente chabotsájabuachanama, nts̈amo cach Bëngbe Bëtsá tojtsichamo y cachcá chaotsichámuama. ");
INSERT INTO kbh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chë Taitá Uaquiñábioye bondbobonshana, y chë Uaquiñábioye obenana tbojats̈etá nÿetsca soyënguiñe jtsemándayama. ");
INSERT INTO kbh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nda chë Uaquiñábeñe tojtsos̈buaché, chë nÿetsca tescama yomna ts̈abe vida echántsebomna; y nda chë Uaquiñábioye ndoñe tbontsas̈buaché, chana chë vida ndoñe queochátsbomna, y chë Bëngbe Bëtsabe uabouana castigo nÿetsca tescama chábeñe echántsemna ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chë fariseunga tmojanuena Jesús, Juanbiama más ústonënga yojtsabamnama, y más ents̈anga yojtsëbáyanama. ");
INSERT INTO kbh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero ndegombre, cach Jesús ndocnábioye bonÿanábayana, sinó chabe uatsjéndayënga. ");
INSERT INTO kbh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bëngbe Utabná Jesús, nts̈amo chë fariseunga tmojanuenama tojántats̈ëmbona ora, Judea luarocana tojë́ftsanbocna y Galileoye tojtaná. ");
INSERT INTO kbh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Choye jtamna ibojamna Samaria luarëjana jachnënguana. ");
INSERT INTO kbh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samariocna, canÿe pueblo Sicar ca uabáinoye Jesús tojánashjango. Chë pueblo yojamna, chë Jacob chabe uaquiñá Josébioye tbojëftsanlargá fshantse béconana. ");
INSERT INTO kbh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Choca yojamna cánÿents̈e atëfjóniñe, búyeshe jobuatsjuama, Jacobëbe atëfjóniñe ca uabáiniñe. Mo nÿetsto ora, chents̈e Jesús yojtsemna, aniñe uamënts̈nayá, chë atëfjóniñe batsjaca yojótbema. ");
INSERT INTO kbh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Chabe uatsjéndayëngna chë puebloye tmojána saná jobuámiñama. Chora, canÿe shembása Samariocá, chë atëfjónoye tojánashjango, búyeshe jauafcama; as Jesús tbojaniyana: —Búyeshtema s̈mabuats̈etá ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Y chë shembása tbojanjuá: —Aca canÿe judío condmëna y ats̈na canÿe samaritaná. ¿Nts̈amo cojtsobena ats̈e búyeshe juabuátjañama ca? (Cha chca tojánayana, er canjanopasana, judiëngna samaritanë́ngaftaca ndoñe monjanenatsëtsná.) ");
INSERT INTO kbh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chora Jesús tbojanjuá: —Aca mo cojtsetáts̈ëmbo nÿe nts̈amo Bëngbe Bëtsá aca jats̈etayama yojtsebos̈cá, y nda chë búyeshe cmojtsábuatjanañama, acna más cha catjuábuatjañe, y chana béjaye vida bomniye cmatjuabuáts̈etaye ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y chë shembása tbojaniyana: —Señor, tondaye quecátsbomna nÿe mo ndayecnaca búyeshe jabuatsjuama, y chë atëfjóniñe corente tboca endmëna; y as, ¿ndayents̈ana cochjobenaye béjaye vida bomniye ats̈e juabuats̈etayama? ");
INSERT INTO kbh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bëngbe tempsca bëts taitá Jacob, quem atëfjóniñe bëngbiama tojë́ftsanboshjona. Cachá, chabe básenga y chabe bayënga muents̈ana búyeshe tmojëftsanofs̈é; y ¿aca chabiama más bëtsá comna ca? —chë shembása yojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","As Jesús tbojanjuá: —Nÿetscanga chë quem búyeshents̈ana tmojofs̈enga, chënga cachiñe echantë́tëjuendaye. ");
INSERT INTO kbh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero chë chanjuabuáts̈etaye búyeshents̈ana tojofs̈é chana ndocna te cachiñe quebochë́tajuendaye. Cha chanjuabuáts̈etaye búyeshna, chábeñe echántsemna mo cánÿents̈e béjaytema obocaniñcá, chë nÿetsca tescama yomna ts̈abe vida jtsebomnama ca —cha tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chora chë shembása tbojaniyana: —Señor, chca búyeshe s̈mabuats̈etá, as ats̈e ndoñe cachiñe chas̈ondetsajuendama, ni búyeshe juafcama moye jtsaboyama ndoñe chas̈ondë́tsemnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","As Jesús tbojaniyana: —Motsa acbe boyá jachembuama y cochjésabo ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chora chë shembása tbojanjuá: —Boyá ndoñe quetsátsbomna ca. As Jesús tbojaniyana: —Ts̈abá tcjayana boyá ndoñe condbomna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Er, aca shachna boyanga conjánabamna, y chë mora contsebomnana, acbe boyá ndoñe quenátsmëna. Nts̈amo tconjayancá ndegombre entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chë shembása chca tojanuena ora, Jesúsbioye tbojaniyana: —Señor, mora ats̈e së́ntsetats̈ëmbo, aca canÿa Bëngbe Bëtsabe juabna oyebuambnayá comnama. ");
INSERT INTO kbh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bëngbe tempsca bëts taitanga quem tjoca Bëngbe Bëtsá monjánadorana; pero ts̈ëngaftanga, judiënga s̈mondbétsichamo, bënga Bëngbe Bëtsá jadóramna, Jerusalenoca chë luare canmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Chora Jesús tbojanjuá: —Shembása, s̈moyeuná; canÿe tempo echanjóshjango y chora ts̈ëngaftanga ndoñe quecmochátamna Bëngbe Bëtsá jadóramna, ni quem tjoye jabana, ni Jerusalenoye jana. ");
INSERT INTO kbh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ts̈ëngaftanga samaritanënga ndoñe ques̈matábuatma nda s̈metsadoránama; pero bënga aíñe fsënduábuatma, er chë atsebacayá judiënguents̈ana endabó. ");
INSERT INTO kbh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero ora entsoshjajuana, ya chë tempo tocjobuache, ndaye ora chë Bëngbe Bëtsá chë Taitá ndegombre atschuanayënga, chë Espíritbeyeca y ndegombre juabnë́ngaca chábioye mochántsadorana. Er chë Taitá entsebos̈e chë chábioye adórayënga chca chamotsamama. ");
INSERT INTO kbh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bëngbe Bëtsá, Espíritu endmëna; y chë chábioye adórayënga entsamna, chë Uámana Espíritbeyeca y ndegombre juabnë́ngaca cha jtsadoránana ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chora chë shembása tbojaniyana: —Ats̈e sëndë́tats̈ëmbo, canmëna chë Bëngbe Bëtsabe Uámana Uabuayaná, chë Cristo jabana ca; y cha chaojáshjango orna, cha nÿetsca soyëngama cas̈ochjabuayená ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","As Jesús tbojaniyana: —Ats̈e, chë ácaftaca entsoyebuambná cha, cha entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chëntscuana, Jesusbe uatsjéndayënga tmojtanashjajna, y tmojtsanëuatjaná, Jesús canÿe shembásaftaca yojtsoyebuambná causa. Pero ndocná Jesús tbonjantjá: ¿Ndayá cháftaca cojtsebos̈e? o ¿Ndáyeca cháftaca cojtsoyebuambná ca? ");
INSERT INTO kbh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chorna, chë shembása chabe uafcanëja tojésanboshjona, y chë puebloye betsco tojtaná. Chocna, ents̈anga tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mabënga canÿe boyabása jinÿama ca. Cha ats̈e s̈onjauyana lempe nts̈amo tijamcá. ¿Chë boyabása, chë Cristo tanántsemna ca?” —cha yojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","As chë ents̈anga chë pueblocana tmojánbocana y Jesús yojtsemnoye tmojánashjajna. ");
INSERT INTO kbh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chca yojtsopasánëntscuana, chë uatsjéndayënga Jesúsbioye imojtseimpadana: —Buatëmbayá, bats̈atema mose ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero cha tojanë́yana: —Ats̈e canÿe soye jasama së́ntsebomna. Ts̈ëngaftanga chë soyama ndoñe ques̈mátstats̈ëmbo ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Chora chë uatsjéndayënga tmojanonts̈é entjanayana: —¿Nderado nda jasama chabiama tojiyëbo ca? ");
INSERT INTO kbh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y Jesús tojanë́yana: —Chë s̈onjichmó cha nts̈amo yojtsebos̈cá jamana, y chabe trabajo japochócana, chë soyënga mo sanacá ats̈biama entsemna. ");
INSERT INTO kbh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ts̈ëngaftanga s̈mondbétsichamo: “Cabá canta ishinÿe entsashbena jaja saná chaotsebínÿnama ca”; pero ats̈e cbë́yana: Minÿënga ts̈a ents̈anga moye montsabëbana; chënga montsemna mo jajañe saná játbanama tojtseprontancá. ");
INSERT INTO kbh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ts̈ëngaftanga s̈montsemna mo chë saná atbanayëngcá. Chëngna jajañe jtsetrabájayana, y chëngbe uacanánana jtsësháchiñana. Cachcá, ts̈ëngaftanga cmontsamna ats̈biama ents̈anga júbuajana, chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama. Chë jaja saná átbanaye ora, jenënga y chë atbanayënga cánÿiñe oyejuayënga jtsemnana. Cachcá, chë ents̈anga áts̈beñe chamojtsos̈buaché ora, nÿetscanga, chë ats̈biama obuájajanënga y chë ats̈biama trabájayëngnaca cánÿiñe oyejuayënga mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quem ents̈angbe ichámuana, canÿe ndegombre soye endmëna: “Chë jená canÿa jtsemnana, y atbanayana inÿa ca.” ");
INSERT INTO kbh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ats̈e ts̈ëngaftanga cbonjichamó canÿe soye játbanama, y ts̈ëngaftanga tondaye ches̈matsma chca chaotsebínÿnama. Inÿenga chiñe bëtscá tmonjëftsetrabája, y ts̈ëngaftangna, chëngbe trabajënguents̈ana s̈mojolograñe ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bëtscá ents̈anga, Samarioca pueblents̈ënga Jesúsbeñe imojtsanos̈buaché, nts̈amo chë shembása tojanë́yanama. Chë shembása tojanë́yana: “Lempe nts̈amo ats̈e tijamcá cha s̈onjauyana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","As chë samaritanënga, Jesús yojtsemnents̈e tmojánashjajna ora, tmojanimpadá chë́ngaftaca chaotsoquedáñama. Y as Jesús, uta te chents̈e tbojëftsanjétana. ");
INSERT INTO kbh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y más ents̈anga, cach nts̈amo Jesús yojtsanëtsëtsnacá tmonjanuena ora, chábeñe imojtsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Y chë shembása chë ents̈anga tmojaniyana: “Mora cocayé fsëntsos̈buaché, ndoñe nÿe nts̈amo aca s̈cojáuyanama, sinó cach bënga chábioye oído fsënjabuajóyeca; y mora fsë́ntsetats̈ëmbo ndegombre cha yojtsemna chë quem luare ents̈angbiama Atsebacayá ca.” ");
INSERT INTO kbh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Uta te chents̈ana, Jesús Samariocana tojáisanbocna y Galileoye tojataná. ");
INSERT INTO kbh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Cach Jesús mënts̈á tojánayana: “Canÿa Bëngbe Bëtsabe juabna oyebuambnayá, cachabe luarents̈e oyenënga ndoñe bëtsá ntjabemëngana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileoca oyenënga Jerusalenoye tmojána, y tmojáninÿe nÿetsca bëts soyënga nts̈amo Jesús Bashco fiesta ora choca tojanmcá. Chíyeca, Jesús Galileoye tojtanashjango ora, chënga ts̈abá tmojtanofja. ");
INSERT INTO kbh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galileocna, Jesús cachiñe Caná puebloye tojésanashjango, chë béjayeca vínoye cha tojánbements̈e. Choca yojtsemna canÿe mandadbe uajabuachaná, y chabe uaquiñana Capernaum puebloca s̈ocá yojtsejájona. ");
INSERT INTO kbh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús Judeocana Galileoye tojánashjanguama, chë uajabuachaná tojanuena ora, Jesúsbioye tojána y ibojtseimpadana chabe yebnoye cháuama, chabe uaquiñá chabuetseshnáñama, er ya jtsóbanama yojtsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","As Jesús tbojaniyana: —Ts̈ëngaftanga, Bëngbe Bëtsabe obenana jinÿanÿiyama bëts soyënga ats̈e jamama ndoñe s̈monjinÿëse, áts̈beñe ndocna te ntsos̈buáchiyana ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chora, chë mandadbe uajabuachaná Jesúsbioye tbojaniyana: —Taita, betsco mabo, ats̈be uaquiñá cabá ndóbana ora ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","As Jesús tbojaniyana: —Acbe yebnoye motsatá. Acbe uaquiñá ainá endëtsomñe ca. Chë boyabásana tojanos̈buaché nts̈amo Jesús tbojaniyancá y tojtaná. ");
INSERT INTO kbh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cha yojtsataye orna, chabe oservénënga tmojánbocana jajébenguama y tmojaniyana: —Acbe uaquiñá ts̈abá entsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","As cha tojanatjá: —¿Ntseco orscana tbënjatëcja ca? Y chënga tmojanjuá: —Tonjopasá yëfse, mos̈enana orscana chë calentora tbonjábosana ca. ");
INSERT INTO kbh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chora chë taitá tojanenojuabó, cachca ora Jesús tbojaniyana: “Acbe uaquiñá ainá endëtsomñe ca”. Y cha y nÿetscanga chabe yebnents̈e oyenënga Jesúsbeñe imojtsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nts̈amo Jesús chora, chë uajabuachanabe uaquiñabiama tojanmcá, Judeocana Galileoye yojtsataye orna, yojamna chabe utama chca bëts soye jamama, Bëngbe Bëtsabe obenana jinÿanÿiyama, Galilea luaroca. ");
INSERT INTO kbh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baseftayté chents̈ana, chë judiënga canÿe oboyejuaye te imojtsebomna ora, Jesús Jerusalenoye tojána. ");
INSERT INTO kbh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Choca, chë Oveshëngbe amashjuana ca uabáinents̈e yojamna canÿe binche uafjajónaye, ents̈angbe pormániñe. Chë béjayna judiëngbe biyañe Betzata ca inauabaina. Chë béjaye juachañe shachna amashjuana otsbojebniñe inamna. ");
INSERT INTO kbh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiñna ba s̈oquënga jtanënga, coshetënga y jama ndobenënga imojtsecjana; chë béjaye chamobonjoma imojtsobátmana. ");
INSERT INTO kbh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Nderado nderado, Bëngbe Bëtsábioca canÿe ángel yojanamana jastjanguana chë béjaye jabónjuama. Chca ora, chë béjayoye natsana tojamashënguá, chabe s̈ocanama ts̈abá jtsatsmënana.) ");
INSERT INTO kbh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chë s̈oquënguiñe canÿe boyabása inamna, unga bnë́tsana y posufta uatama jama ndobená. ");
INSERT INTO kbh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús chë jajonábioye tbojáninÿe ora y ba uatama chca yojamnama tojántats̈ëmbona ora, tbojantjá: —¿Quecojtsebos̈e ts̈abá jtsatsmënama ca? ");
INSERT INTO kbh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y chë s̈ocá tbojanjuá: —Taita, ndocná quetsátsbomna nda chas̈uájabuache béjayoye jamashënguama, chë béjaye tojtsobonjná ora. Y ats̈e béjayoye jamashënguama stsebos̈e ora, inÿa ats̈be natsana jtsamashënguana ca. ");
INSERT INTO kbh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y Jesús tbojaniyana: —Matëtsbaná, acbe tjuashe mesocñe y matonts̈é jóyenana ca. ");
INSERT INTO kbh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Cach ora chë boyabása ts̈abá yojtsatsmëna, chabe tjuashe tojésanocñe y tojanonts̈é jtsanana. Chca tojanopasá ora, chë ochnayté inamna. ");
INSERT INTO kbh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chíyeca, chë tbojanshnábioye chë judiënga tmojaniyana: —Mëntena ochnayté. Mënté ndoñe quenátopodena aca tjuashe jtsecutsnana ca. ");
INSERT INTO kbh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Y chë boyabása tojanë́yana: —Chë s̈onjashná cha mënts̈á s̈onjauyana: “Acbe tjuashe mesocñe y monts̈é jóyenana ca”. ");
INSERT INTO kbh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","As chënga tmojantjá: —¿Nda yojtsemna chë “acbe tjuashe mesocñe y monts̈é jóyenana ca” tcmojauyaná ca? ");
INSERT INTO kbh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero chë shnaná ndoñe yontsetáts̈ëmbo nda tbojanshnama. Chocna bëtscá ents̈anga imojtsemna; chcasna, Jesús chëngbe tsëntsajana tojanenatjëmba. ");
INSERT INTO kbh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chents̈ana, Jesús Bëngbe Bëtsabe bëts yebnents̈e chë boyabásabioye tbojáninÿena y tbojaniyana: —Mouena; mora aca ya ndoñe s̈ocá quecátsmëna; bacna soyënga ndoñe cachiñe cattsama. Aíñese, acbiama puerte mal echanjopása ca. ");
INSERT INTO kbh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chë boyabása tojtsanoñe y chë judiënga tojanë́yana: —Chë s̈onjashná cha Jesús entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chë causa, chë judiënga imojtsenguaye nts̈amo Jesús ndayánaca jabórlana, cha ochnayté chë soyënga tojanmama. ");
INSERT INTO kbh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús tojanë́yana: “Ats̈be Taitá nÿets tempo ts̈abe soyënga endbétsama; cachcá, áts̈naca ts̈abe soyënga së́ntsama ca.” ");
INSERT INTO kbh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesús tojanma nts̈amo ochnayté ndoñe yonjanapodencá, y Bëngbe Bëtsabiama tojánayana “Ats̈be Taitá ca”. Mënts̈á Jesús yojtsanobiamná cach Bëngbe Bëtsacá. Chama, chë judiënga más imojtsebos̈e Jesús jóbama. ");
INSERT INTO kbh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chents̈ana Jesús tojanë́yana: “Ndegombre s̈cuayana: Bëngbe Bëtsabe Uaquiñá, nÿe cachabe cuenta tondaye quenátobena jamana. Cha jtsonÿayana nts̈amo chabe Taitá tojtsamcá. Nts̈amo chë Taitá tojtsamcá, chë Uaquiñánaca jtsamana. ");
INSERT INTO kbh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Er Bëngbe Taitá chabe Uaquiñábioye bondbobonshana, y lempe nts̈amo cha tojtsamcá chábioye bondinÿinÿná; y más bëts soyënga bochanjinÿinÿiye, chë soyëngama ts̈ëngaftanga chas̈menjnanama. ");
INSERT INTO kbh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chë Taitá endama obanënga chámuatayenama y ts̈abe vida chamotsebomnama; cachcá, chë Uaquiñá entsama ts̈abe vida chamotsebomnama, ndëmuanÿenga cha tojtsebos̈cá. ");
INSERT INTO kbh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chë Taitá ndocnabiama jatichámuana ts̈abá o ndoñe ts̈abá yontsama ca. Chabe Uaquiñábioye nÿets obenana tbonjats̈etá nÿetscangbiama jayanama ts̈abá o ndoñe ts̈abá tmontsamama. ");
INSERT INTO kbh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chca, chënga chamuinÿinÿé Bëngbe Bëtsabe Uaquiñá puerte uamaná yomnama, nts̈amo Bëngbe Bëtsá puerte uamaná yomnama nÿetscanga mondbetsinÿinÿnaycá. Nda chë Uaquiñábioye ndoñe más uamaná tbontsebiamná, cach ndoñe más uamana ntsebiamnayana chë Taitábioye, nda chë Uaquiñá tbojichmóbioye. ");
INSERT INTO kbh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ndegombre s̈cuayana: Nda nts̈amo ats̈e sëntsichamcá s̈ojoyeuná, y chë muents̈e s̈onjichmó chábeñe tojtsos̈buaché, chë nÿetsca tescama yomna ts̈abe vida jtsebomnana. Chabiama chë Uaquiñá ndoñe queochátayana castiganá chaotsemna ca. Chca, Bëngbe Bëtsabiama cha ya ndoñe más mo obanacá queochátsmëna, chábeñe ndos̈buáchiye causa; y ya ndoñe nÿetsca tescama castiganá queochátsmëna. Y aíñe, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ndegombre s̈cuayana: Chë jobuáchama te ya tocjobuache. Chë te, chë Bëngbe Bëtsabiama mo obanëngcá imomnënga mochanjouena Bëngbe Bëtsabe Uaquiñá jtsóyebuambnayana. Nda chca ts̈abá chas̈ojoyeuná cha, ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Er nts̈amo Bëngbe Taitá obenana endbomncá, cachá jamama ents̈anga vida chamotsebomnama, chabe Uaquiñábioynaca obenana tbojats̈etá ents̈anga vida chamotsebomnama jamama. ");
INSERT INTO kbh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chë Uaquiñá endmëna nda Bëngbe Bëtsá Ents̈á tbojánbema; chíyeca chë Taitá chábioye obenana tbojats̈etá nÿetscangbiama jayanama ts̈abá o ndoñe ts̈abá tmontsamama. ");
INSERT INTO kbh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Chama ndoñe matenjnanana. Er canÿe tempo echanjobuache, y chora chë Uaquiñá obanënga echántsachembuana; chënga mochanjouena y cach ora, chëngbe oyenocana mochanjésebocana. ");
INSERT INTO kbh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ts̈abe soyënga tmojëftsemënga, obanënguents̈ana mochántayena, chë nÿetsca tescama yomna ts̈abe vida jtsebomnama. Pero bacna soyënga tmojëftsemëngna obanënguents̈ana mochántayena nÿetsca tescama castigánënga jtsemnama ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mënts̈ánaca Jesús cachatbiama tojánayana: “Nÿe áts̈beyeca tondaye quetsátobena jamama. Chë Taitá s̈ontsemánda nts̈amo nÿetscangbiama jayanama ts̈abá o ndoñe ts̈abá tmontsamama. Nÿe chca ats̈e sëntsobena chë soye jamama. Ndoñe quetsátsbos̈e jamana nÿe nts̈amo cach ats̈e stsebos̈cá; pero sempre sëndbétsebos̈e jamama, nts̈amo Taitá, chë s̈onjichmó cha tojtsebos̈cá. Chíyeca ats̈e nÿetscangbiama së́ntsichamo ts̈abá o ndoñe ts̈abá tmontsamama; y nts̈amo nÿetscangbiama sëntsichamcá, ndegombre endmëna. ");
INSERT INTO kbh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nts̈amo cach ats̈biama tijayanama, ndegombre entsemna ca stsichámëse, nts̈amo stsichamcá, nÿetscangbiama tondaye ntsámanana. ");
INSERT INTO kbh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero inÿa entsemna. Cha endë́tats̈ëmbo y entsichamo nts̈amo ndegombre ats̈biama yomncá; y së́ntsetats̈ëmbo nts̈amo cha ats̈biama yojtsichamcá, nÿetscangbiama aíñe yojtsámanama. ");
INSERT INTO kbh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ts̈ëngaftanga ínÿenga s̈mojanichamó ats̈biama Juan jatjayama; y nts̈amo cha tcmojauyancá ndegombre endmëna. ");
INSERT INTO kbh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Masque chë soyënga cha tcmojáuyana, ndoñe ques̈natájaboto ndocna ents̈á ats̈biama chaotsichamo ‘cha aíñe chca endmëna ca’. Ats̈e quem soyënga së́ntsichamo ndayá nÿe ts̈ëngaftanga atsebácanënga chas̈motsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan enjamna mo canÿe uajuinÿanë́sha tojtsajuinÿana y tojtsabuashinÿinÿancá. Ts̈ëngaftanga chabe buashinÿinÿanana s̈monjinÿe, y s̈monjábos̈ena rato cháftaca oyejuayënga jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero chë ats̈e sënjama soyë́ngacna más entsinÿinÿena nts̈amo ats̈biama ndegombre yomncá, chë nts̈amo Juan ats̈biama tojánayanama. Ndayá ats̈be Taitá s̈ojabonÿé jamama, nts̈amo ats̈e sëntsamcá, entsinÿinÿná ndegombre chë Taitá s̈ojichmoma. ");
INSERT INTO kbh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ats̈be Taitá, chë s̈ojichmó chánaca entsichamo nts̈amo ats̈biama ndegombre yomncá, masque ndocna te chabe oyebuambnayana ches̈matuena, ni nts̈amo cha yomncá ches̈mátinÿe. ");
INSERT INTO kbh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero ts̈ëngaftangbe ainanoye chabe palabra ndoñe tonjómashëngo, cha tbojichmóbeñe ts̈ëngaftanga ndoñe ques̈matos̈buaché causa. ");
INSERT INTO kbh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ts̈ëngaftanga, Bëngbe Bëtsabe palabra ts̈a jtsatsjéndayana, er s̈mondobátmana, chca jtsamëse chë nÿetsca tescama yomna ts̈abe vida jónÿenama. Y Bëngbe Bëtsabe uabemana palabrënguiñe ats̈biama endayana nts̈amo ndegombre yomncá; ");
INSERT INTO kbh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero masque chca, ts̈ëngaftanga ndoñe ques̈mátsbos̈e ats̈e jtsë́stonana, y chca, ts̈abe vida jtsebomnama. ");
INSERT INTO kbh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ats̈e ndoñe quetsátsbos̈e ents̈anga yapa ts̈abá ats̈biama chamotsichámuama. ");
INSERT INTO kbh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Y inÿe soye, ats̈e puerte cbondëbuatma, y sëndë́tats̈ëmbo ts̈ëngaftanga Bëngbe Bëtsá ndoñe s̈mondbobonshánama. ");
INSERT INTO kbh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ats̈na ats̈be Taitabe cuenta sënjabo, y ts̈ëngaftanga ndoñe ques̈mátsbos̈e ats̈e jofjana. Pero inÿa, cachabe cuenta tojabábioye cocayé aíñe s̈matjofja. ");
INSERT INTO kbh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ts̈ëngaftanga corente jésebos̈ana, ínÿenga ts̈ëngaftangbiama ts̈abá chamotsichámuama, y ínÿengbiama ts̈abá jtsichámuama; pero ndoñe ntsebos̈ana chë nÿe canÿe Bëngbe Bëtsá ts̈ëngaftangbiama cachcá chaotsichámuama. Chca s̈mojtsamëse, ¿nts̈amo s̈mochtsobena Bëngbe Bëtsábeñe jtsos̈buáchiyana? ");
INSERT INTO kbh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ndoñe s̈mattsejuabnaye, ats̈be Taitabe delante ts̈ëngaftangbe contra ats̈e chjayana ca nts̈amo ts̈ëngaftanga s̈mojtsamama. Ts̈ëngaftanga ts̈a jtsobátmanana atsebácanënga jtsemnama, chë nts̈amo Moisesbe leyiñe endayancá s̈mojtsamama; pero ndegombre, nts̈amo cha tojayancá, cach ts̈ëngaftangbe contra entsemna. ");
INSERT INTO kbh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ts̈ëngaftanga, chë Moisés tojë́ftsanabema soyiñe s̈mojtsos̈buachese, áts̈beñnaca s̈mattsos̈buáchiye, er cha ats̈biama tojanábema. ");
INSERT INTO kbh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero chë tojanábema soyiñe ts̈ëngaftanga ndoñe s̈montsos̈buachesna, ¿nts̈amo s̈mochjobenaye chë ats̈e së́ntsichamo soyënguiñe jtsos̈buáchiyana ca?” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chë soyënga tojanopasá chents̈ana, Jesús chabe uatsjéndayëngaftaca tojána Galilea uafjajónaye chenguana. Chë uafjajónayna Tiberias cánaca inauabaina. ");
INSERT INTO kbh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ba ents̈anga imojtsë́stona, er chënga tmojáninÿe cha bëts soyënga jtsamana, s̈oquënga jtsashnayëse. ");
INSERT INTO kbh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","As Jesús tjoye tojántsjua, y choca chabe uatsjéndayëngaftaca tojanótbema. ");
INSERT INTO kbh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya judiëngbe canÿe fiesta, chë Bashco fiesta, yojétsobeco. ");
INSERT INTO kbh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús tojanótbema ora, tojanontjes̈é y tojánanÿe ba ents̈anga chábioye imojetsebéconaye. As Felípbioye tbojaniyana: —¿Ndayents̈e saná cuanjabuámiye nÿetsca quem ents̈anga chamosama ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús chca tbojaniyana, ana Felípbioye jinÿama nts̈amo cha tabuanjojuama; er cach Jesús ts̈abá inatáts̈ëmbo ndayá jamama. ");
INSERT INTO kbh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y Felipe tbojanjuá: —Ni mo uta patse denario crocenánaca nanjopódia tandës̈e jabuámiyama, nÿetsca ents̈anga nÿe mo bats̈atémnaca chamuétsesama ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Chorna, Jesusbe canÿe uatsjendayá, Andrés ca uabainá, Simón Pédrëbe cats̈ata, Jesúsbioye tbojaniyana: ");
INSERT INTO kbh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Muents̈e entsemna canÿe básetema y cha shachna cebada tandës̈e y uta beónata entsebomna. Pero, ¿ndayase nÿe nÿets̈atema chëfta ents̈angbiama ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","As Jesús tojánayana: —Ents̈anga më́yana chamotbiama ca. Becá shácuana chë luariñe inamna, y nÿetsca ents̈anga chiñe tmojanoshë́ntsjatbiama. Chë ents̈anguents̈e shachna uaranga boyabásenga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chora Jesús, chë tandës̈e chabe cucuats̈iñe tojanca, y Bëngbe Bëtsábioye chë tandës̈ama tbojtanchuá; y chabe uatsjéndayënga tojanëjatá, y chë uatsjéndayëngna nÿetsca ents̈anga imojtsetbiámanënga tmojanats̈atá. Cachcá Jesús chë beónaca tojanma, y nts̈amo ents̈anga imojanbos̈cá tmojanats̈atá. ");
INSERT INTO kbh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nÿetscanga tmojanse y tmojtanoshachá ora, Jesús chabe uatsjéndayënga tojanë́yana: —Chë ojamnëtémënga s̈mochtsatbananga, tondaye nÿe cachcá ntjëftsonÿayama ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","As chënga tmojanatbaná, y chë tmojanse shachna cebada tandës̈ents̈ana tojanójamëtemëngaca, bnë́tsana uta sbarë́cua tmojanajutjé. ");
INSERT INTO kbh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chë ents̈anga quem bëts soye Jesús jamama tmojáninÿe ora tmojánayana: “Ndegombre quem boyabása, chë quem luaroye jabama Bëngbe Bëtsabe juabna jabóyebuambayama cha entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús yojtsetáts̈ëmbo ents̈anga chëngbe rey jabemama imojetsebos̈ama. Chíyeca cach tjoye tojtsaisanoñe canÿa jtsomñama. ");
INSERT INTO kbh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tojanibétata ora, Jesusbe uatsjéndayënga chë uafjajónayoye tmojantsmá; ");
INSERT INTO kbh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","barquë́shañe tmojtanenojayé, y tmojanonts̈é jenashbuachénguana, chca, Capernaumoca jenbocnama. Ya ibeta yojtsemna, y Jesús cabá ndoñe chë́ngbioye ntashjanguana. ");
INSERT INTO kbh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chca imojtsenashbuachnëjuana orna, chë béjayiñe jabuache binÿia tojanóshjango y bëts olëshënga chë barquë́shoye yojtsójants̈etaye. ");
INSERT INTO kbh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Shachna o chnë́nguana kilómetro chënga tmojána ora, tmojáninÿe Jesús chë́ngbioye yojtsebéconaye, béjaye juatsbuacá yojtsaye. Chënga chca tmojáninÿe ora ts̈a tmojanocochauatjaná, ");
INSERT INTO kbh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","pero Jesús tojanë́yana: “Ats̈e sëndmëna; ndoñe matauatjëngana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chora chë uatsjéndayënga oyejuayënga imojtsebos̈e Jesús chë barquë́shoye jofjana, y ndoñe bënë́ntscose ya chë imojtsaye luaroye tmojánashjajna. ");
INSERT INTO kbh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yëfsana, nÿetsca ents̈anga, chë uafjajónaye chenguánoica tmojanoquedanga tmojáninÿe, chë inÿe yëfsana chë nÿe canÿe barquë́sha yojuamnë́shañe Jesusbe uatsjéndayënga tmojtsanoñama, y Jesús chë́ngaftaca ndoñe tonjánama. ");
INSERT INTO kbh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero chëntscuana, Tiberias pueblents̈ana inÿe barquëshangá tojanáshjajna canÿe luarents̈e, chë Bëngbe Utabná Jesús chabe Taitábioye tbojtanchuá chents̈ana, ents̈anga saná tmojanse luare béconana. ");
INSERT INTO kbh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asna, ni Jesús ni chabe uatsjéndayënga chents̈e ndoñe montsemnama chë ents̈anga tmojáninÿe ora, chë barquë́shangañe tmojtanenojayé y Capernaumoye tmojána Jesús jetsenguanguama. ");
INSERT INTO kbh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chë uafjajónaye chenguánoye tmojánashjajna ora, Jesús tmojáninÿena y mënts̈á tmojantjá: —¿Buatëmbayá, ntseco ora muents̈e tcojáshjango ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Y Jesús tojanë́yana: —Ndegombre cbë́yana, ts̈ëngaftanga ndoñe ats̈e ques̈matsnguá, chë bëts soyënga tijamama, sinó nÿe chë jtoshachaye nÿets̈á tandës̈e s̈mojasama. ");
INSERT INTO kbh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ndoñe matenángmenana chë nÿe ndoñe bën y jopochócana sanama; chë ndmopochócaye saná, chë nÿetsca tescama yomna ts̈abe vida jtsebomnama saná s̈mochjánguango. Chë saná, Bëngbe Bëtsá Ents̈á tbojanbemá cmochanjáts̈ataye, er Bëngbe Bëtsá chë Taitá tonjinÿanÿé, ts̈abe soyë́ngaca, cha chábioye tbojuábuayanama ca —tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chora chë ents̈anga tmojantjá: —¿Ndayá fchjama nts̈amo Bëngbe Bëtsá yojtsebos̈cá chaotsemnama ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chca tmojantjá ora, Jesús tojanë́yana: —Chë Taitá entsebos̈e ts̈ëngaftanga chabe ichmonábeñe chas̈motsos̈buáchema ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chora chënga tmojaniyana: —¿Ndaye ts̈abe soye cochjama acbe obenana bënga jinÿanÿiyama ca? Chë soye chaftsjinÿëse, ácbeñe fchantsos̈buáchiye. ¿Bëngbiama taicochjama ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bëngbe tempsca bëts taitanga ents̈anga ndoyenoca maná ca uabaina saná tmojanse. Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Cha celoca tandës̈e tonjanats̈atá chamosama ca” —chënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Chora Jesús tojanë́yana: —Ndegombre cbë́yana, Moisés chënga ndoñe chë celoca tandës̈e tonjanats̈atá; Bëngbe Bëtsá Bëngbe Taitá chë́ngbioye tojanats̈atá chë maná ca uabaina tandës̈e; y cha endmëna nda celocana chë ndocna te ndmopochócaye tandës̈e ndegombre cmondats̈atná. ");
INSERT INTO kbh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Er Bëngbe Bëtsábiocana tandës̈e entsemna chë celocana tojastjanguá; y cha quem luare ents̈angbiama entsama chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Chora chënga tmojanimpadá: —Taita, chë tandës̈e sempre s̈cochtsats̈atnaye ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y Jesús tojanë́jua: —Ats̈e sëndmëna ents̈anga chë nÿetsca tescama yomna ts̈abe vida jtsebomnama tandës̈e. Nda ats̈e chas̈ojtsë́stona, sempre oyejuayá echanjë́ftsemna y Bëngbe Bëtsabe soyënga nÿets tempo echanjesóbomñe, mo nda nÿets tempo saná totsobomñcá, y ndocna te tbontsishëntsancá. ");
INSERT INTO kbh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero nts̈amo ya tcbonjauyancá, ts̈ëngaftanga ats̈e s̈monjinÿe y cabá ndoñe áts̈beñe ques̈matos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nda ats̈be Taitá ats̈biama tbojabocacá, cha ats̈e s̈ochantsë́stona; y nda áts̈bioye s̈ojtsëstona, áts̈bents̈ana quichtëtábocna. ");
INSERT INTO kbh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Er ats̈na celocana sënjabo chë s̈ojichmó cha nts̈amo yojtsebos̈cá jamama, y ndoñe nÿe nts̈amo ats̈e stsebos̈cá. ");
INSERT INTO kbh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Y chë s̈ojichmó cha entsebos̈e, ni mo canÿa chë ats̈biama tojabacacá chents̈ana, ats̈e chailesenciá pochocaná chaotsemnama; y quem luare jopochócama tena, nÿetscanga ats̈biama tojábacacangbiama chámuatayenama ats̈e chaimama. ");
INSERT INTO kbh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Er ats̈be Taitá entsebos̈e, nda chabe Uaquiñábioye tbojinÿe y chábeñe tojtsos̈buaché, chë nÿetsca tescama yomna ts̈abe vida chaotsebomna, y quem luare jopochócama tena, cha cháuatayenama ats̈e chaimama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Ats̈e së́ntsemna chë celocana tojóshjango tandës̈e ca” Jesús tojanë́yana causa, chë judiënga tmojanonts̈é chabiama podesca ichámuana. ");
INSERT INTO kbh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chënga mënts̈á imojtsichamo: —¿Mua ndoñe Jesús yondmëna, chë Josebe uaquiñá? Chabe bëtsë́tsata bënga tmotsábuatmñe. ¿Nts̈amo cha mora yochjátichamo celocana tojástjango ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","As Jesús tojanë́yana: —Ats̈biama ndoñe podesca matichámuana. ");
INSERT INTO kbh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndocná quenátobena ats̈e juastana, chë Taitá, chë s̈ojichmó cha, ainaniñe chca chaotsebos̈ama ndoñe tbonjuajabuáchëse; y ats̈e chanjama cha cháuatayenama quem luare jopochócama te. ");
INSERT INTO kbh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chë tempsquënga Bëngbe Bëtsabe juabna oyebuambnayënga mënts̈á tmojanábema: “Cach Bëngbe Bëtsá nÿetscanga echanjabuatambá ca.” Chcasna, nda ats̈be Taitábioye tbojoyeuná, y nts̈amo chë Taitá tbojabuatëmbacá tojuatsjinÿe, cha ats̈e s̈ochanjuasto. ");
INSERT INTO kbh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ndocná ats̈be Taitá tbonjinÿe. Nÿe chë Bëngbe Bëtsábiocana tojabá aíñe. ");
INSERT INTO kbh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ndegombre s̈cuayana: Nda áts̈beñe tojtsos̈buaché, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ats̈e sëndmëna ents̈anga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama tandës̈e. ");
INSERT INTO kbh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Masque ts̈ëngaftangbe bëts taitanga, ents̈anga ndoyenoca chë maná ca uabaina saná tmojanse, pronto tmojanóbana. ");
INSERT INTO kbh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ats̈e sëntsoyebuambná ndayá chë celocana tojóshjango tandës̈ama. Nda chë tandës̈e tojase, ndoñe queochatóbana. ");
INSERT INTO kbh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ats̈e së́ntsemna ents̈anga chë nÿetsca tescama yomna ts̈abe vida jtsebomnama tandës̈e, chë celocana tojóshjanguës̈e. Nda quem tandës̈e tojase, nÿetsca tescama nÿe ainá echanjesomñe. Chë chanjáts̈ataye tandës̈na, cach ats̈be cuerpo entsemna. Chca chanjama quem luare ents̈anga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chora chë judiënga tmojanonts̈é enatsëtsnayana: —¿Nts̈amo cha yochjobenaye cachabe cuerpo jats̈atayana bënga jasama ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","As Jesús tojanë́yana: —Ndegombre s̈cuayana: Ts̈ëngaftanga Bëngbe Bëtsá Ents̈á tbojanbemabe cuerpo ndoñe s̈monjase y chabe buiñe ndoñe s̈monjofs̈ese, ndegombre ts̈abe vida ndoñe ques̈mochátsbomna. ");
INSERT INTO kbh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nda ats̈be cuerpo tojase y ats̈be buiñe tojofs̈é, chë nÿetsca tescama yomna ts̈abe vida echántsebomna, y quem luare jopochócama te ats̈e chanjama cha cháuatayenama. ");
INSERT INTO kbh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ats̈be cuerpo ndegombre saná endmëna, y ats̈be buiñe ndegombre ofs̈ës̈nayiye. ");
INSERT INTO kbh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nda ats̈be cuerpo tojase y ats̈be buiñe tojofs̈é, áts̈eftaca cánÿiñe mo canÿacá echántsemna, y áts̈naca cháftaca. ");
INSERT INTO kbh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ats̈be Taitá, chë s̈ojichmó cha, vida endbomna, y ats̈e chábeyeca vida së́ndbomna; cachcá, nda ats̈be cuerpo tojase, chana áts̈beyeca vida jtsebomnana. ");
INSERT INTO kbh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Chë ndaye soyama ats̈e sëntsoyebuambná, ats̈be cuerpo y ats̈be buiñe, entsemna chë celocana tojóshjango tandës̈e. Masque ts̈ëngaftangbe bëts taitanga chë maná ca uabaina tandës̈e tmojanse, pronto tmojanóbana; pero quem tandës̈e ndoñe cachcá quenátsmëna. Nda quem tandës̈e tojase, nÿe nÿets tempo vida echanjesóbomñe ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chë soyëngna Jesús tonjanabuatambá Capernaum pueblents̈e, chë judiëngbe enefjuana yebnents̈e. ");
INSERT INTO kbh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chca tmojanuena ora, banga Jesusbe ústonënga imojtsichamo: —Nts̈amo cha entsichamcá yapa totcá entsemna mo ndegombre cuaftsemncá joyeunayama. ¿Nda buanjóyeunaye ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús yojtsetáts̈ëmbo chënga ndoñe ts̈abá imontsichámuama; as, chënga tojanatjá: —¿Nts̈amo cbontsëtsëtsnacá ndoñe ts̈abá cmontsë́uenana ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Y chcasna, Bëngbe Bëtsá Ents̈á tbojanbemá, chë cha tempo inamna luaroye tojë́tstsjuama s̈mojinÿëse, ¿nts̈amo s̈mattsejuabnaye? ");
INSERT INTO kbh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bëngbe Bëtsabe Espíritu entsama ents̈anga chë ts̈abe vida chamotsebomnama. Chë cuerpo ndoñe uámana soye quenátsmëna; chë tcbonjáuyana soyënguiñe entsemna chë Uámana Espíritbe uajabuáchenana y chë ts̈abe vida. ");
INSERT INTO kbh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero masque chca entsemna, ts̈ëngaftangbents̈ana banga áts̈beñe ndoñe ques̈matos̈buaché ca —Jesús tojánayana. Er Bëngbe Bëtsabe soyëngama ents̈anga jábuayenama Jesús tojanbojats̈é orscana, cha inatáts̈ëmbo ndëmuanÿenga chábeñe ndoñe mochanjanos̈buáchiye, y nda chë uayayëngbe cucuats̈iñe yochjë́ftsayents̈bashejuanana. ");
INSERT INTO kbh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y Jesús yojtëtónts̈a oyebuambnayana: —Chíyeca, ats̈e ts̈ëngaftanga tcbonjáuyana: “nda ats̈e juastama ainaniñe chaotsebos̈ama ats̈be Taitá ndoñe tbonjuájabuache, cha ndoñe ques̈ochatasto ca”. ");
INSERT INTO kbh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chë causa, chents̈ana, ba chabe ústonënga cachcá tmojesanonÿá, y cháftaca ya ndoñe imontsajna. ");
INSERT INTO kbh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chora Jesús, chë bnë́tsana uta uatsjéndayënga tojanë́yana: —¿Y ts̈ëngaftángnaca, jtsoñama y ats̈e jéseboshjonama s̈mojtsebos̈e ca? ");
INSERT INTO kbh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chora Simón Pedro tbojanjuá: —Bëngbe Utabná Jesús, ¿chcasna ndábioye fchjanga ca? Nÿe aca s̈contsëtsëtsná chë nÿetsca tescama yomna ts̈abe vida jtsebomnama palabrënga. ");
INSERT INTO kbh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Acbeñe fsëntsos̈buaché, y mora fsë́ntsetats̈ëmbo aca chë Bëngbe Bëtsabe Uamaná comnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Chora Jesús tojanë́yana: —Ats̈e tcbonjabacacá, chë bnë́tsana útata; pero canÿa ts̈ëngaftanguents̈ana, mo Satanasbe canÿe trabajayacá entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariote, chë Simonbe uaquiñabiama chca Jesús tojánayana. Er chana masque canÿa chabe bnë́tsana uta uatsjendayënguents̈á inamna, Jesús uayayëngbe cucuats̈iñe yochjáftsayents̈bashejuana. ");
INSERT INTO kbh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chë soyënguents̈ana, Jesús Galilea luarëjana yojánana. Chë tempo, judiënga imojtsanjuabnaye nts̈amo jamëse cha jóbama. Chíyeca, Jesús ndoñe yontsebos̈e Judeoye jama. ");
INSERT INTO kbh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chora, judiëngbe canÿe bëts fiesta semana yojtsobeco. Quem fiestënguëntscuana, chë judiënga imojanamana tambënguiñe jtsiyenana. ");
INSERT INTO kbh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","As chora Jesusbe cats̈átanga tmojaniyana: —Muents̈e ndoñe catjoquéda; Judeoye motsa, choca condbomna ústonënga, nts̈amo contsamcá chócnaca chaminÿama. ");
INSERT INTO kbh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Er nda tojtsebos̈e chamotsábuatmama, chabe soyënga ndoñe iytëcana ntsamana. Aca bëts soyënga Bëngbe Bëtsabe obenánaca contsamësna, motsa y nÿetscangbe delante chca cochjama ca —chënga tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Er ni mo cach Jesusbe cats̈átanga chábeñe ndoñe montsanos̈buaché. Chíyeca chënga chca tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Chora Jesús tojanë́jua: —Ats̈be ora cabá ndoñe quentóshjango, pero ts̈ëngaftangbiama mocna órnaca ts̈abá endëtsomñe. ");
INSERT INTO kbh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Chë nÿe quem luarama enójuabnaye ents̈anga ndoñe quemátobena ts̈ëngaftanga jtsë́buayënjana, pero áts̈bioyna aíñe, er ats̈e puerte ts̈abá sëntsinÿanÿná nts̈amo chënga imojtsamcá ndoñe ts̈abá yontsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ts̈ëngaftanga chë fiestama s̈mochjá. Ats̈be ora cabá ndoñe quentóshjango. Chíyeca ats̈e choye ndoñe quicháta ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesús chë soyënga tojanë́yana y cach Galileoca tojtsanoquedañe. ");
INSERT INTO kbh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Chabe cats̈átanga chë fiestoye tmojána chents̈ana, Jesúsnaca tojána, masque ndoñe ents̈ángbeñe, sinó mo iytëcana cuenta. ");
INSERT INTO kbh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chë fiestocna, judiënga Jesús imojtsenguaye y imojtsichamo: —¿Ndayents̈e chë boyabása yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ents̈ángbeñe ba soyënga chabiama iytëcana imojtsichamo. Inÿenga chabiama imojtsichamo: “Cha ts̈abia endmëna ca”; pero ínÿengna: “Cha ents̈anga entsaíngña ca”. ");
INSERT INTO kbh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero ndocná Jesusbiama becá añémoca yontsoyebuambná, chë judiëngbe amë́ndayëngbiama imojtsauatja causa. ");
INSERT INTO kbh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chë fiesta semana tsë́ntsañe yojtsó ora, Jesús Bëngbe Bëtsabe bëts yebnents̈e tojánamashëngo, y tojanonts̈é jabuátambana. ");
INSERT INTO kbh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Chents̈e chë judiënga, nts̈amo Jesús tojanabuatambacá tmojanuena ora, ojnanánënga imojtsichamo: —Bëtscá ntjuatsjinÿcá, ¿nts̈amo nÿets̈á nantsetáts̈ëmbo ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","As Jesús tojanë́jua: —Ats̈be buatëmbayana ndoñe nÿe áts̈bents̈ana quenatóbocana, ndayá chë s̈onjichmó chábents̈ana. ");
INSERT INTO kbh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nda tojtsebos̈e jamama nts̈amo chë s̈ojichmó cha yojtsebos̈cá, cha echántsetats̈ëmbo ats̈be buatëmbayana Bëngbe Bëtsábiocana yóbocanama o nÿe áts̈bents̈ana. ");
INSERT INTO kbh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nda nÿe cachabe juábnaca tojtsoyebuambná, jtsebos̈ana ents̈anga más bëtsá chamobemama; pero nda bëtscá tojtsama, chë tbojichmóbioye ents̈anga más bëtsá chamobemama, cha cocayé nts̈amo ndegombre yomncá jtsóyebuambnayana, y ndocnábioye ntseíngñayana. ");
INSERT INTO kbh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Ndegombre, Moisés ts̈ëngaftangbiama ley tojëftsanaboshjona. Pero masque chca, ts̈ëngaftanguents̈á ndocná quenátama nts̈amo cha tojëftsanmandacá. Y ¿ndáyeca s̈mojtsebos̈e ats̈e jóbama ca?” —Jesús tojanatjá. ");
INSERT INTO kbh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chora ents̈anga tmojanjuá: —¡Ndegombre aca bacna bayëjbe juabna contsambá! ¿Nda yojtsebos̈e aca jóbama ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chora Jesús tojanë́yana: —Nÿetsca ts̈ëngaftanga ojnanánënga ats̈e s̈montsonÿá, ats̈e canÿe ochnayté canÿe ents̈á tijashnama. ");
INSERT INTO kbh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero, Moisés tcmonjanamëndá básetema base bobachtema chë más delicadents̈e jatëts̈ana, chaotsinÿnama (ndoñe nÿe Moisésbeyeca chca, sinó Moisesbiama más tempsca bëts taitanga chca jamama imojanamánayeca); y ts̈ëngaftanga canÿe básetema base bobachtema chë más delicadents̈e jatëts̈ana, masque chë te canÿe ochnayté totsomñëse. ");
INSERT INTO kbh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Y mora, nts̈amo Moisés tcmojëftsanamëndacá ndoñe cachcá ntjonÿayama, canÿe básetema chca jatëts̈ana masque ochnayté; as, ¿ndáyeca ats̈e s̈mojtsayaná, ats̈e ochnayté canÿe ents̈abe nÿets cuerpo tijashnama? ");
INSERT INTO kbh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nÿe bats̈á jinÿëse, ínÿengbiama ndoñe matichámëngana ts̈abá o ndoñe ts̈abá tmonjama ca. Nts̈amo chë soyënga ndegombre bétsemnama natsana lempe ts̈abá jshétsetats̈ëmbëse, s̈mochjayana ts̈abá o ndoñe ts̈abá tmonjama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Chora báseftanga Jerusalenoca oyenënga tmojanonts̈é ichámuana: —¿Mua ndoñe yontsemna chë jóbama montsenguá cha ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Masque ba ents̈angbe delante entsoyebuambná, ndocná chábioye ndocá ntjauyanana. ¿Nderado mo chë bëngbe amë́ndayënga imojtsejuabná cha chë Cristo, chë Uámana Uabuayaná yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero bënga mondë́tats̈ëmbo ndëmocá quem boyabása yomnana; y chë cuenta, chë Cristo chaojabo ora, ndocná queochátstats̈ëmbo ndë́mocana cha yochjabama ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chca tojanuena ora, Bëngbe Bëtsabe bëts yebnents̈e Jesús yojtsabuátambayëntscuana, cha jabuache tojánayana: —¡Ts̈ëngaftanga s̈mojtsejuabná ats̈e ndegombre s̈mabuatma, y ndë́mocana tijabama s̈mojtsetáts̈ëmbo ca! Pero nÿe ats̈be cuenta, ndoñe chiyátabo, ndayá canÿa s̈ojichmóyeca, nda nts̈amo ndegombre yomncá nÿetsca soyëngama endbétsoyebuambnaye; y ts̈ëngaftanga cha ndoñe ques̈matábuatma. ");
INSERT INTO kbh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ats̈na aíñe cha sënduábuatma, er ats̈e chábents̈ana sënjabo y cha quem luaroye s̈onjichmó ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesús chca tojánayana ora, chënga tmojánbos̈ena cha jishachama, pero ndocná tbonjánishache, er cha chca japásama cabá ndoñe ora tonjanóshjango. ");
INSERT INTO kbh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Banga chents̈e Jesúsbeñe imojtsanos̈buaché y tmojánayana: “Chë Uámana Uabuayaná chaojabo ora, ¿quem boyabásabiama más ts̈abe soyënga yochjama ca?” ");
INSERT INTO kbh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chë fariseunga tmojántats̈ëmbona nts̈amo ents̈anga Jesusbiama iytëcana imojtsencuéntaye. As, chënga y chë bachnangbe amë́ndayënga tmojanichamó báseftanga Bëngbe Bëtsabe bëts yebnoca josticiënga, Jesús chamuishachama. ");
INSERT INTO kbh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chora Jesús tojánayana: “Muents̈ana nÿe baseftayté ts̈ëngaftangaftaca chanjë́ftsemna; chents̈ana, chë s̈ojichmó chábioye chanjëtspadésa. ");
INSERT INTO kbh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chora ts̈ëngaftanga ats̈e s̈mochántsenguaye, pero ndoñe ques̈mochátinÿena; y ndayents̈e chántsemnoca ndoñe ques̈mochatobenaye jashjanguama ca.” ");
INSERT INTO kbh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chora chë judiënga tmojanonts̈é entjanayana: “¿Ndë́moye quem boyabása yochjá, y bënga ndoñe mochanjobenaye jinÿenama ca? ¿Inÿe fshantsëngoye, judiënga tmojuashanë́ngbioye yochjá, y choca chë ndoñe judiënga yochjabuatambá? ");
INSERT INTO kbh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nts̈amo yojtsents̈áyana cha s̈onjauyancá, chë ‘ts̈ëngaftanga ats̈e s̈mochántsenguaye, pero ndoñe ques̈mochátinÿena; y ndayents̈e chántsemnoca ndoñe ques̈mochatobenaye jashjanguama ca’?” —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chë fiesta jopochócama te yojamna chë más uámana te. Chë te, Jesús ents̈ángbents̈e tojantsá y jabuache tojánayana: “¡Nda tbojtsajuendá, áts̈bioye chauabo y chaofs̈é! ");
INSERT INTO kbh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá: ‘Nda áts̈beñe tojtsos̈buaché, cha echántsemna mo ndabe ainanents̈ana vida bomna béjayënga tojtsobocancá.’ Chca echántsemna áts̈beñe os̈buáchiyëngbiama ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Chë sóyeca, Jesús yojtsebos̈e jayanana, chábeñe os̈buáchiyënga chë Uámana Espíritu mochjanóyëngacñe ca; er chë Uámana Espíritu cabá ndoñe tonjánabo, Jesús corente bëtsá yojamnama cabá ndoñe tmonjaninÿinÿé causa. ");
INSERT INTO kbh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chca tmojanuena ora, ínÿenga imojtsichamo: —Quem boyabása ndegombre chë Bëngbe Bëtsabe juabna oyebuambnayá entsemna, chë Cristbe natsana jabamá ca. ");
INSERT INTO kbh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Inÿenga imojtsichamo: —Ndegombre cha chë Cristo, chë Uámana Uabuayaná entsemna ca. Pero ínÿengna: —Ndoñe, er chë Cristo Galileocana ndoñe queochátabo. ");
INSERT INTO kbh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ndegombre, Bëngbe Bëtsabe uabemana palabrënguiñe endayana, chë Cristna rey Davídbents̈ana ents̈á canmëna, y Belenocana caochjabo ca, cach pueblocana ndayents̈á David inamna ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Y chca, ínÿengna Jesusbe pavor imojtsemna, y ínÿengna chabe contra. ");
INSERT INTO kbh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Inÿenga imojtsebos̈e Jesús jishachama, pero ndocná tbonjánishache. ");
INSERT INTO kbh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Chë fariseunga y bachnangbe amë́ndayënga imojtsemnoye chë Bëngbe Bëtsabe bëts yebnoca josticiënga tmojtanashjajna ora, tmojanatjá: —¿Ndáyeca ndoñe Jesús s̈monjuánatse ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chora chë josticiënga tmojanë́jua: —Ndocná quenatoyebuambná nts̈amo chë boyabása tonjoyebuambacá ca. ");
INSERT INTO kbh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Chora chë fariseunga tmojanë́yana: —¿Ts̈ëngaftángnaca s̈mojalesenciá cha chacmaingñema ca? ");
INSERT INTO kbh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nderado bëngbe amëndayënguents̈á o bënga fariseunguents̈á nÿe mo canÿa chábeñe tayojtsos̈buaché? ");
INSERT INTO kbh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero quem ents̈anga, nts̈amo leyiñe iuayancá nduabuátmënga, bacna soyë́ngaca sempre mochanjë́ftsemna ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chora Nicodemo, canÿa fariseunguents̈á, chë Jesúseftaca jencuéntama ibeta tojána cha, tojánayana: ");
INSERT INTO kbh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Nts̈amo bëngbe leyiñe endayancá, bënga ndoñe quemuátobena jayanana canÿe ents̈á castiganá jtsemnama ibojtsemna ca, cha cabá ntjoyeunaycá, ndayá cha tojamama jtsetats̈ëmbuama ca. ");
INSERT INTO kbh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chora chënga Nicodemo tmojanjuá: —¿Acnaca chábeñe cojtsos̈buaché y mo canÿe Galileoca ents̈acá cojtsejuabná ca? Bëngbe Bëtsabe uabemana palabrënguiñe cochjuatsjinÿe, y cochanjinÿe ni canÿa Bëngbe Bëtsabe juabna oyebuambnayá Galileocana yochjabo ca. ");
INSERT INTO kbh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Fariseunga y bachnangbe amë́ndayënga chë josticië́ngbioye tmojanëcácanents̈ana, cada ona cachabe yebnoye imojtsatóñënga. ");
INSERT INTO kbh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Jesusna canÿe tjoye, Olivos ca uabáinoye tojtsanoñe. ");
INSERT INTO kbh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y chë yëfsana cachëse, Jesús cachiñe Bëngbe Bëtsabe bëts yebnoye tojesaná. Nÿetsca ents̈anga tmojanobeconá jouenama, y Jesús tojanótbema y tojanonts̈é jabuátambama. ");
INSERT INTO kbh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chorna, báseftanga ley abuátambayënga y fariseunga tmonjánashjajna, y canÿe shembása tmojanë́shjango. Chana tmojáninÿena chabe boyábioye ínÿaftaca ibnetsoíngñañëntscuana; nÿetscangbe tsëntsaca tmojanatsá, ");
INSERT INTO kbh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y Jesús tmojaniyana: —Buatëmbayá, quemuá fsënjínÿena chabe boyábioye ínÿaftaca bondëtsoíngñañëntscuana. ");
INSERT INTO kbh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Leyiñe Moisés s̈onjanamëndá mënts̈á uamana shembásengna ndëts̈béngaca jtsëbáyama. ¿Aca nts̈amo catjayana ca? ");
INSERT INTO kbh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jesús chca tmojaniyana ana jisháchichiyama, chca chënga jtsebomnama ndáyeca chabe contra jayanana. Pero Jesús nÿe fshantsoye yojotsejbéna y yojónts̈a nts̈abuáfjaca fshantsiñe juabemama. ");
INSERT INTO kbh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Chënga nÿe imojtsetjanaye causa, Jesús tojantsbaná y tojanë́yana: —Nda ts̈ëngaftanguents̈á tondaye bacna soyënga tondbomná, chaobojats̈é ndëts̈beca jatëchënjama ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chents̈ana Jesús cachiñe fshantsoye yojtotsejbéna, y yojtëtónts̈a fshantsiñe jtëtabemama. ");
INSERT INTO kbh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chca tmojanuena ora, ents̈anga tmojanonts̈é canÿánÿa chents̈ana jésebocanana; natsana chë más bëtsanánënga y chë ínÿengna ústonoye. Canÿa Jesús tonjanoquedá y chë shembásanaca. ");
INSERT INTO kbh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","As, Jesús tojtantsá y tbojantjá: —¿Shembása, ndayents̈e chë acbe contra ichámënga imojtsemna? ¿Ndocná acbiama tonjayana castiganá chacotsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ndoñe, Taita, ndocná ca —chë shembása tbojanjuá. Chora Jesús tbojaniyana: —Ats̈e cach ndoñe acbiama quichátayana castiganá chacotsemna ca. Morna, motsatoñe, pero ndoñe más bacna soye cattsama ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús cachiñe Bëngbe Bëtsabe bëts yebnents̈e yojtsabuátambaye, y ents̈anga mënts̈á tojanë́yana: —Ats̈e sëndbínÿna quem luare ents̈angbe juabnënga. Nda ats̈e chas̈ojtsë́stona, cha echantsiyena ats̈e chë binÿnayáftaca; y ndoñe mo ibetiñcá queochátaye, y chca, ts̈abe vida echántsebomna ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chora chë fariseunga Jesús tmojaniyana: —Aca nÿe cach acbiama chca contsoyebuambná; chcana, chë nts̈amo contsichamcá tondaye quenatámana ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","As chora Jesús tojanë́jua: —Nts̈amo cach ats̈biama sëntsichamcá aíñe entsámana, masque nÿe ats̈e stsichamo nts̈amo ats̈biama ndegombre yomncá. Er ats̈e sëndë́tats̈ëmbo ndë́mocana tijabo y ndë́moye tstsá. Pero ts̈ëngaftanga ndoñe chca ques̈mátstats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ts̈ëngaftanga s̈mondbétsichamo ínÿengbiama ts̈abá o ndoñe ts̈abá tmontsamama, chca, nÿe nts̈amo ents̈anga mondbetsejuabnaycá. Pero ats̈na ndocnabiama chca quetsátichamo. ");
INSERT INTO kbh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ats̈e ndoñe nÿe canÿa quetsátsmëna ínÿabiama jayanama ts̈abá o ndoñe ts̈abá tontsamama; ndayá ats̈be Taitá, chë s̈onjichmó cha, áts̈eftaca chca jayanana. Chíyeca, ats̈e ínÿabiama ts̈abá o ndoñe ts̈abá tonjama ca stsichamo ora, nts̈amo stsichamcá ndegombre jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ts̈ëngaftangbe leyiñe enduábemana, uta ents̈ata ndayámnaca cachcá tbojayanëse, nts̈amo chata tbojayancá puerte jtsámanana ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Y morna, ats̈e së́ntsichamo chë nts̈amo cach ats̈biama ndegombre yomncá, y ats̈be Taitá, chë s̈onjichmó chánaca entsichamo nts̈amo ats̈biama ndegombre yomncá ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chora chënga tmojantjá: —¿Ndayents̈e acbe Taitá yojtsemna ca? Y Jesús tojanë́jua: —Ts̈ëngaftanga ndoñe ques̈matábuatma ni ats̈e ni ats̈be Taitá. Ats̈e s̈mojtsábuatmësna, ats̈be Taitánaca s̈mattsábuatma ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bëngbe Bëtsabe bëts yebnoca, chë crocénana jacjayama luarents̈e yojtsabuátambaye ora, Jesús chca tojánayana. Pero masque cha chents̈e yojtsemna, ndocná tbonjánishache, er chca japásama cabá ndoñe ora tonjanóshjango. ");
INSERT INTO kbh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Chora Jesús yojtëtónts̈a oyebuambnayana: —Ats̈e chantá, y chora ts̈ëngaftanga ats̈e s̈mochántsenguaye. Masque chca, s̈mochanjóbana ts̈ëngaftangbe bacna soyëngama ndëperdonánënga. Chë chanjá luaroye, ts̈ëngaftanga ndoñe ques̈mátobena jama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chora chë judiënga tmojanonts̈é enatsëtsnayana: —¿Mo nderado yojtsejuabná jtsenóitanama, y chíyeca yojtsichamo chë cha yochjá luaroye bënga ndoñe montsobena jama ca? ");
INSERT INTO kbh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Chora Jesús tojanë́yana: —Ts̈ëngaftanga quem luaroquënga s̈mondmëna; ats̈na tsbananocá, celocá sëndmëna. Ts̈ëngaftanga nÿe quem luarama enójuabnayënga s̈mondmëna, pero ats̈e ndoñe. ");
INSERT INTO kbh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chíyeca ats̈e chca tcbonjáuyana, chë “ts̈ëngaftangbe bacna soyëngama ndëperdonánënga s̈mochanjóbana ca”. Er, nda ats̈e ndegombre bétsemnama ndoñe chas̈montsos̈buachese, ts̈ëngaftangbe bacna soyëngama ndëperdonánënga s̈mochanjóbana ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chora chënga tmojantjá: —¿As aca ndase cmëna ca? Y Jesús tojanë́yana: —Ents̈anga jabuátambama sënjanbojats̈é orscana chama tcbonjáuyana. ");
INSERT INTO kbh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ats̈e ba soyënga së́ntsebomna ts̈ëngaftangbiama jayanama, ts̈ëngaftangbe contra jayanama; pero chë s̈onjichmó cha nÿetsca soyëngama ndegombre endbétsichamo, y ats̈na nts̈amo chábents̈ana tijouencá, cachcá quem luare oyenënga sëntsëtsëtsná ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero chënga ndoñe tonjanësertá Jesús cachabe Taitabiama chca tojanë́yanama. ");
INSERT INTO kbh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","As Jesús tojanë́yana: —Bëngbe Bëtsá Ents̈á tbojanbemá chas̈mojatsbaná ora, s̈mochántsetats̈ëmbo nda sëndmëná ats̈e bétsemnama. Cachcá, ts̈ëngaftanga s̈mochántsetats̈ëmbo, nÿe cach ats̈be juábnaca ats̈e tondaye jamama sëndobenama. Nÿe ndayá ats̈be Taitá s̈ojabuatëmbacá ats̈e sëndoyebuambná. ");
INSERT INTO kbh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Y chë s̈onjichmó cha ndoñe nÿe canÿa ques̈nátsboshjuana. Chca endmëna, er ats̈e sempre sëndbétsama nts̈amo cha oyejuayá jabemama tojtsemncá ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús chca tojánayana ora, banga chábeñe imojtsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chora Jesús, chë chábeñe imojtsos̈buaché judiënga tojanë́yana: —Nts̈amo cbontsëtsëtsnacá ts̈ëngaftanga sempre s̈mojtsamëse, ndegombre ats̈be uatsjéndayënga s̈mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nts̈amo ndegombre yomncá s̈mochántsetats̈ëmbo; y nts̈amo ndegombre yomncá jtsetats̈ëmbëse, atsebácanënga s̈mochántsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chora chënga tmojanjuá: —Bëngna Abrahámbents̈ana ents̈anga fsëndmëna, y ndocná ndocna te ches̈náisishëche nÿe chabiama nÿets tempo jtsoservénama. As, ¿ndáyeca s̈cojtsëtsëtsná bënga atsebácanënga fchtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chora Jesús tojanë́yana: —Ndegombre s̈cuayana: Nda bacna soyënga tojtsama, cha nÿe bacna soyënga jamama juabnë́ngaca mandaná jëftsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Canÿe oservená ndoñe nÿets tempo chë pamillents̈á ntjë́ftsemnana, nts̈amo canÿe uaquiñá sempre chë pamillents̈á jesomñancá. ");
INSERT INTO kbh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Y chca, Bëngbe Bëtsabe Uaquiñá chacmojátsebacase, ts̈ëngaftanga ndegombre atsebácanënga s̈mochántsemna bacna soyënga juabnënguents̈ana. ");
INSERT INTO kbh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ats̈e sëndë́tats̈ëmbo ts̈ëngaftangna Abrahámbents̈ana ents̈anga s̈momnama; pero ts̈ëngaftanga s̈montsebos̈e ats̈e jóbama, nts̈amo ats̈e cbontsëtsëtsnacá ainaniñe jóyëngacñama ndoñe ques̈mátsbos̈e causa. ");
INSERT INTO kbh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nts̈amo ats̈be Taitábioca tijinÿcá, cach soyëngama ats̈e sëntsoyebuambná. Ts̈ëngaftángnaca, cachcá nts̈amo ts̈ëngaftangbe taitábents̈ana s̈mojouencá s̈montsama ca —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chora chënga tmojanjuá: —Bëngbe uámana bëts taitá, Abraham endmëna ca. As Jesús tojanë́yana: —Ts̈ëngaftanga Abrahambe básenga ca jtsabáinama merecido s̈mojtsebuajónëse, chë nts̈amo Abraham tojë́ftsema y cachcá ts̈ëngaftanga s̈mattsama. ");
INSERT INTO kbh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ats̈na nts̈amo ndegombre yomncá sëndoyebuambná, nts̈amo Bëngbe Bëtsábents̈ana tsouenancá. Pero mora ts̈ëngaftanga s̈montsebos̈e ats̈e jóbama; Abraham ndocna te chca chenaisobuachjanguá. ");
INSERT INTO kbh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ts̈ëngaftangna, nts̈amo ts̈ëngaftangbe taitá tojëftsemcá y cachcá jtsamana ca —Jesús tojánayana. Chora chënga tmojaniyana: —Bënga nÿe enaquë́cana básenga ndoñe queftsátsmëna. Chë nÿe canÿe taitá fsëndbomná, Bëngbe Bëtsá endmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Chora Jesús tojanë́yana: —Bëngbe Bëtsá ndegombre ts̈ëngaftangbe taitá tojtsemnëse, ts̈ëngaftangna ats̈e s̈mattsebobonshana. Er ats̈na, Bëngbe Bëtsábiocana sënjabo y muents̈e së́ntsemna. Nÿe ats̈be ponto ndoñe chiyátabo; Bëngbe Bëtsá s̈onjichmó. ");
INSERT INTO kbh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ndáyeca ts̈ëngaftanga ndoñe s̈montsobena ats̈be palabrënga josértana? Co, nts̈amo cbontsëtsëtsnacá joyeunayama ndoñe ques̈mátsbos̈e causa chca. ");
INSERT INTO kbh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ts̈ëngaftangbe taitá Satanás endmëna. Ts̈ëngaftangna chabe ents̈anga s̈mondmëna; chíyeca, ts̈ëngaftanga s̈montsebos̈e jamama cachcá nts̈amo cha tojtsebos̈cá. Quem luare jobojáts̈ama orscana, Satanás ents̈á obanayá endmëna. Satanasbe juabnoca, ndocna ts̈abe soyënga ni ndegombre soyënga ntsebínÿnana. Chíyeca, ndocna te cha nts̈amo ndegombre yomncá ntsamana. Cha canÿe bostero endmëna, y chábents̈ana nÿetsca bostero soyënga jtsóbocanana. Chíyeca, cha tojtsebostero ora, nÿe nts̈amo cachá yomnama jtsichámuana. ");
INSERT INTO kbh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ats̈na sempre nts̈amo ndegombre yomncá cbondutsëtsná; chíyeca, chë së́ntsichamo soyiñe ts̈ëngaftanga ndoñe ques̈matos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nda ts̈ëngaftanguents̈á nanjobenaye jinÿanÿiyana ats̈e ndaye bacna soye tijamama? Y ats̈e, nÿe nts̈amo ndegombre yomncá stsichámëse, ¿ndáyeca chë tijayaniñe ndoñe s̈montsos̈buaché? ");
INSERT INTO kbh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nda Bëngbe Bëtsabe ents̈á tomna, nts̈amo Bëngbe Bëtsá tojtsichamcá jtsuenanana. Pero ts̈ëngaftangna ndoñe Bëngbe Bëtsabe ents̈anga ques̈mátsmëna. Chíyeca, nts̈amo Bëngbe Bëtsá entsichamcá ndoñe ques̈mátsbos̈e jouenama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chora chë judiënga tmojaniyana: —Ajá, bënga co ndegombre fstsichamo, aca nÿe samaritano y bacna bayëjbe juabna uambayá comna ca fstsichamo ora ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Y Jesús tojanë́jua: —Ats̈e ni mo canÿe bayëjbe juabna quetsatambá. Nts̈amo ats̈e sëntsamcá, endmëna jinÿanÿiyama ats̈be Taitá Bëngbe Bëtsá uamaná yomnama; pero ts̈ëngaftangna, ats̈e chca tsmënama ndoñe ques̈matinÿinÿná. ");
INSERT INTO kbh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ats̈e ndoñe quetsátsbos̈e ínÿenga ats̈e más uamaná chas̈mobemama. Pero inÿa endmëna; cha aíñe endbos̈e ats̈e bëtsá bétsemnama chaminÿanÿema. Y chánaca endmëna chë ínÿengbiama ts̈abá o ndoñe ts̈abá tmontsamama endbetsichamuá. ");
INSERT INTO kbh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ndegombre s̈cuayana, nda nts̈amo ats̈e sëntsichamcá tojouena y chca tojama, ndocna te queochatóbana ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chora chë judiënga tmojaniyana: —Mora cocayé fsë́ntsetats̈ëmbo aca ndegombre bacna bayëjbe juabna uambayá comnama. Abraham tojanóbana, y cachcá, nÿetscanga Bëngbe Bëtsabe juabna oyebuambnayë́ngnaca. ¿Y mora aca cochjátichamo, “Nda nts̈amo ats̈e sëntsichamcá tojouena y chca tojama, cha ndocna te queochatóbana ca”? ");
INSERT INTO kbh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿O aca, bëngbe bëts taitá Abrahambiama más bëtsá comna? Cha tojanóbana, y Bëngbe Bëtsabe juabna oyebuambnayë́ngnaca. ¿Ndase cojátsmëna ca aca cojatsjuabná ca? —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chora Jesús tojanë́jua: —Ats̈e nÿe cach ats̈e más bëtsá stsenobiamnasna, chë soye tondaye nantsámana. Pero chë más bëtsá s̈ojtsebiamná cha, ats̈be Taitá endmëna, cach ndabiama ts̈ëngaftanga s̈mondbétsichamo ts̈ëngaftangbe Bëtsá canmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero ts̈ëngaftanga cha ndoñe ques̈matábuatma; ats̈e aíñe. Y ats̈e, “cha ndoñe quetsatabuatma ca” stsichámëse, áts̈naca cach ts̈ëngaftangcá canÿe bostero stsemna. Pero ndegombre ats̈e cha sënduábuatma, y nts̈amo cha tojtsichamcá, ats̈e sëndouenana y cachcá sëndbétsama. ");
INSERT INTO kbh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ts̈ëngaftangbe uámana bëts taitá Abraham, chë ats̈e jabama te jinÿama yojtsejuabnaye ora, puerte oyejuayá yojtsemna. Y pronto tojë́ftsaninÿe, y puerte tojanoyejuá ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chora chë judiënga tmojaniyana: —Aca cabá ndoñe shachna bnë́tsana uata quecátsbomna; y as, ¿nts̈amo cochjátichamo, Abraham tcojë́ftsinÿe ca? ");
INSERT INTO kbh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chora Jesús tojanë́jua: —Ndegombre cbë́yana, Abraham cabá ndoñe ainá quenjatsmëna ora, ats̈e ya sënjétsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesús chca tojanë́jua ora, chënga ndëts̈benga tmojanájaca cha jtsatëchë́nganjama. Pero Jesusna oitanánana, Bëngbe Bëtsabe bëts yebnents̈ana tojésanbocna. ");
INSERT INTO kbh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Canÿe luarëjana yojtsachnëjuana ora, Jesús canÿe boyabásabioye tbojáninÿe. Chë boyabásana jtaná inónÿna. ");
INSERT INTO kbh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chë uatsjéndayënga Jesús tmojantjá: —Buatëmbayá, ¿ndáyeca quem boyabása jtaná inónÿna? ¿Camuá bacna soyënga tojamama, o chabe bëtsë́tsangbe bacna soyënga causa ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chora Jesús tojanë́jua: —Ni cachabe bacna soyëngama, y ni chabe bëtsë́tsangbe bacna soyënga causa. Chca endmëna ndayá ents̈anga jinÿanÿiyama nts̈amo Bëngbe Bëtsá yobencá. ");
INSERT INTO kbh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cabá yojtsësháchena ora, s̈ontsamna jamana nts̈amo chë s̈onjichmó cha yojtsebos̈cá. Ndoñe usháchena tempo echanjóshjango; chora ndocná tondaye jamama queochatobenaye. ");
INSERT INTO kbh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quem luariñe chjëftsemnëntscuana, ats̈e quem luare ents̈angbe juabnënga binÿnayá chanjë́ftsemna ca —tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chca tojánayanents̈ana, Jesús fshantsiñe tojanbuashëtjo, y chë yebuáyeca bats̈á ngüiche tojánbema, y chë jtaná chë ngüícheca tbojanbuchanëtjo. ");
INSERT INTO kbh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chora chë jtaná tbojaniyana: —Motsa y metsobúchjabebiye, chë binche uafjajónaye ents̈angbe pormániñe, Siloé ca uabáiniyoca ca. (Siloé, judiëngbe biyañe endayana “Ichmoná ca”.) Y chë jtaná tojána; choca yojetsobúchjabebiye, y yebnoye tojtaná ora, ya ibojtsabinÿna. ");
INSERT INTO kbh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chë juachañe oyenënga y chë jtaná tempo lemos̈na otjanañana tmojáninÿënga, imojtsentjanaye: —¿Mua ndoñe yondmëna chë enjanamana jótbemana lemos̈na jótjañama ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Inÿenga imojtsichamo: —Cha entsemna ca. Y ínÿengna: —Cha ndoñe quenátsmëna, pero chacá entsábona ca. Y cach shnaná yojtsichamo: —Ats̈e cha sëndmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","As chë ents̈anga tmojantjá: —¿Nts̈amo chca mora cmojtsabinÿna ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Y cha tojanë́jua: —Chë boyabása, Jesús ca uabainá, ngüiche yebuáyeca tonjábema, s̈onjabuchanëtjo y s̈onjauyana: “Motsa y Siloé uafjajónayiñe metsobúchjabebiye ca”. Chcasna, ats̈e sënjá, sënjetsobúchjabebiye y cachora s̈ontsabinÿna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chora chënga tmojantjá: —¿Ndayents̈e cha yojtsemna ca? Y chana: —Ats̈e ndoñe quetsátstats̈ëmbo ca —tojanë́jua. ");
INSERT INTO kbh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chora chë ents̈anga, chë jtaná inamná fariseúngbioye tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Chë Jesús bats̈á yebuáyeca ngüiche tojánbema, y chë jtaná tojanma te, canÿe ochnayté inamna. ");
INSERT INTO kbh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","As chë fariseunga chë boyabása tmojantjá: —¿Nts̈ámoyeca mora cmojtsabinÿna ca? Chora cha tojanë́jua: —Cha ngüiche yebuáyeca tonjábema y s̈onjabuchanëtjo. Sënjetsobúchjabebiye, y cachora s̈onjuabinÿna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","As chora básefta fariseunga imojtsichamo: —Chë jtaná chabotsabinÿnama tojamá ndoñe tonjochná, y ochnayté tojatrabajá. Chíyeca cha Bëngbe Bëtsabe ents̈á ndoñe quenátsmëna ca. Inÿenga imojtsichamo: —Cha canÿe bacna soyënga amá tojtsemnëse, ¿nts̈amo nantsobena canÿe bëts soye Bëngbe Bëtsabe obenánaca jamama ca? Y chca, ínÿenga Jesusbe pavor imojtsemna, y ínÿengna chabe contra. ");
INSERT INTO kbh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chama chënga cachiñe chë jtaná inamná tmojtëtantjá: —Er aca mora chacmotsabinÿnama cha tojamëse, ¿chabiama nts̈amo catjayana ca? Chora cha tojanë́jua: —Chana canÿa Bëngbe Bëtsabe juabna oyebuambnayá entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero chë judiënga ndoñe montsanos̈buaché, cha chë jtaná inamnama y chora ibojtsabinÿnama. As chënga, ínÿenga tmojanichamó chë boyabásabe bëtsë́tsata jobiats̈ama. ");
INSERT INTO kbh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chë bëtsë́tsata tbojánashjango ora, chë judiënga tmojanatjá: —¿Quem boyabása tsëndatbe uaquiñá yomna ca? ¿Ndegombre tas̈ojtsichamo cha jtaná inonÿnama? Chcase, ¿nts̈amo mora cha ibojtsabinÿna ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chora chë bëtsë́tsata tmojanë́jua: —Aíñe fsëndë́tats̈ëmbo cha bëndatbe uaquiñá endmënama y jtaná tonjanonÿnama. ");
INSERT INTO kbh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero ndoñe queftsátstats̈ëmbo nts̈ámoyeca mora chca ibojtsabinÿnama, ni bëndatbe uaquiñá chabotsabinÿnama nda tojamama cach ndoñe. Cachá motjanga. Ya bëtsá entsemna, y cachá entsobena ts̈ëngaftanga razón jats̈atayama ca —chata tbojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tempo, chë judiënga imojenóyeunaye, chëngbe enefjuana yebnënguents̈ana jtëbuacanana chë Jesús ndegombre chë Uámana Uabuayaná, chë Cristo yojamna ca tmojayanënga. Chë bëtsë́tsatna chama ibojtsauatja; ");
INSERT INTO kbh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","chíyeca tmojanë́yana: “Cha ya bëtsá entsemna. Cachá motjanga ca”. ");
INSERT INTO kbh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","As cachiñe chë judiënga chë jtaná inamná tmojanchembo y tmojaniyana: —Bëngbe Bëtsabe delante cach acbiama ndegombre mobuambá. Bënga fsëndë́tats̈ëmbo chë boyabása canÿe bacna soyënga amá yomnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chora cha tojanë́jua: —Cha canÿe bacna soyënga amá o ndoñe tondmënama, ats̈e ndoñe quetsátstats̈ëmbo. Ats̈e nÿe mënts̈á së́ntsetats̈ëmbo: Ats̈e jtaná sënjanmëna, pero mora s̈ontsabinÿna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chora chënga cachiñe tmojatantjá: —¿Nts̈amo tcmënjama? ¿Nts̈amo cha tënjama chacmotsabinÿnama ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Y cha tojanë́jua: —Ya tcbonjáuyana y ndoñe ches̈matoyeuná. ¿Ndáyeca cachiñe s̈mojtsebos̈e jatuenama? ¿Ts̈ëngaftángnaca s̈mojtsebos̈e chabe ústonënga jtsemnama ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chora chënga cha tmojtsanóyenguango y tmojaniyana: —Acna canÿe chabe ustoná cojtsemna, pero bënga ndoñe; bëngna Moisesbe ústonënga fsëndmëna. ");
INSERT INTO kbh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bënga fsëndë́tats̈ëmbo, Bëngbe Bëtsá Moisésbioye tbojanatsëtsama, pero chë boyabásabiama ndoñe queftsátstats̈ëmbo ni mo ndë́mocana cha tojabama ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chora chë boyabása tojanë́jua: —¡Nts̈amo chca nántsemna! Ts̈ëngaftanga ndoñe s̈montsetáts̈ëmbo ndë́mocana cha tojabama; pero chas̈uabinÿnama cha tonjama. ");
INSERT INTO kbh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bënga ts̈abá mondë́tats̈ëmbo, bacna soyënga amënga Bëngbe Bëtsá ndoñe queondbátayaunanama. Chana, nÿe chábioye adorayá y nts̈amo cha tojtsebos̈cá amábioye joyeunayana. ");
INSERT INTO kbh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Quem luare jobojáts̈ama orscana ndocna te quenaisótats̈ëmbo canÿe jtaná onÿnanabiama ndánaca cha chabotsabinÿnama tojë́ftsemama. ");
INSERT INTO kbh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Quem boyabása, Bëngbe Bëtsabe ichmoná chabe soyënga jamama ndoñe tontsemnëse, tondaye nantsobena jamama ca —chë ents̈á tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","As chë fariseunga tmojaniyana: —¡Ndayá! Aca tcojanonÿná orscana, corente bacna soyënga amá tcomnëse, ¿nts̈amo mora bënga s̈cochjátabuatambaye ca? Y chora chë judiëngbe enefjuana yebnents̈ana cha tmojtanábocna. ");
INSERT INTO kbh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chë jtaná tmojtanábocnama Jesús tojanuena ora, tojána cha janguanguama. Tbojáninÿena ora tbojaniyana: —¿Aca Bëngbe Bëtsá Ents̈á tbojanbemábeñe quecojtsos̈buaché ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y cha tbojanjuá: —¿Taita, nda cha yojtsemna, as ats̈e chábeñe jtsos̈buáchiyama ca? ");
INSERT INTO kbh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","As Jesús tbojaniyana: —Aca ya tconjinÿe; chë ácaftaca entsoyebuambná cha entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chora, chë boyabása Jesúsbents̈e tojanoshaments̈é jëtschuayama y tbojaniyana: —Ats̈be Utabná, aíñe sëntsos̈buaché ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chora Jesús chë ents̈anga tojanë́yana: —Ats̈e quem luaroye tijabo ndayá ents̈anga jinÿanÿiyama nts̈amo cachënga Bëngbe Bëtsabe soyëngama imojuabnama. Chë Bëngbe Bëtsabe soyëngama ndosertánënga, chë soyënga ats̈e chanjínÿanÿiye ora, mo jtanëna shnanëngcá mochántsemna; y chë Bëngbe Bëtsabe soyëngama corente imotáts̈ëmbo ca juabnayëngna chanjínÿanÿiye, nÿe bats̈á Bëngbe Bëtsabe soyëngama imotats̈ëmbuama. Y chca, chënga, masna mo jtanëngcá mochántsemna y ndoñe mo chë jinÿama obenëngcá. ");
INSERT INTO kbh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Básefta fariseunga Jesúseftaca imojtsemnënga chca tmojanuena ora, cha tmojaniyana: —Ndegombre bënga ndoñe mo jtanëngcá queftsátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chora Jesús tojanë́jua: —Ts̈ëngaftanga Bëngbe Bëtsabe soyëngama ndëtats̈ëmbënga s̈mojtsemna ca, y ndegombre chë soyëngama ndoñe cmontsë́sertana ca s̈mojobuambase, ndayá s̈mojtsamcá Bëngbe Bëtsá mo bacna soyënga cuenta ndoñe queochátonÿaye. Pero ts̈ëngaftanga corente Bëngbe Bëtsabe soyëngama cmojtsë́sertana ca s̈mojtsichámësna, Bëngbe Bëtsá ndoñe queochatobenaye ts̈ëngaftangbe bacna soyëngama jáperdonana ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","As Jesús tojanë́yana: “Ndegombre s̈cuayana: Nda chë oveshëngbe luaroye bës̈áshajana ndoñe tonjámashëngo, pero aíñe inÿajana tojtsamáshëngo, chana canÿe atbëbaná y abacayá jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero chë bës̈áshajana tojamashënguana, chë oveshënga anÿená jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chë bës̈ásha ebtafjuaná, chë bës̈ásha jebëtafjuana, y chë oveshënga abuajë́nÿa nts̈amo cada ona tmabaincá chë oveshënga jáchembuana. Y chë oveshënga jtsetats̈ëmbuana chëngbe abuajë́nÿa yojtsachembuanama; y chë luarents̈ana cha jubuacnana. ");
INSERT INTO kbh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nÿetsca oveshënga tmojábocana ora, chë abuajë́nÿa chënga jtsebënatsanana, y chë oveshënga jtsë́stonana, er chabe oyebuambnayana chënga joyátëmbana. ");
INSERT INTO kbh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero chë tmonduabuatmábioyna chë oveshënga ndoñe ntjuastana; nÿe chábents̈ana jtsachetëngana, chë oveshënga chabe oyebuambnayana ndoñe ntjoyátëmbana causa ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús ents̈anga chca tonjanacuntá, pero chënga ndoñe ntjosértana nts̈amo yojtsents̈ayancá. ");
INSERT INTO kbh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","As Jesús cachiñe tojanë́yana: “Ndegombre cbë́yana: Ats̈e sëndmëna chë bës̈ásha oveshënga mondbétsamashjuanëjana. ");
INSERT INTO kbh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nÿetscanga chë ats̈be natsana tmojánabënga, atbëbanënga y abacayënga imnamna, pero chë oveshënga ndoñe chë́ngbioye ntjóyaunayana. ");
INSERT INTO kbh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ats̈e chë bës̈ásha sëndmëna. Nda quem bës̈áshajana tojamashënguá, atsbocaná echántsemna. Canÿe oveshá jamashënguana y jabocnana, y shácuana jónÿenana. Cachcá, chë quemëjana tojamashënguá, lempe echanjónÿena. ");
INSERT INTO kbh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Chë atbëbaná jabana nÿe jatbëbama, jóbama y lempe jtsepochócama; pero ats̈na, ents̈anga vida chamotsebomnama y áts̈eftaca bëtscá ts̈abe vida chamotsebomnama tijabo. ");
INSERT INTO kbh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ats̈e sëndmëna chë oveshënga ts̈abe abuajë́nÿa. Chë oveshënga ts̈abe abuajë́nÿa sempre jtseprontánana chëngbiama jóbanama, chabe oveshënga ababuánÿeshanayeca. ");
INSERT INTO kbh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero nda nÿe crocenánama totrabája y chë oveshënga ndoñe chábenga tmontsemna, cha nderado tojinÿe canÿe tjañe ques̈e chë oveshë́ngbioye tojtsobécocnama, cachora nÿe cachcá jesë́nÿayana y jtsachana. Chë tjañe ques̈e oveshënga jtsacamiyana, y chë oveshëngna nÿe cátoye jtsachetana. ");
INSERT INTO kbh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cha jtsemnana nÿe crocenánama trabajayá; chabiama nÿe chë uacanánana más uámana soye jtsemnana, y chë oveshëngbiama tondayana ntsents̈amnana; chíyeca cha jtsachana. ");
INSERT INTO kbh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ats̈e sëndmëna chë oveshënga ts̈abe abuajë́nÿa. Ats̈e chënga sëndëubuatma, y chë́ngnaca ats̈e s̈monduábuatma. ");
INSERT INTO kbh_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Cachcá, chë Taitá Bëngbe Bëtsá ats̈e s̈onduábuatma y ats̈e chábioye. Ats̈e sempre sëndétseprontana jóbanama, ats̈be oveshënga sëndababuanÿeshánayeca. ");
INSERT INTO kbh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ats̈e inÿe oveshënga sëndábamna, pero chënga ndoñe quem luariñe oveshënga quemátsmëna. Ats̈e s̈ontsemna chë́ngnaca moye junatsana. Chë́ngnaca ats̈be oyebuambnayana mochanjouena, y muents̈a oveshë́ngaftaca cánÿiñe mochántsemna, y ats̈na nÿetsca chë oveshëngbiama chë abuajë́nÿa chántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ats̈e sempre sëndétseprontana jóbanama, chora jtayenama. Chíyeca chë Taitá s̈ondbobonshana. ");
INSERT INTO kbh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndocná ats̈be vida ques̈ochatsbojuána, pero chënga sëndababuanÿeshánayeca sempre sëndétseprontana jóbanama, cach ats̈e chca së́ndbos̈eyeca. Derecho sëndëtsóbomñe chëngbiama jóbanama, y chora jtayenama. Chca endmëna nts̈amo ats̈be Taitá s̈onjamandacá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Chë soyënga chë judiënga tmojanuena ora, cachiñe banga Jesusbe contra y ínÿengna Jesusbe pavor imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Banga imojtsichamo: —Chana bacna bayëjbe juabna uambayá y corente juicio ndbomná entsemna. Y as ¿ndáyeca cha mochjátsyeunana ca? ");
INSERT INTO kbh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ínÿengna imojtsanichamo: —Ndocna bacna bayëjbe juabna uambayá ntsobenana chca jóyebuambayama. ¿Canÿe bayëja nantsobena jamama canÿe jtaná chabotsabinÿnama ca? ");
INSERT INTO kbh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Canÿe uaftena tempo inamna, y Jerusalenents̈e canÿe fiesta imojtsebomna. Chë fiesta inamna cada uata, Bëngbe Bëtsabe bëts yebna tempo cachiñe tmojtanjebuama ents̈anga jtenójuaboyama. ");
INSERT INTO kbh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús Bëngbe Bëtsabe bëts yebnoca yojétsana, canÿe amashjuana otsbojebniñe, Salomonbe Amashjuana ca uabáinents̈e. ");
INSERT INTO kbh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chora, chë judiënga tmojanóbobuashcona, y tmojantjá: —¿Buetaytentscuana bënga fchjë́ftsemna acbiama ndegombre soye ntsetats̈ëmbcá? Aca chë Cristo cojtsemnëse, chama lempe ts̈abá s̈manÿanÿé ca. ");
INSERT INTO kbh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","As Jesús tojanë́jua: —Ya tcbonjáuyana y ts̈ëngaftanga áts̈beñe ndoñe ntsos̈buáchiyana. Chë ats̈e sëndama soyënga, ats̈be Taitá Bëngbe Bëtsabe obenánaca, cmontsinÿanÿná nda ats̈e bétsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ts̈ëngaftanga áts̈beñe ndoñe ques̈matos̈buaché, er ts̈ëngaftanga ats̈e ndoñe ques̈matë́stona, nts̈amo chë oveshënga chë ts̈abe abuajë́nÿa mondbetsëstoncá. ");
INSERT INTO kbh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chë ats̈e s̈mondústonënga, ats̈e s̈mondbóyeunaye y s̈mondbëuasto. Ats̈e chënga sëndëubuatma. ");
INSERT INTO kbh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ats̈e chanjama, quem ents̈anga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama; chënga ndocna te pochocánënga quemochátsmëna, y ndocná quenátobena áts̈bents̈ana chënga jefcana. ");
INSERT INTO kbh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ats̈be Taitá Bëngbe Bëtsá, chë ents̈anga ats̈e chas̈muastama tojamá, nÿetscangbiama más bëtsá endmëna, chíyeca ndocná quenátobena chábents̈ana chënga jefcana. ");
INSERT INTO kbh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Chë Taitá y ats̈e canÿa fsëndmëna ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Chora, chë judiënga cachiñe ndëts̈benga tmojanájaca Jesús jtsatëchë́nganjama. ");
INSERT INTO kbh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero Jesús tojanë́yana: —Ats̈e ts̈ëngaftangbeñe, ba bëts soyënga sënjama ats̈be Taitá Bëngbe Bëtsabe obenánaca. ¿Ndëmua chents̈a soyama ats̈e s̈mochtsatëchë́nganja ca? ");
INSERT INTO kbh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chora chë judiënga tmojanjuá: —Ni canÿe quem bëts soyëngama bënga queftsátsbos̈e aca jtsatëchë́nganjama. Aca Bëngbe Bëtsabiama ndoñe ts̈abá quecátichamo; mo chábioye cuafjoyenguangcá entsemna. Aca nÿe canÿe ents̈á condmëna, pero acna contsichamo cach aca Bëngbe Bëtsá comna ca; chíyeca bënga fsë́ntsebos̈e ndëts̈béngaca aca jtsatëchë́nganjama ca —chënga tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Chora Jesús tojanë́yana: —Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Ats̈e sënjayana ts̈ëngaftanga diosënga s̈momna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bëngbe Bëtsá chca tojánayana chë chabe palábraca y cha chamotseservénama tojánamandangbiama; ndocná quenátobena jinÿanÿiyana ni mo canÿe soye Bëngbe Bëtsabe uabemana palabrënguiñe, ndoñe ndegombre soye yomnama. ");
INSERT INTO kbh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Y ats̈biama, Bëngbe Bëtsabiacá uabuayaná y quem luare ichmoná, ¿nts̈amo ts̈ëngaftanga s̈mojtsobena jayanama, “aca Bëngbe Bëtsabiama ndoñe ts̈abá quecátichamo ca”, chë Bëngbe Bëtsabe Uaquiñá sëndmëna ca ats̈e tijayanama? ");
INSERT INTO kbh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nts̈amo ats̈be Taitá endamcá ats̈e ndoñe së́ntsamëse, ts̈ëngaftanga áts̈beñe ndoñe s̈mattsos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero, nts̈amo ats̈be Taitá endamcá ats̈e aíñe stsamëse, masque ndoñe áts̈beñe s̈montsos̈buaché, nÿe chë Taitabe obenánaca soyënga tijamama s̈mochtsos̈buáchiye. As, canÿe ora chas̈motsetáts̈ëmbo y chacmësertá, chë Taitá áts̈beñe yomnama y ats̈e chábeñe tsmënama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chora chënga cachiñe tmojánbos̈ena Jesús jishachama, pero cha chë́ngbents̈ana tojanotsbocá. ");
INSERT INTO kbh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chents̈ana, Jesús Jordán béjaye chenguana tojesaná y choca tojtsanoquedañe. Chents̈e Juan tempo ents̈anga yojanëbáyana. ");
INSERT INTO kbh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ba ents̈anga tmojána Jesús jinÿama, y mënts̈á imojtsichamo: “Ndegombre, masque Juan ni mo canÿe bëts soye Bëngbe Bëtsabe obenánaca tonjë́ftsema, lempe nts̈amo quem boyabásabiama tonjanoyebuambacá, ndegombre yojamna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y chents̈e, ba ents̈anga Jesúsbeñe imojtsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Inamna canÿe boyabása s̈ocá, Lázaro ca uabainá. Cha inoyena canÿe pueblo Betania ca uabáinents̈e, Marta y Maríaftaca, chabe uabénata. ");
INSERT INTO kbh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Quem María inamna nda Bëngbe Utabná Jesusbe shecuats̈iñe botamana uanguëts̈iye tbojanáshecbues̈cja, y chabe stjënashaca tbojtanshecbojó cha. ");
INSERT INTO kbh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chë uta uabénatna ínÿenga tmojanichamó Jesús jauenayama: —Bëngbe Utabná, chë aca condbobonshaná s̈ocá entsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús chca tojanuena ora, tojánayana: —Quem s̈ocana ndoñe quenátsmëna Lázaro chaóbanama. Pero aíñe entsemna Bëngbe Bëtsabe obenana ents̈anga jinÿanÿiyama, y Bëngbe Bëtsabe Uaquiñá chamuatschuama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús corente yojánababuanÿeshana Marta, María y chatbe uafts̈e Lázaro. ");
INSERT INTO kbh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Masque chcasna, Lázaro s̈ocá yojtsemna ca Jesús tmojaniyana ora, cabá uta te más cha yojétsemna luarents̈e tojtsanoquedañe. ");
INSERT INTO kbh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chents̈ana, chabe uatsjéndayënga tojanë́yana: —Judeoye cachiñe cuajna ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","As chë uatsjéndayënga tmojaniyana: —Buatëmbayá, baseftayté entsemna chë luaroca judiënga cmonjanbuachetá ndëts̈béngaca jtsóbama; y mora, ¿cabá choye jtésama cojtsebos̈e ca? ");
INSERT INTO kbh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Chora Jesús tojanë́yana: —Bnë́tsana uta hora bnëté endmëna. Nda bnëté tojtsana, ndoñe ntjojéstjiana, binÿniñe bétsemnayeca. Cachcá áts̈eftaca endmëna, tondaye quenátopodena áts̈eftaca jopásana, ats̈e jóbanama cabá ndoñe tonjobuache ora. Pero ibeta tojtsanëse, cha jtsojéstjiana, ndoñe binÿniñe causa. Cachcá, bënga s̈ontsamna yojtsësháchenëntscuana jatrabájana. Ats̈be jóbanama tempo chaojóshjango ora, ya ndoñe queochátëshachena jatrabájama ca —tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chents̈ana tojanë́yana: —Bëngbe amigo Lázaro tojtsomaná, pero ats̈e choye chanjá jetsefs̈enama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chora chë uatsjéndayënga tmojanjuá: —Bëngbe Utabná, tojtsomanase yojtsayana chana ts̈abá yochtsatsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús yojtsanëtsëtsná ndayá Lázaro tojtsanóbana ca, y chabe uatsjéndayëngna imojtsejuabnaye Lázaro ndegombre yojtsomáñama. ");
INSERT INTO kbh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","As Jesús ts̈abá tojanë́yana: —Lázaro tontsóbana. ");
INSERT INTO kbh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ats̈e sëntsoyejuá choca ats̈e ndoñe tsmënama, ts̈ëngaftangbe ts̈abiama chaotsemnama; chca, ts̈ëngaftanga más áts̈beñe chas̈motsos̈buáchema. Pero cuajna cha jinÿama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chora Tomás, chë Gemelo ca uabobainá, chë inÿe uatsjéndayënga tojanë́yana: “Bë́ngnaca cuajna, cháftaca mochjóbana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús chë béconana tojánashjango ora, tojántats̈ëmbona Lázaro ya canta te uatbontsána yojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pueblo yojamna Jerusalén béconana, mo unga kilómetroca. ");
INSERT INTO kbh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ba judiënga tmojána Marta y María jautsëtsayama y jatjëmbambayama ndoñe ts̈a ngménaca chabondëtsemnama, chatbe uafts̈e tojanóbana causa. ");
INSERT INTO kbh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús yojtsashjajuanama Marta tojántats̈ëmbona ora, tojánbocna cha jajébenguama, pero María cach yebnents̈e tojanoquedá. ");
INSERT INTO kbh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Chora Marta Jesúsbioye tbojaniyana: —Bëngbe Utabná, aca muents̈e macmënëse, ats̈be uafts̈e ndoñe matënjóbana. ");
INSERT INTO kbh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ats̈e së́ntsetats̈ëmbo, masque ndayánaca mora Bëngbe Bëtsá chacojotjañe, y cha lempe chca cmochjáts̈etaye ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Y Jesús tbojanjuá: —Acbe uafts̈e echántayena ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chora Marta tbojaniyana: —Aíñe, ats̈e sëndë́tats̈ëmbo cha yochtayenama, pero quem luare jopochócama te, nÿetsca obanënga mochtayena ora ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","As Jesús tbojaniyana: —Ats̈e sëndmëna chë ents̈anga chámuatayenama y chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama endamá. Nda áts̈beñe tojtsos̈buaché, masque chaóbana, echántayena. ");
INSERT INTO kbh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y nda cabá ainá totsomñe y áts̈beñe tojtsos̈buaché, ndocna te queochatóbana. ¿Chë cbontsatsá soyiñe quecojtsos̈buaché ca? —Jesús tbojantjá. ");
INSERT INTO kbh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Chora Marta tbojaniyana: —Aíñe, Bëngbe Utabná, ats̈e ácbeñe sëntsos̈buaché, aca chë Cristo, chë Bëngbe Bëtsabe Uaquiñá y chë quem luaroye jabamá comnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chca tojánayanents̈ana, Marta tojtaná chabe quenata María jachembuama, y iytëcana tbojaniyana: “Buatëmbayá tonjáshjango y entsebos̈e aca jinÿama ca.” ");
INSERT INTO kbh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María chca tojanuena y cachora tojë́ftsanbocna y tojána Jesús jinÿama. ");
INSERT INTO kbh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús cabá ndoñe chë puebloye tonjánamashëngo; yojétsemna Marta tbojanjébengo luarents̈e. ");
INSERT INTO kbh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Chë yebnents̈e imojtsemna judiënga, María ts̈a ngménaca ndoñe chaondë́tsemnama tjëmbambnayënga, tmojánbocana María juastama; er chë tojëftsantsbaná y tojë́ftsanbocna ora, chë judiënga imojtsejuabnaye, Lázaro yojtsátbontsana luaroye María yojtsaye, choca jos̈achnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesús yojtsemnents̈e María tojánashjango ora, chábents̈e tojanoshaments̈é y tbojaniyana: —Bëngbe Utabná, aca muents̈e macmënëse, ats̈be uafts̈e ndoñe matënjóbana ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María y cháftaca tmojánashjajna judiënga, nÿetscanga imojetsenóbos̈achiye; y Jesús chca tojáninÿe ora, corente tbojancochtsets̈ena y puerte ngménaca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chora Jesús tojanatjá: —¿Ndayents̈e cha s̈mojuatbontsá ca? Y chënga tmojanjuá: —Bëngbe Utabná, mabo y cochjinÿe ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chora Jesús tojánenobos̈achna. ");
INSERT INTO kbh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","As chë judiënga tmojánayana: —¡Minÿënga, ts̈a ibnabobonshana ca! ");
INSERT INTO kbh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero inÿe judiënga imojtsichamo: —Chë jtaná chabuabínÿnama tojamá, ¿tondaye tonjobená jamama, Lázaro ndoñe chaondóbanama ca? ");
INSERT INTO kbh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús, cachiñe puerte cochtsets̈enaná, chë uatbontsánoye tojanobeconá. Chë luarna cuevëshe inamna, y amashjuanents̈e canÿe bëts ndëts̈beca yojtsatámena. ");
INSERT INTO kbh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chora Jesús tojanë́yana: —Chë ndëts̈bé mojuánanga ca. Chora Marta, chë obanabe uabena tbojaniyana: —Bëngbe Utabná, mora ya bacá yojtsonguëts̈é, er ya canta te entsemna cha tontsóbana ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Y Jesús tbojanjuá: —Ndegombre, ya tcbonjauyana, aíñe áts̈beñe tcojtsos̈buáchese, cochjinÿe Bëngbe Bëtsá puerte obená y bëtsá bétsemnama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chora chë ndëts̈bé tmojanjuaná; Jesús celoye yojontjes̈iye y Bëngbe Bëtsábioye tbojaniyana: “Taita, cbatschuá ats̈be opresido tcojouenama. ");
INSERT INTO kbh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ats̈e sëndë́tats̈ëmbo aca sempre s̈condbétseyeunanama; ats̈e chca tcbonjauyana, muents̈e montsemna ents̈angbe ts̈abiama, chca, aca ats̈e s̈cojichmoma, chënga chamotsos̈buáchema ca.” ");
INSERT INTO kbh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chca tojánayanents̈ana, jabuache tojánayana: “¡Lázaro, chents̈ana matsbocna ca!” ");
INSERT INTO kbh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y cachora chë obaná tojtanbocna, cucuats̈ënga y shecuats̈ënga ents̈ë́juaca batsëcná, y chabe jubiá base ents̈ë́juaca uamochëcjuaná. As Jesús tojanë́yana: “Motsejafjoná y jama chaotsobena ca.” ");
INSERT INTO kbh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chë soyëngama, banga chë judiënguents̈ana, María jatjëmbambayama tmojánanga, y nts̈amo Jesús tojanmcá tmojáninÿënga, Jesúsbeñe imojtsos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero inÿe judiënga fariseúngbioye tmojána, nts̈amo Jesús tojanmama chënga jacúntama. ");
INSERT INTO kbh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","As, chë fariseunga y chë bachnangbe amë́ndayënga tmojánenefjna inÿe judiëngbe amëndayë́ngaftaca, y tmojánayana: —¿Ndayá mochjobenaye cháftaca jamama? Quem boyabása bëts soyënga entsama. ");
INSERT INTO kbh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nÿe cachcá chamojonÿase, nÿetsca ents̈anga chábeñe mochantsos̈buáchiye; chë romanëngbe amë́ndayënga mochanjabo y lempe mochantsepochóca, Bëngbe Bëtsabe bëts yebna y bëngbe luare Israel ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero canÿa chënguents̈á, Caifás ca uabainá, chë uata chë bachnangbe más uámana amëndayá inamná, tojanë́yana: —Ts̈ëngaftanga tondaye ques̈mátstats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Y ndoñe ques̈matsjuabná, ts̈ëngaftangbiama más ts̈abá yojtsemna nÿe canÿe boyabása Israeloca ents̈angbiama chaóbana, y ndoñe nÿets bëngbe luare chamotsepochocá ca —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero Caifás chë soye nÿe cachabe juábnaca ndoñe chca tonjánayana. Cha, chë uata chë bachnangbe más uámana amëndayá inámnayeca, Bëngbe Bëtsabe Espíritbe obenánaca tojánayana Jesús ibojamna Israeloca ents̈angbiama jóbanama ca. ");
INSERT INTO kbh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ndoñe nÿe Israeloca ents̈angbiama, sinó chë inÿe luarënguiñe Bëngbe Bëtsabe básenga tmojanáshanënga chamuatábama, as chca, nÿetscanga nÿe canÿe luarents̈a ents̈anga chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chcasna, cach tescana judiëngbe amë́ndayënga tmojanenoyeuná Jesús jóbama. ");
INSERT INTO kbh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chíyeca Jesús ents̈ángbeñe, Judea luariñe ya ndoñe yontsana. Chë luarents̈ana tojë́ftsanbocna y canÿe luaroye tojtsanoñe, ents̈anga ndoyeniñe béconana, canÿe pueblo Efraín ca uabáinoye. Y chents̈e chabe uatsjéndayëngaftaca tojtsanoquedañe. ");
INSERT INTO kbh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judiëngbe Bashco fiestama bats̈á yojtsájamna, y ba ents̈anga pueblënguents̈ana Jerusalenoye imojtsajna, soyënga choca jamama nts̈amo tempo inamncá, chca, Bëngbe Bëtsabe bominÿama ts̈ábenga jtsemnama, chë Bashco fiesta cabá ndobuache ora. ");
INSERT INTO kbh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chocna, judiënga Jesús imojtsenguaye, y Bëngbe Bëtsabe bëts yebnents̈e imojtsentjanaye: “¿Nts̈amo s̈mojtsejuabná, cha tayochjabo o ndoñe quem fiestama ca?” ");
INSERT INTO kbh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Chë fariseunga y chë bachnangbe amë́ndayënga tmojanmandá, nderado nda Jesús ndayents̈e tojtsemnama tojtsetats̈ëmbësna, chaobuambá ca, as Jesús jishachama. ");
INSERT INTO kbh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chnë́nguana te chë Bashco fiestama yojtsájamna ora, Jesús Betania puebloye tojtaná. Lázaro, chë Jesús tbojtanayená cha, choca inoyena. ");
INSERT INTO kbh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chents̈na bëts saná Jesusbiama tmojanábua. Marta tojanëjuats̈é, y Lázaro yojtsemna chë Jesúseftaca juasama mesë́shañe imojtsetbiámanënguents̈e. ");
INSERT INTO kbh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","As María canÿe jarrëtema tojanaca; chiñe yojanaftsuamna canÿe botamana uanguëts̈iye, bëtscá uámaniye, ena nárdoca pormániye. Chë uanguëts̈iye, María, Jesusbe shecuats̈ënguiñe tbojanáshecbues̈cja, y cachabe stjënashaca tbojtanshecbojó. Chora, chë yebnents̈e ena nardiyana yojtsonguëts̈iye. ");
INSERT INTO kbh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chora, canÿa Jesusbe uatsjendayënguents̈á, Judas Iscariote, chë Jesús uayayëngbe cucuats̈iñe yochjanayents̈bashejuaná, tojánayana: ");
INSERT INTO kbh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Quem botamana uanguëts̈iye unga patse denario crocénana enduámana. ¿Ndáyeca ndoñe s̈monjuiye y ndbomnëjémënga chë crocénana mas̈mëntsats̈atá ca? ");
INSERT INTO kbh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judas chca tojánayana, chë ndbomnëjémëngbeñe ntsejuabnaycá, sinó cha atbëbaná inamna causa. Judas chëngbe crocénana shecnës̈iñe yojánatbëna, y ba soye, chë shecnës̈oye imojanatsuáma crocenánents̈ana cha yojánatbëbana. ");
INSERT INTO kbh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","As Jesús tbojanjuá: —Cachcá monÿá. María më́ntscoñe chë botamana uanguëts̈iye iuabofjájona, cha jobenayama áts̈beñe jabués̈cjama, er ndoñe bën y ats̈e s̈mochanjaitëme. ");
INSERT INTO kbh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Chë ndbomnëjémëngna ts̈ëngaftangbeñe sempre mochanjesomñe, pero ats̈e ndoñe ca —tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ba judiënga tmojántats̈ëmbona Jesús Betanioca yojtsemnama, y choye tmojána, ndoñe nÿe Jesús jinÿama, sinó Lázarnaca, chë Jesús tbojtanayená cha. ");
INSERT INTO kbh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","As chë bachnangbe amë́ndayënga tmojanenoyeuná Lázarnaca jóbama. ");
INSERT INTO kbh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chabe causa, ba judiënga chë́ngbioye cachcá tmojesanë́nÿa y Jesúsbeñe imojtsos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chë yëfsana, mallajta ents̈anga, Jerusalenoca fiestama tmojánashjajnënga, tmojántats̈ëmbona Jesús choye yochjánashjanguama. ");
INSERT INTO kbh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","As chëngna palma betiye buacuafjënga tmojanatë́tsets̈e, y Jesús jajébenguama tmojánbocana, y mënts̈á imojtsáyebuache: “¡Bëngbe Bëtsá matschuanga! ¡Corente bendición bomná chë Bëngbe Utabnabe obenánaca tojabá! ¡Corente bendición bomná chë Israeloquëngbe Rey ca!” ");
INSERT INTO kbh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús canÿe burrotema tbojáninÿena y chábeñe tojanenojayé. Nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe iuayancá, cachcá tojanopasá. Chiñe mënts̈á endayana Jerusalenoca ents̈angbiama: ");
INSERT INTO kbh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sión bëts puebloca oyenënga, ndoñe matauatjëngana. Minÿënga, ts̈ëngaftangbe Rey burrotémiñe enjaquená entsabó ca. ");
INSERT INTO kbh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chca orna, Jesusbe uatsjéndayënga chë soyëngama ndoñe tonjanësertá; pero chents̈ana, Jesús corente bëtsá yomnama Bëngbe Bëtsá tojaninÿanÿé ora, chë uatsjéndayënga chama tmojanenojuabó, lempe nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe iuayancá y cachcá Jesúseftaca tojanopasama. ");
INSERT INTO kbh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Chë Jesúseftaca imojtsemna ents̈anga, Lázarbioye uatbontsánoye tbojanchembo ora y chents̈ana tbojtanayená ora, nts̈amo tmojáninÿama chora imojtsecuéntaye. ");
INSERT INTO kbh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chíyeca, ba ents̈anga tmojánbocana Jesús jajébenguama, chë bëts soye Bëngbe Bëtsabe obenánaca cha tojanmama tmojanuénayeca. ");
INSERT INTO kbh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero chë fariseunga imojtsenatsëtsnaye: “Ts̈ëngaftanga s̈montsonÿá bënga tondaye jamama quemuátobenama y más, ¡nÿetscanga cha montsë́stona ca!” ");
INSERT INTO kbh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bashco fiestama, chë Bëngbe Bëtsá jadórama Jerusalenoye tmojánangbeñe, básefta griego ents̈ángnaca imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chëngna, Felipe chë Galilea luarocá, chë Betsaida pueblocábioye, tmojanobeconá y tmojanimpadá: “Señor, bënga fsë́ntsebos̈e Jesús jinÿama ca.” ");
INSERT INTO kbh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chora Felipe tojána Andrés jauyanama, y chë útatna Jesúsbioye tbojána, chë grieguëngbiama jauenayama. ");
INSERT INTO kbh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús chata tojanë́yana: “Chë Bëngbe Bëtsá Ents̈á tbojanbemá corente bëtsá yomnama jinÿanÿiyama te ya tocjobuache. ");
INSERT INTO kbh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ndegombre s̈cuayana: Canÿe trigo jénaye ndoñe fshantsiñe tmonjuatbontsá y ndoñe tonjóbanëse, nÿe cach canÿe trigo jénaye jesomñana. Pero tmojuatbontsá y tojóbanase, bëtscá jashájonana. ");
INSERT INTO kbh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Cachcá, nda nÿe cachá tojtsenóbobonshana, cha chabe vida echanjëftsobuets̈e. Pero nda nÿe cachá ndoñe tontsenóbobonshana y nts̈amo ats̈e stsemandacá, quem luariñe vida tojtsebomnëntscuana cha tojtsamëse, chë nÿetsca tescama yomna ts̈abe vida echántsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nda nts̈amo stsemandacá jamama tojtsebos̈e, ats̈e chas̈otsë́stona. Chca, ndayents̈e ats̈e chaitsemna, chánaca, chë ats̈e oservená, chents̈e chaotsemna. Ats̈e s̈ojtseservénabiama, ats̈be Taitá Bëngbe Bëtsá echanjínÿanÿiye bëtsá yomnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Y más Jesús tojánayana: “¡Mora ts̈a cochtsets̈enaná së́ntsemna! ¿Ats̈e chjayana: ‘Taita, chë áts̈eftaca echanjopása soyënga s̈motsebojuaná ca?’ Ndoñe; er más chama ats̈e quem luaroye tijabo. ");
INSERT INTO kbh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taita, s̈minÿanÿé aca puerte bëtsá y obená comnama ca.” Y cachora, celocana canÿe oyebuambnayana tojanóbocna mënts̈á: “Ya tcbonjinÿanÿé ats̈e puerte bëtsá y obená tsmënama, y mora cachiñe cachcá chanjama ca.” ");
INSERT INTO kbh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ents̈anga chca tmojanuena ora, ínÿenga imojtsichamo nÿe tojanjuésase ca; pero ínÿengna imojtsichamo: —Canÿe ángel chábioye tbonjuatsëtsá ca. ");
INSERT INTO kbh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Chora Jesús tojanë́yana: —Nts̈amo s̈monjouencá, ats̈biama ndoñe quenátsmëna, sinó ts̈ëngaftangbiama. ");
INSERT INTO kbh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mora chë tempo entsemna, chë quem luare ents̈anga tmojë́ftsema bacna soyënga jinÿanÿiyama y chëngbe castiguama jayanama. Y mora, chë nÿetsca bacna soyënga mandayá, quem luarents̈ana mochantábocna. ");
INSERT INTO kbh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero ats̈e fshantsocana atsbananá chaitsemna ora, nÿetsca ents̈anga áts̈bioye chanjúbuaja ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chca cha yojtsichamo, ana jinÿanÿiyama nts̈amo jóbanama ibojamnama. ");
INSERT INTO kbh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chora chë ents̈anga tmojanjuá: —Bëngbe Bëtsabe uabemana palabrënguiñe endayana, y chíyeca bënga fsëndë́tats̈ëmbo chë Cristo nÿetsca tescama vida yochtsebomna ca. As, ¿ndáyeca cojtsichamo, Bëngbe Bëtsá Ents̈á tbojanbemá chamuatsbanama yojtsemna ca? ¿Nda yojtsemna Bëngbe Bëtsá Ents̈á tbojanbemá ca? —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Y Jesús tojanë́yana: —Nÿe baseftatescama chë ents̈angbe juabnënga binÿnayá ts̈ëngaftangbeñe entsemna. Chë binÿnayá cabá ts̈ëngaftangbeñe yojtsemnëntscuana, cháftaca s̈mochtsajna. Chca, mo ibetiñcá ndoñe ques̈mochátajna. Nda ndoñe binÿniñe tojtsana, cha ndoñe ntsetats̈ëmbuana ndëmuajana yojtsana. ");
INSERT INTO kbh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chë binÿnayá cabá ts̈ëngaftangaftaca endétsemnëntscuana, chábeñe s̈mochtsos̈buáchiye; as, ts̈ëngaftangbe juabnënga binÿniñe echántsemna ca —Jesús tojánayana. Chë soyënga tojánayanents̈ana, Jesús tojtsanoñe y ents̈angbiama yojetsóitana. ");
INSERT INTO kbh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masque Jesús, judiëngbe delante ba bëts soyënga Bëngbe Bëtsabe obenánaca tojë́ftsema, chënga ndoñe chábeñe ntsos̈buáchiyana, ");
INSERT INTO kbh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","nts̈amo Bëngbe Bëtsabe juabna oyebuambnayá Isaías tojanabemcá, cachcá chaotsemnama. Isaías mënts̈á tojánayana: Bëngbe Utabná, ¿nda bëngbe buayenana soyiñe yojtsos̈buaché? Y ¿nda tbojosertá, acbe obenana tcojinÿinÿé ora ca? ");
INSERT INTO kbh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chíyeca chënga ndoñe montsobena Jesúsbeñe jtsos̈buáchiyama, er Isaías mënts̈ánaca tojë́ftsanabema: ");
INSERT INTO kbh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bëngbe Bëtsá tojama chënga chabe soyëngama ndoñe botamana chamondëtsejuabnama y chabe soyënga ainaniñe ndoñe chamondóyëngacñama, as ndoñe chaondëtsësertánama ca. Y Bëngbe Bëtsá entsichamo: “Chca entsemna, chënga ats̈be benache ndoñe chamondishachama, y ats̈e ndoñe ntjátsebacama; y chca, chënga mochántsemna mo ndëshnana ents̈angcá ca.” ");
INSERT INTO kbh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías chca tojánayana, er tojáninÿe Jesús puerte bëtsá y obená yojamnama, y chca chë uabemaniñe Jesusbiama yojanoyebuambná. ");
INSERT INTO kbh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero masque chca iuábemanëse, ba judiënga imojtsanos̈buaché, y banga judiëngbe amëndayë́ngnaca Jesúsbeñe imojtsanos̈buaché. Pero chëngna, Jesúsbeñe imojtsos̈buáchema ents̈ángbeñe ndoñe montsichamo. Chca imojánama chë fariseungbiama auatja causa, chë judiëngbe enefjuana yebnënguents̈ana ndoñe chamondëtëbuacnama. ");
INSERT INTO kbh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chëngbiama más yojanámana, ents̈anga chëngbiama chamotsichamo ts̈a uámanënga imojamna ca, y ndoñe, Bëngbe Bëtsá chca chaotsamama. ");
INSERT INTO kbh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Chora Jesús mënts̈á jabuache tojánayana: “Nda áts̈beñe tojtsos̈buaché, ndoñe nÿe áts̈beñe ntsos̈buáchiyana; chë nda s̈ojichmó chábeñnaca cha jtsos̈buáchiyana. ");
INSERT INTO kbh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cachca, nda ats̈e s̈ojtsonÿá, chë s̈ojichmó chábioynaca cha jtsonÿayana. ");
INSERT INTO kbh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ats̈e quem luaroye tijabo ents̈angbe juabnënga jabobínÿnama, chca, nda áts̈beñe tojtsos̈buaché, mo ibetiñcá ndoñe chaondë́tsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero nda ats̈be soyëngama tojouena, pero nts̈amo sëntsichamcá ndoñe tontsama, ats̈e chabiama ndocá quichátayana ts̈abá o ndoñe ts̈abá tonjama ca. Ats̈e ndoñe chiyátabo, nts̈amo quem luarents̈a ents̈anga tmojamama ts̈abá o ndoñe ts̈abá yontsemna ca jatichámuama; quem luaroye sënjabo ndayá chënga jabátsebacama. ");
INSERT INTO kbh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nda ats̈e s̈ojtsaboté y ats̈be palabrëngama ndoñe s̈onjoyeuná, ya entsebomna nda chabiama yochjayana bëts castigo jtsebomnama ibojtsemna ca. Ats̈e tijanoyebuambá palabrë́ngaca, quem luare jopochócama te chabiama chca echántsayana. ");
INSERT INTO kbh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Er ats̈e ndoñe nÿe ats̈be juábnaca quetsatoyebuambná. Chë Taitá, chë s̈onjichmó cha, s̈onjamandá nts̈amo jayanana y ndayá jabuátambana. ");
INSERT INTO kbh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ats̈e sëndë́tats̈ëmbo, ats̈be Taitá tojamandá orna, cha jamándana ents̈anga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama. Chíyeca, ndayá sëntsichamcá, endmëna nts̈amo ats̈be Taitá Bëngbe Bëtsá s̈ojamandacá ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bashco fiesta cabá ndobuache ora, Jesús yojtsetáts̈ëmbo chabe tempo tojanóshjanguama, quem luarents̈ana jëftsebocnama y chabe Taitábioye jtama. Nts̈amo Jesús chábenga yojanababuanÿeshancá, chë quem luare imojamnënga, chórnaca yojtsebos̈e chë bëts bonshánana puerte más jinÿanÿiyana. ");
INSERT INTO kbh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pero Satanás, Júdasbe ainaniñe bacna juabnënga tojanjajó, uayayëngbe cucuats̈iñe Jesús jayents̈báshejuanama. Judas Iscariote, Simonbe uaquiñá. ");
INSERT INTO kbh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús yojtsetáts̈ëmbo chabe Taitá Bëngbe Bëtsá nÿets obenana tbojánats̈etama. Cachcá, Jesús yojtsetáts̈ëmbo, Bëngbe Bëtsábiocana cha tojánabama y cachábioye jtama ibojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chcasna, chë ibeta jasama tmojanpochocá ora, mesë́shents̈ana tojantsbaná, chabe juatsboye uichëtjoníya tojanenátsejca y canÿe tuallë́jua tojanenasná. ");
INSERT INTO kbh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Chents̈ana, canÿe baches̈iñe búyeshe tojanbues̈cja y tojanonts̈é chabe uatsjéndayënga jushecjabebiyana y jtë́shecbojuana cha yojtsasnana tuallë́juaca. ");
INSERT INTO kbh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pero, Simón Pedro tbojanobuache ora, Jesúsbioye tbojaniyana: —Ats̈be Utabná, ¿aca s̈cochjuashecjabiá ca? ");
INSERT INTO kbh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chora Jesús tbojanjuá: —Ats̈e së́ntsama soye mora ndoñe quecmátësertana; pero más chcoye aíñe cmochanjosérta ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","As Pedro tbojaniyana: —¡Ndocna te s̈catjuashecjabiá ca! Pero Jesús tbojaniyana: —Ndoñe chacbonjuáshecjabese, ats̈bia ndoñe quecochátsmëna ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Y Simón Pedro tbojaniyana: —¡Ats̈be Utabná, as nÿe ats̈be shecuats̈ënga ndoñe, ndayá ats̈be cucuats̈ënga y bests̈ás̈naca ca! ");
INSERT INTO kbh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Jesús tbojanjuá: —Nda bebená tojtsemna, nÿe shecuats̈e jtsashecjabiama jtsajabótana, ndoñe nÿets̈á cachiñe. Nda tojtsobebé, ndoñe tsengá ntsemnana. Cachcá, mo bebénënga cuenta ts̈ëngaftanga s̈montsemna; pero canÿa muents̈e entsemna, y cha mo bebenacá ndoñe quenátsmëna. ");
INSERT INTO kbh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús yojtsetáts̈ëmbo nda chë uayayëngbe cucuats̈iñe boshjuaná yochtsanmënama, chíyeca tojánayana: “Ts̈ëngaftanguents̈á canÿa entsemna, cha mo bebenacá ndoñe quenátsmëna ca”. ");
INSERT INTO kbh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jushecjabebiyama tojanpochocá ora, chabe juatsboye uichëtjoníya tojtaníchëtjo, y mesë́shents̈e tojtanótbema. Chora tojanë́yana: —¿Chë tcbonjábiama soyama quecmojtsë́sertana ca? ");
INSERT INTO kbh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ts̈ëngaftanga ats̈e s̈mondbauyana Buatëmbayá y Bëngbe Utabná ca; ts̈abá chca s̈montsichamo, er ats̈e ndegombre chca sëndmëna. ");
INSERT INTO kbh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ats̈e, ts̈ëngaftangbe Buatëmbayá y Utabná, tcbonjushecjabebé; chcasna, ts̈ëngaftángnaca cmontsamna jenáshecjabebiyana. ");
INSERT INTO kbh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nts̈amo quem sóyeca tcbonjanÿanÿecá, ts̈ëngaftanga cachcá s̈mochtsama. ");
INSERT INTO kbh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ndegombre s̈cuayana, chë oservená chabe nduiñbiama ndoñe más uamaná ntsemnana. Cachcá, chë ichmoná chë tbojichmobiama ndoñe más uamaná quenátsmëna. ");
INSERT INTO kbh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Quem soyënga chas̈mojuatsjinÿe y chca chas̈mojamëse, ts̈ëngaftanga puerte oyejuayënga vida s̈mochanjë́ftsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ats̈e sëndë́tats̈ëmbo chë tijábacacangbiama, chíyeca ats̈e nÿetscangbiama ndoñe chca quetsatoyebuambná. Y nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá cachcá chaotsemnama, chë ‘canÿa áts̈eftaca tandës̈e tonjasá, ats̈be contra echántsemna ca’, cachcá echanjopása. ");
INSERT INTO kbh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mora, cabá ndoñe chca tonjopasá ora, lempe chë soyënga së́ntsichamo. As, chca chaojopasá ora, áts̈beñe s̈mochantsos̈buáchiye, y as s̈mochántsetats̈ëmbo ats̈e tsmëna chë nda sëndmëná. ");
INSERT INTO kbh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ndegombre s̈cuayana: Nda ats̈e tijichmóbioye tbojofja, cha ats̈e s̈ochanjofja; y nda ats̈e s̈ojofja, cha chë nda s̈ojichmóbioye bochanjofja ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chë soyënga tojánayanents̈ana, Jesús corente cochtsets̈enaná yojtsemna, y tojánayana: —Ndegombre s̈cuayana, canÿa ts̈ëngaftanguents̈á uayayëngbe cucuats̈iñe s̈ochanjáboshjona ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chora, chabe uatsjéndayënga tmojanonts̈é enonÿinÿnayana, y ndoñe montsetáts̈ëmbo ndabiama Jesús chca tojánayanama. ");
INSERT INTO kbh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Canÿe uatsjendayá, chë Jesús puerte ibnabobonshaná, Jesusbe juachaca inatbemana. ");
INSERT INTO kbh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","As, Simón Pedro chábioye tbojánefjats̈ëmbo, ndabiama Jesús chca tojánayanama Jesúsbioye chabotjama. ");
INSERT INTO kbh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chë puerte bonshana uatsjendayá, Jesúsbioye bats̈atema más tojanosjoná y tbojantjá: —Bëngbe Utabná, ¿nda cha yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chora Jesús tbojanjuá: —Ats̈e canÿe base tandëtema chanjafchécuacuaye y ndábioye chajoyé, cha entsemna ca. As Jesús canÿe base tandëtema tojanfchecuacuá, y Judas, Simón Iscariotbe uaquiñábioye, tbojanoyé. ");
INSERT INTO kbh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tandës̈e tojanóyëngacñe y cach ora, Satanás Júdasbe ainaniñe bacna juabnënga tbojáncochëngo. As Jesús tbojaniyana: “Chë cochanjama soye, cam ora moma ca.” ");
INSERT INTO kbh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero ni canÿa chë jasama imojtsetbiamanënguents̈á tbojanësertá, ndayama Júdasbioye chca tbojaniyanama. ");
INSERT INTO kbh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas inamna chëngbe crocénana shecnës̈iñe uambayá; chíyeca ínÿenga tmojanjuabó Jesús chca ibojtsatsaye, ana ndayá yojtseita soye chë fiestama chauabuámiyama, o ndbomnëjémënga ndayánaca chauats̈atama ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Júdasna chë base tandëtema tojanóyëngacñe, y cachora chents̈ana tojë́ftsanbocna. Chora ya ibeta yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas tojë́ftsanbocnents̈ana, Jesús tojánayana: —Ora tocjobuache, Bëngbe Bëtsá Ents̈á tbojanbemá corente bëtsá y obená yomnama jinÿanÿiyama; y mua echanjínÿanÿiye Bëngbe Bëtsá corente bëtsá y obená yomnama. ");
INSERT INTO kbh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Cha echanjínÿanÿiye Bëngbe Bëtsá chca yomnama, chíyeca Bëngbe Bëtsánaca echanjínÿanÿiye corente bëtsá y obená yomnama, y mora entsemna chë ndaye ora Bëngbe Bëtsá chca chabiama yochjínÿanÿiye. ");
INSERT INTO kbh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ats̈be básenga, baseftatescama ts̈ëngaftangaftaca së́ntsemna. Chora s̈mochántsenguaye, pero nts̈amo judiënga sënjauyancá, mora cachcá ts̈ëngaftanga cbë́yana: Chë chanjá luaroye, ts̈ëngaftanga ndoñe ques̈mátobena jama ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Canÿe tsëm soye cbetsamëndá: Nÿetscanga s̈mochtsenbobonshana. Nts̈amo ats̈e ts̈ëngaftanga cbondábabuanÿeshana, cachcá ts̈ëngaftanga s̈mochtsenbobonshana. ");
INSERT INTO kbh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ts̈ëngaftanga s̈mojtsenbobonshánëse, nÿetsca ents̈anga mochántsetats̈ëmbo, ts̈ëngaftanga ats̈be uatsjéndayënga s̈momnama ca —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chora Simón Pedro tbonjantjá: —Bëngbe Utabná, ¿ndë́moye cochjá ca? As Jesús tbojanjuá: —Ats̈e sëntsá luaroye, mora aca ndoñe quecátobena ats̈e juastana, pero más chcoye aíñe s̈cochanjuasto ca. ");
INSERT INTO kbh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","As Pedro tbojaniyana: —Ats̈be Utabná, ¿ndáyeca ndoñe sëntsobena mora aca juastama? ¡Ats̈e së́ntseprontana acbiama jóbanama ca! ");
INSERT INTO kbh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chora Jesús tbojaniyana: —¿Ndegombre cojtseprontana ats̈biama jóbanama? Ndegombre cbëyana, cabá ngallo ndëcánta ora, aca unga soye ats̈biama cochanjayana: “Cha ndoñe quetsatabuatma ca”. ");
INSERT INTO kbh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mënts̈ánaca Jesús tojánayana: —Ndoñe ainana tsets̈anënga matsmënana. Ts̈ëngaftanga Bëngbe Bëtsábeñe s̈mondos̈buaché; áts̈beñnaca s̈mochtsos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ats̈be Taitá Bëngbe Bëtsá endmënoca, ba luarënga joyénanama endmëna. Ndoñe chca tontsemnëse, ats̈e chca matcbënjáuyana. Morna, cha endmënoye ats̈e chanjá ts̈ëngaftangbiama canÿe luare joyénanama jabuáprontama. ");
INSERT INTO kbh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ats̈e chaijá y chë luare chacbojabuaprontá ora, cachiñe moye chanjésabo, ts̈ëngaftanga áts̈eftaca junatsama. As, ats̈e chaitsemnoye, ts̈ëngaftángnaca chas̈motsá joyénanama. ");
INSERT INTO kbh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ats̈e chanjá choye nts̈amo jama y jashjanguama ya s̈montsetáts̈ëmbo ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chora Tomás Jesúsbioye tbojaniyana: —Bëngbe Utabná, ndë́moye cochjama ndoñe queftsátstats̈ëmbo. As, ¿nts̈amo bënga fchtsetáts̈ëmbo nts̈amo choye jama ca? ");
INSERT INTO kbh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chca tbojaniyana ora, Jesús tbojanjuá: —Ats̈e sëndmëna benachcá; chëjana tcojtsase, pronto jashjanguana. Ats̈e sëndmëna nts̈amo ndegombre yomncá sempre oyebuambnayá, y ents̈anga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama endamá. Nÿe áts̈beyeca endopodena ndayëjana jama, y ats̈be Taitá Bëngbe Bëtsábioca jashjanguama. ");
INSERT INTO kbh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ts̈ëngaftanga ats̈e s̈mojtsábuatmëse, ats̈be Taitánaca s̈mattsábuatma. Morscana ya cha s̈montsábuatma y cha s̈montsonÿá ca —tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pero Felipe tbojaniyana: —Ats̈be Utabná, nÿe chë Taitá s̈manÿanÿé, ndayama más ca. ");
INSERT INTO kbh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chora Jesús tbojaniyana: —Chëfta te ts̈ëngaftangaftaca së́ntsemna, y ¿cabá ndoñe ats̈e s̈contsábuatma, Felipe? Nda ats̈e s̈ojinÿe, chë Taitá Bëngbe Bëtsábioynaca jinÿana. As, ¿nts̈amo ats̈e s̈cojtsatsá, chë Taitá s̈manÿanÿé ca? ");
INSERT INTO kbh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ndoñe condos̈buaché, ats̈be Taitá áts̈beñe y áts̈naca chábeñe nÿe canÿacá ftsmënama? Chë cbontsëtsëtsná soyënga, ndoñe nÿe ats̈be juábnaca chca quetsatoyebuambná. Ats̈be Taitá, chë áts̈beñe vida endbomná jtsamana lempe nts̈amo stsamcá. ");
INSERT INTO kbh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Muiñe s̈mochtsos̈buáchiye: Ats̈be Taitá áts̈beñe endmëna, y áts̈naca chábeñe mo nÿe canÿacá sëndmëna. Chama ndoñe s̈montsos̈buachese, as nÿe chë tijama soyëngámnaca áts̈beñe s̈mochtsos̈buáchiye. ");
INSERT INTO kbh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ndegombre s̈cuayana, nda áts̈beñe tojtsos̈buaché, nts̈amo ats̈e tijamcá y cachcá cha echántsama. Ats̈be Taitá entsemnoye ats̈e chanjá, chíyeca, chë áts̈beñe os̈buachiyá, chama más bëts soyënga echanjama. ");
INSERT INTO kbh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ts̈ëngaftanga ndaye sóynaca Bëngbe Bëtsábioye s̈mojotjañe, y chca s̈mojama ats̈e jóts̈ëmbonëse, áts̈beñe s̈mos̈buachéyeca, lempe s̈mochanjóyëngacñe; chca, chë Uaquiñá echanjínÿanÿiye chë Taitá corente bëtsá y obená yomnama. ");
INSERT INTO kbh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ts̈ëngaftanga ndaye sóynaca ats̈e s̈mojotjañe, y chca s̈mojama ats̈e jóts̈ëmbonëse, áts̈beñe s̈mos̈buachéyeca, ats̈e chë soye chanjama ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mënts̈ánaca Jesús tojánayana: “Ts̈ëngaftanga ats̈e s̈mojtsebobonshánëse, nts̈amo cbontsamëndacá cachcá s̈mochanjama. ");
INSERT INTO kbh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chca chas̈mojamëse, ats̈be Taitá Bëngbe Bëtsá ts̈ëngaftangbiama chanjaimpáda, ts̈ëngaftanga jabújabuachama y jabáñemuayama inÿa cha chabuichmoma, chë Uajabuachaná nÿetsca tescama ts̈ëngaftangaftaca chauétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cha, chë Uámana Espíritu endmëna chë nÿetsca soyënguiñe nts̈amo ndegombre yomncá oyebuambnayá. Chë nÿe quem luarama enójuabnaye ents̈anga, chë áts̈beñe ndos̈buáchiyënga ndoñe quematonÿá, ni quematábuatma. Chíyeca chënga ndoñe quemátobena cha jóyëngacñana. Pero ts̈ëngaftanga aíñe cha s̈montsábuatma. Cha ts̈ëngaftangaftaca entsemna, y ts̈ëngaftangbe ainaniñe sempre echanjëftsiyena. ");
INSERT INTO kbh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ats̈e ndoñe quecbocháisabashejuana, mo uajchonga cuenta chas̈motsemnama. Ts̈ëngaftangbioye chanjésabo. ");
INSERT INTO kbh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Muents̈ana baseftaytese, chë nÿe quem luarama enójuabnaye ents̈anga ndoñe más ques̈mochátonÿaye; pero ts̈ëngaftangna aíñe, ats̈e cachiñe s̈mochántinÿe. Ats̈e ainá chántsemna, chíyeca ts̈ëngaftanga áts̈eftaca ts̈abe vida s̈mochántsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chë Uámana Espíritu ts̈ëngaftangbe ainaniñe chas̈mojóyëngacñe ora, ts̈ëngaftanga s̈mochántsetats̈ëmbo, ats̈e ats̈be Taitábeñe nÿe canÿacá tsmënama; cachcá, ts̈ëngaftanga s̈mochántsetats̈ëmbo, ts̈ëngaftanga áts̈eftaca cachcá nÿe canÿacá s̈momnama y áts̈naca ts̈ëngaftangaftaca. ");
INSERT INTO kbh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nda totáts̈ëmbo nts̈amo ats̈e tijamandacá y sempre chca tojtsama, cha ndegombre s̈ojtsebobonshana. Nda áts̈bioye s̈ojtsebobonshana, chábioye ats̈be Taitánaca bochántsebobonshana. Ats̈naca cha chántsebobonshana, y nda ats̈e tsmënama cha chanjinÿinÿiye ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chora, inÿe Judas, ndoñe Judas chë Iscariote, Jesúsbioye tbojaniyana: —Bëngbe Utabná, ¿nts̈amo chca yojtsemna, nÿe bënga s̈cochjínÿanÿiye nts̈amo cach aca comnama, y nÿetsca quem luarents̈ë́ngbioye ndoñe ca? ");
INSERT INTO kbh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chora Jesús tbojanjuá: —Nda ats̈e s̈ojtsebobonshana, nts̈amo ats̈e sëntsoyebuambnacá echanjama. Ats̈be Taitánaca chábioye bochántsebobonshana, y bëndata chábioye fchanjabo y chábeñe vida fchantsebomna. ");
INSERT INTO kbh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nda ndoñe s̈ontsebobonshana, ndoñe queochátama nts̈amo sëntsoyebuambnacá. Nts̈amo sëntsoyebuambnacá ndoñe nÿe ats̈be juábnaca quenátsmëna, sinó chë Taitá, chë s̈onjichmó chabe juábnaca. ");
INSERT INTO kbh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ats̈e cabá ts̈ëngaftangaftaca së́ntsemnëntscuana, lempe quem soyëngama sëntsoyebuambná. ");
INSERT INTO kbh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Chë Uajabuachaná, chë Uámana Espíritu, ats̈be impadanánaca ats̈be Taitá bochanjíchmua. Cha lempe cmochántsabuatambaye, y echanjama nÿetsca chë tcbonjáuyana soyëngama chas̈muatenójuaboma. ");
INSERT INTO kbh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Chë ats̈be ainaniñe puerte ts̈abe ebionana ts̈ëngaftangbiama s̈cuétseboshjona, cbetsats̈atá. Chë nÿe quem luarama enójuabnaye ents̈anga cmondbétsats̈atnaye soyëngcá ndoñe quenátsmëna, chë ats̈e cbontsats̈atná ainaniñe puerte ts̈abe ebionana. Ainana tsets̈anënga ndoñe matsmënana, ni matauatjëngana. ");
INSERT INTO kbh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya s̈monjouena nts̈amo tcbonjauyancá: ‘chanjá y ts̈ëngaftangbioye chanjésabo’. Ts̈ëngaftanga ats̈e s̈mojtsebobonshánëse, s̈mattsóyejuaye ats̈e chë Taitábioye jama s̈ojtsemnama, er chë Taitá ats̈biama más bëtsá endmëna. ");
INSERT INTO kbh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Quem soyënga tcbonjáuyana, cabá ndoñe chca tonjopasá ora; as, chca chaojopasá ora, chiñe jenójuaboyëse áts̈beñe chas̈motsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Chë quem luarents̈a bacna soyënga mandayá endabó; chíyeca ats̈e ya ndoñe bëtscá ts̈ëngaftangaftaca quichaisóyebuambaye. Pero cha tondaye quenátobena ats̈e jabórlana. ");
INSERT INTO kbh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Masque cha chca endmëna, chca entsemna, ats̈e chë Taitábioye tsbobonshánama quem luarents̈a ents̈anga chamotsetats̈ëmbuama. Nts̈amo ats̈be Taitá s̈ojamandacá, ats̈e cachcá tsámama chamotsetats̈ëmbuama. “Motsbananga. Muents̈ana cuajna ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mënts̈ánaca Jesús tojánayana: “Ats̈e sëndmëna mo chë ts̈abe uvas betiycá, y ats̈be Taitá Bëngbe Bëtsá chë ts̈abe uvas betiye inÿenacá. ");
INSERT INTO kbh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Chë inÿená, chë uvas betiyents̈a buacuafjënga ndëshajuanëfjënga jtsebuácuetëtsets̈ana; pero chë uvas betiyents̈a buacuafjënga shajuanëfjënga jtsobolímpiana, bëtscá chaotseshájuanama. Nda ndoñe tontsama nts̈amo Bëngbe Bëtsá tojtsebos̈cá, jtsemnana mo chë ndëshajuana buacuafjëngcá; y chë causa, chë Taitá chábioye corente bochantsecastíga. ");
INSERT INTO kbh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ts̈ëngaftanga s̈monjouena nts̈amo tijayancá; bëtscá chca s̈montsama. Chíyeca mora ts̈ëngaftanga s̈montsemna mo chë limpiana y shajuana buacuafjëngcá. ");
INSERT INTO kbh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ats̈eftaca cánÿiñe mo canÿacá s̈mochtsemna y ats̈e ts̈ëngaftangaftácnaca. Chë buacuafja uvas betiyents̈ana juanánëfja ndoñe ntsobenana nÿe cachabe ponto jashájonana. Cachcá, ts̈ëngaftanga áts̈eftaca ndoñe cánÿiñe mo canÿacá s̈montsemnëse, ndoñe s̈mattsobena Bëngbe Bëtsabiama bëtscá soyënga jamama. ");
INSERT INTO kbh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ats̈e chë ts̈abe uvas betiycá sëndmëna y ts̈ëngaftanga chë buacuafjëngcá. Nda áts̈eftaca cánÿiñe mo canÿacá tojtsemna y ats̈e cháftacnaca, cha Bëngbe Bëtsabiama bëtscá soyënga echanjama, mo canÿe buacuafja becá tojtseshajuancá. Er, ts̈ëngaftanga ats̈be uajabuáchenana ndoñe s̈montsebomnëse, áts̈eftaca cánÿiñe mo canÿacá ndoñe s̈montsemna causa, tondaye s̈mattsobena jamama. ");
INSERT INTO kbh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Canÿa áts̈eftaca cánÿiñe mo canÿacá ndoñe tontsemnëse, cha jtsemnana mo canÿe buacuetë́ts̈ena buacuafja, uts̈enëfja y buashánëfjcá. Chca buacuafjënga, ents̈anga jtsatbanana, íñeshoye jtsëts̈enana y chents̈e jtsejuinÿiyana. Cachcá, nda ndoñe áts̈eftaca cánÿiñe mo canÿacá tontsemna, ndoservená jtsemnana y luaroca cha mochantsesegóra. ");
INSERT INTO kbh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Ts̈ëngaftanga áts̈eftaca cánÿiñe mo canÿacá s̈mojtsemna y nts̈amo ats̈e tijayancá s̈mojtsamëse, lempe nts̈amo s̈mojtsebos̈cá s̈mochjotjañe, y lempe s̈mochanjóyëngacñe. ");
INSERT INTO kbh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chë shajuana buacuafjëngcá ts̈ëngaftanga chas̈mojtsemna ora, s̈mochanjínÿanÿiye ats̈be Taitá corente bëtsá y obená yomnama. Y chca, ts̈ëngaftanga ats̈be ndegombre uatsjéndayënga s̈mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nts̈amo chë Taitá s̈ondbobonshancá, áts̈naca cachcá ts̈ëngaftanga cbondábabuanÿeshana. Chíyeca, s̈mochtsiyena ats̈be bonshánama jtsejuabnayëse. ");
INSERT INTO kbh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ats̈e sëndama nts̈amo ats̈be Taitá s̈ondëmandacá. Chíyeca ats̈e sëndoyena chabe bonshánama jtsejuabnayëse. Cachcá ts̈ëngaftángnaca, nts̈amo ats̈e cbontsamëndacá s̈mojtsamëse, ats̈be bonshánama jtsejuabnayëse s̈mochantsiyena. ");
INSERT INTO kbh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ats̈e chca cbontsëtsëtsná, chë ats̈e së́ntsebomna oyejuayana ts̈ëngaftángnaca chas̈motsebomnama, y ts̈ëngaftanga puerte chas̈motsóyejuama. ");
INSERT INTO kbh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mënts̈á cbetsamëndá: Nts̈amo ats̈e cbondababuanÿeshancá, cachcá s̈mochtsenbobonshana. ");
INSERT INTO kbh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Chë chabe amiguëngbiama tojóbanabiama, ndocna quenátobena chabiama más bonshánana jtsebomnana. ");
INSERT INTO kbh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nts̈amo ats̈e tijamandacá ts̈ëngaftanga s̈mojtsamëse, ats̈be amiguënga s̈mochántsemna. ");
INSERT INTO kbh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Chë oservená ndoñe ntsetats̈ëmbuana ndayá chabe nduiño tojtsamama. Chíyeca ats̈e ts̈ëngaftanga oservénënga ca ndoñe quecbatëtsëtsná. Morscana mënts̈á cbontsëtsëtsná: ‘Ts̈ëngaftangna ats̈be amiguënga s̈montsemna ca’, er lempe nts̈amo ats̈be Taitábents̈ana tijuatsjinÿcá, ts̈ëngaftanga tcbonjinÿanÿé. ");
INSERT INTO kbh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ts̈ëngaftanga ndoñe ats̈e ches̈matábuayana, pero ats̈e aíñe ts̈ëngaftanga tcbonjabacacá y tcbonjubuáyana, Bëngbe Bëtsabe trabajo jamama; y chca, mo canÿe betiye sempre tojtseshajuana y chë shajuana ndocna te tontsopochocacá, ts̈ëngaftanga chas̈motsemnama. Chca, lempe nts̈amo ats̈be Taitá s̈mojotjañcá, y chca s̈mojama ats̈e jóts̈ëmbonëse, áts̈beñe s̈mos̈buachéyeca, cha lempe cmochanjáts̈ataye. ");
INSERT INTO kbh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mënts̈á ats̈e cbetsamëndá: S̈mochtsenbobonshana ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mënts̈ánaca Jesús tojánayana: “Pero chë nÿe quem luarama enójuabnaye ents̈anga tcmojtsëbuayënjëse, s̈mochjenójuaboye, natsana chënga ats̈e s̈monjanáboyënjama. ");
INSERT INTO kbh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ts̈ëngaftanga, chë nÿe quem luarama enójuabnaye ents̈anguents̈ana s̈mojtsemnëse, chënga cmattsababuánÿeshana cachëngbengbioycá. Pero ts̈ëngaftanga ndoñe chë nÿe quem luarama enójuabnaye ents̈anguents̈ana ques̈mátsmëna, y ats̈na, chë quem luare oyenënguents̈ana ts̈ëngaftanga tcbonjabacacá. Chíyeca chë nÿe quem luarama enójuabnaye ents̈anga ts̈ëngaftanga cmontsë́buayënja. ");
INSERT INTO kbh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","S̈mochjenójuaboye nts̈amo tcbonjáuyanama: ‘Chë oservená chabe nduiñbiama ndoñe más uamaná quenátsmëna ca’. Chënga monjánama ats̈e chaisufrima; ts̈ëngaftángnaca chas̈motsesufrínama mochántsama. Ents̈anga nts̈amo ats̈e tijayanents̈ana ntsachets̈á tmojtsamcá, cachcá chënga mochántsama nts̈amo ts̈ëngaftanga chas̈mojtsëtsëtsná chents̈ana. ");
INSERT INTO kbh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chë chacmojtsë́buayënjënga, chë s̈ojichmó cha ndoñe quematábuatma. Chíyeca chënga lempe chca cmochanjáborlaye, ats̈be causa. ");
INSERT INTO kbh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ats̈e ndoñe matijabo y chënga ndoñe matijáuyanëse, ndegombre ndoñe bacna soye mattsebomna. Pero mora, chëngbe bacna soyëngama chënga ndoñe quemátobena jayanana, ‘¡Chca fsënjama ntsetats̈ëmbcá ca!’ ");
INSERT INTO kbh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nda ats̈e s̈ojtsáboyënja, ats̈be Taitábioynaca jtsáboyënjana. ");
INSERT INTO kbh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ats̈e chë bëts soyënga Bëngbe Bëtsabe obenánaca chë́ngbeñe ndoñe matijamëse, ndegombre chënga ndoñe bacna soyënga mattsebomna. Pero mora, masque nts̈amo sënjamcá tmonjinÿëse, chënga ats̈e s̈montsáboyënja y ats̈be Taitábioynaca. ");
INSERT INTO kbh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chca chënga montsama, nts̈amo chëngbe leyënguiñe enduabemancá cachcá chaopasama. Chiñe mënts̈á endayana: ‘Nÿe tondayama chënga s̈monjanáboyënja ca.’ ");
INSERT INTO kbh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ats̈e, ats̈be Taitábents̈ana chë Uajabuachaná y añemuayá ts̈ëngaftangbioye chanjíchmua. Cha chë Uámana Espíritu endmëna, chë nÿetsca soyënguiñe nts̈amo ndegombre yomncá oyebuambnayá. Cha endmëna chë Taitábents̈ana ichmoná; y cha lempe ats̈be ts̈abe soyënga cmochantsë́tsëtsnaye. ");
INSERT INTO kbh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chorscana, ts̈ëngaftángnaca ats̈biama ents̈anga s̈mochantsë́tsëtsnaye, er ts̈ëngaftanga áts̈eftaca s̈mondétsemna, ents̈anga jábuayenama ats̈e sënjanbojats̈é orscana ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mënts̈ánaca Jesús tojánayana: “Ats̈e quem soyënga cbontsëtsëtsná, ts̈ëngaftanga áts̈beñe os̈buáchiyana ndoñe chas̈mondájbanama, ats̈be causa chas̈mojtsesufrina ora. ");
INSERT INTO kbh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chëngna, chë judiëngbe enefjuana yebnënguents̈ana cmochantë́buacana. Chca tempo chaojobuache ora, chë ts̈ëngaftanga chacmojtsëbáyënga mënts̈á mochántsejuabnaye: ‘Bënga ts̈abá tmonjama ca. Nts̈amo Bëngbe Bëtsá yojtsebos̈cá, cachcá bënga tmonjama ca.’ ");
INSERT INTO kbh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chënga, chë Taitá Bëngbe Bëtsá ndoñe quematábuatma, y áts̈bioye cach ndoñe. Chíyeca, chca cmochanjáborlaye. ");
INSERT INTO kbh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ats̈e chca ts̈ëngaftanga cbontsëtsëtsná, nts̈amo tcbonjáuyanama chas̈muenójuaboma, chca tempo chaojobuache ora ca” —Jesús tojánayana. Mënts̈ánaca tojánayana: “Ents̈anga jábuayenama sënjanbojats̈é orscana, chë echanjopása soyëngama ndoñe quecbënjatanëtsëtsná, er ats̈e ts̈ëngaftangaftaca sënjétsemna. ");
INSERT INTO kbh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero morna, chë s̈ojichmó cha yomnoye chantá; y ts̈ëngaftanguents̈á ndocná s̈ochanjatjaye, ‘¿ndë́moye cojtsá ca?’ ");
INSERT INTO kbh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mora, ts̈ëngaftangbe ainana ngménaca entsemna, ats̈e chca tcbonjáuyana causa. ");
INSERT INTO kbh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero ndegombre s̈cuayana: Ats̈e chanjá y chca ts̈ëngaftangbe ts̈abiama echántsemna. Ats̈e ndoñe quetsjase, chë Uajabuachaná y añemuayá ndoñe ts̈ëngaftangbioye queochátabo. Pero aíñe chanjá, y chora cha ts̈ëngaftangbioye chanjíchmua. ");
INSERT INTO kbh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cha chaojáshjango ora, echanjama quem luarents̈a ents̈anga corente chamotsetáts̈ëmbo ndayá ndegombre yomna bacna soyënga jtsamana, ndayá ndegombre yomna chë Bëngbe Bëtsabe bominÿiñe ts̈abia jtsemnana, y ndayá yomna chë Bëngbe Bëtsá ents̈angbiama jayanana ts̈abá o ndoñe ts̈abá tmonjamama. ");
INSERT INTO kbh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ents̈anga áts̈beñe ndoñe quematos̈buaché. Chíyeca chë Uajabuachaná echanjama chënga corente chamotsetáts̈ëmbo ndayá ndegombre yomna chë bacna soyënga jtsamana. ");
INSERT INTO kbh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Chë Taitábioye chanjá y ats̈e ndoñe más ques̈mochátinÿe. Chíyeca chë Uajabuachaná echanjama chënga corente chamotsetáts̈ëmbo ndayá ndegombre yomna Bëngbe Bëtsabe bominÿiñe ts̈abia jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Quem luarents̈a bacna soyënga mándayabiama Bëngbe Bëtsá ya tonjayana, nts̈amo cha tojamama ndoñe ts̈abá yontsemna ca y nÿetsca tescama castiganá chaotsemna ca. Chíyeca chë Uajabuachaná echanjama ents̈anga corente chamotsetáts̈ëmbo, ndayá ndegombre yomna chë Bëngbe Bëtsá ents̈angbiama jayanana ts̈abá o ndoñe ts̈abá tmonjamama. ");
INSERT INTO kbh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ats̈e cabá ba soyënga së́ntsebomna ts̈ëngaftanga jáuyanama. Masque chcasna, mora ts̈ëngaftanga ndoñe ques̈mátobena chë soyëngama josértana. ");
INSERT INTO kbh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero chë Uámana Espíritu, chë nÿetsca soyënguiñe nts̈amo ndegombre yomncá oyebuambnayá, chaojáshjango ora, lempe nts̈amo ndegombre yomncá cmochanjabuatambá. Cha ndoñe nÿe cachabe juábnaca queochátoyebuambnaye. Nts̈amo chë Taitá chábioye tbojauyancá, ts̈ëngaftanga cachcá cmochanjáuyana, y cha cmochanjábuayenaye nts̈amo yochjopásama. ");
INSERT INTO kbh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ats̈be soyënguents̈ana cha echanjóyëngacñe, y cach soyëngama cmochanjabuatambá. Chcase cha cmochanjínÿanÿiye ats̈e bëtsá y obená bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lempe nts̈amo chë Taitá endbomncá, ats̈be soyë́ngnaca endmëna. Chíyeca ats̈e tcbonjáuyana, chë Uámana Espíritu ats̈be soyënguents̈ana yochjóyëngacñe y cach soyëngama cmochjabuatambá ca.” ");
INSERT INTO kbh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Baseftayté y ats̈e ndoñe más ques̈mochátinÿe. Inÿe baseftayté y cachiñe s̈mochantë́tinÿe ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chora Jesusbe básefta uatsjéndayënga imojtsentjanaye: —¿Nts̈amo yojtsents̈áyana, chë “baseftayté y ats̈e ndoñe más ques̈mochátinÿe, y inÿe baseftayté y cachiñe ats̈e s̈mochantë́tinÿe, er ats̈e chë Taitábioye chanjá ca”? ");
INSERT INTO kbh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nts̈amo yojtsents̈áyana, chë “baseftayté ca”? Ndoñe quemuátstats̈ëmbo nts̈amo yojtsents̈áyanama ca —chënga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús yojtsetáts̈ëmbo chënga chca jatjayama imojtsebos̈ama, y tojanë́yana: —Ats̈e tcbonjáuyana: “Baseftayté y ats̈e ya ndoñe más ques̈mochátinÿe, y inÿe baseftayté y cachiñe ats̈e s̈mochantë́tinÿe ca.” ¿Chë soyëngama s̈mojtsentjaná nts̈amo stsents̈áyanama? ");
INSERT INTO kbh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ndegombre s̈cuayana: Ts̈ëngaftanga s̈mochanjenóbos̈achna y puerte ngménënga s̈mochántsemna, pero chë nÿe quem luarama enójuabnaye ents̈anga corente oyejuayënga mochántsemna. Masque ts̈a ngménënga s̈mochántsemna, chents̈ana ts̈ëngaftangbe ngménana, oyejuayana echanjóbema. ");
INSERT INTO kbh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Canÿe shembása tbojonts̈abuache s̈es̈ona jónÿnama ora, ts̈a ngménaca cha jésemnana, puerte tbojtsetsets̈e causa. Chë s̈es̈ona ya tojonÿná ora, cha ndoñe ntsenójuabnayana chë ts̈a ibuántsets̈ama. Canÿe s̈es̈ona quem luaroye cháuashjanguama chë shembása tojámayeca, chora cha ts̈abá y oyejuayá jtsemnana. ");
INSERT INTO kbh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ndegombre, ts̈ëngaftángnaca cachcá, chora ts̈a ngménaca s̈mochántsemna. Pero ats̈e ts̈ëngaftangbioye chaijésabo ora, ats̈e s̈mochantë́tinÿe y corente oyejuayënga s̈mochántsatsmëna. Y ndocná queochatobenaye chë oyejuayana jabuajuánana. ");
INSERT INTO kbh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Chë te chaojóshjango ora, ts̈ëngaftanga ndocá ats̈e ques̈mochatstjaye. Ndegombre s̈cuayana, lempe nts̈amo ats̈be Taitá s̈mojotjañcá, y chca s̈mojama ats̈e jóts̈ëmbonëse, áts̈beñe s̈mos̈buachéyeca, cha lempe cmochanjáts̈ataye. ");
INSERT INTO kbh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Më́ntscoñama, ats̈be Taitá tondaye ches̈matotjañe ats̈e jóts̈ëmbonëse. Cha motjañënga y s̈mochanjóyëngacñe, y chca, bëtscá oyejuayana s̈mochántsebomna ca” —Jesús tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mënts̈ánaca Jesús tojánayana: “Chë soyëngama lempe cuentë́ngaca ts̈ëngaftanga tcbonjáuyana; pero tempo echanjobuache, chora ats̈e ya ndoñe más cuentë́ngaca quecbochátëtsëtsnaye; chë cuentna, puerte botamana lempe ats̈be Taitabiama cbochanjáuyana. ");
INSERT INTO kbh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chë tena, ats̈e jóts̈ëmbonëse, áts̈beñe s̈mos̈buachéyeca, ats̈be Taitábioye s̈mochanjotjañe. Y ats̈e cbë́yana; chca, chë te ndoñe ques̈ochatájaboto ts̈ëngaftangbiama ats̈be Taitá jatsimpadánana. ");
INSERT INTO kbh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ats̈e ndoñe quichatsimpadana, er cach Taitá ts̈ëngaftanga cmondábabuanÿeshana. Ts̈ëngaftanga ats̈e s̈mondbobonshánama, y Bëngbe Bëtsábiocana ats̈e tijabama s̈mojtsos̈buáchema, chë Taitá cmondábabuanÿeshana. ");
INSERT INTO kbh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ats̈e chë Taitábiocana sënjábocna y quem luaroye sënjabo. Pero mora quem luare chanjë́ftseboshjona ats̈be Taitábioye jtama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chora chabe uatsjéndayënga tmojaniyana: —Mora ya ndoñe cuentë́ngaca quecatoyebuambná, chíyeca lempe paselo josértama bëngbiama entsemna. ");
INSERT INTO kbh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mora fsë́ntsetats̈ëmbo aca nÿetsca soyëngama cotats̈ëmbuama, y ndoñe quenátsiyta ndocná aca chacmátstjanama, er aca chëngbe juabnënga jtsabuatmana, chënga cabá aca ndëtjaye ora. Chíyeca bënga fsëntsos̈buaché aca Bëngbe Bëtsábiocana tcojabama ca —chënga tmojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","As Jesús tojanë́yana: —¿Mora chiñe s̈mojtsos̈buaché ca? ");
INSERT INTO kbh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya tempo tocjobuache y cam ora entsemna, ts̈ëngaftanga nÿetsquénache s̈mochanjuáshana y ats̈e nÿe canÿa s̈mochanjéseboshjona. Pero ats̈e ndoñe nÿe canÿa quichátsmëna, chë Taitá áts̈eftaca entsémnayeca. ");
INSERT INTO kbh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ats̈e lempe quem soyënga cbontsëtsëtsná, ts̈ëngaftangbe ainaniñe ts̈abe ebionana chas̈motsebomnama, áts̈eftaca cánÿiñe mo canÿacá jtsemnëse. Quem luarents̈e s̈mochanjasufrina; pero añemo s̈mochtsebomna, ats̈e ya chë quem luarents̈a mandayá sënjayënjaná ca —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús chë soyënga tojánayanents̈ana, celoye tojanontjes̈é y Bëngbe Bëtsábioye tbojaniyana: “Taita, ats̈be te ya tocjobuache. Minÿanÿé, ats̈e acbe Uaquiñá, corente bëtsá y obená bétsemnama. As, ats̈e acbe Uaquiñá, aca corente bëtsá y obená comnama chainÿanÿema. ");
INSERT INTO kbh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mora aca nÿets obenana s̈conjats̈etá nÿetsca ents̈ángbeñe, nÿetscanga chë ats̈biama tcojábacacanga chë nÿetsca tescama yomna ts̈abe vida chamotsebomnama ats̈e chaimama. ");
INSERT INTO kbh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chë nÿetsca tescama yomna ts̈abe vida jtsebomnana endmëna aca, chë nÿe canÿe y ndegombre Bëngbe Bëtsá jtsabuatmana, y ats̈e Jesucristo, acbe ichmoná. ");
INSERT INTO kbh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Lempe nts̈amo s̈conjamandacá ats̈e sënjapochocá, y chca quem luariñe sënjama aca corente bëtsá y obená comnama jinÿanÿiyama. ");
INSERT INTO kbh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taita, quem luare cabá ndoñe quenjatsmëna ora, aca tconjaninÿanÿé ats̈e corente bëtsá y obená ácaftaca bétsemnama. Mora moma ats̈e cachcá ácaftaca chaitsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Aca quem luarents̈a ents̈anguents̈ana quem boyabásenga tconjabacacá y ats̈biama s̈conjinÿinÿé. Ats̈e chënga sënjanÿanÿé nts̈amo ndegombre aca comnama. Chënga acbe ents̈anga mondmëna; y acna, chë ats̈biama chënga s̈conjinÿinÿiyá. Chënga acbe palabra tmonjouena y ts̈abá tcmonjoyeuná. ");
INSERT INTO kbh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chíyeca chënga mondë́tats̈ëmbo, lempe nts̈amo ats̈e tsbomncá ácbents̈ana tijóyëngacñama. ");
INSERT INTO kbh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ats̈e chënga sënjáuyana nts̈amo aca s̈cojauyancá, y chënga montsos̈buaché chë ats̈e sënjauyaniñe. Chíyeca, chënga ndegombre mondë́tats̈ëmbo ats̈e acbiocana tijabama, y montsos̈buaché aca chë ats̈e s̈cojichmó cha comnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ats̈e chëngbiama cbontseimpadana. Chë nÿe quem luarama enójuabnaye ents̈angbiama ndoñe quecbátsimpadana, pero aíñe chë ats̈biama s̈cojinÿinÿiyëngbiama, er chënga acbe ents̈anga mondmëna. ");
INSERT INTO kbh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Lempe nts̈amo ats̈e tsbomncá, acbiámnaca endmëna; y cachcá, lempe nts̈amo cobomncá, ats̈biámnaca endmëna. Acbengbe vidë́ngaca aca tcojinÿanÿé ats̈e corente bëtsá y obená bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ats̈e ndoñe quem luarents̈e ques̈ocháisetotona, pero chënga aíñe cabá camuents̈e mochanjë́ftsemna. Ats̈e chantá ácaftaca jtsatsmënama. Uámana Taitá, chë ats̈biama s̈conjínÿinÿiyënga acbe obenánaca cochtsanÿena. Chca nts̈amo bëndata mo canÿacá bondmëna, chë́ngnaca cachcá chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ats̈e chë́ngaftaca së́ntsemnëntscuana, chënga sëntsanÿena, aca s̈conjats̈etá obenánaca. Ats̈e chënga sëndánÿena, y ni canÿa queochátsmëna infiernoca pochocaná, nÿe chë infiernoca pochocaná jtsemnama ibomná chana aíñe, nts̈amo acbe uabemana palabrënguiñe endayancá, cachcá chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Morna chë aca condmënoye chantá; pero ats̈e cabá quem luariñe së́ntsemnëntscuana chca chënga sëntsëtsëtsná, chca, chë ats̈e së́ntsebomna puerte bëtscá oyejuayana chë́ngnaca chamotsebomnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ats̈e chënga sënjáuyana nts̈amo aca s̈conjauyancá. Nts̈amo ats̈e ndoñe quetsátsmëna chë nÿe quem luarama enójuabnaye ents̈anguents̈á, cachcá, chënga cach ndoñe quemátsmëna. Chíyeca, chë nÿe quem luarama enójuabnaye ents̈anga chënga montsëbuayënja. ");
INSERT INTO kbh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ats̈e ndoñe quecbátsimpadana, chënga quem luarents̈ana chacúbuacanama; pero aíñe, nÿetsca bacna soyënguents̈ana chacuatsebacama. ");
INSERT INTO kbh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nts̈amo ats̈e ndoñe quetsátsmëna chë nÿe quem luarama enójuabnaye ents̈anguents̈á, cachcá, chënga cach ndoñe quemátsmëna. ");
INSERT INTO kbh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cochjama chënga acbe ents̈anga chamuétsemnama, y chca, nÿe acbiama vida chamotsebomna. Chca cochjama, nts̈amo ndegombre yomncá chënga imoyenama. Nts̈amo aca condbetsichamcá, ndegombre endmëna. ");
INSERT INTO kbh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nts̈amo aca quem luaroye s̈conjanichmocá, cachcá áts̈naca chënga sëntsachamná, quem luare ents̈anga jábuayenama. ");
INSERT INTO kbh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chëngbiama ats̈e cachiñe mënts̈á cbëyana: Ats̈e nÿe acbiama sëndmëna. Y chca, chë́ngnaca, nts̈amo acbiama ndegombre yomncá jtsóyebuambnayëse acbe ents̈anga chamotsemna, y chca, nÿe acbiama vida chamuétsebomna, nts̈amo ndegombre yomncá chënga imoyenama. ");
INSERT INTO kbh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pero nÿe chëngbiama ndoñe quecbátsimpadana, sinó chë áts̈beñe mochtsos̈buáchiyëngbiamnaca, chë ats̈biama s̈conjínÿinÿiyënga, chë́ngbioye ats̈biama ínÿenga chamojtsabuayiyná ora; ");
INSERT INTO kbh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","as chënga nÿetscanga cánÿiñe mo canÿacá chamotsemnama. Nts̈amo aca, Taita, áts̈eftaca cánÿiñe mo canÿacá bondmëna y áts̈naca ácaftaca, cachcá chë́ngnaca cánÿiñe mo canÿacá bëndátaftaca chamotsemnama cbontseimpadana. Y chca, quem luarents̈a nÿetsca ents̈anga, ats̈e s̈cojichmoma chamotsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nts̈amo chë obenana y uámanana s̈conjats̈etacá, cachcá áts̈naca chënga sënjats̈atá. As, nts̈amo bëndata cánÿiñe mo canÿacá bondmëna, chë́ngnaca cachcá cánÿiñe mo canÿacá chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ats̈e chëngbe ainaniñe së́ntsemna, y aca áts̈eftaca cánÿiñe mo canÿacá bondmëna; as, chë́ngnaca nÿetsca soyënguiñe cánÿiñe mo canÿacá chamotsemnama. Y chca, quem luarents̈a ents̈anga chamotsetáts̈ëmbo aca s̈cojichmoma, y chamotsetáts̈ëmbo nts̈amo ats̈e s̈condbobonshancá, chë́ngnaca cachcá condábabuanÿeshanama. ");
INSERT INTO kbh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Taita, ats̈biama chënga s̈conjínÿinÿiye. Ats̈e mënts̈á së́ntsebos̈e: chë ats̈e chántsemnoca, chë́ngnaca chamotsemna, y chents̈e, chë s̈conjats̈etá obenana y uámanana chënga chámuinÿe. Quem luare cabá ndoñe quenjatsmëna orscana, s̈conjánbobonshana; chíyeca, cachora tconjaninÿanÿé ats̈e corente bëtsá y obená bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taita, nÿetsca soyënguiñe ts̈abá amá, masque chë nÿe quem luarama enójuabnaye ents̈anga ndoñe quecmatábuatma, ats̈e aíñe cbonduábuatma, y quem boyabásenga montsetáts̈ëmbo, aca comna chë s̈cojichmó cha. ");
INSERT INTO kbh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ats̈e chënga sënjinÿanÿé nts̈amo ndegombre aca comnama, y más chanjínÿanÿiye; chca, nts̈amo s̈condbobonshancá, chë́ngnaca cachcá chamotsenbobonshánama y ats̈e chëngbe ainaniñe chaitsemnama ca” —Jesús tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chë soyënga Jesús tojë́ftsanayanents̈ana, chabe uatsjéndayëngaftaca tojë́ftsanbocna, chë binche béjaye Cedrón ca uabáiniye chenguana jama. Chents̈e inamna canÿe tjashetema; y Jesús chabe uatsjéndayëngaftaca choye tojánamengo. ");
INSERT INTO kbh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Y Judas, chë Jesús uayayëngbe cucuats̈iñe boshjuaná, ts̈abá chë luare yojanábuatma, er Jesús y chabe uatsjéndayënga ba soye chents̈e imojánenefjuana. ");
INSERT INTO kbh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chora Judas tojánashjango, y cháftaca ba soldadënga y básefta Bëngbe Bëtsabe bëts yebnoca josticiënga; chënga imojamna chë bachnangbe amë́ndayënga y fariseungbe ichmónënga; nÿetscanga uajuinÿanë́shangaca, lamparëshangaca y espadë́jangaca uajátënga. ");
INSERT INTO kbh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesusna yojtsetáts̈ëmbo lempe nts̈amo cha yochjanpásama; chíyeca, natsanoye tojánbocna y chë ents̈anga tojanë́yana: —¿Nda s̈mojtsenguá ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Y chënga tmojanjuá: —Jesús, chë Nazaretocá fsëntsenguá ca. As Jesús tojanë́jua: —Ats̈e cha sëndmëna ca. Y Judas, chë boshjuaná, chánaca chë ents̈ángaftaca yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús tojanë́yana: “Ats̈e cha sëndmëna ca”, y cachora chë ents̈anga tmojtanostëts̈ánanga y fshantsoye tmojánshajaye. ");
INSERT INTO kbh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Chora Jesús cachiñe tojanatjá: —¿Nda s̈mojtsenguá ca? Y chënga tmojanjuá: —Jesús, chë Nazaretocá ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","As Jesús tojanë́yana: —Ya tcbonjáuyana: “Ats̈e cha sëndmëna ca.” Ats̈e s̈mojtsenguasna, mënga cachcá s̈mochjónÿaye chamotsóñengama ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chca tojanopasá, ana nts̈amo Jesús tojanayancá cachcá chaotsemnama, chë “Ats̈be Taitá Bëngbe Bëtsá, chë s̈conjínÿinÿiye ents̈anguents̈ana ni canÿa pochocaná queochátsmëna ca”. ");
INSERT INTO kbh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro canÿe espadëja inasëngbuájonÿana; asna, tojanenosë́ngbotënts̈ena y chë bachnangbe más uámana amëndayabe canÿe oservenábioye cats̈bioica matscuas̈e tbojtsanë́stjango. Chë oservená Malco ca inauabaina. ");
INSERT INTO kbh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","As Jesús, Pédrëbioye tbojaniyana: “Acbe espadëja matosëngbuajonÿá. Nts̈amo ats̈be Taitá Bëngbe Bëtsá tojanmandacá, chë ats̈e puerte ngménana jtsebomnama, ¿ndoñe chca chaondë́tsemna ca?” ");
INSERT INTO kbh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chents̈ana chë soldadënga, chëngbe amëndayá y Bëngbe Bëtsabe bëts yebnoca josticiënga Jesús tmojánishache y tmojanëcuébatsëca. ");
INSERT INTO kbh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Natsanëna, Anás, Caifasbe uambén taitábioye Jesús tmojanánatse. Caifás chë uata inamna chë bachnangbe más uámana amëndayá. ");
INSERT INTO kbh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás yojamna nda judiënga tojanë́yana: “Ts̈ëngaftangbiama más ts̈abá entsemna canÿe boyabása Israeloca ents̈angbiama chaóbana ca.” ");
INSERT INTO kbh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro y inÿe uatsjendayá Anasbe yebnoye Jesús imojtsë́stona. Chë inÿe uatsjendayábioyna, chë bachnangbe más uámana amëndayá ibnauábuatma; chíyeca, cha tojanobená Jesúseftaca chabe chashjóntscoñe jashjanguana. ");
INSERT INTO kbh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pédrëna nÿe shjoca, amashjuanents̈e tojanoquedá. Chcasna, chë inÿe uatsjendayá tojánbocna y chë bës̈ás̈a ebtafjuana shembásaftaca tojanoyebuambá. Chora Pedro tbojanë́mashëngo. ");
INSERT INTO kbh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","As chë shembása Pédrëbioye tbojaniyana: —¿Acnaca ndoñe chë boyabásabe uatsjendayá condmëna ca? Y Pedro tbojanjuá: —Ndoñe; ats̈e cha ndoñe quetsatabuatma ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ts̈a yojtsesësna causna, chë oservénënga y chë josticiënga shjoca tmojanniñé y chents̈e imojtós̈boniye. Y Pédrënaca chë́ngaftaca yojtses̈bonena. ");
INSERT INTO kbh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chora, chë bachnangbe más uámana pasado amëndayá tojanonts̈é Jesús jatjayama chabe uatsjéndayëngbiama y ndayá cha ents̈anga yojánabuatambamnaca. ");
INSERT INTO kbh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Y Jesús tbojanjuá: —Ats̈e nÿetsca ents̈angbe delante sënjoyebuambá. Sempre chë ents̈angbe enefjuana yebnënguenache sëndabuatambá, y Bëngbe Bëtsabe bëts yebnócnaca, nÿetsca judiënga mondbétsenefjuanents̈e; y chca, iytëmencá tondaye chiyatoyebuambá. ");
INSERT INTO kbh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ndáyeca chca s̈cojtsetjaná? Ats̈be palabra tmojouenënga mátjaye, as chënga chacmëyana nts̈amo ats̈e tijáuyanama. Chënga mondë́tats̈ëmbo nts̈amo ats̈e tijayancá ca —Jesús tbojanjuá. ");
INSERT INTO kbh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús chë soyënga tojánayana ora, canÿe josticio chents̈e yojtsemná, Jesúsbioye tbojanjuebjants̈etá y tbojaniyana: —¿Chca chë bachnangbe más uámana amëndayá cuanjojuá ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Y Jesús tbojanjuá: —Ndoñe ts̈abá tijayanësna, s̈mëyana ndayents̈e chë podesca palabra yojtsemna; y ts̈abá tijóyebuambasna, ¿ndáyeca s̈cojajuebjants̈etá ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Chents̈ana, Anás tojanmandá, chë bachnangbe más uámana amëndayá Caifasbe yebnoye, Jesús batsëcná chamuánatsama. ");
INSERT INTO kbh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chëntscuana, Pedro yojtses̈bonena, tsanana chë iñe juachaca. Chora chë ents̈anga tmojantjá: —¿Aca ndoñe chabe uatsjendayënguents̈á condmëna ca? Y Pedro ndoñe ca tojánayana: —Ats̈e ndoñe quetsátsmëna ca —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chora, chë bachnangbe más uámana amëndayabe canÿe oservená Pédrëbioye tbojaniyana: —¿Ats̈e ndoñe cháftaca chë tjashetémoca tcbonjinÿe ca? Chë oservená inamna chë Pedro tbojtsanmatstëts̈abe pamillo. ");
INSERT INTO kbh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Y Pédrëna cachiñe ndoñe ca tojánayana, y cachora canÿe ngallo yojacánta. ");
INSERT INTO kbh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chents̈ana, Caifasbe yebnents̈ana Jesús tmojanánatse chë romano mandadbe yebnoye. Ya yojtsebínÿana, y chë bëts yebnoye chë judiënga ndoñe tmonjánamashjna, er chënga imojtsebos̈e chë Bashco saná jasama. Judiënga ndoñe imonjobena Bashco saná jasana, chca tempo canÿe ndoñe judiëbe yebnoye nda tojámashënguse. ");
INSERT INTO kbh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chíyeca Pilato tojánbocna y chënga tojanë́yana: —¿Ndayá quem boyabásabe contra s̈mochjayana ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chora chë ents̈anga tmojanjuá: —Bacá uamaná ndoñe tontsemnëse, ndoñe matifjuánatse ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","As Pilato tojanë́yana: —Ts̈ëngaftanga matánatse, y nts̈amo cach ts̈ëngaftangbe leyiñe iuayancá muabiama s̈mochjayana ts̈abá o ndoñe ts̈abá tonjamama ca. Y chë judiënga tmojanjuá: —Bënga derecho queftsátsbomna ndocná jóbama ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chca tojanopasá, ana nts̈amo Jesús cachá jóbanama tojanayancá cachcá chaotsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","As Pilato cach yebnoye tojtanamáshëngo, Jesús tbojanchembo y tbojantjá: —¿Aca chë judiëngbe Rey cojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Y Jesús tbojanjuá: —¿Nts̈amo s̈conjatjacá, cach aca chca cojtsejuabnáyeca chca yojtsemna o ínÿenga ats̈biama tcmojacuentáyeca ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Chora Pilato tbojaniyana: —¿Mo ats̈e judío quetsmëna? Cach ácbioca ents̈anga y chë bachnangbe amë́ndayënga muents̈e tcmonjúshjango. ¿Ndayá tcojama ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chora Jesús tbojanjuá: —Ats̈be jamándama luare ndoñe quem luarents̈e quenátsmëna. Aíñe tojtsemnësna, ats̈be ústonënga muantsatsejaye ats̈e chë judiëngbe cucuats̈iñe ndoñe chas̈mondboshjonama. Pero ats̈be jamándama luare ndoñe quem luarents̈e quenátsmëna ca —Jesús tbojanjuá. ");
INSERT INTO kbh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","As Pilato tbojaniyana: —¿As aca rey cojtsemna ca? Y Jesús tbojanjuá: —Ts̈abá tcjayana; ats̈e rey sëndmëna. Chama ats̈e tijonÿná y quem luaroye tijabo; y ats̈e sënjabo ndegombre soyëngama jabóyebuambayama. Y chca soyënga jtsamëse tmoyenënga, ats̈e jtseyeunanana ca. ");
INSERT INTO kbh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chora Pilato tbojaniyana: —¿Y ndayase chë ndegombre soye yomna ca? Chca tbojantjá chents̈ana, Pilato cachiñe tojánbocna judië́ngaftaca jóyebuambayama, y tojanë́yana: —Ats̈e ni mo canÿe soye chiyátinÿena, quem boyabása castiganá chaotsemna ca jayanama. ");
INSERT INTO kbh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero ts̈ëngaftanga s̈mondë́tats̈ëmbo, Bashco fiestama ats̈e canÿe utamená cachcá jëtsboshjonama. ¿S̈mojtsebos̈e chë judiëngbe Rey chjëtsboshjona ca? ");
INSERT INTO kbh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Chorna nÿetsca ents̈anga cachiñe tmojanáyebuachena: —¡Ndoñe, cha ndoñe! ¡Barrabás matsboshjona ca! Barrabasna canÿe bacá uamana ents̈á inamna. ");
INSERT INTO kbh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chora Pilato, Jesús tbojanánatse y tojanmandá chamotsetjanjama. ");
INSERT INTO kbh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Y canÿe coronë́sha uchmas̈ë́fjangaca chë soldadënga tmojanapormá y Jesús tmojanabests̈ajó; y canÿe shbuenda uafjatsenga ents̈ayá mo reycá tmojanichëtjo. ");
INSERT INTO kbh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chorna chënga imojtsóbobecocnaye y jtsafchayama imojtsatsëtsnaye: “¡Bayté judiëngbe Rey cochtsemna ca!” Y imojtsejuebants̈etaye. ");
INSERT INTO kbh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato cachiñe tojánbocna y ents̈anga tojanë́yana: —S̈mochjouena; cha chanjuábocna, chë boyabása castiganá chaotsemna ca jayanama ats̈e ni mo canÿe soye ndoñe sënjínÿenama chas̈motsetats̈ëmbuama ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","As Jesús tojánbocna chë uchmas̈ë́fjangaca coronë́sha uabests̈ajoná y chë shbuenda uafjatsenga ents̈ayá mo reycá uichëtjoná. Y Pilato tojanë́yana: —¡Muents̈e chë boyabása entsemna ca! ");
INSERT INTO kbh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Chë bachnangbe amë́ndayënga y chëngbe josticiënga cha tmojáninÿe ora, tmojanonts̈é uayebuáchana: —¡Motsecrucificá! ¡Motsecrucificá ca! Chora Pilato tojanë́yana: —Cach ts̈ëngaftanga mánatse y s̈mochjacrucifíca; ats̈e ni mo canÿe soye chiyátinÿena quem boyabása castiganá chaotsemna ca jayanama ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chora chë judiënga tmojanjuá: —Bëngna canÿe ley fsë́ndbomna, nts̈amo chiñe endayancana, quem boyabása jóbanama bontsemna, Bëngbe Bëtsabe Uaquiñá entsenobiamná causa ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato chca tojanuena ora, más yojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Cachiñe chabe yebnoye tojtanamáshëngo y Jesús tbojantjá: —¿Ndëmocá aca cmëna ca? Pero Jesús ndocá tbonjanjuá. ");
INSERT INTO kbh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Chora Pilato tbojaniyana: —¿Ndoñe s̈cochanjojuá ca? ¿Ndoñe condë́tats̈ëmbo, aca jacrucifícama o jëtsboshjonama ats̈e tsobenama ca? ");
INSERT INTO kbh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","As Jesús tbojanjuá: —Acbe obenana Bëngbe Bëtsá ndoñe macmënjánats̈etase, tondaye cattsobena áts̈eftaca jamama; chíyeca, acbe cucuats̈iñe s̈onjaboshjoná, acbiama más bëts bacna soye tonjama ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cach orscana Pilato yojtsenguaye nts̈amo jamana, jobenayama Jesús jëtsboshjonama; pero chë judiënga imotsáyebuache: —¡Chacojëtsboshjonësna, Césarbe amigo ndoñe condmëna! ¡Nda rey tojtsenobiamná chana, Césarbe uayayá jtsemnana ca! ");
INSERT INTO kbh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato chë soyënga tojanuena ora, chashjoye Jesús tbojanábocna. Pilato tojanótbema chabe puestents̈e tribunaloca. Chë tribunaloca chashjañna hebreo biyañe Gabata ca inauabaina, y endayana “ndëts̈béngaca pormániñe ca”. ");
INSERT INTO kbh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bashco fiestama canÿe te yojtsájamna, y mo nÿetsto ora yojtsemna. Chora Pilato chë judiënga tojanë́yana: —¡Muents̈e ts̈ëngaftangbe rey entsemna ca! ");
INSERT INTO kbh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero chënga tmojanáyebuachena: —¡Chaóbana! ¡Chaóbana! ¡Motsecrucificá ca! As Pilato tojanatjá: —¿Ts̈ëngaftangbe rey ats̈e chjacrucifíca ca? Y chë bachnangbe amë́ndayënga tmojanjuá: —Bëngbe rey nÿe César endmëna, ndocná más ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chents̈ana Pilato, chëngbe cucuats̈iñe Jesús tbojánboshjona chamocrucificama y chë judiënga cha tmojanánatse. ");
INSERT INTO kbh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús tojánbocna chabe cruz tants̈ajónana y tmojanánatse canÿe luaroye, “Obanabe Bests̈ashe ca” uabáinoye (hebreo biyañe Gólgota ca inauabaina). ");
INSERT INTO kbh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chents̈e cha tmojancrucificá y inÿe útatnaca cátatoica tmojanacrucificá; Jesusna tsëntsaca. ");
INSERT INTO kbh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato tojanmandá canÿe uabemana soye chë cruciñe chamuanjuama. Chiñe yojetsábemana: JESÚS NAZARETOCÁ, JUDIËNGBE REY ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Y ba judiënga chë uabemana soye tmojanalía, er chë Jesús tmojancrucificá luare Jerusalenó béconana inamna, hebreo, latín y griego biyañe yojetsábemana. ");
INSERT INTO kbh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chca juabemama tojanmandáyeca, chë bachnangbe amë́ndayënga Pilato tmojaniyana: —Ndoñe matabiamnana “Judiëngbe Rey” sinó nts̈amo cachá tojayancá, “Judiëngbe Rey ats̈e sëndmëna ca”. ");
INSERT INTO kbh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato tojanë́jua: —Nts̈amo tijuábema cachcá chaotsábemana ca. ");
INSERT INTO kbh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Chë soldadënga Jesús tmojancrucificá chents̈ana, chabe ents̈ayangá tmojanájaca y cántañe tmojanajatá, nÿetsca canta soldadëngbiama. Chabe cmes̈ë́jua tmojanaca; chë́juana yojanamna nduajonanë́jua, nÿetsë́jua uabianánëjua. ");
INSERT INTO kbh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","As chë soldadënga tmojáneniyana: “Ndoñe matjuátanëca; más ts̈abana tsbanánoye mochjúts̈ena, ndabiama yochjuáquedama chaotsotats̈ëmbuama ca.” Chca tojanopasá ana nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá cachcá chaotsemnama, chë “Ats̈be ents̈ayangá tmojatenájataye; ats̈be cmes̈ë́juamna tsbanánoye tmonjanë́ts̈ena, ndabiama juaquédama jtsotats̈ëmbuama ca.” Y lempe chca chë soldadënga tmojanma. ");
INSERT INTO kbh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesusbe cruz juachaca imojtsemna chabe mamá; chë mamabe quenata María, Cleofasbe shema; y María Magdalena. ");
INSERT INTO kbh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús chabe mamábioye tbojáninÿe, y chabe juachacna chë Jesusbe bonshana uatsjendayá yojtsemna. Chora chabe mamá tbojaniyana: “Mama, chents̈e acbe uaquiñá entsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Y chë bonshana uatsjendayá tbojaniyana: “Chents̈e acbe mamá entsemna ca.” Cach orscana, chë uatsjendayá chabe yebnents̈e Jesusbe mamábioye tbojanofja. ");
INSERT INTO kbh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesús yojtsetáts̈ëmbo ya lempe tojanchnënguama, chíyeca chents̈ana y nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá cachcá chaotsemnama, tojánayana: “S̈ontsajuendá ca.” ");
INSERT INTO kbh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chents̈e inamna canÿe matbaja buajútjena untja vínoyeca. As, chë soldadënga canÿe esponjëshe chë vínoyeca tmojanfchecuacuá, canÿe hisopo niñëfjiñe tmojananguësëtjo y játsbanase, Jesusbe uayás̈oye tmojanbeconá. ");
INSERT INTO kbh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chë untja vínoye Jesús tojanofs̈é ora, tojánayana: “Ya lempe tocjochnëngo ca.” Tojanotsejbé y tojanóbana. ");
INSERT INTO kbh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bashco fiestama canÿe te yojtsájamna, y chë judiënga ndoñe imontsebos̈e chë crucificánënga cachents̈e chë ochnayté chamotsemnama, chë te puerte uámana te bétsemnayeca. As Pilato tmojanimpadá chë crucificánënga shecuats̈ënga jetsatcacayama y chë cuerpënga chents̈ana jtsejuánama chaomandama. ");
INSERT INTO kbh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","As chë soldadënga tmojána y shecuats̈ënga imojtsatcacaye, natsana canÿa y chents̈ana chë inÿa, Jesúseftaca yojtsecrucificaná. ");
INSERT INTO kbh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero Jesúsbioye tmojanobeconá ora, ya obaná tmojáninÿe; chíyeca chabe shecuats̈ënga ndoñe tmonjanatcacá. ");
INSERT INTO kbh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Masque chca, canÿe soldado Jesúsbioye costillaca canÿe lanzë́s̈aca tbojanashacuá. Y cachora buiñe y búyeshe chents̈ana tonjanóbocna. ");
INSERT INTO kbh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Chë mënts̈á cuentayá chents̈e enjamna y tonjáninÿe, y ndegombre entsichamo; cha endë́tats̈ëmbo ndegombre yojtsichámuama, chca, ts̈ëngaftángnaca chiñe chas̈motsos̈buáchema. ");
INSERT INTO kbh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chë soyënga chca tojanopasá, nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá cachcá chaotsemnama. Chiñe endayana: “Ni mo canÿe betas̈e cha quemochatsënts̈átca ca.” ");
INSERT INTO kbh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y ínÿoca, Bëngbe Bëtsabe uabemana palabrënguiñe endayana: “Chë tmojenachents̈á bominÿe mochanjabuájua ca.” ");
INSERT INTO kbh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chë soyënga tojanopasá chents̈ana, José Arimateocá, Pilátbioye tbojanimpadá Jesusbe cuerpo jesocñama chabolesenciama. José inamna Jesusbe canÿe ustoná, masque nÿe iytëcana, chë judiëngbiama auatja causa. Pilato aíñe tbojanlesenciá; as José tojána y Jesusbe cuerpo yojtsámbañe. ");
INSERT INTO kbh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo, chë ibeta Jesúsbioye tbojanbuachá, chánaca tojánashjango y tojanëyamba unga bnë́tsana kilo mirra y áloe enájuabnana. ");
INSERT INTO kbh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","As José y Nicodemo Jesusbe cuerpo tbojanca y tmojanandmaná chë botamana uanguëts̈e soyë́ngaca unë́tjona ents̈ë́juangaca. Judiënga chca imnauamana, obaná juatbontsama ora. ");
INSERT INTO kbh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús tmojancrucificá luarents̈e canÿe base jajañe inamna, y chiñe canÿe tsëm cuevëshe, ents̈angbe pormánëshe, obanëngbiama; chëshiñe cabá ndocna obaná mondëjajo. ");
INSERT INTO kbh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Asna, nÿe chents̈e Jesusbe cuerpo tmojansegorá, chë Bashco fiestama canÿe te yojtsájamna causa, y chë cuevëshe chë béconana inámnayeca. ");
INSERT INTO kbh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chë inÿe semana bojats̈enté, cabá cachëse, cabá ndëbinÿna ora, María Magdalena chë cuevëshoye tojána y tojáninÿe ínÿoca yojtsemna chë cuevëshoye amashjuanents̈a ndëts̈bé. ");
INSERT INTO kbh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Asna, tojëftsanótjajo y tojána chë Simón Pedro y chë inÿe uatsjendayá, ndábioye Jesús ts̈a ibnabobonshana ibojtsemnoye. Chora tojanë́yana: “Bëngbe Utabnabe cuerpo chë cuevëshents̈ana tmojtsámbañe y ndayents̈e tmotsejájoma ndoñe queftsátstats̈ëmbo ca.” ");
INSERT INTO kbh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chora Pedro y chë inÿe uatsjendayá chents̈ana tbojë́ftsanbocna y chë cuevëshoye tbojánata. ");
INSERT INTO kbh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nÿets útata ibojtsëchamana, pero chë inÿe uatsjendayá Pédrëbiama más betsco tojanótjajo y natsana chë cuevëshoye tojánashjango. ");
INSERT INTO kbh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tojanotsejbé y chë chents̈e tmojanacjá ents̈ëjuangá tojáninÿe, pero choye ndoñe tonjánamashëngo. ");
INSERT INTO kbh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chents̈ana, Simón Pedro chabe ústonoye tojánashjango y chë cuevëshoye tojánamashëngo, y tojáninÿe chë chents̈e tmojanacjá ents̈ëjuangá. ");
INSERT INTO kbh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Y chë Jesús juabests̈ëntsacjuama tojanaservé ents̈ë́juana ndoñe chë inÿájuangaca yontsamna, sinó ínÿoca botamana uandmanánëjua. ");
INSERT INTO kbh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chora chë inÿe uatsjendayá, chë cuevëshoye natsana tojanashjanguá, choye tojánamashëngo. Tojáninÿe y Jesús tojtanayenama yojtsanos̈buaché. ");
INSERT INTO kbh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chë́ntscoñe chë útata cabá ndoñe yontsósertana nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe endayancá, chë Jesús obanënguents̈ana jtayenama ibojamnama. ");
INSERT INTO kbh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chents̈ana chë uatsjéndayata chatbe oyenoye tbojtaná. ");
INSERT INTO kbh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María chents̈e tojanoquedá, chë cuevëshe juachaca s̈achénaca; yojtsos̈achentscuana tojanotsejbé cuevëshoye jarrepárama. ");
INSERT INTO kbh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Y tojáninÿe uta angelotémata uafjantsë́jua uichë́tjonata, Jesusbe cuerpo yojëftsejajónents̈e ibojtsetbemana. Canÿa tsënts̈énëshoica y chë ínÿana matsëscoica. ");
INSERT INTO kbh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chora chata tmojaniyana: —Shembása, ¿ndayama cos̈aché ca? As cha tojanjuá: —Ats̈be Utabná tmojtsámbañe, y ndayents̈e tmojtsejájoma ndoñe quetsátstats̈ëmbo ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chca tojánayana ora, tojanostëts̈antjes̈é y tojáninÿe chents̈e Jesús yojtsemna, pero María ndoñe yontsetáts̈ëmbo cha Jesús bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chora Jesús tbojaniyana: —Shembása ¿ndayama cos̈aché? ¿Nda conguá ca? María yojtsejuabnaye chë boyabásana yojtsemna chents̈a base jajañe uaishanÿá ca; chíyeca tbojantjá: —Bacó, aca tcojuambësna, s̈mëyana ndayents̈e cojtsejajó, as ats̈e cha jesocñama ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","As Jesús tbojaniyana: —¡María ca! Chora María chábioye tojanontjes̈é y tbojaniyana: —¡Rabuni ca! (hebreo biyañe chca endayana “Buatëmbayá ca”.) ");
INSERT INTO kbh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chora Jesús tbojaniyana: —Ndoñe s̈catábojajo, er ats̈e cabá ndoñe ats̈be Taitábioye quetstë́tstsjua. Pero motsa ats̈be cats̈átangbioye y cochjáuyana, ats̈e stsetsjuá ats̈e y ts̈ëngaftangbe Bëtsábioye, ats̈e y ts̈ëngaftangbe Taitábioye ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","As María Magdalena tojána y Jesusbe uatsjéndayënga tojanë́yana cha chë Utabnábioye tbojáninÿe ca y cha chë palabrënga tojánayana ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tojanibétata ora, cach semana bojats̈enté, chë uatsjéndayënga tmojánenefjna canÿe luarents̈e, pero lempe tmojtanatame, chë judiëngbiama auatja causa. Chora Jesús tojánamashëngo, chëngbe tsëntsaca tojantsá y mënts̈á tojanacheuá: “Chë ats̈be ainaniñe ts̈abe ebionana ts̈ëngaftangaftaca chaotsema ca.” ");
INSERT INTO kbh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Y chca tojanë́yana ora, chabe cucuats̈ënga y costillaca tojaninÿanÿé. Chora chë uatsjéndayënga oyejuayënga imojtsemna, chëngbe Utabná tmojáninÿama. ");
INSERT INTO kbh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","As Jesús cachiñe tojanë́yana: “Chë ats̈be ainaniñe ts̈abe ebionana ts̈ëngaftangaftaca chaotsemna. Nts̈amo ats̈be Taitá Bëngbe Bëtsá s̈ojichmocá, áts̈naca cachcá ts̈ëngaftanga cbonts̈achamná ca.” ");
INSERT INTO kbh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chca tojánayana ora, chë́ngbioye tojangouo y tojanë́yana: “Chë Uámana Espíritu s̈mochjóyëngacñe. ");
INSERT INTO kbh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ndëmuanÿenga chëngbe bacna soyëngama chas̈mojáperdonanga, perdonánënga mochántsatsmëna; y ndoñe chas̈monjáperdonasna, ndëperdonánënga mochántsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero Tomás, chë Gemelo ca uabobainá, canÿa chë bnë́tsana uta uatsjendayënguents̈á, chë uatsjéndayëngaftaca ndoñe yontsemna, Jesús tojánashjango ora. ");
INSERT INTO kbh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chíyeca, “bënga chë Utabná fsënjinÿe ca”, chë inÿe uatsjéndayënga tmojaniyana ora, Tomás tojanë́jua: “Ats̈e chabe cucuats̈iñe chë uajabonjana uinÿniñe ndoñe sënjinÿe, y chiñe ats̈be nts̈abuafja ndoñe sënjajué y ats̈be cucuats̈e chabe costillaca ndoñe, ndoñe quichátos̈buachiye ca.” ");
INSERT INTO kbh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Canÿe semana tojanochnëngo ora, chë uatsjéndayënga cachiñe canÿe luarents̈e tmojánenefjna. Y Tomásnaca chë́ngaftaca yojtsemna. Masque chents̈e atámeniñe yojtsemna, Jesús tojánamashëngo, chëngbe tsëntsaca tojantsá y tojanë́yana: —Ats̈be ainaniñe ts̈abe ebionana ts̈ëngaftangaftaca chaotsemna ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chora Tomásbioye tbojaniyana: —Acbe nts̈abuafja muents̈e mojué y ats̈be cucuats̈e minÿe; acbe cucuats̈e miyëbo y ats̈be costillaca mojué. Y ndos̈buachiyá ndoñe matsmënana, sinó ats̈e tijtayenama cochtsos̈buáchiye ca. ");
INSERT INTO kbh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","As Tomás tbojaniyana: —¡Ats̈be Utabná y ats̈be Bëtsá ca! ");
INSERT INTO kbh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chora Jesús tbojaniyana: —Tomás, nÿe s̈conjínÿeyeca cojtsos̈buaché. ¡Bëngbe Bëtsá chaoma puerte oyejuayënga chamotsemna chë nÿe ntjinÿcá tmojos̈buachenga ca! ");
INSERT INTO kbh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús, chabe uatsjéndayëngbe delante inÿe bëts soyënga Bëngbe Bëtsabe obenánaca tonjë́ftsema, pero quem librë́s̈añe ndoñe quenatábemana. ");
INSERT INTO kbh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Y quem librë́s̈añe soyëngna, entsábemana ts̈ëngaftanga chas̈motsos̈buáchema, Jesús, chë Cristo y Bëngbe Bëtsabe Uaquiñá bétsemnama; y chcase, chábeñe chas̈mojtsos̈buachese, chábeyeca chë nÿetsca tescama yomna ts̈abe vida chas̈motsebomnama. ");
INSERT INTO kbh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chca tojanopasá chents̈ana, Jesús inÿe soye chabe uatsjéndayënga tojánebëbuacna, Tiberias mar béjaye tsachañe. Chora mënts̈á tojanopasá: ");
INSERT INTO kbh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cánÿents̈e imojétsemna Simón Pedro; Tomás, chë Gemelo ca uabobainá; Natanael, chë Galilea luarocá, Caná pueblocá; Zebedeobe uaquiñata y Jesusbe inÿe uta uatsjéndayata. ");
INSERT INTO kbh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro chënga tojanë́yana: —Sëntsá beonga jashebuáyama ca. As chënga tmojanjuá: —Bë́ngnaca ácaftaca fchanjá ca. As tmojána y canÿe barquë́shoye tmojánamashjna; pero chë ibeta tondaye tmonjáninÿena. ");
INSERT INTO kbh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ya yojtsebínÿana orna, Jesús chë tsachoca yojtsemna, pero chë uatsjéndayënga ndoñe imontsetáts̈ëmbo cha Jesús yojamnama. ");
INSERT INTO kbh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chora Jesús tojanatjá: —Básenga, ¿tondaye s̈monjashbuá ca? Y chënga tmojanjuá: —Tondaye ca. ");
INSERT INTO kbh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","As Jesús tojanë́yana: —Barquësha cats̈bioica chë atarraië́sha më́ts̈ena y beonga s̈mochanjáshebuaye ca. As chënga chca tmojanma, y chora chësha jtabocnama ndoñe imontsobena, nÿets̈á beonga tmojánishëche causa. ");
INSERT INTO kbh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","As chë Jesusbe bonshana uatsjendayá, Pédrëbioye tbojaniyana: “¡Bëngbe Utabná entsemna ca!” Simón Pedro chca soye tojanuena y cachora ents̈ayá tojtaníchëtjo, er nduichëtjoná yojtsemna, y chë béjayoye tojanoshbuets̈e. ");
INSERT INTO kbh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chë inÿe uatsjéndayëngna chë barquë́shañe tmojána, y chë atarraië́sha jútjena beóngaca imojtsásjaye, er chë tsachocama bécoñe imojtsemna, nÿe canÿe patse metroca. ");
INSERT INTO kbh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Fshantsoye tmojánastjajna ora, chënga tmojáninÿena canÿe chebániñe pormániñe, y chents̈na canÿe beona y tandë́s̈naca yojtsesegorana. ");
INSERT INTO kbh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chora Jesús tojanë́yana: “Chë s̈monjáshebuaye beonguents̈ana báseftanga miyëbo ca.” ");
INSERT INTO kbh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro chë barquë́shoye tojánamashëngo, y chë atarraië́sha jútjena bëts beóngaca, uasjojónana tsachóntscoñe tojanëyamba. Mo canÿe patse y shachna bnë́tsana y unga beóngaca; pero masque nÿets̈á beonga, chë atarraië́sha ndoñe ntjuatanë́canana. ");
INSERT INTO kbh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chora Jesús tojanë́yana: “Mabënga, s̈mochjase ca.” Chë uatsjéndayënguents̈ana ni canÿa yontsenñémua cha jatjayama nda cha yojamnama, er nÿetscanga imojtsetáts̈ëmbo cha chë Utabná bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chora Jesús tojanobeconá, chë tandës̈e tojanca y chënga tojanats̈atá, y chë beónacnaca cachcá tojanma. ");
INSERT INTO kbh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Chóracna, Jesús ya unga soyama chabe uatsjéndayënga yojtsanebëbuacana, obanënguents̈ana tojtanayenents̈ana. ");
INSERT INTO kbh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jasama tmojanpochocá ora, Jesús, Simón Pédrëbioye tbojantjá: —Simón, Juanbe uaquiñá, ¿quemëngbiama más ques̈cbobonshana ca? Y Pedro tbojanjuá: —Ats̈be Utabná, aíñe. Aca condë́tats̈ëmbo ats̈e aíñe cbondbobonshánama ca. As Jesús tbojaniyana: —Ats̈be ents̈anga, mo oveshatemëngcá imomnënga, cochtsanÿena ca. ");
INSERT INTO kbh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chora cachiñe tbojantjá: —Simón, Juanbe uaquiñá, ¿ques̈cbobonshana ca? Y Pedro tbojanjuá: —Ats̈be Utabná, aíñe. Aca condë́tats̈ëmbo ats̈e aíñe cbondbobonshánama ca. As Jesús tbojaniyana: —Ats̈be ents̈anga, mo oveshëngcá imomnënga, cochtsanÿena ca. ");
INSERT INTO kbh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Y unga soyama tbojtëtantjá: —Simón, Juanbe uaquiñá, ¿ques̈cbobonshana ca? Pedro puerte tbojanongmé, ya unga soyama “ques̈cbobonshana ca” tbonjantjá causa; y tbojanjuá: —Ats̈be Utabná, aca lempe condë́tats̈ëmbo. Aca condë́tats̈ëmbo ats̈e aíñe cbondbobonshánama ca. As Jesús tbojaniyana: —Ats̈be ents̈anga, mo oveshëngcá imomnënga, cochtsanÿena. ");
INSERT INTO kbh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ndegombre cbëyana: Más bobontse conjamna ora, conjanamana cach aca jtichëtjuana y ndë́moye jama cojtsebos̈e choye jtsoñana; pero tanguá chacojtsemna orna, buacuats̈ënga cochanjatsbaná, y inÿa cmochantichëtjo y ndë́moye jama ndoñe chacontsebos̈e choye cmochanjuánatse ca —Jesús tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chca tojánayana, ana jtsotats̈ëmbuama nts̈amo Pedro jóbanama ibojamnama, y chë chca jóbanëse, Bëngbe Bëtsá corente bëtsá y obená bétsemnama Pedro yochjáninÿanÿiyama. Y chca tojánayanents̈ana, Pédrëbioye tbojaniyana: —S̈masto ca. ");
INSERT INTO kbh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro tojesanenostëts̈antjes̈é y tojáninÿe, Jesusbe bonshana uatsjendayá ústonoye yojtsaye. Cha enjamna chë monjansá ora, Jesús cabá ndóbana ora, chë Jesúsbioye más tonjanosjoná y tbonjantjá: “Bëngbe Utabná, ¿nda chë boshjuaná yochtsemna ca?” ");
INSERT INTO kbh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro chábioye tbojáninÿe ora, Jesúsbioye tbojantjá: —Ats̈be Utabná, y cháftaca, ¿nts̈amo yochjopása ca? ");
INSERT INTO kbh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Chora Jesús tbojanjuá: —Ats̈e quem luaroye jesabámëntscuana cha ainá chauesomñama ats̈e stsebos̈ëse, ¿aca ndayá chama cmatjátsënts̈amna? Acna nÿe s̈masto ca. ");
INSERT INTO kbh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chíyeca, chents̈ana, Jesucrístbeñe os̈buáchiyëngbenache nÿetscanga imojánichamo, chë uatsjendayá ndoñe yochanjanóbana ca. Pero Jesusna ndoñe chca tonjánayana, sinó “ats̈e quem luaroye jesabámëntscuana cha ainá chauesomñama ats̈e stsebos̈ëse, ¿aca ndayá chama cmatjátsënts̈amna? ca”. ");
INSERT INTO kbh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mua endmëna chë uatsjendayá; cha entsichamo quem soyënga ndegombre yojamnama, y camuá quem librë́s̈añe lempe tonjuábema. Y bënga mondë́tats̈ëmbo cha ndegombre soye endóyebuambnama. ");
INSERT INTO kbh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús inÿe ba soyënga tonjë́ftsema; ts̈a bëtscá soyënga endmëna, nderado lempe cada canÿe soye tcojuábema y librës̈angá tcojuapormá, ats̈e sëntsejuabná, nÿetsca chës̈angá quem luarents̈e ndoñe nanjuába.");
INSERT INTO kbh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ats̈be natsana librë́s̈añe tcbonjuábobema lempe nts̈amo Jesús tojanmama y tojánabuatambama, chca tojanbojats̈é orscana, ");
INSERT INTO kbh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","y Bëngbe Bëtsá celoye tbojtanatsbanantscuana. Cabá celoye ndëta orna, chë chabe ichmonëngcá tojanabacacá boyabásengna Jesús tojëftsanamëndá, chë Uámana Espíritbiajana, ndayá jamama yojánamnama. ");
INSERT INTO kbh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús cruciñe tojanóbana y tojtanayenents̈ana, ba soye chë ichmónënga yojánebëbuacana, chca, chënga jinÿanÿiyama cha ndegombre tojtanayenama. Canta bnë́tsana tentscuana cha yojánebëbuacana y Bëngbe Bëtsabe amë́ndayama chënga yojanabuatambá. ");
INSERT INTO kbh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Canÿe, Jesús chabe ichmónëngaftaca yojétsemna ora, mënts̈á tojanamëndá: —Jerusalenents̈ana ndoñe s̈matjábocana. Camuents̈e s̈mochjobátma, nts̈amo ats̈be Taitá tcmonjanas̈ebuachenacá chaóshjanguëntscuana, ndayama ats̈e tcbonjáuyana. ");
INSERT INTO kbh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ndegombre, Juan ents̈anga béjayeca tonjanëbaye; pero ndoñe baytesna, Bëngbe Bëtsá chë Uámana Espíritu bochanjíchmua, ts̈ëngaftangbe ainaniñe jtsemándayama cháuamashënguama ca. ");
INSERT INTO kbh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Canÿe, chë ichmónënga Jesúseftaca cánÿiñe imojtsemna ora, chënga tmojantjá: —¿César y chë Romoquëngbe amë́ndayents̈ana tas̈cochjatsebacá, y mora bënga, Israeloca ents̈anga, canÿe Rey quemochtsatsbomna ca? ");
INSERT INTO kbh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","As Jesús tojanë́yana: —Ts̈ëngaftanga ndoñe quecmátamna chë soyëngama jtsetats̈ëmbuana. Nÿe ats̈be Taitá aíñe; y cha, chabe obenánaca echanjamánda mocna ora y ndayté chca chaopasama. ");
INSERT INTO kbh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Chë Uámana Espíritu ts̈ëngaftangbe ainaniñe jtsemándayama chaojabo ora, ts̈ëngaftanga obenana s̈mochanjóyëngacñe. Chents̈ana, nts̈amo ats̈biama s̈motats̈ëmbcá, chë tcbonjabuatambá soyënga, ents̈anga s̈mochjáuyana Jerusalenents̈e, nÿets Judea luariñe, Samarioca y quem luarents̈a nÿets luarënguenáchnaca ca. ");
INSERT INTO kbh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chë soyënga tojánayanents̈ana y chabe uatsjéndayënga imojtsonÿaye ora, Bëngbe Bëtsá, Jesúsbioye tbojtanatsbaná y canÿe jants̈etëshe chábioye ibojútsbotse y ndoñe más tmonjanobená cha jinÿama. ");
INSERT INTO kbh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús celoye yojtsetsjuama chënga bën imojtserreparánëntscuana, nÿe ndeolpe, uta boyabásata uafjantse ents̈ayaca bopormánata chëngbe juachaca tbojabántsaye, ");
INSERT INTO kbh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","y chë́ngbioye tmojanë́yana: “Galileoca ents̈anga, ¿ndáyeca celoye s̈mojtsantjes̈ana? Jesús, chë ts̈ëngaftangaftaca enjamná celoye tontá y nts̈amo mora s̈monjinÿcá cha celoye jtama, cachcá quem luaroye cha echanjésabo ca.” ");
INSERT INTO kbh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jesusbe ichmónënga chë Olivos tjashocana Jerusalenoye tmojtaná. Chë tjocana Jerusalenóntscoñna bécoñe inamna, ndayë́ntscoca canÿe ochnayté jama yojanlesenciana nÿets̈á. ");
INSERT INTO kbh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalenoye tmojtanashjajna orna, chë yebnents̈a tsbanánoca tsoye tmojtanás̈ëngo. Chents̈e yojánatana Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago chë Alfeobe uaquiñá, Simón chë Celote ca uabobainá, y Judas, chë Santiagbe uaquiñá. ");
INSERT INTO kbh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chënga sempre imojanamana jtenefjnana Bëngbe Bëtsáftaca jencuéntama básefta shembásengaftaca, María Jesusbe mamá y Jesusbe cats̈átangaftaca. ");
INSERT INTO kbh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chë tempo tmojánenefjna canÿe patse y uta bnë́tsana Jesucrístbeñe os̈buáchiyënga, y canÿe, Pedro tojantsá y tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Jesucrístbeyeca ats̈be cats̈átanga, endánëyta nts̈amo Bëngbe Bëtsabe uabemana palabrënguiñe iuabemancá chaochnënguama, y tempo, David chë Uámana Espíritbeyeca chiñe tojanábema nts̈amo Júdaseftaca yochjanopásama; chcasna, Judas uayayënga tojanënatse Jesús chamuishachama. ");
INSERT INTO kbh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Júdasnaca bëngbe enutá enjamna y Jesús chábioynaca tbonjanábuayana bëngcá chabe trabajuiñe jtsoservénama. ");
INSERT INTO kbh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ts̈ëngaftanga s̈mondë́tats̈ëmbo, chë Judas bacna soye tojanmama tmojtanabuená crocenánacna fshantse tmojánbuamema. Chents̈ana cha tojtsanótsats̈e y chabe bests̈as̈e tsëntsaca tbojtsanashtë́ts̈ena y chabe uafsbents̈ana nÿetsca chabe chunchullëjuangá tojtsanáshana. ");
INSERT INTO kbh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalenents̈e oyenënga chë soyama tmojántats̈ëmbona ora, chë fshantse chëngbe biyañe Acéldama ca tmojanabaye. Acéldama endayana ‘Buiñe Luare ca’. ");
INSERT INTO kbh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Salmos librë́s̈añe, Jesucristo uayayëngbe cucuats̈iñe boshjuanabiama mënts̈á enduábemana: Chabe yebna énañe chaotsemna y ndocná chents̈e chaondëtsiyena ca. Y mënts̈ánaca endayana: Chabe cuenta inÿa chabe trabajo chaoma ca. ");
INSERT INTO kbh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Chcasna, mora muents̈e montsemna taitanga bë́ngaftaca mondenutënga, Bëngbe Utabná Jesús bë́ngaftaca enjamnëntscuana, ");
INSERT INTO kbh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan Jesúsbioye tbonjanabaye orscana y Bëngbe Bëtsá Jesúsbioye bë́ngbents̈ana celoye tbontanatsbanantscuana. Y mora s̈ontsamna canÿa mënguents̈á juabuáyanama, Jesús tojtanayenama ents̈ángbioye bë́ngaftaca jábuayenama ca.” ");
INSERT INTO kbh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","As chora útata tmojanabocacá: José, nda Barsabás ca imojanábobuatma y ínÿengna Justo ca; y chents̈ana Matías. ");
INSERT INTO kbh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chora Bëngbe Bëtsáftaca mënts̈á tmojanencuentá: “Bëngbe Utabná, aca nÿetscangbe ainana icuabuatma; chcasna, s̈minÿanÿé nda quem útatents̈ana cochjuábuayanana, ");
INSERT INTO kbh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","canÿe ichmonacá Júdasbe cuenta chaotrabajama. Judas ya ndoñe canÿe ichmoná quenátsmëna, bacna soye tojama causa, y cha mora yojtsemna chë ndayents̈e jtsemnama ibomna luaroca ca” —chënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Y nda chë ichmoná yochtsemnama jtsotats̈ëmbuamna tsbanánoye tmojanë́ts̈ena y Matías tbojanobuache; as cach orscana, Jesucrístbeñe os̈buáchiyënga chabiama imojanjuabná mo canÿe Jesusbe ustonacá, cachcá nts̈amo chë bnë́tsana canÿe uatsjéndayëngbiama chënga imojanjuabnacá. ");
INSERT INTO kbh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés ca uabaina fiesta tojanobuache ora, chë jaja sananga tmojanobuátbanama fiesta te, Jesucrístbeñe os̈buáchiyënga nÿetscanga cánÿiñe canÿe luarents̈e imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ndeolpe, celocana mo canÿe jabuache binÿiëcá yojtsaishauenana y chca, ts̈a jabuache shauenanana tojanóshjango nÿets yebnents̈e, chënga imojtsetbiámanents̈e. ");
INSERT INTO kbh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Y chora bichtajënga mo iñeshcá yojónÿna y canÿánÿabeñe yojojátaye. ");
INSERT INTO kbh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Chca chë Uámana Espíritu tojánamashëngo chëngbe ainaniñe jtsemándayama; chora nÿetscanga tmojanonts̈é inÿets̈á biyangana, chënga tempo ndmabiyañe, nts̈amo chë Uámana Espíritu yojtsamcá chënga inÿets̈á chamotsebiyama. ");
INSERT INTO kbh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chë tempo Jerusalenents̈e imojtsemna ba judiënga, Bëngbe Bëtsá puerte adórayënga, nÿets luarëngocana áshjajnënga; chënga tmojánabo Bëngbe Bëtsá jëtschuayama. ");
INSERT INTO kbh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ents̈anga chë shauenanana tmojanuena ora, tmojanójoto y ndoñe imontsetáts̈ëmbo nts̈amo jtsejuabnayana ndayá yojtsopasánama, er chë inÿe luarocana áshjajnënga imojtsuenana chë Jesucrístbeñe os̈buáchiyënga inÿets̈á biyangana jtsóyebuambnayana, nts̈amo cada ona chënga imojanbiyacá. ");
INSERT INTO kbh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Chë soyëngama ents̈anga puerte imojenjnaná y mënts̈á imojtsenatsëtsnaye: “Chë chca montsóyebuambnanga Galileoquënga mondmëna. ");
INSERT INTO kbh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Chcase, ¿nts̈ámoyeca bënga imojtsobena chënga joyaunayana cach bënga mondëbiyacá ca? ");
INSERT INTO kbh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Muents̈e montsemna Partioquënga, Medioquënga, Elam, Mesopotamia y Judeoquënga, Capadocia, Ponto y Asia luaroquë́ngnaca, ");
INSERT INTO kbh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigioquënga, Panfilia, Egiptó y Libia, chë Cirene béconana luaroquënga. Báseftangna Romoquënga montsemna; ");
INSERT INTO kbh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","chë́ngbeñe nderado judiënga camuents̈e onÿnánënga, pero ínÿengna ndoñe, y chënga Bëngbe Bëtsá mondbétsatschuanaye cach nts̈amo chë judiënga monduamancá. Inÿengna Cretocana y Arabiocánënaca tmojabo. ¡Y bënga montsobena chë Galileoca judiënga joyaunayana Bëngbe Bëtsá bëts soyënga tojamama cach bënga mondëbiyacá ca!” —chë ents̈anga imojtsichamo. ");
INSERT INTO kbh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chë causa nÿetscanga imojtsenjnanaye y nts̈amo jtsejuabnayama ntsetats̈ëmbcá imojtsemna y imojtsentjanaye: “¿Ndayá chë soye yojtsayana ca?” ");
INSERT INTO kbh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero ínÿengna, chë soyëngama chë́ngbioye imojtsëbayajuana y imojtsichamo: “Chënga tëmiënga montsemna ca.” ");
INSERT INTO kbh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chents̈ana, Pedro tojantsá chë inÿe bnë́tsana canÿe ichmónëngaftaca y jabuache tojanonts̈é chë ents̈anga jáuyanana, mënts̈á: “Ats̈be ents̈anga judiënga y nÿetscanga Jerusalenents̈e oyenënga, ts̈abá s̈mochjouena. Nts̈amo tojopasama cbochanjábuayenaye, as chacmë́sertama. ");
INSERT INTO kbh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ts̈ëngaftanga s̈montsejuabná ats̈e y ats̈be enutënga tëmiënga fstsemna ca, pero ndegombre, tëmiënga ndoñe queftsátsmëna; cabá cachëse, base mos̈enana ora ctsomñe. ");
INSERT INTO kbh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pero nts̈amo entsopasánamna, Bëngbe Bëtsabe juabna oyebuambnayá Joel mënts̈á tojanábema: ");
INSERT INTO kbh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bëngbe Bëtsá mënts̈á tojánayana: ‘Quem luare jopochócama te chaojtsobeco ora, chë soyënga echanjochnëngo. Ats̈e chanjama, ats̈be Espíritu nÿetscangbe ainaniñe cháuamashënguama. Chents̈ana, ts̈ëngaftangbe uaquiñënga y bembianga ats̈be soyëngama ents̈anga mochantsë́tsëtsnaye; ts̈ëngaftangbe bobontsëngna, ats̈e chanjama soyënga mochantsonÿaye mo otjenayoquëcá; y ts̈ëngaftangbe bëtsëjémëngna ats̈be soyënga mochantsotjénaye. ");
INSERT INTO kbh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chca ora, ats̈e chanjama nÿetsca ats̈be oservénëngbiama, boyabásenga y shembásenga, chëngbe ainaniñe ats̈be Espíritu cháuamashënguama, as chënga ats̈be soyëngama ents̈anga mochantsë́tsëtsnaye. ");
INSERT INTO kbh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ats̈e chanjama bëts soyënga celoca; y quem luariñe echántsemna buiñe, íñeshe y ngona mo jants̈etëshcá, ats̈be obenana jinÿanÿiyama. ");
INSERT INTO kbh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cabá chë puerte uámana te, chë Bëngbe Utabná bëts soyënga jamama ndobuache ora, shinÿe ndoñe queochátsbuashinÿinÿana y juashcona buánganëtema mo buiñcá echántsemna. ");
INSERT INTO kbh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y as, ndánaca Bëngbe Utabná tbojtsots̈ëmbuaná, cha bochanjatsbocá.’ Chca Joel tempo tojanábema ca” —Pedro tojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Chora Pedro tojatanë́yana: “Israeloquënga, s̈mochjouena nts̈amo cbochanjauyancá: Bëngbe Bëtsá ndegombre tcmonjaninÿanÿé, Jesúsbioye chabe trabajo biamnayá cha tbojánbemama. Chë soye Bëngbe Bëtsá tcmonjaninÿanÿé, Jesús chë Nazaretocáftaca cha tojanma bëts soyë́ngaca y ójnanana soyë́ngaca, Bëngbe Bëtsabe obenana jinÿanÿiyama. Cach ts̈ëngaftanga chë soyëngama s̈mondë́tats̈ëmbo, Bëngbe Bëtsabe obenánaca chë soyënga ts̈ëngaftangbeñe Jesús tonjánmayeca. ");
INSERT INTO kbh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ndegombre ts̈ëngaftangbe cucuats̈iñe Jesús tmonjánboshjona, pero cabá ndë́boshjona ora, Bëngbe Bëtsá tojanjuabó nts̈amo jopásana yojamnama; y nts̈amo ts̈ëngaftanga cháftaca s̈mochjanmámnaca cha inatáts̈ëmbo. Ts̈ëngaftangna Jesús s̈monjanishache y s̈monjanma cha chamóbama y chamocrucificama, bacna ents̈angbe cucuats̈iñe. ");
INSERT INTO kbh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Bëngbe Bëtsá tojama cha cháuatayenama; y chë obanëngbe luarents̈ana tbojatsbocá, er ndoñe yonjopodena cha obaná chaoquedama ca” —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chora Pedro tojatanë́yana: “Rey David tempo Jesusbiama mënts̈á tojë́ftsanabema, nts̈amo cha Bëngbe Bëtsábioye tbojaniyanama: Ats̈be Utabná, aca sempre áts̈eftaca condbétsemna, y sempre áts̈eftaca condboquedá ats̈e juajabuáchama, chíyeca ndocná queochatobenaye ats̈e jauátjanama. ");
INSERT INTO kbh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chíyeca ats̈e corente oyejuayá së́ntsemna, y ats̈be uayás̈aca cbontsatschuaná. Ats̈e masque chanjóbana, ts̈abá sëndë́tats̈ëmbo aca ats̈be Bëtsá, ats̈e chaitayenama cochjamama. ");
INSERT INTO kbh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aca, Bëngbe Bëtsá, obanëngbe luarents̈e ndoñe ques̈cochátsboshjona, y ndoñe quecochatsleséncia acbe uámana oservenabe cuerpo chaotsopochocama. ");
INSERT INTO kbh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Aca chë ts̈abe benache s̈conjaninÿinÿé, nts̈amo ts̈abe vida jtsebomnama. Aca áts̈eftaca condbétsemnama, ats̈e puerte oyejuayá së́ntsemna ca —David tojë́ftsanabema ca.” ");
INSERT INTO kbh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Chents̈ana Pedro tojatanë́yana: “Baconga y batanga, s̈ontsemna ndegombre ts̈ëngaftanga jábuayenana ts̈abá chacmë́sertama. Bëngbe tempsca bëts taitá David tojanóbana y tmojanatbontsá, y bënga montsemna cha tmojanatbontsá luare béconana. ");
INSERT INTO kbh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Cach David canÿe Bëngbe Bëtsabe juabna oyebuambnayá inamna. Cha ts̈abá inatáts̈ëmbo Bëngbe Bëtsá bëtscá tbojans̈buáchenama, Davidbe ents̈anguents̈ana canÿa, Cristo, cach Davidcá rey jabemama. ");
INSERT INTO kbh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David inatáts̈ëmbo chë Uámana Uabuayaná, chë Cristo, cháuatayenama Bëngbe Bëtsá yochjanmama. Chama cha tojánayana y tojë́ftsanabema, obanëngbe luarents̈e Cristo ndoñe ntjëftseboshjonana y Bëngbe Bëtsá ndoñe ntjalesénciana chabe cuerpo chaotsopochocama ca. ");
INSERT INTO kbh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bëngbe Bëtsá tojama Jesús cháuatayenama y bënga cha fsënjinÿe. Chíyeca bënga fsë́ntsetats̈ëmbo chca ndegombre bétsemnama. ");
INSERT INTO kbh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bëngbe Bëtsá, Jesús celoye tbontanatsbaná chabe cats̈bioica jtsatsmënama jtsemándayama, y Bëngbe Bëtsá chë Uámana Espíritu Jesúsbioye tbojanënts̈abuaché nts̈amo chë Taitá tbojans̈buachenacá. Nts̈amo ts̈ëngaftanga s̈montsonÿá y s̈montsuenancá entsemna, Jesucrístoftaca chë Uámana Espíritu bëngbe ainaniñe cháuamashënguama Bëngbe Bëtsá tojámayeca. ");
INSERT INTO kbh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David ndoñe Jesuscá celoye tonjána, pero mënts̈á tojëftsanábema: Bëngbe Bëtsá ats̈be Utabná Crístbioye tbonjaniyana: ‘Ats̈be cats̈bioica cochtsetbemana, ");
INSERT INTO kbh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","acbe uayayënga acbe cucuats̈iñe chamoquedama ats̈be obenánaca chjamëntscuana ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Chora Pedro tojatanë́yana: “Ts̈ëngaftanga nÿets Israeloquënga s̈mochtsetáts̈ëmbo, ats̈e ndegombre cach Jesusbiama sëntsóyebuambnama. Cha ts̈ëngaftanga s̈monjancrucificá, pero Bëngbe Bëtsá chábioye tbonjábema Bëngbe Utabná y chabe Uámana Uabuayaná, chë Cristo ca.” ");
INSERT INTO kbh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chë soyënga tmojanuena ora, ents̈anga cochtsets̈enánënga imojtsemna, y Pedro y chë inÿe ichmónëngbioye tmojanë́yana: —Baconga, ¿ndayá mora jamama s̈ojtsamna ca? ");
INSERT INTO kbh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","As Pedro tojanë́jua: —Ngménaca s̈mochtenójuaboye bacna soyënga s̈mojtsamama, chca amana s̈mochtsajbaná y Bëngbe Bëtsabe benache s̈mochtishache. Chca chas̈mojama ora, cbochanjubaye mo chábeñe os̈buachiyëngcá, Jesucristo ats̈e jóts̈ëmbonëse. Chcase, Bëngbe Bëtsá ts̈ëngaftangbe bacna soyëngama cmochanjáperdonaye y echanjama chë Uámana Espíritu ts̈ëngaftangbe ainaniñe jtsemándayama cháuamashënguama. ");
INSERT INTO kbh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bëngbe Bëtsá chë soyënga tcmonjanas̈ebuachená ts̈ëngaftangbiama, ts̈ëngaftangbe básengbiama y nÿets chë bën luarënguenache imomna ents̈angbiama, nÿetscanga chë Bëngbe Utabná Bëngbe Bëtsá chábioye jabama chaojubuáyanënga ca. ");
INSERT INTO kbh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Inÿe palabrë́ngnaca Pedro tojatanë́yana y bëtscá tojanabuayená mënts̈á: “¡Bëngbe Bëtsá chë Israeloca bacna ents̈anga echanjácastigaye. Chas̈mótsbocamna, chë́ngbents̈ana s̈mochtsojuánañe ca!” ");
INSERT INTO kbh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba ents̈anga imojtsanos̈buaché nts̈amo Pedro tojanë́yanama y tmojánenabaye. Cach te mo unga uaranga ents̈anga nÿets̈á tmojanoboté, Jesucrístbeñe os̈buáchiyënga jtsemnama. ");
INSERT INTO kbh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chënga corente imojtsebos̈e jtsamama chë Jesusbe ichmónënga imojtsabuatambá soyënga. Ts̈abá yojtsacochebiona nÿetscanga cánÿiñe jtsemnama y imojanamana mo chë Jesucrístbeñe os̈buachiyëngcá cánÿiñe jtsesayana y cánÿiñe Bëngbe Bëtsáftaca jtsencuéntayana. ");
INSERT INTO kbh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nÿetscanga imojtsenjnanaye, chë ichmónënga bëts soyënga y inÿe soyënga chabe obenana jinÿanÿiyama chamomama Bëngbe Bëtsá tojánmayeca. ");
INSERT INTO kbh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nÿetsca chë Jesucrístbeñe os̈buáchiyënga sempre cánÿiñe mo canÿacá imojtsemna y nÿetsca chëngbe bomna soyënga nÿetscangbiama yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Chënga imojanamana fshantsënga jtsatobuíyana y chë imojánbomna soyë́ngnaca, y chë crocénana jujátayana nts̈amo chë ínÿenga tojtsëjabotcá. ");
INSERT INTO kbh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada te imojanamana Bëngbe Bëtsabe bëts yebnents̈e jénefjnana cha jëtschuayama, y yebnënguenache cánÿiñe imojtsesaye oyejuayënga y ndoñe ojéndayënga. ");
INSERT INTO kbh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Chënga imojanamana Bëngbe Bëtsá jtsatschuanayana, y nÿetsca ents̈anga imojtsejuabnaye chë Jesucrístbeñe os̈buáchiyëngbiama ts̈abe ents̈anga imojamna ca. Y cada te Bëngbe Bëtsá yojtsama más os̈buáchiyënga chamóbotema, chë ndëmuanÿenga cha yojtsatsebacayënga. ");
INSERT INTO kbh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Canÿe te, Pedro y Juan Bëngbe Bëtsabe bëts yebnoye tbojánata bëts mos̈enana ora. Chca ora ents̈anga imojanamana Bëngbe Bëtsáftaca jtsencuéntayana. ");
INSERT INTO kbh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bëngbe Bëtsabe bëts yebnents̈e canÿe cosheto yojtsemna; tojanonÿná orscana chca s̈ocá inamna. Ents̈anga imojanamana cada te cha juanatsana canÿe luaroye, Bëngbe Bëtsabe bëts yebnoca, Botamana Amashjuana ca uabáinoye, chë tmojtsachnëjuanënga lemos̈na chaótejañama. ");
INSERT INTO kbh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro y Juan Bëngbe Bëtsabe bëts yebnoye jamashënguama chë cosheto tojánanÿe ora, canÿe lemos̈na chátbioye yojótejañe. ");
INSERT INTO kbh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chatna chë s̈ocá imojtsonÿaye, y Pedro tbojaniyana: “S̈cochtsë́nÿaye ca.” ");
INSERT INTO kbh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","As cha yojtsë́nÿaye y yojtsejuabnaye ndayá chjóyëngacñe ca. ");
INSERT INTO kbh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Chora Pedro tbojaniyana: “Quetsátsbomna ni crocénana, ni castellano aca jats̈etayama, pero ats̈e chanjama Jesucristbe obenánaca ndayá acbiama jamama ats̈e stsobencá: Jesús chë Nazaretocá obenana endbomna; chíyeca ats̈e cbëyana chabe mándoca, matëtsbaná y cochtsana ca.” ");
INSERT INTO kbh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro chca tbojaniyana ora, tbojanábuacueshache cats̈bióicats̈e y tbojtanatsbaná, y cachora chë cosheto shecuats̈iñe y shëmiabeñe añemo yojtsatsbomna. ");
INSERT INTO kbh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","As chë cosheto, canÿe jontsënjëse ts̈abá tojtantsá y tojanonts̈é ts̈abá jtsanana, y Bëngbe Bëtsabe bëts yebnoye Juan y Pédroftaca tojánamashëngo; yojtsayontsënjnaye y Bëngbe Bëtsá ibojtsatschuanaye, tbojanshnama. ");
INSERT INTO kbh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chë Bëngbe Bëtsabe bëts yebnents̈e imojétsemnënga nÿetscanga cha tmojáninÿe ts̈abá jtsanana y Bëngbe Bëtsá jtsatschuanayana. ");
INSERT INTO kbh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Chënga imnatáts̈ëmbo cha chë cosheto yojamnama, chë nda yojanamana Bëngbe Bëtsabe bëts yebnoca, chë Botamana Amashjuanents̈e jótbemana, ents̈anga lemos̈na jotejañama. Cha ts̈abá yojtsatsmënamna ents̈anga ojnanánënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chë cosheto ya shnaná ora, ndoñe yontsebos̈e Juan y Pédrëbents̈ana joluárana. As, nÿetsca ents̈anga ojnanánënga tmojanótjajo chë amashjuana otsbojebniñe, Salomonbe Amashjuana ca uabáinoye, chë Juan, Pedro y chë cosheto shnaná imojétsemnoye. ");
INSERT INTO kbh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro chë ents̈anga tojánanÿe ora, tojanë́yana: “Taitanga y mamanga, Israeloquënga, ¿ndáyeca chë soyëngama ojnanánënga s̈mojtsemna? ¿Ndáyeca nÿe s̈cojtsëbuáutja? ¿S̈mojtsejuabná nÿe bëndatbe obenánaca quem boyabása tifjashná ca? ¿O s̈mojtsejuabná quem boyabása tifjashná bëndata Bëngbe Bëtsá puerte ts̈abá ftsadoránayeca? ");
INSERT INTO kbh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bëngbe Bëtsá, ndábeñe Abraham, Isaac y Jacob imojanos̈buaché y ndábeñe bëngbe bëts taitanga imojanos̈buaché, cha tonjinÿanÿé chabe oservená Jesús chë más uamaná yomnama. Cha ts̈ëngaftanga chë mándayëngbe cucuats̈iñe s̈monjánboshjona chamóbama. Pilato enjétsebos̈e Jesús jëtsboshjonama, pero ts̈ëngaftanga Pilatbe delante s̈monjánayana chca ndoñe s̈montsanbos̈e ca, y chíyeca Pilato ndoñe tbontanboshjona. ");
INSERT INTO kbh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús uamaná y nÿetsca soyënguiñe ts̈abá amá enjamna, pero ts̈ëngaftangna cha s̈montsanaboté y Pilato s̈monjanimpadá chabe cuenta canÿe boyabása, ents̈á obanayá, chabuatsboshjonama. ");
INSERT INTO kbh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Y chca, chë ndegombre ts̈abe vida chas̈motsebomnama amábioye ts̈ëngaftanga s̈monjanóba. Pero Bëngbe Bëtsá tojanma cha cháuatayenama y bënga chë soye fsënjáninÿe y chama fsëndë́tats̈ëmbo. ");
INSERT INTO kbh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesús puerte obená endmë́nayeca, quem cosheto añémoca entsatsmëna. Nts̈amo s̈monjinÿe y s̈monjatats̈ëmboncá ndegombre tonjopasá Jesúsbeñe betsos̈buáchema. Chë Jesúsbeñe jtsos̈buáchiyana tonjama cha ts̈abá ts̈ëngaftangbeñe chaotsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Taitanga y mamanga, ats̈e sëndë́tats̈ëmbo ts̈ëngaftangbe causa y ts̈ëngaftangbe amë́ndayëngbe causa Jesús tojanóbanama. Pero ts̈ëngaftanga chca s̈mojanma, ndayá s̈mojétsamama ntsetats̈ëmbcá. ");
INSERT INTO kbh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tempo, Bëngbe Bëtsá chë chabe juabna oyebuambnayënga tojanamëndá ents̈anga jábuayenama, chë Bëngbe Bëtsabe Uámana Uabuayaná puerte ngménana yochtsanbomnama. Morna, nts̈amo Bëngbe Bëtsá tojanayancá ya tonjochnëngo. ");
INSERT INTO kbh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chcasna, ngménaca menójuabonga bacna soyënga s̈mojtsamama, chca amana s̈mochtsajbaná y Bëngbe Bëtsabe benache s̈mochtishache, chca, ts̈ëngaftangbe bacna soyënga cha chacmabuajuánama. Chca chas̈mojamëse, Bëngbe Bëtsá echanjama ts̈ëngaftangbe ainaniñe oyejuayana chas̈motsóbomñama, ");
INSERT INTO kbh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","y ts̈ëngaftangbioye bochanjíchmua Jesús, chë tempo chabe Uámana Uabuayaná Bëngbe Bëtsá tbojanbemá. ");
INSERT INTO kbh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Canÿe te echanjóshjango, Bëngbe Bëtsá lempe tsmëmacá jëtsbemama. Chë tentscuana Jesús bontsemna celoca joquédana. Chca echanjochnëngo nts̈amo Bëngbe Bëtsá chabe juabna oyebuambnayëngbiajana ents̈anga tojanabuayenacá. ");
INSERT INTO kbh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés bëngbe bëts taitanga tojanabuayená: ‘Chë Utabná Bëngbe Bëtsá canÿe chabe juabna oyebuambnayá nts̈amo ats̈e sëndmëncá, cmochanjayents̈íchmua. Cha ts̈ëngaftangbents̈ana echanjábocna y ts̈ëngaftanga cmontsamna nts̈amo chacmojtsëtsëtsnacá cha jtseyeunanana. ");
INSERT INTO kbh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ndánaca chábioye ndoñe chabonjoyeuná, cha bontsemna chë Bëngbe Bëtsabe ents̈ángbents̈ana luaroca jtsemnama y chamotsepochocama ca’ —cha tojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Y nÿetsca chë Bëngbe Bëtsabe juabna oyebuambnayë́ngnaca Samuel orscana, ents̈anga tmojanabuayená ndayá quem tempo yochjanchnënguama, nts̈amo mora montsonÿacá. ");
INSERT INTO kbh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chabe juabna oyebuambnayë́ngaftaca Bëngbe Bëtsá tojanas̈ebuachená bëts soyënga ts̈ëngaftangbiama, y ts̈ëngaftangbe bëts taitángaftaca canÿe trato tojánbema; chë soyënga cabá ts̈ëngaftangbiama entsemna. Bëngbe Bëtsá Abrahámbioye mënts̈á tbojaniyana: ‘Chë ácbents̈ana ents̈ángbeyeca ts̈abe bendicionënga chanjama nÿetsca quem luarents̈a ents̈angbiama ca.’ ");
INSERT INTO kbh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bëngbe Bëtsá tojama chabe oservená cháuatayenama y natsana ts̈ëngaftangbioye tbojanichmó, bacna soyënga amana chas̈motsajbanama. Y chca, Bëngbe Bëtsá jamama ts̈ëngaftangbeñe ts̈abe bendicionënga chaotsemnama ca” —Pedro tojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro y Juan cabá ents̈anga imojtsë́tsëtsnaye; chorna chë chata ibojtsemnoye tmojánashjajna judiëngbe bachnanga, Bëngbe Bëtsabe bëts yebnents̈a soldadëngbe amëndayá y saduceo ca uabaina judiëngbe amë́ndayënga. ");
INSERT INTO kbh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Chatna ents̈ángbioye imojtsabuátambaye Jesús tojtanayenama y chë soye yojánayana obanënga ndegombre mochtayena ca. Chë causa, chë tmojánashjajna amë́ndayënga tojánetëna. ");
INSERT INTO kbh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","As, Pedro y Juan tmojánishëche y ya jetiñe yojtsemna causa, cárceloye tojanëtame yëfsanëntscuana. ");
INSERT INTO kbh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Masque chca, banga ents̈anguents̈ana, nts̈amo Pedro y Juan tbojanayancá tmojanuenënga, aíñe Jesucrístbeñe imojtsos̈buáchiye. Chë tentscuana shachna uaranga Jesucrístbeñe os̈buáchiyënga imojtsemna, nÿe boyabásenga jacuéntase. ");
INSERT INTO kbh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yëfsana, chë judiëngbe amë́ndayënga, judië́ngbeñe bëtsëjemëngcá amë́ndayënga y ley abuátambayënga Jerusalenents̈e tmojánenefjna. ");
INSERT INTO kbh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chénts̈naca imojtsemna, chë bachnangbe más uámana amëndayá Anás ca uabainá, Caifás, Juan, Alejandro y chë bachnangbe más uámana amë́ndayëngbe nÿetsca pamíllangnaca. ");
INSERT INTO kbh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chora chënga tmojanmandá Pedro y Juan junatsama, y chëngbe tsëntsaca tojanatsá y mënts̈á tmojanatjá: —¿Ndabe obenánaca chë soyënga s̈ojtsama, o, nda derecho tcmënjats̈atá chë soyënga chas̈otsamama ca? ");
INSERT INTO kbh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","As Pedro, chë Uámana Espíritu chabe ainaniñe corente jtsemándayëse, mënts̈á tojanë́jua: —Israeloca mándayënga y bëtsëjémënga, ");
INSERT INTO kbh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mënté s̈conjatjá chë jama ndobenáftaca ts̈abe soye tifjamama y nts̈amo cha mora jama yojtsatobenama. ");
INSERT INTO kbh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chcasna, nts̈amo tojopasama cbochanjabuayená, chca, ts̈ëngaftanga y nÿetsca Israeloca ents̈anga chë soyënga chas̈motsetats̈ëmbuama. Quem boyabása, chë ts̈ëngaftangbe tsëntsaca entsemná, Jesucristo chë Nazaretocabe bëts obenánaca chca ts̈abá entsatsmëna. Y Jesús endmëna nda ts̈ëngaftanga s̈monjancrucificá y ndabiama Bëngbe Bëtsá tojanma cháuatayenama. ");
INSERT INTO kbh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesusbiama Bëngbe Bëtsabe uabemana palabrënguiñe mënts̈á endayana: “Chë yebna jebuanënga tmontsanaboté ndëts̈bé, mora chë más bëts uashacuanës̈ents̈e entsejájona ca”. Ts̈ëngaftanga s̈mondmëna mo chë yebna jebuanëngcá, er Jesúsbioye s̈montsanaboté y mora cha chë más uamaná entsemna. ");
INSERT INTO kbh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nÿe cha yobena ts̈ëngaftanga játsebacama. Bëngbe Bëtsá ndocna inÿe ents̈ábioye tbonjats̈etá chabe obenana chca jamama; chíyeca quem luarents̈e ndocná más quenátobena bënga játsebacama. Nÿe Jesucristbe obenánaca aíñe ca —Pedro tojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chënga imojenjnaná Pedro y Juan ts̈a añémoca ibojtsóyebuambnama tmojáninÿe ora, y chata tempo nduatsjínÿenata y librë́s̈a nduabuatmata bétsemnama tmojántats̈ëmbona ora. Chca chë mándayënga tmojántats̈ëmbona chata Jesúseftaca bayté ibojamnama. ");
INSERT INTO kbh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Y ents̈anga imojtsonÿaye chë tmojanshná cha chents̈e chátaftaca yojtsemnama; chë causa, chënga ndocá más tmonjanobená chatbe contra jatichámuana. ");
INSERT INTO kbh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","As chora tmojanamëndá chents̈ana chábuaisebocnama y chents̈e tmojanoquedangna chë soyama imojtsenatsëtsnaye. ");
INSERT INTO kbh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Chënga imojtsentjanaye: “¿Ndayá chátaftaca mochjama ca? Jerusalenents̈e oyenënga montsetáts̈ëmbo chata chë bëts soye Bëngbe Bëtsabe obenánaca tbojamama; chë causa, bënga ndoñe quemuátobena jayanana chata chca ndoñe tbonjama ca. ");
INSERT INTO kbh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero ents̈anga chama ndoñe más chamondëtsencuéntamna, chata mochjáuyana: ‘Ndoñe más ents̈ángbeñe Jesús s̈mattsebáyana; y ndoñe chas̈monjouenëse, jabuache castigo s̈ochántsebomna ca.’ ” ");
INSERT INTO kbh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","As chë mándayënga cachiñe chata tmojánachembo y tmojanamëndá ndoñe más Jesús jtsebáyanana, ni chabiama ents̈ángbeñe jtsabuátambayana. ");
INSERT INTO kbh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedro y Juan tbojánayana: “¿Nts̈amo ts̈ëngaftanga s̈matjayana nts̈amo fchanjayanama ca? Ndegombre, Bëngbe Bëtsabe bominÿiñe ndoñe ts̈abá quenátsmëna ts̈ëngaftangbioye aíñe joyaunayana y chábioye ndoñe. ");
INSERT INTO kbh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Er bënga queftsátobena jtsajbanana oyebuambnayana chë tifjinÿe y tifjouena soyëngama ca.” ");
INSERT INTO kbh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Chë mandayëngna chátbioye tojtsanautatjá, pero chents̈ana tmojtanabáshejuana. Nÿetsca ents̈anga Bëngbe Bëtsá imojtsatschuanaye nts̈amo tojanopasama; chíyeca, chë mándayënga ndoñe tmonjanobená tondaye ntjinÿenana nts̈amo chata jácastigama. ");
INSERT INTO kbh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Chë boyabása, ndáftaca chata chë bëts soye Bëngbe Bëtsabe obenánaca tbojanma, inabomna canta bnë́tsana uatama más. ");
INSERT INTO kbh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro y Juan ya tmojtanabáshejuana ora, tbojánata chë inÿe os̈buáchiyëngaftaca jateninÿenama y lempe nts̈amo chë bachnangbe amë́ndayënga y bëtsëjemëngcá mándayënga chátbioye tmojanëyancá, chë́ngbioye tmojanacuntá. ");
INSERT INTO kbh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chënga chca tmojanuenents̈ana, nÿetscanga cánÿiñe tmojanonts̈é Bëngbe Bëtsáftaca mënts̈á jencuéntama: “Bëngbe Utabná, aca chë nda tojama celoca, fshantse, nÿetsca béjayënga y lempe nts̈amo chenache yomncá, ");
INSERT INTO kbh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","chë Uámana Espíritbiajana tcojánayana y acbe oservená David, nts̈amo tcojanayancá tojanábema, mënts̈á: ¿Ndáyeca ents̈anga yapa imojtsets̈átjaye ca? ¿Ndáyeca imojtsejuabná nÿe bonamentiama soyënga jamana? ");
INSERT INTO kbh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Quem luarents̈a reyënga y amë́ndayënga imoprontánënga, nÿetscanga tmojenoyeuná Bëngbe Bëtsá y chabe Uámana Uabuayaná chë Cristbe contra jtsemnama ca —cha tojanábema. ");
INSERT INTO kbh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ndegombre chca tonjopasá. Rey Herodes y Poncio Pilato, quem bëts pueblents̈e, ndoñe judië́ngaftaca y israelitë́ngaftaca tmonjánenefjna, jenóyeunayama nts̈amo jamana, Jesús chë acbe uámana oservená y chë Uámana Uabuayaná tcojabemábioye jóbama. ");
INSERT INTO kbh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tempo, Bëngbe Bëtsá, acbe obenánaca y nts̈amo icnabos̈cá tcojanmandá nts̈amo mora chaotsemnama, y chënga chca Jesúseftaca tmonjama. ");
INSERT INTO kbh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Morna Bëngbe Bëtsá, mouena nts̈amo chënga montsichamo, bënga jasúfriama cas̈ojtsamna ca; chcasna, cochjama bënga fchayobená Jesusbe ts̈abe noticiënga bëts añémoca ents̈ángbeñe jtsóyebuambnayama, ");
INSERT INTO kbh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","y cochjama acbe obenánaca s̈oquënga ts̈abá chamotsatsmënama y cochjama bënga fchayobená bëts soyënga jamama, Jesús chë uámana oservenabe obenánaca y cha jóts̈ëmbonëse ca” —chënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bëngbe Bëtsáftaca jencuéntama tmojanpochocá orna, chë tmojánenefjnents̈e tojanangmë́mana; y nÿetscangbe ainaniñe chë Uámana Espíritu tojanonts̈é más jtsemándayana, y chënga tmojanonts̈é más añémoca Bëngbe Bëtsabe soyëngama ents̈anga jábuayenama. ");
INSERT INTO kbh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesucrístbeñe os̈buáchiyënga, nÿetscanga canÿe juabna imojtsebomna y ainaniñe cach canÿe ebionana. Ndocná ntjatichamuana chabe soyënga nÿe chabiama yojtsemna ca, pero aíñe imojtsichamo, “ats̈e së́ndbomna soyënga nÿetscangbiama entsemna ca”. ");
INSERT INTO kbh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Chë Jesusbe ichmónëngna puerte obenánaca mënts̈á imojtsichamo: “Fsënjinÿe y fsë́ntsetats̈ëmbo Bëngbe Utabná Jesús obanënguents̈ana tojtayenama ca.” Y Bëngbe Bëtsá yojtsama chë ichmónënga bëtscá ts̈abe bendicionënga chamotsebomnama. ");
INSERT INTO kbh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jesucrístbeñe os̈buachiyë́ngbeñe ndocná yonjamna ndayánaca uajabotá, er nÿetscanga fshantse o yebna bomnënga imojanamana jtsatobuíyana, y chë crocénana ");
INSERT INTO kbh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","chë ichmónëngbioye jayents̈buáchiyana, nts̈amo tojtsëjabotcá nÿetscanga jujátayama. ");
INSERT INTO kbh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chca tojanma canÿa Bëngbe Bëtsabe bëts yebnoca trabajayá, José ca uabainá; cha chë ichmónënga imojanábobuatma Bernabé ca (y chca iuayana “Añemuayá ca”). Bernabé yojamna Chipre luarocá. ");
INSERT INTO kbh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chana, fshantse yojtsatobuiye, y chë crocénana Jesusbe ichmónëngbioye yojáyents̈buachiye, chë uajabótëngbiama chaoservema. ");
INSERT INTO kbh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Inamna canÿe bacó, Ananías ca uabainá, y chabe shemna, Safira ca. Chatna canÿe fshantse tbojániye. ");
INSERT INTO kbh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías y Safirna tbojanenóyeunata; chcasna, bats̈á crocénana cachatbiama tbojanobuajó y chë tojanójama crocénana ichmónëngbioye Ananías tojanamba, pero tojanë́yana chana canjamna nÿets crocénana ntsachets̈á chë fshantsama tbojanosháchiñe ca. ");
INSERT INTO kbh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","As Pedro tbojaniyana: “Ananías, ¿ndáyeca tcojalesenciá Satanás acbe ainaniñe bacna juabnënga chacmócochënguama, Uámana Espíritu chë crocenánama jabuambayama ca? Acna chë fshantsama tcmojtabuená crocenánents̈ana cach acbiama bats̈á tcontábojama. ");
INSERT INTO kbh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Cabá ntsatobuiye ora, chë fshantse ácbeshe endánmëna y tcojtsatobuíyents̈ana chë crocénana acbiana y chánaca condánobena nts̈amo tcojtsebos̈cá jamama. ¿Ndáyeca acbe ainaniñe tcojajuabó chë crocenánama chca jobostérama? Chca jamëse, ndoñe nÿe ents̈ángbioye quecatabuambná, sinó Bëngbe Bëtsánaca ca” —Pedro tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías chë palabrënga tojanuena ora, obaná tojánshajaye. Y nÿetscanga chama tmojántats̈ëmbonënga corente imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Chents̈ana, básefta bobontsënga tmojánashjajna y Ananíasbe cuerpo ents̈ë́juaca tmojanandmaná y jauátbontsama tmojanamba. ");
INSERT INTO kbh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mo unga horëntscose, Ananíasbe shema Safira tojánashjango, pero ndoñe yontsetáts̈ëmbo nts̈amo chabe boyáftaca tojanopasama. ");
INSERT INTO kbh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chora Pedro tbojantjá: —Ndegombre s̈mëyana, ¿chë s̈monjayana nÿets̈nama chë fshantse s̈mojiye ca? As chë shema tbojanjuá: —Aíñe, nÿets̈nama fsënjiye ca. ");
INSERT INTO kbh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro tbojaniyana: —¿Ndáyeca tsëndata s̈ojenoyeuná Bëngbe Utabnabe Espíritu jabuambayama, y cabá castigo jtsebomnama ndoñe s̈ontsobatmana ca? Acbe boyá jauátbontsama tmonjuambënga muents̈e bës̈oca montsemna y mora ácnaca cmochanjuamba ca. ");
INSERT INTO kbh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cachora Safira Pédrëbe shecuats̈ents̈e obaná tojánshajaye. Chë bobontsënga tmojtanamáshjna ora, obaná Safira tmojáninÿena; asna, chents̈ana tmojanamba y cachabe boyabe juachaca tmojanatbontsá. ");
INSERT INTO kbh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y nÿetsca Jesucrístbeñe os̈buáchiyënga chents̈e imojtsemnënga y nÿetscanga chë soye tmojántats̈ëmbonënga, corente imojtsauatja. ");
INSERT INTO kbh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chë Jesucristbe ichmónëngaftaca ba bëts soyënga ents̈ángbeñe yojtsebinÿna Bëngbe Bëtsabe obenana jinÿanÿiyama; y nÿetsca Jesucrístbeñe os̈buáchiyënga imojanamana Bëngbe Bëtsabe bëts yebnoca jénefjnana, Salomonbe Amashjuana otsbojebnents̈e. ");
INSERT INTO kbh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Chë ínÿenga, chë Jesucrístbeñe ndos̈buáchiyëngna, imojtsauatja Jesucrístbeñe os̈buáchiyëngaftaca jtsenutana; pero ents̈angna chë os̈buáchiyëngbiama ts̈abá imojtsencuéntaye. ");
INSERT INTO kbh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bëngbe Utabnábeñe os̈buáchiyënga más imojtsóbotena, bëtscá boyabásenga y shembásengnaca. ");
INSERT INTO kbh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ts̈a bëts soyënga chë ichmónëngaftaca yojtsebinÿna; chíyeca ents̈anga imojanamana jutsnëshangañe y tjuashënguiñe tsáshenoye s̈oquënga jubuacnana, chca, Pedro chëjana tojtsachnëjuana ora, nÿe mo chabe sómbrënaca chëngbe cuerpëjana chaochnënguama, shnánënga jtsatsmënama. ");
INSERT INTO kbh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalén chábuañe pueblënguents̈ana ba ents̈anga imojanamana jabana, y s̈oquënga y bacna bayëjbe juabna uambayënga imojtsëyabó; y nÿetscanga shnánënga imojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chë ichmónënga ts̈a ts̈abá imojtsamama, chë judío bachnangbe más uámana amëndayá y chabe ústonënga, chë saduceunga, puerte envidia imojtsebomna. ");
INSERT INTO kbh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","As chë ichmónëngbioye tmojánishëche y chë bëts pueblents̈a cárceloye tojtsanëtame. ");
INSERT INTO kbh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ibetna, Bëngbe Utabná canÿe ángel tbojanichmó y chë utámenents̈a bës̈as̈angá cha tojánatëfjo, chënga tojtanëbuacna y mënts̈á tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Motsajna, Bëngbe Bëtsabe bëts yebnents̈e s̈mochjámashjna, y ents̈anga s̈mochjabuayená nts̈amo cuanjama chë nÿetsca tescama yomna ts̈abe vida jtsebomnama, Jesucrístoftaca cánÿiñe mo canÿacá jtsemnëse ca.” ");
INSERT INTO kbh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nts̈amo tmojanuencá, yëfsana cabá cachëse Bëngbe Bëtsabe bëts yebnoye tmojána y tmojanonts̈é ents̈anga jabuátambana. Chëntscuana, chë bachnangbe más uámana amëndayá y chabe ústonënga, chë Israeloca bëtsëjemëngcá mándayënga y inÿe chents̈a amë́ndayënga tmojánachembo jénefjnama y jenóyeunayama; as chora chënga tmojanmandá chë utámenocana chë ichmónënga jobiats̈ama. ");
INSERT INTO kbh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero chë soldadënga chë utámenoye tmojánashjajna ora, chënga chents̈e ndoñe tmonjánanÿena. Chcasna, chënga tmojtaná chë mándayënga chca jaúnayama. ");
INSERT INTO kbh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Y tmojánayana: “Chë utámenoca fsënjínÿena lempe ts̈abá endëtsëtámeñe y soldadëngna nÿetsca bës̈as̈angá monduabojanÿanga; pero fsënjatëfjo y tsoye fsënjámashjna orna ndocná chibiátinÿena ca.” ");
INSERT INTO kbh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chë bachnangbe amë́ndayënga y chë Bëngbe Bëtsabe bëts yebnents̈a soldadëngbe amëndayá chca tmojanuena ora, yojtsëtëmnana y imojtsentjanaye ndayá chents̈ana yochjanopásama. ");
INSERT INTO kbh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chorna, chënga imojtsemnents̈e canÿe boyabása tojánashjango y mënts̈á tojanë́yana: “Chë s̈mojutámiënga mora Bëngbe Bëtsabe bëts yebnoca montsemna, ents̈anga montsabuatambá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chë soldadëngbe amëndayá tojána soldadë́ngaca, chë Jesusbe ichmónënga junatsama; pero nÿe ts̈abá tmojanënatse, er chënga ents̈angbiama imojtsauatja, nderado cachë́ngbioye ndëts̈béngaca muantsëbaye. ");
INSERT INTO kbh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chë́ngbioca tmojanë́shejajna ora, mandayë́ngbioye tmojanënatse; chora chë bachnangbe más uámana amëndayá mënts̈á tojanë́yana: ");
INSERT INTO kbh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Bënga jabuachana tcbontsëuyaná y tcbonjáuyana ndoñe s̈montselesenciana jtsóyebuambnayama chë boyabása Jesús tojánayana yojtsemna jabuátambama soyëngama ca. Masque chcasna, mora ts̈ëngaftanga nÿetsca chë Jerusalenents̈a oyenënga chabe soyëngama s̈mojtsabuatambá y s̈mojtsebos̈e, cha tojanóbanama castigo bë́ngbeñe chaotsemnama ca. ");
INSERT INTO kbh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chorna, Pedro y chë inÿe ichmónënga tmojánayana: —Bënga s̈ontsamna natsana Bëngbe Bëtsá joyeunayana y chents̈ana ents̈ángbioye. ");
INSERT INTO kbh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chë Taitá, nda bëngbe bëts taitanga monjánadorana, cha tojama Jesús cháuatayenama, chë nda ts̈ëngaftanga s̈monjanóba canÿe cruciñe juajabonjëse. ");
INSERT INTO kbh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bëngbe Bëtsá tbontatsbaná y chabe cats̈bioica tbojë́tstbema, jtsamë́ndayama, y tbojábema ents̈angbe Unachayá y Atsebacayá, chca, Israeloca ents̈anga ngménaca chamuenójuaboma bacna soyënga imojtsamama y chca amana chamotsajbanama, y chëngbe bacna soyëngama perdonánënga chamotsemnama. ");
INSERT INTO kbh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bënga fsë́ntsichamo ndayá bënga ndegombre tifjinÿe Bëngbe Bëtsá chca jtsamana ca; chë Uámana Espíritnaca chë soyëngama endbétsoyebuambnaye. Bëngbe Bëtsá endbétsama chë Uámana Espíritu cháuamashëngo chë tmojtseyeunanëngbe ainaniñe jtsemándayama ca —chënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chë mándayënga chca tmojanuena ora, puerte tmojanotjayaná y tmojánbos̈ena chë ichmónënga jtsëbáyama. ");
INSERT INTO kbh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero chë mándayënguents̈e yojtsemna canÿe fariseo, Gamaliel ca uabainá. Chana canÿe ley abuatambayá inamna y ents̈anga puerte imnarrespetana. As cha tojantsá y tojanmandá chë ichmónënga ratotema chents̈ana jubuacnama. ");
INSERT INTO kbh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Chents̈ana chë inÿe mándayënga tojanë́yana: “Israeloca taitanga, puerte cuedado s̈mochtsebomna nts̈amo quem boyabásengaftaca s̈mochjamama. ");
INSERT INTO kbh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Quem soyama s̈mochjenójuaboye: Ndoñe bayté quenátsmëna, Teudas tonjánbocna y cha enjánichamo canÿe uámana ents̈á canjamna ca, y mo canta patse ents̈anga cha tmojanasto. Pero chora ínÿenga cha tmontsanóba y chabe ústonënga tmontsanáshana, y chca lempe tontsanopochocá. ");
INSERT INTO kbh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chents̈ana, chë ents̈anga jenábemama enjamna ora, Judas chë Galileocá tonjánbocna y tonjanma báseftanga cha chamuastama; pero chánaca ínÿenga tmontsanóba y nÿetsca chabe ústonënga tmontsanáshana. ");
INSERT INTO kbh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chíyeca ats̈e cbë́yana, quem boyabásenga matabáshejuana y ndocá mataborlánana. Nts̈amo chënga montsamancá, nÿe ents̈angbe juabna y nÿe chëngbe trabajo tojtsemnëse, betsco echanjopochóca. ");
INSERT INTO kbh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero chca Bëngbe Bëtsabe soye tomnëse, ts̈ëngaftanga ndoñe ques̈mochatobenaye jáyënjanama. Cuedado s̈mochtsebomna, nderado mo Bëngbe Bëtsabe uayayënga s̈muatjanenobiama ca” —cha tojanë́yana. Y as chënga Gamaliel tmojanoyeuná. ");
INSERT INTO kbh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chcasna, chë ichmónëngbioye tmojánachembo, tmojtsanachebuánganja y tmojanë́yana Jesusbe uabáinaca ents̈ángbeñe ndoñe chamondëtsoyebuambná ca; y chents̈ana tmojtanabáshejuana. ");
INSERT INTO kbh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Chora chë ichmónënga chë amëndayë́ngbents̈ana puerte oyejuayënga tmojésanbocna, er Bëngbe Bëtsá tojanalesenciá jasúfriama, chënga Jesusbiama oservénënga bétsemnayeca. ");
INSERT INTO kbh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chents̈ana, chënga cada te imojanabuatambá y Jesús, chë Uámana Uabuayaná, chë Cristo bétsemnama ents̈ángbioye imojanabuayiyná, Bëngbe Bëtsabe bëts yebnents̈e y yebnënguenáchnaca. ");
INSERT INTO kbh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chë tempo, Jesucrístbeñe os̈buáchiyënga betsco imojtsóbotena. Chora chë Jesucrístbeñe os̈buachiyë́ngbents̈e, chë judiënga griego biyanga bats̈á imojtsets̈átjaye y chë judiënga hebreo biyangbiama mënts̈á tmojánayana: “Chë griego biyangbe viudángbioye ndoñe cachcá quemnatëjabuáchana nts̈amo chë hebreo biyangbe viudángbioye cada te montsëjabuachancá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Asna, chë bnë́tsana uta ichmónënga nÿetsca chë Jesucrístbeñe os̈buáchiyënga tmojanë́buaja y tmojanë́yana: “Ndoñe ts̈abá quenátsmëna, bënga jtsajbanana Bëngbe Bëtsabe palabra oyebuambnayana nÿe chë viudanga jtsanÿenama chë tojtsë́jaboto soyënguiñe. ");
INSERT INTO kbh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chcasna, baconga y batanga, ts̈ëngaftanguents̈ana canÿsë́ftanga mëbuáyana, ts̈abá mandbomnëngcá s̈mëbuátmënga, chamotsemna osertánënga y chë Uámana Espíritu chëngbe ainaniñe chaotsemánda, as chënga chë ujabótënga jtsëjabuáchanama trabajo fchanjábanÿiye. ");
INSERT INTO kbh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Y bëngna s̈ontsamna nÿets tempo Bëngbe Bëtsáftaca jtsencuéntayana y Bëngbe Bëtsabe palabra ents̈anga jtsabuayiynayana ca” —chënga tmojánayana. ");
INSERT INTO kbh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nÿetscanga tojanogusetá nts̈amo chë ichmónënga tmojanayancá; as, Esteban tmojanábuayana; canÿe boyabása puerte os̈buachiyá cha inamna y chë Uámana Espíritu chabe ainaniñe yojanmánda. Chents̈ana tmojanëbuáyana Felipe, Prócoro, Nicanor, Timón, Parmenas y Nicolás (cha inamna ndoñe judío ents̈á, Antioquía bëts pueblocá, y cha yojanamana Bëngbe Bëtsá jtsadoránana mo cach judiëngcá). ");
INSERT INTO kbh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chents̈ana chënga tmojanënatse Jesucristbe ichmónënga imojtsemnoye; chocna, chë Jesusbe ichmónënga Bëngbe Bëtsá tmojanimpadá chë ichmónëngbe trabajënguiñe chë ubuáyanënga chaújabuachama, chëngbe cucuats̈ënga chëngbe bests̈as̈ents̈e jajájuase. ");
INSERT INTO kbh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Más banga Bëngbe Bëtsabe palabra imojtsuenana, y chca, Jesucrístbeñe os̈buáchiyënga más imojtsóbotena, y Jerusalenents̈e más os̈buáchiyënga betsco imojtsóbotena. Y ba judiëngbe bachnángnaca tmojanonts̈é Jesucrístbeñe jtsos̈buáchiyana, nts̈amo chë ínÿenga imojtsanos̈buachecá. ");
INSERT INTO kbh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban, Bëngbe Bëtsabe obenana y chábents̈ana ts̈abe bendicionënga yojtsebomnëse, ents̈ángbeñe bëts soyënga yojtsama. ");
INSERT INTO kbh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Báseftanga “Ya Cachcá Atabashejuana Oservénënga ca” uabainëngna tmojanonts̈é Estébanoftaca enatsëtsnayana. Chënga imojamna judiënga Cirenoquënga, Alejandrioquënga, Cilicia y Asioquë́ngnaca, y chëngbe enefjuana luare yojanabaina “Ya Cachcá Atabashejuana Oservénëngbe Yebna ca”. ");
INSERT INTO kbh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero chë Uámana Espíritu tojanma Esteban chaóyebuambama bëtscá osertanacá, y chíyeca chënga ndoñe imontsobena nts̈amo cha jojuana. ");
INSERT INTO kbh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","As chënga báseftanga tmojanëbuénaye Estébanbe contra podesca soye chamuayanama, mënts̈á: “Cha fsënjoyeuná Moisesbiama y Bëngbe Bëtsabiama ndoñe ts̈abá jtsóyebuambnayana, mo cuafjoyanguangcá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chcase chënga tmojanma ents̈anga, bëtsëjemëngcá mándayënga y ley abuátambayënga Estébanbe contra chamónts̈a enbouenanana; y as, Esteban tmojanotbá y chë mándayënga imojtsemnoye imojuíchëmo. ");
INSERT INTO kbh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Y tmojanënatse básefta ents̈anga, uayátsenaye soyënga y podesca soyënga Estébanbe contra chamuayanama; as chënga mënts̈á tmojánayana: “Mua bacna soyënga entsichamo chë Bëngbe Bëtsá jtsadoránama bëts yebnama y Moisesbe leyëngama. ");
INSERT INTO kbh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Y fsënjoyeuná cha jayanana, Jesús Nazaretocá Bëngbe Bëtsabe bëts yebna caochtsepochóca y caochjama bënga nÿe chabe mandë́ngaca mandánënga chamotsiyenama y ndoñe nts̈amo Moisés bëngbe bëts taitanga tojëftsanabuatambacá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chë mándayënga y nÿetscanga chents̈e imojétsetbiamanënga Esteban tmojanonÿinÿé ora, tmojáninÿe chabe jubiá yojtsebuashinÿinÿana mo canÿe ángelbe jubiacá. ");
INSERT INTO kbh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chora chë bachnangbe más uámana amëndayá, Estébanbioye tbojantjá: —¿Nts̈amo acbiama montsichamcá ndegombre yojtsemna ca? ");
INSERT INTO kbh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","As Esteban tojanë́jua: —Taitanga y baconga, mouenënga. Bëngbe Bëtsá, chë corente uamaná endmëná, Abrahámbioye tbojánebëbocna, cha Mesopotamioca yojaniyena ora; tbojánebëbocna, Harán bëts puebloca joyénanama cabá nda ora, ");
INSERT INTO kbh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","y Bëngbe Bëtsá tbojaniyana: “Metseboshjona acbe fshantse y acbe pamíllanga y cbochanjinÿinÿiye luaroye cochjá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","As Abraham chabe luare Caldea tojë́ftsanboshjona y tojána Haránoca joyénanama. Chabe taitá tojanóbanents̈ana, Bëngbe Bëtsá Abrahámbioye chë luaroye tbojanánatse, chë mora ts̈ëngaftanga s̈montsiyenents̈e. ");
INSERT INTO kbh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero quem luariñe ni mo base fshantse ndoñe tbonjëftsanats̈etá, ni mo ndayents̈e jtsiyenama. Pero aíñe Abrahámbioye tbojans̈buachená chë fshantse jats̈etayama, chabiama y chabe básengbiama, Abraham tojóbanents̈ana. Chca tbojans̈buachená ora, Abraham ni canÿe s̈es̈ona bonjánbomna. ");
INSERT INTO kbh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Y Bëngbe Bëtsá mënts̈á tbojaniyana: “Chë ácbents̈ana ents̈anga, ínÿengbe luaroca áshjajnënga mochántsemna, y choca oyenënga chëngbe oservénënga chë́ngbioye mochanjábiama y canta patse uatëntscuana jabuache mochanjasufrina ca.” ");
INSERT INTO kbh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Y mënts̈ánaca tbojaniyana: “Pero ats̈e chanjácastigaye chca oservénënga chacmojábiama luarents̈a ents̈anga; y as, chents̈ana chë ácbents̈ana ents̈anga mochanjésebocana y mora bontsemna luaroye mochanjésabo y muents̈e ats̈e s̈mochántsadorana ca.” ");
INSERT INTO kbh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bëngbe Bëtsá Abrahámbioye tbojans̈buachená nÿe cha y chabe básengbe Taitá cha jtsemnama y jamama ts̈abe bendicionënga chë́ngbeñe chaotsemnama, y chama, chaotsinÿnamna tbojanmandá chabe s̈es̈ona, boyabásetema tojonÿná ora, base bobachtema chë más delicadents̈e jatëts̈ana. Chíyeca, chabe uaquiñá Isaac tojanonÿná ora, posufta tianoye Abraham base bobachtema chë más delicadents̈e tbojantëts̈e. Isaac cachcá tojanma chabe uaquiñá Jacóboftaca y Jacob cachcá tojanma chë chabe bnë́tsana uta uaquiñë́ngaftaca. Chënga monjamna chë Israeloca bnë́tsana uta bëts pamíllangbe taitanga. ");
INSERT INTO kbh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Quem uaquiñënga bëngbe bëts taitanga monjamna. Chëngna, chëngbe uabentsá Josébioye envidia imnabomna y tmojtsatanobuiye, Egiptoye canÿe oservenacá chamotsánatseñama. Pero Bëngbe Bëtsá Josébioye nÿets tempo ibnauájabuachana, ");
INSERT INTO kbh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","chíyeca nÿetsca chabe ngmenënguents̈ana tbojanatsbocá y Bëngbe Bëtsá tojanma cha chaotsetats̈ëmbuama ts̈abá jóyebuambayama chë Egiptoca réybents̈e, Faraón ca uabainá. Bëngbe Bëtsá tojanma chë Faraón chaoyejuá nts̈amo José yojamnama; chíyeca Faraón Josébioye tbojánbema Egiptoca mandado y chabe yebnënguents̈e oyenëngbiámnaca. ");
INSERT INTO kbh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Chë tempo, Egiptó y Canaán luariñe bëts shëntsana tojanóshjango y puerte ngménana yojtsemna y bëngbe bëts taitanga ndoñe imontsobena saná jónÿenama. ");
INSERT INTO kbh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero Jacob tojántats̈ëmbona Egiptoca saná yojtsemnama; asna, chabe uaquiñënga, chë bëngbe bëts taitanga choye tojanichamó. Chora yojamna chë natsanama chënga Egiptoye jama. ");
INSERT INTO kbh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Uta soyama chënga tmojtesaná ora, José chabe cats̈átanga tojanë́yana: ‘Ats̈e José sëndmëna, ts̈ëngaftangbe uabentsá ca.’ Chca chë Faraón Josebe pamíllangbiama tojántats̈ëmbona. ");
INSERT INTO kbh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Chents̈ana, José tojanmandá chabe taitá Jacob y nÿetsca pamíllanga Egiptoye chamotsama. Canÿsëfta bnë́tsana shachnënga imojamna chë Egiptoye tmojánanga. ");
INSERT INTO kbh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chcasna, Jacob Egiptoye tojána choca joyénanama. Choca cha tojanóbana y chë inÿe bëngbe bëts taitángnaca. ");
INSERT INTO kbh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacob y chabe básenga, nts̈amo imojtsobancá, chëngbe cuerpo Siquem bëts puebloye imojtsatambaye y tmojanëtebuantsá, Abraham tojëftsanbuamé cuevëshënguiñe. Abraham canÿe crocenánama Hamorbe uaquiñë́ngbioye, chëshënga yojtëyents̈buamiñe Siquem puebloca. ");
INSERT INTO kbh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nts̈amo Bëngbe Bëtsá Abrahámbioye tbojans̈buachenacá jamama yojtsobeco ora, Egiptoca corente tmojanoboté Israeloca ents̈anga y banga chënga imojtsemna. ");
INSERT INTO kbh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Cabana, Egiptoca inÿe rey tojanojayé y cha Josébioye ndoñe tbonjanabuátmana. ");
INSERT INTO kbh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chë reyna, bëngbe ents̈anga, chë bëngbe bëts taitángbioye tojanaingñé y tojanma chënga puerte chamosufrima; tojanamëndá, chë tmojtsónÿna s̈es̈onatémënga cachcá jtsë́nÿayana chamotsóbanama. ");
INSERT INTO kbh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chë tempo canÿe básetema tojanonÿná y cha Moisés ca tmojanabaye. Bëngbe Bëtsá Moisesbiama oyejuayá yojtsemna y chabe bëtsë́tsata cach yebnents̈e tmojanboché unga ishinÿëntscuana. ");
INSERT INTO kbh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cachcá jonÿayama yojtsamna orna, Faraonbe bembe tbojanocñe y mo cachabe uaquiñá cuenta tbojanboché. ");
INSERT INTO kbh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chca, chë Egiptoquënga imnatáts̈ëmbo soyënga Moisés tmojanbuatëmbá y canÿe uámana ents̈á tojánbocna jóyebuambayama y ndayánaca jamama. ");
INSERT INTO kbh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Canta bnë́tsana uata tojánashjache ora, tojanenojuabó jama jtsetats̈ëmbuama nts̈amo chë Israeloquënga, chabe ents̈anga imojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Canÿe, Moisés tojáninÿe canÿe Egiptocá canÿe Israelocábioye ibojtsejants̈etaye ora; as Moisés tbojanoboguiyaná y chë Egiptocábioye tbojtsanóba. ");
INSERT INTO kbh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés yojtsanjuabnaye chë Israeloquënga yojtsósertana, Bëngbe Bëtsá yochjanma cach Moisesbe obenánaca chë Egiptoca mandents̈ana chë́ngbioye játsebacama ca. Pero chë Israeloquënga ndoñe yontsë́sertana. ");
INSERT INTO kbh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yëfsana, Moisés tojánanÿena útata, cach Israelocata, ibojtsentsjanaye; chora cha betsco tojána jetsë́uyanama y tojanë́yana: ‘Tsëndata cats̈ata s̈ondmëna, ¿ndáyeca s̈ojtsentsjanata ca?’ ");
INSERT INTO kbh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","As, chë ínÿabioye ibojtsetsjanayá Moisésbioye tbojtsanajuatsënts̈e y tbojaniyana: ‘¿Nda bë́ngbeñe tcmënjajayé mandado y chë ts̈abá o ndoñe ts̈abá fstsamama chacuayanama ca? ");
INSERT INTO kbh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Cojtsebos̈e áts̈naca jóbama, nts̈amo tonjopasá yëfse chë Egiptocábioye tconjobacá ca?’ ");
INSERT INTO kbh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisés chca tojanuena ora, Madián luaroye tojtsanachá y choca yojoyena inÿe luarocana ashjangonacá. Chents̈e uta uaquiñata yojë́ftsabamna. ");
INSERT INTO kbh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Chents̈ana canta bnë́tsana uatëse, ents̈anga ndoyena luariñe, Sinaí tjañe béconana, canÿe ángel tbojánebëbocna zarzë́sha yojtsángbototjuanents̈e. ");
INSERT INTO kbh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés yojenjnaná ndayá yojtsonÿama y ts̈abá jinÿama tojanobeconá ora, tojanuena Bëngbe Bëtsá mënts̈á ibojtsatsëtsnaye: ");
INSERT INTO kbh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ats̈e acbe bëts taitangbe Bëtsá sëndmëna, Abraham, Isaac y Jacobëbe Bëtsá ca.’ Moisés chama tojanëuatjaná, ibojtsengmëmnaye y añemo ndoñe yontsebomna choye jontjes̈iyama. ");
INSERT INTO kbh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","As Bëngbe Utabná tbojaniyana: ‘Motsenóshecbotsca, er aca contsemnents̈e nÿe ats̈biama luare endmëna, er áts̈naca chents̈e së́ntsemna. ");
INSERT INTO kbh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ndegombre sënjinÿe nts̈amo ats̈be ents̈anga Egiptoca montsesufrina y sënjouena chëngbe oyabojuayana, y ats̈e sënjabo chënga jabátsebacama. Chcasna, mabouena, Egiptoye cbochanjíchmua ca’ —Bëngbe Bëtsá tbojaniyana.” ");
INSERT INTO kbh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Chents̈ana Esteban tojanë́yana: “Quem Moisés ents̈anga tmojtsanaboté y tmojaniyana: ‘¿Nda bë́ngbeñe tcmënjajayé mandado y chë ts̈abá o ndoñe ts̈abá fstsamama chacuayanama ca?’ Masque chca, Bëngbe Bëtsá mo mandayacá y atsebacayacá tbojesanichmó, chë zarzëshents̈e tojanobinÿná ángeloftaca. ");
INSERT INTO kbh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","As Moisés, bëngbe bëts taitanga Egiptocana tojésanëbuacna y bëts soyënga tojanma, y inÿe soyënga Bëngbe Bëtsabe obenana jinÿanÿiyama Egiptents̈e, chë Buángana ca uabaina mar béjayents̈e y ents̈anga ndoyena luarents̈e, canta bnë́tsana uatëntscuana. ");
INSERT INTO kbh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Cach Moisés Israeloca ents̈anga mënts̈á tojanë́yana: ‘Bëngbe Bëtsá ts̈ëngaftanguents̈ana canÿa bochanjábema ats̈cá Bëngbe Bëtsabe juabna oyebuambnayá ca.’ ");
INSERT INTO kbh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés Israeloca ents̈ángaftaca yojë́ftsemna chë ents̈anga ndoyena luaroca. Choca chë ents̈anga tmojánenefjna Sinaí tjañe béconana. Chents̈na canÿe ángel Moisésoftaca tojanoyebuambá, bëngbe bëts taitángbioye chë buayenana soye Moisés chaóyebuambama, chë ents̈anga ts̈abe vida jónÿenama palabrënga; y Moisés chca tojanma, bë́ngnaca chë palabrënga jouenama jobenayama. ");
INSERT INTO kbh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero bëngbe bëts taitanga ndoñe tmonjánbos̈ena joyeunayama, masna nÿe tmojtsanaboté y Egiptoye jesshë́conama imojtsaisebos̈e. ");
INSERT INTO kbh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moisés cabá chë tja tsjuanoca chë ángeloftaca yojtsemna ora, chëngbe bachnangbe más uámana amëndayá Aarónbioye mënts̈á tmojaniyana: ‘Bëngbe Bëtsabe cuenta s̈mayents̈pormá canÿe buashinÿinÿana soye jadórama, bënga chas̈únatsama. Er bënga quemátstats̈ëmbo ndayá yojtsopasana Moisés, chë Egiptocana s̈onjëftsëbuacnáftaca ca.’ ");
INSERT INTO kbh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","As tmojanma canÿe buashinÿinÿana soye mo canÿe uacnabecá y cha jadórama ba bayënga tmojanëbaye, y tmojanóboyejuanga cachënga chë soye tmojanpormáyeca. ");
INSERT INTO kbh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chë causa, Bëngbe Bëtsá chë́ngbents̈ana tojtsanojuánañe y cachcá tojesanë́nÿaye chëngbe bacna soyënga causa, estrellatémënga chamotsadoránama. Chca jochnënguama, Bëngbe Bëtsabe juabna oyebuambayëngbe librë́s̈añe mënts̈á endayana, nts̈amo Bëngbe Bëtsá tojanayancá: Israeloca ents̈anga, ¿Ats̈e jëtschuayama bayënga ches̈mënjanëbaye y chë soyënga ches̈mënjanáts̈ëmbona, chë canta bnë́tsana uata ents̈anga ndoyena luarents̈e ts̈ëngaftanga s̈monjë́ftsemna ora? ");
INSERT INTO kbh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ats̈e jadóra cuentna, chë Molocbiama jebna soye s̈monjanacutsá y cha s̈monjánadorana, y chë Refánbe estréllacnaca cachcá s̈monjánama. Chë soyënga mo Bëngbe Bëtsá cuenta s̈monjánbomna y cach ts̈ëngaftanga s̈monjanobopormá jadórama. Mora chë causa ats̈e chanjama, Babilonients̈ana más chcoye ts̈ëngaftanga chacmotsë́natsama ca” —chiñe endayana. ");
INSERT INTO kbh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bëngbe tempsca bëts taitanga ents̈anga ndoyena luaroca, chë jatsjacama opodena yebna imnabomna; chë yebnents̈e Bëngbe Bëtsá chë́ngaftaca tojanoyebuambá. Inajebna nts̈amo Bëngbe Bëtsá Moisésbioye tbojanmandacá, y cha tojanma nts̈amo chaojebuama Bëngbe Bëtsá tbojaninÿinÿecá. ");
INSERT INTO kbh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bëngbe bëts taitangna chëngbe taitángbents̈ana chë jatsjacama opodena yebna chëngbiama tmojanóyëngacñe, y chënga chë Canaán luaroye Josuéftaca, chë inÿe luaroquë́ngaftaca jéntsjama tmojána ora, chë jebna soye tmojanamba y chocna, Bëngbe Bëtsábeyeca chents̈a ents̈ángbioye Israeloquë́ngbents̈ana tmojtanëbuacna; y chë jebna soyna chë tmojanayënjaná luarents̈e tojanoquedá, rey David yojëftsiyenëntscuana. ");
INSERT INTO kbh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David ts̈abá mandbomná inamna, chíyeca Bëngbe Bëtsá cháftaca puerte yotsóyejuaye. David chábioye lesencia tbojanotjañe jajebuama, Bëngbe Bëtsá chë Jacob tbojanadorá cha, chents̈e chaotsiyenama. ");
INSERT INTO kbh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero Salomón inamna nda chë Bëngbe Bëtsabe bëts yebna tojanjebuá. ");
INSERT INTO kbh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Masque chë celoca Bëngbe Bëtsá, ents̈angbe jebna yebniñe ndoñe quenatiyena. Nts̈amo Bëngbe Bëtsabe juabna oyebuambnayá tojanabemcá, ndayá Bëngbe Bëtsá tojanayancá: ");
INSERT INTO kbh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Celoca endmëna chë luare ndayents̈ana ats̈e tsmánda, y quem luare endmëna nÿe mo canÿe ts̈enëtemcá ndayents̈e ats̈be shecuats̈ënga chjacjaye. As, ¿nts̈amo ats̈biama jebna yebna s̈mochjajebo ca?’ —chë Utabná jayanana—; ‘o ¿ndaye yebnents̈e ats̈e jóchnama chjobenaye, ");
INSERT INTO kbh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ndegombre cach ats̈e nÿetsca chë soyënga tijamëse ca?’ ” ");
INSERT INTO kbh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban mënts̈ánaca tojanë́yana: “Ts̈ëngaftanga nÿets tempo josértama ndëbos̈ënga s̈mondmëna; s̈mondbomna ainana mo chë Bëngbe Bëtsábeñe ndos̈buáchiyëngbe ainancá, y Bëngbe Bëtsabe soyëngama nduauenanënga s̈mondmëna. Ts̈ëngaftanga ndocna te ques̈mátsbos̈e chë Uámana Espíritu joyeunayana. Nts̈amo ts̈ëngaftangbe bëts taitanga monjaniyencá, ts̈ëngaftángnaca cachcá. ");
INSERT INTO kbh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Bëngbe Bëtsabe juabna oyebuambnayënguents̈ana, ndábioye ts̈ëngaftangbe bëts taitanga ndoñe monjanacmena? Chë Bëngbe Bëtsá tojanichamó ents̈anga chënga tmojtsanëbaye, y mëngna ents̈ángbioye imojanabuayiyná Cristo, chë nts̈amo Bëngbe Bëtsá yobos̈cá amá yochjánabama. Pero morna, uayayëngbe cucuats̈iñe cha s̈mojáboshjona y s̈mojóba. ");
INSERT INTO kbh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bëngbe Bëtsabe mandënga angelë́ngaftaca ts̈ëngaftanga s̈monjanóyëngacñe, pero chë soyënga ndoñe ques̈mátsyeunana ca” —cha tojanë́yana. ");
INSERT INTO kbh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chents̈a mándayënga chca tmojanuena ora, Estébanoftaca tmojanotjayaná y tmojanenaftës̈bonzentsé, rábiaca imojtsemnama. ");
INSERT INTO kbh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero chë Uámana Espíritu Estébanbe ainaniñe corente yojtsemándaye. Celoye yojontjes̈iye y Bëngbe Bëtsabe buashinÿinÿanana yojinÿe, y Jesús, Bëngbe Bëtsabe cats̈bioica yojtsatsana. ");
INSERT INTO kbh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","As, Esteban tojánayana: “¡Mouenënga, sëntsonÿá celoca entsatëfjna y Bëngbe Bëtsá Ents̈á tbojanbemá Bëngbe Bëtsabe cats̈bioica entsemna jtsamë́ndayama ca!” ");
INSERT INTO kbh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Chora chënga jabuache imojtseyoye, imojtsenamatsachto ndoñe más ntsuenanama y Estébanbioye tmojanontsënja. ");
INSERT INTO kbh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Chents̈ana, chënga chë pueblents̈ana tmojtsanábocna y ndëts̈béngaca tmojtsanatëchë́nganja. Chë Estébanbioye mal tmojanquedangna ents̈ayangá tmojtsanenátsejca y canÿe bobontse, Saulo ca uabainá, tmojesanábonÿiñe chaotsinÿenama. ");
INSERT INTO kbh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ndëts̈béngaca imojtsénanantscuana, Esteban Bëngbe Bëtsáftaca ibojtsencuéntaye y mënts̈á tojánayana: “Bëngbe Utabná Jesús, ats̈be espíritu s̈móyëngaca ca.” ");
INSERT INTO kbh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chents̈ana Esteban tojanoshaments̈é y jabuache tojánayana: “¡Bëngbe Utabná, chëngbe bacna soye motsaperdoná ca!” Y chca tojánayana ora, tojanóbana. ");
INSERT INTO kbh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo chents̈e yojtsemna y ts̈abá imojtsama ca yojtsejuabnaye, Esteban tmojanóbama. Cach te, ínÿenga tmojanonts̈é Jesucrístbeñe os̈buáchiyënga Jerusalenents̈e ucamenana y jtsamana puerte chamotsesufrínama; chcasna, chënga tmojtsanacheta y Samarioye y Judeoye tmojanáshana. Nÿe chë Jesucristbe ichmónënga ndócnoye tmonjánacheta. ");
INSERT INTO kbh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Básefta boyabásenga, Bëngbe Bëtsá adórayëngna, Esteban tmojanamba jauátbontsama y chabiama puerte tmojánenobos̈achna. ");
INSERT INTO kbh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Chëntscuana, Saulo yojtsents̈ena Jesucrístbeñe os̈buáchiyënga jtsapochócama y yebnënguenache yojánamashjuana boyabásenga y shembásenga sjojónana ubuacana jutámiama. ");
INSERT INTO kbh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Y Jesucrístbeñe os̈buáchiyënga tmojanáshanëngna nÿetsquénache imojánabuayiynaye Jesusbe ts̈abe noticiënga. ");
INSERT INTO kbh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chca, Felipe Samarioye tojána y tojanonts̈é chë Bëngbe Bëtsabe Uámana Uabuayaná, Cristbiama, chents̈a ents̈anga jábuayenama. ");
INSERT INTO kbh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ents̈anga imojánenefjuana Felipe joyeunayama y tmojáninÿe bëts soyënga cha jtsamana, Bëngbe Bëtsabe obenana jinÿanÿiyama. Chënga nÿetscanga nts̈amo Felipe yojtsichamcá ts̈abá imojtseyeunana. ");
INSERT INTO kbh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Banga bayëjbe juabna uambayënga ts̈abá imojtsatsmëna y chë bacna bayëjënga jabuache jtsaiyoyëse chë́ngbents̈ana imojtsaisebocana; y banga jama ndobenënga y coshetënga ts̈abá imojtsatsmëna. ");
INSERT INTO kbh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chë soyama chë pueblents̈a oyenënga corente imojtsóyejuaye. ");
INSERT INTO kbh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero canÿe pueblents̈e Samarioca inamna canÿe boyabása, Simón ca uabainá; cha tempo inamna canÿe bocjuaná y chë Samarioca ents̈anga chabe soyëngama imojánenjnanaye. Cha yojánichamo cha canÿe uámana ents̈á canjamna ca. ");
INSERT INTO kbh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Y chábioye corente imnayeunana nÿetscanga, uámanënga y nduámanëngnaca. Ents̈anga imojánichamo: “Mua entsemna chë Bëngbe Bëtsabe bëts obenana inÿanÿnayá ca.” ");
INSERT INTO kbh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Y ndegombre chënga corente imnayeunana, er cha chë bocjuanana soyë́ngaca bayté chë ents̈anga ingñénënga y ojnanánënga yojtsabamna. ");
INSERT INTO kbh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero chë luarents̈a ents̈angna, Felipe tmojanoyeuná chë cha yojtsëtsëtsná ts̈abe noticiënga Bëngbe Bëtsabe amë́ndayama y chë Jesucristbiama ts̈abe soyënga. Chorna chënga Jesucrístbeñe imojtsos̈buáchiye, y boyabásenga y shembásenga tmojánenabaye. ");
INSERT INTO kbh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Y cach Simónënaca Jesucrístbeñe yojtsos̈buáchiye y tojanenábaye, y chents̈ana cada te Felípeftaca cha yojtsanmëna. Cha tojáninÿe Felipe chë bëts soyënga Bëngbe Bëtsabe obenánaca jamana, y chama ojnananá yojtsemna. ");
INSERT INTO kbh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chë Jerusalenoca imojtsemna ichmónënga tmojántats̈ëmbona Samarioca ents̈anga Bëngbe Bëtsabe palabra tmojanóyeunama; as, chora Pedro y Juan choye tmojanichamó. ");
INSERT INTO kbh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pedro y Juan Samarioye tbojánashjango ora, chents̈e Jesucrístbeñe os̈buáchiyëngbiama Bëngbe Bëtsá tmojanimpadá, as chë Uámana Espíritu chë́ngbeñe cháuamashënguama jtsemándayama. ");
INSERT INTO kbh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Er cabá ni mo cánÿabeñe chë Uámana Espíritu tonjánamashëngo; chënga tmojánenabaye Bëngbe Utabná Jesús jóts̈ëmbonëse, chábeñe os̈buáchiyënga jtsemnama imojtsebós̈eyeca. ");
INSERT INTO kbh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","As Pedro y Juan chëngbe bests̈as̈iñe cucuats̈ënga tbojancjá, y chca, chë Uámana Espíritu tojánamashëngo chëngbe ainaniñe jtsemándayama. ");
INSERT INTO kbh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón tojáninÿe, chë ichmónënga ents̈ángbeñe cucuats̈ënga tmojacjá ora, chë Uámana Espíritu chë́ngbeñe jamashënguana. As chora Simón chë ichmónënga tojanë́yana: —Quem crocénana mosháchiñe, ");
INSERT INTO kbh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","y áts̈naca chë obenana s̈mats̈etá, y ndábeñnaca cucuats̈ënga chaijajajó ora, chábeñnaca chë Uámana Espíritu cháuamashëngo ca. ");
INSERT INTO kbh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","As Pedro tbojaniyana: —¡Acbe crocénana infiernoye chaotsá y ácnaca, chë Bëngbe Bëtsabe ts̈etana soye crocenánaca jobuámiñama yopodena ca tcojajuabó causa! ");
INSERT INTO kbh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndegombre, aca bë́ngaftaca ndoñe quecátsmëna, ni bëngbe trabajo acbiama quenátsmëna, Bëngbe Bëtsabe delante acbe ainaniñe ts̈abe juabnënga ndoñe quecátsbomna causa. ");
INSERT INTO kbh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ngménaca cochjenójuaboye quem bacna soye tcojamama y chca amana cochtsajbaná y Bëngbe Bëtsá cochjaimpáda, aca chca tcojájuaboma nderádose cmatjaperdóna. ");
INSERT INTO kbh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ats̈e së́ntsetats̈ëmbo, acbe ainaniñe ts̈a bacna juabnënga ínÿengbiama yojtsemnama; y bacna soyënga amana jtsajbanama ndoñe quecátobena causa, aca mo canÿe ntsacjuanacá contsemna ca —Pedro tbojaniyana. ");
INSERT INTO kbh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","As chora Simón tojanë́yana: —Bëngbe Utabná ats̈biama s̈ochjaimpáda, nts̈amo s̈monjauyancá ndoñe chandëpasama ca. ");
INSERT INTO kbh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro y Juan, nts̈amo Bëngbe Utabná Jesucristbiama tbojaninÿcá y ibnatats̈ëmbcá ents̈anga imojtsë́tsëtsnaye. Chents̈ana, Jerusalenoye tbojésanata y tbojánachnëngo ba Samarioca pueblënguëjana, ts̈abe noticiënga ents̈anga abuayiynaye. ");
INSERT INTO kbh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chents̈ana, Bëngbe Utabnabe canÿe ángel Felípbioye tbojaniyana: “Moprontá y tsmana luarëngoye motsa, Jerusalenents̈ana Gaza ca uabaina bëts puebloye benachëjana ca.” Chë benachna ents̈anga ndoyena luarëjana yojanachnë́ngona. ");
INSERT INTO kbh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","As Felipe yojëftsëtsbaná y tojána. Benachiñe tbojáneninÿena canÿa Etiopía luarocáftaca. Etiopía luaroca canÿe reiná inamna y chë boyabásana chabe uajabuachaná y chabe crocénana bojanÿá inamna. Chana Jerusalenoye tojánabo Bëngbe Bëtsá jadórama. ");
INSERT INTO kbh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28"