﻿USE sofia;
DROP TABLE IF EXISTS sofia.kbcNT_vpl;
CREATE TABLE kbcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kbcNT_vpl WRITE;
INSERT INTO kbcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Niɡ̶idi noiigi joaniɡ̶idiaa jotigide laamipi Jesus Cristo. Jesus ida aneetetege licoɡ̶egi Davi, ane licoɡ̶egi Abraão. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão jiɡ̶ijaa eliodi Isaque, Isaque jiɡ̶ijaa eliodi Jacó. Jacó jiɡ̶ijaa eliodi Judá ijaa nioxoadipi Judá. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ijoa itoataale lionigipi ɡ̶oneleegiwadi, onijoteci liboonaɡ̶adi Peres ijaaɡ̶eledi Zera, ajaa eliodo Tamar. Peres jiɡ̶ijaa eliodi Esrom, Esrom jiɡ̶ijaa eliodi Arão. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão jiɡ̶ijaa eliodi Aminadabe, Aminadabe jiɡ̶ijaa ane eliodi Nasam. Nasam jiɡ̶ijaa eliodi Salmom. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom jiɡ̶ijaa eliodi Boaz, Boaz eliodo liboonaɡ̶adi Raabe. Boaz jiɡ̶ijaa eliodi Jessé. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jessé jiɡ̶ijaa eliodi Davi, Davi anijo me inionigi-eliodi. Davi eliodi Salomão, eliodo Salomão naɡ̶ajo anijo me lodawa Urias. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão jiɡ̶ijaa eliodi Roboão, Roboão jiɡ̶ijaa eliodi Abias, Abias jiɡ̶ijaa eliodi Asa. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa jiɡ̶ijaa eliodi Josafá, Josafá jiɡ̶ijaa eliodi Jorão, Jorão jiɡ̶ijaa eliodi Uzias. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias jiɡ̶ijaa eliodi Jotão, Jotão jiɡ̶ijaa eliodi Acaz, Acaz jiɡ̶ijaa eliodi Ezequias. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias jiɡ̶ijaa eliodi Manassés, Manassés jiɡ̶ijaa eliodi Amom, Amom jiɡ̶ijaa eliodi Josias. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias jiɡ̶ijaa eliodi Jeconias ijaaɡ̶ijo nioxoadipi. Niɡ̶ijo malee yewiɡ̶a Josias, odaa niɡ̶ijo laxakawepodi loiigi Israel joɡ̶oyadeegi loiigi Israel digoida niiɡ̶otedi Babilônia midiaaɡ̶i me niwilogojedipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Niɡ̶ijo noiigi noɡ̶oyadeegiticogi Babilônia, odaa Jeconias jiɡ̶ijaa eliodi Salatiel, Salatiel jiɡ̶ijaa eliodi Zorobabel. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel jiɡ̶ijaa eliodi Abiúde, Abiúde jiɡ̶ijaa eliodi Eliaquim, Eliaquim jiɡ̶ijaa eliodi Azor. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor jiɡ̶ijaa eliodi Sadoque, Sadoque jiɡ̶ijaa eliodi Aquim, Aquim jiɡ̶ijaa eliodi Eliúde. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde jiɡ̶ijaa eliodi Eleazar, Eleazar jiɡ̶ijaa eliodi Matã, Matã jiɡ̶ijaa eliodi Jacó. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó jiɡ̶ijaa eliodi José, José jiɡ̶ijaa lodawa Maria. Maria jaɡ̶ajaa eliodo Jesus, ane liboonaɡ̶adi Cristo. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jiɡ̶idaaɡ̶ee jiɡ̶ijoa catooze noiigi ixomaɡ̶atijo anida aneetege licoɡ̶egi Abraão neɡ̶epaaɡ̶icota Davi, odaa idaaɡ̶ee ijoa catooze noiigi ixomaɡ̶atijo anida aneetege licoɡ̶egi Davi neɡ̶epaaɡ̶icota Jeconias anoyadeegiticogi Babilônia. Idaaɡ̶ee ijoa catooze noiigi ixomaɡ̶atijo anida aneetege licoɡ̶egi Jeconias neɡ̶epaaɡ̶icota José, niɡ̶ijo lodawa Maria eliodo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiɡ̶idaaɡ̶ee neɡ̶enitedini Jesus. Maria, ane eliodo Jesus, eka doletibige me lodawa ica José. Pida anaɡ̶a lodawa niɡ̶ipileɡ̶e, codaa Maria aniɡ̶ica daɡ̶a nadi ɡ̶oneleegiwa. Pida Liwigo Aneotedoɡ̶oji eo me ipileɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, niɡ̶ijo ane doletibige me lodawa Maria, ɡ̶oneleegiwa ane iɡ̶enaɡ̶a, codaa mele. Ja domaɡ̶a lowoogo me ika Maria, pida adomaɡ̶a yemaa me ibolikatidi Maria lodoe niɡ̶idi noiigi. Joaniɡ̶idaa leeɡ̶odi me domaɡ̶a lowoogo me ika Maria me diɡ̶ica ane yowooɡ̶odi niɡ̶ica oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Niɡ̶ijo naɡ̶a lowoogo me daɡ̶adiaa lodawa Maria, odaa ja dige. Igee ica niaanjo Aneotedoɡ̶oji me dinikeeta. Odaa oneeta, “José, anida anenitege licoɡ̶egi Davi, jinaɡ̶a domaɡ̶a adoiita me ɡ̶adodawa Maria. Igaataɡ̶a Liwigo Aneotedoɡ̶oji aneo nigaanigi catiwedi Maria le. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Odaa Maria dinigajetece nigaanigawaanigi, odaa awii me liboonaɡ̶adi Jesus, leeɡ̶odi jiɡ̶ijaa napitaɡ̶adi loiigi libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Odaa jiɡ̶idaaɡ̶ee niɡ̶ica niciagi eo me icotece niɡ̶ijoa lotaɡ̶a niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji niɡ̶ijo jotigide, niɡ̶ijo naɡ̶a yalaɡ̶ata aneeteta Ǥoniotagodi, mee, ");
INSERT INTO kbcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Digawini! Ani awicije anicota me ipileɡ̶e, pida aniɡ̶ica me nadi ɡ̶oneleegiwa. Odaa jiɡ̶idi lionigi, odaa joɡ̶owo me liboonaɡ̶adi ‘Emanuel’.” “Emanuel” niɡ̶ina anejinaɡ̶a iniwa “Aneotedoɡ̶oji mokotaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naɡ̶a nioodi José, odaa jeɡ̶eo niɡ̶ijo niaanjo Aneotedoɡ̶oji ane iiɡ̶eta meo. Odaa José ja lodawa Maria. ");
INSERT INTO kbcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pida aniɡ̶ica daɡ̶a loomatewa Maria neɡ̶epaa dinigajetece odoejegi lionigi. Odaa José jeɡ̶eo me liboonaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus lanikadi aca nigotaɡ̶a Belém ane nipodigi Judéia, niɡ̶ijo me inionigi-eliodi Herodes. Niɡ̶ijoa nokododi icoa ɡ̶oneleegiwadi ane libakedi moiɡ̶oaditalo yotetitedi oicoɡ̶oticogi nigoi, igotibeci nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Odaa ja nigikanaɡ̶a, modi, “Igame diɡ̶etigi ica nigaanigawaanigi ane icota me ninionigi-eliodi judeutedi? Jowooɡ̶otaɡ̶a neɡ̶enitini, igaataɡ̶a jinataɡ̶a ajo notedi digoida nigoi. Odaa janagaɡ̶a me joɡ̶eeɡ̶ata.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Naɡ̶a wajipatalo Herodes lotaɡ̶a niɡ̶ijoa ɡ̶oneleegiwadi, odaa eliodi me doɡ̶owikomata, codaa eliodi okotigi nigotaɡ̶a Jerusalém eledi noɡ̶owikomataaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Odaa ja yatecoɡ̶otee niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odaa Herodes ja nigetiniwace ica ane lanikadi icoa Cristo, niɡ̶ijoa Aneotedoɡ̶oji ane niiɡ̶e meote me ɡ̶odewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Odaa joɡ̶oigidi, modita, “Lanikadi Belém nipodigi Judéia, leeɡ̶odi mee anigepidiɡ̶ijo niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, ");
INSERT INTO kbcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Akaami Belém nipodigi Judéia, akamaɡ̶akaami akaami ɡ̶oneɡ̶e liwigotigi eletidi nigotadi Judéia. Igaataɡ̶a digoina makaamitaɡ̶a lanikadi niɡ̶ica ane icota me lacilo, ane dowediteloco yoiigi Israel micataɡ̶a nowienoɡ̶odi waxacocoli’.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Odaa Herodes jeɡ̶eniditiogi ica anokegipi anoicoɡ̶oticogi nigoi igo dakapetege me diɡ̶ica ane yowooɡ̶odi. Odaa ja nigetiniwace niɡ̶ica noko noɡ̶onadi naɡ̶aca yotedi ane nodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Odaa niɡ̶idiaaɡ̶idi ja imonyatibigiwaji migotibeci nigotaɡ̶a Belém, meetiogi, “Emiitiwaji, odaa oleetibige mowooɡ̶oti ane diɡ̶etigi niɡ̶ica nigaanigawaanigi. Nigakati, odaa awii yeemidi, amaleeɡ̶aɡ̶a jakadi maɡ̶aɡ̶a ejigo joɡ̶eteta.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Noɡ̶owajipatalo lotaɡ̶a niɡ̶ini inionigi-eliodi, odaa joɡ̶opitibeci niɡ̶ijoa anokaɡ̶a. Eɡ̶idaa diiticogi me wiajeeɡ̶a, odaa joɡ̶onadi ajaaɡ̶ajo naɡ̶ajo yotedi anonadi diɡ̶etege nigoi. Odaa naɡ̶ajo yotedi jiɡ̶igo lodoe niɡ̶ijoa anokaɡ̶a, odaa ja nicoti ditibigimedi niɡ̶ijo diimicawaanigi aneitice nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Noɡ̶onadi naɡ̶ajo yotedi ane idei ditibigimedi niɡ̶ijo diimicawaanigi, odaa eliodi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Odaa noɡ̶odakatiwece niɡ̶ijo diimicawaanigi, joɡ̶onadi nigaanigawaanigi manitaɡ̶a Maria ane eliodo nigaanigawaanigi. Odaa joɡ̶oyamaɡ̶atedini lokotidi lodoe niɡ̶ijo nigaanigawaanigi, odaa joɡ̶odoɡ̶eteta. Niɡ̶idiaaɡ̶idi joɡ̶oyomoke aca lowoodaɡ̶axi anonadeegi, onoɡ̶a icoa liboonaɡ̶a anonadeegita nigaanigawaanigi. Odaa joɡ̶oyajigo icoa liboonaɡ̶a, oolo, ica namoko ɡ̶odatobi ane liditege lanigi niɡ̶ina moyalegi, idaa ica pomaada ane liditece lanigi codaa dakake loojedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Niɡ̶ijo naɡ̶a niotaɡ̶a, odaa ja nigeeɡ̶a, odaa oigee Aneotedoɡ̶oji me ibodicaxi me daɡ̶adiaaɡ̶idiaa igotinece minitaɡ̶a Herodes. Odaa joɡ̶odioteci eledi naigi mopiticogi niiɡ̶otedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Niɡ̶idiaaɡ̶idi noɡ̶opitibeci niɡ̶ijo anokegipi, José ja igee ica niaanjo Ǥoniotagodi Aneotedoɡ̶oji me dinikeeta, odaa meeta, “Adabititini, abaata nigaanigawaanigi, aniaa eliodo, ialeticogi niiɡ̶o Egito! Idiaaɡ̶oni nigepaa jao ɡ̶adeemidi nige yakadi madopilitijo, igaataɡ̶a Herodes doletibige me yeloadi niɡ̶idi nigaanigawaanigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Odaa José jiɡ̶itibigi, ja nibatine nigaanigawaanigi ajaa eliodo, ijaaɡ̶ijo niɡ̶ijo enoale José jiɡ̶igo Egito. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Odaa jiɡ̶idiaaɡ̶i Egito neɡ̶epaaɡ̶icota me yeleo Herodes, odaa joaniɡ̶idaa mewi me icotece ane lotaɡ̶a Ǥoniotagodi Aneotedoɡ̶oji, ganigepidiɡ̶ijo niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko ane iditedini, “Odaa jiniditalo ionigi me noditicogi Egito.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naɡ̶a nadi Herodes moinaale niɡ̶ijo anokegipi anoicoɡ̶oticogi nigoi, odaa eliodi me deliɡ̶ide. Odaa ja diiɡ̶enatakatiogi monigodi iditawece nigaanigipawaanigi anidiwa itoataale nicaaɡ̶ape, ane niɡ̶eladimigipitigi Belém, codaa me minoataɡ̶a inoa nipodaɡ̶a ane ipegitege nigotaɡ̶a. Eo niɡ̶ida loenatagi leeɡ̶odi yowooɡ̶odi neɡ̶eote itoataale nicaaɡ̶ape naɡ̶ajo yotedi naɡ̶a dinikeetiogi niɡ̶ijo anokegipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Odaa jiɡ̶idaaɡ̶ee naɡ̶a icotece niɡ̶ijoa Jeremias lotaɡ̶a, niɡ̶ijo ane yeloɡ̶oditibece Aneotedoɡ̶oji lowooko, niɡ̶ijo mee, ");
INSERT INTO kbcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Manitaɡ̶a nigotaɡ̶a Ramá jajipaaɡ̶ata layaageɡ̶egi oko me nacaagaɡ̶ateloco, eliodi me agecaɡ̶alodipi. Jaɡ̶ajaa Raquel ane dacaagetibece leeɡ̶odi lionigipi. Dacaagetibece, odaa aɡ̶ica ane yakadi me yocaɡ̶aneɡ̶e leeɡ̶odi iditawece ja nigo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Niɡ̶idiaaɡ̶idi Herodes naɡ̶a yeleo, odaa José ja dige digoida Egito. Igee ica niaanjo Ǥoniotagodi Aneotedoɡ̶oji me dinikeeta. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Odaa niɡ̶ica aanjo jeɡ̶eeta, “Onitibige, anibaatine nigaanigawaanigi aniaa eliodo, odaaɡ̶opiliticogi nipodigi Israel, leeɡ̶odi niɡ̶ijo ane domoɡ̶oyeloadi niɡ̶ini nigaanigawaanigi aɡ̶aleeɡ̶ica, ja nigo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Odaa José jiɡ̶itibigi, nibatine nigaanigawaanigi, ajaa eliodo, odaa ja dopiticogi nipodigi Israel. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Niɡ̶ijo niɡ̶icoticogi, odaa ja dibodiceta Arquelau, lionigi Herodes, me niɡ̶iniaa diiɡ̶enataka waxodi limedi eliodi. Joaniɡ̶idaa leeɡ̶odi José me doita midiaaɡ̶i. Odaa José ja dige, igee Aneotedoɡ̶oji meote leemidi. Odaa jiɡ̶igo nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Odaa jiɡ̶idiaaɡ̶i mani nigotaɡ̶a Nazaré. Odaa jiɡ̶idaaɡ̶ee micotece lotaɡ̶a niɡ̶ijo ane yeloɡ̶oditibece Aneotedoɡ̶oji lowooko niɡ̶ica jotigide, niɡ̶ijo mee, “Oyatedigi me Nazareeno.” ");
INSERT INTO kbcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naɡ̶a ixomaɡ̶atedice icoa nicaaɡ̶ape, ijo ica ɡ̶oneleegiwa ane liboonaɡ̶adi João Batista jiɡ̶igo nipodigi Judéia ane diɡ̶icata niɡ̶eladimigipi. Odaa jeɡ̶eetiogi niɡ̶idi oko anodiita, ");
INSERT INTO kbcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Adinilaanitece ɡ̶abeyaceɡ̶ecotiwaji! Igaataɡ̶a niɡ̶ica noko ja nipegi Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Niɡ̶ica jotigide Isaías ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, yalaɡ̶ata João, niɡ̶ijo mee, “Ida oko ane igedi me dotaɡ̶a miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi, anee, ‘Oenitece ligi Ǥoniotagodi me ixomaɡ̶atedijo! Codaa awiitiwaji naigi ane dixoke nigepaa enotedijo’.” ");
INSERT INTO kbcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","João dinixotinigi nowoodi gameelo lamodi onibila, codaa ibake goenaɡ̶adi ewacogo, liweenigi ɡ̶onipidi inaa napigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eliodi oko igotibeci mowajipatalo lotaɡ̶a João, niɡ̶eladimigipitigi nigotaɡ̶a Jerusalém, codaa me nipodigi Judéia, codaa midiwatawece nipodaɡ̶a ane ipegitege akiidi Jordão. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Odaa niɡ̶ijo oko joɡ̶oyatemati libeyaceɡ̶eco odinilaatece, odaa João nilegetiniwace midi akiidi Jordão (moikee noɡ̶oika mowo ane beyagi). ");
INSERT INTO kbcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","João nadi me eliodi niɡ̶ijo fariseutedi ijaa saduceutedi anigotibeci midataɡ̶a me dinilegetibigiwaji. Naɡ̶a nadi, odaa jeɡ̶ee, “Niɡ̶ida makaamitiwaji ɡ̶adiciagi niɡ̶inoa laketedi ane diniweneene! Aleetibigetiwaji daɡ̶a ɡ̶adiwokoni niɡ̶ica noko nige iloikatidi Aneotedoɡ̶oji niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco? ");
INSERT INTO kbcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pida oleetibige mawii anele mikeeni mewi naɡ̶adinilaanitece ɡ̶abeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jinaɡ̶aleetibige daɡ̶a ɡ̶adiwokoni niɡ̶ina menitibecetiwaji, ‘Ida anejinaɡ̶atege licoɡ̶egi Abraão.’ Igaataɡ̶a ejitaɡ̶awatiwaji Aneotedoɡ̶oji me yakadi meote niɡ̶idiwa wetiadi me lionigipi Abraão. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja nipegi niɡ̶ica noko Aneotedoɡ̶oji me iloikatidi niɡ̶ina oko leeɡ̶otedi niɡ̶inoa libeyaceɡ̶eco. Jiciaceeketege naɡ̶ana niale anidiwa onateciɡ̶idiwa nokododi, odaa ja nakagidi napalite litodi. Inoatawece niɡ̶inoa niale ane daɡ̶a yajigo ela anele, onakagidi, odaa oyokoletiogi minitaɡ̶a noledi. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ǥadilegenitiwaji jatitaɡ̶awa ninyoɡ̶odi me jikee madinilaanitece ɡ̶abeyaceɡ̶eco. Pida ina oko anenagi nigidiaaɡ̶idi ane naɡ̶axatiloco. Niɡ̶ini oko nige ɡ̶adilegenitiwaji, odaa ibake Aneotedoɡ̶oji Liwigo micataɡ̶a daɡ̶a noledi me ɡ̶adapitaɡ̶ati. Daɡ̶axa me notoedi, aiciagi, codaa daɡ̶axa me ɡ̶oneɡ̶egi, caticedi ee, odaa oteɡ̶exaaɡ̶aɡ̶a jakadi me joyaɡ̶adi liwelatedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ja igo me iolatedice niɡ̶ina oko anele me yawalacetege niɡ̶ina oko ane beyagi. Liciagi niɡ̶ijo oko anani nibeneela libaaɡ̶adi, baanaɡ̶a dinenyaɡ̶adi me iolatice idiwatawece niɡ̶icoa leyeema lapadi. Odaa ja yotete nileyeema manitaɡ̶a lotetenaɡ̶anaɡ̶axi, pida niɡ̶ijoa lapadi baɡ̶a yalegi minitaɡ̶a noledi ane daɡ̶a ipe.” ");
INSERT INTO kbcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Niɡ̶ijoa nokododi, Jesus ja noditedicogi nipodigi Galiléia. Odaa jiɡ̶igo akiidi Jordão maɡ̶aɡ̶a dinilege midataɡ̶a João. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pida João ayakadi mele codaa adomaɡ̶a yemaa me ilege Jesus. Odaa mee, “Akaami anagi meetaɡ̶a maɡ̶aɡ̶a adinilegeni. Pida jeɡ̶epaɡ̶a domaɡ̶a leeditibige madilegeni.” ");
INSERT INTO kbcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pida mee Jesus, “Awii ane jemaa, adiwikodeni adilegeni! Odaa ja jaoɡ̶a Aneotedoɡ̶oji ane yemaa.” Odaa João ja niwoditema. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Niɡ̶idiaaɡ̶idi João ja ilege Jesus, odaa aɡ̶ica daɡ̶a leegi Jesus naɡ̶a daxoditedita ninyoɡ̶odi, naɡ̶a iwitedibigimece ditibigimedi, odaa ja nadi me domoke ditibigimedi, codaa jaɡ̶aɡ̶a naditetege Liwigo Aneotedoɡ̶oji me dinikatelogo dinanatigi yotibi, odaa ja nicotelogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Odaa digawini! Niɡ̶ijo oko joɡ̶owajipata ica nigegi digoida ditibigimedi, anee, “Niɡ̶idoa Ionigi yemaanigi. Eliodi me idinitibeci leeɡ̶odi Idaaɡ̶idoa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Niɡ̶idiaaɡ̶idi Liwigo Aneotedoɡ̶oji ja yadeegitedicogi Jesus miditaɡ̶a nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi, odaa jiɡ̶icaaniɡ̶igotalo ɡ̶odaxakawa me dinetalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesus ayemaa mica ane yeligo niɡ̶ijoa cwareenta nokododi, odaa niɡ̶idiaaɡ̶idi ja nigicile. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Odaa niɡ̶ijo ɡ̶odaxakawa, niɡ̶icotalo Jesus, odaa meetalo, “Nigewi makaami Lionigi Aneotedoɡ̶oji, awii naɡ̶ani wetiɡ̶a me paon.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Odaa Jesus ja igidi, meeteta, “Lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji diniditeloco, ‘Me diɡ̶inokina niweenigi meo me yewiɡ̶a oko. Pida leeditibige mowajipatalo codaa mowo inoatawece Aneotedoɡ̶oji ane lotaɡ̶a.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niɡ̶idiaaɡ̶idi ɡ̶odaxakawa ja yadeegitedicogi Jesus digoida nigotaɡ̶a Jerusalém, nigotaɡ̶a anida aneetege Aneotedoɡ̶oji. Odaa ja yadeegitedibigimece ditibigimedi liɡ̶eladi Aneotedoɡ̶oji, niɡ̶ica liwai ane daɡ̶axa me leegitibigimece. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Odaa ɡ̶odaxakawa meetalo Jesus, “Nigewi makaami Lionigi Aneotedoɡ̶oji, adinaxokitinece digoida natinedi, igaataɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji mee, ‘Aneotedoɡ̶oji niiɡ̶e niaanjotedi modoweditaɡ̶aloco. Oilokaditaɡ̶awa me diɡ̶icata ɡ̶ataciledi, codaa me daɡ̶a etaciloteda ɡ̶adoɡ̶onaka midiwataɡ̶a wetiadi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Odaa Jesus ja igidi, “Pida maditaɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji diniditeloco, mee, ‘Jinaɡ̶a adineenitalo Ǥaniotagodi Aneotedoɡ̶oji!’” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Niɡ̶idiaaɡ̶idi ɡ̶odaxakawa ja yadeegitedicogi Jesus ditibigimedi naɡ̶ajo wetiɡ̶a ane daɡ̶axa me leegitibigimece, odaa ja ikeetalo iditawece noiigitigi niɡ̶ina iiɡ̶o, codaa me niliicaɡ̶ajetecidi niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Odaa ɡ̶odaxakawa meetalo, “Jajigotaɡ̶awa inatawece noiigi niɡ̶ina iiɡ̶o me iiɡ̶eni, nige amakitedini ɡ̶adokotidi moɡ̶eetetiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Odaa Jesus ja igidi, meeteta, “Emii, opili, Satanás! Igaataɡ̶a diniditeloco lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji, ‘Oɡ̶eetetalo Ǥaniotagodi Aneotedoɡ̶oji, codaa ikani miniokiniwateda me ɡ̶adiiɡ̶eni.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Odaa ɡ̶odaxakawa ja ika Jesus, odaa aanjotedi jiɡ̶igotibeci, odoweditelogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus naɡ̶a dibodicete João Batista moniwilo, odaa jiɡ̶igo nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aɡ̶idiaaɡ̶itedice nigotaɡ̶a Nazaré, pida igo idiaa liɡ̶eladi nigotaɡ̶a Cafarnaum, ane ipegitege weiigi ane liboonaɡ̶adi Galiléia, nipodigi Zebulom aniaa Naftali. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Odaa jiɡ̶idaa meo micotece lotaɡ̶a Isaías, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, niɡ̶ijo mee, ");
INSERT INTO kbcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Miditaɡ̶a nipodigi Zebulom aniaa Naftali, naigi anigo weiigi nipodaɡ̶a aneite daato akiidi Jordão, nipodigi Galiléia ane liɡ̶eladi niɡ̶ijo ane daɡ̶a judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Midiwataɡ̶a niɡ̶idiwa nipodaɡ̶a, niɡ̶ijo noiigi aneiteloco miditaɡ̶a nexocaɡ̶a onadi aca lokokena loniciweɡ̶ena. Odaa naɡ̶ani lokokena naloteloco iditawece oko aneiteloco niɡ̶idiwa nipodaɡ̶a ane liciagi nipodigi aneite niɡ̶inoa émaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Odaa Jesus jiɡ̶idaaɡ̶eyatedigi me yeloɡ̶oditedibece latematiko, mee, “Adinilaanitece ɡ̶abeyaceɡ̶eco, igaataɡ̶a jiɡ̶ipegiteloco niɡ̶ica noko Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali niɡ̶ina oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus igotetece liniogotibece niweiigi Galiléia, odaa ja nadi itoataale ɡ̶oneleegiwadi dinioxomigi, ijo ane liboonaɡ̶adi Simão (ane eledi oyatigi me Pedro) ijaa André. Odibatalo noɡ̶ojedi moyaa, oyokoletedinibece leelatiidi midi weiigi me nomiigomigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Odaa Jesus meetediogi, “Anagi, aniwitici! Ǥadiiɡ̶axinitiwaji anemiita oko madeegitalo Aneotedoɡ̶oji, liciagi niɡ̶ina mabaata noɡ̶ojedi madeegitiogi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Odaa aɡ̶ica daɡ̶a leegi, joɡ̶oikatedice leelatiidi, odaa joɡ̶odiotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus igoawaanigi odoe, odaa ja naditediogi eletidi itoataale ɡ̶oneleegiwadi dinioxomigi, ane liboonaɡ̶adi Tiago ijaa João, lionigipi Zebedeu. Idiaaɡ̶i catinedi niwatece ijaaɡ̶eniodi, onapade icoa leelatiidi. Odaa Jesus jeɡ̶eniditediogi modiotece. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Odaa aɡ̶ica daɡ̶a leegi jidiaa oyaladi Zebedeu, niɡ̶ijo eniodi, ajaaɡ̶ajo liwatece, odaa joɡ̶odiotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus igotedeloco idiwatawece nipodaɡ̶a Galiléia. Diiɡ̶axinaɡ̶atedibece minoataɡ̶a liiakanaɡ̶axiidi judeutedi. Yeloɡ̶oditedibece ɡ̶obodicetedi anele micota me iiɡ̶e Aneotedoɡ̶oji ɡ̶odaaleɡ̶enali. Codaa nicilatiditedi ijotawece niɡ̶ijoa eelotaginadi, codaa me ijotawece niɡ̶ijo ane nawikodeeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nibodicetedi aneetece Jesus ilaagiteloco iditawece nipodigi Síria. Joaniɡ̶idaa leeɡ̶odi monadeegitalo Jesus ijotawece niɡ̶ijoa eelotaginadi. Odaa icilatidi inoatawece ane latopaco neelotika, codaa me niɡ̶inoa ane ɡ̶odileenaɡ̶a, inoa anodakatiogi niwicidi abeyacaɡ̶aɡ̶a, codaa nicilatiditedi yetoledi, codaa me alejaadotedi ane daɡ̶adiaa ditineɡ̶e. Jesus nicilatidi ijotawece niɡ̶ijo anenagitibeci midoataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eliodi oko anodiotece. Idi ica noiigi anoicoɡ̶oticogi nipodigi Galiléia, idi anoicoɡ̶oticogi micoataɡ̶a icoa deez nigotadi anei oko anodotaɡ̶atigi nioladi greegotedi, idi anoicoɡ̶oticogi nigotaɡ̶a Jerusalém, codaa me nipodigi Judéia, codaa midiwataɡ̶a nipodaɡ̶a daato akiidi Jordão. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Niɡ̶ijo naɡ̶a naditetege Jesus niɡ̶ijo noiigi-nelegi anenagitibeci midoataɡ̶a, odaa ja dalaɡ̶atetedibigimece ica lojotaɡ̶adi, odaa ja nicotedini. Odaa niɡ̶ijo oko anodiotece joɡ̶odipegitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Odaa Jesus jiɡ̶idaaɡ̶eyatedigi me niiɡ̶axinaɡ̶atediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Odaa mee, “Niɡ̶ina oko anoyowooɡ̶odi me diɡ̶ica ane leeɡ̶odi daɡ̶a dinanetibigiwaji lodoe Aneotedoɡ̶oji, Aneotedoɡ̶oji icota me iiɡ̶e laaleɡ̶enali niɡ̶idi oko, joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Niɡ̶ina oko ane agecaɡ̶alodipi niɡ̶ina natigide, Aneotedoɡ̶oji icota me yocaɡ̶aneɡ̶e niɡ̶idi oko, joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Niɡ̶ina oko ane diniwikodetibece lodoe Aneotedoɡ̶oji, Aneotedoɡ̶oji eote me nebi inatawece iiɡ̶o, joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Niɡ̶ina oko ane doletibige ane iɡ̶enaɡ̶a, Aneotedoɡ̶oji icota meote meletibigiwaji, leeɡ̶odi me liciagi niɡ̶ina oko ane nigodi nigigi, codaa me ecibi. Odaa nigoyakadi anoyeligo, codaa anowacipe, odaa jeɡ̶eletibigiwaji. Joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Niɡ̶ina oko anoiwikode eledi oko, Aneotedoɡ̶oji aaɡ̶aɡ̶a niwikodetediniwace, joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Niɡ̶ina oko ane yapidi laaleɡ̶enali, icota monadi Aneotedoɡ̶oji. Joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Niɡ̶ina oko ane ilakidetaciwage niɡ̶ina oko anijo me nidelaɡ̶a, Aneotedoɡ̶oji eetediogi me lionigipi. Joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Niɡ̶ina oko anoiatetibece leeɡ̶odi mowo ane iɡ̶enaɡ̶a, icota Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali codaa me yaxawatediogi. Joaniɡ̶idaa leeɡ̶odi niɡ̶idi oko midioka limedi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Niɡ̶ina oko nigodotaɡ̶atibigaɡ̶ajitiwaji, nige etiɡ̶adiatenitibece codaa nige odiwitakatibigaɡ̶ajitiwaji, modi mawii ane beyagi, leeɡ̶odi me aniwiticitiwaji, odaa icota maniniitibecitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Enice aniniitibecitiwaji, igaataɡ̶a Aneotedoɡ̶oji yotetetedaɡ̶adomi digoida ditibigimedi niɡ̶ica ɡ̶anaɡ̶ajegi ane daɡ̶axa mele. Igaataɡ̶a jiɡ̶idaaɡ̶ee moiatetibeci niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide. (Odaa Aneotedoɡ̶oji yajigotediogi naɡ̶ajegi anele.) ");
INSERT INTO kbcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Niɡ̶ida makamaɡ̶akaamitiwaji ɡ̶adiciagi yoci liwigotigi inatawece oko. Pida niɡ̶ina yoci nige aniaditema loniciwaɡ̶a ane daɡ̶a ika me beyagi niweenigi, odaa aɡ̶aleeɡ̶ica ɡ̶onimaweneɡ̶egi daɡ̶a agelaɡ̶atiti loniciwaɡ̶a. Odaa aɡ̶aleeɡ̶ica ane jaoɡ̶a, alati, odaa oko joɡ̶onipodi. (Odaa jiɡ̶idaaɡ̶enitiwaji ɡ̶adiciagi yoci, leeɡ̶odi aɡ̶ikanitiwaji niɡ̶ina ane beyagi daɡ̶a ibeyacaɡ̶adi oko lewiɡ̶a.) ");
INSERT INTO kbcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Niɡ̶ida makaamitiwaji aaɡ̶aɡ̶a ɡ̶adiciagi naɡ̶ana lokokena ane naloteloco inatawece oko, igaataɡ̶a aɡ̶ica anaɡ̶atitini, leeɡ̶odi mikeeni catiwedi ɡ̶adewiɡ̶a ane yemaa Aneotedoɡ̶oji. Codaa aɡ̶ica ane yakadi me yaɡ̶aditini nigotaɡ̶a anodabiteɡ̶eti ditibigimedi wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aɡ̶ica ane yalegi noledaɡ̶axi, oditaɡ̶a yapoɡ̶oditinigi anigetaɡ̶ada naɡ̶aaɡ̶axi. Pida naɡ̶ana noledaɡ̶axi oipeke ditibigimedi, mowo me naloteloco iditawece ane idei catiwedi diimigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jiɡ̶idaaɡ̶ee ikani ɡ̶anilokokenatiwaji me ídi, amaleeɡ̶aɡ̶a oyakadi niɡ̶ina eledi oko monadi ɡ̶abakedi anele anawiitetiwaji, awii modoɡ̶etetibigimece Ǥadiodi ane ideite ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jinaɡ̶aleetibige daɡ̶a janagi me jaaɡ̶adi lajoinaɡ̶aneɡ̶eco Moisés, ijaa liiɡ̶axinaɡ̶aneɡ̶eco niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. Ee ajanagi daɡ̶a jaaɡ̶adi liiɡ̶enatakaneɡ̶eco Moisés, pida janagi me jotete codaa me jao me yeloɡ̶o niɡ̶ica anodiiɡ̶axinaɡ̶atece. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Nigepaaɡ̶icota me daa ditibigimedi, codaa me iiɡ̶o, aɡ̶ica ane noɡ̶a gaantokaaɡ̶idi niɡ̶inoa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji. Aɡ̶ica gaantokaaɡ̶idi anonoɡ̶a nigepaa owidijegi noko nige ma niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enice niɡ̶ina oko ane daɡ̶a yotete okanicodaaɡ̶ica niiɡ̶enatakaneɡ̶ecawaanigi ane deɡ̶ewi me ɡ̶oneɡ̶egi, codaa nige iiɡ̶axi eledi oko me deɡ̶eyiwaɡ̶adi, odaa niɡ̶ini oko lionigawaanigi liwigotigi niɡ̶ina oko Aneotedoɡ̶oji ane iiɡ̶e. Pida niɡ̶ina oko ane yotete ijoatawece niiɡ̶enatakaneɡ̶eco, codaa maɡ̶aɡ̶a iiɡ̶axi eledi oko me yotete idiwatawece niiɡ̶enatakaneɡ̶eco, niɡ̶ini oko baaniɡ̶iniaa daɡ̶axa me ɡ̶oneɡ̶egi liwigotigi niɡ̶idi oko Aneotedoɡ̶oji ane iiɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Igaataɡ̶a ejitaɡ̶awatiwaji icota Aneotedoɡ̶oji me iiɡ̶e ɡ̶adaaleɡ̶enali, codaa akaamitiwaji jiɡ̶ida anenitege nige daɡ̶axa me ɡ̶adeɡ̶enakitiwaji caticedi niɡ̶inoa fariseutedi inaa niɡ̶ina niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Niɡ̶ida makaamitiwaji jaɡ̶ajipaata niɡ̶ijo Moisés aneeta, aneetiogi jotigide ɡ̶adaamipi, ‘Jineɡ̶eloati eledi oko! Igaataɡ̶a niɡ̶ina ane daije oyadeegiticogi minitaɡ̶a ɡ̶oniwinoɡ̶odi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pida ejitaɡ̶awatiwaji niɡ̶ina oko ane yelatema nioxoa me diɡ̶ica leeɡ̶odi, niɡ̶ini ɡ̶oniwinoɡ̶odi iwi niɡ̶ica anodaaɡ̶igota. Nigica aneeta nioxoa, ‘Akaami yetole!’ Joaniɡ̶iniaa oyadeegiticogi miditaɡ̶a seteenta lacilodi noiigi. Niɡ̶ijo aneeta nioxoa me daɡ̶axa me beyagi, aɡ̶aleeɡ̶ica aneetege Aneotedoɡ̶oji, codaa doidetibige Aneotedoɡ̶oji me iiɡ̶etedicogi niɡ̶ini oko minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Enice nige emii Aneotedoɡ̶oji liɡ̶eladi madeegitalo noɡ̶eedi ditibigimedi nameeja Aneotedoɡ̶oji, odaa analakitibige ɡ̶anioxoa mijo me dinotigimadetaɡ̶agi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Idiaaɡ̶anitice ɡ̶aboonigi lodoe nameeja. Odaa ecoɡ̶otace oleetibige me ɡ̶adilakiitege ɡ̶anioxoa, nigidiaaɡ̶idi nige naɡ̶a ɡ̶adilakiitege, odaa jaɡ̶ajicitalo Aneotedoɡ̶oji niɡ̶ica ɡ̶aboonigitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nigica ane lowoogo me ɡ̶adadeegita ɡ̶oniwinoɡ̶odi me yeloɡ̶odi mida ɡ̶adoenatagi ane beyagi, adinilakidenitege maleediɡ̶icoota ɡ̶oniwinoɡ̶odi. Igaataɡ̶a doidetibige daɡ̶a ɡ̶adadeegiticogi minitaɡ̶a ɡ̶oniwinoɡ̶odi, odaa ɡ̶oniwinoɡ̶odi ja ɡ̶adajicitiogi iodaɡ̶awadi. Odaa iodaɡ̶awadi etiɡ̶adixomitiwece niwiloɡ̶onaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aɡ̶anotiticogitiwaji niwiloɡ̶onaɡ̶axi nigepaaɡ̶ediani icoatawece niɡ̶icoa ɡ̶anaaleweta niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Niɡ̶ida makaamitiwaji joɡ̶owooɡ̶oti niɡ̶ijo aneeta Moisés niɡ̶ijo jotigide, neɡ̶ee, ‘Jinaɡ̶a ɡ̶adoomatewa iwaalo wadonaɡ̶a.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pida ejitaɡ̶awatiwaji, niɡ̶ina ɡ̶oneleegiwa ane iwita iwaalo ane daɡ̶a lodawa, odaa nige yowo me loomatewa, odaa catiwedi laaleɡ̶ena ja doɡ̶olaɡ̶ataka. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Enice ɡ̶agecooɡ̶eli nigeo mowoo ane beyagi catiwedi ɡ̶adaaleɡ̶ena, odaa anoɡ̶aatice ɡ̶agecooɡ̶e, alati! Igaataɡ̶a daɡ̶axa mele maniatitema ɡ̶agecooɡ̶e, pida aɡ̶oyokoletiogi iditawece ɡ̶adolaadi minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ǥabaaɡ̶adi nigeo mawii ane beyagi, akagiti, odaa alati. Igaataɡ̶a daɡ̶axa mele maniatitema onidateci ɡ̶abaaɡ̶adi, pida aɡ̶oyokoletiogi iditawece ɡ̶adolaadi minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Moditibece niɡ̶ijo jotigide, ‘Niɡ̶ina ane yaladi naɡ̶ana lodawa, odaa leeditibige me yajigota notaɡ̶anaɡ̶axi me ikee naɡ̶a yaladi lodawa.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pida ejitaɡ̶awatiwaji, inoatawece ɡ̶oneleegiwadi anoiiɡ̶e lodawa mopi, odaa naɡ̶ani iwaalo nige wadotace, odaa niɡ̶ini ɡ̶oneleegiwa nalatoɡ̶odi jeɡ̶eo me doɡ̶olaɡ̶ataka naɡ̶ani iwaalo. Codaa niɡ̶ini gela lodawa naɡ̶ani iwaalo jaɡ̶aɡ̶a doɡ̶olaɡ̶ataka. Idoka yakadi malati ɡ̶adodawa nige ɡ̶adoɡ̶olaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Codaa owooɡ̶otitiwaji anoditiogi niɡ̶ijo jotigide ɡ̶odaamipi, noɡ̶oditiogi, ‘Jinaɡ̶a inetee niɡ̶ina naɡ̶awii anigida ɡ̶agegi, pida awii niɡ̶ica ane enitalo Ǥoniotagodi Aneotedoɡ̶oji mawii.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pida ejitaɡ̶awatiwaji, nigawii ɡ̶agegi, jinaɡ̶abakeni liboonaɡ̶adi anigetiɡ̶idi, oteɡ̶exaaɡ̶aɡ̶a eledi oko liboonaɡ̶adi. Jinaɡ̶a aboonaɡ̶ateeni ditibigimedi mawii ɡ̶agegi, igaataɡ̶a ditibigimedi jiɡ̶idiaaɡ̶i me diiɡ̶enataka Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Codaa jinaɡ̶abakeni liboonaɡ̶adi niɡ̶ina iiɡ̶o, igaataɡ̶a niɡ̶ina iiɡ̶o liciagi naɡ̶ana baanco aneite Aneotedoɡ̶oji me nipeneɡ̶etedini loɡ̶onaka. Codaa jinaɡ̶abakeni liboonaɡ̶adi Jerusalém, igaataɡ̶a naɡ̶ani nigotaɡ̶a nebi Aneotedoɡ̶oji, minionigi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Codaa jinaɡ̶abakeni niboonaɡ̶adi makamaɡ̶a ɡ̶adacilo mawii ɡ̶agegi, igaataɡ̶a aɡ̶ica ɡ̶animaweneɡ̶egitece ɡ̶adacilo molii me diɡ̶ica otiɡ̶idatece ɡ̶adamodi me yapacaɡ̶a migetaɡ̶a nabidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pida nigawii ɡ̶agegi, onexaaɡ̶eni, ‘Jao’, oɡ̶oa domige eni, ‘Ajao’, igaataɡ̶a daɡ̶awii eledi ɡ̶agegi, niɡ̶ida eledi ɡ̶agegi ja icoɡ̶oticogi mijotaɡ̶a niɡ̶ijo ane beyagi, ɡ̶odaxakawa. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Owooɡ̶otitiwaji niɡ̶ijo jotigide moditibece, ‘Anoɡ̶aa ligecooɡ̶e niɡ̶ina ane napoace ligecooɡ̶e eledi oko. Codaa aninokeni lowe niɡ̶ina ane ninoke lowe eledi oko.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pida ejitaɡ̶awatiwaji jinoɡ̶oojeteeta niɡ̶ina aneo ane beyagitaɡ̶adomi. Nigica ane yabaketigi ɡ̶adajice, odaa ajici eledi ɡ̶adajice maɡ̶aɡ̶a yabake. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nigica ane ɡ̶adadeegiticogi minitaɡ̶a ɡ̶oniwinoɡ̶odi me doletibige me dinigaanyetece ɡ̶anoecaɡ̶axi, odaa ikanitece maɡ̶aɡ̶a yadeegi ɡ̶anibalito. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nigica iodaɡ̶awa ane iiɡ̶etaɡ̶awa moyaɡ̶ati loyaɡ̶aka onadateci ciloomito, odaa adeegitema nigepaa itoa ciloomito. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ediani niɡ̶ina oko ane dipokotibece, codaa jinaɡ̶aciiletema niɡ̶ina ane dadilaɡ̶ataɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Owooɡ̶otitiwaji niɡ̶ijo jotigide moditibece, ‘Leeditibige memaani ɡ̶adoiigi, odaa ɡ̶adeleɡ̶edi niɡ̶ina anakaami leleɡ̶edi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pida ejitaɡ̶awatiwaji leeditibige memaani ɡ̶aneloɡ̶ododipi. Codaa oeni motaɡ̶aneɡ̶eni niɡ̶ina anetiɡ̶adixoomitiwaji. Codaa otaɡ̶aneɡ̶eni Aneotedoɡ̶oji mipokitalo meote aneletema niɡ̶ina aneo ane beyagitaɡ̶adomitiwaji codaa niɡ̶ina anetiɡ̶adiatenitibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Odaa jiɡ̶ikeenitiwaji mewi makaami lionigipi Ǥadiodi ane ideite digoida ditibigimedi. Iniaaɡ̶iniwa daɡ̶axa meletedoɡ̶odomi, igaataɡ̶a eote naɡ̶ani aligeɡ̶e ane nebi me naloteloco oko anele, codaa me niɡ̶ina oko ane beyagi. Codaa niwakateetedigi ebici niɡ̶ina oko ane iɡ̶enaɡ̶a, codaa me niɡ̶ina ane daɡ̶a iɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Igaataɡ̶a nige inoka emaani niɡ̶ina ane ɡ̶ademaanitiwaji, Aneotedoɡ̶oji ayajigotedaɡ̶awatiwaji ɡ̶anaɡ̶ajegi, igaataɡ̶a niɡ̶ina anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, jiɡ̶idiaaɡ̶idi analeetibige doɡ̶owidi libeyaceɡ̶eco, pida idiaaɡ̶idi oyemaa lokaaɡ̶etedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nige anicenitiwaji codaa nige ikeenitiogi ɡ̶ademaanaɡ̶aneɡ̶egi idiokidi ɡ̶adoiigi, odaa aɡ̶awiitetiwaji anele caticedi niɡ̶idi eledi oko anowo, igaataɡ̶a niɡ̶ina oko ane doɡ̶oyowooɡ̶oditeda Aneotedoɡ̶oji owo liciagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Odaa niɡ̶ida makaamitiwaji leeditibige mawii aneletema inatawece oko liciagi Ǥadiodi ane ideite ditibigimedi, igaataɡ̶a idioka limedi meletetema inatawece oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus eɡ̶idaa diitigi me dotaɡ̶a, odaa mee, “Adinowetitiwaji! Niɡ̶ina nigaxawanitiwaji niɡ̶ina anida lemaɡ̶amatiigi, jinaɡ̶awii lodoe eledi oko, moleetibige metiɡ̶adiweniɡ̶ideni. Igaataɡ̶a nigawiitiwaji me lodoe eledi oko, odaa Ǥadiodi ane ideite ditibigimedi ayajigotedaɡ̶awa ɡ̶anaɡ̶ajegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Enice niɡ̶ina maxawani okanicodaaɡ̶ica oko anida lemaɡ̶amatiigi, jinaɡ̶a adineleɡ̶enitiogi inatawece oko micataɡ̶a niɡ̶ina oko anokowo meletibigiwaji minoataɡ̶a niɡ̶inoa niiakanaɡ̶axiidi, codaa me ladicotiidi nigotaɡ̶a. Niɡ̶idi oko inoka odoletibige moiweniɡ̶ide. Ejitaɡ̶awatiwaji niɡ̶ina anewi, niɡ̶idi oko jiɡ̶idokida moiweniɡ̶ide, odaa aɡ̶odibatege naɡ̶ajegi ane domaɡ̶a yajigotediogi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pida niɡ̶ina maxawani okanicodaaɡ̶ica oko anida lemaɡ̶amatiigi, awii makamokakaami mowooɡ̶oti! ");
INSERT INTO kbcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Odaa jiɡ̶idaaɡ̶ee aɡ̶ica ane yowooɡ̶odi niɡ̶ina maxawani niɡ̶ina oko anida lemaɡ̶amatiigi. Iniokiniwateda Ǥadiodi me yowooɡ̶odi! Igaataɡ̶a baɡ̶a nadi inoatawece. Odaa yajigotedaɡ̶awa ɡ̶anaɡ̶ajegi lodoe eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Niɡ̶ina motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, jinaɡ̶awii liciagi niɡ̶ina oko anokeo mele, ane lemaanigi me dabiditiniwace niɡ̶ina moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji catiwedi liɡ̶eladi Aneotedoɡ̶oji, inaa loɡ̶omoce ladicotiidi, owotibige minatawece oko onadi odaa oiweniɡ̶ide. Ejitaɡ̶awatiwaji niɡ̶ina anewi, aɡ̶odibatege anigetiɡ̶ica naɡ̶ajegi miniwataɡ̶a Aneotedoɡ̶oji, inoka odibatege liweniɡ̶idenaɡ̶aneɡ̶egi niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pida niɡ̶ida makaami, nigotaɡ̶aneɡ̶eni Aneotedoɡ̶oji, akaatiwece ɡ̶adiɡ̶eladi, anibatooni ɡ̶adapoagi, odaa otaɡ̶aneɡ̶eni Aneotedoɡ̶oji Ǥadiodi, leeɡ̶odi iniwa okanicodaaɡ̶ica ane onitice. Jiɡ̶iniaa Ǥadiodi ane ɡ̶adati okanicodaaɡ̶ica ane onitice odaa yajigotedaɡ̶awa ɡ̶anaɡ̶ajegi lodoe eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Niɡ̶ina motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, jinoɡ̶opilaɡ̶atitibigeloco ɡ̶agegi ane diɡ̶icata ane niitigi, anee niɡ̶ina oko ane doɡ̶oyowooɡ̶oditeda Aneotedoɡ̶oji. Igaataɡ̶a odiletibige Aneotedoɡ̶oji daɡ̶a wajipatediogi niɡ̶ina meliodi me notaɡ̶anaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jinoɡ̶otaɡ̶aneɡ̶eni Aneotedoɡ̶oji daɡ̶awii liciagi niɡ̶ina oko, igaataɡ̶a Aneotedoɡ̶oji Ǥadiodi ja yowooɡ̶odi anopootibige, maleediɡ̶icatibige diɡ̶ipokitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Enice nigotaɡ̶aneɡ̶eni Aneotedoɡ̶oji etida alitigi ɡ̶agegi, ‘Ǥodiodi anadeoni digoida ditibigimedi, jemaanaɡ̶a minatawece oko oiweniɡ̶ide Ǥaboonaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iiɡ̶eni laaleɡ̶enali niɡ̶ina oko. Jemaanaɡ̶a niɡ̶ina oko mowo digoina iiɡ̶o niɡ̶ica anemaani, digo anee midi anowo anemaani digoida ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ǥodedianiɡ̶itece ɡ̶oweenigi ane jopooɡ̶atibige niɡ̶ina noko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ixomaɡ̶ateenitedice ɡ̶obeyaceɡ̶eco, digo anejinaɡ̶a me jixomaɡ̶ateenaɡ̶atedice libeyaceɡ̶eco eledi oko anowotoɡ̶odomi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jiniɡ̶ikani niɡ̶ina ane beyagi daɡ̶a ɡ̶odice oditeɡ̶eo me jaoɡ̶a ane beyagi. Pida ɡ̶odatamaɡ̶ateenitege ane beyagi, niɡ̶ijo ɡ̶odaxakawa. Igaataɡ̶a jaɡ̶akamaɡ̶akaami ane iiɡ̶eni laaleɡ̶enali niɡ̶ina oko. Niɡ̶ida makaami eliodi ɡ̶adoniciwaɡ̶a, codaa inatawece oko odoɡ̶etetaɡ̶awa. Odaa jiɡ̶idaaɡ̶ee nigepaa ganigicatibige. Jiɡ̶idaaɡ̶ee (Amém).’ ");
INSERT INTO kbcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Igaataɡ̶a nige ixomaɡ̶ateenitedicetiwaji libeyaceɡ̶eco eledi oko anowotaɡ̶adomi, odaa Ǥadiodi ane ideite ditibigimedi aaɡ̶aɡ̶a ixomaɡ̶ateetedice ɡ̶abeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pida nige daɡ̶a ixomaɡ̶ateenitedice libeyaceɡ̶eco eledi oko anowotaɡ̶adomi, odaa Ǥadiodi aixomaɡ̶ateetedice ɡ̶abeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ele midatibece me daɡ̶a jiniodaɡ̶a niɡ̶ina me joleeɡ̶atibige meneɡ̶egi jipecaɡ̶atege Aneotedoɡ̶oji. Nige ikanawaanigi manioditiwaji motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, jinaɡ̶awii micataɡ̶a daɡ̶akaami agecaɡ̶alo, anee niɡ̶ina anokowo meletibigiwaji. Igaataɡ̶a anapiladaɡ̶a owotibige eledi oko moyowooɡ̶odi moikanawaanigi me niodaɡ̶a. Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶idi oko aɡ̶odinigaanyetetece laɡ̶ajedi Aneotedoɡ̶oji, inoka odinigaanyetece liweniɡ̶idenaɡ̶aneɡ̶egi niɡ̶ina eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Pida akamaɡ̶akaamitiwaji, niɡ̶ina me daɡ̶aniodi, anapiladi, codaa iteci ɡ̶adamodi, odaa aɡ̶oyowooɡ̶odi niɡ̶ina eledi oko mikanawaanigi maniodi. Pida iniokiniwateda Ǥadiodi ane ideite ditibigimedi codaa ane ideite okanicodaaɡ̶ica ane oni baɡ̶a yowooɡ̶odi. Odaa Ǥadiodi ane nadi anawii okanicodaaɡ̶ica ane oni, yajigotedaɡ̶awa ɡ̶anaɡ̶ajegi lodoe niɡ̶ina oko anigida noko. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jinaɡ̶a ateciɡ̶i ɡ̶aniliicaɡ̶ajetecidi digoina iiɡ̶o, igaataɡ̶a inoa ipilaɡ̶awaana inaa ligowiiɡ̶a anoyaaɡ̶adi ane ɡ̶oniliicaɡ̶ajetecidi, codaa inoa olicaɡ̶aɡ̶a moyojiketi nibaloote diimigi, odaa ja dakatiobece me nolicaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pida ateciɡ̶i ɡ̶aniliicaɡ̶ajetecidi digoida ditibigimedi ane diɡ̶icoa ipilaɡ̶awaana inaa ligowiiɡ̶a doɡ̶oyaaɡ̶adi ane ɡ̶anepilidi, oteɡ̶exaaɡ̶aɡ̶a olicaɡ̶aɡ̶a aɡ̶oyakadi me dakatiobece daɡ̶a nolicaɡ̶a. Igaataɡ̶a niɡ̶icoa ɡ̶oniliicaɡ̶ajetecidi digoida ditibigimedi aliciaco niɡ̶inoa ane jakataɡ̶ate digoina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Igaataɡ̶a niɡ̶ida moko ɡ̶odemaanigi midiokaanaɡ̶a limedi me idejonaɡ̶a aneite ɡ̶oniliicaɡ̶ajetecidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nigoleetibige inokina ane yemaa Aneotedoɡ̶oji, odaa ɡ̶adiciagi niɡ̶ina oko anele ligecooɡ̶eli. Micataɡ̶a nilokokena Aneotedoɡ̶oji daɡ̶a dakatiwece ɡ̶agecooɡ̶eli, odaa idei catiwedi ɡ̶adaaleɡ̶ena me ikeetaɡ̶awa ane iɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pida nige doɡ̶oleetibige mawii ane yemaa Aneotedoɡ̶oji, odaa baɡ̶a ɡ̶adiciagi niɡ̶ina oko ane beyagi ligecooɡ̶eli. Micataɡ̶a nilokokena Aneotedoɡ̶oji daaditaɡ̶a yakadi me dakatiwece ɡ̶adaaleɡ̶ena me ikeetaɡ̶awa ane iɡ̶enaɡ̶a. Odaa nexogotiwe ɡ̶adaaleɡ̶ena. Codaa niɡ̶ica nexocaɡ̶a daɡ̶axa me nexocaɡ̶a, odaa aɡ̶akati doɡ̶owooɡ̶oti niɡ̶ica ane yemaa Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Aɡ̶ica ane yakadi me dibatema iniwataale necalaixedi, igaataɡ̶a oniniteci yemaa, iniɡ̶eledi baɡ̶a leleɡ̶edi, odaa yoe libakedi niɡ̶ini anepaɡ̶a yemaa. Pida niɡ̶ini eledi baadaɡ̶a deemitetibige. Aɡ̶akatitiwaji mabaatema Aneotedoɡ̶oji, oditaɡ̶aɡ̶a oleetibige mowidi ɡ̶aninyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Enice ejitaɡ̶awatiwaji jinaɡ̶aɡ̶owikomataatibige ɡ̶aweenigi, codaa anopootibige me ɡ̶adewiki, codaa jinaɡ̶a aɡ̶owikomataatibige ɡ̶adowoodaɡ̶agi ane leeditibige madinixomitinigi, igaataɡ̶a aɡ̶odewiɡ̶atema diɡ̶idokida me idinixomaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Digawini niɡ̶inoa ilaaɡ̶axodi ane wayotiwaji digoina! Aɡ̶enanaɡ̶anaɡ̶a, codaa aɡ̶icoa lawodigijedi doɡ̶onopilaɡ̶aditedio, codaa aɡ̶oyatecoɡ̶otee liweenaɡ̶a. Pida Ǥadiodi ane ideite ditibigimedi aɡ̶ica daɡ̶a ika maniaditibige liweenigi. Odaa niɡ̶ida makaamitiwaji baɡ̶a daɡ̶axa mida ɡ̶aniwalótema Aneotedoɡ̶oji caticedi niɡ̶inoa ilaaɡ̶axodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aɡ̶ica ane yakadi me iigitice lewiɡ̶a otiɡ̶idatece noko leeɡ̶odi me igecaɡ̶aleɡ̶e niɡ̶ica ane yopotibige me yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Igaamee ina me ɡ̶adigecaɡ̶aleɡ̶enitiwaji ɡ̶adowoodaɡ̶agi? Digawini anodaaɡ̶ee me iliteloco nipodigi niɡ̶inoa niale lawoɡ̶o. Niɡ̶idiwa niale lawoɡ̶o anibaaɡ̶a, codaa aɡ̶icoa lowoodi loenataka modinixotinigilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pida ejitaɡ̶awatiwaji niɡ̶inoa niale lawoɡ̶o daɡ̶axa me libinienaɡ̶a caticedi niɡ̶icoa lowoodi inionigi-eliodi Salomão anowidi niliicaɡ̶ajetecidi codaa dinixotinigilo nowoodi ane daɡ̶axa me libinienaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Digawini niɡ̶ina nadegogo aninaa, icota me yadilo, odaa joɡ̶oyalegi. Aneotedoɡ̶oji eote nadegogo me libinienigi micataɡ̶a daɡ̶a dinixotinigilo niɡ̶inoa nowoodi ane daɡ̶axa me libinienaɡ̶a. Enice nigeote nadegogo me libinienigi, odaa ajawienatakanaɡ̶a maɡ̶aɡ̶a ɡ̶adinixomeɡ̶enitetiwaji idaaɡ̶ida me deɡ̶eliodi ɡ̶atiwaɡ̶atakaneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Enice jinaɡ̶aɡ̶owikomataatiwaji, jineɡ̶eni, ‘Igamige jakataɡ̶a ane jelicaɡ̶a?’ codaa jineɡ̶eni, ‘Igamige jakataɡ̶a ɡ̶odowoodaɡ̶agi?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Igaataɡ̶a niɡ̶ina oko ane doɡ̶oyowooɡ̶oditeda Aneotedoɡ̶oji baɡ̶a odoɡ̶owikomatatibige anoyeligo, codaa me lowoodaɡ̶agi. Ǥadiodi ane ideite ditibigimedi yowooɡ̶odi mopootibigetiwaji maniodi, codaa anadinixomitinigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pida odoejegi oleetibige Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko, codaa oleetibige minatawece oko owo ane iɡ̶enaɡ̶a, odaa Aneotedoɡ̶oji ja yajigotedaɡ̶awatiwaji inatawece anopootibige. ");
INSERT INTO kbcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Enice jinaɡ̶a ɡ̶adigecaɡ̶aleɡ̶eni niɡ̶ica anopootibige natiinigoi. Igaataɡ̶a anoɡ̶owooɡ̶oti niɡ̶ica ane diɡ̶ica natiinigoi. Jaɡ̶abo niɡ̶inoa ane dakaketaɡ̶adomi niɡ̶ina noko, odaa aɡ̶ele daɡ̶a ɡ̶adigecaɡ̶aleɡ̶eni niɡ̶ica ane dakaketaɡ̶adomi natiinigoi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus eɡ̶idaa diitigi me diiɡ̶axinaɡ̶a, odaa mee, “Jinaɡ̶awini anee lewiɡ̶a eledi oko oditaɡ̶a adinanimiɡ̶ita, adaɡ̶aɡ̶akaami laagetedipi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Igaataɡ̶a Aneotedoɡ̶oji ɡ̶adiwini digo aneni me ɡ̶adiɡ̶oatita eledi oko. Anodaaɡ̶emiita eledi oko, odaa Aneotedoɡ̶oji idaɡ̶aɡ̶a igotedaɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Igame leeɡ̶odi mawini libatiicawaanigi ɡ̶anioxoa, ane micataɡ̶a daɡ̶a laɡ̶amicaɡ̶ajecawaanigi ɡ̶anioxoa, pida akamaɡ̶a ɡ̶abatiigi aɡ̶anati, ane micataɡ̶a daɡ̶a iwoɡ̶o liwai catiwedi ɡ̶agecooɡ̶elitiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ica mabo ɡ̶adaaleɡ̶ena menita ɡ̶anioxoa, ‘Inoɡ̶ataɡ̶adomi ɡ̶adaɡ̶amicaɡ̶ajegi’, pida idi iwoɡ̶o liwai catiwedi ɡ̶agecooɡ̶e? ");
INSERT INTO kbcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ǥadiciagi niɡ̶ina anokeo mele! Odoejegi leeditibige manoɡ̶aa iwoɡ̶o liwai ane idei catiwedi ɡ̶agecooɡ̶e, amanagawini anatiteloco manoɡ̶aa laɡ̶amicaɡ̶ajecawaanigi ɡ̶anioxoa. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jinaɡ̶ajicitiogi niɡ̶idi oko abeyacaɡ̶aɡ̶a niɡ̶ina ane iomaɡ̶aditetema Aneotedoɡ̶oji. Igaataɡ̶a niɡ̶idi oko liciagi necexodi ane diojo, odaa doidetibige deɡ̶etiɡ̶adowacitiwaji. Codaa jineɡ̶enitiogi niɡ̶idi oko niɡ̶inoa notaɡ̶a anele Aneotedoɡ̶oji ane yeloɡ̶oditedaɡ̶awa, igaataɡ̶a niɡ̶inoa notaɡ̶a Aneotedoɡ̶oji ane yeloɡ̶odi liciagi naɡ̶ana wetiɡ̶a ane daɡ̶axa me dakake loojedi. Codaa niɡ̶idi oko abeyacaɡ̶aɡ̶a aaɡ̶aɡ̶a liciagi nigidagiwadi. Nige okolenitiogi nigidagiwadi naɡ̶ani wetiɡ̶a, odaa joɡ̶onipoditibige naɡ̶ani wetiɡ̶a ane dakake loojedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ipokitalo Aneotedoɡ̶oji niɡ̶ica anopootibige, odaa jaɡ̶abaategetiwaji. Oleetibige miniwataɡ̶a Aneotedoɡ̶oji niɡ̶ina anele anepaa yemaa me yajigotedaɡ̶awatiwaji, odaa jaɡ̶akatitiwaji. Atokeni epoagi, odaa Aneotedoɡ̶oji ja yomoke. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Igaataɡ̶a inatawece oko anodipokotalo, odibatege lipoketegi, codaa inatawece oko anodoletibige anigidi, oyakadi. Codaa yomoketetema epoagi niɡ̶ina ane yatoke. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ǥadionigi nige dipokotaɡ̶awa paon, domige ajicita wetiɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ina me dipokotaɡ̶awa noɡ̶ojegi, domige ajicita lakeedi? ");
INSERT INTO kbcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niɡ̶ida makaami anakaami abeyacaɡ̶aɡ̶a, pida owooɡ̶oti majicita ɡ̶adionigipi niɡ̶ina anele. Apiɡ̶ikoa Ǥadiodi ane ideite ditibigimedi yajigotediogi niɡ̶ina anele niɡ̶ina oko modipokotalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Awiitema eledi oko niɡ̶ica anemaanitiwaji modigotaɡ̶awa. Igaataɡ̶a jiɡ̶idaaɡ̶ee me diiɡ̶axinaɡ̶a Moisés niɡ̶ijo naɡ̶a idí niɡ̶ijoa lajoinaɡ̶aneɡ̶eco, codaa jiɡ̶idaaɡ̶ee me niiɡ̶axinaɡ̶anaɡ̶a niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Adinoniciwaɡ̶ati makaatiwece mida epoacawaanigi. Igaataɡ̶a niɡ̶ida eledi epoagi nelegi codaa me niɡ̶ijo naigi aɡ̶ica laɡ̶aliigi me jiwaɡ̶atece dowiceta miditaɡ̶a ica aneitice niɡ̶ina oko me diɡ̶ica liniogo me nawikodeeɡ̶a. Codaa eliodi oko anodioteci niɡ̶ijo naigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pida niɡ̶ida epoacawaanigi ijaa niɡ̶ijo naicawaanigi ane dakake me jiwaɡ̶atece, baɡ̶a dowiceticogi miditaɡ̶a niɡ̶ica aneitice niɡ̶ina oko ane newiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji, odaa baadeɡ̶eliodi oko anodioteci niɡ̶ijo naicawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Anidakitiogi niɡ̶ina anodi moyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, pida niwitakaɡ̶a. Niɡ̶idi oko anokowo moyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko oinaale niɡ̶ina oko. Liciagi diwilecoɡ̶oni me doide, odinixotinigi lamodi waxacoco moinaale waxacoco. Odaa niɡ̶idi oko liciagi waxacoco. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pida icota mowooɡ̶oti anidi leeɡ̶odi niɡ̶inoa loenataka, anodaaɡ̶ee mowooɡ̶oti ane latopagi niale leeɡ̶otedi elali. Igaataɡ̶a naɡ̶ana omiigonaɡ̶a ayajigo uuva, codaa niɡ̶inoa lalepiɡ̶igoli aɡ̶oyajigo fiigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Odaa jiɡ̶idaaɡ̶ee naɡ̶ana niale anele yajigo elali anele, codaa naɡ̶ana niale ane deɡ̶ele yajigo elali ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Naɡ̶ana niale anele ayakadi daɡ̶a yajigo elali ane beyagi. Codaa naɡ̶ana niale ane beyagi ayakadi daɡ̶a yajigo elali anele. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Naɡ̶ana niale ane daɡ̶a yajigo elali anele, oyakagidi, odaa joɡ̶oyokoletiogi noledi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Joaniɡ̶idaa me jakataɡ̶a me jowooɡ̶otaɡ̶a naɡ̶ana niale leeɡ̶otedi elali ane yajigo. Jiɡ̶idaa maɡ̶aɡ̶a jakataɡ̶a me jowooɡ̶otaɡ̶a niɡ̶idiwa awitakaɡ̶a anodi moyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, leeɡ̶odi niɡ̶inoa loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eliodi oko idoka etidadatigi, ‘Iniotagodi, Iniotagodi!’ Pida aɡ̶iditawece odakatiwece digoida ditibigimedi aneitedice Aneotedoɡ̶oji me diiɡ̶enataka. Pida inokina niɡ̶ina anowo Eiodi ane yemaa, idiokidi baɡ̶a dakatiobece digoida ditibigimedi aneitedice Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Niɡ̶ica noko nige iwi Aneotedoɡ̶oji anigotediogi inatawece oko, odaa eliodi oko moditiwa, ‘Iniotagodi, Iniotagodi! Eliodi me jibakenaɡ̶a Ǥaboonaɡ̶adi codaa jeloɡ̶otaɡ̶atedibece lowooko Aneotedoɡ̶oji, codaa me jibakenaɡ̶a Ǥaboonaɡ̶adi me jiticodaɡ̶atedice niwicidi abeyacaɡ̶aɡ̶a, codaa me jibakenaɡ̶a Ǥaboonaɡ̶adi me jaoɡ̶ate ɡ̶odoxiceɡ̶etedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pida ejitiogi lodoe eledi oko, ‘Aɡ̶ica daɡ̶a ɡ̶adowooɡ̶oti. Adetecenitice, jaɡ̶akamaɡ̶akaamitiwaji anawii ane beyagi!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Niɡ̶ina ane wajipatalo yotaɡ̶a odaa eyiwaɡ̶adi, niɡ̶ini liciagi niɡ̶ina ɡ̶oneleegiwa anida lixakedi odaa dabiteɡ̶eteloco liɡ̶eladi ditibigimedi wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Naɡ̶a dinikatini ebici nelegi, odaa neɡ̶enagi abooɡ̶o-ninyoɡ̶odi, codaa niwocotaɡ̶a ane yoniciwadi jiɡ̶icota niɡ̶ijo diimigi, pida aɡ̶enitini. Leeɡ̶odi niɡ̶ijo ɡ̶oneleegiwa dabiteɡ̶etini liɡ̶eladi ditibigimedi wetiɡ̶a, anepeɡ̶ele me diimigi lipodaɡ̶aladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Niɡ̶ina ane wajipatalo yotaɡ̶a pida aɡ̶eyiwaɡ̶adi, baɡ̶a liciagi niɡ̶ina ɡ̶oneleegiwa ane diɡ̶ica lixakedi ane dabiteɡ̶etini liɡ̶eladi midi dotiwadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Naɡ̶a dinikatini ebici nelegi, odaa neɡ̶enagi abooɡ̶o-ninyoɡ̶odi, codaa niwocotaɡ̶a ane yoniciwadi jiɡ̶icota niɡ̶ijo diimigi, odaa ja dojitini, codaa aɡ̶ica ane yeyaɡ̶atice.” ");
INSERT INTO kbcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Naɡ̶a nigotedini Jesus me dotaɡ̶a, odaa ica lapo-nelegi joɡ̶oyopo leeɡ̶odi anodaaɡ̶eeteda me diiɡ̶axinaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Leeɡ̶odi adiiɡ̶axinaɡ̶a daɡ̶a liciagi niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, pida Jesus baɡ̶a ibake epaa naɡ̶atetigi me diiɡ̶axinaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Naɡ̶a daxoditedini Jesus me icoɡ̶otedibigimece ica lojotaɡ̶adi, odaa ica noiigi-nelegi joɡ̶odiotece. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Odaa ica ɡ̶oneleegiwa dawace-lolaadi jiɡ̶icotalo, odaa ja yamaɡ̶atedi lokotidi lodoe Jesus me iweniɡ̶ide, meetalo, “Iniotagodi, jowooɡ̶odi mida ɡ̶adoniciwaɡ̶a madicilatiti, nigemaani.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Odaa Jesus ja ixoketedice libaaɡ̶adi, naɡ̶a ipeketedeloco niɡ̶ijo ɡ̶oneleegiwa, odaa jeɡ̶eeteta, “Ee jemaa me ɡ̶adicili niɡ̶ina natigide!” Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo dawace-lolaadi ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Odaa Jesus jeɡ̶eete, “Digawini, jiniɡ̶ica aneloɡ̶otita niɡ̶ida anejigotaɡ̶awa. Pida emii, adinikeenita sacerdoti naɡ̶a ɡ̶adicili. Codaa aboonitalo Aneotedoɡ̶oji ɡ̶aboonigi ane liiɡ̶enatakaneɡ̶egi lajoinaɡ̶aneɡ̶egi Moisés, awiitibige me ikeenitiogi iditawece oko naɡ̶a akaami ele. Odaa yakadi mopiliticogi miditaɡ̶a ɡ̶adoiigiwepodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus igo nigotaɡ̶a Cafarnaum. Naɡ̶a dakatediwece nigotaɡ̶a, odaa ica goloneegi ane iiɡ̶e onaniteci taalia iodaɡ̶awadi, igo midoataɡ̶a, odaa ja dipokotalo me yaxawa. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Odaa meetalo Jesus, “Iniotagodi, ini iotagi lioneeɡ̶a digoida iɡ̶eladi eliodi me deelotika. Ayakadi oteɡ̶exaaɡ̶aɡ̶a me ditineɡ̶e, eliodi me dawikode.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Odaa Jesus jeɡ̶ee, “Ejigo jicilatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pida niɡ̶ijo goloneegi meetalo, “Aleeditibige deɡ̶emii akaatiwece iɡ̶eladi, Iniotagodi. Igaataɡ̶a daɡ̶axa makaami ɡ̶oneɡ̶egi, caticedi ee. Pida onexaaɡ̶awii ɡ̶agegi me icí, odaa inioneeɡ̶a ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Igaataɡ̶a inoa eletidi iodaɡ̶awadi ane leegitibigimece naɡ̶atetigi ane etidiiɡ̶e. Pida ee aaɡ̶aɡ̶a ida inaɡ̶atetigi maɡ̶aɡ̶a jiiɡ̶e onaniteci taalia iodaɡ̶awadi. Jakadi mejita okanicodaaɡ̶ica niɡ̶idiwa iodaɡ̶awadi, ‘Emii!’ Odaa jiɡ̶igo. Iniaa eledi nigejita, ‘Anagi!’ Odaa jeɡ̶enagi. Codaa nigejita niɡ̶ina iotagi, ‘Awii niɡ̶ida ane jiiɡ̶etaɡ̶awa!’ Odaa jeɡ̶eo. Odaa akaami ida ɡ̶anaɡ̶atetigi me iiɡ̶eni iotagi me ele, odaa ja icí.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Niɡ̶ica Jesus naɡ̶a wajipateta niɡ̶ijoa lotaɡ̶a niɡ̶ijo goloneegi, odaa eliodi me yopo niɡ̶ijo ɡ̶oneleegiwa. Odaa jeɡ̶eetediogi niɡ̶ijo noiigi anodiotece, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ida ɡ̶oneleegiwa eliodi meyiwaɡ̶adi Aneotedoɡ̶oji. Aniɡ̶ica jinadi oko oteɡ̶exaaɡ̶aɡ̶a minataɡ̶a ɡ̶odoiigi Israel ane nakato Aneotedoɡ̶oji, digo midataɡ̶a niɡ̶ida ɡ̶oneleegiwa me nakato Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ejitaɡ̶awatiwaji eliodi eledi oko, ane daɡ̶a judeutedi, icota me icoɡ̶oticogi nigoi codaa me ɡ̶ocidi, odaa nicooɡ̶owepodi Abraão, Isaque, Jacó miditaɡ̶a nalokegi Aneotedoɡ̶oji ane yoe digoida ditibigimedi, lalokegi loiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pida Aneotedoɡ̶oji aikatediobece eliodi oko loiigi judeutedi me dakatiobece miditaɡ̶a lalokegi. Aikatedio me dakatiobece niɡ̶ina oko ane daɡ̶a yemaa Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. Pida Aneotedoɡ̶oji baɡ̶a yokoletedicogi miditaɡ̶a nexocaɡ̶a anei me noenaɡ̶ateloco, codaa moyacigice lowe leeɡ̶odi me nawikodeeɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Odaa Jesus jeɡ̶eeteta niɡ̶ijo goloneegi, “Emii opiliticogi ɡ̶adiɡ̶eladi, ɡ̶aotagi ja icí leeɡ̶odi manakatoni Aneotedoɡ̶oji me yakadi me icilatidi.” Odaa aniaaɡ̶ani naɡ̶aca lakata Jesus neɡ̶ee, odaa niɡ̶ica liotagi niɡ̶ijo goloneegi ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Odaa Jesus jiɡ̶igo liɡ̶eladi Pedro. Naɡ̶a dakatedio, ja naditedeloco loxiiɡ̶ate Pedro miwotini, dapicoɡ̶o-lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Odaa ja ipeketedeloco libaaɡ̶adi naɡ̶ajo iwaalo, odaa ja icí. Naɡ̶a dabiditini, odaa ja doolaɡ̶a yoe liweenigi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naɡ̶a ɡ̶ocidi, joɡ̶onadeegitalo eliodi oko anodakatiogi niwicidi abeyacaɡ̶aɡ̶a, codaa me eelotaginadi. Odaa Jesus onexaaɡ̶eetediogi mopitibeci niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a, odaa ijoatawece noditedice miditaɡ̶a niɡ̶idi oko. Odaa ja nicilatiditediniwace iditawece eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jiɡ̶idaaɡ̶ee neɡ̶eote micotece niɡ̶ica aneeta Isaías, niɡ̶ijo ane yeloɡ̶oditibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, neɡ̶ee, “Yadeegi ɡ̶odeelotagi, codaa noɡ̶a ɡ̶odabocaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Naɡ̶a nadi Jesus ica noiigi-nelegi moyawiile, odaa ja iiɡ̶e niɡ̶ijo anodiotibece me diɡ̶etitacicoace daato niɡ̶ica weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Maleedaɡ̶a noditicoaci, odaa onijoteci niɡ̶ijo ane diiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés igo midoataɡ̶a Jesus, odaa jeɡ̶eetalo, “Niiɡ̶axinaɡ̶anaɡ̶a, ja idigo me jiotaɡ̶adici okanicodaaɡ̶icata ane aaticogi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Odaa Jesus jeɡ̶eeteta, “Niɡ̶inoa eti inoa libecoli, codaa ilaaɡ̶axodi inoa epaa libatoli. Pida Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, baadiɡ̶ica yotokaɡ̶adi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ica eledi ɡ̶oneleegiwa ane diotibece Jesus jeɡ̶ee, “Iniotagodi, jemaa me jiotaɡ̶adici. Pida ecoɡ̶otace jalita eiodi nige yeleo amaleeɡ̶aɡ̶a inaligitini.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pida Jesus jeɡ̶eeteta, “Aniwitici! Igaataɡ̶a niɡ̶ina oko liciagi émeɡ̶egi leeɡ̶odi aɡ̶oyemaa moniotici, odaa dioki epaa onaligitedini émaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Niɡ̶idiaaɡ̶idi Jesus ja waxoditedinigi ajo niwatece ijaaɡ̶ijo niɡ̶ijo anodiotibece lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Codaaɡ̶ida naɡ̶a enagi ica niwocotaɡ̶a aneo me itedibige ebekadi nelecoli. Odaa niɡ̶ijoa ebekadi ja domaɡ̶a oyapoɡ̶oditi niwatece. Pida idiaa Jesus diote. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Odaa niɡ̶ijo anodiotibece joɡ̶odipegitalo, oyojietelogo, moditalo, “Ǥoniotagodi, ɡ̶odaxawaneɡ̶egi! Ade jaaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Odaa Jesus meetediogi, “Igaamee ina madoiitiwaji? Amewi manakatonitetiwaji Aneotedoɡ̶oji.” Naɡ̶a dabiditedini, odaa ja iiɡ̶e niocodi inaa ebekadi me notokotiniwace. Odaa niɡ̶ijo niocodi ijaaɡ̶ijoa ebekadi ja notokotiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Odaa niɡ̶ijo anodiotibece eliodi moyopo, odaa ja dinotaɡ̶aneɡ̶e modi, “Amiidoa icoa ɡ̶oneleegiwa? Aneote niocodi idiaa ebekadi moyiwaɡ̶adi niɡ̶ina ane liiɡ̶enatakaneɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus jiɡ̶icotedicogi daato niweiigi Galiléia, nipodigi aca Gadara. Odaa joɡ̶odakapetege icoa itoataale ɡ̶oneleegiwadi ane dakatiogi niwicidi abeyacaɡ̶aɡ̶a, ja niɡ̶eladimigipitigi midiwa lawimaɡ̶ajetedi-wetiadi, ane onaligite judeutedi némaɡ̶aɡ̶a. Odaa jiɡ̶idiaa oicoɡ̶otiwece niɡ̶ijoa ɡ̶oneleegiwadi. Niɡ̶idiwa ɡ̶oneleegiwadi loidenaɡ̶a, codaa me doide, aɡ̶aleeɡ̶ica ane yakadi me dioteci niɡ̶ijo naigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Noɡ̶onaditege Jesus, odaa ja napaawaɡ̶a, modi, “Igaamee managi ɡ̶odigiwoceɡ̶egi, anakaami Lionigi Aneotedoɡ̶oji? Domige naɡ̶anagi me ɡ̶odiloikatiteɡ̶egi maleediɡ̶icota noko Aneotedoɡ̶oji nige iloikatidi niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco?” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Onidiwa icoa nigidagiwadi ane noxicoɡ̶onaɡ̶a aona leegitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Odaa niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a anodakatiogi niɡ̶ijoa itoa ɡ̶oneleegiwadi moditalo Jesus, “Nige ɡ̶odiiɡ̶eneɡ̶egi me ɡ̶ododiticogi niɡ̶inoa ɡ̶oneleegiwadi, pida ɡ̶odikaneɡ̶egi me jakaɡ̶atiogilo niɡ̶idiwa nigidagiwadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Odaa Jesus meetediogi, “Enice emiitiwaji!” Odaa niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a ja noditicoaci midiwataɡ̶a niɡ̶ijoa ɡ̶oneleegiwadi, odaa joɡ̶odakatiogilo niɡ̶ijoa nigidagiwadi. Odaa niɡ̶ijoa nigidagiwadi ja daleditedigi, odaa jeɡ̶enitinece ica lilokaɡ̶adi, odaa ja daxaboketiniwace, joɡ̶oceɡ̶aɡ̶a miditaɡ̶a weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Niɡ̶ijoa ɡ̶oneleegiwadi anodoweditelogo niɡ̶ijoa nigidagiwadi ja daleditibige odeleticogi nigotaɡ̶a, odaa joɡ̶oyatemati niɡ̶ica ane ninyaagi niɡ̶ijoa nigidagiwadi, codaa anee niɡ̶ijoa ɡ̶oneleegiwadi naɡ̶a noditicoaci niwicidi abeyacaɡ̶aɡ̶a anodakatiogi. ");
INSERT INTO kbcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Odaa ijotawece niɡ̶eladimigipitigi naɡ̶ajo nigotaɡ̶a jeɡ̶enagitibeci odakapetege Jesus. Noɡ̶onadi Jesus, odaa joɡ̶odipokotalo me noditedicogi niiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus naɡ̶a waxoditedinigi niwatece migo daato weiigi, odaa jiɡ̶icotedicogi manitaɡ̶a epaa nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Odaa icoa ɡ̶oneleegiwadi joɡ̶oyadeegitalo ica alejaado ane daɡ̶adiaa ditineɡ̶e ane iwoteloco aca liɡ̶elate. Naɡ̶a nadi Jesus moyiwaɡ̶adi Aneotedoɡ̶oji me yakadi me icilatidi niɡ̶ijo ɡ̶oneleegiwa, odaa jeɡ̶eeteta niɡ̶ijo alejaado, “Jinaɡ̶adoii, ionigi! Ja inapitaɡ̶adi ɡ̶abeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Odaa icoa onateciɡ̶idiwa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés dinotaɡ̶aneɡ̶etiwage modi, “Niɡ̶idoa ɡ̶oneleegiwa beyagi me dotaɡ̶atedibige Aneotedoɡ̶oji leeɡ̶odi niɡ̶ijoa lotaɡ̶a iniokiniwateda Aneotedoɡ̶oji me yakadi me ligegi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus yowooɡ̶oditediwe lowoogo, odaa meetediogi, “Igaameetiwaji mowoo ane beyagi? ");
INSERT INTO kbcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Amiida ica ane dakake mejatigi igegita idi alejaado? Domige eneɡ̶egi dakake deɡ̶ejita, ‘Ja ɡ̶adapitaɡ̶atitece ijoatawece ɡ̶abeyaceɡ̶eco’, oɡ̶oa domige ina deɡ̶ejita, ‘Adabititini, odaa awaligi!’? ");
INSERT INTO kbcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Niɡ̶ida me Ee jikeetaɡ̶awatiwaji me Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ida yoniciwaɡ̶a me inapitaɡ̶adi libeyaceɡ̶eco oko.” Odaa meete niɡ̶ijo alejaado, “Adabititini, odaa anibaatine naɡ̶adi ɡ̶aɡ̶elate, odaa emii digoida ɡ̶adiɡ̶eladi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Niɡ̶ijo ɡ̶oneleegiwa naɡ̶a dabiditini, odaa joɡ̶opiticogi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Niɡ̶ijo noiigi noɡ̶onadi niɡ̶ijo niciagi, odaa joɡ̶odoɡ̶etetalo Aneotedoɡ̶oji, leeɡ̶odi me yajigotediogi niɡ̶ina oko loniciwaɡ̶a monicilatiditiniwace eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus ja noditedicogi niɡ̶ica aneite, eɡ̶idaa diitedicogi mewaligi, odaa jiɡ̶icote ica diimicawaanigi balaacogo aneitice me nicoti ica ɡ̶oneleegiwa ane liboonaɡ̶adi Mateus. Mateus inaaɡ̶ina ane dibatibigege ninyeelo ninionigi-eliodi romaanotedi. Odaa Jesus jeɡ̶eeteta, “Anagi, aniwitici!” Odaa Mateus ja dabiditini, ja diotece. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Odaa Jesus jiɡ̶igo liɡ̶eladi Mateus, odaa ja nicotedi maditaɡ̶a aca nameeja. Naɡ̶a niodaɡ̶a menoale, jiɡ̶icotiobece eliodi niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, ijaaɡ̶ijo eliodi eledi oko, judeutedi anoyakadi me abeyacaɡ̶aɡ̶a. Odaa ja nicotiniwace miniwataɡ̶a Jesus ijaaɡ̶ijo anodiotibece maɡ̶aɡ̶a niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Icoa fariseutedi onadi Jesus me ligiiwepodi niɡ̶idi oko anoyakadi me abeyacaɡ̶aɡ̶a, odaa joɡ̶onigetiniwace niɡ̶ijo anodiotibece Jesus, moditiogi, “Igame leeɡ̶odi ɡ̶aniiɡ̶axinoɡ̶odi me ligiiwepodi idiwa anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, idiaaɡ̶idi idi eledi oko aninoa libeyaceɡ̶eco?” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus wajipatediogi niɡ̶ijoa fariseutedi monigetiniwace niɡ̶ijo anodiotibece, odaa meetediogi, “Niɡ̶ina oko icileɡ̶egi ayopotibige dotowegi, pida inokina niɡ̶ina ane deelotika baɡ̶a yopotibige dotowegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oleetibige mowooɡ̶oti ane diitigi niɡ̶ijoa lotaɡ̶a Aneotedoɡ̶oji, anee, ‘Ajemaa niɡ̶ina oko monajigotiwa eijedi monigodi leeɡ̶odi libeyaceɡ̶eco. Pida baɡ̶a jemaa niɡ̶ina oko mowo aneletema eledi oko.’ Igaataɡ̶a ajanagi jiniditiogi niɡ̶ina anoyakadi meletibigiwaji. Pida janagi jiniditiogi niɡ̶inoa abeyacaɡ̶aɡ̶a modopitalo Aneotedoɡ̶oji, igaataɡ̶a oyopotibige Aneotedoɡ̶oji me napitaɡ̶aditediniwace micataɡ̶a niɡ̶ina oko ane deelotika odaa yopotibige dotowegi me icilatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Icoa nioɡ̶ododi João Batista igotibeci midoataɡ̶a Jesus, odaa joɡ̶oige, moditalo, “Oko, idiaaɡ̶idiwa fariseutedi baɡ̶a jikanakawaanigi me jiniodaɡ̶a, jikeenaɡ̶a moko agecaɡ̶alodipi leeɡ̶odi ɡ̶obeyaceɡ̶eco. Igaamee idi ɡ̶anioɡ̶ododipi me doɡ̶oikanawaanigi me niodaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus naɡ̶a igidi, meetediogi, “Domige agecaɡ̶alodipi ina nodenigipi migotibeci lalokegi nadoneɡ̶egi ina mini miditaɡ̶a niɡ̶ijo ane wado? Aɡ̶agecaɡ̶alodipi! Pida icota noko monoɡ̶atice niɡ̶ijo ane wado miditaɡ̶a. Odaa niɡ̶ica noko jaɡ̶agecaɡ̶alodipi, odaa joɡ̶oikanawaanigi me niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aɡ̶ica ane napadeta nowoodaɡ̶agi oxiiɡ̶odi niɡ̶ina lapadenaɡ̶anaɡ̶adi gela anepaɡ̶alee yexogo, igaataɡ̶a niɡ̶idi lapadijegi gela nige dinixigi, odaa ja daa niɡ̶idi nowoodaɡ̶agi oxiiɡ̶odi. Odaa niɡ̶ica laakajegi ja daɡ̶axa me nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Codaa aɡ̶ica ane yadotinigi viinyo gela naɡ̶ana laɡ̶aaɡ̶axi ewacogo baanaɡ̶a opake. Nigeo iatinigi viinyo gela, odaa naɡ̶ada laɡ̶aaɡ̶axi opake datope, odaa viinyo jaɡ̶aɡ̶a aniadi. Pida oyatinigi viinyo naɡ̶aca laɡ̶aaɡ̶axi gela, odaa naɡ̶ada laɡ̶aaɡ̶axi abeyagi, codaa me viinyo eledi aɡ̶aleeɡ̶aniadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus eɡ̶idaaɡ̶ee me notaɡ̶aneɡ̶etediniwace niɡ̶ijo anodiotibeci João, niɡ̶icotalo ica lacilo judeutedi, odaa ja yamaɡ̶atedini lokotidi lodoe Jesus, meetalo, “Iona ja leedi me yeleo. Anagi ipekeniteloco ɡ̶abaaɡ̶atedi amaleeɡ̶aɡ̶a icí.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Odaa Jesus jiɡ̶igo lixigaɡ̶awa, ijaaɡ̶ijo anodiotibece eledi igotibeci odiotece. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Eɡ̶idaa diiticogi migotibeci, odaa aca iwaalo ja nowidila Jesus. Joneɡ̶eote dooze nicaaɡ̶ape mawodina. Naɡ̶a iwidatece Jesus, odaa dibatece nijayogo liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Naɡ̶ajo iwaalo eo niɡ̶ida anee, leeɡ̶odi mee me dowooko, “Onexaa jiba-aatece nijayogo liniogo, odaa ja idici.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naɡ̶a nilokotedijo Jesus, odaa ja nadi naɡ̶ajo iwaalo. Odaa jeɡ̶eete, “Iona, jinaɡ̶adoii! Ja ɡ̶adicili, leeɡ̶odi me iwaɡ̶ati Aneotedoɡ̶oji me yakadi me ɡ̶adicilatiti.” Naɡ̶ajo iwaalo naɡ̶a dibateloco nijayogo Jesus, odaa ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Niɡ̶idiaaɡ̶idi Jesus jiɡ̶igo liɡ̶eladi niɡ̶ijo lacilo judeutedi. Niɡ̶icotedio, odaa ja naditediogi niɡ̶ijo anoyatetigi natenaɡ̶aneɡ̶egi lajo émeɡ̶egi monaligitini, idiaaɡ̶idi ica oko ane nacaagaɡ̶ateloco. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Odaa meetediogi, “Emii anotiticoacetiwaji! Naɡ̶adi nigaanawaana ayeleo, pida diote.” Odaa joɡ̶oilajitedibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Niɡ̶ijo naɡ̶a noditicoaci niɡ̶ijo oko. Odaa Jesus ja dakatediwece ane liotaɡ̶adi naɡ̶ajo nigaanawaana ane yeleo. Naɡ̶a dibatedigi libaaɡ̶adi, odaa ja nicooɡ̶etedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Odaa noɡ̶odibodiceta niɡ̶ida Jesus aneote jiɡ̶ilaagiteloco iditawece nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus naɡ̶a noditedice niɡ̶ijo aneite. Odaa eɡ̶idaa diitedigi migo, icoa itoataale etoinadi joɡ̶oigaalatece, codaa napaawaɡ̶ateloco, moditalo, “Akaami anida anenitege licoɡ̶egi inionigi-eliodi Davi, ɡ̶odiwikodeneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Naɡ̶a icotedicogi Jesus ica diimigi, odaa niɡ̶ijoa etoinadi joɡ̶oigaalatiwece. Naɡ̶a dakatiobece, odaa joɡ̶ototalo. Odaa Jesus jeɡ̶eetediogi, “Domige iwaɡ̶atakani ica me jakadi me ɡ̶adicilatititiwaji?” Odaa joɡ̶oigidi, moditalo, “Ejiwaɡ̶atakanaɡ̶a, Ǥoniotagodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Odaa Jesus ja dibatedeloco ligecooɡ̶eli, odaa meetediogi, “Enice niɡ̶ina natigide ja ɡ̶adicilitiwaji, leeɡ̶odi me iwaɡ̶atakani!” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Odaa ja yatetibigiwaji, jeɡ̶ele ligecooɡ̶eli. Odaa Jesus ja najoitediniwace, meetediogi, “Jinaɡ̶a domaɡ̶a ica anatematiita niɡ̶ida ane ejigotaɡ̶awatiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pida noɡ̶opitibeci, joɡ̶oyatematitiogi iditawece niɡ̶idi oko niɡ̶eladimigipitigi niɡ̶idi nipodigi me Jesus nicilatiditediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Niɡ̶ijo noɡ̶opitibeci niɡ̶ijoa itoataale ɡ̶oneleegiwadi, odaa ica eledi oko joɡ̶onadeegitalo Jesus ica ɡ̶oneleegiwa ane dakatiogi niwigo abeyaceɡ̶egi aneo me ewaloɡ̶onaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Neɡ̶eote Jesus niɡ̶ijo niwigo abeyaceɡ̶egi me noditice mijotaɡ̶a niɡ̶ijo ɡ̶oneleegiwa, odaa ja dotaɡ̶a. Ijotawece niɡ̶ijo noiigi-nelegi eliodi moyopo, odaa modi, “Aɡ̶ica me jinataɡ̶a digoina ɡ̶oniiɡ̶o Israel ɡ̶oneleegiwa ane yakadi meo ɡ̶odoxiceɡ̶edi liciagi niɡ̶ida aneote niɡ̶idoa ɡ̶oneleegiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pida niɡ̶ijoa fariseutedi modi, “Niɡ̶ijo lacilo niwicidi abeyacaɡ̶aɡ̶a jiɡ̶ijaa yajigotalo loniciwaɡ̶a me iticoitedice niwicidi abeyacaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Odaa Jesus igotetece idiwatawece nigotadi codaa me nigotadawaanaɡ̶a, diiɡ̶axinaɡ̶a midiwa niiakanaɡ̶axiidi, yeloɡ̶oditedibece nibodicetedi anele, Aneotedoɡ̶oji me doletedibige me iiɡ̶e laaleɡ̶enali oko, codaa icilatidi inoatawece ane latopaco neelotika, codaa me niɡ̶ina oko ane diɡ̶ica loniciwaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naɡ̶a nadi Jesus niɡ̶ijo noiigi-nelegi, odaa ja iwikodetediogi, leeɡ̶odi me nawikodeeɡ̶a, aɡ̶ica ane yaxawatiogi, iciaceeketetege niɡ̶inoa waxacocoli ane diɡ̶ica nowienoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Odaa Jesus jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Niɡ̶idi oko liciagi niɡ̶ina nixoɡ̶otagi nelegi baanaɡ̶a leeditibige monopilaɡ̶aditio. Pida ane nibaaɡ̶a aɡ̶eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Odaa ipokitalo Aneotedoɡ̶oji me niwakatee eletidi nibakecajoli moyaxawa eledi oko monakato Aneotedoɡ̶oji, liciagi niɡ̶ijo anodipokota niɡ̶ini ane nebi nixoɡ̶otagi nelegi me niwakatee eletidi ɡ̶oneleegiwadi monopilaɡ̶aditedio lawodigijedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus eniditediogi dooze ɡ̶oneleegiwadi modiotibece. Odaa ja yajigotediogi loniciwaɡ̶a moiticoitedice niwicidi abeyacaɡ̶aɡ̶a anodakatiogi niɡ̶ina oko, codaa moicilatidi okanicodaaɡ̶ica ane latopagi neelotagi codaa me nibeyacaɡ̶ajegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Digawini ane liboonaɡ̶atedi niɡ̶ijo dooze anodiotibece Jesus: odoejegi Simão, aneledi oyatigi me Pedro, ijaaɡ̶ijo nioxoa ane liboonaɡ̶adi André; Tiago ijaa João dinioxomigipi ane lionigipi Zebedeu; Filipe, Bartolomeu, Tomé ijaa Mateus anijo me dibatibigege ninyeelo ninionigi-eliodi romaanotedi; Tiago lionigi Alfeu, Tadeu, ijaa eledi Simão ane domaɡ̶a lowoogo me iticoiticoace romaanotedi me noditicoaci nipodaɡ̶a judeutedi; ijaa Judas Iscariotes aneyaa Jesus mijotaɡ̶a neloɡ̶ododipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus iiɡ̶e niɡ̶ijoa dooze ɡ̶oneleegiwadi, odaa ja najoitediniwace, meetediogi, “Jineɡ̶emiitiwaji liɡ̶eladi niɡ̶ina ane daɡ̶a judeutedi, codaa jinaɡ̶akaatiwece nigotadi samaritaanotedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pida oleetibige oko miditaɡ̶a ɡ̶odoiigi Israel, niɡ̶ijo ane aniatagigipi, ane liciagi niɡ̶inoa waxacocoli aneyamaɡ̶aticoace, odaa jaɡ̶aniadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Emiitiwaji atematikani, eni, ‘Niɡ̶ina natigide Aneotedoɡ̶oji jiɡ̶idaaɡ̶eyatedigi me iiɡ̶e laaleɡ̶enali oko.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Icilatititiwaji eelotaginadi, codaa awii émaɡ̶aɡ̶a me newiɡ̶atace. Codaa awii niɡ̶ina oko ane dawace-loolatedi me nicilaɡ̶a. Iticoitedice niwicidi abeyacaɡ̶aɡ̶a anodakatiogi oko. Inoatawece niɡ̶inoa anabaategetiwaji aɡ̶ica loojedi, odaa jinaɡ̶a domaɡ̶a abanoonaɡ̶ani mawii niɡ̶ida ɡ̶abakeditiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Codaa jinaɡ̶awii adeegi dinyeelo catinedi ɡ̶aninyeelaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Codaa jinaɡ̶adeegi ɡ̶aniboco maniwiaje, oteɡ̶exaaɡ̶aɡ̶a anigetaɡ̶ani eledi ɡ̶anoecaɡ̶axi, oteɡ̶exaaɡ̶aɡ̶a eletidi ɡ̶awelatedi, oteɡ̶exaaɡ̶aɡ̶a ɡ̶agiilaɡ̶adi. Igaataɡ̶a ewi niɡ̶ina modi, ane diba leeditibige me dibatege ane yopotibige me yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nigakaatiwecetiwaji anigani nigotaɡ̶a domige nigotakawaana, odaa oleetibige liɡ̶eladi niɡ̶ina oko anodeemitetibige, odaa idiaaɡ̶onitetiwaji nigepaa limedi manotiticogi naɡ̶ani nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nigakaatiwecetiwaji diimigi, odaa anicenitiniwace niɡ̶ica oko niɡ̶eladimigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nigele modibataɡ̶agitiwaji niɡ̶idi oko ane liɡ̶eladi niɡ̶ica diimigi, odaa ipokitalo Aneotedoɡ̶oji me ibinietediogi. Pida nige deɡ̶ele modibataɡ̶agi, odaa jiniɡ̶ipokitalo Aneotedoɡ̶oji me ibinietediogi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Codaa nige deɡ̶ele modibataɡ̶agi anigini diimigi, domige anigani nigotaɡ̶a, codaa nige doɡ̶oyemaa mowajipatalo ɡ̶adatematiko, odaa niganotiticogi niɡ̶ini diimigi, domige naɡ̶ani nigotaɡ̶a, iticiɡ̶i ɡ̶awelatedi me ikeeni me daɡ̶adiaaɡ̶ica anenitege. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ica noko Aneotedoɡ̶oji nige iloikatidi niɡ̶idi oko leeɡ̶odi libeyaceɡ̶eco, odaa daɡ̶axa me beyagi niɡ̶ica anigotediogi niɡ̶idi oko caticedi me liciagi anigotediogi niɡ̶ijo niɡ̶eladimigipitigi Sodoma ajaa Gomorra niɡ̶ijo naɡ̶a yaaɡ̶adi niɡ̶ijo jotigide, leeɡ̶odi niɡ̶ijoa lakataɡ̶a ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Digawinitiwaji! Ǥadiiɡ̶eni micoataɡ̶a niɡ̶inoa waxacocoli memii liwigotigi oko ane liciagi diwilecoɡ̶oni. Enice ecoɡ̶otace owookoni nigepaa nige awii ane ɡ̶abakedi. Nigawii, odaa abakeni ɡ̶adacilo, me daɡ̶a beyagi ɡ̶adowoogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Anidakitiogi niɡ̶ina oko. Igaataɡ̶a etiɡ̶adiwilotiwaji codaa etiɡ̶adadeegiticogi midiwataɡ̶a lacilodi moiwi anodigotaɡ̶awa, codaa icota metiɡ̶adalakenitibige catiwedi liiakanaɡ̶axiidi judeutedi, oyatitaɡ̶awa lalakenaɡ̶anaɡ̶atedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Leeɡ̶odi maniwitici, odaa etiɡ̶adadeegiticogitiwaji midiwataɡ̶a lacilodi ane niiɡ̶enatakanaɡ̶a, codaa me midiwataɡ̶a inionaɡ̶a-eloodoli, odaa joɡ̶oiwi anigotaɡ̶awa, codaa odiiɡ̶enatakataɡ̶awa metiɡ̶adiloikatiti. Odaa jeɡ̶eniticitiwaji midiwataɡ̶a lacilodi ane niiɡ̶enatakanaɡ̶a, codaa me miditaɡ̶a ane daɡ̶a judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nigetiɡ̶adadeegiticogi lodoe ɡ̶oniwinoɡ̶odi, jinaɡ̶a ɡ̶adigecaɡ̶aleɡ̶eni ane alitigi ɡ̶agegi. Igaataɡ̶a Aneotedoɡ̶oji eote mowooɡ̶otitiwaji niɡ̶ica ane alitigi ɡ̶agegi nigicota naɡ̶aca lakata nige limedi motaɡ̶ani. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Igaataɡ̶a nige limedi motaɡ̶anitiwaji, ɡ̶adotaɡ̶a aicoɡ̶otedigi makaamitaɡ̶a, pida icoɡ̶otedigi mijotaɡ̶a Liwigo Aneotedoɡ̶oji ane Ǥadiodi anini makaamitaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Niɡ̶ina oko icota moyajigo epaa nioxoadipi monigodi, codaa eniododipi oyajigo lionigipi, odaa nionigipi ja lakapetedi eliododipi, odaa joɡ̶owo monigodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Leeɡ̶odi maniwiticitiwaji, inatawece oko icota moyelataɡ̶adomi. Pida niɡ̶ina ane daɡ̶a ika me niotici, codaa me daɡ̶a ika me idinakato, biɡ̶ida lewiɡ̶a ane diɡ̶ica liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nigetiɡ̶adiatenitibece anigani nigotaɡ̶a, odaa ialeticogi manitaɡ̶a eledi nigotaɡ̶a. Ejitaɡ̶awatiwaji anewi, midioka limedi mani eledi nigotaɡ̶a anei makati mawii niɡ̶ida ibakedi nigepaaɡ̶icota me idopitijo, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Aɡ̶ica niiɡ̶axinigi ane naɡ̶axateloco niiɡ̶axinoɡ̶odi daɡ̶a daɡ̶axa me ɡ̶oneɡ̶egi. Codaa aɡ̶ica niotagi ane naɡ̶axateloco niotagodi daɡ̶a daɡ̶axa me ɡ̶oneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Enice niɡ̶ina niiɡ̶axinigi leeditibige me ninitibece niɡ̶ina mododigo digo mijotaɡ̶a niɡ̶ijo niiɡ̶axinoɡ̶odi, codaa niɡ̶ina niotagi leeditibige maɡ̶aɡ̶a ninitibece niɡ̶ina mododigo digo mijotaɡ̶a niɡ̶ijo niotagodi. Nigoditalo niɡ̶ijoa ane nebi diimigi me Belzebu (ane liboonaɡ̶adi Satanás), odaa eledi owote liboonaɡ̶atedi ane daɡ̶axa me beyagi niɡ̶idi loiigi niɡ̶ijoa ane nebi diimigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jinaɡ̶adoiitiogi niɡ̶ina oko. Igaataɡ̶a inoatawece ane dinapoɡ̶oditedini icota moyowiegi, codaa inoatawece anoyowiegitelogo, icota moyowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Niɡ̶inoa anejitaɡ̶awatiwaji niɡ̶ina me enoale, eloɡ̶otitiogi niɡ̶ina oko me noko. Codaa niɡ̶ina anajipaata ane dinaɡ̶aditi, eloɡ̶oti anei eliodi oko moyakadi mowajipata. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jinaɡ̶adoiita niɡ̶ina anoyakadi mowo anodigo ɡ̶adolaadi, leeɡ̶odi aɡ̶ica loniciwaɡ̶a doɡ̶oyeloadi ɡ̶adiwigo. Pida adoiitalo Aneotedoɡ̶oji anepaɡ̶a yakadi me yaaɡ̶adi ɡ̶adewiɡ̶a minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Niɡ̶ina oko adakake loojedi moyaa iniwataale ilaaɡ̶axodawaanaɡ̶a, loojedi onaniteci beexo. Pida niɡ̶ina ilaaɡ̶agi inoka enitinigi iiɡ̶o, nige yemaa Aneotedoɡ̶oji ane Ǥadiodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Codaa Aneotedoɡ̶oji yowooɡ̶odi ane liwokodi ɡ̶adamodi aneitigi ɡ̶adacilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Enice jinaɡ̶adoii! Igaataɡ̶a daɡ̶axa mida ɡ̶aniwaló caticedi niɡ̶inoa ilaaɡ̶axodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Niɡ̶ina ane dineloɡ̶odi lodoe niɡ̶ina eledi oko mida aneetigi, odaa Ee aaɡ̶aɡ̶a jeloɡ̶oditalo Eiodi ane ideite ditibigimedi mida anejitege. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pida niɡ̶ina anee me diɡ̶ica aneetigi lodoe niɡ̶ina oko, odaa Ee eledi eji me diɡ̶ica anejitege lodoe Eiodi ane ideite ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jinaɡ̶aleetibige daɡ̶a janagi digoina iiɡ̶o daɡ̶a jao me ilaɡ̶atiwage inatawece niɡ̶ina oko. Ajanagi daɡ̶a jao me ilaɡ̶atiwage, pida janagi micataɡ̶a niɡ̶ina oko ane nadeegi lodaajo, odaa niɡ̶ina oko idiokiditiwage, pida dawalacetiwage. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Leeɡ̶odi janagi me jao niɡ̶ina nionigi me lakapetegi eliodi, niona lakapete eliodo, codaa me niiɡ̶ate lakapete loxiiɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Odaa dinaxakawepodi niɡ̶idi oko, idaaɡ̶ida me domaɡ̶a dinoiigiwepodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Niɡ̶ina oko ane yemaa eliodi codaa me eliodo caticedi me idemaa, niɡ̶ini oko ayakadi diɡ̶ida aneetigi, codaa niɡ̶ina ane yemaa lionigi codaa me liona caticedi me idemaa, niɡ̶ini ayakadi diɡ̶ica aneetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inoka yakadi mida aneetigi niɡ̶ina baanaɡ̶a igo me dawikode nigepaa yeleo leeɡ̶odi me niotibici. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Niɡ̶ina aninoka doletibige me dowediteloco epaa lewiɡ̶a, codaa epaa dinowedi adinigaanyetece lewiɡ̶a Aneotedoɡ̶oji ane domaɡ̶a yajigote. Niɡ̶ina ane daɡ̶a yewiɡ̶atema epaa lakataɡ̶a, pida ja igo me yeleotomi, joaniɡ̶iniaa dinigaanyetece lewiɡ̶a Aneotedoɡ̶oji ane yajigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Niɡ̶ina anele me dibataɡ̶agitiwaji, odaa aaɡ̶aɡ̶a ele me dibatigi. Niɡ̶ina anele me dibatigi, odaa ele me dibatege Aneotedoɡ̶oji ane idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Niɡ̶ina anele me dibatege niɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji leeɡ̶odi ane libakegitema Aneotedoɡ̶oji, niɡ̶ini oko dibatege icaaɡ̶ica niɡ̶ica laɡ̶ajegi Aneotedoɡ̶oji ane yajigotediogi niɡ̶ina ane yeloɡ̶oditedibece lowooko. Codaa niɡ̶ina ane dibatege niɡ̶ina oko ane iɡ̶enaɡ̶a leeɡ̶odi me iɡ̶enaɡ̶a, niɡ̶ini oko dibatege icaaɡ̶ica naɡ̶ajegi Aneotedoɡ̶oji ane yajigotediogi niɡ̶ina ane iɡ̶enaɡ̶atibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Codaa niɡ̶ina ane yacipeɡ̶eta ninyoɡ̶odi ane diwete anigepidiɡ̶ijo niɡ̶ina anoniotici ane daɡ̶a ɡ̶oneɡ̶aɡ̶a, pida leeɡ̶odi me iiɡ̶exegi, ajawienatakanaɡ̶a niɡ̶ini oko me dinigaanyetece naɡ̶ajegi anele ane yajigote Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Niɡ̶ijo Jesus naɡ̶a ika me niiɡ̶axitediniwace niɡ̶ijo dooze anodiotibece, odaa ja noditedice, jiɡ̶igo diiɡ̶axinaɡ̶a codaa me yeloɡ̶oditedibece ɡ̶obodicetedi anele midiwataɡ̶a nigotadi niɡ̶idi nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","João Batista idei niwiloɡ̶onaɡ̶axi. Naɡ̶a dibodicetibige niɡ̶icoa ane loenataka Cristo, odaa ja iiɡ̶e itoataale niɡ̶ijo anodiotibeci moige Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Noɡ̶ototalo Jesus, moditalo, “Manigakamaɡ̶akaami ica anenagi ɡ̶odewikatidi, oɡ̶oa domigalee jaliiɡ̶atege eledi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus naɡ̶a igidi, meetediogi, “Opilitijotiwaji, eloɡ̶otita João anajipaata, codaa eloɡ̶otita yoenataka baanaɡ̶a anati. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Naɡ̶a yatetacibigiwaji ɡ̶oladi, alejaadotedi jeɡ̶ewaligi, dawace-loolatedi ja nicilaɡ̶a, aticilonadi ja najipaaɡ̶a, émaɡ̶aɡ̶a ja newiɡ̶atace, codaa nibodicetedi anele ane icoɡ̶otedibigimece miniwataɡ̶a Aneotedoɡ̶oji joɡ̶oyeloɡ̶oditiogi madewetedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nige daɡ̶a ikani madinakatoni, odaa niɡ̶ida makaami jaɡ̶aniniitibecitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Niɡ̶ijo naɡ̶a noditicoaci niɡ̶ijoa liiɡ̶exedi João, odaa Jesus ja yalaɡ̶ate João, meetediogi niɡ̶ica oko, “Niɡ̶ijo neɡ̶emiitiwaji akapetege João midi nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi, amiini ica anemii awinitiwaji? Ejideɡ̶emiitiwaji mawini ɡ̶oneleegiwa aɡ̶amaleɡ̶egi ane diɡ̶ica baɡ̶a lowoogo, micataɡ̶a niɡ̶ina naanyogo ane igiketibece niocodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Enice, amiini ica anemii awinitiwaji? Ejideɡ̶emiitiwaji mawini ɡ̶oneleegiwa liico, ane dinixotinigilo nowoodi libinienaɡ̶a ane dakake loojedi. Niɡ̶ina oko anodinixotinigilo nowoodi libinienaɡ̶a ane dakake loojedi odiɡ̶eladetigilo diimaɡ̶a nelecoli, liɡ̶eladi ɡ̶oneɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Enice, amiini ica anemii awinitiwaji? Ejime emii mawinitiwaji anigepidiɡ̶ijo niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Odaa ejitaɡ̶awatiwaji, niɡ̶ijo anemii awinitiwaji daɡ̶axa me ɡ̶oneɡ̶egi caticedi niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Igaataɡ̶a lotaɡ̶a Aneotedoɡ̶oji jotigide naɡ̶akaa yalaɡ̶ata João, mee, ‘Digawini! Ida iiɡ̶exegi, ane datematika maleediɡ̶icatibige diɡ̶icoo. Yoetaɡ̶adomi ɡ̶anaigi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ejitaɡ̶awatiwaji niɡ̶ina anewi. João Batista daɡ̶axa me ɡ̶oneɡ̶egi, caticedi inatawece oko aninaa codaa natigide. Pida niɡ̶ina Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶ena oko ane diɡ̶ica naɡ̶atetigi, odaa niɡ̶ini oko daɡ̶axa me ɡ̶oneɡ̶egi caticedi João. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Niɡ̶ijoa nokododi me yatematitedibece João latematiko, codaa niɡ̶ina noko, niɡ̶ina oko nawikodeeɡ̶a, leeɡ̶odi moikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. Igaataɡ̶a niɡ̶ina oko loidenaɡ̶a odoletibige modinigaanyetece domoɡ̶owotibige me daɡ̶aleeɡ̶oika Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pida maleediɡ̶icatibige me yatemati João latematigo, ijotawece niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, codaa lotaɡ̶a Aneotedoɡ̶oji, oyalaɡ̶ata niɡ̶ica anodaaɡ̶ee Aneotedoɡ̶oji me doletedibige me iiɡ̶e ɡ̶odaaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Odaa nigemaanitiwaji me iwaɡ̶ati anoyatemati, João jiɡ̶iniaaɡ̶ini niɡ̶ijo Elias ane leeditibige me dopitijo. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nigemaani majipaatalo yotaɡ̶a, enice atacoli! ");
INSERT INTO kbcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Amigetiɡ̶ini ica ane jiciaceeketege niɡ̶ina noiigi ane newiɡ̶a niɡ̶inoa nokododi? Liciagi nigaanigipawaanigi ane nicotiniwace dinalokowepodi. Odaa ini lapo ane dapaaweta eledi, meeta, ");
INSERT INTO kbcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ja jatenaɡ̶anaɡ̶ataɡ̶adomitiwaji nateneɡ̶egi nadoneɡ̶egi jatiiɡ̶a natena, pida aɡ̶emaanitiwaji manibaile. Codaa ja jatenaɡ̶anaɡ̶ataɡ̶adomitiwaji natenaɡ̶aneɡ̶egi lajo monaligitini émeɡ̶egi, pida aɡ̶emaanitiwaji manoeni oteɡ̶exaaɡ̶aɡ̶a akaami agecaɡ̶alodipi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jiciaceeketege nigaanigipawaanigi leeɡ̶odi Aneotedoɡ̶oji nimonya João, odaa aɡ̶igo nalokeco daɡ̶a yeligo niweenigi anele, oteɡ̶exaaɡ̶aɡ̶a wacipeta viinyo. Odaa niɡ̶ina noiigi joɡ̶odi, ‘Niɡ̶ida ɡ̶oneleegiwa dakatiogi niwigo abeyaceɡ̶egi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Odaa Aneotedoɡ̶oji jaɡ̶aɡ̶a idimonya Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, odaa baɡ̶a jiitiogi nalokeco, codaa me jeligo niweenigi anele, jacipe viinyo. Odaa niɡ̶ina noiigi modi, ‘Digawini! Niɡ̶iniwa ɡ̶oneleegiwa olade, codaa me acipeɡ̶egi, lokaaɡ̶edi niɡ̶ina anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa me niɡ̶ina oko ane daɡ̶axa me abeyacaɡ̶aɡ̶a.’ Pida oko anida lixakedi ane icoɡ̶otibigimece miniwataɡ̶a Aneotedoɡ̶oji, niɡ̶ina oko idioka limedi meo ane iɡ̶enaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Odaa Jesus jiɡ̶idaaɡ̶eyatedigi me yotaɡ̶aneɡ̶etediniwace ɡ̶onitiadi inoa lotaɡ̶atediogi niɡ̶eladimigipitigi nigotadi anei meote owidi ɡ̶odoxiceɡ̶etedi, leeɡ̶odi niɡ̶ijo oko aɡ̶odinilaatece libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Meetediogi Jesus, “Nagoodi akaamitiwaji, niɡ̶eladimigipitigi nigotaɡ̶a Corazim! Codaa nagoodi akaamitiwaji, niɡ̶eladimigipitigi nigotaɡ̶a Betsaida! Igaataɡ̶a ijoa jaote owidi ɡ̶odoxiceɡ̶etedi anoikee loniciwaɡ̶a Aneotedoɡ̶oji catiwedi ɡ̶anigotaditiwaji, pida idokee aɡ̶ikanitiwaji mawii ane beyagi ane daɡ̶a yemaateda Aneotedoɡ̶oji. Pida daɡ̶a jaote niɡ̶ijoa ɡ̶odoxiceɡ̶etedi niɡ̶ijo jotigide midiwa nigotadi Tiro aniaa Sidom, aneitice niɡ̶eladimigipi ane daɡ̶axa me abeyacaɡ̶aɡ̶a, toɡ̶oika mowo ane beyagi, codaa toɡ̶odinixotinigi jaacogo, codaa toɡ̶oyati lojienigi lacilodi moikee me agecaɡ̶alodipi leeɡ̶odi libeyaceɡ̶eco anowote. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pida ejitaɡ̶awatiwaji, niɡ̶ica noko Aneotedoɡ̶oji nige iloikatidi niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco, odaa daɡ̶axa me ɡ̶adiloikatititetiwaji caticedi niɡ̶idi niɡ̶eladimigipitigi nigotadi Tiro aniaa Sidom. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Akaami, niɡ̶eladimigipitigi nigotaɡ̶a Cafarnaum. Aneotedoɡ̶oji adoɡ̶etetedaɡ̶awatiwaji, oteɡ̶exaaɡ̶aɡ̶a ɡ̶adadeegitedibigimece ditibigimedi aneite. Pida diiɡ̶enatakatedaɡ̶awatiwaji metiɡ̶adokolenitiogi minitaɡ̶a noledi ane daɡ̶a ipe. Igaataɡ̶a jeɡ̶eliodi me jaote ɡ̶odoxiceɡ̶etedi anoikee loniciwaɡ̶a Aneotedoɡ̶oji, pida idokee aɡ̶ikanitiwaji mawii ane beyagi ane daɡ̶a yemaateda Aneotedoɡ̶oji. Daɡ̶a jaote niɡ̶ijoa ɡ̶odoxiceɡ̶etedi niɡ̶ijo jotigide catiwedi nigotaɡ̶a Sodoma, odaa niɡ̶ijo niɡ̶eladimigipitigi toɡ̶oika mowo ane beyagi, codaa Aneotedoɡ̶oji agotaɡ̶a yaaɡ̶adi naɡ̶ajo nigotaɡ̶a, odaa taɡ̶aleeɡ̶ani codaa ina noko. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ejitaɡ̶awatiwaji, niɡ̶ica noko nige iloikatidi Aneotedoɡ̶oji oko leeɡ̶odi libeyaceɡ̶eco, odaa daɡ̶axa me ɡ̶adiloikatititetiwaji caticedi niɡ̶ijo niɡ̶eladimigipitigi nigotaɡ̶a Sodoma.” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naɡ̶ajo lakata, Jesus meete Aneotedoɡ̶oji, “Eiodi, ane Niotagodi ditibigimedi, codaa me iiɡ̶o. Iniotagodetaɡ̶awa leeɡ̶odi maɡ̶atiti anodaa diitigilo yotaɡ̶atiogi niɡ̶ina oko anodiletibige diɡ̶inoa lixaketedi codaa doɡ̶oyowooɡ̶odi inoatawece. Pida biɡ̶ikeenitiogi ane diitigilo yotaɡ̶a niɡ̶ina oko ane deɡ̶ewi ina ica lixakedi, micataɡ̶a niɡ̶ina nigaanigawaanigi analeedaɡ̶a diwaxinaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Joɡ̶etetaɡ̶awa Eiodi, leeɡ̶odi jiɡ̶idaaɡ̶ida niɡ̶ica anemaani mawii.” ");
INSERT INTO kbcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus meetediogi, “Eiodi ja yajigote ibaaɡ̶adi inoatawece. Aɡ̶ica ane yowooɡ̶odi Lionigi Aneotedoɡ̶oji, iniokiniwateda Eiodi me idowooɡ̶odi. Codaa aɡ̶ica ane yowooɡ̶odi Eiodi, emokee ane Ee Lionigi, inaa niɡ̶ina oko ane jao monadi Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anagi meetaɡ̶a akaamitawecetiwaji baanaɡ̶a anigaaxetema ɡ̶adewiɡ̶a leeɡ̶odi me micataɡ̶a doɡ̶oyaɡ̶atitiwaji noyaɡ̶aka ane iwaaɡ̶adi, odaa jao manipenitema ɡ̶adawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Micataɡ̶a niɡ̶ina ewalaile me yoyaɡ̶adi lotoinaɡ̶atijegi aneo me yakadi me ilakidetice niotagodi me diba, odaa idaaɡ̶eni oleetibige madadiwaɡ̶atitiwaji codaa adiniiɡ̶axinitece iiɡ̶axinaɡ̶aneɡ̶eco, igaataɡ̶a Ee okaaɡ̶egi codaa aɡ̶ee anaɡ̶axakeneɡ̶egi, odaa jaɡ̶akatitiwaji ɡ̶anipenaɡ̶adi anele. ");
INSERT INTO kbcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Igaataɡ̶a ɡ̶adotoinaɡ̶atijegi ane jajigotaɡ̶awa aɡ̶adibeyacaɡ̶ati, codaa ɡ̶adoyaɡ̶agi ane jajigotaɡ̶awa aiwaaɡ̶adi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Odaa naɡ̶a saabado, Jesus ja yakagiditedeloco ica nixoɡ̶otagi ane dinanateloco leyeema. Niɡ̶ijo anodiotibece ijo mijoataɡ̶a, ja nigodi nigigi. Odaa joɡ̶onotegi ligegi leyeema oyeligo lolagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pida ijoa icoa fariseutedi anonadi noɡ̶onotegi ligecidi leyeema. Noɡ̶onadi, odaa moditalo Jesus, “Digawini! Niɡ̶idi anodiotibigaɡ̶adici joɡ̶owo ane yolitoɡ̶odomi ɡ̶onajoinaɡ̶aneɡ̶egi niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Odaa Jesus ja igiditediogi, mee, “Ajawienataka niɡ̶ica malomeɡ̶eniteloco ane loenatagi Davi niɡ̶ijo jotigide, Davi icaaɡ̶icoa lokaaɡ̶etedi nigodi nigigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davi naɡ̶a dakatiwece liɡ̶eladi Aneotedoɡ̶oji, odaa ja yeligo niɡ̶ijoa paontedi baanaɡ̶a oibootalo Aneotedoɡ̶oji, ligiiwepodi lokaaɡ̶etedi. Pida ɡ̶onajoinaɡ̶aneɡ̶egi ɡ̶odiiɡ̶e me diɡ̶ica ane yakadi me yeligo niɡ̶ijoa paontedi. Ijokijoa sacerdotitedi moyakadi moyeligo niɡ̶ijoa paontedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eleditace, midiwa Aneotedoɡ̶oji lotaɡ̶a, idi liwai ane iditini Moisés, iwoteloco sacerdotitedi me yakadi mowo libakedi niɡ̶ina me saabado, odaa jiɡ̶idaaɡ̶ee, aɡ̶oyotete niiɡ̶enatakaneɡ̶egi ane ɡ̶odoli me jibaaɡ̶a niɡ̶ina me saabado, pida anilaagetedipi. Odaa ajawienataka neɡ̶eliodi malomeɡ̶enitibigelogo niɡ̶idiwa notaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ejitaɡ̶awatiwaji digoina ɡ̶adiwigotigi ini oko ane daɡ̶axa me ɡ̶oneɡ̶egi caticedi Aneotedoɡ̶oji liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aneotedoɡ̶oji lotaɡ̶a mee, ‘Jemaa niɡ̶ina oko moiwikode eledi oko, pida ajemaa niɡ̶ina oko moyeloadi eijeeɡ̶agi monibootiwa.’ Doɡ̶owooɡ̶otitiwaji ane diitigilo niɡ̶inoa notaɡ̶a, agotaɡ̶a ɡ̶alaagetedipi niɡ̶ijo ane diɡ̶ica leemidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ida inaɡ̶atetigi me idalaɡ̶ata niɡ̶ica ane jakataɡ̶a me jaoɡ̶a niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus naɡ̶a noditedice niɡ̶ijo aneite, odaa jiɡ̶igo manitaɡ̶a liiakanaɡ̶axi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Odaa ini ica ɡ̶oneleegiwa beyagi libaaɡ̶adi, alejaado. Pida idi niɡ̶ijoa neloɡ̶ododipi Jesus odoletibige me nilaagedi. Joaniɡ̶idaa leeɡ̶odi moige, moditalo, “Ijo ɡ̶onajoinaɡ̶aneɡ̶egi, domige ɡ̶odika me jicilatitaɡ̶a eelotaginaɡ̶a ina me saabado?” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Odaa ja igidi Jesus, meetediogi, “Diɡ̶ini niɡ̶ina akaamitiwaji anokanitece niwaxacoco, oditaɡ̶a daxaboketinece begi niɡ̶ina me saabado, odaa domigetaɡ̶a dinoniciwaɡ̶aditibece me noɡ̶atice niwaxacoco midataɡ̶a begi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pida niɡ̶ina oko baɡ̶a daɡ̶axa mida niwaló caticedi waxacoco. Odaa jaɡ̶anatitiwaji ɡ̶onajoinaɡ̶aneɡ̶egi me daɡ̶a ɡ̶odoli me jaoɡ̶a anele niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Odaa jeɡ̶eete niɡ̶ijo ɡ̶oneleegiwa alejaado, “Ixokenitice ɡ̶abaaɡ̶adi!” Odaa ja ixoketice libaaɡ̶adi, odaa ja icí libaaɡ̶adi, ja liciagi niɡ̶ijo caticedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Odaa niɡ̶ijoa fariseutedi ja noditicoaci, odaa ja dinatecoɡ̶otee odinotaɡ̶aneɡ̶etigi nimaweneɡ̶egi moyeloadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Niɡ̶ijo Jesus naɡ̶a yowooɡ̶odi modoletibige moyeloadi, odaa ja noditedicogi aneite. Eliodi oko odiotece, codaa nicilatiditedi ijotawece neelotaginadi anoyadeegitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pida najoitediniwace me diɡ̶ica anoyeloɡ̶odita. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Odaa joaniɡ̶idaa neɡ̶eote micotece niɡ̶ijoa lotaɡ̶a Isaías, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji niɡ̶ijo jotigide, me yalaɡ̶atalo Jesus, niɡ̶ijo mee, ");
INSERT INTO kbcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Digawini! Etiniwa Iotagi, ane jiolatedice. Jemaa, codaa eliodi meote me idinitibeci. Jixotiogilo Iwigo. Odaa ja yatematitediogi niɡ̶ina noiigi niɡ̶ina ane iɡ̶enaɡ̶a, codaa me eetetece micota me jiwi anejigotiogi niɡ̶ina noiigi leeɡ̶odi loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Niɡ̶iniwa Iotagi adinotigimadetetege oko, oteɡ̶exaaɡ̶aɡ̶a yapaawe oko. Adinigetaɡ̶atee me dotaɡ̶a aneitice me yatecoɡ̶o oko minoa nigotadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Doweditedeloco oko ane deɡ̶eliodi eliwaɡ̶atakaneɡ̶egi, ane liciagi naɡ̶ana niale libiwe ane dinoke, codaa ayaaɡ̶adi eliwaɡ̶atakaneɡ̶egi, niɡ̶ina oko ane liciagi nadegogo anokexaa doɡ̶ocilaɡ̶ade. Eote niɡ̶ida libakedi nigepaa iɡ̶eke inoatawece ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Odaa inatawece ane noiigi onibeotege meote me newiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Niɡ̶idiaaɡ̶idi joɡ̶onadeegitalo Jesus ica ɡ̶oneleegiwa ane dakatiogi niwigo abeyaceɡ̶egi aneo me ɡ̶olaɡ̶a codaa mewaloɡ̶onaɡ̶a. Odaa Jesus ja icilatidi, ja yakadi me dotaɡ̶a, codaa me yatetacibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Odaa niɡ̶ijo noiigi-nelegi joɡ̶oyopo, odaa modi, “Manigidaaɡ̶idoa icoa anida aneetetege licoɡ̶egi Davi ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odaxawa?” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pida niɡ̶ijoa fariseutedi noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a niɡ̶ijo noiigi, odaa joɡ̶oigidi, moditiogi, “Yakadi me iticoitedice niwigo abeyaceɡ̶egi leeɡ̶odi Belzebu yajigotalo loniciwaɡ̶a, niɡ̶ijo lacilo niwicidi abeyacaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus yowooɡ̶oditediwe lowoogo, odaa meetediogi, “Nigidi noiigi ane dawalacetiwage, odaa dinideleɡ̶e, niɡ̶idi noiigi icota me dinaaɡ̶adi. Codaa nigidi niɡ̶eladimigipitigi nigotaɡ̶a, oɡ̶oa domige dinoiigiwepodi, ane dawalacetiwage, codaa dinideleɡ̶e, icota mepaa dinaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Odaa niɡ̶inoa ane liotaka Satanás nigoiticoitedice eletidi liotaka Satanás, odaa ja dawalacetiwage, odaa icota me ma loniciwaɡ̶a Satanás. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Menitiwaji me jiticoitedice niwicidi abeyacaɡ̶aɡ̶a leeɡ̶odi Belzebu, ane Satanás, me najigotiwa yoniciwaɡ̶a. Enice ame yajigotiogi anodiotibigaɡ̶adici loniciwaɡ̶a moiticoitice niwigo abeyaceɡ̶egi? Odaa niɡ̶idi anodiotibigaɡ̶adici oikee makamaɡ̶a adininaalenitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pida niɡ̶ina me jiticoitice niwigo abeyaceɡ̶egi, jatika loniciwaɡ̶a Aneotedoɡ̶oji Liwigo. Odaa joaniɡ̶idaa me jikee Aneotedoɡ̶oji naɡ̶a iiɡ̶e laaleɡ̶enali oko ɡ̶adiwigotigitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Digowoo niɡ̶ina ɡ̶oneleegiwa loniciweɡ̶enigi. Aɡ̶ica ane yakadi me dakatiwece liɡ̶eladi, oditaɡ̶a dolicetalo ane nepilidi nige daɡ̶a odoejegi me oigoetini. Idokida nige oigoetini niɡ̶ini ɡ̶oneleegiwa loniciweɡ̶enigi odaa boɡ̶oyakadi moyadeegi ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Niɡ̶ina oko ane daɡ̶a dibatigi, odaa yakapetegi. Codaa niɡ̶ina ane daɡ̶a idaxawa me nadeegitalo Aneotedoɡ̶oji oko, odaa niɡ̶ini oko inibeyacaɡ̶atagodi, codaa eo oko mepaanaɡ̶a leegitalo moyototedice Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Joaniɡ̶idaa leeɡ̶odi mejitaɡ̶awatiwaji Aneotedoɡ̶oji me ixomaɡ̶ateetedice inoatawece ane latopaco libeyaceɡ̶eco oko, codaa niɡ̶inoa lotaɡ̶a ane beyagi modotaɡ̶atibige. Pida Aneotedoɡ̶oji baadaɡ̶a ixomaɡ̶ateetedice niɡ̶ina oko modotaɡ̶atibige Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Codaa baɡ̶a yakadi me ixomaɡ̶ateetedice niɡ̶ina oko modotaɡ̶atibigiji, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. Pida Aneotedoɡ̶oji baadaɡ̶a ixomaɡ̶ateetedice niɡ̶ina oko me beyagi modotaɡ̶atibige Liwigo, aixomaɡ̶ateetedice niɡ̶ina natigide, oteɡ̶exaaɡ̶aɡ̶a nigidiaaɡ̶idi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Naɡ̶ana niale nigele, odaa elali eletidi ele, pida nige deɡ̶ele naɡ̶ada niale, odaa elali idaaɡ̶ee beyagi. Jakataɡ̶a me jowooɡ̶otaɡ̶a niale leeɡ̶odi niɡ̶inoa elali ane yajigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Niɡ̶ida makaamitiwaji ɡ̶adiciagi laketedi ane diniweneene. Akaami abeyacaɡ̶aɡ̶atetiwaji, odaa aɡ̶akati me ɡ̶adalaki anele. Igaataɡ̶a ɡ̶odotaɡ̶a ane icoɡ̶otiwece ɡ̶onioladi, icoɡ̶otiwece ɡ̶odaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Niɡ̶ina oko anele, nolee laaleɡ̶ena niɡ̶inoa anele, codaa lotaɡ̶a inokinoa anele. Niɡ̶ina oko ane beyagi laaleɡ̶ena, odaa yalaɡ̶ata inokina ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ejitaɡ̶awatiwaji niɡ̶ica noko Aneotedoɡ̶oji nige iwi anigote me iloikatidi oko leeɡ̶odi libeyaceɡ̶eco, odaa laagetedipi niɡ̶ina oko anoyalaɡ̶a inokina ane ibeyacaɡ̶adi lewiɡ̶a eledi oko. Codaa leeditibige moyeloɡ̶oditalo Aneotedoɡ̶oji ane leeɡ̶odi modi niɡ̶ijoa notaɡ̶a ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Igaataɡ̶a niɡ̶ica noko Aneotedoɡ̶oji eetedaɡ̶aloco makaami niɡ̶ica oko anele nige ɡ̶adalakita inokina anele, pida nige inoka ɡ̶adalakita ane beyagi motaɡ̶ani, odaa Aneotedoɡ̶oji eetedaɡ̶aloco makaami oko ane beyagi, odaa ja ɡ̶adiloikatiti.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niɡ̶idiaaɡ̶idi onidiwa onateciɡ̶ijo niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, icaaɡ̶icoa fariseutedi igotibeci midoataɡ̶a Jesus, odaa moditalo, “Niiɡ̶axinaɡ̶anaɡ̶a, jemaanaɡ̶a mawii ɡ̶odoxiceɡ̶edi bidige anikeenitoɡ̶owa mewi me Aneotedoɡ̶oji ɡ̶adiiɡ̶eni, codaa me yajigotedaɡ̶awa ɡ̶adoniciwaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus naɡ̶a igidi, meetediogi, “Niɡ̶ina noiigi aninaa niɡ̶inoa nokododi abeyaceɡ̶egipi, codaa me aɡ̶aleeɡ̶oyiwaɡ̶adi Aneotedoɡ̶oji. Oyemaa Aneotedoɡ̶oji meote ɡ̶odoxiceɡ̶edi ane ikee me najigotediwa yoniciwaɡ̶a, codaa me idiiɡ̶e me jao ibakedi. Pida Aneotedoɡ̶oji aɡ̶eote eledi ɡ̶odoxiceɡ̶edi anakati manatitiwaji. Igaataɡ̶a niɡ̶ijo jotigide akaa ikee Aneotedoɡ̶oji me idiiɡ̶e leeɡ̶odi niɡ̶ijo ninyaagi Jonas, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Niɡ̶ijo Jonas me idei catiwedi le noɡ̶ojegi nelegi, ane yalitini, odaa idiaaɡ̶i le itoatadiɡ̶ida nokododi, itoatadiɡ̶ida enoaleli. Odaa jiɡ̶idaɡ̶aɡ̶eji Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, etidaligiti itoatadiɡ̶ida nokododi, itoatadiɡ̶ida enoaleli. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niɡ̶ica noko Aneotedoɡ̶oji nige iwi anigote me iloikatidi oko leeɡ̶odi libeyaceɡ̶eco, niɡ̶ijo oko ane niɡ̶eladimigipitigi nigotaɡ̶a Nínive nige dabiditiniwace me newiɡ̶atace, odaa jaɡ̶akaami nilaagetedipi, leeɡ̶odi mepaɡ̶a odinilaatece libeyaceɡ̶eco niɡ̶ijo noɡ̶owajipatalo lotaɡ̶a Jonas. Jemaa mejitaɡ̶awatiwaji, niɡ̶ida me Ee daɡ̶axa me Ee ɡ̶oneɡ̶egi caticedi Jonas, pida idokee aɡ̶adinilaanitece ɡ̶abeyaceɡ̶eco niɡ̶ijo naɡ̶a ajipaatalo yotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Codaa niɡ̶ica noko naɡ̶ajo iniona, ane icoɡ̶oticogi natinediteloco, nige yewiɡ̶atace, odaa jaɡ̶akaami laagetedipitetiwaji, igaataɡ̶a baɡ̶a leegitece me diniwiaje migo wajipatalo liiɡ̶axinaɡ̶aneɡ̶eco Salomão, niɡ̶ijo anowidi lixaketedi. Odaa digawini! Ee, ane daɡ̶axa me Ee ɡ̶oneɡ̶egi caticedi Salomão, ite Ee digoina makaamitaɡ̶atiwaji. Pida aɡ̶emaanitiwaji majipaatalo iiɡ̶axinaɡ̶aneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Niɡ̶ina niwigo abeyaceɡ̶egi me noditicogi niɡ̶ina oko, odaa jiɡ̶igoteloco nipodaɡ̶a ane yadilo codaa me daxixe, doletibige ane lotokaɡ̶adi. Pida nige diɡ̶ica yakadi lotokaɡ̶adi, odaa mee me dotaɡ̶a, ‘Ejime jopitacicogi iɡ̶eladi ane jicoɡ̶oticogi.’ Nigopitio, odaa jiɡ̶icota liɡ̶eladi me diɡ̶ica ane itidi, yapidi, codaa me ilaaɡ̶atini. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Odaa jiɡ̶igotiogi eletidi seete niwicidi ane daɡ̶axa me abeyacaɡ̶aɡ̶a modiɡ̶eladetigi niɡ̶ini oko. Odaa jiɡ̶idaa leeɡ̶odi niɡ̶ini oko jeɡ̶epaanaɡ̶a abeyaceɡ̶egi caticedi niɡ̶ijo anee jotigide. Odaa icota midaaɡ̶ee, niɡ̶ina noiigi ane abeyaceɡ̶egipi aninaa niɡ̶inoa nokododi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eɡ̶idaa diiticogi Jesus me notaɡ̶aneɡ̶etediniwace niɡ̶ijo noiigi, odaa naɡ̶ajo eliodo, ijaaɡ̶ijo nioxoadipi joɡ̶ototicogi aneite. Odaa idiaaɡ̶iticoaci we niɡ̶ijo diimigi aneitedice Jesus, odoletibige moyotaɡ̶aneɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Odaa ica ɡ̶oneleegiwa meetalo Jesus, “Ǥadiodo, ɡ̶anioxoadipi etidi we. Domoɡ̶oyemaa metiɡ̶adotaɡ̶aneɡ̶eni.” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Odaa Jesus naɡ̶a igidi niɡ̶ijo ɡ̶oneleegiwa ane ibodicaxi, meeteta, “Amaajo aca eiodo? Codaa amiidi ica inioxoadipi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Odaa ja dikeenatakatediogi niɡ̶ijo anodiotibece, mee, “Digawini! Naɡ̶ani beɡ̶eiodo, codaa niɡ̶idi beɡ̶ewi me inioxoadipi! ");
INSERT INTO kbcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Igaataɡ̶a inatawece niɡ̶ina anowo ane yemaa Eiodi ane ideite ditibigimedi, joaniɡ̶inaa beɡ̶ewi me inioxoadipi, iniwaalepodi, codaa me eiodo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ijaaɡ̶ijo niɡ̶ijo noko Jesus ja noditedice niɡ̶ijo diimigi, odaa jiɡ̶igo liniogotibece niweiigi Galiléia. Odaa jiɡ̶idiaa nicote me iiɡ̶axi ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eliodi oko anototalo, odaa joɡ̶oyawiile. Joaniɡ̶idaa leeɡ̶odi naɡ̶a waxoditedinigi ajo etogawaana, odaa ja nicotedinigi. Pida niɡ̶ijo noiigi baɡ̶a dabiditiniwace liniogotibece ninyoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Odaa Jesus ja iiɡ̶axi niɡ̶ijo noiigi. Naɡ̶a niiɡ̶axitediniwace, yatemati owidi natematiko anida ane iciaceeketetege. Odaa mee me datematika, “Ica ɡ̶oneleegiwa onigo lixoɡ̶otagi etanaɡ̶a, odaa yadeegi nolacidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naɡ̶a yaladitedibece niɡ̶ijoa nolacidi meyatedini, onicoa lolacidi aneniteloco liniogotibece naigi. Odaa ilaaɡ̶axodi joɡ̶onoɡ̶oja. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Icoa eletidi lolacidi boɡ̶oneniteloco wetiadawaanaɡ̶a, ane deɡ̶ewi mica iiɡ̶o. Niɡ̶ijoa lolacidi yediiɡ̶a me nokoloɡ̶o leeɡ̶odi iiɡ̶o aleegitinece. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pida naɡ̶a dapicoɡ̶o aligeɡ̶e, odaa ja yalegi nawodigijedi, odaa ja yadilo leeɡ̶odi aleegitinece litodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Odaa icoa eletidi lolacidi boɡ̶oneniteloco ipelakijadi. Odaa niɡ̶ijo ipelaɡ̶a naɡ̶a ili, odaa ja yapoɡ̶oditedini niɡ̶ijoa nawodigijedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pida eletidi lolacidi boɡ̶oneniteloco iiɡ̶o anele. Odaa baɡ̶a ili codaa etaye, yajigo owidi ligecidi. Idatecibece libatadi yajigo onaniteci taalia ligecidi, idaaɡ̶eledi baɡ̶a yajigo seseenta, idatibece baɡ̶a triinta. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Niɡ̶ina oko ane wajipatalo yotaɡ̶a, leeditibige me watacotece.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Odaa niɡ̶ijo anodiotibece Jesus joɡ̶ototalo, odaa joɡ̶oige, moditalo, “Igaamee ina mabakeni natematigo anida ane iciaceekenitege, ina matematikanitema ina oko?” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Odaa Jesus ja igidi, meetediogi, “Aneotedoɡ̶oji baɡ̶a yemaa me ikeetedaɡ̶awatiwaji ane nimaweneɡ̶egi me iiɡ̶e laaleɡ̶enali oko, ane diɡ̶ica ane yowooɡ̶odi anodaaɡ̶ee. Odaa baadaɡ̶a ikeetediogi niɡ̶ina eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Odaa Aneotedoɡ̶oji eneɡ̶egi ikeete niɡ̶ina oko baanaɡ̶a oyowooɡ̶odi anodaaɡ̶ee me iiɡ̶e laaleɡ̶enali. Codaa noɡ̶a lixakedi niɡ̶ina oko ane daɡ̶a yemaa me yowooɡ̶odi anodaaɡ̶ee me iiɡ̶e laaleɡ̶enali oko, icaaɡ̶ica nige domiɡ̶iniawaanigi niɡ̶ini oko lixakedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Joaniɡ̶idaa leeɡ̶odi mepaɡ̶a jibake natematiko anida ane jiciaceeketege niɡ̶ina me jatematikatiogi niɡ̶ina oko. Odaa etidadi pida aɡ̶etidowooɡ̶odi. Codaa owajipatalo yotaɡ̶a, pida aɡ̶odibatege, codaa aɡ̶oyowooɡ̶odi ane diitigilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Odaa niɡ̶ida anee joɡ̶owo micotece niɡ̶ijoa lotaɡ̶a Isaías, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji niɡ̶ijo jotigide, niɡ̶ijo naɡ̶a iditini ane ligegi Aneotedoɡ̶oji, neɡ̶ee, ‘Icota majipaatatiwaji, pida aɡ̶owooɡ̶oti ane diitigi. Icota mawinitiwaji, pida aɡ̶ica daɡ̶a anatitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Leeɡ̶odi oyakakaɡ̶adi laaleɡ̶enali, codaa adinajipake, codaa adoletibigiwaji. Daɡ̶aleetiɡ̶idaaɡ̶ee niɡ̶idi noiigi, toɡ̶oyakadi monadi, codaa mowajipatalo yotaɡ̶a, codaa toɡ̶oyowooɡ̶odi ane diitigilo, codaa toɡ̶odopitiwa oditaɡ̶a jinicilatiditiniwaci.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pida aniniitibecetiwaji leeɡ̶odi akati manati, codaa majipaatalo yotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Eliodi niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji codaa eliodi oko ane iɡ̶enaɡ̶atibigiwaji domoɡ̶oyemaa monadi niɡ̶inoa analeeɡ̶anati, pida aɡ̶onadi, codaa domoɡ̶oyemaa mowajipatalo niɡ̶inoa yotaɡ̶a anajipaatalo, pida aɡ̶owajipatalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Natigide anajipaatiwaji, codaa adiniiɡ̶axinitece anodaa diitigi natematigigi niɡ̶ijo oko anetanaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Niɡ̶ina anowajipata natematigo ane yalaɡ̶ata anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena oko, pida aɡ̶oyowooɡ̶odi ane diitigilo, niɡ̶ina oko liciagi niɡ̶ijoa lolacidi anenitedini naigi liniogotibece. Leeɡ̶odi ɡ̶odaxakawa neɡ̶enagi, odaa ja noɡ̶atedice lotaɡ̶a Aneotedoɡ̶oji ane ideite catiwedi laaleɡ̶ena digo mijoataɡ̶a niɡ̶ijoa ilaaɡ̶axodi monoɡ̶a niɡ̶ijoa lolacidi midi naigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Niɡ̶ijoa lolacidi anenitedini midiwataɡ̶a wetiadawaanaɡ̶a baɡ̶a liciagi niɡ̶ina oko ane wajipatalo natematiko, odaa dibatege, codaa me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pida liciagi niɡ̶ijoa lolacidi anenitedini midiwataɡ̶a wetiadawaanaɡ̶a naɡ̶a nokoloɡ̶o aleegitinece litodi, jiɡ̶idaaɡ̶ee niɡ̶ina oko ane deɡ̶ewi monakato Aneotedoɡ̶oji, odaa aleegi jeɡ̶eyamaɡ̶aticoace niɡ̶ina menagi lawikodico, codaa niɡ̶ina moiatetibeci. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Niɡ̶ijoa lolacidi anenitedini miditaɡ̶a ipelakijadi, liciagi niɡ̶ina oko anowajipata natematigo, pida owidi inoa ligecaɡ̶aleɡ̶etedi leeɡ̶odi ane yopotibige, odaa odoletibige mowidi niliicaɡ̶ajetecidi, odaa epaa dininaale. Odaa jiɡ̶idaa leeɡ̶odi aɡ̶alee ewianaɡ̶a oyowo natematigo, odaa natematigo aɡ̶ica daɡ̶a iigi ane lakataɡ̶a me yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pida niɡ̶ijoa lolacidi anenitedini miditaɡ̶a iiɡ̶o anele, beɡ̶etaye, idatecibece libatadi yajigo onaniteci taalia ligecidi, codaa idatecibece yajigo seseenta ligecidi, idaaɡ̶eledi yajigo triinta ligecidi. Niɡ̶ijoa lolacidi liciagi niɡ̶ina oko anowajipata natematigo, odaa oyowooɡ̶odi ane diitigi. Odaa natematigo ja iigi lewiɡ̶a niɡ̶ina oko eo mowo anele.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus yatematitediogi niɡ̶ijo noiigi eledi natematigo anida ane iciaceeketetege, meetediogi, “Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶ena, liciagi niɡ̶ina ɡ̶oneleegiwa aneyatini nolacidi anele miditaɡ̶a lixoɡ̶otagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ica enoale naɡ̶a niotaɡ̶a liotaka, odaa jeɡ̶enagi niɡ̶ica laxakawa. Odaa niɡ̶ini laxakawa ja yokoletedice eletidi lolacidi liwigotigi niɡ̶ijo leyeema. Niɡ̶icoa lolacidi one diniweneene, codaa one latopiwa leyeema. Odaa joɡ̶opi niɡ̶ijo laxakawa. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naɡ̶a ili niɡ̶ijo leyeema, odaa ja yeloɡ̶o ligecidi. Odaa jaɡ̶aɡ̶a yeloɡ̶o niɡ̶ijo nadegogo ane diniweneene. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Odaa liimetedi niɡ̶ijo bajendeoodi jiɡ̶igotibeci midataɡ̶a, odaa modita, ‘Ǥonecalailegi, niɡ̶ida makaami geme anitedi lolacidi anele. Enice, igame icoɡ̶oticogi ina nadegogo ane diniweneene?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Odaa ja igidi, meetiogi, ‘Yaxakawa libakedi.’ Odaa liimetedi joɡ̶oige, modita, ‘Emaani me inawacenaɡ̶a ina nadegogo ane diniweneene?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Odaa ja igidi, meetiogi, ‘Oɡ̶oa! Igaataɡ̶a daɡ̶a anawaceni niɡ̶ida nadegogo, doidetibige maɡ̶aɡ̶a anawaceni leyeema libatadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dioki leyeema epaaɡ̶awatege nadegogo me ili nigepaaɡ̶icota limedi me inopilaɡ̶ataɡ̶atio. Niɡ̶ica noko, ejitiogi anonakagidi leyeema, “Odoejegi manawacenitiwaji niɡ̶ina nadegogo ane diniweneene, codaa awiitibige ligoxe, odaa okolenitiogi noledi. Nigidiaaɡ̶idi jaɡ̶aɡ̶a aladieni leyeema, odaa baɡ̶a anopilaɡ̶atitiwece diimigi aneitice me jotete yawodigijedi.” ’” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus yatematitediogi niɡ̶ijo noiigi eledi natematigo anida ane iciaceeketetege, meetediogi, “Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, liciagi naɡ̶ana lolacawaana ‘mostaada’ ane dibata ɡ̶oneleegiwa, odaa jeɡ̶eyateloco lixoɡ̶otagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Naɡ̶ani lolagi daɡ̶axa me lionawaana liwigotigi inoatawece eletidi ane niale lolacidi. Pida nige ili, odaa yayoketacedice inoatawece ane ɡ̶odawodigijedi, codaa ili nigepaa icota me niale nelegi. Codaa ilaaɡ̶axodi owote libatoli midoataɡ̶a libiwedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Odaa Jesus ja yatematitediogi eledi natematigo, meetediogi, “Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, liciagi niɡ̶ina ane yabooɡ̶odi leyeema anoibake iwaalepodi. Nige yawanaɡ̶aditege itoatadiɡ̶ida baxia leyeema, odaa niɡ̶ica labookojegi jeɡ̶eo me ili, dabo initawece niɡ̶ini leyeema.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus idioka limedi me yeloɡ̶odi natematiko anida ane iciaceeketetege niɡ̶ina me iiɡ̶axi niɡ̶ina noiigi. Niɡ̶ina me niiɡ̶axitediniwace, aɡ̶ica daaditaɡ̶a ibaketeda natematigo anida ane iciaceeketetege. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Niɡ̶ijo Jesus me datematika, eote micotece lotaɡ̶a niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide neɡ̶ee, “Jatemati natematigo anida ane jiciaceeketege, niɡ̶ina me jatematikatema. Codaa jeloɡ̶oditiogi niɡ̶ina ane diɡ̶ica moyowooɡ̶odi niɡ̶ijo maleekoka yoeteda Aneotedoɡ̶oji niɡ̶ina iiɡ̶o.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus naɡ̶a ibode niɡ̶ijo noiigi-nelegi, odaa jiɡ̶igo minitaɡ̶a ica diimigi. Naɡ̶a dakatedio, niɡ̶ijo anodiotibece joɡ̶odipegitalo, odaa joɡ̶oige, moditalo, “Aneloɡ̶otitoɡ̶owa ane diitigi niɡ̶ijo natematigigi nadegogo ane diniweneene.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Odaa ja igidi Jesus, meetediogi, “Niɡ̶ijo aneyatedini lolacidi anele jeɡ̶emeɡ̶ee, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Niɡ̶ijo nixoɡ̶otagi baɡ̶a niɡ̶ina iiɡ̶o anejonaɡ̶ateloco. Niɡ̶ijoa lolacidi anele baɡ̶a niɡ̶ina oko anida aneetege Aneotedoɡ̶oji, leeɡ̶odi me iiɡ̶e laaleɡ̶enali. Odaa niɡ̶ijo nadegogo ane diniweneene baɡ̶a niɡ̶ina oko anida aneetege ɡ̶odaxakawa, ane abeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Niɡ̶ijo aneyatini nadegogo ane diniweneene baɡ̶a diaabo, ane ɡ̶odaxakawa. Niɡ̶ijo noko me dinopilaɡ̶aditedio nawodigijedi baɡ̶a niɡ̶ica noko nigicota liniogo niɡ̶ina iiɡ̶o. Odaa niɡ̶ijo anonioda leyeema baɡ̶a aanjotedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mijoataɡ̶a niɡ̶ijoa niimetedi anonawace nadegogo ane diniweneene, odaa joɡ̶oyalegi mini noledi, odaa jiɡ̶idaaɡ̶ee nigicota me ma niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, jiniiɡ̶e iniaanjotedi anodibatomi moiomaɡ̶adi oko anowo ane beyagi, codaa anowo eledi oko minoa libeyaceɡ̶eco. Odaa iniaanjotedi joɡ̶onoɡ̶aticoace niɡ̶idi oko liwigotigi niɡ̶idi eledi oko anepiɡ̶ida anejitege. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Odaa joɡ̶oyokoletiwece niɡ̶idi oko catiwedi noledi ane daɡ̶a ipe. Odaa jiɡ̶idiaaɡ̶itice oko me noenaɡ̶ateloco, codaa oyacigice lowe leeɡ̶odi lawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pida niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji anida anejitege baɡ̶a dataletibigiwaji lodoe Aneotedoɡ̶oji, ane Eliodi, liciagi aligeɡ̶e me datale. Niɡ̶ina oko ane wajipatalo yotaɡ̶a, leeditibige me watacotece! ");
INSERT INTO kbcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e niɡ̶ina oko laaleɡ̶enali, liciagi naɡ̶ana nalicexe aneiteloco nipodigi. Odaa ica ɡ̶oneleegiwa jona yakadi, pida one naligitacini. Odaa eliodi me ninitibece, codaa jeɡ̶eyaa icoatawece ane nepilidi, niɡ̶idiaaɡ̶idi joɡ̶opitacijo migo me dinoojeteta niɡ̶ijo nipodigi eotibige me nebi naɡ̶ajo nalicexe. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Eleditace niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, liciagi niɡ̶ina anoojetekegi ane doletibige me dinoojeteta wetiɡ̶a ane diniwaloe. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Odaa naɡ̶ani lakate wetiɡ̶a aneliodi niwaló, odaa jiɡ̶igo meyaa ijoatawece ane nepilidi. Odaa ja dinoojeteta naɡ̶aca wetiɡ̶a ane diniwaloe. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, liciagi niɡ̶ina neladi anoyokoletinigi weiigi. Niɡ̶ina neladi dibatalo inoatawece ane latopaco noɡ̶ojedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Odaa niɡ̶ina neladi naɡ̶a nolee noɡ̶ojedi, niɡ̶ina nomiigomigipi oixigiticogi daato, odaa nicotiniwace moiomaɡ̶adi noɡ̶ojedi. Niɡ̶inoa noɡ̶ojedi anele boɡ̶oyexaɡ̶atinigi naɡ̶aaɡ̶axi, pida niɡ̶inoa noɡ̶ojedi ane deɡ̶eleteda me jelicaɡ̶a boɡ̶oyaladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Niɡ̶ica noko nigicota liniogo niɡ̶ina iiɡ̶o, jiɡ̶idaaɡ̶ee. Aanjotedi enagitibeci, moiolaticoace oko, odaa onoɡ̶atedice niɡ̶inoa oko abeyacaɡ̶aɡ̶a liwigotigi niɡ̶ina oko anepaɡ̶a iɡ̶enaɡ̶atibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Odaa oyokoletiogi niɡ̶idi oko abeyacaɡ̶aɡ̶a catiwedi noledi ane daɡ̶a ipe. Aneitice oko me noenaɡ̶ateloco, codaa oyacigice lowe leeɡ̶odi lawikodico.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus igetediogi niɡ̶ijo anodiotibece, meetediogi, “Migowooɡ̶otitecetiwaji ijoatawece ijoa yatematiko?” Odaa joɡ̶oigidi, moditalo, “Jowooɡ̶otaɡ̶a, Ǥoniotagodi”. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Odaa meetediogi, “Enice digawini! Inatawece niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, niɡ̶ina naɡ̶a ikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena, ja liciagi niɡ̶ina eniodi anani lotetenaɡ̶anaɡ̶axi aneyate niɡ̶inoa nepilidi ane diniwaloe, odaa yakadi me diba niɡ̶ina ane gela, oɡ̶oa, domige niɡ̶ina baanaɡ̶a oxiiɡ̶odi, me yajigotiogi lionigipi. Jiɡ̶idaaɡ̶ee niɡ̶ijo niiɡ̶axinaɡ̶anaɡ̶a yakadi me diiɡ̶axinaɡ̶atece niɡ̶ina niiɡ̶axinaɡ̶aneɡ̶egi gela, codaa me niɡ̶ina oxiiɡ̶odi niiɡ̶axinaɡ̶aneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Niɡ̶ijo Jesus naɡ̶a ika me yatemati niɡ̶ijoa latematiko aninoa ane iciaceeketege, odaa ja noditedice niɡ̶ijo aneite. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Odaa joɡ̶opitedicogi manitaɡ̶a epaa nigotaɡ̶a. Niɡ̶ijo naɡ̶a diiɡ̶axinaɡ̶a mani niiakanaɡ̶axi, odaa niɡ̶ijo anowajipatalo joɡ̶oyopo leeɡ̶odi liiɡ̶axinaɡ̶aneɡ̶egi. Odaa ja dinigetiwage, modi, “Igame yakadite icoa lixaketedi? Codaa igame icoɡ̶otigi loniciwaɡ̶a meote ɡ̶odoxiceɡ̶etedi? ");
INSERT INTO kbcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Niɡ̶idoa lionigi niɡ̶ijoda gapinteelegi. Codaa naɡ̶ajoda eliodo ɡ̶odowooɡ̶ota, Maria. Codaa Tiago, José, Simão ijaa Judas nioxoadipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Codaa me niwaalepodi inaa liɡ̶eladi digoina Nazaré. Enice, igamigodaaɡ̶ee ica me yakadi me diiɡ̶axinaɡ̶a, codaa meote ɡ̶odoxiceɡ̶etedi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Odaa aɡ̶ica mowote. Pida Jesus meetediogi, “Idioka limedi moiweniɡ̶ide niɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Pida aniokani epaa nigotaɡ̶a codaa me liɡ̶eladi, baadoɡ̶oiweniɡ̶ide.” ");
INSERT INTO kbcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Odaa Jesus onateciɡ̶ijoa ɡ̶odoxiceɡ̶etedi aneote manitaɡ̶a epaa nigotaɡ̶a, leeɡ̶odi niɡ̶idi niɡ̶eladimigipi aɡ̶onakato. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Niɡ̶ijoa nokododi Herodes, ninionigi-eliodi nipodigi Galiléia, ja dibodicetibige Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Odaa meetiogi liotagipi, “Ejime niɡ̶idaa João Batista, ejinaɡ̶a yewiɡ̶atace me idei aneiticoace émaɡ̶aɡ̶a. Odaa leeɡ̶odi naɡ̶a yewiɡ̶atace, odaa jiɡ̶ida loniciwaɡ̶a meote ɡ̶odoxiceɡ̶etedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes eote niɡ̶ijoa lotaɡ̶a leeɡ̶odi jiɡ̶ijaa diiɡ̶enatakata moniwilo João, moigoe libaaɡ̶atedi, odaa joɡ̶oixotiwece niwiloɡ̶onaɡ̶axi. Idiɡ̶igota João leeɡ̶ote Herodias ane lodawa Filipe nioxoa Herodes. (Herodias ja lodawa Herodes ane niniwoodi.) ");
INSERT INTO kbcNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","João ijo meeta Herodes, “Ǥoniiɡ̶enatakaneɡ̶egi yolitaɡ̶adomi me ɡ̶adodawa naɡ̶ani lodawa ɡ̶anioxoa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Odaa Herodes ja domaɡ̶a yemaa me yeloadi João, pida doitiogi niɡ̶idi noiigi, leeɡ̶odi oyowooɡ̶odi João miniɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Niɡ̶icota ica lanikegi Herodes, odaa ja nalooɡ̶o. Aca liona Herodias ja dinibaile lodoe iditawece nodenigipi, odaa Herodes eliodi me ninitibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Odaa jeɡ̶eo ligegitege naɡ̶ajo awicije meo noɡ̶eedi okanicodaaɡ̶ica ane dipokotibige. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naɡ̶ajo eliodo ja yeloɡ̶odita ica ane lipoketegita Herodes. Odaa jiɡ̶igo naɡ̶ajo awicije minitaɡ̶a Herodes, odaa meeta, “Jemaa me anajicitiwa lacilo João Batista exakitinigi ɡ̶inogo niɡ̶ina natigide.” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Odaa Herodes, inionigi-eliodi, jaɡ̶agecaɡ̶alo. Pida jeɡ̶eo niɡ̶ijo ligegi ane daɡ̶a yakadi me inoke lodoe niɡ̶ijo lodenigipi me lalokegi lanikegi. Joaniɡ̶idaa leeɡ̶odi meo niɡ̶ijo ane lipoketegi naɡ̶ajo awicije. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Odaa ja diiɡ̶enatakata moyakagiditice João lacilo manitaɡ̶a niwiloɡ̶onaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Odaa joɡ̶onadeegi lacilo João oyexaɡ̶atinigi ɡ̶inogo, odaa joɡ̶oyajigota naɡ̶ajo awicije, odaa ja yadeegita eliodo niɡ̶ijo ɡ̶inogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Niɡ̶ijo anodiotibeci João jiɡ̶igotibeci, odaa joɡ̶oyadeegi lolaadi monaligitini. Niɡ̶idiaaɡ̶idi jiɡ̶igotibeci oyatematitalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Niɡ̶ijo Jesus naɡ̶a dibodicetedibige ane ninyaagi João, odaa ja noditedice niɡ̶ijo aneite, waxoditedinigi niwatece, igo mokijoatece miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi. Pida ijo noiigi-nelegi joɡ̶oyowooɡ̶odi ane diitedicogi, odaa ja noditicoaci nigotadi, jiɡ̶igotibeci onewaligitibigiwaji moigaalatece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Igaanaɡ̶a waxoditedice niwatece, odaa ja nadi niɡ̶ijo noiigi-nelegi. Odaa eliodi me iwikodetediogi niɡ̶ijo noiigi, odaa ja nicilatiditediniwace neelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naɡ̶a ɡ̶ocidi, niɡ̶ijo anodiotibece Jesus joɡ̶odiitalo, odaa moditalo, “Ja ɡ̶ocidi, codaa aɡ̶ica niɡ̶eladimigipi niɡ̶ina nipodigi anejonaɡ̶a. Iiɡ̶eni niɡ̶ina noiigi mopitibeci, amaleeɡ̶aɡ̶a igotibeci minoataɡ̶a niɡ̶inoa nigotadawaanaɡ̶a modinoojetetigi anoyeligo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pida Jesus naɡ̶a igidi, meetediogi, “Aleeditibige doɡ̶opitibeci. Akamaɡ̶akaamitiwaji ajicitiogi anoyeligo!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Odaa niɡ̶ijo anodiotibece joɡ̶oigidi, moditalo, “Idiwa mina ciinco paontedi, idiaa itiwataale noɡ̶ojedi, pida aɡ̶abo!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Odaa jeɡ̶ee Jesus, “Anadeegitediwa niɡ̶icoa paontedi idiaaɡ̶idioda icoa noɡ̶ojedi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Odaa ja iiɡ̶e niɡ̶ijo noiigi monicoteloco nadegocawaanigi. Odaa Jesus ja dibate niɡ̶ijoa ciinco paontedi ijaaɡ̶ijoa itiwataale noɡ̶ojedi. Odaa naɡ̶a iwitedibigimece ditibigimedi, odaa ja diniotagodete Aneotedoɡ̶oji. Naɡ̶a ninoketedini paontedi, odaa ja yajigotediogi niɡ̶ijo anodiotibece monediatiniwace niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Odaa ijotawece niodaɡ̶a, codaa me nitiminaɡ̶a. Niɡ̶idiaaɡ̶idi niɡ̶ijo anodiotibece joɡ̶oniodatece liwailidi ane iiɡ̶otedice. Odaa joɡ̶onoleenaɡ̶adi dooze etacanitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Niɡ̶ijo noko ejinaɡ̶a domaɡ̶a ijoa ciinco miili ɡ̶oneleegiwadi ane niodaɡ̶a, pida baadoɡ̶oyowooɡ̶odi ane liwokodi iwaalepodi inaa nigaanigipawaanigi ane niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aɡ̶ica daɡ̶a leegi Jesus ja iiɡ̶e niɡ̶ijo anodiotibece mowaxoditinigi niwatece, odaa jiɡ̶igotibeci daato weiigi, idaa Jesus baɡ̶a nenyaɡ̶atedi ibode niɡ̶ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Niɡ̶idiaaɡ̶idi naɡ̶a iiɡ̶e mopitibeci niɡ̶ijo noiigi, Jesus ja dalaɡ̶atetedibigimece aca wetiɡ̶a migo yotaɡ̶aneɡ̶e Aneotedoɡ̶oji mokiniwatece. Eɡ̶idiaaɡ̶ite neɡ̶enoale. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naɡ̶aca lakata naɡ̶ajo niwatece ja leegita me yototice liniogotibece weiigi. Odaa ebekadi ja igike naɡ̶ajo niwatece, codaa naɡ̶ajo niwatece ja dakapetege niwocotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aniɡ̶icatibige daɡ̶a yeloɡ̶otibige, Jesus ja iwidatediogi, jeɡ̶ewaligitedeloco ditibigimedi ninyoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Niɡ̶ijo anodiotibece noɡ̶onadi Jesus mewaligitedeloco ninyoɡ̶odi, odaa eliodi me nawelatibigiwaji, odaa modi, “Niɡ̶ina niwigo!”. Odaa ja nacaagaɡ̶ateloco codaa doitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pida aɡ̶ica daɡ̶a leegi Jesus meetediogi, “Anipeneɡ̶eni ɡ̶adaaleɡ̶ena! Jeɡ̶emeɡ̶ee. Jinaɡ̶adoiitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Odaa Pedro meetalo, “Ǥoniotagodi, nigewi naɡ̶akamaɡ̶akaami, enice adiiɡ̶eni maɡ̶aɡ̶a jawaligiteloco ninyoɡ̶odi mejigo jakapetaɡ̶agi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Odaa Jesus jeɡ̶eeteta, “Anagi!” Odaa Pedro ja waxoditice naɡ̶ajo niwatece, jeɡ̶ewaligiteloco ninyoɡ̶odi migo midoataɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pida naɡ̶a nadi niocodi me yoniciwadi, odaa ja doi, ja domaɡ̶a domololetini. Odaa ja dapaawe, mee, “Iniotagodi, jiniɡ̶ikani deɡ̶ee oceɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Odaa aɡ̶ica daɡ̶a leegi Jesus ja ixoketedice libaaɡ̶adi me nolitedini Pedro, odaa meeteta, “Niɡ̶ida makaami aɡ̶eliodi ɡ̶atiwaɡ̶atakaneɡ̶egi! Igaamee ina madawieni?” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Niɡ̶ijo noɡ̶owaxoditinigi naɡ̶ajo niwatece, odaa niɡ̶ijo niocodi ja notokoti. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Odaa niɡ̶ijo ane ideiticoace catinedi niwatece, joɡ̶odiitalo Jesus modoɡ̶etetalo, moditalo, “Dicewi makaami Lionigi Aneotedoɡ̶oji!” ");
INSERT INTO kbcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Niɡ̶ijo naɡ̶a diɡ̶etacicoace niɡ̶ijo weiigi, odaa joɡ̶otota nipodigi Genesaré. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Odaa niɡ̶ijo niɡ̶eladimigipi joɡ̶oyowooɡ̶oditege Jesus, odaa joɡ̶owo libodigi iditawece oko monadeegi neelotaginadi midiwataɡ̶a niɡ̶ijoa nipodaɡ̶a anodipegitege. Odaa joɡ̶onadeegitalo ijotawece ane eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Odaa joɡ̶odipokotalo mokexaa odibateloco liniogo nijayogo. Odaa ijotawece niɡ̶ijo anodibateloco nijayogo ja nicilaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Odaa jiɡ̶igotibeci icoa fariseutedi icaaɡ̶ica anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, oicoɡ̶oticogi Jerusalém. Igotibeci modinotigimadetege Jesus, odaa joɡ̶oige, moditalo, ");
INSERT INTO kbcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Igame leeɡ̶odi ina anodiotibigaɡ̶adici me doɡ̶oyiwaɡ̶aditeda liiɡ̶axinaɡ̶aneɡ̶eco ɡ̶odaamipi? Igaataɡ̶a aɡ̶oiwilegi libaaɡ̶atedi niɡ̶ina me niodaɡ̶a, anetiɡ̶odiiɡ̶axitece ɡ̶odaamipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus naɡ̶a igidi meetediogi, “Enice, igaamee ina me daɡ̶aɡ̶a otetenitatiwaji liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji? Igaataɡ̶a inoka iwitecetiwaji anakamaɡ̶a ɡ̶adiiɡ̶axinaɡ̶aneɡ̶egi ane dakapetege liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Igaataɡ̶a Aneotedoɡ̶oji diiɡ̶enataka, niɡ̶ijo neɡ̶ee, ‘Eemiteetibige ɡ̶adiodi, codaa me ɡ̶adiodo.’ codaa mee, ‘Leeditibige moyeloadi niɡ̶ina ane beyagi me dotaɡ̶atibige eliodi, codaa me eliodo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pida akamaɡ̶akaamitiwaji baɡ̶a iiɡ̶axini niɡ̶ina analeeɡ̶aɡ̶a domiɡ̶ida nimaweneɡ̶egi me yaxawa eliodi codaa me eliodo, leeɡ̶odi jaɡ̶awii me lakatigi, odaa moditiogi eliododipi, ‘Ja jajigotalo Aneotedoɡ̶oji niɡ̶ina ane inepilidi ane domaɡ̶a jajigotedaɡ̶awa’, ");
INSERT INTO kbcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Leeɡ̶odi menitiogi me daɡ̶alee leeditibige me deemitetibige codaa me yaxawa niɡ̶ina eliododipi. Odaa niɡ̶ida aneni aɡ̶aleeɡ̶otetenitiwaji ane iiɡ̶etedaɡ̶awa Aneotedoɡ̶oji, niɡ̶ina me iiɡ̶axinaɡ̶anitece ane ɡ̶adakatigitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Onawiitiwaji makaami oko ane iɡ̶enaɡ̶a. Codaa Isaías niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji eetece niɡ̶ina anewi, niɡ̶ijo naɡ̶a yalaɡ̶ataɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yalaɡ̶ata niɡ̶ica ane ligegi Aneotedoɡ̶oji, neɡ̶ee, ‘Niɡ̶idi noiigi odoɡ̶etetiwa me notaɡ̶anaɡ̶a. Pida catiwedi laaleɡ̶ena aɡ̶oyemaa metidowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aɡ̶ica niwaló niɡ̶ina modoɡ̶etetiwa, leeɡ̶odi odiiɡ̶axinaɡ̶atece inokinoa epaa lakataɡ̶a, odaa aɡ̶odiiɡ̶axinaɡ̶atece ane jiiɡ̶enatakata.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus eniditediogi niɡ̶ijo noiigi modipegitalo, odaa meetediogi, “Ajipaa amaleeɡ̶aɡ̶a mowooɡ̶otitiwaji! ");
INSERT INTO kbcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Niɡ̶ina ane napioyaɡ̶adi laaleɡ̶ena oko aɡ̶iniɡ̶ina ane dakatiwece nioladi. Pida ane napioyaɡ̶adi laaleɡ̶ena oko baɡ̶a ane icoɡ̶otiwece nioladi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Odaa joɡ̶ototalo niɡ̶ijo anodiotibece Jesus, odaa moditalo, “Aɡ̶owooɡ̶oti niɡ̶idi fariseutedi me neliɡ̶ideeɡ̶a leeɡ̶odi niɡ̶ijoa ɡ̶adotaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Odaa Jesus ja igidi, meetediogi, “Eiodi ane ideite ditibigimedi icota me nawace inoatawece nawodigijedi ane deɡ̶eyatedini. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Enice jinaɡ̶a agecaɡ̶aleɡ̶eni niɡ̶idiwa fariseutedi! Igaataɡ̶a niɡ̶idi liciagi niɡ̶ina anonibatege ɡ̶oladi, pida idiaaɡ̶idi aaɡ̶aɡ̶a ɡ̶oladi. Odaa niɡ̶ina ɡ̶olaɡ̶a nige nibatege eledi ɡ̶olaɡ̶a, odaa iditawece enitiniwace mida begi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Odaa Pedro jeɡ̶ee, “Enice, aneloɡ̶otitoɡ̶owa ane diitigi niɡ̶ijo natematigo anida ane iciaceekenitege.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Odaa Jesus jeɡ̶eetediogi, “Niɡ̶ida makaamitiwaji adaɡ̶axa minoa ɡ̶adixaketedi caticedi niɡ̶ina eledi oko! ");
INSERT INTO kbcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aɡ̶owooɡ̶otitiwaji? Niɡ̶ina ane dakatiwece nioladi oko, dakatiwece liwokomaɡ̶a, odaa ja noditicogi lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pida niɡ̶ina ane noditicogi nioladi oko icoɡ̶otiwece laaleɡ̶ena. Odaa niɡ̶ina ane noditicogi catiwedi laaleɡ̶ena beɡ̶eo me napioi laaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Igaataɡ̶a niɡ̶ina oko yowo niɡ̶ina ane beyagi catiwedi laaleɡ̶ena, odaa ja yeloadi niɡ̶ina eledi oko, codaa loomatewa lodawa eledi oko, codaa niɡ̶ina oko ane loomatewa ane daɡ̶a lodawa, codaa dolice, codaa aneo liwitakeco, codaa ane beyagi me dotaɡ̶atibige eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Niɡ̶ina oko nige yowo meo niɡ̶ina ane beyagi, odaa laaleɡ̶ena niɡ̶ini oko ja napioi. Pida niɡ̶ina oko nige daɡ̶a iwilegiteda libaaɡ̶atedi anoiiɡ̶axitece me lakatigi, baadaɡ̶a napioyaɡ̶adi laaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus naɡ̶a noditedicogi niɡ̶idi nipodigi, odaa jiɡ̶igo ica nipodigi anipegitege nigotadi Tiro aniaa Sidom. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Odaa ani aca iwaalo cananéia niɡ̶eladimatigi niɡ̶idi nipodigi. Odaa niɡ̶ipegitalo Jesus, ja dapaawe, mee, “Iniwa-aagodi, anida ane-eenitege licoɡ̶egi Davi, adiwikodeni! Niwigo abeyaceɡ̶egi dakatiogi i-oona, odaa eliodi me dawikode.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pida Jesus aɡ̶ica daɡ̶a igidi. Odaa niɡ̶ijo anodiotibece joɡ̶ototalo, odaa joɡ̶odipokotalo, moditalo, “Iiɡ̶eni naɡ̶ada iwaalo mopi, igaataɡ̶a niotibigoɡ̶odici codaa ja ɡ̶odatitata niɡ̶ina me dapaawetibece.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus meeteta naɡ̶ajo iwaalo, “Aneotedoɡ̶oji idiiɡ̶etediogi loiigi Israel ane liciagi niɡ̶inoa waxacocoli ane nabalaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Odaa naɡ̶ajo iwaalo ja diitalo, odaa ja yamaɡ̶atedini lokotidi lodoe Jesus, odaa meetalo, “Iniwa-aagodi, adaxawani!” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Odaa Jesus meeteta, “Adiitigi niɡ̶ina me jibanoonaɡ̶atece liweenigi nigaanigawaanigi, oditaɡ̶a jokolenaɡ̶atiogi necexodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Odaa ja igidi naɡ̶ajo iwaalo, meetalo, “Ewi, Iniwa-aagodi! Pida codaa me necexodawaanaɡ̶a oyeligo latijedi niwe-eenigi ane icoɡ̶otibigimece nameeja niwikateenoɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Odaa Jesus ja igidi, meeteta, “Iwaalo, niɡ̶ida makaami eliodi ɡ̶atiwaɡ̶atakaneɡ̶egi. Niɡ̶ida anemaani ja jao.” Odaa acaaɡ̶aca naɡ̶aca lakata naɡ̶ajo liona ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus naɡ̶a noditedicogi niɡ̶ijo aneite, odaa joɡ̶opitacedicogi lipecaɡ̶adi niweiigi Galiléia. Odaa ja dalaɡ̶atetedibigimece ajo wetiɡ̶a, odaa ja nicotedini. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Odaa eliodi oko joɡ̶odiitalo, oyadeegi aɡ̶atiloɡ̶oladi, alejaadotedi, ɡ̶oladi, ina ewaloɡ̶onadi, codaa mowidi eletidi eelotaginadi. Niɡ̶ijo noɡ̶oyadeegiticogi lodoe Jesus, odaa ijotawece ja nicilatiditediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Niɡ̶ijo noiigi eliodi moyopo noɡ̶onadi naɡ̶a notaɡ̶anaɡ̶a niɡ̶ijoa ewaloɡ̶onadi, alejaadotedi naɡ̶aɡ̶a nicilaɡ̶a, ane doɡ̶oyakadi mewaligitibigiwaji neɡ̶ewaligitibigiwaji, codaa me ɡ̶oladi yatetibigiwaji. Odaa joɡ̶odoɡ̶etetibigimece Aneotedoɡ̶oji, Noenoɡ̶odi loiigi Israel. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus eniditediogi niɡ̶ijo anodiotibece, odaa meetediogi, “Eliodi me jiwikode niɡ̶ina oko, igaataɡ̶a jeɡ̶eote itoatadiɡ̶ida nokododi mina meetaɡ̶a, odaa aɡ̶aleeɡ̶ica gaantokaaɡ̶idi anoyeligo. Ajemaa daɡ̶a jiiɡ̶etibigiwaji mopitibeci daaditiɡ̶icata ane jajigotiogi me jiniodeɡ̶etiniwace, igaataɡ̶a doidetibige diɡ̶ica ane noɡ̶omiwaditiniwace leeɡ̶odi nabocaɡ̶a doɡ̶opiticogi liɡ̶elatedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Odaa niɡ̶ijo anodiotibece joɡ̶oige Jesus, moditalo, “Igametaɡ̶a jakataɡ̶a ica niweenigi nelegi me jiniodeɡ̶enaɡ̶atiniwace iditawece niɡ̶idi oko digoina minataɡ̶a niɡ̶ina nipodigi ane diɡ̶ica niɡ̶eladimigipi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Odaa ja nigetediniwace, meetediogi, “Igame liwokodi ɡ̶anipaontedi anidiwa?” Odaa joɡ̶oigidi, moditalo, “Idiwa seete paontedi idiaaɡ̶idiwa noɡ̶ojedawaanaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Odaa Jesus ja iiɡ̶e niɡ̶ijo noiigi monicotinigiiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Odaa ja dibate niɡ̶ijoa seete paontedi ijaaɡ̶ijoa noɡ̶ojedawaanaɡ̶a, naɡ̶a diniotagodetedibigimece Aneotedoɡ̶oji, odaa ja ninoketedini, odaa ja yajigotediogi niɡ̶ijo anodiotibece monediatiniwace niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Odaa ijotawece niɡ̶ijo noiigi niodaɡ̶a, neɡ̶epaa nitiminaɡ̶a. Niɡ̶idiaaɡ̶idi niɡ̶ijo anodiotibece joɡ̶onioda niɡ̶ijoa liwailidi ane iiɡ̶otedice, odaa joɡ̶oyetigilo seete etacanitedi nelecoli. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Niɡ̶ica noko ejinaɡ̶a domaɡ̶a cwaatolo miili ɡ̶oneleegiwadi ane niodaɡ̶a, we iwaalepodi, inaa nigaanigipawaanigi anaɡ̶aɡ̶a niodaɡ̶a, pida baadoɡ̶onilaaɡ̶aditibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Odaa niɡ̶idiaaɡ̶idi Jesus ja imonya niɡ̶ijo noiigi mopitibeci, odaa jaɡ̶aɡ̶a waxoditedinigi niwatece, jiɡ̶igo midiwa nipodaɡ̶a Magadã. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niɡ̶idiaaɡ̶idi niɡ̶ijoa fariseutedi ijaaɡ̶ijoa saduceutedi joɡ̶ototalo Jesus. Odineetalo, domoɡ̶owo moyakadi gaantiɡ̶idi ane niwokotedini, odaa ja domaɡ̶a nilaagedi. Joaniɡ̶idaa leeɡ̶odi modipokotalo meote ɡ̶odoxiceɡ̶edi ane ikee me liiɡ̶exegi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Odaa Jesus ja igidi, meetediogi, “Niɡ̶ina naɡ̶a ɡ̶ocidi me ixagodi loolatedi, odaa menitiwaji, ‘Natiinigoi adatiode, leeɡ̶odi ɡ̶ocidi diticetinece.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Odaa niɡ̶ina nigoi me ixagoditege codaa me nexocaɡ̶a ditibigimedi, odaa menitiwaji, ‘Datiode, leeɡ̶odi loolatedi ixagodi me nabidi.’ Odaa boɡ̶owooɡ̶otitiwaji domige datiode, oɡ̶oa domige adatiode, niɡ̶ina mawinitibigimecetiwaji ditibigimedi. Pida baadoɡ̶owooɡ̶otitiwaji niɡ̶ica ane diitigi niɡ̶ina manati ɡ̶odoxiceɡ̶etedi ane jaote. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Niɡ̶ina oko aninaa niɡ̶inoa nokododi abeyacaɡ̶aɡ̶a codaa aɡ̶aleeɡ̶onakato Aneotedoɡ̶oji. Odaa Aneotedoɡ̶oji aɡ̶eote eledi ɡ̶odoxiceɡ̶edi ane ikeetiogi me idiiɡ̶e. Jeɡ̶eote niɡ̶ijo ɡ̶odoxiceɡ̶edi ane ikee me idiiɡ̶e, niɡ̶ijo me ideyate Jonas catiwedi le niɡ̶ijo noɡ̶ojegi nelegi itoatadiɡ̶ida nokododi.” Odaa Jesus ja yototedicoace, joɡ̶opi. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Niɡ̶ijo naɡ̶a diiɡ̶etita daato weiigi niɡ̶ijo anodiotibece, oyaagiditece doɡ̶oyadeegi paontedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Odaa Jesus meetediogi, “Atacolitiwaji codaa anidakita nabookojedi fariseutedi inaa saduceutedi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Odaa niɡ̶ijo anodiotibece joɡ̶odinotaɡ̶aneɡ̶etigi niɡ̶ida aneete, modi, “Eote niɡ̶ida ligegi leeɡ̶odi aɡ̶icoa me inadeegaɡ̶a ɡ̶onipaontedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pida Jesus ja yowooɡ̶odi ane lotaɡ̶a, odaa ja nigetediniwace, meetediogi, “Igaamee ina madinotaɡ̶aneɡ̶enitigitiwaji me diɡ̶ica ɡ̶anipaon? Ame iwaɡ̶atitetiwaji Aneotedoɡ̶oji! ");
INSERT INTO kbcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anoɡ̶owooɡ̶otitiwaji? Naɡ̶a ɡ̶adaagititibige ijoa ciinco paontedi ane jatikatalo me jiniodeɡ̶etiniwace ciinco miili ɡ̶oneleegiwadi, ijaaɡ̶ijoa etacanitedi ane nolee niɡ̶ijoa liwailidi ane iiɡ̶otedice? ");
INSERT INTO kbcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Codaa naɡ̶a ɡ̶adaagititibigetiwaji ijoa seete paontedi ane jatikatalo me jiniodeɡ̶etiniwace cwaatolo miili ɡ̶oneleegiwadi, ijaaɡ̶ijoa etacanitedi nelecoli ane nolee niɡ̶ijoa liwailidi ane iiɡ̶otedice? ");
INSERT INTO kbcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aɡ̶owooɡ̶otitiwaji me daɡ̶a idalaɡ̶ata paon niɡ̶ijo me ɡ̶adajacaɡ̶atitiwaji manidakita nabookojedi fariseutedi idiaa saduceutedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Odaa joɡ̶oyowooɡ̶odi Jesus me daɡ̶a yalaɡ̶ate modinidakata paon labookojedi, pida modinidakata liiɡ̶axinaɡ̶aneɡ̶eco fariseutedi ijaa saduceutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus igo nipodaɡ̶a anipegitege nigotaɡ̶a, ane liboonaɡ̶adi “Cesaréia Filipe ane dabiteɡ̶etini”. Jiɡ̶idiaaɡ̶i naɡ̶a nigetediniwace niɡ̶ijo anodiotibece, meetediogi, “Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, odaa ame Ee modi ina oko?” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Odaa joɡ̶oigidi, moditalo, “Inatecibece modi makaami João Batista, codaa inatecibece eledi modi makaami Elias. Codaa ina eledi modi makaami Jeremias, oɡ̶oa, domige anigepidiɡ̶ica niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji niɡ̶ijo jotigide.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Odaa Jesus ja digika, meetediogi, “Biɡ̶ida makaamitiwaji, amakati me Ee?” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simão Pedro naɡ̶a igidi, meetalo, “Jaɡ̶akamaɡ̶akaami ane iiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatiteɡ̶egi. Akaami Lionigi Aneotedoɡ̶oji anidioka limedi me yewiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Odaa Jesus ja igidi, meeteta, “Aniniitibeci niɡ̶ida makaami Simão, anakaami lionigi João, leeɡ̶odi aɡ̶oko anoikeetaɡ̶awa ane Ee, pida Eiodi ane ideite ditibigimedi ikeetedaɡ̶awa ane Ee. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Natigide jao gela ɡ̶aboonaɡ̶adi akaami Pedro (leeɡ̶odi niitege niɡ̶ina mejinaɡ̶a wetiɡ̶a). Odaa ɡ̶adotaɡ̶a me ɡ̶adalakitiwa liciagi naɡ̶ana wetiɡ̶a anodatika moyoe lipodaɡ̶aladi diimigi. Odaa ja jao niɡ̶ina oko anoyiwaɡ̶adi niɡ̶ijoa ɡ̶adotaɡ̶a me micataɡ̶a niɡ̶ina diimigi ane dabiteɡ̶eteloco niɡ̶ina noenatagodi ditibigimedi wetiɡ̶a ane ɡ̶oneɡ̶e. Odaa oteɡ̶exaaɡ̶aɡ̶a némaɡ̶a aɡ̶aleeɡ̶ica loniciwaɡ̶ateloco niɡ̶idi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Codaa jajigotaɡ̶awa ɡ̶adiiɡ̶enatakaneɡ̶egi me iiɡ̶eni niɡ̶ina oko anida anejitege, micataɡ̶a niɡ̶ina oko anida lakabakenaɡ̶anaɡ̶adi ane dowediteloco diimigi, odaa niɡ̶ica anoliitege digoina iiɡ̶o, Aneotedoɡ̶oji aaɡ̶aɡ̶a yolitetege. Odaa niɡ̶ica anikani mowo niɡ̶ina oko digoina iiɡ̶o, odaa Aneotedoɡ̶oji aaɡ̶aɡ̶a ika.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Odaa Jesus ja dipokotediogi niɡ̶ijo anodiotibece me doɡ̶oyeloɡ̶oditiogi niɡ̶ina oko me Niɡ̶ijaaɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Odaa joaniɡ̶ijaaɡ̶ijotigi niɡ̶ijo noko Jesus jiɡ̶idaaɡ̶eyatedigi me yeloɡ̶oditediogi niɡ̶ijo anodiotibece me leeditibige migo manitaɡ̶a nigotaɡ̶a Jerusalém, codaa me leeditibige meliodi me dawikode libaaɡ̶adi niɡ̶icoa laxokodi lacilodi noiigi judeutedi, ijaaɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Codaa me leeditibige me yeleo, pida nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, odaa ja yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Odaa Pedro ja yadeegitedice Jesus me yapeteɡ̶e, meetalo, “Aneotedoɡ̶oji ɡ̶adiwikodeni, odaa aika daɡ̶awikodee, Ǥoniotagodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Odaa Jesus ja niwiteta Pedro, odaa meete, “Otonitice yodoe, Satanás! Domaɡ̶a adibeyacaɡ̶ati macataɡ̶a naɡ̶ana wetiɡ̶a ane itinece naigi ane ixipe oko, leeɡ̶odi ɡ̶adowoocaɡ̶awa niɡ̶ina oko, pida aɡ̶adowoocaɡ̶awa Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Odaa Jesus meetediogi niɡ̶ijo anodiotibece, “Nigica ane yemaa me niotici, leeditibige me daɡ̶adiaa iniokini me dinowo, codaa leeditibige me igotema me diniwikodetibece, codaa me dawikode nigepaa yeleo, odaa ja niotici. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Igaataɡ̶a niɡ̶ina ane yemaa minoka yewiɡ̶ateloco niɡ̶ina iiɡ̶o, aɡ̶ica lewiɡ̶a ane diɡ̶ica liniogo, pida niɡ̶ina baanaɡ̶a igo me yeleotomi, niɡ̶ini oko baanaɡ̶a ida lewiɡ̶a ane diɡ̶ica liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Igaataɡ̶a niɡ̶ina oko nige yakadi inoatawece ane yopotibige digoina iiɡ̶o, pida odaa liwigo baɡ̶a ika me yeleo, niɡ̶ini oko aɡ̶ica anigetiɡ̶ida nigaanye. Igaataɡ̶a aɡ̶ica anigetiɡ̶idi liboonigi me dedianaɡ̶a niɡ̶ina oko oditaɡ̶a eo lewiɡ̶a liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Leeɡ̶odi Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, idopitijo anigida noko idiaa iniaanjotedi, codaa loniciwaɡ̶a Aneotedoɡ̶oji ane Eiodi, idei meetaɡ̶a. Odaa ja jiwi ane loenataka inatawece oko, codaa jajigotiogi niɡ̶ica loojedi ane loenataka ane beyagi, oɡ̶oa, domige anele. ");
INSERT INTO kbcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ejitaɡ̶awatiwaji anewi. Ina oko digoina analee daɡ̶a nigo nigetidadi me janagi me Ee inionigi-eliodi ane iiɡ̶e oko laaleɡ̶enali.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naɡ̶a ixomaɡ̶atedijo seis nokododi, Jesus ja yadeegi Pedro, Tiago ijaaɡ̶ijo nioxoa anodita João, idiokidi niɡ̶idi itoatadiɡ̶ida anodiotibece me yadeegi. Odaa ja yadeegitedicogi maditaɡ̶a aca wetiɡ̶a ane leegitibigimece, ane diɡ̶ica oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Odaa noɡ̶oiwitalo, joɡ̶onadi Jesus me diniigi idoatawece, latobi ja datale macataɡ̶a aligeɡ̶e, lowoodi jaɡ̶aɡ̶a yapacaɡ̶a me datale. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Codaaɡ̶ida noɡ̶onadi me dinikee Moisés ijaa Elias, odaa joɡ̶oyotaɡ̶aneɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Odaa Pedro jaɡ̶aɡ̶a dotaɡ̶a, meetalo Jesus, “Ica mele minaaɡ̶ejonaɡ̶a, Ǥoniotagodi. Nigemaani, jaote iniwatadiɡ̶ini nopecetiidi, oniniteci ɡ̶anebi, iniaaɡ̶eledi Moisés nebi, iniaaɡ̶eledi baɡ̶aɡ̶a Elias nebi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eɡ̶idaaɡ̶ee Pedro me dotaɡ̶a, ica lolaadi ane datale ja yapoɡ̶oditiniwace Jesus, Moisés ijaa Elias. Odaa joɡ̶owajipata ica notaɡ̶aneɡ̶egi catiwedi lolaadi, anee, “Niɡ̶idoa Ionigi yemaanigi, aneliodi meote me idinitibeci. Atacolitecetiwaji niɡ̶inoa lotaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Niɡ̶ijo noɡ̶owajipata niɡ̶ijo anodiotibece Jesus niɡ̶ijo ane dotaɡ̶a, odaa ja dakagitiniwace oyatedini iiɡ̶o latopidi, leeɡ̶odi eliodi me doitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Odaa Jesus ja diitediogi, naɡ̶a dibatedeloco, meetediogi, “Adabititiniwacetiwaji, codaa jinaɡ̶adoii!” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Odaa naɡ̶a noletibigimoace, noɡ̶oiwitalo, aɡ̶ica anigetiɡ̶ijo eledi anonadi, idokidoateda Jesus monadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Naɡ̶a daxoditiniwace naɡ̶ajo wetiɡ̶a, Jesus ja yajoi niɡ̶ijo itoatadiɡ̶ida anodiotibece, meetediogi, “Jinaɡ̶a domiɡ̶ica aneloɡ̶ititatiwaji ananati maditaɡ̶a wetiɡ̶a nigepaa idewiɡ̶atace, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Odaa niɡ̶ijo anodiotibece joɡ̶oige, moditalo, “Igaamee ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés modi menagi Elias maleediɡ̶ica meno Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji meo me ɡ̶odewiɡ̶atace?” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Odaa Jesus ja igidi, meetediogi, “Ewi niɡ̶idaaɡ̶ee Elias menagi maleediɡ̶ica Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji meo oko me newiɡ̶atace. Elias enagi me ilakidetedice inoatawece. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pida ejitaɡ̶awatiwaji Elias jiɡ̶ijo menagi, codaa ɡ̶odacilodi aɡ̶oyowooɡ̶odi, odaa joɡ̶owotema niɡ̶ica anoyemaa modigota. Odaa idaaɡ̶odigotiwa owo me jawikode, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Odaa niɡ̶ijo anodiotibece joɡ̶oyowooɡ̶odi Jesus me yalaɡ̶ate João Batista niɡ̶ijo naɡ̶a yalaɡ̶ate Elias. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Niɡ̶ijo Jesus naɡ̶a diitacediogi niɡ̶ica noiigi-nelegi lixigaɡ̶awepodi niɡ̶ijo itoatadiɡ̶ida anodiotibece, odaa ijo ɡ̶oneleegiwa jiɡ̶ipegitalo Jesus. Naɡ̶a yamaɡ̶atedini lokotidi lodoe Jesus, odaa meetalo, ");
INSERT INTO kbcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Iniotagodi, iwikodeni ionigi! Ǥatiɡ̶alegi, odaa eliodi me dawikode, elioditibece menitibiga, odaa enitiogi noledi, codaa idatibece daxaboketinigi ninyoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ja inadeegitiogi niɡ̶idi anodiotibigaɡ̶adici, pida joɡ̶oyapi moicilatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Odaa Jesus meetediogi, “Jodaɡ̶akamaɡ̶akaamitiwaji niɡ̶ica noiigi ane doɡ̶oyiwaɡ̶aditeda Aneotedoɡ̶oji, codaa akamaɡ̶a adininaalenitiwaji. Niɡ̶ida me Ee aleegi minaaɡ̶ejo makaamitaɡ̶atiwaji, codaa ajakadi deɡ̶eliodi me idinatitaɡ̶awatiwaji. Anadeegitiwa niɡ̶ica lioneeɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Noɡ̶onadeegitalo, odaa Jesus ja yapeteɡ̶e niɡ̶ica niwigo abeyaceɡ̶egi, codaa iiɡ̶e me noditice. Odaa aɡ̶ica daɡ̶a leegi, niɡ̶ica niwigo abeyaceɡ̶egi ja noditice mijotaɡ̶a niɡ̶ijo lioneeɡ̶a, odaa ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Niɡ̶idiaaɡ̶idi niɡ̶ijo anodiotibece Jesus joɡ̶odiitalo noɡ̶okaaniɡ̶idoatece, odaa joɡ̶oige, moditalo, “Igaamee ina daɡ̶a jakataɡ̶a me jiticodaɡ̶atice ijo niwigo abeyaceɡ̶egi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Odaa ja igidi Jesus, meetediogi, “Aɡ̶akatitiwaji miticoitice niɡ̶ijo niwigo ane beyagi leeɡ̶odi aɡ̶eliodi manakatoni Aneotedoɡ̶oji. Ejitaɡ̶awatiwaji niɡ̶ina anewi. Doɡ̶okateciɡ̶ini ɡ̶atiwaɡ̶atakaneɡ̶egi, macataɡ̶a naɡ̶ana lolagi ‘mostaada’ ane daɡ̶axa me lionawaana, taɡ̶akatitiwaji me enita naɡ̶ani wetiɡ̶a, ‘Otonitice, emii digoida!’ Odaa wetiɡ̶a ja alatí. Aɡ̶ica ane apini mawii, nige iwaɡ̶ati Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pida okanicodaaɡ̶ica niwigo liciagi niɡ̶ijo niwigo abeyaceɡ̶egi noditice idokidata nigotaɡ̶aneɡ̶eni Aneotedoɡ̶oji, codaa nige ikanawaanigi maniodi moleetibige meneɡ̶egi otaɡ̶aneɡ̶eni Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Niɡ̶ica me yatecoɡ̶o niɡ̶ijo anodiotibece midi nipodigi Galiléia, Jesus meetediogi, “Etidajigota libaaɡ̶adi ɡ̶oneleegiwadi, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Odaa etideloadi, pida nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.” Niɡ̶ijo anodiotibece eliodi magecaɡ̶alodipi noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece noɡ̶ototicogi nigotaɡ̶a Cafarnaum, niɡ̶ijo ane oniodatema ninyeelo Aneotedoɡ̶oji liɡ̶eladi, joɡ̶otota Pedro, odaa joɡ̶oige, modita, “Idoa ɡ̶aniotagodi domige yajigo dinyeelo ane leeditibige me yajigo minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Odaa Pedro ja igidi, meetiogi, “Yedia.” Odaa ja dakatiwece diimigi. Pida aniɡ̶icatibige daɡ̶a dotaɡ̶a Pedro, niɡ̶ijapaɡ̶a odoejegi me dotaɡ̶a Jesus, odaa ja ige, meete, “Simão, amiida ɡ̶adowoogo? Etiɡ̶odiiɡ̶e me jajicaɡ̶atiogi dinyeelo niɡ̶inoa ɡ̶odaciloditigi niɡ̶ina iiɡ̶o. Pida amiijo ica ane dedianaɡ̶a? Domigepaa loiigi nedianaɡ̶anaɡ̶a, oɡ̶oa, domigina anokegipi anoicoɡ̶oticogi eletidi nipodaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Odaa Pedro ja igidi, meetalo, “Niɡ̶inoa icoɡ̶aɡ̶a boɡ̶oyedia.” Odaa Jesus jeɡ̶eete, “Odaa niɡ̶ida moko anoko loiigi ame leeditibige me jedianaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pida aɡ̶ele daɡ̶a jaoɡ̶a me neliɡ̶ideeɡ̶a niɡ̶idi anetiɡ̶odipiciadi. Natigide, emii miditaɡ̶a weiigi, odaa okolenitini ɡ̶adomiigo. Odaa okeni niɡ̶ica odoejegi noɡ̶ojegi ane ixigi ɡ̶adomiigo. Odaa catiwedi nioladi akati beexo. Odaa anadeegi naɡ̶ani beexo, ediani niɡ̶ica ane leeditibige me jedianaɡ̶a mini Aneotedoɡ̶oji liɡ̶eladi. Naɡ̶ani beexo abotema mediani codaa ane leeditibige maɡ̶aɡ̶a jedia.” ");
INSERT INTO kbcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jesus eɡ̶idaaɡ̶eeteda me yotaɡ̶aneɡ̶e Pedro, odaa niɡ̶ijo anodiotibece jiɡ̶igotibeci midoataɡ̶a, odaa joɡ̶oige, moditalo, “Amiina ica oko ane ɡ̶oneɡ̶egi ina naɡ̶a iiɡ̶e Aneotedoɡ̶oji laaleɡ̶enali ina oko?” ");
INSERT INTO kbcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Odaa Jesus jeɡ̶enidite ijo nigaanigawaanigi, jiɡ̶ideyate liwigotigi niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Odaa meetediogi, “Ejitaɡ̶awatiwaji anewi. Nige daɡ̶a iigitiwaji aneni me ɡ̶adewiki, codaa nige daɡ̶adiniwikodenitibece micataɡ̶a niɡ̶ini nigaanigawaanigi, Aneotedoɡ̶oji aiiɡ̶e ɡ̶adaaleɡ̶enalitiwaji, odaa aɡ̶ica anenitege. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Enice, niɡ̶ina oko ane diniwikodetibece, codaa aneo me liciagi niɡ̶ida nigaanigawaanigi, baaniɡ̶iniaa eneɡ̶egi ɡ̶oneɡ̶egi liwigotigi noiigi anida aneetetege Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Odaa niɡ̶ina anele me dibatege niɡ̶ina nigaanigawaanigi liciagi anejigo me jibatege niɡ̶idoda nigaanigawaanigi, codaa nige dibatege leeɡ̶odi Iboonaɡ̶adi, odaa niɡ̶ini oko dibatigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nigica aneo anigepidiɡ̶ica niɡ̶ina nigaanigipawaanigi me ika me idinakato, domaɡ̶a daɡ̶axa mele moigoetece lotoinaɡ̶adi naɡ̶ana wetiɡ̶a nelegi, oditaɡ̶a oyokoletinigi akiidi-eliodi moyoceɡ̶atidi, maleedeɡ̶eo niɡ̶ida loenatagi ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o icota meliodi me nawikodeeɡ̶a leeɡ̶odi niɡ̶inoa loenataka ane beyagi anowo eledi oko moika moyiwaɡ̶adi Aneotedoɡ̶oji. Niɡ̶inoa anodineetoɡ̶owa idioka limedi minoa, pida Aneotedoɡ̶oji icota meote meliodi me nawikodeeɡ̶a niɡ̶ina oko aneo eledi oko moika moyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Niɡ̶ina ɡ̶abaaɡ̶adi, idaa ɡ̶adoɡ̶onagi nigowo mabataa, leeditibige maloikatiti ɡ̶abaaɡ̶adi, codaa me ɡ̶adoɡ̶onagi micataɡ̶a daɡ̶akagiti, oditaɡ̶a alati. Igaataɡ̶a daɡ̶axa mele mokidatece ɡ̶abaaɡ̶adi, domigetaɡ̶a ɡ̶adoɡ̶onagi, pida akati makaatiwece miniwataɡ̶a Aneotedoɡ̶oji, odaa idioka limedi me ɡ̶adewiki. Aɡ̶ele diɡ̶idoatawece ɡ̶abaaɡ̶atedi, ɡ̶adoɡ̶onaka, pida etiɡ̶adokolenitiogi noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ǥagecooɡ̶e nigeo mabataa, aloikatiti, micataɡ̶a daɡ̶a anoɡ̶aa, odaaɡ̶alati. Igaataɡ̶a daɡ̶axa mele makaatiwece miniwataɡ̶a Aneotedoɡ̶oji, odaa idioka limedi me ɡ̶adewiki mokanitece ɡ̶agecooɡ̶e. Aɡ̶ele diɡ̶idiwatawece ɡ̶agecooɡ̶eli, pida etiɡ̶adokolenitiogi noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Anidakitatiwaji adaɡ̶aleetibige daatiɡ̶ica ane jaoɡ̶a niɡ̶inoda nigaanigipawaanigi. Ejitaɡ̶awatiwaji niɡ̶icoa aanjotedi anodowediteloco niɡ̶ina nigaanigipawaanigi idioka limedi midi lodoe Eiodi ane ideite ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, janagi me jopilaɡ̶aditacalo Aneotedoɡ̶oji niɡ̶ina aniatagigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Amiida ica anakatitecetiwaji? Diɡ̶ini ɡ̶oneleegiwa anidiwa onaniteci taalia niwaxacocoli, oditaɡ̶a jaɡ̶aca aniadi. Odaa amigetiɡ̶ida anee? Ejitaɡ̶awa me yoya niɡ̶idiwa noventa-noove waxacocoli madi wetiɡ̶a anei me nadecoɡ̶onaɡ̶a. Odaa jiɡ̶igo doletibige naɡ̶ajo ananiaditibige. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ejitaɡ̶awatiwaji anewi. Niɡ̶ina nige yakadi, eliodi me ninitibece, leeɡ̶odi me yakadi naɡ̶ajo niwaxacoco, odaa daɡ̶axa me ninitibece, caticedi linikegitema niɡ̶ijoa noventa-noove ane daɡ̶aniaditeda. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jiɡ̶idaaɡ̶ee Ǥadioditetiwaji aneite ditibigimedi, ayemaa me aniatagigi anigeteɡ̶epidiɡ̶ica niɡ̶ina oko anonakato ane micataɡ̶a niɡ̶ina nigaanigawaanigi meyiwaɡ̶adi eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nige dibatá ɡ̶anioxoa, eotaɡ̶adomi ane beyagi, emii minitaɡ̶a mokakaamitece, ikeenita ane libatiigi. Nige niwoditaɡ̶adomi, jaɡ̶anigaanyetece ɡ̶anioxoa. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pida nige daɡ̶a niwoditaɡ̶adomi, odaa adeegi eletidi itoa oɡ̶oa domige itoatadiɡ̶ida ɡ̶adixigaɡ̶awepodi motaɡ̶aneɡ̶enitiwaji, awii aneeta Aneotedoɡ̶oji lotaɡ̶a. Igaataɡ̶a mee Aneotedoɡ̶oji lotaɡ̶a, ‘Niɡ̶ina nigica oko ane yeloɡ̶odita eledi oko libeyaceɡ̶eco, leeditibige eletidi itoa oɡ̶oa domige itoatadiɡ̶ida oko midokida ane ligegi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pida nige daɡ̶a niwoditema niɡ̶idi oko, enice leeditibige eleɡ̶enitiogi niɡ̶idi lapo anoyiwaɡ̶adi Ǥoniotagodi. Odaa nige daɡ̶aɡ̶a wajipatiogi niɡ̶idi lapo anoyiwaɡ̶adi Ǥoniotagodi, odaa ademii niɡ̶ini ɡ̶anioxoa micataɡ̶a niɡ̶ina oko ane deɡ̶eyiwaɡ̶aditeda Aneotedoɡ̶oji, codaa me laxokegi abataɡ̶a, codaa aɡ̶aleeɡ̶ica anenitege. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ejitaɡ̶awatiwaji anewi. Okanicodaaɡ̶ica anoliitegetiwaji digoina iiɡ̶o, Ǥadiodi ane ideite ditibigimedi aaɡ̶aɡ̶a yolitetege. Codaa okanicodaaɡ̶ica anikanitiwaji midaɡ̶aee digoina iiɡ̶o, Ǥadiodi ane ideite ditibigimedi aaɡ̶aɡ̶a ika midaɡ̶aee. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Aaɡ̶aɡ̶a ejitaɡ̶awatiwaji, nigidi iniwataale niɡ̶ina akaamitiwaji digoina iiɡ̶o ane dinilakidetiwage odaa idokida ane lipoketegi niɡ̶ina moyotaɡ̶aneɡ̶e Eiodi, odaa Eiodi ane ideite ditibigimedi jeɡ̶eote niɡ̶ica ane lipoketegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Igaataɡ̶a diɡ̶idiwa iniwataale, domige iniwatadiɡ̶ini oko ane yatecoɡ̶o moiweniɡ̶ide Iboonaɡ̶adi, odaa idejo miditaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Odaa Pedro jiɡ̶icotalo Jesus, ja ige, meetalo, “Iniotagodi, igame liwokodi me leeditibige me jixomaɡ̶ateetice inioxoa libeyaceɡ̶eco aneotomi? Domige leeditibige nigepaa seete me jixomaɡ̶ateetice libeyaceɡ̶eco inioxoa?” ");
INSERT INTO kbcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus naɡ̶a igidi, meeteta, “Aɡ̶okexaa seete me ixomaɡ̶ateenitice libeyaceɡ̶eco ɡ̶anioxoa aneotaɡ̶adomi. Pida leeditibige midioka limedi me ixomaɡ̶ateenitice libeyaceɡ̶eco ɡ̶anioxoa aneotaɡ̶adomi, aleeditibige daɡ̶a anilaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Igaataɡ̶a niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, eote liciagi niɡ̶ina inionigi-eliodi ane lowoogo me ilakidetedini naalewe liotagipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Niɡ̶ina naɡ̶a dinilakidetege, jonoɡ̶onadeegita ica liotagi ane dinaalewe deez miili icoa beexotedi oolo. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aɡ̶aleeɡ̶ica nimaweneɡ̶egi me yedia niɡ̶ijoa naaleweli anowidi. Odaa niɡ̶ijo niotagodi ja domaɡ̶a diiɡ̶enataka niɡ̶ijo liotagi moyaa dioteci lodawa, lionigipi, moiwotagetibigiwaji, codaa moyaa idiwatawece ane nepilidi me yedianawaanigi naalewe. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pida niɡ̶ijo niotagi ja yamaɡ̶atedini lokotidi lodoe niɡ̶ijo niotagodi, odaa ja dipokota, meeta, ‘Aliitatiwa, jedianoda idiwatawece ane inaalewetaɡ̶awa anigida noko.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Odaa niɡ̶ijo niotagodi eliodi me iwikode, odaa ja ixomaɡ̶ateetedice niɡ̶ijoa naalewe, codaa ikatice mopi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pida ijaaɡ̶ijo niɡ̶ijo niotagi naɡ̶a noditice, odaa ja dakapetege ica eledi liotagi inionigi-eliodi. Niɡ̶ijo eledi niotagi baɡ̶a dinaalewe onexaa onateciɡ̶idiwa beexotedi naaleweta niɡ̶ijo odoejegi niotagi anowidi naalewe. Pida dibatigi lotoinaɡ̶adi, odaa ja iligice, meeta, ‘Yokaaɡ̶edi adediani niɡ̶ijoa anadinaalewe!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Odaa niɡ̶ijo lokaaɡ̶edi ja yamaɡ̶atedini lokotidi, odaa ja dipokota, meeta, ‘Aliitatiwa, odaa icota me ɡ̶adediani idiodatawece ane inaalewetaɡ̶awa.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pida ayemaa me ixomaɡ̶ateetedice, odaa ja yadeegi niɡ̶ijo lokaaɡ̶edi mani niwiloɡ̶onaɡ̶axi midiaaɡ̶i nigepaa yediatelogo ane naalewe. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Niɡ̶ijo noɡ̶onadi eletidi niotaka niɡ̶ida niciagi, eliodi me agecaɡ̶alodipi, odaa jiɡ̶igotibeci oyeloɡ̶odita niotagodi, inionigi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Odaa niɡ̶ijo niotagodi jeɡ̶enidita niɡ̶ijo liotagi anowidi naalewe, odaa meeta, ‘Ejinaɡ̶a akamaɡ̶akaami niɡ̶ica nimeedi ane daɡ̶axa me agopeloagi! Ijoatawece niɡ̶ijoa dinyeelo owidi ane adinaaleweeni jixomaɡ̶ateetedice leeɡ̶odi manipokitiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Odaa niɡ̶ida makaami leeditibige me iwikodeni ɡ̶adokaaɡ̶edi, digo anejigotaɡ̶awa me ɡ̶adiwikodeni.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Niɡ̶ijo niotagodi eliodi me yelatema, odaa ja iiɡ̶eticogi niɡ̶ijo limeedi mani niwiloɡ̶onaɡ̶axi moiloikatidi nigepaa yedia icoatawece ane naalewe. ");
INSERT INTO kbcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Odaa jiɡ̶idaɡ̶aɡ̶a igotedaɡ̶awatiwaji Eiodi ane ideite ditibigimedi nige deɡ̶ewi mixomaɡ̶ateenitedicetiwaji anowotaɡ̶adomi ane beyagi ɡ̶anioxoadipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Niɡ̶ijo Jesus naɡ̶a ika me diiɡ̶axinaɡ̶a, odaa ja noditedicogi nipodigi Galiléia, odaa joɡ̶opitacedicogi liwai nipodigi Judéia, daato akiidi Jordão. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eliodi oko anodiotece, odaa nicilatiditedini eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Icoa fariseutedi igotibeci midoataɡ̶a Jesus modineetalo meote ligegi ane beyagi. Odaa moditalo, “Ǥonajoinaɡ̶aneɡ̶eco domige oika ina ɡ̶oneleegiwa me yaladi lodawa mokanicodaaɡ̶ica ane leeɡ̶odi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Odaa Jesus ja igidi, meetediogi, “Ica ina daaditiɡ̶ica malomeɡ̶eniteloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, miditaɡ̶a anee, ‘Maleekoka yoeteda Aneotedoɡ̶oji niɡ̶ina iiɡ̶o, odaa ja yoe oko, ɡ̶oneleegiwa aniaaɡ̶iwaalo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Odaa Aneotedoɡ̶oji mee, ‘Joaniɡ̶idaa leeɡ̶odi ɡ̶oneleegiwa me ikaticoace eliododipi, odaa ja noiigiwa lodawa, odaa niɡ̶idi iniwataale ja micataɡ̶a doɡ̶okinitece oko.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Odaa aɡ̶aleeɡ̶iniwataale, pida oneniɡ̶initeci. Enice aɡ̶ica ɡ̶oneleegiwa ane yakadi me yawalaceticoace niɡ̶ina ane yexocaɡ̶aditediwage Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Odaa niɡ̶ijoa fariseutedi moditalo, “Enice, igame leeɡ̶odi Moisés me iiɡ̶e ɡ̶oneleegiwa me yakadi me iticoitice lodawa nige yajigota naɡ̶ani lodawa notaɡ̶anaɡ̶axi ane ikee naɡ̶a yaladi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus ja igidi, meetediogi, “Moisés ɡ̶adikanitiwaji malati ɡ̶adodawa leeɡ̶odi me dakake ɡ̶adaaleɡ̶enali. Pida niɡ̶ijo maleekoka yoeteda Aneotedoɡ̶oji ɡ̶oneleegiwa aniaaɡ̶iwaalo, aniɡ̶idaaɡ̶ee. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pida ejitaɡ̶awatiwaji nigica ane yaladi lodawa, odaa ja lodawa eledi iwaalo, niɡ̶ini ja doɡ̶olaɡ̶ataka. Codaa ɡ̶oneleegiwa ane lodawa naɡ̶ana baanaɡ̶a dalataɡ̶a jaɡ̶aɡ̶a doɡ̶olaɡ̶ataka. Niɡ̶ina ɡ̶oneleegiwa idoka yakadi me yaladi naɡ̶ana lodawa niɡ̶ina nige doɡ̶olaɡ̶ataka naɡ̶ani iwaalo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Niɡ̶ijo anodiotibece Jesus moditalo, “Nige niɡ̶idaaɡ̶ee, dice daɡ̶axa mele niɡ̶ina ɡ̶oneleegiwa me daɡ̶a wado.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naɡ̶a igidi Jesus, meetediogi, “Aɡ̶inatawece oko oyakadi modibatege niɡ̶ida iiɡ̶axinaɡ̶aneɡ̶egi aneetece nadoneɡ̶egi. Aneotedoɡ̶oji yajigotediogi niɡ̶ida niiɡ̶axinaɡ̶aneɡ̶egi inokina niɡ̶ina ane yakadi modibatege niɡ̶ida niiɡ̶axinaɡ̶aneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Igaataɡ̶a initibece ɡ̶oneleegiwa awado leeɡ̶odi ida ane ibeyacaɡ̶adi. Inoatecibece ɡ̶oneleegiwadi aɡ̶ica lionigi, leeɡ̶odi mina lakatigi. Pida jiɡ̶inatibece eledi aɡ̶ica lionigi leeɡ̶odi me noɡ̶aligijedi. Pida inatecibece eledi mina aɡ̶oyemaa me nadonaɡ̶a oditaɡ̶a eniododipi, leeɡ̶odi moyemaa mowo libakedi Aneotedoɡ̶oji, moyatematitibece anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko. Ane yakadi me dibatege niɡ̶ida iiɡ̶axinaɡ̶aneɡ̶egi, ele me dibatege!” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Niɡ̶idiaaɡ̶idi joɡ̶oyadeegitalo Jesus ica nigaanigipawaanigi me ipeketedeloco libaaɡ̶atedi me dipokotedeloco me ibinietediogi Aneotedoɡ̶oji. Pida niɡ̶ijo anodiotibece oyapeteɡ̶e niɡ̶ijo anonadeegi nigaanigipawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Odaa Jesus jeɡ̶eetediogi, “Ikani menagitibeci meetaɡ̶a niɡ̶inoda nigaanigipawaanigi, jinoɡ̶oliitege menagitibeci meetaɡ̶a, igaataɡ̶a Aneotedoɡ̶oji iiɡ̶e laaleɡ̶enali niɡ̶ina oko ane liciagi nigaanigawaanigi me diniwikodetibece.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Odaa Jesus ja ipeketedeloco libaaɡ̶atedi niɡ̶ijo nigaanigipawaanigi me dipokotedibigimece Aneotedoɡ̶oji me ibinietediogi. Odaa niɡ̶idiaaɡ̶idi joɡ̶opi. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ica lioneeɡ̶a enotalo Jesus, odaa ja ige, meetalo, “Ǥoniiɡ̶axinoɡ̶odi anele, amiida ica ane leeditibige me jao, odaa jiɡ̶idaa yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Odaa Jesus jeɡ̶eete, “Igame leeɡ̶odi ina menitiwa me Ee ele? Iniokeleteda Aneotedoɡ̶oji. Pida nigemaani mida ɡ̶adewiɡ̶a ane diɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji, oteteni liiɡ̶enatakaneɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niɡ̶ijo lioneeɡ̶a meetalo, “Amiicoa icoa liiɡ̶enatakaneɡ̶eco ane leeditibige me jotete?” Odaa meeteta Jesus, “Jineɡ̶eloati oko, jinaɡ̶a aɡ̶olaɡ̶atakani, jinoɡ̶olice, jinaɡ̶a awitaka deɡ̶eni eledi oko mowo ane beyagi! ");
INSERT INTO kbcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Eemiteetibige ɡ̶adiodi, aniaa ɡ̶adiodo, codaa leeditibige memaani eledi oko digo aneni madinemaani.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Odaa niɡ̶ijo lioneeɡ̶a ja igidi, meetalo, “Idioka limedi me jeemitetibige ijoatawece niɡ̶ijoa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji. Amaleeɡ̶ida ane leeditibige me jao?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Odaa jeɡ̶eeteta Jesus, “Nigemaani me diɡ̶ica ɡ̶abatiigi, emii, aani idiwatawece ane ɡ̶anepilidi, odaa edianitece ɡ̶aninyeelo niɡ̶inoa madewetedi, amaleeɡ̶aɡ̶a yajigotedaɡ̶awa Aneotedoɡ̶oji owidi ɡ̶aniliicaɡ̶ajetecidi digoida ditibigimedi. Odaaɡ̶anagi, aniwitici!” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Niɡ̶ijo lioneeɡ̶a naɡ̶a wajipatalo Jesus lotaɡ̶a, odaa joɡ̶opi, eliodi magecaɡ̶alo, leeɡ̶odi me liico laxokegi, owidi niɡ̶icoa ane nepilidi niliicaɡ̶ajetecidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Odaa Jesus jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Daɡ̶axa me dakake niɡ̶ina liico me ikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Niɡ̶ina liico dakaketibige me ikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena, eneɡ̶egi diɡ̶ica laɡ̶aliigi me jixomaɡ̶atiwece niɡ̶ina gameelo catiwedi niɡ̶ina etakado libegi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Niɡ̶ijo noɡ̶owajipatalo niɡ̶ijo anodiotibece, eliodi moyopo, odaa modi, “Enice, amiijo ica anepaɡ̶a yakadi mida lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Naɡ̶a iwitediogi Jesus, odaa meetediogi, “Niɡ̶ina oko aɡ̶ica nimaweneɡ̶egi deɡ̶eo mida lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. Pida Aneotedoɡ̶oji baɡ̶a yakadi meote inoatawece.” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Odaa Pedro meetalo, “Niɡ̶ida moko ja jikanaɡ̶atedice ijoatawece ane ɡ̶onepilidi, odaa ja jiwaɡ̶atibigaɡ̶adici. Odaa, amigini ica ɡ̶onoɡ̶eedi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Odaa Jesus jeɡ̶eetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, icota me jiiɡ̶e inatawece oko jatikata Aneotedoɡ̶oji loniciwaɡ̶a niɡ̶ica noko nige yoe gela iiɡ̶o. Nige jiiɡ̶enataka, jajigotaɡ̶awa ɡ̶anaɡ̶atetigitiwaji, akaami dooze ɡ̶oneleegiwadi, ananiwitici. Odaa jiɡ̶iiɡ̶enitiwaji niɡ̶ijoa dooze licoɡ̶eco Israel. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Codaa inatawece niɡ̶ina anoyaladi liɡ̶elatedi, nioxoadipi, niwaalepodi, eliodi, eliodo, lodawa, lionigipi, codaa me niiɡ̶otedi, codaa anoyaladi inoatawece, Ee leeɡ̶odi, Aneotedoɡ̶oji yajigotediogi caticedi niɡ̶ijoa anoyaladi. Codaa jiɡ̶ida lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Codaa eliodi oko niɡ̶ina ane ɡ̶oneɡ̶egipi niɡ̶inoa nokododi, jiɡ̶idiaa onaxaceti liboonaɡ̶adi. Pida eliodi ane diɡ̶ica naɡ̶atetigi niɡ̶inoa nokododi, niɡ̶idi baaniɡ̶idiaa leegitibigimece liboonaɡ̶atedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Odaa Jesus jeɡ̶ee, “Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, digawini anodaaɡ̶ee. Onica ica ane nebi icoa nawodigijedi uuva. One opedi me noditice, igo doletibige liimetedi me nibaaɡ̶a midi lixoɡ̶otagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Onicoa icoa ɡ̶oneleegiwadi ane dinilakidetege me yedia onaniteci beexo ane loojedi onidateci noko me jibaaɡ̶a. Odaa ja iiɡ̶eticogi midi lixoɡ̶otagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Noɡ̶one noove lakata joniɡ̶igotace niɡ̶ica ane lotokaɡ̶adi ɡ̶oneleegiwadi anodoletibige libakedi. Naɡ̶a nadi icoa ɡ̶oneleegiwadi ane diɡ̶ica libakedi, ");
INSERT INTO kbcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","odaa meetiogi, ‘Emiitiwaji abaa midiwa yawodigijedi uuva, odaa ɡ̶adedianitiwaji ɡ̶adoojedi ane iɡ̶enaɡ̶a.’ Odaa jiɡ̶igotibeci. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Naɡ̶a yaxoɡ̶o-noko jiɡ̶igotace, codaa naɡ̶a iniwatadaɡ̶ani lakata me ɡ̶ocidi, jiɡ̶igotace, odaa jiɡ̶icotiogi eletidi ɡ̶oneleegiwadi anoyemaa me nibaaɡ̶a. Odaa jaɡ̶aɡ̶a iiɡ̶etibigiwaji me nibaaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Niɡ̶ijo naɡ̶a nipegi me ciinco lakata, jiɡ̶igotace niɡ̶ijo ane yakadite liimetedi. Odaa jiɡ̶icotiogi eletidi ɡ̶oneleegiwadi anidiaaɡ̶iticoace niɡ̶ijo anei. Odaa ja nigetiniwace, meetiogi, ‘Igaamee ina minaaɡ̶onitetiwaji idatawece noko me diɡ̶ica ɡ̶abakedi?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Odaa joɡ̶oigidi, modita, ‘Inaaɡ̶ejonaɡ̶a digoina leeɡ̶odi aɡ̶ica ane najigotoɡ̶owa ɡ̶obakedi.’ Odaa meetiogi, ‘Emiitiwaji midiwa yawodigijedi, odaa ɡ̶adedianitiwaji ane iɡ̶enaɡ̶a me ɡ̶adoojedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Niɡ̶ijo naɡ̶a nexogotini, niɡ̶ijo ane nepilidi niɡ̶ijoa uuva jeɡ̶enidita niɡ̶ijo ane dowediteloco niɡ̶ijoa elanigijedi, odaa jeɡ̶eeta, ‘Aniditiogi iimetedipi, odaaɡ̶anedianitiniwace. Odoejegi manedianitiniwace niɡ̶ijo anowidijedipi me nibaaɡ̶a, odaa owidijeeni manedianiti niɡ̶ijo anodoejedipi me nibaaɡ̶a.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ijoatawece niɡ̶ijoa ɡ̶oneleegiwadi ane nibaaɡ̶a niɡ̶ijo naɡ̶a nipegi me ciinco lakata me ɡ̶ocidi, odibatege onaniteci beexo loojedi me nibaaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Odaa niɡ̶ijo anepaɡ̶a opeditibigiwaji me nibaaɡ̶a odiletibige doɡ̶odibatege caticedi. Pida ijotawece odibatege onaniteci beexo ane ligegitege niɡ̶ijo necalailegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Niɡ̶ijo noɡ̶odibatege ninyeelo, odaa ja notaɡ̶anaɡ̶ateloco oyalomeɡ̶e niɡ̶ijo necalailegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Modita, ‘Niɡ̶idiwa ɡ̶oneleegiwadi nibaaɡ̶a onexaa onaniteci lakata. Pida oko baɡ̶a jibaaɡ̶a idatawece noko idinatiiɡ̶ata dapicaɡ̶aligeɡ̶e. Pida mediani ɡ̶odiwokodaɡ̶awepodi ane liwokodi ɡ̶oninyeelo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Odaa niɡ̶ijo necalailegi ja igidi, meetiogi, ‘Yokaaɡ̶etedipi, aɡ̶ica daɡ̶a jaotaɡ̶adomi ane beyagi. Madinilakidenitigi jiɡ̶idaa liwokodi memaani mabaatege onaniteci beexo loojedi onidateci noko mabaa. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Natigide, abaatege ɡ̶aninyeelo odaaɡ̶opiliticogi ɡ̶adiɡ̶eladi. Emaɡ̶a jemaa me jajigotiogi niɡ̶ijo owidijegi menotibeci me liwokodaɡ̶awa ane jajigotaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Domige jakadi me jao ane jemaa mejigotalo ininyeelo? Oɡ̶oa, anoceetema ina eledi oko ane jemaa me ee libinienigitema?’” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Odaa Jesus nigoditedini me dotaɡ̶a niɡ̶ijo neɡ̶ee, “Joaniɡ̶idaaɡ̶ee niɡ̶ina anowidijedipi jiɡ̶idiaa odoejegi, odaa niɡ̶ina anodoejedipi jiɡ̶idiaa owidijedipi. Igaataɡ̶a Aneotedoɡ̶oji eniditediogi eliodi oko, pida onateciɡ̶idi ane iolatedicoace.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Niɡ̶ijo Jesus naɡ̶a dowicetedibigimece nigotaɡ̶a Jerusalém, noɡ̶atedicoace niɡ̶ijo dooze anodiotibece, odaa eɡ̶idaaɡ̶ee mewaligitibigiwaji, neɡ̶eetediogi Jesus, ");
INSERT INTO kbcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Diganajipaatiwatiwaji! Ja jiiɡ̶ata Jerusalém. Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, etidajigotiogi anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odaa modi mone jao ane beyagi, codaa me leeditibige metideloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Codaa metidajigotiogi lacilodi romaanotedi. Odaa metidame, codaa metidalaketibige, codaa etidototeloco nicenaɡ̶anaɡ̶ate. Pida nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi me ideleo, odaa Aneotedoɡ̶oji jeɡ̶eote me idewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Odaa aca lodawa Zebedeu jiɡ̶igo midoataɡ̶a Jesus lixigaɡ̶awadi niɡ̶ijoa itoa lionaɡ̶a, Tiago ijaa João. Odaa ja yamaɡ̶atedini lokotidi lodoe Jesus, odaa ja dipokotalo meote niɡ̶ica liwikodenatakaneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus naɡ̶a ige, meeteta, “Amiinoda ica anemaani?” Odaa ja igidi, meetalo, “Awiita niɡ̶inoda ionigipi me nicote ɡ̶awai, oniniteci ɡ̶aba-aaɡ̶adi, iniaaɡ̶eledi deɡ̶e-eetege ɡ̶animagijegi mikeeni me ɡ̶oneɡ̶aɡ̶a, nigo-oota ma-aami inionigi-eliodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pida Jesus ja igidi, meetediogi, “Aɡ̶owooɡ̶otitiwaji niɡ̶ica anipokitibige. Domigakatitiwaji mawikodee digo aneji nige jawikode?” Odaa joɡ̶oniniɡ̶odi, moditalo Jesus, “Oko jiboɡ̶atege me jawikodeeɡ̶a niɡ̶ica aneni mawikodee.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Odaa Jesus jeɡ̶eetediogi, “Ewi makati mawikodeetiwaji, niɡ̶ica aneji me jawikode. Pida aɡ̶ica inaɡ̶atetigi daɡ̶a jakadi mejitaɡ̶awa manicootini ibaaɡ̶adi iniaaɡ̶eledi diɡ̶etege inimagijegi. Pida Eiodi ilakidetedini niɡ̶idiwa nimetiidi, baaniɡ̶iniaa yowooɡ̶odi niɡ̶ica ane nicoteloco.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Niɡ̶ijo eledi anodiotibece noɡ̶owajipata ane domoɡ̶oyemaa niɡ̶ijo dinioxomigi, odaa joɡ̶oyelatema. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Odaa Jesus jeɡ̶eniditediogi niɡ̶ijo anodiotibece menagitibeci midoataɡ̶a, odaa meetediogi, “Owooɡ̶otitiwaji anodaaɡ̶ee niɡ̶ina inionigi-eliodi me dakake ane igotiogi niɡ̶idi loiigi ane iiɡ̶e. Codaa owooɡ̶oti anodaaɡ̶ee moibake naɡ̶atetigi niɡ̶inoa ɡ̶odacilodipi moiiɡ̶e eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Niɡ̶ida makaamitiwaji jinaɡ̶a domaɡ̶awii liciagi anowote niɡ̶ina ane niiɡ̶enatakanaɡ̶a. Pida niɡ̶ina ane yemaa me ɡ̶oneɡ̶egi leeditibige me niɡ̶iwatece eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Codaa niɡ̶ina ane yemaa me dibata odoejegi nimedi leeditibige moiwotage niɡ̶ina eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Awii liciagi Ee. Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ajanagi daɡ̶a jiotage oko. Pida janagi me Ee niotagi, codaa me jajigo yewiɡ̶a me loojedi ane yemaa Aneotedoɡ̶oji me napitaɡ̶adi libeyaceɡ̶eco eliodi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus ijaaɡ̶ijo anodiotibece ja noditicoaci nigotaɡ̶a Jericó. Odaa eliodi ica noiigi anodiotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Onidiwa icoa iniwataale ɡ̶oladi onicotinece naigi liniogotibece. Noɡ̶owajipatibece modi me Jesus niɡ̶ijo ane ixomaɡ̶atijo, odaa ja napaawaɡ̶a, modi, “Ǥoniotagodi, anida anenitege licoɡ̶egi Davi, ɡ̶odiwikodeneɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Odaa niɡ̶ijo noiigi-nelegi joɡ̶onapeteɡ̶etiniwace, oiiɡ̶e me notokotiniwace. Pida jeɡ̶epaanaɡ̶a dinigetaɡ̶ateetibigiwaji me napaawaɡ̶a, modi, “Ǥoniotagodi, ɡ̶odiwikodeneɡ̶egi, anida anenitege licoɡ̶egi Davi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Naɡ̶a dabiditedi Jesus, odaa jeɡ̶eniditediogi niɡ̶ijoa ɡ̶oladi. Odaa ja nigetediniwace, meetediogi, “Amiini ica anemaanitiwaji me jaotaɡ̶adomi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Odaa joɡ̶oigidi, moditalo, “Ǥoniotagodi, jemaanaɡ̶a mawii me jatenaɡ̶atibece.” ");
INSERT INTO kbcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus iwikodetediogi, naɡ̶a dibatedeloco ligecooɡ̶eli, odaa aɡ̶ica daɡ̶a leegi joɡ̶oyakadi me doletibigiwaji, odaa joɡ̶odiotece. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Niɡ̶ijo Jesus ijaaɡ̶ijo anodiotibece noɡ̶odipegita nigotaɡ̶a Jerusalém, joɡ̶otota neɡ̶epaa nigotakawaana Betfagé, anipegitege lojotaɡ̶adi ane liboonaɡ̶adi “Oliveira”. Joaniɡ̶idiaaɡ̶i Jesus naɡ̶a iiɡ̶e itoataale niɡ̶ijo anodiotibece migotibeci odoe. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Meetediogi, “Emiitiwaji manitaɡ̶a nigotakawaana digoida ɡ̶ododoe, odaa maleekokakaatio jaɡ̶aniaa boliico dinigoetini, iniaaɡ̶ini boliicawaanigi manitaɡ̶a. Owileceni, odaa anadeegitediwa! ");
INSERT INTO kbcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Odaa nigica ane ɡ̶adige ane leeɡ̶odi mowileceni naɡ̶ani boliico, enitatiwaji, ‘Ǥoniotagodi yopotedibige. Aleegi odaa nopilaɡ̶aditedaɡ̶awatiwaji.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Niɡ̶ida anee eotibige micotece lotaɡ̶a niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, niɡ̶ijo neɡ̶ee, ");
INSERT INTO kbcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Enitiogi niɡ̶idi niɡ̶eladimigipitigi Jerusalém, ‘Digawinitegetiwaji! Ǥaninionigi-eliodi jeɡ̶enotedaɡ̶awatiwaji. Okaaɡ̶egi, codaa waxoditedeloco niɡ̶inoda boliicawaanigi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Odaa niɡ̶ijo itoataale anodiotibece jiɡ̶igotibeci, odaa joɡ̶owo niɡ̶ijo ane iiɡ̶ete Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Joɡ̶onadeegi niɡ̶ijo boliicawaanigi ajaaɡ̶ajo eliodo, odaa joɡ̶oyexaɡ̶ateloco nicaapatedi, odaa Jesus ja waxoditedeloco. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eliodi oko oipecetedice nicaapatedi niɡ̶ijo naigitece, inatecibece boɡ̶onakagidi niale laamotiidi, odaa oilaagaɡ̶aditedinece naigi moiweniɡ̶ide Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Eliodi oko igotibeci lodoe, codaa eliodi eledi oko boɡ̶odilokotelogo, odaa ijotawece napaawaɡ̶ateloco, modi, “Jemaanaɡ̶a Aneotedoɡ̶oji me iweniɡ̶ide Niɡ̶inoa anida aneetetege licoɡ̶egi Davi! Jemaanaɡ̶a Aneotedoɡ̶oji me ibinie Niɡ̶inoa anenagi anida naɡ̶atetigi me Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji! Joɡ̶eeɡ̶atibigimece Aneotedoɡ̶oji!” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Niɡ̶ijo Jesus naɡ̶a dakatediwece nigotaɡ̶a Jerusalém, eliodi niɡ̶eladimigipi itaɡ̶atibigiwaji, dinigetiwage, modi, “Amiiniwa icoa ɡ̶oneleegiwa?” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Odaa niɡ̶ijo noiigi-nelegi anijo mijoataɡ̶a Jesus joɡ̶oniniɡ̶odi, modi, “Niɡ̶iniwa joaniɡ̶iniaaɡ̶iniwa Niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, Jesus, anelatedibige nigotaɡ̶a Nazaré midi nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus naɡ̶a dakatediwece Aneotedoɡ̶oji liɡ̶eladi, ja niticoitedicoace ijotawece niɡ̶ijo ane enaanaɡ̶anaɡ̶a ijaaɡ̶ijo ane oojeteeɡ̶a. Odaa yamaɡ̶atedini nameejatedi niɡ̶ijo anoiikoaɡ̶e dinyeelo, codaa me nibaancotedi niɡ̶ijo anoyaa yotipitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Odaa meetediogi, “Maditaɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji, iwoteloco ane ligegi, niɡ̶ijo neɡ̶ee, ‘Idokoyatigi iɡ̶eladi me diimigi anei oko modoɡ̶etetibigimece Aneotedoɡ̶oji.’ Pida akamaɡ̶akaamitiwaji baɡ̶ademii micataɡ̶a daɡ̶a naɡ̶ataɡ̶adi olicaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Niɡ̶idiaaɡ̶idi icoa ɡ̶oladi icaaɡ̶icoa alejaadotedi enagitibeci midoa Jesus minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, odaa ja nicilatiditediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pida niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, eliodi me neliɡ̶ideeɡ̶a, noɡ̶onadi niɡ̶ijoa ɡ̶odoxiceɡ̶etedi Jesus aneote, codaa noɡ̶owajipatiogi nigaanigipawaanigi me napaawaɡ̶ateloco mini Aneotedoɡ̶oji liɡ̶eladi, modi, “Jemaanaɡ̶a Aneotedoɡ̶oji me iweniɡ̶ide Niɡ̶iniwa anida aneetetege licoɡ̶egi Davi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Odaa moditalo Jesus, “Ida makaami ajipaata ida ligegi idi nigaanigipawaanigi?” Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Ja jajipatiogi. Pida ajawienataka naɡ̶alomeɡ̶enitelocotiwaji ane diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, miditaɡ̶a niɡ̶ijo anee, ‘Aneotedoɡ̶oji ja niiɡ̶axitediniwace lionekadawaanaɡ̶a inaa nigaanigipawaanigi anodaaɡ̶ee me joɡ̶eeɡ̶atibigimece Aneotedoɡ̶oji ane eneɡ̶egi ele mejinaɡ̶a me joɡ̶eeɡ̶atibigimece.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Odaa Jesus ja yototedicoace, ja noditedice Jerusalém, jiɡ̶igo nigotakawaana Betânia. Odaa jiɡ̶idiaa limedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Neɡ̶eledi noko me nigoitijo, Jesus joɡ̶opitacedicogi Jerusalém, odaa ja nigicile. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naɡ̶a nadi ajo libatadi “fiigoigo” liniogotibece naigi, odaa ja diiteta. Pida aɡ̶aca yakadi ela, inokinoa laamotiidi. Odaa meeteta naɡ̶ajo niale, “Aɡ̶aleeɡ̶akati majici fiigo!” Odaa aɡ̶ica daɡ̶a leegi naɡ̶ajo fiigoigo ja yadilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Niɡ̶ijo noɡ̶onadi niɡ̶ijo anodiotibece niɡ̶ijo niciagi, odaa eliodi moyopo, modi me notaɡ̶anaɡ̶a, “Niɡ̶ica meo me yediiɡ̶a me yadilo naɡ̶ada niale!” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus ja niniɡ̶odi, meetediogi, “Ejitaɡ̶awatiwaji anewi. Niganakatonitetiwaji Aneotedoɡ̶oji, codaa nige daɡ̶awienatakani, yakadi mawii liciagi niɡ̶ida anejigota naɡ̶ada fiigoigo, codaa yakadi mawii caticeditace ane jao. Yakadi menitatiwaji naɡ̶adi wetiɡ̶a, ‘Alatii, emii adinokolenitinigi akiidi-eliodi!’ Odaa naɡ̶adi wetiɡ̶a jaɡ̶alatí. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Niganakatonitetiwaji Aneotedoɡ̶oji, yakadi mabaategetiwaji okanicodaaɡ̶ica niɡ̶ica anipokitalo Aneotedoɡ̶oji niɡ̶ina motaɡ̶aneɡ̶eni.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus joɡ̶opitacedicogi minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, odaa ja niiɡ̶axitediniwace ica noiigi. Niɡ̶ijo naɡ̶a diiɡ̶axinaɡ̶a, jiɡ̶igotibeci midoataɡ̶a niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa laxokodi lacilodi niɡ̶idi noiigi. Odaa joɡ̶oige Jesus, moditalo, “Amiida ica ɡ̶anaɡ̶atetigi mawiite inoa ane ɡ̶adoenataka? Amiijo ica ane yajigotaɡ̶awa ɡ̶anaɡ̶atetigi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Ee aaɡ̶aɡ̶a ida igikaneɡ̶egi. Nigadigititiwaji, odaa jaɡ̶aɡ̶a jeloɡ̶oditaɡ̶awa ane najigotiwa inaɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Enice, amiijo ica ane yajigota naɡ̶atetigi João Batista me nilegetiniwace oko? Mige Aneotedoɡ̶oji, oɡ̶oa, domige oko oyajigota naɡ̶atetigi?” Odaa joɡ̶odinotaɡ̶aneɡ̶etigi, modi, “Nigejinaɡ̶a me Aneotedoɡ̶oji ane yajigote naɡ̶atetigi João, odaa jeɡ̶eetedoɡ̶owa, ‘Enice, igaamee ina me diɡ̶iwaɡ̶atiteda lotaɡ̶a João?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pida deɡ̶ejinaɡ̶a, ‘Me ɡ̶oneleegiwadi oyajigota naɡ̶atetigi João.’ Odaa niɡ̶ina noiigi joɡ̶oyelatoɡ̶odomi, igaataɡ̶a oyiwaɡ̶adi me Aneotedoɡ̶oji niiɡ̶e João me nilegetiniwace oko, odaa geme idoiiɡ̶atiogi niɡ̶idi noiigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Noɡ̶oniniɡ̶odi Jesus, moditalo, “Ajowooɡ̶otaɡ̶a ane yajigota naɡ̶atetigi João.” Odaa Jesus meetediogi, “Enice Ee ajeloɡ̶oditaɡ̶awatiwaji ane najigotiwa inaɡ̶atetigi me jaote niɡ̶inoa yoenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pida amiida ica anakatitecetiwaji? Ica ɡ̶oneleegiwa onidiwa iniwataale lionaɡ̶a. One diita niɡ̶ica lionigi boɡ̶oxiiɡ̶odi, odaa oneeta, ‘Ionigi, niɡ̶ina noko emii abaa midiwa eyanigijedi uuva!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naɡ̶a igidi, meeta, ‘Ee aɡ̶ejigo.’ Pida niɡ̶idiaaɡ̶idi ja dinilaatibece, naɡ̶a iigi lowoogo, odaa jiɡ̶igo diba. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niɡ̶ijo eliodi jaɡ̶aɡ̶a diita niɡ̶ijo eledi lionigi, jaɡ̶aɡ̶a iiɡ̶e migo diba. Odaa jeɡ̶eeta eliodi, ‘Je iniotagodi! Jeɡ̶ejigo.’ Pida aɡ̶igo. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Amepidiɡ̶ica ijoa lionaɡ̶a eo ane yemaa eliodi?” Odaa niɡ̶ijoa lacilodi noiigi joɡ̶oniniɡ̶odi, moditalo, “Niɡ̶ijo lionigi liidaɡ̶a.” Odaa Jesus meetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aneotedoɡ̶oji dibatetege codaa me iiɡ̶e laaleɡ̶enali niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, inaa ewocomigipi, niɡ̶ina oko anakatitiwaji meliodi me abeyacaɡ̶aɡ̶a, pida Aneotedoɡ̶oji baadaɡ̶a iiɡ̶eteda ɡ̶adaaleɡ̶enalitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Igaataɡ̶a João Batista enagi, odaa ikee niɡ̶ica anodaaɡ̶ee me ejoɡ̶otalo Aneotedoɡ̶oji, pida niɡ̶ida makaamitiwaji aɡ̶iwaɡ̶ati lotaɡ̶a João. Pida niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi ijaaɡ̶ijoa ewocomigipi boɡ̶oyiwaɡ̶adi. Pida niɡ̶ida makaamitiwaji, naɡ̶anati me eniwaɡ̶atakanaɡ̶a codaa modiotece Aneotedoɡ̶oji, idokee aɡ̶adinilaanitibecetiwaji, oteɡ̶exaaɡ̶aɡ̶a iwaɡ̶ati João.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus eɡ̶idaaɡ̶ee me dotaɡ̶a, meetediogi, “Digajipaatatiwaji niɡ̶ida eledi natematigo anida ane jiciaceeketege! Onini ica ane nebi icoa iiɡ̶otedi aneyatelogo elanigijedi uuva, odaa ja niotaa. Codaa jonaɡ̶a iwila aca nalice lajo monoɡ̶a uuva liwagedi, codaa dabiteɡ̶etini lipe libeoɡ̶adi ica anoyowie elanigijedi. Niɡ̶idiaaɡ̶idi ja yajigotiogi me niwaiɡ̶awepodi icoa nawodaɡ̶anadi niɡ̶ijoa elanigijedi. Odaa ja diniwiaje. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Naɡ̶a nipegi monopilaɡ̶aditedio elali, odaa ja iiɡ̶e icoa liotaka, iiɡ̶etiogi niɡ̶ijoa nawodaɡ̶anadi modibatege niɡ̶ica liwai ane nebi. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pida niɡ̶ijoa nawodaɡ̶anadi joɡ̶odibatiogi niɡ̶ijoa liotaka. Onica ica ononaxacoɡ̶otibige, ica eledi boɡ̶odaa oyeloadi, ica eledi boɡ̶onexaa onigidatice. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Odaa niɡ̶ica ane nepilidi enanigijedi ja iiɡ̶e eletidi liotaka, pida niɡ̶ijoa nawodaɡ̶anadi owo liciagi anodigotiogi niɡ̶ijoa odoejedipi ane iiɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Noɡ̶owidijegi ja iiɡ̶e ica epaa lionigi, meetibige le, ‘Ejime odeemitetibige ionigi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pida niɡ̶ijoa nawodaɡ̶anadi noɡ̶onaditege niɡ̶ijo lionigi, odaa modi me dinotaɡ̶aneɡ̶e, ‘Niɡ̶ina anenagi niɡ̶ijo lionigi anicota me nepilidi niɡ̶inoa nawodigijedi eliodaɡ̶ajetecidi. Ele me jeloataɡ̶a, odaa niɡ̶inoa nawodigijedi ja ɡ̶onepilidi!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Odaa joɡ̶odibata niɡ̶ijo lionigi ane nepilidi nawodigijedi, odaa joɡ̶oyadeegiticogi wetice niɡ̶idiwa nawodigijedi, odaa joɡ̶oyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nige limedi menagi niɡ̶ijo ane nepilidi nawodigijedi, amigida ica anigotiogi idiwa nawodaɡ̶anadi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Noɡ̶oniniɡ̶odi Jesus, moditalo, “Eo meliodi me nawikodeeɡ̶a codaa nigodi niɡ̶ijoa ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a. Odaa yadilaɡ̶aneɡ̶eta lawodigijedi eletidi nawodaɡ̶anadi, anepaɡ̶a oyopilaɡ̶adita niwai anida aneetege nigicota noko monopilaɡ̶aditedio.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Odaa meetediogi Jesus, “Ajawienataka naɡ̶alomeɡ̶enitelocotiwaji maditaɡ̶a Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, niɡ̶ijo anee, ‘Naɡ̶ajo wetiɡ̶a ane diɡ̶ica mowo niɡ̶ijo anodabiteɡ̶etini diimigi, naɡ̶ani wetiɡ̶a jiɡ̶icota me naɡ̶aca ane eneɡ̶egi oyopotibige. Pida Ǥoniotagodi Aneotedoɡ̶oji mina igote, codaa jakataɡ̶a mele niɡ̶ida loenatagi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Joaniɡ̶idaa leeɡ̶odi mejitaɡ̶awatiwaji Aneotedoɡ̶oji me daɡ̶adiaa iiɡ̶e ɡ̶adaaleɡ̶enali, pida ja iiɡ̶e laaleɡ̶enali eledi oko anepaɡ̶a oyoe niɡ̶ica ane yemaa Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nigica oko aneniteloco naɡ̶ani wetiɡ̶a, odaa ja napeegitibige, eote liwailidawaanaɡ̶a. Pida naɡ̶ani wetiɡ̶a niganipaɡ̶a eniteloco oko, iopaaɡ̶adi codaa yeloadi niɡ̶ica oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa fariseutedi noɡ̶owajipatalo niɡ̶ijoa natematiko anida ane iciaceeketege Jesus meyatemati, odaa joɡ̶oyowooɡ̶odi niɡ̶idiaaɡ̶eetediogi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Odaa ja domoɡ̶oyemaa moniwilo Jesus, pida aɡ̶ica nimaweneɡ̶egi leeɡ̶odi odoitiogi niɡ̶ijo noiigi, igaataɡ̶a niɡ̶ijo noiigi oyakadi Jesus miniɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus yatemati eledi natematigo anida ane iciaceeketetege me dotaɡ̶a lodoe niɡ̶ijo ane niiɡ̶enatakanaɡ̶a, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko, jiciaceeketege niɡ̶ina inionigi-eliodi ane ilakidetini nalokegi ladoneɡ̶egi lionigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Odaa ja iiɡ̶e liotaka modigotece lodenigipitema lalokegi. Pida anibetibigiwaji, aɡ̶oyemaa migotibeci nalooɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Odaa ja iiɡ̶e eletidi liotaka, meetiogi, ‘Enitiogi ɡ̶ododenigipi, “Digawinitiwaji! Nalokegi ja limedi. Joɡ̶onigodi waca-lioneke, inaa ɡ̶odinadi ajakalodi, codaa inoatawece ja igo. Anagitiwaji midi nalooɡ̶o!” ’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pida niɡ̶ijo nodenigipi aɡ̶ica mowo, odaa oninitecibeci jiɡ̶igo iwi epaa libakedi. Onica ica anigo nibajeenda, ica eledi biɡ̶igo mani noojetekaxi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Icaaɡ̶ica eledi nodenigipi baɡ̶a odibatiogi niɡ̶ijoa liotaka, odaa joɡ̶onaxacoɡ̶otiniwace, joɡ̶onigodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Niɡ̶ijo inionigi-eliodi naɡ̶a dibodiceta niɡ̶ica niciagi, eliodi me deliɡ̶ide, odaa ja iiɡ̶e niodaɡ̶awadi monigodi niɡ̶ijoa aijekaɡ̶a, codaa moyalegi nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Niɡ̶idiaaɡ̶idi meetiogi liotaka, ‘Lalokegi nadoneɡ̶egi ja igo, pida niɡ̶ijo oko yodenigipi aɡ̶aleeɡ̶oyakadi menagitibeci, leeɡ̶odi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Odaa natigide, emii iwitece ladicotiidi, odaa anodenitema nalokegi okanicodaaɡ̶ica oko anakapetege.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Odaa niɡ̶ijoa liotaka joɡ̶odioteci ladicotiidi, oyatecoɡ̶otee inatawece oko anodakapetege, inatecibece oko libinienigipi, codaa minatecibece baɡ̶a abeyaceɡ̶egipi. Odaa naɡ̶aca nalokaxi ja nolee oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pida niɡ̶ijo inionigi-eliodi naɡ̶a dakatiwece nalokaxi me iwitiogi nodenigipi, odaa ja nadi ica ɡ̶oneleegiwa ane daɡ̶a dinixotinigilo icoa nowoodi epoka lajo nalokegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Odaa niɡ̶ijo inionigi-eliodi ja ige niɡ̶ijo ɡ̶oneleegiwa, meeta, ‘Ǥodokaaɡ̶edi, igame ɡ̶animaweneɡ̶egi manakaatio me diɡ̶icoateda ɡ̶adowoodi anepaa lajo nalokegi?’ Pida aɡ̶ica aneteɡ̶eyatigi ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Odaa niɡ̶ijo inionigi-eliodi meetiogi liotaka, ‘Agoeni libaaɡ̶atedi, loɡ̶onaka, odaa okoleniticogi wetice midi nexocaɡ̶a, aneite oko me noenaɡ̶ateloco, codaa moyacigice lowe, leeɡ̶odi lawikodico.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Igaataɡ̶a Aneotedoɡ̶oji eniditediogi eliodi oko, pida onateciɡ̶idi ane iolatedicoace.” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Odaa niɡ̶ijoa fariseutedi ja noditicoaci me diniikoetiwage lowooko domoɡ̶owotibige Jesus meote ligegi ane daɡ̶a diitigi, domoɡ̶owotibige doɡ̶oyakadi me nilaagedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Odaa joɡ̶oimonyatalo Jesus niɡ̶ijo anodiotibeci fariseutedi oiwaɡ̶ateetece niɡ̶ijo ane licaajepodi inionigi-eliodi Herodes. Odaa niɡ̶ijoa niiɡ̶exedi moditalo Jesus, “Niiɡ̶axinaɡ̶anaɡ̶a, jowooɡ̶otaɡ̶a makaami oko ane iɡ̶enaɡ̶a, codaa mewi me iiɡ̶axinaɡ̶anitece niɡ̶ica Aneotedoɡ̶oji ane yemaa niɡ̶ina oko mowo. Codaa jowooɡ̶otaɡ̶a me daɡ̶a aniwinita niɡ̶ina oko migida naɡ̶atetigi, oɡ̶oa domige aɡ̶ica naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Natigide, enitoɡ̶owa niɡ̶ica anakati. Domige lakapetegi najoinaɡ̶aneɡ̶egi ɡ̶odoiigi me jedianaɡ̶atece César, ninionigi-eliodi romaanotedi, niɡ̶icoa dinyeelo ane leeditibige me jedianaɡ̶a? Domige lakapetegi ɡ̶onajoinaɡ̶aneɡ̶egi, oɡ̶oa, adakapetege?” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pida Jesus ja yowooɡ̶oditediwe lowooko ane beyagi, odaa meetediogi, “Igame leeɡ̶oditiwaji madineenitiwa? Akaamitiwaji niɡ̶ina anokowo meletibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Digawii anadeegitiwatiwaji beexo naɡ̶ana anatikani mediani romaanotedi anetiɡ̶adiiɡ̶eni mediani.” Odaa joɡ̶oyadeegitalo aca beexo. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Odaa ja nigetediniwace, meetediogi, “Ame liwigo aniwoteloco ani beexo? Codaa ame liboonaɡ̶adi ane diniditeloco ani beexo?” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Odaa joɡ̶oigidi, moditalo, “César, niɡ̶ijo ninionigi-eliodi romaanotedi.” Odaa jeɡ̶eetediogi, “Enice edianitecetiwaji César niɡ̶ica ane nebi, codaa edianitece Aneotedoɡ̶oji niɡ̶ica ane nebi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a Jesus, eliodi moyopo. Odaa joɡ̶oyakamaɡ̶adi, joɡ̶opitibeci. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ijaaɡ̶ijo niɡ̶ijo noko joɡ̶odiitalo Jesus icoa saduceutedi. Niɡ̶icoa saduceutedi baadoɡ̶oyiwaɡ̶aditeda Aneotedoɡ̶oji micota me yewikatiditace niɡ̶inoa émaɡ̶aɡ̶a anigida noko. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Odaa joɡ̶oige Jesus, moditalo, “Niiɡ̶axinaɡ̶anaɡ̶a, Moisés diiɡ̶axinaɡ̶atece nigica ɡ̶oneleegiwa ane yeleo, odaa ja nenyaɡ̶aditi lodawa, maleediɡ̶ica lionigitege, odaa nioxoa leeditibige me lodawa naɡ̶ajo wajekalo eotibige mica lionigipi. Odaa diɡ̶icoa lionaɡ̶a micataɡ̶a daɡ̶a lionigipi ijoolatibige nioxoa. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Odaa onica seete dinioxomigipi aninaa liɡ̶eladi digoina. Niɡ̶ica liidaɡ̶a jonaɡ̶a wado. Pida aona niɡ̶ica lionigi naɡ̶a yeleo. Odaa niɡ̶ijo nioxoa ja lodawa naɡ̶ajo wajekalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pida jaɡ̶aɡ̶a yeleo maleedaɡ̶aɡ̶ica lionigitege. Odaa ica eledi nioxoa jaɡ̶aɡ̶a lodawa naɡ̶ajo iwaalo. Pida idaaɡ̶ee aniɡ̶ica lionigitege naɡ̶a yeleo. Odaa ijotawece seete dinioxomigipi nigo. Ijotawece nigo maleediɡ̶ica lionigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Niɡ̶idiaaɡ̶idi naɡ̶ajo iwaalo jaɡ̶aɡ̶a yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Enice, nigicota noko Aneotedoɡ̶oji meote me newiɡ̶atace niɡ̶inoa émaɡ̶aɡ̶a, amigepidiɡ̶ica niɡ̶ijo seete dinioxomigi anepeɡ̶ewi me lodawa naɡ̶ajo iwaalo? Igaataɡ̶a ijotawece lodawadi naɡ̶ajo iwaalo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus naɡ̶a niniɡ̶odi, meetediogi, “Niɡ̶ida makaamitiwaji eliodi mabataa leeɡ̶odi aɡ̶owooɡ̶oti Aneotedoɡ̶oji lotaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a owooɡ̶oti Aneotedoɡ̶oji notoetiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Igaataɡ̶a nigeotace Aneotedoɡ̶oji me newiɡ̶atace niɡ̶inoa émaɡ̶aɡ̶a, odaa ja liciagi niɡ̶inoa niaanjotedi Aneotedoɡ̶oji. Aɡ̶alee nadonaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a icoa lionaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pida, niɡ̶ida makaamitiwaji ejiniɡ̶ica malomeɡ̶eniteloco ane ligegi Aneotedoɡ̶oji niɡ̶ijo neɡ̶eetetece me newikatiditacediniwace niɡ̶inoa émaɡ̶aɡ̶a. Mee Aneotedoɡ̶oji, ");
INSERT INTO kbcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ee Noenoɡ̶odi Abraão, codaa Ee Noenoɡ̶odi Isaque, iniaa Jacó.’ Aneotedoɡ̶oji aNoenoɡ̶odi oko émaɡ̶aɡ̶a, pida Noenoɡ̶odi oko ane newiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Niɡ̶ijo noiigi-nelegi noɡ̶owajipatalo Jesus lotaɡ̶a, eliodi moyopo leeɡ̶odi liiɡ̶axinaɡ̶aneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Niɡ̶ijo fariseutedi noɡ̶odibodicetalo Jesus me yamaketedi saduceutedi. Odaa ja dinatecoɡ̶otee. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Odaa onini mawatiogi ica ane diiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odaa jiɡ̶ijaa dineetalo Jesus, domaɡ̶a dibatalo diɡ̶ica libatiigi me dotaɡ̶a. Ige Jesus, meetalo, ");
INSERT INTO kbcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Niiɡ̶axinaɡ̶anaɡ̶a, amiida ica ɡ̶oniiɡ̶enatakaneɡ̶egi ane daɡ̶axa mida ane jaoɡ̶a ane iditini Moisés?” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Naɡ̶a niniɡ̶odi Jesus, odaa meete, “‘Emaani Ǥaniotagodi Aneotedoɡ̶oji manitawece ɡ̶adaaleɡ̶ena, midatawece niɡ̶ica ɡ̶alidekegi, codaa minitawece ɡ̶adowoogo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Joaniɡ̶idaaɡ̶ida odoejegi liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji, codaa jiɡ̶idaaɡ̶ida ane daɡ̶axa mida ane jaoɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Naɡ̶a lowidi niɡ̶ida ɡ̶oniiɡ̶enatakaneɡ̶egi, ida eledi ɡ̶oniiɡ̶enatakaneɡ̶egi ane daɡ̶axa mida ane jaoɡ̶a, liciagi niɡ̶idi odoejegi. Niɡ̶ijo anee, ‘Leeditibige memaani okanicodaaɡ̶ica oko, digo aneni madinemaani.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nigoteteni niɡ̶idoa itoataale ɡ̶oniiɡ̶enatakaneɡ̶eco, odaa joɡ̶oteteni ijoatawece eletidi ɡ̶oniiɡ̶enatakaneɡ̶eco ane iditedini Moisés, codaa me niɡ̶idiwa niiɡ̶enatakaneɡ̶eco aaɡ̶aɡ̶a oiditedini niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko.” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Niɡ̶ijo malee yatecoɡ̶o niɡ̶ijoa fariseutedi, odaa Jesus ja nigetediniwace, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Amiida ica ɡ̶adowoogotece anodaaɡ̶ee Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji me yatamaɡ̶ateetege ɡ̶odoiigi lawikodico? Amiida ica licoɡ̶egi?” Odaa joɡ̶oigidi, moditalo, “Ida aneetege licoɡ̶egi Davi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus ja nigetacediniwace, meetediogi, “Enice, igame leeɡ̶odi ina Davi meeta, ‘Iniotagodi’? Davi mee, ‘Iniotagodi’ niɡ̶ijo naɡ̶a dakatiogi Aneotedoɡ̶oji Liwigo, odaa Aneotedoɡ̶oji Liwigo eo me dotaɡ̶a. Igaataɡ̶a Davi mee me dotaɡ̶a, ");
INSERT INTO kbcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Aneotedoɡ̶oji Inoenoɡ̶odi meete Iniotagodi, “Anicooti iwai ibaaɡ̶adi nigepaaɡ̶icota me jao manigaanyetece ɡ̶aneloɡ̶ododipi.” ’ ");
INSERT INTO kbcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davi nigeyatigi me Niotagodi. Enice, igamodaaɡ̶ee Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji anida aneetege licoɡ̶egi Davi?” (Igaataɡ̶a noiigi judeu aɡ̶ica aneeta lionigi me Niotagodi.) ");
INSERT INTO kbcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Odaa aɡ̶ica ane yakadi me igidi Jesus. Codaa jiɡ̶ijaaɡ̶ijotigi niɡ̶ijo noko aɡ̶aleeɡ̶ica anabo laaleɡ̶ena me ige Jesus me dineetalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Niɡ̶idiaaɡ̶idi Jesus jeɡ̶eetediogi niɡ̶ijo noiigi-nelegi, ijaaɡ̶ijo anodiotibece, ");
INSERT INTO kbcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Niɡ̶ina anodiiɡ̶axinaɡ̶atece Moisés lajoinaɡ̶aneɡ̶eco inaaɡ̶inoa fariseutedi ida naɡ̶atetigi modiiɡ̶axinaɡ̶atece codaa moyeloɡ̶odi ane diitigilo niɡ̶inoa ane diiɡ̶enatakatalo Moisés mowote. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Enice, okanicodaaɡ̶ica anodiiɡ̶enatakata, iwaɡ̶atitiwaji codaa awii. Pida jinaɡ̶awii liciagi ane lakataɡ̶a, igaataɡ̶a odiiɡ̶enatakata moyiwaɡ̶adi ane diiɡ̶enatakata najoinaɡ̶aneɡ̶eco, pida idiaaɡ̶idi baadoɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Odiiɡ̶enatakata mowote niɡ̶inoa ane dakake me jiwaɡ̶atece, micataɡ̶a doɡ̶oyexaɡ̶ateloco leláɡ̶a oko loyaɡ̶agi ane iwaaɡ̶adi, pida aɡ̶oyaxawa moyoyaɡ̶adi, oteɡ̶exaaɡ̶aɡ̶a oyadodi! ");
INSERT INTO kbcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inoatawece anowote, owote modinikeenaɡ̶aneɡ̶etema niɡ̶ina oko. Oyexocaɡ̶aditeloco libaaɡ̶adi, codaa me latocolodi Aneotedoɡ̶oji lotaɡ̶a owotibige niɡ̶ina oko modiletibige deɡ̶eliodi moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji, codaa oyocaɡ̶atee liniogo niɡ̶inoa nijayogoli owotibige niɡ̶ina oko modiletibige diɡ̶iniɡ̶ina niiɡ̶axinaɡ̶anadi aninoa lixaketedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Niɡ̶ina me nalooɡ̶o oyemaa monicotelogo niɡ̶icoa ane daɡ̶axa mele nimetiidi, codaa me niɡ̶icoa nibaancotedi ɡ̶oneɡ̶aɡ̶a midiwataɡ̶a niiakanaɡ̶axiidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oyemaatibige niɡ̶ina oko monicetibigiwaji, codaa lemaanigi niɡ̶ina oko moikee modeemitetibige niɡ̶ina modakapetibigege, codaa oyemaatibige niɡ̶ina oko moditiogi me ‘Niiɡ̶axinaɡ̶anadi!’. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pida akaamitiwaji baɡ̶a jinaɡ̶a domiɡ̶ikani doɡ̶oditaɡ̶awa niɡ̶ina oko makaami ‘Niiɡ̶axinaɡ̶anadi’, igaataɡ̶a iniwa oniniwatece ɡ̶aniiɡ̶axinoɡ̶odi ane Cristo. Codaa akaamitawece akaami diniciamico, anakaami dinioxomigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Codaa jinaɡ̶a domiɡ̶ica anenita me ɡ̶adiodi digoina iiɡ̶o. Igaataɡ̶a oniniwatece Ǥadiodi, ane ideite ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jiniɡ̶ikani niɡ̶ina oko doɡ̶oditaɡ̶awa, ‘Iniotagodi’, igaataɡ̶a oniniwatece Ǥaniotagoditiwaji, Cristo ane niiɡ̶e Aneotedoɡ̶oji. Codaa jeɡ̶emeɡ̶ee ane niiɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pida niɡ̶ina aneneɡ̶egi ida niwaló ɡ̶adiwigotigitiwaji, jiɡ̶iniaa ɡ̶aotagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Codaa niɡ̶ina anepaa ilecatiditibigimece liboonaɡ̶adi, Aneotedoɡ̶oji icota meote me diɡ̶ica jaoɡ̶a. Pida niɡ̶ina ane diniwikodetibece, Aneotedoɡ̶oji icota meote me leegitibigimece liboonaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nagoodi akaamitiwaji, anakaami niiɡ̶axinaɡ̶anadi ane iiɡ̶axinaɡ̶anitece lajoinaɡ̶aneɡ̶eco Moisés, codaa akaami anakaami fariseutedi, anokawii makaami eletetiwaji! Igaataɡ̶a aɡ̶ikanitiwaji diɡ̶ica oko ane ikee anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena. Codaa akamaɡ̶akaamitiwaji aɡ̶emaani Aneotedoɡ̶oji daɡ̶a iiɡ̶e ɡ̶adaaleɡ̶enali, codaa aɡ̶ikani niɡ̶ina eledi oko moyowooɡ̶odi anodaaɡ̶ee Aneotedoɡ̶oji anigote, niɡ̶ina oko anodoletibige Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nagoodi akaamitiwaji, anakaami niiɡ̶axinaɡ̶anadi, codaa anakaami fariseutedi, anokawii makaami eletetiwaji! Igaataɡ̶a aniboloiteeni iwaalepodi ane wajekalodipi, odaa abanoonitece niɡ̶inoa liɡ̶elatedi, codaa olicetalo niɡ̶inoa ane nepilidi. Odaa niɡ̶idiaaɡ̶idi ocaɡ̶ateeni motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, pida mina adinikeenaɡ̶aneɡ̶eni. Joaniɡ̶idaa leeɡ̶odi Aneotedoɡ̶oji me ɡ̶adiloikatititetiwaji caticedi niɡ̶ina eledi oko ane iloikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nagoodi akaamitiwaji, anakaami niiɡ̶axinaɡ̶anadi codaa anakaami fariseutedi, anokawii makaami eletetiwaji! Igaataɡ̶a aɡ̶eetitatiwaji akiititedi-eloodoli, codaa aniwiajeetelogo owidi nipodaɡ̶a moleetibige mawii mini oko ane dioteci ɡ̶adiiɡ̶axinaɡ̶aneɡ̶eco. Odaa niɡ̶ina mini anakati mawii me diotaɡ̶adici, jiɡ̶icaaɡ̶awiitibigetiwaji Aneotedoɡ̶oji me iloikatidi niɡ̶inida oko caticedi anigotedaɡ̶awatiwaji minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nagoodi akaamitiwaji! Igaataɡ̶a ɡ̶adiciagitiwaji niɡ̶ina oko ɡ̶olaɡ̶a ane domoɡ̶odoletibige moikeeta naigi niɡ̶ina eledi ɡ̶olaɡ̶a. Meni me iiɡ̶axinaɡ̶anitiwaji, ‘Nigica aneo ligegi meo okanicodaaɡ̶ica me liboonaɡ̶adi liɡ̶eladi Aneotedoɡ̶oji, odaa aibeyacaɡ̶adi nige deɡ̶eote niɡ̶ijo ane ligegi. Pida nige ligegi meo okanicodaaɡ̶ica me liboonaɡ̶adi nioolo Aneotedoɡ̶oji liɡ̶eladi, odaa baɡ̶a leeditibige meo ane ligegi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ǥadiciagitiwaji niɡ̶ina oko yetoledi codaa me ɡ̶oladi! Amiida ica aneneɡ̶egi ida ane jaoɡ̶a, oolo ane idei Aneotedoɡ̶oji liɡ̶eladi, oɡ̶oa iniaaɡ̶ini Aneotedoɡ̶oji liɡ̶eladi aneo niɡ̶idiwa oolo anidiwa catiwedi liɡ̶eladi me nepilidi Aneotedoɡ̶oji? ");
INSERT INTO kbcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Codaa eledi meni me iiɡ̶axinaɡ̶anitecetiwaji, ‘Nigica oko aneo ligegi meo okanicodaaɡ̶ica me liboonaɡ̶adi nameeja Aneotedoɡ̶oji niɡ̶ina me dotaɡ̶a, odaa baadaɡ̶a ibeyacaɡ̶adi nige deɡ̶eo niɡ̶ijo ane ligegi. Pida niɡ̶ina nigeo ligegi me liboonaɡ̶adi niɡ̶ijo liboonigi ane idei madi nameeja Aneotedoɡ̶oji, odaa baɡ̶a leeditibige meo niɡ̶ica ane ligegi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ǥadiciagitiwaji yetoledi inaa ɡ̶oladi! Amiida ica aneneɡ̶egi ida ane jaoɡ̶a, mige ɡ̶oboonigi, oɡ̶oa, domige nameeja aneo me dibatetege Aneotedoɡ̶oji ɡ̶oboonigi? ");
INSERT INTO kbcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Enice oko aneo ligegi me liboonaɡ̶adi Aneotedoɡ̶oji nameeja niɡ̶ina me dotaɡ̶a, niɡ̶ini oko aɡ̶idokida me ibake liboonaɡ̶adi nameeja, pida aaɡ̶aɡ̶a ibake liboonaɡ̶adi okanicodaaɡ̶ica ane liboonigi madi nameeja. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Odaa niɡ̶ina oko meo ligegi me liboonaɡ̶adi Aneotedoɡ̶oji liɡ̶eladi, niɡ̶ina me dotaɡ̶a, niɡ̶ini oko aɡ̶idokida me ibake liboonaɡ̶adi Aneotedoɡ̶oji liɡ̶eladi, pida aaɡ̶aɡ̶a ibake Liboonaɡ̶adi Aneotedoɡ̶oji aniniwa catiwedi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Niɡ̶ina oko aneo ligegi me liboonaɡ̶adi niɡ̶ica ditibigimedi, niɡ̶ina me dotaɡ̶a, niɡ̶ini oko ewi me ibake liboonaɡ̶adi naɡ̶aca Aneotedoɡ̶oji nibaanco ɡ̶oneɡ̶e, codaa me Liboonaɡ̶adi Aneotedoɡ̶oji, ane nicotedeloco. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nagoodi akaamitiwaji anakaami niiɡ̶axinaɡ̶anaɡ̶atema lajoinaɡ̶aneɡ̶eco Moisés codaa anakaami fariseutedi anokawii makaami eletetiwaji! Igaataɡ̶a aboonitalo Aneotedoɡ̶oji ane nebi, codaa majici liwai niɡ̶inoa anokateciɡ̶inoa me ɡ̶anidiizimo, niɡ̶inoa niale laamotiidi ane jexakajoɡ̶otinigi niweenigi me lanigi. Pida jiɡ̶ikani me iwitece najoinaɡ̶aneɡ̶eco aneneɡ̶egi ida ane jaoɡ̶ate midiwa lajoinaɡ̶aneɡ̶eco Moisés. Niɡ̶idiwa najoinaɡ̶aneɡ̶eco onikeetoɡ̶owa anodaaɡ̶ejinaɡ̶a me jaoɡ̶a ane iɡ̶enaɡ̶a, codaa moko eletema eledi oko, codaa onikeetoɡ̶owa me leeditibige mejiwaɡ̶ataɡ̶a Aneotedoɡ̶oji. Pida domaɡ̶a leeditibige me iwitecetiwaji niɡ̶inoa najoinaɡ̶aneɡ̶eco ane daɡ̶axa mida ane jaoɡ̶ate, codaa maɡ̶aɡ̶a awiite niɡ̶inoa ane deɡ̶ewi ina mica ane jaoɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niɡ̶ida makaamitiwaji ɡ̶adiciagi niɡ̶ijo oko ɡ̶oladi anodoletibige moikeetece naigi eletidi ɡ̶oladi. Codaa ɡ̶adiciagi niɡ̶ina oko ane yaago viinyo me noɡ̶a ɡ̶onoodo, pida baɡ̶a yalitini gameelo, igaataɡ̶a adowetiteloco niɡ̶inoa anicinoa ane diɡ̶ica ane jaoɡ̶ate, pida aɡ̶oeni niɡ̶inoa anida ane jaoɡ̶ate ane niiɡ̶etedoɡ̶owa Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nagoodi akaamitiwaji anakaami niiɡ̶axinaɡ̶anadi ane iiɡ̶axinaɡ̶anitece najoinaɡ̶aneɡ̶eco, codaa makaami fariseutedi, anokawii makaami eletetiwaji! Niɡ̶ida makaamitiwaji ica ina daɡ̶a akaami eletetiwaji, ɡ̶ademaanigitiwaji mele me iwileci wetice ɡ̶anigoopa idaa ɡ̶aniginogo, pida micataɡ̶a daaditaɡ̶a iwileci le ɡ̶anigoopa idaa ɡ̶aniginogo. Codaa micataɡ̶a daɡ̶a nolee ɡ̶anigoopa idaa ɡ̶aniginogo niɡ̶ina ane ɡ̶adolicaɡ̶aditiwaji codaa akaami adodigomadadi, leeɡ̶odi aɡ̶akati madinajacaɡ̶ati. Leeditibige maɡ̶aɡ̶a iwilecitiwaji catiwedi ɡ̶adaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Anakaami fariseutedi, akaami ɡ̶oladi! Odoejeeni miwileci catiwedi akaamitiwaji, micataɡ̶a diɡ̶iwileci le ɡ̶anigoopa codaa me ɡ̶aniginogo, odaa jaɡ̶aɡ̶a yapidi wetice. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nagoodi akaamitiwaji ane iiɡ̶axinaɡ̶anitece najoinaɡ̶aneɡ̶eco, codaa anakaami fariseutedi, anokawii makaami eletetiwaji! Ǥadiciagitiwaji niɡ̶ina émeɡ̶egi libegi, ane libinienigi inokina we, leeɡ̶odi onadineɡ̶eta nadinaɡ̶ajegi ane yapacaɡ̶a niɡ̶idiwa wetiadi. Pida catiwedi niɡ̶ida begi, baɡ̶a nolee ɡ̶obitaka inaa neladaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niɡ̶ina me ɡ̶adiwineɡ̶egitiwaji ica ina daɡ̶a ɡ̶adeɡ̶enakitiwaji, pida onawiitetiwaji makaami libinienigipi, codaa ɡ̶adaaleɡ̶enali nolee niɡ̶ica ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nagoodi akaamitiwaji ane iiɡ̶axinaɡ̶anitece najoinaɡ̶aneɡ̶eco, codaa anakaami fariseutedi, anokawiitiwaji makaami eletetiwaji! Igaataɡ̶a ipekeniteloco wetiadi libinienaɡ̶a anonaligite niɡ̶ijoa émaɡ̶aɡ̶a, liotagipi Aneotedoɡ̶oji baanaɡ̶a nigo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Codaa awii ɡ̶adiwilanigitiwaji ocaɡ̶ataɡ̶a manalakitibige malee newiɡ̶a niɡ̶ijo oko ane iɡ̶enaɡ̶atibigiwaji niɡ̶ijo jotigide. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Odaa menitiwaji, ‘Daɡ̶a ɡ̶odewiɡ̶a malee newiɡ̶a ɡ̶odaamipi, agotaɡ̶a inigotaɡ̶a liotagipi Aneotedoɡ̶oji anodigotiogi ɡ̶odaamipi niɡ̶ijo liotagipi Aneotedoɡ̶oji.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Odaa niɡ̶ida anenitiwaji jiɡ̶ikeeni mida anenitege licoɡ̶egi niɡ̶ijo anonigodi Aneotedoɡ̶oji liotaka. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Odaa jaɡ̶agotitiwaji niɡ̶ijo nibakedi ane beyagi anoyojogotini ɡ̶adaamipi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ǥadiciagitiwaji niɡ̶inoa laketedi ane diniweneene. Niɡ̶ida makaamitiwaji aɡ̶aleeɡ̶ica ɡ̶animaweneɡ̶egi daɡ̶a ɡ̶adiwokoni Aneotedoɡ̶oji nige iloikatidi niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco, codaa nige limedi me imonyatedicogi minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Codaa Emeɡ̶ee jiiɡ̶eticogi makaamitaɡ̶atiwaji niɡ̶ina anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, inoa aninoa lixaketedi, inaaɡ̶ina anodiiɡ̶axinaɡ̶atece niɡ̶ica ane yemaa Aneotedoɡ̶oji mowo niɡ̶ina oko. Pida ijo ananigotitiwaji, ijo anotonitelocotiwaji nicenaɡ̶anaɡ̶ate manigoti. Ica eledi baɡ̶a analakenitiniwace catiwedi ɡ̶adiiakanaɡ̶axiiditiwaji, codaa me iatenitibece, odaa jaɡ̶awii me daleditibigimoace odeletalo eletidi nigotadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Joaniɡ̶idaa leeɡ̶odi Aneotedoɡ̶oji makaami laagetedipi leeɡ̶odi lemeɡ̶egi ijotawece niɡ̶ijo oko ane iɡ̶enaɡ̶atibigiwaji anonigodi, odoejegi moyeloadi Abel ɡ̶oneleegiwa ane iɡ̶enaɡ̶a, lionigi niɡ̶ijo odoejegi ɡ̶oneleegiwa Adão, neɡ̶epaaɡ̶otota moyeloadi Zacarias, lionigi Baraquias, naiigo ɡ̶adoiigitiwaji, anoyeli wetice Aneotedoɡ̶oji liɡ̶eladi, ipegitege Aneotedoɡ̶oji nameeja. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ejitaɡ̶awatiwaji anewi. Aneotedoɡ̶oji iloikatidi niɡ̶ina noiigi aninaa niɡ̶inoa nokododi leeɡ̶odi laijedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Eliodi me ɡ̶adigecaɡ̶aleɡ̶enitiwaji, anakaami niɡ̶eladimigipitigi Jerusalém! Leeɡ̶odi manigotitiwaji niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, codaa anigidaatiniwace manigoti niɡ̶ijo ane niiɡ̶etedaɡ̶awatiwaji Aneotedoɡ̶oji. Elioditibece me domaɡ̶a jemaa me ɡ̶adatecoɡ̶oteenitiwaji me idoweditaɡ̶aloco, macataɡ̶a naɡ̶ana okoɡ̶okoodi me yatecoɡ̶otee lionaɡ̶a catiwedi labadi, pida aɡ̶emaanitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Natigide, liɡ̶eladi Aneotedoɡ̶oji anini makaamitaɡ̶atiwaji icota moyaladi, leeɡ̶odi me diɡ̶icoateda Aneotedoɡ̶oji ane nebi. ");
INSERT INTO kbcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ejitaɡ̶awatiwaji anewi. Icota me daɡ̶adiaaɡ̶ica madatitiwaji nigepaaɡ̶icota niɡ̶ica noko nigenitiwaji, ‘Jemaanaɡ̶a Aneotedoɡ̶oji me ibinie Niɡ̶inoa anenagi anida naɡ̶atetigi Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus noditedicogi Aneotedoɡ̶oji liɡ̶eladi. Niɡ̶ijo noɡ̶opi, niɡ̶ijo anodiotibece joɡ̶odipegitege, odaa joɡ̶oyalaɡ̶ata Aneotedoɡ̶oji liɡ̶eladi me nelegi codaa me libinienigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Odaa Jesus ja niniɡ̶oditediogi, mee, “Jaɡ̶anatitiwaji niɡ̶ini diimigi libinienigi. Ejitaɡ̶awatiwaji anewi. Icota anigida noko me daɡ̶aca wetiɡ̶a ane yeyaɡ̶ateloco eledi wetiɡ̶a, leeɡ̶odi initawece oyaaɡ̶adi niɡ̶ini diimigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus idiaa nicote minitaɡ̶a lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira”. Odaa niɡ̶ijo anodiotibece joɡ̶oyatecoɡ̶otelogo, odaa joɡ̶oige, oniboloite maleediɡ̶ica eledi oko, moditalo, “Igaatigi ica nigoyojiketini Aneotedoɡ̶oji liɡ̶eladi? Codaa igamodaaɡ̶ee ica me ikee Aneotedoɡ̶oji nigadopilitijo, codaa igaatigi ica nige daa ina iiɡ̶o?” ");
INSERT INTO kbcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus ja niniɡ̶odi, meetediogi, “Adinowetitiwaji adiɡ̶ica ane ɡ̶adinaaleni. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Igaataɡ̶a eliodi oko enagitibeci, odaa oibake Iboonaɡ̶adi, codaa modi, ‘Jeɡ̶emeɡ̶ee ane niiɡ̶e Aneotedoɡ̶oji me jiɡ̶eke inatawece ɡ̶odaxakawepodi.’ Odaa joɡ̶oninaaletiniwace eliodi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Codaa jinaɡ̶aɡ̶owikomataatiwaji nigajipaata layaco witidi, codaa nigabodicetibige noiigi me nidelaɡ̶a. Igaataɡ̶a leeditibige minoa nidelakadi. Pida anaɡ̶a ipegiteloco liniogo niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Igaataɡ̶a niɡ̶ina noiigi dinideleɡ̶etiwage, codaa niɡ̶inoa inionaɡ̶a-eloodoli dinideleɡ̶etiwage. Odaa eliodi mina nigigi, codaa me neelotika ane waxodi, codaa datalale iiɡ̶o, aɡ̶icaadeɡ̶ite. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inoatawece niɡ̶inoa nawikodico liciaco odoejedi lileenaɡ̶aneɡ̶egi iwaalo me dinigaje. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nigidiaaɡ̶idi niɡ̶ina ɡ̶aneloɡ̶ododipi etiɡ̶adiwilotiwaji, odaa etiɡ̶adajicitiogi ane niiɡ̶enatakanaɡ̶a metiɡ̶adiloikatiti codaa metiɡ̶adeloati. Codaa inatawece noiigi akaami neleɡ̶etedipi leeɡ̶odi maniwiticitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Odaa eliodi oko eyamaɡ̶atice eliwaɡ̶atakaneɡ̶egi, odaa joɡ̶oyajigo niɡ̶ina anepaɡ̶alee etidadiwaɡ̶ati, oyajigotiogi neloɡ̶ododipi, odaa neleɡ̶etedipi niɡ̶ijo anoniotici. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Codaa eliodi awitakaɡ̶aɡ̶a anicota menotibeci, odaa modi moyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, odaa joɡ̶oninaaletiniwace eliodi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Odaa niɡ̶ina oko jeɡ̶epaa noɡ̶owo niɡ̶inoa ane beyagi, odaa jiɡ̶idaa leeɡ̶odi niɡ̶ina oko aɡ̶alee dinemaa. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pida niɡ̶ina ane dinatitalo inoatawece ane lawikodico, codaa ane daɡ̶a ika me idadiwaɡ̶adi, joaniɡ̶iniaa biɡ̶ida lewiɡ̶a ane diɡ̶ica liniogo meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Odaa joɡ̶oyadeegitedibece nibodicetedi anele anoditece niɡ̶ica anodaaɡ̶ee Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali oko, codaa oyatematitedibece niɡ̶inoa nibodicetedi anele. Oyatematitiogi inoatawece nipodaɡ̶a, oyeloɡ̶oditiogi noiigi me yemaa Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. Odaa jeɡ̶epaanaɡ̶a icota liniogo niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Daniel, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, mee moyojogotini ica niwigo ane ɡ̶oneleegiwadi liwilanigi minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. (Niɡ̶ina ane yalomeɡ̶eteloco niɡ̶inoa notaɡ̶a leeditibige me yowooɡ̶odi ane diitigilo.) Enice, nigicota manati niɡ̶ida niwigo minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, niɡ̶ina oko aneitelogo nipodaɡ̶a Judéia, leeditibige me daleditibige, odeletibigimece wetiadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Codaa niɡ̶ina ane anipetini ditibigimedi liɡ̶eladi, leeditibige me diɡ̶igo dakatiwece liɡ̶eladi me dibatalo ane nepilidi, pida leeditibige me dinagetice melodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Codaa niɡ̶ina ane ideitice lixoɡ̶otagi, aɡ̶ele daɡ̶a dopitijo me dibata nibalito. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nagoodoli niɡ̶ina iwaalepodi ipilaɡ̶aɡ̶a codaa niɡ̶ina baɡ̶alee oilipeɡ̶e lionigi nigicotalo niɡ̶icoa nokododi ane doide! ");
INSERT INTO kbcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipokitalotiwaji Aneotedoɡ̶oji me daɡ̶adaletitibige me limedi niwetaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a niɡ̶ina saabado. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Igaataɡ̶a niɡ̶ica nawikodigi anenagi eliodi me ɡ̶onitiɡ̶a. Aniɡ̶icoa nawikodico liciaco niɡ̶icoa anenagi, niɡ̶ijo maleekoka dinoe niɡ̶ina iiɡ̶o. Codaa aɡ̶icota micoa eletidi nawikodico liciaco niɡ̶icoa nawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aneotedoɡ̶oji noxopanatidi nokododi niɡ̶icoa nawikodico. Daaditaɡ̶a noxopanatiditeda niɡ̶icoa nokododi, agotiɡ̶ica ane dinatitalo niɡ̶icoa nawikodico. Pida leeɡ̶odi niɡ̶idi oko ane iolatedicoace me nepilidi, Aneotedoɡ̶oji noxopanatidi niɡ̶icoa nokododi niɡ̶icoa nawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nigica aneetaɡ̶awatiwaji, ‘Digawini, etidoa niɡ̶ijoa ɡ̶odacilo Aneotedoɡ̶oji ane niiɡ̶e me iɡ̶eke ɡ̶odaxakawepodi!’, oɡ̶oa, domigetaɡ̶a eetaɡ̶awa, ‘Etidoa digoida!’ Pida jinaɡ̶a domaɡ̶a iwaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Igaataɡ̶a icota mowidi anodinanatigi me ɡ̶odacilodi, codaa icota meliodi anodi miniɡ̶ina anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, pida niwitakaɡ̶a. Codaa owote ɡ̶odoxiceɡ̶etedi anoikee loniciwaɡ̶a, odoletibige moninaaletiniwace niɡ̶ina oko Aneotedoɡ̶oji ane iolatedicoace me nepilidi, odineetiogi doɡ̶oyakadi moninaaletiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Atacolitiwaji! Igaataɡ̶a jao ɡ̶abodigi maleediɡ̶icotalo niɡ̶icoa nawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Niɡ̶ina nigodi, ‘Digawinitiwaji! Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji etidoa midi nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi.’ Jinaɡ̶a domeɡ̶emii! Oɡ̶oa, domigetaɡ̶a niɡ̶ina nigodi, ‘Etiniwa dinaɡ̶aditedini digoina liɡ̶eladi’, jinaɡ̶a domaɡ̶a iwaɡ̶atitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nigicota me idinikee, micataɡ̶a niɡ̶ina nalebepaɡ̶a ane ídi digoida ditibigimedi, dalebepe digoida nigoi nigepaa ane diiticogi aligeɡ̶e me dalimeti. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Igaataɡ̶a jowooɡ̶otaɡ̶a ane diɡ̶etigi anigidi émeɡ̶egi, leeɡ̶odi opoedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nige leecawaanigi me ixomaɡ̶atedijo niɡ̶icoa nawikodico, odaa aligeɡ̶e ipe, codaa epenai aɡ̶alee datale. Yotetitedi enitedini, icoɡ̶otedibigimece ditibigimedi, odaa Aneotedoɡ̶oji ja itineɡ̶e niɡ̶ica loniciwaɡ̶a ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Odaa Aneotedoɡ̶oji jaɡ̶aɡ̶a ikee ganigica digoida ditibigimedi, ane ikee naɡ̶a limedi me dinikee niɡ̶ijoa Ǥoneleegiwa ane icoɡ̶otedibigimece ditibigimedi. Odaa inatawece oko niɡ̶ina iiɡ̶o doitibigiwaji, codaa agecaɡ̶alodipi nigonadi niɡ̶ica ane ikee Aneotedoɡ̶oji digoida ditibigimedi. Codaa inatawece oko onadi niɡ̶ijoa Ǥoneleegiwa ane icoɡ̶otedibigimece ditibigimedi nige limedi menagi, niotedinece lolaadi. Nigenagi, nadeegi epaa loniciwaɡ̶a, codaa datale liciagi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Odaa ja iiɡ̶e niaanjotedi, odaa inatawece oko owajipata layaageɡ̶egi aca goloneeta. Odaa aanjotedi joɡ̶odigoteloco inoatawece ane liwailidi iiɡ̶o, oyatecoɡ̶otee inatawece oko Aneotedoɡ̶oji ane iolatedicoace me nepilidi, anilaagiteloco inatawece iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Atacolitece ane ɡ̶odiiɡ̶axitece libatadi fiigo. Niɡ̶ina naɡ̶a dione libiwedi, ina laamotiidi naɡ̶a nokoloɡ̶o, odaa joɡ̶owooɡ̶otitiwaji naɡ̶a nipegi me dioneteloco nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jiɡ̶idaaɡ̶ee niganatitiwaji micota niɡ̶ida anejita, odaa joɡ̶owooɡ̶oti me daɡ̶alee eliodi ɡ̶animedi, odaa jeɡ̶enagi niɡ̶icoa nawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ejitaɡ̶awatiwaji anewi. Niɡ̶ica oko ane newiɡ̶a niɡ̶icoa nokododi oixomaɡ̶ateetedijo icoatawece niɡ̶icoa nawikodico anenagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ditibigimedi codaa me iiɡ̶o icota me ma, pida yotaɡ̶a biɡ̶idioka limedi midiwa, codaa icota micotece ane igegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aɡ̶ica ane yowooɡ̶odi niɡ̶ica noko oteɡ̶exaaɡ̶aɡ̶a naɡ̶aca lakata nige janagitace. Oteɡ̶exaaɡ̶aɡ̶a aanjotedi digoida ditibigimedi aɡ̶oyowooɡ̶odi, oteɡ̶exaaɡ̶aɡ̶a Ee, Lionigi Aneotedoɡ̶oji. Pida iniokiniwateda Aneotedoɡ̶oji ane Eiodi baɡ̶a yowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige janagi, anee me newiɡ̶a niɡ̶ica oko liciagi niɡ̶ijo jotigide niɡ̶ica oko malee yewiɡ̶a Noé. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Igaataɡ̶a maleediɡ̶ica abooɡ̶o-ninyoɡ̶odi niɡ̶ica oko niodaɡ̶a, nacipaɡ̶a, nadonaɡ̶a, codaa moyajigo lionigipi moyadoneɡ̶e neɡ̶epaaɡ̶icota noko niɡ̶ijo Noé naɡ̶a dakatiwece etogo-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Odaa niɡ̶ijo oko aɡ̶oyowooɡ̶odi niɡ̶ica anicota me ninyaagi, neɡ̶epaaɡ̶icota menagi abooɡ̶o-ninyoɡ̶odi, odaa ijotawece oceɡ̶egipi. Jiɡ̶idaaɡ̶ee lakataɡ̶a niɡ̶ica oko nige nipegi me idopitijo, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Niɡ̶ica noko iniwataale ɡ̶oneleegiwadi odibateloco nipodigi. Odaa aanjotedi onidateci oyadeegi, ideɡ̶eledi baɡ̶a nenyaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iniwataale iwaalepodi oyojogo leyeema. Odaa aanjotedi oyadeegi onaniteci, pida aniaaɡ̶eledi baɡ̶a nenyaɡ̶atini. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Enice adinenyaɡ̶atitiwaji! Igaataɡ̶a aɡ̶owooɡ̶oti niɡ̶ica noko nigeno Ǥaniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ajawienatakanaɡ̶a niɡ̶ina ane nebi diimigi daɡ̶a yowooɡ̶odi noko micotio oliceɡ̶egi, daɡ̶a yowooɡ̶odi taɡ̶a dinowedi agotaɡ̶a ika oliceɡ̶egi me yawime nibaloote me dakatio. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Enice adinenyaɡ̶atitiwaji! Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, janagi niɡ̶ica noko maleedaɡ̶anibeoonitege me janagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Odaa ica niotagi aninoa lixaketedi, anoyakadi monakato, joaniɡ̶ijaaɡ̶ijo niɡ̶ijo ane yajigota niotagodi me dowediteloco eletidi liotaka. Yajigotiogi anoyeligo niɡ̶idiwa eletidi niimetedi ditibigimedi lakata. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Niɡ̶ijo niotagi eliodi me ninitibece nigenota necalailegi leeɡ̶odi meo ane iɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ejitaɡ̶awatiwaji anewi. Niɡ̶ini niotagodi icota me yajigota niɡ̶ijo limeedi me doweditelogo idiwatawece ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pida niɡ̶ijo nimeedi anoyajigota me nowienaɡ̶anaɡ̶a niginiɡ̶ina ane beyagi, odaa meetibige le, ‘Iniotagodi leegi nige dopitijo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oditaɡ̶a nalaketiniwace lokaaɡ̶etedi me niba, ligiiwepodi codaa lacipaɡ̶awepodi niɡ̶inoa acipaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Odaa niɡ̶ini niotagodi dopitijo niɡ̶ica noko maleedaɡ̶a nibeotege, codaa me naɡ̶aca lakata me daɡ̶a eetibige niɡ̶ijo liotagi. ");
INSERT INTO kbcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Odaa niɡ̶ijo niotagodi niwiigitibige, odaa eote lawikodigi liciagi lawikodigi niɡ̶ina anokowo me libinienigipi. Odaa niɡ̶ica oko nacaagaɡ̶ateloco codaa moyacigice lowe leeɡ̶odi lawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Niɡ̶ica noko nige janagi me jiiɡ̶e inoatawece, digawini ane jiciaceeketege. Jiciaceeketege deez awicijipi ane nodenigipi migotibeci ica lalokegi nadoneɡ̶egi, noɡ̶odibatalo loledaɡ̶axiidi, odaa jiɡ̶igotibeci odakapetege niɡ̶ijo ane wado. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ciinco niɡ̶idi awicijipi yetoledi, pida icoa eletidi ciinco baɡ̶a niwaxinaɡ̶anaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Niɡ̶icoa yetoledi oyadeegi loledaɡ̶axiidi, pida aɡ̶oyadeegi lajidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pida niɡ̶ijo awicijipi ane niwaxinaɡ̶anaɡ̶a boɡ̶oyadeegi loledaɡ̶axiidi me nolee codaa ida najidi ane iiɡ̶otice. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Niɡ̶ijo ane wado naɡ̶a dinopaɡ̶adi meno, odaa ijotawece nibaciɡ̶ateloco, odaa ja niotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Naɡ̶a liwigo-enoale jiɡ̶ida ica ane dapaawe, onee, ‘Digawinitege! Niɡ̶ijo ane wado jeɡ̶eno, anagi akapetetegetiwaji!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Odaa ijotawece niɡ̶ijo awicijipi ja niwoditibigiwaji, odaa joɡ̶oyalegi loledaɡ̶axiidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Odaa niɡ̶ijo awicijipi yetoledi moditiogi niɡ̶ijo ane niwaxinaɡ̶anaɡ̶a, ‘Ǥodedianeɡ̶egodi okateciɡ̶ida ɡ̶anajidi, igaataɡ̶a ɡ̶odoledaɡ̶axiidi ja dineliotedini.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Odaa niɡ̶ijo awicijipi ane niwaxinaɡ̶anaɡ̶a joɡ̶oniniɡ̶odi, moditiogi, ‘Aɡ̶ica ɡ̶onimaweneɡ̶egi! Aɡ̶eliodi ɡ̶onajidi, aɡ̶abo-oo me joweenaɡ̶ataɡ̶adomitiwaji. Emiitiwaji manitaɡ̶a oojetekaxi, anoojeteeta ɡ̶anajidi!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Odaa niɡ̶ijo awicijipi yetoledi jiɡ̶igotibeci odinoojetetigi najidi. Odaa aniɡ̶ica me dopitijo, neɡ̶eno niɡ̶ijo ane wado. Niɡ̶ijo awicijipi ane niwaxinaɡ̶anaɡ̶a baanaɡ̶a nigomaɡ̶a, odaa joɡ̶odiotiwece niɡ̶ijo ane wado midi lalokegi nadoneɡ̶egi. Odaa epoagi ja dinoxoco. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Niɡ̶idiaaɡ̶idi jeɡ̶enotibeci niɡ̶ijo eledi awicijipi, odaa ja napaawaɡ̶ateloco, modi, ‘Ǥoniwa-aagodi! Ǥoniwa-aagodi! Omokenitoɡ̶odomi epoagi!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pida naɡ̶a niniɡ̶odi niɡ̶ijo ane wado, meetiogi, ‘Ejitaɡ̶awatiwaji anewi. Niɡ̶ida mee aɡ̶akaami yowooɡ̶otagipi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Odaa meetediogi Jesus, “Enice adinowetitiwaji! Igaataɡ̶a aɡ̶owooɡ̶otitiwaji niɡ̶ica noko oteɡ̶exaaɡ̶aɡ̶a naɡ̶aca lakata nige idopitijo Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Odaa Jesus eɡ̶idaa diitigi me dotaɡ̶a, meetediogi, “Digawini ane jiciaceeketege nige janagi me jiiɡ̶e inoatawece. Jiciaceeketege ica ɡ̶oneleegiwa ane diniwiajeticogi ditigedi. Odaa maleedaɡ̶a noditice, jeɡ̶eniditiogi liimetedi, odaa ja yajigotiogi modoweditelogo ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ica odoejegi yajigota ciinco jaaco nolee beexotedi oolo, ica eledi baɡ̶a yajigota itoataale jaaco nolee beexotedi oolo, ica eledi baɡ̶a yajigota onadateci jaaco. Eote niɡ̶ida anigotiogi leeɡ̶odi yowooɡ̶odi onidateci limeedi ida epaa lixakedi adiniciamico. Odaa niɡ̶idiaaɡ̶idi ja diniwiaje. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aɡ̶ica daɡ̶a leegi niɡ̶ijo ane dibatege ciinco jaacotedi ja ibake niɡ̶ijoa dinyeelo meo nigaanye. Odaa ja dinigaanyetece eletidi ciinco jaacotedi dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Niɡ̶ijo nimeedi ane dibatege itoataale jaacotedi jaɡ̶aɡ̶a ibake niɡ̶ijoa dinyeelo, odaa ja dinigaanyetece eletidi itoataale jaaco nolee beexotedi oolo. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pida niɡ̶ijo ane dibatege onadateci jaaco baɡ̶a naligitini, odaa jiɡ̶idaaɡ̶igota naɡ̶ajo jaaco ane nolee beexotedi oolo, jiɡ̶idaa nimaweneɡ̶egi me yaɡ̶aditedini me yotete ninyeelo necalailegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Igaanaɡ̶a ixomaɡ̶atedijo owidi nokododi, niɡ̶ijo niotagodi niɡ̶ijoa niimetedi ja dopitijo, odaa ja ilakidetedini naalewe. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Niɡ̶ijo nimeedi ane dibatege ciinco jaaco beexo niɡ̶icotio, ja yopilaɡ̶adi niɡ̶ijoa dinyeelo ane dibatege, codaa iwaɡ̶ateetece eletidi ciinco jaacotedi ane dinigaanyetece. Odaa mee, ‘Iniotagodi, geme anajicitediwa ciinco jaaco nolee beexotedi oolo. Odaa inigaanyetece eletidi ciinco jaacotedi dinyeelo. Digawini, etinoa idiwatawece!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Odaa niɡ̶ijo niotagodi meeta, ‘Eliodi mele ɡ̶abakedi! Akaami ɡ̶owotagi anele ane jakataɡ̶a me jinakatonaɡ̶a. Jiɡ̶ikeeni me jakadi me ɡ̶adinakatonitema niɡ̶ina anokateciɡ̶ini. Natigide ɡ̶adixomitio madowetiteloco niɡ̶ina aneliodi. Anagi, akaami inikaɡ̶awa!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Niɡ̶ijo niotagi ane dibatege itoataale jaaco beexotedi jaɡ̶aɡ̶icotio, odaa mee, ‘Iniotagodi, geme anajicitediwa itoataale jaaco beexotedi oolo, odaa inigaanyetece eletidi itoataale jaaco dinyeelo. Digawini, etinoa idiwatawece!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Odaa niɡ̶ijo niotagodi jeɡ̶eeta, ‘Eliodi mele ɡ̶abakedi! Akaami niotagi anele ane jakataɡ̶a me jinakatonaɡ̶a. Jiɡ̶ikeeni me jakadi me ɡ̶adinakatonitema niɡ̶ina anokateciɡ̶ini. Natigide ɡ̶adixomitio me iiɡ̶eni anowidi. Anagi, akaami inikaɡ̶awa!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶eno niɡ̶ijo niotagi ane dibatege onadateci jaaco dinyeelo, odaa mee, ‘Iniotagodi, jowooɡ̶odi makaami ɡ̶oneleegiwa ane dakake laaleɡ̶ena, odaa idoitaɡ̶awa. Anoteci codaa matecoɡ̶oteeni niɡ̶ina ane daɡ̶a ɡ̶atanigijegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Joaniɡ̶idaa leeɡ̶odi me idoi, odaa jeɡ̶ejigo, jaɡ̶aditedini niɡ̶ijoa ɡ̶aninyeelo, inaligitedini. Digawini, etinoa ɡ̶aninyeelo!’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Odaa niɡ̶ijo necalailegi jeɡ̶eeta, ‘Akaami niɡ̶ica nimeedi ane beyagi codaa me nigojigo! Menitiwa me ee ɡ̶oneleegiwa ane dakake laaleɡ̶ena, codaa me inopilaɡ̶aditedio ane daɡ̶a yawodigijedi, codaa me jatecoɡ̶otee ane daɡ̶a eyanigijedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Odaa akaami daɡ̶aleeɡ̶aɡ̶a ixomitiwece baanco ininyeelo, daɡ̶anagawini jibatege ininyeelo codaa me lionaɡ̶a naɡ̶a idopitijo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Odaa niɡ̶ijo necalailegi meetiogi icoa eletidi liotaka, ‘Abaatege ninyeelo, odaa ajicita niɡ̶ijo anidiwa deez nijaaco dinyeelo! ");
INSERT INTO kbcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Igaataɡ̶a jajigota caticedi niɡ̶ijo anidiwa nepilidi, odaa jeɡ̶epaanaɡ̶a owidi ane nepilidi. Pida niɡ̶ijo ane diɡ̶ica nebi, jibanootece, codaa niɡ̶inoa anokateciɡ̶inoa ane nepilidi eletidi jibanootece. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Natigide okoleniticogi niɡ̶ini niotagi ane diɡ̶ica aneletema digoida wetice midi nexocaɡ̶a ane lawikodadi oko. Odaa jiɡ̶idiaaɡ̶i oko me nacaagaɡ̶ateloco codaa moyacigice lowe leeɡ̶odi lawikodico.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, janagi me Ee inionigi-eliodi, ixigaɡ̶awepodi iniaanjotedi. Nige janagi, idicoteloco baanco ɡ̶oneɡ̶e me jiiɡ̶e codaa me jiwi anejigota niɡ̶ina oko leeɡ̶odi loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Odaa inatawece oko minoataɡ̶a digawinitelogo ane latopaco noiigi yatecoɡ̶o yodoe. Odaa jiolaticoace oko micataɡ̶a niɡ̶ina nowienoɡ̶odi waxacocoli me iomaɡ̶aditege waxacocoli, waxigidatedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Odaa idejate niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji ane jiciaceeketege lapo waxacocoli iwai ibaaɡ̶adi, odaa niɡ̶ina oko abeyacaɡ̶aɡ̶a ane jiciaceeketege waxigida baɡ̶a ideja inimagijegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Odaa Ee, ane Ee inionigi-eliodi, ejitiogi niɡ̶idi ane idei ibaaɡ̶adi, ‘Anagitiwaji ane ɡ̶adibinieni Eiodi! Anakaatiobece miniwataɡ̶a Eiodi, miditaɡ̶a ane ilakidetedaɡ̶adomitiwaji maleediɡ̶icatibige me yoe niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aneotedoɡ̶oji ɡ̶adibinienitetiwaji leeɡ̶odi niɡ̶ijo me idigicile, odaa adedianitece ane jeligo. Niɡ̶ijo me ideloadi ecibi, odaa ja adacipeɡ̶eni ninyoɡ̶odi. Niɡ̶ijo me iciagi niɡ̶ina icoɡ̶egi, odaa ele mabaatigitiwaji ɡ̶adiɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Niɡ̶ijo me daɡ̶adiaaɡ̶ica yowoodaɡ̶agi, odaa jaɡ̶adinixomeɡ̶eni. Niɡ̶ijo me jeelotika, odaa jaɡ̶anootiwatiwaji madaxawani. Codaa niɡ̶ijo me idiniwilo, odaa jaɡ̶adaliitiwatiwaji.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Odaa niɡ̶idi oko aneletibigiwaji etidige, moditiwa, ‘Ǥoniotagodi, igaatigi ica me ɡ̶adateɡ̶egi manigicile, odaa ja jajicaɡ̶ataɡ̶awa anelici, codaa igaatigi ica me ɡ̶adeloati ecibi, odaa ja jajicaɡ̶ataɡ̶awa ninyoɡ̶odi? ");
INSERT INTO kbcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Igaatigi ica me ɡ̶adateɡ̶egi me ɡ̶adiciagi icoɡ̶egi, odaa ele me jibaɡ̶ataɡ̶agi catiwedi ɡ̶odiɡ̶eladi? Codaa igaatigi ica me ɡ̶adateɡ̶egi me diɡ̶icoa ɡ̶adowoodi, odaa ja ɡ̶adinixomeɡ̶eneɡ̶egi? ");
INSERT INTO kbcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Codaa igaatigi ica me ɡ̶adateɡ̶egi me eelotikani, odaaɡ̶ejoɡ̶otaɡ̶awa me ɡ̶adaxawaneɡ̶egi? Codaa igaatigi ica me ɡ̶adateɡ̶egi madiniwilo, odaa ja idaliiɡ̶ataɡ̶awa?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Odaa nige jigidi, ejitiogi, ‘Ejitaɡ̶awatiwaji anewi. Niɡ̶ijo maxawanitiwaji niɡ̶ijo ane daɡ̶axa me iwikodadipi liwigotigi inioxoadipi, micataɡ̶a daanteɡ̶emaɡ̶a aniɡ̶iwaatici.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Odaa Ee, ane Ee inionigi-eliodi, ejitiogi niɡ̶ijo ane idei iwai inimagijegi, ‘Adeteceniticetiwaji, anakaami laagetedipi Aneotedoɡ̶oji! Emiitiwaji minitaɡ̶a noledi ane yoetetema Aneotedoɡ̶oji diaabo idiaa niwicidi abeyacaɡ̶aɡ̶a! ");
INSERT INTO kbcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aneotedoɡ̶oji yelatedaɡ̶adomi leeɡ̶odi niɡ̶ijo me idigicile, aɡ̶anajicitiwa ane jeligo. Niɡ̶ijo me ideloadi ecibi, aɡ̶anajicitiwa ninyoɡ̶odi me jacipe. ");
INSERT INTO kbcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Niɡ̶ijo me iciagi niɡ̶ina icoɡ̶egi, aɡ̶ele mabaatigitiwaji catiwedi ɡ̶adiɡ̶eladi. Niɡ̶ijo me daɡ̶adiaaɡ̶ica yowoodaɡ̶agi, aɡ̶ica daɡ̶a adinixomeɡ̶eni. Niɡ̶ijo me jeelotika codaa niɡ̶ijo me idiniwilo, aɡ̶ica daɡ̶adaliitiwatiwaji.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Odaa etidige, moditiwa, ‘Ǥoniotagodi, igaatigi naɡ̶a ɡ̶adateɡ̶egi manigicile, codaa me ɡ̶adeloati ecibi? Igaatigi ica me ɡ̶adateɡ̶egi me ɡ̶adiciagi icoɡ̶egi, codaa me diɡ̶icoateda ɡ̶adowoodi, oɡ̶oa migetaɡ̶a eelotikani, oɡ̶oa migetaɡ̶a madiniwilo, odaa aɡ̶adaxawaneɡ̶egi?’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Odaa ejitiogi, Ee, ane Ee inionigi-eliodi, ‘Ejitaɡ̶awatiwaji anewi. Niɡ̶ijo me daɡ̶a axawanitatiwaji niɡ̶ina oko iwikodadipi, odaa micataɡ̶a me daɡ̶a adaxawani.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Odaa niɡ̶idi oko igotibeci miditaɡ̶a ane lawikodadi oko, aneitice nawikodigi ane diɡ̶ica liniogo, leeɡ̶otedi libeyaceɡ̶eco. Pida niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji biɡ̶idioka limedi me newiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Niɡ̶ijo naɡ̶a nigotedini Jesus me yalaɡ̶ate idiwatawece niɡ̶ijoa niiɡ̶axinaɡ̶aneɡ̶eco, odaa meetediogi niɡ̶ijo anodiotibece, ");
INSERT INTO kbcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Joɡ̶owooɡ̶otitiwaji aniaditibige itoataale nokododi, odaa ja nakatio nalokegi ‘Páscoa’. Odaa jiɡ̶icota metidajigo metidototeloco nicenaɡ̶anaɡ̶ate metideloadi, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Odaa ja yatecoɡ̶o niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, icaaɡ̶icoa laxokodi lacilodi judeutedi. Yatecoɡ̶otibigiwaji minitaɡ̶a liɡ̶eladi-nelegi niɡ̶ijo lacilo-sacerdotitedi, anodita Caifás. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Odaa joɡ̶odinotaɡ̶aneɡ̶etigi ane nimaweneɡ̶egi moniwilo Jesus codaa odinotaɡ̶aneɡ̶etigi moyeloadi me diɡ̶ica ane yowooɡ̶odi niɡ̶idi noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pida modi, “Ajakataɡ̶a daɡ̶a jibaɡ̶atalo niɡ̶ina malee nalooɡ̶o ade jaoɡ̶a magecaɡ̶alodipi niɡ̶ina noiigi codaa ade jaoɡ̶a metiɡ̶odideleɡ̶e.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Niɡ̶ijo Jesus midiaaɡ̶ite manitaɡ̶a nigotakawaana ane liboonaɡ̶adi Betânia, liɡ̶eladi Simão ane nikoxeedi me “Dawace-lolaadi”, ");
INSERT INTO kbcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","jiɡ̶icotalo ajo iwaalo ane yadeegi aca naɡ̶aaɡ̶axi, wetiɡ̶a anodita “alabastro”. Naɡ̶ajo naɡ̶aaɡ̶axi nolee ladokojegi ane dakake loojedi, anoibake moyatita lolaadi émeɡ̶egi. Niɡ̶ijo Jesus naɡ̶a dawaketedeloco nameeja maniodi, odaa naɡ̶ajo iwaalo ja yadotedeloco ladokojegi lacilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Niɡ̶ijo anodiotibece noɡ̶onadi, ja neliɡ̶ideeɡ̶a, odaa ja dinige, modi me dinotaɡ̶aneɡ̶etiwage, “Igaamee ada iwaalo me yaaɡ̶adi ida nadokojegi? ");
INSERT INTO kbcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Daɡ̶aleeɡ̶aɡ̶a eyaa niɡ̶ida nadokojegi me yakakaɡ̶adi loojedi, oditaɡ̶a iboo ninyeelo me yaxawatiogi madewetedipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus yowooɡ̶oditediwe lowoogo, odaa meetediogi, “Igame leeɡ̶odi ina malomeɡ̶eni ada iwaalo leeɡ̶odi ida aneo? Eotomi niɡ̶ida ane daɡ̶axa me libinienigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Igaataɡ̶a niɡ̶ina madewetedipi idioka limedi mina makaamitaɡ̶atiwaji, pida Ee baadiɡ̶idioka limedi minaaɡ̶ejo makaamitaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Niɡ̶ijo me yadoteloco yolaadi niɡ̶ijo ladokojegi, ja ideyaɡ̶aditema nigetidaligitini. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ejitaɡ̶awatiwaji anewi. Niɡ̶ina oko moyeloɡ̶oditedibece nibodicetedi anele okanicodaaɡ̶ica aneitice niɡ̶ina iiɡ̶o, oyatemati niɡ̶ina monalaɡ̶atibige niɡ̶ida loenatagi naɡ̶ada iwaalo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Niɡ̶idiaaɡ̶idi onijoteci niɡ̶ijo dooze anodiotibece, niɡ̶ijo ane liboonaɡ̶adi Judas Iscariotes, jiɡ̶igo yotaɡ̶aneɡ̶e niɡ̶ijo anoiiɡ̶e sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Odaa meetiogi, “Igametaɡ̶a liwokodi madedianitiwaji, daɡ̶a jajigotedaɡ̶awa Jesus?” Odaa joɡ̶onilaɡ̶adi triinta beexotedi, moyedia. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ijaaɡ̶ijoa niɡ̶ijoa nokododi, Judas ja doletibige nimaweneɡ̶egi me yajigo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Noɡ̶odoejegi noko nalokegi anodita “Paon ane diɡ̶ica labookojegi”, odaa niɡ̶ijo anodiotibece Jesus joɡ̶odiitalo, odaa joɡ̶oige, moditalo, “Igamemaani mejonaɡ̶a me joenaɡ̶a ɡ̶oweenigi me Páscoa?” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Odaa ja niniɡ̶odi, meetediogi, “Emiitiwaji nigotaɡ̶a, oleetibige jiɡ̶icaa ɡ̶oneleegiwa, odaaɡ̶enita, ‘Ǥoniiɡ̶axinoɡ̶odi mee, “Jiɡ̶icota noko Aneotedoɡ̶oji ane nibikotatedomi. Jeligo liweenigi Páscoa me igiiwepodi anoniotibici digoina ɡ̶adiɡ̶eladi.” ’” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Niɡ̶ijo anodiotibece joɡ̶owo ane iiɡ̶ete Jesus, odaa joɡ̶oyoe liweenigi Páscoa. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Igaanaɡ̶a enoale, Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece ja nicotiniwace me niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eɡ̶idaaɡ̶ee me niodaɡ̶a, Jesus neɡ̶eetediogi, “Ejitaɡ̶awatiwaji anewi. Ini niɡ̶ina akaamitiwaji ane idajigotiogi ineloɡ̶ododipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Odaa eliodi magecaɡ̶alodipi, odaa oninitecibeci ige, meetalo, “Iniotagodi, manige emeɡ̶ee ane ɡ̶adajici?” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Odaa ja niniɡ̶odi, meetediogi, “Niɡ̶ini ane jibotege me jititinigi liwagedi inipaon, joaniɡ̶iniaa idajigo. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi akaa yalaɡ̶ata Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi me ideleo. Pida nagoodi niɡ̶ina ɡ̶oneleegiwa ane idajigotiogi ineloɡ̶ododipi, igaataɡ̶a Aneotedoɡ̶oji ewi me iloikatidi. Domaɡ̶a daɡ̶axa mele daaditiɡ̶ica menitini niɡ̶ini ɡ̶oneleegiwa!” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Odaa Judas, niɡ̶ijo ane yajigo Jesus, jaɡ̶aɡ̶a ige, meetalo, “Iniiɡ̶axinoɡ̶odi, manige emaɡ̶a ɡ̶adajici?” Odaa Jesus jeɡ̶eeteta, “Adomaɡ̶a leeditibige madigee!” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eɡ̶idaaɡ̶ee me niodaɡ̶a, Jesus ja dibate ijo paon, odaa diniotagodetedibigimece Aneotedoɡ̶oji. Odaa ja inoke me yajigotediogi niɡ̶ijo anodiotibece, odaa meetediogi, “Abaatege, odaa elici niɡ̶idi paon! Ane micataɡ̶a daɡ̶a yolaadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Niɡ̶idiaaɡ̶idi ja dibate ajo goopa ane nolee viinyo, odaa ja diniotagodetedibigimece Aneotedoɡ̶oji. Odaa jaɡ̶aɡ̶a yajigotediogi niɡ̶ijo anodiotibece naɡ̶ajo goopa, meetediogi, “Acipeta akaamitawecetiwaji! ");
INSERT INTO kbcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Igaataɡ̶a niɡ̶ida viinyo micataɡ̶a daɡ̶a yawodi ane inadooɡ̶odi, jaotibige Aneotedoɡ̶oji mida gela nimaweneɡ̶egi me dinilakidetetege niɡ̶ina oko. Odaa natigide Aneotedoɡ̶oji yakadi me iwilegi libeyaceɡ̶eco inatawece oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ejitaɡ̶awatiwaji anewi. Me daɡ̶adiaa jacipe daɡ̶akaami igiiwepoditece niɡ̶ida viinyo. Pida jacipeta niɡ̶ica gela viinyo makaami igiiwepodi nige jatecoɡ̶ojoɡ̶o miditaɡ̶a niɡ̶idi anejonaɡ̶a ane laɡ̶ajegitetema Aneotedoɡ̶oji loiigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Odaa niɡ̶idiaaɡ̶idi joɡ̶odigaanaɡ̶atibigimece Aneotedoɡ̶oji. Odaa jiɡ̶igotibeci minitaɡ̶a Lojotaɡ̶adi Oliveira. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Odaa Jesus meetediogi, “Niɡ̶ina enoale akaamitawecetiwaji adalati moka eetece, igaataɡ̶a Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi yalaɡ̶ata ane ligegi Aneotedoɡ̶oji, niɡ̶ijo mee, ‘Jeloadi nowienoɡ̶odi waxacocoli, odaa idiwatawece niwaxacocoli ilaagitedibece.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pida nige idewiɡ̶atace, odaa ejigo idinewade miditaɡ̶a nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pida Pedro naɡ̶a niniɡ̶odi, meetalo, “Icaaɡ̶ica niginatawece etiɡ̶adalati, pida ee baadaɡ̶a ɡ̶adalati.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Odaa Jesus meeteta, “Ejitaɡ̶awa anewi. Niɡ̶ina enoale, aniɡ̶icatibige daɡ̶a anoe okoɡ̶okoodi, odaa niɡ̶ida makaami itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro meetalo, “Icaaɡ̶ica nige leeditibige makaami yemaɡ̶awa, pida baadaɡ̶a adakatiwece yacilo deɡ̶eji me daɡ̶a ɡ̶adowooɡ̶oti.” Odaa ijotawece niɡ̶ijo eledi anodiotibece idaɡ̶aɡ̶a oyatigi ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Odaa Jesus ja lixigaɡ̶awepodi niɡ̶ijo anodiotibece midiwataɡ̶a icoa enanigijedi “oliveira” anodita Getsêmani. Odaa meetediogi, “Inaaɡ̶anicootetiwaji digoina. Ejigawaanigi digoida odoe jotaɡ̶aneɡ̶e Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Odaa ja yadeegi Pedro me lixigaɡ̶awa ijaaɡ̶ijoa itoataale lionaɡ̶a Zebedeu, João ijaa Tiago. Odaa eliodi Jesus magecaɡ̶alo, codaa eliodi me doɡ̶owikomata. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Odaa meetediogi, “Eliodi me Ee agecaɡ̶alo codaa jeemitetece mica ina daantaɡ̶a doletibige me ideleo. Inaaɡ̶onitetiwaji digoina codaa adinowetitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Odaa Jesus jiɡ̶igoawaanigi odoe, naɡ̶a yamaɡ̶atedini lokotidi, odaa ja yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, mee, “Eiodi, nige yakadi, jiniɡ̶ikani deɡ̶eliodi me jawikode. Pida ajemaa daɡ̶a jao ane emaɡ̶a jemaa, pida jemaa me jao niɡ̶ina anemaani.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Niɡ̶idiaaɡ̶idi ja dopitetege niɡ̶ijo itoatadiɡ̶ida anodiotibece, odaa jiɡ̶icotediogi me niotaɡ̶a. Odaa meeteta Pedro, “Agodaɡ̶akati doɡ̶okateciɡ̶iniawaanigi maɡ̶aɡ̶a adinowetitiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Adinoweti, codaa otaɡ̶aneɡ̶eni Aneotedoɡ̶oji, bidige aɡ̶ikani madinakatoni leeɡ̶odi ɡ̶adawikodico. Catiwedi ɡ̶adaaleɡ̶enali beɡ̶emaani maniwitici, pida ɡ̶adolaadi aɡ̶ica loniciwaɡ̶a otaɡ̶ateciɡ̶ini.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus jiɡ̶igotace yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, odaa mee, “Eiodi, nige leeditibige me jixomaɡ̶ateetedijo inoatawece ane yawikodico ane dakake, Ee daɡ̶axa me jemaa mawii anemaani.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Odaa ja dopitacetege niɡ̶ijo anodiotibece, odaa icotacediogi me niotaɡ̶a, leeɡ̶odi eliodi liotaɡ̶a, odaa aɡ̶oyakadi me noleticoace. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Odaa ja yoyatace, odaa jiɡ̶igotace yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, odaa yopilaɡ̶ateetedeloco ijaaɡ̶ijo niɡ̶ijo ane ligegite Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Niɡ̶idiaaɡ̶idi Jesus ja dopitacetege niɡ̶ijo anodiotibece, odaa meetediogi, “Eɡ̶idaaɡ̶enitiwaji me iote, anigaaxe? Digawini! Jiɡ̶icota lakata Aneotedoɡ̶oji ane nibikotatedomi. Natigide, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, jeɡ̶etidajigotiogi libaaɡ̶adi ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Adabititiniwacetiwaji, jopilaɡ̶a! Digawinitege! Jiɡ̶inaa niɡ̶ijo ane idajigotiogi ineloɡ̶ododipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus eɡ̶idaaɡ̶eeteda me dotaɡ̶a niɡ̶icotalo Judas, niɡ̶ijo ane-diotibece Jesus, lokaaɡ̶etedipi niɡ̶ijo anodiotibece. Odaa Judas lixigaɡ̶awepodi ijo noiigi-nelegi onadeegi nodaajoli-ocaɡ̶atedi inaa laxacoɡ̶onaɡ̶atedi. Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa laxokodi lacilodi judeutedi joaneɡ̶epaaɡ̶oimonya niɡ̶ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Niɡ̶ijo ane yajigo Jesus akaa dinilakidetege niɡ̶ica anodaaɡ̶ee me ikee ane diɡ̶etedigi Jesus. Meetiogi, “Niɡ̶ica ane inapicoɡ̶o me idecoaditece, jiɡ̶idaaɡ̶idoa niɡ̶ijoa ɡ̶oneleegiwa anoleetibigetiwaji. Odaaɡ̶aniwiloteda!” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Niɡ̶ijo Judas niɡ̶icotiogi, ja dowicetelogo Jesus, odaa meetalo, “Ele ɡ̶ocidi, iniiɡ̶axinoɡ̶odi?” Odaa ja napicoɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Yokaaɡ̶edi, ageniteloco niɡ̶ica ane ɡ̶abakedi managi!” Odaa joɡ̶ototelogo Jesus, joɡ̶odibatalo moniwilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pida anigepidiɡ̶ica niɡ̶ijo anodiotibece nixigitice lodaajo-ocaɡ̶ataɡ̶a, odaa ja yakagidi napaaɡ̶ate ane diɡ̶eticogi libaaɡ̶adi liotagi niɡ̶ijo lacilo-sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pida Jesus meeteta, “Ixomitinece ɡ̶adodaajo ɡ̶anaɡ̶aaɡ̶axi. Igaataɡ̶a niɡ̶ina ane nixigitice lodaajo me didele, aɡ̶oiwoko moyeloadi oyatita nodaajo-ocaɡ̶ataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Agodoɡ̶owooɡ̶oti daɡ̶a jemaa me jipokotalo Eiodi, odaa agotaɡ̶a leegi, taɡ̶a niwakatee anigetaɡ̶a liwokodi miili aanjotedi modoweditiloco? ");
INSERT INTO kbcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pida daɡ̶a idoɡ̶atedicogi libaaɡ̶adi niɡ̶ina ineloɡ̶ododipi, agotiɡ̶icotece niɡ̶ijoa lotaɡ̶a Aneotedoɡ̶oji anoyalaɡ̶atiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Odaa naɡ̶aca lakata, Jesus meetediogi niɡ̶ijo noiigi-nelegi, “Igame leeɡ̶odi manadeegi inoa ɡ̶adodaajoli-ocaɡ̶atedi inaaɡ̶inoa ɡ̶adaxacoɡ̶onaɡ̶atedi managi adiwilotiwaji? Domige Ee ɡ̶oneleegiwa ɡ̶onematagodi? Niɡ̶ijoa nokododi eliodi me idejotibige minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, anei me idicotini odaa jiniiɡ̶axitiniwace noiigi-nelegi, pida aɡ̶adiwilotiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pida natigide inoatawece niɡ̶inoa ɡ̶adoenatakatiwaji eotibige micotece ane diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi moyalaɡ̶atiwa niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko.” Odaa ijotawece niɡ̶ijo anodiotibece Jesus joɡ̶oyaladi, jiɡ̶ialetibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Odaa niɡ̶ijo anoniwilo Jesus joɡ̶oyadeegitedicogi minitaɡ̶a diimigi-nelegi liɡ̶eladi Caifás, ane lacilo idiwatawece sacerdotitedi. Jiɡ̶idiaa latecaɡ̶adi niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, ijaaɡ̶ijoa laxokodi lacilodi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro diotece Jesus, pida aɡ̶ipegitece. Diotece neɡ̶epaa niogóteloco liɡ̶eladi lacilo-sacerdotitedi. Naɡ̶a dakatio, odaa jiɡ̶idiaa nicotini awatege icoa nowienaɡ̶anadi, yemaa me iwi niɡ̶ica anodigotalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa lacilodi judeutedi idiaaɡ̶idiwa icoa lilokaɡ̶awadi iditawece odoletibige me nilaagedi Jesus. Odoletibige oko ane diwitaka anee mica Jesus loenatagi ane beyagi, domoɡ̶owotibige mida ane leeɡ̶odi moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pida idaaɡ̶ida meliodi oko awitakaɡ̶aɡ̶a anidiaaɡ̶i miditaɡ̶a, pida aɡ̶ica oteɡ̶exaaɡ̶aɡ̶a itoataale oko ane itiwage liwitakeco niɡ̶ina modotaɡ̶atibige Jesus. Niɡ̶idiaaɡ̶idi jiɡ̶ijoa itoataale ɡ̶oneleegiwadi anototicogi lodoe. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Odaa modi, “Ijo me jajipaaɡ̶atalo mee, ‘Jakadi me jojiketini Aneotedoɡ̶oji liɡ̶eladi, odaa idabiteɡ̶etacini catiwedi itoatadiɡ̶ida nokododi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Odaa niɡ̶ijo lacilo-sacerdotitedi ja dabiditini, odaa ja ige Jesus, meetalo, “Ida makaami aɡ̶otaɡ̶ani? Niɡ̶idoa itoataale ɡ̶oneleegiwadi migoyeloɡ̶odi anewi ina modakapetaɡ̶agi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pida Jesus aɡ̶ica anigetiɡ̶ida ligegi. Odaa niɡ̶ijo lacilo-sacerdotitedi meetalo, “Jibake Liboonaɡ̶adi Aneotedoɡ̶oji me ɡ̶adiiɡ̶eni me aneloɡ̶otitoɡ̶owa! Naɡ̶akamaɡ̶akaami icoa Lionigi Aneotedoɡ̶oji, ane niiɡ̶e me ɡ̶odatamaɡ̶ateetetege ɡ̶odaxakawepodi?” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus naɡ̶a niniɡ̶odi, meeteta, “Analiiki ɡ̶agegi, jeɡ̶emeɡ̶ee. Pida ejitaɡ̶awatiwaji nigidiaaɡ̶idi adati nige idopitijo, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. Icota me idicotini liwai libaaɡ̶adi Aneotedoɡ̶oji aneliodi notoetiigi, odaa idaxoditini jicoɡ̶otibigimece ditibigimedi, jiniotinece lolaadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Odaa niɡ̶ijo lacilo-sacerdotitedi yaawidigidice lowoodi me ikee me yakadi me beyagi niɡ̶ijoa lotaɡ̶a Jesus. Odaa mee, “Beyagi me dotaɡ̶atedibige Aneotedoɡ̶oji, igaataɡ̶a diniciaceeketetege Aneotedoɡ̶oji. Odaa aɡ̶alee jopooɡ̶atibige eledi oko nakataɡ̶anadi moyeloɡ̶odi minoa loenataka ane beyagi. Igaataɡ̶a jaɡ̶ajipaatalotiwaji lotaɡ̶a me beyagi me dotaɡ̶atedibige Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Enige, amiida ica ane iniɡ̶atalo?” Odaa joɡ̶oniniɡ̶odi, modita, “Niɡ̶idoa idokida me nilaagedi, odaa leeditibige me yeleo.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Odaa joɡ̶oyawaletigi latobi Jesus, codaa onalaketedibige. Odaa niɡ̶ijo anonaxacoɡ̶otedibige moditalo, ");
INSERT INTO kbcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Natigide, niɡ̶ida makaami ane eni me ɡ̶adiiɡ̶eni Aneotedoɡ̶oji. Nigewi me ɡ̶adiiɡ̶eni Aneotedoɡ̶oji, aneloɡ̶otitoɡ̶owa niɡ̶ica ane ɡ̶adaxaciɡ̶i!” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro nicote digoida niogóteloco liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. Aca awicije liimete lacilo-sacerdotitedi niɡ̶icota Pedro, odaa meeta, “Niɡ̶ida ma-aami icaa ina daɡ̶a ado-ooni mijoataɡ̶a Jesus ane icoɡ̶otedicogi nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pida Pedro mee me niwitakegi lodoe iditawece niɡ̶ijo oko, mee me dotaɡ̶a, “Aɡ̶ica daɡ̶a jowooɡ̶odi ica ane ɡ̶adalakita.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niɡ̶idiaaɡ̶idi jiɡ̶igo midataɡ̶a ijo epoagi me jiniiɡ̶atiwece niogó liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. Odaa aca eledi awicije niimete meetiogi niɡ̶ijo oko, “Niɡ̶ini aaginaɡ̶a lixigaɡ̶awa Jesus ane icoɡ̶otedicogi nigotaɡ̶a Nazaré.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Odaa Pedro ja diwitakatace mee me daɡ̶a yowooɡ̶oditeda Jesus, odaa mee me dinigetaɡ̶atee, “Aɡ̶icoa daɡ̶a jowooɡ̶odi niɡ̶idoa ɡ̶oneleegiwa!” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aɡ̶ica daɡ̶a leegi anigepidiɡ̶ica niɡ̶ijoa ɡ̶oneleegiwadi anidiaaɡ̶i, niɡ̶ipegita Pedro, odaa meeta, “Icaa ina daɡ̶akaami anigepidiɡ̶ica niɡ̶ijo ane idei mijoataɡ̶a Jesus, igaataɡ̶a ɡ̶adotaɡ̶anaɡ̶awa niɡ̶ina oko ane icoɡ̶oticogi nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Odaa Pedro jeɡ̶ee me yakadi Aneotedoɡ̶oji me iloikatidi nige diwitaka, odaa jeɡ̶ee, “Ewi me diɡ̶icoateda me jowooɡ̶odi niɡ̶idoa ɡ̶oneleegiwa, ajiwitaka!” Odaa aɡ̶ica daɡ̶a leegi, jaɡ̶anoe okoɡ̶okoodi. ");
INSERT INTO kbcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Odaa Pedro ja nalaɡ̶atibige niɡ̶ijo ane ligegite Jesus, niɡ̶ijo neɡ̶eete, “Aniɡ̶icatibige daɡ̶a anoe okoɡ̶okoodi, odaa itoatadiɡ̶ida meni me daɡ̶a adowooɡ̶oti.” Odaa ja noditicogi we niogó niɡ̶ijo diimigi, eliodi magecaɡ̶alo, codaa anoetibece. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Naɡ̶a yeloɡ̶otibige, ijotawece anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa laxokodi lacilodi judeutedi joɡ̶odinilakidetigi niɡ̶ica ane nimaweneɡ̶egi moyeloadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oigoe libaaɡ̶atedi Jesus, odaa joɡ̶oyadeegi, oyajigotalo Pilatos, lacilo romaanotedi ane iiɡ̶e nipodigi Judéia. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, niɡ̶ijo ane yajigo Jesus miditaɡ̶a neloɡ̶ododipi, nadi naɡ̶a nilaagedi Jesus niɡ̶ijoa lacilodi codaa moyemaa moyeloadi, odaa jaɡ̶agecaɡ̶alo, odaa jiɡ̶igo miditaɡ̶a niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niɡ̶ijoa laxokodi lacilodi judeutedi, odaa ja yopilaɡ̶adi niɡ̶ijoa triinta beexotedi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Odaa meetiogi, “Ica me jao ica ibeyaceɡ̶egi me jajigo ɡ̶oneleegiwa ane diɡ̶ica loenatagi ane beyagi odaa natigide ja leedi moyeloadi.” Odaa joɡ̶oigidi, modita, “Aɡ̶ica anejinaɡ̶ataɡ̶agi. Akamaɡ̶a ɡ̶abeyaceɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Odaa Judas ja yokoletedinigi iiɡ̶o niɡ̶ijoa beexotedi mini Aneotedoɡ̶oji liɡ̶eladi. Naɡ̶a noditice, odaa jiɡ̶igo dineloadi, diniɡ̶iwoola. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Niɡ̶ijo anoiiɡ̶e sacerdotitedi odibatalo niɡ̶ijoa beexotedi, odaa modi, “Ǥonajoinaɡ̶aneɡ̶eco etiɡ̶odoli me jokolenaɡ̶atinigi ɡ̶oniwokodaɡ̶axi, leeɡ̶odi loojedi ɡ̶odawodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Odaa ja dinilakidetiwage modinoojeteta nipodigi, oibake niɡ̶ijoa dinyeelo. Niɡ̶ica nipodigi liboonaɡ̶adi “Nipodigi ica niwilanaɡ̶anaɡ̶a”. Niɡ̶idi nipodigi owo me napiiɡ̶o niɡ̶inoa icoɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Joaniɡ̶idaa leeɡ̶odi codaa me niɡ̶inoa nokododi idokoyatigi, “Nipodigi ɡ̶odawodi”. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Odaa jiɡ̶icotece niɡ̶ijoa lotaɡ̶a Jeremias, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, niɡ̶ijo mee, “Odibatalo niɡ̶ijoa triinta beexotedi, ane lica me dinilakidetiwage loiigi Israel me loojedi modinoojetetalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Oibake niɡ̶idiwa dinyeelo modinoojeteta nipodigi niwilanaɡ̶anaɡ̶a. Joaniɡ̶idaa ane niiɡ̶etediwa Iniotagodi Aneotedoɡ̶oji me jao.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus idiaa dabidite lodoe Pilatos, niɡ̶ijo lacilo romaanotedi ane iiɡ̶e niɡ̶idi nipodigi. Odaa niɡ̶ijo lacilo romaanotedi ja ige Jesus, meetalo, “Akaami ninionigi-eliodi judeutedi?” Naɡ̶a niniɡ̶odi Jesus, meeteta, “Jiɡ̶idaaɡ̶ee digo analeeɡ̶enita.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pida aɡ̶ica daɡ̶a igiditediogi Jesus, niɡ̶ijo noɡ̶odakapetege niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa laxokodi lacilodi niɡ̶idi noiigi, ");
INSERT INTO kbcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Odaa Pilatos jeɡ̶ee, “Aɡ̶ajipaatalo inoa ɡ̶anotaɡ̶a? Igaataɡ̶a owidi lotaɡ̶a modakapetaɡ̶agi makaami nilaagedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pida Jesus aniniɡ̶odi, otiɡ̶idatece ligegi, odaa niɡ̶ijo lacilo romaanotedi eliodi me yopo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Niɡ̶ina me lalokegi Páscoa, niɡ̶ijo lacilo romaanotedi ligileɡ̶egi me ikatice okanicodaaɡ̶ica niwilogojegi anodipokota niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Niɡ̶ijoa nokododi onini ica niwilogojegi aniboonaɡ̶ategimadaɡ̶a, liboonaɡ̶adi Barrabás. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Niɡ̶ijo me yatecoɡ̶o niɡ̶ijo noiigi, Pilatos ja nigetiniwace, meetiogi, “Amiijo ica anemaani me jikataɡ̶adomitiwaji, Barrabás oɡ̶oa Jesus, niɡ̶idoa anodi me niiɡ̶e Ǥanoenoɡ̶oditetiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Igaataɡ̶a Pilatos yowooɡ̶odi niɡ̶ijoa lacilodi judeutedi moyadeegi Jesus minitaɡ̶a leeɡ̶odi monocetema. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Niɡ̶ijo Pilatos naɡ̶a nicotini aneitice me iwi anigota niɡ̶ina oko, odaa naɡ̶ajo lodawa ja dajoinaɡ̶ata, meeta, “Jinaɡ̶a domaɡ̶awii ane beyagitema niɡ̶idoa aaginaɡ̶a anele. Le-eeɡ̶odi jotigenoale idigee, meliodi me jawikode le-eeɡ̶odi niɡ̶ica ane ninyaagi niɡ̶idoa aaginaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa laxokodi lacilodi judeutedi joɡ̶odinigaanyetece niɡ̶ijo noiigi modipokota Pilatos me ikatice Barrabás, pida baɡ̶a diiɡ̶enatakatalo Jesus moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Odaa niɡ̶ijo lacilo romaanotedi nigetiniwace, meetiogi, “Apiɡ̶ijo inoa itoataale ɡ̶oneleegiwadi anemaani me jikaticetiwaji?” Odaa joɡ̶oigidi, modita, “Ikanitice Barrabás!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Odaa Pilatos jeɡ̶eetiogi, “Enice, amiida ica anejigotalo Jesus, ane enitalotiwaji me liwaaɡ̶aditedibigaɡ̶aji Aneotedoɡ̶oji?” Odaa ijotawece oigidi, modita, “Otonitedeloco nicenaɡ̶anaɡ̶ate meloati!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Odaa niɡ̶ijo lacilo romaanotedi ja nigetiniwace, meetiogi, “Amiida ica loenatagi ane beyagi?” Pida dinigetaɡ̶ateetibigiwaji, modi, “Otonitedeloco nicenaɡ̶anaɡ̶ate meloati!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Niɡ̶ijo Pilatos naɡ̶a nadi me daɡ̶a yakadi meo ane domaɡ̶a yemaa, codaa niɡ̶ijo noiigi naɡ̶a domaɡ̶aɡ̶a odakapetege, odaa ja dibata ninyoɡ̶odi, ja iwilegi libaaɡ̶atedi lodoe niɡ̶ijo noiigi-nelegi. Odaa jeɡ̶eetiogi, “Ajemaa deɡ̶ee nilaagedi leeɡ̶odi lemeɡ̶egi niɡ̶idoa ɡ̶oneleegiwa anele. Pida akapaɡ̶akaamitiwaji nilaagetedipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ijotawece niɡ̶ijo noiigi oigidi, modita, “Anikanitoɡ̶odici yakadi moko nilaagetedipi, codaa me ɡ̶odionigipi leeɡ̶odi lemeɡ̶egi niɡ̶idoa ɡ̶oneleegiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Odaa Pilatos ja ikatice Barrabás. Odaa ja diiɡ̶enatakatalo monalaketedibige Jesus, odaa niɡ̶idiaaɡ̶idi ja yajigo midiwataɡ̶a niodaɡ̶awadi moyototedeloco nicenaɡ̶anaɡ̶ate moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Odaa niɡ̶ijoa niodaɡ̶awadi niɡ̶ijo lacilo romaanotedi joɡ̶oyadeegitedicogi Jesus minitaɡ̶a diimigi-nelegi, liɡ̶eladi lacilo romaanotedi. Odaa ja yatecoɡ̶o ijoatawece iodaɡ̶awadi onawiile Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niɡ̶idiaaɡ̶idi joɡ̶onoɡ̶a Jesus lowoodi, odaa joɡ̶onixomeɡ̶etedinigi aca caapa lixagotoɡ̶ogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Codaa joɡ̶owo aca lale, anitawece lalepiɡ̶igo, joɡ̶onixotinece Jesus lacilo. Odaa owo me nolitedini ligiilaɡ̶adi. Niɡ̶idiaaɡ̶idi onowo moyamaɡ̶atedini lokotidi lodoe, odaa joɡ̶oyame, modi, “Viiva, Niɡ̶idoa one ninionigi-eliodi judeutedi!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Odaa joɡ̶oyawaletigi latobi, noɡ̶oibanootece niɡ̶ijo ligiilaɡ̶adi, odaa joɡ̶oyaxacoɡ̶otigi lacilo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Noɡ̶oika moyametibigo Jesus, odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶onoɡ̶a naɡ̶ajo caapa lixagotoɡ̶ogo, odaa joɡ̶onixomeɡ̶etacedinigi niɡ̶ijoa epaa lowoodi. Niɡ̶idiaaɡ̶idi joɡ̶oyadeegi Jesus moyototedeloco nicenaɡ̶anaɡ̶ate moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Niɡ̶ijoa iodaɡ̶awadi anoyadeegi Jesus naɡ̶a noditicoaci nigotaɡ̶a Jerusalém, joɡ̶odakapetege ica ɡ̶oneleegiwa ane liboonaɡ̶adi Simão, ane icoɡ̶oticogi nigotaɡ̶a Cirene. Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oiedeɡ̶etege Simão me yoyaɡ̶adi naɡ̶ajo nicenaɡ̶anaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Odaa joɡ̶otota ijo lojotaɡ̶adi ane liboonaɡ̶adi Gólgota. Niɡ̶ida boonaɡ̶adi amina anejinaɡ̶ata, “Ǥodacilo libitagi”. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Niɡ̶idiaaɡ̶idi domoɡ̶oyacipeɡ̶etalo Jesus viinyo awatege ligiti. Pida naɡ̶a napi, odaa ayemaa me wacipete. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Niɡ̶idiaaɡ̶idi joɡ̶oyototedeloco Jesus nicenaɡ̶anaɡ̶ate, odaa joɡ̶oiwi anepaɡ̶a dinetetece niɡ̶ijoa lowoodi. Joaniɡ̶idaa niɡ̶icotece lotaɡ̶a niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, niɡ̶ijo mee, “Odinawalacetigi yowoodi, codaa joɡ̶oiwi anepaɡ̶a dinetetece inicaapa.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niɡ̶idiaaɡ̶idi ja nicotiniwace moyowie. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Odaa joɡ̶oyototi taaboa-liwai ditibigimedawaanigi lacilo Jesus ane diniditeloco ane leeɡ̶odi moyeloadi. Diniditeloco niɡ̶ica taaboa, ");
INSERT INTO kbcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Niɡ̶ijoa iodaɡ̶awadi eletidi oyototedi itoataale ɡ̶oneleegiwadi olicaɡ̶aɡ̶a, onidateci diɡ̶etege nimagijegi idaaɡ̶eledi diɡ̶etege libaaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Niɡ̶ina oko ane ixomaɡ̶ateloco aneite Jesus me dinototedi, oyame. Nabalenaɡ̶anaɡ̶a, odaa modi, ");
INSERT INTO kbcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Niɡ̶ida makaami geemeni makati mojikenitini Aneotedoɡ̶oji liɡ̶eladi, odaa meni me domaɡ̶a adabiteɡ̶enitacini catiwedi itoatadiɡ̶ida nokododi! Axotitice naɡ̶ada nicenaɡ̶anaɡ̶ate! Nigewi makaami Lionigi Aneotedoɡ̶oji, odaaɡ̶axotitice!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, ijoa laxokodi lacilodi judeutedi idaɡ̶aɡ̶a lamenaɡ̶aneɡ̶egitema Jesus, modi, ");
INSERT INTO kbcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Eliodi meetedibece me yakadi meote eledi oko me newiɡ̶atace, pida Idaaɡ̶idoa ayakadi me dinatamaɡ̶ateetetege lemeɡ̶egi! Daantiɡ̶idaaɡ̶idoa niɡ̶icoa ninionigi-eliodi Israel, taɡ̶a waxoditedice naɡ̶ada licenaɡ̶anaɡ̶ate, odaa teɡ̶ejiwaɡ̶ataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Codaa nakato Aneotedoɡ̶oji, odaa natigide jiwinaɡ̶a Aneotedoɡ̶oji nige yemaa me noɡ̶atedice me daɡ̶a yeleoteda. Igaataɡ̶a mee me Lionigi Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Niɡ̶ijoa olicaɡ̶aɡ̶a anoyototelogo nicenaɡ̶anaɡ̶ate anodipegitege Jesus, idaɡ̶aɡ̶aee, oditibigelogo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Igaanaɡ̶a yaxoɡ̶o-noko, ja nexocaɡ̶a neɡ̶epaa iniwatadaɡ̶ani lakata me ɡ̶ocidi, odaa inatawece iiɡ̶o nexocaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naɡ̶a iniwatadaɡ̶ani lakata me ɡ̶ocidi, Jesus ja dinigetaɡ̶atee me dapaawe, mee me dotaɡ̶a, “Eli, Eli, lemá sabactani!” Niɡ̶idiwa notaɡ̶a amina anejinaɡ̶a, “Inoenoɡ̶odi, Inoenoɡ̶odi, igame leeɡ̶odi madikanitice?” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Niɡ̶ijo oko anowajipatalo lotaɡ̶a Jesus, modi, “Dapaawetedigi Elias.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Odaa aɡ̶ica daɡ̶a leegi anigepidiɡ̶ijo niɡ̶ijo anowajipatalo ja walokodi, odaa ititinigi lawaadi ica viinyo ane daɡ̶a dakake loojedi. Naɡ̶a igoetece iwoɡ̶o, odaa ja domaɡ̶a ilipeɡ̶etece Jesus niɡ̶ijo lawaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pida ica eledi oko modi, “Ikani! Jiwinaɡ̶a Elias migenagi noɡ̶atedicogi aneite.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus naɡ̶a dinigetaɡ̶ateetace me dapaawe, odaa ja yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Odaa naɡ̶aca lipegeteɡ̶e nelegi ane nanyoti minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi ane iomaɡ̶adi niɡ̶ica aneite Aneotedoɡ̶oji, naɡ̶aca lipegeteɡ̶e ja daawidigidicetigi liwigotigi icoɡ̶otibigimece ditibigimedi neɡ̶epaa natinedi me daa. Codaa datalale iiɡ̶o, odaa wetiadi dawalace. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Libecoli émaɡ̶aɡ̶a domoke, odaa eliodi oko baanaɡ̶a nigo anida aneetege Aneotedoɡ̶oji ja newiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Noditicoaci niɡ̶inoa libecoli. Niɡ̶idiaaɡ̶idi naɡ̶a yewiɡ̶atace Jesus, niɡ̶ijoa émaɡ̶aɡ̶a ane newiɡ̶atace joɡ̶odakatiwece nigotaɡ̶a Jerusalém, nigotaɡ̶a Aneotedoɡ̶oji ane iomaɡ̶aditedice mepoka nebiteda. Odaa joɡ̶odinikeetiogi eliodi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Niɡ̶ijo jajeentegi ijaaɡ̶ijoa niodaɡ̶awadi anoyowie Jesus noɡ̶onadi me datalale iiɡ̶o ijaaɡ̶ijoa eletidi loanico niɡ̶ijo noko, odaa eliodi me doitibigiwaji, odaa modi, “Dicewi, niɡ̶idoa ɡ̶oneleegiwa me Lionigi Aneotedoɡ̶oji!” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Idiaaɡ̶i eliodi iwaalepodi aneite Jesus, anoniotece, oicoɡ̶oticogi Galiléia anelioditibece moyaxawa. Pida leegitiogi moiɡ̶oaditalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Liwigotigi niɡ̶ijo iwaalepodi ani Maria Madalena, ajo eledi Maria ane eliodo Tiago ijaa José, ajaaɡ̶ajo eliodo lionigipi Zebedeu. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Niɡ̶ijo naɡ̶a doletibige me dalimeti aligeɡ̶e, jiɡ̶icotio ica ɡ̶oneleegiwa liico liboonaɡ̶adi José, ane icoɡ̶oticogi nigotaɡ̶a Arimatéia. Inaaɡ̶ina ane-diotibece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José igo minitaɡ̶a Pilatos, dipokota lolaadi Jesus. Odaa Pilatos ja diiɡ̶enataka moyajigota. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Odaa José ja yadeegi Jesus lolaadi, ilipaditigi niɡ̶elate gela, lipegeteɡ̶e anodita nigitikonaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Odaa ja ixotediwece Jesus niɡ̶ijo anepaa domaɡ̶a libegi José ane nenyaɡ̶adi, lawimaɡ̶ajegi-wetiɡ̶a, gela moigodi me diiɡ̶enatakata José. Odaa ja yawililetio wetiɡ̶a nelegi me noxoco lapoagi niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a. Odaa joɡ̶opitio. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Idiaa nenyaɡ̶ate Maria Madalena ajaaɡ̶ajo eledi Maria. Nicotiniwace lodoe niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Naɡ̶a saabado, ja ixomaɡ̶atijo onijoteci noko modinenyaɡ̶aditege lalokegi Páscoa. Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa fariseutedi jiɡ̶igotibeci minitaɡ̶a Pilatos. ");
INSERT INTO kbcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Odaa modita, “Iniotagodi, nalaɡ̶atibigoɡ̶oji niɡ̶ijo malee yewiɡ̶a niɡ̶ijoa awitakegi, meetedibece, ‘Nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Odaa iiɡ̶eni iodaɡ̶awadi modowediteloco lawimaɡ̶ajegi-wetiɡ̶a anoyatice lolaadi nigepaa ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, adoɡ̶odoliceta niɡ̶ijo anodiotibece lolaadi, oditaɡ̶a oditiogi niɡ̶ina noiigi, ‘Ja yewiɡ̶atace!’ Igaataɡ̶a doɡ̶oyakadi mowo, tiɡ̶ida eledi niwitakegi daɡ̶axa me beyagi caticedi niɡ̶ijo odoejegi niwitakegi mijaaɡ̶ee me yewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Odaa Pilatos jeɡ̶eetiogi, “Awii adeegitetiwaji iodaɡ̶awadi. Emii, odaa adowetiteloco libegi, codaa awii niɡ̶ica aneneɡ̶egi akati mele me ɡ̶animaweneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Odaa jiɡ̶igotibeci, joɡ̶oyatitaɡ̶aditi naɡ̶ajo wetiɡ̶a ane noxoco niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, owo me diɡ̶icata ane yakadi me itineɡ̶e naɡ̶ajo wetiɡ̶a. Odaa jiɡ̶idiaaɡ̶oyoyate iodaɡ̶awadi me nowienaɡ̶anadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Naɡ̶a ixomaɡ̶atijo saabado, ja yapacaɡ̶atege nigoi me nakatio domiingo, Maria Madalena ajaaɡ̶ajo eledi Maria jiɡ̶igotibeci odalita niɡ̶ijo libegi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Maleediɡ̶icotibeci, jonaɡ̶a datalale iiɡ̶o, leeɡ̶odi niaanjo Ǥoniotagodi Aneotedoɡ̶oji me dinikatini, odaa ja noɡ̶atice naɡ̶ajo wetiɡ̶a nelegi ane noxoco niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a aneitice lolaadi Jesus, odaa ica aanjo ja nicoteloco naɡ̶ajo wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Niɡ̶ijo aanjo datale liciagi nalebepaɡ̶a, icoa lowoodi one daɡ̶axa me yapacaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Odaa niɡ̶ijoa nowienaɡ̶anadi eliodi me doitibigiwaji, nawigicaɡ̶ateloco, odaa ja liciagi niɡ̶ina oko baanaɡ̶a yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Odaa niɡ̶ijo aanjo meetiogi niɡ̶ijo iwaalepodi, niɡ̶icotiobeci, “Jinaɡ̶adoii! Jowooɡ̶odi managi oleetibige Jesus, niɡ̶ijoa anoyototedeloco nicenaɡ̶anaɡ̶ate moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aɡ̶aleeɡ̶icoa digoina, leeɡ̶odi ja yewiɡ̶atace, jiɡ̶icota niɡ̶ijo ane ligegi. Anagi, awini niɡ̶ijo anoyatedice. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Natigide ɡ̶adediiki memiitiwaji, enitiogi niɡ̶ijo anodiotibece naɡ̶a yewiɡ̶atace, codaa jiɡ̶igo dinewadetedicogi digoida nipodigi Galiléia. Odaa jiɡ̶idiaaɡ̶i manatitetiwaji. Odaa jiɡ̶idaaɡ̶ee, jeɡ̶ejitece ijoatawece anetidiiɡ̶e me jeloɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Odaa niɡ̶ijo iwaalepodi ja yediiɡ̶atibigiwaji me noditicoaci niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, eliodi me doitibigiwaji, pida niɡ̶idiaaɡ̶idi ninitibigiwaji. Waleditibigiwaji migotibeci oibodicaxi niɡ̶ijo anodiotibece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Odaa naigitece codaa noɡ̶onidoateda Jesus naɡ̶a dakapetetege niɡ̶ijo iwaalepodi, odaa ja nicetediniwace, meetediogi, “Inibeotege mele ɡ̶adaaleɡ̶enali!” Odaa joɡ̶odiitalo, oibedotece loɡ̶onaka, codaa odoɡ̶etetalo. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Odaa Jesus jeɡ̶eetediogi, “Jinaɡ̶a adoiitiwaji! Pida emii, odaa enitiogi inioxoadipi migotibeci nipodigi Galiléia. Jiɡ̶idiaaɡ̶i metidadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Eɡ̶idaa diiticogi mewaligitibigiwaji niɡ̶ijo iwaalepodi, onateciɡ̶ijoa niɡ̶ijoa iodaɡ̶awadi anoyowie niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a joɡ̶opitibeci manitaɡ̶a nigotaɡ̶a. Odaa joɡ̶oyeloɡ̶oditiogi niɡ̶ijo anoiiɡ̶e sacerdotitedi ijoatawece niɡ̶ijoa anonadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Odaa niɡ̶idiwa lacilodi joɡ̶odinatecoɡ̶oteetege niɡ̶ijoa laxokodi lacilodi judeutedi, odinilakidetege. Odaa owidi dinyeelo oyajigotiogi niɡ̶ijoa iodaɡ̶awadi. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Odaa moditiogi, “Jemaanaɡ̶a menitiwaji, ‘Niɡ̶ijo anodiotibece enagitibeci jotigenoale naɡ̶a jiotaɡ̶a. Odaa joɡ̶odoliceta lolaadi Jesus.’ ");
INSERT INTO kbcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Odaa nige wajipata niɡ̶inoa ɡ̶adotaɡ̶a niɡ̶ijo lacilo romaanotedi, odaa jaoɡ̶a me diletibige me daɡ̶awii ane beyagi, odaa aleeditibige daɡ̶akaami agecaɡ̶alodipitetiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oyadeegi niɡ̶ijoa dinyeelo owidi, odaa joɡ̶odi niɡ̶ijo nigegi anoiiɡ̶etiogi niɡ̶ijoa lacilodi. Odaa niɡ̶ida niwitakegi jiɡ̶ilaagiteloco iditawece judeutedi codaa niɡ̶ina noko. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Odaa niɡ̶ijo oonze anodiotibece Jesus jiɡ̶igotibeci nipodigi Galiléia, odaa joɡ̶otota niɡ̶ijo lojotaɡ̶adi aneetediogi Jesus me dakapetetege. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Noɡ̶onadi Jesus, odaa joɡ̶odoɡ̶etetalo. Pida ijoawaanigi onateciɡ̶ijo ane dinawietibigiwaji mewi niɡ̶idaaɡ̶idoa. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Odaa Jesus niɡ̶ipegitediogi, meetediogi, “Aneotedoɡ̶oji najigotediwa iiɡ̶enatakaneɡ̶egitema inoatawece, aninoa ditibigimedi codaa minatawece iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Natigide, emiitecetiwaji inatawece noiigi, odaa aniiɡ̶axinitiniwace moniotici, codaa anilegenitiniwace niɡ̶ina anetidadiwaɡ̶adi. Abakeni Liboonaɡ̶adi Aneotedoɡ̶oji Ǥodiodi, Liboonaɡ̶adi Lionigi, iniaa Liwigo Aneotedoɡ̶oji niɡ̶ina milegenaɡ̶ani. ");
INSERT INTO kbcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iiɡ̶axinitece mowo inoatawece ane jiiɡ̶etedaɡ̶awa mawii. Codaa idioka limedi me idejo makaamitaɡ̶atiwaji nigepaa owidijedi nokododi.”");
INSERT INTO kbcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nibodicetedi anele aneetece Jesus Cristo, Lionigi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jiɡ̶idaaɡ̶ee maleekoka dinojogotedini nibodicetedi anele. Isaías ijaaɡ̶ijo eledi anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji niɡ̶ijo jotigide, oyalaɡ̶atalo Aneotedoɡ̶oji lotaɡ̶a, niɡ̶ijo modi, “Digawini! Jimonyaticogi ɡ̶adodoe niɡ̶ijo aneetece niɡ̶inoa yotaɡ̶a me ilakidetece ɡ̶anaigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dapaawetibece miditaɡ̶a nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi, mee me dotaɡ̶a, ‘Alakidenitema naigi Ǥoniotagodi me ixomaɡ̶atedijo! Awii naicoli me dixoketema!’” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","João Batista niɡ̶ijo ane niiɡ̶e Aneotedoɡ̶oji idiaaɡ̶i miditaɡ̶a nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi, odaa nilegetiniwace oko. Yatematitibece latematigo, yalaɡ̶ata niɡ̶ina oko me leeditibige modinilaatece libeyaceɡ̶eco, odaa ja dinilege me ikee modinilaatece libeyaceɡ̶eco, odaa ja ixomaɡ̶ateetedice Aneotedoɡ̶oji libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ijotawece niɡ̶ijo niɡ̶eladimigipitigi nipodigi Judéia, aniaa nigotaɡ̶a Jerusalém igotibeci midataɡ̶a João me nilegetiniwace midi akiidi Jordão. Niɡ̶ijo noɡ̶odi lodoe eliodi oko me inoa libeyaceɡ̶eco codaa moyemaa moika libeyaceɡ̶eco, odaa ja nilegetiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","João lowoodi, gameelo lamodi anonibila, codaa nigoenaɡ̶adi ewacogo. Codaa yeligo ɡ̶onipidi inaa napigo. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Inoatawece nokododi yalakatiditiogi niɡ̶ica noiigi, meetiogi, “Nigidiaaɡ̶idi enagi eledi oko ane daɡ̶axa me ɡ̶oneɡ̶egi caticedi ee, oteɡ̶exaaɡ̶aɡ̶a jakadi me idakagitini lodoe me jowilece liwelatedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jibake ninyoɡ̶odi me ɡ̶adilegenitiwaji me jikee niɡ̶ikani mawiite niɡ̶inoa ɡ̶abeyaceɡ̶eco, pida baɡ̶a ibake Liwigo Aneotedoɡ̶oji me iigi anodaaɡ̶eni me ɡ̶adewiki.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Niɡ̶ijoa nokododi me dilegenaɡ̶a João, Jesus noditedice nigotaɡ̶a Nazaré, nipodigi Galiléia. Odaa jiɡ̶igo aneitice João me dilegenaɡ̶a. Odaa João ja ilege Jesus miditaɡ̶a akiidi Jordão. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Niɡ̶ijo Jesus naɡ̶a doletibige me daxoditedita ninyoɡ̶odi, aɡ̶ica daɡ̶a leegi, ja nadi ditibigimedi me domoke. Odaa Liwigo Aneotedoɡ̶oji ja dinikatelogo dinanatigi yotibi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Odaa Aneotedoɡ̶oji ja dotaɡ̶a digoida ditibigimedi, meete, “Akaami Ionigi ane daɡ̶axa me jemaa. Eliodi me idinitibeci akaami leeɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Odaa aɡ̶ica daɡ̶a leegi Liwigo Aneotedoɡ̶oji ja yadeegitedicogi Jesus miditaɡ̶a nipodigi ane yadilo ane diɡ̶icata niɡ̶eladimigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Odaa Jesus jiɡ̶idiaaɡ̶itedice cwareenta nokododi. Odaa Ǥodaxakawa jiɡ̶icaaniɡ̶igotalo Jesus me dineetalo, domeɡ̶eotibige deɡ̶eote loenatagi ane beyagi. Codaa niɡ̶idi nipodigi inoa eijedi ane doide, pida aanjotedi odoweditelogo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Niɡ̶idiaaɡ̶idi noɡ̶oixotiwece João manitaɡ̶a niwiloɡ̶onaɡ̶axi, Jesus jiɡ̶igo nipodigi Galiléia yatematitedibece nibodicetedi anele aneetece Aneotedoɡ̶oji me icota me iiɡ̶e laaleɡ̶enali oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Odaa mee, “Niɡ̶ica noko Aneotedoɡ̶oji ane nibikota jiɡ̶icota. Ja nipegi Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali oko. Adinilaanitecetiwaji ɡ̶abeyaceɡ̶eco, codaa iwaɡ̶ati nibodicetedi anele.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Niɡ̶ijo Jesus me noxiwigi liniogotibece niweiigi Galiléia, odaa ja nadi Simão ijaaɡ̶ijo nioxoa ane liboonaɡ̶adi André. Oyokoletedinigi leelatiidi miditaɡ̶a weiigi leeɡ̶odi mina libakedi me nomiigomigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Odaa Jesus meetediogi, “Anagi, aniwitibici! Ǥadiiɡ̶axini anodaaɡ̶emiita oko madeegitalo Aneotedoɡ̶oji, digo anemii madeegi noɡ̶ojegi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aɡ̶ica daɡ̶a leegi odaa joɡ̶oikatedice leelatiidi, odaa joɡ̶odiotibece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Odaa niɡ̶igoawaanigi odoe, Jesus ja nadi Tiago ijaaɡ̶ijo nioxoa ane liboonaɡ̶adi João, lionigipi Zebedeu. Ideiticoace catinedi liwatece, oyoetibigo leelatiidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aɡ̶ica daɡ̶a leegi Jesus jaɡ̶aɡ̶a eniditediogi modiotibece. Odaa jiɡ̶idiaaɡ̶oyaladi niɡ̶ijo eniodi maditaɡ̶a liwatece ijaaɡ̶ijoa liimetedipi, odaa joɡ̶odiotibece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus ijaaɡ̶ijo anodiotibece joɡ̶otota nigotaɡ̶a Cafarnaum. Odaa aɡ̶ica daɡ̶a leegi, naɡ̶a saabado, Jesus jiɡ̶igo diiɡ̶axinaɡ̶a manitaɡ̶a liiakanaɡ̶axi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Niɡ̶idi noiigi ane yatecoɡ̶o eliodi moyopo leeɡ̶odi anodaaɡ̶eeteda me diiɡ̶axinaɡ̶a. Leeɡ̶odi niɡ̶ijo naɡ̶a diiɡ̶axinaɡ̶a, ibake epaa naɡ̶atetigi, aliciagi niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, leeɡ̶odi boɡ̶oibake naɡ̶atetigi niɡ̶inoa eletidi niiɡ̶axinaɡ̶anadi niɡ̶ina modiiɡ̶axinaɡ̶atece najoinaɡ̶aneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Manitaɡ̶a niiakanaɡ̶axi onini ica ɡ̶oneleegiwa ane dakatiogi niwigo abeyaceɡ̶egi aneo meote loenataka ane napioi. Odaa niɡ̶ijo Jesus me diiɡ̶axinaɡ̶a, niɡ̶ijo niwigo abeyaceɡ̶egi eo niɡ̶ijo ɡ̶oneleegiwa me dacaage, odaa mee, ");
INSERT INTO kbcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Aɡ̶ica anejinaɡ̶ataɡ̶agi, Jesus anicoɡ̶iticogi nigotaɡ̶a Nazaré! Domige naɡ̶anagi me ɡ̶odaaɡ̶ateɡ̶egi? Jowooɡ̶odi anakaami. Akaami Niɡ̶ijoa ane iolatedice Aneotedoɡ̶oji, codaa nimonya miniokiniwateda me dibatema.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Odaa Jesus ja yapeteɡ̶e niɡ̶ijo niwigo abeyaceɡ̶egi, meete, “Anotokiti, codaa anotitice niɡ̶idoda ɡ̶oneleegiwa!” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Odaa niɡ̶ijo niwigo abeyaceɡ̶egi eliodi meo me dinaxilaketibece niɡ̶ijo ɡ̶oneleegiwa. Naɡ̶a dinigetaɡ̶atee me dacaage, odaa ja ika niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ijotawece niɡ̶ijo noiigi nawelatibigiwaji, odaa ja dinigetiwage, modi, “Amiida ica niciagi? Domige niiɡ̶enatakaneɡ̶egi gela? Igaataɡ̶a ida notoetiigi me iticoitedice niwicidi abeyacaɡ̶aɡ̶a, codaa oyiwaɡ̶adi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Odaa aɡ̶ica daɡ̶a leegi, nibodigitigi niɡ̶ida aneote Jesus jiɡ̶ilaagiteloco iditawece nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Niɡ̶ijo Jesus naɡ̶a noditedice liiakanaɡ̶axi judeutedi, odaa dowicetedicogi liɡ̶eladi Simão ijaa André. Ijo maɡ̶aɡ̶a lixigaɡ̶awepodi Tiago ijaa João. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aca Simão loxiiɡ̶ate noɡ̶otota one deelotika. Iwoteloco lipe, eliodi me dapicoɡ̶o-lolaadi. Naɡ̶a dakatedio Jesus ijaaɡ̶ijo anodiotibece, odaa joɡ̶oyatematitalo me deelotika Simão loxiiɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Odaa Jesus ja dakatediwece aneitice naɡ̶ajo iwaalo, naɡ̶a dibatedigi libaaɡ̶adi, odaa ja yaxawa me nicotini. Odaa ja ma me dapicoɡ̶o-lolaadi, odaa jiɡ̶idaaɡ̶eyatigi me yoe liweenigi Jesus ijaaɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Niɡ̶ijo naɡ̶a ɡ̶ocidi, naɡ̶a dalimeti aligeɡ̶e, ica noiigi oyadeegitalo Jesus icoatawece niɡ̶icoa neelotaginadi codaa me niɡ̶ica anodakatiogi niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ijotawece niɡ̶ijo niɡ̶eladimigipitigi nigotaɡ̶a dinatecoɡ̶otee lodoe Simão liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Odaa Jesus icilatidi eliodi oko, codaa inoatawece ane latopaco neelotika, codaa iticoitedice owidi niwicidi abeyacaɡ̶aɡ̶a. Niɡ̶ijo naɡ̶a iticoitedice, odaa Jesus aika niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a doɡ̶oyalaɡ̶atalo leeɡ̶odi oyowooɡ̶odi Jesus me Aneotedoɡ̶oji Lionigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Niɡ̶ijo maleedaɡ̶a dinici okoɡ̶okoodi, Jesus jiɡ̶itedibige, odaa jiɡ̶igo miditaɡ̶a nipodigi ane diɡ̶icata oko. Odaa jiɡ̶idiaaɡ̶itedice me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simão ijaaɡ̶ijo niɡ̶ijo eledi anodiotibece joɡ̶odoletibige Jesus idiaanaɡ̶adii. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Niɡ̶ijo noɡ̶oyakadi Jesus, odaa joɡ̶oditalo, “Inatawece noiigi oyapitibigaɡ̶aji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pida Jesus meetediogi, “Iniɡ̶a midiwataɡ̶a eletidi nigotadawaanaɡ̶a ane ipegitege niɡ̶ina anejonaɡ̶a amaleeɡ̶aɡ̶a idiaa yatematikanaɡ̶adi. Igaataɡ̶a jiɡ̶idaa ibakedi Aneotedoɡ̶oji ane niiɡ̶etediwa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Odaa Jesus jiɡ̶igotedeloco iditawece nipodigi Galiléia, yatematitedibece latematiko midiwataɡ̶a liiakanaɡ̶axiidi judeutedi, codaa iticoitedicoace niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ica noko ica ɡ̶oneleegiwa dawace-lolaadi igo midoataɡ̶a Jesus, odaa yamaɡ̶atedi lokotidi lodoe, odaa meetalo, “Nigemaani madicilatiti, jowooɡ̶odi mida ɡ̶animaweneɡ̶egi madicilatiti.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus eliodi me iwikode, odaa ipeketedeloco libaaɡ̶atedi, odaa ja niniɡ̶odi, meeteta niɡ̶ijo ɡ̶oneleegiwa, “Jemaa me ɡ̶adicilatiti! Natigide, ja ɡ̶adicili!” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Odaa aɡ̶ica daɡ̶a leegi, ja ma niɡ̶ijo leelotagi, jeɡ̶ele lolaadi niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Odaa aɡ̶ica daɡ̶a leegi, Jesus ja iiɡ̶e mopi. Codaa yajoi niɡ̶ijo ɡ̶oneleegiwa, meeteta, “Digawini! Jiniɡ̶ica anatematiita me ɡ̶adicilatiti. Pida emii midiwataɡ̶a sacerdotitedi, odaa ikeeni naɡ̶a ɡ̶adicili. Odaa aboonitalo Aneotedoɡ̶oji niɡ̶ijo jotigide Moisés ane iiɡ̶e moibootalo mikeenita niɡ̶ina eledi oko Aneotedoɡ̶oji naɡ̶a ɡ̶adicilatiti.” ");
INSERT INTO kbcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pida niɡ̶ijo ɡ̶oneleegiwa naɡ̶a noditice, odaa jiɡ̶idaaɡ̶eyatigi me yatematitiogi niɡ̶ina eledi oko, odaa jiɡ̶ilaagitice nibodigi. Joaniɡ̶idaa leeɡ̶odi Jesus me daɡ̶a domaɡ̶alee yakadi me dakatediwece nigotadi niɡ̶ina me yemaa. Pida jiɡ̶idiaaɡ̶itedice midiwataɡ̶a nipodaɡ̶a ane diɡ̶icata niɡ̶eladimigipi, wetice nigotadi. Odaa niɡ̶ina oko jiɡ̶igotibeci miniwataɡ̶a, oicoɡ̶oticogi inoatawece nigotadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naɡ̶a ixomaɡ̶atedijo icoa nokododi, Jesus joɡ̶opitacedicogi nigotaɡ̶a Cafarnaum. Odaa jiɡ̶ilaagitice nibodigi niɡ̶iniwa liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Odaa aɡ̶ica daɡ̶a leegi eliodi oko dinatecoɡ̶otee, codaa aɡ̶aleeɡ̶ica nimedi anipegitege lapoagi liɡ̶eladi. Odaa Jesus yatematitediogi Aneotedoɡ̶oji lotaɡ̶a niɡ̶idi noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eɡ̶idaaɡ̶ee me datematika Jesus, odaa icoa cwaatolo ɡ̶oneleegiwadi oyadeegi ica alejaado ane daɡ̶adiaa ditineɡ̶e, odaa joɡ̶oyoyaɡ̶adi waxoditinigi lipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pida aɡ̶oyakadi doɡ̶odipegitalo Jesus leeɡ̶odi niɡ̶ijo noiigi-nelegi. Odaa joɡ̶odalaɡ̶atetibigimece diimigi leláɡ̶a, odaa joɡ̶owo lawimaɡ̶ajegi niɡ̶ijo diimigi leláɡ̶a, ditibigimedi niɡ̶ijo aneitedice Jesus. Niɡ̶ijo noɡ̶owo lawimaɡ̶ajegi nelegi, odaa joɡ̶onikatini niɡ̶ijo alejaado. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Niɡ̶ijo Jesus naɡ̶a nadi niɡ̶ijoa cwaatolo ɡ̶oneleegiwadi moyiwaɡ̶adi mida nimaweneɡ̶egi me icilatidi niɡ̶ijo ɡ̶oneleegiwa alejaado, odaa jeɡ̶eete niɡ̶ijo alejaado, “Ionigi, Aneotedoɡ̶oji ja napitaɡ̶adi ɡ̶abeyaceɡ̶eco!” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Icoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés idiaaɡ̶i nicotiniwace. Odaa ja nowookonaɡ̶a, codaa epaa dinige, modi, ");
INSERT INTO kbcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Igame leeɡ̶odi idoa ɡ̶oneleegiwa meote ida ligegi? Dotaɡ̶atedibige Aneotedoɡ̶oji. Igaataɡ̶a aɡ̶ica eledi ane yakadi me napitaɡ̶adi libeyaceɡ̶eco niɡ̶ina oko. Iniokiniwateda Aneotedoɡ̶oji baɡ̶a yakadi me napitaɡ̶adi nibeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Odaa aɡ̶ica daɡ̶a leegi Jesus ja yowooɡ̶odi ane lowoogo, odaa jeɡ̶eetediogi, “Igame leeɡ̶odi midaɡ̶a ɡ̶adowoogo catiwedi ɡ̶adaaleɡ̶enali? ");
INSERT INTO kbcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Amigida ica ane daɡ̶a ɡ̶alaɡ̶a mejita niɡ̶idi ɡ̶oneleegiwa alejaado? Domigetaɡ̶a eneɡ̶egi dakake mejita, ‘Aneotedoɡ̶oji ja napitaɡ̶adi ɡ̶abeyaceɡ̶eco’, oɡ̶oa, domigetaɡ̶a eneɡ̶egi dakake mejita, ‘Adabititini, abaata ɡ̶adipe, odaaɡ̶awaligi!’? ");
INSERT INTO kbcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pida jikeetaɡ̶awatiwaji, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, mida inimaweneɡ̶egi digoina iiɡ̶o me inapitaɡ̶adi libeyaceɡ̶eco oko.” Odaa Jesus jeɡ̶eete niɡ̶ijo ɡ̶oneleegiwa alejaado, ");
INSERT INTO kbcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ǥadiiɡ̶eni, adabititini, abaata ɡ̶aɡ̶elate, odaa opiliticogi ɡ̶adiɡ̶eladi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo ɡ̶oneleegiwa ja dabiditini, dibata naɡ̶ajo liɡ̶elate, odaa joɡ̶opi, yakagiditeloco lodoe niɡ̶ijo noiigi-nelegi. Odaa ijotawece eliodi moyopo, codaa odoɡ̶etetalo Aneotedoɡ̶oji, odaa modi, “Aniɡ̶ica me jinataɡ̶a liciagi niɡ̶ida niciagi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus niɡ̶igotace liniogotibece weiigi. Odaa ica noiigi-nelegi jiɡ̶igo midoataɡ̶a, odaa jiɡ̶idaaɡ̶eyatedigi me niiɡ̶axitediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Maleeɡ̶idiaa neɡ̶ewaligite, odaa ja nadi Levi, niɡ̶ijo lionigi Alfeu. Levi idiaaɡ̶i nicoteloco nibaanco aneitice me dibatibigege ninyeelo ninionigi-eliodi romaanotedi. Odaa Jesus jeɡ̶eeteta, “Anagi, aniwitibici!” Odaa Levi ja dabiditini, odaa ja diotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesus igo Levi liɡ̶eladi. Odaa ja nicotedini me ligiiwepodi niɡ̶ijo anodiotibece. Aaɡ̶aɡ̶a ligiiwepodi eliodi niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa meliodi oko ane daɡ̶axa me abeyacaɡ̶aɡ̶a, igaataɡ̶a eliodi niɡ̶ijo oko anodiotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, niɡ̶ijo anida aneetege niɡ̶ijo lapo fariseutedi, onadi Jesus me ligiiwepodi niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa me niɡ̶ijoa eletidi oko aneliodi me abeyacaɡ̶aɡ̶a. Niɡ̶ijo noɡ̶onadi, odaa joɡ̶onigetiniwace niɡ̶ijo anodiotibece Jesus, moditiogi, “Igame leeɡ̶odi Ǥaniotagodi me ligiiwepodi codaa me lacipaɡ̶awepodi niɡ̶ina anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa me niɡ̶idi oko aninoa libeyaceɡ̶eco?” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus ja wajipate niɡ̶ijo noɡ̶onigetiniwace niɡ̶ijo anodiotibece. Niɡ̶ijo naɡ̶a wajipatediogi, odaa jeɡ̶eetediogi, “Niɡ̶ina oko icileɡ̶egi ayopotibige dotowegi, inokina niɡ̶ina oko ane deelotika baɡ̶a yopotibige dotowegi. Odaa Ee iciagi niɡ̶ina dotowegi. Igaataɡ̶a ajanagi niɡ̶ina iiɡ̶o daɡ̶a jiniditiogi niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji, pida janagi me jiniditiogi niɡ̶ina oko abeyacaɡ̶aɡ̶a, ane liciagi niɡ̶ina oko eelotaginadipi, amaleeɡ̶aɡ̶a odinilaatece libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ica noko niɡ̶ijo anodiotibeci João Batista ijaaɡ̶ijo anodiotibeci fariseutedi odinatita nigigi mepaanoɡ̶oyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Ica oko enagitibeci midoataɡ̶a Jesus, odaa joɡ̶oige, moditalo, “Niɡ̶ijo anodiotibeci João Batista ijaaɡ̶ijo niɡ̶ijo anodiotibeci fariseutedi odinatita nigigi mepaanoɡ̶oyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Igame leeɡ̶odi niɡ̶idi anodiotibigaɡ̶adici me doɡ̶odinatita nigigi mepaanoɡ̶oyotaɡ̶aneɡ̶e Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Odaa Jesus ja niniɡ̶oditediogi, meetediogi, “Ina oko nodenigipi midi lalokegi nadoneɡ̶egi, domigodinatita nigigi ina nigini niɡ̶ijo ane wado miditaɡ̶a? Oteɡ̶exaaɡ̶aɡ̶oyakadi modinatita nigigi! ");
INSERT INTO kbcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pida icota niɡ̶ica noko niɡ̶ini ane wado modibata, odaa onoɡ̶aticogi liwigotigi niɡ̶idi oko. Odaa niɡ̶ica noko niɡ̶idi oko nodenigipi joɡ̶odinatita nigigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aɡ̶ica ane napade niɡ̶ina nowoodaɡ̶agi oxiiɡ̶odi daɡ̶a dapadenaɡ̶ata niɡ̶ina lipegeteɡ̶e liwai gela, igaataɡ̶a nige dinabake, odaa niɡ̶ijo lapadenaɡ̶anaɡ̶adi gela dinixigitiwage, odaa ja yaaɡ̶adi niɡ̶idi nowoodaɡ̶agi oxiiɡ̶odi anonapade, odaa jeɡ̶epaanaɡ̶a eliodi laakajegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aɡ̶ica ane iatinigi viinyo gela naɡ̶ana laɡ̶aaɡ̶axi ewacogo opake. Igaataɡ̶a niɡ̶ina viinyo gela beyagi nigoiatinigi naɡ̶ana laɡ̶aaɡ̶axi opake, odaa niɡ̶ica viinyo mina aniadi, codaa naɡ̶ada laɡ̶aaɡ̶axi icota me beyagi. Pida leeditibige moiatinigi viinyo gela naɡ̶ana laɡ̶aaɡ̶axi gela.” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ica noko me saabado Jesus ijaaɡ̶ijo anodiotibece oyakagiditeloco ica nixoɡ̶otagi leyeema. Noɡ̶oyakagiditeloco, odaa niɡ̶ijo anodiotibece joɡ̶onotegi ligecidi leyeema, onolagilatedi oyeligo. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Odaa niɡ̶ijoa fariseutedi moditalo Jesus, “Digawini! Igame leeɡ̶odi niɡ̶idi anodiotibigaɡ̶adici mowo ane yolitoɡ̶odomi ɡ̶onajoinaɡ̶aneɡ̶egi me daɡ̶a jaoɡ̶a niɡ̶ina me saabado?” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Pida Jesus meetediogi, “Ajawienataka me naɡ̶alomeɡ̶enitelocotiwaji niɡ̶ijo Davi aneo niɡ̶ijo jotigide, Abiatar me lacilo-sacerdotitedi. Niɡ̶ijo Davi ijaaɡ̶ijoa lokaaɡ̶etedipi naɡ̶a nigodi nigigi, odaa Davi dakatio minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, odaa ja yeligo nipaon niɡ̶ijoa sacerdotitedi anoibootalo Aneotedoɡ̶oji. Ǥonajoinaɡ̶aneɡ̶egi ɡ̶odoxoɡ̶o me diɡ̶ica eledi ane yakadi me yeligo niɡ̶ijo paon. Inokinoa sacerdotitedi boɡ̶oyakadi moyeligo niɡ̶ijo paon. Pida Davi baanaɡ̶a yeligo, codaa yajigotiogi niɡ̶ijoa lokaaɡ̶etedipi maɡ̶aɡ̶a oyeligo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Odaa Jesus meetediogi, “Aneotedoɡ̶oji eote niɡ̶ina saabado me yaxawa niɡ̶ina oko. Aɡ̶eote niɡ̶ina oko midokida modowediteloco niiɡ̶enatakaneɡ̶egi ane iiɡ̶e modowediteloco saabado. ");
INSERT INTO kbcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ida inaɡ̶atetigi mejitece ane yakadi me jaoɡ̶a niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus dakatacediwece manitaɡ̶a liiakanaɡ̶axi judeutedi. Idiaaɡ̶itice ica ɡ̶oneleegiwa beyagi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Onidi ica oko anoiwitalo Jesus odoletibige monadi mige icilatidi niɡ̶ijo ɡ̶oneleegiwa ane beyagi libaaɡ̶adi me saabado, igaataɡ̶a domoɡ̶oyemaa me nilaagedi Jesus niɡ̶ina meote niɡ̶icoa ane yolitoɡ̶odomi lajoinaɡ̶aneɡ̶eco Moisés me jaoɡ̶a niɡ̶ina me saabado. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Odaa Jesus meeteta niɡ̶ijo ɡ̶oneleegiwa, “Anagi digoina lodoe niɡ̶ina oko!” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Odaa Jesus jeɡ̶eetediogi niɡ̶ijo oko lakapetedipi, “Amiinoa icoa lajoinaɡ̶aneɡ̶eco Moisés ane ɡ̶odiiɡ̶e me jaoɡ̶a niɡ̶ina me saabado? Domige jakataɡ̶a me jaoɡ̶a anele, oɡ̶oa domige me jaoɡ̶a ane beyagi? Domige jakataɡ̶a me jaxawanaɡ̶a niɡ̶ina oko me jaoɡ̶a lewiɡ̶a, oɡ̶oa jikanaɡ̶a me yeleo?” Odaa aɡ̶ica anoyatigi ligegi doɡ̶oigidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Odaa Jesus naɡ̶a iwitediogi, odaa ja yelatetema niɡ̶ijo oko, codaa agecaɡ̶alo leeɡ̶odi laaleɡ̶enali me daɡ̶axa me dakake. Odaa jeɡ̶eeteta niɡ̶ijo ɡ̶oneleegiwa ane beyagi libaaɡ̶adi, “Ixokeni ɡ̶abaaɡ̶adi!” Niɡ̶ijo naɡ̶a ixoketice libaaɡ̶adi, odaa ja icí, ja liciagi niɡ̶ijo eledi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Odaa niɡ̶ijoa fariseutedi ja noditicoaci, jiɡ̶igotibeci oyotaɡ̶aneɡ̶e niɡ̶ijo lapo anodiotibeci inionigi-eliodi Herodes. Odoletibige niɡ̶ica nimaweneɡ̶egi moyeloadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Odaa Jesus naɡ̶a noditedicogi aneitedice, jiɡ̶igo lixigaɡ̶awepodi niɡ̶ijo anodiotibece, igotibeci liniogotibece niweiigi Galiléia. Odaa niɡ̶ica noiigi-nelegi anodiotece. Niɡ̶ica oko oicoɡ̶oticogi nipodigi Galiléia, codaa me Judéia. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ica eledi oko boɡ̶oicoɡ̶oticogi nigotaɡ̶a Jerusalém, codaa me nipodigi Iduméia, codaa ica eledi oko oicoɡ̶oticogi daato akiidi Jordão. Ica eledi oko oicoɡ̶oticogi nigotadi Tiro aniaa Sidom. Niɡ̶idi noiigi-nelegi enagitibeci midoataɡ̶a Jesus niɡ̶ijo noɡ̶odibodicetibige ane loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesus ja iiɡ̶e niɡ̶ijo anodiotibece moilakideti aca niwatece, meetediogi, “Alakideni naɡ̶adi niwatece ayenikamaɡ̶a deɡ̶ejigo jaxoditinigi.” Leeɡ̶odi niɡ̶ijo noiigi-nelegi eneɡ̶egi oiligice. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Codaa eliodi oko ane icilatidi, odaa joaniɡ̶idaa leeɡ̶odi niɡ̶ijo oko eelotaginadi me diniligice, odoletibige moyakadi modibatelogo maɡ̶aɡ̶a icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niɡ̶ijo oko anodakatiogi niwicidi abeyacaɡ̶aɡ̶a noɡ̶onadi Jesus, odaa niwicidi abeyacaɡ̶aɡ̶a owo menitiniwace lodoe, codaa nacaagaɡ̶a, modi, “Jaɡ̶akamaɡ̶akaami Lionigi Aneotedoɡ̶oji!” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Odaa Jesus ja noxoɡ̶otediniwace, codaa najoitediniwace me doɡ̶oyatemati niɡ̶ica anijoa. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus dalaɡ̶atetedibigimece aca wetiɡ̶a, odaa jeɡ̶eniditediogi niɡ̶ijoa ɡ̶oneleegiwadi ane yemaa me iolatedicoace, odaa joɡ̶odiitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Odaa Jesus ja iolatedicoace icoa dooze ɡ̶oneleegiwadi aneyatedigi me “Iiɡ̶exedipi”. Iolatedicoace midiaaɡ̶i mijoataɡ̶a, codaa me iiɡ̶e moyatematitedibece latematiko. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Odaa ja yajigotediogi notoetiigi moicilatidi eelotaginadi, codaa moiticoiticoace niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Digawini liboonaɡ̶atedi niɡ̶ijoa ɡ̶oneleegiwadi Jesus ane iolatedicoace: Simão anidokeyatedigi me Pedro, Tiago ijaa João ane lionigipi Zebedeu anidokoyatigi me Boanerges, amina anejinaɡ̶ata, “Lionigipi niximaɡ̶aɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Codaa aaɡ̶aɡ̶a iolatedicoace André, Filipe, Bartolomeu, Mateus, Tomé, Tiago ane lionigi Alfeu, Tadeu, Simão ane domaɡ̶a yemaa me nideleɡ̶etiniwace romaanotedi, ijaa Judas Iscariotes ane yajigo Jesus niɡ̶idiaaɡ̶idi mijoataɡ̶a neloɡ̶ododipi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Niɡ̶ijo Jesus niɡ̶igo liɡ̶eladi, odaa niɡ̶ica noiigi-nelegi ja dinatecoɡ̶oteetace. Odaa Jesus ijaaɡ̶ijo anodiotibece aɡ̶aleeɡ̶oyakadi oteɡ̶exaaɡ̶aɡ̶a me niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Odaa litacepodi Jesus joɡ̶odibodice niɡ̶ica Jesus aneote, odaa ja noditicoaci liɡ̶eladi me lowoogo modigotalo Jesus, domoɡ̶oyadeegitedicogi liɡ̶eladi, leeɡ̶odi ica oko anodi Jesus me yetole. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Onidiwa icoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés anoicoɡ̶oticogi nigotaɡ̶a Jerusalém. Niɡ̶idi modi, “Belzebu, ane lacilo niwicidi abeyacaɡ̶aɡ̶a, yajacaɡ̶adi, codaa yajigotalo notoetiigi me iticoitedicoace niwicidi abeyacaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Odaa Jesus jeɡ̶eniditediogi niɡ̶ijo noiigi me igotibeci odipegitalo, odaa ibake natematiko anida ane iciaceeketetege me niiɡ̶axitediniwace. Odaa meetediogi, “Igamodaaɡ̶ee Satanás me yakadi mepaa diniticoitice minitaɡ̶a oko? Ayakadi! ");
INSERT INTO kbcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nigidi inionigi-eliodi loiigi ane dawalacetiwage, odaa nigidiaa dinideletiwage, odaa loiigi icota me ma. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nigidi dinoiigiwepodi, ane dawalacetiwage, codaa midiaa dakapetiwage, niɡ̶idi noiigi icota me ma. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Codaa niwicidi abeyacaɡ̶aɡ̶a ane iiɡ̶e Satanás nige dawalacetiwage, odaa idiaa dakapetiwage, icota me ma notoetiigi Satanás, odaa aɡ̶alee diiɡ̶enataka. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pida aɡ̶ica ane yakadi me dakatiwece liɡ̶eladi niɡ̶ini ɡ̶oneleegiwa loniciweɡ̶enigi me doliceta niɡ̶inoa ane nepilidi. Idoka yakadi modolicetalo ane nepilidi niɡ̶ini ɡ̶oneleegiwa nigodoejegi moigoetini. Odaa nigaleekoka oyakadi moyadeegi niɡ̶inoa ane nepilidi niɡ̶ini ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aneotedoɡ̶oji yakadi me ixomaɡ̶ateetedice inoatawece ane latopaco libeyaceɡ̶eco niɡ̶ina oko anowote, codaa lotaɡ̶a ane beyagi modakapetege. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pida Aneotedoɡ̶oji baadaɡ̶a ixomaɡ̶ateetedice niɡ̶ina oko ane beyagi modotaɡ̶atibige Liwigo Aneotedoɡ̶oji. Idioka limedi me laagedi niɡ̶ini oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Odaa jiɡ̶idaaɡ̶ee Jesus me igidi leeɡ̶odi niɡ̶idi oko modi me dakatiogilo niwigo abeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niɡ̶icotiobeci Jesus nioxoadipi ajaaɡ̶ajo eliodo. Odaa ideiticoace we niɡ̶ijo diimigi, odaa joɡ̶odienaɡ̶atalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Eliodi oko oyawiile Jesus, odaa moditalo, “Ǥadiodo idiaa ɡ̶anioxoadipi etidi wetice, onienaɡ̶ataɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Odaa Jesus ja igiditediogi, meetediogi, “Amaajo aca eiodo? Codaa amiijo ica inioxoadipi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naɡ̶a niipetediogi Jesus niɡ̶ijo ane nicotiniwace anoyawiile, odaa jeɡ̶ee, “Digawini! Niɡ̶idi jiɡ̶idiaa inioxoadipi codaa me eiodo. ");
INSERT INTO kbcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Igaataɡ̶a niɡ̶ina aneo Aneotedoɡ̶oji ane yemaa, niɡ̶ini jiɡ̶iniaa inioxoa, iniwaalo, codaa me eiodo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus naɡ̶a niiɡ̶axitacediniwace noiigi liniogotibece niweiigi Galiléia. Odaa eliodi oko odilapodetelogo. Joaniɡ̶idaa leeɡ̶odi me waxoditedinigi naɡ̶ajo niwatece nicotedinigi le, odaa niɡ̶ijo noiigi-nelegi idiaaɡ̶i miditaɡ̶a dotiwadi liniogotibece weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Niɡ̶ijo Jesus me niiɡ̶axitediniwace niɡ̶ijo noiigi, yatemati owidi natematiko anida ane iciaceeketetege. Odaa meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Diganajipaatiwa! Ica ɡ̶oneleegiwa one yadeegi nolacidi meyateloco miditaɡ̶a lixoɡ̶otagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Niɡ̶ijo naɡ̶a ilaagaɡ̶aditedibece niɡ̶ijoa nolacidi inoatawece liwailidi, odaa onicoa icoa lolacidi aneniteloco naigi liniogotibece. Odaa ilaaɡ̶axodi jeɡ̶enagitibeci, joɡ̶oyelio niɡ̶ijoa lolacidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Icoa eletidi lolacidi onenite midiwataɡ̶a wetiadi ane deɡ̶ewi ina mica iiɡ̶o. Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijoa lolacidi ja nokoloɡ̶o leeɡ̶odi me deɡ̶ewi ina mica iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pida naɡ̶a dapicoɡ̶o aligeɡ̶e, odaa ja yalegi ijoatawece niɡ̶ijoa nawodigijedi, odaa ja yadilo, leeɡ̶odi onateciɡ̶ijoa litotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Icoa eletidi lolacidi enitedini miditaɡ̶a ipelakijadi. Odaa ipelaɡ̶a naɡ̶a ili, odaa ja iɡ̶owalaɡ̶adi lawodigijedi niɡ̶ijo ɡ̶oneleegiwa aneyatedini, odaa aika daɡ̶a etaye. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pida icoa eletidi beɡ̶eniteloco miditaɡ̶a ica iiɡ̶o anele. Naɡ̶a nokoloɡ̶o, odaa beɡ̶ele me ili, codaa etaye. Onidateci ligegi yajigo triinta, seseenta, codaa me onaniteci taalia lolacidi leyeema.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Odaa meetediogi Jesus, “Niɡ̶ina oko ane wajipatalo yotaɡ̶a, leeditibige me watacotece.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Niɡ̶ijo noɡ̶opitibeci niɡ̶ijo noiigi-nelegi, odaa onaniɡ̶iniwatece Jesus ijaaɡ̶ijo dooze anodiotibece ijaaɡ̶ijoa eletidi lokaaɡ̶etedipi anidiaaɡ̶itice oigetece anodaa diitigi niɡ̶ijo latematigo ane yatemati. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Odaa Jesus jeɡ̶eetediogi, “Aneotedoɡ̶oji ɡ̶adiolaatedicetiwaji me ikeetedaɡ̶awatiwaji anodaaɡ̶ee me iiɡ̶e laaleɡ̶enali niɡ̶ina oko. Pida jatematitiogi natematiko anida ane jiciaceeketege niɡ̶ina ane doɡ̶oyemaa Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Jiɡ̶idaa leeɡ̶odi mideɡ̶ejigotiogi amaleeɡ̶aɡ̶a onadi, pida aɡ̶oyowooɡ̶odi niɡ̶ica ane jao, codaa owajipata, pida aɡ̶oyowooɡ̶odi iiɡ̶axinaɡ̶aneɡ̶eco. Odaa jiɡ̶idaa me doɡ̶oyakadi modinilaatece libeyaceɡ̶eco, odaa ayakadi Aneotedoɡ̶oji me yapitaɡ̶adi laaleɡ̶enali.’” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Odaa Jesus ja nigetediniwace, meetediogi, “Nige doɡ̶owooɡ̶oti ane diitigitiwaji niɡ̶ijo yatematigo ane jatemati, igame ɡ̶animaweneɡ̶egi mowooɡ̶oti inoa eletidi yatematiko? ");
INSERT INTO kbcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Niɡ̶ijo ɡ̶oneleegiwa ane ilaagaɡ̶aditedibece lolacidi liciagi niɡ̶ina ane yatematitedibece nibodicetedi anele ane icoɡ̶otedicogi miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Initibece oko ane wajipatalo niɡ̶inoa nibodicetedi anele liciagi naigi liniogotibece. Niɡ̶ina naɡ̶a wajipata, odaa aɡ̶ica daɡ̶a leegi Satanás ja noɡ̶a natematiko ane ideite catiwedi laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Odaa ina eledi oko liciagi niɡ̶ina iiɡ̶o aninoa wetiadi. Niɡ̶ina noɡ̶owajipatalo nibodicetedi anele, odibatege niɡ̶ijoa natematiko, codaa me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pida niɡ̶ijo oko aɡ̶eliodi eliwaɡ̶atakaneɡ̶egi liciaco niɡ̶ijoa nawodigijedi anokateciɡ̶idiwa litodi, odaa aɡ̶ica daɡ̶a leegi midiaaɡ̶i. Niɡ̶ina niɡ̶inoa ane dakaketema, codaa ina moyalomeɡ̶e niɡ̶ina eledi oko leeɡ̶odi monakato Aneotedoɡ̶oji, odaa niɡ̶idi oko joɡ̶oika monakato Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ina eledi oko liciagi niɡ̶ina iiɡ̶o aninaa ipelaɡ̶a. Owajipatalo nibodicetedi anele. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pida oigecaɡ̶aleɡ̶e niɡ̶inoa aninoatigi digoina iiɡ̶o, odaa daɡ̶axa moyemaa dinyeelo, codaa oyemaa niɡ̶inoa anicinoa mepoka oyakadi. Odaa jiɡ̶idaaɡ̶ee, liciagi niɡ̶inoa nawodigijedi ane yapoɡ̶oditini ipelaɡ̶a, odaa inoatawece niɡ̶inoa anoyemaa mowote aika me ili Aneotedoɡ̶oji lotaɡ̶a catiwedi laaleɡ̶enali, odaa Aneotedoɡ̶oji lotaɡ̶a aiigi ane lakataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pida ina eledi oko baɡ̶a liciagi niɡ̶ijo iiɡ̶o anele. Niɡ̶idi oko odibatege nibodicetedi anele, odaa Aneotedoɡ̶oji lotaɡ̶a iigi lakataɡ̶a niɡ̶idi oko, odaa liciagi metaye niɡ̶ijoa lolacidi anoyajigo ligegi anidiwa triinta, seseenta codaa me onaniteci taalia lolacidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus eɡ̶idaaɡ̶ee me dotaɡ̶a, meetediogi, “Domigica ane yalegi noledaɡ̶axi odaa yapoɡ̶oditeloco baalida, oɡ̶oa domigetaɡ̶a ixotiwece nipe le? Aɡ̶ica! Pida oyalegi naɡ̶ana noledaɡ̶axi, odaa onanyoketi ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Odaa aɡ̶ica ane dinaɡ̶aditi ane daɡ̶a yeloɡ̶oteloco. Codaa inoatawece ane dinaɡ̶aditedini, icota monadi niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Niɡ̶ina oko anowajipatalo yotaɡ̶a leeditibige mowatacotece.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Meetediogi Jesus, “Niɡ̶ina baɡ̶a owookoni niɡ̶ina majipaatalo yotaɡ̶a. Anemiita niɡ̶ina eledi oko, odaa jiɡ̶idaɡ̶aɡ̶a igotedaɡ̶awatiwaji Aneotedoɡ̶oji, odaa eliodi niɡ̶ica ane yajigote niɡ̶ina oko anowatacotece latematiko. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Igaataɡ̶a Aneotedoɡ̶oji daɡ̶axatace meliodi ane yajigote niɡ̶ina oko anoyiwaɡ̶adi. Pida niɡ̶ina oko ane diɡ̶ica eliwaɡ̶atakaneɡ̶egi, Aneotedoɡ̶oji noɡ̶a niɡ̶ijo onateciɡ̶ini anida minitaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus mee, “Niɡ̶ina Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko, liciagi niɡ̶ina ɡ̶oneleegiwa aneyatedini nolacidi miditaɡ̶a iiɡ̶o ane ibinie. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Niɡ̶ina neɡ̶enoale diote, odaa nicotini niɡ̶ina naɡ̶a noko, odaa niɡ̶ijoa nolacidi ja nokoloɡ̶o codaa me ili, pida ayowooɡ̶odi niɡ̶ica anodaaɡ̶ee me ili. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iiɡ̶o eo me ili nawodigijedi. Odoejegi nokoloɡ̶o nawodigijegi, nigidiaaɡ̶idi ja daxoditice ligecidi. Odaa nigidiaaɡ̶idi jaɡ̶aɡ̶a nodi lolacidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Niɡ̶ina neɡ̶ei niɡ̶inoa ligecidi, odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo ɡ̶oneleegiwa ja nakagidi yatita nodaajo, leeɡ̶odi jiɡ̶icota noko me nopilaɡ̶aditedio lawodigijedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eɡ̶idaaɡ̶ee Jesus me dotaɡ̶a, mee, “Igamigodaaɡ̶ee nige iiɡ̶e Aneotedoɡ̶oji laaleɡ̶enali niɡ̶ina oko? Amigida ica natematigo ane jiciaceeketege me jakadi me jatemati? ");
INSERT INTO kbcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Niɡ̶ina Aneotedoɡ̶oji niɡ̶idaaɡ̶eyatedigi me iiɡ̶e laaleɡ̶enali niɡ̶ina oko, liciagi naɡ̶ana lolagi mostaada. Niɡ̶ina moyateloco niɡ̶ina iiɡ̶o, naɡ̶ani lolagi daɡ̶axa me lionawaana liwigotigi niɡ̶inoa eletidi lolacidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pida nigidiaaɡ̶idi nigoyatini naɡ̶ajo lolagi, odaa ili yayoketicoace niɡ̶ijoa eletidi nawodigijedi. Codaa libiwedi daɡ̶axa me nelecoli, odaa ilaaɡ̶axodi owote libatoli odiwaletigi laamotiidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Niɡ̶ijo Jesus me yatematitediogi niɡ̶ijo oko nibodicetedi anele, ibake owidi natematiko anida ane iciaceeketetege liciagi niɡ̶ijoa natematiko baanaɡ̶a yatematitediogi. Inoka eetetece niɡ̶ina anoyakadi moyowooɡ̶odi niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Codaa adatematikatediogi me daɡ̶a ibaketeda natematigo anida ane iciaceeketege. Pida niɡ̶ina noɡ̶okiniwatece ijaaɡ̶ijo anodiotibece, odaa Jesus ja yeloɡ̶oditediogi niɡ̶ica ane diitigi ijoatawece niɡ̶ijoa ane diiɡ̶axinaɡ̶atetece. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Niɡ̶ijo noko naɡ̶a dawike, Jesus meetediogi niɡ̶ijo anodiotibece, “Iniɡ̶a daato weiigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Odaa jiɡ̶idiaaɡ̶oyaladi niɡ̶ijo noiigi-nelegi, odaa joɡ̶oyadeegi Jesus catinedi niwatece niɡ̶ijo aneetedi naɡ̶a ika me datematika, odaa jiɡ̶igotibeci. Odaa ijoa eletidi niwateceli joɡ̶odiotece. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pida codaaɡ̶ida noɡ̶onenagi ica niwocotaɡ̶a. Odaa niɡ̶icoa ebekadi nelecoli ja yalaketedibigeloco naɡ̶ajo niwatece, odaa naɡ̶ajo niwatece ja domaɡ̶a nolee ninyoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pida idiaa Jesus oneote lakaalaɡ̶adi, odaa ja diote digoida lowiditice naɡ̶ajo niwatece. Odaa niɡ̶ijo anodiotibece joɡ̶oyojietelogo, odaa moditalo, “Ǥoniiɡ̶axinoɡ̶odi, aɡ̶ica mawiitioɡ̶oji? Niɡ̶ida moko ja jaaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Odaa Jesus jiɡ̶itedibige, odaa ja yamaketedini niocodi, codaa meetediogi ebekadi, “Anotokitiniwaci!” Odaa niocodi ja damatini, odaa ijoatawece damatiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Odaa Jesus meetediogi, “Igaamee ina madoiitiwaji? Igame leeɡ̶odi me deɡ̶ewi me iwaɡ̶ati Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Odaa eliodi modoitalo Jesus niɡ̶ijo anodiotibece leeɡ̶odi niɡ̶ijo loenatagi. Odaa dinigetiwage, modi, “Amiidoa icoa ɡ̶oneleegiwa? Igaataɡ̶a codaa me niocodi inaa ebekadi oyiwaɡ̶adi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece naɡ̶a diɡ̶etita daato niweiigi Galiléia, odaa joɡ̶otota miditaɡ̶a nipodigi ane liɡ̶eladi noiigi geraseenotedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Niɡ̶ijo Jesus naɡ̶a waxoditedice naɡ̶ajo niwatece, aɡ̶ica daɡ̶a leegi ja noditice ica ɡ̶oneleegiwa icoɡ̶otiwece apiiɡ̶o, odaa jiɡ̶icotalo Jesus. Niɡ̶ijo ɡ̶oneleegiwa dakatiogi niwigo abeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ja liɡ̶eladi minitaɡ̶a apiiɡ̶o midiwataɡ̶a lawimaɡ̶ajetedi-wetiadi anoyatedice niɡ̶inoa émaɡ̶aɡ̶a. Aonaɡ̶aleeɡ̶ica ane yakadi me niwilo niɡ̶ijo ɡ̶oneleegiwa, oteɡ̶exaaɡ̶aɡ̶a niɡ̶ina moibake galeena moigoetini. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Onelioditibece niɡ̶ina modibata, odaa joɡ̶oigoe libaaɡ̶atedi, codaa me loɡ̶onaka oyatita galeena, pida idioka limedi me nakagidi niɡ̶icoa galeenatedi, eote laɡ̶aagetedawaanaɡ̶a. Codaa aɡ̶aleeɡ̶ica ane yakadi me yajacaɡ̶adi, leeɡ̶odi ja daɡ̶axa me yoniciwadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inoatawece nokododi codaa minoatawece enoaleli igoteloco apiiɡ̶o codaa midiwa wetiadi, dapaawetibece, codaa dinanacilotidita wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Niɡ̶ijo ɡ̶oneleegiwa naɡ̶a naditege Jesus, walokoditege, odaa jeɡ̶enitinigiiɡ̶o lodoe Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Odaa dapaawe, meetalo, “Aɡ̶ica anejitaɡ̶agi, Jesus. Jaɡ̶akamaɡ̶akaami Lionigi Aneotedoɡ̶oji, Aneotedoɡ̶oji aninoatawece notoetico. Jibake Liboonaɡ̶adi Aneotedoɡ̶oji me jipokotaɡ̶awa me daɡ̶a adiloikatiti.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Odaa niɡ̶ijo niwigo abeyaceɡ̶egi eote niɡ̶ijoa lotaɡ̶a leeɡ̶odi maleedaɡ̶a dotaɡ̶a, Jesus jaɡ̶aɡ̶a dotaɡ̶a, meeteta, “Niwigo abeyaceɡ̶egi, anotitice niɡ̶ini ɡ̶oneleegiwa!” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Odaa Jesus ja ige niɡ̶ijo niwigo abeyaceɡ̶egi, meeteta, “Igame ɡ̶aboonaɡ̶adi?” Odaa ja igidi, mee, “Iboonaɡ̶adi ‘Eliodi oko’! Leeɡ̶odi moko eliodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Odaa niɡ̶ijo niwigo abeyaceɡ̶egi eliodi me dipokotalo Jesus me daɡ̶a iticoitedicoace me iiɡ̶e moyaladi niɡ̶idi nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Digoida maditaɡ̶a naɡ̶aca wetiɡ̶a onini ica lapo nigidagiwadi, niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Odaa ijoatawece niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a eliodi modipokotibigalo Jesus, moditalo, “Ǥodikaneɡ̶egi me iniɡ̶a jakaɡ̶atiogilo nigidagiwadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Odaa Jesus ja ikatedicoace me igotibeci, odaa niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a ja noditicoaci mijotaɡ̶a niɡ̶ijo ɡ̶oneleegiwa, odaa joɡ̶odakatiogilo nigidagiwadi. Odaa ijotawece niɡ̶ijo lapo nigidagiwadi walediticogi midataɡ̶a wakagi iiɡ̶o, odaa daxaboketiniwace, joɡ̶oceɡ̶aɡ̶a miditaɡ̶a weiigi. Onijoa iniwata miili nigidagiwadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Odaa niɡ̶ijoa ɡ̶oneleegiwadi anoyowie nigidagiwadi ja ialeticoace. Odaa joɡ̶oyatematitedibece manitaɡ̶a nigotaɡ̶a, codaa me niɡ̶inoa nipodaɡ̶a anototalo. Odaa eliodi oko igotibeci oiwi niɡ̶ica niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Niɡ̶ijo noɡ̶ototalo Jesus, odaa joɡ̶onadi niɡ̶ijo ɡ̶oneleegiwa anodakatiogi niwicidi abeyacaɡ̶aɡ̶a. Odaa eliodi me doitibigiwaji niɡ̶ijo noɡ̶onadi niɡ̶ijo ɡ̶oneleegiwa me nicoti, codaa me dinixo, codaa aɡ̶alee yetole. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Niɡ̶ijo anonadi niɡ̶ijo niciagi oyatematitedibece anodaaɡ̶eeteda niɡ̶ijoa nigidagiwadi, codaa niɡ̶ijo ɡ̶oneleegiwa ane dakatiogi niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Odaa joɡ̶odipokotalo Jesus me noditedice niɡ̶idi niiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Niɡ̶ijo Jesus naɡ̶a waxoditedinigi naɡ̶ajo niwatece mopi, niɡ̶ijo ɡ̶oneleegiwa anijo modakatiogi niwicidi abeyacaɡ̶aɡ̶a dipokotibigalo Jesus me domaɡ̶a yemaa me lixigaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pida Jesus ayemaa daɡ̶a yadeegi, odaa meeteta, “Emii, opilitacicogi ɡ̶adiɡ̶eladi, odaa atematiitiogi ɡ̶adoiigiwepodi niɡ̶ica Ǥaniotagodi Aneotedoɡ̶oji meote eliodi aneletaɡ̶adomi, codaa eliodi me ɡ̶adiwikodeni.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Odaa niɡ̶ijo ɡ̶oneleegiwa joɡ̶opi, igo miditaɡ̶a nipodigi ane liboonaɡ̶adi “Deez nigotadi”, odaa yatematitibece ijoatawece niɡ̶icoa Jesus aneotetema. Odaa ijotawece niɡ̶ijo oko eliodi moyopo. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus naɡ̶a diɡ̶etacedita daato weiigi. Odaa ica noiigi-nelegi dinatecoɡ̶oteetelogo liniogotibece weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Onida ica ɡ̶oneleegiwa ane liboonaɡ̶adi Jairo one eledi lacilo liiakanaɡ̶axi judeutedi manitaɡ̶a naɡ̶ani nigotaɡ̶a. Jairo lixigaɡ̶awepodi niɡ̶ijo noiigi-nelegi. Niɡ̶ijo naɡ̶a nadi Jesus, odaa dakagitini lodoe. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Odaa eliodi me dipokotalo Jesus, meetalo, “Jaɡ̶adiaa ionawaana ja doletibige me yeleo. Anagi, ipekeniteloco ɡ̶abaaɡ̶atedi amaleeɡ̶aɡ̶a icí me deelotika, codaa amaleeɡ̶aɡ̶a iwoko némaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Odaa Jesus jiɡ̶igo lixigaɡ̶awa Jairo. Eliodi oko lixigaɡ̶awepodi Jesus codaa diniligice. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Onajo liwigotigi niɡ̶ijo oko aca iwaalo awodina. Joneɡ̶eote dooze nicaaɡ̶ape me leelotagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eliodi migotece dotowexedi, yaaɡ̶adi icoatawece ninyeelo. Codaa eliodi me dawikode me diniwakateetibece, pida aɡ̶ica ane dinilatece, pida jeɡ̶epaanaɡ̶a deelotika. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Niɡ̶ijo naɡ̶a dibodice moyalaɡ̶atalo Jesus, odaa dakatiogi liwigotigi niɡ̶ijo noiigi-nelegi, odaa nowidila Jesus, odaa dibatece nijayogo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Leeɡ̶odi meetibige le, “Nige jakadi mokexaa jiba-aatece nijayogo, odaa ja idici.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Odaa ewi niɡ̶ijo naɡ̶a dibatece nijayogo Jesus, aɡ̶ica daɡ̶a leegi niɡ̶ijoa lawodi ja wakagitege, odaa ja deemitetece lolaadi naɡ̶a icí. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Naɡ̶ajo lakata Jesus yowooɡ̶odi me noditice midoataɡ̶a loniciwaɡ̶a Aneotedoɡ̶oji ane icilatidi naɡ̶ajo iwaalo, odaa naɡ̶a nawiilitetetege niɡ̶ijo lapo-nelegi, odaa ja digika, meetediogi, “Amiijo ica ane dibatece inijayogo?” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Odaa niɡ̶ijo anodiotibece moditalo, “Igame leeɡ̶odi ina magikani mica ane dibataɡ̶aloco, aɡ̶anati minatawece niɡ̶ina oko etiɡ̶adiligiceni?” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pida Jesus niipete liwailidi me doletedibige me nadi niɡ̶ica ane dibatece nijayogo. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Odaa naɡ̶ajo iwaalo jeɡ̶enagi lodoe, odaa yamaɡ̶atedini lokotidi, igaataɡ̶a yowooɡ̶odi mijo ane deemitetece lolaadi. Odaa dawigice, doi, odaa ja yatematitalo Jesus ijoatawece niɡ̶ijoa baanaɡ̶a ixomaɡ̶ateetedice. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Odaa Jesus meeteta, “Iona, ja ɡ̶adicili leeɡ̶odi manakatoni Aneotedoɡ̶oji. Emii, odaa jinaɡ̶alee adinigecaɡ̶aleɡ̶eni. Igaataɡ̶a ewi naɡ̶a ɡ̶adicili.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus eɡ̶idaaɡ̶eeteda me dotaɡ̶a neɡ̶enotibeci ica oko oicoɡ̶oticogi liɡ̶eladi Jairo, niɡ̶ijo lacilo niiakanaɡ̶axi. Odaa joɡ̶owo leemidi Jairo, modita, “Ǥadiona ja yeleo. Aɡ̶alee leeditibige daɡ̶a anigiwocitedice niiɡ̶axinaɡ̶anaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Odaa niɡ̶ijo Jesus naɡ̶a wajipate lotaɡ̶a niɡ̶ijo oko, odaa meeteta Jairo, “Jinaɡ̶adoii, pida anakatoni nimaweneɡ̶egi Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Odaa Jesus aɡ̶ica ane ikatedio me lixigaɡ̶awa, pida ijoka yadeegiteda Pedro, ijaaɡ̶ijo itoataale dinioxomigipi Tiago ijaa João me lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Niɡ̶ijo niɡ̶icotiobeci Jairo liɡ̶eladi, odaa Jesus ja nadi niɡ̶ijo ninyaaɡ̶a, igedi me nacaagaɡ̶ateloco. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Niɡ̶ijo naɡ̶a dakatediwece diimigi, odaa meetediogi, “Igaameni macaagetibecetiwaji, codaa mawiite inoa ɡ̶adayaageɡ̶eco? Naɡ̶adi nigaanawaana ayeleo, pida diote.” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Odaa niɡ̶ijo noiigi joɡ̶oyame. Odaa Jesus ja iiɡ̶e mijotawece noditicoaci. Odaa ja leyakawepodi eliododipi naɡ̶adi nigaanawaana, ijaaɡ̶ijo itoatadiɡ̶ida anodiotibece, odaa dakatediwece catiwedi aneitice lolaadi naɡ̶adi nigaanawaana, anidiwa dooze nicaaɡ̶ape. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Odaa Jesus naɡ̶a dibatedigi libaaɡ̶adi, meeteta, “Talitá cumi!” amina anejinaɡ̶ata “Nigaanawaana, adabititini!” ");
INSERT INTO kbcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Odaa aɡ̶ica daɡ̶a leegi naɡ̶ajo nigaanawaana ja dabiditini, odaa jeɡ̶ewaligi. Pida eliodi me nawelatibigiwaji, codaa moyopo niɡ̶ijo anonadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Odaa Jesus ja najoitacediniwace me doɡ̶oyatemati niɡ̶ida niciagi. Odaa ja diiɡ̶enatakate mowo liweenigi naɡ̶ajo nigaanawaana. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus naɡ̶a noditedice niɡ̶ijo aneite, odaa joɡ̶opitedicogi manitaɡ̶a epaa nigotaɡ̶a lixigaɡ̶awepodi niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Odaa niɡ̶ica naɡ̶a saabado, jiɡ̶igo mani liiakanaɡ̶axi judeutedi, odaa ja dowicenaɡ̶a me diiɡ̶axinaɡ̶a. Odaa eliodi niɡ̶ijo oko ane yatecoɡ̶o oyopo niɡ̶ijo noɡ̶owajipatalo lotaɡ̶a Jesus, odaa dinigetiwage, modi, “Igamige niiɡ̶axinaɡ̶adi me diniiɡ̶axitetece niɡ̶inoa liiɡ̶axinaɡ̶aneɡ̶eco? Amigijo ica ane yajigotalo lixakedi? Igamigodaaɡ̶ee me yakadi meote niɡ̶inoa ɡ̶odoxiceɡ̶etedi? ");
INSERT INTO kbcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Niɡ̶idoa me jowooɡ̶otaɡ̶a geme gapinteelegi, codaa lionigi Maria, nioxoa Tiago, José, Judas ijaa Simão. Idiaa niwaalepodi inaa liɡ̶eladi digoina.” Odaa aɡ̶ele modibatege Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pida Jesus meetediogi, “Niɡ̶ina oko idioka limedi modeemitetibige niɡ̶ina anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Pida inoka doɡ̶odeemitetibige niɡ̶ina niɡ̶eladimigipitigi manitaɡ̶a epaa nigotaɡ̶a, idiaa litacepodi, codaa me loiigiwepodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Odaa Jesus ayakadi meote niɡ̶inoa ɡ̶odoxiceɡ̶etedi nelecoli manitaɡ̶a naɡ̶ani epaa nigotaɡ̶a. Idokida me ipeketedeloco libaaɡ̶atedi onateciɡ̶idiwa eelotaginadi me nicilatiditedini. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Codaa Jesus eliodi me yopo leeɡ̶odi me doɡ̶onakatoteda. Odaa Jesus jiɡ̶igotetece nigotadawaanaɡ̶a niɡ̶idi nipodigi, codaa niiɡ̶axitediniwace oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Odaa eniditediogi niɡ̶ijo dooze anodiotibece, odaa ja iiɡ̶e migotibeci itoataaletibece oyatematitedibece nibodicetedi anele. Maleediɡ̶igotibeci, odaa ja yajigotediogi notoetiigi moyakadi moiticoitedice niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Codaa meetediogi me diɡ̶icata anonibatine me wiajeeɡ̶a. Ijoka yajoitetece moyadeegi ligiilaɡ̶adi. Pida aika doɡ̶owo oyadeegi liawogo, oteɡ̶exaaɡ̶aɡ̶a nixacoola, oteɡ̶exaaɡ̶aɡ̶a dinyeelo catinedi ninyeelaɡ̶axi anonigoetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Odaa iiɡ̶etediogi modinixotinigi liwelatedi, codaa moyadeegi onadateci nitoonicogo. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Odaa niɡ̶idiaaɡ̶idi Jesus jeɡ̶eetediogi, “Nigakaatiwecetiwaji anigini diimigi me idiaaɡ̶onitice, odaa idiaaɡ̶onitice minitaɡ̶a nigepaa limedi manotitice naɡ̶ani nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nige deɡ̶ele modibataɡ̶agitiwaji anigidi niɡ̶eladimigipi, codaa nige doɡ̶oyemaa mowajipatalo ɡ̶adatematiko, odaaɡ̶opili. Niganotiticogitiwaji we, odaa iticiɡ̶i amoɡ̶o midoa ɡ̶awelatedi me ikeenitiogi mepaa icoɡ̶otiogi. Ejitaɡ̶awa niɡ̶ica noko nigicota nige iloikatidi Aneotedoɡ̶oji niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco, iloikatidi niɡ̶idi oko caticedi niɡ̶ijo niɡ̶eladimigipitigi nigotaɡ̶a Sodoma ajaa Gomorra leeɡ̶odi niɡ̶ijo oko daɡ̶axa minoa libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Odaa niɡ̶ijo anodiotibece jiɡ̶igotibeci, oyatematitiogi inatawece oko me leeditibige modinilaatece libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Codaa moiticoitedice owidi niwicidi abeyacaɡ̶aɡ̶a. Codaa moyatikoleteloco lajidi oliveira lacilo eliodi oko eelotaginadi, odaa joɡ̶onicilatiditiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes niɡ̶ijo inionigi-eliodi dibodicetalo icoatawece niɡ̶icoa Jesus loenataka, leeɡ̶odi niɡ̶eladimigipitigi owidi nigotadi oyalaɡ̶atalo. Onica ica oko anodi, “Niɡ̶idoa João Batista Aneotedoɡ̶oji ja yewikatiditace. Joaniɡ̶idaa leeɡ̶odi mida notoetiigi meote niɡ̶inoa ɡ̶odoxiceɡ̶etedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pida ica eledi oko modi, “Niɡ̶idoa Elias.” Odaa ica eledi modi, “Niɡ̶idoa anigepidiɡ̶ica niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, niɡ̶ijo baanaɡ̶a nigo niɡ̶ijo jotigide!” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pida niɡ̶ijo Herodes naɡ̶a wajipatibece moyalaɡ̶atalo niɡ̶ica oko, moditece Jesus, odaa mee, “Ee mejimewi niɡ̶idaaɡ̶ida João Batista, niɡ̶ijo ane jiiɡ̶enatakata moyakagiditice lotoinaɡ̶adi. Ja yewiɡ̶atace!” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Igaataɡ̶a Herodes jiɡ̶ijaa diiɡ̶enatakata moigoetini João, odaa joɡ̶oixotiwece niwiloɡ̶onaɡ̶axi. Eo niɡ̶ida anigota João leeɡ̶ote Herodias, naɡ̶ajo lodawa Filipe, niɡ̶ijo nioxoa iniaaɡ̶ini Herodes. Herodes dibanoonaɡ̶atece Herodias. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Joaniɡ̶idaa leeɡ̶odi João midioka limedi meetibiga Herodes, “Liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji yolitaɡ̶adomi me ɡ̶adodawa ɡ̶anioxoa lodawa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Odaa Herodias eliodi me yelatema João, domaɡ̶a yemaa daɡ̶a yeloadi. Pida aɡ̶ica nimaweneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Igaataɡ̶a Herodes doita João, leeɡ̶odi yowooɡ̶odi João me ɡ̶oneleegiwa ane iɡ̶enaɡ̶a ane dibatema iniokiniwateda Aneotedoɡ̶oji. Odaa Herodes aika diɡ̶ica João ninyaagi. Herodes lemaanigi me wajipata João, pida niɡ̶ijo naɡ̶a wajipatalo lotaɡ̶a, eliodi me doɡ̶owikomata, aɡ̶alee yowooɡ̶odi niɡ̶ica anee. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pida jiɡ̶icota ica noko Herodias me yakadi nimaweneɡ̶egi meo ane beyagitema João. Niɡ̶ica noko me nakatio lanikegi Herodes. Odaa Herodes jeɡ̶eo nalokegi, ja nodetiogi niɡ̶ijo ane niiɡ̶enatakanaɡ̶a ijaaɡ̶ijoa niɡ̶ijoa lacilodi iodaɡ̶awadi codaa me niɡ̶eladimigipitigi ane ɡ̶oneɡ̶aɡ̶a nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Odaa aca liona Herodias ja dakatiwece aneiticoace me nalooɡ̶o, odaa ja dinibaile. Herodes ijaaɡ̶ijo lodenigipi eliodi moyemaa nibaileɡ̶eco. Odaa inionigi-eliodi Herodes meeta naɡ̶ajo awicije, “Anipokitiwa niɡ̶ica anemaani, odaa jajigotaɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Odaa jeɡ̶eo ligegitege, meeta, “Okanicodaaɡ̶ica ananipokitiwa, jajigotaɡ̶awa, codaa me liwai inatawece niɡ̶ina ane jiiɡ̶e.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Odaa naɡ̶ajo awicije ja noditice, odaa jiɡ̶igo ige naɡ̶ajo eliodo, meeta, “Amiini ica ane jipokotigi?” Odaa niniɡ̶odi, meeta, “Ipokita lacilo João Batista.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Odaa aɡ̶ica daɡ̶a leegi naɡ̶ajo awicije ja yediiɡ̶a me dakatacio minitaɡ̶a inionigi-eliodi, odaa meeta, “Jemaa lacilo João Batista exakitinigi ɡ̶inogo niɡ̶ina natigide.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Odaa niɡ̶ijo inionigi-eliodi eliodi magecaɡ̶alo. Pida ayemaa me anojicetema naɡ̶ajo awicije leeɡ̶odi jeɡ̶eo ligegitege, codaa leeɡ̶odi niɡ̶ijo nodenigipi moiwita. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Odaa aɡ̶ica daɡ̶a leegi ja iiɡ̶e onijoteci niɡ̶ijoa iodaɡ̶awadi migo manitaɡ̶a niwiloɡ̶onaɡ̶axi me yakagiditice lotoinaɡ̶adi João. Odaa niɡ̶ijo iodaɡ̶awa jiɡ̶igo, odaa ja yakagiditice João lotoinaɡ̶adi manitaɡ̶a niwiloɡ̶onaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Odaa ja nadeegi João lacilo yexaɡ̶atinigi ɡ̶inogo, odaa ja yajigota naɡ̶ajo awicije. Odaa naɡ̶ajo awicije jiɡ̶igo yajigota naɡ̶ajo eliodo. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Niɡ̶ijo noɡ̶odibodiceta niɡ̶ijo anodiotibeci João niɡ̶ida niciagi, jiɡ̶igotibeci aneitice, odaa joɡ̶oyadeegi lolaadi João, monaligitini. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Niɡ̶ijoa dooze ɡ̶oneleegiwadi ane iiɡ̶e Jesus moyatemati latematigo naɡ̶a dopitibeci, odaa joɡ̶oyatematitalo Jesus ijoatawece loenataka codaa ane odiiɡ̶axinaɡ̶atece. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Odaa Jesus meetediogi, “Anagi! Iniɡ̶a mokomokoko miditaɡ̶a nipodigi ane daxixe ane diɡ̶ica niɡ̶eladimigipi me inipenakawaanigi.” Leeɡ̶odi eliodi oko igotibeci miditaɡ̶a, inaaɡ̶eledi baanaɡ̶a dopitibeci, odaa Jesus ijaaɡ̶ijo anodiotibece aɡ̶aleeɡ̶ica nimedi me niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Odaa joɡ̶owaxoditinigi aca niwatece, odaa ijokijo migotibeci miditaɡ̶a nipodigi ane daxixe, ane diɡ̶ica oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pida eliodi oko onadi niɡ̶ijo naɡ̶a noditicoaci, codaa oyowooɡ̶odi niɡ̶ijaaɡ̶ijo. Odaa niɡ̶ijo oko waleditece liniogotibece weiigi. Niɡ̶ica oko oicoɡ̶oticogi inoatawece ane nigotadawaanaɡ̶a, odaa odoejedipi mototicogi ane diitedicogi Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Niɡ̶ijo Jesus naɡ̶a waxoditedice naɡ̶ajo niwatece, odaa ja nadi niɡ̶ijo noiigi-nelegi. Odaa eliodi me iwikodetediogi, leeɡ̶odi iciaceeketetege niɡ̶inoa waxacocoli ane diɡ̶ica nowienoɡ̶odi. Odaa jiɡ̶idaaɡ̶eyatedigi me niiɡ̶axitediniwace niɡ̶ijo oko, codaa owidi niɡ̶icoa ane iiɡ̶axitetece. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Niɡ̶ijo naɡ̶a doletibige me dawike, niɡ̶ijo anodiotibece Jesus jiɡ̶igotibeci midoataɡ̶a, odaa moditalo, “Niɡ̶ina nipodigi anejonaɡ̶a aɡ̶ica niɡ̶eladimigipi codaa ja ɡ̶ocidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iiɡ̶eni niɡ̶ina noiigi mopitibeci, amaleeɡ̶aɡ̶a igotibeci niɡ̶inoa bajeendatedi inaaɡ̶inoa nigotadawaanaɡ̶a modinoojetetibige liweenigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pida Jesus ja igidi, meetediogi, “Akamaɡ̶akaamitiwaji ajicitiogi anoyeligo niɡ̶ina noiigi!” Odaa niɡ̶ijo anodiotibece moditalo, “Okomoɡ̶oko jinoojeteeɡ̶atibige paon anoyeligo? Igaataɡ̶a loojedi dibata iniwata-taalia beexotedi, ane loojedi oito epenaitedi me jibaaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Odaa Jesus meetediogi, “Digemii awini! Igame liwokodi ɡ̶anipaontedi?” Odaa jiɡ̶igotibeci oiwi, odaa moditalo, “Idiwa onexaa ciinco paontedi idiaaɡ̶idiwa itiodataale noɡ̶ojedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Odaa Jesus ja iiɡ̶e niɡ̶ijo noiigi-nelegi me dilapodetibece me nicotiniwace miditaɡ̶a nadegocawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Odaa ja nicotiniwace ini lapo anidiwa onaniteci taalia oko, iniaaɡ̶eledi lapo onidiwa meya-taalia oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Odaa Jesus ja dibatetege niɡ̶ijoa ciinco paontedi ijaaɡ̶ijoa itiwataale noɡ̶ojedi, naɡ̶a iwitedibigimece ditibigimedi, odaa ja diniotagodeteta Aneotedoɡ̶oji. Odaa ja inoketedigi liwigotigi niɡ̶ijoa paontedi, odaa yajigotediogi niɡ̶ijo anodiotibece monediatiniwace niɡ̶idi noiigi-nelegi. Odaa jaɡ̶aɡ̶a ninoketedini niɡ̶ijoa noɡ̶ojedi, odaa joɡ̶oyajigotiogi niɡ̶idi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Odaa iditawece niɡ̶idi oko niodaɡ̶a, codaa nitiminaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Niɡ̶idiaaɡ̶idi niɡ̶ijo anodiotibece joɡ̶onoleenaɡ̶adi dooze etacani liwailidi niɡ̶ijoa paontedi ijaaɡ̶ijoa noɡ̶ojedi ane iiɡ̶otedice anoyapitelogo niɡ̶ijo oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Onicoa ciinco miili ɡ̶oneleegiwadi ane niodaɡ̶a, pida baadoɡ̶onilaɡ̶adi nigaanigipawaanigi idiaa iwaalepodi anaɡ̶aɡ̶a niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aɡ̶ica daɡ̶a leegi Jesus iiɡ̶e niɡ̶ijo anodiotibece mowaxoditinigi naɡ̶ajo niwatece me dinewadetibigiwaji manitaɡ̶a nigotakawaana ane liboonaɡ̶adi Betsaida ane idei daato weiigi. Iiɡ̶e me igotibeci, niɡ̶ijo naɡ̶a ibodetediogi niɡ̶ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Niɡ̶idiaaɡ̶idi naɡ̶a ibodetediogi niɡ̶ijo noiigi-nelegi, Jesus jiɡ̶igo manitaɡ̶a aca wetiɡ̶a me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Niɡ̶ijo naɡ̶a doletibige me dalimeti aligeɡ̶e, naɡ̶ajo niwatece ideitice liwigotinigi niɡ̶ijo weiigi, idaa Jesus neniɡ̶idoatece digoida daato weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pida naditediogi niɡ̶ijo anodiotibece me dinoniciwaɡ̶aditibigiwaji me nolaakanaɡ̶a, leeɡ̶odi odiitege niocodi. Niɡ̶ijo naɡ̶a ixomaɡ̶atedice iniwatadaɡ̶ani lakata me nigoitijo, maleedaɡ̶a yeloɡ̶otigi, Jesus jiɡ̶igo miditaɡ̶a. Ewaligitedeloco ninyoɡ̶odi, odaa domaɡ̶a yewegitedijo. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Niɡ̶ijo noɡ̶onadi Jesus mewaligitedeloco ditibigimedi ninyoɡ̶odi, odaa odiletibige daɡ̶a niwigo, odaa napaawaɡ̶ateloco. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nacaagaɡ̶ateloco leeɡ̶odi iditawece onaditege, odaa eliodi me doitibigiwaji. Pida aɡ̶ica daɡ̶a leegi Jesus meetediogi, “Eloodaɡ̶ateeni ɡ̶adaaleɡ̶enalitiwaji! Jeɡ̶emeɡ̶ee! Jinaɡ̶adoiitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Odaa ja waxoditedinigi naɡ̶ajo niwatece, odaa niɡ̶ijo niocodi ja notokoti. Eliodi me nawelatibigiwaji, codaa aɡ̶aleeɡ̶oyowooɡ̶odi anee. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Igaataɡ̶a aɡ̶oyowooɡ̶odi niɡ̶ica notoetiigi, idaaɡ̶ee monadi niɡ̶ijo ɡ̶odoxiceɡ̶edi aneote naɡ̶a yowidaɡ̶atee niɡ̶ijoa paontedi, leeɡ̶odi me dakake laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Niɡ̶ijo naɡ̶a diɡ̶etitacicoace daato weiigi, odaa joɡ̶otota nipodigi Genesaré, odaa joɡ̶oigoetini naɡ̶ajo niwatece liniogotibece weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Niɡ̶ijo naɡ̶a waxoditicoace naɡ̶ajo niwatece, aɡ̶ica daɡ̶a leegi, niɡ̶ijo oko joɡ̶oyowooɡ̶oditege Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Odaa joɡ̶owalediteloco iditawece nipodigi, onadeegitalo niɡ̶inoa eelotaginadi, niɡ̶ina baanaɡ̶a odiwoteloco nipe. Oyadeegiticogi niɡ̶ijo anodi migotetece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Odaa Jesus igotetedeloco niɡ̶icoa nigotadawaanaɡ̶a, nigotadi codaa me nipodaɡ̶a. Icoatawece niɡ̶icoa ane licoli, odaa idiaaɡ̶oyaticoace niɡ̶ijoa eelotaginadi aneitice niɡ̶ina oko me dakapetibigiwage, odaa niɡ̶ijo oko odipokotalo Jesus me ika niɡ̶ijoa eelotaginadi mokexaa odibateloco laxabi nijayogo. Odaa ijotawece niɡ̶ijo eelotaginadi anodibateloco nijayogo ja nicilaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Niɡ̶ijoa fariseutedi ijaaɡ̶ijoa icoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés oicoɡ̶oticogi nigotaɡ̶a Jerusalém. Odaa oyatecoɡ̶otelogo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Onadi anigepidiɡ̶ica niɡ̶ijo anodiotibece Jesus moyeligo paon me doɡ̶oiwilegiteda libaaɡ̶atedi, odaa joɡ̶odinapeteɡ̶etege, leeɡ̶odi baɡ̶a lakatigi niɡ̶ijoa fariseutedi mecoɡ̶otace niwilecaɡ̶a nigepaa nige niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Leeɡ̶odi niɡ̶ijoa fariseutedi codaa miditawece noiigi judeutedi odioteci lakatigi niɡ̶ica laamipi. Aɡ̶ica anoyeligo nige deɡ̶ele moiwilegi libaaɡ̶atedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Niɡ̶ijo naɡ̶a dopiticoace moicoɡ̶oticogi balaacogolawaanaɡ̶a aneitedice niɡ̶inoa enaanaɡ̶a, odaa ja diniwilegitibigiwaji. Codaa odioteci niɡ̶icoa eletidi nakataɡ̶a, niɡ̶ina moiwilegi goopatedi, bootitedi nelecoli, nooleli, codaa me nipeli. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Odaa niɡ̶ijoa fariseutedi ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece najoinaɡ̶aneɡ̶eco oige Jesus, moditalo, “Igame leeɡ̶odi idiwa anodiotibigaɡ̶adici me doɡ̶odioteci lakataɡ̶a ɡ̶odaamipi, niodaɡ̶a me doɡ̶oiwilegiteda libaaɡ̶atedi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus niniɡ̶odi, meetediogi, “Akaamitiwaji niɡ̶ina anokeo mele! Isaías, niɡ̶ijo ane yatematitedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, eetece niɡ̶ina anewi, niɡ̶ijo naɡ̶a yalaɡ̶ataɡ̶awatiwaji. Maditaɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji iwoteloco niɡ̶ica Isaías ane yalaɡ̶ata, niɡ̶ijo neɡ̶ee niɡ̶ica Aneotedoɡ̶oji ligegi, anee, ‘Niɡ̶idi noiigi etidiweniɡ̶ide niɡ̶ina me notaɡ̶anaɡ̶a, pida aɡ̶etidemaa catiwedi laaleɡ̶enali, codaa leegitiwa metidetecetice. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aɡ̶ica jaoɡ̶a niɡ̶ina modoɡ̶etetiwa, igaataɡ̶a odiiɡ̶axinaɡ̶atece niɡ̶inoa lowooko niɡ̶ina oko micataɡ̶a daɡ̶a yowooko.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Odaa akaamitiwaji jiɡ̶ikani niɡ̶inoa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji, pida jiɡ̶iwitecetiwaji lakataɡ̶a niɡ̶inoa ɡ̶oneleegiwadi niɡ̶ina moiwilegi bootitedi, goopatedi, codaa mawii niɡ̶inoa eletidi anicinoa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Odaa Jesus meetediogi, “Inoa owidi ɡ̶animaweneɡ̶ecotiwaji me daɡ̶awii niɡ̶ijo liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji awiitibige makati me iwitece niɡ̶inoa akamaɡ̶a ɡ̶adakataɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Igaataɡ̶a Moisés mee niɡ̶ijo jotigide, ‘Aweniɡ̶ideni ɡ̶adiodi aniaa ɡ̶adiodo!’ Codaa eledi mee, ‘Leeditibige moyeloadi niɡ̶ijo oko ane beyagi me dotaɡ̶atibige eliodi codaa me eliodo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pida menitibecetiwaji nigica oko anida nimaweneɡ̶egi me yaxawa eliodi codaa me eliodo, pida nigeeta eliodi aniaa eliodo, ‘Ida Corban’ (ane diitigi ‘iboonigi ane jajigotalo Aneotedoɡ̶oji’). Odaa aɡ̶alee leeditibige me yaxawa eliodi aniaa eliodo. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Niɡ̶ida aneni aɡ̶aleeɡ̶ikanitiwaji niɡ̶ijo oko me yaxawa eliodi aniaa eliodo. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaɡ̶awiitiwaji me diɡ̶ica ane jaoɡ̶a liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji leeɡ̶odi me iwitecetiwaji lakataɡ̶a anetiɡ̶adiiɡ̶axinitece ɡ̶adaamipi. Jiɡ̶inoatiwaji owidi eletidi ɡ̶abatico niɡ̶ida ɡ̶abatiigi anejita.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus eniditacediogi niɡ̶ijo noiigi menagitacibeci midoataɡ̶a, odaa meetediogi, “Akaamitawecetiwaji, ajipaatalo niɡ̶inoa yotaɡ̶a, codaa jemaa mowooɡ̶otitiwaji! ");
INSERT INTO kbcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Inoatawece ane jelicaɡ̶a jakataɡ̶ate we, odaa dakatiwece ɡ̶onioladi. Odaa niɡ̶ina ane icoɡ̶oticogi we anapioyaɡ̶adi ɡ̶odaaleɡ̶ena. Pida niɡ̶inoa notaɡ̶a ane noditedicogi ɡ̶onioladi, inaaɡ̶inoa ɡ̶olidaɡ̶ataka ane icoɡ̶otiwece ɡ̶odaaleɡ̶ena, jiɡ̶inaaɡ̶owo me napioi ɡ̶odaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Niɡ̶ina oko anowajipatalo yotaɡ̶a leeditibige mowatacotece.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Niɡ̶ijo Jesus naɡ̶a yetecetedicoace niɡ̶ijo noiigi-nelegi, ja dakatediwece diimigi, odaa niɡ̶ijo anodiotibece joɡ̶oige, moditalo, “Igame diitigilo ijoa ɡ̶adotaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Odaa meetediogi, “Latopiwatigi me daɡ̶aɡ̶ica anaɡ̶aɡ̶a owooɡ̶otitiwaji. Ǥoweenigi ane dakatiwece ɡ̶onioladi ayakadi me napioyaɡ̶adi ɡ̶odaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Igaataɡ̶a niɡ̶ina niweenigi adakatiwece ɡ̶odaaleɡ̶ena, pida baɡ̶a dakatinece ɡ̶owokomaɡ̶a, odaa niɡ̶idiaaɡ̶idi ja noditice.” (Jiɡ̶idaaɡ̶ee Jesus me ikee me jakataɡ̶a me jelicaɡ̶a okanicodaaɡ̶ica niweenigi.) ");
INSERT INTO kbcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Odaa Jesus eledi yalaɡ̶ate, mee, “Niɡ̶ica ane napioyaɡ̶adi niɡ̶ina oko laaleɡ̶ena niɡ̶ina ane noditice, ane icoɡ̶otiwece laaleɡ̶ena, codaa niɡ̶inoa lotaɡ̶a ane icoɡ̶otiwece nioladi. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Igaataɡ̶a digawini niɡ̶ina ane icoɡ̶otiwece ɡ̶odaaleɡ̶ena; ɡ̶odowooko ane beyagi, ina me jilidaɡ̶ataɡ̶a me ɡ̶odoomatewa lodawa eledi oko, codaa me ewocomigipi, ina me jilidaɡ̶ataɡ̶a me jolicaɡ̶a, codaa me jaijeeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Odaa catiwedi ɡ̶odaaleɡ̶ena icoɡ̶otiwece ɡ̶olidekico, codaa me jilidaɡ̶ataɡ̶a me jaoɡ̶a okanicodaaɡ̶ica ane beyagi, codaa me jiwitakaɡ̶a, codaa me jaoɡ̶a okanicodaaɡ̶ica niɡ̶ina ɡ̶odolaadi ane yemaa meo, ina me ɡ̶odocetema eledi oko, codaa me beyagi me jotaɡ̶anaɡ̶atibige eledi oko, codaa meo moko anaɡ̶axakeneɡ̶egi, codaa niɡ̶inoa ɡ̶olidaɡ̶ataka owo me beyagi me jowookonaɡ̶a micataɡ̶a niɡ̶ina yetole. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Inatawece niɡ̶ina ane beyagi icoɡ̶otiwece catiwedi ɡ̶odaaleɡ̶ena, odaa jeɡ̶eo me napioi ɡ̶odaaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus noditedice niɡ̶ijo aneitedice, odaa jiɡ̶igo nipodigi ane ipegitege niɡ̶ijoa nigotadi Tiro aniaa Sidom. Niɡ̶ijo niɡ̶icotedio, odaa naɡ̶a dakatediwece ica diimigi, adomaɡ̶a yemaa diɡ̶ica ane yowooɡ̶odi miniwa catiwedi diimigi. Pida aɡ̶ica nimaweneɡ̶egi me dinaɡ̶aditedini. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Onaca aca iwaalo ane daɡ̶a judeu, pida loiigi siro-fenícia. Onani aca liona ane dakatiogi niwigo abeyaceɡ̶egi. Niɡ̶ijo naɡ̶a dibodicetigi Jesus, odaa aɡ̶ica daɡ̶a leegi, odaa jiɡ̶igo midoataɡ̶a, odaa ja yamaɡ̶atedini lokotidi lodoe. Odaa eliodi me dipokotalo Jesus me iticoitedice niɡ̶ijo niwigo abeyaceɡ̶egi ane dakatiogi liona. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pida Jesus meeteta, “Niɡ̶ina me niodaɡ̶a, leeditibige modoejedipi nionigipi me niodaɡ̶a. Igaataɡ̶a aɡ̶ele doɡ̶onoɡ̶a liweenigi nionigipi, oditaɡ̶a oyajigotiogi necexodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pida naɡ̶ajo iwaalo ja igidi, meetalo, “Ewi, Iniwa-aagodi. Pida niɡ̶inoda necexodawaanaɡ̶a ane idi-iite catiwedi nameeja oyeligo niɡ̶inoa latijedi niɡ̶ina niga-aanigipawaanigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Odaa Jesus ja igidi, meeteta, “Leeɡ̶odi niɡ̶inoa ɡ̶adotaɡ̶a ane ikee manakatoni Aneotedoɡ̶oji, opiliticogi ɡ̶adiɡ̶eladi, igaataɡ̶a niwigo abeyaceɡ̶egi ja noditice majotaɡ̶a naɡ̶ajo ɡ̶adiona.” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naɡ̶ajo iwaalo niɡ̶icoticogi liɡ̶eladi, odaa icoteloco naɡ̶ajo liona me iwoteloco nipe, codaa niɡ̶ijo niwigo abeyaceɡ̶egi aɡ̶aleeɡ̶ica, ja noditice majotaɡ̶a naɡ̶ajo liona. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Niɡ̶idiaaɡ̶idi Jesus ja noditedicogi niɡ̶idi nipodigi ane ipegitege niɡ̶ijoa nigotadi Tiro aniaa Sidom, odaa ja ixomaɡ̶atedicogi nipodigi ane liboonaɡ̶adi “Deez nigotadi”, odaa jiɡ̶icotedicogi miditaɡ̶a niweiigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Odaa joɡ̶onadeegitalo Jesus ica ɡ̶oneleegiwa aticilonaɡ̶a codaa me ewaloɡ̶onaɡ̶a, odaa joɡ̶odipokotalo Jesus me ipeketedeloco libaaɡ̶atedi niɡ̶ijo ɡ̶oneleegiwa me icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus yadeegitedicogi niɡ̶ijo ɡ̶oneleegiwa wetice niɡ̶ijo noiigi-nelegi, odaa yojogotediwece napaaɡ̶ate niɡ̶ijo ɡ̶oneleegiwa yatite nibedona. Codaa yawale nibedona, odaa ja dibatedeloco loceligi niɡ̶ijo ɡ̶oneleegiwa yocelate lawale. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Odaa iwitedibigimece ditibigimedi, odaa nikatedice laadi. Odaa mee, “Efatá!” niɡ̶ina anejinaɡ̶ata, “Omoke!” ");
INSERT INTO kbcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo ɡ̶oneleegiwa ja wajipa, codaa jeɡ̶ele loceligi, odaa ja yakadi me dotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus iiɡ̶e niɡ̶ijo anonadi me doɡ̶oyatemati niɡ̶ijo ɡ̶odoxiceɡ̶edi. Pida idaaɡ̶ida me domaɡ̶a iiɡ̶etediogi me doɡ̶oyatemati, pida joɡ̶oyatemati oiɡ̶axake niɡ̶ijo anonadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Niɡ̶ijo oko eliodi moyopo, odaa modi, “Inoatawece aneote, ele meote. Codaa eote niɡ̶inoa aticilonadi me najipaaɡ̶a, codaa niɡ̶inoa ewaloɡ̶onadi me notaɡ̶anaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Niɡ̶ijoa nokododi dinatecoɡ̶oteetace niɡ̶ica noiigi-nelegi, codaa aɡ̶aleeɡ̶ica gaantokaaɡ̶ini anoyeligo. Odaa Jesus jeɡ̶eniditediogi niɡ̶ijo anodiotibece migotibeci midoataɡ̶a, odaa meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ja jiwikode niɡ̶ina noiigi, igaataɡ̶a jeɡ̶eote itoatadiɡ̶ida nokododi mina meetaɡ̶a, odaa aɡ̶aleeɡ̶ica gaantokaaɡ̶idi anoyeligo. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Daɡ̶a jiiɡ̶eticogi liɡ̶elatedi me diɡ̶icata anoyeligo, odaa daɡ̶a yemaa idi anenitiniwace naigitece leeɡ̶odi nabocaɡ̶a, igaataɡ̶a idi ane icoɡ̶oticogi ditigedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Odaa niɡ̶ijo anodiotibece joɡ̶oigidi, moditalo, “Igamigetiɡ̶ida ica ɡ̶onimaweneɡ̶egi me jakataɡ̶a paontedi me jiniodeɡ̶enaɡ̶atiniwace niɡ̶idi noiigi-nelegi? Igaataɡ̶a niɡ̶ina nipodigi aɡ̶ica niɡ̶eladimigipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Odaa Jesus ja nigetediniwace, meetediogi, “Igame liwokodi ɡ̶anipaontedi?” Odaa joɡ̶oigidi, moditalo, “Idiwa seete paontedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Odaa Jesus ja iiɡ̶e niɡ̶ijo noiigi-nelegi monicotinigiiɡ̶o. Odaa ja dibate niɡ̶ijoa seete paontedi, odaa diniotagodete Aneotedoɡ̶oji. Odaa naɡ̶a inoketedigi liwigotigi niɡ̶ijoa paontedi, odaa ja yajigotediogi niɡ̶ijo anodiotibece monediatiniwace niɡ̶idi noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Codaa aaɡ̶aɡ̶a idiwa onateciɡ̶idiwa noɡ̶ojedawaanaɡ̶a. Odaa Jesus diniotagodete Aneotedoɡ̶oji leeɡ̶odi niɡ̶ijoa noɡ̶ojedawaanaɡ̶a, odaa jaɡ̶aɡ̶a iiɡ̶e niɡ̶ijo anodiotibece moyajigotiogi niɡ̶idi noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Odaa ijotawece niɡ̶ijo noiigi niodaɡ̶a, codaa nitiminaɡ̶a. Niɡ̶idiaaɡ̶idi niɡ̶ijo anodiotibece Jesus joɡ̶onioda niɡ̶ijoa liwailidi ane iiɡ̶otedice liwai paontedi ijaaɡ̶ijoa noɡ̶ojedawaanaɡ̶a, odaa joɡ̶onoleenaɡ̶adi seete etacanitedi nelecoli. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ejime cwaatolo miili oko ane niodaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Niɡ̶idiaaɡ̶idi Jesus ja iiɡ̶e mopitibeci niɡ̶ijo noiigi-nelegi, odaa aɡ̶ica daɡ̶a leegi ja waxoditedinigi naɡ̶ajo niwatece ijaaɡ̶ijo anodiotibece, odaa jiɡ̶igotibeci nipodigi Dalmanuta. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Icoa fariseutedi igotibeci midoataɡ̶a Jesus, odaa jiɡ̶idaaɡ̶oyatigi modinotigimadetege. Odineetalo Jesus, joaniɡ̶idaa leeɡ̶odi modipokotalo meote ɡ̶odoxiceɡ̶edi ane ikee mida nimaweneɡ̶egi Aneotedoɡ̶oji midoataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Odaa Jesus nikatedice laadi leeɡ̶odi yopo laaleɡ̶enali me daɡ̶axa me dakake, odaa meete, “Igame leeɡ̶odi niɡ̶ina oko ane newiɡ̶a niɡ̶inoa nokododi monipokotiwa me jao ɡ̶odoxiceɡ̶edi me jikee me idimonya Aneotedoɡ̶oji? Ejitaɡ̶awatiwaji ajao ɡ̶odoxiceɡ̶edi lodoe niɡ̶ina oko me jikee Aneotedoɡ̶oji me idimonya.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Odaa Jesus ja yetecetedicoace niɡ̶ijoa fariseutedi. Ja waxoditacedinigi naɡ̶ajo niwatece, odaa jiɡ̶igotace daato weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Niɡ̶ijo anodiotibece Jesus oyaagiditece doɡ̶oyadeegi paon. Pida onidi oniditeci paon mijotaɡ̶a catinedi naɡ̶ajo niwatece. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Odaa Jesus jeɡ̶eote leemidi, meetediogi, “Digawinitiwaji! Adinowetitege nabookojegi fariseutedi ijaa inionigi Herodes!” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Odaa jiɡ̶idaa diiticogi me dinotigimadetiwage, modi, “Eote niɡ̶ida ligegitedoɡ̶owa leeɡ̶odi me daɡ̶a inadeegaɡ̶ateda paontedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus yowooɡ̶odi niɡ̶ijo anodinotigimadetigi, odaa meetediogi, “Igame leeɡ̶odi madinotigimadenitiwage me diɡ̶icoa ɡ̶anipaonteditiwaji manadeegi? Icaaɡ̶ina daɡ̶alee doɡ̶owooɡ̶otitiwaji niɡ̶ijoa ananati. Codaa icaaɡ̶ina daɡ̶a akakaɡ̶ati ɡ̶adaaleɡ̶enalitiwaji me daɡ̶a adinakatoni. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Idiwa ɡ̶agecooɡ̶eli, pida agodoɡ̶owooɡ̶otitiwaji niɡ̶inoa ananati. Codaa idiwa ɡ̶anapaaɡ̶atedi, pida agodoɡ̶owooɡ̶otitiwaji niɡ̶inoa anajipaatalo. Aɡ̶analakitibigetiwaji niɡ̶ijoa yoenataka. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Niɡ̶ijo naɡ̶a ininoketedini niɡ̶ijoa ciinco paontedi, odaa ja jiniodeɡ̶etedini niɡ̶ijoa ciinco miili ɡ̶oneleegiwadi, igame liwokodi etacanitedi nelecoli ane nolee liwailidi ane iiɡ̶otedice ananiodaatiwaji?” Odaa joɡ̶oigidi, moditalo, “Niɡ̶ijo noko jenaɡ̶atigilo dooze etacanitedi nelecoli.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Odaa Jesus ja nigetacediniwace, meetediogi, “Codaa niɡ̶ijo naɡ̶a ininoketedini niɡ̶ijoa seete paontedi me jajigotiogi niɡ̶ijoa cwaatolo miili oko, igame liwokodi etacanitedi nelecoli ane nolee liwailidi ane iiɡ̶otedice ane aniodaa?” Odaa joɡ̶oniniɡ̶odi, moditalo, “Niɡ̶ijo noko baɡ̶a jenaɡ̶atigilo seete etacanitedi niɡ̶inoa nelecoli.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Odaa Jesus meetediogi, “Pida ica ina daɡ̶alee doɡ̶owooɡ̶otitedatiwaji niɡ̶ijoa ananati.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece joɡ̶ototicogi manitaɡ̶a nigotakawaana Betsaida. Ijo ica oko anonadeegitalo ica etoinaɡ̶a, odaa joɡ̶odipokotalo me dibatedeloco me icilatidi niɡ̶ijo etoinaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Odaa Jesus ja dibatedigi libaaɡ̶adi niɡ̶ijo etoinaɡ̶a, odaa noɡ̶atedicogi naɡ̶ani nigotakawaana. Odaa Jesus yawaletediwece ligecooɡ̶eli niɡ̶ijo etoinaɡ̶a, odaa ja dibatedeloco ligecooɡ̶eli, odaa ja ige, meeteta, “Niɡ̶ica ananati?” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Odaa niɡ̶ijo ɡ̶oneleegiwa naɡ̶a nawacetibige lacilo me dole, odaa mee, “Jinadi niɡ̶ina oko midiaanaɡ̶adi, pida liciagi niɡ̶inoa nialeli.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Odaa Jesus ja dibatacetedeloco ligecooɡ̶eli niɡ̶ijo etoinaɡ̶a, odaa iiɡ̶etaceda me doletibece. Odaa aɡ̶ica daɡ̶a leegi ligecooɡ̶eli niɡ̶ijo ɡ̶oneleegiwa ja icí, odaa yakadi mepaanaɡ̶a doletibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Odaa Jesus ja iiɡ̶e mopiticogi liɡ̶eladi, codaa meeteta, “Jinaɡ̶akaatiwece naɡ̶ani nigotakawaana, codaa jiniɡ̶ica anatematiita manitaɡ̶a naɡ̶ani nigotakawaana niɡ̶ida ane jaotaɡ̶adomi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ica noko Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece jiɡ̶igotibeci midiwataɡ̶a nigotadawaanaɡ̶a miditaɡ̶a nipodigi ane liboonaɡ̶adi “Cesaréia Filipe ane dabiteɡ̶etini”. Odaa naigitece mewaligitibigiwaji, Jesus nigetediniwace, meetediogi, “Ina oko, amigida ica anodiletibige ane Ee?” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Odaa joniɡ̶ica anoigidi, moditalo, “Inatecibece oko modi makaami João Batista, pida inatecibece eledi modi makaami Elias, codaa ina eledi boɡ̶oditibige makaami anigepidiɡ̶ica niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Odaa jaɡ̶aɡ̶a nigetediniwace, meetediogi, “Pida baɡ̶akaamitiwaji, amakati me Ee?” Odaa Pedro ja niniɡ̶odi, meetalo, “Akaami Niɡ̶ijo Aneotedoɡ̶oji ane niiɡ̶e ɡ̶odatamaɡ̶ateeneɡ̶egitege ɡ̶odaxakawepodi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Odaa Jesus ja najoitediniwace me doɡ̶oyatematitibece anijoa. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Odaa Jesus jiɡ̶idaaɡ̶eyatedigi me niiɡ̶axitediniwace niɡ̶ijo anodiotibece me leeditibige meliodi me dawikode, mijoa me Ǥoneleegiwa ane icoɡ̶otedibigimece ditibigimedi. Codaa me leeditibige niɡ̶ijo laxokodipi lacilodi niɡ̶idi noiigi, ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, miditawece aɡ̶odibatege Jesus. Codaa me leeditibige me yeleo, pida yewiɡ̶atace nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus iɡ̶enaɡ̶atece niɡ̶ijoa lotaɡ̶a. Odaa Pedro ja yadeegitedice me ideite liwigotigi niɡ̶ijo anodiotibece, odaa jiɡ̶idaaɡ̶eyatigi me yapeteɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pida Jesus nilokotediogi, me niipetediogi niɡ̶ijo anodiotibece, odaa ja yapeteɡ̶e Pedro, meeteta, “Otonitice yodoe, Satanás! Niɡ̶ida makaami mowookoni ɡ̶adiciagi niɡ̶ina eledi oko me nowookonaɡ̶a, pida aɡ̶owookoni daɡ̶a ɡ̶adiciagi Aneotedoɡ̶oji me dowooko.” ");
INSERT INTO kbcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Niɡ̶idiaaɡ̶idi Jesus eniditediogi niɡ̶ijo noiigi-nelegi ijaaɡ̶ijo anodiotibece me enagitibeci midoataɡ̶a. Odaa meetediogi, “Nigica oko ane yemaa me niotici, leeditibige me ika me dioteci niɡ̶ica anepaa yemaa, codaa leeditibige me igotema me dawikode nigepaa yeleo inoatawece nokododi, codaa me igotema moyametibigo leeɡ̶odi me niotici, odaa baɡ̶a yakadi me niotici. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Igaataɡ̶a niɡ̶ina oko aninoka doletibige me dinowedi, niɡ̶ini oko icota me yeleo nigepaa ganigicatibige. Pida niɡ̶ina oko ane yeleo leeɡ̶odi me niotici, codaa me leeɡ̶odi me yatematitedibece nibodicetedi anele anoyalaɡ̶atiwa, niɡ̶ini oko baɡ̶a yewiɡ̶atace nigidiaaɡ̶idi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nigica oko ane yakadi inoatawece aninoa niɡ̶ina iiɡ̶o, pida nige yeleo, odaa aɡ̶ica aneletema ijoatawece niɡ̶ijo ane yakadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Niɡ̶ina oko aɡ̶ica gaantokaaɡ̶ini ane yakadi me yajigotalo Aneotedoɡ̶oji me yakadi lewiɡ̶a ane diɡ̶ica liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Odaa niɡ̶ina oko ane dinibolikatiditici, codaa me dinibolikatiditece niɡ̶inoa yotaɡ̶a niɡ̶ina mini liwigotigi niɡ̶ina oko ane diɡ̶ika mowo doɡ̶onakato Aneotedoɡ̶oji niɡ̶inoa nokododi, codaa aneliodi me abeyacaɡ̶aɡ̶a, odaa aaɡ̶aɡ̶a idinibolikatiditece niɡ̶ina oko ane dinibolikatiditici nige idopitacijo me ixigaɡ̶awepodi niɡ̶ijoa aanjotedi anodibatema iniokiniwateda Aneotedoɡ̶oji. Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, jikee inaɡ̶atetigi me iciagi Eiodi naɡ̶atetigi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Odaa Jesus meetediogi niɡ̶ijo noiigi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Inatibece oko digoina anaɡ̶a nigo nigonadi Aneotedoɡ̶oji nigidaaɡ̶eyatedigi me iiɡ̶e laaleɡ̶enali oko yatite nimaweneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Naɡ̶a ixomaɡ̶atedijo seis nokododi, odaa Jesus yadeegi Pedro, Tiago ijaa João. Yadeegitedicogi maditaɡ̶a aca wetiɡ̶a ane leegitibigimece ane diɡ̶ica oko anodipegitege. Noɡ̶oiwitalo Jesus, odaa jeɡ̶eledi latopagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Niɡ̶ijoa lowoodi Jesus ja datale, daɡ̶axa me yapacaɡ̶a, caticedi okanicodaaɡ̶aca lapacoɡ̶ogo ane yabake nabakenaɡ̶anaɡ̶alo. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Odaa niɡ̶ijo itoatadiɡ̶ida anodiotibece joɡ̶onadi Elias ijaa Moisés anoicoɡ̶otibigimece ditibigimedi moyotaɡ̶aneɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Odaa Pedro jeɡ̶eetalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, ejimele minaaɡ̶ejonaɡ̶atice digoina. Jaoɡ̶ate idabiteɡ̶enaɡ̶atedi iniwatadiɡ̶ini nopecetiidi, oniniteci ɡ̶anebi, ini eledi Moisés, iniaaɡ̶eledi baɡ̶a Elias nebi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pida ayowooɡ̶odi niɡ̶ica lowoogo meo niɡ̶ijo ligegi, leeɡ̶odi niɡ̶ijo itoatadiɡ̶ida anodiotibece eliodi me doitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Odaa ja dinikatini ica lolaadi ane yapoɡ̶oditiniwace, odaa joɡ̶owajipatalo Aneotedoɡ̶oji me dotaɡ̶a catiwedi niɡ̶ijo lolaadi, mee, “Niɡ̶idoa jiɡ̶idaa Ionigi yemaanigi. Ajipaatalo niɡ̶inoa lotaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Codaa noɡ̶onida niɡ̶ijo anodiotibece noɡ̶oiwiteloco niɡ̶inoa liwailidi, odaa joɡ̶onadi idokaaniɡ̶inoateda Jesus miditaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Maleeɡ̶idaaɡ̶ee me dinikatiniwace naɡ̶ajo wetiɡ̶a, Jesus najoitediniwace, meetediogi, “Jinaɡ̶a atematiitiwaji niɡ̶ijo ananati nigepaaɡ̶icota me idewiɡ̶atace Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Odaa oyiwaɡ̶adi niɡ̶ijo Jesus liiɡ̶enatakaneɡ̶egi, aɡ̶ica anoyatematita. Idokida modinotigimadetigi niɡ̶ica ane diitigi niɡ̶ijoa lotaɡ̶a Jesus me yalaɡ̶ate me yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Odaa joɡ̶oige Jesus, moditalo, “Igame leeɡ̶odi niɡ̶ijo niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés modi Elias modoejegi meno, odaa nigidiaaɡ̶idi jaɡ̶aɡ̶enagi Niɡ̶ijoa Aneotedoɡ̶oji ane niiɡ̶e me ɡ̶odatamaɡ̶ateetege ɡ̶odaxakawepodi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus ja igidi, meetediogi, “Ewi Elias noɡ̶odoejegi meno me ilakidetema naigi Niɡ̶ijo Aneotedoɡ̶oji ane niiɡ̶e. Pida igame leeɡ̶odi naɡ̶ajo lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji me yalaɡ̶ata niɡ̶ijo Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi meliodi me dawikode, codaa niɡ̶ina oko mododigota micataɡ̶a niɡ̶ina naagogo? ");
INSERT INTO kbcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pida ejitaɡ̶awatiwaji Elias jiɡ̶ijo meno, odaa joɡ̶owo ane beyagitema niɡ̶ica anepaaɡ̶oyemaa modigota, anodaaɡ̶ee me yalaɡ̶ata Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi maleediɡ̶icota niɡ̶ida niciagi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Niɡ̶ijo noɡ̶odipegitiogi niɡ̶ijo eledi anodiotibece, odaa joɡ̶onadi niɡ̶ijo noiigi-nelegi monawiile. Codaa onidi niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés modinotigimadetege. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Niɡ̶ijo noiigi noɡ̶onaditege Jesus, odaa eliodi moyopo, odaa joɡ̶owaleditege moyecoaditece. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Odaa Jesus nigetediniwace niɡ̶ijoa niiɡ̶axinaɡ̶anadi, meetediogi, “Amiini ica ane adinotigimadenitigitiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Odaa ica ɡ̶oneleegiwa liwigotigi niɡ̶idi noiigi ja igidi, meetalo, “Ǥoniiɡ̶axinoɡ̶odi, inadeegitaɡ̶awa ionigi ini niwigo abeyaceɡ̶egi aneo me daɡ̶a yakadi me dotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Codaa niɡ̶ica niwigo idioka limedi me dibata, odaa yokoletinigiiɡ̶o. Codaa natiatigi nioladi, yacigice lowe, codaa me dinawigice. Ja domaɡ̶a jipokotiogi niɡ̶idi anodiotibigaɡ̶adici moiticoitice niɡ̶ijo niwigo abeyaceɡ̶egi, pida joɡ̶oyapi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Odaa Jesus ja igidi, meeteta, “Jaɡ̶akamaɡ̶akaamitiwaji niɡ̶ica noiigi ane doɡ̶oyiwaɡ̶aditeda Aneotedoɡ̶oji. Igamige liwokodi nokododi ane leeditibige minaaɡ̶ejotice makaamitaɡ̶atiwaji? Igamige liwokodi nokododi jakadi me idinatitaɡ̶awatiwaji leeɡ̶odi me daɡ̶a adadiwaɡ̶ati? Anadeegitiwa niɡ̶ini nigaanigawaanigi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Odaa joɡ̶oyadeegitalo niɡ̶ijo nigaanigawaanigi. Niɡ̶ijo niwigo abeyaceɡ̶egi naɡ̶a nadi Jesus, odaa ja yaxilaketibece niɡ̶ijo nigaanigawaanigi, odaa niɡ̶ijo nigaanigawaanigi jeɡ̶enitinigiiɡ̶o, dinawililetibece, natiatigi nioladi. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Odaa Jesus ja ige eliodi niɡ̶ijo nigaanigi, meeteta, “Akaaɡ̶idokee?” Odaa ja igidi, meetalo, “Niɡ̶ijo malee nigaanigawaanigi naɡ̶a leelotagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jeɡ̶elioditibece niwigo abeyaceɡ̶egi me doletibige me yeloadi, idatecibece eo me dinaxoɡ̶otiogi noledi codaa me ninyoɡ̶odi. Natigide nigakati mawii me icí ionigi, ɡ̶odiwikodeneɡ̶egi, codaa ɡ̶odaxawaneɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Odaa Jesus meeteta, “Aɡ̶eliodi ɡ̶atiwaɡ̶atakaneɡ̶egi alawini menitiwa, ‘Nigakati’. Aneotedoɡ̶oji yakadi meote okanicodaaɡ̶ica loenatagitetema niɡ̶ina oko ane nakato.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo eliodi niɡ̶ijo nigaanigawaanigi jaɡ̶anoe, dapaawe, meetalo, “Iniotagodi, jinakato Aneotedoɡ̶oji, codaa adaxawani mepaanaɡ̶a jinakato!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Niɡ̶ijo Jesus naɡ̶a nadi eliodi oko ane odinatecoɡ̶oteetelogo, odaa ja yapeteɡ̶e niɡ̶ijo niwigo abeyaceɡ̶egi, meeteta, “Niwigo abeyaceɡ̶egi anawii niɡ̶idi nigaanigi me daɡ̶a yakadi me dotaɡ̶a oteɡ̶exaaɡ̶aɡ̶a wajipa, ɡ̶adiiɡ̶eni manotiticogi niɡ̶idi nigaanigi, codaa jinaɡ̶aleeɡ̶akaatiogi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Odaa niɡ̶ijo niwigo abeyaceɡ̶egi ja dinigetaɡ̶atee me dacaage, ecoɡ̶otace eo me dinaxilaketibece niɡ̶ijo nigaanigi, odaa ja noditice. Niɡ̶idi nigaanigi ja liciagi niɡ̶ina émeɡ̶egi, odaa eliodi oko modi, “Ja yeleo!” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pida Jesus dibatedigi libaaɡ̶adi niɡ̶ijo nigaanigi, odaa ja yaxawa me dabiditini. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Niɡ̶idiaaɡ̶idi Jesus ja dakatediwece ica diimigi, onijoateci ijaaɡ̶ijo anodiotibece, odaa niɡ̶ijo anodiotibece joɡ̶oige, moditalo, “Igamige leeɡ̶odi me daɡ̶a jakataɡ̶a me jiticodaɡ̶atice niɡ̶ijo niwigo abeyaceɡ̶egi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Odaa Jesus ja igiditediogi, meetediogi, “Idoka akati miticoitice liciagi niɡ̶ijo niwigo abeyaceɡ̶egi niɡ̶ina mecoɡ̶otace otaɡ̶aneɡ̶enitiwaji Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece ja noditicogi niɡ̶idi nipodigi, odaa ja ixomaɡ̶aticogi miditaɡ̶a nipodigi Galiléia. Jesus adomaɡ̶a yemaa diɡ̶ica ane yowooɡ̶odi ane diɡ̶etedicogi, igaataɡ̶a domaɡ̶a yemaa me niiɡ̶axitediniwace idiokidi niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Niɡ̶ijo naɡ̶a niiɡ̶axitediniwace, meetediogi, “Icota metidajigotiogi niɡ̶inoa ɡ̶oneleegiwadi ɡ̶oneɡ̶aɡ̶a, odaa niɡ̶idiwa ɡ̶oneleegiwadi etideloadi, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. Pida nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi me ideleo, odaa ja idewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pida niɡ̶ijo anodiotibece aɡ̶oyowooɡ̶odi niɡ̶ica ane diitigilo niɡ̶ijoa lotaɡ̶a. Pida joɡ̶odoitalo doɡ̶oigetece Jesus ica ane diitigilo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece jiɡ̶icotiobece nigotaɡ̶a Cafarnaum. Niɡ̶ijo naɡ̶a idiaaɡ̶itice liɡ̶eladi, odaa Jesus ja nigetediniwace, meetediogi, “Amiini ica ane adinotigimadenitigitiwaji naigitece?” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pida notokotiniwace, aɡ̶ica gaantokaaɡ̶ida ligegi niɡ̶ijo anodiotibece, igaataɡ̶a naigitece odinotigimadetigi niɡ̶ica ane daɡ̶axa me ɡ̶oneɡ̶egi liwigotigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus nicotedini, odaa jeɡ̶eniditediogi, meetediogi, “Niɡ̶ina oko ɡ̶adiwigotigitiwaji ane yemaa me idei odoejegi nimedi, niɡ̶ini oko leeditibige mowidijegi, codaa me ɡ̶aotagitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Odaa ja dibate ica nigaanigawaanigi, odaa ideyatedice liwigotigi. Odaa ja ibedotetece niɡ̶ijo nigaanigawaanigi, odaa meetediogi niɡ̶ijo anodiotibece, ");
INSERT INTO kbcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Niɡ̶ina oko ane dibatege nigaanigawaanigi liciagi niɡ̶ini nigaanigawaanigi me Ee leeɡ̶odi, niɡ̶ini oko dibatigi. Odaa niɡ̶ina oko ane dibatigi, aɡ̶emoka dibatigi, pida aaɡ̶aɡ̶a dibatege Niɡ̶ijoa ane idimonya.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","João meetalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, jinataɡ̶a ijo ɡ̶oneleegiwa ibake Ǥaboonaɡ̶adi me iticoitedice niwicidi abeyacaɡ̶aɡ̶a, odaa ja joxokojoɡ̶o me ibake Ǥaboonaɡ̶adi, leeɡ̶odi adiotibigaɡ̶adici daɡ̶a ɡ̶odiciagi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Odaa Jesus meeteta, “Jinoɡ̶oxoki eledi oko me ibake Iboonaɡ̶adi, igaataɡ̶a aɡ̶ica ini ane yakadi me ibake Iboonaɡ̶adi meo ɡ̶odoxiceɡ̶edi, oditaɡ̶a aleegi odaa ja beyagi me dotaɡ̶atibigiji. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Igaataɡ̶a niɡ̶ina oko ane daɡ̶a ɡ̶odakapetegi, niɡ̶ini oko ida anejinaɡ̶atege. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Igaataɡ̶a niɡ̶ina oko ane yajigotaɡ̶awatiwaji goopa ninyoɡ̶odi leeɡ̶odi mida anenitigi, Ee ane idimonya Aneotedoɡ̶oji me jewikatiditace niɡ̶ina oko. Ejitaɡ̶awa niɡ̶ina anewi, Aneotedoɡ̶oji yajigote noɡ̶eedi anele niɡ̶ini oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus eɡ̶idaaɡ̶ee me dotaɡ̶a, odaa meetediogi, “Nigica aneo oniniteci niɡ̶idi nigaanigipawaanigi meyamaɡ̶atice eliwaɡ̶atakaneɡ̶egi, odaa ejimetaɡ̶a daɡ̶axa mele doɡ̶oigoetece lotoinaɡ̶adi wetiɡ̶a nelegi liciagi naɡ̶ana wetiɡ̶a anoibake monidi leyeema, oditaɡ̶a oyokoletinigi akiidi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ǥabaaɡ̶adi nigeo mabataa, ejimetaɡ̶a daɡ̶axa mele makagiti, oditaɡ̶a onaniɡ̶idatece ɡ̶abaaɡ̶adi, pida akaatiwece aneitedice Aneotedoɡ̶oji midioka limedi makaami miniwataɡ̶a. Aliciagi daɡ̶a idoatawece ɡ̶abaaɡ̶atedi, pida etiɡ̶adokoleniticogi miditaɡ̶a aneite nawikodico minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Digoida idioka limedi midiwa nigojokodi anoyeligo lolaadi niɡ̶ina émeɡ̶egi, codaa noledi aɡ̶ica daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ǥadoɡ̶onagi nigeo mabataa, ejimetaɡ̶a daɡ̶axa mele makagiti, oditaɡ̶a akaami alejaado, pida akaatiwece Aneotedoɡ̶oji aneitedice midioka limedi makaami miniwataɡ̶a. Aliciagi daɡ̶a idoatawece ɡ̶adoɡ̶onaka, pida etiɡ̶adokoleniticogi miditaɡ̶a aneite nawikodico minitaɡ̶a noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Digoida idioka limedi midiwa nigojokodi anoyeligo lolaadi niɡ̶inoa émaɡ̶aɡ̶a, codaa noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ǥagecooɡ̶e nigeo mabataa, ejimetaɡ̶a daɡ̶axa mele manoɡ̶aa onaniteci ɡ̶agecooɡ̶e, oditaɡ̶a onaniteci ɡ̶aneike, pida akaatiwece aneitedice Aneotedoɡ̶oji midioka limedi makaami miniwataɡ̶a. Aliciagi daɡ̶a idiwatawece ɡ̶agecooɡ̶eli, pida etiɡ̶adokoleniticogi minitaɡ̶a noledi ane daɡ̶a ipe, aneite nawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Digoida idioka limedi midiwa nigojokodi anoyeligo lolaadi niɡ̶inoa émaɡ̶aɡ̶a, codaa noledi ane daɡ̶a ipe. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Niɡ̶ina monigodi niɡ̶inoa eijedi anoibootema Aneotedoɡ̶oji, odaa onocie libole me doɡ̶oika me beyagi maleedoɡ̶oyalegi, jiɡ̶idaɡ̶aɡ̶aee niɡ̶inoa ɡ̶odawikodico, dapicoɡ̶o liciagi niɡ̶ina noledi, odaa eo ɡ̶otiwaɡ̶atakaneɡ̶egi me daɡ̶a beyagi, pida jeɡ̶epaanaɡ̶a datiteti. ");
INSERT INTO kbcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ele me jibakenaɡ̶a yoci, pida niɡ̶ina yoci nige naɡ̶aniaditema libayodaɡ̶a, odaa aɡ̶aleeɡ̶ica ɡ̶onimaweneɡ̶egi daɡ̶a jaoɡ̶atace me bayodi. Micataɡ̶a niɡ̶ina yoci me daɡ̶a ika libole me beyagi, idaɡ̶aɡ̶aeni jiniɡ̶ikani gaantokaaɡ̶ini ane ibeyacaɡ̶adi ɡ̶ademaanaɡ̶aneɡ̶egi anida makaamitaɡ̶atiwaji, jinaɡ̶a adinotigimadeni, oteɡ̶exaaɡ̶aɡ̶a adinideleɡ̶enitiwagetiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Niɡ̶ijo Jesus naɡ̶a noditedicogi nipodigi Galiléia, odaa jiɡ̶igo miditaɡ̶a nipodigi Judéia, daato akiidi Jordão. Ica noiigi-nelegi odinatecoɡ̶oteetacelogo, codaa modipegitalo, odaa ja niiɡ̶axitacediniwace, ane ligileɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Icoa fariseutedi igotibeci midoataɡ̶a, odaa joɡ̶oige, moditalo, “Ica ɡ̶onajoinaɡ̶aneɡ̶egi domige ika ina ɡ̶oneleegiwa me yaladi lodawa?” Domoɡ̶odoletibige me nilaagedi Jesus mowote niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Niɡ̶ijo Jesus naɡ̶a niniɡ̶oditediogi, odaa ja nigetediniwace, meetediogi, “Amiini ica Moisés ane iiɡ̶etaɡ̶awa mawiitiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Odaa joɡ̶oigidi, moditalo, “Moisés ika niɡ̶ina ɡ̶oneleegiwa meo idí notaɡ̶anaɡ̶axi ane yalaɡ̶ata me yaladi lodawa, odaa yakadi me iiɡ̶e mopi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Odaa Jesus ja igidi, meetediogi, “Moisés iditini niɡ̶ida lajoinaɡ̶aneɡ̶egi leeɡ̶odi ɡ̶adaaleɡ̶enali me dakake. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pida niɡ̶ijo Aneotedoɡ̶oji neɡ̶eote inoatawece aninoa, jiɡ̶idaa ane yalaɡ̶ata Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, mee, ‘Aneotedoɡ̶oji eote ɡ̶oneleegiwa aniaaɡ̶iwaalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Joaniɡ̶idaa leeɡ̶odi ɡ̶oneleegiwa me ika eliodi, eliodo niɡ̶ina naɡ̶a lodawa naɡ̶ana lodawa. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Odaa niɡ̶ijo itoataale ja micataɡ̶a doɡ̶okinitece oko.’ Odaa jiɡ̶idaaɡ̶ee aɡ̶alee liciagi miniwataale oko, pida ja micataɡ̶a doɡ̶okinitece oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Odaa niɡ̶ina Aneotedoɡ̶oji ane yadoneɡ̶etediwage, aɡ̶ica oko ane yakadi me yawalacetiwage.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Niɡ̶ijo naɡ̶a idiaaɡ̶itice minitaɡ̶a ica diimigi ane lotokaɡ̶adi, odaa niɡ̶ijo anodiotibece Jesus joɡ̶oigetece ane diitigilo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Odaa Jesus meetediogi, “Niɡ̶ina ɡ̶oneleegiwa ane yaladi lodawa, odaa nige lodawa eledi iwaalo, odaa ja iɡ̶olaɡ̶adi naɡ̶ajo odoeje lodawa. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Codaa naɡ̶ana iwaalo ane yaladi lodawa, nige lodawa eledi ɡ̶oneleegiwa, odaa ja iɡ̶olaɡ̶adi niɡ̶ijo odoejegi lodawa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ica noiigi oyadeegitalo Jesus nigaanigipawaanigi me ipeketedeloco libaaɡ̶atedi me ibinietediogi. Pida niɡ̶ijo anodiotibece joɡ̶odowocetege niɡ̶ijo oko anonadeegi lionigipi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pida Jesus naɡ̶a nadi niɡ̶ijo anodiotibece niɡ̶ica anowote, odaa ja yelatetema, odaa meetediogi, “Ikanitiwaji niɡ̶ina nigaanigipawaanigi menagitibeci meetaɡ̶a, jinaɡ̶a oliitege menagitibeci meetaɡ̶a, igaataɡ̶a Aneotedoɡ̶oji iiɡ̶e laaleɡ̶enali niɡ̶ina oko ane liciagi niɡ̶ina nigaanigipawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aneotedoɡ̶oji aiiɡ̶e laaleɡ̶ena niɡ̶ina oko ane daɡ̶a dibatege anodaaɡ̶ee niɡ̶ina nigaanigawaanigi me dibatege.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Odaa Jesus nibedotedi niɡ̶ijo nigaanigipawaanigi, odaa ja ipeketedeloco libaaɡ̶atedi me ibinietediogi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Niɡ̶ijo Jesus naɡ̶a idaa diitacedicogi me diniwiaje, odaa ica ɡ̶oneleegiwa walokoditege, odaa ja yamaɡ̶atedi lokotidi lodoe Jesus. Odaa ja ige, meetalo, “Iniiɡ̶axinoɡ̶odi anele, amiida ica ane leeditibige me jao midioka limedi me idewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Odaa Jesus meeteta, “Igame leeɡ̶odi menitiwa me Ee ele? Aɡ̶ica anele, iniokiniwateda Aneotedoɡ̶oji mele. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Joɡ̶owooɡ̶oti liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji. Aneotedoɡ̶oji ɡ̶odiiɡ̶e, meete, ‘Jinaɡ̶a aijee, jinaɡ̶a aɡ̶olaɡ̶atakani, jinaɡ̶a olice, codaa jinaɡ̶a ilikoni. Aweniɡ̶ideni ɡ̶adiodi, codaa me ɡ̶adiodo.’ Codaa jinaɡ̶a inaaleni eledi oko manoɡ̶aa ane nebi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Odaa niɡ̶ijo ɡ̶oneleegiwa ja igidi, meetalo, “Iniiɡ̶axinoɡ̶odi, idioka limedi me jeemitetibige idiwatawece niɡ̶idiwa niiɡ̶enatakaneɡ̶eco niɡ̶ijo maleeɡ̶ee nigaanigi codaa niɡ̶ina natigide.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus naɡ̶a iwiteta, odaa eliodi me yemaa, odaa meeteta, “Onaniɡ̶idatece ane leeditibige mawii. Aani niɡ̶icoa ane ɡ̶anepilidi, odaa edianitece ɡ̶aninyeelo niɡ̶ina madewetedipi. Odaa jiɡ̶idaa Aneotedoɡ̶oji nige yajigotedaɡ̶awa owidi ɡ̶anepilidi digoida ditibigimedi. Odaaɡ̶anagi, pida leeditibige me ɡ̶adigomi mawikodee nigepaa ɡ̶adelewi, odaa baɡ̶akati maniwitici.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Niɡ̶ijo ɡ̶oneleegiwa naɡ̶a wajipatalo niɡ̶ijoa lotaɡ̶a Jesus, odaa deemitetece catiwedi laaleɡ̶ena dakake meo niɡ̶ijo aneeteta Jesus. Odaa eliodi magecaɡ̶alo, odaa joɡ̶opi, leeɡ̶odi owidi niɡ̶icoa ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Odaa Jesus niipetediogi niɡ̶ijo anodiotibece monawiile, odaa meetediogi, “Ica me dakake Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena niɡ̶ina liico!” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Niɡ̶ijo anodiotibece eliodi me nawelatibigiwaji niɡ̶ijo noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a. Pida Jesus eɡ̶idaaɡ̶ee me dotaɡ̶a, meetediogi, “Ionigipi, dakake Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena niɡ̶ina oko ane dinaɡ̶akatiditalo niɡ̶ina ane niliicaɡ̶ajetecidi! ");
INSERT INTO kbcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eneɡ̶egi dakake Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena niɡ̶ina liico, aliciagi gameelo me dakatiwece etakado lawimaɡ̶ajegi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Niɡ̶ijo anodiotibece noɡ̶owajipatacalo niɡ̶ijoa lotaɡ̶a, odaa nawelatacibigiwaji. Odaa ja dinigetiwage, modi, “Enice, amigijo ica ane yakadi midioka limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Odaa Jesus naɡ̶a niipetacediogi, odaa meetediogi, “Niɡ̶ina oko aɡ̶ica nimaweneɡ̶egi deɡ̶epaaɡ̶owo midioka limedi me newiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji, pida Aneotedoɡ̶oji biɡ̶ida nimaweneɡ̶egi. Codaa yakadi meote okanicodaaɡ̶ica, aɡ̶ica idi ane daɡ̶a yakaditeda meote.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Odaa Pedro jiɡ̶idaaɡ̶eyatedigi me yotaɡ̶aneɡ̶e Jesus, meetalo, “Digawini! Ja jikanaɡ̶atedice ijoatawece ane ɡ̶onepilidi leeɡ̶odi me jiwaɡ̶atibigaɡ̶adici.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus ja igidi, meeteta, “Ejitaɡ̶awa niɡ̶ina anewi. Inatawece oko anoyaladi liɡ̶eladi, nioxoadipi, codaa me niwaalepodi, eliodi, eliodo, lodawa, lionigipi, codaa me niɡ̶inoa niiɡ̶otedi Ee leeɡ̶odi, codaa me leeɡ̶odi me yatematitedibece nibodicetedi anele, ");
INSERT INTO kbcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Aneotedoɡ̶oji yajigote niɡ̶ini oko caticedi niɡ̶icoa ane yaladi malee newiɡ̶a niɡ̶ina iiɡ̶o. Aneotedoɡ̶oji yajigote anige liwokodi taalia caticedi ane liwokodi niɡ̶ica anoyaladi. Codaa niɡ̶ini oko dinigaanyetece liɡ̶elatedi, nioxoadipi, niwaalepodi, eliododipi, nigaanigipawaanigi, codaa me niiɡ̶otedi. Codaa icota moiatetibeci, pida nigidiaaɡ̶idi idioka limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Eliodi oko ane daɡ̶axa me ɡ̶oneɡ̶aɡ̶a niɡ̶inoa nokododi digoina iiɡ̶o, niɡ̶idi oko icota me iwikodadipi. Odaa eliodi oko ane iwikodadipi niɡ̶inoa nokododi, niɡ̶idi oko icota me daɡ̶axa me ɡ̶oneɡ̶egipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus ijaaɡ̶ijo anodiotibece eɡ̶idaaɡ̶ee mewaligitibigiwaji, odaa joɡ̶odowicetibigimece manitaɡ̶a nigotaɡ̶a Jerusalém. Jesus igo lodoe niɡ̶ijo anodiotibece odaa one oyopo. Niɡ̶ijo oko anodiotece doitibigiwaji. Odaa Jesus jeɡ̶eniditediogi niɡ̶ijo dooze anodiotibece, ixipetedicoace. Odaa yeloɡ̶oditediogi ane ninyaagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Meetediogi, “Digawini! Ja jowicaɡ̶ata nigotaɡ̶a Jerusalém. Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi etidajigotiogi niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odaa modi me leeditibige metideloadi, codaa aaɡ̶aɡ̶a etidajigotiogi niɡ̶ijo ane daɡ̶a judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Odaa niɡ̶idi ane daɡ̶a judeutedi oyametibigiji, etidalaketibige, codaa metidawaletice, odaa jeɡ̶etideloadi. Pida nigidiaaɡ̶idi nige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tiago ijaa João ane lionigipi Zebedeu, jiɡ̶igotibeci odipegitalo Jesus, odaa moditalo, “Ǥoniiɡ̶axinoɡ̶odi, jemaanaɡ̶a mawiitoɡ̶odomi ane jipokaɡ̶ataɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Odaa Jesus nigetediniwace, meetediogi, “Amiini ica anemaanitiwaji me jaotaɡ̶adomi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Odaa joɡ̶oigidi, moditalo, “Niɡ̶ina Aneotedoɡ̶oji nige ɡ̶adinelecaɡ̶ateeni, nigicota me iiɡ̶eni inoatawece, ɡ̶odikaneɡ̶egi me ɡ̶odicote ɡ̶awai oniniteci diɡ̶etege ɡ̶abaaɡ̶adi iniaaɡ̶eledi diɡ̶etege ɡ̶animagijegi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pida Jesus meetediogi, “Aɡ̶owooɡ̶otitiwaji niɡ̶ica anipokitibige. Domigakatitiwaji mawikodee anodaaɡ̶eji me jawikode, codaa domige akatitiwaji mawikodee nigepaa ɡ̶adelewi anodaaɡ̶eji me ideleo?” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Odaa joɡ̶oigidi, moditalo, “Jakataɡ̶a!” Odaa Jesus meetediogi, “Awikodeetiwaji anodaaɡ̶eji me jawikode, codaa me ɡ̶adelewi, anodaaɡ̶eji me ideleo. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pida aɡ̶ica inaɡ̶atetigi deɡ̶ejitaɡ̶awatiwaji me akati manicootini ibaaɡ̶adi, iniaaɡ̶eledi inimagijegi. Aneotedoɡ̶oji yajigote niɡ̶idiwa nimetiidi niɡ̶ica oko anepaa iolatedice me nicoteloco.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Niɡ̶ijo eledi deez anodiotibece Jesus owajipata niɡ̶ijo Tiago ijaa João anodipokotalo Jesus, odaa joɡ̶oyelatema. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Odaa Jesus jeɡ̶eniditediogi modipegitalo, odaa meetediogi, “Niɡ̶ijo anoditiogi me ɡ̶odacilodi, owooɡ̶otitiwaji me lemaanigi me iiɡ̶e niɡ̶ina oko, codaa niɡ̶ina oko anodiletibige niɡ̶ina eledi oko diɡ̶ida naɡ̶atetigi, niɡ̶ijo oko lemaanigi me ibake epaanaɡ̶a naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jiniɡ̶idaaɡ̶enitiwaji digo miditaɡ̶a. Pida niɡ̶ina ane yemaa mida naɡ̶atetigi ɡ̶adiwigotigitiwaji, niɡ̶ini oko leeditibige makaamitawece dibataɡ̶adomitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Odaa niɡ̶ina oko ane yemaa me dibata odoejegi nimedi ɡ̶adiwigotigitiwaji, niɡ̶ini leeditibige makaamitawecetiwaji aotageni. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Igaataɡ̶a codaa me Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ajanagi daɡ̶a jiotage niɡ̶ina oko, pida janagi me Ee niotagi, codaa me etidajigo me ideleo, odaa ja jao Aneotedoɡ̶oji me yakadi me dibatetege eliodi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece joɡ̶oyakagiditeloco nigotaɡ̶a Jericó. Niɡ̶ijo naɡ̶a doletibige me noditedice naɡ̶ajo nigotaɡ̶a, ijaaɡ̶ijo niɡ̶ijo anodiotibece icaaɡ̶ica noiigi-nelegi, odaa jiɡ̶icote ica ɡ̶oneleegiwa ɡ̶olaɡ̶a ane liboonaɡ̶adi Bartimeu, lionigi Timeu. Bartimeu idiaa nicote liniogotibece naigi, dipokotibige dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Niɡ̶ijo naɡ̶a wajipatibece modi Jesus anelatedigi nigotaɡ̶a Nazaré me inaaɡ̶igotedinece aneitice, odaa jiɡ̶idaa dinanatigi me dapaawe, mee, “Jesus, anida anenitege licoɡ̶egi inionigi Davi, adiwikodenita!” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pida eliodi oko oyapeteɡ̶e, codaa moiiɡ̶e me notokotini. Pida jeɡ̶epaanaɡ̶a dapaawetibece, mee, “Akaami, anida anenitege licoɡ̶egi inionigi Davi, adiwikodeni!” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Odaa Jesus ja dabiditedi, odaa ja diiɡ̶enatakate monadeegitalo. Odaa joɡ̶onidita niɡ̶ijo ɡ̶olaɡ̶a, modita, “Eloodaɡ̶ateeni ɡ̶adaaleɡ̶ena! Adabititini! Jeɡ̶eniditedaɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Odaa Bartimeu ja yokoletice aca nicaapa, codaa yediiɡ̶a me dabiditini, odaa jiɡ̶igo midoataɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Odaa Jesus ja ige, meeteta, “Amiini ica anemaani me jaotaɡ̶adomi?” Odaa niɡ̶ijo ɡ̶olaɡ̶a ja niniɡ̶odi, meetalo, “Iniotagodi, jemaa me jatetacibece.” ");
INSERT INTO kbcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Odaa Jesus meeteta, “Emii, ja ɡ̶adicili leeɡ̶odi manakatoni Aneotedoɡ̶oji me yakadi me ɡ̶adicilatiti.” Ajaaɡ̶ajo naɡ̶aca lakata Bartimeu jona yatetacibece, odaa ja diotece Jesus mijotaɡ̶a naigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece noɡ̶odipegita nigotaɡ̶a Jerusalém, odaa joɡ̶ototicogi minitaɡ̶a ica lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira”, anipegitege icoa nigotadawaanaɡ̶a ane liboonaɡ̶adi Betfagé aniaa Betânia. Odaa Jesus ja iiɡ̶e itoa niɡ̶ijo anodiotibece, odaa meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Emiitiwaji manitaɡ̶a nigotakawaana digoida ɡ̶ododoe. Nige akaatiobecetiwaji, aɡ̶ica daɡ̶a leegi icoota boliicawaanigi ane dinigoetini analeediɡ̶ica mowaxoditeloco. Odaa owilecenitiwaji, anadeegitiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pida nigica aneetaɡ̶awatiwaji, ‘Igame leeɡ̶odi mowilecenitiwaji ini boliicawaanigi?’, odaa enita, ‘Ǥoniotagodi yopotedibige. Nopilaɡ̶adi natigidawaanigi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Odaa niɡ̶ijo itoatataale anodiotibece jiɡ̶igotibeci, odaa joɡ̶otota niɡ̶ijo boliicawaanigi naigitece, dinigoetini ipegitege lapoagi ica diimigi. Odaa joɡ̶oyowilece niɡ̶ijo boliicawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Odaa ica oko anidiaaɡ̶itice ja nigikanaɡ̶a, moditiogi, “Igaamenitiwaji? Igame leeɡ̶odi mowilecenitiwaji ini boliicawaanigi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Odaa niɡ̶ijo itoatataale anodiotibece Jesus joɡ̶oigidi niɡ̶ijo aneetediogi Jesus me ligegi. Odaa niɡ̶ijo oko joɡ̶oikatece niɡ̶ijo anodiotibece Jesus moyadeegi boliicawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Odaa noɡ̶oyadeegitalo Jesus niɡ̶ijo boliicawaanigi, odaa joɡ̶oyexaɡ̶ateloco nicaapatedi niɡ̶ijo boliicawaanigi, odaa Jesus ja waxoditedeloco. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eliodi oko oipecetedice nicaapatedi niɡ̶ijo naigitece, odaa ica eledi onakagidi exate-lamodi oipecetinece naigi. (Idaɡ̶aee leeɡ̶odi moiweniɡ̶ide Jesus.) ");
INSERT INTO kbcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Odaa ijo oko anigotibeci lodoe Jesus, codaa ica eledi boɡ̶odiotece lowidi napaawaɡ̶ateloco, modi, “Jiweniɡ̶idenaɡ̶a Aneotedoɡ̶oji! Codaa jemaanaɡ̶a Aneotedoɡ̶oji me ibinie Niɡ̶inoa anenagi ibake naɡ̶atetigi Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji! ");
INSERT INTO kbcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jemaanaɡ̶a Aneotedoɡ̶oji me ibinie Niɡ̶iniwa anida aneetetege licoɡ̶egi inionigi-eliodi Davi, ane niiɡ̶etedoɡ̶owa Aneotedoɡ̶oji me ɡ̶oninionigi-eliodi, liciagi Davi me ninionigi-eliodi niɡ̶ijo ɡ̶odaamipi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus ja dakatediwece nigotaɡ̶a Jerusalém, odaa jiɡ̶igo minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Naɡ̶a dakatediwece, odaa iwitedigi initawece le. Niɡ̶idiaaɡ̶idi ja noditedice leeɡ̶odi naɡ̶a ɡ̶ocidi, odaa jiɡ̶igo manitaɡ̶a nigotakawaana Betânia lixigaɡ̶awepodi niɡ̶ijo dooze anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Naɡ̶a nigoi Jesus ja noditedicogi Betânia, odaa leecawaanigi ja deemitete me nigicile. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Odaa ditigedi naɡ̶a nadite aca niale fiigoigo ane daamotiide. Odaa jiɡ̶igo iwi daɡ̶aca ela. Pida niɡ̶ijo niɡ̶icote naɡ̶ajo niale, aɡ̶aca yakadi otaɡ̶anitece ela, inokinoa laamotiidi, leeɡ̶odi anaɡ̶a limedi me etaye. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Odaa Jesus jeɡ̶eete naɡ̶ajo niale, “Niɡ̶ina natigide, aɡ̶aleeɡ̶ica ane yeligo ɡ̶atá.” Odaa niɡ̶ijo anodiotibece joɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Odaa Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece noɡ̶otota nigotaɡ̶a Jerusalém, odaa ja dakatediwece minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, odaa jiɡ̶idaaɡ̶eyatedigi me iticoitedicoace ijoatawece niɡ̶ijoa anoojetekaɡ̶a codaa me niɡ̶ijo ane oojeteeɡ̶a. Odaa yamaɡ̶atedini nameejatedi niɡ̶ijo ane libakedi moiikoaɡ̶e dinyeelo codaa eledi yamaɡ̶atedini nibaancotedi niɡ̶ijo anoyaa yotipitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aɡ̶ica ane ika me ixomaɡ̶atice minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi me yoyaɡ̶adi elaanaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Odaa niɡ̶idiaaɡ̶idi jiɡ̶idiaaɡ̶itedice me niiɡ̶axitediniwace ica oko, meetediogi, “Maditaɡ̶a Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi diniditeloco niɡ̶icoa Aneotedoɡ̶oji lotaɡ̶a, niɡ̶ijo neɡ̶ee, ‘Oyatigi iɡ̶eladi me “Diimigi aneitice inatawece noiigi moyakadi moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji”.’ Pida jaɡ̶awiitiwaji Aneotedoɡ̶oji liɡ̶eladi me liciagi niɡ̶ina liɡ̶eladi olicaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés joɡ̶odibodiceta niɡ̶ijo Jesus aneote. Odaa joɡ̶odoletibige niɡ̶ica nimaweneɡ̶egi moyeloadi, pida odoitalo leeɡ̶odi inatawece oko oyopo niɡ̶ijo ane diiɡ̶axinaɡ̶atetece. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naɡ̶a ɡ̶ocidi Jesus ja noditacedice nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Naɡ̶a nigoi, Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece inaaɡ̶igotacinece niɡ̶ijo ligi, odaa joɡ̶onadi naɡ̶ajo libatadi fiigo. Naɡ̶ajo niale adatawece yadilo, codaa me litodi yadilo. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Odaa Pedro ja nalaɡ̶atibige niɡ̶ijoa Jesus lotaɡ̶a, odaa meetalo, “Ǥoniiɡ̶axinoɡ̶odi, digawini! Naɡ̶ajo niale ane ixoomi ja yadilo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Odaa Jesus ja igidi, meeteta, “Anakatonitetiwaji Aneotedoɡ̶oji! ");
INSERT INTO kbcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niɡ̶ina nigewi me iwaɡ̶atitiwaji, akati me enita naɡ̶adi wetiɡ̶a, ‘Emii, adinokolenitinigi akiidi-eliodi!’ Odaa nige daɡ̶a awienatakanitiwaji, pida nige iwaɡ̶atakani micota niɡ̶ijo ane ɡ̶agegita, odaa Aneotedoɡ̶oji eote micota. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Joaniɡ̶idaa leeɡ̶odi mejitaɡ̶awatiwaji niɡ̶ina motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, mokanicodaaɡ̶ica anipokitalo, iwaɡ̶ati Aneotedoɡ̶oji me yajigotedaɡ̶awatiwaji, odaa yajigotedaɡ̶awa niɡ̶ica ane ipokitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Codaa niɡ̶ina motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, ixomaɡ̶ateenitice okanicodaaɡ̶ica ane beyagi aneotaɡ̶adomi eledi oko, amaleeɡ̶aɡ̶a Ǥadiodi ane ideite ditibigimedi ixomaɡ̶ateetedice ɡ̶abeyaceɡ̶ecotiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pida nige daɡ̶a ixomaɡ̶ateeniticetiwaji niɡ̶ina ane beyagi anowotaɡ̶adomi eledi oko, odaa Ǥadiodi ane ideite ditibigimedi aixomaɡ̶ateetedice ɡ̶abeyaceɡ̶ecotiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Niɡ̶idiaaɡ̶idi Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece jiɡ̶icotaciobece manitaɡ̶a nigotaɡ̶a Jerusalém. Jesus igotedigi Aneotedoɡ̶oji liɡ̶eladi, odaa joɡ̶ototalo niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, ijaaɡ̶ijo laxokodi lacilodi niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Odaa moditalo Jesus, “Amiida ica ɡ̶anaɡ̶atetigi miticoiticoace niɡ̶ijo oko minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi? Codaa amiijo ane yajigotaɡ̶awa ica ɡ̶anaɡ̶atetigi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Odaa Jesus meetediogi, “Jeloɡ̶oditaɡ̶awatiwaji ane najigotiwa inaɡ̶atetigi niɡ̶ina nige adigiti ane ɡ̶adigeetece. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Amiijo ica ane yajigota João Batista naɡ̶atetigi me nilegetiniwace oko? Domige Aneotedoɡ̶oji, oɡ̶oa domigoko? Jemaa madigititiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Odaa joɡ̶odinotigimadetigi, modi, “Nigejinaɡ̶a me Aneotedoɡ̶oji ane yajigote naɡ̶atetigi João, odaa jeɡ̶eetedoɡ̶owa, ‘Enice igame leeɡ̶odi me daɡ̶a iwaɡ̶atitedatiwaji lotaɡ̶a João?’ ");
INSERT INTO kbcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pida nigejinaɡ̶a me niɡ̶ina oko oiiɡ̶e João, odaa niɡ̶ina oko joɡ̶oyelatoɡ̶odomi.” Odoitiogi niɡ̶idi noiigi leeɡ̶odi iditawece niɡ̶idi oko oyiwaɡ̶adi João mewi me niɡ̶inaaɡ̶ina niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Odaa joɡ̶oigidi Jesus, moditalo, “Ajowooɡ̶otaɡ̶a ane niiɡ̶e João!” Odaa Jesus meetediogi, “Enice amaɡ̶aɡ̶a jatematitaɡ̶awatiwaji ane najigotiwa inaɡ̶atetigi me jaote niɡ̶inoa yoenataka.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus jiɡ̶idaaɡ̶eyatedigi me yatematitediogi natematiko anida ane iciaceeketetege me diiɡ̶axinaɡ̶a. Odaa meetediogi, “Ica ɡ̶oneleegiwa eyatedi uuva libatatiidi, odaa ja niotaa, codaa eo ligixitaɡ̶anaɡ̶axi me niopaaɡ̶aditedi uuva me yoe viinyo, codaa eo lipe lajo moibeo niɡ̶ijoa lawodigijedi niɡ̶inoa nowienoɡ̶ododi. Odaa niɡ̶idiaaɡ̶idi ja niwaiɡ̶awepodi icoa nawodaɡ̶anadi, odaa jiɡ̶igo diniwiajeticogi ica eledi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Niɡ̶ijo niɡ̶icota limedi me nopilaɡ̶aditedio elali, niɡ̶ijo ane nebi niɡ̶ijoa nawodigijedi nimonya ica liotagi me dienaɡ̶atalo niɡ̶ijoa elali ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pida niɡ̶ijoa nawodaɡ̶anadi odibata niɡ̶ijo nimeedi, odaa onalaketibige, codaa oiiɡ̶e mopi me diɡ̶icata ane yadeegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Odaa niɡ̶ijo ane nebi ja niiɡ̶etace ica eledi liotagi, pida niɡ̶ijoa nawodaɡ̶anadi onigidatice, codaa oyacilotidi lacilo, codaa owo me niboliɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Odaa niɡ̶ijo ane nebi niɡ̶ijoa nawodigijedi ja niiɡ̶etace ica eledi liotagi, pida niɡ̶ijoa nawodaɡ̶anadi baanoɡ̶oyeloadi. Odaa onalee niiɡ̶e icoa eletidi liimetedi, pida niɡ̶ijoa nawodaɡ̶anadi owo liciagi niɡ̶ijoa eletidi liimetedi. Ica eledi dinalaketibigiwaji, icaaɡ̶ica eledi boɡ̶onigodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Niɡ̶ijo ane nebi niɡ̶ijoa nawodigijedi ini ica lionigi aneliodi me yemaa. Odaa niɡ̶idiaaɡ̶idi ja iiɡ̶eticogi niɡ̶ijo lionigi midiwataɡ̶a lawodigijedi. Meetibige le, ‘Odeemitetibige leeɡ̶odi me ionigi.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pida niɡ̶ijoa nawodaɡ̶anadi noɡ̶onaditege niɡ̶ijo lionigi, odaa dinotaɡ̶aneɡ̶e, modi, ‘Niɡ̶ina niɡ̶ijo lionigi niɡ̶ijo ane nepilidi niɡ̶idiwa nawodigijedi, anicota me nepilidi niɡ̶inoa lawodigijedi. Jeloataɡ̶a, odaa ja jakataɡ̶a me ɡ̶onepilidi niɡ̶idiwa nawodigijedi!’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Odaa joɡ̶odibata niɡ̶ijo lionigi niɡ̶ijo ane nebi nawodigijedi, odaa joɡ̶oyeloadi, codaa oyaladiticogi lolaadi wetice niɡ̶ijoa nawodigijedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Odaa Jesus jeɡ̶eetediogi, “Amiida ica anakatitiwaji meo niɡ̶ijo ane nepilidi nawodigijedi? Enagi, odaa ja diiɡ̶enatakatiogi monigodi niɡ̶ijoa nawodaɡ̶anadi, codaa yajigotiogi eletidi nawodaɡ̶anadi niɡ̶idiwa lawodigijedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ajawienatakanaɡ̶a me naɡ̶a alomeɡ̶enitelocotiwaji lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji, niɡ̶ijo mee, ‘Naɡ̶ajo wetiɡ̶a anoyaladi niɡ̶ijo anodabiteɡ̶etini diimigi, niɡ̶ina natigide jaɡ̶aniaaɡ̶ani naɡ̶aca wetiɡ̶a ane daɡ̶axa mida jaoɡ̶a caticedi niɡ̶ijoa eletidi wetiadi anoibake modabiteɡ̶etini diimigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jiɡ̶ijaa Ǥoniotagodi Aneotedoɡ̶oji aneote naɡ̶ajo wetiɡ̶a me daɡ̶axa mida ane jaoɡ̶a. Odaa jopooɡ̶a niɡ̶ida loenatagi.’” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Odaa niɡ̶ijoa lacilodi judeutedi joɡ̶oyowooɡ̶odi niɡ̶ijo Jesus naɡ̶a yatemati niɡ̶ijo natematigo me lakapetedipi. Odaa joɡ̶odoletibige moniwilo, pida odoitiogi niɡ̶ijo noiigi-nelegi. Odaa joɡ̶oika Jesus, odaa joɡ̶opitibeci. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Niɡ̶ijoa lacilodi judeutedi oiiɡ̶etalo Jesus icoa fariseutedi ijaaɡ̶ijo niɡ̶ijo anodiotibeci inionigi-eliodi Herodes. Oiiɡ̶e migotibeci onake doɡ̶owo Jesus meote okanicodaaɡ̶ica ligegi ane beyagi domoɡ̶owotibige me nilaagedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Igotibeci midoataɡ̶a Jesus, odaa moditalo, “Niiɡ̶axinaɡ̶anaɡ̶a, jowooɡ̶otaɡ̶a midioka limedi me enitece anewi, codaa aɡ̶ica mawii niɡ̶ina oko minoa anodiletibige daɡ̶akaami. Igaataɡ̶a aɡ̶ica mawii naɡ̶atetigi oko, pida ewi me iiɡ̶axinaɡ̶anitece naigi Aneotedoɡ̶oji. Domige lakapetegi ɡ̶onajoinaɡ̶aneɡ̶egi me jedianaɡ̶atece César dinyeelo, ninionigi-eliodi romaanotedi ane ɡ̶odiiɡ̶e me jedianaɡ̶a? Domigele me jedianaɡ̶a, oɡ̶oa aɡ̶ele?” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pida Jesus yowooɡ̶odi mokowo, odaa meetediogi, “Igame leeɡ̶odi madineenitiwatiwaji? Digawii anadeegitiwa beexo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Odaa joɡ̶oyadeegitalo aca beexo, naɡ̶a nigetediniwace, meetediogi, “Ame latobi aniwoteloco ani beexo, codaa ame liboonaɡ̶adi ane diniditeloco?” Odaa modi, “César.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Odaa Jesus meetediogi, “Enice ajicitatiwaji César ane nebi, codaa aaɡ̶aɡ̶a ajicitalo Aneotedoɡ̶oji ane nebi.” Odaa joɡ̶oyopo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶a onotalo Jesus icoa saduceutedi, niɡ̶ijo anodi Aneotedoɡ̶oji me deɡ̶eote me newiɡ̶atace niɡ̶ina oko baanaɡ̶a nigo. Odaa joɡ̶oige Jesus, moditalo, ");
INSERT INTO kbcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Niiɡ̶axinaɡ̶anaɡ̶a, Moisés didikotigi ɡ̶odoiigi niɡ̶ida najoinaɡ̶aneɡ̶egi, ‘Nigica ɡ̶oneleegiwa wadonaɡ̶a ane yeleo me diɡ̶icata lionigipi, odaa nioxoa niɡ̶ijo ane yeleo leeditibige me lodawa naɡ̶ani wajekalo micoa lionaɡ̶atege. Odaa niɡ̶idi lionigipi micataɡ̶a daɡ̶a lionigipi niɡ̶ijo ane yeleo.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Onica seete dinioxomigipi. Niɡ̶ica liidaɡ̶a naɡ̶a wado, odaa ja yeleo me diɡ̶ica lionigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Odaa niɡ̶ijo nioxoa liɡ̶eejetewa ja lodawa naɡ̶ajo wajekalo, pida niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶a yeleo me diɡ̶icata lionigi. Odaa niɡ̶ijo eledi nioxoa jaɡ̶aɡ̶eo liciagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Odaa ijotawece niɡ̶ijo seete dinioxomigipi nodawa ajokajo iwaalo, pida aɡ̶ica anini lionigitege. Naɡ̶a nigo ijotawece, odaa niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶a yeleo naɡ̶ajo wajekalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ina nigeote Aneotedoɡ̶oji niɡ̶inoa émaɡ̶aɡ̶a me newiɡ̶atace, amigepidiɡ̶ica niɡ̶ijo seete dinioxomigi anepaɡ̶a lodawa naɡ̶ajo iwaalo, igaataɡ̶a ijotawece nodawa naɡ̶ajo iwaalo?” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus meetediogi, “Eliodi mabataatiwaji leeɡ̶odi aɡ̶owooɡ̶oti aneetece Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, oteɡ̶exaaɡ̶aɡ̶a owooɡ̶oti Aneotedoɡ̶oji nimaweneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Igaataɡ̶a nigicota Aneotedoɡ̶oji meote me newiɡ̶atace niɡ̶inoa émaɡ̶aɡ̶a, niɡ̶ina oko aɡ̶alee nadonaɡ̶ateloco, pida ja liciaco aanjotedi me daɡ̶a nadonaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a nigajeeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ejiniɡ̶ica malomeɡ̶enitelocotiwaji aneetece Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi niɡ̶ijo neɡ̶eetece anodaaɡ̶ee Aneotedoɡ̶oji micota meote niɡ̶inoa émaɡ̶aɡ̶a me newiɡ̶atace. Niɡ̶ijo Aneotedoɡ̶oji me ideitedice catiwedi naɡ̶ajo nialawaana ane ídi, odaa meeteta Moisés, ‘Idioka limedi me Ee Noenoɡ̶odi Abraão, Noenoɡ̶odi Isaque, codaa me Noenoɡ̶odi Jacó.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Odaa niɡ̶idiwa ɡ̶oneleegiwadi dice newiɡ̶a, igaataɡ̶a Aneotedoɡ̶oji Noenoɡ̶odi niɡ̶ina oko ane newiɡ̶a, idiɡ̶ida aNoenoɡ̶odi émaɡ̶aɡ̶a. Odaa eliodi makamaɡ̶a adininaalenitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Onica anigepidiɡ̶ica niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés wajipatiogi niɡ̶ijoa saduceutedi modinotigimadetigi niɡ̶ijoa lotaɡ̶a Jesus. Codaa yowooɡ̶odi Jesus mele me igiditediogi. Odaa jiɡ̶igo midoataɡ̶a Jesus me ige, meetalo, “Amiida ica Aneotedoɡ̶oji liiɡ̶enatakaneɡ̶egi ane daɡ̶axa mida ane jaoɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Odaa Jesus ja igidi, meeteta, “Aneotedoɡ̶oji liiɡ̶enatakaneɡ̶eco ane daɡ̶axa mida ane jaoɡ̶ate, niɡ̶ijo niiɡ̶enatakaneɡ̶egi anee, ‘Ajipaatatiwaji, akaami anakaami loiigi Israel! Oniniwatece Ǥoniotagodi Aneotedoɡ̶oji, codaa Iniokiniwateda me Niotagodi inoatawece aninoa. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lajo memaani Ǥaniotagodi Aneotedoɡ̶oji manitawece ɡ̶adaaleɡ̶ena, codaa minitawece ɡ̶adiwigo, codaa minitawece ɡ̶adowoogo, codaa minitawece ɡ̶adoniciwaɡ̶a!’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Codaa ida eledi niiɡ̶enatakaneɡ̶egi ane daɡ̶axa mida ane jaoɡ̶a, niɡ̶ijo anee, ‘Lajo memaani eledi oko digo aneni makamaɡ̶a adinemaani!’ Niɡ̶idoa itoataale niiɡ̶enatakaneɡ̶eco daɡ̶axa mida ane jaoɡ̶ate caticedi ijoatawece niɡ̶ijoa eletidi niiɡ̶enatakaneɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Odaa niɡ̶ijo niiɡ̶axinaɡ̶anaɡ̶a meetalo Jesus, “Niiɡ̶axinaɡ̶anaɡ̶a, ele motaɡ̶ani! Me enitece anewi niɡ̶ijo neɡ̶eni me oniniwatece Ǥoniotagodi Aneotedoɡ̶oji, odaa aɡ̶icoa eledi aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Codaa daɡ̶axa mele me jemaanaɡ̶a manitawece ɡ̶odaaleɡ̶ena, minitawece ica ɡ̶odowoogo, codaa minitawece ɡ̶odiwigo, codaa minitawece ɡ̶odoniciwaɡ̶a. Odaa daɡ̶axa mele me jemaanaɡ̶a niɡ̶ina eledi oko anodaaɡ̶ejinaɡ̶a me idinemaanaɡ̶a, aliciagi niɡ̶ina me jalecaɡ̶a eijedi maditaɡ̶a nameeja Aneotedoɡ̶oji me idinilakidenaɡ̶atege leeɡ̶odi ɡ̶obeyaceɡ̶eco, codaa niɡ̶ina me jiboonaɡ̶atalo eletidi ɡ̶oboonaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus nadi niɡ̶ijo niiɡ̶axinaɡ̶anaɡ̶a ane diiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés mida lixakedi niɡ̶ijo me igidi. Odaa Jesus meeteta, “Ja domaɡ̶a ɡ̶adigomi Aneotedoɡ̶oji me iiɡ̶e ɡ̶adaaleɡ̶ena.” Niɡ̶idiaaɡ̶idi naɡ̶a nigotedini Jesus me dotaɡ̶a, odaa aɡ̶aleeɡ̶ica anabo laaleɡ̶ena me ige me dineetalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Niɡ̶ijo Jesus me diiɡ̶axinaɡ̶a minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, odaa ja nigetediniwace niɡ̶ijo oko, meetediogi, “Niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, igame leeɡ̶odi moyakadi modi Niɡ̶icoa Aneotedoɡ̶oji ane niiɡ̶e mokexaa ida aneetege licoɡ̶egi Davi? ");
INSERT INTO kbcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Igaataɡ̶a Liwigo Aneotedoɡ̶oji eo Davi me dotaɡ̶a niɡ̶ijo neɡ̶ee, ‘Inoenoɡ̶odi Aneotedoɡ̶oji meeteta Iniotagodi, “Anicootini iwai ibaaɡ̶adi nigepaa iɡ̶eke inatawece ɡ̶aneloɡ̶ododipi”.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ijaaɡ̶ijo Davi meetalo, ‘Iniotagodi’. Enige igamigodaaɡ̶ee Niɡ̶icoa Aneotedoɡ̶oji ane nimonya me yakadi mokexaa ida aneetege licoɡ̶egi Davi?” Niɡ̶ijo noiigi-nelegi eliodi moyemaa niɡ̶ijoa lotaɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus niiɡ̶axitediniwace oko, odaa meetediogi, “Anidakitiogi niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés! Igaataɡ̶a lemaanigi me ewaligitibigiwaji modinixotinigi toonicogo ocaɡ̶ataɡ̶a ane lowoodaɡ̶agi niɡ̶ina oko ɡ̶oneɡ̶aɡ̶a owotibige monicetibigiwaji codaa modeemitetibige miditaɡ̶a licooɡ̶adi oko. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lemaanigi monicotelogo nibaancotedi niɡ̶ina oko ɡ̶oneɡ̶aɡ̶a midiwataɡ̶a niiakanaɡ̶axiidi, codaa midiwataɡ̶a nibaancotedi niɡ̶ina oko anoiweniɡ̶ide miditaɡ̶a nalooɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Codaa oibanootece liɡ̶elatedi codaa ane nepilidi niɡ̶inoda wajekalodipi, codaa onowo niɡ̶ina mocaɡ̶ataɡ̶a moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Joaniɡ̶idaa leeɡ̶odi Aneotedoɡ̶oji micota meliodi me iloikatiditedibigiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus nicotedi minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi ipegitetege naɡ̶ajo iwokodaɡ̶axi nelegi aneitice niɡ̶ina oko moyokoletinigi ninyeelo anoibootalo Aneotedoɡ̶oji. Iwi anodaaɡ̶ee niɡ̶ijo oko moyajigo ninyeelo. Eliodi oko ane liicotedi oyajigo owidi dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Odaa niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶icotio aca wajekalo madewete, odaa ja yokoletinigi naɡ̶ajo iwokodaɡ̶axi iniodataale beexotedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Odaa Jesus jeɡ̶eniditediogi niɡ̶ijo anodiotibece, odaa meetediogi, “Ejitaɡ̶awatiwaji naɡ̶ada wajekalo madewete yajigo caticedi niɡ̶ina eledi oko anoyajigo. ");
INSERT INTO kbcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Leeɡ̶odi niɡ̶ina eledi oko oyajigo ninyeelo ane doɡ̶oyopotibige, pida naɡ̶ajo wajekalo baɡ̶a yajigo ijoatawece ninyeelo, ane domaɡ̶a yopotibige me dinoojetetibige ane yeligo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Niɡ̶ijo Jesus naɡ̶a doletedibige me noditedice Aneotedoɡ̶oji liɡ̶eladi, anigepidiɡ̶ica niɡ̶ijo anodiotibece meetalo, “Ǥoniiɡ̶axinoɡ̶odi, digawini niɡ̶inoa wetiadi nelecoli minitaɡ̶a niɡ̶ini diimigi! Codaa digawini niɡ̶ica me libinienigi Aneotedoɡ̶oji liɡ̶eladi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Odaa Jesus ja igidi, meeteta, “Naɡ̶anati niɡ̶ini diimigi-nelegi? Anigida noko otaɡ̶anitece wetiɡ̶a dipeteloco eledi minitaɡ̶a niɡ̶ini diimigi, onanikatedini idiwatawece.” ");
INSERT INTO kbcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus idiaaɡ̶itedice minitaɡ̶a niɡ̶ijo lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira” nicotedi, dilokotetege Aneotedoɡ̶oji liɡ̶eladi. Idiaaɡ̶itedice oniniwatece, odaa joɡ̶ototalo Pedro, Tiago, João ijaa André. Odaa joɡ̶oige, moditalo, ");
INSERT INTO kbcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Anatematiitoɡ̶owa niɡ̶ica noko nigoyojiketini Aneotedoɡ̶oji liɡ̶eladi. Codaa igamigodaaɡ̶ee Aneotedoɡ̶oji me ikee nige nipegi moyanikatini?” ");
INSERT INTO kbcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus jiɡ̶idaaɡ̶eyatedigi me yeloɡ̶oditediogi, odaa meetediogi, “Adinowetitiwaji adiɡ̶ica ane ɡ̶adinaaleni! ");
INSERT INTO kbcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Eliodi oko ane dinikeetibigiwaji, oibake Iboonaɡ̶adi, odaa modi, ‘Ee Niɡ̶ijo Aneotedoɡ̶oji ane nimonya.’ Odaa eliodi oko anoninaaletiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pida jinaɡ̶adoiitiwaji nigajipaata layaco witidi, codaa nigabodicetigi witidi, igaataɡ̶a leeditibige mina ane diniwitideɡ̶etiwage. Pida aniɡ̶icota niɡ̶ica noko Aneotedoɡ̶oji me yaaɡ̶adi niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Igaataɡ̶a niɡ̶ina noiigi dinideleɡ̶etiwage, codaa niɡ̶inoa inionaɡ̶a oiiɡ̶e loiigi me witidi. Codaa icota me datalale iiɡ̶o owidi nipodaɡ̶a, codaa eliodi noiigi nigodi nigigi, codaa mowidi ɡ̶oninyaco ane doide. Pida niɡ̶inoa nawikodico jiɡ̶inaaɡ̶odoejedi me nawikodico liciagi niɡ̶ina odoejegi lileenaɡ̶aneɡ̶egi naɡ̶ana iwaalo ipileɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pida adinowetitiwaji, igaataɡ̶a etiɡ̶adadeegiticogi lodoe niɡ̶ijoa lacilodi, codaa etiɡ̶adalakenitibigetiwaji midiwataɡ̶a niiakanaɡ̶axiidi. Codaa leeɡ̶odi maniwitici, odaa etiɡ̶adadeegiticogi lodoe niɡ̶ina aninoa naɡ̶atetico codaa midiwataɡ̶a inionaɡ̶a-eloodoli moiwi anodigotaɡ̶awatiwaji. Odaa jiɡ̶idaa nigakatitiwaji madatematiitiogi niɡ̶idiwa lacilodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pida maleedaɡ̶a yaaɡ̶aditeda Aneotedoɡ̶oji niɡ̶ina iiɡ̶o, leeditibigetiwaji matematiitiogi inatawece niɡ̶ina noiigi nibodicetedi anele anoyalaɡ̶atiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nige etiɡ̶adiwilotiwaji, odaa jeɡ̶etiɡ̶adadeegiticogi lodoe niɡ̶inoa lacilodi moiwi anodigotaɡ̶awatiwaji, jinaɡ̶a aɡ̶owikomataatiwaji ane alitigi ɡ̶agegi maleedaɡ̶a etiɡ̶adadeegitiwaji. Igaataɡ̶a enitece niɡ̶ica Aneotedoɡ̶oji ane ikeetedaɡ̶awatiwaji me alitigi ɡ̶agegi. Igaataɡ̶a niɡ̶inoa ɡ̶adotaɡ̶a aicoɡ̶oticogi makaamitaɡ̶atiwaji, pida icoɡ̶oticogi minitaɡ̶a Liwigo Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Icota dinioxomigipi moyajigo epaa nioxoadipi monigodi, codaa niɡ̶ina eniododipi oyajigo lionaɡ̶a, codaa nionigipi dakapetege eliododipi, odaa oibootiobece monigodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Eliodi oko oyelataɡ̶adomitiwaji leeɡ̶odi maniwitici. Pida Aneotedoɡ̶oji eote midioka limedi me yewiɡ̶a miniwataɡ̶a niɡ̶ina oko ane ixomaɡ̶ateetedice lawikodico, codaa me deɡ̶eyamaɡ̶atice eliwaɡ̶atakaneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Icota manati niɡ̶ica aneetece Daniel, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide, me yalaɡ̶ata niɡ̶ica niwigo noenatagi aneo niɡ̶ina oko ligecaɡ̶aloɡ̶o, libikotanaɡ̶anaɡ̶adi ane nigodi oko. Icota moidoyatice niɡ̶ica niwigo digoida ane deɡ̶ele me itice. Niɡ̶ina ane yalomeɡ̶eteloco niɡ̶idiwa notaɡ̶a ele me dinoniciwaɡ̶adi me yowooɡ̶odi ane diitigilo. Nigonadi niɡ̶ica niwigo, niɡ̶ina oko ane ideitice nipodigi Judéia leeditibige me daleditibigimoace odeletibigimece wetiadi nelecoli. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nigica oko ane idei ditibigimedi liɡ̶eladi leláɡ̶a, ele me daɡ̶adakatio me dibatalo ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Codaa nigica anidiaaɡ̶itice nixoɡ̶otagi ele me doɡ̶opitacio minitaɡ̶a liɡ̶eladi me igota nicaapa. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pida iwikodadipi iwaalepodi ipilaɡ̶aɡ̶a codaa eniododipi analee oilipeɡ̶e lionaɡ̶a! ");
INSERT INTO kbcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ele mipokitalo Aneotedoɡ̶oji me daɡ̶a ikateda meyoketege niwetaɡ̶a nige limedi me ialeticoace. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Igaataɡ̶a niɡ̶icoa nokododi owidi nawikodico. Niɡ̶ijo Aneotedoɡ̶oji me iliidaɡ̶adi niɡ̶ina iiɡ̶o codaa niɡ̶ina natigide aɡ̶ica nawikodigi liciagi niɡ̶icoa nawikodico anenagi. Codaa aɡ̶aleeɡ̶icota eledi nawikodigi liciagi niɡ̶inoa nawikodico anenagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ǥoniotagodi Aneotedoɡ̶oji noxopanatidi niɡ̶icoa nokododi minoa nawikodico. Daaditaɡ̶a noxopanatiditeda niɡ̶icoa nokododi, agotiɡ̶ica ane yakadi me yewiɡ̶a. Pida noxopanatidi niɡ̶icoa nokododi leeɡ̶odi niɡ̶ina oko ane iolatedice idioka limedi me newiɡ̶a miniwataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nigica aneetaɡ̶awatiwaji, ‘Digawini! Niɡ̶ijoa Aneotedoɡ̶oji ane nimonya etidoa digoina!’ oɡ̶oa migetoɡ̶odi, ‘Digawini! Etidoa digoida!’ Jinaɡ̶a iwaɡ̶atitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Igaataɡ̶a eliodi oko awitakaɡ̶aɡ̶a icota modi me niɡ̶idaaɡ̶idoa Niɡ̶ijoa Aneotedoɡ̶oji ane nimonya, oɡ̶oa domigodi me niɡ̶ijaaɡ̶ijo niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. Odaa owote ɡ̶odoxiceɡ̶etedi, codaa niɡ̶inoa anetiɡ̶odawelaɡ̶adi moninaaletiniwace oko. Codaa domaɡ̶a oninaaletiniwace niɡ̶ina oko Aneotedoɡ̶oji ane iolatedicoace me nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pida adinowetitiwaji! Ja jao ɡ̶adeemidi maleedaɡ̶a icotalo niɡ̶inoa nawikodico anejitalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nigidiaaɡ̶idi, nige ixomaɡ̶atedijo niɡ̶icoa nokododi menagi niɡ̶icoa nawikodico, odaa aligeɡ̶e ipe, codaa me epenai aɡ̶alee datale. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Niɡ̶inoa yotetitedi niwadetedi. Odaa Aneotedoɡ̶oji itineɡ̶e niwicidi anida nimaweneɡ̶egi digoida ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Odaa niɡ̶ina oko etidadi Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. Idinikatini jiniotinece lolaadi, odaa janagi meliodi inimaweneɡ̶egi, codaa jikee mida inaɡ̶atetigi liciagi Aneotedoɡ̶oji naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jiiɡ̶e iniaanjotedi migoteloco inatawece niɡ̶ina iiɡ̶o moniodatece niɡ̶ina oko Aneotedoɡ̶oji ane iolatedicoace me nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Digowoo naɡ̶ana niale fiigoigo, odaa akati mowooɡ̶oti. Nige dione libiwedi, codaa laamotiidi naɡ̶a nokoloɡ̶o, odaa joɡ̶owooɡ̶otitiwaji naɡ̶a nipegi limedi ebicitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Odaa jiɡ̶idaaɡ̶ee nigeno niɡ̶icoa nawikodico, odaa jaɡ̶akati mowooɡ̶otitiwaji naɡ̶a nipegi niɡ̶ica noko moyaaɡ̶adi Aneotedoɡ̶oji liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Icotece inoatawece niɡ̶inoa anejitedaɡ̶awatiwaji maleedaɡ̶a nigo eliodi oko ane newiɡ̶a niɡ̶ina noko. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ditibigimedi inaa iiɡ̶o icota me ma, pida yotaɡ̶a baadaɡ̶a ixomaɡ̶atedice. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Odaa aɡ̶ica ane yowooɡ̶odi naɡ̶aca lakata oteɡ̶exaaɡ̶aɡ̶a niɡ̶ica noko nige idopitijo. Oteɡ̶exaaɡ̶aɡ̶a niɡ̶idiwa aanjotedi digoida ditibigimedi aɡ̶oyowooɡ̶odi, oteɡ̶exaaɡ̶aɡ̶a Ee, Lionigi Aneotedoɡ̶oji ajowooɡ̶odi. Pida iniokiniwateda Aneotedoɡ̶oji ane Eiodi, baɡ̶a yowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Adinowetitiwaji, codaa midioka limedi me ɡ̶adigomi codaa otaɡ̶aneɡ̶eni Aneotedoɡ̶oji igaataɡ̶a aɡ̶owooɡ̶otitiwaji nigeno niɡ̶ica noko. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Niɡ̶ida me Ee iciagi niɡ̶ina ɡ̶oneleegiwa anigo diniwiajeticogi eledi iiɡ̶o. Odaa yajigota naɡ̶atetigi niɡ̶idiwa liimetedi, codaa yajigota oninitecibeci epaa libakedi. Odaa ja iiɡ̶e niɡ̶ini nowienoɡ̶odi diimigi midiaanaɡ̶a iɡ̶oadita me dinowedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Enice, adinowetitiwaji, igaataɡ̶a aɡ̶owooɡ̶oti niɡ̶ica noko nige idopitijo, Ee, ane iciagi niɡ̶ijo ane nebi diimigi. Yakadi me ɡ̶ocidi, domige liwigo-enoale, domige niɡ̶idatege nigoi, oɡ̶oa domige naɡ̶a yeloɡ̶otibige, nige idopitijo. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Enice adinowetitiwaji amaleeɡ̶aɡ̶a nige aweleɡ̶egi me idopitijo, odaa aɡ̶adakatitiwaji me iote, oteɡ̶exaaɡ̶aɡ̶a me daɡ̶awii niɡ̶ijo ɡ̶abakedi ane joyataɡ̶adomitiwaji mawii. ");
INSERT INTO kbcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Niɡ̶ida anejitaɡ̶awatiwaji, ejitiogi iditawece iotagipi, maɡ̶aɡ̶a dinoweditibigiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aniaditibige itoataale nokododi daɡ̶a nakatio nalokegi anodita me Páscoa, codaa niɡ̶ijo eledi nalokegi anodita “Lalokegi paon ane diɡ̶ica labookojegi”. Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés odoletibige niɡ̶ica nimaweneɡ̶egi modolicetalo Jesus moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pida modi, “Aɡ̶ele me jibaɡ̶atalo midi nalooɡ̶o ade jaoɡ̶atibige niɡ̶idi noiigi metiɡ̶odideleɡ̶e.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Niɡ̶ijo Jesus midiaaɡ̶itedice manitaɡ̶a nigotakawaana Betânia, minitaɡ̶a liɡ̶eladi Simão niɡ̶ijo anijo me dawace-lolaadi. Naɡ̶aniodi, jiɡ̶igo aca iwaalo miniwataɡ̶a yadeegi aca bootawaana wetiɡ̶a ane liboonaɡ̶adi “alabastro”. Naɡ̶ajo bootawaana nolee nadokojegi ane liboonaɡ̶adi “nardo”. Niɡ̶ijo nadokojegi aɡ̶ica gaantiɡ̶ini lalegedi, codaa dakake loojedi. Naɡ̶ajo iwaalo noyaaɡ̶adi naɡ̶ajo bootawaana, odaa ja yadoteloco Jesus lacilo niɡ̶ijo nadokojegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ica oko anidiaaɡ̶itice anonadi oyelatema, odaa dinotaɡ̶aneɡ̶e, modi, “Igame leeɡ̶odi me yame ida nadokojegi? ");
INSERT INTO kbcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aɡ̶oniaaɡ̶eyaa niɡ̶ida nadokojegi loojedi caticedi miniwatadaɡ̶ani taalia beexotedi (abotege loojedi onidateci nicaaɡ̶abi me jibaaɡ̶a), oditaɡ̶a yajigotiogi niɡ̶inoa madewetedi niɡ̶idiwa dinyeelo owidi.” Odaa joɡ̶oyapeteɡ̶e naɡ̶ajo iwaalo. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pida Jesus meetediogi, “Ikanitiwaji naɡ̶ani iwaalo! Igame leeɡ̶odi manapeteɡ̶enitice? Eotomi niɡ̶ica nibakedi libinienigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Igaataɡ̶a niɡ̶inoa madewetedi idioka limedi mina makaamitaɡ̶atiwaji, odaa akati me axawanitiogi nigemaani. Pida Ee baadiɡ̶idioka limedi minaaɡ̶ejotice makaamitaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Naɡ̶ani iwaalo eo niɡ̶ica ane yakadi meo. Enagi maleedaɡ̶a ideleo nenyaɡ̶adi yolaadi monaligitini. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ina moyatematitedibece niɡ̶inoa nibodicetedi anele aneetici inatawece iiɡ̶o, oyatematitibece niɡ̶ida aneotomi moyalaɡ̶atibige naɡ̶ani iwaalo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariotes niɡ̶ijo anida aneetege niɡ̶ijo dooze anodiotibece Jesus igo yotaɡ̶aneɡ̶e niɡ̶ijo anoiiɡ̶e sacerdotitedi me dinilakidetege me yajigo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Odaa eliodi me ninitibigiwaji noɡ̶owajipa ane ligegi, odaa joɡ̶odinilakidetege moyedia. Odaa Judas jiɡ̶idaa dinanatigi me doletibige niɡ̶ica nimaweneɡ̶egi me yajigo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Niɡ̶ijo odoejegi noko nalokegi ane liboonaɡ̶adi “Paon ane diɡ̶ica labookojegi”, niɡ̶ijoa judeutedi onigodi waxacocoli me odinenyaɡ̶aditege moyoe liweenigi nige nakatio nalokegi Páscoa. Niɡ̶ijo noko niɡ̶ijo anodiotibece oige Jesus, moditalo, “Igamemaani meitice me joenaɡ̶a ɡ̶oweenigi lajo Páscoa?” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Odaa Jesus ja iiɡ̶e itoataale niɡ̶ijo anodiotibece, meetediogi, “Emiitiwaji nigotaɡ̶a, odaa akapetege ɡ̶oneleegiwa ane yoyaɡ̶adi leo ane nolee ninyoɡ̶odi. Odaa iwitecetiwaji lowidi niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nige dakatiwece diimigi, enitatiwaji niɡ̶ini ane nebi diimigi, ‘Ǥoniiɡ̶axinoɡ̶odi ɡ̶odiiɡ̶e me jigikanaɡ̶atigi ane diɡ̶etigi ica ɡ̶odicooɡ̶adi aneitice me jelicaɡ̶a liweenigi nalokegi Páscoa me ligiiwepodi anodiotibece.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Odaa ikeetaɡ̶awa ɡ̶odicooɡ̶adi nelegi ditibigimedi dalaɡ̶ate diimigi. Niɡ̶ini ɡ̶odicooɡ̶adi jaigo, codaa idiwa inoatawece ane jopooɡ̶atibige. Odaa oenitiwaji ɡ̶oweenigi lajo nalokegi Páscoa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Odaa niɡ̶ijo itoataale anodiotibece jiɡ̶igotibeci, odaa joɡ̶oyakadi ijoatawece niɡ̶ijoa aneetediogi Jesus. Odaa joɡ̶oyoe ica liweenigi Páscoa. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Niɡ̶ijo naɡ̶a dawike, Jesus jiɡ̶icotedio minitaɡ̶a niɡ̶ijo diimigi lixigaɡ̶awepodi niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Odaa eɡ̶idaaɡ̶ee me niodaɡ̶a maditaɡ̶a nameeja, Jesus meetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi, ini niɡ̶ina akaamitiwaji anadigiwani, idajigotiogi ineloɡ̶ododipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Odaa jiɡ̶idaa diiticogi magecaɡ̶alodipi, codaa oninitecibeci ige Jesus, meetalo, “Domige ee ɡ̶adajici? Ejidaɡ̶a jakadi daɡ̶a ɡ̶adajici!” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Odaa Jesus meetediogi, “Niɡ̶ini ane ititinigi nipaon liwagedi midataɡ̶a ɡ̶odokoladi niɡ̶ina akaamitiwaji anakaami igiiwepodi, jiɡ̶iniaa idajigo. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji yalaɡ̶atiwa, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, me leeditibige me ideleo. Pida nagoodi niɡ̶ini ɡ̶oneleegiwa ane idajigotiogi ineloɡ̶ododipi, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. Ejimetaɡ̶a daɡ̶axa meletema niɡ̶ini ɡ̶oneleegiwa daaditiɡ̶icata menitini! (Igaataɡ̶a Aneotedoɡ̶oji eliodi me iloikatidi niɡ̶ini ɡ̶oneleegiwa.)” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Niɡ̶ijo maleeɡ̶idaaɡ̶ee me niodaɡ̶a, Jesus dibate ijo paon, odaa diniotagodete Aneotedoɡ̶oji leeɡ̶odi niɡ̶ijo paon. Naɡ̶a ninoketedini niɡ̶ijo paon, odaa ja yajigotediogi niɡ̶ijo anodiotibece. Odaa meetediogi, “Nee, abaategetiwaji! Niɡ̶idi paon jiciaceeketege yolaadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Niɡ̶idiaaɡ̶idi odaa jaɡ̶aɡ̶a dibate aca goopa ane nolee viinyo. Naɡ̶a diniotagodete Aneotedoɡ̶oji, odaa ja yajigotediogi naɡ̶ajo goopa ane nolee viinyo, odaa ijotawece owacipeta niɡ̶ijo viinyo. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Odaa Jesus meetediogi, “Niɡ̶ida viinyo jiciaceeketege yawodi ane inadooɡ̶odi leeɡ̶odi eliodi oko. Odaa Aneotedoɡ̶oji jiɡ̶ida gela nimaweneɡ̶egi me dinilakidetetege niɡ̶ina oko leeɡ̶odi me inadooɡ̶odi yawodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aɡ̶alee jacipe niɡ̶ida viinyo nigepaaɡ̶icota me iiɡ̶e Aneotedoɡ̶oji laaleɡ̶enali niɡ̶ina oko, odaa micataɡ̶a daɡ̶a jacipeta gela latopagi viinyo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naɡ̶a nigotiniwace me nigaanaɡ̶anaɡ̶a, moigaa onateciɡ̶ijoa Elaco Davi, odaa ja noditicoaci, jiɡ̶igotibeci minitaɡ̶a lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira”. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus meetediogi niɡ̶ijo anodiotibece, “Inaaɡ̶ina niɡ̶ina enoale, akaamitawecetiwaji adikani, igaataɡ̶a diniditeloco maditaɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji ane yalaɡ̶ate Aneotedoɡ̶oji, niɡ̶ijo mee, ‘Jeloadi niɡ̶ini nowienoɡ̶odi waxacocoli, odaa niɡ̶idiwa waxacocoli ilaagitiwaji.’ ");
INSERT INTO kbcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pida nigidiaaɡ̶idi nige idewiɡ̶atace, ejigo ɡ̶adodoetiwaji miditaɡ̶a nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pida Pedro meetalo, “Icaaɡ̶ica nige inatawece etiɡ̶adikani, pida ee baadaɡ̶a ɡ̶adikani!” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Odaa Jesus meeteta, “Ejitaɡ̶awa niɡ̶ina anewi. Inaaɡ̶ina niɡ̶ina enoale, aniɡ̶icatibige daɡ̶a itoataale manoe okoɡ̶okoodi, odaa itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pida Pedro dinoniciwaɡ̶aditibece me igidi, mee, “Ica deɡ̶eji me daɡ̶a ɡ̶adowooɡ̶oti, icaaɡ̶ica nige leeditibige makaami yemaɡ̶awa, ja idigo makaami yemaɡ̶awa!” Odaa ijotawece niɡ̶ijo eledi anodiotibece idaaɡ̶oyatigi ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece igotibeci midiwataɡ̶a nawodigijedi nialeli “oliveira” ane liboonaɡ̶adi Getsêmani. Niɡ̶idiaaɡ̶idi meetediogi, “Inaaɡ̶oni anicootiniwacetiwaji, ejigo jotaɡ̶aneɡ̶e Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Baɡ̶a yadeegi lixigaɡ̶awepodi Pedro, Tiago ijaa João. Odaa jiɡ̶idaa diiticogi meliodi magecaɡ̶alo, doitedibece, codaa me doɡ̶owikomata. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Odaa meetediogi, “Catiwedi yaaleɡ̶ena eliodi me Ee agecaɡ̶alo, ane jeemitetece liciagi niɡ̶ina daantaɡ̶a doletibige me ideleo. Inaaɡ̶onitetiwaji, codaa adinoweti.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Odaa jiɡ̶igoawaanigi odoe, odaa ja yamaɡ̶atedinigiiɡ̶o lokotidi, odaa dipokote Aneotedoɡ̶oji dokaaɡ̶a yakadi me yatamaɡ̶ateetetege naɡ̶aca lakata niɡ̶icoa lawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Odaa Jesus mee, “Eiodi yemaanigi, akati mawii okanicodaaɡ̶ica. Nigemaani adatamaɡ̶ateenitege niɡ̶icoa yawikodico ane leeditibige me jixomaɡ̶ateetedice! Pida jemaa me jao niɡ̶ica anemaani, idiɡ̶ida aɡ̶inokinoa niɡ̶inoa ane emaɡ̶a jemaa me jaote.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Niɡ̶ijo naɡ̶a dopitetege niɡ̶ijo itoatadiɡ̶ida anodiotibece, odaa enotediogi me niotaɡ̶ateloco, odaa meeteta Simão Pedro, “Simão, iote? Aɡ̶akati madinoweti oteɡ̶exaaɡ̶aɡ̶a onaniteci lakata? ");
INSERT INTO kbcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Adinowetitiwaji, codaa otaɡ̶aneɡ̶eni Aneotedoɡ̶oji me daɡ̶a abataa nige dineetaɡ̶awa Satanás. Igaataɡ̶a beɡ̶emaani mawiitiwaji niɡ̶ina Aneotedoɡ̶oji ane yemaa, pida aɡ̶ica ɡ̶adoniciwaɡ̶atiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus ja yetecetacedicoace niɡ̶ijo itoatadiɡ̶ida anodiotibece, odaa jiɡ̶igotace yotaɡ̶aneɡ̶e Aneotedoɡ̶oji yopilaɡ̶ateetedeloco ijaaɡ̶ijoatace niɡ̶ijoa ane lotaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naɡ̶a dopitacedijo miditaɡ̶a niɡ̶ijo anodiotibece, odaa jeɡ̶enotacediogi me niotaɡ̶a. Leeɡ̶odi eliodi me liotaɡ̶a, codaa aɡ̶oyakadi me noleticoace. Odaa aɡ̶oyowooɡ̶odi niɡ̶ica anoyatigi ligegi moyotaɡ̶aneɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Niɡ̶idiaaɡ̶idi Jesus jiɡ̶igotace yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Niɡ̶ijo naɡ̶a itoatadiɡ̶ida me dopitacediogi niɡ̶ijo anodiotibece, odaa meetediogi, “Eɡ̶iotetiwaji, eɡ̶idaaɡ̶ee manipenitiniwace? Jaɡ̶abotiwaji! Naɡ̶aca inilakata me jawikode ja nipegi micoteloco. Jeɡ̶etidajigotiogi libaaɡ̶adi niɡ̶ijoa ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Adabititiniwacetiwaji, jopilaɡ̶a! Digawini! Etina jeɡ̶enagi niɡ̶ijo ane idajigotiogi ineloɡ̶ododipi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Eɡ̶idaaɡ̶eeteda me dotaɡ̶a Jesus, odaa jiɡ̶icotalo Judas niɡ̶ijo anida aneetege niɡ̶ijo anodiotibece Jesus. Lixigaɡ̶awepodi eliodi oko liiɡ̶exedi niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, ijaa niɡ̶ijo laxokodi lacilodi niɡ̶ijo noiigi. Niɡ̶ijo noiigi-nelegi onigoetigilo nodaajoli-ocaɡ̶atedi inaa neboli. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Niɡ̶ijo Judas ane yajigo Jesus maleediɡ̶icotalo, ja yeloɡ̶odi ica anodaaɡ̶igotalo me ikee Jesus. Odaa meetiogi, “Niɡ̶ica ɡ̶oneleegiwa ane inapicoɡ̶o jiɡ̶idaaɡ̶idoa niɡ̶ijoa anoleetibigetiwaji. Odaa abaatalo, adeegitetiwaji maniwilo.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Odaa Judas jiɡ̶igo dowicetelogo Jesus, odaa meetalo, “Iniiɡ̶axinoɡ̶odi, iniiɡ̶axinoɡ̶odi!”, odaa ja napicoɡ̶o Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Odaa joɡ̶odibatalo Jesus, joɡ̶oniwilo. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pida ganigepidiɡ̶ica niɡ̶ijo anidiaaɡ̶i midoataɡ̶a nixigitice lodaajo-ocaɡ̶ataɡ̶a, odaa ja yakagiditice napaaɡ̶ate niɡ̶ijo liotagi niɡ̶ijo lacilo-sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Odaa Jesus meetediogi niɡ̶ijo noiigi anodibatalo, “Managitiwaji adiwilo anadeegi ɡ̶adodaajoli, ɡ̶aneboli micataɡ̶a daɡ̶a Ee ɡ̶oneleegiwa agopeloagi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Owidi nokododi idiaaɡ̶ejotice minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, jiniiɡ̶axitiniwace noiigi, pida aɡ̶adiwilotiwaji. Pida natigide jiɡ̶icota aneeta lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Odaa ijotawece niɡ̶ijo anodiotibece joɡ̶oika aɡ̶aleeɡ̶ica mowote, ja daleditibige. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Onini ica lioneeɡ̶a ane diotibece Jesus. Onadi me dinilipaditigi niɡ̶elate me yapoɡ̶oditini lolaadi. Odaa joɡ̶odoletibige modibata domoɡ̶oniwilo. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pida yaladi naɡ̶ajo niɡ̶elate, odaa jeɡ̶elodi mokijotani. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Odaa joɡ̶oyadeegitedicogi Jesus minitaɡ̶a diimigi-nelegi liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. Ja dinatecoɡ̶otee niɡ̶ijo anoiiɡ̶e sacerdotitedi, codaa me niɡ̶ijoa lacilodi noiigi judeu ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro diotece Jesus pida leegitalo me yetecetedice, odaa ja dakatiwece miditaɡ̶a niogó niɡ̶ijo diimigi-nelegi ane liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. Odaa ja nicotini liwigotigi niɡ̶ijoa niotaka liniogotibece noledi maɡ̶aɡ̶a dinito. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Niɡ̶ijo anoiiɡ̶e sacerdotitedi codaa mijotawece niɡ̶ijoa seteenta lacilodi judeutedi odoletibige gaantiɡ̶ijo ane yakadi anigetiɡ̶ida ane leeɡ̶odi modinanimaɡ̶atalo Jesus domoɡ̶owotibige doɡ̶odiiɡ̶enatakatalo moyeloadi. Pida aɡ̶ica anoyakadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Eliodi oko owote liwitakeco moyalaɡ̶atalo Jesus, pida niɡ̶icoa lotaɡ̶a aɡ̶ica ane niwoditema. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Odaa onijo ica oko ane dabiditiniwace, odaa ja niwitakaɡ̶a, modi, ");
INSERT INTO kbcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Jajipaaɡ̶atalo me yalaɡ̶ate me yaaɡ̶adi niɡ̶ini Aneotedoɡ̶oji liɡ̶eladi ane loenatagi ɡ̶oneleegiwadi, odaa nige itoatadiɡ̶ida nokododi, odaa jeɡ̶eotace eledi diimigi ane daɡ̶a loenatagi ɡ̶oneleegiwadi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pida oteɡ̶exaaɡ̶aɡ̶a niɡ̶ijoa notaɡ̶a ane domoɡ̶owote modakapetege Jesus aɡ̶oniwoditema. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Odaa niɡ̶ijo lacilo-sacerdotitedi ja dabiditi liwigotigi niɡ̶ijo oko, odaa ja ige Jesus, meetalo, “Aɡ̶ica ɡ̶agegi? Amiinoa icoa lotaɡ̶a idiwa ɡ̶oneleegiwadi modakapetaɡ̶agi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pida Jesus aɡ̶ica gaantiɡ̶ini ligegi. Odaa niɡ̶ijo lacilo-sacerdotitedi ja igetace Jesus, meetalo, “Domige naɡ̶akamaɡ̶akaami Niɡ̶icoa Aneotedoɡ̶oji ane niiɡ̶e me ɡ̶odatamaɡ̶ateetege ɡ̶odaxakawadi, Lionigi Niɡ̶ijoa ane joɡ̶eeɡ̶atalo?” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Odaa Jesus ja igidi, meeteta, “Jeɡ̶emeɡ̶ee. Codaa akaamitawecetiwaji icota madati me idicotini liwai libaaɡ̶adi Aneotedoɡ̶oji anida eliodi nimaweneɡ̶egi. Codaa icota madatitiwaji, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige jiniotinece lolaadi jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Odaa niɡ̶ijo lacilo-sacerdotitedi ja yaaɡ̶adi niɡ̶ijoa lowoodi diletibige Jesus daɡ̶a dotaɡ̶atibige Aneotedoɡ̶oji, mee, “Aɡ̶alee jopooɡ̶atibige eledi oko ane neloɡ̶oditoɡ̶owa ane libatiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jaɡ̶ajipaatalotiwaji niɡ̶ijoa lotaɡ̶a me dotaɡ̶atibige Aneotedoɡ̶oji. Amiida ica anakatitecetiwaji?” Odaa ijotawece ja nilaagedi Jesus codaa modi me leeditibige moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Odaa joniɡ̶ica niɡ̶ijo oko jiɡ̶idaaɡ̶oyatedigi Jesus monawaletedice. Codaa onibatoo latobi Jesus monalaketedibige, odaa moditalo, “Iwela! Amiijo ica ane ɡ̶adalakeni?” Odaa niɡ̶ijoa nowienoɡ̶ododi eledi onalaketedibige maleedoɡ̶oyadeegiteda. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Niɡ̶ijo Pedro maleeɡ̶idiaaɡ̶itice miditaɡ̶a niogó niɡ̶ijo liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi, odaa jiɡ̶icota aca awicije liota niɡ̶ijo lacilo-sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro idiaaɡ̶itice liniogotibece noledi dinito. Naɡ̶ajo awicije naɡ̶a nadi Pedro, iwita, odaa mee, “A-aami eledi idiaaɡ̶o-oonitice mijoataɡ̶a Jesus, niɡ̶ijoa Nazareeno.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pida Pedro me dotaɡ̶a mee me diɡ̶ica me dinadeegitibigege Jesus, odaa mee, “Oteɡ̶exaaɡ̶aɡ̶a jowooɡ̶otawaanigiteda niɡ̶icoa ɡ̶oneleegiwa anenitalo.” Odaa jiɡ̶igo midataɡ̶a lapoagi niogó niɡ̶ijo diimigi. Odaa jaɡ̶anoe okoɡ̶okoodi. ");
INSERT INTO kbcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Odaa aca eledi niota naɡ̶a nadi Pedro niɡ̶ijo aneitice. Odaa naɡ̶ajo niota meetiogi niɡ̶ica oko anodipegitege, “Niɡ̶ida aaginaɡ̶a eledi do-ootibece Jesus.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Odaa Pedro meetace me daɡ̶a diotibece Jesus. Naɡ̶a leecawaanigi, niɡ̶ijo oko anodipegitege moditaca Pedro, “Ejimewi makaami niɡ̶ijo ane-diotibece, igaataɡ̶a yeloɡ̶o micoɡ̶iticogi nipodigi Galiléia, leeɡ̶odi ɡ̶adotaɡ̶anaɡ̶awa niɡ̶ina oko ane icoɡ̶oticogi digoida Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pida Pedro jiɡ̶idaa dinanatacigi me dotaɡ̶a, mee, “Jemaa Aneotedoɡ̶oji me idiloikatidi nige deɡ̶ejitece anewi! Igaataɡ̶a ewi meji me daɡ̶a jowooɡ̶oditeda niɡ̶icoa ɡ̶oneleegiwa ane ɡ̶adalakitalotiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Odaa niɡ̶ijo okoɡ̶okoodi jaɡ̶anoetace. Odaa Pedro ja nalaɡ̶atibige niɡ̶ijoa ane lotaɡ̶ate Jesus, niɡ̶ijo meeteta, “Maleedaɡ̶a itoataale manoe okoɡ̶okoodi, odaa itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti.” Niɡ̶ijo Pedro naɡ̶a yowo niɡ̶ijoa Jesus lotaɡ̶ate, odaa eliodi magecaɡ̶alo, codaa anoe. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Niɡ̶ijo naɡ̶a yeloɡ̶otibige, odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi odinatecoɡ̶oteetege niɡ̶ijoa laxokodi lacilodi judeutedi ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odinilakidetege niɡ̶ijoa eletidi seteenta lacilodi noiigi judeu. Odaa joɡ̶oigoetedi Jesus, joɡ̶oyadeegi igotibeci moyajigotalo Pilatos, niɡ̶ijo ninionigi-eliodi romaanotedi ane iiɡ̶e niɡ̶idi nipodigi Judéia. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Odaa Pilatos ja ige Jesus, meetalo, “Naɡ̶akamaɡ̶akaami ninionigi-eliodi judeutedi?” Odaa Jesus naɡ̶a igidi, meeteta, “Analiiki niɡ̶ida ane alitigi ɡ̶agegi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Niɡ̶ijo anoiiɡ̶e sacerdotitedi eliodi modotaɡ̶atibige Jesus me domoɡ̶owotibige me odinanimaɡ̶atalo lodoe Pilatos. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Odaa Pilatos ja igetace Jesus, meetalo, “Aɡ̶ica anigetiɡ̶ida ɡ̶adopilaɡ̶atagitiogi? Digawini, eliodi modotaɡ̶atibigaɡ̶aji, odinanimaɡ̶ataɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pida Jesus aɡ̶ica gaantokaaɡ̶ida ligegi, odaa Pilatos eliodi me yopo. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Niɡ̶ina me nakatio lalokegi Páscoa, Pilatos ligileɡ̶egi me ikatema niɡ̶idi noiigi judeu onidateci niwilogojegi, niɡ̶ica anepaaɡ̶odipokotibige niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Odaa onini ica niwilogojegi ane liboonaɡ̶adi Barrabás. Barrabás icaaɡ̶icoa lokaaɡ̶etedi diniwilotibigiwaji leeɡ̶odi me nideleɡ̶etiniwace romaanotedi ane niiɡ̶enatakanaɡ̶a, codaa daije. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Niɡ̶ijo noiigi-nelegi dinatecoɡ̶otee, odaa jiɡ̶idaaɡ̶oyatigi modipokota Pilatos niɡ̶ica ane ligileɡ̶egitibece meo. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Odaa Pilatos igidi, meetiogi, “Emaanitiwaji me jikatedaɡ̶adomitiwaji ninionigi-eliodi ɡ̶adoiigi judeutedi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatos eote niɡ̶ijoa lotaɡ̶a leeɡ̶odi yowooɡ̶odi niɡ̶ijo anoiiɡ̶e sacerdotitedi moyajigo Jesus leeɡ̶odi monocetema. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pida niɡ̶ijo anoiiɡ̶e sacerdotitedi idioka limedi moyoniciwaɡ̶adi niɡ̶ica noiigi modipokota Pilatos me daɡ̶a ikatedice Jesus, pida odipokota mijapaɡ̶a ikatice Barrabás. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos ja nigetaciniwace, meetiogi, “Enice, amiida anemaani mejigotalo niɡ̶idoa ɡ̶oneleegiwa ane alitedigitiwaji me ‘Ninionigi-eliodi judeutedi’?” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Odaa niɡ̶ijo noiigi napaawaɡ̶ateloco, modi, “Otonitedeloco nicenaɡ̶anaɡ̶ate meloati!” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Odaa Pilatos ja nigetaciniwace, meetiogi, “Pida amiida ica loenatagi ane beyagi?” Odaa jeɡ̶epaanaɡ̶a napaawaɡ̶ateloco, modi, “Otonitedeloco nicenaɡ̶anaɡ̶ate meloati!” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatos yemaa me yocaɡ̶aneɡ̶e niɡ̶idi noiigi. Odaa joaniɡ̶idaa leeɡ̶odi me ikatema Barrabás, odaa ja diiɡ̶enatakatalo monalaketedibige Jesus, yajigo midiwataɡ̶a iodaɡ̶awadi moyototedeloco nicenaɡ̶anaɡ̶ate moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oyadeegi Jesus catiwedi niɡ̶ijo diimigi-nelegi, liɡ̶eladi niɡ̶ijo lacilo romaanotedi, odaa ijoatawece niɡ̶ijoa iodaɡ̶awadi dinatecoɡ̶otee. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Odaa joɡ̶onixomeɡ̶etedinigi Jesus aca caapa lixagotoɡ̶ogo, liciagi nicaapa niɡ̶inoa inionaɡ̶a-eloodoli. Odaa joɡ̶owo lale odatika lalepiɡ̶igo moyoe, odaa joɡ̶onixotinece Jesus lacilo. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Odaa jiɡ̶idaaɡ̶oyatedigi moyame, modi, “Niɡ̶idoa ninionigi-eliodi judeutedi!” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Odaa onaxacoɡ̶otice lacilo, oyatitalo laxacoɡ̶onaɡ̶adi, onawaletedice, codaa moyamaɡ̶atedini lokotidi lodoe, onowo moiweniɡ̶ide. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Niɡ̶ijo noɡ̶oika moyametibigo, odaa joɡ̶onoɡ̶a naɡ̶ajo nicaapa lixagotoɡ̶ogo, odaa joɡ̶onixomeɡ̶etacedinigi niɡ̶ijoa epaa lowoodi. Odaa joɡ̶oyadeegi moyototedeloco nicenaɡ̶anaɡ̶ate moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Niɡ̶ijo maleeɡ̶idaa diiticogi migotibeci minitaɡ̶a lojotaɡ̶adi, odaa joɡ̶odakapetege ica ɡ̶oneleegiwa ane liboonaɡ̶adi Simão anelatibige nigotaɡ̶a Cirene. Simão eliodi Alexandre ijaa Rufo, icoɡ̶oticogi nipodigi, igotibeci nigotaɡ̶a Jerusalém. Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oiedeɡ̶etege Simão me yoyaɡ̶adi naɡ̶ajo licenaɡ̶anaɡ̶ate Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Odaa joɡ̶oyadeegitedicogi Jesus minitaɡ̶a lojotaɡ̶adi ane liboonaɡ̶adi Gólgota (ane diitigi “Aneitice ɡ̶odacilo libitaka”.) ");
INSERT INTO kbcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Odaa niɡ̶idiaaɡ̶idi domoɡ̶oyajigotalo Jesus me wacipete viinyo awatege ica mirra ane yaaɡ̶aditice niɡ̶ina ane jileenaɡ̶a, pida awacipete. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Odaa niɡ̶idiaaɡ̶idi joɡ̶oyototedi Jesus maditaɡ̶a naɡ̶ajo nicenaɡ̶anaɡ̶ate. Odaa noɡ̶odinawalacetigi niɡ̶ijoa Jesus lowoodi, oiwi niɡ̶ica anepaɡ̶a dinetetece me yakadi oniditecibeci lowoodaɡ̶agi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Onaca noove lakata me nigoitijo niɡ̶ijo noɡ̶oyototedi Jesus madataɡ̶a nicenaɡ̶anaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Diniditeloco niɡ̶ica ane leeɡ̶odi moyeloadi Jesus, oiditeloco taaboa ditibigimedawaanigi lacilo, iwoteloco, ");
INSERT INTO kbcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Codaa niɡ̶ijoa iodaɡ̶awadi aaɡ̶aɡ̶a oyototedi itoata agopeloaɡ̶a midoataɡ̶a eletidi nicenaɡ̶anaɡ̶atedi. Onijoteci oidoyatice liwai libaaɡ̶adi Jesus, odaa ica eledi agopeloagi oidoyatice eledi liwai diɡ̶etege nimagijegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Odaa jiɡ̶idaaɡ̶ee micotece niɡ̶ijo aneetece Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, niɡ̶ijo neɡ̶ee, “Anodigotaɡ̶awa owo liciagi niɡ̶ijoa agopeloaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Niɡ̶ijo oko anidiaaɡ̶igotinece midoataɡ̶a onalomeɡ̶etedice. Codaa oyabale inoa lacilodi, modi, “Aidiiɡ̶a! Geemeni me domaɡ̶a ojikeni liɡ̶eladi Aneotedoɡ̶oji, odaa domaɡ̶a adabiteɡ̶enitacini catiwedi itoatadiɡ̶ida nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jaɡ̶abo mawikodee, axotitice naɡ̶ada ɡ̶adicenaɡ̶anaɡ̶ate!” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Idaaɡ̶ee maɡ̶aɡ̶a oyalomeɡ̶e niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa niɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Odaa dinotaɡ̶aneɡ̶etiwage, modi, “Eote niɡ̶ijo eledi oko me newiɡ̶atace, pida ayakadi mepaa dinewikatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Odaa moditalo Jesus, “Akaami ane eni Aneotedoɡ̶oji me ɡ̶adimonyaa me ɡ̶odatamaɡ̶ateenitege ɡ̶odaxakawadi, akaami ane eni makaami ninionigi-eliodi ɡ̶odoiigi Israel, adaxotiti niɡ̶ina natigide naɡ̶ada ɡ̶adicenaɡ̶anaɡ̶ate bidige jakataɡ̶a me jinataɡ̶a, codaa me ɡ̶adadiwaɡ̶ateɡ̶egi!” Codaa me niɡ̶ijoa itoataale agopeloaɡ̶a anaɡ̶aɡ̶oyototiniwace midoataɡ̶a nicenaɡ̶anaɡ̶atedi aaɡ̶aɡ̶a oyalomeɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Niɡ̶ijo naɡ̶a yaxoɡ̶o-noko, ja nexocaɡ̶a inatawece iiɡ̶o, odaa nexocaɡ̶a neɡ̶epaa iniwatadaɡ̶ani lakata me ɡ̶ocidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Niɡ̶ijo naɡ̶a iniwatadaɡ̶ani lakata me ɡ̶ocidi, odaa Jesus igedi me dapaawe, mee, “Eloí, Eloí, lemá sabactani?” (Niɡ̶idiwa lotaɡ̶a amina anejinaɡ̶a “Inoenoɡ̶odi, Inoenoɡ̶odi, igaamee me daɡ̶adiaaɡ̶ica mawiitigiji?”) ");
INSERT INTO kbcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anigepidiɡ̶ica niɡ̶ijo oko anidiaaɡ̶itice owajipatalo niɡ̶ijoa lotaɡ̶a Jesus, odaa modi, “Digajipaatalo! Dapaawetedigi Elias!” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Odaa onijoteci niɡ̶ijo anidiaaɡ̶itice midoataɡ̶a walokodi, odaa itiminatidi niɡ̶ijo litikonaɡ̶anaɡ̶adi midataɡ̶a niɡ̶ijo viinyo ane daɡ̶a dakake loojedi. Odaa ja dabiteɡ̶etibigimece Jesus me domeɡ̶eo me ilibitetece. Odaa mee, “Alotacaliita! Jemaa me jiwinaɡ̶a Elias nigenagi noɡ̶atedice madataɡ̶a naɡ̶ada nicenaɡ̶anaɡ̶ate.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Odaa Jesus dinigetaɡ̶ateetace me dapaawe, odaa ja yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Onada minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi aca lipegeteɡ̶e ane noxoco niɡ̶ijo diimigi-le ane ijokijoateda Aneotedoɡ̶oji mida aneetetege. Naɡ̶ajo lipegeteɡ̶e daawidigidicetigi liwigotigi ditibigimedi neɡ̶epaa natinedi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Idiaaɡ̶itice lodoe licenaɡ̶anaɡ̶ate Jesus ica jajeentegi. Niɡ̶ijo naɡ̶a nadi anodaaɡ̶eeteda Jesus me dapaawe codaa anodaaɡ̶eeteda me yeleo, odaa mee, “Niɡ̶idoa ɡ̶oneleegiwa dicewi me Lionigi Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Onaɡ̶aɡ̶a idiaaɡ̶iticoaci ica iwaalepodi pida leegitiogi moiɡ̶oaditalo. Liwigotigi niɡ̶ijo iwaalepodi ani naɡ̶ajo anodita Maria Madalena, Salomé, ajaa Maria ane eliodo José, ijaa Tiago ane niloxooxegi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Niɡ̶ijo Jesus maleeɡ̶idiaaɡ̶itedice nipodigi Galiléia, niɡ̶idi iwaalepodi odiotibece oyaxawa. Onidiaaɡ̶aɡ̶a itice ica eliodi eledi iwaalepodi ane lixigaɡ̶awepodi maleekokigoteda Jesus manitaɡ̶a nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Niɡ̶ijo noko maleedaɡ̶a nakatio saabado, noko noɡ̶odinoweditege ica lalokegi Páscoa. Naɡ̶a ɡ̶ocidi, jiɡ̶icotio José anelatibige nigotaɡ̶a Arimatéia minitaɡ̶a Pilatos. José ɡ̶oneleegiwa anele, lokaaɡ̶etedipi me nibaaɡ̶a niɡ̶ijoa seteenta lacilodi judeutedi. Ja walitege niɡ̶ica noko Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali niɡ̶ina oko. José abo laaleɡ̶ena migo dipokota Pilatos Jesus lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos yopo niɡ̶ijo naɡ̶a dibodicetibige Jesus naɡ̶a yeleo. Odaa jeɡ̶enidita niɡ̶ijo jajeentegi me ige domigewi naɡ̶a leecawaanigi me yeleo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Niɡ̶ijo jajeentegi naɡ̶a yeloɡ̶odita mewi, odaa Pilatos ja ika José me yadeegi Jesus lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José dinoojeteta aca lipegeteɡ̶e lapacoɡ̶ogo, odaa ja noɡ̶a Jesus lolaadi madataɡ̶a nicenaɡ̶anaɡ̶ate, odaa ja ilipaditigi Jesus lolaadi naɡ̶ajo lipegeteɡ̶e. Niɡ̶idiaaɡ̶idi ja yadeegiticogi Jesus lolaadi midataɡ̶a ica ane gela moigodi lawimaɡ̶ajegi-wetiɡ̶a. Odaa José ja noxoco yatita aca wetiɡ̶a nelegi me noxoco. ");
INSERT INTO kbcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Idiaaɡ̶iticoaci moiwi Maria Madalena ajaa Maria ane eliodo eledi José. Odaa onadi niɡ̶ijo anoyatice lolaadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Niɡ̶ijo naɡ̶a ixomaɡ̶atijo saabado, odaa Maria Madalena, Salomé ajaa Maria ane eliodo Tiago joɡ̶odinoojetetalo nadokojetedi me domoɡ̶oyatita Jesus lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","One nigoitijo niɡ̶ijo odoejegi noko semaana, aligeɡ̶e ja doletibige me nodi, odaa jiɡ̶igotibeci midataɡ̶a lawimaɡ̶ajegi-wetiɡ̶a anoyatice Jesus lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Naigitece ja dinotaɡ̶aneɡ̶etiwage, modi, “Amigetiɡ̶ijo ane noɡ̶owatoɡ̶odomi naɡ̶ajo wetiɡ̶a nelegi ane noxoco niɡ̶ijo wetiɡ̶a-lawimaɡ̶ajegi?” ");
INSERT INTO kbcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Odaa jiɡ̶idaaɡ̶ee me dinotaɡ̶aneɡ̶e igaataɡ̶a naɡ̶ajo wetiɡ̶a daɡ̶axa me nelegi. Pida niɡ̶ijo naɡ̶a icotiobece, noɡ̶oiwita, odaa joɡ̶onadi naɡ̶ajo wetiɡ̶a nelegi joɡ̶onoɡ̶aticogi midataɡ̶a niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Niɡ̶ijo noɡ̶odakatiwece niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, odaa joɡ̶onadi ica lioneeɡ̶a ane dinixotinigilo nowoodi ane yapacaɡ̶a. Nicoti diɡ̶eticogi liwai libaaɡ̶adi niɡ̶ijo anoyatice lolaadi Jesus. Niɡ̶ijo noɡ̶onadi, odaa eliodi me nawelatibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pida niɡ̶ijo lioneeɡ̶a meetiogi, “Jinaɡ̶a anawelatiwaji! Jowooɡ̶odi me domoɡ̶oleetibige Jesus anelatibige nigotaɡ̶a Nazaré. Owooɡ̶oti moyototedeloco nicenaɡ̶anaɡ̶ate, odaa ja yeleo. Pida aɡ̶aleeɡ̶icoa digoina, ja yewiɡ̶atace. Digawini anoyatice lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pida niɡ̶ina natigide emiitiwaji, eloɡ̶otitiogi niɡ̶ijo anodiotibece codaa me Pedro. Enitiogi migo Jesus dinewadetedicogi digoida nipodigi Galiléia. Odaa jiɡ̶idiaaɡ̶itice manatitetiwaji, niɡ̶ijo ane ligegitedaɡ̶awatiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Odaa ja yediiɡ̶a me noditicoaci midataɡ̶a niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, odaa ja daleditibige, nawigicaɡ̶ateloco, leeɡ̶odi meliodi me doitibigiwaji. Odaa aɡ̶ica gaantiɡ̶ijo anoyatematita. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus yewiɡ̶atace niɡ̶ijo naɡ̶a domiingo me nigoitijo. Odoeje me dinikeeteta Maria Madalena, naɡ̶ajo anijo mijoa seete niwicidi abeyacaɡ̶aɡ̶a ane iticoitedice Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Odaa Maria Madalena jiɡ̶igo, yatematitiogi niɡ̶ijo lokaaɡ̶etedi Jesus aneliodi magecaɡ̶alodipi codaa noenaɡ̶ateloco. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Odaa niɡ̶ijo naɡ̶a nibodicaɡ̶a Jesus naɡ̶a yewiɡ̶atace, codaa Maria mee me nadi, aɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Niɡ̶idiaaɡ̶idi Jesus dinikeetediogi niɡ̶ijo itoataale anodiotibece maleeɡ̶idaa diiticogi mewaligitibigiwaji miditaɡ̶a ica nipodigi wetice nigotaɡ̶a. Ica ane latopagi diniigi niɡ̶ijo naɡ̶a dinikeetediogi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Niɡ̶ijo naɡ̶a dopitiobece, odaa joɡ̶oyatematitiogi niɡ̶ijo eledi anodiotibece modakapetege Jesus. Pida niɡ̶ijo eledi aɡ̶oyiwaɡ̶adi niɡ̶ijo latematigo. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Niɡ̶idiaaɡ̶idi Jesus ja dinikeetediogi niɡ̶ijo oonze anodiotibece niɡ̶ijo me niodaɡ̶a. Odaa ja napeteɡ̶etediniwace leeɡ̶odi laaleɡ̶enali daɡ̶axa me dakake, codaa leeɡ̶odi me doɡ̶oyiwaɡ̶adi naɡ̶a yewiɡ̶atace noɡ̶oyatemati niɡ̶ijo anonadi naɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Odaa Jesus meetediogi, “Emiitecetiwaji inatawece ane noiigi niɡ̶ina iiɡ̶o, atematiitedibecetiwaji nibodicetedi anele aneetici. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aneotedoɡ̶oji eote gela lewiɡ̶a niɡ̶ina oko aneyiwaɡ̶adi nibodicetedi anele, codaa leeditibige me dinilege. Pida niɡ̶ina oko ane deɡ̶eyiwaɡ̶adi, Aneotedoɡ̶oji baɡ̶a laagedi codaa me iloikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aneotedoɡ̶oji ikee niɡ̶ica nimaweneɡ̶egi, codaa eotetema loxiceɡ̶edi niɡ̶ina oko anoyiwaɡ̶adi. Codaa oibake Iboonaɡ̶adi niɡ̶ina moiticoitedice niwicidi abeyacaɡ̶aɡ̶a, codaa odotaɡ̶atigilo eletidi iolatedi ane diɡ̶ica modotaɡ̶atigi niɡ̶ica jotigide. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nigodibatalo laketedi ane diniweneene, oɡ̶oa domige owacipeta weneeno me doɡ̶oyowooɡ̶odi, aɡ̶ica ninyaagi. Nigoipeketelogo libaaɡ̶atedi niɡ̶inoa eelotaginadi, odaa ja nicilaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Niɡ̶ijo Ǥoniotagodi Jesus naɡ̶a ika me notaɡ̶aneɡ̶etediniwace, odaa Aneotedoɡ̶oji ja yadeegitedibigimece ditibigimedi, odaa ja nicotedi liwai libaaɡ̶adi Aneotedoɡ̶oji ikee mida naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Odaa niɡ̶ijo anodiotibece jiɡ̶igotibeci oyatematitedibece nibodicetedi inoatawece ane nipodaɡ̶a. Odaa Ǥoniotagodi yaxawatediogi, codaa meote ɡ̶odoxiceɡ̶etedi me ikee niɡ̶inoa latematiko anoyatematitibece mewi. Odaa jiɡ̶idaaɡ̶ee. (Amém.)");
INSERT INTO kbcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Iniotagodi Teófilo. Eliodi oko dinoniciwaɡ̶aditibigiwaji moiditedini niɡ̶ijoa Jesus Cristo loenataka ɡ̶odiwigotigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Oidi niɡ̶ijoa baaniɡ̶ijo monatematitoɡ̶owa, niɡ̶idi anonadi niɡ̶ijo maleekoka dinojogoti libakedi, codaa joɡ̶oditece latematiko ane icoɡ̶otedigi miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iɡ̶enaɡ̶a monatematitediwa niɡ̶ijoa odoejedi libaketedi, odaa joaniɡ̶idaa leeɡ̶odi me jakadi mele me jidikotibigaɡ̶aji, iniotagodi, ijoatawece niɡ̶ijoa baanaɡ̶a ixomaɡ̶atedijo, ewi me ilaɡ̶atedice. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jidikotibigaɡ̶aji, iniotagodi, amaleeɡ̶aɡ̶a owooɡ̶oti minoatawece ewi niɡ̶inoa niiɡ̶axinaɡ̶aneɡ̶eco anabaatege. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Niɡ̶ijo Herodes, malee ninionigi-eliodi niiɡ̶o judeutedi, onini ica ɡ̶oneleegiwa ane liboonaɡ̶adi Zacarias, one sacerdoti ane libakadi liɡ̶eladi Aneotedoɡ̶oji. Ida aneetege licoɡ̶egi niɡ̶ijo lapo sacerdotitedi ane liboonaɡ̶adi loiigiwepodi Abias. Aca lodawa liboonaɡ̶adi Isabel, loiigiwepodi inaaɡ̶ina sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarias aniaa Isabel idioka limedi mowo ane iɡ̶enaɡ̶a, codaa idokee mowo niɡ̶ica ane yemaa Aneotedoɡ̶oji. Idioka limedi modeemitetibige ijoatawece ane lajoinaɡ̶aneɡ̶eco codaa me liiɡ̶enatakaneɡ̶eco Ǥoniotagodi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pida aɡ̶ica lionigi, leeɡ̶odi Isabel gojoloɡ̶o, codaa joɡ̶opake. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ica noko Zacarias oneo ica ane libakeditibece minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, leeɡ̶odi icota ica noko maɡ̶aɡ̶a diba. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Onowo niɡ̶ica ane lakatigi niɡ̶idiwa sacerdotitedi, oiwi niɡ̶ica anepaɡ̶a dinete me yalegi ica ane liditege lanigi liciagi ɡ̶onadokojegi, ane ligileɡ̶egitibece moyalegi. Odaa Zacarias jiɡ̶ijaa dinete me dakatiwece Ǥoniotagodi Aneotedoɡ̶oji liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Odaa eɡ̶idiaaɡ̶i Zacarias me yalegi niɡ̶ica aneletege lanigi, idiaaɡ̶idi ica noiigi ideiticoace we, oyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Odaa ica niaanjo Ǥoniotagodi Aneotedoɡ̶oji ja dinikee lodoe Zacarias, one dabiditi liwai ɡ̶obaaɡ̶adi aca nameeja anei moyalegi niɡ̶ica aneletege lanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Niɡ̶ica Zacarias naɡ̶a nadi niɡ̶ijo aanjo, odaa nawela, eliodi me doi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Odaa mee niɡ̶ijo aanjo, “Jinaɡ̶adoii Zacarias! Aneotedoɡ̶oji wajipatedaɡ̶awa niɡ̶ijo me ipokitalo, odaa natigide ɡ̶adodawa jiɡ̶icaa lionigi, odaa awii me liboonaɡ̶adi João. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eliodi maniniitibeci leeɡ̶odi lanikegi, codaa eliodi oko aaɡ̶aɡ̶a ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Igaataɡ̶a ɡ̶oneɡ̶egi lodoe Aneotedoɡ̶oji. Awacipeta viinyo, oteɡ̶exaaɡ̶aɡ̶a anigetiɡ̶ida ɡ̶odacipaɡ̶adi ane yoniciwadi. Nigenitini, odaa ja dakatiogi Liwigo Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Odaa eo meliodi loiigi Israel odopitalo Ǥoniotagodi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Niɡ̶ica liwigo codaa me loniciwaɡ̶a liciagi Elias liwigo ane icoɡ̶otibigimece miniwataɡ̶a Aneotedoɡ̶oji. Aniɡ̶icatibige daɡ̶a diba Ǥoniotagodi meote ane libakeditetema Aneotedoɡ̶oji, niɡ̶idi nigaanigawaanigi yeloɡ̶oditedibece latematiko Aneotedoɡ̶oji, eotibige niɡ̶ina eniododipi me daɡ̶adiaa odinotigimadetege oteɡ̶exaaɡ̶aɡ̶a oideleɡ̶e lionigipi, codaa eotibige niɡ̶ijo ane doɡ̶oyiwaɡ̶aditeda Ǥoniotagodi Aneotedoɡ̶oji me nowookonaɡ̶a liciagi niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji. Odaa jiɡ̶idaa libakedi, ilakideticoace niɡ̶idi noiigi modinoweditege lanokegi Ǥoniotagodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Odaa Zacarias ja ige niɡ̶ijo aanjo, meeta, “Amiida ica ane jowooɡ̶oditece nigewi ida ɡ̶agegi? Igaataɡ̶a jeɡ̶eemoda oxiiɡ̶odi, codaa naɡ̶ajo yodawa jaɡ̶aɡ̶a opake.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Niɡ̶ijo aanjo naɡ̶a igidi, meeta, “Ee Gabriel. Idioka limedi me idejotice miniwataɡ̶a Aneotedoɡ̶oji me jibatema. Odaa idiiɡ̶e me ɡ̶adotaɡ̶aneɡ̶eni codaa me jeloɡ̶oditaɡ̶awa niɡ̶ida nibodigi anele. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Odaa niɡ̶ina natigide jaɡ̶akaami aticilonaɡ̶a, codaa makaami ewaloɡ̶onaɡ̶a, aɡ̶akati motaɡ̶ani nigepaa icota noko menitini ɡ̶adionigi, leeɡ̶odi me daɡ̶a iwaɡ̶atiteda yotaɡ̶a, igaataɡ̶a niɡ̶inoa yotaɡ̶a ewi micotalo anigida noko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Niɡ̶ijo noiigi anonibeotege Zacarias joɡ̶oyopo me leegi midiaaɡ̶i catiwedi Aneotedoɡ̶oji liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Niɡ̶ijo naɡ̶a noditice, aɡ̶alee yakadi me dotaɡ̶a. Odaa niɡ̶ijo noiigi joɡ̶oyowooɡ̶odi mica lakatigi catiwedi liɡ̶eladi Aneotedoɡ̶oji. Naɡ̶a daɡ̶a yakadi me dotaɡ̶a, odaa ja yatitiogi libaaɡ̶atedi me yotaɡ̶aneɡ̶e niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Niɡ̶ijo naɡ̶a dinelio nokododi me diba digoida Aneotedoɡ̶oji liɡ̶eladi, odaa Zacarias joɡ̶opiticogi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Odaa aoniɡ̶ica daɡ̶a leegi Isabel jiɡ̶ipileɡ̶e. Odaa aona noditice liɡ̶eladi niɡ̶icoa ciinco nepenaitedi. Odaa meetigi le, ");
INSERT INTO kbcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Joaniɡ̶idaa igotediwa Ǥoniwa-aagodi. Niɡ̶inoa nokododi eletedomi me noɡ̶owa iboliɡ̶a lodoe eledi oko. Igaataɡ̶a idiboliɡ̶a niɡ̶ijo me-ee diɡ̶icata i-oonigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Niɡ̶ica naɡ̶a ixomaɡ̶atedijo ciinco nepenaitedi Isabel me ipileɡ̶e, Aneotedoɡ̶oji ja iiɡ̶e aanjo Gabriel migo manitaɡ̶a nigotaɡ̶a Nazaré, nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iiɡ̶etedicogi manitaɡ̶a aca awicije ane liboonaɡ̶adi Maria. Maria aona niɡ̶ica me nadi ɡ̶oneleegiwa, onaleekoka doletibige me lodawa ica ɡ̶oneleegiwa ane liboonaɡ̶adi José, anida aneetege licoɡ̶egi Davi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Niɡ̶ijo aanjo niɡ̶icota Maria, nice, odaa meeta, “Iniotagodawaana, Ǥoniotagodi Aneotedoɡ̶oji yajigotedaɡ̶awa ɡ̶adinikegi. Aneotedoɡ̶oji yemaa meote ane daɡ̶axa meletaɡ̶adomi. Idioka limedi me ideite makaamitaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria eliodi me nawela leeɡ̶odi lotaɡ̶a niɡ̶ijo aanjo, codaa domaɡ̶a yowotece niɡ̶ica anodaa diitigilo niɡ̶ijoa lotaɡ̶a, pida ayowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Odaa niɡ̶ijo aanjo meeta, “Jinaɡ̶adoii Maria! Igaataɡ̶a Aneotedoɡ̶oji eliodi meletedaɡ̶adomi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Digawini! Icota makaami ipileɡ̶e, odaa jaɡ̶anigajeetece nigaanigawaanigi, odaa awii me liboonaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Icota me ɡ̶oneleegiwa ɡ̶oneɡ̶egi, odaa idokoyatigi me Lionigi Aneotedoɡ̶oji, Aneotedoɡ̶oji ane iiɡ̶e inoatawece. Ǥoniotagodi Aneotedoɡ̶oji eote me inionigi-eliodi, digo anee licoɡ̶egi Davi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Codaa idioka limedi me inionigi-eliodi ane iiɡ̶e anida aneetege licoɡ̶egi Jacó, odaa niɡ̶ica ninioxigi aɡ̶ica liniogo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Odaa Maria jeɡ̶eeta niɡ̶ijo aanjo, “Igamodaaɡ̶ee ica me yakadi? Aniɡ̶icoda daɡ̶a idina-aaditege aaginaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Odaa niɡ̶ijo aanjo ja niniɡ̶odi, meeta, “Liwigo Aneotedoɡ̶oji enagi makaamita, odaa Aneotedoɡ̶oji ditibigimedeoodi ikeetedaɡ̶awa nimaweneɡ̶egi. Joaniɡ̶idaa leeɡ̶odi ɡ̶adionigi anenitini, enitini miniokiniwateda Aneotedoɡ̶oji me nebi, odaa liboonaɡ̶adi ‘Lionigi Aneotedoɡ̶oji’. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Digowoo! Moditibece ɡ̶aditaagi Isabel me daɡ̶a yakadi mica lionigi, pida natigide jiɡ̶idiwa ciinco nepenaitedi me ipileɡ̶e, digo anee noɡ̶opake. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Igaataɡ̶a Aneotedoɡ̶oji aɡ̶ica idi ane daɡ̶a yakaditeda meote.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Odaa Maria mee, “Niɡ̶ida meeyo, eeyo liota Iniwa-aagodi Aneotedoɡ̶oji. Anikanitici niɡ̶ica aneeteta Iniwa-aagodi.” Odaa joɡ̶opi niɡ̶ijo aanjo. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Naɡ̶a ixomaɡ̶atedice icoa nokododi, Maria ja dinoe, odaa ja yediiɡ̶aticogi nigotaɡ̶a nipodigi Judéia, midiwa icoa wetiadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Naɡ̶a dakatiwece liɡ̶eladi Zacarias, odaa ja yecoaditece Isabel. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Isabel naɡ̶a wajipata Maria me nice, odaa niɡ̶ijo nigaanigawaanigi catiwedi le ja ditineɡ̶e. Odaa Isabel ja dakatiogi Aneotedoɡ̶oji Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Odaa ja dinigetaɡ̶atee me dotaɡ̶a, mee, “Aneotedoɡ̶oji eliodi meote aneletaɡ̶adomi, caticedi niɡ̶ina ɡ̶oniwaalowepodi, codaa jeɡ̶eote aneletema niɡ̶idi niga-aanigawaanigi catiwedi ɡ̶ade-ee. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Odaa Aneotedoɡ̶oji eliodi me idiwe-eeniɡ̶ide, le-eeɡ̶odi managi adaliitiwa, ano-oota ma-aami eliodo Iniwa-aagodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Niɡ̶ijo naɡ̶a jajipa-aataɡ̶awa madiceni, niga-aanigawaanigi ninitibece, odaa ja ditineɡ̶e catiwedi ye-ee. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ǥoniwa-aagodi Aneotedoɡ̶oji ɡ̶adibinieni le-eeɡ̶odi mi-iiwaɡ̶ati mo-oota niɡ̶ijo ane ligegitedaɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Odaa jeɡ̶ee Maria, “Jigaanaɡ̶atibigimece Ǥoniwa-aagodi Aneotedoɡ̶oji, mele yaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Odaa eliodi me idinitibeci le-eeɡ̶odi Aneotedoɡ̶oji me idewikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Igaataɡ̶a yemaa meotedomi anele, eeyo liota ane diɡ̶ica me dinabaketibece, eeyo iwikodaɡ̶alo. Niɡ̶ina natigide, nigepaa ganigicatibige, niɡ̶ina oko odi Aneotedoɡ̶oji meliodi me idibinie. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Igaataɡ̶a Aneotedoɡ̶oji aneliodi nimaweneɡ̶egi, eotedomi niɡ̶ica ane jopooɡ̶a. Aɡ̶ica ane beyagi miniwataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iwikode inatawece niɡ̶ina anode-eemitetibige, niɡ̶ina baaniɡ̶ina me newiɡ̶a, codaa niɡ̶ina ane-eediɡ̶ica menitiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aneotedoɡ̶oji ja ikee meliodi loniciwaɡ̶a niɡ̶ina meote niɡ̶inoa ane loweenataka. Iɡ̶e-eeke niɡ̶inoa anaɡ̶axakenaɡ̶aɡ̶a, codaa me noɡ̶owa lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Niɡ̶ina ane ni-iiɡ̶enatakanaɡ̶a, Aneotedoɡ̶oji noɡ̶owa nimaweneɡ̶eco, codaa eote naɡ̶atetigi niɡ̶ina anodi me diɡ̶ica naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yajigo niɡ̶inoa anele, nediatediniwace niɡ̶ina ane nigiciletibigiwaji, codaa i-iiɡ̶e moitibece niɡ̶inoa liicotedi me diɡ̶ica anoyadeegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Idioka lime-eedi meote mo-oota niɡ̶inoa ane lotaɡ̶a anigotediogi jotigide ɡ̶odaamipi, codaa midioka lime-eedi me yaxawa ɡ̶odoiigi Israel, ane liotagipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Igaataɡ̶a ligegite jotigide ɡ̶onelokodi Abraão, codaa niɡ̶ina anida aneetege licoɡ̶egi midioka lime-eedi me iwikodetediogi.” (Odaa ja liniogo me dotaɡ̶a Maria). ");
INSERT INTO kbcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ejinaɡ̶a eote iniwatadiɡ̶ini epenaitedi midiaaɡ̶i mani Isabel, odaa joɡ̶opiticogi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Niɡ̶icota ica noko me dinigaje Isabel, odaa ja dinigajetece nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ica lipecaɡ̶awepodi codaa me litacepodi odibodicetibige, odaa modi Ǥoniotagodi Aneotedoɡ̶oji eliodi me iwikode Isabel. Odaa ja linikaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Niɡ̶ijo neɡ̶eote oito nokododi menitini nigaanigawaanigi, odaa jiɡ̶igotibeci oyakagidi lolaadogo, ane lakatigi judeutedi (moikee me loiigi Aneotedoɡ̶oji). Odaa ja domoɡ̶owo me liboonaɡ̶atewa eliodi, Zacarias. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pida naɡ̶ajo eliodo mee, “Oɡ̶oa, biɡ̶ida liboonaɡ̶adi João.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Odaa modi, “Pida aɡ̶ica ɡ̶aditaagi ane liboonaɡ̶adi João!” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Odaa odatikatalo libaaɡ̶atedi moige eliodi ica ane yemaa me liboonaɡ̶adi nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Odaa Zacarias ja dipokotibige taaboawaanigi me iditeloco, “Jemaa me liboonaɡ̶adi João.” Iditawece niɡ̶ijo oko oyopo. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Odaa aɡ̶ica daɡ̶a leegi ja yakaditace me dotaɡ̶a, odaa ja diniotagodetalo Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Niɡ̶ijo lipecaɡ̶awepodi eliodi moyopo niɡ̶ida niciagi, odaa niɡ̶ica nibodigi aneetece niɡ̶ida niciagi jiɡ̶ilaagiteloco idiwatawece nipodaɡ̶a Judéia, ane inoa wetiadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Odaa inatawece oko anowajipata oyowo niɡ̶ida natematigo, odaa dinigetiwage, modi, “Igamigodaaɡ̶ee ica nigaanigawaanigi? Igaataɡ̶a loniciwaɡ̶a Ǥoniotagodi Aneotedoɡ̶oji ewi me idei miditaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarias, eliodi niɡ̶ijo nigaanigawaanigi one dakatiogi Liwigo Aneotedoɡ̶oji, odaa jiɡ̶idaa dinanatigi me yalaɡ̶ata anodaaɡ̶ee niɡ̶ijo nigaanigawaanigi, mee, ");
INSERT INTO kbcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Joɡ̶eeɡ̶atalo Ǥoniotagodi Aneotedoɡ̶oji, Noenoɡ̶odi loiigi Israel. Igaataɡ̶a enagi midi loiigi me yatamaɡ̶ateetetege libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Niwakateetedoɡ̶owa Ǥonewikatitoɡ̶odi anida nimaweneɡ̶egi, anida aneetege licoɡ̶egi Davi, ane liiɡ̶exegi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jotigide Aneotedoɡ̶oji naɡ̶a ligegi me niwakatee niɡ̶ica Ǥonewikatitoɡ̶odi. Niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, niɡ̶ijo aniniokiniwateda modibatema, oyeloɡ̶odi ane ligegi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Odaa ligegi me ɡ̶odatamaɡ̶ateetetege ɡ̶odaxakawepodi, codaa me loniciwaɡ̶a niɡ̶ijo ane deɡ̶etiɡ̶odemaa. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Codaa ligegi me iwikode ɡ̶odaamipi, codaa nalaɡ̶atigilo niɡ̶ijo ane dinilakidetetege, leeɡ̶odi aixomaɡ̶atice ane ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Akaa ligegiteta ɡ̶onelokodi Abraão me ɡ̶odatamaɡ̶ateetetege loniciwaɡ̶a ɡ̶odaxakawepodi, eote me jakataɡ̶a me jibaaɡ̶atema me diɡ̶ica ane idoiiɡ̶ata. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Odaa jakataɡ̶a miniokiniwateda me jibaaɡ̶atema, codaa me jakataɡ̶a me jaoɡ̶o inokina ane iɡ̶enaɡ̶a inoatawece nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Akaami, ionigi, etiɡ̶adadalitigi makaami niɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji anidioka limedi me diiɡ̶enataka. Odaa eloɡ̶oti latematiko Aneotedoɡ̶oji aniɡ̶icatibige daɡ̶a diba Ǥoniotagodi, anenyaɡ̶ati laaleɡ̶enali niɡ̶idi noiigi modinoweditege lanokegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Awii loiigi Ǥoniotagodi Aneotedoɡ̶oji moyowooɡ̶odi anodaaɡ̶ee me yewikatidi, niɡ̶ina me napitaɡ̶adi libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Igaataɡ̶a Aneotedoɡ̶oji eliodi me ɡ̶odiwikode. Niɡ̶icoa Aneotedoɡ̶oji ane niwakatee me ɡ̶odewikatidi liciagi niɡ̶ina maleekoka daxoditibige aligeɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Niɡ̶ina nigeno, yajigotediogi lokokena niɡ̶ina ane ideiticoace nexocaɡ̶a anodipegitege némaɡ̶a, ɡ̶odadeegitedinece naigi aneo mele ɡ̶odaaleɡ̶enali.” (Odaa ja liniogo me dotaɡ̶a Zacarias). ");
INSERT INTO kbcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Odaa niɡ̶ijo nigaanigawaanigi naɡ̶a ili, odaa jaɡ̶aɡ̶a ili liwaxinigi. Odaa jiɡ̶idiaaɡ̶i midiwataɡ̶a nipodaɡ̶a ane yadilo ane diɡ̶ica niɡ̶eladimigipi neɡ̶epaaɡ̶icota noko migo yeloɡ̶odi Aneotedoɡ̶oji lotaɡ̶a midi loiigi Israel. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Niɡ̶ijo César Augusto minionigi-eliodi ane iiɡ̶e idiwatawece niiɡ̶otedi romaanotedi, ja diiɡ̶enatakata niɡ̶ijoa nokododi me dinilaɡ̶adi oko, diniditedini liboonaɡ̶atedi iditawece noiigi. Codaa one odoejegi noko me dinilaɡ̶aditibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Niɡ̶ijo noɡ̶onilaɡ̶adi oko ica ane iiɡ̶e niiɡ̶o Síria boɡ̶one ica Cirênio. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Odaa leeditibige miditawece oko igotibeci minoataɡ̶a niɡ̶inoa anepaa nigotadi ane lanikadi, me dinilaɡ̶aditibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José ida aneetege licoɡ̶egi Davi niɡ̶ica jotigide inionigi-eliodi ane lanikadi nigotaɡ̶a Belém, nipodigi Judéia. Joaniɡ̶idaa leeɡ̶odi me noditicogi nigotaɡ̶a Nazaré, nipodigi Galiléia, odaa jiɡ̶igo Belém me dinilaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Odaa yadeegi Maria, analeedaɡ̶a lodawa, pida jiɡ̶ipileɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Niɡ̶ijo midiaaɡ̶i Belém, jiɡ̶icota noko me dinigaje. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Odaa ja dinigajetece odoejegi lionigi. Odaa jona ilipaditece lipegeteɡ̶e, yexaɡ̶atinigi nicooxo eijedi, leeɡ̶odi aɡ̶aleeɡ̶ica oyakadi limedi manitaɡ̶a ɡ̶odiotaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Midiwataɡ̶a icoa nipodaɡ̶a onidiwa icoa nowienoɡ̶ododi waxacocoli, oyeloɡ̶oteetigi moyowie icoa lapoli waxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Odaa ica niaanjo Ǥoniotagodi Aneotedoɡ̶oji ja dinikeetiogi, odaa latalaɡ̶a Ǥoniotagodi Aneotedoɡ̶oji ja naloteloco niɡ̶ica aneiticoace. Odaa eliodi me doitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pida niɡ̶ijo aanjo meetiogi, “Jinaɡ̶a domaɡ̶adoiitiwaji! Igaataɡ̶a inadeegitaɡ̶awatiwaji nibodigi anele, aneo minatawece oko ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Digawini! Niɡ̶ina noko digoida Belém, nigotaɡ̶a Davi, enitini ane ɡ̶adewikatititiwaji, Niɡ̶ijoa anakaa jibodicaɡ̶atege, Cristo, ane Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Odaa owooɡ̶otitiwaji mewi. Akapetege nigaanigawaanigi, oilipaditece lipegeteɡ̶e, oyeliiɡ̶etinigi nicooxo eijedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aniaaɡ̶ani naɡ̶aca lakata jaɡ̶aɡ̶a dinikee mijotaɡ̶a niɡ̶ijo aanjo, ica nelegi lapo eletidi liiɡ̶exedi Aneotedoɡ̶oji digoida ditibigimedi. Oigaa enaco, odigaanaɡ̶atibigimece Aneotedoɡ̶oji, modi, ");
INSERT INTO kbcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Digoina ditibigimedi jigaanaɡ̶anaɡ̶atibigimece Aneotedoɡ̶oji. Eote mele laaleɡ̶enali oko digoina iiɡ̶o, leeɡ̶odi yemaa meote aneletema niɡ̶idi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Niɡ̶ijoa aanjotedi noɡ̶opitacibigimece ditibigimedi, odaa niɡ̶ijoa nowienoɡ̶ododi waxacocoli modi, “Iniɡ̶a Belém, iniɡ̶a jiwinaɡ̶a niɡ̶ica nigaanigawaanigi Ǥoniotagodi Aneotedoɡ̶oji aneote ɡ̶obodigi neɡ̶enitini.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Odaa jiɡ̶igotibeci yediiɡ̶atibigiwaji, odaa joɡ̶otota Maria, José, odaa joɡ̶onadi nigaanigawaanigi, anoyeliiɡ̶etinigi nicooxo eijedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Niɡ̶ijo noɡ̶onadi, odaa joɡ̶oyatemati niɡ̶ijo ane lotaɡ̶a aanjotedi moditece niɡ̶idi nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ijotawece niɡ̶ijo anowajipatiogi niɡ̶ijoa nowienoɡ̶ododi waxacocoli eliodi moyopo. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pida Maria biɡ̶idioka limedi me nalaɡ̶atibige baanaɡ̶a ixomaɡ̶ateetice, codaa eliodi me yowo lotaɡ̶a niɡ̶ijoa nowienoɡ̶ododi waxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Odaa niɡ̶ijoa nowienoɡ̶ododi waxacocoli joɡ̶opitibeci. Nigaanaɡ̶anaɡ̶atece ligi, odigaanaɡ̶atibigimece Aneotedoɡ̶oji, odiniotagodetalo leeɡ̶odi ijoatawece anowajipatalo, codaa anonadi. Ijoatawece ane eetece niɡ̶ijo aanjo onadi, codaa mowajipatalo moyalaɡ̶atalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Igaanaɡ̶a ixomaɡ̶atedijo oito nokododi menitini, joɡ̶oyakagidi lolaadi nigaanigawaanigi ane ligileɡ̶egi judeutedi. Odaa joɡ̶owo me liboonaɡ̶adi Jesus, igaataɡ̶a jiɡ̶idaa liboonaɡ̶adi aneeta niɡ̶ijo aanjo maleediɡ̶icatibige diɡ̶ipileɡ̶e Maria. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Niɡ̶ijo naɡ̶a ixomaɡ̶atedijo icoa nokododi ane diiɡ̶enatakata lajoinaɡ̶aneɡ̶eco Moisés me diniwilegitibigiwaji lodoe Aneotedoɡ̶oji, José ajaa Maria joɡ̶oyadeegi nigaanigawaanigi manitaɡ̶a nigotaɡ̶a Jerusalém moibootalo Ǥoniotagodi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Igaataɡ̶a diniditeloco liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji ane iditedini Moisés, anee, “Inatawece nionigi liidaɡ̶a leeditibige moiomaɡ̶aditema Ǥoniotagodi Aneotedoɡ̶oji, odaa iniokiniwateda me nebi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Odaa José ajaa Maria igotibeci maɡ̶aɡ̶a oibootema Ǥoniotagodi Aneotedoɡ̶oji aneledi liiɡ̶enatakaneɡ̶egi lajoinaɡ̶aneɡ̶eco Moisés, iniwataale yotipitedi, oɡ̶oa domige iniwataale yotipitedawaanaɡ̶a liboonaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Manitaɡ̶a nigotaɡ̶a Jerusalém ini ica ɡ̶oneleegiwa niɡ̶eladimigi ane liboonaɡ̶adi Simeão. One ɡ̶oneleegiwa ane iɡ̶enaɡ̶a, codaa midioka limedi meyiwaɡ̶adi Aneotedoɡ̶oji, codaa me nibeotibigege me niwakatee Aneotedoɡ̶oji ane yewikatidi loiigi Israel. Liwigo Aneotedoɡ̶oji idei mijotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Codaa iniaaɡ̶ini Liwigo Aneotedoɡ̶oji ikeeta me daɡ̶a yeleo nigepaa nadi icoa Cristo, liwaaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji me ɡ̶odewikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Liwigo Aneotedoɡ̶oji eo migo Simeão minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Ijaaɡ̶ijo noko moyadeegi eliododipi Jesus minitaɡ̶a liɡ̶eladi Aneotedoɡ̶oji, mowote aneeta najoinaɡ̶aneɡ̶eco mowo. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Odaa Simeão ja dibata niɡ̶ijo nigaanigawaanigi. Naɡ̶a noɡ̶ele, odaa ja doɡ̶etedibigimece Aneotedoɡ̶oji, meetalo, ");
INSERT INTO kbcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Iniotagodi Aneotedoɡ̶oji, niɡ̶ina natigide, ane eemoda ɡ̶adiiɡ̶exegi ja yakadi mikani me inipetini. Ideleo mele yaaleɡ̶ena, igaataɡ̶a jiɡ̶icota niɡ̶ijo ane ɡ̶agegitiwa. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Igaataɡ̶a niɡ̶ida me ee ja jinadi niɡ̶idi ananiiɡ̶eni ane ɡ̶odewikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Inatawece noiigi icota monadi niɡ̶idi ananiiɡ̶eni Iniotagodi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Niɡ̶idi maniiɡ̶eni liciagi lokokena miditaɡ̶a niɡ̶ina ane daɡ̶a judeutedi me ikeetiogi anewi. Odaa joɡ̶oiweniɡ̶ide ɡ̶adoiigi Israel idiaaɡ̶idi leeɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José ajaa Maria eliodi moyopo niɡ̶ijoa lotaɡ̶a Simeão me yalaɡ̶ata niɡ̶idi nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeão dipokotalo Aneotedoɡ̶oji me ibinietediogi, odaa jeɡ̶eeta Maria, eliodo Jesus, “Aneotedoɡ̶oji niwakatee niɡ̶idi nigaanigawaanigi meliodi okotigi ɡ̶odoiigi Israel oyototedice Aneotedoɡ̶oji, pida eliodi eledi ɡ̶odoiigi odopitalo. Aneotedoɡ̶oji niwakatee me ikee niɡ̶ica anodaaɡ̶eeteda. Codaa eliodi oko odotaɡ̶atibige niɡ̶idi nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Odaa joaniɡ̶idaaɡ̶ee niɡ̶inoa lowooko niɡ̶ina noiigi ane doɡ̶oyiwaɡ̶aditeda ja dineloɡ̶otee. Icota me eemiteetece mileeni ɡ̶adaaleɡ̶ena leeɡ̶odi ɡ̶agecaɡ̶aloɡ̶o, micataɡ̶a niɡ̶ina me leegitinece ɡ̶otaciledi me ɡ̶odapeegi nodaajo-ocaɡ̶ataɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Onani aca iwaalo opake, ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Liboonaɡ̶adi Ana, liona ica Fanuel, anida aneetege licoɡ̶egi Asa. Niɡ̶ijo me wado, naɡ̶a ixomaɡ̶atedice seete nicaaɡ̶ape, lodawa ja yeleo. Odaa ja wajekalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Natigide joniɡ̶idiwa 84 nicaaɡ̶ape. Aoniɡ̶ica daɡ̶a noditicogi liɡ̶eladi Aneotedoɡ̶oji. Noko, codaa menoale, one doɡ̶etetalo Aneotedoɡ̶oji. Aɡ̶aniodi niɡ̶ina me idei lodoe Aneotedoɡ̶oji me yotaɡ̶aneɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Acaaɡ̶aca naɡ̶aca lakatatibece micota me diniotagodetalo Aneotedoɡ̶oji, odaa ja yalaɡ̶ata nigaanigawaanigi yatematitiogi ijotawece niɡ̶ijo anonibeotege Aneotedoɡ̶oji me yatamaɡ̶atee noiigitigi Jerusalém me yatamaɡ̶ateetetege laxakawepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Odaa José ajaa Maria noɡ̶oigodi mowotema niɡ̶ijo nigaanigawaanigi icoatawece niɡ̶icoa ane liiɡ̶enatakaneɡ̶eco Ǥoniotagodi Aneotedoɡ̶oji, odaa joɡ̶opiticogi liɡ̶eladi mani nigotaɡ̶a Nazaré, nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Odaa niɡ̶ijo nigaanigawaanigi ja ili, ja yoniciwadi. Codaa jiɡ̶inoa lixaketedi, Aneotedoɡ̶oji eliodi meote aneletema. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Inoatawece nicaaɡ̶ape eliododipi Jesus igotibeci Jerusalém odiita niɡ̶ica nalokegi anodita “Páscoa”. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Niɡ̶ijo Jesus neɡ̶eote dooze nicaaɡ̶ape, jiɡ̶igotacibece nalooɡ̶o ane lakatigitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Niɡ̶idiaaɡ̶idi niɡ̶ijo nalokegi noɡ̶one dinelio, odaa joɡ̶opiticogi liɡ̶eladi. Odaa niɡ̶ijoa nigaanigawaanigi, Jesus, ja nenyaɡ̶atedini mani nigotaɡ̶a Jerusalém. Pida eliododipi aɡ̶oyowooɡ̶odi me nenyaɡ̶atedini. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Odiletibige diɡ̶inoa liwigotigi niɡ̶ijo lapo ane dopitibeci, odaa ja wiajeeɡ̶a ijotawece noko. Igaanaɡ̶a domoɡ̶odoletibige Jesus mijotaɡ̶a niɡ̶ijo litacepodi codaa mijoataɡ̶a niɡ̶ijoa lokaaɡ̶etedipi, pida aɡ̶icoa moyakadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Odaa niɡ̶ijo naɡ̶a diɡ̶icoateda moyakadi, niɡ̶ijo eliododipi joɡ̶opitacicogi Jerusalém modoletibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Igaanaɡ̶a ixomaɡ̶atedice itoatadiɡ̶ida nokododi, odaa joɡ̶oyakadi Jesus minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Nicotedini liwigotigi icoa niiɡ̶axinaɡ̶anadi judeutedi anodiiɡ̶axinaɡ̶atece icoa lajoinaɡ̶aneɡ̶eco Moisés ane iditedini. Jesus wajipatediogi codaa nigetediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ijotawece niɡ̶ijo anowajipatalo eliodi moyopo leeɡ̶odi minoa lixaketedi, codaa me lotaɡ̶a niɡ̶ina me igiditediogi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Niɡ̶ijo eliododipi noɡ̶onadi, aaɡ̶aɡ̶a oyopo. Odaa naɡ̶ajo eliodo meetalo, “I-oonigi, igaamee ina mideɡ̶emiitoɡ̶owa? Alopoo! Ǥadiodi, eeyomoda, eliodi me joɡ̶owikomataaɡ̶atibigaɡ̶aji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Igaamee ina moleetibigijitiwaji? Aɡ̶owooɡ̶oti me leeditibige minaaɡ̶ejo liɡ̶eladi Eiodi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pida aɡ̶oyowooɡ̶odi niɡ̶ica aneyatedigi ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Niɡ̶idiaaɡ̶idi ja lixigaɡ̶awepodi eliododipi, opiticogi Nazaré, idioka limedi meyiwaɡ̶adi eliododipi. Odaa naɡ̶ajo eliodo idioka limedi me nalaɡ̶atibige ijoatawece ane ixomaɡ̶ateetedijo. ");
INSERT INTO kbcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Odaa Jesus ja ili, codaa minoa lixaketedi. Codaa idioka limedi Aneotedoɡ̶oji me iweniɡ̶ide codaa niɡ̶ina oko moiweniɡ̶ide. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Neɡ̶eote ciinze nicaaɡ̶ape Tibério ja ninionigi-eliodi romaanotedi codaa iiɡ̶e inoatawece iiɡ̶otedi. Niɡ̶ijo romaano ane iiɡ̶e nipodigi Judéia baɡ̶a Pôncio Pilatos. Ninionigi-eliodi nipodigi Galiléia baɡ̶a Herodes, nioxoa ica Filipe ninionigi-eliodi nipodigi Ituréia codaa me Traconites. Nipodigi Abilene, baɡ̶a ninionigi-eliodi Lisânias. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Lacilo-sacerdotitedi baɡ̶a Anás ijaa Caifás. Niɡ̶ijoa nokododi Aneotedoɡ̶oji ja yotaɡ̶aneɡ̶e João, lionigi Zacarias. João idiaaɡ̶i miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","João diɡ̶etita iditawece nipodigi akiidi Jordão, odaa yatematitibece me leeditibige inatawece oko modinilaatece libeyaceɡ̶eco, codaa me leeditibige me dinilegetibigiwaji, odaa Aneotedoɡ̶oji ja iwilegitetema inoatawece libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Niɡ̶ida libakedi João, akaa eetece Isaías, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide. Isaías iditeloco lotaɡ̶anaɡ̶axi, mee, “Ida ica ane igedi me dotaɡ̶a miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi. Mee me dotaɡ̶a, ‘Oenitece naigi Ǥoniotagodi menagi, awii naicoli ane dixoketema! ");
INSERT INTO kbcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Inoatawece ane elagigi icota me dinoxoco, codaa inoatawece wetiadi ane leegitibigimece oyakagidi. Naicoli ane dinamage icota me dixoke, codaa naicoli aninoa nalaɡ̶atedi icota mabotiwage. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Odaa inatawece oko onadi Aneotedoɡ̶oji anodaaɡ̶ee me yewikatidi oko.’” (Joaniɡ̶idaa Isaías iboɡ̶oditege niɡ̶ijo me ilakidetice naigi Ǥoniotagodi, João ane ilakideticoace laaleɡ̶enali oko mowajipatalo lotaɡ̶a Jesus.) ");
INSERT INTO kbcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eliodi oko domoɡ̶odiita João me dinilegetibigiwaji. Pida João meetiogi, “Akaamitiwaji lionaɡ̶a laketedi. Amiijo aneo ɡ̶abodigitiwaji ina noɡ̶oleetigi me ɡ̶adiwokonitiwaji lélaɡ̶a Aneotedoɡ̶oji nige iloikatidi oko leeɡ̶odi libeyaceɡ̶eco? ");
INSERT INTO kbcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iigitiwaji ɡ̶adakataɡ̶a amaleeɡ̶aɡ̶a ikeeni naɡ̶adinilaanitibece, macataɡ̶a naɡ̶ana niale ela me ikee anada naɡ̶ada niale. Jinaɡ̶a domeɡ̶enitiwaji me ɡ̶anelokodi Abraão, (Igaataɡ̶a niɡ̶ina anida aneetege licoɡ̶egi Abraão leeditibige me dinilaatibece), igaataɡ̶a ejitaɡ̶awatiwaji Aneotedoɡ̶oji yakadi me ibake niɡ̶idiwa wetiadi meote mida aneetege licoɡ̶egi Abraão. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Codaa micataɡ̶a niɡ̶ina ɡ̶oneleegiwa baanaɡ̶a igo me yakagidi niale neɡ̶epaa litodi. Inoatawece nialeli ane deɡ̶eleteda ela oyakagidi, odaaɡ̶oyalegi.” (Joaniɡ̶idaaɡ̶ee Aneotedoɡ̶oji ja igo me iloikatidi oko aneo ane beyagi). ");
INSERT INTO kbcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pida niɡ̶idi noiigi idioka limedi monigetice João, modita, “Amiida ica ane leeditibige me jaoɡ̶a? (Odaa aɡ̶alee ɡ̶odiloikatidi Aneotedoɡ̶oji.)” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Odaa ja niniɡ̶odi, meetiogi, “Niɡ̶ini anidiwa itiwataale noecaɡ̶axiidi, leeditibige me yajigota onaditeci niɡ̶ijo ane daɡ̶aca noecaɡ̶axi. Codaa niɡ̶ini anidi ane yeligo, leeditibige me yedia niɡ̶ina ane diɡ̶ica ane yeligo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, eledi icotiobece me domaɡ̶aɡ̶a dinilegetibigiwaji, odaa joɡ̶oige João, modita, “Ǥoniiɡ̶axinoɡ̶odi, oko amiida ane leeditibige maɡ̶aɡ̶a jaoɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Odaa jeɡ̶eetiogi, “Jinaɡ̶alee abanoonaɡ̶anitiwaji caticedi ane iiɡ̶etaɡ̶awa najoinaɡ̶aneɡ̶eco mabanoonaɡ̶ani.” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Codaa iodaɡ̶awadi eletidi oige, modita, “Epoɡ̶oko, amiida ane leeditibige me jaoɡ̶a?” Odaa ja niniɡ̶odi, meetiogi, “Jinaɡ̶atikani ɡ̶adoniciwaɡ̶a mabanoonaɡ̶anitece dinyeelo, oteɡ̶exaaɡ̶aɡ̶a awitaka oditaɡ̶a jaɡ̶abanoonaɡ̶ani. Pida adinanenitibece leeɡ̶odi niɡ̶idoda ɡ̶anigaanyeɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Niɡ̶ijo noiigi eliodi mowalita João deɡ̶eo anigetiɡ̶ida loenatagi anodoxicetema. Meetibige le niɡ̶idi noiigi ijoa nige niɡ̶idaaɡ̶ida João Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pida João meetiogi iditawece, “Ǥadilegenita ninyoɡ̶odi. Pida enagi anida loniciwaɡ̶a caticedi ee. Ajakadi me jaxawatece, oteɡ̶exaaɡ̶aɡ̶a me jowilece liwelatedi, leeɡ̶odi eliodi me ɡ̶oneɡ̶egi, aiciagi. Idi ane yajigotediogi Liwigo Aneotedoɡ̶oji, idiaaɡ̶eledi niɡ̶ina akaamitiwaji baɡ̶a iloikatidi, micataɡ̶a daɡ̶a yalegi noledi. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aneotedoɡ̶oji ja igo me iomaɡ̶adi oko, micataɡ̶a niɡ̶ina ɡ̶oneleegiwa baaniɡ̶ida najo libaaɡ̶adi naɡ̶a igo me ibinie lawodigijedi, odaa iomaɡ̶aditege leyeema, lapadi. Iladie leyeema minitaɡ̶a diimigi ane iladiete nijaacotedi. Pida napadi baɡ̶a yalegi mini noledi ane daɡ̶a ipe.” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Odaa João ibodicaxitiogi niɡ̶idi noiigi mowidi eletidi lotaɡ̶a me yaxawatiogi, niɡ̶ina me yatemati nibodicetedi anele. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pida João ja dotaɡ̶atibige Herodes inionigi-eliodi, leeɡ̶odi Herodes dibanoonaɡ̶atece aca Herodias lodawa nioxoa, codaa leeɡ̶odi Herodes mowidi eletidi libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Joaniɡ̶idaa leeɡ̶odi Herodes naɡ̶a diiɡ̶enatakata moixotiwece João niwiloɡ̶onaɡ̶axi, pida joaniɡ̶idaa leeɡ̶odi neɡ̶eote daɡ̶axatace mowidi niɡ̶icoa loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Niɡ̶ica naɡ̶a nigomaɡ̶a ijotawece niɡ̶ica noiigi me dinilegetibigiwaji, odaa Jesus jaɡ̶aɡ̶a dinilege. Niɡ̶ijo naɡ̶a yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, niɡ̶ica ditibigimedi domoke. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Odaa Liwigo Aneotedoɡ̶oji ja dinikatelogo Jesus dinanatigi yotibi. Odaa joɡ̶owajipata ica ane dotaɡ̶a digoida ditibigimedi, anee, “Akaami Ionigi aneliodi me ɡ̶ademaani, codaa eliodi me idinitibeci akaami leeɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Niɡ̶ijo niɡ̶idaa dinanatedigi Jesus me diba, ijoa 30 nicaaɡ̶ape. Odaa eliodi oko odiletibige daɡ̶a lionigi José. Pida Jesus ida aneetetege licoɡ̶egi Eli. ");
INSERT INTO kbcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli eliodi ica Matate, Matate eliodi ica Levi, Levi eliodi ica Malqui, Malqui eliodi ica Janai, Janai eliodi ica José, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José eliodi ica Matatias, Matatias eliodi ica Amós, Amós eliodi ica Naum, Naum eliodi ica Esli, Esli eliodi ica Nagai, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai eliodi ica Maate, Maate eliodi ica Matatias, Matatias eliodi ica Semei, Semei eliodi ica José, José eliodi ica Joda, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda eliodi ica Joanã, Joanã eliodi ica Resa, Resa eliodi ica Zorobabel, Zorobabel eliodi ica Salatiel, Salatiel eliodi ica Neri, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri eliodi ica Melqui, Melqui eliodi ica Adi, Adi eliodi ica Cosã, Cosã eliodi ica Elmadão, Elmadão eliodi ica Er, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er eliodi ica Josué, Josué eliodi ica Eliézer, Eliézer eliodi ica Jorim, Jorim eliodi ica Matate, Matate eliodi ica Levi, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi eliodi ica Simeão, Simeão eliodi ica Judá, Judá eliodi ica José, José eliodi ica Jonã, Jonã eliodi ica Eliaquim, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim eliodi ica Meleá, Meleá eliodi ica Mena, Mena eliodi ica Matata, Matata eliodi ica Natã, Natã eliodi ica Davi, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi eliodi ica Jessé, Jessé eliodi ica Obede, Obede eliodi ica Boaz, Boaz eliodi ica Sala, Sala eliodi ica Nassom, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassom eliodi ica Aminadabe, Aminadabe eliodi ica Admim, Admim eliodi ica Arni, Arni eliodi ica Esrom, Esrom eliodi ica Peres, Peres eliodi ica Judá, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá eliodi ica Jacó, Jacó eliodi ica Isaque, Isaque eliodi ica Abraão, Abraão eliodi ica Tera, Tera eliodi ica Nacor, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor eliodi ica Seruque, Seruque eliodi ica Ragaú, Ragaú eliodi ica Faleque, Faleque eliodi ica Éber, Éber eliodi ica Sala, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala eliodi ica Cainã, Cainã eliodi ica Arfaxade, Arfaxade eliodi ica Sem, Sem eliodi ica Noé, Noé eliodi ica Lameque, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque eliodi ica Metusalém, Metusalém eliodi ica Enoque, Enoque eliodi ica Jarete, Jarete eliodi ica Malaleel, Malaleel eliodi ica Cainã, ");
INSERT INTO kbcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã eliodi ica Enos, Enos eliodi ica Sete, Sete eliodi ica Adão, ane lionigi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aneotedoɡ̶oji Liwigo ini miniwataɡ̶a Jesus. Naɡ̶a dopitedijo Jesus me icoɡ̶otedicogi akiidi Jordão, odaa Liwigo Aneotedoɡ̶oji ja yadeegitedicogi miditaɡ̶a nipodigi ane yadilo, ane diɡ̶ica niɡ̶eladimigipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Niɡ̶icoatigilo cwareenta nokododi, odaa diaabo ja dineetalo Jesus me domeɡ̶eo deɡ̶eote libeyaceɡ̶egi. Niɡ̶ijoa nokododi aɡ̶ica ane yeligo, odaa niɡ̶idiaaɡ̶idi ja nigicile. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Odaa ɡ̶odaxakawa jeɡ̶eetalo, “Nigewi makaami Lionigi Aneotedoɡ̶oji, awii niɡ̶inoa wetiadi me paontedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Odaa Jesus ja igidi, meeteta, “Ajakadi, igaataɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji diniditeloco me diɡ̶inokina paon meo lewiɡ̶a oko, pida oko ewi mida lewiɡ̶a leeɡ̶odi niɡ̶ina meyiwaɡ̶adi inoatawece lotaɡ̶a Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Odaa diaabo ja yadeegitedicogi Jesus digoida maditaɡ̶a aca aneneɡ̶egi daɡ̶axa me leegitibigimece wetiɡ̶a. Odaa aniɡ̶ica daɡ̶a leegi, ja ikeetalo icoatawece niɡ̶icoa iiɡ̶otedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Odaa jeɡ̶eetalo Jesus, “Jajigotaɡ̶awa ɡ̶anaɡ̶atetigi me iiɡ̶eni inoatawece iiɡ̶otedi, codaa jajigotedaɡ̶awa inoatawece ane libinico aneiteloco. Igaataɡ̶a inoatawece onajigotediwa, odaa jakadi maɡ̶aɡ̶a jajigota okanicodaaɡ̶ica ane jemaa me jajigota. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Odaa idiwatawece niɡ̶idiwa ɡ̶anepilidi, nige amakitedini ɡ̶adokotidi yodoe moɡ̶eetetiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Odaa Jesus ja igidi, meeteta, “Emii opili Satanás! Igaataɡ̶a diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, ‘Oɡ̶eetetalo Ǥaniotagodi Aneotedoɡ̶oji, codaa iniokiniwateda moɡ̶eetetalo.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Odaa diaabo ja yadeegitedicogi Jesus nigotaɡ̶a Jerusalém, odaa ideyate miditaɡ̶a ica ane daɡ̶axa me leegitibigimece mini liɡ̶eladi Aneotedoɡ̶oji, odaa meetalo, “Nigewi makaami Lionigi Aneotedoɡ̶oji, adinaxokitinece natinedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Igaataɡ̶a diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, ‘Aneotedoɡ̶oji me niiɡ̶e niaanjotedi modoweditaɡ̶aloco’. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Codaa aaɡ̶aɡ̶a diniditini, ‘Moilokaditalo ɡ̶abaaɡ̶atedi modoweditaɡ̶aloco me deɡ̶etaciloteda ɡ̶adoɡ̶onaka midiwa wetiadi.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Odaa Jesus ja igidi, meeteta, “Ajakadi, igaataɡ̶a madi lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji diniditeloco, ‘Jinaɡ̶a adineenitalo Ǥoniotagodi Aneotedoɡ̶oji.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Niɡ̶ijo diaabo naɡ̶a ika me dineetalo Jesus minoatawece niɡ̶icoa anigotalo, odaa ja ikanawaanigi micaaniɡ̶igotalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus opitacedicogi nipodigi Galiléia, niɡ̶ica Aneotedoɡ̶oji Liwigo jeɡ̶eliodi me yajigotalo loniciwaɡ̶a. Odaa niɡ̶icoa nibodicetedi anoditece Jesus joniɡ̶ilaagiteloco iditawece niɡ̶idi nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Odaa diiɡ̶axinaɡ̶a midiwa liiakanaɡ̶axiidi judeutedi, odaa ijotawece ica oko anowajipatalo oiweniɡ̶ide. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus niɡ̶icotedicogi nigotaɡ̶a Nazaré ane liidaɡ̶adi. Odaa naɡ̶a saabado, jiɡ̶igo mani liiakanaɡ̶axi judeutedi ane lakatigitedibece. Odaa ja dabiditedini me dalomeɡ̶enataka. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Oyajigotalo notaɡ̶anaɡ̶axi ane idí Isaías, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Odaa Jesus naɡ̶a yowiegi naɡ̶adi notaɡ̶anaɡ̶axi, yowiegitedeloco midiwa nidiko anee, ");
INSERT INTO kbcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Liwigo Ǥoniotagodi Aneotedoɡ̶oji etini meetaɡ̶a. Igaataɡ̶a ee liomaɡ̶atagi, codaa me najigotiwa inimaweneɡ̶egi me jeloɡ̶oditedibece nibodicetedi anele midiwa madewetedi. Idiiɡ̶e me jeloɡ̶oditiogi niwilogojedi me jikaticoace, codaa jeloɡ̶oditiogi ɡ̶oladi me jao me yatetacibigiwaji, codaa me jao moiwoko niɡ̶ijo anoiatetibeci. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Idiiɡ̶e me jeloɡ̶oditiogi niɡ̶ica nicaaɡ̶abi nige ikee Ǥoniotagodi Aneotedoɡ̶oji meliodi meletetema niɡ̶ina oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Odaa Jesus ja ilipaditacediwage naɡ̶ajo notaɡ̶anaɡ̶axi, odaa ja yopilaɡ̶adite niɡ̶ijo nowienoɡ̶odi niiakanaɡ̶axi. Odaa ja nicotacedini. Ijotawece oko mani niiakanaɡ̶axi owatacotece. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Odaa ja dotaɡ̶a, meetediogi, “Niɡ̶ina noko, niɡ̶idi ane diniditeloco niɡ̶idi liwai lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji anajipaatatiwaji natigide, jiɡ̶icota. (Leeɡ̶odi jiɡ̶idaa idinanatigi me jiba.)” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iditawece oko ele modotaɡ̶atibige Jesus, codaa oyopo leeɡ̶odi lotaɡ̶a libinienaɡ̶a. Odaa modi, “Ica mele me dotaɡ̶a, niɡ̶idooda lionigi José!” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","(Jesus naɡ̶a yowooɡ̶odi me doɡ̶odibatege.) Odaa meetediogi, “Ajawienataka menitiwatiwaji niɡ̶ijo nigegi anee, ‘Dotowegi, akamaɡ̶a adinicilatiti!’ Codaa maɡ̶aɡ̶a enitiwa, ‘Awii digoina manataɡ̶a naɡ̶ana ɡ̶anigotaɡ̶a niɡ̶ijoa ane jibodicaɡ̶atalo mawiite manitaɡ̶a nigotaɡ̶a Cafarnaum.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Odaa mee, “Jeloɡ̶oditaɡ̶awatiwaji niɡ̶ina anewi, aɡ̶ica ini ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko anele modibatege miditaɡ̶a epaa loiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Diganajipaatiwatiwaji! Niɡ̶ijo jotigide owidi wajekalodi digoina ɡ̶oniiɡ̶o Israel malee yewiɡ̶a Elias, niɡ̶ijo ane yeloɡ̶oditibece Aneotedoɡ̶oji lowooko, niɡ̶ijo me daɡ̶a datiode itoatadiɡ̶ida nicaaɡ̶ape niɡ̶igo meeya. Odaa eliodi niɡ̶ica nigigi inatawece ɡ̶oniiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pida Aneotedoɡ̶oji aiiɡ̶e Elias me yaxawa anigeteɡ̶epidaɡ̶aca niɡ̶ina wajekalodipi judeutedi, digoina Israel. Pida iiɡ̶e Elias manitaɡ̶a aca wajekalo ane daɡ̶a ɡ̶odoiigi, ane liɡ̶eladi mani nigotaɡ̶a Sarepta digoida nipodigi Sidom ane daɡ̶a ɡ̶onipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eledi eliodi dawace-loolatedi judeutedi digoina Israel maleeɡ̶ijo Eliseu, inaaɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Pida aɡ̶ica ane icilatidi. Ijokijo Naamã, ane loiigi siiriotedi, baɡ̶a icilatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Niɡ̶ijo noɡ̶owajipatalo Jesus lotaɡ̶a, ijotawece niɡ̶ijo ane idei mani liiakanaɡ̶axi judeutedi eliodi me neliɡ̶ideeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Odaa ja dabiditiniwace oixigitedicogi wetice nigotaɡ̶a. Naɡ̶ani nigotaɡ̶a idei ditibigimedi ica lojotaɡ̶adi, odaa joɡ̶oyadeegitedicogi Jesus ditibigimedi lojotaɡ̶adi domaɡ̶a oyamaɡ̶atedinece wakagi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pida Jesus yakagiditediogi liwigotigi niɡ̶ijo noiigi, odaa joɡ̶opi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesus one dinikatedinicogi manitaɡ̶a aca nigotaɡ̶a Cafarnaum nipodigi Galiléia. Odaa niiɡ̶axitediniwace niɡ̶idi noiigi me saabado. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eliodi moyopo leeɡ̶odi anodaaɡ̶eeteda me diiɡ̶axinaɡ̶a, igaataɡ̶a dotaɡ̶a micataɡ̶a anida epaa naɡ̶atetigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Manitaɡ̶a niiakanaɡ̶axi aneite me diiɡ̶axinaɡ̶a onini ica ɡ̶oneleegiwa anodakatiogi, icoa lowooko one beyagi. Odaa igedi me dotaɡ̶a, mee, ");
INSERT INTO kbcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Amiina anemaanitoɡ̶odici, Jesus ane ɡ̶adiɡ̶eladi Nazaré? Domige naɡ̶anagi me ɡ̶odaaɡ̶ateɡ̶egi? Jowooɡ̶odi anakaami! Jaɡ̶akamaɡ̶akaami ane niiɡ̶e Aneotedoɡ̶oji, codaa iniokiniwateda mabaatema.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Odaa Jesus ja yapeteɡ̶e, meeteta, “Anotokiti, codaa anotitice niɡ̶ida ɡ̶oneleegiwa!” Niɡ̶ijo niwigo abeyaceɡ̶egi yokoletinigi iiɡ̶o niɡ̶ijo ɡ̶oneleegiwa lodoe ijotawece niɡ̶ijo noiigi, pida aɡ̶ica elaciledi niɡ̶ijo ɡ̶oneleegiwa. Odaa ja noditice niwigo abeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iditawece niɡ̶ica oko nawelatibigiwaji, odaa dinotaɡ̶aneɡ̶e midiaaɡ̶iditiwage, modi, “Ganigaaleeɡ̶inoa niɡ̶inoa lotaɡ̶a! Igaataɡ̶a ida nimaweneɡ̶egi codaa me loniciwaɡ̶a me iticoitedice niwicidi abeyacaɡ̶aɡ̶a. Niɡ̶ina me iiɡ̶e, odaa ja noditicoaci.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Odaa nibodicetedi anoditece Jesus jiɡ̶ilaagiteloco iditawece niɡ̶idi nipodigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus naɡ̶a noditedice niiakanaɡ̶axi, odaa jiɡ̶igo liɡ̶eladi Simão. Aca loxiiɡ̶ate Simão one deelotika, dapicoɡ̶o-lolaadi. Odaa joɡ̶odipokotalo Jesus me icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Odaa Jesus jiɡ̶igo. Niɡ̶icoteta naɡ̶ajo iwaalo, odaa ja dakagitedeloco, ja iiɡ̶e me noditice dapicoɡ̶o-lolaadi. Odaa aɡ̶ica daɡ̶a leegi ja icí, odaa ja dabiditini, ja doolaɡ̶atema Ǥoniotagodi idiaa lokaaɡ̶etedipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Niɡ̶ijo naɡ̶a dalimeti aligeɡ̶e, niɡ̶ica oko anini litaagi ane deelotika, oyadeegitalo Jesus. Adinatopiamico leelotika. Jesus dibatedeloco oninitecibeci ane deelotika, odaa ja icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Niwicidi abeyacaɡ̶aɡ̶a noditicoaci mijotaɡ̶a eliodi oko. Naɡ̶a noditicoaci, dinigetaɡ̶ateetibigiwaji me notaɡ̶anaɡ̶a, modi, “Ja makamaɡ̶akaami Lionigi Aneotedoɡ̶oji!” Oyowooɡ̶odi niɡ̶idaaɡ̶idoa niɡ̶icoa Cristo, ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi. Pida joaniɡ̶idaa leeɡ̶odi Jesus me yapeteɡ̶e, codaa aika modi niɡ̶ijaaɡ̶ijoa icoa Cristo. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Niɡ̶ijo naɡ̶a yeloɡ̶otibige, Jesus ja noditedice nigotaɡ̶a, igo miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi. Niɡ̶ijo noiigi odoletibige, odaa noɡ̶odakapetege, adomaɡ̶aleeɡ̶oikatedice mopi. ");
INSERT INTO kbcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pida Jesus meetediogi, “Leeditibige mejigo jeloɡ̶oditedibece nibodicetedi anele midiwataɡ̶a eletidi nigotadi. Igaataɡ̶a idiiɡ̶e Aneotedoɡ̶oji me jeloɡ̶oditedibece nibodicetedi anele, me icota anigida noko iiɡ̶e inatawece niɡ̶ina noiigitigi niɡ̶ina iiɡ̶o.” ");
INSERT INTO kbcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Odaa ja yatematitedibece nibodicetedi anele midiwataɡ̶a niiakanaɡ̶axiidi nipodigiteloco Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ica noko Jesus ideite liniogotibece niweiigi Genesaré (eledi liboonaɡ̶adi me Galiléia), odaa niɡ̶ica noiigi joɡ̶odiniligicetelogo, leeɡ̶odi moyemaa mowajipatalo Aneotedoɡ̶oji lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Odaa naɡ̶a nadi icoa itiwataale niwateceli ane ideitedice liniogotibece weiigi. Niɡ̶ijo nomiigomigipi waxoditicoace liwateceli, oiwilegi leelatiidi anoibake me nomiigomigipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Odaa Jesus jona waxoditedinigi aca niwatece ane Simão nebi. Odaa jona dipokote me yotonawaanigitice liniogotibece. Odaa naɡ̶a nicotedini Jesus, ja niiɡ̶axitediniwace niɡ̶ijo noiigi, ideite catinedi naɡ̶ajo niwatece. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Niɡ̶ijo naɡ̶a ika me niiɡ̶axitediniwace niɡ̶ijo noiigi, odaa meeteta Simão, “Adeegiticogi ɡ̶awatece digoida liwigotinigi, odaa okolenitinitiwaji ɡ̶adeelatiidi abaatalo noɡ̶ojedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Odaa Simão ja niniɡ̶odi, meetalo, “Ǥoniiɡ̶axinoɡ̶odi, ja jomiigaɡ̶a ijotawece enoale, aɡ̶ica ɡ̶obakajetege. Pida leeɡ̶odi makaami ɡ̶odiiɡ̶eneɡ̶egi, jiɡ̶idaa leeɡ̶odi nige jokolenaɡ̶atacedini ɡ̶odeelatiidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Odaa niɡ̶ijo noɡ̶oyokoletedini leelatiidi, owidi niɡ̶icoa libakajetedi noɡ̶ojedi, ja domaɡ̶a daa niɡ̶ijoa leelatiidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Odaa joɡ̶oyategitiogi icoa eletidi lokaaɡ̶etedi maditaɡ̶a aca eledi niwatece menagitibeci oyaxawatiogi. Neɡ̶enagitibeci odaa joɡ̶oyetigilo niɡ̶ijoa niwateceli noɡ̶ojedi, jona domaɡ̶a domololetedini, leeɡ̶odi me daɡ̶axa me iwaaɡ̶adi niɡ̶ijoa noɡ̶ojedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Niɡ̶ijo Simão Pedro naɡ̶a nadi loniciwaɡ̶a Jesus, odaa ja yamaɡ̶atedini lokotidi lodoe Jesus, odaa meetalo, “Adiwikodeni, adotonitice Iniotagodi, igaataɡ̶a eemoda ɡ̶oneleegiwa aninoa libatico!” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Eo niɡ̶ida ligegi leeɡ̶odi Simão ijaaɡ̶ijoa eletidi ane idei mijotaɡ̶a eliodi moyopo loniciwaɡ̶a Jesus, igaataɡ̶a onowidi niɡ̶icoa noɡ̶ojedi anodibatalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago ijaa João lionigipi Zebedeu, lokaaɡ̶etedi Simão, eledi eliodi moyopo. Odaa Jesus jeɡ̶eete Simão, “Jinaɡ̶adoii! Natigidiwaɡ̶a abaatalo noɡ̶ojedi majicitiogi oko. Pida niɡ̶ina natigide ja ɡ̶abakedi mawii metidadiwaɡ̶adi oko, odaa jaɡ̶ajicitalo Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Odaa noɡ̶oyadeegitedicogi liwateceli daato, odaa joɡ̶odiotece Jesus, joɡ̶oika ijoatawece ane libaketedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ica noko, Jesus me ideite manitaɡ̶a aca nigotaɡ̶a, odaa onini ica ɡ̶oneleegiwa ane daɡ̶axatece ica dawace-lolaadi. Niɡ̶ijo naɡ̶a naditege Jesus, odaa ja dakagitinigi iiɡ̶o neɡ̶epaa itinigi iiɡ̶o latobi, diniwikodetibece. Odaa ja dipokotalo Jesus, meetalo, “Iniotagodi, nigemaani madicilatiti, jowooɡ̶odi mida ɡ̶adoniciwaɡ̶a madicilatiti.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Odaa Jesus ja dibatedeloco, meete, “Ee! Jemaa me ɡ̶adicili!” Aoniɡ̶ica daɡ̶a leegi jona icí niɡ̶ijo ɡ̶oneleegiwa ane dawace-lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pida Jesus yajoi me diɡ̶ica ane yeloɡ̶odita me icilatidi, meeteta, “Emii minitaɡ̶a ane libakadi Aneotedoɡ̶oji liɡ̶eladi, adinikeenita, codaa aboonitalo Aneotedoɡ̶oji niɡ̶ijo eijeeɡ̶agi ane diiɡ̶enataka Moisés me dinalegi, amaleeɡ̶aɡ̶a oyowooɡ̶odi niɡ̶ina oko naɡ̶a ɡ̶adicili.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pida niɡ̶ijo okotigi anitawece nigotaɡ̶a jeɡ̶eliodi moyalaɡ̶atalo Jesus, odaa niɡ̶ica noiigi joɡ̶ototalo mowajipatalo lotaɡ̶a, codaa me nicilatiditediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pida idioka limedi me dinoɡ̶atedicobece, migo miditaɡ̶a nipodigi ane diɡ̶ica niɡ̶eladimigipi, yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ica noko Jesus niiɡ̶axitediniwace ica noiigi. Niɡ̶ica aneite, onidi me nicotiniwace icoa fariseutedi icaaɡ̶icoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Oicoɡ̶oticogi inoatawece ane nigotadawaanaɡ̶a nipodaɡ̶a Galiléia aniaa Judéia, codaa me oicoɡ̶oticogi nigotaɡ̶a Jerusalém. Niɡ̶ica loniciwaɡ̶a Ǥoniotagodi Aneotedoɡ̶oji idei mijoataɡ̶a Jesus niɡ̶ina me nicilatiditediniwace eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Odaa digawini niciagi, onicoa icoa ɡ̶oneleegiwadi anoyadeegi ica alejaado ane daɡ̶adiaa ditineɡ̶e, one iwoteloco liɡ̶elate, odaa joɡ̶odoletibige nimaweneɡ̶egi me dakatiobece catiwedi diimigi aneite Jesus, domoɡ̶oyadeegiticogi niɡ̶ijo ɡ̶oneleegiwa lodoe Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pida aɡ̶oyakadi me dakatiobece leeɡ̶odi niɡ̶ica noiigi-nelegi. Odaa joɡ̶onoɡ̶eletibigimece ditibigimedi diimigi leláɡ̶a. Odaa jonoɡ̶onoɡ̶a deegajoli, owo lawimaɡ̶ajegi diimigi. Noɡ̶oigodi moyomoke niɡ̶ijo diimigi leláɡ̶a, odaa joɡ̶oyexaɡ̶atinigi niɡ̶ijo alejaado catinedi liɡ̶elate, odaa joɡ̶onikatini lodoe Jesus liwigotigi niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Niɡ̶ijo Jesus naɡ̶a nadi mida eliwaɡ̶atakaneɡ̶egi niɡ̶ijoa lokaaɡ̶etedi alejaado, odaa jeɡ̶eete, “Yokaaɡ̶edi, ɡ̶abeyaceɡ̶eco ja inapitaɡ̶adi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Odaa niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, ijaaɡ̶ijoa fariseutedi dinotaɡ̶aneɡ̶etiwage, modi, “Amiidoa icoa ɡ̶oneleegiwa ane diniciaceeketetege Aneotedoɡ̶oji? Igaataɡ̶a iniokiniwateda Aneotedoɡ̶oji me yakadi me napitaɡ̶adi oko libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pida Jesus ja yowooɡ̶odi niɡ̶ica anodinotaɡ̶aneɡ̶etigi, odaa jeɡ̶eetediogi, “Igaamee ina mawii ida ɡ̶adowoogotiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mige daɡ̶axa me dakake mejita niɡ̶idi alejaado, ‘Ja inapitaɡ̶adi ɡ̶abeyaceɡ̶eco,’ oɡ̶oa, domige daɡ̶axa me dakake me jiiɡ̶e me dabiditini, odaa jeɡ̶ewaligi? ");
INSERT INTO kbcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pida natigide amaleeɡ̶aɡ̶a owooɡ̶otitiwaji, jikeetaɡ̶awa me Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, mida iiɡ̶enatakaneɡ̶egi digoina iiɡ̶o me inapitaɡ̶adi libeyaceɡ̶eco oko.” Odaa jeɡ̶eete niɡ̶ijo alejaado, “Adabititini! Abaata ɡ̶adiɡ̶elate, odaa opiliticogi ɡ̶adiɡ̶eladi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aɡ̶ica daɡ̶a leegi niɡ̶ijo ɡ̶oneleegiwa ja dabiditi lodoe ijotawece niɡ̶ijo noiigi, naɡ̶a dibata liɡ̶elate, odaa joɡ̶opiticogi liɡ̶eladi, diniotagodetibigimece Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ijotawece niɡ̶ijo noiigi eliodi moyopo, codaa odoɡ̶etetibigimece Aneotedoɡ̶oji. Eliodi maɡ̶aɡ̶a doitibigiwaji, odaa modi, “Niɡ̶ina noko, jinataɡ̶a nibinico ane diɡ̶icoa me jinataɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Niɡ̶idiaaɡ̶idi Jesus naɡ̶a noditedice nigotaɡ̶a, odaa ja nadi ica ɡ̶oneleegiwa ane liboonaɡ̶adi Levi. One libakedi me dibatibigege ninyeelo ninionigi-eliodi romaanotedi. One nicote niɡ̶ica aneitibige moyedia. Odaa Jesus jiɡ̶igo minitaɡ̶a, odaa jeɡ̶eete, “Anagi, aniwitici!” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Odaa Levi ja dabiditini, ja yaladi ane libakedi, odaa ja diotece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Odaa Levi ja yaloke Jesus eo ica nalokegi nelegi mini liɡ̶eladi. Odaa eliodi niɡ̶ica anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa meledi eliodi oko idi me nicoɡ̶owepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Icoa fariseutedi icaaɡ̶icoa anodiiɡ̶axinaɡ̶atece najoinaɡ̶aneɡ̶eco anida aneetege niɡ̶ijo lapo fariseutedi eledi idi, joɡ̶oyalomeɡ̶e niɡ̶ijo anodiotibece Jesus, moditiogi, “Igaamee ina me ɡ̶agiiwepoditiwaji idi anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa me niɡ̶inoa eletidi abeyacaɡ̶aɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Odaa ja igidi Jesus, meetediogi, “Niɡ̶ina anicileɡ̶egipi aɡ̶oyopotibige dotowegi, pida niɡ̶ina ane neelotikanaɡ̶a boɡ̶oyopotibige dotowegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ajanagi daɡ̶a jiniditiogi ane iɡ̶enaɡ̶atibigiwaji, pida janagi me jiniditiogi aninoa libeyaceɡ̶eco amaleeɡ̶aɡ̶a odinilaatece libeyaceɡ̶eco, odaa joɡ̶odopitalo Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ica noko moditalo Jesus, “Niɡ̶ijo anodiotibeci João Batista idatecibece aniodaɡ̶a, owotibige meneɡ̶egi yoniciwaditibigiwaji moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Anaɡ̶aɡ̶a oniotoɡ̶odici ane fariseutedi idaaɡ̶ee. Pida niɡ̶idi anodiotibigaɡ̶adici baadiɡ̶ica doɡ̶oika me niodaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Odaa Jesus jeɡ̶eetediogi, “Domigakatitiwaji molii me niodaɡ̶a, niɡ̶ina nodenigipi midi nadoneɡ̶egi, ina niɡ̶ini miditaɡ̶a niɡ̶ini ane wado? ");
INSERT INTO kbcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pida icota noko monoɡ̶atice niɡ̶ini ane wado me ideitice liwigotigi. Odaa niɡ̶ida noko joɡ̶oika me niodaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus eledi yatematitediogi ica natematigo anida ane ɡ̶odiiɡ̶axitece, meetediogi, “Aɡ̶ica ini ane dapadenaɡ̶ata niɡ̶ina lipegeteɡ̶e liwai gela daɡ̶a napadeteloco nowoodaɡ̶agi oxiiɡ̶odi. Nigica anidaɡ̶aee, ibeyacaɡ̶adi naɡ̶adi lapadexe, codaa niɡ̶ina napadenaɡ̶anaɡ̶adi me gela aɡ̶eyotinigi niɡ̶ina nowoodaɡ̶agi oxiiɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Eleditace migini ane yadotinigi viinyo gela naɡ̶ana laɡ̶aaɡ̶axi ewacogo baanoɡ̶opake. Nigica anidaaɡ̶ee, niɡ̶idiwa laɡ̶aaɡ̶axidi laxokodi datope, odaa jaɡ̶anado niɡ̶ica viinyo, codaa jaɡ̶aɡ̶a beyagi niɡ̶icoa laɡ̶aaɡ̶axidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Leeditibige moyetigi niɡ̶ina viinyo gela naɡ̶ana laɡ̶aaɡ̶axi gela. ");
INSERT INTO kbcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Codaa aɡ̶ica ane yemaa viinyo gela, niɡ̶ina naɡ̶a eliodi me wacipeta viinyo oxiiɡ̶odi, igaataɡ̶a yakadi mee, ‘Niɡ̶ina viinyo oxiiɡ̶odi daɡ̶axa mele.’” (Jesus yatemati niɡ̶ida natematigo me ikee liiɡ̶axinaɡ̶aneɡ̶eco mepaɡ̶a geladi.) ");
INSERT INTO kbcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Neɡ̶eledi saabado Jesus jonaɡ̶a yakagiditedeloco ica nixoɡ̶otagi aninaa leyeema. Niɡ̶ijo anodiotibece onotegi noɡ̶onigakala, odaa joɡ̶oyeligo lolacidi leyeema. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Odaa onicoa icoa fariseutedi anodi, “Igaamee ina mawiitiwaji ida aneni, ɡ̶onajoinaɡ̶aneɡ̶eco aɡ̶odika me jaoɡ̶a niɡ̶ida aneni niɡ̶ina me saabado? (Igaataɡ̶a ane daɡ̶a ɡ̶odika me jaoɡ̶a okanicodaaɡ̶ica nibakedi codaa me inigakalaɡ̶a leyeema).” ");
INSERT INTO kbcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus naɡ̶a igidi, meetediogi, “Agodiɡ̶ica malomeɡ̶enitelocotiwaji, niɡ̶ijo Davi loenatagi, naɡ̶a nigicile, ijaaɡ̶ijoa lokaaɡ̶etedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davi geme dakatiwece lopegedi Aneotedoɡ̶oji. Odaa ja dibatalo niɡ̶ijoa paontedi anoyajigotalo Aneotedoɡ̶oji, odaa ja yeligo, ligiiwepodi lokaaɡ̶etedi. Pida ɡ̶onajoinaɡ̶aneɡ̶eco modi midiokidi moyakadi moyeligo niɡ̶idi ane nibaaɡ̶a mini Aneotedoɡ̶oji lopegedi, niɡ̶idiwa paontedi anoibootalo Aneotedoɡ̶oji.” (Pida aɡ̶ica daɡ̶a nilaagedi Davi.) ");
INSERT INTO kbcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Odaa Jesus jeɡ̶eetediogi, “Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, jeɡ̶emaɡ̶a jiiɡ̶e niɡ̶ina anoyakadi mowo niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Neɡ̶eledi saabado, Jesus one dakatediwece niiakanaɡ̶axi me diiɡ̶axinaɡ̶a. Odaa oninica ɡ̶oneleegiwa alejaado, beyagi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Icoa anodiiɡ̶axinaɡ̶atece najoinaɡ̶aneɡ̶eco icoa fariseutedi, anaɡ̶aɡ̶a idi oiɡ̶oaditalo Jesus, oyemaa moiwi mige dicilatitaɡ̶a niɡ̶ina me saabado. Owotibige moyakadi modotaɡ̶atibige Jesus me daɡ̶a yoteteteda saabado. (Leeɡ̶odi lakatigi judeutedi me daɡ̶a nibaaɡ̶a niɡ̶ina me saabado.) ");
INSERT INTO kbcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pida Jesus yowooɡ̶oditediwe niɡ̶icoa lowooko. Odaa joaniɡ̶idaa leeɡ̶odi meete niɡ̶ijo beyagi libaaɡ̶adi, “Adabititini lodoe niɡ̶ina oko!” Odaa niɡ̶ijo ɡ̶oneleegiwa ja dabiditi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Odaa Jesus meetediogi, “Ǥadigeetiwaji, amiini ica ane diiɡ̶enatakata ɡ̶onajoinaɡ̶aneɡ̶eco me jaoɡ̶a ina me saabado? Domige ɡ̶odiiɡ̶e me jaoɡ̶a anele, oɡ̶oa, domige ane beyagi? Jakadi me inoɡ̶a ane yeloadi oko, oɡ̶oa domige jakadi me jeloadi oko?” ");
INSERT INTO kbcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Odaa iwitediogi iditawece niɡ̶idi anoyawiile. Odaa meete Jesus niɡ̶ijo ane beyagi libaaɡ̶adi, “Ixokenitice ɡ̶abaaɡ̶adi!” Naɡ̶a ixoketice libaaɡ̶adi, odaa ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Odaa eliodi me neliɡ̶ideeɡ̶a niɡ̶ijoa lakapetedipi, codaa odinotaɡ̶aneɡ̶etigi niɡ̶ica anodigotalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Niɡ̶ijoa nokododi, Jesus igo dalaɡ̶atetedibigimece aca wetiɡ̶a me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Odaa idiaa ixomaɡ̶ateetedice ijotawece enoale me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Noɡ̶one yeloɡ̶otibige, Jesus jeɡ̶eniditediogi ɡ̶oneleegiwadi anodiotibece. Odaa ja iomaɡ̶aditedice dooze, odaa joniɡ̶ida ica aneyatedigi me “Liiɡ̶exedi Aneotedoɡ̶oji.” Odaa liboonaɡ̶atedi niɡ̶icoa ɡ̶oneleegiwadi: ");
INSERT INTO kbcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Simão aneote Jesus me liboonaɡ̶adi me Pedro, ijaaɡ̶ijo nioxoa anodita André; Tiago, ijaa João, Filipe; ijaa Bartolomeu; Mateus ijaa Tomé; Tiago ane lionigi Alfeu; Simão analeeɡ̶oyatigi me Zelotes; Judas ane lionigi eledi Tiago; ijaa Judas Iscariotes aneyaa Jesus mijotaɡ̶a neloɡ̶ododipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Odaa noɡ̶one dinikatedini Jesus me icoɡ̶otedibigimece aca wetiɡ̶a, odaa ja dabiditedini miditaɡ̶a ica anabotiwage ijaaɡ̶ijo noiigi anodiotibece. Codaa onidi ica eliodi oko aɡ̶icaadaɡ̶a icoɡ̶oticogi niɡ̶icoa nipodaɡ̶a Judéia, codaa me nigotaɡ̶a Jerusalém, codaa me nipodaɡ̶a aca Tiro aniaa Sidom, anodipegitinece ica akiidi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Igotibeci mowajipatalo lotaɡ̶a Jesus, codaa me nicilatiditediniwace leelotika. Icaaɡ̶ica ane diotibece niwicidi abeyacaɡ̶aɡ̶a anowote niɡ̶inoa lowooko ane napioi, eledi igotibeci diniwakateetibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ijotawece niɡ̶ijo noiigi odoletibige modibatelogo Jesus, leeɡ̶odi noditice ica loniciwaɡ̶a ane icilatidi iditawece oko ane neelotikanaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus iwitediogi niɡ̶ijo anodiotibece, odaa meetediogi, “Niɡ̶ida makaamitiwaji aniniitibeci, anakaami madewetedi, igaataɡ̶a Aneotedoɡ̶oji ja iiɡ̶e ɡ̶adaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aniniitibecitiwaji ane anigicile niɡ̶ina natigide, igaataɡ̶a icota me ɡ̶aditiminitiwaji. Aniniitibecitiwaji ane anoenitibece niɡ̶inoa nokododi, igaataɡ̶a icota malajikanitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aniniitibeci niɡ̶ina akaamitiwaji ane deɡ̶etiɡ̶ademaani, ane deɡ̶ele modibataɡ̶agi, codaa metiɡ̶adienitibige, nige odi makaami abeyacaɡ̶aɡ̶a, leeɡ̶odi maniwitici ane Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Niɡ̶ina nige ixomaɡ̶ateenitedijo niɡ̶inoa nawikodico anejitalo, jemaa meliodi maniniitibecitiwaji. Igaataɡ̶a Aneotedoɡ̶oji ja yotetetedaɡ̶adomi ane daɡ̶axa meletaɡ̶adomitiwaji digoida ditibigimedi. Igaataɡ̶a diganee natigide, jiɡ̶idaaɡ̶ee niɡ̶ijo jotigide litacepodi niɡ̶ina oko moyametibigo niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pida akaamitiwaji biɡ̶icota meliodi mawikodeetiwaji, anakaami liicotedi, igaataɡ̶a jaɡ̶abaatege icoatawece niɡ̶icoa anakati mabaatege, aɡ̶aleeɡ̶abaatege eledi aneletaɡ̶adomi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Icota meliodi maɡ̶aɡ̶a awikodeetiwaji, akaami anele manioditiwaji niɡ̶inoa nokododi, igaataɡ̶a icota me ɡ̶adeloati nigigi. Codaa icota meliodi mawikodee, akaami ane alajikanitibece, igaataɡ̶a icota manoeni leeɡ̶odi ɡ̶agecaɡ̶aloɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Eliodi maɡ̶aɡ̶a awikodee niɡ̶ina akaami anetiɡ̶adiweniɡ̶ideni niɡ̶ina oko, igaataɡ̶a niɡ̶ica jotigide ɡ̶adaamipi aaɡ̶aɡ̶a oiweniɡ̶ide niɡ̶ijoa awitakaɡ̶aɡ̶a anodi moyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. (Pida oinaale niɡ̶ijo noiigi.) ");
INSERT INTO kbcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pida ejitaɡ̶awatiwaji ane anajipaatiwa, me leeditibige memaani ɡ̶oneloɡ̶ododipi, codaa awii niɡ̶ica aneletema niɡ̶ijo anakaami neleɡ̶etedipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ipokitalo Aneotedoɡ̶oji me ibinietediogi niɡ̶ina anodotaɡ̶atibigaɡ̶aji, codaa otaɡ̶aneɡ̶enitetiwaji Aneotedoɡ̶oji me ibinietediogi niɡ̶ina anoyametibigaɡ̶aji. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nigica ane yabaketigi ɡ̶adajice, ajicita naɡ̶ani eledi ɡ̶adajice maɡ̶aɡ̶a yabake. (Me ikeeni me diɡ̶ica ɡ̶adelaɡ̶atema.) Nigica ane dibata ɡ̶anicaapa ajici codaa me ɡ̶anoecaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Idioka limedi medianitiwaji niɡ̶ina ane dipokotaɡ̶awa ganigica. Codaa niɡ̶ina ane dibata ganigidi ane ɡ̶anebi, jiniɡ̶ipoki doɡ̶oyopilaɡ̶aditaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ademii oko niɡ̶ica anemaani modigotaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Niginoka emaani niɡ̶ina anetiɡ̶ademaani, aɡ̶ica ɡ̶anigaanye miniwataɡ̶a Aneotedoɡ̶oji. Igaataɡ̶a niɡ̶ina oko ane beyagi aaɡ̶aɡ̶oyemaa niɡ̶ina nemaanoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Codaa nigawii aneletema inokina niɡ̶ina anowotaɡ̶adomi anele, odaa aɡ̶icatace ɡ̶anigaanye. Igaataɡ̶a niɡ̶ina oko abeyacaɡ̶aɡ̶a jiɡ̶idaaɡ̶ee. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Codaa nigadilaɡ̶aneɡ̶enitiogi inokina niɡ̶ina ane eni metiɡ̶adediani, nigica anigidi ɡ̶adowoodaɡ̶agi anonadila, aɡ̶icatace ɡ̶anigaanyetiwaji. Igaataɡ̶a niɡ̶ina oko ane beyagi eo ladiligi niɡ̶ina inaaɡ̶ina abeyaceɡ̶egi eotibige me dibatege liikoa. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pida jemaa memaani ɡ̶aneloɡ̶ododipi, codaa awii niɡ̶ina aneletema, awii ladiligi, pida niɡ̶ina me daɡ̶a aliitege me yopilaɡ̶aditaɡ̶awa liikoa. Joaniɡ̶idaaɡ̶ee odaa baɡ̶a ɡ̶adedianitetiwaji Aneotedoɡ̶oji, codaa akaami lionigipi Aneotedoɡ̶oji ane iiɡ̶e inoatawece. Igaataɡ̶a eletetema codaa me niɡ̶ina oko ane daɡ̶a diniotagodetibigiwaji codaa me abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Iwikodeni eledi oko, diganigotedaɡ̶awa Aneotedoɡ̶oji Ǥadiodi me ɡ̶adiwikodenitetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jinaɡ̶awini anee eledi oko niɡ̶ina ane daɡ̶a iwikodeni, odaa Aneotedoɡ̶oji aiwi anenitiwaji oteɡ̶exaaɡ̶aɡ̶a ɡ̶adiloikatititetiwaji. Jineɡ̶eni me leeditibige moiloikatidi oko leeɡ̶odi meo ane beyagi. Odaa Aneotedoɡ̶oji aɡ̶ee me leeditibige metiɡ̶adiloikatititetiwaji. Adinaagitititibige okanicodaaɡ̶ica ane beyagi anowotaɡ̶adomi. Odaa Aneotedoɡ̶oji yaagiditedibige niɡ̶ijoa ɡ̶adoenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ajicitatiwaji eledi oko niɡ̶ica ane yopotibige, odaa Aneotedoɡ̶oji yajigotedaɡ̶awatiwaji niɡ̶ica anopootibige. Digo micataɡ̶a niɡ̶ina oko ane yetigi nelegei leyeema neɡ̶epaa niolakati, alee ipiati, joaniɡ̶idaaɡ̶ee eliodi ane yajigotedaɡ̶awa Aneotedoɡ̶oji. Igaataɡ̶a Aneotedoɡ̶oji yajigotedaɡ̶awa liciagi niɡ̶ina anajicita eledi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus yeloɡ̶oditediogi ica natematigo anida ane ɡ̶odiiɡ̶axitece, meetediogi, “Niɡ̶ina ɡ̶olaɡ̶a domige yakadi me digilaɡ̶atedeta eledi ɡ̶olaɡ̶a? Nige digilaɡ̶atedeta, odaa niɡ̶idoa itoata ɡ̶oladi yeloɡ̶o me daxaboketinece diɡ̶ica begi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Codaa niɡ̶ina ane didiko anaɡ̶axateloco niiɡ̶axinoɡ̶odi. Pida niɡ̶ina nige igodi icoatawece niɡ̶icoa lidiko, odaa ja liciagi niɡ̶ini niiɡ̶axinoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jinaɡ̶a ɡ̶adiɡ̶oati laɡ̶amicaɡ̶ajegi ɡ̶anioxoa catiwedi ligecooɡ̶e, leeɡ̶odi akamaɡ̶akaami oteɡ̶exaaɡ̶aɡ̶a emaani mowooɡ̶oti niɡ̶idi iwoɡ̶o liwai ane idei catiwedi ɡ̶agecooɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pida menita ɡ̶anioxoa, ‘Inioxoa, anagi! Inoɡ̶a ɡ̶adaɡ̶amicaɡ̶ajegi catiwedi ɡ̶agecooɡ̶e.’ Igaamee ina mawii ida ɡ̶agegi, akamaɡ̶akaami aɡ̶emaani mowooɡ̶oti niɡ̶idi iwoɡ̶o liwai catiwedi ɡ̶agecooɡ̶e? Ǥademaanigi mokawii makaami ele. Pida ele majela manoɡ̶aa niɡ̶idi iwoɡ̶o liwai catiwedi ɡ̶agecooɡ̶e, odaa jeɡ̶ele manatiteloco laɡ̶amicaɡ̶ajegi ɡ̶anioxoa manoɡ̶aatema. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Naɡ̶ana niale anele, abeyagi elali. Odaa naɡ̶ana niale ane beyagi, aɡ̶ele elali. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Codaa jowooɡ̶otaɡ̶a anada naɡ̶ana niale leeɡ̶odi niɡ̶inoa elali. Igaataɡ̶a ainotecaɡ̶a ilipeɡ̶e madataɡ̶a lalepiɡ̶igo, codaa ainoɡ̶aaɡ̶a ‘uuva’ maditaɡ̶a omiigonaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Igaataɡ̶a niɡ̶ina anele icoɡ̶otiwece laaleɡ̶ena niɡ̶ina oko anele, leeɡ̶odi laaleɡ̶ena nolee niɡ̶ica anele. Pida niɡ̶ina ane beyagi icoɡ̶otiwece laaleɡ̶ena niɡ̶ina oko ane beyagi, leeɡ̶odi laaleɡ̶ena nolee ane beyagi. Igaataɡ̶a niɡ̶ina oko eetece inokina niɡ̶ina ane idei catiwedi laaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Igaamee ina menitiwatiwaji, ‘Ǥoniotagodi, Ǥoniotagodi,’ pida aɡ̶awii niɡ̶ina ane jiiɡ̶etaɡ̶awatiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Natigide jeloɡ̶oditaɡ̶awatiwaji anodaaɡ̶ee niɡ̶ina oko anenagi meetaɡ̶a, odaa wajipatalo yotaɡ̶a, codaa idadiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jiciaceeketege niɡ̶ina ɡ̶oneleegiwa ane dabiteɡ̶etini liɡ̶eladi. Odaa ilecatiditinece me naligitedini lawonadi ditibigimedi wetiɡ̶a. Odaa naɡ̶a abooɡ̶o-akiidi, icota ninyoɡ̶odi minitaɡ̶a liɡ̶eladi. Pida ninyoɡ̶odi ayakadi me igike niɡ̶ini diimigi, leeɡ̶odi datiteta moyojogotini. ");
INSERT INTO kbcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pida niɡ̶ina oko ane wajipatalo yotaɡ̶a, pida aɡ̶eyiwaɡ̶adi, baɡ̶a liciagi eledi ɡ̶oneleegiwa ane dabiteɡ̶etini liɡ̶eladi. Dabiteɡ̶etini miditaɡ̶a dotiwadi, pida boɡ̶odaa ayatitaɡ̶aditedini lawonadi. Naɡ̶a abooɡ̶o-akiidi, niɡ̶icota ninyoɡ̶odi liɡ̶eladi. Odaa jeɡ̶enitini, aɡ̶ica nenyakigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Niɡ̶ijo naɡ̶a nigotedini Jesus me yotaɡ̶aneɡ̶e niɡ̶idi noiigi, odaa jiɡ̶igo manitaɡ̶a nigotaɡ̶a Cafarnaum. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Odaa oninica ɡ̶oneleegiwa ane iiɡ̶e onaniteci taalia iodaɡ̶awadi. Ica liotagi ane daɡ̶axa me yemaa, one deelotika, jona doletibige me yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Niɡ̶ini ane iiɡ̶e niodaɡ̶awadi romaanotedi naɡ̶a dibodicetalo Jesus, jona iiɡ̶e icoa lacilodi judeutedi migotibeci odipokotalo Jesus migo icilatidi niɡ̶ijo liotagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Noɡ̶ototalo Jesus, odaa icaanoɡ̶odigotalo mowotibige migo, moditalo, “Janagaɡ̶a makaamitaɡ̶a, jemaanaɡ̶a micilatiti liotagi lacilo iodaɡ̶awadi, igaataɡ̶a niɡ̶ini ane iiɡ̶e niodaɡ̶awadi romaanotedi, ɡ̶oneleegiwa libinienigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Codaa eliodi me yemaa ɡ̶odoiigi, jeɡ̶epaa diiɡ̶enatakata modabiteɡ̶etini ɡ̶odiiakanaɡ̶axi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Odaa Jesus jiɡ̶igo lixigaɡ̶awepodi. Pida niɡ̶ijo niɡ̶ipegitedio liɡ̶eladi niɡ̶ijo lacilo romaanotedi, odaa ja iiɡ̶etege icoa lokaaɡ̶etedi migotibeci odakapetege Jesus. Odaa joɡ̶oyeloɡ̶oditalo Jesus niɡ̶icoa lotaɡ̶a niɡ̶ijo lacilo romaanotedi, monee, “Ǥoniotagodi, ajemaa daɡ̶alee ɡ̶adigiwoci. Eliodi ɡ̶aniwaló, aɡ̶akaami iciagi managi anakaatiwece iɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Codaa joaniɡ̶idaa leeɡ̶odi me daɡ̶a ejigo jipokotaɡ̶awa managi deɡ̶epaa digoina. Pida okexaa eni me icí idida iotagi, odaa ja icí inioneeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Igaataɡ̶a akaami iciagi, ee aaɡ̶aɡ̶a idi anetidiiɡ̶e, codaa idiwa iniodaɡ̶awadi maɡ̶aɡ̶a jiiɡ̶e. Idatecibece ini anejita, ‘Emii’, odaaɡ̶igo. Iniaaɡ̶eledi mejita, ‘Anagi’, odaa jeɡ̶enagi. Idatecibece mejita iotagi, ‘Etidi anawii.’ Odaa jeɡ̶eo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Niɡ̶ijo Jesus naɡ̶a wajipate niɡ̶ijoa lotaɡ̶a, eliodi me yopo. Odaa naɡ̶a nawiilitetedijo, meetediogi niɡ̶ijo noiigi anodiotece, “Ejitaɡ̶awatiwaji, aniɡ̶ica oko jakapetege midi ɡ̶odoiigi Israel ane eliodi eliwaɡ̶atakaneɡ̶egi digo minitaɡ̶a niɡ̶ini ɡ̶oneleegiwa (ane daɡ̶a ɡ̶odoiigi).” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Niɡ̶ijoa liiɡ̶exedi niɡ̶ijo ane iiɡ̶e niodaɡ̶awadi romaanotedi, noɡ̶opitiobeci ane icoɡ̶oticogi. Noɡ̶otota, niɡ̶ijo niotagi ja icí. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ica noko Jesus onigo manitaɡ̶a nigotaɡ̶a Naim. Ijaaɡ̶ijo anodiotibece icaaɡ̶ica eledi noiigi-nelegi lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Odaa noɡ̶one odipegita niɡ̶ica lapoagi niɡ̶ica niwilanigi ane niotaa naɡ̶ani nigotaɡ̶a, odaa joɡ̶odakapetetege ica lapo-nelegi, anoyadeegi ica lioneeɡ̶a ane yeleo, oyadeegi monaligitini. Niɡ̶ica émeɡ̶egi onokijoteci me lionigi acoda wajekalo. Niɡ̶ica noiigi-nelegi oigaalatibece naɡ̶ajo eliodo. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Niɡ̶ijo naɡ̶a nadi Ǥoniotagodi naɡ̶ajoda wajekalo, eliodi me iwikode. Odaa jeɡ̶eeteta, “Jinaɡ̶a anoeni!” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Odaa joneɡ̶epaanaɡ̶a ipegiteta, odaa ja dibatedeloco aca iwokodaɡ̶axi. Odaa niɡ̶ijo anoyadeegi ja dabiditiniwace. Odaa jeɡ̶ee Jesus, “Lioneeɡ̶a, Ee ɡ̶adiiɡ̶eni, anicootini!” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Odaa niɡ̶ijo émeɡ̶egi jona nicotini, odaa ja dotaɡ̶a. Jesus ja yopilaɡ̶adite naɡ̶ajo eliodo. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ijotawece niɡ̶ijo oko eliodi me doitibigiwaji, odaa odoɡ̶etetalo Aneotedoɡ̶oji, modi, “Dinikeetoɡ̶owa ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, codaa niɡ̶ida eliodi nimaweneɡ̶egi. Aneotedoɡ̶oji ja dalitediogi loiigi, odaa yaxawatediogi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nibodicetedi anoditece Jesus jiɡ̶ilaagiteloco iditawece nipodigi Judéia, codaa me niɡ̶icoa nipodaɡ̶a anipegitege. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Niɡ̶ijo anodiotibeci João Batista oyeloɡ̶odita icoatawece niɡ̶icoa baaneɡ̶eote Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Odaa João eniditiogi icoa itoataale anodiotibeci, odaa ja iiɡ̶e moige Ǥoniotagodi, meetiogi, “Nigicootalo, enitalo, ‘Manigakamaɡ̶akaami icoa ane inibeoonaɡ̶atege menagi me ɡ̶odewikatidi, oɡ̶oa, domigalee inibeoonaɡ̶atege eledi oko?’” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Noɡ̶ototalo Jesus, odaa joɡ̶oige, moditalo, “Ǥoniotagodi, João Batista ɡ̶odiiɡ̶e me ɡ̶adigeeɡ̶egi manigakamaɡ̶akaami icoa ane inibeoonaɡ̶atege menagi ɡ̶odewikatidi, oɡ̶oa, domigalee inibeoonaɡ̶atege eledi oko?” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ajaaɡ̶ajo naɡ̶ajo lakata niɡ̶icotibeci niɡ̶ijoa liiɡ̶exedi João, Jesus ja icilatidi eliodi oko ane neelotikanaɡ̶a, ina anodakatiogi, codaa eote me yatetacibigiwaji ɡ̶oladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Odaa Jesus ja igiditediogi niɡ̶ijo ane iiɡ̶e João, meetediogi, “Opilitacicogi minitaɡ̶a João, odaa eloɡ̶oti niɡ̶inoa ananati, codaa anajipaatalotiwaji. Eloɡ̶oti me yatetacibigiwaji ɡ̶oladi, mewaligi ane beyagi laxace, codaa me icí dawace-loolatedi, aticilonadi ja wajipatacibigiwaji, émaɡ̶aɡ̶a newiɡ̶atace, codaa me jatemati nibodicetedi anele miditaɡ̶a madewetedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Niɡ̶ina oko ninitibece niɡ̶ina me daɡ̶a dinibolikatiditici.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Niɡ̶ijo noɡ̶opitibeci niɡ̶ijoa liiɡ̶exedi João, odaa Jesus ja yalaɡ̶ate João Batista, meetediogi niɡ̶idi noiigi, “Ijo me emiitiwaji midi nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi, amiijo anemii awinitiwaji? Domigemii mawini ɡ̶oneleegiwa ane diɡ̶ica baɡ̶a niiticogi ane liciagi niɡ̶ina naanyogo ane igike niocodi? ");
INSERT INTO kbcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amiina anemii awinitiwaji? Domigemii awini ɡ̶oneleegiwa anele me dinixo? De jeloɡ̶oditaɡ̶awatiwaji! Niɡ̶ijo anele me dinixotibigiwaji, ane diɡ̶ica ananiaditema, ane diɡ̶eladetigi diimaɡ̶a libinienaɡ̶a, liɡ̶eladi niɡ̶inoa inionaɡ̶a-eloodoli. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Enice, amiijo ica anemii awinitiwaji? Domige emii awinitiwaji niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko? Beɡ̶ewi! Jeloɡ̶oditaɡ̶awatiwaji mepeɡ̶ewi me emii awinitiwaji niɡ̶ijo ane naɡ̶axatelogo niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Igaataɡ̶a joaniɡ̶ijaa João niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, neɡ̶ee Aneotedoɡ̶oji, ‘Jiwakatee iiɡ̶exegi ɡ̶adodoe, yoetece ɡ̶aligi’. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jeloɡ̶oditaɡ̶awa, João me daɡ̶axa me ɡ̶oneɡ̶egi caticedi ijotawece niɡ̶ijo eledi anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. Pida niɡ̶ina oko iwikodaɡ̶a ane iiɡ̶e Aneotedoɡ̶oji laaleɡ̶ena, baɡ̶a daɡ̶axa me ɡ̶oneɡ̶egi caticeditace João.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Niɡ̶ina anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa me iditawece niɡ̶idi noiigi owajipatalo lotaɡ̶a Ǥoniotagodi, joaniɡ̶idiaaɡ̶idi niɡ̶ica ane nilegetiniwace João, noɡ̶owajipatalo lotaɡ̶a Jesus, odaa modi Aneotedoɡ̶oji iɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pida niɡ̶ijoa fariseutedi ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés baadoɡ̶oyemaa me nilegetiniwace João. Joaniɡ̶idaa modowocetege niɡ̶ica ane domaɡ̶a yemaa Aneotedoɡ̶oji mowo. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Odaa Ǥoniotagodi mee, “Niɡ̶ina noiigi, amiini ica ane jakadi me jiboɡ̶oditege? Natigide jeloɡ̶oditaɡ̶awatiwaji ane jiboɡ̶oditege. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Liciagi nigaanigipawaanigi ane nicotiniwace me nalooɡ̶o midi lalokaditibece. Ini lapo meeta, me dapaaweta niɡ̶ini eledi lapo, ‘Ja jatenaɡ̶atigi nateneɡ̶egi nadoneɡ̶egi, pida aɡ̶anibailetiwaji. Codaa ja domaɡ̶a jigaanaɡ̶a ica nanaagi monaligitini émeɡ̶egi, pida aɡ̶anoenitiwaji’. (Odaa niɡ̶idi nigaanigipawaanigi idioka limedi me dinotigimade.) ");
INSERT INTO kbcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Igaataɡ̶a João Batista enagi, odaa ayeligo paon, oteɡ̶exaaɡ̶aɡ̶a wacipeta viinyo. Odaa menitiwaji me dakatiogi niwigo abeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, naɡ̶aɡ̶a janagi, odaa baɡ̶a jeligo paon, codaa me jacipe viinyo. Odaa menitiwaji, ‘Digawini! Niɡ̶idoa ɡ̶oneleegiwa olade, codaa me acipeɡ̶egi. Lokaaɡ̶etedipi niɡ̶idi anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, codaa lokaaɡ̶etedipi inatawece niɡ̶ina oko anowidi libeyaceɡ̶eco!’ (Odaa ɡ̶adiciagitiwaji niɡ̶ijo nigaanigipawaanigi leeɡ̶odi midioka limedi madinotigimadenitiwaji.) ");
INSERT INTO kbcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pida niɡ̶ina oko anida liwaxinigi, baanaɡ̶a yowooɡ̶odi Aneotedoɡ̶oji me diwaxinaɡ̶a, codaa midioka limedi meo ane iɡ̶enaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ica fariseu one node Jesus migo aniodi liɡ̶eladi. Odaa Jesus jiɡ̶igo. Naɡ̶a dakatediwece liɡ̶eladi, odaa ja nicotedi maditaɡ̶a aca nameeja maniodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Manitaɡ̶a naɡ̶ani nigotaɡ̶a onani aca iwaalo agopeloa. Naɡ̶a dibodicetalo miniwatedigi Jesus liɡ̶eladi niɡ̶ijo fariseu maniodi, odaa jiɡ̶igo, yadeegi aca bootawaana wetiɡ̶a, anodita “alabastro”. Naɡ̶aca bootawaana one nolee ladokojegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Naɡ̶ajo iwaalo dabiditi lowidi Jesus micoataɡ̶a loɡ̶onaka, anoetibece. Odaa latiidi datikoletelogo loɡ̶onaka Jesus. Odaa ja yatita lamodi me iwilegi Jesus loɡ̶onaka, codaa eliodi me napicoɡ̶otedice loɡ̶onaka, ikee me diniotagodetalo. Codaa yadotelogo loɡ̶onaka niɡ̶ica ladokojegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Niɡ̶ijo fariseu ane node Jesus naɡ̶a nadi anee naɡ̶ajo iwaalo, odaa meetibige le, “Niɡ̶ina deɡ̶ewi niɡ̶iniaaɡ̶iniwa Niɡ̶icoa ane neloɡ̶oditedoɡ̶owa Aneotedoɡ̶oji lowooko, daɡ̶anagawini yowooɡ̶odi anani naɡ̶ani iwaalo ane dibatelogo, codaa taɡ̶aɡ̶a yowooɡ̶odi niɡ̶icoa ligopeloaɡ̶eco, codaa ane libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Odaa Jesus meeteta niɡ̶ijo fariseu, “Simão, domiɡ̶ida igegi.” Odaa ja igidi, meetalo, “Digageni, niiɡ̶axinaɡ̶anaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Odaa Jesus jeɡ̶eete, “Idiwa iniwataale ɡ̶oneleegiwadi onaalewe ica anidioka limedi me yajigo monadila ninyeelo. Onica ica ane dinaalewe ciinco taalia beexotedi, odaa ica eledi baɡ̶a dinaalewe meya-taalia beexotedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Niɡ̶idi iniwataale aɡ̶oyakadi moyedia niɡ̶ijoa naaleweta niɡ̶ijo ɡ̶oneleegiwa. Odaa joaniɡ̶idaa meetiogi me daɡ̶adiaa leeditibige moyedia. Natigide ɡ̶adige, amepidiɡ̶ica ijoa itoa ane daɡ̶axa me yemaa ijo ɡ̶oneleegiwa anonaalewe?” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simão ja niniɡ̶odi, meetalo, “Ejime niɡ̶ijo ane daɡ̶axa me dinaalewe jiɡ̶ijaa daɡ̶axa me demaanaɡ̶a.” Odaa Jesus meete, “Ele motaɡ̶ani!” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Odaa Jesus naɡ̶a niwiteta naɡ̶ajo iwaalo, odaa meete Simão, “Jaɡ̶anati naɡ̶ani iwaalo. Niɡ̶ijo naɡ̶a inakatiwece ɡ̶adiɡ̶eladi, aɡ̶anajicitiwa ninyoɡ̶odi me jiwilegi iɡ̶onaka. Pida baɡ̶a iwilegi iɡ̶onaka yatitalo latiidi, odaa yatita lamodi me yadilonatidi iɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Codaa niɡ̶ijo naɡ̶a janotio, aɡ̶adapiciɡ̶i me ɡ̶adecoatitici. Pida niɡ̶ijo naɡ̶a nakatio, naɡ̶ani iwaalo naɡ̶ani me napicoɡ̶otedice iɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Codaa oteɡ̶exaaɡ̶aɡ̶a adootigi najidi yacilo mikeeni moɡ̶eetetiwa, pida aniaaɡ̶ani baɡ̶a yadotelogo iɡ̶onaka ladokojegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Odaa jemaa mejitaɡ̶awa Aneotedoɡ̶oji ja iwilegi libeyaceɡ̶eco naɡ̶ani iwaalo anowidi. Odaa joaniɡ̶idaa leeɡ̶odi meliodi me idemaa. Pida niɡ̶ina oko ane daɡ̶a deemitetece me leeditibige me doletibige Aneotedoɡ̶oji me iwilegi libeyaceɡ̶eco, aɡ̶ewi me idemaa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Odaa Jesus jeɡ̶eeteta naɡ̶ajo iwaalo, “Aneotedoɡ̶oji ja napitaɡ̶adi ɡ̶abeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Niɡ̶ijo eledi oko anidiaaɡ̶i madi nameeja, dinotaɡ̶aneɡ̶etiwage, modi, “Amiiniwa icoa ɡ̶oneleegiwa anee me yakadi me napitaɡ̶adi ɡ̶obeyaceɡ̶eco?” ");
INSERT INTO kbcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Odaa Jesus jeɡ̶eeteta naɡ̶ajo iwaalo, “Aneotedoɡ̶oji ja ɡ̶adewikatiti leeɡ̶odi madinakatoni. Odaa emii opili, mele ɡ̶adaaleɡ̶ena!” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Niɡ̶idiaaɡ̶idi Jesus ja diniwiajetedicogi midiwataɡ̶a icoa nigotadi icaaɡ̶icoa nigotadawaanaɡ̶a niɡ̶idi nipodigi, yeloɡ̶oditedibece icoa nibodicetedi anele, anoneloɡ̶oditoɡ̶owa anodaaɡ̶eeteda Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶ena. Niɡ̶ijo dooze anodiotibece eledi ijo me lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Codaa onica ica iwaalepodi anaɡ̶aɡ̶a igotibeci. Jesus one iticoitedice niwigo abeyaceɡ̶egi ane dakatiogi anigepidaɡ̶aca niɡ̶ijo iwaalepodi, codaa one nicilatidi ica ane neelotikanaɡ̶a. Aca anodita Maria aneledi oyatigi me Madalena. Joanaɡ̶ajaa Jesus ane icilatidi modakatiogi seete niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Acaaɡ̶aca aca Joana lodawa ica Cuza ane dowediteloco liɡ̶eladi ica inionigi-eliodi Herodes. Codaa eledi igo aca Susana, icaaɡ̶ica eledi iwaalepodi, anoyaxawa Jesus ijaaɡ̶ijo anodiotibece, oyajigo liwai niɡ̶icoa ane nepilidi moyaxawatiogi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ica oko ane icoɡ̶oticogi inoatawece nigotadi ototalo, odaa ja dilapode niɡ̶ica noiigi-nelegi. Niɡ̶ijo naɡ̶a dilapodetibigiwaji, odaa Jesus ja yatemati ica natematigo ane ɡ̶odiiɡ̶axi, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Digawinitiwaji! Ica ɡ̶oneleegiwa onigo etanaɡ̶a. Niɡ̶ijo naɡ̶a yokoletedibece niɡ̶ijoa nolacidi, onicoa icoa ane enitedini midi naigi. Analee onipodi oko, codaa me ilaaɡ̶axodi aaɡ̶aɡ̶a oyeligo. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Icoa eletidi nolacidi one enitedini midiwa icoa wetiadawaanaɡ̶a. Odaa ja domaɡ̶a ili, pida yadilo, leeɡ̶odi ibeyacaɡ̶adi me yadilo niɡ̶ijo anei. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pida icoa eletidi boɡ̶onenite midi ica ipelakijadi. Naɡ̶a domaɡ̶a ili, pida jonaɡ̶aɡ̶a ili niɡ̶ijo ipelaɡ̶a, odaa ja yapoɡ̶oditedini. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pida onicoa icoa eletidi anenitedinigi miditaɡ̶a ica iiɡ̶o anele. Odaa boɡ̶one ili, codaa onele. One onidateci libatadi yajigo onaniteci taalia ligecidi.” Niɡ̶idiaaɡ̶idi Jesus joneɡ̶eetediogi, “Ane yemaa me wajipatalo niɡ̶inoa ane jiiɡ̶axinaɡ̶atece, enice atacolitece!” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Niɡ̶ijo anodiotibece joɡ̶oigetece Jesus niɡ̶ica ane diitigi niɡ̶ijo natematigo ane yatemati. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus igidi, meetediogi, “Aneotedoɡ̶oji baɡ̶a ikeetedaɡ̶awatiwaji anodaaɡ̶ee me iiɡ̶e oko laaleɡ̶ena, igaataɡ̶a aɡ̶ica ane yowooɡ̶odi. Odaa niɡ̶ina me jiiɡ̶axi eledi oko, baɡ̶a jatemati natematiko anida ane jiciaceeketege. Jaotibige moiwi pida aɡ̶onadi niɡ̶ica anewi, owajipata pida aɡ̶oyowooɡ̶odi ane diitigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Niɡ̶ijo natematigo ane jatemati, digawini ane diitigi. Niɡ̶ijoa lolacidi liciagi niɡ̶inoa lotaɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Niɡ̶ijoa lolacidi anenite miditaɡ̶a naigi, liciagi niɡ̶ina oko anowajipatalo lotaɡ̶a Aneotedoɡ̶oji. Pida neɡ̶enagi ɡ̶odaxakawa, odaa ja noɡ̶a niɡ̶ijoa notaɡ̶a anowajipatalo ane ideite laaleɡ̶ena. Eotibige me daɡ̶adiaa oyiwaɡ̶adi Niɡ̶ijoa ane ɡ̶odewikatidi, odaa Aneotedoɡ̶oji aɡ̶aleeɡ̶aɡ̶a eote lewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Niɡ̶ijoa lolacidi anenite midiwa wetiadawaanaɡ̶a, liciagi niɡ̶ina oko anowajipatalo Aneotedoɡ̶oji lotaɡ̶a, odaa joɡ̶odibatege codaa eliodi me ninitibigiwaji. Pida niɡ̶idi oko aɡ̶ewi niɡ̶ica eliwaɡ̶atakaneɡ̶egi. Liciagi niɡ̶inoa enanigijedi ane daɡ̶a leegitinece litodi. Odaa aleegi metiwaɡ̶ataka, neɡ̶enagi ɡ̶odaxakawa dineeta, odaa jeɡ̶eyamaɡ̶aticoace leeɡ̶odi lawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Niɡ̶ijoa lolacidi anenite miditaɡ̶a ipelakijadi, liciagi niɡ̶ina oko anowajipatalo Aneotedoɡ̶oji lotaɡ̶a, pida idokee mowo niɡ̶inoa lakataɡ̶a niɡ̶ina iiɡ̶o, codaa noɡ̶owikomataaɡ̶a, odoletibige me liicotedi, codaa odoletibige mowo niɡ̶ica anepaaɡ̶oyemaa. Joaniɡ̶idaaɡ̶ee niɡ̶ijo ipelakijadi ane doɡ̶oika me ili niɡ̶ijoa enanigijedi, metaye, liciagi eliwaɡ̶atakaneɡ̶egi niɡ̶ijo oko aili pida dinelio. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Odaa niɡ̶ijoa aneniteloco iiɡ̶o anele baɡ̶a liciagi niɡ̶ina oko anowajipatalo lotaɡ̶a Aneotedoɡ̶oji, odaa oyotete catiwedi laaleɡ̶ena. Odaa baadaɡ̶a inaale laaleɡ̶ena, pida ele. Codaa me lewiɡ̶a niɡ̶idi oko diniigi, owo niɡ̶ina ane yemaa Aneotedoɡ̶oji codaa odinatitalo lawikodico. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aɡ̶ica ini ane yalegi loledaɡ̶axi oditaɡ̶a yamaɡ̶ateloco ɡ̶inogo ane leegitinece le, migetaɡ̶a ixotiwece lipe le loledaɡ̶axi, pida ipeke loledaɡ̶axi ditibigimedi, odaa inatawece oko anodakatiwece diimigi onadi liwitiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Igaataɡ̶a inoatawece niɡ̶inoa ane dinaɡ̶aditedini, icota me jowooɡ̶otaɡ̶a, codaa inoatawece ane daɡ̶a jowooɡ̶otaɡ̶ateda, icota me jinataɡ̶a, codaa enagi manitaɡ̶a aca nilokokena Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Enice anidakitatiwaji anodaaɡ̶eni majipaatalo Aneotedoɡ̶oji lotaɡ̶a. Igaataɡ̶a niɡ̶ina baanaɡ̶a dibatege ganigidi, dibatacege caticeditace niɡ̶ijo baanaɡ̶a dibatege. Pida niɡ̶ina ane diɡ̶ica, niɡ̶ijo ane diletibige diɡ̶idi me nebi, onoɡ̶aticogi minitaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naɡ̶ajo eliodo ijaa nioxoadipi Jesus igotibeci midoataɡ̶a. Pida aɡ̶oyakadi modipegitalo, leeɡ̶odi niɡ̶idi noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Odaa joniɡ̶ica ica aneo libodigi, meetalo, “Ǥadiodo, idiaa ɡ̶anioxoadipi etidi digoida wetice niɡ̶ina diimigi. Oyemaa metiɡ̶adotaɡ̶aneɡ̶eni.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pida Jesus ja niniɡ̶odi, meeteta, “Eiodo, inioxoadipi, niɡ̶ina anowajipatalo Aneotedoɡ̶oji lotaɡ̶a, anowo ane yemaa Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ica noko Jesus ijaaɡ̶ijo anodiotibece owaxoditinigi aca niwatece, odaa mee Jesus, “Iniɡ̶a daato niɡ̶ina weiigi.” Odaa jiɡ̶igotibeci. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eɡ̶idaa diiticogi migotibeci, Jesus jona diote. Codaaɡ̶ida joneɡ̶enagi ica niwocotaɡ̶a, odaa jona nolee ninyoɡ̶odi aca niwatece. Eliodi modiitege niɡ̶ica ane doide. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Odaa niɡ̶ijo anodiotibece Jesus jonoɡ̶odipegitalo moyojietelogo, moditalo, “Ǥoniiɡ̶axinoɡ̶odi! Ǥoniiɡ̶axinoɡ̶odi! Aiwoko moko ma!” Odaa jona niwodi Jesus. Odaa ja yapeteɡ̶e niɡ̶ijo niocodi, ijaaɡ̶ijoa ebekadi, codaa iiɡ̶e me notokotiniwace. Odaa niɡ̶ijo niwocotaɡ̶a, ijaaɡ̶ijoa ebekadi ja notokotiniwace, jona watacoti. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Odaa Jesus jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Igaamee ina me daɡ̶adadiwaɡ̶atitatiwaji?” Pida eliodi moyopo, codaa doitibigiwaji, dinotaɡ̶aneɡ̶etiwage modi, “Amiidoa icoa ɡ̶oneleegiwa? Igaataɡ̶a iiɡ̶e niocodi, ebekadi me notokotiniwace, odaa jiɡ̶idaaɡ̶ee!” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Noɡ̶otota nipodigi ica noiigi gadareenotedi, daato niɡ̶idi weiigi ane dilokotege Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Naɡ̶a waxoditedice Jesus naɡ̶ajo niwatece, odaa jona dakapetege ica ɡ̶oneleegiwa anelatibige naɡ̶ani nigotaɡ̶a. Jona jotigide modakatiogi niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a. Aonaɡ̶aleeɡ̶icoa lowoodi, oteɡ̶exaaɡ̶aɡ̶aleeɡ̶ica liɡ̶eladi, pida one lotokaɡ̶adi midiwataɡ̶a icoa lawimaɡ̶ajetedi-wetiadi minitaɡ̶a ica apiiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Igaataɡ̶a niɡ̶ica niwigo abeyaceɡ̶egi elioditibece me dibata. Codaa onidatecibeci niɡ̶ica oko one oigoetece galeena libaaɡ̶atedi, loɡ̶onaka, pida idioka limedi me nakagidi. Codaa niɡ̶ijo niwigo abeyaceɡ̶egi yadeegiticobige miditaɡ̶a ica nipodigi ane yadilo ane diɡ̶ica niɡ̶eladimigipi. Niɡ̶ijo naɡ̶a naditege Jesus, odaa jona dapaawe, odaaɡ̶enitini loɡ̶onaka Jesus, odaa mee me dinigetaɡ̶atee, “Jesus, Lionigi Aneotedoɡ̶oji ane iiɡ̶e inoatawece! Amiina ica anemaanitici? Jipokotaɡ̶awa me daɡ̶adiloikatiti.” Eo niɡ̶ida ligegi, leeɡ̶odi Jesus ja iiɡ̶e me noditicoaci niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Odaa Jesus jona ige, oneete, “Igame ɡ̶aboonaɡ̶adi?” Naɡ̶a igidi, mee, “Iboonaɡ̶adi me ee, ‘Noiigi-nelegi’.” Eo niɡ̶ida ligegi leeɡ̶odi owidi niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a anodakatiogi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Odaa niɡ̶icoa niwicidi abeyacaɡ̶aɡ̶a eliodi modipokotalo Jesus me daɡ̶a iiɡ̶etedicogi midataɡ̶a libegi ane leegitinece, meote me nawikodeeɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Onini ica lapo-nelegi nigidagiwadi noxicoɡ̶onaɡ̶a odipegitege aca wetiɡ̶a. Odaa niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a odipokotalo Jesus me ika modakatiogilo niɡ̶ijoa nigidagiwadi. Odaa ja ika. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Odaa niɡ̶ijoa niwicidi abeyacaɡ̶aɡ̶a joɡ̶oika niɡ̶ijo ɡ̶oneleegiwa, odaa joɡ̶odakatiogilo nigidagiwadi. Odaa niɡ̶idiwa nigidagiwadi waleditiniwace ica elagigi, odaa joɡ̶odaxaboketinece ica weiigi, joɡ̶oceɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Niɡ̶ijo anoyowie niɡ̶ijoa nigidagiwadi noɡ̶onadi niɡ̶ida niciagi, odaa joɡ̶odeleta naɡ̶ani nigotaɡ̶a, codaa me bajeendatedi, oyatemati niɡ̶ida niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eliodi oko igotibeci oiwi niɡ̶ica niciagi. Noɡ̶odipegitalo Jesus, odaa joɡ̶onadi niɡ̶ijo ane icilatidi modakatiogi niwicidi abeyacaɡ̶aɡ̶a, odaa eliodi me doitibigiwaji, leeɡ̶odi niɡ̶ijo ɡ̶oneleegiwa ini me nicoti micoataɡ̶a Jesus loɡ̶onaka, joniɡ̶idoa lowoodi, codaa aɡ̶aleeɡ̶icoa niɡ̶ijoa lowooko yetoledi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Niɡ̶ica anonadi niɡ̶ida niciagi, oyatematitiogi niɡ̶idi noiigi ica anodaaɡ̶ee noɡ̶oicilatidi niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Odaa iditawece noiigi ane niɡ̶eladimigipitigi nipodigi icoa gadareenotedi odipokotalo Jesus me noditedice nipodigi, igaataɡ̶a one eliodi me doitibigiwaji. Odaa jonoɡ̶owaxoditacinigi aca niwatece, odaa joɡ̶opitacicogi daato weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Niɡ̶ijo Jesus naɡ̶a nipegi me dawace liwatece, odaa niɡ̶ijo ɡ̶oneleegiwa ane icilatidi eliodi me dipokotibigalo migo diotece. Pida Jesus naɡ̶a ibode, meeteta, ");
INSERT INTO kbcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Emii opiliticogi ɡ̶adiɡ̶eladi, odaaɡ̶atematii niɡ̶ica anigotedaɡ̶awa Aneotedoɡ̶oji.” Niɡ̶idiaaɡ̶idi niɡ̶ijo ɡ̶oneleegiwa jiɡ̶igoteloco anitawece nigotaɡ̶a, yatematitibece niɡ̶ica anigote Jesus lewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Niɡ̶ijo Jesus niɡ̶icotacedicogi daato weiigi, ica noiigi ele modibatege, codaa ninitibigiwaji leeɡ̶odi ijotawece akaaɡ̶onibeotibigege. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Joniɡ̶igo dakapetege Jesus ica ɡ̶oneleegiwa anodita Jairo. Joniɡ̶ijaa dowediteloco liiakanaɡ̶axi judeutedi manitaɡ̶a naɡ̶ani nigotaɡ̶a. Naɡ̶a yamaɡ̶atedini lokotidi lodoe Jesus, odaa ja dipokotalo migo liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Leeɡ̶odi Jairo onajoteci me liona, onaleekeote dooze nicaaɡ̶ape, pida eliodi me deelotika, jona doletibige me yeleo. Odaa Jesus jiɡ̶igo, pida niɡ̶ica noiigi joɡ̶odiniligicetelogo. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Odaa ja dakapetetege aca iwaalo awodina. Joneɡ̶eote dooze nicaaɡ̶ape me deelotika, codaa jona yaaɡ̶adi icoatawece niɡ̶icoa ane nepilidi me yedia dotowexedi. Pida aɡ̶ica ane yakadi me icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Odaa naɡ̶ajo iwaalo jona nowidila Jesus, odaa dibatigi laxabi nijayogo, odaa jona wakagitege lawodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Odaa Jesus ja digika, onee, “Amiijo ane dibatiloco?” Pida niɡ̶ijo noiigi modi me diɡ̶ica ane dibatelogo. Odaa Pedro meetalo, “Ǥoniiɡ̶axinoɡ̶odi, inatawece niɡ̶ina noiigi etiɡ̶adawiileni, codaa metiɡ̶adiligiceni.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pida Jesus mee, “Oɡ̶oa ijo ica ane dibatiloco, igaataɡ̶a jeemitetece me noditice yoniciwaɡ̶a ane ɡ̶odicilatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naɡ̶ajo iwaalo naɡ̶a nadi me daɡ̶adiaa yakadi me yaɡ̶aditi niɡ̶ijo loenatagi, odaa joniɡ̶igo dawigicetijo, yamaɡ̶atedini lokotidi lodoe Jesus. Codaa yatemati lodoe ijotawece niɡ̶ijo noiigi ane leeɡ̶odi me dibatelogo Jesus, codaa yatemati niɡ̶ica me daɡ̶a leegi odaa ja icí me awodina. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Odaa Jesus meeteta, “Iona, ja ɡ̶adicili leeɡ̶odi madadiwaɡ̶ati. Emiita opili, mele ɡ̶adaaleɡ̶ena!” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eɡ̶idaaɡ̶eeteda Jesus me dotaɡ̶atedibece, joniɡ̶ica ica ane icoɡ̶oticogi liɡ̶eladi Jairo, niɡ̶ijo ane dowediteloco niiakanaɡ̶axi, odaa jeɡ̶eeta, “Ǥadiona ja yeleo. Jinaɡ̶aleeɡ̶anigiwoci Ǥoniiɡ̶axinoɡ̶odi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Naɡ̶a wajipate Jesus niɡ̶ijoa lotaɡ̶a, odaa jeɡ̶eeteta Jairo, “Jinaɡ̶adoii! Biɡ̶ida adinakatoni, odaa jeɡ̶eletace ɡ̶adiona.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Niɡ̶icotediwece diimigi, aɡ̶ica ane ikatedio me dakatio, pida ijokijo Pedro, Tiago, ijaa João, ijaaɡ̶ijo eliododipi naɡ̶ajo nigaanawaana baɡ̶a ikatediobece me dakatiobece. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ijotawece niɡ̶ijo oko nacaagaɡ̶ateloco, codaa me notaɡ̶anaɡ̶ateloco leeɡ̶odi naɡ̶ajo nigaanawaana. Odaa Jesus meetediogi, “Jinaɡ̶acaagetibecetiwaji! Naɡ̶adi nigaanawaana ayeleo, pida diote.” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Odaa jonoɡ̶oyame, igaataɡ̶a oyowooɡ̶odi neɡ̶ewi me yeleo naɡ̶ajo nigaanawaana. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Odaa ja imonyatedicoace me noditicoaci, odaa naɡ̶a dibatedigi libaaɡ̶adi naɡ̶ajo nigaanawaana, odaa jeɡ̶ee niɡ̶ina me dinigetaɡ̶atee, “Nigaanawaana, anicootini!” ");
INSERT INTO kbcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Odaa niɡ̶ica liwigo jonaɡ̶a dopiteloco, aoniɡ̶ica ica daɡ̶a leegi jona nicoti. Odaa Jesus ja diiɡ̶enatakate mowo liweenigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Niɡ̶ijo eliododipi eliodi moyopo. Odaa Jesus ja yajoi me doɡ̶oyatematitibece niɡ̶ida niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus eniditediogi niɡ̶ijo dooze anodiotibece me dinatecoɡ̶otee, odaa yajigotediogi ica loniciwaɡ̶a codaa me naɡ̶atetigi moiticoitedice inoatawece ane niwicidi abeyacaɡ̶aɡ̶a, codaa moicilatidi eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Odaa ja iiɡ̶etediogi moyeloɡ̶odi anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko, codaa moicilatidi eelotaginadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Odaa jeɡ̶eetediogi, “Jiniɡ̶ica ananibaatinetiwaji maniwiaje. Jinaɡ̶adeegi ɡ̶agiilaɡ̶adi, oteɡ̶exaaɡ̶aɡ̶a ɡ̶adowoodaɡ̶axi, niweenigi, dinyeelo, oteɡ̶exaaɡ̶aɡ̶a eledi ɡ̶anoecaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Adeoni minitaɡ̶a diimigi anele modibataɡ̶agitiwaji, nigepaa limedi manotitice naɡ̶ani nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Odaa nigaca nigotaɡ̶a anicootatiwaji ane deɡ̶ele modibataɡ̶agitiwaji niɡ̶eladimigipi, odaa niganotiticetiwaji naɡ̶ani nigotaɡ̶a, iticiɡ̶i lamoɡ̶o ɡ̶adoɡ̶onaka, amaleeɡ̶aɡ̶a ikeeni Aneotedoɡ̶oji me yelatetema niɡ̶idi niɡ̶eladimigipi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Odaa jiɡ̶igotibeci niɡ̶ijo anodiotibece odigotece icoatawece niɡ̶icoa nigotadawaanaɡ̶a, oyeloɡ̶oditedibece nibodicetedi anele, codaa oicilatidi eelotaginadi niɡ̶ica anodigotece. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes ane ninionigi-eliodi niɡ̶ica nipodigi dibodicetalo icoatawece niɡ̶icoa Jesus loenataka. Odaa eliodi me doɡ̶owikomata, aɡ̶aleeɡ̶ica baɡ̶a lowoogo, leeɡ̶odi onica ica anodi Jesus me João Batista naɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ica eledi modi mone Elias, naɡ̶a dinikeetaci, odaa ica eledi onodi Jesus minaaɡ̶ina niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, baanaɡ̶a yeleo anokaanaɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Odaa Herodes mee, “Jeɡ̶emaɡ̶a jiiɡ̶enatakata moyakagidi lacilo João. Enice, amiida ica ɡ̶oneleegiwa? Igaataɡ̶a jibodicetalo niɡ̶icoa loenataka.” Odaa Herodes ja doletibige nimaweneɡ̶egi me nadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Naɡ̶a dopitijo niɡ̶ijo liiɡ̶exedipi, odaa joɡ̶oyeloɡ̶oditalo Jesus icoatawece niɡ̶icoa ane loenataka. Odaa ja yadeegi igotibeci manitaɡ̶a aca nigotakawaana ane liboonaɡ̶adi Betsaida, ijokijo niɡ̶ijo anodiotibece me yadeegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pida niɡ̶ijo noiigi noɡ̶oyowooɡ̶odi ane diitedicogi Jesus, odaa joɡ̶oigaalatece. Odaa ja dibatetege Jesus, yatematitediogi anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali, codaa icilatidi niɡ̶ijo ane neelotikanaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Niɡ̶ijo naɡ̶a ɡ̶ocidi, niɡ̶ijo dooze anodiotibece Jesus jiɡ̶igotibeci midoataɡ̶a, odaa moditalo, “Jeɡ̶ele me iiɡ̶eni mopitibeci niɡ̶ina noiigi, amaleeɡ̶aɡ̶a igotibeci minoataɡ̶a niɡ̶inoa nigotadawaanaɡ̶a, bajeendatedi, odoletibige niɡ̶ica aniwote, codaa amaleeɡ̶aɡ̶a oyakadi anoyeligo. Igaataɡ̶a niɡ̶ina anejonaɡ̶a yadilo, aɡ̶ica niɡ̶eladimigipi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pida Jesus naɡ̶a igidi, meetediogi, “Akamaɡ̶akaamitiwaji, ajicitiogi ane yeligo!” Odaa modi, “Aɡ̶icoda ɡ̶oweenigi, idiwa mina ciinco paontedi, idiaaɡ̶idioda itiwataale noɡ̶ojedi. Ajakataɡ̶a daɡ̶a jajicaɡ̶atiogi anoyeligo, ajiboɡ̶otege me jinoojeteeɡ̶atibige niweenigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Owo niɡ̶ida ligegi, leeɡ̶odi jona domaɡ̶a iwida ciinco miili ɡ̶oneleegiwadi (we nigaanigipawaanigi codaa me iwaalepodi). Odaa Jesus oneetediogi niɡ̶ijo anodiotibece, “Iiɡ̶eni me nicotiniwace niɡ̶idi noiigi, mowo lapotibece meya-taaliatibece oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Niɡ̶ijo anodiotibece jiɡ̶idaaɡ̶ee, joɡ̶oiiɡ̶e niɡ̶ijo noiigi me nicotiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Odaa Jesus ja dibate niɡ̶ijoa ciinco paontedi ijaaɡ̶ijoa itiwataale noɡ̶ojedi. Naɡ̶a iwitedibigimece ditibigimedi, odaa ja diniotagodete Aneotedoɡ̶oji leeɡ̶odi niweenigi. Niɡ̶idiaaɡ̶idi ja ninoketedini niɡ̶ijoa paontedi, ijaaɡ̶ijoa noɡ̶ojedi. Odaa ja yajigotediogi niɡ̶ijo anodiotibece monediatiniwace niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ijotawece niodaɡ̶a, codaa nitiminaɡ̶a. Odaa niɡ̶ijo anodiotibece joɡ̶oyetigilo dooze etacanitedi niɡ̶icoa liwailidi ane iiɡ̶otedice. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ica noko one oniniwatece Jesus, yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Odaa jonoɡ̶ototalo niɡ̶ijo anodiotibece. Odaa jonaɡ̶a nigetediniwace, meetediogi, “Amiijo anodi me Ee, ina noiigi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Odaa joɡ̶oigidi, moditalo, “Initecibece oko modi makaami João Batista. Pida ina eledi modi makaami Elias. Codaa ina eledi modi makaami anigepidiɡ̶ica niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko jotigide, anokaanaɡ̶a yewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Odaa ja nigetediniwace, meetediogi, “Biɡ̶ida makaamitiwaji, ame Ee me enitiwaji?” Odaa Pedro ja igidi, meetalo, “Oko baɡ̶a jowooɡ̶otaɡ̶a naɡ̶akamaɡ̶akaami ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Odaa Jesus ja yajoi me doɡ̶oyatematitibece niɡ̶iniaaɡ̶iniwa Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Odaa meetediogi, “Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, leeditibige meliodi me jawikode. Odibatigi, niɡ̶ina anoiiɡ̶e ɡ̶odoiigi, codaa me niɡ̶idi anoiiɡ̶e sacerdotitedi, idiaaɡ̶idi niɡ̶idi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Codaa etideloadi, pida nigicotalo itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Odaa Jesus jeɡ̶eetediogi ijotawece, “Nigica ane yemaa me niotici, leeditibige me daɡ̶a doletibige niɡ̶ica anepaa yemaa, codaa leeditibige me igotema me dawikode codaa me yeleo, inoatawece nokododi. Odaa ja yakadi me niotici. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Igaataɡ̶a niɡ̶ina ane yemaa lakataɡ̶a niɡ̶ina oko digoina iiɡ̶o, yeleo nigidiaaɡ̶idi. Pida niɡ̶ina ane yeleo Ee leeɡ̶odi, biɡ̶icota noko me yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Codaa niɡ̶ina oko daɡ̶a dinigaanyetece niɡ̶inoa aninoa digoina iiɡ̶o, nige yeleo, Aneotedoɡ̶oji iloikatidi, codaa aɡ̶aleeɡ̶ica niwaló, jaɡ̶aniatagigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Igaataɡ̶a niɡ̶ina oko nige dinibolikatiditici, codaa me yotaɡ̶a, odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, aaɡ̶aɡ̶a idinibolikatiditece nige janagi inadeegi yoniciwaɡ̶a, codaa nige jatale iciagi miniwataɡ̶a Eiodi me datale, codaa iciaco me datale aanjotedi ane idioka limedi modibatema. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ejitaɡ̶awatiwaji mewi mina oko digoina anaɡ̶a nigo, nigonadi Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Niɡ̶idiaaɡ̶idi ejinaɡ̶a ixomaɡ̶atedice oito nokododi me yeloɡ̶odi Jesus niɡ̶ijoa lotaɡ̶a, odaa ja yadeegi me lixigaɡ̶awepodi Pedro, João, ijaa Tiago. Odaa ja dalaɡ̶atetedibigimece aca wetiɡ̶a ane leegitibigimece, igo me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eɡ̶idaa diitigi me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji jona diniigi anodaaɡ̶ee latobi, lowoodi jonaɡ̶aɡ̶a yapacaɡ̶a, codaa me datale. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Codaaɡ̶ida icoa itoa ɡ̶oneleegiwadi naɡ̶a dinikeetibigiwaji, odaa joɡ̶oyotaɡ̶aneɡ̶e Jesus. Niɡ̶idoa itoa ɡ̶oneleegiwadi one Moisés, ijaa Elias. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Niɡ̶idoa itoa aaɡ̶aɡ̶a dataletibigiwaji. Odaa joɡ̶oyotaɡ̶aneɡ̶etibigo Jesus, oyalaɡ̶ata ica lemeɡ̶egi ane nibikota Aneotedoɡ̶oji micota digoida Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ijaaɡ̶ijoa niɡ̶ijoa lokaaɡ̶etedi jonaɡ̶a nibaciɡ̶a, odaa ja niotaɡ̶a. Pida naɡ̶a niwoditibigiwaji, odaa joɡ̶onadi Jesus me datale, ijaaɡ̶ijoa itoataale ɡ̶oneleegiwadi midoataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Niɡ̶ijo naɡ̶a nipegi mopitibeci niɡ̶idiwa itoataale ɡ̶oneleegiwadi, Pedro meetalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, niɡ̶ica mele minaaɡ̶ejonaɡ̶a! Jaoɡ̶ate iniwatadiɡ̶ini ɡ̶adopecetiiditiwaji, oniniteci ɡ̶anebi, ini eledi Moisés, iniaaɡ̶eledi Elias.” Eo niɡ̶ida ligegi, pida ayowooɡ̶odi niɡ̶ica ane diitigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro eɡ̶idaaɡ̶ee me dotaɡ̶a, naɡ̶a dinikatiogi ica lolaadi, odaa ja yapoɡ̶oditiniwace. Niɡ̶ijo anodiotibece Jesus doitibigiwaji niɡ̶ijo naɡ̶a nowicetiogi niɡ̶ijo lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Odaa joɡ̶owajipata ica ane dotaɡ̶a catiwedi niɡ̶ijo lolaadi, onee, “Niɡ̶idoa, jiɡ̶idaaɡ̶idoa Ionigi aneliodi me jemaa. Ajipaata ane ligegi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Niɡ̶ijo naɡ̶a nigotini ica ane dotaɡ̶a, niɡ̶ijo anodiotibece Jesus joɡ̶onadi mokaaniɡ̶idoatece. Odaa ja notokotiniwace, odaa niɡ̶ijoa nokododi aɡ̶ica anoyeloɡ̶odi niɡ̶ijo anonadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Neɡ̶eledi noko ja daxoditiniwace me idei ditibigimedi wetiɡ̶a. Odaa ica noiigi-nelegi jiɡ̶igotibeci odakapetege Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Odaa onica ica ɡ̶oneleegiwa ane idei liwigotigi niɡ̶idi noiigi, onee me dinigetaɡ̶atee, “Ǥoniiɡ̶axinoɡ̶odi, jipokotaɡ̶awa managi icilatiti ionigi, igaataɡ̶a onididateci me ionigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Niwigo abeyaceɡ̶egi ane dakatiogi, niɡ̶ina me dibata, odaa eo me codaaɡ̶idata naɡ̶a dapaawe, dinawigice niɡ̶ica niwigo, natiamaɡ̶aditigi nioladi niɡ̶idi nigaanigi. Niɡ̶ica niwigo abeyaceɡ̶egi idioka limedi me yawigice, ayemaa me noditice. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja domaɡ̶a jipokotiogi niɡ̶idi anodiotibigaɡ̶adici moiticoitice niwigo abeyaceɡ̶egi, pida aɡ̶oyakadi moiticoitice.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus naɡ̶a dotaɡ̶a, mee, “Akaami oko ane daɡ̶a adinakatonitiwaji, akaami abeyacaɡ̶aɡ̶a. Aɡ̶aleeɡ̶owidi nokododi minaaɡ̶ejo makaamitaɡ̶atiwaji. Amigida ica noko nige daɡ̶adiaa jakadi me idinatitaɡ̶awatiwaji?” Odaa joneɡ̶eete niɡ̶ijo ɡ̶oneleegiwa, “Anadeegi ɡ̶adionigi digoina meetaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Niɡ̶ica naɡ̶a yadeegi niɡ̶ijo nigaanigawaanigi, niwigo abeyaceɡ̶egi jona yokoletinigi iiɡ̶o, codaa me yawigice. Pida Jesus ja iiɡ̶e me noditice niɡ̶ijo niwigo abeyaceɡ̶egi, odaa ja icilatidi niɡ̶ijo nigaanigawaanigi. Odaa ja yopilaɡ̶adite niɡ̶ijo eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ijotawece niɡ̶ijo oko eliodi moyopo, leeɡ̶odi me nelegi niɡ̶ica notoetiigi Aneotedoɡ̶oji. Eɡ̶idaaɡ̶ee modoxicetema niɡ̶ijoa loenataka Jesus, neɡ̶eetediogi niɡ̶ijo anodiotibece, ");
INSERT INTO kbcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Digatacolitece yotaɡ̶ataɡ̶awatiwaji. Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, etidajigota loniciwaɡ̶a ɡ̶oneleegiwadi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pida niɡ̶ijo anodiotibece aɡ̶oyowooɡ̶oditece niɡ̶ijoa lotaɡ̶a, leeɡ̶odi Aneotedoɡ̶oji aneɡ̶eote moyowooɡ̶odi. Odaa joaniɡ̶idaa leeɡ̶odi me doɡ̶oyowooɡ̶odi niɡ̶ica ane diitigi niɡ̶ijoa Jesus lotaɡ̶a. Pida odoitalo doɡ̶oigetece niɡ̶ica ane diitigilo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Niɡ̶ijo anodiotibece Jesus jonoɡ̶odinotigimadetigi niɡ̶ica ane daɡ̶axa me diniwaloe. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pida Jesus yowooɡ̶odi niɡ̶ica anoyowo catiwedi laaleɡ̶enali. Odaa jona dibate ica nigaanigawaanigi. Naɡ̶a nicooɡ̶ete liwai, ");
INSERT INTO kbcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Odaa jeɡ̶eetediogi, “Niɡ̶ina ane dibatege niɡ̶ini nigaanigawaanigi, leeɡ̶odi naɡ̶atetigi Iboonaɡ̶adi, niɡ̶ini dibatigi. Odaa niɡ̶ini ane dibatigi, aaɡ̶aɡ̶a dibatege ane idiiɡ̶e. Igaataɡ̶a niɡ̶ina ane daɡ̶axa me iwikodaɡ̶a ɡ̶adiwigotigitiwaji, joaniɡ̶iniaa daɡ̶axa mida niwaló.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Odaa João oneetalo, “Ǥoniiɡ̶axinoɡ̶odi, jinataɡ̶a ijo ɡ̶oneleegiwa ane iticoitedice niwicidi abeyacaɡ̶aɡ̶a datika Ǥaboonaɡ̶adi. Odaa ja joxokojoɡ̶o me iticoitedice niwicidi abeyacaɡ̶aɡ̶a, igaataɡ̶a adiotibigaɡ̶adici digo anejinaɡ̶a me jiwaɡ̶ataɡ̶adici.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pida Jesus meeteta, “Igaamee ina moxoki? Igaataɡ̶a niɡ̶ina ane daɡ̶a ɡ̶odakapetegi, ɡ̶odicaajo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Naɡ̶a nipegi niɡ̶ica noko Jesus mopitedibigimece ditibigimedi, odaa ja lowoogo mewi migo Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Joneɡ̶eote lienigipi migotibeci odoe. Odaa niɡ̶igotibeci joɡ̶odakatiwece aca nigotakawaana samaritaanotedi, domoɡ̶odoletibige ane lotokaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pida niɡ̶ijo niɡ̶eladimigipi aɡ̶odibatege Jesus, leeɡ̶odi moyowooɡ̶odi me lowoogo migo Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Niɡ̶ijo anodiotibece Jesus, Tiago ijaa João noɡ̶onadi me doɡ̶odibatege, odaa modi, “Ǥoniotagodi, emaani me jiiɡ̶enaɡ̶a me dinikatini noledi icoɡ̶otibigimece ditibigimedi me yaaɡ̶adi niɡ̶idi noiigi, anee Elias niɡ̶ijo jotigide?” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pida Jesus naɡ̶a nawiilitetege, odaa ja napeteɡ̶etediniwace, meetediogi, “Niɡ̶ida makaamitiwaji aɡ̶owooɡ̶oti anodaaɡ̶eni. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ajanagi me jaaɡ̶adi oko, pida janagi me jao lewiɡ̶a.” Odaa joniɡ̶igotibeci manitaɡ̶a aca eledi nigotakawaana. ");
INSERT INTO kbcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Niɡ̶ijo Jesus naɡ̶a ideite naigitinece ijaaɡ̶ijo anodiotibece, ica ɡ̶oneleegiwa oneetalo Jesus, “Iniotagodi, jemaa me jiotaɡ̶adici okanicodaaɡ̶ica anemaani me aaticogi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Odaa Jesus jeɡ̶eeteta, “Naɡ̶ana eti ida epaa libegi, codaa me ilaaɡ̶axodi ani epaa libato. Pida Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, baadiɡ̶icanejo me inipetini.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Odaa Jesus oneete ica eledi ɡ̶oneleegiwa, “Anagi aniwitibici!” Pida onee, “Iniotagodi, ecoɡ̶otace ejigo iɡ̶eladi, inaligitini eiodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Odaa Jesus jeɡ̶eete, “Ikani niɡ̶ina ane liciagi émeɡ̶egi me naligitini némeɡ̶egi. Pida akaami baanaɡ̶a akamaɡ̶a emii, eloɡ̶oti anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e oko laaleɡ̶enali.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Odaa ica eledi ɡ̶oneleegiwa oneetalo Jesus, “Iniotagodi, ee ejigo jiotaɡ̶adici, pida ecoɡ̶otace ejigo jibodenaɡ̶a digoida iɡ̶eladi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pida Jesus naɡ̶a igidi meeteta, “Niɡ̶ina ane gela me yabooɡ̶odi iiɡ̶o, odaa niwiticogi lowidi, Aneotedoɡ̶oji ayakadi daɡ̶a yajigote me libakedi me yeloɡ̶oditibece anodaaɡ̶ee me iiɡ̶e laaleɡ̶enali oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Niɡ̶idiaaɡ̶idi Ǥoniotagodi Jesus naɡ̶a igiditediogi niɡ̶ijoa ɡ̶oneleegiwadi anodi moyemaa modiotibece, odaa ja iomaɡ̶aditedice eletidi seteenta ɡ̶oneleegiwadi. Odaa ja imonya itoataaletibece migotibeci dinewadetibigiwaji, midiwataɡ̶a nigotadi, codaa me midiwataɡ̶a icoa nigotadawaanaɡ̶a ane lowoogo Jesus migotetece. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Odaa meetediogi, “Eliodi oko anonibeotege mowajipatalo nibodicetedi anele, micataɡ̶a niɡ̶ina nixoɡ̶otagi nelegi baanaɡ̶a limedi monopilaɡ̶aditedio nawodigijedi, pida aɡ̶eliodi ane nibaaɡ̶a. Joaniɡ̶idaa leeɡ̶odi ipokitalo Aneotedoɡ̶oji me niwakatee eletidi liotaka. Micataɡ̶a niɡ̶ina ane nebi nixoɡ̶otagi me iiɡ̶e niɡ̶inoa eletidi liotaka me naxawanatakanaɡ̶a monopilaɡ̶aditedio lawodigijedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Emiitiwaji! Ǥadiiɡ̶eni micoataɡ̶a niɡ̶inoa waxacocoli miditaɡ̶a noiigi ane liciagi diwilecoɡ̶oni. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jinaɡ̶adeegi ɡ̶aninyeelaɡ̶axi, oteɡ̶exaaɡ̶aɡ̶a ɡ̶aniboco ane nolee niweenigi, migetaɡ̶a eletidi ɡ̶awelatedi. Codaa jiniɡ̶ica ananicenitiwaji oko ɡ̶adakapetegitinece naigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nigakaatiwece diimigi, odoejegi ane alitigi ɡ̶agegi, eni, ‘Jemaanaɡ̶a Aneotedoɡ̶oji meote mele ɡ̶adaaleɡ̶enali akaamitawecetiwaji ane ɡ̶adiɡ̶eladi niɡ̶ina diimigi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nigica oko anoyemaa Aneotedoɡ̶oji meote mele laaleɡ̶ena, odaa Aneotedoɡ̶oji ibinie ane ɡ̶adipoketegi. Pida nige diɡ̶ica ane yemaa Aneotedoɡ̶oji meote mele laaleɡ̶ena, odaa Aneotedoɡ̶oji aibinie niɡ̶ica niɡ̶eladimigipi, ane domaɡ̶a ɡ̶adipoketegiteloco. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Idiaaɡ̶onitetiwaji minitaɡ̶a niɡ̶ini diimigi, odaa elici anoyajigotaɡ̶awatiwaji. Igaataɡ̶a iɡ̶enaɡ̶a niɡ̶ina nibakecajo me dibatege nigaanyeɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Codaa niɡ̶ina nigakaatiwecetiwaji nigotaɡ̶a, odaa nigele modibataɡ̶agi, elici niɡ̶ica anoyajigotaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Icilatititiwaji eelotaginaditigi naɡ̶ani nigotaɡ̶a, codaa enitiogi niɡ̶idi niɡ̶eladimigipitigi naɡ̶ani nigotaɡ̶a, ‘Aneotedoɡ̶oji ja igo me iiɡ̶e laaleɡ̶enali noiigitigi naɡ̶ana nigotaɡ̶a’. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pida nigakaatiwece nigotaɡ̶a ane deɡ̶ele modibataɡ̶agi, emiitelogo ladicotiidi, odaa enitiwaji, ");
INSERT INTO kbcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Niɡ̶ina amoɡ̶otigi naɡ̶ana nigotaɡ̶a ane yexogotece ɡ̶odoɡ̶onaka, jiticoɡ̶ojoɡ̶o amaleeɡ̶aɡ̶a jikeenaɡ̶ataɡ̶awatiwaji me yelatedaɡ̶adomi Aneotedoɡ̶oji. Domaɡ̶a jemaanaɡ̶a mowooɡ̶otitiwaji naɡ̶a igo Aneotedoɡ̶oji me iiɡ̶e ɡ̶adaaleɡ̶enalitiwaji, pida aɡ̶emaanitiwaji.’” Odaa Jesus meetediogi niɡ̶ijoa seteenta liiɡ̶exedi, ");
INSERT INTO kbcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ejitaɡ̶awatiwaji, Aneotedoɡ̶oji daɡ̶axa meote me nawikodeeɡ̶a niɡ̶ijo niɡ̶eladimigipitigi naɡ̶ani nigotaɡ̶a ane deɡ̶ele modibataɡ̶agi, caticedi niɡ̶ijo oko niɡ̶eladimigipitigi nigotaɡ̶a Sodoma, ane yaaɡ̶adi Aneotedoɡ̶oji niɡ̶ijo jotigide. Eliodi me nawikodeeɡ̶a niɡ̶idi oko ane deɡ̶ele modibataɡ̶agi niɡ̶ica noko nige limedi me iloikatidi Aneotedoɡ̶oji niɡ̶ina noiigi leeɡ̶odi libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesus idokee me niiɡ̶axitediniwace niɡ̶idi oko, odaa meetediogi, “Akaamitiwaji ane ɡ̶adiɡ̶eladi Corazim, icota meliodi mawikodeetiwaji. Codaa akaamitiwaji ane ɡ̶adiɡ̶eladi Betsaida aaɡ̶aɡ̶a icota meliodi mawikodeetiwaji, leeɡ̶odi me daɡ̶a adadiwaɡ̶ati. Igaataɡ̶a niɡ̶ijoa ɡ̶odoxiceɡ̶etedi aneote Aneotedoɡ̶oji mani ɡ̶anigotaɡ̶atiwaji, deɡ̶eote mijoataɡ̶a nigotadi Tiro aniaa Sidom, noiigitigi niɡ̶ijoa nigotadi toɡ̶oika mowo ane beyagi niɡ̶ijo jotigide. Taɡ̶a nicotiniwace, odinixotinigilo lowoodi jaacogoli, codaa toɡ̶oyatita lojienigi lacilodi, moikee modinilaatece libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pida niɡ̶ica noko nige iloikatidi Aneotedoɡ̶oji niɡ̶ina oko leeɡ̶odi libeyaceɡ̶eco, ɡ̶adiloikatititetiwaji caticedi niɡ̶idi niɡ̶eladimigipitigi Tiro aniaa Sidom. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Odaa akaami noiigitigi Cafarnaum, domige ɡ̶adiweniɡ̶ideni Aneotedoɡ̶oji digoida ditibigimedi? Oteɡ̶exaaɡ̶aɡ̶a onateciɡ̶ini! Pida baɡ̶a ɡ̶adokolenitediogi minitaɡ̶a noledi ane daɡ̶a ipe, mawikodeetiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Odaa Jesus jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Niɡ̶ina ane wajipataɡ̶awatiwaji, aaɡ̶aɡ̶a najipatiwa. Codaa niɡ̶ina ane daɡ̶a dibataɡ̶agitiwaji, Ee idaaɡ̶igotiwa. Odaa niɡ̶ina ane daɡ̶a dibatigi, adibatege Aneotedoɡ̶oji ane idiiɡ̶e.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Niɡ̶ijoa seteenta liiɡ̶exedi naɡ̶a dopitijo, odaa eliodi me ninitibigiwaji. Odaa moditalo Jesus, “Ǥoniotagodi, codaa me niɡ̶inoa niwicidi abeyacaɡ̶aɡ̶a etiɡ̶odadiwaɡ̶adi niɡ̶ina me jiticodaɡ̶aticoace, jibakenaɡ̶a Ǥaboonaɡ̶adi me jiticodaɡ̶aticoace modakatiogi oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pida Jesus naɡ̶a igidi, meetediogi, “Jinadi ɡ̶odaxakawa Satanás yediiɡ̶a menitini icoɡ̶otibigimece ditibigimedi, micataɡ̶a niɡ̶ina nalebepaɡ̶a ane yediiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Diganajipaatiwatiwaji! Ja jajigotaɡ̶awa ɡ̶animaweneɡ̶egi me ipoditeloco lakeedi, codaa me nelá. (Odaa aɡ̶ica anigotaɡ̶awa.) Codaa aɡ̶ekeni icatawece niɡ̶ica domaɡ̶a loniciwaɡ̶a ɡ̶odaxakawa, odaa aɡ̶ica anigotaɡ̶awatiwaji niɡ̶ina ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pida jinaɡ̶a aniniitibecitiwaji leeɡ̶odi metiɡ̶adadiwaɡ̶ati niwicidi abeyacaɡ̶aɡ̶a. Pida jemaa maniniitibeci leeɡ̶odi naɡ̶a iditedini Aneotedoɡ̶oji ɡ̶aboonaɡ̶atedi digoida ditibigimedi madi lotaɡ̶anaɡ̶axi aneite liboonaɡ̶atedi loiigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naɡ̶ajo lakata Liwigo Aneotedoɡ̶oji eo niɡ̶ica meliodi me ninitedibece Jesus. Odaa mee, “Eiodi, jaɡ̶akamaɡ̶akaami ane iiɡ̶eni ditibigimedi, codaa me iiɡ̶o, joɡ̶etetibigimaɡ̶adici, leeɡ̶odi jiɡ̶ikeenitiogi niɡ̶ina oko iwikodadi niɡ̶ica anaɡ̶atitema niɡ̶ina oko aninoa lixaketedi, codaa me niɡ̶ina aneliodi me nidikonaɡ̶a. Joaniɡ̶idaa anakamaɡ̶a emaani mawii, odaa ica mele. Joaniɡ̶idaa leeɡ̶odi me iniotagodetaɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Odaa Jesus meetediogi niɡ̶ijo oko anidi miniwataɡ̶a, “Eiodi najigotediwa inoatawece. Aɡ̶ica ane yowooɡ̶odi Aneotedoɡ̶oji Lionigi, iniokiniwateda Eliodi. Aɡ̶ica ane yowooɡ̶odi niɡ̶icoa Eliodi, iniokiniwateda Lionigi me yowooɡ̶odi, codaa niɡ̶ina ane yemaa Lionigi me ikeete anodaaɡ̶eeteda Eliodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Odaa Jesus ja nawiilitetetege niɡ̶ijo anodiotibece. Odaa meetediogi niɡ̶ica midiokiditiwage, “Ninitibigiwaji niɡ̶ina oko anonadi niɡ̶inoa ananatitiwaji! ");
INSERT INTO kbcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Igaataɡ̶a ejitaɡ̶awatiwaji, niɡ̶ijo jotigide eliodi niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, codaa owidi inionaɡ̶a-eloodoli niɡ̶ijo jotigide, domoɡ̶oyemaa monadi niɡ̶ina analeeɡ̶anatitetiwaji, pida aɡ̶onadi. Codaa domoɡ̶oyemaa mowajipatalo niɡ̶inoa analeeɡ̶ajipaatalo, pida aɡ̶ica doɡ̶owajipatalo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Digawinitiwaji! Ica niiɡ̶axinaɡ̶anaɡ̶a lajoinaɡ̶aneɡ̶eco Moisés, niɡ̶ini dabiditi, odaa igeteda Jesus mina dineetalo, mee, “Ǥoniiɡ̶axinoɡ̶odi, amiina ane leeditibige me jao, odaa ja jakadi midioka limedi me idewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus naɡ̶a igidi, meeteta, “Amiidi ica ane diniditeloco midiwa lajoinaɡ̶aneɡ̶eco Moisés? Amiidi ica baanaɡ̶a alomeɡ̶eniteloco?” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Odaa mee niɡ̶ijo ɡ̶oneleegiwa, me igidi, “Emaani Ǥaniotagodi Aneotedoɡ̶oji manitawece ɡ̶adaaleɡ̶ena, codaa minoatawece niɡ̶icoa ane eemiteetece, codaa minitawece ɡ̶adoniciwaɡ̶a, codaa minoatawece ɡ̶adowooko. Codaa leeditibige memaani ɡ̶adipecaɡ̶awa digo aneni madinemaani.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Odaa Jesus meete, “Jaɡ̶adigititece niɡ̶ina anewi. Awii niɡ̶ida anenita, odaa idioka limedi me ɡ̶adewiki miniwataɡ̶a Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pida niɡ̶ijo ɡ̶oneleegiwa domaɡ̶a dinikeenaɡ̶aneɡ̶e me iɡ̶enaɡ̶a. Odaa ja digikataci, mee, “Pida, amiijo ica ipecaɡ̶awa?” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus naɡ̶a igidi, meete, “Ica ɡ̶oneleegiwa one dinikatini manitaɡ̶a nigotaɡ̶a Jerusalém, one igo Jericó. Naigitinece jona dakapetege icoa olicaɡ̶aɡ̶a, odaa jonoɡ̶onoɡ̶a lowoodi, codaa eliodi monalaketibige, pida noɡ̶oika, jona doletibige me yeleo, odaa joɡ̶opitibeci. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pida ganigepidiɡ̶ica niɡ̶ijoa sacerdotitedi ane libakadi Aneotedoɡ̶oji liɡ̶eladi, jonaɡ̶aɡ̶a dinikatini mijotaɡ̶a niɡ̶ijo naigi. Odaa naɡ̶a nadi niɡ̶ijo ɡ̶oneleegiwa, odaa ja nawiile, inigotinece eledi liwai niɡ̶ijo naigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ica leviita eledi jonaɡ̶aɡ̶a inaaɡ̶igotinece. Naɡ̶a nadi niɡ̶ijo ɡ̶oneleegiwa, odaa onexaa iwiteloco, odaa jaɡ̶aɡ̶a ixomaɡ̶atijo. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pida ica samaritaano onaɡ̶aɡ̶a diniwiaje, odaa niɡ̶icoteloco. Naɡ̶a nadi niɡ̶ijo ɡ̶oneleegiwa eliodi me iwikode. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Odaa jona diiteloco niɡ̶ipegi, odaa jeɡ̶eo liwetadi, one yatita najidi inaa viinyo niɡ̶icoa elaciletedi. Niɡ̶idiaaɡ̶idi ja yexaɡ̶ateloco niɡ̶ijo ɡ̶oneleegiwa nemadica, odaa jona yadeegiticogi manitaɡ̶a aca ɡ̶odiotaɡ̶axi, odaa jiɡ̶idiaaɡ̶i me dowediteloco. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Neɡ̶eledi noko jona yajigota niɡ̶ijo ane nebi naɡ̶aca ɡ̶odiotaɡ̶axi iniwataale beexotedi ane loojedi modowediteloco. Odaa meeta, ‘Adowetiteloco, codaa nigicoa eletidi laakataka, nige idopitijo, odaa jediateda.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Odaa Jesus jeɡ̶eeteta niɡ̶ijo ɡ̶oneleegiwa ane ige, “Amiida ica anakati? Amepidiɡ̶ica idi itoatadiɡ̶ida anewi me lipecaɡ̶awa niɡ̶ijo anonaxacoɡ̶otibige?” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Odaa niɡ̶ijo ane diiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés ja igidi Jesus, mee, “Niɡ̶ijo aneneɡ̶egi iwikode niɡ̶ijo ɡ̶oneleegiwa, codaa me yaxawa.” Odaa Jesus jeɡ̶eete, “Dice awii liciagi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus ijaaɡ̶ijo niɡ̶ijo anodiotibece odioteci naigi, odaa joɡ̶otota manitaɡ̶a aca nigotakawaana. Odaa aca iwaalo anodita Marta ja nodetedicogi Jesus minitaɡ̶a liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aca nioxoa anodita Maria, odaa jona dilokotege Ǥoniotagodi Jesus, odaa ja wajipatalo niɡ̶icoa liiɡ̶axinaɡ̶aneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pida Marta baɡ̶a yajolitaɡ̶atelogo niɡ̶icoa libaketedi mini liɡ̶eladi. Odaa niɡ̶igo miniwataɡ̶a Jesus, odaa oneetalo, “Iniwa-aagodi, agodaɡ̶ana-aati, naɡ̶ani ininyooxoa naɡ̶a idika moka eeyotece me jaote digawi-iinitelogo iba-aaketedi? Iiɡ̶eni menagi idaxawanawaanigi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pida Ǥoniotagodi ja igidi meeteta, “Niɡ̶ida makaami ɡ̶adajolitakitibece, codaa me aɡ̶owikomataatibece, leeɡ̶odi niɡ̶inoa anicinoa. ");
INSERT INTO kbcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pida leeditibige mokidatece niɡ̶ica ɡ̶adoenatagi, odaa Maria baanaɡ̶a iomaɡ̶aditice niɡ̶ica ane daɡ̶axa mele, codaa aɡ̶ica ane ibanootece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ica noko Jesus ganigidi ica aneite me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Odaa naɡ̶a nigotedini me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, ganigepidiɡ̶ica niɡ̶ijo anodiotibece dipokotalo Jesus, mee, “Ǥoniotagodi, ɡ̶odiiɡ̶axineɡ̶egi me jotaɡ̶aneɡ̶enaɡ̶a Aneotedoɡ̶oji, digo anee João Batista me iiɡ̶axitiogi anodiotibeci.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Odaa meetediogi, “Niɡ̶ina motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, enitiwaji, ‘Ǥodiodi anadeoni ditibigimedi, jemaanaɡ̶a minatawece oko odoɡ̶eteta Ǥaboonaɡ̶adi. Jemaanaɡ̶a me iiɡ̶eni laaleɡ̶enali inatawece oko. Awii niɡ̶ica anemaani mawii digoina iiɡ̶o, liciagi mowo anemaani digoida ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Anajicitoɡ̶owa ɡ̶oweenigi ane jopooɡ̶atibige inoatawece nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ixomaɡ̶ateenitedice ɡ̶obeyaceɡ̶eco, igaataɡ̶a niɡ̶ida moko jixomaɡ̶ateenaɡ̶atice niɡ̶ina anowotoɡ̶odomi ane beyagi. Codaa jiniɡ̶ikani daɡ̶a dineetoɡ̶owa ɡ̶odaxakawa. Pida ɡ̶odoɡ̶aaɡ̶egiticogi miditaɡ̶a loniciwaɡ̶a nibeyacaɡ̶a.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Odaa Jesus meetediogi, “Diɡ̶ica niɡ̶ina akaamitiwaji anigo liɡ̶eladi lokaaɡ̶edi niɡ̶ina me liwigo-enoale me doletibige ladiligi, oditaɡ̶a eeta, ‘Yokaaɡ̶edi, awiitate yadilaɡ̶a itiwatadiɡ̶idi paontedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Igaataɡ̶a ini yokaaɡ̶edi gela meno me diniwiaje, pida aɡ̶ica anigetiɡ̶idi ane jajigota me yeligo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pida idei catiwedi liɡ̶eladi me igidi, onee, ‘Jinaɡ̶awii igecaɡ̶aloɡ̶o! Ja jinoxoco yapoagi, codaa ionigipi ja niotaɡ̶a, aɡ̶alee jakadi daɡ̶a idicoti oditaɡ̶a jajigotedaɡ̶awa paontedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Odaa ejitaɡ̶awatiwaji anicotini daɡ̶a leeɡ̶odi me lokaaɡ̶edi, pida yajigota ane dipokotibige, leeɡ̶odi jeɡ̶eo ligecaɡ̶aloɡ̶o me daɡ̶a yakamaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Joaniɡ̶idaa leeɡ̶odi mejitaɡ̶awatiwaji, ipokitalo Aneotedoɡ̶oji, odaa jaɡ̶abaatege ane ɡ̶adipoketegi. Oleetibige Aneotedoɡ̶oji niɡ̶ina midi ananiaditibige makaamitaɡ̶atiwaji, odaa akatitiwaji. Atokeni epoagi, odaa domoketaɡ̶adomi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jiɡ̶idaaɡ̶ee inatawece niɡ̶ina anodipokotalo Aneotedoɡ̶oji, yajigotediogi anodipokotibige, codaa inatawece niɡ̶ina anodoletibige, oyakadi. Codaa epoagi domoketema niɡ̶ina ane yatoke. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Domigica ina akaamitiwaji anakaami eniododipi ane yajigota lionigi lakeedi, ina me dipokotigi noɡ̶ojegi? ");
INSERT INTO kbcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oɡ̶oa, domige ajicita nelá ina me dipokotigi okoɡ̶okoodi ligetegi? ");
INSERT INTO kbcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Odaa niɡ̶ida makaamitiwaji, anakaami abeyacaɡ̶aɡ̶a, owooɡ̶oti majici ɡ̶adionigi anele. Odaa Ǥadiodi ane itiniwa digoida ditibigimedi daɡ̶axatace me yajigotediogi Liwigo niɡ̶ina anodipokotalo!” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus one iticoitedice ica niwigo abeyaceɡ̶egi ane dakatiogi ica ɡ̶oneleegiwa, aneo mewaloɡ̶onaɡ̶a. Niɡ̶ijo naɡ̶a noditice niɡ̶ijo niwigo abeyaceɡ̶egi, odaa niɡ̶ijo ɡ̶oneleegiwa jonaɡ̶a yakaditace me dotaɡ̶a. Odaa niɡ̶idi noiigi eliodi moyopo. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pida onidi ica oko anodi, “Naɡ̶anati! Belzebu ane iiɡ̶e niwicidi abeyacaɡ̶aɡ̶a eo notoetiigi niɡ̶idoa ɡ̶oneleegiwa me iticoitedice niwicidi ane beyagi. (Belzebu aneledi liboonaɡ̶adi Satanás).” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Odaa ica eledi oko odineetalo odipokotalo meote loenatagi anodoxicetema, me ikee me icoɡ̶oticogi nimaweneɡ̶egi miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pida Jesus yowooɡ̶odi lowooko, odaa meetediogi, “Niɡ̶ijo noiigi anowotibece lapoawaanigi me dakapetibigiwage, niɡ̶idi noiigi icota me ma. Codaa niɡ̶ina dinoiigiwepodi ane daɡ̶a ilaɡ̶atiwage aaɡ̶aɡ̶a icota me ma. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Codaa niɡ̶ijo ane iiɡ̶e Satanás, nige diniomaɡ̶adi me dinideleɡ̶e, baadaɡ̶a yeyaɡ̶aticoace. Igaamee ina meni me Belzebu najigotiwa inotoetiigi me jiticoitedice niwicidi abeyacaɡ̶aɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pida daantiɡ̶idaaɡ̶ee, amiijo ane yajigotiogi notoetiigi niɡ̶ijo anodiotibigaɡ̶adici moiticoitedice niwicidi abeyacaɡ̶aɡ̶a? Joaniɡ̶idaa leeɡ̶odi niɡ̶ijo anodiotibigaɡ̶adici ijaaɡ̶oikeetaɡ̶awa meliodi mabataa. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pida jatika loniciwaɡ̶a Aneotedoɡ̶oji me jiticoitedice niwicidi abeyacaɡ̶aɡ̶a. Odaa niɡ̶ida ikee naɡ̶a diiɡ̶enataka Aneotedoɡ̶oji digoina ɡ̶adiwigotigitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Niɡ̶ina ɡ̶oneleegiwa loniciweɡ̶enigi anele manigoe, dowediteloco epaa liɡ̶eladi, codaa icoatawece niɡ̶icoa ane nepilidi dotete. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pida nigicota niɡ̶ina ane daɡ̶axa me loniciweɡ̶enigi, odaa ja dinigaanyetece niɡ̶ijo loniciweɡ̶enigi, odaa ja yadeegi icoatawece niɡ̶icoa likanaɡ̶anaɡ̶atedi, niɡ̶ijoa ane nakato niɡ̶ijo ɡ̶oneleegiwa loniciweɡ̶enigi. Odaa ja yawalace niɡ̶icoa latekatece niɡ̶ijo loniciweɡ̶enigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Niɡ̶ina ane daɡ̶a icaajo, dice yakapetegi, codaa niɡ̶ina ane daɡ̶a idaxawatece me jatecoɡ̶otee iniwaxacocoli anilaagitedibece, odaa ja miniaa ilaagaɡ̶aditedibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Niɡ̶ina niwigo abeyaceɡ̶egi naɡ̶a noditicogi oko, onigotelogo nipodaɡ̶a ane yadilo, ane diɡ̶ica niɡ̶eladimigipi, doletibige ane lotokaɡ̶adi. Niɡ̶ina naɡ̶a diɡ̶ica yakadi, odaa meetibige le, ‘Jopitacicogi iɡ̶eladi ane idoditicogi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Odaa joɡ̶opitaceloco niɡ̶ijo oko, anakaaɡ̶ijo me dakatiogi, odaa yakadi me micataɡ̶a niɡ̶ina diimigi ane dinoladitice, codaa anoyoetibigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Odaa ja noditice, odaa igotiogi eletidi seete niwicidi abeyacaɡ̶aɡ̶a, niɡ̶idiwa daɡ̶axa me beyagi caticedi niɡ̶ijo odoejegi. Noɡ̶odakatiogi niɡ̶ini ɡ̶oneleegiwa, odaa jiɡ̶idiaaɡ̶iticoace. Odaa niɡ̶ica anee niɡ̶ijo ɡ̶oneleegiwa ja daɡ̶axa me beyagi caticedi niɡ̶ijo anee maleekoka dakatiogi niɡ̶ijo niwigo abeyaceɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Eɡ̶idaaɡ̶eeteda me dotaɡ̶a Jesus, aca iwaalo ane idei liwigotigi niɡ̶idi noiigi mee, niɡ̶ina me dinigetaɡ̶atee me yotaɡ̶aneɡ̶e Jesus, “Ninitibece naɡ̶aca iwaalo ane dinigajetaɡ̶adici, codaa ane ɡ̶adilipeɡ̶eni!” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pida Jesus naɡ̶a igidi, meete, “Daɡ̶axa me ninitibigiwaji niɡ̶ijo anowajipatalo Aneotedoɡ̶oji lotaɡ̶a, codaa moyiwaɡ̶adi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Niɡ̶ijo noiigi naɡ̶a diniligice, moyawiile Jesus, odaa jona dotaɡ̶a onee, “Niɡ̶ina noiigi niɡ̶inoa nokododi daɡ̶axa me abeyacaɡ̶aɡ̶a. Odipokotalo Aneotedoɡ̶oji meote ɡ̶odoxiceɡ̶edi me ikee me niɡ̶iniaa idiiɡ̶e. Pida Aneotedoɡ̶oji aɡ̶eote eledi loenatagi, igaataɡ̶a jeɡ̶eote niɡ̶ijo anigote Jonas niɡ̶ijo jotigide, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Igaataɡ̶a Jonas ikeetiogi niɡ̶eladimigipitigi Nínive miniaaɡ̶iniwa Aneotedoɡ̶oji iiɡ̶e migo naɡ̶ani nigotaɡ̶a, odaa joɡ̶oyowooɡ̶odi niɡ̶icoa ane ninyaco Jonas. Jiɡ̶idaaɡ̶eji Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, idinikeetiogi niɡ̶ina noiigi me idiiɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naɡ̶ajo iniona-eloodo ane icoɡ̶oticogi micataɡ̶a niocodi niwetaɡ̶a, icoɡ̶oticogi ditigedi enagi me wajipatalo lotaɡ̶a Salomão, niɡ̶ijo aninoa owidi lixaketedi. Odaa niɡ̶ica noko nige limedi Aneotedoɡ̶oji me iloikatidi oko leeɡ̶otedi libeyaceɡ̶eco, ajaaɡ̶ajo naɡ̶ajo iwaalo dabiditini, ikee me abataatiwaji, igaataɡ̶a ite Ee ɡ̶adiwigotigitiwaji ane daɡ̶axa me inoa ixaketedi caticedi Salomão. Pida aɡ̶emaani mabaategetiwaji inoa yotaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a adinilaanitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niɡ̶ijo noɡ̶owajipatalo Jonas lotaɡ̶a niɡ̶ijo niɡ̶eladimigipitigi Nínive, odaa joɡ̶odinilaatece libeyaceɡ̶eco. Odaa niɡ̶ica noko nige limedi Aneotedoɡ̶oji me iloikatidi oko leeɡ̶otedi libeyaceɡ̶eco, odaa niɡ̶eladimigipitigi Nínive dabiditiniwace, oikee makaami nilaagetedipi, igaataɡ̶a ite Ee ɡ̶adiwigotigitiwaji, codaa yotaɡ̶a daɡ̶axa me ɡ̶oneɡ̶aɡ̶a aliciaco lotaɡ̶a Jonas. Pida akaamitiwaji aɡ̶abaatege inoa yotaɡ̶a, codaa aɡ̶adinilaanitibecetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aɡ̶ica ini oko ane yalegi loledaɡ̶axi oditaɡ̶a yapoɡ̶oditini, domigetaɡ̶a yapoɡ̶oditeloco baxia. Pida ideyate loledaɡ̶axi ditibigimedi, eotibige minatawece oko anodakatiwece diimigi onadi liwitiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Niɡ̶inoa ligecooɡ̶e niɡ̶ina oko micataɡ̶a daɡ̶a lokokenatema laaleɡ̶ena. Niɡ̶inoa ligecooɡ̶e nigele, odaa anitawece laaleɡ̶ena nalo. Pida nige deɡ̶eleteda ligecooɡ̶e, laaleɡ̶ena idaaɡ̶ee, idei nexocaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pida anidakitiwaji, amaleeɡ̶aɡ̶a naɡ̶ani lokokena anani makaamitaɡ̶atiwaji adinanatigi me nexocaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Niganitawece ɡ̶adaaleɡ̶ena nolee lokokena, oteɡ̶exaaɡ̶aɡ̶a idei nexocaɡ̶a, odaa atale macataɡ̶a naɡ̶ana lokokena me nalo catiwedi ɡ̶adaaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Naɡ̶a nigotedini Jesus me dotaɡ̶a, odaa ica fariseu jonaɡ̶a node migo aniodi liɡ̶eladi. Odaa Jesus joniɡ̶igo, odaa jona nicotedi maditaɡ̶a aca nameeja. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Niɡ̶ijo naɡ̶a nadi niɡ̶ijo fariseu Jesus me diɡ̶ica daɡ̶a aniwilegi ane lakatigi codaaɡ̶anioditeda, eliodi me yopo. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Odaa Ǥoniotagodi oneete, “Niɡ̶ida makaamitiwaji anakaami fariseutedi, inoka iwileci ɡ̶anigoopa, ɡ̶aniɡ̶inogo wetice. (Odaa idaɡ̶aɡ̶a enitiwaji aniwileci me wetice.) Pida catiwedi ɡ̶adaaleɡ̶ena, inokemaani molice, codaa mawii ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akaami yetoledi! Igaataɡ̶a Aneotedoɡ̶oji jiɡ̶ijaa eote wetice, codaa me yoe catiwedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pida daɡ̶ajicitiogi madewetedi ɡ̶aweenigi ane nolee ɡ̶aniɡ̶inogo, ɡ̶anigoopatiwaji. Odaa inoatawece yapiditedaɡ̶adomitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aneotedoɡ̶oji ɡ̶adiloikatititetiwaji anakaami fariseutedi! Igaataɡ̶a ajicitalo liwai ɡ̶adawodigijedi ane ɡ̶anidiizimo, ‘hortelã’, ‘arruda’, codaa meletidi niale-laamotiidi ane jelicaɡ̶a. Pida niɡ̶ida makaamitiwaji aɡ̶oleetibige makaami eletema eledi oko, codaa aɡ̶emaanitiwaji Aneotedoɡ̶oji. Leeditibige makaami eletema eledi oko, codaa memaani Aneotedoɡ̶oji, codaa niɡ̶inoa anicinoa eletidi ajicitalo Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aneotedoɡ̶oji ɡ̶adiloikatititetiwaji anakaami fariseutedi! Leeɡ̶odi daɡ̶axa me ɡ̶ademaanigitiwaji manicooteloco nibaanco niɡ̶ina oko anida naɡ̶atetigi midiwa niiakanaɡ̶axiidi, codaa ɡ̶ademaanigi modeemitetibigaɡ̶aji metiɡ̶adiceni miditaɡ̶a ane licooɡ̶aditibece oko me dakapetibigiwage. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aneotedoɡ̶oji ɡ̶adiloikatititetiwaji anakaami fariseutedi, codaa makaamitiwaji ane iiɡ̶axinaɡ̶anitece lajoinaɡ̶aneɡ̶eco Moisés, oko ane daɡ̶a dinikee niɡ̶ica anee. Ǥadiciagitiwaji niɡ̶ina anonaligite émeɡ̶egi, pida ayeloɡ̶o, odaa niɡ̶ina oko odaɡ̶axatibigeloco, pida aɡ̶oyowooɡ̶odi midi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Odaa ica ane diiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés jona igidi Jesus, oneetalo, “Ǥoniiɡ̶axinoɡ̶odi, niɡ̶ina mawii niɡ̶ida ɡ̶agegi, jaɡ̶aɡ̶a enitoɡ̶oloco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus oneeteta, “Aneotedoɡ̶oji aaɡ̶aɡ̶a ɡ̶adiloikatititetiwaji ane iiɡ̶axinaɡ̶anitece lajoinaɡ̶aneɡ̶eco Moisés. Leeɡ̶odi micataɡ̶a daɡ̶awii loyaɡ̶agi eledi oko, leeɡ̶odi maɡ̶axakeni ɡ̶adiiɡ̶axinaɡ̶aneɡ̶eco, niɡ̶inoa ane iwaaɡ̶adi, ane daɡ̶adiaa domiɡ̶ica anabotege. Pida akamaɡ̶akaamitiwaji aɡ̶axawani niɡ̶ina oko moyotete icoa ɡ̶adiiɡ̶axinaɡ̶aneɡ̶eco daɡ̶a micataɡ̶a madoti maxawanitiwaji me yadeegi loyaɡ̶agi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Aneotedoɡ̶oji ɡ̶adiloikatititetiwaji leeɡ̶odi miwilaniteloco aniwote niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko naijedi ɡ̶aditacepodi niɡ̶ijo jotigide. Akamaɡ̶akaamitiwaji jiɡ̶iwilaniteloco niɡ̶inoa libecoli manalakitibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Niɡ̶ina miwilaniteloco niɡ̶inoa libecoli, jiɡ̶ikeenitiwaji maniwotitema anee niɡ̶ijo jotigide, niɡ̶ijo noɡ̶onigodi niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Odaa natigide jiɡ̶iwilani aniwote, codaa jaɡ̶awii me libinienigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Joaniɡ̶idaa leeɡ̶odi Aneotedoɡ̶oji ane daɡ̶axa niɡ̶ica lowooɡ̶otakaneɡ̶egi, meete, ‘Jiwakateetiogi niɡ̶idi noiigi anoyeloɡ̶oditedibece yowooko, codaa niɡ̶ina ane jiiɡ̶etibigiwaji mowo ibakedi. Odaa niɡ̶idi noiigi idi anonigodi, idiaaɡ̶eledi oiatetibeci niɡ̶idi anoyeloɡ̶oditedibece yowooko.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Odaa leeɡ̶odi niɡ̶ida niciagi, Aneotedoɡ̶oji icota me iloikatidi niɡ̶ina noiigi niɡ̶inoa nokododi, leeɡ̶odi ijotawece niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko ane nigo, niɡ̶ijo maleekoka yoeteda niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel, jiɡ̶ijaa odoejegi anoyeloadi, codaa me eletidi anonigodi, odaa owidijegi anoyeloadi Zacarias digoida lagitege nameeja wetiɡ̶a minitaɡ̶a niɡ̶ijo eledi diimigi-le aneitedice Aneotedoɡ̶oji. Ejitaɡ̶awatiwaji mewi micota me iloikatidi Aneotedoɡ̶oji niɡ̶ina noiigi aninaa niɡ̶inoa nokododi, leeɡ̶odi lemeɡ̶egi niɡ̶ijo liotagipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aneotedoɡ̶oji icota me ɡ̶adiloikatititetiwaji ane iiɡ̶axinaɡ̶anitece lajoinaɡ̶aneɡ̶eco Moisés. Igaataɡ̶a ɡ̶adiciagitiwaji niɡ̶ina ane noxoco lapoagi liɡ̶eladi, odaa aika oko me dakatiobece. Joaniɡ̶idaaɡ̶enitiwaji aɡ̶ikani oko moyowooɡ̶odi anodaaɡ̶ee moyakadi migotibeci lodoe Aneotedoɡ̶oji, pida oteɡ̶exaaɡ̶aɡ̶a akaamitiwaji aɡ̶emaani makaatiobece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Niɡ̶ijo Jesus naɡ̶a noditedice, odaa niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés ijaaɡ̶ijoa fariseutedi joɡ̶oyalomeɡ̶e. Odaa eliodi moyelatema, codaa eliodi monigetedice. ");
INSERT INTO kbcNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Domoɡ̶odoletibige daɡ̶a dibatá niɡ̶ina me dotaɡ̶a, domoɡ̶owo moyakadi me nilaagedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Icoa fariseutedi onigetedice Jesus, odaa eliodi oko yatecoɡ̶o codaa joɡ̶oipoditibigeloco eledi. Odaa Jesus ja yajoitediogi niɡ̶idi anodiotibece, meetediogi, “Onexaa anidakitiogi fariseutedi anoyotete ane beyagi catiwedi laaleɡ̶ena, ane ibeyacaɡ̶adi lewiɡ̶a. Liciagi niɡ̶ina labookojegi leyeema ane idei catiwedi paon, ajinataɡ̶a, pida eo me dabo. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Inoatawece ane dinapoɡ̶oditedini, icota me dinowiegi, codaa inoatawece anoyowiegitelogo, icota me jowooɡ̶otaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Joaniɡ̶idaaɡ̶ee ijoatawece ane ɡ̶adotaɡ̶a digoida nexocaɡ̶a, icota me jajipaaɡ̶atalo digoina getaɡ̶a. Inoatawece icoa ɡ̶adotaɡ̶a ane domaɡ̶a aɡ̶atitedini catiwedi diimigi-le ane dinoxoco, icota nigidiaaɡ̶idi oyatemati owotibige minatawece oko owajipatalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ejitaɡ̶awa yokaaɡ̶etedi, anaɡ̶adoiita niɡ̶ina ane yakadi me yeloadi ɡ̶adolaadi, leeɡ̶odi aɡ̶alee yakadi meo eledi anigotaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pida jeloɡ̶oditaɡ̶awatiwaji anepaɡ̶a leeditibige madoiita. Adoiitalo Aneotedoɡ̶oji anepiɡ̶ida loniciwaɡ̶a me ɡ̶adokolenitedicogi minitaɡ̶a noledi ane daɡ̶a ipe, nigicota me yaaɡ̶adi ɡ̶adewiɡ̶a. Jopitacaɡ̶alocotiwaji mejitaɡ̶awa, adoiitalo niɡ̶iniwa anejitedaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Niɡ̶ina moyaa ciinco imikola, aɡ̶icoda loojedi, loojedi iniwataale beexotedi. Pida Aneotedoɡ̶oji idokee ayaagiditedibige otaɡ̶anitece imikola. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eleditace jemaa mejitaɡ̶awa Aneotedoɡ̶oji me yowooɡ̶odi ane liwokodi ɡ̶adamodi aneitigi ɡ̶adacilo. Enice jinaɡ̶adoiitiwaji, igaataɡ̶a daɡ̶axa meliodi ɡ̶aniwaló, aɡ̶adiciagitiwaji niɡ̶ijoa imikola anowidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ejitaɡ̶awatiwaji niɡ̶ina oko anee lodoe eledi oko mida anejitege, odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, eji lodoe niaanjotedi Aneotedoɡ̶oji mewi mida anejitege. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pida niɡ̶ina oko ane dinaɡ̶aditi lodoe eledi oko mida anejitege, odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, aaɡ̶aɡ̶a eji lodoe Aneotedoɡ̶oji codaa me aanjotedi mewi me diɡ̶ica anejitege. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Niɡ̶ina ane beyagi me dotaɡ̶atibigiji, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, Aneotedoɡ̶oji baɡ̶a yakadi me ixomaɡ̶ateetedice loenataka ane beyagi, nige dinilaatece libeyaceɡ̶eco. Pida niɡ̶ina ane beyagi me dotaɡ̶atibige Aneotedoɡ̶oji Liwigo, Aneotedoɡ̶oji baadaɡ̶a ixomaɡ̶ateetedice loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Niɡ̶ina nigetiɡ̶adadeegi metiɡ̶adalomeɡ̶eni midiwataɡ̶a liiakanaɡ̶axiidi judeutedi, oɡ̶oa, domige lodoe ɡ̶oniwinoɡ̶ododi idiaa lacilodi judeutedi, jinaɡ̶a aɡ̶owikomataa leeɡ̶odi me doɡ̶owooɡ̶oti me ojetee oteɡ̶exaaɡ̶aɡ̶a owooɡ̶oti magitatakani. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Igaataɡ̶a naɡ̶ani lakata, Aneotedoɡ̶oji Liwigo ikeetaɡ̶awa niɡ̶ica ane leeditibige me ɡ̶agegi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ica ɡ̶oneleegiwa anidiaaɡ̶i liwigotigi niɡ̶idi noiigi-nelegi meetalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, adiwikodeni, iiɡ̶eni inioxoa me iniwaiɡ̶awatece niɡ̶idiwa ane nenyaɡ̶aditedoɡ̶odomi ijoolatibige ɡ̶odiodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pida Jesus meeteta, “Yokaaɡ̶edi, amiijo ica aneetaɡ̶awa me Ee ɡ̶aniwinoɡ̶odi, oɡ̶oa amiijo ica aneo me Ee ɡ̶adacilo me jawalace icoa ɡ̶anepilidi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Odaa Jesus meetediogi iditawece niɡ̶ijo oko, “Atacolitecetiwaji, codaa adowetitatiwaji ineɡ̶ewianaɡ̶a memaani gaantiɡ̶ini ane nebi eledi oko. Igaataɡ̶a Aneotedoɡ̶oji ayemaa me yewiɡ̶atema niɡ̶ina oko minokina me dinigaanyetece niliicaɡ̶ajetegi niɡ̶ina iiɡ̶o.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Odaa Jesus ja yatemati ica natematigo ane ɡ̶odiiɡ̶axi, meetediogi, “Ica ɡ̶oneleegiwa liico, onidiwa icoa lixoɡ̶otaka anoyajigo owidi nawodigijedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Odaa meetibige le, ‘Igamige ele mejigotalo? Igaataɡ̶a aɡ̶ica anejate niɡ̶inoa yawodigijedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Odaa jeɡ̶eo lowoogo, mee, ‘Ja jowooɡ̶odi anejigotalo, jojiketedi niɡ̶inoa idiimaɡ̶a nelecoli aneite me jotete yawodigijedi, odaa jaotace geladi diimaɡ̶a daɡ̶axatace me nelecoli, odaa ja jotete niɡ̶inoa yawodigijedi ela. Odaa catiwedi idiimaɡ̶a geladi jotete idiwatawece yawodigijedi codaa me niɡ̶inoa eletidi ane inepilidi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Odaa meetibige le, ‘Nige jotete idiwatawece ane jopotigi me jixomaɡ̶ateetedice owidi nicaaɡ̶ape. Odaa ja inipetini, ele me jiniodi, jacipe, jaote icoa ane inikeco.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pida Aneotedoɡ̶oji meeteta, ‘Niɡ̶ida makaami, akaami yetole! Igaataɡ̶a inaaɡ̶ina niɡ̶ina enoale ja ɡ̶adelewi. Odaa amiijo ica aneote nepilidi idiwatawece icoa ɡ̶adotetenataka?’ ");
INSERT INTO kbcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Joaniɡ̶idaaɡ̶ee niɡ̶ina oko ane nioda niliicaɡ̶ajetecidi niɡ̶ina iiɡ̶o, lodoe Aneotedoɡ̶oji baadaɡ̶a liico.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Odaa Jesus meetediogi anodiotibece, “Joaniɡ̶idaa mejitaɡ̶awatiwaji jinaɡ̶a ɡ̶adigecaɡ̶aleɡ̶eni niweenigi anopootibige me ɡ̶adewiki, oteɡ̶exaaɡ̶aɡ̶a ɡ̶adowoodaɡ̶agi anopootibige madinixomitinigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Igaataɡ̶a ɡ̶adiwigo daɡ̶axa me ɡ̶oneɡ̶egi aliciagi niweenigi. Ǥadolaadi daɡ̶axa me ɡ̶oneɡ̶egi aliciagi nowoodaɡ̶agi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Digawini ilaaɡ̶axodi! Aɡ̶enanaɡ̶anaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a onioda liweenaɡ̶a. Codaa aɡ̶ica lidiimigi anoyate liweenaɡ̶a moyotete. Pida Aneotedoɡ̶oji idokee me yajigotediogi liweenigi. Pida akaamitiwaji daɡ̶axa makaami ɡ̶oneɡ̶egi caticedi niɡ̶inoa ilaaɡ̶axodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Amiijo ina akaamitelocotiwaji ane yakadi me iigitedice nokododi me yewiɡ̶a, leeɡ̶odi ɡ̶adoɡ̶owikomatiigitiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Enice nige daɡ̶akati mawii ɡ̶adoenatagi lionicawaanigi, igame leeɡ̶oditiwaji ina me ɡ̶adigecaɡ̶aleɡ̶eni inoa eletidi ane daɡ̶axa me dakake? ");
INSERT INTO kbcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Digawini niɡ̶inoa niale lawoɡ̶o libinienaɡ̶a! Anibaaɡ̶a, aɡ̶oyoe lipegeteɡ̶e. Pida ejitaɡ̶awatiwaji ijaaɡ̶ijo Salomão midiwatawece ane niliicaɡ̶ajetecidi, pida aɡ̶ica daɡ̶a dinixotinigilo nowoodi libinienaɡ̶a daɡ̶a naɡ̶axatelogo niɡ̶inoa niale lawoɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aneotedoɡ̶oji eote nadegogo micataɡ̶a diɡ̶inoa lowoodi libinienaɡ̶a. Nadegogo ane ili niɡ̶ina noko, natiinigoi joɡ̶oyalegi. Odaa ajawienataka me yajigotedaɡ̶awa ɡ̶adowoodi anele, akaamitiwaji ane deɡ̶eliodi ɡ̶atiwaɡ̶atakaneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Enice jinaɡ̶a adinigecaɡ̶aloɡ̶otiti, diɡ̶idokee moleetibige me ɡ̶adigecaɡ̶aleɡ̶eni niɡ̶ica anelici, codaa anacipeta. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Igaataɡ̶a noiigi anida aneetege niɡ̶ina iiɡ̶o idokee modoletibige inoatawece niɡ̶inoa anicinoa. Leeɡ̶odi Ǥadioditetiwaji Aneotedoɡ̶oji yowooɡ̶odi inoatawece niɡ̶icoa anopootibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Enice jinaɡ̶a ɡ̶adigecaɡ̶aloɡ̶otiti niɡ̶inoa ganicinoa, pida odoejegi oleetibige mawii Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko, odaa Aneotedoɡ̶oji jaɡ̶aɡ̶a yajigotedaɡ̶awa inoatawece anopootibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Akaami yoiigi anakaami onateciɡ̶idi, jinaɡ̶adoii. Igaataɡ̶a Ǥadiodi Aneotedoɡ̶oji yakadi mele meote makaami lacilodi niɡ̶ina loiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aani niɡ̶icoa ane ɡ̶anepilidi, odaa anedianitiniwace madewetedipi dinyeelo. Oleetibige ɡ̶anaɡ̶aaɡ̶axi ane daɡ̶a daa, odaa oteteni ɡ̶aniliicaɡ̶ajetecidi digoida ditibigimedi, aneite me daɡ̶adiaa daa. Igaataɡ̶a digoida ditibigimedi oliceɡ̶egi aɡ̶icoticogi me dolice, oteɡ̶exaaɡ̶aɡ̶a ipilaɡ̶awaana aɡ̶aca daɡ̶a yaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Igaataɡ̶a aneite ɡ̶aniliicaɡ̶ajetecidi, jiɡ̶idiaa yemaa ɡ̶adaaleɡ̶enalitiwaji me onite. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Leeditibige madinoetitiwaji me ɡ̶adigomitema okanicodaaɡ̶ica gaantiɡ̶ica anenagi, ipiciati ɡ̶anigoenaɡ̶adi, codaa aleci ɡ̶adoledaɡ̶axiidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Awii liciagi niɡ̶ijoa niotaka anowalitibigege necalailegi me icoɡ̶oticogi miditaɡ̶a nadoneɡ̶egi. Nige yatoke epoagi me doletibige me dakatio, odaa aleegi joɡ̶oyomoketege. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Niɡ̶ijoa niotaka ane icotiogi necalailegi malee niwotaɡ̶a, ane nigomaɡ̶a modibatema, odaa ninitibigiwaji niɡ̶ijoa niotaka. Ejitaɡ̶awatiwaji, niɡ̶ijo necalailegi diniikoaɡ̶e, iikoaɡ̶e lowoodi me nediatiniwace, odaa ja iiɡ̶e me nicotiniwace madi nameeja, odaa epaa noɡ̶atema liweenigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eleditace deɡ̶eno me liwigo enoale, migetaɡ̶a iniwatadaɡ̶ani lakata me nigoitijo, idokee micotiogi me niwotaɡ̶a, idokee me nigomaɡ̶a me nibaaɡ̶a, odaa ninitibigiwaji niɡ̶ijoa niotaka. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pida leeditibige mowooɡ̶otitiwaji niɡ̶ina niɡ̶eladimigi daɡ̶a yowooɡ̶odi naɡ̶aca lakata micotio oliceɡ̶egi, odaa agotaɡ̶a ika me yawime liɡ̶eladi me dolice. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Odaa niɡ̶ida makaamitiwaji leeditibige me ɡ̶adigomi, igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, janotaɡ̶awatiwaji naɡ̶aca lakata maleedaɡ̶a anibeoonitege me yanokegi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Odaa Pedro ja ige Jesus, meetalo, “Ǥoniotagodi, okomokoko manatematiitoɡ̶owa ica natematigo ane ɡ̶odiiɡ̶axi, oɡ̶oa, aaɡ̶aɡ̶a atematiitiogi inatawece oko?” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ǥoniotagodi naɡ̶a igidi, meeteta, “Amiijo ica liciagi niɡ̶ijo niotagi ane yakadi me jinakatonaɡ̶a, aninoa lixaketedi? Necalailegi nenyaɡ̶aditini me yowie niɡ̶icoa eletidi niotaka, codaa me yediatece liweenigi me ditibigimedi lakata. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Odaa niɡ̶ijo niotagi aneo idiwatawece niɡ̶icoa necalailegi ane nenyaɡ̶aditini me libaketedi, nigeno necalailegi, niɡ̶ijo niotagi eliodi me ninitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ejitaɡ̶awatiwaji mewi mepaanaɡ̶a ixotio necalailegi me doweditelogo icoatawece ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pida niɡ̶ijo niotagi daɡ̶a eledi lowoogo, oditaɡ̶a dotaɡ̶atigi le, deɡ̶ee, ‘Inecalailegi ja leegi aniɡ̶ica me dopitijo’, oditaɡ̶a ja nalaketiniwace niɡ̶ijoa eletidi niotaka, daɡ̶a daɡ̶axa me aniodi, wacipe, yemaɡ̶atibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Odaa necalailegi niɡ̶ijo niotagi dopitijo niɡ̶ina me daɡ̶adiaa nibeotege, naɡ̶aca aligeɡ̶e me daɡ̶adiaa yowooɡ̶odi. Odaa necalailegi taɡ̶a nakagiditibige eote liwailidawaanaɡ̶a. Odaa joaniɡ̶idaaɡ̶ee niɡ̶ijo niotagi oiloikatidi nigepaa anigicatibige, oyawanaɡ̶aditege niɡ̶ina ane doɡ̶oyiwaɡ̶aditeda Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Niɡ̶ina niotagi ane yowooɡ̶odi necalailegi ane yemaa, pida adinoe, aɡ̶eo necalailegi ane yemaa, icota meliodi monalaketibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pida niɡ̶ijo eledi niotagi ane daɡ̶a yowooɡ̶odi ica necalailegi ane yemaa, diba, pida beyagi libaketedi, odaa idokee me leeditibige me dinalake, pida onateciɡ̶ini me dinaxacoɡ̶o. Aneotedoɡ̶oji idaaɡ̶ee, eliodi me ipiciadi niɡ̶ina oko aneliodi ane yajigote. Codaa me walitetege me dibatetege me naɡ̶axataceloco ane liwokodi niɡ̶ina anowidi me yajigote. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Janagi niɡ̶ina iiɡ̶o micataɡ̶a niɡ̶ina oko ane dáloɡ̶o me yalegi nipodigi, codaa eliodi me jemaatibige doɡ̶odaa yabidi ane jalegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Leeditibige meliodi me jawikode. Joaniɡ̶idaa leeɡ̶odi eliodi me joɡ̶owikomata nigepaa enotiloco niɡ̶ida niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Migaleetibigetiwaji daɡ̶a janagi niɡ̶ina iiɡ̶o daɡ̶a jaotibige niɡ̶ina oko me daɡ̶adiaa nidelaɡ̶a? Aniɡ̶idaa ibakedi me janagi. Pida ejitaɡ̶awatiwaji ane leeɡ̶odi me janagi, jaotibige oko me dawalacetiwage. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Igaataɡ̶a diɡ̶idi ciinco oko dinoiigiwepodi icota me dawalacetiwage, iniwatadiɡ̶ini oko dakapetege iniwata oko, codaa iniwataale dakapetege iniwatadiɡ̶ini. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Eniodi ja lakapetegi lionigi, nionigi jaɡ̶aɡ̶a lakapetegi eliodi; eniodo ja lakapete liona, niona ja lakapete eliodo; noxiiɡ̶ate ja lakapete liiɡ̶ate, niiɡ̶ate jaɡ̶aɡ̶a lakapete loxiiɡ̶ate.” ");
INSERT INTO kbcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Odaa Jesus meetediogi ica noiigi, “Digoina ɡ̶oniiɡ̶otedi, niɡ̶ina nige ica manatitece lolaadi ane icoɡ̶oticogi niocodi wajenaɡ̶a, odaaɡ̶eni, ‘Natigidawaanigi datiode!’ Odaa ewi niɡ̶idaaɡ̶ee. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Odaa niocodi nige icoɡ̶oticogi natinedi, odaaɡ̶enitiwaji, ‘Niláɡ̶a!’ Odaa ewi me niláɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Owooɡ̶otitiwaji anodaa diitigi ane ixomaɡ̶atice niɡ̶ina iiɡ̶o, codaa me ditibigimedi. Enice, igaamee me doɡ̶owooɡ̶oti ica Aneotedoɡ̶oji anigote inoa nokododi? Akaamitiwaji niɡ̶ina anodi mowo Aneotedoɡ̶oji ane yemaa, pida aɡ̶awii. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Igaamee daɡ̶akamaɡ̶akaamitatiwaji awii ɡ̶adowoogo ane iɡ̶enaɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nigica ane beyagi me dotaɡ̶atibigaɡ̶ajitiwaji, codaa ane domaɡ̶a ɡ̶adadeegiticogi lodoe ɡ̶oniwinoɡ̶odi, oleetibige ɡ̶animaweneɡ̶egi madinilakidenitege digoida naigitece, amaleeɡ̶aɡ̶a daɡ̶adiaa ɡ̶adadeegiticogi lodoe ɡ̶oniwinoɡ̶odi. Igaataɡ̶a nige daɡ̶adinilakidenitege, ja ɡ̶adajicita iodaɡ̶awadi libaaɡ̶adi, odaa iodaɡ̶awadi jeɡ̶etiɡ̶adiwilo. ");
INSERT INTO kbcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ejitaɡ̶awatiwaji aɡ̶anotiticogi niwiloɡ̶onaɡ̶axi nigepaa ediani owidije beexo ɡ̶oniwinoɡ̶odi ane diiɡ̶enatakata mediani.” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ajaaɡ̶ajo naɡ̶ajo lakata ica oko ototalo Jesus, odaa joɡ̶oyatematitalo ica anodaaɡ̶ee Pilatos me diiɡ̶enataka monigodi anigepidiɡ̶ica niɡ̶ijoa galileutedi, maleeɡ̶idaa diitigi monigodi waxacocoli moibootema Aneotedoɡ̶oji leeɡ̶odi libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Odaa Jesus ja niniɡ̶odi, meetediogi, “Migakati mijo ijo ninyaagi ijoa galileutedi me leeɡ̶odi mowote libeyaceɡ̶eco caticedi me liciagi niɡ̶inoa eletidi galileutedi? ");
INSERT INTO kbcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ejitaɡ̶awatiwaji aɡ̶ica libeyaceɡ̶egi ane caticedi me liciagi eletidi galileutedi. Codaa niɡ̶ida makaamitiwaji nige daɡ̶adinilaanitece ɡ̶abeyaceɡ̶eco, akaami eleditetiwaji ɡ̶adelewi anee me nigo, odaa idokee me leegitalo Aneotedoɡ̶oji motonitedice. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Niɡ̶ijo 18 oko ane nigo aneniteloco aca niwilana ane leegitibigimece niɡ̶ijo eledi liwai Jerusalém ane liboonaɡ̶adi Siloé. Migakati me nigo leeɡ̶odi me daɡ̶axa me nilaagetedipi lodoe Aneotedoɡ̶oji caticedi niɡ̶idiwa eletidi niɡ̶eladimigipitigi Jerusalém? ");
INSERT INTO kbcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ejitaɡ̶awatiwaji niɡ̶ijo ane nigo adaɡ̶axa me nilaagetedipi lodoe Aneotedoɡ̶oji daɡ̶a liciagi niɡ̶ina eledi oko. Pida nige daɡ̶adinilaanitecetiwaji ɡ̶abeyaceɡ̶eco, akaami eleditetiwaji ɡ̶adelewi digo anee me nigo, odaa idokee me leegitalo motonitedice Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Odaa Jesus ja yatemati ica natematigo anida ane ɡ̶odiiɡ̶axitece, odaa meetediogi, “Ica ɡ̶oneleegiwa ada lawodigije fiigoigo midiwataɡ̶a elanigijedi ‘uuva’. Odaa neɡ̶enagi domaɡ̶a doletibige ela naɡ̶ada niale, pida aɡ̶aca yakadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Odaa meeta niɡ̶ica ane yowie lawodigijedi, ‘Digawini! Jiɡ̶ijoa itoatadiɡ̶ida nicaaɡ̶ape ixomaɡ̶atedijo, idokee niɡ̶ina me janagi joletibige ela naɡ̶ada niale, pida aɡ̶aca jakadi. Natigide akagiti naɡ̶ada niale! Jinaɡ̶alee jikanaɡ̶a naɡ̶ada niale daɡ̶a iteloco iiɡ̶o anele, ane yakadi mejanaɡ̶ate eletidi nawodigijedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pida niɡ̶ijo ane yowie lawodigijedi ja igidi, mee, ‘Inecalailegi, ecoɡ̶otace jikanaɡ̶a naɡ̶ada niale jiwinaɡ̶a niɡ̶ina nicaaɡ̶abi, jabooɡ̶odi libatadi, amaleeɡ̶aɡ̶a yaxawa me ili. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Naɡ̶ada niale nigetaye niɡ̶ina nicaaɡ̶abi anenagi, odaa jikanaɡ̶a me ili. Pida nige daɡ̶acata ela, odaaɡ̶epaanaɡ̶a adiiɡ̶enita me jakagidi.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ica saabado Jesus diiɡ̶axinaɡ̶a manitaɡ̶a aca liiakanaɡ̶axi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Digawini! Onani aca iwaalo joneɡ̶eote dezoito nicaaɡ̶ape me awenanaɡ̶a leeɡ̶odi ica niwigo abeyaceɡ̶egi ane dakatiogi. Aona yakadi me dineɡ̶enaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Odaa Jesus ja nadi aca iwaalo, neɡ̶enidite, meeteta, “Iwaalo, ida makaami ja ɡ̶adicilitema ɡ̶adeelotagi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Odaa ipeketedeloco libaaɡ̶atedi, odaa aɡ̶ica daɡ̶a leegi ja icí me diwena, odaa ja doɡ̶etetibigimece Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pida ica nowienoɡ̶odi niiakanaɡ̶axi ja deliɡ̶ide, leeɡ̶odi Jesus me icilatidi naɡ̶ajo iwaalo me saabado. Joaniɡ̶idaa leeɡ̶odi meetiogi niɡ̶idi noiigi, “Idiwa dibatio ɡ̶obaaɡ̶adi nokododi me jakataɡ̶a me jibaaɡ̶a. Odaa anagi niɡ̶inoa eletidi nokododi me diniwakateeni, pida jinaɡ̶anagi niɡ̶ina me saabado.” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Odaa Ǥoniotagodi ja igidi, meeteta, “Akaamitiwaji niɡ̶ina anodi moyotete liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji, pida aɡ̶otetenitetiwaji! Niɡ̶ina me saabado okanicodaaɡ̶ica niɡ̶ina akaamitiwaji igo aneite neijedi ane noxocotege, odaa ikatedice noɡ̶odinadi, oɡ̶oa, domige nemadicali yadeegitinigi ninyoɡ̶odi me yacipeɡ̶etedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pida naɡ̶ada iwaalo anida aneetege licoɡ̶egi Abraão, niwilo Satanás 18 nicaaɡ̶ape. Igame leeɡ̶odi ina me eni me daɡ̶a yakadi me jicilatidi ina me saabado?” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Odaa Jesus naɡ̶a igiditediogi, ijotawece niɡ̶ijo neloɡ̶ododipi niboliɡ̶atibigiwaji. Pida ijo eledi noiigi baɡ̶a ninitibigiwaji leeɡ̶odi niɡ̶ijoa ɡ̶odoxiceɡ̶etedi aneote. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Odaa Jesus jeɡ̶ee, “Igamigodaaɡ̶ee Aneotedoɡ̶oji nige iiɡ̶e laaleɡ̶enali ina oko? Amigini ica ane jiciaceeketege? ");
INSERT INTO kbcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Digawini! Aneotedoɡ̶oji nige iiɡ̶e niɡ̶ina oko laaleɡ̶enali, jiciaceeketege lolagi ‘mostaada’ ane daɡ̶axa me lionawaana. Ica ɡ̶oneleegiwa dibata, odaa jeɡ̶eyateloco niogó. Odaa naɡ̶ajo elanigije ja ili, odaa ja niale nelegi. Odaa ilaaɡ̶axodi joɡ̶owote libatoli midoataɡ̶a libiweli.” (Odaa jiɡ̶idaaɡ̶ee me ili niɡ̶ina lapo oko ane nepilidi Aneotedoɡ̶oji). ");
INSERT INTO kbcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus naɡ̶a dotaɡ̶atace, odaa mee, “Amigetiɡ̶ini ane jiciaceeketege ica Aneotedoɡ̶oji nige iiɡ̶e ina oko laaleɡ̶enali? ");
INSERT INTO kbcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Niɡ̶ina Aneotedoɡ̶oji nige iiɡ̶e niɡ̶ina oko laaleɡ̶enali, liciagi niɡ̶ina ane yabooɡ̶odi leyeema anoibake moyoe paon, odaa joɡ̶oyawanaɡ̶aditege leyeema oiatigi itoatadiɡ̶ida baxiatedi, odaa niɡ̶idiaaɡ̶idi ijoatawece baxiatedi ja nolee leeɡ̶odi jiɡ̶inaa ane yabooɡ̶odi leyeema.” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus yakagiditedeloco nigotadi nelecoli, codaa me nigotadawaanaɡ̶a, niiɡ̶axitediniwace oko, eɡ̶idaaɡ̶ee me diniwiajetedicogi nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Odaa joniɡ̶ica ane ige, oneetalo, “Ǥoniotagodi, migeliodi ica oko Aneotedoɡ̶oji ane yajigote lewiɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Odaa Jesus ja igidi, meeteta, “Adinoniciwaɡ̶atitiwaji makaatiwece niɡ̶ida epoacawaanigi amaleeɡ̶aɡ̶a yajigotedaɡ̶awa Aneotedoɡ̶oji ɡ̶adewiɡ̶a. Leeɡ̶odi ejitaɡ̶awatiwaji eliodi oko anodoletibige me dakatiobece, pida aɡ̶oyakadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nigidiaaɡ̶idi nige dabiditini niɡ̶eladimigi, odaa ja noxoco epoagi, odaa akaamitiwaji jiɡ̶idiaaɡ̶onitice we. Odaa jaɡ̶anatokenitice epoagi, manidita, odaa menitiwaji, ‘Ǥoniotagodi, omokeni epoagi amaleeɡ̶aɡ̶a jakatio.’ Odaa ja ɡ̶adigititetiwaji, meetedaɡ̶awa, ‘Ajowooɡ̶odi ane icoɡ̶iticogitiwaji!’ ");
INSERT INTO kbcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Odaa menitiwaji, ‘Gemakaami ɡ̶ogiiwa, codaa geme aniiɡ̶axinitiniwace oko niɡ̶inoa ɡ̶onigotadawaanaɡ̶a.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pida nige ɡ̶adigititetiwaji, meetedaɡ̶awa, ‘Geneɡ̶ejitaɡ̶awa, ajowooɡ̶odi ane icoɡ̶iticogi. Adotonitice akaamitawece anawii ane beyagi!’ ");
INSERT INTO kbcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Niganatitiwaji Abraão, Isaque, Jacó, codaa mijotawece niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko digoida Aneotedoɡ̶oji ninioxadi, pida baɡ̶akaamitawece etiɡ̶adokoleniticogi we, odaa jaɡ̶anoenitibece, acigiceni ɡ̶adowe leeɡ̶odi me daɡ̶axa me eliɡ̶ideetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Odaa ina oko ane enagitibeci aɡ̶icaadaɡ̶a icoɡ̶oticogi, icoɡ̶oticogi nigoi, ɡ̶ocidi, wajenaɡ̶a, codaa me niwetaɡ̶a. Odaa ja nicotiniwace madi nameeja me niodaɡ̶a minitaɡ̶a ninioxadi Aneotedoɡ̶oji digoida ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Digawini! Niɡ̶ina oko iwikodadipi, ane ideitice lowiditice, niɡ̶idi jiɡ̶idiaa ideitice odoe. Odaa niɡ̶ina oko ane diniwaloetibigiwaji ane ideitice odoe, niɡ̶idi jiɡ̶idiaa ideitice owiditice.” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aniaaɡ̶ani aca lakata jonoɡ̶ototalo Jesus icoa fariseutedi, odaa moditalo, “Anotitice, emii opili leeɡ̶odi Herodes doletibige me ɡ̶adeloati!” ");
INSERT INTO kbcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Odaa Jesus ja igidi, meetediogi, “Herodes liciagi niɡ̶ina eijeeɡ̶agi ane diwaxinaɡ̶a. Emii, nigicoota, odaa enita, ‘Digawini! Niɡ̶inoa onateciɡ̶inoa nokododi, jiticoitedice niwicidi abeyacaɡ̶aɡ̶a, jicilatidi oko eelotaginadi. Odaa nige ixomaɡ̶atedice itoatadiɡ̶ida nokododi, ja jigodi ibaketedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pida leeditibige me jiotece inaigi niɡ̶inoa nokododawaanaɡ̶a. Igaataɡ̶a ayakadi diɡ̶ica anigeteɡ̶epidiɡ̶ica niɡ̶ina anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko daɡ̶a lemaɡ̶adi eledi nipodigi ditigedi nigotaɡ̶a Jerusalém.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Akaamitiwaji niɡ̶eladimigipitigi Jerusalém, jaɡ̶akamaɡ̶a anigoti niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, eleditace anigidaatiniwace niɡ̶ijo Aneotedoɡ̶oji ane niwakateetedibigaɡ̶aji. Anigenaɡ̶a liwokodi domaɡ̶a jemaa me ɡ̶adatecoɡ̶oteenitiwaji meetaɡ̶a, leeɡ̶odi me domaɡ̶a jemaa me idoweditaɡ̶alocotiwaji, macataɡ̶a naɡ̶ana okoɡ̶okoodi me ixomodatediwece lionaɡ̶a catiwedi labadi. Pida aɡ̶emaanitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Natigide, digawini! Ǥanigotaɡ̶atiwaji aɡ̶aleeɡ̶ica ane dowediteloco. Odaa ejitaɡ̶awatiwaji, aɡ̶aleeɡ̶ica madatitiwaji nigepaaɡ̶icota niɡ̶ica noko menitiwaji, ‘Ninitedibece Niɡ̶inoa anenagi, anida naɡ̶atetigi Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji!’” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ica noko me saabado, Jesus dakatediwece liɡ̶eladi ica lacilo fariseutedi ane node maniodi. Odaa icoa fariseutedi eledi onidi moiɡ̶oaditalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jiɡ̶igo Jesus lodoe ica ɡ̶oneleegiwa eelotaginaɡ̶a, nadedi libaaɡ̶atedi, loɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Odaa Jesus ja igetediogi niɡ̶idiwa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, idiaaɡ̶idiwa fariseutedi, meetediogi, “Mige oyoli ɡ̶onajoinaɡ̶aneɡ̶eco daɡ̶a jicilatidi niɡ̶ina eelotaginaɡ̶a ina noko me saabado, oɡ̶oa, aɡ̶oyoli?” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pida aɡ̶oigidi. Odaa Jesus ja dibate niɡ̶ijo ɡ̶oneleegiwa. Naɡ̶a icilatidi, odaa ja imonya mopi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Odaa Jesus ja igetediogi, meetediogi, “Ina diɡ̶ica ɡ̶adionigi ane daxaboketinece nalice, migetaɡ̶a ɡ̶anoɡ̶odinaɡ̶atiwaji, odaa migetaɡ̶a adinopaɡ̶atitibece manoɡ̶aa leeɡ̶odi me saabado? Oɡ̶oa domige odaa aɡ̶anoɡ̶aa leeɡ̶odi me saabado?” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Odaa aɡ̶oyakadi moigidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus iwitediogi niɡ̶ica oko nodenigipi oniwitedi limetiidi odoletibige niɡ̶ina nimedi ane daɡ̶axa mele. Odaa ja yatemati natematigo anida ane ɡ̶odiiɡ̶axi, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Niɡ̶ina nigakaami nodenigi midi nadoneɡ̶egi, jinaɡ̶anicooteloco baancotedi ane daɡ̶axa mele. Igaataɡ̶a eji meledi onode eledi oko ane daɡ̶axa me ɡ̶oneɡ̶egi ane daɡ̶a ɡ̶adiciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Odaa niɡ̶ijo ane ɡ̶adodeni, diɡ̶icotaɡ̶awa ijaaɡ̶ijo niɡ̶ijo eledi nodenigi, odaa meetaɡ̶awa, ‘Ajicita ɡ̶amedi niɡ̶ida eledi yodenigi.’ Odaa jaɡ̶aniboliki, odaa jaɡ̶anicooteloco nimedi ane deɡ̶ele. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pida niɡ̶ina nigakaami nodenigi nalooɡ̶o, anicooteloco niɡ̶idi nimedi ane daɡ̶a ɡ̶oneɡ̶egi. Odaa niɡ̶ida ane ɡ̶adodeni igo makaamita, meetaɡ̶awa, ‘Yokaaɡ̶edi, anagi, anicooti digoina miditaɡ̶a nimedi anele.’ Joaniɡ̶idaaɡ̶ee ɡ̶adeloɡ̶oteeni lodoe iditawece niɡ̶idi lodenigipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Igaataɡ̶a niɡ̶ina oko anepaa doletibige me yeloɡ̶o, nigidiaaɡ̶idi icota me diniwikodetibece. Pida niɡ̶ina ane diniwikodetibece, nigidiaaɡ̶idi icota me yeloɡ̶o.” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus meeteta niɡ̶ijo ane node, “Ina nigawiite niweenigi nelegi me yaxoɡ̶o-noko, oɡ̶oa, mige ɡ̶ocidi, jinaɡ̶anodeni ɡ̶adokaaɡ̶etedi, ɡ̶anioxoadipi, codaa me ɡ̶aditacepodi, migetaɡ̶a ɡ̶adipecaɡ̶awepodi ane liicotedi. Leeɡ̶odi nigidiaaɡ̶idi jaɡ̶aɡ̶a etiɡ̶adodeni, odaa ja micataɡ̶a deɡ̶etiɡ̶adediani. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pida nigica mawii nalokegi, anodeni madewetedipi, alejaadotedi, inoa ane daɡ̶a yakadi mewaligitibigiwaji, etoinadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Odaa Aneotedoɡ̶oji ɡ̶adibinieni. Igaataɡ̶a aɡ̶ica nimaweneɡ̶egi niɡ̶idi deɡ̶etiɡ̶adediani. Odaa Aneotedoɡ̶oji yajigotedaɡ̶awa anele niɡ̶ica noko nigeote me newiɡ̶atace niɡ̶ina oko ane iɡ̶enaɡ̶atibigiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anigepidiɡ̶ijo niɡ̶ijo oko anidiaaɡ̶i maditaɡ̶a nameeja miniwataɡ̶a Jesus wajipatalo niɡ̶ijoa lotaɡ̶a, odaa meetalo, “Niɡ̶ica ane nicotiniwace maditaɡ̶a nameeja me nalooɡ̶o digoida ninioxadi Aneotedoɡ̶oji, niɡ̶idi icota me daɡ̶axa me ninitibigiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pida Jesus meeteta, “Ica ɡ̶oneleegiwa one dodenaɡ̶a node eliodi oko miditaɡ̶a lalokegi aneote. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Niɡ̶icota aca lakata nalokegi, odaa ja iiɡ̶e liotagi me nodetece oko, mee, ‘Anagitiwaji, inoatawece ja igo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pida iditawece idokida lowoogo, jeɡ̶ecoɡ̶otace owote inoa linetedi. Niɡ̶ica odoejegi nodenigi meeta niɡ̶ida niotagi, ‘Ibeyacaɡ̶adi jinoojeteta nipodigi, leeditibige mejigo jiwi. Jipokotalo ɡ̶aniotagodi me daɡ̶a yakaditeda me beyagi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Odaa niɡ̶ini eledi nodenigi meeta, ‘Jinoojeteta dooze lacilodi ewalaile. Ecoɡ̶otace ejigo jiwi migele me nibaaɡ̶a. Jipokotalo ɡ̶aniotagodi me daɡ̶a yakaditeda me beyagi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Odaa niɡ̶ica eledi mee, ‘Ajakadi mejigo, ibeyacaɡ̶adi gela me jado. Joaniɡ̶idaa leeɡ̶odi daɡ̶a jakadi mejigo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Odaa niɡ̶ijo niotagi ja dopitijo, ja yatematita niɡ̶ini niotagodi, odaa ja deliɡ̶ide. Odaa meeta liotagi, ‘Emii ɡ̶adediiki, emiitece ladicotiidi, ina ladicotiidawaanaɡ̶a diimaɡ̶a, odaa anadeegi niɡ̶inoa madewetedi, inoa alejaadotedi, ina ane deɡ̶ewaligi, etoinadi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Niɡ̶idiaaɡ̶idi ja dopitijo niɡ̶ijo niotagi, odaa mee, ‘Iniotagodi, ja jaote ijoatawece ane ɡ̶adiiɡ̶enatakaneɡ̶eco, pida eɡ̶idiwa nimetiidi iiɡ̶otedice.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Odaa niɡ̶ijo niotagodi meeta niɡ̶ijo liotagi, ‘Emii iwitece naicoli, naicolawaanaɡ̶a wetice nigotaɡ̶a. Awii me nakatiobece oko digoina iɡ̶eladi nigepaa nolee. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Igaataɡ̶a ejitaɡ̶awatiwaji, otiɡ̶initece niɡ̶ijo odoejegipi nodenigipi aniodi digoina yalokegi.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eliodi oko anodiotece Jesus me diniwiaje, naɡ̶a noletedijo, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Niɡ̶ina anenagi meetaɡ̶a, ayakadi me niotibici, nige deɡ̶ewi me idemaa caticedi me liciagi me yemaa eliodi, eliodo, lodawa, lionigipi, nioxoadipi, niwaalepodi, codaa miniaaɡ̶ini. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Niɡ̶ina ane daɡ̶a igotema me dawikode nigepaa yeleo, codaa aniotici, niɡ̶ini ayakadi miniɡ̶ina ane niotibici. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Niɡ̶ina akaamiteloco nige ɡ̶adowoogo mawii ɡ̶adiɡ̶eladi nelegi, odoejegi leeditibige manicooti owoo ane liwokodi yajigo odaa awini migabo mediani. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nige doɡ̶owoo ane liwokodi, doidetibige me idioka oeni lipodaɡ̶aladi, pida aɡ̶initawece agoti diimigi. Odaa niɡ̶ina oko anonadi niɡ̶ida niciagi oyame. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Odaa joɡ̶odi, ‘Niɡ̶ini ɡ̶oneleegiwa domaɡ̶a yoe liɡ̶eladi, pida aigodi libakedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Niɡ̶ina diɡ̶ini inionigi-eliodi anidiwa deez miili niodaɡ̶awadi daɡ̶a doletibige me ideleɡ̶e niɡ̶ini eledi inionigi-eliodi ane iwitideɡ̶eta, nadeegi onokotece ɡ̶odigoti miili iodaɡ̶awadi. Odoejegi ecoɡ̶otace nicotini, doletibige me yowooɡ̶odi migica loniciwaɡ̶a me ideleɡ̶e niɡ̶ini eledi inionigi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nige yakadi ina me daɡ̶a abotege, odaa niboloitee malee leegitege niɡ̶ini eledi, odaa ja imonya liiɡ̶exedi igetece niɡ̶ini eledi inionigi niɡ̶ica ane yemaa eotibige me daɡ̶alee ideleɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Joaniɡ̶idaaɡ̶ee aɡ̶ica niɡ̶ina akaamiteloco ane yakadi me niotibici nige daɡ̶a ika idiwatawece icoa ane nepilidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Odaa eɡ̶idaa diitigi me dotaɡ̶a Jesus, mee, “Niɡ̶ina yoci eletema inoatawece, pida niganiaditema libayodaɡ̶a, aɡ̶ica ɡ̶onimaweneɡ̶egi daɡ̶a jaoɡ̶atace me bayodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Odaa aɡ̶aleeɡ̶eletema iiɡ̶o, oteɡ̶exaaɡ̶aɡ̶a eletema me iniboloiteenaɡ̶a, pida idoka eletema me jalataɡ̶a. Ane yemaa me wajipatalo iiɡ̶axinaɡ̶aneɡ̶eco, atacolitece!” ");
INSERT INTO kbcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ica noko eliodi niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi, idiaaɡ̶idi ica eledi oko anodi me daɡ̶axa me abeyacaɡ̶aɡ̶a, igotibeci odipegitalo Jesus mowajipatalo latematiko. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pida idiwa icoa fariseutedi, icaaɡ̶icoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, eliodi moyalomeɡ̶e Jesus, modi, “Niɡ̶idoa ɡ̶oneleegiwa dibatetege niɡ̶inoa ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a, codaa ligiiwepodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Odaa Jesus ja yatemati ica natematigo ane ɡ̶odiiɡ̶axi, meetediogi, ");
INSERT INTO kbcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Niɡ̶ida makaamitiwaji diɡ̶ini anidiwa onaniteci taalia niwaxacocoli, odaa daɡ̶aca ananiaditibige. Ajawienatakanaɡ̶a me igo doletibige, ecoɡ̶otace yoya niɡ̶ijoa eletidi ane yeyaɡ̶atedice digoida nipodigi. Odaa jiɡ̶igo doletibige naɡ̶ajo waxacoco ananiadi nigepaa yakadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nigidiaaɡ̶idi nige yakadi naɡ̶ajo waxacoco, odaa ja yoyaɡ̶adi, eliodi me ninitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nigicota liɡ̶eladi, odaa jeɡ̶eniditiogi lokaaɡ̶etedi, lipecaɡ̶awepodi, odaa meetiogi, ‘Jemaa makaami inikaɡ̶awepodi, leeɡ̶odi idinitibeci me jakadi naɡ̶ajo iniwaxacoco ananiadi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ejitaɡ̶awatiwaji jiɡ̶idaaɡ̶ee, iditawece ane idei digoida ditibigimedi ninitibigiwaji niɡ̶ina mini ane dinilaatece libeyaceɡ̶eco niɡ̶ina oko abeyaceɡ̶egipi, pida baadaɡ̶a ninitibigiwaji leeɡ̶odi niɡ̶ina eledi oko anodiletibige daɡ̶a iɡ̶enaɡ̶atibigiwaji, codaa anodi me daɡ̶alee leeditibige me dinilaatibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Daɡ̶a aca iwaalo anidiwa deez nibeexotedi daɡ̶aniadi onaniteci, ajawienatakanaɡ̶a migo doletibige. Yalegi loledaɡ̶axi, yoladitice liɡ̶eladi, doletibige nigepaa yakadi naɡ̶ajo beexo. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Naɡ̶a yakadi naɡ̶ajo beexo, odaa jeɡ̶eniditiogi lokaaɡ̶etedi, lipecaɡ̶awadi, odaa meetiogi, ‘Jemaa makaami inikaɡ̶awepodi leeɡ̶odi idinitibeci me jakadi inibeexo ananiadi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ejitaɡ̶awatiwaji, jiɡ̶idaaɡ̶ee Aneotedoɡ̶oji niaanjotedi me ninitibigiwaji leeɡ̶odi me dinilaatece libeyaceɡ̶eco niɡ̶ina oko aniatagigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Odaa Jesus meetetiogi, “Ica ɡ̶oneleegiwa onidiwa iniwataale lionaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ica noko niɡ̶ica baɡ̶alee lioneeɡ̶a lionigi meeta eliodi, ‘Eiodi, jemaa manajicitediwa niɡ̶icoa ane inepilidi ane domaɡ̶a jibatege nige ɡ̶adelewi.’ Odaa ja yawalace ane nepilidi nediatiniwace niɡ̶idoa itoataale lionaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aɡ̶ica doɡ̶owidi nokododi niɡ̶ijo baɡ̶alee lioneeɡ̶a lionigi ja nioda idiwatawece ane noɡ̶etedi, odaa ja noditice, jiɡ̶igo ica eledi iiɡ̶o ane leegita. Odaa oneliodi me dalotibece, wacipetibece, codaa me itineɡ̶e awicijipi, yaaɡ̶adi ijoatawece niɡ̶icoa noɡ̶etedita eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Niɡ̶idiaaɡ̶idi naɡ̶a yaaɡ̶adi ijoatawece icoa ane nepilidi, pida jaɡ̶aɡ̶a icota nigigi niɡ̶idi nipodigi. Odaa ja dawikode. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Niɡ̶idiaaɡ̶idi jiɡ̶igo doletibige libakedi miditaɡ̶a niɡ̶eladimigipitigi niɡ̶idi nipodigi, odaa ja yakadi necalailegi iiɡ̶e me yowie nigidagiwadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Odaa leeɡ̶odi me daɡ̶axa me nigicile, ja domaɡ̶a yemaa me yeligo nigidagiwadi liweenigi, leeɡ̶odi aɡ̶oyediatece ane yeligo. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pida naɡ̶a eliodi me dowooko, meetigi le, ‘Eiodi idiwa owidi liotaka, inoa liweenaɡ̶a caticedi me liciagi ane jopotibige, emeɡ̶ee ite ee digoina ja ideloadi nigigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Natigide ja jopita eiodi liɡ̶eladi. Nigejota, odaa ejita, “Eiodi, jao ane beyagitema Aneotedoɡ̶oji, codaa makaami. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Natigide aɡ̶alee yakadi deɡ̶enitiwa me ee ɡ̶adionigi, leeɡ̶odi aɡ̶ee oko anele. Pida jemaa mawii ibakedi liciagi niɡ̶inoa ɡ̶adiimetedi.” ’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naɡ̶a ika me dowooko, odaa jiɡ̶igo opita eliodi. Odaa niɡ̶ijo lioneeɡ̶a eleegitege, odaa niɡ̶ijo eliodi ja naditege. Odaa eliodi me iwikodetege. Naɡ̶a walokoditege lionigi, ibedotece, napicoɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Odaa niɡ̶ijo lioneeɡ̶a meeta eliodi, ‘Eiodi, jao ane beyagitema Aneotedoɡ̶oji, codaa makaami. Aɡ̶alee yakadi deɡ̶enitiwa me ee ɡ̶adionigi, leeɡ̶odi aɡ̶ee oko anele.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pida niɡ̶ijo eliodi, meetiogi liotaka, ‘Ǥadediiki manadeegi naɡ̶aca ane daɡ̶axa me libiniena jayogo anixomeɡ̶enitinigi. Awii libaaɡ̶ateje ixomitiwece nibedona, codaa awiite liwelatedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Codaa awii abaata wacawaanigi ane daɡ̶axa majakalo, eloati, jaoɡ̶a nalokegi, ɡ̶odinitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Igaataɡ̶a niɡ̶ida ionigi ane dopitijo, micataɡ̶a daɡ̶a yeleo, odaa ja yewiɡ̶atace, codaa aniadi, noɡ̶okaanaɡ̶a jakataɡ̶a.’ Odaa joɡ̶owo nalokegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Niɡ̶ijo lionigi boɡ̶oxiiɡ̶odi ideitice nipodigi, naɡ̶a dopitio, niɡ̶ipegitio liɡ̶eladi, ja wajipatalo natenaɡ̶aneɡ̶eco, ica oko dayaagetiogi me nalooɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Odaa jeɡ̶enidita anigepidiɡ̶ijo niɡ̶idiwa liotaka, naɡ̶a ige, meeta, ‘Amiidi ica ayaagi?’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Odaa ja igidi, meeta, ‘Ǥanioxoa ja dopitijo, mele. Joaniɡ̶idaa leeɡ̶odi ɡ̶adiodi diiɡ̶enataka moyeloadi wacawaanigi ajakalo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Niɡ̶ijo boɡ̶oxiiɡ̶odi lionigi ja deliɡ̶ide, odaa ayemaa me dakatio. Odaa eliodi ja noditicogi we, domaɡ̶a yemaa me yadeegitio, yocaɡ̶aneɡ̶etibigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pida naɡ̶a igidi eliodi, meeta, ‘Digawini! Joɡ̶owidi nicaaɡ̶ape me jibataɡ̶adomi, liciagi niɡ̶inoa ɡ̶aotaka. Aɡ̶ica daɡ̶a ɡ̶adotigimadeni. Pida aɡ̶ica daɡ̶anajicitiwa oteɡ̶exaaɡ̶aɡ̶a waxigida me jeloadi daɡ̶a jao nalokegi me inode yokaaɡ̶etedipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Niɡ̶ini ɡ̶adionigi ane yaaɡ̶adi ɡ̶aninyeelo, yaaɡ̶aditeloco iwaalepodi agopeloaɡ̶a, odaa neɡ̶eno, jeɡ̶eloatitema wacawaanigi ajakalo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Odaa niɡ̶ijo eliodi meeta, ‘Ionigi, idioka limedi makaami meetaɡ̶a. Odaa inoatawece ane inepilidi, akaami ɡ̶anepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pida baɡ̶a leeditibige me jaoɡ̶a nalokegi me ɡ̶odinitibece. Leeɡ̶odi niɡ̶ida ɡ̶anioxoa micataɡ̶a daɡ̶a yeleo, odaa niɡ̶idiaaɡ̶idi ja yewiɡ̶atace. Micataɡ̶a daɡ̶aniadi, niɡ̶idiaaɡ̶idi noɡ̶oyakadi!’” ");
INSERT INTO kbcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus meetediogi niɡ̶ijo anodiotibece, “Ica ɡ̶oneleegiwa liico, oninica liotagi ane iiɡ̶e icoa libaketedi. Odaa joniɡ̶ica anenagitibeci minitaɡ̶a niɡ̶ini ɡ̶oneleegiwa liico, odaa joɡ̶oyatematita niɡ̶ijo liotagi me yaaɡ̶adi ninyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Odaa jeɡ̶enidita niɡ̶ijo liotagi, meeta, ‘Ewi ijo anonatematitiwa? Natigide jemaa maneloɡ̶otitediwa icoatawece niɡ̶icoa ɡ̶adaakataka, jilakidenaɡ̶atedi ɡ̶anaalewe, leeɡ̶odi niɡ̶ina natigide aɡ̶alee iiɡ̶eni niɡ̶inoa ibaketedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Odaa niɡ̶ijo liotagi meetibige le, ‘Inecalailegi ja idikatice. Amigini ica ane jao? Ajakadi me jiba daɡ̶a inaligi iiɡ̶o, codaa idiboliɡ̶a daɡ̶a jipokotibige dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pida ja jowooɡ̶odi ane inimaweneɡ̶egi modibatigi niɡ̶ina niɡ̶eladimigipi midiwataɡ̶a liɡ̶elatedi, nige idiiɡ̶e inecalailegi me jopi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Odaa niɡ̶ijo niotagi jeɡ̶eniditiogi niɡ̶ijo anonaalewe necalailegi. Odaa jeɡ̶eeta niɡ̶ijo odoejegi, ‘Igame liwokodi manaaleweeni inecalailegi?’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Odaa niɡ̶ijo ɡ̶oneleegiwa mee, ‘Jinaalewe onaniteci taalia bootitedi najidi.’ Niɡ̶ijo niotagi mee, ‘Digawini analee liwokodi ɡ̶anaalewe. Idiitini manaaleweeni meya-taalia bootitedi najidi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Odaa jeɡ̶eeta niɡ̶ijo eledi anenotio, ‘Apaɡ̶a akaami, igame liwokodi ɡ̶anaalewe?’ Odaa jeɡ̶ee, ‘Jinaalewe onaniteci taalia jaacotedi leyeema.’ Odaa niɡ̶ijo niotagi mee, ‘Idiitedini manaaleweeni onexaa oiteenta jaacotedi leyeema.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Igaanaɡ̶a yowooɡ̶odi niɡ̶ijo necalailegi niɡ̶ijo niotagi ane daɡ̶a yakadi me jinakatonaɡ̶a, odaa ja iweniɡ̶ide leeɡ̶odi niɡ̶ida anee. Leeɡ̶odi niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o, baɡ̶a daɡ̶axa me niwaxinaɡ̶anaɡ̶a, niɡ̶ina mowote noojetekico caticedi me liciagi niɡ̶ina oko anida aneetege nilokokena Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ejitaɡ̶awatiwaji mabakeni niliicaɡ̶ajetecidi niɡ̶ina iiɡ̶o bidige ina ɡ̶adokaaɡ̶etedipi, awiitibige nige daɡ̶aleeɡ̶icoa niɡ̶ijoa ɡ̶aniliicaɡ̶ajetecidi, odaa Aneotedoɡ̶oji ja dibatedaɡ̶agi me ɡ̶adiɡ̶eladi digoida ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Niɡ̶ina ane yakadi me jinakatonaɡ̶atema niɡ̶inoa anicinoa ane diɡ̶ica jaoɡ̶ate, odaa yakadi me jinakatonaɡ̶atema niɡ̶inoa anicinoa anida ane jaoɡ̶ate. Pida niɡ̶ina ane daɡ̶a yakadi me jinakatonaɡ̶atema niɡ̶inoa anicinoa ane diɡ̶ica jaoɡ̶ate, odaa ayakadi daɡ̶a jinakatonaɡ̶atema niɡ̶inoa anicinoa anida ane jaoɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Enice nige daɡ̶a yakadi metiɡ̶adinakatonitema niɡ̶inoa niliicaɡ̶ajetecidi niɡ̶ina iiɡ̶o, amiijo ica ane ɡ̶adinakatonitema niɡ̶icoa beɡ̶ewi me ɡ̶oniliicaɡ̶ajetecidi? ");
INSERT INTO kbcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Niɡ̶ina nige daɡ̶awiitetiwaji niɡ̶ica ane iɡ̶enaɡ̶atema niɡ̶inoa ane nepilidi eledi oko, amiijo ica ane yajigotaɡ̶awa ica ane ɡ̶anebi? ");
INSERT INTO kbcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Aɡ̶ica ane yakadi me dibatema iniwataale necalaixedi, igaataɡ̶a ini ane daɡ̶a yemaa, odaa iniaaɡ̶eledi baɡ̶a lemaanigi, domige ini ane nienaɡ̶aneɡ̶e, odaa iniaaɡ̶eledi aɡ̶alee deemitetibige. Odaa joaniɡ̶idaaɡ̶ee aɡ̶akati mabaatema Aneotedoɡ̶oji, nige leedi mawiite inoatawece onidaaɡ̶ida manigaanyetece dinyeelo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Icoa fariseutedi anowajipatalo lotaɡ̶a Jesus, jonoɡ̶oyame leeɡ̶odi daɡ̶axa moyemaa dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Odaa Jesus meetediogi, “Niɡ̶ina makaamitiwaji oleetibige niɡ̶ina oko modi ica makaami oko ane iɡ̶enaɡ̶a, pida Aneotedoɡ̶oji baɡ̶a yowooɡ̶oditediwece ɡ̶adaaleɡ̶enali. Igaataɡ̶a niɡ̶inoa ganicinoa analeetibige daɡ̶a diniwaloe, Aneotedoɡ̶oji yakadi me diɡ̶ica ane jaoɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Aneotedoɡ̶oji domaɡ̶a yemaa niɡ̶ina oko me niiɡ̶axinaɡ̶anaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, codaa modiiɡ̶axinaɡ̶atece lotaɡ̶a niɡ̶ijo jotigide Aneotedoɡ̶oji liiɡ̶exedi anoyeloɡ̶oditedibece lowooko. Aneotedoɡ̶oji domaɡ̶a yemaa doɡ̶odiiɡ̶axinaɡ̶atece niɡ̶inoa notaɡ̶a deɡ̶epaaɡ̶eno João Batista. Pida niɡ̶ijo maleeɡ̶ijo João, idokee me jeloɡ̶otaɡ̶a ɡ̶obodicetedi anele anodaaɡ̶eeteda Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko. Odaa natigide digawiniteloco inatawece oko ja dinoniciwaɡ̶aditibigiwaji me dinawanaɡ̶aditege niɡ̶ina noiigi ane iiɡ̶e Aneotedoɡ̶oji laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Icota me daa ditibigimedi, codaa me iiɡ̶o, pida baɡ̶a dakake monidateci ligegi inoɡ̶aaɡ̶a liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Diɡ̶ica ɡ̶oneleegiwa ane iticoitice lodawa, odaa ja lodawa eledi iwaalo. Odaa niɡ̶ini ɡ̶oneleegiwa ja doɡ̶olaɡ̶ataka. Odaa diɡ̶ica eledi ane lodawa naɡ̶ani iwaalo ane oiticoitice, odaa jaɡ̶aɡ̶a doɡ̶olaɡ̶ataka. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ica ɡ̶oneleegiwa liico ane dinixotinigilo nowoodi libinienaɡ̶a ane dakake loojedi. Eotibiga nalokeco, codaa ele maniodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pida onaɡ̶aɡ̶ini ica ɡ̶oneleegiwa madewedi ane liboonaɡ̶adi Lázaro, one diwexege lolaadi. Idiaaɡ̶itibige lapoagi liɡ̶eladi niɡ̶ini ɡ̶oneleegiwa liico. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro walitibigege latijedi niɡ̶ini liico maniodi naɡ̶aleekoka aaɡ̶aɡ̶a aniodi. Icoa necexodi one onapitibece liwexegadi Lázaro. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Niɡ̶ijo ɡ̶oneleegiwa madewedi niɡ̶idiaaɡ̶idi ja yeleo, odaa aanjotedi joɡ̶oyadeegi liwigo me nicote liwai Abraão miditaɡ̶a nalooɡ̶o digoida ditibigimedi. Niɡ̶idiaaɡ̶idi niɡ̶ijo ɡ̶oneleegiwa liico jaɡ̶aɡ̶a yeleo, odaa joɡ̶onaligitini. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Odaa beɡ̶eliodi me dawikode digoida lawikodadi émaɡ̶aɡ̶a. Igaanaɡ̶a noletibige, odaa ja nadi Abraão digoida ditigedi, iniaa Lázaro liwai Abraão. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Odaa ja dapaawe mee, ‘Eiodi Abraão, adiwikodeni! Anieni Lázaro me itiminatidi nibedona, amaleeɡ̶aɡ̶a ilege yoceligi, igaataɡ̶a ja daɡ̶axa me jawikode minataɡ̶a niɡ̶ina noledi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraão naɡ̶a igidi, meeta, ‘Ionigi, analakitibige makati inoatawece anele malee ɡ̶adewiki digoida iiɡ̶o, iniaa Lázaro inoka dibatege ane beyagi. Pida natigide Lázaro ja ilaɡ̶atini, akamaɡ̶akaami baanaɡ̶a awikodee. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Codaa eleditace ida nelegi wakagi iiɡ̶o ane ɡ̶odawalacetiwage digoina ɡ̶odiwigotigi, aneotibige me daɡ̶a yakadi me diɡ̶etita ane domaɡ̶a yemaa migo digoida daato makaamitaɡ̶a, oteɡ̶exaaɡ̶aɡ̶ica ane yakadi me niɡ̶etita digoina naato mokotaɡ̶a.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Odaa niɡ̶ijo liico mee, ‘Enice, eiodi Abraão, jipokotaɡ̶awa, iiɡ̶eni Lázaro digoida liɡ̶eladi eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Igaataɡ̶a idiwa nigotini ɡ̶obaaɡ̶adi inioxoadipi. Iiɡ̶eni Lázaro me ibodicaxi inioxoadipi me deɡ̶enagitibeci niɡ̶ina anejo me jawikode.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraão naɡ̶a igidi, meeta, ‘Miditaɡ̶a ɡ̶anioxoadipi idiwa notaɡ̶anaɡ̶axiidi ane iditedini Moisés, ijaaɡ̶ijoa anoidi niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. Ikani ɡ̶anioxoadipi mowajipatalo lotaɡ̶a niɡ̶ijoa notaɡ̶anaɡ̶axiidi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Niɡ̶ijo liico mee, ‘Oɡ̶oa, eiodi Abraão, aɡ̶owajipatalo. Pida diɡ̶ica ane yewiɡ̶atace, diɡ̶igo datematikatema, odaa boɡ̶odinilaatece libeyaceɡ̶eco.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pida Abraão naɡ̶a igidi, meeta, ‘Nige doɡ̶owajipatalo niɡ̶ijoa notaɡ̶a ane iditedini Moisés, ijaaɡ̶ijoa lidiko niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, odaa idaaɡ̶ee diɡ̶ica ane yewiɡ̶atace, idokee doɡ̶oyiwaɡ̶adi.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus meetediogi niɡ̶ijo anodiotibece, “Ajawienatakanaɡ̶a midioka limedi menagi aneo niɡ̶ina oko mowo loenatagi ane beyagi! Pida Aneotedoɡ̶oji eliodi me iloikatidi niɡ̶ina aneo eletidi oko mowo ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Niɡ̶ina aneo anigepidiɡ̶ica niɡ̶ina nigaanigipawaanigi mowo ane beyagi, domeɡ̶eletema doɡ̶oigoetece lotoinaɡ̶adi naɡ̶ana wetiɡ̶a ane iwaaɡ̶adi, oditaɡ̶a oyokoletinigi akiidi-eliodi. Pida daɡ̶axa me beyagitema niɡ̶ina meo niɡ̶ina nigaanigipawaanigi moyoe ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ina baɡ̶a adinoetitiwaji! Niɡ̶ina ɡ̶anioxoa deɡ̶eo ane beyagitaɡ̶adomi, oxoki. Odaa nige dinilaatibece, ixomaɡ̶ateenitedice icoatawece niɡ̶icoa aneotaɡ̶adomi ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Deɡ̶eo seete ane beyagitaɡ̶adomi noko, odaa seete maɡ̶aɡ̶a igo makaamitaɡ̶a, odaa meetaɡ̶awa, ‘Ja idinilaatibece’, odaa ixomaɡ̶ateenitedice icoatawece niɡ̶icoa aneo ane beyagitaɡ̶adomi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niɡ̶ijoa liiɡ̶exedi joɡ̶odipokotalo Ǥoniotagodi, odaa moditalo, “Ǥoniotagodi, ɡ̶odaxawaneɡ̶egi aleeni ɡ̶otiwaɡ̶atakaneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Odaa Ǥoniotagodi jeɡ̶eetediogi, “Nigokateciɡ̶ini ɡ̶atiwaɡ̶atakaneɡ̶egi, macataɡ̶a naɡ̶ana lolagi ‘mostaada’ ane daɡ̶axa me lionawaana, odaa akatitiwaji me iiɡ̶eni niale nelegi, me enitatiwaji, ‘Adinawaceni, odaa emii adinananiti digoida miditaɡ̶a akiidi-eliodi!’ Odaa naɡ̶ada niale ɡ̶adadiwaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Diɡ̶ica ganigepidiɡ̶ijo niɡ̶ina akaamitiwaji anini ɡ̶aotagi ane dibateloco nixoɡ̶otagi, oɡ̶oa, migetaɡ̶a yowie waxacocoli. Niɡ̶ina naɡ̶a dopitio me icoɡ̶oticogi nipodigi, migetaɡ̶a enita? ‘Anagi, anicooti madi nameeja, aniodi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pida aɡ̶enita! Pida baɡ̶a enita, ‘Oenitomi iweenigi, codaa iikoeni ɡ̶adowoodi manadeegitiwa iweenigi, aliitiwa nigepaa idiaadi me jiniodi, codaa me jacipe. Odaa nigidiaaɡ̶idi baɡ̶akamaɡ̶a adinediani maniodi, codaa macipe.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aleeditibige me iniotagodeeɡ̶ata niotagi leeɡ̶odi niɡ̶ina meo niɡ̶ina anoiiɡ̶eta me yoe. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Odaa akaamitiwaji idaaɡ̶eni. Nigidiaaɡ̶idi nigagoti mawiite icoatawece niɡ̶icoa anetiɡ̶adiiɡ̶enitalo mawiite, odaa enitiwaji, ‘Aleeditibige doɡ̶odiniotagodetoɡ̶owa, leeɡ̶odi oko niotagipi, codaa jaoɡ̶ate inokinoa niɡ̶inoa anoniiɡ̶etedoɡ̶owa me jaoɡ̶ate.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus eɡ̶idaa diitedicogi me diniwiajetedicogi manitaɡ̶a nigotaɡ̶a Jerusalém. Odaa inaaɡ̶igotetece midiwa nipodaɡ̶a Galiléia, aniaa Samaria. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Niɡ̶ijo naɡ̶a nipegi me dakatediwece aca nigotakawaana, odaa jiɡ̶igotibeci odakapetege icoa deez ɡ̶oneleegiwadi dawace-loolatedi. Odaa ja dabiditiniwace, pida leegitiogi moyetecetedice Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Odaa ja napaawaɡ̶a dinigetaɡ̶ateetibigiwaji, modi, “Jesus, Ǥoniotagodi, ɡ̶odiwikodeneɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Niɡ̶ijo Jesus naɡ̶a naditediogi, odaa jeɡ̶eetediogi, “Emii midiwataɡ̶a sacerdotitedi, adinikeenitiogi naɡ̶a ɡ̶adicilitiwaji.” Odaa eɡ̶idaa diiticogi mewaligitibigiwaji, codaaɡ̶ida naɡ̶a nicilaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Odaa ganigepidiɡ̶ica niɡ̶ijoa ɡ̶oneleegiwadi naɡ̶a nadi me icí, odaa ja dopitege Jesus, igedi me dotaɡ̶a, doɡ̶etetibigimece Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Niɡ̶icotalo Jesus, odaa ja yamaɡ̶atedini lokotidi lodoe, diniotagodetalo. Niɡ̶ijo ɡ̶oneleegiwa ane diniotagodetalo, samaritaano. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus mee, “Ijoa deez ɡ̶oneleegiwadi ane nicilaɡ̶a. Odaa igame diɡ̶etedigi ijoa eletidi noove? ");
INSERT INTO kbcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Agodiɡ̶ica eledi ane dopitijo me doɡ̶etetibigimece Aneotedoɡ̶oji, pida tibiginiokini niɡ̶ini ane daɡ̶a ɡ̶odoiigi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Odaa Jesus jeɡ̶eeteta, “Adabititini, odaaɡ̶emii opili! Ja ɡ̶adicili, leeɡ̶odi me iwaɡ̶ati Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Icoa fariseutedi joɡ̶oige Jesus ica Aneotedoɡ̶oji nige iiɡ̶e inatawece niɡ̶ina oko. Naɡ̶a igidi, meetediogi, “Aneotedoɡ̶oji aɡ̶inatawece ikeetediogi nige limedi me iiɡ̶e laaleɡ̶enali oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aɡ̶ica anee, ‘Digawini! Ǥoninionigi-eliodi etiniwa digoina!’ Oɡ̶oa, domigetaɡ̶a ee, ‘Ǥoninionigi-eliodi etiniwa digoidane!’ Igaataɡ̶a Aneotedoɡ̶oji iniwa me diiɡ̶enataka catiwedi ɡ̶adaaleɡ̶enali.” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Odaa jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Icota meliodi memaani madatitace niɡ̶ica noko Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige janagi jiiɡ̶e inatawece iiɡ̶o, pida aɡ̶adatitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Odaa niɡ̶ina eledi oko moditaɡ̶awa, ‘Digawini! Etiniwa digoida!’ Oɡ̶oa, migetoɡ̶odi, ‘Etiniwa digoina!’ Pida jineɡ̶emiitiwaji, oteɡ̶exaaɡ̶aɡ̶a iwitece. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Igaataɡ̶a liciagi nalebepaɡ̶a me ídi, me naloteloco ditibigimedi onidateci liwai nigepaaɡ̶eledi liwai, joaniɡ̶idaaɡ̶ee niɡ̶ica noko Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige janagi me jiiɡ̶enataka. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pida odoejegi, leeditibige me jawikode, codaa niɡ̶ina oko niɡ̶inoa nokododi aɡ̶odibatigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Niɡ̶ica niciagi liciagi niɡ̶ijoa nokododi Noé, niɡ̶ijo jotigide, odaa jiɡ̶idaaɡ̶ee niɡ̶icoa nokododi maleedaɡ̶a idopitijo Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Niɡ̶ijo jotigide niɡ̶ica oko niodaɡ̶a, owacipeta viinyo, nadonaɡ̶a, codaa moyajigo inoa lionaɡ̶a me nadonaɡ̶a. Odaa joaniɡ̶idaaɡ̶ee neɡ̶epaa niɡ̶ijo noko Noé naɡ̶a dakatiwece naɡ̶ajo etogo-nelegi. Odaa neɡ̶eno abooɡ̶o-ninyoɡ̶odi, ja yaaɡ̶adi ijotawece niɡ̶ijo oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Eleditace jiɡ̶idaaɡ̶ee niɡ̶icoa nokododi Ló, niɡ̶ijo jotigide. Ica oko niodaɡ̶a, owacipeta viinyo, oojeteeɡ̶a, oyaa elaanaɡ̶a, codaa moyoe diimaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pida niɡ̶ijo noko Ló naɡ̶a noditicogi nigotaɡ̶a Sodoma, odaa Aneotedoɡ̶oji jeɡ̶eote meniteloco noledi, codaa me wetiadi ane ídi, odaa ja nigodi ijotawece niɡ̶ijo oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Joaniɡ̶idaaɡ̶ee niɡ̶ica noko Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige idinikee. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Niɡ̶ica noko, niɡ̶ijo ananipeti ditibigimedi liɡ̶eladi, ele me daɡ̶a dinikatini me dakatiwece liɡ̶eladi daɡ̶a dibatalo niɡ̶ijo ane nepilidi anele, ade dinopaɡ̶adi melodi. Odaa niɡ̶ijo ane ideitice nipodigi aɡ̶ele daɡ̶a dopitio daɡ̶a dibatalo ane nepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Analakitibigetiwaji ane ninyaagi naɡ̶ajo Ló lodawa! (Ane yeleo, leeɡ̶odi me dinopaɡ̶adi meo ane liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji). ");
INSERT INTO kbcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Niɡ̶ina oko anidioka limedi me doletibige mepaa iiɡ̶e lewiɡ̶a, nige yeleo, odaa jaɡ̶aniatagigi. Pida niɡ̶ina oko ane yeleo me Ee leeɡ̶odi, odaa baɡ̶a yewiɡ̶atace nigidiaaɡ̶idi. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Natigide jeloɡ̶oditedaɡ̶awatiwaji niɡ̶inoa notaɡ̶a anida ane jaoɡ̶ate. Niɡ̶ica enoale itiwataale oko dinoomatewamigi, niotaɡ̶a. Onijoteci oyadeegitibigi, idiaaɡ̶eledi baɡ̶a nenyaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Iniwataale iwaalepodi onidi leyeema. Onaniteci oyadeegitibigi, aniaaɡ̶eledi baɡ̶a nenyaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Itoataale ɡ̶oneleegiwadi nibaaɡ̶a nipodigi. Odaa onidateci oyadeegitibigi, odaa idaaɡ̶eledi baɡ̶a nenyaɡ̶ati.” ");
INSERT INTO kbcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Odaa niɡ̶ijo anodiotibece joɡ̶oige, moditalo, “Ǥoniotagodi, igamei nige jinataɡ̶a ida niciagi?” Odaa jeɡ̶eetediogi, “Anei anigidi émeɡ̶egi, odaa jiɡ̶idiaaɡ̶i me dilapode opoedi.” (Odaa jiɡ̶idaa me jowooɡ̶otaɡ̶a ane diɡ̶etigi ganigidi émeɡ̶egi, leeɡ̶odi me jinataɡ̶a opoedi). ");
INSERT INTO kbcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus yatemati ica natematigo ane ɡ̶odiiɡ̶axitece me leeditibige niɡ̶ina oko midioka limedi me doɡ̶oibagitema moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Odaa jeɡ̶eetediogi, “Manitaɡ̶a aca nigotaɡ̶a onini ica ɡ̶oniwinoɡ̶odi ane daɡ̶a deemitetibige Aneotedoɡ̶oji, codaa aɡ̶ica ane deemitetigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naɡ̶ani nigotaɡ̶a onani aca wajekalo. Anidioka limedi me doletibige niɡ̶ini ɡ̶oniwinoɡ̶odi, dipokota me yaxawa, codaa idioka limedi meetibiga, ‘Adaxawani, codaa awii niɡ̶ica ane ilaɡ̶atice me jakapetege yaxakawa.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Igaanoɡ̶owidi nokododi ixomaɡ̶atedijo me daɡ̶a niniɡ̶odi ane yemaa. Odaa niɡ̶idiaaɡ̶idi epaa dinotaɡ̶aneɡ̶e, mee, ‘Digo aneji me daɡ̶a idoitalo Aneotedoɡ̶oji, codaa me diɡ̶ica ane jeemitetibige, jaxawa naɡ̶ajo wajekalo, leeɡ̶odi jeɡ̶eliodi me idigiwogotice. Daaditaɡ̶a jaxawa, odaa idioka limedi me doletibigiji, pida jeɡ̶eliodi me idigiwogotice.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Odaa Ǥoniotagodi jeɡ̶eetediogi, “Dige atacolitece lotaɡ̶a niɡ̶ijo ɡ̶oniwinoɡ̶odi aiɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ajawienataka Aneotedoɡ̶oji me yaxawa loiigi, anodipokotibigalo, noko codaa menoale, me yaxawatediogi, odaa eotetema niɡ̶ica ane iɡ̶enaɡ̶a modakapetege laxakawepodi. Oɡ̶oa domige dinopaɡ̶adi nige yaxawatediogi idi loiigi? ");
INSERT INTO kbcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pida ejitaɡ̶awatiwaji me age me yaxawa, codaa meote ane iɡ̶enaɡ̶a modakapetege laxakawepodi. Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige janagitace, migica jakadi oko anetidadiwaɡ̶adi digoina iiɡ̶o?” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus yatematitediogi ica eledi natematigo niɡ̶ica oko anodiletibige daɡ̶a daɡ̶axa meletibigiwaji, pida inaaɡ̶ina anoiligoiticoace eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Odaa jeɡ̶ee, “Icoa itoataale ɡ̶oneleegiwadi igotibeci Aneotedoɡ̶oji liɡ̶eladi moyotaɡ̶aneɡ̶e. Onijoteci fariseu, ica eledi baɡ̶a niɡ̶ina ane dibatibigege ninyeelo ninionigi-eliodi romaanotedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Niɡ̶ijo fariseu naɡ̶a dabiditi odaa dinigetaɡ̶atee mepaa dinotaɡ̶aneɡ̶e, mee, ‘Aneotedoɡ̶oji, iniotagodetaɡ̶awa, leeɡ̶odi aɡ̶ee oko adodigomadaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a ee oko ane daɡ̶a iɡ̶enaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a ee oko ane itineɡ̶e lodawa eledi, digo anee niɡ̶inoa eletidi ɡ̶oneleegiwadi. Eleditace iniotagodetaɡ̶awa aiciagi niɡ̶ida ɡ̶oneleegiwa ane dibatibigege ninyeelo ninionigi-eliodi romaanotedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Idinatita nigigi itoataale nokododi inoatawece domiingotedi, codaa me inidiizimo jajigotaɡ̶awa.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Niɡ̶ijo ane dibatibigege ninyeelo ninionigi-eliodi romaanotedi, idiaaɡ̶aɡ̶a itice, pida aɡ̶ipegitege. Odaa oteɡ̶exaaɡ̶aɡ̶a iwitibigimece ditibigimedi. Pida yabaketibigeloco elipije me ikee magecaɡ̶alo, odaa jeɡ̶ee, ‘Aneotedoɡ̶oji, adiwikodeni, leeɡ̶odi eemoda abeyaceɡ̶egi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ejitaɡ̶awatiwaji, niɡ̶ijo ɡ̶oneleegiwa noɡ̶opiticogi minitaɡ̶a liɡ̶eladi, Aneotedoɡ̶oji jeɡ̶eote me iɡ̶enaɡ̶a. Pida niɡ̶ijo eledi Aneotedoɡ̶oji aɡ̶eote me iɡ̶enaɡ̶a. Leeɡ̶odi niɡ̶ijo oneo mida ane jaoɡ̶a, icota moyame, pida niɡ̶ijo ane diniwikodetibece, Aneotedoɡ̶oji icota me iweniɡ̶ide.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ica noko eliodi oko oyadeegi nigaanigipawaanigi midoataɡ̶a Jesus, owotibige me dibatedeloco me ibinie. Pida niɡ̶ijo anodiotibece noɡ̶onadi, odaa joɡ̶oyolitege niɡ̶ijo anonadeegi nigaanigipawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pida Jesus eniditediogi niɡ̶ijo nigaanigipawaanigi mototalo, odaa jeɡ̶ee, “Ikani niɡ̶ina nigaanigipawaanigi menagitibeci meetaɡ̶a, codaa jinoɡ̶oliitege, leeɡ̶odi Aneotedoɡ̶oji iiɡ̶e laaleɡ̶enali niɡ̶ina ane liciagi niɡ̶ina nigaanigipawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ejitaɡ̶awatiwaji niɡ̶ina anewi, niɡ̶ina ane ikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena, liciagi niɡ̶ina nigaanigawaanigi me dibatege niɡ̶ina anodita, odaa niɡ̶ini oko baɡ̶a yakadi me dakatiwece Aneotedoɡ̶oji aneitedice digoida ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ica ɡ̶oneleegiwa ane lacilo judeutedi, igo ige Jesus, meetalo, “Ǥoniiɡ̶axinoɡ̶odi anele, amiida ica ane leeditibige me jao, odaa jiɡ̶idaa yewiɡ̶a digoida ditibigimedi miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus naɡ̶a igidi, meeteta, “Igame leeɡ̶odi ina menitiwa me Ee ele? Oniniwatece Aneotedoɡ̶oji mele, aɡ̶ica eledi anele. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Codaa noɡ̶owooɡ̶oti ijoa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji, anodi, ‘Jinaɡ̶aɡ̶olaɡ̶atakani, jinaɡ̶a aijee, jinoɡ̶olice, jiniɡ̶inaaleni eledi oko. Codaa eemiteetibige ɡ̶adiodi, codaa me ɡ̶adiodo.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Odaa niɡ̶ijo ɡ̶oneleegiwa mee, “Niɡ̶ijo maleeɡ̶ee nigaanigawaanigi naɡ̶a jeemitetibige ijoatawece niɡ̶ijoa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Niɡ̶ijo Jesus naɡ̶a wajipateta niɡ̶ijoa lotaɡ̶a, odaa jeɡ̶eete, “Eɡ̶idaa ananiaditibige mawii. Aani idiwatawece niɡ̶icoa ane ɡ̶anepilidi, odaa edianitiniwace madewetedi ɡ̶aninyeelo. Odaa jaɡ̶akati ɡ̶aniliicaɡ̶ajetecidi digoida ditibigimedi. Odaa nigidiaaɡ̶idi odaaɡ̶anagi, aniwitici!” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Niɡ̶ijo ɡ̶oneleegiwa naɡ̶a wajipatalo niɡ̶ijoa lotaɡ̶a Jesus, odaa eliodi magecaɡ̶alo, leeɡ̶odi owidi niɡ̶icoa niliicaɡ̶ajetecidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus nadi meliodi magecaɡ̶alo, odaa jeɡ̶ee, “Ica me dakake niɡ̶inoa liicotedi moika Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aɡ̶ica laɡ̶aliigi gameelo me ixomaɡ̶atiwece etakado libegi. Pida baɡ̶a dakake ɡ̶oneleegiwa liico me ikatece Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Niɡ̶ijo anowajipatalo niɡ̶ijoa lotaɡ̶a ja nigikanaɡ̶a, modi, “Enice, amiijo ica ane yakadi midioka limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Odaa Jesus meetediogi, “Niɡ̶ina anoyakadi niɡ̶ina oko me diɡ̶ica nimaweneɡ̶egi moyoe, pida Aneotedoɡ̶oji biɡ̶ida nimaweneɡ̶egitetece me yoe.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Odaa Pedro mee, “Digawini! Ja jikanaɡ̶atedice ijoatawece ane ɡ̶onepilidi, odaa ja jiwaɡ̶atibigaɡ̶adici.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Odaa Jesus meetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi, inatawece oko ane daɡ̶adiaaɡ̶ewianaɡ̶a niwita liɡ̶eladi, eliododipi, nioxoadipi, lodawa, idiaa lionigipi, meotibige me iiɡ̶e Aneotedoɡ̶oji laaleɡ̶enali niɡ̶ina eledi oko, ");
INSERT INTO kbcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Niɡ̶idi Aneotedoɡ̶oji yajigotediogi caticedi niɡ̶ijoa baanoɡ̶oikatedice, niɡ̶ina malee newiɡ̶a digoina, codaa aaɡ̶aɡ̶eote niɡ̶ina oko midioka limedi me newiɡ̶a miniwataɡ̶a digoida ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus yadeegi ijokijo niɡ̶ijo anodiotibece, odaa meetediogi, “Digawini! Jiɡ̶iniɡ̶a Jerusalém, odaa digoida jiɡ̶idiaaɡ̶i nige jawikode, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, icotece niɡ̶icoa anoiditedini, niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko niɡ̶ijo jotigide aneetici. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Etidajigotiogi niɡ̶idi ane daɡ̶a judeutedi, odaa oyametibigiji, etidiweenigetice, codaa metidawaletice. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Etidalaketigi, odaa nigidiaaɡ̶idi jeɡ̶etideloadi. Pida nige ixomaɡ̶atedice itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Niɡ̶ijo anodiotibece aɡ̶oyowooɡ̶odi niɡ̶ijoa Jesus lotaɡ̶a. Oyaɡ̶aditema niɡ̶ica ane diitigilo niɡ̶ijoa lotaɡ̶a, odaa aɡ̶oyowooɡ̶odi niɡ̶ica Jesus aneyatedigi ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus niɡ̶ipegitedio nigotaɡ̶a Jericó. Odaa onini ica ɡ̶oneleegiwa etoinaɡ̶a nicotinece liniogotibece naigi, dipokotibige dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Niɡ̶ina me wajipatece niɡ̶ina noiigi me ixomaɡ̶atijo, odaa ja digika, digikatece anigina ica ane enagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Odaa modita, “Jesus niɡ̶ijoa ane icoɡ̶otedicogi Nazaré, inaaɡ̶enagitetece digoina!” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Odaa dinigetaɡ̶atee me dapaawe, mee, “Jesus, anida anenitege licoɡ̶egi Davi, adiwikodenita!” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Odaa niɡ̶ijo noiigi ane dinewadetibigiwaji joɡ̶oyoxoɡ̶o niɡ̶ijo ɡ̶olaɡ̶a, domoɡ̶oiiɡ̶e me notoko. Pida jeɡ̶epaanaɡ̶a dapaawe, mee, “Akaami anida anenitege licoɡ̶egi Davi, adiwikodenita!” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Odaa Jesus ja dabiditedi, ja diiɡ̶enatakate monadeegitalo niɡ̶ijo ɡ̶olaɡ̶a. Naɡ̶a nipegitalo, odaa Jesus ja ige, meeteta, ");
INSERT INTO kbcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Amiina ica anemaani mejigotaɡ̶awa?” Odaa jeɡ̶ee, “Iniotagodi, jemaa me jatetibece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Odaa Jesus jeɡ̶eete, “Anoleetice, odaa jaɡ̶atenitibece! Aneotedoɡ̶oji ɡ̶adicilatiti, leeɡ̶odi madinakatoni.” ");
INSERT INTO kbcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Odaa aɡ̶ica daɡ̶a leegi, niɡ̶ijo ɡ̶oneleegiwa ja yatetibece, odaa ja diotece Jesus, codaa doɡ̶etetibigimece Aneotedoɡ̶oji. Odaa ijotawece niɡ̶ijo noiigi-nelegi noɡ̶onadi niɡ̶ijo Jesus loenatagi, odaa joɡ̶odoɡ̶etetibigimece Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus dakatediwece nigotaɡ̶a Jericó, yakagiditedeloco naɡ̶ani nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Onini ica ɡ̶oneleegiwa liboonaɡ̶adi Zaqueu, lacilo niɡ̶ijo anodibatibigege ninyeelo ninionigi-eliodi romaanotedi. Zaqueu one liico. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Odaa domaɡ̶a yemaa me nadi anidoa icoa Jesus, pida ayakadi me nadi leeɡ̶odi niɡ̶idi noiigi, ibeyacaɡ̶adi me daɡ̶axa moxiiɡ̶otawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Odaa jona walokoditicogi lodoe niɡ̶idi noiigi, odaa ja dalaɡ̶atetibigimece aca niale, fiigoigo loidena, eotibige me yakadi me nadi Jesus, leeɡ̶odi idiaaɡ̶igotetece digoida aneitice me dalaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Niɡ̶ijo Jesus niɡ̶icotedicogi digoida aneitice, naɡ̶a iwitedibigimece ditibigimedi, odaa jeɡ̶eeteta, “Zaqueu, adinageni madaxotiti, igaataɡ̶a leeditibige midiaaɡ̶ejo ɡ̶adiɡ̶eladi niɡ̶ina noko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Odaa ja yediiɡ̶a me waxoditice, odaa ja dibatege Jesus digoida liɡ̶eladi, codaa eliodi me ninitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ijotawece niɡ̶ijo anonadi Jesus me lixigaɡ̶awa Zaqueu, dinoxatiwage, modi, “Igo aniodi digoida liɡ̶eladi niɡ̶ijo ɡ̶oneleegiwa anowidi libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Naɡ̶a dabiditi Zaqueu, odaa jeɡ̶eetalo Ǥoniotagodi, “Digawini, Iniotagodi! Natigide jajigotiogi madewetedi liwigotigi inoa ane inepilidi. Pida nigica ane jinaale me inoɡ̶a ninyeelo, jopilaɡ̶aditace cwaatolo mopitibigeloco niɡ̶ijoa dinyeelo ane jibanootece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Odaa Jesus jeɡ̶eeteta, “Niɡ̶ina noko Aneotedoɡ̶oji eote niɡ̶ina oko ane liɡ̶eladi niɡ̶ina diimigi midioka limedi me newiɡ̶a miniwataɡ̶a. Igaataɡ̶a akaami eledi ida anenitege ane licoɡ̶egi mijotaɡ̶a Abraão. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, janagitiogi me jao lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji niɡ̶ijo aniatagigipi, codaa me ane leegitalo moyototedice Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Odaa niɡ̶ijo noiigi noɡ̶owajipatalo ijoa lotaɡ̶a, odaa Jesus ja yatemati ica natematigo ane ɡ̶odiiɡ̶axi. Niɡ̶ijo noɡ̶odipegita Jerusalém, odaa joɡ̶odiletibige daantaɡ̶a nipegi ica nige iiɡ̶e Aneotedoɡ̶oji inatawece oko. Joaniɡ̶idaa leeɡ̶odi Jesus naɡ̶a yatemati niɡ̶ida natematigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mee, “Onini ica ɡ̶oneleegiwa ica loiigiwepodi one niɡ̶inoa ɡ̶oneɡ̶aɡ̶a. One igo miditaɡ̶a eledi iiɡ̶o digoida ditigedi, eotibige moixotio me ninionigi-eliodi niɡ̶idi epaa nipodigi. Odaa ja dopitijo. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aniɡ̶icatibige daɡ̶a diniwiaje, odaa jeɡ̶eniditiogi deez liimetedi. Odaa yajigota oninitecibeci onaniteci beexo oolo, odaa meetiogi, ‘Abakeni niɡ̶inoa dinyeelo bidige owidi nigepaa idopitijo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pida niɡ̶idi loiigi ane ideitice miditaɡ̶a niiɡ̶o aɡ̶oyemaa me ninionigi-eliodi. Odaa joɡ̶oiomaɡ̶aditicoace icoa ɡ̶oneleegiwadi, odaa joɡ̶oiiɡ̶eticogi niɡ̶idi oko me igotibeci digoida miditaɡ̶a eledi iiɡ̶o moyeloɡ̶odita niɡ̶ijo ane domaɡ̶a ixotio niɡ̶ijo ɡ̶oneleegiwa me inionigi-eliodi. Oyeloɡ̶odita me doɡ̶oyemaa niɡ̶ijo ɡ̶oneleegiwa ane domaɡ̶a ixotio me ninionigi-eliodi niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Niɡ̶ijo ɡ̶oneleegiwa naɡ̶a dopitijo, ja ninionigi-eliodi niɡ̶ijo ane daɡ̶a domoɡ̶oyemaa. Niɡ̶ijo naɡ̶a dopitijo, odaa jeɡ̶eniditiogi niɡ̶ijoa liimetedipi ane yajigotiogi ninyeelo, leeɡ̶odi yemaa me yowooɡ̶odi niɡ̶ica ane liwokodi dinyeelo anowote moibake niɡ̶ijoa beexotedi oolo. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Niɡ̶ijo odoejegi limeedi neɡ̶enota, meeta, ‘Iniotagodi, jakaditedaɡ̶adomi deez beexotedi me jibake naɡ̶ajo beexo ananajicitiwa.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Odaa niɡ̶ijo inionigi-eliodi meeta, ‘Jiɡ̶idiaaɡ̶i! Akaami nimeedi anele! Jaɡ̶anikeenitiwa me jakadi me ɡ̶adinakatoni, mele mawii niɡ̶ijo ane jajigotaɡ̶awa me ɡ̶abaketawaanigi. Joaniɡ̶idaa leeɡ̶odi ɡ̶adixomitio me iiɡ̶eni deez nigotadi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Odaa niɡ̶ijo eledi limeedi naɡ̶aɡ̶a enota, meeta, ‘Iniotagodi, jakaditedaɡ̶adomi ciinco beexotedi me jibake naɡ̶ajo ananajicitiwa beexo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Odaa jaɡ̶aɡ̶a eeta niɡ̶ijo ninionigi-eliodi, ‘Jiɡ̶idiaaɡ̶i! Jajigotaɡ̶awa me iiɡ̶eni ciinco nigotadi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Odaa niɡ̶ijo eledi nimeedi naɡ̶aɡ̶a enota, meeta, ‘Digawini, Iniotagodi! Etani naɡ̶ajo ɡ̶anibeexo. Jilipaditigi leenxo, odaa ja jotete. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Igaataɡ̶a idoitaɡ̶awa, leeɡ̶odi makaami ɡ̶oneleegiwa ane dakake laaleɡ̶ena. Akati manoɡ̶aa niɡ̶ina ane daɡ̶a ɡ̶anebi, codaa anopilaɡ̶atitio ane daɡ̶a ɡ̶atanigijegi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Odaa niɡ̶ijo inionigi-eliodi meeta, ‘Akaami nimeedi ane beyagi! Niɡ̶inoa ɡ̶adotaɡ̶a ja ikee makaami beyagi. Owooɡ̶oti me ee ɡ̶oneleegiwa ane dakake laaleɡ̶ena, me inoɡ̶a ane daɡ̶a inebi, codaa inopilaɡ̶aditio niɡ̶ina ane daɡ̶a eyanigijegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Enice, igaamee daɡ̶ajicitiogi ijoa ininyeelo niɡ̶ina anonadila dinyeelo modoletibige me gaanyaɡ̶a? Daɡ̶ajicitiogi, odaa naɡ̶a idopitijo, otaɡ̶aɡ̶a jibatacege ininyeelo codaa me niɡ̶icoa ane ɡ̶anigaanye.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Odaa niɡ̶ijo inionigi-eliodi jeɡ̶eetiogi niɡ̶ijo anowalitibigege niɡ̶ica ligegi, meetiogi, ‘Anoɡ̶aa naɡ̶ani nibeexo, odaa ajicitiogi niɡ̶ijo anidiwa deez nibeexotedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Odaa joɡ̶odita, ‘Pida Ǥoniotagodi, jiɡ̶idiwa deez nibeexotedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Odaa jeɡ̶ee, ‘De jeloɡ̶oditaɡ̶awatiwaji, niɡ̶ijo anidiwa, odaa alee dibatege eletidi. Pida niɡ̶ijo ane diɡ̶icoa, icaaɡ̶ica onateciɡ̶idi ane nebi pida oibanootece. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Natigide, anadeegitediwa niɡ̶icoa idelaɡ̶awepodi ane daɡ̶a domoɡ̶oyemaa me ee ninionigi-eliodi, odaa anigoti digoina yodoe.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Niɡ̶ijo Jesus neɡ̶ee niɡ̶ijoa lotaɡ̶a, odaa ja dinewade, dalaɡ̶atetedibigimece nalaɡ̶ate Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naɡ̶a icotediogi icoa nigotadawaanaɡ̶a ane liboonaɡ̶adi Betfagé, aniaa Betânia, anipegitiwage odipegitege ica lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira”. Niɡ̶ijo niɡ̶ipegitediogi, odaa ja iiɡ̶e itoataale niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Meetediogi, “Emii nigepaa midiwataɡ̶a nigotadawaanaɡ̶a digoida ɡ̶ododoe. Nigakaatiotiwaji, odaa jaɡ̶akati boliicawaanigi dinigoetini, analeediɡ̶ica mowaxoditeloco. Owileceni ini boliicawaanigi, odaa anadeegiticogi digoina meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nigica ane ɡ̶adigeetiwaji, nigeetaɡ̶awa, ‘Igaamenitiwaji ina mowileceni ini boliicawaanigi?’ Odaa enita, ‘Jowilecenaɡ̶a ini boliicawaanigi leeɡ̶odi Ǥoniotagodi yopotedibige.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Odaa jiɡ̶igotibeci niɡ̶ijo ane iiɡ̶etedibigiwaji, odaa joɡ̶oyakadi niɡ̶ijo aneyatedigi Jesus ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Niɡ̶ijo naɡ̶a oikatice niɡ̶ijo boliicawaanigi, odaa niɡ̶ica ane nebi ja nigikanaɡ̶a, modi, “Igame leeɡ̶odi ina mowileceni ini boliicawaanigi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Odaa joɡ̶oigidi, modita, “Jowilecenaɡ̶a niɡ̶ini boliicawaanigi leeɡ̶odi Ǥoniotagodi yopotedibige.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Odaa joɡ̶oyadeegi boliicawaanigi midoataɡ̶a Jesus, niɡ̶idiaaɡ̶idi joɡ̶oyexaɡ̶ateloco nijayogoli leláɡ̶a niɡ̶ijo boliicawaanigi. Odaa joɡ̶oyadodi Jesus me waxoditedibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Igaanaɡ̶a onaditege Jesus, odaa niɡ̶idi noiigi oipecetinigi iiɡ̶o nijayogoli naigitinece, owotibige moikee moiweniɡ̶ide. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Niɡ̶ipegitedio nigotaɡ̶a Jerusalém, naɡ̶a idinikanaɡ̶atinece minitaɡ̶a lojotaɡ̶adi aninoa icoa nialeli “oliveira”, anodita “Lojotaɡ̶adi Oliveira”. Niɡ̶ijo niɡ̶ico niɡ̶ica noiigi-nelegi anodiotibece ninitibigiwaji, odigaanaɡ̶atibigimece Aneotedoɡ̶oji me dinigetaɡ̶ateetibigiwaji leeɡ̶odi ijoatawece niɡ̶ijoa ɡ̶odoxiceɡ̶etedi libinienaɡ̶a baaniɡ̶ijo monadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Odaa modi niɡ̶ijo noiigi, “Jemaanaɡ̶a Aneotedoɡ̶oji meote aneletema niɡ̶iniwa inionigi-eliodi anida naɡ̶atetigi aneitelogo Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji. Inoatawece aninoa digoida ditibigimedi idioka limedi me ilaɡ̶atiwage. Joɡ̶eeɡ̶atibigimece ane ideitedice ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Odaa onicoa icoa fariseutedi, anidiaaɡ̶i liwigotigi niɡ̶idi noiigi-nelegi, onoditalo Jesus, “Niiɡ̶axinaɡ̶anaɡ̶a! Oxoki niɡ̶idi anodiotibigaɡ̶adici leeɡ̶odi niɡ̶inoa lotaɡ̶a.” (Leeɡ̶odi aɡ̶oyemaa modi Jesus me inionigi-eliodi.) ");
INSERT INTO kbcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Odaa ja igidi, meetediogi, “Ejitaɡ̶awatiwaji daɡ̶a notokotiniwace, odaa niɡ̶inoa wetiadi jaɡ̶aɡ̶a napaawaɡ̶ateloco modoɡ̶etetibigimece Aneotedoɡ̶oji!” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Niɡ̶ijo Jesus niɡ̶ipegite nigotaɡ̶a, naɡ̶a naditeta naɡ̶ani nigotaɡ̶a, odaa jaɡ̶anoe leeɡ̶odi ane ninyaagi nigidiaaɡ̶idi niɡ̶idi niɡ̶eladimigipitigi nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Odaa jeɡ̶ee, “Niɡ̶ida me Ee domaɡ̶a jemaa mowooɡ̶oti niɡ̶ina noko niɡ̶ica ane leeditibige mawii makatitiwaji Aneotedoɡ̶oji me daɡ̶alee yelatedaɡ̶adomi. Pida niɡ̶ina natigide aɡ̶aleeɡ̶akatitiwaji manati niɡ̶ica ane leeditibige mawii. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Leeɡ̶odi icotalo nokododi ɡ̶adaxakawepodi onojotaɡ̶adi iiɡ̶o moyolitaɡ̶agitiwaji manotiticogi we nigotaɡ̶a. Jiɡ̶idaaɡ̶ee nigonoxocotaɡ̶agitiwaji, etiɡ̶adiligicenitiwaji inoatawece ɡ̶awailidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Odaa joɡ̶oyaaɡ̶adi anitawece ɡ̶anigotaɡ̶atiwaji, codaa makaamitawece anakaami niɡ̶eladimigipi. Odaa aɡ̶aca nenyaɡ̶ati otaɡ̶anitece wetiɡ̶a ane waxoditeloco eledi, leeɡ̶odi aɡ̶emaani mowooɡ̶oti Niɡ̶ijoa Aneotedoɡ̶oji ane niiɡ̶e me dalitaɡ̶awatiwaji Liiɡ̶exegi me domeɡ̶eotedaɡ̶adomi anele.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus naɡ̶a dakatediwece Aneotedoɡ̶oji liɡ̶eladi, odaa ja niticoitedicoace icoa anoojetekaɡ̶a anidiaaɡ̶ite. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Odaa jeɡ̶eetediogi, “Lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji diniditeloco niɡ̶ica Aneotedoɡ̶oji ane ligegi, niɡ̶ijo neɡ̶ee, ‘Iɡ̶eladi jiɡ̶idiaa ite niɡ̶ina oko ane etidotaɡ̶aneɡ̶e.’ Pida jaɡ̶ademiitiwaji liɡ̶eladi micataɡ̶a daɡ̶a latecaɡ̶adi olicaɡ̶aɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesus one diiɡ̶axinaɡ̶a minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi icoatawece niɡ̶icoa nokododi. Odaa niɡ̶ijoa sacerdotitedi ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Aneotedoɡ̶oji, ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e judeutedi, joɡ̶odoletibige moyeloadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pida aɡ̶ica nimaweneɡ̶egi, leeɡ̶odi iditawece oko watacotibigiwaji, mowajipatalo lotaɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ica noko Jesus idiaaɡ̶ite Aneotedoɡ̶oji liɡ̶eladi, odaa niiɡ̶axitediniwace ica noiigi, yeloɡ̶oditediogi niɡ̶icoa nibodicetedi anele ane icoɡ̶otedibigimece miniwataɡ̶a Aneotedoɡ̶oji. Odaa joɡ̶ototalo niɡ̶ijo anoiiɡ̶e sacerdotitedi, codaa me niɡ̶ijo anodiiɡ̶axinaɡ̶atece icoa lajoinaɡ̶aneɡ̶eco Moisés, ijaaɡ̶ijoa icoa laxokodi ɡ̶oneleegiwadi, lacilodi noiigi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Odaa joɡ̶oige, moditalo, “Igame icoɡ̶oticogi ica ɡ̶anaɡ̶atetigi mawiite inoa ɡ̶adoenataka? Codaa amiijo ica ane yajigotaɡ̶awa ɡ̶anaɡ̶atetigi me yakadi mawiite inoa ɡ̶adoenataka?” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus ja igidi, meetediogi, “Ee aaɡ̶aɡ̶a ɡ̶adigeetiwaji, odaa jemaa madigiti. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Amiijo ica ane niiɡ̶e João me nilegetiniwace oko? Aneotedoɡ̶oji niiɡ̶e? Oɡ̶oa, ɡ̶oneleegiwadi oniiɡ̶e?” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Odaa jiɡ̶idiaa dinotaɡ̶aneɡ̶etiwage, modi, “Daɡ̶a jigitaɡ̶a me Aneotedoɡ̶oji niwakatee João me dilegenaɡ̶a, odaa jeɡ̶eetedoɡ̶owa, ‘Joaniɡ̶idaaɡ̶ee igatime leeɡ̶odi ina diɡ̶iwaɡ̶atiteda icoa aneetedaɡ̶awa João?’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pida deɡ̶ejinaɡ̶a me ɡ̶oneleegiwadi oniiɡ̶e, odaa niɡ̶ina noiigi-nelegi joɡ̶onokoletoɡ̶oloco wetiadi, leeɡ̶odi oyiwaɡ̶adi João minaaɡ̶ina ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Odaa joɡ̶oigidi Jesus, moditalo me doɡ̶oyowooɡ̶odi niɡ̶ica ane yajigota João naɡ̶atetigi me nilegetiniwace oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Odaa Jesus jeɡ̶ee, “Ee eleditiwaji ajeloɡ̶oditaɡ̶awa niɡ̶ica ane najigotiwa inaɡ̶atetigi me jakadi me jaote niɡ̶inoa yoenataka.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niɡ̶idiaaɡ̶idi Jesus ja yatematitediogi niɡ̶idi noiigi niɡ̶ida natematigo anida ane ɡ̶odiiɡ̶axitece, odaa jeɡ̶ee, “Ica ɡ̶oneleegiwa eyatedi ‘uuva’ libatatiidi miditaɡ̶a lixoɡ̶otagi. Odaa ja dinilakidetege icoa ɡ̶oneleegiwadi modoweditelogo, odaa ja noditice, igo eledi iiɡ̶o, ica ditigedi, odaa leegi midiaaɡ̶i. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Niɡ̶icota ica limedi monopilaɡ̶aditedio lawodigijedi, odaa ja iiɡ̶e onijoteci liotagi me dibatege liwai niɡ̶ica baanaɡ̶a odinilakidetigi. Pida niɡ̶ijoa ɡ̶oneleegiwadi anodoweditelogo onaxacoɡ̶otibige niɡ̶ijo liotagi, oiiɡ̶e mopi, me diɡ̶icata ane yadeegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Niɡ̶ijo ane nebi nixoɡ̶otagi ja iiɡ̶e eledi liotagi. Pida idaaɡ̶odigota onaxacoɡ̶otibige, onietibige, codaa moiiɡ̶e mopi me diɡ̶icata ane yadeegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Odaa ja niwakatee eledi liotagi. Pida niɡ̶ijo liotagi oyacilotidi, odaa joɡ̶oyokoleticogi wetice niɡ̶idiwa nawodigijedi anoniotaa. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Odaa niɡ̶ijo ane nepilidi niɡ̶ijoa nawodigijedi meetigi le, ‘Amigaleeɡ̶ini ica inimaweneɡ̶egi? Natigide jiiɡ̶e niɡ̶ini ionigi yemaanigi. Ijoatibige doɡ̶odeemitetibige.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pida niɡ̶ijo anodoweditelogo niɡ̶ijoa nawodigijedi noɡ̶onaditege lionigi niɡ̶ijo ane nepilidi nawodigijedi, odaa modi, ‘Niɡ̶ina niɡ̶ijo lionigi niɡ̶ijo ane nepilidi nawodigijedi, jiɡ̶inaa nenyaɡ̶atema nawodigijedi, nige yeleo eliodi. Ele me jeloataɡ̶a, odaa niɡ̶inoa nawodigijedi ja ɡ̶onepilidi.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Odaa joɡ̶oyokoleticogi we niɡ̶idiwa nawodigijedi, odaa joɡ̶oyeloadi. Natigide, amiini ica anakatitecetiwaji ijo ane nepilidi idiwa nawodigijedi migotiogi idi anoyeloadi lionigi? ");
INSERT INTO kbcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Enagi, odaa ja nigodi niɡ̶idi anodoweditelogo nawodigijedi. Odaa ja yajigotiogi niɡ̶idiwa nawodigijedi eletidi ɡ̶oneleegiwadi modoweditelogo.” Niɡ̶ijo noiigi noɡ̶owajipata niɡ̶ida natematigo, odaa modi, “Inibeoonaɡ̶atege Aneotedoɡ̶oji me daɡ̶a ikateda micota niɡ̶ida niciagi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus naɡ̶a iwitediogi, odaa jeɡ̶ee, “Enice, amiini ica aneetece ijo liwai ajo Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi anee, ‘Naɡ̶ajo wetiɡ̶a ane diɡ̶ica mowo, niɡ̶ijo anoyoe diimigi, ajaaɡ̶ajo naɡ̶ajo wetiɡ̶a dinoe me wetiɡ̶a ane daɡ̶axa mida anowo mini diimigi, caticedi niɡ̶idiwa eletidi wetiadi anoibake’? (Leeɡ̶odi jaɡ̶aniaa dowediteloco initawece niɡ̶ini diimigi.) ");
INSERT INTO kbcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Niɡ̶ina oko ane dixipeteloco naɡ̶ani wetiɡ̶a, oninoateci liwailidi yeyaɡ̶atedice. Codaa naɡ̶ani wetiɡ̶a deɡ̶eniteloco oko, iopaaɡ̶adi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi, oyowooɡ̶odi niɡ̶idiaaɡ̶eetediogi Jesus, niɡ̶ijo naɡ̶a yatemati niɡ̶ida natematigo. Odaa joɡ̶odoletibige moniwilo aniaaɡ̶ani naɡ̶aca lakata, pida aɡ̶ica loenatagi leeɡ̶odi odoitiogi niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Odaa joɡ̶oiɡ̶oaditalo Jesus, niɡ̶idiaaɡ̶idi joɡ̶oiiɡ̶e ɡ̶oneleegiwadi modinanatigi niɡ̶ina oko ane iɡ̶enaɡ̶a moiɡ̶oaditalo Jesus, codaa monigetedice, odoletibige modibatalo oyatitalo lotaɡ̶a. Domoɡ̶oyemaa mica ica anoyatigi ligegi modakapetege Jesus, domoɡ̶owotibige moyakadi moyajigo minitaɡ̶a ninionigi-eliodi romaanotedi, moiloikatidi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Niɡ̶ijoa ɡ̶oneleegiwadi niiɡ̶exedi joɡ̶oige Jesus, moditalo, “Ǥoniiɡ̶axinoɡ̶odi, jowooɡ̶otaɡ̶a meloɡ̶oti anewi, codaa me iiɡ̶axinaɡ̶anitece anewi. Codaa jowooɡ̶otaɡ̶a me daɡ̶awii ɡ̶ademaani oko daɡ̶a leeɡ̶odi mida ane jaoɡ̶a. Pida ewi me iiɡ̶axinaɡ̶anitece niɡ̶ica Aneotedoɡ̶oji ane yemaa mowo niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Natigide digawini, domige ɡ̶odiiɡ̶e inoa ɡ̶onajoinaɡ̶aneɡ̶eco me jajicaɡ̶ata César dinyeelo, niɡ̶ijo ninionigi-eliodi romaanotedi ane ɡ̶odiiɡ̶eta me jedianaɡ̶a? Oɡ̶oa, domige etiɡ̶odoli inoa ɡ̶onajoinaɡ̶aneɡ̶eco me jedianaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pida Jesus yowooɡ̶odi modoletigi mowotema ane beyagi modakapetege. Odaa jeɡ̶ee, ");
INSERT INTO kbcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Awii anikeenitiwa beexo romaanexe. Ame liwigo aniwoteloco ani beexo, codaa ame liboonaɡ̶adi ane diniditeloco ani beexo?” Odaa joɡ̶odi, “César.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Odaa Jesus jeɡ̶ee, “Enice, ediani César niɡ̶ica ane leeditibige medianitece, codaa ajicitalo Aneotedoɡ̶oji niɡ̶ica ane leeditibige medianitece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Odaa aɡ̶oyakadi modi mica ligegi Jesus ane beyagi lodoe niɡ̶idi noiigi. Codaa eliodi moyopo ane eyatedigi ligegi me igiditediogi. Joaniɡ̶idaa leeɡ̶odi modaa notokotiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Icoa saduceutedi aonoɡ̶oyiwaɡ̶adi micota me newiɡ̶atace niɡ̶ijo baanaɡ̶a nigo, odaa onica anototalo Jesus, moige, ");
INSERT INTO kbcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Moditalo, “Ǥoniiɡ̶axinoɡ̶odi, niɡ̶ijo Moisés naɡ̶a idí niɡ̶ijoa ɡ̶onajoinaɡ̶aneɡ̶eco, mee me iditedini, ‘Diɡ̶ica ɡ̶oneleegiwa ane yeleo nenyaɡ̶aditi lodawa me diɡ̶ica lionigi, odaa leeditibige nioxoa me lodawa naɡ̶ajo wajekalo amaleeɡ̶aɡ̶a icoa lionaɡ̶a. Odaa niɡ̶idi lionigipi ja micataɡ̶a daɡ̶a lionigipi niɡ̶ijo baanaɡ̶a yeleo.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pida onicoa seete dinioxomigi. Odaa niɡ̶ica liidaɡ̶a jona wado. Pida aniɡ̶ica lionigi naɡ̶a yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Odaa niɡ̶ijo liiɡ̶ejetewa ja lodawa naɡ̶ajo wajekalo. Pida jaɡ̶aɡ̶a yeleo maleediɡ̶ica lionigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Niɡ̶idiaaɡ̶idi niɡ̶ijo aaɡ̶aɡ̶a liiɡ̶ejetewa jaɡ̶aɡ̶a lodawa ajaaɡ̶ajo naɡ̶ajo wajekalo. Pida eledi yeleo. Odaa joaniɡ̶idaaɡ̶ee ijotawece niɡ̶ijo seete dinioxomigi nodawa ajokajo iwaalo, codaa ijotawece nigo maleediɡ̶ica lionigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Niɡ̶idiaaɡ̶idi naɡ̶ajo iwaalo jaɡ̶aɡ̶a yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Odaa niɡ̶ica noko nige newiɡ̶atace émaɡ̶aɡ̶a, amigepidiɡ̶ica niɡ̶ijo seete dinioxomigi baɡ̶a lodawa ajo iwaalo? Igaataɡ̶a ijotawece nodawa ajokajo iwaalo.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus naɡ̶a igidi, meetediogi, “Niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o nadonaɡ̶a, odaa jiɡ̶inoa lionaɡ̶a, odaa jaɡ̶aɡ̶a nadonaɡ̶a niɡ̶inoa lionaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pida niɡ̶ina Aneotedoɡ̶oji aneote me yewiɡ̶atace leeɡ̶odi me iɡ̶enaɡ̶atibigiwaji, nige newiɡ̶atace, aɡ̶alee nadonaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pida ja liciaco aanjotedi, aɡ̶alee yakadi daɡ̶a nigo. Ja lionaɡ̶a Aneotedoɡ̶oji leeɡ̶odi jeɡ̶epaaɡ̶eote naɡ̶a newiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Codaa ijaaɡ̶ijo Moisés ikee niɡ̶ijoa émaɡ̶aɡ̶a me newiɡ̶atace. Niɡ̶ijo naɡ̶a iditini me yalaɡ̶ata naɡ̶ajo nialawaana ane ídi, pida ayabidi. Iditini yalaɡ̶atalo Ǥoniotagodi Aneotedoɡ̶oji niɡ̶iniaa, ‘Noenoɡ̶odi Abraão, Noenoɡ̶odi Isaque, codaa me Noenoɡ̶odi Jacó.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Odaa leeɡ̶odi niɡ̶idiwa notaɡ̶a, ja jowooɡ̶otaɡ̶a me daɡ̶a Noenoɡ̶oditeda émaɡ̶aɡ̶a, pida Noenoɡ̶odi niɡ̶ina oko anidi me newiɡ̶a. Leeɡ̶odi lodoe Aneotedoɡ̶oji iditawece newiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niɡ̶idiaaɡ̶idi icoa anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés moditalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, ica mele motaɡ̶ani!” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Owo niɡ̶ida ligegi leeɡ̶odi niɡ̶ijoa saduceutedi aɡ̶aleeɡ̶abo laaleɡ̶ena mowote eletidi ligikaneɡ̶eco midoataɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus digika, meetediogi, “Ica Aneotedoɡ̶oji ane niwakatee me yewikatidi oko, igame leeɡ̶odi ina oko modi mida aneetege licoɡ̶egi Davi? ");
INSERT INTO kbcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Igaataɡ̶a ijaaɡ̶ijo Davi mee miditaɡ̶a liwai Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi anodita Enaco, mee me iditeloco, ‘Ǥoniotagodi Aneotedoɡ̶oji meeteta Iniotagodi, “Anicootini iwai ibaaɡ̶adi me jiiɡ̶enatakanaɡ̶a, nigepaaɡ̶icota me jiɡ̶eke ɡ̶aneloɡ̶ododipi.” ’ ");
INSERT INTO kbcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davi nigeetalo me Niotagodi, odaa igaamee ina me yakadi ica ane niiɡ̶e Aneotedoɡ̶oji mida aneetege licoɡ̶egi Davi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Niɡ̶ijo noiigi owajipatalo Jesus, neɡ̶eetediogi niɡ̶ijo anodiotibece, ");
INSERT INTO kbcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Anidakitiogi niɡ̶ina anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés. Lemaanigi niɡ̶ina mewaligitibigiwaji, modinixotinigilo nijayogoli niɡ̶ina oko ɡ̶oneɡ̶egi. Eleditace lemaanigi niɡ̶ina oko modeemitetibige monice miditaɡ̶a ane latecaɡ̶aditibece oko. Codaa lemaanigi monicoteloco nibaanco niɡ̶ina oko ɡ̶oneɡ̶egi midiwataɡ̶a niiakanaɡ̶axiidi, codaa niɡ̶ina migotibeci nalooɡ̶o, odoletibige limedi niɡ̶ina anele. ");
INSERT INTO kbcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pida oninaaletiniwace wajekalodi, odaa joɡ̶odoliceta anigidi lowoodaɡ̶agi anele, codaa lemaanigi me dinikeenaɡ̶aneɡ̶e moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. Pida Aneotedoɡ̶oji icota meliodi me iloikatidi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus iwitediogi ica oko minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Odaa naditediogi niɡ̶ijoa liicotedi noɡ̶oyokoletinigi ninyeelo naɡ̶ajo niwokodaɡ̶axi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Odaa aaɡ̶aɡ̶a nadi naɡ̶ajo wajekalo madewete maɡ̶aɡ̶a yokoletinigi madi iwokodaɡ̶axi iniwataale beexotedawaanaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Odaa Jesus jeɡ̶ee, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Naɡ̶ani wajekalo madewete yajigotalo Aneotedoɡ̶oji caticedi anoyajigo niɡ̶ijo eledi oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Leeɡ̶odi niɡ̶ijo eledi oko oyajigo niɡ̶inoa ane iiɡ̶otedice ninyeelo. Pida naɡ̶ani wajekalo digo anee me daɡ̶axa me madewete, pida yajigotalo Aneotedoɡ̶oji ijoatawece niɡ̶ijoa ane domaɡ̶a yopotibige me yewiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Niɡ̶ijo anodiotibece notaɡ̶anaɡ̶ateloco oyalaɡ̶ata Aneotedoɡ̶oji liɡ̶eladi, oyakadi ica me daɡ̶axa me libinienigi, icoa niwetiadi libinienaɡ̶a, codaa owidi niɡ̶icoa eletidi elomaɡ̶ajetecidi libinienaɡ̶a niɡ̶ini diimigi anoibootalo Aneotedoɡ̶oji niɡ̶ica noiigi. Odaa Jesus jeɡ̶ee, ");
INSERT INTO kbcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Icota noko niɡ̶ini diimigi libinienigi ananatitiwaji icota moyaaɡ̶adi. Odaa aɡ̶aca nenyaɡ̶atini otaɡ̶anitece wetiɡ̶a ane waxoditeloco eledi wetiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Odaa joɡ̶oige Jesus, moditalo, “Ǥoniiɡ̶axinoɡ̶odi, igaatigi ica nige jinataɡ̶a ida niciagi? Amiida ica Aneotedoɡ̶oji loenatagi me nikeetedoɡ̶owa ica nige limedi ida niciagi anenita?” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Odaa Jesus mee, “Adinowetitiwaji! Adiɡ̶ica ane ɡ̶adinaaleni, leeɡ̶odi eliodi oko odinanatibigiji, modi, ‘Ee liiɡ̶exegi Aneotedoɡ̶oji’, oɡ̶oa, domigodi, ‘Jiɡ̶icota noko Ǥoniotagodi.’ Pida jiniɡ̶iwitecetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Codaa jinaɡ̶adoii nigajipaata moyalaɡ̶ata nideleɡ̶eco digawiniteloco noiigi, codaa me niɡ̶ina dinoiigiwepodi nidelaɡ̶a. Igaataɡ̶a jiɡ̶inaa odoejedi me jinataɡ̶a, pida anaɡ̶a nipegi liniogo niɡ̶inoa nokododi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Odaa Jesus jeɡ̶ee, “Icota midi noiigi dinigoditege eledi noiigi, codaa nimaweneɡ̶eco iiɡ̶o dakapetege nimaweneɡ̶eco eledi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Niɡ̶inoa eletidi nipodaɡ̶a jibodicaɡ̶ata datalale iiɡ̶o ane yoniciwadi, oko nigodi nigigi, codaa me neelotika ane yediiɡ̶a me waxodita eledi oko. Aneotedoɡ̶oji eote ane ikee digoida ditibigimedi ane ikee me deliɡ̶ide, odaa eote niɡ̶ina oko meliodi me doitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pida maleedaɡ̶a icotece inoatawece niɡ̶inoa anejitedaɡ̶awa, icota modibataɡ̶awatiwaji, owo mawikodee. Odaa etiɡ̶adajicitiogitiwaji niɡ̶inoa lacilodi liiakanaɡ̶axiidi judeutedi, odaa jeɡ̶etiɡ̶adixomitiwece niwiloɡ̶onaɡ̶axi. Leeɡ̶odi Iboonaɡ̶adi etiɡ̶adadeegitatiwaji lodoe inionaɡ̶a-eloodoli, inaaɡ̶inoa eletidi lacilodi metiɡ̶adiwini, odaa joɡ̶owo anodigotaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Joaniɡ̶idaa nigakatitiwaji menitici miditaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Atiteteloco ɡ̶adowoogo, jiniɡ̶iigi amanagawini aaɡ̶aɡ̶owikomataatiwaji maleedaɡ̶a icota lakata motaɡ̶ani. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Leeɡ̶odi emeɡ̶ee jajigotaɡ̶awa ɡ̶adixakedi, odaa jaxawataɡ̶adici ane alitigi ɡ̶agegi magiti ɡ̶adaxakawepodi, odaa iditawece aɡ̶oyakadi modinigaanyetaɡ̶adici, codaa aɡ̶oyakadi moditaɡ̶awa me deɡ̶enitece anewi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pida etiɡ̶adajicita metiɡ̶adiwilo niɡ̶ina ɡ̶adiododipi, ɡ̶anioxoadipi, ɡ̶aditacepodi, inaa ɡ̶adokaaɡ̶etedipi. Codaa ganigepidiɡ̶ica anoyeloadi niɡ̶ina akaamitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Odaa inatawece oko aɡ̶etiɡ̶ademaani Ee leeɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pida niɡ̶ida makaamitiwaji aɡ̶ica ananiatitema otaɡ̶aɡ̶idatece ɡ̶adamodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Odaa natigide aatege niɡ̶inoa ane dakaketedaɡ̶adomi, amaleeɡ̶aɡ̶a idioka limedi me ɡ̶adewiki miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Niganatitiwaji nigotaɡ̶a Jerusalém, monawiile owidi iodaɡ̶awadi ɡ̶adidelaɡ̶awadi, odaa joɡ̶owooɡ̶otitiwaji niɡ̶icotalo nokododi ane nibikota Aneotedoɡ̶oji me yaaɡ̶adi nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Odaa anidiaaɡ̶i nipodigi Judéia ele me deletibigimoace midiwataɡ̶a wetiadi. Codaa niɡ̶ina anidiaaɡ̶itice nigotaɡ̶a leeditibige me yediiɡ̶atibigiwaji me noditicoaci. Odaa niɡ̶ina anidiaaɡ̶itice nipodigi aɡ̶alee yakadi me dakatiwece nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Leeɡ̶odi niɡ̶icoa nokododi ja limedi Aneotedoɡ̶oji me iloikatidi niɡ̶idi noiigi, codaa icota midiokidi minoa ninyaco ijoatawece niɡ̶ijoa aniwoteloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Niɡ̶ina iwaalepodi ipilaɡ̶aɡ̶a, inaaɡ̶ina niɡ̶ina baɡ̶alee oilipeɡ̶e lionigipi, niɡ̶idi eliodi me nawikodeeɡ̶a niɡ̶icoa nokododi, leeɡ̶odi enagi owidi nawikodico digoina iiɡ̶o, codaa Aneotedoɡ̶oji iloikatidi niɡ̶ina noiigi leeɡ̶odi yelatetema me daɡ̶axa mowidi libeyaceɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Odaa niɡ̶ica laxakawepodi eliodi anonigodi niɡ̶idi noiigi oyatitiogi lodaajoli-ocaɡ̶atedi, codaa idi eledi oyadeegi micataɡ̶a me niwilogojegipi minoataɡ̶a eletidi iiɡ̶otedi. Odaa idi eledi noiigi oyaaɡ̶adi nigotaɡ̶a Jerusalém, odaa ida loniciwaɡ̶atema moiiɡ̶e nigotaɡ̶a nigepaa liniogo niɡ̶icoa nokododi Aneotedoɡ̶oji ane nibikota me ika mowo niɡ̶ida niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Joaniɡ̶idaaɡ̶ee niɡ̶ica niciagi, naɡ̶ani aligeɡ̶e, epenai, codaa me yotetitedi, oikeetiogi niɡ̶ina oko naɡ̶a nipegi liniogo iiɡ̶o. Odaa digoina iiɡ̶o, inatawece noiigi aɡ̶aleeɡ̶ica doɡ̶onibeotibigege anele, codaa eliodi me doitibigiwaji, leeɡ̶odi layaageɡ̶egi akiidi-eliodi, nebekadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Codaa niɡ̶ina oko noɡ̶omiwaditiniwace leeɡ̶odi daɡ̶axa me doitibigiwaji, niɡ̶ina moyowo niɡ̶ida niciagi nigicote. Leeɡ̶odi inoatawece ane loniciweɡ̶eco ditibigimedi digikee. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Odaa niɡ̶ina oko jeɡ̶etidadi, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, me idinikatini jiniotinece lolaadi, meliodi yoniciwaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nige limedi niɡ̶inoa ninyacoli, odaa jaɡ̶abo ɡ̶adaaleɡ̶ena maliitigi, leeɡ̶odi aɡ̶alee leegi odaa Aneotedoɡ̶oji ja ɡ̶adoɡ̶aatedicogi niɡ̶inoa ɡ̶adawikodico.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Odaa Jesus ja yatemati niɡ̶ida natematigo anida ane ɡ̶odiiɡ̶axitece, mee, “Digawini niale fiigoigo inaaɡ̶inoa eletidi nialeli. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Niɡ̶ina manatitiwaji niɡ̶inoa laamotiidi maleekoka daxoditedice, odaa joɡ̶owooɡ̶oti jiɡ̶icota limedi me daamotiide. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jiɡ̶idaaɡ̶ee nigicota manati niɡ̶ida niciagi, minoa nawikodico, odaa joɡ̶owooɡ̶otitiwaji naɡ̶a nipegi Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ejitaɡ̶awatiwaji niɡ̶ina anewi, niɡ̶ina oko aninaa me newiɡ̶a niɡ̶ica nigicotalo niɡ̶icoa nokododi nige limedi nawikodico, aɡ̶inatawece nigo nigicota niɡ̶ida niciagi anejita. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ditibigimedi, iiɡ̶o, baɡ̶a ixomaɡ̶atedice, pida yotaɡ̶a baadaɡ̶a ixomaɡ̶atedice, idioka limedi midiwa. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Akamaɡ̶akaamitiwaji adinoweti jiniɡ̶idioka limedi moleetibige maloo, daɡ̶a ɡ̶ademakitibece, codaa jinaɡ̶aɡ̶owikomataatelogo niɡ̶inoa aneni digoina iiɡ̶o. Ina daɡ̶adoiita adaɡ̶akaami libakajetegi maleedaɡ̶a enitigi deɡ̶eno niɡ̶ica noko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Igaataɡ̶a niɡ̶ica noko enagi, odaa dibatiogi eliodi oko digoina iiɡ̶o, niɡ̶ina analee doɡ̶oditibige, macataɡ̶a naɡ̶ana enoona me dibata eijeeɡ̶agi me daɡ̶a eetibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Odaa leeditibige midioka limedi madinoweti, codaa midioka limedi motaɡ̶aneɡ̶eni Aneotedoɡ̶oji, amaleeɡ̶aɡ̶a akatitiwaji metiɡ̶adiwokoni nawikodico anenagi, codaa amaleeɡ̶aɡ̶a akatitiwaji manooticogi yodoe, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Inoatawece nokododi Jesus niiɡ̶axitediniwace niɡ̶ijo noiigi minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Odaa niɡ̶ina menoale ja noditedicogi nigotaɡ̶a, idiaaɡ̶itedice maditaɡ̶a aca wetikawaana anodita, “Lojotaɡ̶adi Oliveira”. ");
INSERT INTO kbcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Odaa niɡ̶ina naɡ̶a yeloɡ̶otibige, iditawece niɡ̶idi noiigi igotibeci midoataɡ̶a Jesus minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi mowajipatalo lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Naɡ̶a nipegi ica nalokegi anodita “Lalokegi paon ane diɡ̶ica labookojegi”, aneledi oyatigi me “Páscoa”. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niiɡ̶axinaɡ̶anadi anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, joɡ̶odoletibige nimaweneɡ̶egi moyeloadi Jesus. Pida aɡ̶oyakadi, leeɡ̶odi odoitiogi niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas, aneledi oyatigi me Iscariotes, ida aneetege niɡ̶ijo dooze anodiotibece Jesus. Satanás ja dakatiwece laaleɡ̶ena Judas. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Odaa jiɡ̶igo yotaɡ̶aneɡ̶e niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijo anoiiɡ̶e niɡ̶icoa iodaɡ̶awadi anoyowie Aneotedoɡ̶oji liɡ̶eladi. Odinotaɡ̶aneɡ̶etege ica nimaweneɡ̶egi me yajigo Jesus midiwa lacilodi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Odaa eliodi me ninitibigiwaji, codaa odinilakidetege moyediatece dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ja niwoditema, odaa ja doletibige nimaweneɡ̶egi me yakadi me yajigo Jesus midiwa neloɡ̶ododipi me doɡ̶oyowooɡ̶odi niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Niɡ̶icota ica noko nalokegi “Paon ane diɡ̶ica labookojegi”, niɡ̶ica noko noɡ̶onigodi waxacocoli moninitege ica lalokegi Páscoa. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Odaa Jesus ja iiɡ̶e Pedro ijaa João, meetediogi, “Emiitiwaji odaaɡ̶oeni ɡ̶oweenigi lajo Páscoa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Odaa ja nigikanaɡ̶a, modi, “Igamei ica anemaani mejonaɡ̶atice me joenaɡ̶a ica ɡ̶oweenigi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Odaa Jesus ja igidi, meetediogi, “Digawinitiwaji, nigakaatiwece nigotaɡ̶a, akapetege ɡ̶oneleegiwa yoyaɡ̶adi boote ane nolee ninyoɡ̶odi. Odaa iwitece nigepaa minitaɡ̶a niɡ̶ica diimigi ane dakatiwece. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Odaa enita niɡ̶ini ane nebi diimigi, ‘Ǥoniiɡ̶axinoɡ̶odi ɡ̶odiiɡ̶e me jigikanaɡ̶atigi ica ane diiɡ̶etigi ica ɡ̶odicooɡ̶adi nelegi, anei me niodaɡ̶a, Ǥoniotagodi inaaɡ̶inoa anodiotibece moyeligo liweenigi Páscoa.’ ");
INSERT INTO kbcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Odaa ja ikeetaɡ̶awatiwaji ica ɡ̶odicooɡ̶adi nelegi ditibigimedi diimigi initawece ilaɡ̶atini. Odaaɡ̶idiaaɡ̶onitetiwaji me oeni ɡ̶oweenigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Niɡ̶ijo niɡ̶igotibeci, odaa joɡ̶odakapetege niɡ̶ijo Jesus aneyatedigi ligegi. Odaa joɡ̶oyoe liweenigi Páscoa. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Niɡ̶ijo niɡ̶icota aca lakata, odaa Jesus ja nicotedi maditaɡ̶a aca nameeja awatetege niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Odaa jeɡ̶eetediogi, “Jiɡ̶ijo mejitaɡ̶awatiwaji, meliodi me jemaa me jeligo niɡ̶ida ɡ̶oweenigi me Páscoa, mokotawece jatecoɡ̶ojoɡ̶o maleedaɡ̶a icota me jawikode. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Leeɡ̶odi ejitaɡ̶awatiwaji me daɡ̶adiaa jeligo liweenigi nalokegi Páscoa nigepaa jiniodaɡ̶a nige limedi lalokegi Aneotedoɡ̶oji ane iomaɡ̶aditedice, nigicota me iiɡ̶e laaleɡ̶enali inatawece oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Odaa Jesus naɡ̶a dibate aca goopa viinyo, odaa diniotagodete Aneotedoɡ̶oji. Niɡ̶idiaaɡ̶idi jeɡ̶ee, “Abaatege naɡ̶ada goopa, odaa adinajicitigi niɡ̶ida viinyo. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Leeɡ̶odi ejitaɡ̶awatiwaji aɡ̶alee jacipe viinyo nigepaa limedi Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali niɡ̶ina oko.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Odaa ja dibate paon, naɡ̶a diniotagodete Aneotedoɡ̶oji. Odaa ja inoke niɡ̶ijo paon. Naɡ̶a yajigotediogi niɡ̶ijo anodiotibece, odaa jeɡ̶eetediogi, “Niɡ̶idi paon micataɡ̶a yolaadi ane jajigo leeɡ̶odi akaamitiwaji. Awiitibiga niɡ̶ida anejinaɡ̶a amaleeɡ̶aɡ̶a analakitibigiji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Igaanaɡ̶a oiaaditece moyeligo paon, odaa naɡ̶a dibate naɡ̶ajo goopa, idaaɡ̶igote, odaa jeɡ̶eetediogi, “Naɡ̶ada goopa viinyo micataɡ̶a Aneotedoɡ̶oji daɡ̶a gelatace me dinilakidetetege oko me noɡ̶a libeyaceɡ̶eco, odaa ja dibatacetetege leeɡ̶odi yawodi ane anado ane akaamitawecetiwaji leeɡ̶odi. Odaa niɡ̶ida viinyo anacipetatiwaji micataɡ̶a daɡ̶a yawodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pida digawini! Niɡ̶ijo ane idajigotiogi yaxakawepodi, etini aniodi digoina meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Odaa Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, ideleo, leeɡ̶odi mina lowoogo Aneotedoɡ̶oji. Pida niɡ̶ini ane idajigotiogi ineloɡ̶ododipi, nigidiaaɡ̶idi eliodi me dawikode.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Odaa niɡ̶ijo anodiotibece ja dinigetiwage, modi, “Amigijo ica ane yajigo Ǥoniotagodi midi neloɡ̶ododipi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Niɡ̶ijo anodiotibece Jesus ja dinotigimadetiwage, odoletibige moyowooɡ̶odi ganigepidiɡ̶ijo ica ane daɡ̶axa me diniwaloe. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Odaa Jesus jeɡ̶eetediogi, “Niɡ̶inoa ninionaɡ̶a-eloodoli digoina iiɡ̶o lemaanigi moiiɡ̶e oko, codaa lacilodi lemaanigi moditiogi, ‘Miniɡ̶ina aneo anele mokotaɡ̶a’. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pida baɡ̶aleediɡ̶idaaɡ̶enitatiwaji. Pida niɡ̶ina ane idei makaamitaɡ̶atiwaji ane daɡ̶axa me ɡ̶oneɡ̶egi, leeditibige miniaaɡ̶ini micataɡ̶a niɡ̶ina niotagi baɡ̶alee lioneeɡ̶a. Odaa niɡ̶ina ane ɡ̶adacilo, ele midioka limedi me diniciaceeketege nimeedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Amiijo ica ane daɡ̶axa me ɡ̶oneɡ̶egi? Manigijaaɡ̶ijo ijo ane nicotini madi nameeja maniodi, oɡ̶oa, manigijaaɡ̶ijo ane nadeegita eledi oko liweenigi ane yeligo? Nige yemaa niɡ̶ijo ane nicotini madi nameeja jiɡ̶ijaa ɡ̶oneɡ̶egi! Pida Ee baɡ̶a diniciaceeketege niɡ̶ina niotagi digoina ɡ̶adiwigotigitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jaɡ̶akamaɡ̶akaamitiwaji niɡ̶ijo anidioka limedi me idinadeegitibigege minoa yawikodico. (Pida aɡ̶adikanitiwaji). ");
INSERT INTO kbcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pida joaniɡ̶idaa Eiodi me najigotediwa me jiiɡ̶e inoatawece, odaa Ee, aaɡ̶aɡ̶a jajigotaɡ̶awatiwaji me iiɡ̶eni inoatawece. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Odaa icota maniodi, macipe, codaa makaami ɡ̶ogiiwepodi miditaɡ̶a nalokegi Aneotedoɡ̶oji aneote nige limedi me jiiɡ̶e inoatawece. Codaa niɡ̶ida makaami jiɡ̶ida ɡ̶anaɡ̶atetigitiwaji me iiɡ̶enatakani, odaa jaɡ̶awinitiwaji anemiitiogi, codaa me iiɡ̶eni niɡ̶ijoa dooze latopaco loiigi Israel.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Odaa Ǥoniotagodi jeɡ̶ee, “Simão, Simão, digawini! Satanás dipokotalo Aneotedoɡ̶oji me ika me dineetaɡ̶awa akaamitawecetiwaji, me ɡ̶adigikeni, micataɡ̶a nawodaɡ̶anaɡ̶a me yajigijice leyeema, catinedi beneela. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pida jaɡ̶aɡ̶a jipokotaɡ̶aloco me ɡ̶adaxawani Aneotedoɡ̶oji, me daɡ̶a ikani madadiwaɡ̶ati, Simão. Odaa nige adopilitiwa, odaa awii me yoniciwaditace ɡ̶anioxoadipi mabo laaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pida Pedro meetalo, “Iniotagodi, ja idigo makaami iniwilaɡ̶awa, codaa makaami yemaɡ̶awa.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Odaa Jesus meeteta, “Pedro, ejitaɡ̶awa, niɡ̶ina enoale aniɡ̶icatibige daɡ̶a anoe okoɡ̶okoodi, odaa itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Odaa Jesus ja ige, meetediogi, “Ica ananiaditaɡ̶adomitiwaji, ijo me ɡ̶adiiɡ̶eni memiitiwaji me diɡ̶icoa ɡ̶anibocoli, me daɡ̶aca ɡ̶anixacoola, codaa meletidi ɡ̶awelatedi?” Odaa joɡ̶oigidi, moditalo, “Aɡ̶ica ane aniaditibige.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Odaa jeɡ̶eetediogi, “Pida niɡ̶ina natigide anidiwa nibocoli, mige nixacoola, ele me yadeegi. Odaa niɡ̶ini ane diɡ̶ica lodaajo-ocaɡ̶ataɡ̶a, odaa ele meyaa nicaapa, me yakadi me dinoojeteta lodaajo-ocaɡ̶ataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Leeɡ̶odi ejitaɡ̶awatiwaji me leeditibige micota niɡ̶ida niciagi, aneeta naɡ̶adi Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi mee, ‘Awatetege monilaɡ̶adi niɡ̶ijoa agopeloaɡ̶a.’ Leeɡ̶odi jiɡ̶icota niɡ̶ida niciagi, ijo aneetece Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Odaa niɡ̶ijo anodiotibece moditalo, “Ǥoniotagodi, digawini! Digoina idiwa itiwataale ɡ̶ododaajoli-ocaɡ̶atedi.” Odaa jeɡ̶eetediogi, “Jaɡ̶abo!” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus noditedicogi nigotaɡ̶a, igo minitaɡ̶a Lojotaɡ̶adi Oliveira ane ligileɡ̶egitedibece. Niɡ̶ijo anodiotibece eledi igotibeci. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Niɡ̶ijo niɡ̶icotedicogi niɡ̶ijo lemaanigi meitedibige, odaa jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Ipokitalo Aneotedoɡ̶ojitiwaji me daɡ̶a ikateda mawii ane beyagi nigetiɡ̶adicini.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Odaa ja yetecetedicoace, iboɡ̶odi mabo me jokolenaɡ̶a wetiɡ̶a. Odaa ja yamaɡ̶atedini lokotidi me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, mee, ");
INSERT INTO kbcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Eiodi, nigemaani, madatamaɡ̶ateenitege niɡ̶inoa yawikodico anenagi, ane jiciaceeketege naɡ̶ana goopa ane nolee niɡ̶ina nacipaɡ̶adi ane bayodi. Pida jemaa me jixomaɡ̶ateetedice niɡ̶ica anakamaɡ̶a emaani, idiɡ̶ida aɡ̶iniɡ̶inoa ane emaɡ̶a jemaa me jixomaɡ̶ateetedice.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Odaa ja dinikeetalo ica aanjo, ane icoɡ̶otibigimece ditibigimedi, enagi me yajigotalo loniciwaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus eɡ̶idaaɡ̶ee me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, odaa eliodi me doɡ̶owikomata, neɡ̶epaa dinonipetetece lawodi ane datikoletedinigi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Naɡ̶a nigotedini me yotaɡ̶aneɡ̶e Aneotedoɡ̶oji, odaa ja dabiditedini, opitacedicogi miditaɡ̶a niɡ̶ijo anodiotibece, odaa jiɡ̶icotediogi me niotaɡ̶a, leeɡ̶odi eliodi me agecaɡ̶alodipi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Odaa jeɡ̶eetediogi, “Igaamenitiwaji ina me iote? Anicootiniwacetiwaji, odaaɡ̶ipokitalo Aneotedoɡ̶oji me daɡ̶a ikateda me oeni ane beyagi nigetiɡ̶adicini.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus eɡ̶idaaɡ̶eeteda me dotaɡ̶a, noɡ̶ototalo ica noiigi-nelegi. Odaa niɡ̶ijo ane liboonaɡ̶adi Judas, anida aneetege niɡ̶ijo dooze anodiotibece Jesus, jiɡ̶ijaa odilokoteloco niɡ̶ijo noiigi. Odaa niɡ̶ipegitalo Jesus ja domaɡ̶a napicoɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pida Jesus meeteta, “Judas, me domaɡ̶adapiciɡ̶i, oleetibige me adikeenitiogi idi ineloɡ̶ododipi, Ee Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Niɡ̶ijo noɡ̶onadi niɡ̶ijo anodiotibece Jesus niɡ̶ida niciagi, odaa ja nigikanaɡ̶a, modi, “Ǥoniotagodi, emaani me jiticodaɡ̶aticoace jatiiɡ̶atiogi ɡ̶ododaajoli-ocaɡ̶atedi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Odaa jiɡ̶ijo ica aneyacilotidi ica limeedi niɡ̶ijo lacilo-sacerdotitedi, yakagiditice napaaɡ̶ate ane diɡ̶eticogi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pida Jesus yoxoɡ̶o, meete, “Jaɡ̶abo, jinaɡ̶aleeɡ̶awii ɡ̶adoenatagi!” Odaa ja dibatedinece napaaɡ̶ate niɡ̶ijo nimeedi, odaa ja yexocaɡ̶aditacedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Odaa jeɡ̶eetediogi niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa icoa ninionaɡ̶a iodaɡ̶awadi anoyowie Aneotedoɡ̶oji liɡ̶eladi, icoa lacilodi judeutedi, anigotibeci moniwilo. Odaa jeɡ̶eetediogi, “Igame leeɡ̶oditiwaji manadeegi inoa ɡ̶adodaajoli-ocaɡ̶atedi inaa ɡ̶aneboli madiwilotiwaji, micataɡ̶a deɡ̶ee ɡ̶onematagodi? ");
INSERT INTO kbcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ijiɡ̶ijo me jawataɡ̶agitiwaji minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi inoatawece nokododi, pida aɡ̶adiwilotiwaji. Pida niɡ̶ina natigide, jiɡ̶icota lakata Aneotedoɡ̶oji ane nibikota mabaatiwatiwaji, ja limedi niɡ̶ina anida aneetege nexocaɡ̶a me ini loniciwaɡ̶a meo loenatagi me dakapetigi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Odaa joɡ̶oniwilo Jesus, joɡ̶oyadeegitedicogi liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. Odaa Pedro ja diotece, pida leegitece me yototedice. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Niɡ̶ijo noɡ̶oyelotigi noledi liwigotigi niogó ica diimigi, odaa ja dinitotibigiwaji. Odaa Pedro jaɡ̶aɡ̶a nicotini miditaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Naɡ̶a nicotini, odaa aca niimete ja nadi liniogotibece noledi. Naɡ̶a iwi, odaa jeɡ̶ee, “Niɡ̶ini aaginaɡ̶a idiaaɡ̶i-iitice mijoataɡ̶a Jesus!” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pida Pedro mee, “Awicije, aɡ̶icoa daɡ̶a yowooɡ̶otagi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aona niɡ̶ica daɡ̶a leegi, ica ɡ̶oneleegiwa naɡ̶aɡ̶a nadi, odaa jeɡ̶ee, “Niɡ̶ida makaami eji makaami eledi ganigepidiɡ̶ica niɡ̶ijo anodiotibece.” Pida Pedro ja igidi, meeta, “Ǥodokaaɡ̶edi, aɡ̶ica daɡ̶a jiotibece!” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naɡ̶a ixomaɡ̶atice onaniteci lakata, ica eledi ɡ̶oneleegiwa jeɡ̶ee, “Jeloɡ̶oditaɡ̶awa niɡ̶ina anewi, niɡ̶ini ɡ̶oneleegiwa idiaaɡ̶itice mijoataɡ̶a, leeɡ̶odi icoɡ̶oticogi nipodigi Galiléia!” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pida Pedro mee, “Nagoodi ɡ̶odokaaɡ̶edi, odaa aɡ̶ica daɡ̶a jowooɡ̶odi niɡ̶ica ane ɡ̶adalakita!” Odaa aoniɡ̶ica daɡ̶a leegi, eɡ̶idaaɡ̶ee me dotaɡ̶atibece, naɡ̶anoe okoɡ̶okoodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Odaa Ǥoniotagodi ja nawiilitetetege me iwiteta Pedro. Odaa Pedro ja nalaɡ̶atibige niɡ̶ijoa Ǥoniotagodi lotaɡ̶ateta, neɡ̶eeteta, “Niɡ̶ina enoale, aniɡ̶icatibige daɡ̶a anoe okoɡ̶okoodi, odaa itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Odaa Pedro ja noditicogi anei, odaa eliodi manoetibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Icoa ɡ̶oneleegiwadi anoyowie Jesus onigiwogotedice, codaa monalaketedibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Onoxoco ligecooɡ̶eli, odaaɡ̶oyalaketigi latobi, odaa joɡ̶oige, moditalo, “Iwela, amiijo ica ane ɡ̶adalakeni?” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Odaa owidi eletidi anodigotalo moyametibigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Naɡ̶a yeloɡ̶otibige, niɡ̶ijoa lacilodi judeutedi, ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, niɡ̶idi ja yatecoɡ̶o. Odaa joɡ̶odipoko monadeegitedicogi Jesus lodoe me dilapode. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Odaa joɡ̶oige, moditalo, “Manige akamaɡ̶akaami Niɡ̶icoa ane niwakatee Aneotedoɡ̶oji me ɡ̶odatamaɡ̶ateetetege ɡ̶odaxakawepodi? Enitoɡ̶owa nige naɡ̶akamaɡ̶akaami!” Odaa ja igidi, meetediogi, “Deɡ̶ejitaɡ̶awatiwaji neɡ̶emeɡ̶ee, aɡ̶adadiwaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Codaa daɡ̶a ɡ̶adigeetiwaji, aɡ̶adigiti. ");
INSERT INTO kbcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pida Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, aɡ̶ica daɡ̶a leegi odaa ja idicotini liwai libaaɡ̶adi Aneotedoɡ̶oji aninoatawece loniciweɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Odaa iditawece joɡ̶oige, moditalo, “Ida makaami, akaami Lionigi Aneotedoɡ̶oji?” Odaa ja igidi, meetediogi, “Ewi niɡ̶ida alitigi ɡ̶agegi ewi neɡ̶emeɡ̶ee Lionigi Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Odaa joɡ̶odi, “Aɡ̶alee jopooɡ̶atibige eledi oko daɡ̶a neloɡ̶oditoɡ̶owa aneyatedigi ligegi, leeɡ̶odi okomoɡ̶oko ja jajipaaɡ̶atalo ane lotaɡ̶aneɡ̶egi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Odaa ijotawece niɡ̶ijo lapo-nelegi dabiditiniwace, odaa joɡ̶oyadeegi Jesus minitaɡ̶a Pilatos. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Odaa ja notaɡ̶anaɡ̶ateloco modakapetege Jesus, modi, “Ja jibaɡ̶atalo niɡ̶idoa ɡ̶oneleegiwa ane niiɡ̶axitediniwace ɡ̶odoiigi modakapetege romaanotedi, codaa me doɡ̶oyedia ane leeditibige me jedianaɡ̶a César, ninionigi-eliodi romaanotedi. Codaa Idaaɡ̶idoa mee ica minionigi-eliodi, Aneotedoɡ̶oji ane niiɡ̶e.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Odaa Pilatos ja ige Jesus, meetalo, “Ewi naɡ̶akamaɡ̶akaami ninionigi-eliodi judeutedi?” Jesus ja igidi, meeteta, “Iniotagodi, ewi niɡ̶ida ɡ̶agegi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Odaa Pilatos jeɡ̶eetiogi niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijo noiigi-nelegi, “Aɡ̶ica ane beyagi ane jinaditece idoa ɡ̶oneleegiwa daɡ̶a jiiɡ̶enatakatalo moyeloadi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pida joɡ̶oyopilaɡ̶aditacelogo niɡ̶ijoa lotaɡ̶a, notigimadaɡ̶a, modi, “Pida niiɡ̶axitediniwace ɡ̶odoiigi anitawece Judéia modakapetege romaanotedi, anetiɡ̶odiiɡ̶e. Yajela nipodigi Galiléia, natigide jeɡ̶enotedicogi digoina Jerusalém.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Niɡ̶ijo Pilatos naɡ̶a wajipatibece Jesus mida aneetetege noiigi galileu, odaa ja ige migewi me galileu. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Igaanaɡ̶a yowooɡ̶odi Pilatos Jesus me icoɡ̶otedicogi nipodigi anei me diiɡ̶enataka Herodes, odaa ja iiɡ̶etedicogi minitaɡ̶a, leeɡ̶odi Herodes aaɡ̶aɡ̶a ini manitaɡ̶a nigotaɡ̶a Jerusalém niɡ̶ijoa nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Niɡ̶ijo Herodes naɡ̶a nadi Jesus, odaa eliodi me ninitibece, leeɡ̶odi ijo me wajipatibece icoa anee, codaa akaa domaɡ̶a yemaa me nadi. Odaa ja walitibigege Jesus deɡ̶eote okanicodaaɡ̶ica ɡ̶odoxiceɡ̶edi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Codaa eliodi me nigetedice Jesus, pida aigidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijo niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés, idiaaɡ̶i dabiditiniwace. Odaa dinoniciwaɡ̶aditibigiwaji me notaɡ̶anaɡ̶a modakapetege Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ijaaɡ̶ijoa niodaɡ̶awadi oniweenigitedice Jesus, codaa moyametibigo. Onixomeɡ̶etedinigi nijayogo inionigi-eliodi, odaa Herodes ja iiɡ̶etacedicogi minitaɡ̶a Pilatos. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Odaa Herodes ijaa Pilatos ja dinokaaɡ̶etewamigi ijaaɡ̶ijo niɡ̶ijo noko, leeɡ̶odi niɡ̶icoa nokododi dinelatiwage. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Odaa Pilatos ja yatecoɡ̶otee niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa niɡ̶ijoa lacilodi judeutedi, codaa mijotawece niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Odaa jeɡ̶eetiogi, “Jaɡ̶anadeegitediwatiwaji niɡ̶idoa ɡ̶oneleegiwa menitiwa ica meote lacilo ɡ̶adoiigi me nakapetegipi romaanotedi. Pida digawinitiwaji, ja inigetedice ɡ̶adodoe, odaa jakadi ina me diɡ̶ica loenatagi ane beyagi, niɡ̶ijoa anenitalo meote. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Codaa Herodes idaaɡ̶ee yakadi me diɡ̶ica loenatagi ane beyagi, joaniɡ̶idaa leeɡ̶odi me niiɡ̶etacedicogi mokotaɡ̶a. Pida digawinitiwaji! Aɡ̶ica loenatagi ane beyagi daɡ̶a leeditibige me jiiɡ̶enatakatalo moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pida jiiɡ̶enatakatalo moyametibigo, odaa nigidiaaɡ̶idi ja jikatedice.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Inoatawece nicaaɡ̶ape me nakatio nalokegi Páscoa, leeditibige Pilatos me ikatice onidateci ɡ̶oneleegiwa niwilogojegi, leeɡ̶odi mina ligileɡ̶egitibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Odaa iditawece niɡ̶idi noiigi notaɡ̶anaɡ̶ateloco, codaa napaawaɡ̶ateloco, modi, “Adeegi niɡ̶idoa ɡ̶oneleegiwa meloati, odaa anikanitoɡ̶odomi Barrabás!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Niɡ̶ica Barrabás one niwilogojegi leeɡ̶odi eyatege niɡ̶idi noiigi me lakapetegipi ninionigi-eliodi romaanotedi, codaa onica laigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Odaa Pilatos joɡ̶opitacege me notaɡ̶aneɡ̶etiniwace, leeɡ̶odi domaɡ̶a lipegeɡ̶edi me ikatedice Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pida jeɡ̶epaanaɡ̶a napaawaɡ̶ateloco niɡ̶ijo noiigi, modi, “Otonitedeloco nicenaɡ̶anaɡ̶ate! Otonitedeloco nicenaɡ̶anaɡ̶ate!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Odaa jiɡ̶icota me itoatadiɡ̶ida Pilatos me nigetiniwace, meetiogi, “Pida amiini ica loenatagi ane beyagi me leeditibige me jiiɡ̶enatakatalo moyeloadi? Emeɡ̶ee aɡ̶ica jakadi ane leeɡ̶odi daɡ̶a jiiɡ̶enatakatalo moyeloadi. Pida jiiɡ̶enatakatalo monalaketedibige. Nigidiaaɡ̶idi odaa ja jikatedice.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pida idokee modoletibige niɡ̶ica mowo anodigotalo Jesus, codaa jeɡ̶epaanaɡ̶a dinigetaɡ̶ateetibigiwaji me napaawaɡ̶ateloco, modipokotibige moyototedeloco Jesus nicenaɡ̶anaɡ̶ate. Niɡ̶ijo noiigi ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi napaawaɡ̶a neɡ̶epaa oyakadi anodoletibige. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Odaa Pilatos ja yajigo Jesus midiwa iodaɡ̶awadi mowo niɡ̶ica anoyemaa modigotalo niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Odaa ja ikatice niɡ̶ijo anodipoko me ikatice, ane diniwilo leeɡ̶odi meyatege loiigi modakapetege ninionigi-eliodi romaanotedi codaa me daije. Pida Jesus baanaɡ̶a yajigo midiwa iodaɡ̶awadi moyeloadi, anoyemaa niɡ̶ijo noiigi-nelegi modigotalo. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oyadeegi Jesus. Eɡ̶idaa diiticogi migotibeci, joɡ̶odakapetege ica ɡ̶oneleegiwa ane liboonaɡ̶adi Simão ane liɡ̶eladi nigotaɡ̶a Cirene. Simão icoɡ̶oticogi nipodigi. Odaa joɡ̶odibata Simão, oyexaɡ̶ateloco naɡ̶ajo nicenaɡ̶anaɡ̶ate digoina lewagi, odaa joɡ̶owo me yadeegi dilokotelogo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Eliodi ica noiigi anodiotece Jesus. Liwigotigi niɡ̶idi oko ijo iwaalepodi ane noenaɡ̶ateloco, codaa eliodi me agecaɡ̶alodipi leeɡ̶odi niɡ̶ida anodigotalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pida Jesus naɡ̶a nawiilitetetege, odaa jeɡ̶eetediogi, “Iwaalepodi, anakaami niɡ̶eladimigipitigi Jerusalém, jinaɡ̶anoeni leeɡ̶odi niɡ̶ida aneji, pida anoeni leeɡ̶odi akamaɡ̶akaamitiwaji idiaa ɡ̶adionigipi! ");
INSERT INTO kbcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Leeɡ̶odi ewi micota nokododi niɡ̶ina oko nigodi, ‘Ninitibigiwaji niɡ̶ina iwaalepodi analee diɡ̶ica linala!’ ");
INSERT INTO kbcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Codaa odipokotalo niɡ̶inoa wetiadi, modi, ‘Ǥodapoɡ̶oteɡ̶egiti!’ Codaa oditiogi niɡ̶inoa lojotakatedi, ‘Ǥodaaɡ̶ateɡ̶egitini!’ ");
INSERT INTO kbcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Igaataɡ̶a nigowo niɡ̶ida anodigotiwa, Ee ane ideɡ̶enaɡ̶a, ane iciagi niɡ̶ina iwoɡ̶o baɡ̶alee dione (ane doɡ̶oibake mowo noledi), pida ɡ̶adaxakawepodi baɡ̶a daɡ̶axa me beyagi anodigotaɡ̶awa, ane ɡ̶adiciagi niɡ̶ina iwoɡ̶o baanaɡ̶a yadilo (ane yabidi, odaa aɡ̶ica ane yeyaɡ̶atice).” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niɡ̶ijoa iodaɡ̶awadi eletidi oyadeegi itoataale ɡ̶oneleegiwadi ɡ̶onematagododi me lemaɡ̶awepodi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Niɡ̶ijo noɡ̶otota ica lojotaɡ̶adi ane liboonaɡ̶adi “Libitagi Ǥodacilo”, odaa jiɡ̶idiaaɡ̶i Jesus moyototedeloco nicenaɡ̶anaɡ̶ate. Ijaaɡ̶ijoa itoataale ɡ̶oneleegiwadi ɡ̶onematagododi eletidi nicenaɡ̶anaɡ̶atedi anoyototelogo, onidateci diɡ̶eticogi liwai libaaɡ̶adi Jesus, ijo eledi diɡ̶etege nimagijegi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus mee, “Eiodi, jinaɡ̶aloikatiti niɡ̶idi noiigi leeɡ̶odi niɡ̶ida anodigotiwa. Igaataɡ̶a aɡ̶oyowooɡ̶odi niɡ̶ida ane loenatagi.” Odaa joɡ̶oiwi anepaɡ̶a dinetetece noɡ̶odinawalacetibige lowoodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ica noiigi-nelegi idiaaɡ̶itice dabiditiniwace oiwitalo Jesus, ijaaɡ̶ijoa lacilodi eletidi idiaaɡ̶iticoaci, odaa modi, “Eote eledi oko me newiɡ̶atace. Daantiɡ̶idaaɡ̶idoa Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi, ane iomaɡ̶aditedice Aneotedoɡ̶oji, daɡ̶anagawini ida nimaweneɡ̶egi meote lewiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Niɡ̶ijoa iodaɡ̶awadi oyametibigo Jesus. Igotibeci midoataɡ̶a domoɡ̶oyacipeɡ̶etalo viinyo ane daɡ̶a dakake loojedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Odaa moditalo, “Nigewi makaami ninionigi-eliodi judeutedi, dicakamaɡ̶a awii ɡ̶adewiɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Madataɡ̶a licenaɡ̶anaɡ̶ate Jesus ditibigimedawaanigi lacilo, oyototeloco taaboa-liwai ane diniditeloco, “NIǤIDOA NINIONIGI-ELIODI JUDEUTEDI.” Diniditelogo niɡ̶ijoa notaɡ̶a nioladi greego, nioladi romaano, nioladi hebraico. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ganigepidiɡ̶ica niɡ̶ijoa itoataale ɡ̶onematagododi anaɡ̶aɡ̶a oyototeloco nicenaɡ̶anaɡ̶ate, beyagi lotaɡ̶atalo Jesus, meetalo, “Nigewi naɡ̶akamaɡ̶akaami ane niiɡ̶e Aneotedoɡ̶oji, dice awii ɡ̶adewiɡ̶a, codaa moko awii ɡ̶odewiɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pida niɡ̶ijo eledi ɡ̶onematagodi ja yoxoɡ̶o, meeta, “Jinaɡ̶awii niɡ̶ida ɡ̶agegi, agodaɡ̶adoiitalo Aneotedoɡ̶oji? Etiɡ̶odiloikatidi midokida anodigotoɡ̶owa. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Codaa niɡ̶ida ɡ̶odawikodigi oko itoataale baɡ̶a iɡ̶enaɡ̶a, leeɡ̶odi me jedianaɡ̶ateloco niɡ̶ijoa ɡ̶odoenataka ane beyagi. Pida niɡ̶idoa ɡ̶oneleegiwa, aɡ̶ica loenatagi ane beyagi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Odaa jeɡ̶eetalo Jesus, “Iniotagodi, analakitibigiji, nigadopilitijo, nige limedi managi iiɡ̶eni inoatawece.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Odaa Jesus jeɡ̶eeteta, “Ejitaɡ̶awa niɡ̶ina anewi, niɡ̶ina noko adeoni meetaɡ̶a digoida ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Naɡ̶a nipegi me yaxoɡ̶o-noko, odaa aligeɡ̶e ja ipe, ja nexocaɡ̶a inatawece iiɡ̶o, neɡ̶epaa iniwatadaɡ̶ani lakata me ɡ̶ocidi. Codaa naɡ̶ajo lipegeteɡ̶e minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, ane iomaɡ̶aditege oko aneite Aneotedoɡ̶oji, naɡ̶ajo lipegeteɡ̶e daawidigidicetigi liwigotigi ditibigimedi, icoɡ̶otibigimece ditibigimedi neɡ̶epaa natinedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Odaa Jesus dinigetaɡ̶atee me dapaawe, mee, “Eiodi, jajigotaɡ̶awa iwigo!” Naɡ̶a nigotedini me dotaɡ̶a, odaa ja yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Niɡ̶ijo nowienoɡ̶odi niodaɡ̶awadi romaanotedi naɡ̶a nadi niɡ̶ijo niciagi, odaa ja iweniɡ̶ide Aneotedoɡ̶oji, mee, “Niɡ̶ica mewi niɡ̶idoa ɡ̶oneleegiwa me diɡ̶icata loenatagi ane beyagi!” ");
INSERT INTO kbcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ijotawece niɡ̶ijo oko ane dilapode moiwi niɡ̶ida niciagi, joɡ̶oyabaketibigeloco elipije, moikee magecaɡ̶alodipi, odaa niɡ̶idiaaɡ̶idi joɡ̶opiticogi inoa liɡ̶elatedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Odaa ijotawece niɡ̶ijo lokaaɡ̶etedipi Jesus, ijaaɡ̶ijo iwaalepodi anoniotece, oicoɡ̶oticogi nipodigi Galiléia, aɡ̶ipegitiobece, pida boɡ̶onadi ijoatawece anee niɡ̶ijo niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Onini ica ɡ̶oneleegiwa ane liboonaɡ̶adi José, ane liɡ̶eladi aca nigotaɡ̶a Arimatéia, nipodigi Judéia. Inaaɡ̶ina ɡ̶oneleegiwa anele, codaa me iɡ̶enaɡ̶a, nibeotibigege ica noko Aneotedoɡ̶oji nige iiɡ̶e inatawece iiɡ̶o. Codaa ida aneetege icoa seteenta lacilodi judeutedi. Pida aniwoditema niɡ̶icoa eletidi lacilodi, niɡ̶ijo noɡ̶odoletibige nimaweneɡ̶egi mowo anodigotalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niɡ̶ijo ɡ̶oneleegiwa igo minitaɡ̶a Pilatos dipokota Jesus lolaadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Odaa José jiɡ̶igo noɡ̶a Jesus lolaadi madataɡ̶a nicenaɡ̶anaɡ̶ate, odaa ja ilipaditigi aca niɡ̶elate. Niɡ̶idiaaɡ̶idi ja ixotiwece niɡ̶ijo lolaadi Jesus catiwedi ica lawimaɡ̶ajegi-wetiɡ̶a, baanaɡ̶a igo me dinaligi maditaɡ̶a aca wetiɡ̶a. Niɡ̶ijo lawimaɡ̶ajegi aniɡ̶ica doɡ̶oibake diɡ̶ica émeɡ̶egi anoixotiwece. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Niɡ̶ijo noko anaɡ̶a nakatio saabado, pida niɡ̶ijo noko niɡ̶idi noiigi joɡ̶odinoetege ica saabado. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Niɡ̶ijo iwaalepodi anoniotece Jesus anoicoɡ̶oticogi Galiléia, joɡ̶odioteci José. Odaa boɡ̶onadi niɡ̶ica lawimaɡ̶ajegi-wetiɡ̶a, codaa monadi niɡ̶ica anodigota lolaadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Niɡ̶idiaaɡ̶idi joɡ̶opiticogi inoa liɡ̶elatedi, odaa joɡ̶oyoe edokojetedi, ina najidi aneletege lanigi, moyatita Jesus lolaadi. Naɡ̶a saabado jaɡ̶anipetiniwace, ane liiɡ̶enatakaneɡ̶egi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Naɡ̶a domiingo me nigoitijo, niɡ̶ijo iwaalepodi jiɡ̶igotibeci midataɡ̶a niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a anoyatice lolaadi Jesus, oyadeegi nadokojetedi anoyoe. Codaa ijo eledi iwaalepodi lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Niɡ̶icotiobeci, odaa joɡ̶onadi naɡ̶ajo wetiɡ̶a nelegi anoyatita monoxoco niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, joɡ̶onoɡ̶aticogi niɡ̶ijo aneitice. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pida naɡ̶a dakatiobece, aɡ̶aleeɡ̶ica moyakadi lolaadi Ǥoniotagodi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aɡ̶oyowooɡ̶odi ane diitigi niɡ̶ida niciagi, odaa eɡ̶idaaɡ̶ee me nowookonaɡ̶a, codaa noɡ̶onida dinikeetiogi lodoe itoataale ɡ̶oneleegiwadi, odinixotinigilo nowoodi ane datale. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Odaa niɡ̶ijo iwaalepodi eliodi me doitibigiwaji, dakagitiniwace neɡ̶epaa iiɡ̶o. Odaa niɡ̶ijoa ɡ̶oneleegiwadi ja nigikanaɡ̶a, modi, “Igaameni ina moleetibigetiwaji midiwataɡ̶a émaɡ̶aɡ̶a ijoa baanaɡ̶a yewiɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aɡ̶icoatedigi digoina, pida ja yewiɡ̶atace. Eɡ̶analakitibigetiwaji ijoa lotaɡ̶atedaɡ̶awa maleeɡ̶idiaaɡ̶itedice nipodigi Galiléia, niɡ̶ijo neɡ̶eetedaɡ̶awatiwaji, ");
INSERT INTO kbcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, leeditibige metidajigotiogi ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a, codaa etidototeloco nicenaɡ̶anaɡ̶ate, igaanige ixomaɡ̶atedijo itoatadiɡ̶ida nokododi, odaa ja idewiɡ̶atace.’” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Odaa niɡ̶ijo iwaalepodi joɡ̶onalaɡ̶atigilo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Odaa joɡ̶opitibeci, me icoɡ̶oticogi midataɡ̶a lawimaɡ̶ajegi-wetiɡ̶a, igotibeci oyeloɡ̶oditiogi niɡ̶ijo oonze anodiotibece Jesus, ijaaɡ̶ijo eletidi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Niɡ̶ijo iwaalepodi noɡ̶oyatematitiogi niɡ̶ijoa liiɡ̶exedi Jesus, anonadi, niɡ̶idi iwaalepodi liboonaɡ̶atedi Maria Madalena, Joana, Maria ane eliodo Tiago, ijaaɡ̶ijo eledi iwaalepodi lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pida noɡ̶owajipata niɡ̶ijo latematigo niɡ̶ijo iwaalepodi, oyakadi ina daɡ̶a dinetoletibigiwaji, odaa aɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pida naɡ̶a dabiditi Pedro, odaa ja walokoditicogi midataɡ̶a niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a. Niɡ̶icoticogi, odaa dakagitini iwitiwece catiwedi. Pida ijoka naditeda niɡ̶ijoa niɡ̶elateli. Odaa joɡ̶opiticogi liɡ̶eladi, eliodi me nawela leeɡ̶odi niɡ̶ijo ane nadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ijaaɡ̶ijo niɡ̶ijo noko itoataale anodiotibece igotibeci manitaɡ̶a nigotakawaana anodita Emaús, ejime itoa leegoa me yototice Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Niɡ̶ijoa ɡ̶oneleegiwadi odinotaɡ̶aneɡ̶etigi niɡ̶icoa ane loanico Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eoniɡ̶idaaɡ̶ee me dinotaɡ̶aneɡ̶e, dinotigimadetiwage, naɡ̶a iwidatediogi Jesus, odaa ja lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Odaa noɡ̶onadi aɡ̶oyowooɡ̶odi, Aneotedoɡ̶oji eote me doɡ̶oyowooɡ̶oditeda. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Odaa Jesus ja nigetediniwace, meetediogi, “Amiina ica ane ɡ̶adalakitatiwaji ina naigitece? Codaa igame leeɡ̶odi ina makaami agecaɡ̶alodipi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Odaa ica ane liboonaɡ̶adi Cleopas ja igidi, meetalo, “Manigakamokakaami ane ideoni Jerusalém, ane daɡ̶a yowooɡ̶odi ijo niciagi, natigidiwaɡ̶a niɡ̶ijoa nokododawaanaɡ̶a ane ixomaɡ̶atedice?” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Odaa ja digika, meetediogi, “Amiida ica niciagi ane ɡ̶adalaki?” Odaa joɡ̶oigidi, moditalo, “Idinotaɡ̶aneɡ̶enaɡ̶atigi ninyaagi Jesus, niɡ̶ijoa anelatedibige Nazaré. Inaaɡ̶ina niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, eliodi nimaweneɡ̶egi niɡ̶ina me dotaɡ̶a, codaa owidi loenataka datikate loniciwaɡ̶a lodoe Aneotedoɡ̶oji, codaa me lodoe eliodi oko. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa ɡ̶odacilodi oyajigo moyeloadi, odaa joɡ̶oyototedeloco nicenaɡ̶anaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pida ja domiɡ̶ijaa jaliiɡ̶atalo me yatamaɡ̶ateetetege ɡ̶odoiigi Israel niɡ̶ina laxakawepodi. Pida niɡ̶ina noko jeɡ̶eote itoatadiɡ̶ida nokododi moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pida ijo iwaalepodi ɡ̶odokaaɡ̶etedipi mejiwaɡ̶atibece Ǥoniotagodi, owotibige meliodi me ɡ̶odawela. Eka yapacaɡ̶atege nigoi, niɡ̶igotibeci midataɡ̶a lawimaɡ̶ajegi-wetiɡ̶a anoyatice lolaadi Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Odaa aɡ̶aleeɡ̶ica moyakadi lolaadi. Odaa ja dopitijo modi ica modinikeetiogi icoa aanjotedi, odaa niɡ̶icoa aanjotedi onodi ica naɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Odaa jiɡ̶ijo ɡ̶odokaaɡ̶etedipi anigotibeci midataɡ̶a niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a, odaa joɡ̶onadi mewi niɡ̶ijo anodita niɡ̶ijo iwaalepodi. Pida aɡ̶icoa monadi Ǥoniotagodi Jesus.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Odaa Jesus jeɡ̶eetediogi, “Niɡ̶ida makaamitiwaji aɡ̶ica ɡ̶adowoogo, codaa dakake ɡ̶adaaleɡ̶enali, me daɡ̶a iwaɡ̶atiteda ijoatawece lotaɡ̶a niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Niɡ̶ijoa Aneotedoɡ̶oji ane niiɡ̶e leeditibige me dawikode, odaa ja dakatediwece miniwataɡ̶a Eliodi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Odaa ja yeloɡ̶oditediogi ijotawece liwai Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi aneetece Jesus. Yajela niɡ̶ijo liwai Moisés ligegi, ijaaɡ̶ijo liwai aneetece Jesus, anoidi niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Niɡ̶ijo noɡ̶odipegita naɡ̶ajo nigotakawaana ane diiticogi, Jesus eote micataɡ̶a daɡ̶a ixomaɡ̶atedicogi odoe. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Odaa joɡ̶onolitedini, moditalo, “Inaaɡ̶oni mokotaɡ̶a, leeɡ̶odi ja ɡ̶ocidi.” Odaa ja dakatediwece ica diimigi, midiaaɡ̶inawaanigite. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Odaa niɡ̶ica naɡ̶a nicotedi maditaɡ̶a aca nameeja, ijaaɡ̶ijoa itoa ɡ̶oneleegiwadi, naɡ̶a dibate ica paon, odaa ja diniotagodete Aneotedoɡ̶oji. Naɡ̶a inoke niɡ̶ijo paon, odaa ja yajigotediogi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Odaa Aneotedoɡ̶oji jeɡ̶eote niɡ̶ijoa ɡ̶oneleegiwadi moyowooɡ̶odi me Jesus. Pida jiɡ̶idiaa laakadi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Odaa oninitecibeci mee, “Agodaɡ̶aleeɡ̶aɡ̶a, jowooɡ̶otaɡ̶a naɡ̶a itineɡ̶e ɡ̶odaaleɡ̶ena, niɡ̶ijo naɡ̶a ɡ̶odotaɡ̶aneɡ̶etedice digoida naigi me neloɡ̶oditedoɡ̶owa liwai Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi?” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ajaaɡ̶ajo naɡ̶ajo lakata naɡ̶a dabiditiniwace, odaa joɡ̶opitacicogi nigotaɡ̶a Jerusalém. Odaa joɡ̶ototiogi niɡ̶ijo oonze anodiotibece Jesus, ijaaɡ̶ijo eledi oko anawatege. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Odaa moditiogi niɡ̶ijo itoataale, “Dicewi Ǥoniotagodi naɡ̶a yewiɡ̶atace. One dinikeeteta Simão.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Odaa niɡ̶ijo itoataale jaɡ̶aɡ̶oyatemati anodaaɡ̶ee monadi digoida naigi, codaa oyatemati moyowooɡ̶odi Ǥoniotagodi niɡ̶ijo naɡ̶a inoke niɡ̶ijo paon. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eoniɡ̶idaaɡ̶ee moyatemati, codaa noɡ̶onidoateda Jesus naɡ̶a dinikee liwigotigi. Odaa jeɡ̶eetediogi, “Jemaa Aneotedoɡ̶oji meote mele ɡ̶adaaleɡ̶enalitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pida nawelatibigiwaji, codaa eliodi me doitibigiwaji, odiletibige doɡ̶onadi niwigo. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pida meetediogi, “Igame leeɡ̶odi ina manawelatiwaji? Codaa igame leeɡ̶odi me dawienataka ɡ̶adaaleɡ̶ena? ");
INSERT INTO kbcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Digawini ibaaɡ̶atedi, codaa me iɡ̶onaka! Odaa jaɡ̶anati mewi neɡ̶emeɡ̶ee. Digabaatiloco, odaa joɡ̶owooɡ̶oti neɡ̶emeɡ̶ee! Leeɡ̶odi niwigo aɡ̶icoa liboledi, oteɡ̶exaaɡ̶aɡ̶a libitaka, pida akaamitiwaji madati biɡ̶inoa iboledi.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Niɡ̶ijo neɡ̶ee, odaa ja ikee libaaɡ̶atedi, codaa me loɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pida aneɡ̶eniwaɡ̶atakanaɡ̶a, leeɡ̶odi meliodi me nawelatibigiwaji, codaa me ninitibigiwaji. Odaa Jesus ja digika, meetediogi, “Aɡ̶ica anigetiɡ̶ida ɡ̶aweenigi domaɡ̶a jeligo?” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Odaa joɡ̶oyajigotalo liwai noɡ̶ojegi niloogo. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Odaa ja dibatetege, jaɡ̶aniodi lodoe niɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Niɡ̶idiaaɡ̶idi Jesus meetediogi, “Maleeɡ̶inaaɡ̶ejotice makaamitaɡ̶atiwaji neɡ̶ejitaɡ̶awa me leeditibige me jixomaɡ̶ateetedice ijoatawece niɡ̶ijoa aneetici maditaɡ̶a Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, miditaɡ̶a niɡ̶ijo ane idí Moisés, miditaɡ̶a niɡ̶ijoa anoidi niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, codaa midiwataɡ̶a enaco.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Odaa ja yajigotediogi lixakedi moyowooɡ̶odi ane diitigi lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Odaa jeɡ̶eetediogi, “Niɡ̶ida diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, Niɡ̶ijoa ane niwakatee Aneotedoɡ̶oji me yewikatidi oko, ane Cristo, leeditibige me dawikode, codaa me yeleo, odaa yewiɡ̶atace nige ixomaɡ̶atedice itoatadiɡ̶ida nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Eledi diniditeloco niɡ̶ijoa liiɡ̶exedi moyeloɡ̶oditiogi niɡ̶ina oko me leeditibige modinilaatece libeyaceɡ̶eco, odaa joɡ̶odopitalo Aneotedoɡ̶oji me iwilegi laaleɡ̶enali. Niɡ̶idi liiɡ̶exedi oyeloɡ̶odi niɡ̶inoa nibodicetedi odatika liboonaɡ̶adi Cristo, minataɡ̶a inatawece noiigi, oyajela nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Akaami nakataɡ̶anadi niɡ̶ijo ane ininyaagi, odaa eloɡ̶otitedibece niɡ̶ijoa ananati! ");
INSERT INTO kbcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Odaa digawini! Emeɡ̶ee iniwakateetibigaɡ̶ajitiwaji niɡ̶ijo Eiodi aneeteta. Pida ecoɡ̶otace inaaɡ̶oni nigotaɡ̶a Jerusalém, nigepaaɡ̶abaategetiwaji Liwigo Aneotedoɡ̶oji ane icoɡ̶otibigimece ditibigimedi ane yajigotaɡ̶awa ɡ̶adoniciwaɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Odaa Jesus ja yadeegitedicogi wetice nigotaɡ̶a neɡ̶epaa manitaɡ̶a nigotakawaana Betânia. Naɡ̶a nawacetedibige libaaɡ̶atedi, odaa ja ibinietediogi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eɡ̶idaaɡ̶ee me ibinietediogi, Jesus jaɡ̶anojicetedice, odaa joɡ̶oyadeegitedibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Niɡ̶ijo anodiotibece odoɡ̶etetibigimece, odaa joɡ̶opitacicogi manitaɡ̶a nigotaɡ̶a Jerusalém, eliodi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Odaa idioka limedi me ideiticoace minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi, modigaanaɡ̶atibigimece, codaa modiniotagodetalo Aneotedoɡ̶oji. Odaa jiɡ̶idaaɡ̶ee. (Amém).");
INSERT INTO kbcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Niɡ̶ijoa anoyatedigi me Notaɡ̶a akaaɡ̶iniwa aniɡ̶icatibige daɡ̶a igo inoatawece niɡ̶inoa ane jinataɡ̶a. Odaa iniwa Niɡ̶ijoa anoditalo me Notaɡ̶a miniwataɡ̶a Aneotedoɡ̶oji, codaa iniaaɡ̶iniwa Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Akaaɡ̶iniwa miniwataɡ̶a Aneotedoɡ̶oji maleediɡ̶icoateda inoatawece niɡ̶inoa ane jinataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aneotedoɡ̶oji iiɡ̶e meote inoatawece niɡ̶inoa ane jinataɡ̶a. Aɡ̶ica idi ane daɡ̶a loenatagiteda. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Okanicodaaɡ̶ica ane yewiɡ̶a, yewiɡ̶a leeɡ̶odi Iniaaɡ̶iniwa. Niɡ̶ina meote lewiɡ̶a oko, liciagi naɡ̶ana lokokena ane ikeeta oko anewi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Naɡ̶ani lokokena ídi miditaɡ̶a nexocaɡ̶a. Codaa nexocaɡ̶a ayakadi daɡ̶a ipeedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Niɡ̶ijo eledi João anodita João Batista. Niɡ̶ijo ɡ̶oneleegiwa liiɡ̶exegi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aneotedoɡ̶oji iiɡ̶e João me yalaɡ̶ata anodaaɡ̶ee naɡ̶aca lokokena, eotibige minatawece oko oyakadi moyiwaɡ̶adi naɡ̶aca lokokena, leeɡ̶odi lotaɡ̶a João. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pida João aniɡ̶ijaa lokokena, pida enagi me yalaɡ̶ata naɡ̶aca lokokena. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Niɡ̶ijoa anepeɡ̶ewi me lokokena, ane nalotedeloco inatawece oko, jeɡ̶enagi digoina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Odaa jiɡ̶inaaɡ̶itedice digoina iiɡ̶o. Codaa jeɡ̶epaa eote niɡ̶ina iiɡ̶o, pida niɡ̶ina okotigi digoina iiɡ̶o aɡ̶oyowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Enagi miditaɡ̶a niɡ̶idi epaa nipodigi, pida niɡ̶idi loiigi aɡ̶odibatege. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pida ijotawece niɡ̶ijo anodibatege Niɡ̶ijoa ane lokokena, anonakato, Aneotedoɡ̶oji baɡ̶a yajigote naɡ̶atetigi me lionigipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aleeɡ̶odi ane licoɡ̶egi eliododipi, codaa aleeɡ̶odi eliododipi moyemaa lionigipi, eleditace aleeɡ̶odi lowooko ɡ̶oneleegiwadi, pida ida aneetetege leeɡ̶odi miniaaɡ̶iniwa Aneotedoɡ̶oji eote me gela lewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Niɡ̶ijoa anewi me Notaɡ̶a dinanatedigi me ɡ̶oneleegiwa, odaa ja inaaɡ̶ite mokotaɡ̶a. Idioka limedi meletedoɡ̶odomi, codaa me nikeetedoɡ̶owa inoatawece anewi niɡ̶inoa ane ikee anodaaɡ̶eeteda Aneotedoɡ̶oji. Jinataɡ̶a mida loniciwaɡ̶a, leeɡ̶odi mokiniwatece me Lionigi niɡ̶ijoa Eliodi ane ideite ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Batista ijo me yalaɡ̶atalo, mee, “Joaniɡ̶iniaaɡ̶iniwa anejitece niɡ̶ijo meji, ‘Odaa nigidiaaɡ̶idi nige leecawaanigi me jano, enagi ane daɡ̶axa me ɡ̶oneɡ̶egi, aiciagi, leeɡ̶odi akaaɡ̶iniwa jotigide maleedaɡ̶a janitini’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Idioka limedi mokotawece jibaɡ̶atege ane icoɡ̶otibigimece miniwataɡ̶a ane daɡ̶axa mele, leeɡ̶odi daɡ̶axa meletedoɡ̶odomi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés najigotedoɡ̶owa liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji, pida Jesus Cristo baɡ̶a nikeetedoɡ̶owa me ɡ̶odemaa Aneotedoɡ̶oji, codaa eleditace nikeetedoɡ̶owa anewi niɡ̶ica anodaaɡ̶eeteda Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aɡ̶ica ini oko baanaɡ̶a nadi Aneotedoɡ̶oji. Pida oniniwatece Lionigi anidioka limedi me ipegitetege Eliodi, baaniɡ̶iniaa nikeetedoɡ̶owa anodaaɡ̶eeteda Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Joaniɡ̶idaaɡ̶ee João eetece anodaaɡ̶eeteda Jesus, niɡ̶ica naɡ̶a oniiɡ̶e icoa lacilodi judeutedi midataɡ̶a João niɡ̶ijoa sacerdotitedi ijaaɡ̶ijoa leviitatedi. Niiɡ̶exedi oicoɡ̶oticogi manitaɡ̶a nigotaɡ̶a Jerusalém. Niɡ̶ijo noɡ̶otota João, odaa joɡ̶oige modita, “Amakaami ida makaami?” ");
INSERT INTO kbcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","João iɡ̶enaɡ̶a me dineloɡ̶odi, adiwitaka, neɡ̶eetiogi, “Aneɡ̶emeɡ̶ee Cristo, Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Odaa joɡ̶oigetace, modita, “Enice, amakaami? Akaami Elias?” Naɡ̶a niniɡ̶odi meetiogi, “Aneɡ̶emeɡ̶ee”. Noɡ̶oigetace, modita, “Anaɡ̶akamaɡ̶akaami ica ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, ane yalaɡ̶ata Moisés?” Odaa ja niniɡ̶odi meetiogi, “Aneɡ̶emeɡ̶ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Odaa joɡ̶oigetace, modita, “Enice igame eni makaami? Jopooɡ̶atibige me jowooɡ̶otaɡ̶a anakaami me ininiɡ̶otaɡ̶a niɡ̶ijo anetiɡ̶odiiɡ̶e”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Igaanaɡ̶a niniɡ̶oditiogi João, eetece niɡ̶ijoa lotaɡ̶a Isaías, niɡ̶ijo liotagi Aneotedoɡ̶oji ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji. Odaa jeɡ̶ee, “Ee niɡ̶ina ane datematika midi nipodigi ane yadilo, ane diɡ̶ica niɡ̶eladimigipi, anee, ‘Niɡ̶ina boɡ̶oenitiwaji naigi ane igotetece Ǥoniotagodi’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niɡ̶idi ane igotibeci liiɡ̶exedi fariseutedi joɡ̶oige João, ");
INSERT INTO kbcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Modita, “Meni daɡ̶akaami Cristo, niɡ̶icoa liiɡ̶exegi Aneotedoɡ̶oji me ɡ̶odewikatidi, codaa oteɡ̶exaaɡ̶aɡ̶a akaami Elias, oteɡ̶exaaɡ̶aɡ̶a akaami niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, ane yalaɡ̶ata Moisés. Enice, igaamee manilegenitiniwace oko?” ");
INSERT INTO kbcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Naɡ̶a igidi João, meetiogi, “Ee baɡ̶a jilegenaɡ̶ata ninyoɡ̶odi. Pida digoina ɡ̶adiwigotigitiwaji ini ɡ̶oneleegiwa ane diɡ̶ica mowooɡ̶otitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nige leecawaanigi me jano, odaa jaɡ̶aɡ̶enagi ane daɡ̶axa me ɡ̶oneɡ̶egi, aiciagi, oteɡ̶exaaɡ̶aɡ̶a jakadi daɡ̶a ee liotagi me jowilece leejetedi liwelatedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Niɡ̶ica noko monigetice João idei digoida manitaɡ̶a aca nigotakawaana ane liboonaɡ̶adi Betânia, ane ideitice daato akiidi Jordão, aneite João me nilegetiniwace oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Neɡ̶eledi noko João ja naditege Jesus migo midataɡ̶a. Odaa João jeɡ̶ee, “Digawinitege! Niɡ̶inoa joaniɡ̶inaaɡ̶inoa Waxacoco ane niwakateetedigi Aneotedoɡ̶oji, ane noɡ̶a libeyaceɡ̶eco inatawece oko digoina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jiɡ̶ijo me idalaɡ̶atalo, niɡ̶ijo meji, ‘Nige leecawaanigi me jano, odaa jaɡ̶aɡ̶enagi ɡ̶oneleegiwa ane daɡ̶axa me ɡ̶oneɡ̶egi, aiciagi, leeɡ̶odi akaaɡ̶iniwa maleediɡ̶icatibige me janitini’. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Emeɡ̶eeta aɡ̶epece jowooɡ̶odi aniniwa. Pida janagi inilegetiniwace oko jatitiogi ninyoɡ̶odi, jaotibige loiigi Israel moyakadi moyowooɡ̶odi anijoa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","João eɡ̶idaa diitigi me yalaɡ̶atalo Cristo, mee, “Ee ajowooɡ̶odi niɡ̶ica anijoa. Pida Aneotedoɡ̶oji, ane idiiɡ̶e me jinilegetiniwace oko, jatita ninyoɡ̶odi, neloɡ̶otediwa, meetediwa, ‘Icota manati Liwigo Aneotedoɡ̶oji me dinikateloco lacilo ɡ̶oneleegiwa. Odaa niɡ̶idoa ɡ̶oneleegiwa jiɡ̶idaaɡ̶idoa ane ixotediwece oko Aneotedoɡ̶oji Liwigo me yajigota loniciwaɡ̶a’. Ee jinadi Liwigo Aneotedoɡ̶oji me dinikatelogo Jesus icoɡ̶otibigimece ditibigimedi macataɡ̶a yotibi. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ewi me jinadi niɡ̶ida niciagi, odaa ewi niɡ̶ijaaɡ̶ijoa Lionigi Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Neɡ̶eledi noko, idiaaɡ̶itace João icaaɡ̶icoa itoataale anodiotibeci. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niɡ̶ica naɡ̶a naditece Jesus me ixomaɡ̶atedijo, odaa jeɡ̶eetiogi João, “Digawinitiwaji. Niɡ̶ijoa digoida, niɡ̶ijoa Waxacoco ane niiɡ̶e Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Noɡ̶owajipata niɡ̶ijo itoataale anodiotibeci, odaa joɡ̶oigaalatece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Naɡ̶a nilokotetege Jesus, odaa ja naditetege moigaalatece. Odaa ja nigetediniwace, meetediogi, “Amiina ica anoleetibigetiwaji?” Odaa joɡ̶oigidi moditalo, “Rabi, igamei ica ɡ̶adiɡ̶eladi?” (“Rabi” niɡ̶ina anejinaɡ̶a “Ǥoniiɡ̶axinoɡ̶odi”.) ");
INSERT INTO kbcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus meetediogi, “Anagitiwaji, awini ane yotokaɡ̶adi”. Odaa jiɡ̶igotibeci, joɡ̶onadi ane lotokaɡ̶adi Jesus. Odaa jiɡ̶idiaaɡ̶i miniwataɡ̶a niɡ̶ijo noko. Naɡ̶a doletibige me deez lakata me nigoitijo. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Onijoteci niɡ̶ijoa itoataale ane wajipatalo lotaɡ̶a João, ane igaalatece Jesus, liboonaɡ̶adi André, nioxoa Simão Pedro. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aɡ̶ica ane yopaɡ̶adi André jiɡ̶igo doletibige Simão niɡ̶ijo nioxoa. Naɡ̶a yakadi, odaa jeɡ̶eeta, “Ja jakataɡ̶a Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi, ane liboonaɡ̶adi Cristo.” ");
INSERT INTO kbcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Odaa André ja yadeegi Simão miniwataɡ̶a Jesus. Naɡ̶a iwiteta Jesus, meete, “Niɡ̶ida makaami akaami Simão, akaami lionigi João. Odaa natigide ja ɡ̶aboonaɡ̶adi Cefas”. (“Cefas” idaaɡ̶ida me “Pedro”, niɡ̶ina anejinaɡ̶ata “wetiɡ̶a”.) ");
INSERT INTO kbcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Neɡ̶eledi noko, Jesus ja lowoogo migo eledi nipodigi ane liboonaɡ̶adi Galiléia. Odaa ja dakapetetege Filipe, odaa jeɡ̶eete, “Anagi, aniwitibici!” ");
INSERT INTO kbcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe elatibige nigotaɡ̶a Betsaida, ane liɡ̶eladi André ijaa Pedro. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe ja doletibige Natanael, igaanaɡ̶a yakadi, odaa meeta, “Jakataɡ̶a iniwa ɡ̶oneleegiwa ane liboonaɡ̶adi Jesus, niɡ̶ijoa lionigi José, niɡ̶elademigitigi nigotaɡ̶a Nazaré. Moisés akaa idí niɡ̶ica anodaaɡ̶eeteda maditaɡ̶a lotaɡ̶anaɡ̶axi liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji, codaa me niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji oidi anodaaɡ̶eeteda miniwa.” ");
INSERT INTO kbcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Odaa mee Natanael, “Aniɡ̶ica jinadi oko anele anelatibige nigotaɡ̶a Nazaré”. Odaa Filipe ja niniɡ̶odi, meeta, “Anagi, awini”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naɡ̶a naditetege Jesus Natanael menagi miniwataɡ̶a, odaa mee, “Digawiniticogitiwaji digoida. Niɡ̶ina ɡ̶oneleegiwa yeloɡ̶o melatibige Israel, codaa niɡ̶ina ɡ̶oneleegiwa ainaale eledi oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ja ige Jesus, meetalo, “Amiica ica madowooɡ̶oti?” Jesus naɡ̶a igidi, meeteta, “Aniɡ̶icatibige Filipe deɡ̶eniditaɡ̶awa, jinaditaɡ̶awa midiaaɡ̶oni anicooti libatadi naɡ̶ada niale ‘fiigoigo’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael meetalo Jesus, “Iniotagodi, niɡ̶ida makaami, akaami Lionigi Aneotedoɡ̶oji, jaɡ̶akamaɡ̶akaami ninionigi-eliodi ɡ̶odoiigi Israel”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Odaa Jesus meeteta, “Mige adadiwaɡ̶ati leeɡ̶odi mejitaɡ̶awa me jinaditaɡ̶awa libatadi naɡ̶ajo niale? Pida niɡ̶ida makaami icota manati eletidi yoenataka ane daɡ̶axa me libinienaɡ̶a yayoketice niɡ̶ida ananati”. ");
INSERT INTO kbcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Eledi meeteta Jesus, “Ewi mejitaɡ̶awatiwaji, icota manati me domoke ditibigimedi, odaa anatitiwaji niaanjotedi Aneotedoɡ̶oji igotibeci ditibigimedi, naɡ̶a dinikatiniwace meetaɡ̶a ane Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Naɡ̶a ixomaɡ̶atedijo itoataale nokododi meniditediogi niɡ̶ijo anodiotibece, jiɡ̶ijo ica nadoneɡ̶egi manitaɡ̶a nigotakawaana Caná, midi nipodigi Galiléia. Naɡ̶ajo eliodo Jesus eledi idiaaɡ̶i miditaɡ̶a niɡ̶idi nalokegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Odaa Jesus ijaaɡ̶ijo anodiotibece eledi onodetiogi me igotibeci miditaɡ̶a nadoneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Igaanaɡ̶a dinelio viinyo, odaa jiɡ̶igo naɡ̶ajo eliodo Jesus miniwataɡ̶a, meetalo, “Aɡ̶e-eeɡ̶ica viinyo, ja ma”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Odaa meeteta Jesus, “Eiodo. Aleeditibige madiiɡ̶eni. Leeɡ̶odi aniɡ̶icota limedi me jikee ane Ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Odaa naɡ̶ajo eliodo Jesus jeɡ̶eetiogi niɡ̶ijoa niotaka, “Nigica ane i-iiɡ̶etedaɡ̶awatiwaji, odaaɡ̶awii”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Onidiwa icoa seete bootitedi nelecoli, idoatawece oyatita wetiɡ̶a lamoɡ̶o moyoe. Onadatecibeci yalitedini onaniteci taalia liitilo ninyoɡ̶odi. Niɡ̶idi noiigi oibake niɡ̶ida ninyoɡ̶odi niɡ̶idoa bootitedi me diniwilegi lodoe Aneotedoɡ̶oji, mina epaa lakatigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Niɡ̶idiaaɡ̶idi meetediogi Jesus niɡ̶ijoa niotaka, “Anoleenaɡ̶ati ninyoɡ̶odi niɡ̶idoa bootitedi”. Odaa joɡ̶onoleenaɡ̶adi neɡ̶epaa niolakatedi niɡ̶idiwa bootitedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Odaa ja iiɡ̶etace Jesus, meetediogi, “Natigide okateciɡ̶ica anoɡ̶aa, adeegita ane dowediteloco nalokegi”. Odaa joɡ̶oyadeegita. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Odaa niɡ̶ijo ninyoɡ̶odi ja viinyo. Igaanaɡ̶a ici niɡ̶ijo ane dowediteloco nalokegi, ayowooɡ̶odi niɡ̶ica ane icoɡ̶otigi niɡ̶ida viinyo. Pida ijokijoa niɡ̶ijoa niotaka anonoɡ̶a niɡ̶ijo ninyoɡ̶odi boɡ̶oyowooɡ̶odi ane icoɡ̶otigi niɡ̶ijo viinyo. Odaa niɡ̶ijo ane dowediteloco nalokegi jeɡ̶enidita niɡ̶ijo ane wado. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Meeta, “Niɡ̶ida moko ɡ̶odakatigi modoejegi me jacipaɡ̶ata niɡ̶ina viinyo ane daɡ̶axa mele. Igaanaɡ̶a eliodi me nacipaɡ̶a niɡ̶ina ɡ̶ododenigipi, odaa jaɡ̶aɡ̶a jajicaɡ̶a niɡ̶ina viinyo ane deɡ̶ewi ina mele. Pida akamaɡ̶akaami ja moteteni niɡ̶ida viinyo anele, odaa natigide ekajici.” ");
INSERT INTO kbcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Joaniɡ̶idaa niciagi digoida nigotakawaana Caná, midi nipodigi Galiléia, neɡ̶eote Jesus odoejegi ɡ̶odoxiceɡ̶edi. Ikee nimaweneɡ̶egi ane icoɡ̶otigi miniwataɡ̶a Aneotedoɡ̶oji. Odaa niɡ̶ijo anodiotibece jeɡ̶epaanaɡ̶a oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Niɡ̶idiaaɡ̶idi Jesus ja lixigaɡ̶awa, naɡ̶ajo eliodo, nioxoadipi, ijaaɡ̶ijo niɡ̶ijo anodiotibece me dinikatiniwace manitaɡ̶a nigotaɡ̶a Cafarnaum. Odaa jiɡ̶idiaaɡ̶i onateciɡ̶ijoa nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naɡ̶a nipegi ica lalokegi judeutedi anodita Páscoa, odaa Jesus joɡ̶opitacedibigimece manitaɡ̶a nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Igo minitaɡ̶a Aneotedoɡ̶oji liɡ̶eladi. Joaniɡ̶idiaaɡ̶i niɡ̶icotediogi ɡ̶oneleegiwadi anoyaa ɡ̶odinadi, waxacocoli, yotipitedi. Eledi icotediogi ica ane nicotiniwace moiikoaɡ̶etema ninyeelo niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Odaa Jesus jeɡ̶eote lalakenaɡ̶anaɡ̶adi waca-lolaadi, ja niticoitedice iditawece digoida we niogó Aneotedoɡ̶oji liɡ̶eladi. Eletidi nixotedice niɡ̶ijoa waxacocoli ijaaɡ̶ijoa ɡ̶odinadi. Odaa jaɡ̶aɡ̶a ilaagaɡ̶aditedice niɡ̶ijoa dinyeelo, ninyeelo niɡ̶ijoa ɡ̶oneleegiwadi ane nicotiniwace moiikoaɡ̶e dinyeelo. Yamaɡ̶atedini ijoa nameejatedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Odaa meetediogi niɡ̶ijoa nanaanoɡ̶ododi yotipitedi, “Adeegitedicogi niɡ̶idiwa yotipitedi digoida wetice. Jinaɡ̶a domaɡ̶aleeɡ̶awiitetiwaji ɡ̶anoojetekegi digoina catiwedi Eiodi liɡ̶eladi micataɡ̶a daɡ̶a oojetekaxi eloodo.” ");
INSERT INTO kbcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Odaa niɡ̶ijo anodiotibece joɡ̶onalaɡ̶atibige niɡ̶ijoa notaɡ̶a maditaɡ̶a lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji, niɡ̶ijoa notaɡ̶a anee, “Daɡ̶axa me jemaa ɡ̶adiɡ̶eladi, Inoenoɡ̶odi. Niɡ̶ida yemaanaɡ̶aneɡ̶egi ideloadi, micataɡ̶a noledi daɡ̶a yalegi catiwedi yaaleɡ̶ena.” ");
INSERT INTO kbcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Odaa icoa lacilodi judeutedi joɡ̶oige Jesus, moditalo, “Awii ɡ̶odoxiceɡ̶edi me anikeenitoɡ̶owa ɡ̶anaɡ̶atetigi mawii niɡ̶ida ɡ̶adoenatagi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naɡ̶a igidi Jesus, meetediogi, “Niganikanititiwaji liɡ̶eladi Aneotedoɡ̶oji, odaa inawacetacibige catiwedi itoatadiɡ̶ida nokododi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Odaa moditalo, “Niɡ̶ini diimigi, liɡ̶eladi Aneotedoɡ̶oji, yadeegi 46 nicaaɡ̶ape noɡ̶oigodi moyoe. Odaa niɡ̶ida makaami aɡ̶akati daɡ̶anawacenitacibige catiwedi itoatadiɡ̶ida nokododi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pida Jesus aɡ̶eetetece niɡ̶ini diimigi, Aneotedoɡ̶oji liɡ̶eladi. Pida eeteta epaa lolaadi ane liciagi niɡ̶ini Aneotedoɡ̶oji liɡ̶eladi. (Leeɡ̶odi Aneotedoɡ̶oji Liwigo me diɡ̶eladetigilo.) ");
INSERT INTO kbcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Igaanaɡ̶a yewiɡ̶atace Jesus, odaa niɡ̶ijo anodiotibece joɡ̶onalaɡ̶atibige mijo me yalaɡ̶ate niɡ̶ijoa notaɡ̶a. Odaa jeɡ̶epaanoɡ̶oyiwaɡ̶adi Aneotedoɡ̶oji lotaɡ̶a, codaa moyiwaɡ̶adi niɡ̶ijoa notaɡ̶a aneete Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Niɡ̶ijo me ideite Jesus digoida Jerusalém midi nalokegi anodita Páscoa, eliodi oko oyowooɡ̶odi me Niɡ̶iniaaɡ̶iniwa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi, leeɡ̶odi monadi ɡ̶odoxiceɡ̶etedi aneote. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pida Jesus anakatotediogi, leeɡ̶odi me yowooɡ̶odi anodaaɡ̶ee niɡ̶idi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Leeɡ̶odi miniwa ayopotedibige eledi oko daɡ̶a yeloɡ̶oditalo anodaaɡ̶ee niɡ̶idi noiigi, Iniaaɡ̶iniwa yowooɡ̶odi niɡ̶ica ane lowoogo okanicodaaɡ̶ica oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ica ɡ̶oneleegiwa liboonaɡ̶adi Nicodemus, one fariseu, codaa me lacilo judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Odaa ica enoale, jiɡ̶igo dalitalo Jesus, odaa oneetalo, “Ǥoniiɡ̶axinoɡ̶odi. Jowooɡ̶otaɡ̶a makaami niiɡ̶axinaɡ̶anaɡ̶a ane niiɡ̶e Aneotedoɡ̶oji, igaataɡ̶a aɡ̶ica ane yakadi meote niɡ̶inoa ɡ̶odoxiceɡ̶etedi libinienaɡ̶a ane oeni, daaditiɡ̶icoateda Aneotedoɡ̶oji makaamitaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Naɡ̶a igidi Jesus, meeteta, “Ejitaɡ̶awa niɡ̶ina anewi, anida ane jaoɡ̶a. Aɡ̶ica ane yakadi me nadi ninioxigi Aneotedoɡ̶oji nige daɡ̶a gela menitacini.” ");
INSERT INTO kbcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Odaa jeɡ̶ee Nicodemus, “Igame nimaweneɡ̶egi ina ɡ̶oneleegiwa oxiiɡ̶odi me yakadi menitacini? Ayakadi mopitaciwece le eliodo oditaɡ̶a jeɡ̶enitacini.” ");
INSERT INTO kbcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Ejitaɡ̶awa niɡ̶ina ɡ̶ogegi ɡ̶oneɡ̶egi. Niɡ̶ina oko idoka yakadi me dakatiwece ninioxadi Aneotedoɡ̶oji nige dinilaatece niɡ̶icoa loenataka ane beyagi, codaa nigeo Liwigo Aneotedoɡ̶oji me yewiɡ̶atace liwigo. Odaa ini Aneotedoɡ̶oji Liwigo minitaɡ̶a, odaa micataɡ̶a niɡ̶ina oko daɡ̶a gelatace menitini. Nige dinilege, ja ikee me dinilaatibece, codaa ja ika meote loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Niɡ̶ina ɡ̶odolaadi dinoe leeɡ̶odi ɡ̶odiododipi. Pida ɡ̶odiwigo aaɡ̶aɡ̶a dinoe leeɡ̶odi Aneotedoɡ̶oji Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Enice jinaɡ̶a domoɡ̶opoo mejitaɡ̶awa me leeditibige me gelatace maniitiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Micataɡ̶a niɡ̶ina niocodi. Igo ane yemaa me diiticogi, codaa akaami akati majipaata layaageɡ̶egi niocodi. Pida aɡ̶owooɡ̶oti niɡ̶ica ane icoɡ̶oticogi, oteɡ̶exaaɡ̶aɡ̶a niɡ̶ica ane diiticogi. Joaniɡ̶idaaɡ̶ee inatawece niɡ̶ina oko Aneotedoɡ̶oji Liwigo aneo me gelatace menitini liwigo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naɡ̶a ige Nicodemus meetalo, “Igamodaaɡ̶eeta?” ");
INSERT INTO kbcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Niɡ̶ida makaami akaami niiɡ̶axinaɡ̶anaɡ̶a ɡ̶oneɡ̶egitigi ɡ̶odoiigi Israel. Aɡ̶owooɡ̶oti inoa anejitedaɡ̶awa? ");
INSERT INTO kbcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ejitaɡ̶awa niɡ̶ina anewi. Ejinaɡ̶atece niɡ̶ina ane jowooɡ̶otaɡ̶a. Codaa jatematiiɡ̶a niɡ̶ina ane jinataɡ̶a. Pida akaamitiwaji aɡ̶abaatege niɡ̶inoa ɡ̶odotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Codaa aɡ̶iwaɡ̶atitetiwaji niɡ̶inoa yotaɡ̶a niɡ̶ina mejitece niɡ̶inoa aninoatigi digoina iiɡ̶o. Odaa amiida ica ɡ̶animaweneɡ̶egitiwaji madadiwaɡ̶ati nigejitece aninoatigi digoida ditibigimedi? ");
INSERT INTO kbcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aɡ̶ica oko baaniɡ̶ica migo ditibigimedi. Emoka Ee, me Ee, Ǥoneleegiwa midiaaɡ̶ejo digoida ditibigimedi, codaa jiɡ̶idaa jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Analakitibige Moisés niɡ̶ijo jotigide me nanyoketi niɡ̶ijo lakeedi ɡ̶apileceɡ̶e noenatagi, nanyoketi ditibigimedi iwoɡ̶o digoida nipodigi ane yadilo. Odaa joaniɡ̶idaaɡ̶ee leeditibige Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, maɡ̶aɡ̶a etidayoketinece iwoɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Amaleeɡ̶aɡ̶a inatawece niɡ̶ina ane idadiwaɡ̶adi, ida lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Aneotedoɡ̶oji eliodi me yemaa okotigi digoina iiɡ̶o, joaniɡ̶idaa leeɡ̶odi me yajigo niɡ̶ijoa oniniwatece me Lionigi lemaanigi, eotedibige minatawece niɡ̶ina anoyiwaɡ̶adi aɡ̶alee nigo, pida jiɡ̶ida lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Aneotedoɡ̶oji niiɡ̶e Lionigi me yewikatidi inatawece oko. Aniiɡ̶e Lionigi me iwi, oditaɡ̶a iloikatiditeda oko leeɡ̶odi loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Niɡ̶ina oko aneyiwaɡ̶adi Aneotedoɡ̶oji Lionigi, Aneotedoɡ̶oji aɡ̶alee iwi codaa ailoikatidi niɡ̶ini oko. Pida niɡ̶ina oko ane deɡ̶etiwaɡ̶ataka, baɡ̶a iwi Aneotedoɡ̶oji, codaa baɡ̶a iloikatidi, leeɡ̶odi aɡ̶eyiwaɡ̶adi Liboonaɡ̶adi oniniwatece me Lionigi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Niɡ̶ijoa ane lokokena enagi minataɡ̶a oko digoina iiɡ̶o. Pida niɡ̶ina oko daɡ̶axa moyemaa nexocaɡ̶a, aɡ̶oyemaa lokokena, leeɡ̶odi mowote niɡ̶inoa ane beyagi. Odaa leeɡ̶odi me doɡ̶oyemaa lokokena, Aneotedoɡ̶oji iwi, codaa iloikatidi niɡ̶idi oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Niɡ̶ina oko aneo ane beyagi, ayemaa lokokena. Codaa aɡ̶enagi manitaɡ̶a lokokena, leeɡ̶odi ayemaa diɡ̶ica ane nadi niɡ̶inoa loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pida niɡ̶ina oko aneo niɡ̶ina ane iɡ̶enaɡ̶a, joaniɡ̶iniaaɡ̶enagi manitaɡ̶a lokokena eotibige me yeloɡ̶otelogo loenataka, leeɡ̶odi eo ane yemaa Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Niɡ̶idiaaɡ̶idi Jesus ijaaɡ̶ijo anodiotibece jiɡ̶igotibeci miditaɡ̶a nipodigi Judéia. Odaa jiɡ̶idiaaɡ̶i onateciɡ̶ijoa semaanatedi, Jesus ja iiɡ̶e niɡ̶ijo anodiotibece monilegetiniwace oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João baɡ̶a idei digoida Enom, ipegitege Salim, leeɡ̶odi digoida beɡ̶eliodi ninyoɡ̶odi. João aaɡ̶aɡ̶a nilegetiniwace oko anodiita. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Maleediɡ̶icatibige doɡ̶oniwilo. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ica eledi anodiotibeci João joɡ̶odinotigimadetege icoa ɡ̶oneleegiwadi judeutedi. Odinotigimadetigi lakatigi judeutedi me dinibinie lodoe Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Odaa niɡ̶ijo anodiotibeci João anodinotigimadetege judeutedi jiɡ̶igotibeci midataɡ̶a João, modita, “Ǥoniiɡ̶axinoɡ̶odi. Niɡ̶ijoa ane ideite makaamitaɡ̶a daato akiidi Jordão, niɡ̶ijoa ane ɡ̶adalakitalo, jiɡ̶idaaɡ̶idoa digoida nilegetediniwace oko, codaa eliodi oko anodiitalo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naɡ̶a niniɡ̶odi João, meetiogi, “Niɡ̶ina oko idoka yakadi ganigica nige Aneotedoɡ̶oji yajigote. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akamaɡ̶akaamitiwaji owooɡ̶oti leeɡ̶odi jiɡ̶ijo mejitaɡ̶awa, ‘Maleedeɡ̶emeɡ̶ee Cristo, Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odewikatidi. Pida ee baɡ̶a idiiɡ̶e Aneotedoɡ̶oji maleediɡ̶icatibige menagi Cristo me joetece naigi’. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Niɡ̶ina ane wado, naɡ̶ani awicije ane liomaɡ̶ata, ja nebi. Niɡ̶ina lokaaɡ̶edi niɡ̶ina ane wado ninitibece niɡ̶ina naɡ̶a yowooɡ̶oditege lotaɡ̶aneɡ̶egi ane wado. Odaa ee idiniciaceeketege niɡ̶ina lokaaɡ̶edi niɡ̶ina ane wado, eliodi me idinitibeci. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Igaataɡ̶a leeditibige me leegitibigimece naɡ̶atetigi Cristo, odaa eemoda baɡ̶a leeditibige me naxaceti iboonaɡ̶adi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Niɡ̶ijoa ane icoɡ̶otedibigimece ditibigimedi daɡ̶axa me ɡ̶oneɡ̶egi, aɡ̶ica ane naɡ̶axatelogo. Pida niɡ̶ina anelatibige iiɡ̶o, ida aneetege iiɡ̶o, codaa eetece aninoatinigi digoina iiɡ̶o. Pida Niɡ̶ijoa ane icoɡ̶otedibigimece ditibigimedi baɡ̶a daɡ̶axa me ɡ̶oneɡ̶egi, aɡ̶ica liciagi, leeɡ̶odi icoɡ̶otedibigimece ditibigimedi, aɡ̶elatedibige niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Niɡ̶iniwa eetetece niɡ̶inoa ane nadi, codaa ane wajipate. Pida aɡ̶ewi ina mica ane dibatege lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Niɡ̶ina oko ane dibatege lotaɡ̶a ikee mewi niɡ̶inoa Aneotedoɡ̶oji lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Niɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji, eetetece Aneotedoɡ̶oji lotaɡ̶a, leeɡ̶odi Aneotedoɡ̶oji aɡ̶ica liniogo me yajigote Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aneotedoɡ̶oji, ane Eniodi, yemaa Lionigi. Odaa yajigoteta naɡ̶atetigi me iiɡ̶e inoatawece. ");
INSERT INTO kbcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Niɡ̶ina aneyiwaɡ̶adi Aneotedoɡ̶oji Lionigi jiɡ̶ida lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. Pida niɡ̶ina ane daɡ̶a dibatege Aneotedoɡ̶oji Lionigi aɡ̶ica lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji, codaa Aneotedoɡ̶oji biɡ̶idioka limedi me yelatetema niɡ̶ini oko, codaa iloikatidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Icoa fariseutedi ja nibodicaɡ̶a Ǥoniotagodi Jesus mepaɡ̶a eliodi anodiotibece, codaa nilegetediniwace eliodi oko caticedi João. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Pida aniɡ̶iniaa Jesus nilegetediniwace oko, pida niɡ̶ijo anodiotibece baaniɡ̶ijaa onilegetiniwace oko.) ");
INSERT INTO kbcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Igaanaɡ̶a yowooɡ̶odi Ǥoniotagodi niɡ̶ijoa fariseutedi naɡ̶a nibodicaɡ̶a, odaa ja noditedicogi nipodigi Judéia, odaa joɡ̶opitedicogi nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Odaa anigotetece leeditibige me yakagiditedeloco nipodigi Samaria. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Odaa jiɡ̶icotedicogi aca nigotaɡ̶a anodita Sicar, ane idei nipodigi Samaria. Naɡ̶ani nigotaɡ̶a ipegitege niɡ̶ijo nipodigi jotigide ɡ̶onelokodi Jacó ane yediatece niɡ̶ijo lionigi ane liboonaɡ̶adi José. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Joaniɡ̶idiaaɡ̶i naɡ̶aca nalice ocaɡ̶ataɡ̶a loenata Jacó. Odaa ejime seis lakata me ɡ̶ocidi niɡ̶icotedicogi Jesus manitaɡ̶a nalice, odaa ja nicotedini liniogotibece naɡ̶ani nalice, leeɡ̶odi Jesus ja dinigaaxe me diniwiaje. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Odaa niɡ̶ijo anodiotibece Jesus jiɡ̶igotibeci manitaɡ̶a nigotaɡ̶a odinoojetetibige anoyeligo. Odaa aca iwaalo niɡ̶eladimatigi Samaria jiɡ̶igo noɡ̶a ninyoɡ̶odi manitaɡ̶a nalice. Odaa jeɡ̶eeteta Jesus naɡ̶ajo iwaalo, “Adedianita ɡ̶aninyoɡ̶odi, jacipoda”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Naɡ̶ajo iwaalo naɡ̶a niniɡ̶odi, meetalo, “Iniwa-aagodi. Ica mabo-oo ɡ̶adaaleɡ̶ena manipokitiwa ininyoɡ̶odi, igaataɡ̶a a-aami judeu, beɡ̶eyo iwaalo samaritaana?” Naɡ̶ajo iwaalo meetalo Jesus niɡ̶ida ligegi, leeɡ̶odi niɡ̶idi noiigi judeutedi ailaaɡ̶atege noiigi samaritaanotedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Naɡ̶a niniɡ̶odi Jesus meeteta, “Doɡ̶owooɡ̶otawaanigi niɡ̶ica ane yajigo Aneotedoɡ̶oji, codaa doɡ̶owooɡ̶oti ane Ee, ane jipokotaɡ̶awa ninyoɡ̶odi me jacipe. Doɡ̶owooɡ̶oti, daɡ̶anagawini anipokitiwa odaa ja jajigotaɡ̶awa ninyoɡ̶odi aneo lewiɡ̶a oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Odaa naɡ̶ajo iwaalo ja niniɡ̶odi Jesus, meetalo, “Iniwa-aagodi, aɡ̶aca ɡ̶adeo daɡ̶a anoɡ̶owaa ninyoɡ̶odi, igaataɡ̶a naɡ̶ani nalice le-eegitinece. Igame icoɡ̶oteeniticogi ica ninyoɡ̶odi aneo ɡ̶odewiɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Domige daɡ̶axa ma-aami ɡ̶oneɡ̶egi, agodaɡ̶a ɡ̶adi-iiciagi jotigide ɡ̶onelokodi Jacó, ane nenyaɡ̶aditoɡ̶odomi naɡ̶ani nalice? Ijaaɡ̶ijo wa-aakata ninyoɡ̶odi naɡ̶ani nalice, li-oonigipi, codaa me neijedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Naɡ̶a niniɡ̶odi Jesus naɡ̶ajo iwaalo, meeteta, “Okanicodaaɡ̶ica ane wacipeta ninyoɡ̶odi naɡ̶ani nalice, icotaca me yeloadi ecibi. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pida nigica ane wacipeta niɡ̶ida ninyoɡ̶odi ane jedianaɡ̶atece, aɡ̶aleeɡ̶ica daɡ̶a yeloadi ecibi. Igaataɡ̶a niɡ̶ida ninyoɡ̶odi ane jedianaɡ̶atece liciagi niɡ̶ina lacilotibige ninyoɡ̶odi ane diɡ̶ica me ipe, ideite catiwedi oko laaleɡ̶ena, aneo lewiɡ̶a oko ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Odaa naɡ̶ajo iwaalo ja dipokotalo Jesus, meetalo, “Iniwa-aagodi, adedianita ica ninyoɡ̶odi, amanagawi-iini aɡ̶e-ee ide-eemadi ecibi, odaa aɡ̶e-ee le-eeditibige daɡ̶a janagoda jowedi digoina nalice”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Odaa meeteta Jesus, “Emiita ɡ̶adodawa, odaa adopilitijo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Odaa naɡ̶ajo iwaalo ja igidi Jesus, meetalo, “Aɡ̶icoda yodawa”. Odaa jeɡ̶eete Jesus, “Analiiki ɡ̶agegi menitiwa, ‘Aɡ̶ica yodawa’. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Igaataɡ̶a niɡ̶ida makaami jiɡ̶ijoa ciinco ɡ̶adodawadi, codaa niɡ̶ini anini makaamitaɡ̶a natigide aɡ̶adodawa. Joaniɡ̶idaa manaliiki meni me diɡ̶ica ɡ̶adodawa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Meetalo Jesus naɡ̶ajo iwaalo, “Iniwa-aagodi. Amina natigide ja jowooɡ̶odi ma-aami niɡ̶ina anoneloɡ̶oditoɡ̶owa lowooko Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jotigide ɡ̶odaamipi odoɡ̶owetetalo Aneotedoɡ̶oji ditibigimedi naɡ̶adi wetiɡ̶a. Pida a-aamitiwaji judeutedi me-eenitoɡ̶owa me le-eeditibige me joɡ̶oweɡ̶atalo Aneotedoɡ̶oji idokida digoida nigotaɡ̶a Jerusalém”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Naɡ̶a igidi Jesus, meeteta, “Digawini liciagi. Iwaɡ̶ati anejitaɡ̶awa. Icota noko nige daɡ̶adiaa oɡ̶eetetalo Aneotedoɡ̶oji ditibigimedi naɡ̶adi wetiɡ̶a, oteɡ̶exaaɡ̶aɡ̶a manitaɡ̶a nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niɡ̶ina akaamitiwaji samaritaanotedi aɡ̶owooɡ̶oti niɡ̶ica anoɡ̶eeteta. Pida niɡ̶ida moko anoko judeutedi baɡ̶a jowooɡ̶otaɡ̶a ane joɡ̶eeɡ̶ata. Igaataɡ̶a Aneotedoɡ̶oji baɡ̶a ikeetediogi judeutedi niɡ̶ica anodaaɡ̶ee me yewikatidi oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pida enagi niɡ̶ica noko codaa jiɡ̶icota mina anodoɡ̶etetalo Aneotedoɡ̶oji catiwedi laaleɡ̶ena, joaniɡ̶idiaaɡ̶idi anodoɡ̶etetalo Aneotedoɡ̶oji odatika liwigo, codaa jiɡ̶idaaɡ̶ida anepeɡ̶ewi mejinaɡ̶a. Igaataɡ̶a Aneotedoɡ̶oji ane Ǥodiodi joaniɡ̶inaa doletedibige oko liciagi modoɡ̶etetalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Aneotedoɡ̶oji Niwigo. Joaniɡ̶idaa leeɡ̶odi me leeditibige niɡ̶ina ane doɡ̶etetalo, me datika liwigo me doɡ̶etetalo, joaniɡ̶idaa niɡ̶ica ɡ̶onimaweneɡ̶egi anepeɡ̶ewi mejinaɡ̶a me joɡ̶eeɡ̶atalo Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Odaa meetalo naɡ̶ajo iwaalo, “Baɡ̶a jowooɡ̶odi menagi Niɡ̶icoa ane libo-oonaɡ̶adi Cristo, Niɡ̶icoa ane ni-iiɡ̶e Aneotedoɡ̶oji me ɡ̶odatamaɡ̶ateetetege niɡ̶inoa ɡ̶odaxakawepodi. Niɡ̶ina nigenagi, odaa ja neloɡ̶oditedoɡ̶owa inoatawece ane daɡ̶a jowooɡ̶otaɡ̶ateda.” ");
INSERT INTO kbcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naɡ̶a igidi Jesus, meeteta naɡ̶ajo iwaalo, “Jeɡ̶emeɡ̶ee ane ɡ̶adotaɡ̶aneɡ̶eni, Ee Cristo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Acaaɡ̶aca naɡ̶aca lakata joɡ̶onotalo niɡ̶ijo anodiotibece. Odaa eliodi moyopo Jesus me yotaɡ̶aneɡ̶e naɡ̶ajo iwaalo. Pida aɡ̶ica ane ige, deɡ̶eetalo, “Amiini anoleetibige?” Oteɡ̶exaaɡ̶aɡ̶a oditalo, “Igame leeɡ̶odi motaɡ̶aneɡ̶eni ajo iwaalo?” ");
INSERT INTO kbcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Odaa naɡ̶ajo iwaalo ja yoya niboote. Odaa jiɡ̶igo manitaɡ̶a nigotaɡ̶a, igo me yatematitiogi niɡ̶idi niɡ̶eladimigipitigi naɡ̶ani nigotaɡ̶a, meetiogi, ");
INSERT INTO kbcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Diganagi, awi-iinitiwaji ini aaginaɡ̶a eetece ijoatawece niɡ̶ijoa baanaɡ̶a jowee! Maniginiaaɡ̶iniwa icoa Aneotedoɡ̶oji ane ni-iiɡ̶e?” ");
INSERT INTO kbcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Odaa eliodi oko ja noditicoaci nigotaɡ̶a, jiɡ̶igotibeci miniwataɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Maleedoɡ̶ototalo niɡ̶ijo niɡ̶eladimigipitigi nigotaɡ̶a, odaa niɡ̶ijo anodiotibece joɡ̶oditalo Jesus, “Ǥoniiɡ̶axinoɡ̶odi, ele mecoɡ̶otace aniodi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pida naɡ̶a niniɡ̶odi, meetediogi, “Ida ane jeligo, ane diɡ̶icata mowooɡ̶otitiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Odaa ja dinigetiwage, modi, “Manigicaa ane nadeegitalo liweenigi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Odaa ja yeloɡ̶oditediogi Jesus anodaa diitigi niɡ̶ijo ligegi, meetediogi, “Iweenigi anejita, niɡ̶ina me jao Aneotedoɡ̶oji ane yemaa, ane idimonyatedicogi digoina iiɡ̶o, codaa niɡ̶ina me jigodi ibakedi ane najigotediwa. (Joaniɡ̶idaa daɡ̶axa me jao niwaló odaa ja micataɡ̶a daɡ̶a iweenigi). ");
INSERT INTO kbcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Joaniɡ̶idaa aneeta niɡ̶ijo nigegi, anee, ‘Eɡ̶idiwateda cwaatolo epenaitedi nigepaa limedi monopilaɡ̶aditedio nawodigijedi’. Pida ejitaɡ̶awatiwaji anoleetibigimoace digawini nipodaɡ̶a, nawodigijedi jeɡ̶ei, jeɡ̶ele me inopilaɡ̶ataɡ̶atedio. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Niɡ̶ijo ane libakedi me nopilaɡ̶aditedio nawodigijedi dibatege nedianeɡ̶egi. Idaaɡ̶ee niɡ̶ina ane nadeegi oko moyakadi lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji liciagi niɡ̶ina ane nopilaɡ̶aditedio nawodigijedi. Odaa idaaɡ̶ee niɡ̶ina aneyatedi Aneotedoɡ̶oji lotaɡ̶a, inaaɡ̶ina niɡ̶ina ane yatecoɡ̶otee oko moyakadi lewiɡ̶a idokida linikegi. (Leeɡ̶odi monadeegi oko miniwataɡ̶a Aneotedoɡ̶oji). ");
INSERT INTO kbcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ewi niɡ̶ida nigegi anodita, ‘Ini oko anetanaɡ̶a, iniaa eledi baɡ̶a nopilaɡ̶aditedio nawodigijedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Natigide ɡ̶adiiɡ̶enitiwaji memii anopilaɡ̶aditedio niɡ̶idiwa ane daɡ̶a ɡ̶atanigijegi. Eledi oko ane enanaɡ̶anaɡ̶a, odaa akaamitiwaji aniboloiteeni niɡ̶idi libakedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Eliodi samaritaanotedi niɡ̶eladimigipitigi naɡ̶ani nigotaɡ̶a joɡ̶oyiwaɡ̶adi Jesus leeɡ̶odi lotaɡ̶a naɡ̶ajo iwaalo, neɡ̶eetiogi, “Eetetece ijoatawece niɡ̶ijoa baanaɡ̶a jowee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Igaanaɡ̶a onotalo Jesus niɡ̶ijoa samaritaanotedi, odaa joɡ̶odipokotalo midiaaɡ̶ite miditaɡ̶a. Odaa jiɡ̶idiaaɡ̶ite itoataale nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Odaa jiɡ̶ijotace eliodi oko anoyiwaɡ̶adi Jesus leeɡ̶odi mowajipatalo lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Odaa modita naɡ̶ajo iwaalo, “Niɡ̶ina natigide jeɡ̶ejiwaɡ̶ataɡ̶a igaataɡ̶a ja jajipaaɡ̶atalo me dotaɡ̶a, odaa aɡ̶ejiwaɡ̶ataɡ̶a diɡ̶idoka leeɡ̶odi manatematiitedoɡ̶owa. Pida ja jowooɡ̶otaɡ̶a mewi niɡ̶iniaaɡ̶iniwa niɡ̶icoa Cristo, Niɡ̶icoa anenagi me Ǥonewikatitoɡ̶odi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Naɡ̶a ixomaɡ̶atedice niɡ̶ijoa itoataale nokododi, Jesus ja noditedice nipodigi Samaria, odaa jiɡ̶igo nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Igaataɡ̶a mee Jesus, “Niɡ̶ina ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji aɡ̶odeemitetibige miditaɡ̶a epaa nipodigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Igaanaɡ̶a icotedicogi Jesus digoida Galiléia, niɡ̶ijo niɡ̶eladimigipi ele modibatege. Leeɡ̶odi niɡ̶idi oko eledi oicoɡ̶oticogi mijotaɡ̶a niɡ̶ijo nalokegi anodita Páscoa digoida nigotaɡ̶a Jerusalém, joaniɡ̶idiaaɡ̶onadite ijoatawece niɡ̶ijoa Jesus loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Odaa Jesus joɡ̶opitacedicogi digoida nigotaɡ̶a Caná nipodigi Galiléia. Joaniɡ̶idiaa yelite neɡ̶eote ninyoɡ̶odi me viinyo. Oninica ɡ̶oneleegiwa ɡ̶oneɡ̶egi niɡ̶eladimigitigi nigotaɡ̶a Cafarnaum. Niɡ̶ini ɡ̶oneleegiwa liotagi inionigi-eliodi. Niɡ̶ijo lionigi niɡ̶ini ɡ̶oneleegiwa deelotika digoida nigotaɡ̶a Cafarnaum. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wajipatibece Jesus me icoɡ̶otedicogi Judéia, odaa jiɡ̶iniwatedigi Galiléia. Odaa jiɡ̶igo miniwataɡ̶a Jesus, dipokotalo migo digoida Cafarnaum me icilatidi lionigi, leeɡ̶odi jona doletibige me yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Odaa meeteta Jesus, “Idoka adadiwaɡ̶atitiwaji niɡ̶ina manati niɡ̶inoa ɡ̶odoxiceɡ̶etedi libinienaɡ̶a aniniokiniwateda Aneotedoɡ̶oji me yakadi meote”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Odaa niɡ̶ijo ɡ̶oneleegiwa ja dipokotacalo Jesus, meetalo, “Iniotagodi. Adinageni managi maleedaɡ̶a yeleo ionigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Opiliticogi ɡ̶adiɡ̶eladi. Ǥadionigi ayeleo.” Odaa niɡ̶ijo ɡ̶oneleegiwa jeɡ̶eyiwaɡ̶adi niɡ̶ijoa lotaɡ̶a Jesus, odaa joɡ̶opiticogi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Igaanaɡ̶a opiticogi liɡ̶eladi, naigitece ja dakapetege liotaka. Odaa modita, “Ǥadionigi ja icí.” ");
INSERT INTO kbcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Odaa ja digikatece naɡ̶aca lakata naɡ̶a icí lionigi. Noɡ̶oniniɡ̶odi, modita, “Jotigi-noko, seete lakata menoale naɡ̶a ika dapicoɡ̶o-lolaadi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Odaa niɡ̶ijo ɡ̶oneleegiwa ja nalaɡ̶atibige naɡ̶ajo lakata neɡ̶eeteta Jesus, “Ǥadionigi ayeleo.” Odaa niɡ̶ijo ɡ̶oneleegiwa codaa me iditawece loiigiwepodi joɡ̶oyiwaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiɡ̶itoataale Jesus meote ɡ̶odoxiceɡ̶etedi digoida Galiléia, neɡ̶eno me icoɡ̶otedicogi Judéia. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Niɡ̶idiaaɡ̶idi jiɡ̶ijo ica nalokegi, lalokegi judeutedi. Odaa Jesus ja dowicetedibigimece nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Catiwedi naɡ̶ani nigotaɡ̶a onani aca niwilana ane nolee ninyoɡ̶odi. Anitawece diniwotaa, idoa ciinco lapoaco aninoa liwalajoli. Naɡ̶ani niwilana ipegitege niɡ̶ica lapoagi-nelegi nigotaɡ̶a, ane liboonaɡ̶adi “Lapoagi waxacoco.” (“Betesda” liboonaɡ̶aditigi nioladi judeutedi naɡ̶ani niwilana.) ");
INSERT INTO kbcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Owidi eelotaginadi ane iwotinigi iiɡ̶o midoataɡ̶a lapoaco naɡ̶ani niwilana. Idiwa ɡ̶oladi, idiwa alejaadotedi, codaa inoa ane daɡ̶adiaa mewaligi. Iditawece oibeo niɡ̶ini ninyoɡ̶odi me ditineɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Igaataɡ̶a modi mida noko me dinikatini niɡ̶ica aanjo aneote me ditineɡ̶e niɡ̶ini ninyoɡ̶odi. Odaa niɡ̶ina eelotaginaɡ̶a anepaɡ̶a odoejegi me waxoditinigi ninyoɡ̶odi ja icí okanicodaaɡ̶ica ane latopagi leelotagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Idiaaɡ̶iwo ica ɡ̶oneleegiwa eelotaginaɡ̶a. Joneɡ̶eote 38 nicaaɡ̶ape me deelotika. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus naɡ̶a naditedeloco niɡ̶idi ɡ̶oneleegiwa, odaa ja yowooɡ̶odi naɡ̶a leegi midi me deelotika. Odaa ja ige Jesus, meeteta, “Emaani me ɡ̶adicili?” ");
INSERT INTO kbcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Odaa meetalo Jesus, “Iniotagodi. Aɡ̶ica ane idokoletinigi ninyoɡ̶odi niɡ̶ina niɡ̶icota me ditineɡ̶e. Niɡ̶ina naɡ̶a domeɡ̶eji me jaxoditini, pida jiɡ̶idi eledi eelotaginaɡ̶a odoejegi me waxoditini”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Meeteta Jesus, “Adabititi. Abaata ɡ̶aɡ̶elate, odaaɡ̶awaligi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Odaa aɡ̶ica daɡ̶a leegi niɡ̶ijo ɡ̶oneleegiwa ja icí. Naɡ̶a dibata liɡ̶elate, odaa jeɡ̶ewaligi. Niɡ̶ijo noko saabado naɡ̶a icilatidi Jesus niɡ̶ijo ɡ̶oneleegiwa alejaado. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Odaa niɡ̶ijoa lacilodi judeutedi modita niɡ̶ijo ɡ̶oneleegiwa, “Niɡ̶ina noko me saabado. Ǥonajoinaɡ̶aneɡ̶eco aɡ̶adikani moyaɡ̶ati ɡ̶aɡ̶elate niɡ̶ina me saabado”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naɡ̶a niniɡ̶odi niɡ̶ijo eelotaginaɡ̶a baanaɡ̶a icí, meetiogi, “Niɡ̶ijoa ɡ̶oneleegiwa ane idicilatidi joaniɡ̶ijaa idiiɡ̶e, meetediwa, ‘Abaata ɡ̶aɡ̶elate, odaaɡ̶awaligi’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Odaa modita, “Amiijo ica ane ɡ̶adiiɡ̶eni mabaata ɡ̶aɡ̶elate, odaaɡ̶awaligi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pida niɡ̶ijo ɡ̶oneleegiwa ayowooɡ̶odi ane icilatidi. Igaataɡ̶a daɡ̶axa meliodi oko, codaa Jesus aɡ̶aleeɡ̶icoa, joɡ̶opi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Niɡ̶idiaaɡ̶idi Jesus jiɡ̶icote niɡ̶ijo ɡ̶oneleegiwa catiwedi Aneotedoɡ̶oji liɡ̶eladi. Odaa jeɡ̶eeteta, “Digawini, niɡ̶ida makaami ja ɡ̶adicili. Odaa jinaɡ̶a domaɡ̶aleeɡ̶awii ɡ̶adoenatagi ane beyagi, adiɡ̶icatace ɡ̶aninyaagi caticedi niɡ̶ijo aneni”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Odaa niɡ̶ijo ɡ̶oneleegiwa ja noditice, jiɡ̶igo midiwataɡ̶a niɡ̶ijoa lacilodi judeutedi. Odaa ja yeloɡ̶oditiogi me Jesus niɡ̶ijo ane icilatidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Odaa jiɡ̶idaa oyatedigi moiatetedibeci Jesus, odoletibige nimaweneɡ̶egi moyeloadi leeɡ̶odi me icilatidi niɡ̶ijo ɡ̶oneleegiwa me saabado. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Meetediogi Jesus, “Eiodi diba codaa niɡ̶ina natigide, joaniɡ̶idaa leeɡ̶odi maɡ̶aɡ̶a jiba”. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Joaniɡ̶idaa leeɡ̶odi niɡ̶ijoa lacilodi judeutedi neɡ̶epaanaɡ̶a odoletibige moyeloadi Jesus. Igaataɡ̶a odiletibige daataɡ̶a yoteteteda niɡ̶ijo niiɡ̶enatakaneɡ̶egi leeɡ̶odi saabado, eleditace leeɡ̶odi niɡ̶ina mee me Eliodi niɡ̶icoa Aneotedoɡ̶oji, odaa diniciaceeketetege Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Odaa Jesus ja igidi niɡ̶ijoa lacilodi judeutedi anodakapetege, yalaɡ̶ate me Aneotedoɡ̶oji Lionigi, neɡ̶eetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aneotedoɡ̶oji Lionigi doɡ̶okiniwatece ayakadi meote ganigica. Pida eote inokina niɡ̶ina ane nadi Eliodi meote. Inoatawece niɡ̶inoa Eliodi aneote, Lionigi eledi eote. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Igaataɡ̶a Eliodi yemaa Lionigi, ikeeteta inoatawece niɡ̶inoa aneote. Codaa icota me ikee eletidi loenataka ane daɡ̶axatace me libinienaɡ̶a caticedi niɡ̶inoa eletidi loenataka, anopootiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Digo mijoataɡ̶a Eliodi me yewikatidi niɡ̶inoa émaɡ̶aɡ̶a, meotace me newiɡ̶a, Lionigi idaaɡ̶ee eote me yewiɡ̶atace niɡ̶ina ane yemaa me yewikatiditace. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Iniaaɡ̶iniwa Eliodi aiwi ane igote oko, pida yajigote Lionigi idatawece naɡ̶atetigi me iwi oko anee, odaa jeɡ̶epaa yowooɡ̶odi anigote. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eotedibige minatawece oko odeemitetibige Lionigi, liciagi anodigotalo Eliodi modeemitetigilo. Niɡ̶ina ane daɡ̶a deemitetigilo Aneotedoɡ̶oji Lionigi, odaa adeemitetigilo Eliodi ane niiɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ina ane wajipatalo yotaɡ̶a, odaa eyiwaɡ̶adi Niɡ̶ijoa ane idimonya, joaniɡ̶iniaa ida lewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji ane daɡ̶adiaaɡ̶ica liniogo. Aneotedoɡ̶oji aɡ̶alee iwi ane igote, oteɡ̶exaaɡ̶aɡ̶a icata lawikodigi, pida ja iwoko némaɡ̶a, ja yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Niɡ̶ida anejitaɡ̶awatiwaji, ewi. Enagi noko, codaa jiɡ̶icota niɡ̶inoa émaɡ̶aɡ̶a mowajipata ligegi Aneotedoɡ̶oji Lionigi, odaa ja newiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eiodi liciagi niɡ̶ina lacilotibige ninyoɡ̶odi, leeɡ̶odi jiɡ̶iniaaɡ̶eote oko me yewiɡ̶a. Joaniɡ̶idaa me najigotediwa Ee Lionigi me jao oko me yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Najigotediwa inaɡ̶atetigi me jiwi anejigota oko, igaataɡ̶a Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jinaɡ̶a adinopootiwaji leeɡ̶odi niɡ̶inoa anejitedaɡ̶awa. Igaataɡ̶a icota niɡ̶ica noko mowajipata igegi inoatawece niɡ̶inoa émaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Noditicoaci libecoli. Niɡ̶ijo anowo anele, newiɡ̶atace, codaa idiokaanaɡ̶a limedi me newiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. Pida niɡ̶ijo anowo ane beyagi eledi newiɡ̶a, pida biɡ̶idioka limedi me nawikodeeɡ̶a.” (Odibatege lawikodico ane diɡ̶ica liniogo.) ");
INSERT INTO kbcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eɡ̶idaaɡ̶ee me notaɡ̶aneɡ̶etediniwace Jesus, meetediogi, “Ajakadi me jao ganigica moka eetece. Pida idioka limedi me idiwoditema Eiodi ligegi niɡ̶ina modinigetiwa niɡ̶ina oko me jiwi anodaaɡ̶ejigotiogi. Niɡ̶ina me jiwi anejigota niɡ̶ina oko, jao niɡ̶ina ane iɡ̶enaɡ̶a, leeɡ̶odi ajoletibige daɡ̶a jao ane emaɡ̶a jemaa. Pida joletibige me jao ane yemaa Eiodi, ane idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Deɡ̶emokee mejitece ane Ee, daɡ̶anagawini niɡ̶ina oko aɡ̶odibatege yotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pida jiɡ̶ijo eledi oko ane yeloɡ̶oditibece anodaaɡ̶eji. Jowooɡ̶odi mewi niɡ̶inoa ane yeloɡ̶oditedibece anodaaɡ̶eji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Akamaɡ̶akaamitiwaji iiɡ̶eni oko moige João. Odaa João jeɡ̶eetiogi niɡ̶ica anewi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ajopotibige eledi oko daɡ̶a yeloɡ̶odi anodaaɡ̶eji. Pida ejitece niɡ̶inoa yotaɡ̶a, amaleeɡ̶aɡ̶a eote Aneotedoɡ̶oji ɡ̶adewiɡ̶a miniwataɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","João liciagi naɡ̶ana noledaɡ̶axi ane ibake giliojeenio, anoyalegi, odaa jiɡ̶ídi. Odaa onateciɡ̶ijoa nokododi jeɡ̶emaani maniniitibecitiwaji leeɡ̶odi niɡ̶ijoa liiɡ̶axinaɡ̶aneɡ̶eco, ane liciagi naɡ̶ana noledaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pida ini eledi aneetece anodaaɡ̶eji, codaa baɡ̶a daɡ̶axa me ɡ̶oneɡ̶egi naɡ̶axatelogo niɡ̶ijoa João lotaɡ̶a aneetece anodaaɡ̶eji. Igaataɡ̶a niɡ̶ida ibakedi Eiodi ane najigotediwa nigepaa jigodi, joaniɡ̶idaa ikee niɡ̶iniaaɡ̶iniwa ane idimonya, codaa ikee ane Ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iniaaɡ̶iniwa Eiodi ane idimonya, eledi eetetece anodaaɡ̶eji. Pida niɡ̶ida makaamitiwaji aniɡ̶ica daɡ̶ajipaatalo me dotaɡ̶a, oteɡ̶exaaɡ̶aɡ̶a icoateda manati anodaaɡ̶eeteda. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lotaɡ̶a Eiodi aɡ̶icoa catiwedi ɡ̶adaaleɡ̶ena, igaataɡ̶a aɡ̶adadiwaɡ̶atitiwaji, ane Ee liiɡ̶exegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eliodi malomeɡ̶enitelogotiwaji Aneotedoɡ̶oji lotaɡ̶a, odaa jaɡ̶aleetibigetiwaji diɡ̶idioka limedi me ɡ̶adewiki leeɡ̶odi meliodi malomeɡ̶enitelogo Aneotedoɡ̶oji lotaɡ̶a. Idiaaɡ̶idiwa Aneotedoɡ̶oji lotaɡ̶a oyalaɡ̶atiwa anodaaɡ̶eji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pida niɡ̶ida makaamitiwaji aɡ̶emaani managi meetaɡ̶a, daɡ̶anagi daɡ̶anagawini ida ɡ̶adewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ajoletibige doɡ̶odeemitetibigiji niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eliodi me ɡ̶adowooɡ̶otitiwaji. Codaa jowooɡ̶odi me deɡ̶emaanitedatiwaji Aneotedoɡ̶oji catiwedi ɡ̶adaaleɡ̶ena. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Niɡ̶ina me janagi, Eiodi idiiɡ̶e, pida aɡ̶abaatigitiwaji. Pida deɡ̶enagi eledi ane ibake anepaa naɡ̶atetigi, odaa baɡ̶abaategetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Igame ɡ̶animaweneɡ̶egitiwaji me iwaɡ̶atakani? Ane ɡ̶ademaanigi midokida madiniweniɡ̶idenitiwagetiwaji. Pida niɡ̶ida makaamitiwaji aɡ̶oleetibige Aneotedoɡ̶oji me ɡ̶adiweniɡ̶idenitetiwaji. Aniniokiniwateda me Aneotedoɡ̶oji, aɡ̶ica eledi. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jinaɡ̶aleetibigetiwaji daɡ̶akaami yakapetedipi, daɡ̶a jotaɡ̶atibigaɡ̶aji miniwataɡ̶a Eiodi. Pida Moisés baaniɡ̶ijaa ɡ̶adajicitiwaji, leeɡ̶odi manibeoonitegetiwaji liiɡ̶axinaɡ̶aneɡ̶egi meo ɡ̶adewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Igaataɡ̶a diɡ̶iwaɡ̶atitetiwaji niɡ̶ijoa Moisés lidiko, daɡ̶anagawini adinakatonitiwaji, igaataɡ̶a Moisés jeɡ̶epaa idí anodaaɡ̶eji. ");
INSERT INTO kbcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pida nige daɡ̶a iwaɡ̶atitedatiwaji niɡ̶ijoa ane iditedini Moisés, odaa idaaɡ̶ee aɡ̶iwaɡ̶ati niɡ̶inoa yotaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Niɡ̶idiaaɡ̶idi ja diɡ̶etedita Jesus ica weiigi-nelegi anodita “Niweiigi Galiléia”. Eledi liboonaɡ̶adi niɡ̶idi weiigi me Tiberíades. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","4","Ica lalokegi judeutedi anodita Páscoa jiɡ̶ipegiteloco. Odaa ica noiigi-nelegi joɡ̶oigaalatece Jesus, leeɡ̶odi monadi niɡ̶ijoa ɡ̶odoxiceɡ̶etedi aneote niɡ̶ijo me nicilatiditediniwace eelotaginadi. Odaa Jesus ja dalaɡ̶atetedibigimece ica lojotaɡ̶adi, odaa jiɡ̶idiaa nicote ijaaɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Igaanaɡ̶a noletedini Jesus, odaa ja naditetege ica lapo-nelegi ane odiitalo. Odaa Jesus jeɡ̶eete Filipe, “Igametaɡ̶a jakataɡ̶a liweenigi ina noiigi-nelegi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pida eote Jesus niɡ̶ida ligegi onidaaɡ̶ida me dineeteta Filipe, igaataɡ̶a Iniaaɡ̶iniwa ja yowooɡ̶odi niɡ̶ica aneote. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Odaa jeɡ̶ee Filipe, “Onidaaɡ̶ida me inedianaɡ̶atiniwace mokateciɡ̶initibige, odaa domaɡ̶a jopooɡ̶atibige caticedi miniwata taalia beexotedi me jinoojeteeɡ̶atigi paon”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Odaa niɡ̶ijo ane-diotibece, ane liboonaɡ̶adi André, nioxoa Simão Pedro, meetalo Jesus, ");
INSERT INTO kbcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ini lioneeɡ̶a digoina idiwa ciinco nipaontedi noenataka oyatita ‘cevaada’, idiaaɡ̶idiwa itiwataale noɡ̶ojedawaanaɡ̶a. Pida onateciɡ̶idiwa aɡ̶abotema niɡ̶ina noiigi-nelegi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Odaa jeɡ̶eetediogi Jesus niɡ̶idi anodiotibece, “Enitiogi iditawece niɡ̶idi noiigi-nelegi monicoteloco nadegocawaanigi”. Eliodi nadegocawaanigiteloco anei. Odaa ijotawece ja nicotiniwace. Onicoa ciinco miili ɡ̶oneleegiwadi minitaɡ̶a niɡ̶ijo lapo (we iwaalepodi inaa nigaanigipawaanigi). ");
INSERT INTO kbcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Igaanaɡ̶a iditawece nicotiniwace, odaa Jesus ja dibate niɡ̶ijoa ciinco paontedi, odaa ja diniotagodetedibigimece Aneotedoɡ̶oji. Naɡ̶a ninoketedini niɡ̶ijoa paontedi, odaa ja yajigotediogi niɡ̶ijo anodiotibece monediatiniwace iditawece niɡ̶ijo oko ane nicotiniwace. Odaa idaaɡ̶igote niɡ̶ijoa itiwataale noɡ̶ojedawaanaɡ̶a. Odaa neɡ̶epaa lica me niodaɡ̶a niɡ̶ijo oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Igaanaɡ̶a nitiminaɡ̶a, odaa jeɡ̶eetediogi Jesus niɡ̶ijo anodiotibece, “Atecoɡ̶oteeni inoa liwailidi ane iiɡ̶otedice adaɡ̶aniadi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Odaa joɡ̶oyatecoɡ̶otee niɡ̶ijoa liwailidi paontedi ane iiɡ̶otedice lapinaɡ̶a niɡ̶ijo noiigi-nelegi. Odaa niɡ̶ijoa liwailidawaanaɡ̶a anonioda niɡ̶ijo anodiotibece Jesus noleenaɡ̶adi dooze etacanitedi nelecoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Niɡ̶ijo oko anonadi niɡ̶ijo ɡ̶odoxiceɡ̶edi libinienigi aneote Jesus, modi, “Odaa aɡ̶alee jawienatakanaɡ̶a niɡ̶iniaaɡ̶iniwa, Niɡ̶icoa ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, ane niiɡ̶etedicogi Aneotedoɡ̶oji digoina iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Igaanaɡ̶a yowooɡ̶odi Jesus mewi modoletibige moyadeegi me domoɡ̶owo me inionigi-eliodi, odaa ja dinoɡ̶atedice, joɡ̶opitacedibigimece niɡ̶ijo lojotaɡ̶adi, pida onaniɡ̶ijoatece. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Igaanaɡ̶a dawike, niɡ̶ijo anodiotibece Jesus ja dinikatiniwace neɡ̶epaa miditaɡ̶a weiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Odaa joɡ̶owaxoditinigi niwatece, jiɡ̶igotibeci diɡ̶etitacicoace manitaɡ̶a nigotaɡ̶a Cafarnaum. Ja leegitece ɡ̶ocidi, ijaa Jesus aniɡ̶icoa micotediogi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Odaa joɡ̶odakapetege ica niwocotaɡ̶a, jeɡ̶eote ebekadi nelecoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ejinaɡ̶a domaɡ̶a seis leegoa me nolaakanaɡ̶a, odaa joɡ̶onaditege Jesus. Ewaligitedeloco ditibigimedi ninyoɡ̶odi. Niɡ̶ipegite naɡ̶ajo niwatece, odaa jeɡ̶epaanaɡ̶a doitibigiwaji, leeɡ̶odi aɡ̶oyowooɡ̶odi me Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Neɡ̶epaaɡ̶eetediogi, “Jeɡ̶emeɡ̶ee. Jinaɡ̶adoiitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Odaa ja nixomaɡ̶atice laadi, joɡ̶oyexaɡ̶atedi catinedi liwatece. Odaa aɡ̶ica daɡ̶a leegi naɡ̶ajo niwatece jiɡ̶icoticogi daato anoyemaa me diiticogi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naɡ̶a nigoi niɡ̶ijo oko ane nenyaɡ̶atiniwace daato weiigi, niɡ̶idi noiigi oyowooɡ̶odi mokajotece naɡ̶ajo niwatece anidiaaɡ̶i miditaɡ̶a. Codaa oyowooɡ̶odi me diɡ̶icoateda Jesus me waxoditedini mijotaɡ̶a niɡ̶ijo anodiotibece, codaa aɡ̶icoa Jesus mijotaɡ̶a niɡ̶ijo anodiotibece naɡ̶a noditice naɡ̶ajo niwatece. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pida icoa eletidi niwateceli anokaɡ̶a, ane icoɡ̶oticogi nigotaɡ̶a Tiberíades. Niɡ̶idiwa niwateceli joɡ̶odipegi niɡ̶ijo anei niɡ̶ijo lapo-nelegi moyeligo paontedi ane yediatetece Ǥoniotagodi Jesus, naɡ̶a igodi me diniotagodete Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Igaanoɡ̶onadi me diɡ̶icoateda Jesus ijaaɡ̶ijo anodiotibece niɡ̶ijo aneiticoace, odaa niɡ̶ijo lapo-nelegi joɡ̶owaxoditinigilo niɡ̶ijoa niwateceli, odaa jiɡ̶igotibeci nigotaɡ̶a Cafarnaum odoletibige Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Odaa niɡ̶ijo lapo-nelegi joɡ̶oyakadi Jesus daato weiigi. Odaa joɡ̶oige, moditalo, “Ǥoniiɡ̶axinoɡ̶odi. Igaatigi ica naɡ̶anooticogi ina?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ida makaamitiwaji aɡ̶oleetibigiji leeɡ̶odi manati niɡ̶ijoa ɡ̶odoxiceɡ̶etedi ane jaote (oditaɡ̶a jeɡ̶emaanitiwaji madinakatoni ane idimonya Aneotedoɡ̶oji). Pida niɡ̶ida makaamitiwaji oleetibigijitiwaji leeɡ̶odi melici niɡ̶ijoa paontedi ane jediataɡ̶adicitiwaji, odaa ja ɡ̶aditiminitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jiniɡ̶inoka adineloati mabaa makati ɡ̶aweenigi anepaɡ̶a ma. Pida adinoniciwaɡ̶atitiwaji makati ɡ̶aweenigi anepaɡ̶a daɡ̶a dinelio, aneo ɡ̶adewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji ane daɡ̶adiaaɡ̶ica liniogo. Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, jeɡ̶emaɡ̶a jajigotaɡ̶awatiwaji niɡ̶ida niweenigi, igaataɡ̶a Eiodi, Aneotedoɡ̶oji, ja ikee me najigotediwa inaɡ̶atetigi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Odaa joɡ̶oige Jesus, moditalo, “Amiini ica ane leeditibige me jaoɡ̶a ica ane yemaa Aneotedoɡ̶oji?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Niɡ̶ica nibakedi ane leeditibige mawii, ane yemaa Aneotedoɡ̶oji, yemaa niɡ̶ina me iwaɡ̶atitiwaji niɡ̶iniwa Aneotedoɡ̶oji ane nimonyatedaɡ̶awa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Odaa moditalo, “Amiida ica ɡ̶odoxiceɡ̶edi libinienigi anawii, odaa jeɡ̶ejiwaɡ̶ataɡ̶a niɡ̶inoa ɡ̶adotaɡ̶a? Amiida ica anawii me jinataɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jotigide ɡ̶odaamipi me idei midi nipodigi ane yadilo, oyeligo niɡ̶ijo paon ane icoɡ̶otibigimece ditibigimedi anodita ‘maná’. Igaataɡ̶a mee Aneotedoɡ̶oji lotaɡ̶a, ‘Ja yajigotediogi loiigi paon ane icoɡ̶otibigimece ditibigimedi analee oyeligo’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Odaa jeɡ̶eetediogi Jesus, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Aniɡ̶ijaa Moisés ane yajigo paon ane icoɡ̶otibigimece ditibigimedi moyeligo jotigide ɡ̶odaamipi. Pida Eiodi baaniɡ̶iniaa yajigo paon anewi me icoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Igaataɡ̶a paon ane yajigo Aneotedoɡ̶oji jiɡ̶iniaaɡ̶iniwa niɡ̶iniwa ane dinikatedini icoɡ̶otedibigimece ditibigimedi, aneote lewiɡ̶a oko digoina iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Odaa joɡ̶odipokotalo, moditalo, “Ǥoniotagodi. Enice ɡ̶odedianeɡ̶egitece inoatawece nokododi niɡ̶ica paon anenita”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Odaa jeɡ̶eetediogi Jesus, “Jeɡ̶emeɡ̶ee paon aneo lewiɡ̶a oko. Odaa niɡ̶ina anenagi meetaɡ̶a ja micataɡ̶a daaditaɡ̶adiaa nigicile. Codaa ane idadiwaɡ̶adi ja micataɡ̶a daaditaɡ̶adiaa yeloadi ecibi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Odaa jeɡ̶ejitaɡ̶awatiwaji me daɡ̶adadiwaɡ̶ati, idaaɡ̶ida naɡ̶a domaɡ̶adati. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Inatawece niɡ̶ina oko ane najigotediwa Eiodi, enagitibeci meetaɡ̶a. Niɡ̶ina anenagitibeci meetaɡ̶a, ajiticoiticoace. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Igaataɡ̶a aidinikati me jicoɡ̶otibigimece ditibigimedi daɡ̶a janagi jao inokina niɡ̶ica ane emaɡ̶a jemaa, pida idinikati me janagi jao ane yemaa Aneotedoɡ̶oji, leeɡ̶odi jiɡ̶iniaa idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Codaa jiɡ̶idaa yemaa Eiodi, ane idimonya. Yemaa me diɡ̶icata ane jiniaditema inatawece niɡ̶ina ane najigotediwa. Pida yemaa me jewikatiditace iditawece nigicota owidijegi noko. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Joaniɡ̶idaa ane yemaa, Niɡ̶ijoa ane idimonya. Yemaatedibige minatawece niɡ̶ina anonadi Lionigi Aneotedoɡ̶oji, odaa oyiwaɡ̶adi, modibatege lewiɡ̶a miniwataɡ̶a ane daɡ̶adiaaɡ̶ica liniogo, codaa me jaotace me newiɡ̶a nigicota owidijegi noko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Odaa icoa judeutedi ja notaɡ̶anaɡ̶ateloco odakapetege Jesus leeɡ̶odi niɡ̶ijo meetediogi, “Ee paon ane icoɡ̶otibigimece ditibigimedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Odaa modi, “Idoa aniɡ̶idaaɡ̶idoa ijoa Jesus, lionigi José? Ǥodowooɡ̶otagipi niɡ̶ijo eliododipi. Igaamee ina me yakadi mee me icoɡ̶otedibigimece ditibigimedi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Igaanaɡ̶a niniɡ̶odi Jesus, meetediogi, “Jaɡ̶abo motaɡ̶anitibecetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Inoka yakadi menagi meetaɡ̶a, niɡ̶ina Eiodi ane nadeegitediwa. Eiodi ane idimonyatedinigi niɡ̶ina iiɡ̶o. Odaa niɡ̶ina anenagi meetaɡ̶a jewikatiditace nigicota owidijegi noko. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Niɡ̶ijo jotigide niɡ̶ijo anoyeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, oiditini, ‘Aneotedoɡ̶oji iiɡ̶axi inatawece oko’. Inatawece niɡ̶ina anowajipatalo Eiodi liiɡ̶axinaɡ̶aneɡ̶eco, joaniɡ̶inaaɡ̶enagitibeci meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aɡ̶eji daantiɡ̶ica ane nadi Eiodi. Pida emoka Ee ane jicoɡ̶otibigimece miniwataɡ̶a Aneotedoɡ̶oji, baɡ̶a jinadi Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jemaa mejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ina ane idadiwaɡ̶adi idiokaanaɡ̶a limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jeɡ̶emeɡ̶ee paon aneo oko lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jotigide ɡ̶adaamipi oyeligo maná midi nipodigi ane yadilo. Pida biɡ̶idokee me nigo. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pida niɡ̶ina ane yeligo paon ane icoɡ̶otibigimece ditibigimedi baadaɡ̶adiaa yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ee jeɡ̶emeɡ̶ee paon ane icoɡ̶otibigimece ditibigimedi aneo oko lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo. Nigica ane yeligo niɡ̶idi paon, odaa idiokaanaɡ̶a limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji. Niɡ̶idi paon ane jajigo, yolaadi, jaotibige okotigi niɡ̶ina iiɡ̶o moyakadi lewiɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Odaa niɡ̶ijo judeutedi ja dinotigimadetiwage, modi, “Igamodaaɡ̶ee idoa ɡ̶oneleegiwa ina mee me yakadi me najigotedoɡ̶owa lolaadi me jelicaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Odaa jeɡ̶eetediogi Jesus, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Nige deɡ̶elicitatiwaji lolaadi Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi, ane Ee, codaa nige daɡ̶acipetalo yawodi, niɡ̶ida makaamitiwaji aɡ̶ica ɡ̶adewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pida niɡ̶ina ane yeligo yolaadi, codaa me wacipetalo yawodi, biɡ̶idiokaanaɡ̶a limedi me yewiɡ̶a. Codaa jewikatidi nigicota owidijegi noko. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Igaataɡ̶a yolaadi baɡ̶a paon anewi me yaaɡ̶adi me ɡ̶odigicile, codaa yawodi ɡ̶odacipaɡ̶adi anewi me yaaɡ̶adi me ɡ̶odeloadi ecibi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Niɡ̶ina ane yeligo yolaadi, codaa ane wacipetalo yawodi, idiokaanaɡ̶a limedi mini meetaɡ̶a, codaa ite Ee minitaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eiodi anida nimaweneɡ̶egi meote me yewiɡ̶a okanicodaaɡ̶ica oko, joaniɡ̶iniaa ane idimonya. Odaa jiɡ̶iniaaɡ̶aɡ̶a leeɡ̶odi me idewiɡ̶a. Odaa idaaɡ̶ee niɡ̶ina ane yeligo yolaadi, codaa me wacipetalo yawodi, idiokaanaɡ̶a limedi me yewiɡ̶a miniwataɡ̶a Aneotedoɡ̶oji, Ee leeɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Joaniɡ̶idiaa paon ane dinikatini icoɡ̶otibigimece ditibigimedi. Aliciagi niɡ̶ijo paon anoyeligo jotigide ɡ̶adaamipi, igaataɡ̶a aɡ̶aleeɡ̶ica me newiɡ̶a. Pida niɡ̶ina ane yeligo paon ane Ee biɡ̶idiokaanaɡ̶a limedi me yewiɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus eetetece niɡ̶inoa notaɡ̶a niɡ̶ijo me diiɡ̶axinaɡ̶a manitaɡ̶a liiakanaɡ̶axi judeutedi digoida nigotaɡ̶a Cafarnaum. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Eliodi niɡ̶ijo oko anodiotece noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a, modi, “Niɡ̶inoa lotaɡ̶a ɡ̶aladi, dakaketibige me jibaɡ̶atege. Amiijo ane yakadi me dibatege inoa lotaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aɡ̶ica ane yeloɡ̶oditalo Jesus, pida ja yowooɡ̶odi niɡ̶idi noiigi anodiotece moyalomeɡ̶e, dinotigimadetiwage leeɡ̶odi niɡ̶ijoa lotaɡ̶a. Joaniɡ̶idaa leeɡ̶odi me nigetediniwace, meetediogi, “Manigicaa jao mileenitomi leeɡ̶odi ijoa yotaɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Amiida ica ɡ̶adowoogotiwaji daɡ̶adati Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi, nige jopitibigimece ditibigimedi anejo maleedaɡ̶a icatibige daɡ̶a janagi digoina iiɡ̶o? ");
INSERT INTO kbcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Liwigo Aneotedoɡ̶oji jeɡ̶epaaɡ̶eo oko me yewiɡ̶a. Niɡ̶ida aɡ̶ica oko anida nimaweneɡ̶egi meo. Pida yotaɡ̶a, loniciwaɡ̶awa Liwigo Aneotedoɡ̶oji meo oko me yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Odaa idi niɡ̶ina akaamitiwaji aɡ̶etidadiwaɡ̶adi me idimonya Aneotedoɡ̶oji”. Meetediogi Jesus niɡ̶ida ligegi leeɡ̶odi niɡ̶ijo maleekoka eniditediogi niɡ̶ijo analee odiotibece, akaa yowooɡ̶odi ane doɡ̶oyiwaɡ̶aditeda, codaa akaa yowooɡ̶odi niɡ̶ijo ane yajigo modibatalo niɡ̶ijo neloɡ̶ododi. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eɡ̶idaa diitigi Jesus me notaɡ̶aneɡ̶etediniwace, meetediogi, “Joaniɡ̶idaa mejitaɡ̶awatiwaji niɡ̶ina oko idoka yakadi menagi meetaɡ̶a, nigeote Eiodi me yakadi menagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Niɡ̶idiaaɡ̶idi eliodi niɡ̶ijo oko anodiotece Jesus ja dinoɡ̶aticoace, odaa aɡ̶aleeɡ̶odinadeegitege. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Odaa Jesus jaɡ̶aɡ̶a nigetediniwace niɡ̶ijo dooze anodiotibece, meetediogi, “Akaamitiwaji aaɡ̶aɡ̶a emaani mopili?” ");
INSERT INTO kbcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Naɡ̶a niniɡ̶odi Simão Pedro, meetalo, “Ǥoniotagodi. Amaleeɡ̶aɡ̶ijo ica ane jiiɡ̶ata? Igaataɡ̶a niɡ̶inoa ɡ̶adotaɡ̶a onikeetoɡ̶owa anodaaɡ̶ee me jakataɡ̶a ɡ̶odewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ejiwaɡ̶atakanaɡ̶a codaa jowooɡ̶otaɡ̶a naɡ̶akamaɡ̶akaami ane niiɡ̶e Aneotedoɡ̶oji mawii ɡ̶odewiɡ̶a. Akaami Lionigi Aneotedoɡ̶oji ewikegi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Odaa ja niniɡ̶odi Jesus, meetediogi, “Ja ɡ̶adixipeniticetiwaji akaami dooze. Pida oniniteci niɡ̶ina akaamitiwaji, niɡ̶ini diaabo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Niɡ̶ina meote niɡ̶ida ligegi, eeteta Judas niɡ̶ijo lionigi Simão Iscariotes. Leeɡ̶odi Judas, idaaɡ̶ida mida aneetege niɡ̶ijo dooze anodiotibece, pida jiɡ̶ijaa yajigo Jesus modibatalo niɡ̶ijo neloɡ̶ododipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Niɡ̶idiaaɡ̶idi Jesus igotedeloco nipodigi Galiléia. Aɡ̶idiaaɡ̶ite nipodigi Judéia, leeɡ̶odi niɡ̶ijoa lacilodi judeutedi digoida Judéia odoletibige moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jiɡ̶ipegiteloco lalokegi judeutedi, anodita “Lalokegi nopecetiidi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Odaa niɡ̶ijo nioxoadipi Jesus moditalo, “Anotitice Galiléia, emii Judéia amaleeɡ̶aɡ̶a onadi niɡ̶ina anodiotibigaɡ̶adici niɡ̶inoa ɡ̶odoxiceɡ̶etedi anawiite. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Igaataɡ̶a niɡ̶ina ane yemaa me yeloɡ̶o, ayaɡ̶aditini niɡ̶ina loenatagi. Genaɡ̶a awiite niɡ̶inoa ane libinienaɡ̶a, odaa ele mikeenitiogi inatawece oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pida oteɡ̶exaaɡ̶aɡ̶a niɡ̶idi nioxoadipi aɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Odaa jeɡ̶eetediogi Jesus, “Aniɡ̶icota limedi me jikee ane Ee. Pida akaamitiwaji boɡ̶okanicodaaɡ̶aca lakata noko yakadi memii. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Niɡ̶ina okotigi digoina iiɡ̶o aɡ̶ica leeɡ̶odi doɡ̶oyelataɡ̶adomitiwaji, pida Ee boɡ̶oyelatomi. Igaataɡ̶a jikeetiogi niɡ̶inoa loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Emiitiwaji miditaɡ̶a nalokegi. Ee baɡ̶aleedeɡ̶ejigo igaataɡ̶a aniɡ̶icota limedi me idinikee ane Ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Joaniɡ̶idaa ligegitediogi, odaa jiɡ̶idiaaɡ̶itedice Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Igaanaɡ̶a leecawaanigi migotibeci niɡ̶ijo nioxoadipi miditaɡ̶a nalokegi, odaa Jesus jaɡ̶aɡ̶a igo. Pida dinaɡ̶aditedini migo, aɡ̶ica ane yowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Icoa lacilodi judeutedi joɡ̶odoletibige Jesus miditaɡ̶a nalokegi. Modi, “Igamige diɡ̶etedigi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ica lapo-nelegi miditaɡ̶a niɡ̶ijo nalokegi, eliodi oko oxatiniwace niɡ̶ina me notaɡ̶anaɡ̶a oyalaɡ̶atalo Jesus. Idi oko anodi, “Niɡ̶ijoa ɡ̶oneleegiwa doane mele”. Odaa idiaaɡ̶eledi modi, “Amitiɡ̶ica ica mele, mina ninaaletediniwace oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pida aɡ̶ica ane yalaɡ̶atalo me lodoe oko-nelegi, leeɡ̶odi odoitiogi niɡ̶idiwa lacilodi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Igaanaɡ̶a ixomaɡ̶atedijo liwigotigi niɡ̶ijoa nokododi me nalooɡ̶o, odaa jaɡ̶aɡ̶a icotedio Jesus, ja dakatediwece Aneotedoɡ̶oji liɡ̶eladi, odaa ja niiɡ̶axitediniwace oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Niɡ̶ijoa lacilodi judeutedi eliodi moyopo, modi, “Igaamee ina me yowooɡ̶odi inoatawece? Igaataɡ̶a niɡ̶inoa ɡ̶oniiɡ̶axinoɡ̶ododi aɡ̶ica doɡ̶oiiɡ̶axi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Niɡ̶inoa ane jiiɡ̶axinaɡ̶atece aɡ̶emaɡ̶a yowooko, pida icoɡ̶otedibigimece miniwataɡ̶a Aneotedoɡ̶oji, ane idiiɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nigica ane yemaa meo ane yemaa Aneotedoɡ̶oji, joaniɡ̶iniaa yowooɡ̶odi migewi me icoɡ̶otedibigimece miniwataɡ̶a Aneotedoɡ̶oji niɡ̶inoa iiɡ̶axinaɡ̶aneɡ̶eco, oɡ̶oa domige emaɡ̶a yowooko. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Niɡ̶ina ane diiɡ̶axinaɡ̶atece epaa lowooko, niɡ̶ini doletibige me dinikeenaɡ̶aneɡ̶e. Pida niɡ̶ina ane doletibige meo me yeloɡ̶o Aneotedoɡ̶oji, niɡ̶ini beɡ̶ewi, codaa me iɡ̶enaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés yajigotedaɡ̶awatiwaji liiɡ̶enatakaneɡ̶eco Aneotedoɡ̶oji. Pida aɡ̶ica niɡ̶ina akaamitiwaji aneyiwaɡ̶adi liiɡ̶enatakaneɡ̶eco. Igaataɡ̶a idioka limedi moleetibigetiwaji madeloati.” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Noɡ̶oniniɡ̶odi niɡ̶idi oko-nelegi, moditalo, “Niɡ̶ida makaami ejime dakatiwaɡ̶aji niwigo abeyaceɡ̶egi. Igaataɡ̶a aɡ̶ica ane doletibige me ɡ̶adeloati”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Meetediogi Jesus, “Niɡ̶ijo me jao ɡ̶odoxiceɡ̶edi libinienigi, odaa akaamitawecetiwaji joɡ̶opoo. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Digawini! Niɡ̶ina me saabado akagititiwaji lolaadogo nigaanigawaanigi me ikeeni meledi ida aneetege Aneotedoɡ̶oji loiigi, leeɡ̶odi lajoinaɡ̶aneɡ̶egi Moisés. Codaa aniɡ̶ijaaɡ̶ijotace Moisés liiɡ̶enatakaneɡ̶egi, pida jotigide ɡ̶adaamipi maleediɡ̶icata Moisés naɡ̶akaaɡ̶ida me lakatigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Akagititiwaji nigaanigawaanigi lolaadogo niɡ̶ina me saabado, noko ane daɡ̶a domaɡ̶a yakadi mica ɡ̶abakedi, me iwitece lajoinaɡ̶aneɡ̶eco Moisés. Enice, igaamee ina me ɡ̶adelatomi, leeɡ̶odi me jicilatiditece niɡ̶ijo ɡ̶oneleegiwa ijoatawece libeyaceɡ̶eco me saabado? ");
INSERT INTO kbcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ikanitiwaji me ɡ̶adiɡ̶oati oko leeɡ̶odi anee mida moko, pida oleetibige ane iɡ̶enaɡ̶a codaa anewi niɡ̶ina mawini eledi oko anee.” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Onica ica niɡ̶eladimigipitigi nigotaɡ̶a Jerusalém, anodi, “Niɡ̶idoa jiɡ̶idaaɡ̶idoa niɡ̶icoa ɡ̶oneleegiwa anodoletibige moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pida digawini! Dotaɡ̶atedibece lodoe niɡ̶ina noiigi, niɡ̶inoa ɡ̶odacilodi aɡ̶ica mowote, aɡ̶ica ligegi doɡ̶odakapetege. Migoyowooɡ̶odi mewi niɡ̶idoa ɡ̶oneleegiwa niɡ̶idaaɡ̶idoa Icoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pida Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji nigenagi, aɡ̶ica ane yowooɡ̶odi niɡ̶ica ane icoɡ̶otedicogi. Igaataɡ̶a baɡ̶a jowooɡ̶otaɡ̶a ane icoɡ̶otedicogi niɡ̶idoa ɡ̶oneleegiwa. (Odaa niɡ̶idoa ɡ̶oneleegiwa ayakadi daantiɡ̶idaaɡ̶idoa Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji.)” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Eɡ̶idaaɡ̶ee me diiɡ̶axinaɡ̶a Jesus catiwedi Aneotedoɡ̶oji liɡ̶eladi, ja yawice me dotaɡ̶a, mee, “Migewi madowooɡ̶otitiwaji, codaa migewi mowooɡ̶oti ane jicoɡ̶oticogi? Ajanagi daɡ̶a jibake emaɡ̶a inaɡ̶atetigi. Niɡ̶ijoa ane idiiɡ̶e ewi. Pida niɡ̶ida makaamitiwaji aɡ̶icoa mowooɡ̶oti. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pida Ee baɡ̶a jowooɡ̶odi, igaataɡ̶a ida anejitege, codaa jeɡ̶epaa idimonya”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Odaa joɡ̶odoletibige moniwilo Jesus, leeɡ̶odi niɡ̶ijoa lotaɡ̶a. Pida aɡ̶ica ane dibatalo, leeɡ̶odi aniɡ̶icota limedi me yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Eliodi oko niɡ̶ijo lapo-nelegi joɡ̶oyiwaɡ̶adi. Odaa modi, “Ajawienatakanaɡ̶a niɡ̶ina nigenagi Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a, aɡ̶eote ɡ̶odoxiceɡ̶etedi ane naɡ̶axatelogo niɡ̶inoa aneote niɡ̶idoa ɡ̶oneleegiwa.” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Onateciɡ̶ijo niɡ̶ijo fariseutedi owajipata ligegi niɡ̶ijo lapo-nelegi moyalaɡ̶atalo Jesus, pida oxatiniwace. Joaniɡ̶idaa leeɡ̶odi niɡ̶ijo fariseutedi ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi moiiɡ̶e niodaɡ̶awadi me domoɡ̶odibatalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Odaa jeɡ̶eetediogi Jesus niɡ̶ijo oko, “Aleegi minaaɡ̶ejo makaamitaɡ̶atiwaji. Nigidiaaɡ̶idi jopiticogi miniwataɡ̶a Niɡ̶ijoa ane idiiɡ̶etedinicogi digoina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Icota moleetibigijitiwaji, pida apinitibigiji aɡ̶adakati, igaataɡ̶a aɡ̶akati deɡ̶emiitiwaji ane jiiticogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Odaa modi niɡ̶ijo lacilodi judeutedi, “Igamige diitedicogi ina nige daɡ̶adiaaɡ̶icoa me jakataɡ̶a? Domige igo miditaɡ̶a ɡ̶odoiigi judeutedi ane idei midiwataɡ̶a nigotadi noiigi greego? Oɡ̶oa, mige igo me niiɡ̶axitediniwace idi ane daɡ̶a ɡ̶odoiigi? ");
INSERT INTO kbcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ajowooɡ̶otaɡ̶a niɡ̶ica ane diitigilo niɡ̶ijoa lotaɡ̶a niɡ̶ijo neɡ̶eetedoɡ̶owa, ‘Oleetibigijitiwaji, pida aɡ̶aleeɡ̶ee madakati, apinitibigiji leeɡ̶odi aɡ̶akati deɡ̶emiitiwaji ane jiiticogi’.” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Niɡ̶ijo owidijegi noko me nalooɡ̶o, jiɡ̶ijaaɡ̶ijo niɡ̶ica noko ane daɡ̶axa me ɡ̶oneɡ̶egi. Odaa niɡ̶ijo noko dabiditedini Jesus, ja yawice me dotaɡ̶a, mee, “Nigica ane yeloadi ecibi, anagi meetaɡ̶a, acipe! ");
INSERT INTO kbcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mee Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, ‘Laaleɡ̶ena niɡ̶ina oko ane idadiwaɡ̶adi liciagi niɡ̶ina lacilotibige ninyoɡ̶odi. Latoaɡ̶egi ninyoɡ̶odi aneo ɡ̶odewiɡ̶a icoɡ̶otiwece laaleɡ̶ena’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus eeteta Liwigo Aneotedoɡ̶oji modibatege niɡ̶ina anoyiwaɡ̶adi. Pida aniɡ̶ica doɡ̶odibatege Liwigo Aneotedoɡ̶oji, igaataɡ̶a Aneotedoɡ̶oji aneɡ̶eote Jesus me daɡ̶axa me ɡ̶oneɡ̶egi, leeɡ̶odi anaɡ̶a yeleo codaa anaɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Igaanaɡ̶a owajipatalo lotaɡ̶a Jesus niɡ̶ijo noiigi-nelegi, eliodi oko modi, “Dicewi niɡ̶idoa ɡ̶oneleegiwa niɡ̶idaaɡ̶idoa niɡ̶icoa ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pida idi ica eledi oko anodi, “Jiɡ̶idaaɡ̶idoa Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a”. Pida ica eledi oko modi, “Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji aicoɡ̶otedicogi nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Igaataɡ̶a mee Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, ‘Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a ida aneetetege licoɡ̶egi Davi, codaa idiaaɡ̶aɡ̶a lanikadi manitaɡ̶a nigotakawaana Belém, ane liɡ̶eladi Davi’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Odaa niɡ̶ijo noiigi-nelegi ja dawalacetiwage leeɡ̶odi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Odaa idi ica anodoletibige moniwilo, pida aɡ̶ica ane dibatalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Odaa niɡ̶ijoa iodaɡ̶awadi anoiiɡ̶e ja dopiticogi minitaɡ̶a niɡ̶ijo lapo fariseutedi ijaaɡ̶ijo niɡ̶ijo anoiiɡ̶e sacerdotitedi. Odaa joɡ̶onigetiniwace niɡ̶idiwa iodaɡ̶awadi, moditiogi, “Igaamee ina me diɡ̶icoateda manadeegitetiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Noɡ̶oigidi, moditiogi, “Aniɡ̶ica daɡ̶a jinataɡ̶a ane dotaɡ̶a liciagi niɡ̶ijoa ɡ̶oneleegiwa me dotaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Odaa niɡ̶ijoa fariseutedi moditiogi niɡ̶ijoa iodaɡ̶awadi, “Naɡ̶aɡ̶a etiɡ̶adinaalenitiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Aɡ̶ica aneyiwaɡ̶adi niɡ̶ijoa ɡ̶oneleegiwa niɡ̶inoa lacilodi judeutedi, oteɡ̶exaaɡ̶aɡ̶a niɡ̶idiwa fariseutedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pida niɡ̶idi noiigi aɡ̶oyowooɡ̶odi ɡ̶onajoinaɡ̶aneɡ̶eco ane najigotedoɡ̶owa Moisés, odaa Aneotedoɡ̶oji icota me iloikatidi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Onijoteci fariseu ane liboonaɡ̶adi Nicodemus, niɡ̶ijo ane igo dinotaɡ̶aneɡ̶etege Jesus niɡ̶ijo enoale, meetiogi, ");
INSERT INTO kbcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ǥonajoinaɡ̶aneɡ̶eco anikatoɡ̶odici daɡ̶a jiiɡ̶enatakanaɡ̶a motacidetibigo okanicodaaɡ̶ica ɡ̶oneleegiwa nige doɡ̶odoejegi me jajipaaɡ̶ata, codaa nige daɡ̶a jowooɡ̶otaɡ̶a ane loenatagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Noɡ̶oniniɡ̶odi, modita, “Domige akaami eledi elatibige nipodigi Galiléia? Awiniteloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, odaa joɡ̶owooɡ̶oti me diɡ̶ica ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko ane icoɡ̶oticogi nipodigi Galiléia.” ");
INSERT INTO kbcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Odaa niɡ̶idiaaɡ̶idi ijotawece niɡ̶ijo oko joɡ̶opiticogi niɡ̶inoa liɡ̶elatedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Odaa Jesus jiɡ̶igo minitaɡ̶a lojotaɡ̶adi anodita me “Lojotaɡ̶adi Oliveira”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Igaanaɡ̶a eledi noko, naɡ̶a yapacaɡ̶atege nigoi, jiɡ̶igotace Jesus minitaɡ̶a liɡ̶eladi Aneotedoɡ̶oji. Ijotawece niɡ̶ijo oko-nelegi odilapodetelogo. Naɡ̶a nicotedini, odaa ja niiɡ̶axitediniwace. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Niɡ̶ijo anodiiɡ̶axinaɡ̶atece lajoinaɡ̶aneɡ̶eco Moisés ijaaɡ̶ijoa fariseutedi oyadeegitalo Jesus aca iwaalo, odaa joɡ̶owo me dabidite lodoe niɡ̶idi noiigi-nelegi. Naɡ̶aca iwaalo odibateloco me doɡ̶olaɡ̶ataka. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Odaa moditalo Jesus, “Niiɡ̶axinaɡ̶anaɡ̶a. Naɡ̶ada iwaalo odibateloco me doɡ̶olaɡ̶ataka. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Odaa ɡ̶onajoinaɡ̶aneɡ̶eco, Moisés ane iditedini, oniiɡ̶etoɡ̶owa me inigidaaɡ̶atice jatiiɡ̶ata wetiɡ̶a naɡ̶ana iwaalo ane doɡ̶olaɡ̶ataka me jeloataɡ̶a. Pida baɡ̶akaami, amaɡ̶aɡ̶a ida ica anakati me leeditibige me eniɡ̶ata?” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Moditalo Jesus niɡ̶inoa lotaɡ̶a onidaaɡ̶ida modineetalo, domoɡ̶odoletibige ane leeɡ̶odi modakapetege. Pida aniniɡ̶odi. Naɡ̶a dakagitedini, odaa ja iditedinigi iiɡ̶o datikate nibedona. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Odopitibigelogo moige Jesus. Odaa ja dabiditedini, odaa jeɡ̶eetediogi, “Nigica niɡ̶ina akaamitiwaji ane diɡ̶ica meo anigetiɡ̶ida loenatagi ane beyagi, jiɡ̶iniaa leeditibige modoejegi me yokoleteloco wetiɡ̶a naɡ̶ada iwaalo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Naɡ̶a dakagitacedini, odaa ja iditacedinigi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Igaanaɡ̶a owajipatalo niɡ̶ijoa Jesus lotaɡ̶a, odaa ijotawece opitibeci oninitecibeci dinilotice, leeɡ̶odi odeemitetece maɡ̶aɡ̶a inoa libeyaceɡ̶eco. Odoejedipi niɡ̶ijo laxokodipi lacilodi me noditicoaci. Odaa yeyaɡ̶atedice iniokaaniɡ̶iniwateda Jesus ajaaɡ̶ajo iwaalo ane dabidite lodoe niɡ̶ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Igaanaɡ̶a dabiditedini Jesus, odaa ja nadi naɡ̶ajo iwaalo mokanaɡ̶adatece. Odaa jeɡ̶eeteta, “Igaataɡ̶a ijo anodakapetaɡ̶agi, anetiɡ̶adatameɡ̶enitice? Aɡ̶ica ane nenyaɡ̶ati ijoa anodi me leeditibige metiɡ̶adiloikatiti?” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naɡ̶a niniɡ̶odi meetalo, “Aɡ̶ica ane nenyaɡ̶ati, Iniwa-aagodi”. Odaa jeɡ̶eeteta Jesus, “Ee aɡ̶akaami ilaagete. Emii opili, pida jinaɡ̶aleeɡ̶awii ɡ̶adoenatagi ane beyagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Odaa Jesus jeɡ̶eetacediogi, “Niɡ̶ida mee Ee iciagi macataɡ̶a naɡ̶ana lokokena ane naloteloco inatawece oko digoina iiɡ̶o. Niɡ̶ina oko ane niotici ani nilokokena aneo me yewiɡ̶a oko, aliciagi niɡ̶ina oko anigotigi nexocaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Odaa moditalo niɡ̶ijoa fariseutedi, “Akamaɡ̶a ɡ̶adalaki anakaami. Joaniɡ̶idaa leeɡ̶odi ɡ̶adotaɡ̶a aɡ̶ica niwaló.” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Idaaɡ̶ida nige emeɡ̶ejitece ane Ee, pida yotaɡ̶a baɡ̶a diniwaloe, ejitece anewi. Igaataɡ̶a jowooɡ̶odi ane jicoɡ̶oticogi codaa jowooɡ̶odi ane jopiticogi. Pida niɡ̶ida makaamitiwaji aɡ̶owooɡ̶oti ane jicoɡ̶oticogi, oteɡ̶exaaɡ̶aɡ̶a niɡ̶ica ane jopiticogi aɡ̶owooɡ̶oti. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niɡ̶ida makaamitiwaji ɡ̶adiɡ̶oati oko inokina anee mini me yeloɡ̶o, ane lakatigi, pida Ee aidiɡ̶oadita oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Anaɡ̶a jiwi oko natigide, pida nige jiwi anodaaɡ̶eeta jao niɡ̶ina ane iɡ̶enaɡ̶a, codaa anewi. Igaataɡ̶a aɡ̶oka eetece me jiwi oko anee. Pida Eiodi ane idimonya iniwa meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Maditaɡ̶a notaɡ̶anaɡ̶axi ane iwotelogo ɡ̶onajoinaɡ̶aneɡ̶eco diniditeloco niɡ̶ina iniwataale oko me niwoditiwage, odaa niɡ̶ina ane ligegi ewi, leeɡ̶odi niwoditiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ee ejitece ane Ee, codaa Eiodi ane idimonya eledi eetetece anodaaɡ̶eji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Odaa joɡ̶oige, moditalo, “Igame diɡ̶etedigi icoa ɡ̶adiodi?” Naɡ̶a igidi Jesus, meetediogi, “Niɡ̶ida makaamitiwaji aɡ̶adowooɡ̶oti, oteɡ̶exaaɡ̶aɡ̶a icoateda mowooɡ̶oti Eiodi. Daɡ̶adowooɡ̶otitiwaji, daɡ̶anagawini aaɡ̶aɡ̶a owooɡ̶oti Eiodi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Meetetece Jesus niɡ̶inoa lotaɡ̶a niɡ̶ijo me diiɡ̶axinaɡ̶a catiwedi Aneotedoɡ̶oji liɡ̶eladi, ipegitetege aca niwokodaɡ̶axi anoyate niɡ̶inoa dinyeelo anoyajigotalo Aneotedoɡ̶oji. Aɡ̶ica ane dibatalo Jesus me niwilo, igaataɡ̶a aniɡ̶icota limedi me yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Odaa jeɡ̶eetacediogi Jesus, “Niɡ̶ida me Ee icota me jopi. Domoɡ̶oleetibigijitiwaji. Pida niɡ̶ida makaamitiwaji idokeeta me ɡ̶ademaɡ̶awadi ɡ̶abeyaceɡ̶eco. Aɡ̶akatitiwaji deɡ̶emii ane jopiticogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Odaa niɡ̶ijo lacilodi judeutedi dinotaɡ̶aneɡ̶etiwage, modi, “Meetedoɡ̶owa me daɡ̶a jakataɡ̶a miniɡ̶a ica anopitedicogi. Migigo dineloadi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Odaa jeɡ̶eetediogi Jesus, “Akaami niɡ̶eladimigipitedigitiwaji digoina iiɡ̶o. Pida Ee baɡ̶a iɡ̶eladi digoida ditibigimedi. Akaami niɡ̶eladimigipitedigitiwaji niɡ̶ina iiɡ̶o, pida Ee baadaɡ̶a iɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Joaniɡ̶idaa leeɡ̶odi mejitaɡ̶awatiwaji malee ɡ̶ademaɡ̶awadi ɡ̶abeyaceɡ̶eco. Nige daɡ̶a iwaɡ̶atitatiwaji ane Ee, odaa nige ɡ̶adelewitiwaji ɡ̶ademaɡ̶awadi ɡ̶abeyaceɡ̶eco”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Odaa joɡ̶oige, moditalo, “Ida makaami amakaami?” Odaa jeɡ̶eetediogi Jesus, “Niɡ̶ijo maleeka idinojogotini me jiba neɡ̶ejitaɡ̶awatiwaji ane Ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Owidi inoa anejitece me jakapetaɡ̶agitiwaji, codaa akaami ilaagetedipi. Pida jajipatalo lotaɡ̶a Niɡ̶ijoa ane idimonya, codaa jiɡ̶inokinoateda mejitiogi niɡ̶ina oko digoina iiɡ̶o. Igaataɡ̶a Niɡ̶ijoa ane idimonya, ewi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aɡ̶oyowooɡ̶odi Jesus me yalaɡ̶ate Aneotedoɡ̶oji, ane Eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Joaniɡ̶idaa leeɡ̶odi meetediogi Jesus, “Nigotoniteditiwaji meloati Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi, odaa joɡ̶owooɡ̶otitiwaji ane Ee. Icota mowooɡ̶otitiwaji me diɡ̶ica ane jao ane emaɡ̶a inaɡ̶atetigi. Pida ejitaɡ̶awa inokinoateda ane idiiɡ̶axitetece Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Niɡ̶ijoa ane idimonya etiniwa meetaɡ̶a. Aɡ̶ica daɡ̶a idika doɡ̶oka eetece, igaataɡ̶a idioka limedi me jao ane yemaa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Niɡ̶ijo neɡ̶ee Jesus niɡ̶inoa lotaɡ̶a, eliodi oko joɡ̶oyiwaɡ̶adi mewi me Aneotedoɡ̶oji ane nimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Odaa jeɡ̶eetediogi Jesus niɡ̶ijoa judeutedi anoyiwaɡ̶adi, “Nigidioka limeditatiwaji me iwaɡ̶ati yotaɡ̶a, odaa jaɡ̶akaami niɡ̶ina anewi moniotici. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Odaa joɡ̶owooɡ̶otitiwaji anewi, codaa niɡ̶ida anewi ɡ̶adikaniticetiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Odaa joɡ̶oniniɡ̶odi, moditalo, “Niɡ̶ida moko ida anejinaɡ̶atege licoɡ̶egi Abraão. Aniɡ̶ica daɡ̶a etiɡ̶odiotage. Igame leeɡ̶odi ina menitoɡ̶owa metiɡ̶odikatice? Igaataɡ̶a aɡ̶oko niwilogojegipi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Odaa jeɡ̶eetediogi Jesus, “Ewi mejitaɡ̶awatiwaji, niɡ̶ina anidioka limedi meo ane beyagi, joaniɡ̶iniaa liotagi nibeyacaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Niɡ̶ina niotagi aɡ̶idioka limedi me yakadi midiaaɡ̶itigi liɡ̶eladi niotagodi. Pida niɡ̶ina nionigi biɡ̶idioka limedi me itiogi loiigiwepodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nige Aneotedoɡ̶oji Lionigi ɡ̶adowilecenitetematiwaji ɡ̶abeyaceɡ̶eco me ɡ̶adikanitedice, odaa beɡ̶ewi madinikaniticoace. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jowooɡ̶oditiwaji mida anenitege licoɡ̶egi Abraão, pida oleetibigetiwaji madeloati, leeɡ̶odi aɡ̶abaategetiwaji iiɡ̶axinaɡ̶aneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ejitece niɡ̶inoa ane nikeetediwa Eiodi. Odaa akaamitiwaji jaɡ̶aɡ̶a iwitece niɡ̶ina anaɡ̶aɡ̶a iiɡ̶axitaɡ̶adici ɡ̶adiodi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Odaa joɡ̶oigidi, moditalo, “Ewi me ɡ̶odiodi Abraão”. Odaa jeɡ̶eetediogi Jesus, “Daɡ̶akaami lionigipitetiwaji Abraão, daɡ̶anagawini awii liciagi niɡ̶ijoa loenataka. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pida jeɡ̶ejitaɡ̶awatiwaji anewi, yajipakegitalo Aneotedoɡ̶oji. Pida eɡ̶idaaɡ̶enitiwaji moleetibige madeloati. Abraão aɡ̶ica deɡ̶eo liciagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Niɡ̶ida makaamitiwaji baɡ̶awii liciagi niɡ̶ijo ɡ̶adiodi”. Noɡ̶oniniɡ̶odi, moditalo, “Iniwa oniniwatece Ǥodiodi, ane Aneotedoɡ̶oji. Mina oko lionigipi, anewi me lionigipi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Odaa jeɡ̶eetediogi Jesus, “Digawinitiwaji, deɡ̶ewi me Ǥadiodi Aneotedoɡ̶oji, daɡ̶anagawini ademaani, igaataɡ̶a Ee Lionigi, codaa jiɡ̶idaa jicoɡ̶oticogi miniwataɡ̶a. Aneɡ̶emaɡ̶a yoniciwaɡ̶a me janagi, pida jiɡ̶iniaa idiiɡ̶e. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aɡ̶owooɡ̶otitetiwaji ane diitigi niɡ̶inoa yotaɡ̶a, leeɡ̶odi aɡ̶emaani mabaatege iiɡ̶axinaɡ̶aneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akaami lionigipitetiwaji diaabo, codaa inoka emaani mawii niɡ̶ica ane yemaa. Niɡ̶ijo maleeka igo niɡ̶ina iiɡ̶o, naɡ̶akaa ɡ̶onematagodi. Aɡ̶ica aneetege niɡ̶ica anewi, igaataɡ̶a minitaɡ̶a aɡ̶ica anewi. Niɡ̶ina me diwitaka, eo niɡ̶ica anepaa lakatigi, igaataɡ̶a awitakegi. Codaa eliodi inoatawece niwitakeco. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aɡ̶iwaɡ̶atitiwaji niɡ̶inoa anejitedaɡ̶awa, igaataɡ̶a ejitece niɡ̶ina anewi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aɡ̶ica niɡ̶ina akaamitiwaji ane yakadi me nikeetiwa mida ibeyaceɡ̶egi. Nigejitece anewi, igame leeɡ̶odi me daɡ̶a iwaɡ̶atitedatiwaji yotaɡ̶a? ");
INSERT INTO kbcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Niɡ̶ina ane nebi Aneotedoɡ̶oji, watacotece Aneotedoɡ̶oji lotaɡ̶a. Odaa niɡ̶ida makaamitiwaji aɡ̶atacolitece Aneotedoɡ̶oji lotaɡ̶a, igaataɡ̶a aɡ̶ica ane enitegetetiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Odaa niɡ̶ijoa lacilodi judeutedi moditalo Jesus, “Ja jowooɡ̶otaɡ̶a mewi niɡ̶ijo anejinaɡ̶ata, makaami elatibige noiigi samaritaano, codaa niɡ̶ida makaami ejime dakatiwaɡ̶aji niwigo abeyaceɡ̶egi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Aɡ̶ica niwigo abeyaceɡ̶egi meetaɡ̶a. Pida joɡ̶etetalo Eiodi, pida akaamitiwaji baadaɡ̶a eemiteetibigiji, leeɡ̶odi otaɡ̶anitibigiji. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aidinabaketibece daɡ̶a emaɡ̶a joletibige me ideloɡ̶o. Pida ini anepaɡ̶a doletibige me doɡ̶etetiwa, codaa me ikee anewi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ewi mejitaɡ̶awatiwaji, niɡ̶ina aneyiwaɡ̶adi yotaɡ̶a, aɡ̶alee yeleo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Odaa moditalo niɡ̶ijoa judeutedi, “Niɡ̶ina natigide aɡ̶alee jawienatakanaɡ̶a me dakatiwaɡ̶aji niwigo abeyaceɡ̶egi. Abraão akaa yeleo, niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko eledi akaa nigo. Pida akaami meni niɡ̶ina aneyiwaɡ̶adi ɡ̶adotaɡ̶a me daɡ̶adiaa yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Domige daɡ̶axa makaami ɡ̶oneɡ̶egi, agodaɡ̶a ɡ̶adiciagi ɡ̶odiodi Abraão anakaa yeleo? Eleditace domige anaɡ̶axaateloco niɡ̶ijo anoyeloɡ̶oditedibece Aneotedoɡ̶oji lowooko baanaɡ̶a akaa nigo? Meni manaɡ̶axaateloco, pida awitaka!” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Deɡ̶emaɡ̶a jao me ideloɡ̶o, aɡ̶ica jao. Pida Eiodi doɡ̶etetediwa. Odaa akaamitiwaji meni me Ǥanoenoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pida aɡ̶ica doɡ̶owooɡ̶otitetiwaji. Pida Ee baɡ̶a jowooɡ̶odi. Deɡ̶ejitaɡ̶awatiwaji me diɡ̶icoateda me jowooɡ̶odi, odaa jeɡ̶ee awitakegi, digo anenitiwaji mawitaka. Pida jowooɡ̶odi Eiodi, codaa mejiwaɡ̶adi lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jotigide ɡ̶anelokoditiwaji Abraão ninitibece naɡ̶a yowooɡ̶odi micota noko me janagi niɡ̶ina iiɡ̶o. Naɡ̶a yowooɡ̶odi niɡ̶ijo noko, odaa ja ninitibece”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pida moditalo, “Niɡ̶ida makaami aniɡ̶icoa oteɡ̶exaaɡ̶aɡ̶a meya-taalia ɡ̶anicaaɡ̶ape. Igamodaaɡ̶ee ica makati manati Abraão?” ");
INSERT INTO kbcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Ejitaɡ̶awatiwaji anewi. Aniɡ̶icatibige Abraão deɡ̶enitini, naɡ̶a Ee, codaa idioka limedi me Ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Odaa niɡ̶ijoa judeutedi joɡ̶odibatalo wetiadi me domaɡ̶a oyokoletelogo, pida Jesus ja dinaɡ̶aditedi. Igotedigi liwigotigi niɡ̶ijo noiigi-nelegi ane dilapode, odaa ja noditedice Aneotedoɡ̶oji liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ica noko ewaligitedibece Jesus, odaa ja nadi ica ɡ̶oneleegiwa ane lanikoa me ɡ̶olaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Odaa joɡ̶oige Jesus niɡ̶ijo anodiotibece, moditalo, “Ǥoniiɡ̶axinoɡ̶odi. Igaamee ini ɡ̶oneleegiwa me lanikoa me ɡ̶olaɡ̶a? Mige leeɡ̶odi epaa libeyaceɡ̶eco, oɡ̶oa domige libeyaceɡ̶eco eliododipi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Aleeɡ̶odi libeyaceɡ̶eco, oteɡ̶exaaɡ̶aɡ̶a libeyaceɡ̶eco eliododipi me ɡ̶olaɡ̶a. Pida ɡ̶olaɡ̶a eotibige me yakadi Aneotedoɡ̶oji me ikee mida nimaweneɡ̶egitetece niɡ̶ini ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Leeditibige me jao libakedi Niɡ̶ijoa ane idimonya, malee noko. Igaataɡ̶a nigenoale aɡ̶aleeɡ̶ica ane yakadi me diba. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Codaa maleeɡ̶inaaɡ̶ejotice digoina iiɡ̶o, Ee ane jajigota nilokokena inatawece oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Igaanaɡ̶a nigotedini Jesus meote niɡ̶ijoa lotaɡ̶a, odaa ja yawaletedinigi iiɡ̶o, jeɡ̶eote napaloakawaanigi yatite lawale. Naɡ̶a dibate niɡ̶ijo napaloakawaanigi, odaa ja yocelate ligecooɡ̶e niɡ̶ijo ɡ̶oneleegiwa ɡ̶olaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Odaa jeɡ̶eeteta niɡ̶ijo ɡ̶olaɡ̶a, “Emii, anapiladiti manitaɡ̶a ninyoɡ̶otaɡ̶axi niwilana ane liboonaɡ̶adi Siloé”. (“Siloé” amina anejinaɡ̶ata “Niɡ̶ijo anoniiɡ̶e”). Odaa niɡ̶ijo ɡ̶olaɡ̶a jiɡ̶igo, anapiladiti. Noɡ̶opiticogi liɡ̶eladi, ja yatetibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ijoa lipecaɡ̶awadi niɡ̶ijo ɡ̶olaɡ̶a, codaa niɡ̶ijo anelioditibece monadi me dipokotibece, modi, “Aniɡ̶iniaaɡ̶ini ijo ɡ̶olaɡ̶a ane nicoti, dipokotibece?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Odaa onica anodi, “Joaniɡ̶iniaaɡ̶ini”. Pida ica eledi modi, “Aniɡ̶iniaaɡ̶ini, latopiwa”. Pida ijaaɡ̶ijo niɡ̶ijo ɡ̶oneleegiwa mee, “Jeɡ̶emeɡ̶ee niɡ̶ijo ɡ̶olaɡ̶a, pida ja idici”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Odaa joɡ̶oige, modita, “Ame nimaweneɡ̶egi aneo matenitibece?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naɡ̶a niniɡ̶odi, meetiogi, “Niɡ̶ijoa ɡ̶oneleegiwa ane liboonaɡ̶adi Jesus oneote yatecoɡ̶otee onateciɡ̶ini napaloaɡ̶a, odaa ja yocelate igecooɡ̶e, odaa jeɡ̶eetediwa, ‘Emii manitaɡ̶a niwilana liboonaɡ̶adi Siloé, anapiladiti’. Odaa jeɡ̶ejigo, naɡ̶a inapiladiti, odaa ja jatetibece”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Odaa joɡ̶oigetace, modita, “Igame diɡ̶etedigi icoa ɡ̶oneleegiwa?” Naɡ̶a niniɡ̶odi, meetiogi, “Ajowooɡ̶odi analee diɡ̶etedigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Odaa joɡ̶oyadeegi niɡ̶ijo ɡ̶oneleegiwa ane gela me icí me ɡ̶olaɡ̶a midiwataɡ̶a fariseutedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Odaa joɡ̶oigetece niɡ̶ica ane nimaweneɡ̶egi me yatetibece. Naɡ̶a niniɡ̶odi, meetiogi, “Yocelate napaloaɡ̶a igecooɡ̶e. Naɡ̶a inapiladiti, odaa ja jatetibece”. Niɡ̶ijo noko saabado Jesus meote lategocawaanigi napaloaɡ̶a, naɡ̶a yateneɡ̶etedibece niɡ̶ijo ɡ̶oneleegiwa. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ijo onateciɡ̶ijoa fariseutedi anodi, “Niɡ̶ijoa ɡ̶oneleegiwa aneote niɡ̶ida loenatagi aicoɡ̶otedigi miniwataɡ̶a Aneotedoɡ̶oji, igaataɡ̶a dibatedigi saabado”. Odaa ica eledi modi, “Niɡ̶ijoa ɡ̶oneleegiwa daɡ̶a agopeloagi doɡ̶owidi libeyaceɡ̶eco daɡ̶anagawini ayakadi deɡ̶eote niɡ̶inoa ɡ̶odoxiceɡ̶etedi.” Odaa ja dawalace niɡ̶ijo lapo fariseutedi, leeɡ̶odi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Odaa joɡ̶oigetace niɡ̶ijo ɡ̶oneleegiwa, modita, “Amiida anakatitece ijoa aneote matenitibece?” Naɡ̶a niniɡ̶odi, meetiogi, “Jakadi minaaɡ̶ina niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Niɡ̶ijoa lacilodi judeutedi oyakadi niɡ̶ijo ɡ̶oneleegiwa me daɡ̶a ɡ̶olaɡ̶a niɡ̶ijo jotigide, analee yatetibece natigide. Joaniɡ̶idaa leeɡ̶odi moniditiogi eliododipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Odaa niɡ̶idiwa lacilodi joɡ̶oige eliododipi, moditiogi, “Ini ɡ̶adionigitiwaji? Meni me ɡ̶olaɡ̶a maleekenitini. Odaa igamodaaɡ̶ee ica naɡ̶a yatetibece natigide?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Odaa modi niɡ̶ijo eliododipi, “Ǥodionigi, codaa jowooɡ̶otaɡ̶a me lanikoa me ɡ̶olaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pida ajowooɡ̶otaɡ̶a niɡ̶ica ane nimaweneɡ̶egi naɡ̶a yatetibece niɡ̶ina natigide, codaa ajowooɡ̶otaɡ̶a anigijo ica aneo me yatetibece. Pida aɡ̶alee nigaanigi. Dige ageetiwaji. Iniaaɡ̶ini yakadi me yeloɡ̶odi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Owote niɡ̶ida ligegi niɡ̶ijo eliododipi leeɡ̶odi odoitiogi niɡ̶ijoa lacilodi judeutedi. Igaataɡ̶a niɡ̶ijoa lacilodi jiɡ̶ijo modinotaɡ̶aneɡ̶etigi me daɡ̶adiaa oikatio midiwa niiakanaɡ̶axiidi okanicodaaɡ̶ica oko anee Jesus me niɡ̶ijaaɡ̶ijoa Niɡ̶icoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Joaniɡ̶idaa leeɡ̶odi modi niɡ̶ijo eliododipi, “Aɡ̶alee nigaanigi. Ageetiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Odaa joɡ̶oniditace niɡ̶ijo ane icí me ɡ̶olaɡ̶a, modita, “Oleetibige moɡ̶eetetalo iniokiniwateda Aneotedoɡ̶oji ane ɡ̶adicilatiti. Igaataɡ̶a jowooɡ̶otaɡ̶a niɡ̶ijoa ɡ̶oneleegiwa ane ɡ̶adicilatiti minaaɡ̶ina anowidi libeyaceɡ̶eco”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naɡ̶a niniɡ̶odi, meetiogi, “Ajowooɡ̶odi migowidi libeyaceɡ̶eco. Baɡ̶a jowooɡ̶odi me ee ɡ̶olaɡ̶a niɡ̶ijo jotigide, pida natigide ja jatetibece”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Odaa joɡ̶oigetace, modita, “Amiini ica aneote? Igamodaaɡ̶igotedaɡ̶awa neɡ̶eote matenitibece?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naɡ̶a niniɡ̶odi, meetiogi, “Ja jeloɡ̶oditaɡ̶awatiwaji, pida aɡ̶emaani madadiwaɡ̶ati. Igamawii memaani majipaatace? Migakaami eleditetiwaji emaani me iwitibece?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Odaa joɡ̶oniwotibige modita, “Akapaɡ̶a iwitece. Pida oko, baɡ̶a jiwaɡ̶atece Moisés. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Igaataɡ̶a jowooɡ̶otaɡ̶a Aneotedoɡ̶oji me yotaɡ̶aneɡ̶etedibece Moisés. Pida niɡ̶ijoa ɡ̶oneleegiwa agopeloagi ajowooɡ̶otaɡ̶a niɡ̶ica ane icoɡ̶otedicogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naɡ̶a niniɡ̶odi niɡ̶ijo ɡ̶oneleegiwa, meetiogi, “Eliodi me ɡ̶adopootiwaji! Aɡ̶owooɡ̶otitiwaji ane icoɡ̶otedigi, pida baaneɡ̶eote me jatetibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jowooɡ̶otaɡ̶a Aneotedoɡ̶oji me daɡ̶a wajipatediogi niɡ̶ina anidioka limedi mowo ane beyagi. Pida wajipate niɡ̶ina anoiweniɡ̶ide, codaa anowo ane yemaa. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Niɡ̶ijo maleeka yoeteda Aneotedoɡ̶oji niɡ̶ina iiɡ̶o, aɡ̶ica daɡ̶a jajipaaɡ̶ata doɡ̶odi ijoa yateneɡ̶etedibece oko ane lanikoa me ɡ̶olaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Niɡ̶ijoa ɡ̶oneleegiwa ane idicilatidi daaditaɡ̶a liiɡ̶exegiteda Aneotedoɡ̶oji, daɡ̶anagawini ayakadi deɡ̶eote loenatagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Odaa modita, “Niɡ̶ijo maniitini naɡ̶akaa ɡ̶adoleeni niɡ̶icoa ɡ̶abeyaceɡ̶eco. Enige ja ɡ̶adeedi me ɡ̶odiiɡ̶axineɡ̶egi?” Odaa joɡ̶oyamaɡ̶atijo, joɡ̶onoɡ̶aticogi wetice liiakanaɡ̶axi judeutedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Odaa Jesus ja wajipatedibece moiticoitice niɡ̶ijo ɡ̶oneleegiwa ane icilatidi. Igaanaɡ̶a dakapetetege, odaa ja ige, meeteta, “Ida makaami iwaɡ̶ati Aneotedoɡ̶oji Lionigi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Naɡ̶a niniɡ̶odi, meetalo, “Iniotagodi. Igoataɡ̶a icoa Aneotedoɡ̶oji Lionigi anikeenitediwa amaleeɡ̶aɡ̶a ejiwaɡ̶adi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Odaa jeɡ̶eete Jesus, “Jaɡ̶anati. Jeɡ̶emeɡ̶ee ane ɡ̶adotaɡ̶aneɡ̶eni”. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naɡ̶a igidi, meetalo, “Iniotagodi, ɡ̶adadiwaɡ̶ati”. Odaa ja yamaɡ̶atedini lokotidi lodoe Jesus me doɡ̶etetalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Odaa jeɡ̶eete Jesus, “Janagi niɡ̶ina iiɡ̶o me jiwi anejigota oko, me inoleketicoace ɡ̶oladi, odaa niɡ̶ina anodi me yatetibigiwaji jeɡ̶etoinadi”. (Ǥoladi niɡ̶ina ane doɡ̶oyowooɡ̶odi ane yemaa Aneotedoɡ̶oji.) ");
INSERT INTO kbcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Niɡ̶ijoa fariseutedi anidiaaɡ̶i midoataɡ̶a Jesus owajipatalo niɡ̶ijoa lotaɡ̶a. Odaa joɡ̶oige, moditalo, “Oko domigoko ɡ̶oladi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Daɡ̶akaami ɡ̶oladi, daɡ̶anagawini aɡ̶akaami laagetedipitetiwaji Aneotedoɡ̶oji. Pida menitiwaji matenitibece, codaa mowooɡ̶oti inoatawece. Odaa joaniɡ̶idaa leeɡ̶odi makaami laagetedipitetiwaji Aneotedoɡ̶oji leeɡ̶otedi ɡ̶abeyaceɡ̶eco”. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Eɡ̶idaaɡ̶ee Jesus me dotaɡ̶a, odaa mee, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ina ane dakatiwece liotaanigi waxacocoli, ane daɡ̶a diotiwece epoagi, pida daɡ̶axatio me dakatio, joaniɡ̶iniaa abejeweɡ̶egi, oliceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pida niɡ̶ina ane diotiwece epoagi me dakatio, joaniɡ̶iniaa beɡ̶ewi me nowienoɡ̶odi waxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Odaa niɡ̶ina ane yowie epoagi yomoketege niɡ̶ijo nowienoɡ̶odi waxacocoli me dakatio, codaa niɡ̶idiwa niwaxacocoli joɡ̶oyowooɡ̶oditege lotaɡ̶aneɡ̶egi. Niboonaɡ̶ateetiniwace niwaxacocoli niɡ̶ina meniditege me ixoticogi we liotaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Odaa ja yadeegitedicogi we idiwatawece niwaxacocoli, ijaaɡ̶ijo igo odoe, odaa joɡ̶odilokoteloco niɡ̶ica ane diiticogi, leeɡ̶odi oyowooɡ̶oditege lotaɡ̶aneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aɡ̶odilokoteloco niɡ̶ina ane doɡ̶oyowooɡ̶odi. Pida baɡ̶a daleditibige igaataɡ̶a oilatege eledi oko lotaɡ̶aneɡ̶egi” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus ida ane iciaceeketetege niɡ̶ida latematigo, pida niɡ̶ijo oko aɡ̶oyowooɡ̶odi niɡ̶ica ane diitigilo niɡ̶ijoa lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Odaa jeɡ̶eetace Jesus, “Ejitaɡ̶awatiwaji niɡ̶ina anewi. Iciagi micataɡ̶a niɡ̶ina epoagi anodiotiwece waxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ijotawece niɡ̶ijo anenagitibeci maleediɡ̶icatibige me janagi, niɡ̶ijo abeyaceɡ̶egipi, codaa molicaɡ̶aɡ̶a. Pida niɡ̶inoa waxacocoli aɡ̶owatacotece lotaɡ̶aneɡ̶egi leeɡ̶odi me iomaɡ̶aɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Niɡ̶ida me Ee iciagi epoagi. Niɡ̶ina ane niotiwece meetaɡ̶a, jiɡ̶ida lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji. Yakadi me nakatio, codaa me noditice ane yemaa me diiticogi, codaa yakadi ane yeligo. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Niɡ̶ina oliceɡ̶egi inoka eletema me dolice, daije, codaa me yaaɡ̶adi ane daɡ̶a nebi. Pida Ee baɡ̶a janagi me jao lewiɡ̶a oko ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji codaa jao moyakadi inoatawece anoyopotibige me newiɡ̶a digoina iiɡ̶o, micataɡ̶a niɡ̶ina nowienoɡ̶odi waxacoco me doweditelogo niwaxacocoli, codaa me yediatece inoatawece anoyopotibige. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ee nowienaɡ̶anaɡ̶a anele. Niɡ̶ina nowienaɡ̶anaɡ̶a anele yeleotema niwaxacocoli. (Inatawece anonakato Ǥoniotagodi liciagi niɡ̶inoa waxacocoli.) ");
INSERT INTO kbcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Niɡ̶ina nimeedi, ane daɡ̶a libakedi me nowienaɡ̶anaɡ̶a, codaa ane daɡ̶a nepiliditeda waxacocoli. Niɡ̶ina daɡ̶a naditege diwilecoɡ̶oni, niɡ̶ini yaladi waxacocoli, elodi. Odaa diwilecoɡ̶oni ja dibatalo waxacocoli, codaa ilaagaɡ̶aditiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Niɡ̶ijo nimeedi elodi leeɡ̶odi minoka yowo me dinigaanyetece ninyeelo me diba. Aɡ̶ica meo daɡ̶a ligecaɡ̶aleɡ̶etedi waxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ee nowienoɡ̶odi waxacocoli anele. Digo mijoataɡ̶a Eiodi me idowooɡ̶odi, codaa Ee me jowooɡ̶odi Eiodi, jiɡ̶idaaɡ̶ee maɡ̶aɡ̶a jowooɡ̶odi iniwaxacocoli, nebi aaɡ̶aɡ̶a etidowooɡ̶odi. Icota me ideleotema iniwaxacocoli. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Inoa eletidi waxacocoli ane inepilidi, pida aɡ̶icatibige minataɡ̶a niɡ̶ini lapo judeutedi. Odaa leeditibige maɡ̶aɡ̶a ejigotiogi. Odaa owajipata yotaɡ̶aneɡ̶egi, odaa jiɡ̶ini oniniteci lapo waxacocoli, iniaa oniniteci nowienoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Eiodi idemaa leeɡ̶odi me idinajigo metideloadi, pida idewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aɡ̶ica ane yakadi me ideloadi, nige daɡ̶a idinajigo, pida idinajigo me etideloadi. Ida inimaweneɡ̶egi me idinajigo me ideleo, codaa ida inimaweneɡ̶egi me idinewikatiditaci. Igaataɡ̶a Eiodi idiiɡ̶e mideɡ̶eji.” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Odaa niɡ̶ijoa judeutedi ja dawalacetacicoace leeɡ̶odi niɡ̶ijoa lotaɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Eliodi oko anodi, “Niɡ̶idoa dakatiogilo niwigo abeyaceɡ̶egi, joaniɡ̶idaa me yetole. Igaamee ina majipaatalotiwaji inoa lotaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pida ica eledi oko modi, “Niɡ̶ina oko anodakatiogi adotaɡ̶a daɡ̶a liciagi me dotaɡ̶a. Codaa niwigo abeyaceɡ̶egi ayakadi daɡ̶a icilatidi ɡ̶olaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Icoa nokododi limedi niwetaɡ̶a. Jiɡ̶icota limedi lalokegi judeutedi moyalaɡ̶atibige niɡ̶ijo maleekoka oiwilegitigi Aneotedoɡ̶oji liɡ̶eladi digoida nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus igotedigi ica eledi le Aneotedoɡ̶oji liɡ̶eladi anodita, “Licooɡ̶adi Salomão”. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Odaa niɡ̶ijoa lacilodi judeutedi joɡ̶odilapodetacelogo Jesus, odaa idokee monigetedice, moditalo, “Igaatigi nige aneloɡ̶otitoɡ̶owa ica anakaami? Enitoɡ̶owa nigewi naɡ̶akamaɡ̶akaami niɡ̶icoa Cristo, ane niiɡ̶e Aneotedoɡ̶oji me ɡ̶odatamaɡ̶ateetetege niɡ̶inoa ɡ̶odaxakawepodi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Jiɡ̶ijo mejitaɡ̶awatiwaji ane Ee, pida aɡ̶adadiwaɡ̶ati. Codaa niɡ̶inoa ɡ̶odoxiceɡ̶etedi ane jaote, me jatika naɡ̶atetigi Liboonaɡ̶adi Eiodi ane idimonya, jiɡ̶inaaɡ̶oikee ane Ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pida aɡ̶adadiwaɡ̶atitiwaji niɡ̶ijo mejitaɡ̶awa, leeɡ̶odi aɡ̶akaami iniwaxacocoli, ");
INSERT INTO kbcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Niɡ̶inoa iniwaxacocoli oyowooɡ̶oditege yotaɡ̶aneɡ̶egi. Ee jowooɡ̶oditiogi, codaa oniotibici. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jajigotiogi lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji, codaa aɡ̶alee nigo. Odaa aɡ̶ica ane yakadi me noɡ̶aticoace niɡ̶ina naɡ̶a idei ibaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Eiodi najigotediwa eliodi oko. Eiodi daɡ̶axa meliodi nimaweneɡ̶egi, aɡ̶ica liciagi. Codaa aɡ̶ica ane yakadi me noɡ̶atice aneiteloco Eiodi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ee iniaa Eiodi, ɡ̶odiciagi doɡ̶okinitece oko.” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Igaanaɡ̶a owajipatalo niɡ̶ijoa lotaɡ̶a Jesus, odaa niɡ̶ijoa judeutedi joɡ̶odibatacalo wetiadi me domoɡ̶oyokoletelogo. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pida naɡ̶a notaɡ̶aneɡ̶etediniwace Jesus, meetediogi, “Owidi ane jaote niɡ̶inoa anele ɡ̶adodoetiwaji, niɡ̶inoa ane niiɡ̶etediwa Eiodi me jaote. Amiica ijoa yoenataka aneo me leedi madigidaaticetiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Noɡ̶oniniɡ̶odi, moditalo, “Ajoleeɡ̶atibige me jokolenaɡ̶ataɡ̶aloco wetiɡ̶a daɡ̶a leeɡ̶odi okanicodaaɡ̶ica ɡ̶adoenatagi anele. Pida joleeɡ̶atibige me jokolenaɡ̶ataɡ̶aloco leeɡ̶odi niɡ̶ijoa ɡ̶adotaɡ̶a ane beyagi motaɡ̶anitibige Aneotedoɡ̶oji. Igaataɡ̶a akaami ɡ̶oneleegiwa, pida adiniciaceekenitege Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Midiwataɡ̶a lotaɡ̶a ɡ̶aniiɡ̶axinaɡ̶aneɡ̶eco iwoteloco mee Aneotedoɡ̶oji, ‘Ǥadiciagitiwaji ɡ̶onoenoɡ̶ododi’. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Aneotedoɡ̶oji lotaɡ̶a idioka limedi mewi, codaa Aneotedoɡ̶oji eetediogi me ɡ̶onoenoɡ̶ododi niɡ̶ijo ane yajigotediogi lotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Enige ina meji me Ee Aneotedoɡ̶oji Lionigi, igaamee ina menitiwaji me jotaɡ̶atibige Aneotedoɡ̶oji? Igaataɡ̶a idixipetedice Eiodi, odaa idiiɡ̶etedicogi niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nige daɡ̶a jaote ibaketedi ane niiɡ̶etediwa Eiodi me jaote, odaa aleeditibigetiwaji daɡ̶adadiwaɡ̶ati. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pida daɡ̶a jao libakedi, idokeeta aɡ̶adadiwaɡ̶atitiwaji leeɡ̶odi niɡ̶inoa yotaɡ̶a, enice adadiwaɡ̶atitiwaji leeɡ̶odi niɡ̶inoa ibaketedi ane jaote, amaleeɡ̶aɡ̶a owooɡ̶otitiwaji, codaa aɡ̶ica daɡ̶adinawieni, miniwa Eiodi meetaɡ̶a, codaa Ee ejotelogo Eiodi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Odaa joɡ̶odoletibige moniwilo Jesus leeɡ̶odi modiletibige daɡ̶a dotaɡ̶atedibige Aneotedoɡ̶oji, pida oiwoko. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Niɡ̶idiaaɡ̶idi joɡ̶opitacedicogi daato akiidi Jordão. Odaa jiɡ̶idiaaɡ̶ite digoida anei João Batista me nilegetiniwace oko niɡ̶ijo jotigide. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Eliodi oko igotibeci midoataɡ̶a, igaanaɡ̶a onadi, odaa modi, “João aɡ̶ica deɡ̶eo oteɡ̶exaaɡ̶idatece ɡ̶odoxiceɡ̶edi libinienigi, pida ijoatawece niɡ̶ijoa lotaɡ̶a meetece niɡ̶idoa ɡ̶oneleegiwa, ewi niɡ̶idaaɡ̶ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Odaa eliodi niɡ̶idi oko joɡ̶oyiwaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ica ɡ̶oneleegiwa ane liboonaɡ̶adi Lázaro liɡ̶eladi manitaɡ̶a aca nigotakawaana anodita Betânia. Niwaalepodi, Maria ajaa Marta ane noiigiwepodi. Maria jaɡ̶aniaaɡ̶ani naɡ̶ajo ane yatitalo loɡ̶onaka Ǥoniotagodi ladokojegi, odaa niɡ̶idiaaɡ̶idi, ja yati lamodi me yadilonatidi. Odaa ica noko Lázaro ja deelotika. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Odaa niɡ̶ijo niwaalepodi joɡ̶odajoinaɡ̶atalo Jesus, modi, “Iniotagodi, niɡ̶ijo ɡ̶ademaanigi etidi eliodi me deelotika”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","5","Jesus eliodi me yemaa Marta, ajo nioxoa, ijaa Lázaro. Niɡ̶ijo naɡ̶a dibodicetedigi Lázaro me deelotika, odaa jeɡ̶ee, “Niɡ̶ida neelotagi aɡ̶eo Lázaro diɡ̶idioka limedi me yeleo. Pida niɡ̶ida anee Lázaro onidaaɡ̶ida meo niɡ̶ina oko modoɡ̶etetibigimece Aneotedoɡ̶oji. Jiɡ̶idaa leeɡ̶odi nige odoɡ̶etetiwa, ane Ee Lionigi Aneotedoɡ̶oji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Joaniɡ̶idaa leeɡ̶odi niɡ̶ijo naɡ̶a dibodicetedigi Lázaro me deelotika, odaa edinopaɡ̶aditeda itoataale nokododi midiaaɡ̶ite niɡ̶ijo aneite. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Niɡ̶idiaaɡ̶idi jeɡ̶eetediogi niɡ̶ijo anodiotibece, “Jopilaɡ̶atacicogi Judéia”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Odaa moditalo niɡ̶ijo anodiotibece, “Ǥoniiɡ̶axinoɡ̶odi. Anaɡ̶a leegi niɡ̶ijoa lacilodi judeutedi me domeɡ̶etiɡ̶adigidaatice me domeɡ̶etiɡ̶adeloati. Enige jeɡ̶emaani mopilitacijo!” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Idiwa dooze lakata niɡ̶ina noko mani aligeɡ̶e. Odaa niɡ̶ina oko anewaligitigi noko adixipe, igaataɡ̶a naditece ligi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pida niɡ̶ina anewaligitigi enoale, aiwoko me dixipe, leeɡ̶odi nexocaɡ̶a, codaa aɡ̶aca lokokena mijotaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Joaniɡ̶idaa ligegi Jesus, odaa niɡ̶idiaaɡ̶idi jeɡ̶ee, “Ǥodokaaɡ̶edi Lázaro ja diote, pida ejigo miditaɡ̶a, jojieteloco”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Odaa niɡ̶ijo anodiotibece moditalo, “Ǥoniotagodi, nigokexaa diote, dice icí”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Odiletibige deɡ̶eete Jesus doɡ̶okexaa diote Lázaro. Pida eeteta naɡ̶a yeleo Lázaro, niɡ̶ijo mee diote. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Odaa niɡ̶idiaaɡ̶idi Jesus ja yeloɡ̶oditediogi Lázaro naɡ̶a yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Odaa jeɡ̶eetediogi, “Jakadi mele me daɡ̶a Ee miditaɡ̶a naɡ̶a yeleo leeɡ̶odi akaamitiwaji, amaleeɡ̶aɡ̶a adadiwaɡ̶ati. Natigide iniɡ̶a miditaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Odaa niɡ̶ijo anodita Tomé, ane nikoxeedi me “Owaadi”, joaniɡ̶ijaaɡ̶eetiogi niɡ̶ijo eledi anodiotibece Jesus, “Iniɡ̶a mijoataɡ̶a amaleeɡ̶aɡ̶a ɡ̶odemaɡ̶awa Ǥoniiɡ̶axinoɡ̶odi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Niɡ̶ijo niɡ̶icotedicogi Jesus nipodigi Judéia, pida jeɡ̶eote cwaatolo nokododi midi Lázaro catiwedi lawimaɡ̶ajegi-wetiɡ̶a anonaligite. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Naɡ̶ajo nigotakawaana anodita Betânia idiwa itoatadiɡ̶ida ciloomito me yototice nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Eliodi judeutedi igotibeci odalita Marta, ajaa Maria, igotibeci modalitiogi me ninyaaɡ̶a, leeɡ̶odi me yeleo naaginaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Igaanaɡ̶a dibodice Marta niɡ̶inoa Jesus, odaa jiɡ̶igo dakapetege. Pida Maria baadeɡ̶itibige, niɡ̶ijo aneite me nicoti digoida liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Niɡ̶ijo Marta naɡ̶a dakapetege Jesus, odaa jeɡ̶eetalo, “Iniwa-aagodi. Daɡ̶a-aamitibige mokotaɡ̶a, daɡ̶anagawi-iini inaaginaɡ̶a agotaɡ̶a ye-ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pida jowooɡ̶odi mokanicodaaɡ̶ica ane ipokitalo Aneotedoɡ̶oji, odaa yajigotedaɡ̶awa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Odaa jeɡ̶eeteta Jesus, “Yewiɡ̶atace ɡ̶anaagina”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Odaa Marta jeɡ̶eetalo, “Jowooɡ̶odi me yewiɡ̶atace niɡ̶ica noko nige yewikatiditace Aneotedoɡ̶oji niɡ̶ina oko”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Odaa jeɡ̶ee Jesus, “Ee aneo oko me newiɡ̶atace, odaa jiɡ̶idaa diiticogi, midiokaanaɡ̶a limedi me newiɡ̶a. Niɡ̶ina ane idadiwaɡ̶adi icaaɡ̶ica nige yeleo, pida yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Niɡ̶ina analee yewiɡ̶a, ane idadiwaɡ̶adi, nige yeleo, yewiɡ̶atace. De iwaɡ̶ati ida anejitaɡ̶awa?” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naɡ̶a niniɡ̶odi Marta, meetalo, “Ejiwaɡ̶adi, Iniwa-aagodi. Codaa ɡ̶adadiwaɡ̶ati naɡ̶a-aamaɡ̶a-aami Niɡ̶icoa ane ni-iiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a, niɡ̶icoa Aneotedoɡ̶oji Li-oonigi anenagi niɡ̶ina i-iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Igaanaɡ̶a nigotini Marta me dotaɡ̶a, odaa jiɡ̶igo enidita Maria. Odaa ja ixipetice me yotaɡ̶aneɡ̶e meeta, “Ǥoni-iiɡ̶axinoɡ̶odi jiɡ̶inoa. Codaa najoinaɡ̶atedaɡ̶awa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Igaanaɡ̶a wajipata Maria niɡ̶ijo Marta ligegi, odaa ja dinage me dabiditi, igo dakapetege Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus aneɡ̶enotediwece nigotakawaana, eɡ̶idiaaɡ̶ite digoida anei Marta me dakapetege. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Niɡ̶ijoa judeutedi anidiaaɡ̶i Maria liɡ̶eladi moniɡ̶iwatece, noɡ̶onadi me dabiditi me yediiɡ̶a me noditice, odaa joɡ̶odioteci. Odiletibige Maria diɡ̶igo anoetibece midataɡ̶a lawimaɡ̶ajegi-wetiɡ̶a anonaligite Lázaro. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Igaanaɡ̶a icoticogi Maria aneitedice Jesus, odaa ja dakagitinigi iiɡ̶o midoataɡ̶a loɡ̶onaka. Odaa jeɡ̶eetalo, “Iniwa-aagodi. Daɡ̶a-aamitibige mokotaɡ̶a, daɡ̶anagawi-iini inaaginaɡ̶a agotaɡ̶a ye-ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Igaanaɡ̶a nadi Jesus Maria me dacaagetibece, codaa niɡ̶ijo judeutedi ane lixigaɡ̶awepodi eledi nacaagaɡ̶ateloco, odaa Jesus deemitetetece, codaa agecaɡ̶alo. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Odaa jeɡ̶eetediogi, “Igame analicitetiwaji?” Noɡ̶oniniɡ̶odi, moditalo, “Ǥoniotagodi. Diganagi, awini!” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Odaa Jesus jaɡ̶aɡ̶a anoe. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Odaa modi niɡ̶ijoa judeutedi, “Ica mewi me yemaa ijoolatigi!” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pida ica eledi modi, “Icilatidi niɡ̶ijo ɡ̶olaɡ̶a. Pida agodaɡ̶ayakadi deɡ̶eote anigetiɡ̶ida nimaweneɡ̶egi, odaa ijoolatigi agotaɡ̶a yeleo?” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Odaa Jesus aɡ̶aleeɡ̶ica lita, eliodi me deemitetece. Odaa jiɡ̶igo midataɡ̶a niɡ̶ijo wetiɡ̶a-lawimaɡ̶ajegi anoyatice ijoolatigi. Onani aca wetiɡ̶a nelegi anoyawililetio monibatoo niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Odaa ja diiɡ̶enatakate Jesus, meetediogi, “Anoɡ̶aaticetiwaji naɡ̶ani wetiɡ̶a nelegi”. Odaa Marta, naɡ̶ajo niwaalo ijoolatigi meetalo, “Iniwa-aagodi, ejinaɡ̶a danice. Igaataɡ̶a jeɡ̶eote cwaatolo nokododi midi me ye-ee”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Geneɡ̶ejitaɡ̶awa, nige iwaɡ̶atakani, odaa jaɡ̶anati Aneotedoɡ̶oji meliodi nimaweneɡ̶egi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Odaa joɡ̶onoɡ̶atice naɡ̶ajo wetiɡ̶a nelegi. Naɡ̶a iwitedibigimece Jesus ditibigimedi, odaa jeɡ̶eeteta Aneotedoɡ̶oji, “Eiodi, eliodi me iniotagodetaɡ̶awa leeɡ̶odi manajipaatiwa. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jowooɡ̶odi midioka limedi manajipaatiwa. Pida mejitaɡ̶awa leeɡ̶odi niɡ̶ina noiigi digoina, amaleeɡ̶aɡ̶a eniwaɡ̶atakanaɡ̶a naɡ̶akamaɡ̶akaami anadimonyaa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Igaanaɡ̶a nigotedini Jesus me dotaɡ̶a, odaa ja dapaawe, mee, “Lázaro, anagi, anotitice!” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Odaa Lázaro ja noditice. Pida loɡ̶onaka, libaaɡ̶atedi eɡ̶idaaɡ̶ee me dinilipaditece liwailidi lipegeteɡ̶e, codaa eɡ̶ajo me nadeegitice leenxo anoilipaditece latobi. Odaa jeɡ̶eetediogi Jesus, “Anowilecenitibigetiwaji, odaa ikanitice epaaɡ̶igo”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Eliodi judeutedi anigotibeci odalita Maria noɡ̶onadi Jesus meote Lázaro me yewiɡ̶atace, odaa joɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pida ica eledi joɡ̶opitibeci, odaa jiɡ̶igotibeci oyeloɡ̶oditiogi fariseutedi niɡ̶ijo loenatagi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa fariseutedi ja dinatecoɡ̶otee, modi, “Amiida ica ɡ̶onimaweneɡ̶egi me joxokojoɡ̶o? Igaataɡ̶a niɡ̶ijoa ɡ̶oneleegiwa joɡ̶owidi ɡ̶odoxiceɡ̶etedi aneote. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Daɡ̶a jikanaɡ̶a niɡ̶ida anee, inatawece oko icota moyiwaɡ̶adi. Odaa niɡ̶ijoa lacilodi romaanotedi doidetibige doɡ̶odiiɡ̶enataka moyaaɡ̶adi Aneotedoɡ̶oji liɡ̶eladi, codaa moyaaɡ̶adi ɡ̶odoiigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Onijoteci niɡ̶ijoa lacilodi ane liboonaɡ̶adi Caifás ane eneɡ̶egi ɡ̶oneɡ̶egi, meetiogi, “Aɡ̶ica ɡ̶adixakeditiwaji! ");
INSERT INTO kbcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aɡ̶owooɡ̶otitiwaji me daɡ̶axa meletoɡ̶odomi moniniteci ɡ̶oneleegiwa ane yeleotema ɡ̶odoiigi, odaa inatawece ɡ̶odoiigi aɡ̶alee naaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aɡ̶epaa lowooko Caifás niɡ̶ijoa lotaɡ̶a. Pida Aneotedoɡ̶oji eote meetece niɡ̶ijoa notaɡ̶a ane yeloɡ̶odi micota Jesus me yeleotetema loiigi, igaataɡ̶a Caifás joaniɡ̶iniaa lacilo-sacerdotitedi niɡ̶ijo nicaaɡ̶abi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Niɡ̶ijoa lotaɡ̶a aɡ̶eetalo Jesus daɡ̶a yeleotetema idiokidi noiigi judeu, pida yeleo meote oniniteci lapo inoatawece lionaɡ̶a Aneotedoɡ̶oji ane ilaagiteloco inatawece iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Odaa niɡ̶ijo noko ja diiticogi niɡ̶ijoa lacilodi judeutedi mowo lowoogotece Jesus moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Joaniɡ̶idaa leeɡ̶odi Jesus me daɡ̶adiaaɡ̶awatedigi niɡ̶ijo noiigi digoida Judéia. Pida jiɡ̶igo manitaɡ̶a nigotakawaana anodita Efraim, anipegitege nipodigi ane yadilo ane diɡ̶icata niɡ̶eladimigipi. Odaa jiɡ̶idiaaɡ̶ite ijaaɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja nipegiteloco niɡ̶ijo lalokegi judeutedi anodita me Páscoa. Eliodi oko ane liɡ̶eladi niɡ̶inoa nigotadawaanaɡ̶a, inoa nipodaɡ̶a, ja waxoditibigimoace manitaɡ̶a nigotaɡ̶a Jerusalém. Aneɡ̶eya me nakatio nalokegi niɡ̶igotibeci dinibinie lodoe Aneotedoɡ̶oji, ane najoinaɡ̶aneɡ̶egi noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Odaa joɡ̶odoletibige Jesus, igaanoɡ̶ototicogi Aneotedoɡ̶oji liɡ̶eladi, odaa ja dinige, modi, “Amiida ica anakatitiwaji? Migenagi Jesus niite nalooɡ̶o?” ");
INSERT INTO kbcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Niɡ̶ijo anoiiɡ̶e sacerdotitedi, ijaaɡ̶ijoa fariseutedi domoɡ̶oyemaa moniwilo Jesus. Joaniɡ̶idaa leeɡ̶odi me najoinaɡ̶anaɡ̶a mokanicodaaɡ̶ica ane yowooɡ̶odi aneite Jesus, odaa owo libodigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aniaditibige seis nokododi daɡ̶a nakatio nalokegi Páscoa, niɡ̶igo Jesus mani nigotakawaana Betânia ane liɡ̶eladi Lázaro, niɡ̶ijo ane yewikatiditace Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Odaa joɡ̶oyoe liweenigi Jesus niɡ̶ijo enoale modiniotagodetalo. Marta daxawanataka dedianaɡ̶atece niweenigi. Lázaro eledi ini nameeja miniwataɡ̶a Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Odaa Maria ja dibata aca bootawaana ane nolee ladokojegi, idatawece “nardo”, one dakake loojedi. Odaa ja yadotelogo loɡ̶onaka Jesus, igaanaɡ̶a igodi me yadotelogo, odaa yatita lamodi me iwilegi. Odaa niɡ̶ijo lanigi aneletege niɡ̶ijo ladokojegi jiɡ̶igotigi initawece diimigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pida Judas Iscariotes, niɡ̶ijo lionigi Simão, aninaaɡ̶ina ane-diotibece Jesus, niɡ̶ijo aneyaa Ǥoniotagodi niɡ̶idiaaɡ̶idi miditaɡ̶a neloɡ̶ododipi, mee, ");
INSERT INTO kbcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Naɡ̶ada bootawaana ladokojegi yalitini meyo-liitilo, codaa loojedi iniwatadaɡ̶ani taalia beexotedi. Igaamee doɡ̶oyaa, odaa niɡ̶icoa lojetedi oditoɡ̶onediatiniwace niɡ̶inoda madewetedipi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas eo niɡ̶ida ligegi aleeɡ̶odi daɡ̶a iwikode madewetedipi, pida leeɡ̶odi moliceɡ̶egi. Jeɡ̶epaa dowediteloco dinyeelo, codaa dolicetibigalo dinyeelo. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Odaa jeɡ̶ee Jesus, “Jinaɡ̶alomeɡ̶eni Maria! Igaataɡ̶a yotete niɡ̶ida ladokojegi lajo niɡ̶ica noko nigonaligiti yolaadi mida lawimaɡ̶ajegi-wetiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Niɡ̶inoa madewetedi biɡ̶idioka limedi mina makaamitaɡ̶atiwaji, pida Ee baadiɡ̶idioka limedi minaaɡ̶ejo makaamitaɡ̶atiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eliodi judeutedi, noɡ̶odibodicetigi Jesus miniwatedigi Betânia, odaa jiɡ̶igotibeci odoletibige. Aɡ̶igotibeci diɡ̶ijoka leeɡ̶oditeda Jesus, pida igotibeci maɡ̶aɡ̶a oiwi Lázaro, niɡ̶ijo ane yewikatiditace Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi joɡ̶odinotaɡ̶aneɡ̶etigi moyeloadi Lázaro. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Igaataɡ̶a, leeɡ̶odi Lázaro, eliodi judeutedi aɡ̶aleeɡ̶odeemitetigi niɡ̶ijoa lacilodi, pida jiɡ̶ijapoɡ̶oyiwaɡ̶adi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Naɡ̶a nigoi, niɡ̶ijo noiigi-nelegi ane igotibeci lalokegi Páscoa, joɡ̶odibodicetege Jesus naɡ̶a ipegite nigotaɡ̶a Jerusalém. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Odaa joɡ̶odibatalo laamotiidi “palmeira”, ja noditicoaci migotibeci odakapetege, napaawaɡ̶ateloco, modi, “Joɡ̶eeɡ̶atalo Aneotedoɡ̶oji. Codaa jemaanaɡ̶a Aneotedoɡ̶oji me ibinie Niɡ̶inoa anenagi ane ibake naɡ̶atetigi Liboonaɡ̶adi Ǥoniotagodi Aneotedoɡ̶oji, Niɡ̶inoa ane ninionigi-eliodi ɡ̶odoiigi Israel”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Odaa Jesus ja dakapetetege icoda boliicawaanigi, odaa ja waxoditedeloco. Jotigide naɡ̶akaaɡ̶eeta Aneotedoɡ̶oji lotaɡ̶a niɡ̶ida niciagi, ");
INSERT INTO kbcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jinaɡ̶adoiitiwaji, anakaami niɡ̶eladimigipitigi nigotaɡ̶a Jerusalém. Digawinitege! Ǥaninionigi-eliodi jeɡ̶enagi, waxoditedeloco boliicawaanigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Igaanaɡ̶a onaditege niɡ̶ijo anodiotibece, aɡ̶oyowooɡ̶odi niɡ̶ica anodaa diitigi niɡ̶ida anee Jesus. Pida niɡ̶idiaaɡ̶idi noɡ̶opitedibigimece Jesus ditibigimedi, odaa joɡ̶onalaɡ̶atibige niɡ̶ijoa aneeta Aneotedoɡ̶oji lotaɡ̶a, codaa aaɡ̶aɡ̶a onalaɡ̶atibige niɡ̶ijoa anodigotalo niɡ̶ijo noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Niɡ̶ijo noiigi-nelegi anidiaaɡ̶ite midoataɡ̶a Jesus niɡ̶ijo neɡ̶eniditedibige Lázaro midataɡ̶a lawimaɡ̶ajegi-wetiɡ̶a naɡ̶a yewikatidi, joaneɡ̶epaa oyatematitibece niɡ̶ida niciagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Codaa joaniɡ̶idaa leeɡ̶odi niɡ̶ijo oko naɡ̶a noditicoaci nigotaɡ̶a, migotibeci odakapetege Jesus, leeɡ̶odi modibodicetibige meote niɡ̶ijo ɡ̶odoxiceɡ̶edi nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Odaa niɡ̶ijoa fariseutedi ja dinotaɡ̶aneɡ̶e midiokiditiwage, modi, “Digawini! Aɡ̶ica ica ɡ̶odoenatagi me domaɡ̶a jaoɡ̶a ane beyagitema niɡ̶ida libakedi. Inatawece oko joɡ̶odiotece.” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Liwigotigi niɡ̶ijo oko ane igotibeci nigotaɡ̶a Jerusalém modoɡ̶etetalo Aneotedoɡ̶oji midi nalooɡ̶o, idiwa icoa greegotedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Odaa jiɡ̶igotibeci odakapetege Filipe, anelatibige nigotaɡ̶a Betsaida, nipodigi Galiléia. Odaa joɡ̶odipokota modita, “Ǥoniotagodi, jemaanaɡ̶a me jinataɡ̶a icoa Jesus”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Odaa Filipe jiɡ̶igo eeta André, odaa jiɡ̶igotibeci oditalo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Jiɡ̶icota noko Aneotedoɡ̶oji me idinelecaɡ̶atee, Ee, Ǥoneleegiwa ane jicoɡ̶otibigimece ditibigimedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Atacolitece anejitaɡ̶awatiwaji! Nige doɡ̶oyokoletinigi iiɡ̶o lolagi leyeema, codaa nige doɡ̶oyati naɡ̶ajo lolagi, odaa lolagi idioka limedi mokanitece. Pida naɡ̶ajo lolagi nigonaligitini, odaa ja yajigo eliodi leyeema. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Niɡ̶ina ane daɡ̶axa me yemaa me yewiɡ̶ateloco niɡ̶ina iiɡ̶o, niɡ̶ini baadaɡ̶a yemaa me niotici, codaa icota maniaditema lewiɡ̶a. Pida niɡ̶ina ane daɡ̶a ewianaɡ̶a yecewe me yewiɡ̶ateloco niɡ̶ina iiɡ̶o, baaniɡ̶iniaaɡ̶ini idioka limedi me yewiɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Niɡ̶ina ane yemaa me dibatomi, leeditibige me niotici. Odaa anejote jiɡ̶idiaaɡ̶aɡ̶a ite. Odaa Eiodi iweniɡ̶ide niɡ̶ina ane dibatomi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Eɡ̶idaa diitigi Jesus me notaɡ̶aneɡ̶etediniwace, meetediogi, “Niɡ̶ina natigide ja joɡ̶owikomata. Ajowooɡ̶odi ica anejatigi igegi. Ajakadi daɡ̶a jipokotalo Eiodi deɡ̶eote me idiwoko yawikodigi anicota, leeɡ̶odi jiɡ̶idaa ibakedi me janagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Odaa jeɡ̶ee Jesus, “Eiodi, ikeenitiogi niɡ̶ina oko meliodi ɡ̶animaweneɡ̶egi”. Odaa jiɡ̶ijo nigegi ane icoɡ̶otibigimece ditibigimedi, mee, “Jiɡ̶ijo me jikeetiogi meliodi inimaweneɡ̶egi, codaa ejikeetaciogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Niɡ̶ijo noiigi-nelegi owajipata niɡ̶ijo nigegi. Odaa ijo anodi me niximaɡ̶aɡ̶a. Idiaa eledi modi me aanjo yotaɡ̶aneɡ̶e Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Niɡ̶ijo nigegi aɡ̶ee leeɡ̶odi, pida leeɡ̶odi akaamitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jiɡ̶icota noko Aneotedoɡ̶oji me iwi codaa iloikatidi oko leeɡ̶odi libeyaceɡ̶eco, codaa me iticoitedice diaabo, niɡ̶ijo ane iiɡ̶e oko anida aneetege niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Igaataɡ̶a nigetidawacetibige madataɡ̶a nicenaɡ̶anaɡ̶ate, odaa ja jao moniitiwa eliodi oko inatawece iiɡ̶o, jaotibige mida lewiɡ̶a ane diɡ̶ica liniogo miniwataɡ̶a Aneotedoɡ̶oji.” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus eote niɡ̶ijoa lotaɡ̶a onidaaɡ̶ida me ikee anodaaɡ̶ee me yeleo. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Noɡ̶oniniɡ̶odi niɡ̶ijo noiigi-nelegi, moditalo, “Etiɡ̶odiiɡ̶axitece me iwoteloco notaɡ̶anaɡ̶axi midiwataɡ̶a ɡ̶onajoinaɡ̶aneɡ̶eco, icoa Cristo, ane niiɡ̶e Aneotedoɡ̶oji, midioka limedi miniwa mokotaɡ̶a. Enige igamodaaɡ̶ee ina meni me leeditibige ica Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi monawacetibige mada nicenaɡ̶anaɡ̶ate? Amiijo ica Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Naɡ̶ajo lokokena onateciɡ̶idiwa nokododi minaaɡ̶ite makaamitaɡ̶atiwaji. Awaligitiwaji maleeɡ̶ani lokokena me daɡ̶a nikatiwaɡ̶aji nexocaɡ̶a. Niɡ̶ina anewaligitigi nexocaɡ̶a ayowooɡ̶odi niɡ̶ica ane diiticogi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Niɡ̶ina maleeɡ̶ani lokokena, iwaɡ̶ati lokokena ane Ee, amanagawini akatitiwaji makaami lionigipi Aneotedoɡ̶oji”. Niɡ̶idiaaɡ̶idi naɡ̶a nigotedini Jesus me dotaɡ̶a, odaa joɡ̶opi, ja dinaɡ̶aditetema niɡ̶ijo noiigi-nelegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Idaaɡ̶ee neɡ̶eliodi monadi Jesus meote ɡ̶odoxiceɡ̶etedi, pida idokee aɡ̶oyiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Joaniɡ̶idaa niɡ̶icotece niɡ̶ijoa lotaɡ̶a Isaías, niɡ̶ijo ane yeloɡ̶oditedibece lowooko Aneotedoɡ̶oji, niɡ̶ijo mee, “Iniotagodi Aneotedoɡ̶oji. Aɡ̶ica aneyiwaɡ̶adi ɡ̶odatematiko. Codaa aɡ̶ica anigetiɡ̶ijo anikeenita ɡ̶animaweneɡ̶egi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Codaa aɡ̶oyakadi deɡ̶eniwaɡ̶atakanaɡ̶a, leeɡ̶odi eledi mee Isaías, ");
INSERT INTO kbcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Aneotedoɡ̶oji ja noxoco ligecooɡ̶eli me daɡ̶adiaa yatetibigiwaji, codaa yakakaɡ̶adi laaleɡ̶enali me doɡ̶oyowooɡ̶odi ane diitigilo lotaɡ̶a, codaa me doɡ̶odopitalo me nicilatiditediniwace.” ");
INSERT INTO kbcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mee Isaías niɡ̶ijoa lotaɡ̶a niɡ̶ijo naɡ̶a yowooɡ̶odi Jesus me daɡ̶axa me ɡ̶oneɡ̶egi, odaa ja yalaɡ̶atalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Idaaɡ̶ida meliodi anoyiwaɡ̶adi Jesus niɡ̶ijoa lacilodi judeutedi. Pida aɡ̶ica daɡ̶a dineloɡ̶otee moyiwaɡ̶adi leeɡ̶odi odoitiogi fariseutedi doɡ̶oiticogiticoace wetice niiakanaɡ̶axiidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Domoɡ̶oyemaatibige diɡ̶idioka odeemitetibige niɡ̶ina oko. Odaa agotiɡ̶ica moyocaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Niɡ̶idiaaɡ̶idi Jesus dinigetaɡ̶atee, mee, “Niɡ̶ina ane idadiwaɡ̶adi, aɡ̶emokee me idadiwaɡ̶adi, pida aaɡ̶aɡ̶a eyiwaɡ̶adi Niɡ̶ijoa ane idimonyatedinigi niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Niɡ̶ina ane idadi aaɡ̶aɡ̶a nadi Niɡ̶ijoa ane idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Janagi niɡ̶ina iiɡ̶o me Ee lokokena, jaotibige minatawece anetidadiwaɡ̶adi aɡ̶ideiticoace nexocaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nigica ane wajipatalo yotaɡ̶a, pida aɡ̶eyiwaɡ̶adi, aniɡ̶ica anejigota niɡ̶ina natigide. Igaataɡ̶a anaɡ̶a janagi daɡ̶a jiwi anejigota oko, pida janagi me jao lewiɡ̶a oko. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Niɡ̶ina ane daɡ̶a dibatigi, codaa ane daɡ̶a dibatege yotaɡ̶a, jiɡ̶ini ane iwi anodaaɡ̶igota. Niɡ̶inoa yotaɡ̶a joaniɡ̶inaa anoiwi anodigota nigicota niɡ̶ica owidijegi noko. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Igaataɡ̶a aɡ̶ica deɡ̶emaɡ̶a yolaadi me jotaɡ̶a, pida Eiodi idimonya. Odaa jiɡ̶iniaa idiiɡ̶e meji niɡ̶ina ane leeditibige me igegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jowooɡ̶odi niɡ̶ina liiɡ̶enatakaneɡ̶egi me yajigota oko lewiɡ̶a ane daɡ̶adiaaɡ̶ica liniogo miniwataɡ̶a. Ejitece inokinoateda niɡ̶inoa Eiodi ane niiɡ̶etediwa me jeloɡ̶odi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Naɡ̶a nipegi lalokegi judeutedi anodita me Páscoa. Jesus ja yowooɡ̶odi naɡ̶anipegi me noditedicogi niɡ̶ina iiɡ̶o migo miniwataɡ̶a Eliodi. Idioka limedi me yemaa niɡ̶ijo ane nepilidi, maleeɡ̶inaaɡ̶ite digoina iiɡ̶o, codaa me yemaa neɡ̶epaaɡ̶icota noko me yeleotetema. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Diaabo ja dakatiwece laaleɡ̶ena Judas Iscariotes, niɡ̶ijo lionigi Simão, ixotiwece lowoogo me yajigo Jesus modibatalo neloɡ̶ododi. Jesus yowooɡ̶odi Eliodi me yajigote naɡ̶atetigitedeloco inoatawece. Codaa yowooɡ̶odi me icoɡ̶otedigi miniwataɡ̶a Aneotedoɡ̶oji codaa mopitedibigimece miniwataɡ̶a Aneotedoɡ̶oji. Odaa Jesus ijaaɡ̶ijo anodiotibece naɡ̶a niataɡ̶a me niodaɡ̶a niɡ̶ijo enoale. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Odaa ja dabiditedini Jesus, ja yototedice naɡ̶ajo nameeja, odaa ja noɡ̶a nijayogo. Naɡ̶a dibate aca toaaya, odaa jaɡ̶anigoetedigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Niɡ̶idiaaɡ̶idi ja yadotedinigi ninyoɡ̶odi ica baxia. Odaa ja niwilegitedini loɡ̶onaka niɡ̶ijo anodiotibece, eote ane libakedi niɡ̶ina niotagi. Igaanaɡ̶a igodi me iwilegi, odaa ja yatite naɡ̶ajo toaaya. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Igaanaɡ̶a icote Simão Pedro, odaa jeɡ̶eetalo, “Iniotagodi. Ayakadi daantaɡ̶akamaɡ̶akaami ane iwilegi iɡ̶onaka.” ");
INSERT INTO kbcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Niɡ̶ina natigide aɡ̶owooɡ̶oti ane diitigi niɡ̶ida anejigotaɡ̶awatiwaji. Pida icota mowooɡ̶oti nigidiaaɡ̶idi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Odaa jeɡ̶eetalo Pedro, “Iniotagodi. Ica daɡ̶a jikatedaɡ̶adici me iwileci iɡ̶onaka”. Naɡ̶a niniɡ̶odi Jesus, meeteta, “Nige diɡ̶ikaniteda me jiwilegi ɡ̶adoɡ̶onaka, odaa aɡ̶aleeɡ̶ica anenitigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Odaa jeɡ̶ee Simão Pedro, “Iniotagodi, dice jiniɡ̶idokidoateda iɡ̶onaka me iwileci, pida iwileci ibaaɡ̶atedi, codaa me yacilo!” ");
INSERT INTO kbcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Naɡ̶a igidi Jesus, meeteta, “Niɡ̶ijo baanaɡ̶a igo mánila ja yapidi, odaa idoka leeditibige loɡ̶onaka me iwilegi. Niɡ̶ida makaami ɡ̶adapititiwaji, pida ini oniniteci ane daɡ̶a yapidi niɡ̶ina akaamitiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus yowooɡ̶odi niɡ̶ijo ane yajigo modibatalo neloɡ̶ododi. Joaniɡ̶idaa leeɡ̶odi mee, “Ini oniniteci ane daɡ̶a yapidi niɡ̶ina akaamitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Igaanaɡ̶a igodi Jesus me niwilegitedini loɡ̶onaka niɡ̶ijo anodiotibece, odaa ja dinixotacedinigi nijayogo. Odaa jiɡ̶igotace nicotedini maditaɡ̶a nameeja. Odaa ja nigetediniwace, meetediogi, “Owooɡ̶oti anodaa diitigi ijo anejigotaɡ̶awatiwaji? ");
INSERT INTO kbcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Adadalitigitiwaji me Ee, ‘Ǥaniiɡ̶axinoɡ̶odi’, codaa me Ee, ‘Ǥaniotagodi’. Odaa diitigi anadadalitigitiwaji, igaataɡ̶a jeɡ̶emeɡ̶ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Odaa Ee, ane Ee Ǥaniotagodi, Ǥaniiɡ̶axinoɡ̶odi, ja jiwilegi ɡ̶adoɡ̶onakatiwaji. Joaniɡ̶idaa leeditibige me eni madiniɡ̶iwaatiwagetiwaji miwileci ɡ̶adoɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ja jao ɡ̶awinigi, amaleeɡ̶aɡ̶a idoka enitatiwaji madiniɡ̶iwaatiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Atacolitece anejitaɡ̶awatiwaji! Niɡ̶ina nimeedi anaɡ̶axateloco niotagodi leeɡ̶odi ɡ̶oneɡ̶egi. Codaa niɡ̶ina ane yadeegi nibodigi anaɡ̶axateloco niɡ̶ini ane iiɡ̶e anepaɡ̶a ɡ̶oneɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nigowooɡ̶otitiwaji niɡ̶inoa anejitedaɡ̶awa, codaa nigawiite, odaa eliodi ɡ̶adinikegitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Aɡ̶ejitaɡ̶adici akaamitawecetiwaji. Igaataɡ̶a jowooɡ̶oditibige niɡ̶ijoa iomaɡ̶ataka. Codaa icota niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶a, mee, ‘Niɡ̶ijo ane igiiwatibece me jiniodi, jiɡ̶ijaa analee yakapetegi’. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ejitaɡ̶awatiwaji niɡ̶ina natigide, maleedaɡ̶a icota, amaleeɡ̶aɡ̶a nigicota, odaa jaɡ̶adadiwaɡ̶atitiwaji makaaɡ̶ee, codaa midioka limedi me Ee. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Atacolitecetiwaji niɡ̶ida anejitaɡ̶awa. Ane dibatege niɡ̶ina ane jiiɡ̶e, aaɡ̶aɡ̶a dibatigi. Codaa ane dibatigi, aaɡ̶aɡ̶a dibatege Niɡ̶ijoa ane idimonyatedinigi niɡ̶ina iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Niɡ̶idiaaɡ̶idi naɡ̶a nigotedi niɡ̶ijoa Jesus lotaɡ̶a, odaa ja doɡ̶owikomata, odaa yenikamaɡ̶a meetediogi, “Atacolitecetiwaji anejitaɡ̶awa. Ini niɡ̶ina akaamitiwaji ane idajigo modibatiwa ineloɡ̶ododipi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Odaa niɡ̶ijo anodiotibece ja diniwi, nawelatibigiwaji, aɡ̶oyowooɡ̶odi ane diitigi niɡ̶ijo aneeteta Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Niɡ̶ijo ane lemaanigi Jesus ini me ipegitetege, dawaketelogo. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Odaa Simão Pedro ja yotaɡ̶aneɡ̶e yatita libaaɡ̶adi, dipokota me igetece Jesus ganigepitiɡ̶ijo ica aneeteta me yajigo midi neloɡ̶ododipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Odaa niɡ̶ijo ane-diotibece lemaanigi ja dawaketeloco elipije Jesus, odaa ja ige, oxati meetalo, “Iniotagodi. Amiijo ica anenita?” ");
INSERT INTO kbcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Niɡ̶ini ane jajigota paon liwai ane itimi, joaniɡ̶iniaa idajigo.” Odaa Jesus ja dibate paon liwai, naɡ̶a ititedinigi ica niweenigi liwagedi, odaa ja yajigote Judas, lionigi Simão Iscariotes. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Igaanaɡ̶a dibatege Judas niɡ̶ijo paon, odaa Satanás ja dakatiwece laaleɡ̶ena. Odaa Jesus jeɡ̶eeteta Judas, “Nigica anigida ane eni me ɡ̶adoenatagi, adinageni mawii”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Niɡ̶ijo anidiaaɡ̶i maditaɡ̶a nameeja, aɡ̶ica ane yowooɡ̶odi ane leeɡ̶odi Jesus meote niɡ̶ijo ligegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas jiɡ̶ijaa doweditelogo dinyeelo. Joaniɡ̶idaa modiletibige daɡ̶a iiɡ̶e Jesus migo dinoojetetigi anigetiɡ̶ica anoyopotibige me nalooɡ̶o, migetaɡ̶a nediatiniwace madewetedi beexotedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Naɡ̶a dibatege Judas niɡ̶ijo paon liwai, odaa ja dinagetice me noditice. Pida jeɡ̶enoale. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Niɡ̶ijo naɡ̶a noditice Judas, odaa jeɡ̶ee Jesus, “Niɡ̶ina natigide joɡ̶onelecaɡ̶atee Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi, ane Ee, codaa odoɡ̶etetalo Aneotedoɡ̶oji Ee leeɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nigodoɡ̶etetalo Aneotedoɡ̶oji Ee leeɡ̶odi, odaa iniaaɡ̶iniwa Aneotedoɡ̶oji nelecaɡ̶atee Ǥoneleegiwa ane icoɡ̶otibigimece ditibigimedi, ane Ee. Aneotedoɡ̶oji eote niɡ̶ida aneete natigidawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ionigipi. Aɡ̶alee leegi minaaɡ̶ejo makaamitaɡ̶a. Icota moleetibigijitiwaji. Pida ejitaɡ̶awatiwaji natigide niɡ̶ijo ane igegitiogi niɡ̶ijoa lacilodi ɡ̶odoiigi judeutedi me daɡ̶akatitatiwaji memii ane jiiticogi. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Natigide jajigotaɡ̶awatiwaji gela ɡ̶aniiɡ̶enatakaneɡ̶egi, madinemaanitiwagetiwaji. Digo aneji me ɡ̶ademaanitiwaji, ɡ̶adiiɡ̶eni maɡ̶aɡ̶a adinemaanitiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nigadinemaanitiwage, inatawece oko oyowooɡ̶odi makaami niɡ̶ina anoniotici”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Odaa Simão Pedro ja ige Jesus, meetalo, “Iniotagodi. Igame aaticogi?” Naɡ̶a niniɡ̶odi Jesus, meeteta, “Niɡ̶ina natigide, aɡ̶akati deɡ̶emii ane jiiticogi. Pida nigidiaaɡ̶idi icota memii”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naɡ̶a igetace Pedro, meetalo, “Iniotagodi. Igaamee ica daɡ̶a jakadi mejigo jiotaɡ̶adici ina natigide? Ja idigo me ideleotaɡ̶adomi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Naɡ̶a igidi Jesus, meeteta, “Migewi naɡ̶a ɡ̶adigomi me ɡ̶adelewitomi? Jemaa mejitaɡ̶awa anewi. Aniɡ̶icatibige daɡ̶a dinici okoɡ̶okoodi manoe, odaa itoatadiɡ̶ida meni me daɡ̶adowooɡ̶oti”. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Odaa jeɡ̶eetediogi Jesus, “Jinaɡ̶akaami agecaɡ̶alodipi, codaa jinaɡ̶a aɡ̶owikomataatiwaji. Pida anakatoni Aneotedoɡ̶oji. Ee eledi adinakatoni. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Igaataɡ̶a digoida liɡ̶eladi Eiodi idiwa owidi diimaɡ̶a. Daɡ̶aleetiɡ̶idaaɡ̶ee daɡ̶anagawini akaaɡ̶ejitaɡ̶awatiwaji. Odaa ejigo jilakidetaɡ̶adomitiwaji ane onite. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Igaanige ejigo jilakidetini ane onitetiwaji. Odaa nige jigodi, odaa ja idopitacijo me ɡ̶adadeegitiwaji, amaleeɡ̶aɡ̶a anejote, jiɡ̶idiaaɡ̶aɡ̶a onitetiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Joɡ̶owooɡ̶otitiwaji ane jiiticogi, codaa joɡ̶owooɡ̶oti naigi ane ɡ̶adadeegiticogi digoida ane jiiticogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Odaa jeɡ̶eetalo Tomé, “Iniotagodi, ajowooɡ̶otaɡ̶a ica ane aaticogi. Codaa, igamaleeɡ̶aɡ̶a ɡ̶onimaweneɡ̶egi me jowooɡ̶otaɡ̶a ica naigi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Ee jeɡ̶emeɡ̶ee naigi ane ɡ̶adadeegitalo Aneotedoɡ̶oji, Ee anewi aneetece Aneotedoɡ̶oji, codaa jeɡ̶emaɡ̶a jao lewiɡ̶a oko. Aɡ̶ica ane yakadi micotalo Eiodi, nige daɡ̶a Ee jadeegitalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nigadowooɡ̶otitiwaji, odaa Eiodi aaɡ̶aɡ̶a owooɡ̶oti. Odaa niɡ̶ina natigide joɡ̶owooɡ̶oti codaa jaɡ̶anati Eiodi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Odaa Filipe jeɡ̶eetalo Jesus, “Ǥoniotagodi, enice anikeenitedoɡ̶owa icoa Ǥadiodi. Odaa joɡ̶okomoda ele”. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Filipe. Ja jotigide me Ee makaamitaɡ̶atiwaji. Anaɡ̶adowooɡ̶oti? Niɡ̶ina ane idadi, odaa nadi Eiodi. Enice, igaamee ina menitiwa, ‘Anikeenitedoɡ̶owa icoa Ǥadiodi’? ");
INSERT INTO kbcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aɡ̶iwaɡ̶atakani mejotelogo Eiodi, codaa Eiodi miniwa meetaɡ̶a?” Odaa jeɡ̶eetediogi Jesus niɡ̶ijo anodiotibece, “Niɡ̶inoa anejitedaɡ̶awatiwaji, aɡ̶ejitece emeɡ̶ee. Pida Eiodi aniniwa meetaɡ̶a, joaneɡ̶epaaɡ̶eote libaketedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Leeditibige me iwaɡ̶atitiwaji me idejo miniwataɡ̶a Eiodi, codaa Eiodi miniwa meetaɡ̶a. Nige daɡ̶a iwaɡ̶atakanitatiwaji leeɡ̶odi niɡ̶inoa yotaɡ̶a, enice iwaɡ̶atakani leeɡ̶odi niɡ̶ijoa ɡ̶odoxiceɡ̶etedi ane jaote. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Natigide atacolitecetiwaji niɡ̶ida igegi. Niɡ̶ina ane idadiwaɡ̶adi icota meote niɡ̶inoa ane jaote, codaa icota meote loenataka ane daɡ̶axa me eloodoli, igaataɡ̶a ja jopitalo Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Odaa jao okanicodaaɡ̶ica ananipokitiwatiwaji niɡ̶ina mabakeni Iboonaɡ̶adi, amaleeɡ̶aɡ̶a ane Ee, Lionigi Aneotedoɡ̶oji, inelecaɡ̶atidi Liboonaɡ̶adi Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Niganipokitiwa mabakeni naɡ̶atetigi Iboonaɡ̶adi okanicodaaɡ̶ica, odaa jajigotaɡ̶awatiwaji ane ɡ̶adipoketegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nigademaanitiwaji, enice iwaɡ̶ati niɡ̶inoa iiɡ̶enatakaneɡ̶eco. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jipokotalo Eiodi me yajigotedaɡ̶awa eledi Ǥanaxawanatitoɡ̶odi, anidioka limedi mini makaamitaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Joaniɡ̶iniaa Niwigo ane ikee anewi niɡ̶ina moyalaɡ̶atiwa. Niɡ̶ina okotigi digoina iiɡ̶o ayakadi doɡ̶odibatege, igaataɡ̶a aɡ̶oyakadi doɡ̶onadi, oteɡ̶exaaɡ̶aɡ̶a oyowooɡ̶odi. Pida akaamitiwaji boɡ̶owooɡ̶oti igaataɡ̶a ini makaamitaɡ̶a, codaa icota me diɡ̶eladetiwaɡ̶aji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aɡ̶adalatitiwaji doɡ̶odaa micataɡ̶a daɡ̶akaami exiijigipi. Pida idopitacaɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aɡ̶alee leegi nige ideleo, odaa niɡ̶ina okotigi digoina iiɡ̶o aɡ̶aleeɡ̶etidadi. Pida aɡ̶ica daɡ̶a leegi akaamitiwaji baɡ̶adati. Leeɡ̶odi nige idewiɡ̶atace, odaa jaɡ̶aɡ̶a ɡ̶adewikitace. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nigicota noko nige idewiɡ̶atace, odaa joɡ̶owooɡ̶otitiwaji me emoka Ee me idexogotege Eiodi, codaa akamokakaamitatiwaji me ɡ̶adexocitigi, codaa me emoka Eeta me idexogotaɡ̶agitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Niɡ̶ina ane dibatege codaa meyiwaɡ̶adi iiɡ̶enatakaneɡ̶eco, joaniɡ̶iniaa idemaa. Odaa Eiodi aaɡ̶aɡ̶a yemaa niɡ̶ina ane idemaa. Codaa Ee aaɡ̶aɡ̶a jemaa, codaa me idinikeeta ane Ee.” ");
INSERT INTO kbcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Odaa Judas, aɡ̶ijiɡ̶ijo Judas Iscariotes, pida eledi Judas, ige Jesus, meetalo, “Ǥoniotagodi, igamodaaɡ̶eeta ica madinikeenitoɡ̶owa, nige daɡ̶adinikeenitiogi ina eledi oko digoina iiɡ̶o?” ");
INSERT INTO kbcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Niɡ̶ina ane idemaa eyiwaɡ̶adi niɡ̶inoa yotaɡ̶a, codaa Eiodi yemaa niɡ̶ina ane idemaa. Ee iniaa Eiodi janagaɡ̶a me ɡ̶onoiigiwa. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Niɡ̶ina ane daɡ̶a idemaa, aɡ̶eyiwaɡ̶adi yotaɡ̶a. Codaa niɡ̶inoa notaɡ̶a anajipaatalotiwaji, aɡ̶emaɡ̶a yotaɡ̶a, pida lotaɡ̶a Eiodi ane idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ejitedaɡ̶awatiwaji niɡ̶inoa yotaɡ̶a maleeɡ̶eetibige makaamitaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pida Niɡ̶ina Ǥanaxawanatitoɡ̶odi, Aneotedoɡ̶oji Liwigo, ane niwakatee Eiodi leeɡ̶odi Iboonaɡ̶adi, ɡ̶adiiɡ̶axinitecetiwaji inoatawece, codaa eo manalakitibige ijoatawece niɡ̶ijoa anejitedaɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jaote mele ɡ̶adaaleɡ̶enalitiwaji. Joaniɡ̶idaa ane jaotaɡ̶adomi. Aneji me jaotaɡ̶adomitiwaji aliciagi anee niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o. Odaa jinaɡ̶akaami agecaɡ̶alodipi, jinaɡ̶aɡ̶owikomataa, codaa jinaɡ̶adoiitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jaɡ̶ajipaatatiwaji niɡ̶ijo mejitaɡ̶awa mejigo, pida idopitaɡ̶awatiwaji. Niɡ̶ina nigademaanitiwaji enice aniniitibeci leeɡ̶odi mejitaɡ̶awa me jopitalo Eiodi. Eiodi daɡ̶axa meliodi nimaweneɡ̶egi, aiciagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ejitedaɡ̶awa niɡ̶inoa yotaɡ̶a, maleedaɡ̶a icotalo niɡ̶inoa anejitece, amaleeɡ̶aɡ̶a adadiwaɡ̶atitiwaji nige limedi me icotece niɡ̶inoa anejitedaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aleegi me ɡ̶adotaɡ̶aneɡ̶enitiwaji, igaataɡ̶a niɡ̶ijo ane iiɡ̶e oko digoina iiɡ̶o jiɡ̶ina menagi. Enagi me dakapetigi, pida aɡ̶ica nimaweneɡ̶egitici. ");
INSERT INTO kbcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pida amaleeɡ̶aɡ̶a oyowooɡ̶odi niɡ̶ina oko digoina iiɡ̶o me jemaa Eiodi, odaa jaote inoatawece ane niiɡ̶etediwa. Xebatiwaji, adabititiniwace, jopilaɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Odaa jeɡ̶ee Jesus, “Ee idiniciaceeketege niɡ̶ina libatadi ‘uuva’. Odaa Eiodi baɡ̶a liciagi nawodaɡ̶anaɡ̶a jeɡ̶epaa doweditedeloco elanigije ‘uuva’. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nakagidi inoatawece libiwedi ane deɡ̶etayeteda. Ibinie inoatawece libiwedi anepaɡ̶a etaye, eotedibige mepaanaɡ̶a dáwe. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Niɡ̶ida makaamitiwaji ja ɡ̶adapiti leeɡ̶odi me iwaɡ̶ati niɡ̶inoa yotaɡ̶a anejitedaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ele midioka limeditiwaji me ɡ̶adexocitigi, odaa Ee idiokaanaɡ̶a limedi me idexogotaɡ̶agitiwaji. Naɡ̶ana libiwe idoka etaye nigalee yexogotege naɡ̶ada libatadi ‘uuva’. Jiɡ̶idaaɡ̶enitiwaji, idoka akati me áwe nige ɡ̶adexocitigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ee libatadi ‘uuva’. Odaa akaamitiwaji libiwedi. Niɡ̶ina anidioka limedi me yexogotigi, Ee aaɡ̶aɡ̶a idexogotege, codaa joaniɡ̶iniaa ane dáwe. Igaataɡ̶a nige daɡ̶a ɡ̶adexocitigitiwaji, odaa aɡ̶ica anakati mawii. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Niɡ̶ina ane daɡ̶a yexogotigi, joaniɡ̶iniaa oyaladiticogi we, yadilo micoataɡ̶a niɡ̶inoa niale libiwedi anoiladie, odaa joɡ̶oyokoletiogi noledi moyalegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nigidioka limedi me ɡ̶adexocitigitiwaji, codaa nigidioka limedi mowoo yotaɡ̶a, anipokitiwa niɡ̶ica anemaani, odaa jaotaɡ̶adomitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Odoɡ̶etetalo Eiodi, niɡ̶ina nige áwetiwaji. Odaa jaɡ̶akaami niɡ̶ina anoniotici. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ja ɡ̶ademaanitiwaji digo anigotediwa Eiodi me idemaa. Idoka enitatiwaji midioka limedi me ɡ̶adexocitigi amaleeɡ̶aɡ̶a jikee me ɡ̶ademaanitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Niɡ̶ina nigoteteni iiɡ̶enatakaneɡ̶eco, odaa idioka limedi me jikee me ɡ̶ademaanitiwaji, digo aneji me jotete liiɡ̶enatakaneɡ̶eco Eiodi, odaa idioka limedi me idemaa. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jeɡ̶ejitedaɡ̶awatiwaji niɡ̶inoa yotaɡ̶a amaleeɡ̶aɡ̶a itiwaɡ̶aji inikegi, odaa eliodi ɡ̶adinikegitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Joaniɡ̶idaa iiɡ̶enatakaneɡ̶egi, madinemaanitiwagetiwaji, digo anejigotaɡ̶awa me ɡ̶ademaani. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aɡ̶ica ane daɡ̶axa me yemaa lokaaɡ̶etedipi, daɡ̶a liciagi niɡ̶ina ane yeleotema lokaaɡ̶etedipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Akaami yokaaɡ̶etedipi nigawii niɡ̶ina ane jiiɡ̶etaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aɡ̶ejitaɡ̶awa makaami iotagipi, igaataɡ̶a niɡ̶ina niotagi ayowooɡ̶odi niɡ̶ica aneo niɡ̶ini niotagodi. Pida ejitaɡ̶awatiwaji makaami yokaaɡ̶etedipi leeɡ̶odi jeɡ̶ejitedaɡ̶awatiwaji ijoatawece aneetediwa Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Anaɡ̶akamaɡ̶a adiolaaticetiwaji, pida Ee ɡ̶adiolaatice, odaa ja ɡ̶adiomaɡ̶atiticoace jaotibige memii, codaa me áwe, odaa niɡ̶inoa ɡ̶atá abeyagi. Joaniɡ̶idaaɡ̶ee, Eiodi yajigotedaɡ̶awatiwaji inoatawece ane ipokitibige, niɡ̶ina me abakeni Iboonaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Joaniɡ̶idaa me ɡ̶adiiɡ̶enitiwaji madinemaanitiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nigakaami neleɡ̶etedipi niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o, analakitibigetiwaji me Ee odoejegi me Ee neleɡ̶edi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Igaataɡ̶a diɡ̶ida anenitegetiwaji niɡ̶ina iiɡ̶o, daɡ̶anagawini niɡ̶ina oko etiɡ̶ademaani, igaataɡ̶a inoka oyemaa niɡ̶ina ane nebi, anida aneetege niɡ̶ina iiɡ̶o. Pida ja ɡ̶adiomaɡ̶atiticoace liwigotigi niɡ̶ina oko, ɡ̶adixipeniticoace, odaa aɡ̶aleeɡ̶ica anenitege. Joaniɡ̶idaa leeɡ̶odi makaami neleɡ̶etedipi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Analakitibige niɡ̶ijo mejitaɡ̶awatiwaji, niɡ̶ina nimeedi anaɡ̶axateloco niotagodi. Odaa niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o nigetidiatetibeci, odaa akaami aaɡ̶aɡ̶a etiɡ̶adiatenitibece. Doɡ̶oyotete yotaɡ̶a, odaa taɡ̶aɡ̶a oyotete ɡ̶adotaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pida leeɡ̶odi mida anenitigi jiɡ̶idaa midoɡ̶odigotaɡ̶awatiwaji, igaataɡ̶a aɡ̶oyowooɡ̶odi Niɡ̶ijoa ane idimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Niɡ̶ina daaditaɡ̶a janagi, jeloɡ̶oditiogi, agotiɡ̶ica libeyaceɡ̶egi ane yeloɡ̶o. Pida niɡ̶ina natigide aɡ̶aleeɡ̶ica oko ane yakadi me yaɡ̶aditini libeyaceɡ̶egi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Niɡ̶ina ane Ee leleɡ̶edi, aaɡ̶aɡ̶a leleɡ̶edi Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Niɡ̶ina daaditiɡ̶icoateda ɡ̶odoxiceɡ̶etedi ane jaote lodoe, ane diɡ̶ica ane yakadi meo liciagi, odaa niɡ̶inoa loenataka ane beyagi agotaɡ̶a yeloɡ̶o. Pida noɡ̶onadi ɡ̶odoxiceɡ̶etedi ane jaote, odaa joɡ̶oyelatomi, codaa Eiodi moyelatema. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pida mina jiɡ̶idaaɡ̶ee, icota niɡ̶ijo ane diniditeloco notaɡ̶anaɡ̶axi midiwataɡ̶a niiɡ̶enatakaneɡ̶eco, niɡ̶ijo anee, ‘Aɡ̶ica ane leeɡ̶odi moyelatomi’. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Niɡ̶ijo Ǥanaxawanatitoɡ̶odi, Aneotedoɡ̶oji Liwigo, icota meno, odaa beɡ̶ewi me ikeetaɡ̶awa anodaaɡ̶eji niɡ̶ina moyalaɡ̶atiwa, icoɡ̶otibigimece miniwataɡ̶a Eiodi. Jinimonyataɡ̶awatiwaji, icoɡ̶otibigimece Eiodi. Odaa nigeno, jeɡ̶eetece anodaaɡ̶eji. ");
INSERT INTO kbcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Odaa akaamitiwaji jaɡ̶aɡ̶a enitece anodaaɡ̶eji, leeɡ̶odi makaamitiwaji meetaɡ̶a, niɡ̶ijo maleekoka ɡ̶adiomaɡ̶atiticoace, codaa niɡ̶ina natigide. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ejitedaɡ̶awatiwaji niɡ̶inoa yotaɡ̶a jaotibige me daɡ̶a amiɡ̶iticoace. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Etiɡ̶aditicoiticoace wetice niiakanaɡ̶axiidi. Codaa icota noko, niɡ̶ina anetiɡ̶adeloati odiletibige doɡ̶owo libakedi Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Odaa jiɡ̶idaaɡ̶odigotaɡ̶awatiwaji leeɡ̶odi aɡ̶oyowooɡ̶odi Eiodi, codaa Ee aɡ̶etidowooɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pida ejitedaɡ̶awatiwaji niɡ̶inoa yotaɡ̶a amaleeɡ̶aɡ̶a nige icotece, odaa jaɡ̶analakitibigetiwaji mijo me jao ɡ̶adeemidi. Niɡ̶ijo maleekoka idinojocaɡ̶atini me jibaaɡ̶a aɡ̶ica deɡ̶ejitedaɡ̶awa niɡ̶inoa yotaɡ̶a, leeɡ̶odi maleeɡ̶eetibige makaamitaɡ̶atiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pida niɡ̶ina natigide ja jopitalo ane idimonya. Pida aɡ̶ica niɡ̶ina akaamitiwaji ane idigetece ica ane leeɡ̶odi mejigo. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pida jaɡ̶akaami agecaɡ̶alodipi leeɡ̶odi me jao ɡ̶adeemidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ejitaɡ̶awatiwaji anewi. Daɡ̶axa mele mejigo, igaataɡ̶a daaditaɡ̶a ejigo, odaa Ǥanaxawanatitoɡ̶oditiwaji aɡ̶enagi. Pida nigejigo odaa ja jinimonyataɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Niɡ̶ina nigenagi, odaa ja ikeetiogi niɡ̶ina oko anodaaɡ̶ee nibeyaceɡ̶eco, codaa ane iɡ̶enaɡ̶a, codaa Aneotedoɡ̶oji me laagetedipi niɡ̶ina oko leeɡ̶otedi loenataka ane beyagi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Codaa ikeetiogi niɡ̶ina oko minoa libeyaceɡ̶eco, leeɡ̶odi me deɡ̶etidadiwaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Eledi ikeetiogi ane iɡ̶enaɡ̶a, leeɡ̶odi jeɡ̶ejigo miniwataɡ̶a Eiodi, odaa aɡ̶aleeɡ̶ee madatitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Codaa aaɡ̶aɡ̶a ikeetiogi Aneotedoɡ̶oji me laagetedipi niɡ̶ina oko leeɡ̶otedi libeyaceɡ̶eco, leeɡ̶odi ja laagedi niɡ̶ijo ane iiɡ̶e oko digoina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Eɡ̶inoa owidi ane domeɡ̶ejitedaɡ̶awatiwaji, pida aɡ̶abootegetiwaji daɡ̶ajipaatalo eletidi yotaɡ̶a niɡ̶ina natigide. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pida nigenagi Aneotedoɡ̶oji Liwigo, ane ikee anewi me yalaɡ̶atiwa, ikeetedaɡ̶awatiwaji inoatawece niɡ̶inoa anepeɡ̶ewi. Adotaɡ̶a deɡ̶epaa lolaadi, pida eetece niɡ̶ica anaɡ̶aɡ̶a lajipakegi. Yatematitedaɡ̶awatiwaji niɡ̶inoa ane icota manati. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eo modoɡ̶etetiwa niɡ̶ina oko, leeɡ̶odi yeloɡ̶oditaɡ̶awatiwaji niɡ̶ina ane jajigota, ane jemaa me igegitaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inoatawece ane nepilidi Eiodi, aaɡ̶aɡ̶a inepilidi. Joaniɡ̶idaa meji, Liwigo Aneotedoɡ̶oji dibatege niɡ̶inoa yotaɡ̶a ane jajigota, odaa jaɡ̶aɡ̶a yeloɡ̶oditedaɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Natigidawaanigi aɡ̶aleeɡ̶ee madatitiwaji. Pida nigidiaaɡ̶idi icotace madati. Igaataɡ̶a jeɡ̶ejigo miniwataɡ̶a Eiodi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Odaa onica niɡ̶ijo anodiotibece ane dinotaɡ̶aneɡ̶e midiokiditiwage, modi, “Amiida ica ane diitigi ijo ligegi meetedoɡ̶owa me natigidawaanigi odaa aɡ̶aleeɡ̶icoa me jinataɡ̶a, odaa aleegi ja jinataɡ̶atace, eleditace niɡ̶ina meetedoɡ̶owa me leeɡ̶odi niɡ̶igo miniwataɡ̶a Eliodi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Odaa ja dinotaɡ̶aneɡ̶etace idiokiditiwage, modi, “Igame diitigi ica ligegi ijo mee, ‘Nigidiaaɡ̶idi’? Ajowooɡ̶otaɡ̶a aneyatedigi ica ligegi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus yowooɡ̶odi modoletibige moige, odaa jeɡ̶eetediogi, “Jeɡ̶ejitaɡ̶awatiwaji natigidawaanigi aɡ̶aleeɡ̶ee madati, pida nigidiaaɡ̶idi icotace madati. Jowooɡ̶odi me domaɡ̶a agikanitecetiwaji niɡ̶ica anodaa diitigi niɡ̶ida igegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ejitaɡ̶awatiwaji niɡ̶ina anewi. Niɡ̶ida makaami icota manoenitiwaji, codaa makaami agecaɡ̶alodipi, pida iniɡ̶ina niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o baɡ̶a ninitibigiwaji. Akaami agecaɡ̶alodipi, pida nigidiaaɡ̶idi aniniitibecitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ǥadiciagitiwaji macataɡ̶a naɡ̶ana iwaalo naɡ̶a nipegi me dinigaje, odaa jaɡ̶agecaɡ̶alo, igaataɡ̶a jiɡ̶icota noko lawikodigi. Pida nige dinigaje, odaa aɡ̶alee nalaɡ̶atibige niɡ̶ijo lawikodigi. Pida ja ninitibece leeɡ̶odi naɡ̶a dinigajetece nigaanigawaanigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jiɡ̶idaaɡ̶enitiwaji makaami agecaɡ̶alodipi. Pida nigidiaaɡ̶idi nigadatitacitiwaji, odaa jaɡ̶aniniitibeci. Codaa aɡ̶aleeɡ̶ica ane yakadi daɡ̶a noɡ̶atice ɡ̶adinikegitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nigicota niɡ̶ica noko me jopiticogi miniwataɡ̶a Eiodi, odaa aɡ̶alee leeditibige madigee. Ewi niɡ̶ida anejitaɡ̶awatiwaji. Nigabakeni Iboonaɡ̶adi mipokita okanicodaaɡ̶icata anemaani, odaa jiɡ̶idiaa yajigotedaɡ̶awa Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Codaa natigide aniɡ̶ica daɡ̶a atikani Iboonaɡ̶adi me ipokitalo Eiodi. Ipokitalotiwaji Eiodi, odaa jaɡ̶abaatege ane ɡ̶adipoketegi, eotedibige meliodi maniniitibecitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Niɡ̶ijo me ɡ̶adiiɡ̶axinitiniwace, jibake natematiko, anida ane jiciaceeketege. Pida icota noko nige daɡ̶adiaa jao ane jiciaceeketege niɡ̶ina me ɡ̶adiiɡ̶axinitiwaji, pida iɡ̶enaɡ̶a mejitece Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Niɡ̶ica noko atikanitiwaji Iboonaɡ̶adi me ipokitalo Eiodi. Pida ejitaɡ̶awa aɡ̶alee leeditibige daɡ̶a jipokotaɡ̶alocotiwaji miniwataɡ̶a Eiodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Igaataɡ̶a Iniaaɡ̶iniwa ɡ̶ademaanitetiwaji. Odaa ɡ̶ademaanitetiwaji leeɡ̶odi mademaani, codaa jaɡ̶adadiwaɡ̶ati me jicoɡ̶oticogi miniwataɡ̶a Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jaladi Eiodi, odaa ja janagi niɡ̶ina iiɡ̶o. Odaa natigide jaladi niɡ̶ina iiɡ̶o, jopitalo Eiodi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Odaa moditalo niɡ̶ijo anodiotibece, “Niɡ̶ina natigide ja yeloɡ̶otece ɡ̶adotaɡ̶a, ataleeɡ̶awii ane iciaceekenitege aneo me daɡ̶a jowooɡ̶otaɡ̶atece. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Niɡ̶ina natigide ja jowooɡ̶otaɡ̶a mowooɡ̶oti inoatawece, codaa aɡ̶alee leeditibige diɡ̶ica ane ɡ̶adigee. Joaniɡ̶idaa me ɡ̶adadiwaɡ̶ateɡ̶egi me icoɡ̶iticogi miniwataɡ̶a Aneotedoɡ̶oji (Leeɡ̶odi owooɡ̶oti codaa me ɡ̶odowooko)”. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Naɡ̶a niniɡ̶odi Jesus, meetediogi, “Jawienataka naɡ̶a adadiwaɡ̶atitiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Igaataɡ̶a enagi noko codaa jiɡ̶icota, odaa akaamitawecetiwaji ilaagitibece, odaa joɡ̶opilitalotiwaji niɡ̶inoa ɡ̶adiɡ̶elatedi, leeɡ̶odi madoiitiogi lacilodi judeutedi. Odaa jiɡ̶idaaɡ̶ee nige daɡ̶adiaaɡ̶ica mawitibigiji. Pida aɡ̶oka Eetece, igaataɡ̶a Eiodi iniwa meetaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ejitedaɡ̶awatiwaji niɡ̶inoa yotaɡ̶a, jaotibige mele ɡ̶adaaleɡ̶enali leeɡ̶odi mida anenitigitiwaji. Awikodeetiwaji digoina iiɡ̶o, pida aleeni ɡ̶adaaleɡ̶ena, igaataɡ̶a ja jiɡ̶eke loniciwaɡ̶a niɡ̶ina ane beyagi digoina iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Naɡ̶a igotedi Jesus niɡ̶ijoa lotaɡ̶a, odaa ja iwitedibigimece ditibigimedi, odaa jeɡ̶ee, “Eiodi. Naɡ̶ajo lakata me jawikode ja nipegi. Ikeeni me Ee ɡ̶adionigi, odaa alecatinitibigimece Iboonaɡ̶adi lodoe inatawece oko, amaleeɡ̶aɡ̶a jakadi me joɡ̶etetaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Leeɡ̶odi manajicitiwa inimaweneɡ̶egiteloco inatawece oko me jao midioka limedi me newiɡ̶a niɡ̶ijo ananajicitiwa. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Niɡ̶ina oko idiokaanaɡ̶a limedi me newiɡ̶a makaamitaɡ̶a niɡ̶ina neɡ̶etiɡ̶adowooɡ̶oti, makamokakaami makaami Aneotedoɡ̶oji anewi, codaa niɡ̶ina neɡ̶etidowooɡ̶odi, me Ee, Jesus Cristo anakamaɡ̶a adimonyaa. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ja ɡ̶adinelecaɡ̶ateeni lodoe niɡ̶ina oko digoina iiɡ̶o, igaataɡ̶a ja jigodi ibakedi ananajicitiwa me jao. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Eiodi, natigide awii me ideloɡ̶o ɡ̶adodoe liciagi me ideloɡ̶o niɡ̶ijo jotigide maleediɡ̶icatibige daɡ̶a igo niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ja jikeetiogi anodaaɡ̶eni niɡ̶ijoa ɡ̶oneleegiwadi ane iomaɡ̶atiticoace minataɡ̶a niɡ̶ina oko digoina iiɡ̶o, odaa jaɡ̶anajicitiwa. Ja ɡ̶anepilidi, odaa jaɡ̶anajicitiwa. Codaa oyiwaɡ̶adi ɡ̶adotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Niɡ̶ina natigide niɡ̶ijoa ɡ̶oneleegiwadi joɡ̶oyowooɡ̶odi minoatawece niɡ̶inoa ananajicitediwa icoɡ̶otedigi makaamitaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Igaataɡ̶a jeloɡ̶oditiogi ɡ̶adotaɡ̶a ananajicitediwa, odaa joɡ̶odibatege. Codaa joɡ̶oyowooɡ̶odi mewi me jicoɡ̶otibigimece makaamitaɡ̶a, codaa jeɡ̶eniwaɡ̶atakanaɡ̶a mewi naɡ̶akamaɡ̶a adiiɡ̶eni. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jipokoteloco makaamitaɡ̶a. Pida baadaɡ̶a jipokoteloco niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o, ijoka jipokotelogo niɡ̶ijo ananajicitediwa, igaataɡ̶a ɡ̶anepilidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Inoatawece niɡ̶inoa ane inepilidi, ɡ̶anepilidi. Codaa inoatawece niɡ̶inoa ane ɡ̶anepilidi, Ee aaɡ̶aɡ̶a inepilidi. Leeɡ̶odi moniotici, odaa niɡ̶ina oko joɡ̶oilecateetibigimece Iboonaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Natigidawaanigi jeɡ̶ejigo makaamitaɡ̶a. Aɡ̶aleeɡ̶inaaɡ̶ejo digoina iiɡ̶o. Pida niɡ̶ina anoniotici baɡ̶aleeɡ̶inaaɡ̶i digoina iiɡ̶o. Eiodi, ane diɡ̶ica ɡ̶abatiigi, atikani nimaweneɡ̶egi Ǥaboonaɡ̶adi me otetenitibigiwaji niɡ̶ijoa ɡ̶oneleegiwadi ananajicitediwa, amaleeɡ̶aɡ̶a idioka limedi me ilaɡ̶atiwage, digo anejinaɡ̶a me ɡ̶odilaɡ̶atiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Niɡ̶ijo maleeɡ̶ejote miditaɡ̶a digoina iiɡ̶o, jotetetibigiwaji jatika nimaweneɡ̶egi Ǥaboonaɡ̶adi. Niɡ̶ijoa ɡ̶oneleegiwadi ananajicitediwa, ja idoweditelogo. Codaa aɡ̶ica ananiaditice, ijokijo niɡ̶ijo baɡ̶akaa aniatagigi, niɡ̶ijo anakaa dinibikota maniatagigi, eotibige me jinataɡ̶a niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶a niɡ̶icota. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pida natigidawaanigi jeɡ̶ejigo makaamitaɡ̶a. Ejitece niɡ̶inoa yotaɡ̶a maleeɡ̶eetibige niɡ̶ina iiɡ̶o, amaleeɡ̶aɡ̶a niɡ̶ina anoniotici eliodi me ninitibigiwaji digo aneji me idinitibeci. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ja jajigotiogi ɡ̶adotaɡ̶a. Odaa niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o ja neleɡ̶etedipi, leeɡ̶odi niɡ̶ina anoniotici aɡ̶aleeɡ̶ica aneetege niɡ̶ina iiɡ̶o, digo aneji me diɡ̶ica anejitege niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ajipokotaɡ̶awa daɡ̶anoɡ̶aaticogi niɡ̶ina iiɡ̶o, pida jipokotaɡ̶awa motetenitibigiwaji, adowetiteloco, atamaɡ̶ateenitege nimaweneɡ̶egi niɡ̶ijo ane abeyaceɡ̶egi, diaabo. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aɡ̶ica anoditege niɡ̶ina iiɡ̶o, iciagipi me daɡ̶aɡ̶a icata anejitege niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Atikani anewi niɡ̶ina me iomaɡ̶atiticoace makamoka ɡ̶anepilidi. Ǥadotaɡ̶a joaniɡ̶inaa anewi. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Anemiitiwa madimonyaatinigi niɡ̶ina iiɡ̶o, jiɡ̶idaɡ̶aɡ̶a ejigotiogi me jimonya. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Odaa idiniomaɡ̶aditaɡ̶adomi leeɡ̶odi niɡ̶ina anoniotici. Jao niɡ̶ida anejitaɡ̶awa amaleeɡ̶aɡ̶a odiniomaɡ̶aditaɡ̶adomi makamokakaami me ɡ̶anepilidi. Atiitiogi ɡ̶adotaɡ̶a me iomaɡ̶atiticoace. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pida aɡ̶idioka jipokoteloco, aaɡ̶aɡ̶a jipokoteloco niɡ̶ica eledi anicota metidadiwaɡ̶adi leeɡ̶otedi ɡ̶adotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Eledi jipokoteloco amaleeɡ̶aɡ̶a idiokaaɡ̶a limedi me ilaɡ̶atiwage. Eiodi, jipokotaɡ̶awa amaleeɡ̶aɡ̶a okomokokotege, anejinaɡ̶a mokomokotiwage, codaa emokeetaɡ̶agi, codaa amaleeɡ̶aɡ̶a eniwaɡ̶atakanaɡ̶a niɡ̶ina oko digoina iiɡ̶o naɡ̶akamaɡ̶a adimonyaa. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja jajigo yoɡ̶eeɡ̶egitiogi niɡ̶ina anoniotici, liciagi ɡ̶adoɡ̶eeɡ̶egitiwa, amaleeɡ̶aɡ̶a idioka limedi me ilaɡ̶atiwage, digo anejinaɡ̶a me ɡ̶odilaɡ̶atiwage. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Idejote miditaɡ̶a, liciagi makaami meetaɡ̶a, amaleeɡ̶aɡ̶a ewi me ilaɡ̶atiwage, amanagawini niɡ̶ina oko digoina iiɡ̶o eniwaɡ̶atakanaɡ̶a naɡ̶akamaɡ̶a adimonyaa, codaa memaani digo anemiitiwa mademaani. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Eiodi. Jemaa niɡ̶ijo ananajicitiwa odaa anejote jiɡ̶idiaaɡ̶aɡ̶a ite, codaa amaleeɡ̶aɡ̶a onadi malecatinitibigimece Iboonaɡ̶adi, leeɡ̶odi ademaani maleediɡ̶icatibige me oeni niɡ̶ina iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Eiodi ane iɡ̶enaɡ̶a. Niɡ̶ina oko anida aneetege niɡ̶ina iiɡ̶o aɡ̶etiɡ̶adowooɡ̶oti. Pida Ee baɡ̶a ɡ̶adowooɡ̶oti codaa niɡ̶ijo ananajicitiwa oyowooɡ̶odi naɡ̶akamaɡ̶a adimonyaa. ");
INSERT INTO kbcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ja jao metiɡ̶adowooɡ̶oti, codaa eɡ̶idaa diitigi me ɡ̶adikeenitiogi, jaotibige me dinemaatiwage digo anemiitiwa mademaani, codaa maɡ̶aɡ̶a idejotice miditaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Igaanaɡ̶a nigotedini Jesus me yotaɡ̶aneɡ̶e Eliodi, odaa ja noditedice nigotaɡ̶a ijaaɡ̶ijo anodiotibece igotibeci daato niɡ̶ijo natoaɡ̶a anodita “Cedrom”. Ini lapo nialeli enanigijedi, odaa joaniɡ̶idiaa dakatediwece Jesus ijaaɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, niɡ̶ijo ane yajigo Jesus modibatalo neloɡ̶ododi, eledi yowooɡ̶odi anei niɡ̶ini nialicawaanigi, leeɡ̶odi elioditibece midiaaɡ̶itedibige Jesus ijaaɡ̶ijo anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Odaa Judas jiɡ̶igo niɡ̶ijo aneite Jesus, yadeegi ijoa iodaɡ̶awadi romaanotedi ijaaɡ̶ijoa onateciɡ̶ijoa nowienoɡ̶ododi liɡ̶eladi Aneotedoɡ̶oji, liiɡ̶exedi fariseutedi ijaaɡ̶ijoa lacilodi sacerdotitedi. Oyadeegi noledaɡ̶axiidi inaa laloɡ̶onaɡ̶atedi, codaa me likanaɡ̶anaɡ̶atedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus akaa yowooɡ̶odi inoatawece niɡ̶inoa analeeɡ̶icotece modigotalo. Joaniɡ̶idaa leeɡ̶odi niɡ̶igo dakapetetege, odaa ja nigetediniwace, meetediogi, “Amiijo ica anoleetibigetiwaji?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Noɡ̶oniniɡ̶odi, moditalo, “Joleeɡ̶atibige Jesus anelatedibige Nazaré”. Odaa jeɡ̶eetediogi Jesus, “Niɡ̶ida me Ee, Ee ane Ee!” Judas, niɡ̶ijo aneyaa Jesus eledi ida me lixigaɡ̶awepodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Niɡ̶ijo neɡ̶ee Jesus, “Niɡ̶ida me Ee, Ee ane Ee!”, odaa jaɡ̶anojiceticoace, enitinigi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Odaa ja nigetacediniwace Jesus, meetediogi, “Amiijo ica anoleetibigetiwaji?” Odaa moditacalo, “Joleeɡ̶atibige Jesus anelatedibige Nazaré”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Odaa jeɡ̶eetediogi Jesus, “Geneɡ̶ejitaɡ̶awatiwaji jeɡ̶emeɡ̶ee. Nige neɡ̶emaɡ̶a oleetibigijitiwaji, enice ikaniticoace niɡ̶ina anoniotibici mopitibeci”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eote niɡ̶ida ligegi eote micotece niɡ̶ijo ligegiteta Eliodi, “Eiodi, aɡ̶ica ane aniaditibige otiɡ̶initece niɡ̶idi ananajicitiwa”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simão Pedro idatace lodaajo-ocaɡ̶ataɡ̶a, naɡ̶a nixigitice, odaa ja yakagiditice napaaɡ̶ate ijo ɡ̶oneleegiwa ane liboonaɡ̶adi Malco, ane liotagi lacilo-sacerdotitedi. Naɡ̶ajo napaaɡ̶ate diiɡ̶eticogi libaaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Odaa Jesus jeɡ̶eeteta Pedro, “Ixomitiwece ɡ̶adodaajo laɡ̶aaɡ̶axi! Aleetibige daaditaɡ̶a jibatege yawikodigi ane najigotediwa Eiodi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Odaa niɡ̶ijoa iodaɡ̶awadi romaanotedi, ijo lacilo, ijaaɡ̶ijoa nowienoɡ̶ododi Aneotedoɡ̶oji liɡ̶eladi joɡ̶odibatalo Jesus, joɡ̶oniwilo. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Odaa odoejegi oyadeegitedicogi Jesus liɡ̶eladi Anás, loxiiɡ̶adi Caifás, ane lacilo-sacerdotitedi. Joaniɡ̶iniaa diiɡ̶enataka niɡ̶ijo nicaaɡ̶abi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás, joaniɡ̶iniaa niɡ̶ijo ane yajoitiogi niɡ̶ijoa lacilodi judeutedi me daɡ̶axa mele mokinitece ɡ̶oneleegiwa ane yeleotema noiigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Odaa Simão Pedro ijaaɡ̶ijo eledi ane-diotibece Jesus joɡ̶odiotece lowidi noɡ̶oyadeegi Jesus, dinixigaɡ̶awamigi. Niɡ̶ijo lixigaɡ̶awa Simão Pedro lowooɡ̶otagi niɡ̶ijo lacilo-sacerdotitedi. Joaniɡ̶idaa leeɡ̶odi me yakadi me diotiwece Jesus naɡ̶a dakatediwece niogó liɡ̶eladi niɡ̶ijo lacilo-sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pida Pedro biɡ̶idiaaɡ̶itice we, ipegitege ijo epoagi nelegi. Odaa niɡ̶ijo lixigaɡ̶awa Pedro ane lowooɡ̶otagi niɡ̶ijo lacilo-sacerdotitedi ja noditice, odaa ja yotaɡ̶aneɡ̶e naɡ̶ajo awicije ane yowie niɡ̶ijo epoagi nelegi. Odaa ja ikatio Pedro me dakatio. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Odaa naɡ̶ajo awicije jeɡ̶eeta Pedro, “Ica ina daɡ̶a-aami eledi niɡ̶ina ane do-ootibece niɡ̶idoa aaginaɡ̶a.” Naɡ̶a niniɡ̶odi, meeta, “Oɡ̶oa, aɡ̶ica anejitege!” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Niɡ̶ijoa niotaka ijaaɡ̶ijoa nowienoɡ̶ododi Aneotedoɡ̶oji liɡ̶eladi owo noledi nelegi aninoa ligoli, leeɡ̶odi me diwete niɡ̶ijo enoale. Odaa jiɡ̶idiaa dabidite me dinitotibigiwaji. Pedro eledi ida mawatiogi aaɡ̶aɡ̶a dilowate. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Odaa niɡ̶ijo lacilo-sacerdotitedi ja igetece Jesus niɡ̶ijo anodiotibece, icaaɡ̶ica ane iiɡ̶axitetece, onidaaɡ̶ida me doletibige ane leeɡ̶odi mowo anodigota. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Idioka limedi me jiiɡ̶axinaɡ̶a lodoe noiigi-nelegi. Codaa elioditibece me jiiɡ̶axinaɡ̶a catiwedi niiakanaɡ̶axiidi, codaa me catiwedi Aneotedoɡ̶oji liɡ̶eladi, aneitibige ɡ̶odoiigi judeutedi me yatecoɡ̶o. Aɡ̶ica daɡ̶a idinaɡ̶aditini me jiiɡ̶axinaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Natigide, igaamee ina madigee? Anigeetiniwace niɡ̶ijo anonajipatiwa, igaataɡ̶a oyowooɡ̶odi niɡ̶inoa ane jiiɡ̶axitece”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Niɡ̶ijo neɡ̶ee Jesus niɡ̶ijo ligegi, odaa ica nowienoɡ̶odi lapoagi Aneotedoɡ̶oji liɡ̶eladi ja yabaketigi latobi, meetalo, “Ayakadi mideɡ̶emii magiti niɡ̶ini lacilo-sacerdotitedi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Nige beyagi niɡ̶ijo igegi, enice anikeenitiwa ica ibatiigi. Pida nigele niɡ̶ijo igegi, igatime leeɡ̶odi madabakeni?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesus eɡ̶idaaɡ̶ee moigoetedi, odaa Anás ja diiɡ̶enatakatalo moyadeegitedicogi minitaɡ̶a Caifás, niɡ̶ijo eledi lacilo-sacerdotitedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Eɡ̶idiaa dabidite Pedro me dilowate, noɡ̶oigetace, modita, “Akaami eledi iwitibece idoa ɡ̶oneleegiwa?” Odaa Pedro ja diwitakatace, meetiogi, “Ee oɡ̶oa!” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Onijoteci niɡ̶ijoa niotaka ane litaagi niɡ̶ijo Pedro ane yakagiditice napaaɡ̶ate, meeta Pedro, “Ica ina daɡ̶a ɡ̶adati digoida aneite enanigijedi nialeli.” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Odaa Pedro jiɡ̶ijaa naɡ̶a inaaletace mee me diɡ̶icoateda me yowooɡ̶odi Jesus. Odaa aɡ̶ica daɡ̶a leegi jaɡ̶anoe okoɡ̶okoodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Niɡ̶idiaaɡ̶idi joɡ̶onotaɡ̶ateetedice Jesus liɡ̶eladi Caifás, odaa joɡ̶oyadeegitedicogi liɡ̶eladi-nelegi ninionigi romaanotedi ane liboonaɡ̶adi Pilatos, jeɡ̶epaa iiɡ̶e iditawece niiɡ̶o noiigi judeu. Naɡ̶a yeloɡ̶otibige, joɡ̶oyooditedicogi Jesus minitaɡ̶a Pilatos. Odaa aɡ̶odakatiwece liɡ̶eladi Pilatos, leeɡ̶odi lakatigi judeutedi yoli doɡ̶odakatiwece liɡ̶eladi eledi oko ane daɡ̶a judeu. Odoitibige diɡ̶ica lapioyaɡ̶ajegi lodoe Aneotedoɡ̶oji, igaataɡ̶a leeditibige me yapiditibigiwaji odaa joɡ̶oyakadi moyeligo liweenigi lalokegi Páscoa. Joaniɡ̶idaa leeɡ̶odi midiaaɡ̶iticoace we niɡ̶ijo diimigi-nelegi, liɡ̶eladi Pilatos. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Odaa Pilatos ja noditice liɡ̶eladi, jiɡ̶igo dakapetege, odaa jeɡ̶eetiogi, “Amiini ica ananatitecetiwaji me libeyaceɡ̶egi idoa ɡ̶oneleegiwa?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Noɡ̶oigidi, modita, “Ajinadeegaɡ̶atedaɡ̶awa niɡ̶idoa ɡ̶oneleegiwa daaditiɡ̶icata loenatagi ane beyagi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Odaa jeɡ̶eetiogi Pilatos, “Enice adeegitetiwaji, akamaɡ̶a awini niɡ̶ica anemiitalo, iwitece ane ɡ̶anajoinaɡ̶aneɡ̶eco”. Odaa niɡ̶ijoa lacilodi judeutedi modi, “Aɡ̶ica ɡ̶onaɡ̶atetigi daɡ̶a jeloataɡ̶a oko, akamokakaami mida ɡ̶anaɡ̶atetigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Joaniɡ̶idaaɡ̶ee, jeɡ̶eo micotece niɡ̶ijo Jesus ligegi, me yalaɡ̶ate anodaaɡ̶ee me yeleo. (Leeɡ̶odi ijokijo romaanotedi moyakadi moyeloadi oko oyototeloco nicenaɡ̶anaɡ̶ate.) ");
INSERT INTO kbcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Odaa Pilatos ja dakatiwece liɡ̶eladi, odaa jeɡ̶eniditalo Jesus, naɡ̶a ige, meetalo, “Ewi makaami ninionigi-eliodi judeutedi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Ida anadigeetece akamaɡ̶a ɡ̶adowoogo? Oɡ̶oa, eledi oko yeloɡ̶oditaɡ̶awa ane Ee?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Naɡ̶a niniɡ̶odi Pilatos, meetalo, “Niɡ̶ida me ee, aɡ̶ee judeu! Niɡ̶ina akamaɡ̶a ɡ̶adoiigi inaaɡ̶ina anoiiɡ̶e sacerdotitedi joaneɡ̶epaa etiɡ̶adajici meetaɡ̶a. Enice amiini ica ɡ̶adoenatagi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Naɡ̶a igidi Jesus, meeteta, “Ininioxigi aɡ̶ica aneetege niɡ̶ina iiɡ̶o. Diɡ̶ica aneetege ininioxigi niɡ̶ina iiɡ̶o, daɡ̶anagawini niɡ̶inoa iotaka odideletomi me doɡ̶oika modibatiwa judeutedi. Pida ininioxigi aɡ̶ica aneetege niɡ̶ina iiɡ̶o”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Odaa Pilatos ja igetace Jesus, meetalo, “Enice, ida makaami, akaami inionigi-eliodi?” Naɡ̶a niniɡ̶odi Jesus, meeteta, “Ee inionigi-eliodi, diganaleeɡ̶alitigi ɡ̶agegi. Joaniɡ̶idaa leeɡ̶odi me janitini, odaa ja janagi digoina iiɡ̶o mejitece anewi. Niɡ̶ina oko anida aneetege anewi, joaniɡ̶iniaa wajipatalo yotaɡ̶a”. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Odaa jeɡ̶ee Pilatos, “Amiijo ica anewi?” Odaa Pilatos ja noditacicogi we me notaɡ̶aneɡ̶etaciniwace judeutedi, meetiogi, “Aɡ̶ica jakaditece ane leeɡ̶odi daɡ̶a jiiɡ̶enatakatalo niɡ̶idoa ɡ̶oneleegiwa moyeloadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pida geme ɡ̶adakatigitiwaji manipokitiwa me jikatice oniniteci niwilogojegi niɡ̶ina me nakatio ɡ̶adalokegitiwaji anodita Páscoa. Emaani me jikatedice idoa ninionigi-eliodi judeutedi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Odaa iditawece ja napaawaɡ̶ataceloco modi, “Baadeɡ̶ele daɡ̶a ikanitedice. Biɡ̶ida ikanitice Barrabás!” Barrabás one niɡ̶ina ɡ̶oneleegiwa ane doide, ɡ̶onematagodi. (Codaa joniɡ̶ica me ideleɡ̶e niodaɡ̶awadi ninionigi-eliodi romaanotedi.) ");
INSERT INTO kbcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Odaa Pilatos ja diiɡ̶enatakatalo Jesus monalaketedibige. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Odaa niɡ̶ijoa iodaɡ̶awadi joɡ̶oyoetema lale, macataɡ̶a naɡ̶ana lale inionigi-eliodi, pida boɡ̶odatika lalepiɡ̶igo moyoe. Odaa joɡ̶onixotinece lacilo Jesus, codaa onixomeɡ̶etedinigi ajo caapa ocaɡ̶ataɡ̶a nolidigo-lawoɡ̶o liciagi naɡ̶ana nicaapa inionigi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Odaa moditibigalo me napaawaɡ̶ateloco, “Niɡ̶idoa ninionigi-eliodi judeutedi!” Odaa ja diiticogi moyametibigo, onabaketedice. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Odaa ja noditacicogi Pilatos we. Odaa jeɡ̶eetiogi, “Digawinitiwaji. Inadeegitedicogi digoina wetice, amaleeɡ̶aɡ̶a anatitiwaji me diɡ̶icata ane jakadi me leeɡ̶odi daɡ̶a jiiɡ̶enatakatalo moyeloadi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Odaa Jesus ja noditedice we ajaaɡ̶ajo lale lalepiɡ̶igo anonixotinece lacilo, ajaaɡ̶ajo caapa ane nolidigo-lawoɡ̶o eledi anonixomeɡ̶etinigilo. Odaa Pilatos jeɡ̶eetiogi, “Naɡ̶anatitiwaji! Etidoa niɡ̶idoa ɡ̶oneleegiwa!” ");
INSERT INTO kbcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Niɡ̶ijo anoiiɡ̶e sacerdotitedi ijaaɡ̶ijoa nowienoɡ̶ododi Aneotedoɡ̶oji liɡ̶eladi noɡ̶onaditege Jesus, odaa ja napaawaɡ̶ateloco, modi, “Otonitedeloco nicenaɡ̶anaɡ̶ate! Otonitedini!” Odaa jeɡ̶eetiogi Pilatos, “Adeegitetiwaji, akamaɡ̶a otonitedeloco nicenaɡ̶anaɡ̶ate. Igaataɡ̶a jakadi me diɡ̶ica anigetiɡ̶ida ane leeɡ̶odi daɡ̶a jiiɡ̶enatakatalo moyeloadi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Odaa niɡ̶ijoa lacilodi judeutedi joɡ̶oniniɡ̶odi, modita, “Inoa ɡ̶onajoinaɡ̶aneɡ̶eco. Odaa ɡ̶onajoinaɡ̶aneɡ̶egi meetoɡ̶owa me leeditibige me jeloataɡ̶a, igaataɡ̶a mee mone Aneotedoɡ̶oji Lionigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Igaanaɡ̶a wajipata Pilatos lotaɡ̶a lacilodi judeutedi, odaa jeɡ̶epaanaɡ̶a doi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Odaa ja dakataciwece liɡ̶eladi, igo me igetace Jesus, meetalo, “Igame icoɡ̶iticogi?” Pida Jesus aigidi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Odaa jeɡ̶eetalo Pilatos, “Igaamee ina me deɡ̶emaani madigiti? Aɡ̶owooɡ̶oti mida inaɡ̶atetigi me ɡ̶adikanitice, codaa mida inaɡ̶atetigi me jiiɡ̶enatakataɡ̶awa metiɡ̶adotoniteloco nicenaɡ̶anaɡ̶ate?” ");
INSERT INTO kbcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Ida ɡ̶anaɡ̶atetigi leeɡ̶odi Niɡ̶ijoa ane ideite ditibigimedi me yajigotedaɡ̶awa ɡ̶animaweneɡ̶egi. Joaniɡ̶idaa leeɡ̶odi niɡ̶ina ane idajigotaɡ̶awa nelegi libatiigi caticedi ɡ̶abatiigi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Naɡ̶a wajipatalo niɡ̶ijoa lotaɡ̶a Jesus, odaa Pilatos ja doletibige niɡ̶ica nimaweneɡ̶egitece Jesus me ikatedice. Pida niɡ̶ijoa lacilodi judeutedi idokee me napaawaɡ̶ateloco, modi, “Nige ikanitedice niɡ̶idoa ɡ̶oneleegiwa, amakaami lokaaɡ̶edi César, anokotawece ɡ̶odiiɡ̶e. Igaataɡ̶a niɡ̶ina ane dinanatigi me inionigi-eliodi, lakapetegi César”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Niɡ̶ijo Pilatos naɡ̶a wajipata niɡ̶ida nigegi, odaa ja nadeegitedicogi Jesus wetice liɡ̶eladi. Odaa Pilatos jiɡ̶igo nicotini manitaɡ̶a nibaanco ɡ̶oneɡ̶e, niɡ̶ica aneitice naɡ̶ani baanco liboonaɡ̶adi “Ǥodipodaɡ̶aladi wetiɡ̶a”. (Liboonaɡ̶aditigi nioladi judeutedi me “Gabatá”.) ");
INSERT INTO kbcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aniaditibige onidateci noko daɡ̶a nakatio nalokegi Páscoa, noɡ̶odinoetege me nalooɡ̶o. Ja doletibige me seis lakata, neɡ̶eetiogi Pilatos niɡ̶ijoa judeutedi, “Digawini! Etidoa ɡ̶aninionigi-elioditetiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pida idokee me napaawaɡ̶ateloco, modi, “Eloati! Otonitedeloco nicenaɡ̶anaɡ̶ate meloati!” Odaa ja nigetiniwace Pilatos, meetiogi, “Ewi memaanitiwaji me jiiɡ̶enatakatalo moyototedeloco nicenaɡ̶anaɡ̶ate idoa ɡ̶aninionigi-eliodi?” Pida niɡ̶ijo anoiiɡ̶e sacerdotitedi modita, “Iniokini César me ɡ̶oninionigi-eliodi. Aɡ̶ica eledi ɡ̶oninionigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Odaa Pilatos ja yajigo Jesus moyototedeloco nicenaɡ̶anaɡ̶ate, odaa joɡ̶oyadeegi niɡ̶ijoa iodaɡ̶awadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Odaa ja noditedice Jesus, epaa yoyaɡ̶aditedijo ajo licenaɡ̶anaɡ̶ate. Odaa jiɡ̶igotibeci minitaɡ̶a lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi ɡ̶odacilo-libitagi”. (Nioladi judeutedi niɡ̶ini liboonaɡ̶adi “Gólgota”). ");
INSERT INTO kbcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Joaniɡ̶idiaa oyelite noɡ̶oyototedeloco nicenaɡ̶anaɡ̶ate ijaaɡ̶ijoa itoataale ɡ̶oneleegiwadi. Odaa odoyate Jesus liwigotigi niɡ̶ijoa itoa. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Odaa Pilatos jeɡ̶eote lidiko iditeloco taaboa-liwai. Odaa ja diiɡ̶enataka moyototeloco licenaɡ̶anaɡ̶ate Jesus ditibigimedawaanigi lacilo. Iditini, “JESUS ANE ELATEDIBIGE NAZARÉ, NINIONIGI-ELIODI JUDEUTEDI.” Oiditedi niɡ̶ijoa lidiko me nioladi judeutedi, nioladi greegotedi, ijaa nioladi romaanotedi. Eliodi judeutedi oyalomeɡ̶eteloco naɡ̶ajo nidie, leeɡ̶odi niɡ̶ijo anoyelite Jesus moyototedeloco nicenaɡ̶anaɡ̶ate ipegitege nigotaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Odaa niɡ̶ijo anoiiɡ̶e sacerdotitedi modita Pilatos, “Jinaɡ̶a eliiteloco naɡ̶ada nidie ‘Ninionigi-eliodi judeutedi’. Pida idiiteloco ‘Mee me ninionigi-eliodi judeutedi’”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Naɡ̶a niniɡ̶odi Pilatos, meetiogi, “Ane jiditini, ja diniditini.” ");
INSERT INTO kbcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Igaanaɡ̶a oigodi Jesus moyototedeloco nicenaɡ̶anaɡ̶ate niɡ̶ijoa iodaɡ̶awadi, odaa joɡ̶odibatalo lowoodi, odaa joɡ̶odinilaagaɡ̶aditigilo onaditecibige niɡ̶ijoa cwaatolo iodaɡ̶awadi. Odaa yeyaɡ̶atice onajoteci naɡ̶ajo nitoonicogo, anadatawece me lipegeteɡ̶e adinapeegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Odaa ja dinotaɡ̶aneɡ̶e, midiokiditiwage, modi, “Aɡ̶ele daɡ̶a jaaɡ̶ataɡ̶a naɡ̶ada toonicogo. Pida jiwinaɡ̶a niɡ̶ica anepaɡ̶a dinetetece. Odaa ane dinete ja nebi naɡ̶ada toonicogo.” Niɡ̶ida niciagi eo micotece niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶a, niɡ̶ijo mee, “Odinilaagaɡ̶aditigi yowoodi, codaa oiwi anepaɡ̶a dinetetece, odaa ja nebi initoonicogo.” Odaa niɡ̶ijoa iodaɡ̶awadi jiɡ̶idaaɡ̶odigotalo niɡ̶ijoa lowoodi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ada mipegitege naɡ̶ajo licenaɡ̶anaɡ̶ate Jesus naɡ̶ajo eliodo, ajo nioxoa, ajaaɡ̶ajo Maria lodawa Clopas, ajaa Maria Madalena eledi ada miditaɡ̶a. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Igaanaɡ̶a nadi Jesus naɡ̶ajo eliodo, ijaaɡ̶ijo niɡ̶ijo ane-diotibece ane daɡ̶axa me yemaa, odaa jeɡ̶eete naɡ̶ajo eliodo, “Iniotagodo. Niɡ̶idoda ɡ̶oneleegiwa. Ademii micataɡ̶a daɡ̶a ɡ̶adionigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Niɡ̶idiaaɡ̶idi Jesus jaɡ̶aɡ̶a eete niɡ̶ijo ane-diotibece, “Naɡ̶ada iwaalo. Ademii micataɡ̶a daɡ̶a ɡ̶adiodo”. Odaa niɡ̶ijo ane-diotibece Jesus ja yadeegi naɡ̶ajo eliodo Jesus me noiigiwa digoida liɡ̶eladi ijaaɡ̶ijo niɡ̶ijo noko. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Niɡ̶idiaaɡ̶idi Jesus ja yowooɡ̶odi naɡ̶a igodi inoatawece ane leeditibige meote. Odaa jeɡ̶eo micota niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶a, niɡ̶ijo neɡ̶ee Jesus, “Ideloadi ecibi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ada ajo laɡ̶aaɡ̶axi viinyo ane daɡ̶a dakake loojedi (anepoka lacipaɡ̶adi niɡ̶inoda madewetedi). Odaa joɡ̶oititinigi niɡ̶ijo viinyo naɡ̶ajo ane liciagi coxao. Odaa joɡ̶oigoeteloco niɡ̶ijo iwoɡ̶o anoyakagidi libiwe “hissopo”. Odaa joɡ̶oyatiwece nioladi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Igaanaɡ̶a ici Jesus niɡ̶ijo viinyo, odaa jeɡ̶ee, “Ja jigodi inoatawece ane leeditibige me jaote.” Naɡ̶a noletedini, odaa ja yopilaɡ̶adite liwigo Eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Niɡ̶ijo noko judeutedi joɡ̶odinoetege nalokegi, odaa niɡ̶ijoa lacilodi judeutedi aɡ̶oyemaa diɡ̶idiaaɡ̶ite niɡ̶ijoa ɡ̶oneleegiwadi midoataɡ̶a licenaɡ̶anaɡ̶atedi deɡ̶epaa eledi noko, leeɡ̶odi me saabado, noko daɡ̶axa me ɡ̶oneɡ̶egi. Joaniɡ̶idaa leeɡ̶odi modipokota Pilatos me diiɡ̶enatakatiogi moninoketedini litili niɡ̶ijoa ɡ̶oneleegiwadi anoyototelogo nicenaɡ̶anaɡ̶atedi (owotibige me age me nigo), odaa joɡ̶onikatiniwace nicenaɡ̶anaɡ̶atedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Odaa niɡ̶ijoa iodaɡ̶awadi jiɡ̶igotibeci, odaa joɡ̶oninoketedini litili niɡ̶ijo odoejegi ɡ̶oneleegiwa anoyototini. Odaa niɡ̶idiaaɡ̶idi jaɡ̶aɡ̶a otota moninoketedini litili niɡ̶ijo eledi ɡ̶oneleegiwa anabotege Jesus moyototedini. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pida niɡ̶idiaaɡ̶idi naɡ̶aɡ̶a ototalo Jesus, odaa joɡ̶onadi mewi naɡ̶a yeleo. Joaniɡ̶idaa leeɡ̶odi me daɡ̶adiaaɡ̶oninoketedini litili. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Odaa jiɡ̶ijo iodaɡ̶awa ane dibata napocenigi, odaa ja yapoace liwai Jesus. Odaa jaɡ̶anado lawodi, ina ninyoɡ̶odi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Niɡ̶ijo ane nadi yalaɡ̶ata niɡ̶ida niciagi eotibige makaami eleditetiwaji iwaɡ̶atakani. Yatemati anewi, codaa ijaaɡ̶ijo yowooɡ̶odi mewi niɡ̶inoa latematiko. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Inoatawece niɡ̶inoa ane jinataɡ̶a eotibige me icotece niɡ̶ijoa aneeta Aneotedoɡ̶oji lotaɡ̶a, niɡ̶ijo mee, “Aɡ̶ica otiɡ̶iditece ɡ̶abitagi ane dinoke”. Eledi mee Aneotedoɡ̶oji lotaɡ̶a, “Oiwitibigimece niɡ̶ijoa anoyojogotalo apocenigi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Niɡ̶idiaaɡ̶idi José anelatibige nigotaɡ̶a Arimatéia jiɡ̶igo yotaɡ̶aneɡ̶e Pilatos, dipokota me yadeegi lolaadi Jesus. José eledi diotibece Jesus, pida baɡ̶a dinaɡ̶aditi me diotibece, igaataɡ̶a doitiogi niɡ̶ijoa lacilodi judeutedi. Igaanaɡ̶a dipokotalo, odaa Pilatos ja ikatece. Odaa José jiɡ̶igo nikatedini Jesus madataɡ̶a nicenaɡ̶anaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus ijo migo lixigaɡ̶awa José. Nicodemus, niɡ̶ijo ane igo yotaɡ̶aneɡ̶e Jesus niɡ̶ijo enoale naɡ̶a diiticogi me niiɡ̶axitediniwace oko. Nicodemus me lixigaɡ̶awa José yadeegi triinta ciilo ladokojegi anodita “aloés” awatege ica “mirra”. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Odaa José ijaa Nicodemus joɡ̶odibata lolaadi Jesus, odaa joɡ̶oilipaditigi niɡ̶elateli, oyatitibige niɡ̶ijo ladokojegi. Owo anepaa lakatigi judeutedi moyoetini niɡ̶ina némeɡ̶egi anoixotiwece wetiɡ̶a-lawimaɡ̶ajegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niɡ̶ijo anoyelite Jesus moyototedeloco nicenaɡ̶anaɡ̶ate ipegitege ijoa nawodigijedi niale lawoɡ̶o aneitice niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a gela moigodi, analeediɡ̶icata émeɡ̶egi anoixotiwece. ");
INSERT INTO kbcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Odaa jiɡ̶idiaa oixotediwece lolaadi Jesus, leeɡ̶odi niɡ̶ijo lawimaɡ̶ajegi-wetiɡ̶a baɡ̶a ipegitege aneiticoace, codaa eleditace leeɡ̶odi naɡ̶a nipegi me nakatio nisaabado judeutedi. (Limedi me nipenaɡ̶a). ");
INSERT INTO kbcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Niɡ̶ijo naɡ̶a domiingo me nigoitijo, eɡ̶inaa nexocaɡ̶a, odaa Maria Madalena jiɡ̶igo midataɡ̶a wetiɡ̶a-lawimaɡ̶ajegi anoyatice lolaadi Jesus. Odaa ja nadi naɡ̶ajo wetiɡ̶a nelegi ane nibatoo lawimaɡ̶ajegi-wetiɡ̶a aneitice lolaadi Jesus naɡ̶a dawililetice. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Odaa ja walokodi migo midataɡ̶a Simão Pedro, ijaaɡ̶ijo ane-diotibece Jesus lemaanigi. Odaa jeɡ̶eetiogi, “Joɡ̶onoɡ̶owa Ǥoniwa-aagodi lolaadi, aɡ̶e-eeɡ̶ica midataɡ̶a wetiɡ̶a-lawimaɡ̶ajegi, ajowooɡ̶otaɡ̶a niɡ̶ica anoyaticogi lolaadi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Odaa Pedro ijaaɡ̶ijo lokaaɡ̶edi jaɡ̶aɡ̶igotibeci midataɡ̶a wetiɡ̶a-lawimaɡ̶ajegi anoyatice lolaadi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Niɡ̶ijoa itoa ja waledi, pida niɡ̶ijo eledi daɡ̶axa me dawé, odaa odoejegi me icota anoyatice lolaadi Jesus, ijaa Pedro ja nalatigi. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Igaanaɡ̶a dakagitini niɡ̶ijo anodoejegi micotio, iwitiwece niɡ̶ijo anoyatice lolaadi Jesus, odaa ja nadi niɡ̶ijoa lipataɡ̶axiidi Jesus, pida adakatio. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Niɡ̶idiaaɡ̶idi Simão Pedro jaɡ̶aɡ̶icotio, odaa jeɡ̶epaɡ̶a dakatio. Odaa ja nadi niɡ̶ijoa lipegeteɡ̶e anoilipaditigilo Jesus, idiaaɡ̶itedice niɡ̶ijo ane iwote. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Eledi nadi naɡ̶ajo leenxo anoilipaditece lacilo Jesus. Naɡ̶ajo leenxo aɡ̶awatege niɡ̶ijoa lipegeteɡ̶e lipataɡ̶axiidi, pida diɡ̶eticogi eledi liwai, dinokomoke. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Niɡ̶ijo lokaaɡ̶edi Pedro anodoejegi mico, jaɡ̶aɡ̶a dakatio. Igaanaɡ̶a nadi, odaa jeɡ̶etiwaɡ̶ataka mewi naɡ̶a yewiɡ̶atace Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pida eɡ̶idaaɡ̶ee maleedoɡ̶oyowooɡ̶odi niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶a, me leeditibige me yewiɡ̶atace Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Niɡ̶idiaaɡ̶idi niɡ̶ijo itoataale anodiotibece Jesus joɡ̶opiticogi liɡ̶eladi. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Madalena idiaa dabidite wetice miditaɡ̶a anoyatice lolaadi Jesus, anoetibece. Eɡ̶idaaɡ̶ee manoetibece, naɡ̶a dakagitini me iwitiwece catiwedi. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Odaa ja nadi icoa itoataale aanjotedi yapacaɡ̶a lowoodi. Idiaa nicotiniwace miditaɡ̶a anoyatice lolaadi Jesus. Onijoteci nicotini diɡ̶eticogi lakaaɡ̶adi niɡ̶ijo ane iwote Jesus, ijo eledi baɡ̶a nicote ane dojitedicogi loɡ̶onaka. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Odaa joɡ̶oige, modita, “Iniotagodawaana. Igaameni ina me anoenitibece?” Naɡ̶a niniɡ̶odi, meetiogi, “Jinoetibece le-eeɡ̶odi aɡ̶e-eeɡ̶ica lolaadi Iniwa-aagodi, joɡ̶oyadeegi, ajowooɡ̶odi niɡ̶ica anoyaticogi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Igaanaɡ̶a nigotini me dotaɡ̶a, naɡ̶a nawiilitetijo, odaa ja nadi Jesus, dabiditedi, pida ayowooɡ̶odi niɡ̶idaaɡ̶idoa. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Odaa ja ige Jesus, meeteta, “Iniotagodo. Ame leeɡ̶odi me anoenitibece? Amiijo ica anoleetibige?” Maria diletibige diɡ̶ijiɡ̶ijo nowienoɡ̶odi niale lawoɡ̶o. Odaa jeɡ̶eetalo, “Iniwa-aagodi. Nige naɡ̶a-aamaɡ̶a anoɡ̶owaatice lolaadi Iniwa-aagodi, adiwikodeni aneloɡ̶otitiwa niɡ̶ica ana-aanite, odaa jadeegoda.” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Odaa jeɡ̶ee Jesus, “Maria!” Naɡ̶a nilokotijo, odaa ja igidi, yatitalo ioladi hebraico, meetalo, “Raboni!” (Amina anejinaɡ̶a “Iniiɡ̶axinoɡ̶odi”). ");
INSERT INTO kbcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Odaa jeɡ̶ee Jesus, “Jinaɡ̶a domaɡ̶a abaatiloco, igaataɡ̶a anaɡ̶a jopitibigimece Eiodi. Pida emii opilitio, enitiogi inioxoadipi mejigo miniwataɡ̶a Eiodi ane Ǥadiodi, Inoenoɡ̶odi ane Ǥanoenoɡ̶oditetiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Odaa Maria Madalena joɡ̶opitio, odaa ja yatematitiogi niɡ̶ijo anodiotibece Jesus me nadi Ǥoniotagodi, codaa yatemati ijoatawece niɡ̶ijoa aneeteta. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ijaaɡ̶ijo niɡ̶ijo domiingo, naɡ̶a ɡ̶ocidi, niɡ̶ijo anodiotibece Jesus idiaaɡ̶i yatecoɡ̶o catiwedi diimigi, onibatoo lapoaco, leeɡ̶odi odoitibige niɡ̶ijoa lacilodi judeutedi. Pida codaaɡ̶idoateda Jesus liwigotigi me dilapode, odaa jeɡ̶eetediogi, “Jemaa mele ɡ̶adaaleɡ̶enalitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Igaanaɡ̶a nigotini niɡ̶ijo ligegi, odaa ja ikeetediogi libaaɡ̶atedi, liwai ane yapoace apocenigi. Niɡ̶ijo noɡ̶onadi Ǥoniotagodi, odaa eliodi me ninitibigiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Odaa jeɡ̶eetacediogi Jesus, “Jemaa mele ɡ̶adaaleɡ̶enalitiwaji! Natigide ane igotediwa Eiodi me idimonya, jiɡ̶idaaɡ̶ejigotaɡ̶awatiwaji me ɡ̶adimonyaa mawii ane jemaa.” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Igaanaɡ̶a nigotedini me notaɡ̶aneɡ̶etediniwace, odaa ja nawetediniwace, codaa meetediogi, “Abaategetiwaji Aneotedoɡ̶oji Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Odaa nigipokitalo Aneotedoɡ̶oji me napitaɡ̶adi libeyaceɡ̶eco eledi oko, odaa Aneotedoɡ̶oji jaɡ̶aɡ̶a napitaɡ̶adi niɡ̶icoa libeyaceɡ̶eco. Nige deɡ̶emaani Aneotedoɡ̶oji me napitaɡ̶adi oko libeyaceɡ̶eco, odaa Aneotedoɡ̶oji anapitaɡ̶adi niɡ̶icoa libeyaceɡ̶eco.” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Onijoteci niɡ̶ijo dooze anodiotibece Jesus ane liboonaɡ̶adi Tomé ane nikoxeedi me “Owaadi”. Tomé aɡ̶ica niɡ̶ijo noko Jesus niɡ̶icotediogi me dilapode niɡ̶ijo eledi anodiotibece. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Odaa niɡ̶ijo eledi anodiotibece modita Tomé, “Jinataɡ̶a Ǥoniotagodi”. Pida Tomé dawienataka, meetiogi, “Nige daɡ̶a jinaditeda adotonadi libecoli liwigotigi libaaɡ̶adi, codaa nige daɡ̶a jixotiwece inibedona, codaa nige daɡ̶a jibatiwece niɡ̶ijo elaciledi liwai moyojogotalo apocenigi, oteɡ̶exaaɡ̶aɡ̶a ejiwaɡ̶atakanawaanigi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Igaanaɡ̶a ixomaɡ̶atedice seete nokododi, odaa niɡ̶ijo anodiotibece Jesus ja yatecoɡ̶otace ijaaɡ̶ijo niɡ̶ijo aneiticoace, pida Tomé jiɡ̶ini mawatiogi. Idoatawece epoaco dinoxoco. Codaaɡ̶idoataceda Jesus, naɡ̶awatediogi, odaa jeɡ̶eetediogi, “Jemaa mele ɡ̶adaaleɡ̶enalitiwaji!” ");
INSERT INTO kbcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Odaa jeɡ̶eeteta Tomé, “Dige adeoni ɡ̶anibedona digoina, codaa digawini ibaaɡ̶atedi. Abaatiwece eyaciledi digoina iwai. Ikani mawienatakani, biɡ̶ida iwaɡ̶atakani”. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Naɡ̶a niniɡ̶odi Tomé, meetalo, “Iniotagodi, me Inoenoɡ̶odi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Odaa jeɡ̶eeteta Jesus, “Eka iwaɡ̶atakani leeɡ̶odi naɡ̶adati. Eliodi linikegi niɡ̶ina ane idadiwaɡ̶adi, idaaɡ̶ida me diɡ̶icata me idadi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Owidi eletidi ɡ̶odoxiceɡ̶etedi Jesus aneote lodoe niɡ̶ijo anodiotibece. Pida aɡ̶icoa daɡ̶a diniditelogo naɡ̶adi notaɡ̶anaɡ̶axi. ");
INSERT INTO kbcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pida niɡ̶inoa notaɡ̶a diniditedini amaleeɡ̶aɡ̶a iwaɡ̶atakanitiwaji Jesus me niɡ̶ijaaɡ̶ijoa ane niiɡ̶e Aneotedoɡ̶oji meote ɡ̶odewiɡ̶a, codaa me Lionigi Aneotedoɡ̶oji, codaa amanagawini nige iwaɡ̶atakanitiwaji, odaa idiokaanaɡ̶a limedi me ɡ̶adewikitema leeɡ̶odi naɡ̶atetigi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Niɡ̶idiaaɡ̶idi Jesus ja dinikeetacediogi niɡ̶ijo anodiotibece liniogotibece weiigi anodita “Tiberíades” (eledi oyatigi me Galiléia). Digawini anodaaɡ̶ee me dinikeetediogi. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ini Simão Pedro, Tomé ane nikoxeedi me “Owaadi”, Natanael anelatibige nigotaɡ̶a Caná nipodigi Galiléia, ijoa itoataale lionaɡ̶a Zebedeu, ijaaɡ̶ijoa eletidi itoataale anodiotibece Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Odaa jeɡ̶eetiogi Simão Pedro, “Ejigo jomiige”. Odaa niɡ̶ijo eledi modita, “Oko, iniɡ̶a akaami ɡ̶odixigaɡ̶awa”. Odaa jiɡ̶igotibeci, joɡ̶owaxoditinigi ajo niwatece, odaa ijotawece niɡ̶ijo enoale aɡ̶ica libakajetegi otiɡ̶iditece noɡ̶ojegi. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Igaanaɡ̶a yeloɡ̶otibige, naɡ̶a nodi aligeɡ̶e, Jesus idiaa dabidite liniogotibece weiigi, miditaɡ̶a ijo dotiwadi. Pida niɡ̶ijo anodiotibece aɡ̶oyowooɡ̶odi niɡ̶idaaɡ̶idoa. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Odaa ja dapaawetediogi, mee, “Ionigipi. Aɡ̶ica ɡ̶abakajetegi noɡ̶ojegi?” Noɡ̶oniniɡ̶odi, moditalo, “Amitiɡ̶ica ica ɡ̶obakajetegi”. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Odaa jeɡ̶eetediogi, “Okoleniticogi ɡ̶adeladitiwaji eledi ɡ̶awai, ane diɡ̶eticogi ɡ̶obaaɡ̶adi, odaa baɡ̶abaatalotiwaji noɡ̶ojedi”. Odaa joɡ̶oyokoletace leladi. Aɡ̶ica daɡ̶a leegi, aɡ̶alee domoɡ̶oyakadi niɡ̶ijo leladi moixigitinigi catinedi liwatece, leeɡ̶odi owidi noɡ̶ojedi anodibatalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Odaa niɡ̶ijo ane-diotibece Jesus ane daɡ̶axa me yemaa, joaniɡ̶ijaaɡ̶eeta Pedro, “Niɡ̶idoa jiɡ̶idaa Ǥoniotagodi”. Igaanaɡ̶a wajipata Simão Pedro modi Ǥoniotagodi, odaa ja dinixotinigi nicaapa, leeɡ̶odi noɡ̶a lowoodi me domiige. Naɡ̶a dinixotinigi lowoodi, odaa ja ipoditinigi ninyoɡ̶odi, igo midi dotiwadi. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Niɡ̶ijoa eletidi lokaaɡ̶etedi baɡ̶a owaxoditinigi niwatece, onixigitita neladi nolee noɡ̶ojedi, leeɡ̶odi aleegita moyototice liniogotibece, onexaa onaniteci taalia meetilo moyetecetice niɡ̶ijo dotiwadi ane dabidite Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Igaanaɡ̶a diɡ̶etitacicoace daato, odaa ja waxoditicoace liwatece, odaa joɡ̶onadi ini noledi jiɡ̶inoa ligoli, idiaa noɡ̶ojedi ditibigimedi, idiaaɡ̶idi paon. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Odaa jeɡ̶eetediogi Jesus, “Awiite manadeegi niɡ̶idiwa noɡ̶ojedi ane geladi mabaatalotiwaji”. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Odaa Simão Pedro ja waxoditacinigi naɡ̶ajo niwatece, odaa ja ixigitijo niɡ̶ijo neladi, yadeegiticogi lipenaɡ̶adi. Nolee niɡ̶ijo neladi, 153 noɡ̶ojedi nelecoli. Diganee me nolee niɡ̶ijo neladi, pida adawalace. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Odaa jeɡ̶eetediogi Jesus, “Anagitiwaji, aniodi”. Pida aɡ̶ica anabo laaleɡ̶ena daɡ̶a ige deɡ̶eetalo, “Amakaami?” Leeɡ̶odi joɡ̶oyowooɡ̶odi niɡ̶iniaaɡ̶iniwa Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Odaa Jesus jeɡ̶enagi miditaɡ̶a, naɡ̶a dibate ijo paon, odaa ja nediatediniwace. Odaa niɡ̶ijoa noɡ̶ojedi idaaɡ̶igote. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jiɡ̶itoatadiɡ̶ida Jesus me dinikeetediogi anodiotibece niɡ̶ijo naɡ̶a yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Igaanaɡ̶a niataɡ̶a me niodaɡ̶a, odaa Jesus jeɡ̶eeteta Simão Pedro, “Simão lionigi Jonas, ademaani caticedi niɡ̶ina eledi metidemaa?” Naɡ̶a niniɡ̶odi meetalo, “Jiɡ̶idaaɡ̶ee Iniotagodi, ɡ̶ademaani. Codaa owooɡ̶oti me ɡ̶ademaani”. Odaa jeɡ̶eete Jesus, “Enice, owieni iniwaxacocoli!” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Odaa Jesus ja igetace, meeteta, “Simão, lionigi Jonas, ida makaami ademaani?” Naɡ̶a niniɡ̶odi meetalo, “Iniotagodi owooɡ̶oti me ɡ̶ademaani”. Odaa jeɡ̶eete Jesus, “Enice, adowetitelogo iniwaxacocoli!” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Odaa jiɡ̶icota me itoatadiɡ̶ida me ige, meeteta, “Simão, lionigi Jonas, ida makaami ademaani?” Odaa Pedro jaɡ̶agecaɡ̶alo leeɡ̶odi jiɡ̶itoatadiɡ̶ida Jesus me ige meeteta, “Ida makaami ademaani?” Odaa Pedro jeɡ̶eetalo, “Owooɡ̶oti inoatawece, Iniotagodi. Owooɡ̶oti me ɡ̶ademaani”. Odaa Jesus jeɡ̶eeteta, “Enice, adowetitelogo iniwaxacocoli! ");
INSERT INTO kbcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Codaa atacolitece niɡ̶ida anejitaɡ̶awa. Niɡ̶ina maleeɡ̶akaami lioneeɡ̶a, adinoeni, odaa jeɡ̶emii anemaani me aaticogi. Pida nigakaami oxiiɡ̶odi, odaa jiɡ̶ixokenitedice ɡ̶abaaɡ̶atedi. Nigenagi eledi, odaa ja igoe ɡ̶abaaɡ̶atedi, ɡ̶adadeegiticogi ane daɡ̶a domeɡ̶emaani me aaticogi.” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus eote niɡ̶ida ligegi me ikee anodaaɡ̶ee Pedro lemeɡ̶egi, me ilecatiditibigimece Liboonaɡ̶adi Aneotedoɡ̶oji. Odaa jeɡ̶eeteta Pedro, “Aniwitici!” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Igaanaɡ̶a noletijo Pedro, odaa ja naditege niɡ̶ijo ane-diotibece Jesus ane daɡ̶axa me yemaa, ina me dilokotiogi. Joaniɡ̶ijaa dawaketeloco elipije Jesus, niɡ̶ijo me niodaɡ̶a me Páscoa me ige Jesus, meetalo, “Iniotagodi, amiijo ica ane ɡ̶adajicitiogi ɡ̶aneloɡ̶ododipi?” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Igaanaɡ̶a naditege Pedro niɡ̶ijo ane-diotibece Jesus lemaanigi, odaa jeɡ̶eetalo, “Iniotagodi, igamaɡ̶aɡ̶odaaɡ̶eeta lewiɡ̶a ina ɡ̶oneleegiwa?” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Naɡ̶a niniɡ̶odi Jesus, meeteta, “Aɡ̶ica anenitege nige jemaa me yewiɡ̶a nigepaaɡ̶icota me idopitijo. Pida akaami leeditibige maniwitici!” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Odaa jiɡ̶igotice enalaɡ̶aneɡ̶egi miditaɡ̶a niɡ̶ijo anodiotibece Ǥoniotagodi, modi me daɡ̶a yeleo niɡ̶ijo lemaanigi Jesus. Pida aniɡ̶idaaɡ̶eyatedigi ligegi Jesus, onexaaɡ̶eeteda, “Aɡ̶ica anenitege nige jemaa me yewiɡ̶a nigepaaɡ̶icota me idopitijo.” ");
INSERT INTO kbcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Niɡ̶ijo ane-diotibece Jesus lemaanigi joaneɡ̶epaa yeloɡ̶odi niɡ̶inoa notaɡ̶a, codaa jeɡ̶epaa iditedini, codaa jowooɡ̶otaɡ̶a mewi niɡ̶inoa aneetalo. ");
INSERT INTO kbcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ijoa owidi eletidi Jesus loenataka. Diɡ̶idiwatawece diniditedini, ejitibige me daɡ̶a domaɡ̶abo niɡ̶ina iiɡ̶o niɡ̶icoa notaɡ̶anaɡ̶axiidi daɡ̶a diniditedini ijoatawece loenataka. Odaa jiɡ̶idaaɡ̶ee. (Amém).");
INSERT INTO kbcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jidikotacibigaɡ̶aji, iniotagodi Teófilo. Niɡ̶ijo naɡ̶a jidi naɡ̶ajo odoeje notaɡ̶anaɡ̶axi, jiditini anodaaɡ̶eeteda Jesus, ijoatawece ane loenataka codaa me liiɡ̶axinaɡ̶aneɡ̶eco maleeka dinojogotedini meote ane libakedi. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jiditedini notaɡ̶a aneetece libaketedi Jesus neɡ̶epaa niɡ̶ijo noko Aneotedoɡ̶oji naɡ̶a yadeegitedibigimece ditibigimedi. Maleediɡ̶icatibige doɡ̶opitedibigimece ditibigimedi Jesus ibake loniciwaɡ̶a Aneotedoɡ̶oji Liwigo me iiɡ̶e niɡ̶ijoa liiɡ̶exedi, niɡ̶ijoa ɡ̶oneleegiwadi ane iolatedicoace. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yeleo pida niɡ̶idiaaɡ̶idi ja yewiɡ̶atace, odaa icoatigilo cwareenta nokododi elioditibece me dinikeetediogi niɡ̶ijoa ɡ̶oneleegiwadi, dinikeetediogi mewi naɡ̶a yewiɡ̶atace. Onadi odaa aɡ̶alee yakadi me nawienatakanaɡ̶a naɡ̶a yewiɡ̶atace. Niiɡ̶axitediniwace anodaaɡ̶ee Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali oko. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ica me yatecoɡ̶o, odaa Jesus ja imonya, meetediogi, “Jinoɡ̶otace anotiticoace we nigotaɡ̶a Jerusalém, pida aliitegetiwaji ane ligegitedaɡ̶awa Eiodi me yajigotedaɡ̶awa, niɡ̶ijo baaniɡ̶ijo mejitaɡ̶awatiwaji. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","João Batista nilegetiniwace oko datika ninyoɡ̶odi eotibige me ikee noɡ̶odinilaatece libeyaceɡ̶eco, codaa moyemaa Aneotedoɡ̶oji me iiɡ̶e laaleɡ̶enali. Pida nige ixomaɡ̶atedijo onateciɡ̶idiwa nokododi Aneotedoɡ̶oji Liwigo dakatiwece ɡ̶adaaleɡ̶enali, odaa ja ɡ̶adiiɡ̶enitiwaji.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ica me yatecoɡ̶o niɡ̶ijoa liiɡ̶exedi Jesus, odaa jonoɡ̶oige, moditalo, “Ǥoniotagodi, domige naɡ̶a natigide ica me ɡ̶odoɡ̶aaɡ̶egitice mejonaɡ̶ateloco loniciwaɡ̶a romaanotedi, odaa jaɡ̶awii okomaɡ̶a ɡ̶oninionigi-eliodi?” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Naɡ̶a niniɡ̶odi Jesus, odaa meetediogi, “Aneotedoɡ̶oji ibake naɡ̶atetigi mepaa nibikota noko codaa me lakata nigeote niɡ̶ida anenita, pida aɡ̶akatitiwaji mowooɡ̶oti niɡ̶ica noko nigicota. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pida nige dinikatini Aneotedoɡ̶oji Liwigo me dakatiwaɡ̶ajitiwaji, odaa yajigotaɡ̶awa ɡ̶adoniciwaɡ̶a. Odaa akaamitiwaji jaɡ̶akamaɡ̶akaami nakataɡ̶anadi codaa me enitici. Odaa jeɡ̶eniticitiwaji digoina nigotaɡ̶a Jerusalém, digoida nipodigi Judéia, nipodigi Samaria, codaa me niɡ̶inoa eletidi nipodaɡ̶a ane daɡ̶axa me leegitalo.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Igaanaɡ̶a nigotedini niɡ̶ijoa Jesus lotaɡ̶a, odaa Aneotedoɡ̶oji ja yadeegitedibigimece ditibigimedi. Odaa ja dakatediwece ica lolaadi, odaa aɡ̶aleeɡ̶icoa monadi. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eɡ̶idaa diiticogi Jesus migo ditibigimedi, idiaaɡ̶idi idokee moiwitibigimece ditibigimedi, codaaɡ̶onida noɡ̶onadi icoa itoataale ɡ̶oneleegiwadi ja dinikeetiogi. Niɡ̶icoa ɡ̶oneleegiwadi one odinixotinigilo nowoodi lapacoɡ̶ogoli, dabiditiniwace liwai niɡ̶ijoa liiɡ̶exedi Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Odaa modi, “Akaamitiwaji, ɡ̶oneleegiwadi anicoɡ̶oticogi nipodigi Galiléia, igame leeɡ̶odi maleeɡ̶inaaɡ̶oni awinitibigimece ditibigimedi? Aneotedoɡ̶oji ja yadeegi Jesus digoida ditibigimedi, odaa jiɡ̶inaa ɡ̶adoyaatetiwaji digoina. Pida niɡ̶ijoa Jesus icota me dopitedijo digo anodaaɡ̶eeteda mopitedibigimece ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Odaa niɡ̶ijoa liiɡ̶exedi Jesus naɡ̶a dopitiniwace moicoɡ̶otibigimece lojotaɡ̶adi ane liboonaɡ̶adi “Lojotaɡ̶adi Oliveira”, odaa jiɡ̶igotibeci nigotaɡ̶a Jerusalém one onadateci ciloomito me yototice niɡ̶ijo lojotaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Noɡ̶odakatiwece nigotaɡ̶a, odaa jiɡ̶igotibeci minitaɡ̶a ica dalaɡ̶ate diimigi ane lotokaɡ̶adi. Niɡ̶icoa ɡ̶oneleegiwadi anidiaaɡ̶iticoace one: Pedro, João, Tiago, André, Filipe, Tomé, Bartolomeu, Mateus, Tiago ane lionigi ica Alfeu, Simão niɡ̶ijo ane domaɡ̶a ideleɡ̶e romaanotedi, icaaɡ̶ica Judas ane lionigi ica eledi Tiago. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Elioditibece me yatecoɡ̶o moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji awatege niɡ̶ijo nioxoadipi Jesus, ajo eliodo, ijaaɡ̶ijo eledi iwaalepodi. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Niɡ̶ijoa nokododi yatecoɡ̶o ejime onaniteci taalia niɡ̶igo viinte anoyiwaɡ̶adi Ǥoniotagodi. Odaa Pedro ja dabiditini liwigotigi, odaa jeɡ̶ee, ");
INSERT INTO kbcNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Inioxoadipi, leeditibige micota niɡ̶ijo aneeta Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi aneetece analee ninyaagi Judas. Aneotedoɡ̶oji Liwigo eo inionigi-eliodi Davi me eetece analee ninyaagi Judas niɡ̶ijo jotigide. Niɡ̶ijo me ikeetiogi neloɡ̶ododipi ane diɡ̶etedigi Jesus eotibige moyakadi moniwilo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas eledi ijo me ɡ̶odokaaɡ̶edi me jiwaɡ̶atibece Ǥoniotagodi, aaɡ̶aɡ̶a iomaɡ̶aditedice meo libakedi digo mokotaɡ̶a idokida ɡ̶obakedi.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas dinoojeteta nipodigi. Ibake niɡ̶ijoa dinyeelo ane dinigaanyetece me yajigo Jesus modibatalo neloɡ̶ododipi. Odaa miditaɡ̶a niɡ̶idi nipodigi, jiɡ̶idiaa lemaɡ̶adi, datope le, icoa liwenadi daxoitedice igotinigi iiɡ̶o. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iditawece niɡ̶eladimigipitigi nigotaɡ̶a Jerusalém oyowooɡ̶odi ane ninyaagi Judas. Joaniɡ̶idaa leeɡ̶odi mowo me liboonaɡ̶adi niɡ̶idi nipodigi, “Aceldama”, nioladi hebraico, amina anejinaɡ̶ata “Nipodigi ɡ̶odawodi”. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro eɡ̶idaaɡ̶ee me dotaɡ̶a, odaa jeɡ̶ee, “Niɡ̶ida ane ninyaagi Judas diniditeloco Aneotedoɡ̶oji lotaɡ̶anaɡ̶axi, digoida liwai niɡ̶ijoa enaco, mee niɡ̶ijo nidigo, ‘Leeditibige liɡ̶eladi niɡ̶ini ɡ̶oneleegiwa micota me dinaladi, codaa aɡ̶aleeɡ̶ica anigo diɡ̶eladetigi.’ Codaa eledi diniditeloco niɡ̶ijo liwai lotaɡ̶anaɡ̶axi Aneotedoɡ̶oji, ‘Leeditibige eledi oko me waxodi limedi, codaa meo niɡ̶ijo ane libakedi.’ ");
INSERT INTO kbcNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Enice leeditibige me jiolaaɡ̶atice eledi oko me waxodi limedi Judas me nakataɡ̶anaɡ̶a me naɡ̶a yewiɡ̶atace Ǥoniotagodi Jesus. Leeditibige me jixipenaɡ̶atice oko minoataɡ̶a niɡ̶inoa ɡ̶oneleegiwadi ane akaaɡ̶ina mokotaɡ̶a niɡ̶ijoa nokododi Ǥoniotagodi Jesus maleeɡ̶iniwa mokotaɡ̶a, niɡ̶ijoa nokododi naɡ̶a nilegetiniwace João Batista niɡ̶ijo oko, neɡ̶epaaɡ̶icota niɡ̶ijo noko Aneotedoɡ̶oji naɡ̶a yadeegitedibigimece Jesus ditibigimedi.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Odaa joɡ̶oniboonaɡ̶ateetiniwace itoataale ɡ̶oneleegiwadi, José anoyatigi me Barsabás, codaa nikoxeedi me “Niɡ̶ijo ane iɡ̶enaɡ̶a”, ijaaɡ̶ijo eledi ɡ̶oneleegiwa ane liboonaɡ̶adi Matias. ");
INSERT INTO kbcNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Niɡ̶idiaaɡ̶idi niɡ̶ijo lapo joɡ̶oyotaɡ̶aneɡ̶e Aneotedoɡ̶oji, moditalo, “Ǥoniotagodi Aneotedoɡ̶oji, owooɡ̶otitiwece laaleɡ̶ena okanicodaaɡ̶ica oko. Enice natigide anikeenitoɡ̶owa anigepidiɡ̶ica niɡ̶idoa itoataale ɡ̶oneleegiwadi ane aolaatice meote libakedi me ɡ̶adiiɡ̶exegi, me waxodi limedi Judas me liiɡ̶exegi Ǥoniotagodi, leeɡ̶odi Judas jiɡ̶igo miditaɡ̶a anepaa limedi.” ");
INSERT INTO kbcNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Odaa joɡ̶oiwi anepaɡ̶a dinete modibateloco liboonaɡ̶adi, odaa joɡ̶odibateloco liboonaɡ̶adi Matias. Odaa Matias ja dinawanaɡ̶aditege me lokaaɡ̶etedi niɡ̶ijoa oonze ɡ̶oneleegiwadi liiɡ̶exedi Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Niɡ̶ijo naɡ̶a nakatio ica noko anoyatigi “Pentecostes”, ijoatawece niɡ̶ijoa liiɡ̶exedi Ǥoniotagodi yatecoɡ̶o ijaaɡ̶ijo niɡ̶ijo aneiticoace. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Codaaɡ̶ida noɡ̶owajipata ica nayaageɡ̶egi ane igedi digoida ditibigimedi micataɡ̶a niɡ̶ina niocodi ane daɡ̶axa me yoniciwadi. Codaa owajipata niɡ̶ijo nayaageɡ̶egi catiwedi idiwatawece letiidi niɡ̶ijo diimigi anei me nicotiniwace. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Odaa joɡ̶onadi ica ane liciagi ɡ̶alewaɡ̶a ane ilaagitice, odaa niɡ̶ijo ɡ̶alewaɡ̶a jiɡ̶iteloco lacilo oninitecibeci niɡ̶ijoa liiɡ̶exedi Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Odaa Liwigo Aneotedoɡ̶oji ja dakatiogi oninitecibeci, odaa iditawece joɡ̶odotaɡ̶atigilo eletidi iolatedi, oninitecibeci dotaɡ̶atigi eledi ioladi ane diɡ̶ica me dotaɡ̶atigi. Leeɡ̶odi Aneotedoɡ̶oji Liwigo yajigotiogi lixakedi modotaɡ̶atigilo eletidi iolatedi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Digoida nigotaɡ̶a Jerusalém jiɡ̶idiwa anicotiobece judeutedi anele, anoyemaa modoɡ̶etetalo Aneotedoɡ̶oji. Oicoɡ̶oticogi inoatawece eletidi iiɡ̶otedi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Niɡ̶ijo noɡ̶owajipata niɡ̶ijo layaageɡ̶egi ditibigimedi, ica lapo-nelegi niɡ̶ijo noiigi ja dinatecoɡ̶otee. Eliodi me nawelatibigiwaji leeɡ̶odi oninitecibeci yakadi me yowooɡ̶odi niɡ̶ijoa iolatedi anodotaɡ̶atigilo niɡ̶ijoa liiɡ̶exedi Ǥoniotagodi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Eliodi moyopo, odaa modi, “Digawinitiwaji! Idiwatawece niɡ̶idiwa ɡ̶oneleegiwadi ane notaɡ̶anaɡ̶a elatibige nipodigi Galiléia. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Enige, igamodaaɡ̶ee ina me jakataɡ̶a mokotawece jajipaaɡ̶atiogi modotaɡ̶atigilo ɡ̶oniolatedi ane diɡ̶ica moyowooɡ̶odi modotaɡ̶atigi? ");
INSERT INTO kbcNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Niɡ̶ida moko anejilapodaɡ̶a inatecibece oicoɡ̶oticogi niiɡ̶otedi Pártia, Média, Elão, Mesopotâmia, niiɡ̶otedi Judéia, Capadócia, Ponto, codaa me Ásia. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Codaa ina eledi ane jawanaɡ̶atege oicoɡ̶oticogi niiɡ̶otedi Frígia, Panfília, Egito, inaaɡ̶eledi oicoɡ̶oticogi nipodaɡ̶a Líbia anipegitege nigotaɡ̶a Cirene. Idiaaɡ̶eledi baɡ̶a awaligeɡ̶egipi oicoɡ̶oticogi nigotaɡ̶a Roma. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Inatecibece niɡ̶ina oko judeutedi, inaaɡ̶eledi baadaɡ̶a judeutedi, pida onakato Aneotedoɡ̶oji. Idi eledi oicoɡ̶oticogi Creta, inaaɡ̶eledi boɡ̶oicoɡ̶oticogi Arábia. Pida okotawece jajipaaɡ̶ata modotaɡ̶atigilo ɡ̶oniolatedi, modotaɡ̶atigi niɡ̶idiwa ɡ̶oneleegiwadi, moditece niɡ̶inoa Aneotedoɡ̶oji loenataka libinienaɡ̶a, ɡ̶odoxiceɡ̶etedi!” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Odaa niɡ̶ica lapo-nelegi joɡ̶oyopo codaa noɡ̶owikomataaɡ̶a, odaa dinigetiwage, modi, “Amiida ica ane diitigi ida niciagi ane jinataɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pida ica eledi baɡ̶a namenaɡ̶anaɡ̶a, modi, “Niɡ̶idiwa ɡ̶oneleegiwadi ejime nemáɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Odaa Pedro anidiaaɡ̶i miditaɡ̶a niɡ̶ijoa eletidi oonze liiɡ̶exedi Ǥoniotagodi ja dabiditi, odaa dinigetaɡ̶atee me yotaɡ̶aneɡ̶e niɡ̶ijo noiigi-nelegi. Meetiogi, “Akaami ɡ̶oneleegiwadi judeutedi, codaa makaamitawecetiwaji ane ɡ̶adiɡ̶eladi nigotaɡ̶a Jerusalém, atacolitecetiwaji yotaɡ̶a, jeloɡ̶oditaɡ̶awatiwaji anodaa diitigi niɡ̶ida niciagi ananati. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aleetibigetiwaji niɡ̶idiwa ɡ̶oneleegiwadi daɡ̶a nemáɡ̶a, pida anemáɡ̶a. Igaataɡ̶a eka noove lakata me nigoitijo. (Odaa naɡ̶ani lakata aniɡ̶ica ane yemáɡ̶a.) ");
INSERT INTO kbcNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pida niɡ̶ida analee jinataɡ̶a niɡ̶ijo aneeta Joel niɡ̶ijo jotigide, niɡ̶ijo ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, niɡ̶ijo neɡ̶ee, ");
INSERT INTO kbcNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mee Aneotedoɡ̶oji, “Nigicotalo owidijedi nokododi digawini ane jao. Jimonya Iwigo me dakatiogi codaa me iiɡ̶e inoatawece ane latopaco oko. Ǥadionigipi icota moyeloɡ̶oditedibece yowooko. Jaote niɡ̶inoa lionekadi minoa lakataɡ̶a micataɡ̶a daɡ̶a ligeedi, codaa niɡ̶ina ɡ̶anaxokodipi jao me nigeeɡ̶a me jikeetiogi ane jemaa. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jimonya Iwigo me dakatiogi niɡ̶inoa iotaka, ɡ̶oneleegiwadi codaa me iwaalepodi. Odaa joɡ̶oyatematitedibece yowooko niɡ̶icoatigilo owidijedi nokododi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jaote yoenataka libinienaɡ̶a ane jopooɡ̶a digoida ditibigimedi, codaa digoina iiɡ̶o jaote ɡ̶odoxiceɡ̶etedi. Jao micota monadi ɡ̶odawodi, noledi codaa me ɡ̶ocilaɡ̶adi ane nigexaka. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Aligeɡ̶e icota me nexogoteloco, epenai icota me ixagodi micoataɡ̶a ɡ̶odawodi maleediɡ̶icatibige diɡ̶icota niɡ̶ica Noko Ǥoniotagodi Aneotedoɡ̶oji, niɡ̶ica Noko ɡ̶oneɡ̶egi codaa me daɡ̶axa libinienigi nige limedi me iwi anigote niɡ̶ina oko. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Odaa inatawece niɡ̶ina oko ane dipokotalo Ǥoniotagodi Aneotedoɡ̶oji me iwikode, jiɡ̶iniaa aneote Ǥoniotagodi me yewiɡ̶atace.” ’” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro eɡ̶idaaɡ̶ee me dotaɡ̶a, odaa mee, “Akaami noiigitigi Israel, atacolitece yotaɡ̶a! Aneotedoɡ̶oji ikeetedaɡ̶awatiwaji neɡ̶epaa niiɡ̶e Jesus anelatedibige nigotaɡ̶a Nazaré, odaa ja yajigote ane libakeco. Iɡ̶enaɡ̶a mowooɡ̶otitiwaji codaa ayakadi daɡ̶awienatakani me Aneotedoɡ̶oji niiɡ̶e, igaataɡ̶a Aneotedoɡ̶oji ibake Jesus meote loenataka libinienaɡ̶a codaa me ɡ̶odoxiceɡ̶etedi ɡ̶adiwigotigitiwaji, codaa me niɡ̶inoa anetiɡ̶odawelaɡ̶adi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aneotedoɡ̶oji yowooɡ̶odi inoatawece niɡ̶inoa anicota micotece, odaa jiɡ̶ida me lowoogo me ika Jesus me dinajigotedaɡ̶awatiwaji. Odaa jeɡ̶eloatitetiwaji, leeɡ̶odi maniwotitema majici midiwa ɡ̶oneleegiwadi abeyacaɡ̶aɡ̶a moyeloadi niɡ̶ijo noɡ̶oyototedeloco nicenaɡ̶anaɡ̶ate. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pida Aneotedoɡ̶oji yewikatiditace Jesus. Noɡ̶atedice me dawikodetetema némaɡ̶a, leeɡ̶odi némaɡ̶a aɡ̶ica loniciwaɡ̶atelogo Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Igaataɡ̶a Davi meetece Jesus, niɡ̶ijo mee, ‘Idioka limedi me jinadi Ǥoniotagodi me ideite yodoe. Codaa ideite iwai ibaaɡ̶adi me idaxawa, odaa jiɡ̶idaaɡ̶ee aɡ̶ica ane idoɡ̶owikomata. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Joaniɡ̶idaa leeɡ̶odi me ninitibece yaaleɡ̶ena, codaa mejitece notaɡ̶a aneo ɡ̶odinikegi. Odaa jakadi me inibeotege Aneotedoɡ̶oji meote yolaadi me yewiɡ̶atace. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Igaataɡ̶a niɡ̶ida makaami aɡ̶ikani iwigo diɡ̶idiaaɡ̶i aneite liwicidi émaɡ̶aɡ̶a. Codaa niɡ̶ida makaami aɡ̶ikani yolaadi daɡ̶a neladi, lolaadi ɡ̶aotagi anakamokakaami me dibataɡ̶adomi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jaɡ̶akamaɡ̶a awii me jowooɡ̶odi naigi ane yadeegi oko midioka limedi me yewiɡ̶a, codaa eliodi me idinitibeci leeɡ̶odi makaami meetaɡ̶a.’” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Odaa Pedro eɡ̶idaaɡ̶ee me dotaɡ̶a, odaa mee, “Akaami, inioxoadipi judeutedi, ɡ̶adotaɡ̶aneɡ̶enitiwaji jaotibige makaamitawece owooɡ̶oti anejatigi igegi. Niɡ̶ijo ɡ̶onelokodi ɡ̶oneɡ̶egi, inionigi-eliodi Davi yeleo, odaa joɡ̶onaligitini. Anei monaligitini jipecaɡ̶atege codaa niɡ̶ina noko. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davi inaaɡ̶ina niɡ̶ina ane yeloɡ̶oditedibece Aneotedoɡ̶oji lowooko, codaa yowooɡ̶odi niɡ̶ijo Aneotedoɡ̶oji ane ligegiteta. Aneotedoɡ̶oji ligegi meote dibate oko anida aneetege licoɡ̶egi Davi me inionigi-eliodi, digo mijotaɡ̶a Davi me inionigi-eliodi. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davi yowooɡ̶odi niɡ̶ica Aneotedoɡ̶oji anicota meote, odaa jeɡ̶eetece Jesus. Eetece Aneotedoɡ̶oji meote me yewiɡ̶atace Niɡ̶ijoa ane nimonya aneote me ɡ̶odewiɡ̶atace. Jiɡ̶idaa ane diitigi niɡ̶ijo ligegi mee, ‘Aneotedoɡ̶oji aika liwigo midiaaɡ̶i aneiticoace émaɡ̶aɡ̶a. Codaa lolaadi aneladi.’ ");
INSERT INTO kbcNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aneotedoɡ̶oji eote Jesus me yewiɡ̶atace, odaa oko nakataɡ̶anadi naɡ̶a yewiɡ̶atace Jesus. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Odaa Aneotedoɡ̶oji ja yadeegi Jesus me ideite liwai libaaɡ̶adi, miditaɡ̶a nimedi ɡ̶oneɡ̶egi. Odaa Aneotedoɡ̶oji jeɡ̶eote micota niɡ̶ijo ane ligegite Jesus, odaa Aneotedoɡ̶oji yajigote Jesus me yakadi me iiɡ̶e Liwigo. Odaa Liwigo Aneotedoɡ̶oji enagi me dakatioɡ̶oji. Natigide jaɡ̶anatitiwaji, codaa majipaatibece anodaaɡ̶eeta loenatagi Aneotedoɡ̶oji Liwigo. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Igaataɡ̶a Davi aɡ̶opitibigimece ditibigimedi, pida ijaaɡ̶ijo mee, ‘Ǥoniotagodi Aneotedoɡ̶oji meeteta Iniotagodi, “Anicooti iwai ibaaɡ̶adi miditaɡ̶a nimedi ɡ̶oneɡ̶egi nigepaaɡ̶icota mejateloco ɡ̶adoniciwaɡ̶a niɡ̶ina ɡ̶aneloɡ̶ododipi.” ’ ");
INSERT INTO kbcNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Enice inatawece ɡ̶odoiigi Israel, leeditibige moyoowoɡ̶odi. Niɡ̶ijoa Jesus ane iiɡ̶enatakanitalotiwaji moyototedeloco nicenaɡ̶anaɡ̶ate, Aneotedoɡ̶oji eote me Ǥoniotagodi, codaa iomaɡ̶aditedice meote Niɡ̶ijoa aneote maɡ̶aɡ̶a ɡ̶odewiɡ̶atace.” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Niɡ̶ijo noiigi-nelegi noɡ̶owajipatalo niɡ̶ijoa lotaɡ̶a Pedro, odaa eliodi me noɡ̶owikomataaɡ̶a, odaa modita Pedro ijaaɡ̶ijoa eletidi liiɡ̶exedi Aneotedoɡ̶oji, “Akaami inioxoadipi judeutedi, amiida ica ane jakataɡ̶a me ɡ̶onimaweneɡ̶egi me ɡ̶odiwoko Aneotedoɡ̶oji lelaɡ̶a?” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Odaa Pedro jeɡ̶eetiogi, “Akaamitawecetiwaji leeditibige madinilaanitece ɡ̶abeyaceɡ̶eco, codaa me leeditibige moibake Liboonaɡ̶adi Jesus Cristo metiɡ̶adinilegeni amaleeɡ̶aɡ̶a ixomaɡ̶ateetedice Aneotedoɡ̶oji niɡ̶inoa ɡ̶abeyaceɡ̶eco. Odaa Aneotedoɡ̶oji ja yajigotedaɡ̶awatiwaji Liwigo, anakaaɡ̶ida me ligegi me yajigotedaɡ̶awa. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Eote me ligegi me yajigotedaɡ̶awatiwaji Liwigo, codaa yajigotediogi ɡ̶adionigipi, codaa me niɡ̶ina oko ane liɡ̶eladi niɡ̶inoa nipodaɡ̶a ditigedi. Yajigotediogi Liwigo inatawece niɡ̶ina oko Ǥoniotagodi Aneotedoɡ̶oji aneniditediogi menagitibeci midoataɡ̶a.” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro eɡ̶idaaɡ̶ee me dotaɡ̶a, odaa ja najoitiniwace, meetiogi, “Adinenyaɡ̶atitiwaji amaleeɡ̶aɡ̶a ɡ̶adiwokoni niɡ̶ica noko Aneotedoɡ̶oji nige iloikatidi niɡ̶ina noiigi abeyacaɡ̶aɡ̶a!” ");
INSERT INTO kbcNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eliodi oko oyiwaɡ̶adi niɡ̶ijoa Pedro lotaɡ̶a, odaa ja dinilegetibigiwaji. Ejinaɡ̶a domaɡ̶a iniwatadaɡ̶ani miili oko odinawanaɡ̶aditege niɡ̶ijo lapo anoyiwaɡ̶adi Ǥoniotagodi ijokijo niɡ̶ijo noko. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Odaa ijotawece niɡ̶ijo anoyiwaɡ̶adi Ǥoniotagodi idapaɡ̶a diiticogi modeemitetigilo niɡ̶ijoa liiɡ̶axinaɡ̶aneɡ̶eco niɡ̶ijoa liiɡ̶exedi Ǥoniotagodi, codaa oikee me dinemaatiwage, codaa idioka limedi me dinatecoɡ̶otee niɡ̶ina me niodaɡ̶a codaa moyotaɡ̶aneɡ̶e Aneotedoɡ̶oji. ");
INSERT INTO kbcNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Niɡ̶ijoa liiɡ̶exedi Aneotedoɡ̶oji owote owidi ɡ̶odoxiceɡ̶etedi, codaa me niɡ̶inoa ane libinienaɡ̶a, joaniɡ̶idaa leeɡ̶odi ijotawece oko niɡ̶ijo lapo-nelegi odeemiteti