﻿USE sofia;
DROP TABLE IF EXISTS sofia.kaqNT_vpl;
CREATE TABLE kaqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kaqNT_vpl WRITE;
INSERT INTO kaqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jahuen xohtabo toponpaquexon ta Jesucristo David jaa xohtahi non honanai. Jaton hepa coin ta Abraham janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahanen baque ta Isaaque janeya janishqui. Isaaquen baque cahen Jacobo. Jacobon baque cahen Judá. Judapan huetsabo rihbi jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judapan baque cahen Fares betan Zara. Tamara qui jan baquejani rabe ta jaabo qui. Faresen baque sca cahen Esrom. Esromana cahen Aram. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramana cahen Aminadab. Aminadabena cahen Naason. Naasomana cahen Salmon. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonena cahen Booz, Rahaba qui jan baquejani. Boozena cahen Obed, Rut qui jan baquejani. Obedina cahen Isaí. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isainena cahen David, quiquin hapo. Davidinina cahen Salomon, Uríasnen haibo qui jan baquejani. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonena cahen Roboam. Roboamena cahen Abías. Abíasnena cahen Asa. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asana cahen Josafat. Josafatena cahen Joram. Joramana cahen Uzías. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasnena cahen Jotam. Jotamana cahen Acaz. Acazena cahen Ezequías. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasena cahen Manases. Manasesena cahen Amon. Amomana cahen Josías. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasena cahen Jeconías, Jeconías huetsabo rihbi. Babilonia mai janin hapon hiohah ta jano sca jihuenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilonia mai janinxon sca ta Jeconíasnen Salatiel baquejanishqui. Salatielnin baque cahen Zorobabel. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelnina cahen Abiud. Abiudena cahen Eliaquim. Eliaquimina cahen Azor. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorona cahen Sadoque. Sadoquena cahen Aquim. Aquimana cahen Eliud. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudena cahen Eleazar. Eleazarnena cahen Matan. Matamana cahen Jacobo. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobonena cahen José. José ta Marían bene janishqui. María cahen Jesusen mama. Jesus cahen Cristo. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaa rahsi toponpaquehah ta catorce joni jaiqui, Abraham janinxon David caman toponpaquehah. David janinxon sca Babilonia mai janin caníbo caman toponah ta catorce rihbi qui. Babilonia mai janin caníbo janinhax Cristo caman cahen catorce rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo ta nescari cainnishqui. Marían papabaan ta jaton baque hihbojamanishqui, José hinanyahnoxon. Josen bihriyamahiya ta Dios Yoshiman María baque hinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josen hahcama bi jahuen haibo jan bihyaxihqui ma tohoyahi jisxon bihtima shinanscaquin. Bihcatsihyamascaxon bi ponte joni hihxon, jahuen haibojati rabinmacatsihyamaxon, tsoabi yohixonma jenebahinti shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jascajati shinan shinanxon sca namaquen Papan yonoti jisquin. Sanarenenax jaa yonoti yohuani: —Josen. Davidi baquen. Miin haibo María bihresscahue. Bihti qui raqueyamahue. Jahuen xahquin janin nanescai ta Dios baque qui, Dios Yoshiman baquejahah. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bebo baque ta bihyaxihquiqui. Jaa bebo baquen ta jahuen jihuetahbo mahnebohanxon jihuemayaxihquiqui, jato xahbanen sca jaton tiromajanicabo paquenon. Jaa copi tah min jaa Jesus janeya jayaxihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Papan jato yohiha jahuen joi yohinicabaan yohini quescabijaquin janon ta Papan jascajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jaabaan huishani ta nea qui: Jisnahue. Bebaan honanahma bi ta xontaco tohoxon baque bihyaxihquiqui. Cainscaiya ta Emmanuel jaa janeyaxihcanihqui. Emmanuel ta Papa Dios ta noque betanbi hihquiqui hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Namacax mohi sca jaax, caxon jahuen haibo bihquin, noquen Hihbaan yonotinin yohihah quescabijaquin bihresscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Haibo bihres sca jaax bi hahbe hoxayamatahbi, jahuen baque jan bihnon caman. Cainscaiya, jahuen jane sca Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes quiquin hapo jai tian ta Judea mai janinxon Jesusen maman jaa bihnishqui, Belen jema janinxon. Jaatian hocho quehax, bari cainai quirihax, jonibo nocoti. Huishi honanmisbo Jerusalen janin nocoti becani. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Quiquin hapon xoboho mapexon yocacanquin: —Mato judiobaan quiquin hapo baquexo cainhoh tah non jisi jahui. ¿Jahuerahnon hin? Bari cainai quirixon tah non jahuen huishi jisoqui. Jaa copi tah non hahqui raboxonen tisquihahpaquehi jahui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jascaraiboya quiquin hapo Herodes rahte rahteti. Jerusalen janin jihuetaibo rihbi rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jahuen quiquin sacerdoteboya judiobaan quirica honanbo quenamaxon sca Herodesnin jato yocaquin: —¿Jahuerahnonxon Cristo baquexo bihti quin? Yohinahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Judea mai janin, Belen jema janinxon rahan. Jascajaquin ta Papan joi yohinicaton huishanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belen. Mia tah min Judapan mai meha jema qui. Caibo Judea jemabo mia mentan hashoan hani que bi ta mia rihbi jaabo mentan hashoan hani qui. Mia janinhax ta quiquin hapo jayaxihquiqui. Jaan ta heen israel jonibo jihuemayaxihquiqui. Papan joi yohinicaton ta jascajaquin huishanishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nocotaibo quenabohanxon sca honaxonbi Herodesnin yocaquin, sirijaquin honancatsihquin: —¿Jahuentian man jahuen huishi jisoquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Honanxon sca, jato yohiquin: —Belen janin bonahue. Nocotax, sirijaquin honannoxon yocacahnoxahnahue, jahuerahnon hin jaa baquexo. Meraxon hea yohihi sca beribiyaxahnahue, hean rihbi hen jaa bebonxon raboxonen tisquihahpaquehi canon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jascajaquin yohihah, boresscacani. Picoxon nai bejisahtanaibaan bi bari cainai quiri janinxon jisobo huishi xabarihbihi. Xabacanahi cahi, jato bebon cahax, baquexo machi sca nihreneni. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jaa huishi merarihbihax hihti jenimacani. Coin coinscacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nocotax xoboho mapexon jahuen mama Maríaya baquexo meracanquin. Raboxonen nihxon hahqui tisquihahpaquexon, jaton bohnantibo quehpenxon jaa bexonaibo hinancanquin. Oro, hahan hininjatibo rihbi, hininjanoxon hahan rasquitihbo rihbi hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jaatian sca namaquen joi nincacanquin, Herodes janin catima sca Papan jato yohihah. Jaa copi ta jaton main caribinoxon huetsa bahin sca bocannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jaton main boresscaiboya sca, noquen Hihbaan yonoti hahqui sanareneni jahui namaquen Josen jisribiquin. —Catanhue. Jahuen mamayabi baquexo botanhue, Egipto main histon cahax jano jihuehue, hen mia janohax cati yohinon caman. Baquexo rehtenoxon ta Herodesnin benanoxihquiqui —hahquin yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Huenixon sca baquexoya jahuen mama yamebi hioquin. Egipto main nocoti cahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nocotax janobi jihueti, Herodes hihnon caman. Jascari ta Papan joi yohinicaton huishani joi jai quesca jaresscanishqui: Egipto mai janinhah tah hen heen baque quenamaniqui hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Egipto mai janin José cariyamahiya ta hocho quehax jahuibo Herodes janin cayamascanishqui. Hea yohihi joyaxahnahue Herodesnin jato jaipi bi huetsa bahin cahi jaa tecayacahini cahi. Jaton main boresscaibohi honanax sca, Herodes sina sinati. Jato yocacahtipixon, jaatihi basi sca huishi jismenonibo jai honanxon, jahuen sontarobo sca yonoquin. —Belen jema janin jai baquebo rehtetannahue, rabe bari jaibo, hashoan naman hihquibo rihbi rehtetannahue, Belen senen jai jemabo quiha baquebo rihbi rehtetannahue jatihibi —jato jaquin, Herodesnin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaa copi ta Papan joi yohinica Jeremíasnen huishani joi quesca sca janishqui. Jaa joi ta nescari qui: ");
INSERT INTO kaqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá janin ta sai saihihquibo qui. Huinihibo, huaohihquibo hichahi. Raquel ta jahuen baquebo qui huinihiqui. Jenquetsahaxon sirijaquin shinanmatimascai, jahuen baquebo yamahiya, rehtenahbo quen hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Baquebo jascajaquin rehtemanish ta Herodes sca mahuanishqui. Jaa mahuataiya ta Egipto mainxon namaquen Papan yonoti Josen jisnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Caresscatanhue. Israeli main canoxon miin haiboya jahuen baquexo hiorihbitanhue. Baquexo rehtecatsihquibo ta mahuascaiqui —yonotinin jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mohiyahxon sca jahuen baquexoya jahuen haibo boresscaquin. Israeli main cahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nocoxon sca chanihibo nincaquin. Jahuen papa Herodes xohtahi ta Arquelao sca Judea mai quiquin hapo qui, hihqui chanihah Judea mai qui cati raquescai. Namaquen sca, Jano cayamahue yohihi nincacax Galilea main sca cahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nocotax Nazaret janeya jema janin sca jihueti. Jano Jesus jihuescai copi ta Papan huishani joi quescabihi janishqui. Jaa ta Nazareno hihyaxihquiqui hihqui jaa huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jascanihbo cahchiqui sca ta tsoa jano yamahiton nashimanica Juan nihpahonishqui, Judea main. Yohuancanahi cahi nihnichi. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Maton shinan tiromabo jenebahinquin shinan siribo sca bihnahue. Papan mato jihuemati nete ta nea pishca sca jaonahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Papan joi yohinica Isaíasnen huishaxon yohini quesca ta Juan janishqui. Jano tsoa jihuetaitonma tah hen yohuancanahi. Noquen Hihbo hahan jonon bahixonnahue, pontequin bahixonnahue, hih tah hen jai hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juaman ta camelo rani chopajaxon sahuepahonishqui. Histon nihnoxon rihbi yohina bichi quexen jahuen tari pishnexehti. Champobo res ta pipahonishqui, champoya bonajene. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jaa nincaqui sca ta Jerusalen janin jihuetaibo bocannishqui. Judea main jihuetaibo jatihibi, Jordan huean patax jihuetaibo rihbi jaa nincaqui bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juan yohuanai nincaxon, jaton yorabi yohihi jaton hohchabo yohipaquescacanquin, Juaman jato jeneho hihquimatannon. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jano jan jato nashimahi janin fariseobo betan saduceobo rihbi hicha hahqui nocohihnati. Nocohihnataibo jisxon, Juaman jato yohiquin: —¡Rono baquebon! ¿Tsoan mato neno jabaquihrani joti yohihaxquin, Papan mato casticanmis hihquish man jonon? ");
INSERT INTO kaqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Maton shinan tiromabo potaxon shinan siribo sca bihnahue. Sirijaquin shinanax res sca jihuenahue hih ca hen jahihsen. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Noque caya tah non Abrahanen baquebo qui hihyamaribinahue. ¡Man yohinani jascamis! Abraham baquebo jacatsihquin ta nea man jisi macanbo Papan jonijati hahtipahiqui, Abraham baquebo sca janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jihui reranoxon hahcajaquin ta jahuen yami bihxon Papan tarescaiqui. Bimiyosma jihuibo reraxon mapojaquin hahcajaquin ta tiroma shinanyahpabo Papan casticanscaiqui. Shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Maton shinan man pontehiya tah hen jenen res mato nashimahi. Huetsa joni rihbi ta joresscaiqui. Hea mentan hashoan coshi. Jaa hihti siri copi tah hen jahuen sapato boxonti senenyamahi. Jaan ta jahuen yoshin siri mato hinantihiqui. Chihi rihbi ta mato maracantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bimi berobo tsinquixon, chishpo potaquin hahcajaquin ta Papan xecoscaiqui. Jahuen bimi siribo rahsi tsinquixon sca jahuen jano bexojati janin bexojaquin hahcajaquin ta Papan jahuen baquebo tsinquihiqui. Chishpo cahen nocayosma chihin mapojayaxihquiqui —jato jaquin Juaman. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jaatian ta Galilea mai janinhax Jesus noconishqui. Juaman jaa nashimaquin hihquimatannon hihquish, Jordan huean qui jahuí, jano Juaman nashimahi janin. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hea nashimahue hahca bi Juan queenyamahi. —Mian caya hea nashimahue. ¿Mian hea nashimatihi bi min Hea nashimahue hah min hea jai nan? —hihqui Juan. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—Jaabi hea nashimahue. Min hea nashimati ta Papa queenih qui. Papan yohihi jatihibi hean nincanica hihnon hea nashimascahue —Jesusen jascahah, Juaman jeenhahquin. Jeenhahxon, nashimaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hueaman nashimaha Jesus mapescai. Jaatian ta nai cohin potabohanahcamahi quehpemehtaiya bochiquihax nobex botopaquetai quescari Dios Yoshin hahqui botopaqueti jahui Jesusen jisnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naihoh quehax yohuanai rihbi nincacanquin. —Nea ta hahan hen queenai heen baque qui. Hahan tah hen hihti jenimahi —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jaa pecaho ta jano tsoabi yamahi janin Dios Yoshiman Jesus hionishqui. Jordan huean janinhax cahchiho jan canon, hioquin, janoxon sca tiroma yoshiman jahuen shinan tananon. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jano cuarenta neten piyamabahinaxon piyamashinahax hihti picatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hihti picatsihscaiya ta tiroma yoshin sca joxon yohinishqui, hohchamacatsihquin: —Papa Diosen baque hihxon, toa macan toncobo yohihue, piticahinscanon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Papan huisha janin ta nea joi jaiqui: Piti res jaax jihuetima tah man jai. Papan yohihi joi jatihibi nincaqui jihuenahue hih ta Papa janishqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jaatian ta Jerusalen janin sca tiroma yoshiman hionishqui, Papa yocati xobo janin. Xobo mamacanya manimaxon sca yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Papa Diosen baque hihquish, naman paquehue. Jahuen huisha janin ta Papan yohihiqui: Jahuen yonotibaan ta mia coirantihiqui. Jaton mequemanbi ta mia bihinihnicantihiqui, macan qui min joxcorohyamanon —hahquin yoshiman. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—Huetsa Papan quirica janin ta nea jaiqui: Hea cahra hahxoncointihiquin hihxon miin Hihbo Dios tanayamahue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jaatian, tiroma yoshiman boribiquin, queya mahchi janin sca. Manimaxon sca hocho jismaquin jatihibi jemabo jan jisnon. Jaton jahuaborayabi jato jismaquin. Jismaxon yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Min hehqui raboxonen tisquihahpaquehiya tah hen jaa jatihibi mia hinantihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Catanhue, Satanas. Papan huisha janin ta nea joi jaiqui: Miin Hihbo Dios huesti qui tah min raboxonen tisquihahpaquetihi. Jaa huesti tah min nincatihi —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jascajaquin yohihah ta tiroma yoshin caresscanishqui. Jaa xahbanen cahen Papan yonotibo nocohihnati. Nocohihnaxon, piti hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cahchihoh quehax joxon, quiquin hapon sontarobaan Juan bichipi joi nincacax, Galilea main sca Jesus cahi jahui. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret jema janinhax Capernaum jema janinbo sca baneti cahi, hian quexa. Jano Zabulonbo betan Neftalíbo jihuetaibo janin jihuetahbahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaa copi ta Papan joi yohinica Isaíasnen yohini quescanishqui: ");
INSERT INTO kaqNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulon mai janinhahbon, Neftalí mai janinhahbon, jaton hian janin jaibo rihbi Jordan huean hoque quexa jihuetaibon, Galilea main jihuetai judiomabon, ");
INSERT INTO kaqNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bahquish chian jihuetaibaan bi ta hani xaba jiscannishqui. Mahuati qui raquetaibaanbi ta xaba paquenishqui, mahuapan jato bihpanan hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jano ta Jesusen yohimenonishqui: —Maton shinan pontemabo potaxon shinan siribo bihnahue. Papan mato jihuemati nete ta nea pishca sca jaonahiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jaatian sca Galilea hian quetanbahini caquin bi tarrafa pota potahi joni rabe meraquin. Huetsa, Simon. Huetsa, jahuen jochica Andres. Yapa bihnica rabe. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Hehbetanbi bonahue, jonibo sca hen mato tsinquimanon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yohihah ta jaton tarrafa jenebahini caquin chibanbahincannishqui, hahbetanbi sca nichi. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Caribixon sca huetsa rabe rihbi meraquin. Jacobo betan jahuen jochica Juan, Zebedeonen baque rabe. Jaton papa betan nontinxon jaton tarrafa hona honahiton jato merabonaquin. Jaabo rabe sca jascajaribiquin yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jan yohihah, jacahini caquin jaton papaya jaton nonti jenebahinxon Jesus chibanrihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galilea mai janinbo yohihi cahi ta bocannishqui. Jema qui nocotax judiobaan tsinquiti xoboho hihcoxon Papan joi jato honanmaquin. Papan jato jihuemati nete nea pishca sca jaonahi yohixon, hisinaibo jatihibi rohajaxon, yosmabo rohajaxon coshi jato hinanquin, Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jato honanmaxon rohajahiya ta hocho bi res Siria maibo janin jatihibi jaya yohuanchanicannishqui, jano jihuetaibo. Jaa copi ta jaa janin jaton hisinyahpabo hiocannishqui, hihti hisin tenehibo, mesco hisinyahpabo, mahua hisinyahpabo, tiroma yoshiman hihbojahibo, mapo masataibo, yora honanyamajaquetaibo rihbi. Jaa rahsiya behiboya jato rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hihti caibo sca jaa chibani becani, Galilea mai mehabo, Decápolis jemabo janinhahbo, Jerusalen janinhahbo, Judea mai mehabo, Jordan huean hoque quexa quehabo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nocohihnatax hahqui tsinquijaquetaibo jisish ta mahchi janin Jesus manihihnanishqui. Jano tsahotaiya sca ta jahuen haxenicabo jaa patax nincaqui behinihnacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jato haxemaquin ta nescajaquin jato yohinishqui: ");
INSERT INTO kaqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Caibo ta jahuaborajoma quescapah qui, jaton jahuabora shinanyamahi. Jascapahbo ta hahan jenimati jaiqui, jato jihuemaxon Papan jato jahuen jihue hinanyaxihquibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Caibo ta benatihqui. Jascapahbo ta hahan jenimati jaiqui, Papan jato shinanmaquin sirijatihi copi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Caibo ta mehcayahpa qui, hahxonnica. Jascapa ta hahan jenimati jaiqui. Papan ta nai naman meha mai jatihibi jato hihbomayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Papa queenai quescajati ta caibo hihti queenihqui. Papan jato jascajaquintihi quen ta jascapahbo hahan jenimati jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Caibo ta yanapanmisbo qui, huetsahon shinanxon hahxonnicahbo. Jascapahbo ta hahan jenimati jaiqui, jatohon shinanxon Papan rihbi jato hahxonyaxihquibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Caibo ta siri shinanyahpabo qui, hohchati shinanjomabo. Jascapahbo ta hahan jenimati jaiqui. Noquen Papa Dios ta jisyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sinataibo sirijaquin yohuanquihnxon ta caibaan jato sina tantimahiqui. Jascapahbo sina tantimanicahbo ta hahan jenimati jaiqui, Mato tah man heen baquebo qui, Papa jaiya. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Papa queenai quescajaquin man hahcai copi mato tiromajahah tah man tiroma teneti jai. Jascajaquin tenehibo ta hahan jenimati jaiqui, jato jihuemanoxon ta jahuen jihue Papan jato hinanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Man hea nincacoinaiya quesabaan mato hichacax, mato qui tiromahi yohuan yohuanxon, mato tiromajanoxon chibanbonahiya tah man hahan jenimati shinan man jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jenimanahue. Man tenexonai copi Papan mato jahuen hinantibo naihoh bexojaxonai quen hihti coin coini jihuenahue. Jascajaquin rihbi ta Papan joi yohinicabo tiromajacanpahonishqui. Jaa copi mato qui tiromabo tenenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jatihibi jonibaan tashi quesca tah man qui. Tashi jahuijoma sca tah non jenquetsahaxon bi hahquirihbi jahuijatimahi. Jascapa tashin tah non jahuabi tashin hahtimahi. Potati sca tah qui, huinoquin jonibaan jama jamanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mato tah man mai mehabaan xaba qui, jatihixonbi jisti. Mahchi maracahtai jema ta hochoxon jisti qui, jenquetsahax jonetimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Johue quetejaxon rihbi ta tsoanbi quentipan mahpoyamahihqui. Jahuen tsahotinin tah non johue tsahonai, xoboho jaibo rahsichin jahuen xaba jisnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jascajaquin xabajahibo jihuenahue, man sirijaquin shinanxon joni huetsa hahxonai jisxon jatihibichin mato honannon. Man jascapahbohi jisish ta maton naihoh queha Papa qui siripi yohuanyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Papan huishamani joibo hean mato potamahi jahui shinanyamanahue. Moises jan huishamani, texe jahuen joi yohinicabo jan huishamani, jaa joibo mato potamahi tah hen joyamaniqui. Papan joi potamanoxonma bi tah hen jan yohini quescabijanoxon jahui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hen mato yohicoinnon nincanahue. Naiyahpa mai queyonon caman ta Papan huisha quiha ni huesti bero pishca, ni huesti reshpi pishca rihbi manotimahiqui. Jan yohini jatihibi janon caman ta jahuen huisha jascabi jatihiqui, queyocahinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jaa copi ta huesti res Papan noque yohihi joibo potaxon caibo rihbi potamahax mia hashoan naman sca hihyaxihqui. Jascajahax tah man Papan jihuetahbohax bi texe jahuen jihuetahbo mentan hashoan jahuama sca jayaxihqui. Papan yohihi quescajaxon jaxon caibo rihbi jahuen joi haxemahax tah min hihti siri sca min jatihi, Papan jisí. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Fariseoboya jaton haxemanicahbo mentan hashoan nincacoinnica hihyamahax tah man jahuentianbi Papan jihuemati janin nocotimahi. Jaa hen mato yohihi copi Papan joi queyotimahibo shinanbehnoyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Noquen xenibo ta Papan yohinishqui: Min tah min joni huetsa rehtetimahi, hahquin. Jaa copi ta rehtehi joni Papan casticanyaxihquiqui. Jaa joi tah man honanscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Man honanyamani joi sca tah hen heanbi mato nincamahi: Miin huetsa qui min sinataiya ta jaa copi mia casticanti jatiqui. Jointi xahbanen hah min miin huetsa hichaquin jaiya ta tsinquixon mia casticanti jaticaniqui. Shinanjoman hah min hichaquin jaiya tah min jaa copi chihi janin sca cati jaresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jaa copi jahuabora pishca Papa hinancatsihxon shinanhue. Hinani joxon bi jano hinanti janinxon sca miin huetsan mihqui sirijaquin shinanyamahi shinanrenenxon, janobi miin hinanti jenebahinhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Miin hinanti janobi jenebahini caxon miin huetsa pari sirijaquin yohuanquihnax hahbe bexohue, bexohi sirixon sca miin hinanti pishca hinannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mia demandanaiboya bahin caquin bi histon bi res hahbe bexohue, mia tininti janin bomis. Tinintinin mia policia bihmaxon sipo xoboho mia tsahonah tah min hohmis hohmistihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yohicoin tah hen mia jai, jan mia yohihi tihibi copijanoxon caman tah min jano hihtihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tsiniyamanahue Papan mato jai tah man honanrihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hean tah hen nea sca mato yohihi: Haibo jisish hahbetan hihcatsihqui tah min miin jointi janin tsini sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jaa copi miin mecayaho beron mia hohchamahiya jaa miin bero tsecaxon potahue. Jayajoma hihqui siri que ma bi ta mia chihi janin moanma potahah hihti tiroma qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Miin mecayaho mequeman yometsohtax hohchamis hihxon, mextexon potahue. Jayajoma hihqui siri que ma bi ta mia chihi janin moanma potahah hihti tiroma qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Huetsa yohini joi jai: Miin haibo potaxon jahuen quirica hinanhue, min queenyamascai honanahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jascanihbaan bi tah hen hean mato yohihi: Jan tsinihi ma bi miin haibo potaxon tah min mianbi jaa tsinimahi. Huetsa jonin potahi haibo hihquihinax tah min miabi tsiniscai, hohchaya. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Huetsa noquen xenibaan yohini joi rihbi tah man honanscai: Noquen Hihbaan janen quenaxon yohiquin tah min parantimascai. Jahuen janen quenaxon yohihi tihibi tah min hahcointihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jasca janíbaan bi tah hen hean mato yohihi: Noquen Hihbaan janen quenaxon yohitima tah man jai. Jahuabi quenaxonma yohiti tah man jai. Naihoh quehabo quenayamanahue. Jaa ta janoxon Papan yonohi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mai mehabo quenahaxma rihbi yohuannahue. Jaabo ta jahuen hahqui tapiti qui. Jerusalen jema rihbi quenahaxma yohuannahue. Jaa ta quiquin hapon jema qui, Papan raanyaxihquiton jema. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Miin mapo rihbi quenahaxma yohuanhue. Ni huesti boobi tah min joxocahinmatimahi. Huisocahinmati rihbi tah min hahtipahyamahi, ni huestibi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yohicatsihquin tah min yohirestihi. Jeenhihyamahax, Hihyamahi rahan hihreshue hihcoini yohuani. Jahuabora quenati shinanbo ta tiroma yoshiman hinanah shinanbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Huetsa yohini tah man honanrihbihi: Bero copiquin tah min bero poshabahintihi. Xeta copiquin tah min xeta potamatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jascari janíbaan bi tah hen hean mato yohihi. Mia tiromajahahbo bi tenereshue. Mecayaho mia bepasah bi ramiho sca jismahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mia demandanxon miin camiseta mia bichincatsihquiboya, hinanhue. Hinanxon miin coton rihbi hinanhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mia yonoxon, Huesti hora hea papixonhue hahca, rabe hora jaa papixonhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mia yocacah hinanhue. Hea hinantahhue hahca, Nea tah qui hahhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Huetsa yohini joi tah man honanrihbihi: Miin hahbe jihuetaibohon queenxon bi tah min miin rahuibo jistahihmatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jascari janíbaan bi tah hen hean mato yohihi: Maton rahuibohon shinannahue. Mato tiromajahahbo bi jato yocaxonnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jascajaquin jaax tah man maton naihoh queha Papan baquebo man jatihi. Jahuen barin ta jatihibi xabajaxonihqui, siriboya tiromabo. Jaan raanah ta hoi rihbi joxonihqui, siribo betan tiroma jonibaan jene bihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","¿Matohon queenaibohon res man shinanaiya jahua Papan mato hinantihiquin? Coriqui cobrannicabaan bi ta jascajaquin jatohon queenaibohon res shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Maton huetsabo res man Johue hahcaiya, man jaa copi hihti siribo quin? Nahuabo ta jascapah qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hen mato yohihi nincacax shinancoinyahpanahue, maton naihoh queha Papa shinancoinyahpa hihqui quescari. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Caibo yanapanquin hahcoinnahue. Jonibaan jisnon hihxon res man hahmis. Man hahxoncoinyamahiya ta maton naihoh queha Papan mato jahuabi hahxontimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pishinaibo yanapannoxon jato pishca hinancatsihquin, tsoabi yohixonma hinancoinhue, yanapancoinquin. Shinancoinihcamahibaan hahcai quescajayamahue. Jaabaan hinanai ta tsinquiti xoboho jahuibo yohixon bahin cahibo rihbi yohicaniqui, siri joni hihqui shinanahbo hihxon. Nincanahue hen mato yohinon: Jato qui siripi yohuanai pishca res ta jatihiqui. Papan ta jato jahuabi hinantimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jaa copi tsoabi yohixonma hahxoncoinhue, miin huetsa bocabi tah min yohitimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tsoan honanahma bi joni huetsa min yanapancoinaiya ta Papan mia jisiqui. Jaan ta mia hashoan siribo sca hinanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Papa yocanoxon tsinquitax, shinancoinihcamahibo quescayamanahue. Huetsabaan jato jisnon hihquish ta tsinquiti xobohoxon yocati queencaniqui. Jano jonibo huinotai janin nihxon rihbi ta yocati costancaniqui, caibaan jato jisnon hihquish. Nincanahue hen mato yohinon: Papan ta jascapahbo jahuabi hinantimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Papa Dios yocacatsihquish, tsoa jano yamahi janin chiqueho hihquixon, xehpoti xehpoxon, Papa yocahue. Jaan ta mia jisiqui. Mia ta hahxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tsinquixon Papa yocaquin, yanca res joi tsamanyamarihbinahue. Nincacoinyamahibaan hahcai quescajayamaquin. Joi tsamanxon Dios nincamati shinan ta jacanihqui, jascajati que ma bi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jaa copi jaabaan yohihi quescajayamanahue. Man yocarihyamahi bi ta maton Papan jahua man pishinain hihxon honanscaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaa copi nescajaquin yocanahue: Noquen naihoh queha Papan, mia Papa Dios jai honanahbo jahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Miin jihuetahbo non janon, noque hihbojahue. Min nai hoque hahcai quescajaquin neno rihbi hahhue, mia queenai quescabijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nea neten piti noque hinanhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noquen hohcha rihbi sohuahue. Noque qui tiromahibaan bi tah non jaa shinanxonma jato sirijaquin yohuanquihnai. Jascajaquin rihbi noquen hohcha sohuaxon jaa shinanyamascahue, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanasnen noquen coshi tanatihi janin noque hioyamahue, Papan. Satanas noque bihmayamahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Joni huetsa mato qui tiromahi bi jaa tiromahi man shinanxonma sirijaquin yohuanquihnaiya ta maton naihoh queha Papan rihbi man tiromahi shinanyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mato qui tiromahibo man shinanparihiya ta maton hohcha rihbi maton Papan shinanparihiqui. Jaa copi hen mato yohihah quescajaquin yocanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Piti tenecatsihquin shinanihcamahibo quescajayamanahue. Benati hihcamahax ta behcashcahinax huetsapahcaniqui, caibaan jato jisnon hihquish. Nincanahue hen mato yohinon: Papan ta jato jahuabi hahxontimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piti tenecatsihquin jaabaan hahcai quescahaxma bohuexehtax bepanohtax nihnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Man piti tenescai jismaxonma maton Papa huestichin mato jisnon hihxon hahnahue. Jatihibi jisnicahxon ta maton Papan mato hahxonyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mai meha jahuaborabo hichajanoxon tsinqui tsinquiyamanahue. Mai mehabo ta mahsaman pihiqui, yamibo rihbi ta pohihiqui, texe rihbi ta yometsohbo hihquixon bohancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Naihoh caya bexojanahue, jano hicha jayanoxon. Jano ta mahsamanbi pitimahiqui, jahuabi rihbi pohiyamahi, jahuabi rihbi tsoanbi hihquixon bichinyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jano man bexojahi janin tah man maton shinan camatihi. Jaa copi tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Noquen shinan ta noquen bero quesca qui. Noquen bero siripan jisquin hahcajaquin tah non noquen shinan siripan shinanax nichi. Yohuashihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Miin bero tiromayaxon jiscatsihxon min jaamajaquin jisi quescajaquin rihbi tah min tiroma shinaman shinanax yohuashihscai. Jascapa shinanyahpahax tah min bahquish chian baneparihi, hihti yametai janin. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Patoroyapascaxon tah min jaa sirijaquin teexonhanan huetsa patoro rihbi jaatianbi sirijaquin teexontimahi. Huetsa queenxon bi tah min huetsa sca jistahihmatihi. Jascayamaxon tah min huetsa sca hahxonquin sirijaxon bi huetsa rihbi nincayamascatihi. Jascajaquin rihbi tah man jahuaborabo tsamannoxon jano maton shinan camahahnan, maton Papa Dios teexontimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jaa copi tah hen mato yohihi: Maton piti copi masa shinanyamanahue. Jahua hen piyaxihquin jahua hen xehayaxihquin hihxon masa shinanyamanahue. Jahua hen sahueyaxihquin hihyamaribihi. ¿Pihi res non jihuetain? ¿Chopa sahuenoxon res non yora jain? ");
INSERT INTO kaqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hihsabo jai shinannahue. Jaabaan ta banayamahihqui. Tsinquiyamaquin. Piyanoxon jahuenbi rihbi bexojayamaquin. Maton naihoh queha Papan ta jato coiraniqui. Mato rihbi ta hahxontihiqui. Mato tah man pehiyahpabo mentan hashoan copi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Heen shinaman bi hashoan queyanihpan hihquish bi tah min jahuabi queyanihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Jascajaquin rihbi ta chopa copi masa shinanah yanca res qui. Joa siribo jenquetsax hanihiquin hihxon shinannahue. Jahuabi ta teeyamacaniqui. Toroxahcaxma bi ta siri chopayahpa quesca hihti siribo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hen mato yohinon nincanahue: Quiquin hapo Salomon hicha chopa siribo japahonish bi ta jahuen raotiyahpahax huesti joa betan senenyamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nihi naman joabo hicha joconax cainipi bi tah non huaijaxon jato coharesai, copima copi. ¿Copi que ma bi Papan jato sirijati shinannihxon mato sca jan hashoan sirijaxonti shinantimahiquin? Jaan mato hahxontihi honancoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jaa copi masa shinanyamanahue. Hahrai, jahua non piyaxihquin, Jahua non xehayaxihquin, Jahua non sahueyaxihquin hihxon masa shinanyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nincayosmabaan ta jascajaquin masa shinanihqui. Mato tah man jascajatimahi. Man pishinai ta maton naihoh queha Papan jatihibi honanscaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Papan jihuetahboti pari shinannahue. Jahuen jihuetahboxon jaa queenaijatibo pari shinannahue. Jaatian ta man pishinaibo jaan mato hinantihiqui, jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jaa copi, Bahquish jahua jayaxihquiquin hihxon masa shinanyamanahue. Bahquish jayaxihquibo nocohihnataiya pari tah man jaa tenetihi. Man bahquish teneyaxihqui tah man rahma shinanti pishinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Min hahcai quescajayamaquin caibaan huetsapahaquin hahcai jisish, Jaa ta tiroma joni qui hihyamahue, min shinanai quescajaquin rihbi Papan mia jascajaribixonnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Man huetsa joni jisxon shinanai shinaman ta Papan rihbi mato jascajaquin rihbi yohitihiqui. Man caibo hahxonai quescajaquin rihbi ta Papan mato hahxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Miin bero qui jihui jai bi miin huetsan bero qui jai poto pishca min jistihin? Miin bero qui jai jihui pari shinanhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Miin bero qui jihuinhhuan jaiya miin huetsa min yohitihin, Miin bero qui jai poto pishca hen tsecanon tenehue hah min jatihin? Min tah min jascatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jisyamaxon bi jahuen poto tsecacatsihquin tah min hahcoinicamahi. Miin bero qui jai jihuinhhuan pari potahue. Jaatian tah min jisti hahtipahscaxon jahuen bero quiha jaa poto pishca tsecatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Papa qui hinantibo hochiti qui hinanyamanahue. Maton hihti copibo rihbi cochi hinanyamanahue. Man hinanah, jaa jama jamaxon mato sca picanmis. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Papa Dios yocanahue jan mato hinannon. Manotaibo bena benaquin quescajaquin yocanahue jan mato meramanon. Jahuen xehpoti ton tonhahquin hahcajanahue yocaquin jan mato hinannon. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yocanica rahsichin ta bihtihiqui. Benanicaten ta meratihiqui. Ton tonhahnica ta Papan hinantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Miin baquen mia piti yocacah bi macan sca min jaa hinantihin? Jascapa bebo ta yamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Min mishquitanai yapa mia yocacah min rono hinantihin? ");
INSERT INTO kaqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Man tah man jascapahbo hinantimahi. Jaa copi shinancoinnahue. Tiromaboxon bi maton baquebo siri jahuaborabo hinanti man honanaiya, ¿maton naihoh queha Papan mato hashoan siribo rihbi hinantimahiquin man yocacah? ");
INSERT INTO kaqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jaa copi nea shinan bihnahue: Hea hahxonnahue jacatsihxon jato pari jascajaquin hahxonhue. Moisesnin huishani ta jascarihbi qui. Texe Papan joi yohinicabaan huishani, jascarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Papan bahi qui hihquiti ta hexti pishca qui. Jano hihquinahue. Queyonicabo janin cahi bahi ta hihquiti haniyahpa qui. Jaa bahi ta hihtihosi bahi qui, jahan cahibo rihbi hicha. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Papan jihuetahbo janin cahi bahi ta hexti pishca cainih qui, jahuen bahi rihbi hanitahma pishca. Jahan cahibo ta hicha yamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Papan joi yohiquin bi quesajahibo qui coiramenahue. Maton huetsabohihcamahax ta bemacanya mato quescapahbo qui. Mato paranxon ta mato tiromajascatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jaa copi jenquetsih jihuetihquin hihxon jaton shinan honanquin sirijanahue. Pani moxa quiha ta tsoanbi xexon bimi bihtimahiqui. Bocon jihui quiha rihbi ta tsoanbi binon bimi bihyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jascarihbi ta jatihibi siri jihui bimi siriyahpa qui. Xanascai jihui ta tiromabo bimiyahpa rihbi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Siri jihuin ta jahuen bimi tiromajati hahtipahyamahiqui. Xanascai jihui rihbi ta siri bimiyahpatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bimi sirijoma jihui jatihibi ta Papan reraxon cohayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jascajaquin jaton bimi tanaxon jihui yora honanquin hahcajaquin mato qui nocotaibo honannahue, jaton shinan honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Hea Hihbon Hihbon hahcaibo ta caibo Papan jihue janin nocoyamayaxihquiqui. Heen naihoh queha Papa queenai quescajahibo res ta jano nocotihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jato casticanti nete nocotaiya ta hichaxon hea quenayaxihquiqui: Hihbon, Hihbon. Miin janen tah non jonibo miin joi yohinihqui. Tiroma yoshinbaan joni hihbojahiya tah non miin janen sca jaa tiroma yoshinbo camanihqui. Miin janen tah non hicha hahan rahtetibojaniqui, Hihbon. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jaatian tah hen jato yohiyaxihqui: Mato tah hen jahuentianbi honanyamanihqui. Nenohax botannahue, tiromahibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Caibo jascapahbo copi tah hen nea mato yohihi: Hean yohihi joi nincaxon hen yohihi quescabijaquin hahcai joni ta shinanyahpa qui. Shinanyahpaton hahni quescajanica. Shinanyahpaton ta xobo jihuibo nichinnoxon mixan mai caman poquinxon xobojanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hoi sca ta quexto paquenishqui. Jenenhuan sca jahui. Nihue rihbi coshin bi res jahui. Jene betan nihuen tsahca tsahcaxon bi ta jaa xobo potayamanishqui, mixan mai caman jahuen xobo jihui nichinipi quen. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hean yohihi nincaxon bi hen yohihi quescayama jaibo ta jascapahmabo qui. Jaabo cahen honanma joni quescapahbo. Honanmanen cahen neminma poquinxon mashin xobojanish. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jaatian ta hoi quexto paquenishqui. Jenenhuan jahui. Nihuenhuan rihbi jahui. Joxon jahuen xobo hueranxon poxabahinquin. Champacahinax ta xobo metisihscanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesusen jato jascajaquin haxemaha ta tsinquijaquetaibo rahte rahtenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jaton haxemanicahbaan haxemahi quescajayamaquin bi ta yohiti shinan Papan hinanah jaanbi honanxon jato yohinishqui. Jaa copi rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jato haxemahax, mahchi janinhax botopaquetax jahuiya sca ta hicha jonibo hahqui tsinquijaquexon chibanbenacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jahuiton sca ta huesti sipiyahpa joni behchihi cahax jaa bebonbi betihihpaquexon, yohinishqui: —Hihbon. Mian tah min hea rohajati hahtipahi. Jeenhihxon res tah min hea rohajatihi, Hihbon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sipiyahpa mehexon, Jesusen sca yohiquin: —Jeen. Roha sca jahue —hahquin. Jan yohihitianbi ta sipiyahpa rohacahinnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Hen mia yohinon nincahue. Tsoabi yohihaxma caxon sacerdote jismatanhue. Moisesnin yohini quescabijaquin hinanti pishcaya cahue, rohascaxon hinanti. Jascajaxon tah min jato nincamatihi —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum jema janin sca nococani. Jema janin nocotaiya bi ta sontaro capitan joxon hihti yocanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Hihbon, heen joni ta yoran honanyamajaquetax heen xoboho racatihqui. Hihti hisin ta jaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Hen tah hen rohajahi cahi —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Hea tah hen jahuama qui, Hihbon, heen xobo janin mia mapeti tah hen rabinai. Min rahma nichi janinxonbi yohihue. Min yohihah ta heen joni rohanoxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Hen tah hen honanai. Heen hapon hea yohihah tah hen hahcai. Heen sontarobo rihbi tah hen jai. Cahue hean jaah ta heen sontaro cahiqui. Huetsa hen Johue hahcá ta jahuiqui. Heen joni rihbi tah hen Nescajahue hahcai. Yohihah ta hen yohihi quescajaquin hahquiqui —hahscaquin capitanen. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Capitan yohuanai nincacax ta Jesus rahtenishqui. Chibanaibo sca yohiquin: —Mato yohinon nincanahue. Nescapa shinancoinnica tah hen mato Israeli baquebo merayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mato tah hen yohihi, nincanahue. Hocho quehax ta maton nahuabo beyaxihcanihqui, caibo bari cainai quirihax, caibo bari hihquihi quirihax. Bexon ta Papan jihuetahboxon jahuen jihue janinxon Abraham betan piyaxihcanihqui. Isaaque betan Jacobo rihbi ta fiestajaquin manayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Papan jihuetahbo man hihtihi bi ta bahquish chian mato potayaxihquiqui, jahuen jihuemati quihah. Jano tah man coshin huaohihanan xeta yeres yeresahyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jato jascajaxon, capitan sca yohiquin: —Cahue. Min hihcoinjaquin shinanai quescabijaquin tah hen hahxonai —hahquin. Jaatianbi ta jahuen joni rohacahinscanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jaa pecaho ta Pedron xobon sca mapexon Pedron haita yona yonatai Jesusen meranishqui, hisini racatai. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jahuen mequen qui Jesusen mehehah ta yona tantiscanishqui. Rohacahinax huenixon jahuen haitan jato pitijaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Huetsa neten bepichaiya sca ta yoshiman hihbojahibo hihuecannishqui, hihti caibo. Hisinai rahsi. Yohixon res ta jaton tiroma yoshinbo potanishqui. Hisinaibo rihbi rohajaquin, jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jascajaquin ta Papan joi yohinica Isaiasnen yohini quesca sca janishqui: Noquen hisinbo ta jaanbi bichinxonnishqui. Non hahan hisinaibo jaan potaxonquin hihqui Isaías joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jonibo hahqui tsamajaquetai jisxon: —Hoque quexa canon bonahue —Jesusen hahquin jahuen haxenicabo. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cahi cahiya sca, jaton huisha honan huesti joxon Jesus pataxxon, yohiquin: —Jatihibi janin min cahi tah hen mia manahi catihi, Maestron —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Mari ta mai quiniyahpa qui. Hihsabo rihbi ta nahayahpa qui. Hea cahen jascayamahi. Hea noque baque cahen jano hoxati yamahan —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Huetsa rihbi sca jahuen haxenica jahui. Joxon: —Hihbon, mihbetan capanan tah hen heen papa mahuataiya mihinax pari hen cayaxihqui mihbetan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Hea manahi jotatahhue. Hahbe mahuayaxihquibaan mahuataibo mihinnon jenehue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jaatian sca, nontin nanetaiya, jahuen haxenicabo rihbi hahbetan naneti. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cahiboya sca nihuehnhuan jahui. Behchon hanibo nihuen potajaquetana nonti mahpohah nonti hihquicatsihscai. Hihcax bi Jesus racapaquetax hoxascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mohinxon sca yohicanquin: —Non tah non hihquihi, Hihbon. Noque jahueja ra jaxonhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mohinahbo sca: —¿Jahua jenquetsih man raquetain? Hihcoinai shinanxon bi tah man hicha nincayamahi —jato jaquin. Huenixon sca nihue yohixon hian rihbi yohiquin tantiscahabo. Yohihah, tanticahinscai. Siriscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hian tantihi jisish, rahte rahtecani. —¿Jahuentiho coshiyahpa cohren jaa quin? Hianbocabi ta yohihiqui. Nihue rihbi ta jaan yohihiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hoque quexa sca nococani, Gadara mai janin. Mapetaiya sca jaa behchihi rabe joni jahui, yoshiman hihbojahi joni rabe. Tsahon tocan mehax rabebi jahui, sinabo rabe, hihti coshi. Sinataibo copi ta jano huinotai bahin tsoabi cati hahtipahyamapahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sai saihihxon coshin quenacanquin: —¿Jahuejahi min noque jai jahuin, Diosen baquen? ¿Noque potati nete nocorihyamahi bi min noque potahi joresscain? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jaa hoque tocan ta hicha cochi repinica pihi nihninishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jaa cochibo qui sca hihquinoxon, yoshinbaan hihti yocascaquin: —Noque potaxon, hoa cochibo qui noque raanhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Botannahue, tahca —hahscaquin. Jaa jonibo jenebahini sca cochi qui sca bocani. Yoshin jato qui nocotah, cahi, bishquihihcanahi cahi, tirisihpaquetax jene qui paquetax hahsacani, jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jaton cochi coirannicahbo sca jabacahini caxon jema janin yohibonaquin. Jatihibi yohicanquin, yoshinyahpa hihpahoni rabe rohascai yohirihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yohihahbo picoscacani, jano jihuetaibo jatihibi. Jesus behchihi caxon, meraxon: —Noquen maibo jenebahini catatahtanhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nanetax sca, pohquequihranax Jesus jano jihuepahoni jema qui sca nococani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jano ta yora honanyamajaquetax racatai joni sca Jesus qui hihuecannishqui. Jahuen racatininbi huaquehihnixon hihuecanquin. Jaa jan jato rohajaxontihi shinancoinai jisxon, racatai joni Jesusen yohiquin: —Raqueyamahue, baquen. Miin hohcha tah hen sohuaxonai. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jan jascahiya, jano jai jonibo shinamehti, jaton huisha honanbo. Jaton jointinin yohuancani. Nea joni ta Dios yohuanihcamahi yohuanihqui, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jahua jaton jointinin shinanihquin honanxon, Jesusen jato yocaquin: —¿Jahua copi man maton jointinin tiromajaquin shinanain? ");
INSERT INTO kaqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jahuemeha hashoan teema yohiti quin? ¿Miin hohcha tah hen sohuaxonai hahquin? ¿Huenihihnatax nihaquetanhue hahquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jaabi, noquebaque hihxon hean mainxonbi hohcha sohuaxonti hahtipahi honannoxon, jisnahue —hahxon sca, yoran honanyamajaquetai yohirihbiquin: —Huenihihnaxon miin cacajati bihbahini miin xobon catanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jascahah, huenicahini jahuen xobon cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jaa jisibo ta rahte rahtenishqui. Rahte rahtetax bi noquen Papa qui siriresi yohuancani. —Noquen Papan coshin hahxonai tah non jisi. ¿Yotiho coshi Papan jaa hinanihquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Janohax caxon, tininti cobranxonai joni Jesusen meraquin. Jano tsahoxon cobranti misa janin tsahotaiton meraquin Mateo janeya joni. Meraxon: —Hehbe cahi johue —hahquin. Jascahah, huenicahini jaa manahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jaatian, Mateon xoboho pihi cahax, pihiboya hicha jonibo jato manahi becani, cobranxonnicabo betan hohchayahpabo. Pihi benahue hahca becani. Jahuen haxenicabo betan Jesusen pihiya jato manahi becani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jascapa mesco jonibo jisxon sca, fariseobaan jahuen haxenicabo yocaquin: —¿Jahua copi cobrannicaboya hohchayahpabo betan maton haxemanicahten pihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yocacaibo nincaxon, Jesusen jato yohiquin: —Hisinyamahibo ta rahonnica pishinyamahiqui. Hisinyahpabo caya ta rahonnica pishinihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nea huisha joi jahua hihcatsihquiquin honantannahue: Man joni huetsahon shinanti tah hen queenai. Maton hohcha copi man hea jahuara hinanti tah hen queenyamahi. Jaa huisha honantannahue. Pontebo quenahima bi tah hen pontemabo quenahi joníqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jaa pecaho sca Juaman haxenicabo Jesus qui nocoti. Nocoxon yocacanquin: —¿Jenquetsahpahi noquen non hicha piti tenehi bi miin haxenicabaan piti teneyamahiquin? ¿Jenquetsahpahi fariseobaan rihbi hicha piti tenehi bi miin haxenicabaan piti teneyamahiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jascahahbo Jesusen jato yohiquin: —Jaton huetsa huanomahi caxon ta tsoanbi huanomahanan benáyamahiqui. Huetsatian ta jaton huanomati yamascatihiqui, Papan jato bichinah. Jaatian pari ta piti teneyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Chopa payo honacatsihquin tah non hotsihahma chopa behna bihxon jayaxon coton payo honayamahi. Jayaxon honahah bi ta hotsiscaxon chopa behnapan payo huaxarihbiscatihiqui, hashoan hani sca jahuen huaxa janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Noquen xehati behna rihbi tah non bichi borasa payo qui bochojayamahi. Non bochojaha bi ta xehati pahescaiya borasa pohtoshihtihiqui, noquen xehati yohyocohscanon, noquen borasa rihbi tiromascanon. Behna borasa qui tah non behna xehati bochojahi, rabebi manoyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesusen jato jascajaquin yohihiya bi huesti hapo nocoti joxon, raboxonen tisquihahpaquexon yohiquin: —Heen baque haibo ta rahma hea mahuaxonaxqui. Jaabi cahue. Miin mequeman mehexonhue. Mian mehehah ta teehihribitihiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jan jascahah, huenicahuanax hahbetanbi Jesus cahi. Jahuen haxenicabaan rihbi chibanbahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Bohibaan bi huesti haibo rihbi cahi, Jesus pataxcatsihqui. Doce bari sca jimi pota potahi haibo. Hahchonbi caxon jahuen coton quexa mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jahuen coton res mehehax tah hen rohatihi hihxon, mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jaatian rabejaquexon jaa haibo jisxon, Jesusen yohiquin: —Raqueyamahue, baquen. Shinancoinax copi tah min roha sca jai —hahquin. Jaatianbi ta haibo rohanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jaatian hapon xoboho Jesus mapeti. Rehue hahcaibo betan corotaibo tsamatai meraxon: ");
INSERT INTO kaqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Botannahue. Xontaco ta mahuayamahaxqui. Hoxa res ta jaiqui —jato jaquin. Jato jascahah bi hosan hosancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tsamataibo picohax, chiqueho hihquixon, xontaco mehuetanah, huenicahuani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jan jascajaquin jaa teehihmahah ta jaa mai jatihibi janin yohuanchanicanacannishqui, jano jihuetaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Janohax Jesus cahiya sca benche rabechin chibanxon quenabonaquin. —Noquehon shinanhue, Davidi baquen. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jahuen xoboho Jesus nocotah pecaho sca benche rabe rihbi nocoti. —¿Hen mato hahxonti man shinancoinain? —jato jaquin. —Shinancoinquin rahan, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jaton bero mehexon sca: —Man shinanai quescabi janoxihnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jato yohihah, jisresscacanquin. —Tsoabi yohiyamanahue, mato tah hen yohihi —Jesusen jato jaquin, hihti yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yohiyamahue hahca bi ta janobo jatihibi janin caxon jan jato hahxonah yohibonacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jaa benche rabe jahuen xobo janinhax picotaiya bi ta joyo joni hihuecannishqui, yoshiman hihbojahi joni. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jahuen yoshin potamaha ta yohuanscanishqui. Jaa copi ta tsamajaquetaibo rahtenishqui. —Jascajaquin hahcai joni ta noquen xenibaan jahuentianbi jisyamanishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jascaraibaan bi fariseobo jascayamahi: —Tiroma yoshiman yanapana ta yoshinbo camahihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jano jai jemabo jatihibichin ta Jesus nihnishqui, hani tahma jemabo janin rihbi. Jaton tsinquiti xoboho jato betan tsinquixon jato honanmaquin. Papan jihuemati nete ta nea pishca sca jaonahiqui jato nincamaxon jaton hisinbo jatihibi rohajaquin. Jatihibi yosmahibo sirijaquin rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tsamataibo jisxon ta jahuen jointinin jatohon shinannishqui. Jaan jisi ta tiromajaquin rishquiha quescapahbo jacannishqui. Jaton coirannica yamahiya carnerobo jabisai quescapahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jato jisxon ta jahuen haxenicabo yohinishqui: —Papa bihxonquin tsinquiti ta hicha qui. Tsinquinica bo res ta hichayamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jaa copi tsinquimanica yocanahue hashoan hicha jan raannon, jahuen tee hahxoni behábo. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jaa pecaho sca jahuen doce haxenicabo quenamaxon, hahan yoshin tiroma potati coshi jato hinanquin. Hisinaibo rohajati coshi rihbi hinanxon, yosmahibo coshijati rihbi hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jahuen haxenicabo ta doce janishqui. Jato bebohi ta Simon janeya janishqui, Pedro ca, jahuen jane huetsa. Huetsa cahen Andres, Simoman jochica. Huetsa cahen Jacobo, Zebedeon baque. Huetsa cahen Juan, Jacobon huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Huetsa cahen Felipe. Huetsa cahen Bartolomé. Huetsa cahen Tomás. Huetsa cahen Mateo, coriqui cobrannica hihpahoni. Huetsa cahen Jacobo, Alfeon baque. Huetsa cahen Tadeo. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Huetsa cahen Simon, Cananica hahcaibo. Huetsa cahen Judas Iscariote. Jesus paranxon bihmani. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jaa rahsi jahuen doce haxenica ta Jesusen raannishqui. —Nahuabo qui cahi bahin boyamanahue. Samaritano jemabo janin rihbi boyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Janoboma bi Israeli baquebo qui botannahue. Jaabo ta noquen behnotai yohinahbo qui, carnero hahcaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jato qui caxon yohinahue, Papan jihuemati nete ta nea pishca sca jaonahiqui hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hisinaibo jaiya, jato rohajanahue. Mahuataibo teehihmanahue. Sipiyahpabo rohajaxon sirijanahue. Yoshin tiromabo rihbi potanahue. Mato tah hen jaa coshi hinanresai. Jahuabi copi yohixonma jayaxon jato hahxonresnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jaya cati coriqui bihyamanahue. Coriquijoma tah man catihi, hanibo boxonma coriqui romishin boyamaribinahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jaya cati borasa rihbi tah man botimahi. Coton huetsa boyamaquin. Zapato huetsa rihbi boyamaquin. Mepiti rihbi boyamaquin. Maton tee copi ta nincacaibaan mato pimatihiqui. Jaa copi tah man jaa rahsi botimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jema qui nocoxon jaa hihyamahiya xobo qui nocoxon tsoa jano shinanyahpa joni jaiquin hihxon jato yohinahue. Jano mato Benahue jaibo janin jihuetahxon jato nincamanahue. Caribinoxon caman jaa xobohobi hoxanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Xobo qui mapenoxon jano jaibo yohinahue: Papan mato hahxonnon hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mato Mapenahue jaiboya ta Papan jato hahxontihiqui, man yohihah quescajaquin. Mato Mapenahue jayamahiboya ta Papan jato hahxontimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jano mato nincacatsihyamahibo janinhax caxon, jeman nihxon maton zapato qui hueotai mai poto jato qui tahabahintannahue, jaton mai poto bocabi boyamanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hen mato yohicoinnon nincanahue: Nete queyotaiya ta Sodon jema janin jihuepahonibo casticanxon, Gomorra jema janin jihuepahonibo casticanquin bi hashoan hihtijaquin jaabo mato nincacatsihyamahibo Papan casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jistahi man. Hinobo tocan carnerobo canon quesca tah hen mato raanai. Jaa copi honanbo hihnahue, ronobo honan hihqui quescari. Hihcaxbi joni piyosma nobex hihqui quescari tiromabojatimabo janahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jonibo qui coiramenahue. Mato bihxon ta jaton tinintibo qui mato hinantihiqui. Jaton tsinquiti xobohoxonbi ta mato rishqui rishquiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jaton hapobo qui ta mato botihiqui, jaton quiquin hapobo qui rihbi ta mato botihiqui, man heen jihuetahbo copi. Jano tah man heen joi jato nincamaxon, nahuabo rihbi man nincamatihi, Hen tah hen honanyamanihqui, Hihbon hihyamahabo. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mato bihmahah, masa shinani ¿jahua hen yohitihin, jenques hen jatihin yohuani? jayamanoxahnahue. Papan ta mato yohuanti shinanmatihiqui man jato yohinon. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man jaatian yohuanyaxihqui ta matonahma qui. Dios Yoshin ta maton janaya yohuanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Heen joi nincacai copi ta huetsa jahuen huetsanbi hapobo bihmatihiqui rehtehahbo. Huetsa rihbi ta jahuen papanbi jascajaribitihiqui. Caibo rihbi ta jaton baquebaanbi jato rehtetihiqui, jato qui sinaxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Man heen janen cahi quen ta jatihibichin mato jistahihmatihiqui. Mato jascajahibaan bi ta hen mato jihuemanoxon bihtihi. Hen jonon caman man tenehiya ta hea janin sca Papan mato jihuemayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jaabi, mato tiromahiboya huetsanco botannahue. Yohicoin tah hen mato jai: Israeli jemabo jatihibi janin man cariyamahi bi tah hen joribiyaxihqui, hea noquebaque. Jaa copi tah hen mato yohihi: huesti jema janin mato tiromajahiya huetsa janin sca botannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Haxenica ta jahuen haxemanica mentan hashoan siri hihyamahiqui. Teexonnicah rihbi ta jahuen patoro mentan hashoan hapo hihyamaribihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Maton haxemanica tiromajapahoniboya mato rihbi sca jascajahibaan bi jenimanahue. Maton hihbo tiromajapahoniboya mato rihbi jascajahabaan, heen hihbo jascáhahnibo quesca cahra hea jacanihquin hihquish jenimanahue. Tiroma yoshiman hah ta hea jacanihqui xobo hihbo que bi. Hea jascajahiboya ta mato heen teexonnicahbo hashoan rihbi sca jacantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jaa copi jato qui raqueyamanahue. Jonexon hahcaibo jatihibi ta Papan janibijayaxihquiqui. Jonetax yohuanai joi jatihibi ta jaabo yohuanai Papan janibijaquin nincamayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hen mato yamebo yohihi joibo neten rihbi jato yohiyaxahnahue. Hen baxexi jai joibo rihbi coshin nincamayaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Rehtenoxon caman mato yora tiromajabahinti hahtipahibo qui raqueyamanahue. Maton yoshin ta jahuejati hahtipahyamacaniqui. Mato rehtexon bi maton yoshin rihbi chihi janin potati hahtipahi ta huesti qui. Hahqui caya raquenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Huesti soro copi non rabe hihsa romishin maroyamahin? Copi que ma bi ta huesti res mahuataiya Papan jaa shinanbehnotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Maton boo rihbi ta jahuentihi jaiquin hihxon Papan honanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jaa copi jahua qui raqueyamanahue. Mato tah man hicha hihsa mentan hashoan hihti copi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jonibaan nincanon hihquish Hea tah hen Cristonah qui hihqui jonibo jatihibi ta henabo qui. Heen naihoh queha Papa bebonxon tah hen Jaa ta hena qui hahtihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jonibaan nincanon hihquish Hea tah hen Cristonahma qui hihquibo rihbi ta henamabo qui. Heen naihoh queha Papa bebon tah hen jaabo yohihi, jaabo ta henamabo qui hen hihtihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Joni huetsa betan siripi jihuetaibo rahsi janon hihquish hea jahui shinanyamanahue. Siripi jihuetaibo rahsi janonma bi sinacahinax rehtenanaibo janon tah hen joníqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jahuen papa qui huetsa sinanon tah hen joníqui. Haibobo rihbi ta jaton mamabo qui sinanica qui. Jahuen hihni rihbi ta jahuen yaya qui sinatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Huetsanah ta jahuen jenahaxbi jahuen rahuibo jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jahuen papa sinamis hihquish, jaa hihyamahiya jahuen mama sinamis hihquish hehon queenyamahi joni ta henama qui. Jahuen bebo baque sinamis hihquish, jaa hihyamahiya jahuen baque haibo sinamis hihquish hehon queenyamahi joni ta henama qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hea rehtehibaan bi tah hen heen Hihbaan joi jenetimahi hihxon hea chibanyamahax tah man henabo man hihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Noque rehtecanmis hihxon hea hihbomayamahibo ta jascabiscatihiqui mahuatai. Heen joni jan hihqui copi rehtehibo ta hehbe jihuenica jascabi sca jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mato Benahue hahcaibaan ta hea jascajaribicaniqui. Hea johue hahcaibaan ta hea raanni heen papa jascajaribicaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Papan joi yohinica jan copijahi quescajaribiquin ta jahuen joi yohinica Johue hahcaibo Papan copijayaxihquiqui. Pontejaquin shinanai joni jan copijahi quescajaribiquin ta jaa ponte joni Johue hahcaibo Papan copijayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Heen haxenicaxon copi man nescapa baque pishca jiricatsihquiton jene paxa xehamanixon tah man Papan copijahah bihyaxihqui. Jaa man bihyaxihqui ta jenquetsahpabi manotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jascajaquin jahuen doce haxenicabo haxemaquin queyohax res sca, janohax sca huetsa jeman haxemahi Jesus cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jesusen jahuen coshiyaxon hahcaiya ta sipo xobohoxon joi nincaxon, jahuen haxenicabo Juaman raannishqui yocaqui bohábo. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nocoxon: —¿Hoa jahui joni hen yohini mia quin? ¿Jahui jatihquin huetsa, non mananon? —hahcanquin, Juan chaninoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","—Man jisxon nincacai Juan yohitannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Benchebaan ta jisresscaiqui. Chantobo ta nihresscaiqui. Sipiyahpabo ta rohascaiqui. Pabebaan ta nincascaiqui. Mahuatahbo ta hahquirihbi teehihscaiqui. Jahuaborajomabaan ta joi siri nincaquihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Heen joi nincacoinai joni rihbi ta hahan jenimati jaresscaiqui, jascajaquin yohitannahue —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Boresscaiboya, Juan jahua joni hin honanahbo hihxon jano tsinquitaibo Jesusen yocaquin: —¿Jahua jisi man jano tsoa jaitonma caniquin? ¿Nihuen xayanai tahua jisi man catannihquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Jahua cahra man jisi caniquin? ¿Hihti siri chopa sahuehi joni nan? Hihti siri chopa sahuehibo ta quiquin hapon xoboho pari man meratihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Jahua copi man caniquin? ¿Papan joi yohinica jisi nan? Jaa rahan. Mato yohinon nincanahue. Papan joi yohinicahax bi ta yohinica mentan hashoan coshi joibo jaa jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jaa yohihi ta nea huisha jaiqui: Jise. Mia bebon canon tah hen heen raanti joni raanai. Mia bahi bexojaxoni ta catihiqui, min jahan canon hihqui jaa joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nincanahue hen mato yohicoinnon. Nashimanica Juaman yohihi joi mentan hashoan siri joi yohinica ta jahuentianbi jayamanishqui. Papan jihuetah res ta hashoan siri yohiti jaiqui. Caibo Papan jihuetahbo texe mentan hashoan namanhax bi ta hashoan siribo yohiti jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nashimanica Juan jomenoni bi ta rahma caman jahuen hahbe jihuetihbo Papan coshin tsinquihiqui. Mohi mohinihbaan ta jaa joi histon bichiqui, jahuen jihuetahbocatsihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan yohihi jonon caman ta Cristo jotihi Papan joi yohinicabaan huishaxon yohipahonishqui. Moisesnin huishani janin ta jascarihbihiqui, jaa joi rihbi. Jaa copi ta Juaman jato yohihah histon sca bihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nincati shinanyahpaxon nea nincanahue. Elías janeya ta joyaxihquiqui hahquin ta Papan joi yohinicabaan huishanishqui. Juan ta jaa Elías qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pabinquiyahpaxon nincanahue, hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Rahma jihuetaibo jahua quescapahbo hin hen mato nescajaquin yohinon nincanahue. Baquebo jaabo rahsi shirohi notsihi sinacananai quescapahbo ta jaabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Man bairahnon hihxon non rehue hahcai bi tah man bairahyamahi. Non huinihah bi tah man huaohihyamahi hih ta jacanihqui notsihi. Rahma jaibo ta jascarihbihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Joxon ta piti siribo Juaman piyamanishqui. Xehati rihbi ta xehayamapahonishqui. Jaa copi ta Yoshiman ta jaa hihbojahiqui hihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hea noquebaque joxon tah hen pixon xeharihbihi. Jaa copi yohuanrihbicani. Jise, jaa joni ta pihanhuan qui hih ta jacanihqui. Xehanhuan tah qui. Coriqui cobrannicabo ta jahuen hahberabetibo qui. Hohchayahpabo ta jahuen hahberabetibo qui hihribicani, hea yohihi. Tsoa ponte shinanyahpa quin hihxon tah man joni huetsa jisxon, jan hahcai jisxon man honantihi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jaatian sca jano jahuen coshiyaxon jan jato hicha hahxonrahsihi jemabo sca jaan yohicoinquin, jaton shinan ponteyamahiya jato yohicoinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Hahrai hih tah man jatihi, corazinobon. Hahrai hih tah man jatihi betsaidabon. Mato tocanxon heen coshiyaxon hen hahrasihi quescajaribiquin, Tiro jemanxon hahxon, Sidon jemanxon hen hahcaiya cahen neateman jaton hohcha copi benaxon hahan benati chopa sahuehax chihi mapo mapocohtax tsahoxon jaton shinan pontehan. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaton shinan pontehaxma mahuanihbo casticanxon bi ta mato sca hashoan rihbi Papan casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum janinhahbon, ¿naiho jihueti quescarax maton jema janin jihuetai shinan man jain? Matoyabi ta maton jema panteon hihyaxihquiqui. Heen coshin mato hahxonni jai quescajaquin Sodom jema janin rihbi jascajaxonah cahen rahma caman jaton jema jaquehahniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jaabo tiromabo copi jaton jema Papan yamajabahinni bi ta jahuen casticanti neten jato casticanquin mato sca hashoan rihbi casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jaa pecaho sca Papa yocaxon Jesusen yohiquin. —Hahxon tah min hea jai, Papan. Mia tah min naiyahpa mai hihbo qui. Shinamahnhuanyahpabo betan honanbaan honancasquimanon tah min jato pantexon miin baquebo sca honanmahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mian jisi, jascajaha siri quen tah min jato jascajaxonai, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Papan ta hea jatihibi hinanihqui. Jahuen baque tsoa quin ta tsoanbi honanyamahiqui. Heen Papa huestichin ta honanihqui. Tsoa heen Papa quin tah hen jahuen baque hihxon hea huestichin honanai. Caibaan ta honanyamahiqui. Hea nincacaibaan res ta honanihqui, hean jato honanmahah. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Benahue, teetaibon. Benahue, hihue papihibon, jatihibi. Mato tah hen tantimatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hen mato hihbonon benahue. Hen mato nincamanon benahue, man honannon. Honaxon bi hen mato yohinon. Mah hohmis hohmisai honanai tah hen qui. Benahue, hen mato shinan siricahinmanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Hen mato yonohi quescahah ta teema qui. Hen mato yohihah tah man histon hahtihi. Heen jihuetahbohi benahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jaton tantiti neten sca ta Jesus betan bahin caquin trigo huai nabebacahini caquin, picatsihxon jahuen haxenicabaan huestibo bero pasquebonaxon bishquihahxon pinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jascajahibo jisxon, fariseobaan sca yohiquin. —Jise. Tantiti neten jascajatimahi bi ta miin haxenicabaan bero bichiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jascahah sca: —¿Jahuen jonibo betan caxon, picatsihxon, jahua Davidinin janishquin? ¿Papan joi jisxon man honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Picatsihquish ta Papan xoboho hihcoxon yocacah, Papa pejanxonti paan hinanah bihxon pinishqui. Jaa ta jaan pitima piti qui. Jahuen hahbe cahibaan pitima rihbi. Yohuanxonnicahbaan piti res ta jaa qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tantiti netenbi ta Papan xoboho Papa bebon yohuanxonnicahbo teetihqui. Jaa netenbi jaabo jaton tee jaah ta siri qui, Papan jisi. ¿Moisesnin huishani joi jisxon bi man jaa rihbi honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nincanahue hen mato yohinon. Papan xoboho teeti joi jai copi res ta tantiti netenbi jahoxon teexoncaniqui. Rahma ta jahuen xobo mentan hashoan coshi joiyahpa neno qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","¿Nea huisha jahua hihcatsihquiquin man honanyamarihbihin? Man joni huetsahon shinanti tah hen queenai. Maton hohcha copi man hea jahuara hinanti cah hen queenyamahi. ¿Jaa joi hen jahua hihti quin? Honanxon cah man ponte jonibo qui tiromahi yohuanyamahan. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noquebaquehax tah hen tantiti nete hihbo qui, hah tah hen mato jai, man honannon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Janohax caparihax sca, jaa fariseobaan tsinquiti xoboho nococani. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mapetaibaan bi joni meyosma jano tsahoti. Jesus caheti shinanxon, yocacanquin, jano jaibaan: —¿Tantiti neten non joni rohajatihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jascajaquin yocacahbo jaan sca jato yohiquin: —¿Maton carnero hina tantiti netenbi mai quiniho paquetaiya man bihxon tsecayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Joni ta carnero mentan hashoan jihuemati qui, hah ca hen mato jai. Jaa copi tah non tantiti neten joni huetsa yanapantihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jato jascajaxon meyosma sca yohiquin: —Miin mequen hehqui pontehue. Yohihah, hahqui jahuen mequen pontehax rohascai. Huetsa jahuen mequen hihqui quescapi, siribehcoinscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jaatian picotax, fariseobo yohinani. Jenquetsaha non jatihin jaa rehtenoxon, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Rehteti shinanaibohi honanax, janohax Jesus caresscai. Cahiton sca hihti caibaan chibanbahinscaquin. Jato tocan jai hisinaibo ta jatihibi rohajapaquenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Rohajaxon ta jato hihti yohinishqui, jan jato rahonah tsoabi yohiyamahahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Isaiasnen huishani quesca sca janon ta jato yohinishqui. Jaa joi ta nesca qui: ");
INSERT INTO kaqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jisnahue. Jaa ta hen caisai heen joni qui. Hahan hen hihti queenai heen joni tah qui. Hahan hen jenimahi. Heen yoshin tah hen hinanai. Jayaxon ta jatihibi nahuabo yohiyaxihquiqui, jato hihboscanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tsohbetanbi ta sinacananantimahiqui. Sai saihihima ta qui. Bahin cahibaan nincacah ta jahuabi quenayamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tahua moshitai quescapahbo meraxon bi ta jaan tehcayamahiqui. Lamparin huaxmen nocahax cohinai quescapahbo ta jaan nocajayamahiqui. Quiquin hapoxon jan tiromabo casticannon caman ta jasca jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hahqui ta jatihibi nahuabaan jaton shinan camatihiqui, jaan jato jihuemayaxihqui copi hihqui Isaiasnen huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jaatian ta yoshiman hihbojahi joni hihuecannishqui. Yoshiman hihbojahah benche sca banetax, joyoscai. Jesusen rohajaha jisresscaquin, yohuanrihbiscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rahte rahtetax sca tsamajaquetaibo yohinani. —¿Jaa tsi ra Davidi xohta hihyamahiquin? —hihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nincaxon sca fariseobaan jato yohiquin: —Neatohon ta tiroma yoshiman coshiyahpaxon yoshinbo potahiqui. Beelzebú ta jahuen hihbo qui, tiroma yoshin —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jasca jaibaan bi jaabaan shinanai honanxon Jesusen jato yohiquin: Hapon jihuetahbo jaabo rahsibi rehtenanaiya ta jaton hapon yonoti queyotihiqui. Jema ta jascarihbihiqui. Xobo jascarihbihi. Jaabo rahsibi rehtenanax jahuabi baneyamascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanas hahbe Satanasnen potahah ta Satanasbo rehtenanscaiqui. ¿Jenquetsahax sca jahuen yonoti banetihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Beelzebú coshiyahpaxon tiroma yoshinbo hean potahiya jahua coshiyahpaxon cahra maton baquebaan jato potahiquin? ¿Jenquetsahpa shinanya man quin? Maton baquebaanbi ta mato yohitihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dios Yoshinyaxon hean jato potahi honanscanahue: Papan jihuemati nete ta mato qui noco sca jaiqui, shinanscanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Coshi jonin jahuen xobo coiranaiya jenquetsahax hihcoxon huetsan jahuen jahuaborabo bichintihiquin? Xobo hihbo nexaxon pari ta jahuen jahuabora bichintihiqui. Shinanscanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hehbetan teeyamahax tah man heen rahuibo qui. Hea tsinquixonyamaquin tah man jabisahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jaa copi tah hen mato yohihi: Papan ta jatihibi tiromabo sohuati hahtipahiqui. Jaton shinaman tiromajaquin hahcaibo, Papa qui tiromahi yohuanaibo, jato jatihibi sohuatihiqui, yocacah. Jahuen Yoshin siri qui tiromahi yohuanaibo res ta jato sohuaxontimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hea noquebaque qui tiromahi yohuanaibo ta Papan sohuatihiqui. Dios Yoshin qui tiromahibo ta jascayamahiqui. Jascapahbo ta jahuentianbi sohuatimahiqui. Rahma sohuayamarihbiquin. Nete queyotai bi sohuayamarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jihui honanquin hahcajaquin honannahue. Siri jihui tah qui hih tah man jai, siri bimiyahpahi honanax. Tiroma jihui tah qui hih tah man jaribihi, tiromabo bimiyahpahi honanax. Jahuen bimi honanxon tah man jahuen yora yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jascajaquin rihbi hea honannahue, rono janayahpabon. ¿Jenquetsahax man tiromabohax siripi yohuantihin? Maton shinan tiroma hichahi quen tah man tiroma yohuanyahpabohi. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Siri jonibo ta siri shinan hicha qui, jaa copi siripi yohuani. Tiroma jonibo rihbi tiroma shinan hichahax jaya yohuanrihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hihresi yohuanaiboya ta jatihibi jaton joi tiroma copi Papan jato casticanyaxihquiqui, jahuen casticanti neten. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tiroma yohuan japahonibo ta casticanyaxihquiqui. Yohuan siriyahpabo ta jaton yohuan copi casticantimahiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jaatian jaton huisha honanbo betan fariseobaan yocascaquin. —Maestron. Papan shinan coshiyaxon min hahcai tah non jiscatsihqui, mia Papan raanai joni hihqui honannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yocacahbo sca jato yohiquin: —Tiromaboxon tah man jascajaquin shinanai. Tsiniti shinanyahpaboxon tah man jascajaquin hea yocacai. Papan coshiyaxon hen hahcai man jiscatsihqui bi ta Papan mato jismatimahiqui. Hahan hea honanti mato hinanquin bi ta jahuen joi yohinica Jonas jan huinomani quescapah res huestijaquin res Papan mato jismatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yapahhuahnen xehahah, quimisha nete jahuen poco janin Jonas hihbahinahax quimisha yame rihbi hihshinahax piconi quescarihbihi tah hen noquebaque mai chicho quimisha neten quimisha yame rihbi hea jatihi. Jasca hen jaiya ta hahan hea honanti qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Papan casticanti neten ta Nínive jema janin jihuepahonibaan mato metoxon yohiyaxihquiqui. Jonasen noque yohihah tah non noquen shinan pontenihqui. Jonas mentan hashoan nincati jonin mato yohihah bi tah man nincayamanihqui. Mato tah man noque mentan hashoan nincayosmabo qui hih ta jayaxihcanihqui, man nincayosmabo quen. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Etiopia mai janin japahoni quiquin hapo haibaan rihbi ta casticanti neten mato jisxon jascajaquin rihbi mato yohiyaxihquiqui. Hocho bi res hihquish bi tah hen Salomon yohuanai nincaqui caniqui, Salomonen honanax yohuanai nincacatsihquish. Salomon mentan hashoan honanai jonin mato yohihah bi tah man nincayosmabo qui hih ta jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jan coiranai joni jenehax ta tiroma yoshinbo nihnichiqui, jano hotati yamahi janin nihnichax bi jahuenbi tantitimahiya shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Janohax hen jahui janin caribitanpan, heen xobon, hihcahinax ta caresscaiqui jahuen xoboho. Nocoxon ta hihbojoma siri merahiqui. Matsó siri meraquin, bexojaxonah siri. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaatian sca caxon, hashoan tiromabo yoshinbo rihbi benaxon, siete merahax jaya joribiscai, jano jihuenoxon. Jaatian ta hashoan tiromacanahi sca jaa joni jatihiqui, hicha yoshiman sca hihbojahah. Huestichin hihbojamenoha bi hashoan tiromascai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tsamajaquetaibo haxemahi yohuanparihiya, jahuen mamaya jahuen huetsabo nocoti jahuex jeman nichish hahbetan yohuancatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","—Miin mama betan miin huetsabo ta jeman nichiqui. Mia ta yohuanquihncatsihcanihqui —hahquin huetsan. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jascahah: —¿Tsoa hin, heen mama? ¿Tsoa hin, heen huetsabo? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jato jascajaxon jahuen haxenicabo metoxon: —Jisnahue. Neabo ta heen mama qui. Neabo ta heen huetsabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Heen naihoh queha Papa queenai quescabijaquin hahcai joni ta heen huetsa qui. Jascapah ta heen choca qui. Jascapah ta heen mama qui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jaatian ta hian patax tsahoti Jesus canishqui, xobohoh quehax picotax. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hian quetsahohtaiya sca hihti caibo hahqui tsinquijaqueti becani. Jaa copi ta nontin sca nanenishqui, nontin tsahoxon quexa nichibo haxemanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Haxemaquin ta jaa patax queha joibo jato hicha yohinishqui. Nescajaquin jato yohiquin: Huesti huaijanicah ta jahuen trigo banahi canishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huai chian sca trigo berobo mihsahahbonahi cahi. Mihsahahbonahah cahen caibo berobo bahin paquecanahi. Jascapa ta pehiyahpabaan topiquin queyonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Caibo berobo rihbi cahen chahoma main paquenish. Bemacanya mashi jai. Mai chicho hihyamahax copi cahen jascapa histon joconish. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bari xanascaiya sca cahen joconaibo histon xanahi, mai chicho jaton tapon cayamahiya. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Caibo moxa chian paqueti. Jaabo joconai bi cahen moxan rishquiquin, hashoan hani sca hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Caibo berobo rihbi cahen mai siri janin paqueti. Jaabo cahen joconax, hanihax bimiscai. Caibo cahen huesti bero potahah cien beroyahpascai. Caibo cahen sesenta beroyahpascai. Caibo cahen treinta beroyahpascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hahan nincati pabinquiyahpaboxon nincanahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jaa pecaho sca jahuen haxenicabo jaabo rahsibi Jesus qui caxon yocacanquin: —¿Jahua copi min jaa patax queha joibo res yohiquin jato haxemahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yocacahbo sca: —Papan jihuemati jenquetsahpa quin man honannon hihxon tah hen jaa patax queha joi yohihi. Hoa caibaan nincaxon bi honanyamanon hihxon tah hen jascajahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jaton jointi janin Papan shinan pishca jaibo tah hen hashoan hinantihi, hicha bi res jan janon. Jaton jointi janin jai shinan yamahibo tah hen jaa jaibo pishca rihbi jato bichintihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jaa copi tah hen jaa patax queha joi jato yohihi. Jaatian ta jisquin bi jistimacantihiqui. Nincaquin bi ta nincarestihiqui, honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiasnen huishani joi jai quesca sca ta jaresscaiqui. Pabinquinin nincaxon bi tah man honantimatihi. Beron jisquin bi tah man jistimatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nincayosmaboxon copi tah man jascajatihi. Pabinquiyaxon bi hochoxon nincacai quescajaquin. Jistihi bi tah man bero rahcohi, jismis hihxon. Nincamis hihxon rihbi, jointinin nincaxon, shinan pontehax rohahax jihuemis hihxon tah man jascajahi. hih ta jaiqui Isaiasnen huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jahuerohajaquin tah man jascajaxonma beron jisxon jiscoinai. Jahuerohajaquin tah man pabinquiyahpaboxon nincacoinai. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Man jisibo ta hicha Papan joi yohinicabo jisti queenpahonishqui. Pontejaquin shinanaibaan hihti jiscatsihxon bi man jisi jisyamaquin. Man nincacai joibo hihti nincacatsihquibaan bi ta Papan jato nincamayamanishqui. Jaa copi sca Jahuerohajaquin ta Papan noque jismahiqui, Jahuerohajaquin ta noque nincamahiqui, hihnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bananica joi jahua hihcatsihquiquin mato hen yohinon nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Papan jihuemati joi yohihah bi honanyamahi joni ta bahinbi bero paquetai quesca qui. Jahuen jointi janin banaquin hahcajaquin non nincamaha bi cahen joxon, non yohiha joi tiroma yoshiman bichinbahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chahoma main bero paquetai ta nincamenoxon jenimaxon bichi quescapah qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jahuen tapon chicho cayamahi quesca sca basiyamahi. Jaa joi jan bihcoinai copi caibaan hosan hosanquin. Hosanah sca histon jenescaquin. Masa tenetihi bi jenebahini caresi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Moxa chian paquetaibo ta joi bihcoinxon bi huetsa shinanboya jaxon caijayamahibo quescascai qui. Nincacoinxon bi ta mai mehabaan shinanai quescajaquin shinanxon, jaton jahuaborabo rihbi shinanxon jaa joi caimayamahiqui, bimijoma quesca sca jan janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mai siripan banaha bero ta nincanica joni quescapah qui. Joi nincaxon, jahuen shinaman nincacoinxon, shinan caijaquin. Bero caichi jai quescarihbihi jahuen shinan, caibo quiha cien bero sca, caibo quiha sesenta, caibo quiha treinta. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Huetsa jaa patax quehah joi rihbi ta nescajaquin jato yohinishqui. Papan jihuemati ta bananica jai quesca qui. Jahuen huai chian caxon cahen banaquin jahuen berobo mihsahahbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mihsahahquipish yame hoxahiya sca jahuen rahui jahui. Joxon, jaa huai chian sca banahipibo bero tocan jahuen huasi bero mihsahahbonahax caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo bero joconax hani sca jaax beroyahpa sca jaiya bi cahen huasi jascarihbihi, beroyahpascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Trigo tocan huasi jai jisxon ta jahuen jonibaan sca yocatihiqui: —¿Siri bero rahsi min banayamahohquin, Patoron? ¿Siri rahsi potahi shinanah bi jenquetsahpi huasi sca jaiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jaatian ta jaton patoronen jato yohitihiqui: —Jaa ta noquen rahuin noque jascajanhoxqui —hahquin. —¿Hoa huasibo non mexahi catimahin —hih sca jacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Mexayamaquin rahan. Huasi mexaquin bi jayabi trigo rihbi man mexamis. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jatihibi haninon jenenahue. Trigo tsinquiti tian pari caxon tah non tsinquixonnicahbo yohitihi. Huasi pari mexanahue. Huasi mexaxon nexaxon cohati sca tsamanhihninahue. Trigo bero rahsi sca tsinquixon jano bexojati xobo janin bexojaxonnahue —hah sca jato jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Huetsa jaa patax queha joi rihbi ta jato yohinishqui. Papan jihuemati ta moxo bero pishca jai quescarihbihiqui. Jascapa bero pishca cahen huai chian hihbaan banahah joconi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Caibo bero mentan hashoan hexti pishcahax bi ta joconax hani sca jaax texe banabo mentan hashoan hani sca jaiqui. Jihuiscaiya ta hihsabo joxon jahuen mebibo janin sca nahajatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Huetsa jaa patax queha joi rihbi ta nescajaquin yohinishqui. Paan hahnica haibaan ta jahuen paan soohihmanoxon hahan soohihmati bihnicah qui. Jascapa bihxon cahen huesti paniro tihopa tonco janin niaquin. Jano niahah ta tonco jatihibi soohihtihiqui. Papan jihuemati ta jascarihbihihqui, non honanaima bi hanihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jascapahbo jaa patax queha joibo ta Jesusen jato haxemanishqui, tsinquitax tsamajaquetaibo yohiquin. Jaa patax joibo rahsichin ta jato haxemanishqui. Jayajoma jahuabi jato yohiyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jaa copi ta Papan joi yohinicaten huishani jai quesca janishqui. Jaa patax queha joibo yohiquin tah hen jato haxemahi. Jahuentianbi nincanihmabo joi tah hen jato nincamahi hih ta jaiqui huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tsamataibo potabahini sca Jesus cahi, xoboho hihcohi. Jano rihbi ta jahuen haxenicabo hihconishqui, yocacatsihqui. —¿Huasi bero joi jahua hihcatsihquiquin? Noque yohihue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—Nesca tah qui, jisnahue —jato jaquin.— Siri berobo banahi joni ta noquebaque qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jahuen huai ta nai naman yohihi qui. Jahuen bero siribo ta Papan jihuetahbo qui. Huasibo cahen tiroma yoshiman jonibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jahuen rahui cahen Satanas. Jahuen tsinquiti tian cahen nea nete queyotai hihcatsihqui. Jahuen tsinquixonnicahbo cahen Papan yonotibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jascarihbihi, huasi mexaxon cohahi jaibo quescarihbihi ta nea nete queyotaiya jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noquebaque hihxon tah hen heen yonotibo raanyaxihqui. Caxon ta hohchamanicahboya tiromajahibo tsinquiyaxihcanihqui. Jascapahbo ta Papan jihuematima janin boyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jato boxon ta johuehihnatai chihi janin jato potayaxihcanihqui. Jano ta sai saihihyaxihcanihqui. Jaton xeta yeres yeresahquin, hisin tenequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jaatian ta bari coshi xaba jai quescarihbihi, Papan jihuetahbo siribo coshi shinanyahpa hihyaxihcanihqui, Papan jihuemati janin. Pabinquiyahpaxon nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Papan jihuemati ta nahue chian tsama coriqui jonenoxon mihinnihbo quescapah qui. Jaa mihinnihbo meraxon cahen huetsa jonin mahporihbihax hihti jenimahi caxon jan jai jatihibi maromatihi. Maromaxon ta coriqui bihxon jahan sca jaa nahue marotihiqui, jaa mihinnihbo jahuenah sca hihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Papan jihuemati ta marocatsihquin moro copibo benahi maronica nihnichi quescapah rihbi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huesti moro hihti siri, hihti queenti siri meraxon cahen caxon jan jai jatihibi maromaxon sca jaa moro siri maroscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Papan jihuemati ta tarrafa quesca rihbi qui. Tarrafa cahen hian janin potaxon mesco yapa rahcocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bochoscaiya ninixon mapemaxon yapa tsecapaquescacanquin. Tsecapaquexon caispaquecanquin. Tsahoxon sca tasa qui siribo nanehihniquin, tiromabo potapaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nete queyotaiya ta jascaja rihbi Papan jayaxihquiqui. Joxon ta Papan yonotibaan tiromabo bihyaxihcanihqui, siribo tocan nihyamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Johuehihnatai chihi janin ta jato potayaxihcanihqui. Jano ta sai saihihyaxihcanihqui. Xeta ta yeres yeresahyaxihcanihqui, hisin tenequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—¿Hen mato yohihi jatihibi man nincaxon nincacoinain? —jato jaah: —Nincaquin rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—Jaa copi tah man Papan jihuetahbohax jahuen jihuetahbo haxescaxon caibo rihbi sca man haxematihi. Jaatian tah man hicha jahuaborayahpa hani patoro quesca man jatihi. Jascapah cahen jahuen bexojati chiqueho caxon behnaboya xenibo siribo cainmatihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jascajaquin jaa patax queha joibo jato yohiquin queyohax, janohax Jesus cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jahuen main cahi. Cahi nocotax jaton tsinquiti xoboho mapexon janoxon jahuen caibo Papan joi yohiquin. Jaan jato haxemaha, rahte rahtecani. —¿Jahuerahnon haxenihxon hen neatohon yotiho honannishquin? ¿Jenquetsahaxon coshi bihxon jonibo rohajahiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Xobojahnicaten baque ma hin? ¿María janeya jahuen mama ma quin? ¿Jacobo, José, Simon, Judas jahuen huetsaboma quin? ");
INSERT INTO kaqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Jahuen chocabo jatihibi noque betanbi jihueyamacaniquin? ¿Jahuen sca hen jahuen shinan bihnishquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaa copi nincacoinyamacanquin. Nincacoinyamahibo copi sca Jesusen jato yohiquin: —Papan joi yohinicahon huetsancohabo queenaibaan bi ta jahuen mai janinhahbo jahan queenyamacaniqui. Jahuen jenabo, jahuen xobo janinhahbo, jaabo jahan queenyamarihbihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nincayosmabo copi ta jahuen coshiyaxon jaton jema janin jato hicha hahxonyamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Janobo jahuen coshiyaxon Jesusen jato hahxonai ta caibaan sca quiquin hapo Herodes yohinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—Nashimanica Juan tah qui. Yamanicahax bi ta hahquirihbi teehihscaiqui. Jaa copi ta coshiyahpa qui —hih sca Herodes jai, Jesus yohihi. Jahuen jonibo betan yohuani ta Herodes jascanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Neateman Juan rehtehox copi jascari yohuani. Jasca jayanoxon pari ta Juan bihxon sipo xoboho Herodesnin tsahonnishqui, Herodesnin huetsan haibo Herodias copi. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jaa ta miin haiboma qui. Min tah min hahbetan tiromahi, Juaman yohihah copi sipo xoboho tsahonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Juan rehtecatsihxon bi jonibo sinamis hihxon rehteyamaquin. Jaa ta Papan joi yohinica qui hihquiboya sinacanmis hihxon rehteyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jahuen bari senenjahiya ta xehahibo Herodesnin xehaquihnnishqui. Jahuen haibaan baque haibo chirinai jisxon, Herodesnin costan costanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Costanxon, Dios quenaxon sca jaa xontaco yohiquin: —Min queenaibo hea yocareshue. Mia tah hen hinantihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Juaman mapo yocahue jahuen maman jaá sca, jahuen mama queenai quescajaquin xontaconen yocaquin: —Juaman mapo quencha qui nanexon hea bexonahbo yohihue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Xontaconen yocacah sca quiquin hapo benacahinscai. Min yocacai tah hen mia hinantihi hahxon bi masa shinanscaquin. Masa shinanxon bi Dios quenaxon yohixon copi jeenhahquin, hichaxon nincacaibo jai copi rihbi jeenhahquin. —Textetannahue —hahquin jato. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Caxon sca sipo xobohoxon bi Juan textecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Quencha qui sca jahuen mapo nanexon, bexon, xontaco hinanquin. Jaan sca jahuen mama hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juaman haxenicabo ta jahuen yora bichi bocannishqui. Bihxon mihinquin. Mihintani joxon, Jesus yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yohihahbo nontin nanetax janobihax Jesus cahi. Jano tsamataibo yamahi janin jahuen haxenicabo betan yohuani cahi. Jano tsoa yamahiton nocoti cahi. Jano ta Jesus cahiqui chanihibo nincacax sca, jano jai jemabo janinhax tsama jonibo cahi. Hian quetanbahini sca Jesus chibani bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Taxnatax mapexon jonibo tsamascai Jesusen meraquin. Jatohon hihti shinanxon, jaton hisinbo rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bepiscaiya joxon jahuen haxenicabaan yohiquin: —Neno ta tsoabi jihueyamahiqui, Hihbon. Bari rihbi ta hihquicatsihscaiqui. Nea jonibo raanscahue, honobo jai jemabo janin caxon jaton piti pishca maroscatanahbo —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Jahua copi catima ta jacanihqui. Piti jato hinannahue, matonbi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Neno tah non pichca paan pishca res jai, rabe yapa xohi rihbi. Jahua hashoan tah non piti yamahi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Jaa hea bexonnahue —hahquin jato. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","—Janobi tsahopaquenahue —jonibo jaxon, jaa pichca paanya rabe yapa bihxon, nai bejisihnixon, Papa yohiquin. Piti tehcaxon sca jahuen haxenicabo hinanpaquequin, jaabaan sca jonibo hinanhihninon. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pihi yanicahinscacani. Texejahabo tsinquixon doce tasa bocho bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jaa pihibo ta hicha janishqui. Haiboboya baquebo toponyamahah bi bebo rahsi toponah ta cinco mil janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jaa pecaho ta jahuen haxenicabo yohinishqui: —Hean hen nea jonibo camanon nontin nanetax pohquejaquescanahue —hahquin jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tsamataibo camahax sca, jano jai mahchi manihihnati cahi, jaa huesti caxon Papa yocanoxon hihquish. Yamescaiya sca jaa huesti jano baneti. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jahuen nonti pohquejaqueti cahi hochoscai. Behchoman tsahcahah huinahahbo bi cacasquimahi. Nihuen jato behchihah huinacasquimacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xaba jahui hochoma sca hian benichi jato qui Jesus cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hian benichi jahui jisish, jahuen haxenicabo hihti raqueti. Yoshin tah qui hihquish, raquetax sai saihihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jaatian: —Raqueyamanahue. Hea tah hen qui. Rahteyamanahue —hahquin jato. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","—Mia hihxon hea yohihue, Hihbon, hen jene benicanaxon mia behchihi canon —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Johue —jaáh sca picotax jene benichi Jesus qui cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Caquin bi behchon jisish, raquerihbiscai. Jene meran hihquicatsi sca jaax sai saihihquish: —Hihbon, hea bihhue —hih sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mehuetanxon huenihihnixon sca: —Hicha tahma res tah min shinancoinai. ¿Jahua jenquetsahin min shinancoinyamahin? —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nontin nanexon sca nihue tantinon yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jaa jisxon, hahbe cahibaan hahqui raboxonen tisquihahpaquexon: —Mia coin tah min Papa Diosen baque qui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hoque quexa nocotax sca Genesaret jema qui nococani. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Janohahbaan sca jaa nocotaibo jisxon, Jesus honanxon janobo jai jemabo janin quenamacanquin, hisinyahpabo benon hihxon. Jaa copi jascapahbo becanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesus qui caxon, hihti yocacanquin. —Miin coton quexa pishca res hea mehemahue, hen rohanon —hahcanquin. Mehehax res sca hisinyamascai. Siricahin sca jacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalen janinhax sca caibo nocoti becani. Fariseobo betan jaton huisha honanbo. Nocoxon sca: ");
INSERT INTO kaqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Miin haxenicabaan ta mechoquihxonma pihiqui. ¿Jahua copi jascajacaniquin, noquen xenibaan yohini quescajayamaquin? —hahcanquin yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—Maton caya tah man Papa Diosen yohini quescajayamanoxon huetsajaquin jonibo haxemahi. ¿Jahua copi man jascajahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Papan ta yohinishqui: Miin papahon queenhue; miin mamahon rihbi queenhue hahquin. Huetsa rihbi jan yohini: Jahuen papa qui tiromahi yohuanai joni queyocahinnon tah man rehtetihi. Jahuen mama qui tiromahi yohuanai joni jascajaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Papan mato jascajaquin yohinih bi tah man huetsajaquin jonibo yohihi. Jaton mamaboya jaton papabo yanapanyamahabo hihxon tah man jato yohihi, Maton papabo man yanapanpanan Papa Dios hinantijanahue hah tah man jato jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jascajaquin tah man maton haxemati joiyaxon Papan joi nincayamamahi, jonibaan nincapanan. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Nincacoinihcamahibon! Mato yohihi ta sirijaquin Isaíasnen yohinishqui: ");
INSERT INTO kaqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jaton janan nea jonibo hehqui siripi yohuanih bi ta jaton jointinin jahuabi nincayamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nescajaquin Papa Dios hahxonnahue hihxon bi ta jonibaan shinanax yohuanai joi res haxemacaniqui. Jaa copi ta yanca bi res hea yocacaniqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tsamataibo sca Benahue hahxon: —Nincaxon nincaquin sirijanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Piquin non noquen poco janin nanehiton ta noquen jointi rishtajayamahiqui. Noque jointi rishtajahi ta noquen jana janinhax picotaibo qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jahuen haxenicabo sca jaa pataxi becani. Pataxxon sca: —¿Min yohihi nincacax fariseobo sinascai min honanyamahin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Jahuen huai janin jaan banayamani meraxon ta heen Papan mexabahinxon potatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sinaresnon jato jenenahue. Benchexon bi ta bahi jismahi bebobonacaniqui. Benchen hahbe benche hiohax ta rabebi xanqueman paquetihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","—Min noque yohiha jaa patax queha joi, jahua hihcatsihquiquin? Noque yohihue —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Maton rihbi man honanyamaparihin? ");
INSERT INTO kaqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Noquen jana janin hihquihax noquen poco janin huinotax pohi sca jatihibi piti picotihqui man honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Noquen jana janinhax cainaibo ta noquen jointi janinhax cainihqui. Jascapahbaan ta noquen jointi rishtajahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Noquen jointi janinhax cainai ta shinan tiromabo qui. Joni rehteti, tsiniti, haiboya shiroti, yometsohti, joni huetsa qui quesahi yohuanti, Papa qui tiromahi yohuanti. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jascapahbo shinan ta hahan jointi rishtatih qui. Mechoquihxonma piquin bi tah non jascajaquin noquen jointi rishtajatimahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Janohax picotax sca Tiro jema janinbo sca Jesus betan bocani, Sidon jema janinbo cahi, Jesus betan. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jesus nocotai merahax Cananeo haibo sca jahui, jano jihuetai haibo. Quenáhonahi joxon hihti yocaquin. —Hehon shinanhue, Hihbon, Davidinin baquen. Yoshiman hihbojaha ta heen baque haibo hihti hisinihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hihti yocacah bi jahua hihyamahi. Jahuen haxenicabaan sca Jesus pataxxon yohiquin: —Yohihue, jan catannon. Sai saihihanan ta noque chibanbenahiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Noquen nahuabo qui ma bi manotai Israeli baquebo qui res hen jonon ta Papan hea raannishqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jaa bebon sca joxon betihihpaquexon haibaan yohiquin: —Jenquetsaha ra hea jaxonhue, Hihbon. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Baquebo bichinxon hochiti jaton piti hinanah ta tiroma qui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Tiroma rahan, Hihbon. Jaabi ta jaton hihbaan misa janinhax paquetai teque romishin hochitinin piti qui —hahquin haibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Min tah min shinancoinai, haibon. Min yocacai quescabijaquin tah hen mia hahxonai —Jesusen jaquin. Jaatianbi ta jaa haibaan baque siricahinnishqui, rohascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Janohax cahax sca, Galilea hian quetanbahini cahax, mahchi manichish jano Jesus tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hihti caibo jonibo jahui, jaa chibanbenahi. Jaton hisinyahpabo hihuecanquin, chantobo, benchebo, meyosmabo, joyobo, mesco hisinyahpabo hicha bi res becanquin. Jesus bebonbi jato taracanrenencanquin, jato jatihibi rohajascanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jato rohajahiya ta tsinquijaquetaibo rahte rahtenishqui. Joyobo yohuanscai, meyosmabo siricahinscai, chantobo nihresscai, benchebaan jisresscaiya, rahtetax: —Noquen Papa Diosen ta hihtijaquin noque hahxonihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jahuen haxenicabo quenabohanxon sca Jesusen jato yohiquin. —Nea tsinquijaquetaibohon tah hen shinanai. Quimisha neten sca ta nenobi banecaniqui, pihan ta hihcanihqui. Pihaxma cati tah hen jato yohicatsihyamahi. Bahin cahi bi pihaxmahuan hihquish nocoyamacanmis. Jatohon tah hen shinanai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—¿Jahuerahnon non tsoabi jano jihueyamahi janin hicha piti marotihin? Jaabo ta hicha qui —hah sca jacanquin jahuen haxenicabaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Jahuentihi paan man jain? —jato jaquin. —Siete res ta qui. Yapa pishca rihbi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tsamajaquetaibo mihtsahohti yohiscaquin, Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yohixon jaton siete paanya yapa pishca bihxon Papa yohixon tehcapaquexon jahuen haxenicabo hinanquin, jaabaan sca jonibo hinanpaquerihbinon. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pihax yanicahinaibaan bi texejaribicanquin. Texejahabo tequebo tsinquixon siete tasa bocho bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Haiboboya baquebo toponyamahah bi bebo rahsi toponah ta cuatro mil joni janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jonibo camahah cahiya sca ta nontin nanetax Magdala jema janin taxnati bocannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseobo betan saduceobo sca becani. Jesus qui joxon: —Papan coshiyaxon hahhue —hahcanquin, jan hahcai jisxon hahqui chaniscanoxon sca jascajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","—Bepichaiya tah man nai jisish, Nai ta joshinjaquetihqui. Bahquish ta nete siri janoxihquiqui hih man jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Xaba paquetaiya sca tah man nai jisish, Rahma ta hoi nete qui, nai ta joshinihqui hih man jai. Nai jisxon tah man nete yohiti honanai. Nete joibo yohiti honanxon bi tah man Papan hahxonai jisxon jahueja Papan noque janoxihquiquin hihxon man joni huetsa yohiti honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tiromaboxon tah man hea yocacai, hahan honantijaquin Papan coshiyaxon hen mato jismati hea yocaquin. Tsiniti shinanyahpa quescapahbo hihquish tah man hean mato jismati man queenai. Jahuabi hahan honanti ta Papan mato jismatimahiqui. Jonas huinoni quescapa huesti ta Papan mato jismatihiqui —Jesusen jato jaquin. Jato jascajaquin yohihax caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hoque quexa sca Jesus betan jahuen haxenicabo cahi, pohquejaqueti. Caquin bi jaya cati piti shinanbehnobahincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","—Coiramenahue. Fariseobo betan saduceobaan jai hahan paan soohihmati qui coiramenahue. Jistahin man —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","—Non pitijoma jahui copi rah ta noque jascajahiqui —hih sca jacani jaabo rahsibi yohinani. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jahua yohuan jaabo jai jahuen jointinin honanxon sca: —¿Jahua copi man pitijoma non jahui copi rah ta qui hih man jain yohinani, ¿man hihcoinjaquin shinanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Pichca paanyaxon non cinco mil joni pimahipi man shinanbehnoscain? ¿Texejahabo tequebo jahuentihi tasa tsinquihipixon man shinanyamascain? ¿Man honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Siete paanyaxon non cuatro mil jonibo pimahipi man shinanbehnorihbiscain? Texejahabo man jahuentihi paniro tsinquihipi man shinanbehnoscain? ");
INSERT INTO kaqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Fariseobo betan saduceobaan jai hahan paan soohihmati qui coiramenahue, hen mato jaáh ta maton piti copima qui. ¿Jenquetsahpahin man honanyamahin? —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jaatian pari ta honancannishqui. Hahan paan soohihmati jan hihqui bi fariseobo betan saduceobaan haxemahi joi qui coirameti jan yohiha honancanquin. Hahan paanjati jan yohiyamahi honanscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cesarea de Filipo jema janin sca nococani. —¿Hea noquebaque hen jahua joni quin, jahua jacanihquin? —Jesusen jato yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Caibaan shinanah ta mia nashimanica Juan qui. Caibaan rihbi shinanah cahen Elías yamanica. Caibaana cahen Jeremías yamanica. Jaa hihyamahax cahen, huetsa rihbi Papan joi yohinica japahoni —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Maton cahran? ¿Maton shinanah hea jahua quin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Mia tah min noquen Papan caisni joni qui, mia joti neateman jan yohini —hih sca Simon Pedro jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Mia tah min hahan jenimati jai, Simoman, Jonasen baquen. Jonibaan res mia shinanmahama bi heen naihoh queha Papan mia shinanmaha tah min honanai. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mia tah hen Pedro janehi. Mixan main xobojaquin hahcajaquin tah hen heen jihuetahbo rahsi huesti yorajatihi. Min yohiha join jato jihuetahbojaxon tah hen jato huesti yorajatihi. Tiroma yoshiman ta jato teneti hahtipahtimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hahan quehpenti hinanquin hahcajaquin tah hen mia yohihi, min heen jihuemati janin jonibo hihquimanon. Mainxon min jonibo yohiyaxihqui ta Papan yohihah quesca sca jatihiqui, jascabi sca janon. Mainxon min nexabo pecaquin hahcajaquin yohihi rihbi ta Papan yohihi quesca sca jatihiqui —Jesusen Pedro jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jaatian sca Jesusen yohiquin sirijaquin: Hea Cristo hihqui tsoabi yohiyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jaatian pari jato yohimenoxon ta hashoan sirijaquin sca jato yohibenanishqui, jaa mahuayaxihqui honanahbo. Jerusalen janin jaa cati jai, jano jan hicha tiromabo teneti jai, judio hapobaan tiromajahah bi jan teneti jai, sacerdote hapobaan tiromajahah jan teneti jai, jaton huisha honanbaan tiromajahah bi jan teneti jai, tenehax bi jan mahuatihi, mahuatipish bi jahuen quimisha neten sca jan teehihribiyaxahnon jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nincaxon, hahmebi yohicatsihquin Jesus ninibohanxon sca Pedronen yohiquin: —Jascari yohuanyamahue, Hihbon. Papan ta mia jascajatimahiqui. Min yohihi quescaja ta mia jatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pedro bejisxon sca: —Hea jenebahini catanhue, Satanas. Papa queenai quescajayama hen janon hihxon tah min hea pantecatsihqui. Papan shinanai quescajaquinma bi tah min jonibaan shinanai quescajati honanai. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jascajaquin Pedro yohixon, texe rihbi sca jahuen haxenicabo yohirihbiquin: —Hehchon jocatsihxon tah man matobi man queenaima sca man hahtihi. Hea rehtehibaan bi tah hen heen Hihbaan joi jenetimahi hihxon tah man hen mato yohihi quescahijatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mahuati qui raquetaibo ta mahuatihiqui. Jascapahbo jihuetimahi bi ta hea copi mahuataibo queyoyamanox manatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Nea mai jatihobi hihbohax bi mahuatax jahuaya sca man banetihin? ¿Jabiyahpa queyóscaxon jahua man jatihin? ¿Jabiyahpa queyoyamanoxon man jahua Papa hinanti hahtipahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Heen Papan coshi xabaya tah hen joribiyaxihqui. Jahuen yonotiboyabi tah hen jotihi. Joxon tah hen jatihibi jonibo tsinquixon jaabo hihpahonibo quescabijaquin jato hahxontihi, caibo copijaquin, caibo casticanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Hen mato yohinon nincanahue. Caibo neno nichibaan tah man mahuaxonma hea quiquin haposcaax jahui man jisyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jato jascahipi seis dias sca Pedro, Jacobo, Jacobon huetsa Juan, jaabo rahsi quenaxon mahchi janin Jesusen jato hioquin. Jano tsoa yamahi janin mahchi queya jato maniquihnquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jano sca ta jaton jisnon bi Jesus huetsapahcahinnishqui. Jahuen bemanan xabati, bari xabati quesca sca jai. Jahuen chopa rihbi pehnecahini, xaba quescacahini. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jaabaan jisi bi yamanihbo Moises betan Elías jano rihbi nihresscai. Jesus betan yohuan yohuani rabebi jano nichi. Jato jisxon Pedronen sca Jesus yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","—Hihbon. Non neno jahue ta siri qui. Mia queenaiya tah non quimisha tapastihi, mina huetsa, Moisesnina huesta, Eliasena huetsa rihbi —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro yohuanparihiya xabatai nai cohiman jato mahporenenquin. Jaa nai cohin chicho quehax yohuanai sca nincacanquin: —Nea ta hen queenai heen baque qui. Hahan tah hen hihti jenimahi. Jaa nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jaa yohuanai joi nincacax, jahuen haxenicabo hihti rahtetax betihihpaquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Joxon sca jato mehexon: —Raquetaxma huenihihnanahue —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Huenixon jisi bi tsoabi yamascai, Jesus huesti res. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mahchi janinhax botopaqueti caquin sca: —Man rahma jisí tsoabi yohiyamaxahnahue. Mahuatipish hen hahquirihbi teehihnon caman tsoabi yohiyamaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","—Mia noque jihuemanica hihqui bi ta noquen huisha honanbo huetsa yohuan jaiqui. Elías pari ta joribitihiqui, chini sca noque jihuemanicah hih ta jacaniqui. ¿Jahua copi jascacaniquin? —Jesus yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Hihcoini. Elías ta joribixon jatihibi bexoja sca jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Man honannon hihxon tah hen mato yohiscai: Elías ta moa joribiscanishqui. Jahuiton bi ta jaa hihqui honanyamacannishqui hapobaan. Jaa honanxonma ta queenaibo quescajaquin jahancanhoxqui. Jascaja rihbi ta hea jayaxihcanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jaatian ta Elías jan hihqui bi nashimanica Juan jan yohihi honanscacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Botopaquetax cahax tsama manahihtaibo qui nococani. Jesus behchihax jaa bebonbi huesti jonin raboxonen tisquihahpaquexon: ");
INSERT INTO kaqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Hihbon, jenquetsaha ra heen baque hea jaxonhue. Tehquehihqui ta hihti jomihiqui. Hicha coti ta chihi janin paquetihqui. Jeneho rihbi ta paqueresiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Miin haxenicabo qui hen hihuehah bi ta rohajati hahtipahyamacanaxqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","—¡Shinancoinjomabon! Shinanquin sirijayamahibo tah man qui. ¿Jahuentiho basi hen mato betan hihquiya pari man pontetihin? ¿Jahuentiho basi cahra hen mato teneti jain? Jaa hihuenahue —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","—Jaa jenebahinhue —Jesusen coshin jaáh sca ta jaa baque jenebahini tiroma yoshin canishqui. Jaatianbi rohacahinscai, siriscai, jaa baque. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jesus qui sca jaabo rahsibi jahuen haxenicabo tsinquijaquexon yocacanquin: —¿Jahua jenquetsahiya non camati hahtipahyamahaquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Man hicha shinancoinyamahi copi, rahan. Hen mato yohihah nincanahue: Moxo bero hexti pishca hihqui quescapi maton shinan hicha tahma pishca res jaxon cah man nea mahchi yohirestihi. Join res potati tah man hahtipahquehahnai. Catanhue man jaah cahen cahan. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jaatian man hahtipahyamahibo yamahan —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea hian qui nocorihbixon sca: —Hea bihnon ta hapobo bihmayaxihcanihqui, hea rehtehahbo hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rehtehipibaan bi tah hen quimisha neten hihquish hahquirihbi teehihyaxihqui —Jesusen jato jaquin. Yohihah benáscacani. Hihti benati. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Janohax Capernaum jema janin sca bocani. Nocotaiya Papan xobo bexojati cobrannicabaan Pedro yocaquin: —¿Papan xobo bexojati coriqui maton haxemanicahten copijayamahiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Copijaquin rahan —hihcahini sca Pedro cahi. Jano Jesus jai xoboho mapetai bi Jesusen pari jaa yocaquin: —¿Min jenquetsahpa shinanain, Simoman? Hea yohihue: ¿mai meha quiquin hapobaan tsoabo cobraniquin? ¿Jatonah bi jaton baquebo nan? ¿Huetsabo nan? ");
INSERT INTO kaqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Huetsabo rahan, Hihbon. —Hihcoini. Jaton baquebo ta cobrantimabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jaabi, sinayamahahbo hiaman mishquitanhue. Mishquixon min bihmenohi yapa bihxon, jaxbaxon, jahuen jana janin jai coriqui bihhue. Jaa bihxon tah min noque rabebi copijaxontihi —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jaatian jahuen haxenicabo sca joxon, Jesus yocacanquin: —¿Papan jihuemati janin tsoa non hashoan yohuan hihbo quin, hihbon? ");
INSERT INTO kaqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Baque pishca quenabohanxon sca jato tocanbi nichinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Naponbi nichinxon sca: —Hen mato yohinon, nincanahue. Baque pishca quescanahue. Shinan ponteyamahax tah man Papan jihuemati janin nocotimabirestihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jahuen hapoti coshi yamahi ta nea baque pishcaten honanihqui. Jascajaquin shinanaibo ta Papan jihuemati janin hashoan yohuan hihbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nescapa baque pishca huesti res heen janen sirijaquin bihxon yanapanquin tah man hea rihbi jascajahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nescapa hea nincacoinai baque pishca hohchamahi joni ta hihti hohcha jaiqui. Hihtihosi macan renti qui tenexxon hian naponbi potahah jenimatihihma bi ta nescapa pishca jan hohchamani copi Papan casticanah hihti tiromati qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mai mehabo ta hahraai hihyaxihquiqui, huetsabo hohchamanish. Hohchati qui caibo tecayacahinti hahtipahyamahibaan bi ta jato hohchamanibo hashoan hahraai hihyaxihquiqui, Papan casticanti jato qui paquetah. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","¿Miin mequeman min hohchatain? Mextehue. ¿Miin tahen min hohcatain? Taxtehihxon potahue. Mento hihyamahax chantohax queyoyamanox manatah cahen tiromama. Rabe mequenyahpahax rabe taheyahpa chihi qui potahah cahen hihti tiromahan. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","¿Miin beron mia hohchamahiquin? Tsecaxon potahue. Rabe beroyahpahax bi johuehihnatai chihi perehihqui janin cahá ta tiroma bi res qui. Benchehax bi queyoyamanox manatah cahen hashoan siri. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Coiramenahue. Nescapa baque pishca jahuajoma hihqui man shinanmis. Naihohxon ta jato coiranquin jascabijaquin heen naihoh queha Papa yocaxoncaniqui jahuen yonotibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Manotaibo jihuemahi tah hen joníqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Huesti joni cien carnerobo jai quesca tah qui. Huesti jahuen carnero cahen manotan. Noventinueve pasto janinbi potabahini ta manotai huesti benahi sca catihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Caxon merahax ta jahan hihti jenimatihiqui. Texe behnotaxma pasto chian nichi copi jenimahax bi ta manotai rahma merahax hashoan jenimascaiqui. Jasca coin tah qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ni huestibi nescapa baque pishca manotima ta maton naihoh queha Papa queenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Miin huetsa mihqui hohchataiya jaa benahi caxon, jaa huesti yohuanquihnxon jan hohchatai yohihue. Mian yohihah jaan nincacaiya tah min miin huetsa merarihbi sca jai, jan manoquehana. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Min yohihah bi nincacatsihyamahiya huetsa rihbi miin huetsa benatahhue. Huesti hihyamahiya rabe meraxon, hioxon, jaton nincanonbi miin huetsa yohirihbihue. Huishani joi jai quescaquin hahhue, Yohicoin sta jaaxqui jaábo hihxon rabe hioxon man yohuanai nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jaabaan rihbi yohihah bi nincacatsihyamaparihiya, miin huetsabo jatihibi sca yohihue. Jatihixonbi sca yohihah bi nincayosmaparihiya, nahua tah qui hihxon jenebahinscahue, miin caibohax bi nahuascai quescanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hen mato yohinon nincanahue. Jascabi sca janon man mainxon jascajaquin yohihi jatihibi ta naihohxon jascarihbihi yohihah sca jatihiqui. Man mainxon yohixon bexojahi jatihibi ta naihohxon rihbi bexojaha sca jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Huetsa rihbi hen mato yohinon: Huesti shinanyaxon man joni huetsa betan tsinquixon yocacah ta man yocacai jatihibi heen naihoh queha Papan mato hahxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jano man rabe hihyamahax quimisha joni heen janen tsinquitai janin tah hen hea rihbi hihtihi. Jaa copi Papan mato hahxontihiqui honannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesus patax nihquirani joxon Pedronen yocaquin: —¿Jahuentihi coti noquen huetsa noque qui tiromahah bi non hahan shinanxon, jascabi sca janon jenehue non jatihin, Hihbon, noque qui jan tiromahi non shinanyamascanon? ¿Hasta siete coti non jascajatihin? ");
INSERT INTO kaqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Siete coti res ma bi setenta coti siete janaxon toponah, jano caman, rahan. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Papan jihue cahen quiquin hapon hahcai quescapah. Jaa quiquin hapon cahqui jaton cuenta copi jahuen jonibo betan bexohah. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jaton cuenta toponhihnihiya bi jaton hani coriqui huesti mil ribinai joni jahui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jahuatohonbi jahuen ribin copijatimahiya sca: Hina sca jaábo nea joni maromanahue, jahuen haiboya jahuen baquebo rihbi maromaxon jahuen jahuaborabo jatihibi maromanahue, jan ribinai copi hen coriqui bihnon hah ca hapon jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jaatian ta raboxonen nihxon jahuen jonin hihti yocatihiqui: Hea tenehue, hihbon. Mia tah hen jatihibi copijayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hahan shinanxon sca ta Jascabi sca janon jenehue jahuen hapon jatihiqui, ribinjoma sca jan janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ribinjoma caxon sca cahen jahuen hahbe teenica cien coriqui res jaa ribinai meratihi. Meraxon texecobahinxon, Min hea ribinai hea copijatahi tsoh hahtihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Raboxonen nihxon sca ta jahuen hahbe teenicaton hihti yocatihiqui: Hea tenehue. Mia tah hen copijayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jan hihti yocacah bi cahen jeenhahyamaxon bi policia bihmaxon jatihibi jan copijanon caman sipo xoboho tsahontihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jan jascajahi jisish texe jahuen hahbe teenicabo hihti benati. Benatax ta jaton hapo yohihi caxon jatihibi yohicantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jahuen joni quenamaxon sca ta jahuen hapon yohitihiqui: Tiroman, min hea hihti yocacah tah hen mia Jascabi sca janon jenehue hahcaqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Hen mia jascajaxonah cahen mian rihbi sca miin hahbe teetai joni mian hahxontihi, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sinaxon sca ta jahuen sipo xobo coirannicabo jaa joni hinantihiqui, jahuen ribin jatihibi copijanon caman. ");
INSERT INTO kaqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Maton huetsa mato qui tiromahah bi man maton jointiboyaxonbi man jaa hohmismayamahiya ta heen naihoh queha Papan maton hohcha shinanbehnoyamarihbitihiqui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jato jascajaquin yohihax sca Galilea mai janinhax cahax Judea main sca cahi cahi. Nocotax Jordan huean janinbo cahi, hoque quexa. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hihti caibo rihbi jaa chibani bocani. Hahqui nocotaiboya, janoxonbi jaton hisinbo jaan rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseobo rihbi sca jahui, Jahuen yohuan copi rehtenoxon hihxon, Jesus yocacanquin: —¿Queenxon copi res noquen haibo potacatsihquin non potatimahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—¿Jonijamenoquin haibo betan bebo Papan jato jonijani man jahuen quirica janin jisyamaniquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jaa copi ta jahuen mama jahuen papa jenebahini sca jahuen haibo betan jihueti jahuen bene catihiqui. ¿Rabehax bi huesti yora sca jaabo rabe sca janon jahuen haibo bebaan hihquihinti Papan yohihi man honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaa copi ta rabehax bi huesti yora sca qui. Papan ta jato huesti yorajahiqui. Jaan huesti yorajaha tsoanbi jenemayamanahue hih ca jaihsen —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—¿Jascahiya jahua copi sca noquen haibo potanoxon non jahuen jaya cati quirica huishaxon potati Moisesnin yohinishquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Mato nincayosmabo copi ta Moisesnin mato jascajaquin yohinishqui. Noquen haibo non potanon Papan noque jonijani que ma bi ta maton haibo man potacatsihqui copi mato jascajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hean sca tah hen mato yohihi: Maton haibo tsinihima bi jaa potaxon huetsa sca bichish tah man jaa copi hohchayahpaboscai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","—Noquen haibo non potatimahiya ta haibojoma jihuetah hashoan siri qui —hihcani jahuen haxenicabo sca. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Jaa man yohuanai ta jatihibi jonibaan shinantimahiqui, caibaan res. Jascari jahue Papan jaah ta caibaan res jascajaquin shinantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Queejomabo ta mesco jaiqui. Caibo cahen jascapahbo caini. Caibo cahen huetsabaan jato jascapahhue hahca queejoma sca baneti. Caibo rihbi cahen Papan jihuemati joi yohinoxon queejoma banetan. Nincati hahtipahxon nincanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jaatian baquebo sca Jesus qui becanquin. Jan jato mehexon Papa yocaxonnon hihxon hihuecanquin. Hihuehibaan bi jahuen haxenicabaan jato Jaya beyamanahue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","—Jaya behábo jato panteyamanahue. Joresnon, jotima yohiyamanahue. Jascapahbo ta heen Papan jihue janin canicahbo qui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jato jascajaquin yohixon baquebo sca mehexon janoxonbi Papa jato yocaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huetsa joni sca jahui, beronan tahni. —Maestron, ¿queyoyamanox mananoxon jahua siri shinanti hen pishinain? —hahquin yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿Jenquetsahpahiya min hea sirijati joibo yocacain? Huesti res ta siri qui. Queyoyamanox manacatsihquin Papan mia yohini quescajahue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Jahua jan yohini nan? —hahscaquin. —Rehteyamahue. Tsiniyamahue. Yometsohyamahue. Quesayamahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Miin papaya miin mamahon queenhue. Mihmebi min queemehti hihqui quescarihbihi joni huetsahon queenhue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jatihibi tah hen jaresscai. ¿Jahua hashoan hen pishintihin? —hahquin beronanen. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Jahuabi pishinyamacatsihxon miin jahuaborabo maromatanhue. Maromaxon jahuaborajomabo jaa coriqui hinanhue. Jaatian tah min naihoh hicha jahuabora jatihi. Jato hinanax, hehbetan cahi sca jotanhue —Jesusen jaa jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jascahah, benacahini beronan caresscai, jahuen jahuaborabo hicha jaax copi. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jaa benatax cahiya, jahuen haxenicabo sca Jesusen yohiquin: —Man honannon hihxon tah hen mato yohihi. Coriquiyahpabo Papan jihuemati janin hihquiti ta tee bi res qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hen mato yohirihbinon: Xohmox bero qui hahua huinomati tee que bi ta Papan jihuemati janin coriquiyahpabo cati hashoan tee bi res qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesus jascari yohuanai nincacax ta jahuen haxenicabo rahte rahtenishqui. —¿Coriquiyahpabo cati tee hihquiya tsoa non Papan jihuemati janin catihin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jato jatihibi bejisxon sca: —Jonibo hahmebi jano nocoti hahtipahyamahi bi ta Papan jatihibijati hahtipahiqui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","—Noquen caya tah non noquen jahuaborabo jatihibi jenebehnanxon mia chibanai, Hihbon. ¿Jahua sca non bihyaxihquin? —hahscaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Nincanahue, hen mato yohinon. Hea chibanaibo hihquish tah man nete behna tian sca hapobo sca man jihuetihi. Quiquin hihbo hihxon hen jatihibi hihbojahi tian tah man Papan israeli baquebo jatihibi jisxontihi, hapo rahsixon. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hea hahxonnoxon jaton jihuebo jenebahinaibo, jaton huetsabo jenebahinaibo, jaton chocabo jenebahinaibo, jaton papa jaton mama jenebahinaibo, jaton banabo jenebahinaibo, jascapahbo tah hen hashoan hicha hinantihi. Huesti jan jenebahinni tah hen cien sca jaa hinantihi. Queyoyamanox manataibo rihbi ta jaabo jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Hen jascajaquin hahxontihi bi nincanahue, hen mato yohinon: Hicha bebohibo ta chinibo sca hihyaxihquiqui. Hicha chini chininish ta bebocahinyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Papan jihuemati ta huai hihbaan hahcai quescapah qui. Jaa copi tah hen mato yohihi. Jaa huai hihbo cah hen yamequiri cahan, jahuen bimi tsinquixonnicahbo benahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Teexonnicahbo meraxon, huesti neten teexona patorobaan copijahi tihibi copijatijaxon, jahuen huai janin jato raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bari nai pohahihnataiya sca caxon, huetsa teenicabo rihbi meraquin, jaton nihti janin cahuan cahuanresaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jaabo rihbi quenaxon: —Heen huai chian botannahue mato rihbi. Ponte shinanxon tah hen mato copijatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jahuen huai chian sca bocani. Barin manan tsahcahiya sca caribixon huetsabo meraxon jascajaribiquin. Bari racacahuanaiya sca jascajaribiquin, caibo rihbi sca meraxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bari hihquiscai cahiya sca caxon, nihresaibo merarihbixon jato yocaquin: —¿Jahua copi man jeman res nihbahinahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Tsoanbi ta noque teemayamahiqui —hahcanquin. —Heen huai chian teeti botannahue, mato rihbi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Bari hiquihiya sca jahuen teemanica yohiquin: —Noquen jonibo quenahue. Chini hihquihahbo pari copijahue, jascajaquin teemenohibo chini sca copijanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bari hihquicatsiscaiya cahabo jahuiya sca jato copijapaquequin, joni tihibi huesti neten teexonbahinaha patorobaan copijahi tihi copijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chini sca teemenohibo jahui. Noque rah ta hashoan hicha copijanoxihquiqui hihcani. Jascaraibaan bi jaabo rihbi jatihi rihbi copijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jaton coriqui bichish sca, huai hihbo qui sinati yohuancanacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—Hoa chini hihquihahbo ta huesti hora res teecanaxqui. Non tee teexon bari tenebahinahi bi ta jatíhi res noque copijahiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Huai hihbaan sca yohiquin: —Mia tah hen tiromajayamahi, chahin. ¿Jaatihi canannoxon huesti neten teebahinati min yohiyamahahquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Miin coriquiya catanhue. Hen mia hinanai tihi rihbi tah hen chini hihquihahbo hinanai, queenxon copi. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Heabi hen queenai quescajaquin heen coriqui hen hinanti hahtipahyamahin? ¿Hen huetsa joni hicha hinanai copi min sinatain? —hahscaquin hihbaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jascajaquin rihbi ta chinitaibaan beboyaxihquiqui, bebohibo rihbi ta chiniyaxihquiqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jaa pecaho sca Jerusalen jema janin Jesus cahi cahi. Bahin caquin, jahuen doce haxemanicahbo quenabohanxon, jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalen janin tah non cahi. Jano ta sacerdote hapobaan hea bihyaxihquiqui, caibaan hea jato bihmahah. Jaton huisha honanbo betan yohuanxon ta hea rehteti yohiyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Hea rehtehahbo hihxon ta nahuabo hea hinanyaxihcanihqui. Hea hosan hosanxon, rishqui rishquixon jihuin hueonxon hea rehtenon ta jascajayaxihcanihqui. Rehtehahbo bi tah hen quimisha neten hihquish hahquirihbi teehihyaxihqui. Man honannon hihxon tah hen mato yohihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jaatian Zebedeon baquebaan mama sca jahui. Jahuen baque rabeya joxon jan queenai yocanoxon Jesus bebon raboxonen nichi. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿Jahua min queenain? —Jesusen jaquin. —Mia noquen quiquin hapo hihqui tian, nea heen baque rabe mia namanbi hapo rabe hihnon yohixonhue. Huetsan mia mecayahoxon yononon, huetsan mia memihohxon yononon yohixonhue —hahquin haibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Min yocacai tah min honanyamahi. ¿Hean xehayaxihqui mocani jaabaan xehati hahtipahiquin? —Jesusen jaquin. —Hahtipahquin rahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Hean xehahi mocani tah man xehatihi. Man jaa tenehi bi ta hea pataxxon hehbe hapoti hen mato yohiti hahtipahyamahi. Heen Papan ta hea jascajati yohiyamahiqui. Jaan honanaibo qui ta Papan jaa hinanyaxihquiqui, jato jascajati yohinihxon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Texe jahuen haxemanicahbaan sca nincaxon Zebedeon baque rabe sinajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jato sinajahibaan bi Jesusen jato yohiquin: —Hen mato yohinon benahue —hahxon— nahua hapobaan jaton caibo yono yonohi tah man honanai. Jato ta hihbojacaniqui jaton hapobaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Maton tah man jascajatimahi. Hapocatsihxon texe hahxoncoinnahue yanapanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bebonicacatsihquish, jaton yonotinahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jonibaan hea hahxonnon hihquish tah hen joyamaniqui. Jato hahxonnoxon hihquish tah hen joníqui, noquebaque hihqui bi. Hicha jonibo jihuenon hihxon tah hen hehrí jato rehtemahi. Hen jato hahxonti shinanai quescajaquin shinannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó jema janin nocotax sca, janohax Jerusalen quiri jahuiton sca hihti caibo jato chibanbenahi becani. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jaa bahi quexabi ta rabe benche janishqui, huinotaibo nincaresi tsahotai. Huinotai ta Jesus qui, hihquibo nincacax sca quenácahincani. —Hihbon, noquehon shinanhue, Davidinin baquen —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jascari quenataibaan bi Netenahue hahcanquin, huinotaibaan. Netenahue hahcabo bi hashoan sca quenacani: —Noquehon shinanhue, Davidinin baquen. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nihrenenxon sca Jesusen jato quenaquin. —¿Hen mato jenquetsahaxonti man queenain? —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Non jisnon noquen bero rohajahue, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jaatian jatohon hihti shinanxon, bero qui jato mehexon jato rohajaquin. Jaton bero siricahinax, hahbetanbi sca becani, rabebi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalen hochoma sca becani. Betfagé jema pishca qui nocotax, Olivo manan qui nococani. Janoxon sca jahuen haxenica rabe raannoxon yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Hoa hoque jai jema janin caxon tah man caballo meraxihqui. Nexa tah man meraxihqui, jahuen baqueyabi. Rabebi pecaxon jahuen baqueyabi hea bexontannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jahueja man jain hahcá, Noquen Hihbo ta nea pishinihqui hihnahue. Jaatian ta mato bexonmatihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Neateman Papan joi huishanicabaan yohini quescabijaquin janon ta jato jascajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalen janin jihuetaibo nescajaquin yohinahue: Jisnahue. Maton quiquin hapo ta nocoti jahuiqui. Quiquin hapobo jahui quescarihma bi joni quesca jahuiqui, caballo cahtsahotax. Caballo baque res cahtsahotax ta jahuiqui, noquen jahuaborabo noque papixonnica caballo baquen ta jahuiqui hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jan yohihah quesca sca caxon, nexa sca caballo meracanquin jahuen haxenicabaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pecaxon, jahuen baqueyabi becanquin. Caballo baque jaton chopa cahpohenxon, jano Jesus cahtsahonbenacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hihti caibaan jaton cotonbo pecaxon jano Jesus jonoxihqui bahinbi mijancanquin, hahan jonon. Caibaan rihbi jepe pehi xatexon jascajaribiquin, mijanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Caibo bebohi becani, caibo rihbi hahchon becani. Quenáhonahi becani: —David xohtahi ta jahuiqui. Hahxonhue. Papa Diosen janen ta jahuiqui. Papan shinanya ta jahuiqui. Jaa hahxonhue, Papan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jascahah, Jerusalen janin hihcohi. Jaa jema janinhahbo jatihibi rahte rahtetax: —¿Tsoa hin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Nea ta Papan joiya jahui joni qui, Jesus. Galilea mai mehax nocoti jahui, Nazaret jema janinhax nocoti jahui —hihcani, tsamajaquetaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Papan xoboho sca Jesus mapeti. Mapexon, janoxon marohiton jonibo meraxon, maromahiton rihbi meraxon, jascapahbo jatihibi camaquin. Jato picomaxon, jaton coriqui mahnenanti mesabo behonxon, nobex maromanicahbaan tsahotibo hueranbohanxon, jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—Papan huishani joi janin ta nea jaiqui: Heen xobo ta janoxon hea yohiti xobo qui. Jascapa xobo hihqui bi tah man jano yometso tsamati jaa xobo jai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jaatian sca bencheboya chantobo jaa xoboho mapeti, Jesus jano jai copi. Jato jisxon, jaan jato rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jahuen coshi shinaman jan jato hahxonai jisxon sacerdote hapobo betan jaton huisha honanbo sinati. Papan xoboho baquebo quenatai, Davidi xohta hahxonhue hihquibo nincacax, sina sinacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sinaxon, Jesus yocacanquin: —¿Jaabo yohuanai min nincayamahin? —hahcanquin. —Nincaquin rahan. ¿Baquebo tah min mihqui siripi yohuanmahi, baquexobo rihbi, hihqui Papan huishani joi, man jahuentianbi jaa jisyamaniquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jato jenebahini sca picoti cahax huetsa jema janin cahi, Betania jema. Jano sca hoxashinahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Xaba paquetaiya sca jahuex Jerusalen janin nocotax picatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bahi quexabi bimi jihui huesti meraxon, bimi bichi caha bi yamahi. Pehi rahsi jai. —Jahuentianbi bimiyamaxihhue —hahquin, jihui. Jan yohihah, xanacahinscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jan yohiha jihui choshihi jisish, rahte rahtetax jahuen haxenicabo yohuani: —¿Jenquetsahpi jaa jihui xanacahinihquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yohuanai nincaxon, jato yohiquin: —Man honannon hihxon tah hen mato yohihi. Papan mato hahxoncointihi honanxon, hahxonyama rah ta hea jatihiqui shinanyamaxon tah man jascapa yohiti hahtipahtihi. Jascapah res ma bi tah man hoa manan quescapahbo rihbi yohitihi, Huenihihnatax hoa hiaman paquehue. Shinancoinxon man yohihah ta man yohihi quescatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Papan mato hahxontihi honancoinxon man yocacai jatihibi ta jaan mato hahxonyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jaatian sca nocotax Papan xoboho mapexon jano nocohihnatai jonibo haxemaquin. Jato haxemahiya bi sacerdote hapobo becani, jaton hahbe hapobo betan. Joxon: —¿Tsoan mia jascajahue hahca min neno jascajahipiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Mato rihbi tah hen huestijaquin yocatihi. Man hea yohihiya tah hen tsoan hea jascajahue hahcai hen mato yohirihbitihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tsoan yohihah Juaman nashimapahonishquin? ¿Papan yohihah nan? ¿Jonibaan res yohihah nan? —jato jaáh bi jahuahihyama sca jacani. Jaabo rahsibi res yohinani. —Papan yohihah rahan hih non jaiya ta noque yocaxihquiqui, Jahua copi sca man Juaman yohihah bi nincayamanihquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jonibaan res rahan hih tah non jatimaribihi. Tsamataibaan noque jenquetsah ra jamis. Juan Papan joi yohinica hihpahoni ta shinancaniqui —hihcani, jaabo rahsibi yohinani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yohinanxon sca: —Non tah non honanyamahi —hahcanquin Jesus. —Hean rihbi tah hen tsoan hea jascajahue hahcai mato yohiyamarihbihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Man jaa shinannon tah hen mato yohihi. Rabe bebo baqueya joni ta japahonishqui. Jahuen beboquiha baque ta yohinishqui: —Rahma noquen huai chian teetanhue, baquen —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jascahah bi: —Hen tah hen queenyamahi —hihqui. Jascarax bi chini sca pontejaquin shinanax, teeti cahi, huai chian. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jahuen chini sca jahuen papan jascajaquin rihbi yonoquin. —Teeti rahan, Papan —hahcax bi jahuen chini baque cayamaribihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hea yohinahue: ¿Jahuemehaton jahuen papan yohiha quescabijanishquin? —Jahuen baque beboquihaton rahan —hahcanquin. —Hihcoini. Jascarihbihi ta coriqui cobranmisboya tsini haibobo mato bebohi bocanihqui Papan jihuemati janin cacatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Papan bahin canoxon ponte jihueti Juaman mato yohihah bi tah man nincayamanihqui. Coriqui cobranmisbaan caya ta nincanishqui. Tsini haibobaan rihbi. Jaabaan nincacoinscai jisxon maton rihbi chini sca pontejaquin shinanxon nincacointihi bi tah man nincacoinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Huetsa jahan haxeti joi nincanahue. Huesti jonin ta hani huaijanishqui. Jahuen huai banaxon, jahuen senenjatibo honantijanoxon chiquebohanxon, hahan bishtaxmatijaxon, janoxon coiranti xobojaxon, jahuen huai coirantibo yohihax joribiyanoxon cahi caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jahuen huai tsinquiti tian sca, jahuen jonibo raanquin, jahuen coirannicahban jahuen bimi hinannon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Raanah sca nococani. Nocotaiton bi jahuen coirannicahbaan jato yahtanquin. Huetsa rishquixon, huetsa rehtexon, huetsa rihbi macaman tsacaquin rehtecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jaa pecaho sca huetsa jahuen jonibo sca huai hihbaan raanrihbiquin, hashoan hicha sca. Raanah nocotaiton jato jascajaribicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chini sca jahuen baquebi raanquin. Heen baque ta nincayaxihcanihqui hihxon jaa raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jahuen baque nocoti jahui merahax, yohinancani: —Nea ta huai hihbo hihyaxihquiqui, jahuen papa mahuataiya. Jaa rihbi rehtenon benahue noquenah sca jahuen huai hihnon —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nocotaiton sca yahtanxon, huai mapoho boxon rehtecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Joxon sca jaa huai hihbaan jahua jato jati quin? —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Jato ta tiromajaquin rehtetihiqui. Jahuen huai rihbi ta huetsa coirannicahbo hinantahtihiqui, bimi jai tian jahuenah hinanyaxihquibo —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—¿Papan huishani joi janin man nea jahuentianbi jisyamaniquin? Tiroma tah qui hihxon xobojahibaan potani xobo jihui ta hahqui xobojati qui. Papa Diosen ta jaa caisihqui. Jan hahcai shinanax tah non rahtetai hihqui jaa joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jaa copi tah hen mato yohihi: Papan ta mato jahuen jihue bichinyaxihquiqui. Mato bichinxon ta maton nahuabo sca hinanyaxihquiqui, jahuen joi jai quescabijahibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jaa jihui qui paquetaibo ta tobitihiqui. Jato qui jaa jihui paquetah ta moshi moshitaibo jayaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hahan haxeti joi jan yohihi nincaxon, jato qui jan jayaxon yohihi jaton hapobaan honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jaa bihcatsihquish bi jonibo qui raquexon bihyamacanquin. Papan joi yohinica tah qui hihquibo sinacahincanmis hihquish raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yahtancatsihquibaan bi Jesusen jato yohipariquin hahan haxeti joi jato nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Papan jihuemahi ta huesti quiquin hapon hahní quescapi qui. Jahuen baque huanomayanoxon ta jato hichaxon pitijati yohinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Piti hicha jaiya sca, jan yohihipibo yohitannon, jahuen jonibo raanscaquin. Huanomaquin pihi benahue hahca bi queenyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Huetsabo sca jaton hapon raanrihbiquin. —Hen yohihipibo yohitannahue. Piti ta hihresscaiqui. Heen torobo rehtexon, xoa toro baquebo rehtexon, pitijaha ta jatihibi hihresscaiqui. Pihihue jato jatannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Caxon yohihah bi nincacatsihyamacani. Huetsa janin res bojaquetancani. Huetsa jahuen huai chian cahi. Huetsa jahuen tee janin cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Caibaan rihbi jahuen jonibo bihxon, jato sinajaxon rehtecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jaa copi ta sinaxon sca jaton quiquin hapon jahuen sontarobo sca raanxon hoa rehtemisbo rehtexon jaton xobobo mapojaribinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jato jascajaxon sca jahuen jonibo yohirihbiquin: —Noquen piti hihresscai bi ta non jato yohihipibo tiromabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hoque cahi bahin sca botannahue. Man jano merahi jatihibi jato yohibonanahue, pihi behabo. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yonohah sca bocani. Bahin caquin jonibo meraxon chanixon jahuen huanomati janin jato becanquin. Siriboya tiromabo mesco jato becanquin, jahuen huanomati piti janin hihti caibo sca joni janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pihibo jisi caxon sca jayaxon huanomati chopa sahuehaxma huesti joni pihi tsahotaiton hapon meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Meraxon: —¿Jenquetsahpahi min jayaxon huanomati chopa sahuehaxma neno hihcohin, hiconin? —hapon jaáh bi jahuahihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Piti metexonaibo sca quenaxon: —Nea menexxon tanexnahue. Nexaxon nenoma qui bahquish chian potanahue. Jano bahquish chian potahahbo ta saisaihihquiqui, hisinxon xeta tais tais hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hicha quenamaha bi ta huestibo res hihquinica qui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yohihah, yohinani fariseobo caresscai. Jahuen joi copi rehtenoxon jenquetsahaxon non tiroma yohuanmatihin hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jatonahbi jaton haxenicabo sca raancanquin, herodianobo betan caxon Jesus yocacahbo. Cahi nocoxon sca, yocacanquin: —Mian tah min sirijaquin yohihi, maestron. Non tah non honanai. Mian tah min noque Papan bahi sirijaquin honanmahi. Tsoa qui bi raquexonma tah min jaabijaquin noque yohihi. Noquen bemanan res tah min jisyamahi; noquen shinan rihbi tah min honanai. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaa copi tah non mia yocacai. ¿Quiquin hapo Cesaronen noque cobranah non copijati jain? ¿Non copijatimahin? Noque yohihue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tiromabohi honanxon, jato yocaquin: —¿Jahuejanoxon man shinancoinihcamaxon hea tanahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hahan copijati coriqui hea jismanahue —hahquin. Yohihah, jaa coriqui bexon hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bihxon, sanahihnixon jato yocaquin: —¿Neno tsoan mapo jaiquin? ¿Tsoan huishani neno jaiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Cesaronena rahan —hihcani. —Jahuena hihquiya, jahuena hinannahue. Noquen Papa rihbi jahuena hinannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nincacax, rahtecani. Joihaxma sca bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jaatian saduceobo rihbi yocaqui becani. Jaabaan shinanah, mahuatax non tsoabi hahquirihbi teehihtimahi. Jaabaan sca yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestron, Moisesnin ta noque yohinishqui, noquen bocha baquejahaxma hihxonaiya non jahuen yononma bihxon hahqui sca noquen bocha non baquejaxonti. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Neno noquen chahin baquebo ta siete janishqui, bebo rahsi. Jahuen beboquiha baque haibo bichish bi baquejahaxma hihqui. Jahuen chinipan sca jahuen yononma hihquihinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jaa jascarihbihi; baquejahaxma mahuati. Huetsa sca jascarihbihi. Huetsa sca jascarihbihi, jaton chini caman sca. Jaa jascarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jaton yononma sca mahuarihbiscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Papan jihue janin sca teehihribihax jihuetaiboya, tsoan haibo jaa yononma jatihiquin? Jatihibichin jaa hihquihinish bi —hahcanquin Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jasca jaiboya, jato yohiquin: —Papan huishamani joi honanyamaxon tah man honanai shinanxon bi honancoinyamahi. Papan coshi rihbi honanyamaxon tah man shinancoinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Papan jihue janin sca teehihribihibaan ta haibo bihyamayaxihquiqui. Haibobo rihbi ta benoyamayaxihquiqui. Papan naihoh jai yonotibo hihqui quescapi ta jayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mahuanihbo ta hahquirihbi teehihtimahiqui hih man jai bi tah hen mato yohihi ¿nea Papan huishamani joi man jisyamaniquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hea tah hen Abrahanen Papa Dios qui. Isaaquen Papa Dios tah hen qui. Jacobon Papa Dios tah hen qui. hihqui jaa joi. Jaa copi honannahue. Papa Dios ta mahuanihbaan Papa Dios hihpahoni ma qui. Jihuetaibaan Papa Dios ta jaa qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesusen jato yohihi ta tsamajaquetaibaan rihbi nincanishqui. Nincacax bi ¿jasca hin? hihquish rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceobo rihbi jan yohixon netemahi chanihahbo sca fariseobo jaabo rahsi sca tsinquicani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yohinanax, jato quiha huesti jahui, Moisesnin huishani joi honan. Jesus tanacatsihquin nescajaquin yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestron, ¿jahue meha non Moisesnin huishani joibo jaa pari hashoan nincati jain? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Miin Hihbo Diosohon tah min miin jointiboyabi queentihi, miin yoshinboyabi, miin shinanboyabi tah min jahan queentihi. Jaa pari nincati joi ta jaa qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Jaa pecaho ta huetsa jascapah rihbi qui: Mihbe jihuetaibohon tah min queenrihbitihi, mihri min queemehti hihqui quescarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jaa joi rabe janinhax ta texe Moisesnin huishani joi jahuiqui. Texe Papan joi yohinicabaan huishani joi rihbi janohax jahui. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Caibo rihbi sca fariseobo nocohihnataiya Jesusen jato yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Hean sca tah hen mato yocacai: ¿Tsoan baque Cristo quin? ¿Jahua man shinanain? —hahquin. —Davidina rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Davidina hihquiya, ¿jenquetsahpahiya quenaquin Hihbon Davidi janishquin, Dios yoshiman huishamahah? ");
INSERT INTO kaqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jaa jan huishani ta nesca qui: Heen Hihbo Diosen ta heen hihbo yohinishqui. Hihbonoxon hea mecayaho tsahoti johue, miin rahuibo miin hinabo sca hen hihmanon caman hihbohue. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jahuen hihbo hihqui Davidi yohuani jaiya, ¿jenquetsahpax jahuen baque hihti quin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yocacah bi jahua yohiti honanyamacanquin. Jato jascajaquin yocarihbimis hihxon rabinxon jahuabi yocayamascacanquin, jahuentianbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jaa xoboho hihti caibo jaiya sca, jahuen haxenicabo rihbi jano jaiya, jatihibixonbi nincanon Jesusen yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Fariseobaan ta Moisesnin huishani joiyaxon mato haxemahiqui. Jaton huisha haxemanicahbaan ta jascajaribihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaa copi jato nincanahue. Jaabaan mato yohihi jatihibi jointinin nincaxon hahnahue. Jaabaan yohihi quescajaxon bi jaabaan hahcai quescajayamahue. Janan sirijaquin yohixon bi ta jascajayamacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Patorobaan jaton jonibo hihuenhuan papimahi hahcajaquin ta yohiquin tee joibo tsamancaniqui, man rehbo rehbocanascanon. Mato jascapa hihuebo yohixon bi ta ni huesti metotininbi jahuabi mato yanapanyamacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Caibaan jisnon hihxon res ta hahcanihqui, siri hihqui shinanahbo hihxon. Jisíbo hihxon res ta jaton benexehtibo pextinjacaniqui, hahqui huishaxon Papan joi shinantihibi. Jaton rajoti jisibo hihxon res ta jaton coton quexabo quenejaxon hanijacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Huanomati hihyamahiya huetsa copi hichaxon pitijahibo jai nincacax ta cahax xobo hihbo pataxbi tsahocatsihcanihqui, huetsanco tsahocatsihyamahi. Papan joi nincaqui cahax bi, jascarihbicani, hapon tsahotinin res tsahocatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Huinotaiton caibaan jato saludanxon Hapon hahcá ta costancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tsoabi mato Hapon hahmayamanahue. Maton hapo ta huesti res qui, mato haxemahi. Mato tah man noque huetsa rahsi qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tsoabi rihbi tah man main jaibo Papan hahtimahi. Maton naihoh queha Papa huesti res ta maton Papa qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tsoabi rihbi mato Maestron hahmayamanahue. Cristo huesti ta maton maestro qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maton huetsabo man hashoan hahxonaiya tah hen hashoan shinanya joni mato jisyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jaa copi ta rahma caibo mahuinti shinanai joni hean hihpaquemayaxihqui, naman sca jaa janon. Naman mehabo quescaxon joni hahxonaibo tah hen hinahihnamayaxihqui, shinan siriya jaa hihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Hahrai hahrai hih tah man jayaxihqui, fariseobon. Judio joi xeni honanmanicabon, hahrai hih tah man jayaxihqui, Papan casticanah. Shinancoinihcamaxon paranaibo tah man qui. Jonibo Papan jihue janin capanan tah man jato bahi xehponai. Papan jihue janin hihcocatsihquibaan bi tah man jato pantehi, mato rihbi hihcocatsihyamaxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yomanahtai yononmabo jaton jahuaborabo bichinxon bi tah man Papa yocaquin joi tsamanscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hahrai hih tah man jayaxihqui fariseobon. Mato judio joi xeni haxemanicabon. Man tah man jascarihbiyaxihqui, Papan casticanah. Shinancoinihcamaxon paranaibo tah man qui. Huesti joni haxemanoxon tah man mai nabebacahinax hian pohquejaquexon haxemahi. Man haxemaha sca ta man tiromajaquin hahcai quescajaquin bi rabejaquin hashoan tiromaja sca jaiqui, maton tiroma shinanyaxon mato mahuinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Hahrai hih tah man jayaxihqui. Benchexon bi tah man caibo hioti shinanai. Nesca tah man yohuani jai: Papan xobo hihcoinnicahton xobo hihqui quescarihbihi tah hen hihcoini yohuanai hihquish bi non quesahah ta tiroma ma qui, hih tah man jai, paranquin. Papan xobo janin jai oro hihcoinnicahton oro hihqui quescarihbihi tah hen hihcoini yohuanai hihquish tah non quesatima sca jai hih tah man jai. Jascari yohuanquin tah man joni huetsa paranai. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Shinanjomabon. Benchebon. ¿Jahuemeha hashoan coshi quin? ¿Oro nan? ¿Oro hihbo nan? ");
INSERT INTO kaqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jano Papa racanxonti ta hihcoinnica racanxonti qui hihquish bi quesascaax tah non tiroma yamahi hih tah man jai, parani. Jaa racanti janin racatai tah non hihcoinnica hinanai hihquish tah non quesatimascai hih tah man jai. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Shinanjomabon, ¿jahue meha hashoan coshi quin: non hinanai jahuaborabo nan? ¿Racanxonti hihbo nan? ");
INSERT INTO kaqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jaa copi ta jaa racanxontiya yohuanai joni jahuen racanxontiya res yohuanyamahiqui. Jano racatai jahuen hinantiyabi ta yohuanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Papan xoboya yohuanai joni ta jaya res ma bi jaa chicho jaiboya yohuanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naiya yohuanai joni rihbi ta jaho jaiboya yohuanihqui: janoxon ta Papan noque jisiqui. Jaa copi ta jascari yohuanai joni noquen Papa Diosyabi yohuanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hahrai hih tah man jayaxihqui, fariseobon. Hahrai hih tah man jayaxihqui, judio joi xeni honanmanicahbon. Hihcoinihcamaxon tah man paranai. Maton haxé pehi tah man texe pishca jahuena noquen Papa hinanxon, cahua meso rihbi pishca hinanxon, comino pehi rihbi pishca hinanxon jai. Jascajahax bi tah man Papan hani joibo, non jaa pari nincati jai joibo, man nincati pishinai. Non pontejaquin shinanti jai joibo, non joni huetsahon shinanti jai joibo, non Papan joi nincacointi jai joibo. Jaa joibo caya tah man shinancointihi, hoa hanitahmabo jenexonma. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Benchexon bi tah man joni hioti shinanai. Naca pishca xehamis hihxon maton xehati tohaxon bi tah man moanman hahua xeharesai. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hahrai hih tah man jayaxihqui, fariseobon. Mato jascarihbihi, judio joi xeni haxemanicahbon. Shinancoinihcamaxon tah man jonibo paranresai. Pinoxon tah man tason rahchoxon quenchábo rahchocai. Chicho rihbi nahpantahin: jano ta yometsohtiya bihresti shinanbo bochohiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Shinanjoma fariseon. Chicho pari miin tasonbo nachohue, chixama rahpanah siri sca hihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hahrai hih tah man jayaxihqui, judio hapobon. Hahrai hih tah man jayaxihqui, fariseobon. Shinancoinihcamaxon tah man jonibo paranresai. Tsahon quescapahbo tah man qui. Tsahon ta bemacanya sirijaquin bexojahah bi chicho sca mahuatipi pisi bochohi qui, rahnintibo bochohi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mato tah man jascapahbo rihbi qui, rahmacanya ponte joni quescapahax bi jointi janin tiroma shinanbo bochohi, paranti shinanbo bochohi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hahrai hih tah man jayaxihqui, judio hapobon, fariseobon, shinanihcamaxon parannicabon. Papan joi yohinicabo tah man jaton tsahon xobojaxonai. Sirijaquin Papan joi yohipahonihbo copi tah man jaton tsahon sirijaquin bexojahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jascajahax tah man yohuanai. Noquen papabo jihuetai tian jihuexon cah non jaabaan rehteni quescajayamaquehahnai, Papan joi yohinicabo rehteyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jascari yohuanxon tah man Papan joi yohinicabo rehtepahonihbaan baquebo man hihqui man honanmahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Maton papabaan rehtequin texejani senenjascanahue, hah ca hen mato jaihsen. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ronobon. Toahihca baquebon. Man tah man jenquetsahaxon bi maton casticanti mato xahbanjamatimahi. Tiromabo casticanti tian ta Papan mato tiromajayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Man jato tiromajanon tah hen heen raantibo mato qui raanai, heen joi yohinicabo hen mato qui raanai, honanbo hen mato qui raanai, heen joi huishahibo hen mato qui raanai. Caibo tah man rehtetihi. Caibo tah man jihuin hueonxon rehtetihi. Caibo tah man maton tsinquiti xobohoxon bi rishqui rishquitihi. Caibo rihbi tah man huesti jema janinxon huetsa caman chibantihi tiromajacatsihquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaa copi tah hen mato hihti casticanyaxihqui. Abel janeya siri joni rehtemenonihxon texe siri jonibo rehtepahonihxon, Berequiasnen baque Zacarias sca man rehtenihqui. Jaa tah man racanxonti janinhax Papan xobo janin cahiton man rehtenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hen mato yohinon nincanahue: Jaa jatihibi copi ta Papan mato casticanyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalen janin jihuetaibo sca yohihi: —Jerusalen janinhahbon, Papan joi yohinicabo tah man rehtehi. Jan mato qui raanaibo tah man macaman tsacaxon rehtehi. Hatapanen jahuen baquebo paxajaquin hahcajaquin hicha coti sca hen mato tsinquihah bi tah man queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jisnahue. Maton jihue ta boncoscaiqui. Jonijoma sca ta jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Man tah man hea jisyamascatihi. Hea hahquirihbi jahui merahax tah man Papan shinanya ta joxonihqui. Papan janen ta jorescaiqui hih tah man jayaxihqui. Hen joyaxahnon caman tah man hea jisyamascatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Papan xobo janinhax picotax sca bahin cahi cahi. Hahbetan caquin, jemanxon Papan xobobo jisxon, jahuen haxenicabaan metoxon hani xobo siribo jismacatsihquin yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jishue, Hihbon jaábo bi: —Hen mato yohinon nincanahue. Nea man jisi rahsi ta potojaquequin queyobahinyaxihcanihqui. Nea macan tsamanxon xobojanibo bi ta ni huesti macan huetsa cahchian tsahoyamascayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jato jascajabahini cahax, Olivoya manan manichish Jesus tsahoti. Jaabo rahsibi sca jahuen haxenicabo hahqui tsinquijaquexon yocacanquin: —Noque yohipishcahue. ¿Min yohiha jahuentian jayaxihquiquin? ¿Jahua huinotai jisxon non mia joribiti nea pishca sca jai non honantihin? ¿Nete queyoti neno pishcasca jai honannoxon jahua non jistihin? ");
INSERT INTO kaqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yocacahbo sca: —Coiramenahue. Mato parancanmis. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hea hihquicamahax ta hicha jonibo joyaxihquiqui. Hea tah hen Cristo qui hihxon ta hicha joni paranyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Rehtenanaibo tah man nincayaxihqui. Huetsa janin rehtenanaibo jai chanihi tah man nincarihbiyaxihqui. Nincaxon bi masa shinanyamanahue. Nete queyorihyamanon bi ta jascapahbo jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jaa rehtenanaibo janon ta huetsa nahuabo jaton nahuabo betan rehtenani boyaxihcanihqui. Jaton sontaroboya cahax ta quiquin hapobo hahbe quiquin hapobo betan rehtenanyaxihcanihqui. Huetsa janinbo ta pihan hihquish mahuayaxihcanihqui. Huetsa janinbo rihbi ta mai mihuanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jaa rahsi ta pehocohyaxihquiqui, nete queyoscayaxahnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jaatian ta mato bihxon mato tiromajayaxihcanihqui. Mato ta rehteyaxihcanihqui. Man hea hihbomahi copi ta jatihibi nahuabaan mato jistahihmayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jaa copi ta nincapahonixon bi hihti caibaan hea jenebahinyaxihquiqui. Hea jenexon ta paranxon jaton hahbe nincacoinnicabo rihbi polisia bihmayaxihcanihqui. Jascapah ta jistahihmahanani jayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Papan joi yohihihcamahax ta hicha quesabo jaresscatihiqui. Tsama jonibo ta paranyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tiromabo hashoan hicha sca jaiya ta joni huetsahon shinanyamahibo hashoan hichayaxihquiqui. Shinanyahpabo cahen huestibo res. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jabi ta maton nete queyonon caman man tenehiya Papan mato jihuecoinmayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Papan mato jihuemayaxihqui joi siri ta jatihibi janin chanihi boyaxihcanihqui, jatihibi nahuabo nincamaquin. Jaatiansca ta nete queyoscayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jaa copi Danielnin huishani joi jisxon, honannahue. Papan joi yohinicaxon ta huishanishqui, Papan jati janin ta non rahninai joni nihyaxihquiqui, hihqui jaa huisha. Jascapa jano nichi jisxon sca honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jaa jisish, jabatax mahchibo janin joneyaxahnahue, Judea mai mehabon. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Miin xobo pemacanya tsahotax, botocahintanhue histon. Miin xoboho jai jahuaborabo bichishma hishtocahintanhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Miin huai chian cotonjoma teetax carestanhue, miin coton benahi joribiyamatanhue, carestanhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jaa netebaan ta tohoyabo huaohihcanahi cayaxihquiqui. Xoma hahmahibo jascarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jenetian jabayamanoxon Papa yocayaxahnahue, tantiti neten rihbi jabayamanoxon yocayaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jaatian ta hihti tiromajayaxihcanihqui. Nete jamenoni rahma caman tsoan jisnima tiromabo ta jayaxihquiqui. Jahuentianbi jascapahbo hahquirihbi yamascanon ta jaatian jayaxihquiqui. Jaa copi jascajaquin Papa yocayaxahnnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jascapa tiroma netebo hashoan hichahiya cahen tsoabi jihueyamahan. Jaa copi ta jahuen caisahbohon shinanxon jascapa tiromabo basi jatima Papan yohiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jaatian, Neno ta Cristo qui hihquiboya jato nincayamaxahnahue. Hono tah qui hihquiboya nincayamaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Hea tah hen Cristo qui hihqui quesahibo ta joyaxihquiqui. Papan joi yohinica tah hen qui hihquibo quesahi. Jaton coshiyaxon hahan honantijaquin hahcajaquin ta jonibo rahteyaxihcanihqui, jato parannoxon. Hahtipahxon cahen nincacoinnicabo rihbi bahinmahhuan nichinbohanan. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jascapahbo jayaxihqui tah hen mato yohiscai. Jato honanyaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jisnahue, Cahchiho ta Cristo nichiqui hihquibaan bi jato honanax jisi boyamanoxahnahue. Xobo chicho tah qui, hihquibaan bi jato nincayamanoxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bari cainai quirihax bari hihquihi janin caman cana bacahi xabatani jai quescapi tah hen sanarenenyaxihqui. Jaa honanxon jato nincayamanoxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jano mahuatipi racatai janin ta hishmin tsinquitihqui, hih ca hen jaihsen. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jascapa nete tiromabo queyoscaiya ta bari xehpo sca jaax xabayamascatihiqui. Hoxne rihbi ta xabayamascatihiqui. Naihoh quehax ta huishibo rihbi paqueyaxihquiqui. Naiho jai coshibo ta Papan tahayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jaatian tah man nai bejisxon hahan honanti jisyaxihqui, hea joribiscanon. Jaatian ta jatihibi janin jaibo huaohihyaxihcanihqui. Naihoh quehax botopaqueti jahui sca ta hea noquebaque jisyaxihcanihqui, nai cohiman jahui ta hea jisyaxihcanihqui, hihti xabaya hihti coshiya jahui ta jisyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Corneta rehue coshin res corotai bi tah hen heen yonotibo raanyaxihqui, jatihibi janin jai heen caisahbo tsinquinon. Nai chibechijaquetancahuanai janin cahi, ramiho jascarihbi, jatihibi janin jato tsinquixonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Xono jihui ta hahan haxeti qui, honannahue. Bochocohax pehihiscaiya ta bimi bero tsinquiti netebo nocoti jahui non honanai. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jascajaquin rihbi hen mato yohihahbo jaresscai jisxon, maton xoboho hihcohi jahuicamahi hen hochoma pishca jahui honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Man honannon hihxon tah hen mato yohihi: Hen mato yohihah quescabihi jaresscaiya pari ta nete queyoyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jaatian ta naiya maibo queyocahinyaxihquiqui. Naiya maibo queyocahinai bi ta heen joi jahuentianbi queyotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","¿Jahuentian nete queyoyaxihquiquin? ¿Jahuen bari hihquiya queyoyaxihquiquin? Tsoanbi tah non honanyamahi. Naihohxon Papan yonotibaan honanyamarihbinon tah hen hean rihbi honanyamahi. Papa huestichin ta honanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jahuentian queyoyaxihquiquin honanxonma bi nea honannahue: Noen jihuetai tian japahonibo quescarihbihi ta hea sanareneni jonon caman jayaxihcanihqui jonibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jenen jato mahponon caman ta pipi pipichi xeha xehahi jihuecanpahonishqui. Jahuen nontin Noen nanenon caman ta bebaan hahuinjanon haibobo rihbi benonon huanomacanpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jahuentian jene paquexihquiquin honanxonma ta jascajacanpahonishqui, paquerenenxon sca jenen jato bonon. Jascarihbihi ta hea joti jayaxihquiqui, tsoan honanaima bi histon. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jaatian ta jaton huai chian rabe joni teetai jayaxihquiqui, huetsa hioxon tah hen huetsa jenebahintihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jaton rentin rabexon rene renehiton bi tah hen huetsa bihxon huetsa jenebahintihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Coiramenahue tahca. Jahua netenbi maton hihbo mato bichi jahuiquin man tah man honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jahua neten hen jotihiquin man tah man honanyamahi. Mato qui ta nococahintihiqui. Jaa tah man honanscai. Jahua hora jahuen xoboho yometso hihquicahintihi honanxon cahen xobo hihbaan coiranan. Coiranxon cahen jahuen xoboho hihquimayamahan. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jaa copi coiramenahue. Rahmabi ta joyamahiqui hih man jai bi tah hen joresscatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jahuen patoronen yohihi quescabijaquin hahxonai joni ta siri joni qui, shinanyahpa. Jascapa cahen jahuen patoronen yohitihi, texe jahuen jonibo jan jisxonnon. Jaton piti tian jan jato pimanon. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jascajaxonaiton jahuen patoro joxon merahah ta hahan jenimati jaiqui, jahuen patoronen siri joni jisi copi. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jascapa joni ta jahuen patoronen yohitihqui, jatihibi jahuen xoboyabi jahuen jonibo jan jisxonnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jascapa hihyamahax bi tiroma joni hihquish cahen Heen patoro ta basixihquiqui hihxon, ");
INSERT INTO kaqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","jahuen hahbe jonibo rishquitihiqui. Jato rishquixon sca ta piquin sirijaxon xehahax pahenscatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Joriyama ta jatihiqui hih jahuen joni jaitianbi ta pahenscaiton jahuen patoronen merahi jotihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Joxon ta jaa joni caxquepaquexon jahuen tequebo potatihiqui. Jano nincacoinihcamahibo jaiton potaquin. Jano ta saisaihihqui, xeta tais tais hahcaibo rahsi jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jahuen jihuetahbo Papan jihuemahi jahui ta diez xontaconen hahni quescatihiqui. Jaton johue bihbahini caxon cahen huanomanoxon jaton tsaben benejati jahui behchihi bocani. Jan huanoxihqui bepi jascacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pichca xontaco shinanjoma janon cahen jatíhi rihbi shinanyahpa jaribinish. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Honanma xontacobaan cahen jaton johuebo bihbahini caxon bi jaton nachiti boyamanish. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Shinanyabaan jaton johue boxon bi jaton nachiti rihbi boquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jaton tsaben benejati basihiya sca, manatax hoxacatsihquish racapaquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yame pochinicon sca quenatai nincacanquin. Jo ta jaiqui. Behchitannahue, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Huenicahuanxon sca jaton johue cohuasquin. Cohuasxon nachicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","—Maton nachiti noque hinannahue. Noquena ta nocahiqui —tanamabaan jaton huetsabo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Noquena xabanon matonah rihbi xabati rah ta noquen nachiti senentimahiqui. Jano marohibo janin maton nachiti marotanahue, hih ca hen jai ihsen —shinanyahpabaan jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Marohi bohiboya sca jaton patoro nocoti. Jaa manatax, huanomahi hahbetan hihcocani johueyahpabo. Mapescaiboya sca coirannicahban xehpoti xehpoquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chini sca nachiti marotani jahui xontacobo nocorihbihi. Nocoxon, jemanxon quenacanquin: —Patoron, noque quehpenxonhue, patoron. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Chichoxon sca ta jaan jato yohitihiqui: —Mato tah hen honanyamabiresai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jaa copi coiramenahue. Heen joti nete, heen joti hora tah man honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Papan jihuemahi ta huesti joni hocho canoxon jai quesca qui. Jaan cahen jahuen jonibo quenaxon jahuen jahuaborabo hinantahban. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Huetsa cahen pichca borasa coriqui hinanan. Huetsa cahen rabe res. Huetsa cahen huesti res. Jaabo jaya teeti hahtipahi tihi jato hinanpaquequin, jaton shinan tihi coriqui senenjaquin. Jato hinanbahini caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pichca borasa bichish, jan hinanmenoha jahuen coriquiya caxon, jahuaborabo maromaribinoxon maroquin. Basi jascajaxon huetsa pichca borasa rihbi coriqui bochojaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Rabe borasa hinanah jascajaribiquin. Jatíhi rihbi bochojaquin maroxon maromaxon coriqui bihxon, caíjaxon rabe bochojaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Huesti borasa hinanah cahen jascayamahi. Jaan cahen jahuen borasa bichish, caxon, mai poquinxon, jano jahuen patoronen coriqui jonequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Basihax sca jaton patoro joribiscai. Nocoxon, jato betan bexonoxon jato quenamapaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Quenamaha jan pichca borasa bocho hinantahni pari jahui. Jan cananxonai pichca borasa bocho bexon jahuen patoro jismaxon: —Pichca tah min hea hinantahbahinnihqui, Hihbon. Jatíhi rihbi tah hen jayaxon mia cananxonai. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Siri tah qui. Mia tah min siri joni qui. Sirija tah min jai. Mia tah hen hicha tahma hinantahbahinniqui. Rahma tah hen hicha sca mia hinanai. Hea jenimahi hihqui quescari hehbetanbi jenimahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Rabe borasa jan hinantahbahinni sca jahui. —Rabe tah min hea hinantahbahinniqui, hapon. Jatíhi rihbi tah hen mia cananxonai. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Siri tah qui. Mia tah min heen joni siri qui. Sirija tah min jai. Hicha tahma tah hen mia hinantahniqui. Hicha sca tah hen mia hinanai. Hea hen jenimahi hihqui quescari hehbetanbi jenimahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Huetsa sca jahui, huesti borasa bihnish. —Hapon, mia yonomis hihqui tah hen honannihqui. Mianbi banahahmabo tah min tsinquihi. Mianbi jahuen chishpo potaxonma tah min bichi. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jaa copi tah hen raquexon miin coriqui mihinnihqui. Nea tah qui, jise. Bihhue. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jaatian ta jahuen patoronen jaa yohitihiqui: —Joni tiroman, chiquishin, ¿heanbi bananihxonma hean tsinquihi min honannihquin nan? ¿Jano heanbi jahuen chishpo potayamahi janin hen bichi cahi min honanihquin nan? ");
INSERT INTO kaqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Hea jascapah honanxon heen coriqui jaya teenica hinantahtahin min janiquin jan jaya teenon? Jaatian tah hen joxon heen coriquinin cananai hashoan hicha bihquehahnai. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Heen coriqui jaa bichinnahue, hah ca mato jaihsen. Jaa bichinxon hoa chonga borasayahpa hinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Hicha jaibo tah hen hashoan hicha rihbi hinanxihqui, jan tsama sca janon. Jahuabi yamahibaana tah hen jaabo jai pishca jato bichintihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hojri bahquish chian sca nea chiquish potanahue. Jano ta saisaihihxon xeta tais tais hahcaibo rahsi jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Heen joti neten ta heen coshi xabaya hea noquebaque joyaxihqui. Heen yonotibo rihbi tah hen hahbeyaxihqui. Joxon ta heen quiquin hapo tsahotinin tsahoxon jatihibi quenamayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jaatian ta jatihibi jonibo hea bebonbi tsinquiyaxihcanihqui. Carneroboya chibo jai bi carnerobo rahsi jano huesti janon jaton hihbaan jato caisai hahcajaquin ta ramiho huesti tsama janon ramihoh rihbi texe hean nichinbohanyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Heen carnerobo ta heen mecayaho nihyaxihquiqui. Chibobo cahen memiho. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mecayaho nichibo sca tah hen quiquin hapo hihxon yohiyaxihqui: Benahue. Heen Papa ta matohon hihti queenihqui, man jenimanon. Man jano jihuenon jan mato bexojaxonai janin benahue, matonah sca jahuen jihue janon. Naiyahpa mai jariyamahiyabi ta mato jaa bexojaxonnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mato tah man hea pimanihbo qui. Picatsihquiton tah man hea pimanihqui. Jiricatsihquiton tah man hea xehamaniqui. Maton nahua hihqui bi tah man sirijaquin hea maton xoboho mapemaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chopanma hihquiton tah man hea sahuemaniqui. Hen hisinaiya tah man hea jisi caniqui. Sipo xobo tsahotaiton tah man hea yanapanniqui, hah tah hen jato jayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaatian ta jahuen siri jonibaan yocayaxihquiqui: ¿Jahuentian mia picatsihqui jisxon non mia pimanihquin, Hihbon? ¿Jahuentian mia xehacatsihquiton non mia xehamaniquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jahuentian non mia noquen nahua quescapa mapemaniquin? ¿Jahuentian non mia chopanma jaiton sahuemaniquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jahuentian mia hisini jai, jaa hihyamahax sipo xoboho tsahotai non mia jisi caniquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jaton quiquin hapo hihxon tah hen jato yohiyaxihqui: Man honannon tah hen mato yohihi. Nea heen huetsabo romishin jascajaxonquin tah man hea rihbi hahxonnihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Memiho quehabo sca tah hen nescajayaxihqui: Botannahue, tiromabon. Satanas jahuen tiroma yoshinbo betan jano cati chihi janin botannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hen picatsihqui bi tah man hea pimayamanihqui. Hen jiricatsihqui bi tah man hea xehamayamaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Maton nahua quesca jahuiton bi tah man hea mapemayamaniqui. Chopa bocabi tah man hea sahuemayamaniqui, hisinax, sipo xoboho tsahonah racatai bi tah man hea jisi cajaquetanyamanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jato jascajaha ta yocaticanihqui. ¿Jahuentian non mia picatsihqui jisniquin, Hihbon? Picatsihqui, jiricatsihqui, xobojoma, chopanma, hisinai, sipo xoboho tsahotai jahuentian non mia jascapa jisxon bi non mia hahxonyamanihquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jasca jaiboya tah hen jato yohitihi: Man honannon tah hen mato yohihi. Nescapa pishcabo maton jisí, jahuama quescapahbo, jato hahxonyamaquin tah man hea rihbi hahxonyamanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jato jascajaxon tah hen jato potascatihi, jascabijaquin casticanahbo sca janon. Heen siri jonibo tah hen queyoyamanox manati janin hiotihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jato jascajaquin haxemaquin queyoxon sca: ");
INSERT INTO kaqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Hoqueha bahquish ta pascua fiesta hihyaxihquiqui. Man tah man honanscai. Jaa neten ta hea jihuin hueonxon rehtehahbo hihxon hea bihmayaxihcanihqui —jahuen haxenicabo Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jaatianbi ta Caifas janeya hapon xoboho sacerdote hapobo betan jaton hahbe hapobo tsinquinishqui. Caifas jaton yohuan hihbo copi jano tsinquicani, yohuannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Quexexon Jesus paranxon bihxon rehteti yohinanax, jeenhihquinannancani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Fiesta naponbi tah bihtima qui. Jonibo sinayohuanax noque potacatsihcanmis hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betania jema janin sca Jesus cahi, sipiya hihpahoni jonin xoboho nocoti, jahuen jane cahen Simon, xobo hihbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jato betan pihi tsahoti Jesus jaiya sca huesti haibo jahui. Hahan hininjatiya joxon, jahuen pomo quiha xenin Jesus boshnashimaquin. Hihti copi jahuen hininjati. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus machicai jisish, sinatax yohuancani: —¿Jahua copi jaa jatihibi yohyoquihquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maromaxon ta hicha coriqui bihquehahniqui, jahuaborajomabo yanapannoxon —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jaabo yohuani jai honanxon sca: —¿Jahua copi man jaa haibo jatsanjahin? Hea ta sirijaquin hahxonaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jahuaborajomabo ta jascabi jatihiqui, man jato yanapannon. Hea tah man huetsatian jisyamascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hea tsahonahbo ta hea hininjahaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nincanahue hen mato yohinon: Jano heen joi siri nincacaibo janin jatihibi ta neatohon hea hahxonai yohuanchaniyaxihcanihqui. Jaa copi ta jaa shinanbehnoyamayaxihcanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jaatian ta jahuen haxenica huesti picoti canishqui, Judas Iscariote. Sacerdote hapobo janin cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jato qui nocoxon: —¿Hen mato bihmanon jahua man hea hinantihin? —jato jaquin. Coriqui toponxon sca janacanquin, treinta libra jan bihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bichish, cahi. Caxon, jahuentian cahra bihmahah siritihiquin hihxon shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jaton fiesta nocotai neten sca, jahuen haxenicabo joxon Jesus yocaquin: —¿Jahuerahnonxon pinoxon non mia fiesta neten pitijaxontihin, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Hoa non honanai joni yohitannahue jema janin. Heen nete ta nea pishcascaiqui. Miin xobohoxon tah hen heen haxenicabo betan fiesta pinoxihqui hih ta maestro jaiqui. Jascajatannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesusen raanah sca, bocani. Jan yohiha quescajaxon janoxon fiesta neten pitijacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bepi sca jaiya jahuen haxenicabo betan janoxon piquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Piresscaiboya jato yohiquin: —Man honannon hihxon tah hen mato yohihi: Nenohah ta huesti jaiqui, hea jato bihmaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hihti benatax sca tsoan jascajatihiquin hihquish huesti huestibo yocacancani: —¿Hea nan, Hihbon? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Hehbetanbi nea quenti qui piti bichi joni ta hea bihmanica qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Papan huishamani joi jai quesca ta noquebaque janoxihquiqui. Hea jascajati jai bi ta hea bihmahi joni Hahrai hihyaxihquiqui. Jahuen papan jaa baquejayamahah cahen siripan —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jaa bihmanoxihqui hihxon Judasen sca yocaquin: —¿Hea hin, Maestron? —Mia rahan —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pihiboya sca posen bihxon, Papa yocaxon, tehcaxon, jato hinanxon: —Bihnahue pinoxon. Nea ta heen yora qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tason rihbi bihxon, Papa yocaxon, jato hinanrihbiquin: —Nea xehanahue, jatihixonbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Heen jimi tah qui. Jonibaan hohcha copijaquin tah hen heen jimi potaxihqui. Mahuaquin tah hen mato hahxonbahinai. Jaa shinanhahnan xehati ta nea qui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mato betan huetsapahaquin xehayahnoxon caman tah hen nea xehati hahyamascatihi. Heen Papan jihue janin mato jihuemahi tian pari tah hen mato betan huetsapahaquin xehayaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pihax, behuahax, olivo janeya manan qui sca bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Janoxon sca jato yohiquin: —Nea yamebi tah man jatihibichin hea jenebahinnoxihqui, Papan huishani joi jai quesca tah man jatihi. Carnero coirannica tah hen rehtexihqui, heen carnerobo potojahtannon hihqui jaa joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jaabi tah hen hahquirihbi teehihquish Galilea main sca catihi, mato rihbi man jano hea merahi canon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—Caibaan mia jatihixonbi jenebahinai bi tah hen hean mia jenetimahi, hihbon —Pedronen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Quimisha coti hatapa queorihyamahi bi tah min nea yamebi heen joni hihtima min yohixihqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Hea rehtehibaan bi tah hen miin joni hihti ma hen yohitimabirestihi —hahscaquin Pedronen. Jatihixonbi sca jascajaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Getsemani janeya nahue chian sca becani, Jesus betan. —Neno tsahopaquenahue, Papa yocaqui hen hori canon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jato jascajaxon Pedroya Zebedeon baque rabe hori boquin. Jano sca Jesus hihti benati, hihti masa shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Mahuabena tah hen jai, hihti masa shinanquin. Nenoxonbi hea manahi banenahue, hea coirannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jato jascajabahini cahax, hori pishca beho racaxon Papa yohiquin: —Papan. Hea janoxihquibo jatimajahue, jatimajati hahtipahxon. Jaabi hea queenai quescayamahi bi mia queenai quesca janon hihmahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yocacax joxon sca hoxahiton jahuen haxenicabo meraquin. —¿Huesti hora pishca hea mananoxon man hoxa teneti hahtipahyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hoxa tenexon Papa yocanahue, tiroma yoshiman mato tiromamacatsihquin tanayamanon. Maton shinaman man teneti shinanai bi tah man hahan teneti coshi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jascacahini sca Papa yocaqui caribihi. —Papan, hea janoxihquibo jatimajati yamahiya mia queenai quesca janon jahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Joxon sca, hoxahiton jato merarihbiquin. Jaton bero quextojaquetax hoxa hoxacani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jato mohinaxma caribixon jahuen quimisha sca jascajaquin yocarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Joxon sca: —¿Man hoxaparihin? ¿Tanti tanti pari man jain? Jisnahue. Hohchayahpabaan bihnon bihmahi ta beresscacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hueninahue. Caresscatannon benahue. Hea bihmahi jahui ta nea nocoscaiqui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jato yohihiyabi jahuen haxenica huesti jahui, Judas. Hahbetan rihbi hicha becani, caibo machitoya, caibo chantiya. Sacerdote hapobaan raanah becani, judio hapobaan raanah becani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jato betan joriyamaxon ca Judasen jato yohihah: —Hen meraxon betsohahquin hicotanai joni tah qui. Hen betsohahquin hicotanai bihtannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nocotax sca ponte res Jesus qui jahuex, Min jascabi jayamahin hahxon, betsohahxon hicotanquin. Hicotanahbi: ");
INSERT INTO kaqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—¿Jahuejahi min jahuin, amigon? —Jesusen jaa jaquin. Jaatian nihquirani joxon bihxon Jesus menexcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jasca jaibaan bi huesti jahuen haxenicaton machito tsecaxon sacerdote hapon joni marequin bi cahnexon jahuen pabinqui paxtebahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—Miin machito bexojahue. Machitonen rehtenanaibo ta jahanbi mahuatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Heen Papa hean yocacah jan jahuen yonotibo sesenta mil raantihiqui min honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hea nescajayaxihquibo ta Papan huishani joi jaiqui. ¿Hen yocacaiya jenquetsahpax jan yohini quesca jatihiquin? —Jesusen jaa jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yahtannicabo sca yohiquin: —¿Jahua copi man rehtemis joni yahtanquin hahcajahin, machitoyaxon chantiyaxon hea chibanbenahin? Netetihibi Papan xoboho tsahoxon haxemahi bi tah man hea bihyamahipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Papan huishani joi jai quesca janon tah man nescajahi —hahquin jato. Jaatianbi jahuen haxenicabo jatihibi jabacani. Jesus yahtanahbo jenebahini bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Menexxonsca sacerdote hapo Caifas janin Jesus bocanquin. Jaa xoboho jaton huisha hapobo jaton hanibo tsinquiquihranscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jano Jesus hiohiboya hocho sca jato chibanquin Pedronen. Sacerdote hapon xoboho jaabo mapenon, jeman res Pedro nihnichi. Jaton sontaro tocan jano tsahoti, jahueja janoxihcanihquin hihquish manati. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chicho cahen sacerdote hapoboya texe judio hapobo yohuancani. Jaa copi rehteti janon hahqui yohuanai quesabo quenamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hicha quesabo jano mapetai bi jahua copi rehteti merayamacanquin. Chini sca huetsa quesa rabe nocoti. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Toa joni tah non yohuanai nincaquipiqui. Papan xobo tah hen potojaquetanxon quimisha neten hahquirihbi jaa xahnen xobojati hahtipahi hih ta jaipishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jaton quiquin sacerdote sca huenicahinxon Jesus yocaquin: —¿Min jahuabi yohiyamahin? ¿Jaabo mihqui yohuanai bi min jahuabi yohiti yamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yocacah bi jahuahihyamahi. Jahuabi yohiyamahiya, hapon yohirihbiquin: —Quiquin Dioscoinyaxon tah hen mia hihti yohihi quesaxonma min yohicoinnon. ¿Mia min Diosen baque Cristo quin? Noque yohihue. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Min yohihi quesca rahan. Hashoan rihbi tah hen mato yohihi: Papan mecayaho jahuen quiquin hapo tsahotai tah man hea noquebaque jisyaxihqui. Nai cohiman jahui tah man hea jisyaxihqui —Jesusen jaquin sacerdote hapo. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nincaxon, jahuen coton huaxabahinxon, jato yohiquin: —Dios qui ta tiromahi yohuanihqui. ¿Jahua hashoan non nincati pishinain? Jan tiromahi yohuanai tah man nincascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jahua shinan man jain? —Jan yohuanai copi non rehteti jai rahan —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jahuen bemanan qui toshbanhahxon, copasxon beshrishquicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rishquixon yocacanquin: —Yohihue, Criston. ¿Tsoan mia rishquihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jasca jaabo jai bi jemanhihti janin Pedro tsahoti. Jano tsahotaiton huesti haibaan joxon yohiquin: —Mia rihbi tah min hoa Galilea mai meha Jesus betan nihrasihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jano jaibaan sca jatihixonbi nincanon jahuen joni hihtima yohiscaquin: —Min yohuanai tah hen honanyamabiresai —Pedronen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nichibo tocan mehax huetsa haibo rihbi joxon, Pedro jisquin sirijaxon, jato yohiquin: —Nea coin ta Jesus Nazareno betan nihcachihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hahquirihbi jahuen joni hihtima Pedronen yohiquin. Dios quenaxon: —Jaa joni tah hen honanyamabiresai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Basiyamahax jano nichibosca joxon: —Hihcoini. Mia rihbi tah min jahuen haxenica qui. Min yohuanai tah non honanai. Janoha joni quescapah tah non mia nincacai —Pedro jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dios quenaxon, hihcoinyamahax hea mahuapahinon hihxon jascajaribiquin: —Jaa joni tah hen honanyamabiresai —Pedronen jaquin. Jaatianbi sca hatapa queoti. ");
INSERT INTO kaqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jesusen yohiha joi shinanrenenscaquin. Hatapa queorihyama jai bi tah min quimisha coti heen joni hihtima min yohixihqui. Jesus jascari yohuanah shinanax, picocahini cahax coshin huaohihscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Xaba paquescaiya sca sacerdote hapobo betan judio hapobo tsinquirihbixon sesion hahxon sca Jesus rehteti yohicanquin jatihibichin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Menexrihbixon jaton gobernador janin sca Jesus hiocanquin Pilato janeya gobernador janin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jaan bihmahah Jesus rehtenoxihquibohi jisxon, masa shinanxon sca Judasen jahuen treinta coriqui hinanrihbihi caxon, sacerdote hapoboya judio hapobo hinanrihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Hohchajoma joni mato bihmahi tah hen hohchatai —jato jaquin. —¿Min jascahah bi jahueja non noquen jatihin? Mianbi jise —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Papan xoboho jaa coriqui potaquin potojaquetanbahini Judas caresscai. Cahax risbipan tenexentax rontamehscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jahuen coriqui topihax sca sacerdote hapobo yohuani: —Hahan mahuamati coriqui tah qui. Papa hinanti bohnanti qui tah non nanetimahi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jaa copi ta jahanbi mai maroti yohinannishqui. Caxon sca huesti quentijanicaton mai maroncanquin, jano nahuabo mihinti janon. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaa copi ta jaa mai jimin mai hahcanihqui, rahma caman. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jasca ta janishqui Papan joi yohinica Jeremiasnen yohini quescabi: Joni ta jaatihi copitihqui hih Israelibo hapobo jaiya ta treinta coriqui bihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jahanbi ta quentijanicaton mai marocaniqui, heen hihbaan hea yohini quescabijaquin hihqui Jeremiasnen huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jaatian gobernador bebon Jesus nichi. Jano hihuehahbo Gobernador yocacahti Jesus: —¿Mia min judiobaan quiquin hapo quin? —hahquin. —Min yohihi quescari rahan —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Judio hapobo rihbi hahqui chanihah bi Jesus jahuabi yohuanyamascai. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatonen sca yocarihbiquin: —¿Mihqui hicha chanihibo min nincayamahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jabi ni huesti jaton joi qui Jesus yohuanyamahi. Jaa copi ta gobernador rahtenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jaa fiesta hahqui nocotai tihibi ta gobernadornen sipo xoboho tsahonnibo huesti jato picoxonpahonishqui, fiestajahibaan caisxon jaa jane yohihiya jaa jato picoxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jan jano tsahonni ta tiroma shinanya joni janishqui jatihixonbi honanaibo. Jahuen jane cahen, Barrabas. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Fiestajahibo tsinquijaquetaiton sca Pilatonen jato yocaquin. —¿Tsoa hen mato picoxonti man queenain? ¿Barrabas nan? ¿Jesus, Cristo hahcaibo nan? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Notsixon copi judiobaan Jesus hinanah ta Pilatonen honannishqui. Honanxon copi ta jonibo jascajaquin yocanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Janoxon joni ponteti sca Pilato tsahoscai. Jano tsahotai bi ta joni raanxon jahuen haibaan yohinishqui: —Siri joni tah qui. Jahuabi jahua hahyamahue. Rahma jaya namaxon tah hen hihti masa shinanai. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jascajaquin jahuen haibaan Pilato yohinon bi ta judio hapobaan tsamajaquetaibo nescajanishqui: Barrabas mato picoxonnon Jesus rehteti yocanahue, hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Quenataibo nincaxon sca gobernadornen jato yocaquin: —¿Rabe jai bi jahuemeha hen mato picoxonti man queenain? —Barrabas rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Cristo hahcaibo Jesus cahran? Jaa hen jahuejati man queenain? —Pilatonen jato jaquin. —Jihui qui hueonhue —hahcanquin jatihixonbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Jahua copi nan? ¿Jahua tiroma janishquin? —jato jaquin. Jato jascahah bi hashoan sca quenacani: —Jihuin hueonnue. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jan jano jahuabi hahyamahi bi hashoan sca corocanahibo jai jisxon, jeneya benahue jaax jaton jisnon bi mechoquihti. —Jahuen jimi ta hehqui hueoyamahiqui. Mato quibi ta paquetihqui, jisnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsinquijaquetaibo jatihibi sca nescari coshin yohuani: —Noque qui jahuen jimi paquenon, noquen baquebo qui rihbi jahuen jimi paquenon —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jaatian Barrabas jato picoxonxon, Jesus rishquihahbo jahuen sontarobo yohixon jato hinanquin jihuin hueonahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jahuen sontarobaan sca Jesus bihxon, gobernador xobo chicho hioxon, jaton hahbe sontarobo quenacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jahuen chopa potamaxon joshin coton sca sahuemacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Moxa maitijaxon, maimaxon, tahua xecomaxon, jaa bebon raboxonen nihxon hosan hosancanquin. —Jee, judiobaan quiquin hapon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jascajaxon, hahqui toshbanhahxon, jahuen tahua bichinxon hahanbi mashrishquiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hosan hosanxon jaa joshin coton pecaxon jahuen coton sahuemaribixon, jihuin hueonnoxon sca Jesus bocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jemama qui picoti caxon sca Simon janeya joni meracanquin, Cirene mai meha joni. Jaa jahuen coros hiamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Manan qui nococani, Golgota janeya manan. Golgota ta mapo xao manan hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xehati mocani xehanon hinanahbo bi tanahax queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jihui qui tasaxon rontanxon sca jahuen chopa metisahnoxon tsoan bihtihiquin hihxon borasa qui macan bero nanexon chicohah, huetsa macan pari cainaiya huetsan bihnon, huetsa macan pari cainaiya huetsan bihquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Coirani sca sontarobo tsahopaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jaa bochihori ta quirica hueoncannishqui, jaa copi rehteha joibo jano janon. Nea ta Jesus qui, Judiobaan quiquin hapo, hihqui jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yometso rabe rihbi sca tasaxon rontancanquin jaa senenbi. Ramiho huetsa, ramiho huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jano huinotaibaan ta hosan hosancannishqui, jaton mapo bose bosehihcanaxon. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Papan xobo potojaquetanxon quimisha neten jaa xahnen hahquirihbi xobojanica hihquish, janohax siri sca johue Papan baque hihquish, jaa jihui janinhax botoquihranhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdote hapobo betan texe judio hapobaan ta jascajaquin rihbi hosancannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Huetsabo jihuemati hahtipahxon bi ta hahri jihuemati hahtipahyamahiqui. Israelibaan quiquin hapo hihquish, jan coros janinhax botopaquenon. Jaatian tah non nincacointihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Papa Diosen baque hihqui ta shinannishqui. Queenxon, Papan jaa botonxon rohajascanon. Hea tah hen Diosen baque qui jan jaipi hih ca hen ja hisen —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jascajaquin rihbi ta hahbe hueonahbaan hichaquin hosannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Barin manan tsahcahiya sca ta yamecahinnishqui, jatihibi mai janin. Nai pohapaque bari janon caman bahquishihpi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bari nai pohapaquetaiya sca ta coshin bi res Jesus yohuannishqui: —Elí Elí lama sabactani. Papan, Papan, ¿jahua copi min hea jenebahinain? hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nincacax: —Elías ta quenahiqui —hihcani jano nichibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huesti bishquihihcanahi caxon, taco quescapa bihxon, xehati cachaqui maosahxon tahua qui queonxon sananhihnixon xehamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Caibaan sca: —Jenehue. Jaa botoni Elías jotihiquin non tah non jiscatsihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hahquirihbi coshin bi res quenatax sca Jesus mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jaatianbi ta Papan xoboho hahan chiqueti chopa rontamehtai huaxacahinnishqui, bochiquihax naman caman, rabe teque sca janon. Mai rihbi ta mihuannishqui. Macamahnhuanbo rihbi ta caxquecahinnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Cristo hihquipish bi teehihribihi pecaho ta tsahonbo rihbi quehpemehnishqui, neateman hihni Papan baquebo yorayabi teehihribihax huenihihnatax bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jaabo ta jaa jema janin nichi bocannishqui, hihti caibaan jisnonbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesus mahuataiya jascapa huinotai jisish ta jano coiranai sontaro capitan hihti raquenishqui, jahuen sontarobo rihbi hihti raqueti. —Jaa ta Papan baque coin hihnishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hochoxon rihbi ta hichaxon haibobaan coiranxon jisnishqui. Jaabaan ta Galilea mai janinhax Jesus betan jahui haibobo janishqui, pitijaxonaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Huetsa ta María Magdalena janeya janishqui. Huetsa cahen María Jacobon mama, Josepan mama. Huetsa cahen Zebedeon baquebaan mama. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bepi sca Arimatea jema janinhax coriquiyahpa patoro jahui, José janeya. Jesusen haxemaha nincacoinni joni. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato janin caxon sca ¿Jesusen yora hean bihtimahin hahca, Pilatonen Bihhue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jahuen yora botonxon sca sabana pahtsacah siripan rahcoquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Rahcoxon boxon, tsahomehyanoxon jano jan macan manan xanqueman poquinipi janin mihinquin. Heen tsahonti janinbi tsahonpan hihxon jano Jesus mihinquin. Tsahon xehponoxon sca hihtihosi macan taranbohanxon xehpoquin. Macaman xehpobahini sca caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jaa tsahon patax sca María Magdalena betan huetsa María manati tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jaton tantiti nete janon jaa nete queyotaiya sca sacerdote hapobo betan fariseobo Pilato janin bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nocoxon: —Hapon, hoa paranmis bihyamaparixon tah non yohuanai nincaquipiqui. Jaa tah non rahma shinanai. Quimisha neten hihquipish tah hen teehihribiyaxihqui hih ta jaipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jaa copi yohihue, jahuen quimisha neten caman jahuen tsahon coiranahbo. Jonetax jahuen yora yometsohtax teehihrihbi ta jaipishqui —hih jahuen haxenicabo jamis, jonibo parani. Jascajaquin paranah ta jan jato paranmenopahoni mentan hashoan tiroma jatihiqui —Pilato jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Hoa cahisen, sontarobo. Jato boxon, man honanai quescajaquin jato coiranmatannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Caxon sca, hahan xehpoti macan boyacanquin. Boyaxon honantijaxon coiranahbo sontarobo quenimacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jascahipibo pecaho jaton tantiti nete huino sca jaipi quen xaba paqueti hochoma sca María Magdalena betan huetsa María cahi, tsahon jisi. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cahiboyabi naihoh quehax Papan yonoti huesti botopaqueti jahuiya coshin bi res mai mihuani. Botopaquexon hahan xehpoti macamahnhuan taranbohanax jaa cahtsahoscai. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jahuen yora cana bacahi quescari xabati. Jahuen chopa cahen joxo bi res joxo. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jaa jisish ca hihti raquetax tastahihcanahax sontarobo racareneni mahuataibo quescapahax. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Haibobo nocotaiya: —Raqueyamanahue. Rehtepibo Jesus benahi man jahui tah hen honani. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nenoma ta qui. Jan yohipi quescari ta teehihribihaxqui. Jano racanipibo jahuen tsahon jisi benahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Histon caxon sca jahuen haxenicabo yohitannahue. Hihquipish bi ta hahquiribi teehihquishqui. Mato bebohi ta Galilea main cahiqui. Jano tah man jaa jisi catihi. Mato tah hen yohiscai, jato jascajaquin yohitannahue —Papan yonotinin jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Histon sca bocani. Tsahon janinhax hishtocanahi cahi, raqueya jenimahax jahuen haxenicabo yohihi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cahitonbi jato behchihi Jesus jahui. —¿Man jascabi jayamahin? —jato jaquin. Jato jascahah bi pontecahini caxon jaa bebon betihihpaquexon taxecocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Raqueyamanahue. Galilea main bohábo heen huetsabo yohitannahue. Jano ta hea jisyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jato yohihi haibobo bohiboyabi sca tsahon janinhax sontarobo rihbi bocani. Jeman caxon rahma huinotah jatihibi sacerdote hapobo yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Judiobaan hapobo betan tsinquixon sca jahueja sca non jatihin hihquish yohinanxon sontarobo hicha coriqui hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Coriqui hinanxon: —Non yame hoxahiya ta jahuen haxenicabo joxon jahuen yora bichincanaxqui hihnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Man jascari yohuani jai chanihah noquen gobernador sinataiya tah non jaa rihbi raejatihi, mato jahuejayamanon —sontarobo jacanquin sacerdotebaan. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jaa coriqui bichish sca jascari yohuani bocani, sacerdotebaan yohihah quescari. Jascari yohuannihbo copi ta rahma caman jatihibi Judea mai janin jascari yohuanchanicaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Galilea main sca ta jahuen haxenicabo bocanishqui, once joni. Jano nocoyaxahnahue Jesusen jato yohipi manan janin nococani. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jano Jesus meraxon, hahqui raboxonen tisquihahpaquehcanquin. Jesus tah qui hih caibo janon bi jaa hin Hen tah hen honancoinyamahi hih caibo jaribihi. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jato qui joxon sca: —Papan ta hea jatihibi hihbomascaiqui, naiho jai jatihibi, main jaibo jatihibi rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaa copi jatihibi mai janin caxon jano jaibo haxematannahue. Heen Papan janen, jahuen baquen janen rihbi, jahuen yoshin siripan janen rihbi jato nashimatannahue, heen jihuetahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jascajanahue hahquin hen mato yohipahoni joibo jatihibi jato haxemanahue, jascajahabo. Nete queyonon caman hen mato betan jascabihi jayaxihqui honannahue.");
INSERT INTO kaqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Papan baque Jesucristo joi siri ta nescari pehocohnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Papan joi yohinica Isaiasnen pari ta nescajaquin huishanishqui: Jise. Mia bahixonnon hihxon tah hen heen joi yohinica pari raanai. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaa ta cahchiho jano tsoa jihueyamahiton nichish coshin yohuanyaxihquiqui: Bahixonnahue jahan hihbo jonon. Jahuen bahi najisti chaibo hahxonnahue hih ta jaa jayaxihquiqui hihqui Isaiasnen huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Isaiasnen yohini quescajaquin nashimahi ta Juan cahchiho jano tsoa jihueyamahiton canishqui. Cahax coshin yohuani: —Papan maton hohcha sohuanon maton shinan pontenahue hen mato nashimanon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jascajahiya ta Judea mai mehabo, Jerusalen jema janinhahbo rihbi Juan qui bocannishqui jatihibi. Jaton hohcha Papa Dios yohihiya cahen Juaman jato nashimaquin Jordan huean janinxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juaman ta camello rani chopa sahuepahonishqui. Bichi cinturonen chinexehti. Champo pipahoni. Bona jaene rihbi xehapahoni. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","—Hehchon ta hea mentan hashoan shinanya noque joyaxihquiqui. Jaa hihti siri copi tah hen chiquerehue tsahopaquexon jahuen sapato risbi pecaxonti betan hea senenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hean hen mato jenen nashimahi bi ta jahuen jonibo man jai honanahbo hihxon Papan mato jahuen Yoshin hinanyaxihquiqui, nashimaquin hahcajaquin hicha hinanquin —Juaman jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jascascaiya Galilea mai meha Nazaret jema janinhax Jesus jahui. Jahuiya ta Juaman jaa nashimanishqui Jordan huean janinxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nashimaha cahen jene janinhax mapexon nai huiso quehpemehtai Jesusen jisquin. Dios Yoshin nobex quescapah hahqui botopaquetai jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jaatian: —Mia tah min hen hihti queenai heen baque qui. Mihon ta hen jenimahi —hihqui naihoh quehax yohuanai joi. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jaa pecaho ta Dios Yoshiman Jesus cahchiho camanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta neten cahchiho Jesus nichi yohinahbo tocan. Jano nichiton ta Satanasnen hohchamacatsihquin tananishqui. Papan yonotibaan sca ta Jesus pimanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jaatian sca Juan sipojahipibo pecaho sca Jesus caribihi Galilea main. Papan joi siri yohibonahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Papan mato hahxonti nete ta nocoscaiqui. Papan jihuemahi joti ta nea pishca sca jaonahiqui. Maton shinan pontenahue. Papan joi siri bihcoinnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea hian quexa sca quetanbonahi cahi. Caquin bi Simon jahuen huetsa Andres betan jisbonaquin. Tarrafa potahiton jato jisbonaquin, yapa bihnica rabe. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Hehbe bonahue, joni hionica sca hen mato hihmanon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jascaha jaton tarrafa potabahini sca hahbe bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jaatian caribiquin bi Zebedeon baque Jacobo jisbonaquin. Jahuen huetsa Juan betan nontinxon jaton tarrafa honahiton jisbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisxon jato quenaquin. Quenaha jahuen jonibo betan jaton papa nontinbi banenon Jesus betan sca bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaum jema janin sca nococani. Tantiti neten sca haho tsinquiti xoboho hihcoxon Jesusen jato haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Haxemaha rahtecani. Huishani honanbaan haxemahi quescajaquinma bi hapon hahcai quescajaquin jato haxemaha ta rahtecannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jaa xoboho rihbi cahen tiroma yoshinyahpa joni huesti jai. Jaan cahen joi coshin yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Min noque jahuejatihin, Nazaret janinha Jesusen? ¿Min noque queyohi jahuin? Min tsoa quin hen ta hen honanai. Diosen raanai tah min qui —hahquin yoshiman. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusen sca jaa yohiquin: —Netetax jahuen yora janinhax picohue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jan jascaha jaa joni tastahihmahax sai saihihquish tiroma yoshin picoti. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jatihibi sca rahtetax yocacahanani: —¿Teeee, jahua joni hin? Honanmati joi behna tah qui. Hapon hahcai quescajaquin ta haxemahiqui. Yoshin tiromabo ta yohihiqui. Jaan catanhue hahca ta bocanihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Janohax cahen histon bi res Jesus qui yohuanscacani Galilea mai jatihibi janinhahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaatian sca haho tsinquiti xobohoh quehax cainax Andres betan Simoman xoboho hihcocani Jesus, Jacobo, Juan. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoman haita cahen yonatax racati. Jesus yohiscacanquin, Jaa ta hisinihqui, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yohihahbo metsontanxon hueniquin. Huenihah rohacahinxon jato pimascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jaa bepi bari hihquiscaiya sca ta hisinyahpabo, tiroma yoshinyahpabo rihbi jato jatihibi Jesus qui hiocannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jaa jema janinhahbo jatihibi Jesus janin xehqui patax tsamajaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jano cahen mesco hisinyahpabo Jesusen rohajaquin hihti caibo. Hicha tiroma yoshinbo rihbi netemaxon picoquin. Jaa honanaibo copi jato netemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mohiyahtax hihari sca xaba paqueri jaima huenitax Jesus cahi jano tsoabi yamahiton. Janoxon sca jahuen Papa yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jaatian sca Simon, jaabo, Jesus benahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Meraxon yohicanquin: —Jatihixonbi ta mia benacaniqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Huetsa jemabo janin sca canon bonahue, jano rihbi Papan joi yohinon. Jaa copi tah hen jahuequi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jato jascahax Galilea janin sca Jesus nihnichi jatihibinco. Haho tsinquiti xobohoxon Papan joi yohibonahi cahi. Tiroma yoshinbo rihbi picoquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jaatian cahen huesti sipiyahpa joni Jesus qui joxon hihti yocaquin. Raboxonen tisquihahpaquexon yocaquin: —Queenxon ta mian hea rohajatihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jahan hihti shinanxon mehancahinxon mehexon Jesusen sca yohiquin: —Queen tah hen jai. Rohascahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jan jascahah hisinyamascai, rohascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jaatianbi jaa catannon sca Jesusen hihti yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Tsoabi yohihaxma sacerdote qui catanhue, min rohascai jismahi. Min rohahi copi Moisesnin yohini hinanti hinantanhue min rohascai honanahbo —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesusen jascahah bi cahi. Jan rohascai yohibonahi cahi. Yohibonahiya cahen jema janin jahuibo hichahiya jeman cati Jesusen hahtipahyamascaquin, jaa yocacatsihquibo hichahiya. Hueneman res cahi. Jatihibi janinhax sca Jesus qui bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Huetsa neten sca cahen Capernaum janin hahquirihbi Jesus nocoti cahi. Jahuen xobon jaa nocoscai cahen nincacanquin janohahbaan. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hicha joni tsamajaquetaiya cahen xobo senenyamascai, xehqui pataxbi jahuenbi nihcahuantimahi. Jaan ca Papan joi jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jahuen yora honanyamajaquetai joni sca hihuehi becani, chosco joni. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Joni tsamajaquetaiboya Jesus pataxti hahtipahyamaxon Jesus mahchi xobo pemacanya tsecaquin. Quinijaxon jahuen cacajatiyabi jaa joni botonpaquecanquin. Yora honanyamajaquetai joni hahan racatai bi botonpaquecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Rohajatihi shinancoinaibo jisxon yora honanyamajaquetai joni sca Jesusen yohiquin: —Miin hohcha ta sohuá scah qui, baquen —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jano rihbi cahen jaton jointinin shinani tsahocani huishani joi honanbo. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Jahua jenquetsahin nea jonin jascajaquin yohihiquin? Tiromahi ta yohuanihqui. Papa huestichin ta hohcha sohuati hahtipahiqui —hihcani jaton jointinin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jaton jointinin jascajaquin shinanaiboya jahuen shinaman honanscaxon Jesusen jato yohiquin: —¿Jahua jenquetsahin man jascajaquin shinanain maton jointinin? ");
INSERT INTO kaqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jahue meha joi nea yora honanyamajaquetai joni yohiti hashoan teema quin? ¿Miin hohcha ta sohuá scah qui hihqui nan? ¿Hueníhue, miin cacajati bichish caresscatanhue hihqui nan? ¿Jahue meha hashoan yohiti teema quin nan? ");
INSERT INTO kaqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nai nequebihoxon hohcha sohuati hihbo hea jai man honannon hihxon tah hen nea sca yohihi —jato jaxon yora honanyamajaquetai joni sca yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mia ta hen yohihi. Huenihue. Miin cacajati bichish miin xobon caresscatanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yohihah huenixon jahuen cacajati bichish res sca jaton jisnonbi caini. Jatihixonbi jisish rahtetax siripi Papa qui yohuancani: —Jahuentianbi tah non jascajahi jisyamaniqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hian quexa sca cahen Jesus caribihi. Jatihibi jonibo hahqui tsamajaqueti, jaan jato haxemanon. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jano huinoquin bi Leví sca meraquin Alfeonen baque. Janoxon coriqui cobranti janin hapobaana cobranxoni tsahotai meraquin. Meraxon: —Hehbe cahue —hahquin. Jan jascahah huenicahuanax hahbetan cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pihi benahue hahca Levin xoboho sca jahuen haxenicaboyabi Jesus cahi. Jesus betan hicha joni bocani. Nocotax pihi tsahoti hicha cobranxonaiboya hicha hohchayahpabo rihbi jano tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hohchayahpaboya cobranxonaibo betan Jesusen pihi jisxon huishani joi honan fariseobaan jahuen haxenicabo yocacanquin: —¿Jahuejanoxon cobranxonaiboya hohchayahpabo betan pihiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jascajaquin yocacaibo nincaxon Jesusen jato yohiquin: —Hisinjomabo pishinaima bi ta hisinyahpabo rahonica pishinihqui. Hohchajoma jonibo quenahima bi tah hen hohchayahpabo quenahi joniqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jaatian sca cahen Juaman haxematibaan piti tenenish. Fariseobaan rihbi piti tenequin. Jesus qui caxon fariseobaan Jesus yocaquin: —¿Jahua jenquetsahin Juaman haxenicabaan piti tenenon fariseobaan haxenicabaan rihbi tenehi bi minabaan piti teneyamahihquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusen jato yohiquin: —¿Jato betan huanohi joni hihparihiya huanoquin quenamahibaan piti tenetihiquin? Jato betan huanohi joni hihparihiya ta piti tenetimahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Huetsatian ta jatoma qui huanohi joni hionyaxihcanihqui. Jaatian pari ta piti teneyaxihcanihqui quenamahibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tsoanbi ta hotsinica chopan chopa payo honayamahihqui. Jascajaquin honahah ta hona teresihqui hashoan huaxascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsoan rihbi ta hompa rahma nehsehihqui bichi borasa xeni qui mahneyamahihqui. Jascahah ta hompa pohtoshihmatihiqui, xehati yohyocohnon borasa rihbi masascanon. Hompa rahma nehsehihqui ta borasa behna qui mahneti qui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Huesti tantiti neten sca cahen trigo huai nabebacahini cahi. Hahbetan caquin jahuen haxenicabaan trigo bimi tesabonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseobaan sca Jesus yohiquin: —Jise. ¿Jahua jenquetsahin jaabaan jascajahiquin, tantiti neten jascajatima joi jai bi? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jascahahbo jato yohiquin: —¿Jahua pitimahiya hahbe cahibo rihbi pihan hihquiya jaa rihbi pihan hihxon Davidinin hahni man jisyamaniquin huishani joi janin? ");
INSERT INTO kaqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar sacerdotebaan hapo hihqui tian ta Papan xoboho David hihconishqui. Jaa paan sacerdotebaan res piti que bi jaan piquin. Jahuen jonibo rihbi piquihinquin —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jato jascajaxon yohirihbiquin: —Tantiti nete copi joni jaima bi ta joni copi tantiti nete jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaa copi ta hea noque baque tantiti nete hihbo qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jaton haho tsinquiti xoboho cahen Jesus hihcorihbihi. Meyosmahi noque jano rihbi jai. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesus jisquin sirijascacanquin. —Rohaja ra ta jatihiqui tantiti neten hihqui bi —hihxon jiscanquin jaya yohuanti janoxon cahecatsihquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesusen sca meyosmahi yohiquin: —Noque tocanbi johue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jascajaxon tsahotaibo yocaquin: —¿Tantiti neten sirijati joi jaiquin? ¿Masajati joi jaiquin? ¿Teehihmati joi jaiquin? ¿Rehteti joi jaiquin? —jan jascahah bi jahua hihyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Benaya bi sinaxon sca Jesusen jato bejispaquequin. Jointi chahomayabo copi benati. Meyosmahi sca yohiquin: —Miin mequen sanahihnihue —hahquin. Sanahihnihax rohascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jaa rohajahi jisish cainax herodianobo betan sca fariseobo hahqui yohuancani: —¿Jenquetsahaxon non Jesus mahuamatihin? —hihcani yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hian janin sca jahuen haxenicabo betan Jesus caresscai. Hahchon bocani hicha jonibo tsama bi res. Galilea mai mehax, Judea mai mehax. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalen janinhax, Idumea janinhax, Jordan hoque quexa quehax, Tiro janinbohax, Sidon janinbohax. Tsama bi res hahqui cahax tsamajaqueti. Jatihibi jan hahcaibo nincacax tsamajaqueti hashoan nincacatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Main tsamajaquetaibo hahqui tsehquesihquiboya jahuen haxenicabo sca yohiquin: —Nonti jistannahue non hahan canon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jan hicha rohajahipi copi hisinyahpabaan jatihixonbi Jesus mehecatsihquish hahqui tsamajaquetax tsehquesihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yoshin tiromabaan rihbi Jesus jisish hahqui betihipaquetax joi coshin yohuani: —Mia tah min Diosen baque qui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jonibaan yoshin jascari yohuanai nincayamanon hihxon, jato hihti yohiquin: —Yohuanyamanahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mananahbo sca cahi. Caxon jan caisaibo quenaquin. Quenahah hahqui bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doce joni cahen caisquin, hahbetan nihnon. Papan joi yohinicabo raannoxon jato caisquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tiroma yoshin potati hihbobo hihnon jato caisquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Huetsa cahen Simon. Jaa cahen Pedro janequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Huetsa cahen Jacobo, Zebedeon baque. Huetsa cahen Juan Jacobonen huetsa. Jabo rabe Jesusen Boanerges janequin. Boanerges cahen terenhihca baquebo hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Huetsa cahen Andres, huetsa cahen Felipe, huetsa cahen Bartolomé, huetsa cahen Mateo, huetsa cahen Tomas, huetsa cahen Alfeon baque Jacobo, huetsa cahen Tadeo, huetsa cahen Simon Celador, ");
INSERT INTO kaqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","huetsa cahen Judas Iscariote, Jesus bihmanica. Jaa rahsi caisquin, doce joni. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Xobon sca Jesus cahi. Hahquirihbi tsamajaquetaiboya piti hahtipahyamascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jascascai nincacax jaa bichi sca jahuen jenabo cahi. —Tehquehih sca ta jaiqui —hihxon jaa bichi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalen janinhax jahuex huishani joi honanbo rihbi yohuani: —Tiroma yoshin hapon yanapana ta tiroma yoshin picohihqui. Beelcebunen ta jaa hihbojascaiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jascahiton: —Benahue —jato jaquin. Jahuiboya sca jaa patax queha joibo sca jato yohiquin: —¿Jenquetsahaxon Satanasnen Satanas picotihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Huesti mai mehax jaabo rahsibi rehtenananax ta queyoscatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huesti xobo mehabo jaabo rahsibi rehtenananax ta jaabo queyoscatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanas hahbe Satanas betan rehtehahax cahen jaabo queyoscaan, hahri queyocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Coshi jonin xoboho ta tsoabi yometsohti hihcoti hahtipahyamahiqui, hihbo nexayamahax. Hihbo nexaxon pari ta jahuen jahuaborabo bichintihiqui, jatihibi queyobahinnoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yohicoin ta hen mato jai: jatihibi hohcha ta jonibo sohuatihiqui. Papa qui tiromahi yohuanaibo rahsi rihbi ta sohuatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jascapahbo sohuaxon bi ta Dios Yoshin qui tiromahi yohuanaibo Papan jahuentianbi sohuatimahiqui. Jascapa hohcha ta jascabihi sca banetihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jaa ta tiroma yoshinyahpa qui jaabo jai copi cahen jato jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jahuen mama betan jahuen huetsabo sca nocoti. Jemanhihti janin nihxon Jesus quenamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsamajaquetax tsahotaibaan sca yohixonquin: —Miin mamaya miin huetsabo ta jeman qui. Mia ta quenamacaniqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jaan sca joi bichinquin: —¿Tsoa heen mama quin? ¿Tsoa heen huetsabo quin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tsahohahtancahuanaibo bejispaquexon sca: —Neabo ta heen mama heen huetsabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Papa queenai quescajanicahbo ta heen huetsa, heen choca, heen mama qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jaatian sca cahen hian quexaxon Jesusen jato haxemaribiquin. Hicha joni hahqui tsamajaquetaiya nontin nanetax tsahoti tsamajaquetaibo hian quexa banenon. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Janoxon sca hicha jaa patax queha joi jato haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Nincanahue. Mihsahahnicahton cahen jahuen bimi bero mihsahahbonahi cahan. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jan mihsahahca can caibo bero bahinbi paqueti. Jano paquetaibo topibonahi sca hihsabo cahi queyobonahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mai chahoma janin caibo rihbi paqueti. Hihquiyamahax histon joconi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Joconai bi barin hahca hashoan xanahax jahuen tapon chicho cayamahax pehuahax res sca xanahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Moxa tocan rihbi caibo bero paqueti. Moxa pari hanixon rishquihah bimi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mai siri janin rihbi caibo paqueti. Hanihax bimihi siripi. Jaa bero hanihax bimihi caibo quiha treinta bero, caibo quiha sesenta bero, caibo quiha cien bero sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hahan nincati pabinquiyahpaxon nincanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tsamajaquetai jonibo boresscaiya Jesus qui banejaquetax jahuen doce jaabo yocacahcani. Jan yohiha jaa patax queha joibo honancoincatsihqui yocacahcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yocaca jato yohiquin: —Papan jihuemahi jone joi mato honanmaxon tah hen jaa patax queha joi rahsi jaabo nincamahi nincayosmabo quen. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jis jisxon bi jisyamahabo, ninca nincaxon bi nincayamahahbo, jaton shinan pontehax jaton hohcha yamamis hihxon nincayamahibo copi tah hen jaa patax queha joi rahsi jato nincamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jato jascajaxon Jesusen yocaquin: —¿Hen rahma yohiha jaa patax queha joi man honanyamahin? ¿Jenquetsahaxon sca man jatihibi jaa patax queha joi honantihin? ");
INSERT INTO kaqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bero mihsahahquin hahcajaquin ta mihsahahnicahton joi yohibonahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bahinxon nincacaibo ta nescapah qui. Yohibonahi joi nincacaibaan bi ta Satanas joresscaxon jaa joi jato bichinihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jascajaquin rihbi ta mai chahoma janinxon joi nincamaha jenimarenenscacaniqui. Nincacoinax, jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jenimahax bi jaton tapon chicho cayamahax quescaxon basimaxon jenescacanquin. Jaa joi jaiton caibaan jato hosan hosana jenescacanquin. Nincacaibo copi caibaan tiromajacatsihquin chibana jenescacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Caibo rihbi ta yohibonahi joi moxa tocanxon nincacaibo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Jahuen teebo jan shinanai ta moxa quesca qui. Coriquiyahpati shinanax paramehti, jahuaborabo jan hashoan queenyorahi rihbi ta moxa quesca qui. Jaan rishquihah bimiyamascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mai siri janin joi nincamaha ta nincacoinnicabo qui. Bimihi siripi. Huesti bero joconax caichi, caibo quiha treinta, caibo quiha sesenta, caibo quiha cien bero —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jaatian sca jato yocaquin: —¿Jahuejahi non johueyahpa chiqueho jotihin? ¿Quenti behonbohana naman tsahonih nan? ¿Jano hoxati tapo naman tsahonih nan? ¿Jano johue tsahonti janin tsahoni non jaaya joyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yohiyamayaxihqui jone joi ta yama qui. Joneha jismayamayaxihquibo yamarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hahan nincati pabinquiyahpaxon nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Man nincacai nincaquin sirijanahue. Man hinannoxon toponaitihi ta jatíhi rihbi mato hinantihiqui. Hashoan rihbi sca ta mato hinantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jaibo bi ta hashoan jaan hinantihiqui. Yamahibo bi ta jaabo jai pishca jato bichintihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jascajaxon jato yohirihbiquin: —Papan jihuemahi ta nescapah qui. Huesti jonin cahen bimi bero main mihsahahbonahan. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hoxashinahax mohiyahtax, jasca jan hicha neten jaiya, jan mihsahahbonahipi bero joconscaax hanihi. Jenquetsahax hanihiquin jaan honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Main joconaibo ta hahmebi bimihihqui. Pehi pari caini, bimihax res sca bero caniscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Canihiton ta tsinquiscanoxon xatebonacaniqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jascajaxon jato yohirihbiquin: —¿Papan jihuemahi ta nescapah qui hihxon non jahua yohuan jatihin? ¿Jahua jaa patax queha joi non jatihin, Papan jihuemahi joi nincamanoxon? ");
INSERT INTO kaqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Papan jihuemahi ta moxo bero quescapah qui. Main banahah bi ta jatihibi jihui bero mentan moxo bero hashoan hexti romishin qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jascapah cahen banahipi joconi. Hanihi. Jatihibi banabo mentan hashoan hanihi. Hihtihosi mebihi, hotahi joxon hihsabaan sca jano nahajanon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jascajaquin hicha jaa patax queha joi yohixon Papan joi jato nincamaquin jaabaan nincati hahtipahi tihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jaa patax queha joi rahsi jato yohiquin. Huetsa jonibo jato betan hihyamascaiya cahen jahuen haxenicabo rahsi jatihibi yohiquin sirijascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jaa neten bari hihquiscaiya cahen jahuen haxenicabo yohiquin: —Hoque quexa pohquejaqueti bonahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsamajaquetaibo jenebahinax res sca hahan jan tsahotai nontin Jesusyabi pohquejaquecani. Huetsa nontibo rihbi hahchon pohquejaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nihuehnhuan sca jahui. Behchoman nonti tsahcaquin. Nonti qui nachicohti jene bochonon. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jascarai bi Jesus nonti chishqui quiri hoxahi. Nonti tsahotinin racatax tepitinin tepihax hoxahi. Mohinxon sca yocacanquin: —Maestron, ¿non mahuataiya mia jahua hihtimahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mohinah nihueyahpa hian yohiquin: —Tantiscahue. Behchonyamascahue —jan jascahah nihue tantihi, behchon yamascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—¿Jahua jenquetsi man raquetain? ¿Man shinancoinyamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jan jascahah rahtetax yohinanancani: —¿Jahua hihxon yohihah nihuen bocabi nincaquihquin? ¿Hiaman bocabi nincaquihquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hian hoque quexa Gadara mai qui sca nococani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nonti janinhax mapetaiton yoshin tiromayahpa joni Jesus behchihi jahui. Tsahonnihbo janin cahuan cahuani jihuetax joxon behchiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tsahonnihbo janin jaa cahuan cahuani nihrasihi. Tsoanbi nexati hahtipahyamahi joni, cadenanen bocabi nexatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hicha coti cadenanen tanexxon menexahbaan bi jaan cadenabo tehcaquin, hahan tanexahbo tehcapaquequin. Jaa xecoti tsoabi coshi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jascabi tsahon tocan nichish mahchi rihbi manichish sai saihihshinahax sai saihihbahinahax hahmebi macaman tsehuérahsihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jaan cahen hochoxon Jesus jisish hishtoquihrani jahuex hahqui betihihpaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Picohue Jesusen jaá bi betihihpaquexon coshin bi res yohiquin: —¿Hea min jahuejatihin, Jesusen, queya queha Diosen baquen? Diosen noque jisnon tah hen mia hihti yocacai: hea tiromajayamahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","—Jahuen yora mehax picohue, yoshin tiroman —Jesusen jaá jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesusen sca yocaquin: —¿Mia min jahua jane quin? —hahquin. —Heen jane ta Legion qui, noque non hichahi copi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jascajaxon yoshiman hihti yocaquin, huetsa main jato camayamanon. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jano rihbi ta hicha repinica cochi janishqui mananan pibonahibo. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—Cochi qui sca noque camahue, jato qui non hihquinon —hahquin yoshiman hihti yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jascajaha Jesus jeenhihqui. Yoshin tiromabo picotax res sca cochi qui sca hihquihi. Hihquihiboya jaa repinica dos mil rocohihcanahax quempe janinhax cayahax jenenencanya hihquihax hahsatax mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cochi coirannicahbo sca jabaxon yohibonaquin jema janinxon, huenemanxon rihbi. Jaabaan yohihah cahen jahuahi jacanaxquin hihquish honani sca bocani jano jihuetaibo. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus qui nocoxon yoshinyahpa hihrasihi joni jiscanquin. Yoshiman hichaxon hihbojani bi jano siripi tsahotai jiscanquin. Chopayahpahax res sca tsahotai jahuen shinan siriscai jiscanquin. Jisish raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jan cochi qui yoshin mahnebohanxon yoshinyahpa joni rohajahi jisibaan ja to yohihah hihti raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nincacax raquexon sca Jesus hihti yocascacanquin. Noquen mai mehax catanhue hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nontin Jesus nanetaiton cahen yoshinyahpa hihrasihiton hihti yocascaquin, hahbetan cacatsihquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jan jascahah bi Jesus jeenhihyamahi. —Miin caibo yohihi miin xoboho catanhue. Mihon shinanxon miin hihbaan mia hahxonai jatihibi yohitanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jan jascahah yohihi caxon yohibonaquin. Decápolis jemabo janinhahbo yohiquin. Jatihibi Jesusen jaa hahxonai yohibonaquin. Jan yohibonaha jatihibi rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jaatian sca Jesus hoque quexa nontin pohquerihbihiya hicha joni hahqui tsamajaqueti. Hian quexa sca cahen jaa nichi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hapo sca nocoti. Jairo janeya, haho tsinquiti xobo hapo. Jesus jisish jahuen tahe qui betihipaquexon hihti yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Heen baque haibo pishca ta mahuacatsihquiqui, hapon. Miin mequeman mehexoni cahue. Rohahax jihuenon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hahbetan sca Jesus cahi. Cahiya hichaxon Jesus chibancanquin. Tsehquesihcanahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jato betan rihbi huesti haibo cahi, doce bari sca jimihi hisinish. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hicha rahonnicabaan rahonah bi rohayamahi, hohmis hohmisi, jahuen coriqui queyoquin. Rahonahbaan bi jascabi hisini, nanocohcanaribihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesusen hahcai nincacax tsamajaquetaibo tocan nichish hahchon cahi. Hahchon caquin sca jahuen chopa mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jahuen yora meheyamaxon bi jahuen chopa pishca mehehax tah hen rohascatihi, hihxon mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mehehax jimi tantiscai. Jahuen hisin rohascai jahuen jointinin honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesusen sca jahuen yora janinhax coshi cahi jahuen jointinin honanxon tsamajaquetaibo tocan rabejaquecahuanxon jano nichibo yocaquin: —¿Tsoan heen chopa mehehaxquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jahuen haxenicabaan sca yohiquin: —¿Nea tsamajaquetaibo mihqui tsehquesihqui jisi bi min Tsoan hea mehehaxquin hihqui yocacahtain? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jascajahibaan bi Jesusen jisjaquehtanquin, honannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jan hahxonah honanax raquetax tastahihcanahi jahuex Jesus qui betihihpaquexon hihcoinjaquin sca haibaan jatihibi yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jaa cahen Jesusen yohiquin: —Baquen, min shinancoinai copi tah min rohascai. Shinanquin sirijahax caresscatanhue, miin hisin rohascaax caresscatanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jan yohuanai betanbi hapon xobo janinhax jahuibo nocoti. Nocoxon tsinquiti xobo hapo yohicanquin: —Moa ta miin baque mahuascaaxqui. ¿Jahuejanoxon sca min maestro jatsanjahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jascajahibo nincaxon Jesusen jaa hapo yohiquin: —Raquexonma shinancoinhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Caquin sca tsoabi hahbetan camayamaquin. Pedro, Jacobo, Jacobonen huetsa Juan, jaabo rahsi Jesusen boquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cahi, hapon xoboho nococani, haho tsinquiti xobo coiranicahton xoboho. Nocoxon corotaibo jisbonaquin, huaohihquiboya hihti huinihibo. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hihcoxon Jesusen jato yocaquin: —¿Jahua jenquetsahin man huaohihqui coro corotain? Mahuatihma bi ta xontaco hoxahihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jascajahiton hosancanquin. Hosan hosana Jesusen jato jatihibi jeman cainmaquin. Jahuen papa, jahuen mama, hahbe jahuibo, jaabo rahsi cainmayamaquin. Jano xontaco racataiton sca jato betan Jesus hihcohi. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Xontaco metsonxon: —Talita, cumi —hahquin. Haibo pishcan, mia tah hen yohihi huenihue, hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jan jascahah huenitax nichi. Doce bari jai xontaco. Jisish rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jan xontaco hahxonai tsoabi yohiyamahahbo cahen Jesusen jato hihti yohiquin. Jascajaxon: —Xontaco piti hinannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Janohax res sca cahen jahuen mai janin sca Jesus caribihi. Jahuen haxenicabo rihbi hahbetan bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tantiti neten sca haho tsinquiti xobohoxon jato haxemaquin. Nincacax hicha jonibo rahte rahteti. —¿Jahuerahnohax nescapa yohuan haxenishquin? ¿Jenquetsahpa shinan bihnishquin? ¿Jahua coshin jahuen mequeman hahquiquin? ");
INSERT INTO kaqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Hoa carpinteroma hin? ¿Marian baquema hin? ¿Jacobo, José, Judas, Simon jahuen jochicaboma hin? ¿Jahuen chocabo neno noque tocan jihueyamahiquin? —hihcani hahqui sinati. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","—Huetsancohabo Papan joi yohinicahon queenaibaan bi ta jahuen mai janinhahbo res jahan queenyamahihqui. Jahuen jenabo, jahuen xobo janinhahbo rihbi jahan queenyamacani —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jaa jema janinxon ta jahuen coshin jato hahxonti hahtipahyamanishqui, huestibo res hisinaibo mehexon rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hihcoinai jaabaan shinanyamahi copi Jesus rahteti. Jemabo janin sca haxemabonahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jahuen doce quenaxon yoshin tiromabo picoti jato hihbomaxon rabe rabebo jato raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Raannoxon jato hihti yohiquin, mequen botanahbo, huesti hahqui paxati mepitiya res bohabo. Piti boyamanon, borasa, jaya cati coriqui rihbi boyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapato sahuequin bi rabe coton sahueyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Xoboho hihcohax janobi banenahue, jaa jema janinhax canoxon caman. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mato Johue hahyamaxon mato nincacatsihyamahiboya janohax caquin maton sapato qui hueotai mai poto jato qui tahabahini botannahue yohitimabohi honanahbo —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jaan jascajaha boresscacani, shinan pontenahue jato jabonahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hicha yoshin rihbi picocanquin. Hicha hisinyahpabo rihbi xeniyaxon bemanxon rohajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jascajahiboya cahen Jesusen joi jatihixonbi nincacanquin. Herodes janeya quiquin hapon rihbi nincaquin. Jesus yohihi cahen caibo nescari yohuannish: —Nashimanica Juan ta mahuatipish bi teehihribihiqui. Jaa copi ta jascajaquin coshin hahquiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","—Elías yamanica tah qui —hihqui caibo rihbi. —Papan joi yohinica tah qui. Neateman Papan joi yohipahoni quescapah tah qui —hihqui caibo sca. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jesusen hahcai nincacax Herodes sca jascarihbihi: —Juan ta jihuerihbihihqui. Hean rehtequin textebahinhoh bi ta teehihribihiqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jascari yohuanyahnoxon ta Herodias copi Juan bihmaxon Herodesnen Juan sipojanishqui. Herodias Felipenin haibo que bi ta Herodesnen bichinnishqui. Jahuen huetsan haibo bichinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bichinaiton cahen Juaman Herodes yohiquin: —Miin huetsan haibo bichintima joi ta jaiqui, noquen nincati joi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jan jascahah Herodesnen haibo Herodias Juan qui rainyamahi jihuexon rehtecatsihquin bi hahtipahyamaquin, jahuen benen pantehah. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juan ponte jihueti hohchajomahi honanax Juan qui raquequin Herodesnen coiranquin, caibaan rehtemis hihxon. Juan nincaxon jahua shinanti honanyamaquin bi nincaquin, coin coinxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jahuen bari nocotai neten sca cahen Herodesnen fiestajaquin. Pihi jahuebo jahuen tinintibo quenamaquin, jahuen sontaro hapobo quenamaxon Galilea mai meha patorobo rihbi quenamaquin. Fiestajahiboya jahuen haibaan Juan copicatsihquin shinanquin: Rahma caya tah hen Juan rehteti hahtipahscai hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fiestajahibo qui hihcohax Herodiasnen baque xontaco jato bairahxonaiya hahan Herodes hihti jenimahi, jan quenamahabo rihbi. Jenimaxon Herodesnen yohiquin: —Min queenaibo hea yocareshue, hen mia hinannon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jascajaxon Papa Dios quenaxon sca xontaco yohirihbiquin: —Min hea yocacaibo tah hen mia hinantihi, heen yonotibo jatíhi hena hihnon jatíhi rihbi mina hihnon caman —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yohiha jahuen mama yocaqui sca caresscai. —¿Jahua yocapan? —hahquin. —Nashimanica Juaman mapo rahan —hahquin jahuen maman. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hapo qui histon caribixon sca yohiquin: —Nashimanica Juaman mapo tah hen queenai rahmabi. Quencha qui nanexon min hea hinanti tah hen queenai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yocacah sca hapon masa shinanquin. Hihtijaquin masa shinanxon bi Dios quenaxon yohixon copi jahuen joi huetsajati hahtipahyamaquin. Jan quenamahibaan nincacah copi rihbi jeenhahscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jeenhihxon, rehtexonnica sontarobo sca raanquin, jahuen mapo bihtanahbo. Raanah caxon carcel janinxonbi Juan textecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Quencha qui jahuen mapo nanehax jaya joxon xontaco hinancanquin. Xontaconen sca jahuen mama hinanrihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jascajahibo nincacax ta Juaman haxenicabo jahuen yora bichi canishqui. Jahuen yora bihxon tsahoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesusen jato raanah catanipish Jesus qui jahuen raantibo joribihi. Joxon jaabaan hahtanipi yohixon jaabaan haxematanipi yohirihbiquin jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yohihiboya Jesusen jato yohiquin: —Mato rahsibi tantihi bonahue jano tsoabi yamahiton —jato jaquin. Cahi jahuibo hichahiya ta pinoxon bocabi tantiti hahtipahyamacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jano tsoabi yamahiton sca nontin bocani jaabo rahsibi. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jaabo cahi cahen hichaxon jiscanquin. Jato honancanquin. Jatihibi jema janinhax quetanpaquebahini cahax jaabo pari nocoti, jano nontin cahi janin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nocoxon hicha tsamascaibo Jesusen jisbonaquin. Coiranyamaha carnerobo behnocanahi quescapahbo jato jisquin. Jatohon shinanxon hicha jato haxemarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bepiscaiya sca hahqui joxon jahuen haxenicabaan yohiquin: —Neno ta jahua yamahihqui. Bepi rihbi sca ta jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jano huaiyahpabo jaiton jato raanscahue, hochoma jemabo janinxon rihbi jaton piti marohi cahabo —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jascahahbo: —Piti hinannahue, matonbi —jato jaquin. —¿Non doscientos denario copi paan marohi catihin, jato pimanoxon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Jahuentihi paan man jain? Jistannahue —jato jaquin. Jistani jahuex sca: —Pichca rahan. Rabe yapa rihbi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jato jatihibi sca Jesusen yohiquin, cincuenta cincuentaboya cien joni rahsi jano huasi mipaxbihtaiton tsahonon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jascari tsinquitax tsahocani cincuenta cincuentabo, cien cienbo. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jaton pichca paan bihxon jaton rabe yapa rihbi bihxon nai bejisihnixon Papa yocaxon paan tehcapaquexon jahuen haxenicabo hinanscaquin, tsamajaquetaibo hinanpaquehahbo. Yapa rabe rihbi jatihibi hinanpaquemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hinanah jatihixonbi pihi yanicahini. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Paan tequeboya yapa tequebo tsinquirihbixon sca doce tasa bohasjacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Paan pihibo cahen cinco mil bebobo. Hichaxon bi jatihi tasa bocho texejacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jaatian sca chini canoxon jahuen haxenicabo yohiquin, nontin nanetax Betsaida jema janin pohquejaquenon. Jaabo cahiya cahen tsamajaquetaibo Jesusen yohiquin xobon caresscatannon. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jato yohihax manan manixon Papa yocaqui cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yamescaiya cahen nonti caresscai bi Jesus huesti main baneti. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nihuen tsahcahah huinacasquimahibo bi jaan jato jisquin. Xaba paqueri jaima sca jato qui cahi, jene benicanahi. Jato huinobahincatsihqui bi jaabaan meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jene benicahinquihranai jisish, Yoshin tah qui, hihquish sai saihihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jatihixonbi jisish hihti raquecani. —Jointi coshijanahue. Hea tah hen qui. Raqueyamanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jato qui nontin nanetaiya cahen nihue tantiscai. Nihue tanticahinaiya hihti rahtescacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paan tehcapaquexon jahuen coshi jan jato jismahipi bi honanyamacanquin, jaton shinan chahomahiya. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pohquejaquetax Genesaret main taxnati. Taxnaxon nonti nexacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nonti mehax bototaiton janohahbaan Jesus honancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Honanax jatihibinco hishtocahini caxon hisinyahpabo jaton cacajatinin racatai hihuecanquin. Jano Jesus jai nincaxon jano becanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jatihibinco jan cahi, hanitahma jemabo janin, hani jemabo janin, huenenaiton rihbi, hisinyahpabo bexon jano maronicabo tsinquitai hueneman jato racancanquin. Racanahbo Jesus yocacanquin jahuen chopa quechon bocabi mehenoxon. Jaa mehehibo jatihibi ta rohanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jaatian sca huishani honanbo betan fariseobo Jesus qui tsinquicani, Jerusalen janinhax jahui honanbo. Tsinquixon jahuen haxenicabaan pihi jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mechoquihxonma jaton mequen rishtayaxon texe jahuen haxenicabaan pihibo jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mechoquihyamaxon ta fariseobaan piyamahiqui, jatihibi judiobaan rihbi jascajarihbiquin. Jaton xenibaan hahpahoni quescajaquin ta jacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jano piti maroti janinhax joxon ta nashiyamaxon piyamacaniqui. Hicha jascapahbo japahoni ta jacanihqui. Pinoxon ta posillobo, poobo, yami quentibo qui jene jasijacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseobo betan huishani joi honanbaan sca Jesus yocaquin: —¿Jahua jenquetsahin miin haxenicabaan noquen xenibaan hahpahoni quescajayamahiquin? Mechoquihxonma ta picanihqui. Jaton mequen qui hueotai hohchayabi ta picanihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jascahahbo jato yohiquin: —Ponte bi res ta mato qui yohuanquin Isaiasnen huishanishqui: Nea jonibo jaton janan siripi hehqui yohuanai bi ta jaton shinan hocho bi res qui, hehon queenyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Papan joi haxemahicamaxon bi ta jonibaan joi honanmacanihqui. Yanca bi res ta hehqui betihipaquecanihqui hah ta Isaiasnen janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jonibaan hahpahoni quescajaquin hahnoxon tah man Papan yohini joi jenehi. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jato jascajaxon jato yohirihbiquin: —Sirija ra tah man jai, maton xenibaan hahpahoni quescascanoxon Papan joi jenequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisesnin ta yohinishqui: Miin papahon queenhue, miin mamahon queenhue. Huetsa jan yohini ta nea qui: Tiromahi jahuen papa qui yohuanai joni tah man rehteti jai, jahuen mama qui tiromahi yohuanai rehtequin cahneyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jaan jascajani que bi tah man matonbi yohihi: Maton papa, maton mama yohinahue Jaa hen mia hinanpanan ta Corban qui, hahquin. Corban ta Papa qui hinanah hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jascari yohuanmaxon tah man jaton mama hahxontima haxemahi, jaton papa hahxontima haxemahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jascajaxon tah man Papan joi pantehi, maton xenibaan hahpahoni quescajaquin tah man maton rihbi maton baquebo haxemahi. Jascapajahi tah man jai hicha —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jonibo quenarihbixon sca jato yohiquin: —Hea nincanahue, jatihixonbi honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jahuabi ta noque chicho quehama noque qui nanexon noque rishtajatimahiqui. Noquen jointinin non shinanaiton ta noque rishtajahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hahan nincati pabinquiyahpaxon nincahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jato potabahinax xobohoh hihcohiton jan jato yohiha jahuen haxenicabaan yocaquin, min yohiha jahua hihcatsihquiquin, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yocaca jato yohiquin: —¿Mato rihbi man honanti pishinain? Noque chicho quehamabo ta noque qui nanexon noque rishtajati hahtipahyamahiqui. ¿Man honanyamahin? —jato jaquin, jatihibi pitibo hahan jointi rishtajatima sca janon. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Jaatian sca: —Noquen jointi qui hihquihima bi ta poco janin res nanetihqui. Poco janin nanetax jaroma caini —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jato yohirihbiquin: —Noquen jointinin non shinanaiton ta noque rishtajahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Noquen jointinin tah non shinanai: tiroma shinanbo, benejomabo betan hihti, queejomabo betan hihti, yometsohti, joni rehteti, benoyahpabo betan hihti, queeyahpbo betan hihti ");
INSERT INTO kaqNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","caibaan jahuequibo bichinti, tiromajati, paranti, tsiniti, notsi notsiti, joni qui tiromahi yohuanti, yohitimabohi, honanmabohi. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jascapa tiromabo rahsi tah non noquen jointinin shinanxon hahcai rishtascanoxon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jato jascahax janohax Tiro jema janinbo sca caresscai. Nocotax bi jan jano hihqui honanyamahahbo xoboho hihcocani. Hihcohax bi jenquetsahax jonetimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jesus nocotai joi nincacax huesti haibo jahui, jahuen haibo baque pishca yoshiman hihbojahi. Jahuex Jesusen tahe qui betihihpaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jaa haibo ta judiobaan nahua hihpahonishqui, sirofeniciabaan jena. Jahuen baque janinhah yoshir picoxonti jaan hihti yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Baquebo pari pimanon. Baquebaan paan pihi bichinxon tah non hochitinin pinon potantimahi —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Jascari rahan, Hihbon. Jaabi ta baquebaan paquehi paan tomes misa namanxon hochitinin pihiqui —hahquin haibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Jascarax tah min caresscatihi. Yoshin ta miin baque janinhax picoscaiqui —haibo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jan jascahah xoboho caxon jahuen baque bachiho racatai meraquin, siri scah. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jaatian sca Tiro janinbohax cahi Sidon jema nabebacahini, Galilea hian janin carihbihi, Decapolis maibo nabebacahini cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cahiton bi pabe joni Jesus qui hiocanquin. Pabehax bi joyorihbi. Jesusen mehenon sca yocaxoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tsamajaquetaiboma qui pabe nihcahuancahuanquihnxon jahuen pabinqui janin jahuen metoti niaquin. Toshbanhahxon jahuen jana mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nai bejisihnixon jointi xecahihnixon: —Efata —hahquin. Quehpemehhue hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jascahiya jahuen pabinqui quehpemehscai, jahuen jana janpequehtax yohuani siriscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jaa rohascaiya cahen Jesusen jato hihti yohiquin tsoabi yohiyamanon. Jan hihti yohihah bi hashoan hicha sca yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hihti rahtetax yohuancani. —Jatihibijaquin ta sirijahiqui. Pabehibo nincamaquin. Joyobo yohuanmaquin —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jascasca jaiya hicha joni tsamajaquetaiya jahua pitimahiya jahuen haxenicabo quenaxon jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nea tsamajaquetaibahon tah hen shinanai. Quimisha neten sca hehbetan hihxon bi ta jahuabi piyamacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pihaxma jaton xobon cahabo raanah ta bahin mehax jaton yora yosmajaquexihcanihqui, caibo rihbi hocho quehabo —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jascaha jahuen haxenicabaan: —¿Jenquetsahaxon non nea jonibo pimatihin, neno tsoabi jihueyamahiton? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Jahuentihi paan man jain? —jato yocaquin. —Siete rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tsamajaquetaibo sca jaan yohiquin, main tsahonon. Jaton siete paan bihxon Papa yocaxon tehcapaquexon jahuen haxenicabo hinanquin, jonibo sca hinannon hihxon. Bihxon sca jato hinanpaquecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yapa romishin huestibo rihbi cahen jaabo jai. Jaa bihxon Papa yocaxon jato hinanmarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hinanah pihi yanicahincani. Texehi tequebo tsinquirihbixon siete tasa bohasjacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cuatro mil jonibo jano hihqui bi jato pimaxon cahabo jato camascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jaatian sca jahuen haxenicaboyabi nontin nanetax Dalmanuta main sca cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseobo sca ta Jesus qui jonishqui. Joxon Jesus yohuanquihnquin, joi bichinnanancatsihquin. Papan hinanah hahan honanti jan jato jismanon hihxon yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jascahiboya jointi hihti xecahihnixon jato yohiquin: —¿Jahua jenquetsahin nea rahma jihuetai jonibaan hahan honanti jiscatsihquiquin? Yohicoin tah hen mato jai: jahuabi hahan honantibi ta mato jismatimahihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jato banescaax nontin nanerihbihax ramiho quexa sca cahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Caquin bi piti boti shinanbehnocanquin. Huesti paan res nonti janin jai. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Coirametahbo jato yohiquin: —Jisnahue. Fariseobaan hahan paan soohihmati qui raquenahue. Herodesnen hahan paan soohihmati qui raquenahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jaa jan yohihi jaabo rahsibi sca yocacahcani: —Non paan yamahiya cahra noque yohihihquin —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jascajaquin shinanaibo honanxon Jesusen sca jato yocaquin: —¿Jahua jenquetsahin man paan yamahi yocacahnananain? ¿Man jiscoinyamaparihin? ¿Man honancoinyamaparihin? ¿Maton shinan chahoma sca quin? ");
INSERT INTO kaqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Beroyahpaxon bi man jisyamahin? ¿Pabinquiyahpaxon bi man nincayamahin? ¿Cinco mil jonibo pimanoxon pichca paan hen tehcapaquehiya texehi teque tsinquirihbixon jahuentihi tasa man bohasjahoquin? ¿Man shinanyamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","—Doce rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Siete paan cahran, hahan hen cuatro mil pimahiya texehi teque tsinquixon jahuentihi tasa man bohasjahipiquin? —jato jaquin. —Siete rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Man honancoinyamaparihin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida jema janin sca nococani. Nocotaiboya benche joni Jesus qui caibaan hiocanquin. Hioxon hihti yocacanquin, mehexonhue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yocacah benche metsonxon hiobonahi jemama qui cahi. Benchen bero qui toshbanhahxon mequeman mehexon sca yocaquin: —¿Min jisyamabiresain? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jari jisxon: —Jihui nihcahuanai quescapahbo ta hen joni jisi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jaatian sca jahuen bero meherihbihah coshicahinxon jisribiquin. Siriscaxon jatihibi sca jisquin sirijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jahuen xobon sca jan catannon: —Jema janin hihquihaxma catanhue —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jaatian sca jahuen haxenicaboyabi Jesus cahi, Cesarea de Filipo mai meha jemabo janin sca. Caquin jato yocaquin: —¿Hea tsoa hihqui shinancaniquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Nashimanica Juan yamanica tah qui hih ta caibo jaiqui. Elías yamanica tah qui hih ta caibo rihbi jaiqui. Papan joi yohipahoni yamanica tah qui hih ta huetsabo rihbi jaiqui —hihcani jahuen haxenicabo. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jaan sca jato yocarihbiquin: —¿Maton cahran? ¿Hea tsoa hihqui shinan man jain? —jato jaquin. —Mia tah min Cristo qui —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Tsoabi jascajaquin yohiyamanahue —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jaatian sca jato sirijaquin yohiquin: —Hea noque baque ta tiromajayaxihcanihqui. Hehon ta queenyamayaxihcanihqui hanibo, sacerdote hapobo, huishani honanbo. Hea ta rehteyaxihcanihqui. Rehtehipibo bi tah hen quimisha netenax hahquirihbi hueniyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jahuabi joi jonexonma jato jascajaquin. Jesus quenabohanxon sca Pedronen yohiquin: —Jascari yohuanyamahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Rabejaquexon jahuen haxenicabo jisxon Pedro yohiquin: —Jascayamahue. Hea janinhax catanhue, Satanas. Papan shinanai quescajaquinma bi jonin shinanai quescajaquin tah min shinanai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jahuen haxenicaboya tsamajaquetai jonibo nincaqui jonon sca jato quenaquin. Jato quenaxon: —Hehchon jocatsihxon tah man matobi man queenaima sca man hahtihi. Hea rehtehibaan bi tah hen heen Hihbo jenetimahi hihnahue, nete tihibi jascanahue. Jaatian tah man heen jihuetahbo jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Non mahuamis hihquibo ta mahuatihiqui. Hehqui hinamehxon heen joi siri nincacoinaibo ta rehtehah bi jihuetihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Mai jatihobi hihbojahax bi mahuatax jahuaya sca man banetihin? ");
INSERT INTO kaqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Hahquirihbi teehihnoxon non copijaquin jahua hinantihin? ");
INSERT INTO kaqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Rahma jaibo ta tsini tsinihibo qui, hohchapan baquebo. Hehqui hihtimahpai joni qui tah hen hea rihbi hihtimahyaxihqui. Heen joi qui hihtimahpai joni qui rihbi tah hen hea noquebaque hihtimahyaxihqui Papan yonotibo betan Papan shinanya jahuex jato qui hihtimahpi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jascajaxon: —Mato ta hen yohicoinai: jahuen coshin Papan jihuemahi joresscai jisyanoxon caman ta texe neno nichibo mahuayamayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jato jascahax seis neten sca hihxon Pedro, Jacobo, Juan jaabo rahsi Jesusen boquin. Hani mahchi jato maniquihnquin jaabo rahsibi. Jatoyabi maniscaax jaton jisnonbi huetsapahcahini. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jahuen chopa xabareneni joxoshamani. Jascapa joxojahti ta tsoanbi main jihuetai pahtsanicaton hahtipahyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elías yamanica betan Moises yamanica sca jato qui cainax Jesus betan yohuan yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yohuanaibaan bi Pedronen sca Jesus yohiquin: —Maestron, noque neno hihqui ta siri qui. Quimisha tapasnonhue. Mina huesti, Moisesnina huesti rihbi, Eliasnena huesti rihbi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jahua yohiti honanyamahax jascari yohuani. Hihti rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jato bochiqui cahen nai cohin maracahti. Nai cohin chicho quehax sca yohuani jai: —Nea ta hen hihti queenai heen baque qui. Jaa nincanahue —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nincaxon jisbohanrenenxon bi tsoabi jisyamacanquin. Jesus huesti jano jai meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jaa pecaho sca mahchi mehax botopaquexon Jesusen jato hihti yohiquin: —Man rahma jisí tsoabi yohiyamanahue. Hea noquebaque hihquipish bi hahquirihbi hueninon caman yohiyamanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jan jascahah tsoabi yohiyamacanquin. Hihquipish bi hahquirihbi huenitihi jan hihqui bi jahua hihcatsihquiquin hihquish jaabo rahsibi yocacahanancani. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jesus sca yocacanquin: —¿Jahua copi Elías pari ta jotihiqui huishani honanbaan jaiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jaan sca: —Hihcoini. Elías pari joti jai. Jatihibi rohajahi jahui. Hean sca hen mato yocanon: ¿Jahua yohihi nea huishani joi jaiquin? Noquebaque ta hihti tiromajayaxihcanihqui, hosan hosan rihbi ta jayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mato ta hen yohihi. Elías ta moa joresscanishqui. Jahuiton bi ta jaabo queenai quescajaquin jaabaan janishqui jayaxihquibo Papan huishani quescajaquin —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jahuen haxenicabo qui nocoxon sca jato qui hicha tsamajaquetaibo meracanquin. Huishani honanbo jato betan joi bichinanaiton jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesus jahui jisish rahtetax jatihibi tsamajaquetai jonibo sca hahqui bishquihihcahinxon hicotancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jaatian sca jaan jato yocaquin: —¿Jahua yohuan man jato betan jain? ");
INSERT INTO kaqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yocacah sca tsamajaquetaibo meha huestichin yohiquin: —Heen baque ta hen mihqui hihuehahqui, Maestron, joyo yoshiman hihbojani quen. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jan janoxon shinanaiton bi ta hueran paquehihqui. Bacox jancharahicahini. Jahuen xeta yeres yeres hahquin. Jahuen yora jestancahini. Picoxonhue hah hen miin haxenicabo jaah bi ta hahtipahyamacanaxqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Nincayosmabon, jascapahbo tah man qui. ¿Jahuentiho basi hen mato betan jatihin? ¿Jahuentiho basi hen mato tenetihin? Neno hehqui hihuenahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hahqui hihuescacanquin. Jesus meraxon cahen tiroma yoshiman beronan tastahihmaquin. Tastahihquish maihi taramehcanahi, bacox jancharahiquish. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jahuen papa Jesusen yocaquin: —¿Jahuentiho basi nescari jihuescaiquin? —hahquin. —Baque pishcabihaxbi rahan. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hicha coti ta chihi janin hueranrahsihiqui, jenenencanya rihbi hueranquin rehtecatsihquin. Hahtipahxon noque yanapanhue noquehon shinanxon —hahquin jahuen papan. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¿Hahtipahxon nan? Shinancoinai jonin jisi ta jatihibi jati hahtipahti qui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yoshinyahpaton papa sca coshin yohuani: —Hen ta hen shinancoinai. Hen hashoan sca nincacoinnon hea yanapanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hicha bishquihihcahinquiranax jahuex tsamajaquetaibo jisxon tiroma yoshin Jesusen yohiquin: —Joyo yoshiman, pabe yoshiman. Mia ta hen yohihi. Jahuen yora mehax picohue, jahuentianbi hahqui joyamascanoxon —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sai saihihquish coshin tastahihmahax picoti. Beronan mahuati quescapi racati. Jatihibi sca yohuanquehancani: —Mahua sca ta jaiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesusen sca metsonxon huenihihnihah hueniscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Xoboho Jesus mapescaiya sca jahuen haxenicabaan jaabo rahsichin yocaquin: —¿Jenquetsahpahin non picoti hahtipahyamahaquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Jascapa tah man Papa yocaxon res picotihi. Huetsajaxon tah man jenquetsahaxon bi picotimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Janohax Galilea mai nabebacahini bocani. Jaabo jano cahi tsamajaquetaibaan honanti Jesus queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jahuen haxenicabo res haxemabonanoxon jaabo rahsi nihquihinquin. Jato nihquihinquin yohiquin: —Jaton jonibaan hea bihnon ta hea hinanyaxihcanihqui. Bihxon sca tah hea rehteyaxihcanihqui. Rehtehahbo sca tah hen quimisha neten hihquish hahquirihbi hueniyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jan jascahah bi honancoinyamacanquin. Yocacahcatsihqui bi raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum jeman sca nococani. Xobohoxon sca Jesusen jato yocaquin: —¿Jahua yohuan man jaonahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yocacah bi jahua hihyamacani. Tsoa non hashoan coshi quin yocacahnananhonahax bi rahma jahua hihyamascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsahoxon jahuen doce joni quenaxon sca jato yohiquin: —Bebocatsihqui joni ta chiniti jaiqui, jatihixon bi yononica —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Huesti baque pishca bihxon naponbi nichinxon hicobehnanxon jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Nescapa baque pishca heen janen johue hahcai jonin ta hea rihbi johue hahquiqui. Hea johue hahcai jonin ta hea que ma bi hea raanni johue hahquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juaman sca yohiquin: —Huesti joni tah non merahipiqui, Hihbon. Miin jane yohixon tiroma yoshinbo picohi. Noque betan ta nihyamahiqui. Noque chibanyamahiya ta non jascajayamahue hahquipiqui —hihscai Juan. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesusen yohiquin: —Jascajaquin yohiyamanahue. Heen jane yohixon coshin hahcai joni ta hahcax res sca hehqui tiromahi yohuantimahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Noque panteyamahibaan ta noque yanapanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yohicoin tah hen mato jai: mia Criston joni copi hahxoncatsihquin mia jene pishca xehamahi joni ta copijacoinyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nescapa hea nincacoinai baque pishca hohchamahibo ta Papan hihti tiromajayaxihquiqui. Jascapahbo macanya tenexxon jenenencanya potahah sirijaquin shinantimahi bi ta Papan casticana hihti tiromajaquin shinanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Miin mequeman tiromajanicahax mextehihhue. Mento jihuenish bi queyoyamanox manatah tiroma que ma bi ta rabe mequenyabi nocayosma chihi janin potahah hihti tiroma bi res qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jano ta jaton xena jahuentianbi mahuayamahiqui. Jaa chihi rihbi ta jahuentianbi nocayamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Miin tahen tiromajanicahax taxtehihhue. Tanto jihuenish bi queyoyamanox manatah tiroma que ma bi ta rabe taheya chihi janin potahah mia hihti tiromascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jano ta jaton xena jahuentianbi mahuayamahiqui. Chihi rihbi jahuentianbi nocayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Miin beron tiromajanicaxon miin bero tsecahue. Huesti beroya jihuenish queyoyamanox manatah tiroma que ma bi ta rabe beroya chihi janin potahah mia hihti tiromascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jano ta jaton xena jahuentianbi mahuayamahiqui, chihi rihbi jahuentianbi nocayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tashi nepocah quesca ta jatihibi jonibo chihin jatiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tashi ta siri qui. ¿Tashi jahuíyamascaiton jahuínon hihxon jenquetsahaxon man hahquirihbi jahuíjatihin? Tashiyahpa jihuenahue. Joni huetsa betan siripi jihuenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Janohax caresscai Judea mai janin, Jordan hoque quexa rihbi. Jano rihbi hahqui tsamajaquecani. Jan hahrasihi quescajaquin sca jato haxemarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hahqui joxon sca tanacatsihquin fariseobaan yocaquin: —¿Bebaan jahuen haibo potati joi yama quin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Jahua Moisesnin huishanishquin, man jascajanon? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Jascajati queenaibo ta Moisesnin yohinishqui: Bebaan ta jahan jahuen haibo potati quirica huishaxon jahuen haibo potatihiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesusen sca: —Man jointi chahomahi copi ta jascajaquin huishanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nete jamenohi tian ta bebo betan haibo Papan jato jonijanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jaa copi ta jahuen papaya jahuen mama jenebahinax jahuen haibo betan sca bebo jihueti canicah qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jaabo rabehax bi huesti yora sca jihueti. Rabe hihyamascai, huesti yora sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jaa copi jaabo rabe Papan huestijaha tsoanbi potamayamaxahtahi man —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Xoboho sca jahuen haxenicabo jaa joi hahquirihbi yocacahti. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jaan sca jato yohiquin: —Jahuen haibo potaxon huetsa haibo bichi joni ta jahuen haibo qui hohchati jihuetihqui, tsinihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jahuen bene potaxon huetsa bebo bichi haibo rihbi ta jahuen bene qui hohchati jihuetihqui, tsinihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jaatian sca Jesus qui baquebo hihuecanquin jato mehexonnon. Hihuehiton jahuen haxenicabaan yohiquin: —Jascapahya joyamanahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jascajahibo jisish sinaxon jato yohiquin: —Panteyamanahue, hehqui baquebo behabo. Jascapah ta Papan jihuemati qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nincanahue hen mato yohinon: baque pishcaten Papa Dios hihbojamahi quescajayamahax tah man Papan jihue janin jahuentianbi catimahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jato jascajaxon baquebo hicotanxon mehexon Papa yocaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Carihbihi bi huesti joni bishquihihcahinxon hahqui raboxonen tisquihahpaquexon yocaquin: —¿Jenquetsahax hen queyoyamanox manatihin, maestro siripan? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusen sca yohiquin: —¿Jahua copi min hea siripan hahcain? Tsoabi ta sirima qui. Papa huesti ta siri qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Papan joi tah min honanai. Rehteyamahue. Tsiniyamahue. Yometsohyamahue. Caibo qui quesahi yohuanyamahue. Paranxon bichinyamahue. Miin papa, miin mama nincacoinhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Beronan pishcahax bi ta hen jascari jihuescai —hihqui yocanica. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sirijaquin bejisxon sca jahan queenxon Jesusen yohiquin: —Huesti tah min pishinparihi. Jatihibi miin jahuequibo maromaxon jahuabijomabo coriqui hinantanhue naihoh quehax bi sca min hicha bi res jayaxahnon. Jascajatanax joribihue hehbe canoxon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jan jascajaha jahuen jahuequibo hichahi copi metsamarenenax masa shinanbahini caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jato jispaquexon sca jahuen haxenicabo Jesusen yohiquin: —Jahuequi hichayahpa joni jano Papan jihuemahi janin hihquiti ta tee bi res qui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jan jascajaha jahuen haxenicabo rahtecani. Rahtetaiton Jesusen jato yohirihbiquin: —Jano Papan jihuemahi janin hihquiti ta tee bi res qui, heen baquebaan. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hahua xohmox bero chirehuinti tee que bi ta jahuequi hichayahpa joni jano Papan jihuemahi janin hihquiti hashoan tee qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jan jascajaha hihti rahtetax yohuancani: —¿Jascahiya tsoa non queyoyamanox manatihin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jato jisxon Jesusen yohiquin: —Jonibaan hahtipahyamahi bi ta Papan hahtipahiqui. Papan ta jatihibijati hahtipahiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—Jise. Jatihibi jenebahinax tah non mihbetan sca cahi —hihscai Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Hen mato yohinon nincanahue. Jahuen xobo, jahuen huetsabo, jahuen chocabo, jahuen mama, jahuen papa, jahuen baquebo, jahuen huaibo, jaa rahsi hea copi, heen joi siri copi rihbi jenebahinai jonin ta jan potabahinai quescahpabo rihbi bihyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Bih ta jatihiqui xobobo, huetsabo, chocabo, mamabo, baquebo, huaibo. Huesti jenebahinnixon ta cien sca bihribiyaxihquiqui. Rahma tahni ta jascapahbo bihyaxihquiqui, caibaan sca jato tiromajacatsihquin jatsanjanon. Papan jihuemahitian rihbi ta queyoyamanox manatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hicha bebocanahibo ta chinijaqueyaxihquiqui. Chinitaibo ta beboyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jaatian sca bahin cahax, Jerusalen janin bocani. Jesus bebohi. Jano cahiya ta jan honanmahibo rahtecannishqui. Chibanaibo rihbi raquecani. Hahquirihbi jahuen doce joni quenabohanxon jaa huinoyaxihquibo jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Jisnahue. Jerusalen janin tah non cahi. Jano ta sacerdote hapobo, huishani honanbo rihbi hea hinanyaxihcanihqui. Hinanahbo ta Rehteti ta jaiqui hihxon nahuabo jaabaan sca hinanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hea hosanxon ta hehqui toshbanhahxon rishquixon rehteyaxihcanihqui. Rehtehipi bi tah hen quimisha neten hihquish hahquirihbi hueniyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaatian sca Zebedeon baque rabe Jacobo betan Juan Jesus betanbi pecantaba cahi, yohuancanahi: —Non mia yocacai noque hahxonhue, Maestron —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jaan sca: —¿Jahueja mato jaxonti man queenain? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Min jihuemahi tian noque tsahomaxahnhue, huetsa mia mecayaho, huetsa mia memiho —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesusen jato yohiquin: —Man yocacai tah man honanyamahi. ¿Hean xehahi mocani man maton rihbi xehati hahtipahin? ¿Hahan hea nashimahiton mato rihbi nashimaha man teneti hahtipahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Tenequin rahan —hihcani. —Hean xehahi mocani tah man maton rihbi xehatihi. Hahan hea nashimahiton ta mato rihbi nashimayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hea mecayaho tsahomati hihboma tah hen qui, hea memiho rihbi. Jano tsahonica rahsi ta jano tsahotihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jacobo betan Juan jascaraiya nincaxon jahuen diez jonibo jato qui rainyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jato quenaxon Jesusen yohiquin: —Nahua hapobaan ta jaton jonibo jihuematihi bi yono yonohihqui man tah man honanai. Jaton patorobaan rihbi jato coshin yonohi ta man honanrihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mato tah man jascahpabo jatimahi. Maton hapocatsihqui ta maton yonoti jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maton cacannicacatsihqui ta jatihibichin teexonnica jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jascarihbihi tah hen hahxoni joníqui, yonohima. Hicha jihuetahbo tah hen mahuati joníqui, jaton ribin copijaxoni quescari. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericó jema janin sca nococani. Jahuen haxenicaboyabi cahax hicha joniboya rihbi janohax cahiya, bahimahhuan hihquicahuanax Timeon baque Bartimeo tsahoti. Bartimeo cahen benche joni, coriqui yocanica joni. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesus jano huinotai yohihahbo coshin quenaquin: —Hehon shinanhue, Jesus, Davidinin baquen —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jascaraiton: —Jascayamahue. Netehue —hahcanquin hichaxon. Jascahahbo hashoan coshin sca yohuani: —Hehon shinanhue, Davidinin baquen —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nihrenenxon Jesusen yohiquin: —Jaa quenanahue —jato jaquin. Benche joni sca quenacanquin: —Jenimahax huenihue. Mia ta quenamahiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jahuen rahcoti potabahinax histon huenicahuanax Jesus qui cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nocotaiton Jesusen yocaquin: —¿Mia jahuejaxonti min queenain? —hahquin. —Heen bero hea rohajahue, Hihbon —hahquin benche jonin. ");
INSERT INTO kaqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Caresscatanhue. Hihcoinjaquin shinanax tah min rohascai —hahscaquin Jesusen. Rohascaxon Jesus chibanbonascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalen hochoma sca Betfagé jema patax Betania jema patax rihbi Olivos mahchi janin nocoxon Jesusen jahuen haxenica rabe raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Man jano nichi hoque jema janin catannahue. Nocoxon tah man cabacho baque nexa meraxihqui, hahan tsoabi cahtsahoyamaparihi. Pecahax jaya jonoxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jahuejanoxon man jascajahin jaiboya, Noquen Hihbo ta nea pishinihqui. Rahmabi ta mihqui raanrihbinoxihquiqui, hahnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Caxon cabacho baque xehqui patax nexa meracanquin. Janibi bahin nichi meracanquin. Meraxon pecacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pecahiton jano nichibaan jato yocaquin: —¿Jahua man jain? ¿Jahuejanoxon man cabacho baque pecahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Hihbaan yohiha quescajaquin sca jato yohicanquin. Yohiha jeenhihscacani, jaabo jaya catannon. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Cabacho baque sca Jesus qui hihuecanquin. Cabacho jaton chopabo cajanxon sca Jesus cahtsahoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Caibaan rihbi jaton chopa bahinbi cacajaquin. Caibaan rihbi nahue chian pehi bihtanxon bahinbi cacajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bebohibo betan chini cahibo coshin yohuanbonacani: —Hahxonhue, Papan. Nete Hihbaan raanah ta jahuiqui. Miin shinan siri jaa hinanhue, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Noquen xohta Davidinin jahuen jihuetahbo jihuemapahoni quescajaribiquin ta janoxihquiqui, jahuen shinan Papan hinanah. Jaa hahxonhue, Naihoh quehan. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalen jema janin hihquihax sca Papan xoboho Jesus hihcohi. Jatihibi jispaquehax moa bepiscaiya Betania jema janin caribihi jahuen doce joniyabi. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hoxashinahax mohiyahtax sca Betania janinhax cahax pihan hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hochoxon bimi jihui pehiyahpa jisxon bimijoma hin hihquish jisi cahi. Jihui qui nocoxon jahuabi merayamaquin pehi rahsi, jahuen bimiti tian nocorihyamahiya. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","—Jahuentianbi sca miin bimi tsoanbi piyamanoxihnon —hahscaquin. Jihui yohiquin jan jascajahi jahuen haxenicabaan nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalen janin nocorihbihax Papan xoboho hihcohi. Hihcoxon janoxon marohibo cainmaquin. Maromahibo picomaquin. Coriqui mahnenanaibaan misabo behonjanaquin. Nobex maromahibaan tsahotibo rihbi behonjanaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jaa xobon tsoabi jaton jahuabora papihibo huinomayamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Honanmaquin sca jato yohiquin: —Jatihibi mai mehabaan janoxon yocati xobo ta heen xobo jayaxihquiqui. ¿Jascapa huisha yama quin? Jai bi tah man jano yometsohtaibo joneti xobo man heen xobo jai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jan jascajahi sacerdote hapobo betan huishani honanbaan nincaquin. Jatihibi tsamajaquetai jonibo jahuen honanmati joi qui rahtetaiya hahqui raquexon jenquetsahaxon non jaa rehtetihin hihxon shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bepiscaiya jema janinhax bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yamequirihbi huinonbahinxon tapon caman bimi jihui xanascai meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jan yohuanipi shinanrihbixon sca Pedronen yohiquin: —Jise, Hihbon. Hoa bimi jihui min hahqui yohuanipi ta pehua sca jaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusen jato yohiquin: —Papahon shinancoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hen mato yohinon nincanahue: jahuen jointinin shinancoinyamaxonma bi shinancoinai jonin nea mahchi nescajaquin yohihiya, Huenitax, hian janin hueramehhue, jan yohihi quescabijaquin ta Papan hahxontihiqui. Jan yohihi Papan jascascajatihi shinancoinaiya ta Papan hahxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaa copi tah hen mato yohihi. Papa yocaxon man yocacaibobi man bihtihi shinancoinnahue. Jascajaquin yocaxon ta man bihtihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nihxon Papa yocaxon mato qui hohchataibo shinanyamascanahue. Maton Papan rihbi naihohxon man hohchataibo shinanyamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Jascapa man shinanyamascatihi bi man shinanparihiya ta maton Papan rihbi naihohxon man hohchataibo shinanbehnotimahihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalen janin sca boribicani. Papan xoboho Jesus nichiya hahqui bocani sacerdote hapobo, huishani honanbo, judiobaan hanibo. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hahqui caxon yocacanquin: —¿Jahuaxon min jascajahin? ¿Tsoan jascajahue hahca min jascajahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Mato rihbi ta hen yocacai. Man hea yohihiya tah hen jahuaxon hen nescajahi hean rihbi mato yohitihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Tsoan raana Juaman nashimapahonishquin? ¿Papan nan? ¿Jonibaan nan? Hea yohinahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jaabo rahsi sca yocacahnanancani: —Papan rahan, hih non jaiya ta jaan sca noque yocatihiqui, Papan raana Juaman nashimahiya jahua jenquetsahin sca man jaa nincacoinyamanihquin? ");
INSERT INTO kaqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Jonibaan rahan, hih cahra non jatihin? —hihcani tsamajaquetai jonibo qui raquetax. Papan joi yohinica Juan jai jatihixonbi shinanai copi jato qui raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yocacahnananxon Jesus yohicanquin: —Non tah non honanyamahi —hihcani. —Hean rihbi ta hen mato yohiyamahi, jahuaxon hen nescajahi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jaa patax queha joi sca Jesusen jato yohiquin: —Huesti jonin cahen huai banahan. Banaxon chiquequin. Chiquexon macan quenchajaquin, bimibo jentsinnoxon. Janoxon huai coirannoxon sca tapojascaquin. Banaquin queyoxon sca caibo jahuen huai hinantahquin. Huai hihbo sca huetsa main cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bimi tian jan hinantaho hihbobo qui jahuen joni raanquin, bimi texe hinanahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nocotaiton rishquixon jahuabi bimijoma raanscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mequen bi res nocotaiya huetsa jahuen joni sca raanrihbiquin. Nocotaiton mapo qui tsehuejaxon tiromajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Huetsa jahuen joni rihbi hapon raanrihbiquin. Jaa rehtecanquin. Huetsa rihbi jascajacanquin, caibo rishquixon caibo rehtequin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Huesti sca jai, hahan jan shinanai jahuen baque huesti sca. Chini sca jaa jato qui raanquin, heen baque ta nincatihcaniqui, hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nocotaiya hinantaho hihbobo yohinani: Nea ta jahuen papan huai hihboyaxihquiqui. Jaa rehtehi canon bonahue jahuen huai noquenah sca janon, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jaa bihxon rehtexon huai behro potacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Jahueja jascapahbo huai hihbaan jatihiquin? Joxon ta hinantaho hihbobo rehteyaxihquiqui, huetsabo sca huai hinantahnoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Nescajaquin huishani joi man jisyamaniquin? Tiroma ta jaiqui hihxon xobojahibaan potabohannihbo jihui ta hahqui xobojati jihui qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Papan ta jascajahiqui. Jan jascajahi jisish tah non rahtetai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jahuen huai joi jan yohihi jatoya jan joihi honanxon jaa xecotancatsihquibo bi tsamajaquetaibo qui raquetax jaa janinhax boresscacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yohuanquihnahbo jaamahi yohuanaiton bihnon fariseoboya herodianobo sca raancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Raanahbo hahqui caxon yohicanquin: —Mian ta min ponte yohihi, Maestron. Non tah non honanai. Rabinxonma tah min honanmahi. Tsohqui raquexonma tah min jatihibi jonibo min yohihi. Jahuabi joi huetsajaxonma tah min ponte res noque yohihi. Papan joi ta min honanmacoinai. Cesaronen noque cobranah noquen copijati joi jaiquin? ¿Yamahihquin? ¿Non copijatihin? ¿Non copijatimahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jaabo hihcoinicamahi yohuanai honanxon jato yohiquin: —¿Jahuejanoxon man hea tanahin? Huesti coriquiya benahue hen jisnon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Huesti bohiboya jato yocaquin: —¿Tsoana hin, nea mapo? ¿Nea huisha cahran? —jato jaquin. —Cesarona rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Cesaronabo Cesaro hinanrihbinahue. Papanahbo Papa hinannahue —jato jaquin Jesusen. Jan jascaraiya hahqui raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceobo sca Jesus qui bocani. Tsoabi ta hahquirihbi huenitimahiqui hihquibo. Nocotax yocacahcani: ");
INSERT INTO kaqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Moisesnin ta noque huishaxonnishqui, Maestron. Jahuen huetsa baquejahaxma mahuataiya ta jahuen yononma jahuen chinipan bihtihiqui, jahuen bochan baque janon hahqui baquejanoxon hahquin huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Siete huetsabo ta janishqui. Beboquihahnen ta haibo bihnishqui. Bichish bi mahuati, baquejahaxma. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jahuen chinipan sca ta jahuen yononma bihnishqui. Bichish bi mahuati, baquejahaxma. Jahuen jochica jascarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Siete rahsi jascari mahuati, baquejahaxma. Chini sca haibo rihbi mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Papan noque hahquirihbi huenihi tian jahuemehatona jaa haibo hihyaxihquiquin, siete jatihixonbi haibojani? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesusen jato yohiquin: —Papan huishamani joi honanyamahax tah man jascarai, jahuen coshi rihbi honanyamahax tah man ponte yohuanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mahuataibo hahquirihbi huenihi tian ta Papan yonotibo naihoh queha jai quescapahbo bebobo jayaxihquiqui huanohahmabo. Haibobo rihbi ta beneyahpatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Mahuanihbo hahquirihbi huenitimahiquin? ¿Papan Moises yohini man jisyamaniquin, Moisesnin huishani janin hoa jihui namantiha pishca joibo jaiton? Papan ta Moises yohinishqui: Abrahanen Papa Dios tah hen qui, Isaaquen Papa Dios, Jacobon Papa Dios hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mahuataibaanama bi jihuetaibaan Papa Dios ta jaa qui. Jaamajaquin tah man shinanai —hahquin jato. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jaatian sca huishani honan huesti jato pataxi jahui. Jaabo yohinanai nincaquin. Jesusen jato yohiquin sirijahi jisxon Jesus yocaquin: —¿Papan yohini joi non jahuemeha hihti nincatihin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusen sca yohiquin: —Hihti nincati joi ta nea qui. Nincanahue, Israelibaan. Noquen hihbo Papa Dios ta jaa huesti hihbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Miin Hihbohon shinanhue miin jointiboyaxonbi, miin yoshinboyaxonbi, miin shinanboyaxonbi, miin coshiboyaxonbi. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jaa pecaho ta nea qui. Mihbe jihuetaibohon shinanhue, mihmebi min shinamehti hihqui quescarihbijaquin. Nea rabe joi mentan ta hashoan hani joi yama qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jascajaha huishani honan joni sca yohuani: —Ponte ta min jai, Maestron. Papa Dios huesti tah qui. Huetsa yamahi, jaa huesti. Hihcoin tah min jai. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Noquen jointiboyaxonbi noquen shinanboyaxonbi noquen coshiboyaxonbi noquen Papahon shinantixon, non noquebi shinamehti hihqui quescarihbijaquin noquen hahbe jihuetaibohon shinanti ta Papa qui hinanti jatihibi mentan hashoan siri qui. Jatihibi hinábo rehtexon Papa qui hinanti mentan hashoan siri —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jan honanax yohuanai jisxon Jesusen sca jaa yohiquin: —Papan jihuemati hochoma ta mia qui —hahquin. Jaa pecaho yocati qui raquecani jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Papan xobohoxon honanmahahnan Jesusen jato yocaquin: —¿Jenquetsapahin huishani honanbaan nescajahiquin: Cristo ta David xohta qui hahquin? ");
INSERT INTO kaqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dios Yoshiman shinanmaha ta Davidininbi yohinishqui: Papan ta heen hihbo yohinishqui: Hea mecayaho tsahohue, miin rahuibo hen mia namanjaxonnon caman. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jaa yohihi, Heen hihbo, ta Davidininbi janishqui, jaanbi. ¿Jenquetsahax sca jahuen xohta hihtihiquin? —jato jaquin. Coin coinxon hicha tsamajaquetaibaan nincacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Honanmaquin jato yohirihbiquin: —Huishani honanbo qui raquenahue. Chopa nenque sahuehax ta nihniti costancaniqui. Janoxon maroti janin caibaan jato hapon hahti rihbi ta costancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jaho tsinquiti xoboho ta hashoan siribo tsahotibo rihbi queencaniqui. Fiesta tian ta jano hashoan cacannicabo tsahotai janin tsahocatsihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Haibo yononmanen xobo ta jahuen jahuequiboyabi bichincaniqui. Caibaan jato jisnon hihxon res ta chaijaquin Papa yocacaniqui. Jascapahbo ta hashoan casticanyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jano Papa Dios hinanti coriqui naneti hoque tsahoxon jaton coriqui nanehibo Jesusen jisquin. Coriquiyahpa jonibaan ta hichaxon hicha coriqui nanecannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jahuabijoma haibo yononma huesti joxon cahen nanequin, rabe coriqui pishca huesti soro copitai. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jahuen haxenicabo quenaxon sca Jesusen jato yohiquin: —Nincanahue, mato yohinon. Jatihibi coriqui nanehibo mentan ta nea yononmanen hashoan nanehiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hicha jaxon ta jaabaan nanecaniqui. Jahuabi jaxonma bi ta neatohon jan jai pishca queyobahinihqui nanequin —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Papan xobohoh quehax cainaiton sca jahuen haxenica huestichin yohiquin: —Maestron, yotihoparahbo macanbo, yotihoparahbo xobo jise —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesusen sca jaa yohiquin: —¿Nea hihtihosi xobobo min jisin? Ni huesti macanbi ta huetsa cahchian cahtsahoyamascatihiqui. Jatihibi ta potapaqueyaxihcanihqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Picotax sca Papan xobo hoque tocan Olivos manan janin tsahotaiton Jesus yocacanquin Pedro, Jacobo, Juan, Andres, jaabo rahsichin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Noque yohihue. ¿Jahuentian jascajayaxihcanihquin? ¿Jahua hahan honanti jayaxihquiquin, min noque yohiha quescabi janon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusen jato yohiquin: —Jisnahue. Mato parancanmis. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jaa ta hen qui hihquish ta heen janen joyaxihcanihqui hicha. Hicha jonibo ta paranyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Rehtenanaibo nincacax, hocho rehtenanaibo joi rihbi nincacax raqueyamanahue. Nete queyorihyamanon ta jascatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nahuabo ta hahbe nahuabo betan rehtenantihiqui. Quiquin hapon jonibo ta huetsa quiquin hapon jonibo betan rehtenantihiqui. Huetsancobo ta mai mihuanyaxihquiqui. Piti ta yamayaxihquiqui pihan hihquibo. Jascaraiboya ta hohmis hohmisti pehocohtiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Matobi coiramenahue. Casticannicahbaan tananon ta mato hinanyaxihcanihqui. Haho tsinquiti xobohoxon ta mato rishquiyaxihcanihqui. Tinintibo bebon tah man nihyaxihqui, quiquin hapobo bebon rihbi. Man tah man jato yohicoinyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Heen joi siri ta jatihibi jonibo pari yohiti jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mato yahtanxon hinanaiya, jahua non jatihin hihxonma masa shinanyamanahue. Mato jaatianbi hinanai yohuan yohiyaxahnahue. Matonbi shinanaxma bi Dios Yoshiman yohuanmaha ta man yohuanyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Huetsa jonin ta jahuen huetsabi hinanyaxihquiqui, rehtehahbo. Huetsa papan ta jahuen baquebi jascajarihbiyaxihquiqui. Jaton papa, jaton mama rihbi rahuijaxon ta baquebaan jato rehtemayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jatihixonbi ta mato jistahihmayaxihcanihqui man heen jane jai copi. Jascahahbo bi ta mahuanoxon caman tenehi joni hean teehihmayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jan jano nihtima janin rahninti masajanica nichiton merahax mahchi quiri jabayaxahnahue, Judea mai mehahbon. Honanhue, nea quirica jisnican. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Xobo pemacanya janinhax jahuequi bihbahini xoboho hihcopaqueyamayaxahnhue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Huai chian teetax rahcoti bichi joribiyamascayaxahnhue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tohoyabo betan xoma hahmahibo ta hohmis hohmisyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Matsi tianbi jascayamaxahcabo Papa yocanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Papan jato jonijamenoni yamanish ta rahma caman tsoan jisyamanibo tiromabo netebo jayaxihquiqui. Jaax ta jahuentianbi jascapa hahquirihbi jaribitimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jaa netebo noquen hihbaan basimayamahiya cahen tsoabi baneyamahan. Jan caisnibohon shinanxon ta jaa netebo basimayamayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jise, nea ta Cristo qui hihquiboya nincayamanahue. Jise, hoa tah qui, hihquiboya hihcoinai shinanyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cristohaxma bi Cristohicamahi Papan joi yohihihcamahibo rihbi ta jatihiqui. Hahan honantiboya hahan rahtetibo ta mato jismatihiqui, hahtipahxon Papan caisaibo parannoxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jisnahue. Jascapahbo jatihibi jariyamanon ta hen mato yohiscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jaa hihti tiromabo pecaho ta bariyahpanbi bari xabayamascatihiqui. Hoxne nete rihbi ta yamascatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Naihoh quehax ta huishibo paqueyaxihquiqui. Hani huishmabo ta bahinma sca cayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jaatian ta nai cohin tocan hihti coshi shinanya hihti xabatai hea noquebaque jahui hea jisyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jaatian tah hen heen yonotibo raanyaxihqui. Raanah ta reboqui caxon, chiponqui caxon bari cainai quiri caxon bari hihquihi quiri caxon jano nai chibechijaquehtancahuanaiton caxon jahuen caisaibo tsinquiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Pesto jihui jisquin hahcajaquin honannahue. Pesto pereocotax bochocohiya tah man jene tian rahma jahui man honanai. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jascajaribiquin hen mato yohihi quesca sca jai jisxon hea noquebaque neno pishca sca jaonahi honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Man honannon hihxon tah hen mato yohihi: rahma chini jihuetaibo queyorihyama jai bi ta hen mato yohihi quesca sca jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Naiya mai queyocahinai bi ta heen joi jascabiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","¿Jahuentian jascapahbo jayaxihquiquin? ¿Jahua neten, jahua hora? Tsoanbi ta honanyamahiqui. Papan naihoh quehabaan yonotibaan bocabi honanyamaquin. Papan baquen rihbi honanyamarihbiquin. Papa huestichin honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jisnahue. Jahuentian jaa nete jotihiquin honanaxma coiramenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Huesti joni hocho catani jahuicama tah hen jatihi. Jahuen xobo janinhax cacatsihxon cahen jahuen jonibo tee hihbomapaquequin. Huetsa jahuen tee, huetsa rihbi jahuen tee, jatihibi jaton tee jato hihbomapaquequin. Xehpoti coirannicah rihbi yohiquin coiranhue, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","¿Jahuentian xobo hihbo joyaxihquiquin? ¿Yamescaiya, yame pochinicon, hatapa queotaiya, xaba paquetaiya? Man tan man honanyamahi. Jaa copi coramenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Man shinanyamahi tianbi joxon hoxahiton mato meramis. ");
INSERT INTO kaqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jatihibi jonibo hen yohihi quescajaquin tah hen mato jai: coiramenahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua fiestaya chahoma paan fiesta rihbi nocoti rabe nete pishinaiya cahen sacerdote hapobo betan huishani honanbo yohinani: —¿Jenquetsahaxon non Jesus paranxon bihtihin rehtenoxon? ");
INSERT INTO kaqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Fiesta jai tian bihtima ta jaiqui, hoa fiestajahi jonibo rehtenanmis —hihcani yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jaabo jascarai bi Betania jema janin Jesus pihi tsahoti Simoman xoboho. Simon ta sipi paheyahpa japahonishqui. Pihi tsahotaiya huesti haibo jahui, hahan hininti nardo xeniyahpa pomoya, hihti copi bi res hahan hininti. Jahuen pomo retequebahinxon Jesusen mapo qui nardo xeni machiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Machicaiya caibo rainyamahi: —¿Jahuejanoxon nea hahan hininti xeni jascajaquin yohyoquihquin? ");
INSERT INTO kaqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jaa nardo xeni maromaxon ta trescientos denarios, hashoan rihbi, bihquehaniqui jahuabijomabo sca coriqui pishca hinannoxon —hihcani, haibo qui rainyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesusen jato yohiquin: —Jenenahue. ¿Jahua jenquetsahin man jaa jatsanjain? Jan hea jascajaxonah ta siri bi res qui. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mato tocan ta jahuabijomabo jascabihi jatihiqui. Man queenai tianbi tah man jato yanapanti hahtipahi. Huetsa tian ta mato tocan hea hihyamascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jan hahtipahi quescaja ta haibaan jaxonaxqui. Hea tsahonyahnoxon ta heen yora hea hininjahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yohicoin ta hen mato jai: jatihibi mai janinxon heen joi siri yohixon ta jaan hea jascajaxonni yohiyaxihcanihqui, jaa haibo shinanxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jaatian sca Judas Iscariote cahi. Jaa cahen Jesusen haxemati huesti, sacerdote hapobo qui cahax jato Jesus hinanyahnoxon jato betan bexohi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jan jascacatsihqui nincacax coincoinxon yohicanquin: —Mia tah non coriqui hinantihi —hahcanquin. Jenquetsahaxon hen hinantihin hihxon Judasen shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chahoma paan fiesta pehocohti neten sca pascua carnero baque rehtehiboya Jesusen haxenicabaan yocaquin: —¿Jahuerahnon non catihin, pascua fiesta mia pitijaxonnoxon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yocacah cahen rabe jahuen haxenicabo raanquin yohixon: —Jema janin botannahue. Janoxon ta jeneyahpa poo maibehnani jahui jonin mato behchixihquiqui. Hahbe botannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jan hihcohi janin xobo hihbo yocanahue: Noquen maestron ta mia yohihiqui, Jahuerahnon hin, janoxon piti chique, janoxon heen haxenicabo betan hen pascua fiesta pinon. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bochiquiha hani chique ta mato jismaxihquiqui, misayahpa, tsahotiyahpa, moa hihrescai. Janoxon noque pitijaxontannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Raana jema janin nocoti bocani. Jan yohihi quescabijaquin meracanquin. Pascua fiesta sca pitijaxoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bepiscaiya jahuen doceyabi Jesus nocoti. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pihi tsahoxon jato yohiquin: —Man honannon hihxon tah hen mato yohihi: mato quiha huestichin ta hea bihmatihiqui, hehbetan pihi huestichin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Masa shinanxon jatihixonbi yocapaquecanquin: —¿Hea hen quin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Heen doce quiha huesti tah qui. Hen poseman netinai tason qui ta jaan rihbi hehbetanbi jahuen poseman netinihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hea yohihi huishani joi jai quescari tah hen mahuanoxihqui. Hahraai hih ta jatihiqui, hea bihmahi joni. Jahuentianbi jonijayamaha ta jaa hashoan siribiresquehanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pihanan sca posen bihxon Papa yocaxon tehcapaquexon jato hinanpaquequin. —Bihnahue. Nea ta heen yora qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tason rihbi sca bihxon Papa yocaxon jato hinanquin. Hinana jatihixonbi hahqui xehaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Nea ta heen jimi qui. Hicha jonibaan hohcha copijaquin tah hen heen jimi potaxihqui. Mahuaquin tah hen mato hahxonbahinai. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yohicoin tah hen mato jai: nea xehati tah hen hahquirihbi xehayamascatihi. Janoxon Papan jihuemahi janinxon pari ta hen behna sca xehayaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Papa qui behuahax sca Olivos manan janin boribicani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Janoxon sca jato yohiquin: —Jatihixonbi tah man hea potabahinnoxihqui, huishani joi jai quescajaquin: Carnero coirannicah ta hen rehtetihi carnerobo potojahtani jabisihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Hihquipi bi hahquirihbi huenihah tah hen hea pari Galilea main cayaxihqui, man chini canon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedronen sca yohiquin: —Jaabaan jatihixonbi mia potahi que bi tah hen hean mia potatimahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Yohicoin ta hen mia jai: hatapa rabe coti queori jaima tah min heen joni hihtima min quimisha coti yohinoxihqui nea yamebi —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jascajaha coshin sca yohuani: —Hea miayabi rehtehibaan bi tah hen miin joni hihtima hen yohitimahi —hihqui. Jatihibi sca jascarih. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Getsemaní janeya huai janin sca bocani. Nocoxon sca jahuen haxenicabo yohiquin: —Nenobi tsahopaquenahue, hen Papa yocatannon. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jascajaxon Pedro, Jacobo, Juan, jaabo rahsi boquin. Hihti masa shinanscaquin Jesusen. Rahte rahteti. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Heen jointiboyabi tah hen bena benatai, hahan mahuati bena tah hen jai. Nenobi banexon coirannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hoque pishca cahax beho racaxon Papa yocaquin, janoxihquibo jatimajati yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Papan, hea janoxihquibo jayamanoxahnon jahue, jatimajati hahtipahxon. Mian tah min jatihibi hahti hahtipahi. Jaabi hea queenai quescayamahi bi mia queenai quescahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Joribixon jaabo hoxahiton meraquin. Hoxahiton meraxon Pedro yohiquin: —¿Min hoxayamahin, Simoman? ¿Huesti hora pishca min coiranti hahtipahyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Coiranhanan Papa yocanahue mato hohchati queenmayamahabo. Maton shinaman man coshiti shinanai bi tah man shinan coshi yamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hahquirihbi caxon Papa yocarihbiquin. Jan yocacah quescajaquin yocarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Joribixon sca jato hoxahiton merarihbiquin, jaton bero quextojaqueti. Yocacah bi jahua yohiti honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jahuen quimisha coti sca catani joribixon jato yohiquin: —¿Man tanti tantihi hoxaparihin? Senen ta jaiqui. Hora ta nocoscaiqui. Hea noquebaque ta hohchayahpabo jonibo hinannoxihquiqui, bichíbo hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Huenitax canon bonahue. Jisnahue, hea bihmanica ta jahuiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jan jascajahi betanbi Judas nocoti, jahuen doce quiha huesti. Hicha joni machitoyahpabo huinoyahpabo rihbi hahbetan becani. Sacerdote hapobaan raanah becani. Huishani honanbo betan judiobaan hanibaan rihbi raanah becani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jato betan bexohax bihmanica jato bebohi jahui. Hahan Jesus honanahbo jato yohibenanai: —Hen hicotannoxihqui joni tah qui. Jaa bihxon coiranxon hiotannoxahnahue —jato yohibenani jahui. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nocotax res sca Jesus qui joxon: —Hihbon —hahxon hicotanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hicotanaiya Jesus bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesus bichiboya jaa patax nichi huestichin jahuen machito tsecaxon sacerdote hapon yonoti reraquin bi jahuen pabinqui res paxtebahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesusen sca jato yocaquin: —¿Yometso bihquin hahcajaquin man hea bichin, machitoyahpa joxon, huinoyahpa rihbi joxon? ");
INSERT INTO kaqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Netetihibi Papan xobohoxon honanmahanan hen mato betan hihrasihi bi tah man hea bihyamahipiqui. Jaabi huishani joi jai quescabi janon tah man nescajahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jato jascajanon jatihixonbi jaa potabahini jahuen haxenicabo jabati. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huesti beronanen cahen jahuen rahcoti res sahuexon Jesus chibanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jaa rihbi sca bichibaan bi jahuen rahcoti potabahinax chopanma sca hishtocanahi jabati cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sacerdote hapo janin sca Jesus hiocanquin. Sacerdote hapobo, judiobaan hanibo, huishani honanbo jatihibi jano tsinquicani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hiohibo bi hochoxon Pedronen jato chibanbonaquin sacerdote hapon xobo jemanhihti janin hihconoxon caman. Jemanhihtin sca sacerdote hapon yonotibo betan pehchihi tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xobohoxon cahen sacerdote hapobo betan tsinquitaibaan jatihixonbi Jesus qui yohuancointi joi benacanquin, cahexon rehtemanoxon. Benaxon bi merayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hahqui yohuancoinihcamahi quesahi yohuanaibo hichahi. Jaa joiya huesti yohuancoinyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Caibo nihinahtax hahqui yohuancoini quescari quesahi yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nea mequeman xobojanihbo Papan xobo tah hen potapaqueyaxihqui. Quimisha neten potahipixon tah hen huetsa rihbi sca xobojayaxihqui, mequeman hahcahma sca, hih ta jaipishqui noquen nincanonbi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jascaraibaan bi jaa joiya huesti yohuancoinyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naponbi nihxon sca sacerdote hapon Jesus yocaquin: —¿Min jahua yohiti yamahin? ¿Jahua yohuan neabo mihqui jaiquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jascahah bi jahua hihyamahi. Neteti. Sacerdote hapon yocarihbiquin: —¿Mia min Cristo quin? ¿Mia min noquen Papan siripan baque quin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jaa tah hen qui. Coshiyahpaton mecayaho hea noquebaque tsahotai tah man jisyaxihqui. Nai cohin tocan jahui rihbi ta man hea jisyaxihqui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jan jascajahiya sacerdote hapon sca jahuenahbi jahuen chopa huaxabahinxon yocaquin: —¿Jahua copi non hashoan rihbi hahqui yohuanti benaparitihin? ");
INSERT INTO kaqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jan tiromahi Papa qui yohuanai ta man nincascai. ¿Jahuejati man shinanain? —hahquin. —Rehteti ta jaiqui —hihcani jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Caibo hahqui toshbanhihcahini. Jahuen bemanan beracohxon rishquixon yocacanquin: —¿Tsoan mia rishquihiquin? Noque yohihue —hahcanquin. Sacerdote yonotibaan sca bihxon rishqui rishquirihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Naman jemanhihti janin Pedro nichiya sacerdote hapon yonoti haibo jano cahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro pehchihi jisxon bejisquin sirijaxon yohiquin: —Mia rihbi tah min Nazaret janinha Jesus manahi nihrasihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jascajaha jeenhihyamahi: —Jahua rah tah min jai. Min yohuanai ta hen honanyamahi —hihqui. Jemanhihti xehpoti janin sca Pedro nichi cahiya hatapa queoscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jan cahi jisxon yonoti haibaan jano nichibo sca yohiquin: —Jaa ta jato betan nihnicah qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Haibaan jascajahi bi Pedro jeenhihyamahi. Jascama ta qui hihresi. Jaa pecaho pishca jano nichibaan sca Pedro yohirihbiquin: —Hihcoini tah min jato betan nihnicah qui. Mia ta min Galilea mai meha qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—Hen yohuancoinyamahiya Papan hea rehtenon. Papan hea jiscoina tah hen yohuancoinai. Man yohihi joni tah hen honanyamabiresai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jahuen rabe coti sca hatapa queoti. Queotaiya cahen Jesusen yohiha joi Pedronen shinanscaquin: Hatapa rabe coti queori jaima tah min heen joni hihtima min quimisha coti yohinoxihqui. Jaa joi shinanax hihti benatax huaohihscai. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Xaba paquescaiya sacerdote hapobo, judiobaan hanibo, huishani honanbo, jaabo rahsibi tsinquitax yohinani. Jesus menexxon hioxon Pilato hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatonen sca yocaquin: —¿Mia min judiobaan quiquin hapo quin? —hahquin. —Min yohihi quesca rahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hahqui tiromahi yohuanquin sca cahen sacerdote hapobaan joi tsamanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatonen sca jaa yocarihbiquin: —¿Min jahua yohiti yamahin? ¿Mihqui hicha yohuanquin joi tsamanaibo min nincayamahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yocacah bi Jesus jahua hihyamascaiya Pilato rahteti. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pascua fiesta tian ta jan sipojani huesti Pilatonen jato picoxonpahonishqui, jaabaan yocacai huesti picoxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jaton quiquin hapo potacatsihquin, rehtenanxon huetsa jonibo rehtehiton jan sipojanibo jai. Huesti cahen Barrabas janeya. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tsamajaquetai jonibo mapexon sca, jan jato hahxonpahoni quescajaquin Pilatonen jato hahxonnon yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yocacatsihquibo bi jaan pari yocaquin: —¿Judiobaan quiquin hapo hen mato picoxonti man queenyamahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sacerdote hapobo notsi notsixon hinanai honanscaxon jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jascahah bi cahen sacerdote hapobaan tsamajaquetaibo yohuanquihnquin sinamaquin, Jesus yocatima shinanahbo. Sinaxon sca Jesusma bi Barrabas jan jato picoxonnon yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jascajahiton Pilatonen jato yocarihbiquin: —¿Barrabas picoxonti man queenaiya maton quiquin hapo hahcaibo joni cahran? ¿Jaa hean jahuejatihin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Jihuin hueonhue —hahcanquin coshin bi res. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Jahua copi nan? ¿Jahua tiroma jaiquin? —jato jaquin Pilatonen. Jan jascahah bi hashoan coshin sca yohuancani: —Jihuin hueonhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jenimahabo sca Pilatonen Barrabas jato picoxonquin. Jesus rishquimaxon, jihuin hueonnon hihxon, bihnahue jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bihnahue hahca hapon xobo chicho sca sontarobaan Jesus hioquin, pretorio janeya xoboho. Jano hioxon sca hahbe sontarobo jatihibi quenacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yancon chopa sahuemaxon moxa maitijaxon maimacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—Jihuehue, judiobaan quiquin hapon —hahcanquin hapojahicamaxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jascajaxon jihui taxon marishquicanquin. Hahqui toshbanhihcani. Hapojahicamaxon hahqui raboxonen tisquihahpaquecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hosanquin queyoscaxon yancon chopa pecaxon jahuen chopa sahuemacanquin. Sahuemaxon jihuin hueonnoxon sca hiocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simon janeya joni cahchihoh quehax jahuex jano huinotaiton jahuen coros hiamacanquin. Jaa ta Alejandro betan Rufo jaton papa hihpahonishqui, Cirene mai janinhah. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jano Gólgota jane jaiton hiocanquin. Gólgota cahen mapo xaoya manan hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mirra rahoya vino mescoxon xehamacatsihquibaan bi queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jihuin hueonscacanquin. Jahuen chopabo metisahcanquin. Tsoana banetihiquin hihxon macan bero borasa qui nanexon chicoha huetsa pari cainaiya huetsan bihnon, huetsa macan pari cainaiya huetsan sca bihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bari hihinahtaiya hueoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jahua copi rehtehiquin honanahbo hihxon quirica sca hueoncanquin. Judiobaan quiquin hapo, hihqui jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Rabe yometsoh rihbi hueoncanquin, huetsa jahuen mecayaho, huetsa jahuen memiho. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jaatianbi ta huishani joi quesca sca janishqui: Hohchataibo betan hihqui shinanxon rehtehah ta qui, hihqui jaa joi. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jano huinotaibaan sca jaton mapo bose bosehihcahinxon hosanquin. —Heeeen. Papan xobo potapaquehipixon tah hen quimisha neten hihxon jaa xahnen hen huenirihbiyaxihqui hih ta min jaipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Coros janinhax bototax mihmebi sca teehihhue —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sacerdote hapobo, huishani honanbo betan jascarihbihi yohuani. Hosancanquin. —Caibo teehihmaxon bi ta hahmebi teehihti hahtipahyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Criston, Israelibaan quiquin hapon, coros janinhax rahmabi botopaquequihranhue, botoquihranai mia jisxon non mia nincacoinnon —hihcani. Hahbe hueonahbaan rihbi hosanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Barin manan tsacahiya sca jatihibi mai bahquishihcahinscai, bari racapaquenon caman. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bari racapaquetaiya sca Jesus coshin yohuani: —Eloi, Eloi, ¿lama sabactani? —hahquin. Papan Dios, Papan Dios, ¿jahua jenquetsahin min hea jenescain? hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jan jascahi nincaxon: —Jisnahue, Elías ta quenahiqui —hahcanquin jano nichibaan. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Hishtocahinxon huesti jonin xehati cachani qui taco quescapah maosahxon jihui taxo qui queonxon sananhihnixon xehamaquin. Xehamaxon: —Mananahue. Jaa botonnoxon Elías jahui non jisnon. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jaatian sca saisaihihquish Jesus mahuascai. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jaatianbi ta Papan xobo janin rontamehtai chopa chique huaxacahinnishqui, bochiqui janinhax naman caman. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesus bebon nihxon jan jascari mahuatai jisish capitan sca yohuani: —Hihcoini, nea ta Diosen baque qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Haibobaan rihbi ta hochoxon jisnishqui. Huetsa cahen María Magdalena, huetsa cahen María, hoa chinitai Jacoboya José jaton mama, huetsa cahen Salomé. Jano nihxon ta jiscannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galilea janin Jesus nichiya cahen jaabaan jaa chibanpahonish. Jaa pimarihbipahonish. Jesus betan Jerusalen janin jahuipi haibobo rihbi ta jano nihxon jiscannishqui, hichaxon. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yantanscaiya cahen bahquish tantiti neten piyanoxon pitijacanquin, jaton pitijati neten. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jaa copi jahuen raque potahax Pilato janin caxon Jesusen yora Josepan yocaquin. Jaa José ta Arimatea janinhah hihpahonishqui hahbe hapobo tsinquinica, shinanyahpa joni. Papan jihuemahi jiscatsihqui jaan rihbi manaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesus mahuascai nincacax Pilato rahteti. Capitan quenaxon sca yocaquin: —¿Mahua sca jaiquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Mahua sca ta jaaxqui —capitan jaiya jeenhihscai, Josepan jahuen yora bihnon. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sábana maroxon Jesus botonpaquexon sabananen rahcoxon macan xanquen poquinipibo tsahon chicho racanquin. Macan taranxon sca tsahon quini behpoquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jan jano tsahonai ta María Magdalena betan Josepan mama Marian jisnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tantiti nete huinoscaiya hininjahi canoxon hahan hininti marocanquin, María Magdalena, Jacobon mama María, Salomé, jaabo rahsibichin. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hahan semana pehocohtai neten sca xaba honanax yamequiribi tsahon janin bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yohuanbonacani: —¿Hahan tsahon behpohipi macan tsoan noque taranbohanxontihiquin? —hihcanahi. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jaa macan cahen hihtihosi. Jari jisxon moa taranbohanah meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tsahon chicho hihcoxon joxo tariyahpa beronan mecayaho tsahotai meracanquin. Merahax rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jaan jato yohiquin: —Rahteyamanahue. Man tah man Jesus benahi Nazaret janinha Jesus hueonipibo. Jaa ta huenitaxqui. Nenoma sca tah qui. Neno racanipi jisi benahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yohihi sca botannahue: Mato rihbi canon ta Galilea main Jesus caresscaiqui. Janoxon tah man jaa jistihi, jan mato yohihipi quescabijaquin. Jahuen haxenicabo, Pedro rihbi yohitannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yohihah rahte rahtetax tastahihquish tsahon janinhax picotax bishquihihcanahi bocani. Raquetax tsoabi yohibonahaxma bocani. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hihquipish bi hahan semana pehocohtai neten hihari huenitax roqui María Magdalena qui pari Jesus cainnish. Jaa haibo janinhah roqui siete tiroma yoshin jaan piconish. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Caxon qui jaa Marian Jesus betan nihcahchihibo huinihi huaohihquiton meraxon yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Hahquirihbi ta teehihquiqui. Hen ta hen jistanai —hah qui jan jai bi qui hihcoinai shinanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jaa pecaho roqui huetsapahax sca huetsa rabe qui caini, jemama qui cahiton. Jahuen haxenica rabe. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jaabo rabechin qui caxon texe yohihahbaan bi hihcoinai shinanyamarihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jaa pecaho sca roqui jahuen once qui cainrihbihi pihi tsahotaiton. Hihquipish bi hahquirihbi teehihscai jisxon yohihahbaan bi hihcoinai shinanyamahiboya roqui jato hihti yohiquin, hihcoinai shinanyamahibo copi, jaton jointi chahomahi copi rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—Jatihibi main caxon jatihibi jonibo heen joi siri yohihi botannahue. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nincacoinaiton man nashimahibo tah hen teehihmatihi. Nincacoinyamahibo tah hen casticanyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Heen janen tah man caibaan tiroma yoshinbo picoyaxihqui. Joi behnapan ta caibo yohuanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ronobo bichish bi ta hisinyamayaxihcanihqui. Hahan mahuati paheyahpabo xehahax bi ta hisinyamayaxihcanihqui. Hisinaibo ta mequeman meheyaxihcanihqui rohahahbo. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jato yohi sca jan jaiya qui noquen hihbo Jesus naihohxon Papan bihinihninish, jahuen mecayaho sca tsahonon. ");
INSERT INTO kaqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jaabo sca ta jatihibinco caxon Papan joi haxemacannishqui. Noquen Hihbaan ta jato yanapanquin hahan honantijaxonnishqui, jaabo hihcoinai yohuanai honanahbo.");
INSERT INTO kaqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mihqui tah hen nea joi raanai, señor Teofilon. Neno jenques japahonishquin hihxon hichaxon huishati shinannihbaan bi tah hen hean sca huishaxon mia yohicatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Cristo jomenoni jisnicahboxon ta jahuen joi yohinicabaan noque jaa joi honanmascanishqui, jaabaan jisnixon. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Min honannon hihxon tah hen hean rihbi huishapaqueti shinanai. Neateman pehocohnish rahma caman jenques jaiquin jatihibi honanquin sirijaxon tah hen huishaxon mia yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jenquetsahpa yohuan jacoinnishquin min mian rihbi honancoinnon tah hen nea huishahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea main Herodes quiquin hapo japarihiya ta Zacarías janeya joni janishqui. Noquen Papa noque yocaxonnicah, jahuen joi haxemanicah. Abías baquebo betan teenica. Jahuen haibo ta Elisabet janeya janishqui, yocaxonnica Aaroman chiní baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jaa haibo betan bebo cahen rabebi pontejaquin shinanaibo, Papan yohini joibo nincacoinaibo. Papan yononi quescabijaquin hahcaibo. Jascajati ta jaiqui hihxon Papan yohihi quescabijaxon rabebichin jahua joibi pishinmayamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jascapahbohax bi baquejomabo. Jahuen haibo baqueyosma, yoxaboscai, jaa rihbi yosiboscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Hen mia yohihi quescari jaton coiranti nete nocotaiya cahen Abías baquebo Papan xobo coirani jaax bocani. Jaton tee hahqui jano Zacarías cahi. Papan xoboho hahan hininjati quetejatanhue hahca jano mapescai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chichoxon Zacarías huestichin quetejahiya bi ta jemanhihti janin texe jonibo tsamajaquenishqui. Quetejati hora nocotai quen jemanhihtinin tsinquijaquexon Papa yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Janoxon quetejati janin nihxon sca, Papan yonoti hahqui sanareneni jahui Zacaríasnen jisquin. Jahuen hininjati pataxbi nihrenenai jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jisish rahte rahteti. Hihti raqueti. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","—Raqueyamahue, Zacarian. Min yocacai ta Papan nincaquihqui. Min hahqui baquejaha ta miin haibaan tohoscaxon baque bihyaxihquiqui. Jaa pishca tah min Juan janeyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jaa baque copi tah min jenimayaxihqui, hihti coincoini. Jan cainaiya ta hicha jonibo rihbi jenimayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Papan jisí ta haniscaax shinanya joni sca jayaxihquiqui. Pahe xehayosma. Mae, hompa, jascapa pahebo xehayamaquin. Cainrihyamahiton bi ta Dios Yoshiman jaa hihbojayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jaa copi ta haniscaxon jaan yohihah miin caibaan hichaxon jaton shinan ponteyaxihquiqui, jaton Papa Dios qui hinamehxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jahuen hihbo bebohi ta miin baque nihyaxihquiqui. Elías yamanicaton coshi shinanya ta nihyaxihquiqui. Jahuen yoshin siri Papan Elías hinanni quescajaquin rihbi ta jaa rihbi hinanah jaaya nihyaxihquiqui, jonibo shinan hinanbonahi nichi. Jaton baquebohon shinanahbo jato shinan hinanquin. Hihti sirijaquin shinan sca jaábo nincayosmabo yohibonaquin. Jaton Hihbo nincacatsihquibo jaábo hihxon ta jato yohibonayaxihquiqui —hahquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jascari Papan yonoti yohuani jaiya: —¿Min hihcoinai hen honannon, jahua min hea jismatihin? Jise. Hea tah hen yosiboscai. Heen haibo rihbi yoxaboscai —hahquin Zacaríasnen. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jaatian sca: —Hea tah hen Gabriel qui, noquen Papa Dios bebon nihnicah. Yohitanhue hea Papan jaah tah hen mia yohihi jahui. Jaa copi tah hen mia joi siri yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hen mia yohihah nincahue. Joyo sca tah min jatihi. Hen mia yohihi nocoyaxahnon caman tah min yohuantimacahinscatihi, hen yohihah bi hihcoinai shinanyamahax. Hen mia yohihi quescabi ta jayaxihquiqui, jahuen nete nocotaiya —hihqui Papan yonoti. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías piconon caman jaa manati jemanhihtinin jonibo nichi. Papan xoboho jan basihiya rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jaatian sca picoscai. Picotax bi joyoscai, Jascabi yohuantimacahinxon behantanresquin. Jan behantan behantanaiya ta chichoxon Papan jismaha jan jahuara jisbenanai honanscacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jaa pecaho sca jahuen xobon cati nete nocoscaiya jahuen xobon caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jahuen xobon jan nocotipi pecaho hahbetan hihquish jahuen haibo Elisabet tohoscai. Tohoxon bi pichca hoxne jahuen toho paxajaquin jisyamahabo. Tsoabi yohiyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Papan ta hea hahxonihqui. Jonibo tocan hen hihtimahyamascanon ta jaa queenai tianbi hea hahxonihqui, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jan Elisabet yohiho seis hoxne sca ta Nazaret janeya jema janin sca Papan yonoti canishqui, Papan raanah. Gabriel janeya, Papan yonoti. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jano cahax huesti haibo qui nocoti cahi. María janeya haibo. Bebaan honanahma. Jaa bihyaxihqui joni ta José janishqui, Davidinin chini baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nocoxon sca Papan yonotinin yohiquin: —¿Min jascabi jayamahin, haibon? Mia ta noquen Hihbaan shinanihqui. Mihbetanbi ta hihquiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jan jascahah, haibo rahte rahteti. Jan jascarai jahua hihcatsihquiquin hihqui, jahuen jointi chicho res. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rahtetaiton sca: —Raqueyamahue, Marian, noquen Papa ta mihon jenimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jise. Min tah min tohoscayaxihqui. Bebo baque bihxon sca tah min jaa Jesus janeyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jaa ta shinanya joni hihyaxihquiqui. Papa naihoh quehaton baque tah qui hih ta jayaxihcanihqui. Jahuen xohta yamanica Davidinin jihuetahbo ta Papa Diosen jaa hinanyaxihquiqui, ");
INSERT INTO kaqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","queyotaxma jan jascabi sca judiobaan quiquin hapo hihnon —hahquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jascahah Marian yocaquin: —¿Jenquetsahaxon hen heen bene yamahi bi hen baque bihtihin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jaatian sca: —Dios Yoshiman ta mia hihbojahiqui. Papan coshi shinaman ta mia coiraniqui. Jaa copi ta min bihyaxihqui baque yohihi, Jaa ta Papan baque qui, Diosen baque, hihyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jise. Miin tsabe Elisabet rihbi ta yoxabohax bi tohoyascai qui. Baquejoma hihpahonish bi ta jahuen seis hoxne tohoya sca jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Papan ta jatihibijati hahtipahiqui —María jaquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jascahah: —Hea tah hen qui, hih ca hen jai sen, heen Hihbaan jihuetah. Min hea yohihah quescajaquin jan hea janon —hahquin Marian. Jaatian Papan yonoti caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Papan yonoti jascaripi pecaho Judea main sca histon cacatsihquish María caresscai. Mahchibo jano jaiton cahi, jan honanai jema janin nocoti cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nocotax sca Zacarían xoboho mapeti. Min jascabi jayamahin, tsaben hahquin Elisabet hicotanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Min jascabi jayamahin tsaben hahcai betan bi jahuen xahquin janin jahuen baquexo tehquexihtani Elisabetnin honanquin. Dios yoshiman hihbojaha sca Elisabet coshin yohuani: ");
INSERT INTO kaqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—Hihti hahxon ta noquen Papan mia jaiqui. Miin xahquin janin jai baquexo ta jaan mia hahxoniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Hea jahua que ma bi min heen hihbaan mama hihquish min hehqui jahuin? ");
INSERT INTO kaqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hihcoin tah hen jai. Jise, min hea yohihi hen nincacai betan bi ta coincoinax heen xahquinhoh quehax heen baquexo tehquexihtanaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Noquen Papan mia hinantijaxon yohihipi nincacoinax tah min hihti jenimascatihi —hahquin Elisabetnin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María sca noquen Papa qui siripi yohuani: Mia tah min hihti siri qui, Papan, hih tah hen jai, heen jointiboyabi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Noquen Papa ta hea jihuemanicah qui. Jahan tah hen hihti jenimahi hih tah hen jai noquen Papa yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jahuen hina pishca res hen hihqui bi ta hehon shinanihqui. Hehon shinanxon jan hahxonai copi ta jayaxihquibo yohuancoinsca jayaxihcanihqui. Papan ta jaa hahxonnishqui hih ta jayaxihcanihqui hea yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jahuen coshi shinaman ta hea hihti hahxonihqui. Jaa ta Papa Dios coin qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jan yohihi quescabijaquin non hahcaiboya ta noquehon jascabijaquin Papan shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jahuen mequen siripan hahxonquin ta jahuen coshi noque jismahiqui. Nincayosmabo ta jaan rabinmahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Hani quiquin hapobo namanjaxon ta jaton yohuanbo jato jenebahinmahiqui. Jahuaborabojomabo rihbi ta mehehiqui, hihti meyayahpa quescapahbo sca jaábo. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pihan hihquibo rohahihriscanon jato piti siribo pimaxon bi ta hicha jahuequiyahpabo picatsihcanahabo jato camahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israeli baquebo hahxontijanixon ta jan yohini quescabijaquin noque yanapaniqui, noque jahuen jonibo quen. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham yohinixon ta noquen xohtabo rihbi sca hahxontijanixon jan yohini quescabijaquin hahxonscaiqui, jascabi sca janon hihqui María. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Elisabet janin cahen quimisha hoxnebo sca María jihueti. Janohax res sca jahuen xobon caribiscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jan cahipi cahchiqui sca jahuen tsaben jahuen baque bihresscaquin, bebo baque pishca. Bichish, hihti jenimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hahbe jihuetaibo betan jahuen jenabo rihbi jenimacani. Hahan shinanxon ta noquen Hihbaan hihti hahxonihqui, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Huesti semana huinoscaax jaya jahuen mama, jahuen papa cahi, jahuen jane huishamahi. Janoxon honantijati janin caxon, hahan judiobaan honantijahahbo hihxon jaton baquexo jismaquin. Janohahbaan sca: —¿Jahuen papan janeya janon non Zacarías huishatihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","—Hahyamaquin rahan. Jahuen jane ta Juan qui —hihqui jahuen mama. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Jaa janeya ta miin jenabo yamahihqui, tsoabi —hahscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jaatian sca jahuen papa cohantanquin yocacanquin: —¿Mian min jahua janecatsihquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jahuen papan sca huishaquin hahcajaquin tabla pishca yocaxon bihxon, hahqui huishaquin. Jahuen jane ta Juan qui hahquin huishaquin. Rahte rahtescacani, jan huishahi jane jisish. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jaatianbi jahuen jana choyocahinax Zacarías yohuanscai. —Hahxon tah min hea jai, Papan —hihscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jan yohuanscai nincacax, jaton hahbe jihuetaibo rahte rahtescai. Jenquetsahax jahuen baquexo jaresscaiquin hihquish janohahbo yohuan chanicanahiboya sca Judea mahchi janinbo jihuetaibo jaya res yohuan yohuancani. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chanihibo nincaxon shinancanquin: Hahan Papan shinanai baque tah qui, Jenquetsahpa joni jaa jayaxihquiquin, hihxon shinan shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dios Yoshiman hihbojaha jahuen papa yohuanai joi rihbi nincascacanquin. Jaa Zacarías yohuanni ta nesca qui: ");
INSERT INTO kaqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Hahxon tah min noque jai, Papan. Non tiromabohi copi noque casticanquin mahuamatihi bi tah min noquehon shinanxon hahqui paxacahuanti joni noque hinanscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Neateman miin joi yohinicaton janan min yohuanni quescabihi tah min rahma jai. Davidinin chini baque tah min noque hinanai, quiquin hapoxon noque jihuemahi jan jayaxahnnon tah min noque hinanai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Noquen rahuibaan noque hihbojapanan ta jaan noque xahbanjamayaxihquiqui. Noque jistahihmahibo jatihibi ta jaan pantetihiqui, noque jahuejayamascaábo. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Noquen xohtabohon shinanxon min jato hahxontijani quescabijaquin tah min noque hahxonscai, Papan. Min jato yohini quescabijaquin tah min noque hahxonscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Jaton rahuibo qui hen jato xahbanjamahah ta raquexonma sca miin chini baquebaan hea teexonyaxihquiqui hah tah min noquen xohta Abraham janiqui, Papan, noque yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Jaa yohicoinnixon tah min noque hahxoncoinscai, Papan. Sirijaquin shinanhahnan sca non janon. Tiroma shinanjomabo non jihueti hahtipahscanon. Mahuanoxon caman non jascabi sca mia shinanhahnan jihuenon tah min noque hahxonai, Papan Papa Dios jaxon, jahuen baquexo rihbi sca Zacaríasnen yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Naihoh queha Papan joi yohinica ta mia hihtihi, baquexon. Noquen Hihbo beboxoni tah min nihyaxihqui, jonibo yohiquin shinan hinanbonaquin. Noquen Hihbo nincati shinan jato hinanbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jatohon shinanxon noquen Papan jaton hohcha sohuaxona jahuen baquebo sca jihuenon tah min jato honanmabonayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Noque jisí noque qui botopaquexon ta Xaba Hihbaan noque xabajayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bahquish chian jihuetaibo ta xabajaxonyaxihquiqui. Mahuati qui raqueti jihuetaibo ta xabajaxontihiqui, hahan jihueti bahin sca nichíbo hihqui Zacarías. ");
INSERT INTO kaqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jascapa cainnish cahen jahuen baque hanicahuani. Jahuen shinan caícanahi. Jahuen Hihbaan joi yohiti nete janon caman cahchiho res nichi jihueti. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jaatian ta Cesaro Agostonen jahuen jonibo yohinishqui, jatihibi jonibaan jane huishapaquehahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jascajati jan yohimenoni tah qui, Siria main Cirino jaton tininti hihpahoni tian. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cesaronen jascajaquin yonohah ta jaton jemabo janin jatihibi jonibo bocannishqui, jaton jane huishahahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Galilea mai janinhax José rihbi cahi, Nazaret jema janinhaxbi. Judea main cahax, jahuen xohta Davidinin jema janin nocoti cahi. Jaa jema ta Belen janeya qui. Davidinin chini baquehax copi ta jano canishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tohoyascai jahuen haibo hihyaxihqui ta María hahbetanbi canishqui. Jaan jaa bihyaxihqui copi jahuen jane rihbi jahuen benenahyabi huishahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jano nocoxon Marian jahuen baque jan bihnoxihqui honanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jano jai xobo bocho rahsi jaiya jahuenrahnon hoxatimahiya ganado xobohoxon sca jahuen bihmenohi baquexo bihxon, chopan rahcoxon, vacan piti racanxonti janin racanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jaatian rihbi ta jaa maibo janin carnero coirannicahbo janishqui. Jaton xobo hochó copi ta pastochianxon jaton carnerobo coiranshinacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yame coiranaiton jato qui Papan yonoti cainquihrani. Papan xaba rihbi jato janin xabarenenaiya rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","—Raqueyamanahue. Joi siri mato yohihi tah hen jahui, jatihibichin nincacax jenimahabo. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nea netenbi ta Davidinin jema janinxon huesti haibaan jahuen baque bichishqui, mato jihuemanica coin noquen Hihbo Cristo. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hahan honanti sca tah hen mato yohihi: chopan rahcohah vacan piti racanxonti janin racatai tah man jaa meratihi. Jistannahue —hahquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jaatian sca hahchonquihrani hicha Papan yonotibo sanareneni. Papa qui yohuani siricani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Noquen naihoh queha Papa ta hihti coshi shinanya qui. Nai nequebihahbohon hihti shinanxon ta hahan sirijaquin shinanti shinan jato hinanihqui, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Papan yonotibo naihoh boresscaiboya sca carnero coirannicahbo yohinancani: —Noquen Hihbaan noque honanmaha jisnon bonahue. Belen janin canon bonahue —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bishquihihcanahax sca nocoxon Maríaya José meracanquin. Jisíbo bi vacan piti racanxonti janin baquexo racati. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Honanscaax janohax joquin sca Papan yonotinin noque yohihah tah non jistanai, hihxon sca jatihibi jonibo yohibenacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yohihahbo jatihibi rahtecani. Coirannicahbo yohuanai joi jahua hihcatsihquiquin hihcani, rahtetax. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Rahtetaibaan bi María rahteyamahi. Jaan cahen jahuen jointinin shinanresquin, chanihibo joibo shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jaatian sca coirannicahbo jaton pasto janin nocorihbicani. Noquen Hihbo ta coshi shinanya qui hihcani. —Min noque yohihipi jatihibi tah non jistanahqui, Papan. Min noque yohihipi quescabi tah qui. Hahxon tah min noque jai —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jan cainipi huesti semanan sca honantijamaxon Jesus janecanquin. Jahuen maman xahquinho jahuabi nanéyamaparihiya, Jaa tah man Jesus janeyaxihqui, Papan yonotinin jato jaho quescabijaquin janescacanquin, Jesus janeya janon. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Man baquexo janeho huesti hoxne senennon caman tah man Papan xobo qui samatihi hahquin ta Moisesnin huishanishqui. Jaa copi jascajacanquin. Jahuen hoxne senenscaiya Papa hinani sca baquexoya bocani, Jerusalen janin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Papan joi janin ta jascajati huisha jaiqui: Jahuen maman bihmenoho bebo baque jatihibi yohihi tah man Papanah ta qui hih man jatihi, Papa hinani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Huetsa rihbi ta jaiqui, Papan huishamani: Haibaan baquexo bichipi copi rabe nobex hinanyamaxon rabe coma pishca mohitahpa noquen Papa Dios hinanxon rehtexonquin, hihqui jaa huisha. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jascajati joi copi Jerusalen janin bocani. Jaatian rihbi ta Jerusalen janin Simon janeya joni janishqui. Pontejaquin shinanai joni. Noquen Papahon shinanai joni. Noque jahuen jonibohon shinanxon noque jihuemanica Papan raantihi honancoinax manatai joni. Jaa hihbojaxon ta Dios Yoshiman honanmanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Papan raanai joni jisishma mahuati tah min jatimahi, hahquin Dios Yoshiman. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Papan xoboho sca Dios Yoshiman hihuehah Simon nocoti. Jaatianbi jano Papan huishamani joi jai quescabijahi Jesusen papa betan jahuen mama rihbi jahui, Jesus hihuehi. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jaya mapetaiton sca jaton baquexo bichinxon Simoman hicotanquin. Chihtoxon noquen Papa yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Hihti sirijaquin sca tah hen shinanai, Hihbon. Hea yohinihxon tah min jaabijahi. Mihqui caresscanoxahnpan. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Min raanai noque jihuemanicah tah hen jisresscai, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Jatihixonbi jisíbo hihxon tah min raanscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mia honanyamapahonihxon bi ta nea baque copi noquen nahuabaan rihbi mia honanscatihiqui. Noquen caibo rihbi ta miin joniboxon nea jisish hihti siribohi yohuanyaxihcanihqui, Papan hihqui Simon. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jaton baquexo yohihi Simon jascaraiya jahuen papa betan jahuen mama rahteti. Rahtetaiboya: ");
INSERT INTO kaqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","—Noquen Papan ta matohon shinanihqui —hihxon, baquexon mama bejisahnan sca, jahuen baquexo yohihi yohuani— Jise. Nea copi ta hicha noquen caibo jascabi behnoti sca jaticaniqui. Hicha rihbi ta nea copi jascabi sca jihuetihiqui. Hahqui ta caibo rihbi tiromahi yohuanyaxihquiqui. Noquen Papa hahan honantihi bi tiromabohi yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jonibo jenquetsahpa shinanyahpabohin non honannon ta neatohon noque yohiyaxihquiqui. Mian rihbi tan min jointi machexehxon masa shinanyaxihqui —hihqui Simon. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jano rihbi ta huesti haibo janishqui, Ana janeya. Fanuelnin baque, Aserin chini baque. Papan shinanmahah yohuannica haibo. Xontacohax jahuen bene betan siete bari jihuenish bi jahuen bene mahuataiya yononma sca banenish yoxaboscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ochenta y cuatro bari jai bi sca yoxabohax bi Papan xoboho nihxon bariyahpan, yame rihbi piti tenehahnan Papa yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simon betan nichibo merahax: —Hahxon tah min noque jai, Papan. Jaa jisish tah hen hihti jenimahi —hihqui haibo. Jerusalen janin jihuetaibo sca yohihi cahi. Papan jihuemanica jopahinon hihquish manataibo jatihibi sca ta yohinishqui, Jaa ta jaresscaiqui, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jaatian sca Papan yohinih quescabijaquin queyohax Galilea main sca cahi Jesusen mama betan jahuen papa caribihi. Cahipish Nazaret jema janin jaton xobon nocorihbiscacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jano jihuenish sca jaton baque haniscaax coshiscai. Hihti honan. Hahan Papan hihti shinanai joni. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jatihibi bari tian ta Jerusalen janin jahuen mama betan jahuen papa capahonishqui. Pascua fiesta tian jano fiesta huinoti bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Doce bari Jesus jaiya sca jaabo hihpahoni quescari fiesta huinoti jano bocani. Jaa rihbi jato betan cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Fiesta queyoscaiya sca jaton xoboho jonoxon beribicani. Jema janin jaton baque banetai bi honanaxma jahuen papabo joribicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jahuen chahibo betan jaa rihbi jahui shinanax nihbahinahi becani. Bepi sca jaton baque yamajaxon jato betan jahuibo janin sca benacanquin. Jaton jenabo yocacah bi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Benacasquimahax sca Jerusalen janin benahi boribicani, rabebi. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jano quimisha neten benacasquimacanquin. Benabonaxon sca Papan xoboho haxemanicahbo betan jaa tsahotai meracanquin. Haxemanicahbo yohuanai nincanoxon, jano jaa tsahotai merascacanquin. Hashoan honancatsihquin jato yocarihbiquin. Jato betan yohinani tsahotai. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jan honanxon yohuanquihna haxemanicahbo rahteti. Nincaqui jano tsahotaibo rihbi rahteti. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Papan xobo janin jahuen haxemanicahbo yohuanquihnaiton merahax jaabo rabe rihbi rahte rahteti. —¿Jenquetsahpahin min noque betan cayamahipiquin, baquen? ¿Min honanyamahin? Masa shinanhahnan tah non mia benacasquimahipiqui —hahquin jahuen maman. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Jahua copi man hea benarahsihin, maman? ¿Heen Papan teebo jisti hea jai man honanyamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jascajaha bi jan yohihi jahua hihcatsihquiquin honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jaatian sca Nazaret janin jato betan caresscai. Nococani. Jano jihuescacani. Jahuen papan, jahuen maman yohihah quescabijaquin hahquin. Hicha bari huinoscai bi hen huishaxon mia yohihi jatihibi jahuen maman shinanpariquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jano jihuetax ta Jesus haninishqui. Jahuen shinan rihbi caicanahi. Jano jaibaan jisí ta siri joni jaa janishqui. Papan jisí siririhbihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jasca sca janíbaan ta huetsa quiquin hapo jaresscanishqui, Tiberio janeya. Quince bari sca jaa jaton hapo jaiya cahen jonibo jisxonnicah rihbi jai, jahuen gobernadorbo. Judea main jahuen gobernador ta Poncio Pilato janeya janishqui. Jaatian rihbi ta Galilea main Herodes haponishqui. Herodesnin huetsa Felipe ta Iturea main sca haponishqui. Traconite janinbo rihbi jahuen mai, jaa hihboti. Janohax ta Abilinia janinbo Lisaniasnen hihboti janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas betan Caifas rihbi ta judiobaan quiquin yohuan hihbobo janishqui. Jaabo rahsi hapobo jaiya sca ta jano tsoa jihueyamahi janin jihuexon noquen Papa yohuanai Juaman nincanishqui. Jaa Juan cahen Zacaríasnen baque. Papa yohuanai nincacax jaa joi yohihi sca nichi. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jordan huean janinbo sca nihnichi. Quetanhihnibahinxon quetanpaquebahinrihbiquin. Yohibonahi nichi. —Noquen Papan maton hohcha sohuanon shinan siri sca bihnahue. Shinan behnayahpa man jaiya hen mato nashimanon benahue —Juaman jaquin yohibonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaíasnen rihbi ta Papan joi yohinicaxon jaa yohihi neateman huishanishqui. Jano tsoa jihueyamahi janin tah hen quenahi: Noquen Hihbo hahan jonon bahixonnahue. Pontequin bahixonquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mai xanquen jatihibi tah man bochojabonatihi. Mahchi jatihibi rihbi tah man mapaquin mispanjabahintihi. Mayabo rihbi tah man pontetihi. Xanquen xanquenaibo rihbi sirijabonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jaatian ta Papan raanah jihuemanica joresscai jatihibi jonibaan jisyaxihquiqui hah ta Isaíasnen janishqui huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Isaíasnen jascajani copi ta nashimamahi behibo Juaman yohinishqui: —Papan ta mato casticantihiqui. ¿Tsoan mato Papan mato castanmis yohihah man neno jabaquihrani jahuin, rono papayahpabon? ");
INSERT INTO kaqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Maton shinan pontejacoinax siri shinanya sca jihuenahue hih ca hen jai sen, maton shinan honanahbo. Noquen Papa ta Abraham qui hihyamarihbinahue. Nea macanbo ta Papan jonijati hahtipahiqui, Abrahanen baquebo sca janon, hahan Papa jenimahibo sca janon. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jihui reranoxon hahcajaquin ta jahuen yami bihxon Papan tarescaiqui. Siri bimijomabo tarexon cohaquin hahcajaquin ta tiroma shinanyahpabo Papan casticanscaiqui. Shinannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jascahah yocascacanquin. —¿Hicon nan? ¿Jahueja sca non jatihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yocacahbo sca jato yohiquin: —Rabe cotonyahpaxon cotonjoma joni huesti hinannahue. Pitiyahpaxon, jascajaquin rihbi pitijoma joni hinannahue jan pinon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jaatian sca coriqui cobranaibo rihbi becani. Jaan jato hihquimatanquin nashimanon hihquish becani. Nocoxon sca yocacanquin: —¿Noquen non jahuejatihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Hapon mato yohihi tihi res cobrannahue. Man mahuinmamis —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sontarobaan rihbi sca yocaquin. —Noque rihbi sca yohihue. Sontaroxon non jenquetsahatihin —hahcanquin. —Man tah man tsoabi tahtijaxon jahuabi bichintimahi. Quesaxon bichintimarihbihi. Maton hapobaan mato copijahi res bihxon jaa res bihti shinannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juaman jascajahiya manahihti quenichibo shinamehti: —Jaa tsi ra Papan caisai joni quin —hihcani, Juan yohihi jaton jointinin shinamehti. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jascaraiboya: —Hean hen mato jenen nashimahi bi ta hea mentan hashoan coshi joni jahuiqui. Ni jahuen sapato risbi pecaxonti tah hen senenyamahi jaa hihti siri copi. Jaan ta jahuen yoshin siri mato hinantihiqui chihi rihbi mato maracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chishpo nihuen potanon hihxon bero romishin potaquin hahcajaquin ta Papan xecoscaiqui. Bero rahsi tsamatai tsinquixon sca jahuen bexojati janin niaxon bi ta nocayosma chihin chishpo mapojayaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jascapahbo joibo ta jato hicha yohinishqui, nincacoinahbo. Joi siri jato nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Siri joibo jan yohihi que bi ta quiquin hapoxon Herodesnin bihmaxon sipo xoboho Juan tsahonnishqui. Jascatimahi bi tah min miin huetsan haibo betanbi hihqui, Juaman jaho copi Herodesnin jaa sipo xoboho tsahonquin. Jatihibi jan tiromajaquin hahni Juaman yohiho copi rihbi sipo xoboho tsahonquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hihti tiromaxon bi ta hashoan sca tiromajaquin Herodesnin Juan bihnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jaabi, sipo xoboho Herodesnin jaa tsahonyaxahnon ta Juaman jato nashimapahonishqui, jato nashimanon hihquish hahqui nocotaibo. Jascapahbo nashimaxon ta Jesus rihbi nashimanishqui. Nashimaha ta noquen Papa yocanishqui. Yocacahnan, nai quehpemehtai jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jaton jisnonbi sca naihoh quehax nobex quescapah botopaqueti jahui jisquin. Naihoh quehax yohuanairihbi nincacanquin. —Mia tah min jahan hen queenai heen baque qui. Mihon tah hen hihti jenimahi —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jaa pecaho ta joi siri yohibonahi sca Jesus nihnishqui, treinta bari jaax. Jonibaan jisí cahen jaa Josepan baque. Jahuen chahita cahen Helí. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helí sca cahen Mataten baque. Matat cahen Levin baque. Leví cahen Melquin baque. Melqui cahen Janan baque. Jana cahen Josepan baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José cahen Matatiasnen baque. Matatias cahen Amosen baque. Amos cahen Nahuman baque. Nahum cahen Eslin baque. Esli cahen Nagainin baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí cahen Maaten baque. Maat cahen Matatiasnen baque. Matatias cahen Semeinin baque. Semei cahen Josepan baque. José cahen Judapan baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá cahen Joananen baque. Joana cahen Resan baque. Resa cahen Zorobabelnin baque. Zorobabel cahen Salatielnin baque. Salatiel cahen Nerin baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri cahen Melquin baque. Melqui cahen Adin baque. Adi cahen Cosamam baque. Cosam cahen Elmodamen baque. Elmodam cahen Erin baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er cahen Josuepan baque. Josué cahen Eliezernin baque. Eliezer cahen Joriman baque. Jorim cahen Matatinin baque. Matat cahen Levin baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví cahen Simeonen baque. Simeon cahen Judapan baque. Judá cahen Josepan baque. José cahen Jonaman baque. Jonan cahen Eliaquim baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim cahen Meleanen baque. Melea cahen Mainanen baque. Mainan cahen Matatanen baque. Matata cahen Nataman baque. Natan cahen Davidinin baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David cahen Isaipan baque. Isaí cahen Obedin baque. Obed cahen Boozen baque. Booz cahen Salmonen baque. Salmon cahen Naasonen baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason cahen Aminadab baque. Aminadab cahen Adminen baque. Admin cahen Arnin baque. Arni cahen Esroman baque. Esrom cahen Faresen baque. Fares cahen Judapan baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá cahen Jacobon baque. Jacobo cahen Isaaquen baque. Isaaque cahen Abrahanen baque. Abraham cahen Tarepan baque. Taré cahen Nacoren baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor cahen Seruquen baque. Seruque cahen Ragaunen baque. Ragau cahen Peleg baque. Peleg cahen Eberin baque. Eber cahen Salan baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala cahen Cainanen baque. Cainan cahen Arfaxad baque. Arfaxad cahen Seemin baque. Seem cahen Noeman baque. Noem cahen Lamequen baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec cahen Matusalenen baque. Matusalé cahen Enoquen baque. Enoc cahen Jaretan baque. Jaret cahen Mahalalelnin baque. Mahalalel cahen Cainanen baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan cahen Enosen baque. Enos cahen Setin baque. Set cahen Adaman baque. Adam cahen Papa Diosen baque. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dios Yoshiman shinanyahpahax sca Jordan huean janinhax Jesus cahi. Cahi, Dios Yoshiman jano cahue hahca, jano tsoa jaitonma sca cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta neten jano nihnixon bi ta jahuabi piyamanishqui. Tiroma yoshiman sca ta hohchamacatsihquin tana tananishqui. Jahuen cuarenta neten sca hihti picatsih sca jaiya sca Satanasnen tanarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—Papa Diosen baquexon, toa macan yohihue, piticahinscanon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jascajaha: —Piti res jaax jihuetima tah man jai hah ta Papan janishqui huishamaquin —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jaatian sca queya maniquihnxon bochiquixon sca jatihibi mai janin jai jemabo Satanasnen jismarenenquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Hoa jatihibi ta Papan hea hinannishqui. Queenxon tah hen mia hinantihi, mian sca jato hihbojanon. Jaton jahuabora jatihibi mina sca hihnon. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hea bebon min miin raboxonen nichish betihihpaquexon yocacah tah hen mia hinantihi —hahquin Satanasnen. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jascahah: —Miin Papa Dios huesti tah min yocatihi, jaa huesti qui tah min betihihpaquetihi hih ta Papa jaiqui jahuen huisha joi janin —hahquin Jesusen sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jaatian Jerusalen janin sca Satanasnen hioquin. Jano sca Papan xobo pemacanya Jesus penimaxon: —Papa Diosen baque hihquish nenohax cayahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jahuen yonotibo ta Papan yohitihiqui, mia coiranabo hih ta jaiqui Papan huishani janin. Cayahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jahuen mequeman ta mia bihtihiqui, macan qui min joxcorohyamanon hih ta jaribinishqui jahuen quirica janin —hahquin Satanasnen. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jascahah bi: —Hea cahra hahxoncointihiquin, tanapan hihxon, Miin Hihbo Dios tanayamahue hah ta Papan janishqui —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satanasnen hohchamacatsihquin bi jenquetsahaxon bi hohchamatimahiya sca Jesus jenebahini caresscai, joribiyaxahpan hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jaatian Jesus rihbi joresscai. Dios Yoshiman coshi hinanah, Galilea main sca cahi jahui. Nocotaiya, Papan coshiyahpa ta jaa qui hihqui jano jihuetaibo sca yohuan chanicanahi bocani jatihibi janin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jaton tsinquiti xoboho mapexon ta jato haxemapahonishqui. Jan yohihi nincacax, nea ta Papan raanai joni qui hihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jaa pecaho Nazaret jema janin sca Jesus nocoti cahi, janohax jan hanini janin sca nocoti. Jan japahoni quesca sca tantiti neten jaton tsinquiti xobo janin jato betan tsinquiti cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsinquitaibaan sca noque nincamarohahue hahxon Isaiasnen huishani quirica hinancanquin. Jato nincamanoxon sca nihxon quirica quehpenxon jano nea joi jai benaxon jato nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dios yoshiman ta hea hihquihiniqui. Jahuajomabo joi siri hen yohinon ta hea caisnishqui. Caisnixon ta hea raannishqui, hinábo hen piconon hináboma sca jaábo. Benchebo rihbi hen yohinon ta hea raannishqui hahquirihbi jisti hahtipahabo. Tiroma hihboyahpabo hen piconon ta hea raanishqui, hinábomascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Papan jisí ta rahma jahuen joi siri nincamaha hihti siri qui hahquin jato nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jascajaquin nincamaxon jahuen quirica xehpoxon quirica coiranxonnica hinanrihbihax tsahopaque sca jai. Tsahotaiya jaa bejisi manacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jaatian sca: —Nea hen mato nincamaha joi ta rahma maton nincanonbi jascacoinscaiqui, Papan yohini quesca sca —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jan yohihah nincaquin sirijahax rahte rahtescacani. Papan noque hahxoncoinai joi ta noque nincamahaxqui hihquish rahte rahtecani. Jaatian sca shinanax: —Nea Josepan baquema quin —hihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jascari yohuananaiboya: —Hea rah tah man jatihixonbi hea nescajaquin yohiyaxihqui. Rahomehhue, rahonnican hah ra tah man hea jayaxihqui. Capernaum jema janinxon roqui miin coshiyaxon min jato jenquetsaja ra jaxonipi. Neno miin mainxon sca noque jascajaxonhue hah tah man hea jaribitihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jato jascajaxon jato hihti yohiscaquin: —Jaabi tah hen mato yohicoinai. Jahuen main cahiton ta Papan joi yohinica jahuen caibaan sirijaquin bihtimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hihcoinja tah hen mato jai. Elías yamanica jihueni tian ta basi hoi paqueyamanishqui, quimisha bari seis hoxnerihbi hoi yamanon. Jatihibi janin ta hihti pihaxmahnhuan sca hihcannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hicha maton caibo yononmabo jaatian rihbi janí que bi ta jato qui Papan Elías raanyamanishqui. Jato qui ma bi ta Sarepta jema janin Papan raannishqui, huesti sidono yononma haibo qui caxon piti caijaxonnon. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jascajaquin rihbi ta Eliseo jihuenitian sca hicha maton caibo sipiyahpabo janí que bi jatoma bi Siria mai janinha huesti res Papan rohajanishqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jaton nahua Papan hahxonai nincacax sinacahincani, tsinquiti xoboho jaibo rahsibi sina sinati. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bihtanxon sca jemama qui Jesus bocanquin. Jano jai hani xanquen janin boxon rehtenoxon naman potacatsihquibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Rehtecatsihquibaan bi jato nabebacahini cahax Jesus caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Capernaum jema janin sca cahi, Galilea mai janin. Nocotipixon jaton tantiti neten jato haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jan yohihah nincacax ta rahtecanishqui, shinan hihboxon jaan jato honanmaha copi. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jaton tsinquiti xoboho rihbi ta tiroma yoshinyahpa joni mapenishqui. Jesus yohuanai nincacax coshin sai saihihscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Hahrai! ¿Noque jahuejahi min jahuin, Jesus Nazarenon? ¿Noque queyohi min joresscain? Mia tah non honanai. Mia tah min Diosen baque qui —hahquin yoshinyahpaton. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jascahah bi: —Jascaraxma netetax jaa jenebahini catanhue —hahquin Jesusen. Catanhue hahca yoshiman jaa joni tapon hueranbohanquin, jato tocan racanon. Jahuabi tiromajaxonma sca jaa joni jenebahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jaa jisish raqueya sca hihcani jaa xoboho jaibo rahsi. Raquetax yohinanancani. —¿Jenquetsahpa coshi shinanya jaa jaiquin? ¡Jistan! Jahuen coshiyaxon ta catanhue hahquiqui. Jaan yohihah ta tiroma yoshinbo boresscaiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jaa copi ta jaya joihi hicha bocannishqui, janobo jaibo chanicatsihqui xobo tihibi mapecanahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jaton tsinquiti xobo janinhax sca Simoman xobon Jesus cahi. Nocotaiya bi Simoman haita yona yonati racati. Jaa copi, Rohajaxonhue, hahcanquin, nocoscaiton. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Hihcohax jaa racatai patax nihrenenxon sca jahuen hisin Jesusen yonoquin jenebahinhue, hahquin. Yonohah, yonayamascacahini. Rohascaax huenitax jato pitijaxoni mehca mehcascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bari hihquiscaiya sca jaton hisinyahpabo hihuecanquin. Hihuehibo mehexon sca jato rohajapaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hicha tiroma yoshinbo rihbi ta jaan camanishqui. Jenebahini catanhue jan jaah sai saihihcani. Mia tah min Diosen baque qui hihcahini boresscacani. Jaabo hashoan coshin yohuanpanan ta jato netemanishqui. Jaa Cristo hihqui honanax yohuanaibo copi jato netemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Xaba paque sca jaiya sca jano tsoa jaitonma sca Jesus cahi. Tsamajaquetaibo caxon jaa benabonaxon merahax hahqui nocohihnati. —Noque jenebahini cayamascahue, hihbon. Noque qui banejaquerohahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noque qui banejaquerohahue hahcabo bi: —Huetsa jemabo janin rihbi tah hen Papan joi yohibonahi cati jai, Papan jihuemati joi honanahbo. Jaa copi tah hen jahui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaa pecaho sca judiobaan tsinquiti xoboboho mapecanaxon Papan joi siri jato yohibonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jaatian sca Genesaret hian quexa sca cahax, nihxon jano jaibo honanmaquin. Nincacatsihquish sca tsama jonibo hahqui tsinquijaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nincacatsihquibo tsehquesihquin hueranbonaha jisí bi nonti rabe quexa racatai. Nonti racatai bi yapa rahconicabo yamahi, yapa rahcotani jahuex jaton tarrafa pahtsaqui mapescaibo. Huetsa nonti ta Simomana janishqui, huetsa nonti cahen jahuen companihrobaana. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simoman nontin nanéxon sca: —Napon hori noque hueranbohanhue —hahquin Simon yohiquin. Jaatian sca nontin tsahoxon sca quexa nichibo haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yohuanquin janquenjaxon sca Simon yohiquin. —Nemin janin sca noque hioxon maton tarrafa potanahue, yapa bihnoxon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Pota potashinaxon bi tah non jahuabi bihyamahaqui, maestron. Jaabi, mian yohihah tah hen potahi —hahquin Simoman. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Potaxon sca hicha yapa rahcoquin. Yapa hashoan hichahiya jaton tarrafa huaxacatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mapo behue behuehahxon sca jaton companihrobo quenacanquin, huetsa nontin joxon jato yanapanabo. Joxon rabebi jaton nonti bochojabahincanquin hihquicatsihscanon caman. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yotihi ra jisish raquescaax Jesus bebonxon raboxonen tisquihahpaquexon: —Hea jenebahinhue, Hihbon. Hea tah hen hohchayahpa joni qui —hahquin, Simon Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Huestijaquin potaxon bi yotihi ra yapa bichish Pedro raquescai, hahbe yapa bihnicahbo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeon baque rabe rihbi ta jascarihbihi raquenishqui, Jacobo betan Juan, Simoman companihrobo rabe. Raquescaiboya: —Raqueyamahue, Simoman. Rahma tah min joni bihnicah sca jatihi —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Taxnaxon sca cahen jaton nontibo jatihibi jenebahini sca Jesus manahi sca bocanni. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jaa pecaho sca ta janobo jai jemabo qui nocoti canishqui. Huesti jema qui nocoxon sca sipiyahpa joni behchiquin. Sipiyahpaton sca Jesus merahax taracahpaquexon Jesus hihti yocaquin. —Jeen hihxon res tah min hea rohajatihi, Hihbon. Mian tah min hahtipahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jascajaha, mehexon sca: —Queen ta jai. Rohascahue —hahquin. Jaatianbi jahuen bichi siricahinscai, behna sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—Hen mia rohajaha tsoabi yohiyamaxahtahi min. Min yohimis. Tsoabi yohixonma, sacerdote jismatanhue, Moisesnin yohini quescabijaquin hinanti pishcaya catanhue, rohascaxon hinanti pishca. Jascajaquin tah min jato nincamatihi, jonibo tocan hahquirihbi jihueti hahtipahnoxon —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yohiyamahue hahca bi hashoan sca jonibo yohibonaquin, Jaan ta hea rohajahaxqui hahquin. Jaa copi hihti caibo sca becani. Jesus yohuanai nincanoxon rahomehti becani. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jan cahá cahchiqui nocotahbo jaa huesti Jesus cahi. Jano tsoa jaitonma cahax basihi, Papa yocaqui basihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Huetsa neten sca ta jato haxemaribinishqui. Jato yohihi bi ta fariseoboya jaton haxemanicahbo nocohihnatax nincaqui tsahopaquecannishqui. Galilea mai mehax jahuibo, Judea mai mehax jahuibo rihbi, Jerusalen jema janinhax jahuibo rihbi nincaqui tsahocani. Papan coshiyaxon jan rohajahi sca jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tsinquijaquetaiboya sca jahuen yora honanyamajaquetai joni becanquin. Jahuen cacajatiyaxonbi hihuexon Jesus bebonbi janacatsihquibaan bi joni hichahiya jenquetsahax hihcotimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jenquetsahaxonbi mapematimahiya sca jayabi xobo pemacanya hinaxon xehuabo xecabohanxon jahuen cacajatinin sca rontanpaquebohanxon Jesus bebonbi sca racanpaquecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jan jato rohajaxontihi shinancoinaibohi jisxon, racatai joni Jesusen yohiquin: —Miin hohcha tah hen mia sohuaxonai, hiconin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jaatian jano tsahotai fariseoboya jaton haxemanicahbo jaabo rahsibi yohinancani. —¿Jahua hihqui shinanax Diosihcamahi yohuanihquin? Papa Dios huestichin ta hohcha sohuati hahtipahiqui. ¿Neatohon rihbi hahtipahiquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jaya baxexaibo honanxon Jesusen jato yocaquin: —¿Jahua yohuan man maton jointinin jain? ");
INSERT INTO kaqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jahuemeha hashoan teema yohitihquin? ¿Miin hohcha tah hen sohuaxonai hihqui nan? ¿Huenihihnatax nihaquetanhue hihqui nan? ");
INSERT INTO kaqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jaabi, noquebaque hihxon hen mainxonbi hohcha sohuaxonti hahtipahi honannoxon jisnahue —hahxon sca yora honanyamajaquetai yohirihbiquin: —Mia tah hen yohihi. Huenihihnaxon miin cacajati bihbahini caresscatanhue, miin xobon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yohihah sca jaton jisnonbi huenicahuanxon jahuen cacajati bichish jaya cahi caresscai. Jahuen xobon cahi. —Papa Diosen ta hea rohajahaxqui —hihcanahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nincacax rahte rahtecani. —Papan ta hahxoncoiniqui —hihcani. Caibo rihbi hihti raquetax: —Tsoan jisníma tah non rahma jisiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jaa pecaho sca caxon, tininti cobranxonai joni Jesusen meraquin, Leví janeya. Jahuen janoxon cobranti misa janin tsahotaiton meraquin. Meraxon: —Hehbe cahi johue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jascajaha huenixon jatihibi potabahini cahi, Jesus manahi sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jaatian sca jahuen xobo janin sca hani fiesta hahqui jonon Levin Jesus quenamaquin. Jaan quenamaha hahbe cobrannicabo rihbi hicha jano jai, jaton hahberabetibo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jaabo rahsi jaa manahi tsahotaiya sca fariseobo betan jaton haxemanicahbo reren rerenxon, Jesusen haxematibo cahecanquin. —¿Jahua copi man cobranmisboya hohchayahpabo betan man pihi tsahotain? ¿Jahua copi man jascapa betan xehahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesusen sca jato joi bichinquin. —Hisinjomabo ta rahonnica pishinyamahihqui. Hisinyahpabo caya rahonnica pishinih. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pontebo quenahima bi ta pontemabo quenahi hea joníqui, shinanquin pontejahabo —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jaatian: —Juaman haxenicabaan ta hicha piti tenehiqui. Hicha rihbi ta Papa yoca yocacaniqui. Fariseobaan haxematibaan ta jascajaribicaniqui. Minabaan ta jascajayamacaniqui. Minabaan ta pipi pipixon xeha xehacaniqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—Jaton huetsa huanomahi caxon ta huanomahanan piti tenetima jacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Huetsa tian ta jaton huanomati yamascatihiqui, Papan jato bichinah. Jaatian pari ta benáxon piti teneyaxihcanihqui —hahxon, honanahbo hihxon sca jaa patax queha joi jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nescajaquin jato yohiquin: —Chopa payo honacatsihquin tah non hahan honanoxon hotsihahma chopa behna non teque huaxayamahi. Behna chopayaxon honanoxon non huaxahah ta behna chopa tiromascatihiqui. Payo honahah bi ta behna hotsihax chopa payo betan senenyamarihbiscatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noquen xehati behna rihbi tah non xeni bichi borasa qui non bochojayamahi. Non bochojaha bi ta pahescaxon borasa pohtoshihmahax noquen xehati yohyocohtihiqui, noquen borasa rihbi tiromascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Xehati behna tah non hestenica borasa behnabo qui bochojati jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Xehati pahe xehahax tah non bata queenyamarihbihi. Pahe ta nohuepihqui hihquish —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jaatian sca tantiti neten sca bahin cahax trigo huai nabebacahini cahi. Hahbetan caquin, jahuen haxenicabaan huestibo bero tesabonaxon, bishqui bishquihahxon xocaxon picanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jascajahiton fariseobaan jato yocaquin: —¿Jahua copi man jascajahin, tantiti neten non piti tsinquitimahi bi? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesusen sca jato yohiquin: —¿Papan joi jisquin man Davidinin hahní honanyamahin? Hahbetan cahibo picatsihquiya jaa rihbi picatsihquish, ");
INSERT INTO kaqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Papan xobo janin hihcoxon Papa jismanoxon pejanxonti paan hinanah bihxon, pixon, hahbe nichibo rihbi jan hinanni man honanyamahin? Jascapa ta tsoanbi pitimahiqui, Papa yohixonnica huestichin ta jaa piti hahtipahiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sirijaquin yohiquin sca jato yohirihbiquin: —Hea ta hen noquebaque qui, tantiti nete hihbo —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Huetsa tantiti neten rihbi sca jaton tsinquiti xoboho mapexon jato haxemaribiquin. Huesti meyosma joni rihbi jano tsahoti, mecayaho jahuen mequen yosmahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tantiti neten ta rahonnicabaan tsoabi rahontimahihqui, tantiti netenbi jaa rohajatihiquin hihxon ta jaton haxemanicahbo betan fariseobaan jisisnishqui. Hahan cahenoxon jisiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jahua yohuan jaabo rahsi jaiquin jahuen jointinin honanxon ta jaton nincanonbi meyosma joni sca yohinishqui: —Huenihihnatax naponbi nihhue —hahquin. Jascajaha huenihihnatax jato tocanbi nihrenenscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Reren rerenaibo sca Jesusen yocaquin: —¿Tantiti neten non siribojaxontimahin? ¿Tantiti neten non tiromajatihin? ¿Joni huetsa non tantiti neten jihuematihin? ¿Non mahuamatihin? Hea yohinahue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jato jispaquexon meyosma sca yohiquin: —Miin mequen sanahihnihue —hahquin. Yohihah mehanscaax rohacahinscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Roha sca jaa jai bi jano tsahotaibo sina sinati. Jesus qui yohuan yohuanscacani, jahueja non jaa jatihin, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jascaripish noquen Papa yohihi sca mahchi manichi Jesus cahi. Yametai bi janoxonbi Papa Dios yoca yocashinaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xabacoscaiya cahen jahuen haxenicabo quenascaquin. Hahqui jahuiton doce res caisxon: —Mato tah man heen raantibo qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jan caisni ta neabo qui: Simon, jahuen jane huetsa cahen Pedro. Jahuen huetsa Andres rihbi, Jacoboya Juan jaabo rabe rihbi, Felipe, Bartolomé. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Santiago Alfeon baque, Simon Zelotes hahcaibo ");
INSERT INTO kaqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Santiagonen baque, Judas Iscariote, jaabo rahsi. Judas Iscariote cahen Jesus paranxon judiobo ");
INSERT INTO kaqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jato betan botoquihrani jahuex sca mai mispani janin nihrenenai bi hicha haxehibo becani. Nincaqui becani, hihti caibo. Jaabo cahen Judea mai mehax behibo, Jerusalen janinhax behibo. Tiro jema janinhahbo, Sidon jema janinhahbo, quebijistima hian quexa jihuetaibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesus nincacatsihqui jahuibo, rahomehti jahuibo. Caibo rihbi tiroma yoshinbaan hihbojani bi becani. Jascapahbo rihbi ta Jesusen rohajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesus mehehax jahuen coshin rohahibo rahsibo quen jano jaibo rahsichin jaa mehecatsihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jato honanmaxon bejisquin sca jato yohiquin: Jenimanahue jahuaborajomabon. Papan ta mato jihuematihiqui. Mato cah man jahuen jihuetahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jenimanahue pihan hihquibon. Man tah man yaniyaxihqui, rohahihrichi. Jenimanahue huinihibon. Man tah man coin coini bitsayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jonibaan mato jistahihmaha jenimanahue. Mato yohuanquihnyamascaxon bi mato roa roahahbo bi jenimanahue. Man hea nincacoinai copi maton janeya tiromahi yohuanaiboya jenimarihbinahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mato jascahibaan bi hihti coincoinnahue. Jaton xohtabaan ta Papan joi chaninicabo jascajaribinishqui. Naihoh sca ta janoxon mato hinantibo Papan mato hicha bexojaxonihqui. Jaa copi jenimanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jascapahbo hahan jenimati jaibo bi ta hicha coriquiyahpahax man ¡Hahrai! hihyaxihqui. Maton jahuaboraya jenimati shinanxon bi tah man jahuabi hashoan bihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rahma yanitax bi tah man Hahrai hihyaxihqui hihti pihaxmahhuan hihquish. Rahma bitsatax bi tah man Hahrai hihyaxihqui bena benatax huaohihquish. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jatihibi jonibo mato qui siripi yohuanaiya Hahrai hihnahue. Papan joi yohihihcamahi quesahiboya ta maton papabo jato qui jascarihbihi siripi yohuanpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mato tah hen yohihi, nincanahue. Maton rahuibohon shinannahue. Mato jistahihmahibaan bi jato sirijaquin hahxoncoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mato roahibaan bi jato qui Papa yocaxonnahue. Mato tahtijahibaan bi jato yocaxonnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mia copasah bi copixonma ramiqui sca jismahue. Miin coton mia bichincatsihquiya jaa hinanax miin camiseta rihbi yohuashihyamahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mia yocacaibo jatihibi hinanhue. Mia bichinai bi bichinyamascahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hea hahxoncanpahinon hih min jain, jato pari hahxonhue, min jato hahxonai quescajaribiquin mia hahxonnon. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Matohon queenaibohon tah man copinani queenai. ¿Jaa copi man shinanyahpabo hihqui man shinanain? Nincayosmabo rihbi ta jascanica qui, jatohon queenaibohon queeni copinani. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","¿Caibaan rihbi mato siribojaxonah, copinanquin sca jato siribojaxonquin bi man jaa copi hicha shinanyahpabo man jihuetai man shinanain? Nincayosmabaan rihbi ta jascajanica qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","¿Jan mato hinanrihbitihi honanxon man joni huetsa coriqui hinantahbax man jaa copi shinanyahpa sca jain? Nincayosmabaan rihbi ta hahbe nincayosmabo hinantahbahiqui, jatihibi bihribiyanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jaabo jascahi bi tah man maton rahuibohon man shinantihi. Jascapahbo siribojaxonnahue. Hinantahxon bihribiti masa shinanyamanahue. Naihohxon sca ta Papan mato hinanrihbiyaxihquiqui, hashoan hicha sca. Bihribiti shinanxonma hinantahbax tah man noquen naihoh queha Papan baquebo jihuetihi. Jaan rihbi ta jahuen sinatahbohon shinanihqui, jahuen tiromabohon bi shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yomanahtaibohon shinannahue, maton naihoh queha Papan hahcai quescajaquin. Hohmis hohmisaibohon bi maton naihoh queha Papan jatohon shinanquin hahcai quescajarihbinahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Min hahcai quescajayamaquin bi jaan hahcai quescajaquin joni huetsan jahuaborajahi jisish, Jahuejanoxon jascajahiquin, tiroma joni tah qui hihyamanahue. Jaatian ta mato rihbi Papan jascajayamayaxihquiqui. Caibaan mato tiromajanih bi jaa tiromani shinanyamanahue, maton Papan rihbi man tiromani shinanyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pishinaibo hinannahue, maton papan ta mato hinanrihbiyaxihquiqui. Yohuashihxonma ta tasa bochojaxon bishtaxpaquexon tsahonpaquexon shaconxon hahquirihbi matsanhihnixon mato hinanrihbiyaxihcanihqui. Hinannoxon man toponai quescabijaquin ta maton Papan mato hinanrihbiyaxihquiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jato jascajaxon jaa patax queha joi sca jato nincamaquin. Benchen ta hahbe benche bahi jismatimahiqui. Jismacatsihqui bi ta mai xanquen qui rabebi paquetihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Haxenica ta jahuen haxemanicah mentan hashoan honan hihyamahiqui. Sirijaquin haxemaha pari ta jahuen haxemanicah quesca sca jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jenquetsahaxon min miin bero janin jihuihhuan jaxon bi miin huetsan bero qui jai poto pishca min yohitihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Miin bero janin jihui jaxon jenquetsahaxon sca min miin huetsa yohitihin, Miin bero janin jai poto pishca hean tsecanon tenehue huetsan, hah min jatihin? ¡Quesan! Miin bero qui jai jihui pari tah min potatihi. Jaatian pari tah min jisquin sirijaxon miin huetsa bejistihi, jahuen poto bero pishca tsecanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jihui siribo ta bimi tiromayahpa yamatihiqui. Jihui payo rihbi ta bimi siriboya jatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jenquetsahpa jihui hin hihxon tah non jahuen bimi jisxon jatihibi jihui honanai. Moxayahpa jihui queha tah non pama tsinquitimahi. Moxayahpa yora quiha rihbi tah non xexon bihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Noquen jointi janin siri shinanbo jaiya tah non siri yohuan noque jai. Jascarihbihi tah non tiroma jonihax noquen jointi janin tiroma shinanboya tiroma yohuan rihbi jai. Noquen jointi janin jai shinanboya tah non yohuanai. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Hen jahuejanon hihxon man hea Hihbon Hihbon hahcain, hen mato yohihah hea nincaxonma bi hea quenaquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hehqui joxon hen yohihi nincaxon jaabijaquin hahcaibo rahsi jenquetsahpabo hin hihxon tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jascapa hihquish tah min xobojahi joni quesca qui. Xobo jihuibo nichinnoxon ta nincacoinnicaton nemin pari mai poquinihqui, minquex mai qui nocoxon xobo jihui nichinnoxon. Jaatian ta jenehhuan joxon mai mahpobahinxon bahiquin xobo bocatsihquin bi hahtipahyamahiqui, sirijaquin jan xobo jihui nichinai copi. ");
INSERT INTO kaqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hen yohihah nincaxon bi hahyamahi joni ta mashin xobojanoxon bemacanya poquinxon jihui nichinai quescapah qui. Jenehhuan joxon maimahah ta xobo paquerestihiqui, jenen huaxa huaxascanon —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jato nincamaquin queyohax sca Capernaum jema janin cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jano ta huesti sontaro capitan rihbi jihuenishqui. Hahan jan hihti shinanai jahuen joni jai bi jaa jahuen joni hisini. Mahuati hisini racati. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesus nocoscai chanihi nincaxon jahuen joni rohajaxoni Jesus jonon hihxon judio hapobo sca raanquin yohitannahue hahxon. Raanah bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesus qui nocoxon sca hihti yocacanquin. —Jaa hahxonrohahue, Hihbon. Nahuahax bi ta siri joni qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Noquen caibohon ta queenihqui. Noquen tsinquiti xobo rihbi ta jaanbi noque hahxonnishqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jascajaha jato betan Jesus cahi. Capitanen xobo qui nocoti cahiboya sca capitanen raanah caibo sca jato behchihi jahui. Behchixon yohicanquin: —Hehon shinanax bi paxquini hocho joyamahue, Hihbon, hih ta jaiqui, Hihbon. Hea ta hen jahuama qui. Heen xobo janin mia hihquiti tah hen senenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jaa copi tah hen heabi mihqui cayamahaqui. Jano xonbi yohireshue. Min yohihah ta heen joni rohaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hen tah hen honanai. Hean rihbi tah hen heen hapon yohihah hen hahcai, heen sontarobo rihbi tah hen jai, hean yonohibo. Hean cahue hahcá ta catihiqui. Huetsa rihbi cahen johue hahca jahui. Nescajahue hahca cahen hean yohihi quescajaquin, hih ta jaiqui, Hihbon —hahcanquin yohixonquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitan yohuanai chanihahbo Jesus rahteti. Janobi rabejaquexon chibanaibo sca yohiquin: —Mato yohinon nincacoinnahue. Jascapa nincacoinnica tah hen ni huestibi Israeli baquebo merayamanihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jesusen yohihah sca ta capitan janin boribixon jahuen joni rohascai meracannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hoxashinahax mohiyahtax res sca ta Nain hahcaibo jema janin Jesus cahi canishqui. Jahuen haxenicabo betan hicha jonibo rihbi Jesus manahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jema xehqui qui nocoti caquin sca tsahoni jahuibo behchicanquin. Mahuatipi hiabenahibo behchicanquin. Jaa huesti jahuen baque mahuatipi quen cajon hiacaibo jahuen maman chibanbenaquin. Jahuen bene yamahi, yononma. Jema mehabo rihbi hicha jaa manahi becani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yononma jisxon hahan shinanxon: —Huaohihyamahue —hahquin noquen Hihbaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yohixon caxon sca cajon mehequin. Jan mehehiya hiacaibo janobi nihreneni. —Beronan. Mia tah hen yohihi, huenihue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jan yohihah mahuatipi tsahohihnascai. Tsahohihnatax yohuanscaiya jahuen maman bihnon: —Miin baque bihhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hihti rahte sca jacani. —Papan ta noque hahxoniqui. Jahuen joi nincamanica janon ta noque quiha huesti Papan caisnishqui —hahcanquin, Jesus yohihi. —Noque jahuen jonibohon ta Papan shinanihqui —hihcanahi boribicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yohuanchanicanahiboya sca ta Judea mai janinhahbaan jatihixonbi nincanishqui, chanihahbo, jaa senenbi jihuetaibaan rihbi nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juaman haxenicabaan rihbi Juan yohiquin. Nincaxon rabe jahuen haxenica Juaman raanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Noquen Hihbo yocaqui cahábo hihxon jato raanquin. —¿Hoa jahui joni Papan noque yohini mia quin? ¿Jo hen jatiquin huetsa, non mananon? hahquin yocatannahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jaan raanah cahax nocoxon yohicanquin. —Nashimanica Juaman ta noque raanaxqui non mia yocanon. ¿Hoa jahui joni Papan noque yohini mia quin? ¿Jo hen jatiquin huetsa, non mananon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jaton jisnonbi sca hicha hisinaibo jaan rohajaquin. Hohmis hohmisaibo rihbi rohajaxon tiroma yoshiman jatsanjahibo rihbi rohajaquin. Hicha benchebo rihbi rohajaquin, jisíbo sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jaatian yocacaibo sca jaan yohiquin: —Man jisxon nincacah Juan yohitannahue. Benchebaan ta jisresscaiqui. Chantobo ta nihresscaiqui. Sipiyahpabo ta siricahinscaiqui. Pabebaan ta nincascaiqui. Mahuatipibo ta jihuerihbiscaiqui. Jahuaborajomabaan ta joi siri nincaquihqui, hahquin yohitannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hen yohihi nincacoinaibo ta hahan jenimati jaiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan yohihi boressca jaiboya sca Juan tsoa quin honanahbo hihxon tsinquijaquetaibo noquen Hihbaan yocaquin: —¿Jahua jisí man jano tsoa jihuetaitonma caniquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tahua huesti nihuen xayanai nan? ¿Jahua cahran man jisi caniquin? ¿Chopa siri sahuehi joni nan? Hihti siri chopayahpabo tah man hapobaan xoboho pari man meratihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jahua cahran man jisi caniquin? ¿Papan joi yohinica nan? Jaa rahan. Mato yohinon nincanahue. Yohinica res ma bi ta yohinica mentan hashoan coshi joibo jaa jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hahqui ta huishacannishqui: Jise: Mia bebon canon tah hen heen raanti joni raanai. Mia ta bahi bexojaxoni catihiqui mia hahan canon hih ta jaa yohihi Papan joi janin jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nincanahue, hen mato yohinon. Juaman yohihi joi mentan hashoan siri joi yohiti ta tsoabi yamahihqui. Papan jihuetahbo res ta jahuamahax bi Papan jihuemaha hashoan siri joi yohiti jaiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jan yohihi nincacax Juaman nashimanibo sca: —Papan ta noque hihti hahxonihqui —hihscai. Coriqui cobranxonaibo betan tsinquijaquetaibo jascacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseobo betan jaton haxemanicahbo jascayamahi. Juaman jato nashimati queenyamanish, rahma Papa queenai quescajati rihbi queenyamarihbicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Rahma jihuetaibo ¿jenquetsahpabo quin? Jahua quescapahbo hin hen mato yohinon nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mato tah man baquebo jaabo rahsibi shirohi quescapahbo qui, notsi notsihi nescari yohinanaibo: Man bairahnon hihxon non rehue hahcai bi tah man bairahyamahi. Non huinihah bi tah man noque betan huaohihyamahi hihqui ta notsihi quenananiqui. Jascapahbo tah man qui, rahma jaibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Joxon ta piti siribo Juaman piyamanishqui, xehati rihbi xehayamaquin. Jan piyamahiya tah man hahqui yohuanpahonihqui, tiroma yoshinyahpa tah qui, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hea sca joxon tah hen pixon xeharihbihi. Hen jascajahiya tah man Hoa pihanhuan jisnahue. Xehanhuan tah qui. Coriqui cobranxonnicahbo ta jahuen hahberabetibo qui. Hohchamisbo ta jahuen hahberabetibo qui hih tah man janiqui, hea yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tsoa ponte shinanyahpa quin hihxon ta jenques jihuetihquin hihxon jisxon pari non honantihi hih ta jacanihqui. Jascatihi bi tah man hehqui yohuanresai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jaatian sca: —Heen xobo janin pihi canoxahnhue —hah huesti fariseo jonin sca jaah, jano cahax mapetax Jesus hisquen racati, pinoxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jaa jema janin rihbi huesti hahresti haibo jai. Fariseonen xobohoxon Jesusen pihi honanax jahui, pomo xecobenahi. Jahuen hahan hininjati rahoya pomo. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mapetax Jesus cahchiqui nihrenenax jahuen tahe quiri cahcopaquetax huaohihqui. Huaohihqui bi jahuen bero jenen jahuen tahe qui toisihqui. Jahuen boon sca tasoxon, tahe qui tatsohahxon jahuen hinintinin jahuen tahe hininjaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jaa jisish, jahuen jointi chicho fariseo yohuanscai: —Papan joi chaninicaxon ta neatohon honanquehanihqui. Hoa haibo jenquetsahpa quin, jenquetsahpaton mehehiquin hihxon cahen honanquehan, hohchayahpa haibo can —hihqui jahuen jointinin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Fariseo jascaraiton sca: —Mia ta pishca yohicatsihqui, Simoman —hahquin Jesusen. —¿Jahua hin, maestron? Hea yohiroahahue —hahscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Coriqui jan jato hinantahni cahen rabe jonibaan jaton patoro ribinnish. Huetsan cahen rabe bari teexon copijati ribinish. Huetsan cahen rabe hoxne teexon copijati ribinnish. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Copijati hahtipahyamahiboya cahen jaton patoronen jato Jascabi sca janon, jenenahue hahcan. Jato jascajaquin hahxonah sca jahuemeha hashoan jahuen patorohon queennishquin? Yohihue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Hean shinanah ta hoa hashoan ribinpahoni hashoan rihbi sca jahuen patorohon queennishqui —hahquin Simoman. —Hihcoini. Pontejaquin tah min shinanai —hih sca Jesus jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Haibo jisxon sca Simon yohirihbiquin: —Nea haibo jise. Miin xoboho mapetaiton tah min hea tachoquiti hinanyamahahqui. Neatohon caya jahuen bero jenen hea tacho tachoxon jahuen boon sca hea tasohihqui. Mapetaiton tah min hea mehuetanyamahaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Neatohon ta hihcoxon tahe qui hea tatsohahquin jeneyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hahan boo masquiti min hea jahuabi hinanyamahah bi ta neatohon hea hahan hinintinin tasquihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaa copi tah hen mia yohihi, jahuen hohcha hichahi bi tah hen jatihibi sohuahi, jan hihti queenscanon. Non hichatahma sohuaxonah ta hichatahma rihbi noquehon queencaniqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Haibo sca yohiquin: —Miin hohcha tah hen sohuaxonai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hahbetan pihi tsahotaibo sca jaton jointi chicho yohuani. —¿Jahua hihxon hohcha sohuaxonti jaan shinanihquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jascaraiboya bi haibo yohirihbiquin. —Hen mia hahxontihi min shinancoinai copi ta miin hohcha yama sca qui. Sirijaquin shinani sca cahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Janohax cahax res sca janobo jai jemabo janin caxon joi siri Jesusen jato yohiquin. Hani jemabo, hanitahma jemabo, jatihibi janin Papan jihuemati joi jato nincamaquin. Jahuen doce haxenicabo rihbi jaa manahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Haibobo rihbi jan rohajaho jato betan bocani. Tiroma yoshiman jispahoni haibobo rihbi jan rohajaho jato manahi bocani. Huetsa cahen María Magdalena, siete tiroma yoshiman hihbojani bi jaan rohajaha rohascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Huetsa cahen Juana, Cusan haibo. Jaa Cusa ta Herodesnin tininti hihpahonnishqui. Huetsa rihbi cahen Susana. Huetsa haibobo rihbi cahen hicha. Huaiyahpaxon jato pitijaxonai haibobo. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jemabo janinhax jonibo hahqui tsinquijaqueti nocoscaax hichascaiton sca ta jaa patax queha joi jato nincamanishqui. Nescajaquin jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jahuen huai banahi cahen huesti joni canish. Jahuen huai chianxon sca bero romishin banaquin mihsahahbonaquin. Mihsahahbonahah cahen caibo bero bahinbi paqueti, jahuibaan jamabonascanon. Hihsabaan rihbi joxon topibonaquin queyoquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Caibo bero rihbi cahen chahoma main paqueti. Jaabo cahen joconax bi bemacanya hihquish xanahi pehuacanascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Caibo bero rihbi moxa bero tocan paqueti. Moxa bero betanbi joconax bi hanihiton moxan sca rishquiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Caibo bero rihbi siri main paqueti. Jaabo cahen joconax, hanihax bimihi, hichahi. Huesti bero potaho joconax bimiyahpascaax cien beroyahpascai. Berotihibi jascari —hahquin. Jaa joi jato nincamaxon coshin sca yohiquin: —Hahan nincati pabinquiyahpaxon nincanahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jaatian jahuen haxenicabaan sca yocaquin: —¿Jahua noque haxemacatsihquin min jascarain, Hihbon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—Papan jihuemati jenquetsahpa quin man honannon hihxon tah hen jaa patax queha joi yohihi, caibaan honannonma hihxon. Jisxon bi jisyamahabo hihxon. Nincaxon bi nincayamahahbo hihxon tah hen jascapa yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","Nea tah qui. Jaa bero ta Papan joi qui. Jonibo cahen bahinxon nincacaibo. Nincascaibaan bi ta nincacoinax Papan baquebo sca jamis hihxon tiroma yoshiman jato jaa joi bichinihqui jaton jointi janin yamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Chahoma main paquetaibo ta joi siri nincacax coin coinxon bichibo qui. Bemacanya jaton tapon jai quescaxon ta basima tahni bichipixon jenebahinaibo qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Moxa chian paquetaibo ta nincacoinaibo qui. Nincacoinxon bi ta huetsa shinanbo rihbi sca bihcaniqui, masa shinantibo, jahuabora tsamanti shinanbo, mai mehabo costan costanti shinanbo. Jascapa shinanbo jointi qui bochohax ta shinan siri caitimahiqui, jahuama quesca sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Siri main paquetaibo ta sirijaquin bihxon nincacoinxon jeneyamahibo qui. Jascapah ta bimi hichayahpa qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tsoanbi tah non johue quetejaxon quentipan sca mahpobahinyamahi. Quetejaxon tah non tapo naman rihbi tsahonyamahi. Jahuen tsahonti janin caya tah non johue tsahonai, jahuibaan sca jahuen xaba jisnon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Man jonexon hahcai ta janibi sca Papan yohipaqueyaxihquiqui. Jan yohiyamaxihqui ta yama qui, jonexon hahcaibaan bi. Jaan honantima jonexon hahcai ta yama bi res qui. Jatihixonbi honanahbo sca ta jonexon hahcaibo jaan yohipaqueyaxihqui, jahuabi jone yamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jaa copi nincacoinnahue. Nete queyoscaiya ta nescajayaxihquiqui: Papan hinanah min jaiya ta hashoan sca jaan mia hinanyaxihquiqui. Jaan hinanah bi min yamahiya ta min jai pishca rihbi mia bichintihiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jaatian jahuen mama betan jahuen huetsabo nocoti jahui. Joxon bi jonibo tsamataiya Jesus yohuanquihnti hahtipahyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Caibo sca chanihi jahui. —Miin mama betan miin huetsabo ta jemanhihtinin nichiqui. Mia ta jiscatsihcanihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jasca jaiboya sca: —Hean yohihi nincaxon hahcoinaibo ta heen mamaya heen huetsabo qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Huetsa neten sca ta jahuen haxenicabo betan nontin naneti canishqui. Nanexon sca: —Hian pohquejaquenahue —jato jaquin. Pohqueti caquin hoque quexa sca chibibonacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nihuen xotonah sca pohquecanahi cahi, pohquecanahi cahi, nontinbi sca Jesus hoxascanon. Hian naponbi sca nihuehhuan jato qui paqueti. Behchoman bochojaha nonti hihquicatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesus qui caxon sca mohinxon: —Hihbon. ¡Non tah non hihquiscai, Hihbon! —hahcanquin. Huenicahuanxon sca nihueya behchonbo yohiquin. Tantinahue jan jaiya tanticahinscai. Jahua nescascai. Jaatian hahbe cahibo sca: ");
INSERT INTO kaqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—¿Man nincacoinyamabiresain? —hahquin. Jaabo rahte rahtetax yohuan yohuanaiton jato jascajaquin. —¿Jahua joni cohren jaa quin? Jaan yohihah ta nihuen rihbi nincaquihqui. Jaan yohihah ta behchoman rihbi nincaquihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jaatian sca nocotax Gadara main sca taxnacani, Galilea mai hoque quexa. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bototax mapescaiton sca jaa behchihi yoshinyahpa joni jahui, janohahbaan caibo. Tiroma yoshiman hihbojani cahen basi sca chopanma nihpahonish. Jahuen xobon jihueyamahi. Tsahon tocanbo cahuan cahuanresi. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus nocotai merahax bishquihihanan sai saihihonahi jahuex raboxonen nichish betihihpaqueti. Coshin sai saihihqui. —¿Hea jahuejahi min jahuin, Jesusen? Mia tah min naihoh queha Diosen baque qui. Mia tah hen hihtí yocacai. Hea tiromajayamahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","—Jaa joni jenebahini catanhue, tiroma yoshiman —Jesusen jaah sca yoshin jascari sai saihihqui. Hicha coti jahuen yoshiman yahtanxon bohá cahen basi sca jaa joni hohmis hohmispahoni. Cadenanen menexxon tanexxon coiranabaan bi cahen cadena tesabahinax jano tsoa jaitonma jabapahonnish, yoshiman jatsanjahah. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jascapa hihqui bi Jesusen yocaquin. —¿Mia min jahua jane quin? —hahquin. —Hea ta legión qui —hihqui. Jaa janin hicha yoshin nocohihnaxon hichaxon hihbojani cahen jaa janeya janish. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Picotax botannahue hahcá sca hihti yohiscacanquin yoshinbaan: —Noquen quininhuan janin, jano Diosen noque potayaxihqui janin noque potayamahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jano rihbi cochi repinica jai, pihi manichi hichahi. —Hoa cochi qui non canon yohirohahue —hahcanquin yoshinbaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","—Botannahue —hahca sca jaa joni jenebahini bohax cochi qui sca hihquihi bocani. Yoshin jato qui hihquihah sca mapoho rocohihcanahi cahi, jene qui paquetax hahsacani cochibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jascahibo jisish cochi coirannicahbo jacahini caresscai. Caxon jema janin jihuetaibo yohi yohixon hocho jihuetaibo rihbi nincamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yohihah sca jisi becani. Jahua jaaxquin hihquish becani. Jesus qui nocoxon sca jaa patax tsahotai jaa joni meracanquin, jahuen yoshin tiroma yamascai. Chopayahpahax res sca sirijaquin shinani tsahotaiton meracanquin. Jaa jisish rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Raqueya sca jaibo bi caibaan sca jan rohajahi jisxon yohirihbicanquin: —Jascajaquin ta yoshinyahpa joni rohajahaxqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jaatian tsinquijaquexon Gadara janinbo jihuetaibaan sca Jesus yohiquin, Noque jenebahini catanhue, hahcanquin. Hihti raquexon Jesus camati shinanxon jascajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jaatian nanetax cacatsihqui bi yoshin tiroma potamaha joni rihbi hahbetan cacatsihqui. —Hea rihbi hiohue —hahca bi jeenhahyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Miin xobon caxon Papan mia hahxona jato yohihue —hahquin. Jascajaha jatihibi janin sca yohibonahi cahi, Jesusen ta hea rohajahaxqui, hihcanahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hoque quexa Jesus nocotaiton sca janohahbaan johue hahquin sirijaquin. Jaa joti manarahsihibaan jaa bihquin sirijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jaatian jaton tsinquiti xobo hihbo jahui, Jairo janeya. Jesus bebon miracahpaquexon, Heen xoboho johue, hihxon hihti yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jaa huesti jahuen baque haibo hisinai quen hihti yocaquin. Doce bari jahuen baque jai mahuacatsihscai. Jeenhihquish hahbetan caresscai bi jonibo hichahi. Tsinquitax hueranhahnanax Jesus qui tsehquesihcanahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jaatian jano rihbi huesti haibo jai, hisinax jahui. Doce bari sca jimi pota potahi haibo. Tsoanbi jaa rohajati hahtipahyamahiya, hahchon nihxon Jesusen coton quexa mehequin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mehehax rohacahin sca jai, jimi tanticahinscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—¿Tsoan man hea mehehahquin? —hahscaquin Jesusen. —Hen tah hen hahyamahaqui —hahcaibo rahsi jaiya sca Pedronen yohiquin: —Hichaxon ta mia tejabohanxon mia tsahca tsahcahahbonacaniqui, maestron —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Tsoan rah ta hea mehehaxqui. Heen coshi hahqui cainai tah hen honanahqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Joneti hahtipahyamahax, raqueyahax saqui saquihihquish, jahuex jaa bebon raboxonen nihxon sca, Hisinnixon tah hean mia mehehahqui, Hihbon, hahquin haibaan yohiquin sirijaquin. Jatihixonbi nincanon sca yohiquin, jan rahma rohacahinscai yohiquin sirijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Shinancoinax copi tah min roha sca jai, baquen. Jascabi roha sca jahue —hahquin Jesusen sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jaa jan jascajaquin yohiparihiya bi tsinquiti xobo hihbo yohihi jahuen joni nocoti jahui. —Miin baque ta mahuascaaxqui. Noquen haxemanica jatsanjayamascahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jaa yohihi nincaxon tsinquiti xobo hihbo jisanan: —Masa shinanyamahue. Shinancoinreshue. Roha ta jatihiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jahuen xoboho mapexon sca hahbe nichibo Jesusen mapemayamaquin. Pedro, Juan, Jacobo, xontaconen papa, jahuen mama, jaabo rahsi res hahbetan hihcomaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Texe jano tsamataibo cahen jaya huinihi. Jaya huaohihqui. —Huaohihyamanahue. Mahuatihma bi ta hoxaresiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jascajaha bi xontaco mahua sca jai honanxon Jesus hosancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Xontaco mehuetanxon sca coshin yohiquin: —Huenihue, baquen —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jahuen yoshin joribiscaax xontaco huenicahuanscai. —Piti hinanhue, jan pinon —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jahuen papa betan jahuen mama rahte rahteti. Jenquetsahaquin rohajahaxquin yohiyamahahbo sca jahuen papaya jahuen mama hihti yohiquin: —Tsoabi yohiyamanahue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jahuen doce raantibo sca quenamaxon cahen coshi shinan jato hinanquin. Jatihibi tiroma yoshinyahpabo rohajati, jatihibi hisin rihbi rohajati coshi hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hinanxon Papan jihuemati joi yohihahnan hisinaibo rohajabonanon hihxon jato raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Jaya catibo bichishma botannahue. Mepiti tah man botimahi, borasa boyamaribiquin. Ni piti ni coriqui boyamaribiquin. Rabe cotonya rihbi tah man catimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xobon mato mapemaha janobinahue. Caribinoxon caman tah man jaa xoboho hoxatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mato mapenahue hahyamahiboya tah man jaton jema potabahini caquin sca maton sapato qui hueotai jaton mai poto jato qui tahabahintihi, nincayosmabohi honanahbo hihxon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Cahax sca jema tihibi qui nocoxon Papan joi siri yohihahnan hisinaibo rohajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes janeya quiquin hapo sca caibaan yohiquin, Jasca roqui Jesus jaiqui hahquin, jatihibi yohixon. —Caibaan shinanah ta Juan mahuanish bi jihuerihbiscaiqui —hihquiboya caibo sca: ");
INSERT INTO kaqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","—Elías yamanica rah ta noque qui caini joribiscaiqui —hihcani, Jesus jaa hihqui shinanax. —Neateman jihuepahonish bi teehihribiscai Papan joi yohixonnicah ra tah qui —hihqui caibo rihbi sca. Jascapa nincaxon Herodesnin masa shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","—Juan tah hen textenihqui. ¿Nea yohihibo Jesus jahua joni jatihiquin? ¿Jenquetsahaxon hen jaa jistihin? —hihxon shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesusen raanipi hahqui beribixon sca jaabaan caxon hahtanipi jatihibi yohicanquin. Jato canon benahue hahxon sca jaabo rahsibi sca hahbetan canon Betsaida jema janin jato hioquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jahuen bocanaxquin honanax texe rihbi jano bocani. Nocotaiton jato Benahue hahxon Papan jihuemati joi Jesusen jato honanmaquin. Hisinaibo rihbi rohajaquin jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bepiscaiya jahuen raantibo joxon yohicanquin: —Nea jonibo camahue, Hihbon, nenobo jai jemabo janin caxon huaiyahpabo janin rihbi caxon jano hoxati sca benahahbo. Jano jaton piti benahahbo. Neno ta jahuabi yamahihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jascajahahbo bi: —Maton caya jato piti hinannahue —hahquin. —Noque tah non piti yamahi. Pichca paan pishca, rabe yapa rihbi, jaa res. Jahua hashoan tah non yamahi. ¿Yotihixon piti marohi non catihin? —hahcanquin. Cinco mil bebobo jano jai quen jascajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","—Cincuentabo rahsi tsahojaquetannon jato mitsahohmanahue —hahquin jahuen haxenicabo. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yohihah sca jascajacanquin mitsahohmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jaton pichca paanya rabe yapa bihxon sca nai bejisihnixon Papa yohixon tehcaxon jahuen haxenicabo metisahpaquequin. Hinanah, jaabi rihbi jonibo sca hinanpaquecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bihxon yaninoxon caman jatihixonbi picanquin. Pixon bi texejaribicanquin. Yapaya paan tequebo piquin texejahiboya sca doce tasa bocho tsinquirihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jaa pecaho sca Papa yohihi jaa huesti cahiya jahuen haxenicabo sca hahqui bocani. Noco sca jaiboya sca jato yocaquin: —¿Hea jahua joni hihqui shinancaniquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Mia roqui Juan yamanica qui, hoa nashimapahoni. Caibaan shinanah cah min mia Elías yamanica. Caibaan rihbi jisí cah min neateman japahoni Papan joi nincamanicah, hahquirihbi teehihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—¿Maton shinanah cahran? ¿Hea tsoa quin? —jato jaquin. —Mia tah min Papan raanai qui, min jotihi jan neateman yohini tah min qui —hahquin Pedronen sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Tsoabi jascajaquin honanmayamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hicha pari tah hen teneti jai, noquebaque hen jai copi. Hapobo rihbi ta Jaa ta tiroma qui hihyaxihquiqui, hea yohihi. Jaton haxemanicahbaan rihbi ta jascajaribiyaxihquiqui. Jascajaxon ta hea rehtescayaxihcanihqui. Rehtehipibaan bi tah hen quimisha neten hihquish hahquirihbi teehihtihi —jahuen haxemanicabo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jano jaibo rahsi sca yohirihbiquin: —Hehchon jocatsihxon tah man matobi man queenaima sca man hahtihi. Hea rehtehibaan bi tah hen heen Hihbo jenetimahi hihnahue nete tihibi. Jaatian tah man heen jihuetahbo jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mahuati qui raquetaibo ta mahuatihiqui. Jascapa jihuetimahi bi ta hea copi mahuataibo queyoyamanox manatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Nea mai jatihobi hihbojahax bi mahuatax sca jahuaya man banetihin? ¿Jaabiyahpa queyoscaxon man jahua jatihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hea hihbomacatsihyamahibo tah hen noquebaque hihxon Mia tah min henama rihbi qui hah hen jatihi. Heen joi qui hihtimahpaibo rihbi tah hen jascajatihi. Coshi shinanya joxon tah hen jascajatihi, noquebaque hihxon. Papan xabaya joxon, hicha naihoh queha yonotibo rihbiya joxon tah hen jascapa jascajatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hihcoinja tah hen mato jai. Caibo neno nichibaan tah man mahuaxonma Papan jihuemati man jistihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jato jascahipixon ocho netebo hihxon Pedro, Juan, Jacobo jaabo quimisha hioquin. Papa yohinoxon mahchi janin cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Janoxon Papa yohihahnan sca jahuen bemanan huetsapahcahini. Jahuen chopa rihbi pehnecahini, cana bacahi quescapi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jaatian rabe joni hahbetan yohuani sanareneni jahui, huetsa cahen Moises yamanica, huetsa cahen Elías yamanica. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jaabo rabe rihbi xabayahpahax hahbetan yohuani. Jerusalen janin jan mahuayaxihqui yohuancani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yohuan yohuanaiboya bi Pedro jaabaan hoxan hihxon bi tenexon jahuen xaba jisquin. Hahbe yohuanai xabayahpa rabe rihbi jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yamanica rabe caresscacatsihquiya sca Pedronen Jesus yohiquin. —Noque neno jaah ta siri qui, maestron. Quimisha tapasnonhue, mina huesti, Moisesnina huesti rihbi, Eliasnena huesti rihbi —hahquin, jahua yohuanti honanxonma jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro jascari yohuanaiya bi nai cohiman jato mahporenenquin. Cohiman mahpobahinah raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jaatian cohiman mehax yohuanai sca nincacanquin: —Nea ta hen caisni heen baque qui. Jaa nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jascari yohuanai nincaxon jisibaan bi Jesus huesti sca jai. Jascapa jisipixon bi ta tsoabi yohiyamacannishqui. Jisyamahicamacani. Chiní sca ta yohicannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jaa mahchi janinhax bototipish hoxashinahax mohiyahtax cahiton sca jato behchihi tsama jonibo becani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jato tocan huesti joni coshin yohuanhonahi jahui. —Maestron, mia tah hen hihti yocacai. Heen baque jisxonhue. Jaa huesti heen baque tah qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yoshiman hihbojaha ta sai saihihcahinax jomi jomihax bacox jancharahihquiqui, hihbon. Jenexonma ta yoshiman rishqui rishquihihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jahuen tiroma yoshin potamaxonnahue hen jaah bi ta miin haxenicabaan hahtipahyamahipicanaxqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—¡Nincacoinyosmabon! ¿Jenquetsahpahi man shinancoinyamahin? ¿Jahuentiho basi hen mato betan hihquiya pari man pontetihin? ¿Jahuentiho basi cahran hen mato teneti jain? Miin baqueya johue —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jan jaya jahuiyabi yoshiman sca main hueranbohanxon jomimaribiquin. Jascaraiton sca yohixon tiroma yoshin jenemabahinxon: —Nea ta miin baque qui, bihhue —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jan jascajaxonai jisish rahte rahtecani jano jaibo jatihibi. —¿Jahuentiho coshi Papan shinanyaxon noque hahxonihquin? —hihcani. Jan jato hahxonai jatihibi jisish rahte rahtetaibo rahsi. Jaatian sca jahuen haxenicabo jaan yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Hen mato yohinon nincaquin sirijanahue. Jaabaan hea jahuejara janon ta jonibaan hea bihmayaxihcanihqui. Jaabaan hea bihti ta hochomascaiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jan yohihah jahua hihcatsihquiquin cahen honanyamacannish. Jaton jointi xehpotaiya cahen honancasquimacannish. Jahua hihcatsihquiquin hihxon hihbo yocatihi bi yocati qui raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jaa pecaho sca jaabo rahsibi yocacahanani. Tsoa non hashoan hapotihin hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jaton jointi chicho yohuanaibo joi honanxon, jano nichi baque pishca bihxon jaa pataxxon jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Nea baque pishca heen janen bichi jonin ta jascajaquin hea bichiqui. Hea bichi jonin ta hea raanni rihbi bichiqui. Mato tocan hashoan hahxonnica joni ta hihti shinanya joni qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","—Maestron, tiroma yoshinbo miin jane yohixon camahi joni tah non jisiqui. Jaa tah non Jascajayamahue hahbenanai, jan noque betanbi nihyamahi copi —hahscaquin Juaman. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jascajaha: —Jascapa panteyamanahue. Mato panteyamahibaan ta mato yanapaniqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jahuen Papa qui cati hochoma sca jaonahiya sca Jerusalen janin cati shinanax, jano res cahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jano jan nihnoxihqui janin pari canon, jonibo raanquin. Jaan raanah bocani. Samaritano jema qui nocoscaxon noquen hihbo jano hoxati benaxonabo bi jano hoxati hinancatsihyamacani, samaritanobo. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jerusalen janin jan cahi honanax jano hoxamati queenyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jano nocoscaxon jascapahbohi jisxon rabe jahuen haxenicabaan yocaquin: —¿Naihoh quehax jato qui chihi paquexon jato queyobahinti non Papa yocatimahin, hihbon? —hahquin Jacobo betan Juaman. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jato qui rabejaquexon: —Hahyamaquin rahan —hahxon pontequin jato hihti yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yohiquin sirijaxon jaa jema huinobahini caresscaax cahi. Huetsa jema qui sca nococani. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Janohax boribicani. Huinotaiton sca huesti jonin Jesus yohiquin: —Jano mia cahi tihibi tah hen mia manahi catihi, miin joi yohinicanoxon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jascahiya: —Caman hinobo ta jaton mai quini jaiqui. Pehiyahpabo rihbi ta nahayahpa qui. Hea noquebaque tah hen jascayamahi. Hea noquebaque tah hen jahuenbi hoxati yamahi —hahxon, huetsa sca yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","—Heen joi yohinicanoxon hehbe johue —hahquin. Hehbe johue hahcá bi: —Heen papa pari hen mihintahyaxahnnon, hihbon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Mahuataibaan hahbe mahuataibo mihinnon jenehue. Papan jihuemahi joi yohibonahi cahi johue mia —hahscaquin noquen Hihbaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Huetsa sca yohuani: —Mihbetan tah hen catihi, hihbon. Heen jenabo pari hen yohitannon manatahhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jaa sca yohiquin: —Miin tee queyoyamaxon bi min japahoni janin sca miin shinan camahax tah min Papan teexonnicah mia jatimahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jasca jaipixon sca huetsa jonibo sca joi yohibonatannahue hahquin. Jascajaxon setenta raanquin, rabe rabe bohábo hihxon. Jano jaabi nocoyaxihqui xobo jatihibi qui canon jato raanquin, jano jan nocoyaxihqui jema tihibi. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jato raannoxon yohiquin: —Banaho huai johuescaax tsinquiti hicha jai bi ta teexonnicahbo huestibohiqui. Jaa copi huai hihbo yocanahue, tsinquixonnicahbo jahuen huai chian jan raannon. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jistahi man. Hinobo tocan man carnerobo canon quesca tah hen mato coiranhanan raanai. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Coriqui boyamanahue. Ni borasabi, ni sapatobi, boyamanahue. Bahin caxon jonibo behchixon yohuanquihnxonma huinóbahintannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Xobo qui nocoxon tihibi, Papan hahxonah man neno jascabihi jayamahin, hahnahue sirijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mato sirijaquin bichiboya ta man yohihah quesca sca Papan jato hahxonyaxihquiqui. Mato sirijaquin johue hahyamahiboya ta man jato sirijaquin yohiyamahah quescatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mapetax tah man jaa xoboho sca jihuetahtihi. Jano jihuetahxon jaton piti mato hinanahbo pinahue. Jaton xehati xehaquin. Teexonnicah copijaha tah qui. Jaa copi jatona pinahue. Xobo tihibi tah man piquin betsatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jemabo janin rihbi nocotaiton mato sirijaquin benahue hahca jaa xoboho hoxanahue. Mato hinanai pitibo pinahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jano jaibo rohajaxon, Papan mato jihuemati ta nocoscaiqui, jato janahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jemabo qui nocotaiton bi mato benahue hahyamahiboya tah man jaton jemanhihtibo janin nihxon man yohitihi: ");
INSERT INTO kaqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Noquen tahe qui hueotai mai poto tah non mato qui tahabahinai man jascapahbo copi. Jaabi honannahue. Papan jihuemati ta hochoma sca jaonahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mato tah hen yohihi. Casticanti neten ta sodomitobo Papan casticanai mentan hashoan coshin jaton jema jaan casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Hahrai hih tah man jayaxihqui, corazino jonibon! Jascarihbi tah man jayaxihqui, Betsaida jonibon. Mato tocanxon heen coshiyaxon hen hahní quescajaribiquin hen Tiro jema janinxon hahcaiya cahen neateman jaton hohcha copi benaxon hahan benati chopa sahuehax chihi mapo mapocohtax tsahoxon jaton shinan pontehan. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tiro joniboya Sidono jonibo jan casticanyaxihqui bi ta hashoan hihtijaquin sca Papan mato casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Capernaum jonibon! ¿Naihoh jihuetax quescari man maton jema janin siripi jihueti shinanain? Maton jema ta maton tsahon baneyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jascajaxon jahuen raantibo yohirihbiquin: —Man yohihah nincacaibaan ta hea nincaquihqui. Man yohihah bi nincacatsihyamahibo ta hea rihbi nincacatsihyamahiqui. Hea nincacatsihyamahibo ta hea raanni heen papa rihbi nincacatsihyamacaniqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Raanah, botanipish, jahuen setentabo jenimahonahi beribicani. Nocoxon: —Yoshinbobi tah non miin janen yonohipiqui, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—Naihoh quehax cana bacahihcamahi tah hen Satanas potahah paquetai jisniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nincanahue. Hean raanah caquin man rono jamabahinti coshi tah hen mato hinanipiqui. Nibo jamabahinti rihbi. Satanasnen yoshinbaan mato jahuejati hahtipahyamanon tah hen mato coshi hinanipiqui. Ni jahuatohonbi ta mato tiromajatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tiroma yoshinbo man camati hahtipahi bi tah man jaa copi jenimatimahi. Naihohxon maton jane huishá sca jai copi jenimanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jato jascajaxon Dios Yoshiman hahan jenimati hinanah hihti jenimaxon noquen Papa sca yohiquin: —Hahxon tah min hea jai, Papan. Mia tah min naiyahpa mai Hihbo qui. Shinamanhuanyahpabo betan honanbaan honancasquimanon tah min jato pantexon, miin baquebaan sca honannon min jato honanmahi, Papan. Mian jisí jascapa siri quen tah min jascajaxonai, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Papan ta hea jatihibi hinanihqui. Jahuen baque tsoa hin ta tsoanbi honanyamahihqui. Papa huestichin ta honanihqui. Tsoa heen Papa quin tah hen jahuen baque hihxon hea huestichin hen honanai. Caibaan ta honanyamahihqui. Hean yohihah res ta caibaan rihbi honanscaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jascaxon jahuen haxenicabo rahsi sca yohirihbiquin: —Man jisibo jisish jenimanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Man rahma jisi ta Papan joi yohixonnicahbo betan quiquin hapobo hichaxon jiscatsihxon bi hahtipahyamacannishqui. Man nincacai ta nincacatsihxon bi nincayamacanpahonishqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jaatian nihxon judiobaan haxemanicahton jenquetsahaxon yocaxon non Jesus tiromahi yohuanmatihin hihxon yocascaquin: —Maestron, ¿jenquetsahax hen queyoyamanox manatihin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—¿Papan joi janin jahua huisha jaiquin? ¿Jahua min jano jisin? —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jaan yocacah sca: —Miin Hihbo Diosohon tah min miin jointiboyabi queentihi, miin yoshinboyabi, miin coshiboyabi, miin shinanboyabi tah min jahan queentihi. Mihbe jihuetaibohon tah min queenrihbitihi, miabi min queemehti hihqui quescarih —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Hihcoini. Jihuenox hihqui jascahue —hahscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jascajanicah sca jan hihqui Jesus shinanmacatsihxon sca Jesus yocarihbiquin: —¿Tsoa heen hahbe jihuetahbo quin nan? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","—Nesca tah qui. Huesti joni cahen Jerusalen janinhax Jericó jema janin cahi cahpaquehti. Cahiton sca cahen tiromabaan bihxon jahuen chopa bichinxon, rishqui rishquixon hahan mahuati tsehueya sca potabahincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sacerdote huesti sca jano huinoti jahui. Bahin joxon jahuen caibo jano miracahtai merahax tecayacahini caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levito baquebo huesti sca jascarihbihi, jahuen caibo. Jano nocoxon merahax tecayacahini caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samaritano huesti sca hocho quehax jahui, jahuen nahua sca. Hahqui nocoxon jahan shinanxon bihtanxon, rahonquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Olivo bimi xeniya vino rahojaxon jayaxon jahuen tsehue rahonquin. Jahuen cabacho cahracanxon sca jano hoxati xobo janin sca hioquin. Janoxon sca rahonxon coiranshinarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Xaba paque sca jaiya sca rabe neten teexon cananai tihi coriqui hinanxon sca xobo hihbo yohiquin: Jaa hea coiranxonhue. Jaa coiranquin min hashoan sca coriqui castanaiya tah hen joribixon mia copijatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jascajaquin yohixon sca Jesusen yocaquin: —Yometsohbaan tsehuejaha racatai qui cahen quimisha joni nocoti. Mian shinanah, jahuemeha jahuen hahbe jihuetah quesca janishquin? Hea yohihue —hahquin haxemanica yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Hoa jahan shinanxon hahxonai rahan —hahscaquin. —Mian rihbi jascajatanhue —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Janohax Jesus, jaabo, boresscaax huetsa jema janin nococani. Jano cahen Marta janeya haibo jihuenish. Jaan Mapehue hahquin jahuen xobon Jesus mapenon. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jahuen shara rihbi cahen jano jihuepahonish, María janeya. Jesusen haxemahi nincacatsihqui cahen jaa patax tatsahoxon jan yohihi Marian nincaquin sirijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jahuen tee hichahiya Marta tee teeti. Piti qui jaa mehca mehcatai bi Marian nincaresquin. Martan sca yocaquin: —¿Hea huesti hen tee teenon heen sharan hea yanapanyamahi min jisyamahin, Hihbon? Yohihue, jan hea yanapannon —hahquin Martan. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Hicha tah min masa shinanai, baquen. Miin tee hichahi tah min jatsanai. ");
INSERT INTO kaqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Huesti shinanyati ta jaiqui, Papan joi nincati res. Marian ta sirijaquin shinanax nincati queenihqui. Jan queenai ta tsoanbi bichintimahiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Huetsa neten sca cahen huetsa janin caxon janoxon Papa yocanish. Papa yocaquin queyoscaiya huesti jahuen haxenicaton yohiquin: —Juaman ta jahuen haxenicabo Papa yocati haxemanishqui, Hihbon. Jascajaquin rihbi noque haxemahue, non Papa yocanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Haxemahue hahcá jato haxemaquin nescajaquin: —Papa yocacatsihquin nescajanahue. Papan, mia Papa Dios jai honanahbo jahue. Miin jihuetahbo non janon noque hihbojahue. Min naihoh hahcai quescajaribiquin neno rihbi hahhue. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nea neten piti noque hinanhue, Hihbon. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Noquen hohcha sohuahue. Mihqui non hohchani min shinanyamascai quescajaribiquin tah non joni huetsa tenexon noque qui tiromahibaan bi jato sirijaquin yohuanquihnai. Jascajaquin rihbi noquen hohcha sohuaxon jaa shinanyamascahue, Papan. Satanasnen noquen coshi tanatihi janin noque hioyamahue, Papan. Satanas noque bihmayamahue hahquin yocanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jascajaquin haxemaxon sca jato yohiscaquin: —Mihqui nocotaibo pimacatsihquish rah tah min yame pochinicon miin huetsan xobo janin caxon min yocatihi: Huetsan, quimisha pichanti pishca hea hinanhue, huetsan. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Noquen jenabo ta hocho quehax jahuex hehqui nocotaxqui. Jahuabi tah hen jato pimati yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chichoxon sca cahen mia yohihan: Hea jatsanjayamahue. Heen xehpoti tah hen moa xehposcai. Heen baquebo rihbi ta moa hoxascaiqui. Mia hinantihi bi tah hen picotimahi ¿hah mia jatihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nincatahi man. Mia jahuen huetsa que bi hinanti queenyamaxon bi ta min hihti yocacai copi mia hinantihiqui, min yocacai tihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Man honannon hihxon tah hen mato yohihi. Papa yocanahue. Mato ta hinantihiqui. Benanahue. Papan ta mato meramatihiqui. Xehpoti ton ton hahnahue. Papan ta mato quehpenxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yocacai tihibichin ta bihtihiqui. Benahi tihibichin ta meratihiqui. Ton ton hahcai tihibi ta mapetihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Miin baquebo mihqui caxon min mishquitanai yapa pishca mia yocacah bi min rono hinantihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Hatapa bachi yocacah bi min nibo hinantihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Honannahue. Tiromaboxon bi tah man maton baquebo qui siribo hinanti honanai. ¿Man yocacah maton naihoh queha Papan hashoan rihbi sca jahuen yoshin siri mato hinantimahiquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Huetsa tian sca ta yoshiman bihni joni rihbi jahuen tiroma yoshin camaxon rohajanishqui. Tiroma yoshiman hihbojaha joyo sca banenish. Joyo banenish bi jahuen tiroma yoshin camaha yohuanscai. Jan yohuanai jisish rahte rahtecani tsamajaquetaibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Caibo rihbi hahqui yohuani: —Quiquin yoshin Beelzebunen coshi hinanah ta tiroma yoshinbo camahiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Caibaan rihbi sca jahuen coshi tanacatsihquin: —Miin naihoh queha coshin hahxon noque jismahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yocacahbo bi jaton shinan honanxon Jesusen jato yohiquin: —Jahuen jihuetahbo jaabo rahsi bi rehtenanaiya ta hapon yonoti queyotihiqui. Jaton caibo betan rehtenancanahibo ta queyonicabo qui, jahuabi yamascanon. Jaa copi honannahue. Satanasnen ta jahuentianbi jahuen hahbe yoshin tiromabo picotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanas hahbe Satanas betan rehtenanxon cahen jenquetsahxon bi sca jahuen yonotibo yonoyamahan. Jascama ta qui. Satanasnen coshiyaxon hen tiroma yoshinbo camahi hih man jai copi tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Tiroma yoshiman coshiyaxon hean tiroma yoshinbo camahi man jaiya, jahuatohon cahran maton baquebaan jato camahiquin? ¿Jenquetsahpa shinanya man quin? Jaabaanbi ta mato yohiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Papan coshiyaxon tah hen hean yoshinbo camahi. Jaa copi honannahue: Papan jihuemati nete ta mato qui noco sca jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nesca tah qui, jisnahue. Coshi jonin cahen jahuen toohahtiyahpaxon jahuen xobo coiranan. Coiranah cahen jaho jaibo tsoanbi meheyamahan. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hashoan coshi joni pari joxon ta xobo hihbo bihxon jahuen toohahti bichinnica qui, jayaxon coiranti jaa xobo hihbaan shinanah bi. Jahuen jahuaborabo rihbi bichinxon ta jahuenahbi jahuen jonibo qui sca jaan metisahpaquenica qui. Jascapah tah hen qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hehbe hihyamahax tah man henaboma qui. Hea tsinquixonyamaquin tah man jabismahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tiroma yoshin ta joni jenebahini cahax jano jahuabi jaitonma cahax jano jihueti benahi cahuan cahuani caxon bi merayamahax janohax hen jahui janin caribitanpan hihcahini cahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Caxon ta matso siri sca jahuen xobo merascaiqui, bexojaxonah sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jaatian ta caxon hashoan tiromabo hahbe yoshin rihbi benatihiqui, siete hahbe yoshinbo. Jatihibi sca jahuex ta jaa jonin jointi janin sca jihuetihiqui. Jaa copi ta jaa joni hashoan tiromacanahi sca jatihiqui, hicha yoshiman hihbojaha sca. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jato jascajaquin yohi yohihiya sca ta tsinquijaquetaibo tocanxon huesti haibaan coshin yohinishqui: —Mia baquexo bihni haibo ta hihti jenimati jaiqui. Mia chocho hahmani ta hihti jenimati jaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jascajaha sca: —Jaama bi ta Papan joi nincaxon bihcoinaibo caya, hahan jenimati jaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hihti caibo sca nocohihnataiya jato yohiquin nescajaquin: —Rahma ta jonibo shinan tiromayahpabo qui. Non mia nincanon hahan honanti noque jismahue hah tah man jai. Man jascarai bi ta huestijaquin res hahan honanti Papan mato jismatihiqui, Jonas janí quescapah res tah man jistihi, jaa jisxon honanti. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonas jisxon ta ninevitobaan honannishqui. Jaa Jonasbi ta hahan honanti janishqui. Jascapahribihi tah hen hea noquebaque hahan honanti qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jonibo casticanpaqueti nete noco sca jaiya ta chiponquiha quiquin hapo yamanica nihxon rahma jai jonibo yohiyaxihquiqui: Mato tah man nincayosmabo qui hahquin. Jaa ta hocho quehax jonishqui, shinanyahpahax Salomon yohuanai nincaqui jahui. Salomon hihpahoni mentan hashoan coshi shinanya rahma neno jai bi tah man nincacatsihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Papan casticanti neten ta Níneve jema janin jihuepahonihbaan mato metoyaxihquiqui, Jonasen yohihah jaton shinan pontenihxon. Mato tah man noque mentan hashoan nincayosmabo qui. Jonas mentan hashoan nincati jonin mato yohihah bi tah man nincayamanihqui hah ta jayaxihcanihqui, mato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tsoanbi tah non johue quetejaxon joneyamahi. Quetejaxon tah non quentipan mahpoyamarihbihi. Quetejaxon tah non jahuen tsahotinin tsahonai mapetaibo rahsichin jahuen xaba jisnon. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Noquen yoran johue ta noquen bero qui. Miin bero siripaiya tah min xabapan nichi. Miin bero tiromahiya tah min bahquish chian nichi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jistahi man. Maton shinan janin xaba jai man shinanah bi bahquishcahinmis. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Miin shinan xabayahpa hihquish, jahuabi miin shinan bahquishihyamaha tah min sirijaquin xabajaxonah sca min jatihi, johuepan xabajaha quescapi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jascajaquin jan yohihiya, fariseo jonin sca: —Heen xobon pihi cahue —hahquin. Jascahah hahbetan cahax mapetax pihi tsahopaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Piríyamahax jan mechoquihyamahi quen fariseo rahteti. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Rahtetaiton: —Mato fariseobaan tah man chichoma maton tasonbo rahchoxon maton platobo rahchocai. Maton jointi nahpamehtan; jano tah man tiroma shinanbo bochohi, yometsohti shinanya hihti tiromabo shinanbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¿Maton mequen mato hinanxon maton jointi rihbi Papan mato hinanyamanishquin, honanmabon? ");
INSERT INTO kaqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Maton jointiboyaxonbi jahuaborajomabo yanapancoinnahue. Jaatian tah man jahuabi sca rishtaya hihqui man shinanyamascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Hahrai! hih tah man jatihi, fariseobon. Maton haxe pehi romishin tah man texe Papa jahuena hinanxon, cahua meso rihbi texe pishca hinanxon, huai bimi rihbi texe hinanxon bi Papan yohihi quescajati man pishinmahi. Joni huetsa yanapantihi bi tah man tiromajahi. Joni huetsahon shinanti Papan mato yohihah bi tah man hahyamahi. Man hinanaibo Papa hinanquin jenebahinxonma caibo rihbi yanapantihi bi tah man hahyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Hahrai! hih tah man jayaxihqui, fariseobon. Tsinquiti xobo janin tah man hapobo tsahotai janin tsahoti queenbiresai. Jemanhihti janin tsinquijaquetaibaan mato saludanti rihbi tah man queenyorahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Hahrai, hahrai! hih tah man jayaxihqui. Mato tah man tsahonipibo quescapahbo qui. Tsahonipi maníxon bi tah non jenquetsahpa pisi chicho jaiquin non honanyamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Noquen Hihbaan jascajaquin yohihiya sca Moisesnin joi haxemanica huesti jano tsahoxon yohiquin: —Maestron, jascajaquin yohiquin tah min noque rihbi cahehi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","—¡Hahrai! hih tah man mato rihbi jayaxihqui, haxemanicahbon. Jonibo hihuehhuan papima papimaquin hahcajaquin tah man joi tsamanxon jato yohihi. Yohixon bi tah man maton metotinin bocabi mehexon jato yanapanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Hahrai! hihnoxihnahue. Maton papabaan ta Papan joi yohinicabo rehtepahonishqui, maton sca man Papan joi yohinicabaan tsahon qui tsahonxobojanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jascajaquin tah man maton shinanbo noque jismahi. Maton papabaan hahpahoni quescajaribiquin tah man shinanai. Jaabaan rehtenihbo tah man maton sca man tsahonxobojaxonai, hahbe rehtemisboxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jaa copi ta honanxon Papan yohihiqui: Jato qui tah hen heen joi yohixonnicaboya heen raantibo hean raanai. Hen raanah cahiton ta texe rehtexon texe rihbi tiromajayaxihcanihqui, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Rahma jihuetaibo yohihi sca ta Papan nescajaquin yohihiqui: Maton tah man heen joi yohixonnicahbo rehtennihqui. Hen raanmenoni rehtennixon tah man rahma caman jato jatihibi rehtenpaquehi, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel rehtennixon tah man caibo sca rehtexon, jato rehtepaquehi. Janoxon Papa yocaxonti janin jan nichi que bi Zacarías sca rehtenoxon caman tah man jato rehtenpaquehi. Mato ta Papan casticanyaxihqui, hih ca hen jai sen, jaton jimi man potamani copi. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Hahrai! hih tah man jayaxihqui, haxemanicahbon. Jayaxon Papa honanti huisha joiyahpaxon bi tah man honancatsihyamahi. Jascaxon tah man caibo rihbi sca man pantehi, honanpanan —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jascajabahini caressca jan jaiya cahen jaton haxemanicahbo betan jaton fariseobo sina sinati. ");
INSERT INTO kaqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hashoan sca yocacanquin. Jahuemeha jahuen yohuan copi non rehteti hahtipahtihin hihxon hicha yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Quexehibaan bi hicha bi res jonibo jano tsinquijaqueti. Hihti caibo tsamatax, joni huetsa qui tsehquesihcanahi bohiboya jahuen haxenicabo Jesusen yohiquin, behna joi sca: —Coirametahi man. Fariseobaan coro pahe mato qui mahnemis —hahquin, fariseobaan hahcoinicamati shinan yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Rahma jonexon hahcaibo jatihibi ta Papan janibijaquin yohiyaxihquiqui. Jonetax hihquibo jatihibi ta jaan yohipaqueyaxihquiqui jatihixonbi nincacahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tsoanbi nincayamanon hihquish man bahquish chian yohuanni joibo ta xaba chianxon jaan jato nincamayaxihquiqui. Maton xobo chicho baxexai joibo ta xobo manixon coshin nincamaquin hahcajaquin jatihibi nincamayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Caibaan ta mato rehtexon bi jahua hashoan mato tiromajati hahtipahyamahiqui, hea huetsabaan. Jascapahbo qui raqueyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Huetsan ta mato rehtexon mato casticanti rihbi hahtipahiqui. Hahqui raquenahue, bihxon chihi janin mato potamis. Hahqui caya raquenahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Rabe soro copi non pichca hihsa romishin maroyamahin? Copi que ma bi ta jascapa mahuataiya mi huestibi Papan jato shinanbehnoyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maton boo rihbi ta jahuentihi jaiquin Papan honanihqui. Raqueyamanahue hah ca hen mato jai sen. Mato tah man hicha hihsa mentan hashoan copi qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jonibaan nincanon hihquish Hea ta Cristonah qui hihquibo jatihibi tah hen hean rihbi Papan yonotibo tocanxon rihbi Jaabo ta hena qui, hen jatihi, jaabo yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jonibaan nincanon hihquish Hea ta Cristonahma qui hihquibo rihbi tah hen Papan yonotibaan nincanonbi Jaabo ta henama qui hen jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Man hehqui tiromahi yohuanai bi tah hen jaa mato sohuaxonti hahtipahtihi. Dios Yoshin qui man tiromahi yohuanai ta jascayamahi qui. Jaa ta hen mato sohuaxontimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jaton tsinquiti xobo janin mato hiohax, jaton hapobaan mato casticannon hihquish quesahiboya, jahua yohuan japan, jahua hen yohitihin hihyamayaxahnnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Jaatianbi ta Dios Yoshiman mato yohuan hinantihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jaatian, tsinquijaquetaibo tocan nihxon, huesti jonin yohiquin: —Maestron, heen bocha yohihue, noquen papa yamanicaton jahuaborabo jan hea texe hinannon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Maton jahuaborabo hinannicama tah hen qui. Mato jascajaquin ponteti ta Papan hea yohiyamahiqui —jaa jascajaxon tsamataibo sca yohirihbiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","—Jistahi man. Coiramenahue, jahuaborabo tsinquiti shinan man bihmis. Maton jahuaborabo hichahax jihueti siriti shinanyamanahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jahan haxeti joi sca jato yohiquin: —Huesti jonin cahen huai banahoxon tsama bi res bimibo tsinquiscaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tsinqui tsinquihax ¿Jahuejascapan? Heen bimibo hichahi copi tah hen jahuerahnon bexojatimascai, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Shinanax sca, Heen jano bexojati xobobo huaxepaquexon hihtihosi xoboja sca janoxahpan. Jascajati ta jaiqui. Jano sca heen beroboya heen bimibo tsamanquin bochojascaax tah hen jenimatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hicha bari jihuexon piti tah hen tsinqui sca jai. Tanti tantihahnan pipi pipixon xeha xehascapan, coin coini, hih tah hen jatihi, hihqui shinamehti. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jahuen jointinin jan jascari yohuanaiya bi ta Papan yohinishqui: Shinanjoman, nea yamebi tah hen mia mahuamanoxihqui. Min bexojahibo tsoa sca hihbotihiquin? hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Man jascapa honanma jamis, main jihuexon, hahan jihuexahpan hihxon tsinqui tsinquixon bi Papa janin hicha tsinquiyamahi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jahuen haxenicabo sca yohiquin: —Masa shinanyamanahue, hih ca hen jai sen. Jahua pitima ta jaiqui, jahua pipan hihyamanahue. Chopa tah hen yamahi, jahua hen sahuetihin hihyamarihbinahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","¿Pinoxon res non jihuetain? ¿Chopa sahuenoxon res non yora jain? ");
INSERT INTO kaqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hihsabaan hahcai shinannahue. Jaabaan ta banayamahihqui. Bimi ta tsinquiyamarihbicaniqui. Piyanoxon bexojacatsihxon bi cahen jahuerahnobi bexojati yamahi. Jaton bexojati xobo yamahi bi ta Papan jato piti pishinmayamahiqui. Mato tah man hihsabo mentan hashoan copi qui, hah ca hen mato jai sen. Papan ta mato jistihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Heen shinaman bi hashoan queyanihpan hihquish bi tah min min queyanihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Jascati hahtipahyamaxon jahuejanoxon man texe copi man masa shinantihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Joabo rihbi jenquetsahpabo hin hihxon shinannahue. Jaabaan ta yomenjayamahiqui. Chopa rihbi hahyamahax bi ta hihti siri rajotiyahpa qui. Salomon hicha chopa siribo japahonish bi cahen huesti joa betan senenyamanish. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Joa ta nihi naman hicha jaiqui. Siripi hanihi bi tah non huaijaxon jato mapojahi, copima quen. Copi que ma bi ta Papan jato hihti siri rajotibo hinanihqui. ¿Hashoan sca jan mato coirantihi man shinanyamahin? Shinancoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jaa copi, Jahua pipan, jahua xehapan jayamanahue. Jahua copi bi masa shinanyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Man jascapa pishinai ta Papan jisiqui, hah ca hen mato jai sen. Piti benahi, chopa rihbi benahi ta jatihibi nahuabo nihnichiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Maton tah man Papa queenai quescajaquin hahtihi, pitiya chopabo jaan mato hinannon. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Masa shinanyamanahue, baquebon. Mato man hicha jihuetaima bi ta Papan mato jahuen jihue hinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Maton jahuaborabo maromaxon yomanahtaibo yanapannahue. Queyoyosma coriqui quescapa bihquin hahcajaquin Papa janin queyoyosma jahuaborabo bexojanahue. Jano ta yometsohtimahiqui. Champon rihbi ta jano pihantimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jahua ra hihti queenxon cah man jano res shinanah. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Maton Hihbo manati shinan bihnahue. Chopa sahuexon johue quetejahax manatihcamahi quescanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Huanomahi catani jaton patoro yame jonoxihqui honanax ta jan nocoxon quenahi nincaxon manataibaan histon jahuen xobo xehpoti quehpenbohanxontihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hoxahaxma manataiton jaton patoronen jato merahah ta hihti jenimacantihiqui. Jaton hihbaanbi ta jato hahxonquin pitijaxonquin jato pimatihiqui, jaanbi jato metexpaquexonquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yame pochinicon joyamahax xaba paqueti hochoma sca joxon jato jascari manataiton merahah ta hihti jenimati jaabo jatihiqui, jahuerohahi tah non hoxayamahahqui hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Man honannon hihxon tah hen huetsa sca mato yohihi: Jahua hora yometso jotihiquin honanxon cahen coiranxon xobo hihbaan yometso hihquimayamahan. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jascapa hoxan hihtima shinanya janahue. Hea nocotihi man shinanyamahi tianbi tah hen hea noquebaque mato qui nocotihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","—¿Jaa jaa patax queha joi yohuani min hihqui bi min noquebi yohihin, Hihbon? ¿Caibo rihbi min yohihin? —hahscaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jascahah Jesusen yohiquin: —Shinanyahpa ta jahuen hihbaan yohihi quescabijaquin hahxonai joni qui. Jascapah ta jahuen hihbaan yohitihiqui, jahuen jonibo jisxonti. Jato jisxonquin jaton pitibo jato hinanxonnon hihxon ta jato jisxonnahue hahbahintihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jahuen hihbo joxon sca jascajahiton merahah ta hahan jenimati jaresscatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jascapa ta jahuen hihbaan yohitihiqui, jatihibi jahuen joniboya jahuen jahuabora jan jisxonscanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Shinanyahpa hihyamahax ta heen hihbo ta basihi cahiqui hihxon jahuen hihbaan jonibo rishqui rishquixon jahuen teexonnicah haibobo rihbi rishquixon, pixon, xehahax pahenscaiton sca jahuen hihbaan jisbenatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Joriyama ta jatihiqui hih jan jai tianbi ta hihbo sanarenentihiqui, hihbo nocorihtimahi jan shinanah bi. Joxon sca cahen caxquepaquexon nincayosmabo janin jaa potatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jahuen hihbaan yohini quescabijati honanxon bi hahxonyamahi quen ta jahuen hihbaan hihti casticantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Honanyamaxon tiromajahibo ta hashoan hichama rishqui rishquiyaxihquiqui, hihti hahtihi bi. Hicha mia hinannixon ta hicha rihbi mia hahquirihbi yocayaxihquiqui. Hicha mia hinantahnixon ta hicha rihbi mia bichinyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Chihi potahi tah hen main joniqui. Quetetax perehihna sca japahinon hih tah hen jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hihti tiromabo hen tenetihi tah hen honanai. Histon huinopahinon hihxon tah hen tene tenehi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Huesti shinanyahax siripi jihuetaibo rahsi sca janon hea joní shinan man jain? Huetsajaquin shinanaibo qui huetsa shinanyabo rainyamanon tah hen joníqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Huesti xoboho pichca joni jihuetax bi ta texe qui rabe rainyamatihiqui. Jascayamahiya ta rabe qui texe rainyamatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Huetsa ta jahuen baque qui rainyamatihiqui. Huetsa rihbi ta jahuen papa qui rainyamatihiqui. Huetsa haibo ta jahuen baque qui rainyamatihiqui. Huetsa rihbi jahuen mama qui rainyamahi. Yaya rihbi jahuen hihni qui rainyamahi. Hihni rihbi jahuen yaya qui rainyamahi —hahquin noquen hihbaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jahuen haxenicabo jascajaxon, tsinquijaquetaibo sca yohirihbiquin: —Jano bari hihquihi quiri jisxon nai cohin hanicanahi merahax tah man Hoi ta jahuiqui hihqui. Hihcoini. Jasca ta jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chiponquihax nihue jahuiya tah man Rahma ta barinoxihquiqui hihqui. Jascacoinrihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Honanihcamahibon, ¿nihueya cohinbo jisxon jahua jatihiquin honanxon jahua copi sca man Papan yohihah jahua jatihiquin man honanyamahin, jan mato yohihah bi? ");
INSERT INTO kaqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Jahua jenquetsahaxon man matonbi shinanxon ponte res jihueti shinanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mia demandana juez janin caquin bahinxon bi mia demandanai betan bexohue. ¡Juez janin mia ninitana juezin sca jahuen porisia yohixon mia sipo xoboho rehuinmamis! ");
INSERT INTO kaqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chicho tsahonah tah min copijabahinquin queyoyamahax janohax picotimahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jaatian Pilatonen hahni sca caibaan yohiquin. Galilea mai mehabaan roqui jaton yohinahbo rehtexonquin Papa mapojaxoncannish, Papa Dios hinancatsihquin. Jaton yohinahbo mapojahiton bi roqui Pilatonen jato rehtenish. Rehtexon qui jaton jimin qui jaton yohinahbo nashimaquin, jonin jimiya sca maponon. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jaa chanihibo sca Jesusen yocaquin: —¿Jatihibi jonibo mentan hashoan hohchayahpabo quen Papan jato jascajani shinan man jain? ");
INSERT INTO kaqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jascayama ta jaiqui. Maton shinan ponteyamahax tah man mato rihbi jascapahbo rihbi jayaxihqui, queyocahinscaibo rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Hoa dieciocho jonibo, jato qui jaton xobohhuanen paquequin bishtaxni cahran? Jatihibi ta mahuacannishqui. ¿Jatihibi Jerusalen janin jihuetaibo mentan jaabo hashoan hohchayahpabo hi shinan man jain? ");
INSERT INTO kaqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jascayamahi rahan. Maton shinan ponteyamahax tah man mato rihbi queyocahinyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jato jascajaxon jaa patax queha joi sca jato nincamaribiquin: —Huesti jonin cahen bimi jihui bananish. Bananish, bimiyahpa sca rah ta qui hihquish, cari carixon jisi bi jahuen bimi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bimi yamahiya sca jahuen huai teexonnica yohiquin: Jise. Quimisha bari sca tah hen bimi bihcatsihquish jori jorichai. Jahuabi ta yamahihqui, rahma caman. Rerascahue. ¿Jahua janon jaa nihtihiquin? hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huesti bari pari jenetahhue, hihbon, mai cahuenbohanxon hen jaa naman tara payobo tsamanbohantannon. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jascajaha bimihiya jascabiscanon. Jascajahah bi bimiyamahiya tah non rerascatihi hahquin jahuen huai teexonnicahton —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jato jascajahipish huetsa neten sca jaton tsinquiti xoboho Jesus mapexon jato haxemarihbiquin, jaton tantiti neten. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jano tiroma yoshinyahpa haibo rihbi mapeti. Yoshiman hihbojaha dieciocho bari sca hisini. Cahcopaquecanahi nihnica. Jenquetsahax bi pontetimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jaa meraxon mequeman mehehax Jesus coshin yohuani: —Rohascahue, chocan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jan yohihah, pontecahin sca jai. Jascari rohacahinscaax Hahxon tah min hea jai, Papan, hihqui Papa Dios yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jaton tantiti netenbi Jesusen jaa rohajahiya jaton tsinquiti hihbo rainyamacahini. Rainyamaxon jano tsinquitaibo sinajaquin: —Seis nete ta hahan teeti netebo qui. Jaa netebaan rahomehti benahue. Tantiti neten tah man rahomehtimahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jato jascajahiton Jesusen sca pontejaquin yohiquin: —Quesan, ¿xehpohipixon tantiti netenbi man maton vaca pecaxon, jaa hihyamahiya maton cabacho pishca pecaxon, hioxon man jene xehamayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Satanasnen nea haibo jisxon nexahah dieciocho bari nexá sca nichi quen non tantiti neten jaa rohajatimahin? ¿Maton caibo que bi nexá bi res janon man rohajamacatsihyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jato jascajaha jano tsahobehcoinaibo hihtimahcahinscai. Jaabo hihtimanon bi texe tsinquijaquetaibo jenimahi. Jahuen coshi shinaman jan jato hahxonah quen hihti jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jaa copi ta jato yohinishqui: —Papan jihuemati jenquetsahpa quin, Jenquetsahpa hin hihxon tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Huesti moxo bero pishca quesca tah qui. Jascapah non noquen huai chian banahah cahen hanicahuanscaax jihuiscai. Jihui tihopa sca jaiya cahen jahuen mebibo romishin janin hihsabaan nahajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hahquirihbi sca jato yohiquin: —¿Papan jihuemati jenquetsahpa quin? ");
INSERT INTO kaqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jaa ta hahan paan soohihmati quescapa qui. Jascapa bihxon cahen tasa bocho misi janin haibobaan niahan. Jano niahah ta tasa bocho jatihobi soohihcahuaniqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jaatian sca cahi. Jerusalen janin cahi caquin janobo jai jemabo janin banehuanax caribihiton sca: ");
INSERT INTO kaqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","—Hihbon, ¿Papan jihuemahibo hichatahmabo quin? —hahquin huetsan. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Papan hani tahma xehqui huesti janin hihcoti shinannahue. Hicha ta Hihcopan hihxon bi hihcoti shinanyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Xobo hihbaan jahuen xehqui xehpobohanscai bi tah man jeman nihxon sca xehpoti ton ton hahxon Noque quehpenxonhue Hihbon man jatihi. Man jascaraiton ta Mato tah hen honanyamahi, jahuerahnohahbo ra tah man qui hah ta mato jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jaatian tah man Mihbetan tah non pipahoniqui, mihbetan rihbi tah non xehapahonihqui, noquen jemabo janinxon tah min haxemapahonihqui hah man jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jaatian ta mato yohiyaxihquiqui: ¿Jahuerahnohahbo mato quin? Hen tah hen mato honanyamahi. Nenohax botannahue, tiromabon. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jascajaha tah man huaohihyaxihqui. Abraham, Isaaque, Jacobo, Papan joi yohixonnicahbo jatihibi rihbi, jaabo jatihibi Papan jihuetahbohax jaa janin jihuetai jisxon tah man hihti masa shinanbahinscatihi. Jato qui tah man hihcotimahi. Jatoma qui ta mato potayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Caibo caya ta hocho quehax nocohihnayaxihcanihqui. Bari cainai quirihax, bari hihquihi quirihax, reboquihax, chiponquihax, janobohax nocohihnaxon ta Papan jihuetahboxon jaa janinxon fiestajayaxihcanihqui, benahue Papan jato jaah. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaatian ta rahma chini chinitaibo bebonicabo sca jatihiqui. Caibo rihbi rahma bebonicabo ta chinitaibo sca jayaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jato jascajahiya bi fariseobo sca nocoxon: —Nenohax catanhue. Herodesnin ta mia rehtecatsihquiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","—Hoa quexenica yohitannahue. Tiroma yoshinbo camaxon tah hen hisinaibo rahma rohajaxon, bahquish rihbi rohajaxon hoqueha bahquish sca hen janquenjayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jaabi tah hen rahma jari caparihi. Bahquish rihbi tah hen caparinoxihqui, hoqueha bahquish rihbi tah hen capariyaxihqui. Maton quiquin jema janinbi tah man tiromaboxon Papan joi yohinica rehtematihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalen janinhahbon. Man hea nincacoinpahinon, Jerusalen janinhahbon. Papan joi yohinicabo rehtemisboxon tah man mato qui Papan raannihbo rihbi macaman tsacaquin rehtepahoniqui. Jahuentihi coti sca hen mato tsinquímaha bi tah man queenyamahi. Hatapanen jahuen baque romishin tsinquixon jahuen pehi naman jato paxajaquin hahcajaquin hen mato tsinquímaha bi tah man queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jistahi man. Jahuen baquemabo sca man janon ta Papan mato jenehihqui. Man tah man hea jisyamascatihi, hen joribinon caman. Jaatian pari tah man yohuanyaxihqui, Papan baque ta hihti shinanya nete hihbo jahuiqui hihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jaa pecaho sca quenamaha huesti fariseo hapon xoboho pihi cahi, jaton tantiti neten. Jaa piquihinxon jahua hahxon non cahetihin hihxon jis jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jascapa tocanxon pihanan jisi bi huesti tahsóhihqui joni rihbi jaa bebon tsahotai jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jaton joi xeni haxemanicahboya jano jai fariseobo sca Jesusen yocaquin: —¿Tantiti neten non rohajatihin? ¿Non rohajatimahin? Hea yohinahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yocacah bi jahua hihyamacani. Jahua hihyamahiboya sca tahsóhihqui mehexon rohajaxon, caresscahue hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tsahohahtanaibo sca yohiquin: —¿Maton baque mai poquin chicho paquetaiya, jaa hihyamahiya maton ganado mai poquin chicho paquetaiya tantiti neten que bi man histon bihtimahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yocacah bi jahua yohiti honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Quenamahabo ta pihi tsahocatsihquin hapobaan tsahotibo bihcatsihquibo rahsi jano janishqui. Jascapahbo rahsihi jisxon, jaa patax queha joi sca jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Heen xobo janin pihi cahue hahca cahax jano jahuen hanibo tsahotihi janin tsahopaqueyamanahue. Mia mentan hashoan hapo rihbi quenamaxon mihqui sca caxon, Hori cahue, jaa neno tsahonon, hah mia jamis. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jan mia jascahah tah min hihtimahpax chini chini sca tsahoti catihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jaa copi quenamaha cahax jano chinibo jaiton tsahopaquehue. Jaatian rah ta piti hihbo joxon sca mia Jari hapobo quiri tsahohihnarohahue mia jatihiqui. Jan jascajahiya ta mihbe quenamahabo jatihibichin mia shinanya hihqui mia jistihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hea rah tah hen caibo mentan hashoan shinanyahpa qui hihquibo jatihibi ta hihtimahyaxihquiqui. Hea rah tah hen caibo mentan hashoan jahuama qui hihquibo ta shinan siri Papan hinanyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jaatian sca jaton piti hihbo sca yohiquin: —Pihi benahue hahnoxon pitijaxon miin hamicobo quenamayamahue. Miin huetsabo rihbi quenaxonma, miin jenabo rihbi quenaxonma, mihbe coriquiyahpabo rihbi quenamayamahue. Mia pimanoxon copiquin sca mia quenamaribicanmis. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hichaxon pitijacatsihquin, jahuaborajomabo, tobi pishcabo, chantobo, benchebo, jascapahbo quenamanoxahnhue. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jaabaan mia pimaquin copiti hahtipahyamahi quen tah min hahan jenimati jaresscatihi. Jahuen baquebo Papan huenihihnixon ta mia hahan jenimati hinanyaxihquiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jato tocan pihi tsahotax huetsa joni sca yohuani: —Papan jihue janinxon pihibo ta hihti jenimatihiqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jascahah: —Piti fiestajayanoxon cahen huesti jonin hicha jonibo quenamahan. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jahuen piti hihres sca jaiya sca jahuen joni raanquin, jan quenamahipibo yohinon hihxon. Raanah, Benahue hih ta jaiqui, Ma ta hihresscaiqui hahquin jato yohibonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yohihah bi huesti cacatsihyamahi. Jaa cacatsihyamahiya jatihibi sca cacatsihyamascacani. Jan yohimenohah cacatsihyamaxon joi bichinscaquin: Huai tah hen marohipiqui. Pihi catahin tah hen heen huai jisi cahi. Pihi cati tah hen hahtipahyamascai hahquin hea yohixontanhue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Huetsan sca: Hean tah hen diez toro marohipiqui, rabexon nininicabo. Pihi catahin tah hen rahma jato tanahi cahi. Pihi cati hen hahtipahyamascai piti hihbo yohixonhue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huetsan rihbi sca: Hen tah hen haibo bichipiqui. Jaa copi tah hen cati hahtipahyamascai hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jato yohitani nocoxon sca, jaabo yohuanai jahuen patoro yohiquin. Yohiha jahuen patoro rainyamascai: Rahmabi caribitanhue. Bahin nichibo janin sca caxon jano jaibo, jema quexabi nichibo rihbi yohitanhue. Jahuaborajomabo, tobi pishcabo, benchebo, chantobo jaabo sca yohixon hihuetanhue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jascajatani joxon sca: Min yohihah quescajaquin non hihuehah bi ta piti hicha pari jaiqui, hihbon, hahquin jahuen jonin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jemama qui sca caxon, min bahinxon behchihibo sca bihxon tapasoho jihuetaibo rihbi hihuetanhue heen xobo bochoscanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Non quenamamenohibaan ta jahuabi noquen piti tanatimabiresiqui hihca hen jai sen hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jascajaquin jano tsahotaibo Jesusen yohihiya hihti caibo sca hahqui nocohihnati. Nocotaibo sca jaan yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Maton papabo jistahihmahaxma hehqui jahuibo ta heen haxenicabo jatimahiqui. Maton papa, maton mama, maton haibo, maton baquebo, maton huetsabo, maton chocabo jistahihmahaxma, maton yoshin rihbi jistahihmahaxma tah man heen haxenicabo jatimabiresai. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hea rehtehibaan bi tah hen heen Hihbo jenetimahi hihnahue. Jascaxon nincacoinnahue. Jascajayamaxon tah man heen haxetibo jatimahi. Man shinannon hihxon tah hen yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿Xobojacatsihxon, jahuentihi copitihiquin, heen coriqui senentihiquin hihxon man shinanquin sirijaxon pari xobojayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Shinanquin sirijayamaxon xobo jihuibo nichinxon bi janquenjati min hahtipahyamahiya ta jisibaan sca mia hosantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hoa jonin ta xobojacatsihxon bi janquenjati hahtipahyamahiqui hih ta jaticaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","¿Quiquin hapobo rihbi hahbe quiquin hapo betan rehtenani canoxon tsahotahxon veinte mil sontaroyahpa hahqui jahui bi diez mil pishcayaxon jaa tenetihin hihxon sirijaquin shinanyamaparihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tenetimahi shinanxon ta hoa huetsa hocho pari jahui bi comision hahqui raantihiqui jenquetsahax non bexotihin hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jascajaquin rihbi shinanquin sirijaxon maton jihue jatihibi jenebahinyamahax tah man heen haxetibo jatimabirestihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Tashi ta siri qui. ¿Hahan non pitijacatsihqui bi noquen tashi jahuiyamascaiya, jahuatohon sca non noquen piti jahuijatihin. Non tah non hahtipahyamascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jascapa tashi tah non hahquiribi mai sca hihnon hihxon noquen banabo janin minchintimahi. Non payomacatsihquin piti huecax potahi janin rihbi tah non jascapa tashi tsamantimahi. Jascapa tashi tah non potaresai. Hahan nincati pabinquiyahpaxon nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jaatian sca cobranmisbo betan hohchayahpabo rahsi sca becani. Jesus yohuanai nincaqui becani. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jascapa hahqui nocotaiya fariseobo betan jaton xenibaan joi haxemanicahbo hahqui yohuanscai. Hohchayahpabo sirijaquin bihxon ta jascapa betan pihiqui, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jaa copi ta jaa patax queha joi jato yohinishqui: ");
INSERT INTO kaqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Cien carnero jaax bi huesti manotaiya, jaa manotai huesti benahi canoxon man texe noventinueve janobi jenebahini caquin, man benahi sca cayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","¿Meranoxon caman man benahi cayamahin? ¿Meraxon man jenimahanan papibehnantimahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","¿Xoboho nocoxon sca maton jenaboya mahbe jihuetaibo quenaxon, Jahuerohajaquin tah hen heen carnero baque manotai bi merahahqui, Jenimanonhue hah man jatimahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jascarihbihi ta naihoh quehax jenimacaniqui. Huesti hohchaya jonin mainxon jahuen shinan pontehiya ta jenimacaniqui. Noventinueve jaton shinan ponteti pishinyamahi shinanaibohon jenimayamahax bi huestichin jahuen shinan pontehiya jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","¿Jascarihbihi ta huesti haibaan diez libra jaxon bi huesti manomaxon, johue quetejaxon xobo matsoquin sirijaxon meranoxon caman benabonatimahiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Meraxon sca jahuen jenaboya jahuen hahbe jihuetaibo quenaxon Jahuerohajaquin tah hen hen manomaha coriqui hen merahahqui, jan jatimahiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jascarihbihi ta mainxon huesti hohchaya jonin jahuen shinan pontehiya Papan yonotibo jenimacaniqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Huetsa rihbi sca jato yohiquin: —Huesti joni cahen rabe bebo baque janish. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Haniscaxon cahen jahuen chini baquen jahuen papa yohiquin: Papan, texe hena hihnon min mahuaquin potabahinyaxihquibo hea rahmabi hinanscahue. Jascajaha jahuen baquebo hinantijaxon jaa sca jahuena hinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jahuenahbo jatihibi bichipish jaabiyahpa caresscai, hocho sca huetsa main cahi cahi. Cahi nocoxon sca bexnanbo maroquin. Haibobo copi rihbi jahuen coriqui potaquin queyobahinquin, jahuabi yamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jaa maibo janin piti pishin sca jaiboya, jaa rihbi pihan hihscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pihan hihxon janoha joni patorojascaquin. Jahuen patoronen sca jaan jahuen cochibo pimahi canon jahuen pasto chian sca raanquin, cochi coirantanhue hahxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tsoanbi piti hinanyamahah, pihan hihquish cochin piti bimi romishin piti shinanbahinquin. Jascapah que bi yanicahinnoxon caman piti shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jaatian sca shinanquin sirijahax, Heen papan jonibo hichahi bi ta jaton piti pishinyamahiqui. Neno ca hen pitin mahuacatsih sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Rahma ran heen papa janin hea caresscatihi. Nocoxon tah hen yohitihi: Papan, noquen Papa Dios qui hohchatax tah hen mihqui rihbi hohchatai. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tiroma copi tah min hea Baquen hahtimascai. Miin joni quesca sca hea jahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jascatanpan hihcahini sca caresscai, jahuen papa janin cahi cahi. Nocoti jahui bi hocho pari hihquiya manan huinoquihrani jahuiton jahuen papan meraquin. Jointi xecahihnixon hahan hihti shinanax bishquihihcanahi caxon jahuen baque hicotanxon betsohahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hicotanah sca: Papan, noquen Papa Dios qui hohchatax tah hen mihqui rihbi hohchanihqui. Hea tiroma quen tah min hea Baquen jatimascai hahscaquin jahuen baquen. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jascahah bi yosibaan jahuen jonibo yohiquin: Sahuemanoxon tari siriya berinahue. Mehesehtiya joxon mehesennahue. Sapato rihbi bexonnahue jan sahuenon. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Non xoamarasihi toro baque bihtannahue rehtenoxon. Hicha pitijaxon pihi non coin coinnon. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nea heen baque ta mahuanish bi jihuerihbiscaiqui. Manonish hen shinanah bi tah hen heen baque merahahqui, jato jaquin. Jenimascai, jahuen papa. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jahuen baque bebo quihah teeti. Huai chian teetanax joresscaquin bi xobo hochomaxon sca rehuen behua behuáhibo nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jahuen papan joni huesti quenaxon sca yocaquin: ¿Jahua copi jascacaniquin? hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jochica ta nocotaxqui. Jaa copi ta toro xoa pishca papan rehtehaxqui, jaa siripi nocotai quen hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Honanscaax jahuen bocha rainyamahax xoboho hihcocatsihyamascai. Picoxon jahuen papan Johue, Johue hahca bi joi bichinquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jahuentihi bari sca hen mia teexonai bi tah min heen hahbe rabetibo betan hen jenimanon jahuentianbi hea chibo baque bocabi hinanyamanihqui. Basi teexonquin bi tah hen jahuentianbi mia nincayama yamanihqui. Hea teemis que bi tah min hea jahuabi rehtexonyamaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hoa miin baque jahuen hahresti haibobo janin caxon miin coriqui queyontanax jahuiya cah min noquen toro xoa rehtexonah, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jaatian sca: Mia tah min jascabihi hehbetan jihuetai, baquen. Hea jai jatihibi rihbi ta mina qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jan jahui quen non coin coinax jenimaha ta siri qui. Miin jochica ta mahuanish bi jihuerihbiscaiqui. Manonish bi ta rahma hahquirihbi merahah sca qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jascajaxon jahuen haxenicabo sca Jesusen yohirihbiquin: —Huesti coriquiyahpa joni cahen janish, jahuaborayahpa joni. Huesti neten sca ta chanicannishqui: Miin jahuabora coirannicahton ta miin coriqui mia queyonihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jascaraiboya jahuen coirannica quenamaxon jahuen hihbaan cahescaquin. ¿Hihcoini yohuancaniquin? Hen mia hinantahni coriqui toponpaquehue non jisnon. Heen coiranxonnica tah min jatimascai hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jascahah shinamehti: ¿Jahuejascapan? Heen patoronen ta hea heen tee hea bichinihqui. Yosmaxon tah hen horo horoti hahtipahyamahi. Yocamis sca hihtihi bi tah hen yocati hihtimahpai. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hen honanai quescajaquin hahpan, heen tee jan hea bichinai bi caibaan sca sirijaquin jaton xoboho hea jihuemahabo hihcahini sca caxon jahuen patoro ribinai jonibo sca quenamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jahuen patoro ribinaibo quenamapaquexon sca: ¿Jahuentihi min heen patoro ribinain? hahquin, jan quenamamenohi. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Cinco mil botella olivo xeni tah hen ribinai hahquin. Tsahohue, miin hahan huishati bihxon tres mil botella min copijascai huishahue hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Huetsa rihbi sca yocaquin: ¿Mian cahran? ¿Jahuentihi min ribinain? hahquin. Hean tah hen mil tasa trigo ribinai hahquin. Miin huishati bihxon ochenta res min ribinai huishahue hahscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jan jascajahi chanihibo nincacax sca jahuen patoro yohuani: Jaa ta yometsohti honan qui hihqui, coirannica yohihi jascari. Jascapahbo rihbi ta mai mehabo qui. Jaton caibo jatohon queennon hihxon ta nea mai mehabaan hahquiqui, xaba baquebo mentan hashoan honan ta jacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Maton rihbi rah tah man yometsohxon, jaa coriquinin sca jonibo hesetihi, maton coriqui queyo sca jaiya jaabaan sca jaton queyoyosma jihue janin mato jihuemanon —hahquin fariseobo yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Hicha tahma hinanah, jayaxon sirijaquin hahxon tah man hicha hinanah jayaxon sca sirijaquin hahtihi. Hicha tahma hinanah bi jayaxon tiromajaquin hahxon tah man hicha hinanah sca jayaxon rihbi tiromajatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","¿Nea mai meha jahuaborayaxon man sirijaquin hahyamahiya tsoan sca mato naihoh queha jahuaborabo hinantahtihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","¿Caibaana man jaton jahuaborabo coiranxonquin sirijayamahiya tsoan sca mato matonah hinantihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Patoroyahpaxon tah man jaa sirijaquin teexonhanan huetsa patoro rihbi sirijaquin teexontimahi. Huetsa queenxon tah man huetsa sca jistahihmatihi. Huetsa hahxonquin sirijaxon tah man huetsa sca nincayamascatihi. Maton Papa Dios hahxonquin tah man jahuaborabo rihbi tsinqui tsinquiti hahtipahyamascatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jan yohihi jatihibi nincaxon bi yohuashihboxon hosancanquin fariseobaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hosanaibo sca jaan yohiquin: —Man siribo hihqui jonibaan shinanahbo hihquish tah man siripihcamahi yohuanai. Siripi yohuanihcama man jai bi ta maton shinanbo Papan honanihqui. Hihti siri tah qui hih jonibo jai que bi ta jascapahbo shinanyabo Papan jistahihmahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Juan jonon caman ta Moisesnin huishani joibo janishqui, Papan joi yohixonnicahbaan yohini joibo rihbi. Juan joní pecaho tah non Papan jihuetahboti joi siri sca non yohihi. Jaa copi ta histon sca jahuen jihuetahbo sca jacahincaniqui. Nincati queenaibo rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Papan joi ta queyotimahiqui. Naiya mai queyócahinyaxihqui bi ta ni huesti teque pishcabi jahuen joi manotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Miin haibo potaxon huetsa sca bichish tah min hohchayahpa sca jai, noquen Papa qui tiromahi. Huetsa jonin potahah haibo bichish tah min jascarihbihi, noquen Papa qui hohchayahpa sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Huesti joni cahen coriqui hicha bi res janish. Yanconihboya joxonihbo jahuen quiquin chopabo sahuexon cahen jatihibi neten hihti nohuenihbo pipipahonish. Jenimahanan jihueti can. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jahuen xoboho jaa jascari jihuenon cahen jemanhihti hoque huesti yocamis janish. Patoronen xobo xehqui janin cahi bahin potahahbo racati, jahuen yora nobepan rahbojocotax hisini racati. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Racatax sca: Haitara, jahuen misa janinhax paquetai teque romishin hea hinanpahinnon, hahan hen pihi yanicahinnon, hihqui pihan hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jascari jaax mahuascai. Papan yonotibo sca joxon jano Abraham siripi jihuetai janin jaa hioscaquin, jano sca siripi jihuenon. Coriquiyahpa rihbi sca mahuati. Mahuatai mihincanquin jonibaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jano jascapa bexojati janinxon sca hihti hisin hisinxon hoque jisxon hocho Abraham meraquin. Lázaro rihbi hahbetan pihi tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Abraham quenaxon sca: Hehon shinanhue, Papan. Lázaro raanrohahue, jahuen metoti rebo pishca jenen mehchajaxon jan heen jana matsijaxonnon. Nea chihin ta hea jeneyamahiqui. Hihti tiroma hisin tah hen jai, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Shinanhue, baquen. Jihueparihax tah min siriboyahpa janiqui. Lázaro cahen tiromabo rahsi. Rahma cahen pihihue hahca nenoxon pihi jihueti. Mia cah min hisin jaroma teneti jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hono naponbi rihbi ta hihtihosi xanquen jaiqui, jenquetsahax bi nenohax jari tsoabi botopaquetimahi. Jarihax rihbi tsoabi neno pohquequihrani jotimahi, hahquin Abrahanen. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jaatian hihti yocaribiscaquin: ¡Hahrai, Papan! Jascahiya heen papan xobo janin jaa raanrohahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pichca ta heen huetsabo jaiqui. Raanrohahue, caxon jan jato yohi yohinon, nea hihti tiroma janin joyamahabo, hahquin coriquiyahpa hihpahoniton. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Moisesnin huishani joibo ta jaabo jaiqui, Papan joi yohinicabaan huishani joi rihbi. Jaa joibo jaabaan nincacoinnon, hahquin Abrahanen. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jascahah: Jaa joi ta nincayamacaniqui, Papan. Mahuatipish bi jato qui huesti cahiya pari ta nincacointicaniqui, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Moises nincayamaxon, Papan joi yohinicabo rihbi nincayosmaboxon ta huesti mahuatipish bi hahquirihbi jihuexon jato yohihah bi nincatimarihbicaniqui, hah sca Abrahanen jaa janon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jascajaxon jato yohirihbiquin: —Hahan hohchati shinanya ta jotihiqui. Man jaa jotimajati hahtipahyamahi bi ta jaa jomahi joni hihti sai saihihyaxihquiqui, casticannah. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hohchati shinan hinanyamanon macan renti tenexxon jenenencanya potahah cahen hashoan siriquehahni. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Coiramenahue. Miin huetsa hohchataiya pontejaquin yohihue. Shinanquin sirijahiya sca sirijaquin yohuanquihnhue. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mia tiromajaxon bi Hen tah hen tiromajahahqui, huetsan. Pontejaquin sca tah hen shinanai mia jaah tah min sirijaquin yohuanquihntihi, jan mihqui tiromahah tah min shinanyamascatihi. Huesti neten mia siete coti jascajaha bi tah min hahxontihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jascahah: —Hahan nincacointi shinan noque hashoan hichajaxonhue, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Moxo berotihopa shinan pishcayahpaxon man nea huishtinanti jihui yohixon Mexecahinax hian janin cayacahintanhue man jaah cah man yohihah quesca sca jaquehahni. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Patoroboxon man yonohah, maton joni huai chian teebahinahax jascayamaxon maton hinabo pimaxonax xobon sca jahuiton sca man Johue, mapexon piresscahue ¿hah man jatihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hea pitijaxoni sca johue, hahqui mehca mehcaxon hea bexonhue, hen pixon xehanon. Jascajaxon pari mian sca Pinoxahnhue, xehanoxahnhue, ¿hah man patoroboxon jatimahin? ");
INSERT INTO kaqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Man yonoha jan hahcaiya, Hahxon tah min hea jai, ¿hah man jatihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maton jonin mato hahxonai quescajaribiquin maton Hihbo hahxonnahue. Maton hihbaan mato yohiha jatihibi hahcax Noque tah non tiromabo teexonnicahbo qui. Jan noque yohihah res tah non hahcai, hihnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jaatian sca Jerusalen janin sca cahi cahi. Galilea mai senenbi cahi, samaritanobaan mai quetanpaquebahini cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jaton jema huesti qui nocoxon sca sipiyahpabo jahuibo behchiquin. Diez joni, sipiyahpabo rahsi. Jesus merahax, hocho nihxon coshin quenacanquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—¡Maestron, Jesusen, noquehon shinanrohahue! —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jato jisxon: —Man rohahi sacerdotenin jisnon jismatannahue —jato jaquin. Jascahah boresscacani. Bahin caquin jisi bi jaton sipi rohacahinscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Rohahipibo bi huesti res joribihi. —Papan ta hea hihti hahxonihqui —hihonahi jahui. Nincacahbo hihquish coshin yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus qui nocoxon sca hahqui betihihpaquexon: —Hihti hahxon tah min hea jai, Hihbon —hahquin. Jaa joni cahen samaritano. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—¿Rohascaibo diez hihyamahipishquin? ¿Texe cahran? ");
INSERT INTO kaqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Caibo jononma nea nahua huesti Hahxon tah min hea jai, Papan hihonahi jahuiquin? —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jascajaxon jaa yohiquin: —Huenitax caresscatanhue. Hihcoinjaquin shina nax copi tah min siri sca jai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jaa pecaho sca ta fariseobaan yocannishqui: —¿Papan jihuemati jahuentian jotihiquin? —hahcanquin. Yocacahbo sca: —Papan jihuemati ta jistimahiqui. Maton beron tah man jaa jistimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Neabi tah qui, Hoa tah qui hih tah man jatimaribihi. Papan ta mato tocanxon mato jihuematihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Fariseobo jascajaxon jahuen haxetibo sca yohiquin: —Huetsa tian tah man Noquen Hihbo noque betan hihpahinon, huesti nete pishca res jan hahquirihbi noque betan nihpahinon, hih tah man jayaxihqui. Hea jiscatsihxon bi tah man hea jisyamayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hoa tah qui hihyamahax ta Neno tah qui hihyaxihcanihqui. Jascahahbo bi jano yohihibo janin boyamayaxahnahue. Jato chibanyamayaxahnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Naihoh ramihoh quehax ramihoh queha cana bacatanicamahi ta hea naihoh quehax jahuiya jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jascayahnoxon pari tah hen hicha teneti jai. Hea queenyamahax ta mai mehabo hea yohihi, Tiroma tah qui hihtihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Neateman Noen jihueni tian japahoni quescarihbihi ta jayaxihcanihqui hea naihoh quehax hahquirihbi joresscanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jaatian ta pixon xehacanpahonishqui. Bebobaan haibo bihquin. Haibobaan rihbi bebo bihquin, jahuen xobo nontin Noen nanenon caman. Jaatian ta jenehhuahnen joxon jato queyonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot jihueni tian janíbo quescarihbihi ta jayaxihcanihqui. Picanquin, xehacanquin, marocanquin, maromacanquin, huaijacanquin, xobojacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodon jema janinhax Lot picotai betanbi ta naihoh quehax johuehihnacahinai chihi jato qui paquetah queyocahincannishqui, sodomobo. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jascarihbihi ta jayaxihquiqui, naihoh quehax hea noquebaque sanarenenaiya. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jaatian maton xobo cahchian tsahoxon bi maton xobo chicho jai jahuaborabo bichi cati shinanyamanahue. Huai chian teetax jascarihbihi, xobon cayamascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loton haibo hihni shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Noque rehtecanmis hihxon hea hihbomayamahibo ta queyocahinyaxihquiqui. Hea jenebahinyamahibo ta rehtehah bi jihuecoinyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jaa yamebi huesti bachiho rabe joni hoxahi bi tah hen huetsa bihxon huetsa rihbi hean jenebahinyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rabexon rene renehiboya tah hen huetsa bihxon huetsa rihbi hen potabahinyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Huai chian teetaibo jascajaribiquin. Huetsa bihxon bi huetsa jenebahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jato jascajaha: —¿Jahuerahonon nan, Hihbon? —hahscacanquin. —Jano nami racatai bi ta hishmin tsinquitihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jaatian sca Papa yocati jenebahinyamahahbo hihxon jaa patax queha joi sca jato haxemaquin. Jaayocaqui paxquinyamahahbo hihxon jato haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Huesti tininti cahen jahuen jeman jihuetan, Papahon shinanyosma, jonihon shinanyosma. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jano rihbi cahen huesti yononma haibo janish. Jahuen tininti yohihi sca yononma cari carichi. Hea tiromajahi joni hea casticanxonhue hahqui cari carichi. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Basi jascacahchihi bi tininti queenyamahi. Basihax res sca hahmebi shinamehti: Dios qui raquexonma tah hen jonibo qui rihbi raqueyamaxon bi nea haibaan hea jaajatsanjaha jan demandanai hean casticanxontihi, hea jatsanjayamascanon, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jaa joi jato nincamaxon Jesusen jato yohiscaquin: —Jaa tiroma tininti yohuanai shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Man yocabahinaxon yocashinahah noquen Papan tiromajahibo pontequin mato hashoan histon hahxontimahiquin? ¿Man yocacai tenexon jaan manarestihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Histon bi res ta mato hahxontihiqui. Jan histon mato hahxonai bi ¿naihoh quehax joquin man nincacoinai hen mato jisbenayaxihquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jato jascajaxon huetsa jaa patax queha joi sca jato yohiquin. Hea caya tah hen hohchajoma qui hihxon bi caibo sca jistahihmahiboya nescajaquin jato nincamaquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Rabe bebo cahen janoxon Papa yocati xoboho mapexon Papa yocanish. Huetsa cahen fariseo joni, huetsa cahen coriqui cobranxonnica. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nichish cahen fariseo nescari hahri horahi: Hahxon tah min hea jai, Papan. Hea tah hen caibo jonibo quescapahma qui. Jaabo ta yometsohbo qui, tiromabo, tsinibo. Hoa coriqui cobrannica quescayamarihbi ta hea qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Semanan tihibi tah hen rabe coti samacai. Hen teexon cananai tihibi tah hen texe mia hinanai. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jaa jascari yohuannon bi hocho nichish nai bejisihniti hihtimahpax hahri xohtíhihqui nihxon cobrannicaton yohiquin: Papan Dios, hea tah hen hohchayahpa qui. Tenexon hea sohuahue, Papan, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Man honannon hihxon tah hen mato yohihi. Papan jisí ta hoa fariseo jahuen hohchaya jascabi janishqui, hoa cobranxonnica ta hohchajoma sca jahuen xobon caresscanishqui. Hea caya ta siri qui, hihquibo jatihibi ta Papan rabinmayaxihquiqui. Hea ta jahuama qui hihquibo ta caibo mentan hashoan siri qui, Papan jisi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baquexobo rihbi ta hihuecannishqui, jan jato mehenon. Jaya jahuibo jisxon, jahuen haxenicabaan jato yohiquin, jascapahya beyamanahue, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pantehibo jisxon jato quenaxon: —Baquebo hehqui jonon jenenahue. Jato panteyamanahue. Jascapa ta Papan jihuetahbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hen mato yohinon nincanahue: Baquebaan Papan joi nincacoinai quescajayamaquin nincaresaibaan ta Papan jihuetahboti hahtipahyamahiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Huesti hapon sca yocaquin: —Siri Maestron, ¿jenquetsahax hen hea queyoyamanox manatihin? ");
INSERT INTO kaqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿Jahua copi min hea siri yohihin? Tsoabi siri ta yama qui, Papa huesti res. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Papan yohini joibo tah min honanai. Tsiniyamahue. Joni huetsa rehteyamahue. Yometsohyamahue. Quesayamahue. Miin papan yohihah nincahue, miin maman rihbi yohihah nincaquin —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Baque pishcaxon nincanixon tah hen rahma caman jaa min yohihi quescabijaquin hahcai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","—Huestijati sca tah min pishinai. Miin jahuaborabo jatihibi maromabahinxon jahuajomabo jaa coriqui hinanreshue. Jaatian tah min naihoh sca siri jahuabora jatihi. Jascajatanax hehbe johue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nincaxon masa shinanscaquin, jahuen jahuabora hichahiya. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","—Coriquiyahpabo Papan jihuetahbo jaah ta hihti tee qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xohmox quini janin hahua huinomaha ta tee qui. Tee que bi ta coriquiyahpahhuan Papan jihue janin hihquiti hashoan tee qui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jan jascahiya: —¿Coriquiyahpabo Papan jihuetahbotimahiya tsoabo sca non Papan jihuetahbo jatihin? —hahscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Jonibaan jisí jenquetsahaxon hahtimahi bi ta Papan hahtipahiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","—Jise. Noquen tah non jatihibi jenebahinxon mia chibanai, Hihbon. ¿Non queyoyamanox jihuetimahin? —hahscaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","—Papan jihuemati joi bihcoinnoxon tah man maton xobo potabahinai. Maton xobo, maton haibo, maton huetsabo, maton papabo, maton baquebo rihbi, jaabo jatihibi jenebahinxon tah man nea mainxon bi hashoan hihti caibo rihbi man bihtihi. Naihoh sca tah man queyoyamanox jihuerihbitihi. Jatihibi potabahinax bi tah man hashoan sca jatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jahuen doce joni sca quenaxon: —Nincanahue. Jerusalen janin tah non cahi cahi. Jano sca ta Papan joi yohinicabaan huishani joibo jai quesca sca jatihibi jaresscatihiqui, noquebaque hihqui bi hea yohihi joibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Hea ta nahuabo bihmayaxihcanihqui. Hosan hosanxon ta hea hicháyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hea betoshbanhahxon ta rishquitinin rishqui rishquixon hea rehtescayaxihcanihqui. Hea rehtehipibo bi quimisha neten hihquish tah hen hahquirihbi hueníyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yohihah bi nincayamacanquin. Jaabaan nincacah cahen honantima joi. Jahua hihcatsihquiquin honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jaatian sca Jericó jema janin sca nocoti bocani. Jema hihcoti bahin bocani. Jaa bahi quexabi benche joni tsahoti. Coriqui yocaqui tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Huinojaquetai nincacax yocacahti: —¿Tsoabo man huinotain? —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Nazaret janinhah Jesus ta huinotihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","—Jesusen, Davidi baquen, hehon shinanhue —hahquin, coshin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hahbe huinotaibaan sca: —Netehue. Netehue —hahcabo bi hashoan sca sai saihihqui: —Davidi baquen, hehon shinanrohahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nihrenenxon sca: —Jaa neno hihuenahue —hahquin Jesusen. Hihuehah, jaa senenbi nichiton sca benche yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Hen mia jahuejaxonti min queenain? —hahquin. —Heen bero hea rohajaxonhue, Hihbon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Jisresscahue. Hen mia rohajati min shinancoinai quen tah hen mia rohajasca jai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jaatian jahuen bero siricahin sca jai. Bero siricahinxon Jesus chibanbonahi caquin, Papa Diosen ta hea hihti hahxonihqui hihcanahi. Jaa jisish jatihibi sca jascarihbihi; Papa Dios ta hihti siri qui hihcanacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericó jema nabebacahini cahi sca bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jano Zaqueo janeya joni jai, cobrannicabaan hapo. Coriquiyahpa joni. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jenquetsahpa hin hihxon Jesus jiscatsihqui bi jonibo tsamajaquetaiya jenquetsahaxon jistimahi. Queyanihmaxon jisti hahtipahyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bishquihihcanahi cahi. Jari Jesus huinoxihqui quiri cahi, jihuin hinacahini. Jesus jiscatsihqui hinacahinxon manaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hinatax manatai bi jaa jihui ponte sca nocoxon bejisihnixon bototi Jesusen yohiquin: —Botopaquehue, Zaqueon, histon. Rahma tah hen miin xoboho tantihi cacatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Botocahinax res sca hahbetan caxon jenimahanan jahuen xobon mapemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jan jano mapetai jisish, jatihibi reren rerenscacani. —Hohchayahpa jonin xoboho mapetax ta janobi tantihiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Reren rerenaibaan bi nihinaxon: —Hihbon, texe heen coriqui hena hihnon tah hen jatíhi rihbi jahuajomabo hinannoxihqui. Paranxon hen bichinnihbo rihbi tah hen chosco coti jatíhi rihbi tsamanxon jato hinanrihbitihi, hihbon —hahquin Zaqueonen. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","—Nea netenbi ta nea xoboho jihuetai joni Papan jihuemahiqui, queyoyamanox manascanon. Nea rihbi Abrahanen baque, can. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Manonihbo benahi tah hen naihoh quehax joníqui, jato jihuemanoxon. Jaa copi tah hen queyoyamanox manati yohihahqui —jato jaquin, Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jato jascajahax Jerusalen hochoma sca nichiya sca: —Jaa rah ta quiquin hapo sca Papan hihmanoxihquiqui. Jaa rah tah non rahmabi jisnoxihqui —hihcani. Jascajaquin shinanaibo quen jaa patax queha joi sca jato yohiscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Huesti hani patoro cahen hocho canish, janoxon quiquin hapo sca hihmahahbo. Quiquin haposcaax joribiyanoxon cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cariyamaxon diez jahuen jonibo quenaxon joni tihibi coriqui hinantahquin, joni tihibi diez mil soles. Hinanxon jato yohiquin: Hen joribinon caman jayaxon maroxon maromanahue hichajanoxon, jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jan caresscaipi cahchiqui sca texe jahuen jihuetahbaan jaa jistahihmaxon comision raanquin. Jano jaton patoro cahi janinbi cahax nocoxon Jaa patoro noquen quiquin hapo hihti tah non queenyamahi yohihi cahabo hihxon comision raancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jaabi, quiquin haposcaax joribixon sca jan coriqui hinantahnihbo quenamaquin. Joni tihibichin jahuentihi cananihquin hihxon jato quenamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Huesti joxon: Hihbon, min hea hinantahbahinni tah hen diez coti rihbi jatíhi rihbi hahcai, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Min tah min sirijahi. Mia tah min siri joni qui. Hicha tahma hinanah bi tah min sirijaquin hahcai. Jaa copi tah min diez hani jemabo sca min hihbotihi hahquin jahuen hapon. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Huetsa sca jahui. Min hea hinanbahinni coriqui tah hen pichca coti rihbi jatíhiribi hahcai, Hihbon, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mia rihbi tah hen pichca hani jemabo sca hinanai, min hihbonon, hahscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Huetsa rihbi sca jahui. Joxon: Nea ta min hea hinantahbahinni coriqui qui, Hihbon. Chopan rahcoxon tah hen sirijaquin mia bexojaxonnihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mihqui raquexon tah hen bexojaniqui, Hihbon. Mia tah min sina qui. Mian jananihma tah min bichinai. Min banayamanih tah min tsinquirihbihi, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Min yohuanai quescabija tah hen mia jatihi, tiroman. ¿Hea sina hihqui min honanihquin? ¿Hen jananihmabo hean bichinain? ¿Heanbi banayamanihbo tsinquinica min hea honanain? ");
INSERT INTO kaqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Jahua copi sca min heen coriqui jaya teenica hinanyamanihquin jan jaya teenon? Joxon cah hen heen coriquinin cananai hashoan hicha bihribiquehahnai. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jano nichibo sca yohiquin: Jahuen coriqui bichinxon, diez tsama jai joni hinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jaatian: Ma ta diez jaresscaiqui, Hihbon, hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jaa jaibo rahsi tah hen hashoan sca hinantihi. Jahuajomabo rihbi tah hen jan jai pishca hean bichintihi, hih ca hen jai sen. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hoa hea jaton quiquin hapoti queenyamahibo sca neno hihuenahue. Heen rahuibo tah qui. Heen jisnon bi jato rehtepaquenahue. —Jascajaquin ta haxehahbo Jesusen jato jaa patax queha joi yohinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jaa joi jato nincamahax Jerusalen janin sca cahi caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagéya Betania jemabo hochoma sca Olivo janeyahpa mahchi ponte nococani. Janoxon sca rabe joni raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Hoque racatai jema janin botannahue. Nocoxon tah man cabacho baque nexá meratihi, tsoabi jaa cahtsahonima. Pecaxon hahbenahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","¿Jahuejanoxon man pecahin? yocacah sca, Noquen hihbo ta pishinihqui hihnahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Raanah boresscacani. Cahi nocoxon jan yohiha quescabi meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cabacho baque pecahiton sca cabacho hihbaan jato yocaquin: —¿Jahuejanoxon man pecahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Noquen Hihbo ta nea pishinihqui —hahscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jascajaxon becanquin. Jaya noco sca jaiya sca, jaton chopa hahan pohenxon tsahotijacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jaa cahtsahotax cahiya sca caibaan rihbi jaton taribo pecaxon bahin mijanquin, hahan nihnon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivoya mahchi naman sca nocotaiya jahuen haxenicabo jatihibi jenimacanahi yohuancanahi, coshin bi res: —Papan shinanyaxon ta hihti hahxonihqui —hihcani. Papan coshiyaxon Jesusen jato hahxonrahsihi jisipish jascacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Quiquin hapo ta jahuiqui, Papa Diosen janen ta jahuiqui. Shinanya siri tah qui. Papan ta noquehon shinanxon hahxonihqui. Noquen naihoh queha Papa ta hihti siri bi res qui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Caibo fariseobo rihbi jato tocan nihxon Jesus yohiquin: —Jascayamanon miin haxenicabo netemahue, maestron —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Jaabo netetaiya ta toa minchihi macanbo coshin yohuanquehanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mahchi cahpaquehxon hori Jerusalen jema racatai jisish Jesus jaya huaohihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—¡Rahmabi Papa betan siripi jihueti man honanpahinon, Jerusalen janinhahbon! Jaa honantihi bi tah man benchebo qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tiromabo netebo ta mato qui nocoti jahuiqui. Mato qui tsequeti joxon ta mai tsamanxon mato chiquehahtanbohanxon mato tejatanbohanxon jatihibi janinxon mato tiromajayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Maton xobobo potojaquetanxon ta maton baquebo rehteyaxihcanihqui. Hahan xobojaquin man tsamanni macan ta ni huestibi huetsa macan cahchian tsahoyamascatihiqui. Mato jascajayaxahnnon bi tah man Papan mato rahma sirijacatsihqui man honanyamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jema janin hihcohax sca Papan xoboho mapeti. Mapexon janoxon maromahibo cainmabahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Heen xobo ta jahoxon hea yocati xobo qui hih ta Papan joi janin jaiqui. Nenoxon Papa yocatihi bi tah man jano yometsohbo tsinquitijahi —hahxon jato jabamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jatihibi neten sca ta jaa xobohoxon jonibo haxemanishqui. Jan haxemahiya cahen judiobaan hapobo betan jaton haxemanicahbaan jaa rehteti shinannish. Judio patorobo betan rihbi jascajaquin shinanxon bi jenquetsahaxon rehteti merayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jan haxemahi nincacatsihqui jonibo hashoan hicha tsinquijaquetaiya cahen jenquetsahxon rehtenoxon bihtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Huetsa neten sca Papan xobohoxon jonibo haxemahanan jan joi siri yohihiya sca judiobaan hapobo mapeti jahui. Jaton hapobo, jaton haxemanicahbo, jaton yohuan hihbobo, jaabo rahsi jano mapeti jahui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mapexon yocacanquin: —¿Tsoan janen min jascajahin? ¿Tsoan jascajahue hahca min jascajahin? Noque yohihue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Hean rihbi tah hen mato huesti yocatihi, maton pari hea yohinon. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tsoan yohiha Juaman nashimapahonnishquin? ¿Jonibaan yohihah nan, Papan yohihah nan? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jascajaquin yocacah jaabo rahsibi yocacahanannancani: —¿Jahua non yohitihin? Papan yohihah rahan hah non jaiya ta jahua copi sca man jaa nincayamanihquin hah noque jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jonibaan res yohihah rahan hih non jaiya ta nea tsamajaquetaibaan noque macaman tsacaxon rehtetihiquin. Papan joi yohinica ta Juan janishqui hah ta jacanihqui jatihixonbi, hih ca hen jaihsen —hihcani, jaabo rahsibi yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jascahahnanxon sca: —Tsoan yohiha jaan nashimanishquin, non tah non honanyamahi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Man hea yohiyamahi quen tah hen tsoan yohihah hean nescajahin hean rihbi hen mato yohiyamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jaatian sca jaa patax queha joi sca jonibo yohirihbiquin: —Huesti jonin cahen bimi huai bananish. Huaijaxon ta teexonnicahbo jahuen huai hinantahnishqui, canoxon. Hinantahbahini cahi, hocho cahi caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Basixon sca texe jahuen bimi bihxonnon hihxon hochoxon jahuen joni raanquin. Raanah nocotaiton sca hinantahnibaan rishquixon mequen sca camarihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Huetsa rihbi jahuen joni sca raanrihbiquin. Jaa rihbi rishqui rishquixon roaxon mequen bi res camarihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Huetsa rihbi sca raanquin, jahuen quimisha sca. Jaa rihbi tsehue tsehuejaxon potacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","¿Jahuejascapan? Hahan hen queenai heen baque sca raanpan. Jaa rah ta nincayaxihcanihqui, hahxon raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jaa sca nocoti jahui jisish, yohinancani jahuen hinantahnibo. Jahuen papa yama sca jaiya ta nea sca huai hihbo hihyaxihquiqui. Rehtenonhue, jahuen huai noquena sca hinon hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jascaxon huaima qui hioxon sca rehtecanquin. ¿Huai hihbobi joxon sca jahueja jaan jato jatihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Joxon ta jahuen hinantahnibo rehtepaqueyaxihquiqui. Jato queyobahinxon sca ta huetsabo sca jahuen huai hinantihiqui —jato jaquin. —Jascajayama jacanpahinon —hihscacani, nincacax. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jato bejispaquequin sca: —¿Nea huishani jahua hihcatsihquiquin? Jaa nahuita jihui ta tiroma qui hihxon xobojahibaan potahibaan bi ta jaabaan potahi jihui qui hean xobojacoinai hih ta jaiqui huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jaa nahuita jihui qui paquetaibo ta tobicahintihiqui, jatihibi. Caibo qui paquequin ta jaa jihuin jato champajabahintihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jato qui jan jaa joi yohihi honanxon ta jenquetsahaxon non jaa bihtihin hihxon jaton haxemanicahbo betan jaton hapobaan tanaxon bi bihti hahtipahyamacannishqui, jonibo qui raquexon. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Noquen Hihbo nincacoinihcamahax manahihti cahabo sca caibo copijacanquin. Jaama joi yohuanmatannahue hahxon copijacanquin. Jaama yohihiton bihxon tah non noquen hapo hinanscatihi, noquen gobernador rihbi hinanquin hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nincacoinihcamaxon sca Jesus yocacanquin: —Mian tah min sirijaquin yohihi, maestron. Pontejaquin tah min haxemahi. Tsohquibi raquexonma tah min jaabijaquin jatihibi jonibo yohihi. Papa qui cahi bahi tah min honanmacoinai. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Noque yohihue: ¿Quiquin hapo Cesaronen noque cobranah non copijatihin? ¿Non copijatimahin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Paranxon yocacaibohi honanxon: ");
INSERT INTO kaqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Coriqui huesti hea jismanahue. ¿Tsoan mapo jano jaiquin? ¿Tsoan huisha jano jaiquin? —jato jaquin. —Cesaronena rahan —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Jahuena hihquiya jaa hinannahue. Papana hihquiya tah man noquen Papa hinanrihbitihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tsinquitaibaan jisiya ta jenquetsahaxon yohuanquihnxon bihtima jacannishqui. Jato joi bichinah neteresscani, rahtetax. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceobo sca jahui, tsoabi ta mahuatax hahquirihbi huenitimahiqui hihnicabo. Jaabaan sca tanaquin yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestron, Moisesnin ta huishanishqui, noquen bocha baquejahaxma hihxonaiya non jahuen yononma bihxon hahqui noquen huetsa yamanica non baquejaxonti. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Siete joni ta janishqui, jaa mama quiha rahsi. Bebo quihaton ta haibo bichish bi baquejahaxma mahuanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jahuen chini jaa bichish bi jascarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huetsa rihbi sca jahuen chini, jascarihbihi. Jatihibi sca jascarihbihi, baquejahaxma queyocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hahchon sca ta jaton haibo rihbi mahuanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Papan noque hahquirihbi huenihiya sca, ¿tsoan haibo jaa jatihiquin? Jatihibichin jaa hahuinjani —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","—Rahma jihuetaibo ta haibo bihmahahnaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Papan caisxon hahquirihbi jihuemahibo ta huanoyamascayaxihcanihqui. Huanomayamaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jaabo ta mahuayosmaboyaxihquiqui. Papan yonotibo hihqui quescarihbihi ta jayaxihcanihqui. Papan jato jihuemaha ta jahuen baquebo rahsi sca jayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mahuanicabo hahquirihbi hueníyosmabohi man shinanah bi ta huenínicabohi Moisesnin yohinishqui, nescajaquin: Hea tah hen Abrahanen Papa Dios qui, Isaaquena rihbi, Jacobona rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Papa Dios ta mahuanihbaan Diosma qui. Jaa ta jihuetaibaan Papa Dios qui, Jaan jisi jatihibi japarihi quen —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—Hihcoini rahan —hih sca jaton haxemanica huesti jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hashoan yocati qui raquescaax jascari. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Netetaiton sca: —¿Jahua jisxon Cristo ta Davidin baque hihyaxihquiqui jacanihquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Man jisyamahin, behua huishaquin ta jaa yohihi Davidinin yohinishqui: Xaba hihbaan ta heen hihbo yohinishqui, Hea mecayaho hihbohi tsahohihnahuea ");
INSERT INTO kaqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Miin rahuibo miin hinabo sca hihnon hen jato namanjanon caman neno tsahotihue hah cahen Davidinin janish huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Heen hihbo jan hihquiya ¿jenquetsahax res sca jahuen hihbohax bi jahuen baquetihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jato jascajaxon jatihixonbi jonibaan nincanon sca jahuen haxenicabo yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Jaton haxemanicahbo hihqui quesca man jamis. Coiramenahue. Jaton chopa siribo sahuehax jano jonibo tsinquijaquetai nihti ta costancaniqui, jisibo hihquish jano nichi. Caibaan jato Hapon hahnon hihxon ta costancaniqui. Tsinquiti xoboho ta hapobaan tsahotibo janin tsahocatsihcanihqui. Pihi johue hahca ta xobo hihbo patax bi res tsahoxon picatsihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yononma meraxon ta tahtijaxon jahuen jahuaborabo jatihibi bichincaniqui. Paranquin ta Papa basi yocacaniqui, jatihixonbi nincanon hihxon. Jascapa ta Papan hihti casticanyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jaatian sca coriquiyahpabo jano nichi jisquin. Papa qui hinancatsihquin coriqui naneti bohnanti janin coriqui nanehi nichibo jisquin, hicha coriqui nanehibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Huesti yononma sca joxon jahuen coriqui yamahi bi jahuen rabe coriqui romishin nanequin. Jaan nanehi jisxon sca Jesusen jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","—Hoa jahuaborajoma yononmanen ta caibo mentan hashoan hicha nanehiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Hoabaan ta hicha bi res jaxon texe hinanihqui. Hoa yononmanen ta jatihibi pishinxon bi jan jai jatihibi hinanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jaatian Papan xobo yohihi caibo yohuani. —Macanbo hihti siribo tah qui. Jise. Sirijaquin ta hahcannishqui, xobo siri —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Nea man jisi xobo ta potojaquetanyaxihcanihqui. Ni huesti macanbi ta huetsa cahtsahotimascatihiqui. Potaquin ta ni huestibi pishinmayamayaxihcanihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—¿Jahuentian jascajayaxihcanihquin, maestron? ¿Jahua jisxon non min yohihi quesca sca jacatsihqui non honantihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","—Coiramenahue, mato parancanmis. Hea tah hen qui hihqui ta heen janen hicha joyaxihquiqui. Nete ta queyocatsihscaiqui hih ta jaribiyaxihcanihqui. Jascascaibaan bi jato nincayamaxahnnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Rehtenanaibo joi nincacax bi rahteyamayaxahnnahue. Mai hihbocatsihxon rehtehibo joi nincacax rahteyamarihbiyaxahnnahue. Jascapahbo pari ta jatihiqui. Jascapa jai bi ta nete queyorihyamatihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jascajaxon jato yohirihbiquin: —Huetsa jonibo ta jaton nahuabo betan rehtenanyaxihcanihqui. Quiquin hapobo ta hahbe quiquin hapobo betan rehtenantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mai rihbi ta coshin bi res mihuanyaxihquiqui. Nahuan pahen ta hisinyaxihcanihqui, mahuati hisini. Hicha janin ta jascayaxihquiqui. Hahqui raquetibo ta jatihiqui. Naihoh rihbi ta hahan honantibo jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jaabi ta jascapahbo jariyamahi bi mato tiromajanoxon mato yahtanyaxihcanihqui. Tsinquixon mato tiromajanoxon ta jaton tsinquiti xoboho mato boyaxihcanihqui. Jaton sipo xoboho rihbi ta mato tsahonyaxihcanihqui. Man heen janen yohihi copi ta jaton gobernadorbo janinxon mato demandanyaxihcanihqui. Jaton quiquin hapobo janinxon jascajaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hioxon ta mato Hihcoini sca yohuanhue hahxon mato tana tanayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mato jascajahabo bi rahtexonma maton jointinin shinanquin sirijanahue. Jahua yohipan hihyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jaatianbi tah hen mato shinan hinantihi, hahan yohuanti hinanquin. Man hahan yohuanaiya ta mato joi bichinti hahtipahyamayaxihcanihqui. Mato joi bichincatsihquibo rahsichin ta Jascama ta qui hahti hahtipahtimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hahan yohuanti shinan hen mato hinanah bi ta mato qui yohuanxon caibo maton papabaan, maton mamabaan, maton huetsabaan, maton jenabaan, maton hahbe rabetibaan maton tinintibo mato bihmayaxihcanihqui. Caibo rihbi ta mato rehteyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Man hea nincacoinai quen ta mato jistahihmayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jaabi tah man manotimahi, ni huestibi ta maton boo queyocahintimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hea jenebahinyamahax tah man queyoyamanox manatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mato jascajayaxihquibo bi nahuan sontarobo nea Jerusalen mayahahtanbohanai jisxon, nea jema tiromajabahinti nea pishca sca jai honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jaa jisish Judea main jihuetax mahchi janin jabacahintannahue. Jerusalen janin hihquish rihbi picocahintannahue. Jemama qui nichibo rihbi jema janin joyamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huishani joibo jai quesca sca janon ta hihti tiromabo netebo jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jascapa hahqui nocotah ta tohoyabo hohmis hohmisyaxihquiqui. Xoma hahmahibo rihbi jascarihbihi. Nea main jihuetaibo ta hihti tiromabo huinoyaxihquiqui, Papan jato casticanah. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sontarobaan ta hicha jonibo rehteyaxihquiqui. Jato bihxon rihbi ta jatihibi nahuabaan main jato borestihiqui. Nea Jerusalen rihbi ta nahuabaan hihbojayaxihquiqui, jaton nete senennon caman. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hahan honanti rihbi ta jayaxihquiqui, bari huetsapahi. Hoxne rihbi huetsahpacahini, huishibo jascarihbihi. Quebijistima nian coshin behchon behchonax tsahca tsahcajaquetaiya ta jatihibi janin jihuetaibaan rihbi hihti masa shinanyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jahua sca noque huinomatihiquin hihquish ta raqueya jihuetax jaton jointi masacahinax jonibo mahuayaxihquiqui. Naihoh queha coshibo ta Papan shacon shaconyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jaatian ta naihoh quehax hea noquebaque botopaquetai jisyaxihcanihqui, nai cohiman hihti coshi xabaya hea jahuiya. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hen mato yohihi quescari jacatsihscaiya yobacahinnahue. Hen mato bichi joti nea pishca sca jai honanax, bejisihnibahinquin hahcajahi jihuenahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jato jascajaquin yohixon, jaa patax queha joi jato yohiquin: —Banabo jihuibo jisnahue, jatihibi jihui rihbi jisnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bochocohi jisish tah man Bari tian sca ta jatihiqui hih man jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jascajaquin rihbi hen mato yohihah quescari jaresscai jisxon, mato bichi hea joti nea pishca sca jai honannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hen mato yohihah quescari jatihibi jascascaiya pari ta nete queyoyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Naiya mai queyoyaxihqui bi ta heen joibo jahuentianbi queyotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Coiramenahue. Pahen pahenax man jointi xehpomis. Tiroma netebo huinotax, Hahrai jahueja sca non jatihin hihquish man jointi xehpomis. Huetsa janin man maton shinan camahiya hahan hea jahui nete mato qui nocorenenmis. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jatihibi main jihuetaibo qui ta jaa nete histon nocorenenyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hen mato yohihah quesca jaresscacatsihquiboya mato cahnehahbo hihxon jatihibi tian hoxa tenexon jaayocanahue. Hea naihoh quehax jahuiya, hea bebon nihnicahnoxon hihxon, jaayocanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jato jaa joibo yohinoxon ta bariyahpan Papan xobohoxon jonibo haxemahax yamebo sca Olivoya manan janin hoxahi capahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Xaba paquescaiya ta Papan xoboho jonibo hahquirihbi tsinquijaquepahonishqui, jan haxemahi nincaqui jahuex tsinquicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jaatian pascua fiesta hochoma sca jai, chahoma paan piti fiesta. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jesus yohihi, Jenquetsahaxon non jaa mahuamatihin hih sca jacani, judio hapobo betan jaton haxemanicahbo. Jonibo qui raquetax jascacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jaatian Judas Iscariote Satanasnen hihbojaquin. Jaa Judas ta Jesusen haxenica hihpahonishqui, jahuen doce joni huesti. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Caxon judio hapobo yohuanquihnxon jaton tinintibo rihbi jaan yohuanquihnquin. Jenquetsahaxon Jesus bihmatihin honanscaxon jato yohiscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jan jato yohiha jenimacani. Jenimahanan: —Mia tah non copijatihi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Mato tah hen bihmacointihi —hihquish, Jahua hora jonibo yamahiquin, Jaatianbi bihmahah ta siri qui hihscai Judas, shinamehti. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Fiesta hani neten sca jaton paan pinon jaton carnero baque rehteti netenbi Juanya Pedro Jesusen yohiquin: —Noquen fiesta piti hahxontannahue non pinon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Jahuerahnoxon piti non hahtihin, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Jema janin caxon tah man jene bihtanax poo hiabenahi jahui joni behchinoxihqui. Jaa tah man chibantihi. Jano jaa mapetai janin rihbi tah man jaa xoboho mapetihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mapexon xobo hihbo yohinahue: Jahoxon heen haxenicabo betan hen pascua piti pinon jahoxon piti chique jahuen hin hah ta maestronen jaiqui hahquin yohitannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Man jascahah ta bochiquiha chique hani mato jismanoxihquiqui bexojaha siriscai bi. Janoxon pitija noque jaxontannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Caxon sca jan jato yohihah quescabi meracanquin. Janoxon sca pascua pitijaxoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ma hihresscaiya pihi tsahopaquecani, Jesus jahuen haxenicabo betan. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Janin hea tiromajacanmis tah hen mato betan nea pascua piti hihti queenahqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Papan jihuetahbo janon hen jaton hohcha queyobahinnon caman tah hen pascua piti piyamascatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hahqui xehati sca bihxon: —Nea bihxon hinanpaquenahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nea hompa tah hen xehatimascai, mato jihuemahi jonoxon caman. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jato jascaxon, posen sca bihxon Papa yohixon tehcaxon jato hinanrihbiquin. —Nea ta heen yora qui, man jihuenon hihxon tah hen hehrí jato rehtemahi. Mahuaquin tah hen mato hahxonai. Jaa shinanhahnan piti ta nea qui. Hen mato hahxonai shinanhahnan pinahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pixon xehati sca bihxon jan piti yohihah quescajaribiquin: —Nea xehati hahnahue. Hahxontijanixon mato hahxonscaxon tah hen behna sca hahquirihbi hahxontijahi. Hahxontijaxon hen jahuentianbi huetsajatimahi honanahbo tah hen heen jimi potahi. Jaa shinanhahnan xehanahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jaa hen mato jascajaquin yohihi que bi ta hea bihmahi jonin hehbetanbi piti bichiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Papan yohini quescabihi ta hea tiromahabo jatihiqui. Hea tiromajayaxihquibo bi ta hea jato bihmanoxihqui joni Papan hihti casticanyaxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jato jascahah, yohinancani. Tsoan cahra jascajatihiquin hihquish yocacahanancani, jaabo rahsibi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Caibo sca yohinani, Tsoa non hashoan hapo hihyaxihquiquin hihquish. Jascaraibaan bi Jesusen jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","—Nahuabaan quiquin hapobaan ta jato hihti hihbojahiqui. Jato yono yonohah bi ta Jaa ta hapo siri qui hihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mato tah man jascapahbo jatimahi. Cacannicahax bi tah man jatihibichin yonoti quesca man jatihi, jato hahxonnicah. Mato bebonica ta maton chini quesca jatihiqui, mato hahxonnicah. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Huetsan pinon ta huetsan rihbi metexoniqui. ¿Jahuemeha hashoan hapo quin? ¿Pinica hashoan hapoma quin? Maton hihbo hihxon bi tah hen mato tocan jihuexon mato hihti hahxonai. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Caibaan hea tiromajahah bi tah man jenebahinyamarahsihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Hea quiquin hapo hihnon heen Papan hea yohini quescajaribiquin tah hen hean sca mato rihbi yohihi, hapobo sca man janon, hea quiquin hapo quen man hea janin hehbetanbi pixon xehayaxahnnon. Hen mato hinanah tsahoxon tah man quiquin hapoboscaxon israelibaan doce jenabo man yonoyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Simoman, nincahue, Simoman. Bimi bero rahsi bihcatsihquin tohaquin hahcajaquin mato tana tananoxon hihxon ta Satanasnen coshin yocacaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jaabi tah hen mia yocaxonaqui, min nincacoinquin jeneyamanon. Hahquirihbi miin shinan pontexon sca miin huetsabo coshi hinanyaxahnhue. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Sipo xoboho hea tsahonahbaan bi tah hen mia jahuentianbi jenebahintimahi, hihbon. Hea rehtehibaan bi tah hen mia jenebahintimahi —hahscaquin Simoman. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Yohicoin tah hen mia jai, Pedron. Nea yamebi ta hatapa queori jaima quimisha coti min Hea tah hen jahuen jonima qui hih min jatihi hea yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pedro jascajaxon jatihibi sca yohiquin: —Coriquijoma tah hen mato raannihqui, borasajoma rihbi, sapatojoma rihbi. Jascapa raanah bi ¿jahua man pishinnihquin? —Jahuabima rahan, hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Rahma tah hen mato yohihi. Borasayahpahax jaya cahue. Coriquiyahpahax jascarihbihi. Hahan rehtenanti machitojomaxon miin coton maromaxon machito marohue. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hea yohihi, Hahbe yometsohbo betan ta hihquiqui hih ta hea yohihi jacanihqui, hehqui huishani joi jai quescajaquin ta hea janoxihcanihqui. Jaa copi tah hen yometsoh yohuanihcamaquin mato yohihahqui. Neateman huishaxon yohini quescabi sca ta jaresscatihiqui, hea yohihi joibo —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Jise, Hihbon. Neno tah non machito rabe jai —hihcani. —Jascabi sca janon jenenahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xobo janinhax cahax, jan hihcachihi quescari Olivoya manan manichi cahi. Hahchon bi jahuen haxenicabo rihbi manahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nocoxon: —Tiroma yoshiman mato tanayamanon Papa yocanahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jato jascajahax hori pishca non macan pishca potahi tihixon jaa huesti cahi. Cahax, raboxonen nihxon, Papa yocascaquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Papan, rahma janoxihquibo hea cahnemahue, queenxon. Jaabi, hea queenai quescarihma bi mia queenai quesca janoxihnon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jaatian Papan yonoti naihoh quehax hahqui botopaquexon coshi hinanai jiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jaatian bená benaxon Papa hihti yocascaquin. Yocahahnan niscani, jimi toisihquicamahi niscani. Mai qui toisihquiya mai mehchascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yocati queyohax res sca huenicahuanax jahuen haxenicabo qui joxon benaya hoxahiton jato meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Jahua jenquetsahax man hoxa hoxahin? Huenixon Papa yocanahue; tiroma yoshiman mato tanamis. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jan jato yohihi betanbi jonibo nocoti. Jato betan jahuen haxenica Judas rihbi jato beboxoni jahui. Jesus qui joxon betsohahquin saludanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—¿Betsohahquin min hea jato bihmahin, Judasen? —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jaatian Jesus tejabohanaibohi jisxon sca: —¿Non jato rerascatihin, hihbon? —hahcanquin jahuen haxenicabaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Judio hapon yonoti sca huestichin reraquin. Reraquin bi jahuen pabinquin mecayaho paxtebahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—Jenenahue —hahxon jahuen pabinqui Jesusen mehexon rohajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jaya tejacahuanaibo cahen porisiabo, sacerdotebo, mesco hapobo. Jato jatihibi yocaquin: —¿Yometsoh yahtanquin hahcajahi man machitoya jahuin? ¿Maton huinoboya man jahuin? ");
INSERT INTO kaqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nete tihibi Papan xobohoxon honanmahanan hen mato betan hihrasihi bi tah man hea bihyamahipiqui. Yame bihnicahbo tah man qui, yame baqueboxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jato jascahah bi bihxon judio hapon xobon Jesus bocanquin. Hocho tahni cahen Pedronen jato chibanbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jesusyabi caibo mapenon, caibaan jemanhihtian chihi requenjaquin. Pehchihi tsahotaiboya sca Pedro rihbi jato tocan pehchihi tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pehchihi tsahotai jisxon, Pedro bejisxon huesti haibaan sca yohiquin: —Nea rihbi ta hahbetan nihrasihiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","—Quesahi. Jaa tah hen honanyamahi joni qui —hihscai Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jahuen hihbo jan hihbomayamahah basima sca huetsan rihbi bejisahnan yohiquin: —Mia rihbi tah min jahuen joni qui —hahquin. —Jaama tah hen qui —hihribiscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Basima huesti hora tihixonpahax huetsa rihbi yohuani: —Hihcoini ta jato betan nea nihcachihiqui, Galilea mai meha joni can —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jan jascarai bi: —Min yohihi tah hen honanyamabiresai —hihribihi Pedro. Jan yohuanai betan bi hatapa queoscai. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Xobohoxon sca rabejaquexon Jesusen Pedro bejisquin. Jaatianbi ta Jesusen yohihah joibo Pedronen shinanscanishqui, janin hatapa queonon tah min quimisha coti hehqui paranahxihqui jan yohihah shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Shinanax, picotax huaohihscai. Hihti huaohihqui, Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Xobohoxon sca Jesus xecoxon hosanhahnan rishquicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bebepoxon beshrishquixon yocacanquin: —Jisxonma yohihue. ¿Tsoan mia beshrishquihiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hicha jascapa join hosan hosancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Xaba paque sca jaiya sca, jaton hani hapobo tsinquiti becani. Sacerdote hapobo betan jaton huisha honanbo tsinquicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bexon, jato tocan sca Jesus nihmacanquin. Nihmaxon: —¿Mia min noquen Cristo quin? Noque yohihue —hahcanquin. —Hen mato yohihah bi tah man nincatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hen mato yocacah bi tah man yohitimarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Rahma tah hen hea noquebaque Papa mecayaho tsahonoxihqui, janoxon sca jahuen coshiyaxon yononoxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jato jascaha, joi bichincanquin: —¿Mia min Papa Diosen baque quin nan? —Jaa tah hen qui. Man yohihi quescabi rahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—¿Jahua hashoan nincati non pishinain? Jan jascari yohuanai tah non noquenbi nincacai —hahscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Canon benahue hahxon sca Pilato janin sca Jesus hiocanquin jatihixonbi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Janoxon sca quesa cahecanquin. —Nea tah non noquen caibo hihbojacatsihquiton merahahquin. Quiquin hapo Cesaro copijayamahabo ta jato haxemahiqui. Quiquin hapo Cristo jan hihqui ta yohirihbihiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","—¿Mia min judiobaan quiquin hapo quin? —hahscaquin Pilatonen. —Min yohihi quesca rahan —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","—Hean jisi ta jahua copi nea joni demandanti yamahihqui —judio hapoboya jano tsamajaquetaibo Pilatonen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Coshi coshixon sca: —Neatohon ta jonibo sinamaxon coromahiqui. Judea mai janin jatihibincon nihxon ta jato jascati haxemahiqui. Reboqui Galilea janin pehocohnish ta neno caman sca jahuiqui, jascati honanmabenahi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","—¿Galilea mai meha joni hin? —Pilatonen jato yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Herodesnin mai meha joni Jesus hihqui honanxon, Herodes janin sca jaya bohabo jato raanscaquin. Herodes rihbi Jerusalen janin jaatian jai quen hahqui sca jato raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jaatian Jesus jisish, Herodes coin coinscai. Jaya joihibo nincanish basi sca jaa jiscatsihquish jenimascai. Jahuen coshiyaxon hahcai jiscatsihquish jenimahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jahuen coshi jiscatsihxon sca yoca yocaquin. Yocacah bi jahua hihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jan jahua hihyamahi bi ta jano rihbi nihxon judio hapobo betan jaton haxemanicahbaan quesajaquin coshin bi res cahe cahecannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jahuen sontarobo betan Herodesnin Jesus tiromajaquin yohixon hosan hosanscaquin. Quiquin hapon tari sahuemaxon sca Pilato janin raanrihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato betan Herodes rainyamapahonish bi jaatianbi raescai rabebi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatonen sca judio hapoboya jaton meyayahpabo quenamaxon, jaton jonibo rihbi quenamaxon jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Noquen jonibo noque bichincatsihqui joni tah qui hahxon tah man nea joni hihuehahqui. Maton nincanonbi tah hen sirijaquin jaa yocacahqui. Honanquin sirijaxon tah hen jahua copi caheti merayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesnin ta merayamarihbihaxqui. Hen hahqui raanah bi ta noque qui raanrihbihaxqui. Jahua copi rehteti ta yamahihqui, jan tiromani yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaa copi tah hen rishqui rishquimaxon picoxihqui —jato jaquin Pilatonen. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jaton fiesta tian cah qui huesti joni jato picoxonpahonnish, hahpahonibo quescajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilatonen jato yohihah bi coshin bi res sai saihihcani jatihibi. —Jaama rahan. Barrabas caya noque picoxonhue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabasnen ta jaton jema janinhahbo sinamaxon rehtenanmanishqui. Jaa copi ta sipo xoboho jaa tsahoncannishqui, jan joni rehteni copi rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sai saihihquiboya coshin sca Pilatonen jato yohirihbiquin: —Jesus tah hen mato picoxontihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pilato coshin yohuanai bi sai saihihquin mahuincanquin. —Jihui qui hueonhue. Jihui qui hueonhue, mahuanon —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jato yohirihbiquin, quimisha coti sca: —¿Jahua tiroma hen janishquin nan? Hean jisi ta jahua copi rehteti yamahihqui. Jaa copi tah hen rishquimaxon jenebahintihi —hahquin Pilatonen. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hashoan sca coshicahinxon coshin bi res yohicanquin. —Jihui qui hueonxon rehtehue —coshin yohiquin Pilato mahuincanquin, sai saihihxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jaabaan yohihi quescajati ta jaiqui hihxon sca ");
INSERT INTO kaqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","hoa joni rehtenica sca jato picoxonquin, jaabo queenai quescajaquin. Rehtenanmanica joni picoxonxon bi Jesus jato hinanquin, jaabo queenai quescajahabo. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesus boxon sca jemama quirihax jahui joni behchixon bihxon jaa jahuen coros hiamacanquin. Simon janeya joni ta jaa janishqui, Cirene mai meha. Jesus chibanbonanon hiamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hicha jonibo rihbi hahchon bocani. Haibobo rihbi hahchon bocani, huini huinicanahi. Jaya huaohihcanacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jato qui rabejaquexon sca Jesusen jato yohiquin: —Heya huaohihyamanahue, Jerusalen haibobon. Maton yoraya huaohihnahue, maton baqueya rihbi huaohihnahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tiromabo netebo ta mato qui nocoti jahuiqui. Jaatian tah man masa shinanyaxihqui: Hea rihbi baquejoma japahinon, baquexo jahuentianbi bihyamaha cahen hashoan siripan. Jahuentianbi baquexo xoma hahmayamani cahen siripan hih tah man jayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Noque qui paquenahue mananbon. Noque mahpobahinnahue, mahchibon, hah tah man jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xoo pari jihui jai bi nescajahibo jaiya ¿jihui xanascaiya jenquetsahpabo jatihiquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Huetsa joni rabe rihbi ta bocannishqui, tiroma rabe. Jesus hueonxon jaabo rabe rihbi jihuin hueonnoxon bocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mapo xao janeya mahchi manixon sca janoxonbi jihuin hueoncanquin. Jesus naponbi janon, jaa patax tiroma joni huesti hueonxon nichinxon, ramiho sca huetsa joni tiroma. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","—Jaton hohcha jato sohuaxonhue, Papan. Hea honanyamaxon ta hea nescajacanihqui —hihqui Jesus. Jihuin Jesus hueonxon sca tsoan jahuen chopa bihtihiquin hihxon macan bero pishca borasa qui nanexon chicohah huetsa macan pari cainaiya huetsan jahuen chopa bihnon, huetsa macan pari cainaiya huetsan sca jahuen chopa bihnon hihxon, jascajaquin jahuen chopa bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jano tsinquijaquecahuani nihxon, jonibaan jis jisquin. Hosan hosancanquin, jaton hapobaan. —Caibo ta rohajapahonishqui. Papan Cristohax hahrí sca rohajahanon, Papan caisah jonihax hahri rohajahanon —hihcani jaton hapobo. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sontarobaan rihbi sca jano nihxon hosan hosanquin. Mae cachani bexon, hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Judiobaan quiquin hapohax mihri rohajahahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jahuen mapo bochiqui quirica rihbi hueoncanquin. Nea ta judiobaan quiquin hapo qui hihqui jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jaa patax hueonahbo huesti sca yohuani, yometsoh huesti: —¿Mia min Cristo quin? Mihri rohajahatax botoxon noque rihbi hahxonhue —hihqui hosani. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ramiho quehaton sca joi bichinxon jahuen hahbe tiroma joni qui rainyamascai: —¿Mia min Dios qui raqueyamahin? Mia rihbi tah min mahuanoxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Noque rabe non tiromajani copi tah non rahma mahuatai. Non caibo hahni quescaja ta noque jacanihqui. Noque quescayamahi ta nea jahua tiromayamanishqui —hahxon, Jesus sca yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","—Quiquin haposcaxon, hehon shinanyaxahnhue, Jesusen —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Nea netenbi tah min hehbetanbi heen jihue janin jacoinnoxihqui —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Barin manan tsacahiya sca, jatihibi janin bahquishihcahini, bari mahpohah yamecahini, bari racapaquescanon caman bahquishihcahini. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Papa yocati xoboho rihbi chopa chique naponbi huaxacahini, quexe rabe sca janon. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Coshin bi res sca Jesus yohuani: —Hea bihhue, Papan. Mihqui tah hen hinamehtai —hihquish mahuascai. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jatihibi jisish jano nichi sontaro capitan sca yohuani: —Papa Diosen ta jisiqui. Nea joni ta siri joni hihquishqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jisi jahuibo rihbi hen mia yohihibo jisish rahte rahteti. Masa shinanax xohpatsihtax sca boribicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hahbetan nihpahonibaan rihbi hocho nihxon jatihibi jisquin. Galilea mai janinhax jaa manahi jahuipi haibobaan rihbi jatihibi jisquin, hochoxon. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Jaatian ta Jerusalen janin José janeya joni japahonishqui, Arimatea jema janinha joni. Arimatea ta judiobaan jema rihbi qui. Jaa José ta jaton cacannica rihbi janishqui, hihcax bi siri joni, pontejaquin shinanai joni. Noque jihuemanica Papan raanpahinon hihnicah. Jaan jisí cahen jahuen hahbe hapobaan tiromajaquin shinanrahsihi. Jesus rehtecatsihquibo quescayamahi ta jaa janishqui, jaabaan hahcachihi quescajayamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jaa José sca Pilato janin caxon Jesusen yora yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jesusen yora bihpaxon sca, sabananen rahcoquin sirijaxon, mai xanqueman poquin quiniho sca mihinquin, jano tsoabi tsahonnihma. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tantiti neten piyanoxon ta jaton pitijati neten jaa tsahonnishqui, tantiti nete nea pishca sca jaiya. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea mai mehax Jesus betan jahuipi haibobo ta José chibanbonahi canishqui, jan tsahoni cahiya. Tsahon honanxon, jan jascajaquin racanai jisish, boresscacani. ");
INSERT INTO kaqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hahan yora hininjati mescohi bocani. Mirra janeya hahan hininjati rihbi bichi bocani. Tantiti neten sca tanticani, Moisesnin yohini quescari. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tantiti nete huinoscaipish xaba honanax sca tsahon janin boribicani. Jaton hininjatibo rahojahipixon papibahini bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nocoxon, hahan xehpohipibo macan taranbohana sca meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsahon janin hihcoxon bi noquen Hihbo Jesusen yora merayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jahuen hea bohancanaxquin hihquiboya sca rabe joni jano sanareneni. Jaton chopa cahen bahri bahrichi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hihti raquetax, jato qui betihihpaquecani haibobo. Betihihpaquetaiton: —Mohitahpa joni tah man benahi. ¿Jahuajanoxon man neno tsahonnihbo janin man benahi jahui nan? ");
INSERT INTO kaqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nenoma ta qui. Ma ta hueniscaaxqui. Galilea mainxon jan mato yohiho shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hohchayahpabo qui tah hen hea noquebaque hinamehti jai, jihuin hueonxon rehtescaabo. Jaa pecaho tah hen jahuen quimisha neten sca hahquirihbi teehihtihi hah ta mato jahoxqui —hahcanquin, sanareneni jahuibaan. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yohihah, Hihcoini, jasca ta jahoxqui hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jacahini sca tsahon janinhax boribicani. Jahuen once haxenicabo yohitannon benahue, jato jatihibi yohinon benahue. Texe rihbi jano jaibo yohinon benahue hihcahini bocani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jaa ta María Magdalena qui, Juana, Jacobon mama María rihbi. Caibo haibobo rihbi jato betan bocani. Nocoxon jahuen haxenicabo yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yohihah bi yohuanresaibo shinanxon jato nincayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro sca picotax bishquihihcanahax tsahon janin nocotax cahcopaquexon jisi bi jano jahuen sabana jano huesti tsamati. Jahua jenquetsaxquin hihquish, rahtetax, xobon sca caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jaa neten bi sca jato quiha rabe joni cahi, huetsa jema janin cahi bocani. Emaus janeya jema janin cahi bocani, Jerusalen janinhax tahen cahá cahen rabe hora. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yohuan yohuancanahi bocani. Jisipiboya rahma nincabehnanaibo rahsi shinanax yohuan yohuancanahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yohinancanahi bohiboya sca, jato chibanbonahi caxon jato huinonquin bi jato manahi sca Jesus nichi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jaa hihqui bi bebepohah quescaxon jaa honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—¿Jahua yohuan man jain, man yohinani nihcanahin? —jato jaah, nihrenencani jaton bemanan huetsapahcahini. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleopas janeya sca yohuani: —¿Jerusalen janin jihuetahxon bi min mia huestichin jano jaipibo joi min honanyamahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Jahua jaipishqui nan? —hahquin. —Jesus nazareno jaipibo rahan. Jaa ta Papan joi yohinica hihpahonishqui. Jatihibichin jisnon bi ta Papan coshiyaxon hahpahonishqui. Papan shinanyaxon ta noque haxemapahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Noquen hapobo betan noquen cacannicabaan rehtenon ta hinanipicanaxqui, jihuin hueonxon rehtehahbo. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noque israelibo jihuemanicah tah qui hih non jarasihi que bi ta rehtehipicanaxqui. Neayanish ta quimisha netescaiqui, rehtepibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Rahma rihbi ta noquen chocabaan noque rahtehaxqui. Hihari tsahon janin caxon roqui jahuen yora xahbanjacanax. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Merayamahax qui joquin sca Papan yonotibo jato qui cainai qui jiscanquin. Jihue ta jaiqui qui jaa yonotibo jai, yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jaatian ta noque janinhax caibo rihbi sca jahuen tsahon janin bocanaxqui. Haibobo yohuanah quescabi roqui meracanax, jahuen yora yamascai —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","—Honanyamahibon. ¿Yotiho chahoma maton jointi quin? Papan joi yohinicabaan yohini joibo jatihibi man nincapanan. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Jascapa tiromabo huinoti Criston jai yohiyamacannishquin? ¿Jaa pecaho sca naihoh queha quiquin hihbo jaa jatihi yohiyamacannishquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jato jascajaxon, Moisesnin huishani joibo jato honanmaquin sirijaxon, texe Papan joi yohinicabaan huishani joibo sca jato honanmapaquequin, Cristo yohihi joi rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jano jaabo cahi jema qui sca nococani. Hojno caparihi quesca jaa jai bi hihti yocacanquin: ");
INSERT INTO kaqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—Noque qui banetahhue. Bepi sca ta jaiqui. Bari ta hihquicatsihscaiqui. Jeenhihquish mapeti. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jaabaan Pihue hahcá piti bihxon Papa yocaxon tehcaxon jato hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jaatian pari jaton bero quehpemehxon quescaxon jisxon jaa hihqui honanscacanquin. Jaatian jaabaan jisi bi jaa yamacahin sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","—Bahinxon noque yohixon huishani joibo noque honanmaxon ¿noquen jointibo xecahihnimayamahaxquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jaatianbi cahax, Jerusalen janin boribicani. Nocoxon jahuen once haxenicabo tsinquitaiton meracanquin. Texe rihbi jato betan tsinquiti. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Noquen Hihbo ta teehihrihbihiqui. Hueni coin ta jaaxqui. Pedronen ta jisishqui —hihqui tsinquitaibo. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jaatian jaabo rabechin bahinxon jisxon nincatanah yohixon, jan paan tehcaxonaiya jaa hihqui honanaibo yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jato yohiparihiya bi jato tocan jaa sanareneni jahui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rahte rahtetax, yoshin tah qui hihquish, raquepahhuancani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","¿Jahua jenquetsain man rahtetain? ¿Jahuejahi man maton jointi janin raqueya yohuanain? ");
INSERT INTO kaqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Heen mequen jisnahue. Heen tahe jisnahue. Hea tah hen qui. Mehexon jisnahue. Yoshinma tah hen qui: yoshin ta nami yamahihqui, xaobo yamarihbihi. Hea ta jascapahma qui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jato jascajaxon, jahuen mequen jato jismaquin. Jahuen tahe jato jismaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hihti jenimaya rahte rahtexon jaa hihqui shinanyamaparihiboya sca jato yocaquin: —¿Man piti yamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yapa xohi teque pishca hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bihxon jaton jisnon bi sca piquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pixon jato yohiquin: —Mato betan jihueparixon tah hen mato yohinihqui, hea yohihi Moisesnin huishani jatihibi jai quesca ta jatihiqui. Huetsa Papan joi yohinicabaan huishani joibo, Davidinin behua janin rihbi jaibo quesca sca ta jatihibi jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jascajaquin yohixon jaton jointi quehpenxonquin Papan huishani joibo honancoinahbo jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Tiromahabo bi Cristo mahuatihi, jan hihquipish bi quimisha neten hihquish hahquirihbi teehihti ta huishacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Maton shinan pontenahue jan maton hohcha sohuaxonnon hahquin Jerusalen janin yohimenohax janohax jatihibi jonibo janin sca jahuen janen jascajaquin yohiyaxihcani, jaa jatihibi ta huishaxon yohicannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yohinihbo jai quesca sca jai jisxon tah man honanquin sirijahi. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Papan mato hinantijani tah hen mato qui raanyaxihqui. Nea jema janin banetahnahue, heen naihoh queha coshi mato qui noconon caman —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jato jascajaxon Betania jema janin caman jato hioquin. Janoxon sca jahuen mequen sanahihnixon siri shinanya janoxihquibo sca jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jato yohihahnan sca caresscai, naihoh hinahihnati. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jaabo sca hihti jenimahanan Jerusalen janin boribicani. ");
INSERT INTO kaqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Papa yocati xoboho res mapexon Papa yocacanquin, Hahxon tah min noque jai, Papan, hahquin.");
INSERT INTO kaqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jahuabi jaríyamanon ta Papan joi hihbo janishqui. Papa Dios betan jihueti. Papan joi hihbo ta Papan shinanyahpa qui. Dios bi res ta jaa joi qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Naiyahpa mai jaríyamanon ta Papa Dios betan jaa joi hihbo janishqui. Jahuen jane cahen Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jaan ta jatihibi janishqui. Jaan hahyamani quen ta jahuabi yamaquehanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaan ta jatihibi yoshinyahpabojaquin jihuemanishqui. Jaa noquen jihuemanicah ta noquen xaba qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bahquish chian xabatai bi cahen yamepan bahquishjayamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Noquen xaba hihbo ta jahuiqui hihqui jonon ta Juan janeya joni Papan raannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jaa ta xaba hihbo qui hihxon yohicoini jonon. Joxon, jatihixonbi nincacoinahbo hihxon jato yohicoinquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jaa Juan cahen xaba hihquishma bi xaba hihbo qui yohicoini jahui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jaa xaba hihbo ta jatihibi joni xabajanicah qui. Xaba hihbo hihquish bi cahen noque janin jaa jahui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jan hahni nete janin jaabi jahue que bi cahen jano jihuetaibaan huetsapahascaquin, jaabi que bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jaton caibo que bi Johue hahyamacanquin, jaanbi hahni nete janin nocotai bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Caibaan res Johue hahquin. Jaa Johue hahcaibo cahen: Diosen baquebo sca janahue, mato rahsibi, hea nincacoinaibo rahsi, xabapan jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jaa Johue hahcaibo Papa Diosen baquebo hihnon, jimiyahpa papa janonma bi queeyahpa papajomabo hihnon, bebaan baquejaha hihnonma bi: Papan baquebo janahue xabapan jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yorayahpahax ta noque betan jaa Papan joi hihbo jihuenishqui. Jan hihti coshin hahcai tah non jisniqui. Jaa huesti jahuen papa xohtahi, nete hihbohi. Yohuani hihcoinai. Shinanyahpa siri. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hahqui chanicoini cahen Juan coshin yohuani, nescari: —Hoa ta hen mato yohipi noque qui, hea pari jomenoni que bi ta hehchon jahui noquen hea mahuinihqui, jaa pari jihue hihbonixon —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jahuen shinan hihti caibohi tah non jatihixonbi bihniqui, jaan hinanresah. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xabapan shinan non bihnon hihxon ta Papan Moises yononishqui, noquen nincati joi Moisesnin huishanon. Jaa pecaho ta Jesucriston sca jahuen shinan noque hinanresiqui, hihcoinai joi non honannon, noquehon Papan shinanai non honannon. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tsoanbi ta noquen Papa Dios jisyamanishqui, jahuentianbi. Non jisyamani bi ta hahan jan shinanai jahuen baquen noque yohiha, jenquetsahpa noquen Papa Dios quin non honanscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yocacahbo hihxon ta Jerusalen janinha judiobaan jaton sacerdoteboya levitobo Juan qui raannishqui. —¿Mia min tsoa quin? —Juan yocacahbo. Yocacahbo ta jato yohicoinnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Paranxonma jato yohicoinquin: —Hea ta hen Cristoma qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jasca jan jaiya, yocarihbicanquin: —¿Tsoa min quin? ¿Mia min Elías yamanica quin? —hahcanquin. Jascahahbo bi: —Hea ta jaama qui —hahquin. —¿Hoa Dios joi yohinica nan? —hahscacanquin. —Hea ta jaama rihbi qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jaatian yocarihbicanquin: —¿Tsoa min quin? Noque Yocatannahue hahcaibo non yohihi sca canon, Jaa ta hen qui noque jahue, mianbi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Cahchihoxon quenahi ta hea qui, Hihbo hahan jonon bahi najisti chai jaxonnahue hahnicah. Papan joi yohinica hihxon Isaiasnen noque yohini quescabijaquin tah hean jai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yohihahbaan bi fariseobaan sca hahquirihbi raanah, yocarihbicanquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—¿Jahua copi min Cristo hihxonma bi min jato nashimahin, Elías rihbi hihxonma bi, hoa Dios joi yohinica rihbi hihxonma bi min nashimahi nan? —hahcanquin Juan yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Hean ta hen jenen res nashimahi. Mato tocan ta man honanyamahi joni nichiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hehchon jahui que bi tah hen jahuen sapato risbi pecaxonti senenyamahi, jaa hihti siri copi —Juaman jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jordan huean hoque quexaxon, janoxon Juaman jato nashimahi janinxon bi ta jascajaquin yocacannishqui, Betania jema janinxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huetsa bahquish sca jari Jesus jahui qui jisxon, Juaman jato yohiquin: —Jisnahue. Hoa ta Papan carnero joni qui, main jihuetaibaan hohcha copi mahuayaxihqui joni. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hen mato yohihipi tah qui, Hehchon jahui jonin ta hea mahuinihqui, jaa pari jihue hihbonixon hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hean rihbi jaa honannixonma bi tah hen israelibaan jaa jisxon honannon hihxon hean jenen nashimahi joníqui —Juaman jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jato jascajaxon yohirihbicoinquin: —Naihoh quehax Dios Yoshin botopaquetax, nobex quescapa hahqui bototi manahi jahui tah hen hean jisoqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jaa tsoa quin tah hen hean rihbi honanyamanihqui. Hen honanyamahi bi ta Papan hea yononishqui, jenen nashimahi hea jonon. Botopaquetax heen yoshin siri jaa manahi jahui min jisyaxihqui ta heen yoshin siri bichibo nashimaquin hahcajanicah qui, heen yoshin siri jato hinanquin, hih ta Papa jahoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jan jascajahi jisoxon ta hen mato yohicoinai: Papa Diosen baque tah qui —Juaman jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huetsa bahquish sca, jahuen haxenica rabe betan nihribixon, ");
INSERT INTO kaqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus nichi jisxon: —Jisnahue. Jaa ta Papa Diosen carnero qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jan jascarai nincacax rabebi jahuen haxenica cahi, Jesus chibani sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Rabejaquexon, chibanai jato meraxon Jesusen jato yocaquin: —¿Jahuejahi man behin? —jato jaquin. Yocacah: —¿Jahuen min jihuetain, Rabin? —hahcanquin. Rabin ta maestron hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Jisi benahue —hahscaquin. Jaatian boresscaxon, jan jano jihuetai jisish, bepiscaiya jaa netenbi jahuen xoboho banecani. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Huesti ta Andres janishqui, Simon Pedro huetsa. Huetsa joni betan nihxon, Juan yohuanai nincaxon, Jesus res sca chibanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jahuen huetsa Simon benaxon meraxon: —Mesías tah non merascai —hahquin. Mesías cahen Papan raanah joni hihcatsihqui, Cristo, jaton join. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jascajaxon, Jesus janin Simon hioquin. Nocotaiya bejisxon Jesusen yohiquin: —Mia tah min Simon qui, Juaman baque. Cefas janeya sca tah min jayaxihqui —hahquin. Cefas ta macan hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huetsa bahquish sca Galilea main cacatsihquin Felipe meraxon: —Hehbe cahue —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida jema janin ta Felipe jihuepahonishqui, Andres betan Pedro jano jihuepahoni janin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Natanael meraxon, Felipenin yohiquin: —Papan joi huishaquin Moisesnin yohini joni tah non meratanai. Papan joi yohinicabaan rihbi hahqui huishaxon yohini. Josepan baque Jesus tah qui, Nazaret janinhah —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Nazaret janinha jahua siri jatihiquin? —hihqui Natanael. —Jisihue —hahscaquin Felipenin. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael hahqui nocoti jahui jisish Jesus yohuani: —Jisnahue. Jaa ta israeli baque coin qui, paranyosma joni —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Jenquetsahaxon min hea honanain? —hahquin Natanaelnin. —Higo jihui naman tsahotai ta hen mia jisiqui, Felipenin mia quenarihyamanon —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Mia tah min Papa Diosen baque qui, Maestron. Mia tah min israelibaan quiquin hapo qui —hihscai Natanael. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusen sca Natanael yohiquin: —¿Higo jihui naman tsahotai ta hen mia jisiqui hen mia jaiya min nincacoinain? Heen coshiyaxon hahcai tah qui. Hashoan rihbi heen coshiyaxon hen hahcai tah min jisyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yohicoin ta hen mato jai: nai huiso quehpemehtaiya hea janinhax hinahihnatax hea noquebaque qui nocoti botopaquetai tah man Papan yonotibo man jisyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jan jascahipi quimisha neten sca Galilea main huanomahibo jai, Caná jema janin. Quenamaha jano rihbi Jesusen mama cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jahuen haxenicaboyabi canon Jesus rihbi quenamacanquin, huanohihbo jisi canon. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jaton xehati queyoscaiya: —Hompa ta yamascaiqui, baquen —hihqui jahuen mama. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—¿Min jascaraiya bi jahueja hen jatihin, maman? Heen coshiya teeti nete ta nocorihyamahiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xehamanicahbo sca: —Jaan mato yohihi quescabijanahue —jahuen maman jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Janobi rihbi cahen seis macan poo tsahoti jene paxa hahqui bexojatibo. Hanibo poo can, huesti cuñete hihyamahax rabe cuñete betan senenai tihopabo, hahan judiobo mechoquiti, tachoquiti, jaton hihti quescari. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","—Poo qui jene bohasaxonnahue —jato jaquin Jesusen. Jaatian bohasabahincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Huehaxon, fiesta hihbo nomimatannahue —Jesusen jaah sca, huehaxon nomimacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jaa jene hompacahinscai bi fiesta hihbaan tanaquin. Tanaxon bi jahuerahnohah hin honanyamaquin. Jene bihtanaibaan honanai bi fiesta hihbaan honanyamaquin. Tanaxon jahuen huanoni quenaxon sca fiesta hihbaan yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Pahenscaiton jato tiroma xehati xehamanoxon tah non siri pari jato hahmanica qui. Mian tah min rahma pari hompa siri cainmahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Galilea mai janinhah Caná jema janinxon ta Jesusen jascajamenoquin hahan honantijanishqui. Jahuen coshi jato jismahah cahen jahuen haxenicabaan nincacoinscaquin, Papan caisai joni hihqui honancoincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jaa pecaho jahuen mama, jahuen jochicabo rihbi, jahuen haxenicabo rihbi Capernaum janin hahbetan cahax nocotax jahuentihi ra netebo jano baneti, basima tahni. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judiobaan pascua fiesta nea pishcascaiya Jerusalen janin Jesus cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nocoxon Papan xobohoxon jaton ganadoya carnero maromahiton jascapa maromanicahbo meraquin. Nobex maromanica joniboya coriqui mahnenannica jonibo rihbi jano tsahotai merarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jascajahiton meraxon risbipan hahan rishquitijaxon jeman jato potaquin. Jatihibi potaquin, jaton ganadaboya jaton carneroboya bi. Jaton coriqui napabohanxon coriqui misa rihbi behonjanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nobex maromanicahbo sca yohiquin: —Nescapahbo botannahue. Heen papan xobohoxon jascajayamanahue. Janoxon marotima tah qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jato potahi jisxon, Hea tah hen miin xobo hihti jenipahichai jaa jiscatsihqui, hihqui neateman huishani joi jahuen haxenicabaan shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jahuen haxenicabaan sirijaquin shinanai bi judiobaan sca joi bichinquin: —¿Jahua hahan honanti min noque jismahin, nescajanoxon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Nea xobo potojaquetannahue, quimisha nete huinoxon hen jaa xahnenenbi hahribinon —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—¿Cuarenta y seis bari teexon janquenjanibo xobo min quimisha neten xobojaquin queyotihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jahuen yora yohihi jan hihqui bi janoxon Papa Dios yocati xobo yohihi shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hihquipish bi teehihrihbihiya pari ta jan jascajaquin jato yohiho jahuen haxenicabaan shinanscanishqui. Shinanax, Hihcoini Papan huishamani joi ta jaa yohihi jaiqui, noquen Hihbo Jesusen rihbi ta noque jascajaquin yohinishqui, hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua fiesta tian Jerusalen janinxon hahan honantibo Jesusen hahcai jisxon: —Papan caisai noque tah qui —hahcanquin hicha jonibaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jascaraibaan bi jato jatihibi honanax jato tocan Jesus nihresyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jatihibi jonibaan shinanai jaanbi jahuen jointinin honanscai copi, Jasca ta shinancaniqui hihnica pishinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Huesti fariseo joni ta judiobaan cacannica hihpahonishqui, Nicodemo janeya joni. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesus qui yame caxon yohiquin: —Noque honanmahi mia jonon ta mia Papan raannishqui, Maestron. Non tah non honanai. Mian tah min hahan honantibojahi. Mihbetan Papa Dios hihyamahiya cahen min jascajati hahtipahyamahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jaatian: —Mia tah hen yohicoinai. Behnajaquin jonijahama jonin ta Papan jihue jistimabiresiqui —Jesusen jaa jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Yosibohax non jenquetsahax hahquirihbi jonitihin? Noquen maman xahquin janin non hahquirihbi hihquitihin, jonirihbinoxon? —Nicodemonen Jesus jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Mia tah hen yohicoinai: Dios Yoshiman jonijahama joni ta Papan jihue janin hihcotimabiresihqui. Jenen rihbi jonijahama joni ta jano hihcotimabiresihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Namin jonijaha ta yorayahpa qui. Dios Yoshiman jonijaha ta yoshin rihbi qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hahquirihbi joniti tah min jai hen mia jaah bi rahteyamahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jano jan queenaiton ta nihue cahiqui. Jahuerahnohax cainax jahuen cahiquin tah min honanyamahi, xoo hihqui nincaxon bi. Dios Yoshiman jonijaha jatihibi ta jascarihbi qui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Jaa min yohihi jenquetsahatihiquin nan? —hihqui Nicodemo. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesusen sca yohiquin: —¿Israelibaan honanmanicahxon bi min hean mia yohihah min honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yohicoin tah hen mia jai: Honanxon non mato yohihah bi tah man nincayamahi. Jisxon non yohihah bi tah man nincayamahi non hihcoinai bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nea mai meha joi yohihah bi nincacoinyamaxon tah man jenquetsahaxon bi naihoh queha hen mato yohihi joi nincacointimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tsoabi naihoh catanni que ma bi tah hen janohax botopaquetai hea huesti jano canicah qui, hea noquebaque. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nincacoinaibo queyoyamanox mananon ta cahchihoxon Moisesnin rono nichinhihninoxon jihuin hueonni quescajaquin hea noquebaque nichinhihninoxon hueonyaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Hea noquebaque qui hinamehxon nincacoinaibo jatihibi ta queyoyamanox manatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nai nequebihabo hihti queenxon ta jahuen baque hea huesti Papan raannishqui, hinamehxon nincacoinaibo jatihibi queyoyamanox mananon, tsoabi mehtexehtaxma jihuenon. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Main jihuetaibo casticani jonon hihxonma bi hen jato jihuemahi jonon hihxon ta Papan hea raannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nincacoinai jonibo ta jahua copi casticantimabo qui. Nincayosma jonibo ta casticanscatihiqui, Papan baquen yohihah bi jahua nincayamahibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mai janin xaba jahue que bi ta xaba jenipahiyamacaniqui. Yame caya ta jenipahicaniqui tiromabohax. Jaa copi ta jato casticanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nenoxon tiromajahibo rahsi ta johue jiscatsihyamahax xaba quiri cayosmabo qui, tiromajahibo caibaan jismis hihquish xaba quiri cayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hihcoinaibo ta xaba quiri canicah qui. Papan jisi hah ta jaan jaiqui caibo hihnon hihquish —Jesusen Nicodemo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jaa pecaho ta jahuen haxenicabo betan Jesus canishqui Judea mai janin. Jano jato betan banexon nincacoinaibo hihquimatanquin nashimaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Enon jema janinxon Juaman rihbi nashimaquin Salim hochoma jano noayahpa huean jaiton. Juaman jato nashimanon caibo jano cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sipo xoboho Juan tsahonrihyamahiboya jano jonibo bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jascascahiya Juaman haxenicabo betan judiobo yohinani: —¿Jenquetsahaxon non noquen hohcha potatihin? —hihqui yohinani rainyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juan qui caxon sca yohicanquin: —Jordan hoque quexa mia manatipi jonin rihbi ta nashimahiqui, maestron. Min noque yohicoinipi joni tah qui. Jise. Hahqui sca ta jatihibi bocanihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jascahahbo jato yohiquin: —Papan noque hinanyamahah tah non tsoanbi jenquetsahpabi bihti hahtipahtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hea ta hen Cristoma qui. Hean pari yohixoni jonon hihxon res ta Papan hea yononishqui. Hen jascahipi tah man matonbi honancoinai. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nesca tah qui, jisnahue. Jahuen haibo hihnon cahen bebo huanocatsihqui. Jan yohuanai ta jano rihbi nihxon jahuen hahberabetinin nincatihiqui. Jan yohuanai nincacax coincoini. Jascarihbi ta hen hea coin coini jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Caiti ta jaa jaiqui. Jahua hihtima ta hea jai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Bochiquihax jahui jonin ta jatihibi joni hihbojahiqui. Mainxon jonijahabo ta mainxon jisish jan jisiboya yohuanihqui. Naihoh quehax jahui joni ta jatihibi jonibaan hihbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Naihohxon jisnibo yohuancoin jan jai bi ta tsoanbi nincacoinyamahihqui. Jan nincanihbo yohuancoin rihbi jan jai bi ta tsoanbi nincacoinyamarihbihihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jan yohicoinah nincacoinaibo ta Papa Dios ta hihcoinnicah qui hihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Papan raannica joni hihxon ta Papan joibo yohihiqui. Hahqui ta jahuen yoshin siri Papa Dios yohuashihyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jaa jahuen baquehon queenxon ta Papan jatihibi jaa hinannishqui, jaan sca hihbojanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jaa Papan baque qui hinamehxon nincacoinai joni ta queyoyamanox manatihiqui. Jahuen baquen yohihah bi nincayamahi joni ta jihuetimahiqui. Jascapa ta Papan hihti jistahihmahiqui, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Juaman honanmaxon nashimahi mentan hashoan hihti caibo Jesusen honanmaxon nashimahi cahen fariseobaan nincascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jaanbi Jesusen nashimayamahi bi ta jahuen haxenicabaan res nashimanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jahuen nashimatibo caichai fariseobaan joi nincacai honanxon Judea mai Jesusen potabahinquin, Galilea main caribinoxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galilea main canoxon cahen Samaria mai nabebacahinti jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Cahi, Samaria mai meha jema janin nocoti, Sicar janeya jeman. Jacobonen jahuen baque José hinanni mai hochomahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jene bihnoxon ta janobi Jacobonen mai poquinnishqui. Poquinxon chiquerihbiquin. Jano sca ta Jesus noconishqui. Bahin nihnichi paxquinax, barin manan tsacahiya jaa mai poquin quexa Jesus tsahopaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jahuen haxenicabo jema janin piti benahi canon cahen jano manati. Manahahnan, samaritano haibo jene bichi jahuiton, yocaquin: —Hen nominon jene pishca hea bihxonhue, haibon —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jaatian: —¿Jenquetsahaxon min mia judio hihxon bi hea samaritano haibo jene yocacain? —samaritano haibaan Jesus yocaquin. Judiobaan samaritanobo jistahihmahi copi haibaan jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—Tsoan mia jene yocacai honanxon cah min mianbi jaa yocacan. Papan mia hinanai rihbi honanxon cah min yocacan. Jaatian ta mia jene mohini hinanquehanihqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Mai poquin ta nemin qui, bebon. Hahan tsecati rihbi tah min yamahi. ¿Jahuen min jascapa jene mohini bihtihin? ");
INSERT INTO kaqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Noquen xeni Jacobonen ta nea noa xehanishqui. Jahuen baqueboyaxonbi jahuen yohinabaan rihbi nea jene xehaquin. Nea noa noque jaan hinannih que bi cahran min jaa mentan hashoan coshi quin? —hahquin haibaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jaatian Jesusen sca: —Nea jene hahcaibo ta hahquirihbi nomicatsihnoxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Hean jene hinanah xehahax ta jahuentianbi jiricatsihyamascatihiqui. Jaa chicho quehax ta hen hinanai jene mohini jahuentianbi taraxaxma jabascatihiqui —haibo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Jaa jene hea hinanhue, bebon, jiricatsihyamascaax hen neno jene bichi jori joriyamascanon —haibaan Jesus jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesusen sca: —Miin bene quenatanhue, joribinoxon —jaa haibo jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jascahah: —Heen bene ta yamahihqui —hahquin haibaan. —Yohiquin sirija tah min jai, miin bene yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pichca miin bene janish bi cah min rahma huetsa betan hihrihbihi, miin benema rihbi. Hihcoin tah min jai —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Papan joi yohinica mia quin hen ta hen honanscai, bebon. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nea machinxon ta noquen xenibaan betihihpaquexon Papahon shinanpahonishqui, Jerusalen janinxon non Papahon shinanti jai man maton jai bi —hihqui haibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesusen sca: —Hen mia yohihah nincacoinhue, haibon. Papahon shinanaibaan ta nea mahchinxonma bi Jerusalen janinxonma rihbi noquen Papahon man shinanyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Man honanyamahi naman tah man betihihpaquetai, Papahon shinancatsihqui. Non honanai naman betihihpaquexon tah non noquen shinanai. Jihuemanicah ta judio xohta qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hahan Papahon shinanti nete jahuex bi ta nocoscaiqui, Papa qui betihihpaquexon shinancoinaibaan jahuen yoshin siriyaxonbi Papahon shinanbiresnon, hahan shinancoinquin. Jascapa shinanaibohon ta noquen Papa queenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Noquen Papa ta yoshin qui. Jahan shinanai noquebo ta jahuen yoshinyaxonbi shinancointi jaiqui —haibo Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Papa Diosen caisai joni, Cristo hahcaibo, joyaxihqui ta hen honanai. Joxon ta jatihibi joi noque yohiyaxihquiqui —hihqui haibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Hea tah hen jaa qui, mia yohihi joni —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jasca jan jaiya bi jahuen haxenicabo nocoti. Haibo betan yohuanaiton merahax rahtecani. Rahtexon bi ¿Jahuejahi min hahbe yohuanahquin, jahua yohuan min jain, hahbetan? Jesus yocacatsihquin bi yocayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jaatian jahuen poo tsahonbahini jema janin haibo cahi cahi. Cahi nocoxon jonibo yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jatihibi hean janíbo hea yohihi joni jistannahue. ¿Jaa Cristoma hin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jaatian jema janinhax cainax Jesus jisi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jasca sca jaiboya: —Pihue, maestron —jahuen haxenicabaan Jesus jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pihue jaibaan bi: —Man honanyamahi piti ta hea jai —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jasca jan jaiya jahuen haxenicabo jaabo rahsibi yohuani: —¿Tsoan cahra piti bexonaxquin? —hihcani yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jascahibo bi: —Hea yononi queenai quescajaxonti ta heen piti qui. Jahuen tee queyoxonti rihbi ta heen piti qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Chosco hoxne hihquish pari ta banabo tsinquiti siri sca jatihiqui hih man jayamahin? Man jascarai bi ta hen mato yohihi. Huai chian bana johuescai jisnahue. Tsinquiti siri sca ta jaiqui hah ta hen mato jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cananhahnan ta tsinquinicaton jascabi jihuetai bimi tsinquihihqui. Bananica betan tsinquinica jenimascanon ta jaton tsinquitibo queyoyamanox manatihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Huetsan tsinquixonyaxahnon ta huetsan banahihqui hih ta jacanihqui. Hihcoini. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Man bananixonma bi tsinquitannon tah hen mato yononihqui. Caibaan hahni tee tah man tsinquitihi —jato Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jaa jema janinha samaritanobaan ta hichaxon Jesus nincacoinnishqui. Jatihibi hean janíbo ta hea yohihaxqui hahquin haibaan jato yohicoinai copi nincacoincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jesus qui caxon yocaquin: —Noque qui banehue. Cayama sca jahue —hahcanquin. Jascahahbo jato betan rabe neten baneti. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jaanbi jato yohihiya nincacoincanquin hashoan tsamaxon sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nincacoinxon haibo yohicanquin: —Mian noque yohihah nincacoinipixon bi tah non jaa yohuanai noquenbi nincaxon non hashoan sca nincacoinscai. Jaa coin ta nai nequebihabo jihuemanicah qui, honancoin sca tah non jai —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rabe neten jato betan banetax janohax Galilea main sca cahi caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caquin sca ta jato yohinishqui: —Jahuen main jihuetai bi ta jahuen caibaan Papan joi yohinica nincacatsihyamahihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jascahi bi jatihibi jan Jerusalen janinha fiesta janinxon hahcai jistanipixon Galilea main jihuetaibaan Johue hahquin jaton main nocotaiton. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Janoxon jan jato jene hompajaxonni jema janin nocorihbihi, Caná janeya jema, Galilea main. Capernaum jema janin cahen huesti tinintinin baque hisini jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judea mai mehax Galilea mai janin Jesus joresscai chanihah jaa yocaqui tininti jahui. —Heen baque hea rahonxoni cahue. Hihcatsih sca ta jaiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Hahan honanti jisyamaxon tah man nincacoinyamahi, hahqui rahtetibo rihbi jisyamaxon —tininti Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jan jascarai bi: —Jani heen baque mahuanon carihue, hihbon —hahquin tinintinin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Careshue. Miin baque ta jihuetihiqui —tininti Jesusen jaquin. Min yohihi quescabi ta jacointihiqui hihquish tininti cahi caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cahipish cabahinahi bi jahuen jonibaan behchibenaquin. —Miin baque ta rohscaipishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jascaraiton jato yocaquin: —¿Jahuerahnon bari racataiya jahuen yona tantihipishquin? —Bahquish bari hihpaquescaiya ta yona tantihipishqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jano bari racatai bi Miin baque ta jihuetihiqui Jesusen jaipi jahuen papan honanscaquin. Jaatian sca jahuen xobo janinhahbo betan jatihixonbi Jesus nincacoinscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jaa ta Judea mai mehax Galilea janin joribixon sca jahuen rabe sca jahuen hahan honanti Jesusen jato hahxonnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jaa pecaho judiobaan fiesta jaiya Jerusalen janin Jesus caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalen janin ta jema xehpoti jaiqui, carnero janeya xehpoti. Jema xehpoti hochoma cahen noa pishca racatah Betesda hahcaibo, judiobaan join. Jaa hian quexa ta pichca xobo tsahotihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jaa xoboho cahen hicha hisinaibo racati, benchebo, tobi pishcabo, yora honanyamajaquetaibo. Noa pishca bahinon jaabo manati. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jaa noa janin roqui Papan yonoti paquepahonish. Paquexon qui jene bahimaquin. Bahihiya qui jenenencanya paquemenohi joni rohahi siripi. Jahuen hisin jatihibi rohacahini. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jano cahen huesti joni racati, treinta y ocho bari jascabi hisini. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Racataiton jisxon hicha bari sca hisinai honanscaxon: —¿Min rohacatsihyamahin? —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Jene bahihiya hea jenenencanya potanica ta yama qui, hihbon. Hea cahiya bi huetsa pari hihquihi —hihqui hisinai. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Huenihue. Huenixon miin cacajati bichish caresscatanhue —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jaatianbi rohacahinxon jahuen cacajati bichish caresscai. Jaton tantiti neten ta Jesusen jascajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jaa copi ta jan rohajahi joni judiobaan yohinishqui: —Rahma ta tantiti nete qui. Tantiti neten tah min miin cacajati botimahi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jascahahbo bi: —Miin cacajati bichish caresscatanhue hah ta hea rohajahi jonin jaaxqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Jahua joni jaa quin, mia Miin cacajati bichish jaya catanhue hahcai? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yocacahbo bi Jesusen jane honanyamaquin, jano jonibo hicha nichiton Jesus rebesohtai copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jaa pecaho Papan xobohoxon jaa merarihbixon: —Jise. Mia tah min siriscai. Hohchayamascahue hashoan tiromamis —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jaatian caresscaxon judiobo yohiquin: —Hea rohajahi joni ta Jesus qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tantiti neten jan rohajahi copi judiobo Jesus qui rainyamahiton jaan jato joi bichinquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","—Heen papa ta rahma caman teetihqui. Hea rihbi ta hen teetai —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jascajaha hashoan sca Jesus rehtecatsihquibohi. Jan tantiti neten tantiyamahi copi rehtecatsihquibo. Papa Dios betan jasca rabe hihquish, Papa Dios ta heen papa qui jan jaiton. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesusen jato yohirihbiquin: —Yohicoin ta hen mato jai: Papan baquexon bi tah hen hehmebi jahuejati hahtipahyamahi. Heen papan hahcai jisxon pari tah hen hahcai, jatihibi heen papan hahcai quescabijaquin hean rihbi hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Hea jahuen baquehon shinanxon ta heen papan jatihibi jan hahcai rihbi hea jahuen baque jismahihqui. Jahuen coshiyaxon hen hahcai bi ta nea mentan hashoan coshin hen hahcai rihbi hen mato jismayaxihqui, man rahtenon. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mahuanihbo huenixon heen papan jihuemahi quescajaribiquin tah hen jahuen baque hihxon hea hen queenaibo hean jihuemahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tsoabi casticanxonma ta Papan hea yonohihqui hean sca jatihibi jointi honanxon casticanyaxahnon. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Papa Dios Nete Hihbohi man honanai quescajaribiquin man jahuen baque Nete Hihbohi man jatihixonbi honannon ta jascajahiqui. Jahuen baque ta nete hihboma qui hihquibo ta Jaa raanni jahuen papa rihbi ta nete hihboma qui hihnicahbo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yohicoin tah hen mato jai: heen joi nincaxon bi hea raanni heen papa rihbi nincacoinai joni ta queyoyamanox manatihqui. Jaa casticanxonma ta Papan mahnescaiqui, mahuataibo janinhax jihuetaibo qui mahnenon. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yohicoin ta hen mato jaribihi: mahuanihbaan ta Papan baquen yohihi nincascaiqui, nincacaibo jihuescanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jahuen papa teehihmanicahi quescarihbihi tah hen hea jahuen baque jaa xohtahi, Mia rihbi jato teehihmanicahue, Papan hea janí. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mia tah min noquebaque qui. Mian sca jato casticanhue hah ta heen papan janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hen mato yohihah bi rahteyamanahue. Hean quenahah ta tsahon janinhahbaan jatihixonbi nincayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sirijanibo ta cainax huenicahintihiqui, jascabi sca queyoyamanox manati jihuenoxon. Tiromajanibo rihbi ta cainax huenitihiqui, jascabijaquin casticanahbo janoxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Hehmebi tah hen jahuejati hahtipahyamahi. Papa nincaxon res tah hen jato casticantihi. Jaa copi tah hen pontejaquin shinanxon casticanyaxihqui. Jaan hea yononixon shinanai quescajaquin tah hen jascajatihi. Heabi hen queenaijah ta hen jayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Hehqui heabi yohuanax cahen heen yohuan jahuabi hihyamahan. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hea jahua quin honanahbo ta huetsa yohuancoinihqui. Hea yohihi jan hihcoini yohuanai tah hen honanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Honancatsihquin man Juan qui raanah ta hihcoini jaa yohuancoinnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jonibo res yohuanai joi ta hean nincayamahi. Papan mato teehihmanon hihxon res ta hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johue quetejaha xabatai janin quescari tah man Juan qui caniqui, jahuen xaba chian sca basima jenimanoxon quescapi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Heen papan ta hea teebo yohinishqui hean queyoxonnon. Jaa ta hen hahcai, hea papan raanni man honancoinnon hihxon. Hean hahcaibo ta hea yohihi joi quesca qui, hahan hea honanti. Juaman yohini nincaxon hahan hea honantihi bi hean hahcai jisxon hashoan sirijaquin honanti. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hea raanni heen papan ta hehqui yohicoinihqui. Jan yohuanai tah man jahuentianbi nincayamanihqui. Beron rihbi tah man jaa jisyamaniqui jahuentianbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jaan raanni joni man nincacoinyamahiya ta maton jointi janin Papan joi yamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Papan huishani joi jisquin sirijanahue. Hea yohihi joi ta jaa qui, hahan hea honantihi bi tah man hahan mahuataxma jihueti man shinanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hean mato teehihmanon hehqui jotihi bi tah man jocatsihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Jonibaan res hea Yotiho coshi mia quin hahti tah hen queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mato tah hen honanai. Noquen Papahon tah man queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Heen papan hea raanah hen jahui bi tah man hea Johue hahyamahi. Jaabaanbi shinanax jahuibo tah man Johue hahtihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Jenquetsahaxon man mato qui siripi yohuanaibo benaxon man noquen Papan joi nincacointihin? Papa huesti noquen Dios hihqui bi tah man jaa siripi mato qui yohuanti man queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Heanbi noquen Papa maton hohcha yohipaqueyaxihqui shinanyamanahue. Mato cahenica ta Moisesnin huisha qui, hahan jihueti man shinanai que bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesnin huishani joi nincacoinxon cah man hea rihbi nincaquehanai. Hehqui ta jaan huishanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","¿Jenquetsahaxon man heen joi nincacointihin, Moisesnin huisha rihbi nincacoinxonma bi? —jato Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jaa pecaho sca ta Galilea mai meha hian pohquejaqueti Jesus canishqui. Tiberias cahen jaa hiaman jane huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Papan coshiyaxon hisinaibo Jesusen rohajahi jisxon hichaxon Jesus chibancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mahchi manichish jano jahuen haxenicabo betan Jesus tsahopaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judiobaan pascua fiesta nea pishca sca jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jari jisxon hihti caibo hahqui jahui meraxon Felipe yocaquin: —¿Jahuerahnon non piti marotihin jaabaan pinon? ");
INSERT INTO kaqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Felipe tananoxon ta jascajanishqui, jaanbi piti caijanoxon bi yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jaatian: —Doscientos libras non jai bi ta hahan paan marohah jato jatihixonbi piti senentimahiqui, hexti pishca cohren huesti hinanah bi —Jesus Felipenin jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Huetsa rihbi jahuen haxenica jahui, Andres, Simon Pedron huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Neno ta beronan jaiqui. ¿Pichca cebada paanya rabe tsatsa rihbi jan jai bi hen neatihi noquebo janon bi jaa jahuejatiquin? —Jesus jaquin Andresnin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Jato tsahopaquemanahue —Jesusen jaquin. Hani pasto jano jaiya, jano tsahopaquecani. Bebobo rahsi toponah ta cinco mil joni janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jaatian jaa paan pishca bihxon Papa yocaxon tehcaxon tsahotaibo Jesusen hinanpaquequin. Tsatsa sca jascajaribiquin jaabo queenai tihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yaniscaiboya: —Texejaha teque romishin tsinquitannahue, jahuabi yohyocohyamanon —jahuen haxenicabo Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jascajaha tsinquicanquin. Pichca cebada paan pihibaan texejahi tequebo tsinquixon, doce tasa bohasacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jascajaquin Papan coshiyaxon jan hahcai jisish: —Nea coin ta Papan joi yohinica main joyaxihqui yohicanpahonishqui —hihqui pihi tsahotaibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jaton quiquin hapo sca hihnon jaa bichi jocatsihquibaan bi honanscaax mahchi janin jaa huesti Jesus caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bepiscaiya jaton nonti janin jahuen haxenicabo nihpaqueti cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","18","Nontin nanetax Capernaum quiri pohquejahqueti cahi. Yamescaiya jato qui Jesus joriyamahi bi nihuen coshin behchonjaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Basi huina huinaxon yame jisíbaan bi hahchon hian benichi Jesus jahui, nonti hochoma sca. Hian benichai merahax rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Rahtetaibaan bi: —Hea ta hen qui, raqueyamanahue —hihqui Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jaatian nontin nanemacatsihquibo bi nococahinscacani, jano jan cahi hoque quexa. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Xaba paquescaiya cahen hoque quexa banetipibaan benahah bi Jesus yamascai. Jahuen haxenicabo betan ta Jesus naneyamahipishqui. Jaabo rahsibi nontin cahi tah non jisipiqui. Jaa huesti nonti res ta jaipishqui, huesta yamahi. ¿Jahuenrahnon Jesus cahipishquin? hihxon benahahbo bi yamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Janoxon jan Papa yocaxon jato paan pimahipi hochoma sca Tiberias janinhax jahui nontibo nocoti. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jahuen haxenicaboyabi Jesus xahbanjahax, hahan behibo nontin sca nanetax, Capernaum janin jahui becani, Jesus benahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pohquequihrani joxon Jesus meraxon yocacanquin: —¿Jahuentian min neno jahuequin, maestron? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—Yohicoin ta hen mato jai: Papan coshiyaxon hen mato hahxonai jisipixon bi tah man jaa copima hea benahi. Paan pihi yanitipixon copi tah man hea benahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Queyonica piti copi teeyamanahue. Jahuentianbi queyoyamanox manatai piti copi teenahue. Noquebaque hihxon hen hinanyaxihqui piti ta jascapah qui. Hea jascapa hinannica man honannon hihxon ta jahuen shinanyaxon hen hahnon Papan hea hinanihqui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jan jascahiya: —¿Jahueja non jatihin, Papan tee hahnoxon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Papan raanai joni nincacointi ta jaa tee qui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—¿Jahua hahan honanti min hahcain, jisxon non nincacoinnon hihxon? ¿Jahueja min jain, Papan shinanyaxon? ");
INSERT INTO kaqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Cahchihoxon ta noquen xenibaan maná piti pipahonishqui. Jaa yohihi ta Naihoh queha piti ta jato hinannishqui, pihabo, hih Papan huisha janin jaiqui —Jesus jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Mato tah hen yohicoinai: naihoh queha piti ta Moisesnin mato hinanyamanishqui. Heen papan caya ta mato naihoh queha piti coin hinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jaan hinanai piti ta naihoh quehax botopaquetihqui, jaa pihax jihuetahbo —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Jascapa piti noque hinanquin jeneyamaxahnhue, Hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Hea ta hen hahan jihueti piti qui. Hehqui jahuibo ta picatsihyamascatihiqui. Hea nincacoinaibo ta jiricatsihyamascatihiqui, jahuentianbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hea jisxon bi tah man nincacoinyamahi hah cah hen mato jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Heen papan hea hinanai tihibi ta hehqui joti qui. Hehqui jahuibo tah hen potatimahi, ni huestibi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hea queenai quescajahi tah hen joyamaniqui. Hea raanni queenaijahi tah hen naihoh quehax botopaquetax joníqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni huestibi manomaxonma tah hen jan hea hinanai jatihibi hean hueniyaxihqui nete queyoscanon. Hean jascajati ta hea raanni queenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jahuen baque jisxon jaa nincacoinaibo queyoyamanox manati ta heen papa queenihqui. Nete queyoscanon tah hen jato hueniyaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jan jascahiya judiobo hahqui renren renreni. Naihoh quehax botopaqueni piti ta hea qui jan jaiya hahqui rainyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Nea Jesus janeya joni Josepan baquema hin? ¿Jahuen papa, jahuen mama non honanyamahin? ¿Jenquetsahaquin sca Hea tah hen naihoh quehax paquenihqui hah noque jaiquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jaatian: —Mato rahsibi yohuani renren renrenyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Heen Papan Johue hahca ta hehqui jahuibo jahuiqui. Jan Johue hahyamaha cahen joti hahtipahyamahan. Hehqui jahuibo tah hen hueniyaxihqui, nete queyoscanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Papan honanmahibo rahsi ta jatihiqui; jascajaquin ta Papan joi yohinicabaan huishanishqui. Heen papa yohuanai nincaxon honanaibo jatihibi ta hehqui jotihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tsoanbi noquen Papa jisyamani que bi ta Papa janinha huestichin jaa jisnicah qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hihcoinja ta hen mato jai: nincacoinaibo ta jahuentianbi queyoyamanox manatihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hahan jihueti piti ta hea qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Cahchihoxon maná piti pihax bi ta maton xenibo mahuanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Naihoh queha piti pihax tah man mahuayamascatihi. Jascapa piti ta naihoh quehax botopaquetihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naihoh quehax botopaqueni piti mohitahpa ta hea qui. Jascapa piti pihax tah man queyoyamanox manascatihi. Hean hinanai piti ta heen yora qui. Mai mehabo jihueyaxahnon tah hen jato hinanai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","—¿Jenquetsahaxon noque jahuen yora hinantihiquin, non pinon? —hihquish jaabo rahsibi judiobo join bahchinnanscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Join rehtenanaiboya Jesusen jato yohiquin: —Yohicoin tah hen mato jai. Noquebaquen yora piyamaxon jahuen jimi rihbi xehayamahax tah man jihueyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Heen yora pixon heen jimi rihbi xehahi noque ta queyoyamanox manatihqui. Jaabi rihbi tah hen hueniyaxihqui, nete queyoscanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Heen yora ta piti coin qui. Heen jimi rihbi ta xehati coin qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Heen yora pixon heen jimi rihbi xehahi tah man heen hahberabetibo qui, hea rihbi maton hahberabeti. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Heen papa ta jihuetihqui. Hea ta raannishqui. Hea jaa copi jihuetai quescarihbi ta hea pihibo jihuetihiqui, hea copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jascapah ta naihoh quehax botopaquetai piti qui. Noquen xenibaan piti pihax bi mahuanih quescayamahi. Nea piti pihax queyoyamanox manati, jascabi sca jihuenox manati, —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum janin haho tsinquiti xobohoxon ta Jesusen jato jascajaquin yohinishqui honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jan yohuanai nincaxon: —Honantima tah qui, jan yohuanai. ¿Tsoan nincatihiquin? —hihqui hicha jahuen haxenicabo. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jahuen haxenicabo hahqui renren renrenai jahuen jointinin honanxon jato yocaquin: —¿Hen yohuanai nincacax man rahtetain? ");
INSERT INTO kaqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Janohax hen joníton hen hahquirihbi hinahihnatai jisish cahran man hihti rahtetimahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dios Yoshiman ta mato jihuematihiqui. Maton yora betan res tah man jahua bihtimahi. Hen mato yohihi joi ta yoshinyahpa qui, hahan jihueti. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hahan jihueti joi hen mato yohihah bi tah man caibaan nincacoinyamahi —jato jaquin. Jato jismenoxon ta tsoabo nincayosmabohin Jesusen honannishqui. Paranxon jaa bihmayaxihqui joni rihbi honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—Jaa copi ta hen mato jascajahipiqui. Papan shinanyamahiya ta tsoabi hehqui jotimahiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jan jascaraiya ta hicha jahuen haxenicabaan jaa potabahinnishqui. Haxehi hahbetan nihyamascacani. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","—¿Maton rihbi man hea potabahincatsihquin? —jahuen doce haxenicabo Jesusen yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—¿Tsohqui non catihin nan, Hihbon? Mian tah min noque hahan queyoyamati joi nincamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mia Papan raanai jahuen caisti joni tah non mia honancoinai. Shinanquin sirijaquin tah non honanscai —hahquin Simoman. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—¿Mato doce hen caisyamanihquin? Mato quiha huesti ta tiroma yoshin qui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jan yohihi ta Judas qui, Simon Iscariotenin baque. Jahuen doce quiha hihxon bi Jesus bihmati shinanai joni. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jascahipish Galilea mai janin res Jesus nichi. Judea main nihcatsihyamascai, judiobaan rehtecatsihquiya. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Judiobaan tapasohoxon fiestajati nete nea pishcascaiya, jahuen huetsabaan Jesus yohiquin: —Nenohax Judea main carestanhue, janoxon min hahcaibo miin haxenicabaan rihbi jisnon. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sirijaquin jisíbo hihxon ta jonexon tsoanbi jahuejayamahiqui. Papan coshiyaxon hahan honanti hahcatsihquin janibixon hahhue, jatihixonbi jisquin sirijahabo —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nincacoinyamaxon copi ta jahuen huetsabaanbi jascajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesusen sca jato yohiquin: —Caritima pari tah hen jai. Mato caya botannahue. Jahua copi hea manatima tah man jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mato jistahihmajati ta mai mehabaan hahtipahyamahiqui. Jaabaan tiromajahi hean hihcoinjaquin yohihiya ta hea jistahihmajacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Fiesta janin botannahue, mato. Caritima ta hea jai. Queenax ta hea catihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jato jascajaquin yohihax, Galilea main banetahbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jahuen huetsabo fiesta janin cahipi sca jaa rihbi cahi, caibaan jisnonma sca, janibima. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jonetax cahi bi fiesta janinxon judiobaan jaa benaquin: —¿Jahuen jaa quin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hihti caibo jaya baxex baxexi. —Siri joni tah qui —hihqui caibo. —Sirima ta qui. Jonibo ta paranihqui —hihqui caibo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judiobo qui raquetax tsoabi coshin jaya yohuanyamahi, honahaxbi yohuancani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta naexbi sca Papan xoboho mapexon Papan joi Jesusen haxemaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jan jascahiya rahtetax judiobo yohuani: —¿Jenquetsahaxon neatohon huisha joi honanishquin tsoanbi quirica honanmanima bi? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jascahiton Jesusen yohiquin: —Hen jato honanmahi ta heen joima qui. Hea yononihton joi tah qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Papan shinanaijati hahcatsihquibaan ta honantihiqui. ¿Papan shinanaiya honanma hen jain? ¿Heanbi shinanxon honanma hen jain? Jaabaan ta hen yohuanai honantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Coshi joni hihqui shinanahbo hihquish ta jaabaanbi shinanax yohuanaibo jaiqui. Hea raanai heen Papa coshi hihqui honanahbo hihquish tah hen hea yohuanai. Jascapa yohuannica ta hihcoini yohuannica qui. Jahuabi tiroma yohuanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Maton nincati joi Moisesnin hinanyamanishquin? Ni huestichinbi tah man jaa joi nincayamahi, jaan hinanni que bi. ¿Hean mato jahua hahca man hea rehtecatsihquin? —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Mia rah ta yoshiman hihbojahiqui. ¿Tsoan mia rehtecatsihquiquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusen jato yohirihbiquin: —Hen hahcai huesti jisish tah man jatihibi rahtetai. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jaanbi shinanxonma bi noquen xenibaan pari yohihah ta Moisesnin mato honantiyahpati yohinishqui. Tantiti netenbi tah man baquexo honantijahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisesnin yohini quescajacatsihquin tantiti netenbi joni huetsa honantijanicaboxon ¿jahua copi sca man tantiti neten hean huetsa joni rohajahiya man hehqui rainyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Beron jisxon res huetsa jonin shinan honanti shinanyamanahue. Shinanquin sirijaxon pari joni huetsa honannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jasca jan jaiya caibo Jerusalen janinhahbo yohuanscai: —¿Neama hin, rehtecatsihquibo joni? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jistan. Janibi nichish yohuanai bi ta jahua hihyamacanihqui. ¿Cristo hihqui noquen cacannicabaan honancoinscaiquin? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Janobihax nea joni jahui tah non honanai. Cristo joni jahuiya roqui tsoanbi jahuerahnohax jaa jahuiquin hihxon honanyamayaxihcanihqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jaa copi cahen Papan xobohoxon jato haxemahi sca Jesus coshin yohuani: —¿Hea man honanain nan? Janobihax hea joní man honanrihbihi nan? Hehme mehax ta hen joyamaniqui. Hihcoinnicahton ta hea raannishqui. Jaa tah man honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hean tah hen jaa honanai. Jaan hea raanah ta hen jaa janinhax joniqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jasca jan jaiya xecotancatsihxon bi jaa bihxon rehteti siriyamaparihiya tsoanbi meheyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Rehteti shinan caibaan jai bi hicha noquebaan Jesus nincacoinquin. —Neatohon ta hahan honanti hahquiqui, hicha. ¿Cristo joxon, neatohon hahcai quescajaxon bi hashoan hicha rihbi hahan honanti hahtihiquin? —hahcanquin ");
INSERT INTO kaqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jascari baxexaibaan bi fariseobaan nincaquin. Nincaxon, sacerdote hapobo betan fariseobaan sca jaton porisiabo raanquin, Jesus bihtannahue hahxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Bihcatsihscaibo copi cahen jato yohiquin: —Basima tahni sca tah hen mato betan hihtihi. Hea raanni janin sca hea cati ta hochoma sca qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hea benaxon bi tah man hea meratimahi. Hea cahi janin tah man cati hahtipahyamatihi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jaabo rahsibi sca judiobo yohuani: —¿Jahuenbi cacatsihquiquin, non jaa merayamascanon? ¿Nahuabo qui caníbo janin cacatsihquiquin, nahuabo sca honanmahi? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Benaxon bi tah man hea meratimahi jan hihqui bi jahua hihcatsihquiquin? Hea cahi janin tah man cati hahtipahyamahi. ¿Jan jascari yohuani hen jahua hihcatsihquiquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hahan fiesta queyotai neten, jaton hani netenbi, nichish Jesus coshin yohuani: —Jiricatsihquish hehqui benahue, xehahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hea nincacoinai joni janinhax ta jene mohini huean bahihihcamaxihquiqui, jahuen jointi janinhaxbi, Papan huisha joi jai quescari —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jan jene yohihi ta Dios Yoshin qui, nincacoinaibaan bihyaxihqui Dios Yoshin. Jesus huenihihniriyamaxon ta jahuen yoshin Papan hinanyamaparinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jan jascari yohuanai nincacax tsinquijaquetaibo yohuanrihbihi: —Nea coin ta Papan joi yohinica qui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—Noquen hapo hihnon Papan caisai joni tah qui —hihqui caibo rihbi. —¿Galilea mai janinhax Papan caisai joni jotihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","David xohtahax ta David jihuepahoni janinhax Papan caisai joni picotihiqui, Belen jema janinhaxbi. ¿Jascayamahin, Papan huisha joi janin? —hahcanquin caibaan rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jascapa mesco shinanyahpabohax join bahchinnanscacani. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Caibaan Jesus xecotancatsihquin bi tsoanbi meheyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jano sacerdote hapobo betan fariseobo manatai janin jaton porisiabo nocorihbihiton yocacanquin: —¿Jenquetsahpa hin man hihueyamahahquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Tsoabi ta jan yohuanai quesca jayamanishqui, jahuentianbi —hihqui jaton porisiabo sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—¿Mato rihbi jaan paran paranaxquin? ");
INSERT INTO kaqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maton hapobaan ni huestichin jaa nincayamahi ¿man jisyamahin? Fariseobaan rihbi ta jaa nincayamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nea tsamatai rahsi ta yohitimabo qui, Papan huisha joi honanyamahibo —jato jacanquin fariseobaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo janeya Jesus qui johuanni joni jato betan hihxon jato yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Huetsa joni yohuanquihnxonma bi, jan hahcai rihbi honanxonma bi non jaa casticantihin? ¿Papan huisha joi janin jascajati joi jaiquin? —jato jaquin Nicodemonen. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—¿Mia rihbi tsi ra min Galilea mai meha quin? Papan joi jisquin sirijaxon, Galilea mai janinhax Papan joi yohinica jotima honanhue —jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Janohax picotax, jatihibi jaton xoboho bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Olivoyahpa mahchin sca Jesus cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hihari sca Papan xoboho cahi. Jano sca roqui hahqui jatihibi joni tsinquitaiton tsahoxon jato yohi yohinish. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jan jato haxemahiya qui jaton haxemanicahbo betan sacerdote hapobaan qui huesti haibo hihuequin, joni huetsa betan hihqui qui meraxon. Jato tocan jaa nichinxon qui Jesus yocacanquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Joni huetsa betan hihqui bi tah non nea haibo merahahqui, maestron. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Huishaxon ta Moisesnin yohinishqui, nescapa non macaman tsacaquin rehtenon. ¿Mian cahran? ¿Jahua min mian yohihin? —hah qui jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jaton hapobo yohinoxon qui Jesus tanaquin jascajacanquin, hahqui yohuanti qui janon. Jasca jaabo jaiya qui cahcopaquexon qui jahuen metotinin mai huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jascabi yocacahbo qui huenixon qui jato yohiquin: —Hohchajomaxon mato janinha huestichin macaman tsacamenonon —hah qui jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cahcopaquerihbixon qui mai huisharihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jan yohihi nincacax qui yosibobo rahsi pari cahi. Jaa pecaho qui huesti huestibo cahi, jaa xobo janinhax caini. Jesus patax haibo huesti qui banenon. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Huenixon qui haibo Jesusen yocaquin: —¿Jahuen bocanaxquin? ¿Mia tsoanbi casticancatsihyamahiquin? —hah qui jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Tsoanbi hihbon —hihqui haibo. —Hean rihbi ta hen mia casticanyamahi. Caresscatanhue. Jahuentianbi hohchayamascahue —hah qui jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Huetsa tian rihbi ta Jesusen jato yohinishqui: —Jatihibi main ta hen hean jato xabajaxonai. Hea chibanaibo ta bahquish chian nihyamahiqui. Hahan jihueti xabapan sca ta mayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jan jascajahiya: —Mianbi shinanax tah min yohuanresai. Chanicoin tah min jayamahi, noquen nincatima hih —fariseobaan sca hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesusen sca jato pontequin: —Jahuerahnohax jahuex jahuen sca hea catihin hen honanax yohuanai hen mato yohihi ta maton nincati qui, yohicoinai joi. Heabi yohihi hen yohuanai bi tah man nincacointi jai. Janohax jahuex hea jahuerahnon cahin man tah man honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Beron res jisxon tah man joni huetsana jahuen shinan honanti shinanai. Jascajaquin shinanxon tah man casticannoxon Papan rahuibo yohiti shinanai. Hean ta hen tsoabi jascajaquin yohiyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yohixon tian tah hen hahcoinquin yohitihi. Hea raanni heen papa betan tah hen jaton shinan honanai, hea huestichin yohixonma bi hahbetanbi yohixon. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Maton nincati joi janin ta nescapa huisha jaiqui. Rabechin yohihah pari ta yohuan coin qui, nincati. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Rabe tah non qui hah ca hen mato jai sen. Hea yohihi heabi hihqui bi ta hea raanni heen papan rihbi hea yohihihqui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jaatian: —¿Jahuen hin, miin papa? —hahcanquin. —Hea honanyamaxon tah man heen papa rihbi honanyamahi. Hea honanxon cah man heen papa rihbi honanan —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Janoxon Papa Dios coriqui hinanti chiquehoxon ta Jesusen jato jascajaquin yohinishqui, Papan xobohoxon honanmaxon. Jahuen mahuati hora nocorihyamahiya tsoanbi meheyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jahuen Papa honanyamahibo copi jato hahquirihbi yohiquin: —Hea tah hen cahi. Hea benahax bi tah man maton hohchayabi mahuatihi. Jano hea cahiton tah man catimahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nincaxon bi honanyamahax sca: —¿Jano hea cahiton tah man catimahi hihquish bi hahri rehtécatsihquiquin? —hihcani judiobo. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—Mato tah man naman mehabo qui. Hea tah hen bochiquiha qui. Mato tah man nea xabapan meha qui. Hea tah hen nea xabapan mehama qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jaa copi tah hen Maton hohchayabi tah man mahuatihi hah hen mato jaahqui. Hea hihqui shinanyamahax tah man maton hohchayabi mahuatihi —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jan jascajahiya: —¿Mia min jahua quin? —hahcanquin. —Jaa yohi tah hen mato jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mato qui yohiti ta hen hicha jai. Mato casticanti rihbi tah hen hicha jai. Man tiromahibo bi ta hea raanni hihcoini yohuannica qui. Jan yohuanai nincaxon ta hen jaa joi rihbi main jihuetaibo yohihi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jahuen papa yohihi jan hihqui bi ta honanyamacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Honanyamahiton Jesusen yohiquin: —Hea noquebaque jihuin hueonxon pari tah man hea hihqui honantihi. Hehmebi jahuejaxonma bi papan hea yohini joi rahsi yohi hen jai tah man honantihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hea raanni noque ta hehbe hihquiqui. Jaa queenai quescajaquin hen jai copi ta hea jeneyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jascajaquin jato yohihah hichaxon nincacoincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nincacoin ta jai hihquibo judiobo sca Jesusen yohiquin: —Heen joi jascabijaquin nincacax tah man heen haxenicabo jacointihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hihcoin hen jani quen tah man honantihi. Jaa honanax tah man hinabomascatihi —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Noque tah non Abrahanen baquebo qui. Tsoanbi ta noque hinajayamanishqui, jahuentianbi. ¿Jenquetsahpahin min noque Hinaboma sca tah man jatihi min noque jain? —Jesus jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jascaraiton jato yohirihbiquin: —Yohicoin tah hen mato jai. Jatihibi hohchataibo ta hina qui, hohchapan hihbojahah. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hina ta xoboho jascabihi jihue jihueyamahihqui. Xobo hihbaan baque res ta jano jihuenica qui, queyoyamanox mana jihueti. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Papan baquen mato hohcha sohuaxona tah man hihcoini hinabomascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahanen baquebo man jai tah hen honanai. Jahuen baqueboxon bi tah man hea rehtecatsihqui, maton jointi janin heen joi hihquicasquimahiya. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Heen papan hea jismahi ta hen mato yohihi. Maton rihbi tah man maton papan yohihi quescabijaquin hahcai —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Noquen papa xeni ta Abraham qui —hahcanquin. Jesusen sca: —Abrahanen baqueboxon tah man jahuen tee hahquehahnai. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hea tah man rehtecatsihscai, Papan hea yohihi hen mato yohicoinah bi. Abrahanen ta jascajayamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Maton papan tee tah man hahcai —Jesusen jato jaquin. —Noquen mama ta tsiniyamanishqui. Huesti res ta noquen papa qui, noquen papa Dios —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesusen sca: —Papa Dios maton papa hihquiya tah man hehon queenquehanai. Papa Dios janinhax jonish tah hen hea jahui. Hehmebi tah hen joyamaniqui. Jaan ta hea raannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jenquetsahpahin man hen mato yohihah bi man honanyamahin? Heen joi nincayosmaboxon tah man honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tiroma yoshin ta maton papa qui. Jaa queenai hahti res tah man maton rihbi shinanai. Noquebo jamenohitian rehtemis hihnish ta rahma caman jascabi rehtemis qui, maton papa. Jaabiyahpa quesamisax, jascabihi quesahi. Quesa hihxon ta caibo sca quesamaribihiqui. Hihti quesa, maton papa. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hihcoini yohuan hen jai copi tah man nincacoinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tsoan man hea heen hohcha yohitihin? ¿Jenquetsahpahin man hea hihcoini yohuanai bi man hea nincacoinyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Papan baquebo ta jahuen joi nincanicabo qui. Jahuen baquemaboxon tah man nincayamahi —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jan jato jascajahiya: —Mia tah min Samaria mai meha qui. Yoshiman ta mia hihbojahiqui. ¿Hihcoinja non mia jayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jascahahbo jato Jesusen yohirihbiquin: —Yoshiman ta hea hihbojayamahiqui. Heen papa qui tah hen siripi yohuanai. Mato tah man hehqui tiromahi yohuanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hehqui siripi yohuanaibo benahi ta hen joyamahi. Jatihibi shinan honannica ta jaiqui. Jaan ta mato yohihihqui, hehqui siripi yohuanxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hihcoinja ta hen mato jai. Heen joi nincacai jonibo ta mahuayamanox manatihqui —jato Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Mia yoshiman hihbojahi tah non honanscai. Abraham ta mahuanishqui. ¿Papan joi yohinicabo rihbi hihni que bi min jascarain, Heen joi nincacai noque ta mahuayamanox manatihqui, hihqui? ");
INSERT INTO kaqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mia min noquen papa yamanica Abraham mentan hashoan coshi quin? Papan joi yohinicabo rihbi ta mahuanishqui. ¿Jahua hihqui shinan mian jain? —Jesus jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jato Jesusen yohiquin: —Hehqui siripi yohuanaibo benaxon tah hen jahuabi bihtimahi. Heen papa ta hehqui siripi yohuanihqui, Jaa ta noquen Dios qui hih man jai que bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jaa man honanyamahi bi tah hen hean honanai. Mato quescapa quesamis hihquish pari ta hen Jaa ta hen honanyamahi hen jatihi. Jaa ta hen honanai. Jahuen joi rihbi ta hen nincacoinai. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hea neno joyaxihqui honanax ta maton papa yamanica Abraham jenimanishqui. Hea jahui jisish sca ta coin coinnishqui —jato Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jan jascaraiya: —¿Cincuenta bari jariyamaxon bi min noquen xohta yamanica Abraham jisniquin? —judiobaan Jesus jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Hihcoinja tah hen mato jai. Abraham cainrihyamahi bi tah hen hea janíqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jan jascaraiya, tsacanoxon macan bichibaan bi jonetax Papan xobo janinhax Jesus cainscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jano huinoxon benche joni jisquin, benche jahuen maman bihni. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jahuen haxenicabaan sca yocaquin: —¿Tsoa tsi ra hohchanishquin, Maestron, benche hoa jahuen maman bihnon? ¿Jahuen papabo nan? ¿Jaabi nan? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Jan hohchani copima ta qui. Jahuen papabo rihbi hohchani que ma bi tah qui. Papan coshiyaxon jaa rohajahi jisíbo ta benche jahuen maman bihnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hea raanni heen papan teebo jahti ta noque jai, bari queya parihiya. Tsoabi teeti hahtipahyamascanon ta yametihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mai mehabo tocan jihuexon tah hen jato xabajaxonai. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jascajaxon mai qui toshbanhahxon huaho berojaxon benche betsamxon yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Siloé janeya noaho benashitanhue —hahquin. Siloé ta raanah hihcatsihquiqui. Jascahah, cahax, benashitani joquin jisbenascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jan coriqui yocacahtai jispahonibaan sca yocaquin: —¿Neama hin, yoca yocaqui tsahopahoni joni? Jahuen hahbe jihuenihbaan rihbi jascajaquin yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Jaabi ta qui —hihqui caibo. —Jaamahax bi ra ta jaa quescapih qui —hihqui caibo rihbi. —Hea tah hen qui —hihqui jaabi sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Honancatsihquin sca: —¿Miabi hihquish jenquetsahax min bero siriscaiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jesus janeya jonin huaho berojaxon heen bero qui betsamxon hea Siloé janin nashitanhue hahcah tah hen nashihi sca cahaqui jisresscanoxon —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Jahuen hin, jaa joni? —hahcanquin. —Hen ta hen honanyamahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Benche hihpahoni joni fariseobo janin sca bocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tantiti neten cahen Jesusen huaho berojaxon jahuen bero rohajanish. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseobaan sca yocarihbiquin: —¿Jenquetsahaxon miin bero rohajaxquin? —hahcanquin. —Jaan heen bero qui huaho tsamanah benashixon tah hen jisresscai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Papa Diosen raanahma tah qui. Tantiti neten jan tantibahinayamahi copi tah non honanai —hihcani caibo fariseobo sca. —¿Jenquetsahaxon hohchayahpa jonin jascapa hahan honanti jatihquin? —hihcani caibo rihbi. Caibo huetsa shinanya hihnon caibaan rihbi huetsa shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Benche hahquirihbi yocacanquin: —Mia ta bero rahonaxqui. ¿Mian jisi jenquetsahpa joni quin? —hahcanquin. —Papan joi yohinica tah qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jan benche hihpahonixon bi rahma pari jisi judiobaan nincacatsihyamahi. Hihcoinai shinanyamacanquin. Jahuen papa, jahuen mama yocarihyamaxon hihcoini jaa yohuanai shinanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Nea hin, maton baque, benche ta cainnishqui hih man jain? ¿Jenquetsahaxon sca rahma jisiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jascahah: —Jaa ta noquen baque qui, non tah non honanai. Jan benche cainni tah non honanrihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jenquetsahaxon jan rahma jisiquin, non tah non honanyamahi. Tsoan jahuen bero rohajaxquin, non tah non honanyamarihbihi. Jaabi yocanahue. Hani sca ta jaiqui, jaanbi ta mato yohitihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judiobo qui raquexon jahuen papan, jahuen maman jascajaquin. Judiobaan cahen jatihixonbi yohinish, Cristo tah qui hihquibo jatihibi tah non potati jai, noquen tsinquiti xoboho mapeyamascaábo, tsoanbi jato yohuanquihnyamascaábo tah non jato potatihi, hahcanquin huesti shinanyaxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Judiobaan jascahipi copi raquetax: —Jaa ta haniscai qui. Jaabi yocanahue —hihresi jahuen papa. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jascaraiya, rabe coti sca benche jahuen maman bihní joni hahquirihbi quenamacanquin. —Papa Diosen caya ta hea rohajahaxqui hihhue. Hoa joni ta hohchamis qui, non tah non honanai —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Jahuen hohcha yamahihquin, hen ta hen honanyamahi. Nea res ta hen honanai: benchepahonixon bi ta hen rahma jisi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Jahueja mia jaaxquin? ¿Jenquetsahaxon mia jismahaxquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Moa ta mato yohihahqui. Hen yohihah bi tah man nincacatsihyamahahqui. ¿Jahua copi man hahquirihbi nincacatsihquin? ¿Mato rihbi man jahuen haxenicabocatsihquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jaa sinajascacanquin: —Mia tah min jahuen haxenica qui. Noque tah non Moisesnin haxenicabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Papa Diosen ta Moises yohinishqui, non tah non honanai. Jahuerahnohax hoa joni jonishquin, non tah non honanyamahi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jaabo jascaraiya: —Man jascaraiya tah hen rahtetai. Jahuerahnohax jaa jonishquin man honanyamahi bi ta hea bero rohajahaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hohchamisbo ta Papan nincayamahihqui. Jaa tah non honanai. Papahon shinancoinaibo, Papa queenai quescajahibo, jascapahbo ta Papan nincaquihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tsoanbi ta benche cainni joni bero rohajayamanishqui. Benche rohajahi ta tsoan jascajanima qui, nete jamenoni tian, rahma caman. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Papa Dios betan hihyamaxon cahen Jesusen jahuejatibi hahtipahyamaquehaniqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Mia tah min hohchaya bi res piconihqui. ¿Jascapahxon bi min noque honanmacatsihquin? Catanhue —hahxon picocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Catanhue hahcaibo joi nincaxon benche hihpahoni meraxon Jesusen yocaquin: —¿Noquebaquen yohihah min nincacoinyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Tsoa jaa quin, hapon, hen nincacoinnon? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Hea min jisi tah hen qui, mihbetan yohuanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Hean tah hen nincacoinai, hihbon —hihxon raboxonen nichish betihihpaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Honanahbo tah hen naihoh quehax joniqui, jisyamahibaan jisíbo, jisibo rihbi benche sca banenon —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jan jascajahi caibo fariseobaan hochomaxon nincaxon yocacanquin: —¿Noque rihbi non benche quin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Benchehax tah man hohcha yamaquehanai. Non tah non jisi man jai copi ta maton hohcha banetihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Hen mato yohinon nincanahue. Carnero chiqueho hihquicatsihquish xehpoti janinma bi huetsanco hinatax hihconica ta yometsoh qui, bichinmis joni. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Xehqui janin hihconica ta carnero coirannicah qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jan hihconon ta xehpoti coirannicahton quehpenxoniqui. Jahuen carnerobaan rihbi ta jahuen joi nincaquihqui. Jaan rihbi ta jaton jane quenapaquexon jato cainmahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jahuenah rahsi jatihibi cainmaxon ta jato beboxoniqui. Jaton hihbaan joi nincaxon ta carnerobaan chibanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Huetsa joni cahen chibanyamacanquin, jahuen joi honanyamaxon. Jato bichi huetsa jahuiya cahen jabarescani —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Honanahbo jato jascajaquin yohihah bi nincayamacanquin. Jan yohuanai honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jaa copi jato hahquirihbi yohiquin: —Man honannon hihxon tah hen yohihi: hea tah hen carnero jano hihcoti quescapa qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Hea joriyamanon joníbo ta yometsohbo qui, bichinnicabo. Carnerobaan ta jato nincayamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Hea tah hen jano hihcoti quescapah qui. Hea janin hihcohibo ta queyoyamanox mananicabo qui. Hihcohax ta picorihbihihqui, jaton piti rihbi pishinyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yometsohti res ta yometso jahuiqui. Rehtehi rihbi jahui. Masajahi rihbi jahui. Jihuetahbo tah hen hea jahui, siripi jihuetahbo. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hea ta carnerobo coirannicah siri qui. Siri coirannicahton ta jahuen carnerobo jeneyamahihqui, rehtehibaan bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jahuenah que ma bi carnerobo coirannon hihxon copijaha jonin cahen hino jahui jisish carnerobo potabahini caresi, coirannicah hihyamahax copi. Hinon sca cahen hahchixon jato jabisjaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Coriqui copi coiranhue hahca bi cahen joni jabatih, carnerohon shinanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Hea tah hen carnero coirannica siri qui. Henabo tah hen hean honanai. Henabaan rihbi ta hea honanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Heen papan hea honanai quescajaquin tah hen hean rihbi heen papa honanai. Carnero mahuayamanon hihxon tah hen paxajaquin hehri jaton sinatahbo hean rehtemahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hea ta huetsa carnerobo jaribihi, nea chiquehoh quehama. Jaabo rihbi beti tah hen jai. Heen joi ta nincayaxihcanihqui, huesti repinica res janon, coirannicah rihbi huesti res. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Hahquirihbi teehihnoxon tah hen heen jihuetahbo jihuenon hihxon jaton sinatahbo paxajaquin hehri rehtemahi. Jaa copi ta heen papan hehon shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tsoanbi ta hea rehteresyamahiqui. Heanbi shinanxon tah hen hehri jato rehtemahi. Heanbi shinanax ta hen hahquirihbi teehihtihi, jascahue heen papan hea janí —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jan jascajaquin yohihah, caibo judiobo huetsa shinanya janon caibo rihbi huetsa shinanya hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mesco shinanya hihquibaan bi hichaxon caibaan yohiquin: —¿Jahua copi man hashoan nincatihin? Yoshinyahpa tah qui. Tehquehih ta jaa jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—Jan yohihi joi ta yoshinyahpa joninahma qui. ¿Yoshiman benche jismati hahtipahiquin? —hahcanquin caibaan rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jene tian sca jaiya cahen Jerusalen janin judiobaan fiesta jai, Papan xobo jato behnajaxonnihbo copi fiestajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jaa xoboho sca Jesus nichi, Salomon janeya chiquehoh. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hahqui tsinqui jaquexon yocacanquin: —¿Jahuentian caman min noque honancasquimamatihin? Cristo hihxon, Hea ta hen Cristo qui hahquin noque yohiquin sirijahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Moa hen mato yohihah bi tah man hea quesahi shinanai. Heen papan hea Jascajahue hahca hen hahcaibo ta jaa jisxon hahan hea honanti qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jaabi tah man nincayamahi, heen repinica janinhahmaxon copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hean quenahah ta heen carnerobaan hea nincaquihqui. Hean rihbi tah hen jato honanai. Hea ta chibancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Hean tah hen jato teehihmahi, queyoyamanox mananon, jahuentianbi manoyamanon. Heen mequeman hen xecohibo ta tsoanbi hea bichintimahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Heen papan ta hea jato hinanihqui. Jaan ta jatihibi mahuinihqui. Jaan xecohi ta tsoanbi mebichintimahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Heen papa betan tah hen huesti yora qui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judiobaan sca ta macan bihribinishqui, Jesus rehtecatsihquin hahan tsacanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Macan bichiton jato yohiquin: —Hen hicha siri hahcaibo tah hen mato jismascai, Papan hea Siribojahue hahcah. ¿Jahuemeha hen hahcai copi man hea rehtecatsihquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Min siribo hahcaima bi min Papa Dios qui tiromahi yohuanai copi rahan. Mia jonihax bi Diosax quescapi yohuanai copi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesusen sca: —¿Davidinin huishani joi janin nea huisha yamaquin? ¿Mato tah man diosbo qui hah ta hen mato jai hahquin huishayamanishquin? ");
INSERT INTO kaqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Papan huishamani ta tsoanbi huetsajati hahtipahyamahiqui. Jato yohihi Mato tah man diosbo qui Papa janí que bi man hehqui rainyamascain? ");
INSERT INTO kaqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Hea ta hen Papa Diosen baque qui hen jai copi man Dios qui tah min tiromahi yohuanai hah man hea jain? Baquen hahxon Papan hea naihohxon raanni que bi ¿man jascarain? ");
INSERT INTO kaqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Heen papan teebo hean hahyamahiya hea hihcoinai shinanyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hen hahcoinaiya, hean mato yohiha copi que ma bi hean hahcai jisxon copi hihcoinai shinannahue. Jascajaquin tah man honanxon nincacointihi, hea janin heen papa hihqui, hea rihbi heen papa janin hihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jascahiton jaabaan hahquirihbi bihcatsihqui bi cahi, mequen sca cahabo. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jaatian sca cahax Jordan huean hahquirihbi pohquejaquetax, janoxon Juaman nashimamenoni janin cahi. Cahi nocotax janobi sca baneti. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jano sca hihqui honanax ta hihti caibo hahqui nocoti bocannishqui. —Juaman ta hahan honanti hahyamanishqui. Hahyamahax bi ta hihcoini nea joni qui chaninishqui, jatihibi jan yohini quescabi ta nea Jesus jaiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Janoxon sca hichaxon nincacoincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania jema janin ta Lázaro janeya joni jihuepahonishqui, jano María jahuen hohshi Marta betan jihuetai jeman. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jaa Marianen ta hahan hinintinin noquen hihbo tachixon jahuen boon tasonishqui. Jahuen roha cahen Lázaro. Lázaro cahen hihti hisini. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hisinaiya ta jahuen chocabaan huetsa joni raannishqui: —Min hahan shinanai joni ta hisinihqui, hihbon —yohihi canon. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yohiha Jesusen yohiquin: —Mahuanoxonma bi ta hisinihqui. Papa Dios nete hihbohi jisibo ta hisinihqui. Hea Papan baque xaba hihbohi honanahbo ta hisinihqui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jaabo ta Jesus hihti queenpahonishqui, Marta, jahuen huetsa, Lázaro rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jan hisinai honanax bi janobi rabe neten hihribihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Rabe neten hihxon sca jahuen haxenicabo yohiquin: —Judea main hahquirihbi canon bonahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jascahah: —¿Rahma pishca mia janohahbaan macaman tsacaquin rehtecatsihquipi que bi min hahquirihbi caribicatsihquin, Maestron? —jahuen haxenicabaan Jesus jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—¿Huesti neten doce hora yamahiquin? Bariyahpan nichish tah non joxcorohyamahi, bari xaba jisish. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yame nichish tah non joxcorohtai, jano nihti jisyamahax —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jato jascajaxon: —Noquen huetsa Lázaro ta hoxahihqui. Mohini tah hen cahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Hoxahax ta hahquirihbi rohatihiqui, hihbon —hahcanquin jahuen haxenicabaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lázaro mahuatipi Jesusen yohihi bi hoxaresai shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jaa copi ta jato sirijaquin sca yohinishqui: —Lázaro ta mahuatipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jahuerohahi tah hen hea jano hihyamahipiqui, man honancoinnon. Man nincacoinnon hihquish ta hen jano cayamahipiqui. Jaabi, jisnon bonahue —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—Noque rihbi canon bonahue, hahbetan mahuanoxon —hahquin Tomasen, rabe nane hahcaibo Tomasen. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nocoxon sca chosco neten sca tsahonipibo yohihibo Jesusen nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ta Jerusalen hochoma qui, media hora tahen cahah. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jaa copi ta janohax hihti caibo judiobo Marian xoboho bocannishqui, jano Marta betan María jihuetai xoboho. Jaton roha mahuatipi quen manahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus nocoti jahui yohiha jaa behchihi Marta cahi, xoboho María banenon. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Behchixon yohiquin: —Mia neno hihquiya ta heen roha mahuayamaquehanihqui, Hihbon. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jan mahuatipi que bi ta min Papa yocacai rahsi mia hahxontihiqui. Hen tah hen honanai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Roha ta huenirihbitihiqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Nete queyotaiya Papan noque Hueninahue hahca ta huenirihbiyaxihquiqui. Hen tah hen honanai —hihqui Marta. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesusen sca: —Hea ta jato hueninica qui, teehihmanicah. Hea nincacoinai joni ta mahuatax bi teehihribitihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jihuexon hea nincacoinai joni ta queyonox jascabi mahuatah jatimahiqui. ¿Mian min hea hihcoinai shinanyamahin? —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Hen tah hen mia hihcoinai shinanai, Hihbon. Mia tah min Cristo qui, Papan baque. Mia tah min naihoh quehax jonicah qui. Min hihcoinai tah hen shinanai —hahquin Martan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jascajaquin yohihax jahuen shara quenahi cahi. Nocoxon hexti pishca join jahuen shara yohiquin: —Honanmanicah ta nocoscaiqui. Mia ta quenamahiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nincacax, histon huenicahuanax, picotax cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jema janin cahen Jesus nocorihyamahi, jano Martan jaa behchitana janin banetahbahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria histon huenicahuanax picotai jisxon, Tsahon janin ta huinihi cahiqui hihxon jaa manahibaan chibanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesus janin María nocoxon, merahax, Jesusen tahe naman betihihpaqueti. —Mia neno hihquiya ta heen roha mahuayamaquehanihqui, hihbon —hahquin huaohihanan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jaa huaohihquiya hahbe jahui judiobo rihbi huinihiya, jahuen jointi hihti xecahihniquin. Masa shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Jahuen man tsahonipiquin? —jato jaquin. —Jisihue, hihbon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus huaohihscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Huaohihqui jisish: —Jise. Hahan ta hihti shinanihqui —hahquin judiobaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","—¿Benche jismahipixon cahra nea rihbi mahuayamanon rohajati hahtipahyamaquehahnipishquin? —hahcanquin caibaan rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus sca hahquirihbi jointi hihti xecahihnihax tsahon janin nocoti cahi. Tsahonxon macan champanin behpohipibo janin nocoti. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Macan janabohannahue —jato jaquin Jesusen. —Neatian ta pisiscaiqui, hihbon. Chosco nete sca tah qui jan hihquipi —hahquin Martan, yamanicaton chocan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—¿Hihcoinai shinanxon tah min noquen Papa nete hihbohi jistihi hen mia jayamahaquin? —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jaatian sca macan janabohancanquin. Bochiqui sca jisxon: —Papan, hen yocacah tah min nincacai. Hahxon tah min hea jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Hen yocacai tihibi tah min nincacai. Hen ta honanai. Jaabi, nea neno nichibaan nincanon hihxon tah hen mia yohihi, mian min hea raanni hihcoinai shinanahbo —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jascajaxon coshin bi res quenaquin: —Lazaron, picohue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jaatian sca hihquipi joni picoti. Jahuen mequen, jahuen tahe chopa quexen yabi yabihah, payoman rihbi bebepohipibo. —Pecanahue, jan nihtatahnon —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jan Lázaro teehihmahi jisxon María manahi jahui judiobaan sca hihti caiboxon nincacoinquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Caibo rihbi jaton hapobo yohihi bocani. Nocoxon, Jasca ta jaaxqui, hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yohihah sacerdote hapobo betan fariseobo tsinquiti, hapobo rahsi. —¿Rahma can? ¿Non jahuejatihin? Hoa jonin ta hahan honantijahiqui, hicha. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jan jascajaresnon non jahua hahyamahiya ta jatihixonbi jaa sca chibanyaxihcanihqui. Romanobo sca joxon ta noquen janoxon Papa Dios yocati xobo pohtastihiqui, noquen jihuetahbo rihbi ta noque bichinyaxihcanihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Huesti joni sca jato tocan nihinati, Caifas janeya joni. Sacerdotebaan hapo hihxon jato yohiquin: —Maton tah man jahuabi honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Huetsa jonibo jihuenon huesti joni mahuatah ta siri qui. Noquen jihuetahbo jatihibi queyoyamanon jascatihi bi tah man honanyamahi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hahmebi shinanxonma ta jascajanishqui. Jaa bari tian sacerdote hapo hihxon ta honanxonma bi jayaxihqui joi yohinishqui. Jaton caibo jihuenon Jesus mahuatihi yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jaton caibo res jihuetahbo Jesus mahuayamahi. Hocho hocho jihuetai Papan baquebo tsinquinoxon cahen Jesus mahuati, jato huesti yorajanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifas jascari yohuanipiya sca Jesus rehtenoxon yohinan yohinancani, jatihibi neten. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jaa copi ta judiobaan jisnonma sca jonetax Jesus nihnishqui. Janohax caresscai, chiponqui. Jano tsoa yamahi hochoma, Efrain janeya jeman sca nocoti. Jano baneti jahuen haxenicabo betan. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judiobaan pascua fiesta hochomascaiya ta hocho jihuetaibo Jerusalen janin bocannishqui. Jaton rishta sohuamahi bocani, janin pascua fiesta noconon hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nocoxon Jesus benacanquin. Papan xoboho hihquihax yohinancani: —¿Fiesta janin jaa jotimahiquin? ¿Jahua min shinanain? —yohihahnancani. ");
INSERT INTO kaqNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jasca jaibaan bi jaton hapobaan jato yohiquin: —Jano jan hihqui honanxon, noque yohinahue, non porisia bihmanon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua fiesta joti seis nete pishinaiya cahen Betania janin Jesus joribihi. Jano Lázaro jihuetai jema, mahuatipi que bi jan hahquirihbi teehihmahipi. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesus nocoscaiya pitijacanquin, hichaxon piti. Martan cahen jato piti metexxonquin. Misanxon Jesus betan pihibo tocan sca Lázaro tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Marian sca nardo hahan hininti pomo bocho bihxon Jesus tachiquin. Hihti copi, hahan hininti. Tachixon, jahuen boon sca tasoquin, jatihobi xobo hinin potonon. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jaatian sca jahuen haxenica Judas Iscariote, Jesus paranxon bihmayaxihquiton yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Jenquetsahpahin jahuen hininti tres mil soles copi maromayamahaxquin, jahuaborajomabo sca hinannoxon? —jato jaquin Judasen. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jahuaborajomabohon shinanxon copima jaan jato jascajaquin. Yometso hihxon copi jascajaquin. Jaa rihbi jaton coriqui coirannicahax ta jaton coriqui rihbi yometsohpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesusen sca Judas yohiquin: —Jenehue. Hea mahuataiya hahan hea hininjati ta hea hininjaxonihqui, jenehue. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mato janin ta jahuaborajomabo jascabi jatihiqui. Hea tah man yamajayaxihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jan jano hihqui honanax tsama bi res judiobo jaa jisi bocani. Jesus huestima bi Lázaro rihbi jiscatsihqui bocani, hihquipi que bi hahquirihbi huenihipi joni jiscatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaa copi ta Lázaro rihbi rehteti shinanscacannishqui, jaton hapobaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro copi hichaxon judiobaan jato potabahinxon Jesus sca nincacoinaiboya ta jaton hapobo sinanishqui. Jaa copi ta Lázaro rihbi rehtecatsihscacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Huetsa neten sca ta fiestajahi bohibo tsinquihihnanishqui. Fiesta janin ta Jesus jahuiqui hahquin yohihahbo nincacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Honanax binon pehi bihbahinax Jesus behchihi bocani. Quenacanahi bocani: —Hosanná. Nete hihbaan raanai joni ta jahuiqui, israelibaan quiquin hapo. Papan shinanyahpa tah qui —hihcanahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jascahibaan bi cabacho baque merahax jaa cahtsahotax Jesus jahui. Jan jascanon ta huishani joi jaiqui: ");
INSERT INTO kaqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Raqueyamanahue, Sion jema baquebon. Maton quiquin hapo ta jahuiqui, cabacho baque cahtsahotax. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jaa huisha joi nincamenoxon ta jahuen haxenicabaan honanyamanishqui. Jan naihoh cahipi cahchiqui ta jan jascayaxahnon huishani joi jai shinancannishqui. Jaatian pari ta honancannishqui, Jesusen hahyaxihqui jaabaan huishani honanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Caibo jascari quenacananon cahen caibaan yohibonaquin. Lázaro mahuatipi bi ta picohue hahxon jan hahquirihbi teehihmahi non jisipiqui hahbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Papan coshiyaxon Jesusen jascajaquin hahquipi nincacax tsinquijaquetaibo jaa behchihi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bohiboya sca: —Jisnahue. Non tah non jahuabi hahyamahi. Jatihixonbi ta jaa chibancaniqui —hahcanquin fariseobaan sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Caibo fiesta janin bohibo ta jaton nahua quescapahbo sca janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipe cahen Betsaida jema janinhah, Galilea mai meha. Felipe qui caxon, jaa nahuabaan yocaquin: —Noquen tah non Jesus jiscatsihqui, hapon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Andres yohihi sca Felipe cahi. Yohihax, Felipe betan sca cahi, Jesus yohihi. Yohihah bi: ");
INSERT INTO kaqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","—Hea noquebaque Papan shinanya hihqui ta rahma jisnoxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nincanahue hen mato yohinon. Main paqueyamahax ta bimi bero jaa huesti banetihqui, queyoyamahi. Banahoh queyotax pari ta bimi hicha caichihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mahuapaho hihxon Papan joi bihcatsihyamahibo ta mahuatihiqui. Non main res jihuetah ta jahuama qui hihquibo ta queyoyamanox manatihqui, jihuecointi. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Heen hahxontibo ta hea chibanti jaiqui. Jano hea hihquiton tah heen jonibo rihbi hihtihiqui. Hea hahxonai jonibo qui rihbi ta heen papa siripi yohuanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Rahma tah hen masa shinanai. ¿Jahua hen yohitihin? ¿Janoxihquibo tiromabo hea cahnemahue Papan, hih hen jatihin? Hihyamahi. Hea janoxihquibo copi tah hen nea nete qui noconihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Papan, mia nete hihbo shinanahbo jahue —hahquin Jesusen. Jaatian naihoh quehax yohuanai nincacanquin. —Jascajaxon tah hen hahribitihi —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hochomaxon nincacax tsamajaquetaibo yohuani: —Terenhih ta jaiqui —hihcani. —Papan yonoti ta hahbetan yohuanihqui —hihqui caibo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesusen sca jato yohiquin: —Maton honannon hihquish ta yohuanihqui, hean honannon hihquishma. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mai mehabaan hohcha casticanti hora ta nocoscaiqui. Rahma ta mainxon yononica yoshin naman potapaquenoxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hea jihuin hueonhihnipibo tah hen jatihibi jonibo hehqui jomatihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jihuin hueonahbaan jan mahuanoxihqui honanahbo hihxon jato jascajaquin yohiquin. Tsamajaquetaibaan sca yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","—Cristo roqui queyoyamanox manayaxihquiqui. Huishanihbo joi roqui jascari jai. ¿Jahua copi sca min Noquebaque ta hueonhihnixihcanihqui hah min noque jain? ¿Noquebaque min hihqui tsoa quin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesusen jato yohiquin: —Basimaxon sca tah man xaba jisti jenexihqui. Xaba chian nihnahue, jani yamenon. Bahquish chian nichi jonin ta jahuen nihti honanyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xaba jaxon jaa xaba nincacoinnahue, xabapan baquebo janoxon —jato jaquin. Jato jascajahax, caresscai, jaabaan jisyamascanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jaton jisnon bi hicha hahan honanti jan hahcai bi nincayamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Papan joi yohinica Isaíasnen yohini quescapahbo: ¿Non yohihah bi tsoan nincaquihquin, hihbon? ¿Nete hihbaan jahuen coshi jato jismahah bi tsoan nincaquihquin? hihqui jaa huisha joi. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jascapahboxon copi ta nincacoinyamacannishqui. Huetsa joi rihbi ta Isaíasnen huishanishqui: ");
INSERT INTO kaqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jaton beron jismis hihquish ta benchecahincaniqui. Jaton jointinin nincacoinmis hihquish ta jaton jointi xehpocahinihqui, hean jato rohajamis hihxon ta jaton shinan huetsajacaniqui hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Papan xaba jisxon ta jascajaquin Isaíasnen huishanishqui. Jasca ta Papa jaiqui jato japahonixon jascajaquin sca huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jaabi Jesusen yohihah hichaxon nincacoincanquin. Caibo jaton jonibaan rihbi nincacoinquin. Nincacoinxon bi fariseobo qui raquexon tsoabi yohiyamacanquin. —Tsoanbi noque yohuanquihnyamascanon noquen tsinquiti xoboho noque mapemayamascacanmis —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Papan hea siri jisnon yohipan hihtihi bi hapobaan hea sirijaquin yohuanquihnnon tsoabi yohiyamapan hihxon yohiyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jaabo netetai bi coshin bi res Jesus yohuanai: —Hea nincacoinax hinamehtaibo ta hehqui hinamehyamahiqui. Hea raanni qui caya ta hinamehtiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hea jisi jonin ta hea raanni rihbi jisiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jato xabajahi tah hen nai naman joniqui, hehqui hinamehtaibo bahquish chian baneyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hea nincaquin bi nincaresaibo tah hen heanbi casticanyamahi. Mai mehabo casticannoxonma bi tah hen jato teehihmahi joníqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hea Johue hahyamaxon, heen joi rihbi nincacatsihyamahibo ta honantiyahpabo qui. Hean yohihi joi ta hahan jascapahbo honanti qui, nete queyoscaiya. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hehmebi shinanax ta hen yohuanyamahi. Hea raanni heen papanbi ta hea yohihihqui. Jascari yohuanhue, jaa yohihue hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jahuentianbi queyoyamanox manati jato jihuemahue hih ta jaiqui. Jaa copi ta heen papan hea yohihi quescabijaquin hean mato yohihi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua fiesta nocorihyamahi bi mai jenebahini Papa qui cati sca jan jai Jesusen honanquin. Jahuen jonibohon shinanxon mahuanoxon caman jatohon shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pascua piti piriyamahiboya cahen Judas, Simon Iscariotenin baque, tiroma yoshiman bihxon tiroma shinan jahuen jointi janin niascaquin, Jesus paranxon bihmanoxahnnon. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pascua piti pihi tsinquiscacani, Jesus jahuen haxenicabo betan. Mian sca jato jatihibi hihbojahue Papan jai cahen Jesusen honanquin. Jahuen Papa janinhax jonish bi hahquirihbi hahqui cahi cahen honanrihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Misa janinhax huenixon sca jahuen tari potahax hani payoman chinexehti. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bandeja qui jene chicoxon jahuen haxenicabo tachoquin. Tachoxon hahan jan chinexehtai payoman sca jato tasoquin. Jascajaquin jato tachopaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Pedro qui nocoquihranscai. —¿Hea rihbi min tachocatsihquin, Hihbon? —hahquin Simoman. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Hen mia tachoca jahua hihcatsihquiquin, rahma honanxonma bi tah min huetsa tian pari honanyaxihqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Hea tah min jahuentianbi tachotimahi, hihbon —hahscaquin Pedronen. —Hen mia tachóyamahah tah min henama sca jatihi —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Hea tachoxon mepanxon manashimarihbihue, Hihbon —hahscaquin Simon Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Nashitanax ta tsoabi nashiti pishinyamascaiqui, tachoquiti huesti pishini, jatihobi rishtama sca hihnoxon. Mato tah man rishtajomaboscai, hihcax bi jatihibima —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus parannoxihqui joni honanxon copi jato jascajaquin, jatihibima jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jato tachoquin queyoxon jahuen chopa sahuerihbihax jahuen tsahotinin tsahopaquexon jato yocaquin: —¿Jahua man haxenon hihxon hen mato tachocain? ¿Man honanyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hihbon, Honanmanican, hah tah man hea quenaquin jai. Hahcoinquin. Jaa tah hen qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Maton hihbo, mato honanmanicah rihbi hihxon bi hean mato tachocaiya tah man maton rihbi joni huetsa tachotihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hen hahcai jisxon man jascajaribinon tah hen mato jismahahqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mato tah hen yohicoinai. Yonoti ta jahuen hapo mentan hashoan tee hihboma qui. Raana joni rihbi ta jaa raanai joni mentan hashoan yohuan hihboma qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nea hen mato yohihi joibo honanxon, hen mato yohihi quescabijahax tah man hahan jenimati jaresscayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mato jatihibi qui tah hen yohiyamahi. Heen caisaibo tah hen honanai. Papan huishamani joi jai quescabi ta janoxihquiqui. Heen paan pihi jonin ta jotsistonen hea jamaquihqui hihqui jaa huisha joi. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Janoxihquibo jaríyamahi bi tah hen mato rahmabi yohihi, jaressca jaiboya man hea hen qui man honannon. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hen mato yohinon nincanahue: hean raanah cahax nocotaiton mato johue hahcaibaan ta hea rihbi johue hahquiqui. Johue hea jaibaan ta hea raanni rihbi johue hahquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jato jascajaquin yohixon masa shinanxon jato yohicoinquin: —Man honannon hihxon tah hen mato yohihi: mato tocan tsahotai huestichin ta hea paranxon bihmanoxihquiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jahuen haxenicabo bejisahtanani. —¿Tsoa yohihiquin? —shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hahan Jesus queenai jahuen haxenica cahen Jesus senenbi tsahoti. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pedron sca jaa cohan cohan hihxon: —¿Tsoa yohihiquin? Yocahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jesus senenbixon yocascaquin: —¿Tsoa hin, Hihbon? ");
INSERT INTO kaqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Nea paan tequen netinxon hen hinanai joni tah qui —hahquin Jesusen. Jascaxon paaman netinxon Judas hinanquin. Simon Iscariotenin baque can, Judas. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Paan teque bichiton jahuen jointi Satanasnen hihbojaquin. —Hoa min hahcatsihqui hahtanhue, Judasen, histon —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jahua yohiquin jascahiquin misa janin tsahotaibaan honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","—Noquen coriqui coiranai copi rah ta hahan fiestajati piti non pishinai marotanhue hahquiqui —shinanquin caibaan. —Jahuaborajomabo coriqui hinantanhue hah ra ta jaiqui —shinanquin caibaan rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hahtanhue hahca jahuen paan bichish Judas caresscai, yamescai bi. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Caresscaiya Jesusen jato yohiquin: —Hea noquebaque nete hihbo hihqui ta rahma jisnoxihcanihqui. Jisquin ta noquen Papa rihbi nete hihbo hihqui jiscantihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Hea jisxon Papa Dios nete hihbo hi honanaiboya ta nete hihbo hihxon jato jismatihiqui, jahuen baque rihbi nete hihbo hi honanahbo. Rahmabi ta jascajatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Basima bi res tah hen mato betan hihtihi, heen baquebaan. Man tah man hea benayaxihqui. Hen judiobo yohihipi quescajaquin ta hen mato rahma yohihi. Hea jano cahiton tah man cati hahtipahtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Joi behna ta hen mato yohihi. Nincanahue. Joni huetsahon shinannahue, hean hen matohon shinanai quescajaquin. Joni huetsahon shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Man joni huetsahon shinanaiya ta heen haxenicabo mato qui jatihixonbi honancantihiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","—¿Jahuerahnon min canoxihquin, Hihbon? —hahquin Simon Pedronen. —Hen jano cahiton tah min rahma chibantimahi. Huetsa tian tah min hehchon catihi —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedronen yocaquin: —¿Jahua copi hen mia rahmabi chibanti hahtipahyamahin? Hea rehtecatsihquibo que bi tah hen mia jenetimahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Mia rehtecatsihquibo que bi min hea jenetimahin? Nincahue, hen mia yohinon: hatapa queorih jaima bi tah min quimisha coti heen joni hihtima min yohinoxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Masa shinanyamanahue. Papan joi nincacoinnahue. Hea rihbi nincacoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Heen papan jihue janin ta xobo hicha qui. Yamahiya cahen Mato ta hen jihuetijaxoni cahi hen jayamahan. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Caxon mato jihuetijaxonax tah hen joribiyaxihqui, mato bichí sca. Hea jano hihquiton man mato rihbi hihnon tah hen mato bichi joyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hahan hean cahi bahi tah man honanai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—¿Jahuen min cahin? Non tah non honanyamahi, Hihbon. ¿Jenquetsahaxon non mia jano cahi bahi honantihin? —hahquin Tomasen. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Hea ta Papa qui cahi bahi qui. Yohuani hihcoinai joi tah hen qui. Hahan jihueti ta hea qui. Hea jano hihquiton cayamahax ta tsoabi Papa qui nocotimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hea honanxon tah man heen papa rihbi honanquehanai. Rahma tah man honanscai. Jaa tah man jisiqui —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—Noquen Papa noque jismahue, Hihbon. Jaa res tah non queenai —hahquin Felipenin. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—¿Yotihixonpahi hen mato betan hihqui bi min hea honanyamahin, Felipin? Hea jisi jonin ta heen papa jisiqui. ¿Jahua copi min hea Noquen Papa noque jismahue hah min jain? ");
INSERT INTO kaqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jano heen papa hihquiton tah hen hea rihbi hihqui. Hea janin ta heen papa rihbi hihquiqui. ¿Min hihcoin shinanyamahin? Hen mato yohihi tah hen heanbi shinanxon mato yohiyamahi. Hehbe hihxon ta heen papan jahuen tee hahquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Heen papa betan tah hen qui, hehbetan rihbi heen papa hihqui. Hea hihcoinai shinannahue. Yohihah copi res shinanyamaxon, heen tee jisxon copi hihcoinai shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mato ta hen yohicoinai: hen hahcai teebo ta hea nincacoinai jonin rihbi hahtihiqui. Hen hahcai hahxon bi ta hashoan hanibo rihbi hahtihiqui, hea heen papa qui cahiya sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jatihibi man heen janen yocacai tah hen hahxontihi. Heen papa nete hihbo hi honanahbo tah hen hahxontihi, jahuen baque hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Man heen janen yocacai jatihibi tah hen mato hahxontihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Hehon shinanxon tah man hen mato yohihi man hahtihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hean rihbi tah hen heen papa yocatihi, huetsa yanapannica jan mato hinannon. Jaa ta jascabi sca mato betan jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jaa ta yohuancoinai hihbo qui, Dios Yoshin. Jaa jisyamaxon ta mai mehabaan jaa bihtimahiqui, jaa honanyamaxon copi rihbi. Maton tah man jaa honanai. Mato betan ta hihresscaiqui. Mato chicho rihbi sca ta jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jaabiyahpa cayama ta jai. Joribiyanoxon tah hen cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mai mehabaan hea jisyamascanon caman ta basima sca qui. Jaabaan hea jisyamascai bi tah man maton hea jistihi. Hea jihuetai copi tah man mato rihbi jihuetihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jaatian tah man honantihi, hea heen papa betan hihqui, mato rihbi hehbetan hihqui, hea rihbi mato betan hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hen yohihi honanxon nincacoinaibaan ta hehon shinannicabo qui. Hehon shinanaibohon ta heen papan rihbi jatohon shinanihqui. Hean rihbi hen jatohon shinanai. Jaabaan hea honannon hihxon tah hen heen yora hean jato jismatihi —jato jaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judasen sca yocaquin (Iscarioteninma, huetsa Judasen): —¿Jenquetsahaxon min noque miabi jismatihin, mai mehabaan mia jisnonma? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusen yohiquin: —Hehon shinanaibaan ta heen joi bihtihiqui. Jatohon ta heen papan shinantihiqui. Jato qui cahax tah non hahbetanbi jihuetihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hehon shinanyamahi jonin ta heen joi bihyamahiqui. Hen mato yohihi joi ta henama qui. Hea raanni heen papanah ta qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mato betan nihparixon tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dios Yoshin sca ta mato yanapannicah qui. Jaa ta heen janen heen papan raanyaxihquiqui, jatihibi joi mato honanmanon. Hen mato yohipahoni joi jatihibi ta mato shinanmayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Hahan jihueti siri mato hinanbahini tah hen cahi. Heen hahan sirijaquin shinanti tah hen mato hinanai. Mai mehabaan hinanai quescajayamaquin tah hen mato hinanai. Masa shinanyamanahue. Raqueyamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Caresscaax ta hen jorihbiyaxihqui hen mato jaah tah man nincacahqui. Heen papan ta hea mahuinihqui. Hehon shinanax cah man jenimahan, heen papa qui hea cahiya. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Janoxihquibo tah hen mato yohiscaáqui, jaresscaiboya man hihcoinai shinannon. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mato betan tah hen basi yohuanyamascatihi. Mai mehabo yoshin hihbo ta jahuiqui. Hea ta jahuejati hahtipahyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jaabi tah hen heen papahon hea queenai mai mehabaan honannon hihxon heen papan hea yohihi quesca hean jai. Hueninahue. Caresscanon bonahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Hea ta bana jihui yora coin quescapah qui. Heen Papa cahen huai hihbo. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jatihibi heen bimijoma mebibo ta jaan mextehiqui. Bimiyahpa mebi jatihibi ta boxtepaquehiqui, hashoan bimi hichanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mato tah man boxtehahscaqui. Hen mato yohiha join ta Papan mato boxtehihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jahuen jihui yora jahuen mebin jenebahintimahi quesca hehbetan jascabihi janahue. Hea rihbi tah hen mato betan jascabihi jai. Mebi ta hahmebi bimiti hahtipahyamahiqui; jahuen yora qui rechihah pari bimihi. Mato jascarihbihi; hehbetan hihyamahax cahen jahuabijomabo mebibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Hea tah hen jihui yora quescahpa qui, mato cahen heen mebibo. Jahuen yora janin jahuen mebi rechitax hicha bimiyahpa hihqui quescajaquin tah man hehbetan hicha hahtihi. Hehbetan hihyamaxon cah man jahuabi hahtimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hehqui rechitaima mebibo ta huai hihbaan mextexon potatihiqui mebi choshihi quescanon. Shinannahue: mebi choshibo ta tsinquixon mapojacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Rechitax quesca man hehbetan jihuexon, heen joi rihbi maton jointi janin hihquiya tah man man queenai jatihibi yocatihi, hen mato hahxonnon. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hicha bimiyahpabo quescaxon man hicha noquen Papa hahxonaiya ta mato jisxon, heen Papa nete hihbohi jonibaan honanyaxihcanihqui. Jascapahbo tah man heen haxenicabo jatihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Heen papan hehon shinanxon hahxonai quescajaribiquin tah hen hean rihbi matohon shinanxon hahxonai. Hen mato hahxonnon jascabijaquin nincacoinnahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Heen papan hea yohihi quescabijaquin tah hen jai, jaa queenai quescabijaquin hea hahxonnon. Jascajaquin rihbi man hen mato yohihi quescabijaquin jaiya tah hen hea queenai quescabijaquin hen mato hahxontihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Hea jenimahi hihqui quescari man mato rihbi jenimanon hihxon tah hen mato yohihi, man hinti jenimanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nea tah hen mato yohihi: matohon hean shinanai quescajaribiquin maton rihbi joni huetsahon shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Noquen hahbe rabetibohon hihti shinanxon tah non mahuanoxon caman jato hahxonquin yanapantihi. Jascapa hahxonnicah ta tsoanbi hahxonquin mahuintimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hen mato yohihi quescajaquin hahcaibo tah man heen hahbe rabetibo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mato tah hen “heen jonibon” hahyamascai. Jahuen hihbaan hahcai ta jahuen jonin honanyamahihqui. Jatihibi heen papan hea yohipahoni mato honanmaxon copi tah hen mato “heen hahbe rabetibon” hahcai. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hea man caisnima bi tah hen hean mato caisnihqui. Caisxon tah hen mato janescai, man hicha hahqui canon. Man hahcai queyoyamanox mananon tah hen mato raanai. Jascapahboxon man yocacai jatihibi noquen papan mato hahxonnon tah hen mato raanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Joni huetsahon man shinannon hihxon tah hen jascajaquin mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mai mehabaan mato jistahihmahiya honannahue: hea pari ta jistahihmacanishqui, mato chini sca. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mai mehabo man hihquiya cahen mai mehabo matohon queenquehan, jaton caibo copi. Jascapahboma tah man qui. Mai mehabo hihyamascanon tah hen mato caisnihqui. Jaa copi ta mai mehabaan mato jistahihmahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Hen mato yohiha joi shinanbehnoyamanahue. Yonoti ta jahuen hihbo mentan hashoan yohuan hihbo hihyamahiqui. Hea tiromajacatsihquin hea chibannixon ta mato rihbi sca chibanyaxihcanihqui. Heen joi nincanixon ta maton joi rihbi nincayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hea raanni heen Papa honanyamaxon ta mato tiromajayaxihcanihqui heen jonibo man hihqui copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hen jato yohiyamahah cahen hohchayahpaboyamahan. Hean yohihah copi ta Honanyamahax tah hen hohchanihqui jati hahtipahyamascacaniqui, hohchanihxon. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hea jistahihmahi jonin ta heen papa rihbi jistahihmahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tsoan jascajani que ma bi tah hen Papan coshiyaxon jato hahxonpahonihqui. Jato tocan hen hihyamahiya cahen hohchayahpabohihyamahan. Hen jato hahxonai jisxon bi ta heen papayabi hea jistahihmacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Papan huishamani joi janin ta nea jaiqui: Jahua copima bi ta hea jistahihmarescaniqui. Jaa joi jai quescabi ta jacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mato yanapannicah sca tah hen heen Papa janinxon mato qui raanyaxihqui. Jaa ta yohuancoinai hihbo qui, Dios Yoshin. Papa janinhax jahuex ta hehqui yohuancoinyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hen haxemamenoni tian hea nincanish tah man rahma caman haxehi hehbetan nihnicahbo qui. Jaa copi tah man mato rihbi heya joihi yohuancointi jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Hea jeneti shinan tsoanbi mato hinanyamanon hihxon tah hen nea rahsi hen mato yohihahqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jaton tsinquiti xoboma qui ta mato potayaxihcanihqui, tsoanbi mato yohuanquihnyamascanon hihxon. Mato rehtehibo ta Mia rehtequin Papa Dios hahxonpan hihnicahbo rahsi jatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Heen papa honanyamaxon ta hea rihbi honanyamaxon jascajayaxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nea hen mato yohihi quesca jaresscaiya Noque ta yohinishqui hihyaxahnahue. Man honannon hihxon tah hen mato yohihi. Mato manati hahtipahparixon tah hen mato honanmamenoxon jaa joi mato yohiyamanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Hea raanni heen Papa janin sca tah hen canoxihqui. Hen canoxihqui bi tah man Jahuen min canoxihquin hea jayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jascajaquin hen mato yohihah copi tah man jointinin benatihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Man benatai bi tah hen mato yohicoinai. Hea cahah ta siri qui. Hea cayamahiya cahen mato yanapannica joyamahi. Caxon ta hen raantihi, mato qui jonon. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Joxon ta jatihibi jonibo honancoinmatihiqui, jahua tiroma quin, jahua siri coin quin, jahua Papan casticantihiquin, jato honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hea nincayamahibo copi ta jaton hohcha copi Papan jato casticanyaxihqui jato honanmatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Heen papa qui hea cahiya man hea jisyamascai copi ta jahua siri coin quin hihxon jato honanmatihiqui, jihueti honanahbo. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mai meha hihbojanica yoshin casticanti jaresscai copi ta tiromabo copi Papan casticanyaxihqui jato honanmatihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mato yohiti hicha pari jai bi tah man rahmabi nincati hahtipahyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Joxon ta yohuancoinai hihbaan mato jatihibi hihcoinai joi honanmayaxihquiqui. Hahmebi shinanxonma bi ta Papan yohiha jan nincacai joibo mato honanmayaxihquiqui. Joyaxihquibo rihbi ta mato yohiyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hea nete hihbohi honanahbo ta yohiyaxihquiqui. Hean yohihi joibo bihxon ta jaan mato honanmayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Heen papanahbo jatihibi ta henabo qui. Jaa copi tah hen mato yohihahqui, hean yohihi joibo bihxon ta jaan mato honanmayaxihquiqui hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Man hea jisquin jenenon ta nea pishca sca jaiqui. Basima tahni hea jisyamascaipixon tah man hea hahquirihbi jisyaxihqui —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Caibo sca jahuen haxenicabo yohinani: —¿Jan yohuanai jahua hihquiquin? Man hea jisquin jenenon ta nea pishca sca jaiqui. Basima tahni hea jisyamascaipixon tah man hea hahquirihbi jisyaxihqui. Hea heen papa qui cahiya jan hihqui bi ¿jahua yohihi jascarihquin? ");
INSERT INTO kaqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Basima sca jan hihqui bi jahua hihcatsihquiquin? Jan yohihi tah non honanyamahi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yocacatsihquibo hih honanxon Jesusen jato yohiquin: —Man hea jisquin jenenon ta nea pishca sca jaiqui. Basima tahni hea jisyamascaipixon tah man hea hahquirihbi jisyaxihqui hen mato yohihah copi ¿jaa jahua hihcatsihquiquin hah man yocacahanan jayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hen mato yohinon nincanahue: man tah man huinitihi, huaohihqui, mai mehabo jenimanon. Bena benatax bi tah man hihti jenimaribitihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jahuen baquexo bihti nete nocotaiya ta hisinxon jahuen baque caincatsihquin haibaan masa shinanihqui. Jahuen baquexo bihresscaxon sca ta jan masa shinanah shinanbehnoscaiqui. Joni behna noquen neten jahui copi jenimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mato jascarihbihi. Rahma masa shinanax bi tah man jointinin jenimayaxihqui, hen mato hahquirihbi jisiya. Man jenimahi yohuan ta tsoanbi mato bichintimahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jaa neten tah man hea jahuabi yocayamayaxihqui. Man honannon hihxon ta hen yohihi: man queenaibo man heen janen noquen naihoh queha Papa yocacah ta mato hinanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Rahma caman tah man jahuabi heen janen yocayamahi. Yocanahue. Jenimanoxon tah man bihtihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Papan jihuemati ta jascapah qui hahxon tah hen mato haxemapahoniqui. Huetsa tian tah hen jaa patax queha joi mato yohiyamascatihi, heen Papan joi mato yohiquin sirijascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jaatian tah man heen janen yocayaxihqui. Mato qui tah hen noquen Papa yocaxonyaxihqui hah ta hen jayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Man hehon shinanxon heen papa janinhax hea joní man shinancoinai copi ta matohon shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Heen papa janinhax tah hen joniqui. Naihoh quehax jonish tah hen hahquirihbi heen papa qui cahi, mai mehax sca —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jahuen haxenicabaan sca yohiquin: —Rahma caya tah min yohiquin sirijahi, jaa patax queha joima. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mian tah min jatihibi honanai. Noquen tah non honanscai. Jahuabi yocacahtima sca tah non jai. Non tah non honanscai. Jaa copi tah non hihcoinai shinanai, Mia tah min Papa Dios janinhax joniqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusen jato yocaquin: —¿Man rahma nincacoinscain? ");
INSERT INTO kaqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hea huesti hihnon tah man jabacahini cahax jabisnoxihqui. Jaabi tah hen hea huesti hen banetimahi, heen papa ta hehbetan hihtihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Heen shinan bihxon man shinanquin sirijanoxahnon hihxon ta hen mato yohihahqui. Mai mehax tah man hohmis hohmisyaxihqui. Jascarax bi jenimanahue. Mai mehabo ta hen namanjasca jai. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jato jascajaquin yohixon nai bejisahnan sca yohiquin: —Hen tah hen janquenjascai, Papan. Hea miin baque nete hihbohi jato honanmascahue, mia nete hihbohi honanahbo, hean rihbi jato honanmanon. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hen mia hinanai jatihibi teehihmanoxon jatihibi yorayahpabo hihbojahue hah tah min hea janiqui. Jahuentianbi queyoyamanox manati jihuetahbo tah hen jato teehihmascatihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mia huesti tah min Papa Dios coin qui. Queyoyamanox manataibo ta mia honanax jihuetaibo qui. Mia honanxon, hea mian raanni Jesucristo rihbi honanax ta jihuecoinnicabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Hen hahxonnon min hea hinanni tee queyoxon tah hen mainxon hen mia nete hihbohi jato jismapahonihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mai tsahonrihyamahax bi tah hen mihbetan nete hihbo hihquish xabanihqui. Mia jano jaiton sca hea rihbi nete hihbohi jisibo heen xaba jato jismahue, Papan. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Min hea hinanni mai meha jonibo tah hen noquen Papa jenquetsahpa quin hahxon jato honanmaniqui. Minabo tah min hea hinannihqui. Miin joi ta bihresscacanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Min hea hinanni joibo jatihibi ta mina qui. Jaa ta honanscacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Min hea hinanni joi hean jato hinanah ta honancaniqui. Jaa bihcoinxon ta mia janinhax hea joní honancoincaniqui. Mian min hea raanni ta hihcoinjaquin shinancoincaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jaabo ta hen yocaxonai. Mai mehabo yocaxonma bi tah hen min hea hinannihbo hen yocaxonai. Jaabo ta mina qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Henabo jatihibi ta mina qui. Minabo jatihibi rihbi ta hena qui. Jaabo heen shinanyahpabo quen ta hea nete hihbohi honancantihiqui, mai mehabaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Rahma tah hen mai mehabo tocan hihyamascai. Jaabo res ta mai mehabo tocan hihquiqui. Mihqui tah hen cahi. Hahan min hea janeni miin janen jato coiranhue, jaabo huesti hihnon, noque rabe non huesti hihqui quescarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jato betan hihxon tah hen min hea hinanni miin janen jato coiranpahoniqui. Hean jato coiranah ta tsoabi manoyamahihqui. Nincayosma tiroma huesti res ta manotihqui, huishani joi jai quescabi janon. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mihqui sca tah hen cahi. Mainxon tah hen nea joibo mia yohihi, hea jenimahi hihqui quescarahbo. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Miin joi tah hen jato yohiscaniqui. Hea mai mehama hihqui quescarihbihi ta jaabo mai mehaboma quen mai mehabaan jato jistahihmahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mai janinha jato tsecahue hah ta hen jayamahi. Tiroma yoshiman jato jahuejayamanon jato jisxonhue hahquin tah hen jato yocaxonai. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hea mai mehama hihqui quescarihbihi ta jaabo mai mehamabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nincacointi shinan jato hinanxon hihcoinai join jato mequexonhue. Miin joi ta jaa joi qui, hihcoinai joi. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mian min hea mai mehabo tocan raanni quescajaribiquin tah hen jato raanscai mai mehabo tocan canon. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hihcoinai joi honanxon mihqui hinamehxon teneti shinan bichibo tah hen jaton hohcha copi hen hinamehtai. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Jaabo res ma tah hen yocaxonai. Jaabaan sca yohihah hea nincacoinyaxihquibo rihbi ta hen yocaxonai. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jaabo jatihibi huesti yora hihnon, mia hehbetan hihqui quescari, hea rihbi mihbetan hihqui quescarihbihi, noque betan jaabo huesti yora jihuenon. Non jascaraiya ta mian min hea raanni honancoinyaxihquiqui jonibaan. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Min hea hinanni coshi shinan tah hen jato hinanrihbinihqui, jaabo huesti hihnon, noque non huesti hihqui quescarihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jato betan tah hen jihuetai. Hehbetan rihbi tah min jihuetai, jaabo rihbi huesti yora siripi jihuenon. Jascaraiya ta min hehon hihti queenai quescarihbihi, hea raanax min jatohon hihti queenai mai mehabaan honanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Jano hea jaiton min hea hinanni jonibo rihbi jati tah hen queenai, Papan, nete jariyamanon hehon queenxon min hinanni coshi jisibo. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mai mehabaan mia honanyamahi bi tah hen hean mia honanai, Papan. Hea min raanni rihbi ta heen jonibaan honanihqui. Mian tah min pontejaquin shinanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hahxonnica Papa siri min hihqui jato honanmanixon bi tah hen jato honanmarihbitihi, min hehon queenxon hahxonni quescajaribiquin jatohon shinanxon min jato hahxonnon. Hea rihbi jato betan hihnoxon tah hen jato honanmanoxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jascahax jahuen haxenicabo betan cahax Cedron janeya texpa pohquetax jano huai jaiton cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesus bihmacatsihqui Judasen ta jaa huai honanrihbinishqui, jaa huai chian jahuen haxenicabo betan Jesus cahiya cahen jaa rihbi jano capahoni. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jano Jesus cahi honanxon sontarobo sca benaxon sacerdote hapobo janin porisiabo rihbi benaxon jaa huai chian jato hioquin. Caibo johueyahpabo, caibo ramparinyapabo, jaton jashiya bocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Huai chian nocotaiton Jesusen jato behchiquin. Jahuejanoxihquibo jatihibi honanax, jato behchihi cainxon yocaquin: —¿Tsoa man benahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Nazaret janinha Jesus rahan —hihcani. —Hea ta hen qui —hihqui Jesus. Jesus bihmanica hihquish Judas jato betan nichi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hea ta hen qui Jesus jaiya jaabo chitihihrenenax paqueti miracahrenencani. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","—¿Tsoa man benahin? —jato jaribiquin. —Jesus Nazaret janinhah rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Hea ta hen qui hih ca hen jai sen. Hea benaxon heen jonibo jenenahue, botanahbo —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Min hea hinanni jonibo tah hen ni huestibi manomayamahi jan yohihah quescabi janon hihxon jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pedronen sca machito jaxon, tsecaxon, sacerdotenin joni reraquin bi mecayaho res paxtebahinquin. Malco ta jaa jonin jane qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","—Miin machito bexojahue. ¿Heen papan hea jascajahue hahca hen hahtimahin? —Jesusen Pedro jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jaatian sontaro hapon yohihah porisiabo betan jahuen sontarobaan Jesus bihtanxon menexcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Menexxon Anasen xobo janin pari bocanquin. Anas cahen Caifasnen coca. Caifas cahen jaa bari tian sacerdote hapo hihpahoni. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifas ta Huetsa jonibo jihuenon huesti joni mahuatah ta siri qui hihnicah qui. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Anasen xobon bohiboya pari ta huetsa jahuen hahbe haxenica betan Simon Pedronen jato chibanbonanishqui, Jesus bohiboya. Jahuen hahbe haxenica ta sacerdote hapon honannishqui. Jaa copi ta sacerdote hapon xoboho mapetaiboya jemanhihti janin jahuen hahbe haxenica hihconishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jaa hihcohi bi jemanhihti xehqui senenbi Pedro banereneni. Jahuen hahbe haxenica sca sacerdote hapon honanai joni hihquish picoxon xehpoti coirannica haibo yohixon Pedro hihcomaquin, jemanhihti janin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jemanhihti janin nichiton sca xehpoti coirannica haibaan Pedro yocaquin: —¿Mia rihbi min jahuen haxenicama quin? —hahquin. —Jaama ta hen qui —hihqui Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Matsihiya sca cahen hapon jonibo betan porisiabaan chihi requenjaquin. Perehihquiya jano pehchicani. Pedro rihbi jato betan pehchihi nichi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Xoboho cahen jaton hapo yocacahti: —¿Tsoabo miin haxenicabo quin? ¿Jahua yohiquin min jonibo haxemahin? —hahxon yocapaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yocacah Jesusen yohiquin: —Janibixon tah hen jatihibi joni yohirahsihi. Maton tsinquiti xobohoxon haxemaxon, Papan xobohoxon haxemaxon, jano judiobo tsinquitaiton tah hen jato honanmarasihi. Jonexon tah hen jahuabi yohiyamarahsihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jahua copi sca min hea yocacain? ¿Hea nincarahsihibaan jahua yohihipishquin? Jaabo caya yocahue. Jascajati ta jaiqui. Hen yohirahsihi nincaxon ta honancaniqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jascahiton: —¿Jascajaquin min sacerdote hapo joi bichinain? —hahxon jaa senenbi nichi porisianen Jesus copatsahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Ponte hen yohiyamahiya Jascama ta qui hahhue. ¿Hen ponte yohihiya jahua copi sca min hea rishquihin? —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jaatian hahquirihbi menexti jato yohixon Caifas janin sca Anasen jato raanquin, Caifas hashoan hapo copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Xoboho pari jaabo jai bi jemanhihtin Pedro nichi pehchihi. —¿Mia rihbi min jahuen haxenicama quin? —hahcanquin. —Jaama tah hen qui —hahquin, Jesus qui paramehquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sacerdote hapon joni sca Pedronen paxteha jonin jenabo hihxon yocaquin: —¿Huai chian min hahbetan nichi hen mia jisyamahaquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jascajaquin yocacah hahquirihbi jahuen joni hihtima yohiquin. Jaatianbi sca hatapa queoscai. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caifasnen xobo janinhax picoxon gobernador xoboho sca Jesus bocanquin. Xaba paquecatsihscai. Nahuan xoboho mapetax rishtaxon non pascua fiesta piti hahtipahyamamis hihquish jahuen xoboho mapeyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jaa copi jato qui Pilato picoti. —¿Jahua man hahqui yohuanain? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Tiroma joni hihyamahiya cah non mia hinanyamahan —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Boxon, maton xenibaan huishanihbo joi jisxon jaa joi jai quescajaquin hahnahue matonbi —Pilatonen jato jaquin. —Noquen cah non rehteti hahtipahyamahi. Noquen rehtetima joi ta jaiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jascajaquin ta hea rehteyaxihcanihqui hahxon Jesusen jato jaipi quescabijaquin janon, jascajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jahuen xoboho hihcorihbixon Jesus quenaxon Pilatonen yocaquin: —¿Mia min judiobaan quiquin hapo quin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Mianbi shinanxon min hea yocacain? ¿Caibo hehqui yohuanah min hea yocacain? —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¿Hea judio quin? Jaton sacerdote hapobo betan ta miin caibaan mia hihuexon hea casticanmacatsihquiqui. ¿Jahuejah min jaipiquin? —Pilatonen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Hean hihboti ta nea mai mehama qui. Nea mai meha heen hihboti jaiya cahen heen jonibo coshicahinquehanihqui, judiobaan hea bihyamahahbo. Nea mai mehama ta heen hihboti qui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—¿Mia min quiquin hapo qui nan? —Pilatonen yocaquin. —Quiquin hapo hea hihqui hah tah min miabi jai. Jaamama jaabijaquin yohinoxon tah hen cainnihqui. Jaa copi tah hen nai naman joniqui. Jatihibi hihcoinai yohuannicaton ta heen joi nincaquihqui —hahquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿Hihcoinai jahua quin? —hihscai Pilato. Jascahax Pilato caini judiobo qui. —Jahua hohchabi ta hen jisyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascua fiesta tian yocanicabo tah man qui, hen sipo xoboho tsahonni huesti mato picoxonnon. ¿Judiobaan quiquin hapo hen mato picoxonti man queenyamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Jaama bi Barrabas —hahcanquin, coshin bi res. Barrabas ta yometsoh hihpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jaatian sca Jesus rishquihahbo jahuen sontarobo Pilatonen yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sontarobaan sca rishquixon moxa maitijaxon Jesus maimaquin. Yancon tari rihbi sahuemacanquin, hapon tari. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sahuemaxon hahqui jori jorixon: —Jihuehue, judiobaan quiquin hapon —hahcanquin. Jascajaxon tihibi tantashahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jaatian judiobo qui Jesus hahquirihbi picoxon Pilatonen jato yohiquin: —Jisnahue. Man jisnon tah hen mato jismahi. Hean jisi ta jahuen hohcha yamahihqui. Man honannon hihxon tah hen mato yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jascahiya Jesus picoscai, moxa maitiya, yancon tariya. —Nea tah qui —jato jaquin Pilatonen. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote hapobo betan porisiabaan sca Jesus meraxon coshin yohiquin: —Jihuin hueonhue. Jihuin hueonhue —hahcanquin. —Jihuin hueonnahue matonbi. Jahuen hohcha ta yamahihqui, hean jisi bi —jato jaquin Pilatonen. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Huishani joi tah non noque jai. Hea ta Diosen baque qui jan jai copi tah non jaa rehteti jai, noquen nincati joi nincaxon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jascaraibo nincacax Pilato hashoan raquescai. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jahuen xoboho hihcorihbixon Jesus yocarihbiquin: —¿Jahuerahnohah mia quin? —hahquin. Yocacah bi jahua hihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jahua hihyamahiya Pilatonen yocaquin: —¿Min hea yohicatsihyamahin? Mia tah hen picoti hahtipahi. Mia jihuin hueonxon rehteti tah hen hahtipahribihi ¿min honanyamahin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Naihohxon mia coshi hinanyamahah tah min hea jahuejati hahtipahyamaquehanai. Jaa copi ta hea bihxon mia hinanai joni hashoan hohchaya qui —Jesusen Pilato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jascahah Pilatonen picocatsihqui bi judiobo coshin yohuani: —Min jaa picohi tian tah min quiquin hapo Cesaronen hamicoma sca min jatihi. Jatihibi quiquin hapocatsihquibo ta Cesaronen rahuibo qui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jascaraibo nincaxon Jesus cainmahax, casticanti yohinoxon janoxon yohiti tsahotinin tsahopaqueti. Gabata janeya jemanhihti janin, judiobaan join cahen Gabata macan champani tapojahibo hihcatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua fiesta piyanoxon jaton pitijati neten barin manan tsacahiya cahen jano tsahoxon judiobo sca Pilatonen yohiquin: —Nea ta maton quiquin hapo qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jascahiya sai saihihscacani: —Rehtehue. Rehtehue. Jihuin hueonhue —hihcani. —¿Maton quiquin hapo hen jihuin hueontihin? —Pilatonen jato jaquin. —Cesaro huesti ta noquen quiquin hapo qui, huetsama —hihcani sacerdote hapobo. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jaatian jihuin hueonahbo sca jato Bihnahue hahquin. Bihnahue hahca Jesus bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bihxon boxon jahuen coros hiamabahincanquin. Cahax mapo xao janeya manan qui nococani. Judiobaan join cahen Gólgota. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Janoxon sca tasaxon nichinxon jihuin hueoncanquin. Huetsa joni rabe rihbi jascajarihbicanquin, ramiho huetsa nichinxon ramihoh rihbi huetsa nichincanquin. Naponbi cahen Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Quirica huishamaxon ta Jesusen coros qui Pilatonen jaa quirica hueonmanishqui: Nazaret janinha Jesus, judiobaan quiquin hapo hihqui jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hihti caiboxon ta judiobaan jaa quirica jisnishqui, jema hochoma hueonaibo quen. Judiobaan join huishaxon bi Latin join rihbi hahxon, Griego join rihbi huishahah, jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jaa quirica jisxon judiobaan hapobaan sca Pilato yohicanquin: —Judiobaan quiquin hapo hahquin huishayamahue. Judiobaan quiquin hapo ta hen qui jan hahcai, hahquin huishahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Hen huishahah ta huisha sca qui —hahquin Pilatonen. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jihuin hueonxon sca ta jahuen chopabo sontarobaan bihnishqui. Chosco sontaro hihquish jahuen chopa metisihpaquecani. Jahuen tari sca cahen metisihpanan rechijoma hihnish, jahuen tepan janinhax jahuen quecato caman saya. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Jahuen tari huaxayamanahue. Tsoana banetihiquin hihxon macan bero pishca borasa qui nanexon chicoti ta jaiqui —hihcani. Jascaxon huishani joi janí quescabijacanquin. Heen chopabo ta bihpaquecanihqui. Heen sahueti bihnoxon ta macan bero potacaniqui. hihqui jaa joi. Jaa joi jai quescabijaquin cahen sontarobaan hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jasca jaibaan bi Jesusen coros patax jahuen mama, jahuen mama huetsa, María Cleofas haibo, María Magdalena, jaabo nichi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jahuen mama jisxon hahan jan queenai jahuen haxenica rihbi hochoma nichi jisxon jahuen mama Jesusen yohiquin: —Hoa ta miin baque qui, maman —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jahuen haxenica sca yohiquin: —Nea ta miin mama qui —hahquin. Jaa copi ta jahuen xoboho sca jaa haxenicaton Jesusen mama jihuemanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jaatian sca jatihibi janquenja sca jan jai honanxon huishani joi jai quescanon hihquish: —Xehan tah hen hihqui —hihqui Jesus. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jano cahen tason bocho xehati cachani tsahoti. Jesus jascaraiya sca taco quescapa hahan maosahxon mehchajaquin, jashi taxoyaxon jahuen jana janin sanancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cachani tanahax sca: —Janquenja sca ta jai —hihqui. Jascarax jahuen mapo betihiquish mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pilato janin caxon sca pitijati nete sca jai copi, Janin yamenon mahuamati ta jaiqui hahxon judiobaan yocaquin. Jaton huihtax tobanon yohihue, mahua sca jaiton jaton yora botonxon botanahbo hahcanquin yocaquin. Tantiti neten jaton yora coros janin hueoyamanon hihxon jascajacanquin. Jaa tantiti nete jaton hani fiesta nete hihqui copi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tobatannahue hahca sontarobaan caxon jaa senenbi hueonah rabebi jahuen huihtax tobaxon huetsana jascajaribicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesus qui nocoxon sca mahuascai meraxon jahuen huihtax tobayamascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tobayamaxon bi huesti sontaronen jashin Jesus pishnacoquin. Pishnacoha jimiya jene caini. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jaa jisnixon tah hen mato yohicoinai, maton rihbi man nincacoinnon. Hen tah hen hihcoinai. Honancoinax tah hen hihcoinai maton rihbi man nincacoinnon hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Huishani joi jai quescabi janon ta tobayamacanishqui. Jahuen xao ta ni huestibi tobatimahiqui hihqui jaa joi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jaa pishnaconixon ta jaabi jisyaxihcanihqui hihqui huetsa rihbi huishani joi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jaa pecaho Arimatea janinhax José janeya joni joxon Pilato yocaquin Jesusen yora botannoxon. Jaa José cahen nincacoinnica. Nincacoinnicaxon bi judiobo qui raquexon tsoabi yohiyamaquin. Rahma sca jahuen yora yocaquin. Yocacah Pilato jeen hihqui. Jeen hihquiya caxon jahuen yora botonxon boquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jesusen haxemamenohiya hahqui yame canicah rihbi jahui, Nicodemo. Mirra, áloe jahan hinintibo mesco bequin hicha. Hahan mihinti rahobo jan behi cahen cuarenta kilo hihuepai. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesusen yora bihxon judiobaan hahpahoni quescajaquin hahan hininjatiya bi joxo chopa quexen yabi yabicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jano hueonahbo janin cahen jihui huai jai. Jaa huai janin rihbi mai poquin behna jai, jaho tsahonti quini, jano tsoabi tsahonrihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaa tsahon hochomahi copi janobi Jesus tsahonbahincanquin pitijati neten copi hishtocani. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jahan semana pehocohtai neten sca hihari xaba paqueri jaima tsahon janin María Magdalena jahui. Nocoxon hahan tsahon behpohipibo macan taranbohanah sca jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bishquihihcanahi caxon Pedroya huetsa haxenica yohiquin. Jaa huetsa cahen jahan Jesus queenai joni. —Tsahon janinhah ta noquen hihbo tsecacanaxqui. Jahuerahnon racanaxquin tah non honanyamahi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yohiha jaa huetsa haxenica betan picotax tsahon janin bishquihihcanahi Pedro cahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Rabebi bishquihihcanahax bi jaa huetsa pari tsahon janin nocoti, hashoan coshin cahax. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cahcopaquexon najisquin. Hahan yabihipibo joxo chopa jano tsamana jisish bi hihcoyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hahchon sca Simon Pedro nocoti. Jahuex pontecahini tsahon quiniho hihcohi. Hihcoxon jisí bi jahuen chopa quexe tsamanah racati. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hahan bebepohipibo payon cahen huetsanco, joxo chopa quexebo betan racayamahi. Jaa cahen hahmebi boxca boxcahah racatan. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Huetsa sca tsahon janin hihcohi, jaa pari nocotax bi chini hihcohi. Jisxon, Bohancoin ta jacanaxqui hihqui shinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jaa hihquipish bi hahquirihbi teehihtihi hihqui huishani joi honanyamaxon jascajaquin shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jaatian sca jaton xoboho rabebi caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tsahon patax banetax María nichi, huaohihqui. Huaohihanan cahcopaquexon tsahon najisquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jisí bi Papan yonoti rabe. Jano Jesusen yora racanipi janin joxo chopayahpa yonoti rabe tsahotai. Tsahon mapo quiri huesti tsahoti, tahe quiri huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—¿Jahua copi min huaohihquin, haibon? —yocaquin. —Heen hihbo hea bohanahbo copi, rahan. Jahuen racancanaxquin hen ta hen honanyamahi —hihqui María. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jascahax rabejaquexon jisí bi janobi Jesus nichi. Jaa que bi Marian honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—¿Jahua copi min huaohihquin, haibon? ¿Tsoa min benahin? —Jesusen yocaquin. Jaa huai hihbo hihqui shinanxon: —Huetsanco hea bohanxon jahuen min racantanai hea yohihue, jonin, hen botannon —hahquin haibaan, jisxonma. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—Marian —hahscaquin Jesusen. Jascahah rabejaquetax judiobaan join yohuani: —Raboni —hihqui. Maestron hihcatsihqui, jaton join. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Hea xecoyamahue. Heen papa qui tah hen hinahihnarihyamahi. Heen huetsabo yohitanhue, hea heen papa qui, maton papa qui, heen Dios qui, maton Dios qui hea hinahihnatai yohitanhue. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yohitanhue hahca caxon jahuen haxenicabo María Magdalenanen yohiquin: —Noquen hihbo tah hen jistanai —jato jaxon jan nincacah jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jaa pecaho sca jaa neten, hahan jaton semana pehocohtai neten, jano jaabo jai xoboho mapexon judiobo qui raquexon jahuen haxenicabaan xehqui xehpoquin sirijaquin. Bepiscaiya sca jahuex jato tocan Jesus nihreneni jahui. —¿Man siripi jayamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jato jascajaxon jahuen mequen jato jismaquin. Jahuen pishi jato jismaquin. Noquen Hihbo jisish jahuen haxenicabo jenimahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jato yohirihbiquin: —¿Man siripi jayamahin? Heen papan hea raanni quescajaribiquin tah hen mato raanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","Jato jascajaquin yohixon jato xoonhahxon: —Dios Yoshin bihnahue —jato jaxon— Man huetsa joni hohcha sohuamahiya tah hen jaa sohuaxontihi. Man huetsa joni hohcha sohuamayamahiya ta jahuen hohcha jascabi jaiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Rabe nane janeya Tomas ta jahuen doce haxenica janinha huesti janishqui. Jesus jahui bi cahen jato betan Tomas hihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jaa copi cahen jahuen hahbe haxenicabaan yohinish: —Noquen hihbo tah non jisiqui —hahcanquin. Yohihahbaan bi: —Jahuen mequen janin clabon metasipi quini jisyamaxon, jaa clabon quini janin heen metoti rihbi niayamaxon, pishnacohipibo janin heen mequen rihbi niayamaxon tah hen hihcoinai shinantimabirestihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jan jascahipi ocho neten sca jaa xoboho jahuen haxenicabo hahquirihbi tsinquiti. Jato betan Tomas hihqui. Xehqui xehpotai bi jato tocan Jesus nihreneni jahui. —¿Man siripi jayamahin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jato jascajaxon Tomas sca yohiquin: —Miin metoti niahi johue. Heen mequen jisihue. Heen pishi janin miin mequen niahi johue. Paranaibo shinanyamahue. Hihcoinai shinanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Heen hihbo, heen Dios —hihscai Tomas. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—¿Hea jisxon copi min hihcoinai shinanain? Jisxonma bi hihcoinai shinanaibo ta hahan jenimati jaiqui —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jahuen haxenicabaan jisnon bi hicha hahan honantibo Jesusen hahní bi tah hen nea quirica huishaxon texe res yohihi; hashoan hicha jan hahnibo tah hen yohiti pishinai. ");
INSERT INTO kaqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jaabi Jesus noquen Papa Diosen baque Cristo hi man honancoinnon hihxon tah hen nea huishahahqui, nincacoinax Jesus qui hinamehtax man jihueyaxihnon. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jascari jato qui cainipish cahen Tiberias hian quexa sca jahuen haxenicabo qui Jesus sanareneni joribinish. Jan sanareneni jahui ta nescanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pedro, Rabe nane janeya Tomas, Galilea mai meha Cana jema janinha Natanael, Zebedeonen baque rabe, huetsa jahuen haxenica rabe rihbi, jaabo jano hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Hea tah hen tsatsa benahi cahi —Simon Pedronen jato jaquin. —Cahue non mihbetan canon —hahcanquin. Cahax nontin nanecani. Tarrafa potashinaxon bi jahuabi bihyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Xaba paquescaiya quexabi jahuex Jesus nihreneni. Jesus que bi jahuen haxenicabaan honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","—¿Man tsatsa bihyamahin, heen baquebaan? —Jesusen jato jaquin. —Bihyama tah non jai —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Mecayaho sca tarrafa potanahue. Jano tah man meratihi —jato jaquin. Jascahah potaxon bi naneti hahtipahyamascacanquin tsatsa hichahiya. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hahan Jesus queenai jahuen haxenicaton sca Pedro yohiquin: —Noquen Hihbo tah qui —hahquin. Chopanma teexon bi Noquen Hihbo tah qui hihqui nincaxon jahuen chopa Pedronen sahuequin. Sahuehax jenenencanya cayahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Texe jahuen haxenicabo nontin taxnati cahi. Tarrafa tsatsa bochohi ninibonahi cahax taxnacani, quexa hochoma hihquish cien metro tihixonpahi. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mapexon tsiste requeman tsatsa xohihi meracanquin. Paan rihbi jano racatai meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Man rahma rahcohi tsatsa pishcaya benahue —Jesusen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nanexon jaton tarrafa ninibenaxon Simon Pedronen mapemaquin. Hanibo tsatsabo tarrafa bochohax bi huaxayamahi, ciento cincuenta y tres tsatsa. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—Pihi benahue —Jesusen jato jaquin. Tsoa min quin tsoanbi jahuen haxenicaton yocayamaquin, raquexon. Noquen Hihbo hihqui honanscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Joxon paan bihxon Jesusen jato hinanquin. Tsatsa rihbi jato hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jaa cahen jahuen quimisha coti sca jan hihquipish bi hahquirihbi teehihquipish jahuen haxenicabo qui jaa sanareneni jahui. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Piquin jaabijahiboya Simon Pedro sca Jesusen yohiquin: —Simon, Juaman baquen, ¿neabo hehon queenai bi hashoan bi res min hehon queenain? —hahquin. —Jeen. Mihon ta hen queenai, Hihbon. Min tah min honanai —hihqui Simon. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","—Heen carnerobo pimahue —hahxon yocarihbiquin jahuen rabe coti sca: —Simon, Juaman baquen, ¿min hehon queenain? —hahquin. —Jeen. Mihon tah hen queenai, Hihbon. Min tah min honanai —hihqui. —Heen carnerobo pimaxonhue —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jahuen quimisha coti sca yocarihbiquin: —Simon, Juaman baquen, ¿min hehon queenain? —hahquin. Min hehon queenain hahquin jan quimisha coti yocacai copi Pedronen masa shinanscaquin. —Mian tah min jatihibi honanai, Hihbon. Mihon tah hen queenai. Min tah min honanai —hahquin Pedronen. —Heen carnerobo pimaxonhue. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mia tah hen yohicoinai: beronan hihquish tah min miin chopa sahuehax min jano queenaiton nihpahoniqui. Yosiboscaax tah min miin mequen cataxon sanatihi, huetsan mia sahuemaxon jano min cacatsihyamahiton mia bonon —hahscaquin Jesusen. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jan yohihi ta jascahahbo mahuaxon noquen Papa Dios Nete Hihbohi Pedronen jato honanmayaxihquiqui honanahbo. Jaa pecaho: —Hea chibanhue —Jesusen Pedro jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Rabejaquexon hahan Jesus queenai jahuen haxenicanen jato chibanbenahi Pedronen jisquin. Jaa cahen pihiboya Jesus senenbixon yocaquipi, Tsoan mia parannoxihquiquin, Hihbon, hihnicah. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jaa jisxon cahen Pedronen Jesus yocaquin: —¿Hoa cahran, Hihbon? ");
INSERT INTO kaqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Hea jonon caman jaa manati hen queenaiya, ¿mihqui jahua hihti quin? Mian hea chibanhue —Jesusen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaa copi ta jaa pecaho hicha noquen huetsabo jaya joihi yohuanpahonishqui: —Jaa haxenica ta mahuayamayaxihquiqui —hihcani. Jasca que ma bi Jaa ta mahuayamayaxihquiqui Jesus hihyamani. Hea jonon caman jaa manati hen queenaiya, mihqui jahua hihti quin hihresi. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jaa haxenicaxon tah hen honancoinxon nea joibo huishahahqui. Honancoinax yohuana joi tah qui. Non tah non honanai. ");
INSERT INTO kaqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hashoan hicha rihbi ta Jesusen hahnishqui. Jatihibi huishapaquehah rah cahen mai senenyamascaan, quirica bochohi.");
INSERT INTO kaqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mihqui huishamenoxon tah hen Jesusen hahni jatihibi mia yohinihqui, señor Teófilon, jan honanmani rihbi mia yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Hinahihnanoxon caman jan hahpahoni jatihibi tah hen mia yohinihqui. Hinahihnarihyamaxon ta jan caisni jahuen raantibo jaan yohinishqui jascahahbo. Dios Yoshiman shinanmaha jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jihui qui hueonahbo mahuatipish bi cahen jaabaan jisíbo hihquish jato qui sanareneni jahui, jan hahquirihbi jihuetai honanahbo. Cuarenta neten cahen jato betan hihcanahi. Jato nihquihinxon jenquetsahaquin Papan noque jihuemayaxihquin jato honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jato betan pixon cahen jato yohiquin: —Jerusalen jema potabahinaxma janobinahue, Papan yohini nocoyaxahnon caman janobi mananahue. Jaa ta Papan hinanyaxihquiqui hah ta hen mato janiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juaman mato jenen nashimani bi ta Papan mato jahuen Yoshin hinanyaxihquiqui nashimaquin hahcajaquin hicha hinanresquin. Jan jascajati nete ta nea pishca sca jaonahiqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jaatian hahqui tsinquirihbixon Jesus yocacanquin: —¿Noquen caibobi sca hahquirihbi noquen hapo janon min rahmabi noquen nahuabo camatihin, Hihbon? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yocacahbo jato yohiquin: —Jaabi hihbo hihxon ta jayaxihquibo Papan yohinishqui. ¿Jahuentian jaticaniquin? ¿Jahua neten jayaxihcanihquin? Man tah man honantimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jaa man honantimahi bi ta Dios Yoshiman mato coshi hinanyaxihquiqui mato qui botopaquexon. Coshi bichish tah man hehqui chanicoinyaxihqui Jerusalen jema janin, Judea mai jatihibinco rihbi, Samaria mai janin rihbi, jano nai chibechijaquehtancahuanaiton rihbi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jascahiton cahen Papan jaa bihinihniquin jaton jisnonbi. Nai cohiman pantehah cahen jisyamascacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jan cahiya nai bejisihnihi nih nichaibaan bi joxo chopaya rabe jato patax nihreneni jahui. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nihrenenxon yocacanquin: —¿Jahua jenquetsahin man naihoh jisichain, Galilea mai mehabaan? Maton jisnon bi jan naihoh hinahihnatai quescaquihrani ta joribiyaxihquiqui, Jesus, jaabi, huetsama —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jasca jaabo jaiya cahen Olivo janeya mahchin mehax Jerusalen janin boribicani. Jaa mahchi ta Jerusalen hochoma qui noquen xobo janinhax noquen huai tihixon. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nocotax rabe tapoyahpa xoboho bocani bochiquiha chique janin, jano jaabo jihuetai janin. Pedro, Juan, Jacobo, Andres, Felipe, Tomas, Bartolomé, Mateo, Alfeon baque Jacobo, Simon Celador, Jacobon baque Judas. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jaabo rahsichin Papa jaayocacanquin jaa shinan huestiya hihxon. Jato betan haibobaan rihbi yocaquin. Jesusen jochicabaan rihbi, jahuen mama Marían rihbi yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jano cahen noque huetsabo tsinquicani, ciento veinte rah. Jato tocan mehax huenihihnaxon Pedronen yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Papan huishamani joi jai quescari ta jahoxqui, noque huetsabaan. Judasen jascajayaxihqui ta Davidinin huishanishqui, Dios Yoshiman shinanmahah. Jesus bihmanoxon ta Judasen Jesus qui jonibo hihuehoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jaa Judas ta noque betan hihpahonishqui, jaa rihbi nea tee hihbomahah. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jan hohchaquin cananai coriquinin ta mai marohoxqui. Marohax paqueti behoracareneni pohtoshihcahinax jahuen pocobo napaquehreneni. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jan jascajahi jatihixonbi honanxon ta Jerusalen janin jihuetaibaan jaa mai janenishqui Acéldama, jaton join. Jimiyahpa mai hihcatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Salmos quirica janin ta nea joi huishá jaiqui: Jahuen xobo xahbanscanon tsoabi jano jihueyamascanon hihqui jaa quirica janin. Jahuen tee rihbi huetsan hihbojanon hihqui huetsa quirica janin rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Jascabi sca janon huetsa sca caisnahue. Noque betan huetsa sca yohinica caisti ta jaiqui. Juaman noquen Hihbo nashimani tian noque betan nihni joni huesti. Noquen Hihbaan noque nihquihinpahoni tian noque betan nihxon rahma caman noque manapahoni joni huesti caisnahue, noquen jisnonbi noquen Hihbo hinahihnanon caman noque manapahoni joni. Jaan ta noque betan noquen Hihbo Jesus rehtehahbo bi hahquirihbi jihuetai yohicointihiqui —jato jaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jaatian cahen rabe joni naponbi nihmacanquin. Huetsa cahen Matías. Huetsa cahen José, Barsabas hahcaibo. Justo jahuen jane huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Jaatian cahen Papa yocacanquin: —Hihbon, mian tah min jatihibi jonibaan shinan honanai. Criston raantibaan tee ta Judasen potabahinhoxqui jano jan cacatsihquiton canoxon. Rabe joni tah non naponbi nihmahi. ¿Jahuemeha min caisain Judasen tee jan hihbojanon? Noque jismahue non honannon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jascajaquin yocaxon jahuemeha hin honannoxon macan bero borasa qui nanexon chicoxon jiscanquin. Jisxon Matías honanscacanquin. Criston once raantibo betan sca hihnon jaton hahbe raanti janecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostes fiesta nete nocotaiya cahen jaabo jatihibi huesti xoboho tsinquiti. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jano tsahotaibaan bi nihuehhuan corotihcamahi naihoh quehax jahuex jaa xoboho coshin corotai nincacanquin jatihibichin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jascascaiya cahen chihi perehihquicamahi romishin jato qui paquereneni. Chihi perehihquicamahi joni tihibi maracahreneni. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dios Yoshiman sca jato jatihibi hihbojaquin. Jaan hihbojaxon shinanmaha huetsa join sca yohuancani. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jerusalen janin ta jatihibi mai janinhax jahuex Papahon shinanai judiobo jihuecanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yohuanaibo nincacax cahen jato qui hicha tsinquijaqueti. Yohuanaiboya jatihixonbi jahuenahbi jahuen joi nincaquin. Huetsan jahuen joi nincaquin. Huetsan rihbi jahuena nincaquin. Jascajaquin jaton joibi nincacanquin jatihixonbi. Jascascaiya jahua copi jascarihquin honanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rahte rahtexon yocacanquin: —¿Yohuanaibo Galilea janinhahbo rahsima hin? ");
INSERT INTO kaqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Jascaraiboya ¿jenquetsahaxon non noquen mai meha joibi non nincacain jatihibichin? ");
INSERT INTO kaqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Neno tah non jai partobo, medobo, elamitabo, Mesopotamia janinhahbo, Judea janinhahbo, Capadocia janinhahbo, Ponto janinhahbo, Asia janinhahbo, ");
INSERT INTO kaqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia janinhahbo, Panfilia janinhahbo, Egipto janinhahbo, Cirene hochoma Africa mai janinhahbo, Roma janinhax pasijahi jahuibo, ");
INSERT INTO kaqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","noquen caibo, nahua hihpahonish bi noquen caiboscaibo rihbi, cretensebo, árabebo. Papan coshin hahcai joi yohuanai tah non nincacai, noquen joinbi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rahtetax jahua copi jascarihquin honanyamahax yocacahnanancani jatihibi: —¿Jahuatohon yohuanihquin non jascajaquin nincanon? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jascahibo bi yohuanxon sca caibaan hosanquin: —Pahenax ta jascari yohuancaniqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jascaraibaan bi hahbe raantibo betan nihrenenxon Pedronen jato coshin yohiquin: —Judea mai mehabon, Jerusalen janin jihuetaibaan. Man honannon hihxon tah hen mato yohihi. Hea nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Noque pahenai shinan man jai bi tah non pahenyamahi. Bari ta queyarihyamahiqui. Nescaran ta tsoabi pahenyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pahenaxma bi tah non Papan joi yohinica Joelinin yohini quesca noque jai. Joelinin ta nescajaquin huishaxon yohinishqui: ");
INSERT INTO kaqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Papan ta yohihihqui: Nete queyoti hochomascaiya tah hen jatihibi jonibo heen Yoshin hinanrestihi. Hinanah sca ta maton baque bebobo, maton baque haibobo rihbi hean shinanmaha yohuanyaxihquiqui. Maton beronanbaan ta namaquen hahcajaquin hahan honantibo jisyaxihquiqui. Maton yosibobaan rihbi ta namayaxihquiqui hean jismaha jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jaa neten tah hen heen teexonnicahbo bebobo, heen teexonnicahbo haibobo rihbi heen Yoshin hinanrestihi. Hinanah ta hean jismahah yohuanyaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Naihohxon tah hen hahan rahtetibo cainmatihi. Main rihbi hahan honantibo sca cainmaribiquin. Jimi, chihi rihbi, chihi cohin rihbi jato jismaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bari ta bahquishihcahinscatihiqui. Hoxne ta joshincahintihiqui, jimi quescacahini. Jascapahbo ta jatihiqui Hihbo joriyamanon. Jahuen joti nete nocotaiya ta jato casticani jotihiqui jahuen coshi jato jismanoxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hea hihbojahue Hihbon, hihquibo jatihibi ta Hihbaan teehihmatihiqui. Jascajaquin ta Joelinin huishanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hen mato yohihi nincanahue, heen caibaan. Jesus ta Nazaret janinha joni hihnishqui. Papan raanai joni jaa hihqui man honannon hihxon ta jahuen coshi Papan hinannishqui tsoan jascajani que ma bi jaa coshiyaxon jan hahnon. Jisish hahan rahtetibojamaquin. Hahan honantibojamaquin. Maton jisnonbi ta jascajanishqui man tah man honanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Man rehteyaxihqui honanxon Papan yohini quescabijaxon ta Judasen mato jaa Jesus hinanhoxqui. Hinanah tah man rehtehohqui nincayosmabo jaa jihui qui hueonmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Rehtehipibaan bi ta Papan huenirihbihoxqui teehihmaxon. Jaa ta jascabi mahuatai jatimahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hahqui yohuanxon ta Davidinin rihbi huishanishqui: Netetihibi noquen Hihbaan hea manahi ta hen honanai. Hea pataxxon ta hea yanapaniqui, hen masa shinanyamanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaa copi tah hen coin coinax siripi yohuanai, mahuatax bi hen hahquirihbi jihuetihi honanax. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Hea jascabihi mahuatai hihyamanon tah min hea potabahintimahi. Minabi miin joni tah min pisimatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Hea jahuentianbi queyoyamanox manati tah min hea honanmahi. Hea manaxon tah min hea hihti jenimamatihi. Jascajaquin ta Davidinin huishanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Honanquin sirijaxon tah hen mato yohihi, heen caibaan. Neateman jihueni noquen xeni Davidi ta mahuatai tsahoncannishqui. Jahuen tsahon ta rahma caman jaiqui. Jatihixonbi tah non jaa honanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Miin jihuetahbo jan yononon hihxon tah hen miin xohta quiquin hapomayaxihqui hah ta Papan janishqui, jahuentianbi jahuen joi huetsajayosmaxon. Jan jascani honanxon Papan jismaha yohinica rihbi hihxon ta Cristo hihquipi bi Papan huenirihbitihi jaan honannishqui. Jaa yohihi ta jan jascabihi mahuatai hihyamanon potabahintimahi, jahuen yora rihbi pisimatimahi hihnishqui David. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jaa Jesus hihquipi bi Papan huenirihbihi jisoxon ta non mato yohicoinai jatihixonbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Quiquin Hihboscahue Papan jaah ta jaa mecayaho sca Jesus tsahotihqui. Papan noque Dios Yoshin hinantijanixon ta nea man jisxon nincacai jaan hinanresiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David ta naihoh nihinahyamanishqui. Jaanbi ta yohinishqui: Noquen Hihbaan ta heen Hihbo yohinishqui, Hea mecayaho tsahotihue. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Miin rahuibo hen mia namanjaxonnon caman tsahotihue, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Jaa copi honanquin sirijanahue, heen caibaan jatihixonbi. Jaa man jihui qui hueonmaho Jesus ta Papan yohiscaiqui jaa huesti Hihbo hinon, jan caisai joni —jato jaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jan jascahi nincaxon masa shinanxon Pedro, jahuen hahbe raantibo rihbi yocacanquin: —¿Jahueja sca non jatihin, noque huetsabaan? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—Maton shinan pontenahue. Cristo sca maton Hihbo hihnon hihxon non mato nashimanon yohinahue maton hohcha jan sohuanon. Jascajahiton ta mato Dios Yoshin hinanrestihiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mato ta hinantijanishqui, jahuen yoshin mato hinanti, maton baquebo rihbi, jatihibi hocho quehabo rihbi, noquen Papan quenahibo rahsibi —jato jaquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Basi yohuanxon cahen jato yohiquin sirijaquin: —Nea tiromabo qui nocoyaxihqui casticanti mato xahbanjamanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaatian sca jan yohihah nincacoinaibo nashimacanquin. Jaa netenbi ta tres mil jonibaan Cristo bihnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Criston raantibaan honanmaha cahen nincaquin jeneyamacanquin. Jato manacanquin. Noquen hohcha copi Cristo mahuaho shinanhahnan picanquin. Papa yocaquin jeneyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hicha hahan rahtetibo jahuen raantibaan hahcai jisish rahtecani. Hahan honantibo rihbi hahcaibo jisish raquecani jatihibi. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Hahmerihbi cahen jihuecani nincacoinaibo rahsi. Jaabo jai jaton jahuaborabo jatihixonbi hihbojacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jaton jahuaborabo, jaton mai rihbi maromaxon cahen coriqui hinanpaquecanquin jaabo pishinai tihi jato hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jatihibi neten huesti shinanyahax Papan xoboho nocohihnacani. Jenimaxon shinanquin sirijaxon jaton xobohoxon sca picanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Papa qui siripi yohuani jihuecani. Janohahbaan rihbi jato sirijaquin yohuanquihnquin. Jato betan nocohihnataibo caicananon jan teehihmahibo noquen Hihbaan rihbi jato nocohihnamaquin jatihibi neten. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bari racapaquescaiya cahen jaabo hihqui quescari jascaran Papa yohihi tsinquitaiboya Pedro betan Juan Papan xoboho mapeti cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jano rihbi cahen huesti joni chanto jahuen maman bihni jascabi sca caibaan hioxon xehqui patax racanquin jaa neten tihibi. Siri Xehqui hahcaibo patax racaxon Papan xoboho mapetaibo coriqui yocaquin chanton. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro betan Juan jaa xoboho mapecatsihscai jisxon jahuen mequen mehanahxon coriqui pishca jato yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yocaca jaa jisquin sirijaxon sca: —Noque jise —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jascahahbo coriqui pishca bihti shinanxon jato jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—Heen coriqui yamahi bi tah hen hen huetsa jai pishca mia hinanai. Jesucristo Nazarenon janen ta hen mia yohihi. Nihrescahue —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jascajaxon mecayaho mehuetanxon huenihihniquin. Huenihihniha jahuen tahebo jahuen tapoxcobo jahuen ponobo coshicahinax cayatani nihrenenscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nihaquehtanscai. Nihaquehtanax jato betan sca Papan xoboho mapescai. Nichish cayacanahax: —Papan ta hea hahxonihqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nichish jascari Papa qui siripi jaa yohuanai jisxon cahen jano hihquibo rahsichin jaa honanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Siri Xehqui hahcaibo patax jaabi tsahoxon Papan xoboho mapetaibo coriqui yocarahsihi honancanquin. Jan siriscai honanax hihti rahtecani. Rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pedroya Juan jaa jonin xecohiya jano hihquibo rahsibi rahtetax Salomonen xobo hahcaiboho jato qui tsinquijaqueti, xobo rechiho. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tsinquijaquetaibo jisxon Pedronen sca jato yohiquin: —Heen caibon. ¿Jahua copi man nea jisish rahtetain? ¿Jahua copi man noquen coshinbi noquen shinamanbi non nea joni nihmahi quesca man noque jisin? ");
INSERT INTO kaqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Noquen xenibo hihpahoni ta Abraham qui, Isaaque rihbi, Jacobo rihbi. Jaton Papa Dios ta noquenah qui. Jaa noquen Papan ta jahuen joni Jesus shinanya hih mato jismahihqui, Pilato jaa Jesus hinanax man queenyamahoh que bi. Pilatonen jaa picocatsiqui bi tah man queenyamahohqui, noque jihuemanicahma tah qui hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jaa ponte joni que bi tah man queenyamahohqui, jaa Papan baque que bi. Queenyamaxon tah man rehtemis joni mato picoxonti man yocahohqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Noque jihuemanicah tah man matonbi rehtemahoqui. Rehtehipibaan bi ta Papan teehihmarihbihoxqui. Jan teehihmahi jisoxon tah non mato yohiscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cristo honancoinxon tah non jahuen janen nea joni rohajahaqui, nea man jisi man honanai jonibi. Jan noque hinanai shinaman tah non nea coshijahaqui, maton jisnonbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Honanyamaxon tah man rehtemahoqui, noque huetsabaan. Maton tinintibaan rihbi honanyamaxon rehtequin. Hen tah hen honanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cristo ta hohmis hohmisyaxihquiqui hihxon Papan joi yohinicabaan jatihixonbi janí quescaja ta Papan jahoxqui jascahahbo. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaa copi maton shinan pontenahue, maton hohcha Papan sohuanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Sohuaxon hahan maton shinan behnajati netebo Papan mato hinannon. Pontejaquin shinanax sca jihuenahue. Jan mato hinanai jahuen Cristo ta Jesus qui. Jaa jan raannon pontejaquin shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jahuen joi yohinon hihxon ta jahuen joi yohinicabo Papan caisnishqui. Jaabaan yohini jatihibi quesca janon caman ta noquen Jesus naihoh banetahbiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisesnin ta yohinishqui: Maton huetsabi ta joi yohinica Papa Diosen mato qui raanyaxihquiqui jaa maton huetsabi hea quescapa joni. Jan yohihi jatihibi tah man nincatihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jaa joni nincayamahi jatihibi tah man Papan baqueboma qui picomaxon queyobahintihi, hahquin huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel jaa pecaho joxon yohinicabo rihbi jatihibi ta jascarihbihi yohuannishqui, nea netebo yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mato tah man hoa yohinicabaan baquebo qui. Main jihuetaibo jatihibi jato shinan siri hinannon tah hen miin baquebo sirijaquin shinanmatihi, hah ta Papa Diosen Abraham janishqui. Jaanbi mato hahxonnoxon ta maton xenibo rihbi jascajati yohinishqui. Jaa copi ta jaa joi matonah rihbi qui, Papan jisnonbi man jascanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jahuen baque raanxon ta mato qui pari Papan jaa raannishqui. Maton hohcha potamaxon mato jatihibi sirijaquin shinanmahi jonon hihxon mato qui jaa raanquin —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sacerdotebo betan Papan xobo coiranai sontarobaan hapo sca becani. Saduceobo rihbi jato betan jahui. Joxon sca tsinquitaibo yohihiton meracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jan Jesus hueniho quescajaquin mahuanihbo Papan hueniyaxihqui hihxon cahen jano jai jonibo Pedro betan Juaman nincamaquin. Jato honanmahi merahax sinaxon jato bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bihxon bepiscai copi bahquish pari jato casticanyaxahpan hihxon sipo xoboho jato tsahoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jaabi ta Criston joi siri nincacaibaan hichaxon nincacoinnishqui, cinco mil jonibaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hoxashinahax mohiyahtax jaton hapobo jatihibi jaton hanibo betan tsinquiscai. Huishani honanbo rihbi jato betan Jerusalen jema janin tsinquiti becani. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jaton quiquin sacerdote Anas, Caifas, Juan, Alejandro, jaabo, quiquin sacerdotebaan jenabo jatihibi rihbi jato betan tsinquiti. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro, Juan naponbi nichinxon yocacanquin: —¿Jahua coshin man hahquipiquin? ¿Jahua janen man jascajahipiquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dios Yoshiman hihbojaha sca Pedronen jato yohiquin: —Jema hihbobon, noquen hapobon. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Jenquetsahaquin man nea chanto rohajahipiquin? ¿Jahuatohon man jaa rohajahipiquin? hah man noque jaiya tah hen mato yohihi, man honannon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jatihibi noquen caibaan honannon hihxon tah hen mato yohihi. Maton tah man Jesus Nazareno jihui qui hueonmaxon rehtehohqui. Jaa man rehtehipi bi ta Papan hahquirihbi teehihmahoxqui. Jahuen janen tah non nea rohajahipiqui, rahma siri sca mato bebonbi nihnon. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jaa Jesus ta hahqui xobojati jihui quescapah qui, tiroma tah qui hihxon man xobojahibaan potanih que bi. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jaa huestichin ta noque teehihmati hahtipahiqui. Huetsa noque teehihmanica ta yamahihqui ni jahuenbi. Jaa huestichin jonibo teehihmanon ta Papan jaa yohihihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Raquetaxma Pedro betan Juan yohuanai jisxon, escuela janin hihpahonima bi jemama qui hanini rabe jato honanax rahtecani. Jesus betan nihpahonibo sca jato honancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Rohajahipi joni jato patax nichi jisxon joi bichincatsihxon bi jahua yohiti hahtipahyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsinquitaiboma qui jato picomahax res sca yohinannanscacani: ");
INSERT INTO kaqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Jahueja non jato jatihin? Hahan honanti hani ta hahquipicanaxqui. Jatihixonbi ta Jerusalen janinhahbaan honanihqui. Hahyama ta jaipicanaxqui, hih tah non jatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jaabi, jaa joi huetsabo janin caícanayamanon jato yohinon benahue. Jaa janen yohuanyamascanahue, non mato rishquimis jistahi man tan, hahquin jato yohinahue —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Quenamaxon sca jato hihti yohicanquin: —Jesusen janen yohuanyamascanahue tsoh. Jahuen janen tsoabi yohiyamanahue —jato jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Jascahahbo Pedro betan Juaman jato yohiquin: —¿Papan jisi jahuemeha ponte quin? ¿Mato noquen nincati nan? ¿Noquen Papabi non nincati nan? Shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Noque tah non non jisnibo chaniti jai, non nincanihbo rihbi yohiti jai. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jascaraiton jato tahtijaribicanquin. Jema janin jato nincacatsihquibo hicha jai quen jenquetsahaxon casticanti honanyamaxon tahtijaribixon jato Boresscatannahue hahrescanquin. Jaa rohajahipi honanxon texe jatihixonbi, Hahxon tah min jaa jai Papan, jaiboya, casticanti hahtipahyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hahan honantijaquin jaabaan rohajahipi joni ta cuarenta bari janishqui, hashoan rihbi. Jaa copi cahen jatihixonbi jaa honancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Boresscatannahue hahcabo sca jaton hahberabetibo qui caxon jaton sacerdote hapobo betan jaton hanibaan jato tahtijahi yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yohiha jatihixonbi Papa yocacanquin: —Hihbon, naiyahpa mai, hian, janobo jai jatihibi rihbi tah min hahniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Miin Yoshin siri mian hinanah ta noquen xenibo David miin jonixon miin joi yohinishqui: ¿Jahua copi noquen nahuabo sina sinatihquin? ¿Jahua copi noquen caibaan honanma jai joibo yohiti shinanihquin? ");
INSERT INTO kaqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mai meha quiquin hapobaan ta jaton sontarobo nichinihqui rehtemanoxon. Jaton hapobo tsinquicani, noquen Papa rehtecatsihqui, jan caisai joni rihbi rehtecatsihqui hah ta Davidinin janishqui huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Jascacoini. Herodes, Poncio Pilato, nahuabo, noquen caibo, jaabo jatihibi ta nea jema janin tsinquihoxqui. Minabi miin joni qui sinatax ta tsinquicanhoxqui. Min caisai miin Jesus qui ta sinacanhoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mian shinanxon miin mequeman hahmaha jayaxihquibo min yohini quescabija ta jaabaan jahoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Rahma jaabaan hahan noque tahtijahi joibo jise, Hihbon. Raquexonma non miin joi yohinon noque coshi hinanhue, noque miin jonibo. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Miin mequeman mehexon jonibo rohajahue. Miin baque Jesusen janen non hahan honantibo hahnon hahan rahtetibo rihbi non hahnon jahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Papa yocaquin janquenja sca jaiboya jaabo jano tsinquitai xobo xayascai. Dios Yoshiman jato jatihibi hihbojaha sca raquexonma Papan joi yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jaatian cahen nincacoinaibo jaa shinan huestiya hihcani. Jatihixonbi jaa huesti shinancanquin. Jan jaibo yohihi, jaa ta hena res qui, hih tsoabi jayamahi. Jatihibi jaya hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Papan coshiyaxon hahxon cahen noquen Hihbo Jesus hahquirihbi teehihscai yohicanquin jahuen raantibaan. Jato jatihibi ta hicha shinan Papan hinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jato tocan tsoabi jahuabi pishinyamahi. Xobo jaxon maromacanquin. Mai jaxon jaa rihbi maromacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Maromaxon coriqui bihxon caxon Criston raantibo hinancanquin. Jaabaan sca pishinaibo hinanpaquenon. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","José janeya huesti ta Criston raantibaan Bernabé janenishqui. Bernabé cahen sirijaquin shinanai baquebo hihcatsihqui. Jaa cahen Chipre janinhax joní, levito joni. ");
INSERT INTO kaqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mai hihbo hihxon cahen jahuen mai maromaxon coriqui bichish jaya caxon Criston raantibo hinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananías janeya jonin sca jahuen haibo Safira betan jaton mai maromaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Coriqui bihxon, Jascajahue jahuen haibaan rihbi jaah, texe mequecanquin. Texe mequexon texe boxon Criston raantibo taracanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedronen sca yocaquin: —Ananin. ¿Jenquetsahaxon Satanasnen miin jointi hihbojahaxquin, min maromahi texe yohuashihxon Dios Yoshin paranti min shinannon? ");
INSERT INTO kaqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Maroyamaha minabi hihyamahipishquin? ¿Maromaxon sca jaa coriqui hihboxon quesayamaxon min queenai quescajati min hahtipahyamahin? ¿Jahua copi sca min jascajaquin paranain? Jonima bi tah min noquen Papabi parancatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jan yohihah nincacax Ananías racareneni mahuascai. Jaa chanihi joi nincacaibo rahsi sca hihti raquecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Beronanbaan sca huenixon Ananías rahcoxon boxon tsahoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Quimisha horabo huinohax jahuen haibo sca hihcohi. Jaan cahen jahuen bene jascarax mahuatah honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jaa sca Pedronen yocaquin: —Hea yohihue. ¿Man noque hinanah tihi copitai min mai maromahaquin? —hahquin. —Jatihi copitai rahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedronen sca: —¿Jenquetsahpahin man rabexonbi Dios Yoshin tanati shinanahquin? Nincahue. Miin bene tsahontanaibo ta mapescaiqui. Mia rihbi sca ta hioxihcanihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jaatian cahen Pedro taracahrenenax haibo mahuati. Hihcoxon cahen haibo mahuascai meraxon beronanbaan boresscaquin. Boxon jahuen bene janin tsahonscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jaatian ta nincacoinaibo jatihibi hihti raquenishqui. Jaa joi nincacaibo rahsi raqueti. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jaa jema janinxon ta Criston raantibaan hicha hahan honantibo hahnishqui, hahan rahtetibo rihbi hahquin. Salomonen rechí xoboho sca jatihibi tsinquicani. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tsinquitaiboya caibo tsoabi jato betan tsinquiyamahi raquetax. Raquexon bi jema janinhahbaan jato hihti siri jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nincacoinaibo cahen caícanascai. Bebobo, haibobo rihbi tsamascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hihti caiboscaiya cahen jema bahinbi jaton pishinbo, jaton cacajatibo racanxonxon jaton hisinyahpabo jano racancanquin, Pedro jahuiya jahuen bari yoshiman bocabi jato huinonon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalen hochoma jemabo janinhax sca hicha jonibo jahui. Jaton hisinyahpabo hihuecanquin. Tiroma yoshinyahpabo rihbi hihuecanquin. Jato jatihibi ta Criston raantibaan rohajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jasca sca jaiboya jaton quiquin sacerdote jahuen hahbe saduceobo betan notsi notsiscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Notsi notsixon porisiabo bihmaxon Criston raantibo sipo xoboho tsahoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tsahonahbaan bi yame noquen Hihbaan naihoh queha yonoti joxon sipo xobo xehpoti quehpenxonxon jato picoquin. Picoxon: ");
INSERT INTO kaqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Botannahue. Papan xoboho mapexon jonibo nea hahan jihueti joi jatihibi yohitannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jan yohihi quescabijascacanquin. Xaba paquetaiya bi Papan xoboho mapexon jonibo haxemascacanquin. Jaatian cahen quiquin sacerdote, jaabo, jahuen hihti janin nocoxon hahbe hapobo tsinquimaquin israelibaan hanibo rahsi. Jato tsinquimaxon porisia sca sipo xobo janin raancanquin jato hihuenon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sipo xobo janin nocoxon sca porisiabaan jato xahbanjaquin. Joribixon sca jan xahbanjatanai yohicanquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Xehpoti jascabi xehpohah tah non meratanai, hihti xehpohah. Sipo xobo coirannicah rihbi tah non jahuen xehqui xehnichai jistanai. Non quehpenxon jisí bi ta tsoabi yamahaxqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chanihibo nincacax Papan xobo coiranai sontaro hapo betan quiquin sacerdotebo rahtecani, ¿Jahua sca janoxihquiquin? hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jato yohihi sca huetsa jahui. —Man sipo xoboho tsahonipibaan ta Papan xobohoxon jonibo haxemahiqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jahuen sontarobo betan caxon jaa xobo coiranai hapon sca jato hihuequin. Jan hapo qui hihuehi copi jonibaan jato macaman tsacapaho hihxon coshixonma jato hihuequin honaxonbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hihuexon hapobo tsinquitai naponbi sca jato nichinquin. Quiquin sacerdotenin sca jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Jaa janen yohiyamascanahue hah tah non mato jaipiqui, sirijaquin yohiquin. Yohihah bi tah man Jerusalen jatihobi maton honanmati joi jato nincamahi. Jaa joni rehtehoh quen tah man jaa hohcha noque hihbomacatsihqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Hahbe raantibo betan Pedronen sca yohiquin: —Joni mentan tah non hashoan noquen Papa nincati non jai. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Noquen xenibaan Papa Diosen ta Jesus teehihmarihbihoxqui, jihuin hueonxon man rehtehipi que bi. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jaa ta noquen Papa Diosen huenihihnihoxqui, jaa mecayaho tsahonon quiquin hapo sca jonibo teehihmanicah. Noque israeli baquebo ponte shinan hinanxon noquen hohcha sohuanon ta noquen Papa jaa huenihihnihoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noquenbi jisoxon tah non yohiscai. Noque ta jahuen Yoshin siri rihbi Papan hinanihqui jahuen joi nincacoinaibo rahsibi. Noque ta yanapanihqui —hihqui Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jascahahbo nincaxon cahen hihti sinaxon jato rehtecatsihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jano rihbi huesti fariseo tsahoti, Moisesnin huishani joi honan, Gamaliel janeya. Jatihibi jonibaan siri jisi joni. Hapobo tocan nihrenenxon Criston raantibo jatoma qui picomatahtahxon jaan jato yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","—Heen caibaan. ¿Jahueja man jaabo jacatsihquin? Sirijaquin shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Neateman ta Teudas jonishqui. Hapohihti shinanax yohuanaiton sca ta hicha tahni jonibaan jaa chibannishqui hahbetan nihcatsihquibaan. Cuatrocientosbo. Jaabi hihbocatsihqui bi ta rehtexon jaa chibanaibo rihbi jabamacannishqui, jahuabi sca yamanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jaa pecaho ta Galilea janinhax Judas jonishqui jonibo toponpaquehibo tian. Caibo hiohiton bi ta jaa rihbi rehtexon hahbe cahibo rihbi jabamacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaa copi tah hen mato rahma yohiscai. Jaabo jenenahue, jenebahinquin. Jaabaan bi shinanxon hahcaiya cahen jahuabi jatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Papa Diosen shinanmaha hahcaiboya cah man jenquetsahaxon bi jato pantetimahi. Dios betanbi man rehtenanai man meramis —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nincacax jeenhihcani. Criston raantibo quenamaxon sca rishqui rishquimaxon Jesusen janen yohuanyamascaabo hihxon tahtijaxon jato camascacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Picohahbo hapobo janinhax jenimacanahi bocani. Criston jonibo copi ta mato tiromajacaniqui. Tenescaibo tah man qui Papan jaiya jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jatihibi neten Papan xoboho yohuanax jaton xoboho rihbi yohuancani. Jesus ta Papan caisai joni qui hihcani. Honanahbo nete tihibi nincamahi tantiyamacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nincacoinaibo caícanahiya sca ta hebreobo qui helenistabo reren rerencanishqui. Nete tihibi piti hinanpaquehibaan jaton yononmabo hinanyamahiya reren rerenscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nincacoinaibo tsinquimaxon sca Criston raantibaan jato yohiquin: —Non Papan joi yohiquin jenebahinxon piti metexxona ta tiroma qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaa copi man honanai siri jonibo caisnahue. Siete caisnahue, Dios Yoshiman hihbojahi rahsi. Shinan siriya rahsi caisquin, piti hinanpaqueti tee non jato hinannon. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Noque cah non yocaxonxon Papan joi yohinicabo sca jatihi —jato jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","—Jascahah ta siri qui —hihxon sca jatihixonbi caiscanquin. Huetsa cahen Esteban, shinanya siri, Dios Yoshiman hihbojahi joni. Huetsa cahen Felipe. Texe cahen Prócoro, Nicanor, Timon, Parmenas, Nicolas, jaton nahua hihpahonish bi judioni Antioquía janinhah. Jaa rahsi caiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Criston raantibo bebon jato nichinxon mehexon jato yocaxoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Hashoan sca cahen Papan joi caícanascai. Jerusalen janin nincacoinaibo rihbi hashoan caícanahi. Sacerdotebaan rihbi cahen hichaxon nincacoincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hicha Papan shinanyaxon sca Estebanen hihti hahan rahtetibojaquin. Jonibo rohajaquin. Hahan honantijaquin Papan coshiyahpaxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jaatian sca judiobaan Esteban joi bichincanquin. Hinaboma sca hahcaibo, cirenobo, alejandrinobo, Cilicia janinhahbo, Asia janinhahbo. Jaabo rahsichin Esteban joi bichincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dios Yoshiman yanapana hashoan honanax Esteban yohuanaiya sca hahbetan yohinanti hahtipahyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yohinanti hahtipahyamascaxon jonexon coriqui hinanxon caibo sca yohuanmacanquin, quesahahbo hihxon. —Moises qui tiromahi yohuanai tah non jaa nincaquipiqui. Noquen Papa qui tiromahi yohuanai rihbi tah non jaa nincaquipiqui —hihcani quesahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Esteban qui sinatax coro corotahbo cahen jonibo rihbi judiobaan coro coromaquin. Jaton hanibo rihbi, huishani honanbo rihbi sinamacanquin. Jaabaan sca Esteban panterenenxon bihxon jaton hapo tsinquitai janin bocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Quesamisbo sca yohuanmacanquin hahqui yohuanahbo. —Jaa joni ta nea Papan xobo qui tiromahi yohuanihqui. Noquen Moisesnin huishani joi qui rihbi tiromahi yohuani. Tiromahi yohuani ta tantiyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Joxon ta nea xobo Jesus Nazarenon potojaquetanxon noquen hihti quescayamascai non jihuenon Moisesnin joi rihbi huetsajayaxihquiqui hah ta jaipishqui noquen nincanonbi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jano tsinquitai hapobaan sca Esteban bejisquin sirijaxon jahuen bemanan naihoh queha Papan yonoti bemanan quesca sca jiscanquin jatihixonbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","—¿Jascama hin? —hahquin quiquin sacerdotenin sca. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban sca yohuani: —Hea huetsabaan, heen papabaan, hea nincanahue. Xaba Hihbo noquen Papa ta noquen xohta Abraham qui cainnishqui, Haran jema janin jihueti cariyamahax, Mesopotamia mai janin jihuetaiya. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Miin mai, miin jenabo rihbi potabahini catanhue, hen mia jismatihi main sca cahi catanhue hah ca noquen xohta janish noquen Papan. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Papan Cahue hahca cahen Caldeo mai potabahinax Haran janin sca jihueti. Jahuen papa mahuatipi pecaho ta neno sca Papan jaa hihuenishqui. Nea main man neno rahma jihuetai mai janinbi ta hihuenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Jaabi ta nea mai jaa hihbomayamanishqui. Ni huesti tamanehcahinti hihbomayamaquin. Hihbomayamaxon bi hinantijaquin, jahuena hihyaxahnon jahuen baque yamahi que bi jahuen baquebaana, jahuen chini baquebaana rihbi hihyaxahnon jato hinantijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jahuen chini baquebo sca jaton nahuabaan main cahiton jaton nahuabaan jato hihbojaxon cuatrocientos bari jato tiromajayaxihqui ta yohirihbinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jaabi ta jato hinajahi jonibo hean casticanyaxihqui. Jaatian ta picóscaxon nenoxon sca hehon shinanyaxihcanihqui hih ta Papa janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Miin baquebo caijaxon jato jano jihueti hinanah ta heen jonibo hihyaxihcanihqui hea nincacoinaibo hah ta Papan janishqui, Abraham yohiquin. Jaabo honantiyahpabo jayaxahnon hihxon sca ta Honantiyahpa jahue Papan jaa janishqui. Jaa pecaho ta Abrahanen baquejanishqui. Jahuen baquexo Isaaque cainipi huesti semanan huinoxon ta jahuen ocho neten sca Abrahanen jaa jahuen baquexo honantijanishqui. Isaaquen baque sca ta Jacobo janeya janishqui. Jacobonen baquebo rihbi sca ta noquen doce xohtabo janishqui, noquen xenibo. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","José qui notsi notsixon ta noquen xenibaan jaa maromaxon hinancannishqui, Egipto mai janin bohábo. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jaabi ta noquen Papa Dios hahbetanbi nihxon jan yomanahyamascanon yomanahtai tihibi jaa yanapannishqui. Egipto mai janin quiquin hapon José siri joni hihqui shinannon ta José honan joni hihqui jismanishqui. Quiquin hapon sca ta Egipto mai jatihobi jaa José hihbomanishqui. Jahuen xobo hihbomaxon, jahuen xoboho jihuetaibo rihbi jatihibi hihbomaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Jaatian ta Egipto mai janin Canaan mai janin rihbi jahuenbi piti yamascaiya pihan hihcannishqui. Hihti hohmis hohmiscani. Piti merayamabirescanquin noquen xenibaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egipto mai janin tsinquinihbo bimi bero tsama jai joi nincaxon ta Jacobonen noquen xenibo raannishqui marohi cahábo. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jato raanhohxon raanrihbiquin. Jaatian pari ta Hea tah hen qui, Josepan jahuen huetsabo janishqui. Jaatian pari ta Tsoabo Josepan jenabo quin jaa mai meha quiquin hapon honanscanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jahuen huetsabo raanxon cahen jahuen papa Jacobo, jahuen jenabo jatihibi Josepan quenamaquin jano bohábo setenta y cinco jonibo. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jahuen baquen quenamaha sca Egipto main Jacobo cahi. Canish cahen janohaxbi mahuati. Noquen xenibo rihbi yosibohax janohaxbi mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mahuataiton cahen Siquem janin jato boxon jano Abrahanen jahuen coriquinin maroni jano tsahonti main sca jato tsahoncanquin Siquem janinbi. Hamoren baquebo jan maronni tsahon janinbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Papan Abraham yohini quesca sca jaonahiya ta Egipto janin noquen caibo caípahonishqui. Hichascai, jaabo. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Huetsa quiquin hapo sca ta jaresscanishqui, José honannihma joni sca. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jaan cahen noquen caibo paranxon jato tiromajaquin. Jaton baquexobo mahuanon hihxon jato nihi naman potabahinmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jaatian ta Moises baquexo jahuen maman bihnishqui. Noquen Papa Diosen jisí, baquexo siri pishca. Quimisha hoxne xobohoxon jaa coirancanquin jahuen papan jahuen maman. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tahua naman sca jonebahinscacanquin. Jano racanahbo sca jaton quiquin hapon baque haibaan jaa meraquin. Meraxon cahen jahuen baquebi hahcajascaquin hanijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Haniscaiton cahen Egiptobaan quirica jatihibi jaa honanmacanquin. Haniscaxon hicha honanquin. Jan hahcai hochoxon joi nincacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Cuarenta bari jaresscaxon ta jahuen huetsabo pasijahi cati shinannishqui jahuen caibo pasijacatsihquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jahuen caibo tiromajahiton egipto joni meraxon cahen jahuen caibo yanapanquin. Jaa tiromajahi joni copiquin rehtequin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Noque piconon Papan yanapanai joni tah qui hih ta hea yohihi janoxihcanihqui hihqui shinamehti. Hihcax bi jascayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hoxashinahax mohiyahxon sca noquen caibo rabe sinacananaiton meraxon cahen jato sina tantimacatsihquin yohiquin: ¿Jahua jenquetsahin man maton huetsabo betanbi tiromahananain? jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jascahah bi jahuen caibo tiromajahi jonin sca Moises hueranbohanxon: ¿Tsoan yohihah min noquen hapo jacatsihquin? ¿Noque pontenica hihnon tsoan mia yohihiquin? ");
INSERT INTO kaqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Hoa egipto joni min hahquipi quescajaquin min hea rihbi sca rehtecatsihquin? hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jascarai nincacax ta Moises jabascanishqui. Madian mai janin sca jahuen nahua tocan jihuexon rabe baquejaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta bari huinorihbi sca jaiya ta Sinaí nihi namanxon sca jihui naman tiha pishca mapohihcamahi janin Papan yonoti jisnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jascapa merahax rahteti. Jisquin sirijacatsihquish ta hochoma pishca caxon noquen Hihbo yohuanai nincanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Hea tah hen miin papabaan Papa Dios qui. Abraham, Isaaque, Jacobo jaton Papa Dios ta hea qui hihqui nincaquin. Nincacax tastahihqui. Jisti raquescai. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Noquen Hihbo sca yohuanrihbihi: Hea janin tah min nichi. Miin tahe xaca potascahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egipto janin heen jonibo hohmis hohmisai tah hen jisi. Jaabo sai saihihcanahi tah hen nincacai. Jaa copi tah hen jato picohi sca botopaquetai. Johue hihcahisen hen mia Egipto mai janin raannon hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Egipto janin jihuetahbaiton, Tsoan yohihah min noquen hapo jacatsihquin, pontenica mia hihnon tsoan mia yohihiquin hah jaabaan Moises janí que bi ta jaamama jaabi Papan raannishqui jaton hapo sca hihnon. Jato piconica sca hihnon raanquin. Naman tiha jihui mapohi janin jahuen yonoti raanxon ta Papan jascajaxon Moises sca raannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Egipto mai janinxon sca cahen hahan rahtetibojaxon hahan honantibojaxon rihbi Moisesnin jato picoquin. Hian Joshini janinxon rihbi jascajaquin. Nihi namanxon sca cuarenta bari rihbi jascajaribiquin hahan rahtetibojaquin. Hahan honantibojaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jaa Moisesnin ta noque israeli baquebo yohinishqui: Mato tocan ta hea quescapa jahuen joi yohinica Papan cainmatihiqui maton huetsabo janinhahbi, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jaa Moises ta noquen caibo xenibo tsinquitai tocan nihnishqui. Papan naihoh queha yonoti betan ta nihnishqui. Sinaí mahchi janin rihbi ta Papan yonoti betan yohuannishqui. Noquen xenibo betan yohuanni Papan yonoti betan rihbi ta jaa nihnishqui. Hahan jihueti joi ta Papan jaa hinannishqui, mato sca jaan rihbi nincamanon hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Jaabi ta noquen xenibaan nincacatsihyamanishqui. Jaa potabahinxon cahen jaton jointinin Egipto shinanrihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaron sca yohicanquin: ¿Hoa Moises, Egipto mai janinhah noque picoho Moises, jahuen cahipishquin? Non tah non honanyamahi. Noque bebon jaabo sca canon santobo noque hahxonhue jaabo sca noquen diosbo hihnon hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jascajaxon toro quescapa santojacanquin. Jascajaxon jaton hinábo jaa santo rehtexoncanquin. Jaton mequemanbi jascapahahax hahan jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jaa copi ta noquen Papan jato potabahinnishqui. Jahuen joi yohinicabaan huishaxon yohini quescajaquin jato potabahinquin, huishi, bari, jaabo jaton dios sca hihnon. ¿Man cuarenta bari nihi namanxon hinábo rehtexonxon hea mapojaxonpahonihquin; israeli baquebaan? ");
INSERT INTO kaqNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hea queenyamaxon tah man Moloquen chopa xobo bihniqui. Huishi rihbi tah man chibanpahonihqui, Renfan janeya maton dios jai quen. Santojarihbi tah man janiqui jaa sca yocanoxon. Jaa copi tah hen Babilonia hoque tocan mato potatihi hah ta Papan jato janishqui jahuen joi yohinicabo huishamaxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Noquen Papan jato yohini jahan honanti chopa xobo ta noquen xenibo tocan janishqui jaabo nihi naman nihnípahoni tian. Hen mia jismaha quescapahahue hahxon ta Papan Moises yohinishqui jascajaquin jan jaa xobojanon. Jaa copi ta Papan Moises jismani quescapajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Josué betan noquen papabaan jaton mai hihbojanon sca ta neno jihuepahoni nahuabo Papan camaxonnishqui jaton mai bichinahbo. Jan camaxona ta Papan chopa xoboyabi becannishqui nea mai hihbojahi sca. David quiquin hapo hihnon caman ta jaa xobo janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jaa David cahen Papan jisquin siri joni. Jascapahxon ta Papa Dios xobojaxoncatsihxon Davidinin noquen Papa yocanishqui, jahuen xohta Jacobo yamanicaton Papa Dios. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Queenxon bi ta Davidinin jaa xobojayamanishqui. Salomonen ta jaa hahnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jascapa xobo jai bi ta mequeman xobojahibo janin Xaba Hihbo jihueyamahihqui. Papan joi yohinica yohuanni quescari tah qui: ");
INSERT INTO kaqNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nai ta heen tsahoti qui. Mai ta heen taracahti qui. Jatihibi janin ta hea jai. ¿Jenquetsahpa xoboja sca min hea jaxontihin? ¿Hea jano hihti jahua jaiquin? ");
INSERT INTO kaqNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Hoa jatihibi hean hahyamaniquin? hih ta noquen Hihbo jaiqui hih ta Papan joi janin jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nincayosmabon, Papan baquebo hihqui shinanax bi tah man jahuen nahuabo res qui. Maton jointinin shinanxon maton pabinquinin nincaxon bi tah man Papa nincayamabiresai. Dios Yoshin tah man jaapantehi, mato jahuen shinan hinanpanan. Maton xenibo janí quescarihbi sca tah man jai. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Papan joi yohinicabo jatihibi ta maton papabaan tiromajacannishqui. Papan ponte joni joyaxihqui yohihibo rihbi ta rehtecannishqui. Maton sca tah man jaa jahuen ponte joni paranxon rehtehohqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hahan jihueti joi Papan yonotinin mato hinanni que bi tah man bihníxon bi nincayamabiresai —jato jaquin Estebanen. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jascajaquin yohihah cahen sina sinacani. Sinaxon xeta yeres yeresahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jaatian sca Dios Yoshiman hihbojaha jaan nai bejisihniquin. Bejisihnixon cahen Papan xaba jisquin. Papa mecayaho Jesus nichi rihbi jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","—Jisnahue. Nai quehpemehtai tah hen jisi. Papa mecayaho noquebaque nichi tah hen jisi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jascahah bi coshin sai saihihscacani. Mequeman pabepobahini caxon jaa xecotancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jemama qui sca boxon macaman tsacacanquin. Jato betan nichi bebo cahen jano jai, Saulo janeya, beronan tahni. Jaan coiranxonnon hihxon jaton chopa pecaxon jaa taracanxon Esteban tsacacanquin rehtenoxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Macaman tsaca tsacahibaan bi: —Heen yoshin bihhue, heen Hihbo Jesusen —hahquin Estebanen. ");
INSERT INTO kaqNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jascajahax raboxonen nichish coshin sca yohuani: —Hea nescajahax hohchataibaan bi jato casticanyamahue, Hihbon —hihqui. Jascahax cahen mahuascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo rihbi cahen jaa mahuati queeni. Jaatianbi ta Jerusalen janinxon noquen huetsabo tiromajamenocannishqui hihti tiromajaquin. Tiromajahahbo jatihibi jabisi. Judea maibo janin, Samaria maibo janin rihbi jabiscani. Criston raantibo res jabayamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Papahon shinanaibaan ta hihti huinixon Esteban tsahonnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hoa Saulonen ta noquen huetsabo potojaquetannishqui. Jaton xoboboho hihquicahinxon cahen jato bihquin. Bebobo, haibobo rihbi coshin bi res boxon sipo xoboho jato tsahonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jabisipibaan sca Papan joi yohibonaquin jaabo jano cahiton. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Samaria jema janin caxon ta Felipenin jato Cristo joi yohibonanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jan yohihi nincaxon cahen jan hahan honantibojahi jisxon huesti shinanyaxon nincacoincanquin hahqui tsamajaquetaibaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jaan yohihah ta hicha tiroma yoshinyahpabo janinhax tiroma yoshinbo coshin sai saihihquish piconishqui. Yora honanyamajaquetaibo betan chantobo hihti caibo rihbi rohacahini. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jaa copi ta jaa jema janinhahbo hihti jenimanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Felipe nocorihyamahiya cahen jaa jema janin huesti joni janish, Simon janeya. Jahuen yobepan hahxon cahen Samaria mai mehabo rahtehax, Hea tah hen coshi joni qui hihcachihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jaa yobe yohuanaiya ta jatihixonbi nincacanpahonishqui. Jaton jonibaan, jaton patorobaan, jatihibichin nincaquin. Nea joni ta Diosen coshi qui, jahuen hihti coshi hahcaibo, hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jahuen yobepan basi jan jato rahte rahtepahoni copi jaan yohihah nincacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jaabi Papan jato jihuemayaxihqui joi siri Felipenin yohihah nincacoincanquin. Jesucristo joi siri yohihah nincacoinaiton Felipenin jato nashimaquin, haibobo, bebobo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoman rihbi sca nincaquin. Felipenin nashimaha Felipe manati sca hahbetanbi nichi. Hahan honantibo Felipenin hahcai, jan Papan coshiyaxon tsoan jascajani que ma bi hihti coshin hahcai jisish Simon rahte rahtescai. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria mai mehabaan Papan joi bihcoinai honanscaxon cahen Jerusalen janinxon Criston raantibaan Pedro betan Juan jato qui raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Raanahbo cahax nocoxon sca Dios Yoshin bichibo hihxon jato yocaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jesusen jane huestichin Felipenin jato nashimahi quen ta Dios Yoshin jato qui botopaquerihyamanishqui. Jaa copi cahen jato yocaxoncanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yocaxonxon mehehah Dios Yoshin bihresscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Criston raantibaan mehehah Dios Yoshin bichibo jisxon Simon jato coriqui hinancatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Hea rihbi jascajati hahtipahmanahue, hean mehehahbaan sca Dios Yoshin bihnon —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedronen sca: —¿Papan hinanresai jahuen yoshin min coriquinin maroti shinanain? Miin coriquiyabi mia queyoyaxihnon. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Min tah min jahuabi bihtimahi. Jahuabi tah min bihyamayaxihqui. Papan jisí ta miin jointi tiromah qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Min tiromajaquin shinanai pontescahue. Hihbo yocahue, min tiromajati shinanai jan sohuanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Jointi mocapaiya mia notsi notsihi jihuetai tah hen jisi, hohchapan hiná tah hen mia jisi —hahquin Pedronen. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","—Maton caya hea yocaxonnahue man hea yohihi quesca jayamanon —hahquin Simoman. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jaatian sca jaabaan jisobo yohixon noquen Hihbaan joi siri rihbi yohihax Jerusalen janin cahi caribihi. Samaritanobaan jemabo janin joi siri yohibonahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Noquen Hihbaan yonotinin sca ta Felipe yohinishqui: —Caresscahue. Jerusalen janinhax Gaza janin cahi bahin picoti catanhue chiponqui —hahquin. Jaa bahin cahen tsoabi jihueyamahan. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Caresscaax jano sca cahi. Picoti cahi jisí bi Jerusalen janin Papahon shinantanipish Etiopía joni jaa bahin jahui. Jaa cahen hapo. Etiopíabaan quiquin haibo hapon coriqui coirannicah. Jahuen hapon jane cahen Candace. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Isaíasnen huishani joi jisanan jahuen taramehtinin tsahotax cabachonen ninihah taramehquirani jahui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dios Yoshiman sca Felipe yohiquin: —Behchitanhue. Jahuen taramehti janin nanetanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Bishquihihcanahi caxon sca Isaías janeya Papan joi yohinicaton huishani joi jisish jaa yohuanhonahi nincaquin. Nincaxon yocascaquin: —¿Min jisi joi min honanain? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—¿Jenquetsahaxon hen honantihin, huetsan hea yanapanyamahiya? Hea patax tsahoti nanehue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jan jisbenahi huishani joi ta nea qui: Carnero rehtenoxon hiohah bi neteresai quescarihbihi ta jahua hihyamahiqui. Jahuen rani rahmaxcorohah bi carnero baque sai saihihyamabiresai quescarihbihi ta yohuanyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jaa rabinmaxon ta pontejayamaquin casticancaniqui. Rehteres ta Tsoa jahuen xohtabo quin hih tsoabi jayamascanon hihqui jaa quirica. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jaatian: —¿Yohinica jascarai tsoa yohihiquin? ¿Jaabi nan? ¿Huetsa joni nan? Hea yohirohahue —Felipe yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jaatian sca jaa quiricaya yohuanxon Jesusen joi siri Felipenin yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bahin taramehcanahi cahax jano hian jaiton sca nococani. —Jise. Jano ta jene jaiqui. ¿Jenquetsahpahi min hea nashimatimahin, Jesusen joni sca hea hihnon? —Felipe yocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Miin jointiboyaxonbi nincacoinaiton tah hen mia nashimatihi —hahscaquin Felipenin. —Jesucristo ta Papa Diosen baque qui. Hen tah hen shinancoinai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jahuen taramehti janobi racarenennon cahen cabacho rebinica yohiscaquin. Jaton taramehti racarenenaiya cahen bototax rabebi jene nenichi, Felipe betan jaa Etiopía hapo. Janoxon sca cahen Felipenin jaa hihquimatanquin nashimaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jaabo mapescaiya bi Dios Yoshiman Felipe bihinihniquin. Felipe jisyamascaax bi jaa huesti sca jenimahanan sca caresscaribihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Azoto jema janin sca sanarenenxon ta jano jai jemabo janin sca joi siri Felipenin yohibonanishqui, Cesarea jema janin noconoxon caman. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jasca Felipe jai bi cahen noquen Hihbo qui hinamehtaibo tahtijaxon, Hen tah hen mato rehtetihi, Saulonen jato jaquin. Jato tahtijahax quiquin sacerdote janin cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Caxon, yocaquin: Jayaxon joni bihti quirica hea hinanhue hahquin. Jascajaxon cahen Damasco jema janin tsinquitai judiobo qui hinanti quirica huishamaquin. Criston joi bichibo meraxon jato nexaxon jaa quiricayaxon Jerusalen janin bebobo, haibobo rihbi hionoxon jascapa quirica huishamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Huishamahax jaya cahi. Damasco qui nocoti hochoma nichibo sca naihoh quehax xabacahinai xabapan jato xabajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Main paquerenenxon sca yohuanai joi nincaquin. —Saulon, Saulon. ¿Jahua copi min hea tiromajacatsihquin chibanain? ");
INSERT INTO kaqNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—¿Tsoa min quin, Hihbon? —hahscaquin. —Hea ta Jesus qui, hea tiromajacatsihquin min hea chibanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Huenihue. Jema janin catanhue. Jahueja min jatihin, jano ta mia yohinoxihcanihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yohuanai nincaxon bi jahuabi jisyamahax hahbe nichibo rahtetax nihreneni. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Main racatax huenicahuanxon jahuen bero rahcoyamaquin bi Saulonen jahuabi jisti hahtipahyamascaquin. Jisyamahiton sca hahbe nichibaan mehuexon Damasco jema janin sca hioquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Quimisha neten sca jano hihqui. Jahuabi jisyamascaquin. Jahua piyamaquin. Xehayamarihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jaa Damasco jema janin cahen Criston joni jai, Ananías janeya. Jaan cahen namaquen noquen Hihbaan quenahi nincaquin: —Ananin. —Neno tah hen qui, Hihbon —hihscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Huenihue. Derecha janeya bahin caxon Judasen xoboho Tarso janinha joni benatanhue, Saulo janeya. Hea ta yocaquihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Namaquen jismahah ta miin janeya joni jisishqui. Jahuen xoboho hihquixon jahuen bero sirinon hihxon jaa mehehi ta namaquen jisishqui —hihscai noquen Hihbo. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","—Jerusalen janinxon noquen huetsabo jan hicha tiromajahi tah hen hichaxon yohihi nincarahsihi, Hihbon. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Neno sca roqui sacerdote hapobaan quiricaya jahui, mia yocacaibo rahsi bichí —hihqui Ananías. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","—Jaabi cahue. Hen caisax jaya teeti tah qui. Huetsa jonibo, quiquin hapobo, israeli baquebo rihbi jan heen jane jato nincamanon hihxon tah hen jaa caisai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hea copi jan hihti teneyaxihquibo tah hen jaa jismayaxihqui —hihqui noquen Hihbo. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jascahah caresscai Ananías. Jaa xoboho hihcoxon mehexon yohiquin: —Heen huetsa Saulon, min hahan jahui bahin mihqui cainipixon ta noquen Hihbo Jesusen hea raanihqui, miin bero siriscanon. Dios Yoshiman rihbi mia hihbojanon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jaatianbi jahuen bero janinhax poto quescapa romishin pototani. Jahuen bero siricahinscaax hueniti. Hueniscaiton cahen Ananíasnen nashimaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pihax Saulo tantiscai. Damasco janinha Criston jonibo betan sca basima tahni jihueti, jahuentihi nete rah. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jaatian sca judiobo tsinquiti xoboboho mapecanaxon jaan jato yohibonaquin, Jesus ta Papa Diosen baque qui, hahbonaquin Saulonen. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jaa nincacaibo rahsi rahte rahteti. —¿Jesusya yohuanaibo rahsi neatohon Jerusalen janinxon tiromajayamarahsihiquin? ¿Jato tiromajanoxon neno joyamahipishquin? ¿Jato nexaxon sacerdote hapobo qui hiohi joyamahipishquin? —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jaabo jascarai bi Saulo coshihi. Nete tihibi hashoan coshicanaxon Damasco janinha judiobo netemaquin. Jesus ta Papan caisai joni qui hihxon Papan huishamani joi yohiquin jato honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Basiscaxon cahen jaa rehteti judiobaan shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Rehtenoxon bariyahpan yame rihbi jahuen xobo xehqui quexecanquin. Mia ta rehtecatsihcanihqui Saulon, hahscaquin caibaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Criston jonibaan sca yame jema macan chique huinomaxon tasa qui Saulo nanexon botonpaquecanquin catannon. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Botonahbo cahi Jerusalen janin nocoti. Criston jonibo janin hihquicatsihqui bi raquecani jatihibi. Criston joni hihqui shinanyamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mapemacatsihyamahiboya cahen Bernabé janeya jonin sca Criston raantibo janin Saulo hioquin. Hiohah bahinxonbi noquen Hihbo jisxon jan nincaquipi jato yohiquin. Damasco janinxon jan raquexonma Jesusen joi siri yohirahsihi jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jato betan sca jihuexon Jerusalen janin jato pasijapaquexon raquexonma noquen Hihbaan joi siri yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Judiohax bi griego joi yohuanaibo judiobo sca huetsayohuani. Joi bichincatsihquibaan bi: —Jascama ta qui —jato jaquin. Jaabaan rihbi jaa rehtecatsihscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Rehtecatsihquibo honanxon noquen huetsabaan Cesarea janin sca Saulo hioquin. Janohax sca Tarso jema janin canon raancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jaatian jatihibi janin siripih sca jihuecani; Judea main, Galilea main, Samaria main rihbi noquen huetsabo siripi jihuescai. Coshijaquecani. Noquen Hihbo qui hohchati qui raqueti jihueti. Dios Yoshiman rihbi jato sirijaquin shinanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jato tocan ta jatihibi janin Pedro nih nipahonishqui. Lida janin jihuetai Papan baquebo qui nocorihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jano cahen Eneas janeya joni meraquin. Ocho bari yora honanyamajaquetax jahuen racatinin racatai meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","—Enin, Jesucriston ta mia rohajahiqui. Huenixon miin cacajati bihhue —hahquin Pedronen. Yohihah cahen hueniscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jaa jisxon ta Lida jema janin jihuetaibo Cristo qui hinamehnishqui jatihibi. Saron jema janin jihuetai jatihibi rihbi Cristo qui hinamehti nincacoinax. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jaatian ta Jope jema janin rihbi Criston joni janishqui, haibo. Tabita jahuen jane. Tabita ta chaxo hihcatsihquiqui. Jaa haibaan ta caibo siribojaxonpahonishqui hicha. Jato yanapanquin jatohon shinanxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jascapahax bi hisinax mahuati. Mahuascai bi nashimaxon bochiquiha tapon racancanquin xoboho. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope ta Lida hochoma qui. Lida janin Pedro jai honanxon cahen Noque janin histon jorihue yohihi canon, Criston jonibaan rabe joni raanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yohihahbo cahen jato betan Pedro cahi caresscai. Nocotaiton jano haibo racanahbo chique janin Pedro hiocanquin bochiquiha tapo janin. Jano yononmabo rahsi tsahoti mayacahuani. Huinihi tsahocani. Cotonbo, sahuetibo jan jihueparixon jato quehxexonrasihi jismahi tsahocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jato jatihibi picomaxon raboxonen nihxon Papa yocaxonquin Pedronen. Yocaxonxon mahuatah haibo jisxon sca: —Tabitan, huenihue —hahquin. Jascahah jahuen bero peehahtanxon Pedro jisish tsahohihnascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tsahoscai bi mehuetanxon Pedronen huenihihniquin. Papan baquebo quenaxon yononmabo rihbi quenaxon teehihqui jato jismaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jan jascajaha Jope janin jihuetaibo jatihibi yohiscacanquin. Nincaxon hichaxon nincacoinax noquen Hihbo qui hinamehti. ");
INSERT INTO kaqNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Basi tahni sca Jope janin Pedro jihueti, Simoman xoboho. Simon ta yohina bichi poconica hihpahonishqui sapatojatijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea jema janin ta sontaro hapo japahonishqui Cornelio janeya. Cien sontaroboyahpa hapo. Italiano hahcaibo cahen jahuen sontarobo. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jaa sontaro hapo cahen Papahon shinanai joni. Jahuen xoboho jihuetaibo jatihibi hahbetan Papa qui hohchati qui raqueti. Jema janin jahuajomabo coriqui hinanresquin. Papa Dios jaayocaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bari racapaquescaiya cahen Papan yonoti hahqui nocoti jahui jisquin namaquen jisijaquin. —Cornelion —hahquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jaa jisish hihti raquetax: —¿Jahua min queenain, Hihbon? —hihscai. —Min yocaxonai ta Papan nincaquihqui. Min joni huetsa yanapannoxon coriqui hinanresai ta shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jope janin canon jonibo raanscahue, jano jai Simon neno hihuehahbo. Jahuen jane huetsa ta Pedro qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Huetsa Simoman xoboho ta jihuetihqui, yohina bichi poconicaton xoboho, quebijistima hian quexabi —hahquin Papan yonotinin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Papan yonoti yamacahinscaiya rabe jahuen hahxontibo quenaxon Papahon shinanai sontaro rihbi quenaquin jahuen xobohoxon teexonai jahuen sontaro. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jan rahma jisibi jato yohixon Jope janin jato raanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Raanah becani. Nichish bahin hihshinahax mohiyahtax nihnichi jema hochoma sca jaabo jahuiya jaa xobo champani pemacanyaxon Papa yocaqui Pedro mapeti barin manan tsacahiya. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pihan hihquish picatsihscai bi cahen xobohoxon pitijaquin janquenjariyamacanquin. Jaatian namaquen jisijaquin jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nai quehpemehtai jisquin. Hani sábana quescapa hoquen panexbehcoinxon main caman botonai jisquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jaa chicho cahen jatihibi yohinahbo main ninotaibo rihbi, hihsabo rihbi jai. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","—Huenihue, Pedron. Rehtexon pihue —hihqui nincascaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","—Hen tah hen pitimahi, Hihbon. Jahuentianbi tah hen rishtayabo piyamaniqui, pitimabo —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yohuanai nincarihbiquin: —Siri sca ta qui Papa jaiya tah min tiroma ta qui hih min jatimahi —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Quimisha coti jascahahnani. Jaatian jisi bi naihohxon sábana bihinihnirihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jan namaquen jisibi jahua jenquetsi jascarihquin hihxon shinanscaquin. Shinan shinanaiya bi Cornelionen raanipibo xehqui janin nocoscai. Simoman xobo yocacahcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","—¿Simon Pedro hahcaibo neno jihueyamahiquin? —hihcani yocacahti. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jan jisíbo Pedronen shinanparihi bi Dios Yoshiman yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","—Hoa ta mia benahi jahuibo qui. Huenihue tahca. Bototax basihaxma jato betan caresscatanhue. Hean horixon raanah ta becanihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Botoxon sca: —Hea tah hen man benahi joni qui. ¿Jahua queenax man jahuin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Noquen hapo ta Cornelio qui, cien sontaroboyahpa. Sirijaquin shinanai joni tah qui. Noquen Papahon shinanai. Jatihibi judiobo ta jahan jenimahiqui. Jaa ta Papan yonotinin yohihipishqui, Jonibo raanhue, hahquin. Mian yohihi joi jan nincanon hihquish tah non mia bichi jahui jahuen xoboho min catannon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","—Mapenahue —hahxon sca jano jato hoxamashinaquin. Hoxashinahax mohiyahtax sca jato betan caresscai. Caibo Jope janinha noquen huetsabo rihbi ta jaa manahi bocanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nihbahinahipish huetsa neten sca Cesarea janin nococani. Pedro nocoti manahahnan jahuen jenabo jatihibi quenamaxon, jahuen hahbe rabeti siribo rihbi Cornelionen jato quenamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro mapescaiya cahen behchihi cahax jahuen tahe naman betihihpaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jaa hueniquin Pedronen yohiquin: —Huenihue. Hea rihbi tah hen mia quescapa joni qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jaa yohuanquinhanan xoboho hihcoxon hicha jonibo nocohihnascai meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jato meraxon: —Nahuabo pasijatima joi ta noque judiobo jai. Nahuabaan xoboho mapetima joi cahen noque jai. Jaa cah man honanai. Jaabi ta Papan hea jismahipishqui, mehetima rishtayahi hen tsoabi jayamanon. Jato yohuanquihnax noque rishtaya jai ta tsoabi yamahihqui. Hen honannon hihxon ta Papan hea jismahipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jaa copi tah hen joresscai, Caresscatanhue Papan hea jaáh. Hea yohiscanahue tahcah. ¿Jahua copi man hea quenamahipiquin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio sca yohuani: —Chosco nete sca nescaran bari racapaque sca jaiya tah hen heen xobohoxon Papa yocaxon pehneni chopaya joni hea bebon sanarenenai hean jisipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hea ta yohihipishqui: Cornelion, min yocaxonai ta Papan nincaquihqui. Min joni huetsa yanapannoxon coriqui hinanresai ta shinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jope janin jonibo raanscahue, Simon Pedro hahcaibo quenamaquin. Yohina bichi poconica Simoman xoboho ta jihuetihqui, quebijistima hian quexabi, hah ta hea jaipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jaatianbi tah hen mia quenamanoxon raanipiqui. Jahuerohahi tah min nocoscai. Neno tah non noquen Papan noque jisiya noque tsinquitai, noquen Hihbaan mia yohihi joi nincacatsihqui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedronen sca jato yohiquin: —Rahma tah hen honancoinscai. Papan ta caibo mentan huetsabo hashoan siri jisyamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Papahon shinanxon ponte hahcai nahuabo ta Papan siri jisiqui. Hen tah hen honancoinscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Noque israeli baquebo qui ta jahuen joi raannishqui. Jatihibi jonibaan Hihbo hihxon ta Papan rahuiboma sca noque janon Jesucristonen noque hihbojahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","¿Judea mai jatihobi janin jahua jahoxquin? Man tah man honanai. Galilea mai mehax ta joi behna jamenonishqui, Juaman yohixon nashimahipi pecaho. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazaret janinha Jesus ta Papan caisai joni qui, non honannon hihxon sca ta jahuen Yoshin siri Papan jaa hinannishqui, jahuen coshi rihbi hinanquin. Papan yanapana sca ta jonibo sirijabonahi nihninishqui, tiroma yoshiman hihbojaha jonibo rihbi jato jatihibi sirijabonaquin. Man tah man honanscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Neno noquen judiobaan mainxon jan hahpahoni, Jerusalen jema janinxonbi rihbi jan hahpahoni jatihibi tah non jisnixon yohinica qui. Jihuin hueonxon rehtehibo rihbi jisoxon tah non yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jan hihquipi jahuen quimisha neten sca Papan huenirihbixon jisíbo hihxon noque qui cainmahi jisoxon tah non yohirihbihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jan hihquipish bi hahquirihbi teehihquipi non hahbetan pixon xehacahchihi ta Papan noque caisoxqui, Cristo jihuerihbiscai joi yohihibo sca noque janon. Jatihibichin jisnon hihxonma bi noque jan caisaibaan jisnon hihxon ta noque janin jaa cainmahoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jahuen joi siri non jonibo yohinon ta noque yohihoxqui. Jihuetaibo betan mahuanihbo jan siri hin tiroma quin hihxon jisnon hihxon ta Papan jaa yohinishqui. Jaa joi rihbi non yohinon ta noque yohihoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Cristo nincacoinai jonibo jatihibi ta jaan jaton hohcha sohuaxoniqui. Jatihibi Papan joi yohinicabo ta jascari yohuannishqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jascari Pedro yohuanparihi bi nincacaibo jatihibi Dios Yoshiman hihbojaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judioxon bi nincacoinaibo Pedro betan jahuex rahtescai. Jaton nahuabo que bi Dios Yoshiman jato hihbojahi jisish rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Huetsapahi yohuanai jato nincacanquin. Papa Dios qui jaabo hihti siripi yohuanai nincacax rahte rahtecani. Jato sca Pedronen yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Non haho quescajaribiquin ta neabaan Dios Yoshin bichiqui. Non jato nashimanon. Tsoanbi ta Jato nashimayamanahue noque jatimahiqui —Pedronen jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jascajaxon Jesucriston janen jato nashimanon Pedronen yohiquin. Nashimaha sca: —Huetsa neten cayanoxon noque qui banetahhue —Pedro jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jaa pecaho cahen Judea mainxon Criston raantibo betan janoha noquen huetsabaan nincaquin. Jaton nahuabaan rihbi Papan joi bichipi nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jerusalen janin nocotaiton sca Pedro pontecatsihquin, Jato honantijati ta jaiqui hihnicabaan Pedro yocaquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Jahua jenquetsahin min noquen nahuabo janin hihcohipiquin? ¿Jahua jenquetsahin min jato betanbi pihipiquin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jan jisipibo sca Pedronen jato yohiquin sirijaquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jope jema janinxon noquen Papa yocaxon tah hen namaquen jisijaquin hihtihosi sábana quescapa jisipiqui, hoquen panexbehcoinxon naihohxon botonai. Hea bebonbi ta botonipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Jisquin sirijaxon tah hen yohinahbo, nami pinicahbo, ninotaibo, hihsabo rihbi jisipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yohuanai sca hean nincaquin, Huenihue, Pedron, rehtexon pihue, hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hen tah hen jascajatimahi, Hihbon, jahuentianbi tah hen pitimabo rishtayabo piyamaniqui, hahquin hean. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jaabi hahquirihbi naihoh quehax yohuani, Siri sca ta qui Papa jaiya tah min tiroma ta qui min jatimahi, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Quimisha coti non jascahahnanai bi naihohxon jatihibi hahquirihbi ninihihniquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jaatianbi ta noque jano hihqui xobon quimisha joni nocotipishqui Cesarea jemanxon raanipi. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nahua tah qui hihquishma hen jato betan catannon ta Dios Yoshiman hea yohihipishqui. Nea seis noquen huetsabo rihbi ta hea manahi bohipicanaxqui. Jahuen xoboho tah non hihcohipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jaan ta noque yohihipishqui. Jan jisi bi jahuen xoboho nichi Papan yonoti jahui. Nihrenenxon cahen Jope janin joni raanhue Simon Pedro hahcaibo hihuenon, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Hahan mia Papan teehihmahi joi ta mia yohixihquiqui miin xoboho jihuetaiboyabi, hah ta Papan yonotinin jaa jaipishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Hean jato yohimenohiya bi ta Dios Yoshiman jato hihbojahipishqui non yohimenohi tian jan noque hihbojaho quescajaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jaatian tah hen noquen Hihbaan noque yohini joi shinanscaipiqui, Juaman jenen nashimahi bi tah hen jenen nashimaquin hahcajaquin mato Dios Yoshin hinanyaxihqui, hah jan noque janí tah hen shinanscaipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Noquen Hihbo Jesucristo nincacoinaiton Papan noque hinanho Yoshin jato rihbi jan hinanaiya ¿jahua hihxon hen Jascajayamahue Papan hen jatihin? —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nincacax netecani. Papa qui sca siripi yohuancani: —Nahuabo rihbi ta shinan pontemaxon jato teehihmahihqui, hicahisen —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Hoa Esteban rehtexon jato tiromajaha jabisaibo ta Fenicia main caman bocannishqui. Chipre mai janin, Antioquía janin rihbi ta nococannishqui. Caquin bi judiobo rahsi Papan joi yohibonacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Caibo Chipre mai janinhahbo hihxon, caibo rihbi Cirene janinhahbo hihxon, Antioquía janin nocoxon sca jaton nahuabo rihbi noquen Hihbo Jesusen joi siri yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Noquen Hihbaan ta jato yanapannishqui. Jaabaan yohihah ta hihti caiboxon nincacoinxon noquen Hihbo bihnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jascajahibo nincaxon ta Jerusalen janinxon noquen huetsabaan Bernabé raannishqui Antioquía janin canon. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nocoxon Papan jahuen shinan jato hinanai jisish jenimahi. Noquen Hihbo jeneyamahahbo hihxon cahen jaan jato yohiquin sirijaquin noquen Hihbaan yohihi quescabijaquin hahcabo hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Janohahbo hicha joni sca noquen Hihbaan hihbojaquin. Bernabé ta siri joni janishqui Dios Yoshiman hihbojaha joni. Papan jato hahxontihi cahen jaan shinancoinquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Saulo benahi sca Tarso janin Bernabé cahi sca cahi. Saulo meraxon Antioquía janin hihuequin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Huesti bari Papan caisaibo betan tsinquixon cahen rabechin hicha jonibo haxemaquin. Jano pari ta Criston jonibo cristianobo janemenocannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jaatian Jerusalen janinhax Papan jismaha yohihibo nocoti Antioquía janin. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Agabo janeya sca jato tocan nihxon jatihibi main piti pishinscaax pihan hihyaxihquibo jato Dios Yoshinyaxon yohiquin. Jan jascani cahen jascacoinscai, Claudio quiquin hapo hihqui tian. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jaa copi cahen Judea main jihuetai noquen huetsabo qui coriqui raanti Criston jonibaan shinannish. ");
INSERT INTO kaqNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jatihixonbi hahtipahnoxon caman raanti shinancanquin. Shinanxon jaabaan shinanai quescabijacanquin. Jaton pastorobo qui hinantannon hihxon Bernabé betan Saulo jaya catannon hihxon raancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jaabo cahiya ta jaton quiquin hapo Herodesnin caibo Papan joi nincacoinaibo bihnishqui, jato tiromajanoxon bihquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juaman huetsa ta Jacobo janishqui. Jaa ta Herodesnin rehtenishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jaa rehtehiya judiobo jenimahi jisxon Pedro rihbi bihquin chahoma paan fiestajahiboya. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bihxon sipo xoboho tsahonquin. Chahoma paan fiesta pecaho rehteyaxahpan costanahbo hihxon jahuen sontarobo Pedro coiranmaquin. Chosco coiranti janahue, huesti coiranti cahen chosco sontaro, jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Sipo xoboho Pedro tsahotaiya cahen noquen huetsabaan noquen Papa hihti yocaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jisibo hihxon bahquish Pedro rehtenoxahpan hih Herodes jai bi sipo xoboho Pedro hoxahi. Jaa yamebi rabe cadenanen jato qui menexah rabe sontaro napon Pedro hoxahi. Xehqui janin rihbi sontaro coirani xehqui janichi. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jaatian noquen Hihbaan raanah jahuen naihoh queha yonoti sanareneni jahui. Sipo xobo chicho xaba siri jaresscai. Rahpasxon Pedro mohinquin. —Huenihue histon —hahquin. Huenitaiya hahan menexipi cadena mepequehti. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","—Miin chopa sahuexon tahe xaca rihbi sahuehue —hahquin Papan yonotinin. Jascajaha sahuequin. —Miin tarin rahcoxon hea chibanhue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jascahah hahbe cahi picoscai. Papan yonotinin hahcoinai honanyamaquin. Namaquen jisija tah hen jai hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Huetsa coiranai sontaro huinoxon huetsa rihbi huinohax yami xehpoti qui nococani, jano jema qui cati. Hahmebi xehpoti quehpemehti. Picotax bahin sca bocani. Cahiya bi Papan yonoti yamacahinscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Shinanscaax: —Herodesnin hea rehteyamanon hihxon ta jahuen yonoti Papan raanaxqui heen caibaan hea jacatsihqui jatihibi rihbi hea jayamanon hihxon. Rahma tah hen honanquin sirijascai —hihqui Pedro. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Honancoinscaax Marian xobon cahi. Jaa María ta Juaman mama qui. Juaman jane huetsa cahen Marcos. Jaa xoboho tsinquixon ta Papa yocacannishqui hichaxon Pedro yocaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Jemanhihti xehpoti Pedronen tontonhahcai nincacax Rode janeya xontaco jisi jahui. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro joi nincaxon honanax hihti jenimahax quehpenxonti shinanaxma bishquihihcanahi caribihi xobon. Hihcohax: —Pedro ta jemanhihti janin nichiqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","—Min tah min tehquehihqui —hahcanquin. —Hihyama tah hen jai. Jaa coin tah qui —hihresi. —Jahuen yoshin rah ta qui —hihscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedronen xehpoti tontonhahquin jeneyamaquin. Quehpenscaxon jisish rahte rahtecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Netetahbo jahuen mequen sanaxon sipo xobo janinhah noquen Hihbaan jaa picohah jato yohiquin. —Jacobo, noquen huetsabo rihbi yohiscatannahue —jato jabahini huetsa xoboho caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Xaba paquescaiya sca rahtetax sontarobo coro coroti, hihti corocani. ¿Jahuen Pedro cahaxquin? hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jato Benatannahue hahca bi benacasquimahiboya coirannica sontaro yocapaquexon, Nea coirannicahbo rehtenahue hahscaquin Herodesnin. Jascajahax Judea mai janinhax Cesarea jema janin jihueti sca Herodes cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jaatian sca Tiro mai janinhahbo qui Herodes sinati. Sidon janinhahbo qui sinarihbihi. Jaa copi huesti shinanyahax hahqui nococani. Nocoxon jahuen xobo coirannica Blasto yohuanquihnxon jeenhihmacanquin jan jato yanapannon. Quiquin hapo sca hihti yocacanquin jan jato qui sinayamascanon hihxon. Jahuen mai janinhax jaton piti jahui copi raejacatsihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jaa neten yohuanyaxahnpan hih jan jaipi jaa nete nocotaiya jahuen quiquin hapo tari sahuehax, jahuen quiquin hapo tsahotinin tsahoxon basi yohuanquin Herodesnin jato yohi yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herodes yohuanai nincacax: —Diosax tah min yohuanai. Joni yohuanaima ta mia qui —hihcani coshin. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jaatianbi, Jascama ta qui, Papa Dios huesti ta Dios qui, hih jan jayamahi copi noquen Hihbaan yonotinin Herodes rishquiquin. Rishquihah xenahax mahuati. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Herodes mahuataiya sca Papan joi caícanascai. Hashoan hocho sca nococanahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jaatian antioquiabaan coriqui hinana Jerusalen janin noquen huetsabo qui jaa coriqui hinantanax Bernabé betan Saulo joribiscai. Juan rihbi becanquin, Marcos cahen jahuen jane huetsa. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía janin ta Papan caisaibo tocan haxemanicahbo betan Papan jismaha yohinicabo japahonishqui, huetsa cahen Bernabé, huetsa cahen Simon, joni huisoni hahcaibo, huetsa cahen Cirene janinhah Lucio, huetsa cahen Manaen jaton gobernador Herodesnin yanapannicah, huetsa cahen Saulo. Jaabo rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Piti tenehahnan Papahon shinanaiton Dios Yoshiman jato yohiquin: —Hen jato yohihi tee jatannon Bernabé betan Saulo raannahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jascajaha piti tenehahnan Papa yocaxon jato metsoncanquin, mato tah non yanapantihi hahxon jascajacanquin. Jascajaxon jato camacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jascajaquin Dios Yoshiman camahah Seleucia jema janin cahax Chipre mai pishca caman quebijistima hian nontin pohquejaqueti. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina jema janin mapexon judiobaan tsinquiti xobohoxon Papan joi yohicanquin. Juaman rihbi ta jato yanapannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jaa mai pishca nabebacahini cahax Pafos jema janin nococani. Jano ta yobe joni meracanishqui, Barjesus janeya. Judio. Papan jismaha yohinicahicamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jaa ta janoha tininti teexonai joni hihpahonishqui. Tininti ta Sergio Paulo janeya janishqui, honan joni. Papan joi nincacatsihxon jaa tinintinin Bernabéya Saulo quenamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jaa yobepan jane huetsa cahen Elimas, yobe hihcatsihqui. Jaan jato Jascama ta qui, hahquin, tinintinin nincacoinmis hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jaatian Pablo hahcaibo Saulo Dios Yoshiman hihbojaha jaa yobe bejisquin sirijaxon yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Mia tah min tiroma yoshiman baque qui. Jatihibi pontejaquin shinanaibaan rahui ta mia qui. Paran paranmis. Hihti tiromajaquin shinanai ta mia qui. ¿Papan ponte bahibo min mayamahi tanticatsihyamahin? ");
INSERT INTO kaqNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jisresscahue. Noquen Hihbaan ta mia mehehihqui, benchescaxon min bari basi tahni jisyamascanon —hahquin. Jan jascahiya bi jahuen bero coropax bahquishcahinscai. Tsoan hea mehuetanxon hiotihiquin, hihquish joni benahi huea hueacanahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jaa jascahi jisxon noquen Hihbaan joi nincacax rahtexon jaton tinintinin nincacoinquin, jahuen jointiboyaxonbi nincacoinquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jaatian Pablo, jaabo, Pafos mai potabahini nontin caresscaax Panfilia mai janin nocoti Perge jeman. Jano jato potabahini ta Jerusalen janin sca Juan caribinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perge janinhax cahax Pisidia mai meha Antioquía qui nococani. Jaton tantiti neten sca janoha judiobaan tsinquiti xoboho hihcohax tsahocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisesnin huishani joi nincamaxon Papan joi huishaxon yohinicabaan joi nincamaxon tsinquiti xobo coirannicahbaan jano tsahotai bi jato quenaquin: —Noque huetsabaan, jonibo yohiti joi jaxon nihhinaxon noque yohirohahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jascahahbo nihhinaxon mequen sanaxon Pablon jato yohiquin: —Heen caibon, noquen Papa Diosohon shinanaibon, hea nincanahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Noque israelibaan Papa Diosen ta noquen xenibo caisnixon Egipto main jaabo jihuetaiya jato caíjanishqui. Jahuen coshi jismaxon ta janohax piconon jato hionishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Cuarenta bari sca ta jato tenenishqui nihi naman nih nichaiboya. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaan mai janin sca siete quiquin hapobo jaton jihuetahboyabi camaxon ta jaa mai israelibaana sca hihnon hihxon jato hinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cuatrocientos cincuenta bari jano jihuescanon jato jaa mai hinanquin. Jahuen joi yohinica Samuel janon caman ta jato pontenicabo hinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Quiquin hapo sca noque hinanhue, hah sca ta jacannishqui. Yocacahbo cahen Cisin baque Saulo jato hinanquin. Jaa ta Benjamin baquebo janishqui, Saulo. Cuarenta bari ta jaan jato coirannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jaa potascaxon ta Davidinin sca jato coirannon hihxon jaa sca quiquin hapomanishqui. Jaa yohihi ta Papan nescajanishqui: Isaín baque David tah hen heen shinanya jisi. Hea queenai quescabija ta jaan jatihiqui hea hahxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jaa Davidinin chini baquebo janinhah ta noque israelibo teehihmanica Papan cainmascanishqui, Jesus, jan yohini quescabijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jaa jonon ta jaton shinan pontexon nashimati Juaman jato yohinishqui, jatihibi noquen caibo yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jato yohiquin queyoti hochoma sca: ¿Hea jahua quin shinan man jain? Hea ta jaama qui. Hehchon ta huetsa jahuiqui. Jaa hihti siri copi tah hen jahuen sapato risbi pecaxonti hahtipahyamahi hahquin jaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Heen huetsabaan, Abrahanen baquebaan, Papahon shinanaibaan. Noquen nincanon hihxon ta Papan noque jaa joi raannishqui, hahan teehihti joi non nincanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jaa teehihmanica jisxon bi ta jaa honanyamacannishqui. Jatihibi tantiti neten Papan yohinicabaan joi nincamaha bi nincayamarihbixon ta Jerusalen janin jihuetaibaan jaton hapobo betan jaa rehtemacanishqui, jayaxihquibo Papan yohini quescabijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jahua copi rehteti yamahi bi Pilato yocacanquin jaa rehtemanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jaa yohihi huishani joi jai quescabijaxon jihuin hueonahbo mahuascai botonxon ta tsahoncannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Hihquipi bi ta Papan teehihmarihbinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hahquirihbi teehihquish ta hahbetan Galilea janinhax Jerusalen janin cahipibo qui cainnishqui, jaabaan sca jan teehihribihi jisnicahboxon caibo sca yohinon. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Joi siri tah non mato yohihi, hea huetsabaan. Noquen xenibo jan hahxontijani quescabija ta Papan jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jesus hihquipi bi hahquirihbi teehihmaquin ta jan hahxontijani quescabijaquin Papan noquen xenibo hahxonihqui, noque teehihmanica janon. Jahuen rabe behua huishaquin Davidinin yohini quescabi ta qui: Mia tah min heen baque qui. Nea neten tah hen heen baque mia hihqui jato honanmascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jaa hihquipish bi jahuentianbi yora pisiyamascanon hahquirihbi teehihmahi ta nescajaquin rihbi yohinishqui: Hen jahuentianbi huetsajatima joi siri hen David yohini quescabijaquin tah hen mia hahxonscai, hih ta jaiqui huetsa quirica janin rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jaa yohihi ta huetsa behua janin rihbi nescarihqui: Min caisai miin baque tah min pisimatimahi hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jihueparixon ta Papa queenai quescajaquin Davidinin hahnishqui. Mahuatai tsahonahbo ta jahuen yora payoscanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Papan hahquirihbi teehihmahi joni ta jascayamahihqui: jaa ta payoyamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jaan ta maton hohcha sohuaxonti hahtipahiqui. Man honannon hihxon tah non mato yohihi, hea huetsabaan. Moisesnin noque yohini quescabijaxon bi man potati hahtipahyamahi hohcha jatihibi ta jaan sohuahihqui nincacoinaibo rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jaa nincacoinaibo jatihibi ta Papan siri jisiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Papan joi yohinicabaan ta nescajaquin huishaxon yohinishqui: ");
INSERT INTO kaqNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jisnahue, hea hosanaibaan. Rahtenahue queyoscanoxon. Man jihuetai netenbi hen hahan rahteti hahcaiya bi tah man hihcoinai shinantimabiresai. Papan ta jascajaaxqui hih huetsa jai bi hih ta jahuen huisha jaiqui. Jistahi man. Jan yohihi quescabija jan mato jamis —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jascahax cainscaiton huetsa tantiti neten rihbi noque yohirihbiyaxahnhue hihxon jato hihti yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tsinquixon yohuanaibo nincaquin queyoxon sca, jaton nahua hihpahonish bi Papahon shinanax judioscaibo betan judiobaan hichaxon Pablo, Bernabé chibanbonaquin. Chibanahbo Papan shinanai quescari jihuetahbo hihxon jato sirijaquin yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Huetsa tantiti neten sca Papan joi nincaqui jaa jema janinhahbo jatihibi tsinquicani. Huestibo res pishini. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pablo yohuanai nincacaibo hihti caibohi jisish notsi notsixon: —Jascama ta qui tiroman —hahcanquin judiobaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pantecatsihquibaan bi raquexonma Bernabé betan Pablonen jato yohiquin: —Mato pari tah non Papan joi nincamati jai. Queyoyamanox manataibomaxon man jaa joi potascaiya tah non nahuabo sca yohihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Non jascajanon ta noquen Hihbaan noque yohinishqui: Nahuabo min xabajaxonnon tah hen mia yohihi jano nai chibechijaquetancahuanaiton caman hahan teehihmati joi min jato nincamanon hah ta noquen Hihbo janishqui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jan jascarai nincacax judiomabo jenimacani. Papan joi hihti siri jiscanquin. Queyoyamanox jihueyaxihquibo rahsi noquen Hihbo qui hinamehti, Papan caisnibo rahsi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Janohax sca cahen janoha maibo janin Papan joi caícanahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Papahon shinanax bi haibo patorobo sca ta jaa judiobaan Pablo qui sinamanishqui, jaa jema janin jihuetaibo haibo patorobo. Janoha patoro rihbi sinamacanquin Pablo Bernabé rihbi picohahbo hihxon. Sinamahabo cahen jato jaa mai janinhah picocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jaabaan picohah yohitimabohi honanahbo hihxon jaton sapato poto jato quiri tahabahini Iconio jema janin sca boresscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jaabi Jesusen jonibo hihti jenimahi. Dios Yoshiman hihbojaha jenimahi jihuecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio janin sca judiobaan tsinquiti xoboho mapexon jato yohiquin nincacoinahbo. Yohihah hichaxon nincacoincanquin judiobaan, judiomabaan rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nincacoinaiboya cahen nincayosma judiobaan judiomabo sinamaquin. Noquen huetsabo jistahihmanon hihxon jato tiroma shinan hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jaabi ta janobi basi tahni jihuescacannishqui raquexonma noquen Hihbaan joi jato yohihahnan. Jatohon shinanxon Papan hahxonai joi nincacoinahbo hihxon ta noquen Hihbaan rihbi yanapanquin hahan honantiboya hahan rahtetibo jato jaxonnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jema janinhahbo sca caibo huetsa shinanya hihnon caibo rihbi huetsa shinanya hihqui. Judiobo res caibaan nincaquin. Caibaan rihbi Criston raantibo res nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jasca sca jaiya cahen jato tiromajaxon macaman tsacanon benahue hihcani judiomabo, judiobo, jaton hapobo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Macaman tsacacatsihquibo honanax jabascacani. Licaonia main, Listra, Derbe, jaa jemabo janin bocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jano sca Papan joi siri yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra janin ta chanto joni meracannishqui, jahuen ponobo yosmahi cainnish jascabiscai. Jahuentianbi nihti hahtipahyamani. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jaan cahen Pablo yohuanai nincaquin. Jaa Pablonen bejisquin sirijaquin. Jisanan Papan mehehah rohatihi jan shinanai honanxon coshin sca yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","—Huenihue. Nihrenenhue —hahquin. Jascahah cayahihnatax nichi tana tanascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablonen jascajaha jisish tsinquijaquetaibo coshin yohuanscai: —Yorayahpa quescapahax ta dios rabe noque qui botopaquetaxqui —hihcani jaton join, Licaonicabaan join. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé ta Júpiter janecannishqui. Pablo cahen Mercurio janecanquin, yohuan hihbo hapo quen. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Júpiter hiná rehtexonnicah sca hicha jonibo betan cahi. Pehi toronjaxon ganado tejomaxon jema xehqui janin jano Júpiter hahcaibo jaton diosen xobo jaiton jaton ganado rehtecatsihscai, Pablo hinancatsihquin, mapojaxonnoxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jascajahibo nincaxon Criston raantibo Bernabé betan Pablonen jaton chopa huaxabahinxon tsamatai jonibo tocan cayatanxon jato coshin yohiquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¿Jahueja man jacatsihquin, jonibon? Noque tah non mato quescapa jonibo qui. Nescapa tiroma shinan potabahinxon jihuenica Dios man bihnon hihxon tah non jahuen joi siri mato yohihi. Nai, mai, hian, jano jai jatihibi ta jaan hahnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Neateman jihuepahonihbo ta jaabo jihueti queenai quescari jaan jihuemanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Jaabi ta hahan honanti jato pishinmayamanishqui jato yanapanquin naihohxon hoi paquemaquin, bimibo hinanquin, piti mato hinanquin, hahan jenimati mato hinanquin —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jascajaquin yohi yohihah pari ta jaabaan jaton ganado jato rehtexonquin bi rohajacanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jaatian Antioquía janinhax judiobo jahui. Iconio janinhax rihbi nocoxon judiobaan janohahbo sinamaquin, Pablo rehtehahbo hihxon. Sinaxon Pablo macaman tsacacanquin. Jemama qui ninibonaxon mahua sca ta jaiqui hihxon janobi potabehnancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Criston jonibo jaa mayajaquetaiya hueniscaax jema janin caribihi. Jano hihshinahax Bernabé betan caresscai. Derbe jema janin cahi caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nocoxon Papan joi siri jato yohicanquin. Yohihahbo hichaxon nincacoinquin. Janohax sca Listra janin caribihi. Janohax sca Iconio janin. Janohax sca Antioquía janin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Criston jonibo coshi hinanbonahi cahi, shinancoinquin jeneyamaxahcabo hihxon jato hihti yohiquin. —Papan jihuemati janin noconoxon tah non hicha teneti jai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Piti tenehahnan mequeman mehexon Papa yocaxon nincacoinaibo jano jaiton tihibi siri jonibo caisxon Mia pastorohue, Mia rihbi pastorohue hahcanquin. Jascajaxon jaabaan nincacoinipi quen noquen Hihbaan jato coirannon hihxon Papa yocarihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia mai sca nabebacahinax Panfilia mai janin nococani. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge janin sca caxon joi siri yohiscaax Atalia janin cahpaquehcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Janohax sca Antioquía janin cahi nontin boribicani. Hoa chai yohitanahbo hihxon janoxon Papa jato yocaxonnibo janin nocorihbiscacani, janohax jaabo catanni janin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nocoxon noquen huetsabo tsinquimaxon jato betan Papan hahrasihi jatihibi yohicanquin. Judiomabo jan jascajaquin nincamamenohi jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Basi sca jano Criston jonibo betan jihuecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jaatian Jerusalen janinhahbo sca joxon noquen huetsabo yohiquin: —Moisesnin yohini quescabijaquin honantijayamahah tah man hahquirihbi teehihtimahi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jaamajahibo copi ta Bernabé betan Pablonen jato pontequin sca yohinishqui. Yohihah bi hahbetan sca yohinanresi. Join bahchinani. Criston raantibo yocacahti ta jaiqui, hihxon sca Jerusalen janin bohábo sca raancanquin Pablo, Bernabé, caibo rihbi. Jerusalen janin caxon Criston raantibo yocacahbo cahen raancanquin. Noquen huetsabo shinanyahpabo yocacahti canon raancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Noquen huetsabaan sirijaquin camahah cahen bocani. Judiomabaan shinan pontexon Papan joi bichi jato yohihahnan Fenicia mai nabebacahinax Samaria mai rihbi nabebacanahi bocani. Yohiha janoha noquen huetsabo hihti jenimacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalen janin nocotaiton sca Criston raantibaan jato Benahue hahquin. Janoha pastorobaan jatihixonbi jato Benahue hahcanquin. Benahue hahcabo jato betan Papan hahrasihi jato yohirihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Fariseoboxon bi nincacoinaibo sca nihrenenxon yohiquin: —Jato honantijaxon Moisesnin yohini quesca jaahbo tah non jato yohiti jai —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jaa joi sca shinanquin sirijanoxon cahen Criston raantibo betan pastorobo rihbi jano huesti tsinquiti. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Basi yohinannan sca jaiboya nihrenenxon Pedronen jato yohiquin: —Heen huetsabaan, neateman ta Papan hea mato tocan mehax canon hea yohinishqui jahuen joi siri hean yohihah noquen nahuabaan nincacoinnon. Man tah man honanscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jonin jointi honanxon ta Papan jaabo siri hihqui noque jismanishqui, noque jahuen Yoshin siri jan hinanai quescajaribiquin jaabo rihbi hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Noque ta jascapa rabe jisnishqui. Jaabaan nincacoinai copi jaabo rihbi jaton jointi sohuaxonquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Non papiti hahtipahyamani bi noquen xenibaan rihbi papiti hahtipahyamani hihue papimaquin hahcajaquin tah man Criston jonibo judionahue hahcai. ¿Jahua copi man jascajaquin noquen Papa Dios tanahin? ");
INSERT INTO kaqNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Noquen Hihbaan noquehon shinanxon noque teehihmatihi quescajaribiquin ta jaabo rihbi teehihmatihiqui. Jaa tah non shinancoinai —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jaatian pari netexon Bernabé betan Pablo yohuanai nincacanquin. Nincacaiton judiobaan nahuabo janin caxon hahan honantibo hahan rahtetibo jato betan Papan hahquipi jato yohipaquequin Pablonen, Bernaben rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Yohiquin queyoscaiya Jacobo sca yohuani: —Hea nincanahue, hea huetsabaan. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jahuenahbi jaabo hihnon hihxon jahuen joi siri noquen nahuabo Papan nincamamenoni ta Simoman noque yohiscaaxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Papan yohinicabaan rihbi ta huishaxon jascajaquin yohinishqui. Nincanahue: ");
INSERT INTO kaqNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jaa pecaho joribixon tah hen Davidinin xobo poxoni huenirihbixon hahcajaquin jahuen jihuetahbo hinanrihbitihi. Payonihbo hahribixon hahcajaquin tah hen jahuen jihuetahbo hinanrihbiyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Texe jonibaan jaton Hihbo benahahbo hihxon tah hen jascajayaxihqui. Maton nahuahax bi hehqui hinamehtaibo jatihibichin hea benahahbo hihxon tah hen jascajayaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nea joi neateman yohinihxon ta noquen Hihbaan jascajahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Hean shinanah tah non jaton shinan pontexon noquen Papan joi nincacoinaibo noquen nahuabo non jatsanjatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Jato qui raannoxon quirica huishati ta jaiqui, santoya rishtayamahahbo joni huetsa betan tsiniyamahahbo, hahsataibo piyamahabo, jimi rihbi piyamahabo. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Jatihibi jema janinxon ta neateman Moisesnin joi nincamanixon rahma caman nincamacanihqui. Nincamaxon ta jaa jahua hihcatsihquiquin hihxon yocarihbicaniqui, tantiti nete tihibi jaton tsinquiti xobobohoxon. Jaa copi tah non jato qui joi raantihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jeenhihxon sca jonibo raanah ta siri qui hihxon Criston raantibo, janohahbo pastorobo, jatihibi noquen huetsabo, jatihixonbi sca Bernabé betan Pablo manahi cahabo mananicabo caiscanquin, Antioquía janin jato raannoxon. Judas Barsabas hahcaibo, Silas rihbi, caiscanquin. Jaabo hihti shinanya noquen huetsabo copi jato caiscanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jato betan raanti quirica sca huishamacanquin: Maton huetsabo, Criston raantibo, pastorobo, noque rahsibixon tah non mato qui joi raanai, man jascabi jayamahin, hahquin. Antioquía, Siria, Cilicia maibaan jihuetai noquen caibohaxma bi noquen huetsabo qui tah non raanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Noquen raanahma bi noque quihax caxon yohixon mato masa shinanmahibo joi tah non nincacai. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nincaxon tah non jatihixonbi sca shinanquin sirijaxon noque quiha jonibo caisai, Bernabé betan Pablo manahi mato janin canon. Bernabé betan Pablo ta hahan non shinanai noquen huetsabo qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Caibaan jato rehtecatsihquibaan bi ta noquen Hihbo Jesucriston joi siri yohihi caresscahoxqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jaa copi tah non Judas betan Silas raanai, jaabaan sca non mato yohihi joi mato yohiquin sirijanon. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Judiobaan mato jisi copi man jascajati jai joi res tah non mato yohihi, jahuabi hashoan mato hihuejayamanoxon. Non jascahah ta siri qui hihxon tah non yohihi, Dios Yoshiman rihbi noque jascajaquin shinanmaha. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jaa copi tah non mato yohihi, santo rehtexona nami piyamanahue, jimi rihbi piyamanahue, terehahxon rehtehibo rihbi piyamaquin. Joni huetsa betan tsiniyamanahue. Non mato yohihi quescarax tah man siritihi. Jaa res tah non yohihi, hahcanquin huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Raanahbo Antioquía janin bocani. Jano noquen huetsabo tsinquixon jaa quirica jato hinancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jaa quirica bihxon jisxon shinanquin sirijascacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Papan jismaha yohinicaboxon Judas betan Silasen jato hicha yohixon noquen huetsabo coshi hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jano jihuetahbax cacatsihscaiboya jato raanipibo qui caribinon sirijaquin jato camacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Hihcax bi Silas cayamahi. Baneti jan shinanaiya Judas huesti cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Antioquía janin Pablo betan Bernabé baneti. Banexon jato honanmaquin. Hicha noquen huetsabo betan jaa joi siri yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Jahuentihi ra nete jano hihxon: —Jano non noquen Hihbaan joi non jato yohiniton caribinon cahue jato jisi. Jenquetsahpi jacanihquin jisnon cahue jatihibi jema janin —Bernabé Pablonen jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Juan Marcos hahcaibo Bernabenin hiocatsihqui bi Pablo queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Panfilia janin jato potabahini jato betan Papan joi yohihi cayamani copi cahen jaa hioti Pablonen shinanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Huesti shinanyamascaax cahchinanbehcoini. Chipre janin Marcos betan canoxon cahen Bernabé nontin naneti. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo cahen Silas betan cahi, noquen huetsabaan noquen Papa yocaxonah. ");
INSERT INTO kaqNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria nabebacahinax Cilicia mai rihbi nabebacahini cahi noquen huetsabo shinan hinanbonaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Derbe janin nocotax janohax cahax Listra janin nocorihbihi. Jano Timoteo janeya Criston joni jai. Jahuen mama judiohax bi nincacoinnica. Jahuen papa cahen judiobaan nahua. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jaa Timoteo qui ta Listra janinha noquen huetsabo siripi yohuannishqui. Iconio janinhahbo jascarihbihi yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jaa hiocatsihxon bihxon janobo judiobo jai copi Pablonen jaa honantijaquin. Nahua papayahpa jaa honanaiboya jaa honantijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jemabo sca nabebacanahi caquin jato yohibonaquin. Jerusalen janinxon Criston raantibo betan jaton pastorobaan yohihipi joibo jato yohibonaquin. Jaa joi nincaxon jascari jihuetahbo hihxon jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jaa copi ta noquen huetsabaan hashoan sca nincacoinnishqui. Nete tihibi caícanahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Frigia mai sca nabebacahinax Galacia mai rihbi nabebacahini bocani. Asia mai janin cacatsihquibo bi Dios Yoshiman jato jano yohimayamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia main nocotax, Bitinia main sca cacatsihquibo bi Papan Yoshiman jato panterihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misia mai huinojaquetax Troas jema janin sca cahpaquehcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Huesti yame cahen namaquen Macedonia janinha joni Pablonen jisquin. Jaa bebon nihrenenxon jaa macedonio jonin hihti yocaquin: —Macedonia janin noque yanapani johue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Namayama sca jan jaiya jenquetsahax non Macedonia janin caman pohquetihin hihxon hahan pohqueti benaquin noquen. Non jano jahuen joi siri yohihi canon Papan noque quenahi tah non honanquin sirijaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nontin nanexon Troas potabahinquin noquen. Samotracia quiri ponte res cahi. Nihshinahax huetsa neten sca Neápolis jema janin taxnati. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mapetax Filipos jema janin cahi. Filipos ta romanobaan tsahonni jema qui, jano jai jemabo mentan hashoan hani. Jano tah non jahuentihi ra nete hihniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tantiti neten sca tah non jema jemanhihtinin caniqui, huean quexabi. Janoxon ta judiobaan noquen Papa Dios yocaquihqui hihquish tsahopaquetax non jano behchinanai haibobo betan noque yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Huesti haibo ta Lidia janeya jano janishqui. Papahon shinanai haibo. Yancon chopa maromanicah. Tiatira jema janinhah haibo. Jaan cahen nincaquin sirijaquin. Pablonen yohihi joi nincati shinan noquen Hihbaan hinanah nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jatihibi jahuen xoboho jihuetaibo betan nashimaha sca noque hihti yohiquin: —Noquen Hihbaan joi hen nincacoinai shinanax heen xoboho botannahue. Jano sca banenahue —hahxon jano sca noque hioquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Janoxon jaabaan Papa yohihi janin sca non cahi bi huesti hiná haibaan noque behchiquin. Tiroma yoshinyahpa haibo hihxon ta jayaxon jonibo yohipahonishqui. Honancatsihquin yocacah jaan yohiquin. Jascajaxon ta jahuen hihbobo hicha coriqui cananxonpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jaa haibaan cahen Pablo chibanbenaquin. Noque rihbi chibanbenaquin. Noque chibanhahnan coshin yohuani: —Nea jonibo ta Xaba Hihbo Diosen jonibo qui. Hahan teehihti joi ta mato yohicaniqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hicha neten jascarihbihi. Jatsanscaax mayacahuanxon Pablonen jaa yoshin yohiquin: —Jesucriston janen tah hen mia yohihi, jaa haibo janinhax picohue —hahquin. Jan yohihah cainscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hahan coriqui cananti yamascai jisxon jahuen hihbobaan Pablo bihquin. Silas rihbi bihcanquin. Bihxon tinintinin jemanhihti janin hioxon jaton hapobo quenacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jaton hapobo jahuiya: —Neabo ta judiobo qui. Noquen jema ta tiromajacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Noque jascatima joi ta noque yohihihqui, jascapa noquen nincatimahi bi. Noque jascatimahi joi tah qui. Noque tah non romanobo qui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jano tsamajaquetaibo rihbi jascari jato qui yohuani. Jascaraiboya jaton chopa potamaxon, jihuin jato cahrishqui cahrishquinon jaton hapobaan yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tsehue tsehuejaxon sipo xoboho jato tsahonxon sipo xobo coirannica yohicanquin sirijaquin jan coirannon. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jascajaquin yohihahbo chicho queha chiqueho jato niaxon hahan tabitaxtinin jato tabitaxpaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yame pochinicon sca Pablo betan Silasen noquen Papa yocaquin. Papa qui siripi behuahi. Hahbe sipojahipibaan cahen jato nincaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jaatian mai coshin mihuanreneni. Xobo jihuibo taxca taxcahihqui. Jatihibi xehpoti quehpemehscai. Hahan jato menexipi cadenabo mepequehcahini. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Sipo xobo coirannicah sca mohixon jaa xobo xehpoti jatihibi quehpemehtai jisish machitonen nacocatsihscai. Hahmebi rehtecatsihqui sipojahipibo jabascai shinanax. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nacocatsihqui bi Pablonen coshin quenaquin: —Jascari tiromayamahue. Neno tah non qui jatihibi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jascajahah: —Johué quetejanahue —hihquish sipo xobo hihcocahinax tastahihcanahi cahi Pablo betan Silas janin taracahreneni. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Hueniscaxon jemanhihti janin jato picoxon yocaquin: —¿Queyoyamanox mananoxon hean hen jahuejati jain, jonibon? ");
INSERT INTO kaqNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","—Noquen Hihbo nincacoinax tah min queyoyamanox manatihi. Miin xoboho jihuetaibo jascaribihi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jascajaxon jahuen xoboho jihuetaibo rihbi Papan joi yohiquin sirijacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jaatianbi yamebi jato hioxon jaton tsehue chocaxon: —Nincacoin tah hen jai. Hea nashimanahue. Heen xoboho jihuetaibo rihbi nashimanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jahuen xoboho jato mapemaxon sca jato pimaquin. Papa nincacoinax jaa, jahuen haibo, jahuen baquebo, jatihibi hihti jenimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xaba paquescaiya sca jaa jema hapobaan porisia raanquin, yohihi cahabo. —Hoa jonibo picotanhue botanahbo —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sipo xobo coirannicahton sca jascajaquin Pablo yohiquin: —Hapobaan ta joi raanihqui hen mato piconon. Picoscanahue tahca. Siripi catannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Jascahah bi Pablonen jato yohiquin: —Noque romano jonibo que bi ta jatihixonbi jisnon hihxon noque rishqui rishquimahipicanaxqui non jahuejahipi honanxonma bi. Jisíbo hihxon ta noque sipojahipicanaxqui. ¿Jonexon tsoan honannonma sca noque picocatsihcanihquin? Jascajatima ta jaticaniqui. Jaabobi joxon noque piconon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Hapobo yohihi sca bocani porisiabo. Romano jonibo ta qui hihqui nincacax raquescacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jaabo sca joxon jato raejacatsihquin jato sirijaquin yohuanquinquin: —Honanyamaxon tah non mato jascajahipiqui —hahxon jato picoxon sca Noquen jema potabahinrohanahue —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jascari sipo xobo janinhax picotax Lidia jisi bocani. Noquen huetsabo jisxon sca jato yohiquin. Nincacoinquin jeneyamaxahnahue jato jaax caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anfípolis jema nabebacahinax Apolonia jema sca nabebacahinax Tesalónica jema janin nococani. Jano cahen judiobaan tsinquiti xobo jai. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jahuen hihti quescarax jano Pablo mapeti. Quimisha tantiti neten jato betan yohinani, tsoa noquen teehihmanicah quin hihqui yohinani. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Papan huishamani joiboyaxon cahen Pablonen jato honanmaquin. Papan caisai jahuen baque hohmis hohmisax hihquipish bi teehihribiti jaa janí jato jismaquin sirijaquin, Jaa Papan caisai jahuen baque ta Jesus qui, jaa hen mato yohihi, hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Nincacoinmaha Pabloya Silas manahi sca caibo cahi. Judiohaxma bi judiocatsihquibaan rihbi hichaxon nincacoinquin. Patoro haibobaan rihbi nincacoinquin hicha tahnixon. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Jaa copi ta notsi notsixon shinanjoma tiromabo tsinquixon jema janinhah judiobaan jato coro coromanishqui. Jasoman xoboho sca jaa corotaibo mapeti, Criston raantibo benahi. Corotaibo bebonbi jato nichincatsihquin jato benacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Criston raantibo benacasquimaxon Jason sca bihxon caibo noquen huetsabo rihbi bihxon jema hapobo janin jato ninitancanquin. —Jatihibi janin tiromajaquin jonibo coromabenani ta neno sca neabo nocotipishqui. Jasoman rihbi ta jahuen xoboho jato hoxamahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jatihixonbi ta noquen quiquin hapo Cesaro nincacatsihyamascacanihqui, huetsa quiquin hapo Jesus jaresscai shinanxon copi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jascajaxon jonibo coromacanquin. Nincaxon jema hapobaan masa shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jaabi Jason cobranxon caibo rihbi cobranxon: —Boresscatannahue —jato jacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jaa yamebi ta Pablo, Silas rihbi noquen huetsabaan hionishqui Berea jema janin cahábo. Berea janin nocotax sca judiobaan tsinquiti xoboho mapecani. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jaabo ta Tesalónicabo mentan hashoan shinanya janishqui. Hihti honancatsihxon Papan joi nincacanquin. Jasca coin hin hihxon jatihibi neten Papan huishamani joi jisquin honancatsihquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hichaxon ta nincacoinnishqui. Jaton nahua patoro haibobo rihbi hicha. Bebobo rihbi huestima. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Papan joi Berea janinxon rihbi Pablonen yohihi honanscaax Tesalónica janinha judiobo jano rihbi bocani. Nocoxon jonibo sinamaxon jato coro coromacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jaa copi histon sca noquen huetsabaan Pablo camacanquin. Quebijistima hian quiri hiocanquin. Jema janin sca Silas betan Timoteo baneti. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablo hiohibaan ta Atenas jema caman jaa nocomanishqui. Janohax jaabo caribinon ta Pablonen jato joiya raannishqui, Silas betan Timoteo hahqui histon jonon. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenas janin jato manahahnan jatihibi janin santobo jai jisxon Pablonen masa shinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Judiobaan tsinquiti xoboho jato betan yohinanax Papahon shinanai judiomabo betan rihbi yohinani. Jatihibi neten rihbi jaton janoxon maroti jemanhihti janin jano jaibo betan yohinani Papan joi nincamacatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jaton honan joi honanaibo rihbi ta jano nihnínishqui, caibo epicúreobo, caibo estoicobo. Jaabaan ta Pablo yohuanquihnnishqui. Yohuanquihnax: —¿Jahua yohuan nea paranmis jaiquin? —hihqui caibo. —Nahuan dios joi yohinica ra tah qui —hihqui caibo rihbi. Jesus hihquipish bi hahquirihbi teehihqui joi jan yohihiya jascacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jaatian sca jaa bihxon Areópago janeya mahchi janin hiohax yocacahcani: —¿Nea min honanmahi joi behna min noque yohirohatimahin? ");
INSERT INTO kaqNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Min noque yohihi nincacax tah non rahtetai. Jahua min yohirohatimahin hih tah non jai honancatsihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Jatihibi Atenas janinhahbo betan huetsancohax johox jano jihuetaibo ta jahuabi teeyamapahonishqui. Joi behna yohixon nincaqui jihueresi. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Areópago mahchi naponbi nihrenenax sca Pablo yohuani: —Atenas janinhahbon, hicha diosbo man shinanai tah hen jisi. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Jema janin huinoxon tah hen maton diosbo huishaxon man tsahonxonni macanbo jisbonaxon hen nea huishayahpa huesti merahipiqui. Non honanyamahi diosenah hihqui jaa quirica. Jaa honanyamaxon bi hahan man shinanai Dios tah hen mato yohiscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nea naiyahpa mai, jano jaibo jatihibi rihbi hahní Dios ta nai hihbo qui, mai hihbo. Jaa ta jonin mequeman xobojahi janin jihueyamahihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jaa ta jonibaan hahxonti pishinyamabiresiqui. Noquen mequeman tah non jaa jahuabi hahxontimahi. Jaan caya ta jatihibi jihuemaxon noquen piti, jatihibi noque hinanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Huesti jonijamenonixon ta jahan sca jatihibi jonibo cainmanishqui jatihibi main jato jihuemanoxon. Janobi jihueyaxahnahue. Jaatian pari jihueyaxahnahue hih ta jaa janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Noquen Papa Dios benahahbo ta jascanishqui. Mehebonaquin meraxon hahcajaquin merahahbo ta jascanishqui, noque hochoma jan hihqui bi. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jaan ta noque yora jihuemahiqui. Hahan jatihibijati coshi hinanxon ta hahan jihueti shinan rihbi noque hinanihqui. Caibo maton quirica huishanicabaan rihbi ta jascajaquin huishanishqui: Noque tah non jahuen chini baquebo qui, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Papan chini baquebo hihxon tah non noquen Papa Dios oro quescapa hihqui shinantimahi. Yami pehneni quescapahma, macan quescapahma, jonibaan mequeman sirijaquin hahcai quescapahma, jonin shinanai quescapahma ta jaa qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Honanmabo jai bi ta Papan jato tenepahonishqui. Jato tenenixon bi ta rahma jatihibi jonibo sca jatihibi janin jaan yohiscaiqui shinan pontehahbo hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Jahuen hahan casticanti nete janoxahnon ta yohiscanishqui. Jahuen hahan casticannicah ta jaribiscaiqui, Mia tah min jonibo pontejaquin casticannicah qui hah cahen jaa janish. Jahuen casticannicah tsoa quin non honannon ta hihquipi que bi jaa hahquirihbi teehihmanishqui —jato jaquin Pablonen. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hihquipi bi hahquirihbi teehihmahi yohihi nincacax bitsa bitsacani. —Huetsa tian min noque yohirihbinon tah non nincayaxihqui —hihqui caibo rihbi. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jascahiya jato janinhax Pablo picoscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Caibaan rihbi nincacoinax Pablo manahi bocani. Huesti cahen Dionisio Areopagito, huetsa cahen haibo, Dámaris janeya. Caibobo rihbi jato betan cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Jaa pecaho ta Atenas janinhax picotax Corinto jema janin Pablo canishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Jano ta huesti judio meranishqui, Aquila janeya. Jaa ta Ponto mai janinha joni hihpahonishqui, jahuen haibo betan Italia janinhax jahuex nocotipi. Claudio quiquin hapo hihxon Roma jema janinhax jatihibi judiobo picoti jaan yohihiya janohax Aquila jahuipi. Jato jisi sca Pablo cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Jaa Aquila cahen chopa xobojanicah. Pablo rihbi ta jascajanica janishqui. Hahbe chopa xobojanicah honanax jaton xoboho jihuetax hahbetanbi Pablo teescai. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tantiti netebo nocoscaiya judiobaan tsinquiti xoboho caxon jato betan yohinanxon judiobo, jaton nahuabo rihbi Papan joi nincamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia janinhax Silas betan Timoteo nocoscaiya Papan joi yohihi sca jihueti. Jesus ta Papan caisai joni qui hihxon judiobo honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Honanmaha bi nincacatsihyamacani. Pablo qui tiromahi yohuancani. Jascaraiton jahuen chopa peren perenhahxon jato yohiquin: —Nincacatsihyamahax tah man hohchaya mahuatihi. Min tah min noque honanmayamaniqui hah tah man hea jatimascai. Nahuabo sca tah hen yohitihi —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Jato jascajabahini cahax jaa tsinquiti xobo patax jihuetai jonin xoboho mapescai. Jaa joni ta Justo janeya janishqui judiocatsihqui joni. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jaton tsinquiti xobo coirannicahton ta noquen Hihbo nincacoinnishqui, Jahuen jane cahen Crispo. Jahuen xoboho jihuetaibaan rihbi nincacoinquin jatihixonbi. Hihti caibo rihbi corinto jonibaan Papan joi nincaxon nincacoincanquin. Nincacoinaiton jato nashimacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Yame namaquen sca noquen Hihbo yohuanai Pablonen nincaquin: —Raquexonma yohireshue. Neteyamahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mia tah hen manahi cahi, tsoanbi mia tiromajaquin jahuejayamanon. Nea jema janin tah hen hicha joni jai —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Huesti bari seis hoxne rihbi ta jano jihuenishqui jato tocan jihuexon Papan joi honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Acaya main Galion sca gobernador hihquiya judiobo rahsi tsinquiscai. Tsinquixon jatihixonbi Pablo bihti shinancanquin. Bihxon jaton hapo janin hiocanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","—Noquen xenibaan yohini quescajayamaquin bi ta huetsajaquin Diosohon shinanahbo hihxon neatohon jonibo yohihihqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo sca yohuancatsihscai bi judiobo Galionen yohiquin: —Huetsa joni jan tiromajahiya tah hen jaa copi mato nincaquehanai, judiobon. Jan tiromahiya tah hen nincaquehanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Man yohuanresai joi tah hen nincacatsihyamahi. Janebo, maton xenibaan joibo, jascapa joibo copi man yohinanai tah hen nincacatsihyamahi. Botannahue. Bexonahue, matobi. Jascapa joi copi tah hen tsoabi pontecatsihyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jascajaxon jahuen ponteti xobo janinxon jato cainmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Cainmaha jaton tsinquiti xobo coirannica bihcanquin, Sóstenes janeya. Bihxon hapon ponteti xobo xehqui ponte nihxon rishqui rishquicanquin. Jascajahibaan bi Galion jahua hihyamahi, jisresquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Basi tahni jano jihuetahbax, Hen ta hen caresscai noquen huetsabon, hah jato jaax Pablo caresscai. Hen yohihipi quescabija tah hen jai hihxon honanahbo hihxon Cencrea jema janinxon sca jahuen boo maxcorohamabahinquin. Siria main caman nontin pohquejaquenoxon janohax nanecani. Priscila betan Aquila rihbi cahi hahbetan. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeso jeman pari taxnatax jato potabahini cahi, judiobaan tsinquiti xoboho mapeti. Janoxon judiobo yohuanquihnquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Basi pari banetahhue hahcabo bi Pablo queenyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","—Hen tah hen caresscai. Noquen Papa queenaiya tah hen joribitihi —jato jaquin. Nanerihbixon Efeso jema potabahinquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea jema janin sca mapetax Jerusalen janinha noquen huetsabo pasijatani joresscaax Antioquía jema janin cahpaquehcahini cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jano ta jihuenishqui basima tahni. Janohax sca cahax Galacia mai nabebacahini cahax Frigia mai rihbi nabebacahini cahi. Noquen huetsabo shinan coshijabonahi cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Huesti Apolos janeya judio ta Efeso janin noconishqui Alejandría janinha joni. Joi yohinica. Papan huishani joi honanquin sirijahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Criston joi honanmahabo hihti yohicatsihxon jaan jato yohiquin. Jesus joi jato yohiquin sirijaquin jaamama. Hihcax bi jatihibi honanyamaquin. Juaman nashimati joi honanxon Criston janen nashimati joi honanyamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Raquetaxma ta jaton tsinquiti xoboho yohuannishqui. Jan yohuanai nincaxon jaton xoboho boxon Priscila betan Aquilanen hashoan sirijaquin Papan joi honanmaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Acaya main jaa cacatsihquiton, Catanhue, hahxon noquen huetsabaan quirica huishaquin, jaya cahiton Criston jonibaan sirijaquin bihnon hihxon. Cahi nocoxon nincacoinaibo hicha shinan hinanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Papan huishani joi jismaxon ta Cristo ta Papan caisai joni qui hihxon judiobo yohinishqui. Jatihixonbi nincacahbo hihquish ta janibi nichish yohuannishqui. Sirijaquin jato yohihiya ta nincacoinaibaan shinan bihnishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Corinto janin Apolos jaiya manan cahpoquetax Efeso janin sca Pablo cahpaqueti. Jano Papan joníbo huestibo meraquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","—¿Nincacoinxon man Dios Yoshin bihyamahin? —jato jaquin. —Dios Yoshin joi tah non honanyamaparihi —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","—¿Tsoan janen mato nashimacannishquin? —jato jaquin. —Juaman nashimapahoni quescajaquin rahan —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","—Jaa hahchon jahui joni nincacoinahbo hihxon yohixon ta Juaman nashimapahonishqui shinan pontehiton. Jaa hahchon joní joni ta Jesus qui —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jaa honanscaxon cahen noquen Hihbo Jesusen janen sca jato nashimanon yohicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pablonen jato mehehiya Dios Yoshin jato qui nocohihnati jahui. Jaa bichish huetsapahi yohuancani. Papan honanmaha yohuanscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Doce joni rah ta jaabo janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Judiobaan tsinquiti xoboho mapetax sca tsoanbi chihtehahma Pablo yohuani. Quimisha hoxne jato betan yohinani, Papan jihuemayaxihqui joi yohinani. Yohuanquihnannani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Jaatian ta nincayosma jointi chahomayahpabo noquen Hihbaan joi qui tiromahi yohuanscanishqui, janibi sca hichaxon nincacahbo. Jaa copi ta janohax Pablo picoscaxon Criston jonibo hioxon jatihibi neten Tiranno escuela xobohoxon jato yohinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Janoxon ta rabe bari haxemanishqui. Jaan jato haxemahiya jatihibi Asia janin jihuetaibaan noquen Hihbaan siri joi nincaquin. Judiobo betan judiomabaan nincacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pablo ta noquen Papan hahan hihti rahtetibo hahmanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Payon bihxon, jaa hihyamahiya chopa pishca bihxon jayaxon Pablo mehexon ta jaton hisinaibo sca hahan rahoncannishqui. Rahona jaton hisinbo picoti, jaton tiroma yoshinbo rihbi picoti. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nihresai judio yobebo sca nocoti jahui. Nocoxon tiroma yoshinyahpabo meraxon noquen Hihbo Jesusen janen jaton yoshinbo yohicanquin picotahbo hihxon: —Hoa Pablonen yohihi Jesusen janen tah non mia yohihi —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jaton papa ta Esceva janeya janishqui, judiobaan quiquin sacerdote. Jahuen baquebaan siete hihxon jascajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Jascajaquin yohihiton tiroma yoshiman jato joi bichinquin: —Jesus tah hen honanai. Pablo rihbi tah hen honanai. ¿Mato man tsoabo quin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Jato jascajaxon jaa yoshinyahpa jonin jato qui cayatan cayatanxon jato bahchinquin. Jato jatihibi taponbi potaquin. Jaan huexahah chopanma tsehue tsehueya sca jaa xobo janinhax jabascacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efeso jema janin jihuetai judiobaan ta jaa joi nincanishqui jatihixonbi. Judiomabaan rihbi jatihixonbi nincaquin. Nincacax ta hihti raquescacannishqui. Noquen Hihbo Jesus hihti coshi honancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nincacoinaibo hicha joxon tiromajaquin hahpahoniboxon jaton hohcha yohipaquecanquin, jascapa jenebahinnoxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Hicha yobe hihpahonibaan rihbi jaton yobepan quirica bexon jatihixonbi jisnon hihxon janibixon jaton quirica mapojacanquin. Jaabaan mapojahi quirica toponah ta cien mil soro copinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jaatian ta noquen Hihbaan joi hashoan sca caícananishqui. Huetsa joi potaxon jaa sca bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Jaa pecabo cahen Jerusalen jema janin cati sca Pablonen shinannish. Macedonia mai nabebacahini cahax Acaya mai rihbi nabebacahini cahax Jerusalen jema janin nocoti shinanquin. Janohax tah hen Roma jema janin catihi hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jaatian Macedonia janin bebotannon hihxon jahuen yanapannica rabe raanquin Timoteo betan Erasto. Jato raanax Asia main jihuetahbihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jato raanipi pecaho ta noquen Hihbaan joi copi rainyamahax hihti caibo corocahinquihrani nocohihnacannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio janeya joni ta jano janishqui, yami charajahi teenica. Jaton santo Diana xobojaxonnica. Jascajaquin ta jahuen hahbe santo xobojanicahbo hicha jato cananmanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Jato quenamaxon jascapahbo hahnicahbo rihbi quenamaxon ta jato yohinishqui: —Nescapahbojaquin tah non coriqui cananai. Man tah man honanquin sirijahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hihti caibo yohixon ta Pablonen jato honanmahiqui jaa sca chibanahbo. Efeso janin res ma bi ta jatihibi janin jato jascajaquin yohihiqui. Casi jatihibi Asia mai mehabo ta jato nincamascaiqui. Jaa tah man jisxon nincarihbihi. Jonin mequeman hahcaibo ta diosmabo qui hih ta jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jan jascajaquin noquen tee tiromajamis hihxon tah hen mato yohirihbihi. Jascajaquin yohihah ta noquen dios xobo caibaan jahuama shinanscatihiqui, noquen hihti siri haibo dios Diana xobo. Jaa rihbi ta jahuama shinantihcanihqui. Asia mai janin jihuetaibaan jatihixonbi hahan shinanai que bi ta jahuama sca jatihiqui —jato jaquin. Jatihibi mai janin jihuetaibaan hahan shinanai que bi jahuama sca. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Jan yohuanai nincacax hihti rainyamahax sai saihihcani. —Noque Efeso janin jihuetaibaan Diana ta hihti shinanya qui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jaa jema bahibo janin jatihibi coro cororescani. Jahua nincatimascai. Pablon companihro rabe sca bihxon ninibonahi bocani. Janoxon yohuanaibo nincati mai xanqueman sca bishquihihcanahi bocani. Pablon companihro cahen Gayo, huetsa cahen Aristarco, Macedonia janinha rabe. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo rihbi jano hihquicatsihqui bi ta caibaan Criston jonibaan huinómayamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Caibo patorobo rihbi Pablon amicobo hihxon joi raanquin, jan jaton jaho tsinquiti mai xanqueman cayamanon hihxon, rehtecanmis hihxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Corotaibo Pablo qui chanicatsihquish caibo huetsa yohuanya janon caibo rihbi huetsa yohuanya sai saihihcani. Coro coroquin nincatimajacanquin. Jahuejahi non tsinquitain hihxon hichaxon honanyamarihbicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mia sca yohuani cahue hihxon judiobaan pehueranbonaha janohax yohuanti janin Alejandro mapeti. Jonibo nincamacatsihquin jahuen mequen sanaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Jahuen mequen sanahihnihiya hihti sai saihihscacani. Judio tah qui hihquish sai saihihresscacani, jaa yohuanai nincacatsihyamahax. Rabe horabo jano coro corocani. —Noque Efeso janin jihuetaibaan haibo dios Diana ta hihti shinanya qui —hihcani coshin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Corotaibo tantimascaax jaton tininti yohuani: —Efeso janinhahbaan, noque Efeso janin jihuetaibaan tah non noquen hihti shinanya Diana xobo coiranxonai. Naihoh quehax paqueni jahuen santo rihbi tah non coiranxonai. Non jascajahi ta jatihixonbi honancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jascama ta qui, hih ta tsoabi jatimahiqui. Jaa copi tah man tantitihi. Sirijaquin shinanyamaxon jahuabi jahuejayamanahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Jaabaan maton diosen xobo jahua tiromajahi que ma bi tah man nea rabe joni neno hihuehahqui. Maton dios qui rihbi tiromahi yohuanai que ma bi. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demandanaibo nincati netebo ta jaiqui. Noquen gobernadorbo rihbi ta neno jaresscaiqui. Nea jonibo qui chanicatsihxon jahuen hahbe teenica betan Demetrionen jato demandantannon. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Huetsa joi rihbi nincamacatsihxon janoxon jascajati jai janinxon hahtannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Man rahma coro corotai joi nincacax, noque rah ta potacatsihcanihqui romano hapobo jamis. Jaa copi tah hen mato yohihi. Jahua copi man coro corocanahi tsinquitain hahcah tah non jahua yohiti yamahi —jato jaquin jaton tinintinin. ");
INSERT INTO kaqNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Jato jascajaha jaton xoboho boresscacani. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Coroyama sca jaiboya Criston jonibo quenamaxon nincacoinquin jeneyamaxahnnon hihxon jato yohihax, Hen tah hen caresscai, hihquish Macedonia mai janin cahi Pablo caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Macedonia maibo nabebacahini caquin jano jai noquen huetsabo hicha yohiquin. Jato yohibonahi cahi Grecia main nocoti. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Jano sca quimisha hoxne hihqui. Siria main caman pohquenoxon nontin nanepanan ta jano sca jaa cacatsihqui honanscaxon judiobaan jaa bihti shinannishqui. Bihcatsihquibo nincarihbihax Macedonia main caribihax janohax sca cati Pablonen shinanscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hahbetan ta caibo rihbi canishqui. Huetsa cahen Sópater, Pirron baque, Berea janinhah. Huetsa cahen tesalónicabo rabe, Aristarco betan Segundo. Huetsa cahen Gayo, Derbe jema janinhah. Huetsa cahen Timoteo. Huetsa cahen Asia mai meha rabe, Tíquico betan Trófimo. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Jaabo rahsi bebotanax Troas jema janin noque manati bocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Chahoma paan fiesta huinotipish Filipos jema janinhax noque cahi. Pichca nete nihxon Troas janin jato merahax jano sca siete neten rihbi noque baneti. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hahan semana pehocohtai neten sca pihi noque tsinquiti. Bahquish sca cayanoxon jato betan Pablo yohuan yohuani. Yame pochinicon caman jaa yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jano noque tsinquitai chiqueho cahen hicha ramparin xabati. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jano ta xehqui pishca janin huesti beronan tsahonishqui Eutico janeya. Pablo basi yohuan yohuanaiya ta hoxa teneyamascaax paquenishqui. Jaton quimisha tapoyahpa xobohoh quehax paqueti bochiquihax. Mahuascai bihtancanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Hahqui botopaquescaxon Pablonen jaa racatai hicobahinquin. —Masa shinanyamanahue. Jihue ta jaiqui —noque jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jaatian sca maperihbixon posen tehcaxon pihax, xaba paquenon caman yohuanrihbihax, caresscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jaa beronan mohitahpa mapemahiya ta sirijaquin sca shinancannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ason jema caman Pablo main cacatsihquiya tah non nontin bebohi caniqui. Cahax Ason jema janin Pablo bichi taxnati. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Jano noque merahi jorescaiya tah non nanemahax Mitilene jema caman noconihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Jano hoxashinahax mohiyahtax tah non caribiniqui. Cahi Quío mai pishca qui nocoti. Janohax caxon hian naponbi racatai mai pishca huinobahinquin, Samos janeya mai pishca. Janohax jahuen quimisha neten sca Mileto jema janin nocotax taxnati. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Janin Pentecostes fiesta noconon hihquish ta Jerusalen janin Pablo histon nococatsihnishqui hahtipahax. Jaa copi ta Asia mai janin basiyamanoxon Efeso jema huinoresti shinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto janixon sca Efeso janinha pastorobo jaan quenamaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nocotaiton jato yohiquin: —¿Asia main noconish jenquetsi hen mato tocan jihuenihquin? Man tah man honanquin sirijahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Jahuabi hapo quescaxonma tah hen noquen Hihbo teexonniqui. Heen caibaan hea tiromajacatsihquin tana tanahah tah hen masa shinani jihuenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mato sirijanoxon tah hen jahuabi mato yohiquin pishinmayamaniqui. Tsinquitaiton yohixon tah hen heen xobohoxon rihbi yohixon mato honanmaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Papan joi nincaxon shinan pontexon noquen Hihbo Jesucristo sca nincacoinnon hihxon tah hen heen caibo yohixon heen nahuabo rihbi yohicoinnihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Dios Yoshiman hiohah sca tah hen Jerusalen janin cahi. ¿Janoxon hea jahuejaticaniquin? Hen tah hen honanyamahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Jatihibi jema janin ta Dios Yoshiman hea yohihiqui. Cadenanen nexaxon ta mia hihti tiromajayaxihcanihqui, hah ta hea jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Jaabi hea rehtecanmis hih ta hea jayamahi. Noquen Hihbo Jesusen hea yohini quescabijaquin Papan jatohon shinanai joi siri yohiti res tah hen queenai. Papan hea yohihi cahue hahca tah hen cahi, jano hea raanaiton. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mato tocan caquin tah hen Papan mato jihuemahi joi mato yohinihqui. Hea tah man jisyamascatihi. Hen tah hen honanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jaa copi tah hen mato rahma yohihi. Maton hohchayabi mahuatax tah man Joi siri Pablonen yohiyamahah bi tah non mahuatai, hih man tsoabi jatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Papan noque yohihi jatihibi tah hen mato sirijaquin yohinihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Coiramenahue. Criston jonibo rihbi coirannahue. Jaabo man coirannon hihxon ta Dios Yoshiman mato pastorobomanishqui. Carnero pimaquin hahcajaquin man Papan caisaibo shinan hinannon hihxon ta mato jaa tee hinannishqui. Jahuen jimi potaquin ta Criston jahuen caisaibo bihnishqui jahuen carnerobo. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Hea caresscaho pecaho ta mato tocan tiroma jonibo nocoyaxihquiqui carnerobo rehteresai hinobaan hahcajaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hea chibannahue Criston jonibon hihnicah rihbi ta mato quihabo caibo jayaxihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jaa copi coirannahue. Quimisha bari tah hen matohon hihti shinanxon yame, bariyahpan rihbi hen mato yohipaquehi tantiyamanihqui. Jaa shinannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jato coiranhue Hihbon, hahbahini tah hen cahi. Jahuen joi bihquin jeneyamanahue, hahan tah man jihuetihi, matohon shinanxon hinanai jahuen joi. Jaan ta mato shinan hinanxon jatihibi jahuen baquebo tocan mato jahuen jihue hihbobo sca jaan mato hihmati hahtipahiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Maton oro, maton coriqui, maton chopa tah hen jahuentianbi mato bichincatsihyamanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Heen mequeman teexon tah hen hen pishinaibo bihniqui. Heen hahberabetibaana rihbi tah hen bihxonnihqui. Man tah man honanai. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Hea hihqui quescarihbi man janon hihquish tah hen jihuenihqui. Jascajaquin teexon noquen Hihbo Jesusen joi shinanxon yomanahquetaibo yanapanti tah hen mato haxemaniqui. Hinanti ta bihti mentan hashoan siri qui, hah cahen noquen Hihbaan janish —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Jatihibixonbi sca raboxonen nihxon Papa yocacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Huaohihscacani jatihibi. Pablo mehuetanax hicotanax huaohihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jan jato yohihah nincacax jaa jisyamascatihi nincacax bena benatax nontin caman jaa manahi bocani. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jaatian tah non nanetax jato potabahini caniqui. Cos mai janin caman tah non ponte caniqui. Jano hoxashinahax mohiyahtax cahax Rodas mai janin sca nocoti. Janohax Pátara jema janin taxnati cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fenicia mai janin pohquejaqueti cahi, nonti jano merahax hahan sca nanetax quebijistima hiaman caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Caquin tah non noque memiho Chipre mai jisniqui. Jaa potabahinax Siria mai janin cahax Tiro jeman taxnatax mapeti. Jahuen jahuaborabo nonti hihbaan jano mapemahi cahiya tah non jano mapenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tiro janin tah non Criston baquebo meranihqui. Jato betan tah non siete neten banetahnihqui. Dios Yoshiman shinanmaha Pablo yohicanquin, Jerusalen janin cayamahue hahxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jahuentihi ra neten jano hihquish tah non caribiniqui. Jema jemanhihti janin ta jaabo jaton haibobo jaton baquebo noque manahi canishqui. Jemanhihtinin sca tah non raboxonen nihxon Papa yocanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Papa yocacax nontin noque naneti, jaabo xobon boribihahbo. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro potabahinax Tolemaida jeman taxnatax noque mapeti, main sca canoxon. Jano noquen huetsabo jisi caxon huesti neten rihbi jato pasijaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Hoxashinahax mohiyahtax caribihax Cesarea jeman nocotax Felipen xoboho mapeti. Felipe ta Papan joi siri nincamanicah hihpahonishqui hoa siete caisnibo quihah. Jahuen xoboho tah non banejaquenihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jaa ta chosco haibo baqueyahpa janishqui bebo honanyamahibo rahsi. Papan shinanmaha ta jaabo yohuanpahonishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Jahuentihi ra neten non jano jaiya Judea mai janinhax Agabo janeya joni nocoti, Papan shinanmaha yohuannica. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nocoxon Pablon sintoron bichinax jahan sca tanexehtax menexehtax yohuanscai: —Dios Yoshiman ta yohihiqui: Nescajaquin ta Jerusalen janinha judiobaan nea sintoron hihbo nexayaxihcanihqui. Nexaxon ta nahuabo sca jaa hinanyaxihcanihqui —hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Jan yohuanai nincaxon tah non Jerusalen janin jaa cayamascanon hihxon Pablo noquen yohinihqui. Janohahbaan jascajaribiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Jascajahabaan bi Pablonen yohiquin: —¿Jahuejanoxon man huaohihxon hea masa shinanmacatsihquin? Hea noquen Hihbo Jesusen joni copi hea nexayaxihquibo bi tah hen cati shinanai. Jerusalen janin hea rehteyaxihquibaan bi tah hen cati shinanai —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Banemati hahtipahyamahax noque netescai. —Noquen Hihbo queenai quescari janon —hihquish. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Jaa pecaho sca non pishinaibo bichish Jerusalen janin noque cahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cesarea janinha noquen huetsabo caibo noque betan caxon Mnasoman xoboho noque hiocanquin. Mnason ta Chipre janinha joni qui, Criston joni xeni. Jaan ta noque jahuen xoboho hoxamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalen janin noco sca non jaiya jenimahanan noquen huetsabaan noque bihquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Hoxashinahax mohiyahtax sca noque betan Pablo cahi, Jacobo jisi. Jano ta jatihibi jaton pastorobo tsinquinishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Man jascabi jayamahin hahxon jaton nahuabo tocan Papan hahan honanti jaa hahmatanho jato yohipaquequin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jan chanihi nincaxon: —Papan ta hahquiqui —hahxon yohicanquin: —Noquen caibo nincacoinaibo ta jahuentihi ra mil jaresscaiqui. Jatihixonbi ta Moisesnin joi chibancaniqui. Min tah min honanscai. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Mian roqui min hochó jabisnihbo noquen caibo mian honanmahi Moisesnin joi jenebahinnon. Jaton baquebo honantijayamati roqui mian jato yohihi. Moisesnin yohini quescayamascarihbihi jihuenon roqui mian jato yohihi. Jascaraibo ta nincacaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Jahueja sca min jatihin? Min nocotai ta honannoxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jaa copi non mia yohihi quescabijahue. Neno ta chosco beronan jaiqui, Hen yohihi quescabijaquin tah hen jatihi hihquipibo yohuani. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jato hiohax jato betan nashitanxon jaton mapo maxcorohabahinnon copijaxonhue. Min jascajahi jisxon ta jaabaan nincacai jahuama hihqui honannoxihcanihqui. Man Moisesnin joi chibanparihin ta honannoxihcanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Santo rehtexona nami nincacoinai judiomabaan piyamanon hihxon jimi rihbi piyamanon hihxon terehahxon rehtehibo rihbi piyamanon hihxon joni huetsa betan tsiniyamanon hihxon tah non jato moa huishaxon yohinihqui. Jaa ta honanscacanihqui —hihqui Jacobo. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Jascaha jaa beronanbo hiohax huetsa neten sca jato betan nashihax Papan xoboho Pablo mapeti. Mapexon: —Jatíhi neten hihquish tah non mequejaqueti queyoscatihi. ¿Jahua neten non jatihibichina noquen hinanti non betihin hinannoxon? —hihqui Pablo, hapo yocacahti. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jahuen siete nete nocoti pishca pishinaiya Asia janinhax judiobo nococani. Papan xoboho Pablo meraxon jonibo coro coromaxon Pablo bihcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Coshin sca quenacanquin: —Noque yanapannahue, noque caibon. Nea ta jatihibi janin nihxon noque qui tiromahi yohuanai joni qui. Nea ta Moisesnin joi qui yohuanihqui. Nea xobo qui tiromahi yohuanrihbihi. Jascajahax ta Pishin pari ta jaiqui hihquish, Papan xoboho nahuabo rihbi mapemaxon nea mequexonti xobo rishtajahiqui —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Efeso janiha joni betan Pablo jaton jema janin nichi jisipixon Papan xoboho Pablonen jaa mapemahi shinancanquin. Trófimo cahen jaa joni. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jascajahiboya jema jatihobi cobinai quescapi jonibo rainyamahax bishqui bishquihihcanahax Papan xoboho nocohihnati. Pablo bihxon jemanhihti janin ninixon xehpotibo xehpobahincanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Jaa rehtehibaan bi ta sontaro hapo qui cahax caibo chaninishqui, Jerusalen janin ta jatihibi coro corocaniqui, hihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Sontarobo quenamaxon jaton capitanbo rihbi histon quenamaxon jato betan jema janin hishtocahinquihrani sontaro tininti jahui. Jaton hapo betan sontarobo jahui honanxon Pablo rishquiquin jenebahinscacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nocoxon Pablo bihxon cahen rabe cadenanen nexahahbo hihxon sontaro hapon jato yohiquin. Jascajaxon sca: —¿Tsoa min quin? ¿Jahuejahi meraxon mia jascajacanihquin? —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Corotaibo cahen mesco yohuanyahpabo. Coro corotaiboya jahuabi honanquin sirijati hahtipahyamaxon sontarobo sca yohiquin: Xoboho hiotannahue —jato jaquin jaton hapon. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Rehtenahue hihqui coro corocanahibo sina sinataiya tapiti qui Pablo nocotaibon sontarobaan jaa hiascacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","—Rehtenahue —coshin hihcanacani coro corotaibo. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sontarobaan xobo xehqui qui nocoscaxon sontaro hapo Pablonen yohiquin: —¿Hen mia pishca yohinon min hea nincarohatimahin? —hahquin. —¿Griego join min yohuanain? ");
INSERT INTO kaqNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Mia min hoa Egipto mai meha jonimah quin? ¿Hapobo potanon hihxon jato sinamaxon cuatro mil rehtemisbo nihi naman sca hiohipi, mia min jaamah quin? —hahquin yocaquin sontaro hapon. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Jascajaha Pablonen yohiquin: —Hea ta Tarso janinha judio qui. Cilicia main hani jema janinhah. Nea jonibo hea yohimarohahue —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jan jeenhihquiya tapitinin mapexon jato qui jahuen mequen Pablonen sanaquin. Netecahinscacani. Jaton joinbi sca Pablo yohuani, judiobaan join sca. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Hea huetsabaan, heen papabaan, hea tsoa quin hen mato rahma yohinon nincanahue —jato jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jaton joinbi jan yohuanai nincacax hashoan sca netecani. Pablo yohuanparihi: ");
INSERT INTO kaqNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Hea ta judio qui, Cilicia mai Tarso janinhax cainni joni. Nea jema janinxon ta maton haxemanicahbaan hea haxemapahonishqui. Gamaliel ta heen haxemanica hihxon hea haxemaquin sirijanishqui. Noquen xenibaan yohini quescabijaquin hen hahnon ta hea haxemanishqui. Man hihqui quescarihbihi tah hen noquen Papan joi hihti jenipahichai. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Hean rahma nincacoinai joi nincacoinaibo tah hen rehtenoxon caman jato chibanpahonihqui. Cadenanen nexaxon tah hen haiboya bebo jato sipojapahoniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hen jascajapahoni ta sacerdotebaan hapon, jatihibi noquen hani hapobaan rihbi mato yohitihiqui. Jaabaan ta hea jayaxon jato bihti quirica hinannishqui, Damasco janinha noquen huetsabo hen hinantannon hihxon. Jaya caxon jano jaibo cadenanen nexaxon casticannoxon sca neno Jerusalen janin jato hihuehi tah hen caniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Barin manan tsacahiya ta Damasco hochoma bahin cahiton naihohxon sca hani xabapan hea xabajanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Main paquexon sca hea yohihi joi hean nincaquin: Saulon, Saulon, ¿jahua copi min hea tiromajaquin chibanain? hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","¿Tsoa min quin, Hihbon? hahquin hean. Hea ta Jesus Nazareno qui, min hea tiromajaquin chibanai, hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Hehbetan cahibaan ta jaa xaba jisxon bi hehbetan yohuanai joi nincayamanishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Hean hen jahuejati jain Hihbon, hean jaah ta Huenihue. Damasco janin catanhue. Jano ta mian hea hahxonti jai mia yohinoxihcanihqui hah ta hea noquen Hihbaan janishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Hoa xabapan bechaxah tah hen jisti hahtipahyamascaax hehbe cahibaan mehuetanxon hiohah sca Damasco jema janin noconihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Jano ta Ananías janeya joni janishqui, Moisesnin joi nincanica. Jano jihuetai judiobaan ta jatihixonbi jahan shinannishqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hea janin nocoxon ta hea pataxxon sca, Heen huetsa Saulon, jise, hea janishqui. Jaatianbi tah hen jisresscaxon jaa meranihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Noquen papabaan Papa Diosen ta mia caisihqui, mian jaa hahxonti jan shinanai min honannon hihxon. Jahuen nincanica baque min jisnon, jan yohuanai min nincarihbinon ta mia caisihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Min jisibo, min nincacaibo rihbi tah min jatihibi jonibo yohiyaxihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","¿Jahuejahi sca min basitihin? Mia nashimanon huenihue. Noquen Hihbo yocaxon miin hohcha sohuamascahue, hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jerusalen janin nocorihbixon tah hen Papan xobohoxon Papa yocaxon namaquen hahcajaquin noquen Hihbo jisniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Histon Jerusalen janinhax carihue. Hean hen jato hahxonai min jato yohihah ta nincayamaxihcanihqui, hea jaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Hihbon, noquen tsinquiti xoboboho hihcoxon mia nincacoinaibo meraxon hean sipojaxon jato rishqui rishquipahoni ta honancaniqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Miin joi yohinica Esteban rehtehiboya rihbi tah hen jano rihbi nihxon jascajanahue hihxon jaa rehtehibaan chopa hean coiranxonnihqui, hahquin hean. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Catanhue, hocho tah hen mia raantihi nahuabo janin, hea noquen Hihbaan jaquin —hihqui Pablo. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jano caman res nincacanquin. Jaton nahuabo yohihi Pablo catihi nincacax coshin sca sai saihihcani: —Jascapa joni main yamascanon rehtenahue. Jascapah ta jihuetimahiqui —hihcani. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jaton chopa pecaxon mai poto rihbi bochiqui potahihnicanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jascajahibo jisxon Xoboho botannahue hapon jahuen sontarobo hahquin. Jahua copi jonibo hahqui jatiho sinatiquin hihxon sca rishqui rishquixon hisinjanon jato yohirihbiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yohihah rishquinoxon nexacanquin. Jano jai capitan sca Pablonen yocaquin: —¿Jahuen hohcha honanxonma romano joni rishquiti joi man jain? ");
INSERT INTO kaqNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jan yocacai nincacax hapo janin caxon capitanen yohiquin: —¿Jahueja min jacatsihquin? Jaa ta romano joni qui —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Hahqui caxon sca hapon yocaquin: —¿Mia min romano quin? —Hea rahan —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","—Hea tah hen hicha copijahax romanoscaniqui —hahquin hapon. —Hea tah hen romano cainnihqui —hahquin Pablonen. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Histon sca jaa hisinjacatsihquibo picoti bocani. Romano que bi jan cadenanen jaa nexahi copi hapo rihbi raquescai. ");
INSERT INTO kaqNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jascajahipi huesti nete sca jahua hahqui yohuan jacoiniquin hihxon Pablo pecaxon sacerdotebaan hapobo, judiobaan hanibo jatihibi betan tsinquinon yohiquin. Jato qui hioxon sca jato bebonbi Pablo nichinquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Tsinquitai hapobo jisanan Pablonen jato yohiquin: —Hea huetsabaan, shinanquin sirijahax, tiromahaxma jihuepahonish tah hen rahma caman jascarai, Papan hea jisi honanax. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pablonen jascajahiya jaa pataxaibaan Pablo copasnon sacerdotebaan hapon jato yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","—Papa Diosen ta miabi rishquiyaxihquiqui, maoxen sicaha chiquepan. ¿Jascajatima Moisesnin yohinih que bi min hea jato copasmahin? ¿Jascajaquin min hea Moisesnin yohini quescajaquin min hea pontecatsihquin? —hahquin Pablonen. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Jaa pataxaibaan sca: —¿Papa Diosen sacerdote hapo min jascajaquin tiromajaquin yohihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","—Sacerdotebaan hapo tah hen honanyamahahqui, hea huetsabaan. Maton hapo tah man tiromajaquin yohitimahi hah ta huishani joi jaiqui —hahquin Pablonen. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jaatian caibo fariseobo caibo rihbi saduceobo honanscaxon hapobaan nincacahbo coshin sca yohuani: —Hea ta fariseo qui, hea huetsabaan. Fariseobaan baque ta hea qui. Mahuanihbo ta Papan hahquirihbi teehihmayaxihquiqui hen jai copi ta hea casticancanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Jan jascaraiya fariseobo betan saduceobo join bahchinanscai. Jaa copi caibaan Pablo casticancatsihqui bi caibo queenyamascai. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mahuanihbo ta Papan teehihmaribitimahiqui. Papan naihoh queha yonotibo ta yamahihqui, yoshin rihbi ta yamahihqui, hih saduceobo jai bi ta Hah ta jatihiqui, jaí rahan, jaí rahan, fariseobo jaiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Join bahchinani corotaiboya fariseo huishani honanbo nihrenenxon hani join coshin jato yohiquin: —Noquen jisi ta nea joni hohcha yamahihqui. Yoshiman jaa yohuanquihnaiya jaa hihyamahiya Papan yonotinin jaa yohuanquihnaiya mato jahua hihtihin? —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hashoan sca rainyamacani. Nininanquin Pablo huaxabahincanmis hihxon, Jato bichinnahue hapon jahuen sontarobo jaquin. Mehuetani caxon bichinxon coshin ninibehnantanxon jaton xoboho sontarobaan Pablo boresscaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jascajahipi huesti neten sca yame Pablo janin noquen Hihbo sanarenenxon: —Raqueyamahue. Neno Jerusalen jema janinxon min hehqui jato yohicoinai quescajaribiquin tah min Roma jema janinxon jatihi —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Xaba paquescaiya Pablo rehteti shinancanquin judiobaan. —Non jaa rehtenoxon caman tah non pitimahi, xehatimarihbihi. Non jaa rehteyamahiya noque sca Papan rehtenon —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Cuarenta joni hihxon jascajacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Jascajahax jano sacerdote hapobo betan jaton hanibo jaiton bocani. Nocoxon: —Non yohihi quescabijaquin non hahyamahiya Papan noque rehtenon hihxon tah non yohihahqui, Pablo rehtenoxon caman tah non jahuabi piti nohuejatimahi. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tsinquitai hapobo yocaxon sontaro hapo rihbi yocanahue jan neno mato janin jaa bexonnon. Pablo yohuanai man sirijaquin sca nincacatsihqui janahue. Janin noconon tah non rehtetihi, non tah non manascai —hahcanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Rehteti shinanaibo honanax Pablon pihasha pishca cahi sontarobaan xoboho caxon Pablo yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Jaan sca capitan quenaquin. Jahuiton: —Nea beronan miin hapo janin hioxonhue jan nincabehnanai jan yohitannon —hahquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jahuen hapo janin sca capitanen hioquin. —Non bichipi Pablonen ta hea quenaxon nea beronan mihqui hihuexonnon hea yocacaxqui. Mia roqui nincamacatsihquiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jascajaha mehuetanxon hahmebi hiohax sca yocacahti: —¿Jahua min hea yohicatsihquin? ");
INSERT INTO kaqNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","—Heen caibaan ta hashoan sirijaquin honancatsihquin hahcajaquin mia nescajaquin yocati shinanihqui. Non Pablo yocanon hapobo tsinquitai janin bahquish Pablo hioxonyaxahnhue hih ta jacanihqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Jaabo hihcoinai shinanyamahue. Cuarenta hihxon hashoan hicharihbixon ta jaa rehtenoxon caman pitimahi, xehatimahi yohicaniqui, rehteyamahiboya jaabo sca Papan rehtenon hihxon. Rahma ta quexescacanihqui rehtecatsihquin. Min jeenhahnon res ta manacaniqui —hahquin beronanen. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","—Hea min jascajahi tsoabi yohiyamatahin min. Caresscatanhue —hahquin hapon. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Rabe capitan sca quenaxon jato yohiquin: —Doscientos sontaro tsinquinahue. Cabachonen nichibo rihbi setenta sontaro. Jashiyahpabo rihbi doscientos sontaro. Yame sca jaiya Cesarea jema janin caman Pablo botannon jato raannahue. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Hahan Pablo rihbi cati cabacho bexonnahue, gobernador Félix janin caman sirijaquin hionoxon. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jato jascajaxon quirica sca nescajaquin huishaquin: ");
INSERT INTO kaqNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Hea Claudio Lisias hihxon tah hen mia noquen gobernador Félix mihqui joi raanai. ¿Min jascabi jayamahin? ");
INSERT INTO kaqNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hen mihqui raanai joni judiobaan rehtepanan tah hen sontaroya nocoxon romano joni honanxon jato bichinipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jahua tiroma jaiquin hihxon hen jaton hapobo jano tsinquitaiton hiohipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Jaton xenibaan joi jan nincayamarai copi res jaabaan sinajahi bi ta jahua copi rehteti yama qui. Jahua copi sipojati yamarihbihi tah hen honanscaipiqui. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Jaa rehtenoxon caman piyamaxihquibo jai chanihah tah hen histon res mihqui raanti shinanscaipiqui. Hahqui yohuanaibo rihbi tah hen yohihipiqui, hahqui yohuanti joi jaxon mia hihbaan yohuantannon, hahquin huishaquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hapon yohiha quescabijaquin cahen Pablo bihxon nihshinaxon Antípatris jema janin caman sontarobaan hioquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bariyahpan sca cabachonen nichibo hahbetan catannon texe sontarobo jaton xobon caribihi. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hiotanxon Cesarea jema janin nocoxon cabachonen nichibaan janoha gobernador qui jaa quirica hinanquin. Hinanxon Pablo rihbi hahqui hihuecanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Jaa quirica jisxon jahuerahnoha mai meha mia quin hihxon Pablo yocascaquin. Cilicia mai meha rahan jan hihnon: ");
INSERT INTO kaqNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","—Min yohihi tah hen nincatihi mihqui yohuanaibo nocotaiya —hahxon Herodesnin quiquin hapo xobohoxon coiranahbo hihxon jahuen sontarobo yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Jan jano nocotipi pichca neten sca sacerdotebaan hapo Ananías nocoti jahui. Hahbetan rihbi caibo jaton hanibo. Yohuanxon yanapannicah rihbi Tértulo janeya. Jaa rahsi jahui. Pablo qui jaabo yohuanti jai joi jaton gobernador nincamacanquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pablo quenamaha noco sca jaiya hahqui yohuani Tértulo pari yohuani: ");
INSERT INTO kaqNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","—Mia copi ta noquen caibo siripi jihuetihqui, Félix hapon. Mia tah min hihti siri qui. Mian yohihah ta pontejaquin sca shinanxon nea noquen caibo coirancaniqui. Jatihibi janinxon tah non jatihibijaquin, Min tah min noque hahxonai, hahcai, mia yohiquin. ");
INSERT INTO kaqNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Jaabi tah hen mia hashoan jatsanjacatsihyamaxon hen mia pishca yohicatsihqui. Siri joni hihxon min hahcai quescajaquin hea nincarohahue, hen mia yohinon. ");
INSERT INTO kaqNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nea joni ta hisin pahe quescapah qui. Non tah non honanscai. Jatihibi main jihuetai noquen caibo ta jaan rainyamamahiqui, noquen quiquin hapobo non potanon hihxon. Jaa ta nazareno joi chibanaibaan hapo qui. ");
INSERT INTO kaqNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Noquen Papa Diosen xobo rishtajahiton tah non jaa bichipiqui. 